﻿USE sofia;
DROP TABLE IF EXISTS sofia.zia_vpl;
CREATE TABLE zia_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zia_vpl WRITE;
INSERT INTO zia_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Emo kasa yero butunawe duwa Yesu Kristo nung Abrahamto Dawidira saisibuna nunato zo mene kasa yena, auna ungwe. ");
INSERT INTO zia_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham nung Isakara mfaung. Isaka nung Yakobora maung. Yakobo nung Yuda meta maingne auna maung. ");
INSERT INTO zia_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda nung Pereseto Zerara maung. Ai nunato awiya Tema. Perese nung Hesronna maung. Hesron nung Ramuna maung. ");
INSERT INTO zia_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramu nung Aminadapra maung. Aminadap nung Nasonna maung. Nason nung Salamonna maung. ");
INSERT INTO zia_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamon nung Boasira maung. Boasira ai awiya Rehap. Boasi nung Obedera maung. Obedera ai awiya Ruti. Obede nung Zesira maung. ");
INSERT INTO zia_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Zesi nung emo tuwa Dawidi auna maung. Dawidi nung Solomonna maung. Solomonna ai awiya Yurayara bauno noi. ");
INSERT INTO zia_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon nung Riaboamna maung. Riaboam nung Abaisara maung. Abaisa nung Asara maung. ");
INSERT INTO zia_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa nung Yeosofatra maung. Yeosofat nung Yoramuna maung. Yoramu nung Usayara maung. ");
INSERT INTO zia_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaya nung Yotamuna maung. Yotamu nung Ahasira maung. Ahasi nung Hesekayara maung. ");
INSERT INTO zia_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaya nung Manasara maung. Manasa nung Amosira maung. Amosi nung Yosayara maung. ");
INSERT INTO zia_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosaya nung Yekonaya metamani nuna aune auna maung. Be aune Yuda emora iwo mene awong bunero puro baung tawing Babilon auna yewa. ");
INSERT INTO zia_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Awong puro baung Babilon yewa aune Yekonaya nung Siatielira maung. Siatieli nung Zerababora maung. ");
INSERT INTO zia_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerababo nung Abiudura maung. Abiudu nung Elayakimna maung. Elayakim nung Azora maung. ");
INSERT INTO zia_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azo nung Zedokra maung. Zedok nung Akimuna maung. Akimu nung Eliudura maung. ");
INSERT INTO zia_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudu nung Eleasara maung. Eleasa nung Matanna maung. Matan nung Yakobora maung. ");
INSERT INTO zia_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo nung Yosefera maung. Yosefe nung Mariara yu ara. Ora Maria mene zo mani Yesu Sorao emo naname yazo nuna Kristo awiya puna. ");
INSERT INTO zia_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kasa yao awena awiya eyero kasa yero bumuwa era. Abrahamna una atu kasa yero butunawe duwa Dawidira una atu kasa yena, awiya kasa yao dubu awong 14 yewa. Ora Dawidira una atu kasa yero butunawe duwa iwo mene Yuda emo puro baung Babilon tawingna yewa awiya kasa yao dubu dekaongka deka aine 14 yewa. Ora be auna atu kasa yero butunawe duwa Kristo kasa yena awiya dekaongka deka aine kasa yero dubu 14 yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Kristo kasa yena auna susuwa awiya eyero mitiya era. Ai nuna Maria nung Yosefe eno sero gerewa nasani nauwato ara. Arata awongto oko tayao sero gerao gege gerewa newato Oweno mene tani putoungne yenu Maria mesa yena ara. ");
INSERT INTO zia_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ayero yenu yu gerao nuna Yosefe nung etutero nasani nauna, arare dubo nuna mene eyero kotuna, “Na nung saingtiro yangduwari nena. Nung ugaing yetiya auna na nung gera pugana meng goiye sero, saingtiro kora yero yangduwarinena.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ayero yari kotupunasani nenu Tuwara angelo zo mene nung eno atiyora atu kasa yero eyero sena, “O Yosefe, ning Dawidira sai, bauno gerao nina Maria pumari nasani kotung-katung oko yase. Bauno mesa yetiya awiya mani Owenona ara. ");
INSERT INTO zia_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mani emodi pumariniya nung amimene dubu nuna pasena nunae-una abena auna atu sorero pumariniya, aeno yazo nuna Yesu yause.” Angelo mene ayero sena ara. Yazo auna susuwa awiya Tuwa Bayau Sorao Emo ara. ");
INSERT INTO zia_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nona apakana kasa yena awiya porofete zo mene Tuwara bera ge eyero sena awiya me yaise kasa yena ara. ");
INSERT INTO zia_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Sana nigipu. Mani baunodi zo gitau emo zore oko tayao amimene mesa yero mani emodi pumariniya auna yazo nuna Emanuel ayero sarineya. (Ge naname una “Tuwa Bayau mene name aune dema noiya.”) ");
INSERT INTO zia_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosefe atiyo nenu Tuwara angelo mene ge nung eno sena, awiya nigiro giro seka yero iropuro ge diungno Maria puro witi garo nuna-una yena ara. ");
INSERT INTO zia_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Arata yu aro oko yao neteto aune mani emodi puna. Punu giro Yosefe mene mani yazo nuna Yesu yausena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herode mene emo tuwa yero nasani nauna be aune Yesu nung Betelehem nape Yudaya tawingna atu kasa yena. Kasa yenu aune wari wiwitinoiya auna ina tawing zora emo nigao bainane mene Yerusalem nape kasa yero atata yero sewa, ");
INSERT INTO zia_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Yuda emo, emo tuwa ninae mani wuire zo kasa yetiya awiya napo natu mitiye? Nae wari wiwitinoiya auna ina atu arasa nuna giro nuna-una koing gairo nung bowi yari sero butunenane.” ");
INSERT INTO zia_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ayero sewa emo tuwa Herode arita Yerusalem napo susuwa awong teng nigiro awang yero sopine yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ayero yero Herode mene Yuda emora pirisa babuze aune sao tauyao ge gipinao emo yausenu augaiwa atata yero sena, “Sorao emo naname awiya napo nauna atu kasa yaise sao ing?” ");
INSERT INTO zia_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ayero senu awong eyero sewa, “Betelehem nape Yudaya tawingna atu kasa yaise sao mitiya ara. Auna porofete zo mene Tuwa Bayaura bera ge eyero gaena era, ");
INSERT INTO zia_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Betelehem napo, Yudaya tawingna mitiya. Napo awiya Yudaya tawingna napo gitau yao auna wosao zo okowa. Napo auna atu gitau yao bainakama zo kasa yero Isreli emo dubu nana diya yero baingtariniya.” ");
INSERT INTO zia_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ge awiya sewa nigiro Herode mene emo nigao bainane amaze nuna-una opene baese yau senu nuna-una bumuwa ara. Nuna-una bumuwa arasa awiya be noune kasa yeni auna susuwa gari sero nung awong atata yenu sero baingtiwa gigina ara. ");
INSERT INTO zia_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Sewa giro awong Betelehem nape babaese sero eyero sena, “Niye baungno kaunete taungno giro buro na saya na deka ayero baungno koing gairo nung bowi yane.” ");
INSERT INTO zia_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Emo tuwa mene ayero senu nigiro bamuwa ara. Bautunewa arasa nunae-una tawingna atu gigiwa dekaongka amimene nagibo gitau yero bautunete garo mani mitina atu dopena ara. ");
INSERT INTO zia_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Arasa atu dopenu awong arasa giro yawa yawa bainakama yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ayero yero awong gare atu toiro mani ai nuna Maria aune awiya giro boma gaero nung bowi nasani maguro nunae waure awiya be apero gol aune nona boingsa sereyao aune nona sere iwaingne a dema puro nung eno pugaiwa ara. ");
INSERT INTO zia_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Arare Tuwa Bayau mene atiyore awong Herodera una kapetegairo babao awang senu nigiro nagibo zora bautunete tawing nuka nunae-una kasa yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Awong kapetegairo bautunewa Yosefe atiyo nenu Tuwara angelo zo mene nuna-una kasa yero tugata yero eyero sena, “Ning iropuro mani aire puro Izip tawingna baungno atu ge nana diya neupu. Noeno oko, Herode mene mani kaunete taungno dari siniya.” ");
INSERT INTO zia_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ayero senu Yosefe mene iropuro mani aire puro pingne tara yero Izip tawingna bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Awong baungno atu nawe duwa Herode magayena ara. Tani ayao kasa yenu aune ge porofete zo mene Tuwa Bayaura bera eyero sena awiya me yena, Mani nana Izip tawingna atu nenu yau sewang doro kapetegaina. ");
INSERT INTO zia_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Emo nigao bainane awong Herode etegairo nagibo ewe bamuwa, awiya Herode mene nigiro tini kapao baina puna. Ayero yero gorobo emo nuna senu baung Betelehem nape yero napo aune napo mamanikaka ziuno mitiwa auna mani emodidi dawang tani etobera atu wosiro bautuniya ayao amaze apakana dero aungkamore yewa. Awiya emo nigao bainane mene arasa kasa yaora be sewa nigina auna teng senu dewa mamagayewa. ");
INSERT INTO zia_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ayero yewa porofete Yeremia mene ge zo gitau eyero sena awiya me yena ara, ");
INSERT INTO zia_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Rema nape atu bewing kasa yariniya. Zi saore dubo minaore baina kasa yariniya. Bauno Reso mene mani mamani nuna eno zi sai onggo saya teng oko yariniya. Noeno oko, mani apakana aung yarineya. ");
INSERT INTO zia_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herode magayenu Yosefe Izip tawingna atu nasani atiyo nenu Tuwara angelo zo mene nuna-una kasa yero eyero sena, ");
INSERT INTO zia_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Mani daya magayaise sewa awong awiya magateya, arare ning iropuro mani aire puro kapete Isreli tawingna gaipu.” ");
INSERT INTO zia_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ayero senu giro Yosefe mene iropuro mani aire puro kapete Isreli tawingna gaiwa ara. ");
INSERT INTO zia_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kapetegairo Yosefe mene ge zo eyero nigina, “Akeleas nung maung nuna Herodera buro puro Yudaya tawingna emo tuwa yero niya ara.” Ge ayero nigiro baungno atu nao awang yena ara. Ayero yero atiyore ge zo nigiro giro Yudaya tawing yangdoro Galilaya tawingna baungna ara. ");
INSERT INTO zia_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ayero yero napo zo yazo nuna Nasarete atu baungno nasani nauna ara. Arare porofete mene ge Sorao Emo eno sewa awiya me yena ara. Ge awiya eyero mitiya era, Nung Nasarete emo ayero sarineya. ");
INSERT INTO zia_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yohane ge ou zayero suwao emo amimene Yudaya tawingna kasa yero eu yanawira atu nasani ge eyero tugata nasani nauna, ");
INSERT INTO zia_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Uritira mitoiya amimene nata Tuwa yero nariniya auna be butuniya, arare niye dubo darawa yepu.” ");
INSERT INTO zia_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ge porofete Yesaya mene sena awiya emo auna-una atu me yena. Ge awiya eyao era, Zo nung eu yanawira soma mani aungna atu wawa sero eyero siniya, “Tuwara nagibo kora yepu korosae.” ");
INSERT INTO zia_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohane mene taung wori nuna wo kamel tumiza mene gayao amaze puro wosogairo nasani nauna ara. Ayero yero wora aingso mene ipura geing yero diro nasani nauna ara. Ora nona minao nuna awiya pika ou koware amaze mininasani nauna ara. ");
INSERT INTO zia_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yerusalem napora emo bauno enata Yudaya tawingna emo bauno enata ou Yodan enabarata enabara emo bauno apakana nuna-una dowinasani nauwa ara. ");
INSERT INTO zia_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ayero yero pasena nunae keregairo yangdoti nauwa aune nung awong ou Yodan auna atu ge ou susunasani nauna ara. ");
INSERT INTO zia_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Arare Farisayo ta Sadukayo awong ge ou eno nuna-una kasa yewa giro nung awong eno eyero sena, “Yira mani awiso, niye pasenana abena kasa yariniya awiya awang yero daigaese awe mene niye eno sesiye? ");
INSERT INTO zia_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Niye dubo darawa yarineya auna teng me ninae-ina kasa yaise. ");
INSERT INTO zia_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ora taung puro wiwitinasani dubo ninae mene eyero oko sepu, ‘Nae Abrahamna saisibuna, arare Tuwa Bayau mene nae gera oko pugariniya.’ Na sana nigipu. Tuwa Bayau mene sari yero giro sai daba emimene Abrahamna saisibuna kasa yarineya ara. ");
INSERT INTO zia_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tuwa Bayau mene oto sosero i susuwara pugainu mitoiya. Arare i zo me iwaing oko iyao yai giro yetero au iyaora gariniya. ");
INSERT INTO zia_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Niye dubo darawa neya giro na ou gege mene niye ge ou susunena. Na emo wosao gege. Ora emo zo ago bariniya nung amimene zo emo putoung bainane ara. Putoung nuna mene putoung nana daigatiniya. Nune na daigatiniya, arare na emo wosao eyao mene te soga nuna dimao teng oko niya. Nune mene zo Oweno niye eno pugariniya. Nupema niye iyaora pugariniya. ");
INSERT INTO zia_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nung tapono wawong nuna mene initiniya. Puro buro wuit mozaora masira kasa yero iwe babaise sero wuit au bisira gariniya. Iwe babai wuit me awiya kora yero puro pu gare gariniya. Ora iwe zo iyao awao gege awinoiya auna augariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Be auna atu Yesu nung Galilaya tawing doro baung Yodan oura yero Yohane mene nung ge ou suwaise sena. ");
INSERT INTO zia_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Arare Yohane mene giginu teng oko yenu giro abena eyero sena, “Na eyao mene nono yanese buro sinesi? Nine na ge ou suwasa teng yariniya.” ");
INSERT INTO zia_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ayero senu Yesu mene ge abena eyero sena, “Ning yeme kotung-katung oko yase. Nao ge dimao buro apakana yanano teng iwaing yariniya.” Ayero senu Yohane mene ge nuna diuna. ");
INSERT INTO zia_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ayero ge ou suwenu Yesu mene Yodan ou doro wiwitinasani eyero gigina: Uriti be gausenu Tuwa Bayaura Oweno mene ni audubo ine yero wosiro nuna-una tame daungka yenu gigina ara. ");
INSERT INTO zia_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ayero yenu uritira atu ge zo eyero wosina, “Ning Mani nana. Ning yo diyang nana. Na ning eno yawa yawa nena.” Ge ayao wosina arauwa. ");
INSERT INTO zia_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Sanda Yesu etegaise Oweno mene Yesu yuno puro eu yanawira baungna. ");
INSERT INTO zia_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ayenu Yesu nung iya mume 40 ayao nona semini nasani nete meri magayena ara. ");
INSERT INTO zia_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Be aune etegaora maung kasa yero eyero sena, “Ning Tuwa Bayaura Mani me yai giro se daba amimene ma yai minase.” ");
INSERT INTO zia_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ayero senu giro Yesu mene abena eyero sena, “Aung ara. Noeno oko, ge gayao zo eyero mitiya, Minao taungna a gege mene emo bauno oko soremaise sao mitiya. Tuwa Bayaura una bera atu ge wowosinoiya amaze teng nigiti nasani iwaing narineya.” ");
INSERT INTO zia_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ayero senu Sanda mene Yesu yuno puro Tuwa Bayaura dang napo Yerusalem auna baungno ibu bainana enora pugainu witina ara. ");
INSERT INTO zia_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ayero yero nung eno eyero sena, “Ning Tuwa Bayaura Mani me yai giro etu sasero wosi. Ning eza oko yarinesa. Noeno oko, ge gayao zo eyero mitiya, Tuwa Bayau mene sai angelo dubu nuna mene ning diya yarineya. Ayero nasani te nina daba mene gayoiye sero, awong ning wawong mene soga nasani puro wosarineya.” ");
INSERT INTO zia_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ayero senu Yesu mene awang sero abena eyero sena, “Ora ge gayao zo dema eyero mitiya, Ning Tuwa Bayau nina amaze gaero gari oko yase.” ");
INSERT INTO zia_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ayero senu Sanda mene nung nupema yuno puro diri witiro baungno dodopinasani tawing sero-sero zamena-simena yao nunae amaze gipena. ");
INSERT INTO zia_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","A nasani eyero sena, “Boma gitira diro na bowi yarinesa, awiya na nona awiya apakana ning eno pugarinena.” ");
INSERT INTO zia_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ayero senu Yesu mene ge abena eyero sena, “Sanda, ning na yangdoro baung. Ge gayao zo eyero mitiya, Ning Tuwa nina Tuwa Bayau awiya bowi yase. Nung dekaongka gege sou yarinesa.” ");
INSERT INTO zia_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ayero senu Sanda mene nung yangdoro baungna ara. Sanda baungnu angelo dubu ena kasa yero Yesu kora yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yohane bunao gare pugaiwa mitinu Yesu mene auna bowi nigiro giro tawing awiya yangdoro Galilaya tawingna baungna. ");
INSERT INTO zia_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ayero yero Nasarete napo yangdoro Kapaneam napo maze zo mitao masi nuna yena ara. Napo awiya ou nazi nugu mitiya. Napo awiya Sebulonito Naftalira tawingna atu mitoiya. ");
INSERT INTO zia_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ayero baungno mitao masi yenu aune porofete Yesayara ge zo eyero mitiya awiya me yena, ");
INSERT INTO zia_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Tawing zo ou nazira ina mitoiya auna atu Sebulonito Naftalira saisibuna yero nowa. Tawing awiya ou Yodan deung enaba atu mitiya. Tawing auna yazo zo Galilaya. Emo Yuda oko mene atu kasa yero neya ara. ");
INSERT INTO zia_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tawing auna emo dubu mumena atu neya amimene waegao baina garineya. Magayao awang nasani mumena atu mitima nowa awena una atu waegao kasa yariniya. Yesaya mene ge ayero gaena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Be auna atu Yesu mene zayero uritira ge sinasani emo bauno eno eyero tugata nasani nauna, “Uritira mitoiya amimene nata Tuwa yero nariniya auna be nugu niya, arare niye dubo darawa yepu.” Ayero sinauna arauwa. ");
INSERT INTO zia_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Arare wari zore Yesu mene Galilaya ou nazira bage atu nete emo etobe metare tatore tauna ara. Zo Simon yazo nuna zo Petoro, aune meta nuna Anderea. Awongto wo pumao emo, arare awongto ou auna atu moga papati nasani newato tauna ara. ");
INSERT INTO zia_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Taungno awongto eno eyero sena, “Nito bungputo na ago yaeto. Na nito gipana emo pumaora emo yaeto.” ");
INSERT INTO zia_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ayero senu giro awongto moga nunato mena yangdoro buro nung ago yewato. ");
INSERT INTO zia_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Atu iropuro bautunete emo etobe awongto metare deka ayao ine nupema tauna ara. Yakobo meta nuna Yohane awongto Zebedira mani etobe ara. Awongto maung nunato Zebedi aune dema wangna atu mitasani moga nunae kora newato giro Yesu mene buro nung ago yaetose sena ara. ");
INSERT INTO zia_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nung awongto yau senu giro awongto maung wangna atu yangdoro nung ago yewato ara. ");
INSERT INTO zia_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu mene Galilaya tawing zipunasani Yuda emora yere ibu sero witiro ge tugata nasani uritira mitoiya amimene nata Tuwa yero nariniya auna Bowi Iwaing tugata nasani emo bauno yaya benaung giti puro nasani nauwa awiya kora yero nasani nauna ara. ");
INSERT INTO zia_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ayero naunu bowi nuna mene Siria tawingna teng yenu nigiro giro emo yaya-biyayare, emo iwae sorowe nunae-una mokora mitao, emo ena angzi apunao, arita ena asama yao amimene kara iropuro nuna-una bamuwa kora yero aung yena ara. ");
INSERT INTO zia_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ayero yenu Galilaya tawingna, Dekapolis tawingna, Yerusalem napora, Yudaya tawingna, Yodan deung enabara emo bauno dubu bainakama amimene nuna-una au dekaongna gairo nung ago nasani nauwa arauwa. ");
INSERT INTO zia_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu mene emo bauno dubu baina awiya giro diri witiro adungno mitinu buro-mani nuna mene nuna-una nugu bamuwa aune ");
INSERT INTO zia_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","nung ge eyero sinasani emo bauno tugata yena ara. ");
INSERT INTO zia_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Emo dubo nunae gosinowa wowosinoiya awong amimene yawa yawa yaese. Noeno oko, awong uriti napo auna gerao. ");
INSERT INTO zia_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Emo dubo mininasani mitowa awong amimene yawa yawa yaese. Noeno oko, Tuwa Bayau mene dubo nunae kora yai awong iwaing yarineya. ");
INSERT INTO zia_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Emo yazo nunae puro wowosinowa awong amimene yawa yawa yaese. Noeno oko, awong Maung nunae-una tawing apakana pumarineya. ");
INSERT INTO zia_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Emo pewayero nari sero merire maganonane ayao ine yero nowa amimene yawa yawa yaese. Noeno oko, awong pumaya teng yariniya. ");
INSERT INTO zia_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Emo ao-diyaore yero nowa amimene yawa yawa yaese. Noeno oko, Tuwa Bayau mene awong ao-diyariniya. ");
INSERT INTO zia_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Emo dubo etore oko, dubo dekaongka yero nowa amimene yawa yawa yaese. Noeno oko, awong Tuwa Bayau garineya. ");
INSERT INTO zia_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Emo mono kasa yaise buro yero nowa amimene yawa yawa yaese. Noeno oko, awong awiya Tuwa Bayau mene ‘emodi baunodi nana’ ayero sariniya. ");
INSERT INTO zia_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Emo ena nao pewayaore yero nowa giro ena mene awong dedunasani buninasani ayero nowa amimene yawa yawa yaese. Noeno oko, awong uriti napora gerao. ");
INSERT INTO zia_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Niye dubu nana yero naya giro emo ena mene ge iwinasani yazo ninae puro wowosi nasani niye dero tuninasani ge memeko-mameko niye eno sarineya, awiya niye yawa yawa yepu. ");
INSERT INTO zia_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ayero yaya niye dubo iwaing nasani yawa yawa yepu. Noeno oko, niye uritira atu zuma baina pumarineya. Porofete gitau nasani nauwa awong awiya deka ayero dero tuninasani nauwa. Porofetera te weso nunae maze ago nasani nowa, aeno yawa yawa yepu. ");
INSERT INTO zia_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Wo seka mitete gung yoiye sero, emo wo puro biyoung mene susunowa nimoi-namoi iwaing mitoiya, deka ayero niye tawingna emo bauno apakana awena una towang atu biyoung ine yero nowa ara. Ora biyoung perusa yariniya, awiya name nono yanane aune mapu nuna nupema kasa yariniye? Aung ara. Biyoung perusa yao awiya meko ayero sero augatinowa emo mene papatinowa. ");
INSERT INTO zia_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Niye emo bauno apakana auna waegao ine. Napo zo diri tame daung mokera mitai nona zo mene oko worariniya. ");
INSERT INTO zia_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ora name damana gaero au apero mokora pugairo oko wopunonane. Awiya mitao masi nuna-una atu pugati nonane emo bauno garo mokora mitowa awiya teng waegati noiya. ");
INSERT INTO zia_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Arare waegao ninae mene deka ayero emo baunona una towang atu waegaise. Ayero yai awong nao ninae gaya iwaing yai Maung ninae uritira mitoiya awiya bowi yarineya arauwa. ");
INSERT INTO zia_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Niye na eno eyero saneya, ‘Nung sao tauyao ge Mose mene gaena aune porofetera ge awiya disari buna.’ Na eno ayero zo oko sae. Ge awiya aung yaise oko, me yaise kasa yewang ara. ");
INSERT INTO zia_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Na memokoba sane. Uritire tawingne mitarineyato teng Mosera sao tauyao ge deka ayero mitariniya ara. Ayero nasani Mosera sao tauyao ge agegewa dekaong-dekaong awiya dema mitete oko aung yariniya. Awiya me gege yero aune aung yariniya ara. ");
INSERT INTO zia_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Arare emo zo mene Mosera sao tauyao ge maingkoka nibamu zo daigati nasani ena mene deka ayero yaese sariniya, awiya uritira mitoiya amimene nata Tuwa yero nariniya be aune emo amimene emo wosao nibamu yariniya. Ora zo mene dipunasani ena deka ayero yaese sariniya, nung awiya uritira mitoiya amimene nata Tuwa yero nariniya be aune emo baina yariniya. ");
INSERT INTO zia_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Arare sana nigipu. Niye sao tauyao ge gipao emo aune Farisayo auna etutero nao nunae oko daigao yarineya, awiya niye uriti mokora oko towarineya. ");
INSERT INTO zia_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Aya ewowo naname eno ge zo eyero sao ara, ‘Ning emo oko dasa magayae. Zo nung mani dai magayariniya, nung awiya ge burora gerao yariniya.’ ");
INSERT INTO zia_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Arata nane mene zo niye eno eyero tugata nena ara: Zo nung otao nuna eno tini kapao pumariniya, nung amimene ge burora gerao yariniya. Zo nung otao nuna eno ‘Ning mani meko nibamu’ ayero sariniya, nung emo gitau yao dubura augao auna gerao yariniya. Zo nung otao nuna eno, ‘Ning dau dubo siwingyao’ ayero sariniya, nung awiya soma mekora baungno iyaora gerao yariniya. ");
INSERT INTO zia_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Arare ning aitara dopero nona zo Tuwa Bayau eno pugari sero nasani aune eyero kotumarinesa, ‘Otao nana aune dubo meko nanato mitiya.’ ");
INSERT INTO zia_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ayero sero nona nina demese pugasa mitai ning baungno otao nina aune ge kora yero aune kapetegairo nona nina aitara pugase. ");
INSERT INTO zia_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ning zazra una baungno ge buro yasese saya giro oko kasa yaore nagibe atu nasani aune emo ning gera pugatiniya aune ge mena kora ye. Ayero oko yao yasa iwo nina mene ning mena zazra una pugairo susuwa nina sai zaz mene gorobo emo nuna eno sai, ning bunao gare pugariniya. ");
INSERT INTO zia_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Na meba sane. Ning ayero mitete tebeba oko kasa daung yarinesa. Otao nina-una abena pugasa aung yero baingtai aune ning kasa daung yarinesa arauwa. ");
INSERT INTO zia_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Aya ewowo naname eno ge zo eyero sao ara: ‘Ning kuma oko yase.’ ");
INSERT INTO zia_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Arata nane mene zo niye eno eyero tugata nena ara. Emo zo mene bauno zo giro dubo-dubo yariniya, awiya nung bauno aeno dubo mene kuma yetiya ayero yariniya. ");
INSERT INTO zia_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Arare diti moko nina zo mene pasena yasese yai giro diti moko awiya zokero augarinesa. Taung nina zere-tutupore puro nasa soma meko iyaore auna atu augaya babosi sero saineba diti moko nina zo gera ye. ");
INSERT INTO zia_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ora wawong me nina mene ning pasena yasese yai giro wawong awiya kapero yangdo. Taung nina zere-tutupore puro nete soma meko iyaore auna atu babosi sero, saineba wawong nina zo gera ye. ");
INSERT INTO zia_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Aya ewowo naname eno ge zo eyero sao ara: ‘Zo nung bauno nuna yangduwari yero giro bauno yangduwaora igi nung eno pugairo aune bauno iyengtai babaise.’ ");
INSERT INTO zia_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Arata nane mene zo niye eno eyero tugata nena ara. Zo nung bauno nuna kuma oko yao amaze tebeba yangduwariniya, awiya nung bauno nuna kuma bauno yaise yariniya. Ora bauno mene kuma yariniya, awiya emo nung dotinasani pasena oko dimariniya. Zo nung bauno emo zo mene yangduna awiya atariniya amimene kuma yariniya. ");
INSERT INTO zia_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Aya ewowo naname eno ge zo eyero sao ara, ‘Ning Tuwa Bayaura benaungna sao tauyao ge nina awiya ge oko iwase. Sao tauyao ge sero giro Tuwara benaungna diung me yae.’ ");
INSERT INTO zia_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Arata nane mene zo niye eno eyero tugata nena ara. Ge zo sasa emo bauno gaya me yaise sero nona zora yazo yausero oko sase. Uritira yazo yausero sao tauyao awiya eyao eno yangduwaese sinena. Uriti napo awiya Tuwa Bayaura mitao-masi. Arare ning uritira yazo yausarinesa, awiya Tuwa Bayaura yazo dema yau sarinesa ayero yariniya ara. ");
INSERT INTO zia_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Tawingna yazo awiya yausero sao tauyao awiya dema eyao eno yangduwaese sinena. Tawing awiya Tuwa Bayaura te guto yao ara. Arare tawingna yazo yausarinesa, awiya Tuwa Bayaura yazo dema yausarinesa ayero yariniya ara. Yerusalem napora yazo yausero sao tauyao awiya eyao eno yangduwaese sinena. Yerusalem awiya Tuwa bainana napo, arare napo Yerusalem yazo yausarinesa, awiya Tuwa Bayaura yazo dema yausarinesa ayero yariniya ara. ");
INSERT INTO zia_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ora ziyo ato ninae yausero sao tauyao awiya dema yangduwaese sinena. Noeno oko, niye giti ai ninae zo neyangyao awiya saya siwing yarinita? Ora giti ai siwing yao zo saya neyang yariniye? Awiya aung ara. ");
INSERT INTO zia_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Arare niye ge me sari yero giro “Yore” gege, o “Aung” gege ayero sepu. Ge ena susuuno sao awiya mekora maung auna una atu butunoiya. ");
INSERT INTO zia_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Aya ewowo naname eno ge zo eyero sao ara, ‘Zo mene diti moko nina gayai zokai giro abena gayasa zokae. Ora zo mene di nina dai bezai giro abena de bezae.’ ");
INSERT INTO zia_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Arata nane mene zo niye eno eyero tugata nena ara. Emo meko mene niye puro gera gaira yari saya taung aingso ninae oko sorepu. Nupema zo mene ning sowena dai giro enaba deka ayero gipe dae. ");
INSERT INTO zia_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ora zo mene ning gera pugairo taung wori nina zuma wosao awiya pumari sai giro mo uno awinao nina zuma bainane awiya dema nung eno pugai pumae. ");
INSERT INTO zia_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ora gorobo emo zo mene ning nona nuna diungno puro nagibo apungkaka babasese sai giro ning nona nuna diungno nagibo imoko kara baungputo. ");
INSERT INTO zia_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Deka aine zo mene nona zo eno isa sai giro pugai pumae. Ora nona nina zo tebeba puro nari sai giro awang oko sase. ");
INSERT INTO zia_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Aya ewowo naname eno ge zo eyero sao ara, ‘Ning otao nina kora ye, ora iwo nina zo iwo ye.’ ");
INSERT INTO zia_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Arata nane mene zo niye eno eyero tugata nena ara. Iwo ninae eno otao yepu. Niye dero tuninowa awiya awong eno Tuwa Bayau eno isa sepu. ");
INSERT INTO zia_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ayero yarineya, awiya niye Maung ninae uritira atu mitoiya auna mani me yero narineya. Nung amimene sinoi wari nuna mene emo iwaingne mekore apakana awiya waegairo aung yero noiya. Nupema wa awiya sinoi emo iwaingne emo nao mekore auna-una teng wowosinoiya ara. ");
INSERT INTO zia_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Emo bauno niye dubo bayao yero nowa awong aeno gege bayao yaya Tuwa Bayau mene nono yero niye gai iwaing yarinei? Nao awiya emo bauno uritira ge dotinowa amimene dema yero nowa ara. ");
INSERT INTO zia_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Niye otao mani ninae gege tairo naya aune nao ninae mene nono yero emo bauno enana nao awiya daigariniye? Diga awong deka ayero yero nowa. ");
INSERT INTO zia_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Arata niye mene zo uritira Maung ninae etutero noiya auna teng yero neupu. ");
INSERT INTO zia_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Niye Tuwara buro yanenese sao awiya teba emo bauno mene niye bowi yaese sero oko puro nae. Ayero yaya Maung ninae uritira atu mitoiya amimene nona iwaing niye eno abena oko pugariniya. ");
INSERT INTO zia_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ning emo mono pupunasani ena mene gaese to oko pisarinesa. Ge iwao emo awong me sao yero nowa amimene yere ibu enana atuta napo kakame atu emo mono pupunowa awiya ena mene giro awong emo yazore saese ayero yero nowa ara. Na ge me niye eno sinena era. Emo ena mene awong eno yawa yawa yero nowa amimene abena nunae noi aung yero noiya. Nete ago abena iwaing zo oko pumarineya. ");
INSERT INTO zia_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ayao ine oko yarinesa. Ning mono pupunasani bayao nina awiya pungyero nebu eno oko sase. ");
INSERT INTO zia_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ayero yasa mono iwaing nina pungyero mitariniya. Ayero yai Maung nina nona pungyao gosinoiya amimene abena iwaing ning eno pugariniya. ");
INSERT INTO zia_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Niye isa sari yero giro ge iwao emo awong me sao yero nowa aine oko yae. Awong yere ibu enana atuta kakame atu dopero isa saora tauyero nowa, awiya emo bauno mene awong giro bowi yaese nowa. Arare amimene abena nunae yero noi aung yero noiya ara. Nete ago abena iwaing zo oko pumarineya. ");
INSERT INTO zia_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Arata nine mene zo isa sari yero giro garo nina auna witiro garo be gazero aune Maung nina pungyero mitoiya aeno isa se. Ayero yasa Maung nina nona pungyao gosinoiya amimene abena iwaing ning eno pugariniya ara. ");
INSERT INTO zia_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Niye isa tebeba be mene gege oko sepu. Awiya diga mene yero nowa auna tani. Awong amimene ge gayang-gayangne isa sinanane Tuwa Bayau nigariniya ayero sero nowa ara. ");
INSERT INTO zia_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Arare niye tani nunae ine oko yepu. Maung ninae mene niye nung eno isa oko saore nona kau yero nowa awiya gosinoiya. ");
INSERT INTO zia_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Arare niye isa eyero sepu. O Mama nanae ning uritira atu mitosa, yazo nina dang mitaise. ");
INSERT INTO zia_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Bung, dubo sero tawing sero auna Tuwa nanae yase. Uritira atu ge nina dipunowa, aine tawingna etu nanae una atu kasa yaise. ");
INSERT INTO zia_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ma nae eno wari be sero pugatinosa awiya yeme pugai. ");
INSERT INTO zia_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pasena emo ena mene nae eno yero nowa awiya yangdotinonane, aine ning pasena nanae yangdo. ");
INSERT INTO zia_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nae etegaora atu oko pugase. Nae mekora atu sorero pung. Awiya me yaise. ");
INSERT INTO zia_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Niye emora pasena yangduwaya giro uritira Maung ninae mene pasena ninae deka ayero abena yangduwariniya ara. ");
INSERT INTO zia_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ora niye emora pasena puro naya giro Maung ninae mene pasena ninae deka ayero puro nariniya arauwa. ");
INSERT INTO zia_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Niye Tuwa Bayau eno nona semini nasani benaung ninae yayare mene yaine oko nasani nae. Ge iwao emo awong me sao yero nowa amimene ayero yero benaung nunae awetu suwero yero nowa. Awiya emo bauno ena mene awong seminiro neya auna susuwa gaese ayero yero nowa. Na meba sinena. Emo bauno mene awong eno yawa yawa yero nowa amimene abena nunae yero noi aung yero noiya. Nete ago abena iwaing zo oko pumarineya. ");
INSERT INTO zia_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Arata nine mene zo nona semini nasani benaung nina saero giti ai nina kisagairo neu. ");
INSERT INTO zia_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ayero yasa emo bauno mene semininesa awiya oko garineya. Maung nina pungyero noiya amimene nata gariniya. Ayero yero nung nona pungyao gosinoiya amimene abena iwaing ning eno pugariniya arauwa. ");
INSERT INTO zia_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Wau moni ninae awiya tawingna etu oko wori mene dowaya mitae. Tawingna wau moni awiya ziri mene dedunoiya, o kayai yero meko yero noiya, arita emo mene goma yauseuno ugaing pupunowa. Arare wau ninae tawingna etu oko wori mene dowae. ");
INSERT INTO zia_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Wau ninae awiya uritira atu wori mene dowepu mitae. Uritira wau moni awiya ziri mene dao ine teng oko, nupema kayai yao ine teng oko, nupema emo mene goma yauseuno ugaing pumao ine teng oko. Arare wau moni ninae awiya uritira atu wori mene dowepu mitae. ");
INSERT INTO zia_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Noeno oko, masi wau moni ninae mitoiya masi dekaongka auna atu dubo ninae mitariniya arauwa. ");
INSERT INTO zia_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Diti moko nina awiya taung nina auna waegao ara. Arare diti moko nina iwaing mitai aune taung aingso nina deka iwaing waegaore mitariniya. ");
INSERT INTO zia_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ora diti moko nina meko yai aune taung aingso nina deka ayero mume yariniya ara. Arare dubo nina deka ayao ara. Dubo nina mene mume yai, mume bainakama nina ina mitariniya. ");
INSERT INTO zia_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Mani dekaongka mene emo tuwa etobera una atu sou buro yai teng oko yariniya. Awiya nung zo otao nasani zo eno iwo yariniya. Arata nupema zo tumo didinasani zo eno bereya yariniya. Niye deka ayero Tuwa Bayau eno sou buro yao arita wau monina sou buro yao awiya etobe deka ayero yao ine teng oko arauwa. ");
INSERT INTO zia_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Arare na niye eno sana nigipu. Niye nao ninae eno kotung-katung nasani eyero oko sae, ‘Nona minao natu tamari nenine? Ou minao natu tamari nenine?’ Nupema niye taung aingso ninae eno kotung-katung nasani eyero oko sae, ‘Taung wori natu tamari nenine?’ Niye sepu. Nao ninae mene me ta nona mene me niye? Taung aingso ninae mene me ta taung wori ninae mene me niye? ");
INSERT INTO zia_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Niye ni mamani kotungno gipu. Awong buro uno yetero yero urinasanita wo dedunasani gainasani ayero oko mininowa. Awong nona minao oko gurutu yero nowa. Arata uritira Maung ninae mene saineba nona minao nunae tapunoiya ara. Awiya nono niye? Niye wosao nunae ing? Awiya aung ara. Arare nung nona iwaing niye eno pugariniya. ");
INSERT INTO zia_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ninae-una zo mene nao nuna eno kotung-katung nasani nete wari be ena nao nuna-una susuuno paka tame yai teng yarinita? Aung ara. ");
INSERT INTO zia_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Niye noeno taung wori more eno yanakana kotungkatung yero nowi? Niye i ware atu agiti bairo wuzi ditinowa auna susuwa awiya kotungno gipu. Awong asino aimaora buro oko yero nowa. Nupema awong mo gayaora buro oko yero nowa. ");
INSERT INTO zia_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Arata na niye eno sinena era. Gitau emo tuwa Solomon mene taung nuna sipunasani yero baingtiti nasani nauna, arata simao nuna yero nauna amimene i wuzira simao awiya oko daigaina. ");
INSERT INTO zia_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","I wuzi yeme ware atu iwaing ditiniya, arata gora emo mene wezero igiyarineya ara. Arata saineba, Tuwa Bayau mene sinoi simao iwaing kasa yero Solomonna simao iwaing awiya daigati noiya. Tuwa Bayau mene ayero yero noiya, arare nung noeno niye eno mo taung wori oko tamao yariniye? O tumo diyao besaore niye, nung niye eno mo taung wori iwaing-kawaing tamariniya. ");
INSERT INTO zia_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Arare niye kotung-katung nasani eyero yanakana oko sae. ‘No yero minari nenine? No puro minari nenine?’ ");
INSERT INTO zia_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Awiya diga mene kotumao nunae auna pugatinowa mitoiya ara. Niye nona awiya aung iwaing oko narineya, awiya uritira Maung ninae mene nigitinoiya ara. ");
INSERT INTO zia_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Niye dubo ninae puro pu uritira ge nuna arita nao pewayao nuna auna gaipu mitae. Ayero yaya nung auna tame nona apakana awiya pugai pumarineya. ");
INSERT INTO zia_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Arare yaya ago kasa yariniya auna kotung-katung oko yae. Gorara kotung-katung yao awiya gorara gerao gege. Wari be sero auna yaya tamao nuna mene gerao nuna mitai teng yariniya arauwa. ");
INSERT INTO zia_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Tuwa Bayau mene niye gera pugoiye sero, niye zaz mene yaine yero emo ena gera oko pugae. ");
INSERT INTO zia_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","No eno oko, emo gera pugati nasani ge sarineya, teng Tuwa Bayau mene niye eno abena sariniya. Ora niye nona emo eno pugarineya, teng Tuwa Bayau mene niye eno pugariniya. ");
INSERT INTO zia_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ning noeno otao nina-una diti mokora uzozoru mitiya awiya gosinasani nina-una diti mokora i zizaing mitiya awiya oko giro baingtao nesi? ");
INSERT INTO zia_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","I zizaing nina-una diti mokora mitai aune ning otao nina eno eyero sasa teng yarinita? ‘Nina ina diti mokora uzozoru mitiya awiya pumane.’ ");
INSERT INTO zia_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ge iwao emo me sao ine yero nowa, nina ina diti mokora i zizaing mitiya awiya gitau puro aune giro baingtiti nasani otao nina auna diti mokora uzozoru pumasa teng yariniya ara. ");
INSERT INTO zia_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Niye uritira ge auna nona awiya sino eno oko pugae. Nupema simao wau onone ninae me awiya pu eno oko augairo yangduwae. Ayero yaya awong nona ayao ine awiya te mene patiro aune mena kapete gairo niye gamaneya. ");
INSERT INTO zia_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Niye Tuwa Bayau eno isa sinete aune pumarineya. Niye tamaora buro yero nete aune me tamarineya. Niye isa ninae mene garo be daine yero nasani naya Tuwa Bayau mene nigariniya. ");
INSERT INTO zia_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Emo bauno isa sinowa amimene pupunowa. Emo bauno tamaora buro yero nowa amimene me tapunowa. Emo bauno isa mene garo be daine yero nowa auna isa awiya Tuwa Bayau mene nigitinoiya. ");
INSERT INTO zia_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ora ninae una awe mene mani nuna ma eno sai daba pugariniye? ");
INSERT INTO zia_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Arita wo eno sai yi pugariniye? ");
INSERT INTO zia_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Aung ara. Niye emo memeko-mameko mene mani awiso ninae aeno nona iwaing pugatinowa ara. Arare eyero gosinonane ara: Maung ninae uritira mitoiya auna bayao mene tawing emora bayao awiya daigatinoiya, aeno nung emo bauno isa sinowa awong eno nona iwawaing-kakawaing witao pugariniya. ");
INSERT INTO zia_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Niye nao emo mene niye eno yaese arataungno yero nowa teng ayao ine awong eno yepu. Ayero yaya aune sao tauyao ge apakana arita porofetera ge apakana gaewa awiya teng dipunowa ayao ine yariniya. ");
INSERT INTO zia_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Niye nao mera towao-be maingkoka auna toipu. Gera yao napo auna towao-be awiya bainakama. Nupema nagibo nuna dema bainakama. Auna emo bauno daigairo mene bautu nasani nowa ara. ");
INSERT INTO zia_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nao mera napo auna towao-be awiya maingkoka. Nupema nagibo nuna dema taung dao bainane. Arare emo bauno agi okoka mene gege tapunowa arauwa. ");
INSERT INTO zia_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ge gipao emo ge iwao awong sao nunae awiya lamana ine, dubo wosao gege. Arata moko nunae mene zo sinona moko ine, gorobo moko. Arare awong umo yero baingtiti nasani neupu. ");
INSERT INTO zia_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ge nunae-una me awiya giro aune susuwa nunae garineya. Pura mene biye zuwero iyarinita? Arita masao mene ona zuwero iyariniye? ");
INSERT INTO zia_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Aung ara. I iwaing awiya me iwaing itinoiya. I meko awiya me meko itinoiya. ");
INSERT INTO zia_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","I iwaingna atu me meko kasa yao ine teng oko ara. Nupema i mekora atu me iwaing kasa yao ine a deka teng oko ara. ");
INSERT INTO zia_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Arare i zo me iwaing oko iyao yai giro kapero au iyaora garineya ara. ");
INSERT INTO zia_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Susuwa ayero mitiya, arare niye ge nunae-una me awiya giro aune susuwa nunae garineya. ");
INSERT INTO zia_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Emo mene na eno “Tuwa nana, Tuwa nana,” ayero sero nowa awong teng apakana uritira mokora oko towarineya. Mama nana uritira mitoiya auna ge dipunowa awong amimene gege towarineya ara. ");
INSERT INTO zia_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Emo daigairo mene be bainana atu na eno eyero sarineya, “O Tuwa nanae, nae be nina-una Tuwa Bayaura ge porofete mene saine yewangne. Ora be nina-una iwae tunewangne. Ora be nina auna buro baina yewangne.” ");
INSERT INTO zia_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ayero saya na awong eno eyero sarinena, “Na niye zo za nibamu oko gosinona. Doro zanepu aung yae, pasena emo niye.” ");
INSERT INTO zia_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Emo zo mene ge nana ewiya nigiro dimariniya, nung awiya emo nigao bainane. Nung emo zo garo nuna-una ziwong kote me wauno pugainu dopena ayao ine ara. ");
INSERT INTO zia_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ayero yenu mitinu wabamu baina denu garo tau yero mitina ara. Garora ziwong mutero baingtinare, aeno tau yero mitina ara. ");
INSERT INTO zia_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ora emo zo mene ge nana ewiya nigiro yangduwariniya, nung awiya emo darabi mene yaine garo ziwong tame paka yena, ayao ine yariniya. ");
INSERT INTO zia_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ayero yenu mitinu wabamu baina denu garo gisena ara.” ");
INSERT INTO zia_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu mene ge awiya sinete sero aung yenu emo bauno awong ge nuna dina awiya nigiro wawong di gamuwa. ");
INSERT INTO zia_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Awiya noeno oko, nung gera susuwa mene ge diro baingtina. Awiya sao tauyao ge gipao emo awong ge gipinasani nauwa, awiya yangdoro daigairo putoungne sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu mene diri atu wowosinenu emo bauno dubu baina amimene nung ago yero ");
INSERT INTO zia_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","wowosinewa emo zo bozo tauyaore mene Yesura benaungna baungno nugu atu boma gaero koing gairo eyero sena, “Tuwa, ning putoung nina mitiya, arare ning na kora yari yero giro kora yasa iwaing yarinena.” ");
INSERT INTO zia_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ayero senu Yesu mene wawong pugairo taung nuna dingyero eyero sena, “Na ayero yari kotupunena, arare bozo nina soyaise.” Ayero sinenu bozo nuna mena soyewa taung nuna iwaing yena ara. ");
INSERT INTO zia_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu mene ayero yero nung eno eyero sena, “Tani ning eno yetena auna bowi awiya emo zo eno oko sase. Ning baung, taung nina awiya pirisa eno gipasa gae. Ayero nasani nona Mose mene Tuwa Bayau eno pugasese sena awiya pugasa yaya nina aung yetiya auna susuwa giro baingtarineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu mene Kapaneam nape baungno atu nenu Romana gorobo emora gitau yao zo mene nuna-una kasa yero nung yausero eyero sena, ");
INSERT INTO zia_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Tuwa, soumani nana yaya mou-mesa yao puro gare atu apegairo mitiya.” ");
INSERT INTO zia_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ayero senu Yesu mene abena eyero sena, “Na buro kora yarinena.” ");
INSERT INTO zia_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ayero senu gorobo emora gitau yao mene ge abena eyero sena, “Tuwa, na emo iwaing oko. Arare ning garo nana-una towasa teng oko yariniya. Aeno ning etu mitasani aune ge gege sasa soumani nana iwaing yariniya. ");
INSERT INTO zia_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Awiya gosinena, noeno okowata, na emo babuze ago yero nona. Nupema na gorobo emo enana gitau yao. Arare nunae-una zo babaise sana babariniya, arita zo baise sana bariniya. Aine soumani nana buro yaise sana yariniya. Arare ning etu mitasani ge gege sasa soumani nana iwaing yariniya, awiya gosinena.” ");
INSERT INTO zia_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ayero senu Yesu mene ge awiya nigiro wawong di gauno emo dubu nung ago nasani newa aeno eyero sena, “Na ge me niye eno sinena. Isreli emo ninae-una atu emo zo tumo diyao eyao ine zo oko tamuwang. ");
INSERT INTO zia_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Arare eyero tugata yana nigipu. Wari wosaorata witaora atu emo Yuda oko daigairo mene kasa yero Abraham Isaka Yakobo awong aune dema uriti mokora atu augairo ana-bonene yero adungno mininasani yawa yawa yarineya. ");
INSERT INTO zia_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Arata emo uriti mokora gerao nunae mene zo mumena baungno zi irare barare sinasani mitarineya.” ");
INSERT INTO zia_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ayero sero gorobo emora gitau yao eno eyero sena, “Ning baung, tumo diyao nina-una me kasa yariniya.” Ayero senu soumani nuna be dekaongka aune iwaing yena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu mene Petorora una gare witiro imeti nuna yaya taung kokoni yao puro mitinu gigina ara. ");
INSERT INTO zia_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Giro wawong nuna ininu yaya bisi sena. Ayero yenu bauno awiya iropuro Yesura nona sainu miniwa ara. ");
INSERT INTO zia_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ture inu emo bauno iwae sorowe mokora mitao daigairo puro bumuwa ara. Ayero yewa Yesu mene iwae sorowe nunae be nuna mene tunena ara. Ayero nasani emo bauno yayare apakana kora yena ara. ");
INSERT INTO zia_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ayero yenu porofete Yesaya mene ge zo eyero gaena awiya me yena. Nung yaya naname kora yai iwaing yarinenane. Nupema, nung mouyao naname dimariniya. ");
INSERT INTO zia_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Emo bauno daigairo mene Yesura una kasa yero nung zimuwa giro buro-mani mene nung puro dawero ou nazi deung enaba atu pugaese sena. ");
INSERT INTO zia_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Arare babari sero nenu sao tauyao ge gipao emo zo mene nuna-una nugu buro eyero sena, “Gipao emo, ning natu natu babarinesa awiya na teng ning ago yarinena.” ");
INSERT INTO zia_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ayero senu Yesu mene abena nung eno eyero sena, “Wo niniyang awong awao masire. Nupema ni mamani deka ayero awong paungne. Arata na Emora Mani mene zo niya-koma apegairo oregao aungware keusuma nasani nona. Arare ning mena na ago yari oko sase.” ");
INSERT INTO zia_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ayero senu nunae-una dubura zo mene nung eno eyero sena, “Tuwa, ning nigasa na gitau mama nana magayai mutero aune na ning ago yane.” ");
INSERT INTO zia_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ayero senu Yesu mene abena eyero sena, “Ning na ago ye. Emo ititi aung mene yaine yero nowa amimene magayao emo mutaese.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ayero sero wangna witinu buro-mani nuna witiwa aune bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bautunewa bisi mena buro wito gaenu kakawa iropuro bainakama yenu wito wang mokora toina. Be awiya Yesu nung auriti awinena ara. ");
INSERT INTO zia_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Arare buro-mani nuna mene baungno uwero eyero sewa, “Tuwa, nae soreung. Name kara nosero tura babari sero nenane.” ");
INSERT INTO zia_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ayero sewa giro eyero sena, “Tumo diyao ninae baina oko. Niye noeno awang nei?” Ayero sero iropuro kakaware bisire gona yenu soma bisi binono dena ara. ");
INSERT INTO zia_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ayero yenu emo mene giro wawong di gauno eyero sewa, “Emo ewiya noiye? Nona apakana aune bisire kakaware dema ge nuna nigitinei?” Ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu mene ou nazi buwagairo Gadara emora tawing auna kasa yena ara. Kasa yenu emo etobe biritira atu buro nung tamuwato ara. Iwae sorowe nunato una mitauwa awongto gorobo baina yero nasani nauwato emo ena mene awang yero nagibo auna buro baungno oko yao yero nasani nauwa ara. ");
INSERT INTO zia_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Arare awongto wawa sero eyero sewato, “Ning Tuwa Bayaura Mani mene nato eno no yari butunesi? Ning be baina oko kasa yaore yaya buro nae eno pugari butunesita?” ");
INSERT INTO zia_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Be aune pu witao amimene ake ina atu nona mininasani mitiwa. ");
INSERT INTO zia_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Arare iwae sorowe mene isa sinasani Yesu eno eyero sewa, “Ning nae tunari yero giro sasa pu dubu ouna-una mokora towanene.” ");
INSERT INTO zia_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ayero sewa giro nung awong eno eyero sena, “Niye baungpu!” Ayero senu awong emo etobe yangdoro baungno pu dubu newa auna-una mokora toiwa ara. Ayero yewa pu apakana yanakana sungno kowara baungno ou nazira gutero ou miniro mamagayero aung yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ayero yewa pu diya newa awong dema zanewa ara. Zanero baung napo bainana yero ge ungwe awiya apakana keregairo sero aung yewa ara. Awong tani emo etobera una kasa yena auna ge ungwe awiya yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ayero sewa giro napo bainana emo bauno awong apakana iropuro Yesu tamari bamuwa. Awong buro nung giro nung eno ge tau tataware yao sinasani nung tawing nunae yangdoro babaise sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu mene wangna witiro ou nazi nupema buwagairo napo nuna-una baungna. ");
INSERT INTO zia_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Baungno kasa yenu emo zo te-wawong gimao awiya gogara pugaiwa apegairo mitinu diungno puro bumuwa ara. Ayero yewa Yesu mene tumo diyao nunae-una susuwa giro emo asama yao eno eyero sena, “Mani nana, ning awang oko yase. Tau ye. Pasena nina disero aung nena era.” ");
INSERT INTO zia_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ayero senu Yudara sao tauyao ge gipao emo ena awong dubo nunae mene eyero kotumuwa, “Emo emimene Tuwa Bayau mene yaine niya.” ");
INSERT INTO zia_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ayero kotupunewa Yesu mene kotumao nunae giro aung yero eyero sena, “Niye noeno ge meko kotupunei? ");
INSERT INTO zia_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Name emo yayare aeno ‘Iropung, ang yase’ tebeba ayero sanane nung oko ang yao yariniya, awiya name meng garinenane. No eno oko, emo bauno mene ge naname gaya ge iwao yariniya. Arata name ‘Na pasena nina disinena’ tebeba ayero sarinenane, awiya name meng oko garinenane. No eno oko, emo bauno mene ge naname auna me awiya gao ine teng oko. ");
INSERT INTO zia_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Arare na pasena disaora putoung puro tawingna etu nona awiya gaese sero na ge ewiya dema nung eno sarinena: Na ning eno eyero sinena, Iropuro awao masi gogare nina puro baung nina gare yase.” ");
INSERT INTO zia_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ayero senu emo awiya iropuro nuna nape baungna ara. ");
INSERT INTO zia_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ayenu emo dubu baina amimene tani awiya giro awang yero Tuwa Bayau nung putoung ayao zo emora waweng pugaina, awiya giro nung bowi yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu mene atu iropuro bautunete takis pumao emo zo yazo nuna Matiu nung takis pumaora gare atu mitinu giro nung eno eyero sena, “Ning bung na ago yase.” Ayero senu giro iropuro nung ago yena ara. ");
INSERT INTO zia_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ayero yero nung Yesu garo nuna-una atu nona minaise senu witinu aune takis pumao emo aune Yudara sao tauyao ge dao emo daigairo amimene kasa yero Yesu buro-maine aune dema tairo nona miniwa ara. ");
INSERT INTO zia_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ayero newa Farisayo mene awong giro buro-mani nuna eno eyero sewa, “Gipao emo ninae mene noeno takis pumao emo aune Yudara sao tauyao ge dao emo aune dema mitasani nona mininei?” ");
INSERT INTO zia_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ayero sewa ge awiya Yesu mene nigiro abena eyero sena, “Emo yaya aung mene doktara una oko bautunowa. Arata emo yayare gege mene doktara una bautunowa. ");
INSERT INTO zia_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Niye baungno ge gayao eyero mitiya auna susuwa kotungno gipu. Na Tuwa Bayau mene niye zawing pugaese oko ara tapunona. Niye mono pumaese aratapunona. Na emo nao nunae pewayao sinowa awiya yausari sero oko bumuwang. Arata na emo pasena nao awiya yausari bumuwang.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Be auna atu Yohanena buro-mani mene Yesura una kasa yero nung atata yero sewa, “Nae aune Farisayo aune nae nona minao semini nasani yero nonane, arata buro-mani nina mene zo awong noeno nona oko seminao yero nowi?” ");
INSERT INTO zia_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ayero sewa Yesu mene awong eno abena eyero sena, “Emo bauno ataora sao zuwao nasani mitaya emo nung bauno atariniya amimene awong aune dema nariniya be aune awong dubo mininasani nona seminaese saya nigarineita? Aung ara. Ora ago emo awiya iwo mene puro babaya aung yariniya be aune awong nona seminarineya. Deka ayao ine na eno yaya aune buro-mani nana mene nona seminarineya. ");
INSERT INTO zia_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Name mo toto worero gayari sero mo be sekawa puro mo asora oko gainonane. Ayero yari nenane, awiya mo sekawa mene watimai mo aso nupema kerai toto bainakama yariniya. ");
INSERT INTO zia_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Name ou wain sekawa puro meme aingso matura oko sukupunonane. Ayero yarinenane, awiya ou wain mene daing yero meme aingso inai kerai ou wain meme aingsore awiya gera gaira yarinenane. Name ou wain sekawa puro meme aingso sekawara sukupunonane. Ayero nonane ou wain sekaware meme aingso sekaware awongto kara iwaing mitowato ara.” Ayero sena. Ge eniya awiya tebeba oko sena. Awong susuwa ewiya gaese sero sena: Nung nao sekawa auna ge sinauna, arare buro-mani nuna mene Yudara tani matu awiya yangdoro tani sekawa gege puro narinenane ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu nung ge awiya sinasani mitinu yere ibu diya emo zo mene nuna-una buro benaungna atu koing gairo eyero sena, “Mani nana baunodi yeme magayetiya, arata ning puro babana wawong nuna-una tame pugasa iropariniya.” ");
INSERT INTO zia_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ayero sero baungnu Yesu mene iropuro buro-mani nuna aune emo awiya ago yero bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Bautunewa bauno zo yu pupunasani nawe dunu dawang 12 ayao yena amimene Yesura una ame baungno Yesura taung wori tera atu ding yena ara. ");
INSERT INTO zia_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ayero nasani nuka nutope eyero kotuna, “Taung wori nuna gege ding yero iwaing yarinena.” ");
INSERT INTO zia_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ayero kotungno ding yenu Yesu mene kapetegairo bauno giro eyero sena, “Aya nana, ning oko awang yase. Ning tumo diyao nina mene iwaing yetesa.” Ayero sinenu bauno awiya mena iwaing yena ara. ");
INSERT INTO zia_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ayero yenu Yesu mene bautunete diyara gare witiro bui pisao emo aune emo bauno dubu bainane amimene zire buware nasani mitiwa giro eyero sena, ");
INSERT INTO zia_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Niye kasa yero bungpu! Mani baunodi awiya nung oko magayao. Nung auriti awiniya.” Ayero senu awong nung izewa ara. ");
INSERT INTO zia_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ayero yewa nung senu wosiro aung yewa mani magayao mitina auna-una baungno mani baunodi awiya wawong ininu iropuna ara. ");
INSERT INTO zia_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ayero yena auna ge bowi mene tawing auna atu daure gairo teng yero baungna arauwa. ");
INSERT INTO zia_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu mene atu iropuro bautunenu emo diti guma yao etobe mene nung ago yero yausinasani eyero sewato, “O Dawidira sai, ning nato eno yo-amase.” ");
INSERT INTO zia_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu bautunete gare witinu awongto nuna nugu baungno kasa yewato ara. Nuna-una kasa yewato giro Yesu mene awongto atata yero sena, “Diti moko kora yaora putoung nana-una mitiya ayero sero gigeyato me yeti bumeitota?” Ayero senu awongto sewato, “Yore, Tuwa. Gigenato me niya.” ");
INSERT INTO zia_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ayero sewato giro nung diti moko nunato dingti nasani eyero sena, “Tumo diyao ninato auna me mene ninato ina kasa yaise.” ");
INSERT INTO zia_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ayero senu diti moko nunato pagaina ara. Ayero yenu Yesu mene awongto eno sao tauyao ge eyero pugaina, “Nito tani auna ge bowi emo ena eno oko saeto.” ");
INSERT INTO zia_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ayero sena, arata awongto doro baungno ge bowi nuna sero sero yewato tawing auna teng yena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yesu buro-mani nuna aune atu iropuro bautunewa emo zo puro Yesura una bumuwa ara. Iwae sorowe zo nuna-una mitaunu ge aung nasani nauna. ");
INSERT INTO zia_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Arare Yesu mene iwae sorowe tunenu baungnu emo awiya ge sena ara. Ge senu emo dubu baina amimene wawong di gauno eyero sewa, “Isreli tawingna etu gitau nona ayao ine zo oko kasa yenu gigiwangne.” ");
INSERT INTO zia_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ayero sewa, arata Farisayo mene Yesu eno eyero sewa, “Iwae sorowera gitau yao mene nung sorepunoi iwae sorowe tunero noiya ara.” Ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Arare Yesu nung atu nasani napo bainata maingkoka awiya nung teng nasani nauna ara. Atu nasani yere ibu nunae sero toiro ge gipinasani Tuwa Bayau nata Tuwa yero nariniya auna Bowi Iwaing tugata nasani nauna ara. A nasani emo bauno yayare apakana kora yero naunu yaya nunae bisi sero aung yero nauna ara. ");
INSERT INTO zia_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Arare nung emo bauno dubu baina awiya giro awong eno yo amao tauna. No eno oko, awong lama dubu diya aung ine. Arare awong putoung aung dubo mininasani nauwa. ");
INSERT INTO zia_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Arare nung buro-mani nuna eno eyero sena, “Nona bure etu zauno mitiya, arata pumaora emo etoka gege. ");
INSERT INTO zia_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Arare niye pumao burora maung eno isa saya nung nona pumao emo tamai buro nuna-una babaese.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu mene buro-mani nuna 12 yau senu bumuwa iwae sorowe tunaora putoung aune yaya benaung giti korayaora putoung aune awiya awong eno pugaina ara. ");
INSERT INTO zia_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aposolo 12 auna yazo nunae awiya eyao era: Gitau yao Simon yazo nuna zo Petoro, meta nuna Anderea, Yakobo Zebedira mani, aune meta nuna Yohane, ");
INSERT INTO zia_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip aune Batolomiu, Tomas aune Matiu takis pumao emo, Yakobo Alifayora mani, aune Tadias, ");
INSERT INTO zia_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon Zelote aune Yudas Iskeriot nung nawe Yesu keregaina arauwa. ");
INSERT INTO zia_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu mene buro-mani nuna 12 awong awiya burora iyengtiti nasani eyero sena, “Niye emo Yuda okora una tawingna oko babae, arita Samaria napo auna dema oko babae. ");
INSERT INTO zia_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Isreli emo bauno dubu awong lama tara yetugao ine auna-una gege baungpu. ");
INSERT INTO zia_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Bautunasani ge eyero tugata yepu: Tuwa Bayau nata Tuwa yero nariniya auna be nugu niya. ");
INSERT INTO zia_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Atu nasani emo bauno yayare awiya kora yepu. Nupema mamagayao awiya dema uwepu. Ayero nasani bozore awiya kora yepu bozo soyae. A nasani iwae sorowe tunepu. Niye putoung awiya zuma aung tebeba pumeya, arare niye deka ayero buro awiya zuma aung yepu. ");
INSERT INTO zia_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Moni bainata moni mamanikaka awiya oko guguno puro babarineya. ");
INSERT INTO zia_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Niye nagibe atu zao oko desanegae. Taung wori etobe aung, o te soga sekawa zo aung, o tung zo aung, ayero neupu. No eno oko, buro emo awong nona zuma aung tebeba pugao minao gege ara. ");
INSERT INTO zia_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Arare napo zorata zora kasa yero giro gitau emo iwaing zo kau yepu. Ayero yero zo gaya iwaing yai giro garo nuna-una witiro deka atu gege awiro-dutiro nasani nema aune baungno yepu. ");
INSERT INTO zia_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Garo nunae-una wiwiti nasani giro eyero sepu, ‘Tuwara gao ninae-ina mitaise.’ ");
INSERT INTO zia_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ayero saya garo maung mene nigai teng yai giro ge ninae mene nunae-una atu me yaise. Arata garo maung mene nigai teng oko yao yai giro Tuwara gao ninae-ina atu gege me yaise. ");
INSERT INTO zia_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Napo zorata garo zora babaya niye eno masi oko pugao, o ge ninae auna bereya yai saya giro garo awiya yangdoro baungpu. Ayero yero popo nunae te ninae-ina mitiya awiya durere gaipu wosae. ");
INSERT INTO zia_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Na memokoba sinena. Tuwa Bayau mene emo awega-ziwega nasani abena pugariniya be aune napo etobe yazo nunato Sodomto Gomora auna emo awong abena mou-mesayao tamarineya. Arata ge ninae awang sarineya napo auna emo mene zo abena mou-mesa yao nibamu tamarineya. ");
INSERT INTO zia_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Sana nigipu. Niye lama ine, gorobo aung, amaze emo ena eu sino ine auna towang iyengtitinena. Arare niye umo nasani neupu. Ayero nasani gorobo aung dero yawero neupu. ");
INSERT INTO zia_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Niye emo itere-temare yero baingtiti nasani neupu. Awong niye puro gera pugarineya. Awong yere ibu nunae-una atu niye waung mene darineya. ");
INSERT INTO zia_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Awiya gege okowata, niye buro-mani nana yero nowa aeno awong niye puro emo gitau yaora unata emo tuwara una babaya ge buro yarineya. Arare niye nunae benaungnata nupema digara benaungna tauyero Bowi Iwaing sero keregaipu. ");
INSERT INTO zia_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Awong niye puro emo gitau yaora una pugaya ge nono yero sarinenine ayero sinasani kotung-katung oko yae. Ge abena saora be kasa yai aune ge sari yaya Oweno mene niye eno kotumao pugai sarineya ara. ");
INSERT INTO zia_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ge saya ge ninae oko yariniya. Maung ninae auna Oweno mene dubo ninae-una nariniya auna ge yariniya ara. ");
INSERT INTO zia_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Tatomani ena mene metamani nunae magayaese iwora waweng pugarineya. Mamono ena mene mani awiso nunae magayaese sero iwora waweng pugarineya. Mani awiso ena mene ai amono mamono iwo nasani magayaese sero iwora waweng pugarineya. ");
INSERT INTO zia_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Niye yazo nana puro nowa aeno emo apakana niye eno tini kapaore narineya ara. Arare zo nung tau yero dopero nete magayariniya, nung awiya Tuwa Bayau mene sorero pumariniya. ");
INSERT INTO zia_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Arare napo zora atu naya dero tunaya giro napo awiya yangdoro nupema zora baungpu. Na meba sane. Niye buro yero bautu nete Isreli napo sero sero auna atu buro oko yero besugao naya na Emora Mani mene nupema kasa yarinena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mani zota zo mene gipao emo nuna daigairo witaine yao oko mitiya. Nupema soumani mene emo tuwa nuna daigairo baina yao adeka dema oko mitiya. ");
INSERT INTO zia_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Arata mani mene gipao emo nuna mene noiya aine yai teng yariniya. Nupema soumani mene emo tuwa nuna mene noiya aine yai teng yariniya ara. Awong na eno Iwaera Maung ayero sewa, arare buro-mani nana eno deka ayero ge memeko-mameko sarineya ara. ");
INSERT INTO zia_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Arata saineba, susuwa ninae pungyero mitiya awiya ago kasa daung yai garineya. Arare niye awong giro awang oko yae. ");
INSERT INTO zia_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ge ena nane pungyero tugata yero nona awiya dubu bainana atu keregaipu nigae. Ora maingkoka dawong mene nigaine yao awiya dema daung mokera atu keregairo sepu. ");
INSERT INTO zia_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Taung aingso ninae gege dero ititi ninae dari nasani putoung kau yarineya, awong awiya oko awang yepu. Taungne ititire etobe ayero musugai kowa iyaore auna babarineya auna putoung awiya nuna-una mitiya, nung awiya giro awang yepu. ");
INSERT INTO zia_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ni sisisi awiya nona me aung, arare maketra atu ni sisisi etobe auna zuma awiya toya dekaongka gege. Arata Maung ninae mene gai teng oko yati siya, awiya zo oko zuwero magayatiya. ");
INSERT INTO zia_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Arata emo bauno niye mene zo Mama mene niye diya yero baingtiti nasani giti ai ninae zazagairo aung yero noiya ara. ");
INSERT INTO zia_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ni sisisi daigairo auna zuma awiya baina oko, arata ninae mene zo zuma bainane. Arare niye awang oko yae. Mama mene gai teng oko yao yai, nona meko zo ninae-ina tebeba oko kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Zo nung emora benaungna atu ‘Na Yesura mani yero nona’ ayero sariniya, awiya nane emo aeno uritira Mama nana auna benaungna atu ‘Nung awiya mani nana’ ayero sarinena. ");
INSERT INTO zia_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Arata zo nung emora benaungna atu na bewae yariniya, nung awiya nane uritira Mama nana-una benaungna atu abena bewae yarinena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Na mono pumari oko, emo bauno gagausari sero bumuwang ara. Arare ge nana eno gagausero narineya. ");
INSERT INTO zia_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mani emodidi mamonone gagausarineya. Ai amono mani baunodidire gausarineya. Bemani imeti maingne deka ayero gausarineya ara. ");
INSERT INTO zia_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Dubu dekaongka amimene gausero iwo wina-ye yarineya. ");
INSERT INTO zia_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Zo nung aita maung nuna ara tamao baina ara tapunasani na maingkoka ara tamariniya amimene gerao nana yao ine teng oko ara. Zo nung deka ayero mani nuna emodita baunodi ara tamao baina ara tapunasani na maingkoka ara tamariniya a deka gerao nana yao ine teng oko ara. ");
INSERT INTO zia_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ora zo nung i pasao nuna diungno na ago oko yao yariniya, nung a deka gerao nana yao ine teng oko ara. ");
INSERT INTO zia_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Zo nung nao nuna sorariniya amimene nao nuna taragariniya. Arata zo nung na eno nasani nao nuna yangduwariniya amimene nao me tamariniya arauwa. ");
INSERT INTO zia_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Zo nung niye kora yariniya, awiya na eno yetiya ayero yariniya. Ora na eno yariniya, awiya nung Mama nana na iyengtina aeno yetiya ayero yariniya. ");
INSERT INTO zia_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Zo nung porofete zo nai giro kora-makora yariniya nung amimene porofetera abena auna teng pumariniya. Zo nung emo etutero nai giro kora yariniya amimene emo etutero naora abena auna teng pumariniya. ");
INSERT INTO zia_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Na memoko sane. Zo nung emo na ago yero nowa awong auna zo nai giro ou iyangyao dungno pugai minariniya, awiya ou pugariniya aeno nung abena nuna me pumariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu mene buro-mani nuna 12 aeno buro ge sero aung yero atu iropuro napo enana atu uritira ge sero gipero ayari sero baungna ara. ");
INSERT INTO zia_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Anenu Yohane nung bunao gare atu mitasani Kristo mene buro yero nasani nauna auna bowi awiya nigiro giro buro-mani nuna ena iyengtinu ");
INSERT INTO zia_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","baungno Yesu atata yero sewa, “Kristo bumaise sao awiya ning arita zo ago bumai gari diya yarinenine?” ");
INSERT INTO zia_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ayero sewa Yesu mene awong eno abena eyero sena, “Niye kapetegairo baungno nona gigeya, o ge nigeya auna bowi sinasani Yohane tugata yepu nigae. ");
INSERT INTO zia_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Diti guma yao awiya diti pagatineya; te meko yao awiya nupema angneya; emo bozo tauyaore awiya taung iwaing yero neya; dawong itigao awiya ge nigitineya; mamagayao awiya seka yero iropupuneya; ora bogamasa awiya Bowi Iwaing nigitineya. ");
INSERT INTO zia_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Zo nung na eno gai mou oko yao yariniya amimene yawa yawa yariniya.” ");
INSERT INTO zia_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ayero senu Yohanena buro-mani awong kapetegairo bautunewa Yesu mene emo dubu baina mitiwa aeno Yohanena ge eyero sero tugata yena, “Niye Yohane gari eu yanawira bamuwa, awiya emo nono yao maze gari sero bamuwi? Niye emo iyangyao zo bisi mene teboza augati noi buro baungno noiya ayao ine maze gari bamuwita? Aung ara. ");
INSERT INTO zia_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Niye emo nono yao maze gari sero eu yanawira bamuwi? Emo zo taung wori nuna iwaingne amaze gari sero bamuwita? Aung ara. Emo taung wori iwaingne awong awiya emo tuwara gare gege atu mitowa. ");
INSERT INTO zia_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Arare emo nono yao maze gari sero bamuwi? Porofete zo gari sero bamuwita? Na sana nigipu. Emo gari sero bamuwa nung amimene porofete yero nasani porofete ena nauwa awiya daigatiniya. ");
INSERT INTO zia_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nung aeno sero ge zo eyero gaewa mitoiya, Ewiya gipu! Na bowi sao emo nana iyengtarinena. Nung gitau yero nagibo nina kora yariniya. ");
INSERT INTO zia_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Na memoko sana nigipu. Yohane ge ou zayero suwao emo amimene tawingna emo apakana daigatiniya. Arata Tuwa Bayaura napora gerao zo wosao nibamu amimene Yohane daigatiniya ara. ");
INSERT INTO zia_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yohane ge ou zayero suwao emo amimene buro zayena be auna atu emo bauno mene uritira mokora towari sero wina-zakita yero neyata emo putoungne mene toitineya ara. ");
INSERT INTO zia_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mose arita porofete emo ena awong Tuwa Bayau nata Tuwa yero nariniya auna ge sinasani gainasani ayero butunawe duwa Yohane kasa yena be aune porofetera ge atu tana yero dopena ara. ");
INSERT INTO zia_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Arare niye ge nunae gao me yao ine teng yai giro ge ewiya gipu me yae: Eliya mene Sorao Emora nagibo gitau yero bumaise sao, awiya Yohane ara. ");
INSERT INTO zia_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Zo nung dawongne mene ge ewiya nigaise. ");
INSERT INTO zia_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Arare na emo bauno yeme tawingna etu neya amaze nona nora pugairo sana teng yariniye? Niye tani mani mamanikakara ine yero nowa. Mani mamanikaka napo kakame atu adungno mitasani mani mamanikaka ena yau sero eyero sinowa, ");
INSERT INTO zia_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nae ge tuwari niye yuno gogoing detenane, arata niye na oko wuyao yeteya. Nupema nae yo-amaora zi be yetenane, arata niye zi be oko yao yeteya. Arare nae nono yanane gaya iwaing yariniye?’ ayero sinowa ara. ");
INSERT INTO zia_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yohane mene buro nuna zayero nona minao ena semini nasani noi giro nung eno eyero sinowa, ‘Iwae nuna-una mokora mitoiya.’ Ayero sinowa. ");
INSERT INTO zia_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nupema na Emora Mani mene kasa yero nona mininasani ou mininasani ayero nona giro na eno eyero sinowa, ‘Gipu! Nung nona yana mininao emo. Nung ou wain yanakana mininoiya. Nung takis pumao emo aune Yudara sao tauyao ge dao emo awong auna otao.’ Ayero sinowa. Arata nato buro yero nonato awiya Tuwa Bayaura kotumaora yero nonato auna susuwa awiya buro nanato una me mene keregatinoi emo bauno gosinowa me yero noiya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesu mene napo enana atu buro putoungne daigairo nasani putoung nuna-una susuwa keregainu gigiwa, arata dubo oko darawa yao yewa. Arare ge zayero eyero sinasani awong gona yena, ");
INSERT INTO zia_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Oiye Korasin emo bauno! Oiye Besaida emo bauno! Mouyao bainakama ninae-una kasa yariniya. Na tani putoungne ena ninae-una atu yero nona awiya na napo Tayato Saidon auna atu yateni siya, awiya awong yemaoko dubo darawa yero pasena nunae kotungno dubo mininasani mo taung yiurire awiya awiro awetu suwero mitateya. ");
INSERT INTO zia_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Arare sana nigipu. Tuwa Bayau mene emo awega-ziwega nasani abena awong eno pugariniya be aune Tayato Saidon napora emo bauno mene abena wosao tamarineya. Arata ninae mene zo abena ninae bainakama tamarineya. ");
INSERT INTO zia_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ora niye Kapaneam emo bauno, emo bauno ena mene yazo ninae de ika yarineita? Aung ara. Awong yazo ninae puro wosarineya. Ninae una tani baina kasa yena ayao ine Sodom nape atu kasa yati siya, awiya napo awiya oko disatiya. Yeme ewiya mitatiya. ");
INSERT INTO zia_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Aeno sana nigipu. Ago Tuwa Bayau mene emo bauno awega-ziwega nasani abena pugariniya be aune Sodom napora emo bauno mene abena mou yao tamarineya. Arata ninae mene zo abena mou-mesayao nibamu tamarineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Be aune Yesu mene ge eyero sena, “O Mama, ning uritire tawingne auna Tuwa. Awong nuka nuyetope gosinowa emo baina yero noiya emo ayao amimene susuwa nina gowi sero ning putoung nina-una susuwa puingtinosa. Ora awong nuka nuyetope gosinowa mani wuire ine yero noiya awong aeno zo keregatinosa. Arare na aeno ning bowi nena. ");
INSERT INTO zia_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","O Mama, ning ayero gege yari aratapunosa.” ");
INSERT INTO zia_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nung ge awiya sero aung yero aune eyero sena, “Mama nana mene susuwa nuna keregaora putoung awiya wawong nana-una pugaina. Emo zo mene na Maungna Mani auna susuwa oko gosinoiya; Mama mene nata gosinoiya. Deka ayero emo zo mene Mamana susuwa oko gosinoiya; na Mani mene nata gosinona. Ora na Mani mene Mamana susuwa emo ena eno gipinona, awong amimene Mamana susuwa gosinowa. ");
INSERT INTO zia_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Niye sao tauyao ge dimari kaputinasani mouyao dipunowa amimene nana-una bungpu. Buro oregao me tamae. ");
INSERT INTO zia_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Na dubo wosaore ao-diyaore nona, arare nana-una buro amoka nana-una agewa puro dipunasani susuwa nana giro baingtae. Ayero yaya ititi ninae oregairo baingtae. ");
INSERT INTO zia_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Amoka nana niye eno pugari nena awiya iwaing. Deka aine nona ninae dimaese pugarinena awiya eo-meo yao.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sabat iya be zo aune Yesu gitau yenu wuit bure towang bamuwa ara. Bautunasani buro-mani nuna mene merire auno wuit me kowero miniwa ara. ");
INSERT INTO zia_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ayero yewa Farisayo emo awong awiya giro Yesu tugata yero eyero sewa, “A gi! Buro-mani nina buro neya awiya sao tauyao ge mene Sabat bere tani ayao yowi sero awang sao mitiya.” ");
INSERT INTO zia_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ayero sewa giro Yesu mene eyero sena, “Dawidi aune emo ena nung aune dema nasani nauwa awong merire apunasani tani zo yewa auna ungwe awiya niye oko zazagairo gao mene saine neya! ");
INSERT INTO zia_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Awong Tuwa Bayaura ibu auna toiro ame Tuwa Bayaura benaungna pugatinasani nauwa awiya puro miniwa ara. Ame awiya awong emo wosao mene minao sao oko. Pirisa emo gege mene mininaese sao ara. Arata awong miniwa Tuwa Bayau mene giginu meko oko yena. ");
INSERT INTO zia_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ora sao tauyao ge zo bukura gayao mitiya awiya niye zazagairo susuwa nuna gosinowita? Ge awiya eyao era. Pirisa emo awong Sabat bere ibu bainana atu buro nasani iya be dang awiya sisigatinowa pasena oko yero noiya. ");
INSERT INTO zia_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ora nane sana nigipu. Sao nana mene ibu bainana buro awiya daigatiniya. ");
INSERT INTO zia_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ge gayao zo eyero mitiya era, Na Tuwa Bayau mene niye zawing pugaese oko aratapunona. Niye mono pumaese aratapunona. Niye ge auna susuwa nigatei siya, awiya niye buro-mani nana pasena aung eeno ge oko sateya. ");
INSERT INTO zia_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Na Emora Mani mene Sabat be auna Tuwa yero nona ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ayero sero atu baungno yere ibu nunae zo auna witina ara. ");
INSERT INTO zia_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Witinu emo zo wawong nuna amao amimene atu mitina ara. Arare emo ena mene Yesu gera pugari sero, iko nora gairo gera pugari nenine ayero sero giro nung atata yero sewa, “Emo Sabat iya zore kora yao awiya teng nita?” ");
INSERT INTO zia_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ayero sewa Yesu mene be nunae-una puro eyero sena, “Ninae-ina auna zo mene lama nuna dekaongka Sabat iya zo aune zuwero kotera wosai nung Sabat iya kotungno yangduwarinita? Aung ara. Saineba kara watimariniya. ");
INSERT INTO zia_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Lama awiya nona me aung ara. Arata emo mene zo nona me ara. Arare Sabat bere soremao iwaing yaora buro yao awiya teng ara.” ");
INSERT INTO zia_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ayero sero emo aeno eyero sena, “Wawong nina iteti.” Ayero senu wawong nuna itetinu iwaing yero zo aune dema teng yena ara. ");
INSERT INTO zia_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ayero yenu Farisayo awong tani awiya giro apakana baungno Yesu daya magayaise sero ge gatewa ara. ");
INSERT INTO zia_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu mene ge awiya nigiro napo awiya yangdoro baungna ara. Napo awiya yangdoro bautunenu emo bauno daigairo mene nung ago yewa giro emo bauno yayare awiya kora yenu iwaing yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Iwaing yewa giro Yesu mene awong susuwa nuna keregowi sero ge tauyao nibamu sena ara. ");
INSERT INTO zia_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ayero yenu ge gitau Tuwa Bayau mene senu porofete Yesaya mene gaena, ge awiya me yena ara. Ge awiya eyero mitiya, ");
INSERT INTO zia_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ewiya mani sou nana. Na nung giro baingtiro aune pumuwang ara. Nung yo diyang nana. Na nung aratapunona. Na Oweno nuna-una tame pugana nung soremai diga emo bauno eno etutero naora ge sero gipero yariniya ara. ");
INSERT INTO zia_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nung ge matu yaota ge betao awiya oko yariniya. Ge nuna-una bewing kakame etu oko kasa yai nigarineya. ");
INSERT INTO zia_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nung emo bauno opowang botu zorogao ine awiya gera yari okowata, kora yai tauyarineya. Nung emo bauno damanana wuik kayai yao ine awiya sisigari okowata, kora yai iwaing yarineya ara. Ayero nasani buro etutero korayero naora ge mene nao apakana daigatinasani iwaing kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ayero yai diga emo naiye-naiye amimene nung tumo diyarineya ara. ");
INSERT INTO zia_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Emo zo iwae mene mokora toinu diti guma yenu ge sao teng oko yero nasani nauna emo awiya ena mene puro baung Yesura una yewa ara. Ayewa Yesu mene kora yenu diti moko nuna pagainu ge wina-se yewato ara. ");
INSERT INTO zia_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ayero yenu emo bauno dubu baina mitiwa amimene giro wawong di gauno bowi pasore nasani eyero sewa, “Dawidira sai bumaise sao arita?” ");
INSERT INTO zia_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ayero sewa Farisayo mene nigiro eyero sewa, “Iwae sorowera gitau yao yazo nuna Bielsebul amimene nung sorepunoi iwae tuninoiya ara.” ");
INSERT INTO zia_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ayero sewa Yesu mene kotumao nunae-una susuwa giro ge nunae abena sari sero tawingna pugairo eyero sena, “Tawing zo auna emo awong gagausero wina-de yarineya, awiya tawing awiya mena zatu yero i bairo suwariniya. Deka aine napo zota dubu zo auna emo awong gagausero wina-de yarineya, awiya napo awiya tauyao oko mitarineya. ");
INSERT INTO zia_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Arare Sandara dubu mene awigairo nasani wina-de yatei siya, awiya putoung nuna sisigairo aung yatiya. ");
INSERT INTO zia_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ayero na Bielsebulra putoungna iwae tuninoni siya ayero sinowa, ge awiya meba siya, awiya mani awiso ninae iwae tuninowa awong awiya ana putoungna iwae tunarinei? Awong Tuwa Bayaura putoungna iwae tuninowa, arare awong amimene ge iwao ninae auna susuwa keregarineya. ");
INSERT INTO zia_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Naka awiya Tuwa Bayaura Oweno mene sorepunoi iwae tuninona, arare Tuwa Bayau nata Tuwa yero nariniya auna putoung ninae-una yemaoko kasa yero mitoiya. ");
INSERT INTO zia_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Arata zo mene emo putoung bainane zo mitai aune garo nuna-una witiro wau nuna sorero pumao awiya teng nita? Awiya aung ara. Nung emo putoung bainane awiya gitau bunero aune wau nuna sorero pumariniya ara. ");
INSERT INTO zia_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Zo nung na eno otao oko yao yariniya amimene na eno iwo yariniya. Nupema zo nung dubu nana oko duma dao yariniya nung amimene sisigao buro yariniya. ");
INSERT INTO zia_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Arare sana nigipu. Emora pasena susuwa giti arita Tuwa Bayau izaora ge susuwa giti awiya disao ine teng ara. Arata zo nung Oweno izariniya, emo auna pasena awiya disao teng oko ara. ");
INSERT INTO zia_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Zo nung na Emora Mani eno ge meko sariniya, awiya Tuwa Bayau mene pasena awiya disariniya. Arata zo mene Oweno sero pusugairo iyariniya awiya pasena nuna tawingna etuta ago uritira atu disao aung yao ine teng oko ara. ");
INSERT INTO zia_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Niye i zo eno ‘iwaing’ ayero sero giro me nuna eno deka ayero ‘iwaing’ sepu. Ora i zo eno ‘meko’ ayero sero giro me nuna eno deka ayero ‘meko’ sepu. Noeno oko, i me mene ira susuwa keregatinoiya ara. ");
INSERT INTO zia_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Niye yira saisibuna, niye meko mene nono yero ge iwaing sarinei? Dubo mene denenu mitoiya auna teng be mene keregairo sinoiya. ");
INSERT INTO zia_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Emo iwaing awiya kotumao iwaing nuna-una mokora mitoiya, arare nung tani iwaing yero noiya. Emo meko awiya nung kotumao memeko-mameko nuna-una mokora mitoiya, arare nung tani memeko-mameko yero noiya. ");
INSERT INTO zia_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Arata nane sana nigipu. Ge diti giro oko sinowa awiya Tuwa Bayau mene emo bauno awega-ziwega nasani abena pugariniya be aune niye ge auna ge buro yarineya ara. ");
INSERT INTO zia_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Awiya noeno oko, ge sinosa amimene susuwa nina keregai iwaing yai Tuwa Bayaura una kotora atu iwaing yarinesa. Arata ge sinosa amimene susuwa nina keregai meko yai Tuwa Bayaura una kotora atu zuwarinesa.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yesu mene ayero sero tugata yenu sao tauyao ge gipao emo ena aune Farisayo ena awong amimene ge eyero kapetegairo sewa, “Gipao emo, ning tani putoungne zo ye kasa yai ganene.” ");
INSERT INTO zia_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ayero sewa abena eyero sena, “Niye emo memeko-mameko. Emo mene bauno daigati noiya deka ayero niye Tuwa Bayau daigatinowa. Niye tani putoungne zo yana gari sineya. Arata niye tani putoungne zo oko garineya. Tani gitau porofete Yonana una atu kasa yena, deka ayao ine kasa yai garineya. ");
INSERT INTO zia_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yona nung iya mume etama ayero wo baina auna obera atu mitina, deka ayero na Emora Mani mene iya mume be etama ayero tawing mokora atu mitarinena. ");
INSERT INTO zia_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tuwa Bayau mene emo awega-ziwega nasani abena pugariniya be aune Niniwe emo mene iropuro emo bauno be yeme tawingna etu neya euna susuwa keregaya mouyao dimarineya. Awiya noeno oko, Niniwe emo Yona mene Tuwara ge tugata yenu nigiro dubo darawa yewa. Arata na etu dopero mitena amimene Yona daigatinena. ");
INSERT INTO zia_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ora Siba tawingna bauno tuwa nung dema iropuro emo bauno yeme tawingna etu neya euna susuwa keregai mouyao dimarineya. Awiya noeno oko, bauno amimene Solomonna kotumao bainakama awiya sai nigari taung dero tawing ake nibamu auna atu buna ara. Arata na etu dopero mitena amimene Solomon daigatinena. ");
INSERT INTO zia_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Iwae mene emora mokora atu kasa yero oregaora masi eu atu tamari babariniya. ");
INSERT INTO zia_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Baungno oko tamao nete giro eyero sariniya, “Garo nana doro bumuwang deka auna nupema kapetegairo babarinena.” Ayero sero baungno garo awiya sauno kora yeteya besuma sungno mitiya awiya gariniya. ");
INSERT INTO zia_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Awiya giro nupema baungno iwae otao mani 7 awiya nung ine oko, meko nibamu awiya puro garo deka auna toiro mitao masi yarineya ara. Ayero yaya emo awiya gitau meko nasani nauna amimene be aune meko yore nibamu yariniya. Arare emo dubu meko yeme tawingna etu neya auna-una atu deka ayero kasa yariniya ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu nung ge awiya tugata nasani nenu nunae-una bautara atu ai metamaine nuna mene ge nung eno sari sero nung diya mitiwa ara. ");
INSERT INTO zia_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ayero mitiwa emo zo mene Yesu eno eyero sena, “Ai nina metamaine awong ge ning eno sari sero buro bautara atu dopero miteya.” ");
INSERT INTO zia_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ayero senu Yesu mene ge abena eyero sena, “Awe ai nana yero niye? Awe mene metamani nana yero nowi?” ");
INSERT INTO zia_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ayero sero buro-mani nuna atu mitiwa aeno wawong yunu yero eyero sena, “Gipu. Aya mani metamani nana era. ");
INSERT INTO zia_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Zo nung Mama nana uritira mitoiya auna ge nigiro dipunoiya nung amimene metata, numonota, aya nana niya ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Iya be aune Yesu mene gare atu wosiro ou nazi deung bera bage atu adungno mitina ara. ");
INSERT INTO zia_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Atu mitinu emo bauno dubu bainakama mene nuna-una kasa yewa ara. Kasa yewa giro nung wang zora witiro adungno mitinu emo bauno dubu baina mene zo awong ika atu dopewa ara. ");
INSERT INTO zia_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ayero yewa Yesu mene ge eniya ena sinasani kotumao daigairo awong eno tugata nena. Tugata nasani ge eyero sena, “Sana nigipu. Emo zo mene nona we bure atu sesari sero baungna ara. ");
INSERT INTO zia_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Baungno nona we bure atu sesinenu we ena nagibe atu wosiwa. Atu wosiro daung mokera mitiwa ni mamani mene taungno miniro aung yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","We ena awiya tawing daba tame soyao auna wosiwa ara. Tawing awiya sori oko, arare we amimene mena pusasa yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ayero yewa tatai nunae mene imokore oko wosiro baunare wari mene witiro awenu irara yero auno aung yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","We ena awiya tawing i nawe tatai mitiwa auna wosiwa ara. We awiya i nawere dema apakana tetemo pusasa yewa i nawe mene nona awiya denu me oko iyao yena ara. ");
INSERT INTO zia_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","We ena awiya tawing me gawire auna wosiro me daigairo iwa ara. Nona wosiro pusasa yero iropumuwa auna zora me nuna 100, zora me 60, ora zora me mene zo 30, ayero kasa yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Arare zo nung dawongne mene ge awiya nigaise.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ge ayero senu buro-mani nuna mene nuna-una nugu baungno atata yero sewa, “Ning noeno ge eniya ena awiya awong eno sinosi?” ");
INSERT INTO zia_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ayero sewa Yesu mene abena eyero sena, “Tuwa Bayau nata Tuwa yero nariniya auna ge pungyero mitoiya, auna susuwa awiya niye ena mene nigaese sao mitiya ara. Arata emo bauno ena awiya aung ara. ");
INSERT INTO zia_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Zo nung nona nung eno pugao awiya puro nai giro nupema memani pugana nung zamena simena baina tamariniya. Arata zo nung nona nung eno pugao awiya doro aung nai giro na nona nuna sorero pumana nung teba aung nariniya ara. ");
INSERT INTO zia_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Awong diti moko nunae mene gosinowa, arata oko giro baingtitinowa. Awong dawong mene ungwe nigitinowa, arata ungwena susuwa awiya oko giro baingtitinowa. Aeno na ge eniya awiya awong eno sinona. ");
INSERT INTO zia_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Arare ge zo porofete Yesaya mene gaena ge awiya nunae-una atu me niya. Ge awiya eyero mitiya, Niye dawong mene zo nigarineya, arata susuwa nuna oko nigiro baingtarineya. Niye diti moko ninae mene garineya, arata susuwa nuna oko giro baingtarineya. ");
INSERT INTO zia_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Emo dubu ewiya awong kotumao aung. Awong dawong itigao ine, arare ge oko nigao yero nowa. Awong diti moko nunae sikimuwa. Ayero oko yao yateya, awiya diti moko mene nonana susuwa gateya; arita dawong mene gera susuwa nigateya; nupema dubo mene nonana susuwa nigiro baingtateya. Ayero oko yao yateya, awiya awong dubo darawa yaya na awong kora yatena. ");
INSERT INTO zia_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ninae mene zo diti moko pagairo giro baingtitinowa. Nupema dawong yawero nigitinowa. Arare niye yawa yawa yero nowa. ");
INSERT INTO zia_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Na ge me sane. Gitau porofete daigairo aune etutero nao emo daigairo awong amimene nona gosineya awiya gari aratapu nasani nauwa, arata awong oko gao yero nawe mamagayewa. Awong ge nigitinowa awiya nigari aratapu nasani nauwa, arata oko nigao yero nawe mamagayewa. ");
INSERT INTO zia_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Arare nona me bure sesaora ge eniya sesena auna susuwa nuna awiya keregairo sana nigipu. ");
INSERT INTO zia_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nona we ena nagibe atu wosina auna susuwa eyao era: Emo zo uritira ge nigitinoi susuwa oko kasa yao noi pasenana maung mene nuna-una kasa yero uritira ge dubo nuna-una toitinoiya awiya puro tara yero noiya ara. ");
INSERT INTO zia_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ora nona we ena awiya tawing daba tame soyao auna wosina, auna susuwa eyao era: Zo nung uritira ge nigiro mena puro yawa yawa yero noiya. ");
INSERT INTO zia_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Arata nung tatai aung, arare nung be apungkaka gege Tuwara nagibora nariniya. Ayero nai uritira gera iwo kasa yai nung mena yangduwariniya ara. ");
INSERT INTO zia_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ora nona we ena i nawe towang wosina auna susuwa eyao era: Zo nung uritira ge nigitinoiya, arata nung tawingna nona eno kotung-katung noi wau moni mene nung etegatinoiya, arare tani ayao amimene uritira ge wori nowa me oko kasa yero noiya. ");
INSERT INTO zia_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ora nona we ena tawing gawire auna wosina auna susuwa eyao era: Zo nung uritira ge nigitinoi susuwa kasa yero noiya. Nung amimene me itinoiya. We zora me 100, zora me 60, zora me 30, ayao ine kasa yero noiya ara.” Ge ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ayero sero ge eniya zo dema eyero sena, “Uritira mitoiya amimene nata Tuwa yero nariniya auna susuwa awiya eyero pugairo sana teng yae. Emo zo mene wuit me iwaing bure atu sesena. ");
INSERT INTO zia_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Me sesena aune ping tuno tano iwo nuna mene kasa yero wuit auna towang atu i-we zo goru nuna wuitra ine auna me awiya puro baungno sesero doro tara yena. ");
INSERT INTO zia_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ayero yenu wuit aune i-we aune teng pusasa yewa. Pusasa yero me iwa aune i-we auna benaung kasa daung yena ara. ");
INSERT INTO zia_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ayero yenu mani sou mene giro buro maung tugata yero eyero sewa, “Emo tuwa, ning buro nina auna nona me iwaing gege sesasa, arata i-we meko ewiya natu buro pusasa niye?” Ayero atata yewa sena, ");
INSERT INTO zia_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Awiya iwo zo mene sesena amimene pusasa niya.” Ayero senu nupema atata yero sewa, “Ayero nae baungno i-we awiya sumanenese kotupunesita?” ");
INSERT INTO zia_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ge ayero sewa abena eyero sena, “Aungwa. Niye i-we supunasani wuit dema sumowi sero yangdopu. ");
INSERT INTO zia_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Wuit awiya i-we aune dema teng mitete iropaeto. Ago wuit me pumaora be kasa yai aune me pumaora emo mene gitau i-we meko awiya suno tairo tiro iyaora igiyaese sarinena. Arata wuit me gege etutero garo nana-una zuwagaese sarinena.” Yesu mene ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu mene ge eniya zo eyero sena, “Tuwa Bayau nata Tuwa yero nariniya, awiya i mastet ayero sero nonane auna me ine ara. Emo awong i me awiya puro bure nunae-una atu urinowa. ");
INSERT INTO zia_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Urinowa pusasa yero bairo nona we ena bure atu urinonane awiya apakana daigairo baina noiya. Ayero noi bowang nuna babuze kasa nowa ni mamani mene utung nuna-una buro bowangna atu uwang gapunowa.” ");
INSERT INTO zia_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu mene ayero sero ge eniya zo eyero dema sena, “Tuwa Bayau nata Tuwa yero nariniya auna susuwa awiya yis ine. Bauno zo mene tao baina zora atu plaware yisre pugairo dawenu yis toiro plawa punu titisero daing yena ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu mene emo bauno ge tugata yero nasani nauna, awiya ge eniya gege sinauna ara. Ge keregairo oko sao yena. ");
INSERT INTO zia_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ayero yenu porofete zo mene gitau ge eyero sena awiya me yena, Na ge eniya sinasani kotumao pungyao tawing kasa yena aune kasa yero butunoiya awiya keregarinena. ");
INSERT INTO zia_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu mene emo bauno senu bautunewa nung garo nuna-una witina ara. Witiro mitinu buro-mani nuna mene nuna-una baungno eyero sewa, “Ning wuit bure atu i-we enana ge sesesa auna susuwa se nae niganene.” Ayero keregaise sewa giro sena, ");
INSERT INTO zia_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","“Emo we iwaing sesena nung awiya Emora Mani. ");
INSERT INTO zia_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Buro awiya tawing apakana auna teng ara. We iwaing awiya uritira gerao dubu ara. Ora i-we awiya pasenana maung auna mani awiso. ");
INSERT INTO zia_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Iwo mene i-we sesena awiya Sanda. Wuit me pumaora be awiya be baina. Me pumaora emo awiya angelo dubu. ");
INSERT INTO zia_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","I-we suno iyaora igitinowa susuwa ayao awiya be bainana atu kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Be bainana atu na Emora Mani mene angelo dubu nana iyengtana wosiro pasena yumaora nona arita emo pasena yero nowa awiya apakana yangtagairo emo tuwa yaora masi nana yangdoro ");
INSERT INTO zia_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","iyao tauyao awao gege awinoiya auna augarineya ara. Ayero yaya atu zi irare barare sinasani engweze-pangweze nasani mitarineya. ");
INSERT INTO zia_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Be aune emo etutero nao awong Maung nunae-una atu nasani wari posinoiya ayao ine posero waegarineya. Zo nung dawongne mene ge ewiya nigiro baingtaise. ");
INSERT INTO zia_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Tuwa Bayau nata Tuwa yero nariniya auna susuwa eyao era. Maguro zo wau moni bainane tawing agewa zora atu pungyao mitauna, awiya emo zo mene taungno nupema pungyenu kayero mitinu nung yawa yawa nasani nona-owi nuna awiya apakana emo eno pugairo aung yenu nung eno zuma pugaiwa puro baungno tawing agewa awiya zuma gaero pungna arauwa. ");
INSERT INTO zia_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Nupema Tuwa Bayau nata Tuwa yero nariniya auna susuwa awiya eyao era. Emo zo nung zewe zaima tamaora buro yero nauna. ");
INSERT INTO zia_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ayero kaunawe iwaing zo taungno giro nona-owi nuna apakana emo eno pugainu aung yenu nung eno zuma pugaiwa puro baungno zewe zaima awiya zuma gaero pungna ara.” Ayero sena ara. Name tawingna nona me aung awiya doro kotumao naname puro pu uritira gairo nanenese auna sena. ");
INSERT INTO zia_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesu mene eyero sena, “Tuwa Bayau nata Tuwa yero nari niya auna susuwa awiya moga ine. Emo mene moga witora augairo wo ewego-papego benaung giti watimuwa. ");
INSERT INTO zia_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ayero yewa wo be bunu watimuwa witi ika yenu emo adungno wo yangtagati nasani wo minao awiya puro pu taora gaiwa. Ora oko minao ami zo augairo yangduwa ara. ");
INSERT INTO zia_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tawingna be aung nai aune susuwa ayao ine kasa yariniya. Be auna atu angelo awong tawing sero sero auna atu baungno emo bauno iwawaing auna towang atu emo bauno memeko-mameko yangta gatigairo ");
INSERT INTO zia_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","iyao tauyao nibamu awao gege awinasani mitoiya auna augaya babarineya. Ayero yaya atu zi irare barare sinasani engweze-pangweze nasani mitarineya.” ");
INSERT INTO zia_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu mene ayero sero atata yero sena, “Niye ge apakana auna susuwa nigiro baingtitineita?” Ayero senu awong eyero sewa, “Nigiro baingtitinonane.” ");
INSERT INTO zia_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ayero sewa giro eyero sena, “Buro-mani nana zo mene Tuwa Bayau nata Tuwa yero nariniya auna susuwa awiya nigitinoiya amimene garo maung zo ine ara. Garo maung mene nona mature sekare garo nuna-una pugairo diya noi emo ena mene nona kau nowa giro garo mokora atu puro emo nona kau nowa aeno pugatinoiya. Deka ayero buro-mani nana mene kotumao mature sekare amaze puro nasani emo bauno gipari yero giro puro gipariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu mene ge eniya benaung giti awiya sinete sero aung yero tawing awiya doro baungna ara. ");
INSERT INTO zia_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ayero baungno napo nuna-una kasa yero yere ibu nunae-una toiro uritira ge tugata yenu emo mene wawong di gauno eyero sewa, “Emo ewiya nigao baina aune tani putoungne yao awiya natu taungni? ");
INSERT INTO zia_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Name susuwa nuna gosinenane. Nung kapendara mani ara. Ai nuna yazo Maria. Aune metamani nuna yazo nunae Yakoboto Yosefe, aune Simonto Yuda. Nupema numono mani nuna apakana awiya nae aune dema yero nowa. ");
INSERT INTO zia_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Arare emo ewiya nigao baina awiya natu taungni?” ");
INSERT INTO zia_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ayero sero nung eno kotumao meko pumuwa ara. Ayero yewa Yesu mene awong eno eyero sena, “Porofete awong emo yazore. Arata napo nunae-una atu, o mamono nunae-una atu awong emo yazo aung.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Napo auna emo awong nung tumo oko diyao yewa, arare nung tani putoungne ena daigairo nunae-una atu oko yero nauna. ");
INSERT INTO zia_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Be auna atu emo tuwa Herode mene Yesura ge bowi nigina ara. ");
INSERT INTO zia_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nigiro buro-mani nuna eno eyero sena, “Yohane ge ou zayero suwao emo nung ka amimene magayaora atu iropuro noiya, arare nung tani putoungne yero noiya.” ");
INSERT INTO zia_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ge awiya tebeba oko sena. Herode nung gitau yemaoko meta nuna Filip auna bauno sorero puna, yazo nuna Herodia, bauno aeno yero senu gorobo emo baungno Yohane tere wawongne bunero puro pu bunao gare gaiwa. ");
INSERT INTO zia_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Awiya Yohane mene ge eyero sena aeno yena, “Ning bauno pumasa awiya teng oko niya.” ");
INSERT INTO zia_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ayero senu Herode mene Yohane dari kotupunauna ara. Arata emo bauno mene Yohane nung porofete ayero sinasani nauwa, arare Herode mene awong awang yero yangdunu mitauna ara. ");
INSERT INTO zia_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Atu mitaunu aune Herode kasa yao be nuna bunu giro emo babuze senu nuna-una kasa yero augairo mitiwa Herodiara mani baunodi amimene nunae-una benaungna atu na wuinu Herode mene giginu iwaing yenu giro ");
INSERT INTO zia_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","nung eno eyero sena, “Na Tuwa Bayaura benaungna ge me sana tau yae. Ning nona zota zo ara taungno giro sasa pugarinena.” ");
INSERT INTO zia_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ayero senu mani baunodi awiya nung ai nuna mene kotumao zo pugainu giro eyero sena, “Ning Yohane ge ou zayero suwao emo auna gitau ato awiya puro pu taora gairo yeme puro bung na eno pugase.” ");
INSERT INTO zia_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ayero senu emo tuwa nung dubo nuna mou yena ara. Arata Tuwa Bayaura benaungna ge senu tauyena, nupema emo dema mitiwa amimene ge nuna gaya wosao yoiye sero awang yero giro, ");
INSERT INTO zia_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","saineba sero senu gorobo emo awong baungno Yohane bunao gare atu dubo nuna kapero ");
INSERT INTO zia_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","gitau taora pugairo puro buro mani baunodi eno pugaiwa puna ara. Pugaiwa mani mene puro ai nuna eno pugainu puna ara. ");
INSERT INTO zia_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yohane dewa magayenu giro buro-mani nuna mene kasa yero taung aingso nuna puro mutewa. Mutero aune baungno Yesu eno ge ungwe yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu mene Yohanena bowi nigiro tawing awiya doro wang zora witiro tawing zo emo aung auna atu nata nari sero baungna ara. Bautunenu emo bauno mene bowi nuna nigiro napo sero sero auna emo bauno dubu baina amimene ika bautunete tawing deka auna kasa yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ayero yewa Yesu mene wangna atu wosiro emo bauno dubu baina awiya giro yo baina yenu giro emo bauno yayare nunae awiya kora yena ara. ");
INSERT INTO zia_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ayero nasani nenu ture itinenu giro buro-mani nuna mene nung eno eyero sewa, “Eu etu nenane ture itiniya, arare emo pugasa napo sero sero baungno nona minao tamarineya.” ");
INSERT INTO zia_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ayero sewa abena eyero sena, “Niye awong babaese oko sae. Ninae awong eno nona pugaipu minae.” ");
INSERT INTO zia_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ayero senu abena sewa, “Nae ma wawong zo aune wo etobe gege maze puro nenane.” ");
INSERT INTO zia_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ayero sewa giro Yesu mene sena, “Nona awiya puro nana-una bungpu.” ");
INSERT INTO zia_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ayero sero emo bauno senu yowangze patiro isiyero adungno mitiwa ara. Ayero yero mitiwa nung ma wawong zore wo etore awiya puro diti ika uritira yero Tuwa Bayau eno dange sero eegairo buro-mani nuna eno pugainu puro emo bauno eno bono yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ayero yewa awong apakana miniwa teng yena ara. Ayenu giro nona itoto ena awiya puro pu dekaongna gaiwa saka 12 teng yena ara. ");
INSERT INTO zia_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ora emo nona miniwa awiya 5,000 mene nona miniwa ara. Arata ai amonone mani mamanikakare ami zo oko zazagao yangduwa arauwa. ");
INSERT INTO zia_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesu mene buro-mani nuna eno senu awong nata wangna witiro gitau ou nazi deung enaba bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bautunewa Yesu mene senu emo bauno zanero bautunewa nung isa buro yari nata witi ika diri yena ara. Atu isa buro nasani nenu ping atu ina. ");
INSERT INTO zia_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A nenu wang mene bautunete ou nazi towang daung singsang gaina ara. Mume aune bisi benaungna atu butunenu kakawa baina dema dero buro wang puro witiro wosiro nena. ");
INSERT INTO zia_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ayero nenu newa iya gari sero nenu Yesu mene ou nazi tame atu ang yero bautunete awong tamari nugu daung nenu ");
INSERT INTO zia_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","buro-mani mene nung ou tame atu ang nena amaze giro yangka sero ipinasani ‘iwae mene butuniya’ ayero sero awang nasani aiyamama sewa ara. ");
INSERT INTO zia_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Aiyamama sinewa Yesu mene eyero sena, “Niye tau yepu. Nane ara. Awang oko yae.” ");
INSERT INTO zia_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ayero senu Petoro mene be nuna-una puro eyero sena, “Tuwa, nine meba butunesita se giro na dema ou tame atu ang yero nina ina bumane.” ");
INSERT INTO zia_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ayero senu Yesu mene eyero sena, “Bung.” Ayero senu giro Petoro mene wangna atu wosiro ou tame atu ang yero Yesura una baungna ara. ");
INSERT INTO zia_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nuna-una bautunasani bisi baina nena awiya giro awang yero oura kuru-kuru sinasani Yesu yau sero eyero sena, “Tuwa, na pung!” ");
INSERT INTO zia_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ayero senu Yesu mene mena wawong nuna initinasani eyero sena, “Ning tumo diyao bainane oko, arare ou tura babari sero nesa. Ning noeno dubo eto nesi?” ");
INSERT INTO zia_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ayero sero wangna witiwato bisi aung yena ara. ");
INSERT INTO zia_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ayero yenu emo wangna mitiwa amimene Yesura una atu koing gairo eyero sewa, “Ning Tuwa Bayaura Mani me.” Ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Awong ou nazi buwagairo Genesaret tawingna atu kasayero witiwa ara. ");
INSERT INTO zia_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ayero yewa emo bauno mene Yesu gigiwa ziwenu ge sero sero yewa napo sero baungnu emo bauno yayare nunae mitauwa awiya puro Yesura una bamuwa. ");
INSERT INTO zia_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ayero yewa emo bauno yayare mene Yesu isa sero taung wori nuna tera atu gege ding yari sewa. Arare awong nung ding yewa awong auna yaya mene zo aung yena ara. ");
INSERT INTO zia_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Be auna atu Yerusalem napora Farisayo aune sao tauyao ge gipao emo ena awong amimene Yesura una kasa yero atata yero sewa, ");
INSERT INTO zia_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Buro-mani nina awong noeno ewowo naname una tani daigatinowi? Ayero nasani wawong oko sayao nona tebeba mininowa, amaze sinenane!” ");
INSERT INTO zia_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ayero atata yewa giro Yesu mene abena eyero sena, “Ora niye dema noeno tani ninae matu ago nasani Tuwa Bayaura sao tauyao ge awiya dedunowi? ");
INSERT INTO zia_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tuwa Bayaura ge zo eyero mitiya, ‘Ning tani iwaing ai maung nina eno nasani neu.’ Nupema ge nuna zo eyao era, ‘Zo nung ai maung nuna eno ge meko sari niya nung awiya depu magayae.’ ");
INSERT INTO zia_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tuwa Bayaura ge ayero mitiya, arata ninae mene zo eyero sinowa, ‘Zo nung aita maung nuna eno eyero tugata yariniya, nung amimene ai maung nuna sou yaise sao oko mitiya, “Nona nito eno pugatena, arata nona awiya yemaoko Tuwa Bayau eno pugari sewang tau yena.’” ");
INSERT INTO zia_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Niye ayero sinowa amimene ewowora tani puro nasani Tuwa Bayau mene ai maung sou yaese ge sena awiya dotinowa aung yero noiya. ");
INSERT INTO zia_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Niye ge iwao emo me sao yero nowa! Porofete Yesaya mene ge gaena amimene niye gapuniya. Ge gaena awiya eyero mitiya, ");
INSERT INTO zia_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Tuwa mene eyero siniya, Emo emimene na begiti mene bowi yero nowa, arata moko nunae mene zo nana-una oko mitiya. ");
INSERT INTO zia_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Awong emo ge amaze Tuwa Bayaura sao tauyao ge ine ayero sinasani sero gipero yero nowa. Arare awong na bowi yero tetere yero nowa.” ");
INSERT INTO zia_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu nung ayero sero emo bauno dubu baina yunu kasa yewa eyero tugata yena, “Na ge sana nigiro baingtipu. ");
INSERT INTO zia_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nona be ninae-una toitinoiya amimene oko niye yero noi beingtire yero nowa ara. Ge be ninae-una atu kasa yero noiya amimene niye yero noi beingtire yero nowa ara.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ayero senu giro buro-mani nuna mene nimoi aung nuna-una benaungna baungno nung atata yero sewa, “Ning ge sesesa aeno Farisayo awong ge awiya nigiro dubo mou pupuneya, awiya gosinesita?” ");
INSERT INTO zia_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ayero sewa giro abena eyero sena, “I dubu baina uritira Mama nana mene oko urao agiti pusasa yero baiwa awiya apakana suno aung yarinena ara. ");
INSERT INTO zia_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Awong dubo mou pupuneya auna kotung-katung oko yepu. Awong diti guma yao amimene nagibo gitau yari yaine neya. Ora emo diti guma yao zo mene otao nuna diti guma yao auna nagibo gitau yariniya, awiya awongto etobe deka ayero kowara babarineyato.” ");
INSERT INTO zia_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ayero senu Petoro mene Yesu eno eyero sena, “Ning ge eniya sesesa auna susuwa keregai niganene.” ");
INSERT INTO zia_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ayero senu Yesu mene eyero sena, “Ayero niye deka dema kotumao aungta nowa. ");
INSERT INTO zia_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Susuwa eyao oko nigao yero nowita? Nona be mene mininonane tini naname una baungno nagibo nuna-una wowosinoiya. ");
INSERT INTO zia_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ora ge be ninae-una atu kasa yero noiya awiya dubora atu kasa yero noiya, arare ge amimene niye yero noi beingtire yero nowa ara. ");
INSERT INTO zia_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Emora dubora atu nona eyao awiya kasa yero noiya: kotumao meko, emo dao magayao, kuma yao, nona ugaing yao, kotora atu ge iwao, ge iwero emora yazo puro wosao. ");
INSERT INTO zia_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nona ayao amimene niye yero noi Tuwa Bayaura benaungna atu beingtire yero nowa ara. Ora wawong oko saero nona minao amimene noi niye beingtire oko yero nowa.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu buro-mani nuna aune tawing awiya doro napo etobe mitauwato auna tawingna bamuwa ara. Napo etobe awiya Tayato Saidon. ");
INSERT INTO zia_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Atu baungno newa Kenan tawingna bauno zo Yuda oko mene buro Yesu yausero sena, “O Tuwa, ning Dawidira sai mene naka eno yo aung. Mani baunodi nana iwae mene daraunu meko yero mitoiya.” ");
INSERT INTO zia_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ayero senu Yesu mene nigiro ge zo oko sena. Ayero yenu buro-mani nuna mene nuna-una kasa yero eyero sewa, “Ning bauno se babae. Nung naname una ago butunasani wawa siniya.” ");
INSERT INTO zia_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ayero sewa giro Yesu mene eyero sena, “Na Isreli emo dubu lama tara yao ine awong auna gerao gege.” ");
INSERT INTO zia_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ayero sinenu bauno awiya nuna-una benaungna kasa yero koing gairo isa sinasani eyero sena, “O Tuwa, ning na soreung!” ");
INSERT INTO zia_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ayero senu abena eyero sena, “Mani mamanina nona minao sorero sino unao ine awiya teng oko niya.” ");
INSERT INTO zia_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ayero senu ge abena eyero kapetegaina, “Tuwa, awiya meba sinesa. Arata nupema sino awong diya nunae-una opesa wese atu nona susuna wowosi noi mininowa.” ");
INSERT INTO zia_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ayero senu giro Yesu mene eyero sena, “O bauno, tumo diyao nina bainakama. Arare sinesa ayero yaise.” Ayero sinenu mani baunodi nuna awiya iwaing yena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu nung tawing awiya doro nupema kapete gairo butunete Galilaya ou nazira kasa yero bage-bage nete diri zora witiro baungno adungno mitina ara. ");
INSERT INTO zia_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Atu mitinu emo bauno dubu baina amimene emo bauno yayare witao nibamu puro buro nuna-una kasa yewa ara. Awong ena te gimao, o ena diti guma yao, o te wawong amao, o ena ge aung dau emo, o dubu bainane mene zo yaya benaung giti noyao, ayao amaze puro kasa yero Yesura benaungna pugaiwa apakana kora yero aung yena ara. ");
INSERT INTO zia_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ayero yenu dau mene ge ungwe-maungwe yewa, ora te wawong amao mene iwaing yewa, ora te gimao mene iwaing yero ang yewa, ora diti guma yao mene zo diti pagaiwa ara. Arare emo bauno dubu baina mene tani amaze giro yawa yawa bainakama nasani Isreli emora Tuwa Bayau auna yazo de ika gatinasani bowi pasore yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu mene buro-mani nuna yau senu bumuwa eyero sena, “Na emo dubu ewiya eno yo baina niya. Noeno oko, awong nana-una wari be etama ayero nete doteya nona minao aung yeti nona kau neya. Arare nona aung ayero sana awong etu iropuro bautunete nagibe atu meri magayowi sero awang nena.” ");
INSERT INTO zia_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ayero senu buro-mani nuna mene eyero sewa, “Ewiya: Eu nezera etu nenane, arare ma witao natu taungno emo dubu baina ewiya eno puganane minaya teng yariniye?” ");
INSERT INTO zia_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ayero sewa giro nung awong atata yero sena, “Ma ninae una nazigo mitiye?” Ayero senu awong eyero sewa, “Ma 7 aune wo mamanikaka etoka gege ara.” ");
INSERT INTO zia_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Asewa giro Yesu mene emo bauno adumaese senu adungno mitiwa ara. ");
INSERT INTO zia_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ayero yewa nung ma 7 aune wo eto amaze puro Tuwa Bayau eno dange sero eegairo buro-mani nuna eno pugainu awong bono yero emo bauno eno pugairo bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Pugairo bamuwa emo bauno miniwa teng yena ara. Ayero yewa nona itoto awiya puro pu dekaongna gaiwa saka 7 teng yena ara. ");
INSERT INTO zia_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nona miniwa auna emo namba nunae 4,000. Arata bauno mani awisore ami zo oko zazagao. ");
INSERT INTO zia_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu mene emo bauno iyengtinu bautunewa nung wangna witiro bautunete Magadan tawingna kasa yena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisayo emo aune Sadukayo emo awong amimene Yesura una kasa yero Yesu gaero gari sero etegao ge eyero sewa, “Ning kara sasa uritira tani putoungne zo kasa yai ganene.” ");
INSERT INTO zia_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ayero sewa giro awong eno abena eyero sena, “Niye ture iyari yero noi giro eyero sinowa, ‘Ture gori iwaing ziwero sawiya, arere awiro wari witariniya.’ ");
INSERT INTO zia_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ora iya gari noi giro eyero sinowa, ‘Bereze siwingniya, arare yeme wa diyariniya.’ Niye berezera susuwa gosinowa, arata be euna susuwa emi zo niye oko gao yero neya ara. ");
INSERT INTO zia_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Niye emo memeko-mameko. Emo mene bauno daigatinowa, deka ayao ine niye Tuwa Bayau daigatinowa. Niye tani putoungne zo yana gari sinowa. Arata niye tani putoungne zo oko yana garineya. Tani gitau Yonana una atu kasa yena deka ayao ine kasa yai garineya.” Yesu mene ayero sero awong yangdoro buro-mani nuna aune dema bamuwa arauwa. ");
INSERT INTO zia_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesura buro-mani awong ma nuwegairo doro Yesu aune dema ou nazi buwagaiwa ara. ");
INSERT INTO zia_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Buwagairo suwa yero witi ika yewa Yesu mene eyero sena, “Farisayo aune Sadukayo auna yis awiya seung ninae-una goiye sero, niye umo yero baingtiti nasani neupu.” ");
INSERT INTO zia_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ayero senu awong eyero sinasani wina-se yewa, “Ma oko pao doro bumenane aeno sinita nowa.” ");
INSERT INTO zia_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ge auna sinewa nung yetine yero giro abena awong eno eyero sena, “Oiye, tumo diyao besaore niye! Noeno ma doteya auna ungwe-maungwe nei? ");
INSERT INTO zia_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Niye noeno susuwa nana oko gao yero nei? Na ma wawong zo amimene emo 5,000 aeno pugena mineya teng yeti itoto awiya yangtagairo saka nazigo yeteya be bumiye? ");
INSERT INTO zia_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ora ma 7 mene emo 4,000 aeno pugena mineya teng yeti itoto nunae yangtagairo saka nazigo yeteya be bumiye? ");
INSERT INTO zia_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Na ma minao eno oko sesena. Niye noeno oko kotungno baingtao yetei? Farisayo aune Sadukayora yis awiya seung ninae-una goiye sero umo yero baingtiro naese sinena.” ");
INSERT INTO zia_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ge awiya tugata yenu awong nigiro eyero sewa, “O, nung ma minaora yis aeno oko sesiya. Farisayo aune Sadukayora gipao ge nunae aeno sesiya.” Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu nung napo Sisaria-Filipai auna tawingna kasa yero buro-mani nuna atata yero sena, “Emo awong na Emora Mani aeno awe sero nei?” ");
INSERT INTO zia_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ayero senu awong nung eno eyero sewa, “Ena mene ning maze Yohane ge ou zayero suwao emo ayero sero nowa, asinowa ena mene Eliya ayero sero nowa, ena mene zo Yeremiata porofete gitau nasani nauwa auna zo, ayero ning eno sinowa ara.” ");
INSERT INTO zia_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ayero sewa giro nung nupema awong atata yero sena, “Ora nika niyetope na awe sero nowi?” ");
INSERT INTO zia_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ayero senu giro Simon Petoro mene abena eyero sena, “Ning Sorao Emo nanae Kristo. Ning Tuwa Bayau putoungne auna Mani ara.” ");
INSERT INTO zia_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ayero senu Yesu mene abena eyero sena, “Simon Yonana mani, ning yawa yawa yase. Noeno okowata, ge me sesesa awiya emora mokora atu oko kasa yero noiya. Uritira Mama nana mene sero keregai sinesa ara. ");
INSERT INTO zia_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Arare na yazo nina sekawa zo sinena: Ning Petoro. (Ge naname-una Daba.) Arare nane daba tame atu dubu nana pugatinana garo ine kasa yero babariniya. Ayero yana mekora putoung mene awong puro wosari yai teng oko yariniya. ");
INSERT INTO zia_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ayero yero na uritira napo auna ki awiya ning eno pugarinena. Arare ning nona zo tawingna etu awang sasa giro nona awiya Tuwa Bayau mene uritira atu deka ayero awang sariniya. Arata ning nona zo tawingna etu gasa teng yai giro nona awiya Tuwa Bayau mene uritira atu deka ayero gai teng yariniya.” ");
INSERT INTO zia_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ayero sero buro-mani nuna eno ge tauyao sinasani eyero sena, “Na Sorao Emo ninae Kristo nena awiya emo eno oko sae.” ");
INSERT INTO zia_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Be auna atu Yesu mene zayero nona nuna-una ago kasa yarinena auna ge buro-mani nuna eno sero keregairo eyero sena, “Na Yerusalem nape witana emo gitau yao aune pirisa babuze aune sao tauyao ge gipao emo awong amimene yaya-biyaya na eno pugatinete na iwora waweng pugaya daya magayariena. Magayero wari be etama aung yai aune nupema seka yero iroparinena.” Ayero sero aune tani nuna-una ago kasayariniya auna ge apakana tugata yero sero aung yena ara. ");
INSERT INTO zia_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ayero senu giro Petoro mene nung yuno ewe baungno aune awang sinasani eyero sena, “Tuwa, Tuwa Bayau mene nigai nona ayao oko kasa ye nina-una gaise.” ");
INSERT INTO zia_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ayero senu Yesu mene kapetegairo Petoro eno abena eyero sena, “Sanda, ning awiya Tuwa Bayaura ge okowata, emora ge niya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Be deka aune Yesu mene buro-mani nuna eno eyero sena, “Zo nung na ago yari yero giro aratamao nuna apakana doro dubo minaore yaya tamaore auna i pasao nuna diungno na ago yaise. ");
INSERT INTO zia_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Noeno okowata, zo nung nao nuna tawingna awiya sorero puro nari kotumariniya auna teng nao nuna awiya aung yariniya. Arata zo nung na eno yero giro nao nuna duwariniya amimene nao iwaing tamariniya. ");
INSERT INTO zia_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Zo nung tawingna nona iwaing apakana awiya pupunariniya, arata nao nuna aung yariniya, awiya nona nomi nuna-una mitariniye? Ora nao nuna kapetegaise kotungno zuma no pugai aune nao nuna awiya abena kapete nuna-una gariniye? Aung ara. ");
INSERT INTO zia_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Na Emora Mani mene Mama nana-una waegaore angelo dubu nuna aune dema wosiro emo bauno apakana auna nao nunae-una teng abena pugarinena ara. ");
INSERT INTO zia_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Na meba sane: Emo ena etu dopero miteya amimene oko magayao mitaya na Emora Mani mene tawing sero sero auna Tuwa yero nete daung-mokera kasayana gariney. ");
INSERT INTO zia_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yesu mene wari be 6 nete Petoroto Yakobo aune meta nuna Yohane awong pungnu awong nata diri baina zora witiro bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ayero yero atu benaung nunae-una dodopinasani benaung nuna zo ewe yena ara. Ayero nasani benaung nuna warira waegao ayao ine waegaina ara. Nupema taung wori nuna awiya neyangyero zayang zayang yena ara. ");
INSERT INTO zia_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ayero nenu Moseto Eliya mene wosiro nuna-una nugu kasa yero nung aune dema ge ungwe-maungwe nasani mitiwa Petoro otao etore mene gigiwa ara. ");
INSERT INTO zia_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ayero gigiwa Petoro mene Yesu eno eyero sena, “Tuwa, nae etu mitenane awiya iwaing. Arare nigasa na kouboga etama sinane — zo nina, zo Mosera, zo Eliyara.” ");
INSERT INTO zia_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ayero sinenu bereze waegao bainane zo wosiro awong worena. Ayero yenu aune ge zo bereze mokora atu eyero kasa yenu nigiwa, “Awiya Mani bouwa nana. Na nung eno yawa yawa nena. Niye ge nuna nigipu.” ");
INSERT INTO zia_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Buro-mani mene ge awiya nigiro diti benaung nunae worero puro pu tawingna gairo awang yero ipinasani mitiwa ara. ");
INSERT INTO zia_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ayero newa Yesu mene nunae-una nugu baungno awong initinasani eyero sena, “Niye iropungpu, awang oko yepu.” ");
INSERT INTO zia_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ayero senu awong diti pagairo Yesu gege gigiwa ara. ");
INSERT INTO zia_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Arare diri atu wowosinewa aune Yesu mene eyero sena, “Nona benaung sekawa zo gigeya auna ge bowi emo zo eno oko sarineya. Mama mene na Emora Mani awiya uwai magayaora atu seka yero iropana aune ge bowi awiya sarineya.” ");
INSERT INTO zia_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ayero senu giro buro-mani nuna mene nung atata yero sewa, “‘Eliya gitau bumai aune Kristo bumariniya,’ awiya sao tauyao ge gipao emo mene noeno ayero sinowi?” ");
INSERT INTO zia_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ayero atata yewa giro abena eyero sena, “Eliya nung meba gitau kapetegairo tawingna nao meko awiya apakana korayai aune Kristo bumariniya, awiya ge meba ara. ");
INSERT INTO zia_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Arata sana nigipu. Eliya nung yemaoko kasa yero naunu emo bauno mene susuwa nuna gigiwa oko kasa yao yenu nung eno tani tebe-tabe yewa ara. Arare awong na Emora Mani deka ayero puro dedunasani gainasani ayero yarineya ara.” ");
INSERT INTO zia_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ayero senu awong nung Yohane ge ou zayero suwao emo aeno sena awiya gigiwa arauwa. ");
INSERT INTO zia_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Awong diri atu wowosinete emo bauno dubu baina auna una kasa yewa aune emo zo mene buro Yesura nugu atu koing gairo eyero sena, ");
INSERT INTO zia_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Tuwa, ning mani nana eno yo aung. Nung be ozaung angzi apunasani yaya baina tapunoiya. Nung iyaora zuwero nasani oura gutero nasani ayero noiya ara. ");
INSERT INTO zia_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Arare na buro-mani nina eno puro bumena kora yari teya teng oko tiya.” ");
INSERT INTO zia_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ayero senu Yesu mene abena eyero sena, “O niye emo bauno meko, tumo diyao aung. Na be nazigo niye aune dema narineni? Mani puro nana-una bungpu.” ");
INSERT INTO zia_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ayero senu awong mani puro bumuwa nung iwae gona yero ge senu mani doro baungnu mani mena iwaing yena ara. ");
INSERT INTO zia_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Arare buro-mani nuna mene awong gege nata mitasani aune nung atata yero sewa, “Nae nono yero iwae tunaora buro yetenane teng oko yao yetiye?” ");
INSERT INTO zia_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ayero sewa abena eyero sena, “Tumo diyao ninae besao aeno teng oko yao yetiya. Na meba niye eno sana nigipu. Tumo diyao ninae awiya i me maingkoka zo ine iropuro baina yariniya, amimene zo niye diri eeno, ‘Ning etu zokero otu baung!’ ayero saya, zokero babariniya. Tumo diyao ayao awiya ninae-una mitai niye buro baina yao teng ara. ");
INSERT INTO zia_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Iwae ayao tunao awiya nona zota zo mene oko niya ara. Isa saore nona seminaore mene gege tunao teng ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Buro-mani nuna nawe apakana Galilaya tawingna atu nuna-una au dekaongna gaiwa aune Yesu mene eyero sena, “Nanane aune na Emora Mani awiya emora waweng pugaya ");
INSERT INTO zia_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","daya magayana wari be etama aung yai aune Mama mene na uwai iropari nena ara.” Ayero senu buro-mani awong nigiwa dubo nunae mou yena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu buro-mani nuna aune Kapaneam nape kasa yewa emo ena Tuwa Bayaura ibu baina aeno takis buro nasani nauwa amimene Petoro atata yero sewa, “Gipao emo ninae mene ibu bainana takis 5O toya awiya pugatinoita?” ");
INSERT INTO zia_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ayero sewa Petoro mene eyero sena, “Yore, pugatinoiya ara.” Ayero sero nung nupema tera Yesura una gare witiro ge awiya oko keregao nenu Yesu nung nuka nutope Petoro atata yero sena, “Simon, susuwa ewiya gasa nono yai giro abena se gane: Tawingna emo tuwa awong ana-una atu takista kastam pupunowi, dubu nunae unata dubu zora una ing?” ");
INSERT INTO zia_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ayero senu Petoro mene eyero sena, “Dubu zora una.” Ayero senu Yesu mene eyero sena, “Iwaing sinesa, arare emo tuwara dubu awong takis pugaese sao oko mitiya. ");
INSERT INTO zia_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Arata saineba, awong name eno kotumaya meko yao eno, ning ou nazira baungno angsi augairo wo zo gitau dumarinesa awiya watimasa witai be nuna inasa zanai kina zo tamarinesa. Awiya ibura takis moni nanao ayero sero puro baungno awong eno pugasa teng yae.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Wari be aune buro-mani nuna awong nuna-una baungno atata yero sewa, “Uritira mitoiya amimene nata Tuwa yero nai aune awe mene gitau yao baina yero nariniye?” ");
INSERT INTO zia_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ayero sewa Yesu mene mani maingkoka zo senu bunu nunaeuna towang atu pugairo ");
INSERT INTO zia_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","eyero sena, “Na meba niye eno sane. Niye dubo kapetegairo mani mamanikakara nao ine oko yero narineya, awiya uritira mokora oko towarineya. ");
INSERT INTO zia_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Zo nung dubo nuna puro wosiro mani eyao ine yero nariniya, nung amimene Tuwa Bayau nata Tuwa yero nai aune emo gitau yao baina yariniya. ");
INSERT INTO zia_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Arare zo nung na eno nasani mani eyao ine zo kora yariniya, nung amimene na kora yetiya ayao ine yariniya arauwa. ");
INSERT INTO zia_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Zo nung mani mamanikaka na tumo didinowa auna zo yumai pasena tamoiye sero, niye bere-bere daba bainakama zo emo auna dube kimegairo wito kurura teugaipu gutero babai teng yariniya. Noeno oko, emo amimene pasena oko yaore oura gutero magayariniya, awiya nona eo yao gege. Arata nung pasena yai aune Tuwa Bayau mene abena pugariniya, awiya nona mou-mesa yao. ");
INSERT INTO zia_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Pasenana yumao benaung giti amimene kasa yero emo bauno yumai pasenana zuwarineya. Arata zo nung emo bauno pasenana yumariniya amimene meko yaise. ");
INSERT INTO zia_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Arare wawong nina zo meneta te nina zo mene pasena yasese yai giro kapero yangdo. Nao me iwaing pumari kotungno giro wawong dekaongkare gege o te dekaongkare gege nete nao me iwaing topetasa teng yariniya. Arata tere wawongne zere tutupore deka ayero puro nasa ago ning iyao tauyao awao gege awinoiya auna augaya babasa teng oko yariniya. ");
INSERT INTO zia_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ora diti moko nina zo mene pasena yasese yai giro zokero yangdo. Nao me iwaing pumari kotungno giro diti moko dekaongkare gege nete nao me iwaing topetasa teng yariniya. Arata etobe deka ayero puro nasa ago ning kowa iyaore auna augaya babasa teng oko yariniya. ");
INSERT INTO zia_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Niye mani-mamani nana zo gaya oko wosao yaise. Awiya susuwa eeno sinena. Angelo nunae uritira atu nowa awong uritira Mama nana auna benaungna kasa nasani mani nunae-una ge ungwe yero nowa. ");
INSERT INTO zia_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Na Emora Mani mene emo tiri-tara yao awiya kau yero tamari sero wosiwang. ");
INSERT INTO zia_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ora ge zo sana kotungno abena sepu gane. Emo zo lama nuna 100 nunae-una zo mene tara yai giro yangduwarinita? Aung ara. Nung lama 99 nona mininasani miteya awiya doro baung eu ware yero tara yao amaze kau yariniya. ");
INSERT INTO zia_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na meba sana. Nung baungno kau nete taungno aune 99 oko tara yao awong aeno okowata, tara yeti tamiya awiya eno dubo iwaing yariniya ara. ");
INSERT INTO zia_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Arare deka aine uritira Maung ninae mene mani-mamani nana nunae-una zo mene Maungna una gomara atu tara yoiye sero sinoiya arauwa. ");
INSERT INTO zia_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Otao nina zo mene pasena nina yai giro ning baungno nito nata adungno meko nuna gipe gae. Ayero yasa nung ge nina nigiro kotumao nuna iwaing tamai nupema otao wina-ye yarineyato. ");
INSERT INTO zia_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ora ge nina dai giro doro baungno emo dekaongkata etobe ayao awiya puro nupema tera nuna-una babaya awongto dema susuwa nuna gosinasani ge nito sarineyato awiya nigaeto. ");
INSERT INTO zia_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ora ge ninae teng deka ayero dai giro dubu nana-una benaungna atu keregai gae. Dubura ge deka ayero dai giro niye gaya nung emo meko, diga emota takis pumao emo ine yaise. ");
INSERT INTO zia_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Na memoko sane. Niye tawingna etu tairo diyaya giro Tuwa Bayau mene deka ayero uritira atu tairo diyariniya. Ora tawingna etu besaya giro Tuwa Bayau mene deka ayero uritira atu besariniya. ");
INSERT INTO zia_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","O zo susuuno sana nigipu. Ninae-una etobe mene nona zo eno dubo nunato dekaongka tiyayato dekaongka yai isa sayato giro uritira Mama nana mene isa nunato nigiro auna teng pugariniya. ");
INSERT INTO zia_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Noeno oko, emo etobeta etama awong yazo nana-una augaya giro na nunae-una towang atu narinena.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yesu mene ge ayero senu Petoro mene atata yero sena, “Tuwa, otao nana zo mene na eno pasena nai na be nazigo ayao awiya pasena nuna yangduwari neni? Be 7 ayao awiya yangduwana teng yarinita?” ");
INSERT INTO zia_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Atata yenu Yesu mene abena eyero sena, “Na be 7 ayao yangduwasese oko sinena. Ning be daigairo nibamu 70 taims 7 ayao ine yangdotinasese sinena. ");
INSERT INTO zia_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Tuwa Bayau nata Tuwa yero nariniya auna susuwa amaze na emo tuwa zora pugairo sana nigipu. Emo tuwa zo mene mani sou dubu nuna abena nuna abena pugaese ge buro awiya zayena. ");
INSERT INTO zia_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Arare ge buro zayero sou mani bunaese senu nunae-una zo abena nuna 10 milion kina amimene emo tuwara una kasa yena. ");
INSERT INTO zia_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nung abena nuna baina awiya pugaine yao teng oko yenu giro emo tuwa mene eyero sena, ‘Emo erita bauno maingne nuna arita wo nuna nona wau nuna awiya apakana emo mene zuma gaero pumaya na moni tamane.’ ");
INSERT INTO zia_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ayero senu soumani mene emo tuwara una koing gairo isa sinasani eyero sena, ‘Emo tuwa nana, ning na ao-diyasa abena nina pugarinena.’ ");
INSERT INTO zia_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Isa senu emo tuwa nung yo-auno giro ao-diro abena nuna baina awiya yangduna. ");
INSERT INTO zia_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ayero yenu nung gare atu wosiro baungno soumani otao nuna zo tauna, nung awiya nuna-una abena nuna 100 kina mitina. Nung amaze taungno dubo iniro dedunasani eyero sena, ‘Abena nana yemeneka keeune mena pugai!’ ");
INSERT INTO zia_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ayero yenu otao nuna nuna-una koing gairo nung eno isa sinasani eyero sena, ‘Ning na ao-diyasa abena nina pugarinena.’ ");
INSERT INTO zia_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nung eno isa senu ge nuna oko nigao yero baungno senu otao nuna eno eyero sinasani bunao gare pugaiwa, ‘Abena nuna pugairo aung yero aune kasa yarinesa.’ ");
INSERT INTO zia_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ayenu otao mani nuna mene giro moko nunae meko yenu baungno emo tuwa eno ge ungwe yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ge ungwe yewa emo tuwa mene nigiro soumani awiya nupema yau senu bunu eyero tugata yena, ‘Ning emo meko nibamu amaze sina. Ning na eno isa sesesa na ning yo-aungno giro abena nana baina awiya ning eno dotena. ");
INSERT INTO zia_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Arare na ning ao-diyena ayao ine ning deka otao nina eno yo-aungno ao-diyatesa, awiya teng yatiya.’ ");
INSERT INTO zia_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ayero sero dung yero tini kapenu gorobo emora waweng pugairo eyero sena, ‘Niye bunao meko nibamu nung eno pugaipu, nasani aune nung abena nana baina awiya pitiro aung yai aune yangduwarineya.’” ");
INSERT INTO zia_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu mene ayero sero ge ewiya susuuno sena, “Arare niye dubo eo-yaore pasena wina-yangduwao oko yao yaya uritira Mama nana mene nona mou-mesa yao deka ayao niye eno yariniya arauwa.” ");
INSERT INTO zia_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu nung ge noyao benaung giti awiya sero aung yero Galilaya tawing doro Yudaya tawing agewa ou Yodan deung enabara mitina atu baungna ara. ");
INSERT INTO zia_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bautu nenu emo bauno dubu baina mene nung ago yewa ara. Tawing auna atu newa nung emo yayare kora yena ara. ");
INSERT INTO zia_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Atu nenu Farisayo nung gaero gari sero kasa yero nung atata yero sewa, “Zo nung bauno nuna susuwa zota zo eno yero yangduwai teng yarinita?” ");
INSERT INTO zia_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ayero sewa nung abena eyero sena, “Niye Tuwara ge eyero mitiya awiya oko zazagairo gao mene saine neya, awiya! Yaora Maung mene nung tawing zayaora atu emo yari nasani emore baunone teng yena. ");
INSERT INTO zia_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yero aune eyero sena, ‘Arare emo mene ai maung nuna yangdoro bauno nuna aune dema gauno baingtiro awongto dubore taungne dekaongka yero narineyato.’ ");
INSERT INTO zia_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Arare awongto etobe okowata, dekaongka yero narineyato. Tuwa Bayau mene awongto pu dekaongna gainu atiwato, arare emo mene oko kapaese.” ");
INSERT INTO zia_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ayero senu awong abena eyero sewa, “Ayao siya, awiya Mose mene noeno eyero seni, ‘Emo zo mene bauno nuna yangduwari yero giro igi pugairo sai babaise.’ Mose mene noeno ayero seni?” ");
INSERT INTO zia_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ayero sewa Yesu mene abena eyero sena, “Mose nung niye Tuwa Bayaura ge nigao awang gaung yero nauwa susuwa aeno wina-yangduwaora ge sewa nigina ara. Arata zayaora atu nagibo ayao ine zo oko mitauna. ");
INSERT INTO zia_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Arare nane sana nigipu. Zo nung bauno nuna yangdoro zo atariniya nung amimene susumao nunato awiya kapero nung kuma yetiya aine yariniya. Arata bauno nung emo zore nete meko yero nai aune emo zo mene atiro aune awang sariniya, awiya wina-yangduwaora pasena awiya bauno mene dimariniya. Emora oko yariniya.” ");
INSERT INTO zia_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ayero senu buro-mani nuna mene eyero sewa, “Arare sao auna susuwa ayero mitai giro name bauno aung nao amimene zo iwaing mitaora nagibo ara.” ");
INSERT INTO zia_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ayero sewa Yesu mene abena eyero sena, “Emo dubu baina mene ge amaze nigiro pu dube gao ine aung. Emo putoung mena pugao pumao gege mene puro pu dube garineya. ");
INSERT INTO zia_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Emo ena aira tiyangna atu kasa yero bauno ataine yao teng oko somono nowa; ora ena awiya emo mene taung aingso nunae gera nowa bauno oko atao yero nowa; ora ena mene zo uritira ge eno bauno oko atao somono nowa. Arare zo auna putoung mitai giro ge ewiya puro pu dube gaise.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Emo bauno awong mani mamanikaka nunae puro baung Yesura una yero wawong paka ziye yero isa saise sewa. Ayero yewa buro-mani nuna mene emo bauno awang sewa ara. ");
INSERT INTO zia_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Awang sewa giro Yesu mene eyero sena, “Niye mani mamanikaka yangdopu nana-una bumae. Nagibo nunae oko gazae. Ayao amimene uriti napora gerao.” ");
INSERT INTO zia_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ayero sero wawong nuna paka ziyo nunae-una yero awong gao yena. Ayero yero aune tawing awiya doro baungna ara. ");
INSERT INTO zia_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Emo zo mene Yesura una kasa yero atata yero sena, “Gipao emo, na buro iwaing zo nomaze yero aune nao me iwaing tamarineni?” ");
INSERT INTO zia_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ayero senu Yesu mene eyero sena, “Nona iwaingna susuwa gari sero noeno na atata nesi? Iwaingna susuwa auna Maung awiya dekaongka gege niya. Arare ning nao me iwaing auna gerao yari yero giro sao tauyao ge nuna diung.” ");
INSERT INTO zia_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ayero senu giro nung sao tauyao ge awiya noiye ayero sinasani atata yenu Yesu mene eyero sena, “Na sao tauyao ge eyao eno sinena: ‘Ning emo oko dasa magayae. Ning kuma oko yase. Ning ugaing oko yase. Ning emo zo gera pugatinasani ge oko iwase. ");
INSERT INTO zia_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ning ai maung nina-una ge diung. Ora ning nika nitope aratapunosa, deka aine emo ena eno ye.’ Amaze sinena ara.” ");
INSERT INTO zia_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ayero senu emo taung seka amimene abena eyero sena, “Awiya yemaoko otu mena diungno butunona. Arare zo nono yero yana teng yariniye?” ");
INSERT INTO zia_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ayero senu Yesu mene eyero sena, “Ning etutero nari kotungno giro baungno nona nina apakana pugasa emo mene zuma gaero pumaya wau moni nina awiya emo bogamasa eno bono yasa pumae. Ayero yasa wau nina uritira atu mitariniya. Ayero yero aune ning buro na ago yase.” ");
INSERT INTO zia_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ayero senu emo taung seka amimene ge awiya nigiro kotung-katung nasani doro baungna. No eno oko, wau moni nuna witao. ");
INSERT INTO zia_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Baungnu Yesu mene buro-mani nuna eno eyero sena, “Na memoko sane. Emo wau moni bainane mene uritira towari nete buro bainakama yariniya. ");
INSERT INTO zia_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Na nupema sane. Wo kamel mene zai mo gayao auna enora towao awiya teng oko. Deka ayero emo wau moni bainane mene Tuwa Bayaura napo auna babao awiya deka teng oko.” ");
INSERT INTO zia_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ayero senu buro-mani awong ge awiya nigiro yangka sero eyero sewa, “Arare awe mene uritira baungno nao me iwaing tamao teng niye?” ");
INSERT INTO zia_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ayero sewa Yesu mene awong anuwing nasani eyero sena, “Awiya emo mene yao ine teng oko. Arata Tuwa Bayau mene ayero yai teng yariniya.” ");
INSERT INTO zia_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ayero senu Petoro mene bera puro eyero sena, “Ayero nae nona nanae apakana nuwe gatigairo ning ago nonane. Arare nete auna abena no nanae-una kasa yariniye?” ");
INSERT INTO zia_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ayero atata yenu Yesu mene eyero sena, “Na memoko sane. Nete nona apakana seka yero iwaing kasa yariniya be aune na Emora Mani mene adumao masi simaore nana-una atu adungno mitana na ago yewa niye deka ayero emo tuwara adumao masi 12 auna atu mitasani aune Isreli emo dubu 12 amaze awega-ziwega yarineya. ");
INSERT INTO zia_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Arare zo nung na eno nasani metamani o nu ai amono, o meto mani, ai maungne mani awiso, o napo, o tawing yangduwariniya — nung amimene abena nona daigairo ipu ewa-gaewa yao puro auna tame nao me iwaing dema maung yariniya ara. ");
INSERT INTO zia_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Arare emo gitau neya awena-una ena mene ago yarineya. Ora ago neya awong auna ena mene gitau yarineya. ");
INSERT INTO zia_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Tuwa Bayau nata Tuwa yero nari niya auna susuwa awiya wain burora maung zora pugairo sane. Wain burora maung zo mene wain buro nuna eno kotungno giro buro emo pumari gora-gara baungna. ");
INSERT INTO zia_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ayero yero ena puro buro be dekaongka auna zuma nuna K1.00 ayero keregainu gigiwa teng yenu giro buro nuna-una iyengtinu bamuwa. ");
INSERT INTO zia_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Wari witiro 9 kilok nenu nung nupema baungno emo ena napo kakame atu tebeba newa giro eyero sena, ");
INSERT INTO zia_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‘Wain buro nana mitiyare niye baungno buro yaya zuma teng pugarinena.’ ");
INSERT INTO zia_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ayero senu giro wain buro nuna-una bamuwa ara. Ayero yero 12 kilok aune mani ena puro 3 kilok nupema ena puna. ");
INSERT INTO zia_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ayero 5 kilok nupema baungno emo ena buro aung newa taungno giro eyero sena, ‘Niye noeno wari eune buro oko yao timara neya ture itiniye?’ ");
INSERT INTO zia_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ayero senu awong abena eyero sewa, ‘Awong buro ge zo nae eno oko sao.’ Ayero sewa giro nung awong iyengtiti nasani eyero sena, ‘Wain buro nana-una buro mitiya arare baungpu yae.’ ");
INSERT INTO zia_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Burora maung mene ayero nenu ture inu buro diya yao emo nuna yau senu bunu eyero sena, ‘Ning buro emo au dekaongna gairo zuma pugai pumae. Ago kasa yeteya atu zayero pugairo bautunete gitau kasa yeteya atu besugai.’ ");
INSERT INTO zia_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ayero senu giro ago bumuwa awiya senu bumuwa K1.00 pugairo aung yena. ");
INSERT INTO zia_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pugainu gitau bumuwa awong giro eyero kotupunewa, ‘Zuma puro witiro pugariniya.’ Ayero sinasani mitiwa, arata diya mene K1.00 dekaongka amaze awong eno pugaina. ");
INSERT INTO zia_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pugainu puro gugumama sinasani burora maung eno kotumuwa meko yena. Ayero nasani eyero sewa, ");
INSERT INTO zia_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Ago bumeya awong buro wan aua gege yeteya. Arata nanae mene zo wari baina auna atu yaya kokoni yao tapunenane ture iya, awiya ning noeno ago bumeya aeno zuma teng ayero pugatinesi?’ ");
INSERT INTO zia_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ayero sewa burora maung mene nunae-una zo eno eyero sena, ‘Otao, na niye eno oko meko nena. Na K1.00 sesena nigesa teng yetiya. ");
INSERT INTO zia_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Arare moni nina puro baung. Na ago beya awiya ning eno teng ayero pugari kotumena teng yetiya. ");
INSERT INTO zia_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nona nana ware, eyerota ayero yana teng yariniya. Ning bayao nana-una awong eno dubo mou tapunesita?’” ");
INSERT INTO zia_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu mene ungwe awiya diro besugairo ge susuuno eyero sena, “Arare ago neya amimene gitau yarineya. Ora gitau neya amimene ago yarineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu nung Yerusalem nape babari sero wiwitinete aune buro-mani nuna 12 awiya gege puro baung ewe yero aune awong nuka nuye gege nagibe atu bautunasani eyero tugata yena, ");
INSERT INTO zia_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Sana nigipu. Name Yerusalem babari wiwitinenane. Atu kasa yanane aune awong na Emora Mani awiya pirisa babuze aune sao tauyao ge gipao emora waweng pugaya na magayanese sarineya. ");
INSERT INTO zia_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Magayanese sero na puro emo Yuda okora waweng pugaya na izinasani waung mene dedunasani anete i pasaora daya magayarinena. Magayana wari be etama aung yai aune nupema iroparinena ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Be auna atu Zebedira aro mene mani nuna etobe puro Yesura una nugu baungno koing gairo nona zo eno isa sena ara. ");
INSERT INTO zia_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ayero yenu nung atata yero sena, “Ning no eno sinesi?” Ayero senu giro nukara eyero sena, “Ning sasa mani nana etobe ning Tuwa baina kasa daung yarinesa be auna atu awongto nina una nugu zo wawong mera zo wawong mepora mitaetose.” ");
INSERT INTO zia_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ayero senu Yesu mene abena eyero sena, “Ning ge sinesa auna susuwa oko gosinesa. Na ou dokowang yao zo minarinena, awiya nito teng minarineyato?” Ayero senu awongto sewato, “Yore, teng minarinenato.” ");
INSERT INTO zia_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ayero sewato nung awongto eno abena eyero sena, “Ou dokowang yao zo minarinena, awiya minarineyato. Arata nito nana-una zo wawong mera zo wawong mepora adungno mitarineyato auna ge awiya nane saine yao oko. Mama nana nung dubo nuna mene mani ena kotupunasani masi awiya sosenu mitoiya, arare awong amimene masi auna adungno mitarineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Asewa buro-mani 10 awong ge awiya nigiro otao nunae etobe eno gigiwa meko yena ara. ");
INSERT INTO zia_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Anewa giro Yesu mene awong yau senu bumuwa eyero sena, “Tawingna emo tuwa mene emo bauno awong sou yaese sinowa. Nupema, emo babuze mene emo bauno puro wosiro awong witao nunae ine yero nowa, awiya gosineya. ");
INSERT INTO zia_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ora ninae mene zo ayero oko yae. Ninae-ina zo mene baina yari yero giro enana soremao yero naise. ");
INSERT INTO zia_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ora gitau yao yari yero giro enana soumani yero naise. ");
INSERT INTO zia_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Na Emora Mani mene deka ayero emo bauno na sou yaese okowata, naka natope sou buro nasani nete magayero emo bauno daigairo mekora atu sorero pumari bumuwang.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu buro-mani nuna aune awong Yeriko napo buwagairo doro bautunewa emo bauno dubu baina amimene awong ago yero bamuwa. ");
INSERT INTO zia_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bautunewa emo diti guma yao etobe nagibo deungbera atu adungno mitasani Yesu buro bautuniya ayero sewa nigiro yanakana wawa sinasani eyero sewato, “Tuwa, ning Dawidira sai mene nato eno yo aung!” ");
INSERT INTO zia_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Yanakana wawa sewato emo bauno mene awongto giro sinasani awang sewa ara. Awang sewa awongto nigiro oko nigao ine yero gewera yero wawa sinasani eyero sewato, “Tuwa, ning Dawidira sai mene nato eno yo-aung!” ");
INSERT INTO zia_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ayero sewato giro Yesu mene nagibe atu dopero senu bumuwato awongto atata yero sena, “Na no maze nito eno yanese sineito?” ");
INSERT INTO zia_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ayero senu abena eyero sewato, “Tuwa, diti nanato sasa pagaise sinenato.” ");
INSERT INTO zia_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ayero sewato Yesu mene awongto ka eno yo-auno diti nunato ding yenu mena pagaiwato ara. Ayero yero Yesu ago yewato arauwa. ");
INSERT INTO zia_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu buro-mani nuna aune bautunete Yerusalem nape kasa yari sero nasani aune Betefasi napo Oliwa diri susuwara mitina atu kasa yero Yesu mene buro-mani nuna etobe iyengtiti nasani eyero sena, ");
INSERT INTO zia_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Nito baungno napo maingkoka atu mitiya gosineyato auna toiro baungno wo dongki maingne geta yao miteyato awiya tamarineyato. Taungno geta besero puro bumaeto. ");
INSERT INTO zia_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nito atu nayato zo mene nito atata yai giro abena eyero seputo, ‘Tuwara buro euna mitiya.’ Ayero sayato mena pugariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nona awiya tebeba oko kasa yena. Ge porofete zo mene gitau sena awiya me yaise ayero yena ara. Porofete mene ge eyero gaena, ");
INSERT INTO zia_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Niye napo Zaiyon auna emo bauno eno eyero tugata yepu nigae: Ewiya gipu! Emo tuwa ninae mene ninae-una butuniya. Nung dubo wosaore nasani wo dongki tame adungno butuniya. Nung wo nona-owi dimao auna mani auna tame adungno butuniya. ");
INSERT INTO zia_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Arare mani etobe baungno Yesura ge dipunasani ");
INSERT INTO zia_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","dongki aire maingne puro bumuwato taung wori nunae mene tame ero zuwewa Yesu witina ara. ");
INSERT INTO zia_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ayenu emo bauno daigairo mene taung wori nunae dutugairo birigairo nagibe atu ero zuwewa. Ora ena mene zo i gomi kapero nagibe atu ero zuwewa ara. ");
INSERT INTO zia_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ayero yero emo bauno witao mene gitaure agore gazero bautu nasani wawa sero eyero sewa, “Oro, oro, Dawidira sai. Tuwara bera butunesa, ning awiya bowi yanene. Uritira atu nowa amimene Tuwa Bayau bowi yaese.” ");
INSERT INTO zia_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Asinewa Yesu Yerusalem nape witinu napo susuwa awong zabu-butu nasani eyero sewa, “Awe mene butuni nei?” ");
INSERT INTO zia_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ayero sewa emo dubu baina amimene abena eyero sewa, “Awiya porofete Yesu. Nung Galilaya tawingna Nasarete nape atu kasa yena amimene butuniya.” ");
INSERT INTO zia_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu mene Tuwa Bayaura ibu bainana witiro nona wina-piti nasani mitiwa awong awiya tunena ara. Ayero nasani moni darawa yao emora tewo arita emo ni gumo ibu atu zawing pugao auna buro nasani nauwa auna apa adumao awiya ininu kapetegaina. ");
INSERT INTO zia_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ayero nasani eyero sena, “Ge gayao zo eyero mitiya era, Ibu nana awiya isa saora ibu mitaise. Arata ninae yeteya ibu ewiya ugaing yao emora pungyao masi ine niya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ibu bainana atu nenu emo diti guma yaore asama yaore nuna-una bamuwa kora yena ara. ");
INSERT INTO zia_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ayero yenu pirisa babuze aune sao tauyao ge gipao emo awong tani putoungne nuna gigiwa ara. Nupema, mani mamani mene Tuwa Bayaura ibura atu yawa yawa nasani, “Oro, oro, Dawidira sai,” ayero sewa nigiwa ara. Arare tani putoungne giro mani mamanina ge nigiro awong tini kapena. ");
INSERT INTO zia_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tini kapenu Yesu eno eyero sewa, “Awong emimene ge ewiya sineya nigitinesita?” Ayero sewa abena eyero sena, “Nigitinena. Arata niye ge gayao zo eyao mitiya awiya oko zazagairo gao mene saine neya, awiya! Mani mamanikaka arita mani wuire auna dubo nunae pumasa eo yai nunae-una bera atu bowi yao nina iwaing kasa yariniya.” ");
INSERT INTO zia_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ayero sero awong doro Yerusalem nape atu wosiro Betani nape yero atu awina arauwa. ");
INSERT INTO zia_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesu mene gora-gara napo Betani doro nupema tera Yerusalem witari sero bautunenu meri yena ara. ");
INSERT INTO zia_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ayero yenu nagibo deungbera atu i fik zo dopero mitinu giro i susuwara baungno me kau yero gi gege mitinu giro i aeno eyero sena, “Ning sobe yero me nupema oko iyarinesa.” Ayero sinenu nuna bera i awiya gi nuna irara yenu soyena ara. ");
INSERT INTO zia_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ayenu buro-mani nuna awiya giro wawong di gauno eyero sewa, “I awiya nung nono yero mena soyetiye?” ");
INSERT INTO zia_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ayero sewa Yesu mene eyero sena, “Na memoko sane. Niye dubo eto oko yao tumo diyao mere dema narineya amimene tani ira atu kasa yetiya ayao awiya ninae yarineya. Awiya gege oko, niye diri oeno eyero sarineya, ‘Diri, ning zokero witora gute.’ Ge sarineya, auna teng kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ayero yero tumo diyao mere dema nasani aune nona zota zo no eno isa saya kasa yariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu mene bautunete Tuwa Bayaura ibu bainana witiro emo bauno uritira ge gipinasani mitinu pirisa babuze aune Yuda emora simai amimene nuna-una baungno nung atata yero sewa, “Ning tani ena yero nosa awiya ana bera yero nosi? Awe mene ning eno senu yero nosi?” ");
INSERT INTO zia_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ayero sewa Yesu mene ge abena eyero sena, “Na niye eno atata zo yarinena. Niye abena na eno sarineya, awiya na deka ayero ana bera tani ayero yero noni auna susuwa sarinena. ");
INSERT INTO zia_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yohane ge ou suwao buro nuna awiya ana bera nauni, emora berata Tuwa Bayaura bera ing?” Ayero sinasani atata yenu awong ge no sarinenine ayero sinasani dubo gagausewa ara. Ayero yero nuka nuyetope ge wina-se nasani eyero sewa, “Name ‘Tuwa Bayaura bera’ ayero sarinenane, awiya nung eyero sariniya, ‘Arare niye noeno ge nuna oko nigao yewi?’ ");
INSERT INTO zia_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Name ‘Emora bera’ ayero satenane, arata emo bauno mene name eno iwo yowi sero awang nenane. Noeno oko, awong Yohane gosinauwa porofete me yero nauna.” ");
INSERT INTO zia_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ayero sero Yesu eno eyero sewa, “Nae oko gosinenane.” Ayero sewa Yesu mene ge abena eyero sena, “Arare na deka ayero ana bera tani ewiya yero noni auna susuwa oko sarinena.” ");
INSERT INTO zia_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu mene eyero sena, “Ungwe diyana nigiro sepu. Emo dekaongkara mani etobe nasani nauwato ara. Arare maung mene mani zo eno eyero sena, ‘Mani, ning yeme baung wain buro yase.’ ");
INSERT INTO zia_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ayero senu abena sena, ‘Aungwa. Na bure oko babarinena.’ Ayero sero nete dubo darawa yero bure baungna. ");
INSERT INTO zia_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Bautunenu maung mene nupema mani zo eno ge dekaongka kamaze tugata yero sena ara. Senu giro mani zo amimene abena eyero sena, ‘Yore, nakara yarinena.’ Ayero sero oko babao kara mitina. ");
INSERT INTO zia_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Arare niye mani awe mene maung nuna-una ge diungna ayero sarinei?” Atata ayero yenu awong eyero sewa, “Mani ge gitau sena.” Ayero sewa Yesu mene eyero sena, “Na memoko sane. Takis pumao emore towangna baunone awong Tuwa Bayau nata Tuwa nunae yaise sero gitau nasani nuna-una mokora toitinaya ninae mene zo ago yari neya. ");
INSERT INTO zia_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Noeno oko, Yohane kasa yero etutero naora nagibo niye eno gipenu niye ge nuna awang yero yangduwa takis pumao emore ugaing baunone mene ge nuna nigiwa ara. Ayero yewa niye gigiwa, arata niye dubo oko darawa yao, o ge nuna oko nigao yewa.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu mene eyero sena, “Na ge eniya zo sana nigipu. Emo baina zo mene tawing zora wain urero goma gaero ziuna. Ayero yero wain me mozaora kote baina zo wauno wain buro diya yao emora garo dema yero ayena ara. Ayero aung yero emo ena mene wain buro nuna diya naese sero nung tawing zo ake nibamu auna baungna ara. ");
INSERT INTO zia_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Baungno nenu wain paora be bunu giro nung me ena pumari kotungno soumani nuna ena iyengtinu baungno diyara una kasa yero sewa giro ");
INSERT INTO zia_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","diya mene iropuro soumani zo puro dero musuna-masuna yewa, ora zo maze zo dewa magayena, ora zo awiya daba mene dewa ara. ");
INSERT INTO zia_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ayero yewa burora maung mene nigiro nupema soumani daigairo pugatinaunu bautunauwa nao deka ayao awong eno yero nauwa ara. ");
INSERT INTO zia_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ayero nawe duwa giro nung mani yo diyang nuna nibamu amaze eyero kotupu nasani iyengtina ara. ‘Mani nana baungno kasa yai awong giro ge nuna dimarineya,’ ayero sero iyengtinu baungno kasa yenu ");
INSERT INTO zia_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","diya mene mani nuna yo diyang nibamu awiya giro eyero sinasani wina-se yewa ara, ‘Nung amimene nete tawing euna maung yariniya. Arare bungpu, name mani ewiya danane magayai tawing ewiya naname yae.’ ");
INSERT INTO zia_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ayero sero nung bure atu musuna-masuna nete puro baungno goma bautara atu dewa magayena ara.” ");
INSERT INTO zia_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu mene ayero sero susuuno eyero sena, “Arare burora maung nung kasa yero buro diya yao emo eno nono yariniye?” ");
INSERT INTO zia_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ayero senu awong eyero sewa, “Nung emo memeko-mameko awiya dai oena-paena nete magayarineya ara. Ayero yero diya iwaing ena buro nuna-una pugai awong me kasa nai giro me puro buro maung eno pugati nasani narineya.” ");
INSERT INTO zia_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ayero sewa Yesu mene ge eyero susuuno sena, “Uritira ge gayao zo eyero mitiya, awiya niye zazagati nowita? Garo yao emo mene daba zo gigiwa meko yenu yangduwa ara. Arata daba amimene garo autura ziwong yero mitoiya. Nona awiya Tuwara bera kasa yena, arare emo mene gigenane iwaing niya arauwa. ");
INSERT INTO zia_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Auna sana nigipu. Tuwa Bayau nata Tuwa yero nao auna nagibo awiya ninae-una atu sorero puro dubu zo eno pugarinena. Ayero yana awong buro yero me puro maung eno pugarineya. ");
INSERT INTO zia_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Zo nung daba auna tame atu zuwariniya amimene bezariniya. Ora daba amimene emo zora una tame zuwariniya, awiya emo awiya dai bezero pusupasu yero mamanikaka yariniya.” ");
INSERT INTO zia_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ge eniya ayero senu pirisa babuze aune Farisayo emo awong nigiro eyero sewa, “Oiye, nung name eno siniya.” ");
INSERT INTO zia_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ayero sero puro bunari kotungno aune emo bauno mene Yesu nung porofete ayero sero nauwa giro awong emo bauno awang yero yangduwa arauwa. ");
INSERT INTO zia_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu nung ge eniya zo nupema susuuno sena, ");
INSERT INTO zia_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Uritira mitoiya amimene nata Tuwa yero nariniya auna susuwa awiya emo tuwa zo mene mani nuna bauno pumaise sero ana-bonene yena auna pugairo sane. ");
INSERT INTO zia_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nung nona sosero buro-mani iyengtinu awong baungno emo bowi mena tugata yena awong awiya yuno puro bari bamuwa ara. Baungno sewa arata awong yangduwa. ");
INSERT INTO zia_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Yangduwa giro emo tuwa mene buro-mani ena nupema tera iyengtiti nasani eyero sena, ‘Niye baungno emo bowi sao awiya eyero tugata yepu: Na kara nona sosetena mitiya. Wo bulimakao babuzere mamanikaka gawire awiya dema sesena dero aero yeteya ara. Ayero yero nona ewezo nibamu kora-makora yero aung yeteya ara. Arare niye bumaya name emo eno bauno pugati nasani nona mininasani yawa yawa yanene.’ ");
INSERT INTO zia_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Emo tuwa mene ayero senu buro-mani baungno sewa awong nigiro oko nigao ine yero zanero tere taira yero bamuwa ara. Zo nung buro nuna-una baungnu, zo nung stowa nuna-una baungnu, ");
INSERT INTO zia_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ora ena mene zo emo tuwara buro-mani sero pusugairo itinasani saniro puro dewa mamagayewa ara. ");
INSERT INTO zia_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ayero yewa emo tuwa mene nigiro tini kapenu giro senu gorobo emo nuna mene baungno emo mani dewa magayewa awiya dero aung yero napo nunae kouyewa awena ara. ");
INSERT INTO zia_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ayewa emo tuwa nung buro-mani nuna eno eyero sena, ‘Nona sairo sosao mitiya, arata emo bowi sao awiya awong awang yero yangdoteya, arare na awong abena dotinena. ");
INSERT INTO zia_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Arare niye napo kakamo sero baungno emo tamarineya awiya teng sero puro bumaese sinena.’ ");
INSERT INTO zia_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ayero senu buro-mani nuna soma sero baungno emo mekore iwaingne tebe-tabe puro bumuwa augao ibu awiya be buro mitiwa ara. ");
INSERT INTO zia_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mitiwa emo tuwa mene awong gari sero witiro emo zo ana-bonene yaora taung wori aung mitinu giro nung eno eyero sena, ");
INSERT INTO zia_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Otao, ning nono yero ana-bonenena taung wori oko wosogao buro mitesi?’ Ayero senu nung ge titi yero doro mitina ara. ");
INSERT INTO zia_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ayenu emo tuwa mene buro-mani nuna eno eyero sena, ‘Niye te wawong nuna bunero au daung mumena gaipu. Atu zi aiyamama sero be kerinasani mitae.’” ");
INSERT INTO zia_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu mene ungwe awiya diro aung yero ge susuuno eyero sena, “Yau sao nigao awiya daigairo ara, arata kora yero yangta gairo pumao awiya zo etoka gege.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yesu mene ayero senu Farisayo awong ewe baungno ge mene wao zo itaine yanane dariniya ayero sero ge diro kora-makora yewa. ");
INSERT INTO zia_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ayero nete buro-mani nunae arita Herodera Pati auna memba sao amaze ena tugata yero iyengtiwa Yesura una baungno eyero sewa, “Gipao emo, nae susuwa nina gosinonane. Ning ge iwao ge zo oko sinosa. Me gege sinosa ara. Tuwa Bayaura nagibo awiya nae witaota wosao teng tugata yero nosa nigiti nonane. Ning emo witaore wosaore awiya giro awang oko yero nosa. ");
INSERT INTO zia_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Arare nae ning atata nenane, ning se. Name Yuda emo mene takis moni Roma emora emo tuwa Sisa eno pugati nonane, awiya ning gosinosa teng yero noita aung ing?” ");
INSERT INTO zia_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ayero sewa nung dubo nunae-una ge iwao awiya giginu kasa yenu giro eyero sena, “Niye ge iwao emo mene me sao yero nowa. Noeno ge mene na wao itaine nei? ");
INSERT INTO zia_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Niye takis moni pugati nowa awiya zo gipepu gane.” Ayero senu moni zo taungno gipewa giro ");
INSERT INTO zia_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","nung awong atata yero sena, “Ititire yazore monina mitiya ewiya ana ing?” ");
INSERT INTO zia_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ayero senu awong sewa, “Awiya Sisara.” Ayero sewa giro awong eno eyero sena, “Nona Sisara ayero sero giro Sisa eno pugaipu. Ora nona Tuwa Bayaura ayero sero giro Tuwa Bayau eno pugaipu.” ");
INSERT INTO zia_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ayero senu awong wawong di gauno doro bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Wari be dekaongka auna atu Sadukayo emo awong Yesura una kasa yewa ara. Emo amimene magayao awong nupema oko iroparineya ayero sinauwa ara. ");
INSERT INTO zia_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Awong amimene kasa yero atata yero sewa, “Gipao emo, Mose nung ge eyero gaena. ‘Emo zo mene mani aung magayai giro meta nuna mene bauno noi nuna ataise. Ayero yero aune tato nuna eno mani zo pumaise.’ ");
INSERT INTO zia_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Arare nanae-una towang tatomani metamani 7 nasani nauwa. Arare tato kiyongne nunae mene bauno puro mani oko pumao nawe magayenu, meta nuna wese mene bauno noi nuna awiya atina. ");
INSERT INTO zia_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nung deka ayero nete magayenu meta maingkoka zo mene bauno dekaongka amaze nupema atina. Ayero yerota yero ayero butunawe metamani 7 apakana magayero aung yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ayero yewa aune bauno noi nunae awiya ago magayena ara. ");
INSERT INTO zia_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Arare awong apakana bauno dekaongka amaze atiwa, arare be magayao mene nupema iroparineya be aune bauno awiya ana yariniye?” ");
INSERT INTO zia_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ayero sewa Yesu mene awong eno eyero sena, “Niye Tuwa Bayaura ge gayao aune Tuwa Bayaura putoung awiya oko gosinowa, aeno ge meba wosopapatineya. ");
INSERT INTO zia_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Magayao mene iropuro nupema oko wina-ati yarineya. Awong uritira angelo ine yero tebeba narineya. ");
INSERT INTO zia_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Arare iropaora sineya aeno sane. Tuwa Bayau nung ge eyao niye eno sena amaze niye oko zazagairo gao mene saine neya, awiya! ");
INSERT INTO zia_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nung eyero sena, Na Abrahamto Isaka arita Yakobo auna Tuwa yero nona. Tuwa Bayau nung emo magayao ayero sero nonane awiya gosinoi seka gege yero nowa. Arare nung emo magayaora Tuwa okowata, nung emo seka mitowa auna Tuwa yero mitoiya.” ");
INSERT INTO zia_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yesu mene ge ayero senu emo bauno dubu baina amimene ge nuna awiya nigiro wawong di gauno yawa yawa yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesura ge mene Sadukayo emo puro wosina. Ayero yenu Farisayo awong nigiro au dekaongna gairo ");
INSERT INTO zia_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","otao nunae zo Yudara sao tauyao ge susuwa nigiro baingtao aeno sewa nung Yesu etegari sero eyero sena, ");
INSERT INTO zia_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Gipao emo, sao tauyao ge nomi mene gitau yao baina niye?” ");
INSERT INTO zia_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ayero senu Yesu mene eyero sena, “‘Ara tamao nina bainakama awiya Tuwa Bayau nina nuna-una mitaise. Ayero nasani dubore ititire kotumaore nina mene nung sou ye.’ ");
INSERT INTO zia_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Sao tauyao ge amimene sao tauyao ge apakana awiya daigati nasani bainakama niya. ");
INSERT INTO zia_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nupema zo eyero mitiya awiya awongto dekaongka neyato ara. ‘Ning nika nitope aratapunosa, deka aine emo ena eno ye.’ ");
INSERT INTO zia_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sao tauyao ge etobe amimene Mose aune porofete ge nunae apakana auna gera poza nibamu neyato.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisayo emo au dekaongna gairo newa Yesu mene awong atata yero sena, ");
INSERT INTO zia_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Niye Yuda emora Sorao Emo yazo Kristo aeno no sinowi? Nung sai ana ing?” Ayero senu awong abena eyero sewa, ");
INSERT INTO zia_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Nung Dawidira sai.” Ayero sewa Yesu mene abena eyero sena, “Niye Kristo nung Dawidira sai sineya, aune Dawidi noeno Oweno mene gaenu aune Kristo eno ‘Tuwa nana’ ayero seni? Ayero sinena, noeno oko, Dawidi mene eyero sena, ");
INSERT INTO zia_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Tuwa mene tuwa nana eno eyero sena, ‘Ning buro wawong me nana-una adungno mitasa na iwo dubu nina awiya benaung nina ina pugana izarinesa.’ ");
INSERT INTO zia_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Arare aune Dawidi mene Kristo eno Tuwa nana ayero sena ara. Arare Kristo nung nono yero Dawidira sai yariniye?” ");
INSERT INTO zia_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ayero sinasani atata yenu awong ge abena kapete gari yero ge kau yewa ara. Ayero yero nung nupema atata yari oko kotumuwa. ");
INSERT INTO zia_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Be auna atu Yesu mene emo bauno dubu baina aune buro-mani nuna aeno eyero tugata yena, ");
INSERT INTO zia_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Sao tauyao ge gipao emo aune Farisayo awong Mosera sao tauyao ge gipao emo yero nowa. ");
INSERT INTO zia_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Aeno ge sero gipero ayaya teng nigiro diungpu. Ora nao nunae ami zo ago oko nae. Noeno oko, awong be gege mene sao awiya zo sinowa, arata dimao mene zo oko dipunowa. ");
INSERT INTO zia_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Awong sao tauyao ge witao nona mouyao ine awiya kora yero gausero diro ninae una tame pugairo dimaese sinowa. Arata nuka nuyetope dimao zo awang sero nowa ara. ");
INSERT INTO zia_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nona yero nowa amaze emo mene giro ara tamaese aeno gege yero nowa ara. Awong Tuwara ge ena gaero puro paus mamanikakara pugairo megeteta waweng diro puro naese sao, awiya daigairo paus babuze diro puro nowa, awiya gosineya. Nupema, taung wori bera angsi imokakaung sipunowa kirikoro yero mitoiya, awiya gosinowa. ");
INSERT INTO zia_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ayero nasani ana-bonene yero minaora bera atu awong emo baina siya asero nona baina pugaya minari sinowa. Nupema yere ibura atu emo baunona benaungna atu adumari aratapunowa. ");
INSERT INTO zia_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Emo bauno mene kakame atu awong arugati nasani yazo bowire nunae de ika gaese aratapunowa. Ayero yero yazo nunae gipao emo asaya nigari yawa yero nowa. ");
INSERT INTO zia_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Arata ninae mene zo emo bauno ena mene niye gipao emo asaese oko sae. Noeno oko, gipao emo ninae dekaongka gege niya. Arare niye apakana otao gamao gege. ");
INSERT INTO zia_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ayero yero tawingna emo zo eno ‘gera maung nanae’ oko sae. Maung ninae dekaongka uritira mitiya a gege ara. ");
INSERT INTO zia_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Awong niye gitau yao asaese adeka dema oko sae. Gitau yao ninae dekaongka awiya Sorao Emo ninae Kristo ara. ");
INSERT INTO zia_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Zo nung sou ninae yariniya amimene baina ninae yariniya. ");
INSERT INTO zia_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Zo nung nuka nutope puro wiwitinasani nai giro Tuwa Bayau mene nung puro wosariniya. Ora zo nung wosiro nariniya, awiya Tuwa Bayau mene yazo nuna de ika gariniya. ");
INSERT INTO zia_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Oiye, sao tauyao ge gipao emo arita Farisayo. Niye ge iwao emo me sao yero nowa. Emo bauno awong uritira mokora towari sero nowa ninae awong musugairo nasani uritira garo be gazero nowa ara. Niye nika niyetope oko towao nasani aune awong towari sinowa awang sinowa ara. ");
INSERT INTO zia_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Oiye, sao tauyao ge gipao emo arita Farisayo. Niye ge iwao emo me sao yero nowa. Niye bauno yu magayao auna wau amaze sorero puro nowa. Ayero nasani pasena ninae worero me sao yero nasani isa imoko-kaungkaung sinowa. Isa imoko-kaungkaung mene pasena ninae oko worao yatei siya, awiya ago abena ninae meko maingkoka gege pumateya. Arata niye isa imoko-kaungkaung mene pasena ninae worero yero me sao yero nowa, arare auna ago abena ninae mou-mesayao nibamu tamarineya. ");
INSERT INTO zia_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Oiye, sao tauyao ge gipao emo arita Farisayo. Niye ge iwao emo me sao yero nowa. Niye emo dekaongka amimene tani ninae ago yaise sero tawingne witore buwagairo bautunowa ara. Arare ayao amimene niye aune dema tairo noi aune niye nung tugata yero nowa nung kowa iyaore auna gerao yero witiro niye daigatinoiya ara. ");
INSERT INTO zia_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Oiye, gitau yao emo diti guma yetugao. Niye eyero sinowa, ‘Tuwa Bayaura ibu baina auna ikogati nasani sao tauyao awiya piti. Ora Tuwa Bayaura ibu bainana simao nona mitiya auna ikogati nasani sao tauyao amimene zo me.’ Ayero sinowa. ");
INSERT INTO zia_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Oiye, dau emo diti guma yetugao. Tuwa Bayaura ibu baina awiya dang mitoiya aeno ibura simao nona awiya dang mitoiya ara. Arare nona nomi mene memoko nibamu niye, ibura simao meneta ibu mene niye? ");
INSERT INTO zia_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","O zo eyero sinowa, ‘Aitara ikogati nasani sao tauyao awiya me aung. Ora zawing aita tame mitiya auna ikogati nasani sao tauyao amimene me ara.’ ");
INSERT INTO zia_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Oiye, emo diti guma yao ine. Aita awiya dang mitoiya aeno nuna-una tame zawing pugao amimene dang yero noiya ara. Arare nona nomi me noiye, zawing meneta aita mene niye? ");
INSERT INTO zia_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Arare zo nung aitara ikogairo sai tauyai aita arita aita tame nona mitiya awiya dema gamariniya ara. ");
INSERT INTO zia_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ora zo nung kara Tuwa Bayaura ibu bainana ikogairo sai tauyai giro ibu baina arita Tuwa Bayau ibu bainana atu noiya awiya dema gamariniya ara. ");
INSERT INTO zia_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ora zo nung uritira ikogati nasani sai tauyariniya, awiya Tuwa Bayaura adumao masi aune adumaora maung aune dema gamariniya. ");
INSERT INTO zia_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Oiye, sao tauyao ge gipao emo arita Farisayo. Niye ge iwao emo me sao yero nowa. Niye i bure ninae-ina nona piti amaze dubu wawong etobe auna atu dekaongka teng auna Tuwara gerao ayero sero pugatinowa. Ayero nasani sao tauyao gera agewa nona me — emo eno yanenese saota mono pumaota sero dimao — awiya yangdoro nowa wowosinoiya ara. Niye dubu wawong etobe auna atu dekaongka Tuwa Bayau eno pugati nasani nona me awiya dema yatei siya, awiya teng yatiya. ");
INSERT INTO zia_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Niye gitau yao emo diti guma yao. Niye ou minao ninae auna atu kumisa gutinoi giro awang nasani u pasi pugairo yasagati nowa. Arata wo kamel nona baina awiya niye mena nukinowa arauwa. ");
INSERT INTO zia_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Oiye, sao tauyao ge gipao emo arita Farisayo. Niye ge iwao emo me sao yero nowa. Au-tao ninae taung tame gege saitinowa pewayero noiya. Arata auna mokora dubo-dubo yero ugaing yero nowa auna nona meko amimene be bumao mitiya ara. ");
INSERT INTO zia_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisayo emo diti guma yao. Ning gitau au-tao moko sayasa pewa yai aune taung nuna deka ayero pewa yari niya arauwa. ");
INSERT INTO zia_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Oiye, Farisayo, ge iwao emo me sao yero nowa. Niye biriti simao ayao ine. Biriti nung buyong asiyang mene simao, arata tura mokora awiya emo weture magayao gungyaore amimene mitiya ara. ");
INSERT INTO zia_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Niye awiya deka ayao ine taung aingso ninae mene emora benaungna wosewa sao yero nowa. Arata dubo ninae mene zo ge iwaore uritira ge gera gaira yao mene bebumao arauwa. ");
INSERT INTO zia_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Oiye, sao tauyao ge gipao emo arita Farisayo. Niye ge iwao emo me sao yero nowa. Porofetera biriti yero nowa wosewa yero noiya, a nasani ge emo matura biriti sipunowa. ");
INSERT INTO zia_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ayero nasani eyero sinowa, ‘Aya ewowo naname nasani nauwa aune natenane, awiya awong aune dema tairo porofete oko dero sisigatenane.’ ");
INSERT INTO zia_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ewowo ninae gitau porofete dedunauwa awiya niye ge ayero sinasani aune saisibuna nunae yero nowa auna susuwa ninae awiya keregatineya ara. ");
INSERT INTO zia_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Arare porofete daora buro aya ewowo ninae mene zayewa, awiya yero besugaipu! ");
INSERT INTO zia_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Niye yi mani. Niye yira mani awiso. Pasenana abena kowa iyaore auna babao awiya nugu yai niye nono yero daigarinei? ");
INSERT INTO zia_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Arare na eyero sinena ara. Na naka natope porofete aune kotumao emo arita gipao emo ena ninae-ina iyengtana baya niye ena daya mamaga yarineya, ora ena awiya i pasaora darineya, ora ena zo yere ibu ninae-ina atu waung mene darineya, awong ena ago iniro tunaya napo sero babaya baungno pupunasani dedunasani ayero yarineya. ");
INSERT INTO zia_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ayero naya tawingna atu emo pewa yetugao awiya dedunauwa mamaga nauwa auna abena ninae-ina kasa yariniya ara. Gitau yemaoko otu emo pewayao zo yazo Abel awiya dewa magayena auna atu gorobo zayena awiya bumao gege butu nawe dunu ninae Berekayara mani Zekaraya nung aita tumana atu dewa magayena auna abena awiya ninae-ina kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Na memokoba niye eno sane. Gorobo apakana auna pasenana abena awiya emo bauno yeme tawingna etu neya auna-una kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","O Yerusalem emo bauno, Yerusalem emo bauno. Niye porofete dedunowa magayero nowa. Nupema Tuwa Bayau mene ge emo ninae-ina iyengtitinoi butunowa awong awiya daba mene dedunowa magayero nowa. Kokora ai mene mani awiso nuna wati wese pugairo sanitinoiya deka ayao ine nane emo bauno niye puro pu dekaongna gari yero nona niye awang sinowa. ");
INSERT INTO zia_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Arare Tuwa Bayau mene napo ninae yangduwai yanero mitariniya, awiya gipu. ");
INSERT INTO zia_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Sana nigipu. Niye na oko gao nasani nete eyero sinasani aune na nupema garineya, ‘Tuwara bera butuniya nung awiya bowi yanene.’” Yesu mene ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu nung Tuwa Bayaura ibu bainana atu kasa yero bautunenu buro-mani nuna mene nuna-una baungno ibu bainana garo gipari sewa. ");
INSERT INTO zia_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ayero yewa nung ge abena eyero sena, “Nona apakana miti gosineya auna na memoko sana nigipu. Iwo mene ibu kasero disaya aung yariniya. Ibura daba zo oko duwaya zora una tame mitariniya.” ");
INSERT INTO zia_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu nung Oliwa diri witiro adungno mitinu buro-mani nuna mene nata nuna-una baungno atata yero sewa, “Nona sesesa awiya be nazi kasa yariniye? Ora kasa yao be nina, o tawing aung yaora be awiya nugu nai tani nomi kasa yai ganane kasa yariniye?” ");
INSERT INTO zia_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ayero sewa Yesu mene eyero tugata yena, “Emo ena mene dubo ninae sisiganeya, umo yero baingtiti nasani neupu. ");
INSERT INTO zia_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Noeno oko, emo witao amimene kasa yero esega nana una yero eyero sarineya, ‘Na Kristo Sorao Emo ninae era.’ Ayero sinasani emo bauno daigairora dubo sisigarineya. ");
INSERT INTO zia_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Niye winade nugu etu narineya awiya gosinasani aune nupema winade-wanade ake-akemo otu narineya auna bowi dema nigarineya. Nigiro awang oko yae. Nona awiya gitau kasa yaise sao mitiya. Nona ayao ine kasa yariniya, arata tawingna be mena oko aung yariniya. ");
INSERT INTO zia_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dubu zo mene iropuro emo tuwa enana dubu aune dema winade-wanade yarineya. Dora botiyo babuze kasa yerota kasa yero yariniya. Nupema, dumi babuze iperota ipero yariniya. ");
INSERT INTO zia_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Bauno mani pumari yero nowa yaya gitau mena maingkoka zayero noiya. Arata ago yaya bainakama kasa yero noiya. Ayao ine yaya sesena awiya kasa yai aune yaya bainakama ago kasa yariniya, awiya garineya. ");
INSERT INTO zia_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Be auna atu emo ena mene niye puro iwora waweng pugaya puro dedunasani gainasani ayero daya mamaga yarineya. Tawing sero sero auna emo bauno mene na eno tini kapao pupunasani niye buro-mani nana aeno iwo yarineya ara. ");
INSERT INTO zia_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Be aune emo daigairo amimene uritira ge yangduwarineya. Doro ge wina-se nasani otao nunae awiya puro pu iwora waweng gairo iwo wina-ye yarineya ara. ");
INSERT INTO zia_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ora porofete ge iwao daigairo mene kasa yero emo daigairo auna dubo sisigarineya ara. ");
INSERT INTO zia_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Uritira ge dao mene bainakama yariniya susuwa aeno emo bauno daigairo auna mono pumao buro awiya aung yariniya ara. ");
INSERT INTO zia_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Arare zo nung uritira ge puro iniro takasero nasani tauyero dopero nete magayariniya nung awiya Tuwa Bayau mene sorero pumariniya. ");
INSERT INTO zia_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tuwa Bayau nata Tuwa yero nariniya auna ge bowi amimene tawing sero sero teng babai emo dubu giti mene nigaya aune be aung yariniya arauwa. ");
INSERT INTO zia_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Arare nona meko nibamu gera yao, porofete Daniel mene nona auna ge gaena, amimene ibu bainana masi dang auna dopai garineya ara. (Ge zazagatinesa amimene nigiro baingti.) ");
INSERT INTO zia_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ayao ine kasa yai giro Yudaya tawingna mitarineya amimene awang yero sungno baungno diri naese. ");
INSERT INTO zia_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ayero nasani zo nung garo nuna-una opesara atu mitariniya amimene nona-owi nuna gare mitiya awiya pumari oko towaise. ");
INSERT INTO zia_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ora zo nung bure atu nariniya amimene taung wori nuna doti mitiya awiya pumari oko kapetegairo nape babaise. ");
INSERT INTO zia_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Oiye, bauno mesare arita bauno mani wuire, awong yanakana sumao ine teng oko, arare na awong eno yo apunena. ");
INSERT INTO zia_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Awang yero sungno babao ninae awiya wara be aune ta Sabat iya auna atu kasa yai wa meneta Sabat iyara sao tauyao ge mene niye gazao eno, Tuwa isa sepu. ");
INSERT INTO zia_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","No eno oko, be auna atu mou bainakama kasa yariniya ara. Tawing kasa yena atu zayero butunawe duwa mou zo ayao ine oko kasa yena. Arata ago zo ayao ine nupema oko kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Arare Tuwa mene be awiya oko kapao yatiya, awiya emo bauno apakana sisigairo aung yateya. Ora nung dubu gerao nuna eno yero aune be awiya kapena, arare apungkaka yariniya ara. ");
INSERT INTO zia_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Arare be aune emo zo mene niye eno eyero sai oko nigae, ‘Era Sorao Emo naname ara.’ Ora, ‘Sorao Emo naname ora.’ Ge ayao ine sero buro baungno ayaya oko nigae. ");
INSERT INTO zia_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Be auna atu Sorao Emo ge iwao enane porofete ge iwao enane amimene kasa yarineya. Kasa yero emora dubo sisigari sero tani putoungne ena arita tani benaung seka ena witao awiya yarineya. Ayero nasani Tuwa Bayaura dubu gerao awiya dema dubo sisigari sero buro yarineya ara. Arata awong Tuwa Bayaura dubu gerao auna dubo sisigao ine teng oko, arare yero tetere yarineya ara. ");
INSERT INTO zia_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Na nona ago kasa yariniya auna ge niye eno bere-bere sinena. ");
INSERT INTO zia_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Arare aune ‘Kristo soma emo aung auna atu kasa yeti gigenane,’ ayero saya oko gari babae. Ora ‘Garo mokora atu pungyero miti gigenane,’ awiya dema ayero saya oko nigae. ");
INSERT INTO zia_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Noeno oko, bibiya mene papari-papari yero noi wari witaora atu baung deung enaba wari wosaora yero aung yero noiya, deka ayao ine na Emora Mani mene kasa yarinena. ");
INSERT INTO zia_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Buro awinoi ni owa mene iyao boingsa giro dowinowa. ");
INSERT INTO zia_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yaya kokoni yao iwore dema aung yai aune wari mume yariniya. Ayero yai inona waegao awiya dema aung yariniya. Arasa uritira atu zokero wosariniya. Ayero nai aune putoung uritira mitowa amimene iparineya. ");
INSERT INTO zia_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ayero yai aune Emora Mani auna owe uritira atu kasa yai tawing sero sero auna emo bauno amimene zi sinasani mitaya aune na Emora Mani mene uritira bereze tame atu putoungne waegao bainane aune dema kasa yana garineya ara. ");
INSERT INTO zia_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Arare to baina pisaya ge sai na angelo dubu nana iyengtana tawing ageware ageware ikata enaka auna baungno dubu gerao nana pumarineya ara. ");
INSERT INTO zia_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Niye i fik auna tani awiya kotungno aune susuwa zo gipu. Bowang nuna botu kasa yero dang iwaing ditinowa be aune niye giro, ‘O warira be nugu niya,’ ayero sero nowa ara. ");
INSERT INTO zia_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Arare nona awiya apakana kasa yero aung yai giro eyero sepu, ‘Nung nugu yetiya. Be towaora bautara dodopiniya.’ ");
INSERT INTO zia_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Na meba sane. Emo bauno yeme tawingna etu neya amimene oko magayero aung yao naya aune tani awiya apakana kasa yero aung yariniya ara. ");
INSERT INTO zia_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ago uritire tawingne awongto disero aung yarineyato ara, arata ge nana mene zo oko disero aung yariniya. ");
INSERT INTO zia_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ora tani kasa yariniya auna wari beta aua be awiya emo zo mene oko gosiniya. Uritira angelo awong deka ayero oko gosineya. Na Mani nuna deka ayero oko gosinena. Mama nung nata gosiniya. ");
INSERT INTO zia_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tani gitau Noa wangna oko witao aune yero nasani nauwa deka ayao ine naya aune na Emora Mani kapete gairo bumarinena. ");
INSERT INTO zia_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Awong wabamu baina oko dao aune nona pupu nasani mini nasani ayero nasani bauno wina-darawa yero atiti nasani nauwa. Ayero nasani kara nauwita ayero sero newa Noa wangna witina ara. ");
INSERT INTO zia_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Witinu awong wabamu baina dero butunena awiya oko gao mitiwa ou baina buro awong nukero aung yena ara. Emora Mani auna kasa yao bera atu deka ayero yarineya. ");
INSERT INTO zia_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Be auna atu emo etobe bure atu nayato na zo puro zo yangduwarinena. ");
INSERT INTO zia_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Bauno etobe ma yeti nasani mitayato na zo puro zo yangduwari nena. ");
INSERT INTO zia_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Tuwa ninae mene be nazi kasa yariniye, awiya niye oko gosineya, arare dubo ninae diya yero baingtiti nasani neupu. ");
INSERT INTO zia_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Niye susuwa eyero gipu. Garo zora maung mene ugaing emo pingne bumariniya awiya gatiya, awiya nung seka ayero mitasani garo nuna diya yero baingtai ugaing emo oko towatiya. ");
INSERT INTO zia_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Arare Emora Mani auna kasa yao be oko gao nasani na oko bumarinena ayero sinaya be aune bumarinena. Ayao eno niye kora makora nasani neupu. ");
INSERT INTO zia_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Niye soumani iwaing yero neupu. Soumani iwaing nung kotumao iwaing puro nai giro emo tuwa nuna mene nung soumani nuna apakana diya yaise sariniya. Nung awong diya nasani wo ma awong eno pugatinaise sariniya ara. Emo tuwa nuna mene buro ge awiya nung eno pugairo doro baungno nariniya. ");
INSERT INTO zia_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Arare soumani amimene buro nung eno sao awiya teng dipunasani nai, emo tuwa nuna mene kapete gairo buro nuna-una me giro tani iwaing nung eno yai yawa yawa yariniya. ");
INSERT INTO zia_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Na memokoba sane. Emo tuwa nuna mene diya buro baina soumani eno pugati nasani nona nuna apakana diya yaise sariniya. ");
INSERT INTO zia_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ora soumani awiya nung diya buro nuna pore nasani dubo nuna mene eyero sariniya, ‘Emo tuwa nana mene mena oko kapete gariniya. Nete ago kapete gariniya.’ ");
INSERT INTO zia_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ayero sinasani emo bauno sou buro yero nowa awiya dero gera gaira nasani otao nuna ena ou tauyao miniro dau yero nowa awong aune dema ana-bonene nasani ou tauyao mini nasani ayero nasani dau yarineya ara. ");
INSERT INTO zia_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ayero nasani nete emo tuwa nuna kapete gaora be awiya oko gao nasani nung mena oko kapete gariniya ayero sinasani nai, emo tuwa nuna kapete gairo bumariniya. ");
INSERT INTO zia_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Buro soumani awiya yanakana wezero dero ge iwao emo awong abena tamarineya masi deka auna pugariniya. Atu zi aiyamama be kerero sinasani engweze-pangweze nasani mitariniya arauwa. ");
INSERT INTO zia_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Be baina awiya kasa yai aune uritira mitoiya amimene nata Tuwa yero nariniya auna susuwa awiya eyero kasa yariniya. Na sou baunodidi 10 auna pugairo sana nigipu. Emo zo mene bauno gerao nuna atari sero bauno gerao auna maungna una bauna. Bautunenu sou baunodidi 10 amimene emo awiya nagibe atu taungno puro bumari sero damana nunae puro bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Baunodidi 5 awong awiya dau, ora 5 awong mene zo kotumaore. ");
INSERT INTO zia_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Arare dau mene damana nunae gege pumuwa ara. Garewa nunae ou oko sukuno pumao. ");
INSERT INTO zia_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Arata kotumaore mene damana nunae puro ou garewara dema sukuno puro aune bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Arare emo awiya mena oko bumao, nimoi nenu awong diya mitete magayero giro auriti awinewa ara. ");
INSERT INTO zia_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Auriti awinewa ping towang daung singsang gainu aune wawa zo eyero kasayena, ‘Emo butuniya. Iropungpu, baungno tamanene!’ ");
INSERT INTO zia_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Arare baunodidi 10 awong nigiro giro iropuro damana nunae kora-makora yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ayero newa baunodidi dau awong iropuro baunodidi kotumaore aeno eyero sewa, ‘Nae damana nanae sikipuniya, arare niye nae eno ou sukungpu!’ ");
INSERT INTO zia_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ayero sewa baunodidi kotumaore mene abena awong eno ge eyero kapetegaiwa, ‘Aung ara. Ou name apakana auna teng oko yarinita nowa. Arare niye stowara baungno ou ninae zuma gaero pungpu!’ ");
INSERT INTO zia_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ayero sewa giro awong ou zuma gayari bautunewa emo awiya kasa yena. Arare sou baunodidi 5 nona kora yero damana nunae aune dopero mitiwa awiya yuno ataora ana-bonene yari maungna gare toiwa. Gare toiro garo be gazero ana-bonene nasani mitiwa ara. ");
INSERT INTO zia_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Atu mitiwa baunodidi dau awong ago buro wawa sinasani eyero sinewa, ‘O Tuwa nanae, be towao iwe!’ ");
INSERT INTO zia_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Wawa sinewa abena eyero sena, ‘Na memoko niye eno sane. Na niye oko gosinona!’ Ayero sena ara.” ");
INSERT INTO zia_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu mene ayero sero ge susuuno eyero sena, “Niye be awiya oko gao, arare diya yero baingtiti nasani neupu.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesu mene eyero sena, “Uritira atu mitoiya amimene nata Tuwa yero nariniya auna susuwa gaese sero na soumani etama auna pugairo sane. Emo tuwa zo mene ake-akemo babari sero diya dubu nuna gurutu dekaongna gairo moni nuna diya yaese bono yena. ");
INSERT INTO zia_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ayero nasani soumani zo eno K5,000 pugairo zo eno K2,000 pugairo zo eno K1,000 pugaina ara. Awiya moni tamaora putoung nunae teng gosinasani pugaina. Moni pugairo aung yero nung doro baungna ara. ");
INSERT INTO zia_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nung bautunenu soumani moni K5,000 pungna amimene moni awiya puro buro yero susuunota susuuno ayero nenu K5,000 ayao teng kasa yenu moni nuna K10,000 yena. ");
INSERT INTO zia_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ora otao nuna K2,000 pungna nung deka ayao buro yenu K2,000 susuunu moni nuna K4,000 yena. ");
INSERT INTO zia_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Arata soumani K1,000 pungna amimene emo tuwa nuna-una moni puro baungno mutenu mitina ara. ");
INSERT INTO zia_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Arare emo tuwa nunae be imoko-kaungkaung nawe kapetegairo buro kasa yena ara. Kasa yero soumani moni diya nauwa awiya au dekaongna gairo moni puro buro yewa nono yao kasa yeni, awiya saese sena ara. ");
INSERT INTO zia_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Asenu giro K5,000 pungna amimene kasa yero K5,000 pugairo K5,000 zo susuuno eyero sena, ‘Tuwa nana, ning K5,000 na eno pugasa awiya na puro buro nawe dotena K5,000 ayao teng nupema kasa yetiya era!’ ");
INSERT INTO zia_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ayero senu emo tuwa nuna mene eyero sena, ‘Soumani iwaing ge dimaore. Ning nona maingkokaka awiya iwaing diya yasa, arare nane ning nona bainakamana diya pugarinena ara. Arare ning bung, na emo tuwa nina aune dema yawa yawa yaneno!’ ");
INSERT INTO zia_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ayero senu soumani K2,000 pungna awiya kasa yero eyero sena, ‘Emo tuwa nana, ning moni K2,000 na eno pugasa, awiya nane puro buro nawe dotena K2,000 ayao nupema kasa yetiya era!’ ");
INSERT INTO zia_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ayero senu emo tuwa nuna mene eyero sena, ‘Soumani iwaing ge dimaore. Ning nona maingkokaka awiya iwaing diya yasa, arare nane ning nona bainakamana diya pugarinena ara. Arare ning bung, na emo tuwa nina aune dema yawa yawa yaneno!’ ");
INSERT INTO zia_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ayero senu ago moni K1,000 pungna amimene kasa yero eyero sena, ‘Emo tuwa nana, na susuwa nina eyero gosinona. Ning emo kokoniyao. Emo zo mene nona bure urinoiya awiya ning me nuna pupunosa. Ora tawing agewa zo auna emo zo mene wuit me augatinoi kosoyero zapunoi ning wuit me nuna pupunosa. ");
INSERT INTO zia_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Arare na aeno awang yero moni nina mutewang mitoiya. Arare yeme na moni nina ning eno pugatinena era!’ ");
INSERT INTO zia_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ayero senu emo tuwa nuna mene abena eyero sena, ‘Ning soumani meko timara. Emo zo mene nona bure urinoi me nuna pupunona, o emo zo mene wuit me augatinoi kosoyero zapunoi pupunona, awiya gigesa me yetiya ayero sinesa, arare ");
INSERT INTO zia_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ning na eno ayero kotupunasani moni nana awiya moni diya yao emo eno pugasa buro yaya zapunai kasa yero pumatena, awiya teng yatiya.’ Ayero sero soumani ena eno eyero sena, ");
INSERT INTO zia_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","‘Arare niye moni nuna sorero K5,000 puro noiya aeno pugaipu pumae. ");
INSERT INTO zia_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Zo nung nona nung eno pugao awiya puro nasani amimene buro yai giro ena susuuno nung eno pugarinena. Ayero yana aune zamena-simena nuna-una kasa yariniya ara. Arata zo nung nona nung eno pugao awiya puro nasani amimene buro oko yao yai giro na nona maingkokaka nuna-una mitiya awiya sorero pumarinena. Ayero yana nung aung nariniya. ");
INSERT INTO zia_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ora soumani timara nung awiya puro ake mumena augaya atu zi aiyamama sinasani engweze-pangweze nasani mitaise.’ ");
INSERT INTO zia_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Nete ago na Emora Mani mene uritira waegao nana aune angelo dubure dema kasa yero Tuwara adumao masi simao zineka yao auna atu adungno mitarinena. ");
INSERT INTO zia_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ayero nasani tawing sero sero auna emo bauno pu dekaongna gana nana-una augarineya. Ayero yaya wo diya mene lamane memene awega-ziwega yero noiya deka ayero na emo bauno awega-ziwega yero ");
INSERT INTO zia_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","lama awiya benaung nana-una atu dubu zo gurutu yarinena ara. Arata meme zo nana-una bautara atu dubu zo gurutu yarinena. ");
INSERT INTO zia_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ayero yero na Tuwa mene benaung nana-una atu mitarineya awong aeno eyero sarinena, ‘Mama nana mene gao yena niye bungpu, uriti napo ninae topetae. Napo awiya gitau yemaoko tawing kasa yena be auna atu niye eno gerena. ");
INSERT INTO zia_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Noeno okowata, niye na eno eyero yewa: Na meri magayewang giro niye na eno ma pugaiwa; na oure magayewang giro niye na eno ou pugaiwa; na esewa nasani mitao masi kau newang giro niye na kora-makora yewa; ");
INSERT INTO zia_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","na taung wori kau yewang giro niye na eno taung wori zo pugaiwa; na yaya pumuwang giro niye na eno yo-amuwa; na bunao gare mitiwang niye na soremuwa.’ ");
INSERT INTO zia_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ayero sana etutero nao mene ge eyero kapetegarineya, ‘Tuwa, ning natu meri magayasa ning eno nona pugaingwine? Ora ning natu oure magayasa ning eno ou pugaingwine? ");
INSERT INTO zia_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ning natu esewa nasani mitao masi kau nasa ning kora yewingne? Ora ning naina atu taung wori kau nasa nae ning eno taung wori pugaingwine? ");
INSERT INTO zia_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nupema ning natu bunao gare atu yayare mitasa ning kora yewingne?’ ");
INSERT INTO zia_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ayero saya na Tuwa mene eyero sarinena, ‘Na memokoba niye eno sane. Niye otao mani nana wowosigao auna zo kora-makora yewa, awiya niye na eno yewa ayero niya ara. ");
INSERT INTO zia_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Na awong eno ayero sero aune nana bautara mitarineya awong aeno eyero sarinena, ‘Kowa iyaore auna gerao niye. Niye na doro baungpu, iyao tauyao Mama nana mene Sanda angelo dubu nuna aune eno kou yenu awao gege awinoiya auna atu nae. ");
INSERT INTO zia_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Noeno okowata, niye na eno eyero yewa: Na meri magayewang giro niye na eno ma oko pugao yewa; na oure magayewang niye ou na eno oko pugao yewa; ");
INSERT INTO zia_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","na esewa nasani mitao masi kau newang niye na oko kora yao yewa; na taung wori kau newang niye na eno taung wori oko pugao yewa; na bunao gareta yayare mitiwang niye na oko kora yao yewa.’ ");
INSERT INTO zia_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ayero sana nana bautara mitarineya amimene eyero sarineya, ‘Tuwa, ning natu ma kau nasani, ou kau nasani, mitao masi kau nasani, mo kau nasani, yayareta bunao gare mitasa nae ning oko soremao yewingne?’ ");
INSERT INTO zia_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ayero saya na eyero sarinena, ‘Na memoko sane. Niye otao mani nana wowosigao auna zo awiya oko kora yao yewa, awiya na eno oko yao yewa ayero niya ara.’ ");
INSERT INTO zia_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ayero sana awong gera yao masi auna nape babarineya. Orata etutero nao mene nao me iwaing auna nape babarineya.” Yesu mene ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu nung ge awiya apakana sinete sero aung yero buro-mani nuna eno eyero sena, ");
INSERT INTO zia_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Wari be etobe aung yai aune Magayao mene awong Daigaina auna iya be kasa yariniya, awiya gosineya ara. Arare be auna atu awong na Emora Mani i pasaora magayanese sero puro emora waweng pugarineya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Arare be auna atu pirisa babuze aune Yuda emora simai awong pirisa baina yazo Kayafa nuna-una augao gare witiro ");
INSERT INTO zia_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yesu opene puro dari ge diwa ara. ");
INSERT INTO zia_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ayero nasani eyero sewa, “Emo bauno yo-dubo uwanane tini kapai gorobo yowi sero, oregao be baina aune oko yanene.” Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu mene Betani nape baungno Simon bozo tauyaore nenu kora yena auna gare atu nona mininasani mitinu ");
INSERT INTO zia_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","bauno zo mene nuna-una baungno ou sereyao zuma bainakamane garewa daba mene yao auna sukumao, awiya puro nuna-una ziye yasagainu suwena ara. ");
INSERT INTO zia_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ayero yenu buro-mani nuna mene giro dung yero eyero sewa, “Nona zuma bainane awiya noeno gera niye? ");
INSERT INTO zia_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Amimene moni witao tamai emo bogamasa eno pugaoware.” ");
INSERT INTO zia_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ayero sewa Yesu mene nigiro awong eno eyero sena, “Niye noeno bauno eno ge bautara sinei? Bauno nung na eno mono pupuni iwaing niya. ");
INSERT INTO zia_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Emo bogamasa awong niye aune dema be giti yero nowa narineya. Arata nane mene zo niye aune dema oko nao gege narinena. ");
INSERT INTO zia_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Na be maingkokaka nete magayana mutarineya. Arare nung bere-bere taung nana siuno sosiniya. ");
INSERT INTO zia_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Na memokoba sana nigipu. Bowi Iwaing tawing sero sero bautunai aune tani iwaing na eno yetiya auna bowi awiya dema sero sero ayaya babariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Arare buro-mani nuna 12 nunae-una zo yazo nuna Yudas Iskeriot, nung amimene pirisa babuzera-una baungno ");
INSERT INTO zia_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","eyero sena, “Na Yesu keregairo pu wawong ninae-una gana niye na eno moni nazigo pugarinei?” Ayero atata yenu awong silva moni 30 zazagaiwa pungna ara. ");
INSERT INTO zia_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Puro Yesu gera pugaora nagibo tamari buro yena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Magayao mene awong Daigaina auna iya be kasa yenu Yuda emo bauno mene yis semini nasani newa aune Yesura buro-mani mene nung atata yero sewa, “Nae yeme garo natu Magayao mene awong Daigaina auna bonene nina sairo kora-makora yanenese kotupunesi?” ");
INSERT INTO zia_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ayero sewa nung abena eyero sena, “Niye Yerusalem nape baungno emo zo gitau sewang gigiwa aeno eyero sepu nigae: ‘Gipao emo nanae nung ning eno eyero siniya: Be nana nugu niya, arare nina-una buro buro-mani aune dema Magayao mene awong Daigaina auna bonene minarinenane sinena,’ ayero sepu gae.” Yesu mene ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yesu mene ge awiya senu buro-mani nuna mene diungno Magayao mene awong Daigaina auna bonene sairo kora-makora yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ture inu Yesu nung buro-mani nuna 12 puro Yerusalem baungno garo auna witiro Magayao mene awong Daigaina auna bonene miniwa ara. ");
INSERT INTO zia_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mininasani Yesu mene eyero sena, “Na memokoba sane. Ninae-una zo mene na keregairo iwora waweng pugariniya.” ");
INSERT INTO zia_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ayero senu buro-mani nuna dubo mininasani dekaong dekaong nung atata yero sewa, “Tuwa, na eno sinesita?” ");
INSERT INTO zia_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ayero sewa nune eyero sena, “Na aune dema ame sura dusarinenato nung amimene na keregariniya. ");
INSERT INTO zia_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Na Emora Mani mene nagibo na eno sero gaewa auna babari sero nena ara. Arata emo na keregariniya nung awiya, oiye! abena nuna nono yao pumariniye? Ai nung oko pumao yatiya, awiya nung meko oko yatiya.” ");
INSERT INTO zia_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ayero senu Yudas keregao emo amimene deka ayero nung atata yero sena, “Gipao emo, na eno sinesita?” Ayero senu abena eyero sena, “Sinesa ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Awong nona mininasani mitiwa Yesu mene poro puro Tuwa Bayau eno dange sero eegairo buro-mani nuna eno pugatinasani eyero sena, “Puro minipu. Ewiya goi nana.” ");
INSERT INTO zia_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ayero sero awang ou wainne zo puro Tuwa Bayau eno dange sero awong eno pugatinasani eyero sena, “Niye apakana amimene minipu. ");
INSERT INTO zia_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ewiya yu nana. Yu amimene Tuwa Bayau aune tairo nao auna ge inai tau yariniya. Emo bauno daigairo auna pasena disaise yasagarinena. ");
INSERT INTO zia_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Sana nigipu. Na ou wain yeme mininenane ewiya doro oko minao nete Mama nana nata Tuwa yai aune niye aune dema ou wain seka zo minarinenane ara.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Awong yere zo gauno aune iropuro Yerusalem doro baungno diri yazo Oliwa auna witiro mitiwa ara. ");
INSERT INTO zia_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nagibe atu bautunasani aune Yesu mene eyero sena, “Ping eune niye apakana awang yero na doro zanarineya. Noeno okowata, ge gayao zo eyero mitiya awiya me yariniya, Na Tuwa Bayau mene wo sipsip diya emo dana magayai wo sipsip sisi-bura-bura yarineya. ");
INSERT INTO zia_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Arata na magayaora atu iropuro Galilaya tawingna babana niye ago bumarineya.” ");
INSERT INTO zia_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ayero senu Petoro mene eyero sena, “Awong apakana ewiya iwo awang yero ning yangduwaya nane zo ning oko yangduwarinena.” ");
INSERT INTO zia_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ayero senu Yesu mene eyero sena, “Na memoko sana nigi. Nine ping eune kokora ge oko saore na bewae yasa be etama yariniya.” ");
INSERT INTO zia_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ayero senu Petoro mene eyero sena, “Awong na ning aune dema daya magayanese sarineya, arata saineba, na ning oko bewae yarinena.” Ayero senu buro-mani otao mani ena mene deka ayero nung soreuno sewa ara. ");
INSERT INTO zia_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu buro-mani nuna aune bautunete i buro zo yazo Gesemani auna kasa yero Yesu mene buro-mani nuna eno eyero sena, “Niye etu adungno mitaya nane zo otu baungno isa sarinena.” ");
INSERT INTO zia_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ayero sero Petoro aune Zebedira mani etobe puro bamuwa ara. Bamuwa Yesu nung dubo mininasani dubo mou yenu ");
INSERT INTO zia_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","awong eno eyero sena, “Na dubo minao bainane tapunena dubo minao mene na puro wosi magayanese niya. Arare niye na aune dema etu seka mitasani umo neupu.” ");
INSERT INTO zia_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ayero sero awong doro baungno ake yero diti benaungne nuna pu tawingna gairo eyero sinasani isa sena, “Mama nana, ning nigasa yaine yao yai giro yaya baina ewiya na daigae. Arata ge nana okowata, ge nina mene me yaise.” ");
INSERT INTO zia_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Isa ayero sero mani etamara-una kapetegairo awong auriti awinewa giro Petoro eno eyero sena, “Niye na aune dema aua dekaongka gege seka yero mitao teng oko, awiya! ");
INSERT INTO zia_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Niye etegaora atu iyangyao eno, seka yero mitasani isa sepu. Dubo ninae mene buro iwaing yaora eo niya, arata taung mene zo mou niya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Arare nung nupema baungno ge eyero sinasani isa sena, “Mama nana, yaya baina ewiya na daigaise nigasa teng oko yao yai giro saineba diungno aung yana ge nina mene me yae.” ");
INSERT INTO zia_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Isa ayero sero kapetegairo buro-mani awong diti morenu auriti awinasani mitiwa gigina ara. ");
INSERT INTO zia_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Giro doro nupema baungno isa senu be etama yena. Ge gitau sena deka awiya sinasani isa sena ara. ");
INSERT INTO zia_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Isa sero aung yero buro maingna-una kapetegairo eyero sena, “Niye auriti gege awinasani miteya. Be kasa yetiya. Emora Mani keregeya pasena emora waweng wiwitinena. ");
INSERT INTO zia_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Keregao emo butuniya. Iropungpu, nunae-una babanene.” ");
INSERT INTO zia_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ayero sinenu buro-mani 12 auna otao nunae Yudas mene iwo dubu baina gitau yenu kasa yewa ara. Iwo dubu awiya pirisa babuze aune Yuda emora simai amimene iyengtiwa gorobo yari sero iwire ami dawangne puro buro kasa yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Gitau keregao emo mene iwo dubu baina eno ge zo gipero eyero sena, “Emo nane saniro toko yarinena, nuka ara. Nung awiya saniro pumarineya.” ");
INSERT INTO zia_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Arare kasa yero mena Yesura-una baungno, “O gipao emo nana,” ayero sero toko yena. ");
INSERT INTO zia_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ayero yenu Yesu mene eyero sena, “Otao, buro nina yari sero bumesa awiya ye aung yae.” Ayero senu awong buro nung puro wawong bunewa ara. ");
INSERT INTO zia_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Anewa Yesu aune dema newa auna-una zo mene iwi nuna geingna atu ininu gururu senu pirisa bainana soumani awiya dari yero dawong nuna kesena ara. ");
INSERT INTO zia_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ayero yenu Yesu mene eyero sena, “Iwi nina geingna pugai towae. Zo nung gorobo yariniya amimene abena nuna deka awiya gorobo tamariniya. ");
INSERT INTO zia_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ning susuwa nana mitiya awiya oko gao nasani aeno ayero nesita? Mama nana eno isa sana yemeneka keune angelo 70,000 pugai wosiro na soremateya, arata dotinena. ");
INSERT INTO zia_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ayero wosiro na soremaya ge gayao mene nagibo nana eyero kasa yaise sinoiya amimene nono yero me yariniye?” ");
INSERT INTO zia_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ayero sero emo dubu baina nung pumari bumuwa aeno eyero sena, “Niye iwire ami dawangne puro butuneya, awiya gorobo emo zo puro bunari bumaine neya. Be giti awiya na niye aune dema ibu bainana atu yero nona niye atu noeno na oko pumao yero nowi? ");
INSERT INTO zia_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Arata tani ewiya porofete mene ge gaewa awiya me yero aung yaise kasa niya.” Ayero senu buro-mani nuna awong apakana nung doro zanero aung yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Emo Yesu iniro saniwa amimene nung puro baungno pirisa baina yazo nuna Kayafa auna gare puro witiwa. Garo auna atu sao tauyao ge gipao emore simaire amimene augairo mitiwa ara. ");
INSERT INTO zia_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Yesu puro bautunewa Petoro nung ake atu ago nasani pungyero-pungyero baungna ara. Bautunete kasa yero pirisa baina auna-una goma mokora toina ara. Toiro pirisa bainana soumani auna-una towang atu eyero sero adungno mitina, “Yesura ge nono saya tau yariniye, etu mitasani nigane.” ");
INSERT INTO zia_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Arare pirisa babuze arita gitau yao dubu awong teng mitasani emo zo mene Yesu eno ge iwai Yesu gera pugairo daya magayaise sero ge iwao ge yangtaka-betaka yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ayero nasani ge iwao daigairo sewa kasa yenu nigiwa mou oko yao yenu giro ge iwao ge iwaing zo tamari sero buro nasani mitiwa. Ayero nasani mitiwa emo etobe iropuro eyero sewato, ");
INSERT INTO zia_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Yesu nung eyero senu nigiwangto, ‘Nane Tuwa Bayaura ibu baina kasero wari be etama gege aung yai nupema yana dopariniya. Na ayero yao ine teng.’ Ayero senu nigiwangto ara.” ");
INSERT INTO zia_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ayero sewato pirisa baina amimene iropuro Yesu eno eyero sena, “Ning noeno ge nina sineyato auna abena oko sao bora bora yero mitesi?” ");
INSERT INTO zia_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ayero senu Yesu mene ge abena oko sao bora bora yero dopero mitina ara. Ayero yenu pirisa baina mene nupema atata yero sena, “Tuwa Bayau putoungne auna benaungna ning atata yana se tau yae. Ning Yuda emora Sorao Emo yazo Kristo, Tuwa Bayaura Mani meta aung ing?” ");
INSERT INTO zia_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Atata yenu Yesu mene eyero sena, “Sinesa ara. Arata zo sana nigipu. Nete na Emora Mani mene Tuwa Bayau Putoungne auna wawong mera atu adungno mitana garineya. Na uritira bereze tame adungno mitana wosiro buro kasa yai garineya.” ");
INSERT INTO zia_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ayero senu pirisa baina amimene ge awiya niginu meko yenu nung taung wori nuka nuna ininu kerenu emo dubu nuna eno eyero sena, “Nung Tuwa Bayau daigari nasani siniya, arare name noeno emo ena buro nung gera pugaese sarinenine? ");
INSERT INTO zia_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ge meko awiya nika niyetope nigiro no sarinei?” Ayero senu awong eyero sewa, ");
INSERT INTO zia_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","“Nung magayaora gerao niya ara.” Ayero sero Yesura benaungna begura pisero nung dero musuna-masuna yewa ara. Anewa ena mene zo wawong petata yero nung sowena dero ");
INSERT INTO zia_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","nung eno eyero sewa, “Oiye, Sorao Emo Kristo. Ning porofete me yai giro se, emo ning deduniya auna yazo aweni?” ");
INSERT INTO zia_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ayero nasani newa Petoro nung goma mokora napo kakame atu mitina ara. Mitinu soumani baunodi zo mene nuna-una baungno eyero sena, “Ning amimene Yesu Galilaya emo oune dema nosa ara.” ");
INSERT INTO zia_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ayero senu nung emo mitiwa auna benaungna atu bewae nasani eyero sena, “Ning ge sinesa awiya na kau nena.” ");
INSERT INTO zia_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ayero sero iropuro goma towao bera ina baungno mitinu nupema soumani baunodi zo mene giro emo atu mitiwa aeno eyero sena, “Emo ewiya nung Yesu Nasarete napora aune dema noiya.” ");
INSERT INTO zia_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ayero senu Petoro mene Tuwa Bayaura benaungna senu tau yenu nupema bewae nasani eyero sena, “Na emo owiya oko gosinona.” ");
INSERT INTO zia_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ayero sero dodopinenu be apungkaka aung yenu emo mitiwa amimene Petorora-una baungno eyero sewa, “Nae ge mapu nina nigitinenane Galilaya emora ge ine niya. Ning meba dubu nuna-una zo ara.” ");
INSERT INTO zia_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ayero sewa nung nupema Tuwa Bayaura benaungna ge eyero senu tau yena, “Na ge iwarinena, awiya Tuwa Bayau na dai magayarinena. Na emo awiya oko gosinona.” Ayero sinenu kokora mene ge sena ara. ");
INSERT INTO zia_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petoro kokora ge nigiro Yesu mene gitau nung eno ge eyero sena awiya kotungna. “Kokora ge oko saore nine na bewae yasa be etama yariniya.” Nung ge awiya kotungno kasa daung yero zi bainakama sena ara. ");
INSERT INTO zia_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Iya gainu pirisa babuzere simaire awong au dekaongna gairo Yesu daya magayaise sewa tau yena ara. ");
INSERT INTO zia_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ayero yero sewa Yesura wawong etobe bunero puro Romana emo tuwa Pilato auna-una bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Magayaise sewa tau yena awiya Yudas keregao emo mene nigiro giro, “noeno ayero yeteni?” ayero sero dubo nuna meko yenu moni pugaiwa awiya puro baungno pirisa babuzere simaire aeno pugaina ara. ");
INSERT INTO zia_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ayero nasani eyero sena, “Na were-were yero emo pasena aung awiya keregena pumeya.” Ayero senu awong eyero sewa, “Nae no yanenese buro sinesi? Awiya nona nina gege.” ");
INSERT INTO zia_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ayero sinasani moni awang sewa puro baungno Tuwa Bayaura ibu bainana atu augainu witinu nung doro baungno muri zuwero magayena ara. ");
INSERT INTO zia_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ayero yenu pirisa babuze mene moni silva awiya yangtagairo pu dekaongna gairo eyero sewa, “Moni ewiya dao magayaora zuma, aeno ibu bainana awangna puganane oko teng yariniya.” ");
INSERT INTO zia_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Asero awong moni amimene no yarinenine ayero sero wina-se nete sewa teng yenu moni awiya puro baungno au yao emora tawing agewa zo zuma gaewa ara. Emo esewa buro magayaya atu mutaya biriti esewara yaise sero zuma gaewa ara. ");
INSERT INTO zia_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Arare tawing auna yazo “Yu Zuma Gayaora” ayero sewa tau yenu mitoiya ara. ");
INSERT INTO zia_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Arare porofete Yeremiara ge me yena ara. Ge awiya eyao era, Isreli emo awong zuma nuna silva moni 30 ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Emo moni silva 30 amimene au yao emora tawing zuma gaewa ara. Tuwa mene na eno sena deka ayero yewa. ");
INSERT INTO zia_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Awong Yesu puro bamuwa emo tuwara benaungna dopenu emo tuwa mene atata yero sena, “Ning Yuda emora emo tuwa ing?” Ayero senu Yesu mene eyero sena, “Yore, sinesa ara.” ");
INSERT INTO zia_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ayero sena ara. Arata be pirisa babuzere simaire mene nung gera pugari sero ge sewa be aune nung ge abena oko sao yena. ");
INSERT INTO zia_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ayero yenu Pilato mene atata yero sena, “Ning eno ge mou-mesa yao sineya awiya nigitinesita?” ");
INSERT INTO zia_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ayero senu Yesu mene ge abena oko sao bora bora yero mitinu emo tuwa mene giro wawong di gauna ara. ");
INSERT INTO zia_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Magayao mene awong Daigaina auna iya sero emo tuwa nung Yuda emo zo yazo yau sinauwa emo awiya bunao gare atu besero ayero nasani nauna. ");
INSERT INTO zia_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Arare be auna atu gorobo emo meko nibamu zo bunao gare mitina yazo nuna Barabas. ");
INSERT INTO zia_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Arare emo apakana augairo dodopinewa Pilato mene atata yero sena, “Emo zota zo besanese sinei? Na Barabas besanese sineita Yesu nung emo tuwa Kristo asineya, nung awiya besanese sinei?” ");
INSERT INTO zia_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato mene ayero sena, noeno okowata, Yesu mene buro nasani naunu emo bauno Yudara gitau yao emo yangdoro nuna-una bautunauwa aeno gitau yao emo mene nung eno tini kapao puro nung puro buro nuna-una newa, ayero gigina. ");
INSERT INTO zia_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Be aune emo tuwa nung ge sao tau yao masi nuna-una adungno mitinu bauno nuna mene ge eyero pugainu baungna, “Ning emo dang auna ge osina zo oko sase. Noeno okowata, na yeme atiyo yero nung aeno yaya baina tapunete gigena.” ");
INSERT INTO zia_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Arare pirisa babuzere simaire awong emo bauno dawong gaero eyero sewa, “Barabas ao-diro Yesu daese sepu.” Ayero sewa. ");
INSERT INTO zia_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Arare emo tuwa mene nupema atata yero sena, “Zota zo besanese sinei?” Ayero senu awong eyero sewa, “Barabas.” ");
INSERT INTO zia_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ayero sewa nung atata yero sena, “Ayero Yesu Sorao Emo Kristo ayero sinowa nung eno nono yarineni?” Ayero atata yenu be kerero zayero wawa sero eyero sewa, “Nung i pasaora magayaise.” ");
INSERT INTO zia_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ayero sewa Pilato mene nupema atata yero sena, “Noeno ayero sinei? Nung pasena no yeni?” Ayero senu awong atata auna susuwa oko sao yangdoro wawa sero eyero sewa, “I pasaora magayaise.” ");
INSERT INTO zia_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ayero sewa Pilato ge sero tetere yero giro winade bainakama kasa yoiye sero awang nasani senu soumani ou puro bumuwa nung Yuda emora benaungna atu wawong nuna sainasani eyero sena, “Emo pewayao ewiya dao magayao auna pasena awiya nana-una oko mitaise. Awiya nona ninae gege.” ");
INSERT INTO zia_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ayero senu awong be kerero wawa sero eyero sewa, “Dao magayao nuna auna pasena awiya nae aune saisibuna nanae auna-una mitaise.” Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ayero sewa Pilato mene senu Barabas besewa kasa yenu awong Yesu angsi wo tata mene yao amimene wezewa ara. Wezinete duwa aune Pilato mene Yesu i pasaora daya magayaise sero gorobo emora waweng pugaina ara. ");
INSERT INTO zia_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pilatora gorobo emo ena mene Yesu puro Roma emo tuwara gare witiro sewa gorobo emo apakana nuna-una augaiwa ara. ");
INSERT INTO zia_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Augatinasani Yesura taung wori dutugairo taung wori yuyao wosogaiwa pungna. Awiya emo tuwara taung wori wosogaine yewa pungna. ");
INSERT INTO zia_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ayero yero angsi dungne puro ewero aune ziyo nuna-una atu wosogaiwa ara. Ayero yero itu zo pugaiwa wawong me mene puro dopena ara. Ayero dopero mitinu nuna-una nugu baungno boma gaero nung izinasani eyero sewa, “Iya iwaing, Yuda emora emo tuwa.” ");
INSERT INTO zia_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ayero sero begura pisinasani itu sorero puro nung ziye dewa ara. ");
INSERT INTO zia_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ayero nasani nung izinasani nete gorobo emora taung wori dutugairo yangdoro taung wori nuna awiya nupema wosogaiwa pungnu i pasaora dari sero puro bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Puro bautunete nagibe atu emo zo tamuwa yazo nuna Simon, nung Sairini napora. Awong nung taungno ato sewa Yesura i pasao soreuno diunu bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bautunete tawing zo yazo Goligata, ge naname-una “Gitau Atora Wetu,” atu kasa yewa. ");
INSERT INTO zia_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kasa yero ou wain puro ou dokowang yao yaya nuwegaora ou aune dema dawero pugaya minaise pugaiwa miniro giro yangduna ara. ");
INSERT INTO zia_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ayero yero nung i pasaora dewa ara. Dero aune taung wori nuna itagi yero pumari sero ge tuwao zo yazo nuna laki awiya yewa ara. Ayero aune taung wori nuna bono yero pumuwa ara. ");
INSERT INTO zia_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ayero nung diya nasani adungno mitiwa ara. ");
INSERT INTO zia_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ika i pasao tame atu susuwa nouna nung dewi auna ge eyero gaero pugaiwa mitina, “Ewiya Yesu, Yuda emora emo tuwa.” ");
INSERT INTO zia_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Emo ugaing mani etobe nung aune dema i pasaora dero zo enaba zo enaba ayero pugaiwa dopewato ara. ");
INSERT INTO zia_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Masi auna atu emo puma-sauma nasani Yesu izero nung eno eyero sewa, ");
INSERT INTO zia_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ae, ibu baina kasero wari be etama aune ibu seka yari sasa amimene taung aingso nina gera yaora atu sore. Ning Tuwa Bayaura mani me nosi siya, arare ning nika nitope i pasaora atu wosi dopase.” ");
INSERT INTO zia_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Pirisa babuze aune sao tauyao ge gipao emore simaire awong deka ayero nung izinasani sewa, ");
INSERT INTO zia_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Nung gitau emo ena soreuno kora yero nasani nauna, arata nung nuka nutope soremao ine teng oko ara. Nung Isreli emora emo tuwa naname noita, aeno i pasaora atu yeme wosai nung Sorao Emo naname me ayero sarinenane. ");
INSERT INTO zia_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nune ‘Na Tuwa Bayaura Mani’ asinasani Tuwa Bayau tumo didinoiya, arare Tuwa Bayau mene nung aratapu nasani giro nung sorero pumaise ganene.” ");
INSERT INTO zia_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ayero sewa pasena emo etobe dema awongto Yesu deka ayero izewato ara. ");
INSERT INTO zia_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ayero nung eno newa wari diti 12 kilok yenu mume baina kasa yero tawing teng yero mitinu 3 kilok yena ara. ");
INSERT INTO zia_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Arare 3 kilok yenu aune Yesu mene wawa sero eyero sena, “Eli, Eli, lema sabaktani.” Ge naname-una, “Tuwa Bayau nana, Tuwa Bayau nana, ning nono yero na dotinesi?” ");
INSERT INTO zia_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ayero senu dopero mitiwa auna ena mene nigiro eyero sewa, “Nung Eliya yau siniya.” ");
INSERT INTO zia_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aune zo mene nigiro mena sungno baungno witora yabutata zo puro wain dokowang yao dusero itura diro Yesu mene minaise sero pugainu witina ara. ");
INSERT INTO zia_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ayero yenu ena mene giro eyero sewa, “Ning yangdo. Eliya mene buro nung batagairo pugai wosarinita, awiya ganene.” ");
INSERT INTO zia_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ayero sinewa Yesu nung nupema wawa bainakama senu oweno aung yenu magayena ara. ");
INSERT INTO zia_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Magayenu ibu bainana mo bainakama kimegao awiya ika atu zayero kerero dao etobe yena ara. Dumi bainakama ipenu daba babuze bebezegaiwa. ");
INSERT INTO zia_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ayero yenu biriti be gausenu ge emo gitau magayao ena mene seka yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ayero yewa ago Yesu nung nuka nutope gitau yero iropunu aune awong biriti nunae-una atu iropuro Yerusalem napo dang auna baungno emo bauno daigairo auna-una kasa yewa gigiwa ara. ");
INSERT INTO zia_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Gorobo emora gitau yao aune gorobo emo nuna ena awong Yesu diya nasani dopero mitiwa amimene dumine nona enane dema kasa yena awiya giro awang yero sewa, “Emo ewiya kara meba Tuwa Bayaura Mani ara.” ");
INSERT INTO zia_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Mani bauno daigairo Yesu Galilaya tawingna atu ago yero nasani sou buro nauwa amimene ake ina atu dopero tani awiya gosinasani mitiwa ara. ");
INSERT INTO zia_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nunae-una ena awiya Maria Madala napora, aune Maria yazo nung Yakoboto Yosefera ai, nupema Zebedira mani etobe auna ai dema. ");
INSERT INTO zia_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ture inu aune Arimatia napora emo waure zo yazo nuna Yosefe, nung Yesura ge nigitinasani nauna, amimene baungno kasa ye ");
INSERT INTO zia_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilatora-una gairo Yesura taung aingso pumari senu nigina ara. Nigiro taung aingso pumaise gorobo emo eno senu yangduwa. ");
INSERT INTO zia_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yangduwa Yosefe mene taung aingso puro mo neyangyao sekawa zo imoko-kaungkaung mene ewero ");
INSERT INTO zia_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","puro baungno daba uma sekawa wamao biriti gerao nuka nuna auna atu Yesu pugairo daba bainakama zo dereme yenu baungno be gazenu yangdoro baungna ara. ");
INSERT INTO zia_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ayenu biriti auna bera atu Maria Madala napora nung yazoreto adungno mitiwato ara. ");
INSERT INTO zia_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Fraide ture weno dung mume yenu Sarerera be zayewa be aune pirisa babuze Farisayore awong au dekaongna gairo Pilatora-una bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Baungno eyero sewa, “Emo tuwa nanae, nae ge zo kotupunenane, awiya sanane. Ge iwao emo omimene nung seka nasani eyero sero nasani nauna, ‘Na magayero wari be etama aung yai aune seka yero iroparinena.’ ");
INSERT INTO zia_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Gitau nung seka nasani aune nuka nutope Sorao Emo Kristo ayero sero naunu meko yero nauna. Arata yeme awiya buro-mani nuna mene baungno taung aingso nuna ugaing puro tara yero aune, ‘Nung magayaora atu iropuro seka yetiya,’ ge asero name eno ge iwaya meko yore yariniya. Arare awong ayero yowi sero, ning ge sasa gorobo emo mene baungno diya yero baingtitinaya wari be etama aung yaise.” ");
INSERT INTO zia_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ayero sewa Pilato mene awong eno eyero sena, “Gorobo emo pugatinena. Arare niye puro baungno pugaipu umo yero baingtiti nasani mitae.” ");
INSERT INTO zia_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ayero senu awong gorobo emo aune dema baungno daba be gazao awiya angsi mene diwa. Ayero yero angsi osina besaya mitai gari sero angsi osina etobe awiya i saora mung mene dewa saneneungna ara. Ayero yero gorobo emo ena biriti diya yaese pugairo ayero yewa ara. ");
INSERT INTO zia_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat iya aung yenu Sande gora iya gatinenu Maria Madala napora nung yazo nuna auneto biriti gari sero bamuwato ara. ");
INSERT INTO zia_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Bautunewato dumi bainakama ipenu Tuwara angelo zo mene uritira atu wosiro daba dereme enaba yenu baungnu nung tame adungno mitina ara. ");
INSERT INTO zia_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Benaung nuna awiya zayang-zayang nasani waegatinena. Taung wori nuna imoko-kaungkaung awiya neyangyao, bereze ine ara. ");
INSERT INTO zia_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Arare diya emo awong giro awang yero wetu ipenu zuwero mamagayao ine yero mitiwa ara. ");
INSERT INTO zia_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ayero mitiwa bauno etobe baungno kasa yewato angelo mene eyero sena, “Nito awang oko yaeto. Na gosinena. Nito Yesu i pasaora dao awiya gari sero butuneyato. ");
INSERT INTO zia_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Arata nung etu oko mitiya. Nung gitau niye eno sena deka ayero iropumiya. Nito bungputo, masi nuna gaeto. ");
INSERT INTO zia_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Diti moko ninato mene giro aune mena baungno buro-mani nuna eno eyero seputo: Yesu nung magayaora atu iropuro Galilaya tawingna gitau bautuniya. Arare niye baungno nung atu garineya. Ge kara sinena ara.” ");
INSERT INTO zia_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Angelo mene ayero senu giro awongto awang yero biriti doro mena kapetegairo sungno bamuwato. Arata awongto yawa yawa bainakama dema yero buro-mani nuna eno bowi sari sero sumao gege sungno bamuwato ara. ");
INSERT INTO zia_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Bautunewato Yesu mene nagibe atu awongto taungno eyero sena, “Gora iwaing.” Ayero senu awongto nuna-una nugu koing gairo te nuna iniwato ara. ");
INSERT INTO zia_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ayero yewato Yesu mene eyero sena, “Nito awang oko yaeto. Baungno otao mani nana sayato Galilaya tawingna baungno na garineya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bauno etobe bautunewato biriti diya nunae-una ena mene mena sungno baungno nape atu pirisa babuze eno ungwe didinasani tani kasa yena auna ungwe diro aung yewa. ");
INSERT INTO zia_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ayero sewa nigiro awong simaire dema augairo ge sero nigiro ayero aune gorobo emo eno moni witao pugatinasani eyero sewa, ");
INSERT INTO zia_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Niye eyero sepu, ‘Pingne auriti awinenane buro-mani nuna mene kasa yero aingso nuna ugaing puro babeya.’ ");
INSERT INTO zia_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ge awiya emo tuwa mene nigiro niye eno nona zo yao eno awang oko yae. Nae nung zawagairo sanane nigariniya.” ");
INSERT INTO zia_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ayero sewa gorobo emo mene moni awiya puro ge sewa awiya dimuwa ara. Arare ge iwao ge awiya Yuda emora-una teng yena. Teng yero mitoiya mitiya. ");
INSERT INTO zia_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Buro-mani 11 awong Galilaya tawingna diri zo gitau Yesu mene awong eno sena auna witiwa ara. ");
INSERT INTO zia_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Witiro nung maze giro nuna-una baungno kokoing gaiwa ara. Dekaong dekaong mene dubo gagausewa ara. ");
INSERT INTO zia_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Arare Yesu mene nunae-una nugu baungno eyero sinasani tugata yena, “Putoung baina uritira aune tawingna aune apakana na eno pugairo aung yao. ");
INSERT INTO zia_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Arare niye tawing sero sero bautunasani emo bauno dubu sero ge tugata yaya nigiro awiso nana yae. Ayero nasani Mama, Mani aune Oweno auna yazora susupunasani ge ou suwepu pumae. ");
INSERT INTO zia_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Wini ge sero gipero ayero nona amaze gipepu diungno aung yae. Sana nigipu. Na wari be giti niye aune dema nana tawingna be aung yariniya arauwa.” ");
INSERT INTO zia_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yesu Kristo Tuwa Bayaura Mani auna Bowi Iwaing eyero kasa yena era. ");
INSERT INTO zia_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Porofete zo yazo nuna Yesaya mene bukura ge ewiya gaenu mitoiya era, Ewiya gipu! Na bowi sao emo nana iyengtarinena. Nung gitau yero nagibo nina kora yariniya. ");
INSERT INTO zia_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nung eu yanawira atu wawa sero eyero siniya, “Tuwara nagibo awiya kora yepu korosae.” ");
INSERT INTO zia_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yesaya mene ge ayero gaena deka ayero Yohane ge ou zayero suwao emo amimene eu atu mitasani ge putoungne sinaunu nigiti nasani nauwa. Eyero sinauna, “Niye dubo darawa yero nao memeko ninae duwaya giro aune na niye ge ou suwarinena. Ayero yaya aune Tuwa Bayau mene pasena ninae disai aung yariniya.” Ayero sero nauna ara. ");
INSERT INTO zia_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yudaya tawingna emo bauno arita napo baina Yerusalem auna emo bauno apakana amimene nuna-una baungno pasena nunae keregati nauwa aune nung awong ou Yodan auna atu ge ou susu nauna arauwa. ");
INSERT INTO zia_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohanena mo awiya wo kameli tumiza puro gaewa ara. Ipura geing nuna awiya wo aingso ara. Nung koware aune pika ou amaze mininauna. ");
INSERT INTO zia_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yohane mene Tuwa Bayaura ge eyero sinauna, “Na gitau nena, arata na putoung aung. Ora emo zo ago bariniya auna putoung bainakama. Nune na daigatiniya ara. Na utero te soga nuna-una angsi awiya besao ine teng oko ara. ");
INSERT INTO zia_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nane ge ou gege niye eno pugena pumeya, arata nune mene zo ge ou Owenone niye eno pugai pumarineya.” Ayero sinauna arauwa. ");
INSERT INTO zia_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ayero newa aune Yesu napo Nasarete Galilaya tawingna mitiya auna atu bunu Yohane mene nung ou Yodan auna atu ge ou suwena ara. ");
INSERT INTO zia_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ayero yenu Yesu oura atu wiwiti nenu uriti gausenu Oweno mene nuna-una towari sero ni audubo ine yero wowosinenu gigina. ");
INSERT INTO zia_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Diti yero gosinenu ge zo eyero uritira atu wosina, “Ning mani nana. Ning yo dingya nana. Na ning giro yawa yawa nena.” ");
INSERT INTO zia_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ge wosinu Oweno mene nung puro eu baungna. ");
INSERT INTO zia_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Eu baungno wari be 40 mitaunu Sanda mene nung etegari yena. Yesu eu wo somara atu nenu angelo mene nung kora yewa. ");
INSERT INTO zia_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Emo ena mene Yohane puro bunao gare pugaiwa aune Yesu mene Tuwara Bowi Iwaing awiya sero sero yero baung Galilaya yena. ");
INSERT INTO zia_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Galilaya baungno eyero sena, “Be kasa yetiya. Tuwa Bayau nata tuwa yero nariniya auna be kasa yetiya. Niye dubo darawa yero Bowi Iwaing nigipu me yae.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu mene ou nazi Galilaya auna bage atu nete Simon meta nuna Anderea awongto wo buro nasani nauwato amimene moga oura papatinewato gigina ara. ");
INSERT INTO zia_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Giro awongto eno eyero sena, “Nito bungputo, na ago yaeto. Na nito gipana emo bauno pumao emo yaeto.” ");
INSERT INTO zia_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ayero senu giro awongto moga nunato atu doro Yesura ame bamuwato ara. ");
INSERT INTO zia_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu mene nupema maingkoka bage-bage baungno menetatore etobe yazo nunato Yakoboto Yohane, awongto Zebedira mani, amimene wangna atu mitasani moga kora newato awiya gigina. ");
INSERT INTO zia_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Giro yausenu awongto maung nunato Zebedi awisore wangna atu doro Yesu aune dema bamuwato arauwa. ");
INSERT INTO zia_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Awong baung napo Kapaneam yewa. Atu newa oregaora be yazo nuna Sabat awiya kasa yenu giro nung Yuda emora yere ibu auna toiro awong eno ge tugata yena ara. ");
INSERT INTO zia_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nung ge tugata nenu awong ge nuna nigiro wawong di gapunewa ara. Awiya noeno okowata, nung gera susuwa mene ge diro baingtina, awiya sao tauyao ge gipao emo nunae gipinauwa awiya doro daigairo putoungne sena ara. ");
INSERT INTO zia_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ayero gipinenu emo zo iwae mene nuna una toiro mitina amimene yere ibu nunae-una atu kasa yena. ");
INSERT INTO zia_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Kasa yero ge betero eyero sena, “Yesu Nasarete napora emo, ning no yari sero nanae-una butunesi? Ning nae sisigari sero butunesita nowa. Na susuwa nina gosinena. Ning Tuwa Bayaura mani wosewa zebao.” ");
INSERT INTO zia_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ayero sena ara, arata Yesu mene iwae tunero eyero sena, “Ning ge doro nung doro baung.” ");
INSERT INTO zia_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ayero senu giro iwae mene emo awiya denu angzi apunenu iwae be kerero aiyamama sero nung doro baungna ara. ");
INSERT INTO zia_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ayero yenu emo bauno mene giro wawong di gauno ge wina-se nasani atata yero sewa, “Ewiya noiye? Nung gipao ge seka zo gipiniya. Nung emo putoungne ine yero ge sinoi nona apakana ge nuna dipunowa. Iwae dema ge nuna dipunowa.” ");
INSERT INTO zia_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ayero sewa bowi nuna amimene baungno Galilaya tawingna teng yena ara. ");
INSERT INTO zia_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu buro-mani nuna aune dema ayero yero yere ibu doro Simonto Andereara-una gare toiwa Yakoboto Yohane awongto aune dema toiwato. ");
INSERT INTO zia_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simonna imeti mene yaya taung kokoni yao puro apegairo mitinu giro awong bowi nuna Yesu eno sewa ara. ");
INSERT INTO zia_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Sewa giro Yesu mene nuna-una baungno wawong nuna ininu iropunu taung kokoni yao awiya aung yenu nung nona nunae sairo pugainu miniwa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ture itinenu awong emo bauno yayare aune emo bauno iwae puro nasani nauwa awong awiya puro nuna-una kasa yewa. ");
INSERT INTO zia_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ayero yewa napora emo bauno apakana amimene be towaora atu wina-mise yero towari sero yewa. ");
INSERT INTO zia_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu mene senu emo bauno daigairo yaya ewe-pape puro nasani nauwa amimene iwaing yewa. Iwae daigairo tunenu bamuwa. Iwae mene nung gosinauwa, arare nung awong ge sao awang senu awong ge sao ine teng oko yewa. ");
INSERT INTO zia_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pingne iya oko gaore nung iropuro garo doro soma zo emo bauno aung auna baungno isa sinenu ");
INSERT INTO zia_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon aune emo ena nung aune dema nauwa amimene nung kau yero baungno, ");
INSERT INTO zia_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","taungno eyero sewa, “Emo bauno apakana ning kauneya.” ");
INSERT INTO zia_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ayero sewa nung eyero sena, “Napo babuze nugu miteya auna dema babarinenane. Atu baungno na Tuwa Bayaura ge awong eno sane. Noeno okowata, na buro awiya eno bumuwang.” ");
INSERT INTO zia_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ayero sero nung yere ibu nunae Galilaya tawingna mitauwa auna baungno Tuwa Bayaura ge tugata nasani iwae ena tuni nasani nauna arauwa. ");
INSERT INTO zia_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Yesu tani ayero nenu emo zo bozo tauyaore mene Yesura-una buro boma gaero koing gairo eyero sena, “Ning putoung nina mitiya, arare ning na kora yari yero giro kora yasa iwaing yarinena.” ");
INSERT INTO zia_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ayero senu Yesu mene nung yo yenu giro nung kora yari sero wawong pugairo nung dingyero eyero sena, “Yore, na ayero yari kotupunena. Taung nina iwaing kasa yaise.” ");
INSERT INTO zia_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ayero sinenu bozo tauyao nuna mena soyewa taung nuna iwaing yena. ");
INSERT INTO zia_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ayero yenu Yesu mene nung mena babaise sero ge tauyao nung eno eyero sena, ");
INSERT INTO zia_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Tani ning eno yetena auna bowi awiya emo zo eno oko sase. Arata ning baung, taung nina awiya pirisa eno gipasa gae. Ayero nasani nona Mose mene Tuwa Bayau eno pugaese sena, awiya pugasa yaya nina aung yetiya auna susuwa giro baingtarineya.” ");
INSERT INTO zia_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ayero senu emo awiya garo doro baungna ara. Arata nung emo bauno daigairo aeno ge sinasani auna bowi awiya sero sero yena. Arare Yesu mene napo zota zora emo bauno auna ditira babao ine teng oko yenu giro nung soma emo bauno aung auna baungno mitaunu emo bauno euna aune ouna aune ayero nuna-una kasa yero nauwa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wari be ena aung yenu Yesu mene nupema tera baung Kapaneam yenu emo bauno mene Yesu kapete nuna gare gairo mitina awiya nigiwa. ");
INSERT INTO zia_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nigiro emo bauno daigairo mene nuna-una buro augaiwa garo mokore bautare apakana beburo aung yena ara. Ayero yewa nung Tuwa Bayaura ge awong eno sinasani mitinu ");
INSERT INTO zia_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","emo ena mene emo zo te wawong amao awiya puro bumuwa ara. Emo siwongpatige amimene emo awiya diungno puro bumuwa. ");
INSERT INTO zia_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Arata emo bauno witao mitiwa, arare awong Yesura-una nugu babao ine teng oko yenu giro awong garo eno nung wese mitina atu be yero emo gogare awiya pugaiwa wosina. ");
INSERT INTO zia_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ayero yewa Yesu mene inao nunae giro mani yayare aeno eyero sena, “Mani nana, na pasena nina disinena.” ");
INSERT INTO zia_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ayero senu Yudara sao tauyao ge gipao emo ena mene eyero kotupunasani mitiwa, ");
INSERT INTO zia_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Emo emimene Tuwa Bayau mene yaine niya. Emo zo mene pasena disao ine teng oko. Awiya Tuwa Bayaura buro gege.” ");
INSERT INTO zia_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ayero kotupunewa giro Yesu mene awong kotupunewa awiya mena yetine yero giro awong eno eyero sena, “Niye nono yero ayero kotupunei? ");
INSERT INTO zia_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Name emo yayare aeno, ‘Iropu, ang yase’ tebeba ayero sanane nung oko ang yao yariniya, awiya name meng garinenane. Noeno okowata, emo bauno mene ge naname gaya ge iwao yariniya. Arata name, ‘Na pasena nina disinena,’ tebeba ayero sarinenane, awiya name meng oko garinenane. Noeno okowata, emo bauno mene ge naname-una me awiya gao ine teng oko. ");
INSERT INTO zia_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Arare na pasena disaora putoung puro tawingna etu nona, awiya gaese sero na ge ewiya dema nung eno sarinena, ");
INSERT INTO zia_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Na ning eno eyero sinena: Iropu, awao masi gogare nina puro garo nina-una babase.” ");
INSERT INTO zia_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ayero senu nung iropuro awao masi gogare nuna puro emo baunona diti mokora atu garo doro baungna ara. Ayero yenu awong wawong di gauno Tuwa Bayau bowi yero eyero sewa, “Name tani eyao ine gitau oko gao.” Ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu mene soma awiya doro ou nazira nugu nupema baungnu emo bauno apakana mene nuna-una kasa yewa ge tugata yena ara. ");
INSERT INTO zia_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Atu nawe garo awiya doro bautunete emo zo yazo nuna Lewi, nung Alifayora mani, nung amimene takis pugaora gare atu adungno mitinu giro nung eno eyero sena, “Ning na ago ye.” Ayero senu giro nung iropuro nung ago yena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesu mene Lewira-una gare baungno adungno nona mininasani mitinu takis pumao emo aune Yudara sao tauyao ge dao emo daigairo amimene Yesu buro-mani nuna aune dema adungno mitiwa. Emo ayetugao daigairo amimene Yesura ame nasani nauwa. ");
INSERT INTO zia_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Arare Farisayora sao tauyao ge gipao emo ena mene Yesu takis pumao emo aune Yudara sao tauyao ge dao emo aune dema nona mininasani mitina, awiya giro buro-mani nuna eno eyero sewa, “Nung nono yero takis pumao emore ge dao emo aune dema nona mininiye?” ");
INSERT INTO zia_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ayero sewa Yesu mene ge awiya nigiro awong eno eyero sena, “Emo yaya aung mene doktara-una oko bautunowa. Arata emo yayare mene gege doktara-una bautunowa. Na emo nao nunae pewayao asinowa awiya yausari oko bumuwang. Arata na emo pasena yao emo awiya yausari bumuwang.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Be aune Yohanena buro-mani aune Farisayo awong amimene nona minao semini nasani mitiwa. Arare emo ena mene buro Yesu atata yero sewa, “Susuwa noeno Yohanena buro-mani aune Farisayora buro-mani amimene nona seminineya buro-mani nina mene nona oko seminao yero nei?” ");
INSERT INTO zia_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ayero sewa Yesu mene awong eno eyero sena, “Emo bauno ataora bonene nasani mitaya emo nung bauno atariniya amimene awong aune dema nariniya be aune nona seminaese saya nigarineita? Aung arauwa. Awong emo aune dema narineya be aune seminaese saya oko nigarineya. ");
INSERT INTO zia_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Arata ago emo awiya iwo mene puro babaya aung yariniya be aune awong nona seminarineya. Deka ayao ine na eno yaya aune buro-mani nana mene nona seminarineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yesu mene eyero sena, “Name mo toto yangtagairo gayari sero mo be seka puro mo asora atu oko gainonane. Ayero yarinenane, awiya mo seka mene watimai mo aso awiya nupema kerai toto bainakama yariniya. ");
INSERT INTO zia_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nupema, name ou wain seka puro meme aingso matura oko sukupunonane. Ayero yarinenane, awiya ou wain mene daing yero titisero meme aingso misero pisai kerai ou wainne meme aingsore awiya gera yarinenane. Name ou wain seka puro meme aingso sekara sukupunonane.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabat iya be zore Yesu buro-mani nuna aune nagibe atu bautunete wuit buro zo buwagati nasani buro-mani nuna mene wuit me kowero miniwa. ");
INSERT INTO zia_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ayero yewa giro Farisayo mene nung eno eyero sewa, “Sao tauyao ge mene awong buro zo Sabat iya be aune yao awang siniya awiya neya, gosinesita?” ");
INSERT INTO zia_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ayero sewa Yesu mene awong eno abena eyero sena, “Niye ungwe zo Dawidi aune emo ena nung aune dema nauwa, awong nona minao aung, meri apunasani mitiwa auna ungwe awiya niye oko nigao mene saine neya, awiya! ");
INSERT INTO zia_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abayata mene pirisa baina yero nasani nauna be aune Dawidi mene Tuwa Bayaura ibu auna toiro ame Tuwa Bayaura benaungna pugati nasani nauwa awiya minina. Ame awiya awong wosao mene minaese sao oko. Pirisa gege mene minaese sao ara. Arata Dawidi mene ame awiya puro dubu nuna eno pugainu miniwa Tuwa Bayau mene giginu meko oko yena.” ");
INSERT INTO zia_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ayero sero susuuno eyero sena, “Tuwa Bayau mene Sabat iya be amimene emo bauno soremaise pugaina. Arata emo bauno mene Sabat iya be awiya soremaese oko pugaina. ");
INSERT INTO zia_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Arare na Emora Mani mene nona apakana auna Tuwa yero nona amimene Sabat iya be auna Tuwa dema yero nona.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu mene yere ibura nupema toiro emo zo wawong amao atu mitinu tauna. ");
INSERT INTO zia_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Emo bauno atu mitiwa amimene Yesu anuwing nasani “Nung emo yayare awiya Sabat iya be eune kora yarinita?” asero etuti nasani mitiwa. Awong Yesu gera pugari sero kotupu nasani newa, ");
INSERT INTO zia_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","arare Yesu mene emo wawong amao aeno eyero sena, “Era gapo.” ");
INSERT INTO zia_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ayero sero nung atu awong eno eyero sena, “Name tani iwaing Sabat bere yanane teng yarinita, tani meko yanane teng yariniye? Ora name emo bauno soremanane iwaing yaya teng yarinita, emo gera yanane magayaya teng yariniye?” Ayero sena, arata awong bora-bora yero mitiwa. ");
INSERT INTO zia_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ayewa nung diti-dati yero tini kapenu nupema kotumao meko nunae giro awong eno yo-aungno moko nuna zi sinenu giro emo aeno eyero sena, “Wawong iteti.” Ayero senu wawong itetinu wawong iwaing nupema yena. ");
INSERT INTO zia_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ayero yenu Farisayo mene ibu doro kasayero mena baungno Herodera Pati memba ena aune dema augairo Yesu daya magayaise auna nagibo tamari sero yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu buro-mani nuna aune baung ou nazira yewa ara. Galilaya emo bauno dubu bainakama mene nung aune dema bamuwa. Ayero yewa emo Yudaya tawingna aune ");
INSERT INTO zia_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","emo napo Yerusalemna aune emo Idumia tawingna aune emo ou Yodan enabara aune emo napo Tayato Saidonna amimene buro apakana Yesu mene nasani nauna auna ge nigiwa, arare awong witao amimene nuna-una bumuwa. ");
INSERT INTO zia_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ayero yewa nung buro-mani nuna eno eyero sena, “Emo bauno ewezoware na patowi sero wang zo sosero kora yero nugu pugaipu mitae.” ");
INSERT INTO zia_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ayero sena, noeno okowata, gitau nung emo yayare daigairo awiya kora yenu giro emo bauno yayare apakana amimene nung dingyari sero wina-mise nasani mitiwa. ");
INSERT INTO zia_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Arare emo bauno iwae nunae-una mitiwa amimene nung giro te nuna-una zuwero aiyamama sinasani eyero sinauwa, “Ning Tuwa Bayaura Mani.” ");
INSERT INTO zia_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ayero sinauwa Yesu mene ge tauyao iwae eno sinasani awong susuwa nuna emo ena eno keregao awang sinauna. ");
INSERT INTO zia_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu mene diri witiro emo ena ara taungno yausenu nuna-una bumuwa. ");
INSERT INTO zia_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nung awong yangtagairo kora yero emo 12 puro burora pugairo awong nung aune dema naese sena. Nung awong iyengtai Tuwa Bayaura ge saese, ");
INSERT INTO zia_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","o iwae tunaora putoung awiya pumaese sena ara. ");
INSERT INTO zia_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nung buro-mani 12 yangtagairo puna auna yazo nunae era: Nung yazo seka Simon eno pugairo Petoro asena ara. ");
INSERT INTO zia_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobo nung Zebedira mani aune meta nuna Yohane auna yazo seka Boanege asena ara. (Ge naname-una, “Bibiyara mani.”) ");
INSERT INTO zia_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anderea, Filip, Batolomiu, Matiu, Tomas, Yakobo nung Alifayora mani, Tadias, Simon Zelote, ");
INSERT INTO zia_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yudas Iskeriot nung Yesu keregairo iwora waweng pugao emo. Yesu mene buro-mani awiya burora pugairo aune nung doro baung nuna gare yena. ");
INSERT INTO zia_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Emo bauno daigairo mene nupema Yesura-una bumuwa nung aune mani awiso nuna aune awong nona minaora be daigaiwa. ");
INSERT INTO zia_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ayewa giro dubu nuna ena mene ge awiya nigiro, “Nung dau yaine niya,” asero nung sorari bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yudara sao tauyao ge gipao emo ena mene Yerusalem atu wosiro buro eyero sinasani mitiwa, “Iwae yazo nuna Bielsebul amimene nuna-una toiro mitiya. Arare iwaera gitau yao amimene nung sorepunoi iwae tuninoiya.” Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Arare Yesu mene emo bauno yausenu bumuwa ge pungyao ena awong eno eyero sena, “Sanda mene nono yero nutope tunariniye? ");
INSERT INTO zia_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Napo dekaongka auna emo bauno mene gausero wina-de yarineya, napo awiya tauyao oko mitarineya. ");
INSERT INTO zia_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ora dubu zo gausero ge wina-se nasani iwo wina-ye yarineya, dubu awiya tauyao oko mitarineya. ");
INSERT INTO zia_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sanda mene nutope iwo nuna yero putoung nuna gausero nariniya, awiya nung tauyero mitao teng oko yariniya. Putoung nuna aung yariniya. ");
INSERT INTO zia_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Name emo putoung bainane zora wau apakana pumari sero gitau emo awiya bunero aune nuna-una gare toiro wau nuna apakana pumarinenane ara. ");
INSERT INTO zia_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Na memoko sana nigipu. Emo baunona pasena apakana arita Tuwa Bayau izao ge nunae awiya disao teng niya. ");
INSERT INTO zia_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Arata zo nung Oweno izariniya emo auna pasena disao ine teng oko ara. Pasena nuna mitao gege mitariniya.” ");
INSERT INTO zia_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu ayero sena. Awiya noeno okowata, awong nung eno eyero sewa, “Iwae mene nuna-una toiro mitiya.” ");
INSERT INTO zia_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ai nuna aune metamani nuna awong buro garo bautara atu dopero mitasani Yesu nunae-una baise sewa. ");
INSERT INTO zia_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Asewa emo bauno dubu baina Yesura-una nugu adungno mitiwa amimene nung eno eyero sewa, “Ai nina aune metamani nina amimene ning gari sero buro bautara atu dopero miteya.” ");
INSERT INTO zia_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ayero sewa nung abena eyero sena, “Ai nana metamani nana awiya nami i?” ");
INSERT INTO zia_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ayero sero nung emo bauno nuna-una nugu adungno mitiwa awiya gosinasani diti-dati yero eyero sena, “Emo bauno emimene ayamani nana aune metamani nana aune neya. ");
INSERT INTO zia_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Emo bauno Tuwa Bayaura ge nigiro dipunowa amimene metamani numono aune ayamani nana neya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu nung ou nazira nupema baungno ge tugata nenu emo bauno daigairo nibamu amimene nuna-una kasa yewa. Ayewa giro nung senu wang isewa wosinu nung witiro adungno mitinu emo bauno diti bainane mene bage atu mitiwa. ");
INSERT INTO zia_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Atu mitiwa nung awong eno ge eniya ena sinasani ge witao awong eno tugata nasani yena. Tugata nasani awong eno eyero sena, ");
INSERT INTO zia_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Sana nigipu. Emo zo mene nona we bure atu sesari baungna ara. ");
INSERT INTO zia_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Baungno nona we sesinenu we ena nagibe atu wosiwa ni mamani mene taungno miniro aung yewa ara. ");
INSERT INTO zia_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ora we ena awiya tawing daba tame atu paka yero mitina auna atu wosiwa ara. Tawing awiya sori oko wiyai yao, arare we amimene mena koso yewa ara. ");
INSERT INTO zia_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tatai nunae deka ayero imokore oko bauna, arare wari mene witiro kokoni yenu irara yero magayero aung yewa ara. ");
INSERT INTO zia_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ora we ena awiya tawing iwe ena mitiwa auna atu wosiwa ara. We awiya iwere dema apakana teng-temo pusasa yero iropuro iwe mene nona awiya anenu me oko iyao yena ara. ");
INSERT INTO zia_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ora we ena awiya tawing me gawire auna wosiro iropuro zauno me witao iwa ara. We zora me 30 inu, we zora me 60 inu, we zora me 100 ina.” ");
INSERT INTO zia_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ayero sero sena, “Zo nung dawongne mene ge awiya nigaise.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Emo bauno zanewa aune emo ena mene Yesu aune dema nauwa arita buro-mani nuna 12 awong amimene ge eniya sena auna susuwa gari sero nung atata yewa. ");
INSERT INTO zia_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Atata yewa giro nung awong eno eyero sena, “Tuwa Bayau nata tuwa yero nariniya auna ge pungyero mitoiya, auna susuwa awiya niye ena mene nigaese sao mitiya ara. Arata ena awiya susuwa nuna pungyero mitai ge eniya gege sana nigaese sero sinona. ");
INSERT INTO zia_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Porofete Yesaya mene ge eyero gaena, Awong dubo kapete gairo nao sekara naya na Tuwa Bayau mene pasena nunae disoni sero, awong diti moko nunae mene gaese, arata oko giro baingtaese. Awong ungwe nigaese, arata ungwena susuwa oko nigiro baingtaese. Tuwa Bayau mene ayero sena, arare na ge eniya gege awong eno sinona.” Yesu mene ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu mene ayero sero awong eno eyero sena, “Niye ge eniya auna susuwa awiya oko gao neita? Arare niye nono yero ge eniya ena auna susuwa giro baingtarinei? ");
INSERT INTO zia_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Susuwa nuna eyao era: Emo we urari sesinoiya amimene Bowi Iwaing auna ge we urinoiya. ");
INSERT INTO zia_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Arata emo bauno enana dubo awiya nagibora tawing tauyao ine. Awong Bowi Iwaing nigitinowa Sanda mene mena buro Bowi Iwaing dawong nunae-una toitinoiya awiya sorinoiya. ");
INSERT INTO zia_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Deka ayao ine emo bauno ena awong tawing gawi aung daba tame paka yero mitoiya ayao ine ara. Awong uritira ge nigiro mena puro yawa yawa nowa. ");
INSERT INTO zia_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Arata awong tatai aung. Awong Tuwara nagibo awiya be maingkoka gege ago yero nema aune emo bauno mene uritira ge eno iwo awong eno yero nowa giro awong mena nagibo awiya dotinowa. ");
INSERT INTO zia_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Emo bauno ena mene awong tawing iwe mekore ine ara. Awong amimene uritira ge nigitinowa, ");
INSERT INTO zia_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","arata awong tawingna nona eno kotung-katung nasani wau moni eno yawa yawa nasani nona apakana aeno dubo-dubo nasani nowa, arare tani ayao amimene uritira ge worinowa me oko kasa yao noiya. ");
INSERT INTO zia_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Arata emo bauno ena mene zo tawing me gawire ine. Awong amimene uritira ge nigiro pu dube gairo me tapunowa — ena 30, ena 60, ena 100.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu mene awong eno eyero sena, “Name damana gaero puro au wese apero pugati nonineta? Aung arauwa. Ora name damana awiya garo bautara pugati nonineta? Aung arauwa. Name damana gaero gerura atu ikogati nonane. ");
INSERT INTO zia_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nona pungyao apakana ago kasa daung yarineya. Nona angayao apakana ago kasa daung yariniya. ");
INSERT INTO zia_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Zo nung dawongne mene ge ewiya nigaise.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nung awong eno eyero sena, “Ge nigitinowa awiya nigiro baingtipu. Niye nona emo bauno eno pugarineya teng Tuwa Bayao mene niye eno pugariniya. Nona aune nona enane kapetegariniya. ");
INSERT INTO zia_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tuwa Bayau mene emo zo ge me ena puro noiya aeno ge me bainakama pugariniya. Ora emo zo ge me maingkoka gege puro noiya auna ge me awiya Tuwa Bayau mene sorero pumariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu mene eyero sena, “Tuwa Bayau nata tuwa yero nariniya auna susuwa awiya eyero mitiya: Emo zo mene nona we buro nuna-una urinoiya. ");
INSERT INTO zia_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nona we urero nung awiro-dutiro anema we mene kosonoi aune emo amimene we koso yaora susuwa oko giro baingtao noiya. ");
INSERT INTO zia_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tawing mene nung nutope gawi nona eno pugatinoiya. Gitau koso yero kasa yero aune me wuzi noiya. Ayero yero aune me titisinoiya ara. ");
INSERT INTO zia_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Titisero sau itinoi aune emo amimene minaora be kasa yetiya asero giro emo ena iwi gegeru yaore nona pumaese sero bure pugatinoiya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu mene eyero sena, “Tuwa Bayau nata tuwa yero nariniya auna susuwa awiya pu nora gairo sarinenine? Name susuwa awiya keregari sero ge pungyao nora pugairo sanane teng yariniye? ");
INSERT INTO zia_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tuwa Bayau nata tuwa yero nariniya auna susuwa awiya i zo yazo nuna mastet asinonane auna me ine arauwa. Emo mene i me awiya bure atu urinowa. I me awiya tawingna i me apakana miteya auna wosao nunae ara. ");
INSERT INTO zia_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Arata urinowa mena bairo nona we ena bure atu urinonane awiya apakana daigairo baina noiya. Ayero noi bowang nuna babuze kasa yero nowa ni mamani mene utung nuna-una buro bowangna atu uwang gapunowa.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu mene ge eniya witao sinasani Bowi Iwaing emo bauno eno sero nauna ara. Nigao nunae auna teng sinauna. ");
INSERT INTO zia_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nung ge eniya gege awong eno sero nauna. Arata buro-mani nuna nata nung aune dema mitima nauwa giro be aune nung ge auna susuwa awong eno keregairo nasani nauna arauwa. ");
INSERT INTO zia_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Be aune ture inu Yesu mene buro-mani nuna eno eyero sena, “Name ou nazi buwagairo enabara babanene.” ");
INSERT INTO zia_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ayero senu giro awong emo bauno dubu baina awiya doro Yesu wangna atu kayero mitinu giro nung puro bamuwa. Wang ena awong aune dema bamuwa. ");
INSERT INTO zia_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bautu newa bisi yanakana sunu kakawa mene wang nosari sero nena. ");
INSERT INTO zia_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Be awiya Yesu nung wang age baungno ziyo guto zo pugairo apegairo auriti awinena. Arare awong nung uwero nung eno eyero sewa, “Gipao emo, name magayari sero nenane era, awiya ning gosinesita?” ");
INSERT INTO zia_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ayero sewa nung iropuro bisi gona yero kakawa eno eyero sena, “Ning aung ye. Bisi sero mitiung.” Ayero senu soma bisi binono denu ");
INSERT INTO zia_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","nung awong eno eyero sena, “Niye nono yero yo bainakama mininei? Niye inao aungta nowa?” ");
INSERT INTO zia_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ayero senu awong yangka sero eyero wina-se yewa, “Emo ewiya nono yao i? Nung sesi bisi oure dema ge nuna dipunei?” Ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu buro-mani nuna aune awong ou nazi buwagairo enabara kasa yewa. Tawing awiya Gerasa emora tawing. ");
INSERT INTO zia_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu wangna atu witinu emo zo iwae nuna-una toiro mitauna amimene biritira atu buro Yesura-una kasa yena. ");
INSERT INTO zia_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Emo awiya biritira daba umana atu mitasani nauna. Emo zo mene nung saniro bunaine yao teng oko. Angsi tauyao yazo nuna seni awiya dema teng oko yao ara. ");
INSERT INTO zia_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Gitau emo mene te wawong nuna seni mene buninauwa, arata nung wawongna seni watipu naunu kasugatinaunu tera seni deka ayero dedunaunu kasugatinauna ara. Emo zo mene nung saniro isiyao ine teng oko amimene nauna. ");
INSERT INTO zia_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pingne iyare nung biritira atu nasani diri atu nasani wawa sinasani nuka nutope daba mene kapinasani nauna. ");
INSERT INTO zia_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nung amimene ake-ina atu mitete Yesu giro sungno buro Yesura-una atu zuwero koing gairo ");
INSERT INTO zia_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","yausero aiyamama sinasani eyero sena, “Yesu, ning Tuwa Bayau ika mitoiya auna Mani, amimene na eno no yari butunesi? Na Tuwa Bayaura ditira atu sinasani ning na oko dasese sinena.” ");
INSERT INTO zia_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Emo amimene ayero sena, noeno okowata, Yesu nung eno mena eyero sena, “Iwae, ning emo ewiya doro baung.” ");
INSERT INTO zia_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Arare Yesu mene nung atata yero sena, “Yazo nina aweni?” Ayero senu abena eyero sena, “Yazo nana Dubu Baina. Noeno okowata, nae dubu bainakama.” ");
INSERT INTO zia_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ayero sero ge betinasani Yesu eno eyero isa sena, “Iwae tunasa ake oko babae.” ");
INSERT INTO zia_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Arare napo pu witao diri deungna atu nona kau nasani mitiwa giro ");
INSERT INTO zia_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","iwae mene Yesu eno yausero eyero sewa, “Nae tunasa pura-una towanene.” ");
INSERT INTO zia_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ayero sewa giro Yesu mene eyero sena, “Ayero yepu.” Ayero senu iwae mene emora-una atu kasa yero doro pura-una toiwa pu mene sungno kowara baungno ou nazira gugute gairo ou miniro mamaga yewa ara. Pu auna zare nunae awiya 2,000. ");
INSERT INTO zia_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pu diya yao emo amimene zanero baungno emo nape mitiwa aeno sero emo wo bogara mitiwa adema sewa giro awong tani kasa yena awiya gari sero bumuwa. ");
INSERT INTO zia_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Awong Yesura-una buro emo gitau iwae witao nuna-una mitauwa nauna amimene mo awiro kotumao iwaing puro adungno mitina awiya giro awang yewa. ");
INSERT INTO zia_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Emo ena tani emo auna-una atu kasa yenu gigiwa amimene ge ungwe awiya yewa. Nupema tani pura-una atu kasa yena awiya dema tugata yewa. ");
INSERT INTO zia_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ayero yewa emo bauno mene Yesu yausero tawing nunae ozaung doro babaise sewa ara. ");
INSERT INTO zia_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ayero sewa Yesu wangna wiwitinenu emo gitau iwae nuna-una mitiwa tunena amimene Yesu eno isa sero nung aune dema nari sena. ");
INSERT INTO zia_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Arata Yesu mene “Aungwa” sero nung eno eyero sena, “Dubu nina-una baungno Tuwa mene ning ao-diro tani iwaing ning eno yetiya awiya se nigae.” ");
INSERT INTO zia_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ayero senu nung baungno tawing yazo Dekapolis (ge naname-una, “Napo wawong etobe”) auna kasa yero tani Yesu mene nung eno yena auna ungwe tugata-magata yero yenu emo bauno apakana be angyero ge nuna gege nigiti nasani nauwa. ");
INSERT INTO zia_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu wangna witiro ou nazi nupema buwagairo enabara kasa yero bage atu mitinu emo bauno daigairo mene nuna-una kasa yewa. ");
INSERT INTO zia_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kasa yero mitiwa yere ibura simai emo zo yazo nuna Yairo amimene Yesu giro nuna-una baungno koing gairo ");
INSERT INTO zia_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","isa sero eyero sena, “Mani baunodi nana maingkoka amimene magayari sero niya. Ning bung. Ning mani kora yari sero giro wawong nina nuna-una tame pugasa nung iwaing yero nariniya, awiya gosinena.” ");
INSERT INTO zia_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ayero senu Yesu mene nung aune dema baungna. Bautunenu emo bauno daigairo mene nung aune dema bautunasani nung pu towang gairo puro bautunewa. ");
INSERT INTO zia_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Anewa bauno zo awong aune dema bautunena amimene yu pupunasani nawe dunu dawang 12 aung yenu yu pupunauna awiya oko soyao. ");
INSERT INTO zia_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nung dokta witao auna-una bautu naunu awong yaya nuna aung yaise buro yero nauwa, arata yaya nuna oko aung yao naunu nung yaya bainakama tapunasani nauna ara. Nung wau moni nuna apakana pugainu aung yena, arata yaya oko aung yao yena. Yaya bainakama kasa nasani nauna. ");
INSERT INTO zia_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Arare nung amimene Yesura bowi nigiro emo bauno dubu baina awiya gate-gate yero Yesura-una bautara kasa yero ");
INSERT INTO zia_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","nutope eyero kotungna, “Na taung wori nuna ding yero iwaing yarinena.” ");
INSERT INTO zia_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ayero kotungno kasa yero Yesura mo ding yenu yu nuna mena soyenu Yesu mene nung kora yenu yaya aung yena awiya gigina. ");
INSERT INTO zia_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ayero yenu Yesu mene kora yaora putoung auna yatu nung doro baungna awiya yetine yero giro emo bauno dubu baina auna towang atu mena kapetegairo eyero sena, “Awe mene taung wori nana ding yetiye?” ");
INSERT INTO zia_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ayero senu buro-mani nuna mene nung eno eyero sewa, “Emo bauno dubu baina mene ning misineya, arare ning nono yero ‘Awe na ding yetiye?’ asinesi?” ");
INSERT INTO zia_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ayero sewa arata Yesu mene, “Awe mene na ding yetiye?” asero gari sero diti-dati yena. ");
INSERT INTO zia_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Anenu bauno amimene tani Yesu mene nung eno yena awiya giro yangka sero awang nasani Yesura-una buro te nuna-una zuwero susuwa nuna keregairo sena ara. ");
INSERT INTO zia_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ayero yenu giro Yesu mene nung eno eyero sena, “Aya nana, ning inao nina-una iwaing yetesa. Arare ning yawa yawa nasani aune baung. Yaya nina oko kapete gariniya.” ");
INSERT INTO zia_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu mene ayero sinasani mitinu emo ena mene simai emora-una gare atu buro eyero sewa, “Mani baunodi nina magatiya. Ning nono yero buro baina Gipao Emo eno pugari sinesi?” ");
INSERT INTO zia_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ayero sewa, arata Yesu mene ge sinewa awiya nigari sero dawong oko yawao yero yere ibura simai emo eno eyero sena, “Kotung-katung oko yase. Tumo diyaore gege neu.” ");
INSERT INTO zia_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ayero sero awong apakana nung aune dema babao awang sero Petoro aune Yakobo meta nuna Yohane ami gege nung aune dema babaese sena. ");
INSERT INTO zia_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Awong baungno yere ibura simaira gare kasa yero Yesu mene emo bauno witao pasero zi sinasani mitiwa awiya gigina. Emo bauno zi sinasani zibe nasani mitiwa. ");
INSERT INTO zia_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ayero newa giro Yesu gare toiro awong eno eyero sena, “Niye noeno gurutu sero mitasani zi sinei? Mani awiya oko magayao. Nung auriti awiniya.” ");
INSERT INTO zia_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ayero senu awong nung pusugairo iwa. Arata nung awong awang senu garo doro bamuwa aune nung maina maung aire aune emo nung aune dema mitiwa awiya puro masi mani mitina auna toina. ");
INSERT INTO zia_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Toiro maina wawong iniro nung eno Yuda gera eyero sena, “Talita kumi.” Ge auna susuwa eyao era: “Zebi, ning iropasese sinena.” ");
INSERT INTO zia_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ayero senu mani awiya mena iropuro angyena. Dawang nuna 12. Ayenu emo bauno mene wawong di gauno yangka sewa. ");
INSERT INTO zia_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu mene awong susuwa awiya emo bauno ena eno sowi sero ge tauyao sena. Ayero sero awong nona minao mani eno pugaese sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu mene napo awiya doro napo nuna-una baungna. Buro-mani nuna mene nung aune dema bamuwa. ");
INSERT INTO zia_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Arare Sabat be kasa yenu giro nung yere ibu mokora toiro ge tugata nenu emo bauno witao mene ge nuna nigiro wawong di gauno eyero sewa, “Emo kotumao awiya natu tamiye? Kotumao tauyao nono yao mene nuna-una kasa yetiye? Nung nono yero tani emo bauno gitau oko gao awiya yero noiye? ");
INSERT INTO zia_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Emo ewiya nung kapenda. Nung Mariara mani arauwa. Nung Yakobo, Yosefe, Yuda, aune Simonna tato. Numono ai amono nuna name aune dema nowa.” Ayero sero awong Yesu eno kotumao meko puro dubo mou yewa. ");
INSERT INTO zia_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Arata Yesu mene awong eno eyero sena, “Porofete awong emo yazore. Arata napo nuka nunae-una, o dubu nuka nunae-una atu, o maung nuka nunae-una atu, awong emo yazo aung.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nung tani emo bauno mene gitau oko gao nauwa awiya nunae-una atu yao teng oko yena. Arata nung wawong nuna mene emo yayare dekaong-dekaong auna-una pugainu yaya nunae aung yena ara. ");
INSERT INTO zia_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","“Awong nono yero na tumo oko diyao yero nei?” ayero kotungno giro nung angyero napo mamanikakara baungno ge tugata yena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu mene buro-mani nuna 12 yau senu bumuwa iwae tunaora putoung awiya awong eno pugairo awong eto-eto baungno tere-taira yero buro yaese sero nung awong eno eyero sena, ");
INSERT INTO zia_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","“Nagibora nona zo oko pumae. Wo ma aung, zao aung, wau moni aung. Tung gege pungpu. ");
INSERT INTO zia_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Te soga wosogarineya, arata taung wori etobe oko wosogae. ");
INSERT INTO zia_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Niye esewa yero napo zora baungno garo dekaongka auna toiro mitasani buro baungno nete napo awiya duwari yero giro aune garo awiya dopu. ");
INSERT INTO zia_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Napo zo mene niye masi oko zuwao, o ge ninae oko nigao yaya giro napo awiya doro susuwa nunae gaese sero popo awetu nunae te yo ninae-una mitiya awiya dureregaipu wosae.” ");
INSERT INTO zia_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ayero senu giro buro-mani 12 amimene baungno emo bauno eno eyero sewa, “Niye dubo kapetegaipu.” ");
INSERT INTO zia_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ayero sero iwae witao tunero uweri emo bauno yayare witao auna-una yasagairo nauwa yaya nunae aung yero nauna arauwa. ");
INSERT INTO zia_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesura bowi baungno emo bauno apakana tawing sero sero auna teng yena. Ayero yenu emo tuwa zo yazo nuna Herode amimene Yesura bowi nigina. Emo ena mene Yesu eno eyero sinauwa, “Yohane ge ou zayero suwao emo nung amimene magayaora atu iropuna, arare nung tani putoungne yero noiya.” ");
INSERT INTO zia_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ena mene ayero sinauwa, arata ena mene eyero sinauwa, “Nung Eliya.” Ora ena mene eyero sinauwa, “Nung porofete zo. Porofete gitau nauwa ayao ine.” Ayero sinauwa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Arata Herode mene Yesura tani auna ge nigiro eyero sena, “Na ge sewang awong Yohanena dubo kapewa magayena, arata nung nupema iropuro niya.” ");
INSERT INTO zia_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herode mene ayero sena, noeno okowata, gitau nung gorobo emo senu baungno Yohane bunero puro pu bunao gare gaiwa. Herode mene tani awiya bauno Herodia eno yena, auna susuwa awiya eyao era: Herode mene meta nuna Filipra bauno puro atina ara. Bauno auna yazo nuna Herodia. ");
INSERT INTO zia_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ayero yenu giro Yohane mene Herode eno eyero sena, “Ning meta nina-una bauno sorero puro aune dema nosa, awiya teng oko niya. Sao tauyao ge gazao mitiya.” ");
INSERT INTO zia_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yohane mene ayero senu giro bauno Herodia mene dung yero Herode nung Yohane daise sinauna. ");
INSERT INTO zia_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Arata Herode mene tani awiya oko yao yena. Noeno okowata, nung Yohane awang yero nauna. Yohane nung emo pewayao, nung emo pasena aung, awiya giro awang yero sorero nauna ara. Yohane nung ge sinaunu Herode mene nigiro kotung-katung yero nauna, arata nung Yohanena ge nigari aratapunauna arauwa. ");
INSERT INTO zia_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Arata Herodia mene Yohane dao magayaora be awiya tauna. Herode mene ai nung puna auna be awiya kasa yenu giro nung emo babuze nuna aune gorobo emora gitau yao ena aune Galilaya tawingna emo babuze ena awong aeno ana-bonene yena. ");
INSERT INTO zia_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Be aune Herodia mene Yohane dao magayaora nagibo tauna. Awiya eyao era: Mani baunodi nuna mene Herodera ibu auna toiro na bainakama wuinu Herode ta esewa nung aune dema mitiwa amimene giro yawa yawa yewa. Ayero yewa giro Herode mene mani daungse aeno eyero sena, “Ning nona zota zo nomaze ara taungno sasa giro pugarinena. ");
INSERT INTO zia_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Na Tuwa Bayaura benaungna sana tauyae. Ning nona no eno saisi — nona maingkokata nona bainakama — awiya saineba na ning eno pugarinena. Tawing nana agewa eno sarinesa, awiya pugarinena.” ");
INSERT INTO zia_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ayero senu nung doro baungno ai nuna eno eyero sena, “Na no pugaise sarineni?” Ayero senu ai nuna mene eyero sena, “Yohane ge ou zayero suwao emo auna gitau ning eno pugaise sarinesa.” ");
INSERT INTO zia_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ayero senu nung mena sungno Herodera-una baungno eyero sena, “Yemeneka keune ning Yohane ge ou zayero suwao emo auna gitau taora pugairo pugasa pumane.” ");
INSERT INTO zia_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ayero senu Herode mene kotunu teng oko yenu dubo nuna mou yena. Arata nung Tuwa Bayaura ditira atu ge senu tau yena, nupema emo dema mitiwa amimene ge nuna gaya wosao yao eno, ");
INSERT INTO zia_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","nung gorobo emo zo mene Yohanena gitau kapero puro baise senu baungno bunao gare atu dubo nuna kapero ");
INSERT INTO zia_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","gitau taora pugairo puro baungno mani baunodi aeno pugainu puro ai nuna eno pugaina ara. ");
INSERT INTO zia_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ayero yewa Yohanena buro-mani mene tani auna bowi nigiro giro baungno taung nuna puro baungno biritira atu mutewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Emo Yesu mene iyengtina amimene Yesura-una atu augairo ge tugata nasani buro yewa awiya apakana nung eno sewa ara. ");
INSERT INTO zia_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Anasani mitiwa emo bauno witao mene Yesura-una buro baungno anasani newa Yesu aune buro-mani nuna aune nona minaora be aung yena. Ayero yenu giro Yesu mene buro-mani nuna eno eyero sena, “Bungpu. Name nata baungno soma emo bauno aungna atu oreganene.” ");
INSERT INTO zia_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ayero sero awong wangna witiro soma emo bauno aung auna babari bautunewa ");
INSERT INTO zia_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","emo bauno witao napo sero sero auna mene awong bautunewa giro nai bage-bage gege gitau mena baungno kasa yero mitiwa ara. ");
INSERT INTO zia_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mitiwa Yesu wang doro witi ika yero emo dubu bainakama awiya giro awong eno yo auna. Noeno okowata, awong pu mamani mene ai kau nasani nowa ayao ine. Ayao giro yo auno nung awong eno ge tugata-magata nenu ");
INSERT INTO zia_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ture itinenu giro buro-mani mene nuna-una nugu buro nung eno eyero sewa, “Soma ewiya soma meko. Nona minao aung. Ture itiniya, ");
INSERT INTO zia_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","arare ning emo bauno duwasa baungno nona minao nunae pumari napo nugu-nagu miteya auna babae.” ");
INSERT INTO zia_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ayero sewa nung eyero sena, “Ninae nona minao pugaipu minae.” Ayero senu awong nung eno eyero sewa, “Nae baungno ame igiyao 200 kina mene zuma gaero awong eno puganane minaese sinesa?” ");
INSERT INTO zia_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ayero sewa nung awong eno eyero sena, “Ame igiyao niye nazigo i? Baungpu gae.” Ayero senu awong baungno giro nupema buro eyero sewa, “Ame wawong zore wo etobere gege miteya.” ");
INSERT INTO zia_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ayero sewa nung emo bauno eno eyero sena, “Niye dubu sero dopero kanasi nezayao owiya naero adungpu.” ");
INSERT INTO zia_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ayero senu awong dubu sero adumuwa — dubu ena emo bauno 100, dubu ena emo bauno 50, ayero yero adumuwa ara. ");
INSERT INTO zia_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ayero yewa aune Yesu mene ame wawong zore wo etobe awiya puro ditiye uritira gairo Tuwa Bayau eno dange sero ame awiya eegairo buro-mani eno pugaina ara. Awiya buro-mani mene emo bauno eno pugaese sero ayero yena ara. Nung wo etobe puro zozoro gairo bono yenu emo bauno apakana amimene pumuwa. ");
INSERT INTO zia_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Awong apakana miniwa teng yena ara. ");
INSERT INTO zia_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Teng yenu awong ame itoto wo itoto awiya yangtagairo puro saka 12 auna gaiwa teng yena. ");
INSERT INTO zia_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Emo nona miniwa auna zare nunae awiya 5,000. ");
INSERT INTO zia_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yesu mene buro-mani nuna eno eyero sena, “Niye wangna witiro musugairo enaba Besaida nape gitau babarineya. Na emo bauno zanaese sero aune awong duwarinena.” ");
INSERT INTO zia_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ayero sero nung awong gitau iyengtinu bamuwa nung isa sari sero diri witina ara. ");
INSERT INTO zia_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Atu isa sinasani mitinu ture itinenu mani awiso wangna bautunete ou nazi towang daung yewa ara. ");
INSERT INTO zia_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Atu bisi mene awong dero ibena abena nenu awong wang dawaora yaya tapunewa awiya gigina. Ayero giro iya gari nenu aune nung ou nazi tame angyero nunae-una nugu kasa yena. Nung awong daigari sero nenu ");
INSERT INTO zia_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","awong nung ou tame angnena awiya giro nung ititi zota asero aiyamama sewa. ");
INSERT INTO zia_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Awiya noeno okowata, awong nung giro awang yero te wawong ipena. Ayero yewa giro nung awong eno mena eyero sena, “Niye tau yepu. Na ara. Awang oko yae.” ");
INSERT INTO zia_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ayero sero nung wangna witinu soma bisi sena. Ayero yenu awong yangka sewa ara. ");
INSERT INTO zia_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Awiya noeno okowata, awong tani Yesu mene ame emo bauno eno pugaina auna susuwa oko gao. Diti dubore nunae oko zawagao. ");
INSERT INTO zia_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Awong ou nazi buwagairo baung tawing yazo Genesaret auna yero wang isewa witina ara. ");
INSERT INTO zia_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ayero yero wang doro witiwa emo bauno Yesu gao amimene nung giro ");
INSERT INTO zia_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","napo nugu-nagu mitiwa auna sungno baungno emo bauno kezeya yetugao goga gaero zuwagairo puro buro Yesu atu mitiya asero atu pugaiwa ara. ");
INSERT INTO zia_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Soma apakana Yesu mene baungna — napo mamanikaka, o napo babuze, o soma napo aung — soma auna emo bauno mene emo bauno kezeya yetugao puro nagibe pugaiwa emo bauno yayare mene Yesu yausero mo be nuna gege ding yari sewa. Emo bauno ding yewa auna yaya aung yena. ");
INSERT INTO zia_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisayo ena aune sao tauyao ge gipao emo ena Yerusalem atu bumuwa amimene Yesura-una augaiwa. ");
INSERT INTO zia_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Augairo buro-mani nuna mene wawong oko sayao nona mininewa awiya gigiwa. ");
INSERT INTO zia_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Wawong sayaora tani auna susuwa eyao era: Farisayo emo gege okowata, Yuda emo apakana dema, awong nona teba oko mininowa. Awong ewowo nunae-una sao tauyao ge awiya ago yero wawong saero aune nona mininowa ara. ");
INSERT INTO zia_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Awong maketra atu nema kapetegairo gare buro gitau ou suwero aune ago nona mininowa. Awong ewowora sao tauyao ge ewe-pape ago nasani awangne taore aure sainowa. ");
INSERT INTO zia_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Arare Farisayo aune sao tauyao ge gipao emo amimene Yesu eyero atata yero sewa, “Buro-mani nina mene nono yero ewowora sao tauyao ge awiya doro wawong oko sayao nona tebeba mininei?” ");
INSERT INTO zia_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ayero sewa nung awong eno eyero sena, “Niye ge iwao emo me sao yero nowa. Ge porofete Yesaya mene gaena amimene niye gapuniya. Ge gaena awiya eyero mitiya era: Tuwa mene eyero siniya, Emo bauno emimene na begiti mene bowi yero nowa, arata moko nunae nana-una oko mitiya. ");
INSERT INTO zia_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Awong emora ge awiya Tuwa Bayaura sao tauyao ge ine ayero sero gipero ayero nowa. Arare awong na bowi yari yero tetere yero nowa. Yesaya mene ayero gaena ara.” ");
INSERT INTO zia_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesu mene ayero sero aune ge susuuno eyero sena, “Niye Tuwa Bayaura sao tauyao ge doro emora wini ge puro iniro baingtitinowa.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu mene ge zo nupema awong eno eyero sena, “Niye Tuwa Bayaura sao tauyao ge doro ewowora tani ago yero nowa, awiya kotupunowa iwaing noi? ");
INSERT INTO zia_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Na ayero sinena, noeno okowata, Mose mene eyero sena, Ning tani iwaing ai maung nina eno nasani neu. Nupema, Zo nung ai maung nuna eno ge meko sariniya, nung awiya depu magayae. ");
INSERT INTO zia_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mose mene ayero sena, arata niye eyero sinowa: Zo nung ai maung nuna eno eyero sai teng yariniya, ‘Na nona nito eno pugatena, arata na nona awiya mena Koban eno sewang.’ (Koban auna susuwa eyao era: “Na nona ewiya Tuwa Bayau eno pugari sewang tauyena.”) ");
INSERT INTO zia_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mani zo ayero sariniya, awiya niye nung ai maung soremoiye sero awang sinowa. ");
INSERT INTO zia_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ayero yero niye Tuwa Bayaura sao tauyao ge pu ago gairo ewowora tani pu gitau gairo mani eno gipinowa. Tani ayao awiya daigairo yero nowa.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu mene ayero sero emo bauno nupema yausenu bumuwa eyero sena, “Ge sana nigipu. Niye apakana nigiro baingtipu. ");
INSERT INTO zia_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nona be ninae-una toitinoiya amimene oko niye noi beingtire yero nowa. Ge be ninae-una atu kasa noiya amimene niye noi beingtire yero nowa ara. ");
INSERT INTO zia_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Zo nung dawongne mene ge ewiya nigaise.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ayero sero emo bauno doro buro-maine dema gare toiro buro-mani mene ge sena auna susuwa nigari sero nung atata yewa ara. ");
INSERT INTO zia_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Atata yewa giro nung awong eno eyero sena, “Ayero niye dema oko gao yero neita? Niye susuwa ewiya gosineita? Nona minao mene bera toiro niye oko noi beingtire yero nowa. ");
INSERT INTO zia_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Noeno okowata, nona minao amimene dubo ninae-una oko toitinoiya. Nona awiya tini ninae-una baungno nagibo nuna-una wowosinoiya.” Yesu mene ge awiya sinasani nona minao apakana amimene dubora beingti oko tapunoiya. Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ayero sero aune eyero sena, “Tani emora-una dubora atu kasa yero noiya amimene emo awiya noi beingtire yero noiya. ");
INSERT INTO zia_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Noeno okowata, emora-una mokora atu, o emora-una dubora atu kotumao meko mene kasa yero nowa — kuma yao, ugaing yao, mani dao magayao, atao gerayao, ");
INSERT INTO zia_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","dubo-dubo yao, tani meko yao, ge iwao ge sao, gao meko yao, isi patao ge sao, taung puro witao, wini ge dero nao — ");
INSERT INTO zia_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","tani awiya apakana emora-una mokora atu kasa yero emo awiya yero noi beingtire yero noiya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu mene atu iropuro baung tawing zora atu napo zo yazo nuna Taya mitauna auna yero garo zora toiro mitasani emo bauno mene nung atu mitina awiya gowi sero awang sena, arata nung nutope pungyaine yao teng oko. ");
INSERT INTO zia_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ayero nenu bauno zo mene Yesura bowi nigina. Bauno auna mani bauno di zo maingkoka amimene iwae nuna-una mokora mitauna ara. Bauno amimene kasa ye Yesura-una gairo koing gaina. ");
INSERT INTO zia_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Arata bauno awiya nung Yuda oko. Tawing nuna yazo Sirofonisia. Arare nung Yesu eno isa sero nung mani nuna-una iwae tunaise senu ");
INSERT INTO zia_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu mene nung eno ge eniya zo eyero sena, “Na nona mani mamani eno gitau pugana minaya teng yae. Noeno okowata, mani mamanina nona minao sorero sino unao ine awiya teng oko yariniya.” ");
INSERT INTO zia_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ayero senu giro bauno mene ge eniya auna abena eyero sena, “Tuwa, awiya meba sinesa. Arata sino opesa wese atu mitasani susuna mani mene nowa wowosinoiya awiya mininowa.” ");
INSERT INTO zia_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ayero senu giro Yesu mene nung eno eyero sena, “Ge iwaing sesesa, arare gare baung. Iwae mene mani nina mena doro babiya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ayero senu bauno mene nupema tera kapete nuna-una gare gairo baungno iwae mena baungnu mani nuna teba apegairo mitina awiya gigina. ");
INSERT INTO zia_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu mene atu iropuro tawing napo Taya mitina awiya doro napo Saidon buwagairo tawing yazo Dekapolis awiya buwagairo kasa ye ou nazi zo yazo Galilaya auna gaina. ");
INSERT INTO zia_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ayero mitinu emo ena mene emo zo puro buro Yesura-una yewa ara. Emo awiya dawong itigao, ge aung. Emo mene emo awiya puro Yesu mene nung ding yero kora yaise sero isa sewa. ");
INSERT INTO zia_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ayero yewa giro Yesu mene emo awiya puro emo bauno doro baungno dopero wawong soro emo auna-una daweng pugairo begura pisero wawong mene emo auna ewawa dingyero ");
INSERT INTO zia_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","diti ika uritira yero oweno tauyao pisero emo aeno eyero sena, “Epata.” (Ge naname-una, “Dawong iwaise.”) ");
INSERT INTO zia_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ayero senu dawong tangsenu be eo yenu ge iwaing sena ara. ");
INSERT INTO zia_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ayero yenu giro Yesu mene awong eno eyero sena, “Niye tani euna bowi sowi sero awang sinena.” Ayero sinaunata emo bauno mene gewera yero keregairo nauwa. ");
INSERT INTO zia_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Anauwa emo bauno ena mene nigiro wawong di gauno yangka sero eyero sinauwa, “Nung tani apakana iwaing yero noiya. Nung noi emo dawong itigao mene ge nupema nigitinowa, nupema emo ge aung amimene ge nupema sinowa.” Ayero sinauwa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Iya zore emo bauno daigairo mene Yesu aune augairo mitete nona minao aung yenu mitiwa giro nung buro-mani nuna yau senu bumuwa eyero sena, ");
INSERT INTO zia_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Na emo bauno yo niya. Noeno okowata, awong iya etama na aune dema nete doteya nona minao awena aung yetiya. ");
INSERT INTO zia_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Arare na nona awong eno oko pugao tebeba iyengtarinena, awiya awong bautunete nagibe atu meri magayero zuwarineya. Awong ena soma nugu daung okora atu bumeya.” ");
INSERT INTO zia_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ayero senu buro-mani mene nung eno eyero sewa, “Name towangna etu nono yero emo baunona nona minao taungno pugarinenine?” ");
INSERT INTO zia_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ayero sewa giro eyero sena, “Niye ame igiyao nazigo i?” Ayero senu giro awong sewa, “Nae ame igiyao 7.” Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Arare Yesu mene emo bauno tawingna adumaese senu adumuwa nung ame igiyao 7 awiya puro Tuwa Bayau eno dange sero ame awiya eegairo buro-mani eno pugaina. Buro-mani mene emo bauno eno bono yaya minaese sero pugainu puro emo bauno eno bono yewa. ");
INSERT INTO zia_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nupema wo mamanikaka nunae ena mitiwa awiya puro Tuwa Bayau eno dange sero buro-mani eno eyero sena, “Wo dema emo bauno eno bono yepu.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ayero senu puro bono yewa miniwa teng yena. Teng yenu giro itoto pu dekaongna gaiwa saka 7 teng yena ara. ");
INSERT INTO zia_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nona miniwa awong auna zare nunae awiya 4,000. ");
INSERT INTO zia_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Miniwa aune Yesu mene awong senu bamuwa. Bamuwa nung buro-mani nuna aune wangna witiro tawing yazo Dalimanuta auna bamuwa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisayo ena mene Yesura-una buro nung aune dema ge wina-se yewa ara. Awong Yesu gaero gari sero nung tani diti seka zo yai uritira putoung kasa daung yai gari sewa ara. ");
INSERT INTO zia_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sewa Yesu mene ge nunae giginu bereya yenu giro eyero sena, “Emo yeme neya emimene noeno tani diti seka zo gari sinei? Na ge meba nibamu sinena era. Emo yeme neya emimene tani diti sekawa zo oko garineya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ayero sero nung awong doro wangna nupema witiro ou nazi enabara baungna arauwa. ");
INSERT INTO zia_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Buro-mani nuna mene ame oko pumao nuwegaiwa. Ame dekaongka gege awong aune dema wangna mitina. ");
INSERT INTO zia_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Arare Yesu mene dawong gayao ge zo awong eno sinasani eyero sena, “Niye umo yepu. Farisayora yis ta Herodera yis amimene seung ninae-una goiye sero niye umo yero baingtiti nasani neupu.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ayero senu awong ge nuna awiya nigiro wina-se yewa, “Name ame nuwegenane aeno ge ewiya sinita nowa?” ");
INSERT INTO zia_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ayero sewa awong Farisayora gipao ge okowata, ame minao maze kotupunewa giro Yesu mene awong eno eyero sena, “Name ame dotenane aeno siniya awiya noeno sinei? Niye yeme susuwa nana oko gosineita nowa? Diti dubore ninae daba ine i? ");
INSERT INTO zia_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Niye diti mokore, arata niye oko gao i? Niye dawongne, arata niye oko nigao i? Niye susuwa ewiya nuwegeita nowa? ");
INSERT INTO zia_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Na emo 5,000 eno ame wawong zo eegaiwang be aune niye itoto saka nazigo diwi?” Ayero senu awong sewa, “Saka 12 diwangne.” ");
INSERT INTO zia_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ayero sewa giro nung eyero sena, “Na emo 4,000 eno ame 7 eegena niye itotora saka nazigo diyei?” Ayero senu sewa, “Saka 7 diyenane.” ");
INSERT INTO zia_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ayero sewa giro nung eyero sena, “Niye tani awiya oko gao i?” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu buro-mani nuna aune dema kasa ye napo Besaida auna yewa emo ena mene emo diti guma yao zo puro Yesura-una buro Yesu mene nung ding yaise sewa ara. ");
INSERT INTO zia_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ayero sewa giro Yesu mene emo diti guma yao awiya wawong gaero puro napo doro baungno begura ye diti mokora gairo wawong diti mokora pugairo atata yero sena, “Nona zo gosinesita?” ");
INSERT INTO zia_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ayero senu nung diti kanero abena eyero sena, “Na emo bauno gosinena. Na awong gosinena i ipu ine neya, arata awong ang neya.” ");
INSERT INTO zia_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ayero senu giro Yesu mene wawong nuna diti mokora nupema pugainu emo awiya anuwing nenu diti nuna iwaing yenu nung nona apakana giro baingtina ara. ");
INSERT INTO zia_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ayero yenu giro Yesu mene nung iyengtari sero eyero sena, “Ning nupema napo euna oko babase. Ning garo nina-una baung.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu buro-mani nuna aune dema napo ena tawing yazo Sisaria-Filipai auna mitiwa auna bamuwa. Bautunete Yesu mene buro-mani atata yero sena, “Emo bauno mene na awe sero nei?” ");
INSERT INTO zia_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ayero senu abena sewa, “Ena mene eyero sineya: Ning Yohane ge ou zayero suwao emo. Arata ena mene eyero sineya: Ning Eliya. Arata ena mene eyero sineya: Ning porofete gitau nawe magayewa auna zo.” ");
INSERT INTO zia_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ayero sewa giro nung awong atata yero sena, “Ora niye nika niyetope na awe sero nei?” Ayero senu Petoro mene eyero sena, “Ning Kristo, Sorao Emo nanae.” ");
INSERT INTO zia_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ayero senu Yesu awong eno ge tauyao eyero sena, “Ge nana awiya emo zo eno oko sae.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu mene awong ge tugata yari sero eyero sena, “Na Emora Mani mene yaya-biyaya tamarinena. Yuda emora simaita pirisa babuzeta sao tauyao ge gipao emo amimene na awang sero na daya magayarinena. Magayana be etama aung yai aune na nupema seka yero iroparinena.” ");
INSERT INTO zia_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ge awiya senu kasa yenu gigiwa. Asenu Petoro mene nung yuno baungno awang sero eyero sena, “Ayero oko sase.” ");
INSERT INTO zia_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ayero senu Yesu mene kapetegairo buro-mani nuna ena giro abena Petoro gona yero eyero sena, “Sanda, ning na doro daigai. Ning ge sinesa awiya Tuwa Bayaura ge okowata, emora ge niya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesu mene buro-mani nuna aune emo bauno dubu baina aune awiya yau senu bumuwa eyero sena, “Zo nung na ago yari yero giro aratamao nuna apakana doro dubo minaore yaya tamaore auna i pasao nuna diungno na ago yaise. ");
INSERT INTO zia_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Noeno okowata, zo nung tawingna nao nuna sorero puro nari kotumariniya auna nao nuna aung yariniya. Arata zo nung na eno yero o Bowi Iwaing nana eno yero tawingna nao nuna duwariniya amimene nao iwaing tamariniya. ");
INSERT INTO zia_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Zo nung tawingna nona iwaing apakana awiya pupunariniya, arata nao nuna aung yariniya, awiya nona nomi nuna-una mitariniye? ");
INSERT INTO zia_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nupema nao nuna kapetegaise kotungno zuma noma pugai aune nao nuna awiya abena kapete nuna-una gariniye? Aung arauwa. ");
INSERT INTO zia_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Emo pasena nasani Tuwa Bayau daigati nasani nowa be aune emo zo mene na ta ge nana awiya awang sariniya, awiya na Emora Mani mene Mama nana-una waegaore angelo pewa yetugaore bumarinena be aune na abena emo awiya awang sarinena.” Yesu mene ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu mene awong eno eyero sena, “Na ge me niye eno sinena era. Emo ena etu dopero miteya amimene oko magayao naya Tuwa Bayau nata tuwa yero nariniya auna putoung kasa daung yai garineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wari be 6 aung yenu aune Yesu mene Petoro Yakobo aune Yohane awong awiya gege puro diri bainana witiwa Yesura taung mene diti moko nunae-una atu darawa yero benaung zo ewe yena ara. ");
INSERT INTO zia_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Mo nuna mene waegairo neyang yena. Mo nuna awiya neyang kaing-kaing yao. Emo zo mene mo sayai ayao ine yao teng oko. ");
INSERT INTO zia_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Buro-mani nuna mene Eliyato Mose awongto Yesu aune dema ge sinasani mitiwato awiya gigiwa. ");
INSERT INTO zia_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Giro Petoro mene Yesu eno eyero sena, “Gipao emo, name etu mitenane awiya iwaing. Arare ning nigasa nae kouboga etama sinarinenane — zo nina, zo Mosera, zo Eliyara.” ");
INSERT INTO zia_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petoro mene no saine nete giro ge awiya sena. Noeno okowata, awong buro-mani mene awang bainakama yewa. ");
INSERT INTO zia_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ayero newa bereze zo mene buro awong worena. Ayero yenu ge zo bereze auna mokora atu eyero kasa yenu nigiwa, “Awiya mani nana. Nung yo diyang nana. Ge nuna nigipu.” ");
INSERT INTO zia_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Buro-mani mene ge awiya nigiro gari-gari yero emo zo oko gigiwa, arata Yesu gege mene awong aune dema mitina awiya gigiwa. ");
INSERT INTO zia_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Yesu buro-mani nuna aune dema diri atu wosiro bautunasani nung awong eno ge tauyao sinasani eyero sena, “Niye tani gigeya auna ge oko sae. Na Emora Mani mene magayero iropana aune niye ge awiya saya teng yariniya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Arare awong Yesura ge tauyao sena awiya dimuwa. Arata awong Yesu magayero iropariniya auna gera susuwa gari sero kotung-katung yewa. ");
INSERT INTO zia_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ayero nasani nung atata yero sewa, “Sao tauyao ge gipao emo mene eyero sinowa, ‘Eliya gitau bai aune Kristo bariniya.’ Nono yero ayero sinowi?” ");
INSERT INTO zia_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ayero sewa giro Yesu mene awong eno eyero sena, “Eliya nung gitau buro tawingna nao meko awiya apakana korayai aune Kristo bariniya. Na Emora Mani eno ge eyero gaewa mitoiya, Nung yaya-biyaya tamariniya. Awong nung pusugairo gero iyarineya. Ge ayero gaewa mitoiya. Arata Eliya mene buro tawingna nao meko apakana kora yati siya, awiya tani nana-una atu kasa yariniya auna ge oko gayateya. ");
INSERT INTO zia_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Aeno na niye eno sinena era. Eliya buna. Bunu giro emo ena mene nung eno tani tebe-tabe yewa. Ge nung eno gaewa ayao ine teng yewa.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Awong wosiro buro kasa ye buro-mani enana-una yero emo bauno dubu baina mene buro-mani nuna ena aune dema mitiwa gigiwa. Sao tauyao ge gipao emo ena mene buro-mani aune ge betinasani mitiwa. ");
INSERT INTO zia_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ayero newa emo bauno mene Yesu butunenu giro yangka sero sungno baungno arugaiwa ara. ");
INSERT INTO zia_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ayero yewa Yesu mene awong atata yero sena, “Niye ge nomaze awong aune dema sinei?” ");
INSERT INTO zia_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ayero senu emo bauno dubu baina mitiwa auna emo zo mene nung eno eyero sena, “Gipao emo, na mani emodi nana puro nina-una bumena. Noeno okowata, iwae nuna-una toiro mitoi nung ge aung mitoiya. ");
INSERT INTO zia_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mani nana be ena iwae mene nung darapunoi zuwero begura suwero di yetinoi taung aingso nuna tau-tataware noiya. Arare na buro-mani nina mene iwae tunaese sesena, arata awong tunao ine teng oko yeteya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ayero senu Yesu mene awong eno eyero sena, “O niye emo bauno inao aung. Na be nazigo niye aune dema narineni? Na be nazigo buro ninae eno taung dedunasani nari neni? Mani puro nana-una bungpu.” ");
INSERT INTO zia_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ayero senu awong mani puro nuna-una bumuwa iwae mene Yesu giro mani daraunu zuwero begura gutinasani angzi apunenu ");
INSERT INTO zia_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu mene maina maung atata yero sena, “Dawang noune yaya ewiya tauni?” Ayero senu abena eyero sena, “Nung mani maingkore tauna. ");
INSERT INTO zia_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Arare iwae mene mani magayaise sero nung darapunoi oura ta iyaora zuwero noiya arauwa. Arata ning yaya kora yao ine teng yariniya, awiya ning nae eno yo auno nae soreung.” ");
INSERT INTO zia_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ayero senu giro Yesu mene bera puro eyero sena, “Na yaya awiya kora yao ine teng yarinita, asinesita? Emo zo nung tumo diyaore amimene tani apakana yai teng yariniya.” ");
INSERT INTO zia_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ayero senu maina maung mene mena eyero sena, “Na ning tumo didinona, arata ning na soremasa na ning tumo diro baingtane.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Arare Yesu mene emo bauno witao nuna-una suno butunewa giro nung iwae tunero eyero sena, “Ning iwae ge aung nao, o dawong itigao, na ning eno ge tauyao sinena era. Ning mani doro nuna-una nupema oko towase.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ayero senu iwae mene be kerero mani awiya tau-tataware yao denu angzi apunenu iwae nung dunu mani awiya magayaine yena. Ayero yenu emo bauno witao mene giro eyero sewa, “Mani magayetiya.” Ayero sewa, ");
INSERT INTO zia_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","arata Yesu mene maina wawong iniro ininu iropuna ara. ");
INSERT INTO zia_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu buro-maine dema gare toiro buro-mani mene emo baunona diti pungyero aune nung atata yero sewa, “Nae iwae awiya tunari yetenane nono yero teng oko yao yetiye?” ");
INSERT INTO zia_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ayero sewa Yesu mene awong eno eyero sena, “Name iwae ayao awiya tunari sero isa saora buro gege yero tuninonane. Iwae tunaora nagibo zo oko mitiya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Awong atu iropuro baungno tawing yazo Galilaya awiya buwagaiwa. Arata Yesu mene awong bautu newa awiya emo bauno mene gao awang sena. ");
INSERT INTO zia_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Noeno okowata, nung buro-mani nuna gipinasani eyero sena, “Awong na Emora Mani awiya puro emo enana-una waweng pugaya na daya magayarinena. Magayero wari be etama aung yai aune iroparinena.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Arata awong ge nuna-una susuwa oko gigiwa. Nupema awong nung atata yao awang yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Awong bautunete baung Kapaneam yero gare toiro mitiwa aune Yesu mene awong atata yero sena, “Niye nagibe atu ge nono sesei?” ");
INSERT INTO zia_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yesu mene ayero atata yena, arata awong ge abena oko sao yewa. Noeno okowata, awong nagibe atu eyero sewa, “Naname-una zo awe mene baina niye?” Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Arare Yesu mene adungno buro-mani nuna 12 yau senu bumuwa eyero sena, “Emo zo mene gitau yari sariniya, nung amimene ago yaise. Nung emo apakana auna sou yaise.” ");
INSERT INTO zia_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ayero sero aune nung mani maingkoka zo puro pu towang gairo mani saniro awong eno eyero sena, ");
INSERT INTO zia_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Emo zo mene mani zo eyao ine na eno kora yariniya, nung amimene na kora yetiya ayero yariniya. Emo zo na kora yariniya amimene na gege okowata, nung na iyengtinu wosiwang awiya dema kora yetiya ayero yariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohane mene nung eno eyero sena, “Gipao emo, nae emo zo nae aune dema oko nao amimene yazo nina yau sinasani iwae tuninenu gigiwangne. Arata nung nae oko ago yao noiya, arare duwaise sewangne.” ");
INSERT INTO zia_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ayero senu Yesu mene abena eyero sena, “Buro duwaise awiya oko sae. Noeno okowata, emo zo mene yazo nana yau sinasani tani putoungne zo yariniya amimene mena yazo nana puro wosari yai teng oko yariniya. ");
INSERT INTO zia_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Emo iwo name eno oko yariniya awiya otao naname arauwa. ");
INSERT INTO zia_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Na ge me niye eno sinena era. Emo zo mene niye Kristora mani yero nowa awiya giro ou minao niye eno pugariniya amimene abena zuma nuna iwaing pumariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yesu mene eyero sena, “Zo nung mani mamanikaka na tumo didinowa auna zo yumai pasena tamoiye sero, niye bere-bere daba bainakama zo emo auna dube kimegairo wito kurura musugaya gutai teng yariniya. Noeno okowata, emo amimene pasena oko yaore oura gutero magayariniya, awiya nona eo yao gege. Arata nung pasena yai aune Tuwa Bayau mene abena pugariniya, awiya nona mou-mesa yao. ");
INSERT INTO zia_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ning wawong zo mene pasena yasese yai giro wawong awiya kapase. Ning wawong dekaongkare gege nete ago uritira baungno nasa iwaing yariniya ara. Arata ning wawong etore nete ago soma iyao awao gege awinoiya auna babasa meko yariniya. ");
INSERT INTO zia_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Soma meko auna ipa mene oko maganowa. Soma auna iyao oko wowosinoiya. ");
INSERT INTO zia_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ning te zo mene pasena yasese yai giro te awiya kapase. Ning te dekaongkare gege nete ago uritira baungno nasa iwaing yariniya ara. Arata ning te etore nete ago soma iyao awao gege awinoiya auna babasa meko yariniya arauwa. ");
INSERT INTO zia_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Soma meko auna ipa mene oko maganowa. Soma auna iyao oko wowosinoiya. ");
INSERT INTO zia_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ning diti moko zo mene pasena yasese yai giro diti moko awiya zokase. Ning diti moko dekaongkare gege nete ago Tuwa Bayau nata tuwa yero nariniya auna nape babasa iwaing yariniya ara. Arata ning diti moko etore nete ago soma iyao awao gege awinoiya auna babasa meko yariniya arauwa. ");
INSERT INTO zia_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Soma meko auna ipa mene oko maganowa. Soma auna iyao oko wowosinoiya. ");
INSERT INTO zia_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Name biyoung puro nona minaora sesinonane iwaing noiya ara. Deka ayero yaya zo iyao ine amimene emo bauno apakana iwaing yaese sesariniya. ");
INSERT INTO zia_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Biyoung awiya nona iwaing. Arata biyoung perusa yariniya, awiya name nono yanane mapu nuna iwaing nupema kasa yariniye? Name biyoung puro nona tame sesinonane iwaing noiya, deka ayero niye dubo-monone naya iwaing yariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu buro-mani nuna aune dema atu iropuro baung tawing yazo nuna Yudaya auna yero nupema doro baung tawing zo ou Yodan enabara mitina auna yewa emo bauno dubu baina mene nuna-una nupema kasa yewa nung awong eno uritira ge tugata yero gipero nasani nauna ara. ");
INSERT INTO zia_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Anenu Farisayo ena mene nuna-una kasa yero nung gaero gari sero atata yero sewa, “Emo mene bauno nuna duwao awiya teng nita?” ");
INSERT INTO zia_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ayero sewa nung abena eyero sena, “Mose mene sao tauyao ge niye eno pugairo nono seni?” ");
INSERT INTO zia_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ayero senu awong sewa, “Mose mene eyero sena: Emo zo bauno nuna duwari sero yero giro bauno duwaora igi zo gaero aune bauno duwaise. Mose mene ayero sena arauwa.” Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Asewa Yesu mene awong eno eyero sena, “Ziyo tauyao ninae eno Mose mene ge awiya niye eno gaena. ");
INSERT INTO zia_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Arata Tuwa Bayau mene nona apakana tapunasani emore baunone tauna. ");
INSERT INTO zia_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Arare emo mene ai maungne nuna doro bauno nuna aune dema gauno baingtiro ");
INSERT INTO zia_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","awongto dubore taungne dekaongka yero narineyato. Arare awongto etobe okowata, dekaongka yero narineyato. ");
INSERT INTO zia_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tuwa Bayau mene awongto tairo pugainu atiwato, arare emo mene oko kapaese.” Yesu mene ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Awong gare toiro mitiwa aune buro-mani nuna mene gera susuwa gari sero nung atata yewa. ");
INSERT INTO zia_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Atata yewa giro nung awong eno eyero sena, “Emo zo mene aro nuna doro bauno seka atariniya, awiya nung kuma yariniya. ");
INSERT INTO zia_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ora bauno zo mene yu nuna doro emo zo atariniya, awiya nung kuma yariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Emo bauno ena mene mani mamanikaka Yesu mene iniro gao yaise sero nuna-una puro butunewa buro-mani nuna mene emo bauno awang sewa. ");
INSERT INTO zia_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ayero sewa Yesu mene giginu meko yenu giro buro-mani nuna eno eyero sena, “Niye mani mamanikaka dopu nana-una bae. Nagibo nunae oko gazae. Awong ayao amimene Tuwa Bayaura napo auna gerao. ");
INSERT INTO zia_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Na ge me niye eno sinena era. Zo nung tumo diyao nuna mani mamanikakara ine oko amimene Tuwa Bayaura-una nape babao ine teng oko.” ");
INSERT INTO zia_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yesu mene ge ayero sero mani mamanikaka puro saniro wawong nunae-una ziye pugairo gao yena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu mene babari sero nenu emo zo sungno buro kasa ye nuna-una gairo koing gairo eyero sena, “O gipao emo iwaing, na nono yero nao me iwaing tamarineni?” ");
INSERT INTO zia_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ayero senu Yesu mene nung eno eyero sena, “Ning na iwaing asinasani iwaingna susuwa gosinesita? Tuwa Bayau nung nata iwaing. ");
INSERT INTO zia_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ning Tuwa Bayaura sao tauyao ge gosinosa erauwa: ‘Emo oko dasa magayae; kuma oko yase; ning ugaing oko yase; ning emo zo gera pugari ge iwao ge oko sase; emo zora nona ge iwero sero oko pumase; ai maung nina-una ge dimase.’ Sao tauyao ge ayao mitiya.” ");
INSERT INTO zia_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ayero senu nung eno eyero sena, “Gipao emo, na sema nana naungwa be aune ge awiya apakana diungno butunawe emo yetena.” ");
INSERT INTO zia_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ayero senu Yesu diti yero nung gosinasani yo auno giro nung eno eyero sena, “Ning buro zo duwasa mitoiya awiya ye. Ning buro ewiya yero aune nao me iwaing tamarinesa. Ning baungno nona nina apakana pugasa emo ena mene zuma gaero pumaya aune wau moni nina awiya emo bauno bogamasa eno bono yasa pumae. Ayero yasa wau nina uritira atu mitariniya ara. Ayero yero aune buro na ago yase.” ");
INSERT INTO zia_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yesu mene ayero senu nung tumo koina-kaina yero kotung-katung nasani doro baungna. Awiya noeno okowata, wau moni nuna witao. ");
INSERT INTO zia_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Arare Yesu mene diti-dati yero buro-mani nuna eno eyero sena, “Emo wau moni witaore amimene Tuwa Bayaura napo auna babaora buro bainakama yarineya.” ");
INSERT INTO zia_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ayero senu buro-mani ge awiya nigiro wawong di gamuwa. Arata Yesu awong eno eyero nupema sena, “O buro-mani nana, Tuwa Bayaura nape babao awiya buro bainakama. ");
INSERT INTO zia_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Wo kamel mene zai totora towao awiya teng oko. Deka ayero emo wau moni witaore mene Tuwa Bayaura napo auna babao awiya deka teng oko.” ");
INSERT INTO zia_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ayero senu awong wawong di gauno wina-se yewa, “Arare awe mene uritira baungno nao me iwaing tamao teng niye?” ");
INSERT INTO zia_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ayero sewa giro Yesu mene diti nunae-una yero eyero sena, “Emo mene ayero yao ine teng oko, arata Tuwa Bayau mene ayero yao awiya teng niya. Noeno okowata, Tuwa Bayau mene tani apakana yao teng niya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ayero senu giro Petoro mene nung eno eyero sena, “Sana nigi. Nae nona nanae apakana doro nina ame nasani nonane.” ");
INSERT INTO zia_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ayero senu Yesu mene eyero sena, “Na ge me niye eno sinena era. Emo zo mene napo nuna ta metamani nuna ta numono mani nuna ta ai nuna ta maung nuna ta mani awiso nuna ta tawing nuna awiya na enota Bowi Iwaing eno duwariniya, awiya ");
INSERT INTO zia_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nung amimene napore metamaine numono mani ai amono mani awisore tawingne awiya 100 be yeme eune tamariniya. Ayero nai emo bauno ena mene nung mani nana asero nung gera gaira yero narineya. Ago nung nao me iwaing awiya pumariniya. ");
INSERT INTO zia_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ora emo gitau neya auna daigairo mene ago yarineya. Emo ago neya amimene gitau yarineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu emo enane Yerusalem babari sero nagibe atu bautunewa Yesu nung gitau nenu buro-mani nuna mene ago atu kotung-katung nasani bautunewa emo bauno ena awong ago newa adeka dema awang nasani aune bamuwa ara. Ayero bautunewa Yesu mene buro-mani nuna 12 puro tani emo mene ago nung eno yarineya auna ge awong eno keregati nasani eyero sena, ");
INSERT INTO zia_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Sana nigipu. Name Yerusalem nape babari sero wiwitinenane. Witiro atu kasa yero nanane aune emo zo mene na Emora Mani awiya puro pirisa babuzera-una ta sao tauyao ge gipao emo auna waweng pugai awong na daya magayanese sero emo Yuda okora-una waweng pugarineya. ");
INSERT INTO zia_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ayero pugaya emo Yuda oko mene na isipu nasani begura na eno pisero waung mene na yana-kana dero aune daya magayarinena. Magayana wari be etama aung yai aune nupema iroparinena.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedira mani etobe Yakoboto Yohane, awongto amimene Yesura-una buro eyero sewato, “Gipao emo, ning nato eno nona zo yasese kotupunenato.” ");
INSERT INTO zia_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ayero sewato giro abena eyero sena, “Na nomaze nito eno yanese kotupuneito?” ");
INSERT INTO zia_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ayero senu awongto sewato, “Ning waegaore mitarinesa be aune nato deungbe nina-una adungno mitarinenato, zo wawong mera, zo wawong mepora, awiya nigasese sinenato.” ");
INSERT INTO zia_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ayero sewato nung abena ge pungyao awongto eno sena, “Nito nonana susuwa oko gao yero na atata yeteyato. Na ou dokowang yao zo minarinena, awiya nito minao teng yarineitota? Na ou suwao zo pumarinena, awiya nito pumao teng yarineitota?” ");
INSERT INTO zia_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ayero senu awongto eyero sewato, “Nato teng yarinenato.” Ayero sewato giro nung eyero sena, “Na ou dokowang yao zo minarinena, awiya nito dema minarineyato. Na ou suwao zo parinena, awiya nito dema parineyato. ");
INSERT INTO zia_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Arata nito wawong nana mera, ta wawong nana mepora adungno mitarineyato auna ge awiya nane sao ine teng oko. Tuwa Bayau mene masi awiya emo ena eno kora yenu mitoiya. Arare awong amimene masi auna atu adungno mitarineya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Buro-mani 10 mene ge awiya nigiro Yakoboto Yohane eno dubo mou yewa. ");
INSERT INTO zia_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ayero yewa giro Yesu mene buro-mani 12 yau senu bumuwa eyero sena, “Tawingna emo tuwa mene emo bauno awong sou yaese sinowa. Nupema emo babuze mene emo bauno puro wosiro awong witao nunae ine yero nowa, awiya gosinowa. ");
INSERT INTO zia_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Arata ninae mene zo ayero oko yae. Ninae-una zo mene baina ninae yari yero giro enana soremao yero naise. ");
INSERT INTO zia_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Gitau yao ninae yari yero giro enana soumani yero naise. ");
INSERT INTO zia_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Noeno okowata, na Emora Mani mene emo na sou yaese okowata, na natope sou buro nasani magayero emo bauno witao mekora atu sorero pumari bumuwang.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu buro-mani nuna aune baungno kasa ye Yeriko nape gairo napo awiya duwari sero emo bauno dubu baina aune dema bautu newa emo diti guma yao zo yazo nuna Batimea, nung Timeara mani, amimene nagibo deungbera atu adungno mitina ara. Nung moni eno isa sinauna. ");
INSERT INTO zia_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Arare nung atu mitasani Yesu Nasaretera emo etu butuniya auna ge nigiro nung arugairo sena, “O Yesu, ning Dawidira sai, ning na eno yo aung.” ");
INSERT INTO zia_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ayero senu emo witao mene nung gona yero sewa, “Ning ge do.” Ayero sewa, arata nung nupema wawa baina sena, “O Dawidira sai, ning na eno yo aung.” ");
INSERT INTO zia_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ayero senu giro Yesu mene dopero eyero sena, “Yau sepu bae.” Ayero senu awong emo diti guma yao awiya yau sero sewa, “Awang oko yase. Iropuro dope. Nung ning yau siniya.” ");
INSERT INTO zia_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ayero sewa nung mo wape nuna kougairo mena dopero kasa ye Yesura-una yenu ");
INSERT INTO zia_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu mene nung eno eyero sena, “Na nomaze ning eno yanese sinesi?” Ayero senu emo diti guma yao amimene eyero sena, “Gipao emo, diti moko nana iwaing yaise sinena.” ");
INSERT INTO zia_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ayero senu Yesu mene nung eno eyero sena, “Ning baung. Tumo diyao nina-una teng ning iwaing nesa.” Ayero senu diti moko nuna iwaing yenu nung Yesu nagibe atu ago yero baungna arauwa. ");
INSERT INTO zia_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Awong napo Yerusalem nugu kasa yewa. Napo maingkoka etobe yazo nunato Betefasito Betani atu mitauwato ara. Atu kasa yero diri yazo nuna Oliwa awiya zorogairo Yesu mene buro-mani etobe gitau babaetose sero awongto eno eyero sena, ");
INSERT INTO zia_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Nito buwagairo napo nugu mitiya auna baungputo. Baungno atu kasa yero wo dongki auna mani zo kimegeya mitiya awiya tamarineyato ara. Emo zo za wo auna tame oko adumao. Wo awiya besero puro bungputo. ");
INSERT INTO zia_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Anayato emo zo mene, ‘Nito no yari wo awiya besineito?’ ayero sariniya, awiya nito nung eno eyero seputo: ‘Tuwara buro euna mitiya. Nung etu mena nupema pugariniya.’ Ayero seputo.” ");
INSERT INTO zia_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yesu mene ayero senu awongto baungno wo dongkira mani awiya tamuwato. Wo awiya emo mene garo bera atu kimegaiwa nagibo nugu atu mitina awiya taungno besewato ara. ");
INSERT INTO zia_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Angsi besinewato emo ena atu mitiwa amimene awongto eno eyero sewa, “Nito no yari buro wora angsi besineito?” ");
INSERT INTO zia_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ayero sewa giro awongto ge Yesu mene saetose sena awiya sewato giro duwa. ");
INSERT INTO zia_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ayero yewa awongto wo awiya puro baung Yesura-una yewato awong mo nunae wo tame atu zuwewa Yesu mene wo tame witiro aduna. ");
INSERT INTO zia_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ayero yenu emo witao mene taung wori nunae puro nagibe atu ero zuwewa. Ena mene i bure baungno i bowang kapero puro buro nagibe atu pugairo pugairo bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Arare emo gitau bautu newa aune emo ago butunewa amimene arero sewa, “Emo Tuwara bera butuniya nung awiya bowi yanene. ");
INSERT INTO zia_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tuwa yero naora be nuna kasa yariniya, arare nung bowi yanene. Ewowo naname Dawidi auna emo tuwa yaora be awiya nune nupema tamariniya. Oro, oro, Tuwa Bayau eno sanene.” Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu mene Yerusalem kasa yero Tuwa Bayaura ibu baina auna toiro nona apakana awiya gigina. Gosinenu ture itinenu giro nung napo awiya doro buro-mani nuna 12 aune dema napo Betani auna bamuwa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Iya gainu awong napo Betani awiya doro bautu newa Yesu nung meri auno giro ");
INSERT INTO zia_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","i zo yazo nuna fik awiya gire ake atu giro nung me ena mitita asero gari baungna ara. Baungno i auna nugu kasa yero me aung gi gege gigina. Awiya noeno okowata, me iyaora be aung. ");
INSERT INTO zia_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Arare Yesu mene i aeno waru ge eyero sena, “Emo zo mene me nina oko minariniya.” Ayero senu buro-mani nuna mene ge awiya nigiwa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Awong kasa ye Yerusalem gaiwa Yesu nung ibu bainana toiro emo ibu mokora atu nona wina-piti newa awiya dero awang sero tunena ara. Ayero nasani nung emo moni wina-piti newa auna tewo awiya ininu kapetegainu emo ni gumo pugao emo auna adumao masi dema kapetegaina ara. ");
INSERT INTO zia_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ayero yero awong nona diungno ibu baina auna puma-sauma yao awang sena. ");
INSERT INTO zia_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nung awong eno eyero sena, “Ge gayao zo eyero mitiya era, ‘Ibu nana awiya tawing sero sero auna emo bauno mene isa saora ibu mitaise.’ Ge gayao ayero mitiya, arata niye yeteya ibu awiya ugaing yao emora pungyao masi ine niya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ayero senu emo bauno apakana amimene Yesura ge nigiro wawong di gamuwa. Ayero yewa pirisa babuzere sao tauyao ge gipao emo mene ge awiya nigiro Yesu awang yero nung dari sero nagibo tamari yewa ara. ");
INSERT INTO zia_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ture itinenu Yesu buro-mani nuna aune awong Yerusalem doro bamuwa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Iya gainu awong angyero i fik auna nugu baungno i irara yena awiya gigiwa. Tatai nuna aune dema irara yena. ");
INSERT INTO zia_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ayenu Petoro mene i awiya giro kotungno Yesu eno eyero sena, “Gipao emo, ewiya gi. Nine i fik zo waru yetesa amimene irara yetiya.” ");
INSERT INTO zia_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ayero senu Yesu mene eyero sena, “Niye Tuwa Bayau tumo dipu. ");
INSERT INTO zia_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Na ge me eyero sinena era. Emo zo mene diri ewiya eno eyero sariniya, ‘Ning nitope iropuro baungno witora gute.’ Nung ayero sariniya, awiya tani deka ayao ine kasa yariniya. Arata emo amimene dubo eto yariniya, awiya tani awiya oko kasa yariniya. Nung, ‘Ge diri eno sesena awiya me yariniya,’ asero nariniya, awiya tani awiya kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Arare na niye eno eyero sinena era. Niye nona zo pumari sero giro isa sarineya be aune niye eyero kotungpu: Tuwa Bayau mene nona awiya nae eno pugariniya. Ayero kotumarineya, awiya nona pumarineya. ");
INSERT INTO zia_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ora niye isa sari sero yero giro dopero aune emo zo eno dubo mou puro nete giro mouyao awiya disepu. Mama naname uritira mitoiya amimene pasena ninae dema disaise sero niye emora pasena awiya disepu. ");
INSERT INTO zia_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Arata niye emo zora pasena oko disao yarineya, awiya Mama nana uritira mitoiya amimene pasena ninae dema oko disariniya.” Yesu mene ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Awong nupema tera kapete gairo baungno Yerusalem kasa yewa. Atu kasa yewa Yesu mene ibu bainana atu ang nenu pirisa babuze ta sao tauyao ge gipao emo ena ta simai ena amimene nuna-una kasa yero ");
INSERT INTO zia_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","nung eno eyero sewa, “Ning nae eno se. Ning ana bera tani awiya yero nosi? Awe senu tani awiya yero nosi?” ");
INSERT INTO zia_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ayero sewa Yesu mene awong eno eyero sena, “Na niye eno atata zo yarinena. Niye abena na eno sarineya, awiya nane deka ayero ana bera tani awiya yero nona auna susuwa sarinena. ");
INSERT INTO zia_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yohane ge ou zayero suwao emo amimene buro nuna awiya ana bera yero nauni — emora bera ta Tuwa Bayaura bera i? Ge sepu nigane.” ");
INSERT INTO zia_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ayero senu awong nuka nuyetope ge wina-se nasani eyero sewa, “Nae Yohanena ge ou suwao awiya uritira nona asarinenane, awiya nung eyero sariniya, ‘Arare niye nono yero ge nuna oko nigao yewi?’ ");
INSERT INTO zia_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Arata name eyero sarinenineta? ‘Yohanena ge ou suwao awiya emora nona.’ Ayero sarinenineta?” Ayero wina-se yewa ara. Awiya noeno okowata, emo bauno apakana mene Yohane gosinauwa nung porofete me yero nauna, arare awong emo bauno awang nasani ");
INSERT INTO zia_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yesu eno eyero sewa, “Nae oko gao yero nenane.” Ayero sewa Yesu mene awong eno eyero sena, “Arare na ana bera tani awiya yero nona auna susuwa awiya niye eno oko keregarinena.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu mene ge eniya ena sero awong eno eyero sena, “Emo zo mene wain urero goma gaero wain buro diya yao emo auna garo yena ara. Ayero yero nung wain me mozaora kote baina zo wauna. Ayero yero aune nung emo ena eno eyero sena, ‘Na tawing zora babarinena, arare niye buro nana diya yepu. Diya yarineya, awiya na me nuna ena niye eno pugarinena.’ Ayero sero nung doro tawing zo omete oko auna baungna. ");
INSERT INTO zia_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Arare wain me paora be bunu giro buro maung mene buro-mani zo buro nuna diya yero nauwa auna-una baungno wain me ena pumaise sero iyengtinu baungna. ");
INSERT INTO zia_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Baungno kasa yenu awong nung puro waung mene dero awang sewa nona aung wawong usa yero baungna. ");
INSERT INTO zia_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ayero yenu giro buro maung mene nupema buro-mani zo nunae-una babaise sero iyengtinu baungnu awong nung puro giro sero gero iro ziye atu dewa bozo yena ara. ");
INSERT INTO zia_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ayero yewa giro buro maung mene nupema buro-mani zo iyengtinu baungnu awong nung dewa magayena ara. Tani ayao gege nasani nauwa. Nung buro-mani witao pugatinaunu bautunauwa awong buro-mani ena waung mene dero buro-mani ena dero nauwa magayero nauwa. ");
INSERT INTO zia_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ayero nawe duwa emo dekaongka gege nung buro maung aune mitauna. Nung mani emodi nuna. Nung awiya yo dingya nuna. Arare nung mani nuna nunae-una babaise sero eyero kotungna, ‘Awong mani nana-una ge oko darineya.’ Ayero kotungno iyengtinu baungna ara. ");
INSERT INTO zia_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Arata buro diya yao emo mene nuka nuyetope wina-se yero eyero sewa, ‘Mani euna maung magayai aune nung maungna tawing ewiya pumariniya. Nung danane magayai aune tawing nuna ewiya tawing naname yariniya ara. Bungpu.’ ");
INSERT INTO zia_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ayero sero awong nung saniro dewa magayenu aingso nuna puro wain buro doro au goma bautara gaiwa ara. ");
INSERT INTO zia_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ayero yewa, arare wain buro maung mene nono yariniye? Nung buro diya yao emo awiya dai magayaya aune emo ena mene tawing nuna diya yaese sariniya ara. ");
INSERT INTO zia_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Niye Tuwa Bayaura ge ewiya gitau zazagaiwita? Garo yao emo mene daba zo gigiwa meko yenu duwa. Arata daba amimene garo autura ziwong yero mitoiya. ");
INSERT INTO zia_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nona awiya Tuwara bera kasa yena. Naname gigenane iwaing niya. Niye ge awiya gitau zazagaiwita?” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Awong Yesura ge nigiro nung ge eniya awiya awong eno sena awiya giro nung gera pugari sewa, arata awong emo bauno dubu baina atu mitiwa awiya awang yero giro Yesu doro bamuwa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yuda emora gitau yao ena mene Farisayo ena aune Herodera Pati memba ena aune awong awiya Yesura-una iyengtiwa bamuwa ara. Awiya Yesura ge zo puro nung gera pugari sero bamuwa. ");
INSERT INTO zia_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Awong baungno ge nung eno eyero sewa, “Gipao emo, ning ge me gege sinosa awiya gosinenane. Ning emo zo oko awang nosa. Ning emo witaore emo wosaore apakana gosinosa ziyo gomi dekaongka gege noiya. Ning ge me sinasani Tuwa Bayaura nagibo gipinosa. Arare name Yuda emo mene takis moni Roma emora emo tuwa Sisa aeno pugatinonane, awiya ning gosinosa teng noita aung i? ");
INSERT INTO zia_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Name takis moni pugari nenineta duwari nenine?” Ayero sewa ara. Arata Yesu nung awong iwora yani itari sero newa awiya giro eyero sena, ");
INSERT INTO zia_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","“Niye noeno na gaero gari sero nei? Moni zo pugaipu bai gane.” Ayero senu awong moni zo pugaiwa puro eyero sena, “Ititire owere monina mitiya ewiya ana i?” Ayero senu awong eyero sewa, “Awiya Sisara.” ");
INSERT INTO zia_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ayero sewa nung awong eno eyero sena, “Niye nona Sisara asero giro Sisa eno pugaipu. Ora nona Tuwa Bayaura asero giro Tuwa Bayau eno pugaipu.” Ayero senu awong ge awiya nigiro wawong di gamuwa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadukayo emo mene eyero sinauwa, “Mamagayao awong nupema oko iroparineya.” Arare Sadukayo ena mene Yesura-una buro nung gaero gari sero eyero atata yero sewa, ");
INSERT INTO zia_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Gipao emo, Mose mene name eno eyero sero gaena: Emo zora tato magayai aro nuna mani aung mitariniya, awiya emo amimene tato nuna-una aro noi awiya atiro mani tato nuna eno pumaise. Mose mene ayero gaena ara. ");
INSERT INTO zia_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Arare gitau metato 7 mitauwa. Tato kiyongne amimene bauno atiro mani oko pumao magayena. ");
INSERT INTO zia_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ayero yenu meta nuna nung tamaira amimene bauno deka awiya atiro mani oko pumao magayena. Ayero yenu nupema nung tamaira deka ayero yena. ");
INSERT INTO zia_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ayero yero metato 7 apakana bauno awiya atiro mani oko pumao magayewa. Ago bauno awiya magayena. ");
INSERT INTO zia_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Metato 7 mene nung atiro nasani nauwa, arare mamagayao iroparineya be aune bauno awiya ana yariniye?” ");
INSERT INTO zia_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ayero sewa Yesu mene awong eno eyero sena, “Niye Tuwa Bayaura ge gayaore Tuwa Bayaura putoungne awiya oko gao, arare niye ge me wosopatiro nowa. ");
INSERT INTO zia_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Magayao mene iropuro nupema oko wina-ati yarineya. Awong uritira angelo ine yero narineya. ");
INSERT INTO zia_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Niye mamagayao iroparineita asero atata neya, arata niye ge Mose mene gaena awiya zazagatinowita? Nung i motu zora atu iyao awinenu gigina. Arata iyao mene i motu awiya oko awero aung yao yena auna ungwe awiya gaitinete aune ge zo Tuwa Bayau mene nung eno sena awiya eyero gaena, ‘Na Abrahamto Isaka aune Yakobo auna Tuwa yero mitona.’ Niye ge awiya zazagatinowita? ");
INSERT INTO zia_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tuwa Bayau nung emo mamagayao asinonane awiya gosinoi seka gege yero nowa. Arare nung emo magayaora Tuwa okowata, nung emo seka mitowa auna Tuwa yero mitoiya. Mamagayao iroparineya auna susuwa wosopatiro baingtitinowa.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Sao tauyao ge gipao emo zo mene kasa yero awong ge wina-se newa ge awiya nigina. Yesu mene awong eno ge iwaing wina-se nenu giro nung Yesu atata yero sena, “Sao tauyao ge nomi gitau yao niye?” ");
INSERT INTO zia_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ayero senu Yesu mene eyero sena, “Sao tauyao ge gitau yao awiya eyao mitiya, O Isreli emo, ge ewiya nigipu. Baina naname nung Tuwa Bayau. Nung nata Tuwa naname. ");
INSERT INTO zia_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ara tamao nina bainakama awiya Tuwa Bayau nina auna-una mitaise. Ayero nasani dubore ititire kotumaore putoungne nina mene nung sou ye. ");
INSERT INTO zia_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Sao tauyao ge auna wese awiya eyao era, Ning nika nitope aratapunosa, deka ayero emo ena aratamase. Sao tauyao ge etobe amimene gege baina neyato. Sao tauyao ge eyao ine zo oko mitiya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ayero senu sao tauyao ge gipao emo amimene Yesu eno eyero sena, “Gipao emo, me sinesa. Tuwa Bayau dekaongka gege mitiya. Tuwa zo aung awiya me sesesa. ");
INSERT INTO zia_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Arata dubore kotumaore mene Tuwa Bayau aratamao ta naka nametope aratapunonane deka ayero emo ena aratamao, awiya tani etobe iwaing ara. Arata tani nona Tuwa Bayau eno pugari sero iyaora pugao awao ta tani wo Tuwa Bayau eno pugari sero dao magayao, awiya tani etobe iwaing maingkoka gege.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ayero senu Yesu mene ge nuna niginu iwaing yenu giro nung emo kotumaore giro nung eno eyero sena, “Tuwa Bayau mene beba Tuwa nina niya.” Ayero senu emo bauno apakana Yesu atata yao awang yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu mene Tuwa Bayaura ibu bainana toiro awong eno ge tugata nasani eyero sena, “Sao tauyao ge gipao emo mene eyero sinowa, ‘Yuda emora Sorao Emo yazo nuna Kristo, nung amimene Dawidira sai.’ Nono yero ayero sinowi? ");
INSERT INTO zia_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Oweno mene kotumao Dawidi eno pugainu Dawidi nung nuka nune eyero sena, Tuwa Bayau mene Tuwa nana eno eyero sena, ‘Ning wawong me nana-una adungno mitasa na iwo dubu nina awiya benaung nina-una pugana gona yarinesa.’ Tuwa Bayau mene Tuwa nana eno ayero sena ara. Dawidi ayero sena ara.” Yesu mene ayero sero susuuno eyero sena, ");
INSERT INTO zia_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Dawidi mene ge ayero sinasani Kristo eno ‘Tuwa nana’ asena. Arare Kristo nung nono yero Dawidira sai yariniye?” Yesu ayero senu emo dubu bainane mene ge nuna nigiro yawa yawa yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu mene ge tugata nasani eyero sena, “Niye sao tauyao ge gipao emo awiya umo yepu. Awong taung wori imokakaung wosogairo ang naya emo bauno mene awong kakame atu giro bowi yaese aratapunowa. ");
INSERT INTO zia_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nupema awong yere ibura atu emo baunona benaungna adumari aratapunowa. Nupema awong ana-bonene yaora bera atu masi yazore auna adumari aratapunowa. ");
INSERT INTO zia_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Awong bauno yu mamaga yetugao awiya etegairo wau moni nunae pupunowa. Ayero nasani awong pasena nunae worero mani me sao yero nasani isa imoko-kaungkaung sinowa. Emo amimene abena nunae mou-mesayao tamarineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu mene Tuwa Bayaura ibu bainana toiro adungno emo bauno moni kolektara pugatinewa awiya gigina. Emo waure daigairo mene wau witao pugatinewa ");
INSERT INTO zia_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","bauno bogamasa zo yu magayao amimene buro toya etobe pugaina ara. ");
INSERT INTO zia_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ayero yenu giro Yesu mene buro-mani nuna yau senu bumuwa eyero sena, “Na ge me niye eno sinena era. Bauno zo yu magayao wau moni aung amimene moni pugaiya awiya emo apakana moni Tuwa Bayau eno pugatineya auna moni awiya daigatiniya. ");
INSERT INTO zia_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Noeno okowata, awong awiya moni witao mitiya, arata awong ena gege Tuwa Bayau eno pugeya. Arata bauno ewiya moni nuna maingkoka mitiya auna teng pugairo aung yetiya. Arare nung nona zuma gaero minaora zo oko mitiya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu buro-maine dema ibu baina doro kasa ye daung gatinewa buro-mani zo mene nung eno eyero sena, “Gipao emo, ibura daba babuze awiya gi. Ibu iwaing-kawaing ara.” ");
INSERT INTO zia_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ayero senu Yesu mene nung eno eyero sena, “Ning ibu iwaing gosinesa. Arata ago ibura daba zo oko duwaya zora-una tame mitariniya. Emo mene ago ibura daba apakana kasarineya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu mene diri yazo Oliwa auna witiro adungno ibu baina awiya anuwing nasani mitinu Petoroto Yakobo aune Yohaneto Anderea awong amimene nata nung aune dema mitasani giro nung atata yero sewa, ");
INSERT INTO zia_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Gire, tani awiya be nazi kasa yariniye? Ora nae tani no saore giro susuwa auna me kasa yariniya awiya garinenine?” ");
INSERT INTO zia_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ayero sewa giro Yesu mene awong eno eyero sena, “Emo zo mene niye etegoiye sero, niye giro baingtipu. ");
INSERT INTO zia_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Emo witao mene buro ge iwi nasani eyero sarineya, ‘Na Kristo.’ Ayero sinasani awong emo bauno witao etegarineya. ");
INSERT INTO zia_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Niye winade-wanade nugu mitarineya arita winade-wanade ake-akemo mitariniya auna bowi nigiro awang oko yae. Winade-wanade kasa yariniya, arata kasa yaya tawingna be oko mena besugariniya. Ago tani ena susuuno kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Dubu zo mene iropuro dubu zore dema winade-wanade yarineya. Emo tuwa enana dubu mene iropuro emo tuwa enana dubu aune winade-wanade yarineya. Soma enana atu dumi babuze ipariniya. Nupema dora botiyo babuze kasa yerota kasa yero ayariniya. Bauno mani pumari yero nowa auna yaya bere maingkoka zayero noiya. Arata ago awiya bainakama kasa yero noiya. Ayao ine yaya sesena awiya kasa yai aune yaya bainakama ago kasa yariniya, awiya garineya. ");
INSERT INTO zia_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Arata niye nika niyetope giro baingtipu. Awong niye puro gera pugarineya. Awong niye yere ibu mokora atu waung mene darineya. Niye buro-mani nana yero nowa, aeno awong niye puro emo babuzere emo tuwa ena auna-una pugaya doparineya ara. Dopero ge me awong eno sarineya. ");
INSERT INTO zia_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bowi Iwaing tawing sero gitau babai aune tani awiya ago kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Emo mene niye saniro puro gera pugaya be aune niye no sari yero kotung-katung oko yae. Niye gera pugaya be aune ge Tuwa Bayau mene niye eno pugao awiya sepu. Ninae okowata, Oweno mene ge sariniya. ");
INSERT INTO zia_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tatomani ena mene metamani nunae magayaese sero iwora waweng pugarineya. Mamono ena mene mani awiso nunae magayaese sero iwora waweng pugarineya. Mani awiso ena mene iropuro ai amono mamono iwo nasani magayaese sero iwora waweng pugarineya. ");
INSERT INTO zia_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Niye dubu nana yero nowa awiya emo bauno apakana gosinowa aeno awong tini kapao niye eno pumarineya. Arata zo nung tau yero dopero nete magayariniya, nung awiya Tuwa Bayau mene sorero pumariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesu mene ayero sero sena, “Sisigaora nona meko amimene masi nung mitaine teng oko auna atu dopariniya awiya garineya. Be aune awong Yudaya tawingna mitarineya amimene iwo awong doiye sero sungno baung diri yaese. (Emo ge gayao ewiya zazagatinoiya amimene gera susuwa awiya gaise.) ");
INSERT INTO zia_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Be aune zo nung garo nuna-una opesara atu mitariniya amimene nona-owi nuna gare mitiya awiya pumari oko towaise. Nung iwo mene doiye sero sungno baung diri yaise. ");
INSERT INTO zia_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Be aune zo nung bure atu nariniya amimene taung wori nuna pumari sero oko kapetegairo nape babaise. Nung dema iwo mene doiye sero sungno baung diri yaise. ");
INSERT INTO zia_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Oiye, bauno mesare aune bauno mani wuire. Awong yanakana sumaine yao teng oko, arare na awong eno yo apunena. ");
INSERT INTO zia_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tani awiya wa wosaora be nai aune kasa yai wa mene niye gazao eno, niye isa sepu. ");
INSERT INTO zia_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Noeno okowata, be auna atu mouyao bainakama kasa yariniya ara. Tuwa Bayau mene tawing yena atu zayero butunawe duwa atu mouyao zo ayao ine oko kasa yena. Nupema ago zo ayao ine oko kasa yariniya ara. ");
INSERT INTO zia_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Arare Tuwa mene be awiya oko kapao yatiya, awiya emo bauno apakana sisigairo aung yateya. Arata nung gegeregao dubu nuna eno kotungno aeno be awiya kapena, arare apungka yariniya ara. ");
INSERT INTO zia_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Arare be aune emo zo mene niye eno eyero sai oko nigae, ‘Era, Sorao Emo naname ara.’ Nupema, ‘Sorao Emo naname ora.’ Ge ayero sero buro baungno ayaya oko nigae. ");
INSERT INTO zia_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Be auna atu Sorao Emo etegao enane porofete etegao enane amimene kasa yarineya. Kasa yero emo baunona dubo sisigari sero tani putoungne ena aune tani benaung sekawa witao awiya yarineya. Ayero nasani Tuwa Bayaura gegeregao dubu auna dubo dema sisigari sero buro baina yarineya ara. Arata awong Tuwa Bayaura gegeregao dubu auna dubo sisigao teng oko, arare yero tetere yarineya ara. ");
INSERT INTO zia_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Arata niye nika niyetope umo yepu. Na tani ago kasa yariniya auna ge bere-bere eune niye eno keregatinena.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yesu mene ayero sero aune eyero sena, “Yaya tamaora be awiya aung yai aune wari mume yariniya. Ayero yai inona waegao awiya dema aung yariniya. ");
INSERT INTO zia_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ayero nai aune putoung uritira mitowa amimene iparineya. Ayero yai arasa mene uritira atu zokero wosarineya. ");
INSERT INTO zia_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tani ayero kasa yai aune na Emora Mani mene putoung tauyaore waegaore berezera atu wosiro butunana emo bauno mene garineya ara. ");
INSERT INTO zia_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Na wosiro angelo iyengtiro emo bauno dubu Tuwa Bayau mene nuna yaese gegeregaina awiya puro pu dekaongna gaese sarinena. Arare angelo mene baungno tawing ageware ageware ikata enaka auna gegeregao dubu nana pumarineya ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesu mene ayero sero aune eyero sena, “Niye i yazo fik auna tani awiya kotungno aune susuwa zo gipu. Bowang nuna botu kasa yero dang iwaing ditinowa be aune niye giro, ‘O, warira be kasa yariniya,’ ayero sinowa. ");
INSERT INTO zia_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Arare nona awiya apakana kasa yero aung yai giro eyero sepu, ‘Nung nugu yetiya. Towao bera bautara dodopiniya.’ ");
INSERT INTO zia_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Na ge me niye eno sinena era. Emo bauno yeme tawingna etu neya amimene oko magayero aung yao naya aune nona awiya apakana kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ago uritire tawingne aung yarineyato, arata ge nana mene zo oko aung yariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesu mene ayero sero aune eyero sena, “Tani awiya kasa yaora be nuna awiya emo zo za oko gosineya. Angelo uritira nowa adeka dema be awiya oko gosineya. Na Tuwa Bayaura Mani mene dema be awiya oko gosinena. Mama nana mene gege nata gosinoiya ara. ");
INSERT INTO zia_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Niye umo nasani neupu. Be nazi tani awiya kasa yariniye, awiya niye oko gosineya. Arare umo yero baingtipu. ");
INSERT INTO zia_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Susuwa nuna eyero mitiya. Emo zo mene tawing ake-kake auna babari sero giro buro-mani nuna awong nona apakana diya yaese sero burora pugaina. Zo buro zora pugairo zo buro zora pugairo ayero yena ara. Ayero nasani garo be diya yao mani mene umo yero baingtaise sero garo doro baungna. ");
INSERT INTO zia_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Arare be nazi garora maung mene kapete gariniye — ture itinai auneta, ping tuno-tanota, kokora ge sinai auneta, nupema iya gaora i? Awiya niye oko gosineya, arare niye umo yero baingtiti nasani neupu. ");
INSERT INTO zia_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nung mena kapetegairo niye auriti awinasani mitaya tamoiye sero niye umo yero baingtiti nasani neupu. ");
INSERT INTO zia_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Na ge niye eno gege okowata, emo bauno apakana aeno sinena. Niye umo yero baingtiti nasani neupu.” Yesu mene ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Magayao mene awong Daigaina auna bonene minaora be kasa nenu be zo ame yis aung auna bonene minaora be awiro nupema awiro kasa yari nenu giro pirisa babuze aune sao tauyao ge gipao emo ena aune awong amimene Yesu etegairo saniro daya magayaise sero nagibo tamari yewa. ");
INSERT INTO zia_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Awong eyero sewa, “Emo bauno name dao eno, name oregao be baina auna atu oko yarinenane.” Ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu buro-mani nuna aune napo Betani atu baungno emo zo yazo nuna Simon Bozo Tauyaore auna gare atu nona mininasani mitiwa bauno zo garewa daba yazo nuna alabasta amimene yao awiya puro nuna-una buna. Ou zo yazo nuna nad, sere nuna iwaing, awiya garewa mokora mitina. Zuma nuna baina. Arare bauno amimene kasa yero garewa awiya zorogairo ou sere yao awiya Yesura ziye atu yasagaina. ");
INSERT INTO zia_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ayero yenu emo ena atu mitiwa amimene yo iropunu wina-se yewa, “Noeno ou ewiya gera niye? ");
INSERT INTO zia_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nung ou ewiya moni 300 kinana sai zuma gaero pumaya aune nung moni awiya emo bauno bogamasa eno pugai teng yatiya.” Ayero sero awong nung gona yewa. ");
INSERT INTO zia_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ayero yewa Yesu mene awong eno eyero sena, “Niye bauno dopu. Niye noeno bauno kaputinei? Tani nung na eno yetiya, awiya tani iwaing. ");
INSERT INTO zia_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Noeno okowata, emo bauno bogamasa awong niye aune dema nowa narineya. Arare niye awong kora yari sero kotumarineya, awiya nagibo ayao mitariniya. Arata nane mene zo niye aune dema oko nao gege narinena. ");
INSERT INTO zia_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Bauno emimene tani nune yaine yao auna teng tani ewiya niya. Ago awong aingso nana mutarineya, arata nung bere-bere buro magayaora ou ewiya aingso nana-una susuniya. ");
INSERT INTO zia_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na ge me niye eno sinena era. Bowi Iwaing tawing sero bautunai aune tani iwaing na eno yetiya auna bowi awiya dema sero sero yaya babariniya ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Be aune Yudas Iskeriot, nung buro-mani 12 auna zo, amimene Yesu keregairo gera pugari sero pirisa babuzera-una baungna ara. ");
INSERT INTO zia_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Baungnu awong ge nuna nigiro yawa yawa yero nung eno eyero sewa, “Ayero yasa nae moni ena ning eno pugarinenane.” Ayero sewa giro nung Yesu gera pugaora nagibo tamari buro yena. ");
INSERT INTO zia_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Oregao be baina yazo nuna Ame Yis Aung auna iya namba wan aune Yuda emo mene Magayao mene awong Daigaina auna bonene awiya minari sero wo sipsip mani zo dero aero mininauwa. Arare be awiya kasa yenu giro Yesura buro-mani mene nung eno eyero sewa, “Name natu baungno Magayao mene awong Daigaina auna bonene nina kora yanenese kotupunesi?” ");
INSERT INTO zia_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ayero sewa giro Yesu mene buro-mani nuna etobe iyengtiti nasani awongto eno eyero sena, “Nito nape baungnoto emo zo ou aura dungno puro bautuniya awiya tamarineyato ara. Nito nung aune dema babarineyato. ");
INSERT INTO zia_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nung gare towai aune nito garora maung eno eyero seputo, ‘Gipao emo mene ning atata niya. Nung nae buro-mani nuna aune Magayao mene awong Daigaina auna bonene garo moko nauna atu minarinenine?’ ");
INSERT INTO zia_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ayero sayato nung garo moko baina zo garo ika tame mitiya awiya nito eno gipariniya. Garo moko awiya masi zuwao au-tao kora yao mitiya. Gipai giro atu nito bonene minaora nona kora yeputo.” ");
INSERT INTO zia_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ayero senu giro buro-mani etobe mene iropuro napo auna baungno nona Yesu mene sena deka ayao ine taungno Magayao mene awong Daigaina auna bonene minaora nona kora yewato ara. ");
INSERT INTO zia_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ture inu Yesu mene buro-mani nuna 12 aune dema kasa yewa. ");
INSERT INTO zia_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Awong adungno nona mininasani mitiwa aune Yesu mene eyero sena, “Na ge memoko niye eno sane. Ninae-una zo mene na keregairo iwora waweng pugariniya. Emo na aune dema nona mininiya amimene yariniya.” ");
INSERT INTO zia_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ayero senu awong dubo mininasani nata-nata nung eno eyero sewa, “Nane oko yarinena. Me sinenita?” ");
INSERT INTO zia_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ayero sewa nung awong eno eyero sena, “Niye buro-mani nana 12 auna zo mene yariniya. Emo zo na aune dema ame sura dusariniya amimene yariniya. ");
INSERT INTO zia_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ge gitau gaewa mitoiya ayero na Emora Mani mene magayarinena. Arata emo na Emora Mani keregariniya, nung awiya, oiye, abena nuna nono yao pumariniye? Ai nung oko pumao yatiya, awiya nung meko oko tamatiya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Awong nona mininasani mitiwa Yesu mene poro puro Tuwa Bayau eno dange sero eegairo buro-mani nuna eno pugati nasani eyero sena, “Puro minipu. Ewiya goi nana.” ");
INSERT INTO zia_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ayero sero nung awang ou wainne zo puro Tuwa Bayau eno dange sero awong eno pugainu awong apakana puro miniwa. ");
INSERT INTO zia_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ayero yewa Yesu mene awong eno eyero sena, “Awiya yu nana. Yu nana mene Tuwa Bayau aune tairo nao auna ge inai tau yariniya. Yu nana emo bauno daigairo eno wosariniya. ");
INSERT INTO zia_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Na ge me niye eno sinena era. Na ou wain nupema oko minarinena. Ago Tuwa Bayau nata tuwa yero naora be kasa yai aune na ou wain seka minarinena.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Awong yere zo gauno iropuro Yerusalem doro baungno diri yazo Oliwa auna witiro mitiwa ");
INSERT INTO zia_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu mene awong eno eyero sena, “Niye apakana na duwarineya. Noeno okowata, ge gayao zo eyero mitiya era, Na Tuwa Bayau mene wo sipsip diya yao emo dana magayai wo sipsip sisi-bura-bura yarineya. ");
INSERT INTO zia_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Arata na magayaora atu iropuro Galilaya tawingna babana niye ago barineya.” ");
INSERT INTO zia_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ayero senu Petoro mene nung eno eyero sena, “Awong apakana ning duwarineya, arata na ning oko duwarinena.” ");
INSERT INTO zia_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ayero senu Yesu mene nung eno eyero sena, “Na ge me ning eno sinena era. Nine ping eune kokora mene ge be etobe oko saore na bewae yasa be etama yariniya.” ");
INSERT INTO zia_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ayero sena, arata Petoro mene tauyero ge sena, “Awong na ning aune dema daya magayanese sarineya, arata saineba, na ning oko bewae yarinena.” Petoro mene ayero senu giro awong apakana amimene ge deka ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesu buro-mani nuna aune awong baungno soma zo yazo Gesemani auna kasa yero nung buro-mani nuna eno eyero sena, “Niye etu adungpu. Na isa sarinena.” ");
INSERT INTO zia_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ayero sero nung Petoroto Yakobo aune Yohane awong awiya puro baungno te wawongne nuna ipinenu ");
INSERT INTO zia_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","nung awong eno eyero sena, “Na dubo minao bainakama tapunena. Dubo minao mene na puro wosi magayanese niya. Niye etu seka mitasani umo neupu.” ");
INSERT INTO zia_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ayero sero nung maingkoka baungno tawingna atu boma gaero isa sinasani yaya nuna-una kasa yari nena awiya nung daigao teng yai giro daigaise sena. ");
INSERT INTO zia_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Isa ayero sinasani eyero sena, “O Mama nana, ning tani apakana yao teng niya. Ning yaya ewiya nana-una atu sorero pung. Arata kotumao nana-una okowata, kotumao nina-una teng ye.” ");
INSERT INTO zia_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Isa ayero sero kapetegairo buro awong auriti awinasani mitiwa giro nung Petoro eno eyero sena, “Simon, auriti awinesa. Ning be maingkoka gege seka tauyero mitao ine teng oko i? ");
INSERT INTO zia_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Etegao mene ninae-una kasa yoiye sero, niye seka mitasani isa sinasani mitipu. Dubo ninae mene buro iwaing yaora eo niya, arata taung mene mou niya.” ");
INSERT INTO zia_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ayero sero nung nupema baungno isa gitau sena deka amaze nupema sena. ");
INSERT INTO zia_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Isa sero kapetegairo buro awong diti mou yenu nupema auriti awinasani mitiwa gigina. Giro senu awong no saine yero duwa ara. ");
INSERT INTO zia_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yesu mene nupema baungno isa sero kapetegairo awong auriti awinewa giginu be etama yenu giro awong eno eyero sena, “Niye oregatinasani auriti awineya, amaze sinena! Teng yetiya. Be kasa yetiya. Emora Mani keregeya pasena emora-una waweng wiwitinena. ");
INSERT INTO zia_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Keregao emo butuniya. Iropungpu, nunae-una babanene.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ayero sinenu buro-mani 12 auna otao nunae Yudas mene iwo dubu baina gitau yero puro buro kasa yewa ara. Pirisa babuzere sao tauyao ge gipao emo aune simai amimene iwo dubu awiya iyengtiwa gorobo yari sero iwire ami-dawangne puro buro kasa yewa ara. ");
INSERT INTO zia_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Gitau keregao emo amimene iwo dubu baina aeno ge zo eyero sena, “Emo nane saniro toko yarinena, nung arauwa. Arare niye nung saniro puro babarineya.” ");
INSERT INTO zia_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ge awiya gitau sena, arare nung kasa yero Yesura-una baungno, “Gipao emo,” ayero sero nung toko yena ara. ");
INSERT INTO zia_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ayero yenu giro iwo dubu mene Yesu iniwa ara. ");
INSERT INTO zia_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ayero yewa emo dopero mitiwa auna zo mene iwi nuna geingna atu ininu gururu senu nung pirisa bainana soumani awiya dari yero dawong nuna kesena. ");
INSERT INTO zia_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ayero yenu Yesu mene iwo dubu eno eyero sena, “Niye iwire ami-dawangne puro butuneya, awiya gorobo emo zo puro bunari baine neya. ");
INSERT INTO zia_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Be giti awiya na niye aune dema ibu bainana atu ge tugata nasani yero nona niye atu noeno na oko pumao yero nowi? Arata Tuwa Bayaura ge gayao awiya me yaise.” ");
INSERT INTO zia_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ayero senu buro-mani nuna apakana nung doro sungno bamuwa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mani seka zo mene mo neyang yao zo gege awiro Yesura ame nenu iwo dubu mene nung sanari yewa ");
INSERT INTO zia_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nung mo awao nuna yugairo doro aung sungno baungna arauwa. ");
INSERT INTO zia_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Awong Yesu puro pirisa bainana-una bamuwa pirisa babuze simai ena aune sao tauyao ge gipao emo ena amimene garo auna augaiwa ara. ");
INSERT INTO zia_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ayero newa Petoro mene ake ina atu Yesu ago yero buro pirisa bainana goma auna toiro baungno umo yao emo aune dema adungno iyao ainasani kakame atu mitina ara. ");
INSERT INTO zia_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pirisa babuzere gitau yao dubu apakana awong teng mitasani emo zo mene Yesu eno ge iwao ge sai Yesu gera pugairo daya magayaise sero ge iwao ge ena tamari sero yewa ara. Arata awong pasena nuna zo oko tamuwa. ");
INSERT INTO zia_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Emo witao mene Yesu tani yero nauna auna ge ungwe nasani ge iwao ge ena sewa, arata ge iwao ge nunae auna susuwa awiya dekaongka gege oko sewa. ");
INSERT INTO zia_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ena mene dopero ge iwero sero eyero sewa, ");
INSERT INTO zia_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nae ge nuna nigiwangne. Nung eyero sena, ‘Na Tuwa Bayaura ibu emo bauno mene yewa awiya kasarinena. Kasana wari iya be etama aung yai aune na ibu zo wawong mene yao okowata, ewe zo yarinena.’ Nung ayero senu nigiwangne.” Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Arata awong ayero sinasani ge nunae auna susuwa awiya dekaongka gege oko sero yewa. ");
INSERT INTO zia_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Pirisa baina mene nunae-una towang atu dopero Yesu eno eyero sena, “Ning nono yero ge nina sineya auna abena oko sao ge aung mitesi?” ");
INSERT INTO zia_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ayero sena ara, arata Yesu mene ge auna abena oko sao teba dopero mitina ara. Ayero yenu pirisa baina mene nupema atata yero sena, “Ning Yuda emo baunona Emo Tuwa yazo Kristo Tuwa Bayaura Mani meta aung i?” ");
INSERT INTO zia_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ayero senu Yesu mene eyero sena, “Na Kristo. Niye na Emora Mani awiya Tuwa Bayau Putoungne auna wawong mera atu adungno mitana garineya. Na uritira berezere dema butunana garineya.” ");
INSERT INTO zia_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ayero senu pirisa baina mene Yesu nung Tuwa Bayaura yazo dena-betena yenu siya sero taung wori nuka nuna ininu kerenu eyero sena, “Name noeno emo ena buro nung gera pugaese sari nenine? Nung nutope kara gera pugaiya. ");
INSERT INTO zia_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Niye ge meko nuna nigiro no sarinei?” Ayero senu awong sewa, “Pasena nuna meko, arare daya magayaise.” ");
INSERT INTO zia_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ayero sewa ena mene begura pise nuna-una tame gairo diti moko nuna worero wawong mene dero aune eyero sewa, “Emo awe mene ning detiye, auna yazo nuna keregai ganene.” Ayero sewa nung bunero puro mitiwa amimene nung sowena yanakana dewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petoro mene wese kakame atu adungno mitinu pirisa bainana soumani baunodi zo mene buro Petoro iyao ainasani mitinu ");
INSERT INTO zia_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","giro nung anuwing nasani eyero sena, “Ning dema Yesu Nasaretera emo aune dema nosa.” ");
INSERT INTO zia_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ayero senu nung eyero sena, “Na oko gao. Ning ge sinesa awiya na oko gosinena.” Ayero sero nung goma bera baungnu kokora zo mene ge sena ara. ");
INSERT INTO zia_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Petoro atu baungnu soumani baunodi deka amimene nung giro emo atu mitiwa aeno nupema sena, “Emo ewiya dubu nuna auna zo.” ");
INSERT INTO zia_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ayero senu Petoro mene nupema bewae yero “Aung arauwa,” ayero sena ara. Be maingkoka aung yenu aune emo atu mitiwa amimene Petoro eno eyero sewa, “Ge me sinenane ara. Ning dubu nuna auna zo arauwa. Noeno okowata, ning dema ning Galilaya emo zo.” ");
INSERT INTO zia_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ayero sewa nung nupema Tuwa Bayaura benaungna ge eyero senu tau yena, “Na ge iwarinena, awiya Tuwa Bayau mene na dai magayarinena. Niye emo yazo sineya awiya na oko gosinena.” ");
INSERT INTO zia_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ayero senu kokora mena ge be etobe sena ara. Kokora ge senu Petoro mene Yesura ge kotuna. Yesu mene gitau Petoro eno eyero sena, “Nine kokora ge be etobe oko saore na bewae yasa be etama yariniya.” Yesu mene gitau ayero sena, awiya nuka nutope kotungno zi baina sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Iya gati nenu pirisa babuze aune simaire sao tauyao ge gipao emo ena aune gitau yao dubu apakana awong amimene augairo ge teng sero Yesura wawong etobe bunero puro Pilatora-una bamuwa. ");
INSERT INTO zia_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Puro bamuwa Pilato mene nung atata yero eyero sena, “Ning Yuda emora emo tuwa i?” Ayero senu Yesu mene abena eyero sena, “Yore, sinesa ara.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Awong Yesura ge buro newa pirisa babuze mene ge iwi nasani Yesu nung tani meko witao yero nasani nauna ayero sewa. ");
INSERT INTO zia_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ayero sewa Pilato mene nung nupema atata yero sena, “Ning ge abena saine yao teng oko i? Awong tani meko nina auna susuwa witao keregatineya, gosinesa.” ");
INSERT INTO zia_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ayero sena, arata Yesu mene ge zo oko sao yenu giro Pilato mene kotungno wawong di gauna ara. ");
INSERT INTO zia_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Dawang sero bonene yaora be kasa naunu Yuda emo mene bunao mani zo eno sinauwa giro Pilato mene mani awiya besinauna. ");
INSERT INTO zia_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Arare emo zo yazo nuna Barabas amimene emo enane dema bunao gare mitina ara. Awong gavman dari sero winade yero emo ena dewa magayewa, arare awong bunao gare mitiwa. ");
INSERT INTO zia_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Arare emo dubu bainane mene Pilatora-una kasa yero eyero sewa, “Ning dawang sero tani zo nae eno yero nosa awiya nupema ye.” ");
INSERT INTO zia_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ayero sewa nung eyero sena, “Na Yuda emora emo tuwa besero niye eno puganese kotupuneita?” ");
INSERT INTO zia_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato mene pirisa babuze awong tini kapaore Yesu teba puro baungno nuna-una pugaiwa awiya kotungno aune ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Arata pirisa babuze mene emo dubu baina aeno eyero sewa, “Nung Yesu okowata, Barabas maze besaise sepu.” Emo dubu baina amimene ayero saese sewa tau yenu giro ge dekaongka awiya sewa ara. ");
INSERT INTO zia_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ayero sewa Pilato mene nigiro awong eno nupema eyero sena, “Ayero saya aune emo nika ninae nung maze Yuda emora emo tuwa asinowa, nung awiya puro nono yanese sinei?” ");
INSERT INTO zia_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ayero senu awong wawa sero nung eno eyero sewa, “I pasaora magayaise.” ");
INSERT INTO zia_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ayero sewa Pilato mene abena awong eno eyero sena, “Noeno ayero sinei? Nung pasena no yeni?” Ayero sena, arata awong be kerero wawa sero nupema eyero sewa, “I pasaora magayaise.” ");
INSERT INTO zia_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ayero sewa giro Pilato mene emo bauno dubo iwaing yaise sero senu gorobo emo mene Barabas besewa kasa yenu awong Yesu angsi wo aingso mene yao amimene wezewa ara. Wezi nete duwa aune Pilato mene Yesu i pasaora daya magayaise sero gorobo emora-una waweng pugaina arauwa. ");
INSERT INTO zia_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Romana emo tuwara gorobo emo ena mene Yesu puro Romana emo tuwara gare witiro sewa gorobo emo apakana nuna-una augaiwa. ");
INSERT INTO zia_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Augairo taung wori yuyao ine nung eno wosogairo angsi dungne puro ewero aune ziyo nuna-una atu wosogaiwa ara. ");
INSERT INTO zia_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ayero yero nung izinasani emo tuwa arugaine nasani eyero sewa, “Wari iwaing, Yuda emora emo tuwa.” ");
INSERT INTO zia_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ayero sero ziyo nuna waung mene dedunasani begura nuna tame pisinasani koing gairo nung bowi yaora etotoma yewa ara. ");
INSERT INTO zia_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Awong nung izinete taung wori yuyao ine awiya dutugairo doro taung wori nuna nupema wosogaiwa punu i pasaora dari sero puro bamuwa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Emo zo yazo nuna Simon, tawing nuna Sairini, nung Alesandato Rufasra maung, nung towang zora atu buro Yerusalem babari sero butunenu awong nung taungno ge tauyao nung eno eyero sewa, “Ning emo euna i pasao ewiya diung.” ");
INSERT INTO zia_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ayero sero awong Yesu puro baung tawing yazo Goligata auna yewa ara. Tawing auna yazo awiya susuwa nuna eyao era, “Gitau atora wetu.” ");
INSERT INTO zia_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Awong ou wain puro dubo dau yaora ou zo yazo mira aune dema dawero nung eno pugaiwa, arata nung oko minao yangduna. ");
INSERT INTO zia_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Awong nung i pasaora atu niri mene dewa. Dero aune mo nuna bono yari sero awemene mo zo pariniye, asero getuwao zo yazo nuna laki awiya yero mo nuna bono yewa ara. ");
INSERT INTO zia_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Awong nung dewa awiya wari diti 9 kilok nenu aune nung i pasaora atu dewa ara. ");
INSERT INTO zia_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ayero ziyo gomina ika atu susuwa noeno nung dewi auna ge eyero gaero pugaiwa mitina, “Yuda emora emo tuwa.” ");
INSERT INTO zia_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Be aune awong ugaing yao mani etobe dema i pasao nunato-una dero Yesura-una zo enaba zo enaba yero pugaiwa dopewato ara. ");
INSERT INTO zia_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ayero yewa Tuwa Bayaura ge gitau gaewa awiya me yena. Ge awiya eyero mitiya era, Awong nung gigiwa pasena emo ine yenu giro nung pasena emore dema pugaiwa ara. Ge awiya gitau gaewa amimene me yena. ");
INSERT INTO zia_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Emo bauno mene puma-sauma nasani nung izero nung eno eyero sewa, “Wae, ning emo ibu baina kasero wari be etama gege ibu seka yero aung yari sasa. ");
INSERT INTO zia_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ning nika nitope taung aingso nina gera yaora atu sorero i pasaora atu wosi dopase.” Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Deka ayero pirisa babuzere sao tauyao ge gipao emo enane mene Yesu izinasani wina-se yewa, “Nung gitau emo ena soreuno kora yero nauna, arata nung nuka nutope soremao ine teng oko. ");
INSERT INTO zia_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kristo nung Isreli emora emo tuwa naname noiya amimene yeme i pasora atu wosaise. Wosai giro, ‘Me sena,’ asarinenane.” Ayero wina-se yewa ara. Emo etobe i pasaora mitiwato amimene dema nung izewato arauwa. ");
INSERT INTO zia_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wari diti 12 kilok yenu mume baina kasa yero tawing teng yero mitinu 3 kilok yenu ");
INSERT INTO zia_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","aune Yesu mene be kerero eyero sena, “Eloi, Eloi, lama sabaktani.” Ge auna susuwa eyao era, “Tuwa Bayau nana, Tuwa Bayau nana, ning noeno na dotinesi?” ");
INSERT INTO zia_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ayero senu emo ena nugu mitiwa amimene ge awiya nigiro eyero sewa, “Gipu. Nung Eliya yau siniya.” ");
INSERT INTO zia_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ayero sewa giro mani zo mene sungno baungno witora yabutata zo ou wain dokowang yaora dusero itura diro Yesu mene minaise sero nung eno pugairo eyero sena, “Name nung Eliya mene buro i pasaora atu parinita, awiya garinenane.” ");
INSERT INTO zia_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ayero senu Yesu mene nupema aiyamama sero magayena ara. ");
INSERT INTO zia_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Magayenu ibu bainana mo bainakama kimegao awiya ika atu zayero kerero dao etobe yena ara. ");
INSERT INTO zia_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Gorobo emo 100 auna gitau yao mene Yesu anuwing nasani mitinu Yesu magayenu giro eyero sena, “Emo ewiya nung Tuwa Bayaura mani me.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bauno ena dema mitiwa. Awong ake ina atu dopero anuwing nasani mitiwa ara. Enana yazo nunae Maria napo nuna Madala, aune Maria zo nung Yakoboto Yosera ai, aune bauno zo yazo nuna Salome. ");
INSERT INTO zia_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Gitau Yesu Galilaya tawingna atu nasani nauna be aune bauno amimene nung ago nasani nona nuna sasinasani nauwa ara. Aune bauno witao Yesu aune dema Yerusalem atu buro kasa yewa amimene awong aune dema atu dopero mitiwa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Arimatia napora emo zo yazo nuna Yosefe, nung Yudara gitau yao dubu auna emo zo yazore ara. Nung dema Tuwa Bayau nata tuwa yero nariniya auna be diya nasani nauna. Arare nung amimene ture itinenu be bonene korayaora be kasa yenu awiro gora awiya Sabat iya dang giro nung tauyero Pilatora-una baungno Yesura aingso pumari sena ara. ");
INSERT INTO zia_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yesura aingso pumari senu giro Pilato mene, nung magayetita, asero gorobo emo 100 auna gitau yao yau senu bunu eyero sena, “Yesu magayetita?” Ayero senu gitau yao mene eyero sena, “Nung magayetiya.” ");
INSERT INTO zia_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ayero senu giro Pilato mene Yosefe baungno Yesura aingso pumaise sena. ");
INSERT INTO zia_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Senu Yosefe mene baungno mo neyang yao iwaing zo zuma gaero puro baungno Yesura aingso i pasaora atu batagairo puro mo amimene ewero puro baungno daba-uma wamao auna pugaina. Atu pugairo daba zo dereme yenu baungno daba-umana be awiya gazena ara. ");
INSERT INTO zia_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ayero yenu Maria etobe, zo napo nuna Madala, zo nung Yosera ai, amimene daba-umana atu aingso nuna pugaiwa awiya gigiwato arauwa. ");
INSERT INTO zia_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat iya dang be aung yenu Maria napo nuna Madala auneto Maria nung Yakobora ai, awongto aune bauno Salome amimene baungno ou sereyao Yesura aingso tame yasagari sero zuma gaero pumuwa ara. ");
INSERT INTO zia_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Arare wikira be namba wan yazo nuna Sande awiya kasa yenu iya gainu awong iya oko gao biriti be nuna-una bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Awong bautunasani nuka nuyetope eyero wina-se yewa, “Awe mene daba zo uma be gazao awiya name eno dereme yero enaba pugariniye?” ");
INSERT INTO zia_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ayero sewa, noeno okowata, daba awiya bainakama. Ayero sero diti gitau yero daba baina awiya uma be doro enaba atu mitina awiya gigiwa. ");
INSERT INTO zia_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Giro daba-umana toiro mani taung seka zo wawong mera atu adungno mitina awiya gigiwa. Mani auna mo neyang yao awiya imoko-kaungkaung. Bauno mene nung giro yangka sewa. ");
INSERT INTO zia_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ayero yewa mani amimene awong eno eyero sena, “Niye awang yao dopu. Niye Yesu Nasaretera emo deteya magatiya awiya gari sero butuneya. Nung iropumiya. Nung etu oko mitiya. Masi aingso nuna pugeya awiya era gipu. ");
INSERT INTO zia_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ayero niye baungpu, buro-mani nuna ena eno sinasani Petoro eno dema eyero sepu nigae, ‘Nung Galilaya tawingna gitau bautuniya. Arare niye baungno nung atu garineya ara. Ge deka awiya gitau mena niye eno sena.’ Ayero sepu nigae.” ");
INSERT INTO zia_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ayero senu awong daba-uma doro sungno bamuwa. Noeno okowata, te wawongne awena ipinenu awong awang yewa. Arare awong awang nasani ge awiya emo zo eno oko sao yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu mene wikira be namba wan yazo Sande aune gora-gara iropuro nuka nutope gitau Maria napo Madala auna-una kasa yenu gigina ara. Gitau Yesu mene iwae 7 Mariara-una atu tunena. ");
INSERT INTO zia_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Bauno amimene baungno Yesura dubu zi sinasani zibe nasani mitiwa aeno eyero sena, “Na nung gigena.” ");
INSERT INTO zia_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ayero senu awong bauno mene Yesu seka yero iropunu gigina auna ge sena awiya nigiwa me oko yena. ");
INSERT INTO zia_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ago Yesu mene benaung ewe yero emo etobe nagibe atu bautunewato towang atu nuka nutope nunato-una kasa yenu gigiwato. ");
INSERT INTO zia_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nung awongto aune dema nenu nung gigiwato kasa yenu giro awongto nupema tera kapete Yerusalem gairo baungno Yesura dubu ena eno sewato, arata awong ge nunato nigiwa me oko yao yena. ");
INSERT INTO zia_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ago nung buro-mani nuna 11 amimene nona mininasani mitiwa aune nuka nutope nunae-una atu kasa yenu gigiwa. Emo bauno ena mene Yesu iropunu gigiwa auna ge sewa nigiwa me oko yao yena aeno nung awong gona yena. ");
INSERT INTO zia_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nung awong eno eyero sena, “Niye tere-taira yero tawing sero baungno Bowi Iwaing emo bauno apakana eno sepu nigae. ");
INSERT INTO zia_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Zo nung Bowi Iwaing nigiro na tumo diro ge ou suwariniya, nung awiya Tuwa Bayau mene sorero pumariniya. Arata zo nung Bowi Iwaing nana nigiro na tumo oko diyao yariniya, nung awiya Tuwa Bayau mene gera pugai zuwariniya ara. ");
INSERT INTO zia_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Emo na tumo diyarineya amimene tani putoungne eyao ine yarineya: Awong iwae be nana-una tunarineya; awong ge ewe-pape gitau oko nigao awiya sarineya; ");
INSERT INTO zia_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","awong yi mani gamao awiya iniro oko meko yarineya; awong ou meko miniro magayao awiya minarineya, arata awong yaya oko tamarineya; awong wawong nunae emo bauno yayare auna tame pugaya iwaing yarineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tuwa Yesu mene buro-mani nuna eno ge senu aung yenu Tuwa Bayau mene nung puro witiro pu uritira gainu nung Tuwa Bayaura wawong mera aduna ara. ");
INSERT INTO zia_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ayero yenu awong tere-taira yero Bowi Iwaing soma apakana auna atu sinauwa. Ayero yero yewa Tuwa mene ge nunae soremai tau yaise sero awong sorepu naunu tani putoungne yero nasani nauwa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","O emo baina Teofilo, gitau emo daigairo mene tani ena nanae-una towang atu kasa yena auna ungwe awiya gaero baingtari sero yewa. ");
INSERT INTO zia_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ungwe awiya emo ena awong tani awiya diti moko nunae mene zayaora atu giro butu nasani nauwa amimene Bowi Iwaingna buro-mani yero nasani tugata yero nauwa nigiti nasani naungwane ara. ");
INSERT INTO zia_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Arare nane ungwe gaewa deka ayao ine maze ning eno gaero baingtari kotupunena. Noeno okowata, na tani auna susuwa nigiro baingtari sero atata daigairo yero nawe tamuwang. ");
INSERT INTO zia_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Arare ge ning eno gipewa auna ge me susuware awiya gasa memoko yaise sero ungwe awiya gayari sero nena. ");
INSERT INTO zia_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Be Herode mene Yuda emora emo tuwa yero nasani nauna be aune pirisa zo yazo nuna Zekaraya amimene nasani nauna. Nung awiya pirisa dubu yazo Abaisa auna zo. Bauno nuna awiya Aronna dubu auna zo. Yazo nuna Elisabet. ");
INSERT INTO zia_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Awongto Tuwa Bayaura ditira atu iwaing nasani nauwato ara. Awongto Tuwara sao tauyao ge awiya teng ago nasani nauwato ara. Anasani Tuwa Bayaura ge teng dipunasani nauwato ara. Nunato-una mouyao zo aung. ");
INSERT INTO zia_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Arata awongto mani aung. Noeno okowata, Elisabet nung wagaung. Nupema awongto zai yewato. ");
INSERT INTO zia_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Zekarayara dubu awong buro yaora be nunae kasa yenu giro Zekaraya nung Tuwa Bayaura benaungna pirisa buro nenu ");
INSERT INTO zia_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","awong nung zawing sereyao pugao auna buro yaise sewa ibu moko iwaing pirisa mene Tuwa Bayau eno zawing pugati nauwa auna toina ara. ");
INSERT INTO zia_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Be zawing pugaora bera atu emo bauno dubu baina amimene masi daung auna atu augairo isa sinasani mitiwa. ");
INSERT INTO zia_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ayero newa aune Zekaraya nung Tuwa Bayaura angelo zo zawing pugaora aita auna deung wawong mera ina atu dopero mitinu gigina ara. ");
INSERT INTO zia_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nung angelo giro yangka sero awang yena ara. ");
INSERT INTO zia_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Arata angelo mene nung eno eyero sena, “Zekaraya, ning awang oko yase. Tuwa Bayau mene isa nina nigitinoiya. Bauno nina Elisabet mani nina emodi pumai ning yazo nuna Yohane ayause. ");
INSERT INTO zia_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ayero ning dubo nina iwaing mitai yawa yawa yase. Nung kasa yai emo bauno daigairo amimene dema yawa yawa yarineya. ");
INSERT INTO zia_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nung awiya Tuwara benaungna atu emo baina yariniya. Arata nung ou wain oko minariniya. Aune ou tau-tataware yao dema oko minariniya. Be nung aira tiyangna mitai aune Oweno mene moko nuna topetiro bebariniya. ");
INSERT INTO zia_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nung Isreli emo bauno daigairo yumai kapetegairo baung Tuwa nunae Tuwa Bayaura-una yero narineya. ");
INSERT INTO zia_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nung Eliya ine yero tani nuna aune putoung nuna awiya puro nariniya. Ayero Tuwara nagibo gitau yariniya. Nung mamonona kotumao inai darawa yero mani mamani nunae kotumarineya. Nung ge dao emo awiya kora yai kotumao iwaing tamarineya. Ayero emo kora yai Tuwa bariniya awiya diya mitarineya.” ");
INSERT INTO zia_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Angelo ayero senu Zekaraya mene angelo eno eyero sena, “Na nono yero ge awiya nigiro me sarineni? Na mena zai tena. Bauno nana deka ayero zai tiyare.” ");
INSERT INTO zia_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ayero senu angelo mene ge abena kapetegairo eyero sena, “Na Gebriel. Na Tuwa Bayaura benaungna dodopinona amimene Tuwa Bayau mene na ge iwaing ewiya ning eno sanese sesi giro buro sinena. ");
INSERT INTO zia_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Arare sana nigi. Ning ge nana nigesa me oko yao niya, aeno ewawa nina tauyaise. Ayero yai ning ge sao titiyero nasa ge nana euna me kasa yai aune ge nupema sarinesa.” Angelo mene ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Emo bauno awong Zekaraya diya yewa mena oko kasa yao yenu giro kotumao gayang-gayang pupunasani eyero sewa, “No kasa yeti nung ibu moko dang auna atu nimoi-namoi mitiye?” ");
INSERT INTO zia_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ago nung kasa daung yero aune awong eno ge saine yao teng oko yena ara. Ayenu awong nung moko dang auna atu nona putoungne zo tauna awiya gigiwa kasa yena ara. Nung ge awong eno sao awiya wawong mene gege etotoma yena ara. Noeno oko ewawa nuna tauyaore. ");
INSERT INTO zia_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ago Zekaraya nung buro nuna aung yenu doro napo nuna-una baungna. ");
INSERT INTO zia_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ayenu ago bauno nuna Elisabet nung mesa yena ara. Mesa yero ino wawong zo awiya nung pungyero mitauna ara. Nung eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Tuwa mene na yo-auno giro na eno eyero yetiya ara. Awiya na wagaung nona aeno meng gao nana ewiya emo baunona benaungna atu disanese sero yetiya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet nung mesa yenu ino 6 aung yenu aune Tuwa Bayau mene senu angelo Gebriel mene napo baina zo Galilaya tawingna mitauna yazo nuna Nasarete auna baungna. ");
INSERT INTO zia_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Napo auna mani baunodi zo yazo nuna Maria, nung emo zo yazo nuna Yosefe, nung Dawidira saisibuna auna zo, awiya ataise sero gerewa nasani nauna. ");
INSERT INTO zia_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Arare Gebriel mene nuna-una baungno eyero sena, “Ture iwaing. Tuwa Bayau ning gosinoi iwaing yero noiya. Tuwa mene ning aune dema mitoiya.” ");
INSERT INTO zia_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ayero senu Maria nung ge awiya nigiro kotumao nuna mou-mesa yena ara. Dubo nuna mene kotungno, “ge nomaze siniye?” asena ara. ");
INSERT INTO zia_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ayero yenu angelo mene nung eno eyero sena, “Maria, ning oko awang yase. Tuwa Bayau mene ning gigi iwaing niya. ");
INSERT INTO zia_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Sana nigi. Ning mesa yero mani emodi zo puro yazo nuna Yesu yau sarinesa. ");
INSERT INTO zia_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nung emo baina yero nariniya. Nung Tuwa Bayau ika mitoiya auna Mani memoko asarineya ara. Tuwa Bayau mene nung emo tuwa pugai ewowo nuna Dawidi ine yero mitariniya. ");
INSERT INTO zia_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nung amimene Yakobora saisibuna auna emo tuwa yero be giti mitao gege mitariniya. Emo tuwa yero naora buro nuna awiya oko aung yariniya.” ");
INSERT INTO zia_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Angelo ayero senu Maria mene angelo eno eyero sena, “Tani ayao awiya nono yero kasa yariniye? Na emo zo oko ataoware.” ");
INSERT INTO zia_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ayero senu angelo mene ge nuna abena kapetegairo eyero sena, “Oweno mene nina-una kasa yariniya. Ayero Tuwa Bayau ika mitoiya auna putoung nuna mene ning worariniya. Aeno mani pumarinesa awiya awong nung eno eyero sarineya, ‘Nung dang. Nung Tuwa Bayaura Mani.’ ");
INSERT INTO zia_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Sana nigi. Ai nina maingkoka Elisabet nung zai, arata nung mesa yero niya. Mani emodi otira mitiya. Gitau awong nung eno eyero sinauwa, ‘Nung mani pao ine teng oko.’ Arata yeme nung mesa yeti ino 6 aung yetiya. ");
INSERT INTO zia_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nona zo nomaze Tuwa Bayau mene yao ine teng oko awiya oko mitiya.” ");
INSERT INTO zia_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ayero senu Maria mene eyero sena, “Na Tuwara buro bauno, arare sinesa ayero yaise.” Ayero senu angelo doro baungna arauwa. ");
INSERT INTO zia_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Be aune Maria nuka nutope iropuro wongto-wongto yero Yudaya tawingna baungno napo zo diri atu mitauna auna baungna. ");
INSERT INTO zia_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Atu baungno Zekarayara garo mokora toiro Elisabet arugaina. ");
INSERT INTO zia_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ayero yenu Elisabet nung Mariara arugao nigitinenu Elisabetra mani otira mitina awiya wurugu-warugu yena. Ayero yenu Oweno mene Elisabetra moko be buna ara. ");
INSERT INTO zia_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ayenu nung yau sinasani eyero sena, “Ning gao bainane. Gao nina mene bauno enana gao daigatiniya. Mani nina-una otira mitiya a deka dema gaore ara. ");
INSERT INTO zia_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Naka iwaing ungta ning Tuwa nana-una ai amimene nana-una butunesi? ");
INSERT INTO zia_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Dawong nana mene arugao nina nigitinena aune nana-una otira mani mitiya amimene yawa yawa yero wurugu-warugu yetiya. ");
INSERT INTO zia_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tuwa mene ning eno sena auna me awiya ago kasa yariniya asinosa, arare ning yawa yawa yero nasani nosa.” Elisabet mene ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria nung eyero sena, “Na moko nana mene Tuwara yazo puro wiwitinona. ");
INSERT INTO zia_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ititi nana yawa yawa Tuwa Bayau Sorao Emo nana eno niya. ");
INSERT INTO zia_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Noeno okowata, nung na buro baunodi nuna wosao ewiya kotungna. Arare yemeta ago awiya emo bauno apakana amimene na eno eyero sarineya, ‘Tuwa Bayau mene bauno awiya gao yenu yawa yawa baina yena.’ ");
INSERT INTO zia_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Gaya ayao yariniya, noeno okowata, Tuwa Bayau putoung bainane mene na eno nona baina yena. Yazo nuna dang mitoiya amimene yena. ");
INSERT INTO zia_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ara tamao nuna awiya emo nuna wosao miteya auna-una mitoiya. Deka ayero saisibunana-una atu wisika sero babao gege bautunasani mitariniya. ");
INSERT INTO zia_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nung wawong nuna mene buro tau-tataware yao yariniya. Taung puro witao emo kotumao nunae paso didinowa, awong awiya tunai tere-taira yero zanarineya. ");
INSERT INTO zia_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tuwa Bayau mene emo tuwa tau-tataware yao auna putoung nunae puro wowosi nasani emo wosao awiya puro witariniya. ");
INSERT INTO zia_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nung emo bogamasa eno nona iwawaing pugariniya. Ayero emo wau-moni witaore awong tunai wawong usa yero tebeba babarineya. ");
INSERT INTO zia_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nung soremao nuna mitoiya auna gege buro-mani nuna Isreli dubu sorepu nasani nariniya. ");
INSERT INTO zia_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ayero nasani nung ewowo nanae eno sena awiya teng yariniya. Awiya Abraham aune saisibuna nuna eno sena ara.” ");
INSERT INTO zia_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria mene Elisabet aune mitete dunu ino etama aung yenu aune nung doro napo nuna-una baungna arauwa. ");
INSERT INTO zia_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mani pumaora be bunu Elisabet mene mani emodi puna. ");
INSERT INTO zia_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Napo dema nuna arita didikaing nuna bowi nigiwa Tuwa mene nung soreunu giro awong teng deka ayero nung aune dema yawa yawa yewa. ");
INSERT INTO zia_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nung mani punu wari be 8 aung yenu aune awong maingna taung aingso kapari augaiwa ara. Anasani aune awong maung nuna Zekarayara yazo yau sari sewa, ");
INSERT INTO zia_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","arata maingna ai mene “Aungwa” sero eyero sena, “Name yazo nuna Yohane yau sarinenane.” ");
INSERT INTO zia_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ayero senu awong nung eno eyero sewa, “Imoo mani nina-una yazo ayao zo aung ara.” ");
INSERT INTO zia_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Awong wawong mene etotoma yero maung atata yewa, “Ning yazo awe maze yau sari kotupunesi?” ");
INSERT INTO zia_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ayero sewa nung tape zo puro bumaese yenu giro puro bumuwa eyero gaena, “Yazo nuna Yohane.” Ayero gaenu awong kotumao daigairo pumuwa ara. ");
INSERT INTO zia_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ayero newa be aune ewawa nuna tauyena mitauna amimene nupema ge sena ara. Nung ge sinasani Tuwa Bayau bowi yena. ");
INSERT INTO zia_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ayenu napo dema nuna awong apakana awang yewa. Arare maingna bowi mene Yudaya tawingna diri auna napo sero sero baungno aung yena ara. ");
INSERT INTO zia_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Emo bauno daigairo amimene bowi awiya nigiro pu dube gaiwa ara. Ayero aune eyero sewa, “Ago mani amimene nono yero nariniye?” Awong gigiwa Tuwara putoung nung aune dema mitina arauwa. ");
INSERT INTO zia_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Oweno mene maung nuna Zekarayara-una atu bebunu nung porofete mene saine nasani eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Name Isrelira Tuwa Bayau auna yazo nuna puro witanene. Nung buro name emo bauno nuna soreuno zuma gayariniya. ");
INSERT INTO zia_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Buro-mani nuna Dawidi auna dubura atu Sorao Emo tau-tataware yao zo naname-una towang pugatiniya. ");
INSERT INTO zia_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nung ayero yari sero gitau otu porofete pewa yetugao nuna eno senu awong be nunae mene keregaiwa. ");
INSERT INTO zia_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nung eyero yari sero keregaina: Nung name iwora waweng atu sorero pumariniya. Anasani nung name emo kotumao memeko name eno pupunowa auna waweng atu dema sorero pumariniya ara. ");
INSERT INTO zia_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nung ewowo naname soremari sena. Nung tairo naora ge sena awiya kotupunasani giro ayero yari sena. ");
INSERT INTO zia_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tairo nao ge awiya ewowo naname Abraham eno sena. Arare nung tairo naora ge sinasani eyero yari sena: ");
INSERT INTO zia_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Nung name iwora waweng atu sorariniya. Ayero yai name be narinenane auna teng awang yao aung nuna benaungna atu nasani be giti nao iwaing nasani tani pewa yero nao aune tani iwaing gege nasani aune nung sou nasani narinenane. ");
INSERT INTO zia_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Orata mani nana, nine zo emo mene ning eno Tuwa Bayau ika mitoiya auna porofete asariniya. Ning awiya Tuwara nagibo kora yari sero gitau yarinesa. ");
INSERT INTO zia_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nine emo bauno nuna tugata yasa awong eyero garineya: Nung pasena nunae disero awong sorero pumariniya. ");
INSERT INTO zia_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Awiya Tuwa Bayau naname mene mono pumao nuna-una teng ayero yariniya. Nung emo zo uritira wari ine awiya pugai naname-una bumariniya. ");
INSERT INTO zia_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nung buro emo bauno awong magayao awang nasani mumena atu mitima nowa auna atu waegariniya. Nung name dubo iwaingne naora nagibora pugariniya.” Zekaraya mene ayero sero aung yena ara. ");
INSERT INTO zia_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mani Yohane awiya kasa yero bairo bainakama yenu kotumao nuna zawagairo iwaing yena ara. Ayero yenu nung Isreli dubura benaungna kasa yao auna be nuna diya nasani tawing zo emo aung auna atu baungno nasani nauna arauwa. ");
INSERT INTO zia_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Zekarayara aro mene mani Yohane puna be aune Romana emo tuwa Sisa Ogastas nung sao tauyao ge zo pugairo awong emo baunona yazo teng apakana ayero gayaese sena ara. ");
INSERT INTO zia_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Awiya zayero mena yazo gaewa ara. Arare Sairinias nung Siria tawingna emo tuwa yero mitauna be aune yazo gaewa ara. ");
INSERT INTO zia_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Arare be awiya emo bauno apakana ayero awong yazo nunae gayari napo susuwa nunae-una bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosefe nung Dawidira saisibuna auna zo, arare nung Galilaya tawingna napo Nasarete awiya doro baung Yudaya tawingna yero Dawidira napo yazo Betelehem asinauwa auna baungna. ");
INSERT INTO zia_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nung bauno gerao nuna Mariato dema babayato yazo nunato gayaese sero bamuwato ara. Maria nung moure nasani aune baungna ara. ");
INSERT INTO zia_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Awongto napo auna atu mitiwato Maria mani pumaora be nuna kasa yena. ");
INSERT INTO zia_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Arata garo esewara awiya emo bauno mene puro aung yero mitiwa. Arare nung mani nuna emodi muwo mani awiya puro mo mene dowero pu bulimakao tepara gainu mitina. ");
INSERT INTO zia_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Napo auna bautara atu emo ena wo sipsip nunae pingne diya newa, ");
INSERT INTO zia_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tuwara angelo zo mene nunae-una kasa yenu Tuwara waegao baina amimene nunae una atu waegainu awong giro awang yewa ara. ");
INSERT INTO zia_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Arata angelo mene awong eno eyero sena, “Niye awang oko yae. Sana nigipu. Na Bowi Iwaing puro ninae-ina butunena. Bowi awiya emo bauno apakana amimene nigiro yawa yawa bainakama yarineya. ");
INSERT INTO zia_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Be eune Dawidira nape atu bauno zo mani pumiya. Mani amimene niye mekora atu sorero pumariniya. Nung awiya Tuwa ninae Kristo ara. ");
INSERT INTO zia_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Niye nung eyero gaya kasa yariniya: Niye mani zo garineya, awiya mo mene dowao. Nung bulimakao tepara atu apegairo mitiya.” ");
INSERT INTO zia_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Angelo nung ayero sinenu uritira angelo dubu daigairo awong mena kasa yero nung aune dema Tuwa Bayaura yazo de ika nasani eyero sewa, ");
INSERT INTO zia_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Uritira atu Tuwa Bayaura yazo baina yaise. Tawingna atu emo bauno Tuwa Bayau mene gosinoi iwaing yero nowa auna atu mono kasa niya.” Ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Angelo dubu awong doro kapete gairo baung uritira newa wo sipsip diya yao emo awong eyero sewa, “Name Betelehem nape baungno nona kasa yeti Tuwa mene name eno gipetiya awiya ganene.” ");
INSERT INTO zia_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ayero sero awong kapetegairo baungno Mariato Yosefe mitiwato awiya giro mani wuire bulimakao tepara atu apegairo mitinu gigiwa ara. ");
INSERT INTO zia_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Awong mani giro mani wuire auna ge nigiwa awiya keregairo sewa ara. ");
INSERT INTO zia_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ge awiya keregairo sewa emo apakana wo sipsip diya yao emora ge awiya nigiro kotumao daigairo pumuwa ara. ");
INSERT INTO zia_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Arata Maria nung ge apakana awiya dubo nuna-una pugainu mitaunu nung kotupunasani nauna ara. ");
INSERT INTO zia_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Wo diya yao emo awong kapetegairo baungno Tuwa Bayau bowi nasani yazo nuna de ika yewa. Noeno okowata, angelo mene ge senu nigiwa awiya teng maingna-una atu gigiwa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ago wari be 8 ayero aung yenu awong maingna taung aingso kapero yazo nuna Yesu yau sewa. Nung aira tiyangna atu oko kasa yaore angelo mene yazo awiya sena. ");
INSERT INTO zia_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mani aire kora yai pewa yaetose Mose mene sao tauyao ge gaero pugainu mitauna, arare be nuna awiya bunu giro maung aire mene mani awiya Tuwara benaungna pugari sero puro baung Yerusalem yewato ara. ");
INSERT INTO zia_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Awiya Tuwara sao tauyao ge gayao eyero mitiya auna teng yewa: “Mani emodi muwo mani awong aira tiyangna atu kasa yaya giro awong awiya Tuwara gerao ara.” ");
INSERT INTO zia_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nupema Tuwara sao tauyao ge zo eyero mitiya auna teng yewato: “Niye aira zawing pugari sero giro ni uko etota ni gumo sekawa etobe awiya pugaipu.” Ge ayero sao mitauna aeno awongto ge awiya diungno Tuwa eno zawing pugari sero bamuwato ara. ");
INSERT INTO zia_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Be aune emo zo Yerusalem atu mitauna yazo nuna Simion. Nung emo iwaing, aune nung Tuwara ge nigao emo. Nung Isreli emora Korayao Emo awiya kasa yai gari diya mitasani nauna. Arare Oweno mene Simionna mokora atu mitasani nauna. ");
INSERT INTO zia_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Oweno mene nung eno yemaoko eyero sena, “Ning mena oko magayarinesa. Aung ara. Ning mitasa Tuwara Korayao Emo yazo Kristo awiya kasayai giro aune magayarinesa.” ");
INSERT INTO zia_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Arare Oweno mene nung uwenu nung baungno Tuwa Bayaura ibu bainana toiro mitinu ai maungne mene mani Yesu puro bumuwato ara. Awiya awongto tani yaise sao awiya nung eno yari puro bumuwato ara. ");
INSERT INTO zia_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ayewato Simion nung wawong nuna mene mani awiya puro Tuwa Bayau bowi nasani eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Tuwa, ning ge gitau na eno sasa awiya me yetiya, arare sasa na buro-mani nina dubo iwaingne magayane. ");
INSERT INTO zia_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Diti moko nana mene nona nae sorero pumaise yasa awiya gosinena. ");
INSERT INTO zia_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Korayao Emo ewiya kora yasa, awiya emo bauno apakana gaese sero yasa. ");
INSERT INTO zia_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nung awiya waegao ine ara. Arare nung emo Yuda oko aeno nagibo gipariniya. Ayero Isreli dubu auna yazo de ika nariniya.” ");
INSERT INTO zia_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yesura ai maungne awongto Simion mene nung eno ge ayero sena auna kotumao daigairo pumuwato. ");
INSERT INTO zia_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Arare Simion mene awong gao yero maingna ai Maria eno eyero sena, “Sana nigi. Mani ewiya Isreli emo bauno gausaise sao mitiya ara. Arare ena mene nung giro zuwero meko yarineya. Arata ena awiya nung giro tau yero doparineya. Nung awiya Tuwa Bayaura nagibo gipao emo ara. Arare emo witao mene nung eno ge memeko-mameko sarineya. ");
INSERT INTO zia_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ayero yaya kotumao nunae pungyao awiya kasa daung yariniya ara. Nupema dubo minao bainakama nina-una kasa yariniya. Dubo minao awiya iwi mene mani gaitinowa yaya tapunowa ayao ine moko nina-una atu kasa yariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Porofete bauno zo mitasani nauna yazo nuna Ana. Nung Panuelra mani. Nung Ase dubura zo. Nung zai nibamu. Nung gitau emo atiro emo nuna aune dema dawang 7 nawe duwato ");
INSERT INTO zia_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","emo nuna magayenu nung nata mitasani nawe dunu dawang nuna 84 yena. Nung Tuwa Bayaura ibu baina oko duwao nasani nauna. Nung nona minao seminiro isa buro nasani mitasani nauna. Anasani Tuwa Bayaura buro pingne iyare initi nasani nauna ara. ");
INSERT INTO zia_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Be aune nung dema nugu buro Tuwa Bayau eno dange sena. Ayero nung mani auna ge awiya emo Tuwa Bayau mene Yuda emo bauno nupema sorero pumaise sero diya nasani nauwa awong aeno keregairo sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Awong nona apakana Tuwara ge mene yaese sao mitina awiya teng yewa aung yenu aune yesese yero Galilaya tawingna baungno Nasarete napo nunae-una kasa yewa ara. ");
INSERT INTO zia_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Atu mani bairo baina yero mani putoungne yena ara. Nung kotumao iwawaing daigairo kasa yenu Tuwa Bayaura gao nuna-una mitasani nauna arauwa. ");
INSERT INTO zia_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yesura ai maungne awongto dawang sero iya be dang yazo Magayao mene awong Daigaina awiya gari sero Yerusalem nape wiwitinasani nauwato ara. ");
INSERT INTO zia_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Arare Yesura dawang 12 ayero aung yenu giro awong tani awiya ago yero iya be dang aune Yerusalem nape witiwa. ");
INSERT INTO zia_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ago iya be dang aung yenu awong yesese yero bamuwa ara. Arata Yesu nung Yerusalem atu kara mitina. Ai maungne nuna mene nung mitina awiya oko gao. ");
INSERT INTO zia_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Awongto nung emo bauno ena aune dema bautunena sero bautunewato. Arata ture inu awong oregatinewa aune nung tamari sero dubu nunato-unata nupema otao mani enanauna atu tamari sero ");
INSERT INTO zia_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","kau yewato, arata oko tamuwato. Ayero yero giro awongto nung kau yero yesese yero Yerusalem bamuwato ara. ");
INSERT INTO zia_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Awongto nung tamaora buro yewato wari be etama ayero aung yenu aune nung ibu bainana mokora atu mitinu tamuwato ara. Nung gipao emora-una towang atu adungno mitasani ge wina-se yero nigitinasani mitiwa. ");
INSERT INTO zia_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Emo ge nuna awiya nigiwa amimene kotumao nunata wina-se yao nuna nigiro wawong di gamuwa. ");
INSERT INTO zia_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Arare awongto nung giro wawong di gauno baingtiwato ara. Ayero aune ai nuna mene nung eno eyero sena, “Bouwa, ning nono yero nato eno ayero yetesa nato maungne dubo nanato mou-mesa yeti ning tamaora buro nenito?” ");
INSERT INTO zia_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ayero senu nung ai maungne eno eyero sena, “Nito noeno na kaunasani neito? Na Mama nana-una gare atu mitanese sao mitiya, awiya nito oko gosineitota, nowa.” ");
INSERT INTO zia_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ayero senu awongto ge auna susuwa kau yewato ara. ");
INSERT INTO zia_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ayero sero nung awongto aune dema yesese yero baungno Nasarete kasayewa. Ayero atu be giti nung ge nunato dipunasani nauna ara. Arare ai nuna mene ge awiya apakana pu dubo nuna-una gainu mitauna ara. ");
INSERT INTO zia_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu nawe bairo emo baina yenu kotumao nuna iwaing kasa yero baingtina ara. Arare Tuwa Bayau arita emo bauno awong Yesu gigiwa iwaing yero baingtina arauwa. ");
INSERT INTO zia_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Zekarayara mani Yohane nung tawing emo aung auna atu nenu Tuwa Bayau mene ge nung eno sero nung burora pugaina. Awiya emo emimene emo babuze yero nasani nauwa be aune ayero yena ara: Roma emora emo tuwa Taibirias nung emo tuwa yero nenu dawang 15 aung yena, be aune Pontias Pilato nung awiya Yudaya tawingna atu emo bauno diya nasani nauna; Herode nung Galilaya tawingna atu emo bauno diya nasani nauna; aune meta nuna Filip awiya nung tawing etobe yazo nunato Ituriato Trekonaitis auna atu emo bauno diya nasani nauna; Anasito Kayafa awongto pirisa baina yero newato, be aune Tuwa Bayau mene Yohane burora pugaina arauwa. ");
INSERT INTO zia_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ayenu Yohane baungno ou Yodan auna garawira yero atu nasani emo bauno ge tugata nasani nauna. Emo bauno mene uritira ge nigiro dubo darawa yero ge ou suwaya Tuwa Bayau mene pasena nunae disaise ayero sinauna ara. ");
INSERT INTO zia_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Awiya porofete Yesaya mene ge zo gaenu mitoiya auna teng yena, Emo zo eu yanawira atu wawa sero eyero siniya, ‘Tuwara nagibo awiya kora yepu korosae. ");
INSERT INTO zia_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Witio-watio apakana kora yaya bisisae. Diri bibou yao apakana gizaya wosiro bisi bisi sae. Nagibo gegeru yao awiya kora yaya korosae. Nagibo kitiyo-kotiyo mitiya awiya dema kora yaya masa masa sae. ");
INSERT INTO zia_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ayero yaya emo bauno apakana Tuwa Bayaura kora yao buro awiya garineya.’ ");
INSERT INTO zia_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Emo bauno witao mene Yohanena-una kasa yero nung awong ge ou suwaise sewa giro awong eno eyero sena, “Niye yi meko auna mani. Awe mene sesi aune niye Tuwa Bayau abena pugari niya awiya daigari sero taung mene gege ge ou suwari sinei? Nane ayero oko sesena. ");
INSERT INTO zia_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Niye dubo darawa yero aune tani dubo darawa yaora me awiya taungpu. Niye nika niyetope ge eyero oko sae, ‘Abraham nung mama nanae, arare Tuwa Bayaura abena amimene nanae ina oko bariniya.’ Na niye eno sinena era. Tuwa Bayau mene sai daba domito amimene Abrahamna saisibuna ine teng kasa yarineya. Auna putoung nuna-una mitiya. ");
INSERT INTO zia_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tuwara oto yemaoko i susuwara atu daka dao mitiya ara. I me iwaing oko iyao mitaya giro awong yetero au iyaora garineya.” ");
INSERT INTO zia_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nung ayero senu awong nung atata yero sewa, “Arare nae nono yarinenine?” ");
INSERT INTO zia_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ayero sewa nung awong eno ge abena eyero sena, “Emo taung wori etobe puro noiya amimene saineba zo puro emo taung wori aung aeno pugaise. Emo ena mene nona minaora zamena simena tapu nasani giro deka ayero yaese.” ");
INSERT INTO zia_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Emo ena takis pumao emo awong dema ge ou suwaise sero nuna-una buro nung eno eyero sewa, “Gipao emo, nae nono yari nenine?” ");
INSERT INTO zia_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ayero sewa nune awong eno eyero sena, “Niye takis gavman mene pumaese siniya awiya teng pungpu. Arata niye ena oko tebeba pumae.” ");
INSERT INTO zia_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ayero senu gorobo emo ena mene nung atata yero sewa, “Orata nae mene zo nono yari nenine?” Ayero sewa nung awong eno eyero sena, “Niye emo tebe-tabe oko dae. Ayero ge iwi nasani sero emora daba oko sorae. Niye zuma ninae teng pungpu.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Yohane nauna be aune emo daigairo mene “Yuda emora Sorao Emo yazo Kristo amimene bariniya,” ayero kotupunauwa. Arare awong Yohanena susuwa giro dubo eto nasani eyero sewa, “Nung awiya Kristo nanameta aung ing?” ");
INSERT INTO zia_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Asinewa Yohane mene abena awong eno eyero sena, “Na niye eno ge ou suwao gege pugatinena. Arata emo zo ago bariniya auna putoung mene putoung nana daigariniya. Na emo wosao nibamu amimene te soga nuna-una angsi besao ine teng oko niya. Nune mene zo Oweno niye eno pugariniya, nupema iyao niye eno pugariniya. ");
INSERT INTO zia_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nung tapono nuna wawong nuna mene initiniya. Puro buro wuit mozaora masira kasa yero iwe babaise sero tapono nuna mene wuit dungno au bisira gariniya. Iwe babai wuit me awiya yangtagairo pu gare gariniya. Arata iwe zo iyao awao gege awinoiya auna augariniya.” ");
INSERT INTO zia_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohane nung kotumao nunae awiya uwari sero ge gewaoko ena dema sinasani Bowi Iwaing awong eno tugata yero nasani nauna. ");
INSERT INTO zia_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Diya emo nunae Herode nung meta nuna-una bauno Herodia awiya sorero pungna. Awiya gege okowata, nung pasena ena dema nasani nauna, arare Yohane mene nung gona yena. ");
INSERT INTO zia_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Gona yenu giro Herode mene tani meko zo dema susuuno Yohane puro bunero bunao gare pugaina arauwa. ");
INSERT INTO zia_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Emo bauno apakana ayero ge ou suwero mitiwa Yesu dema ge ou suwena. Nung ge ou suwero isa sinasani mitinu uriti gausenu ");
INSERT INTO zia_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Oweno mene ni audubo ine yero wosi nuna-una tame atu daungka yena. Ayero yenu uritira atu ge zo eyero kasa yena, “Ning mani nana. Ning yo dingya nana. Na ning giro yawa yawa nena.” ");
INSERT INTO zia_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu dawang nuna 30 yenu aune buro nuna zayena. Emo bauno awong nung eno eyero sero nauwa, “Nung Yosepera mani.” ");
INSERT INTO zia_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","38","Yosepe nung Hilaira mani, Hilai nung Matatira mani, Matati nung Lewira mani, Lewi nung Melikaira mani, Melikai nung Yanaira mani, Yanai nung Yosepera mani, Yosepe nung Matatayara mani, Matataya nung Amosira mani, Amosi nung Neamna mani, Neam nung Esilira mani, Esili nung Nagaira mani, Nagai nung Meatira mani, Meati nung Matatayara mani, Matataya nung Semenna mani, Semen nung Yosekera mani, Yoseke nung Yodara mani, Yoda nung Zoananna mani, Zoanan nung Resara mani, Resa nung Zerababora mani, Zerababo nung Siatielira mani, Siatieli nung Neraira mani, Nerai nung Melikaira mani, Melikai nung Adira mani, Adi nung Kosamna mani, Kosam nung Elimadamna mani, Elimadam nung Erera mani, Ere nung Yosuara mani, Yosua nung Eliesara mani, Eliesa nung Yorimna mani, Yorim nung Matatira mani, Matati nung Lewira mani, Lewi nung Simionna mani, Simion nung Yudara mani, Yuda nung Yosepera mani, Yosepe nung Yonamna mani, Yonam nung Elayakimna mani, Elayakim nung Meliara mani, Melia nung Menana mani, Mena nung Matatara mani, Matata nung Netanna mani, Netan nung Dawidira mani, Dawidi nung Zesira mani, Zesi nung Obedera mani, Obede nung Boasira mani, Boasi nung Salara mani, Sala nung Nasonna mani, Nason nung Aminadapra mani, Aminadap nung Adaminna mani, Adamin nung Anina mani, Ani nung Hesronna mani, Hesron nung Peresera mani, Perese nung Yudara mani, Yuda nung Yakobora mani, Yakobo nung Isakara mani, Isaka nung Abrahamna mani, Abraham nung Terara mani, Tera nung Nehorira mani, Nehori nung Serakra mani, Serak nung Riyura mani, Riyu nung Pelekra mani, Pelek nung Ibara mani, Iba nung Selara mani, Sela nung Kainanna mani, Kainan nung Apasatra mani, Apasat nung Semna mani, Sem nung Noara mani, Noa nung Lemekra mani, Lemek nung Metusalara mani, Metusala nung Inokra mani, Inok nung Yeretra mani, Yeret nung Mahalalilira mani, Mahalalili nung Kainanna mani, Kainan nung Inosira mani, Inosi nung Setira mani, Seti nung Adamna mani, Adam nung Tuwa Bayaura mani. ");
INSERT INTO zia_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Oweno mene Yesura moko be bunu Yesu nung ou Yodan doro kapete gairo baungna. Oweno mene nung puro tawing emo aung auna baungna. ");
INSERT INTO zia_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ayero yenu nung iya mume 40 atu naunu Sanda mene nung etegari yena. Be aune Yesu nona oko minao nauna. Ago iya mume 40 aung yenu aune Yesu meri magayena ara. ");
INSERT INTO zia_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Anenu Sanda mene nung eno eyero sena, “Ning Tuwa Bayaura mani me yai giro se daba amimene ma yai minase.” ");
INSERT INTO zia_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ayero senu Yesu mene ge abena eyero sena, “Ge gayao zo eyero mitiya era, ‘Ma mene gege emora nao oko diya yero noiya.’” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Asenu Sanda nupema nung puro witiro baung ika yero aune nona tawing sero sero miteya awiya Yesu eno mena gipena. ");
INSERT INTO zia_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Gipero nung eno eyero sena, “Na putoung ewiya apakana ning eno pugarinena. O tawing sero sero auna wazawa dema ning eno pugarinena. Nona apakana awiya nana gege yena. Arare na mani zo eno pugari sero giro kara pugarinena. ");
INSERT INTO zia_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Aeno ning na eno boma gaero na bowi yasa giro aune na nona apakana ning eno pugarinena.” ");
INSERT INTO zia_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ayero senu Yesu mene ge abena eyero sena, “Ge gayao zo eyero mitiya, ‘Ning Tuwa nina Tuwa Bayau awiya bowi yase. Nung dekaongka awiya gege sou yarinesa.’” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Asenu Sanda mene nupema Yesu puro Yerusalem nape baungno Tuwa Bayaura ibu bainana ika tame atu pugaina. Pugairo nung eno eyero sena, “Ning Tuwa Bayaura mani me yai giro etu sasero wosi. Ning eza oko yarinesa. ");
INSERT INTO zia_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Noeno okowata, ge gayao zo eyero mitiya era, ‘Tuwa Bayau mene sai angelo dubu nuna mene ning diya yarineya. ");
INSERT INTO zia_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ayero yaya te nina daba mene gayoiye sero, awong ning wawong mene soga nasani puro wosarineya.’” ");
INSERT INTO zia_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ayero senu Yesu mene abena eyero sena, “Ge gayao zo deka eyero mitiya era, ‘Ning Tuwa nina Tuwa Bayau awiya oko gaero gari yase.’” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Arare Sanda nung etegao apakana yenu aung yenu giro nung Yesu doro be zo ayao awiya diya yena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu nung Owenona putoung nuna-una mitina, arare nung nupema tera kapetegairo Galilaya tawingna baungna. Baungnu bowi nuna mene tawing auna baungno teng yena. ");
INSERT INTO zia_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nung atu emo bauno yere ibu nunae-una atu gipinasani naunu daigairo mene yazo nuna de ika gatinasani nauwa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu mene Nasarete baungna. Gitau nung mani maingkore nung napo auna atu baina. Nung Sabat be sero yere ibura mokora toitinasani nauna, arare Sabat be zore toina. Toiro Tuwa Bayaura ge zazagari sero benaung nunae-una dopena. ");
INSERT INTO zia_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ayenu awong porofete Yesayara buku zo nung eno pugaiwa nung puro apero ge gayao eyero mitiya awiya taungno keregairo zazagaina, ");
INSERT INTO zia_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Tuwara Oweno nana-una mitiya. Awiya na ago bogamasa eno bowi iwaing sanese sero nung na burora pugatinasani Oweno na eno pugaina. Na eyero tugata yanese iyengtinu bumuwang ara: Niye bunao emo, na niye besana bunao doro babarineya. Niye emo diti guma yao, na niye korayana nupema diti pagarineya. Emo sou buro memekora nasani nauwa sou yao buro mene awong bunena auna bunao besana doro babaese, o ");
INSERT INTO zia_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tuwa Bayau mene emo kora yariniya auna be pugainu mitoiya awiya kereganese sero na iyengtinu bumuwang ara. ");
INSERT INTO zia_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu mene buku tapu dero yere ibu diya yao emo eno pugairo ge sari sero ge saora masira atu aduna. Ayero yenu emo bauno ibu mokora mitiwa amimene apakana ayero teng diti ye nuna-una gairo mitiwa, ");
INSERT INTO zia_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","nung zayero awong eno eyero sena, “Ge zazagena nigeya auna me yeme kasaniya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Arare awong yazo nuna puro de ika gatinasani kotumao daigairo kotumuwa. Noeno okowata, nuna-una bera atu ge iwaing kawaing kasa yena. Arata awong nung eno eyero sewa, “Nung Yosefera mani amimene ge ayero siniya.” ");
INSERT INTO zia_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ayero sewa nung awong eno eyero sena, “Niye na eno eyero sarineita, nowa, ‘Dokta, ning nitope taung aingso nina kora ye giro me asanene. Tani ena Kapaneam atu yasa awiya nae nigiwangne. Arare ning yeme deka ayero napo susuwa nina-ina atu ye ganene.’ Niye na eno ayero sarineita, nowa.” ");
INSERT INTO zia_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ayero sero aune eyero sena, “Na meba niye eno sinena. Porofete zo mene napo susuwa nuna-una atu ge sai oko nigarineya. ");
INSERT INTO zia_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ewowo mani ninae mene porofete Eliyara ge oko nigao yewa. Ayewa giro Tuwa Bayau mene senu wa oko wosao wari gege posinaunu dawang etama aune ino 6 ayero aung yena. Be aune dora botiyo bainakama kasa yenu bauno gagamo ibono mamaga yetugao daigairo mene Isreli tawingna atu nasani nona minao kau nasani nauwa. ");
INSERT INTO zia_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Arata Tuwa Bayau nung Eliya senu Isrelira bauno gamo zo yu magayao auna-una oko baungna. Aung ara. Nung nung maze iyengtinu Saidon tawingna baungno napo Sarefat auna gege kasa yena ara. Awiya bauno gamo yu magayao zora-una atu kasa yero bauno awiya nona minaora sorepunasani mitauna. ");
INSERT INTO zia_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nupema deka ayero porofete Elisa eno yewa ara. Nung nasani nauna be aune emo bozo tauyaore daigairo Isreli emora-una atu mitauwa. Arata nung nunae-una zo oko kora yenu iwaing yena. Aung ara. Siria tawingna emo zo yazo Neaman nung awiya gege kora yenu iwaing yena ara.” Yesu mene ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ayero senu emo yere ibu mokora mitiwa awong amimene ge awiya nigiwa tini kapenu ");
INSERT INTO zia_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","awong iropuro Yesu saniro puro napo bautara bamuwa ara. Napo nunae awiya diri zora ika tame atu mitauna, arare awong nung puro baung diri auna deung bera yero nung au kowara gari yewa ara. ");
INSERT INTO zia_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Arata nung nunae-una towang atu ang yero doro baungnu aung yena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nung wosiro Galilaya tawingna napo zo yazo nuna Kapaneam auna baungna. Baungno atu mitasani aune Sabat iya be zo auna atu emo bauno eno ge tugata yena. ");
INSERT INTO zia_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ayero yenu awong ge nuna nigiro wawong di gamuwa. Awiya noeno okowata, ge nuna awiya putoungne. ");
INSERT INTO zia_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Be aune emo zo yere ibu mokora atu mitina awiya iwae mene nuna-una mokora mitauna. Nung amimene be kerero eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ae, Yesu Nasarete napora emo, ning no yari sero nanae-una butunesi? Ning Tuwa Bayaura Mani iwaing pewayao.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Arata Yesu mene nung gona nasani eyero sena, “Ning ge doro emora mokora atu kasa yero bung, babase.” Ayero senu iwae amimene emo awiya augainu emora towang atu zuwe tawingna gaina ara. Arata iwae mene emo awiya oko gera yao yero doro baungna ara. ");
INSERT INTO zia_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ayero yenu emo apakana amimene wawong di gauno nuka nuyetope eyero wina-se yewa, “Emo ewiya nono yao i? Nung iwae eno ge putoungne sinoi iwae mene ge nuna diungno emo doro bautunowi.” Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ayenu Yesura bowi amimene tawing auna napo sero baungna arauwa. ");
INSERT INTO zia_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu nung iropuro yere ibu awiya doro Simonna gare witina. Simonna imeti yaya taung kokoni baina awiya puro mitina, aeno awong Yesu yausero nung kora yaise sewa ara. ");
INSERT INTO zia_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Asewa giro nung baungno nuna-una nugu dopero yaya awiya gona yenu yaya aung yena ara. Aung yenu bauno amimene mena iropuro awong kora yena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ture itinenu Sabat iya be awiya aung yenu emo bauno mene didikaing nunae yaya ewego-papego puro mitiwa awiya puro bung nuna-una yewa ara. Ayero yewa nung emo bauno awiya wawong pu ziye gairo awong apakana kora yenu iwaing yewa ara. ");
INSERT INTO zia_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ayero nenu iwae ena mene emo bauno daigairo awiya doro bautunasani eyero sewa, “Ning Tuwa Bayaura Mani.” Arata nung awong gona yero ge sao awang sena. Awiya noeno okowata, awong nung Yuda emora Sorao Emo yazo Kristo yero nauna awiya gigiwa. ");
INSERT INTO zia_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Gora-gara nung napo awiya doro agewa zo emo aung auna baungna. Ayenu emo bauno mene nung tamari sero nuna-una baungno nung awong doro babao eno awang sewa. ");
INSERT INTO zia_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Arata nung awong eno eyero sena, “Tuwa Bayau nata Tuwa yero nariniya auna Bowi Iwaing awiya na napo enana atu dema nasani sarinena. Tuwa Bayau mene na buro awiya yanese sero iyengtinu bumuwang ara.” ");
INSERT INTO zia_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ayero sero nung Yuda emora yere ibu sero auna atu nasani ge tugata yao buro yero nasani nauna arauwa. ");
INSERT INTO zia_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Be zo Yesu mene ou nazi yazo Genesaret auna bage atu dopero mitinu emo bauno daigairo mene Tuwa Bayaura ge nigari sero nuna-una buro kasa yero wina-mise yewa ara. ");
INSERT INTO zia_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Anewa nung wang etobe ou nazira bage mitiwato gigina ara. Arata emo wo pumao emo awong wang etobe awiya doro moga sayao buro nasani mitiwa. ");
INSERT INTO zia_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Anewa nung wang zora witina, awiya Simonna wangna atu witina ara. Ayero atu nung Simon senu wang isenu bago doro maingkoka baungno dopenu nung wang tame adungno emo bauno eno ge tugata yena ara. ");
INSERT INTO zia_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nung ge sero aung yero aune Simon eno eyero sena, “Name ou kurura babanane aune niye moga augairo wo pumae.” ");
INSERT INTO zia_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ayero senu Simon mene ge abena eyero sena, “Gipao emo, nae ping ewiya wo buro baina teba nenane iya gaiya, arata wo zo oko pumao yetenane. Arata nine sinesa giro sana moga augaya wosariniya.” ");
INSERT INTO zia_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ayero senu awong ayero yewa aune wo daigairo dero tatakasewa moga zanari nete sekawa yena ara. ");
INSERT INTO zia_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ayero yenu giro awong otao mani nunae wang zora mitiwa amimene buro awong soremaese sero asawa yewa. Ayero yewa awong buro wo puro pu wang etora gaiwa bebunu wang eto deka ayero nosari sero yewato ara. ");
INSERT INTO zia_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ayero yenu Simon Petoro nung tani awiya giro Yesura-una tera nugu daung atu boma gaero eyero sena, “O Tuwa, na emo meko, arare ning na doro baung.” ");
INSERT INTO zia_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ayero sena. Noeno okowata, nung aune emo ena nung aune dema mitiwa amimene wo benaung ewego-papego pumuwa awiya giro awang yewa ara. ");
INSERT INTO zia_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zebedira mani emodi etobe Yakoboto Yohane awongto Petoro aune dema wo buro nasani yero nauwato amimene dema giro awang yewato ara. Ayero yewa Yesu mene Petoro eno eyero sena, “Ning awang oko yase. Ning yeme zayero emo bauno pumaora buro nasani narinesa.” ");
INSERT INTO zia_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ayero senu awong wang etobe isewa witiwato nona apakana awiya doro nung ago yero bamuwa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Napo nugu atu emo zo mitauna. Nung bozo tauyao witao mene taung aingso nuna meko yao. Arare Yesu napo auna kasa yero nenu emo amimene Yesu giro nuna-una baungno boma gaero koing gairo eyero sena, “Tuwa, ning putoung nina mitiya, arare ning na kora yari yero giro kora yasa iwaing yarinena.” ");
INSERT INTO zia_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ayero senu Yesu mene wawong pugairo nung ding yero eyero sena, “Yore, na ayero yari kotupunena. Arare bozo nina aung yai ning iwaing pewa yase.” Ayero sinenu bozo tauyao nuna mena aung yewa. ");
INSERT INTO zia_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ayero yenu Yesu mene ge tau-tataware yao nung eno eyero sena, “Tani ning eno yetena auna bowi awiya emo zo eno oko sase. Ning baung, taung aingso nina pirisa eno gipasa gae. Ayero nasani nona Mose mene Tuwa Bayau eno pugaese sena awiya pugasa yaya nina aung yetiya auna susuwa giro baingtarineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ayero senata tani ena yero nasani nauna auna bowi awiya soma sero baungna. Arare emo bauno daigairo mene nuna-una atu ge nigari serota yaya nunae kora yai iwaing yaise sero nuna-una butunauwa. ");
INSERT INTO zia_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ayero nauwa nung be ozaung baung soma emo aung auna yero isa sero nauna arauwa. ");
INSERT INTO zia_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Be zore nung emo bauno ge tugata nasani mitinu aune Farisayo aune sao tauyao ge gipao emo ena awong dema ayero adungno mitiwa ara. Awong awiya Yerusalem napota Galilaya tawingna napo sero sero auna ta Yudaya tawingna napo sero sero auna atu buro mitiwa. Tuwara putoung yaya emo kora yaora awiya Yesura-una mitina. ");
INSERT INTO zia_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Arare emo ena awong emo zo gogara atu pugairo diungno puro bamuwa ara. Emo auna wetu awiya auno turero mapeta ine yao. Awong nung diungno puro garo mokora baungno Yesura-una nugu pugari yewa. ");
INSERT INTO zia_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Arata emo bauno daigairo mene garo gazewa. Ayewa awong emo yayare awiya puro baung garo mokora yaora nagibo kau yewa. Ayero giro nung puro garo ika tame witiro garo eno be yero baero emo gogare dema puro pugaiwa wosina ara. Awiya emo bauno Yesu aune dema mitiwa auna towang wosiro Yesura benaungna kasa yena ara. ");
INSERT INTO zia_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ayenu Yesu mene tumo diyao nunae giro emo aeno eyero sena, “Otao, na pasena nina disetena aung yetiya.” ");
INSERT INTO zia_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ayero senu sao tauyao ge gipao emo aune Farisayo awong nuka nuyetope ge witao sinasani wina-se yewa, “Emo emi Tuwa Bayau mene yaine yero niya. Emo zo mene pasena disao ine teng oko. Awiya Tuwa Bayaura buro gege.” ");
INSERT INTO zia_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu nung kotumao nunae awiya mena yetine yero giro ge nunae abena eyero sena, “Niye noeno ayero kotupunei? ");
INSERT INTO zia_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Name emo yayare aeno, ‘Iropu, ang yase,’ tebeba ayero sanane nung oko ang yao yariniya, awiya name meng garinenane. Noeno okowata, emo bauno mene ge naname gaya ge iwao yariniya. Arata name, ‘Na pasena nina disinena,’ tebeba ayero sarinenane, awiya name meng oko garinenane. Noeno okowata, emo bauno mene ge naname auna me awiya gao ine teng oko. ");
INSERT INTO zia_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Arare na pasena disaora putoung puro tawingna etu nona, awiya gaese sero na ge ewiya dema nung eno sarinena, ‘Na ning eno eyero sinena: Ning iropu, awao masi gogare nina puro nina-ina gare babase.’” ");
INSERT INTO zia_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ayero sinenu nung emo bauno mitiwa auna ditira iropuro awao masi gogare nuna puro Tuwa Bayaura yazo de ika gatinasani baung garo nuna-una yena ara. ");
INSERT INTO zia_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ayero yenu emo apakana amimene giro wawong di gamuwa ara. Ayero yero awong awang yero Tuwa Bayaura yazo de ika gatinasani ge eyero wina-se yewa, “Name tani yeme gosinenane awiya benaung zo seka ara.” Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ago Yesu mene doro ang yero bautunete diti yero takis pumao emo zo, nung takis pumaora gare atu adungno mitina, awiya gigina. Emo yazo nuna Lewi. Arare Yesu mene nung eno eyero sena, “Ning bung, na ago yase.” ");
INSERT INTO zia_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ayero senu nung iropuro nona apakana atu mitina awiya doro Yesu ago yero baungna arauwa. ");
INSERT INTO zia_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lewi mene Yesu nung aune dema nona minaise sero gare atu nona minao kora yena. Ayero yenu takis pumao emo daigairo aune emo ena dema nung aune dema adungno nona mininasani mitiwa. ");
INSERT INTO zia_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Atu mitiwa Farisayo ena aune dubu nunae-una sao tauyao ge gipao emo ena amimene Yesura buro-mani eno ge witao sinasani eyero sewa, “Ae, niye nono yero takis pumao emo aune pasena emo awong aune dema tairo nonane oure mininei?” ");
INSERT INTO zia_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ayero sewa Yesu mene ge nunae abena kapete gairo eyero sena, “Emo yaya aung mene doktara-una oko bautunowa. Arata emo yayare mene gege doktara-una bautunowa. ");
INSERT INTO zia_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Na emo nao nuna pewayao asinoiya awiya yausero pana dubo darawa yaese oko bumuwang. Aung ara. Na pasena emo awiya yausero pana dubo darawa yaese bumuwang ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Arare awong Yesu eno eyero sewa, “Yohanena buro-mani mene be ozaung nona minao seminiro isa sinasani nowa. Nupema Farisayora buro-mani mene deka ayero yero nowa ara. Arata buro-mani nina mene zo nona oko seminao minao gege mininowa.” ");
INSERT INTO zia_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ayero sewa Yesu mene awong eno eyero sena, “Emo bauno ataora sao zuwao nasani mitaya emo bauno atariniya amimene awong aune dema nariniya be aune nona seminaese saya nigarineita? Aung ara. ");
INSERT INTO zia_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Arata ago emo awiya iwo mene puro babaya aung yariniya be aune awong nona seminarineya. Deka ayero na eno yaya aune buro-mani nana mene nona seminarineya.” ");
INSERT INTO zia_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu nung ge eniya zo dema awong eno sinasani eyero sena, “Emo mene taung wori sekara agewa maingkoka zo kapero taung wori matura toto awiya gayao ine awiya teng oko arauwa. Emo zo mene ayero yariniya, awiya taung wori seka awiya yai meko yariniya. Ayero yai mo be maingkoka taung wori sekara awiya taung wori mature teng dekaongka oko yarineyato. ");
INSERT INTO zia_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nupema zo sana nigipu. Ou wain sekawa awiya emo mene wo memena aingso matu auna sukumao ine teng oko ara. Emo zo mene ayero yai, ou wain sekawa mene titisero memena aingso misai zanai ou wain yasa tawingna gariniya ara. Ayero yai meme aingso watimai zanero meko yariniya ara. ");
INSERT INTO zia_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Emo nung ou wain sekawa awiya meme aingso sekawara gege sukumaise. ");
INSERT INTO zia_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Emo nung ou wain matu minina amimene ou wain sekawa awiya oko aratapunoiya. Nung eyero sinoiya, ‘Matu mene zo nona nana iwaing.’” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabat iya be zore Yesu mene wuit buro zora towang atu ang yena ara. Ayero nenu buro-mani nuna mene wuit me ena gosero pumuwa. Puro wawong nunae mene binero kowero miniwa. ");
INSERT INTO zia_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ayero newa Farisayo ena mene giro eyero sewa, “Sabat iyare buro ayero yao awiya awang sao mitiya, awiya noeno nei?” ");
INSERT INTO zia_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ayero sewa Yesu mene abena eyero sena, “Tani Dawidi mene yena auna ungwe awiya niye oko nigao mene saine neya, awiya! Na eyao eno sinena. Be zore nung aune dubu nuna awong meri magayewa ara. ");
INSERT INTO zia_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ayero yewa Dawidi mene Tuwa Bayaura ibu toiro ame Tuwa Bayaura benaungna pugatinasani nauwa awiya puro minina ara. Ame awiya awong emo wosao mene minaese sao oko mitiya. Pirisa gege mene minaese sao ara. Arata Dawidi mene miniro dubu nuna dema pugainu miniwa Tuwa Bayau mene giginu meko oko yena. Niye ungwe awiya oko gao ing?” ");
INSERT INTO zia_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ayero sero susuuno awong eno eyero sena, “Na Emora Mani mene Sabat iya be auna Tuwa yero nona.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabat iya zore nung yere ibu zora toiro emo bauno ge tugata yena. Emo zo wawong me nuna amao amimene dema atu mitina. ");
INSERT INTO zia_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Arare sao tauyao ge gipao emo aune Farisayo dubu awong Yesu gera pugaora nagibo tamari sero nung etutinewa ara. “Nung emo yayare awiya Sabat iya be eune kora yari nita aung ing,” asero etuti nasani mitiwa ara. ");
INSERT INTO zia_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Arata nung nutope kotumao nunae mena gigina ara. Arare nung emo wawong nuna amao aeno eyero sena, “Ning bung, towang etu dopase.” Ayero senu nung iropuro dopena ara. ");
INSERT INTO zia_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ayero yenu Yesu mene awong eno eyero sena, “Na niye atata nena. Name tani iwaing Sabat iyare yanane teng yarinita tani meko yanane teng yariniye? Nupema name emo soremanane iwaing yaya teng yarinita emo sisiganane meko yaya teng yariniye?” ");
INSERT INTO zia_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ayero sero nung diti dati yero emo apakana mitiwa awiya giro aune emo aeno eyero sena, “Wawong nina iteti!” Ayero senu emo awiya wawong itetinu wawong nuna nupema iwaing yena ara. ");
INSERT INTO zia_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ayenu awong tini kapao bainakama puro nuka nuyetope eyero sewa, “Name tani no nung eno yarinenine?” Ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Be aune Yesu mene isa sari diri witiro baungna. Baungno ping awiya nung Tuwa Bayau eno isa gege sinasani mitinu iya gaina ara. ");
INSERT INTO zia_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Iya gainu nung wosiro buro emo nung ago newa awong awiya yau senu bumuwa nung nunae-una atu emo 12 awiya yangtagairo puro yazo awena aposolo asena ara. ");
INSERT INTO zia_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Zo Simon, arata Yesu mene yazo Petoro nung eno sena; zo Anderea awiya nung Simonna meta; Yakoboto Yohane; aune Filipto Batolomiu; ");
INSERT INTO zia_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiu aune Tomas; zo Yakobo awiya nung Alifayora mani; Simon awiya yazo nuna Gewera asinasani nauwa; ");
INSERT INTO zia_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","zo Yuda awiya Yakobora mani; ora Yudas Iskeriot, nung amimene ago Yesu keregairo iwora waweng pugaina. ");
INSERT INTO zia_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Arare Yesu awong aune dema diri atu wosiro baungno tawing garawi zora kasa yero emo bauno nung ago nauwa auna ena mene emo dubu baina aune dema dopero mitiwa tamuwa. Awiya emo bauno witao nibamu Yudaya tawingna arita Yerusalem napora aune wito bera napo eto Tayato Saidon auna atu buro augairo mitiwa tamuwa. ");
INSERT INTO zia_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Awong ge nuna nigari sero, o nung yaya nunae korayaise sero buro mitiwa. Ena iwae mene mokora toinu nauwa amaze Yesu mene kora yena ara. ");
INSERT INTO zia_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ayenu emo bauno apakana wawong mene nung inari yewa. Awiya noeno okowata, putoung nuna mene emora-una seuno awong apakana kora yena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu mene emo bauno nung ago nauwa awong awiya anuwing nasani eyero sena, “Niye emo bauno bogamasa, niye amimene yawa yawa yepu. Niye Tuwa Bayaura napo auna gegeregao. ");
INSERT INTO zia_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Niye dora botiyo ninae una kasa yero noi nowa, niye amimene yawa yawa yepu. Ago zamena simena ninae una atu kasa yariniya ara. Niye emo bauno yeme zi sinasani miteya, niye amimene yawa yawa yepu. Ago niye gero iyarineya. ");
INSERT INTO zia_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ago emo bauno ena mene niye gaya na Emora Mani auna dubu yaya awong tini kapao puro niye tunarineya, arita niye eno ge meko sarineya, ayero yazo ninae yaya meko yariniya, auna niye yawa yawa yarineya. ");
INSERT INTO zia_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Niye eno ayero yaya giro niye yawa yawa nasani wuyari-gamari yaya moko ninae iwaing yaise. Noeno okowata, zuma ninae uritira atu pumarineya awiya bainakama. Emo meko niye eno yarineya auna ewowo awiya gitau deka ayero porofete emo ena eno nasani nauwa. Arare niye porofete emora te weso papatinasani narineya. ");
INSERT INTO zia_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ora niye wau emo, niye amimene gosinasani aune neupu! Niye moko ninae iwaing yaora nona awiya yemaoko pupugaiwa. ");
INSERT INTO zia_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Niye emo bauno zamena simenane nowa, niye amimene gosinasani aune neupu! Ago dora botiyo ninae una atu kasa yariniya. Niye emo gero itinowa, niye amimene gosinasani aune neupu! Ago niye dubo mininasani zi saya ziziung wosariniya. ");
INSERT INTO zia_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ago emo bauno apakana amimene yazo ninae puro witarineya, awiya niye gosinasani aune neupu! Gitau ewowo nunae mene porofete ge iwao eno deka ayero sinasani nauwa ara. Arare niye eno ayero saya niye porofete ge iwao auna te weso papatinasani narineya arauwa. ");
INSERT INTO zia_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Niye ge nana nigitinowa, na niye eno eyero sana nigipu. Niye iwo ninae eno dubora mono pungpu. Niye tani iwaing emo tini kapao niye eno puro nowa aeno yepu. ");
INSERT INTO zia_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Emo waru ge niye eno sarineya, awiya abena gao ge iwaing awong eno sepu. Arita emo niye eno meko yarineya, awiya abena awong soreuno isa sepu. ");
INSERT INTO zia_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ora emo zo mene ning sowena enabara dai giro ning meta yero enaba gipe dae. Emo zo mene mo taung wori nina pumai giro taung wori mokora dema pugai pumae. ");
INSERT INTO zia_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Emo zo mene nona nina zo eno isa sai giro pugai pumae. Nupema emo zo mene nona nina pumai giro abena pugaora ge oko sase. ");
INSERT INTO zia_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Niye tani emo mene niye eno yaese aratapunowa teng deka ayero awong eno yepu. ");
INSERT INTO zia_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Zo awiya niye emo dubora mono niye eno pupunowa awong aeno abena dubora mono pumaya niye bowi yaneya? Pasena emo awong deka ayero nasani emo awong eno dubora mono pupunowa aeno abena dubora mono pupunowa ara. ");
INSERT INTO zia_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ora emo tani iwaing niye eno yero nowa aeno abena tani iwaing yaya niye bowi yaneya? Pasena emo awong tani deka ayero yero nowa ara. ");
INSERT INTO zia_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Niye emo ena eno nona ena pugairo nupema abena niye eno pugaese kotumaya niye bowi yaneya? Pasena emo awong deka ayero nasani pasena emo ena eno nona pugairo nupema nona awiya nupema kapete gairo pumari sinowa ara. ");
INSERT INTO zia_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Arata niye mene zo iwo ninae aeno dubora mono pungpu. Niye tani iwaing awong eno yepu. Niye nona ena awong eno pugairo abena nona zo pumari sero oko kotumae. Niye ayero nasani nete ago zuma bainakama pumarineya ara. Ayero ago niye Tuwa Bayau ika nibamu mitoiya auna mani me yarineya ara. Emo ena nung eno dange oko sao yero nowa, arita ena mene meko nasani nowa. Awiya saineba, nung awong eno bayao noiya. ");
INSERT INTO zia_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Niye yo-amao Mama ninae mene yero noiya ayero yepu. ");
INSERT INTO zia_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Niye zaz mene yaine yero emo ena oko gera pugae. Ayero oko yao yarineya, awiya Tuwa Bayau mene niye oko gera pugariniya. Niye zaz mene yaine yero mou yao emo ena eno oko pugae. Ayero oko yao yarineya, awiya Tuwa Bayau mene mou yao niye eno oko pugariniya. Niye emo enana pasena ganena duwaya Tuwa Bayau deka ayero pasena ninae duwariniya. ");
INSERT INTO zia_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Niye nona emo ena eno pugaya giro Tuwa Bayau mene nona niye eno pugariniya. Nung nona niye eno sukumai be kiziba yero yasagai pumarineya. Niye nona emo ena eno pugarineya teng Tuwa Bayau mene niye eno pugariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu mene ge pungyao zo awong eno sinasani eyero sena, “Emo zo diti guma yao amimene emo zo diti guma yao aeno nagibo gipai teng yarinita? Aung ara. Awongto etobe deka ayero kowara zuwarineyato ara. ");
INSERT INTO zia_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mani zo nigao gare atu nariniya amimene gipao maung nuna daigao ine oko mitiya. Nung nigao gitau puro aune gipao maung nuna ine yariniya. Arare gipao mani nina mene ning oko daigao yai giro nung gera oko pugase. ");
INSERT INTO zia_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ning nono yero otao nina-una ditira uzozoru mitiya awiya gosinasani nina-una diti mokora i zizaing mitiya awiya oko giro baingtao nesi? ");
INSERT INTO zia_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","I zizaing nina-una diti mokora mitiya awiya ning oko gao nasani otao nina eno eyero sasa teng yarinita? ‘Otao, nina-una ditira uzozoru mitiya awiya pumane.’ Ge iwao emo, ning nitope nina diti mokora i zizaing mitiya awiya gitau puro aune giro baingtiti nasani otao nina-una ditira uzozoru mitiya awiya pumasa teng yariniya. ");
INSERT INTO zia_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","I iwaing mene me meko oko iyariniya. Deka ayero i meko mene me iwaing oko iyariniya. ");
INSERT INTO zia_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Emo awong gitau i me giro aune i mekota iwaing ing, awiya gosinowa ara. Name yuwang me awiya angsi tapo giginone auna atu oko iro mitai sukarinenane. Nupema guwawa me awiya nibara atu oko iro mitai uwarinenane. ");
INSERT INTO zia_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Emo iwaing awiya kotumao iwaing nuna-una mokora mitoiya, arare nung tani iwaing yero noiya. Emo meko awiya nung kotumao memeko-mameko nuna-una mokora mitoiya, arare nung tani memeko-mameko yero noiya. Dubo mene denenu mitoiya auna teng be mene keregairo sinoiya arauwa. ");
INSERT INTO zia_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Niye nono yero begiti mene gege na eno, ‘Tuwa nana, Tuwa nana,’ asinasani ge sinona awiya oko dimao yero nowi? ");
INSERT INTO zia_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Zo nung nana-una atu buro ge nana nigiro dimariniya, susuwa nuna awiya emo zora pugairo sana nigipu. ");
INSERT INTO zia_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Emo awiya nung emo zo garo yena ayao ine ara. Nung gitau kote me wauno ziwong pugairo susuwa gaenu tauyenu aune garo pugainu dopena ara. Ago wabamu baina denu garo awiya oko gisao tauyena. Noeno okowata, emo awiya garo tauyao yena. ");
INSERT INTO zia_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Arata emo ge nana nigiro oko dimao yero noiya awiya nung emo zo garo tawingna tame pugairo yena ayao ine ara. Nung gitau kote me oko wamao. Nung garo auna ziwong tame paka yero yena. Arare ago wabamu baina dero garo awiya denu mena uno zuwero kasero aung yena ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu mene ge awiya emo bauno eno senu aung yenu nupema baung Kapaneam nape yena. ");
INSERT INTO zia_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Gorobo emo 100 auna gitau yao zo awiya atu mitina. Soumani nuna zo awiya giro ara tapunauna amimene be aune yaya puro maga yari sero nasani mitina. ");
INSERT INTO zia_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Emo gitau yao amimene Yesu mitina auna ge nigiro giro Yuda emora diya ena iyengtinu baungno Yesura-una atu nung yausero eyero sewa, “Gorobo emora gitau yao zo mene ning baungno soumani nuna kora yasese siniya.” ");
INSERT INTO zia_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ayero sero awong nupema Yesu eno ge tau-tataware yao sinasani eyero sewa, “Gitau yao awiya nung gorobo emo enana gitau yao ine okowa. Nung gitau yao emo iwaing. Arare ning soumani nuna kora yasa teng yariniya. ");
INSERT INTO zia_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nung name Yuda eno nao iwaing yero noiya. Nung nutope gitau yere ibu naname zo yena.” ");
INSERT INTO zia_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ayero sewa giro Yesu mene awong aune dema baungna. Baungno kasa garo nugu yenu aune gorobo emora gitau yao amimene otao mani ena eno ge senu puro baungno eyero sewa, “Tuwa, saineba, ning buro baina oko yase. Na emo iwaing oko, arare ning garo moko nana-una towasa teng oko yariniya. ");
INSERT INTO zia_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nupema na emo iwaing oko amimene nina-ina nugu bana teng oko yariniya. Arare ning atu mitasani ge gege sasa soumani nana iwaing yariniya, awiya gosinena. ");
INSERT INTO zia_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Noeno okowata, na emo gitau yaora ame-ame nona. Nupema gorobo emo dubu ena mene nana-una ame-ame nowa. Arare nane nunae-una zo babaise sana babariniya. Ora zo bumaise sana bumariniya. Nupema na soumani nana buro yaise sana yariniya. Arare putoung nina-ina susuwa gigena kasaniya. Arare ge gege sasa soumani nana iwaing yariniya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ayero senu Yesu mene ge awiya nigiro wawong di gauno ziruru yero emo bauno dubu baina nuna ame newa aeno eyero sena, “Na niye eno sana nigipu. Na Isreli emo ninae-ina atu emo tumo diyao eyao ine zo oko tamuwang.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Arare emo gitau yao nunae una ge puro bumuwa awong amimene nupema baung gare yero soumani awiya iwaing yero mitinu gigiwa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yesu buro-mani nuna aune baungno napo zo yazo nuna Nen auna yari sero bautunewa emo bauno dubu baina amimene nuye ago yero dema bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Baungno napo auna atu kasa yero napora goma auna towao bera atu towari sero newa aune napo auna emo bauno ena mene mani magayao zo puro biritira babari sero puro bumuwa. Mani magayao auna ai awiya nung yu magayao aune nung mani dekaongka gege ara. Arare napo auna emo bauno witao mene iropuro bauno aune dema butunewa. ");
INSERT INTO zia_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tuwa nung bauno awiya giro nung eno yo-aungno giro nung eno eyero sena, “Ning zi oko sase.” ");
INSERT INTO zia_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ayero sero nung nugu baungno wawong goga tame pugainu emo mani gogare diungno newa amimene dopewa ara. Ayero yewa Yesu mene eyero sena, “Bouwa, ning iropasese sinena.” ");
INSERT INTO zia_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ayero senu mani magayao awiya iropuro adungno ge sena. Ayero yenu Yesu mene puro ai nuna eno pugaina ara. ");
INSERT INTO zia_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ayero yenu emo bauno witao amimene awang nasani Tuwa Bayaura yazo de ika yewa. Ayero nasani eyero sewa, “Naname-una towang etu porofete zo kasa yetiya.” ");
INSERT INTO zia_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ayero sewa Yesu buro nauna auna bowi amimene Yudaya tawingnata tawing enana-una baungno teng yena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yohanena buro-mani mene Yesu buro nauna auna bowi nung eno sewa. ");
INSERT INTO zia_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Arare Yohane mene buro-mani nuna etobe yausenu bumuwato awongto ge zo puro Tuwara-una babaetose sena. Baungno eyero saetose sena, “Ayero Kristo baise sao awiya ning arita, orata zo ago bai gari diya yarinenine?” ");
INSERT INTO zia_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ayero senu emo etobe awiya baungno Yesura-una kasa yero eyero sewato, “Yohane ge ou zayero suwao emo amimene nato sesi nina-ina butunenato. Nato ning eyero atata yanetose sesiya, ‘Ayero Kristo baise sao awiya ning arita, orata zo ago bai gari diya yarinenine?’” Ayero sewato ara. ");
INSERT INTO zia_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Arare be aune Yesu mene emo bauno daigairo auna yaya-biyaya noyao awiya kora yena. Anasani iwae sorowe mokora mitao awiya tunena, aune diti guma yao awiya kora yenu diti pagaiwa ara. ");
INSERT INTO zia_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Arare Yesu mene ge awongto eno abena eyero sena, “Nito yesese yero baungno nona yeme gosineyato, o ge nigitineyato awiya Yohane eno seputo nigae. Diti guma yao awiya diti pagatineya; te meko yao awiya nupema ang neya; emo bozo tauyaore awiya taung iwaing neya; dawong itigao awiya ge nigitineya; mamagayao awiya seka yero iropupuneya; ora bogamasa awiya Bowi Iwaing nigitineya. ");
INSERT INTO zia_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Zo nung na eno gai mou oko yao yariniya amimene yawa yawa yariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Emo etobe Yohanena ge puro bumuwato awongto amimene nupema tera yesese yero bamuwato aune Yesu mene emo bauno dubu baina aeno Yohanena ge ungwe yena. Ayero nasani eyero sena, “Niye Yohane gari sero tawing emo aung auna bamuwa, awiya niye emo nono yao gari bamuwi? Niye emo turao zo bisi mene teboza pisinoi buro baungno yero nasani noiya ayao ine awiya gari bamuwita? Aung ara. ");
INSERT INTO zia_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Niye emo nono yao gari bamuwi? Niye emo zo taung wori iwaingne nasani nauna awiya gari bamuwita? Aung ara. Emo nona sekare yero nowa, o taungna nona ipu ewa-gaewa yao pupunowa, emo ayao awiya awong emo tuwara gare mitima nowa ara. ");
INSERT INTO zia_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Arata niye emo nono yao gari bamuwi? Niye porofete zo gari bamuwita? Yore. Niye porofete zo gari bamuwa. Arare na niye eno ge me sane. Nung awiya porofete ara. Nune porofete nasani nauwa awiya daigatiniya. ");
INSERT INTO zia_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Arare emo aeno ge gayao zo eyero mitiya, Ewiya gipu. Na bowi sao emo nana iyengtarinena. Nung gitau yero nagibo nina kora yariniya. ");
INSERT INTO zia_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na niye eno sane. Yohane mene tawingna emo apakana daigatiniya. Arata Tuwa Bayaura napora gerao zo wosao nibamu amimene Yohane daigatiniya ara.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Emo bauno apakana aune takis pumao emo awong ge awiya nigiro eyero sewa, “Yore, Tuwa Bayaura tani awiya me ara.” Ayero sewa noeno okowata, gitau Yohane mene awong ge ou suwena. ");
INSERT INTO zia_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Arata Farisayo aune sao tauyao ge gipao emo awong awiya Yohane mene oko ge ou suwao, arare awong Tuwa Bayau mene nagibo naese sena awiya awang sero yangduwa. ");
INSERT INTO zia_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Arare Yesu mene eyero sena, “Arare na emo bauno yeme tawingna etu neya awiya nona nouna pugairo sana teng yariniye? Niye emo nono yao ing? ");
INSERT INTO zia_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Niye tani mani mamanikakara ine yero nowa. Mani mamanikaka napo kakame atu adungno mitasani otao mani ena yausero eyero sinowa, ‘Nae ge tuwari aeno niye yuno gogoing detenane, arata niye na oko wuyao yeteya. Nupema nae yo-amaora zi be yetenane, arata niye zi be oko yao yeteya. Arare nae nono yanane gaya iwaing yariniye?’ Ayero sinowa ara. ");
INSERT INTO zia_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ayero Yohane ge ou zayero suwao emo amimene buro nuna zayero nona minao ena semininasani ou wain dema semini nasani noi giro nung eno eyero sinowa, ‘Iwae nuna-una mokora mitoiya.’ ");
INSERT INTO zia_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nupema na Emora Mani mene kasa yero nona mininasani ou mininasani ayero nona giro na eno eyero sinowa, ‘Gipu. Nung wiso minao nao emo. Nung ou wain yanakana mininiya. Nung takis pumao emo aune Yudara sao tauyao ge dao emo auna otao.’ Niye na eno ayero sinowa. ");
INSERT INTO zia_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Arata nato buro yero nonato awiya Tuwa Bayaura kotumaora yero nonato auna susuwa awiya buro nanato una me mene keregatinoi emo bauno gosinowa me yero noiya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisayo zo mene Yesu nona minaise sero garo nuna-una yunu baungno witiro nona minaora masira atu adungno nona minari mitina ara. ");
INSERT INTO zia_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ayero mitinu pasena bauno zo napo auna atu mitauna amimene ge bowi Yesu Farisayora-una gare atu nona mininasani mitina awiya nigina. Ayero sewa nigiro giro nung garewa daba mene yao auna ou sere bainane awiya puro buna ara. ");
INSERT INTO zia_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ayero yero baungno Yesura-una tera nugu atu dopero zi sinasani mitinu ziziung mene Yesura te gugusa yena. Ayero yenu nung giti ai nuna mene dupenu soyenu te nuna toko yena ara. Ayero yero ou sere bainane amimene Yesura te suwena ara. ");
INSERT INTO zia_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Arare Farisayo emo Yesu yunu buro garo nuna-una yena auna yazo Simon, amimene tani awiya giro eyero kotuna, “Emo ewiya nung porofete me yero nati siya, awiya nung bauno emimene nung ding niya auna susuwa gatiya. Nung awiya pasena bauno awiya gatiya.” ");
INSERT INTO zia_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Emo ayero kotupunenu giro Yesu mene nung eno eyero sena, “Simon, na ge zo ning eno sari kotupunena.” Ayero senu Simon mene eyero sena, “Gipao emo, ning ge nina se nigane.” ");
INSERT INTO zia_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ayero senu Yesu mene eyero sena, “Mani etobe awongto abena emo zora-una yewato ara. Zo mene 100 kina abena yena, arata zo mene zo 10 kina gege abena yena. ");
INSERT INTO zia_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Awongto abena awiya nupema abena pugao ine awiya teng oko yao yena. Arare emo awiya abena awenato etobe deka awiya yangduna. Arare nunato-una awe mene emo aeno moko nuna iwaing yariniye?” ");
INSERT INTO zia_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ayero senu Simon mene ge nuna auna abena eyero sena, “Emo awiya abena nuna baina yangduna nung amimene yariniya.” Ayero senu Yesu mene nung eno eyero sena, “Ning iwaing kotumesa.” ");
INSERT INTO zia_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ayero sero nung diti ye bauno auna-una yero Simon eno eyero sena, “Ning bauno ewiya gi. Na garo moko nina-ina bumena ning te sayaora tani naname awiya doro te sayaora ou na eno oko pugao yetesa. Arata bauno emimene zo te nana ziziung nuna amimene saetiya ara. Ayero giti ai nuna mene dupeti soyetiya ara. ");
INSERT INTO zia_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na nina-ina bumena ning na wawong oko inao yetesa ara. Arata bauno emimene zo be na toiro bena atu zayero te nana yumao gege yupunasani mitiya era. ");
INSERT INTO zia_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ning giti ai nana uweri mene oko suwao yetesa ara. Arata bauno emimene zo te nana uweri sereyaore mene suwetiya. ");
INSERT INTO zia_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Arare na ning eno sane. Pasena nuna witao bainakama disetena aung yetiya, ka eno nung na eno yo-amao bainakama taungno na kora yetiya. Arata zo nung pasena nuna maingkokaka gege disana nung abena na eno yo-amao maingkokaka gege tamariniya.” ");
INSERT INTO zia_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesu mene ayero sero aune bauno eno eyero sena, “Na pasena nina disetena ara.” ");
INSERT INTO zia_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ayero senu giro emo nung aune dema nona mininasani mitiwa amimene nuka nuyetope wina-se nasani eyero sewa, “Emo ewiya nung nono yao mene pasena disiniye?” ");
INSERT INTO zia_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ayero sewa, arata Yesu mene bauno aeno eyero sena, “Tumo diyao nina auna teng iwaing yetesa. Arare dubo iwaingne baung.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ago Yesu mene napo babuzere mamanikakare zipunasani Tuwa Bayau nata Tuwa yero nariniya auna ge tugata nasani nauna ara. Atu buro-mani 12 nung aune dema nasani nauwa. ");
INSERT INTO zia_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Bauno ena gitau Yesu iwae nunae-una atu tunena arita yaya meko nunae-una atu kora yena awong amimene nung aune dema nasani nauwa ara. Nunae-una zo awiya Maria. Awong nung Maria Madala napora asinauwa. Gitau Yesu mene iwae 7 nuna-una atu tunena. ");
INSERT INTO zia_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ora bauno Yoana awiya nung Kusara bauno. Yu nuna mene Herodera garo diya nasani nauna. Ora bauno zo yazo nuna Susana, aune bauno ena dema, awong apakana amimene Yesu aune dema nasani nung aune buro-mani nuna aune awiya wau nunae mene sorepunasani nauwa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Emo bauno dubu baina awong Yesura-una buro augatinewa dubu bainane mene nupema susuuno napo sero sero auna atu bumuwa giro nung ge eniya zo awong eno sinasani eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Emo zo mene nona we bure atu sesari sero baungna. Baungno nona we sesinenu we ena nagibe atu wosiwa ara. Nagibe atu wosiwa emo bauno te mene patiwa, nupema ena awiya ni mamani mene taungno miniro aung yewa ara. ");
INSERT INTO zia_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ora we ena mene zo agewa daba mitina auna tame atu wosiwa. Wosiro pusasa yewa, arata tawing awiya ou aung, arare nona awiya irara yero magayena ara. ");
INSERT INTO zia_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ora we ena mene zo i-we meko mitiwa auna atu wosiwa ara. We awiya i-were dema apakana teng-temo pusasa yero iropuro i-we mene nona awiya anenu me oko iyao yena ara. ");
INSERT INTO zia_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Orata we ena mene zo tawing me gawire auna atu wosiro pusasa yero zaungno me witao iwa arauwa.” Yesu mene ayero sero aung yero aune eyero sena, “Arare zo nung dawongne mene ge ewiya nigaese.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Buro-mani nuna awong nung ge eniya auna susuwa keregaise sewa giro ");
INSERT INTO zia_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","nung eyero sena, “Tuwa Bayau nata Tuwa yero nariniya auna ge pungyero mitoiya auna susuwa awiya niye ena mene nigaese sao mitiya ara. Arata ena awiya susuwa nuna pungyero mitai ge eniya gege sana nigaese sero sinona. Arare diti moko nunae mene gaese, arata oko giro baingtaese. Awong ungwe gege nigaese, arata awong ungwena susuwa oko nigiro baingtaese. ");
INSERT INTO zia_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ge eniya auna susuwa awiya eyao era: Nona we awiya Tuwa Bayaura ge ara. ");
INSERT INTO zia_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ora we ena nagibe atu wosiwa auna susuwa eyao era: Emo awong ge nigitinowa, arata Sanda mene buro awong ge awiya nigiro Tuwa Bayau tumo diyaya nung awong sorero pumao eno, nung ge awiya nunae-una kotumaora atu sorero pupunoiya. ");
INSERT INTO zia_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ora we ena tawing agewa dabare auna atu wosiwa auna susuwa awiya eyao era: Emo awong uritira ge nigiro dube pugairo yawa yawa nowa, arata awong tatai aung. Awong tumo diyaore nasani nowa etegao zo kasa noi aune awong tumo diyao nunae besinowa. ");
INSERT INTO zia_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ora we ena i-we towang atu wosiwa auna susuwa awiya eyao era: Emo awong ge nigitinowa, arata awong tawingna nona eno kotung-katung nasani wau moni eno yawa yawa nasani nona ipu ewa-gaewa yao aeno dubo-dubo nasani nowa nona amimene awong zipunoi me nunae oko kasa yero baina noiya. ");
INSERT INTO zia_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ora we ena zo tawing iwaing gawire auna atu wosiwa auna susuwa awiya eyao era: Emo awong ge nigiro dubo nunae iwaing-kawaing auna pugairo iniro baingtiti nasani tau-tataware nasani me tapunowa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Emo name damana gaero au apero wese atu oko pugatinonane. Nupema name damana puro opesa wese oko pugatinonane. Aung ara. Name puro iko gerura gatinonane. Awiya emo awong buro garo mokora toiro waegao gaese sero ayero nonane. ");
INSERT INTO zia_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nona pungyao apakana ago kasa daung yarineya. Ora nona dowao apakana kasa ye daung gaya emo mene garineya. ");
INSERT INTO zia_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Niye ge nigari sero giro, kotungno baingtiro aune nigipu. Emo zo nung ge me puro nariniya, awiya Tuwa Bayau mene ge me bainakama nung eno pugariniya. Arata emo zo nung ge me oko puro nao nasani ‘ge me nana-ina mitiya,’ asariniya, awiya Tuwa Bayau mene ge me nuna-una atu sorero pumariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Be aune Yesura ai metamaine awong nuna-una bumuwa. Arata emo bauno witao mitiwa, arare awong nuna-una nugu babao awiya teng oko yena. ");
INSERT INTO zia_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ayenu newa giro emo ena mene nung eno eyero sewa, “Ai nina metamaine awong ning gari sero buro bautara atu dopero miteya.” ");
INSERT INTO zia_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ayero sewa nung ge nunae abena eyero sena, “Emo bauno Tuwa Bayaura ge nigiro dipunowa amimene ai nana arita metamani nana neya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Be zore Yesu buro-mani nuna aune wang zora witiro nung awong eno eyero sena, “Name ou nazi buwagairo enaba babanene.” Ayero sero buwagairo bamuwa. ");
INSERT INTO zia_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bautunewa Yesu nung auriti awinenu bisi baina zo diri ina atu wosi ou nazira yero kakawa dena. Ayero yenu wang beboga nosenu awong gera yari sero nasani ");
INSERT INTO zia_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","giro baungno Yesu uwero nung eno eyero sewa, “Gipao emo, name gera yari sero nenane!” Ayero sewa nung iropuro bisire kakaware baina awiya gona yena. Gona yenu bisire kakawa bainane awiya binono dena ara. Ayero yenu ou awiya kapu nupema aung yena. ");
INSERT INTO zia_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ayenu nung awong eno eyero sena, “Niye nono yero tumo diyao ninae besinei?” Ayero senu awong awang yero kotung-katung nasani nuka nuyetope ge wina-se yero sewa, “Emo ewiya nono yao i? Nung bisire kakaware eno ge sesi ge nuna dimeyato ewiya!” Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu buro-mani nuna aune mene ou nazi zo Galilaya tawing enaba Gegesa tawing enaba ayero mitowato auna atu buwagairo Gegesa tawingna kasa yewa. ");
INSERT INTO zia_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Kasa yero Yesu nung wang doro witi ika nenu emo zo napo auna amimene nuna-una buna. Iwae ena emo auna-una mokora mitiwa. Gitau oune iwae amimene emo awiya ozaungzaung darauno nasani nauwa. Emo ena awong emo meko awiya diya nasani seni mene buninasani hankap pugati nasani nauwa. Ayero nauwa nung iropuro nona apakana awiya initi naunu kasugatinaunu iwae amimene nung puro baungno tawing agewa emo aung auna yero nasani nauwa. Nung mo aung nasani nauna. Nung garo mera oko awinauna. Nung biritira atu mitima awiro nasani nauna. Arare emo amimene Yesu giro aiyamama sero baungno Yesura-una tera atu zuwe tawingna gaina. Zuwero aiyamama yanakana sinasani eyero sena, “Yesu, ning Tuwa Bayau ika mitoiya auna Mani me nosa amimene na eno nomaze yari butunesi? Ning yaya buro na eno oko pugase.” Ayero sena, noeno okowata, Yesu mene mena iwae awiya emo doro babaese sena. ");
INSERT INTO zia_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Arare Yesu mene nung atata yero sena, “Yazo nina aweni?” Ayero senu nung eyero sena, “Yazo nana dubu baina.” Ayero sena, noeno okowata, iwae daigairo mene gitau nuna-una toiro mitauwa ara. ");
INSERT INTO zia_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ayero senu iwae awong isa sinasani aiyamama sero Yesu eno eyero sewa, “Nae kowa iyaore auna babanenese sero oko tunase.” Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Pu dubu baina diri deungna atu nona mininasani newa, arare iwae awong Yesu eno eyero sewa, “Ning nigasa nae baungno pu dubu ouna-una towanene.” Ayero sewa Yesu mene ge nunae nigina ara. ");
INSERT INTO zia_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ayenu iwae awong emo awiya doro baungno pura-una mokora toiwa pu dubu awiya yanakana sungno kowara baungno ou nazira gutero ou miniro maga yewa ara. ");
INSERT INTO zia_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ayero yewa pu diya awong tani awiya giro awang yero sungno baungno ge awiya keregairo emo bauno napo bainanata agewa enana aeno sewa ara. ");
INSERT INTO zia_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ayero yewa giro emo bauno awong tani awiya gari sero bamuwa. Baungno Yesura-una kasa yero emo iwae nung doro bamuwa awiya gigiwa. Nung mo awiro kotumao nuna nupema iwaing yenu nung Yesu aune dema tairo adungno mitina awiya giro awang yewa. ");
INSERT INTO zia_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ayero yewa emo awong gitau tani awiya gigiwa amimene Yesu mene emo iwae nuna-una mitao awiya korayena auna ungwe awiya yewa nigiwa. ");
INSERT INTO zia_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Arata Gegesa tawingna emo apakana amimene awang yero Yesu nung tawing nunae doro babaise sewa. Asewa giro nung buro-mani nuna aune witi wangna yero yesese yero babari newa ");
INSERT INTO zia_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","emo iwae nung doro bamuwa amimene Yesu eno isa sinasani eyero sena, “Na ning aune dema babari sinena.” Ayero senu Yesu mene awang sinasani nung eno eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ning yesese yero napo nina-una baungno Tuwa Bayau tani daigairo ning eno yetiya awiya sasa nigae.” Ayero senu emo amimene yesese yero baungno tani daigairo Yesu mene nung eno yena auna ge ungwe nasani emo bauno napo nuna-una aeno senu nigiwa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu ou buwagairo nupema yesese yero bunu emo bauno dubu baina nung diya mitiwa amimene nung giro yawa yawa nibamu yewa. ");
INSERT INTO zia_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Aune emo zo yazo nuna Yairo, nung awiya simai baina yere ibu diya yero nasani nauna amimene buro Yesura-una nugu baungno koing gairo isa sinasani eyero sena, “Ning kara garo nana-una bung.” ");
INSERT INTO zia_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ayero sena, noeno okowata, mani nuna baunodi dekaongka dawang nuna 12 gege amimene magayari nasani mitina. Ayero senu giro Yesu bautunenu emo bauno dubu baina mene nung pu towang gairo bautunewa ");
INSERT INTO zia_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","bauno zo be giti yu pupunawe dunu dawang 12 ayao yena awiya dema baungna. Arata emo zo mene yaya nuna kora yaine yao teng oko ara. ");
INSERT INTO zia_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Bauno amimene Yesura-una bautara buro wawong pugairo Yesura taung wori be dingyena. Nung ayero nasani nenu be ka aune yu pupunauna awiya soyena. ");
INSERT INTO zia_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ayero yenu Yesu mene eyero sena, “Awe mene taung wori nana dingniye?” Ayero senu awong apakana eyero sewa, “Na aung. Na aung.” Ayero sero bamuwa Petoro mene eyero sena, “Gipao emo, emo bauno dubu baina mene ning kara puro pu towang gairo miteya, gosinesa!” ");
INSERT INTO zia_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ayero senu Yesu mene eyero sena, “Zo gitau wawong nuna nana-ina pugaiya, awiya yetine yetena, noeno okowata, korayaora putoung ena nana-ina atu kasayero babi yatu tamena.” ");
INSERT INTO zia_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ayero senu bauno awiya susuwa nuna pungyao ine teng oko yenu giro awang yero ipinasani nuna-una nugu buro boma giti mene tawingna gaena. Ayero yero emo bauno dubu baina mitiwa auna ditira atu nung nono yero wawong pugairo Yesu dingyena auna susuwa keregati nasani yaya nuna mena aung yena awiya dema senu nigiwa. ");
INSERT INTO zia_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ayero senu Yesu mene nung eno abena eyero sena, “Aya nana, ning tumo diyao nina auna teng iwaing yetesa. Ning dubo iwaingne baung.” ");
INSERT INTO zia_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nung ge sinasani mitinu emo zo simaira-una gare atu buro simai eno eyero sena, “Mani nina magayetiya. Arare buro baina gipao emo eno oko pugase.” ");
INSERT INTO zia_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ayero senu Yesu mene ge awiya nigiro emo simai aeno eyero sena, “Ning kotung-katung oko yase. Ning tumo diyaore gege nasa mani nina iwaing yariniya.” ");
INSERT INTO zia_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ayero sero baungno simaira-una gare kasa yero emo bauno nung aune dema garo mokora towao awang sena. Awang sero nung Petoro, Yohane, Yakobo aune maina ai maungne awong awiya gege puro toiwa ara. ");
INSERT INTO zia_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ora emo bauno witao mene zo awong mani eno zire-buware nasani mitiwa. Anewa Yesu mene awong eno eyero sena, “Niye zi oko sae. Nung oko magayao ara. Nung auriti gege awiniya.” ");
INSERT INTO zia_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ayero senu awong mani meba magayena awiya gigiwa, arare nung pusugairo itinasani izewa. ");
INSERT INTO zia_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Arata Yesu mene mani baunodi auna wawong iniro yausero eyero sena, “Zebi, ning iropung.” ");
INSERT INTO zia_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ayero senu maina oweno nupema bunu mena iropuna. Ayero yenu Yesu mene nona pugaya minaise sena. ");
INSERT INTO zia_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Arare maina ai maungne awongto tani awiya gigiwato beu dena. Arata Yesu ge tauyao awongto eno eyero sena, “Nito tani euna bowi awiya emo zo eno oko saeto.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu mene buro-mani nuna 12 yau senu bumuwa putoung tau-tataware yao iwae apakana tunaora putoung, arita yaya-biyaya korayaora putoung awiya awong eno pugaina ara. ");
INSERT INTO zia_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ayero awong baungno Tuwa Bayau nata Tuwa yero nariniya auna ge sero gipinasani emo bauno yayare kora yaese sero iyengtina ara. ");
INSERT INTO zia_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Iyengtiti nasani awong eno eyero sena, “Niye nagibe atu nasani nona daigairo oko pumae. Niye tungta ketewata nona minaota wau moni oko pumae. Niye taung wori etobe oko pumae. ");
INSERT INTO zia_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ora niye esewa yero garo zora towarineya awiya garo dekaongka kamaze mitao masi yero buro baungno nasani nete aune garo awiya doro babarineya ara. ");
INSERT INTO zia_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ora niye napo zora babaya awong niye oko puro toi garo nunae-una yao yaya giro niye napo awiya doro te ninae auna popo durere gaya awong tani nunae meko awiya kotumae.” ");
INSERT INTO zia_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ayero senu awong bamuwa. Baungno napo sero sero auna atu nasani Bowi Iwaing sero gipero anasani emo bauno yayare awiya korayewa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Emo tuwa Herode mene Yesu tani yero nauna auna bowi nigiro nung dubo eto yena. Noeno okowata, emo ena mene eyero sewa, “Yohane magayaora atu iropuro niya.” ");
INSERT INTO zia_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Arata ena mene eyero sewa, “Eliya nupema kasa yetiya.” Ora ena mene eyero sewa, “Porofete gitaura zo seka yero iropuro niya.” ");
INSERT INTO zia_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ayero sinasani newa Herode mene eyero sena, “Na Yohanena dubo kapewang. Arata emo awe mene ni na ge bowi nuna nigitineni?” Ayero sero nung Yesu gaora nagibo tamari yena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aposolo 12 awong nupema tera Yesura-una buro buro apakana yewa auna ungwe yewa ara. Ayero yewa Yesu mene awong gege puro emo ena doro awong baung napo zo yazo Besaida auna yewa ara. ");
INSERT INTO zia_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ayero yewa giro emo bauno ena mene nung tamari sero baungno nuna-una kasa yewa giro nung yawa yawa nasani Tuwa Bayau nata Tuwa yero nariniya auna ge awiya awong eno sero gipero anasani emo bauno yayare awiya kora yena ara. ");
INSERT INTO zia_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ayero nasani mitinu ture itinenu giro buro-mani nuna 12 amimene nuna-una buro eyero sewa, “Ning emo bauno iyengti napo nugu miteya auna baungno atu nona minao taungno miniro awae. Tawing name mitenane ewiya nona minao aung ara.” ");
INSERT INTO zia_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ayero sewa, arata Yesu mene awong eno eyero sena, “Nika niyetope nona minao awong eno pugaipu minae.” Ayero senu awong sewa, “Nae nona minao daigairo aung. Nae ame igiyao wawong zo aune wo etobe amimene gege miteya era. Ning naka nanae baungno emo bauno euna nona minao zuma gaero pumanenese kotungno sinesita?” Ayero sewa, noeno okowata, ");
INSERT INTO zia_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","emo dubu awiya 5,000 amimene mitiwa. Ayero sewa Yesu mene buro-mani nuna eno eyero sena, “Niye sepu emo bauno 5,000 amimene dubu sero dubu sero 50-50 yero adumae.” ");
INSERT INTO zia_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ayero senu buro-mani nuna deka ayero sewa emo bauno adumuwa ara. ");
INSERT INTO zia_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Adungno mitiwa Yesu mene ame wawong zo aune wo etobe aune awiya puro diti ika uritira yero Tuwa Bayau eno dange sero wore amere awiya eegairo buro-mani nuna eno pugainu awong emo bauno eno bono yewa ");
INSERT INTO zia_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","emo bauno apakana amimene miniwa teng yena ara. Ayero yero nona itoto duwa giro yangta gairo puro pu dekaongna gaiwa saka 12 teng yena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Be zore Yesu nung isa sinasani mitete aune buro-mani nuna nung aune dema mitiwa awiya atata yero sena, “Emo bauno mene na awe asero nowi?” ");
INSERT INTO zia_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ayero senu awong abena nung eno eyero sewa, “Ena mene ning maze Yohane ge ou zayero suwao emo asero nowa; ena Eliya asero nowa; ena porofete gitau nasani nauwa auna zo seka yero noiya asero nowa ara.” ");
INSERT INTO zia_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ayero sewa nung eyero sena, “Arata nika niyetope na awe asero nowi?” Ayero senu Petoro mene abena eyero sena, “Ning awiya Sorao Emo nanae Kristo Tuwa Bayau mene iyengtina ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu mene ge tau-tataware yao sinasani awong susuwa nuna awiya keregairo emo zo eno sao awang sena ara. ");
INSERT INTO zia_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nung awang sinasani eyero sena, “Na Emora Mani mene yayabiyaya tamarinena. Ayero yana Yuda emora simai pirisa babuzere sao tauyao ge gipao emore amimene na awang sero daya magayana wari be etama aung yai aune na nupema seka yero iroparinena.” ");
INSERT INTO zia_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ayero sero nung nupema emo bauno nung ago newa aeno eyero sena, “Zo nung na ago yari yero giro ara tamao nuna apakana doro be sero dubo minaore yaya tamaore auna i pasao nuna diungno na ago yaise. ");
INSERT INTO zia_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ayero sinena, noeno okowata, zo nung nao nuna tawingna awiya sorero puro nari kotumariniya auna nao nuna aung yariniya. Ora zo nung tawingna nao nuna na eno yero duwariniya amimene nao iwaing tamariniya ara. ");
INSERT INTO zia_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nupema emo zo mene tawingna nona iwawaing apakana awiya pupunariniya arata ititi nuna gera yai meko yariniya, awiya teng yarinita? Aung ara. ");
INSERT INTO zia_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ora emo zo nung na ta ge nana awiya awang sariniya, awiya na Emora Mani mene simao waegaore nana aune Mamana angelo dubu pewa yetugao auna simao waegaore awiya puro bumarinena be aune na abena emo awiya awang sarinena. ");
INSERT INTO zia_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Na ge me niye eno sinena. Emo ena etu dopero miteya amimene oko magayao naya Tuwa Bayau nata tuwa yero nariniya auna putoung kasa daung yai garineya ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu ge awiya senu wari be 8 ayao aung yenu nung Petoroto Yohane aune Yakobo awong awiya puro isa sari sero diri witiwa ara. ");
INSERT INTO zia_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nung isa sinasani mitinu benaung nuna darawa yero benaung zo yenu taung wori nuna awiya waegairo neyang nibamu yena ara. ");
INSERT INTO zia_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ayero yenu sao tauyao ge pugaora maung Mose aune porofete baina Eliya awongto amimene nung aune dema mitasani ge ungwe nung eno newato ara. ");
INSERT INTO zia_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Awongto simao waegaore nunato aune dema buro Yesu mene Yerusalem atu magayari nena auna ungwe yewato ara. ");
INSERT INTO zia_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petoro otao nuna etore diti morenu auriti awinete iropuro Yesura simao waegaore aune emo etobe nung aune dema dopero mitiwato awiya gigiwa ara. ");
INSERT INTO zia_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Awongto Yesu doro babari newato giro Petoro mene Yesu eno eyero sena, “Gipao emo, name etu mitenane awiya iwaing. Arare nigasa nae kouboga etama sinanene — zo nina, zo Mosera, zo Eliyara.” Ayero sena ara. Arata Petoro nung oko giro baingtao nasani tebeba sena ara. ");
INSERT INTO zia_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nung ayero sinenu bereze zo mene awong worenu awong awang yewa ara. ");
INSERT INTO zia_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ayero newa ge zo bereze auna mokora atu eyero kasa yenu nigiwa, “Awiya Mani nana. Na nung puro burora zawang yewang. Niye ge nuna nigipu.” ");
INSERT INTO zia_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ge awiya aung yenu aune awong diti yero Yesu nata mitinu gigiwa ara. Arare awong be aune tani gigiwa, awiya emo zo eno oko sao dubo nunae-una atu mitaunu nauwa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Iya gainu awong diri doro wosiwa emo bauno dubu baina amimene buro Yesu nagibe atu tamuwa ara. ");
INSERT INTO zia_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ayero yewa emo bauno auna mokora emo zo mene wawa sero eyero sena, “Gipao emo, na isa ning eno sinena. Ning mani nana eno yo aung. Mani nana dekaongka gege. ");
INSERT INTO zia_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Iwae zo mene nung darauno noi ozaung be kerero noiya. Ayero noi iwae amimene nung dero musuna-masuna noi poro bera kisa-kisa yero nasani yaya bainakama tapunoi aune iwae nung dotinoiya. ");
INSERT INTO zia_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Arare na buro-mani nina mene iwae tunaese sero zi sero ayetena iwae tunero tetere teya.” ");
INSERT INTO zia_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ayero senu Yesu mene ge abena eyero sena, “O niye emo bauno meko, tumo diyao aung. Na be nazigo buro ninae eno taung dedunasani narineni? Mani nina puro nana-ina bung.” ");
INSERT INTO zia_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ayero senu nung mani nuna puro butunenu iwae mene augainu zuwenu puro awena-kawena yena ara. Arata Yesu mene iwae awiya gona yero mani awiya kora yero maung nuna eno nupema pugaina ara. ");
INSERT INTO zia_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ayero yenu emo bauno baina amimene Tuwa Bayaura putoung baina awiya giro yangka sero wawong di gamuwa arauwa. Awong tani ena yena auna kotung-katung nasani mitiwa Yesu mene buro-mani nuna eno eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Niye dawong yawero ge ewiya nigiro baingtipu. Awong Emora Mani puro pu emo dubura waweng garineya.” ");
INSERT INTO zia_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ayero sena, arata awong ge awiya oko gao. Awong eyero kotumuwa, “Nung emo tuwa naname siya sero sinenane aune magayaora ge siniya!” Ayero kotungno ge auna susuwa awiya gigiwa beu dena. Arata awong ge auna atata yao awang yero duwa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Buro-mani nuna mene, “Yesu mene emo tuwa naname yero nai aune naname-una awe mene baina yariniye?” auna sero zabu bumuwa ara. ");
INSERT INTO zia_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kotumao awiya nunae-una mokora atu mitinu Yesu gigina ara. Arare nung mani maingkoka zo puro nuna-una deungbera pugainu nung aune dema dopenu ");
INSERT INTO zia_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","nung awong eno eyero sena, “Emo zo nung mani maingkoka ewiya na kotungno kora yariniya, awiya nung na kora yetiya ayero yariniya ara. Ora emo zo nung na kora yariniya, awiya nung na iyengtinu bumuwang awiya kora yetiya ayero yariniya ara. Emo zo ninae-una towang atu nung nutope puro wosiro nariniya, nung amimene baina yariniya ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ayero senu Yohane mene eyero sena, “Gipao emo, nae emo zo mene yazo nina yau sinasani iwae tuninenu gigiwangne ara. Arata nung nae oko ago yao yero noiya, arare nung duwaise sewangne.” ");
INSERT INTO zia_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ayero senu Yesu mene nung eno eyero sena, “Niye nung duwaise oko sae. Zo nung iwo niye eno oko yao yariniya awiya otao ninae ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tuwa Bayau mene Yesu pumai witi uritira yaora be awiya nugu yena ara. Ayero yenu Yesu nung kotungno giro nung Yerusalem babari denena ara. ");
INSERT INTO zia_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Anasani giro nung emo ena iyengtinu gitau baungno nona nuna kora yari sero Samaria emora napo zora bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bamuwa emo napo auna amimene Yesu napo nunae auna babao awang sewa. Awiya noeno okowata, nung Yerusalem babari nasani nena. ");
INSERT INTO zia_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Awang sewa giro buro-mani etobe Yakoboto Yohane mene nung eno eyero sewato, “Tuwa, nae yausanane uritira atu iyao wosiro emo bauno ewiya awaise a kotupunesita?” ");
INSERT INTO zia_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ayero sewato Yesu kapete gairo awongto gona yena ara. ");
INSERT INTO zia_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Gona yero aune nung buro-mani nuna aune dema napo awiya doro napo zora bamuwa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Awong nagibe atu bautunewa emo zo mene nung eno eyero sena, “Ning natu natu babarinesa, awiya na teng ning ago yarinena.” ");
INSERT INTO zia_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ayero senu Yesu nung eno eyero sena, “Wo niniyang awong awao masire. Nupema ni mamani deka ayero awong uwangne. Arata na Emora Mani mene zo niyang koma apegairo oregao aung. Arare ning mena na ago yari oko sase.” ");
INSERT INTO zia_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ayero sero emo zo eno eyero sena, “Ning bung, na ago yase.” Ayero sena ara. Arata emo awiya eyero sena, “Tuwa, ning nigasa na gitau mama nana magayai mutero aune ago mene ning ago yane.” ");
INSERT INTO zia_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ayero senu Yesu mene nung eno eyero sena, “Saineba, emo ititi aung mene yaine yero nowa amimene magayao emo mutaese. Arata nine mene zo baungno Tuwa Bayau nata Tuwa yero nariniya auna ge bowi awiya sero gipero ayase.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ora emo zo mene nung eno eyero sena, “Tuwa, na ning ago yarinena. Arata ning nigasa na gitau baungno dubu nana wawong inane.” ");
INSERT INTO zia_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ayero senu Yesu mene nung eno eyero sena, “Zo nung Tuwa Bayaura buro gege yari sero kotungno giro dubo dekaongka gege yero yaise. Emo dubo eto nasani nowa amimene Tuwa Bayaura buro yaine yao teng oko yarineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ago Tuwa mene buro-mani seka 70 eto eto iyengtiti nasani baungno napo babuzere mamanikakare nung nutope ago babari kotupunena auna babaese sena ara. ");
INSERT INTO zia_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ayero sero awong eno eyero sena, “Nona bure atu zaungno mitiya, arata pumaora emo etoka gege. Arare niye pumao burora maung eno isa saya nung nona pumao emo ena tamai buro nuna auna babaese. ");
INSERT INTO zia_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Niye burora baungpu. Na niye iyengtitinena niye wo sipsip mani mamani ine yero eu sino miteya auna-una mokora babarineya, a gipu. ");
INSERT INTO zia_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Niye moni worireta ketewata te soga oko pumae. Niye nagibe atu emo bauno taungno wawong iniro ge ungwe oko yae. ");
INSERT INTO zia_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ora niye garo zora towari yero giro eyero sepu, ‘Emo bauno garo euna awiya Tuwa Bayaura gao mene nunae-una mitaise.’ ");
INSERT INTO zia_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ayero saya emo zo uritira gao pumari aratapunoiya amimene garo auna mitariniya, awiya gao ge sarineya awiya nuna-una atu me yariniya. Ora emo zo uritira gao pumari sero ara oko tapunoiya amimene atu mitariniya, awiya gao ninae nupema kapete ninae-ina gairo mitariniya. ");
INSERT INTO zia_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Niye garo dekaongka auna gege atu mitao masi ninae yero neupu. Atu nona minao oure niye eno pugaya giro awiya gege mininasani mitiungpu. Noeno okowata, buro emo awiya nung buro noiya auna zuma teng pumariniya ara. Niye garo zora witiro gaya meko yai giro doro garo zora oko towae. ");
INSERT INTO zia_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ora niye napo zora babaya awong niye otao yero nona niye eno pugarineya awiya puro minipu. ");
INSERT INTO zia_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Niye napo auna emo yayare awiya kora yero awong eno eyero sepu, ‘Tuwa Bayau nata Tuwa yero nariniya auna putoung awiya ninae-una kasa yari sero niya.’ ");
INSERT INTO zia_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ora niye napo zora babaya awong niye eno otao oko yao yaya giro niye baungno kakame atu dopero eyero sepu, ");
INSERT INTO zia_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Susuwa ninae meko awiya gaese sero nae napo ninae-una popo te nanae-una takasesiya awiya durere genane ninae-una babiya ara. Aeno niye susuwa ewiya giro baingtipu: Tuwa Bayau nata Tuwa yero nariniya auna putoung awiya ninae-una kasayeti niye oko pumao yeteya niye daigairo bautuniya.’ ");
INSERT INTO zia_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na niye eno sinena: Tuwa Bayau mene emo bauno awega-ziwega nasani abena pugariniya be aune napo Sodomna emo bauno abena mouyao tamarineya. Arata napo ge ninae awang sarineya amimene abena mou-mesa yao nibamu tamarineya. ");
INSERT INTO zia_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Oiye Korasin emo! Oiye Besaida emo! Mouyao bainakama ninae-una kasa yariniya. Na tani putoungne ena ninae-una atu yero nona awiya na napo Tayato Saidon auna atu yateni siya, awiya awong yemaoko dubo darawa yero pasena nunae kotungno dubo mininasani mo taung yiurire awiya awiro awetu suwero mitateya. ");
INSERT INTO zia_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tuwa Bayau mene emo bauno awega-ziwega nasani abena pugariniya be aune Tayato Saidon napora emo bauno mene abena wosao tamarineya. Arata ninae mene zo abena ninae bainakama tamarineya. ");
INSERT INTO zia_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ora niye Kapaneam emo, emo bauno mene yazo ninae de ika yarineita? Aung ara. Awong yazo ninae puro wosarineya.” ");
INSERT INTO zia_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu mene ge ayero sero buro-mani nuna eno eyero sena, “Zo nung ge ninae dimariniya, awiya nung ge nana dipunoiya ayero yariniya. Ora zo nung ge ninae awang sariniya, awiya nung ge nana awang sesiya ayero yariniya. Nupema zo nung ge nana awang sariniya, awiya nung Tuwa Bayau na iyengtinu bumuwang auna ge awang sesiya ayero yariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ago buro-mani 70 amimene yawa yawa nasani kapete gairo Yesu eno eyero sewa, ‘Tuwa, nae yazo nina yausero nasani buro yero nonane iwae dema ge nanae nigiro doro bautunowa.” ");
INSERT INTO zia_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ayero sewa nung awong eno eyero sena, “Sanda nung uritira atu zuwenu gigiwang, awiya nung bibiya papari noiya amimene wiwiri-weweri yero wosaine yena. ");
INSERT INTO zia_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Niye eyero nigipu. Na putoung niye eno pugena. Arare niye yire gogoyangne awiya pataya niye gera oko yarineya. Niye iwora putoung teng puro wosarineya ara. Ayero yaya nona zo mene niye oko gera yariniya. ");
INSERT INTO zia_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Arata iwae mene ge ninae nigiro doro bautunowa aeno yawa yawa oko yae. Aung ara. Niye Tuwa Bayau mene yazo ninae uritira atu gaenu mitoiya aeno yawa yawa yepu.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Be aune Oweno mene Yesura moko be bunu Yesu mene eyero sena, “O Mama, ning uritire tawingne auna Tuwa. Awong nuka nuyetope gosinowa emo baina yero noiya emo ayao amimene putoung nina-una susuwa gao eno, ning puingtinosa. Arata awong nuka nuyetope gosinowa mani wuire ine yero noiya awong eno zo keregatinosa. Arare na ning bowi nena. O Mama, ning ayero gege yari ara tapunosa, arare na ning bowi nena.” Nung ge awiya Maung eno sero aung yero aune eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Mama nana mene nona apakana awiya wawong nana-una pugaina. Emo zo mene na Mamana Mani auna susuwa awiya oko gosinoiya. Mama mene nata gosinoiya. Deka ayero emo zo mene Mamana susuwa oko gosinoiya. Na Mani mene nata gosinona. Ora na Mani mene Mamana susuwa emo ena eno gipinona awong amimene Mamana susuwa gosinowa.” ");
INSERT INTO zia_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ayero sero kapetegairo buro-mani nuna eno gege eyero sena, “Niye nona benaung seka gosinasani neya aeno yawa yawa yepu. ");
INSERT INTO zia_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Na niye eno sane. Gitau porofete daigairo aune emo tuwa daigairo awong amimene nona niye gosinowa awiya gari sero ara tapunasani nauwa, arata awong oko gao nawe mamagayewa. Awong ge niye nigitinowa awiya nigari aratapu nasani nauwa, arata awong oko nigao yero nawe mamagayewa.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Sao tauyao ge nigao emo zo mene iropuro Yesu gaero gari sero atata yero sena, “Gipao emo, na nono yero nao me iwaing awiya tamarineni?” ");
INSERT INTO zia_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ayero senu Yesu mene nung eno eyero sena, “Sao tauyao ge no sero gayao mitei? Ning zazagairo gosinosita?” ");
INSERT INTO zia_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ayero senu nung abena eyero sena, “Ara tamao nina bainakama awiya Tuwa Bayau nina auna-una mitaise. Ayero nasani dubore ititire putoungne kotumaore nina mene nung sou ye. Ora ning nitope ara tapunosa, deka ayero emo ena eno ye.” ");
INSERT INTO zia_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ayero senu Yesu mene nung eno eyero sena, “Ge abena awiya iwaing sinesa. Ning ayero yero nete nao me iwaing tamarinesa.” ");
INSERT INTO zia_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Arata sao tauyao ge nigao emo mene nung nutope yazo nuna yai iwaing yaise sero Yesu eno eyero sena, “Ora emo awe maze kora yanese sao mitiye?” ");
INSERT INTO zia_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ayero senu Yesu mene ge abena sari nasani ungwe eyero dina ara. “Emo zo Yerusalem doro Yeriko nape babari sero wosiro bautunenu emo memeko ena mene nagibe atu nung dewa magayari sero nenu nona nuna apakana sorero puro doro bamuwa ara. Ayero yewa nung magayari sero mitina ara. ");
INSERT INTO zia_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Be aune pirisa zo mene nagibo awiya ago yero wosiro bautunete emo awiya giro doro daigairo deungbera ziruyero baungna ara. ");
INSERT INTO zia_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ayero yenu pirisa dubura wawong mugo zo mene nagibe atu bautunete nuna-una atu kasa yero nung giro deka ayero daigairo deungbera ziruyero baungna ara. ");
INSERT INTO zia_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ayero yewato emo zo Samaria napora amimene nagibo deka auna atu bautunete emo awiya giro yo-amao baina nung eno tauna. ");
INSERT INTO zia_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ayero giro nung nuna-una nugu baungno nung iniro ou wain aune uweri awiya iso nuna-una atu yasagairo dowena ara. Ayero yero ininu iropunu wo dongki nuna auna tame pugainu adunu puro baungno esewa garora atu pugairo diya yena ara. ");
INSERT INTO zia_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ayero nenu iya gainu nung esewa garora maung eno kina etobe pugairo eyero sena, ‘Ning emo ewiya diya yero baingti. Ora moni nina nung eno duwarinesa awiya be na kapetegairo barinena aune moni nina abena pugarinena.” ");
INSERT INTO zia_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu mene ungwe awiya diro aune emo aeno eyero sena, “Ungwe diyena awiya nigiro nono kotupunesi? Emo dewa magayari sero mitina auna-una emo etama kasa yewa, nunae-una awe mene emo korayao emo yeni?” ");
INSERT INTO zia_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ayero senu sao tauyao ge nigao emo mene eyero sena, “Emo nung yo-auno soreuna amimene korayao emo me yena ara.” Ayero senu Yesu mene nung eno eyero sena, “Arare ning baungno deka ayero nasani neu.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu buro-mani nuna aune bautunete napo zora kasa yewa bauno zo yazo nuna Mata amimene nung puro garo nuna-una baungna ara. ");
INSERT INTO zia_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Matara yao yazo nuna Maria amimene buro Tuwara te nugu atu adungno ge nigitinasani mitina. ");
INSERT INTO zia_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Arata Mata mene zo nona minaora buro baina nasani kotumao gayang-gayang tauna ara. Ayero yero baungno Yesu eno eyero sena, “Tuwa, yao nana na doti na nata nona minaora buro nena, awiya gigesa teng nita? Ning nung se na soremae.” ");
INSERT INTO zia_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ayero senu Tuwa Yesu mene ge nuna abena eyero sena, “Mata, Mata, ning nona baina auna kotumao nina sisigati nesa moko nina meko niya. ");
INSERT INTO zia_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Arata nona dekaongka gege pumanenese sao ara. Maria nung nona iwaing ewiya pumari aratapuniya. Arare name nona iwaing awiya nuna-una atu oko sorero pumanene.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yesu nung agewa zora atu mitasani isa senu aung yenu aune ago buro-mani nuna zo mene nung eno eyero sena, “Tuwa, ning nae isa saora susuwa gipe. Gitau Yohane mene buro-mani nuna gipena, deka ayero gipase.” ");
INSERT INTO zia_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ayero senu nung awong eno eyero sena, “Be niye isa sari yero giro niye eyero sepu: O Mama, yazo nina dang mitaise. Bung, dubo sero tawing sero auna Tuwa nanae yase. ");
INSERT INTO zia_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ma nae eno wari be sero pugatinosa awiya yeme pugai. ");
INSERT INTO zia_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pasena emo ena mene nae eno yero nowa awiya yangdotinonane, aine ning pasena nanae yangdo. Nae etegaora atu oko pugase. Isa ayero sepu.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ayero sero awong eno eyero sena, “Na eyero gosinena. Ninae-una zo mene ping tuno-tano iropuro baungno otao nuna uwero eyero sariniya, ‘O otao, ning nona minao ena mitai giro na eno pugai. ");
INSERT INTO zia_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Otao nana zo nung nagibe atu ang nete yemeneka keune buro nana-ina kasa yetiya. Ayero yeti na nona minao aung ware na isa nina-una butunena.’ ");
INSERT INTO zia_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ayero sai garora maung mene abena eyero sariniya, ‘Ning na eno buro oko pugase. Garo be nana gazao ara. Nupema mani awiso nana na aune dema masira etu awineya ara. Arare na iropuro nona ning eno pugaine yao teng oko nena.’” ");
INSERT INTO zia_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yesu mene ayero sero susuuno eyero sena, “Na niye eno sana nigipu. Garo maung mene emo aeno, ‘Nung otao nana,’ asero oko iropuro nona pugariniya. Aung ara. Arata saineba, nung garo be nimoi-namoi deduni giro nung iropuro nona kau niya awiya teng nung eno pugariniya. ");
INSERT INTO zia_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Arare na niye eno sinena: Niye Tuwa Bayau eno isa sinete aune pumarineya. Niye kau yaora buro nete aune tamarineya. Niye isa ninae mene garo be daine nasani naya Tuwa Bayau mene nigariniya. ");
INSERT INTO zia_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Emo isa sinowa amimene pupunowa. Emo kauyaora buro nowa amimene me tapunowa. Emo isa mene garo be daine nowa auna isa awiya Tuwa Bayau mene nigitinoiya. ");
INSERT INTO zia_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ora ninae-una emo zora mani mene wo eno sai maung nuna mene yi meko mani eno pugarinita? Aung ara. ");
INSERT INTO zia_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ora mani mene maung nuna eno ni muzu zo nung eno pugaise sai gogoyang zo pugarinita? Awiya dema aung ara. ");
INSERT INTO zia_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Niye emo memeko-mameko mene mani awiso ninae eno nona iwaing pugatinowa. Arare eyero gosinonane: Mama uritira mitoiya amimene niye emo daigati nasani Oweno emo isa sinowa aeno pugariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Iwae zo emo zora-una toinu dau yero ge aung nasani nauna. Arare Yesu mene iwae awiya tunenu baungnu emo awiya Yesu aune dema ge wina-se yewato emo bauno witao mene giro wawong di gamuwa ara. ");
INSERT INTO zia_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Arata emo ena mene nung eno eyero sewa, “Nung iwae tuninoiya, awiya iwaera gitau yao Bielsebul auna putoungna tuninoiya ara.” ");
INSERT INTO zia_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ayero sewa, nupema emo ena mene putoung nuna atata yero uritira tani putoungne zo yai gari sewa. ");
INSERT INTO zia_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Arata nung kotumao nunae giro awong eno eyero sena, “Dubu zo gausero iwo wina-ye yarineya, awiya ago sisigairo aung yarineya. Ora ibu be zora mani awiso awong iwo wina-ye yero nete sisigairo aung yarineya. ");
INSERT INTO zia_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Arare Sanda mene soumani nuna eno iwo yero winade yati siya, awiya putoung nuna mene nono yero tauyero mitatiye? Niye na eno eyero sineya: Nane Bielsebulra putoungna iwae tuninona, asero nowa, ");
INSERT INTO zia_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","awiya ge ninae me siya, awiya mani awiso ninae iwae tuninowa amimene ana putoungna iwae tunatei? Awong Tuwa Bayaura putoungna iwae tuninowa, arare nunae mene ge iwao ninae auna susuwa keregarineya. ");
INSERT INTO zia_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Na Tuwa Bayaura putoung mene iwae tuninona, arare Tuwa Bayau nata Tuwa yero nariniya auna putoung ninae-una yemaoko kasa yero mitoiya. ");
INSERT INTO zia_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Susuwa nanato Sandato eyero mitiya era: Emo zo tauyero gi ami iniro garo nuna diya yariniya, awiya nona-owi nuna iwaing mitariniya. ");
INSERT INTO zia_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ayero nasani nai aune emo tau-tataware yao zo mene kasa yero emo awiya dero gi ami nuna tumo didinoiya awiya puro augariniya. Ayero yero aune nona-owi nuna awiya puro emo ena eno bono yariniya. ");
INSERT INTO zia_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Arare zo nung na otao oko yao yariniya amimene na eno iwo yariniya. Nupema zo nung na sorepunasani puro pu dekaongna gao buro nana oko yao yariniya amimene sisi-bura-bura yao buro yariniya. ");
INSERT INTO zia_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Iwae mene emo zora-una mokora atu kasa yero oregaora masi eu atu tamari babariniya. Baungno oko tamao nete giro eyero sariniya, ‘Garo nana doro bumuwang deka auna nupema kapetegairo babarinena.’ ");
INSERT INTO zia_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ayero sero baungno garo awiya sauno kora yeteya mitiya awiya gariniya. ");
INSERT INTO zia_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ayero giro baungno iwae otao mani 7 nung ine okowata, meko nibamu, awiya puro buro garo dekaongka auna toiro mitao-masi yarineya. Ayero yaya emo awiya gitau meko nasani nauna amimene meko yore nibamu yariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu ayero senu aune emo bauno mitiwa auna-una towang atu bauno zo mene be kerero eyero sena, “Ai nina ning puro ami gaena nung amimene yawa yawa yaise.” ");
INSERT INTO zia_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ayero senu Yesu mene eyero sena, “Ayao okowata. Emo bauno Tuwa Bayaura ge nigiro dipunasani nowa amimene yawa yawa yaese.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Emo bauno witao buro augatinewa nung awong eno eyero sena, “Emo bauno be yeme tawingna etu neya awong emo bauno memeko-mameko ara. Awong tani putoungne zo yana gari sinowa. Arata tani putoungne zo oko garineya. Tani gitau Yonana-una atu kasa yena deka ayero kasa yai garineya. ");
INSERT INTO zia_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Gitau Yona mene Tuwa Bayaura tani Niniwe emo bauno eno gipena, deka ayero na Emora Mani mene Tuwa Bayaura tani emo bauno be yeme tawingna etu neya aeno giparinena. ");
INSERT INTO zia_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tuwa Bayau mene emo bauno awega-ziwega nasani abena pugariniya be aune Siba tawingna bauno tuwa nung dema iropuro emo bauno be yeme tawingna etu neya auna susuwa keregai mouyao dimarineya. Noeno okowata, bauno tuwa amimene Solomonna kotumao bainakama awiya sai nigari taung dero tawing ometeoko auna atu buna ara. Arata na etu dopero mitena amimene Solomon daigatinena. ");
INSERT INTO zia_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tuwa Bayau mene emo bauno awega-ziwega nasani abena pugariniya be aune Niniwe emo bauno mene iropuro emo bauno be yeme tawingna etu neya auna tani meko nunae-una susuwa keregaya mouyao dimarineya. Noeno okowata, Niniwe emo bauno awong Yona mene Tuwara ge tugata yenu nigiro dubo darawa yewa. Arata na etu dopero mitena amimene Yona daigatinena. ");
INSERT INTO zia_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Name damana gaero garo wese atu kote wauno oko pugatinonane. Aung ara. Nupema au apero wese atu oko pugatinonane. Aung ara. Emo gare toitinowa amimene waegao awiya gaese sero name gerura atu ikogatinonane waegatinoiya ara. ");
INSERT INTO zia_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Diti moko nina awiya taung nina-una damana ine ara. Arare diti moko nina iwaing mitai aune taung aingso nina deka ayero iwaing waegaore mitariniya. Ora diti moko nina meko yariniya, awiya taung aingso nina apakana deka ayero mume yariniya ara. ");
INSERT INTO zia_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Arare waegao nina-una mokora mitiya awiya mume yoiye sero moko nina etutero diya ye. ");
INSERT INTO zia_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Taung aingso nina apakana waegao gege mitai agewa mume oko yariniya, awiya damana me mene waegati nasani name puro pu daung gatinoiya ayao ine yariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu ge awiya senu aung yenu aune Farisayo emo zo mene nung aune dema nona minaise sena. Senu giro nung Farisayora-una gare baungno tewora atu aduna ara. ");
INSERT INTO zia_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nung Yudara tani wawong sainasani nauwa awiya oko yao tebeba adungno nona gege mininu Farisayo emo amimene giginu teng oko yao yena ara. ");
INSERT INTO zia_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Arare Tuwa mene nung eno eyero sena, “Farisayo emo niye au-tao taung gege sainowa ara. Arata moko ninae ugaing yaora tani aune pasena yaora tani amimene bebumao ara. ");
INSERT INTO zia_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Niye emo dau ara. Tuwa Bayau mene taungne mokore eto deka ayero yena ara. ");
INSERT INTO zia_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Arata nona au-tao mokora miteya awiya niye puro emo bauno bogamasa eno pugaya aune nona ninae apakana awiya pewa yariniya ara. ");
INSERT INTO zia_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Arata niye Farisayo emo, niye gosinasani aune neupu! Niye Tuwa Bayaura sao tauyao ge dipunasani noiwangne tagorore zawingne yangtagairo pu dekaongna gatinowa dubu wawong etobe noi aune dekaongka Tuwa Bayau eno pugatinowa ara. Arata niye tani iwaing awiya daigatinasani Tuwa Bayau eno dubora mono pumao auna tani awiya oko yao nowa. Ora niye tani yero nowa awiya nasani ena sesena awiya dema yateya, awiya teng yatiya. ");
INSERT INTO zia_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Niye Farisayo emo, niye gosinasani aune neupu! Niye yere ibura atu emo baunona benaungna adumari arataungno yero nowa. Emo bauno mene kakame atu niye arugaese yawa yero nowa. ");
INSERT INTO zia_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Niye gosinasani aune neupu! Biriti tawing mokora mitoi emo bauno mene oko gaine nasani biriti tame ang yero taung beingtire yero nowa, biriti ayao ine awiya niye ara.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ayero senu sao tauyao ge gipao emo zo mene abena eyero sena, “Gipao emo, ning ge awiya sesesa nae dema gapuniya ara.” ");
INSERT INTO zia_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ayero senu Yesu mene abena eyero sena, “Niye sao tauyao ge gipao emo, niye gosinasani aune neupu! Niye sao tauyao ge ninae mou-mesa yao emo bauno eno pugatinowa dipunasani yaya tapunowa. Arata nika niyetope awong soreuno wawong zo oko pugatinowa aune awong nona mou-mesa yao awiya dipunowa. ");
INSERT INTO zia_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Niye gosinasani aune neupu! Porofete aya-ewowo ninae mene dewa mamaga-simaga yewa auna biriti nunae awiya ninae siuno amero yero baingtiro nowa ara. ");
INSERT INTO zia_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Aya-ewowo ninae mene porofete dewa mamaga-simaga yewa ninae porofetera biriti awiya siuno amero yero nowa. Ayero nasani aya-ewowo ninae-una pasena awiya gosinowa iwaing yero noiya, ayero niya ara. ");
INSERT INTO zia_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Arare Tuwa Bayau nigao iwaingne amimene niye eno eyero sena, ‘Na porofete aposolore iyengtana nunae-una babaya emo mene tunaya zanaya ena daya mamaga yarineya ara.’ ");
INSERT INTO zia_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Be tawing kasa yena auna atu zayero porofete dedunauwa mamaga nasani nauwa auna abena awiya emo bauno yeme tawingna etu neya auna-una atu kasa yaise sero Tuwa Bayau mene ayero sena. Awiya Abel dewa magayena auna atu gorobo zayena awiya bao gege butunawe dunu aune Zekaraya aita tumana atu dewa magayena ara. Arare na memokoba sinena. Porofete dewa auna abena awiya emo bauno yeme tawingna etu neya auna-una atu kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Niye sao tauyao ge gipao emo, niye gosinasani aune neupu! Ge porofete mene sero gainasani nauwa awiya niye emo bauno eno oko keregairo baingtao yero nowa, arare niye nao me tamaora ki yemaoko zokero puro nowa ayero niya ara. Arata niye nika niyetope nao me iwaing auna gare oko towao nasani aune ena mene towari yero nowa giro gazinowa ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu garo doro kasa daung yero nenu sao tauyao ge gipao emo aune Farisayo emo awong tau-tataware yero nung ge tebe-tabe saise atata daigairo yewa. ");
INSERT INTO zia_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ayero nasani nung etutinasani dawong yawero ge zo sai gaya meko yai giro nung kara gera pugari sero yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Emo bauno witao-nibamu amimene augairo gikisero te wina-pati newa be aune Yesu mene gitau buro-mani nuna eno eyero sena, “Farisayora yis awiya suwaye ninae-una goiye sero umo yero baingtiti nasani neupu. Awong me sao nasani aune moko meko puro nowa ara. ");
INSERT INTO zia_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nona apakana pungyao mitiya awiya ago kasa daung yariniya. Nona apakana dowao miteya awiya ago emo bauno mene garineya. ");
INSERT INTO zia_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Niye ge mumene pungyero sinowa awiya ago emo bauno mene warire nigarineya. Niye garo mokora atu ge gugumamane didinowa awiya ago emo bauno mene kakame atu dopero wawa sero ge sarineya arauwa. ");
INSERT INTO zia_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Otao mani nana, na niye eno sane. Taung aingso ninae gege daya magayarineya, arata auna tame nona zo niye eno yari sero putoung kau yarineya, awong awiya oko awang yae. ");
INSERT INTO zia_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Niye emo awe maze awang yarinei, awiya na niye eno giparinena. Niye emo nung emo dai magayai au kowa iyaore auna gaora putoung nuna-una mitiya, nung awiya awang yepu. Meba sinena ara. Niye emo awiya awang yepu. ");
INSERT INTO zia_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Niye gipu. Emo bauno awong maket nasani ni nisokiyang wawong zo awiya toya etobe mene zuma gainowa. Arata Tuwa Bayau nung ni mani mamanikaka zo oko nuwegatinoiya ara. ");
INSERT INTO zia_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nung giti ai ninae apakana zazagairo gosinoiya. Niye awang oko yae. Ni nisokiyang daigairo auna zuma awiya baina aung. Arata ninae mene zo zuma bainane. ");
INSERT INTO zia_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Arare na niye eno sane. Zo nung emora-una benaungna atu, ‘Na Yesura mani yero nona,’ ayero sariniya, awiya na Emora Mani mene deka ayero Tuwa Bayaura angelo dubura-una benaungna atu, ‘Nung awiya mani nana,’ ayero sarinena. ");
INSERT INTO zia_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ora zo nung emora-una benaungna atu na bewae yariniya, awiya na Tuwa Bayaura angelo dubura-una benaungna atu abena nung bewae yarinena. ");
INSERT INTO zia_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Zo nung na Emora Mani eno ge meko sariniya, awiya Tuwa Bayau mene pasena awiya disariniya. Arata zo nung Oweno izariniya emo auna pasena awiya disao ine teng oko ara. ");
INSERT INTO zia_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ora awong niye puro baung Tuwa Bayaura ibura yero diya emo aune emo yazore auna benaungna pugaya niye awong giro awang yero eyero oko kotungpu, ‘Name abena awong eno nono sarinenine? Name ge no sarinenine?’ Ayero oko kotumae. ");
INSERT INTO zia_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Niye gera pugaya aune ge Oweno mene niye eno gipariniya awiya sarineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Emo bauno dubu baina awong auna zo mene Yesu eno eyero sena, “Gipao emo, ning sasa tato nana mene mama nanato-una nona awiya bono yero na agewa pugaise sinena.” ");
INSERT INTO zia_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ayero senu Yesu mene nung eno eyero sena, “Awiya nono yao i? Awe mene na zaz ninae yero nasani nona ninae bono yanese seni? Aung ara.” ");
INSERT INTO zia_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ayero sero awong eno eyero sena, “Niye gosinasani aune neupu! Niye nona apakana aeno dubo-dubo oko yepu. Emo waure amimene wau moni nuna auna nao iwaing oko pumariniya.” ");
INSERT INTO zia_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ayero sero awong eno ge eniya zo eyero sena, “Emo waure auna minao bure zaungna ara. ");
INSERT INTO zia_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ayero yenu wau emo nung eyero kotuna, ‘Na nono yarineni? Na nona nana witao euna garo aung.’ ");
INSERT INTO zia_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ayero sinasani sena, ‘Na eyero yarinena. Na nonana garo nana apakana kasero nupema babuze yarinena. Ayero yero na wuitre nona nana iwaing ena dema garo auna atu gurutu yarinena. ");
INSERT INTO zia_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ayero yero aune na eyero kotumarinena: Nona nana witao dawang daigairo auna teng mitiya. Arare na yeme oregarinena. Na nona miniro ou miniro yawa yawa nasani mitarinena.’ Wau moni emo mene ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Arata Tuwa Bayau mene eyero sena, ‘Ning emo dau ine ara. Ning ping yeme eune magayarinesa. Ayasa nona apakana sosetesa mitiya awiya zo mene pumariniya.’ Ayero sena ara.” Yesu mene ungwe awiya diro aune eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Zo nung taungna zamena simena gurutu yero puro nasani aune Tuwa Bayaura benaungna atu dubora wau moni oko gurutu yariniya, awiya tani deka ayao ine nuna-una atu kasa yariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu mene buro-mani nuna eno eyero sena, “Arare na niye eno sana nigipu. Niye nao ninae eno kotung-katung nasani eyero oko sae, ‘Nona minao natu tamarinenine?’ Nupema niye taung aingso ninae eno kotung-katung nasani eyero oko sae, ‘Taung wori natu tamarinenine?’ Ayero oko sae. ");
INSERT INTO zia_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nona minao mene me oko niya. Nao mene me niya. Nupema taung wori mene me oko niya. Taung aingso mene me niya. ");
INSERT INTO zia_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Niye ni owa kotungpu. Awong nona minao puro urero nasani oko yero nowa. Awong nona minao gurutu yaora garo awiya aung ara. Tuwa Bayau mene nona minao awong eno pugatinoiya ara. Arata niye emo bauno mene zo ni mamani daigatineya ara. ");
INSERT INTO zia_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ora ninae-una zo mene nao nuna eno kotung-katung nasani nete wari be ena tawingna nao nuna susumaise nupema susumai teng yarinita? Aung ara. ");
INSERT INTO zia_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Niye buro maingkoka ayero yao ine teng oko ara. Arare niye noeno buro baina awiya eno kotung-katung yero nowi? ");
INSERT INTO zia_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Niye i wuzi yero ditinoiya auna susuwa awiya kotungno gipu. Awong asino aimaora buro oko yero nowa. Nupema mo gayaora buro oko yero nowa. Arata na niye eno eyero sinena: Gitau emo tuwa Solomon mene taung nuna siuno amero yero baingtiti nasani nauna, arata siuno amero yao nuna mene i wuzira simao awiya oko daigaina. ");
INSERT INTO zia_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","I wui yeme eu atu iwaing iro ditiniya, arata awiro gora awiya emo mene wezero igiyari neya ara. Arata saineba, Tuwa Bayau mene sinoi simao iwaingne kasa yero Solomonna simao iwaing awiya daigatinoiya. Tuwa Bayau mene ayero noiya, arare nung noeno niye eno mo taung worire oko tamao yariniye? O tumo diyao besaore niye, nung niye mo taung worire iwawaing tamariniya. ");
INSERT INTO zia_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Arare niye nona minaore oure auna kotung-katung oko yae. Niye dubo eto oko yae. ");
INSERT INTO zia_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tawing euna diga emo awong kotung-katung nona ena tamaora yero nowa ara. Arata Maung ninae mene nona minaese yero noiya awiya gosinoiya. ");
INSERT INTO zia_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Iwaing nibamu awiya niye Tuwa Bayaura nao seka tamari kotumaya aune nung auna tame nona ena dema niye eno pugariniya arauwa. ");
INSERT INTO zia_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Dubu maingkoka niye, niye awang oko yae. Maung ninae mene nao sekawa niye eno pugari mena senu tauyena. ");
INSERT INTO zia_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Niye nona ninae apakana monina pugairo moni puro moni awiya emo bogamasa soreuno awong eno pugaipu. Niye moni sisigairo aung yao ine teng oko awiya tamari yepu. Ayero nasani naya Tuwa Bayau mene uritira atu nona ipu ewa-gaewa yao sisigairo aung yao ine teng oko awiya niye eno pugariniya. Ugaing emo uritira oko miteya. Atu nona ziri oko dedunoiya. ");
INSERT INTO zia_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Masi wau nina mitoiya, masi deka auna atu dubo nina mitariniya. ");
INSERT INTO zia_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Niye geing ipura diro aune damana ninae gaero kora makora nasani mitiungpu. ");
INSERT INTO zia_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Soumani ena awong emo tuwa nunae mene ana-bonene doro kapetegairo garo be dai mena iwari miteya ayao ine niye mitiungpu. ");
INSERT INTO zia_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Emo tuwa mene buro soumani nuna oko auriti awao seka yero mitaya gariniya, awiya awong yawa yawa yarineya. Na memoko nibamu niye eno sane. Emo tuwa nung nutope soumaina mo nona saora awiya wosogairo awong apara adumaese sariniya. Ayero yaya nung nutope buro nona minao awong eno pugariniya. ");
INSERT INTO zia_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nung ping towang singsang gairo barinita ping tuno-tano aune buro soumani seka yero mitaya gariniya, awiya soumani awong yawa yawa yarineya. ");
INSERT INTO zia_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Arata niye nona ewiya kotungpu: Garo maung mene ugaing emo baora be nuna gatiya, awiya nung diti seka yero mitasani garo nuna diya yero baingtai ugaing emo oko towatiya. ");
INSERT INTO zia_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Na Emora Mani mene barinena, awiya na oko barinenita ayero sero naya be aune na barinena. Aeno niye sosero benero nasani neupu.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petoro mene Yesu eno eyero sena, “Tuwa, ge eniya nae eno gege sinesita emo bauno apakana aeno sinesi?” ");
INSERT INTO zia_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ayero senu Tuwa mene eyero sena, “Niye soumani iwaing yero neupu. Soumani iwaing nung kotumao iwaing puro nai giro emo tuwa nuna mene nung soumani nuna apakana diya yaise sariniya. Nung awong diya nasani wo ma awong eno pugatinaise sariniya. Emo tuwa nuna mene buro ge awiya nung eno pugairo doro baungno nariniya. ");
INSERT INTO zia_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Arare soumani amimene buro nung eno sao awiya teng dipunasani nai, emo tuwa nuna mene kapetegairo buro buro nuna-una me giro tani iwaing nung eno yai yawa yawa yariniya. ");
INSERT INTO zia_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Na meba niye eno sinena. Emo tuwa nuna mene diya buro baina nung eno pugatinasani nona nuna apakana diya yaise sariniya. ");
INSERT INTO zia_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Arata soumani mene eyero sariniya, ‘Emo tuwa nana mena oko kapetegariniya. Nete ago kapetegairo barinita nowa.’ Ayero sinasani nung zayero sou emore baunone dero usi-besi nasani ana-bonene nasani ou tauyao mininasani anasani dau yariniya. ");
INSERT INTO zia_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ayero nasani emo tuwa kapetegaora be nuna oko gao nasani ‘Nung mena oko kapetegariniya’ ayero sinasani nai emo tuwa nuna mene kapetegairo bumariniya. Buro soumani awiya yanakana wezero dero emo tumo diyao aung abena tamarineya masi deka auna pugariniya. ");
INSERT INTO zia_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Soumani nung emo tuwa nuna auna buro ge gosinoiya, arata nung nona oko sosao yero emo tuwa nuna auna buro ge awiya oko dimao yariniya, awiya emo tuwa mene nung meko nibamu dariniya. ");
INSERT INTO zia_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Arata soumani nung emo tuwara buro ge awiya oko gao nasani abena meko tamaora nona yariniya, awiya emo tuwa nuna mene nung maingkoka gege dariniya. Emo zo eno nona bainakama pugarineya, awiya nung abena bainakama pugaise sarineya. Nupema emo bauno mene emo zora waweng atu nona witao pugarineya, awiya nung abena witao nibamu pugaise sarineya. ");
INSERT INTO zia_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Na bumuwang, awiya tawing iyao gamoyana awaise bumuwang. Arare mena awaise ayero kotupunena. ");
INSERT INTO zia_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Na yaya tame nanese sao mitiya, awiya ou buro tawing topetitiniya ayao ine yaya mene na topetariniya. Yeme na yaya auna buro oko yao, arata kotupunena moko nana mou-mesa niya ara. ");
INSERT INTO zia_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Niye nane buro tawingna dung gere winadere dana amaise kotupunowita, nowa. Arata ayao aung ara. Na niye eno sane. Na bumuwang, awiya emo bauno gagausari bumuwang ara. ");
INSERT INTO zia_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yeme euneta ago oune emo bauno wawong zo garo dekaongna mitarineya, awiya gausero dubu etobe yarineya. Etama awiya iwo etobe eno yarineya. Nupema etobe awiya iwo etama eno yarineyato. ");
INSERT INTO zia_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Awong eyero gagausarineya: Maungne mani emodi nuna aune awongto iwo wina-ye yarineyato; ai mani baunodi nuna aune awongto iwo wina-ye yarineyato; maingna aro ai imeti nuna aune iwo wina-ye yarineyato.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu mene emo bauno eno eyero sena, “Niye bereze siwingyao dodopinoi giro mena eyero sinowa, ‘Wa wosariniya.’ Ayero sinowa wa wowosinoiya. ");
INSERT INTO zia_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Deka ayero soma gori ziwinoi giro niye eyero sinowa, ‘Gora wari baina posariniya.’ Ayero sero nowa me yero noiya. ");
INSERT INTO zia_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Niye ge iwao emo me sao yero nowa! Niye tawingne berezera owe auna susuwa giro baingtitinowa. Arata niye nono yero be yeme euna susuwa oko giro baingtao yero nowi? ");
INSERT INTO zia_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Tani iwaing yaese sao awiya niye nika niyetope nono yero oko wuyero gao yero nowi? ");
INSERT INTO zia_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Otao nina zo mene ning gera pugairo kotora babasese sariniya, awiya ning bere-bere nung aune dema kaunsolra-una baungno ge awiya sero kora yeputo aung yae. Ayero oko yao yarinesa, awiya nung ning puro zaz emora-una babai zaz emo mene ning puro pu polisra-una gai awong ning puro pu bunao gare garineya. ");
INSERT INTO zia_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na niye eno sane. Ning bunao garo tebeba oko duwarinesa. Ning gitau otao nina auna abena apakana pugairo aung yero aune kasa daung yarinesa.” Yesu mene name ge nuna bere-bere niganenese ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Be aune emo ena mene Yesura-una kasa yero eyero sewa, “Galilaya emo ena mene wo dero aero puro Tuwa Bayau eno zawing pugari sero newa aune Pilato mene ge senu gorobo emo ena mene baungno Galilaya emo awiya dewa magayewa yu nunae zawingna tame yasagaina.” ");
INSERT INTO zia_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ayero sewa Yesu mene abena eyero sena, “Niye awong eno eyero sineita nowa, ‘Pasena nunae mene emo enana pasena daigairo mitina, aeno ayero magayewa.’ ");
INSERT INTO zia_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ayero oko sae. Arata niye dubo oko kapetegao yarineya, awiya niye dema sisigarineya. ");
INSERT INTO zia_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Arata emo 18 gitau Siloam atu garo tura tamere gamao amimene durero wosiro denu mamagayewa, awiya pasena nunae mene emo ena Yerusalem mitauwa auna pasena nunae daigaina aeno magayewa, ayero sinowita nowa. ");
INSERT INTO zia_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ayero oko sae. Ora niye dubo oko kapetegao yarineya, awiya niye dema sisigarineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu mene ge eniya zo eyero sena, “Emo zo gitau i fik awiya i buro nuna-una atu urenu mitauna. Mitawe dunu nung me ena pumari buna, arata me aung ara. ");
INSERT INTO zia_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ayao giro aune buro-mani nuna zo eno eyero sena, ‘Sana nigi. Na buro i fik me pumari kau nasani nete dotena dawang etama aung yetiya. Arare yete aung yae. Noeno okowata, i amimene tawingna gawi puro aung yero noiya.’ ");
INSERT INTO zia_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ayero senu buro-mani mene ge abena nung eno eyero sena, ‘Emo tuwa, ning yangdo mitai dawang euna mokora atu na tawing i susuwara dero baungno gapuro puro buro pugairo ayana yai gane. ");
INSERT INTO zia_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Dawang ago oune me iyariniya, awiya iwaing ara. Arata me oko iyao yariniya, awiya sasa yetarinena.’” Yesu mene ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabat iya zore Yesu mene emo bauno yere ibura atu ge tugata nena. ");
INSERT INTO zia_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Bauno zo atu mitina, awiya iwae zo mene nuna-una mokora atu mitasani yaya nung eno pugainu meko yero mitawe dunu dawang 18 aung yena. Bauno awiya bisa gurutusao, arare nung oko dopero baingtiro nauna. ");
INSERT INTO zia_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu mene bauno awiya giro yausenu bunu eyero sena, “Bauno, yaya nina aung yetiya.” ");
INSERT INTO zia_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ayero sero wawong paka baunona-una tame yenu bisa nuna korosena. Ayero yenu bauno amimene Tuwa Bayaura yazo de ika yena ara. ");
INSERT INTO zia_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kora yena aeno yere ibura gitau yao emo tini kapao Yesu eno puna. Noeno okowata, nung Sabat iya aune bauno awiya kora yena. Arare gitau yao emo mene emo bauno eno eyero sena, “Buro yaora be 6 mitiya. Arare niye be aune bungpu korayae. Arata niye Sabat iya bera atu ayao oko yero yae.” ");
INSERT INTO zia_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ayero senu Yesu mene ge abena eyero sena, “Niye ge iwao emo me sao yero nowa! Niye apakana Sabat iya aune bulimakaota dongki ninae gare atu buninowa mitima nowa awiya besero puro baungno nowa ou miniro nowa. ");
INSERT INTO zia_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Arata bauno ewiya nung Abrahamna saisibuna zo, awiya Sanda mene yemaoko bunenu dawang 18 ayao aung yena. Arare na nung iya dang be eune besetena awiya nono yero gigeya meko niye?” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ayero senu emo iwo nuna awiya meng gaiwa ara. Ayero yewa emo bauno mene nung buro apakana yenu iwaing gege yena auna yawa yawa yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu mene ge zo susuuno eyero sena, “Tuwa Bayau nata Tuwa yero nariniya auna susuwa awiya nona no ine ing? Na nouna pugairo sarineni? Susuwa awiya i zo mastet asero nonane auna me ine ara. ");
INSERT INTO zia_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Emo awong mastet me maingkoka nibamu zo puro baungno buro nunae-una atu urinowa. Awiya ago bairo bainakama yero i zo ine yero noiya. Ayero noi ni mamani mene buro i auna bowangna atu uwang gapunowa.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ayero sero nupema eyero sena, “Tuwa Bayau nata Tuwa yero nariniya auna susuwa awiya na nouna pugairo sarineni? ");
INSERT INTO zia_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Awiya yis ine. Bauno zo mene tao baina zora atu plawa yisre pugairo dawenu yis toiro plawa punu titisena.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu mene Yerusalem babari sero bautunete napo babuzeta mamanikaka auna teng bautu nasani uritira ge tugata-magata nasani baungna ara. ");
INSERT INTO zia_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Bautunenu emo zo nung eno eyero sena, “O Tuwa, Tuwa Bayau mene mani etoka gege sorero pumarinita?” Ayero senu Yesu mene awong eno abena eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Niye uritira garo be maingkokaka auna towari sero di gigi-gagi yero wetu wawongne tu diro kosopuro towae. Na niye eno meba sinena. Emo bauno daigairo mene atu towari yarineya, arata teng oko yarineya. ");
INSERT INTO zia_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ago garo auna Maung nung iropuro garo be awiya gazai aune niye buro daung dopero garo be dero yausero eyero sarineya, ‘Tuwa, ning garo be nae eno iwe.’ Ayero saya nung ge abena eyero sariniya, ‘Niye nami nei? Na niye oko gosinena.’ ");
INSERT INTO zia_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ayero sai niye eyero sarineya, ‘Nae gitau ning aune dema nona tao dekaongkara mininasani naungwane. Nupema gitau ning napo nanae-una atu dopero nae gipinauwasa.’ ");
INSERT INTO zia_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ayero saya nung niye eno eyero sariniya, ‘Niye nami nei? Na oko gosinena ara. Niye awiya pasena emo ara. Niye na doro baungpu!’ Ayero sariniya. ");
INSERT INTO zia_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Niye gipu. Abraham, Isaka, Yakobo aune porofete apakana awong amimene Tuwa Bayaura-ina mokora mitaya garineya, arata niye esegaya niye daung mitasani zi aiyo gatiyo nasani mitarineya. ");
INSERT INTO zia_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Emo bauno agewa wari witaorata wari wosaora, ora ikata enaka auna atu buro Tuwa Bayaura nape toiro adungno nona minarineya. ");
INSERT INTO zia_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Arata emo gitau neya auna ena mene ago yarineya. Nupema ago neya auna ena mene gitau yarineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Yesu mene ayero sinenu be deka aune Farisayo ena mene kasa yero nung eno eyero sewa, “Herode mene ning dari siniya, arare ning napo ewiya doro agewa zora babase.” ");
INSERT INTO zia_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ayero sewa Yesu mene awong eno eyero sena, “Niye baungno eu sino meko aeno eyero sae: Yeme ta gora mene na iwae tuninasani yaya emo kora yarinena. Ayero yero gora mitete wari zo oune na buro nana besugarinena. ");
INSERT INTO zia_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yeme ta gora ta ogora aune na ang yero Yerusalem babarinena. Noeno okowata, awong porofete Yerusalem nape atu gege daya magayai teng yariniya. ");
INSERT INTO zia_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O Yerusalem emo bauno, Yerusalem emo bauno. Niye porofete dedunowa maga yero nowa. Nupema ge emo Tuwa Bayau mene iyengtitinoi ninae-ina butunowa awong awiya daba mene dedunowa maga yero nowa. Kokora ai mene mani awiso nuna wati wese pugairo sanitinoiya, deka ayao ine nane emo bauno niye puro pu dekaongna gari yero nona niye awang nowa. ");
INSERT INTO zia_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tuwa Bayau mene napo ninae dotiniya, awiya gipu. Nupema na ge zo sana nigipu. Niye na oko gao nasani nete eyero sinasani aune na nupema garineya, ‘Tuwara bera butuniya, nung awiya bowi yanene.’” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat iya be zore Yesu mene baungno Farisayo emo gitau yao zo auna gare atu nona minari sero baungno mitinu nung Sabat iya be awiya sisigai gari sero etuti nasani mitiwa. ");
INSERT INTO zia_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Atu mitiwa emo zo karuwitao awiya Yesura-ina nugu kasa yenu gigina. ");
INSERT INTO zia_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Giro nung sao tauyao ge gipao emo aune Farisayo aeno eyero sena, “Name emo yayare awiya Sabat be aune kora yarinenineta aung ing?” ");
INSERT INTO zia_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ayero senu awong abena ge oko sao mitiwa giro nung emo awiya kora yero iyengtinu baungna. ");
INSERT INTO zia_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ayero yero aune awong eno eyero sena, “Ora ninae-ina emo zo mene nung mani nuna zota bulimakao zo Sabat iyare ou wamao zo auna gutai nung kara mena sero watimarinita?” ");
INSERT INTO zia_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ayero senu awong ge abena sao awiya teng oko yero ge aung yewa. ");
INSERT INTO zia_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu nung emo nona nung aune dema minari bumuwa awiya gigina. Awong nona baina minari ara tamuwa. Ayero yewa giro nung awong eno eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ning emo zo mene aro ataora ana-bonene yero ning yausai baungno giro nona baina oko puro minase. ");
INSERT INTO zia_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nona baina puro minarinesa, awiya emo zo yazo bainane kasayai aune bonenena maung mene nona baina puro buro ning daigairo emo yazore aeno pugariniya. Ayero yai ning meng baina gatinasani diyasa gagazai borabora yero mitarinesa. ");
INSERT INTO zia_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Aeno emo zo ning nona minaora yausariniya, awiya ning baungno nona maingkoka gege puro mini. Ayero yasa aune bonenena maung mene buro ning eno nona memani pugariniya. Ayero yai aune emo nona mininasani miteya amimene ning gaya emo yazore yarinesa. ");
INSERT INTO zia_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Zo nung nutope taung puro witariniya, awiya Tuwa Bayau mene nung puro wosariniya. Arata zo nung wosiro nariniya, awiya Tuwa Bayau mene yazo nuna de ika gariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu mene emo nung buro nona minaise yausena aeno eyero sena, “Ning nona maingkokata nona baina yero emo yumari yero giro otao mani, meta mani, didikaing, nebu ena wau monine awong awiya oko yausase. Ayero yasa awong amimene ago abena yausaya ning baungno garo nunae-una atu nona minasa abena nina aung yariniya. ");
INSERT INTO zia_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ayero oko yase. Aeno ning ana-bonene baina yero giro emo bogamasa, emo taung meko yao, te gimaota diti guma yao awong awiya yause. ");
INSERT INTO zia_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Emo a yetugao amimene nona nina abena yao ine teng oko ara. Aeno ning yawa yawa yarinesa. Ago emo bauno iwawaing magayaora atu iroparineya be aune Tuwa Bayau mene nona nina abena pugariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Emo Yesu aune dema nona mininasani mitiwa auna-una zo mene ge awiya nigiro nung eno eyero sena, “Zo nung Tuwa Bayau nata Tuwa yero nariniya auna nape atu nona minariniya amimene yawa yawa yariniya.” ");
INSERT INTO zia_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ayero senu Yesu mene ungwe zo nung eno eyero dina, “Emo zo nung ana-bonene bainakama yari nasani be pugairo emo daigairo mene buro nona minaese sena ara. ");
INSERT INTO zia_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Arare ana-bonene yaora be bunu soumani nuna zo iyengtinu ge puro baungno emo gitau baese ge pugainu baungna auna-una baungno awong eno eyero sena, ‘Niye bungpu. Nona apakana sairo zuwero yero sosetenane mitiya.’ ");
INSERT INTO zia_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ayero senu awong apakana amimene iropuro esega burora yewa. Ayero nasani emo zo nung eno eyero sena, ‘Na bumatena, arata na tawing seka zo zuma gaetena, arare na baungno garinena. Ning baungno emo tuwa nina eno sasa gai meko oko yae.’ Ayero senu zo deka ayero sena, ");
INSERT INTO zia_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","‘Na bumatena, arata na bulimakao wawong eto zuma gaetena mitiya, aeno na baungno wo ami buro yaya gari bautunena. Ning baungno emo tuwa nina eno sasa gai meko oko yae.’ ");
INSERT INTO zia_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ayero senu zo mene eyero sena, ‘Na yeme yemeneka bauno seka atetena, arare na baine yao awiya teng oko nena.’ ");
INSERT INTO zia_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ayero sewa buro-mani yesese yero baungno emo tuwa nuna eno ge sewa deka ayero sena. Ayero senu garora maung mene tini kapenu buro-mani nuna eno eyero sena, ‘Ning mena baungno napo bainana nagibo babuzere mamanikakare auna baungno emo bogamasa, emo taung meko yao, emo diti guma yao, emo te meko yao awong awiya puro bumasa garo nana euna towae.’ Ayero senu buro-mani mene baungno nete aune kapetegairo buro eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","‘Tuwa, na ge nina diungno besugena, arata adumao masi ena tebeba miteya.’ ");
INSERT INTO zia_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ayero senu emo tuwa mene buro-mani eno eyero sena, ‘Ning napo baina auna bautara baungno nagibo mamanikaka napo sero babao auna atu emo bauno yuno puro basa towaya garo nana bebumae. ");
INSERT INTO zia_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Na ning eno sinena. Emo apakana gitau yau sewang amimene ana-bonene nana oko minarineya.’” Yesu mene ungwe awiya diro aung yena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Emo bauno dubu bainakama awong Yesu aune dema ang yero bautunete aune Yesu mene kapetegairo awong eno eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Emo zo nana-una buro na aune dema nari yero giro nung ai maungta bauno mani awisoreta metamani nu ai-amonone nupema nao nuna dema oko pu bautara gao yariniya, awiya nung mani nana yero nao ine oko mitiya. ");
INSERT INTO zia_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Zo nung dubo minaore yaya tamaore auna i pasao nuna diungno na oko ago yao yariniya, awiya nung mani nana yero nao ine oko mitiya. ");
INSERT INTO zia_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ninae-ina zo mene garo bainakama zo yari yero giro nung gitau adungno zuma garora kotungno moni nuna giro eyero sariniya, ‘Moni nana teng nita teng oko yao i?’ Awiya nung gitau ayero oko yao yariniya, awiya ago nung ziwong pugairo garo awiya yero aung yao ine teng oko yao yai aune ");
INSERT INTO zia_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","emo bauno apakana amimene nung giro sero izayarineya. ");
INSERT INTO zia_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ayero nasani nung eno eyero sarineya, ‘Emo emimene garo awiya zayetiya, arata nung oko yero aung yariniya.’ ");
INSERT INTO zia_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Emo tuwa zo mene emo tuwa zore winade yari yero giro gitau adungno eyero kotumariniya, ‘Gorobo emo nana 10,000 amimene iwora gorobo emo 20,000 aune dema winade yaya teng yarinita aung ing?’ ");
INSERT INTO zia_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ayero kotungno gai teng oko yao yai giro iwo ake mitaya aune nung mono pumaora ge buro yari sero mani zo iyengtai iwora-una babariniya. ");
INSERT INTO zia_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Arare ninae-ina zo mene nona nuna pu bautara oko gao yariniya, awiya nung mani nana yero nao ine oko mitiya. ");
INSERT INTO zia_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Biyoung awiya nona iwaing. Arata biyoung mege aung yariniya, awiya name nono yanane aune mege nuna nupema kasayariniye? ");
INSERT INTO zia_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Biyoung ayao ine amimene tawing gawi pugaine yao teng oko. Nupema biyoung awiya tawing gawi pugaise naname bulimakaora ze aune dema gurutu yanane teng oko yariniya. Name tebeba augatinonane ara. Zo nung dawongne mene ge ewiya nigaise.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takis pumao emo aune pasena emo awong witao amimene ge nigari Yesura-ina nugu bumuwa. ");
INSERT INTO zia_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Arata Farisayo aune sao tauyao ge gipao emo awong amimene Yesu gigiwa meko yenu gugumama sinasani eyero sewa, “Emo awiya nung pasena emore otao nasani nona dema mininasani nowa.” ");
INSERT INTO zia_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ayero sewa giro Yesu mene ge eniya awong eno eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ninae-ina emo zora lama 100 auna zo tara yariniya. Ayero yai lamana maung amimene lama 99 awiya duwai nona mininasani agewa zora atu mitaya nung lama tara yetiya awiya tamari sero buro yariniya. Buro yero bautunete taungno ");
INSERT INTO zia_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","puro pu augape gairo yawa yawa nasani puro kapete gairo bariniya. ");
INSERT INTO zia_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Puro buro garo nuna-una kasa yero otao nuna aune napo tayao nuna awiya yausai nuna-una bumaya aune awong eno eyero sariniya, ‘Na lama nana zo tara yetiya awiya taungno puro bena, aeno niye na aune dema tairo yawa yawa yepu.’” ");
INSERT INTO zia_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yesu mene ungwe awiya diro aune eyero sena, “Na niye eno sinena. Emo 99 ‘Iwaing nonane’ asinasani dubo oko kapetegao naya uritira atu awong eno yawa yawa bainakama oko yarineya. Arata pasena mani dekaongka amimene dubo kapetegai aune nung eno uritira atu yawa yawa bainakama yarineya. ");
INSERT INTO zia_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ora bauno zo nung wan kina wawong etobe nuna-una mitai ago zo tara yariniya. Ayero yai nung damana gaero aune garo sauno kau nete tamariniya. ");
INSERT INTO zia_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Taungno puro aune otao mani aune napo tayao nuna awiya yausai nuna-una bumaya awong eno eyero sariniya, ‘Moni nana zo tara yetiya awiya kau nete taungno pumena, aeno niye na aune dema tairo yawa yawa yepu.’” ");
INSERT INTO zia_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yesu mene ayero sero aune eyero sena, “Na niye eno sinena. Deka ayao ine Tuwa Bayaura angelo mene pasena emo zo dubo kapetegatinoi yawa yawa yero nowa ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu mene eyero sena, “Emo zora mani emodi etobe basani nauwato. ");
INSERT INTO zia_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Arare meta gugu mene maung eno eyero sena, ‘Mama, moni nona nina ago bono yero nato eno pugarinesa auna agewa nana sao awiya yeme na eno pugai.’ Ayero senu giro maung nona bono yero awongto eno pugaina. ");
INSERT INTO zia_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Pugainu nimoi aung mani gugu mene nona nuna apakana pu dekaongna gairo puro tawing zo nugu oko ake-akemo nibamu auna baungno nasani nauna. Nung atu mitasani nung moni emowa saese moni tebe-tabe sisigairo aung yena. ");
INSERT INTO zia_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ayenu nona nuna yore-yare aung-kamore yenu aune dora botiyo baina tawing auna atu kasa yenu nung nona kauyena. ");
INSERT INTO zia_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ayero giro nung baungno tawing auna maung zora-una atu buro punu emo amimene nung pugainu baung tawing nuna-una yero pu diya yero nasani nauna. ");
INSERT INTO zia_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Anasani nung pura ma minari kotuna. Noeno oko emo mene nona minao ena nung eno oko pugao yewa. Ayero yewa aune nung dubo kapetegairo ");
INSERT INTO zia_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","eyero sena, ‘Mama nana-una buro-mani daigairo nowa amimene nona tame atu neya. Arata nane mene zo etu mitasani meri maganena. ");
INSERT INTO zia_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Saineba, na iropuro mama nana auna atu baungno nung eno eyero sarinena, ");
INSERT INTO zia_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","“Mama, na gitau pasena Tuwa Bayau eno yero ning eno yewang. Arare yeme na nono yero mani nina yarineni? Nine na yausero mani nana oko sarinesa. Ning na pumasa soumani nina gege nane.” Na mama eno ayero sarinena.’ ");
INSERT INTO zia_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ayero sero iropuro maungna-ina baungna. Nung butunenu maung mene nung ake atu gigina. Giro yo-auno sungno baungno mani nuna saniro toko yena ara. ");
INSERT INTO zia_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ayero yenu mani mene nung eno eyero sena, ‘Mama, na gitau pasena Tuwa Bayau eno yero ning eno yewang. Arare yeme ning na maze mani nana ayero na eno oko sase.’ ");
INSERT INTO zia_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ayero sena, arata maung mene buro-mani nuna eno eyero sena, ‘Ewiya mani nana me, arare niye taung wori iwaing-kawaing awiya mena puro buro nung eno wosogaya pumae. Ayero yero wawong soro nuna-una ling zo pugae. Ayero te soga te nuna-una wosogaipu pumae. ");
INSERT INTO zia_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ayero yero aune bulimakao mani taung gawire awiya puro buro depu mininasani yawa yawa yanene. ");
INSERT INTO zia_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Noeno okowata, mani nana ewiya magayena asinasani nona amimene kasa yetiya. Mani tara yena amimene nupema kapetegairo bumiya.’ Ayero senu awong zayero yawa yawa yewa ara. ");
INSERT INTO zia_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Anewa muwo mani nuna nung bure atu butunete garo bautara kasa yero na wuinewa bewing duruka nigiro ");
INSERT INTO zia_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","buro-mani zo yausero atata yena, ‘Tani owiya noeno nei?’ Ayero atata yenu ");
INSERT INTO zia_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","buro-mani mene nung eno eyero sena, ‘Meta nina bumiya, aeno maung nina mene bulimakao mani taung gawire zo detiya. Noeno okowata, mani nuna kapete gairo bumi nung pumi iwaing mitiya.’ ");
INSERT INTO zia_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ayero senu mani muwo mani nung tini kapenu dung yero baungno gare atu towao awang sero yangduna. ");
INSERT INTO zia_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ayero yenu maung mene kasa yero buro korayao buro nasani nung yunu nung ge abena maung eno eyero sena, ‘Na dawang bainakama nibamu sou buro nina yero nona. Na ge nina zo oko dewang. Arata ning nane otao mani nana aune yawa yawa yanenese wo zo za na eno oko pugao yero nosa. ");
INSERT INTO zia_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Arata mani nina awiya nung towangna bauno eno nasani nona nina sisigairo aung yero kapete gairo bumi aune ning nung kotungno sesesa bulimakao mani taung gawire zo dero ainei!’ ");
INSERT INTO zia_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ayero senu giro maung mene eyero sena, ‘Bouwa, nao zo be giti dema mitonano, arare nona nana apakana awiya nina gege ara. ");
INSERT INTO zia_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Arata yeme name yawa yawa yanane moko naname iwaing yaise. Noeno okowata, meta nina magayena amimene seka yero iropumiya. Nung tara yena amimene kasa yetiya. Arare nung eno yawa yawa nenane teng niya.’” ");
INSERT INTO zia_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu mene buro-mani nuna eno eyero sena, “Emo wau monine zo mene nung nona nuna awiya mani zo eno senu diya nasani nauna. Diya nenu emo ena mene emo wau monine aeno eyero sewa, ‘Diya yao mani nina mene nona nina sisi-bura-bura yero noiya.’ ");
INSERT INTO zia_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ayero sewa nung nigiro mani awiya yausenu bunu nung eno eyero sena, ‘Ning buro nono yero nesa ge bowi nina seseya nigeni? Ning buro nana oko kora yero diya yero nosi siya, aeno ning diya yao buro nana yaine yao teng oko. Arare ning baungno buro yero nosa auna ge gayao puro buro gipasa gane.’ ");
INSERT INTO zia_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ayero senu buro diya nao mani awiya dubo mene eyero kotuna, ‘Burora maung mene buro sorai aune na nono yarineni? Na buro mou-mesa yao awiya yao ine teng oko, nupema na nona eno emo eno isa sarinena, awiya na meng garinena. ");
INSERT INTO zia_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aeno burora maung mene na awang sai aune emo ena mene na otao yero garo nunae-una yuno kora yaese sero na tani zo yari kotupunena.’ ");
INSERT INTO zia_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ayero sero nung emo ena abena nunae nuna-una atu mitina awong awiya nata-nata yausenu dekaong-dekaong bamuwa. Aune nung zo eno eyero sena, ‘Ning abena nazigo burora maung nana auna atu mitiye?’ ");
INSERT INTO zia_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ayero senu nung abena eyero sena, ‘Kerosinina daramu mamanikaka 100.’ Ayero senu nung eyero sena, ‘Nonana doket nina era. Arare mena adungno 100 disero 50 gae.’ ");
INSERT INTO zia_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ayero sero emo zo eno eyero sena, ‘Abena nana nazigo nina-ina atu mitiye?’ Ayero senu nung eyero sena, ‘Beki wuit 100.’ Ayero senu nung nung eno eyero sena, ‘Ning nonana doket nina puro 100 disero 80 gae.’ Buro diya yao mani mene ayero yaese senu yewa. ");
INSERT INTO zia_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Arare burora maung mene buro diya yao mani tani yena auna susuwa giginu emo kotumaore mene yaine yao yena, aeno nung mani awiya bowi yena. Awiya noeno okowata, tawingna nona eno dubo-dubo yero nowa amimene otao mani nunae aune dema nasani emo kotumaore mene yaine yero nowa. Arata uritira waegao eno dubo-dubo yero nowa awong amimene tawingna nona eno emo kotumaore mene yaine yero nowa aine oko yero nowa. ");
INSERT INTO zia_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Na memokoba nibamu niye eno sinena. Niye moni tawing euna mene otao-gamao yepu. Ayero yaya ago moni puro naora be aung yai aune awong niye puro pu garo mitao gege mitao auna pugarineya. ");
INSERT INTO zia_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Arata zo nung nona maingkoka diya yero baingtariniya amimene deka ayero nona baina zo diya yero baingtariniya. Ora zo nung nona maingkokaka auna buro oko yero baingtao yariniya amimene deka ayero buro baina zo awiya oko yero baingtao yariniya. ");
INSERT INTO zia_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ora niye moni tawing euna awiya diya pore yarineya, awiya awe mene nona me niye eno pugai diya yarinei? ");
INSERT INTO zia_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ora niye nona emo zora awiya diya oko yero baingtao yarineya, awiya awe mene nona ninae pugai pumarinei? ");
INSERT INTO zia_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Mani dekaongka mene emo diya etobe nunato-una atu sou buro yaine yao teng oko ara. Awiya nung zo eno otao nasani zo eno iwo yariniya. Nupema zo tumo didinasani zo bereya yariniya. Niye deka ayero Tuwa Bayaura sou buro nasani aune wau monina sou buro etobe deka ayero yao ine awiya teng oko arauwa.” ");
INSERT INTO zia_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisayo awong moni eno dubo-dubo yero nasani nauwa, arare Yesu mene ge sena awiya nigiro ge nuna aeno sero gero iwa. ");
INSERT INTO zia_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ayero yewa nung awong eno eyero sena, “Niye emo bauno mene niye gaya iwaing yaise yero nowa. Arata Tuwa Bayau mene moko ninae gosinoiya. Nona emo mene gosinowa iwaing yero noiya awiya Tuwa Bayau mene gosinoi nona meko nibamu yero noiya. ");
INSERT INTO zia_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mosera sao tauyao ge aune porofetera ge awiya tauyero mitawe dunu Yohane kasa yena be aune aung yena. Aung yenu atu zayero Tuwa Bayau nata Tuwa yero nariniya auna Bowi Iwaing sero butunowa. Arare emo bauno apakana Tuwa Bayaura napora babari tau-tataware yero nowa. ");
INSERT INTO zia_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Uritire tawingne auna be besugariniya awiya nona eo yao gege. Arata sao tauyao gera owe maing maingkoka nibamu zo awiya duwao aung yao ine teng oko ara. ");
INSERT INTO zia_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Emo zo nung bauno nuna doro bauno sekawa atariniya, awiya nung kuma yetiya ayao ine yariniya. Nupema emo zo nung bauno emo zo mene gitau atiro yangduna awiya atariniya, awiya nung dema kuma yariniya. ");
INSERT INTO zia_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Gitau wau moni emo zo nasani nauna. Nung taung wori owere ipu ewa-gaewa yao gege puro wosogati nasani nauna. Ayero nasani wari be sero ana-bonene yero nasani yawa yaware nasani nauna. ");
INSERT INTO zia_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Be aune emo bogamasa zo garo be nuna auna nugu atu adungno desetiro mitima nauna, yazo nuna Lasaro. Taung nuna bozo mene minao. ");
INSERT INTO zia_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nung nona susuna wau emora tewora atu wosai puro minari sero diya nauna. Atu mitasani naunu sino mene buro bozo nuna sasaing miniro saero nauwa. ");
INSERT INTO zia_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ayero nawe duwato emo bogamasa awiya magayenu angelo mene puro baungno Abraham aune dema tairo pugaiwa mitina ara. Ayero yenu aune wau emo magayenu mutewa ara. Mutewa nung kowa iyaore auna atu mitasani yaya baina tapunasani nauna ara. ");
INSERT INTO zia_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ayero nasani diti yero Abraham ake-akemo atu mitinu Lasaro mene nugu nung aune dema mitinu gigina ara. ");
INSERT INTO zia_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ayero yero nung aiyamama sero eyero sena, ‘O mama nana Abraham, ning na eno yo aung. Ning Lasaro iyengti wawong soro dung nuna oura dusero puro buro pugai ewawa nana iyang maingkoka yae. Na iyao mene awini yaya meko tapunena.’ ");
INSERT INTO zia_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ayero senu Abraham mene abena eyero sena, ‘Mani nana, ning gitau seka mitauwasa be aune zamena simena tame atu mitasani nona ipu ewa-gaewa yao pupunasani nauwasa. Arata Lasaro mene zo nona memeko-mameko pupunasani nauna. Arare yeme napo euna atu nung mitao nuna iwaing taungno mitiya. Ayero miti ning zo yaya tapunasani mitesa. ");
INSERT INTO zia_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Arata awiya gege okowata, nona zo dema mitiya. Ninae-ina arita nanae-una towang watiyo bainakama mitoiya. Arare emo awong etu mitowa amimene watiyo awiya yauseuno ninae-ina babari yaya teng oko yariniya. Deka ayero emo agewa auna atu mitowa amimene watiyo yauseuno nana-una bumao ine awiya dema teng oko ara.’ ");
INSERT INTO zia_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ayero senu wau moni emo mene eyero sena, ‘Mama, eyao eno na ning yausinena. Ning Lasaro sasa nung mama nana-una gare babaise sinena. ");
INSERT INTO zia_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Na metamani nana wawong zo miteya. Awiya Lasaro mene baungno ge tau-tataware yao awong eno saise awong nete masi euna buro yaya baina tamowi sero sinena.’ ");
INSERT INTO zia_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ayero senu Abraham mene eyero sena, ‘Awong Mosera ge mitiya, o nupema porofetera ge mitiya, arare awong ge awiya nigaese.’ ");
INSERT INTO zia_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ayero senu wau moni emo mene eyero sena, ‘O mama nana Abraham, awiya teng oko niya. Arata magayao zo mene biritira atu iropuro baungno nunae-una kasa yero ge sai nigiro dubo darawa yarineya.’ ");
INSERT INTO zia_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ayero senu Abraham mene eyero sena, ‘Awong Mosera geta porofetera ge oko nigao yarineya, awiya emo zo mene biritira atu nupema iropuro baungno ge sai gaya me oko yariniya.’” ");
INSERT INTO zia_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu mene buro-mani nuna eno eyero sena, “Pasenana yumao ewe-pape noyao amimene kasa yero emo bauno yumai pasenana zuwarineya. Arata zo nung emo bauno pasenana yumariniya amimene meko yaise. ");
INSERT INTO zia_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Emo ayao amimene mani maingkoka zo yumai pasena tamoiye sero, niye bere-bere daba bainakama zo emo auna dube kimegairo wito kurura atu teugaya gutero tura babai teng yariniya. Noeno okowata, emo amimene pasena oko yaore oura gutero magayariniya, awiya nona eo yao gege. Arata nung pasena yai aune Tuwa Bayau mene abena pugariniya, awiya nona mou-mesa yao. ");
INSERT INTO zia_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Niye nika niyetope diya yero baingtipu. Otao nina pasena yai giro ning nitope nung awang se. Nupema nung dubo darawa yai giro ning dema pasena nuna yangdo. ");
INSERT INTO zia_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nupema nung pasena ning eno be 7 ayao wari zore yariniya, arata nung nupema tera kapetegairo ning eno eyero sariniya, ‘Na dubo darawa nena.’ Ayero sinai be 7 yai saineba ning pasena nuna yangduwarinesa ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aposolo mene Tuwa eno eyero sewa, “Ning tumo diyao nanae inasa tauyaise.” ");
INSERT INTO zia_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ayero sewa Tuwa mene eyero sena, “Tumo diyao ninae awiya i me maingkokaka zo ine bairo baina yatiya, awiya niye i baina oeno eyero sateya, ‘Ning etu zokero baungno wito towang atu dopero bayase.’ Ayero saya ge ninae dimatiya arauwa. ");
INSERT INTO zia_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ayero ninae-ina mani sou zo mene ma buro nete ta bulimakao diya nete ture nupema kapete gairo bung nape yai aune diya nuna mene, ‘Ning mena bung adungno nona minase,’ ayero sarinita? ");
INSERT INTO zia_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aung ara. Nung nung eno eyero sariniya, ‘Ning nona minao nana sairo kora yero mo neyang yao awiro aune nona nana dungno puro bung. Na nona minana teng yai aune ning ago nona minase.’ ");
INSERT INTO zia_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ayero soumani mene buro nung eno sao awiya yai aune diya nuna mene nung eno dange sarinita? Aung ara. ");
INSERT INTO zia_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Susuwa ninae deka ayero mitiya. Tuwa Bayau mene buro niye eno pugaina awiya yero besugairo aune eyero sepu, ‘Naeka buro-mani me ungta sinesa. Buro nae eno sao awiya gege yetenane.’ Ayero sepu.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu nung Yerusalem babari sero nagibe atu ang yero Samaria towang Galilaya towang atu bautunete ");
INSERT INTO zia_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","kasa napo zora yena. Ayero yenu emo bozo tauyaore wawong etobe amimene buro nung nagibe atu tamuwa. ");
INSERT INTO zia_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Awong ake ina atu dopero yausero eyero sewa, “Yesu, emo tuwa, ning nae eno yo aung.” ");
INSERT INTO zia_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ayero sewa nung awong giro eyero sena, “Niye baungno taung aingso ninae pirisa eno gipepu giro iwaing yeteya asae.” Ayero senu awong ang yero bautunewa taung aingso nunae iwaing yena ara. ");
INSERT INTO zia_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ayero yenu nunae-una emo zo mene taung nuna iwaing yenu giro wawa sero Tuwa Bayaura yazo bowire de ika gatinasani yesese yena ara. ");
INSERT INTO zia_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yesese yero baungno Yesura-una tera atu boma gaero benaung koing tawingna gairo nung eno dange sena. Nung awiya Samaria emo ara. ");
INSERT INTO zia_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu mene giro eyero sena, “Na emo wawong etobe kora yetena iwaing yeteya, arata 9 awiya natu mitei? ");
INSERT INTO zia_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ayero emo 9 apakana yesese yero Tuwa Bayaura yazo bowire de ika gateya teng yatiya, arata emo Yuda oko amimene nata yesese yero bumiya era.” ");
INSERT INTO zia_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ayero sero nung eno eyero sena, “Ning iropuro baung nase. Tumo diyao nina mene yeti ning iwaing yetesa.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisayo mene Yesu atata yero sewa, “Be noune Tuwa Bayau nata Tuwa yero nariniye?” Ayero atata yero sewa giro Yesu mene ge nunae abena eyero sena, “Tuwa Bayau nata Tuwa yero nariniya auna be awiya emora diti mene gao teng oko ara. ");
INSERT INTO zia_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nupema awong ge eyero sao teng oko, ‘E gipu. Nung etu mitiya era.’ Ora, ‘Nung agewa zora otu mitiya ora.’ Sana nigipu. Tuwa Bayau nata Tuwa yero nao awiya ninae-ina towang mitiya ara.” ");
INSERT INTO zia_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ayero sero buro-mani nuna eno eyero sena, “Nete ago niye na Emora Mani kau nasani wari be dekaongka gege niye aune dema nanese kotumariniya, arata na niye aune dema oko narinena. ");
INSERT INTO zia_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Awong niye eno eyero sarineya, ‘Gipu, nung otu mitiya.’ Ora, ‘Gipu, nung etu mitiya.’ Ayero saya niye oko baungno awong ago yae. ");
INSERT INTO zia_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Awiya noeno okowata, be bibiya papari-papari noi waegao awiya waegairo baung uriti agewara atu besugatinoiya, deka ayao ine na Emora Mani mene be na kasa yarinena aune ayero yarinena. ");
INSERT INTO zia_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Arata gitau na yaya buro witao tamarinena. Tamana emo yeme tawingna etu neya amimene na bauta potero duwarineya. ");
INSERT INTO zia_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tani gitau Noa wangna oko witaore nasani nauwa deka ayao ine naya na Emora Mani kapetegairo barinena. ");
INSERT INTO zia_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Awong ou oko bumaore nona pupunasani mininasani anasani bauno wina-piti yero atitinasani nauwa. Ayero nasani nauwita asero newa Noa wangna witina ara. Witinu ou wori baina buro awong worero aung yena. ");
INSERT INTO zia_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Emo yazo Loto nasani nauna be aune deka ayero nasani nauwa. Awong nona mininasani nona wina-piti nasani minao buro nasani garo nasani awinasani nawe duwa ");
INSERT INTO zia_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Loto mene napo Sodom doro daigati nenu wari be aune awetu iyaore uritira atu wa sigoru mene wosaine yero emo bauno apakana awero aung yena ara. ");
INSERT INTO zia_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Emo mene deka ayero nasani kotumao nunae puro pu tawingna burora gairo naya na Emora Mani kasa daung yarinena. ");
INSERT INTO zia_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Be aune zo nung garo nuna-una opesara atu mitariniya amimene nona-owi nuna gare mitiya awiya pumari oko towaise. Ora zo nung bure atu nariniya amimene oko kapete gairo nape babaise. ");
INSERT INTO zia_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Niye tani Lotora bauno auna-ina kasayena awiya kotungpu. ");
INSERT INTO zia_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Zo nung nao nuna tawingna awiya puro nari kotumariniya amimene tawingna nao nuna awiya yangduwariniya. Arata zo nung nao nuna na eno duwariniya amimene nao iwaing tamariniya. ");
INSERT INTO zia_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Na sana nigipu. Ping aune emo etobe masi dekaongka auna awinayato na zo puro zo duwarinena. ");
INSERT INTO zia_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Bauno etobe mene ma yetinasani mitayato na zo puro zo duwarinena. ");
INSERT INTO zia_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Emo etobe bure atu nayato na zo puro zo duwarinena.” ");
INSERT INTO zia_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ayero senu awong ge awiya nigiro eyero sewa, “Emo tuwa, nona awiya naina atu kasa yariniye?” Ayero sewa Yesu mene ge pungyero eyero sena, “Buro awinoi ni owa mene boingsa giro dowinowa ara.” ");
INSERT INTO zia_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu mene awong isa saora bereya aung be giti isa sinasani naese sero ge pungyero eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Emo zaz zo napo zora mitauna amimene Tuwa Bayau ta emo awiya oko awang yero nasani nauna. ");
INSERT INTO zia_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Napo auna bauno gamo yu magayao zo nasani nauna amimene zazra-ina ozaung-zaung kasa yero eyero sero nauna, ‘Iwo nana mene na yora initinoiya, arare ning na soreung.’ ");
INSERT INTO zia_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ayero sero naunu zaz mene ge nuna oko nigao doro nawe aune eyero kotuna, ‘Na Tuwa Bayauta emo awiya awang oko yero nona, ");
INSERT INTO zia_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","arata bauno gamo ewiya nung buro baina na eno pugatinoiya. Nete ozaung-zaung nana-una butunai na bereya yoiye, na nung kotora atu gera soremane.’” ");
INSERT INTO zia_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tuwa mene ge pungyao awiya sero aune eyero sena, “Niye zaz meko auna ge awiya nigiro susuwa eyero gipu. ");
INSERT INTO zia_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Tuwa Bayaura gerao dubu nung ping iya yausinasani nowa awong awiya Tuwa Bayau mene kotora atu gera soremarinita? ");
INSERT INTO zia_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yore. Na meba sinena. Nung awong mena gera soremariniya. Arata na Emora Mani mene nupema tawingna kapetegairo buro emo tumo diyaore ena isa sinasani naya tamarinenita?” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Emo ena awong nuka nuyetope gosinauwa emo pewayao naunu otao mani ena zo gosinauwa meko yero nauna awong aeno Yesu mene ge eniya eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Emo etobe awongto isa sari sero witi Tuwa Bayaura ibu bainana yewato ara. Zo nung Farisayo, zo nung takis pumao emo ara. ");
INSERT INTO zia_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisayo awiya dopero mitasani moko nuna mene isa eyero sena, ‘O Tuwa Bayau, na emo ena ine oko ara. Ayero nasani giro na ning eno dange sinena. Awong awiya ugaing yao emo, tani meko nao emo, aune kuma yao emo ara. Arata na awong ine oko ara. Nupema, na takis pumao emo eine oko ara. ");
INSERT INTO zia_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Na Sande dekaongka auna be etobe ayao nona seminiro nona. Arata nona apakana pupunona awiya gausero dubu wawong etobe yero zo ning eno pugatinona ara.’ ");
INSERT INTO zia_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Isa ayero sena ara, arata takis pumao emo awiya ake ina atu dopero diti ika uritira yao awang yena. Nung pasena nuna giginu baina yenu meng gatinasani isa eyero sena, ‘O Tuwa Bayau, na pasena emo. Ning na ao-di.’” Yesu mene ungwe awiya diro aune eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Na niye eno sane. Takis pumao emo awiya Tuwa Bayau mene nung emo pewayao ayero senu nung kapete gairo garo nuna-una baungna. Arata emo zo awiya aung ara. Noeno okowata, zo nung taung puro witariniya, awiya Tuwa Bayau mene nung puro wosariniya. Arata zo nung wosiro nariniya, awiya Tuwa Bayau mene yazo nuna de ika yariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Emore baunone awong Yesu mene mani mamanikaka gao yaise sero puro nuna-una bamuwa. Arata buro-mani nuna mene gigiwa meko yenu awong gona yewa. ");
INSERT INTO zia_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ayero yewa arata Yesu mene mani mamanikaka nuna-una bumaese sero eyero sena, “Niye mani mamanikaka dopu nana-ina bumae. Nagibo nunae oko gazae. Awong ayao amimene Tuwa Bayaura napo auna gerao ara. ");
INSERT INTO zia_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Na ge memokoba nibamu niye eno sinena. Zo nung tumo diyao mani mamanikakara ine aung amimene Tuwa Bayaura nape babao ine teng oko.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Gitau yao zo mene Yesu atata yero eyero sena, “O gipao emo iwaing, na nono yero nao me iwaing tamarineni?” ");
INSERT INTO zia_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ayero senu Yesu mene abena eyero sena, “Ning na iwaing asinasani iwaingna susuwa gosinesita? Tuwa Bayau nata iwaing. ");
INSERT INTO zia_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ning Tuwa Bayaura sao tauyao ge gosinosa: ‘Kuma oko yase; Ning emo oko dasa magayae; Ning ugaing oko yase; Ning emo zo gera pugari ge oko iwase; Ning ai maungnena ge diung.’ Sao tauyao ge ayero mitiya.” ");
INSERT INTO zia_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ayero senu gitau yao emo mene eyero sena, “Na mani maingkore ge awiya apakana diungno butunawe emo yetena.” ");
INSERT INTO zia_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ayero senu Yesu mene nigiro eyero sena, “Ning buro zo duwasa mitoiya, awiya ye. Ning baungno nona nina apakana pugasa emo mene zuma gaero pumaya wau moni nina awiya emo bogamasa eno bono ye pumae. Ayero yasa aune wau nina uritira atu mitariniya. Ayero aune buro na ago yase.” ");
INSERT INTO zia_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ayero senu emo gitau yao amimene ge awiya niginu dubo nuna mou-mesa yena. Noeno okowata, nung wau moni bainane. ");
INSERT INTO zia_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ayero yenu Yesu mene giro eyero sena, “Emo wau moni witaore amimene Tuwa Bayaura napo auna babaora buro bainakama yarineya. ");
INSERT INTO zia_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Wo kamel mene zai mo gayao auna enora towao awiya teng oko. Deka ayero emo wau moni witaore mene Tuwa Bayaura napo auna babao awiya deka teng oko.” ");
INSERT INTO zia_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ayero senu emo ge awiya nigiro eyero sewa, “Arare awe mene uritira baungno nao me iwaing awiya tamao teng niye?” ");
INSERT INTO zia_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ayero sewa Yesu mene eyero sena, “Nona emo mene yao ine teng oko awiya Tuwa Bayau mene yai teng yariniya.” ");
INSERT INTO zia_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ayero senu Petoro mene eyero sena, “Sana nigi. Nae napore nona-owi nanae apakana doro ning ago nasani nonane.” ");
INSERT INTO zia_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ayero senu Yesu mene awong eno eyero sena, “Na memokoba nibamu niye eno sinena. Zo nung Tuwa Bayau nata Tuwa yero nariniya auna ge bowi babaise sero napo nunata bauno nunata metamani nunata maung aire nunata mani awiso nuna duwariniya, awiya ");
INSERT INTO zia_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","abena Tuwa Bayau mene yeme tawingna etu abena nuna bainakama pugariniya. Nupema ago nung eno nao me iwaing pugariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu mene buro-mani 12 sero puro gitau baungno awong eno eyero sena, “Sana nigipu. Yeme name Yerusalem babari sero wiwitinenane era. Arare ge gitau porofete mene Emora Mani eno gaewa awiya me yariniya. ");
INSERT INTO zia_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Awiya emo mene na puro pu emo Yuda oko auna waweng garineya. Ayero yaya na izi nasani na eno nao meko nasani begura pise nana tame garineya. ");
INSERT INTO zia_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ayero yero awong na waung mene yanakana dero aune na daya magayarinena. Magayana wari be etama aung yai aune nupema iroparinena.” ");
INSERT INTO zia_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ayero sena, arata buro-mani mene ge awiya nigiwa gera susuwa oko kasayao yena. Awong ge auna susuwa kau yero iwawa yewa. ");
INSERT INTO zia_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yeriko nape atu emo diti guma yao zo mene nagibo deungbera atu adungno emo bauno eno moni isa sinasani mitina. Ayero nasani mitinu Yesu mene napo auna nugu kasa yena. ");
INSERT INTO zia_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kasa yenu emo amimene emo bauno witao butunewa auna bewing nigiro emo ena atata yero sena, “Awong ewiya no nei?” ");
INSERT INTO zia_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ayero senu awong nung eno eyero sewa, “Yesu Nasaretera emo amimene butuniya.” ");
INSERT INTO zia_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ayero sewa giro nung yausero be kerero eyero sena, “Yesu ning Dawidira sai, ning na eno yo aung!” ");
INSERT INTO zia_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ayero senu emo gitau ang newa amimene nung gona nasani nung ge duwaise sewa. Arata nung nupema wawa bainakama sero sena, “O Dawidira sai, ning na eno yo aung!” ");
INSERT INTO zia_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ayero senu Yesu mene nigiro nagibe atu dopero awong eno eyero sena, “Puro nana-ina bungpu.” Ayero senu puro bung nugu yewa Yesu mene atata yero sena, ");
INSERT INTO zia_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Na no ning eno yanese sinesi?” Ayero senu nung eyero sena, “Tuwa, na sasa diti moko nana iwaing yaise sinena.” ");
INSERT INTO zia_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ayero senu Yesu mene nung eno eyero sena, “Diti moko nina iwaing yaise. Tumo diyao nina-una teng ning iwaing nesa.” ");
INSERT INTO zia_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ayero sinenu diti moko nuna iwaing yenu nung soma nupema gigina. Ayero yenu emo bauno mene tani awiya giro Tuwa Bayau bowi yewa. ");
INSERT INTO zia_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu mene Yeriko nape toiro busero buwagairo babari sero yena. ");
INSERT INTO zia_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Aune napo auna emo zo nasani nauna yazo nuna Zakayo. Nung emo takis pupunasani nauwa auna diya zo. Arare nung moni witaore ara. ");
INSERT INTO zia_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nung amimene Yesura benaung giro baingtari kotuna, arata emo bauno witao mitiwa amimene nung gazewa nung Yesu gao teng oko yena. Noeno okowata, nung emo apungka. ");
INSERT INTO zia_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Aeno nung gitau sungno baungno Yesu etu butunai garinena asero witi i zora yena. ");
INSERT INTO zia_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ayero mitinu Yesu agewa auna buro diti ika yero nung eno eyero sena, “Zakayo, ning mena wosiro bung. Yeme na garo nina-ina atu witiro mitete awarinena.” ");
INSERT INTO zia_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ayero senu nung mena wosiro buro yawa yawa nasani Yesu puro baung garo nuna-una yena. ");
INSERT INTO zia_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Anenu emo bauno daigairo mene gigiwa meko yenu Yesu eno ge bautara sinasani eyero sewa, “Nung baungno pasena emo ouna gare atu awari sero bautuniya, owiya!” ");
INSERT INTO zia_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakayo nung dopero Tuwa eno eyero sena, “Tuwa, sana nigi. Na nona-owi nana puro dubu etobe gurutu yero zo puro emo bogamasa eno pugarinena. Nupema na gitau ge iwero emo zora nona dekaongka ugaing pumuwingta, awiya na abena nuna siwongpatige ayero pugarinena.” ");
INSERT INTO zia_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ayero senu Yesu mene nung eno eyero sena, “Yeme Tuwa Bayau mene emo bauno garo euna awiya pumiya. Emo ewiya dema nung Abrahamna saisibuna auna zo. ");
INSERT INTO zia_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Na Emora Mani mene emo tara yao eyao ine ewiya kau yero taungno kora yari bumuwang.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ayero senu nigiwa aune nung susuuno ge eniya zo sena. Noeno okowata, nung kasa Yerusalem gatinenu awong eyero kotumuwa, “Yeme Tuwa Bayau nata Tuwa yero nariniya.” ");
INSERT INTO zia_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ayero kotupunewa giro nung ungwe zo didinasani eyero sena, “Emo baina zo nung tawing zo omete-oko auna babai emo tuwara putoung nung eno pugaya kapetegairo bari sena. ");
INSERT INTO zia_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ayero yari sero buro-mani nuna wawong eto yau senu bumuwa awong eno moni bono yero 200 kina 200 kina pugainu pumuwa aune eyero sena, ‘Niye moni emimene buro yaya zamai puro naya na kapetegairo bumane.’ ");
INSERT INTO zia_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ayero sero doro bautunenu tawing nuna auna emo bauno mene nung bereya yenu giro ge pugaiwa puro nung ago yero bamuwa ara. Baungno kasa yero eyero sewa, ‘Emo amimene emo tuwa nanae yao awang sinenane.’ ");
INSERT INTO zia_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ayero sewa, arata saineba awong emo tuwara putoung nung eno pugaiwa puna ara. Putoung pugaiwa puro kapetegairo buro tawing nuna-una kasa yero buro-mani wawong eto gitau moni pugaina awong awiya yau saese senu yau sewa bumuwa ara. Bumuwa nung awong moni buro yewa nazigo kasayeni awiya gari sena. ");
INSERT INTO zia_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Arare buro-mani zo mene nuna-una kasayero eyero sena, ‘Emo tuwa, 200 kina na eno pugasa amimene buro yetena 2,000 kina nupema kasayetiya.’ ");
INSERT INTO zia_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ayero senu emo tuwa mene nung eno eyero sena, ‘Ning buro-mani iwaing. Ning nona maingkokaka awiya iwaing diya yetesa, arare ning yeme napo wawong etobe ayao awiya diya yasese pugarinena.’ ");
INSERT INTO zia_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ayero senu buro-mani zo mene buro eyero sena, ‘Emo tuwa, 200 kina na eno pugasa amimene buro yetena 1,000 kina kasayetiya.’ ");
INSERT INTO zia_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ayero senu emo tuwa mene nung eno eyero sena, ‘Na ning napo wawong zo awiya diya yasese pugarinena.’ ");
INSERT INTO zia_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ayero senu aune buro-mani zo mene buro eyero sena, ‘Emo tuwa, 200 kina nina mitiya era. Na gitau mo be zora pugairo sikigaingwa mitoiya era. ");
INSERT INTO zia_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Awiya noeno okowata, na susuwa nina gosinona. Ning nona eno dubo-dubo nasani tau-tataware yero nosa. Nona mani zo mene pugatinoi mitoiya awiya nine pupunosa; nona mani zo mene urinoiya awiya nine pupunosa; aeno na ning awang yero nona.’ ");
INSERT INTO zia_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ayero senu emo tuwa mene buro-mani aeno eyero sena, ‘Ning buro-mani meko nibamu ara. Ge nika nina eno na ning gera pugatinena. Ning susuwa nana gosinosa asinesa. Na nona eno dubo-dubo nasani tau-tataware yero nona. Anasani nona emo ena mene pugatinowa mitoiya awiya nane pupunona. Nupema nona emo ena mene urinowa awiya nane pupunona, ayero sinesita? ");
INSERT INTO zia_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Aune ning noeno moni nana gitau oko puro pu benkira gao yasi? Ayero yatesi siya, awiya na kapetegairo buro agewa nuna aune dema pumatena.’ ");
INSERT INTO zia_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ayero sero nung emo ena nugu dopero mitiwa aeno eyero sena, ‘Niye 200 kina nuna awiya sorero puro pugaipu emo 2,000 kina tauna amimene pumae.’ ");
INSERT INTO zia_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ayero senu awong eyero sewa, ‘Tuwa, nung ka awiya 2,000 kina mitiya!” ");
INSERT INTO zia_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ayero sewa, arata nung eyero sena, ‘Na niye eno sane. Zo nung nona nung eno pugao awiya puro nasani amimene buro yai giro na ena susuuno nung eno pugarinena. Arata zo nung nona nung eno pugao awiya puro nasani amimene buro oko yao yai giro na nona maingkokaka nuna-una mitiya awiya sorero pumarinena. Ayero yana nung aung nariniya. ");
INSERT INTO zia_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ora emo bauno na iwo nasani na emo tuwa nunae yao awang sewa, awong ami zo puro bungpu nana-una benaungna atu daya mamagayae.’” ");
INSERT INTO zia_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu nung ge awiya sero aung yero aune Yerusalem witari gitau ang yero baungna. ");
INSERT INTO zia_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nung diri yazo Oliwa awiya witiro napo etobe yazo nunato Betefasito Betani auna nugu kasa yero buro-mani nuna etobe eno eyero sero iyengtinu gitau bamuwato, ");
INSERT INTO zia_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Nito napo ouna baungno toiro baungputo. Baungno wo dongki seka bayao zo getara kimegeya mitiya awiya garineyato. Gitau mani zo mene tame oko aduna ara. Nung awiya geta besero puro bungputo. ");
INSERT INTO zia_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ora besinayato emo zo mene nito atata yero ‘Nito noeno dongki awiya geta besineito?’ ayero sai giro nito abena eyero seputo, ‘Tuwara buro euna mitiya.’” ");
INSERT INTO zia_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yesu mene ayero sero awongto iyengtinu bamuwato ara. Baungno nona sena awiya teng deka ayero tamuwato ara. ");
INSERT INTO zia_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Awongto dongki sekawa auna angsi besinewato wora mamono mene awongto eno eyero sewa, “Nito noeno dongki sekawa auna angsi besineito?” ");
INSERT INTO zia_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ayero sewa awongto eyero sewato, “Tuwara buro euna mitiya.” ");
INSERT INTO zia_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Asero awongto dongki sekawa awiya puro baung Yesura-una yewato ara. Ayero yewato awong taung wori nunae puro pu dongki tame gairo aune Yesu iniro soga yewa witi wo tame yena. ");
INSERT INTO zia_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nung dongki tame adungno bautunenu emo bauno mene awong taung wori nunae amimene nagibe atu ero zuwero gitau newa. ");
INSERT INTO zia_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nung diri Oliwa wosiro baungno Yerusalem nugu kasa nenu dubu baina nung ago nauwa amimene yawa yawa yewa. Awong tani putoungne naunu gosinasani nauwa awiya kotupunasani arero Tuwa Bayaura yazo de ika gatinasani eyero sewa, ");
INSERT INTO zia_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Emo tuwa naname Tuwara bera butuniya nung awiya bowi yanene. Uritira tini kapao aung yetiya. Name Tuwa Bayaura yazo de ika yanene!” ");
INSERT INTO zia_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ayero sewa Farisayo ena emo bauno dubu baina auna towang mitiwa amimene Yesu eno eyero sewa, “Gipao emo, emo dubu nina mene ning emo tuwa asineya awiya se duwae.” ");
INSERT INTO zia_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ayero sewa nung abena eyero sena, “Na niye eno sane. Awong ge duwarineya, awiya daba mene ‘emo tuwa’ asinasani ararineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Arare Yesu nung baung Yerusalem nugu yero napo baina awiya giro napo eno zi sena. ");
INSERT INTO zia_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Zi sero eyero sena, “Niye dema be yeme eune monona nagibo gatei siya, awiya teng yatiya. Arata yeme monona nagibo puingtiniya. Arare niye oko garineya. ");
INSERT INTO zia_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Iwo mene napo ninae ziuno mitasani aiwo gaero pupunasani gapuro au gitau gairo amimene bemi yaise yarineya. Ayero yero niye puro pu towang gaya niye nai kau yarineya. ");
INSERT INTO zia_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Awong napo ninae daya bezai toiro niye dero aung-kamore yarineya. Awong daba zo zora-una tame mitariniya, awiya oko ao-diyarineya. Tani awiya ninae-ina atu kasa yariniya, noeno okowata, Tuwa Bayau mene niye kora yari buna auna be awiya niye oko gao yero nowa.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu mene Tuwa Bayaura ibu bainana toiro emo moni paora buro ibu mokora atu yero newa giro tunena. ");
INSERT INTO zia_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nung awong eno eyero sena, “Ge gayao zo eyero mitiya era: Ibu nana awiya isa saora ibu mitaise. Arata niye yeteya ibu ewiya ugaing yao emora pungyao masi nunae ine niya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nung wari be sero ibu mokora atu emo bauno gipinasani nauna. Arare pirisa babuze aune sao tauyao ge gipao emo aune diya ena dema awong amimene nung daya magayaise auna nagibo tamari yewa. ");
INSERT INTO zia_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Arata emo bauno apakana amimene ge nuna nigaora tauyero putoung newa giro awong nagibo zo oko tamuwa. ");
INSERT INTO zia_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Arare be zore Yesu mene emo bauno Tuwa Bayaura ibu mokora atu Tuwara ge gipinasani Bowi Iwaing tugata nenu pirisa babuze aune sao tauyao ge gipao emo aune simai ena amimene nuna-una buro ");
INSERT INTO zia_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","nung eno eyero sewa, “Ning nae eno se. Ning ana bera atu tani awiya yero nosi? Awe senu tani awiya yero nosi?” ");
INSERT INTO zia_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ayero sewa nung ge nunae abena eyero sena, “Na deka dema ge zo niye atata yari kotupunena. Niye na eno sepu. ");
INSERT INTO zia_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohane mene ge ou buro nuna amaze ana bera yero nauni, emora berata Tuwa Bayaura bera i?” ");
INSERT INTO zia_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ayero senu awong nuka nuyetope ge wina-se nasani eyero sewa, “Name ‘Yohanena ou suwao awiya uritira nona’ asarinenane, awiya nung eyero sariniya, ‘Arare niye nono yero ge nuna oko nigao yewi?’ ");
INSERT INTO zia_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ayero soiye sero eyero sarinenineta, ‘Yohanena ou suwao awiya emora nona gege ara.’ Ayero sanane emo apakana emimene daba au naname-una garineya. Noeno okowata, awong Yohane gosinowa porofete me yero nauna.” ");
INSERT INTO zia_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ayero sero awong Yesu eno ge abena eyero sewa, “Yohanena ge ou susunauna awiya naina atu kasa yeni, awiya nae oko gao arauwa.” ");
INSERT INTO zia_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ayero sewa Yesu mene awong eno eyero sena, “Ayero sineya, arare na ana bera atu tani yero nona auna susuwa niye eno oko sarinena.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu mene emo bauno eno ge eniya eyero sena, “Emo zo mene wain urena ara. Urero diya ena burora pugairo nung tawing ake-akemo auna baungno nimoi nasani nauna ara. ");
INSERT INTO zia_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Arare wain me pumaora be bunu giro nung buro-mani zo baungno wain me ena pumaise sero iyengtinu baungnu diya mene dero tunewa tebeba kapete gairo baungna ara. ");
INSERT INTO zia_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Baungnu wain burora maung mene buro-mani zo nupema iyengtinu baungnu dero izinasani tunewa tebeba kapete gairo baungna ara. ");
INSERT INTO zia_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Baungnu maung mene buro-mani zo nupema iyengtinu baungnu dewa taung kamuta mungtenu musugaiwa. ");
INSERT INTO zia_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ayero yewa burora maung mene giro eyero sena, ‘Nono yarineni? Na mani nana yo diyang nana ewiya iyengtana babariniya. Babai awong nung giro aratamarineita?” ");
INSERT INTO zia_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ayero sero iyengtinu baungnu diya mene mani awiya giro wina-se yero eyero sewa, ‘Nung emimene nete tawing euna maung yariniya, arare nung kara danane magayai tawing ewiya naname yae.’ ");
INSERT INTO zia_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ayero sero nung musuna-masuna nete puro baungno wain buro doro goma bautara atu dewa magayena ara.” Yesu ungwe awiya diro emo atata yero sena, “Burora maung mene diya yao emo eno nono yariniye? ");
INSERT INTO zia_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nung buro awong dariniya. Ayero yero diya sekawa buro nuna-una pugariniya.” Yesu ayero senu awong nigiro eyero sewa, “Aung ara. Ayao ine oko kasa yaise!” ");
INSERT INTO zia_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ayero sewa Yesu mene diti ye nunae-una gairo eyero sena, “Arare ge gayao euna susuwa nono yero mitiye? Garo yao emo mene daba zo gigiwa meko yenu duwa ara. Arata daba amimene garo wurura ziwong yero mitoiya. ");
INSERT INTO zia_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Zo nung daba auna atu te gaero zuwariniya amimene pusupariniya. Ora daba amimene emo zora-una tame zuwariniya, awiya emo awiya dai pusupuro mozero aung yariniya.” ");
INSERT INTO zia_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ayero senu sao tauyao ge gipao emo aune pirisa babuze mene ge eniya sena amimene awong gaunu giro wari deka aune nung bunao gare pugari sewa, arata awong emo bauno awang yero giro duwa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Arare awong Yesu iniro puro emo tuwara waweng pugari sero nung umo yewa. Ayero nasani awong emo ena pugaiwa baungno esega ge nigaora yero nung etutinewa. Awiya nung ge meko zo sai giro nung sanari sero newa. ");
INSERT INTO zia_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ayero nasani nung atata yero eyero sewa, “Gipao emo, nae susuwa nina gosinenane. Ge nina awiya iwaing. Ning ge nina iwaing gege emore baunone eno sinosa. Ning emo ena yazore awiya awang oko yero nosa. Aung ara. Ning emo bauno eno Tuwa Bayaura ge auna susuwa gipero baingtitinosa. ");
INSERT INTO zia_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ning nono kotupunesi? Name Yuda emo mene Roma emora emo tuwa Sisa aeno takis pugatinonane awiya ning gosinosa teng yero noita?” ");
INSERT INTO zia_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ayero sewa, arata Yesu mene awong iwora yani ititinewa awiya giro awong eno eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Moni zo gipepu gane. Ora ititire yazore monina mitiya ewiya ana ing?” Ayero senu awong eyero sewa, “Awiya Sisara.” ");
INSERT INTO zia_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ayero sewa nung awong eno eyero sena, “Arare nona Sisara gerao ayero sero giro Sisa eno pugaipu. Ora nona Tuwa Bayaura gerao ayero sero giro Tuwa Bayau eno pugaipu.” ");
INSERT INTO zia_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ayero senu awong nung emo baunona benaungna atu sanao teng oko yena. Nupema ge sena awiya nigiwa kotumao nunae-una atu oko kasa yao yenu awong no saine yero giro duwa ara. ");
INSERT INTO zia_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Emo ena Sadukayora dubu amimene Yesura-ina bumuwa ara. Awong Sadukayo mene ge eyero sinauwa: “Magayao awong nupema oko iroparineya.” Ayero sinauwa. ");
INSERT INTO zia_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Arare awong nung atata yero eyero sewa, “Gipao emo, Mose mene ge zo name eno eyero gaena, ‘Emo zo bauno atiro nete mani oko pumao magayariniya, awiya meta nuna mene bauno awiya atariniya. Ayero yero nung amimene tato nuna eno mani zo pumaise.’ ");
INSERT INTO zia_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Arare metamani 7 awiya awong nasani nauwa ara. Tato kiyongne awiya nung bauno atiro nawe mani aung magayena. ");
INSERT INTO zia_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Arare namba tu mene bauno deka amaze atiro nawe mani aung magayenu ");
INSERT INTO zia_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","namba tri mene bauno deka amaze atiro nawe mani aung magayenu, ayero gege yero baungno awong metamani 7 amimene bauno dekaongka amaze atiwa, arata awong mani aung magayewa ara. ");
INSERT INTO zia_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Arare ago bauno awiya magayena. ");
INSERT INTO zia_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Awong 7 amimene gitau bauno dekaongka awiya atiwa. Arare be mamagayao mene nupema iroparineya be aune bauno awiya bauno ana yariniye?” ");
INSERT INTO zia_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ayero sewa Yesu mene awong eno eyero sena, “Yeme tawingna etu emo bauno atitinasani nowa. ");
INSERT INTO zia_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Arata nete be bainana atu emo bauno ena nao me iwaing topetaese Tuwa Bayau mene gai teng yarineya, awong amimene magayaora atu iropuro nupema oko wina-ati yarineya. ");
INSERT INTO zia_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tuwa Bayau mene awong magayaora atu yemaoko uwenu iropumuwa, arare awong mani nuna yero nasani angelo ine yero mitarineya. Awong nupema magayao ine teng oko ara. ");
INSERT INTO zia_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ora mamagayao mene iroparineya, auna ge awiya Mose mene dema gipena. Nung i zo awero oko aung yao yena auna ungwe awiya gainete aune ge zo Tuwa Bayau mene nung eno sena awiya eyero gaena, Na Abraham, Isaka, aune Yakobo auna Tuwa yero mitona. ");
INSERT INTO zia_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tuwa Bayau nung emo mamagayao asero nonane awiya gosinoi seka gege yero nowa. Arare nung emo magayaora Tuwa okowata, nung emo seka mitowa auna Tuwa yero mitoiya.” ");
INSERT INTO zia_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nung ayero senu sao tauyao ge gipao emo ena mene eyero sewa, “Gipao emo, ge sinesa awiya gigenane kara teng niya.” ");
INSERT INTO zia_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ayero sewa, noeno okowata, Sadukayo mene nung nupema atata yao awang yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu mene awong eno eyero sena, “Emo bauno awong noeno eyero sinowi, ‘Yuda emora Sorao Emo yazo Kristo awiya nung Dawidira sai?’ ");
INSERT INTO zia_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Arata yere buku naname yazo Sam auna awiya Dawidi nung nuka nutope eyero sero gaena, Tuwa mene tuwa nana eno eyero sena, ‘Ning buro wawong me nana-una adungno ");
INSERT INTO zia_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mitasa na iwo dubu nina awiya benaung nina-ina atu pugana gona yarinesa.’ ");
INSERT INTO zia_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawidi mene ge ayero sinasani Kristo eno ‘Tuwa nana’ asena. Arare Kristo nung nono yero Dawidira sai yariniye?” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Emo bauno mitiwa auna benaungna atu Yesu mene buro-mani nuna eno eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Niye sao tauyao ge gipao emo awiya umo yepu. Emo bauno mene awong samo daese sero taung wori imokakaung wosogairo yero nowa. Emo bauno mene awong kakame atu giro arugaese arataungno yero nowa. Awong yere ibura atu emo baunona benaungna atu adumari arataungno yero nowa. Awong ana-bonene yaora bera atu masi yazore auna atu adumari arataungno yero nowa. ");
INSERT INTO zia_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Awong bauno yu magayao auna wau moni awiya sorero pupunowa. Ayero nasani awong pasena nunae worero me sao nasani isa imoko-kaungkaung sinowa. Arare awong abena nunae mou-mesa yao bainakama nibamu tamarineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu nung ibu bainana atu mitasani diti yero emo bauno wau monine mene moni nunae ena ibura kolekta auna pugatinewa ");
INSERT INTO zia_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","gosinasani mitinu bauno zo yu magayao wau moni aung bogamasa amimene kasayero toya etobe kolektara pugainu gigina ara. ");
INSERT INTO zia_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ayero yenu Yesu mene giro eyero sena, “Na ge memoko niye eno sinena. Bauno yu magayao bogamasa emimene moni pugatiniya amimene enana awiya daigatiniya. ");
INSERT INTO zia_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Noeno okowata, awong awiya moni witao mitiya arata awong ena gege Tuwa Bayau eno pugeya. Arata bauno emimene moni nuna maingkoka mitiya awiya teng pugairo aung yetiya. Arare nung nona zuma gaero minaora zo oko mitiya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Buro-mani nuna ena mene Yerusalem ibu baina Yuda emo mene gitau daba iwawaing amimene simuwa, nupema nona iwawaing Tuwa Bayau eno pugatinasani nauwa amimene dema simuwa, auna ge sewa giro nung eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Niye nona apakana yeme gosineya auna susuwa sane. Ago be zo bumai aune awong ibura daba zo oko duwaya zora-una tame mitariniya. Awong dero sisigairo augaya wosariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yesu mene ayero senu awong nung atata yero eyero sewa, “Gipao emo, nona sinesa awiya be noune kasa yariniye? Tani no gitau kasa yai aune be awiya nugu niya awiya garinenine?” ");
INSERT INTO zia_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ayero sewa Yesu mene eyero sena, “Ena mene niye etegowi sero umo neupu. Emo daigairo mene buro niye etegairo yazo nana sinasani nuka nuyetope ‘Na emo era’ ayero sarineya. Nupema ‘Be kasa yetiya’ ayero sarineya. Arata niye baungno awong oko ago yae. ");
INSERT INTO zia_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Niye ge bowi eyao ine nigarineya: ‘Winade-wanade baina neya, ora gavman iwo nasani napo sisigatineya.’ Ayero saya nigiro awang oko yae. Tani awiya gitau kasa yarineya, arata tawingna be mena oko aung yariniya.” ");
INSERT INTO zia_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesu mene ayero sero aune awong eno eyero sena, “Emo dubu ena awong winade-wanade emo dubu ena aune yarineya. Arita emo tuwa enana dubu amimene emo tuwa enana dubu aune winade-wanade yarineya. ");
INSERT INTO zia_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Dumi babuze ipariniya. Agewa enana atu dora botiyo babuze kasa yariniya. Nupema yaya babuze ena mene emo sero auna witiro aung yariniya. Nupema uritira atu tani-butani babuze enata nona benaung seka-seka ena amimene kasa yaya giro emo awang bainakama yarineya. ");
INSERT INTO zia_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ora nona awiya apakana oko kasa yaore awong niye saniro yaya buro niye eno pugaya tamarineya. Ayero yaya niye puro pu yere ibura gairo atu niye gera pugairo aune bunao gare pugarineya. Niye yazo nana puro nowa, aeno awong niye puro emo tuwara benaungnata nupema emo tuwa wosao enana benaungna atu pugaya ge buro yarineya. ");
INSERT INTO zia_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ayero yarineya be aune niye Bowi Iwaing puro nowa auna susuwa ninae keregarineya. ");
INSERT INTO zia_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Niye ge ewiya kotumao ninae-una atu pugaipu tauyero mitae, ‘Na gera pugarinaya be aune na abena saora kotumao mena oko denarinena.’ Ayero kotupunasani neupu. ");
INSERT INTO zia_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Noeno okowata, nane kotumao iwaing niye eno pugarinena. Ayero yana iwo ninae mene ge awiya awang sao ine teng oko yarineya. Nupema puro wosao ine teng oko yarineya ara. ");
INSERT INTO zia_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ai-amono mamonone metamani numonone didikaing aune otao mani awong dema niye iwora waweng pugarineya. Ayero yaya ninae-ina atu ena awiya daya mamagayari neya. ");
INSERT INTO zia_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Emo daigairo mene niye eno tini kapao pumarineya. Awiya noeno okowata, yazo nana awiya ninae-ina atu mitiya. ");
INSERT INTO zia_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Arata na niye soremana giti ai ninae zo oko usero wosariniya. ");
INSERT INTO zia_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Niye tau-tataware yero nete nao me pumarineya. ");
INSERT INTO zia_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Arata ago gorobo emo buro Yerusalem zimari naya giro eyero garineya era: napo baina dero bezaora be awiya kasa yetiya. ");
INSERT INTO zia_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Be auna atu emo bauno Yudaya tawingna mitarineya amimene awang yero sungno baung diri naese. Emo bauno Yerusalem mokora mitarineya amimene napo doro sungno babaese. Emo bauno ena goma bautara mitarineya amimene napo mokora oko towaese. ");
INSERT INTO zia_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Noeno okowata, be aune Tuwa Bayau mene abena nuna meko pugariniya. Ayero yai ge gaewa awiya apakana me yariniya. ");
INSERT INTO zia_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Oiye, bauno mesare ta bauno mani wuire. Awong yanakana sumao ine teng oko, arare na awong eno yo apunena. Noeno okowata, be aune mouyao bainakama tawing euna kasa yariniya. Nupema Tuwa Bayaura tini kapao baina amimene emo bauno dubu euna-una kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Awong awiya gorobo emo mene puro iwi mene daya mamagayarineya. Nupema gorobo emo mene saniro bunero puro emo dubu sero auna-una babaya sou buro nunae yarineya. Ora napo Yerusalem awiya zo emo Yuda oko mene puro patiro gera-gaira nasani naya be nunae besugai aune duwarineya. ");
INSERT INTO zia_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Tani ena inona atuta, warira atuta, arasara atu kasa yarineya. Nupema tawingna atu wito bainakama iropuro bezinai emo bauno dubu sero mene nigiro awang nasani kotung-katung yarineya. ");
INSERT INTO zia_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ora putoung uritira mitowa amimene iparineya. Ayero yaya emo bauno mene nona tawingna atu kasa niya awiya awang nasani kotumao aung yai doparineya. ");
INSERT INTO zia_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ayero yaya na Emora Mani mene putoungne waegao bainane bereze zora wosiro butunana emo bauno mene garineya. ");
INSERT INTO zia_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ago nona awiya kasa yari zanai giro niye apakana dopero diti ika yepu. Noeno okowata, be awiya Tuwa Bayau mene nupema kapetegairo buro niye pumaora be awiya nugu yetiya.” ");
INSERT INTO zia_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu ayero sero ge pungyao zo awong eno eyero sena, “Niye i fik arita i ena auna tani kotungno susuwa zo gipu. ");
INSERT INTO zia_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bowang nuna botu kasayero dang iwaing ditarineya be aune niye giro, ‘O, warira be kasa yariniya,’ ayero sinowa. ");
INSERT INTO zia_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Deka ayero tani kasa yari ni sesena awiya kasa yai aune niye eyero sepu: ‘O, Tuwa Bayau nata Tuwa yariniya auna be kasa niya.’ ");
INSERT INTO zia_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Na ge me memoko niye eno sane. Emo bauno yeme tawingna etu neya amimene oko magayero aung yao naya aune nona awiya apakana kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ago uritire tawingne disero aung yarineyato, arata ge nana mene zo oko disero aung yariniya. ");
INSERT INTO zia_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Niye nona yanakana mininasani ou tauyao miniro dau nasani taungna nona eno dubo-dubo nasani naya be baina mene niye mena wao mene daine yoiye sero, niye nika niyetope diya yero baingtipu. ");
INSERT INTO zia_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Be baina awiya emo bauno tawing sero sero nowa auna-una kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Niye tani apakana kasa yariniya auna mokora atu tauyero nete na Emora Mani auna benaungna dopari sero etutinasani isa sinasani neupu.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesu mene warire emo bauno ibu bainana atu gipinasani nauna, arata pingne nung doro diri zo yazo Oliwa auna baungno awiro nasani nauna. ");
INSERT INTO zia_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Iya gatinaunu emo bauno witao mene ibu mokora atu ge sai nigari sero nuna-una atu augairo nasani nauwa. ");
INSERT INTO zia_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Oregao be baina zo ame yis aung mininasani nauwa auna iya zo yazo nuna Magayao mene awong Daigaina oregao be awiya kasa yari nenu ");
INSERT INTO zia_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","pirisa babuzere sao tauyao ge gipao emore awong emo bauno awang nasani Yesu opene daora nagibo kau yewa. ");
INSERT INTO zia_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kau newa Sanda mene Yudasra-una mokora toina. Yudas yazo nuna zo Iskeriot asinasani nauwa, nung buro-mani 12 auna zo. ");
INSERT INTO zia_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nung amimene baungno pirisa babuzere ibu bainana polis auna diya enane dema au dekaongna gairo nung Yesu keregairo wawong nunae-una pugai pumaese sena. ");
INSERT INTO zia_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ayero senu awong nigiro yawa yawa nasani nung eno moni ena pugari sewa tauyena. ");
INSERT INTO zia_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ayero sero sewa nung ge nunae nigiro “Teng yetiya. Ayero yarinena,” asero nung eyero kotungna, “Emo bauno aung Yesu nata nai aune keregari nena.” Ayero kotupunasani Yesu keregairo wawong nunae-una pugari nagibo tamaora buro yena. ");
INSERT INTO zia_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Oregao be ame yis aung auna be kasa yena. Be aune awong wo sipsip mani daese sao mitauna. ");
INSERT INTO zia_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Arare Yesu nung mani etobe Petoroto Yohane iyengtiti nasani eyero sena, “Nito baungno ame naname soseputo buro minanene.” ");
INSERT INTO zia_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ayero senu awongto eyero sewato, “Ning masi nauna atu nona sosanetose kotupunesi?” ");
INSERT INTO zia_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ayero sewato nung eyero sena, “Nito nigiputo. Nito napo mokora baungno emo zo ou au baina zora diungno puro butunete nito nagibe atu tamariniya. Nito emo awiya ago yero baungno garo zora towai giro nito garo deka auna toiro ");
INSERT INTO zia_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","garora maung atata yero eyero seputo, ‘Nae gipao emo nanae aune garo moko nauna atu Magayao mene awong Daigaina auna bonene minarinenine?’ ");
INSERT INTO zia_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ayero sayato nung garo moko baina zo ika tame atu mitiya awiya nito eno gipariniya. Garo moko awiya masi zuwao au-tao sosao matu mitiya, awiya gipai giro atu nito bonene minaora nona kora yeputo.” ");
INSERT INTO zia_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ayero senu awongto baungno Yesu mene sena deka ayero yero taungno aune Magayao mene awong Daigaina auna ana-bonene minaora nona sosewato arauwa. ");
INSERT INTO zia_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Minaora be nugu yenu Yesu nung nona minaora masi auna baungno aposolore dema adumuwa ara. ");
INSERT INTO zia_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ayero yero nung awong eno eyero sena, “Na yaya oko tamaore bonene ewiya niye aune dema minanese moko nana eo niya. ");
INSERT INTO zia_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Na memoko niye eno sana nigipu. Na bonene nupema oko minarinena. Bonene me Tuwa Bayau nata Tuwa yero nariniya auna napora atu kasa yariniya awiya minarinena.” ");
INSERT INTO zia_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ayero sero nung awang ou wainne zo puro Tuwa Bayau eno dange sero aune eyero sena, “Niye awang ou wainne ewiya puro teng minipu. ");
INSERT INTO zia_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Na niye eno sinena. Yeme euneta ago na ou wain nupema oko minarinena. Be Tuwa Bayau nata Tuwa yariniya auna be kasa yai aune nupema minarinena.” ");
INSERT INTO zia_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ayero sero aune nung poro puro Tuwa Bayau eno dange sero eegairo buro-mani nuna eno pugatinasani eyero sena, “Puro minipu. Ewiya goi nana. Na niye soremaise pugatinena. Ago niye na kotupunasani eyero mininasani neupu.” ");
INSERT INTO zia_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ayero senu nona miniro aung yewa aune awang ou wainne zo puro deka ayero nasani eyero sena, “Ou wain ewiya yu nana. Yu nana ewiya niye eno yasagatinena. Yu amimene Tuwa Bayau aune tairo nao auna ge seka awiya inai tauyari niya. ");
INSERT INTO zia_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Arata gosineya: emo na puro pu iwora waweng gariniya amimene na aune dema nona minaora masira etu mitiya. ");
INSERT INTO zia_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Na Emora Mani mene magayao nana Tuwa Bayau mene senu mitoiya auna teng magayarinena, arata emo na keregariniya nung awiya, oiye, abena nuna nono yao pumariniye?” ");
INSERT INTO zia_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nung ayero senu giro awong nuka nuyetope atata wina-ye nasani eyero sewa, “Naname-una awe mene yariniye?” ");
INSERT INTO zia_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Buro-mani awong ge mene wina-de nasani eyero sewa, “Awe mene gitau yao emo naname yero nariniye?” ");
INSERT INTO zia_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ayero sewa nung eyero sena, “Tawingna emo tuwa mene emo bauno awong souyaese sinowa. Nupema emo putoung bainane amimene emo wosao mene awong bayao emo ayero saese sinowa. ");
INSERT INTO zia_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Arata niye ayero oko yarineya. Aung ara. Emo ninae-ina atu baina ninae yariniya amimene wosao ine yero naise. Gitau yao emo ninae mene soumani ine yero naise. ");
INSERT INTO zia_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Niye sepu. Awe mene baina niye, — adungno nona mininasani mitiya amimene baina nita dopero nona pugatiniya amimene baina niye? Gosineya, nona mininasani mitiya amimene baina niya. Arata nane mene zo ninae-una towang atu nasani soumani ine yero nona. ");
INSERT INTO zia_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Na yaya mokora yero nona niye na oko duwao na aune dema nowa. ");
INSERT INTO zia_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mama nana mene na nona apakana auna diya baina yero nanese putoung na eno pugaina. Deka ayero na putoung niye eno pugatinena ara. ");
INSERT INTO zia_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Arare na nata Tuwa yero narinena be aune niye na aune dema nona minarinenane. Niye emo tuwara adumao masira atu adungno mitasani Isreli emo bauno dubu 12 awiya awega-ziwega yarineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu mene Petoro eno yo auno eyero sena, “O Simon, sana nigi. Wuit mozero kowinowa me ewe piti ewe ayero noiya ayao ine Sanda mene niye puro mozero kowari sero senu Tuwa Bayau mene nigina. ");
INSERT INTO zia_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Arata na ning eno isa yemaoko sesena. Awiya tumo diyao nina besoiye sero isa sesena. Arare ago ning nupema kapetegairo otao mani nina inasa tau yarineya.” ");
INSERT INTO zia_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ayero senu Petoro mene nung eno eyero sena, “Tuwa, ning bunao gareta magayaora babasa na teng babarinena.” ");
INSERT INTO zia_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ayero senu Yesu mene eyero sena, “Petoro, na ning eno meba sinena. Nine ping eune kokora ge oko saore ‘Na Yesu oko gao’ ayero sasa be etama yariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesu mene ayero sero aune awong eno eyero sena, “Na gitau niye moni aung zao aung te soga aung iyengtiwang niye baungno nona kau yewita?” Ayero senu awong eyero sewa, “Aungwa.” ");
INSERT INTO zia_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ayero sewa nung nupema awong eno eyero sena, “Orata yeme awiya emo zo nung moni mitiya amimene puro naise. Arita zao puro noiya amimene deka ayero yaise. Ora emo zo nung winade yaora iwi aung yai giro taung wori nuna pugaise zuma gayaya nung nupema winade yaora iwi zo zuma gaero pumae. ");
INSERT INTO zia_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Na niye eno sinena era: Ge gayao eyero mitiya amimene nana-una atu me yaise sao mitiya. Ge awiya eyao era, Awong nung gigiwa sao tauyao ge dao emo ine yena.” ");
INSERT INTO zia_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ayero senu awong eyero sewa, “O Tuwa, gi. Nae winade yaora iwi etobe mitiya era.” Ayero sewa nung awong eno eyero sena, “Nona aeno oko sinena. Dopu!” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu nung Oliwa diri ozaung-zaung bautunasani nauna, arare be aune nung napo doro atu bauna. Baunu buro-mani awong nung ago yero bamuwa. ");
INSERT INTO zia_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nung agewa auna kasa yero awong eno eyero sena, “Etegao ninae-ina kasa yaniya, isa sepu.” ");
INSERT INTO zia_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ayero sero nung awong doro daba saingtoka eyare augatinonane baungno zuzunoiya ayero baungno boma gaero isa sinasani eyero sena, ");
INSERT INTO zia_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Mama, ning yaya nana-una butuniya awiya gazari yero giro gaze. Arata ning ara tamao nana-una okowata, ara tamao nina-una teng ye.” ");
INSERT INTO zia_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ayero senu uritira angelo zo mene wosiro nung ininu tauyena. ");
INSERT INTO zia_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu nung dubo gagausenu isa tauyero sinenu wiri nuna yu ine yero buro wosi tawingna yena. ");
INSERT INTO zia_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nung isa sinete iropuro buro-mani nuna-una baungno awong dubo minao taungno mou yero auriti awinewa gigina. ");
INSERT INTO zia_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Giro uwero awong eno eyero sena, “Niye nono yero auriti awinei? Niye iropungpu isa sae. Naya etegao mene buro niye tamaniya.” ");
INSERT INTO zia_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu nung ge ayero sinasani mitinu emo dubu baina mene nuna-una bumuwa. Emo yazo nuna Yudas, nung awiya buro-mani 12 auna zo, nung amimene gitau yenu bumuwa. Nung Yesu toko yari sero nuna-una nugu baungna. ");
INSERT INTO zia_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ayero yenu Yesu mene eyero sena, “Yudas, ning nono yero na Emora Mani toko yao nina mene keregairo gorobo emo eno pugari sero nesi?” ");
INSERT INTO zia_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ayero senu buro-mani Yesu aune dema mitiwa awong amimene nona kasa yarinena awiya giro eyero sewa, “Tuwa, ning nae iwi mene awong danenese kotupunesita?” ");
INSERT INTO zia_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ayero sinewa nunae-una zo mene iropuro pirisa bainana soumani awiya dari yero dawong wawong mera awiya kesena. ");
INSERT INTO zia_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ayero yenu Yesu nung awiya giro eyero sena, “Tani awiya yeme yangdo.” Ayero sero nung wawong pu daweng gainu iwaing yena. ");
INSERT INTO zia_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesu nung pirisa babuzere ibu bainana polis auna diya enane awong nung iniro pumari sero bumuwa giro awong eno eyero sena, “Niye iwire ami dawangne puro butuneya, awiya gorobo emo zo puro bunari baine neya. ");
INSERT INTO zia_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Be giti awiya na niye aune dema ibu bainana atu yero nona niye atu noeno na oko pumao yero nowi? Arata yeme ewiya niye aune mumena maung aune auna be arauwa.” ");
INSERT INTO zia_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ge ayero senu nung saniro puro pirisa baina auna-una garo mokora bamuwa. Arata Petoro mene zo ake ake nasani nung ago yero bauna ara. ");
INSERT INTO zia_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Awong garo auna goma mokora toiwa ena mene iyao ero aune adungno ainasani mitiwa Petoro nung awong aune dema adungno mitina ara. ");
INSERT INTO zia_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Atu mitinu aune sou baunodi zo mene Petoro iyao nugu atu adungno mitinu giginu kasa yenu giro nung anuwing nasani eyero sena, “Emo ewiya nung Yesu aune dema noiya.” ");
INSERT INTO zia_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ayero sena, arata Petoro mene bewae nasani eyero sena, “Bauno, na nung awiya oko gosinena.” ");
INSERT INTO zia_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ayero senu nimoi oko yao nupema zo mene buro nung giro eyero sena, “Ning dema emo auna buro-mani zo.” Ayero senu Petoro mene eyero sena, “Otao, na aung ara.” ");
INSERT INTO zia_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ago aua zo aung yenu aune nupema zo mene be tauyero eyero sena, “Meba nibamu ara. Emo ewiya kara nung aune dema noiya. Nung Galilaya emo zo.” ");
INSERT INTO zia_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ayero senu Petoro mene eyero sena, “Otao, ge nina sinesa awiya na oko gosinena ara.” Ayero sinenu kokora ge sena. ");
INSERT INTO zia_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ayero yenu Tuwa mene kapetegairo diti ye Petorora-una yena. Ayero yenu Petoro nung Tuwa mene ping aune ge gitau nung eno eyero sena awiya kotuna, “Nine ping eune kokora ge oko saore gitau ‘Na Yesu oko gao’ ayero sasa be etama yariniya.” ");
INSERT INTO zia_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Petoro ge awiya kotungno kasa daung yero zi bainakama sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Emo Yesu iniro puro mitiwa amimene nung giro sero izinasani dewa. ");
INSERT INTO zia_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ayero nasani mo be mene diti moko nuna worero sikigairo diro nung atata yero eyero sewa, “Ning porofete me yai giro se, emo ning deduniya auna yazo aweni?” ");
INSERT INTO zia_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ayero sero awong ge meko ena susuuno nung eno sinasani nung giro sero izewa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Iya gainu Yuda emora gitau yaore pirisa babuzere sao tauyao ge gipao emore amimene au dekaongna gairo sewa emo Yesu puro augaora bamuwa aune nung eno eyero sewa, ");
INSERT INTO zia_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ning ge se. Ning Yuda emora Sorao Emo Kristota aung ing?” Ayero sewa nung eyero sena, “Na niye eno sarinena, arata niye gaya oko me yariniya. ");
INSERT INTO zia_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nupema na ge enana niye atata yarinena, awiya niye ge nana abena oko sarineya. ");
INSERT INTO zia_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ora be baina babarinenane awiya na Emora Mani mene Tuwa Bayau putoungne auna wawong mera atu adungno mitarinena.” ");
INSERT INTO zia_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ayero senu awong eyero sewa, “Arare ning nitope Tuwa Bayaura Mani ing?” Ayero sewa nung eyero sena, “Yore, na era. Arare nika niyetope sineya.” ");
INSERT INTO zia_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ayero senu awong wina-se yero eyero sewa, “Name ge nomaze nupema nigarinenine? Be nuna mene Tuwa Bayaura yazo dena-betena yeti nigenane meko yetiya ara.” Ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ayero sero awong apakana iropuro nung puro baungno Pilatora-una pugaiwa. ");
INSERT INTO zia_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Atu zayero ge nuna sero eyero sewa, “Emo amimene nae Yuda emo mene Roma emore winade yanenese dubo nanae uwinawe doti susuwa nuna taungno nung puro butunenane. Nung nae emo tuwa Sisa eno takis moni pugao awang sinoiya. Nung nutope emo tuwa nanae yazo Kristo ayero sinoiya.” ");
INSERT INTO zia_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ayero sewa Pilato mene nung atata yero sena, “Ning Yuda emora emo tuwa ing?” Ayero senu nung Pilatora ge abena sinasani eyero sena, “Yore. Sinesa ara.” ");
INSERT INTO zia_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ayero senu giro Pilato nupema kapetegairo emo gitau yao arita emo bauno dubu baina aeno eyero sena, “Na susuwa nouna emo ewiya gera pugarineni? Na pasena nuna zo oko tamena.” ");
INSERT INTO zia_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ayero sena, arata awong be tauyero ge eyero sewa, “Nung nae Roma emore winade yanenese dubo uwinoi ge nuna amimene Yudaya tawing teng yero noiya. Nung Galilaya tawingna atu zayero butunawe kasa ye napo euna gairo deka ayero niya.” ");
INSERT INTO zia_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ayero sewa Pilato mene nigiro awong atata yero sena, “Emo ewiya Galilaya emota?” ");
INSERT INTO zia_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ayero atata yenu sewa nung Yesura susuwa eyero gigina: nung tawing agewa Herode mene diya yero nasani nauna auna mani zo. Be awiya Herode nung Yerusalem nape atu mitauna, arare Pilato mene senu awong Yesu puro Herodera-una bamuwa ");
INSERT INTO zia_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herode nung Yesu giro yawa yawa yena. Noeno okowata, nung gitau bowi ge nuna nigiro nung gari kotupu nasani nauna. Nung Yesu mene tani putoungne zo yai gari sinasani nauna. ");
INSERT INTO zia_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Arare Herode nung atata yerota yero ayena, arata Yesu mene ge zo nung eno abena oko sao yena. ");
INSERT INTO zia_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ayenu pirisa babuze aune sao tauyao ge gipao emo awong amimene nunato-una nugu atu dopero mitasani be tau-tataware yero Yesu gera pugaiwa. ");
INSERT INTO zia_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Anewa Herode gorobo emo nuna aune awong nung puro wowosinasani giro sero izero yewa. Izinasani mo owe iwao zo puro nuna tame atu wosogaiwa punu Herode nupema senu awong nung puro Pilatora-ina bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Gitau Herodeto Pilato awongto iwo wina-ye nasani nauwato, arata wari be aune awiya awongto otao yewato arauwa. ");
INSERT INTO zia_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato nung pirisa babuze diyare emo baunone yau senu buro augaiwa ");
INSERT INTO zia_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","awong eno eyero sena, “Niye emo ewiya puro nana-una buro nung emo bauno winade yaese dubo uwinoiya ayero seseya giro na benaung ninae-ina etu susuwa nuna gari sero atata yetena. Arata niye ge nora sero emo ewiya gera pugatinei? Na pasena nuna zo za nibamu oko tamena. Aung ara. ");
INSERT INTO zia_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herode nung dema ayero yero giro nupema pugai naname-una bumiya. Arare sana nigipu. Pasena nung daya magayaine yao awiya oko gosinena. ");
INSERT INTO zia_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Arare na sana nung waung mene wezero dero besaya babariniya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Arata tani eyao ine yero nasani nauwa. Magayao mene awong Daigaina auna iya oregao be kasa naunu Pilato mene aratamao nunae-una mani zo besinaunu nunae-una baungno nasani nauna. ");
INSERT INTO zia_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Arare Pilato ge ayero senu giro emo bauno dubu baina amimene teng-tetemo girara sero be kerero wawa sinasani eyero sewa, “Emo awiya depu magayai Barabas besaya kasa yero nanae-una bumae.” ");
INSERT INTO zia_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas nung gitau napo mokora atu winade zo diya emore nete mani zo denu magayenu giro nung bunao gare pugaiwa mitauna. ");
INSERT INTO zia_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato mene Yesu besari sero awong eno ge nupema sena, ");
INSERT INTO zia_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","arata awong nupema wawa sero eyero sewa, “Nung i pasaora depu! Nung i pasaora depu!” ");
INSERT INTO zia_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ayero sewa nung nupema awong eno senu be etama yena, “Noeno ayero sinei? Nung pasena no yeni? Na pasena nuna meko nung daya magayaine yao awiya kau nena. Arare na sana nung waung mene wezero dero duwaya babariniya.” ");
INSERT INTO zia_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ayero sena, arata awong be kerero nung i pasaora atu magayaise wawa sewa. Ayero sewa wawa nunae mene Pilatora ge puro wosina. ");
INSERT INTO zia_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ayenu giro Pilato mene ge nunae nigiro ge awiya tauyaise sena. ");
INSERT INTO zia_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Emo zo gitau winade diyare nete mani denu magayenu nung bunao gare pugaiwa mitasani nauna, nung awiya emo bauno mene pumari sewa giro Pilato mene besenu baungna. Ora Yesu awiya emo bauno mene nung magayaise sewa giro Pilato mene gorobo emora waweng pugaina arauwa. ");
INSERT INTO zia_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Awong Yesu puro bautunete emo zo nagibe atu tamuwa. Emo awiya yazo nuna Simon. Nung Sairini napora. Nung buro napo baina auna atu towari sero butunenu awong nung saniro i pasao puro nuna-una apapara pugaiwa diungno Yesu ago yero baungna ara. ");
INSERT INTO zia_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Emo bauno dubu baina awong nung ago yero bautunewa mani bauno witao mene nung eno zire-buware nasani dubo minaore bamuwa. ");
INSERT INTO zia_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Anewa Yesu nung kapetegairo awong eno eyero sena, “O Yerusalem mani bauno, niye na eno zi oko sepu. Niye nika niyetope arita mani awiso ninae eno zi sepu. ");
INSERT INTO zia_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sana nigipu. Ago be kasa yariniya be aune niye dubo mininasani eyero sarineya, ‘Bauno wagaung dopaota bauno mani aming oko gayao nowa amimene yawa yawa yaese.’ ");
INSERT INTO zia_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Be aune emo bauno mene diri eno eyero sarineya, ‘Niye dure nanae tame gaipu.’ Nupema diri mamanikaka eno eyero sarineya, ‘Niye wosipu nae worae.’ ");
INSERT INTO zia_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Iwo mene na i mesa yao ine awiya puro iyaora pugatineya, arare ago awong niye i soyao ine awiya iyaora pugari yaya niye nono yarinei?” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Awong pasena mani etobe Yesu aune dema daya magayaetose puro bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Awong baungno soma zo yazo Ziyo Atora Wetu, auna kasa yero Yesu i pasaora dewa ara. Ayero yero pasena mani etobe dema dero Yesura-una zo enaba zo enaba ayero pugaiwa ara. ");
INSERT INTO zia_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ayero yewa Yesu mene eyero sena, “O Mama, awong susuwa nana oko gao nasani tani ewiya neyare ning pasena nunae yangdo.” Ayero sena ara. Awong Yesu dero aune taung wori nuna awiya bono yero pumari kotungno ge tuwao zo yazo nuna laki ayewa. ");
INSERT INTO zia_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Emo bauno awong dopero anuwing nasani mitiwa ara. Ora diya sao mene zo awong nung maze izinasani eyero sewa, “Nung gitau emo ena soreuno kora yero nasani nauna, arare Tuwa Bayau nung punu Tuwa naname Kristo me yero nasani giro nung nuka nutope soremaise.” ");
INSERT INTO zia_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Gorobo emo dema nung izewa. Awong nuna-una nugu buro ou dokowang yao nung eno pugairo ");
INSERT INTO zia_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","eyero sewa, “Ning Yuda emora emo tuwa yero nasani giro ning nika nitope soreung.” ");
INSERT INTO zia_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Owe zo nuna-una ziyo gomina atu eyero gaewa, “Emo ewiya Yuda emora emo tuwa.” ");
INSERT INTO zia_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Pasena mani etobe awongto dema dewa auna zo mene Yesu izinasani eyero sena, “Ning Sorao Emo nanae Kristo asineyare ning nika nitope sorepunasani nato dema soreung.” ");
INSERT INTO zia_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ayero senu pasena mani zo mene ge awiya nigiro nung gona nasani eyero sena, “Ning Tuwa Bayau awang nesita? Name magayanenese deteya. ");
INSERT INTO zia_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Arata awong nao deteya awiya tani iwaing. Noeno okowata, nao tani meko gitau yewangno auna abena tapunenano ara. Arata emo emimene zo nung gitau tani meko zo oko yena ara.” ");
INSERT INTO zia_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ayero sero aune eyero sena, “Yesu, ning ago emo tuwa yero nete kasa yero na kotung.” ");
INSERT INTO zia_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ayero senu Yesu mene eyero sena, “Na ge me ning eno sinena. Be yeme eune ning na aune dema napo iwaing Paradais auna mitarinesa.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Arare wari diti 12 kilok yenu warira waegao aung yenu mume baina kasa yero tawing teng yero mitinu 3 kilok yena ara. Ayero yenu Tuwa Bayaura ibu bainana mo bainakama kimegao awiya kerero dao etobe yena. ");
INSERT INTO zia_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Anenu Yesu be kerero wawa sinasani eyero sena, “Mama, ititi nana wawong nina-una pugatinena.” Ayero senu oweno nuna aung yenu magayena ara. ");
INSERT INTO zia_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Gorobo emora diya mene tani awiya giro Tuwa Bayaura yazo de ika gatinasani eyero sena, “Ge me nibamu, emo ewiya nung meba pasena aung.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ora emo bauno dubu baina buro mitiwa amimene tani apakana kasa yena awiya giro aung yero awong dubo mininasani nupema kapetegairo bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Arata Yesura otao mani aune mani bauno awong nung ago yero Galilaya atu bumuwa amimene akepari yero dopero mitasani tani kasa yena awiya giro aung yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Emo zo nasani nauna yazo nuna Yosefe. Nung Yuda emora napo yazo Arimatia auna emo. Nung awiya Yuda emora gitau yao dubu auna zo. Nung awiya emo etutero nao, tani iwaing gege nasani nauna. ");
INSERT INTO zia_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Otao mani nuna mene Yesu gera pugairo dari sewa nung giginu meko yenu awong oko soremao yangduna. Emo amimene Tuwa Bayau nata Tuwa yero nariniya auna be diya nasani nauna. ");
INSERT INTO zia_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Emo amimene Pilatora-una baungno Yesura taung aingso pumari sena. ");
INSERT INTO zia_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Senu niginu taung aingso nuna i pasaora atu puro mo neyangyao imoko-kaungkaung mene ewero puro pu daba uma zo wamao auna gaina. Gitau emo zora taung aingso atu oko pugao. ");
INSERT INTO zia_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sabat iyara nona kora nasani mitiwa ture itinenu aune nung Yesura taung aingso daba umana pugainu wari diti 6 kilok yenu Sabatra be kasa yena. ");
INSERT INTO zia_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Bauno awong gitau Galilaya atu Yesu aune dema bumuwa amimene Yosefe ago yero baungno biriti awiya gigiwa ara. Ayero nasani Yosefe nung Yesura taung aingso nono nono yero pugaina awiya dema gigiwa. ");
INSERT INTO zia_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Awong giro nupema kapetegairo garo nunae-una baungno ou sereyao uweri enane sosewa. Sosewa Sabat iya kasa yenu giro awong sao tauyao ge dipunasani doro mitiwa arauwa. ");
INSERT INTO zia_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sande iya gatinenu gora-gara gumorore awong ou sereyao gitau sosewa awiya puro biritira bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Baungno eyero gigiwa: Daba biritira daba uma be gazao awiya dereme yero baungno demese atu mitinu gigiwa. ");
INSERT INTO zia_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ayenu mitinu giro daba umana toiwa, arata awong Tuwa Yesura aingso kau yewa. ");
INSERT INTO zia_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Awong aingso kau yero iwawa nasani mitiwa emo etobe taung wori nunato awiya neyangyero waegatinena amimene nunae-una nugu atu dopero mitiwato gigiwa. ");
INSERT INTO zia_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bauno awongto giro awang yero diti wese tawingna yero tawing anuwing newa aune emo etobe amimene awong eno eyero sewato, “Niye noeno buro emo naore awiya magayaora masira etu kau nei? ");
INSERT INTO zia_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nung etu oko mitiya. Nung yemaoko iropumiya. Niye ge gitau Galilaya atu niye eno sena awiya kotungno gipu. ");
INSERT INTO zia_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nung niye eno eyero sena, ‘Awong na Emora Mani pu pasena emora waweng garineya. Ayero yaya awong na i pasaora daya magayarinena. Magayero be etama ayao aung yai aune nupema seka yero iroparinena.’ Niye eno ayero sena.” ");
INSERT INTO zia_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Emo etobe mene ayero sewato giro bauno awong Yesu ge gitau sena awiya kotumuwa kasa yena. ");
INSERT INTO zia_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ayenu awong biriti doro nupema kapetegairo baungno buro-mani nuna 11 aune emo bauno ena eno dema nona kasa yenu gigiwa auna ge ungwe yewa. ");
INSERT INTO zia_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Bauno emimene ge awiya aposolo eno sewa: Maria nung Madala napora, Yoana, Yakobora ai Maria, awong aune bauno ena amimene ge awiya aposolo eno sewa. ");
INSERT INTO zia_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Arata aposolo mene baunona ge nigiwa me aung yenu giro yangduwa. ");
INSERT INTO zia_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Arata Petoro mene zo iropuro sungno baungno daba umana atu utero diti mokora yero mo gege mitinu gigina. Ayero yero nupema kapetegairo gare baungno nona kasa yena auna susuwa kau nasani kotumao nuna gagausena. ");
INSERT INTO zia_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Wari be dekaongka aune nunae-una emo etobe awongto ang yero baungno napo maingkoka zo yazo Emeas auna yari bamuwato. Nagibo Yerusalem doro baungno Emeas yao awiya 11 kilomita. ");
INSERT INTO zia_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Awongto bautu nasani tani kasa yenu gigiwato auna ungwe didinasani ");
INSERT INTO zia_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","bautunewato Yesu nung nuka nutope kasa nunato-una yero awongto aune dema baungna. ");
INSERT INTO zia_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Awongto nung aune dema bautunasani nung gigiwato oko kasa yena, noeno okowata, Tuwa Bayau mene awongto Yesu saore gowito sero dubora diti awenato gazena. ");
INSERT INTO zia_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Aune nung awongto eno eyero sena, “Nito ge ungwe nora yero butuneito?” Ayero senu awongto dopero dubo mininasani mitiwato ");
INSERT INTO zia_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Aune nunato-una zo yazo nuna Kliopa amimene ge abena eyero sena, “Esewa Yerusalem atu augatinasani nowa amimene tani baina be yeme eune kasa yetiya auna bowi awiya nigitineya. Aune ning nata amimene nono yero oko nigao nete aune buro nato atata nesi?” ");
INSERT INTO zia_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ayero senu Yesu mene awongto nupema atata yero eyero sena, “Tani nomaze sineito?” Ayero senu awongto nung eno eyero sewato, “Tani awiya Yesu Nasarete napora emo auna-una atu kasa yetiya amaze sinenato. Nung porofete, arare nung tani putoungne yero nasani ge putoungne tugata yero nasani Tuwa Bayaura benaungna o emo baunona benaungna atu noiya. ");
INSERT INTO zia_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Arata pirisa babuze aune emo gitau yao babuze nanae awong amimene nung daya magayaise sero nung iwora waweng pugeya awong nung i pasaora deteya magayetiya. ");
INSERT INTO zia_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Arata nae eyero kotupunasani nonane. Emo amimene Isreli emo nae iwora waweng atu sorariniya. Awiya gege okowata, deteya magayeti nenane wari be etama niya. ");
INSERT INTO zia_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Arata be yeme eune dubu nanae-una bauno ena mene ge zo seseya nae nigiro kotumao nanae sisigatini iwawa nenane. Awiya awong iya gatini gora-gara gumorore iropuro biritira baungno ");
INSERT INTO zia_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Yesura aingso oko gigeya. Ayero yero awong nupema tera kapetegairo ge eyero seseya, ‘Nae angelo gigenane angelo mene nung nupema seka yero iropumiya ayero seseyato.’ ");
INSERT INTO zia_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bauno mene ayero seseya giro dubu nanae-una emo ena mene iropuro biritira baungno bauno mene ge seseya ayao ine teng gigeya. Arata nung zo oko gigeya.” ");
INSERT INTO zia_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ayero sewato giro Yesu mene awongto eno ge eyero sena, “Nito kotumao aung. Ge apakana porofete mene gaewa awiya niye nono yero gao me yaora timara yero nowi? ");
INSERT INTO zia_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Sorao Emo Kristo nung gitau yaya taungno aune ago simao waegaore nuna pumaise sao mitiya, awiya niye oko gao ing?” ");
INSERT INTO zia_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yesu mene ayero sero aune ge nuna Tuwara gera gaewa mitoiya auna susuwa awiya awongto eno keregari sero ge Mose aune porofete apakana amimene gaewa auna atu zayero momo-zimomo yero sena ara. ");
INSERT INTO zia_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Awong bautunete kasaye napo auna nugu gaiwa aune Yesu nung awongto yangdoro darama babari sero yenu giro ");
INSERT INTO zia_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","awongto nung sorero eyero sewato, “Wari wowosini ping mena iyariniya. Arare ning nato aune dema mitaisa.” Ayero sewato giro nung awongto aune dema baungno awenato gare yena. ");
INSERT INTO zia_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ayero atu mitasani awong nona minari nasani newa giro nung ame puro Tuwa Bayau eno dange sero eero awongto eno pugaina ara. ");
INSERT INTO zia_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nung awongto eno ayero yenu awongto nung gigiwato kasa yenu giro nung mena aungne gaina. ");
INSERT INTO zia_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ayero yenu awongto eyero sewato, “Name nagibe atu ang nenane nung nao eno ge tugata yetiya, nupema gera susuwa nao eno keregaiya, be aune moko nanao mene yo wigaga yetiya.” ");
INSERT INTO zia_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Awongto ge ayero sero iropuro ang yero nupema kapetegairo Yerusalem bamuwato ara. Ayero awongto buro-mani 11 awong otao mani enane augairo mitiwa tamuwato ara. ");
INSERT INTO zia_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tamuwato awong awongto eno eyero sewa, “Ge me nibamu. Tuwa nupema iropumiya. Iropuro Simonna-una kasa yeti gigiya.” ");
INSERT INTO zia_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ayero sewa awongto nagibe atu ang nasani tani yewa auna ungwe didinasani sewato, “Nung ame eeti aune nato nung gigenato kasa yetiya.” Ayero sewato arauwa. ");
INSERT INTO zia_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Awong ge awiya sinasani mitiwa Yesu nung nuka nutope nunae-una towang daung atu kasa yero dopero eyero sena, “Niye dubo iwaingne mitiungpu.” ");
INSERT INTO zia_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ayero senu awong sopine yero iwaeta ayero sero awang yero babari yewa. ");
INSERT INTO zia_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ayewa giro nune awong eno eyero sena, “Niye noeno iwawa nasani kotumao ninae sisigati nei? ");
INSERT INTO zia_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Niye te-wawong nana gipu, na naka natope kasa yero mitena. Wawong ninae mene na iniro gipu. Iwae awiya taung aingso aung, arata nane mene zo taung aingsore mitena era.” ");
INSERT INTO zia_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ayero sero nung te-wawong nuna awong eno gipena. ");
INSERT INTO zia_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ayero yenu awong nung giro yawa yawa bainakama yewa, arata nupema iwawa yero ge aung yenu bora-bora yero mitiwa giro nung awong eno eyero sena, “Ninae-una nona ena minao etu mitita?” ");
INSERT INTO zia_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ayero senu giro wo ito gitau igi yewa mitina awiya pugaiwa ");
INSERT INTO zia_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","nung nunae benaungna atu puro minina. ");
INSERT INTO zia_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nung ge awong eno eyero sena, “Gitau na niye aune dema nasani eyero sewang, ‘Ge na eno gitau gaewa — Mosera sao tauyao ge auna atuta porofetera bukura atuta Sam bukura atu gaewa — ge awiya apakana me yariniya.’ Ayero sewang.” ");
INSERT INTO zia_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ayero sero nung kotumao nunae ininu tang senu awong be aune Tuwa Bayaura ge gayao auna susuwa gigiwa kasa yena ara. ");
INSERT INTO zia_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nung awong eno eyero sena, “Tuwa Bayaura ge gayao eyero mitiya. Na Sorao Emo ninae Kristo mene yaya taungno magayana wari be etama aung yai aune nupema biritira atu iroparinena. ");
INSERT INTO zia_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Arare niye Yerusalem etu zayero bowi nana keregaya emo bauno dubu sero sero amimene nigiro yazo nana yau sinasani dubo darawa yaya aune Tuwa Bayau mene pasena nunae yangduwariniya. ");
INSERT INTO zia_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Niye tani apakana gosinowa auna ge keregairo sinasani neupu. ");
INSERT INTO zia_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Sana nigipu. Oweno Mama nana mene niye eno pugari sena awiya iyengtana wosi ninae-una yariniya. Arata niye napo ewiya oko yangduwae. Niye etu mitaya putoung uritira atu wosi ninae-una yai aune napo doro burora babarineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yesu mene ayero sero awong puro baung Betani nape yero nung wawong buyagairo ikapari yero awong gao yena. ");
INSERT INTO zia_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nung awong gao nenu aune Tuwa Bayau mene nung punu nung awong yangdoro witi uritira yena. ");
INSERT INTO zia_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ayero yenu awong nung bowi yero yawa yawa bainakama nasani nupema wesora kapete Yerusalem gairo bamuwa. ");
INSERT INTO zia_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Atu baungno nasani awong be ozaung-zaung ibu bainana atu toiro Tuwa Bayaura yazo de ika gatinasani nauwa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ge bera nung nao gege nasani nauna. Ge bera nung Tuwa Bayaura benaungna atu nasani nauna. Ge bera nung nutope Tuwa Bayau. ");
INSERT INTO zia_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nung awiya gitau susuwara otu Tuwa Bayau aune dema nao gege nasani nauna. ");
INSERT INTO zia_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ge bera nung Tuwa Bayaura wawong yero nona apakana yero aung yena. Arare nona kasayena, awiya nung aung nona zo oko kasayena. ");
INSERT INTO zia_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nao awiya nuna-una mitauna. Arare nao awiya emora-ina waegairo mitauna ara. ");
INSERT INTO zia_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Waegao mene mume waegainu mume mene waegao disari kaputena, arata waegatinoiya. ");
INSERT INTO zia_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tuwa Bayau mene emo zo giginu kasayero nasani nauna yazo nuna Yohane. ");
INSERT INTO zia_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Nung amimene waegaora bowi sari buna. Emo bauno apakana waegaora Maung tumo diyaese sero Tuwa Bayau mene senu kasayena ara. ");
INSERT INTO zia_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohane nung nutope waegaora Maung okowata. Nung waegaora bowi gege maze sari buna. ");
INSERT INTO zia_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Waegao me nung emo bauno apakana awiya waegao pugatinoiya, amimene be aune tawingna atu kasayero nasani nauna. ");
INSERT INTO zia_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nung tawingna atu mitauna. Awiya gege okowata. Tawing dema nune yena ara. Ayero yena, arata tawingna emo bauno awong nung saore oko giro baingtiwa. ");
INSERT INTO zia_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nung tawing nuna-una kasayena, arata dubu nuna mene nung gosinasani aune nupema oko gao ine yewa. ");
INSERT INTO zia_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Arata ena mene awong nung otao yewa, o nung tumo diwa amimene Tuwa Bayaura mani awiso yaese sero nung yazo nunae mena puna ara. ");
INSERT INTO zia_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Awong emora yura kasa yero Tuwa Bayaura mani awiso oko yewa. Awong emora aratamaora okowata, o emora sao tauyaora okowata, awong Tuwa Bayaura putoungna kasa yero mani awiso nuna yewa ara. ");
INSERT INTO zia_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ge bera nung emo yero kasayero naname-una towang atu nasani nauna. Ayero yenu nae simao waegaore nuna gigiwangne. Nung Tuwa Bayaura Mani me, arare simao waegaore nuna-una gege mitauna. Nao mere monone awiya dubo nuna-una bebunu puro wosina ara. ");
INSERT INTO zia_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Susuwa nuna awiya Yohane mene puro daung gairo wawa sero eyero sena, “Na nung aeno eyero sewang, ‘Ago butuniya amimene nung gitau yao nana niya. Noeno okowata, na oko kasayaore nung nasani nauna.’” Yohane mene ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Name apakana amimene soremao iwawaing awiya zamena simena nuna-una atu pupunasani nonane. ");
INSERT INTO zia_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tuwa Bayau mene sao tauyao ge name eno pugari sero Mose eno pugaina ara. Arata Tuwa Bayau mene nao mere monone awiya name eno pugari sero Yesu Kristo eno pugainu puro buna ara. ");
INSERT INTO zia_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tuwa Bayau nung emo zo mene oko gigina. Aung nibamu arauwa. Arare Mani nuna dekaongka nuna-una deungbera mitoiya amimene Maung nuna name eno keregaina arauwa. ");
INSERT INTO zia_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yuda emora gitau yao Yerusalem atu nauwa amimene pirisa ena wati mugo nunae aune awong awiya iyengtiro sewa baungno Yohane atata yero eyero sewa, “Ning emo aweni?” ");
INSERT INTO zia_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ayero sewa Yohane nung susuwa nuna oko pungyao keregairo eyero sena, “Na Sorao emo ninae Kristo okowa.” ");
INSERT INTO zia_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ayero senu awong nupema atata yero eyero sewa, “Aune ning aweni? Ning Kristora ai mani Eliya ing?” Ayero sewa nung eyero sena, “Na Eliya okowa.” Ayero senu awong eyero sewa, “Ning porofete diya yero nonane awiya ning ari?” Ayero sewa nung eyero sena, “Aung arauwa.” ");
INSERT INTO zia_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ayero senu awong nupema atata yero eyero sewa, “Ora ning aweni? Nae baungno emo babuze nae seseya bumenane aeno ge no sarinenine? Ning nitope susuwa nina se niganene.” ");
INSERT INTO zia_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ayero sewa nung abena eyero sena, “Porofete Yesaya mene ge zo gaena awiya nana-una atu me niya. Na bowi sao emo eu yanawira atu nasani eyero sero nona, ‘Tuwara nagibo kora yepu korosae.’” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Emo Yohanena-una bumuwa awiya Farisayo mene iyengtiwa bumuwa ara. ");
INSERT INTO zia_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Arare awong nung nupema atata yero eyero sewa, “Ning sorao emo nanae Kristo oko siya, o Eliya oko siya, porofete oko siya, sinesa awiya gi. Arare ning nono yero emo bauno ge ou susunesi?” ");
INSERT INTO zia_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ayero sewa Yohane mene abena eyero sena, “Na emo bauno ou gege susunena ara. Arata ninae-una atu zo kasayero mitiya, niye nung oko gosinowa. ");
INSERT INTO zia_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nune nana-ina bautara bumariniya amimene emo bainakama. Na emo wosao nibamu amimene te soga nuna-una angsi besao ine teng oko yariniya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Susuwa awiya napo Betania, ou Yodan enabara mitauna, auna atu kasa yena. Yohane mene atu nasani atu emo bauno ge ou susunauna arauwa. ");
INSERT INTO zia_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Iya gainu Yesu mene Yohanena-una bautu nenu nung ake atu giro eyero sena, “Owiya gipu. Tuwa Bayaura lama mani ara. Nune tawing sero sero emo bauno auna pasena nunae diungno magayariniya. ");
INSERT INTO zia_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Na nung aeno eyero sewang, ‘Ago butuniya nung gitau yao nana niya. Noeno okowata na oko kasayaore nauna.’ Nung awiya ora. ");
INSERT INTO zia_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Na natope nung gitau oko gigiwang kasa yena. Arata Isreli emo niye bowi nuna sana nigaese sero na kasa yero ge ou zayewang.” ");
INSERT INTO zia_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohane mene emo eno ge ayero sero aune zo eyero sena, “Oweno mene ni audubo ine yero uritira atu wosiro nuna-una adungno mitinu na gigiwang. ");
INSERT INTO zia_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Na gitau nung oko gigiwang kasa yena, arata Tuwa Bayau mene na emo bauno ge ou suwanese sero eyero sena, ‘Oweno wosiro nuna-una adungno mitari niya emo amimene ge sai aune emo bauno Oweno pumarineya.’ ");
INSERT INTO zia_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Na susuwa nuna giro eyero sinena: Nung Tuwa Bayaura Mani me.” Yohane mene ge ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Iya gainu Yohane buro-mani nuna etobe aune amimene dopero mitiwa ");
INSERT INTO zia_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yesu butunenu giro Yohane mene eyero sena, “Tuwa Bayaura lama ora.” ");
INSERT INTO zia_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ayero senu buro-mani nuna etobe mene ge awiya nigiro Yesura-una ame bamuwato ara. ");
INSERT INTO zia_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Bautunewato Yesu mene kapetegairo giro awongto eno eyero sena, “Nito no kau neito?” Ayero senu awongto eyero sewato, “Rabai, (Ge naname-una, ‘Gipao emo’) ning garo nauna atu mitesi?” ");
INSERT INTO zia_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ayero sewato Yesu mene eyero sena, “Bungputo gaeto.” Ayero senu mani etobe amimene nung ago yero gare witiwato ara. Witiro wari awiya nung aune dema mitete duwato wari wosiro wari diti 4 kilok yena ara. ");
INSERT INTO zia_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Awongto Yohanena ge nigiro Yesu ago yewato auna zo yazo nuna Anderea. Nung Simon Petorora meta. ");
INSERT INTO zia_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Anderea nung tato nuna Simon awiya mena taungno eyero sena, “Nato Yuda emora sorao emo yazo nuna Mesia awiya tamenato.” (Mesia awiya Kristo.) ");
INSERT INTO zia_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ayero sero Yesura-una yuno baungno kasa yewato Yesu mene Petoro giro eyero sena, “Yazo nina Simon. Ning Yohanena mani. Arata na yazo nina sekawa Sifas asinena arauwa.” (Ge naname-una Daba Domito.) Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Iya gainu Yesu nung Galilaya tawingna babari sero nasani aune Filip giro eyero sena. “Ning na ago ye.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip nung Besaida napora. Andereato Petoro awong napo dekaongka auna ara. ");
INSERT INTO zia_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Arare Filip mene Nataniel taungno eyero sena, “Emo zo Mose mene sao tauyao gera atu ge nuna gaena, arita porofete ena mene deka ayero gaewa, emo awiya tamenane. Nung Yesu Yosepera mani. Nung Nasarete napora arauwa.” ");
INSERT INTO zia_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ayero senu Nataniel mene ge abena eyero sena, “Nona iwaing zo mene Nasarete nape atu kasa yai teng yarinita?” Ayero senu Filip mene abena eyero sena, “Ayero sinesare bung babanano gase.” ");
INSERT INTO zia_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ayero senu Nataniel nung Yesura-una baungnu Yesu mene giro eyero sena, “Ewiya gipu. Emo ewiya Isreli emo me. Ge iwao dubo nuna-una oko mitiya.” ");
INSERT INTO zia_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ayero senu Nataniel mene Yesu atata yero eyero sena, “Na natu newang gigasi?” Ayero senu Yesu mene abena eyero sena, “Filip mene ning oko tamaore na mena ning i fik susuwara atu mitesa gigena arauwa.” ");
INSERT INTO zia_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ayero senu Nataniel mene abena eyero sena, “Gipao emo, ning Tuwa Bayaura Mani me. Ning Isreli emora emo tuwa.” ");
INSERT INTO zia_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ayero senu Yesu mene abena eyero sena, “Ning i fik susuwara atu mitesa giro sesena auna eno gege na tumo didinesa? Tani yeme gigesa awiya agewa gege. Ago nona me baina kasa yero babai gosinarinesa.” ");
INSERT INTO zia_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ayero sero nung eno eyero sena, “Na memokoba sane. Niye uriti be gausai Tuwa Bayaura angelo dubu mene na Emora Mani auna-una witiro wosiro anaya garineya ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Wari be etobe aung yenu Galilaya tawingna napo zo yazo Kena auna atu emo mene bauno ataise sero ana bonene newa Yesura ai dema mitina. ");
INSERT INTO zia_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu buro-mani nuna aune awong dema babaese sewa giro baungno augaiwa. ");
INSERT INTO zia_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Augairo mitasani ou wain miniwa aung yenu giro Yesura ai mene nung eno eyero sena, “Ou wain nunae aung yetiya.” ");
INSERT INTO zia_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ayero senu Yesu mene abena eyero sena, “Na awong soremanese aeno sinesita? Auna be nana oko bao.” ");
INSERT INTO zia_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ayero senu aune ai nuna mene soumani eno eyero sena, “Yesu mene buro ge nomaze sariniye, amaze diungno yepu.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Be aune garo auna atu au babuze 6 mitiwa ara. Yuda emora-una garo sero au ayao ine mitaunu aune awong ewowora tani nasani nonane taungne sainasani nauwa. Au awiya babuze. Au dekaongka auna ou baketi 10 mene sukupunauwa. ");
INSERT INTO zia_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Arare Yesu mene soumani eno eyero sena, “Niye ou dungno aura yasagaipu bebumae.” Ayero senu soumani mene ou dungno aura yasagaiwa bebumuwa ara. ");
INSERT INTO zia_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ayero yewa aune nung eyero sena, “Niye ou aura awiya ena dungno bonene maung eno puro baungpu.” Ayero senu giro ou awiya ");
INSERT INTO zia_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","dungno puro bonene maung eno puro bautunewa ou awiya wain yena ara. Puro bamuwa bonene maung mene mininu bera atu mege yena. Ayero yenu nung ou wain awiya natu buna auna susuwa nung oko gao, arata soumani ou dumuwa amimene gigiwa. Arare bonene maung mene emo bauno atitinena awiya yau senu bunu ");
INSERT INTO zia_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","eyero sena, “Nae gitau ou wain me pugatinonane mininowa dubo sisigati noi aune, ou wain zuma wosao awiya ago pugatinonane mininowa. Tani nanae ayao mitiya ara. Arata nine mene zo ou wain me pungyero ou wain zuma wosao gitau pugesa mineya aune me ago pugatinesa.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu nung Kena napo Galilaya tawingna atu tani putoungne nuna naungna awiya gitau atu zayero yena ara. Ayero yero nung putoung nuna keregainu buro-mani nuna mene tani putoungne awiya giro nung tumo diwa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ataora bonene aung yenu Yesu nung Kena napo doro baung Kapaneam nape yari nenu ai nuna metamaine aune buro-mani nuna amimene nung aune dema bamuwa ara. Baungno atu be daigairo oko nauwa. ");
INSERT INTO zia_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yuda emora iya dang be zo yazo nuna Magayao mene awong Daigaina auna be nugu yenu giro Yesu mene Yerusalem witiro baungna. ");
INSERT INTO zia_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yerusalem nape kasa yero Tuwa Bayaura ibu baina auna pae zo kasa ewe gao auna baungno atu lama aune bulimakao arita ni gumo awiya puro baungno wina-piti nasani newa gigina. Anasani moni tewo tame pugairo moni wina-piti nasani mitiwa ");
INSERT INTO zia_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","giro Yesu mene angsi ena puro tenero aune amimene lama bulimakao aune emore dema tunenu bamuwa tewo monine ininu kapetegainu moni wosi duru yena ara. ");
INSERT INTO zia_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ayero yero emo ni gumo puro dopero mitiwa aeno eyero sena, “Puro baungpu. Niye Mama nana-una ibura etu nona wina-piti yaya stowa ibu ine yoiye sero awang sinena.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yesu nung ayero yenu buro-mani nuna mene ge zo gayao mitoiya awiya kotumuwa. Ge awiya eyao era. Ibu nina ewiya eno tini nana kapinoiya. ");
INSERT INTO zia_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Arare Yuda emo mene Yesu atata yero eyero sewa, “Awe mene sesi tani awiya yetesi? Tuwa Bayau mene sai yarinesa awiya susuwa awiya pu daung gari sero tani putoungne zo ye ganene.” ");
INSERT INTO zia_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ayero sewa Yesu mene be nunae-una ge puro abena eyero sena, “Niye ibu ewiya kasaya nane wari be etama gege mena yana nupema dopariniya.” ");
INSERT INTO zia_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ayero senu awong eyero sewa, “Mamono nanae mene ibu ewiya dawang 46 ayao gapunawe besugaiwa, awiya nine wari be etama gege yasa dopaise sinesa?” Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Arata Yesu nung taung aingso nuna-una ge awiya pu ibu bainana gairo sena ara. ");
INSERT INTO zia_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Arare ago nete magayero aune magayaora atu seka yero iropunu aune buro-mani nuna mene ge awiya kotumuwa ara. Ayero kotupunasani Tuwa Bayaura ge gayao ena aune ge Yesu mene sena aune awiya gigiwa me yena. ");
INSERT INTO zia_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu Yerusalem atu mitasani iya dang auna atu tani putoungne ena yenu emo daigairo mene tani putoungne awiya giro Yesu tumo diwa ara. ");
INSERT INTO zia_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yesu nung nutope emora moko gosinasani susuwa nuna awong eno oko keregao. ");
INSERT INTO zia_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nung emo zora susuwa gari sero emo ena oko atata yero nasani nauna. Nung nutope emora kotumao giro baingtiti nasani nauna arauwa. ");
INSERT INTO zia_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Emo zo nasani nauna yazo nuna Nikodema. Nung Farisayo zo. Nung Yuda emora gitau yao bainakama yero nasani nauna. ");
INSERT INTO zia_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Emo amimene pingne Yesura-una baungno eyero sena, “Gipao emo, nae susuwa nina gosinonane. Ning gipao emo me mene Tuwa Bayaura bera bumasa. Ning tani yero nosa awiya emo mene Tuwa Bayau aung nasani yao ine oko mitiya.” ");
INSERT INTO zia_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ayero senu Yesu mene abena nung eno eyero sena, “Na memokoba sana gi. Zo nung kasa yao seka nupema oko kasa yao yariniya, awiya nung Tuwa Bayaura napo gao ine teng oko.” ");
INSERT INTO zia_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ayero senu Nikodema mene abena eyero sena, “Zo nung zai yao mene nono yero aune kasa yao seka nupema kasa yariniye? Nung aira tingyana nupema towai aune pumao teng oko yarinita?” ");
INSERT INTO zia_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ayero senu Yesu mene abena eyero sena, “Na memokoba sana gi. Zo nung oura ta owenona putoungna oko kasa yao yariniya, awiya nung Tuwa Bayaura nape babao ine teng oko yariniya. ");
INSERT INTO zia_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Zo nung emora mesara kasa yao awiya tawingna taung aingsore dema noiya. Arata zo nung Owenona mesara kasa yao awiya Owenone dema noiya. ");
INSERT INTO zia_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Niye kasayao seka kasayaese sesena awiya nigiro wawong di oko gamase. ");
INSERT INTO zia_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Bisi nung tebe-tabe supunoi ning bewing nuna gege nigitinosa, arata susuwa natu zayero butuniye o baungno natu aung niye, awiya ning susuwa oko gosinosa. Deka ayero zo nung Owenona mesara kasa yao auna susuwa ning oko gosinosa.” ");
INSERT INTO zia_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ayero senu Nikodema mene abena eyero sena, “Tani awiya nono yero kasayari niye?” ");
INSERT INTO zia_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ayero senu Yesu mene abena eyero sena, “Ning Isreli emora gipao emo mene tani awiya oko gao nosa ing? ");
INSERT INTO zia_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","“Na memokoba sane. Nae nona dubora diti mene gosinonane, o nona diti moko mene gosinonane deka awiya sero nonane ara. Ayero yero nonane niye ge nanae doro nowa ara. ");
INSERT INTO zia_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nona tawingna etu kasa yero noiya awiya sero nona giro nowa me oko yero noiya amimene uritira nona mitiya awiya sana nono yero gaya me yariniye? ");
INSERT INTO zia_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Emo zo mene uritira witiro nawe oko wosina. Na Emora Mani nata uritira atu wosiwang. Nane gege nata uritira nona gosinena. ");
INSERT INTO zia_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mose mene gitau eu yanawira atu kapa puro yi yero puro witiro i pasaora ikogaina deka ayero na Emora Mani i pasaora ikogaese sao mitiya. ");
INSERT INTO zia_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Arare na tumo diyarineya amimene nao me iwaing awiya tamarineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Zo nung Tuwa Bayaura mani tumo diyariniya amimene magayero mekora babaise okowata, nung nao me iwaing tamaise sero Tuwa Bayau mene emo bauno name eno dubo bayao bainakama nasani Mani nuna dekaongka iyengtinu wosina ara. ");
INSERT INTO zia_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tuwa Bayaura Mani mene emo gera pugaise auna okowata, emo soraise sero Tuwa Bayau mene senu wosina ara. ");
INSERT INTO zia_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Zo nung Tuwa Bayaura Mani tumo diyariniya amimene Tuwa Bayaura kotora atu oko zuwariniya. Zo nung Tuwa Bayaura Mani oko tumo diyao yariniya nung amimene kotora atu mena zuwetiya ayero yariniya. Noeno okowata, nung Tuwa Bayaura mani dekaongka awiya oko tumo diyao yero noiya. ");
INSERT INTO zia_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Arare kotora atu zuwao auna susuwa eyero mitiya era. Waegao mene tawingna kasa yenu emo awong waegaora babao awang sero mumena katu mitari sewa ara. Awong nao nunae meko, arare ayero yewa. ");
INSERT INTO zia_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Zo nung pasena yero noiya amimene waegao awang noiya. Waegao mene pasena nuna-una susuwa keregoiye sero awang nasani nung waegaora oko kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Awong ge me nigiro puro nowa amimene waegaora kasa yero nowa. Zo nung waegaora kasa yai waegao mene buro nuna-una susuwa keregatinai emo bauno mene giro buro nuna-una me awiya Tuwa Bayaura putoungna atu kasa yero noiya ayero sarineya. ");
INSERT INTO zia_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yesu mene buro-mani nuna punu Yerusalem doro Yudaya tawing agewara baungno nauwa. Atu nasani aune emo ena ge ou suwena. ");
INSERT INTO zia_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohane dema emo bauno ge ou susunasani mitina. Nung tawing zo yazo Ainon, Selim nape ina atu nasani ge ou suwao buro nasani nauna. Nung tawing auna atu nasani nauna, noeno okowata, ou baina atu mitauna. Arare emo bauno nuna-una butunauwa ge ou susunauna ara. ");
INSERT INTO zia_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yohane nung be aune Herode mene bunao gare oko pugaore atu buro nasani nauna. ");
INSERT INTO zia_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Arare Yuda emo zo aune Yohanena buro-mani awong taung aingso sayaora tani auna ge wina-se yewa ara. ");
INSERT INTO zia_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ge sinete buro-mani mene baung Yohanena-una yero eyero sewa, “Gipao emo, gitau ning ou Yodan enabara atu nauwasa emo buro ning taunu susuwa nuna nae eno keregairo sasa, emo amimene be yeme eune emo bauno ge ou susunasani miti giro apakana nuna-una bautuneya.” ");
INSERT INTO zia_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ayero sewa Yohane mene eyero sena,” Emo zo nung uritira Maung mene nona nung eno oko pugao yai nung nutope nona awiya pao ine teng oko ara. ");
INSERT INTO zia_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Na eyero sinasani niye eno sewang gigiwa, ‘Na Kristo okowa, arata Tuwa Bayau mene na pugainu nane nagibo nuna gitau nena.’ ");
INSERT INTO zia_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Emo zo bauno atariniya bauno awiya nuna gege ara. Arare nung yawa yawa nai otao nuna mene nugu dopero ge nuna nigiro deka ayero dubo iwaing yariniya. Emo bauno mene Yesura-una babeya, arare dubo iwaing yaora be nana kasa yetiya. ");
INSERT INTO zia_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nune na daigairo emo tuwa bainakama nibamu yariniya. Arata nane mene zo nuna wese nibamu yarinena.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ika atu wosina amimene witao naname ara. Zo nung tawingna etu kasa yao amimene tawing euna, arare nung tawingna ge sinoiya. Arata uritira atu wosina amimene name apakana daigairo baina naname yero noiya ara. ");
INSERT INTO zia_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nune uritira nona gosinasani nauna awiya name eno keregairo sinoiya, arata emo mene ge nuna dotinowa. ");
INSERT INTO zia_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Zo nung Maina ge nigiro puro pu dube gairo noiya amimene ayero nasani ‘Tuwa Bayau ge me sinoiya’ asero noiya. ");
INSERT INTO zia_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Emo Tuwa Bayau mene senu wosina amimene Tuwa Bayaura ge sinoiya. Noeno okowata, Tuwa Bayau mene Oweno zere tutupore apana nung eno pugao gege pugatinoiya. ");
INSERT INTO zia_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Maung nung Mani nuna aratapu nasani nona apakana Mani nuna-una waweng pugainu mitoiya. ");
INSERT INTO zia_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Zo nung Tuwa Bayaura Mani tumo didinoiya amimene nao me iwaing puro noiya. Arata zo nung Tuwa Bayaura Mani auna ge dero noiya amimene nao me iwaing oko gariniya. Emo ayao auna atu Tuwa Bayaura tini kapao mene mitao gege mitariniya. ");
INSERT INTO zia_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisayo awong Yesura bowi eyero nigiwa, “Yesu nung mani daigairo puro ge ou susuniya, arare emo bauno nung ago neya amimene Yohane ago nowa awiya daigatineya.” Ayero nigiwa ara. ");
INSERT INTO zia_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Arata Yesu nung nutope emo zo ge ou oko suwena. Buro-mani nuna mene emo bauno ge ou susunauwa ara. ");
INSERT INTO zia_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Arare Farisayo ge ayero nigiwa giro Yesu mene Yudaya tawing doro kapetegairo Galilaya tawingna baungna ara. ");
INSERT INTO zia_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Nagibo awiya Samaria tawing busero buwagairo bautunauna. ");
INSERT INTO zia_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yesu mene tawing awiya busero buwagairo bautunete Samaria napo zo yazo Saiko auna kasa yena ara. Napo awiya Yakobo mene mani nuna Yosepe eno tawing agewa pugaina auna nugu mitauna ara. ");
INSERT INTO zia_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nupema tawing auna atu Yakobora ou kote wamao zo mitauna. Arare Yesu nung atu kasa yenu wari diti 12 kilok yena ara. Ayenu nung putoung aung yenu giro ou kote wamao auna nugu atu aduna ara. ");
INSERT INTO zia_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Adungno mitinu Samaria bauno zo ou dumari sero buna. Bunu Yesu mene giro nung eno eyero sena, “Ou piti minane.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Buro-mani nuna awong ma pumari sero nape bamuwa nung nata mitete bauno eno ou isa senu ");
INSERT INTO zia_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","bauno mene nung eno eyero sena, “Ning Yuda emo mene nono yero Samaria bauno na eno ou isa sinesi?” Ayero sena, noeno okowata Yuda emore Samaria emore awong kasugairo nasani nauwa, aeno bauno mene ge awiya sena. ");
INSERT INTO zia_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ayero senu Yesu mene eyero sena, “Nona Tuwa Bayau mene ning eno pugari siniya auna susuwa aune nupema na ou eno sinena auna susuwa dema gasa kasa yatiya, awiya ning ou eno na isa sasa nao me iwaing auna ou awiya ning eno pugatena.” ");
INSERT INTO zia_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ayero senu bauno mene ge abena eyero sena, “Ou kote ewiya tura daung ware, ning kopu ou dumao aung. Arare nao me iwaingna ou awiya natu pumarinesi? ");
INSERT INTO zia_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ewowo naname Yakobo nung ou kote ewiya wauna. Ayero yenu nung aune mani awiso nuna aune lama bulimakao aune awong apakana ou ewiya mininasani nauwa. Nung ou kote ewiya nae eno diriyegaina. Arata ning Yakobo daigatinesa, ayero sinesita?” ");
INSERT INTO zia_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ayero senu Yesu mene eyero sena, “Ou ewiya mininowa nupema ouwe mena yero noiya. ");
INSERT INTO zia_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Arata ou nane pugarinena awiya zo mene minai ouwe nupema oko yariniya. Nane ou awiya emo zo eno pugana, dubo nuna-una atu ou diti ine yero gubigubi nasani mitariniya. Ayero nai emo amimene nao me iwaing puro nasani nariniya.” ");
INSERT INTO zia_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ayero senu bauno mene eyero sena, “Emo, ning ou awiya pugasa miniro ouwe oko nai nane. Ayero na ou eno be ozaung-zaung etu butunona awiya duwane.” ");
INSERT INTO zia_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ayero senu Yesu mene eyero sena, “Ning baungno emo nina puro nito dema baeto.” ");
INSERT INTO zia_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ayero senu bauno mene ge abena eyero sena, “Na emo aung.” Asenu Yesu mene eyero sena, “Ning emo nina aung sisa awiya me sinesa ara. ");
INSERT INTO zia_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ning emo wawong zo ayero atiro doro nosa. Arare be yeme ning emo zore nesa, arata nung awiya emo nina okowa, arare ning ge me sinesa.” ");
INSERT INTO zia_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ayero senu bauno mene eyero sena, “Emo, na yeme susuwa nina gosinena. Ning porofete me. ");
INSERT INTO zia_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Arare se gane. Kikiyongne nanae awong diri euna atu augairo Tuwa Bayau bowi nasani nauwa, arata Yuda emo niye mene zo Yerusalem nape atu Tuwa Bayau bowi nasani nanenese sao mitiya ayero sero nowa.” ");
INSERT INTO zia_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ayero senu Yesu mene abena eyero sena, “Bauno, na ge sana nigasa me yaise. Be zo nugu niya. Be awiya kasa yai aune niye Mama bowi yari sero diri eunata Yerusalem nape atu oko yarineya. ");
INSERT INTO zia_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Niye awiya oko giro baingtao nasani bowi nowa. Nanae mene zo giro baingtiti nasani bowi nonane. Noeno okowata, korayao iwaing yao awiya Yudara-una atu gitau kasa yaise sao mitiya. ");
INSERT INTO zia_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Be zo bariniya, be aune Tuwa Bayaura emo dubu me mene nung bowi yari sero ititire nao mere mene yarineya. Mama nung emo ayao mene nung bowi yaese arataungno yero noiya. ");
INSERT INTO zia_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tuwa Bayau nung taung aingso okowata, nung ititi. Arare niye nung bowi yari sero taung mene okowata, ititire nao mere mene nung bowi nasani neupu.” ");
INSERT INTO zia_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ayero senu bauno amimene ge abena eyero sena, “Na gosinena, Mesia yazo nuna zo Kristo amimene bariniya. Nung buro nona apakana pu daung gariniya.” ");
INSERT INTO zia_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ayero senu Yesu mene nuna bera puro eyero sena, “Ge sinesa awiya mani zo oko mitiya. Na gege ara. Na ning aune dema ge sinena, naka kerauwa.” ");
INSERT INTO zia_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ge ayero sinenu buro-mani kasa yero nung baunone dema ge ungwe newato awiya giro wawong di gamuwa ara. Arata susuwa no eno bauno eno ge siniye, o nono yero siniye, ayero sero atata yaora awiya gigiwa teng oko yenu giro duwa ara. ");
INSERT INTO zia_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ayero yewa bauno nung kopu ou dumao nuna doro sungno baung nape yero emo bauno eno eyero sena, ");
INSERT INTO zia_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Niye bungpu. Baungno emo zo gae. Nune nao nana-una susuwa apakana na eno keregaiya. Nung Kristo, ta?” ");
INSERT INTO zia_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ayero senu awong kara Yesu gari bamuwa. ");
INSERT INTO zia_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Awong Yesura-una butunewa buro-mani nuna mene Yesu eno eyero sewa, “Gipao emo, ning nona mini.” ");
INSERT INTO zia_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ayero sewa ge abena eyero sena, “Ma nana mitiya. Awiya niye oko gosineya.” ");
INSERT INTO zia_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ayero senu buro-mani nuna mene awong nuka nuyetope wina-se yero eyero sewa, “Awe mene ma puro bumiye?” ");
INSERT INTO zia_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ayero sewa giro nung eyero sena, “Nung na iyengtinu bumuwang auna be diungno buro nuna yero bautunete besugarinena amimene ma nana niya arauwa. ");
INSERT INTO zia_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Niye nika niyetope eyero sero nowa, ‘Ino siwongpatige ayao aung yai aune ma me yariniya.’ Ayero sinowa, arata nane mene zo eyero sinena. Niye diti-dati yero buro gipu. Ma pumaora be kasa yero mitiya. ");
INSERT INTO zia_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Emo zo nung ma puro pu dekaongna gao buro yero noiya amimene zuma pupunoiya. Nung ma zo nao me iwaingna gerao awiya pu gare gatinoiya. Arare emo ma urao emo arita emo ma pumao emo awongto amimene dema yawa yawa yarineyato. ");
INSERT INTO zia_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Arare ge eyero sinonane amimene etu me yariniya, ‘Zo mene uraora buro noiya, arata zo mene pumaora buro noiya.’ ");
INSERT INTO zia_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ma niye oko urao yewa auna me awiya pu gare gaese sesena babarineya. Buro awiya ena mene yewa auna me niye pupuneya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria emo bauno daigairo mene baunona ge nigiro Yesu tumo diwa ara. Ayero yewa, noeno okowata, bauno mene nao nuna-una susuwa awiya apakana Yesu mene keregainu giro emo bauno eno susuware senu nigiwa. ");
INSERT INTO zia_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Arare awong Yesura-una buro Yesu awong aune dema naise yuno puro baung nape yari sewa giro Yesu mene awong aune dema wari be etobe nauna ara. ");
INSERT INTO zia_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Atu ge tugata nasani nenu emo bauno daigairo mene ge nuna nigiro nung tumo diwa. ");
INSERT INTO zia_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ayero yero bauno eno eyero sewa, “Gitau nae ungwe nina nigiro nung tumo diyenane. Arata yeme ewiya nae be-giti nuna-una atu ge nigiro eyero sinenane: Nung tawing sero sero auna emo bauno auna Korayao Emo me.” Ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu nung Samaria emo bauno aune dema be etobe mitete awong doro Galilaya tawingna baungna. ");
INSERT INTO zia_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu nung ge gitau eyero sena, “Porofete awong napo nunae-una kasa yero emo yazore oko yero nowa.” ");
INSERT INTO zia_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Arare Yesu mene Galilaya tawingna baungno kasa yenu Galilaya emo nung giro arugairo yawa yawa yewa. Awiya noeno okowata, be zore awong baung Yerusalem yero Yuda emora iya dang auna atu buro Yesu mene yena awiya gigiwa. ");
INSERT INTO zia_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu mene Galilaya tawingna kasa yero Kena nape baungna. Napo auna atu nung gitau senu ou mene wain yena. Atu baungnu, Kapaneam napo auna diya emo baina zo nasani nauna auna mani yaya mouyao puro mitina. ");
INSERT INTO zia_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Arare “Yesu nung Yudaya tawing doro yesese yero bung Galilaya tawingna niya” ayero sewa giro diya emo amimene baung Kena nape yero Yesura-una baungna ara. Baungno mani nuna magayari sero nasani nenu giro Yesu yuno puro gare baungno mani nuna kora yaise sena. ");
INSERT INTO zia_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ayero senu Yesu mene nung eno eyero sena, “Niye tani putoungne ena aune buro baina ena awiya oko gao yarineya, awiya niye na oko tumo diyarineya.” ");
INSERT INTO zia_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ayero senu diya emo mene eyero sena, “O Tuwa, mani nana magayoiye sero, mena babasese sinena.” ");
INSERT INTO zia_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ayero senu Yesu mene nung eno eyero sena, “Ning teba baung. Mani nina iwaing yetiya arauwa.” Ayero senu diya emo nung Yesura ge niginu me yenu giro baungna ara. ");
INSERT INTO zia_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Yesese yero bautu nenu soumani nuna ena mene bowi puro buro nung taungno eyero sewa, “Mani nina iwaing yero niya.” ");
INSERT INTO zia_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ayero sewa giro mani iwaing yena auna wari diti be awiya gari sero atata yenu sewa, “Sipe wari diti towang dopero mitesesi aune taung kokoni yao nuna aung yetiya.” ");
INSERT INTO zia_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ayero sewa diya emo mene susuwa eyero gigina: Be aune Yesu mene na yesese yanese sero eyero sesiya, “Mani nina iwaing yetiya.” Arare diya emo mene susuwa awiya giro nung arore awisore Yesu tumo diwa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesu tani yena, awiya nung Yudaya tawingna atu yesese yero buro Galilaya tawingna kasa yero aune tani awiya yena, awiya tani putoungne namba tu Galilaya atu yena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yuda emora iya dang auna be bunu Yesu nung witiro baung Yerusalem yena ara. ");
INSERT INTO zia_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Goma napo Yerusalem zimao auna towaora be zo yazo nuna Lama Towao be. Towao be auna atu ou ubutu zo mitauna yazo nuna Yuda gera Betesida. Ou auna deung bera atu bisi paora garo wawong zo mitauna. ");
INSERT INTO zia_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Garo auna emo yayare witao amimene apepegairo mitauwa. Emo ena diti guma yao, o ena te amao, o ena yu soyao daigairo mene atu mitauwa. Awong ou kapu yai gari diya mitauwa. ");
INSERT INTO zia_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Atu mitauwa be ena Tuwa Bayaura angelo zo mene wosiro ou ubutu awiya dedunaunu kapu naunu yaya emora-una atu zo mene gitau gitau yero wosi oura yero gutero yaya nuna mena aung naunu iwaing yero nasani nauwa. ");
INSERT INTO zia_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Arare emo zo nung asama yero mitawe dunu dawang 38 aung yena amimene atu mitina. ");
INSERT INTO zia_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu mene emo awiya giro yaya nuna nimoi-namoi mitauna awiya giro nung eno eyero sena, “Ning iwaing yari kotupunesita?” ");
INSERT INTO zia_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ayero senu emo asama amimene abena eyero sena, “O emo, ou kapu noi aune awe mene naka wawong iniro pumai wosiro ou awiya gutero iwaing yateni? Ena mene na daigairo wosi oura yero nowa giro na mitima nona.” ");
INSERT INTO zia_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ayero senu Yesu mene nung eno abena eyero sena, “Ning iropuro awao masi nina puro angye.” ");
INSERT INTO zia_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ayero senu emo asama awiya taung iwaing yenu nung iropuro masi nuna puro angyena ara. Wari be awiya Yuda emora Sabat iya dang mitiwa ara. ");
INSERT INTO zia_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Arare Yuda emo mene emo iwaing yena aeno eyero sewa, “Iya be dang euna sao tauyao ge naname mitiya awiya ning noeno daigati nasani awao masi nina puro nesi?” ");
INSERT INTO zia_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ayero sewa nung ge abena eyero sena, “Na kora yetiya emo amimene eyero sesiya, ‘Masi nina puro angye.’” ");
INSERT INTO zia_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ayero senu awong eyero sewa, “Masi nina puro angye, awiya emo yazo awe mene sesiye?” ");
INSERT INTO zia_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ayero sewa emo senu iwaing yena amimene Yesura yazo kauyena. Noeno okowata, Yesu nung emo dubu dopero mitiwa auna towang atu saingtiro baungna ara. ");
INSERT INTO zia_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ago Yesu mene emo awiya Tuwa Bayaura ibu bainana atu taungno eyero sena, “Ning taung nina iwaing yetiya, arata mou yao zo nina-una kasa yoiye sero, pasena doro neu.” ");
INSERT INTO zia_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ayero senu nung Yesu giro baingtiro baungno Yuda emo eno eyero sena, “Emo na kora yetiya awiya yazo nuna Yesu.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesu nung Sabat iya dang aune buro ayero nasani nauna, arare Yuda emo mene giro nung iwo yewa ara. ");
INSERT INTO zia_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ayero yewa Yesu mene eyero sena, “Mama nana nung buro yao gege nasani noiya, arare na deka ayero buro nona.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesu nung Sabat iya dang sisigaina, nupema Tuwa Bayau nung Maung nuka nuna asinasani nung Tuwa Bayau ine ayero sena. Asenu Yuda emo mene gigiwa meko yenu giro awong nung dari sero nagibo tamari yewa. ");
INSERT INTO zia_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ayero sewa Yesu mene abena eyero sena, “Na memokoba sana nigipu. Na Mani mene kotumao nana-una gege buro oko yero nona. Mama nana mene noiya a giro yero nona. Mama mene noi giro na Mani mene deka ayero yero nona. ");
INSERT INTO zia_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mama nung na Mani nuna ewiya giro ara bainakama tapunoiya, arare buro noiya awiya teng gipinoiya. Arata buro ewiya gege okowata, buro witao ena mitiya awiya dema Mani eno gipai giro niye yangka sero wawong di gamarineya ara. ");
INSERT INTO zia_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mama nung emo magayao uwinoi seka yero nowa deka ayero na Mani mene aratamao nana-una zota zo awiya uwana seka yarineya ara. ");
INSERT INTO zia_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mama nung emo zaz oko noiya. Buro awiya apakana Maina waweng pugaina ara. ");
INSERT INTO zia_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Arare emo awong Mama bowi yero nowa, deka ayero Mani bowi yaese. Zo nung Mani oko bowi yao yariniya amimene Mama na iyengtina awiya dema oko bowi yao noiya ayero yariniya. ");
INSERT INTO zia_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Na memokoba sana nigipu. Zo nung ge nana nigiti nasani Mama nana na iyengtina auna ge nigitiniya amimene nao me iwaing yeme eune puro niya. Nung kotora atu oko zuwari niya. Nung tauyero magayao doro naora kasa yero noiya. ");
INSERT INTO zia_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Na memokoba sana nigipu. Be zo kasa yariniya — erawa mena kasa yero mitiya era — be aune mamagayao mene yaine nowa amimene Tuwa Bayaura Mani auna ge bewing nigarineya. Ena mene ge nigiro baingtiro seka yero narineya. ");
INSERT INTO zia_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mama nung naora Maung, arare nung na Mani nuna eno nao diriyegainu na naora Maung yero nona. ");
INSERT INTO zia_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na Mani, na Emora Mani. Arare Mama nana mene emora koto auna zaz buro awiya na Mamana bera yanese sero putoung na eno pugaina. ");
INSERT INTO zia_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Niye ge awiya nigiro oko wawong di gamae. Noeno okowata, be zo pugao mitiya awiya kasa yai aune mamagayao biritira atu awinowa amimene wawa nana nigarineya. ");
INSERT INTO zia_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ayero nigiro iwaing nasani nauwa amimene iropuro nao me iwaing tamarineya. Arata meko yero nasani nauwa amimene zo iropuro koto yero kotora atu zuwarineya ara. ");
INSERT INTO zia_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Na dubo nana-una buro zo yao ine oko mitiya. Na ge Mama nana-una bera atu nigitinona deka ayero nasani kotora zaz yero nona ara. Ayero nasani kotora zaz buro yana teng yariniya. Noeno okowata, na aratamao nana-una okowata, nung na senu wosiwang auna aratamao ago yari yero nona ara. ");
INSERT INTO zia_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Na natope susuwa nana sana teng oko yariniya. ");
INSERT INTO zia_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Susuwa nana awiya zo mene keregatinoiya. Nung susuwa nana keregati nasani ge me siniya awiya gosinena. ");
INSERT INTO zia_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Niye seseya buro-mani ninae mene Yohanena-una baungno atata yewa nung ge me keregairo sena ara. ");
INSERT INTO zia_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Emo zo mene susuwa nana keregaise awiya oko aratapunena. Niye susuwa nana nigaya Tuwa Bayau mene niye sorero pumaise sero niye eno sesena ara. ");
INSERT INTO zia_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohane nung waegao bainakama ine yero nasani niye waegaina. Waegao nuna giro be apungkaka gege yawa yawa nasani nauwa ara. ");
INSERT INTO zia_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Arata susuwa nana keregatinoiya amimene nung Yohane ine okowata. Nung witao. Buro Mama mene yanese sena awiya yero nona. Buro amimene susuwa nana eyero keregatinoiya: Mama mene senu wosiwang arauwa. ");
INSERT INTO zia_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nupema Mama na senu wosiwang amimene susuwa nana keregatinoiya. Niye be nuna-una ge oko nigao yero nowa. Niye diti moko nuna oko gao yero nowa. ");
INSERT INTO zia_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ge nuna dubo ninae-una oko mitoiya. Noeno okowata, niye Mama na senu wosiwang auna ge nigitinowa me oko yero noiya. ");
INSERT INTO zia_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Niye eyero sero nowa, ‘Tuwa Bayaura ge gayao amimene nao me iwaing name eno pugariniya.’ Ayero sinasani nao me iwaing tamari sero ge gayao zazagati nasani nowa. Ge gayao amimene susuwa nana keregatinoiya, ");
INSERT INTO zia_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","arata niye na nao me iwaing niye eno puganese sero na aune dema tayao awang sinowa. ");
INSERT INTO zia_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Emo mene na bowi yaese oko sinona. ");
INSERT INTO zia_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Na susuwa ninae gosinona. Dubo ninae zo Tuwa Bayau Mama nana auna-una oko mitoiya. ");
INSERT INTO zia_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na Mama nana-una ge diungno ninae-una wosiwang, arata niye ge nana doro na oko otao yero nowa. Nete emo zo kotumao nuna-una kasa ninae-una yai aune nung aune dema otao yarineya. ");
INSERT INTO zia_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Niye niyetope bowi wina-ye nasani nowa. Arata Tuwa Bayau nata niye bowi yaise ayero oko sao yero nowa amimene nono yero na tumo diyarinei? ");
INSERT INTO zia_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Niye na eno eyero oko sepu, ‘Nune name gera pugai ge buro yarinenane.’ Na eno ayero oko sepu. Niye Mose tumo diro yero nowa, arare Mose mene niye gera pugariniya. ");
INSERT INTO zia_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mose mene ge gaena, awiya na eno gaena ara. Niye ge nuna nigaya me yatiya, awiya niye ge nana dema nigaya me yatiya. ");
INSERT INTO zia_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Arata niye Mosera ge gayao awiya nigiwa me oko yao yenu giro dewa, arare nono yero ge nana nigaya me yariniye?” Yesu mene ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yesu mene ge awiya senu aung yenu aune Galilaya ou nazi buwagairo baung enabara yena ara. Ou nazi auna yazo zo Taibirias asinowa. ");
INSERT INTO zia_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Buwagairo baungnu emo bauno yayare kora naunu iwaing nauwa awiya ena mene gosinauwa, arare emo bauno dubu bainane mene nung ago yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ayero yewa Yesu mene buro-mani nuna puro witi diri yero adungno mitiwa ara. ");
INSERT INTO zia_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Be auna atu Yuda emora iya dang zo yazo nuna Magayao mene awong Daigaina auna be nugu yena ara. ");
INSERT INTO zia_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Arare Yesu mene emo bauno dubu baina nuna-una butunewa giro Filip atata yero eyero sena, “Ma naina atu puro emo bauno dubu baina aeno puganane minaya teng yariniye?” ");
INSERT INTO zia_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu nung buro zo yari kotupunena, arata nung Filip gaero gari atata yero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ayero senu Filip mene eyero sena, “500 kina mene ma puro puganane minaya teng oko yarinita, nowa.” ");
INSERT INTO zia_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ayero senu buro-mani nuna zo Anderea, nung Simon Petorora meta, amimene eyero sena, ");
INSERT INTO zia_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Mani zo mene ma wawong zore ou wo etore puro niya. Arata emo bauno dubu baina, arare teng oko yarinita, nowa.” ");
INSERT INTO zia_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ayero senu Yesu mene eyero sena, “Niye sepu emo bauno au dekaongna gairo adumae.” Ayero senu giro awong sewa tawing auna yowangze mitina awiya isiyero adumuwa. Zare nunae awiya emo 5,000 ayao ine amimene adumuwa ara. ");
INSERT INTO zia_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ayero yewa Yesu mene ma puro Tuwa Bayau eno dange sero emo bauno adungno mitiwa aeno bono yena. Ou wo deka ayero yenu teng yena. ");
INSERT INTO zia_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Miniwa teng yenu itoto duwa giro Yesu mene buro-mani nuna eno eyero sena, “Nona itoto mitete meko yariniya, aeno yangtagaipu.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Asenu ma wawong zo miniwa auna itoto awiya yangtagaiwa saka 12 ayao be buna. ");
INSERT INTO zia_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Emo mene tani putoungne awiya giro Yesu bowi nasani eyero sewa, “Porofete bainakama zo tawingna etu kasa yaise sao awiya era.” ");
INSERT INTO zia_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ayero sero Yesu puro emo tuwa nunae pugaya naise sinewa giro nung emo dubu awiya doro nata witiro baung diri yena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ture inu buro-mani nuna mene ou nazira wosiro ");
INSERT INTO zia_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kapaneam nape yesese yero babari sero wangna witiro bamuwa ara. Ayero bautunewa ping inu Yesu mene nunae-una oko kasa yao yenu ");
INSERT INTO zia_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","bisi tauyao nibamu bunu kakawa bainakama denu ");
INSERT INTO zia_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","awong dawero baung towang yero 5 kilomita ayao newa aune Yesu mene ou tame atu ang yero baungno wang nunae-una nugu kasa nenu giro awang yewa ara. ");
INSERT INTO zia_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Awang yewa giro Yesu mene eyero sena, “Awang oko yae. Nane butunena arauwa.” ");
INSERT INTO zia_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ayero senu giro awong yawa yawa nasani nung iniwa wangna witinu aune awong napo babari sero newa auna mena kasa yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Iya gainu emo bauno ou nazi enabara awinewa amimene eyero sewa, “Pingne wang dekaongka gege miti buro-mani nuna mene Yesu doro awong nata wangna witiro babeya ara.” ");
INSERT INTO zia_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ayero sewa, arata wang ena Taibirias nape atu buro kakamo Tuwa mene ma gao yenu miniwa auna bumuwa ara. ");
INSERT INTO zia_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Arare emo bauno mene Yesu buro-mani nuna aune awiya kau nete awong tamari sero wang buro mitiwa auna witiro baung Kapaneam nape yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Baung ou enabara yero Yesu kau nete taungno eyero sewa, “Gipao emo, ning nazi besi?” ");
INSERT INTO zia_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ayero atata yewa Yesu mene eyero sena, “Na memokoba sana nigipu. Tani putoungne nona gosinowa aeno okowata, ma pugena mineya aeno gege na tamari sero kau neya. ");
INSERT INTO zia_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Niye ma zo mitima mena aung noiya aeno okowata, nao me iwaingna ma auna buro yepu. Na Emora Mani awiya Tuwa Bayau Mama mene putoung na eno pugainu pumuwang. Arare nao iwaingna ma awiya nane niye eno pugarinena.” ");
INSERT INTO zia_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ayero senu awong ge abena eyero sewa, “Nae nono yero Tuwa Bayaura buro yarinenine?” ");
INSERT INTO zia_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ayero sewa nung eyero sena, “Tuwa Bayaura buro eyao era. Na Tuwa Bayau mene senu wosiwang na awiya tumo dipu.” ");
INSERT INTO zia_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ayero senu awong ge abena eyero sewa, “Ning tani putoungne no yasa ganane ge nina me yari niye? ");
INSERT INTO zia_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Aya ewowo nanae eu yanawira atu nasani ma yazo mana awiya mininasani nauwa. Auna ge gayao eyero mitiya era: ‘Uritira ma pugati naunu mininauwa.’” ");
INSERT INTO zia_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ayero sewa Yesu mene awong eno eyero sena, “Na memokoba sana nigipu. Mose nung uritira ma niye eno oko pugaina. Mama nana mene uritira ma me niye eno pugatinoiya ara. ");
INSERT INTO zia_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ma Tuwa Bayau mene pugatinoiya amimene uritira atu wosiro tawingna emo bauno niye eno nao tapunoiya.” ");
INSERT INTO zia_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ayero senu abena eyero sewa, “O Tuwa, ning ma sinesa awiya be giti nae eno pugairo neu.” ");
INSERT INTO zia_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ayero sewa abena eyero sena, “Nao pugaora ma na era. Zo nung na aune dema tairo nariniya amimene meri oko nariniya. Zo nung na tumo diyariniya amimene ouwe oko yariniya. ");
INSERT INTO zia_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Na sesena gigeya. Niye na gosinowa, arata niye na oko tumo diyao yero nowa. ");
INSERT INTO zia_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Emo bauno Mama mene na eno pugatinoiya amimene apakana nana-una kasa yarineya. Zo nung nana-una bai na nung oko awang sarinena. ");
INSERT INTO zia_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Uritira atu wosiwang awiya kotumao nana-una okowata, Mamana bera buro nuna yari sero wosiwang ara. ");
INSERT INTO zia_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nung senu wosiwang auna aratamao eyao era: Emo bauno dubu na eno pugaina awong awiya sisigairo meko yowi sero, be bainana atu awong uwana apakana iropaese. ");
INSERT INTO zia_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Mama nana-una aratamao awiya eyero mitiya era: Awong na Mani giro baingtiro tumo diyari neya amimene nao me iwaing pumarineya. Ayero yaya nane be bainana atu awong uwana iroparineya. Mama nana-una aratamao ayero mitiya arauwa.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesu mene “Ma uritira atu wosina awiya na ara,” ayero sena. Asenu Yuda emo gigiwa meko yenu giro eyero sewa, ");
INSERT INTO zia_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Emo awiya nung Yesu. Nung Yosefera mani arauwa. Name ai maungne nuna gosinenane. Arare noeno nung uritira atu wosinu siya ayero siniye?” ");
INSERT INTO zia_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ayero sewa Yesu mene eyero sena, “Niye gugumama oko sepu. ");
INSERT INTO zia_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Zo nung kotumao nuna-una gege nana-una bao auna yani oko mitiya. Mama na senu wosiwang amimene nung watimariniya, ami zo nung nana-una bariniya. Ayero yai nane be bainana atu uwana seka yero iropariniya. ");
INSERT INTO zia_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Porofete mene ge zo eyero gaewa mitoiya era: ‘Tuwa Bayau nung nutope emo apakana ge nuna tugata yariniya.’ Arare zo nung Mama mene ge gipai nigiro kotumao tamariniya amimene nana-una bariniya. ");
INSERT INTO zia_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Emo awe mene Mama gigine? Aung arauwa. Tuwa Bayaura-una atu wosiwang na dekaongka amimene Mama gigiwang ara. ");
INSERT INTO zia_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Na memokoba sana nigipu. Zo nung na tumo didinasani noiya amimene nao me iwaing awiya puro noiya ara. ");
INSERT INTO zia_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Naora ma na era. ");
INSERT INTO zia_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Aya ewowo ninae eu yanawira atu nasani ma yazo mana mininasani nawe mamagayewa. ");
INSERT INTO zia_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Arata uritira ma miniro oko magayao nao gege nao awiya na era. ");
INSERT INTO zia_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Naora ma uritira atu wosina awiya na era. Arare zo nung ma awiya miniro nao gege nariniya. Goi nana mene ma niya ara. Arare emo bauno mene nao tamaese pugarinena.” ");
INSERT INTO zia_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ayero senu Yuda emo nuka nuyetope wina-se yero eyero sewa, “Nung nono yero goi nuna pugai minanenese siniye?” ");
INSERT INTO zia_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ayero sewa Yesu mene eyero sena, “Na meba sinena. Niye Emora Mani auna goire yure oko minao yarineya, awiya nao me dubo ninae-una oko mitariniya. ");
INSERT INTO zia_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Zo nung goi nana aune yu nana aune minariniya amimene nao me iwaing tamariniya. Ayero yai nane be bainana atu nung uwarinena ara. ");
INSERT INTO zia_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Goi nana mene ma me. Yu nana mene ou minao me. ");
INSERT INTO zia_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Goi nana aune yu nana aune minariniya amimene na aune dema nariniya. Ayero yai na deka ayero nung aune dema narinena. ");
INSERT INTO zia_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mama nung naora Maung amimene na senu wosiwang, arare nao nana awiya Mamana-una tauyao mitoi nona. Arare zo nung na minariniya awiya deka ayero nao nuna nana-una mitai nariniya. ");
INSERT INTO zia_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Uritira ma auna susuwa ayao mitiya ara. Awiya aya ewowo ninae mene miniwa, ayao ine okowata. Awong ma awiya mininasani mamagayewa. Arata zo mene ma ewiya minariniya amimene nao gege nariniya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu nung Kapaneam nape atu yere ibura atu ge awiya awong eno tugata yena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Dubu nuna-una ena mene ge awiya nigiro eyero sewa, “Ge awiya nigenane teng oko niya. Ge awiya awe mene nigai teng yariniye?” ");
INSERT INTO zia_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ayero sinasani dubo tu mene gugumama gagumama sinewa Yesu mene mena yetine yero giro eyero sena, “Ge awiya nigeya meko nita? ");
INSERT INTO zia_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Arare na Emora Mani mene nupema kapetegairo uritira witana gaya nono yariniye? ");
INSERT INTO zia_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Oweno mene nao emo bauno eno pugatinoiya. Taungna goi mene oko sorepunoiya. Na ge sinona awiya Owenone arita naore ara. ");
INSERT INTO zia_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Arata niye zo nigiro na tumo oko diyao yero nowa.” Yesu mene ayero sena. Noeno okowata, nung awong ena mene ge nuna nigiro nung tumo oko diyao yarineya auna benaung nunae gitau otu mena giginu aung yena ara. Arita emo nung keregari nauna auna benaung dema mena giginu aung yena. Aeno ge awiya sena ara. ");
INSERT INTO zia_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Arare nung ge zo susuuno eyero sena, “Na aeno eyero sinena era. Zo nung Mama mene oko soremao yai nana-una bao auna yani oko mitiya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Arare be auna atu dubu nung ago nauwa auna ena mene nung aune dema nao awiya bereya yenu nung doro bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ayero yewa Yesu mene buro-mani 12 atata yero eyero sena, “Niye deka ayero na duwari kotupuneita?” ");
INSERT INTO zia_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ayero senu Simon Petoro mene abena eyero sena, “Tuwa, ning doro zo ana-una babari nenine? Nao me iwaing auna ge nina-una mitoiya. ");
INSERT INTO zia_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Arare nae ning tumo didinasani eyero gigenane me yetiya: Ning Tuwa Bayaura Mani dang.” ");
INSERT INTO zia_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ayero senu Yesu mene abena eyero sena, “Na niye buro-mani 12 yangtagairo pumuwang. Arata ninae-una zo mene nono yero Sanda ine yero niye?” ");
INSERT INTO zia_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ayero sena, awiya nung Simon Iskeriot auna mani yazo Yudas aeno sena. Nung Yesura buro-mani 12 auna otao zo amimene nawe Yesu keregairo iwora waweng pugaina. ");
INSERT INTO zia_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yesu mene ayero senu giro Yuda emo ena mene Yesu dari sero opene ge diwa tauyenu Yesu mene ge awiya nigiro giro Yudaya tawing doro Galilaya tawingna gege atu buro baungno nasani nauna ara. ");
INSERT INTO zia_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ayero nenu Yuda emora iya dang zo yazo nuna Koubogara Iya Dang auna be nugu yena ara. ");
INSERT INTO zia_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ayero yenu metamani nuna mene nung eno eyero sewa, “Ning tawing ewiya doro Yudaya tawingna baungno tani ena yero nosa awiya otu yasa emo bauno ning ago yero nowa amimene gae. ");
INSERT INTO zia_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Zo nung emo baina yari kotupunoiya amimene buro nuna oko puingnoiya. Arare ning buro me iwaing yero nasani giro baungno emo bauno apakana auna benaungna atu ye gae.” Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Metamani nuna mene ge ayero sewa, noeno okowata, awong nung tumo oko diyao nasani nauwa. ");
INSERT INTO zia_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ayero sewa Yesu mene awong eno eyero sena, “Be nana oko bao. Niye zo be aung buro gege yero nowa teng yero noiya. ");
INSERT INTO zia_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Emo bauno mene niye iwo yao ine teng oko. Arata nane mene zo nao nunae meko awiya keregatinona giro na iwo yero nowa. ");
INSERT INTO zia_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Niye augaora baungpu. Nane zo augao auna oko babari nena. Noeno okowata, be nana oko kasa yao.” ");
INSERT INTO zia_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ayero sero nung Galilaya tawingna kaatu mitinu ");
INSERT INTO zia_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","awong gitau bautunewa aune nung nata opene ago baungna ara. ");
INSERT INTO zia_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ayero yenu iya dang be nugu yenu Yuda emo babuze amimene nung kau nasani eyero sewa, “Nung natu mitiye?” Ayero sinewa ");
INSERT INTO zia_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","aune emo dubu baina amimene ge daigairo sinasani ena mene eyero sewa, “Nung emo iwaing.” Asinewa ena mene eyero sewa, “Aungwa. Nung ge iwi nasani emo bauno etegati noiya.” Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Arata dubu baina mene Yuda emo babuze awiya awang nasani ge bautara sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Iya be dang towang daung yenu Yesu mene Tuwa Bayaura ibu bainana mokora toiro emo bauno ge tugata yena. ");
INSERT INTO zia_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ge tugata nenu Yuda emora gitau yao mene giro wawong di gauno eyero sewa, “Nung nigao garo naname-una oko towao amimene nono yero ge susuware nigine?” ");
INSERT INTO zia_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ayero sewa Yesu mene eyero sena, “Na gera susuwa niye eno tugata yero nona, awiya nana okowata, na senu wosiwang auna arauwa. ");
INSERT INTO zia_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Niye na kotumao nana-una gege ge tugata yero nonita Tuwa Bayaura bera ge tugata yero noni, ayero sinowa. Arata emo zo mene Tuwa Bayaura ge dipunasani nariniya amimene na ge sinona auna susuwa gariniya. ");
INSERT INTO zia_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Emo zo nung kotumao nuna-una ge tugata yero noiya amimene taung nuna puro witari sero noiya. Arata emo zo nung buro burora maung auna bowi kasa yaise sinoiya amimene ge iwao aung ge me gege sinoiya. ");
INSERT INTO zia_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mose mene sao tauyao ge gaero niye eno pugaina, arata ninae-una zo mene oko dipunoiya. Arare noeno na dari sinei?” ");
INSERT INTO zia_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ayero senu emo bauno amimene girara sero eyero sewa, “Ning iwae mene dubo nina-una miti dau nasani sinesa. Awe mene ning dari siniye?” ");
INSERT INTO zia_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ayero sewa Yesu mene abena eyero sena, “Na tani putoungne dekaongka yewang niye giro wawong di gauno kotupu nasani mitowa ara. ");
INSERT INTO zia_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Sana nigipu. Mose mene mani emodidi ninae-una taung aingso agewa kapaese sena. Awiya Mose mene okowata, aya ewowo ninae mene zayewa ara. Arare buro awiya yaora be butunoi Sabat iya auna atu yero nowa. ");
INSERT INTO zia_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Awiya Mosera sao tauyao ge daigowi sero niye Sabat iya auna atu mani emodidi ninae auna taung aingso kapero nowa. Arata nane mene zo emo zora taung aingso zere tutupore awiya Sabat iya auna atu kora yewang. Aune niye noeno na eno tini kapao pupunei? ");
INSERT INTO zia_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Na pasena yaine yewang asero buro nana meko oko sae. Buro nana-una susuwa giro baingtiro aune buro iwaing ta meko ing, awiya sepu.” ");
INSERT INTO zia_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ge ayero senu Yerusalemna emo bauno ena mene eyero sewa, “Emo dari sinowa awiya era. ");
INSERT INTO zia_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Gipu. Nung awong eno ge benaungna atu pasero siniya, arata awong nung eno ge zo oko sao neya. Pirisa awong nung gosinowa Kristo yero noita? Aungta nowa. ");
INSERT INTO zia_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Name kasayao nuna gosinenane. Arata Kristo bariniya auna kasa yao awiya zo mene oko gariniya.” Ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu nung Tuwa Bayaura ibu bainana atu dopero ge tugata nenu ge awiya sewa nigiro abena eyero sena, “Niye na gosinowa, nupema kasayao nana-una susuwa gosinowa. Arata na kotumao nana-una oko wosiwang. Nung na senu wosiwang awiya me ara. Niye nung oko gosinowa. ");
INSERT INTO zia_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Na nuna-una atu wosiwang, nupema nune senu wosiwang, arare na nung giro baingtitinona.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ayero senu awong nung bunari sewa, arata be nuna oko bao, arare wawong nuna-una tame pugao awiya mou yero duwa ara. ");
INSERT INTO zia_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ayero yewa emo bauno daigairo mene Yesu tumo diro eyero sewa, “Kristo bariniya awiya emo emimene tani putoungne yero noiya awiya daigairo yarinita? Aungta nowa.” Ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Emo bauno awong ge ayero opene sinewa Farisayo mene nigiro pirisa babuze enane dema augairo Yesu bunari sero ge sinete gorobo emo iyengtiwa Yesu pari sero bamuwa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu mene eyero sena, “Na be apungka gege niye aune dema nete nung na senu bumuwang auna-una kapete garinena ara. ");
INSERT INTO zia_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ayero yana niye na kauyao buro bainakama yero oko tamari neya. Baungno narinena auna niye babao ine teng oko ara.” ");
INSERT INTO zia_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ge ayero senu Yuda emo nuka nuyetope ge wina-se yero eyero sewa, “Nung natu babai kau yanenese siniye? Yuda emo otao mani naname Grik tawingna atu nowa auna-una baungno Grik emo ge tugata yari sinita? ");
INSERT INTO zia_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nung eyero sesiya, ‘Na kau yero oko tamarineya. Nupema babarinena auna niye babao ine teng oko.’ Noeno ge ayero siniye?” Ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Iya dang awiya besugatinenu Yuda emo awong augairo mitiwa aune Yesu mene iropuro dopero wawa sero eyero sena, “Zo nung ouwe yai giro nana-una buro ou minaise. ");
INSERT INTO zia_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Auna ge gayao zo eyero mitiya, ‘Zo nung na tumo diyariniya auna dubora atu nao me iwaing auna ou sasa ine bao gege butunasani mitariniya.’” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Awiya emo nung tumo didinowa amimene Oweno pumarineya amaze ayero sena. Yesu mene Owenona ge awiya oura pugairo ge awiya sena. Be auna atu nung uritira waegaora oko kapetegairo witao yena, arare Oweno mene oko wosao yena. ");
INSERT INTO zia_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Emo bauno awong ge awiya nigiro eyero sewa, “Porofete diya yero nonane nung ara.” ");
INSERT INTO zia_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ayero sinewa ena mene zo eyero sewa, “Nung Kristo me.” Ayero sewa ena mene enana ge dero eyero sewa, “Kristo mene Galilaya atu nono yero kasa yariniye? Aungta nowa. ");
INSERT INTO zia_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tuwa Bayaura ge gayao zo eyero mitiya era: ‘Kristo nung Dawidira napo susuwa Betelehem atu saisibuna nuna-una towang atu kasa yaise sao.’ Ge gayao ayero mitiya.” Ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Emo awong Yesura ge ayero sinasani dubu sero gagausewa ara. ");
INSERT INTO zia_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ayero nasani ena mene Yesu bunari ge sewa, arata nung zo za oko iniwa. ");
INSERT INTO zia_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Gorobo emo awong pirisa babuzere Farisayora-una kapetegairo bamuwa awong atata yero eyero sewa, “Niye noeno nung oko puro bao yetei?” ");
INSERT INTO zia_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ayero atata yewa gorobo emo mene eyero sewa, “Nung emo ge iwawaing sinowa awiya daigairo ge iwaing-kawaing nibamu sesiya aeno nae nung oko pumao dotenane.” ");
INSERT INTO zia_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ayero sewa Farisayo emo mene abena eyero sewa, “Nung niye dema etegai gigeya me yetiya. ");
INSERT INTO zia_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Simai Farisayore nanae-una awe mene nung tumo didinoiye? ");
INSERT INTO zia_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Awiya aung ara. Arata emo bauno dubu baina nung ago neya amimene Mosera sao tauyao ge oko gao nasani nowa, arare waru nunae-una mitoiya.” ");
INSERT INTO zia_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ayero sewa otao nunae zo yazo nuna Nikodema nung gitau be zo Yesura-una baungna amimene eyero sena, ");
INSERT INTO zia_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Niye sepu. Emo zo name susuwa nuna oko gao, arita pasena nuna oko tamao nasani nung tebeba gera puganenese sao mitita? Sao tauyao naname mene ayero yanenese sinita?” ");
INSERT INTO zia_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ayero senu otao mani nuna mene abena eyero sewa, “Ning deka Galilaya emo ing? Ning sao tauyao ge naname zazagao buro yero bautu nete eyero garinesa: Galilaya tawingna atu porofete zo kasa yaise sao oko mitiya.” ");
INSERT INTO zia_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ge ayero sinete doro soma sero zanero bamuwa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu nung Oliwa diri witiro ");
INSERT INTO zia_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","atu mitinu iya gainu atu yesese yero baungno Tuwa Bayaura ibu bainana toinu emo bauno daigairo mene nuna-una buro augaiwa giro adungno ge tugata yena. ");
INSERT INTO zia_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ayero nenu sao tauyao ge gipao emo aune Farisayo awong amimene bauno zo kuma nenu tamuwa awiya puro pu towang gairo Yesu eno eyero sewa, ");
INSERT INTO zia_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Gipao emo, bauno emimene kuma ni tameya. ");
INSERT INTO zia_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mose mene sao tauyao ge naname gainasani bauno eyao ine awiya daba mene danane magayaese sena. Arata ning nitope nono yanenese kotupunesi?” ");
INSERT INTO zia_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ayero sewa, awiya noeno oko, awong nung atata yaya abena ge zo sai giro nung puro gera pugari aeno sewa. Ayero sewa Yesu nung awong eno ge abena oko sao. Nung utero tawingna atu owe nasani mitina. ");
INSERT INTO zia_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ayero yenu awong nung atata yerota yero ayewa giro zutiyero eyero sena, “Ninae-una zo pasena aung noiya amimene daba puro zayero daise aune dae.” ");
INSERT INTO zia_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ayero sero nupema utero tawingna atu owe susuuno nena. ");
INSERT INTO zia_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ayero nenu awong ge nuna nigiro bauno awiya doro babuze mene gitau yewa tiri-tara yero baungno aung yewa ara. ");
INSERT INTO zia_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ayero yewa bauno nata mitinu Yesu diti yero giro nung eno eyero sena, “Awong naiye? Zo mene ning gera pugaita?” ");
INSERT INTO zia_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ayero senu bauno mene abena eyero sena, “O Tuwa, aung ara.” Ayero senu Yesu mene eyero sena, “Na deka ayero ning gera oko pugatinena. Ning baungno nasani pasena nupema oko yase.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu mene emo bauno eno ge zo eyero sena, “Na tawing sero sero auna waegao. Arare zo nung na ago yariniya amimene mumena oko bautu nariniya. Nung naora waegao nuna-una mitai nariniya arauwa.” ");
INSERT INTO zia_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ayero senu Farisayo emo mene eyero sewa, “Ning nitope susuwa nina keregatinesa, awiya gosinenane me oko yero niya.” ");
INSERT INTO zia_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ayero sewa giro Yesu mene abena eyero sena, “Na natope susuwa nana keregatinena amimene me aung oko yero niya. Na natu bumuwing arita natu bautuneni, auna susuwa gosinasani aune ge sinona. Arata ninae mene zo na natu bumuwing arita natu bautuneni, auna susuwa kauyero nowa ara. ");
INSERT INTO zia_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Niye taung nana gege giro na zaz yero nowa. Arata nane mene zo zaz yaora buro oko yero nona. ");
INSERT INTO zia_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Arata na zaz yaora buro yatena, awiya buro me yatiya. Noeno okowata, na nata oko mitena. Nung na senu wosiwang amimene na aune dema noiya. ");
INSERT INTO zia_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Sao tauyao ge gayao ninae auna atu ge eyero mitiya, ‘Emo etobe mene nona zora susuwa sayato teng yariniya. Ayero yai me ayero sarineya.’ ");
INSERT INTO zia_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Arare na susuwa nana natope keregairo nona aune Mama na senu wosiwang amimene dema keregatinoiya.” ");
INSERT INTO zia_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ayero senu awong nung atata yero eyero sewa, “Maung nina naiye?” Ayero sewa nung abena eyero sena, “Niye na oko giro baingtao yero nowa. Arare niye Mama nana deka ayero oko giro baingtao yero nowa. Niye na giro baingtateya, awiya Mama nana dema giro baingtateya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu nung ibu bainana atu mitasani awang wau-moni pugatinauwa auna nugu dopero ge tugata nasani aune ge awiya sena. Arata magayaora be nuna oko bao, arare awong nung oko sanao yewa. ");
INSERT INTO zia_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu mene awong eno nupema eyero sena, “Na niye doro babana na kau yero pasena ninae aune dema nete magayarineya. Na baungno narinena auna niye babao ine teng oko ara.” ");
INSERT INTO zia_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ayero senu Yuda emo mene eyero wina-se yewa, “Nung eyero siniya, ‘Na baungno narinena auna niye babao ine teng oko.’ Ge ayao awiya noeno siniye? Nung nutope taung nata dero magayari sinita?” ");
INSERT INTO zia_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ge ayero sewa Yesu mene abena eyero sena, “Niye enakara. Na ikara. Niye tawingna. Na tawingna okowa. ");
INSERT INTO zia_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Aeno na niye eno ayero sesena, ‘Niye pasena ninae aune dema nete magayarineya.’ Na susuwa nana keregatinona, awiya nigaya me oko yao yariniya, awiya niye pasena ninae aune dema nete magayarineya.” ");
INSERT INTO zia_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ayero senu awong nupema atata yero eyero sewa, “Ning aweni?” Ayero sewa nung abena eyero sena, “Na sinona nigitinowa. ");
INSERT INTO zia_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Na pasena ninae daigairo keregairo niye gera pugari sero awega-ziwega yero baingtatena. Arata nung na senu wosiwang amimene ge me sinoiya. Arare nane be nuna-una atu nigiwang awiya gege tawingna etu keregatinona.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nung Maung eno ayero senu awong oko giro baingtao yewa giro ");
INSERT INTO zia_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","nung nupema eyero sena, “Niye Emora Mani awiya i pasaora ikogairo aune susuwa nana garineya. Be aune na buro yero nona awiya kotumao nana-una oko yero nona awiya garineya. Mama mene gipena awiya puro nasani sinona awiya dema garineya. ");
INSERT INTO zia_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nung na senu wosiwang amimene na aune dema noiya. Be giti awiya buro nona a giro aratapunoiya. Arare nung na oko duwao na aune dema noiya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesu ge ayero senu emo daigairo mene nung tumo diwa. ");
INSERT INTO zia_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Awong awiya Yuda emo, arare Yesu mene awong eno eyero sena, “Niye ge nana nigiro baingtiro diungno narineya, awiya niye mani dubu nana me yero narineya. ");
INSERT INTO zia_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Niye ayero nasani ge me nigiro baingtaya amimene bunao ninae besariniya. Besai bunao aung iwaing narineya.” ");
INSERT INTO zia_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ayero senu abena eyero sewa, “Nae Abrahamna saisibuna. Nae emo zora soumani oko yero nonane. Nae bunao aung narinenane, awiya sesesa auna susuwa nono yero mitiye?” ");
INSERT INTO zia_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ayero sewa Yesu mene abena eyero sena, “Na memokoba sana nigipu. Zo nung pasena yero noiya amimene pasenana soumani yero noiya. ");
INSERT INTO zia_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Soumani mene emo tuwa nuna-una ibu auna atu oko nao gege nariniya. Arata emo tuwara mani mene maungna ibu auna atu nao gege nariniya. ");
INSERT INTO zia_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Arare Mani mene niye besariniya, awiya niye pasenana bunao aung narineya. ");
INSERT INTO zia_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Niye Abrahamna saisibuna awiya na gosinena. Arata ge nana mene ninae-una mokora oko towao yero noiya, aeno niye na daya magayanese sineya. ");
INSERT INTO zia_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Na Mama nana-una atu nona gosinasani naungwa awiya niye eno tugata yero nona, arata niye mene zo maung ninae-una nigiwa awiya yero nowa.” ");
INSERT INTO zia_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ayero senu awong abena eyero sewa, “Nae mama nanae Abraham.” Ayero sewa Yesu mene eyero sena, “Niye Abrahamna saisibuna natei siya, awiya niye Abrahamna tani puro nateya. ");
INSERT INTO zia_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Tuwa Bayaura-una atu ge me susuware nigiwang awiya niye eno tugata yero nona, aune niye noeno na dari sinei? Gorobo ayero yao awiya Abraham mene oko yero nauna. ");
INSERT INTO zia_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Arata ninae zo maung ninae-una buro yero nowa.” Ayero senu awong eyero sewa, “Nae towangna mani okowa. Tuwa Bayau nung mama nanae dekaongka.” ");
INSERT INTO zia_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ayero sewa Yesu mene abena eyero sena, “Maung ninae Tuwa Bayau siya, awiya niye na ara tamateya. Noeno okowata, na Tuwa Bayaura-una atu bumuwang. Na kotumao nana-una oko wosiwang. Tuwa Bayau mene senu wosiwang. ");
INSERT INTO zia_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Niye noeno ge nana oko gao yero nowi? Niye oko gao yero nowa, noeno okowata, ge sinona awiya niye nigao teng oko. ");
INSERT INTO zia_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Niye maung ninae Sanda auna mani awiso, arare aratamao nuna ago yero buro meko awiya yari sero sinowa. Nung gitau otu emo dedunaunu mamaganauwa, deka ayero yero butunoiya arauwa. Nung ge me oko puro noiya. Noeno okowata, ge me zo nuna-una oko mitiya. Ge iwao nuna mene nuna-una mokora atu beburo mitoiyare nung ge iwaora maung yero noiya. ");
INSERT INTO zia_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Aeno ge me nana sinena, awiya nigitineya me aung ine niya. ");
INSERT INTO zia_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ninae-una zo mene na pasena emo ayero sai me yarinita? Aung ara. Na emo ayao amimene ge me susuware tugata yero nona niye noeno gosinowa me oko yao yero noiye? ");
INSERT INTO zia_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Zo nung Tuwa Bayaura mani yero noiya amimene Tuwa Bayaura ge nigitinoiya. Niye Tuwa Bayaura mani oko yero nowa, aeno ge nuna awang sinowa arauwa.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ayero senu Yuda emo mene eyero sewa, “Nae ning eno eyero sinenane: Ning Samaria emo. Iwae mene nina-una mokora mitiya. Ning eno ayero sinenane awiya ge me ara.” ");
INSERT INTO zia_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ayero sewa Yesu mene eyero sena, “Iwae nana-una mokora oko mitiya. Na mama nana bowi yero nona, arata ninae mene zo yazo nana puro wowosinowa. ");
INSERT INTO zia_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Na yazo bowire nana de ika yari oko sinona. Zo mitiya amimene yazo nana de ika gatinoiya. Nune zaz yero noiya. ");
INSERT INTO zia_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Na memokoba sana nigipu. Zo nung ge nana nigiro puro nariniya amimene oko magayariniya. Nung nao gege nasani nariniya.” ");
INSERT INTO zia_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ge ayero senu Yuda emo awong eyero sewa, “Iwae nina-una mokora mitiya awiya gosinenane me niya. Abraham magayena nupema porofete ena awong deka ayero mamagayewa. Arata ning eyero sinesa, ‘Zo nung ge nana puro nasani nariniya amimene oko magayariniya.’ ");
INSERT INTO zia_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mama naname Abraham magayena. Arata nine nung daigari sinesita? Porofete deka ayero magayewa ara. Ning noeno taung nina puro wiwitinesi?” ");
INSERT INTO zia_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ayero sewa Yesu mene awong eno eyero sena, “Na taung nana puro witana teng oko yariniya. Mama nana noiya, awiya niye Tuwa Bayau ninae asero nowa, nung amimene na bowi noiya. ");
INSERT INTO zia_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Niye nung oko giro baingtitinowa. Nane mene zo giro baingtitinona. ‘Na nung oko gao nona,’ ayero satena, awiya na ge iwao ge sao emo ine yero niye ine yatena. Na nung giro baingtiti nasani ge nuna dipunasani nona. ");
INSERT INTO zia_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Maung ninae Abraham nung kasa yaora be nana gari sero yawa yawa nasani nauna. Arare nung be nana giro yawa yawa yena.” ");
INSERT INTO zia_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ayero senu Yuda emo mene abena eyero sewa, “Ning dawang nina 50 oko yao amimene Abraham gasita?” ");
INSERT INTO zia_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ayero sewa nung eyero sena, “Na memokoba sana nigipu. Na Abraham oko kasa yaore naungwa nona era.” ");
INSERT INTO zia_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ayero senu awong daba puro nung daya magayaise sero yewa ibu mokora atu tara yero kasayena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu nung bautunete emo zo aira tiyangna atu diti guma yao kasa yero mitauna awiya tauna. ");
INSERT INTO zia_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ayero yenu buro-mani nuna mene nung atata yero eyero sewa, “Gipao emo, pasena ana mene aune emo ewiya diti guma yeni? Pasena nuna-unata aira maungna auna ing?” ");
INSERT INTO zia_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ayero sewa Yesu mene abena eyero sena, “Auna okowa. Pasena nuna-unata ai maungna auna okowata. Tuwa Bayau putoung nuna-una susuwa awiya emo euna-una atu kasa daung yai gaese ayero yena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Emo bauno warire buro yero nowa ping itinoi buro dotinowa, deka ayao ine name na senu wosiwang auna buro warire nasani nanenese sao mitiya. Be zo bumai aune buro nuna yaora be aung yariniya. ");
INSERT INTO zia_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Na tawingna etu narinena, auna teng waegao nana mene niye waegatinasani nariniya.” ");
INSERT INTO zia_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ayero sero begura ye tawingna gairo tawingne dema dawero puro emo auna ditira dupena ara. ");
INSERT INTO zia_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Dupero iyengtiti nasani eyero sena, “Ning baungno Siloam ou ubutu ouna atu benaung nina sae.” Ayero sena arauwa. (Siloam awiya ge naname-una “Iyengtao.”) Arare emo awiya baungno ou ubutu auna atu diti moko saenu diti moko pagaina. ");
INSERT INTO zia_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Diti moko pagainu yesese yenu otao manita emo bauno nung nona eno isa sero naunu gosinauwa amimene nung giro eyero sewa, “Nona eno isa sinasani mitoiya nung arita?” ");
INSERT INTO zia_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ayero sewa ena mene eyero sewa, “Nung arauwa.” Arata ena mene eyero sewa, “Nung okowata, mani zo nung ine ara.” Ayero sinewa nuka nutope eyero sena, “Zo ewe oko ara. Na era.” ");
INSERT INTO zia_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ayero senu awong nung atata yero eyero sewa, “Nono yetesa diti moko nina iwaing yetiye?” Ayero sewa nung eyero sena, ");
INSERT INTO zia_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","“Emo zo yazo nuna Yesu amimene tawing dawero diti moko nana-una dupero eyero sero iyengtiya, ‘Siloam ou ubutura baungno benaung nina sae.’ Ayero sesi baungno saetena diti moko nana pagaiya.” ");
INSERT INTO zia_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ayero senu awong atata yero sewa, “Emo awiya natu niye?” Ayero sewa nung eyero sena, “Na oko gao wa.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ayero senu awong emo gitau diti guma yao nauna awiya puro baung Farisayo dubura-una yewa. ");
INSERT INTO zia_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesu mene tawing dawero emo auna diti mokora dupenu pagaina, awiya Sabat iya aune yena. ");
INSERT INTO zia_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Arare Farisayo emo awong deka ayero atata yero eyero sewa, “Ning nono yetesa diti moko nina pagaiye?” Ayero sewa emo diti guma yao amimene eyero sena, “Nung tawing dawero diti moko nana-una dupeti na baungno oura atu saetena diti moko nana pagaiya.” ");
INSERT INTO zia_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ayero senu Farisayo ena mene eyero sewa, “Emo awiya Sabat iyara sao tauyao ge awiya deduniya, arare nung Tuwa Bayaura-una atu oko buna.” Ayero sinewa aune nunae-una ena mene eyero sewa, “Nung emo meko nao siya, awiya tani putoungne ayao ine oko yatiya.” Ayero sinasani ge wina-se yero gagausewa. ");
INSERT INTO zia_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ayero sinete emo diti guma yao awiya atata yero eyero sewa, “Diti nina sesi pagaiya aeno ning nung giro nono kotupunesi?” Ayero sewa nung eyero sena, “Nung porofete.” ");
INSERT INTO zia_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ayero senu Yuda emo mene emo diti pagaina auna ge nigiro giro, “Gitau nung diti guma yao aungta,” asero ai maungne nuna yau sewa bumuwato atata yero eyero sewa, ");
INSERT INTO zia_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“Ewiya mani ninato ing? Nung diti guma yao ka yero tiyangna atu kasa yenuta? Ora nung nono yero diti moko pagaiye?” ");
INSERT INTO zia_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ayero atata yewa abena eyero sewato, “Nung mani nanato awiya gosinenato. Nung diti guma yao tiyangna atu kasa yena, awiya gosinenato. ");
INSERT INTO zia_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Arata nono yero diti moko pagaiye auna susuwa awiya nato oko gosinenato. Nupema awe mene diti nuna sesi iwaing yetiye? awiya nato oko gosinenato. Nung bairo emo yao, arare niye nung atata yepu sai gae.” ");
INSERT INTO zia_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Maung aire nuna mene Yuda emo awang yero ge ayero sewato ara. Noeno okowata, Yuda emo awong ge yemaoko eyero sewa tauyena, “Zo nung Yesu eno ‘Nung Kristo’ asariniya, awiya nung tunero yere ibura atu awang sari nenane.” ");
INSERT INTO zia_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ayero sewa, arare ai maungne awongto awang yero eyero sewato, “Nung bairo emo yao, arare niye nung atata yepu sai gae.” ");
INSERT INTO zia_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Awong emo diti guma yao awiya nupema sewa bunu eyero sewa, “Ning Tuwa Bayaura benaungna etu ge me se. Nae emo auna susuwa gosinenane. Nung emo meko.” ");
INSERT INTO zia_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ayero sewa nung abena eyero sena, “Nung emo mekota nono yao i? awiya na oko gosinena. Arata na diti guma yao nawe dotena diti moko nana pagaiya susuwa ami zo na gosinena.” ");
INSERT INTO zia_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ayero senu awong nupema atata yero eyero sewa, “Ning eno nono yetiye, o nono yero yeti diti moko nina pagaiye?” ");
INSERT INTO zia_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ayero sewa nung ge abena eyero sena, “Na niye eno mena sesena ara. Niye nono yero oko nigao sero nei? Noeno sesena matu deka awiya nupema sana nigari sinei? Niye dema buro-mani nuna yari sineita?” ");
INSERT INTO zia_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ayero senu awong nung gona nasani eyero sewa, “Nine buro-mani nuna zo yero nesa. Nanae mene zo Mosera buro-mani ara. ");
INSERT INTO zia_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tuwa Bayau mene Mose eno ge tugata yena amaze nigitinonane. Arata emo awiya natu kasa yero buni, awiya nae oko gosinonane.” ");
INSERT INTO zia_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ayero sewa emo diti moko pagaina amimene wawong di gauno eyero sena, “Niye kasa yao nuna-una susuwa oko gosinowa arata saineba, nung yeti diti nana pagaiya ara. ");
INSERT INTO zia_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Name eyero nigitinonane: Tuwa Bayau mene emo memeko-mameko auna isa sao oko nigitinoiya. Arata zo nung Tuwa Bayau bowi nasani Tuwa Bayaura aratamao ago yariniya auna isa awiya Tuwa Bayau mene nigariniya. ");
INSERT INTO zia_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Arata emo zo diti guma yao aira tiyangna atu kasa yenu aune zo senu diti pagaina auna ungwe zo oko mitiya. Name ungwe ayao ine gitau otu oko nigao butunasani naungwane nonane. ");
INSERT INTO zia_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Arare emo awiya Tuwa Bayaura-una atu oko bao yati siya, awiya nung buro ayero yaine yao teng oko yatiya.” ");
INSERT INTO zia_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ayero senu awong eyero sewa, “Ning aira tiyangna atu kasa yero pasena mani yero nosa amimene nae tugata yari sinesita?” Ayero sero nung yere ibura atu musugairo awang sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Awang sewa Yesu mene nigiro nung taungno eyero sena, “Nine Emora Mani tumo didinesita?” Ayero senu abena eyero sena, ");
INSERT INTO zia_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","“O Tuwa, ning awe eno sinesi? Gipe giro tumo diyane.” ");
INSERT INTO zia_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ayero senu Yesu mene eyero sena, “Ning nung gigasa ara. Na ge sinena, na era.” ");
INSERT INTO zia_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ayero senu emo diti guma yao amimene eyero sena, “O Tuwa, na ning tumo didinena.” Ayero sero buro nuna-una te gitaura atu koing gaina. ");
INSERT INTO zia_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ayero yenu Yesu mene eyero sena, “Na emo susuwa ninae keregari sero tawingna wosiwang. Emo dubo ditire guma yao amimene gaese sero aeno arita emo ‘nae gao’ asinowa amimene dubo ditire guma yao mitaese sero wosiwang.” ");
INSERT INTO zia_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ayero senu Farisayo ena nung aune dema dopero mitiwa amimene nigiro eyero sewa, “Nae deka dema dubo ditire guma yao ing?” ");
INSERT INTO zia_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ayero sewa Yesu mene abena eyero sena, “Niye dubo ditire guma yao natei siya, awiya pasenana abena ninae-una oko mitatiya. Arata niye niyetope eyero sinowa, ‘Nae gao ara.’ Arare pasenana abena ninae-una mitao gege mitoiya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu mene ge eyero sena, “Na memokoba sana nigipu. Zo nung lamana goma auna towari sero goma be doro demese atu goma yauseuno baung mokora yariniya, nung awiya ugaing emo. Nung nona emo ewera pao emo. ");
INSERT INTO zia_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Zo nung goma be iwero toitinoiya, nung amimene lama diya me ara. ");
INSERT INTO zia_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nung butunoi giro goma be diya yao emo mene goma be iwinoi lama nuka nuna mene ge mapu nuna nigitinowa goma mokora atu yazo nunae yau sero yuno puro bautunoiya. ");
INSERT INTO zia_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nung lama nuna yupunoi ge mapu nuna nigitinowa nung gitau noi awong nung ago yero bautunowa. ");
INSERT INTO zia_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Arata emo zo ewe awiya awong oko ago yarineya. Awong ge mapu nuna ewe nigiro awang yero sumarineya.” ");
INSERT INTO zia_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu nung ge eniya awiya senu awong ge nuna-una susuwa oko yetine yero titiyewa. ");
INSERT INTO zia_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu mene eyero sena, “Na memokoba sana nigipu. Lama toitinowa auna goma be awiya na era. ");
INSERT INTO zia_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Na oko kasa yaore gitau kasa yewa awong awiya ugaing emo. Awong nona emo ewera pao emo. Arata lama mene ge nunae doro awang yewa. ");
INSERT INTO zia_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Goma be awiya na era. Zo nung goma mokora towari sero nana-una bariniya, awiya nung Tuwa Bayau mene sorero pariniya. Ayero yai nung buwana isona nasani nona zamena simena bainakama tamariniya. ");
INSERT INTO zia_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ugaing emo nung lama ugaing yari sero, o dari sero, o dero aung kamore yari sero butu noiya. Arata nane mene zo lama zamena simena bainakamane iwaing naese sero kasa yewang. ");
INSERT INTO zia_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Na lama diya iwaing. Diya iwaing mene lama dubu eno nao nuna duwari niya. ");
INSERT INTO zia_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Arata soumani mene zo nung diya me oko. Lama awiya nuna okowata, ewera arare eu sino kasa yai giro nung lama dubu doro awang yero babai eu sino mene gamai zanarineya. ");
INSERT INTO zia_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nung soumani gege. Nung lama dubu eno oko kotupu noiya. Arare nung doro babariniya. ");
INSERT INTO zia_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Na diya iwaing nona. Nato Mamato wina-gi nasani nonato, deka ayao ine na aune lama dubu nana nae wina-gi nasani nonane. Arare na lama dubu eno nao nana dotinena. ");
INSERT INTO zia_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Lama dubu nana zo neya, awiya awong goma euna oko. Arare na baungno yuno puro bana ge nana nigarineya. Ayero yana lama dubu dekaongka yero diya dekaongna ge nigiti nasani narineya. ");
INSERT INTO zia_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Na nao nana doro nupema pumarinena, arare Mama nana mene na aratapunoiya. ");
INSERT INTO zia_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nao nana awiya emo zo mene oko sorero pariniya. Awiya kotumao nana-una duwarinena. Na nao nana doro nupema parinena auna putoung na teng mitiya. Mama nana mene ayero yanese sena ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yuda emo awong ge awiya nigiro gausero dubu etobe yewa. ");
INSERT INTO zia_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Dubu baina mene eyero sewa, “Iwae mene mokora toi dau niya. Noeno ge nuna nigitinei?” ");
INSERT INTO zia_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Asewa ena mene eyero sewa, “Iwaere mene ge ayao oko sariniya. Iwae mene emo diti guma yetugao awiya sai diti pagari neita? Aung ara.” Ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yuda emora iya be zo yazo nuna Ibu Baina Korayewa auna be bunu giro awong Yerusalem atu augaiwa. Be awiya yayaungna be. ");
INSERT INTO zia_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Arare Yesu mene ibu bainana agewa zo yazo nuna Solomonna waranda auna atu puma-sauma nasani nenu ");
INSERT INTO zia_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yuda emo awong nung ziuno atata yero eyero sewa, “Ning noeno susuwa nina puingtinosa nae titiye zaruwe yero nonine? Ning Sorao Emo nanae Kristo me nasani giro keregairo se ganene.” ");
INSERT INTO zia_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ayero sewa Yesu mene awong eno eyero sena, “Na sewang nigiwa, arata nigitineya me aung ine yero niya. Buro ena na Mama nana-una bera yero nona amimene susuwa nana keregati noiya. ");
INSERT INTO zia_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Niye lama dubu nana oko, arare ge nana nigitineya me aung ine yero niya. ");
INSERT INTO zia_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Lama dubu nana yero nowa awong awiya ge nana nigitinowa. Arare nane awong gosinona na ago yero nowa. ");
INSERT INTO zia_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ayero yero nowa na nao me iwaing awong eno pugatinona oko magayao nao gege nowa. Awong wawong nana-una atu zo mene sorero paine yao oko mitiya. ");
INSERT INTO zia_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mama nana mene awong na eno pugaina ara. Mama nana mene emo apakana aune nona apakana awiya daigatinoiya. Arare zo mene awong Mama nana-una waweng atu sorero paine yao teng oko. ");
INSERT INTO zia_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Na aune Mama aune nato dekaongka.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ayero senu Yuda emo awong daba mene Yesu nupema dari yewa. ");
INSERT INTO zia_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Dari yewa nung eyero sena, “Buro iwaing daigairo Mamana soremaora yetena gigeya, arare niye tani nomaze yetena aeno na daba mene dari sero nei?” ");
INSERT INTO zia_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ayero senu awong be nuna-una puro eyero sewa, “Buro iwaing yero nosa auna okowata, ning deka tawing emo amimene Tuwa Bayau daigati nasani ning nitope Tuwa Bayau asinosa, aeno nae ning daba mene dari sero nenane.” ");
INSERT INTO zia_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ayero sewa nung abena eyero sena, “Sao tauyao ge ninae eyero gayao mitiya: ‘Tuwa Bayau mene eyero sena: Niye tuwa.’ ");
INSERT INTO zia_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ge gayao mitiya awiya doro zo sao ine oko mitiya. Arare Tuwa Bayaura ge awiya ewowo naname auna-una kasa yenu giro nung awong eno ‘Tuwa’ asena, ");
INSERT INTO zia_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","nupema Mama mene na wosi tawingna yanese giginu mitauna auna teng na senu wosiwang. Arare na natope na Tuwa Bayaura Mani asero nona niye noeno na Tuwa Bayau daigari nena asero nowi? ");
INSERT INTO zia_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Buro yero nona awiya gaya Mama nana-una ine oko yao yariniya, awiya ge nana duwaya teng yari niya. ");
INSERT INTO zia_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Arata gaya Mama nana-una ine yariniya, awiya ge nana-una okowata buro yao nana-una na gaya me yaise. Ayero nasani Mama mene na aune dema noiya, deka ayero na Mama aune dema nona, auna susuwa giro baingtarineya.” ");
INSERT INTO zia_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ayero senu giro awong nung bunari sero yewa nung awena mokora atu kasayero doro baungna arauwa. ");
INSERT INTO zia_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu kasayero doro baungno ou Yodan enabara Yohane mene gitau emo bauno ge ou susunasani nauna atu baungno nasani nauna. ");
INSERT INTO zia_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ayero naunu emo bauno daigairo mene nuna-una baungno eyero sewa, “Yohane nung tani putoungne zo oko yao. Arata ge Yohane mene emo eeno sena awiya me niya.” ");
INSERT INTO zia_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Arare emo bauno daigairo mene soma auna atu Yesu tumo diwa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betani napora emo zo nauna yazo nuna Lasaro. Nung amimene yaya puro mitina. Mariato Mata, awongto awiya yaore yaore, awongto napo dekaongka auna. ");
INSERT INTO zia_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Maria nung ou sereyao mene Tuwara te saero giti ai nuna mene Tuwara te dupena auna nu-emodi Lasaro amimene yaya puro mitina.) ");
INSERT INTO zia_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Arare awongto yaore mene Yesu eno ge eyero pugaiwato baungna. “O Tuwa, ning nigi. Otao nina yaya puro mitiya.” ");
INSERT INTO zia_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ge ayero pugaiwato baungnu Yesu mene nigiro giro eyero sena, “Yaya auna me awiya magayao mene kasa yaise auna okowata, emo bauno mene Tuwa Bayau bowi yaese sao ara. Emo bauno mene Tuwa Bayaura Mani bowi yaese sero yaya awiya kasa yetiya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesura aratamao awiya Mata yaore aune Lasaro awong auna-una mitauna. ");
INSERT INTO zia_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Arare nung yaya auna bowi ge nigina arata wari be etobe katu mitina. ");
INSERT INTO zia_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Atu mitete nunae-una babari sero buro-mani nuna eno eyero sena, “Bungpu! Yudaya tawingna yesese yero babanene.” ");
INSERT INTO zia_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ayero senu buro-mani mene eyero sewa, “Gipao emo, be imoko oko Yuda emo atu daba mene ning dari yeteya, arare ning noeno nupema nunae-una yesese yanenese sinesi?” ");
INSERT INTO zia_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ayero sewa Yesu mene buro yaora be nuna oko aung yao kara mitina awiya gaese sero ge pungyao zo eyero sena, “Buro yaora be 12 aua mitiya. Zo nung warire nagibe atu bautu nasani te oko gayariniya. Noeno okowata, nung tawingna waegao gosinoiya. ");
INSERT INTO zia_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Zo nung pingne nagibe atu waegao aung bautunete te gaero zuwariniya.” ");
INSERT INTO zia_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ayero sero ge zo eyero sena, “Otao naname Lasaro auriti awiniya, arata name baungno na Lasaro uwari nena.” ");
INSERT INTO zia_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ayero senu buro-mani nuna mene eyero sewa, “O Tuwa, nung awinete iropariniya.” ");
INSERT INTO zia_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu mene magayaora ge awiya auriti awaora pugairo senu buro-mani nuna mene auriti maze sinita asero ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Arare Yesu mene keregairo eyero sena, “Lasaro magatiya. ");
INSERT INTO zia_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Na atu oko baungno nao etu nena magayetiya, arare na niye eno dubo nana iwaing niya. Niye tumo diyao mere naese nona awiya kasa yetiya. Arare nuna-una babanene.” ");
INSERT INTO zia_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ayero senu Tomas yazo nuna zo Didimo nung amimene otao mani eno eyero sena, “Name baungno nung aune dema magayanene.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lasaro biritira mitinu be siwongpatige aung yenu aune Yesu baungno kasa yena. ");
INSERT INTO zia_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani napo awiya Yerusalem nugu ina atu mitauna. Nagibo towang atu ang yero babao awiya 4 kilomita gege. ");
INSERT INTO zia_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Arare Yuda emo daigairo mene Matato Mariara nu-emodi magayena awiya gari bumuwa ara. ");
INSERT INTO zia_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Arare Mata nung “Yesu butuniya,” ayero sewa giro Maria gare atu mitina awiya doro baungno Yesu nagibe atu tauna. ");
INSERT INTO zia_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Taungno nung eno eyero sena, “O Tuwa, ning etu natesa, awiya nu-emodi nana oko magayatiya. ");
INSERT INTO zia_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Na susuwa nina gosinena. Ning yeme nona zo eno Tuwa Bayau isa sasa nigariniya.” ");
INSERT INTO zia_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ayero senu Yesu mene abena eyero sena, “Nu-emodi nina seka yero iropariniya.” ");
INSERT INTO zia_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ayero senu Mata mene abena eyero sena, “Ago be bainana atu seka yero iropariniya awiya gosinena.” ");
INSERT INTO zia_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ayero senu Yesu mene eyero sena, “Seka yero iropao o naora maung na era. Arare zo nung na tumo diyariniya amimene magayero nupema iropariniya. ");
INSERT INTO zia_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Arata zo nung seka nasani na tumo diro nariniya amimene oko magayao seka nao gege nariniya. Ning ge awiya nigesa me nita?” ");
INSERT INTO zia_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ayero senu Mata mene eyero sena, “Ning Kristo, Tuwa Bayaura Mani me. Ning tawingna wosasese sao, awiya nigena me yetiya.” ");
INSERT INTO zia_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ayero sero baungno yao nuna Maria yau senu bunu opene eyero sena, “Gipao emo buro ning yau siniya.” ");
INSERT INTO zia_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ayero senu Maria mene nigiro mena iropuro Yesura-una baungna. ");
INSERT INTO zia_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu nung napo bautara atu Mata eno ge sena masi deka auna atu dopero mitina. ");
INSERT INTO zia_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mitinu Maria iropuro baungnu Yuda emo magayaora buro mitiwa amimene “Maria biritira atu zi sari bautuniya,” asero ago yero bamuwa. ");
INSERT INTO zia_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Arare Maria nung wosi napo bautara yero Yesu taungno nuna-una koing gairo eyero sena, “O Tuwa, ning etu natesa, awiya nu-emodi nana oko magayatiya.” ");
INSERT INTO zia_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ayero sero zi senu Yuda emo Maria ago yewa amimene Maria giro deka ayero zi dema sewa. Zi sewa Yesu mene giginu mou yenu koing gaina ara. ");
INSERT INTO zia_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yesu mene atata yero eyero sena, “Natu mutetei?” Ayero atata yenu eyero sewa, “Tuwa, bung gase.” ");
INSERT INTO zia_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ayero sewa Yesu zi senu ziziung buna. ");
INSERT INTO zia_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ayero yenu Yuda emo awong nung giro eyero sewa, “Gipu. Dubo nuna bainakama Lasarora-una mitiya.” ");
INSERT INTO zia_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ayero sewa ena mene eyero sewa, “Diti guma yao zo senu diti pagaina deka ayero emo ewiya magayoiye sero nung kora yai iwaing yao teng oko yao yetita?” ");
INSERT INTO zia_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ayero sinewa Yesu ge awiya nigiro moko nuna mene yaya bainakama taungno baung biritira yena. Magayaora masi awiya daba bainakama mene dereme yewa baungno be gazena. ");
INSERT INTO zia_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Arare Yesu mene eyero sena, “Daba be gazao awiya dereme yepu babae.” Ayero senu Mata emo magayena auna nu-bauno amimene eyero sena, “Tuwa, nung wari siwongpatige kotera awiya, arare kaungwa niya.” ");
INSERT INTO zia_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ayero senu Yesu mene abena eyero sena, “Na eyero sesena, ‘Ning na tumo diyarinesa, awiya ning Tuwa Bayaura putoung garinesa.’ Ge awiya sesena nigesita?” ");
INSERT INTO zia_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ayero senu daba dereme yewa baungnu Yesu mene diti ye ika gairo eyero sena, “Mama, ning isa nana nigesa, arare na ning eno dange sinena. ");
INSERT INTO zia_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ning isa nana be giti nigitinosa awiya gosinona. Arata emo dubu emimene nine sasa wosiwang awiya gaya me yaise sero ge ayero sinena ara.” ");
INSERT INTO zia_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ayero sero yausero eyero sena, “Lasaro, ning iropuro bung.” ");
INSERT INTO zia_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Yausenu magayao mene iropuro buna ara. Te wawong nuna mo mene dowao, aune benaung nuna mo mene worao, ayenu Yesu mene eyero sena, “Mo besepu babae.” Ayero senu mo besewa baungna arauwa. ");
INSERT INTO zia_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yuda emo Mariara-una buro mitiwa auna awong daigairo mene tani putoungne awiya giro Yesu tumo diwa. ");
INSERT INTO zia_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Anewa ena mene zo Farisayo emora-una baungno Yesu mene tani yena auna ge ungwe yewa. ");
INSERT INTO zia_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ayewa pirisa babuzere Farisayo emo awong ge awiya nigiro gitau yao dubu yausero sewa bumuwa augairo eyero sewa, “Emo amimene tani putoungne daigairo noiya, arare nung nono yari nenine? ");
INSERT INTO zia_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Name nung duwanane tani ayao nai emo apakana nung tumo diyaya Roma emora gorobo emo mene name iwo yero buro ibu baina naname aune dubu naname aune awiya gera yarineya.” ");
INSERT INTO zia_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ayero sewa otao nunae zo yazo Kayafa nung dawang aune pirisa baina yero nasani nauna amimene eyero sena, “Niye kotumao aung nowa. ");
INSERT INTO zia_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Niye eyero gipu. Nagibo iwaing eyero mitiya era. Emo dubu name meko yonine sero emo dekaongka omimene name eno abena magayaise.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ge awiya kotumao nuna-una oko sena. Nung dawang be aune pirisa baina yero nasani nauna, arare nung porofete mene saine yero Yesu mene Yuda emo bauno dubu eno abena magayari nena auna ge sena. ");
INSERT INTO zia_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yesu magayari nena, awiya Yuda emo bauno eno gege okowata, Tuwa Bayaura mani awiso tawing sero sero nowa awong apakana pu dekaongna gai dubu dekaongka yero naese magayari nena. ");
INSERT INTO zia_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Auna gitau yao dubu wari be aune Yesu daora ge buro zayewa. ");
INSERT INTO zia_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Arare Yesu nung Yuda emora-una nupema oko kasa yero nao. Nung buro-mani nuna puro baungno napo zo yazo Efraim eu yanawira ina mitina auna atu nasani nauwa ara. ");
INSERT INTO zia_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yuda emora iya be dang yazo nuna Magayao mene awong Daigaina auna be nugu yenu giro napo mamanina emo daigairo mene pasena disaora burora gitau witiro baung Yerusalem yewa. ");
INSERT INTO zia_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Anasani awong Yesu kau nasani ibu bainana atu augairo wina-se nasani eyero sewa, “Niye nono kotupunei? Nung iya dang eune barinita, aung ing?” ");
INSERT INTO zia_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pirisa babuzere Farisayo emo aune awong sao tauyao ge eyero sewa, “Emo zo mene nung taungno giro saise nung puro bunae.” Ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Magayao mene awong Daigaina auna iya be dang nunae wari be 6 ayao mitinu aune Yesu nupema kapete gairo buro Betani nape atu kasa yena. Nung gitau napo auna atu Lasaro magayaora atu uwenu seka yero iropuna ara. ");
INSERT INTO zia_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yesu eno nona saiwa Mata mene dunu Lasaro dema adungno nona miniwa ara. ");
INSERT INTO zia_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nona mininasani mitiwa Maria mene garewa maingkoka zo ou sereyao iwaing yazo nuna nad zuma bainakama, awiya puro Yesura te suwero giti ai nuna mene te nuna dupena ara. Ayero yenu garo mitiwa awiya sere sere yena ara. ");
INSERT INTO zia_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ayero yenu Yudas Iskeriot, nung Yesu keregari nena, amimene eyero sena, ");
INSERT INTO zia_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Name nono yero ou sereyao awiya puganane 300 kina mene zuma gaero pumaya moni awiya puro bogamasa eno oko pugatenine?” ");
INSERT INTO zia_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nung emo bogamasa eno kotungno oko sena. Yesu buro-maine nauwa auna moni awiya kope zora pugati nauwa Yudas mene diya nasani moni ena ugaing pupunasani nauna. Aeno ge awiya sena ara. ");
INSERT INTO zia_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ayero senu Yesu mene eyero sena, “Niye bauno eno ge oko sepu. Nung ou sereyao ewiya puro nai na magayana aune taung nana-una suwai aune mutaese kotupu noiya auna teng niya. ");
INSERT INTO zia_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Emo bogamasa awong be giti niye aune dema nowa narineya. Arata nane mene zo niye aune dema oko nao gege narinena.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yesu napo auna atu nena auna bowi Yuda emo daigairo mene nigiro bumuwa. Arata awong Yesu gege gari okowata, Lasaro magayaora atu uwenu seka yero iropuna awiya dema gari bumuwa. ");
INSERT INTO zia_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Arare pirisa babuze mene awong Lasaro dema dari ge buro yewa ara. ");
INSERT INTO zia_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Noeno okowata, Yuda emo daigairo mene Lasaro uwenu seka yero iropuna awiya giro pirisa babuze doro Yesu tumo diwa, aeno awong Lasaro dema dari sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Iya gainu emo bauno dubu bainakama mene iya be dang nunae eno Yerusalem augaiwa amimene ge bowi eyero nigiwa, “Yesu butuniya.” ");
INSERT INTO zia_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ge awiya nigiro giro i gomi zozoro gairo waweng initi gairo nagibe atu tamari bamuwa ara. Taungno yawa yawa nasani eyero sewa, “Tuwara bera naname-una butuniya, nung awiya bowi yanene. Nung Tuwa naname Isreli emora.” ");
INSERT INTO zia_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu nung wo dongki mani zo taungno auna tame witiro adungno baungna. Awiya ge gayao eyero mitauna auna teng yena: ");
INSERT INTO zia_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Zaiyon napora emo bauno, niye awang oko yae. Gipu. Emo Tuwa ninae butuniya. Nung wo dongki maingna tame atu butuniya. ");
INSERT INTO zia_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ge awiya gitau buro-mani nuna mene oko giro baingtao yero nauwa. Nawe Yesu nung witi uritira waegao nuna-una yenu aune ge awiya kotungno susuwa gigiwa ara. Ge awiya nung eno sero gayao, arare auna teng yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Emo bauno Yesu Lasaro yausenu biritira atu kasa yenu gigiwa awong amimene ge ungwe yewa dubu baina mene nigiwa. ");
INSERT INTO zia_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tani auna bowi nigiwa, arare emo bauno daigairo mene baungno nung nagibe atu tamuwa. ");
INSERT INTO zia_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ayero yewa Farisayo awong nuka nuyetope eyero sinasani sewa, “Gosineya. Niye ge buro gege kaputinowa. Emo bauno apakana nuna-una gege bautuneya.” Ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Yuda emo iya be dang nunae eno Yerusalem augatinewa Grik emo ena mene awong aune dema augao auna newa ara. ");
INSERT INTO zia_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Anewa Grik emo mene Filip, nung Besaida napo Galilaya tawing auna emo, auna-una baungno eyero sewa, “Otao, nae Yesu gari sinenane.” ");
INSERT INTO zia_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ayero sewa Filip mene baungno Anderea sero dema Yesura-una baungno sewato ara. ");
INSERT INTO zia_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Sewato Yesu mene abena eyero sena, “Emora Mani mene simao waegaore pumarinena, auna be nugu niya. ");
INSERT INTO zia_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Na ge memokoba sana nigipu. Tabara me zo tawingna wosiro oko kosoyao yariniya, awiya nung nata tebeba mitariniya. Arata nung tawingna wosiro kosoyero iropariniya, awiya nung me witao iyariniya. ");
INSERT INTO zia_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Deka ayero zo nung nao nuna ara tapunoiya auna teng nao nuna aung yariniya. Arata zo nung tawingna etu nasani nao nuna iwo yero noiya amimene nao nuna initi nasani nao me iwaing tamariniya. ");
INSERT INTO zia_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Zo nung soumani nana yero nari yero giro na ago yaise. Ayero yero na narinena auna soumani nana nariniya. Zo nung na sou yariniya nung awiya Mama nana mene simariniya. ");
INSERT INTO zia_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yeme moko nana mene yangka sero ipiniya. Arare nono sarineni? Mama, ning yaya ewiya musugai. Ayero sarinenita? Aung ara. Na ge ayero oko sane. Noeno okowata, na yaya ewiya puro magayari sero wosiwang. ");
INSERT INTO zia_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mama, ning yazo nina de ika ye.” Yesu mene ayero senu uritira atu ge eyero wosina, “Na yazo nana de ika yetena, nupema de ika yarinena.” ");
INSERT INTO zia_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ayero senu emo dubu dopero mitiwa amimene nigiro eyero sewa, “Bibiya bezetiya.” Arata ena mene eyero sewa. “Angelo zo mene ge nung eno sesita nowa.” ");
INSERT INTO zia_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ayero sewa Yesu mene nunae-una bera puro eyero sena, “Ge awiya na eno okowata, niye eno kasa yetiya. ");
INSERT INTO zia_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yeme Tuwa Bayau mene tawingna emo bauno awega-ziwega yariniya. Yeme na tawing euna tuwa teugairo masi nuna pumarinena. ");
INSERT INTO zia_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Awong na tawingna atu puro witi ika yaya tawing sero sero emo bauno yumana nana-una barineya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Awiya magayao nono yero magayariniye auna ge awiya sena. ");
INSERT INTO zia_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ayero senu emo mitiwa amimene eyero sewa, “Nae ge gayao mitiya auna eyero gosinonane: Sorao Emo naname Kristo nung oko magayao nao gege nariniya. Arata nine mene zo eyero sinesa, ‘Emora Mani puro witiro ira iko garineya.’ Noeno ayero sinesi? Emora Mani aweni?” ");
INSERT INTO zia_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ayero sewa Yesu mene ge abena eyero sena, “Waegao mene ninae-una atu be apungkaka gege waegariniya. Arare mume mene niye dowoiye sero waegao mitai waegaore neupu. Zo nung mumena bautu nasani nagibo oko gosinoiya. ");
INSERT INTO zia_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Arare waegao ninae-ina mitai niye nung dubo mene tumo didinasani dubu nuna yero neupu.” Yesu mene ge ayero sero aune awong doro baungno pungyero nasani nauna arauwa. ");
INSERT INTO zia_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu nung tani putoungne daigairo nunae-una ditira atu yero bunu gosinasani nung tumo oko diyao yewa. ");
INSERT INTO zia_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Awiya porofete Yesayara ge me yaise ayero yewa. Nung ge eyero gaena, Tuwa, bowi nina sero nonane awe mene gosinoi me noiye? Tuwa mene putoung nuna awe eno keregaine? ");
INSERT INTO zia_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Arare awong Yesura ge nigiro nung tumo diyao ine teng oko yewa. Noeno okowata, Yesayara ge gayao zo mitiya. Ge awiya eyero mitiya, ");
INSERT INTO zia_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Tuwa Bayau mene eyero sena, “Awong diti moko mene nona gowi sero, o dubo mene nona kotungno gowi sero, o dubo nunae kapetegaya na awong kora yoni sero.” Tuwa Bayau mene ayero sero senu diti moko nunae guma yenu dubora diti nunae gazenu daba ine yena. ");
INSERT INTO zia_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesaya mene ge awiya gaena, noeno okowata, nung Yesura waegao giro ge awiya Yesu eno sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Yuda emora gitau yao emo daigairo mene Yesu tumo diwa. Arata awong tumo diyao nunae keregaya Farisayo mene awong yere ibura atu awang sowi sero, tumo diyao nunae pungyero puro nauwa ara. ");
INSERT INTO zia_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ayero nauwa, noeno okowata, Tuwa Bayau mene awong bowi yaise sero yawa yawa maingkoka gege yero nauwa. Arata emo mene awong bowi yaese sero yawa yawa bainakama yero nasani nauwa. ");
INSERT INTO zia_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu nung wawa sero ge eyero sena, “Zo nung na tumo diyariniya amimene na gege okowata, na senu wosiwang awiya dema tumo diyariniya. ");
INSERT INTO zia_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Zo nung na gariniya amimene na senu wosiwang awiya dema gariniya. ");
INSERT INTO zia_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Zo nung na tumo diyariniya nung awiya mumena atu mitoiye sero na waegao ine yero wosi tawingna yewang amimene nung waegati narinena. ");
INSERT INTO zia_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Zo nung ge nana nigiro oko dimao duwariniya nung awiya nane oko gera pugarinena. Na emo bauno gera pugari okowata, kora yari wosiwang. ");
INSERT INTO zia_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Zo nung ge nana nigiro doro na awang sariniya auna zaz mitiya. Ge sinona amimene ago be bainana atu zaz nuna yariniya. ");
INSERT INTO zia_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Noeno okowata, na ge sinona, awiya dubo nana-una oko sinona. Mama nana na senu wosiwang amimene ge sanese sero na tugata-magata yena. ");
INSERT INTO zia_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na eyero gosinena: Mamana ge mene nao me iwaing tapunoiya. Arare ge sinona awiya Mama mene sero gipena auna teng sinona ara.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Magayao mene awong Daigaina auna oregao be nugu nenu Yesu nung nutope eyero gigina, “Na tawing doro kapetegairo Maungna-una witari nena auna be nugu niya.” Ayero gosinasani giro buro-mani nuna tawingna atu narineya aeno dubora mono puna. Mono pumao nuna awiya oko aung yao mitao gege mitauna. ");
INSERT INTO zia_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pingne awong nona minari augairo mitiwa aune tani eyero kasa yena. Simonna mani Yuda Iskeriot, nung Yesu keregaise Sanda mene kotumao awiya mena dubo nuna-una atu pugainu mitauna. ");
INSERT INTO zia_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Arare Yesu mene eyero gigina: “Mama nung nona apakana wawong nana-una pugainu mitoiya. Na Tuwa Bayaura-una atu wosiwang, nupema Tuwa Bayaura-una kapete gairo witarinena.” ");
INSERT INTO zia_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kotumao ayero gosinasani nona mininena awiya doro iropuro taung wori nuna tame awiya dutugairo pugairo taulu zo puro ipura awiro ");
INSERT INTO zia_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ou taora yasa gairo buro-mani nuna-una te saena. Saero taulu ipura mitina amimene te nunae dupena. ");
INSERT INTO zia_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ayero nasani mani enana te saero aune Simon Petorora te sayari yenu nung eyero sena, “Ning Tuwa mene te nana sayari sinesa?” ");
INSERT INTO zia_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ayero senu Yesu mene eyero sena, “Tani nena euna susuwa oko gosinesa. Nete ago garinesa.” ");
INSERT INTO zia_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ayero senu Petoro mene eyero sena, “Aung arauwa. Ning te nana oko sayarinesa.” Ayero senu Yesu mene ge abena eyero sena, “Na te nina oko sayao yana ning na aune dema oko dubo dekaongka yero narinesa.” ");
INSERT INTO zia_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ayero senu Simon Petoro mene abena eyero sena, “Tuwa, ayero sero giro te nana gege okowata, wawong gitire dema sae.” ");
INSERT INTO zia_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ayero senu Yesu mene eyero sena, “Zo nung ou suwero nete te nuna gege sayai taung iwaing yariniya. Niye iwaing. Arata ninae-una zo mene iwaing oko noiya.” ");
INSERT INTO zia_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Nung keregao emo awiya gosinasani aune eyero sena, “Ninae-una zo mene iwaing oko noiya.” ");
INSERT INTO zia_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu mene te nunae saero besugairo aune taung wori nuna imoko nupema wosogairo adungno mitasani eyero sena, “Na nona niye eno yetena auna susuwa gosineita? ");
INSERT INTO zia_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Niye na eno Gipao Emo asinasani, o Tuwa asinasani yero nowa. Na ayero nona, arare me sinowa. ");
INSERT INTO zia_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Arare na Tuwa ninae o Gipao Emo ninae mene naka natope puro wowosi nasani te ninae saetena, deka ayero niye nika niyetope puro wowosi nasani te wina-sae nasani naya teng yariniya. ");
INSERT INTO zia_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Na tani niye eno gipetena awiya puro nasani na yetena deka ayero yero nasani neupu. ");
INSERT INTO zia_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Na memokoba sana nigipu. Soumani mene emo tuwa nuna daigairo nao ine oko mitiya. Nupema burora senu baungna amimene buro maung daigao ine oko mitiya. ");
INSERT INTO zia_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Arare niye ge awiya nigiro baingtiro auna teng narineya, awiya niye yawa yawa yarineya. ");
INSERT INTO zia_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Na ge sesena amimene niye apakana oko gapuniya. Dubu yangtagairo pumuwang awiya gosinona. Arata ge gayao zo eyero mitiya awiya me yaise sao mitiya, ‘Ma eero pugatinona mininoiya nung amimene na dari siniya.’ ");
INSERT INTO zia_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Tani awiya oko kasa yaore na niye bere-bere tugata nena. Arare ago tani awiya kasa yai aune niye na eno eyero sepu, ‘Nung meba Sorao emo nanae Kristo.’ ");
INSERT INTO zia_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Na memokoba sana nigipu. Zo nung na niye burora pugaingwa aeno masi zuwariniya amimene burora maung na eno masi zuetiya ayero yariniya. Zo nung na eno masi zuwariniya amimene na senu wosiwang nung aeno dema masi zuetiya ayero yariniya.” ");
INSERT INTO zia_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu mene ge ayero sero moko nuna meko yenu giro keregairo eyero sena, “Na memoko niye eno sana nigipu. Ninae-una zo mene na keregairo iwora waweng pugariniya.” ");
INSERT INTO zia_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ayero senu buro-mani nuna awong wina-gi yero awe eno siniye asero kau yewa ");
INSERT INTO zia_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","be aune mani zo Yesu mene aratapu nasani nauna amimene nuna-una nugu atu mitina. ");
INSERT INTO zia_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Arare Simon Petoro mene ziyo mene etotoma yero eyero sena, “Atata ye sai gase. Awe eno siniye?” ");
INSERT INTO zia_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ayero senu mani amimene Yesura-una nugu baungno be puro daweng gairo eyero sena, “Tuwa, ning awe eno sinesi?” ");
INSERT INTO zia_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ayero senu Yesu mene abena eyero sena, “Ma sura dusero pugana minariniya nung ara.” Ayero sero ma sura dusero Simonna mani Yudas Iskeriot nung aeno pugainu minina ara. ");
INSERT INTO zia_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Mininu Sanda mene moko nuna-una toina ara. Ayero yenu Yesu mene eyero sena, “Tani yari sinesa awiya mena ye.” ");
INSERT INTO zia_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ge ayero Yudas eno senu awong ena dema mitiwa amimene ge auna susuwa oko gosi nasani ");
INSERT INTO zia_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ena mene eyero sewa, “Yudas nung moni naname diya noiya, arare nung iya be dang euna nona zo paise sesi bautunita? O emo bogamasa eno moni bono yaise sini bautuniye?” Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudas nung ma awiya miniro mena iropuro ping mumene baungna arauwa. ");
INSERT INTO zia_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudas baungnu aune Yesu mene buro-mani ena eno eyero sena, “Emora Mani auna yazo de ika yaora be yeme nugu yetiya. Tani nana-una kasa yariniya amimene Tuwa Bayaura yazo de ika yariniya. ");
INSERT INTO zia_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Arare na Emora Mani mene Tuwa Bayaura yazo de ika yana nung abena yazo nana de ika yariniya. Ayero be imokore oko, mena de ika yariniya. ");
INSERT INTO zia_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","O mani awiso nana, na be apungkaka niye aune dema narinena. Ago niye na kau yarineya. Arare na Yuda emo ena eno sewang deka ayero niye eno sinena. Na babarinena auna atu niye babao ine oko mitiya. ");
INSERT INTO zia_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Aeno na sao tauyao ge seka zo niye eno pugatinena. Dubora mono wina-pung yepu. Na niye eno dubora mono pupunona nowa deka ayero nika niyetope dubora mono wina-pung nasani neupu. ");
INSERT INTO zia_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Niye dubora mono wina-pung nasani naya emo niye giro Yesura buro-mani yero neya asarineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ge ayero senu Simon Petoro mene atata yero eyero sena, “Tuwa, ning natu babarinesi?” Ayero atata yenu Yesu mene abena eyero sena, “Na babarinena auna ning yeme eune babao ine oko mitiya. Nete ago babarinesa.” ");
INSERT INTO zia_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ayero senu Petoro mene eyero sena, “Tuwa, ning noeno na yeme ning aune dema babao ine oko mitiya asinesi? Na ning eno nasani nao nana gera yaina awiya teng yariniya.” ");
INSERT INTO zia_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ayero senu Yesu mene eyero sena, “Ning na eno nao nina gera yari sinesa? Na memokoba sana nigi. Kokora ge oko saore nine na bewae yasa be etama yariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu mene buro-mani nuna eno eyero sena “Niye dubo ninae oko sisigae. Niye Tuwa Bayau tumo didinasani na dema tumo dipu. ");
INSERT INTO zia_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mama nana-una napo auna ibu-niya koma daigairo miteya. Ayero oko mitao yati siya, awiya na mitao masi ninae kora yari babari nena ayero oko satena. ");
INSERT INTO zia_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Arare na baungno mitao masi ninae kora yero nupema kapetegairo buro niye puro babana na narinena masi deka auna atu nasani narineya. ");
INSERT INTO zia_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Babarinena auna nagibo awiya niye gosineya.” ");
INSERT INTO zia_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ayero senu Tomas mene abena eyero sena, “Tuwa, ning natu babarinesi, awiya nae oko gosinenane. Arare nono yero nagibo awiya garinenine?” ");
INSERT INTO zia_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ayero senu Yesu mene abena eyero sena, “Nagibo Mamana-una babao awiya na era. Ge me susuware keregao awiya na era. Nao seka pugao awiya na era. Na daigairo Mamana-una kasa yao ine oko mitiya. ");
INSERT INTO zia_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Niye susuwa nana gatei siya, awiya niye Mama nana-una susuwa deka ayero gateya. Yeme niye Mama nana-una susuwa gigeya kasa niya.” ");
INSERT INTO zia_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ayero senu Filip mene eyero sena, “Ning Maung gipasa nae giro aune kara teng niya asarinenane.” ");
INSERT INTO zia_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ayero senu Yesu mene eyero sena, “Filip, na be imoko kaung-kaung niye aune dema nona ning na oko giro baingtao yero nosa? Zo nung na gosinoiya amimene Mama gosinoiya. Arare ning noeno Mama gipe ganene ayero sinesi? ");
INSERT INTO zia_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Mama mene nana-una mitoiya, deka ayero na Mamana-una mitona, awiya gigesa me oko yao nita? Ge niye eno tugata yero nona awiya kotumao nana-una oko tugata yero nona. Mama mene dubo nana-una atu mitasani buro nuna yero niya. ");
INSERT INTO zia_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mama mene na aune mitoiya, o na deka ayero Mama aune mitona ge awiya nigipu me yae. Arata ge awiya gaya me oko yao yai giro buro ena yero nona awiya kotungno aune ge awiya gipu me yae. ");
INSERT INTO zia_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Na memokoba sana nigipu. Zo nung na tumo diyariniya amimene buro yero nona deka awiya teng yariniya. Na Mamana-una witarinena, arare nung buro awiya gege okowata, yai nana awiya daigairo baina yariniya. ");
INSERT INTO zia_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Niye yazo nana puro nasani isa saya giro na nigiti nasani teng soremarinena. Awiya Mamana bowi kasa yaise sero na Mani mene ayero yarinena. ");
INSERT INTO zia_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Niye yazo nana puro nasani nona zo eno na isa saya nigiti nasani ayero teng soremarinena. ");
INSERT INTO zia_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Aratamao ninae nana-una mitariniya, awiya niye ge nana dimarineya. ");
INSERT INTO zia_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nane Mama isa sana nung soremao ninae zo pugai wosiro niye aune dema nao gege nariniya. ");
INSERT INTO zia_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nung awiya Oweno. Nung ge me susuware niye eno gipariniya. Emo na tumo oko diyao yero nowa amimene Oweno diti moko mene oko gosinowa. Nupema awong nung kotumao mene oko kotupunowa. Aeno awong Oweno puro nao ine teng oko. Arata nung niye aune dema noiya, nupema moko ninae-una toiro nariniya. Aeno niye nung giro baingtitinowa. ");
INSERT INTO zia_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Na niye duwana bogamasa yero oko narineya. Na ninae-una nupema kapetegairo barinena. ");
INSERT INTO zia_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Be apungkaka gege mitiya awiya aung yai aune emo na tumo oko diyao nowa amimene na nupema oko garineya. Arata niye mene zo na garineya. Noeno okowata, na nao gege nona, narinena, deka ayero niye na aune dema narineya. ");
INSERT INTO zia_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Oweno mene wosi ninae-una yai aune Mama mene na aune dema noiya, o na niye aune dema nona, o niye na aune dema nowa, auna susuwa awiya giro baingtarineya. ");
INSERT INTO zia_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Zo nung ge bera nana nigiro puro dipunoiya auna aratamao awiya nana-una mitiya. Zo nung na ara tapunoiya, deka ayero Mama nana mene nung ara tamariniya. Nupema nane deka ayero nung ara tapunasani susuwa nana nung eno keregarinena.” ");
INSERT INTO zia_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ayero senu Yudas Iskeriot auna yazo mene atata yero eyero sena, “Tuwa, ning nono yero susuwa nina nae eno gege keregati nasani emo bauno eno oko keregao pung yarinesi?” ");
INSERT INTO zia_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ayero senu Yesu mene abena eyero sena, “Zo nung na ara tamariniya amimene ge nana nigiro dimariniya. Ayero yai Mama nana mene nung ara tamariniya. Mama nana mene nung aratapunai nato Mamato nuna-una kasa yero nung aune dema narinenato. ");
INSERT INTO zia_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Zo nung na oko ara tamao yariniya amimene ge nana oko dimariniya. Ge tugata nona gosinowa awiya nana okowata, Mama nana na iyengtina auna-una atu butunoiya ara. ");
INSERT INTO zia_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Na niye aune dema nasani ge tugata-magata yero nona, awiya nuwegowi sero ");
INSERT INTO zia_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","soremao ninae Oweno awiya nung Mama mene be nana-una iyengtai wosiro ge apakana niye eno tugata-magata yariniya. Ge awiya nane tugata yero nona deka awiya Oweno mene dubo ninae uwero sero aung yariniya. ");
INSERT INTO zia_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Na dubo iwaingne nao awiya niye eno pugatinena. Na dubo iwaingne nao naka nana awiya niye eno pugatinena. Tawingna emo bauno mene pugatinowa ayao ine okowata, dubo iwaingne nao nana me awiya niye eno pugatinena. Arare dubo ninae awang yao aung, kotung-katung yao aung, mitaise. ");
INSERT INTO zia_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Na eyero sesena nigeya: Na niye doro baungno nete nupema ninae-una kapetegairo barinena. Niye na aratamatei siya, awiya na Mamana-una babarinena awiya giro yawa yawa yateya. Noeno okowata, Mama nung witao nana yero noiya. ");
INSERT INTO zia_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Tani nana-una kasa yariniya awiya oko kasa yaore gitau niye eno sinena era. Arare kasa yai aune tumo diyao ninae tauyaise. ");
INSERT INTO zia_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Na ge daigairo susuuno niye eno oko sarinena. Tawingna emo tuwa Sanda mene nana-una bari nasani niya. Arata nung na eno tani zo yao ine teng oko. ");
INSERT INTO zia_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Emo na oko tumo diyao nowa amimene aratamao nana Mamana-una mitiya awiya gaese sero buro ge sinoiya awiya yero nona. Arare iropupu babanene.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu mene eyero sena. “Na wain susuwa me. Mama nana mene wain burora maung. ");
INSERT INTO zia_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tapo zo nana-una susuuno mitasani me oko iyao yai giro kapero duwariniya. Nupema tapo zo mere mitai giro me daigairo iyaise sero gomi kapero kora yai iwaing yariniya. ");
INSERT INTO zia_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Niye awiya na ge tugata yewang nigiwa, arare Mama nana mene meko ninae kapero niye kora yenu iwaing yero nowa. ");
INSERT INTO zia_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Arare niye na aune dema naya na deka ayero niye aune dema narinena. Wain tapo mene susuware oko gamao nung gege mitasani me oko iyariniya. Arare niye deka ayero na aune dema oko tayao nasani me oko iyarineya. ");
INSERT INTO zia_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Na awiya wain susuwa. Niye awiya wain tatapo. Zo nung na aune dema susuuno nariniya, awiya na deka ayero nung aune dema susuuno narinena. Ayero yana nung me ewezo iyariniya. Niye na doro nasani Tuwa Bayaura buro zo yao ine oko mitiya. ");
INSERT INTO zia_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Zo nung na aune dema oko susumao yariniya, nung awiya duwarinena. Ayero yana nung wain tatapo dotinowa sonoi yangta gairo iyaora pugatinowa awinoiya ayero yariniya. ");
INSERT INTO zia_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Niye na aune dema susuuno ge nana pu dube gairo narineya, awiya nona zo noeno isa saya ninae-una kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Niye me ewezo itinasani buro-mani nana yero naya Mama nana-una bowi kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mama mene na aratapunoiya, deka aine nane niye aratapunona. Arare niye aratamao nana auna neupu. ");
INSERT INTO zia_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Na mama nana-una ge dipunona, arare aratamao nuna nana-una mitoiya. Deka aine niye ge nana dimarineya, awiya aratamao nana ninae-una mitariniya. ");
INSERT INTO zia_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Yawa yawa yao nana mene ninae-una mitai aune yawa yawa ninae mene moko ninae-una beburo mitaise sero ge awiya sinena. ");
INSERT INTO zia_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Tinawiya ge nana eyero mitiya: Na niye aratapunona, deka aine nika niyetope wina aratapu nasani neupu. ");
INSERT INTO zia_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Zo nung otao mani nuna sorari yero giro nao nuna awong eno doro magayariniya auna aratamao awiya aratamao me asarineya. ");
INSERT INTO zia_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ge sinona awiya dimarineya, awiya niye otao mani nana yarineya. ");
INSERT INTO zia_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Na be yeme eune niye maze ‘soumani’ oko sinena. Noeno okowata, soumani mene emo tuwa nuna-una kotumao mitoiya awiya oko gosinoiya. Na niye ‘soumani’ okowata ‘otao mani nana’ ayero sinena. Noeno okowata, nane Mama nana-una atu ge nigiwang awiya teng niye eno keregairo tugata yero aung yetena. Arare na niye gigena otao mani nana neya arauwa. ");
INSERT INTO zia_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ninae na burora babanese sero oko pumuwa. Nane niye burora babaese sero pumuwang. Arare niye baungno burora me uraya me ewezo iyaese sinena. Uraya me iro mitao gege mitaise. Ayero yero yazo nana puro nasani Mama eno isa saya teng pugariniya. ");
INSERT INTO zia_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Niye nika niyetope wina aratapu nasani neupu. Ge awiya tinawiya ge nana arauwa. ");
INSERT INTO zia_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Emo bauno ge nana oko nigao amimene niye iwo yaya aune eyero sepu. Gitau awong Tuwa ayero zayero iwo yewa. ");
INSERT INTO zia_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Emo bauno ge nana oko nigao aune dema susumatei siya, awiya awong niye saore giro niye otao yateya. Arata na niye nunae-una towang atu yangtagairo pumuwang, aeno awong niye iwo yero nowa ara. ");
INSERT INTO zia_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ge zo niye eno eyero sesena awiya kotungpu. Soumani mene emo tuwa nuna daigairo nao ine oko mitiya. Ge auna susuwa eyao era. Ena mene ge nana nigiro dipunowa, deka ayero ena mene ge ninae nigiro dimarineya. Nupema ena mene na iwo yero nowa, deka ayero ena mene niye iwo yarineya. ");
INSERT INTO zia_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Awong nung na iyengtina auna susuwa oko gosinowa, arare niye iwo yarineya. Nupema niye buro-mani nana yero yazo nana puro nasani nowa, susuwa aeno niye eno ayero yarineya. ");
INSERT INTO zia_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Na nunae-una atu oko wosao yatena, o susuwa nana oko tugata yao yatena, awiya awong pasena aung nateya. Arata yeme awong pasena nunae nono sero pungyarinei? ");
INSERT INTO zia_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Zo nung na iwo yero noiya amimene deka ayero Mama nana iwo yero noiya. ");
INSERT INTO zia_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Na nunae-una atu nasani tani putoungne emo mene yao ine teng oko awiya oko yao yatena, awiya awong pasena aung nateya. Arata awong eno tani putoungne yero yewang awiya giro na iwo nasani Mama nana deka ayero iwo yero nowa. ");
INSERT INTO zia_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ayero yero nowa ge zo sao tauyao buku nunae-una atu gayao mitoiya awiya tauyero noiya. Ge awiya eyao era: ‘Awong na tebeba iwo yewa.’ ");
INSERT INTO zia_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Arata Soremao ninae Mamana-una mitoiya awiya iyengtana Mamana-una atu wosiro niye sorepu nasani susuwa nana niye eno keregariniya. Nung awiya Oweno. Ge me saora maung awiya nung ara. ");
INSERT INTO zia_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Be niye na buro zayewang auna atu na aune dema nasani nauwa neya amimene dema susuwa nana keregarineya.” ");
INSERT INTO zia_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yesu mene susuuno ge zo eyero sena, “Ago awong tani mou-mesa yao ena niye eno yaya niye titiye zaruwe yero tumo diyao ninae besao eno, na ge ewiya bere-bere keregatinena. ");
INSERT INTO zia_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Awong yere ibu sorarineya. Agege okowata, be zo bariniya be aune awong ‘Tuwa Bayaura buro kara yero nonane’ asinasani niye daya mamagayarineya. ");
INSERT INTO zia_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Awong nato Mamato awiya oko giro baingtao yero nowa, arare ayero yarineya. ");
INSERT INTO zia_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ge sinena amimene me yai aune ‘Yesu gitau eyao maze sena,’ ayero saese sero na niye bere-bere tugata nena era. Na niye gipari sero buro zayero naungwa be aune be nana imoko mitina, aeno na ge ewiya gitau niye eno oko sao naungwa. ");
INSERT INTO zia_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Arata yeme nung na senu wosiwang auna-una witari sero nena, aeno ge ewiya sinena. Arata ninae-una zo mene na eyero oko atata niya, ‘Ning natu babarinesi?’ ");
INSERT INTO zia_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ge ayao niye eno sesena niye dubo minao mene moko ninae beburo mitiya. ");
INSERT INTO zia_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Na ge me sana nigipu. Na kapete gairo witarinena, awiya niye iwaing mitaese witarinena. Na oko witao yarinena, awiya Soremao ninae mene oko wosariniya. Arata na witiro Soremao awiya iyengtana wosiro niye aune dema nariniya. ");
INSERT INTO zia_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Wosiro nona etama auna susuwa awiya emo bauno eno keregariniya: Pasenana susuwa, iwaing yero naora susuwa, pasenana abena tamao auna susuwa. Nung susuwa etama awiya keregai emo bauno mene gaya me yariniya. ");
INSERT INTO zia_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Pasenana susuwa eyero gipai garineya: awong na oko tumo diyao yero nowa, arare pasena nunae kara mitoiya. ");
INSERT INTO zia_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Iwaing yero naora susuwa eyero gipai garineya: na Mamana-una kapetegairo witana niye na nupema oko garineya. ");
INSERT INTO zia_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Pasenana abena tamao auna susuwa eyero gipai garineya: tawingna tuwa awiya Tuwa Bayaura kotora atu zuwaise sao mitiya. ");
INSERT INTO zia_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ge tugata yaora kotumao nana daigairo mitiya, arata niye yeme nigao ine teng oko. ");
INSERT INTO zia_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ge me susuware sao awiya Oweno ara. Nune wosiro ge me apakana susuware niye eno gipariniya. Arata ge awiya kotumao nuna-una oko puro sariniya. Ge nanato Mamato sarinenato awiya nigiro teng niye eno tugata yariniya. Tani daigairo ago kasa yarineya awiya dema bere-bere niye eno keregariniya. ");
INSERT INTO zia_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Na ge sana Oweno mene nigiro puro buro niye eno keregariniya. Ayero yai bowi nana kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Mamana nona apakana awiya nona nana, aeno na niye eno eyero sesena, ‘Oweno mene ge nana puro buro niye eno keregariniya.’ ");
INSERT INTO zia_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Be apungkaka mitiya awiya aung yai aune niye na oko garineya. Nupema be apungkaka aung yai aune niye na garineya.” ");
INSERT INTO zia_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yesu mene ayero senu buro-mani nuka nuyetope ge wina-se yero eyero sewa, “Nung eyero siniya, ‘Be apungkaka mitiya awiya aung yai aune niye na oko garineya. Nupema be apungkaka aung yai aune niye na garineya.’ Nung nono yero ungta ayero siniye? Nupema nung ge zo dema eyero sesiya, ‘Mamana-una witarinena.’ Ayero sesiya ara.” ");
INSERT INTO zia_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Buro-mani mene ayero sero nupema eyero sewa, “Nung eyero sesiya, ‘Be apungkaka mitiya.’ Ge awiya noeno siniye? Name iwawa nenane.” ");
INSERT INTO zia_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ayero sero nung atata yari sero newa Yesu nung nuka nutope mena giro eyero sena, “Ge eyero niye eno sesena aeno niye wina-se neita? ‘Be apungkaka mitiya awiya aung yai aune niye na oko garineya. Nupema be apungkaka aung yai aune niye na garineya.’ Ge auna susuwa sana gari sineita? ");
INSERT INTO zia_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Na memokoba niye eno sinena. Niye zire buware naya emo bauno na oko tumo diyao nowa amimene yawa yawa yarineya. Niye dubo minaore naya dubo minao ninae mene kapete gai yawa yawa yao ninae-una kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Bauno mene mani pari nema yaya tapunasani dubo mininowa. Ayero nema mani puro oregairo ‘mani pumena’ ayero sero yawa yawa yero nowa. Yaya tapunowa awiya oko kotupunowa. ");
INSERT INTO zia_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Deka ayero niye yeme dubo minineya. Arata na niye nupema garinena be aune niye yawa yawa bainakama yarineya. Yawa yawa ninae awiya emo zo mene kapai aung yao ine teng oko. ");
INSERT INTO zia_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Arare be aune niye nona zo kau yero giro na oko atata yarineya. Na memokoba sana nigipu. Niye nona zo eno Mama isa saya nona awiya pugari niya. Awiya noeno okowata, nung yazo nana-una pugariniya. ");
INSERT INTO zia_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Be na niye yangta gairo pumuwang atu butunawe yeme niya be aune niye yazo nana puro nasani nona zo eno isa oko sewa. Arare niye yawa yawa yao mene ninae-una kasa yero beburo mitaise isa sepu. Isa saya pugai parineya. ");
INSERT INTO zia_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ge niye eno tugata yero butunona awiya ge eniya tugata yero nona. Nete be zo bariniya aune na ge eniya oko sarinena. Be aune na Mamana susuwa pu daung gari sero ge pungyero oko, me keregairo niye eno sarinena. ");
INSERT INTO zia_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Be aune niye yazo nana puro nasani Mama isa sarineya. Na eyero oko sinena. ‘Nane niye soreuno Mama isa sarinena.’ Ayero oko sinena. Awiya noeno okowata, Mama mene niye aratapunoiya. ");
INSERT INTO zia_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Na Mamana-una atu wosiwang ge awiya niye nigiwa me yenu na aratapunowa. Arare Mama mene deka ayero niye ara tapunoiya. ");
INSERT INTO zia_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Na Mama doro tawingna wosiwang, arare na tawing doro nupema Mamana-una wiwitinena.” ");
INSERT INTO zia_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ayero senu buro-mani nuna mene eyero sewa, “Ning yeme ge eniya doro daung mokera keregairo sinesa ara. ");
INSERT INTO zia_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Arare nae ning eyero gosinenane: ning nika nitope kotumao nanae-una susuwa apakana giro aung yero nosa. Nae ning atata yari kotupu nonane arata ning nika nitope dubo nanae mena gosinosa, aeno ning Tuwara-una atu wosasa awiya gosinenane me niya.” ");
INSERT INTO zia_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ayero sewa Yesu mene eyero sena, “Niye yeme gigeya me nita? ");
INSERT INTO zia_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Be zo mitiya awiya mena bai aune na doro zanero napo ninae sero baungno aung yarineya. Ayero yero na duwaya na nata narinena. Arata na nata oko narinena. Mama mene na aune dema noiya, arare nata oko narinena. ");
INSERT INTO zia_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Niye yo-ozaore naese sero ge awiya niye eno sesena. Niye tawingna yayare dubo minaore narineya. Arata nane tawingna nona dire bere awiya puro wosiro papatinena, arare niye putoungne neupu.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu nung ge awiya sero aung yero diti uritira yero isa sinasani eyero sena, “O Mama, be nugu niya. Na Mani nina. Na yazo nina de ika yana baina yaise sero gitau nine yazo nana de ika yasa baina yaise sinena. ");
INSERT INTO zia_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ning emo ena na eno pugairo na nao me iwaing awiya awong eno puganese sero na tawing sero serora emo bauno auna maung bainakama pugasa. ");
INSERT INTO zia_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nao iwaing auna susuwa eyero mitiya. Ning Tuwa Bayau me dekaongka. Emo iyengtasa awiya Yesu Kristo arauwa. Emo bauno mene susuwa nanao awiya gaya me yai awong nao me iwaing pumarineya. ");
INSERT INTO zia_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Buro ge na eno sasa awiya tawingna etu yero butu nawe besugena. Ayero nasani yazo nina de ika gena. ");
INSERT INTO zia_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O Mama, tawing oko kasa yaore na ning aune dema uritira waegao nana aune naungwa, deka awiya nupema pugai na puro nane. ");
INSERT INTO zia_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Emo bauno apakana auna-una atu emo ena yangtagairo na eno pugasa nana yewa aune na susuwa nina awong eno keregaingwa. Dubu nina sao nauwa awiya na eno pugasa awong ge nina nigiro puro pu dube gairo nowa. ");
INSERT INTO zia_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Awong yeme nona nana apakana nina-una atu gege butu noiya awiya gosinowa. ");
INSERT INTO zia_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ning ge na eno pugasa awiya sewang nigiro pumuwa ara. Ayero nasani na nina-una atu wosiwang awiya giro me asewa, arare nine buro ge na eno sasa awiya deka ayero nigiwa me yena ara. ");
INSERT INTO zia_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Na awong eno isa sinena. Emo bauno na oko tumo diyao nowa awong awiya eno oko ning eno isa sinena. Dubu na eno pugasa awiya eno isa sinena, noeno okowata, awong awiya dubu nina me arauwa. ");
INSERT INTO zia_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Emo bauno nana apakana awiya nina ara. Nupema emo bauno nina apakana awiya nana ara. Arare awong yazo nana de ika gatineya. ");
INSERT INTO zia_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na tawingna etu oko mitarinena. Na buro nina-una yarinena. Arata nunae mene zo tawingna etu mitasani narineya. O Mama dang, nao dubo dekaongka yero nonano, deka ayero awong dubo dekaongka yero naese sero yazo nina na eno pugasa auna putoung mene awong diya ye. ");
INSERT INTO zia_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Na awong aune dema nasani yazo nina-una putoung mene awong diya yero nona. Ning yazo awiya na eno pugasa. Na awong diya yero baingtena, arare zo mene oko tara yao. Arata ge gayao zo mitiya awiya me yaise dekaongka mene tara yero sisigari niya. Nung tara yaora gerao. ");
INSERT INTO zia_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Yawa yawa yao nana mene dubo nunae topetaise sero na tawingna etu mitasani na nina-una baora be nugu ni giro ge ewiya sinena. ");
INSERT INTO zia_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Na ge nina tugata nona puro nowa aeno tawingna emo bauno mene awong iwo yero nowa. Nao nana awiya tawingna emo bauno auna nao ine okoware. Deka ayero nao nunae awiya tawingna emo bauno auna nao ine oko. Aeno tawingna emo bauno awong iwo yero nowa. ");
INSERT INTO zia_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ning buro-mani nana awiya tawing euna atu sorero pasese okowata, Sanda mene awong etegai meko yowi sero, ning awong soremasese isa sinena era. ");
INSERT INTO zia_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nao nana awiya tawingna emo bauno auna nao ine okoware. Deka ayero nao awena awiya tawingna emo bauno auna ine okowa. ");
INSERT INTO zia_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ge me nina mene dubo awena inai awong pewa yero gerao nina yae. Ge nina awiya ge me susuware ara. ");
INSERT INTO zia_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nine na tawingna etu buro yanese sasa, arare deka ayero nane awong tawingna etu buro yaese sewang. ");
INSERT INTO zia_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ge me mene dubo nunae inai tau yero naese na nao nana awong eno wawong nina-una pugatinena era. ");
INSERT INTO zia_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Arata na awong eno gege oko isa sinena. Ge tugata yaya nigiro na tumo diyarineya awong aeno dema isa sinena. ");
INSERT INTO zia_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Awong dubo dekaongka yero naese ning eno isa sinena. O Mama, ning na aune mitosa na deka ayero ning aune mitona, deka ayero awong nao aune dema mitaese. Ayero yaya emo na oko tumo diyao yero nowa amimene nine na iyengtasa wosiwang awiya giro me asae. ");
INSERT INTO zia_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nao dubo dekaongka yero nonano, deka ayero awong dubo dekaongka yero naese sero ning putoung na eno pugasa dekaongka awiya awong eno pugatinena. ");
INSERT INTO zia_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Na awong aune dema mitana ning deka ayero na aune dema mitasa awong dubu dekaongka yero nae. Ayero yero naya emo bauno na oko tumo didinowa amimene na iyengtasa wosiwang awiya gaese. Nupema awong ning na aratapunosa deka ayero ning dubu nana dema aratapunosa awiya dema giro baingtaese. ");
INSERT INTO zia_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","O Mama, emo dubu na eno pugasa awong awiya masi na narinena deka auna atu naese sinena. Ayero yero tawingna poza oko kasa yaore nine na ara tapunasani uritira waegao na eno pugasa waegao awiya awong nao aune dema nasani gaese sinena. ");
INSERT INTO zia_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O Mama, ning dangna maung. Emo na oko tumo diyao yero nowa amimene ning oko giro baingtiti nowa. Arata nane mene zo ning giro baingtiti nona. Nupema dubu nana mene nine na iyengtasa wosiwang awiya giro baingtiti nowa. ");
INSERT INTO zia_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Aratamao nina nana-una mitoiya deka ayero nunae-una mitai na awong aune dema nari sero bowi ge nina awong eno keregena. Ayero gege keregati nasani narinena.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu nung isa ayero senu aung yenu iropuro buro-mani nuna puro nape atu wosiro ou Kidoron buwagairo tawing zora i buro mitauna auna bamuwa. ");
INSERT INTO zia_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yesu buro-mani nuna aune be ozaung atu augairo nasani nauwa, arare Yudas keregao emo amimene i buro awiya nung gao ara. ");
INSERT INTO zia_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Arare Yesu buro-mani nuna aune atu newa Yudas keregao emo amimene pirisa babuze aune Farisayora polis ena aune gorobo emo ena awiya puro gitau yero izira yuno damana gaero gi amine puro bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu mene nona apakana nung eno yari newa awiya giro iropuro benaungna baungno awong atata yero eyero sena, “Niye awe maze kau nei?” ");
INSERT INTO zia_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ayero senu awong eyero sewa, “Nasaretera emo zo yazo nuna Yesu awiya kau nenane.” Ayero sewa nung eyero sena, “Na era.” Ayero sena ara. Yudas nung keregao emo nung gorobo emore dema dopero mitina. ");
INSERT INTO zia_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Arare Yesu mene, “na era,” ayero senu awong awang yero bautara baungno zuwewa ara. ");
INSERT INTO zia_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ayero yewa nung nupema atata yero sena, “Niye awe maze kau nei?” Ayero senu awong eyero sewa, “Yesu Nasaretera emo.” ");
INSERT INTO zia_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ayero sewa Yesu mene awong eno eyero sena, “Na sesena arauwa. Na era. Niye na kau neya, arare dubu nana ewiya dopu babae.” ");
INSERT INTO zia_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nung ge gitau sena awiya me yaise sero buro-mani nuna duwaese sena. Ge gitau eyero sena, “Na eno pugasa awong diya yetena zo za oko tara yao ara.” ");
INSERT INTO zia_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Arare Simon Petoro nung iwi geingna puro nena awiya ininu gururu senu pirisa bainana soumani zo auna dawong wawong mera awiya kesena. Mani awiya yazo nuna Maliko. ");
INSERT INTO zia_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ayero yenu Yesu mene Petoro eno eyero sena, “Iwi nina geingna pugai towae. Yaya ewiya Mama nana mene na eno pugatiniya, awiya duwanese nesa?” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ayero senu gorobo emora diya mene senu gorobo emo aune Yudara polis amimene Yesu puro wawong bunewa ara. ");
INSERT INTO zia_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bunero puro gitau baung Anasira gare yewa ara. Dawang aune emo zo yazo nuna Kayafa amimene pirisa baina yero nauna. Nune Anasira mani baunodi atiro nasani nauna. ");
INSERT INTO zia_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa nune gitau Yuda emo eno ge eyero sena, “Emo bauno name apakana meko yero aung yonine sero, nung dekaongka amimene name eno magayaise sao mitiya.” Gitau ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Polis mene Yesu puro baungno Anasira-una yewa, Simon Petoro otao nuna zore awongto Yesu puro bamuwa awiya ago yero bamuwato ara. Petorora otao awiya pirisa baina awiya nung gosinauna, arare Yesu ago yero toi goma mokora yena ara. ");
INSERT INTO zia_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Petoro mene zo goma bautara atu dopena ara. Ayero yenu otao nuna mene pirisa baina auna gare atu nauna, arare wosiro goma be diya yao mani baunodi zo aeno senu goma be iwenu Petoro toi mokora yena ara. ");
INSERT INTO zia_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Petoro toinu mani baunodi goma be diya nena amimene Petoro giro eyero sena, “Emo ouna buro-mani zo ning arita nowa.” Ayero senu Petoro mene “Na aung.” ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Be aune pirisa bainana soumani gorobo emore awong yayaung yenu giro iyao ero ainewa Petoro nung dema baung nunae-una towang yero iyao ainena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pirisa baina mene Yesu buro-mani pupugaina aune o ge tugata yero nauna aune atata yena. ");
INSERT INTO zia_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Atata yenu Yesu mene abena eyero sena, “Na ge benaungna atu gege sinona. Yuda emo augati nowa — yere ibu enanata ibu bainana — auna atu ge sero tugata nasani gipinasani ayero nona. Na opene ge oko sinona. ");
INSERT INTO zia_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Arare ning nono yero na atata nesi? Ge sinona nigiti nowa awong awiya atata yasa ge sinona awiya saya nigase.” ");
INSERT INTO zia_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ayero senu diya emo dopero mitiwa auna zo mene Yesu sowena dero eyero sena, “Ning noeno ge ayero pirisa baina eno sinesi?” ");
INSERT INTO zia_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ayero senu Yesu mene abena eyero sena, “Ge meko seseni siya ayero sinesa auna susuwa se. Arata na ge iwaing sinena aune noeno na dedunesi?” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yesu ge ayero senu aune Anasi mene senu Yesu bunero puro pirisa baina yazo nuna Kayafa auna-una bamuwa arauwa. ");
INSERT INTO zia_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Petoro nung iyao ainasani mitinu awong nung nupema atata yero sewa, “Buro-mani nuna auna zo ning arita nowa?” Ayero sewa nung bewae yero eyero sena, “Na aung.” ");
INSERT INTO zia_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ayero senu pirisa bainana soumani zo, Petoro mene dawong kesena auna dikaing zo, amimene eyero sena, “Ge me nibamu, ning i bure atu Yesu aune dema dopero mitesa gigenita nowa?” ");
INSERT INTO zia_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ayero senu Petoro mene nupema bewae yenu aune kokora ge sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Iya gainu awong Yesu Kayafara-una gare atu puro wosiro baung Roma emo zo awong diya nasani nauna auna-una yewa ara. Yuda emo awong Magayao mene awong Daigaina auna bonene minari sero newa, arare awong iya be dang sisigowi sero, Pilatora gare oko towao yewa. Awiya noeno okowata, Yuda emo mene eyero sinasani nauwa, “Dubo naname beingtire yoiye sero, name emo Yuda okora-una gare oko towanene.” ");
INSERT INTO zia_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ayero sinauwa, arare awong duru atu dopewa Pilato mene kasa daung yero awong atata yero sena, “Emo ewiya pasena nouna puro butunei?” ");
INSERT INTO zia_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ayero senu awong eyero sewa, “Nung pasena oko yao yatiya, awiya nae nina-una oko puro batenane.” ");
INSERT INTO zia_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ayero sewa Pilato mene eyero sena, “Sao tauyao ge ninae mitiya auna teng sepu aung yae.” Ayero senu awong eyero sewa, “Nae mani magayaese sao aung yao awiya nanae-una gazao mitiya. Noeno okowata, sao tauyao ge ninae Roma emora amimene gaziniya. Arata nine sasa teng yariniya.” Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yuda emo ayero sewa Yesu nung nutope gitau “Na i pasaora daya magayarinena,” ayero sena auna ge awiya me yena. ");
INSERT INTO zia_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato mene garo mokora baungno Yesu yausenu baungnu eyero sena, “Ning Yuda emora emo tuwa ning?” ");
INSERT INTO zia_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ayero senu Yesu mene abena eyero sena, “Ge awiya dubo nina-una sinesita ena mene bowi nana ning eno seseya giro sinesi?” ");
INSERT INTO zia_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ayero senu Pilato mene eyero sena, “Na Yuda emo okowa. Emo mamono nina arita pirisa babuze amimene ning nana-una pugatineya. Ning no yetesi?” ");
INSERT INTO zia_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ayero senu Yesu mene eyero sena, “Na tawingna etu emo tuwa oko yero nona. Na tawingna etu emo tuwa yero natena, awiya emo dubu nana mene gi ami puro na soremaya Yuda emo na oko pumateya. Emo tuwa yero naora buro nana awiya tawingna etu oko mitiya.” ");
INSERT INTO zia_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ayero senu Pilato mene eyero sena, “Ayero ning emo tuwa zo ning?” Asenu Yesu mene eyero sena, “Ara, kara sinesa arauwa. Na emo tuwa zo. Na ge me susuware keregari sero wosiro tawingna etu kasa yewang. Ge me nigari ara tapunowa amimene ge nana nigiti nowa.” ");
INSERT INTO zia_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ayero senu Pilato mene abena eyero sena, “Ge me awiya noiye?” Ayero sero kasa daung yero Yuda emo eno eyero sena, “Na emo euna pasena tamari sero kau nete zo oko tamao yetena. ");
INSERT INTO zia_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Arata tani ninae zo mitiya. Magayao mene awong Daigaina auna iya be dang ninae-una atu na eno sinowa bunao emo zo ao-didinona tebeba bautunoiya. Arare deka ayero nigaya na Yuda emora emo tuwa ninae ao-diyana naise kotupuneita?” ");
INSERT INTO zia_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ayero senu awong wawa sero eyero sewa, “Aung ara. Nung okowata, Barabas nung awiya ao-diyasa bae.” Ayero sewa ara. Barabas nung mani dero nona ugaing puro yao emo. ");
INSERT INTO zia_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilato mene senu gorobo emo awong Yesu angsi mene dewa. ");
INSERT INTO zia_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ayero yero nung izari sero angsi dungne puro ewero aune ziyo nuna-una atu wosogaiwa. Ayero yero taung wori yuyao zo dema wosogaiwa punu ");
INSERT INTO zia_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","baung nuna-una nugu yero nung sowena dedunasani eyero sewa, “Wari iwaing, Yuda emora emo tuwa.” ");
INSERT INTO zia_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato mene nupema kasa daung yero Yuda emo eno eyero sena, “Gipu. Na nung puro ninae-una butunena. Na pasena nuna tamari sero kau nete zo oko tamao yetena.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ayero senu Yesu nung angsi dungne ewao aune taung wori yuyao wosogaiwa puro nena aune dema wosiro dopenu Pilato mene gipero eyero sena, “Emo ewiya gipu.” ");
INSERT INTO zia_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ayero senu pirisa babuzere gorobo emo nunae amimene giro wawa sero sewa, “I pasaora atu magayaise. I pasaora atu magayaise.” Ayero sewa Pilato mene be nunae-una puro eyero sena, “Na pasena nuna kau nena. Nung pasena aung. Arare niye nika niyetope puro i pasaora depu.” ");
INSERT INTO zia_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ayero senu Yuda emo mene eyero sewa, “Nung nutope ‘Na Tuwa Bayaura mani,’ asinoiya, arare emo ayao awiya magayaese sao tauyao ge nanae auna atu sao mitiya, arare magayaise.” ");
INSERT INTO zia_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ayero sewa Pilato ge awiya nigiro awang bainakama yena ara. ");
INSERT INTO zia_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ayero yero Yesu nupema yuno garo mokora baungno atata yero sena, “Ning natu kasa yasi?” Ayero senu Yesu mene abena oko sao yangduna. ");
INSERT INTO zia_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ayero yenu Pilato mene eyero sena, “Ning noeno ge nana oko abena sao nesi? Nane sana narinesita i pasaora magayarinesi auna putoung nana-una mitiya, awiya ning oko gosinesita?” ");
INSERT INTO zia_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ayero senu Yesu mene abena eyero sena, “Tuwa Bayau mene putoung awiya ning eno oko pugao yatiya, awiya ning na magayaora pugao ine teng oko yatesa. Arare emo na magayanese sero nina waweng pugaiya auna pasena mene pasena nina daigatiniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ayero senu Pilato mene ge awiya nigiro kasa daung yero Yesu ao-diro duwari senu Yuda emo awong wawa sero eyero sewa, “Ning emo awiya ao-diro duwaora ge sarinesa, awiya ning Romana emo tuwa Sisa auna otao nupema oko narinesa. Zo nung nutope emo tuwa asariniya amimene Romana emo tuwa Sisa awiya daigatiniya.” ");
INSERT INTO zia_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ayero sewa Pilato mene ge awiya nigiro giro senu Yesu puro kasa daung yewa Pilato mene ge sao aung yao masi nuna-una atu adungno mitina ara. Masi awiya daba mene nabero yao. Masi auna yazo Yuda emo mene Gabata asinauwa ara. ");
INSERT INTO zia_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Arare Yuda emo bauno oregao be baina auna atu mitari sero nona kora nasani newa wari towang dopenu Pilato mene masi nuna-una atu mitasani Yuda emo eno eyero sena, “Gipu. Emo tuwa ninae era.” ");
INSERT INTO zia_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ayero senu awong wawa sero eyero sewa, “Nung aung yaise. Nung aung yaise. I pasaora atu magayaise.” Ayero sewa Pilato mene eyero sena, “Emo tuwa ninae sana i pasaora atu magayaise sineita?” Ayero senu pirisa babuze mene abena eyero sewa, “Nae emo tuwa nanae zo aung. Roma emora emo tuwa Sisa amimene gege yero niya.” ");
INSERT INTO zia_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ayero sewa giro Pilato mene ge nunae nigiro Yesu i pasaora magayaise sero pu wawong nunae-una gaina arauwa. ");
INSERT INTO zia_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ayenu gorobo emo mene Yesu puro i pasao pugaiwa diungnu tawing zo yazo nuna Gitau Atora Wetu, arata Yuda gera Goligata, auna puro bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Puro baungno i pasaora dewa ara. Dero pasena mani etobe i pasao etora dero zo enaba zo enaba Yesu towang ayero urewa dopewa ara. ");
INSERT INTO zia_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato mene senu ge eyero gaero Yesura i pasaora atu pugaiwa, “Yesu Nasarete napora. Nung Yuda emora emo tuwa.” ");
INSERT INTO zia_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yesu dewa tawing awiya napo mitina auna nugu. Arare Yuda emo daigairo mene puma sauma nasani ge Yuda gera, Roma gera, Grik gera gaewa awiya zazagaiwa. ");
INSERT INTO zia_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Arare Yuda emora pirisa babuze mene Pilato eno eyero sewa, “Ning eyero gaetesa awiya teng oko niya, ‘Nung Yuda emora emo tuwa.’ Awiya doro eyero sero gae, ‘Nung nutope na Yuda emora emo tuwa asinoiya’ ayero gae.” ");
INSERT INTO zia_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ayero sewa Pilato mene eyero sena, “Gaetena amimene mitaise.” Ayero sena arauwa.’ ");
INSERT INTO zia_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Gorobo emo awong Yesu i pasaora dero aune taung wori nuna tame awiya kerewa siwongpatige yenu bono yero pumuwa. Arata taung wori tura awiya mo etobe pu dekaongna gairo gayao oko. Ika atu gaero wosiro babao ara. ");
INSERT INTO zia_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Arare awong eyero sewa, “Awiya keranane meko yariniya. Arare ge tuwao zo yazo nuna laki yanane emo zora-una kasayai giro amimene paise.” Ayero sero yewa ara. Ayero yewa aune ge gayao zo eyero mitiya amimene me yena, Awong taung wori nana tame awiya bono yewa. Taung wori nana eno ge tuwao zo yazo nuna laki yewa. Ge gayao mitiya, arare gorobo emo mene ayero yewa. ");
INSERT INTO zia_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesura i pasao susuwara atu emo bauno benaung eyao amimene dopewa: Ai nuna, aira yao, Maria Kliopara aro, Maria napo nuna Madala. ");
INSERT INTO zia_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Arare Yesu nung ai nuna aune buro-mani nuna iwaing awongto dopero mitiwato giro ai nuna eno eyero sena, “Aya, mani nina arauwa.” ");
INSERT INTO zia_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ayero sero buro-mani nuna eno eyero sena, “Ai nina arauwa.” Ayero senu giro be auna atu nung Yesura ai yunu nuna-una gare witinu diya yero nauna arauwa. ");
INSERT INTO zia_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Arare Yesu nung buro nuna aung yenu giro ge gayao zo mitina awiya me yaise sero eyero sena, “Na ouwe niya.” ");
INSERT INTO zia_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ayero senu awong witora yabutata zo puro ou wain dokowang yao awang zora mitina auna dusero itura diro be nuna-una pugaiwa. ");
INSERT INTO zia_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ou wain miniro eyero sena, “Buro yero besugena.” Ayero sero tumo gokosenu oweno nuna aung yena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yuda emo awong iya dang nunae-una nona sosinasani giro eyero sewa, “Ture awiya Magayao mene awong Daigaina auna iya be bainakama, arare emo i pasaora dao awiya oko mitae.” Ayero sero Pilato eno eyero sewa, “Awong mena magayaese sero ning ge sasa gorobo emo mene baungno te nunae dero zozorogaya mena magayaya aingso nunae i pasaora atu paese.” Ayero sewa Pilato mene ge nunae nigina. ");
INSERT INTO zia_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ayenu gorobo emo awong pasena emo etobe Yesu aune dema dewa auna zora te dewa wetu zorogainu zora deka ayero dewa zorogainu ayewa ara. ");
INSERT INTO zia_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ayero yero Yesura-una baungno nung magayero mitinu giro wetu oko dao zorogao duwa ara. ");
INSERT INTO zia_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Arata gorobo emo zo mene baungno karowa mene Yesura zazawingna atu gaenu basugainu yure oure wosina ara. ");
INSERT INTO zia_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nane nona awiya diti moko nana mene gigiwang. Arare na sero keregatinena me niya arauwa. Na gosinena, ge awiya me arauwa. Niye dema gaya me yaise sero ge me keregatinena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ge gayao zo eyero mitiya awiya me yaise sero nona awiya kasa yena, Awong wetu nuna zo za oko daya zorogariniya. ");
INSERT INTO zia_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nupema ge gayao zo eyero mitiya, Awong nung gaewa basugaina awiya diti yero garineya. Ge gayao etobe ayero miteyato arauwa. ");
INSERT INTO zia_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yosepe Arimatia napora nung Yesura mani zo yero nasani nauna, arata nung Yuda emo awang yero tumo diyao nuna awiya pungyero puro nasani nauna. Nung amimene Pilatora-una baungno Yesura aingso i pasaora atu pumari sero atata yena. Ayero yenu Pilato mene niginu baungno batagairo puna ara. ");
INSERT INTO zia_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodema nung gitau pingne Yesura-una kasa yena amimene i mung sereyao mouyao nuna 34 kilogram ayao puro baungno Yosepe sorepu nasani ");
INSERT INTO zia_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yesura aingso i mung sereyao amimene suwero mo neyang yao mene ewewato ara. Yuda emo awong emo maganauwa awiya ayero yero nauwa ara. ");
INSERT INTO zia_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesu dewa tawing auna agewara i buro zo mitauna auna atu daba uma zo biriti asero seka wamuwa mitina. Gitau emo zora aingso atu oko pugao. ");
INSERT INTO zia_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Biriti awiya nugu mitina, arare Yuda emora oregao be baina auna nona sosaora be mitinu giro awongto Yesura aingso atu pugaiwato arauwa. ");
INSERT INTO zia_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sande gora oko iyagairo baingtao Maria napo nuna Madala amimene biritira baungno eyero gigina. Daba biritira uma be gazao awiya dereme yero baungno enaba demese atu mitina. ");
INSERT INTO zia_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ayero giro sungno baungno Simon Petoro aune Yesura buro-mani iwaing auna-una kasa yero eyero sena, “Awong Tuwara aingso puro babeya. Awiya natu pugei?” ");
INSERT INTO zia_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ayero senu giro Petoro otao nuna zore baung biritira yewato ara. ");
INSERT INTO zia_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nagibe atu sungno bautu newato otao amimene sungno Petoro daigairo gitau baungno biritira kasa yena. ");
INSERT INTO zia_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kasa ye daba umana gairo utero mo aingso nuna ewewato agege mitinu gigina. Arata nung oko towao. ");
INSERT INTO zia_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ayero nenu Simon Petoro ago kasa yero daba umana toiro mo gigina. ");
INSERT INTO zia_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Mo zo ziyora ewewato awiya dema mitinu gigina. Mo awiya mo enane dema oko mitina. Nung nata enaba atu zorogairo baingtao mene mitina. ");
INSERT INTO zia_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Arare Petoro gosinenu otao nuna gitau baungno daba umana atu kasa yena amimene ago toiro giginu me yena ara. ");
INSERT INTO zia_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Arata awongto Yesu magayaora atu seka yero iropariniya auna ge gayao mitina auna susuwa awiya oko giro baingtiwato. ");
INSERT INTO zia_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ayero yero nupema yesese yero baung nape yewato arauwa. ");
INSERT INTO zia_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria nung biriti umana bera atu dopero zi sinasani mitete daba umana bera atu utero diti yena. ");
INSERT INTO zia_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Diti yero angelo etobe taung wori neyang yaore Yesu pugaiwa iropuro bauna masi auna atu zo gitaura zo tera ayero dopero mitiwato gigina ara. ");
INSERT INTO zia_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Giginu awongto eyero sewato, “Ning noeno zi sinesi?” Ayero sewato nung eyero sena, “Tuwa nana-una aingso puro natu babeya kau neni.” ");
INSERT INTO zia_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ayero sero kapetegairo Yesu dopero mitinu gigina. Giro Yesura benaung oko giginu kasa yena ara. ");
INSERT INTO zia_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ayero yenu Yesu mene atata yero eyero sena, “Ning noeno zi sinesi? Ning awe kau nesi?” Ayero senu Maria nung i buro auna maung mene dopero mitinuta asero eyero sena, “Nine Yesura aingso puro baungno agewa zora atu pugesita? Se giro baungno pumane.” ");
INSERT INTO zia_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ayero senu Yesu mene abena eyero sena, “Maria.” Ayero senu nung sopine yero Yuda gera “Rabonai” asena. (Ge naname-una, Gipao Emo.) ");
INSERT INTO zia_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ayero senu Yesu mene eyero sena, “Na Mamana-una oko witao ware na oko inase. Ning baungno buro-mani nana eno eyero se. ‘Mama nana awiya Maung ninae. Tuwa Bayau nana awiya Tuwa Bayau ninae. Na nuna-una witarinena.’ Ayero se nigae.” ");
INSERT INTO zia_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ayero senu Maria napo nuna Madala amimene yesese yero baungno Yesura buro-mani eno eyero sena, “Na Tuwa gigena.” Ayero sero aune Yesu mene ge nung eno sena awiya awong eno sena ara. ");
INSERT INTO zia_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sande ture mume itinenu buro-mani mene Yuda emo awang yero augairo garo be dewa gaunu mitiwa Yesu mene awena-una towang atu kasa yero dopero eyero sena, “Awang yao doro iwaing mitipu.” ");
INSERT INTO zia_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ayero sero berumana masi wawong etora aune zazawingna aune gipena. Ayero yenu buro-mani mene Tuwa nunae giro yawa yawa yewa. ");
INSERT INTO zia_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ayero yewa nung nupema awong eno eyero sena, “Awang yao doro iwaing mitipu. Mama mene na iyengtina, deka ayero nane niye iyengtiti nena.” ");
INSERT INTO zia_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ayero sero oweno nuna pise awena-una gairo eyero sena, “Oweno pungpu. ");
INSERT INTO zia_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Niye emora pasena disaya aung yariniya. Arata niye oko disao yaya mitariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Otao nunae Tomas yazo nuna zo Didimo, nung awiya agewa zora atu nenu Yesu mene mani enana-una gege kasa yena. ");
INSERT INTO zia_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Arare otao mani ena mene bowi ge nung eno eyero sewa, “Nae Tuwa gigenane.” Ayero sewa nung eyero sena, “Na natope diti moko nana me mene wawongna beruma masi giro, o wawong soro nana mene beruma masi gaero giro, o zazawing nuna gaeteya auna iso wawong nana mene iniro giro ayarinena, awiya ge ninae me asarinena.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wari be 8 aung yenu aune buro-mani nuna ena aune Tomas nuka nung dema garo mokora atu toiro garo be apakana dewa gaunu mitiwa Yesu mene awena-una towang atu nupema kasa yero dopero eyero sena, “Awang yao doro iwaing mitipu.” ");
INSERT INTO zia_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ayero sero Tomas eno eyero sena, “Ning wawong soro nina mene wawong nana iniro gi. Wawong nina mene zazawing nana iniro gi. Ayero yero dubo eto nupema oko ye. Na seka nena awiya gasa me yae.” ");
INSERT INTO zia_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ayero senu Tomas mene eyero sena, “Ning Tuwa nana. Ning Tuwa Bayau nana.” ");
INSERT INTO zia_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ayero senu Yesu mene eyero sena, “Ning na gosinasani aeno na tumo didinesa. Awong na oko gao nasani na tumo diyarineya awong amimene dema yawa yawa yarineya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Tani ena daigairo Yesu mene buro-mani nuna-una ditira atu nauna awiya buku euna oko gaero aung yao. ");
INSERT INTO zia_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Arata ge gainena auna susuwa noeno okowata, eyao eno gainena arauwa: Niye ge ewiya zazagairo nigiti nasani Yesu nung Sorao Emo Kristo, Tuwa Bayaura Mani, auna ge awiya gaya me yaise, o nung tumo didinasani yazo nuna-una nao me iwaing tamaese sero ge ewiya gainena. ");
INSERT INTO zia_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yesura buro-mani ena Taibirias ou nazira atu newa nung nunae-una kasa yena. Buro-mani awong dubu euna-una kasa yena. ");
INSERT INTO zia_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Petoro, Tomas yazo nuna zo Didimo, Nataniel Galilaya tawing Kena napo mitauna auna, aune Zebedira mani etobe, aune zo etobe dema. Emo amimene au dekaongna gairo mitiwa aune ");
INSERT INTO zia_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Petoro mene ena eno eyero sena, “Na wo pumari bautunena.” Ayero senu awong eyero sewa, “Nae ning aune dema babarinenane.” Ayero sero wangna witiro bamuwa. Bautunete ping aune wo oko pumao yewa. ");
INSERT INTO zia_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Anasani ou nazi auna atu newa iya gatinenu Yesu mene bage atu dopena ara. Dopenu awong benaung nuna oko giro baingtiwa. ");
INSERT INTO zia_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ayero yewa Yesu mene awong atata yero eyero sena, “Mani awiso, niye wo zo mitita?” Ayero atata yenu awong eyero sewa, “Aung.” ");
INSERT INTO zia_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ayero sewa nung eyero sena, “Wang deung enaba wawong mera ina atu moga pugaipu wosai aune wo takasai watimae.” Ayero senu moga pugaiwa wosinu wo daigairo nibamu takasena ara. Ayero yenu watiung wangna gari yewa teng oko yenu kaputewa. ");
INSERT INTO zia_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ayenu Yesura buro-mani iwaing amimene Petoro eno eyero sena, “Owiya Tuwa ara.” Ayero senu Simon Petoro nung mo gege awiro nena, arare nung “Tuwa mene niya ora,” ge awiya nigiro taung wori nuna tame awiya wosogairo witora gutena ara. ");
INSERT INTO zia_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Awong bago deungbera ake ina atu newa, arare mani ena mene wang dawinasani moga wore watiuno bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ayero yero witi ika yero nona eyao gigiwa. Iyao mokora atu wore mare sasinasani mitina. ");
INSERT INTO zia_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Mitinu awong witiro bamuwa Yesu mene eyero sena, “Wo pumeya auna ena puro bungpu.” ");
INSERT INTO zia_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ayero senu Simon Petoro mene wangna witiro moga watiung ika gaina ara. Moga mokora wo babuze 153 ayero mitiwa, arata moga oko zanao. ");
INSERT INTO zia_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Arare Yesu mene awong eno eyero sena, “Bungpu, nona minae.” Ayero senu buro-mani nuna mene “Ning aweni?” ayero atata yari sero yewata gigiwa mou yenu giro duwa. Noeno okowata, nung Tuwa ara, awiya yemaoko gigiwa kasa yena. ");
INSERT INTO zia_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu mene wo ma bono yero awong eno pugaina ara. ");
INSERT INTO zia_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesu nung magayaora atu seka yero iropuro buro-mani nuna-una kasa yenu be etama yena. ");
INSERT INTO zia_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nona miniwa aune Yesu mene Simon Petoro atata yero eyero sena, “Simon, Yohanena mani, otao mani nina awong na aratapunowa, awiya nine awong daigati nasani na ara baina tapunosa, awiya me ing?” Ayero senu Petoro mene abena eyero sena, “Tuwa, nao otao yero nonano, awiya ning gosinesa.” Ayero senu Yesu mene eyero sena, “Ning lama dubu nana awiya uninasani neu.” ");
INSERT INTO zia_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ayero sero nupema atata yero eyero sena, “Simon, Yohanena mani, ning meba na aratapunosita?” Ayero senu Petoro mene eyero sena, “Tuwa, nao otao yero nonano, awiya ning gosinesa.” Ayero senu Yesu mene eyero sena, “Ning lama dubu nana-una diya yero neu.” ");
INSERT INTO zia_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ayero sero nupema atata yero eyero sena, “Simon, Yohanena mani, nao otao yero nonano, awiya me ing?” Tairo naora atata yenu be etama yenu Petoro nung punu nuna-una mou yenu giro dubo mininasani eyero sena, “Tuwa, ning emora dubo gosinosa, arare nao otao yero nonano awiya ning gosinesa arauwa.” Ayero senu Yesu mene eyero sena, “Ning lama dubu nana uninasani neu. ");
INSERT INTO zia_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ge memoko sana nigi. Ning sema nina-una nasani nitope geing ipura diyao nina awiya diro nagibo natu natu babari sero bautunauwasa. Arata nete zai yero wawong nina ika pari yasa emo zo mene ipu nina-una geing diro masi oko babari sarinesa auna ning puro babariniya.” ");
INSERT INTO zia_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu mene ayero sinasani Petorora magayao auna susuwa awiya keregaina. Magayao nuna mene Tuwa Bayaura yazo de ika yari nena awiya sena arauwa. Ge ayero sero aune nung eno eyero sena, “Bung, na ago yase.” ");
INSERT INTO zia_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Asenu Petoro mene kapetegairo Yesura buro-mani iwaing nuna-una bautara bautu nenu gigina. Mani awiya gitau Magayao mene awong Daigaina auna bonene mininewa aune Yesura-una nugu baungno ge daweng pugairo atata yero eyero sena, “Tuwa, awe mene ning keregariniye?” ");
INSERT INTO zia_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Mani ayero sena amimene ago bautu nenu giro Petoro mene Yesu atata yero eyero sena, “Tuwa, mani ewiya gire?” ");
INSERT INTO zia_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ayero atata yenu Yesu mene eyero sena, “Nung katu nai, na kepetegairo bari sarinena, nona awiya nina okowa. Ning na ago ye.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Arare ge nigao ena mene ago na eno bisi ge eyero sewa, “Mani awiya nung oko magayariniya.” Ayero sinauwa ara. Arata Yesu mene na eno eyero oko sena, “Nung oko magayariniya.” Ge eyero gege sena, “Nung katu nai na kapetegairo bari sarinena, nona awiya nina okowa.” ");
INSERT INTO zia_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nane nona awiya apakana giro baingtiwang amimene keregairo ge ewiya gaetena. Arare niye na eno eyero gosinowa, ge nana me nibamu. ");
INSERT INTO zia_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu mene tani ena yero nasani nauna. Arata emo mene tani Yesu nasani nauna awiya dekaong-dekaong bukura gayateya, awiya buku mene tawing sero topetiro aung yero yatita nowa. ");
INSERT INTO zia_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O Teofilo, na gitau ge gaewang, awiya buro apakana Yesu mene yero nasani nauna, o ge tugata yero nasani nauna auna ge ungwe awiya gitau buku zora gaewang ara. ");
INSERT INTO zia_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Yesu buro nuna zayero nawe dunu Tuwa Bayau mene senu uritira witina auna ungwe gaero besugaingwa ara. Yesu oko witaore Oweno mene nung soreunu nung aposolo dubu gitau yero naunu nasani nauwa awong eno buro ge pugaina ara. ");
INSERT INTO zia_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nung yaya tapunete magayero nupema seka yero iropuro aposolo dubura-una wari be 40 ayero kasa yero pungyero ayero nasani Tuwa Bayau nata Tuwa yero nariniya auna ge tugata-magata yero nung iropuna auna susuwa dema keregairo baingtinu gigiwa ara. ");
INSERT INTO zia_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nung awong aune dema nasani awong eno ge eyero tugata yena, “Niye Yerusalem napo mena oko yangduwae. Mama mene Oweno pugari sena, awiya diya nasani mitiungpu. Na auna gitau sewang gigiwa. ");
INSERT INTO zia_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Diya mitaese sinena, noeno okowata, Yohane mene emo bauno ou gege susunasani nauna, arata be maingkoka gege aung yai aune Tuwa Bayau mene Oweno niye eno pugariniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Aposolo awong Yesu aune dema augairo mitasani nung atata yero eyero sewa, “Tuwa, ning be eune Isreli emo bauno apakana au dekaongna gasa name naka nametope tawing naname-una maung yero narinenineta?” ");
INSERT INTO zia_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ayero sewa Yesu mene abena eyero sena, “Mama nung putoung nuna mene be imokore apungne pugainu mitoiya, awiya niye nigao ine oko mitiya. ");
INSERT INTO zia_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Arata Oweno mene wosiro ninae-una towai aune putoung pumarineya. Putoung puro bowi sao emo nana yero narineya. Ayero yero Yerusalem nape atu zayero Yudaya tawingnata Samaria tawingna o tawing sero sero auna niye bowi nana puro babarineya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ge ayero sero aune nunae-una ditira atu witina. Wiwitinenu bereze mene nung worero puro witinu kau yewa ara. ");
INSERT INTO zia_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Awong diti ye ika gairo kau newa emo etobe taung wori nunato neyangyaore mene nunae-una atu mena kasa yero dopewato. ");
INSERT INTO zia_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Atu dopero atata yero sewato, “Galilaya tawingna emo, niye noeno diti ye ika uritira gairo mitei? Yesu niye doro uritira witi gigeya deka ayero yero nupema wosariniya.” Ayero sewato ara. ");
INSERT INTO zia_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Aposolo awong diri yazo Oliwa auna atu kapetegairo Yerusalem nape buro toiwa. Nagibo diri yazo Oliwa doro Yerusalem babao awiya apungkaka gege ara. ");
INSERT INTO zia_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Awong Yerusalem nape toiro esewa garo mitauwa deka auna baungno witiwa ara. Atu witiwa auna yazo nunae era: Petoro, Yohane, Yakobo, Anderea, Filip, Tomas, Batolomiu, Matiu, Yakobo nung Alifayora mani, Simon Gewera ayero sinasani nauwa, Yuda nung Yakobora yazo auna mani. ");
INSERT INTO zia_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Emo dubu aune Yesura ai Maria nupema bauno ena aune Yesura metamani, awong amimene dubo dekaongka yero isa buro wari be sero yero nasani mitiwa ara. ");
INSERT INTO zia_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Be aune wari be etobe oko aung yaore Yesura emo bauno 120 amimene augairo mitiwa Petoro mene nunae-una towang atu iropuro eyero sena, ");
INSERT INTO zia_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“O otao mani nana, Yudas nung nai gitau yeti iwo mene Yesu pumeya auna ge nuna Oweno mene Dawidira be pungnu eo yenu ge sena, ge awiya me yaise sao mitiya, arare me yetiya. ");
INSERT INTO zia_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudas nung buro otao nanae zo. Nung dema burora atu naise Yesu mene sero puna ara.” Petoro mene ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Yudas nung pasena yenu zuma gaewa auna moni awiya puro baungno emo zora tawing zuma gaero pungna. Nung tawing auna baungno zuwenu oti bususenu tini yo popore buwaka gainu magayena ara. ");
INSERT INTO zia_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ayero yenu bowi awiya Yerusalem emo bauno mene nigiro tawing auna yazo ge nunae-una Akelidama ayero sewa ara. Ge naname-una Tawing Yu Wosina.) ");
INSERT INTO zia_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Petoro mene eyero sena, “Yere buku nanae yazo Sam auna atu eyero gayao mitiya, Napo nuna zatu kasayaise. Garo nuna-una emo zo oko naise. Ayero zo eyao era, Buro nuna awiya zo mene pumaise. ");
INSERT INTO zia_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ge gayao ayero mitiya, arare emo zo mene nae soremai Yesu magayaora atu seka yero iropumiya auna bowi nuna sinasani nanene. Emo eyao amimene nae soremaise: ");
INSERT INTO zia_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Yohane mene emo bauno ge ou susunenu Tuwa Yesu mene buro nuna zayero naname-una towang atu nasani naunu name nung ago yero nasani nawe duwane uritira witiya, emo zo susuwara atu Yesu ago yero buna amimene kasa yero name soremaise.” ");
INSERT INTO zia_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Petoro mene ayero senu emo etobe tamuwa ara. Zo yazo nuna Yosefe. Ena mene nung Basaba ayero sinauwa, arata ena mene zo Zastas ayero sinauwa. Emo zo yazo nuna Matayas awiya dema tamuwa. ");
INSERT INTO zia_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tauno giro isa eyero sewa, “O Tuwa, ning emora dubo gosinosa, arare emo etobe ewiya nunato-una awe gigesa teng niye, awiya gipe giro ");
INSERT INTO zia_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","aposolo buro Yudas mene yangdotiya awiya pumae. Yudas nung buro awiya yangdoro soma gerao nuna auna babiya.” ");
INSERT INTO zia_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Isa ayero sero vot yewa Matayas mene daigaina. Ayero yewa Matayas nung aposolo 11 aune dema taina ara. ");
INSERT INTO zia_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Iya be baina yazo nuna Pentekos auna be kasa yenu giro Yesura emo bauno apakana garo dekaongka auna atu augairo mitiwa ara. ");
INSERT INTO zia_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mitiwa bewing zo bisi bainakama mene bewing saine yero uritira atu wosiro garo mitiwa auna toiro be buna. ");
INSERT INTO zia_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ayero yenu awong gosinewa nona zo ewawa ine amimene iyao ine yero gagausero emo bauno mitiwa auna emo sero dopero waegaina ara. ");
INSERT INTO zia_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ayero yenu Oweno mene dubo nunae-una toiro be buro ge ewe-pape dubo nunae-una pugaina awiya teng sewa ara. ");
INSERT INTO zia_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Be aune Yuda emo tawing sero sero mene augaora buro Yerusalem atu augairo mitiwa ara. Awong yere sao emo ara. ");
INSERT INTO zia_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Arare awong bewing baina awiya dema nigiro emo bauno apakana ayero buro zimuwa ara. Ziuno wawong di gamuwa. Noeno okowata, aposolo mene ge tawing sero sero auna awiya sinewa nigiwa ara. ");
INSERT INTO zia_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nigiro wawong di gauno iwawa nasani eyero sewa, “Emo dubu ge sineya ewiya Galilaya emo gege. ");
INSERT INTO zia_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Awong nono yero tawing kasa yewangne auna ge benaung giti seseya nigenane gera mamono mene saine nei? ");
INSERT INTO zia_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Name ewiya Patia emo, Midia emo, Ilam emo, Mesopotemia tawingna, Yudaya tawingna, Kapadosia tawingna, Ponto tawingna, Asia tawingna, ");
INSERT INTO zia_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Firizia tawingna, Pamfilia tawingna, Izip tawingna, napo Sairini Libia tawingna mitiya auna napo mamanikakara, name ena mene napo Roma atu esewa yero buro mitenane, ");
INSERT INTO zia_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Yuda emo aune emo ena Yuda emo mene yaine nowa awong aune Krit emo aune Arabia emore. Name amimene nenane ge naname tawing sero sero auna awiya sinasani tani iwawaing Tuwa Bayau mene yero noiya auna bowi ge seseya nigiti nenane ara.” ");
INSERT INTO zia_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Emo awong ayero sewa dubo sisigainu kotumao daigairo puro eyero sewa, “Tani awiya noiye?” ");
INSERT INTO zia_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ayero sewa, arata ena mene zo aposolo dubu izinasani eyero sewa, “Awong ou wain yanakana mineya, arare dubo dau ni ge ayetugao sineya ara.” Ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ayero sewa Petoro nung otao 11 aune dema dopero ge puro zutiyero eyero sena, “O Yuda emo otao mani arita mani Yerusalem nape etu nowa, niye apakana dawong yawero ge sana nigipu. ");
INSERT INTO zia_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Niye emo dubu eeno eyero sineya, ‘Ou wain mininete dau neya.’ Ayero oko sepu. Iya yemeneka gatiniya. Arare ou wain nono yero minari nenine? ");
INSERT INTO zia_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Niye ge sineya auna eno okowata. Tani gosineya auna susuwa awiya eyao era. Porofete Yoeli mene ge eyero gaena awiya me niya. ");
INSERT INTO zia_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Tuwa Bayau mene siniya, Nete tawingna be besugatinai aune na Oweno nana pugana wa sigoru ine yero wosiro emo bauno apakana auna mokora towariniya. Mani emodidire baunodidire ninae mene porofete mene saine yarineya. Mani emodidi ninae mene seka mitasani atiyo yaine yero nona me garineya. Emo kikiyongne ninae mene atiyo me yarineya. ");
INSERT INTO zia_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Be aune na Oweno nana emo bauno nana auna-una pugana awong porofete mene saine yarineya. ");
INSERT INTO zia_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Sana berezera atu tani ena kasa yariniya. Nupema tawingna atu dema tani ena kasa yariniya. Tani awiya yure, iyaore, boingsa bainane amimene kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Wari sikimariniya. Ino yu yero yu ine yariniya. Tani awiya kasayaya aune Tuwara be baina waegaore kasa yariniya. ");
INSERT INTO zia_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Be aune zo nung Tuwa yau sariniya, nung awiya Tuwa mene sorero pumariniya. Yoeli mene ayero gaena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","O Isreli emo otao mani nana, ge sana nigipu. Tuwa Bayau mene Yesu Nasarete emo awiya burora pugaina, awiya gaese sero Tuwa Bayau mene putoung nung eno pugainu ninae-una towang atu nasani buro tau yetugao, tani sekawa aune tani putoungne yero nasani naunu gosinasani nauwa ara. Susuwa awiya gosineya ara. ");
INSERT INTO zia_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Awong Yesu puro wawong ninae-una pugarineya, awiya Tuwa Bayau mene yemaoko ayero yaese senu tau yena. Nupema yemaoko giginu teng yena. Arare nagibo sena teng niye Yesu maga yaise sero emo Yudara sao tau yao ge aung auna waweng pugeya i pasaora deteya maga yetiya ara. ");
INSERT INTO zia_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nung maga yaora yaya tami Tuwa Bayau mene yayara bunao besero maga yaora mokora atu uweti seka yero iropumiya. Noeno okowata, magayao mene nung sorao ine teng oko. ");
INSERT INTO zia_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dawidi mene Sorao Emo naname iropariniya auna ge eyero sena, Tuwa nung benaung nana-una mitoi gosinona. Na awang yoni sero, nung wawong me nana-una dopero mitoiya. ");
INSERT INTO zia_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Arare moko nana mene yawa yawa noi ewawa nana mene yawa yawa yero noiya. Awiya gege okowata, na magayaora gerao amimene Tuwa Bayau tumo didinasani iwaing oregarinena. ");
INSERT INTO zia_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ayero yarinena. Noeno okowata, ititi nana mene magayao napora mitoiye sero, Tuwa Bayau ning na oko duwarinesa. Ning na soumani nina me ewiya oko yangduwasa aingso nana gung yero wuru puro aung yariniya. Aung ara. ");
INSERT INTO zia_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ning nao mera nagibo awiya na eno gipasa. Ning na aune dema mitasa na yawa yawa bainakama yarinena. ");
INSERT INTO zia_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Dawidi mene ayero sena arauwa. O otao mani nana, na ewowo naname Dawidira ge awiya sero baingtana nigipu. Dawidi nung magayenu mutewa biriti nuna naname-una etu mitoiya. ");
INSERT INTO zia_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nung amimene porofete yero nasani nauna, arare nung eyero gigina ara. Tuwa Bayau mene Dawidira saisibuna dubu auna atu zo emo tuwa pugai emo tuwa yaora buro nuna awiya pumaise ge senu tau yena ara. ");
INSERT INTO zia_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tuwa Bayau mene buro yari sena, awiya Dawidi mene gigina. Arare nung Sorao Emo naname iropao nuna-una ge eyero sena, “Tuwa Bayau mene nung oko yangduwai magayao napora atu mitariniya. Taung aingso nuna mene oko gung yero wururu sariniya. Aung ara.” ");
INSERT INTO zia_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesu nung awiya Tuwa Bayau mene uweti seka yero iropumiya, awiya me diti moko nanae mene giro nenane ara. ");
INSERT INTO zia_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Tuwa Bayau Maung nuna-una yumao mene yumi witiro Tuwa Bayaura wawong mera adumi Maung mene Oweno pugari sena, awiya nung eno pugai puro tani nigiti nasani gosineya ewiya yeti kasa yetiya. ");
INSERT INTO zia_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Yesu uritira witiya, ayero Dawidi nung nuka nutope uritira oko witao. Arata nung eyero sena, Tuwa Bayau mene Tuwa nana eno eyero sena, “Ning buro wawong me nana-una atu adungno mitasa ");
INSERT INTO zia_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","na iwo dubu nina awiya benaung nina-una pugana izarinesa.” ");
INSERT INTO zia_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Dawidi mene ayero sena ara. Arare niye Isreli emo apakana amimene eyero gipu tauyae. Niye Yesu i pasaora deteya, nung awiya Tuwa Bayau mene burora pugainu nung Tuwa aune Sorao Emo naname yero noiya ara.” Petoro mene ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Petoro mene ge ayero senu nigiro dubo miniwa ara. Dubo mininasani nung arita aposolo ena awiya atata yero eyero sewa, “Otao mani, nae nono yarinenine?” ");
INSERT INTO zia_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ayero sewa giro Petoro mene eyero sena, “Tuwa Bayau mene pasena ninae disaise niye dubo darawa yero Yesu Kristo tumo diyaya nae niye ge ou suwanene. Ayero yanane Tuwa Bayau mene Oweno niye eno pugariniya ara. ");
INSERT INTO zia_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Niye arita mani awiso ninae arita ena ake atu nowa, awiya Tuwa Bayau naname mene ara taungno yau sinoiya auna teng Oweno niye eno pugari sinoiya ara.” ");
INSERT INTO zia_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petoro mene ge ayero sero aung yero ge ena susuuno sinasani wini ge dema sinasani eyero sena, “Emo memeko-mameko etu nowa amimene pasenana abena tamarineya. Niye awong aune dema abena tamowi sero dubo darawa yepu.” ");
INSERT INTO zia_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Petoro mene ayero senu emo ena ge awiya nigiwa me yena, arare awong awiya ge ou suwewa. Wari be aune emo 3,000 Yesura dubu aune dema taiwa arauwa. ");
INSERT INTO zia_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Aposolo mene Yesura ge tugata nauwa awong nigari arataungno yero nauwa ara. Ayero nasani dubo mene tairo baingtiro bonenena-ta isara awiya ozaung-zaung augati nasani nauwa ara. ");
INSERT INTO zia_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Aposolo awong tani-butani putoungne daigairo nasani nauwa emo bauno apakana amimene wawong di gauno nasani nauwa ara. ");
INSERT INTO zia_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kristo tumo didinasani nauwa amimene dubo dekaongka yero wau nona nunae dubura gege ayero sero nasani nauwa ara. ");
INSERT INTO zia_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ena mene tawingne wau nunae aune awiya emo ena eno pugairo moni puro otao mani ena bogamasa nasani nauwa giro bono yero nasani nauwa ara. ");
INSERT INTO zia_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Awong wari be sero dubo dekaongka yero Tuwa Bayaura ibu bainana atu augati nasani nauwa. Nupema garo nuka nunae sero augairo bonene yero mininasani nauwa ara. Ayero nasani ma maze zo oko sorao dubo mene yawa yawa yero mininasani nauwa ara. ");
INSERT INTO zia_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ayero nasani Tuwa Bayau bowi nasani nauwa. Ayero yewa emo bauno apakana awong giro yawa yawa nasani awong aratamuwa. Tuwa nung be giti emo bauno ena sorero pupunaunu awong dubura una susuuno nasani nauwa arauwa. ");
INSERT INTO zia_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Wari zore Petoroto Yohane ture isa saora be bunu giro Tuwa Bayaura ibu baina auna toiwato ara. ");
INSERT INTO zia_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Toiti newato emo zo aira tiyangna atu asama yao kasayena, awiya diungno puro bumuwa. Emo nung otao mani mene be giti diungno puro baungno ibu baina auna garo bera nugu atu pugati nauwa mitima nauna. Garo be awiya Garo Be Wosewa ayero sinasani nauwa. Atu mitasani emo toiro buwana isona nauwa nona eno isa wowosa sero nasani nauna. ");
INSERT INTO zia_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Arare Petoroto Yohane ibu mokora towari sero newato giro nung nona eno awongto isa sena ara. ");
INSERT INTO zia_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Isa senu awongto nung anuwing nasani Petoro mene eyero sena, “Diti yero nato gi.” ");
INSERT INTO zia_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ayero senu emo asama amimene nona zo pugari sewitota ayero sero awongto yanakana anuwengna. ");
INSERT INTO zia_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ayero nenu Petoro mene eyero sena, “Nato wau moni aung. Arata nona dekaongka mitiya, awiya pugana pumarinesa. Na Yesu Kristo Nasarete napora be nuna-una sinena: iropung, ang yase.” ");
INSERT INTO zia_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ayero sero wawong mera puro ininu iropupunenu te mere mepore auna mugo nunato mena tau yena ara. ");
INSERT INTO zia_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tau yenu nung mena dopero ang yero awongto aune dema ibu baina auna mokora toiwa. Toiro nung sasero-sasero yero ang nasani Tuwa Bayau bowi yena ara. ");
INSERT INTO zia_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Emo apakana mene nung ang nasani Tuwa Bayau bowi nenu gigiwa ara. ");
INSERT INTO zia_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Giro eyero sewa, “Ibu bainana Garo Be Wosewa auna atu mitasani wau moni eno isa wowosa sinoiya, nung ara.” Ayero sero nung iwaing yena awiya giro sopine yero kotumao oko pumao yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Emo amimene Petoroto Yohane saniti nenu emo bauno apakana ibu bainana masi zo yazo nuna Solomonna waranda auna atu sungno awongto ziuno wawong di gauno dopewa ara. ");
INSERT INTO zia_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Emo bauno ayero yewa giro Petoro mene ge eyero sena, “O Isreli otao mani nana, niye nono yero emo ewiya giro wawong di gapunei? Niye nono yero nato yanakana anuwing nei? Nato putoung nanato una, o etutero nao nanato una emo ewiya kora yetenato ang niya, ayero sineita? Aung ara. ");
INSERT INTO zia_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Isaka, aune Yakobo auna Tuwa Bayau, nung ewowo naname auna Tuwa Bayau, nung amimene buro-mani nuna Yesu auna yazo de ika yena. Nung awiya ninae puro pu iwora waweng gaiwa Pilato nung besai babaise senu niye awang sewa ara. ");
INSERT INTO zia_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ayero nasani dubo dangne, o etutero naora maung nung awiya awang sinasani gorobo emo ninae ao-diyaise Pilato dawong ");
INSERT INTO zia_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","gainasani naora maung awiya dewa magayena ara. Arata Tuwa Bayau mene uwenu magayaora atu seka yero iropunu diti moko nanato mene gigiwangto, amaze sinenato era. ");
INSERT INTO zia_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Emo ewiya gosinowa. Nato Yesu tumo didinasani nonato, arare Yesu mene tumo diyao nanato awiya uweti iropuro tau yeti Yesura yazo auna putoung mene emo ewiya kora yeti taung nuna iwaing yeti gosineya. ");
INSERT INTO zia_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Otao mani nana, na niye eno eyero gosinena. Niye arita gitau yao dubu ninae amimene tani yewa auna susuwa oko gosinasani yewa ara. ");
INSERT INTO zia_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Gitau gatau Tuwa Bayau mene Sorao Emo nuna Kristo yaya tapunete magayaise auna ge porofete apakana auna kotumaora pugainu sero gaewa, ge awiya me yena. ");
INSERT INTO zia_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Arare Tuwa Bayau mene pasena ninae disaise sero niye dubo darawa yero Tuwa Bayau aune dema neupu. ");
INSERT INTO zia_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tuwa mene nuna-una atu putoung seka pumaora be pugai bumaise, o Kristo niye eno iyengtari sena awiya iyengtai wosaise niye dubo darawa yero Tuwa Bayau aune dema neupu. Yuda emora Sorao Emo Kristo awiya nung Yesu ara. ");
INSERT INTO zia_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nung amimene yeme uritira atu mitasani be zo diya mitaise sao mitiya, arare atu mitiya. Be aune Tuwa Bayau mene sai tawingna nona apakana nupema sesekawa ine kasa yariniya. Tuwa Bayau mene gitau otu ge nuna awiya porofete dubu nuna gerao auna kotumaora pugati naunu sinauwa ara. ");
INSERT INTO zia_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mose nung ge eyero sena, “Tuwa Bayau mene dubu ninae-una towang atu porofete zo na eyao ine niye eno tamariniya. Nung ge tugata yari niya awiya teng nigipu. ");
INSERT INTO zia_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Zo nung porofete auna ge nigao awang yai giro nung Isreli dubu aune tairo noiye sero, Tuwa mene dai magayariniya.” Mose mene ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ora porofete ena Samuel nauna bautara kasa yero bautunasani nauwa awong apakana amimene be yeme euna ge sero gaewa ara. ");
INSERT INTO zia_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Tuwa Bayau mene nona iwaing pugari sero ge porofetera kotumaora pugati naunu awong keregairo sinauwa, nona awiya ninae pumaese sena ara. Nupema tairo nao Tuwa Bayau mene aya-ewowo ninae eno tauna, auna me niye ara. Tairo nao awiya Abraham eno eyero sinasani tauna, ‘Na saisibuna nina gao yana gao amimene tawing sero sero emo baunona una atu teng yariniya.’ ");
INSERT INTO zia_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Tuwa Bayau mene Mani nuna burora pugati nasani ninae-una gitau bumaise sero iyengtinu wosina, awiya niye apakana gao nasani mekora nagibora atu pumari sero ayero yena ara.” Petoro mene ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petoroto Yohane awongto emo bauno eno ge ayero tugata newato pirisa aune ibura polis auna gitau yao aune Sadukayo emo aune dema nunato una kasa yewa. ");
INSERT INTO zia_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Kasa yero awongto emo bauno eno ge tugata nasani Yesu nung magayaora atu seka yero iropuna arare mamagayao iroparineya, auna bowi keregaiwato gigiwa meko yena ara. ");
INSERT INTO zia_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Gigiwa meko yenu giro awongto saniro ture inu giro bunao gare pugaiwa awiwato. ");
INSERT INTO zia_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Be aune Petoro mene ge tugata yenu nigiwa awong auna ena mene ge awiya nigiro Yesu tumo diro Yesura dubu aune dema susumuwa 5,000 ayao yena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Iya gainu Yudara gitau yao emo aune simai aune sao tauyao ge gipao emo awong amimene Yerusalem nape atu augaiwa ara. ");
INSERT INTO zia_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Pirisa baina yazo nuna Anasi aune Kayafa aune Yohane aune Alesanda aune pirisa bainana didikaing apakana awong amimene awong aune dema augaiwa ara. ");
INSERT INTO zia_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Augairo sewa aposolo etobe augao nunae-una puro bumuwa nunae benaungna atu dopewato atata yero sewa, “Awe mene nito soremi emo asama awiya kora yeteito? Ana-una bera seseyato iwaing yetiye?” ");
INSERT INTO zia_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ayero atata yewa Petoro nung Oweno mene moko nuna be bunu ge eyero sena, “Gitau yao simaire, sana nigipu. ");
INSERT INTO zia_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Nato emo asama zo eno tani iwaing yetenato, aeno, ‘Awe mene nito soremi emo awiya kora yeteito?’ ayero sero koto nasani nato atata neya. ");
INSERT INTO zia_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Arare keregana niye eune Isreli emo bauno apakana amimene nigipu. Yesu Kristo Nasarete napora ninae i pasaora deteya magayetiya, arata Tuwa Bayau mene magayaora atu uweti iropuro niya, putoung nuna-una emo ewiya taung nuna iwaing yeti ninae-una ditira atu dopero mitiya era. ");
INSERT INTO zia_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ge gayao zo mitiya amimene Yesu eno eyero siniya, Garo yao emo niye daba zo gigiwa meko yenu yangduwa ara. Arata daba amimene garo wurura ziwong yero mitoiya. ");
INSERT INTO zia_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yesu nata name kora yao teng niya. Tuwa Bayau mene Yesura yazo emo eno keregaina, arare kora yao emo naname zo tawingna oko mitiya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Petoroto Yohane awongto awang yao aung be nunato eo yenu ge sewato, emo koto newa amimene nigiro awongto nigao gare oko towao, awongto emo wosao gege, awiya giro sopine yero wawong di gamuwa. Awongto Yesu aune dema nasani nauwato awiya gigiwa. ");
INSERT INTO zia_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nupema emo kora yewato amimene nunato una nugu atu dopero mitinu awong nung giro ge abena sao awang yero ");
INSERT INTO zia_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","awongto sewa wosi kakame yewato nuka nuyetope eyero wina-se yewa, ");
INSERT INTO zia_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Name emo etobe nono yari nenine? Awongto tani putoungne ewiya yeteyato kasa yeti Yerusalem napo mene bowi ewiya nigiro aung yeteya, arare name tani nunato bewae yao ine teng oko. ");
INSERT INTO zia_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Arare ge ewiya napo sero babai nigowi sero, sanane emo auna yazora nupema oko emo bauno eno ge tugata yaeto.” ");
INSERT INTO zia_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ayero sero aune awongto sewa witiwato eyero sewa, “Nito Yesura yazora nupema oko ge tugata-magata yaeto.” ");
INSERT INTO zia_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ayero sewa, arata Petoroto Yohane mene ge abena eyero sewato, “Niye nika niyetope kotungno gipu. Ge ninae dipunasani Tuwa Bayaura ge awang sanato Tuwa Bayau mene gai teng yarinita? Aungwa. ");
INSERT INTO zia_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ge nigiwangto, o nona gigiwangto awiya nato pungyero puro nao ine teng oko niya.” ");
INSERT INTO zia_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ayero sewato awong awang saora ge nupema sinete awongto yangduwa bamuwato ara. Napora emo bauno apakana mene tani yewato awiya giro Tuwa Bayau bowi newa giro awong emo bauno awang nasani awongto eno taung yaya zo pugaora nagibo kau yewa ara. ");
INSERT INTO zia_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Emo kora yewato awiya nung asama yero mitawe dunu dawang 40 ayero aung yena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Awong Petoroto Yohane yangduwa awongto augaora atu baungno otao mani taungno pirisa babuze aune simai amimene ge awongto eno sewa auna ungwe-maungwe yero besu gaiwato. ");
INSERT INTO zia_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ayewato awong ge awiya nigiro dubo nunae dekaongka yero Tuwa Bayau eno pugairo eyero sewa, “O Tuwa bainakama, ning uritire tawingne witore nona apakana aune dema yasa. ");
INSERT INTO zia_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Arare nine sasa Oweno mene ewowo nanae Dawidi nung soumani nina auna be punu eo yenu ge eyero sena, Emo Yuda oko awong Tuwa eno tini kapao puro nasani tini kapao nunae auna susuwa kasa yaise yero tetere yero nowa. Emo dubu giti Tuwa gera yari sero kaputinowa. ");
INSERT INTO zia_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tawing sero serora emo tutuwa amimene Tuwa Bayau aune Sorao Emo nuna Kristo awongto iwo yari sero ziuno dopewa ara. Emo babuze amimene awongto iwo yari sero augaiwa ara. ");
INSERT INTO zia_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ge Dawidi mene gaena, ge awiya napo euna atu me yena. Herodeto Pontias Pilato awongto emo Yuda oko aune Isreli emo awong aune dema Mani nina Yesu, nung buro nina-una gerao, nung awiya iwo yari sero augaiwa ara. Nung awiya Sorao Emo nanae yaise sasa. ");
INSERT INTO zia_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ayero yaya nina-una teng yarinita, awiya oko sao yewa. Arata putoung nina mitiya, arare kasa yaise sinosa teng kasa yero noiya. Aeno tani kasa yaise sasa, auna teng yewa ara. ");
INSERT INTO zia_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","O Tuwa, ge nina awang sineya auna susuwa gosinasani buro-mani dubu nina nae eno putoung pugasa ge nina awang yao aung tau yero sanene. ");
INSERT INTO zia_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Putoung nina gipasa gaese sero emo bauno yayare kora ye. Nupema Yesu nung buro-mani nina dang auna bera tani putoungne yanene.” ");
INSERT INTO zia_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Isa ayero sewa garo augairo mitiwa awiya youto-youto yenu Oweno mene awong sero topetinu awong awang yao aung tau yero Tuwa Bayaura ge emo bauno eno tugata yari zayewa arauwa. ");
INSERT INTO zia_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Yesu tumo didinasani nauwa amimene dubo kotumaore dekaongka yero nasani nauwa. Ayero nasani wau moni nunae awiya ninawa nanawa oko sao, dubura gege ayero sewa mitauna ara. ");
INSERT INTO zia_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aposolo mene Tuwa Yesu magayaora atu seka yero iropuna auna bowi ge putoungne sinauwa emo bauno nigiti nasani nauwa Tuwara soremao bainakama nunae-una atu mitauna ara. ");
INSERT INTO zia_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nunae-una zo mene bogamasa oko yero nauna. Emo tawingne ibu niyangne nasani nauwa amimene nona nunae awiya emo ena eno pugairo abena moni puro ");
INSERT INTO zia_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","moni awiya aposolora waweng pugati nasani nauwa. Ayero nasani nauwa aposolo mene emo wau moni kau yero nasani nauwa awiya teng moni bono yero pugati nauwa pupu nasani nauwa ara. ");
INSERT INTO zia_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Be aune emo zo nasani nauna yazo nuna Yosefe. Aposolo awong yazo nuna zo Banaba ayero sewa. Ge naname-una Onggo sero korayao emo. Nung Lewira saisibuna auna zo. Nung Saipras gutura atu kasa yena ara. ");
INSERT INTO zia_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Emo amimene tawing garawi nuna emo ena eno pugairo moni pugaiwa awiya apakana puro aposolora waweng pugaina arauwa. ");
INSERT INTO zia_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Emo zo nasani nauna yazo nuna Anania. Nung aro nuna Safairato ge ungwe yero tawing nunato emo eno pugaiwato abena moni pugaiwa pumuwato ara. ");
INSERT INTO zia_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Awongto ge sero tiro emo mene moni agewa pung yero agewa gege aposolora waweng pugaina ara. ");
INSERT INTO zia_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pugainu Petoro mene atata yero sena, “Anania, Sanda mene dubo nina topetiro Oweno etegati nasani tawing nina-una zuma agewa pung yasese sesi noeno nigiro deka ayero yari yetesi? ");
INSERT INTO zia_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tawing nina mitaise sero giro yangduwasa mitatiya. Nupema emo ena eno pugairo moni pumesa, awiya nine gege moni maung nesa. Ning noeno tani awiya yari kotumesi? Ning emo okowata, Tuwa Bayau etegesa ara.” ");
INSERT INTO zia_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ayero senu Anania mene ge awiya nigiro zuwero magayena ara. Ayero yenu ena mene bowi awiya nigiro awang bainakama yewa. ");
INSERT INTO zia_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Magayenu mani seka mitiwa amimene iropuro taung aingso nuna mo mene dowero puro baungno mutewa ara. ");
INSERT INTO zia_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ayero yewa 3 aua ayao aung yenu aro nuna mene tani kasa yena awiya oko gaoware garo auna atu toina ara. ");
INSERT INTO zia_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Garo auna atu toinu Petoro mene atata yero sena, “Gire, nito tawing pugeyato zuma pugeya pumeyato, awiya deka ke eri?” Ayero atata yenu bauno mene eyero sena, “Deka ka ara.” ");
INSERT INTO zia_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ayero senu giro Petoro mene abena eyero sena, “Nito noeno Tuwara Oweno gaero gari sero ge dekaongka seseito? Yu nina muteteya mani dubu awiya yemeneka garo be bautara dopero miteya. Arare awong ning deka ayero puro baungno mutarineya.” ");
INSERT INTO zia_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ayero senu bauno amimene zuwe te nuna-una nugu gairo magayena ara. Magayenu mani seka dubu amimene toiro aro magayenu giro puro baungno yu mutewa deka auna atu mutewa ara. ");
INSERT INTO zia_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Arare Yesura dubu aune emo bauno ena dema bowi nunato awiya nigiro awang bainakama yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposolo mene tani putoungne daigairo emo baunona una towang atu yero nasani nauwa. Awong apakana dubo dekaongka yero Tuwa Bayaura ibu baina auna agewa zo yazo nuna Solomonna waranda auna atu augati nasani nauwa ara. ");
INSERT INTO zia_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Augati nauwa emo ena mene awong aune tairo nao awang nauwa. Arata emo bauno daigairo mene awong giro aratapu nasani yawa yawa nauwa. ");
INSERT INTO zia_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Arare emore baunone daigairo nibamu amimene Yesu tumo diro nuna-una susuuno nasani nauwa ara. ");
INSERT INTO zia_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Aposolo mene tani putoungne nasani nauwa giro ena mene otao mani nunae yayare awiya nagibe atu masi zuwero masi auna atu pugati nasani eyero sinauwa, “Eyero etu mitaya Petoro mene nagibe etu puma-sauma nasani awong giro kora yaise. Nung wawong mene oko kora yao yariniya, awiya utung nuna mene enana-una suwayai iwaing yaese.” Ayero sero nauwa ara. ");
INSERT INTO zia_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Napo mamanikaka Yerusalem ziuno mitauwa auna emo bauno daigairo mene aposolora una buro augati nasani otao mani nunae yayare iwae mokora mitao aune dema puro buro nauwa kora yero nauwa iwaing yero baungno nasani nauwa arauwa. ");
INSERT INTO zia_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nona ayero kasa yenu giro pirisa babuze aune emo nung aune dema mitasani nauwa, awong Sadukayo dubura, awong amimene aposolo dubu eno kotumao meko puro awong iwo yewa ara. ");
INSERT INTO zia_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ayero nasani aposolo dubu saniro puro bunao gare pugaiwa. ");
INSERT INTO zia_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ayero yewa awinewa pingne Tuwara angelo zo mene garo be apero awong yuno puro wosiro eyero sena, ");
INSERT INTO zia_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Niye ibu bainana atu toiro emo bauno apakana aeno nao sekawara bowi ge keregairo baingtiti nasani neupu.” ");
INSERT INTO zia_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ayero senu awong nigiro gora gara ibu bainana atu toiro ge tugata yewa ara. Pirisa baina arita emo dubu nuna amimene au dekaongna gairo gitau yao dubu arita Isreli emo babuze apakana awiya yau sewa buro augaiwa ara. Augairo polis baungno bunao gare atu aposolo puro bumaese sewa. ");
INSERT INTO zia_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ayero sewa polis mene baungno bunao gare atu kau yero giro yesese yero buro eyero sewa, ");
INSERT INTO zia_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nae baungno garo be gazao miti gigenane. Nupema diya awong garo be diya nasani dopero miteya. Arata nae garo be apero toiro emo kau yetenane.” ");
INSERT INTO zia_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ayero sewa ibu bainana polis auna gitau yao aune pirisa babuze amimene gigiwa teng oko yao yenu, “Tani ewiya nono yero besugariniye?” ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ayero sinewa emo zo mene kasa yero eyero sena, “Bunao gare pugeya awiya awong ibu bainana mokora atu ge tugata neya ora, gipu.” ");
INSERT INTO zia_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ayero senu polisra gitau yao amimene dubu nuna puro baungno aposolo dubu keketero yuno puro bumuwa. Awiya emo bauno mene aposolo dubu eno polis daba mene dowi sero iwo yanakana oko yao etutero puro bumuwa arauwa. ");
INSERT INTO zia_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Awong aposolo puro baungno augaora pugaiwa gitau yao dubura benaungna atu dopewa pirisa baina mene ge eyero sena, ");
INSERT INTO zia_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Niye emo auna yazora emo bauno ge tugata yao awang sinenane. Arata niye ge awiya nupema Yerusalem atu tugata yeteya emo bauno pu sino apakana nigeya. Ayero nasani emo Yesu dewa auna pasena awiya nae eno pugari sero neya.” ");
INSERT INTO zia_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ayero senu Petoro aposolo ena aune mene abena eyero sewa, “Emora ge dipunasani Tuwa Bayaura ge awang sao ine oko mitiya. ");
INSERT INTO zia_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ninae Yesu i pasaora dewa magayena, nung awiya ewowo naname una Tuwa Bayau mene uwenu seka yero iropuna ara. ");
INSERT INTO zia_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Iropunu Tuwa Bayau mene sorero nuna-una wawong mera pugairo Gitau Yao Emo, o Sorao Emo naname pugaina. Isreli emo name dubo naname darawa yanane pasena naname disari sero ayero yena ara. ");
INSERT INTO zia_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Auna bowi awiya nae sinonane Oweno deka ayero dema sinoiya. Oweno awiya Tuwa Bayau mene ge nuna dipunowa awong aeno pugati noiya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Aposolo mene ayero sewa nigiro tini kapenu kotumao meko puro aposolo dari sewa ara. ");
INSERT INTO zia_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Dari sewa, arata augao nunae-una atu Farisayo zo mitina, yazo nuna Gameliel. Nung sao tauyao ge gipao emo zo. Emo bauno apakana mene yazo nuna de ika gatinasani nauwa. Nune iropuro polis mene aposolo puro wosiro kakame yaya be maingkokaka atu mitaese senu wosiwa aune nung ");
INSERT INTO zia_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","otao mani nuna eno eyero sena, “Isreli otao mani nana, niye emo awiya iwo yari sero giro kotungno baingtiro aune yepu. ");
INSERT INTO zia_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Gitau emo zo yazo nuna Tiudas amimene kasa yero eyero sena, ‘Na putoung bainakama nana-una mitiya.’ Ayero senu emo 400 mene nung ago yero bamuwa ara. Arata nung iwo mene dewa magayenu dubu nuna zanewa buro nunae aung yena ara. ");
INSERT INTO zia_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nupema gavman mene emo baunona yazo gainewa be aune Galilaya tawingna emo zo yazo nuna Yuda amimene kasa yero nasani nauna. Nune emo ena yunu nung ago nasani nauwa. Ayero yenu nung dewa magayenu dubu nuna zanewa ara. ");
INSERT INTO zia_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Arare na emo eeno ge eyero sana nigipu. Niye emo dubu ewiya iwo oko yae. Dopu nae. Ge tugata yero nowa, o buro yero nowa, awiya kotumao nunae-una yarineya, awiya yangduwaya wosiro aung yariniya. ");
INSERT INTO zia_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Orata buro yero nowa awiya Tuwa Bayaura kotumaora yero yarineya, awiya ninae awong kaputari neya. Niye buro nunae sisigati nasani Tuwa Bayau iwo yaneya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ge ayero senu nigiwa teng yenu aposolo yau sewa witi augaora yewa waung mene dewa. Dero Yesura yazo bowire auna ge nupema tugata yowi sero, awang sero iyengtiwa bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Iyengtiwa Tuwa awong eno giginu teng yenu awong yazo nuna eno waung pumuwa auna yawa yawa nasani augaora atu wosiro bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Arare awong wari be giti ibu bainana atuta ibu niyang enana atu Yesu Kristora Bowi Iwaing oko yangduwao tugata-magata yero nasani nauwa arauwa. ");
INSERT INTO zia_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Be aune emo bauno daigairo mene Yesu tumo diro nuna-una susumuwa dubu baina yena. Awong ena mene Grik ge sinasani nauwa, ena mene Yuda ge sinasani nauwa. Awong wari be sero nona minaora moni kapero bono yero nasani nauwa ara. Ayero nauwa Grik ge sao emo amimene Yuda ge sao emo eno kotumao meko puro eyero sewa, “Niye taung sogayaora moni bono yero nasani bauno ibono mamaga yetugao nanae yangdoti nowa.” ");
INSERT INTO zia_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ayero sewa aposolo 12 mene Yesura dubu apakana yau sewa augaiwa eyero sewa, “Nae taungna buro soga yero nasani Tuwa Bayaura ge tugata yao auna buro awiya yangduwanane wosai teng oko yariniya. ");
INSERT INTO zia_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Arare otao mani, niye emo 7 ninae-una towang atu taungpu. Emo Oweno mene nuye topetiro noiya, o emo kotumao iwaingne, o emo emo bauno ena mene giro aratapu nowa, emo 7 ayao ine awiya taungpu. Ayero yaya buro awiya sanane naya ");
INSERT INTO zia_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","nanae mene zo isa burore ge tugata yaora buro awiya nanene.” ");
INSERT INTO zia_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ge ayero sewa dubu mene nigiwa teng yenu, emo ewiya tamuwa: Stiwen, nung tumo diyao bainakama. Oweno mene nuna-una be buro mitasani nauna. Otao mani nuna ena awiya Filip aune Prokoro, Nikano, Timon, Pamena, Nikola, nung Antiok napora emo. Nung Yuda emo me okowata, nung Yuda emo mene yaine yero nasani nauna. ");
INSERT INTO zia_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Emo dubu awiya tamuwa awong aposolo dubura una nugu atu dopewa isa sero wawong ziye pugairo gao yewa ara. ");
INSERT INTO zia_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ayero yewa Tuwa Bayaura ge wisika sero bautunenu Yerusalem atu emo bauno daigairo mene Yesura dubu aune dema susumuwa. Aune pirisa dubura una daigairo mene Yesura ge nigiro dipunasani nauwa arauwa. ");
INSERT INTO zia_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Tuwa Bayaura gaore putoungne Stiwenna una mitauna, arare nung emo baunona benaungna atu tani putoungne ena nauna ara. ");
INSERT INTO zia_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Arare Yuda emo ena iropuro Stiwen aune dema ge wina-se yewa. Yuda emo eyao emimene nung aune dema ge wina-se yewa: Dubu zo yere ibu nunae auna yazo nuna Emo Souyao Burora Bunao Aung auna Ibu ayero sinauwa, awong auna emo ena aune Sairini emo ena, Alesandria emo ena, Silisia emo ena aune Asia emo ena awong amimene au dekaongna gairo Stiwen aune ge wina-se yewa. ");
INSERT INTO zia_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ayero yewa Oweno mene kotumao iwaing Stiwen eno pugainu ge me gege sero baungnu ge nunae ge iwao yena ara. ");
INSERT INTO zia_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nung awong ayero daigainu giro awong emo ena taungno ge iwaese sewa giro awong Stiwen eno eyero sewa, “Stiwen nung Moseto Tuwa Bayau izinasani ge meko awongto eno sesi nigenane.” ");
INSERT INTO zia_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ayero sinasani emo bauno aune simai aune sao tauyao ge gipao emo auna dubo uwewa ara. Ayero yewa awong baungno Stiwen saniro puro gitau yaora augao auna bamuwa ara. ");
INSERT INTO zia_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Puro baungno ge iwao ge saya gitau yao mene gaya me yaise sero ge iwao kotumao ena otao mani nunae eno pugaiwa. Arare awong kotora atu ge iwinasani Stiwen eno eyero sewa, “Emo emimene ibu baina naname aune sao tauyao ge naname awiya izinasani noiya. ");
INSERT INTO zia_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Eyero sesi nae nigenane, ‘Yesu Nasarete napora amimene ibu baina ewiya dero kasariniya. Ayero nasani tani Mose mene yanenese sero gaena awiya yangdoro tani zo yanenese pugariniya,’ asesiya.” Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ayero sewa emo dubu augaora mitiwa amimene Stiwen anuwing nasani benaung nuna gigiwa angelora benaung ine yena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Pirisa baina mene Stiwen atata yero eyero sena, “Ge sineya ewiya ge me ing?” ");
INSERT INTO zia_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ayero senu Stiwen mene abena eyero sena, “O otao mani aune gitau yao nana, ge sana nigipu. Ewowo naname Abraham nung Heran napo auna oko babao Mesopotemia tawingna katu nenu aune Tuwa Bayau waegaore amimene kasa yero nung eno eyero sena, ");
INSERT INTO zia_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Ning tawing susuwa nina arita dubu nina awiya yangdoro nane tawing zo giparinena auna baungno narinesa.’ ");
INSERT INTO zia_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ayero senu nung ge awiya nigiro tawing nuna Kalidia awiya yangdoro Heran nape baungno nasani nauna ara. Atu nenu maung nuna magayenu aune Tuwa Bayau mene tawing auna atu yuno puro bung tawing name yeme nenane euna yena. ");
INSERT INTO zia_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Puro buro tawing oko diriye gainu nuna yena. Aung ara. Agewa zo za nung eno oko pugao yena. Nung aune saisibuna nuna aune mene ago topetaese senu tauyena. Awiya nung mani aung nauna be aune Tuwa Bayau mene ayero senu tauyena ara. ");
INSERT INTO zia_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Tuwa Bayau mene ge zo nung eno eyero sena, ‘Saisibuna nina mene tawing sekawa zora baungno esewa ine yero nasani sou buro gege yero nasani dawang 400 ayao atu yayara tame narineya ara.’ ");
INSERT INTO zia_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nupema nung ge zo susuuno eyero sena, ‘Sou buro yaese sero pumarineya, emo awiya abena pugana saisibuna nina yangduwaya tawing awiya yangdoro tawing euna buro na bowi yero nasani narineya.’ Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Tuwa Bayau mene ayero sero awong nung aune dema tayaese sero tairo nao nuna Abraham eno pugairo tayao awiya daung mokera mitaise Abraham aune dubu nuna aune mene tani taung aingso kapao awiya puro naese sena. Arare mani nuna Isaka kasa yero mitinu wari 8 aung yenu Abraham mene maingna taung aingso kapena. Deka ayero Isaka mene Yakobo kasa yenu taung aingso nuna kapena, nupema Yakobo mene ewowo naname 12 kasa yero nasani nauwa auna taung aingso nunae awiya kapena ara. ");
INSERT INTO zia_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Arare ewowo naname mene maingkoka nunae Yosefe eno kotumao meko puro moni eno emo enana waweng pugaiwa puro baung Izip tawingna yewa sou buro nasani nauna. Atu baungno naunu Tuwa Bayau mene nung aune dema nasani nauna. ");
INSERT INTO zia_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Nasani Yosefe dubo minaora atu sorero puro kotumao iwaing pugainu Izip emo tuwa Fero mene giginu iwaing yenu giro ibu niyang nuna aune napo aune emo aune awiya diya naise emo tuwa pugaina ara. ");
INSERT INTO zia_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Pugainu naunu Izip tawingna o Kenan tawingna atu dora botiyo bainakama kasa yenu soma apakana nona aung yena. Ayero yenu aya-ewowo naname meri magayero nona minao kau nasani nauwa. ");
INSERT INTO zia_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Arare Yakobo mene ‘Izip tawingna atu ma mitiya,’ ayero sewa nigiro giro mani awiso nuna iyengtinu atu bamuwa. ");
INSERT INTO zia_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ago awong Izip tawingna nupema bamuwa Yosefe mene susuwa nuna awiya tatomani nuna eno keregaina. Ayero yenu Fero nung deka ayero Yosefera dubu gigina. ");
INSERT INTO zia_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Arare Yosefe mene maung nuna Yakobo aune dubu nuna apakana emo bauno 75 awiya yau sena ara. ");
INSERT INTO zia_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yau senu Yakobo dubu nuna aune Izip tawingna baungno mitawe magayenu aya-ewowo naname deka ayero mamagayero aung yewa ara. ");
INSERT INTO zia_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Magayewa wetu nunae puro kapetegairo baung Sikem nape yewa ara. Gitau Abraham mene Sikem nape Heimora saisibuna auna tawing zo biritira gerao ayero sero moni mene zuma gaena auna atu mutewa ara. ");
INSERT INTO zia_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ge Tuwa Bayau mene Abraham eno sena awiya me yaora be nugu nenu awong Izip tawingna atu daigairo wisika sewa. ");
INSERT INTO zia_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ayero nasani newa Izip emo tuwa seka zo kasa yena. Nung amimene Yosefera susuwa oko gosinasani aeno ");
INSERT INTO zia_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","aya-ewowo naname etegairo gera-gaira nauna. Ayero nasani senu awong mani wuire nunae magayaese sero augairo yangdoti nauwa. ");
INSERT INTO zia_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Be auna atu Mose kasa yena. Nung mani emodi benaung iwaing nibamu ami kasa yenu giro ai maungne mene gare atu pungyero puro mitawe duwato ino etama aung yena ara. ");
INSERT INTO zia_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ino etama aung yenu aune nung magayaise sero augaiwa Ferora mani baunodi mene taungno mani nuna ayero sero puro diya yenu baina. ");
INSERT INTO zia_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ayero yenu Ferora gipao emo mene Izip emora nigao awiya apakana gipewa giro o nigiro ayero yero buro naunuta sinauna awiya iwaing gege nauna arauwa. ");
INSERT INTO zia_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Arare Mose nung nawe emo yenu dawang nuna 40 ayao yenu Isreli emo otao mani tatomani nuna gari sero baungna. ");
INSERT INTO zia_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Baungno Izip emo zo mene Isreli zo dedunenu giro otao nuna sorero Izip emo abena denu magayena. ");
INSERT INTO zia_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ayero nasani eyero kotuna, ‘Dubu nana Ferora wawengna atu sorero panese Tuwa Bayau mene buro niya, awiya garineya.’ Ayero kotuna, arata awong oko gigiwa. ");
INSERT INTO zia_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ayero yenu iya gainu Isreli emo etobe wina-de newato nung baungno taungno kasugati nasani eyero sena, ‘Nito dubu dekaongka amimene noeno iwo wina-ye neito?’ ");
INSERT INTO zia_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ayero senu emo winade zayero otao nuna dena amimene Mose musugairo ge abena eyero sena, ‘Ning emo tuwa nanae ing? Ning diya awe mene pugainu? ");
INSERT INTO zia_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Sipe ning Izip emo zo detesa, deka ayero na dari sinesita?’ ");
INSERT INTO zia_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ge ayero senu Mose mene ge awiya nigiro giro awang yero baungno Midian tawingna emo enana towang atu esewa ine yero nasani nauna. Atu nawe bauno atiro mani emodi etobe pungna arauwa. ");
INSERT INTO zia_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Atu nawe dunu dawang 40 aung yenu aune baungno eu yanawira yero diri Sinai auna susuwara atu nenu i mamanikaka mitiwa auna zora atu iyao awinenu iyao mokora atu angelo zo mene kasa yena. ");
INSERT INTO zia_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ayenu Mose nung iyao awiya nono yero kasa niye, awiya gane, ayero sero nugu baungnu Tuwara ge eyero kasa yena, ");
INSERT INTO zia_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Na aya-ewowo ninae-una Tuwa Bayau. Na Abrahamto Isaka aune Yakobo auna Tuwa yero mitona.’ Ayero senu Mose te-wawong ipenu awang nasani diti ye agao awang yero dopena. ");
INSERT INTO zia_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Dopenu Tuwa mene eyero sena, ‘Tawing papatinesa awiya dang ara, arare te nina-una soga dutugai. ");
INSERT INTO zia_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Emo mani nana Izip tawingna atu dero kaputinowa zire-buware yero nowa awiya diti ye enaka gairo gigena. Arare na awong sorero pumari sero wowosinena ara. Arare ning iropung. Izip tawingna iyengtana nupema babarinesa.’ Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Arare Isreli emo awong Mose awang sero eyero sewa, ‘Ning awe mene emo tuwata diya nanae pugainu?’ Emo awang sewa deka awiya Tuwa Bayau mene emo tuwa o sorao emo nunae yaise sero angelo nuna iyengtinu iyao mokora atu kasa yero buro ge awiya sena. ");
INSERT INTO zia_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Angelo amimene nung soreunu tauyero burora baungno Izip tawingnata Wito Yuyaora atu tani putoungne nasani Isreli emo bauno yuno puro buna ara. Nung awong puro eu yanawira atu nasani tani putoungne yero nasani nawe dunu dawang 40 aung yena. ");
INSERT INTO zia_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mose mene Isreli emo eno ge eyero tugata yena, ‘Tuwa Bayau mene ninae-una towang atu porofete zo na ine niye eno tamariniya.’ ");
INSERT INTO zia_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ayero sena ara. Mose mene tawing towang atu Isreli emo bauno nasani nauwa aune dema nasani nauna. Nung aya-ewowo naname aune dema naunu aune angelo zo mene nung aune dema nauna. Angelo amimene Sinai diri atu nung eno ge mitao gege mitoiya awiya senu nigiro ganenese sero gaena ara. ");
INSERT INTO zia_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Aya-ewowo naname mene Mosera ge nigao awang sero Izip tawingna kapetegari sero dubo nunae baung Izip tawingna yena. ");
INSERT INTO zia_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ayero yenu awong Aron eno eyero sewa, ‘Ning ititi ena yasa tuwa naname ayero sanane ititi amimene name gitau yaya babanene. Mose name Izip tawingna atu yuno puro buna nung magayetita nono yetiye, awiya name oko gosinenane.’ Ayero sewa ara. ");
INSERT INTO zia_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ayero sero ititi zo bulimakao mani ine yero zawing pugati nasani tuwa ge iwao wawong mene yewa auna bonene yero mininasani yawa yawa yewa. ");
INSERT INTO zia_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tani awiya yewa giro Tuwa Bayau mene awong doro pasena nunae-una abena tamaese senu dubo nunae sisigairo inone arasare bowi yero nasani nauwa. Arare porofetera bukura atu ge eyero gayao mitiya, Isreli dubu, niye dawang 40 ayao eu yanawira atu nasani wore zawingne igiti nasani nauwa awiya na eno igiti nasani nauwita? Aung ara. ");
INSERT INTO zia_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Niye tuwa ge iwao yazo Molak auna yere ibu seli mene yao awiya diungno puro puma-sauma yero nasani nauwa. Niye tuwa ge iwao zo yazo Refan auna arasara ititi puro nasani nauwa. Niye nona awiya bowi yari sero wawong mene yewa ara. Arare na niye napo Babilon auna bautara atu pugana narineya arauwa. ");
INSERT INTO zia_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Aya-ewowo naname mene eu yanawira atu seli ibu puro nasani nauwa. Seli ibu amimene ‘Tuwa Bayau etu mitiya’ awiya keregati nasani nauna. Tuwa Bayau mene Mose eno seli ibura ititi gipinasani deka ayero yaese senu teng yewa ara. ");
INSERT INTO zia_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Seli ibu awiya aya-ewowo naname mene susuunota susuuno anasani puro butunawe duwa Yosua mene gitau yenu atu Tuwa Bayau mene emo dubu ena dero tunenu bamuwa. Arare aya-ewowo naname mene dubu enana tawing awiya puro mamono yero seli ibu nunae puro atu pugaiwa mitawe dunu Dawidi kasa yena. ");
INSERT INTO zia_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawidi kasa yero naunu Tuwa Bayau mene nao nuna giginu iwaing yena. Arare Dawidi mene Tuwa Bayau Yakobo mene bowi nasani nauna auna mitao masi tamari sero Tuwa Bayau isa sena. ");
INSERT INTO zia_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ora Solomon mene Tuwa eno ibu yena. ");
INSERT INTO zia_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Arata Tuwa Bayau nung dang mitoiya amimene ibu emora wawong mene yao auna atu mitao masi oko yero noiya. Ge porofete zo mene sero gaena awiya eyero gayao mitiya, ");
INSERT INTO zia_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Tuwa mene eyero siniya, ‘Uriti awiya adumao masi simaore nana ara. Tawing mene zo te guto yao nana. Garo nana nono yao yaya teng yariniye? Nupema mitao-masi nana nono yao tamaya teng yariniye? ");
INSERT INTO zia_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Na wawong nana mene nona apakana oko yewang ayero sineita? ");
INSERT INTO zia_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Niye ge dao emo. Dubore dawongne ninae oko zawagao diga emora ine. Aya-ewowo ninae nasani nauwa deka ayero nasani Owenona ge dimao awang sinowa. ");
INSERT INTO zia_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Aya-ewowo ninae mene porofete apakana oko ao-diyao yaya pugaiwa ara. Dangna Maung kasa yaise ge gitau sewa emo dubu awiya dema dewa magayewa. Arare kasa yenu niye nung awiya magayaise sero keregairo dewa ara. ");
INSERT INTO zia_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tuwa Bayaura sao tauyao ge angelora be mene sao awiya niye puro oko dimao yewa.” ");
INSERT INTO zia_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Stiwen mene ge ayero senu Yudara gitau yao emo mene nigiro tini kapao bainakama pumuwa. ");
INSERT INTO zia_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Arata Stiwen nung Oweno mene nung bebunu ditiye uritira gairo Tuwa Bayaura waegao gosinasani Yesu Tuwa Bayaura wawong mera atu dopero mitinu giro eyero sena, ");
INSERT INTO zia_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Na uriti be gausesi Emora Mani Tuwa Bayaura wawong mera atu dopero miti gosinena.” ");
INSERT INTO zia_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ayero senu ge beti nasani dawong awena wawong mene zuzero apakana iropuro buro nung saniwa ara. ");
INSERT INTO zia_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Saniro puro baungno napo bautara atu daba mene dewa. Ayero nasani emo Stiwen eno ge iwao ge sewa amimene taung wori nunae dutugairo mani zo yazo nuna Saulo auna nugu atu gurutu yewa. ");
INSERT INTO zia_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ayero yero Stiwen daba mene dedunewa isa sinasani eyero sena, “O Tuwa Yesu, ning ititi nana pung.” ");
INSERT INTO zia_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ayero sero boma gaero wawa sero eyero sena, “Tuwa, pasena nunae ewiya dise.” Ayero sero magayena. Dewa magayenu Saulo mene giginu iwaing yena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Be dekaongka aune Yerusalem nape atu Yesura dubu eno gera iwo bainakama zayewa. Ayero yewa awong zanero Yudaya tawingna, o Samaria tawingna bamuwa. Aposolo dubu mene gege oko zanao Yerusalem katu nasani nauwa. ");
INSERT INTO zia_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Emo ena Tuwara gera nasani nauwa amimene Stiwen mutero zire buware bainakama yewa ara. ");
INSERT INTO zia_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Arata Saulo mene zo Yesura dubu gera-gaira nasani garo sero witiro emore baunone dero watiuno puro baungno bunao gare pugaina arauwa. ");
INSERT INTO zia_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yesura dubu zanewa amimene napo sero nasani Tuwara ge tugata nasani nauwa. ");
INSERT INTO zia_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Nunae-una zo Filip mene Samaria emora napo gitau yao auna kasa yero Kristora Bowi Iwaing awiya tugata yena. ");
INSERT INTO zia_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Tugata yenu emo bauno dubu bainakama mene ge nuna nigiro tani putoungne awiya giro dawong yawero ge nuna nigiro baingtiwa. ");
INSERT INTO zia_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nung iwae daigairo tunenu wawa sero emora mokora atu kasa yero zanero bamuwa. Nung asama yetugatigao aune te wawong amao awiya dema kora yenu iwaing yewa. ");
INSERT INTO zia_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ayero yenu napo auna atu yawa yawa bainakama kasa yena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Arata napo dekaongka auna atu emo zo nasani nauna yazo nuna Simon. Nung goe isika yao emo. Arare nung nuka nutope “Na emo bainakama” ayero sero goe isika buro yero naunu Samaria emo bauno mene gosinauwa nung emo yazore yero nasani nauna. ");
INSERT INTO zia_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Arare emo witaota wosao apakana amimene dawong yawero ge nuna nigiti nasani eyero sinasani nauwa, “Emo ewiya Tuwa Bayaura putoung bainakama nung eno pugao ara.” ");
INSERT INTO zia_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nung be imoko-nibamu goe isika nuna nasani emora dubo sisigati nasani nauna awong dawong yawero ge nuna nigiro nasani nauwa. ");
INSERT INTO zia_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Arata Filip mene Tuwa Bayau nata Tuwa yero nariniya auna Bowi Iwaing tugata nasani Yesu Kristora ge ungwe tugata yenu nigiro Yesu tumo diwa nung emore baunone ge ou suwena ara. ");
INSERT INTO zia_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ayero yenu Simon nung deka ayero Tuwa Bayaura ge niginu me yenu giro ge ou suwero Filip aune tairo nasani nauna ara. Ayero naunu Filip mene tani putoungne yero naunu giro wawong di gauno nasani nauna arauwa. ");
INSERT INTO zia_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samaria emo bauno awong Tuwa Bayaura ge nigiro dubo nunae darawa yewa auna bowi mene Yerusalem nape aposolo dubura una baungnu nigiwa ara. Nigiro giro awong Petoroto Yohane Samaria tawingna iyengtiwa bamuwato ara. ");
INSERT INTO zia_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Baungno kasa yero Oweno mene nunae-una toiro be baise Tuwa eno isa sewato. ");
INSERT INTO zia_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Noeno okowata, gitau Oweno mene nunae-una oko wosao. Awong Yesura yazora gege ge ou suwewa. ");
INSERT INTO zia_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Arare aposolo etobe wawong nunato ziyo nunae-una pugaiwato Oweno mene nunae-una wosiro be buna arauwa. ");
INSERT INTO zia_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Aposolo awongto emo baunona ziye atu wawong pugaiwato aune Tuwa Bayau mene Oweno pugainu pumuwa awiya Simon mene giro moni puro baung nunato una yero moni pumaetose sero eyero sena, ");
INSERT INTO zia_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Nito Oweno pugaora putoung awiya na eno dema pugayato na wawong nana emo zora ziye atu pugana aune Oweno pumae.” ");
INSERT INTO zia_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ayero senu Petoro mene nung eno abena eyero sena. “Oweno pugaora putoung awiya Tuwa Bayau mene zuma aung pugati noiya, putoung awiya nine moni mene zuma gaero pumari sinesa, arare ning aune moni nina aune dema gera yaetose sinena. ");
INSERT INTO zia_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tuwa Bayau mene dubo nina gigi teng oko yao niya. Arare ning nae tairo buro ewiya yao teng oko. ");
INSERT INTO zia_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ning kotumao meko nina awiya yangdoro dubo darawa yero tani meko yari kotupunesa auna pasena Tuwa mene disaise isa se. ");
INSERT INTO zia_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ning dubo-dubo baina yero nosa pasenana bunao mene ning bunero baingtinu nosa, awiya gosinena.” ");
INSERT INTO zia_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ayero senu Simon mene abena eyero sena, “Nito na eno Tuwa isa sayato nona sineyato awiya nana-una oko kasa yaise.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Aposolo etobe mene Yesura susuwa gigiwato auna ge keregati nasani emo bauno Tuwara ge tugata yero aune Yerusalem nape kapetegairo bamuwato ara. Kapetegairo bautunasani Samaria tawingna napo daigairo mitiwa auna atu Bowi Iwaing tugata yero bamuwato arauwa. ");
INSERT INTO zia_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Tuwara angelo zo mene Filip eno eyero sena, “Ning iropuro nagibo ika ina Yerusalem nape atu wosi Gasa nape yero nowa nagibo auna baung.” (Nagibo awiya tawing emo aung auna atu mitiya.) ");
INSERT INTO zia_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ayero senu giro Filip mene iropuro baungna ara. Itiopia tawingna bauno tuwa baina zo nasani nauna yazo nuna Kandasi auna soremao nuna zo nung bauno tuwa baina auna wau moni diya nasani nauna, nung amimene Tuwa Bayau bowi yari sero baung Yerusalem nape yero ");
INSERT INTO zia_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Tuwa Bayau bowi yero nupema tera nape babari sero karesra kapetegairo bautunasani ge porofete Yesaya mene gaena awiya zazagati nasani bautunena. ");
INSERT INTO zia_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Bautunenu Oweno mene Filip eno eyero sena, “Ning kares ouna nugu baung, nung tairo babase.” ");
INSERT INTO zia_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ayero senu Filip mene sungno baungno taungno emo porofete Yesayara ge gayao awiya zazagati nenu giro atata yero sena, “Ge zazagati nesa auna susuwa gosinesita?” ");
INSERT INTO zia_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ayero senu emo amimene abena eyero sena, “Emo zo mene na oko tugata yao yai na naka natope nono yero gera susuwa garineni?” Ayero sero Filip wangna witaise senu wangna witiro adunu dema bamuwato ara. ");
INSERT INTO zia_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ge gayao zazagatinena awiya eyero gayao ara, Lama zo dero ayari sero puro bautuneya ayao ine nung ara. Ora lamana tumiza kapari sero yero nowa ge aung yero nowa ayero nung ge oko sao yena. ");
INSERT INTO zia_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Awong nung izewa. Awong koto nasani ge me nung eno oko sewa. Tawingna nao nuna kapewa aung yena, arare awe mene dubu nuna-una ge ungwe yao teng niye? ");
INSERT INTO zia_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Arare emo gitau yao amimene Filip atata yero sena, “Nine se nigane. Porofete nung awe eno ge ayero seni? Nung enota emo zo eno seni?” ");
INSERT INTO zia_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ayero senu Filip mene porofetera ge awiya Yesura una pugairo Yesura Bowi Iwaing tugata yena. ");
INSERT INTO zia_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ayero sero bautunete ou ubutu zora kasa yero emo gitau yao amimene eyero sena, “Gi. Ou mitiya era. Na ge ou suwasa teng yarinita?” ");
INSERT INTO zia_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ayero senu Filip mene abena eyero sena, “Ge tugata yetena awiya nigiro iniro taka sasa giro na ning ge ou suwana teng yari niya.” Ayero senu abena eyero sena. “Yesu Kristo nung Tuwa Bayaura Mani me awiya iniro taka sinena.” ");
INSERT INTO zia_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ayero sero wo dopaetose senu dopewato nung Filip aune wosi oura yero Filip mene emo awiya ge ou suwena. ");
INSERT INTO zia_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ayero yero oura atu wiwitinewato Tuwara Oweno mene Filip mena puro ewe baungnu emo gitau yao amimene Filip kau yero nung yawa yawa nasani nagibo nuna-una baungna ara. ");
INSERT INTO zia_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ayenu Filip nung Azoto nape kasa yero atu zayero napo sero ge tugata yero bautunete Sisaria nape kasa yena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo nung Tuwara dubu gera-gaira nasani dai mamagayaese sero moko nuna-una gorobo kasa yenu giro buro yaora eo yena. Ayero yero baung pirisa bainana-una yero ");
INSERT INTO zia_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","igi pugaise senu giro igi gaero pugaina ara. Igi awiya Yudara yere ibu diya yao emo Damaskas nape atu nauwa aeno pugati nasani Saulora nao aune buro nuna dema keregaina ara. Keregairo emore baunone Tuwara Nagibo Sekawara naya taungno giro bunero puro bung Yerusalem nape yaise sero gaena ara. ");
INSERT INTO zia_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ayenu nung igi awiya puro bautunete Damaskas napo nugu daung nenu waegao zo mene uritira atu mena wosiro nung gaena ara. ");
INSERT INTO zia_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Gaenu Saulo zuwe tawingna gairo mitasani ge eyero nigina, “Saulo, Saulo, ning noeno na dero tuninasani yero nosi?” ");
INSERT INTO zia_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ayero senu Saulo mene atata yero sena, “Tuwa, ning aweni?” Ayero senu Tuwa mene ge abena eyero sena, “Dero tuninasani nosa Yesu na ara. ");
INSERT INTO zia_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Arata ning iropung. Nape babasa nona yasese sao mitiya, awiya tugata yarinena ara.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Emo nung aune dema bautunewa amimene ge aung yero dopero mitasani ge gege nigiwa ara. Arata emora benaung awiya oko gao yewa. ");
INSERT INTO zia_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ayenu Saulo nung tawingna atu iropuro diti pagairo soma giginu mume gege yena. Ayero yenu emo dubu nuna mene wawong gaero puro baung Damaskas nape yewa ");
INSERT INTO zia_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","wari be etama diti guma yenu nona oure oko minao mitina arauwa. ");
INSERT INTO zia_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaskas nape atu Yesura dubu auna zo nasani nauna yazo nuna Anania. Nung atiyo yaine nenu Tuwa mene nung yausena, “Anania.” Ayero senu Anania mene eyero sena, “Tuwa, na era.” ");
INSERT INTO zia_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ayero senu Tuwa mene nung eno eyero sena, “Ning iropung. Nagibo yazo Korosao ayero sero nowa auna atu baungno emo zo yazo Yuda auna gare witiro emo zo yazo nuna Saulo, nung Taso napora, nung awiya tamarinesa. Nung isa sinasani mitiya. ");
INSERT INTO zia_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nung atiyo yaine yero nona eyero gigiya: Emo zo yazo nuna Anania amimene nuna-una kasa yero diti pagaise wawong nuna ziye pugaiya.” ");
INSERT INTO zia_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Tuwa mene ge ayero sinasani tugata yenu Anania mene abena eyero sena, “Tuwa, emo auna ungwe meko diro yero nowa nigitinona. Nung Yerusalem atu dubu nina daigairo gera-gaira yero noiya. Arare nae napo euna atu yazo nina bowi yero nonane aeno nae ewiya dema bunero puro babaise pirisa babuze mene igi gaeteya ara.” ");
INSERT INTO zia_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Anania mene ayero sena. Asenu Tuwa mene eyero sena, “Ning atu babasese sinena. Emo awiya buro-mani nana pupunena. Arare nune yazo bowire nana puro emo Yuda okora unata emo tuwara unata Isreli dubura una puro sero sero yero bautu nasani naise. ");
INSERT INTO zia_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nung yazo bowire nana tugata yari yayare dubo minaore nariniya, awiya nane gipana gariniya.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ayero senu Anania mene baungno garo sena auna witiro wawong nuna Saulora ziye pugairo eyero sena, “Saulo, otao nana, Tuwa nagibe atu nina-una kasa yetiya, nung awiya Yesu ara. Nung amimene na iyengti nina-una butunena era. Ning diti pagasa Oweno mene moko nina bebumai nase.” ");
INSERT INTO zia_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ayero senu Saulora diti mokora atu nona zo wo tata ine amimene wosinu aune diti nuna pagaina ara. Ayenu Saulo iropuro senu ge ou suwewa ara. ");
INSERT INTO zia_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nung ge ou suwewa aune nung nona miniro putoung pungna arauwa. ");
INSERT INTO zia_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Saulo mene Yesura dubu Damaskas atu nasani nauwa aune dema wari be ena atu nasani nauna ara. ");
INSERT INTO zia_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Atu nasani mena baungno Yuda emora yere ibu atu mitauwa auna baungno toiro Yesura bowi keregairo tugata nasani eyero sinauna, “Yesu nung Tuwa Bayaura Mani.” ");
INSERT INTO zia_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ayero tugata yenu nigiwa teng oko yenu awong nuka nuyetope eyero wina-se yewa, “Emo emimene Yerusalem nape atu Yesura yazo auna isa sinowa dubu awiya giro gera-gaira yero noiya. Deka ayero nung etu buro Yesura dubu awiya bunero puro pirisa babuzera una babari sero buna, nung awiya bumiya era.” Ayero wina-se yewa ara. ");
INSERT INTO zia_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Arata Saulo mene tau-tataware yero Yesu nung Sorao Emo Kristo me auna ge susuware sero baingtiro Yuda emo Damaskas nape atu nasani nauwa awiya tugata yenu nigiro no saine yero giro yangduwa. ");
INSERT INTO zia_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ayero atu nawe dunu Yuda emo augairo Saulo dari sero opene ge diwa tauyena, ");
INSERT INTO zia_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","arata Saulo mene ge awiya nigina ara. Awong Saulo dari sero napora towao be sero pingne warire umo yero nasani nauwa ara. ");
INSERT INTO zia_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Anewa giro Saulora dubu mene pingne nung sakara guguno angsi mene goga gaero napora goma bautara atu angsira iniro gururu gururu yewa wosiro baungna arauwa. ");
INSERT INTO zia_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo mene baungno Yerusalem nape kasa yero Yesura dubu aune dema susumari senu awong awang yewa. Awiya noeno okowata, nung Yesura mani yena awiya gigiwa ge iwao yena. ");
INSERT INTO zia_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Awang yewa giro Banaba mene Saulo otao yero puro aposolo dubura una baungno Tuwa mene nagibe atu Saulora una kasa yero nung eno ge senu nung Damaskas nape atu awang yao aung Yesura Bowi Iwaing keregaina auna ungwe dina ara. ");
INSERT INTO zia_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ayero yenu Saulo nung awong aune dema nasani Yerusalem nape atu puma-sauma nasani nauna. ");
INSERT INTO zia_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Atu mitasani Tuwara ge awiya emo eno awang yao aung tugata yero nasani nauna. Ayero yero naunu Yuda emo Grik ge nigao amimene nung aune dema Tuwara ge awiya sinasani ge wina-se yero nasani nauwa ara. Ayero nasani Saulo dari sero nagibo tamari sero newa ");
INSERT INTO zia_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","giro otao mani nuna mene nung yuno puro baungno Sisaria nape kasa yero wangna pugairo iyengtiwa baungno Taso nape kasa yena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Awong Saulo iyengtiwa baungnu aune Yesura dubu Yudaya tawingna, Galilaya tawingna, aune Samaria tawingna atu nasani nauwa nunae-una atu gera mono kasa yena ara. Monone nasani gera putoung pu dekaongna gairo tau yewa. Ayero yero Tuwara yazo de ika gatinasani nauwa. Ayero newa Oweno mene awong soreunu emo bauno witao mene Yesura dubu aune tairo nasani nauwa arauwa. ");
INSERT INTO zia_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petoro nung burora puma-sauma nasani nawe wosiro Yesura dubu Lida nape atu nasani nauwa auna-una kasa yena. ");
INSERT INTO zia_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Atu kasa yero emo zo yazo nuna Ainia awiya gigina. Nung asama yero mitawe dunu dawang 8 ayao aung yena. ");
INSERT INTO zia_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ayenu Petoro mene nung eno eyero sena, “Ainia, Yesu Kristo mene ning kora niya. Arare iropuro awao masi nina ewe.” Ayero senu mena iropuna ara. ");
INSERT INTO zia_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ayero yenu Lida napora arita Seron garawira emo bauno mene giro dubo darawa yero Tuwara dubu yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yesura dubu nauwa auna bauno zo Yopa nape atu nasani nauna, yazo nuna Tabita. Grik gera Dokas. Nung mono pumao buro yero nasani kora yao buro daigairo yero nasani nauna. ");
INSERT INTO zia_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Arare Petoro nung Lida nape atu nenu Tabita yaya puro magayena ara. Magayenu aingso nuna saero garo moko zora puro witiro pugaiwa. ");
INSERT INTO zia_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida napo awiya Yopa napo nugu ina atu mitauna, arare Yesura dubu mene Petorora bowi nigiro emo etobe iyengtiwa nuna-una baungno eyero sewato, “Nato ning puro napo nanae-una mena babanene.” ");
INSERT INTO zia_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ayero sewato Petoro mene ge awiya nigiro eo yero emo etobe aune dema bamuwa ara. Baungno kasa yenu garo bauno magayao mitina auna atu puro witiwa bauno gagamo apakana buro Petoro ziuno zi sinasani mo wapere taung worire Dokas mene seka nasani gaenu pumuwa awiya gipewa. ");
INSERT INTO zia_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ayero yewa Petoro mene awong awang senu wosi duru yewa boma gaero isa sena. Isa sero aung yero aune diti yero bauno magayao awiya anuwing nasani aune eyero sena, “Tabita, ning iropung.” Ayero senu diti pagairo Petoro giro iropuro aduna. ");
INSERT INTO zia_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Adungno mitinu Petoro mene wawong iniro senu iropuro dopena. Ayero yenu nung Yesura dubu aune bauno gagamo enane yau senu witiwa Tabita nung seka yena awiya nunae-una waweng pugaina ara. ");
INSERT INTO zia_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Auna bowi mene baungno Yopa napo awiya teng yenu daigairo mene Tuwa tumo diwa. ");
INSERT INTO zia_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petoro nung Yopa nape atu mitasani emo zo yazo Simon, nung wo aingso buro yao emo, auna gare atu be daigairo nasani nauna arauwa. ");
INSERT INTO zia_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sisaria nape atu emo zo nasani nauna yazo nuna Konilio. Nung Itali tawingna gorobo emo auna zo. Nung gorobo emo 100 auna diya yero nasani nauna ara. ");
INSERT INTO zia_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nung aune awiso nuna awong Tuwa Bayau sou nasani etutero nasani nauwa ara. Ayero nasani Yuda emo bauno bogamasa eno mono pumao buro daigairo yero nasani Tuwa Bayau eno ozaung isa sao gege sinasani nauwa ara. ");
INSERT INTO zia_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ayero nawe wari be zore ture 3 kilok aune nung seka mitasani atiyo yaine yero Tuwa Bayaura angelo zo mene nuna-una gare toinu gigina ara. Ayero gosinenu angelo mene yazo nuna yau sero sena, “Konilio,” ");
INSERT INTO zia_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ayero senu anuwing nasani awang yero tibebere auno eyero sena, “Tuwa, noeno sinesi?” Ayero senu angelo mene nung eno eyero sena, “Isa nina aune mono pumao nina aune Tuwa Bayaura una bautunoi giro arataungno yero noiya. ");
INSERT INTO zia_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Arare ning soumani ena iyengtasa baung Yopa nape yero emo zo yazo nuna Simon Petoro awiya taungno puro bumae. ");
INSERT INTO zia_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Emo awiya emo zo yazo nuna Simon, nung wo aingsora buro yero noiya, auna-una gare atu mitoiya. Garo awiya wito bera atu mitiya.” ");
INSERT INTO zia_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Angelo mene ge awiya tugata yero doro baungnu nung soumani nuna etobe aune gorobo emo nung sou yero nasani nauwa auna zo nung Tuwara gera nao awong etama ayero yau senu bumuwa ");
INSERT INTO zia_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ge ungwe yero besugairo Yopa nape iyengtinu bamuwa arauwa. ");
INSERT INTO zia_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Mani iyengtinu bautunete nagibe atu awiro nupema atu iropuro bautunete napo tamari sero newa wari towang dodopinena be aune Petoro nung isa sari sero garo tame witiro ");
INSERT INTO zia_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","isa sinete meri magayero senu nona sasinewa nung atiyo yaine nenu Tuwa mene nung eno nona eyero gipena ara: ");
INSERT INTO zia_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Uriti gausenu nona zo mo ine bainakama oko nuna siwongpatige auna atu angsi mene diyao gamao awiya nung eno pugaiwa wosiro buro tawingna yena. ");
INSERT INTO zia_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mo auna mokora atu wo benaung giti, yi benaung giti, aune ni benaung giti amimene mitiwa. ");
INSERT INTO zia_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Wosiro bunu aune ge zo eyero kasa yena, “O Petoro, iropuro dero aero mini.” ");
INSERT INTO zia_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ayero senu Petoro mene abena eyero sena, “Tuwa, ayero oko sase. Na nona meko awiya oko mininona.” ");
INSERT INTO zia_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ayero senu ge nupema eyero kasa yena, “Tuwa Bayau mene nona saero kora yero noiya awiya meko oko sase.” Ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ge awiya kasa yenu be etama yenu aune mena nupema watimuwa witiro baung uritira yena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petoro nung nona awiya atiyo yaine yero gigina, auna susuwa gari sero kotung-katung nasani mitinu Koniliora emo awong nape atu kasa yero Simonna garo kau nasani atata yero bautunete garo taungno garo bera dopewa ara. ");
INSERT INTO zia_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Dopero yau sinasani eyero sewa, “Simon yazo nuna zo Petoro nung garo euna atu mitita?” ");
INSERT INTO zia_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ayero sinewa be awiya Petoro nung nona gigina auna susuwa awiya kotungno gari sero kotung-katung nasani mitinu aune Oweno mene nung eno eyero sena, “Emo etama buro ning kau neya, awiya gi. ");
INSERT INTO zia_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Arare ning iropung. Wosiro awong aune dema babari sero nasani kotung-katung oko yase. Emo awiya nane sesena bumeya ara.” ");
INSERT INTO zia_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ayero senu giro Petoro mene wosiro baungno nunae-una yero eyero sena, “Na kau neya na era. No eno butunei?” ");
INSERT INTO zia_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ayero senu awong eyero tugata yewa, “Gorobo emora diya emo Konilio amimene nae iyengti butunenane. Nung Tuwa Bayau sou yero nasani etutero noiya. Arare Yuda emo nung giro aratapu nasani yawa yawa yero nowa. Nung awiya Tuwa Bayaura angelo zo mene nuna-una kasa yero ning garo nuna-una yuno babanane be nina-una atu ge ena nigaise sesiya.” ");
INSERT INTO zia_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ayero sewa giro Petoro mene awong kora-makora yena ara. Kora yenu atu awiwa iya gainu aune nung Yopa napora ge nigao ena aune emo otu bumuwa aune dema bamuwa arauwa. ");
INSERT INTO zia_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Awong nagibe atu ping dekaongka awiro aune kasa ye Sisaria nape gaiwa. Konilio nung sedikaing nuna aune otao mani nuna eno senu au dekaongna gaiwa awong diya mitiwa kasa yewa. ");
INSERT INTO zia_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kasa yero Petoro mene gare towari sero nenu Konilio mene nuna-una nugu buro nuna tera atu boma gaero yawa yawa bainakama yena. ");
INSERT INTO zia_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ayero yenu Petoro mene iropaise eyero sena, “Ning iropung. Na emo ning ayao ine ara.” ");
INSERT INTO zia_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ayero sena ara. Ayero sero ge ungwe-maungwe yero gare toiro emo augairo mitiwa awiya giro eyero sena, ");
INSERT INTO zia_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","“Niye susuwa nanae Yuda emora gosinowa. Nae emo Yuda oko aune tairo naota esewa ye ninae-una gao awiya gazao ge mitiya ara. Arata Tuwa Bayau mene susuwa awiya na eno gipetiya, arare na emo zota zo eno beingtire ayero sero awang oko sarinena. ");
INSERT INTO zia_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Arare na bumanese yumeya bumaora oko mou yetena. Arare bumanese yumeya butunena auna susuwa sepu gane.” ");
INSERT INTO zia_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ayero senu Konilio mene eyero sena, “Sipe zo oune tani zo nana-una kasa yetiya auna ungwe diyana nigi. Yeme wari diti 3 kilok niya, deka ayero wari diti 3 kilok nesesi na isa sinasani mitesesena aune emo taung wori nuna waegaore amimene nana-una kasa yetiya. ");
INSERT INTO zia_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Kasa yero na eno eyero sesiya, ‘Konilio, Tuwa Bayau mene isa nina nigiti nasani mono pumao nina giro ning aratapu nasani yawa yawa niya. ");
INSERT INTO zia_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Arare ning emo iyengtasa Yopa nape baungno Simon yazo nuna zo Petoro puro bumaese. Nung emo yazo Simon wo aingsora buro yero noiya auna-una gare atu mitiya. Garo nuna wito bera atu mitiya.’ ");
INSERT INTO zia_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ayero sesi giro na mena emo iyengtena nina-una babeya. Aune ning ge nana nigiro butunesa na kara dubo nana iwaing niya. Arare Tuwa Bayau mene ge ning eno tugata yetiya awiya teng sasa nigari sero nae apakana Tuwa Bayaura benaungna augairo etu mitenane era.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petoro nung be eo yenu ge eyero tugata yena, “Tuwa Bayau mene emora taung gege gosinasani oko awega-ziwega yero noiya, awiya yeme gigena me niya. ");
INSERT INTO zia_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Emo dubu giti auna ena mene nung sou yero nasani etutero nowa awong awiya Tuwa Bayau mene gosinoi teng yero noiya. ");
INSERT INTO zia_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Bowi Tuwa Bayau mene Isreli emo eno pugaina auna bowi awiya niye nigitinowa. Yesu Kristo, nung emo bauno apakana auna Tuwa, nung amimene mono pungna auna Bowi Iwaing Tuwa Bayau mene keregairo pu daung gaina ara. Gitau Yohane mene emo bauno ge ou susunasani ge tugata yero nasani nauna be auna atu ");
INSERT INTO zia_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","bowi amimene Galilaya tawingna atu zayero baungno Yudaya tawing teng yena, awiya gosinowa ara. ");
INSERT INTO zia_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ge eyao eno sinena. Tuwa Bayau mene Yesu Nasaretera awiya burora iyengtiti nasani Oweno nuna-una pugainu toinu Tuwa Bayaura putoung pungna ara. Putoung puro puma-sauma nasani emo bauno soreuno buro nasani ena Sanda mene gera yenu meko yewa awiya apakana kora yero nasani nauna. Awiya noeno okowata, Tuwa Bayau mene nung sorepu nasani naunu buro yero nauna ara. ");
INSERT INTO zia_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nung buro Yuda tawingna arita Yerusalem nape atu yero nasani nauna auna bowi sao emo nae era. Awong nung puro i pasaora atu dewa magayena ara. ");
INSERT INTO zia_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Magayero biritira atu mitinu wari be etama aung yenu Tuwa Bayau mene nupema uwenu seka yero iropuro kasa nanae-una yenu gigiwangne. ");
INSERT INTO zia_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Awiya Yuda emo bauno apakana auna-una atu okowata, emo bowi sao emo nae Tuwa Bayau mene gitau yangtagairo pungna nanae-una gege atu kasa yena. Nae nung kara magayaora atu seka yero iropunu nung aune dema nona miniwangne ara. ");
INSERT INTO zia_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Tuwa Bayau mene Yesu emo bauno magayaore seka naore auna zaz baina naname pugaina, auna bowi ge awiya emo dubu giti aeno keregairo sanenese sena ara. ");
INSERT INTO zia_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Yesu tumo diyarineya awong awiya Tuwa Bayau mene Yesura iwaing gege eno pasena nunae disariniya. Awiya porofete apakana amimene keregairo aung yewa ara.” Ge ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petoro nung ge ayero sinasani mitinu emo bauno Bowi Iwaing nigiti nasani mitiwa Oweno mene wosiro nunae-una toina ara. ");
INSERT INTO zia_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ayero yenu Yuda emo ge nigao Petoro aune dema bamuwa awong Tuwa Bayau mene emo Yuda oko aeno dema Oweno pugaina awiya giro wawong di gamuwa ara. ");
INSERT INTO zia_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Wawong di gamuwa, noeno okowata, emo Yuda oko awong ge ewe-pape Oweno mene tapunoiya awiya sinasani Tuwa Bayau bowi newa nigiwa ara. Ayero yewa Petoro mene eyero sena, ");
INSERT INTO zia_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Oweno naname-una toina deka ayero nunae-una toitiniya, arare ge ou suwao awiya sorao ine oko mitiya.” ");
INSERT INTO zia_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ayero sero senu emo awong Yesu Kristora yazora susumuwa ge ou suwewa. Ayero yewa awong Petoro sorewa wari be ena awong aune dema atu mitasani nauna arauwa. ");
INSERT INTO zia_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Aposolo ena aune Tuwara dubu Yudaya tawingna atu nasani nauwa awong amimene emo Yuda oko dema Tuwa Bayaura ge nigiwa auna bowi nigiwa ara. ");
INSERT INTO zia_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Arare Petoro mene Yerusalem nape kapetegairo witinu Yuda emo ena emo Yuda okora taung aingso kapari sinauwa amimene nung gona yero eyero sewa, ");
INSERT INTO zia_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ning noeno baungno emo Yuda oko taung aingso oko kapao aune dema nona mininosi?” ");
INSERT INTO zia_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ayero sewa Petoro mene nona kasa yena auna ungwe susuwara atu momo-zimomo yero dina ara. Didinasani eyero sena, ");
INSERT INTO zia_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Na Yopa nape atu isa sinasani mitena Tuwa mene kotumao nana kapetegai atiyo yaine nasani nona eyero gigena ara. Nona zo mo ine bainakama oko nuna siwongpatige auna atu angsi mene diyao gamao awiya uritira atu pugeya wosiro buro nana-una nugu kasa yetiya ara. ");
INSERT INTO zia_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ayero yeti giro na susuwa nuna gari sero diti yero aune mokora atu wo benaung-giti — napo wore, yire, ni mamanine — miteya gigena ara. ");
INSERT INTO zia_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Aune nana-una atu wawa eyero kasa yeti nigena, ‘Petoro, iropung. Dero aero minase.’ ");
INSERT INTO zia_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ge ayero kasa yeti nane eyero sesena, ‘Tuwa, ayero oko sase. Na nona meko awiya oko mininona.’ ");
INSERT INTO zia_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ayero sesena uritira atu ge eyero nupema kasa yetiya, ‘Tuwa Bayau mene nona saero kora niya awiya meko oko ayero sase.’ Ayero sesiya ara. ");
INSERT INTO zia_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Nona awiya kasa yeti be etama yeti aune mo nonane awiya watimeya nupema kapetegairo uritira witiya ara. ");
INSERT INTO zia_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nona aung ni aune Sisaria nape atu emo etama ai puro nana-una baungno garo mitena auna kasa yeteya ara. ");
INSERT INTO zia_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Kasa yeteya Oweno mene na eno eyero sesiya, ‘Ning awong aune babari nasani kotung-katung oko yase.’ Ayero sesi otao mani 6 mene na aune dema baungno kasa yero Koniliora gare witenane ara. ");
INSERT INTO zia_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Witenane ge ungwe eyero yetiya, ‘Angelo mene garo nana-una witiro na eno eyero sesiya, “Ning mani iyengti Yopa nape baungno Simon yazo nuna zo Petoro awiya sero puro bumae. ");
INSERT INTO zia_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Puro baya ning aune dubu nina niye ge tugata yai nigaya Tuwa Bayau mene niye sorero pumariniya.” Angelo mene na eno ayero sesiya.’ ");
INSERT INTO zia_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Konilio mene ayero sesi giro na ge tugata nasani mitena, gitau Oweno naname-una wosina, deka ayero nunae-una wosiya ara. ");
INSERT INTO zia_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Wosi giro nane Tuwa mene ge eyero sena awiya kotumena, ‘Yohane mene niye ge ou susunoiya, arata Tuwa Bayau mene Oweno niye eno pugariniya.’ ");
INSERT INTO zia_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Name Tuwa Kristo tumo diwangne Oweno name eno pugaina, Oweno dekaongka awiya awong eno pugai giro na wosao eyao emimene nono yero Tuwa Bayau awang sarineni?” ");
INSERT INTO zia_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Petoro mene ayero sinasani awong tugata yenu nigiro yo nunae ozenu Tuwa Bayau bowi nasani eyero sewa, “Arare Tuwa Bayau mene emo Yuda oko dema dubo darawa yero nao me iwaing auna gerao yero naese sinoiya ara.” Ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Iwo mene Stiwen dero Yesura dubu auna ena dero tunewa zanero ena Fonisia tawingna, ena Saipras gutura bamuwa, aune ena Antiok nape bamuwa ara. Baungno atu nasani Tuwara ge awiya Yuda emo eno gege tugata yewa ara. ");
INSERT INTO zia_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ayero newa nunae-una mokora Saipras guturata Sairini tawingna ge nigao emo bauno ena awong amimene Antiok nape kasa yero emo Yuda oko aune dema nasani Tuwa Bayaura Bowi Iwaing tugata yewa ara. ");
INSERT INTO zia_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tuwara putoung nunae-una mitina, arare ge tugata yewa emo bauno dubu bainakama mene ge awiya nigiro Tuwa tumo diro dubu nuna yewa ara. ");
INSERT INTO zia_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Dubu nuna yewa auna bowi awiya Yesura dubu Yerusalem atu nasani nauwa amimene nigiro Banaba iyengtiwa Antiok nape baungna ara. ");
INSERT INTO zia_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Baungno kasa yero Tuwa Bayaura mono bowire nunae-una mitina awiya giro yawa yawa nasani dubo nunae mene Tuwa Bayau iniro baingtaese sero awong yupunasani ge tugata-magata yena. ");
INSERT INTO zia_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banaba nung emo iwaing. Moko nuna-una Owenone tumo diyaore mene be buna. Arare napo auna emo bauno daigairo amimene Tuwara una susumuwa arauwa. ");
INSERT INTO zia_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Arare Banaba nung Saulo tamari sero Taso nape baungna. ");
INSERT INTO zia_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Baungno taunu dema Antiok bamuwato ara. Awongto Yesura dubu aune dema tairo dawang zo atu nasani emo bauno daigairo aeno ge tugata yero nasani nauwato ara. Yesura dubu Kristen ayero sero nowa, yazo awiya Antiok nape atu mena sewa tau yena. ");
INSERT INTO zia_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Be aune porofete emo ena mene Yerusalem atu iropuro baung Antiok nape yewa ara. ");
INSERT INTO zia_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Nunae-una emo zo yazo nuna Agabo, nung Oweno mene kotumao pugainu giro dopero tawing sero sero auna atu dora botiyo bainakama kasa yarinena auna bowi sena. (Dora botiyo awiya Roma emo tuwa Klodio nauna aune kasa yena.) ");
INSERT INTO zia_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Arare Kristen dubu awong ge awiya nigiro titiwing awena gosinasani auna teng moni kora yero pu dekaongna gairo Yudaya tawingna otao mani eno pugaya babaise sewa tau yena ara. ");
INSERT INTO zia_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Arare moni pu dekaongna gaiwa awiya Banabato Saulora waweng pugaiwa puro baungno dubu auna simai yero nasani nauwa aeno pugaiwato pumuwa arauwa. ");
INSERT INTO zia_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Be auna atu emo tuwa Herode mene Yesura dubu auna emo bauno ena dero gera-gaira yero puro bunao gare pugaina. ");
INSERT INTO zia_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ayero nasani senu Yohanena tato Yakobo awiya iwi mene dewa magayena ara. ");
INSERT INTO zia_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ayero yena aeno Yuda emo yawa yawa yewa giro pasena zo susuuno senu Petoro dema bunero bunao gare pugaiwa ara. Be awiya Magayao mene awong Daigaina auna oregao be yenu Yuda emo yis seminiro newa aune bunena ara. ");
INSERT INTO zia_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Herode mene Petoro bunero eyero kotuna, “Magayao mene awong Daigaina auna oregao be nunae aung yai aune na Petoro dari sero puro emo baunona ditira atu koto yarinena.” Ayero kotupu nasani senu bunao gare pugaiwa gorobo emo dubu 4 mene diya yewa. Dubu zo gorobo emo 4, dubu zo gorobo emo 4, ayao amimene nung diya yewa. ");
INSERT INTO zia_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Petoro bunao gare mitinu Tuwara dubu mene nung eno isa susuuno sao gege sinewa Tuwa Bayaura una witao gege wiwiti nauna arauwa. ");
INSERT INTO zia_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Koto yaora be nugu yenu Herode mene eyero kotuna, “Iya gai na Petoro puro kasa yana garineya.” Ayero kotupunasani awinenu ping aune gorobo emo etobe mene Petoro seni etobe mene bunero puro awinewato, gorobo emo ena mene zo garo be bautara atu dopero bunao garo diya yewa ara. ");
INSERT INTO zia_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Dopero mitiwa Tuwara angelo zo mene garo mokora atu mena kasa yena. Kasa yenu garo moko waegatinenu aune angelo mene Petoro uwero eyero sena, “Mena iropung.” Ayero sinenu Petorora wawongna atu seni etobe mitiwato awiya besewato ara. ");
INSERT INTO zia_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Seni besero wosiwato angelo mene Petoro eno eyero sena, “Ipura geing nina diro te soga tera pugai.” Ayero senu yenu aune angelo mene nupema sena, “Taung wori nina imoko wosogairo na ago ye.” ");
INSERT INTO zia_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ayero senu giro ago nasani angelo mene tani nena awiya giginu tani me ine okowata atiyo yaine yena. ");
INSERT INTO zia_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Awongto bautunete gorobo emo zo daigairo nupema zo daigairo bautunete garo be napo kakame babao aeni mene yao auna kasa yewato garo be nuka nutope apenu kasa daung yewato ara. Kasa daung yero baungno nagibo zo daigairo aune angelo mena tara yena. ");
INSERT INTO zia_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ayero yenu Petoro nung kotumao kasa yenu eyero sena, “Yeme gosinena. Tuwa nung angelo nuna iyengti Herodera waweng atu o nupema tani Yuda emo mene na eno yari sineya auna atu sorero pupuniya.” ");
INSERT INTO zia_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ayero sero susuwa me giro baungno Yohane zo yazo nuna Mak auna ai yazo Maria auna gare kasa yena. Garo auna emo bauno daigairo mene augairo isa sinasani mitiwa. ");
INSERT INTO zia_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ayero newa Petoro baungno daung atu dopero garo be denu au bauno zo yazo nuna Roda nung, “Awe garo be deduniye?” ayero sero kasa yena. ");
INSERT INTO zia_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kasa yero Petorora ge mapu nigiro yawa yawa nasani garo be oko apao yangdoro kapetegairo toiro, “Petoro buro garo be bautara atu dopero mitiya,” ayero sero awong tugata yena ara. ");
INSERT INTO zia_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Tugata yenu nigiro eyero sewa, “Ning dau nesita?” Ayero sewa nung ge tauyao sena, “Nung meba dopero mitiya ara.” Ayero senu awong eyero sewa, “Awiya ititi nuna mene nita.” ");
INSERT INTO zia_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ayero wina-se newa Petoro mene garo be giriri-gariri yao gege nasani mitinu giro garo be apero nung giro awong ge aung yewa. ");
INSERT INTO zia_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ayero yewa Petoro mene ge yangduwaese wawong sapiyero Tuwa mene bunao gare atu nung besero puro buna auna ge ungwe yero besugairo aune eyero sena, “Niye ge ungwe nana awiya Yakobo aune otao mani nana ena tugata yepu nigae.” Ayero sero awong yangdoro agewa zora baungna arauwa. ");
INSERT INTO zia_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Iya gainu gorobo emo mene Petoro kau yero “Tani ewiya noiye? Nupema nung nono yero babiye?” ayero sero susuwa kau yero giro yangduwa. ");
INSERT INTO zia_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ayero yewa arata Herode mene kau yero tamaese senu kau yao buro yewa aung yenu giro gorobo emo Petoro diya mitiwa awiya daya magayaese sena ara. Ayero sero aune nung Yudaya tawing doro wosiro baung Sisaria nape yero atu nasani nauna ara. ");
INSERT INTO zia_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herode nung be aune napo etobe Tayato Saidon auna emo bauno iwo yena. Anenu giro napo auna mamono awong dubo dekaongka yero nung gari bamuwa ara. Baungno kasa yero ge kora yari sero Herodera emo gitau yao zo yazo nuna Bilasto nune awong soremaise sewa giro nung awong soreuna. Gitau awong Herodera tawingna atu wo ma zuma gaero pupunasani nauwa, arare ge kora yero nupema tairo nari sewa ara. ");
INSERT INTO zia_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ge kora yari sewa Herode mene ge abena saora be pugaina. Be awiya bunu giro taung nuna siuno yero baingtiro emo tuwa adumaora ura nuna-una atu adungno mitasani ge taung puro witaora sinasani emo tugata yena. ");
INSERT INTO zia_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tugata yenu emo bauno apakana amimene wawa sero eyero sewa, “Ge awiya emo zora ge ine okowata, Tuwara ge ine niya.” ");
INSERT INTO zia_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ayero sewa Herode mene emo baunona ge oko awang sao Tuwa Bayau daigaina, aeno Tuwara angelo zo mene nung mena no daine yena. Ayero yenu ipa mene miniwa magayena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tuwa Bayaura ge mene zo wisika sero soma sero baungna ara. ");
INSERT INTO zia_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabato Saulo awongto Yerusalem nape atu buro sao awiya teng yewato aung yenu awongto nupema Antiok nape kapetegari nasani Yohane zo yazo nuna Mak awiya puro dema bamuwa arauwa. ");
INSERT INTO zia_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Yesura dubu Antiok nape atu nasani nauwa auna mokora atu porofete emore gipao emore awong amimene nasani nauwa. Banaba, Simion, yazo nuna zo Naiza, Lusias nung Sairini napora, Saulo, aune Maneyen. Nung aune emo tuwa Herode awongto awiya dema bayao. Emo ayao amimene porofete emo arita gipao emo yero nasani nauwa. ");
INSERT INTO zia_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Awong wari be zore nona semininasani Tuwa bowi newa Oweno mene ge eyero sena, “Banabato Saulo eno buro ge sewang awiya yaetose na eno nasani burora pugaipu.” ");
INSERT INTO zia_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ayero senu nona seminiro isa sinete wawong nunae ziye nunato una pugairo gao yero burora iyengtiwa bamuwato ara. ");
INSERT INTO zia_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Oweno mene awongto burora iyengtinu giro wosi wito bera yero bautunete Selusia nape kasa yewato ara. Atu kasa yero wangna witiro bautunete Saipras gutura kasa yewato ara. ");
INSERT INTO zia_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Atu kasa yero napo gitau yao Salamis auna baungno Yuda emora yere ibu ena auna toiro Tuwa Bayaura ge tugata yewato ara. Yohane zo yazo nuna Mak amimene awongto aune dema nasani awongto soreuna. ");
INSERT INTO zia_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Awong atu iropuro ang yero gutu busero Pefos nape kasa yewa. Atu kasayero goe-isika yao emo zo yazo nuna Bara-Yesu awiya tamuwa. Nung Yuda emo. Nung nuka nutope, “Na Tuwa Bayaura porofete zo,” asinasani nauna, arata nung Tuwa Bayaura porofete okowa. ");
INSERT INTO zia_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Emo amimene diya emo baina zo yazo nuna Sesias Polas auna otao yero nasani nauna. Diya emo nung kotumao bainane. Nung Tuwa Bayaura ge nigari sero arataungno giro Banabato Saulo yunu garo nuna-una witiwato ara. ");
INSERT INTO zia_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nung awongto yunu witiwato goe-isika yao emo Elima (yazo awiya Grik ge. Grik emo mene goe-isika yao emo apakana awiya Elima asinasani nauwa), nune diya emo aeno Tuwara ge sorinasani awongto awang sena ara. ");
INSERT INTO zia_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ayero yenu Saulo, yazo nuna zo Paulo asinasani nauwa, nung awiya Owenona putoung mene moko nuna-una atu toiro bebunu nung Elima anuwing nasani eyero sena, ");
INSERT INTO zia_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Ning Sandara mani. Ning etutero naora iwo emo. Dubo nina-una atu etegaore mekore mene be bumao. Ning Tuwara ge me darawa yasa ge iwao yaise yero nosa. ");
INSERT INTO zia_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Arare Tuwara putoung abena nina-una yeme kasa niya. Ning diti guma yariniya. Wari be ena ning warira waegao oko gao narinesa.” Ayero senu mena kara diti guma yenu ziru-ziru nasani wawong mene inigi-inigi nasani emo zo wawong nuna iniro nagibo gitau yaise kau yero baungna. ");
INSERT INTO zia_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tani awiya kasa yenu diya emo mene giro Tuwara ge giginu putoungne yenu giro Yesu tumo dina ara. ");
INSERT INTO zia_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo aune emo mani nuna awong Pefos napo yangdoro nupema wangna witiro bautunete baungno Pamfilia tawingna napo zo yazo Pega auna kasa yewa. Atu Yohane Mak mene awongto yangdoro Yerusalem nape kapetegairo baungna ara. ");
INSERT INTO zia_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ayero yenu awongto Pega napo yangdoro bautunete Pisidia tawingna Antiok napo zo auna kasa yewato. Kasa yero atu newato Sabat iya be zo bunu giro awongto Yuda emora yere ibura toiro adungno mitiwato ara. ");
INSERT INTO zia_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Atu mitiwato yere ibura simai mene sao tauyao gere porofetera ge gayao ena awiya zazagairo aung yero mani zo sewa baungno awongto eno eyero sena, “Otao, Tuwara ge susuwa ena kotupuneitota, awiya seputo niganene.” ");
INSERT INTO zia_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ayero sewa Paulo mene iropuro ge duwaese wawong mene sapi yero eyero sena, “Isreli otao mani nana, niye erita ena Tuwa Bayau sou yero nowa aeno sana nigipu. ");
INSERT INTO zia_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Name Isreli emo auna Tuwa Bayau mene aya-ewowo naname pungnu Izip tawingna atu newa senu wisika sewa. Ayero yewa putoung nuna mene atu yuno puro buna. ");
INSERT INTO zia_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ayero yero eu yanawira atu puro nasani wo ma mene uninasani naunu nawe duwa dawang 40 ayero aung yena. ");
INSERT INTO zia_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ayero yero Kenan tawingna atu emo dubu 7 mitasani nauwa, awiya dero aung yero senu aya-ewowo naname mene tawing awiya gagau sero maungne maungne yero puro nasani nauwa ara. Ayero mitawe duwa dawang 450 aung yena. ");
INSERT INTO zia_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kenan tawingna atu nauwa gitau yao emo pugatinaunu puro nawe duwa porofete Samuel kasa yena ara. ");
INSERT INTO zia_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Kasa yenu emo tuwa pumari sewa giro Tuwa Bayau mene Benzaminna dubura atu Kisira mani Saulo senu emo tuwa nunae yero dawang 40 awong gitau yero nasani nauna ara. ");
INSERT INTO zia_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ayero nawe dunu Tuwa Bayau mene senu Saulo nung emo tuwa yaora buro yangdunu Tuwa Bayau mene Dawidi maze emo tuwa nunae pugaina. Pugairo nung eno ge eyero sena, ‘Zesira mani Dawidi kotumao nanato dekaongka ara, arare sana ge nana dipunariniya.’ ");
INSERT INTO zia_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ayero sena, arare Dawidira saisibuna awena una towang atu zo mene kasa yero name Isreli emo baunona Sorao Emo yaise senu tauyena. Ge senu tauyena awiya me yaise Tuwa Bayau mene senu Yesu kasa yena. ");
INSERT INTO zia_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesu emo baunona towang oko kasa yaore, gitau Yohane mene Isreli emo bauno apakana dubo darawa yaya ge ou suwari sero ge tugata nasani yero nauna ara. ");
INSERT INTO zia_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yohane mene buro nuna sao awiya nawe besugati nasani awong eno ge eyero tugata yena, ‘Na maze nungta sero sinowa, na emo awiya okowata. Nung ago bumariniya. Nung witao, arare nane te soga nuna dutugana teng oko yariniya.’ Yohane mene ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Otao mani nana, Abrahamna saisibuna niye erita ena Tuwa Bayau sou yero nowa, sana nigipu. Tuwa Bayau mene name kora yero noiya auna bowi awiya naname una atu pugainu kasa yena ara. ");
INSERT INTO zia_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yerusalem nape atu nowa awong aune gitau yao nunae amimene Yesu nung Sorao Emo awiya oko giro baingtao nasani porofetera ge gayao awiya Sabat iya be sero zazagairo nigiro ayero nowa, awiya dema oko gao nasani nung iwora waweng pugaiwa. Awong ayero yewa porofetera ge awiya me yena ara. ");
INSERT INTO zia_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Awong pasena nuna kau nasani susuwa zo oko tamao yewa. Arata saineba gewera yero Pilato mene tebeba dai magayaise sewa. ");
INSERT INTO zia_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ayero sewa Roma emo mene Tuwa Bayaura ge gayao nung eno sao auna teng yero besugaiwa. Ayero yewa ena mene nung i pasaora atu batagairo puro pu biritira gaiwa. ");
INSERT INTO zia_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Arata Tuwa Bayau mene nung magayaora atu uwenu seka yero iropuna. ");
INSERT INTO zia_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Iropuro emo bauno ena gitau nung aune dema Galilaya tawingna atu Yerusalem nape dema bamuwa nunae-una atu kasa naunu gosinauwa. Ayero nawe dunu wari be daigairo aung yena. Arare kasa yenu gigiwa awong amimene bowi sao emo nuna yero bowi nuna Yuda emo eno keregatinowa. ");
INSERT INTO zia_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Aeno nae etu buro Bowi Iwaing niye eno eyero tugata nenane era: Nona Tuwa Bayau mene gitau aya-ewowo naname eno pugari senu tauyena, ");
INSERT INTO zia_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","nona awiya name saisibuna nuna nonane aeno pugaina. Awiya nung Yesu uwenu iropunu nona awiya name eno pugaina. Ge gayao awiya namba tu Sam auna atu eyero gayao mitiya, Ning awiya Mani nana ara. Na yeme Maung nina nena. ");
INSERT INTO zia_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Yesu uwai seka yero iropuro nete ago magayao nupema oko tamari niya auna Tuwa Bayau mene ge eyero sena, Na nona ipu ewa-gaewa yao Dawidi eno pugari sewang tauyena auna me awiya niye eno pugarinena ara. ");
INSERT INTO zia_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ora ge gayao zo eyero mitiya era, Ning emo nina dang awiya oko yangduwasa gung yero wurupariniya. ");
INSERT INTO zia_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Name Dawidira ungwe eyero nigiti nonane ara: Nung Tuwa Bayau mene buro sena awiya emo bauno dubu nuna eno yero besugairo magayena. Magayenu aya-ewowo nuna-una biritira atu pugaiwa gung yero wurupuna. ");
INSERT INTO zia_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Arata emo Tuwa Bayau mene uwenu iropuna amimene oko gung yero wurupao yena. ");
INSERT INTO zia_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Otao mani nana, sana nigipu. Tuwa Bayau mene emo awiya eno nasani pasena ninae disariniya. Auna bowi nuna mene ninae-una atu kasa yero niya ara. ");
INSERT INTO zia_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mosera sao tauyao ge mene pasena ninae-una bunao besao ine oko mitiya. Arata Yesu tumo diyaya aune pasena ninae-una bunao apakana besariniya. ");
INSERT INTO zia_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ora porofete mene ge gaewa ge amimene ninae-una me yoiye sero, niye giro baingtipu. Ge awiya eyero mitiya era, ");
INSERT INTO zia_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Oiye, Tuwara ge awang sao emo, niye giro yangka sero yoreba magayepu. Na Tuwa Bayau mene buro zo niye naya be aune yarinena. Buro auna bowi awiya zo mene sai niye nigiro gaya me oko yariniya. Ge gayao ayero mitiya.” Paulo mene ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pauloto Banaba awongto yere ibura atu kasa daung yari sero newato emo mene Sabat iya be zora atu ge dekaongka awiya nupema tugata yaetose sewa ara. ");
INSERT INTO zia_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ayewa awong augaora atu wosiro Yuda emo daigairo aune emo ena Yuda mene yaine yero nasani nauwa awong amimene awongto ago yewa giro Pauloto Banaba mene awong Tuwa Bayaura soremao awiya tumo diro naese wini ge sewato ara. ");
INSERT INTO zia_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sabat iya be nunae zo kasa yenu emo napo auna daigairo amimene Tuwa Bayaura ge nigari sero augaiwa. ");
INSERT INTO zia_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Augaiwa Yuda emo mene emo bauno diti bainane amimene atu augaiwa awiya giro kotumao meko Paulo eno puro ge nuna puro wosaine nasani nung giro sero izewa ara. ");
INSERT INTO zia_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ayero yewa Pauloto Banaba awongto tau yero ge sinasani eyero tugata yewato, “Yuda emo niye Tuwa Bayaura ge gitau nigaese sao mitiya ara. Arata niye nika niyetope awang sinasani ‘Nae nao me iwaingna gerao yaine yao teng oko,’ ayero sineya, arare nato niye doro emo Yuda oko auna-una babari nenato ara. ");
INSERT INTO zia_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tuwa mene wini ge nae eno eyero sena, Nane ning emo Yuda okora waegao ine yasese pugaingwa. Arare emo bauno tawing sero sero yero nowa awong aeno ge tugata yasa sorero pumane.” ");
INSERT INTO zia_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ayero sewato emo Yuda oko amimene nigiro dubo iwaing yenu Tuwara ge eno yawa yawa nasani dawong yawero nigiwa ara. Nao me iwaingna gerao mene Yesu tumo diwa ara. ");
INSERT INTO zia_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ayewa Tuwara ge mene tawing auna atu napo sero sero teng yero baungna. ");
INSERT INTO zia_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Arata Yuda emo mene ge iwero ge pasinasani bauno ena yazore Yuda emo aune yere sinauwa arita napora emo gitau yao auna dubo gaewa ara. Ayero yero tairo Pauloto Banaba iwo nasani tawing nunae-una tanona atu tunewa bamuwato ara. ");
INSERT INTO zia_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Bautu nasani pasena nunae-una mitina awiya gaese sero awong pu bautara gairo te nunato una atu popo nunae dureregaiwato wosinu Aikoniam nape bamuwato ara. ");
INSERT INTO zia_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Yesura dubu Antiok nape atu nasani nauwa amimene yawa yawa bainakama yewa. Nupema Oweno mene nunae-una mokora bebuna arauwa. ");
INSERT INTO zia_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pauloto Banaba Aikoniam nape kasa yero Yuda emora yere ibu auna dema toiro ge tugata yewato gigiwa me yena. Gigiwa me yenu Yuda emo aune Grik emo daigairo mene Yesu tumo diwa ara. ");
INSERT INTO zia_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Arata Yuda emo ena awong Tuwara ge awang sero emo Yuda oko ena dubo gaewa Kristora dubu eno tini kapao pumuwa. ");
INSERT INTO zia_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Arata awongto saineba sero ino ena napo auna atu nasani nauwato ara. Atu nasani Tuwara una desetiro ge nuna awang yao aung sinasani mono nuna-una bowi ge tugata nauwato Tuwa mene ge nunato awiya ge me, awiya gaese sero awongto soreunu tani putoungne ena yewato ara. ");
INSERT INTO zia_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ayero yewato napo auna emo awong gausero ena Yuda emore taiwa, ena aposolo etobe aune taiwa. ");
INSERT INTO zia_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ayero yewa giro emo Yuda oko ena aune Yuda emo ena aune gitau yao nunae amimene aposolo etobe aeno nao meko yari sero o daba mene dari sero ge tiwa ara. ");
INSERT INTO zia_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ayero yewa giro awongto napo awiya mena yangdoro baung Likonia tawingna yewato ara. Tawing auna atu nasani Listera napeta Derebe napeta napo enana baungno ");
INSERT INTO zia_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Bowi Iwaing sero bautunasani nauwato arauwa. ");
INSERT INTO zia_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listera nape atu emo zo mitauna nung te magayao. Nung aira tiyangna atu deka ayao kasa yero ura dekaongna atu puma-sauma yao aung adungno gege mitasani nauna. ");
INSERT INTO zia_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Adungno mitasani Paulo mene emo bauno eno ge tugata nena awiya nigiti nasani mitinu Paulo mene diti ye nuna-una gairo tumo diyao nuna gigina awiya nung kara iwaing yaine yao teng awiya gigina. ");
INSERT INTO zia_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Giro yanakana yau sero eyero sena, “Ning te nina itetiro patiro iropuro dope.” Ayero senu emo awiya mena iropuro ang yero puma-sauma yena. ");
INSERT INTO zia_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ayero yenu emo dubu bainakama awong Paulo mene tani yena awiya giro wawa sero Likonia ge nunae-una eyero sewa, “Uritira Tuwa mene emo ine yero naname-una kasa yero miteyato era.” ");
INSERT INTO zia_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ayero sinasani Banaba maze tuwa etegao nunae zo yazo Zus auna yazo sewa. Anasani Paulo mene ge daigairo sinasani nauna, aeno tuwa etegao nunae zo yazo Hemis auna yazo sewa. ");
INSERT INTO zia_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Tuwa etegao yazo Zus auna zawing pugao ibu napo atura mitina. Ibu auna zawing pugao emo amimene senu bulimakao dire aune i wuzi piyao enane puro wosiro goma towao bera atu aposolo etobe aeno zawing pugari sero yewa. ");
INSERT INTO zia_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ayero yewa Banabato Paulo mene nona awiya giro dubo mininasani taung wori nunato iniwato kerenu suno baung emo dubu baina auna-una towang yero ge puro suwamuro eyero sewato, ");
INSERT INTO zia_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Oiye, niye noeno ayero nei? Nato emo gege. Nato niye ine ara. Niye tuwa etegao awiya yangdoro Tuwa naore awiya tumo diyaese Bowi Iwaing nuna niye eno sinenato. Nune uritire tawingne witore nona apakana yero aung yena. ");
INSERT INTO zia_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Gitau nasani nauwa be aune emo dubu sero awong niginu nao susuwa giti taungno nasani nauwa. ");
INSERT INTO zia_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Arata nung susuwa nuna oko pungyena. Susuwa nuna gaese mono iwaingne nasani sinoi uritira atu wa wowosinoi zamena simena kasa yero noi niye mininasani yawa yawa yero nasani yero nowa ara.” ");
INSERT INTO zia_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Aposolo etobe mene ge ayero sinasani awongto eno zawing pugao awang sewato awong ge nunato daine yewa arauwa. ");
INSERT INTO zia_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ayero yewa awongto atu newato Antiok napo zora-ta Aikoniam napora Yuda emo ena kasa yero emo bauno dubo uwero awong tairo Paulo daba mene dewa ara. Dewa magayenuta ayero sero watiuno puro baungno napo bautara atu pugaiwa. ");
INSERT INTO zia_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Atu pugaiwa mitinu Yesura dubu mene au gairo nung ziuno mitiwa nung iropuro napo auna nupema toiro baungna. Ayero yenu iya gainu nung Banaba puro napo awiya doro Derebe nape bamuwato ara. ");
INSERT INTO zia_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Baungno atu Bowi Iwaing sewato emo daigairo mene nigiro Yesura dubu yewa ara. Ayero yewa awongto nagibo bamuwato deka auna yesese yero Listera, Aikoniam, Antiok nape kasa yero bamuwato ara. ");
INSERT INTO zia_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Nape kasa yero Yesura dubu tauyaese o tumo diyao nunae tauyero mitaise sero wini ge ena sewato ara. Wini ge sinasani eyero sewato, “Name yayara tame atu nete Tuwa Bayau nata Tuwa yero noiya auna nape babanenese sao ara.” ");
INSERT INTO zia_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ayero sinasani napo dekaong dekaong auna atu emo ena yangtagairo puro nona seminiro isa sinasani aune emo awiya dubura gitau yao yaese sero burora pugaiwato ara. Burora pugairo Tuwa tumo didinauwa auna waweng pugati nasani Tuwa eno isa sero aune doro bamuwato arauwa. ");
INSERT INTO zia_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Awongto Pisidia tawing busero bautunete Pamfilia tawingna kasa yewato ara. ");
INSERT INTO zia_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Atu kasa yero Pega nape atu Bowi Iwaing tugata yero aune wosi Atelia nape yewato ara. ");
INSERT INTO zia_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Atu wosiro wangna witiro bautunete Antiok nape kasa yewato. Gitau napo auna atu Yesura dubu mene awongto Tuwa Bayau mene diya yai buro nuna yaetose burora iyengtiwa bamuwato ara. Arare buro awiya zayero nawe besugairo nupema yesese yero bumuwato ara. ");
INSERT INTO zia_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Buro kasa yero Yesura dubu sewato augaiwa Tuwa Bayau mene awongto soreunu buro yewato, o Tuwa Bayau mene emo Yuda oko eno tumo diyaora nagibo gipenu tumo diyaore yewa, auna ge ungwe apakana yero aung yewato ara. ");
INSERT INTO zia_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Awongto be imokore ine Yesura dubu aune dema nasani nauwato arauwa. ");
INSERT INTO zia_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Emo ena mene Yudaya tawingna atu wosiro Antiok nape kasa yero Yesura dubu eno eyero sewa, “Niye taung aingso kapaora tani Mose mene yanenese sena auna teng taung aingso ninae oko kapao yarineya, awiya Tuwa Bayau mene niye oko sorero pumariniya.” ");
INSERT INTO zia_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ayero sewa Pauloto Banaba mene awong gona yewato ge bainakama betinewa giro dubu mene eyero sewa, “Pauloto Banaba aune ge nigao emo ena awong ge awiya aposolo dubu ena Yerusalem nape atu nasani gera gitau yao yero nowa, awong auna-una puro babaese.” ");
INSERT INTO zia_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Dubu mene ayero sero iyengtiwa bamuwa. Bautunasani Fonisia tawing busero Samaria tawing busero buwagati nasani Yesura dubu atu nasani nauwa aeno ge eyero tugata yero bamuwa, “Emo Yuda oko daigairo mene gera mokora toitineya.” Ayero tugata yewa nigiro yawa yawa bainakama yewa ara. ");
INSERT INTO zia_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Paulo dubu aune bautunete baungno Yerusalem nape kasa yewa Yesura dubu aune aposolo aune gera gitau yao mene awong arugairo yawa yawa yewa ara. Ayero yewa awong Tuwa Bayau mene soreunu buro yewa me yena auna ungwe-maungwe yewa ara. ");
INSERT INTO zia_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ungwe diwa aung yenu Yesura dubu auna ena awong Farisayora dubu aune tairo nasani nauwa amimene eyero sewa, “Emo Yuda oko taung aingso nunae kapaese sao mitiya. Nupema sao tauyao ge Mose mene gaena awiya dimaese sero tugata yepu.” Ayero sewa arauwa. ");
INSERT INTO zia_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Aposolo aune gera gitau yao aune awong ge awiya kora yari sero augaiwa. ");
INSERT INTO zia_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Augairo ge buro nasani mitiwa Petoro mene iropuro ge eyero tugata yena, “Otao mani nana, gitau buro zayewangne be aune nane Bowi Iwaing emo Yuda oko eno tugata yana nigiro Yesu tumo diyaese Tuwa Bayau mene naname una atu na puro buro auna pugaina, awiya gosineya. ");
INSERT INTO zia_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Arare na buro yewang Tuwa Bayau nung emora dubo gosinoiya amimene Yuda emo name eno Oweno pugaina deka ayero emo Yuda oko eno pugati nasani tumo diyao nunae teng ayero sena ara. ");
INSERT INTO zia_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Awong Yuda oko ewe, name Yuda ewe, ayero oko sena. Awong nung tumo diwa giro dubo nunae saero kora nasani name eno yena deka ayero awong eno yena ara. ");
INSERT INTO zia_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mosera sao tauyao ge dimao awiya buro mou-mesa yao, arare niye noeno Tuwa Bayau gaero gari nasani buro ge awiya Kristen eno pugari sinei? Aya-ewowo naname arita name dema buro ge mou-mesa yao awiya dimao ine teng oko ara. ");
INSERT INTO zia_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Arata name eyero gosinonane ara: Tuwa Bayau mene Tuwa Yesura mono iwaing auna emo Yuda oko sorero pungna, deka ayero nung name Yuda emo sorero pupuniya.” Ayero sena arauwa. ");
INSERT INTO zia_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ayero senu emo augaora atu mitiwa awong amimene apakana ge aung yero mitiwa ara. Mitiwa Banabato Paulo mene Tuwa Bayaura burora nauwato be aune emo Yuda okora una atu tani p