﻿USE sofia;
DROP TABLE IF EXISTS sofia.zgam_vpl;
CREATE TABLE zgam_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zgam_vpl WRITE;
INSERT INTO zgam_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ikhitabu eikya khikolo eikya Yeisu Klisiti mwana va Ibrahimu. ");
INSERT INTO zgam_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","U Ibrahimu ale vise va Isakha, nu Isakha ale vise va Yakobo, nu Yakobo ale vise va Yuda nu vukolo vake. ");
INSERT INTO zgam_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","UYuta ale vise va Pelesi nu Sera khwa Tamali, uPelesi vise va Hezeloni, nu Hezeloni vise va Ramu. ");
INSERT INTO zgam_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","U Ramu ale vise va Aminadabu, Aminadabu vise va Nashoni, nu Nashoni vise va Salimoni. ");
INSERT INTO zgam_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","U Salimoni vise va Boazi khwa Rahabu, u Boazi vise va Obedi khwa Luti, u Obedi vise va Yese, ");
INSERT INTO zgam_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","u Yese ale vise vantwa u Daudi. U Daudi ale vise va Sulemani khu dala va Uria. ");
INSERT INTO zgam_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","U Sulemani ale vise va Rehoboamu, Rehoboamu vise va Abiya, Abiya vise va Asa. ");
INSERT INTO zgam_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","U Asa ale vise va Yehoshafati, Yehoshafati vise va Yoramu, nu Yoramu vise va Uzia. ");
INSERT INTO zgam_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","U Uzia ale vise va Yothamu, u Yothamu vise va Ahazi, Ahazi vise va Hezekia. ");
INSERT INTO zgam_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","U Hezekia ale vise va Manase, u Manase vise va Amoni nu Amoni vise va Yosia. ");
INSERT INTO zgam_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","U Yosia vise va Yekonia na vavahave useikhi ugwa khutoliwa ukhuluta khu Babeli. ");
INSERT INTO zgam_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Va vile vatoliwe ukhuluta khu Babeli, u Yekonia ale visa va Shatieli, Shatieli ale khukhuye va Zerubabeli. ");
INSERT INTO zgam_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","U Zerubabeli ale vise va Abiudi, Abiudi u vise va Eliakimu, u Eliakimu vise va Azori. ");
INSERT INTO zgam_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azori vise va Zadoki, nu Zadoki vise va Akimu, nu Akimu vise va Eliudi. ");
INSERT INTO zgam_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","U Eliudi ale vise va Elieza, nu Elieza vise va Matani nu Matani vise va Yakobo. ");
INSERT INTO zgam_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","UYakobo vise va Yosefu ugosi va Maliya uvi umwene UYesu aholiwe, uveikhilangiwa vei Kilisite. ");
INSERT INTO zgam_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ifivumbukhu fyooni ukhuhuma khwa Ibrahimu impakha khwa Daudi fyale ifivumbukhu kumi ni fine, ukihuhuma khwa Davidi impakha ukhutoliwa ukhuluta khu Babeli ifivu mbukhu kumi ni fine nu khutoliwa ukhuhuma khu Bababeli impakha kwa kilisite ifivumbukhu kumi ni fine. ");
INSERT INTO zgam_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ukhuholiwa khwa Yeisu khwale nde. Umamaye, UMaliya, UYosefu, vu ahilikhe eindanda sakha, vuva khamale ukhutolana pu UMaliya akhavonekha ukhuta aleinonehigo mumakha ga mepo umbalanche. ");
INSERT INTO zgam_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ugosi va mwene u Yosefu ale munu golofu sanogwe ukhukoncha isoni pa vanu. Pu akhalamula ukhundekha u ng'eincha va mwene khuvutitu avanu khitaluanya. ");
INSERT INTO zgam_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pu avile isaga ndavule usuhwa Vantwa akhambonekhela mu njosi, akhata, “Yosefu mwana va Daudi, ulekhe ukhudwaada ukhutola uMaliyamu ndu dala vakho, ulwa khuva unchigo ugwaleinagwo gwa makha gamepo umbalanche. ");
INSERT INTO zgam_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Puyaihola umwana udeemi puyavukhupa eitawa lya mwene vei Yesu, ulwa khuva ayikuvapo kha avanu va mwene.” ");
INSERT INTO zgam_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Aga gooni gahumile ukhuvonesya khila eikhikhyanchoviwe nu Ntwa ukhugendela munya malago vuita, ");
INSERT INTO zgam_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Lola, ung'enja uvisagonile nu gosi lusikhu pu iva nu chigo nu khuhola umwana udeemi, puvikhumwilangaga eilitawa lya mwene Imanueli”— khukhuta uNguluve paninie nufwe.” ");
INSERT INTO zgam_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","U Yosefu akhasisimukha mutulu nukhugaha nduvu usuhwa va Nguluve ambulile ukhuta atole ave idala va mwene. ");
INSERT INTO zgam_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pu leino sa gone nave impakha avile aholile umwana udeemi pu akhamwilanga eitawa lya mwene vei Yesu. ");
INSERT INTO zgam_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","U Yesu avile aholiwe mu Bethelehemu ya vayuta mufigono fya Nkuludeva u Herode, avanu avamanyi va nondwe ukhuhuma khuvuhumo wa linchuva vakhafikha khu Yerusalemu vakhata, ");
INSERT INTO zgam_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Aleindakhu umwene uviaholiwe unkuludeva vava yuta? Tuvye tuyeiwene einondwe ya mwene khuvuhumo wa linchuva nufwe pu twinchile khukhumwimikha.” ");
INSERT INTO zgam_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Useikhi ugu unkuludeva u Helode aviile apulikhe akhakalala, na yei Yelusalemu yooni paninie na yumwene. ");
INSERT INTO zgam_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","U Helode akhavalundania avavaha vava tekhenchi vooni na visimbi va vanu, pu akhavuncha, “U Klisiti ayoiholiwa ndakhu?” ");
INSERT INTO zgam_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Vakhambula, “Mu Bethelehemu yava yuta, ulwa khuva vuyisimbiwe nu nyamalago. ");
INSERT INTO zgam_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Nuve Bethelehemu, mukhilunga eikya va yuta suleideebe muvalongonchi vava Yuta, pakhuva ukhuhuma khulyuve ikhwincha umbaha uviyakhiva ikhuvadeemaga avanu vango Israeli.” ");
INSERT INTO zgam_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pu leino u Helode akhaviilanga avamanyi va nondwe khuvutitu akhavavuncha gyu seikhi guleikhu ugu einondwe yeivile yeivonikhe. ");
INSERT INTO zgam_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Akhavasuha khu Bethelehemu, akhata, “Mlutage einjila eiyie mkhavunche fincho umwana uvyaholiwe. Pu mungambone mwinche mumbule ukhuta nayune puninche neimwimeekhe.” ");
INSERT INTO zgam_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Puvavile vapuleihinche unkuludeva puva khava vanu va khuluta, pu einondwe yeila uyuvakhayiwene khuvuhumo wa linchuva yeikhavalongolela impakha upu ya eimile pala upu umwana uvyaholiwe upu ale. ");
INSERT INTO zgam_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Useikhi uguvayiewene einondwe va howikhe fincho. ");
INSERT INTO zgam_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Vakhingeila munyumba puvakhambona umwana nu mamaye u Mariamu. Vakhamwinamila nukhumwimekha, vakhavopola ifipakho fyavo vakhambonola uluvonolo ulwa lutalama, uvufumba ni mono inonu. ");
INSERT INTO zgam_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","U Nguluve akhavavula munjosi valekhe ukhukilivukha khwa Helode, puvakhahega ukhuluta khumyavoyo puvakhagenda einjila eiyeinge. ");
INSERT INTO zgam_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Puva viile vahegile, usuhwa vantwa akhambonekhela u Yosefu munjosi nu khuta, “Wime, utole umwana nu mamaye pumunyileile khu Misiri. Muve khukhukhwa impakha yakhiva nikhuvavula ulwa khuva u Helode ilonda ukhwangamencha umwana. ");
INSERT INTO zgam_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ikilo eiyo pu u Yosefu akhasisimukha nukhutola umwana nu mamaye pu vakhanyileila khu Misili. ");
INSERT INTO zgam_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Atamile ukhu impakha u Helode avile afwile. Eiyie puyiekhavombekha nduvu uNtwa anchovile ukhugendela khu nyamalago, “Ukhuhuma khu Misili ni mwilangile u manango.” ");
INSERT INTO zgam_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pu u Helode aviile awene akalaliwe na vanu avamanyi va vanu avamanyi va nondwe avipile fincho. Pu akhalageila ukhubudiwa avana vooni avadeemi avu vaale mu Bethelehemu na vooni avuvale nkilunga khila avanya miakha givili na pasi pa miakha eigyo ukhukongana nu seikhi ugu amalile ukhulumanya khuvamanyi va nondwe. ");
INSERT INTO zgam_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Leino pulikha leikwilanile eilimenyu leila eileilyanchoviwe nu ndomo gwa nyamalago u Yelemia, ");
INSERT INTO zgam_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Eingolo ya puleikhikhe khu Ramah, eikhileilo nu lyoveelo uluvaha, u Raheli wikhuva leileila avana va mwene pu akhabeela ukhunchesiwa ulwa khuva vasipali hange.” ");
INSERT INTO zgam_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","U Helode avile afwile, lola usuhwa va Ntwa akhambonekhela u Yosefu mu njosi ukhu khu Misili nu khuta, ");
INSERT INTO zgam_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Wime utole umwana nu vanina pu mlutage mukhilunga eikya mu Israeli ulwa khuva avakhalondaga uwumi wa mwana vafwile.” ");
INSERT INTO zgam_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","U Yosefu akhima akhatola umwana na vanina puvakhincha mukhilunga ikhya mu Israeli. ");
INSERT INTO zgam_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Puleino aviile apulikhe ukhuta u Arikelau ale mbaha va valongonchi khuva Yuta ahalile pa vise va mwene u Helode, adwaadile fincho ukhuluta ukhwa. Pu uNguluve avile ambulaninche munjosi akhahega ukhuluta khukhilunga eikhya khu Galilaya ");
INSERT INTO zgam_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","pu akhaluta khutama mumbunchege uwa khu Nazareti. Pu ukhuta leivombekhe eilimenyu leila eili lyamalile ukhunchoviwa navanyamalago ukhuta ayikhelangiwagwa Mnazareti. ");
INSERT INTO zgam_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Pu mufigono fila u Yohana uveiaonchaga aleikhulumbelila munyikha incha va Yuta, ");
INSERT INTO zgam_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mpelage inongwa ulwa khuva uludeeva lwa khukyanya lu leipipi.” ");
INSERT INTO zgam_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ulwa khuva uyu vei mwene anchoviwe nu nyamalago u Isaya aleikhuta, “Ngolo ya munu uvei alei ndukungu, munonchage einjeila ya Ntwa, mgolosyage umwa khuluta umwene.” ");
INSERT INTO zgam_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Leino u Yohana aafwalile amanchwa ga ngamia nu lukata lwa ngwembe mukhi vina khya mwene. Eikhya khulya khya mwene khyale imanji nu wuukhe uwa mumisitu. ");
INSERT INTO zgam_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Pu ei Yelusalemu, ni Yuta yooni ni khilunga khyoni eikhinchungula ulugasi ulwa Yolodani pu valei khunduteila umwene. ");
INSERT INTO zgam_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Puvaleikhyonchiwa nu mwene mundugasi ulwa Yolodani khunu vipela inogwa nchaavo. ");
INSERT INTO zgam_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Puleino avile avawene ava falisayo na vasadukayo valeikhwincha khumwene khukhyonchiwa akhava vula akhata, “Umwe mwiva khivumbukhu khya njokha veeni uvei ava vuulile umwe ukhukimbela uluviipo uluyakhiva lwikhwincha? ");
INSERT INTO zgam_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Muvoniage eisekhe inchino gelanile nu vupeli. ");
INSERT INTO zgam_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Pu mulekhe avange ndyumwe ukhusaga nu khwincho fanja, 'Tuleinave u Ibrahimu ndu daada yeito.' Ulwa khuva u Nguluve avahile ukhumwimekhila umwana ukhuhuma mumawe aga. ");
INSERT INTO zgam_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Einjunu puyeimalile ukhuveikhiwa mfikolo fya mabeikhi. Puleino khila beikhi ugu sagu houpa isekhe inonu pu gugeidiwaga nukhu laheila mu mwoto. ");
INSERT INTO zgam_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Pu une nikhuvoncha na magasi savuli ya khupela. Pu leino umwene uveikhwincha musana ndyune vei mbaha ukhunduteiila une, na yune saneinogile ukhugega ifilato fya mwene. Pu umwene ikhuvonchaga khu mepo umbalanche nu mwoto. ");
INSERT INTO zgam_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Uvie umwene ulupeetelo luleimavokho nu mwene pwi nonchaga fincho eikhyaalo khya mwene nukhulundania einganu mukhibaana khya mwene. Pu leino amapuna pwi nyanyaga mu mwoto ugusagwinchima. ");
INSERT INTO zgam_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Pu u Yesu akhincha ukhuhuma khu Galilaya impakha khulugasi ulwa Yolodani khukhyonchiwa nu Yohana. ");
INSERT INTO zgam_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Puleino u Yohana aleikhunogwa ukhu beencha aleikhuta, “Une ninogwa ukhyonchiwa nuve, uve puvukhwincha khulyune?” ");
INSERT INTO zgam_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","U Yesu akha mwanda akhata, “Weideekhe ulu leino ulwa khuva yeilondiwa ukhutekhelesya eilweli yooni.'” Pu akhamweideekha. ");
INSERT INTO zgam_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Pu aviile amalile ukhyonchiwa, pu u Yesu akhahuma mumagasi, pu u Yesu akhahuma mumagasi, pu nilola ikyanya nchikhade indukha. Pu akhambona umepo va Nguluve vu ikhwincha ndei khihwani khya ngundya pukhikhalitama pa mwene. ");
INSERT INTO zgam_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Lola, eingolo eikhahuma khukyanya eiyiita, “Uyu vei manango ugane, uveinihovokha fincho nu mwene.” ");
INSERT INTO zgam_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pu leino u Yesu akhalongonjwa nu Mepo impakha khu lukungu ukhuta ageliwe nu tavangwa. ");
INSERT INTO zgam_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Pu akhideenda ukhulya isikhu alubaini pamusi na pakilo, pu akhipuleikha einchala. ");
INSERT INTO zgam_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Pu leino ugeli akhincha pwakhambula akhata, “Unave uve ulie mwana va Nguluve gavale amaganga aga gave fisyesye.” ");
INSERT INTO zgam_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pu Yesu akhamwamula akhata, “Yeisimbiwe u munu sayitamaga ni khisyesye khyeene khisita limenyu eilihuma mndomo gwa Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pu utavangwa akhangileikha muvunchenge uvuvalanche pu akhambeikha patembile baho pa hungile fincho, ");
INSERT INTO zgam_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","pu akhambula akhata, “Ungave uve uleimwana va Nguluve, weilaheile pasi ulwa khuva yeisimbiwe ikhuvavula avasuhwa vamwene vikhu khyupeila mumavokho ga va veene, ulekhe ukhukuvala eikhilunde khyakho muliwe.” ");
INSERT INTO zgam_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","U Yesu akhambula akhata, “Yeisimbiwe, 'Ulekhe ukhugela uNtwa vakho u Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pu leino, utavangwa akhaatola nu khumbeikha baho pahangile ukhuluteilila fincho pu akhambonesya uvukuludeeva wooni uwa kilunga nuvunonu wa incho nchooni. ");
INSERT INTO zgam_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Pu akhambula akhata, “Punikhukhupa eikhyuma khyooni ikhi ungave vukhunyimikhaga nu khwisuya khulyune.” ");
INSERT INTO zgam_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pu uYesu akhambula akhata, “Lutaga uhege apa, veitavangwa pakhuva yeisimbiwe umwimikhage uNtwa uNguluve vankho nukhumbombela umwene mwene.” ");
INSERT INTO zgam_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pu utavangwa akhandekha, pu lola avasuhwa vakhincha vakhambombelela. ");
INSERT INTO zgam_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Pu uYesu avile apulikhe ukhuta uYohana va mwibite akhahega nu khuluta khu Galilaya. ");
INSERT INTO zgam_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Akhahega khu Nazareti pwa khaluta khutama khu Kaperanaumu, eiyileikhunji mnyanja ya Galilaya, ukhupakhana ni khilunga eikhya Zabuloni nu Naftali. ");
INSERT INTO zgam_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Eiyi yahumile ewo ukhuvonesya eikhyukhyanchoviwe nu nyamalago u Isaya, ");
INSERT INTO zgam_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Mu mbunchenge uwa Zabuloni nu vunchenge wa Naftali, ukhulonha khunyanja eimwambo ya Yolodani, Galilaya ya vapanji! ");
INSERT INTO zgam_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Avanu avatamile muhisi valuwene ulumuli uluvaha, na vala ava vatamile muhisi ya vufwe mumbeene ulumuli luvamulikhe.” ");
INSERT INTO zgam_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ukhuhuma apo u Yeu akhatengula ukhulumbeileila nukhuta, “Mpelage imbivi pakhuva uludeeva ulwa khukyanya lulipipi.” ");
INSERT INTO zgam_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Avile igenda mundukanji mwanyanja ya Galilaya, akhavavona avana munu vaveili, u Simoni uvie ailangiwagwa Petro, nu Andreya umbahave, valie khutega inyaafu munyanja ulwa khuva vale valovi va somba. ");
INSERT INTO zgam_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","U Yesu akhavavula, “Mwinchage mang'ongage, punikhuvaveikha valovi va vanu.” ");
INSERT INTO zgam_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Khimbeivimbeivi vakhanchilekha inyaafu pu vakhakonga. ");
INSERT INTO zgam_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nu Yesu akhaluta pakhimbale akhavavona avana munu vaveili, u Yakobo umwana va Zebedayo, nu Yohana umbahave, vaale muwaato nu Zebedayo u vise vavo vahonaga inyaafu nchaavo akhavielanga, ");
INSERT INTO zgam_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","akhaseikhi ndakhuleikhu vakhavulekha uwato paninie nayu vise vavo vakhakonga. ");
INSERT INTO zgam_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Pu uYesu agendile mu Galilaya pakhasigala padebe ukhumala yooni, pwaleikhu manyisya mumasinagogi gaavo nukhulumbeileila eilivangeili lya ludeva nu khuponia uvutamu uvulipapingi mumbano. ");
INSERT INTO zgam_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Pu ikhulongu ncha mwene chikha vaala mu Siria mwoni, pu avanu vakhincha vooni avuvale nuvutam uvalipapingi uvu wa pelaga uluvavo, uvavale ni mepo imbivi na vanyaligonchi na vavo vafwile eiganji emiveili gyavo. ");
INSERT INTO zgam_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ni fipuga fingi ifya vanu filikhukonga ukhuhuma khu Galilaya na khudekapuli mu Yelusalemu na mbu Yuta nu khuhuma eimwambo ya mu Yolodani. ");
INSERT INTO zgam_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Navope aviile avawene ifipugu fya vanu akhatoga khukhyamba. Pu avile amalile ukhulama, avakongi va mwene vakhincha. ");
INSERT INTO zgam_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Pwakha deendula undomo gwa mwene akhanja ukhuvamanyisya, nu khuta, ");
INSERT INTO zgam_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Huba vala avaganchu va numbula manya uluudeva lwa khukyanya lwavo. ");
INSERT INTO zgam_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Huba avanya lususuvalo, manya avo yaviachesiwagwa. ");
INSERT INTO zgam_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Huba avanyakhisa, manya avo vala khihala ikhilunga. ");
INSERT INTO zgam_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Huba avanya njala ni khyumilwa ikhya yeilweli, manya avo valigutaga. ");
INSERT INTO zgam_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Huba vula avanya lusyikhilo manya avo valasyeikhiliwagwa. ");
INSERT INTO zgam_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Huba avanya numbula inonu manya avo yavikhumbona uNguluve. ");
INSERT INTO zgam_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Huba avavisayania, manya avo vikhilangiwagwa vana va Nguluve. ");
INSERT INTO zgam_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Huba avaviveipeiliwa savuli ya vuyeilweli manya uludeeva lwa khukyanya lwavo. ");
INSERT INTO zgam_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Huba umwe yumwe avanu yavikhuvadukhaga nukhuvapa uluvungu nukhuva uvuvivi umwe nukhuvadelela savuli yango. ");
INSERT INTO zgam_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Muhovokhage nukhulu lutila, manya ulutalama lwinyo luvaha khukyanya ulwa khuva vuyeilievyo avanu vava vungaga avanya malago avuvalekhyo umwe vu mukhanale. ");
INSERT INTO zgam_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Umwe mulei mwoyo gwa khilunga. Pu einave umwinyo guyanchinche uvunonu wa gwene, pu yiva ndakhikhi ukhuta yuve nonu khange? Pu nalusikhu sagwiva nonu khu khinu eikhinge khyukhyoni, puleino pugwiva gwa khutaga khunji nukhukadiwa na vanu. ");
INSERT INTO zgam_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Umwe muleilumuli lwa khilunga. Uvunchege uwuvunchengiwa pakyanya pakhyamba savufihama. ");
INSERT INTO zgam_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Na vavanu saviwasya einyali nu khuveikha pasi pakhisanja, pu vi veikha pavuhagufu, puyikhuva muleikhaga voni avahei mgati munyumba. ");
INSERT INTO zgam_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Pumululekhe ulumuli lwenyo lumuleikhage mbulongolo mu vanu munjeila eiya khuta avanu vanchivonage imbombo inonu ndyumwe nu khumwimikha uDaada yeinyo uva khukyanya. ");
INSERT INTO zgam_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mlekhe ukhuta ninchile khudenya ululageilo vave vuvanya malago saninchile khudenya punichele khwinoncha nukhugolosya. ");
INSERT INTO zgam_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Pu lweli nikhuvavula ukhuta pu napakha ikyanya ni khilunga fyooni filute, khisikhuli eikhigelelo nakhimo eikhya lulagilo ulu yakhiva lwihega, pu mpakha apo upoyakhiva khila khinu khiva khikwilanile. ");
INSERT INTO zgam_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Pu leino umunu uveiavenchaga uveideenya ululagilo uludeebe loninie mundagilo inchi nukhuvanyisya akange ukhudeenya uywa puikhilangiwaga ideebe muludeva lwa khukyanya. Pu ula uveikhunchibata nukhuvamanyisya avange uywa ikhilangiwaga imbaha muludeeva lwa khukyanya. ");
INSERT INTO zgam_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Manya nikhuvavula ukhuta einave uvugolofu weinyo savulutiila, mumbogolofu wa vasimbi va kalata na Vafalisyao, pusamuleingile lusikhu mundudeeva ulwa khukyanya. ");
INSERT INTO zgam_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mupoulikhe ukhuta avanu ava khatale vavuliwe ukhuta, ulahudaga nu munu ubudi panogile ukhuheigiwa.' ");
INSERT INTO zgam_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pu leino une nikhuvavula ukhuta umunu unyaluviipo khu niine punogile ukhuheigiwa, umunu uveikhinchifula nukhusula ulukololwe panugile ukhuheigiwa palulundamano lwa vaheigi nu munu uveikotola vivakhulahiwa mundugadu ncho ulwa mwoto ukali. ");
INSERT INTO zgam_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Puleino unave vuheileikha isadakha ya panekhelo yakhutekhela khuntwa, punakhumbukhe ukhuta uleininogwa nu lukololwo ikuta nuve, ");
INSERT INTO zgam_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","pu yeilekhe isadakha eiyo pala panekhelo, pu beite tasi ukhideehane nulukololwo, pukilivukhe khwilaha isadakha yakho. ");
INSERT INTO zgam_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Weideehane nu munu uveitutile inogwa khumwene, weideikhe khimbeivi mbeive vumuleimunjeila mwiluta khubalasa, pu unave savukhwidehana nave munjei pu ula uveiutulile einongwa khumwene avahile ukhukhulekha khumbaha vavuheigi wa nongwa pu ula ikhukhuheilikha mmavokho ga vasikhali puvikhukhudeindeila mundu pala nie minyololo. ");
INSERT INTO zgam_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Pu weideikhe ukhu nalusikhu sakha khudekhepele winchiga ukungiwe mulamula vusuhombile eihela ya mwene impakha yakhiva vuhomba yooni. ");
INSERT INTO zgam_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Mupulikhe ukhuta, linchoviwe eilita ulaligupaga.' ");
INSERT INTO zgam_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pu une nikhuvavula niita umunu ikhundola udala mumbunogwe uywa amalile ukhuligupa nave munumbula ya mwene. ");
INSERT INTO zgam_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Enave eiliho lyakho eilya khundyo likhukhupela uvunangi pu uleihenche utage khuvutali nuve. Ulwa khuva huba uve mbula khamagikha khaninie. Pu umbeili gwakho gwooni gulekhe ukhutagiwa mundugaduncho la mwoto. ");
INSERT INTO zgam_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Pu ni khivokho khyakho eikhya khundyo khinga khupele uvunangi pugeide, utage khutali nuve. Manya panogile uve mbulakhimagikha khininie, pu umbeili gwakho gyooni gulekhe ukhutagiwa mundugaduncho lwa mwoto. ");
INSERT INTO zgam_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Leinchoviwe eilita, uveihumya udala nukhupa eikalata eiyiita niswimile udala uyu.' ");
INSERT INTO zgam_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pu une nikhuvavula niita, uveihumya udala va mwene vusaligwipe, pu ikhupela aveindigu na vanu avange pu umunu uveitola udala uvalekhiwe nu gosi va mwene uywa pu iva iligupa nave. ");
INSERT INTO zgam_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Mupulikhe ukhuta, vavuliwe ava viise veinyo ukhuta, 'Ulekhe ukhwijiega mbudesi, pu umwe mweijiagage khu Ntwa kwene uvwayeilweli. ");
INSERT INTO zgam_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pu une leino nikhuvavula niita, muleijieguga na padebe, khumela nu khuta manya nakhukyanya, ulwa khuva khyukhigoda eikhya Nguluve; ");
INSERT INTO zgam_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Khive mukhilunga manya pupakhuvikha amalunde ga mwene, yeive mwu mu Jelusalemu, pakhuva wuvunchenge uwankuludeva umbaha. ");
INSERT INTO zgam_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Khyumela nukhwijiega pakhuta, manya neilie nuntwe manya neilieninchwele pakhuva sawigela nukhupela ate uluywilei hata lumo ukhuta luve lu valafu yeive luve lutitu. ");
INSERT INTO zgam_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pu amamenyu geinyo gavenchage ga khuta, 'Ena, enave mukhweideihana, mutenchage khyomela enave samukhwi deihana.' Pa khuva agaluteilile pa ago gihuma mundugu. ");
INSERT INTO zgam_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Mupulikhe lisimbiwe eilita ukhwita, vuleila eiliho pa liho, eilino pa lino.' ");
INSERT INTO zgam_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pu leino une nikhuvavula niita, mulakilanaga nu munu umbivi; pu umunu anakhutove ni lipi khuvunchuga waakho uluvafu ulwa khundyo pupinchage nuluvafu ulunge lwope atove. ");
INSERT INTO zgam_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pu umunu anakhuheileikhe pavuheigi apokhe umwenda gwakho pu upinchage na gugunge. ");
INSERT INTO zgam_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Pu ula uveikhukhyumeilincha ukhugenda nu mwene eimaili yeimo pu gende nave imaili eveili. ");
INSERT INTO zgam_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Pu ula uveikhudova ifya khudova upeinchage, ula uveidova ukole upe ulekhe ukhusyetukhila khungosi. ");
INSERT INTO zgam_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Mu pulikhe leisimbiwe eilita uganage unino, unsoulage utavangwa.' ");
INSERT INTO zgam_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pu une nikhuvavula niita muvaganage avatavangwa veinyo, muvadovelage ulusayo vala avikhuvakotola muvavombelage inonu na vala vavo vavansoulile, ");
INSERT INTO zgam_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","pu muvenchaga vaana va Daada yeinyo uva khukyanya. Pakhuva umwene ikhuva muleikhila eilinchuva avavivi na vanonu, ifula ya mwene yeitima khu vagolofu navatava vagolofu. ");
INSERT INTO zgam_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Pumunave mukhuvagana vala vavo vavaganile umwe, pu muhombiwa khinukheikhi? Avasangunchi voope nchusavivoomba ndincho? ");
INSERT INTO zgam_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Hange munave musamusania mwivana munu yumwe, pu muvomba khinu khikhi ukhuluteila? Pu! avanu avapanchi nchu savivoomba ndiincho? ");
INSERT INTO zgam_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pu umwe muvenchage vagolofu nduvu u Dada yeinyo uvakhukyanya umwavelile igolofu. ");
INSERT INTO zgam_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Mweilolage mulekhe ukhuvomba uvugolofu weinyo pamiho ga vanu ukhuta nuvonekhe khuvene, pu munave mwigaha ewo pusamwikava uluhombo kwa Daada yeinyo uvaleikhukyanya. ");
INSERT INTO zgam_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Puleino vuleipakhuhumya isadakha yakho pulekhe ukhunkuva eingalape yuve nukhwiginia nduvu avanu avadesi umuvigahila munyumba ncha khwisayeila ukhuta avanu puvavakele, pu ncha yilweli. Lweli nikhuvavula niita, pu viva vakavie hani uluhombo lwavo. ");
INSERT INTO zgam_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pu uve vuwihumya, isadakha yakho ikhivookho khyakho eikhyaheigi kheilekhe ukhulumanya khila eikhyukhi vombiwa nei khivookho eikhyakhundyo, ");
INSERT INTO zgam_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","eisadukha yakho ukhuta puyivenchage ya khuvutitu. Pu uDada vakho uveilola nifyakhuvutitu veikhukhupa uluhombo lwakho. ");
INSERT INTO zgam_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Pu useikhi uguvukhisaya, ulekhe ukhuvanda vadesi, ulwa khuva vinogwa ukhwima nukhwisaya manyumba icnha khwisayeila na munjeila inchilekhehine ukhuta avanu puvavavone, lweli nukhuva vulela vamalile ukhukava uluhombo lwavo. ");
INSERT INTO zgam_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pu leino uve vuleipakhwisaya iengeila mukhiyumba khyakho. Deinda ulwinchi puwisayage kwa Daada vakho uvyalei khuvutitu. U Daada vakho uvei ilola khuvutitu ikhukhupa uluhombo. ");
INSERT INTO zgam_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nu pumwiva pakhwisaya pumulekhe ukhupwateila nduvu vipwateila avakaya pakhuva avene puvisaga viita vanapwatage amamenyu gavo pugipuleikhikha. ");
INSERT INTO zgam_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pu mulekhe ukhuhwanana navo, ulwa khuva u Daada yeinyo agamanyile ugumulonda vu mukhaale ukhudova. ");
INSERT INTO zgam_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Pu umwe vumukhisaya mwisayage mtenchage: Daada veito vakhukyanya, eilitawa lyakho leivalanchiwe. ");
INSERT INTO zgam_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Uludeeva lwakho lwinchage, uvunogwe vwakho vukongiwagwe pasi apa nda khuyanya. ");
INSERT INTO zgam_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Utupinchange ifinu fyieto ifya eilelo iyi. ");
INSERT INTO zgam_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Utusyiekhilage inogwa ncheito, ndufwe vutukhuvasyiekhila avanyanogwa khulyufwe. ");
INSERT INTO zgam_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ulekhe ukhutuveikha palugelu, pu utupokhe pa mbivi, pu uludeva lwakho na makha gakho nu vudwadwa vwakho sikhu nchooni. ");
INSERT INTO zgam_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Munave mukhavasyiekhila avanu inongwa nchavo, pu uDaada veinyo uva khukyanya voope ikhuvasyiekhilaga inongwa ncheinyo. ");
INSERT INTO zgam_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pu leino munave samukhuvasyiekhila avanu pu nayu, daada yeinyo sakhavasyeikhile inongwa ncheinyo. ");
INSERT INTO zgam_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Pu unave weideindile ukhulya savuli ya khisaya, pulekhe ukhuguva khu miho pakhuva nukhikoncha isoni, mulekhe ukhuva nda vanu avadesi umuvigahila viguva khumiho ukhuta avanu puvavavone ukhuta vadeendile ukhulya savuli ya khwisaya. Pu lweli nikhuva vula vumalile ukhukava uluhombo lwavo. ");
INSERT INTO zgam_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pu uve upuwiva udeindile savuli ya kwisaya, bakha imono untwe gwakho pu ukalave na khumiho. ");
INSERT INTO zgam_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Pu sayikhavonekhe khuvanu ukhuta ue udeindile savuli ya khwisaya. Pu yimanyekhikha kwene khwa Daada vakho uveilola khuvutitu veikhukhupa uluhombo. ");
INSERT INTO zgam_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Khyomela ukhwilundikhila ifyuma fyakho mukhilunga umu, umuimikoswe nu husu yinangania hange avalyasi puvibomola nukhuhincha. ");
INSERT INTO zgam_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Eikhivaha mwilundikhilage ikhibana khyinyo khukyanya ifyuma ifyumwi kava, pakhuva khukyanya ingoswe neihusu sayinanga, upu navava valyasi savigela ukhuhincha nukhunanga. ");
INSERT INTO zgam_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pakhuva ikhibano khya fyuma fyakho upukhileipwo, pu apo na yeinumbula yakho puyileipwo. ");
INSERT INTO zgam_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Eliho nyali ya mbeili gwakho. Pu leino, inave eiliho lyakho linonu umbele gwakho gwooni gwiva nulumuli. ");
INSERT INTO zgam_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pu einave eiliho livivi, na ngumbeili gwakho gwiva neihisi. Pu leino einave ulumuli lulwa lulei mugati mundyuve luvye hisi fincho, pu hisi mu khigelelo khikhi! ");
INSERT INTO zgam_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Asikhuli nayumo uveigela ukhuvavombela avankuludeva vaveili, ulwa khuva pwayi khukalaleila yumo nukhugana uyunge. Hamuwezi kumtumikia Mungu na mali. ");
INSERT INTO zgam_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Pu leino nikhukhuvula ulekhe ukhwigatancha nukhusaga pa wumi vwakho, pakhuta yawilya khiikhi, ya winywa khiikhi, nu mbeili gwakho ya vufwala khiikhi. Pu! Uwumi savululeilile pa khya khulya nu mbeili gululeilile pafyakhufwala? ");
INSERT INTO zgam_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mulolage ifidege ifya khukyanya. Safileima hange safibena, pu safilu ndania nukhuveikha nkibana, pu u Daada yeinyo uvakhukyanya ukhufileisya ifyo. Umwe pusamuluteilile khufyene? ");
INSERT INTO zgam_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Pu veeni mundyumwe uveigeila ukhwiyongelencha ikhigono khimo muwumi wa mwene? ");
INSERT INTO zgam_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Pu khikhi mwiva na masago gakhwisagila pa mienda gya khu fwala? Mulole khiluhala uvuluva mufyalo umuvudaleila. Savuvomba mbombo hange savukhifwaheincha. ");
INSERT INTO zgam_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pu neipinchige nikhuva vula niita, na yu Sulemani mumbuvaha wamwene wooni safwale lusikhu ndu vuluva uvu na vumo. ");
INSERT INTO zgam_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Einave uNguluve ifwaleincha ewo eilinyasi mufyalo, leilyo litama isikhu yeimo pukhilavo gilahiwa mumwoto, pu mukhigelelo khileikhu ayikhuvafwaleincha umwe, umwe mwei vayikhuvafwaleincha umwe, umwe mwei vanyalweidekho ludeebe? ");
INSERT INTO zgam_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Pu leino niita khyomela ukhwisagila nukhula, 'Pu ya twilya khiikhi?' Pu ya twinywa khiikhi?” Pu ya tufwala khiikhi?” ");
INSERT INTO zgam_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ulwa khuva avankhilunga, avakaya vikhufilonda ifinu ndiifi, nu Daada yeinyo uva khukyanya alumanyile ukhata mulonda ifinu ifyo. ");
INSERT INTO zgam_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pu leino mulondage uludeeva lwa mwene taasi nuvwayeilweli vwa mwene pu ifinge fyooni ukhuvongelenchaga. ");
INSERT INTO zgam_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Pu ulekhe ukhwisagila savuli ya khilavo, pakhuva ifya khilavo fikhisageila fyeene. Ifigono fyooni umufikyiela filinincha fyene. ");
INSERT INTO zgam_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Khomela ukhuhiga pakhuva nayumwe malahigiwa. ");
INSERT INTO zgam_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Pakhuva eimihigile gila igyumwihegiwa vulevule. Pu nakhikhigelelo eikhumu gelela avange nayumwe mulageliwagwa mueikhyo. ");
INSERT INTO zgam_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Pu khikhi wilola akhalagaleilo akhalagile muliho lya nino, pu leino salumanyile ukhuta muliho lyakho muleikhi lagaleila khya gubeikhi uguvaha? ");
INSERT INTO zgam_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Pu wiva na makhamakhi agakhunchova khunino ukhuta ukhi nikhuhenche akhalagaleila mu liho la nino vu uve muliho lyakho muleigulagalila uguvaha? ");
INSERT INTO zgam_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Uleidesi uve; puhenche tasi ugulaga leila muliho lyakho, pu leino wiva na makha gakhuhencha akhalagaleila muliho lya nino. ");
INSERT INTO zgam_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Khyomela ukhunchipa imbwa ifinu ifivalanche, hange khyomela ukhunchilahila ingube inyambo. Pakhuva inchene pu yachikanda inyambo eincho na malunde ga nchene nukhuvasyetukhila nukhuva niefulania. ");
INSERT INTO zgam_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Pudovage puvupewa. Ulondage, puvukhufivonaga. Hodenchaga, nuve puvudeinduliwagwa. ");
INSERT INTO zgam_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pu ula uveidova ikyupeleilaga. Nula uveilonda ikhufivonaga, nu umunu uveikohona eideinduliwa. ");
INSERT INTO zgam_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Pu khulei munu veeni khulyumwe uvei anave umwana va mwene idova eikhisyesye pwi khupa eiliwe? ");
INSERT INTO zgam_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Pu anave idova eisomba, ikhupa pu ikhupa einjokha? ");
INSERT INTO zgam_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pu leino, einave umwe mwivavivi lyooni mukhimanyile ukhuvapa avana veinyo ifinu ifinonu pu u Daada yeinyo uvakhukyanya alekhe ukhuvapa umwe ifinu ifinonu ukhuluteileila ifyumudova khumwene? ");
INSERT INTO zgam_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Savuli ga eiyo, upuwinogwa ukhuta avanu vavavombelage umwe inonu nayumwe pumuvombage vulevule. Pakhuva eiyo lyu lulageli na vanyamalago. ");
INSERT INTO zgam_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Mwingeilage na ndyango ufinye, ulwa khuva undyango mwelefu na yeinjeila nyeleefu eiyuyiluta khuvuyagi, hange pu vingi avigenda munjeila einyelefu. ");
INSERT INTO zgam_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ifinye undyango ifinye nu einjeila yiebanelinchiwe eiyo yiluta khuwumi na veene avikhuyeivona vadebe fincho. ");
INSERT INTO zgam_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Mwivandeikhe nukhwilolela navanya malago avavudesi, vavo vikhwincha puvafwalile eingwembe ya ng'osi, humbe leinu eilyulibuda avanu. ");
INSERT INTO zgam_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pu mukhuvamanyaga musekhe nchavo. Pu leino avanu vitungula amasilu mu mitwinyo? Pu umunu itungula ncha kuyu pamatula? ");
INSERT INTO zgam_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Vuvuwa umbeikhi unonu guhupa isekhe inonu, nu ubeikhi umbivi guhupa isekhe imbivi. ");
INSERT INTO zgam_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ubeikhi unonu saguhupa lusikhu isekhe imbivi, nu beikhi umbeivi nalusikhu saguhupa isekhe inonu. ");
INSERT INTO zgam_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ubeikhi gula ugusaguhupa isekhe inonu gwakhudumula, nukhutaga mu mwoto. ");
INSERT INTO zgam_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Pu leino niita mukhuvamanyagamusekhe nchavo. ");
INSERT INTO zgam_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Mulekhe ukhuta vala vooni avuvii, 'Inkhuludeva, Inkhuludeva,' khuntwa vuvalingeila khukyanya ndeili, pu ula uveivomba nchila inchinogelanile pa Daada vava lingila khukyanya. ");
INSERT INTO zgam_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pu avanu vingi pa khigono eikyo valata, 'Inkhuludeva, Inkhuludeva, salulikhulangula munditavwa lyakho, satulikhutuleikhumya munditawa lyakho? ifidego satuleikhuvomba munditavwa lyakho?' ");
INSERT INTO zgam_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pusanilavafihe nilavavula pava valafu ukhuta, 'Samvanyile umwe! Muhege palyune mwemvivombeile imbivi mwimukhale nalubedo!' ");
INSERT INTO zgam_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Pu leino, umunu uveipuleikha eilimenya lyango nukhukonga pu ihwana naga nu munu unyaluhala uveanchengile einyumba palinalawe. ");
INSERT INTO zgam_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pu eifula yeikhatima ingasi nchikhadeiga gukhuyila ukulugutu gukhakula einyumba eila, pusayagwe pasi, ulwa khuva yanchengiwe palunalawe. ");
INSERT INTO zgam_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pu ula uveipuleikha eilimenyu lyango sikhuleikonga, pwihwanana nu munu unchimu uveianchengile einyumba ya mwene palusanga. ");
INSERT INTO zgam_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Eifula yeikhincha yeikhatima fincho amagasi gakhadeiga ukulugutu gukhuyeila gukhapula einyumba yeila yeikhagwa eikhutuveili khikhadang'alukha.” ");
INSERT INTO zgam_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pu gukhafikhe useikhe ugu u Yesu akhava amalile ukhunchova amamenyu aga, pu avanyalulundamano vadegile fincho ulumanyisyo lwa mwene, ");
INSERT INTO zgam_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ulwa khuva amanyisye ndu munu umwene vutwa. ");
INSERT INTO zgam_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Pu umwene avile ikhile ukhuhuma pakhyamba, avanyalulundamano vingi vakongile. ");
INSERT INTO zgam_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Pu lola, akhincha umunu unyabuuba, akhata, “Nkhuludeva unave winogwa wimonie uvutamu.” ");
INSERT INTO zgam_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","U yesu pwakhagolosya ikhivokho khyamwene akhamwabasya akhata, “Ninogwa upone. Pu akhapona useikhe gulagula ibuuba. ");
INSERT INTO zgam_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Pu u Yesu akhambula akhata, “Lola khyomela ukhumbula umunu eikhidego eikhi. Pu lutage ukhivonesye khuntekhenchi, pukhahumye neinekhelo nduva alagile u Mose muvamanyile avane” ");
INSERT INTO zgam_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Pu uYesu avile afikhe khu Kapernaumu, pu undongonchi vavasikhali akhincha khumwene, ");
INSERT INTO zgam_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","pu leino unchongonchi ula akhasimelencha akhata, “'Veinkuludeva, umunu vango aleipa kaya alambalieile igona umbeili gwa mwene gufwe eiganji hange aleinuluvavo fincho.” ");
INSERT INTO zgam_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Pu u Yesu akhambula akhata, “'Nikhwinja neinjaveile apone”. ");
INSERT INTO zgam_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pu ula undongonchi vavasikhali akhamwamula akhata, “Inkhuludeva, vango sapanogile ukhuta uve wingile mukaya yango, pu ni doova unchove eilimenyu vuvule pu umbombi vango ipona. ");
INSERT INTO zgam_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ulwa khuva une na yune neilimunu neiveikhivwe pulungonchi vwa vasikhali ava valipasi palyune. Nei ngale khyuyu “'Luta' khuvuleive, pu iluta 'Vuvule' pu khuyunga neingate inchaga khunu ikhwincha vuvule, hange umunu umbombi vango neingate,' vomba eikheive puivomba vuvule. ");
INSERT INTO zgam_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pu u Yesu vuapulikhe ndavule adegilee fincho nukhuvavula avakongaga akhata, “Ncha yeilweli nikhuvavula, saneigelile lusikhu umunu unya lweideikho ndulu mu Israeli eiyei yooni. ");
INSERT INTO zgam_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nune nikhuvavula eiyakhuta avingi valahuma khuvuhumo wa linchuva na khuvusemo wa linchuva, valatama pupaninie nu Abrahimu, nu Isaka, nu Yakobo, pakhulya ifinu mundudeeva lwa khukyanya. ");
INSERT INTO zgam_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pu leino avene avana valudeeva vala lahwagwa muhisi ya khunji, pu ukhwa khulava neikhileilo nu lugaduncho lwa meno.” ");
INSERT INTO zgam_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Na voope uYesu akhambula undongonchi vavasikhali akhata, “Lutaga! puyive nduvunchovile ukhuta umunu umbombi vakho apane, Ukhukongana nu lweidekho lwakho.” Pu leino umbimbi va mwene akhapona useikhe gulagula. ");
INSERT INTO zgam_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pu uYesu akhafikha khukaya ya Petro, pwakhambuna unkwive va Petro vaninemwa va dala va mwene, igona pakhihaga aleineimungu. ");
INSERT INTO zgam_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Pu uYesu akhamwabasia ikhivokho khya mwene imungu puyeikhandekha. ");
INSERT INTO zgam_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pu pakhimihe vukhwilile pu avanu vakhavagega vavingi avavule ni mepo imbivi. Akhandimenyu lya mwene akhavaponia vooni avo vale vatamu hange vatokhile. ");
INSERT INTO zgam_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Pu yeikhava limalile ukhuvombekha eiliemenyu leila ilyanchoviwagwa nu nyamalago u Isaya, eilyakhuta umwene avatulile uvudekhedekhe vwito, nu vutamu vwito wooni avupeimbeile” ");
INSERT INTO zgam_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Pu umwene u Yesu avile avwene ikhipuga khya vanu vuvingi vanchungutile akhavavula nuvalagila ukhuta tuvukhe tulovokhe khumwambo khunyanja eiyamu Galilaya. ");
INSERT INTO zgam_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pu umunu uyungu usimbi vakalata akhandutila uYesu, pwakhata, veimanyisi uve nikhukhukonga khyoni ukhuwiluta.” ");
INSERT INTO zgam_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","U Yesu akhamwamula akhata, “Amakave galeinamaguli umwakhugona ifidege fyope filinuvufumba, pu umwana vanya munu aleinchila pakhuveikha uluvafu nukhuhagalila untwe.” ");
INSERT INTO zgam_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ukongi va mwene uyunge akhambula akhata, “Nkuludeva, nidova nilute nikhasyile u Daada.” Pu u Yesu akhata, ");
INSERT INTO zgam_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","“Ung'ongage une uvalekhe avafwile vasyiilage vavo.” ");
INSERT INTO zgam_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","U Yesu akhingeila muliboti, avakongi va mwene vakhakonga. ");
INSERT INTO zgam_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Lola inyanja yikhahambukha vu umbelo guleikhukulugata neimepo yale mbaha fincho. Pu leino u Yesu agonelile utulu. ");
INSERT INTO zgam_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Avakongi vakhanduteila vakhasisimula nukhata, gwe Nkhuludeva utupokhe ufwe tuleivanya khyongomela munyanja. ");
INSERT INTO zgam_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","U Yesu akhavavula akhata khiikhi muleivadwaanchi umwe, khikhi mulei nulwidikho ludebe umwe?” Akhasisimukha, pu akhava munu va khutama khu kulugutu ugunya mepo eiyinya mbelo uguleikhupiga eiliboti pu einyanja yeikhalitama, ");
INSERT INTO zgam_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","avanu vooni vakhadeya nukhuta umunu uyu aleinamakha makhi, hange aleindakhikhi pakhuva ukulugutu gwa mepo eiyinyambelo gyope gukhudwaada?” ");
INSERT INTO zgam_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pu useikhi ugu uYesu avile alutile khumwambo khu khilunga eikhya vaMagadala, valepo na vanu vaveili avanya mepo imbivi vakhaganila nave. Avanu avo vahumile khumapumba pu valeikhuvagatancha fincho avanu, pa navava gendanjeila savaleikhugenda einjeila yeila. ");
INSERT INTO zgam_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Lola, puvakhovela eilimenyu vakhaya, “Tuleinakhikhi nuve vei mwana va Nguluve? Winchile apa pakhuta kineila vu pakhale useikhi sagufikhe?” ");
INSERT INTO zgam_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pu kwale neikhipuga khya ngube pu nchale pipi navo, hange valepo na vadeimi vagube, ");
INSERT INTO zgam_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","imepo imbivi punchilikhukuta khwa Yesu ukhuta. “Pu ungave ulwamwile ukhutuhumya utuheileikhe magubenchila.” ");
INSERT INTO zgam_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Pu uYesu akhata, “Lutaga!” Pu imepo imbivi nchikhahuma khu vanu vala nukhunchikhingeila khugube. Lola eikhipuga khyoni khikhikha ukhuhuma khukhyamba leikhaluta nukhwingila munyanja punchikhafwa mumagosi. ");
INSERT INTO zgam_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pu leina avadeimi vagube vakhanyila ukhuvuya, vavile vafikhe khu vanchege vwa vanu vakhayavula nchooni inchuvanchiwene na vavanu avanya mepo imbivi. ");
INSERT INTO zgam_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Lola, uvunchenge wooni wa vanu vakhincha khukhwaganila nu Yesu. Vaveile va mbwene vakhasimeileincha ahegage nu khilunga khyavo. ");
INSERT INTO zgam_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Pu u Yesu akhingila mundiboti, pwakhalovoka nukhufikha mumbunchege uwamyave. ");
INSERT INTO zgam_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Lola, pakhincha avanu vagegile umunu uvyafwe eiganji vugoninche pa khihaga puvakhapimba. Pu uYesu akhaluvona ulweideikho lwavo. u Yesu akhambula utamu ula akhata, “Manango uve nuluhekhelo weikanganche, usyeikhiliwe inongwa nchakho” ");
INSERT INTO zgam_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Lola, pu avamanyi vakalata vaninie vakhinchofanja munumbula nchavo, vakhata uyu eikhubeiga lweli unguluke” ");
INSERT INTO zgam_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","U Yesu akhagamanya amasege ugu visaga pwa khata, “Khikhi musaga uvuvivi munumbula ncheinyo? ");
INSERT INTO zgam_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Pu lilele leileikhu neigate usyeikhiwe inongwa nchakho nukhuta ima ugendage?' ");
INSERT INTO zgam_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Puleino mulumanye ukhuta umwana vanyamunu veimwene uveisyeikhila inongwa (Pu ikhumbula ula utamu) hega weitwikhe eikhihaga khyakho ulutage khukaya yakho.” ");
INSERT INTO zgam_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Pu umunu ula uveifwele eiganji akhima nukhuhega ukhuluta khukaya ya mwene. ");
INSERT INTO zgam_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pu ikhipuga khya vaanu khyooni vavile valolile ndavule puvakhadwada hange nukhuginia uNguluve uvei avapeile avanu amakha aga leidavule. ");
INSERT INTO zgam_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Pu uYesu avile eigeinda ukhuhuma pala akhambona umunu eilitawa ale vei Mathayo, atamile pavusangunchi wa songo. Pu akhambula, “Ung'ongage une” Voope akhima nukhukonga. ");
INSERT INTO zgam_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pu u Yesu avile atamile pasi ukhuta alavukhe eikhya khulya munyumba, vakhincha avasangunchi va songo vuviingi na vanu avatula nogwa vakhalya pupaninie nu Yesu eikhya khulya hange na vavakonge vamwene. ");
INSERT INTO zgam_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pu avafalisayo vavile valolile ndavule, puvakhavavala avakongi vakhata “Khikhi umanyisi veinyo ahanga eikhyakhulya navusangunchi va songo na vanu avatula nongwa?” ");
INSERT INTO zgam_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","U Yesu avile apulikhe ewo na vope pu akhata “Avanu vavosavatamu vukafu pa mbeili vusavilonda unyakhuvayavila, pu vala vavo vatamu vu avo veilonda unyakhuvaya veila. ");
INSERT INTO zgam_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pupanogile mulute mukhamanyile khukhuta khikhi amamenyu aga, “Nilonda eikhisa sanilonda isadakha ya nekhelo. ");
INSERT INTO zgam_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Leino puvukhincha avakongi va Yohana vakhavuncha vakhata, “Khikhi ufwe nava Falisayo khikhe tukhufilekha ifinu ukhulya, pu avakongi vakho savikhufilekha?” ");
INSERT INTO zgam_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","U Yesu akhavavula akhata, avanu vavo veilangiwe khuvulegulani puvisusuvalaga ndakhikhi vuvalei nutegula ndala? Lakini siku zinakuja ambapo Bwana arusi atachukuliwa kutoka kwao, na ndipo watakapofunga. ");
INSERT INTO zgam_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Asikhuli umunu uveivekha eikhikata eikhipya pa mwenda unkulu, ulwa khuva khila eikhikata ekhipya khipapukha pamwenda unkulu. ");
INSERT INTO zgam_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Vusikhuli avanu avaviveikha unekhe ugwa masilu puvidudeileila mupakho unkulu, einave viveikha ifipakho fila pufiniefukha amasilu gidudeikha. Ndeili unekhe gwa masilu vidudeila mumipakho eimipya eigya musilu, pu fyoni fiva finonu vuvule. ");
INSERT INTO zgam_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","U Yesu avile aleipakhuvavula inchi lola pwakhincha umbaha vava manyisi pwaleikhufu gafuga pu Yesu aleikhuta, “Umwaleivango afwile akhaseikhi akha leino, puwinche siwo uveikhe eikhivokho khyakho pamwene pu inchukha iva mwumi. ");
INSERT INTO zgam_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Pu uYesu akhima akhanda ukhukonga navakongi va mwene vakhalongonjana. ");
INSERT INTO zgam_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Pu lola, udala umo uvei ale khwimali eimyakha eikhinchigo neigeiveili akhahegelela pa Yesu khusana pu akhabasya eikhilundwa khya mwene khu malunde. ");
INSERT INTO zgam_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Pakhuva ainchofanjinche munumbula ya mwene akhata, “Puninave nikhwabasya khyene eikhilundwa khya mwene punipona.” ");
INSERT INTO zgam_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","U Yesu pwakhava munu vakhusye tukha khusana pwakhambona akhata, “Mwaleivango weikanganche einumbula ulweideikho lwakho lukhuponinche. ");
INSERT INTO zgam_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pu uYesu avile afikhe khukaya ya mbaha vava manyisi puakha vavona ikhipuga khya vanu nava nkhuva fiwiwi ni nyovelo imbaha. ");
INSERT INTO zgam_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Pu akhata, “Muhege apa pakhuva umanango safwile, pu agonelile vuvule. Pu avene vakhahekha nu khubeida. ");
INSERT INTO zgam_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Avanu vala vavile vahumile khunji, pu u Yesu akhingeila khugati akhamwibata eikhivokho umwana ula akhima. ");
INSERT INTO zgam_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Pu einongwa inchi nchikha daala nukhupulikhikha mukhilunga khyoni eikhavanhenge vula. ");
INSERT INTO zgam_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","U Yesu vuahumile pala iluta khuvunye pu avanu vaveili avabofwile amiho vakhincha, vakhakonga, puvakhava vanu vakhyova nukhuta, “Vei mwana va Daudi, utuleileilage eikhisa.” ");
INSERT INTO zgam_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","U Yesu avile ingile munyumba vala avabofwile amiho vakhincha khwa Yesu, pu akhavavula akhata, “Mukweideikha ukhuta nikhimanyile ukhuvomba einchumsagile?” Pu avene vakhambula vakhata “Ena, Nkuludeva” ");
INSERT INTO zgam_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Pu u Yesu akhavabasya amiho gavo akhata “Vuyeivombekhe ewo nduvumweideikhe ulweidekho lweinyo.” ");
INSERT INTO zgam_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Pu amiho gavo gakhadeindukha. Nu Yesu pwakhavataneila fincho ukhuta, “Mweilolelage umunu na yumo alekhe ukhulumanya inchivombikhe khulyumwe.” ");
INSERT INTO zgam_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pu leino avanu vala vakhahega vuva humile khunji puvaleikhuva vula avanu voni vakhalumanya mukhilunga eikhya vunchenge wooni. ");
INSERT INTO zgam_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pu vavile viluta lola pwavanu vakhagega umunu uveisinchova ahuliwe ndu munu avaleikhinunu, ulwa khuva ale ni mepo imbivi. ");
INSERT INTO zgam_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Imepo imbivi nchavile nchihegile pu akhanda ukhunchova, avale pa khipuga vakhaswiga fincho nukhuta eili satugele tuleivone mu Israeli. ");
INSERT INTO zgam_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pu leino avafalisayo puvaleikhuta ihumya imepo imbivi mumakha gambaha va mepo imbivi.” ");
INSERT INTO zgam_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pu uYesu pwaleikhunchungula mbunchenge uvuvaha nuvudebe akhamala wooni vuimanyisya munyumba nchavo inchakhwisayila pwaleikhuvavula inongwa inonu inchaludeva pwalikhuvania avanu voni avuvale vatamu nuvulemale uvuleipapingi. ");
INSERT INTO zgam_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Vu avile akhuvalola eikhipuga khya vanu akhava kolela eikhisa ulwa khuva vatokhile nukhwihasania ndi ng'osi inchilimbula deimi. ");
INSERT INTO zgam_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Pu akhavavula avakongi vamwene akhata. “Imbene nyingi fincho pu leino avabeni vadebe. ");
INSERT INTO zgam_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pu leino mudovage khu mwene mbene avasuhage avabeni mumbene ya mwene.” ");
INSERT INTO zgam_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Pu u Yesu akhaveilanga avakongi va mwene vooni eikhinchigo nafive ile pupaninie akhavapa amakhaga khuhencha imepo imbivi nukhuponia uvutamu nuvulema wooni. ");
INSERT INTO zgam_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Amatawa gavene avapositili eikhinchigo nafiveili gu aga. Utanchi ale vei Simoni (uveiva mwilangaga Petro), eilinge eilitawa, nu Andrea ununa va Yakobo unya Zebedayo, nu Yohana unu nave: ");
INSERT INTO zgam_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Nu Philipo, nu Bartelemayo, Thomaso, nu Mathayo usangunchi va songo, nu Ykobo unya Alfayo, nu Tadeo, ");
INSERT INTO zgam_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","nu Simoni uva Mukananayo, nu Yuta uva muiskariote, uveiasambukhile uNkuludeva. ");
INSERT INTO zgam_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Avakongi ava khinchigo nafiveili vu avasuhile akhata khuvakaya mulekhe ukhuluta hange mumbunche vwa vasamaliya indekhe ukhwingila. ");
INSERT INTO zgam_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pu beitage khung'osi incha Vaislaeli avayagile. ");
INSERT INTO zgam_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Vu mwiluta indumbeileilage ukhuta uludeva lwa khukyanya luhegelile.' ");
INSERT INTO zgam_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Muponiage avatamu munchusyage avatamu, mukhavaponiage nukhuva valancha avanya buuba nukhuhencha imepo imbivi. ");
INSERT INTO zgam_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mulekhe ukhuhava ulutalama, almasi nukhuva nifyuma mumipakho gyeinyo. ");
INSERT INTO zgam_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Khyomela ukhwivopela eimbopo pa ncheila, mulagegaga mwenda ungwongelile, five filato, luve lusaga pakhova umbombi anogile ukhukava ulahombo lwa mbombo. ");
INSERT INTO zgam_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Uvu nchenge uwavenchaga vuve vuvaha vuve vudebe uvuyakhiva mukhwingila mulolange veeni ukhwa uviavile igolofu pumulamage khumwene impakha yakhiva mwihega. ");
INSERT INTO zgam_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Numwe vumwingile pakaya ya munu pu muvasamusye, ");
INSERT INTO zgam_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","enave eikaya yeinogelanile ulunonche hencho lweinyo luve pala, pu enave sapanogile pu muve nulunonchehencho muhegage apo. ");
INSERT INTO zgam_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Pu vanave vabelile ukhuvupeileila hange nakhukhuvapuleihincha ugumwinchova vumwihege pa kaya eiyo pu mwikuhunage amalunde ngeinyo ulufumbe palapala. ");
INSERT INTO zgam_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Pu nchayeilweli nikhuvavula ukhuta, pu yeilava huba uvuhegi uwa mbunchege uwa mu Sodoma nu wakhu Gomolah uvahegi uwavunchege uwa vulaluteila. ");
INSERT INTO zgam_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Lola panikhuvasuha nding'osi pagati na gati pafikana ifitalaam fidwancha, pu muvenchage nuluhala ndinyandalwe hange muvenchage vudekhedekhe ndigundya. ");
INSERT INTO zgam_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mweitevekhage nukhwilolela na vanu, pakhuva yavikhuvaheilikha khuvaheigi vanongwa nukhuvatova hange munyumba nchavo eincha khwisayila. ");
INSERT INTO zgam_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pu valavagega mbulongolo pa vanu avavaha na va nkuludeva savuli yango, pu khive khimanyilo khuvene nakhuva kaya. ");
INSERT INTO zgam_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Puyakhiva vikhuvakunga nukhuvaheilikha khuvavaha avavuheigi mulekhe ukhusagania agakhunchova, pakhuva unkuludeva umbalanche veiyaikhuvapinchaga palapala amamenyu agakhunchova. ");
INSERT INTO zgam_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Pakhuva samwemwe mweiyakhiva minchova, pu leino uMepo uva Daada veiyainchovaga igati ndyumwe. ");
INSERT INTO zgam_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Pu umunu alasambukhila ulukololwe uvei vaholiwe ung'onchi yumo pwikhugega pakhubuda, na yu visa alagagila umwana vamwene, na vana valeimag nu khuvagagila avahonchi vavo nukhuva buda. ");
INSERT INTO zgam_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Pu umwe avanu vooni vikhuvavipeilaga savuli ya litawa lyango, pu ula uviyakhiva eikhiyumileincha mpakha pavusileilo veiuywa alapokhiwagwa. ");
INSERT INTO zgam_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pu leino yakhiva vikhuvasweima mbunchege uva muhegage mkimbeilage nukhuluta khuvunchege uvukonga, ncha yeilweli nikhuva vula samukhamale uvunchenge wooni uvwa mu Israeli impakha umwana vanyamunu alava akiliwikhe. ");
INSERT INTO zgam_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Asikhuli ukongi uveimanyila puikhunduteila umanyisi vamwene. ");
INSERT INTO zgam_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Eikweilanile ukongi ukhuva ndu manyisi vamwene nu mbanda ukhuva ndu ntwa vamwene. Einave unyakaya vapeile elitawa viita Belzabuli, puyavikhu valekha avange avaleimunyumba ya nyakaya. ");
INSERT INTO zgam_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Mula dwadaga umwe, pakhuva khisikhuli eikhilava khuvutitu hange eikhilikhuvutitu khilava pavuvalafu. ");
INSERT INTO zgam_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Leila eilyunikhuva vula khuvutitu pu muleinchovage pavuvalafu, na leila ailyuni khuva hehela muleinchovage khuvanu. ");
INSERT INTO zgam_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mulekhe ukhuvadwada avibuda avibuda umbeile pu valinchilamakha agakhubuda ula unyamakha gakhubuda umbeile ni numbula yope mulwongomencho lwa mwoto ukali. ");
INSERT INTO zgam_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Pu ifiyuni fiveili safigonchiwa ni senti yeimo? Hata hivyo hakuna anayeweza kuanguka chini bila Baba yenu kufahamu. ");
INSERT INTO zgam_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Pu leino umwe nanchinchweile ncheinyo khumintwe nchivaliwe nchooni. ");
INSERT INTO zgam_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Pu mulekhe ukhudwada umwe pakhuva mufiluteilile ifiyuni. ");
INSERT INTO zgam_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Pu leino ula uveiyakhiva ikhunchova pavuvalafu pavanu vuvipulikha ukhuta amanyile une, pu nayune nilata nimanyile pamiho ga Daada vango uvakhukyanya. ");
INSERT INTO zgam_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pu ula uveiyakhiva ikhumbela pavanu ita sanimanyile nayune punila beila pamiho ga Daada vango uvialei khukyanya. ");
INSERT INTO zgam_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Mulatenchaga pamo ninchile khuveikha ulunonchencho inkeilunga, saninchele khuveikha ulunonchencho, puneigegile eimundu khwigeida. ");
INSERT INTO zgam_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ulwa khuva ninchile khukhuva palahania umunu nuswambe, ung'eincha nu vanina, umunu nu kwive. ");
INSERT INTO zgam_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nu ntavangwa va munu vuvala avamukaya ya mwene. ");
INSERT INTO zgam_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Uvei aganile uvise nu vanina ukhuluteila ukhungana une sanugile palyune khange uvei aganile unswambe nu mwaleive ukhuluteila pakhugana une sanogile palyune. ");
INSERT INTO zgam_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Pu umunu anave sitola eikhida mileihanie nukhung'onga unesanogelanile palyune. ");
INSERT INTO zgam_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ula uveikhuvupokha uwumi vei ula uveikhuwambuncha uwumi savuli yango leino vei uywa avupokhile uwumi wa mwene. ");
INSERT INTO zgam_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Uvei ikhuvupeileila umwe ikhunyupeile ila une, nula uveikhunyupeileila une ikhamwupeileila ula uvei asuhile une. ");
INSERT INTO zgam_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Uvei ikhumwupeileila unyamalago ulwakhu inyamalago vei uywa alahombwa uluhombo ulwanyamalago. Nula uveiyakhiva iva igolofu ikhumwupeileimbo ulwavugolofu. ");
INSERT INTO zgam_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ula uveiyakhiva ikhupa umo muvadebe ava, pundakhive khinywelo khimo eikhya magasi amanchinchimu, ulwakhuva umwene ikongi, lweli nikhuvavula pu umwene pusaladeila uluhombo lwa mwene.” ");
INSERT INTO zgam_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pwu yikhava uYesu wa maliele ukhuvavula avankongi va mwene kumi na mbili akhahege pala akhaluta khumanyisya nukhulumbielila khukhilunga ikya vene, ");
INSERT INTO zgam_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","uYohana waliemukheghu ngwa avile apuliekhe imbombo incha Klisiti, akhasuha ululagielo ukhugeendela khuva nkhongi avamwene, ");
INSERT INTO zgam_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","vakhambuncha, “Uve ndaveve vunkwincha, apange nkhwale uyuunge uvyakhiva inkwinhanga?” ");
INSERT INTO zgam_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","UYesu akhavamu akhata, “Mulutage mukhambule u Yohana nchila inchuomupulikhe na nchila ienchumunkhu nchivona. ");
INSERT INTO zgam_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Avanu avasavilola vilolaga, avifugafuga vigeendanga, avankhoma vivalanchiwaga, avanchivile viepuliekhaga, avafwile vinchukhaga ukhuva vumi, avagaanchu vilambeeliewagwa eilimenyu eilinonu. ");
INSERT INTO zgam_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Asayiewe uvie umwene unchila luuviepo nune. ");
INSERT INTO zgam_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Avanu ava vuvahegiele, u Yesu akhatengula wakhunchova na vanu inongwa incha Yohana, “'Akhavavancha upwumukha lutile khulukhungu mukhakhiwe khinu khikhi, ieligugu lieliekhusukhaniekha nie mepo? ");
INSERT INTO zgam_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Inave saewo mukhahumile mukhalutiele nkwilola khikhi? Umunu uvyafwalile imienda iminonu avietama munyumba iya nkhuludeva. ");
INSERT INTO zgam_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Humbe munkhahegiele ukhuluta kwilola inkhikhi? Apange khukhombona unyamalago. ");
INSERT INTO zgam_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Uyou ule imbombo nchamwe chandiekhiwe, 'Mulolage, nikhunsuha umunu vango, nikhusuha khulyumwe uvakhiva ikweta injila pamiho ghakho. ");
INSERT INTO zgam_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mwidikgage, nikhuvavula ielweli asikhuli umunu uvaholiwe khudaala uvyahwanine nuu Yohana uvikhwoncha. Humbe vie iedebe mu mumbu ntwa uwa khukyanya, vie mbaha ukhulutielila khwa Yohana uvikhwoncha. ");
INSERT INTO zgam_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ukhuma mumanchuva aga Yohana umwonchi ukhufikha leino, uludeva ulwa khukyanya lwa makha, avanu avanyamakha vuvitola namakha. ");
INSERT INTO zgam_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ulwa khuva avanyamalago voni avandagielo avanchovaga ukhudugha wunsiekhi ugwa Yohana. ");
INSERT INTO zgam_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Inave mukwiedihana, ukhuta vyuula uEliya, uvie avanyamalago avalikhuta ula viikyiencha. ");
INSERT INTO zgam_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Uviali ni mbulukhutu inchakhupulika apuliekhage. ");
INSERT INTO zgam_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Uvuholiwa uvu nivuhwananinche nie khikhi? vuliendavana avikhina vikhwilangana vikyega nduviengilo, ");
INSERT INTO zgam_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","vita, tuvatovile iekhiwiewie khunema, twaiembiile inyimbo incha khililo samuliekhuliela.' ");
INSERT INTO zgam_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ulwa khuva uYohana ainchile saliekhulya nu ukhunywa pwu valie khuta, 'Alieni mepo imbivi.' ");
INSERT INTO zgam_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Umwana va Adamu ainchile aliekhulya nukhunywa valiekhuta ielya ano khange ingaanchi, umanyani va vasangunchi avalie nimbivi!' Ulwa khuva uluhala lwa mwene luvonekha mu mbombo inchamwene.” ");
INSERT INTO zgam_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","U Yesu pwakhatengu ukhuvaduka mwoni muvunchenge umwuo imbombo ncha mwene inchuavombile nchavonikhe, ulwa khuva savapele, ");
INSERT INTO zgam_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","uliviekhi, Kolazini, uliviekhi Betisaida! Ukhuta imbombo imbaha nchale nchivombe khu Tilo na khu Sidoni inchivombike apa vuvakhasayiwe khatale vakhale vifwala amaguniela nukhubakha ilyeela. ");
INSERT INTO zgam_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Hange ukwieyumilincha khu Tilo na khu Sidoni ilie nchuva ilyavuhiegi ukhulutilila khuvene. ");
INSERT INTO zgam_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Uve, Kapernaumu, wieta uyuvukhwie miekhiwa impaka khukyanya? Bakho vukhwikhaga pasi khuvufwe. Khu Sodoma khukhale khuvombekhage imbombo imbaha, nduvunchivombike khulyuve, ukhale wiva khwule ufikha ilelo. ");
INSERT INTO zgam_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ulwa khuva akhanchovile khulyuve ukhuta, yivahuoba ikhilunga ikya khu Sodoma ukhunchukha ilinchuva ilya vuhiegi ukhulekha uve. ");
INSERT INTO zgam_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Unsiekhi ugwa uYesu anchovile ankhata, “Ninkhugienia Dada, Vinkhuledeva va khukyanya na Nkhilunga, ulwa khuva ukhavafihiele imbombo inchi avanyaluhala nuvumanyi, nu khuvavonekhela avasaviembiele, uvadiendulile avana avadebe. ");
INSERT INTO zgam_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ena Dada ukhuva inchi nchu nchinogile pamiho ghakho. ");
INSERT INTO zgam_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ifiinu fyoni amile Udada. Hange asikhuli yuywa amanyile unswambe amanyile ywu Dada, hange asikhuli uvamanyile Udada amanyile yu mwana, nu vieumwana anganile vieikhumbonesya Udada khumwene. ");
INSERT INTO zgam_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mwinchage khulyune mwievoni yumwe muhangayiekha, yuumwe mwitwiekhile ieminchiigo eiminchitu, une ninkhuva ghata lusya. ");
INSERT INTO zgam_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mwiyumilinchage khulyune mumanyilage khulyune, ulwa khuva une niliemwidihinchi hange nieliindenkhedekhe va numbula pwu mukhaga ulugataluko ulwa munumbula nchienyo. ");
INSERT INTO zgam_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ulwa khuva undeghehe gwango iendekhedekhe nu nchiigo ngwango impepe. ");
INSERT INTO zgam_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Unsiekhi guula uYesu alutile akhageenda mufjalo ya vanu ielinchuva ilya sabato. Avankhongi va mwene vale nienjala pwu valiekhudenya isoncho ncha nganu valiekhusegheya mu mavokho valiekhulya. ");
INSERT INTO zgam_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Avafalisayo vuvaloliele ewo, vakhambula uYesu vakhata “Ulole avankongi vakho vanangile ululagielo vivombo inchusanchinogiewa ukhumba ilinchuva ilya Sabato.” ");
INSERT INTO zgam_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pwu uYesu akhavavula akhata, “Samwiembile inchu uDaudi avombile unsienkhe uuguale nie njala, na vanu vamwene uvuale nawo? ");
INSERT INTO zgam_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Vwuingile munyumba iya Nguluve alikhulya ikhisyesye, khikyo sakyale kyakhula na vanu uvuale nawo, kyale kyankhula avate nkhenchi vene? ");
INSERT INTO zgam_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Khange samwimbile ululagielo ukhuta avatekhendu mugaati muntembile vikhuyibeda ei Sabato, ulwa khuva valievuvule uvuvivi? ");
INSERT INTO zgam_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pwu nikhuva vula umwe ikhuta umbaha ukhulutielila ietembile pwale aapha. ");
INSERT INTO zgam_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mwale mulumanye eile khikhuta khikhi; une nilondo iekhisa sahielonda iefyakhusa; samukhale munkhuvahiga vavo valie vuvule ienongwa, ");
INSERT INTO zgam_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ulwa khuva umwana va Adamu veimwene inkhuludeva va Sabato.” ");
INSERT INTO zgam_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","U Yesu pwankhahega pala akhaluta muntembile yavene. ");
INSERT INTO zgam_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Lola pwu ale umunu uvyaposile inkhivokho. Pwu vankhambuncha uYesu vankhata, “Ndayiva lweli unkhumponia umunu eilinchuva ilya Sabato?” Valiekhunogwa ukhusitakha ukhuta avombile imbivi. ");
INSERT INTO zgam_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","U Yesu ankhavavula, “Veni umunu yuywa angave nie ng'osi yiengile ndiguli eilinchuva ilya Sabato, sakhawesye ukwingile mugaati ndiguli mukhuyihumya na makha eing'osi mundieguli? ");
INSERT INTO zgam_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Khiliekhu iekhienunu ukhulutielila khuo ng'osi! Pwu yiva lweli ukhumba inonu ielinchuva ilya Sabato.” ");
INSERT INTO zgam_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","wu akhambula umunu unla akhata, “Husya iekhievokho kyakho” Akhahusya iekheivokho nkhapona khinkha khwanana niekhieniena. ");
INSERT INTO zgam_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Avafalisayo vankhahuma nkhunji ankhanchovana vankhidihana umwakhumbudiela pwu vankhahuma khunji vuvikhwidihana ukhubuda. ");
INSERT INTO zgam_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","U Yesu wanchimanyile ienchi ankhahuma ankhahega apo. Pwu avanu avingi vavo vankonga, ankhavaponia voni. ");
INSERT INTO zgam_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ankhabencha unkhuta valenkhage ukhuvavula avanu ynkhuta umwene vyavaponninche. ");
INSERT INTO zgam_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ukhuta linkhongane nielivanchovile unyamalago u Isaya, ukhuta, ");
INSERT INTO zgam_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Mulolage umbombi vango uvieniegaanile une muugaati munumbula yango niengaaniele. Nivieka inumbula yango muugaati mumwene, unkhuta avavulaghe avanyampaji uvuhiegi. ");
INSERT INTO zgam_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Salatabeikha hange nukhuliela na mankha; hange asikhuli uyakhiva ipuliekha iliemenyu lyamwene munjila. ");
INSERT INTO zgam_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Saladeenya aligugu alepunuikhe; salanchimya ikhiesikhi eikhihumya eilyosi, ukhuduga uvuhiegi ukhuwesya. ");
INSERT INTO zgam_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Avanyapanji pwu vivinchaga va nuhuvila munditawa ilyamwene. ");
INSERT INTO zgam_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Pwu vankhandetela umunu uvyabifwile amiho ububu, unyaniepo imbivi khwa Yesu. Unkhuta anjaviele akhanjaviela akhapona, umunu ula akhapona ankhalola nunkhuchova. ");
INSERT INTO zgam_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Avanu aviingi voni valienkhudegha nu nkhunchova, unkhuta “Uyu samwana va Daudi?” ");
INSERT INTO zgam_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Avafalisayo vuvapuliekhe ienkhiedego iekhi, vakhata, “'Umunu uyu sihencha imepo imbivi khumakha agha mwene yuywa iekhencha khumankha aga Belzebuli, umbaha va mepo. ");
INSERT INTO zgam_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","“U Yesu aghamanyiele amasago gavene akhavavula akhata, “'Inkhilunga nkhingasambunkhilanile kyene khinangienkha, uvujeenge uwa nyumba vungalekhehane vuwa savukhieme. ");
INSERT INTO zgam_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Iengave Usetano inkhung'encha Usetano uniene, pwu iva inkheihambula yuywa mumbwumi uwamwene. ");
INSERT INTO zgam_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Khunjiela yieliekhu uvutwa uwa mwene vuliemiekhiwa? Inave ihencha imepo imbivi khumakha aga Belizabuli, avankongi avanwene pwu vihumya khunjila yieliekhu? Khulugendo ulu valavavalamuli. ");
INSERT INTO zgam_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Inave iehencha iemepo imbivi khumakha aga a Mepo uva Nguluve, uludeva ulwakhukyanya lwiva lwinchile khulyumwe. ");
INSERT INTO zgam_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Umunu ikwingila ndakhiekhi munyumba yamunu unyamakha nukhuhiencha, vusankhungile umunu unyamakha? Pwi weesya ukhuhiencha ifinu munyumba. ");
INSERT INTO zgam_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Umunu uvieavenchaga yuywa salielipupaninie nune pwu iva alivuunge nune, hange uviesilundamania nune uywa vieihasania. (itaga) ");
INSERT INTO zgam_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Pwu nienchova nkhulyumwe, eimbivi eiyavienchaga nulubedo avanu visyiekhiliwagwa, pwu ukhumbeda uMepo umbalanche uywa salasyiekhiliwa. ");
INSERT INTO zgam_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Uvieavinchaga uvieinchova eilimenyu vunge nu mwana va Adamu, ielyo lisyiekhiliwa. Hange uviavenchaga uvieinchova vunge khu Mepo umbalanche, uywa salasyiekhiliwa mukhilunga iekhi, na khikhilunga ikhikyuncha. ");
INSERT INTO zgam_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Pwu uvombe umbinki ukhuva guuve ni nsenkhe inonu, apange unange uguu nange umbinkhi ugwa sekhe na nchisekhe ncha yene, ulwa khuva umbinkhi gwumanyiekhikha nisenkhe ncha yene. ");
INSERT INTO zgam_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Umwe mwivaholilwa va njonkha, umwe mulievavivi, ndamuwesya ukhunchova imbombo inonu? Ulwa khuva undomo gwinchova inchihuma munumbula yamunu. ");
INSERT INTO zgam_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Umunu unonu munumbula yamwene inchueivikhile inchova inonu, numunu umbivi munumbula yamwene inchova imbivi inchuiviekhile. ");
INSERT INTO zgam_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Lino pwu ninkhuvavula ukhuta khila limenyu ilyuinchova umunu lya lahomya eimbalilo ilinchuva eilyavuhieghi. ");
INSERT INTO zgam_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ulwa khuva khumamenyu ghankho ulavalieliwa imbalielo khuvuyilweli wa mamenyu ghako ulahiegiewa.” ");
INSERT INTO zgam_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pwu avanklani na Vafalisayo vakhamwa khwa Yesu vakhata “Imanyisi, twinogwa twale tulole iekhimanyielo ukhuhuma khulwuve.” ");
INSERT INTO zgam_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Hange uYesu akhamula nu khuvavula, “Uvuholwa uvuvivi ikya vuliigu khilondo eikhimanyielo. Khisikhuli inkhiemanyilo eikyakhiva khihumila khuvene khumbe ikhiemanyilo ikya Yona unyamalago. ");
INSERT INTO zgam_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nduvu unyamalago uYona atamile mulitumbu eilya somba eimbaha amanchuva ghaatadatu pamusi na pakhilo, vule vule umwana va Adamu wayiva mughati munumbula ya nkhilunga khumanchuva ghadatu pamusi na pankhilo. ");
INSERT INTO zgam_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Avanu avakhu Ninawi valiema pavulongolo pavuhieghi pwu paninie na vaholwa avalieno ava. Ulwa khuva vavombile imbivi vakhapela wie lumbiliela u Yona, ulwa khuva khwale apa umunu umbaha ukhulutielila khwa Yona. ");
INSERT INTO zgam_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Unkhuludeva undala uvakhusikha alatogha pwu paninie khuvuhieghi na vanu avakhivumbukho iekhi nukhukhihiega ukhuta valie nimbivi. Ulwa khuva umwene akhumile uluvafu ulwa khuvusilielo wa nkhilunga ukhwincha khupuliehiencha uluhala ulwa Selemani, lola apa pwale umunu umbaha uvalutielile khwa Selemani. ");
INSERT INTO zgam_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Vui imepo imbivi vunchi huma khumunu, nchihumili apoonu upwu ghasipali amaghasi vughilonda apakhughataluka, humbe pasipali. ");
INSERT INTO zgam_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Pwu nchita, 'nighodonkha khukhaya ukhuniehumile khunyumba yango iyounihumile.' Vuikhilivukha pwivona inyumba iela yiekhuniwe yieviekhiwe vunonu. ");
INSERT INTO zgam_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Pwu iluuta inchikhunchi ghegha inchinghe imepo imbivi saba imbivi ukhulutielila khumwene, pwu nchikhwicha nchitamaga numwene upwa lyiepo. Umwakhavelile pakhusila pwu iva pavuvivi huba pavutengulielo. Vuyakhieva khiva ikhievumbukho ikhie eikhivivi. ");
INSERT INTO zgam_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","U Yesu vuinchova na vanu avinghi, uvanina navalukhololwe vaeimile khunji, valiekhunogwa ukhunchova nave. ");
INSERT INTO zgam_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Umunu yumo akhaluta akhambula, “Akha ujyuva vako navalukhololwo veimile panchi, vinkhukhulonda vinogwa ukhunchova nuve”. ");
INSERT INTO zgam_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Akhamula akhata uvyambulile ujyuva vango veini? na valukholo lwango veini?” ");
INSERT INTO zgam_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Umwene akhinula iekhievokha kya mwene khuvakhongi vamwene akhanchova, “Lola, uyou vie jyuva vango navalunkholo lwango! ");
INSERT INTO zgam_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ulwa khuva umunu uvieivombo uwieghane wa Dada vango vuuakhukyanya, umunu uyou vilukholo lwango, ving'anchavango hange vijyuva vango”. ");
INSERT INTO zgam_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Eilinchuva eilyo uYesu akhakhegha munyumba akhaluta khulukhanji khu nyanja akhatama. ");
INSERT INTO zgam_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Avanu avinghi valundamine, vakhanchungula, umwene pwakhingile mumbwato akhatama mughati. Avanu avinghi pwu vakheima khulukanji khu nyanja. ");
INSERT INTO zgam_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Pwu akhavavula ifinu finghi aliekhuhwananincha ni fihwani, alikhunchova, “Mlole, umbyalie alutiele khuvyala. ");
INSERT INTO zgam_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Aliekhuvyale ienchinghe iesekhe nchiliekhugwa mu njiela pwu fikhincha ifideghe fikhahola. ");
INSERT INTO zgam_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Inchinghe nchikhagwa palunalawe, incho sanchakhave ung'anga mwingi ukhuta nchimelaghe. Nchikhamela ulwa khuva ung'anga gwale indebe. ");
INSERT INTO zgam_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pwu ulunchuva lwavile lwivala lukhanyanya iemilela ulwa khuva gyale pakanya ung'anga gwale iedebe pwu nchikhuma. ");
INSERT INTO zgam_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Iembeyu inchienghe nchagwile mumintwinyo. Eimitwinyo gheikhakhula ghekhava mitali ukhulutielila inchene pwu nchikhalemwa ukhukhula. ");
INSERT INTO zgam_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Iembeyu inchienghe nchikhagwa mung'anga unonu, nchikhamela nukhuhupa, inchienghe nchikhahola mala mia moja, inchinge sitini, inchingi salasini. ");
INSERT INTO zgam_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Umwene uvyalienie mbulukhutu inchakhupulikha apuliekhaghe. ");
INSERT INTO zgam_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Avankhongi va mwene vakhincha vakhambuncha u Yesu, “Khinu khiekhi inkhewienchova na vanu wienchova nifiehwaniehencho?” ");
INSERT INTO zgam_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","UYesu akhavanda akhata, “Umwe mkhavile ukhunchimanya inchilikhuvutitu incha ludeva ulwa khukyanya, avene savakavile. ");
INSERT INTO zgam_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ulwa khuva umwene yuywa alienafwo ifinu uywa vie vieikyongelenchiwa ifinghe, hangha pwiva nafyo ukhulutielila. Uvalievuvule hange nakhikyo alienakyo pwu ipokhiwa kyope. ");
INSERT INTO zgam_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Pwu ninchova nawo khufikhwani ulwa khuva vangalolaghe savakhalolaghe. Hanghe vangapuliekhaghe valekhe ukhupuliekha, hanghe valekhaghe ukhunchimanya. ");
INSERT INTO zgam_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Eilimenyu lya nyamalago uIsaya lievombikhe khuvene pwu lita, ukhuphulikha mpulikhagha hanghe samukhanchimanyaghe. ");
INSERT INTO zgam_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ulwa khuva ienumbula incha vanu ava nchivile nchitu, niembulukhuto nchavo sanchipulikha vunonu, namiho gha vene vasisiliele, ukhuta valekhe ukhulola na miho ghavene, vakhaphulikha ni mbulukhuto nchavene, vakhanchimanya ni numbula nchavene vakhasyetukha, une nikhavapokha.” ");
INSERT INTO zgam_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Musayiwe ulwa khuva amiho gheinyo ghilola, nie mbulukhuto ncheinyo nchiepuliekha. ");
INSERT INTO zgam_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mwiedhiekhaghe nikhuvavula, avanya malagho avingi na vanu avanya lwiedhikho vanogwagwa ukhunchivona nchila unchumukhunchivono. Valemilwe ukhunchievona, vanoghilwe ukhuphulikha imbombo iela inchumupuliekha, savakhapuliekha. ");
INSERT INTO zgam_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Pwu mupuliekhaghe lieno ienongwa iya mbyalii. ");
INSERT INTO zgam_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Umunu uvieiphuliekha eilimenyu ilya ludeva ulwa khukyanya alekhaghe ukhuliemanya, umbivi pwu ikhwincha itola eiliekhavyaliwe munumbula mumwene. Eiyi yu mbeyu iyavyaliwe munundukhanji munjila. ");
INSERT INTO zgam_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Uvya vyaliwe mundunalawe vie ule uvyaliephokhiele ielimenyo nukhuhovoka. ");
INSERT INTO zgam_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Alivale eimilela mughati mumwene, lietama unsiekhe iendebe. Pwu yienghahumile ietabu apanghe ukhuhanghayiekha khu nongwa ya liemenyu, umwene pwu iviepha iembeive. ");
INSERT INTO zgam_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Uvieavyaliwe mumintwinyo, uyuo vieiphulikha eilimenyu iekwaghana ni mbombo incha nkhilunga nifwa vunongwe uwankhielungha pwu nchikhu mpelela ukhuta ielimenyu lielekhe ukhupa iesekhe. ");
INSERT INTO zgam_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Uviavyaliwe mung'anga unonu. Uyuo veihola isekhe na vienchiholagha isekhe nchunyingi mala mia, iyeinge sitini, iyeingi salasini.” ");
INSERT INTO zgam_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","UYesu akhavapha eikhikhwani eikhinghe. Akhanchova, “Uludeva lwa khukyanya luhwanine numu yuywa avyalile iembeyu mukyalo kya mwene. ");
INSERT INTO zgam_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Vuvaghonelile avanu pwu vakhancha avalughu vamwene akhavyale amanyasi munganu vakhahegha vakhaghodokha. ");
INSERT INTO zgam_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ingano yiekhamela nukhuhupha, na ghamanyasi ghope ghakhamela. ");
INSERT INTO zgam_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Avavombi va nyakyalo vakhincha vakhambuncha unyakyalo vakhata, 'Khikhi sawauyale iembeyu einonu mukyalo kyako? Khihumile khikhi lino mbona ghamelile amanyasi? ");
INSERT INTO zgam_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Akhavavula akhata, undughu avombile imbombo inchi.' Avavomba mbombo vakhambola vakhata, “Lino wienogwa tukhakhupule?” ");
INSERT INTO zgam_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Unyakyalo akhanchova akhata, 'Mwielekhelwe, ukhuluta khukupula, ulwa khuva vumukhupula amanyasi pwu mukhupulagha nayie ngano pwu paninie. ");
INSERT INTO zgam_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mughalekhe ghakhula pupaninie ukhudugha upwakhiva gwifikha unsiekhi ugwakhubena. Unsiekhi ugwakhubena niela vavula aviebena ukhuta, 'Mutale ukhunkhupula amanyasi mughakhunghe mumwoto, pwu mulundamanie einganu tuviekhe mukhibana kyango.” ");
INSERT INTO zgam_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","U Yesu akhavavula ikhikhwani hincho ikhinghe. Akhata, “'Uludeve ulwa khukyanya lukhwanine nie mbeyu iya haladali(iendebe nno) yienyo umunu atoliele akhaluta kuvyala mukyalo ikya mwene. ");
INSERT INTO zgam_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Eimbeyu eiye nini eno(ndebe) ukhulutilila imbeyu inchinghe nchoni. Vuyimela nukhukhula pwu yiekhula yive iembiekhi imbaha ukhulutilila ambiekhi eghienghe mukyalo pwu ifidege ifya munkyanya vikwinchaga vikwemaga nukhughataluka pakyanya pa mbikhi finchengagha nuvufumba mumaswatu gha mbikhe.” ");
INSERT INTO zgam_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Akhavapha ikhikhwananincho eikhinghe akhata. “Uludeva ulwa khukyanya lukyanine nie khinu ikhilulile khikyo undala atolile akhapima ifiphimielo fidatu akhahanjania mumbutine woni vukhatutuma. ");
INSERT INTO zgam_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nchoni ienchi uYesu anchovile pavanu avinghi nukhuhwananincha ifihwani. Ukhulekha ifyakhuhwananincha pwu salikhunchova khinu. ");
INSERT INTO zgam_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ukhuva nchila inchanchoviwe navanyamalagho nchivonekhaghe, upwu inchova, “Uyunikyama undomo gwangho ukhuchova khufihwani. Uyuninchova imbombo nchincho nchikhale khuvutitu ukhuhuva khuvutenghulilo uwa khilunga.” ");
INSERT INTO zgam_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pwu uYesu akhavalekha avanu vinghi akhaghodokha khumyave. Pwu avakhongi avamwene vakhankongha vakhata, “Utuvule vunonu ikhihwani ikyamasi mukyalo.” ");
INSERT INTO zgam_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","U Yesu akhavanda akhata, “Uvie ivyala iembeyu inonu vei mwana va Adamu. ");
INSERT INTO zgam_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Eikyalo kyu khilunga; imbeyu einonu vuvana avakhuludeva. na manyasi vuvana ava ndughu untavangwa, nuu mbivi uviavyalile vei setano. ");
INSERT INTO zgam_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Uvubeni vuvusililo uwa khilunga, aviebena vuvasuhwa va nghuluve. ");
INSERT INTO zgam_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Amanyasi vughilundama nukhu nyanya mu mwoto, vuyilava eiwo khuvumalilo uwa khilunga. ");
INSERT INTO zgam_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Umwana va Adamu alasuha avasung'wa vamwene, ukhwincha khuluondamania ukhuhuma khuludeva ulwa mwene imbombo nchoni inchikhapelagha imbivi na voni avakhavombagha inchambivi. ");
INSERT INTO zgam_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Voni valalahiwa mundighuli eilya mwoto, ukhwa khukhulava nikhililo nukhuheveta amino. ");
INSERT INTO zgam_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pwu avanu vavo vavombagha inonu valang'ala ndielinchuva khuludeva ulwa Dada vavo. Uvyalieni mbulukhuto aphuliekhaghe. ");
INSERT INTO zgam_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Uludeva ulwa khukyanya luliehani niekhiebana khikyo khiefihiele mukyalo. Umunu akhakhievona akhafiha. Munduhekhelo ulwa mwene pwu akhaluta khwighuncha fyoni fifwo akhale nafwo, nukhughula eikyalo. ");
INSERT INTO zgam_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Hange uludeva ulwa khukyanya luleindumunu unchulusi uvieilonda ulutalama ulunonu ulwa khukhava indalama inchiluteilile. ");
INSERT INTO zgam_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Aviele akhaviele uluntalama ulunonu ulualondagha, ankhaluta ankhaghuncha iefyuale nafyo fyoni ankhanchighula ulutalama uluanoghielwe. ");
INSERT INTO zgam_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Uludeva ulwa khukyanya luliehaniele ni nyafu inchilakhiwa munyanja, pwu nchi lundamania khila khinu eikhiliemaghasi. ");
INSERT INTO zgam_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Vunchidieghile avalovi pwu vikhweghela khulu nkhanji vitama pasi, pwu visalula iefinonu vinhola viveikha mu fyombo, ifisafielondiwa pwu viekhufietagha khuvutali. ");
INSERT INTO zgam_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Vuyielava eiwo eilinchuva eilya khusiliela eikhilunga. avasuhwa valukhumila, valavakhencha avavomba mbivi voni mughati mbavo vivomba ienonu. ");
INSERT INTO zgam_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Pwu valavatagha mundighuli ilya mwoto, pwu khulava nikhilielo nukhu kheveta amino. ");
INSERT INTO zgam_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","U Yesu akhavavuncha munchimanyile imbombo nchoni? Avankhongi va mwene vakhanda vakhata, “Ena.” ");
INSERT INTO zgam_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Pwu u Yesu ankhavavula akhata, “'Khila nkhalani yuoywa aviele nkhonghi va ludeva ulya khukyanya, akhwanine nunyanyumba uvie ihumya mukhibana kyamwene iehomya ifinu ifiepya nie finkhulu.” ");
INSERT INTO zgam_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","U Yesu wa maliele iefikhwanie kheincho, akhakhegha pala upwuale. ");
INSERT INTO zgam_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","U Yesu wanchifikhe khukhielunga eikya khumyave ukhu aliekhunchikhuvamanyisya avanu muntembiele. Pwu valiekhudhegha valiekhuta uyuo atoliele ndakhu uluhala uolu nie fidhehgo iefii? ");
INSERT INTO zgam_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Umunu uyou samwana vaselemala? uMariamu ndasavie vanina? Avalokhololwe savuva Yakobo, Yusufu, Simoni nu Yuda? ");
INSERT INTO zgam_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Navahanchave tulie navo apha pakhaya? Khumbe umunu uyou anchiwene ndhakhu ienchi nchoni?”. ");
INSERT INTO zgam_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Vakhaviphinchana. U Yesu akhavavula, “Unyamulagho sakhalemwe ukhudwadiwa. Khumyave sakhadwadiwe na mumu nkhielunga ikya myiave. ");
INSERT INTO zgam_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Pwu akhilekhelwa ukhuvomba ifiedhekho finghi khumyave ulwa khuva savaliekhumwiedhikha. ");
INSERT INTO zgam_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Unsiekhie ghula, u Helode akhaphulikha imbombo incha Yesu. ");
INSERT INTO zgam_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Akhavavula avavombi va mwene, “Uyou vi Yohana umwonchi anchukhiele ukhuhuma khuvuwe. Amakha ghamwene ghakhale ghipivomba eimbombo khumwene.” ");
INSERT INTO zgam_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ulwa khuva u Herode amwibite u Yohana akhankhungha akhanchikhundhaha munyololo, kunongo iya Herodia, undhala uvava Filipo va nkaghaye. ");
INSERT INTO zgam_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ulwa khuva u Yohana ambuliele akhata, “Salukhale lwiva lunonu ukhuva ave indhala vakho.” ");
INSERT INTO zgam_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","U Herode akhalonda unkhumbuda pwa akhadwada khuvanu ulwakhu avanu vambwene u Yohana ukhuta inyamalagho. ");
INSERT INTO zgam_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Lyavile linchuva ilya lukhenkhelo ukhumbukha eilinchuva lielyo aholiwe u Herode umwa uva Herodia akhaneva vunonu phaghati phavanu u Herode akhanogwa. ");
INSERT INTO zgam_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Pwa anchovile akhijyiegha akhata uyuniekhukhupa khila khinu khikyo uvywinogwa une nikhukhupa. ");
INSERT INTO zgam_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Umwana ula vakhanchovana nu vanina akhata, udove, “Akhuphe mukhekhombe untwe ugwa Yohana Uvikwoncha.” ");
INSERT INTO zgam_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Untwa adwadile nukhusagha akhavona inchi mbaha, ulwakhu aeinjyeghile, pavulongolo pavanu vavo vyalinchagha ikyakhula pamesa numwene pwa khata vakhalete. ");
INSERT INTO zgam_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Akhansuha umunu ankhandete u Yohana khunyololo ");
INSERT INTO zgam_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","pwu vakhaghieola untwe ugwa Yohana vakhagheghela ungiencha musahani akhuphiela akhahielikha khwa vanina. ");
INSERT INTO zgam_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Avankhongi va mwene pwu vakha mpiemba umfimba ghula vakhaluta khusyiela, vuvasyelile vakhaluta khukhombula u Yesu, einongwa ieyo. ");
INSERT INTO zgam_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","U Yesu waphulikhe inongwa iencho, akhahegha phala akhaluta pavutali akhatoghe munghalava akhaluta khukhilunga eikhenghe, avanu vinghi vaviele vaphuliekhe ukhuta aheghile pwu vakhaghenda na malunde vakhankhonga ukhuluta khukhilungha ukhwalutiele. ");
INSERT INTO zgam_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Hanghe u Yesu akhavavona avanu avinghi phavolongolo pa mwene avankhonghile. Akhava kholela ikhiesa pwu akhavayavila avatanu vavo vainchile navo. ");
INSERT INTO zgam_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Lyakhiemihe avankhonghi va mwene vakhaluta khumwene vakhanchova vakhata, “Apha tuliephalukhunghu eilinchuva lielutile. Vavule avanu vaghodokhaghe khuvunchenghe wa vene vakhaghule ikyakhula kya khula. ");
INSERT INTO zgam_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","U Yesu akhavavula akhata ava savakhaghodokhe, “Umwe muvape eikyakhula.” ");
INSERT INTO zgam_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Vakhambula, “Apha tulienie nie fisyesye fihano ni somba ieveli vuvule.” ");
INSERT INTO zgam_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","U Yesu akhanchova akhata, “Mume une.” ");
INSERT INTO zgam_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","U Yesu akhavavula avanu vatame pasi pamanyasi. Pwu akhatola ifisyesye fihano nie somba ieveile. Akhalola khukyanya, akhamanyula akhavapa avankongi. Avankhonghi vakhavaghaviela avanu avienghi. ");
INSERT INTO zgam_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Pwu vakhalya voni vakhighuta. Pwu vakhalundamania ififyasighile fikhadhiegha ifitundhu khinchigho nifi vielie. ");
INSERT INTO zgam_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Avanu avalile avaghosi ava elfu vahano avadala savavaliwe na vavanana vophe savavaliewe. ");
INSERT INTO zgam_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pwu akhata khuvankonghi va mwene vienghiele muwato, vakheghe ukhulonghola ukhuluta khumwambo, umwene vuikhelagha khuvanu vavo vale vinghi. ");
INSERT INTO zgam_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Vueilaghile khuvanu ukhuta vaghodhokhaghe, umwene pwu akhakhegha akhaluta khuvutitu khukhwisaya mwene. Yiekhava lyakhiemihe akhava mwene. ");
INSERT INTO zgam_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Vuvafikhe phaghati pha nyanja ienghava pwu yieliekwelela ulakhuva khwale numbelo nukhulughuta gwale imbaha. ");
INSERT INTO zgam_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pwu pakhilo eikhilo iya nne u Yesu akhava pawipi, aliekhughenda pakyanya pa maghasi munyanja. ");
INSERT INTO zgam_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Avakhonghi vamwene, vuvawene u Yesu eighenda pakyanya pamaghasi vakhadwadha vakhata khipepenchela, vankhakhuta vakhapwata khumakha khuvundwanchi. ");
INSERT INTO zgam_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nambievie u Yesu akhavavula akhata, “Vulekhe uvudwanchi, inumbula nchienyo nchielekha ukhudwada nene, mweilekhelwe ukhudwada.” ");
INSERT INTO zgam_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","U Petro akhanda akhata, “Ntwa, ienave veve, wiembule nayune ninche khulyuve nieghende pakyanya phamaghasi.” ");
INSERT INTO zgam_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Akhanchova akhata, “lenchaga.” U Petro akhikha mukyombo, akhaluta na malunde pakyanya pamaghasi ukhuluta khwa Yesu. ");
INSERT INTO zgam_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pwu u Petro aviele ieluta khwa Yesu akhalola unkhulughutu nu umbelo akhadwada, akhatenghula ukhwikha phasi pamaghasi, akhovela khulimenyu eilivaha akhata, “Nkhuludeva, iemokhe!” ");
INSERT INTO zgam_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","U Yesu akhagholola eikhievokho kya mwene iembive akhamwibata akhankwegha u Petro, akhambula, “Uve ulienu lyiedhikho ludhebe, khikhi ukhale nuvundwanchi?” ");
INSERT INTO zgam_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","U Petro akhinghile mughati munghalava eimephu yiekhanunala. ");
INSERT INTO zgam_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Avankhongi vavo vale mughati mukyombo, vakhansana u Yesu vakhanchova vakhata, “Lweli uve ulie Nswambe va Nghuluve.” ");
INSERT INTO zgam_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Vuvalowiekhe vakhafikha, khukhilungha iekya khu Genesareti. ");
INSERT INTO zgam_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Avanu ava khwonu ukhwa vuvalumanyile ukhuta vie Yesu, pwu valikhunchova ukhuvavula avanu avaukhwa khufilungha fifwo filiemulonkhanji mbunjenghe uwa ukhu, pwu vakhavaghegha avanu voni vavo vale vatamu. ");
INSERT INTO zgam_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Pwu valiekhudova nukhusiemieliencha ukhuta tudova twiebate ulughonjo ulwa mwenda gwakho, avienghi vavo vaibiete vaponile vunonu. ");
INSERT INTO zgam_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pwu Avafalisayo na vankhalani ukhua ku Yerusalemu. Vakhandhutiela u Yesu vakhanchova, ");
INSERT INTO zgam_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Khikhi avankhonghi vakho vienangha indagheilo incha vaghogholo veitu? Ulwa khuva savinkhalava amavokho ghavene vuvilya eikyakhula.” ");
INSERT INTO zgam_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","U Yesu akhanda akhavavula ankhata, “Mbhona na yumwe munanga ululaghilo ulwa Nguluve wuu mukhulyuphielila? ");
INSERT INTO zgam_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ulwa khuva uNguluve anchovile, 'Umwiemiekhaghe udada vankho na yuo vanina vankho; uvie inkhudhukha udadaye aphange uvanina uva mwene ukhuwa afwinchaghe.' ");
INSERT INTO zgam_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Hanghe umwe mwinchova, 'Uvikhumbula udadaye na yu vanina va mwene, eikhilondiwa ukhutangheiliwa avatanghe noune khiva khisayiwe nwu Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Umunu uveisinkhu ndwandwa udadaye nu vanina, lua ananghiela eilimenyu lya Nghuluve khumighendele igwumwuphielile. ");
INSERT INTO zgam_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Umwe mwievadhesi, luononu nduvuu u Isaya anchovile mumalagho pwu akhata, ");
INSERT INTO zgam_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","'Avanu ava vikhunsana une khumilomo gyavene, khumbe ienumbula ncha vene nchilikhutali nune. ");
INSERT INTO zgam_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ukhutekhela khuwitekhela vuvule, ulumanyisyo uluviemanyisya lya vanu.” ");
INSERT INTO zgam_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Akhavielangha avanu akhavavula, “Muphuliekhienche mulumanye— ");
INSERT INTO zgam_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Khiekyo khikhwiengiela mundomo ugwamu khwisakhiviekha uvuvivi. Eikhihuma mundomo ugwamu eikyou khwio khikhumbiekha umunu uvuvivi.” ");
INSERT INTO zgam_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pwu avankhonghie vamwene vakhanduteila vakhambula vakhata, ulumanyiela ukhuta Avafalisayi vakhavile viephulikha eilimenyu liela vakhaviphiele?” ");
INSERT INTO zgam_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","U Yesu akhavavula akhata, “Eikhiemeliele kyene khikhwo Udada vango uvakhukyanya savyaliele, khilukhuphuliwa. ");
INSERT INTO zgam_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Valekhe, avo valonghonchi avabofwile amiho. Uveisilola amiho anghandongonche uniene yuywa silola, voni vuvavilie vigwa vikhwinghiela mundighuli.” ");
INSERT INTO zgam_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pwu uPetro akhamula akhambuncha u Yesu,” Uluvule ikhiekyani, ");
INSERT INTO zgam_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","u Yesu ankhandha akhata, “Nayumwe mukhale samukhulumanya? ");
INSERT INTO zgam_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Samukhalumanye ukhuta eikhikyunghile mundomo khiluta mundhitumbhu, khinchitaghiwa khulinyasi? ");
INSERT INTO zgam_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ulwa khuva iefinu fwoni iefihuma mundomo fikhuma mughati munumbula, vufieliewo ifienu fifwo vikhumbikha umunu uvuvivi. ");
INSERT INTO zgam_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ulwa khuva einumbula yiekhumya amasago amavivi, uvubudi, uvulieghu, uvumalalaya, uvulyasi, ukhunchova uvudheisi na ghamadhusi. ");
INSERT INTO zgam_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Inchi nchu mbombo nchincho nchikhumbikha umunu uvuvivi.” ");
INSERT INTO zgam_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","U Yesu pwakhahegha aphonu phala akhava pavutali akhaluta khuvunchenghe uwa Tilo nakhu Sidoni. ");
INSERT INTO zgam_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Lola pwa khincha undhala u Nkhanani ukhuhuma uluvafu ulwa, akhatoncha eilimenyu akhanchova akhata, “Inanghe, Ntwa, vinswambe va Daudi; umwalievangho alienimepho iembivi nchikhunganghayiesya eino.” ");
INSERT INTO zgam_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Umwene sakhamwamula khinu. Avakhonghi vamwene vakhandutiela vakhandhova, vakhata, “Wieng'enche aghodokhaghe ulwa khuva iekhutuyweghela.” ");
INSERT INTO zgam_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","U Yesu akhavandha akhata, une saniekhasuhiewe khuvanu, nliekhasukhiwe khu ng'osi inchiyaghiele incha munyumba ya Israeli.” ");
INSERT INTO zgam_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Umwene akhincha akham fumiela, akhanchova, “Nkhuludeva weinanghe.” ");
INSERT INTO zgam_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Akhandha akhata, saluvile lunonu ukhutola eikyakhula ikyavana ulakhiela iembwa,” ");
INSERT INTO zgam_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Akhanchova, “Ena, Nkhuludeva, nanchimbwa nchihola eikyakhula eikhigwa pasi pha mesa iya Nkhuludeva vavo.” ");
INSERT INTO zgam_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Pwu u Yesu akhanda akhata, “Viendhala uve, ulweidhikho lwakho luvaha. Nchivombekhe khulyuve nduvukha nogwagwa. “Umwana va mwene akhaphona usienkhe ghugwa. ");
INSERT INTO zgam_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","U Yesu akhahegha pala akhaluta ukhukheghelela nie nyanja iya khu Galilaya. Akhatogha khukyamba aliekhunchima ukhwa. ");
INSERT INTO zgam_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Avanu avienghi vakhincha khumwene, vakhavaghegha avikyafula, avasavilola, avasavinchova, avalemilwe na vanghe avienghi vavo vale vatamu. Vakhavaviekha mumalunde ghamwene valiekhupona. ");
INSERT INTO zgam_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Avanu pwu valiekhudhegha ukhuvona vavosavinchova vinchova, avalemilwe viva vanonu, avikwafula vieghenda, na vavo savielola vielola. Pwu vakhanghinia uNguluve uva Vanyaisraeli. ");
INSERT INTO zgam_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","U Yesu akhavilangha avankhongi vamwene akhanchova, “Nikhuvankholela eikhisa avanu ulwa khuva vakhanchighagha nune amanchuva ghadatu savaliele khinu. Saniekhilaghe ukhuta vaghokhaghe nie njala ulwa khuva uyuvienchiliekha munjiela.” ");
INSERT INTO zgam_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Avankhonghi vamwene vakhambula, “Tunchilonda ndhakhu ifisyesye ifyakhwielanila avanu voni ava ukhuta valye vighute ulwa khuva vienghi hanghe tuliephalunyikha?” ");
INSERT INTO zgam_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","U Yesu akhavavuncha akhata, '“Mleini fisyesye filienghi?” Vakhata, “Saba, ni somba ndebe.'” ");
INSERT INTO zgam_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","U Yesu pwu akhavavula avanu akhata vatame phasi. ");
INSERT INTO zgam_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Akhatola ifisyesye saba nie somba, akhasana, akhamanyula akhavapa avankhonghi. Avankhonghi vakhavapha avanu. ");
INSERT INTO zgam_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Avanu vakhalya vakhakwielanila vakhighuta. Pwu vakhalundamanie ifiemenyuleilo ifyasigiele fikhadhiegha fitundu saba. ");
INSERT INTO zgam_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Avanu voni vavo valiele vale avaghosi avaelfu vanne avadala na vana savavaliewe. ");
INSERT INTO zgam_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pwu u Yesu akhielagha khuvanu ukhuta vaghodokhaghe na vope akhatogha munghalava ukhuluta uluvafu ulwa khu Magadani. ");
INSERT INTO zgam_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Avafalisayo nava Sadukayo vakhincha khukhonghela u Yesu avavonesye iekhimanyielo khikyo khikhuma khukyanya. ");
INSERT INTO zgam_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Akhamula akhavavula, (yienghave) lyakhiemikhe, pwu mwita eilelo khunonu, ulwa khuva uvuntandhanche wieva vudhukhu. ");
INSERT INTO zgam_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Pope panavusikhu mwienchova, 'Eilelo kwiva nie mephu, ulwa khuva khukyanya khudhukhu namaveingho ghaghubiekhe khukyanya khwoni.' Mukhiemanyile ukhulola uvutandhanche uwakhukyanya, hanghe samukhimanyile ukhulola ifivonekhelo ifya miesiekhie. ");
INSERT INTO zgam_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Uvuholiwa uvuvi uwa vulieghu vulondha eikhimanyilo, pwu khikhuli eikhiemanyielo, sakhikhinche eikhimanyielo, aphanghe khila ikya Yona. ");
INSERT INTO zgam_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Avankhonghi vakhaluta, pwu samilwe ukhutola ifisyesye. ");
INSERT INTO zgam_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","U Yesu akhavavula “Mwilolelaghe uvinchaghe miho nuvuvivi uwa Mafalisayo nava Masadukayo.” ");
INSERT INTO zgam_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Avankonghi pwu vakha niehana vavo pwu vakhata, “Ulwa khuva satukhagheghe ifisyesye. ");
INSERT INTO zgam_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","U Yesu alimanyile eilyo akhanchova, “'Khikhi iekyu mubenchana yumwe, umwe mwie vanyalwidhikho ludebe, ulwa khuva samukhagheghe ifisyesye? ");
INSERT INTO zgam_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Samulumanyile bado hanghe samukhumbukha ifisyesye fila vihano khuvanu ava elfu vahano, nie fitundhu filienghi fifwo malundanienche? ");
INSERT INTO zgam_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Aphanghe ifisyesye saba kuvanu ava elfu vanne, ifintundhu filienghi fifyo mukhalundaninche? ");
INSERT INTO zgam_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Pwu nchivile ndhakhikhi samukhalumanye ukhuta saniekha nchovangha numwe ukhulancha khufisyesye? Mwielolelaghe nava Mafalisayo na va Masadukayo uvuvivi vuwa valienawo.” ");
INSERT INTO zgam_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Pwu vakhalumanya ukhuta sakhanchova na vene ukhuta vie lolelaghe nie fisyesye ifivivi, khumbe alikhunchova ukhuta vilolelaghe nava Mafalisayo na va Masadukayo. ");
INSERT INTO zgam_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","U Yesu wanchifiekhe uluvafu ulunghe ulwakhu Kaisaria iya Filipi, akhavavuncha avankonghi vamwene ankhata, “'Avanu vinchova vita umwana va Adamu vita viveni?” ");
INSERT INTO zgam_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Vakhata, “Avanghe vita vie Yohana Umwonchi; avanghe vita vie Eliya; avanghe vieta vie Yeremia, au uhwanine nunyamalagho. ");
INSERT INTO zgam_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Akhavavula akhata, umwe mwieta une nene veni? ");
INSERT INTO zgam_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","U Simoni Petro akhamula ankhata, “Uve veve Klisiti vie mwana va Nghuluve yuve uliemwumi.” ");
INSERT INTO zgam_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","U Yesu akhamwamula akhata, “Usayiewe uve, Simoni Bar Yona, ulwa khuva unkhisa nie nyama safikhakhuvoneikhiele khwieli, ulwa khuva u Dada vangho uvakhukyanya. ");
INSERT INTO zgam_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Akhata nayuve nikhukhuvula unkhuta uve veve Petro, hanghe pakyanya phalunalawe ulu uyunienchengha iemilyangho eikya khuvufwe saghiekhawesye. ");
INSERT INTO zgam_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Une nikhukhupha ifunghulu inchakhudiendulila khuludeva ulwa khukyanya. Eikyakhiva vudhienda mukhielungha khiva khiedhendhiwe nakhukhukyanya, khiekyo khiedhiendhuliwa mukhielungha na khukhukyanya khidhiendhuliwa.” ");
INSERT INTO zgam_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","U Yesu akhava mbencha avankhonghi vamwene ukhuta valekhe ukhuvavula avanu voni ukhuta umwene akhale vei Klisiti. ");
INSERT INTO zgam_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ukhuhuma unsiekhi ughwa u Yesu akhatenghula ukhuvavula vankhonghi va mwene, ukhuta umwene phanoghile ukhuluta khu Yerusalemu, nu khunchitesiwe khunonghwa inchielutielile na vaghogholo nuva vavaha avamakhuhani na iviesimba, nukhufwa hanghe eilinchuva eilyadhatu alanchukha. ");
INSERT INTO zgam_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pwu u Petro ankhuntola, akhutenghula unkhudhukha, alikhuta, sio, lweli, Ntwa, inchi sanchikhakhuvone. ");
INSERT INTO zgam_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pwu u Yesu akhasyetuka khusana akhambula u Petro khilivukha khunsana khulyune uliesetano! Uve veve vunkhunsigha une, ulwa khuva uve savuwesya inchanghuluve, incha vanu chuvuwesya.” ");
INSERT INTO zgam_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pwu u Yesu akhavavula avankhongi vamwene akhata, “'Inave umunu inoghwa unkhu ng'ongha une, eisaghiele tasi ivone yuywa, eitwienkhe iekhidhamihani kya mwene, ang'oonghaghe. ");
INSERT INTO zgam_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ulwa khuva umunu uvieinoghwa ukwiphokha uwumi uwa mwene, ayikhuvuyancha, numu uvieinogwa ukhuyancha uwumi wa mwene khulyune, ayiphona. ");
INSERT INTO zgam_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Khulikhekhi umunu ukhukhava ikhilungha kyoni khanghe ayanche uwumi uwa mwene? Pwa yiekhava khikhi umunu ukhukhe uwumi uwa mwene? ");
INSERT INTO zgam_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ulwa khuva umwana va Adamu aliencha nu vuntwa uwa Dada vamwene nu va sukhwa vamwene. Pwala ng'oomba khilamunu ukhunkhonghana nie mbombo ncha mwene. ");
INSERT INTO zgam_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mwiedhikhaghe nikhuvavula, khuvale avanu avanghe aviemiela apha, vavo savalafwa upwu valava viekhombona umwana va Adamu vuinkhwincha nuvuntwa uwa mwene. ");
INSERT INTO zgam_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Vughasisile amanchuva sita u Yesu avatoliele pwu paninie numwene u Petro, nu Yakobo, nu Yohana ulunkhololwe, akhavahielikha ukhuluta ukhutogha khu kyamba eikhitali khuvutitu. ");
INSERT INTO zgam_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Khumiho khumwene khukhasyetuka khukava lumuli ndhu lwa linchuva. Emiendha gya mwene ghinkhang'ala ukhuta lumuli. ");
INSERT INTO zgam_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Pwu, vakhahumiela u Musa nu Eliya valiekhunchova nu mwene. ");
INSERT INTO zgam_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","U Petro akhamula, akhambula u Yesu, “Ntwa, ndalwiva lunonu ufywe ukhuva apha. Unghanongwe une pwuninchengha ifye violatu khiemo kyakho, khimo kya Musa, nie khinghe kya Eliya.” ");
INSERT INTO zgam_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Vu viphinchova, lola likhincha eiliviengho eilivalafu, liekhaviekha eikhiphe phenchela, puvu eilimenyu likhaphulienkhikha ukhuma khuliviengho, liekhanchova liekhata, “Uyu vie mwana vangho unghane uvienie nghaniele umwene, mumphuliehienchaghe umwene. ");
INSERT INTO zgam_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Avankhonghi va mwene vuvaphuliekhe ewo, vakhaghwa phasi valiekhufughafugha vakhadwda eino. ");
INSERT INTO zgam_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","U Yesu akhincha, akhaviebhata nu khunchova, “Mwieme mlekhe ukhundwada.” ");
INSERT INTO zgam_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pwu vakhinula amiho ghavene khukyanya savakhakhivona khienu, vakhambona u Yesu mwene. ");
INSERT INTO zgam_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Vaviele vikhyikha ukhuma khukyamba u Yesu pwakhavavula akhata mkhielekhelwe ukhuvavula avanu nchincho munchiwene khunu, “Iemphakha umwana va Adamu alava inchukha ukhuhama khuvufwe.” ");
INSERT INTO zgam_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Avankhonghi va mwene vakhambuncha vakhata, “Ulwa khuva khikhi avakhalani vinchova ukhuta, u Eliya alatala ukhwincha? ");
INSERT INTO zgam_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","U Yesu akhavamunu akhunchova, “Lweli u Eliya itala ukhwincha umwene vyalavomba nchoni inchi. ");
INSERT INTO zgam_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Hanghe nikhuvavula umwe ukhuta, u Eliya akhinchile, umwe samukhamanye. Pwu vakhambombile nchoni inchuvakhanoghwaghwa avane. Vulevule umwana va Adamu wayietesiwa ewo mumavokho ghavene.” ");
INSERT INTO zgam_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Pwa avankhonghi vakhaluma ukhuta akhanchovagha inonghwa iencha Yohana Uvikhwoncha. ");
INSERT INTO zgam_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Vuvafikhe pavanu avinghi, umunu yuomo akhandhutiela, akhafughama khuvulongholo khumwene, pwa khambula, ");
INSERT INTO zgam_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Nkhuludeva nidhova, unanghe umwana vangho alienielighonchi likhughwisya mumwoto aphanghe mumaghasi linkhung'angha yiesya eno ietabhiekha. ");
INSERT INTO zgam_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Niekhangheghile khuvankhonghi vakho vankhalemilwe ukhumphonia. ");
INSERT INTO zgam_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Pwu u Yesu akhanda akhata, “Umwe mwievaholwa yumwe samkhwidhikha, yuomwe muyaghile, nientamagha, numwe imphankha ndhieli? Mungheghe khulyune khunu.” ");
INSERT INTO zgam_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","U Yesu akhankhemela, iemepho nchikhahegha. Undhimi akhaphona unkhuhuma unsiekhe ghula. ");
INSERT INTO zgam_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pwu avankhonghi va Yesu vankhandutiela ukhuvutitu vakhambuncha vakhata, “Ufwe mbona tukhalemilwa ukhukhencha?” ");
INSERT INTO zgam_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","U Yesu akhavavula akhata, “Ulwa khuva ulywiedhinkho lweinyo ludhebhe. Mwiedhikhe nikhuvavula, inave mwiva nulwidhinkho ludhebe ndhie mbeyu iendhebe eiya haladali, ukhuta khiekheghe upwukhili pho khilelute phavunghe, kyophe khikhegha, ulwa khuva khiesikhuli eikhienu khiekyo eiyo ukhilemwa ukhuvombekha khulyumwe. ");
INSERT INTO zgam_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Ulwa khuva iemepho ndinchi sanchiwesya ukhuhegha, nchikhegho nukhudhova nukhufungha). ");
INSERT INTO zgam_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Vuvakhale viphitama khu Galilaya, uYesu akhavavula avankhonghi vamwene akhata, “Umwana va Adamu iluta khuviekhiwa mumavokho aghavanu. ");
INSERT INTO zgam_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Avanu avo vikhumbudha, haghe eilinchuva eilya dhatu alanchukha.'” Avankhonghi va mwene vasaghile ukhulutielila. ");
INSERT INTO zgam_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Vuvafikhe khu Kapelnaumu, avasonghasongho iya nusu sekeli vakhandhutiela u Petro vakhata, “Nayu manyisi venu iehomba eisongho eiya nusu sekheli?” ");
INSERT INTO zgam_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Umwene vuinghile nunyumba, akhambuncha akhata wivuna ndakhikhi Simoni? Avakhuludeva avankhilungha aviephokhela isongho aphanghe ukhuhombencha ukhuhuma khwani? Khuvana vavene aphanghe khuvagheni? ");
INSERT INTO zgam_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","U Petro akhata, “Ukhuma khuvagheni” U Yesu akavavula, aviloleliwa muvakhenche ukhosongha eisongho. ");
INSERT INTO zgam_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Aphanghe uyoutukhuvaviekha avasongha songho ukhutula einonghwa lutagha khunyanja, ukhalole iendhovana, ukhatole eisomba eyietala ukhwincha. Akhieva vudhiendhula undhomo gwa yeene, uyuovukhuyie vona mula isekheli yiemo. Utole ukhavape avasongha songho yieva yangho nuve. ");
INSERT INTO zgam_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Unsiekhe ghula avankonghi vakhincha khwa Yesu valikhumbula, “Vie veni uvavile imbaha kuludeva ulwa khukyanya?” ");
INSERT INTO zgam_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Pwu akhamwilangha umwa undhebe akhambiekha paghati pa vene, ");
INSERT INTO zgam_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","akhanchova, “Mwiedhikhaghe nikhuvavula, munghalekhe ukhunchilekha imbivi nukhuva ndavana avadhebe, samulienghila khuludheva ulwa Nguluve khukyanya. ");
INSERT INTO zgam_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Uvieikhieyisya mwene ndumwa udhebe, uywa veiva iembaha khu ludheva ulwa khukyanya. ");
INSERT INTO zgam_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nu vei ikhumwuphielila umwana undhebe khulitawa eilyangho iva ikhumokhela une. ");
INSERT INTO zgam_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Hanghe yuywa iekhunjancha umwana undhebe yumo avikhunyiedhiekha, pwu lwiva lunonu umunu uywa ukhunkungha musingho eiliwe eilivaha elya khuhevelela, nu khunchikhuntagha mughati munyanja. ");
INSERT INTO zgam_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ole khuva nkhilungha khumbombo incha khuyancha! Ulwa khuva nchilincha inongwa inchakhuyancha, ole khumunu uveighegha imbombo incha khuyancha! ");
INSERT INTO zgam_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Enghave eikhievokho kyakho fikhukhu yancha, ughiedhe utaghe khuvutali nuve. Pwu lwiva lunonu khulyuve ukwinghile khuludeva ulwa khukyanya vukhipungwikhe eikhivokho apanghe eikhilundhe. Hanghe unghave na mavokho ghavieli na malunde ghavieli utaghiwe mumwoto ghugwa saghulasila lusikhu. ");
INSERT INTO zgam_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nie liho lyakho lieghukhuyanche, uliehenche, ukhalietaghe pavutali nuve. Hoba ukwinghile khuludheva nie liho leimo eililola, nukwienghila na miho ghavile, nukhitaghiwa mu mumbuhighi uwa mwoto. ");
INSERT INTO zgam_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Mlolaghe mulavabeolagha udhebe yumo va ava. Niekhuvavula avasukhwa vavo avakhukyanya amanchuva ghoni vielola phamiho pha Dada vangho yaywa aliekhukyanya. ");
INSERT INTO zgam_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(“Ulwa khuva umwa va Adamu ainchile khukhie khiephokha khila iekhieyaghile). ");
INSERT INTO zgam_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mwilola ndakhikhi? Umunu anghave nie ng'osi miamoja, yeimo yie nghayaghe, sakhanchielekhe nchila tisini na tisa, nukhuluta khukyamba, khulonda yiela iyieyaghile? ");
INSERT INTO zgam_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Anghayievone iyiekhayaghila, mwiedhikhaghe, niekhuvavula, niehovokha ukhulutiela khunchila tisini na tisa nchincho sanchiyaghile. ");
INSERT INTO zgam_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Vuyie liewo ewo saphunonghile pavulongholo vetu uvakhukyanya ukhuta undhebe yumo muava ayaghaghe. ");
INSERT INTO zgam_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ulukhololyo anghakhu nanghiele, ulute mukhanchovane muvulane umwe mwivavile mwie vene inchumuyaghine, anghakhuphulikhe wiva weikhiliwile ulukhololwo. ");
INSERT INTO zgam_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Hanghe anghalekhe ukhukhuphulikha pwu untole uyungha umunu nu va viele nuvadaatu ukhuta amamenyu gha ava ghavinchaghe vusaidi pa vuyielweli aghivuliwa. ");
INSERT INTO zgam_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pwu anghabedhe ukhuvaphuhiencha, pwu mukhaghuvule umpelela, pwu aghalemwe ukhughuphuliehiencha umpelela, pwave munu va khuva khulyuve ndumunu untenghe nuo nsongha songho. ");
INSERT INTO zgam_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Mwiedhikhaghe, mikhuvavula, ikyumuphulihana ukhukhiekhungha mukhilungha na khukhu kyanya khiva khiekhunghiwe. ");
INSERT INTO zgam_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Hanghe nikhuvavula ukhuta avanu vavieli mughati ndyumwe vanghiedhiehana mukhilungha khukhinu ikyuvidova, iekhuvapha ikhienu ikyuvidova, uDada vango uvakhukya iekhuvavombela. ");
INSERT INTO zgam_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ulwa khuva avanu vavieli aphanghe vadhatu vanghalundamane pwuphaninie khulitawa lyangho, une pwu niva paghati pavene. ");
INSERT INTO zgam_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Hanghe uPetro akhincha nukhumbula uYesu, “Nkhuludeva, pilondiwa ulukhololyo akhunanghiele khalienghi pwu wiesyiekhile? Ndawisyiekhile mara saba?” ");
INSERT INTO zgam_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","U Yesu akhambula, “Sanikhukhuvula ukhuta mala saba, hanghe unsiekhile saba mala saba. ");
INSERT INTO zgam_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ulwa khuva uludheva ulwa khukyanya lulieanile nuntwa yuomo uvieanogwagha ukhuliehania eimbalilo ukhuhuva khuva vanda vamwene. ");
INSERT INTO zgam_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Watenghwile ukhuliehania eimbalilo ya mwene, umbanda yumo va mwene vakhaghegha khumwene yuywa akhandhayagha, intalanta avaelfu khumi. ");
INSERT INTO zgam_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ulwa khuva alemwagha ukhuta ihomba ndakhiekhi, untwa vamwene akhalaghincha aghunchiwe, undhala va mwene na vavana vamwene na khila khinu eikyalienakyo, nuluhombo puluvombekhe. ");
INSERT INTO zgam_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Umbendha ankaghwa, akhafughama pavulonghole pa mwene, akhanchova, “Nkhuludeva, uvinchaghe vakhu muliekhila pwu paninie nune, niekhukhuhomba khila khinu.' ");
INSERT INTO zgam_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Pwu untwa va mbandha ula, ulwakhuva akholile eikhisa akhandhekha pwu akhansiekhila unkhole ngwa mwene. ");
INSERT INTO zgam_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Khanghe umbanda ula akhahuma hanghe akhambona yumo mu vavanda avanine, yuywa andhayagha unkhole idinali mia moja. Akhankwegha, akhunkhuda khusingho, nukhumbula ukhuta, 'Uhombe unkhole gwanghokhiekyo nikhukhumela.' ");
INSERT INTO zgam_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Hanghe umbandha ula unine akhaghwa nukhundhova ukhulutielila, aliekhuta, “Uve munu vakhumuliekhila, une nikhukhuhomba.' ");
INSERT INTO zgam_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pwu umbanda uviatalile abelile. Pwu akhaluta nukhuntagha mumbunkhungwa, imphakha akhieva ihomba unklole gwa mwene. ");
INSERT INTO zgam_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Vavile vilola avavanda avanine nchila inchivombikhe. Vasaghile eino. Puvakhincha vakhambula untwa vavo khilakhieno iekhievumbikhe. ");
INSERT INTO zgam_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Pwu ule untwa va mbanda ula akhamwilangha, nukhumbula, 'Uve vie mbanda vintulanonghwa, nikhakhusyiekhile unkhole gwangho gwoni ulwa khuva ukhansiemielinche eno. ");
INSERT INTO zgam_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Khekhi! Sukhalondiwagha ukhuta uvienchaghe niekhisa khumbanda nieno, nduvuniekhakhukholile einkhesa uve? ");
INSERT INTO zgam_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Untwa va mwene akhaviepha pwu akhan'ielekha khuvavo vietesya imphakha upwakhiva iehomba unkhole fyoni fifyo akhandhayagha. ");
INSERT INTO zgam_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Vuyayiwa ewo u Dada uvakhukyanya wayikhuvavombela, khila munu yuywa sakhasyiekhile ulukhololwe ukhuhuma munumbula yamwene.” ");
INSERT INTO zgam_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Vu UYesununsiekhe ghula wamaliele amamenyu agho, akhahajha khu Galilaya, akhaluta khumakha incha Vayahudi khumwambo khulughasi ulwa khu Yolodani. ");
INSERT INTO zgam_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Avanu avinghi pwu vakhankhonga, navophe akhavaphonia. ");
INSERT INTO zgam_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Avafalisayo vakhandutila, vakhagheda, vakhambula, “Nda yivo lweli umunu ukhundekha undhala uvamwene khu khila nonghwa? ");
INSERT INTO zgam_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","UYesu ankhavandha akhata, samwimbile unkhuta umwene uvavumbiwe uviatlile, avumbiwe umunu ughosi nu munu undhala? ");
INSERT INTO zgam_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Hanghe akhanchova, khululaghielo ulwa umunu, alandhekha udadaye nu vanina vamwene pwu vivinchagha pwu paninie nuo ndhala, vamwene, vuvavieli pwu vivie nchagha umbieli ghumo. ");
INSERT INTO zgam_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Pwu hanghe savivinchagha vanu vavieli, pwu vivienchagha umbielie ghumo. Uvuavalunghaninche UNguluve, umunu alekhaghe ukhuvalughulula. ");
INSERT INTO zgam_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Vakhambula vakhata, pwu nchiva ndakhikhi UMusa avavuli ukhuta vavaphinchaghe avanu eibalula iyakhulekhehana? ");
INSERT INTO zgam_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Akhavula akhata, “Khunumba ncheinyo inchietu uMusa akhavatavula ukhuvalekha avadhala vienyo ulwakhuva ukhuma khuvutenghulilo vusanchale ewo. ");
INSERT INTO zgam_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Une nikhuwavula umwe, khila munu yuywa akhiva iekhundhekha undhala vamwene khunongwa ieyavulighu, nukhutola undhata uyunghe, aligwiphe, vope uvieikhintola uvialekhiwe iva iendhighu. ");
INSERT INTO zgam_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Avankhonghi vakhambula UYesu vankhata ienava imbombo ncha munu nu ndhala vamwene nchinghave ewo, pusaphilondhiwa ukhutola. ");
INSERT INTO zgam_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ulwakhuva umwene akhavavula, awanu voni saviewesya uliyuophielila eilimenyu eilie; aphanghe khuvala aviwesya. ");
INSERT INTO zgam_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ulwakhuva khuvale uwatowashi vavo vaholiwe ewo ukhuma mumatumbunghavavaninavo. Hanghe khuvale avatowashi avavombiwe ukhuva vatowashi avivikhile ukhuva vatowashi khu nonghwa iyaludeva ulwa khukyanya. ");
INSERT INTO zgam_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Vakhandetela avana avadhebe avavikhile amavokho pamitwe gyavene ukhuta avadhove, avankhongi vamwene vakhavadhukha. ");
INSERT INTO zgam_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Hanghe UYesu akhanchova akhata, mvalekhe avana avadhebe vinchanghe khulyune, mulekhe. Ukhuvabencha, ulwakhu avakhwanine uludedheva ulwakhukyanya lwa veene. ");
INSERT INTO zgam_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","AKhaviekha amavokho ghumwene pakyanya pavene, akhahegha apho. ");
INSERT INTO zgam_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Pwu umunu yuomo akhandhutila akhambula akhata, Imanyise, nievombo eikhinu eikhikhi eikhienuno, pwu niekhave uludheva ulwa khukyanya? ");
INSERT INTO zgam_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Akhambula akhata, khikhi vukhumbuncha inongwa incha vunonu? unonu alieyumo. Hanghe unghanoghwe ukwinghiela khuwumi ulwaakhukyanya, unchinkhonghe iendaghielo. ");
INSERT INTO zgam_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Akahambula, “chiliekhu?” UYesu akhanchova akhata, ienchi, “ulabudhagha, ulalighupagha, ulahienchagha, ulanchova uvudhesi. ");
INSERT INTO zgam_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Uvadwadaghe avadada vakho nayuvanina vakho, hanghe unghane uvaphawiphi phalyuve nduvu wieghanile yuove” ");
INSERT INTO zgam_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Udhiemi uola akhambula, Nchoni ienchi neinchibhiete, khinu khieikhi eikhienghe khiekyo nielinivule? ");
INSERT INTO zgam_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","UYesu akhambula, unghanoghwe ukhuva mwiedhiekhi, ulutaghe ukhaghunche fifyo ulienafyo, ukhavaphe avaghanchu, uve pwu wieva niekhiebana khukyanya, pwu wienche ung'onghe. ");
INSERT INTO zgam_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Udhiemi uola aviele aphulikhe eilimenyulu lila akhahegha pale khuno aviephiele, ulwakhuva ale niekyama khinghi. ");
INSERT INTO zgam_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","UYesu akhavavula avankongi avankhonghi vamwene, mwidhikhaghe, nikhuvavula, khulava khupla akhatayieli ukhwinghile khuludheva ulwa khukyanya. ");
INSERT INTO zgam_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Hanghe nikhuvavula nita piva padhekhe dhekhe ukhulutieliela einghamiela ukhughenda pandyangho ugwa sindhano. Nduo untayieli ukwienghida khuludheva ulwa khwa Nghuluve.” ");
INSERT INTO zgam_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Avankhonghi vamwene vuviephuliekha, valiekhudhegha eino, valikhunchova, vievrni hanghe yuywa iephona? ");
INSERT INTO zgam_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","UYesu akhavalola akhanchova, khuvanu eilyo calienkhonghiwa, khwa Nghuluve nchoni nchivombekha. ");
INSERT INTO zgam_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pwu uPeteli akhandha, akhambula, “Lola ufwe tufu toufilekhe fyoni tukhunkhonghile uve. Pwutwikhava khikhi khumbe? ");
INSERT INTO zgam_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","UYesu akhavavula akhata, mwiedhikhe, nikhuvavula ukhuta umwe yumwe mung'onghile uone, mukhilungha eikhiegheni, upwalava ietama u Mwana va Adamu pha khighoda eikyanitwa utwa mwene, nujyumwe pwu mulantama pafighoda kheinchigho niefiviele, pwumuhieghagha ifikholo khienchigho niefiviele ifya Islaeli. ");
INSERT INTO zgam_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Khila munu uvyayielekhile einyumba, apanghe ulukhololwe udhiemi, aphanghe udhala, aphanghe udadaye, aphanghe uvanina, aphanghe avana, aphanghe iefyalo, khulitawa eilyangho, pwu iekwupielagha mala miamoja, nukhunchitama khuwumi vuwa savulasila lusikhu. ");
INSERT INTO zgam_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Humbe, avingi vavo vakhatalie vivienchagha vakhuvumalilo, hanghe vavo vakhale khuvumalielo pwuo vivinchagha khuvutenghulilo. ");
INSERT INTO zgam_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ulwakhuva utudheva ulwakhukyanya luhwanine nu munu yuywa vienienyumba yuwa alaviele phavusi vuwikya, ukhuta khukhodova aviliema avahieliekhe khukyalo kyamwene ikya sabibu. ");
INSERT INTO zgam_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Umwene wamalile ukhunchova naviliema ukhuta iekhuvahomba eilinchova limo edinali pwu akhavahieliekha khukyalo iekyamwene eikya sabibu. ");
INSERT INTO zgam_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pwu akhahuva gwale unsiekhi ugwa saa tatu, akhavavona avanghe viemili palighunchi vavo valievuvule eimbombo. ");
INSERT INTO zgam_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Vophe avo akhavavula akhata mulutaghe khukyab ghangho eikya sabibu eikhilondiwa eikyalweli ukhuvaphanie khuvapha vakhaluta. ");
INSERT INTO zgam_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Akhahuma khanghe unsiekhi ugwa saa sita kenda, akhavomba vulevule. ");
INSERT INTO zgam_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hanghe mwuo saa khumi na moja akhahuma, akhavavona avanghe viemile, akhavavula, khikhi mwiemile apha eimusi yoni samuvombile eimbombo. ");
INSERT INTO zgam_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Vakhambula vakhata, asikhuli umunu yuywa atughongholiele khukhombombela, akhavula akhata mulutaghe nayumwe khu kyalo kyangho eikya sabibu. ");
INSERT INTO zgam_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Wavile wielile umbaha uvialolelagha pakyalo akhambula undoleli vamwene. Uvielanghe avielema uvaphe uluhombo lwavo, ukhutenghula uvakhalile ukhudhugha uvvakhatengwiele. ");
INSERT INTO zgam_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Vavile vienchie avasaa khumi na moja vakhavava uluhombo. ");
INSERT INTO zgam_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Vula avataliele valumanyile ukhuta viekhava uluhombo ululutieliele, na vophe vakhuphiliela uluhombo lulwa lulihaninile navakhancheliwe. ");
INSERT INTO zgam_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Vuvaphokhili puvakhasagha vakhaviepha vakhambiephiela unyanyumba. ");
INSERT INTO zgam_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Pwu valiekhunchova valikhuta, avinchilekhuvumalilo vavombile eimbombo iesaa yeimo vuvule, nuve uvahombile tulihaniele nufwe twieyumielinche nukhughatala nulunchuva ulukhali ulwaphamusi yoni. ");
INSERT INTO zgam_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Vophe akhamwamula yuomo akhambula akhata, imanyani, saniekhukhosyova, ataukhidhiehane nune ukhukhuhomba ulutatama? ");
INSERT INTO zgam_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Utole uluhombo lwakho ughodhokhaghe. Nienoghwa ukhumpha uyou uvakhuvusilielo mutiehane nuve. ");
INSERT INTO zgam_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Saluononu khulwune ukhuvombela fifwo nielenafwo mumbwieghane wangho? Aphanghe eiliho lyakho lieviele livivi ulwakhuva une ukhuva ienonu? ");
INSERT INTO zgam_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Vulevule avakhuvumalielo valatata, navavo vataliele valalava vakhuvumalielo. ");
INSERT INTO zgam_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","UYesu uwitogha ukhuluta khuu Yelusalemu, avatolile avankhonghe vamwene khienchigho na vavieli ukhula khuvutietu munjiela akhavavula. ");
INSERT INTO zgam_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Mulolaghe twietogha twieluta khu Yelusalemu, nu Mwana viva Adamu ienchiviekhiwa mumavokho ghu vavaha avalumbielieli na muvakhatani, avene uyuvikhung'iegha akhuta afwe. ");
INSERT INTO zgam_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Pwu yuviekhung'umia ukhumbiekha khuvana avanyaphanchi ukhuta vankieniele, ukhunhova nukhu ntensya. Hanghe eilinchuva eilyadhatu alanchuka. ");
INSERT INTO zgam_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Akhincha uvanina vavana ava Zebedayo, pwu akhaluta khwa Yesu navana va mwene, akhansana, nukhundhova eikhienu ukhuma khumwene. ");
INSERT INTO zgam_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Akhambula, wie nohwa khikhi? Akhambula, uchove utamule, avana vangho ava, vaieli vatame yuomo iekhievokho eikhwakho eikyakhundyuo. Uyunghe eikhivokho eikya ng'eighe, khuludheva lwakho. ");
INSERT INTO zgam_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","UYesu akhandha akhata, Samukhiemanyile eikyumudhova. Ndamukhawesye ukhunywela eikhikhombe khikyo ninywela uone? Vakhambula vakhata, “Tuwesya”. ");
INSERT INTO zgam_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Pwu akhwavula, “Lweli akhikhombe kyango uyumunywela, ukhuta ukhutama khulyune khukhievokho eikyando nie khievokho eikyang'enghi une nillienivule uvulamuli wangho uwakhuvapha, valakhava vala vavo UDada vangho avaviekhiela uvutamo uwakhutama. ");
INSERT INTO zgam_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Avankhonghi vala khienchigho vuvaphuliekhe eiwo vakhaviepha eino khuvalukhololwava vala vaveili. ");
INSERT INTO zgam_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","UYesu akhaviekingha avene akhanchovba muluomanyile ukhuta avalonghonchi avanyamphanchi viekhuvalonghoncha khumakha, na vavaha vavo vikhuvaphuliehincha nukhuvavombencha umwe! ");
INSERT INTO zgam_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pwu sanchikhave ewo khulyumwe, ulwakhuva umunu uvieinoghwa ukhuva iembaha khulyumwe, avienchaghe iembombi veinyo. ");
INSERT INTO zgam_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nu munu uvieinoghwa ukhutala atenghule khulyume pwu ave iembombi ienonu. ");
INSERT INTO zgam_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nduvu umunu una Adamu saienchekhuvombeliewa, ainchile khuvomba, nukwiehumya uwumi uwamwene ukhuva neekhelo iya vanu avienghi. ");
INSERT INTO zgam_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Wou iehegha khu Yeliko awanu avienghi vakhankhongha. ");
INSERT INTO zgam_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Pwu avanu vavieli vavo vabhoofwile amiho vatakhatama palunkhanji panchiela, vaviele viephulekha ukhuta UYesu ieghendha ielutaniencha phala, pwu avene valiekhukhola nukweilangha khumakha valikhuta, ututanghe, lentwa, viemwana va Davudi! ");
INSERT INTO zgam_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Avanu pwu valiekhuyadhukha, valiiekhuta vanchinghe mie vielekhelwe ukhunchova. Avene pwu valiekhuphie kwilangha, hutanghe, lentwa, mwana va davudi! ");
INSERT INTO zgam_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","UYesu akhema, akhavielagha, akhanchova, mwinoghwa nievavombele khinukhiekhi? ");
INSERT INTO zgam_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Vakhata, lentwa, twinoghwa amiho gyeio ghadiendunkhe ghalolaghe. ");
INSERT INTO zgam_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","UYesu akhavakholela eihisa, akhavakhotela amiho ghavene, usisiekhi ghughwa vakhatengule ukhulola, vakhankongha. ");
INSERT INTO zgam_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","UYeisu navakongi vamwene vakhava vahengelile ukhufikha khu Yelusalemu. Puvakhaluta na khu Betifage pakhyamba eikhyamba ikhya mono. Puleino UYeisu akhavasuha avakongi vaveilei. ");
INSERT INTO zgam_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Akhavavula, “Akhala mlulanghe pa vunchenge uvuvukonga, puvuminfikhe mukhweivona eilinghodowe leiokungiwe pala nei khyana khya linghodowe khinkungiwe paninie pumuvopole munchinghenghe khulyune. ");
INSERT INTO zgam_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Eingave umunu uveiavena angha ikhuvavula khininie. Ukhukongana neilyunevasuhile mutenhange unkuludeva aleinuvutumbwe nancho pu umunu uywa ikhuvalekha mwinchanghe na manghodowe angho.” ");
INSERT INTO zgam_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Eili iyahumile nduvulya nchove'we nu nyamalangho puleino livombekha nduvulya nchoviwe. ");
INSERT INTO zgam_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Mumbule ungh'ei ncha ava Musayuni, lola, khulyuve. Idekhedekhe itonghile palinghodowe neikhya na khyalinghodowe ikhinghosi. ");
INSERT INTO zgam_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Puleino avakongi vaakhahengha nukhuvomba nduvu UYeisu avavulile. ");
INSERT INTO zgam_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Puvakhanchileta eilinghodowe nei khyana khya linghodowe puvakhatandancha imyenmda ngyavo palinghodowe na pakhyana khya linghodowe, pu UYeisu akhatama palinghodowe. ");
INSERT INTO zgam_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Avanu vingi pakhipungha khila vakhatandancha eimyenda nghyavo munheila avange avaleikhunghida isamba puvaleikhutandancha amaswato ngha samba musevo. ");
INSERT INTO zgam_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ikhipungha ikhikhyandongwile UYeisu na vala avava kongangha valekhyova eilimenyu valeikhuta: Hosyana mwana va Daviti anghinivwanghwe na uvei ikhwincha munditavwa lya Nkuludeva. Hosyana na khukyanya. ");
INSERT INTO zgam_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","UYeisu vwafikhe uvunche nge vwoni vukhakenyemukha nukhuta uyu veiveni. ");
INSERT INTO zgam_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ikhipungha khikhamula khikhata; “Uyu vei Yeisu uva mu Nazareti eiya khu Nghalilai. ");
INSERT INTO zgam_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Pu UYeisu akhingheila mulembile ya Nguluve pu akhava veingheila khunchi vooni avanghulangha mkhunghuncha mtembile. Heunge akhabeileivanchula ifisalati fya vala avaleikwanania indalamanifinghoda fya vanghuncha nghundya. ");
INSERT INTO zgam_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Akhavavula akhata, “Yeisimbiwe ukhata, “Inyumba yango yiva nyumba ya lwisayo, 'Pu leino umwe mpelile ukhuta yive manga ya vanyambuda.” ");
INSERT INTO zgam_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Pu leino avabofu va miiho na valemale puvakhahenghelela khumwene vwalei mu tembile, pu akhavuponia uvumpala vwavo. ");
INSERT INTO zgam_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pu leino avavaha vavatekhe nchi na vamanyi vakalata vavile vafiwene ifidengho ifyu avombile, pu vavile vapulikhe pu leino avana valekhuvata, “Hosyana vi mwana va Daviti,”Pu avene nghukhavipa fincho. ");
INSERT INTO zgam_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Puvakhambula u Yeisu vakhata, “Vupuleikha eikhyuvinchova avana ava?”U Yeisu akhata, “Eena! Samweimbile mukalata upupita, 'Khumilomo einghya vana avanyehe navavo vikhyoha ukhuta umalile ulunghinwo?” ");
INSERT INTO zgam_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pu akhavalekha akhahengha pavunchenge vula nukhuluta khu Betaniya khuakhanchinghona. ");
INSERT INTO zgam_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pavusikhu avile ivuya ukhu khuvunchenge akhava, aleineinjala. ");
INSERT INTO zgam_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Pu akhanghuvuna unkuyu nghumo palukanji panjeila. Puakhahenghelela, pusakhivone khinu pabeikhi nghula anghawe amaani nghene. Pu akhanghukotola akhata, “Ukhuhumangha leino sahula hupa isekhe isikhu nchooni.” Pu unkuyu nghula nghukhaniala palapala. ");
INSERT INTO zgam_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Avakongi vavile valolile, eikhidengho eikhi vadenghile nukhuta, “Pu yeivile ndakheikhi unkuyu nghunialile akhaseikhi ndakha?” ");
INSERT INTO zgam_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Pu u Yeisu akhamula akhata, “Ncha yeilwei nukhuvavula, mungave mwiva nulweideikho samusinana, samukhavomba nghe ikhivombikhe khubeikhi unghwa vuvule, pu leino muvambangha ifideingho nifinghe pu leino mukhukhivulangha nakhikhyamba eikhyo ukhuta khitoliwanghwe, 'nukhunchutangha munyanja pu yivombekhangha ewo. ");
INSERT INTO zgam_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Pu nghala unghinyakhiva mudova ndweisayo nulweideikho, pumukavangha.” ");
INSERT INTO zgam_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","U Yeisu avile afikhe muntembile, avavaha va vate khenchi navamanyi vakalata vakhahenghelela khumwene avile aleipa khumanyisya, “Puvakhambuncha vakhata, “Vuvomba inchi nchooni vuvombela mumakha makhi?” ");
INSERT INTO zgam_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Pu U Yeisu akhavamula akhata, “Na yune nikhuvavu ncha eilimenyu leino. Leilyo munganyamule, punikhuvavula ni vomba inchi mundulanghilo lwani. ");
INSERT INTO zgam_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ulyoncho lwa Yohana - lwa humile khwani, khunyanya khuvanu?” Vakheinchofanja vavo vakhata, tunghate lwa humile khunkyanya puyaikhutu vula ukhuta pukheikhi samwamwedeikhe? ");
INSERT INTO zgam_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pu leino tungate, 'lwahumile khuvanu,' Putudwada avanu ava pakhuva vooni vikhumbona u Yohana ndu munu unyamalangho. ");
INSERT INTO zgam_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Pu leino vakhamwamula u Yeiau vakhata, “Satulumanyile” Pu akhavavula khange akhata puna yune sanikhuvavula nivomba angha mundu langhilo lwani. ");
INSERT INTO zgam_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Leino pu musangha kheikhi? Umunu unyavana va veilei. Akhaluta khumwana wamweneumo akhata, 'Manango, luta khuvomba imbombo mukhyalo eikhya masilu Akhamula akhata. ");
INSERT INTO zgam_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Niluta Ntwa pusakhaluta. ");
INSERT INTO zgam_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Pu akhaluta khuswambe uvaveilei akhambula vuvuvwa, vupe akhata ndeili saniluta, pungela akhasangha munumbula utima nghukhambava akhadova ulusyeikhilo pu akhaluta khukhyalo. ");
INSERT INTO zgam_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Pu leino muvana avo vaveilei aleikhu uviavombile uvunonghwe vwa vise? Vakhata ula uvaveilei, “Pu u Yeisu akhavavula akhata ncha yeilweli lweli nikhuvavula, avasanghunchi va songo navalinghu valavalongola pavulongolo pa lyumwe ukhwingila mundudeva lwa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ulwakhuva u Yohana ainchile khulwumwe khunjeila ingolofu, pu leino umwe samwa mweideikhe, pu avasanghunchi va sango na valinghu vakhamwedeikha. Pu umwe, na pala upu mwavavonanga samulaikha deikhe. ");
INSERT INTO zgam_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Mupuleiheinche eikhihwani eikheinge. Kwale nu munu, umunu unyalilevunchi lya kheilunga. Avyalile amasilu pu akhaveinghileila nuluveingho, puakhanchengha neikhivo eikhya khukameila amasilu, pukhayava nulukonje lwakhungulolela akhanchenga pu akha vaveikha na vanu avakhulolela akhahengha ukhulula eikhilunga eikhya pavulale. ");
INSERT INTO zgam_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Useikhi ngwa vubeni vwa masilu vunghuhenghelile akhavasuha avavombi vadebe khuvavombi va masilu vakalole amasilu ngha mwene. ");
INSERT INTO zgam_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pu leino avavombi va masilu nukhyalo vakhavibala avavombi vamwene uvu avasuhile, vakhatova yumo, uyunge vakhatova na manghanga. ");
INSERT INTO zgam_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Pa seikhi unghunge unyakhyuma akhavasuha avavombi avange vuvingi ukhululeileila vala avakhatalile, pu leino avavombi va mukhyalo khya masilu vakhavatova vuvuvwa nduvuvakhatovile khuvala avakhatalile. ");
INSERT INTO zgam_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pu ukhuma pala unkuludeva ula akhasuha khanger khuvene uswambe akhata, “Vinchikhudwada uswambango.” ");
INSERT INTO zgam_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pu avavombi va masilu vala vavile va mbwene undume ula, vakhavulana, “Uyu veimwene vuhale pu leino tu bude, pu uvuhale vwa mwene tuhale ufwe.” ");
INSERT INTO zgam_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Puleino vakhatola vakhatangha khunji khukhyalo khya masilu vakhabuda. ");
INSERT INTO zgam_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Leino unyakhyalo khya masilu yakhiva eikhwincha, ayikhuvanghaha ndakheikhi avavombi va khyalo khya masilu?” ");
INSERT INTO zgam_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Vakhambula vakhata, “Avanu avavivi ava sakhavakolele eikhisa, avanu vavo yavi hombangha ukhukongana na masilu unghuvikavana yakhiva nghadulwikhe.” ");
INSERT INTO zgam_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","U Yeisu akhavavula, “Samweimbile mumbusimbe,” eiliwe eilyu vakhaleibelile avanchenga va nyumba livile liwe lyakhwikanga ncha mu eilyo. Eilei leihumile khwa nkuludeva, pukheiswingho pa miiho geito?” ");
INSERT INTO zgam_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Leino nikhuvavula, Uludeva lwa Nguluve luhengha ngha ukhuhuma khulwumwe nukhuvapa avanu vakhilunga eikhikhunchilolela iseikhe ncha nyakhyalo. ");
INSERT INTO zgam_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Pu ula uveiyakhiva inghwa pa liwe elyo vei uyu itikhinyuliwanghwa vuvule. Pu leino khu ula uviyokhiva likhunghwila pulikhutikhinyula.” ");
INSERT INTO zgam_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Avavaha vavatekhenchi na va Falisai vavile vapulikhe ifihwani fya mwene, vakheivona ukhuta ikhuvanchova avene. ");
INSERT INTO zgam_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Pu leinu khila seikhi vupava leikhunonghwa ukhuta vamwibate vakhudwada ifipungha fya vanu, ulwakhuva avanu vambonangha u Yeisu ndu munu unyamalangho. ");
INSERT INTO zgam_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","UYeisu pu akhamula hange akhanchova nufihwani hata, “ ");
INSERT INTO zgam_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Uludeva lwa khukyanya luhwanine ndunkuludeva uviatelikhe ifinu vutenghulani vwa munu viatolangha udala. ");
INSERT INTO zgam_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pu akhavasuha avavombi vamwene vakhaveilanghe aveilangiwa ukhwincha khwilya eikhyakhulya ekhitelekhiwe eikhyavutenghulani pu avanu voni vakhabela. ");
INSERT INTO zgam_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Unkuludeva pwakhasuha khange avavombi avange, akhavavula. Akhata “Mukhavavule voni aveilwangwa, mulole, pumeitesaminche ifinufya vutolani. Isenga nchangho ni finge ifinu ifinonile, fiheinjiwe pu fyoni neimalile ukhufitesania pu mwinchanghe khuvutengulani tuhovokhe paninie.” ");
INSERT INTO zgam_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pu leino aveilangwa avo savaleikhuyi sangeila einyielango pu valeikhwiluteila nu yunge ukhwa sanghie, umo aluteile khukhyalo khwileima uyunge akhuluta khukhedengha. ");
INSERT INTO zgam_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Avange avuvasinghile puvakhavasambukhila avavombi avasuhiwe vakhavabuda. Pu leino unkuludeva ula akalile fincho. ");
INSERT INTO zgam_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Pu akhasuha eikhipungha khya mwene, eikhya valwa linghoha ukhuluta khukhuvabuda vala voni avabudi vavavombi va mwene nukhuyanja uvunjenge vwavo nu mwoto. ");
INSERT INTO zgam_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Puleino akhavavula avavombi vamwene akhata, “Uluhekhelo lwakhulya ifyavute, ngulani lufikhe aveilangwa savanonghile. ");
INSERT INTO zgam_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Pu leino mulutanghe na munjeila malekhano eincha misevo voni uvuya khiva mukhuvavona muveilangenghe vinchange khuhekhela uvutengulani.” ");
INSERT INTO zgam_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Avombi vala puvakhaluta pa njeila eimbaha vakhaveilanghe voni avavikhuvavona avangholofu na vavivi. Uluhekhe khela lwa vutenghulani pulukhadengha avanu vuvingi avanghenji. ");
INSERT INTO zgam_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Pu leino avile eingile unkuludeva ula khwilola avanghenji, vamwene pwakha vuna munyumba ya vulenghulani eiyaluhekhelo mwale umo uveisafwalile eimienda einghya luhekhelo lwa vutenghulani! ");
INSERT INTO zgam_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Pu Unkuludeva akhambuncha akhata, 'Imanyani, vangho vwingile ndakheikhi umu nuve nsufwalile eimienda nghya vutenghulani?' Pu umunu uywa sanchove khinu akhava eikelile ukhuva pala pavutenghulani. ");
INSERT INTO zgam_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Pu unkuludeva akhavavula avavombi vamwene akhata, '“Munkunge umunu uyu amavokho nanghamalunde pu mutanghe khunji khuhisi pu ukhwa khukhwiva nulukuto nulunghaduncho lwa mino. ");
INSERT INTO zgam_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ulwakhuva aveilangiwa veingi avahalwa vadebe.” ");
INSERT INTO zgam_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pu ava Falisai vakhahengha vakhuluta nukhisavania umuyakhiva vikhumwibateila u Yeisu mumanyu ngha mwene. ");
INSERT INTO zgam_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Pu ava Falisai vakhasuha avakongi vavo navanya Heloti. Pukhanchita khwa Yeisu, “Manyisi, tulumanyile ukhuta uve ulei munu vayeilwei, nukhuta vumanyesya uvunonghwe vwa Nguluve vumanyeisya mumbwayeilweli. Hange savudwada uvuvaha vwa munu uvei avenchangha pakhuva savwilola khumiho umunu umwa velile. ");
INSERT INTO zgam_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Pu leinou Yeisu utuvule vwa vona ndhakeikhi? Panonghile, unkusanguncha nukhusongha eisongho khwa kesali pamo mwikho?” ");
INSERT INTO zgam_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pu leino u Yeisu avumanyile uvvivi vwavo pu akhata, “Kheikhi munkhungela mweivangalukhi umwe? ");
INSERT INTO zgam_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mume eindalama ya songo neilole puvakhapa eidinali. ");
INSERT INTO zgam_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","U Yeisu akhavavuncha, “Khiwani khyani eikhi?” ");
INSERT INTO zgam_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Pu vakhamula vakhata, “Khihwani Khya Kesali.”Pu humbe muhombenge khwa kesali ifyavukesali vwa mwene nei fya Nguluve mupe UNguluve.” ");
INSERT INTO zgam_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Vavile vapolikhe ewo vadenghile fincho puvakhandekha vakhanja ukhuluta. ");
INSERT INTO zgam_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Pu eikhinghono eikhyo vakhinchaava Sadukai khwa Yeisu, avanu avavita vusikhuli uvunchikha, pu avavakhambuncha, ");
INSERT INTO zgam_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Vakhata, “Manyisi, u Mose atile, umunu angafwe khita hola mwana ulukololwe ahalanghe udala ufwile pu angh'olele ulukololwe umwana. ");
INSERT INTO zgam_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pu khulyufwe kwale navana munu lekhela khumo. utanchi atolile udala pwakhafwa khitahola umwana. Pu akhandekhela ulukololwe udala. ");
INSERT INTO zgam_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pu yeikhava vuvuvwa nayulukololwe uva veilei vope na yuvadatu, pu voni saba yeikha vulevule savahole mwana. ");
INSERT INTO zgam_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pu leino udala vope nghukhafikha useikhi nghwa khufwa akhafwa. ");
INSERT INTO zgam_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Pu leino khuvandukha valava vanchukhile voni pwa lava idala vani? Pakhuva voni lekhela khumo vale nave.” ");
INSERT INTO zgam_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Pu u Yeisu akhavamula akhata mwiyangha, “Mwiyangha pakhuva sambumanyile uvusimbe na nghamakha ngha Nguluve. ");
INSERT INTO zgam_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pu u Yeisu akhavavula akhata, khuvunchukha khusikhuli ukhutila khuve khuvu kha pu leino viva ndavasuhwa va Nguluve khukyanya. ");
INSERT INTO zgam_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Hange pakhulongu ya vunhukha, samwembile eilimenyu eilinchoviwe nu Nguluve eiliita, Une neilei ");
INSERT INTO zgam_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nguluve va Abrahamu, neilei Nguluve va Isikakha, neileiNguluve va Yakobo? U Nguluve sa Nguluve vavafwile pu Nguluve vavumi.” ");
INSERT INTO zgam_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pu ululundamano vavile vapulikhe ewo vadenghile fincho. ");
INSERT INTO zgam_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pu ava Farisai vavile vapulekhe ukhuta ava Sadukai, vavemilwe puvakhalundamana ava Farisai, vakhinchofanja. ");
INSERT INTO zgam_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Pu umo, mwene umanyi va ndanghilo pu akhavunja elimenyu pakhunghela. ");
INSERT INTO zgam_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Pu akhata imanyisi, lyululanghilo luleikhu uluvaha ukhuluteila khunchinge mundangheilo?” ");
INSERT INTO zgam_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","U Yeisu pwakhamula akhata, “Ungananghe u Nguluve vakho nei numbula yakho yoni, na nghutima nghwakho nghyoni, na masagho ngha luhala lwakho lwoni. ");
INSERT INTO zgam_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ulu lyululanghilo uluvaha hange lulei mbulongolo. ");
INSERT INTO zgam_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ulwa veilei luhwanine nulwa lyope lyu ulu - Unghananghe unino nduvu vwi nghanile yuve. ");
INSERT INTO zgam_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Eindanghilo nchoni eincha va nyamalangho muncheilotikhe mundangeilo eveilei inchi.” ");
INSERT INTO zgam_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pu ava Farisai vavalundamine pupaninie, U Yeisu akhavavuncha eilimenyu. Akhata, ");
INSERT INTO zgam_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Pu!, musongha ndakheikhi ukhukongana nu keileisite? U mwene nswambe vani?” Pu avene vakhamula vakhata, “Nswambe va Daveite.” ");
INSERT INTO zgam_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Pu ndakheikhi, “U Daveite einchovela mwamepo ukhuta, 'U Nkuludeva ambulile u Nkuludeva vango,' ");
INSERT INTO zgam_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Akhata tama khukhivokho khyango eikhya khundyo, punikhuvaveikhangha avatavangwa vakho pasi pa malunde nghakho.'”?” ");
INSERT INTO zgam_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Pu leino eingave u Daveite inchova ita veinkuludeva va mwene, “Pu ivenchangha nswambe va mwene?” ");
INSERT INTO zgam_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Pu sa nghele umunu nayumo ukhwamula limenyu, hange ukhuhumangha eikhinghono khila sanghele munu ukhuvuncha limenyu. ");
INSERT INTO zgam_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pu leino u Yeisu akhavavula eikhipungha khya vanu na vakongi akhata, ");
INSERT INTO zgam_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Pu avamanyi va kalata nava Farisai puvatamile eikhinghoda khya Mose. ");
INSERT INTO zgam_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Pu nchoni inchuvikhuvavula muvombange nukhukonga, punchila inchuvivomba avene mulekhe ukhunchikonga pakhuva avene einchuvi nchova nchu savivomba. ");
INSERT INTO zgam_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Avene, puvinkunga eiminchingho eiminehitu khuvanu einghidenya, puvikhuvatweikha avanu mumave ngha, na hali avene savinghela na padebe ukhunghipeimba. ");
INSERT INTO zgam_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Imbombo nchovo nchoni vivuvomba ukhuta veivonie khuvanu, pu nnghama sandukha nghavo melefu, navuvudeikha vwa fihunilwa fyalo khumalunde vutale fincho. ");
INSERT INTO zgam_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Pu avene valeineikhihelehele munyumba ncha khisayila vilonda ukhutama mbutamo uvwa mufinghoda ifya vuvaha, ");
INSERT INTO zgam_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pu vanave musokhoni puvilonda ukhuta avanu vavapembenchanghe pu vinongwa ukhuta, veilangiwanghwe “Vamanyisi”khuvanu. ");
INSERT INTO zgam_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pu leino umwe samnonghile ukhwilangwa“Vamanyisi,”Pakhuva u Manyisi veinyo alei umo, numwe muleivana munu. ");
INSERT INTO zgam_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pu mwekhe ukhumwimeikha umunu nukhuta Daada pakhilunga, apa ulwakhuva u Dadayeito alei umo, avakhukyanya. ");
INSERT INTO zgam_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Hange mulekhe ukhwilangiwa 'Vamanyisi, 'Pakhuva muleinumanyisi umo vope, vei keileisite. ");
INSERT INTO zgam_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Pu leino umbaha mundwamwe veiva mbombi veinyo uvakhuvavombela. ");
INSERT INTO zgam_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Pu leino uveikheiyeimikha veiikhwisiwanghwa. Nuveiikheiyisya vei ikhweimekhiwanghwa. ");
INSERT INTO zgam_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Pu lweinyo umwe mweiva Farisai, a mweivamanya kalata! Muleivangalufu mukhuvandeindeila avanu umwumi vwa vwa ludeva lwa khukyanya, pu na yumwe samukhwinghila hange avilonda ukhwinghila samukhuvalavuleila veingheilanghe. ");
INSERT INTO zgam_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(Lweinyo mweivanyakalata na Farisai mwevanghalufu, pakhuva mwilya khuva fweile, nukhwisaya einyeisayo inali puleino puyamuheinghiwangwa uvuheinghi uvuvucha ukhuluteila”). ");
INSERT INTO zgam_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Lweinyo umwe mweivanya vakalala na mwei va Farisai, mweivanghalufu! Mlovukha inyanja mweiluta khumwambo nukhupeila umunu umo akave avupo khi nukhuva mwosivwa, puyakhiva eideikhe pu mukhupela ave vakhuheingeiwa mumwoto unghwa sikhu nchoni. ");
INSERT INTO zgam_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Lweinyo mweivalonghonchi mweimu bofwile, umwe mweimwita, Umunu uveikheijyinghila mwatepeli sakhinangikhe khinu. ");
INSERT INTO zgam_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Pu leino umunu uveijyeinghila mulutalama lwa tembile, uywa einkungile nu khwijyeingha kwa mwene. Umwe mweimubofwile hange muleivakonyofu, kheileikhu eikhivaha ulutalama ewo eitembile eiyivalancha ulutalama? ");
INSERT INTO zgam_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Hange, umunu uveikhijyeinghila panekhelo sa khinangheikha khinu. Pu ula uveikhejyeinghila pafinu ufiveikhivwe pa neikhelolei sadakha uywa veinkungile mwene. ");
INSERT INTO zgam_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Umwe mwei bofwile, khileikhu khivaha eisadakha eiyapanekhelo, ewo einekhelo yeila eiyivalancha eisadakha? ");
INSERT INTO zgam_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pu leino, ula uveikhijyeinghila panekhelo, eikhijyeinghila pa eiyo hange na khufila ifilipakyanya pa nekhelo. ");
INSERT INTO zgam_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Pu na yu ula uveijyeinghila mutembile, eijyeinghila mweiyo na khwa ula uveitama munghati muyene. ");
INSERT INTO zgam_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ula uveijyeinghila khukyanya, ejyeingeila mukhinghoda eikhinyalwangula eikhya Nguluve na khyula uveiitama pa kyanya pakhiene. ");
INSERT INTO zgam_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Lweinyo, mweiva manyi vakalata na mweiva Farisai, mweivangalufu! Pakhuva muhomba ifya ndevulu, nifyambilipili ni fya nbwingha napa nungu puleino munchilekhile eindangeilo eimbaha eincha ungendo ulunonu - neikhisa, nulweideikho, angho ngumunonghile ukhunghavomba pu nanghala anganghe mlukhe ukhunghalekha. ");
INSERT INTO zgam_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mweivalongonchi mweimubofwile, umwe muhuncha eimbwele pu mwimila eingameila! ");
INSERT INTO zgam_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Lweinyo, mweivanyi vakalata na mwei va Farisai, mweivanghalufu! Ulwakhuva mwisukha nukhuvalancha khunji, eikhinywelo vu munghati fimonghalile, pufidenghile uvusyovi uvwakhupokha ifyuma fya vanghe. ");
INSERT INTO zgam_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Umwe mweiva Farisai mweimubofwile, muvalanchanghe tasi munghati mukhinywelo na mundelema, pu nakhukhunji khwope khuvenchanghe khuvalile. ");
INSERT INTO zgam_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Lweinyo umwe, mweivamanyi vakalata na mweiva Farisai, mweivanghalafu! ulwakhuva muhwanine nuvunghuli uvuvaniasinche vononu khunji puvuvonekha vunonu munghati nghadeinghile manchenghe nghene nu vuvili. ");
INSERT INTO zgam_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Pu vuvuvwa, na yumwe khunji muvonekha muleivangolofu pamiho ngha vanu, pu leino munghati mudeinghile uvunghalufu nuvutula nongwa. ");
INSERT INTO zgam_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Lweinyo umwe, mweivanya kalata na mweiva Farisai, mweivangalufu! Pakhuva munjengela uvunghuli vwa vanyamalangho nukhunoncha uvunghuli vwa vangholofu. ");
INSERT INTO zgam_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Pu mwita, tunghale tuvenhange khyutule ifinghono fya vankhukhu yeito satwale tuve paninie pakhududa unkisa ngwavanyamalangho. ");
INSERT INTO zgam_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pumu leino mukhinchova yumwe ukhuta muleivana vavanu vavo vabudangha khuvanyamalangho. ");
INSERT INTO zgam_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Pu leino umwe mudeinche eikhingelelo khya va vise veinyo. ");
INSERT INTO zgam_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Umwe mwe nyandalwe mweikhivumbukhu khya nyato umwe pumwipona ndakheikhi khumwoto nghwa sukhunchoni? ");
INSERT INTO zgam_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Puleino, mulole, nikhuvasuha khulyumwe avanyamalangho avalei nuluhala navasimbi. Pu avange muovo umwe pumukhava budangha nukhuvatovelela pa khidameileihanie. Puavange mulavatovangha mutumbile ncheinyo nukhuvusweima punchenghe nuvunchenghe. ");
INSERT INTO zgam_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Puleino palyumwe ngulavahumeila unkisa nghwoni ungwavangholofu unghwa Hebeli nughwa sakhaliya unya velekiya uvaimwabudeile panghati pavungholofu napanekhelo. ");
INSERT INTO zgam_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Pu leino, nchayeilweli, einchi nchoni nchiva neikhivumbukhu eikhi. ");
INSERT INTO zgam_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yerusalemu, Yerusalemu, uve weivwibuda avanyamalangho nukhuvatova namangangavala avansuhiwe khulyuve, khaleingi neinonghilwe ukhuvalundamania pupaninia avana vakho nduvu eihukhu yeilundania paupa ninie ifinkukhu fy ayene mumapapateilo ngha yene, pu umwe samuleikhunonghwa. ");
INSERT INTO zgam_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Lola, einyumba yeinyo yeivile meenakhivula munu unynsinghile. ");
INSERT INTO zgam_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Pu leino nikhuvavula, samulambone khange ukhuhumangha leino nukhufikha upuya khiva mwita mwaleimi asayiwe uveikhwinchila munchitawa lya Ntwa.'” ");
INSERT INTO zgam_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Pu u Yeisu akhahuma mutembile akhanja ukhuluta. Pu avakongi vamwene puvakhanduleila vakhambonesya einyumba ya Tembile. ");
INSERT INTO zgam_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Pu leino akhavamula akhata, “Samunchi wene einchinchoni? Lweli nikhuvavula, ukhuta leisipali eilinganga eileiyakhiva lesinghala paleinge khisita khumamuliwa.” ");
INSERT INTO zgam_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Vu eiyeisu avie Anchitamile pakhyamba eikhyamono, pu avakongi vamwene vakha, “Vakhahenghelela, upwa leipwo puvakhambuncha vakhata, “Utuvule pu einchi yanchivombeikhangha ndeili? Pu khimanyeilo kheikhi ekhyakhu manyeilamwo ukhuta vuvusileilo vwakhilungha?” ");
INSERT INTO zgam_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","U Yeisu akhavamula akhata, “Mulolanghe nukhuva miho umunu alavasyovangha. ");
INSERT INTO zgam_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ulwakhuva avingi puvikhwinchangha munditawa lyangho vitenchangha. Une, 'Nene keileisite, 'Pu vikhuvasyovangha avanu vuvingi. ");
INSERT INTO zgam_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Pumupuleikhangha amangho ni khulongu ncha linghoha. Mweilolelanghe mulekhe ukhuva nuvudwanchi uvunya khusanisya, pu eimbombo einchi pu chivonekhangha vuvule; Pu leino uvumaleilo vwa khilunga vwiva vukhale ukhufikha. ");
INSERT INTO zgam_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ulwakhuva ikhilunga khisambukhangha nukhukhisambukhila ikhilunga eikhinghe, pu nunkuhuludeva uvakhilunga eikhinge ikhusambukhilangha unkuludeva. Nine uva khilunga eikhinge, pukhulavanei njala neikhisenyenge khya khilunga khila ndimangha ukhwa nukhwa. ");
INSERT INTO zgam_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pu angha nghoni nghivenchangha vwuvu tenghuleilo vwa vunkuveilwa. ");
INSERT INTO zgam_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Pu useikhi inghwa vikhuvanghalukhilanga umwe pumvenchange vanjhila khinu. Puvikhuvabudangha. Pumuvenchangha vanu vansule mufilunga fyoni savali ya litawa lyango. ");
INSERT INTO zgam_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Pu vingi vikhibhumeinchangha nukhunghalavandukhilanila nukhuvepeilania vavo khwa vavo. ");
INSERT INTO zgam_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Avanyamalangho vingi puvalahumeila nukhuvasyova avanu vuvingi. ");
INSERT INTO zgam_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ulwakhuva uvuvi vuladeingha, ulunghano lwa vingi lulanchinchima. ");
INSERT INTO zgam_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Puleino uveiyakhiva eikhiyumeileincha nakhuvusileilo vei uyu ipokhi vwanghwa. ");
INSERT INTO zgam_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Eilei livangeili lya ludeva pulilumbeileili wanghwa mkhilunga khyoni ukhuva nghavenchange mamenyu ngakhulumanya avanu vakhilunga khyoni. ");
INSERT INTO zgam_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Pu leino, mulava mukhuluvona uluvipo lwa vuvivi, ululwanchoviwe munyamalangho u Danieli lweimile baho pavalanche (uvei ikhwimba alumanye), ");
INSERT INTO zgam_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Pu avaleikhu vuyuta vinyileilangha mu fyamba. ");
INSERT INTO zgam_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Pu ula uvialei khukanu alekhanghe ukhwi kha khutola ifinu ifilimunyumba ya mwene, ");
INSERT INTO zgam_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Pu ula uvialei khukhyalo vope alekhe ukhukilivukha khutola umwenela nghwa mwene. ");
INSERT INTO zgam_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","P leino lwavo vala avaleineiminchingho ghya khulola avana, navavo vikyosya ifinghono ifyo! ");
INSERT INTO zgam_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mudovanghe munyeisayo ukhuta ukhu keimbeila khweinyo khulekhe ukhuva useikhi nghwa mepo eiyahala, hange yeilekhe ukhuva khinghono khya lekhela khumo. ");
INSERT INTO zgam_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ulwakhuva uvunongwe vwa khinghono eikhyo vulava fincho, uvutava vungelile ukhuhumeila ukhuhuma vukhipeliwa eikhilunga nu khufikha leino na hange savulava eikhyo lusikhu. ");
INSERT INTO zgam_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Eingave isikhu eincho nchale chiveikhiwe ndebe pu sale avepo umunu unya khukava uvupokhi. Puleino savali yava haliwa ifinghono ifyo pufiva fidebe. ");
INSERT INTO zgam_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Puleino engave umunu yuyoni ikhuvavala ukhuta, “Ukeiliesile, aleipa ewo alei ukhu mulekhanghe ukhweideikha amamenyu angho. ");
INSERT INTO zgam_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ulwakhuva puvalavonekhanga avakeileisite avavudesi na vanyamalangho avavudesi nukhupela ifidengho ifivaha iftakhu swingha, uvufumbwe vwavo vavenchangha vufumbwe vwakhuyancha avanu hange navavahaliwa. ");
INSERT INTO zgam_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Lola pumivapavile angaleimbulongolo. ");
INSERT INTO zgam_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Puleino, vangave vikhuvavulaukhula, “Yeisu aleindunkunghu, 'Mlekhe ukhuluta ukhwa khulankunghu. Nda puvangate, 'Lola, aleimunyumba, 'muleideikhangha, amemenyu angho. ");
INSERT INTO zgam_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nduvu einjasi yeimuleikha ukhuhuma khuvusemo, vuteilava ewo ukhwincha khwa mwana vanyamunu. ");
INSERT INTO zgam_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ulwakhuva puponi pala apaleinufimba, unghunolile punchilundamana ni ngasimula. ");
INSERT INTO zgam_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Leino yakhiva avanu vahumile pavunkuvei lwa, eilinchuva lilavahisi naghumwenchi sanghula muleikhangha ulumuli lwangwene nanchinondwe nchilalanghalangha ukhuhuma khukyanya navanyamakha khukyanya valayungeilangha. ");
INSERT INTO zgam_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pu leino eikhidengho khya Mwana vanya munu khila vonekhangha khukyanya pu avanu voni avankilungha valaveilangha avafivumbukhu fyoni. Puvalambonangha umwana va Nyamunu vuikhwoncha mumaveingo paninie navanyamakha nuvweimikhiwa uvuvaha. ");
INSERT INTO zgam_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Pu alavasuha avasuhwa vamwene nieinyovelo imbaha eiyankuva ngalape pu ava valavalundamania avahalwa ukhuhuma eingutu nchooni nchu inne, ukhuhumangha mbumaleilo uvu uvwa kyanya eiyei navuvumdeilo uvwa kyanya eiyeinge. ");
INSERT INTO zgam_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mumanyielanghe emwo mndeibeikhi eilya mono. Akhaseikhe ulusamba vuluhelukha nakhumencha amaani, pumukhulumanya ukhuta useikhi unghwa vabeni nghuhenghelile. ");
INSERT INTO zgam_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Leino hanghe, yakhiva mukhunghavona angho nghoono. ");
INSERT INTO zgam_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Pu mweideikha mukhuvavula ekhivu mbukhu eikhi sakhihayanghe vusanchivombikhe einchi nchooni. ");
INSERT INTO zgam_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Eikhilunga eikhya khukyanya nei khya pasi khilayangha, pu amamenyu ngango sanghalayangha lusikhu. ");
INSERT INTO zgam_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Pu leino useikhi neilinchuva eilya khuhumeila angha asikhuli uvyaleimanyile, pu navava vasuhwa va khukyanya vope savalumanyile, yeive veimwana va Nyamunu, pu u Daada mwene vei alumanyile. ");
INSERT INTO zgam_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nduvuyale pafinghono ifya Nwakha, vuyeilava vuvuvwa ifinghono ifyawincheilo vwa Mwana va Nyamunu. ");
INSERT INTO zgam_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","|Ulwakhuva ifinghono fila ifya lyongomencho vulakhale ukhufikha avanu valeikhulya mukhunywa, valeikhutengala mukhutenghuliwa pu pakha eikhinghono khila u Nwakha upwainyile mungalava, ");
INSERT INTO zgam_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pasavalumanye khinu savaleikhusa ngha pulwavile lufikhe ulyongomencho mukhiva peimba vooni vu yeilava ewo ukhwincha kwa mwana vanya munu. ");
INSERT INTO zgam_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Pu avanu vaveilei valavenchangha khukhyalo veileima umo pu itoliwanghwa, unine isinghalangha mwene. ");
INSERT INTO zgam_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Avadala vaveilei valahevetangha palwala umo - pwipeimiwangwa umo veisinghalangha. ");
INSERT INTO zgam_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Pu leino, mbeinchanghe miho ulwakhuva samulumanyile sikhu nyikhi yeiyo ayikhwincha unkuludeva veinyo. ");
INSERT INTO zgam_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pu leino mulumanye ukhuta, unyakaya angale alumanye eilinchuva eilyu undyasi ikhwincha pakhuheincha, puale iva miho undyasi alekhe ukhubomola einyumba ya mwene. ");
INSERT INTO zgam_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Pu savuli, ya eiyo nayumwe mweisavanianghe, pakhuva paseikhe unghutava mukhunghusanghila paikhwincha u mwana vanyamunu pu ikhwincha. ");
INSERT INTO zgam_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Pu veini umbombi ungholofu unyluhala, uvei unkuludeva vamwene apeile amakha nghavuvaha pa vala avalei mukaya ya mwene, ukhuta avape ekhyakhulya paseikhi unghunonghelanile? ");
INSERT INTO zgam_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ve nghatalufu umbombi uywa, uvei uNkuludeva vamwene ikhumbonangha aleipakhuvomba uvungholofu nduvwa. ");
INSERT INTO zgam_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ncha yeilweli nikhuvavala ukhuta Unkuludeva pwa yikhumbeikha pa finu fyoni fifyo fya mwene. ");
INSERT INTO zgam_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Puleino eingave imbombi imbivi angate munumbulaya mwene, 'Unkuludeva vango aleindile,' ");
INSERT INTO zgam_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Pu akhalenghula ukhuvatova avavombi avalei pasi pa mwene nukhuvavombila fivi, pu nukhwileila nukhwinywela paninie navanghanchi, ");
INSERT INTO zgam_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Pu Unkuludeva va mwene umbombi uywa eikhwincha paseikhi unghu sanghumanyile. ");
INSERT INTO zgam_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Pu Unkuludeva vamwene pwaladumulyania umbombe uywa mufiveilei veilei fiveilei nukhumbeikha paninie na vanghalo khukhwa pukhuvenchangha nulukuto paninie nulunghaduncho. ");
INSERT INTO zgam_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Pu uludeva lwa khukya luleindavaheinja avuvale ni nyale nchavo puvakhaluta khukhumwambeileila utenghula dala. ");
INSERT INTO zgam_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Puvaleipo avaheinja vahano vale vakonyofu na vange vahano vale nuluhala. ");
INSERT INTO zgam_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Vala vahano avakonyofu puvakhanghengha inyale nchavo khivula maveingha. ");
INSERT INTO zgam_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pu leino avahenja avanya luhala vanghile namaveingha mufivo fyavo paninie ni nyale nchavo. ");
INSERT INTO zgam_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Pu utenghuledala aveile akelinche ukhwincha voni puvakhaghatala vakhanghonelela. ");
INSERT INTO zgam_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pu leino pakilo panghati pukhukhava nei nyoveelo, vakhingho utenghuladala afikhe muhumanghe khukhumwambeileila.' ");
INSERT INTO zgam_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Pu useikhi ndunghu avaheinja vala voni vakhasisimukha vakhanchitesania inyale nchavo chilikhwakha. ");
INSERT INTO zgam_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pu avaheinja vala avakonyofu vakhanja ukhudova amaveingha nghanyale khuvala avaheinja vahano avanyaluhala vavo vale namaveingha anghange mufivo fyavo, vakhata, 'Mtupe amaveingha manini pakhuva inyale ncheito nchilivula maveingha punchinchima ukhwakha.' ");
INSERT INTO zgam_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pu leino vala avuvale nuluhala vakhamula vakhata, 'Hata ndeili pakhuva amaveingha sanghakhatukweile ufwe numwe, pu leino indutanghe mukhanghule khuvano avavinghu ncha amaveingha, pu mweinghuleile anghinyo.' ");
INSERT INTO zgam_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pu vala vahano vavile viluta khwinghula utenghula dala akhafikha, avaheinja vala vavo vaeitesaninche puvakhinghila nutenghula dala munyumbu eiyaluhekhelu lwavatenguladala, pu ulwinchi vakhadeinda.' ");
INSERT INTO zgam_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Pu ponghela pavakhincha avaheinja vala avakonyofu puvakhanja ukhukuta valeikhuta, 'Nkuludeva Nkuludeva tudunduleile.' ");
INSERT INTO zgam_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pu akhavamula akhata, 'Mulumanye ukhuta sameivanyile umwe.' ");
INSERT INTO zgam_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Pu leino muvenchanghe, miho pakhuva samukhimanyile eikhinghono nanghuseiikhi. ");
INSERT INTO zgam_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ulwakhuva leino puyeileihine nu munu uvaanonghwanghwa ukhunghenda pancheila ukhuluta eikhulunga eikhinghe. ");
INSERT INTO zgam_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Akhaveilanga avavanda vamwene akhaveikha uvakavi nuvumofu vwa mwene khuvavanda. Pu akhampa umo indalama ihano, uyunge akhampa eveilei, pu uyunge akhampa eindalama yeimo, nu yunghe aambeileilangha indalama ukhukongana numwavelile amakha nghamwene, pu umunu ula uveiavanghaveilangha indalama avile avapile puakhanja ukhuluta pancheila. ");
INSERT INTO zgam_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pu useikhi nghulanghula ula uveiatolile eindama eihano pu akhaluta khunchivombeleila nukhwinchulusya pu akhakava eindalama inchinge ihano. ");
INSERT INTO zgam_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Pu nayulayula uveiaambeilile eindalama eiveirei navope akhinchulusya akhakava inchinge iveilei. ");
INSERT INTO zgam_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pu leino umbanda uveiaambeilile indalama yeimo pu akhaluta akhanchiyava akhanghuli mbaha vamwene. ");
INSERT INTO zgam_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Pu nghwavye nghululile useikhi unghwa finghono fingi akhanchikhwincha Unkuludeva va vanda vala pu akhavala eimbaleilo navo. ");
INSERT INTO zgam_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pu akhincha ula uveiaambeilile indalama ihano akhava ongelinche indalama inchinge ihano. Akhata Lola, pumeinchi kavaile indalama einchinghe ihano pakyanya.' ");
INSERT INTO zgam_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Pu Unkuludeva akhambula ukhata unghahile vuvonu, 'veimbanda veinonu hange uleingolofu! Pu khale ingolofu pafinini ifi. Punikhukhuveikha uveindoleli pafingi. Puleino eingheilangha muluhekhelo lwa Nkuludeva vakho.' ");
INSERT INTO zgam_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Pu umbanda uvei aambeilile indalama iveilei akhincha akhata, “Nkuludeva, akhanule indalama eveilei. Lola, puneikavile indalama inchnge eiveilei pakyanya,' ");
INSERT INTO zgam_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Unkuludeva vamwene akhambula akhata, “Unghahile, vononu uleimbanda nonu hange ukingholofu, ukhele ngolofu pafidebe ifi punikhukhuveikha pavuloleli uvwa fingi. Ingheila munduhekhelo lwa Nkuludeva vakho.' ");
INSERT INTO zgam_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pu pongela leino umbanda ula uveiaambeiliye eindalama eimo akhincha akhata, 'Nkuludeva, neilumanyile ukhuta uve ulei munu nkangafu. Vwibena upunsuvyalile, vulundamania patava ukhahasinie. ");
INSERT INTO zgam_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Pu leino pungadwaadile pangalutile pakhufiha eindalama pasi. Lola, puleinayo apapuyeile yeila eiyakho.' ");
INSERT INTO zgam_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Pu ukuludeva va mwene akhamula akhata, 'Veimbanda uve veombovi hange uleimwolo, ulumanyile ukhuta nibena patava ngavialile hange nilundamania epatava ngahasaninche. ");
INSERT INTO zgam_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Pukhikhale kheikhi ukhuvapa eikhuma khyango vala avikhwolosya, pu ula vunieikilivwikhe paniale nitola paninie na yeila eiyuvyolwisye. ");
INSERT INTO zgam_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Puleino miita mupokhe eindalama eiyo, mumpe ula uvyaleinindalama eikhinchingho. ");
INSERT INTO zgam_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ulwakhuva avanu avaleinafyo ifinge vu ava, vikhyongele nchiwangha ukhupewa nifinge pakyanya. ");
INSERT INTO zgam_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Pu umbanda uyu uveisanonghile pumutanghe muhisi eiyakhunji.' ");
INSERT INTO zgam_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ulwakhuva alava ikhavincha avala ikhwincha amavana vanyamunu mumbu dwadwa Nwamwene, navasuhwa avavala nche voni paninie namwene, pu leino pwalatama pakhinghoda eikhinyalwa ngula eikhyavutonchiwa vwa mwene. ");
INSERT INTO zgam_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Pu avanu avafilunga fyoni valalundamana pavulongolo pamwene, pu umwene alavapadula nduvu udeimi ipadula ing'osi ni mene. ");
INSERT INTO zgam_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Pu ing'osi alanchiveikha khukhivokho eikhya mwene, eikhya khundyo, pu imene alaveikha khukhivokho eikhyaheinghi. ");
INSERT INTO zgam_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Pu Unkuludeva alava vula vala avalei khukhivokho eikhyakhundyo, 'Alata, mwinchanghe khunu umwe mweivasayi vwa va Dada umwe, mwengheilanghe khuludeva ulu u Nguluve avaveikhile umwe ukhuhuma vukhipelivwa eikhilunga. ");
INSERT INTO zgam_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Pakhuva vuneileineinjala umwe muleikhu fungheila une ifinu, upu miale palenghenelo pa njeila umwe mukhanyupeileila; upulwa tovile ululakha uumwe mukhama amanghasi ngha khunywa; Upuniale khibwinda mukhafwaleincha eimienda; ");
INSERT INTO zgam_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Upuniale itamu mukhandolela; upu niankungiwe nei minyololo khulupatala mwainchile khukhundola.' ");
INSERT INTO zgam_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Pu leino avangholofu puvalamula valata, 'Nkuludeva, ndeili upatwakhu vwene kuleinei njala, tukhakhufunghiela? Mupu vwale mululakha lwa manghasi tukhakhunywesya amanghasi? ");
INSERT INTO zgam_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Hange ndeili twakhuvwene uleipalunghendo, panchiela lukhakhwambeileila? Nu pavwale vubwinda tukhakhufwaleinaha? ");
INSERT INTO zgam_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ndeili tukakhuvwene vuleitamu, na vunkhungilwe neiminyololo, uleindupatala tukhincha pakhukhulola? ");
INSERT INTO zgam_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Pu Unkuludeva ikhuvamulangha, 'Nukhuvavula ukhuta, eideikha nikhuvavula, eikhinghelelo eikhyu mumbombile udebe vuvuvwa, vumumbombile une.' ");
INSERT INTO zgam_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Pu ikhuvavulangha leino vala avaleikhu khivokho khya mwene eikhya heingei muhenghe khulyone, 'Mweimukotoliwe, pu mulutanghe khumwoto unghwa sikhu nchooni, unguveikhiwe suvuli ya tavangwa navasuhwa vamwene, ");
INSERT INTO zgam_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ulwakhuva niale neinjala samwame eikhyakhulya, upumiale nululakha samwame amangasi nghakhunywa; Upuniale nghenji samwanyambeileila vuneile vufula samwafwaleinche; ");
INSERT INTO zgam_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Upuniale itamu samwainche khukoudola; Hange nupuniale neiminyololo, ndupatala neiokungiwe samwainche khukhoundola.' ");
INSERT INTO zgam_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Pu leino vupe avovkhwamulangha nukhuta, 'Nkuludeva, ndeili tukhakhuvwene vulei neinjala, nupu vwale nululakha, nu puvwele inghenji nu puvwale vubwinda, vwale itamu nupuvwale neiminyololo unkungiwe pu safwakhutange? ");
INSERT INTO zgam_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Pu leino ikhuvamulangha nukhuta lwei, 'Nikhuvavula khila eikhyusa mwavavombele nukhuvatanga vamo muvana avadebe ava pusamwa na nganghe une.' ");
INSERT INTO zgam_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Pu leino avo vilutangha munduvungu ulwasikhu nchooni navala avangholofu vilulangha khumwoto unghwa sikhu nchooni.” ");
INSERT INTO zgam_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pu U Yeisu avile amalile ukhunchova amamenyu angha nghoni, pu akhavavula avakongi va mwene, ");
INSERT INTO zgam_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mulumanyile ukhuta nchisinghile isikhu iveilei vuvule ukhuva pasakha, pu nayumwana va Nyamunu vikhungha lavanchukhilangha ukhuta avungiwe.” ");
INSERT INTO zgam_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Pu pongela avavaha vavatekhenchi navanghongholo va vanu vikhwanghanila pupaninie pavanchenge vwa vutamo vwa tekhenchiumbaha, eilitawa lyamweme vei Kayafa. ");
INSERT INTO zgam_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Puvakhideihana ukhuta, “Tumwibate u Yeisu nukhubuda. ");
INSERT INTO zgam_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ulwakhuva vaeideihine ukhuta, “Eilekhe ukhuva pakhinghono eikhivalanche pu yayipelaunchwengho pamiho ngha vanu.” ");
INSERT INTO zgam_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Pu u Yeisu vwaleikha Betania munyumba ya Simoni uvei ale me buba, ");
INSERT INTO zgam_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Pu udala umo akhincha atwalile ekhovo, eikhinyamono inonu finchopwakhahenghelela pa Yeisu akhinama nukhududeiyeila inomo khuntwe upuatamile waleipakhulya. ");
INSERT INTO zgam_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pu avakongi vamwa mwene vuvalolile ndavule vakhavipa fincho pu vakhata vweikhi uvuveyanile vwakhyuma ndavule? ");
INSERT INTO zgam_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nakhuva imono inchi nchale nchinghunchiwa nukhukava ikhyuma ikhilipakhyanya fincho, nukhuvatanga avanghanchu.” ");
INSERT INTO zgam_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Pu u Yeisu, akhava avamanyile amasangho nghavo pu akhata, “Kheikh mukhunghatancha udala uyu? Pakhuva khinu kheinonu eikhya ambombile une. ");
INSERT INTO zgam_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Avanghanchu muleinavo ifinghono fyoni pu leino une samuleinune ifinghono fyoni. ");
INSERT INTO zgam_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ulwakhuva unkhundudeileila une imono inchi pa mbeilei nghwango, ambombile ewo pakhuva ikhunesania pukhusyielaune. ");
INSERT INTO zgam_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ncha yeilweli nikhuvavula ukhuta, puponi upuyakhiva eilivangeili eilei lilumbeileiliwa ghwa mukhilunga khyono, ikhyuavombile udala uyu pukhinchuvivwangwa mumbu nkumbuheincha vwa mwene.” ");
INSERT INTO zgam_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pu ukongi umo muvala khinchingho na vaveilei, unyalitawa eilei Yuta uvanu Kalyoti, puahakhuluta khuvavaha va vayekhenchi. ");
INSERT INTO zgam_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Akhata, “Pumukhuma khinu kheikhi une neinganghalavandukhe u Yeisu?” Avene pukhanghelela nukhubineila indalama eimilevula nghidatu. ");
INSERT INTO zgam_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Pu ukhuhumangha apo pwaleikhulonda akhavaleilo akhakhunghalavandukha U Yeisu. ");
INSERT INTO zgam_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pu paleinchuva eilitanchi elya fisyesye ifilivula nsabe, avakongi vakhanduteila u Yeisu nukhuta, “Ndapi upuvwinonghwa tukhutesa neiheinche puve munu vakhulya eipasakha?” ");
INSERT INTO zgam_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Indutanghe, “Khuvanchenge pumukhumbonangha umunu umo pumumbale ukhuta, Umanyisi atilei useikhei nghwango nghuhenghelile pu nilonda ukhuleila eipasakha munyumba yakho une navakongi vango.'” ");
INSERT INTO zgam_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Avakongi puvakhavomba nduvu u Yeisu avalanghiile, puvakhatesania apakhuleila eipasakha. ");
INSERT INTO zgam_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pu leino khwa vile khwilile, puakhatama navakongi va mwene pakhulya eipasakha. ");
INSERT INTO zgam_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Vavile vilya eipasakha akhata, “Ncha yeilweli nikhuvavula ukhuta umo ndyamwe ikhungalandukha.” ");
INSERT INTO zgam_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Pu vakhansunsuvala fincho, pu umo umo aleikhuvuncha khwa Yeisu aleikhuta, “Pamo, nene, Nkuludeva?” ");
INSERT INTO zgam_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Pu U Yeisu akhavamula akhata, “Ula uveininchaba paninie numwene mukhi hava vei uywa eikhungalava ndukha. ");
INSERT INTO zgam_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","U Mwana va Nyamunu pu iluta, tuvu asimbiwe. Pu leino lwa mwene umunu ula uveikhunghalavanchukha u Mwana va Nyamunu! Pu yale yiva huba khumwene umunu uywa ale ave saholiwe.” ");
INSERT INTO zgam_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","U Yuda, ula unyakhunghalavandukha akhamula akhata, “Pu!, imanyisi?” Pu U Yeisu akhata, “uve vuwita.” ");
INSERT INTO zgam_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Vavile valeipakhulya pu, u Yeisu akhatwala eikhisyesye akhasana, pu akhamenyula. Akhavapa avakongi vamwene akhata, “Mutolanghe, mulinchnge. Unghu nghyu mbeilei nghwango.” ");
INSERT INTO zgam_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pu akhatola neikhinywelo akhasana pu akhavapa akhata, “Munywenchanghe mweivoni mueikhi. ");
INSERT INTO zgam_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ulwakhuva unghu unghyu nkisa nghwango unghwa lweideihano, unghududei kha pavingi pavusyiekhilo vwa mbivi. ");
INSERT INTO zgam_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pu leino nikhuvavala ukhuta, pusaneikhanywe khange numwe, pupakha neilava ninywa upya paninie numwe pa ludeva lwa Daada vango.” ");
INSERT INTO zgam_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pu leino vavile vamalile ukhwimba nukhunginia puvakhahuma khunji nu khuluta khukhyamba khya mono. ");
INSERT INTO zgam_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Pu u Yeisu akhavavula akhata, “Ekeilo eiyei mweivoni mukalalangha savali yango ulwakhuva yeisimbiwe, punikhutova utekhenchi pu ekhipungha khya ng'osi khye vanikha. ");
INSERT INTO zgam_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pu leino yakhiva neinchukhite, puyanikhuvalongola ukhuluta khu Galilaya.” ");
INSERT INTO zgam_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pu U Peteli akhamula akhata, “Ndaveipungave vooni yavi vipa savuli yakho une pusanikhavipe niva paninie nuve.” ");
INSERT INTO zgam_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","U Yeisu akhamula akhata, “Ncha yeilweli nikhukhuvula eikeilo eiyei vueilikongove leikhale ukhuvekha pu vwiva umbelile khadatu.” ");
INSERT INTO zgam_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","U Peteli akhata, “Nu pupanonghile une ukhufwa nuve, sanghakhubele lusikhu.” Pu nava vakongi avange vakhata vulevule. ");
INSERT INTO zgam_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pu u Yeisu akhaluta navo avakongi paluvanja ulwa Getisamani pu akhata khuvakongi vamwene, “Mutame apa pu une neilute ukhu pakhudova.” ");
INSERT INTO zgam_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pu akhatola u Peteli navana vaveilei ava Sebedayo pu akhatengula ukhu nsunsuvala nukhuyuyuvala. ");
INSERT INTO zgam_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Pu akhavavula akhata, “Einumbala yango yeinsunsuvile fincho, ulunsunsuvalo ulwakhufwa. Pu mve apa hange mve miho paninie nune.” ");
INSERT INTO zgam_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Pu akhaluta pakhimbale padebe puakha nghwila, eilitumbu akhanja ikhubeileifyu kha nukhwisaya. Pwaleikhudova aeikhuta, “Daada vango, panghale pavonekhe apakhuluta eikhiywelo eikhi, eingave vunonghwe vwakho pu uvunonghwe vwakho vavombekhanghe.” ");
INSERT INTO zgam_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pu akhaluta pavakongi vamwene akhavona vanghonelile, pu akhambula u Peteli akhata, “Pu kheiikhi mulemilwe ukhuva miho paninie nune napaseikhi nghumo vavula? ");
INSERT INTO zgam_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Muvenchanghe miho nukhwisaya ukhuta mulekhe ukhuva ndu nghelo. Inumbula yeidekhe umbeilei unghu nghyudekhedekhe.” ");
INSERT INTO zgam_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Puakhaluta khange pakhudova ulwa veilei, akhata, “Daada eingave, eikhinywelo eikhi pasipali pavunge apa akhuluta, pu uvu nonghwe vwakho vukongivwanghwe.” ");
INSERT INTO zgam_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pu akhavuya khange khuyakongi akhavona vanghonelile itulo pakhuva amiho nghovonghangatile. ");
INSERT INTO zgam_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Pu akhavalekha khange akhaluta khudova ulwadatupu akhadova amamenyu nghunghalanghala. ");
INSERT INTO zgam_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pu pongela akhaluta khuvakongi va mwene akhavavula akhata, “Pumungonelele leino mukekhe? Lola, useikhi nghuhenghelile unghu u mwana va Nyamunu pu aleipakhuva mumavokho nghavatula nonghwa. ");
INSERT INTO zgam_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ima tuvukhe. Lola, uba uveikhungalavandu kha ahenghelile.” ");
INSERT INTO zgam_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Pu aveile ipinchova navo, lola uYuta umo mbakongi vala khinchingho navaveilei akhafikha, paninie. Numwene neikhipungha khya vana ikhivaha khihuile khuvavaha vavatekhenchi navanghongholo vavanu, puvakhincha ni mundu ni mbunda. ");
INSERT INTO zgam_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Pu ula unyakhunghalavandukha u Yeisu akhava avavilile eikhimanyeilo akhata, “Uveiyakhiva nikhunchiba, khudomo vei uywa. mumwibatanghe.” ");
INSERT INTO zgam_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pu ukhaluta khwa Yeisu pu akhata, “Nikhukhunya, vei Manyisi!” Pu akhanchiba. ");
INSERT INTO zgam_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Pu u Yeisu akhata, “Imanyani, vombangha eilyuvwinchile. ");
INSERT INTO zgam_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Lola, leino vala avuvale nu Yeisu, umo pwakhangolosya eikhivokho khyamwene, akhaswekhula umundu ya mwene, pu akhatova khumbombi vatekhe nchi umbaha, pu akhamyatula eimbulukhutu ya mbombi. ");
INSERT INTO zgam_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Pu u Yeisu akhata, kilivula eimundu yakho veikha upuyeikhale, pakhuva voni avilwela nukhubuda neimundu puvibudi wanghwa neimundu. ");
INSERT INTO zgam_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Pamo musangha mwita neilemwa ukhudova u Daada vupe puasuheile useikhi unghu eikhipungha khya vasuhwa eikhingho navaveilei nukhuluteila pakyanya? ");
INSERT INTO zgam_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pu leino pu uvusimbe vumanyeikhikhangha ndakheikhi uvuvwasimbiwe mukalata pu panonghelanile angha ukhuhumila?” ");
INSERT INTO zgam_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Pa seikhi unghwa u Yeisu akhavavula eikhipangha eikhikhya inchile pakhu mwibata akhata, “Pu! mwinchile ni mundu nembunda ukhuta mukhu mwibata unyambunda? ifinghono fyoni muleikhu mutembile neileikhuya manyisya samuleikhunonghwa ukhu puleikha! ");
INSERT INTO zgam_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pu leino inchi nchoni nchivombekha ukhuta punchivonekhange nchila unchuvasimbile mukalata avanyamalangho.”Pu avakongi voni vakhande kha vakhankimbeila. ");
INSERT INTO zgam_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Pu vala avamwibite u Yeisu puva khanghileikha khwa Kayafa, utekhechi Umbaha, pakhuva puvalundamine avamanyakalata navavaha vakhivumbukhu. ");
INSERT INTO zgam_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pu u Peteli aleikhukonga musana akhava patale pu akha nchifikha munyumba ya tekhenchi umbaha, akhingeila akhanchitama paninie navaloleli alole khihumeila khiekhi. ");
INSERT INTO zgam_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pu leino avavaha navatekhenchi voni paninie neikhipungha khyavanchova nonghwa vanchovangha nincha vudesi eincha khuleyela khwa Yeisu, puvabude. ");
INSERT INTO zgam_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nda puyeingave vavonekhe avanyakhu nchova inonghwa ncha vudesi, pasava yeivone inonghwa eiyatulile u Yeisu, puvakheihumia avanchova nonghwa vaveilei pavubulongolo Vakhata, “Umunu uyu aatile, ");
INSERT INTO zgam_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Aleina makha nghakhumamula eitembile ya Nguluve nukhunchenga pafinghono fidatu.” ");
INSERT INTO zgam_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Pu utekhenchi umbaha akhima akhambuncha akhata, “Savukhwamula limenyu? Ava vinchova nyikhi palyuve?” ");
INSERT INTO zgam_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Puu Yeisu akhanchingha mye. Utekhenchi umbaha akhambula akhata, “Nduvu u Nguluve uveikhwale itama niita utuvule, eingave uve veve keileisite, Mwana va Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","U Yeisu akhamula akhata, “Uve veve vwinchova ewo paleino nukhukhuvula niita ukhuhumangha leino vuvonngha umwana Vanyamunu atamile khukhivokho eikhyakhundyo eikhinyamakha vuikhwincha khumaveingo anghakhukyanya.” ");
INSERT INTO zgam_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pu utekhenchi umbaha akhalendula eimienda nghyamwene akhata, “Vubeingha sayilondiwa khange ukhulonda avanu avakhu tutanga ukhunchova? Lola, mumalile ukhupuleikha vuibeingha. ");
INSERT INTO zgam_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Leino! Pu musangha kheikhi? Vakhamula vakhata, “Anonghile ukhubudiwa.” ");
INSERT INTO zgam_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Pu vakhabehela amati khumiho, vakhatova nimbuli, vakhatova na mapi, ");
INSERT INTO zgam_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nukhuta, “Putenghuleila veeni uvei akhutovile?” ");
INSERT INTO zgam_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Useikhi unghwa u Peteli atamile khunji khuluvanja, pu udala umo umbombi akhanduteila akhata, “Uve na yuve ukhale paninie nu Yeisu uvamunu Galilai.” ");
INSERT INTO zgam_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Puakhabela pa vanu voni akhata, saneinchimanyile einchuvwinchova.” ");
INSERT INTO zgam_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Avile ihuma pandyango, udala uyunge umbombi akhavavwa avanuavavale epwo pala akhata, “Umunu uyu vope akhale paninie nu Yeisu uva mu Nazaleti.” ");
INSERT INTO zgam_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Akhabela hange akhijyiengha akhata, “Une sanimanyile umunu uyu.” ");
INSERT INTO zgam_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pu akhaseikhi khadebe, vala avuvale pwuvale pala vavo vale pipi nave u Peteli, “Vakhata lweli uve uleinine va Yeisu pakhuva nayeinchovele yakho yivonesya.” ");
INSERT INTO zgam_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pu akhatengula ukhwijyiengha mukhwikotola aleikhutu, “Saneimanyile umunu unywa,” Pu eilikongove leikhavekha. ");
INSERT INTO zgam_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","U Peteli akhankumbukha amamenyu unghuavuliwe nu Yeisu, “Eilinkongove vusaleiveikhile yavukhumbela khadatu.” ");
INSERT INTO zgam_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pu useikhi unghwa pavasikhu nghwavile ngufikhe avavaha voni avavatekhencha navavaha vavanu pu vakhalundamana pakhunchovana umwakhubudeila u Yeisu. ");
INSERT INTO zgam_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Puvakhankunga vakhandonghoncha ulukhuluta khwa piate undolei va khilungha. ");
INSERT INTO zgam_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pu leino u Yuta, uvei anghalavandwikhe u Yeisu avye avwene valamwile ukhuta u Yeisu vabude, pu einumbula yeikhambava pu akhaluta khukilivula indalama inchuvapile eimilevulu gheidatu, ");
INSERT INTO zgam_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","akhavakilivuleila avatekhenchi avavaha na vanyivaha, U Yuta akhata, “Neitulile einongwa pakhunghunghalavandukha unkisa unghule nchila nongwa.”puleino vakhata, “Yeikhutuvumbuleila kheikhi ufwe? Pu angho vweilolehanghe yuve.” ");
INSERT INTO zgam_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Pu leino umwene akhalaha pasi indalama munyumba eimbalanche pavalekhinchi uvuva pile pu umwene akhaluta khukhilulikha. ");
INSERT INTO zgam_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Umbaha vavatekhenchi akhanjitova indalama nchila unchu alahile pasi vakhata, “Vakhata salunonu ukhuveikha mundisanukha lya ndalama incha pelela, pakhuva ndalamanha nkisa inchi.” ");
INSERT INTO zgam_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Puvakhinchofanja pupaninie voni vakhidei hana ukhuta puvanguleile eikhulunga, eilileivunchi lya mbumbafivya vakhata pupakhusyiela avanghenji. ");
INSERT INTO zgam_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Pu leino eililevunchi leila likheilangiwa, “Lilevnji lya nkisa” nanchi sikhu inchi. ");
INSERT INTO zgam_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Puleino eilimenyu leila eilyulya nchovivwe munyamalangho U Yeleimia puleikhava leimalile ukhuvombekha upuatenchangha, “Vatwalile indalama eimilevulu nghidatu, eilinghunchi eilyakhunghula umwene, eilinghunchi eilyangu nchiwe na vanu vamu Israeili ya mwene, ");
INSERT INTO zgam_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Puvakhavombela ukhunghuleila eililevunchi lyambumba fiyya, nduvuandanghile Unkuludeva.” ");
INSERT INTO zgam_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Pu leino u Yeisu akhima pandoleili vakhilunga, pu undoleli akhambuncha, “Pu uve veve Nkuludava va Vayuta?” U Yeisu akhamula akhata, “Uveve vuvwita.” ");
INSERT INTO zgam_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Puleino vavile vikhumbuleila avavaha va vatekhenchi navanyivaha, sa amule limenyu. ");
INSERT INTO zgam_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pu U Pilato akhambuncha akhata, “Pusavupuleikha unghuvikhuvuleila uve?” ");
INSERT INTO zgam_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pu umwene samwamule eilimenyu naleimo, pu undolaili vakhilungha akhaswingha fincho. ");
INSERT INTO zgam_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pu leino pakhinghono eikhivalanche lwale lwiho lwa Vayuta ukhudeinduleila unkungwa umo uveiahaliwe nei khipungha khya vanu. ");
INSERT INTO zgam_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Pu useikhi nghula khwale nu nkungwa vanyololo unduti ale vei Balaba. ");
INSERT INTO zgam_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pu leino vavile valundamine pupaninie avanu pu u Pilato akhava vuncha, “Mwinonghwa neideinduleile uveni?” Pamo neuvadeinduleile U Balaba pamo U Yeisu uveikheilangiwa veikeileisite?” ");
INSERT INTO zgam_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Avavunchinche pakhuva alumanyile ukhuta vikhungheingha u Yeisu savuli ya khivini. ");
INSERT INTO zgam_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Puavile atamile pakheinghoda khya mwene eikhya khuheingheila pu udada va mwene akhasuheila eilimenyu eilita, “U lavombangha kheininie khumunu uywa umbula nonghwa. Pakhuva neinghatanchiwe fincho eilelo munjosi savwi ya munuuywa.” ");
INSERT INTO zgam_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pu leino avavaha vavatekhenchi na vanyivaha vakhavasonga ikhipungha vadovanghe ukhudei nduleila u Balaba, pu u Yeisu abudiwe. ");
INSERT INTO zgam_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Undoleli vakhilunga akhavavuncha akhata pa ava vaveilei aleikhu mwinonghwa neideinduleile khulyumwe?” akhata, “Balaba.” ");
INSERT INTO zgam_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pu u Pilato akhavavula, “Pu neinghale ndakheikhi u Yeisu uvei ikheilangiwa keileisite?” Voni vakhamula vakhata, “Aloveleliwe pakheidameileihanie” ");
INSERT INTO zgam_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Undoleli vakhelungha akhavuncha, “Akhata avombile vuvivi vukhi?” Pu avene valeikhyo vela fincho amamenyu, “Alovelelwe.” ");
INSERT INTO zgam_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pu u Pilato avile avwene savikhumweidei kha vanghanghile nukhyovela pu akhatola amanghasi akhakalava amavokho eikhipungha vukhilola, akhata, “Neileimbulanonghwa pa nkisa nghwa munu uyu ungholofu pu mweilolelanghe yumwe angha.” ");
INSERT INTO zgam_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Avanu voni vakhata, “Unkisa nghwa mwene nghuvenchanghe palyufwe na vana veito.” ");
INSERT INTO zgam_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pu akhadeinduleila u Balaba pu umwene, u Yeisu akhatova ni mbeikhi pu akhavapa avene vakhatovelele pakheidameileihanie. ");
INSERT INTO zgam_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pu leino avasikhali vandolela khilungha vakhatola u Yeisu ukhuluta munyumba eiyakhupembenukhila avasikhali voni vakhalu ndamanapa pa Yeisu. ");
INSERT INTO zgam_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Pu vakhafula eimyenda nghyoni vakhafwaleincha unghwanyingeileincha ufuveifu. Pu vakhahona uludenghuleilo ulwa motoni puvakhaveikha patwe nghwa mwene, puvakha veikha neilinghunghu khukheivokho khya mwene eikhyandyo. ");
INSERT INTO zgam_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Puvaleikhufunghama pavulongolo pamwene vale khuta, “Tupepencha khuvinkulu aleva vava vayuta, “Pu valeikhukineila?” ");
INSERT INTO zgam_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Vakhabehela amati, vakholola eilinghunghu vakhatovela patwe. ");
INSERT INTO zgam_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Puvavile vikhukineila vakhafwa unghwanyinjei leincha vakhafwaleincha eimienda nghya mwene, puvakhandongoncha ukhuluta khukhutovelela pakhidameileihanie. ");
INSERT INTO zgam_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Vavile vahumile khunji, vikhambona umunu uva khukilene eilitavwa lya mwene ale vei Simoni, puvakhatola vope ukhuta apeimbe eikheidameihanie. ");
INSERT INTO zgam_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Puvavile va fikhe aponu apikheilangiwa pupa Goligota, khukhuta pupavunyali vwantwe.” ");
INSERT INTO zgam_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pu vakhampa na masilu unghu vahanchinche nei nyongo vakhata anywe. Pu leino avile einonchanjinche mundomo sanywe. ");
INSERT INTO zgam_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pu vavile vato velile pakhida meileihanie puveleikhuncha eimienda nghyamwene nukhutenghuleila. ");
INSERT INTO zgam_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Puvakhatama valeikhundolela palapala. ");
INSERT INTO zgam_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pantwe pa mwene puvakhaveikha amamenyu unghuvasimbile vakhata, “U YU VEI YEISU, UNKULUDEVA VA VAYUTA.” ");
INSERT INTO zgam_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pu vakhatovelela paninie na vanyambuda vaveili umo akhava khundyo u yungekhu heinghe. ");
INSERT INTO zgam_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Vala avaluteisyaniangha pala puvale khufwe yula nukhutingha eimintwe nghyavo. ");
INSERT INTO zgam_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Puvalei khuta, “Uve yuve ukhatenchangha yavumamula einyumba eimbalanche pu vunchengha khufinghono fidatu, pu vweipokhe yuve! Ungave ulei nswambe va Nguluve, pu vwikhe apo pakhidameileihanie!” ");
INSERT INTO zgam_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Navope ava vaha va valekhenchi nava manyakalata navanyivaha pu valeikhu fweyula valeikhuta, aleikhuvapokha avange pu ilemwa ukweipokha yu mwene, ");
INSERT INTO zgam_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Umwene, vei Nkludeva vaka yuta pu eikhe pasi pakhida meileihanie putukhu mwedeikhangha. ");
INSERT INTO zgam_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Aleikhwi huveila kwa Nguluve. Pu ndekhe u UNguluve apokhe leino engave inonghwa pakhuva aleikhuta, 'Une neileinswambe va Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Pu avanyambuda vala uvuvatovelilwe paninie nu Yeisu navope vakhadukha u Yeisu. ");
INSERT INTO zgam_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pa seikhi unghwa ntanato pakhova neihisi eikhilunga khyoni ukhufikha useikhi unghwa budeikha khumo. ");
INSERT INTO zgam_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Unghwa vile nghufikhe useikhi unghwa budekha khumo u Yeisu akhakuta fincho akhaleila akhuvela akhata, “Eloi Eloi, Lamasabakitani?” khukhuta, “VeiNguluve, vango vei Nguluve, vango kheikhi undeikhile?” ");
INSERT INTO zgam_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Avange vavo valepo vuikuta ndavule, pu vakhata, “Ikhumweilanga u Eliya.” ");
INSERT INTO zgam_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Pu umo khimbeivimbeivei akhanyila akhanchitola akhanda akhanchaba nu sinki pu akhaveikha palunghunghu akhanywesya. ");
INSERT INTO zgam_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pu avange vavo vasinghile vakhata, “Indekhetulole eingave u Eliya ayikhwincha khukhapokha.” ");
INSERT INTO zgam_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Puleino u Yeisu akhakuta akhaleila akhoveela akhadumukha einumbula ya mwene. ");
INSERT INTO zgam_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Pu eilivaleikha lya mutembile leikha niefukha leikhava ng'ana khunu na khunu ukhuhuma khukyanya ukhufikha pasi. Pu nakhikhilungha khikhalindima na manalawe nghakhabandukha. ");
INSERT INTO zgam_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Uvunghuli vukhenchembukha, eimiveilei nghya vanu avangholofu avuvangonelile itulu vakhanchukha. ");
INSERT INTO zgam_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Vakhahuma mulunghuli avile anchukhile umwene, puvakhingeila mumbunchenghe uvuvalanche vakhavonekha khuvanu vingi. ");
INSERT INTO zgam_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pu leino unalongonchi vavasikhali na vala avalolelangha khwa Yeisu vakhivwene eikhisenyenge vukhilindima ni nchooni inchunchavonekhangha, puvakhava nuvundwanchi fincho valeikhuta, “Lweli uyu akhale nswambe va Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Vale epwo avadala pala avakongangha ukhuhuma khu Galilai ukhwincha khukhoutanga vale palapala valeikhulola vavaleipavutale. ");
INSERT INTO zgam_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Muvene avo alepo u Maliya vamugatala nu Maliya uvaninemwa va Yakobu nu Yusefu, nu vaninemwa vavana va Sebedayo. ");
INSERT INTO zgam_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pu lyakhimihe, akhincha umunu umo ukavi va khu Alimatai, uyu ale vei Yusefu, eilitawa lya mwene, pu akhipela ikongi va Yeisu. ");
INSERT INTO zgam_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pu akhaluta khwa Pilate khukhoudova umbeilei nghwa Yeisu. Pu u Pilate akhalanghila ukhuta vape. ");
INSERT INTO zgam_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Pu U Yusefu akhanghutola umbeilei nghwa Yeisu akhanghupinya neimienda ieiminonu fincho eimivalafu hange eimipya, ");
INSERT INTO zgam_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Pu akhanchikhunghunghonia pavunguli uvupya uvuapunjile pa lunalawe. Akhalei beilusya eilinghanga eilivaha leikhava pandyango leikhadeinda uvunghuli, pwakhahengha. ");
INSERT INTO zgam_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Valepo u Maliya uva Maghatala nu Maliya u yunge uvaveili vatamile valeikhuvulola uvunghuli. ");
INSERT INTO zgam_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pakhingono eikhyakhilavo khikhyo khyale khinghono khya khwitesania avavaha va vatekhenchi nava Falisai valundamine pupaninie khwa Pilate. ");
INSERT INTO zgam_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Vakhinchofancha nave vakhata, “Imbala tunkumbusya ukhuta useikhi unghu udesi ula vumwumi, atile.' ");
INSERT INTO zgam_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Pa khinghono eikhyadatu ayinchukha ukhuhuma khuvunchukha. Pu uvudesi vwa khuvumaleilo yavwiva vuvivi ukhuluteila pavula uvutanchi.” ");
INSERT INTO zgam_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","U Pilato akhavavula akhata, “Muvatole avaloleli pu mulute mukhaveikhe avaloleli ndumwuensangheila.” ");
INSERT INTO zgam_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pu vakhaluta vakhaveikha avaloleli, uvunghuli vukhava pavuloleli eiliwe leila vakhaleveikha eikhimanyeilo. ");
INSERT INTO zgam_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Isabati yavile yeilutile, vukhuleipakhukya pakhinghono ikhitanchi ukhuhuma pa sabati pu u Maliya manghatala pu na yu Maliya uyunge vainchile pakhulola uvunghuli. ");
INSERT INTO zgam_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Lola pukhwale neikhisenyenge ikhivaha pakhuva asuhwa va Nguluve ahumile khukyanya pwakhaleibeilusya eilinghanga pu akhalamila pakhyanya. ");
INSERT INTO zgam_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Pamiho pamwene pwaleikhuvonekha ukhuta lumuli lwa njasi, neimienda nghya mwene einghya fwalile nghyale mivalafu ukhula hala. ");
INSERT INTO zgam_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Pu avaloleli vala avavunghuli puvakhake nyemukha, puvakhava nulundwado, vakhanghwa pasi wita vafwile. ");
INSERT INTO zgam_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Usuhwa ula akhava vula avadala vala akhata, “Muladwadangha umwe pakhuva neilumanyile mukhundonda u Yeisu, uvyakhatovelilwe pakhidameileihanie. ");
INSERT INTO zgam_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Asipali apa, puleino anchukhile nduvu akhava vuleile. Pu mwinehe mulole upwakhanghonile unkuludeva. ");
INSERT INTO zgam_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mulute khyahanila mukhavavule navavakongi vamwene, 'Anchukhile ukhuhuma khuvufwe, lola pwalongwile khulyumwe ukhuluta khu Galilai. Ukhwa khukhwene mukhumbona.'Leino punjemalile ukhuvavula.” ");
INSERT INTO zgam_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Pu avadala vala puvakhahengha khya hanila ukhuhuma pavunghuli vakhava nuludwado, paninie nuluhekhelo pavaleikhunkuya ukhuluta khukhuva vula avakongi va mwene. ");
INSERT INTO zgam_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Lola U Yeisu pwakhanghanila navo pu akhata, '“Munghonile.”puvakhakenyemukha, vakhahenghelela vakhamwibata amalunde puvakhisaya khumwene. ");
INSERT INTO zgam_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Pu u Yeisu akhavavula akhata, “mulekhe ukhudwada, mulutanghe mukhavavula avalukololwango nikhu valongola khu Galilai. Ukhwa kuvikhumbonangha. ");
INSERT INTO zgam_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Avadala vala vuvalutile, lola avasikhali avange puvakhaluta khivavaha va vatekhenchi vakhavavula nghooni unghunghahumile. ");
INSERT INTO zgam_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Puvakhalundama avavaha vavatekheneli navanghongolo vankivumbukhu vakhincho fanja navasikhali, ");
INSERT INTO zgam_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","puvakhava pa indalama nchu nyingi avasikhali vala avakhalolelangha. Puvakhavavula vakhata, “muvavulange avanu avange ukhuta, 'avakongi vamwene vakhinchile pakilo puvaheinchile umbei nghwa Yeisu ufwe vutu ngonelile.' ");
INSERT INTO zgam_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pu angave undoleli vakhilunga ipuleikho inonghwa inchi ufwe putwinchova nave alekhe ukhuva neilimenyu khulumwe mulekhe ukhusangha.” ");
INSERT INTO zgam_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Pu leino avasikhali vala vakhatola indalama nchila, puvakhavomba nduvu vavuliwe. Inongwa inchi nchikhavala fincho khuva Yuta pu yeilei ewo ukhufik leino. ");
INSERT INTO zgam_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Pu avakongi vala ikhinchingho numo pakyanya vakhaluta khuyalilai khukhyamba khila eikhn akhavavulele u Yeisu. ");
INSERT INTO zgam_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Navope vavile vambene, vakhisaya khumwene. Pu avange valeikhusina munumbula. ");
INSERT INTO zgam_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","U Yeisu akhincha khuvene akhanehova navo akhata, “Neipevilwe une amakha nghono anghakhukyanya nangha pasi. ");
INSERT INTO zgam_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Pu leino indutanghe leino, mukhavape langhe avanu voni ukhuva vakongi. Mukhavonchanghe mulitavwa eilya Daada, nei lya Nswambe, nu mepo umbalanche. ");
INSERT INTO zgam_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nu khuvamanyisya ukhukonga nghooni unghunivalanghile umwe napavusileilo vwa khilunga. ");
INSERT INTO zgam_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Uvwu vwu vutengulilo wa limenyu lya Yiisu Kriste, Nswambe va Nguluve. ");
INSERT INTO zgam_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ndavwuwa lesimbiwe nu nyamalago Yesaya, “Lole nihonsuha unsuhiwa vangu mumbolongolo hulyove, unyahutesania enjela yakho. ");
INSERT INTO zgam_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Elimenyu lya munu uveikhwelanga ndodasi, “Mmalesyage injela ya Ntwa; mgolosyage injela incha mwene.” ");
INSERT INTO zgam_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","O Yohani ainchile, alekuncha ndodasi nu hulumbilila ulyancho ulwa khupela khu lusyekhelo lwa mbivi. ");
INSERT INTO zgam_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ekhelunga khoni ekhya Yudea na avanu voni ava mu Yerusalemu valutile khumwene. Valekhyonchiwa nnmwene ndugaasi ulwa Yordani, valechupela imbivi incga vene. ");
INSERT INTO zgam_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","O Yohani afwalaga umwenda gwa lwage lwa ngamia nu ombote gwa ngwembe mukhivina lchya mwene, alinchaga imanji nu wukhi vwa mwinyasi. ");
INSERT INTO zgam_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Alumbilile nu khuta, “Pwale yomo uveikhwincha munsana nndyone unyamakha agalutelile khulyone, one saniwesya ukhugundame nu ukhuhudula indegekhe incha vilatu ifya mwene. ");
INSERT INTO zgam_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","One navoochiche na amagasi, leno umwene ikhovonchaga umwe nu umepo umbalache.” ");
INSERT INTO zgam_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yakhomile amanchova agoo ukhuta Yiisu ainchile ukhukhuma Nazareti eya Galileya, pwu aonchiwe nu Yohani mundugasi ulwa Yolodani. ");
INSERT INTO zgam_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Imisekhe Yiisu wikhwinamkha ukhukhuma mu ndugasi, akhavona khukhyanya khule mwanchi nu umepo ikhwikha pakhyanya pamwene ndekhengundya. ");
INSERT INTO zgam_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Elimenyu lekhakhuma khukyanya, “Uve ole Nswambago vegane. Nekhuganile uvwe.” ");
INSERT INTO zgam_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Usekhe gugwa umepo akhamwomelencha ukhuluta khulodasi. ");
INSERT INTO zgam_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Avile khuludasi amanchuva arobaini, alekhugeliwa nu Ntavangwa u setano. Ale pupaninie ni ifikanu ifya mwinyasi, pwu avasukhiwa valekhuntangela. ");
INSERT INTO zgam_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pwu vwu ibatiwe Yohani, u Yiisu akhincha khu Galileya alekhulumbilela alimenyu lya Nguluve, ");
INSERT INTO zgam_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Alekhuta, “Unsekhe gusilile, uludeva lwa Nguluve lukhegelile. Pelega nu khwidika elimenyu.” ");
INSERT INTO zgam_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Vwuilotanincha ndukhanji mwanyanja eya Galileya, akhambona u Simoni nu olokhololwe u Ndeleya vilakhela inyafu incha vene mu nyanja ulwa khuva vavombaga embombo eya khulova. ");
INSERT INTO zgam_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yiisu akhavavola ukhuta, “Mwinchage, mung'ongage, nikhovavekha ukhuva valovi va vanu.” ");
INSERT INTO zgam_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Unsekhe gugwa vakhanchilekha inyafu valekhunkonga. ");
INSERT INTO zgam_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","U Yiisu walotile pavutali padebe, akhambona u Yakobo unswambe va Zebedayo nu Yohani alokololwe; vale mu mbwato valekhutenda inyafu. ");
INSERT INTO zgam_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Na vope akhavelanga vahandekha u Dada vavene u Zebedayo mu bwato na avavombi avagongoliwa, vakhankonga. ");
INSERT INTO zgam_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Vovanchifikhe hu Kaperinaumu, elinchuva lya isabato, u Yiisu akhingila mu sinagogi mukhumanyisya. ");
INSERT INTO zgam_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Valeswigila lelyo alemanyisye, ulwa khuva alekhuvamanyisya ndu munu unyalulagelo sandavovwa vavimanyisya amasimbi. ");
INSERT INTO zgam_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Unsekhe gugwa khwale nu munu mu sinagogi lya vene uveale ni mepo imbivi, pwu akhaywega, ");
INSERT INTO zgam_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Akhata, “Tulene khehi ekhya huvomba nuve, Yiisu va Nazareti? Winchile khukhutoyancha? Nekhumanyile ule veni. Uve ulembalanche vemwene va Nguluve!” ");
INSERT INTO zgam_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","U Yiisu akhanchibencha imepo nu khunchova, “Nunala mukhome mgati mumwene!” ");
INSERT INTO zgam_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Pwu imepo embivi yekhagwisya pasi nu ikhahuma mumwene vwu ilelo khu limenyu elya pa kyanya. ");
INSERT INTO zgam_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Avanu voni valekhuswiga, pwu valekhuvonchana khela munu, “Khenu kheli ekhe? Lumanyisyo ulopya ulunyalulagilo? Ulwa khulagila imepo imbivi ukhumpwulikha!” ");
INSERT INTO zgam_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Elimenyu lya mwene likhamanyekhekha ekhelunga khyoni khya Galileya. ");
INSERT INTO zgam_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Unsekhe gugwa vwa khomile mu sinagogi, vakhingila mbunchenge uvwa Simioni nu Ndeleya vovale nu Yakobo nu Yohani. ");
INSERT INTO zgam_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Leno ukwive va Simioni alekhogona avile ne khoma, pwu unsekhe gugwe vakhambula u Yiisu. ");
INSERT INTO zgam_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Pwu akhincha, akhamwibata ekhevokho, nu khumwinula; ekhoma yekhakhega, akhatengula ukhuvatangela. ");
INSERT INTO zgam_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Lyakhemikhe elijuva volesemile, vakhandetela avanu voni avale watamu, avange avale ni mepo imbivi. ");
INSERT INTO zgam_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ikhelunga khyoni wakhalundamana pwu paninie pa ndyango. ");
INSERT INTO zgam_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Akhavapokha vingi avale vatamu va vitamu nu ukhuvahencha imepo ukhunchova, ulwa khuva nchamanyile. ");
INSERT INTO zgam_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Akhalavela ukhusisismkha panavusiku, vwu khunchige ne khisi; akhahega akhaluta pa vwukhale akhesaya ukhwe. ");
INSERT INTO zgam_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simioni na voni avale paninie nu mwene valekhondonda. ");
INSERT INTO zgam_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Vakhambona nu khumbula, “Ukhuta voni vikholonda” ");
INSERT INTO zgam_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Akhavavola, “Tuvokhe pavunge, khunji mumbojenge, pwu nelumbilela nukhwa. Khyomene ninchile apa.” ");
INSERT INTO zgam_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Akhalota akhagendela Galileya yoni, alekhulumbelela mu masinagogi gavene nu ukhunchibencha imepo. ");
INSERT INTO zgam_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Unyabuuba yumo akhincha khumwene. Alekhodova; akhafugama nu khuta, “INgave vwinogwa, umbombe neve nonu.” ");
INSERT INTO zgam_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Vwuikhulugiwa ne khisa, u Yiisu akhagolosya ekhevokho khya mwene akhankolela, akhata, “Ninogwa. Uvwe nonu.” ");
INSERT INTO zgam_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Unsekhe gugwa ubuuba vukhakhega, akhava nonu. ");
INSERT INTO zgam_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yiisu akhambolanincha ukhuta akhege unsekhe gugwa, ");
INSERT INTO zgam_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Akhambula ukhuta, “Usite ukhonchova elimenyu khwu munu yeyone, pwu lotaga, ukhevonesye khuvatekhenchi, ukhakhumie enekhelo eya uvuvalanche ndavovwa alagile u Mose, yeve luvonekhelo khuvene.” ");
INSERT INTO zgam_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pwu alekhuluta nu khutengula ukhupangila khela munu elimenyu lichadala khwoni pwu u Yiisu akhalemwa ukhwingila khuvulegefu mumbunchenge. Pwu akhatama aponu pavukhale avanu vakhincha khumwene ukhuhuma ukhyoni. ");
INSERT INTO zgam_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Vwavunyile Kaperinaumu manchuva madebe, yekhapolekhekha ukhuta alembunchenge. ");
INSERT INTO zgam_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Avanu vingi vavo walundamine vadegile pakha pa ndyango, pwu u Yiisu akhanchova elimenyu khuvene. ");
INSERT INTO zgam_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Pwu vakhincha avanu vagegile umunu u ndema; avanu vanne vampembile. ");
INSERT INTO zgam_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Vwuvalemilye ukhufikha khwa Yiisu ulwakhuva avanu vadegile, pwu vakhatoga khukhituvile vakhakhotola ekhanu upwalepo u Yiisu, vakhisya ekhyagonile undema. ");
INSERT INTO zgam_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Vwu alowene ulwidikho lwa vene, u Yiisu akhambula undema, “Nswambago, usyekheliwe imbivi nchakho.” ");
INSERT INTO zgam_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Pwu amasimbi vavavatamile pala valekhwe voncha mu numbula, nchevene ");
INSERT INTO zgam_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Yelendakhekhi umunu ukhunchova aga? Idokhela! Veni uveisyekhela imbivi u Nguluve ve nyalusekhelo lwa mbivi?” ");
INSERT INTO zgam_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pwu u Yiisu akhalumanya mu numbula eya mwene ekhevalekhusaga. Akhavavula, “Khekhi msaga evo mu numbula nchenyo? ");
INSERT INTO zgam_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Lelekhu lipepe ukhunchova khu munu u ndema, 'Imbivi nchakho nchisyekheliwe ama ukhuta 'ema ugendage wetwekhe eligonelo lwakho?' ");
INSERT INTO zgam_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pwu valumanye ukhuta Nswambe va Ntwa alenamakha akgakhusyekhela imbivi mu khilunga, akhambula undema ula, ");
INSERT INTO zgam_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nikhukhuvola uve, ema, tola elitefu lyakho, ulutage ukhnjenge vwakho.” ");
INSERT INTO zgam_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Pwu akhema akhatola elitefu lya mwene, akhakhuma panji khoga vanu, pwu vwoni valekhoswiga valekhuginia u Nguluve, nu khuta “Satugelile, ukhulola imbombo ndeye.” ");
INSERT INTO zgam_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Akhaluta khulukhanji eya nyanja, elipuga lya vanu voni vakhincha khumwene, akhavamanyisya. ");
INSERT INTO zgam_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Vwu ilotanincha akhambona u Lawi unswambe va Alfayo atamile upovi songela esongo akhambula ukhuta, “Ung'ongage.” Akhema nu khunkonga. ");
INSERT INTO zgam_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Usekhe u Yiisu vu ilya mbunchenge vwa Lawi, avasakha songo vingi na vanu avatula nongwa valekhulya nu Yiisu na vakhongi va mwene, ulwakhuva vale vingi vope vakhankonga. ");
INSERT INTO zgam_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Avasimbi vavo vale vapitawe, vovawene ukhuta u Yiisu ilya na vatula nongwa na vasakha songo, vakhavavula avakhongi va mwene, “Khehi ilya na vasakha songo na vatula nongwa. ");
INSERT INTO zgam_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","U Yiisu vu apolikhe akhavavula, “Avanu avakhafu emivele gya vene savilonda uvakhovayavela; avanu vavo vatamu vovilonda uvakhovanyavela. Saninchile khukhwilaga avanu avanya lwidikho, ninchile khuvanya mbivi.” ");
INSERT INTO zgam_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Avakhongi va Yohani na Avapitawe. Pwu avange avanu vakhincha khumwene khukhombola, “Khekhi avakhongi va Yohani na Avapitawe hufunga, na avakhongi vakho hawafungi? ");
INSERT INTO zgam_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","U Yiisu akhavavula, “Avelangiwe ukhutoliwa udala wiwesya ukhufunga, imisekhe unya khutola udala vuvalenjela, unyaweghi vovalenjela savakhefunge.” ");
INSERT INTO zgam_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Amanchuva khikhwincha untola udala vuahenchi we khuvene, pwu mumanchuva ago pwu fifungaga. ");
INSERT INTO zgam_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Asikhuli umunu uveikhona ekhe tambala khya mwenda umpya mumwenda unkholo, apo umwenda ugwa pwu gwitatukha tena, ekhepya khikhega mu mwenda unkolo, pwu yapiva pavakhe uluvuvu. ");
INSERT INTO zgam_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Asikholi umunu uveivekha uvugimbe uvwunonu mu khidenge khyakhatale, uvugimbe yavukhufibanchula ifidenge, uvugimbe ne ifidenge fyoni pwu fiyaga. Uvungimbe uvwunonu vekha mu khidenge ekhepya.” ");
INSERT INTO zgam_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pa linchova lya sabato u Yiisu alotaninche khufyolo, na avakhongi va mwene vakhatengula ukhipa ulubelege lwa ngano. ");
INSERT INTO zgam_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pwu avapitawe vakhambulo, “Lola khekhi vivomba ekhenu khekhyo ululagelo lubela ukhuvomba elinchuva lya sabato?” ");
INSERT INTO zgam_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Akhavavola ukhuta, “Samwembile ekya avombile u Daudi ulwa ale ne njala umwene navanu vavo vale paninie nave? ");
INSERT INTO zgam_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Umwa alotile mu mbunjenge vwa Nguluve Abiathari upwu ale ntekhenchi mbakha, akhalya ukate uguve khwe khuvolongolo - gugwa ululagilo lwa benchiche umunu yeyoni ukhulya - gwale wagwa na vatekhenchi - akhavapa voni vavo vale paninie numwene?” ");
INSERT INTO zgam_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","U Yiisu akhanchovaukuhuta, “E Sabato yavombiwe khutwevanu, sio avanu khu Sabato. ");
INSERT INTO zgam_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Pwu, u Nswambe na Adamu ve Ntwa, khu Sabato.” ");
INSERT INTO zgam_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Vwu ingile mu sinagogi muvile nu munu unyakhevokho khelema. ");
INSERT INTO zgam_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pwu avange avanu vavovalekhonkongelela pa wipi ukhulola inave yikhopokha elinchuva lya Sabato pwu vang'ege. ");
INSERT INTO zgam_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","u Yiisu akhambula unyakhevokho khelema, “Ema paagatinagati pa lulundamano ulu.” ");
INSERT INTO zgam_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pwu akhavavola avanu, “Lunonu ukhuvomba elinonu palinchuva lya Sabato ama ukhovomba gago sagalweli; ukhupokhe uvwumi, ama ukhubunda?” Avene vakhanchiga mie. ");
INSERT INTO zgam_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Hulyoyo akhavavola, avile nulususuvalo ulwakhuva vavile ni numbula ng'afu, pwu akhambula umunu ola, “Golosya ekhevokho khyaho.” ");
INSERT INTO zgam_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Akhakhegolosya pwu u Yiisu akhampokha ekhevokho khyamwene. Avapitavwe vakhakhuma khunji vakhasongane na vatwa valonde anjela eya khubuda. ");
INSERT INTO zgam_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Pwu u Yiisu, na vakongi va mwene, vakhaluta khu nyanja, ululundamano lwa vanu avakhomile khu Galileya avange khu va Yuta. ");
INSERT INTO zgam_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Avange ukhukhuma khu Yerusalemu khu Idumaya khovolongolo eya Yolodani khuwipi ne Tiro ne Sidoni, lulundamano uluvakha, vwulupulikhe imbombo inchoikhonchivomba, vakhincha khumwene. ");
INSERT INTO zgam_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Pwu akhavavola avakongi va mwene ukhutesania uvwato uvwudebe ukhuta ululundamano vasite ukhuntinga. ");
INSERT INTO zgam_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ulwakhuva avapokhile vingi, khela munu uveale nu khungatanchawa ale nuvwunogwe amwabasye. ");
INSERT INTO zgam_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mwoni imepo imbivi upunchambwene, walekhugwa pasi nu khulela, valekhune hova, “Uve ule mwana va Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pwu alekhuvavola vasite ukhuvomba amanyikhihe. ");
INSERT INTO zgam_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Akhalota khu kyamba, akhavelanga vavo avanogilwe, vakhaluta khumwene. ");
INSERT INTO zgam_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Akhavakhala kumi na vaveli (akhavatambula vasukhiwa), ");
INSERT INTO zgam_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","vave paninie nu mwene avasukhage khulumbelela, Vave na akga khuhencha imepo. ");
INSERT INTO zgam_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Pwu akhavakhala kumi na vaveli: Simioni, uveampile elitawa lya Peteli, ");
INSERT INTO zgam_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobo unswambe Zebedayo, nu Yohani ulukholo va Yakobo, aveapevilwe elitawa lya Bonagesi, avo vale vana va Ngurumo, ");
INSERT INTO zgam_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Nu Ndeleya, Filipo, Batholomayo, Mathayo, Tomaso, Yakobo unswambe Alfayo, Thadayo, Simioni Mkananayo, ");
INSERT INTO zgam_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Nu Yuta Iskariote, yoywa alamwambuncha. ");
INSERT INTO zgam_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pwu akhaluta khukaya, nu lulundamano lwa vanu vakhincha paninie, vakhalemwa na khuhulya unkate. ");
INSERT INTO zgam_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Avakhekholo kya mwene vuvapolikhe elimenyu elyo, vakhaluta khu khomwibata, vakhata, “Ikhwalukha.” ");
INSERT INTO zgam_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Avasimbi vavovainchile ukhuhuma khu Yerusalemu vakhata, “Alenimepo incha Beelzebuli, “Nu, “Umbakha va mepo ikhencha imepo.” ");
INSERT INTO zgam_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yiisu akhavelanga khumwene nu khunchova navo khu fikhwani, “Ndakhehi u Setano ikhung'encha u Setano? ");
INSERT INTO zgam_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ingaveuvwutwa vungalekhehane uvwutwa uvwa savokheme. ");
INSERT INTO zgam_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ingave uvwunchenge vungalekhehane uvivunchenge uvwa savokheme. ");
INSERT INTO zgam_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ingave u Setano iva nekhemendu yoywa, sakheme, pwu iva afikhe khuvwusililo vwa mwene. ");
INSERT INTO zgam_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ulwakhuva asipale uvealeyomo yoywa iwesya ukhwingila mbunchenge uvwa munu unyamakha nu khuhencha ifinu fya mwene khetampinya unyamakha tasi, pwu ilandamaninga ifilimbunchenge. ");
INSERT INTO zgam_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Elweli nihovavola, imbivi nchoni incha vana va vanu yanchisyeleheliwa, paninie na ukhudakhela inchovonchova, ");
INSERT INTO zgam_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Yeyoni uveyakheva ikhodokha umepo umbalanche sahasyekheliwe, pwu iva ntula nongwa amanchuva goni.” ");
INSERT INTO zgam_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yiisu alenchovile ele ulwakhuva valekhunchova ukhuta, “Ale ni mepo imbivi.” ");
INSERT INTO zgam_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kisha mama yake na ndugu zake walikuja na kusimama nje. Wakamtuma mtu, kumwita. ");
INSERT INTO zgam_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ululundamano lalwa lwatamile pawipi nu mwene vakhambola, “Ujyuva vakho na valokhololwo vale hanji, vikhoholonda uve.” ");
INSERT INTO zgam_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Akhavanda akhata, “Ujyuva vango na avalokholo vango?” ");
INSERT INTO zgam_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Akhavalola vava vatamile nu kunchungula akhata, “Lola, ava vuvajyuva na valokholo lwango! ");
INSERT INTO zgam_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yeyone uveivomba ulugano lwa Nguluve, u munu uywa velokholo lwango, nu ng'ancha vango, nu jyuva vango.” ");
INSERT INTO zgam_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Pwu akhatengwa ukhumanyisya mu ndakhanji mu nyanja. Ululundamano ulwalundamine lukhanjongula, akhingela mu mbwato munyanja, nu hutama. Ululundamano lyoni lwale mundokanji mu nyanja. ");
INSERT INTO zgam_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Pwu akhavamanyisya imbombo nyingi khu fikhwani, akhanchova khuvene. ");
INSERT INTO zgam_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ukhuta, mupolikhenchage undemi alotile khuvyala. ");
INSERT INTO zgam_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Vwu ivyala, inchinge imbeyu ncha gwile mu njela, ifidege fikhincha fikhanchilya. ");
INSERT INTO zgam_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Imbeyu inchinge nchagwile mu lunalawe, bakho wlifu lyale lidebe, pwu jikhaniala, ulwakhuva elifu lyale lidebe. ");
INSERT INTO zgam_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pwu ulunchuva volwivala, nchikhaniala, ulwakhuva nchale bula milela, nchikhoma. ");
INSERT INTO zgam_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Imbeyu inchinge nchagwile mmatoni. Amatoni khakola sanchikhahopo isekha nchochoni. ");
INSERT INTO zgam_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Imbeyu inchinge nchagwile palifu elinonu, nchikhahopa isekhe vwu vunchikhula, inchinge nchakhopile thelathini nu khulutelela, inchinge sitini, inchinge mia.” ");
INSERT INTO zgam_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Pwu akhanchova, “Yeyoni unyambulukhutu incha khupulikha, apulekhage!” ");
INSERT INTO zgam_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yiisu vu alemwene, vavo vale pipi nu mwene, navala kumi na vavele vakhambuncha ukhukhongana ni vikhwani. ");
INSERT INTO zgam_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Akhanchova khuvene, “Umwe mpevilwe uvayelweli uvwa ludeva lwa Nguluve. Khu vavo vale honji khela khenu khuvene fihwani, ");
INSERT INTO zgam_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Pwu vovilola, lweli vilola, savikhokhe vona, vovipulekhe, vipulikha, savikhwaliwa, manya vakhavisyetukha pwu Unguluve akhale ikhovasyekhela.” ");
INSERT INTO zgam_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Pwu akhanchova khuvene, “Ukhuta samukhemanyile ekhekhwani ekhe? Pwu mukhweliwaga ifikhwani ifinge? ");
INSERT INTO zgam_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Unyakhovyala avyalile elimenyu. ");
INSERT INTO zgam_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Avange vovala avagwile munjela, bakho elimenyu lyavyaliwe. Vwu vapolikhe akhincha u Setano akhaletola elimenyu lelyo lyavyaliwe muvene. ");
INSERT INTO zgam_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Avange vovala vavovavyaliwe pakhyanyu pa lunalawe, avene voviholepulekha elimenyu, nambeve vikhupelela nulokhovokho. ");
INSERT INTO zgam_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Viva vovovle imilela mugati muvene pwu vikheyomelencha unsekhe unsupi vu lwikhwincha alogelo nu khugata nchiwa khu limenyu. Pwu vikhekho vencha. ");
INSERT INTO zgam_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Avange vovala avanyaliwe mumatoni vikholepulikha elumenyu. ");
INSERT INTO zgam_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pwu ukhugatanchiwa ne khelunga, uvosyovi uvwa fyome, nu vonogwe uvwa mbombo inchinge nchikhovingela elimenyu lilemwa ukhuhupa isekhe. ");
INSERT INTO zgam_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pwu khuvale vavo vavyaliwe mu ndifu elinonu. Vikholepulekha elimenyu nu khuleopelela vikhopa isekha: avange thelathini, avange sitini, na avange mia moja.” ");
INSERT INTO zgam_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yiisu akhavavola, “Vwa wigega ulumuli mbunchenge nukhuluvekha pasi pa khetundu, ama pasi pavogono? Pwu vukhulugega ulumuli nukhuluvekha pakhanya pa khetalati. ");
INSERT INTO zgam_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ulwa khuva khesikholi khyohyoni khekhyo khefikhime khekhyo sakhe khamanye khene, lesipali lelyo lefikhime lelyo salekhave pavuvalafu. ");
INSERT INTO zgam_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Avange pwale unyambulukhutu inchipulekha, apolekhage!” ");
INSERT INTO zgam_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Akhavavola muvinchage mikho na lelyo mupulekha, ulwakhuva ekhemwipimila khemulapimiliwa na yomwe nu khulutelela. ");
INSERT INTO zgam_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ulwa khuva uvealenakhyo, yikhwupela ekheluyelile, na yoywa ale vovole ukhukhuma khumwene yafitoliwa na fifyo alenafyo.” ");
INSERT INTO zgam_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Pwu akhata, “Uludeva lwa Nguluve lukhwanine nu munu uveavyalile embeyu mu ndifu. ");
INSERT INTO zgam_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Vwa agonelile pakhelo nu khusisimukha panavusikhu, pwu embeyu nchikhamela nu khukula, ndave salomanyile umuyekhomile. ");
INSERT INTO zgam_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ekhelunga khihomya embeyu, gitala amani; vwukhwincha uvuluva, pwu, nchikhonga embeyu inchidolwikhe. ");
INSERT INTO zgam_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Embeyu vuyekholile nu khuvefula pwu egega emundu, ulwa khuva misekhegha khubena.” ");
INSERT INTO zgam_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Pwu akhata, “Tuvukhwananinche uludeva lwa Nguluve ne khenu kheli, tuvunchanganule ne khekhwani khehi? ");
INSERT INTO zgam_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Vule nde mbegu eya haladali, yeyo yavyaliwe incha khelunga. ");
INSERT INTO zgam_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Na pakho yevyaliwe, yikhula nu khuva mbakha ukhulutelela embeyu nchoni, pwu yipasa isyamba imbakha, ifidege fya khukyanya finchenga uvufumba mu khenchimela.” ");
INSERT INTO zgam_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Khu fikhwani fingi amanyisye nu hunchova elimenyu khuvene, ndamumwa valekhumweliwa, ");
INSERT INTO zgam_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Sa anchove navo bila fikhwani. Ulwa khuva vu alemwene, akhavavola khela khenu avakhongi va mwene. ");
INSERT INTO zgam_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pa linchuva elyo, imisekhe gha lyakhemikhe, akhanchova khuvene, “Tuvukhe emwambo eyenge.” ");
INSERT INTO zgam_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Pwu vakhalulekha ululundamano, vakhantola u Yiisu, imisekhe egyo vualemumbwato. Uwato uvunge vukhava paninie. ");
INSERT INTO zgam_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Emepo enyakhuluguto, amagasi. ");
INSERT INTO zgam_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","U Yiisu ale pa shetri, agonelile. Vakhansisimula, vakhata, “Mmanyisi, savusaga ufye twifwa?” ");
INSERT INTO zgam_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Pwu akhasisimukha, akhayebencha emepo nu khuyevola enyanja, '“Yeve mie, nu lunonchehecho.” Emepo yekhelekhelwa, khuva mie. ");
INSERT INTO zgam_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pwu akhanchova khuvene, “Khehi mundwada? Mulevovole ulwidikho?” ");
INSERT INTO zgam_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Vakhava nuludwado ulwakha munumbula incha vene vakhenchofanya, “Veni oyo, ulwa khuva emepo ne nyanja fikhomwedekha?”. ");
INSERT INTO zgam_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Vakhincha uluvafu ulonge ulwa nyanja, huvu Gerasi ");
INSERT INTO zgam_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","U Yiisu vu ikhoma mu mbwato, umunu unya mepo imbivi akhincha khumwene vuikhomela khumapumba. ");
INSERT INTO zgam_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","U munu tamaga khumapumba. Asikholi aveawesinche ukhunsiga. Akhongiwe mara khingi ne minyololo. ");
INSERT INTO zgam_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Akhagedumula eminyololo asikholi uveale na makha agakhuntola. ");
INSERT INTO zgam_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pakhelo na pamusi vu alekhumapumba na hufyamba, alekhulela nu khwetema na mawe amakhali. ");
INSERT INTO zgam_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Vwu ambwene u Yiisu khuvutali, akhanyilela khumwene nu khungundama khumwene. ");
INSERT INTO zgam_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Akhovela khulimenyu elivakha, “Akhata vwinongwa ukhungakha kheli, u Yiisu, va Nswambe va Nguluve uve ale khukyanya? Nikhohodova khwa Nguluve uste, ukhungatancha.” ");
INSERT INTO zgam_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ulwa khuva ambolile, “Khuma khu munu oya, ve mepo imbivi.” ");
INSERT INTO zgam_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Umwene akhambuncha, “Elitawa lyakho veni?” Pwu akhanda akhata, “Elitawa lyango ne Legion, ulwakhuva tule vingi.” ");
INSERT INTO zgam_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Akhandela ukhudova ukhuta asite ukhung'elekha khuvutali. ");
INSERT INTO zgam_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Pale ni ngube nchindebelenchwa pakhyamba, ");
INSERT INTO zgam_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Pwu vakhadova, ukhuta, “Utusukhe khungube; twingile huchene.” ");
INSERT INTO zgam_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Pwu akhavedekha; imepo imbivi nchakhahoma nu khwingela mu ngube, pwu nchikhanyilela mu nyanja, nchale ingube elfu mbili nchicho nchaingile mu nyanja. ");
INSERT INTO zgam_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Na vavo vanchidemaga ingube vakhanyila khuhavavola khehyo pa khelunga. Pwu avanu vingi vakhehomya ukhuluta khwilola ekhehomile. ");
INSERT INTO zgam_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pwu vakhincha khwa Yiisu vakhambona umunu unyamepo- imbiviuveale ne jeshi — atamile pasi, afyalile, alenulukhala lunonu pwu vakhadwada. ");
INSERT INTO zgam_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Vavo valolile khekhyo khehomile khu munu uveakhale ni mwepo imbivi vakhambula ekhehomile khumwene na khu ngube. ");
INSERT INTO zgam_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Vovikhondova akhege mu khelunga kya vene. ");
INSERT INTO zgam_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Vwu ikhwingela mumbwato, u munu unyamepo mbivi akhadova alotage paninie nu mwene. ");
INSERT INTO zgam_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Akhasita ukhumwedekha, akhata, “Lutaga khuvunchenge vwakho na khuvanu vakho, ukhavavole ungaakhovombile Utwa, nu luhungu uuakhopile.” ");
INSERT INTO zgam_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Pwu akhaluta nu khutengula ukhupanga imbombo imbakha nchocho u Yiisu anchivombile khumwene khu Dekapoli, khela munu akhaswiga. ");
INSERT INTO zgam_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","U Yiisu vualowikhe emwambo eyenge, mu mbwato, lulundamano lukhalundamano au hunchungutela, vu alepalukhanchi pa nyanja. ");
INSERT INTO zgam_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Pwu undongonchi yomo va sinsgogi, atambuliwawa Yailo, akhinche, vu ambwene akhagwa mumalunde ga Yiisu. ");
INSERT INTO zgam_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Akhansima akhata, “Umwana vango udebe alepakhufwa. Nikhokhodova, winche umbekhele ifivokho pamwene, apate ukhupona.” ");
INSERT INTO zgam_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Pwu akhaluta nave, nu lulundamano lukhankonga nu khunchungutila. ");
INSERT INTO zgam_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pale nu ndlaa uvegwakhumaga unkisa emiakha kumi na miwili. Agatanchiwe, nu khuyaveliwa na vingi akhominche khela khenu khekhyo alenakhyo. ");
INSERT INTO zgam_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Saapate uvwavule, pwu akhendelela ukhuva ne khali mbivi. Akhapulikha elimenyu ly Yiisu. ");
INSERT INTO zgam_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Pwu akhincha khunsana khwa Yiisu vu ingenda mu lulundamano, akhibata eligwanda lya mwene. ");
INSERT INTO zgam_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ulwa khuva anchovile, “Ingave ningabate eligwanda lya mwene, niva neponile.” ");
INSERT INTO zgam_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Voibite, unkisa gukhelekhe lwa ukhuhuma, pwu akhepulekha mu mbele ukhuta aponile mbugatanchiwa wa mwene. ");
INSERT INTO zgam_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pwu u Yiisu akhalumanya ukhuta amakha gapungwikhe. Akhasyetukha khunu na khunu ndulundamano lwa vanu akhavoncha, “Veni uveanyibite eligwanda lyango?” ");
INSERT INTO zgam_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Avankongi va mwene vakhata, “Wilola ululundamano lukhunchungulile, nuve wita, “Veni uveakhwibite?'” ");
INSERT INTO zgam_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","U Yiisu akhalola khunu na khunu ukhulola yoywa amwibite. ");
INSERT INTO zgam_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Undala vualumanyile ekhevombikhe khumwene, akhadwada nu khutetema. Akhincha nu khugwa pasi pamwene nu khumbula elweli yoni. ");
INSERT INTO zgam_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Akhata khumwene, “Ulwidikho lwakho lakhopokhile. Lutaga nu lunonchehecho apone ekhetamu khyaho.” ");
INSERT INTO zgam_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Vwu inchova, avange avanu vakhincha ukhuhuma khu ndongonchi va Sinagogi, valekhuta, “Umwalevo afyile. Khehi vukhugatancha umanyisi?” ");
INSERT INTO zgam_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pwu u Yiisu vuapulikhe khekhyo khinchoviwa, akhambula undongonchi va Sinagogi, “Osite ukhudwada. Wedekhe.” ");
INSERT INTO zgam_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Sahamwedekha yeyoni ukhulongonchana nave, akhava nu Peteli, Yakobo nu Yohani, alokhololwe va Yakobo. ");
INSERT INTO zgam_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Vakhincha mumbonchenge uvwa ndongonchi va Sinagogi, vope akhavono vilela. ");
INSERT INTO zgam_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Vuingile mbunchenge, akhavavola, “Kheli msosovile, kheli mwilela? Umwana safwile agonelile.” ");
INSERT INTO zgam_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Vakhang'eha, umwene, akhavahomya voni khunji, akhantola udada va mwana nu vanine navavo vakhele nu mwene, akhingela umwalemo umwana. ");
INSERT INTO zgam_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Akhatetola ekhevoho kya mwana akhata, “Talitha koum, “khuhuta, “Mwana ndebe, nikhohovola, sisimukha.” ");
INSERT INTO zgam_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Umwana akhasisismukha nu khugenda (ulwa khuva ale ne miakha kumi na mbili). Pwu vakhava vanu va khudega. ");
INSERT INTO zgam_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Akhava lagela ukhuta asikholi ovinogiwa ukhulemanya elevombikhe. Akhavavola vampe umwana ekyakhulya. ");
INSERT INTO zgam_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pwu akhahege ukhuluta khujini gwa miave, avakhongi va mwene vakhenkonga. ");
INSERT INTO zgam_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Vuyefihe e Sabato, akhatengula ukhumanyisya mu sinagogi. Avanu vingi vakhampulekhe nu khudega. Vakhata, “Akavile ndahu ulumanyisyo alo?” Luhala lukhi ulwapevilwe?” Ivomba ndekhehi aga khu monokhoga mwene?” ");
INSERT INTO zgam_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Oyo si ve ola u Selemala, nswambe va Mariamu na lokhololwe lwa va Yakobo, Yose, Yuta nu Simioni? Na vakhenchavevitama pakhapa nufwe?” Yavakhovoswe nu Yiisu. ");
INSERT INTO zgam_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","U Yiisu akhavavola, “Unyamalagosi dwadiwa, apange mjini gwa mwene na valokhololwe ava mbunchenge vwa mwene.” ");
INSERT INTO zgam_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Pwu sakhavomba inchakhudeega apo, akhavavekhela ifivokho avatamu vadebe vakhepona. ");
INSERT INTO zgam_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Akhaswiga ulwa khuva savalekhwedekhe. Pwu akhavigendela ifijiji fya pawipi nu khumanyisya. ");
INSERT INTO zgam_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Akhavelanga avakongi kumi ne mbili akhatengula ukhuvasukha vavele vavele. Akhavapa ululagelo khu mepo imbivi, ");
INSERT INTO zgam_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nu khuvalagela wasite ukhugega ekhe nu khyokhyoni vuvilula vagegage ingoma njene. Vasite ukhugega unkate, umpakho ni ndalama mufipakho; ");
INSERT INTO zgam_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Pwu vafyale ifikato, vasite ukhuva na magwanda gavele. ");
INSERT INTO zgam_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Akhavavola, “Uvenjenge vwuwoni umuyakheva mukhwingela, mtamage apo mpakha vu mwikhega. ");
INSERT INTO zgam_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nu njini gyogyoni gugwa sakhuhovupilela ama nkhuvapulekhencha, mukhegege khuvene, mwekhuhune ulundukhulu lwa mmalunde genyo, kheve kheme nyekhelo khuvene.” ");
INSERT INTO zgam_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Na vene vakhaluta nu khulumbelela avanu ukhuuta nu ukhunchilekha imbivi incha vene. ");
INSERT INTO zgam_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Vakhavaswema imepo imbivi nu khuvabakha imono avatamu vakhapona. ");
INSERT INTO zgam_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Untwa u Herode vuapolikhe ago, ulwa khuva elitawa lya Yiisu levile lemanyekhikhe. Avange vakhata, “Yohani unyalyoncho anchokhile, amakhe ni fikhwani fivomba imbombo mu mwene.” ");
INSERT INTO zgam_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Avange vakhata, “Oyo ve Eliya, “Nu avange vakhata, “Oyo ve nyamalago, alepaninie na vanyamalago avakhetale.” ");
INSERT INTO zgam_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pwu u Herode vu apulikhe aga akhata, “Yohani, yoywa nagedile untwe anchokhile.” ");
INSERT INTO zgam_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ulwa khuva Herode yoywa alagile u Yohani ibatwe nu khukungwa khwa Herodia (udala va mbakhave va Filipo) ulwa khuva umene antolile ukhuva idala. ");
INSERT INTO zgam_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ulwa khuva u Yohani ambolile u Herode, “Lu vivi ukhuntola udala va mbakhavo.” ");
INSERT INTO zgam_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Pwu u Herode akhatengula ukhukalalela alekhulonda ukhumbuda, akhalemwa, ");
INSERT INTO zgam_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","U Herode alekhundwadwa u Yohani; alomanyile ukhuta va ye lweli munu mbalanche, pwu akhandekhe. Vwu ipikhompole khencha akhavanulususuvalo, akhahovoha ukhumpole hencha. ");
INSERT INTO zgam_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Vwu gufikhe unsekhe vwu lekhegelile elinchuva lya khololiwa u Herode ahavandalela avakhongi va mwene, avasikhali, na valongonchi va Galileya. ");
INSERT INTO zgam_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Pwu umaleve va Herodia akhingela pakhonema, akhang'ovosya u Herode na vagenji avalepakhulya lyakhemihe pwu u herodeakhambula umwaleve, “Udove kyokyoni ikhevwunongwa une yanikhuhupa.” ");
INSERT INTO zgam_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Akhadyega ukhuta, khyokyoni khekyo yavudova, yanikhuhupa, ndageve nusu ya indeva lwango.” ");
INSERT INTO zgam_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Akhahoma khunji akhavoncha khwa vanina, “Nedove ekhehi?” Akhata, “Untwe ugwa Yohani.” ");
INSERT INTO zgam_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Unsekhe gugwa akhingila khwa nkuludeva akhatengula ukhunchova, “Ninogwa umemu sakhani, untwe gwa Yohani.” ");
INSERT INTO zgam_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Unkuludeva akhasususvala, ulwakhuva aedyegile pavageni, akhalemwa nkhubelela ekheadovile. ");
INSERT INTO zgam_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Pwu unkuludeva akahasuha avasikhali va mwene akhavalagela ukhuluta ukhugegela umtwe gwa Yohani. Pwu usikhali akhalota khwigeda untwe mumbokongwa. ");
INSERT INTO zgam_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Akhagega untwe gwa Yohani mu sakhani akhampa umwana, umwana akhampa uvanina. ");
INSERT INTO zgam_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Avakhongi va mwene vuvapulikhe ago, vakhaluta khuhogotola ufimba gwa mwene vakhaluta khusyila hulipumba. ");
INSERT INTO zgam_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Avasukhiwa vakhalundamano popaninie khuvolongolo khwa Yiisu, vakhambula goni agavavombile nu khuvamanyisya. ");
INSERT INTO zgam_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Pwu akhavavola, “Mwinchange pavotitu tugatalukhe padebe.” Avanu vingi valekhwincha nu khuhega savakhava nu unsekhe ugwa khulavukha. ");
INSERT INTO zgam_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Pwu vakhatoga mu mbwato vakhaluta pavutitu vakhava vene. ");
INSERT INTO zgam_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Vakhavavona vuvikhaga, vakhavamanya pupaninie vakhanyila ulwamalonde vakhavatalela ukhunchifikha. ");
INSERT INTO zgam_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Vuvafikhe khu mbwani, akhavavona ava lulundamano akhavakolela ekhesa, ulwa khuva vale ndi ng'osi imbula ndoleli. Akhatengula ukhuvamanyisya imbombo inyingi. ");
INSERT INTO zgam_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Emisekhe vugelulile, avakhongi vakhakonga vakhata, “Apa pale pavutitu nu usekhe gulutile. ");
INSERT INTO zgam_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Welage valute khunji ni vijiji vakhagule ekyakhulya.” ");
INSERT INTO zgam_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pwu akhavanda akhata, “Muvape umwe ekyakhulya.” Vakhambola, “Tuwesye ukhuluta khwigula imikate igya dinari mia mbili nu khuvapa valye?” ");
INSERT INTO zgam_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Akhavavola, “Mle nemikate gelengi? Luta mukhalole.” Vovapatile vakhambola, “Emikate gekhano ni somba ivele.” ");
INSERT INTO zgam_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Akhavalagela avanu vatame mu fipuga mu manyasi amigu. ");
INSERT INTO zgam_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Vakhavatamekha mu fipuga; mu fipuga fya mamia khu hamsini. ");
INSERT INTO zgam_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pwu akhatola emikhate gekhano ni somba ivele, pwu akhalolakhukyanya akhagesaya, pwu akhavapa avakongi vavekhe mbulongolo pa lulundamano. Pwu akhagava isomba ivele khu vanu voni. ");
INSERT INTO zgam_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Vakhalya voni vakhakwila. ");
INSERT INTO zgam_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Vakhalundania imikate emimenyule egesigile, vikhadega ifitondu kumi na mbili, ni somba inchi menyuliwe. ");
INSERT INTO zgam_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Vale avagosi elfu tano avalile emikate. ");
INSERT INTO zgam_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pwu akhavavola ukhuta vatoge mu mbwato valote khuvunge, vakhaluta khuabethsaida, vu ikhelaga nu vanya lulundamano. ");
INSERT INTO zgam_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","avuvakhegile, akhaluta khukyomba khudova. ");
INSERT INTO zgam_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","vuyevile lyakhemile, uwato vwu vulepagati mu nyanja, umwene ale mwene khumwambo. ");
INSERT INTO zgam_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Akhavavova vovigatanchiwa mu mbwato ulwa khuva imepo nchilikhuvasiga, vuvulepakhwikya akhavalotela, alekhugenda nkyanya munyanja, akhonogwa ukhulutaniche. ");
INSERT INTO zgam_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pwu vuvambwene igenda nkyanya mu magasi, vakhava nuludwadwa vakhata pamo misyokha pwu vakhaywega. ");
INSERT INTO zgam_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ulwa khuva vambwene vakhava nululundamano. Pwu akhanchova akhavavola, “Muve vakhangafu! Nene! Msite ukhudwada.” ");
INSERT INTO zgam_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Akhingela mu mbwaro, imepo yekhelekhelwa unkhuluguto, pwu vakhadega lweli. ");
INSERT INTO zgam_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Pwu vakhava saveliwe elimenyu lya mikate. Ulwa khuva inyala nchavene nchale ndebe. ");
INSERT INTO zgam_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Vovalowikhe khumwambo, vakhafikha ekhelunga ekhya Genesareti pwu uwato vakhema. ");
INSERT INTO zgam_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Vovakhomile khunji khuwato, pwu vakhamanya. ");
INSERT INTO zgam_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Vakhanyila khulumbelela mu khelunga vakhatengula ukhuvagega avatamu mu fisanja, khela vuvapulikhe ukhuta ikhwincha. ");
INSERT INTO zgam_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Popone opoaingile mu vijiji, ana mijini, amamukhelunga vakhavavekha avatamu upovigonchekhecha, vakhadova edekhe ukhwibata eligwanda lya mwene. Voni vavo vamwibite vakhapona. ");
INSERT INTO zgam_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Avalongonchi ne avasimbi vavo vakhomile khu Yerusalemu valondamine nu khunchungutela umwene. ");
INSERT INTO zgam_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Vakhavavona avakhongi va mwene vilya imikate ne fikokho khetakalava. ");
INSERT INTO zgam_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Avalongonchi na Vayahudi voni savilya vikhalava vononu; vikhwibatelela inyikho incha vagogolo. ");
INSERT INTO zgam_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Avalongonchi vovayile ukhuhuma ukhuvigoncha, savilya vu savogile. Khulenindagelo inchinge inchovikhonchikonga, ukhusukha ifinywelo, isefulila, ifyombo ifya shaba niifigodo ifivitamela pakhulya.) ");
INSERT INTO zgam_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Avalongonchi ne vasimbi vakhambuncha u Yiisu, “Khehi avakhongi vakho samitame ukhukongana ni nyikho incha vatanchi, ulwa khuva vilya imikate khetakalava amavokho?” ");
INSERT INTO zgam_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Umwene akhavavola, “Unyamalago Yesaya anchovile vononu khulyomwe asimbile, 'Avanu ava vikhunyedehka khu milomo, inumbula incha vene chilikhutali nune. ");
INSERT INTO zgam_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Vikhombombela inekhelo injalubedo vimanyisya indagelo incha vanu ndi finchago fya vane.' ");
INSERT INTO zgam_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Munchilekhile indagelo incha Nguluve nu hwibatelela inyikho imepo incha vanu.” ");
INSERT INTO zgam_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Pwu akhanchova khuvene, “Mlubelile ululagelo ulwa Nguluve ili mlolele inyikho nchenyo! ");
INSERT INTO zgam_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ulwa khuva u Mose atile, “Umwedekhe u Dada vakho nu Jyova vakho, 'Yoywa inchova amavivi khwa Dadaye nu khwavanina lwa yelweli ifwa.' ");
INSERT INTO zgam_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ulwa khuva mwita, 'Ingave umunu inchova khwa dadaye nu vanina, “Ulutangilo lwolwoni lolwo mukhale mwikhava ukhuhuma khulyone lwiva khebana khu Hekalu,'” (elyo khuhuta atekhominche Unguluve') ");
INSERT INTO zgam_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Pwu sikhondekhe ukhuvomba embombo yeyonikhwa deda ama uvanina. ");
INSERT INTO zgam_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mukholovekhe ululagelo ulwa Nguluve ukhuta sakhenu khu nyikho nchenyo. Ni mbombo inchopingi mukhonchivomba.” ");
INSERT INTO zgam_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Akhakilivukhela ukhuvelanga avalulundamano nu khuvavola, “Mumolekhenche one, mwe voni, munyeliwe. ");
INSERT INTO zgam_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Khesiholi kyokyoni ukhuhuma khunchi khu munu khekyo khiwesya ukhundamya amunu ekhihwingela khumwene. Khekhonguma omunu khyohikhondamya. ");
INSERT INTO zgam_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Nchingakhencha: unsitali ugu, “Ingave omunu yoywa avenchaga ale ni mbulukhutu incha khupulikha, apulekhage” Gusimoli mu kalata incha khatale). ");
INSERT INTO zgam_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","U Yiisu akhavalekha avalulundamano nu khwingela mu mbunchenge, avakhongi va mwene vakhambuncha ukhukongana ne khehwani khela. ");
INSERT INTO zgam_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yiisu akhata, “Na nyomwe samweliwe? Samwilola ukhuta khyokyoni ni khekyo khihomwingila omunu sakhiwesya ukhundamya, ");
INSERT INTO zgam_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ulwa khuva sakhehelote mu numbula eya mwene, khihwingela mulitumbu lya mwene pwu kheluta khu ya vele.” Khu nchovele eye u Yiisu akhafivalancha ifyakhulya fyoni. ");
INSERT INTO zgam_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Akhanchova, “Khehyo khihoma umunu khyohikhondamya. ");
INSERT INTO zgam_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ulwa khuva khihoma mu munu, khunchi eya numbula, khilomana na masage amavivi, uvuligu, uvulyasi, uvubudi, ");
INSERT INTO zgam_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Uvumalaya, uvunogwe uvuvivi, uvuvivi, uvusyovi, ukhuligupa, ilweginio, uvokhonyofu. ");
INSERT INTO zgam_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Amavivi aga goni gikho mugati, gugagyo gikhondamya omunu.” ");
INSERT INTO zgam_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Akhema ukhuhuma pala nu khuhega ukhuluta khu Tiro ne Sidoni. Akhingela mugati sakhanogwa omunu uveavinchaga alomanye ukhuta aleapo, yekhalemehan ukhumfikha. ");
INSERT INTO zgam_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Pwu udala, unyamwana unyamepo imbivi, akhapulekha elimenyu lya mwene, akhincha, akhagwa pa malunde ga mwene. ");
INSERT INTO zgam_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Udala uywa ale Myunani, uva khevumbuho kya Kifoniki. Akhansima ukhuta anchisweme imepo imbivi ukhuhuma khu mwaleve. ");
INSERT INTO zgam_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yiisu akhambula udala, “Valekhe avana valye tasi, ulwa khuva sio lunonu ukhutola unkate gwa vana nu khulakhela imbwa.” ");
INSERT INTO zgam_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pwu udala akhanda ukhuta, “Lweli Ntwa, na nchimbwa pasi pa mwes yayilya amasigalelo ga khyahulya hya vana.” ");
INSERT INTO zgam_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Akhambola, “Ulwa khuva unchovile evwo, ulutage nuvudekhedekhe. Imepo nchindekhisye umwalevo.” ");
INSERT INTO zgam_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Udala akhavuya khuvunchenge uvwa mwene ambone umwaleve agonile pa khetalati, imepo nchindekhisye. ");
INSERT INTO zgam_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yiisu akhahuma khu Tiro akhagengela khu Sidoni akhaloncha khunyanja eya Galileya ulunyikha ulwa Dikapolisi. ");
INSERT INTO zgam_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Pwu vakhandetela omunu uveanchivile uve ilemwa ukhonchova vononu, vakhansima u Yiisu avekhe ifivokho fya mwene pa mwene. ");
INSERT INTO zgam_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Akhang'omya khunchi ya lulundamano khu lufikho, pwu akhavekhe ifikonche mu mbulukhutu nchamwene, vwu abekhile amati, akhibata ululimi lwa mwene. ");
INSERT INTO zgam_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Akhalola khule yanya, akhakeha nu khumbula, “Efata, “Khuhuta “Dendukha!” ");
INSERT INTO zgam_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Pwu unsekhe gugwa imbulukhutu nchikha dendukha, na khwhyo khehansigaga ululimi khehanangeha alekhunchova. ");
INSERT INTO zgam_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Pwu akhavalagela vasite ukhumbula omunu uveavenchaga. Vwu ikhovalagela elyo, pwu vale khupanga imbombo incho khuvingi. ");
INSERT INTO zgam_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Va yelweli vakhadega nu khuta, “Avombile khela khenu khenonu. Nu khuvavekha avanchivile ukhupulekha, na avabubu ukhunchova.” ");
INSERT INTO zgam_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mu manchuva ago, khwale nu lulundamano uluvakha, ulwale vovole ekhyahulya. ");
INSERT INTO zgam_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Yiisu akhavelanga avakhongi va mwene nu khuvavula, “Nikholokolela ekhesa ululundamano ulu, vandelile ukhuva nune amanchuva gadatu na valevovole ekhyahulya. ");
INSERT INTO zgam_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ningavavule vagodokhe mumbunchenge uvwa vene khetalya viwesya ukhunchiliha mu njela ne njala. Avange vakhomile khuvutali.” ");
INSERT INTO zgam_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Avakhongi va mwene vakhamwanda, “Twikhavandahu emikate egya khuvigusya avanu ava apasitakhenu?” ");
INSERT INTO zgam_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Akhavavuncha, “Mle ni vimenyu vilengi ifya mikate?” Vakhata, “Saba.” ");
INSERT INTO zgam_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Akhalulagela ululundamano lutame pasi. Akhatola emikati saba, akhansana Unguluve, nu khugemenyula. Akhava pa avakhongi va mwene vavekhe mu mbulongolo, avene vakhagevekha mbulongolo lwa lulundamano. ");
INSERT INTO zgam_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Vale ni somba indebe, vu esayile akhavalagela avakhongi va mwene vavagavele n anchope. ");
INSERT INTO zgam_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Valile vakhakwilanila. Pwu vakhalundania ifimenyu ifisigile, ifitundu ifivakha saba. ");
INSERT INTO zgam_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Avanu vale elfu nne. Pwu akhavalekha vavuyage. ");
INSERT INTO zgam_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Pwu akhingela mu mbwato na vakhongi va mwene, pwu vakhaluta ulunyikha ulwa Dalmanuta. ");
INSERT INTO zgam_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pwu avalongonchi vakhehuma khunchi nu khutengula ukhukanikhana nu mwene. Valekhunogwa avape ifikhwani ifikhomile khukyanya, valekhugela. ");
INSERT INTO zgam_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Akhenchofanja mu numbula eya mwene akhata, “Kheli ekhepapo ekhe khilonda ifikhwani? Nekhovavula uvulweli umwe, khesikhuli ekhehwani ekheyakheva khihumela khuhepapo ekhe.” ");
INSERT INTO zgam_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Pwu akhavalekhe, akhingela mu mbwato, akhahega ukhuluta emwambo eyenge. ");
INSERT INTO zgam_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Unsekhe ugwa avakhongi va mwene vasamilwe ukhugega emikati. vale vuvule emikate, vale ne khemenyu khemu mu mbwato. ");
INSERT INTO zgam_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Akhavavunga ukhuta, “Muvinchage mukho nu mwilolele nu uvuvivi uvwa valongonchi nu uvuvivi uvwa Herode. ");
INSERT INTO zgam_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Avakhongi vahenchofyanja vavo, “Ulwa khuva tulevuvule emukate.” ");
INSERT INTO zgam_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","U Yiisu akhalemanya ele, khuvavula, “Khehi mu khenchofanya ukhuta mule vuvule emikate? Bado samulomanyile? Samukhweliwa? Inumbula nchenyo nchivile nyebepe? ");
INSERT INTO zgam_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mle na mikho, samwilola? Mle ni mbulukhutu, samupolekha? Samukumbukha? ");
INSERT INTO zgam_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Vonegavinie emikate gekhano khuvanu elfu ikhano, mwatolile ifitundu filengi ifidegile ifimenyu ifyamikate?” Vakhamwanda, “Kumi na fivele.” ");
INSERT INTO zgam_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ulwanagavinie emikate saba khu vanu elfu nne, mwatolile ifitundu filengi?” ");
INSERT INTO zgam_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Vakhata, “Saba.” Akhavavula, “Samukhweliwa?” ");
INSERT INTO zgam_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Vakhincha khu Bethsaida. Avanu vavo vagegile khwa umunu uvesisola vakhansima u Yiisu amwibate. ");
INSERT INTO zgam_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yiisu akhamwibata umunu uvesilola, nu khundongolela khunchi khuhejiji. Vuabekhile amati pa mikho ga mwene nu khugolosya ifivokho fya mwene khu mwene, akhambuncha, “Vukhohevona khyohyoni?” ");
INSERT INTO zgam_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Akhalola khu kyanya nu khuta, “Nikhuva vona avanu nde mibekhe egigenda.” ");
INSERT INTO zgam_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Pwu akhagolosya amavokho ga mwene mu mikho ga mwene, omunu ola akhafungula amikho ga mwene, akhalola akhange, akhavona khela khenu khenonu. ");
INSERT INTO zgam_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yiisu akhandekha alote khumwene nu khumbula, “Usite ukhwingela mjini.” ");
INSERT INTO zgam_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yiisu akhahega navakhongi vamwene ukhuluta khu Kaisaria eya Filipi. Vuvalemunjela akhavavuncha avakhongi, “Avanu vita une nene veni?” ");
INSERT INTO zgam_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Vakhamwanda vakhata, “Yohani unyalwoncho. Avange vita vee, “Eliya' avange, 'Vita ulenyamalago.” ");
INSERT INTO zgam_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Akhavavunda, “Umwe mwita one nene veni?” Peteli akhambula, “Uve ve Kristi.” ");
INSERT INTO zgam_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yiisu akhavavunga ukhuta vasite ukhumbula omunu imbombo incha mwene. ");
INSERT INTO zgam_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Pwu akhatengula ukhuvamanyisya ukhuta unswambe va Adamu yigatanchiwa khu mbombo inyingi, yibeliwa na valongonchi, na vatekhenchi avavaha, na avasimbi, na avanyalwidikho, vugasilile amanchuva gadatu alanchukha. ");
INSERT INTO zgam_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Aganchovile aga mu mbuvalafu. Pwu Peteli akhantola palukhanji akhatengula ukhumbencha. ");
INSERT INTO zgam_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","U Yiisu akhasyetukha khuhuvalola vakhongi va mwene pwu akhambencha u Peteli akhata, “Luta khunsana Setano! Sawilola imbombo incha Nguluve, wilola imbombo incha vanu.” ");
INSERT INTO zgam_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Pwu akhavelanga avalulundamano na vakhongi va mwene, nu khuvalola, “Inave khule munu inogwa ukhung'onga, ebele yoywa, atole ekhendamingani kya mwene, nu khung'onga. ");
INSERT INTO zgam_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ulwa khuva yeyoni uveinogwa ukhuvupokha uvwumi uvwa nwene alavuyancha, na yeyo ni uveyakheva ikhovoyancha uvwumi uvwa mwene khwa ajili yango na khulimenyu, alavopokha. ");
INSERT INTO zgam_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Yikhontanga khehi omunu, ukhukava ekhelunga kyoni, nu khukava ekhesara eya vwumi uwamwene? ");
INSERT INTO zgam_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Omunu iwesye ukhuhomia khehi badala eya vwumi uvwa mwene? ");
INSERT INTO zgam_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yeyoni uveikhombonela isoni na mamenyu gangu mu khepapo ekhe ekya valigu, ne khepapo ekhya vanya mbivi, unswambe va Adamu yikhombolela isoni yakheva ikhwincha khu ludeva ulwa Dadaye nukhuvasukhiwa avavalanche. ");
INSERT INTO zgam_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Aganchovile khuvene, “Lweli ni nchova khulyomwe, avange venyo khule vanu avemile apa savalafwa mpakha valuvone uludeva lwa Ngluve vulwikhwincha na makha.” ");
INSERT INTO zgam_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Vu galuti amanchuva sita, Yiisu akhavatola Peteli, Yakobo nu Yohani ukhuluta navo khukyamba, vene. Pwu akhatengula ukhuhambukha pa vene. ");
INSERT INTO zgam_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Emienda gya mwene gekhatengula ukhungala, gekhava mivalafu, uvuvalafu uvulotelile mu khelunga. ");
INSERT INTO zgam_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Pwu u Eliya nu Mose vakhahomela mu mbolongolo mu vene, valekhonchova nu Yiisu. ");
INSERT INTO zgam_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peteli akhanda akhambula u Yiisu, “Mmanyisi, luvile lunonu ufye ukhuva apa, pwu tunchenge ameve gadatu, lemoleve lyakho, lemo leve lya Mose nelenge leve lya Eliya.” ");
INSERT INTO zgam_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Ulwa khuva sakhemanye ekyakhunchova, vakhadwada fincho.) ");
INSERT INTO zgam_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Elifunde likhehumela nu khuvagubikha. Pwu elimenyu likhahuma mu mafunde likhata, “Oya ve nswambango ugane, mupulekhenchange umwene.” ");
INSERT INTO zgam_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Vwu vipilola, savakhambona yeyone uveale paninie navene, alepo u Yiisu mwene. ");
INSERT INTO zgam_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Vuvikhwiha ukhuhuma khukyamba, akhavalagela vasite ukhumpangila omunu gago valolile, hadi unswambe va Adamu alavaicnhukha ukhuhuma khuvufwe. ");
INSERT INTO zgam_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Pwu vakhanchingahencha imbombo vavo vene. Pwu vakhenchofanja ukhuta khuhuta kheli “Ukhunchula ukhuhuma khuvufwe” ");
INSERT INTO zgam_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Vakhambunche u Yiisu, “Kheli avasimbi vavita ikhwincha tasi u Eliya?” ");
INSERT INTO zgam_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Akhavavola, “Lweli u Eliya alincha tasi khwipokha ifinu fyoni. Kheli yesimbiwe unswambe va Adamu alagatanchiwa nu khusuliwa? ");
INSERT INTO zgam_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Leno ninchova khulyomwe u Eliya ainchile, vakhambombela umuveganelile, ndu elimenyu linchova.” ");
INSERT INTO zgam_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Vuvavuyile khuvakhongi, vakhevona ululundamano ludegile na Masadukayo valekhukanihane navo. ");
INSERT INTO zgam_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Vu vambwene, elipuga lyoni lekhadega nu khuluta khuhomponia. ");
INSERT INTO zgam_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Akhavavoncha avakhongi va mwene, “Mkanekhana navo khuhekhi?” ");
INSERT INTO zgam_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yomo mu khepuga akhamwanda, “Mmanyisi, nekhagegile umwana vango khulyove; aleni mepo imbivi inchikhosiga ukhonchova, ");
INSERT INTO zgam_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","nchikhopelela ukhutetema nu khugwisya pasi, epofu yikhomaga mundomo nu khuyeledula amino nu khuncichima. Nekhavadova avakhongi vakho vanchikhomie imepo, vakhalemwa. ");
INSERT INTO zgam_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Akhavanda, “Khepago ekhesakhihwedekha, nitamoga numwe hadi ndeli? Nitolelanila numwe hadi ndali? Mugege khulyone.” ");
INSERT INTO zgam_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Vakhagega umwana vamwene. Emepo imbivi vunchimbwene u Yiisu, pwu nchikhapelela ukhutetema. Undemi akhagwa pasi nu khuhumia epofu mundomo. ");
INSERT INTO zgam_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yiisu akhambuncha u Dadaye, “Avile ne khetamu ekhe ukhuhuma ndeli?” Dadaye akhata, “Ukhuhuma vu idebe. ");
INSERT INTO zgam_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Pavunge alekhugwila mu mwoto apange, mu magasi, nu khugela ukhunjancha. Inave vwuwesye ukhuvomba khyokhyoni tokholele ekhesa ututange.” ");
INSERT INTO zgam_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yiisu akhambula, “Ingave ule tayari? Khela khenu khiwe sekhana khu yeyoni unyalwidikho.” ");
INSERT INTO zgam_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Pwu u Dada va mwana akhalela akhata, “Nikhwedekha! Unange ukhusikhwigekha khwango.” ");
INSERT INTO zgam_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","U Yiisu vuawene elipuga linyilela khuvene, akhalagela khu mepo imbivi akhata, “Uve mepo venchivanchi, nikhphogela indekhe, usite ukhwingila khumwene khange.” ");
INSERT INTO zgam_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Akhalela khumakha nu khugatancha umwana pwu imepo akhahuma. Umwana akhavonekha ukhuta afwile, vingi vakhata, “Afwile,” ");
INSERT INTO zgam_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pwu u Yiisu akhantola ne khevokho akhamwinula, omwana akhema. ");
INSERT INTO zgam_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","U Yiisu vu ingile mugati, avakhongi va mwene vakhambuncha khuvutitu, “Kheli tukhalemilwe ukhungumia?” ");
INSERT INTO zgam_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Akhavavola, “Siwesya ukhuhuma ikhone nyesayo.” ");
INSERT INTO zgam_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Vakhahega pala nu khugendela khu Galileya. Sakhanogwa omunu yeyone alumanye upuvalepo, Ulwa khuva alekhuvamanyisya avakhongi va mwene. ");
INSERT INTO zgam_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Akhavavola, “Unswambe va Adamu yikhelehwa mu mavokho ga vanu, pwu vikhombuda, vuafwile, vugalutile amanchuva gatatu alanchokha.” ");
INSERT INTO zgam_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pwu savakheliwa ekhinchova, vakhadwada ukhumbuncha. ");
INSERT INTO zgam_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Vuvafikhe Karperinaumu. Vu ale mumbunchenge skhavavuncha, “Mukhenchofanchaga kheli mu njela?” ");
INSERT INTO zgam_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pwu vakhanchiga miye. Ulwa khuva vale khukanikhana mu njela ukhuta veni yoywa imbakha huvoni. ");
INSERT INTO zgam_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Akhatama pasi akhavelanga kumi na vavele paninie, akhanchova navo, “Ingave yeyoni ilonde ukhuva va mbulongolo, edekhe ukhuva va munsana na ntangeli va voni.” ");
INSERT INTO zgam_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Akhantola omwana udebe akhambekha pagati pavene. Akhampemba mumavokho, akhata, ");
INSERT INTO zgam_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Yeyoni uveikhomwopelela umwana ndoyu mu litawa lyango, iva anyupelile one, ingave omunu anyupelile one, sanyupelile one nemwene nu uveansukhile.” ");
INSERT INTO zgam_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohani akhambula, “Mmanyisi tukhambwene omunu ikhomia imepo khu litawa lyakho tukhabencha, ulwakhova sikhongana nu fwe.” ");
INSERT INTO zgam_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Pwu u Yiisu akhata, “Msitage ukhuvasiga, ulwa khuva asikhuli omunu uveiwesya ukhovombe imbombo imbkha khu litawa lyango, yoywa iwesya ukhunchova elimenyu elivivi khulyone. ");
INSERT INTO zgam_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yeyoni yoywa salenufwe, alepaninie nufwe. ");
INSERT INTO zgam_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yeyoni uveyakheva ikhohopa ekhekombe kya magasi aga khunywa ulwakhuva ule nu Kristi, lweli ni khovavola, salayancha ulusayo lwamwene. ");
INSERT INTO zgam_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yeyoni uveikhovapenja avadebe avikhonyedekha one, lukhale lwiva lunonu khumwene ukhukongiwa ulwala mu nsingo nu khutagwa mu nyanja. ");
INSERT INTO zgam_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ingave ekhevokho kyakho khihohopenja Geda. Lwiva lononu ukhwingela khuvwumi ne khevokho khemo, ukhwingela khuvahegi nifivokho fyoni. Khu muoto “Gogwa sagwinchima.” ");
INSERT INTO zgam_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Nchingakhencha: unsitari ege, “Baho amatekhenya sagifwa nu muoto gogwa sagwinchima. “Gusimuli mu mbusimbe uvwa khatale). ");
INSERT INTO zgam_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ingave ekhelunda kyakho khehopenchinche khegede. Lwiva lunonu khulyove ukhwingila khu vwumi vu ulendema, ukhwingela khuvuhegi ni filunde fivele. ");
INSERT INTO zgam_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Nchingakhencha: unsitari ogo, “Baho amatekhenya sagifwa nu mwoto gogwa sagwinchima “gusimuli mu mbusimbe uvwa khatale). ");
INSERT INTO zgam_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ingave elikho lyakho likhohopencha lekhenche. Lwiva lunonu khulyove ukhwingila khu ludeva lwa Nguluve vule nelikho lemo, ukhuva na mikho gavele nu khutagiwa khu vwukhegi. ");
INSERT INTO zgam_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Baho pale na matekhenya agasagifwa, nu mwoto gogwa sagwinchima. ");
INSERT INTO zgam_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ulwa khuva khela munu alagendela mumwoto. ");
INSERT INTO zgam_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Omwinyo nnonu, ingave omwinyo gungayanche ovononu vwa gwene, pwu vukhogovombela ndeti ukhungilivula avononu vwa gwene? Muve nu mwinyo yomwe khwa yomwe, muvinchage nu lunonchehecho khwa khela munu.” ");
INSERT INTO zgam_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yiisu akhagega apo akhaluta khu Uyahudi na khuvolongolo khu Yordani, nu lulundamano vakhankonga. ");
INSERT INTO zgam_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Akhavamanyisya, ndavovwa lwale vunchovele vwa mwene ukhuvomba. ");
INSERT INTO zgam_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Pwu avalongonchi vakhincha khuhongela vakhambuncha, “Lwiva lononu ugosi ukhunde ha udala va mwene?” Yiisu akhavanda, “Mose avalagile khehi?” ");
INSERT INTO zgam_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Vakhata, “Mose atotawile ukhusimba ekhalata eya khulekhana nu khuswema udala.” ");
INSERT INTO zgam_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","“Ulwa khuva inumbula nchenyo ng'afu khyomene avasimbile ululagelo ulu, “Yiisu akhavavola. ");
INSERT INTO zgam_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","“Ukhuhuma ukhupeliwa vwa khelunga, “Unguluve avapelile ngosi nu udala.' ");
INSERT INTO zgam_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Pwu ugosi alandekhaga uddaye nu vanina nukhwelunga nu dala va mwene, ");
INSERT INTO zgam_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na vavele avo viva umbele gumo; ulwa khuva saviva vavele, viva umbele gumo. ");
INSERT INTO zgam_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Pwu khekyo akhelonganinche Unguluve omunu asite ukhudatalula.” ");
INSERT INTO zgam_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Vovale mu mbunchenge, avakhongi vakhambuncha ukhukhongana nele. ");
INSERT INTO zgam_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Akhavavola, “Yeyoni uveikhondekhe udala va mwene nu khuntola udala uyonge ivombe uvuligu. ");
INSERT INTO zgam_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Udala angandekhe ugosi va mwene nu khutoliwa nu gosi uyonge, iva iligupa.” ");
INSERT INTO zgam_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Pwu vakhagegela avana avadebe avibate, avakhongi vakhavabencha. ");
INSERT INTO zgam_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pwu u Yiisu vu alemanyile elyo, salekhang'ovosya, akhavavola, “Muvalekhe avana avadebe vinche khulyone, msitage ukhuvasiga, ulwa khuva avana ndava uludeva lwa Nguluve lwavene. ");
INSERT INTO zgam_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Elweli nikhovavula, yeyoni uveisikhupelela uludeva lwa Nguluve ndu mwana ndebe, lweli salingela khuludeva lwa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pwu akhavatola avana mumavokho ga mwene akhavasaya akhavavekhela ifivokho. ");
INSERT INTO zgam_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Vwu ategwile ulugendo lwa mwene omunu yomo akhanyilelela akhafugama khumwene, akhambuncha, “Mmansisi venonu, nevombe khehi nekave uvwumi uvwa sikhunchoni?” ");
INSERT INTO zgam_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","U Yiisu akhata, “Kheli vukhonambula ukhuta nelenonu? Asikhuli unonu, Unguluve ve nnonu mwene. ");
INSERT INTO zgam_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Unchimanyile indagelo: 'Usitage, ukhubuda, ulaligupaga, usitage, ukhuvadesi, vadwadwage Dadayo nu jyuva vakho.'” ");
INSERT INTO zgam_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Omunu da akhata, “Mmanyisi, aga gone ni khogakhonga ukhuhuma neledemi.” ");
INSERT INTO zgam_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","U Yiisu akhandola nu khugana. Akhambula, “Khesigalile ekhenu khemo. Vunogivwa ukhuguncha fyoni ifyoulenafyo pwu uvape avalemilwe, pwuwiva ne khebana khukyanya. ang'ongage.” ");
INSERT INTO zgam_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pwu akhapekha khu mamenyu ago; akhahega vwu ale nolusosovalo, ulwa khuv ale ne fyoma fingi. ");
INSERT INTO zgam_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yiisu akhalolesya khyoni akhavavola avakhongi va mwene, “Umo yevelile vugafu khuvanya fyoma ukhwingela mu ludeva lwa Nguluve! ");
INSERT INTO zgam_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Avakhongi vakhadega khu mamenyu aga. Pwu Yiisu akhavavola akhange, “Vana, vukhafu ukhwingela khu ludeva lwa Nguluve! ");
INSERT INTO zgam_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Vwu pepe khu ngamia ukhulutanincha pa khepulukha kya Sindano, kholikho khu munu untayeli ukhwingela khu ludeva lwa Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Vakhadega nu khwenchofanja, “Pwu veni uveyakheva ipona” ");
INSERT INTO zgam_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yiisu akhavalola akhata, “Khu vanu salekhawesekhane, ila khwa Nguluve. Ulwa khuva khwa Nguluve gone giwesekhana.” ");
INSERT INTO zgam_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","“Peteli akhatengula ukhunchova nave, “Lola tofilekhile fyoni tokhokongile.” ");
INSERT INTO zgam_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yiisu akhata, “Elweli nikhovavola umwe, asipali uveavulekhile uvunchenge, ama ulukhololwe, ama ung'anchange, ama uvanina, ama udadaye, ama avana, ama ekhelunga, nu khung'onga une, ne limenyu, ");
INSERT INTO zgam_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Yoywa salakava mara mia nu khulutelaleno pa khelunga; uvunchenge, ulukholo, ung'ancha, ujyuva, avana, ne khelunga, khu vugatanchiwa, ne ekhelunga ekhihwincha nu vwumi uvwa sikhu nchoni. ");
INSERT INTO zgam_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Vingi vavo valembulongolo valava va munsana, na vavo valemunsana valava mumbolongolo.” ");
INSERT INTO zgam_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Vovalemunjela, ukhuluta khu Yerusalemu, Yiisu alogwile mu mbolongolo khuvene. Avakhongi vakhadega, na vavo valekhuvakonga munsana vakhadwada. Pwu Yiisu akhavavekha palukhanji vala kumi na vavele nu khutengula ukhuvavola eleyakheva likhongwimila umwene: ");
INSERT INTO zgam_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Lole, tulota khu Yerusalemu, nu Nswambe va Adamu yikhelikhiwa khu vatekhenchi avavakha na vasimbi. Yavikhong'ega afwe yavikhong'omia khu vanu va khelunga. ");
INSERT INTO zgam_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Yavikhonkinela, vikhobekhela amati, valantova ne mbekhe, nu khubuda. Vugalutile amanchuva gatatu alanchuha.” ");
INSERT INTO zgam_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakobo nu Yohana, avaswambe va Zebedayo, vakhincha khumwene nukhuta, “Mmanyisi, tudova atovombele kyokyoni ekhetuhohodova.” ");
INSERT INTO zgam_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Akhavavola, “Mwinogwa nevavombele kheli?” ");
INSERT INTO zgam_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Utwedekhe tutame nuve khuvuvalanche vwakho, yomo ekhevokho ekhyahulela, nu yonge ekhevokho ekhyahege.” ");
INSERT INTO zgam_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pwu Yiisu akhavanda, “Samukhemanyile khehyo mudova. Muwesye ukhunywela ekhekombe ekheninywela ama ukhedekha olwoncho oloyakheva ni khwonenchiwa?” ");
INSERT INTO zgam_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Vakhambula, “Tuwesya” Yiisu akhavavola, “Ekhekombe ekheyakheva ni nywela, yamunywela. Nu ulwoncho lolwa nonchiwe, muwesya. ");
INSERT INTO zgam_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Leno uveya kheva itama ekhevokho khyango ekyando ama ekyakhege, sanikhomia one, elyo lya vavo vandaliwe.” ");
INSERT INTO zgam_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Avakhongi avange vala kumi vuvapulikhe elyo, vakhatengula ukhuvakalalela Yakobo nu Yohani. ");
INSERT INTO zgam_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yiisu akhavelanga khumwene nukhuta, “Mulomanyile ukhuta vala uvumwita vovavakha va vanu va khelunga vikhovalongoncha na vanu avanyamakha vivonesya ama khaga vene khulyomwe.” ");
INSERT INTO zgam_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pwu sayinogiwa ukhuva evo khulyomwe. Yeyoni uveinogwa ukhuva mbaha palyomwe edekhe ukhuvavombela, ");
INSERT INTO zgam_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Pwu yeyoni uveinogwa ukhuva mu mbolongolo khulyomwe, edekhe ukhuva nsukhiwa va voni. ");
INSERT INTO zgam_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ulwa khuva Unswambe va Adamu sinchile khuvombeliwa, inchile khuvomba, nu khwehomya uvwumi vwa mwene ukhuva vupokhi khu vingi.” ");
INSERT INTO zgam_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Vakhincha khu Yeriko. Vwu ikhega khu Yeriko na vakhongi va mwene elipuga livakha, unswambe va Timayo, Batimayo, uvesilola na ntofi, atamile palokanji mu nsewe. ");
INSERT INTO zgam_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Vu apolikhe ukhuta ve Yiisu Mnazareti, akhatengula ukhuywega nu khuta, “Yiisu, Nswambe va Daudi, ong'olele ekhesa!” ");
INSERT INTO zgam_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Vingi vakhabencha uve abofyikhe, valekhumbula ununale. Pwu alekhulela khu limenyu lya pakyanya, “Nswambe va Daudi, ong'olele ekhesa!” ");
INSERT INTO zgam_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yiisu akhema nu khulagela elangiwe. Vakhamwelanga, valekhuta, “Ove nkhangafu! Ema! Yiisu ikhohwelqanga.” ");
INSERT INTO zgam_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Akhaletaga palokhanji elikoti lya mwene, akhanyila, ukhuluta khwa Yiisu. ");
INSERT INTO zgam_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","U Yiisu akhamwanda nu khuta, “Winogwa ne khovombele khehi?” Ogosi ola akhamwanda, “Mmanyisi, ninogwa ukhulola.” ");
INSERT INTO zgam_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yiisu akhambula, “Lutaga. Ulwedekho lwakho lukhopolite.” Usekhe gugwa amikho gamwene galekholola; akhankonga u Yiisu munsewe. ");
INSERT INTO zgam_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Usikhei ugwa vuvinchile khu Yerusalemu, vuvafikhe khu Bethfage nakhu Bethania, khu kyamba kya Mizeituni, U Yesu akha vasuha vavili mugati muvakongi va mulene ");
INSERT INTO zgam_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Akhavavula, “Akhata mulutage khu kheijiji eikhukhili kalibu nufwe. Numekhwingila umwa mukhu yevona ei punda ne nyana va punda eiligodowe yeyo saye pakheiliwe nu munu mulungule mlete khuliane. ");
INSERT INTO zgam_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mungavone umunu ikhu vavuncha ita khekhi muligaha lulo'?, Mtenchaga u Yesu atusuhile ekilivala khavilii.” ");
INSERT INTO zgam_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Vakhaluta nu khuvivona epunda (embunda) vekunglule khunji khundiango khuu ntava uguliei wasi, puvakha hudula. ");
INSERT INTO zgam_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Na vanu avange va eimile pala vakata (va kha vavula muligaha kheikhii muvopoa ei punda eyei)?” ");
INSERT INTO zgam_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Vakha vavula nduvu u Yesu avavulile na vanu vakhavalekha valutage. ");
INSERT INTO zgam_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Avakongi vavile vakhagega (vakhalela) ei punda ei ligodowe khwa Yesu va khatandiikha, ei mienda gwa vene pakianya payene u Yesu akhatama pakianya. ");
INSERT INTO zgam_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Avanu vingi vakhatandikha ei mienda gwa vene museule, na vange va khata ndikha amaswatu aga avagidile muvialo. ");
INSERT INTO zgam_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Vala avavale khuvongolo na vala avovakongaga vakhatova ekelele vakhata, “Hosana! Mwana va Daudi Hosiana uviu sajuwe Hosiana uvii khui ncha khulituwa lya Yesu Krisri. ");
INSERT INTO zgam_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Lusanyiwe uludeva ululukhui n'cha ulwa dada vito udavudi! Hosana khuula uvali khuu kianya” ");
INSERT INTO zgam_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pu u Yesu akhiungila khu Yerusalemu akhiingila mutembile akhalola khiila kheinu puu usikhei gu khava gulutile akhaluta khu Bethania, paninie na vali khei n'chigo na vavili. ");
INSERT INTO zgam_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ee sikhu eyekongile vuvivu ya ukhuhuma khu Bethania, ale na njala. ");
INSERT INTO zgam_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Akha vona ubikhei ugugwale nama swatu, khuvutali akhaluta khuui lola eingave iwesya ukhupata kyukyoni vu alutile khuilola sa khapata kheinu mubikhei ugwa gale maswatu gene pa khuva sagwale isikhei gwa mibeikhii. ");
INSERT INTO zgam_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Akhaguvula ubikhii asikhuli umunu uviyakheva ilya isekhe ukhuhuma khuliuve.”Na vakongi va mwene va kha pulekha. ");
INSERT INTO zgam_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Vakhii n'cha khu Yerusalemu, umwene akhiingila mutembile nu khutengula ukhova humya khunji avagulaji na vagunchaji mugati mutembile. Apindyiile itisi ncha vavi khwandusanwa iihela ni figoda fya vala avavagu n'chaga iti nguundya. ");
INSERT INTO zgam_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Sakha luhusa vei voni ukhutola kyukyooni mtembile khii kyo kya gun'chiwe. ");
INSERT INTO zgam_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Akhava manyeisya nu khun'chova, “Ye salisimbiwe ei lwakhuta, “Ei nyumba ya daada viva nyumba ya nyeisayo'? Khwanya panji vooni? lino muvikhile lipango lya valiasi.” ");
INSERT INTO zgam_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Avanchungaji avavaha na navavi simba vakha puleikha vuinchova, navo vakhalonda einjila ya khuumbuda. Hata ewe vadwadile pakhuva amapuga ga vanu gasuugaga na mamenyu aga amanyasaga. ");
INSERT INTO zgam_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kheila sikhei voa fikhee valikhuhega. ");
INSERT INTO zgam_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Vuvigenda vukhu vakha vona ubikhe guumde nage milela gwa yane. ");
INSERT INTO zgam_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","U Peteli akha kumbukha nu khun'chova, “Mwalimu (Imanyisi) lola ubikhii ugukha gu katuule gwumile.” ");
INSERT INTO zgam_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","U Yesu akhavajibu, “Akhata muve nukwieidekho mwa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Eedikha nikhuvavula ukhuta mungate ei kyamba ei khiei kupukha khunyanja, 'Eingawe in'chila masiakha munumbula ukhuta eikhei anchovile, vuyilewonayu Nguluve vuivomba. ");
INSERT INTO zgam_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nikhuvavula khila khene eikhiei munchiova nukhuvan'cha mweidikhage ukhuta muuipata ni fyofiva fyeonyo. ");
INSERT INTO zgam_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Vumukhueeima ne khueisaya munogile ukhusikhila khila khinu eikhimulenakyo khumunu vivoni pu udaada va khukianya eikhova syekhila umwe inogwa n'cheinyo. ( ");
INSERT INTO zgam_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Achiingahein'cha: mungasite ukhusyekila avanu inogwa nayo daada khu kiyanya sikhuva syeikhila inogwa ncheinyo). ");
INSERT INTO zgam_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Va khiin'cha khu Yerusalemu khavidi. Nu Yesu vuigenda mutembile, avachungaji avavana, avasimbii na vagogolo vakhiin'cha khumwene. ");
INSERT INTO zgam_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Khululagilo luleikhu vuvomba imbombo in'chii?” Nave ni akhupile amamulakha aga ukhuvomba eulo?” ");
INSERT INTO zgam_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","U Yesu akhata, “Nikhuva vun'cha eilimenyu limo. Mumbule na yune nikhuvavula khululagilo luleikhu ni vomba aga. ");
INSERT INTO zgam_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ukuoncho lwa Yohani lwa humile khukianya euo lwa humile khumunu? munjibu.”(mumbule). ");
INSERT INTO zgam_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yakhavun'chana vavo va khata, “Tungate khukianya, 'Iti pukheikhii, 'samkhedikhe?' ");
INSERT INTO zgam_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tungate khuvanu, 'Pakhuva avanu,'...” Vadwadile pakhuva vaibatilile ukhuta u Yohani einyamalago. ");
INSERT INTO zgam_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Pu vakhajibu u Yiisu vakhata, “Satulumanyile. Nayu Yesu akhata, “Nayune sanikhuva in'chi khuve ululagilo luleikhu. ");
INSERT INTO zgam_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Pu u Yesu akhatengula ukhuva manyisya khufihwani. Akhata, “Umunu avyalile ugunda gwa misabibu, nu khunchungusya uluvigo, nu khuyava eilifuli lya khivekhila ei togwa (umfinyo) akhanchenga unala akhali hemin'chanche nu gunda gwa misabibu khuva limi va misabibu. Pu akhasafili eisafyali ya pauutali. ");
INSERT INTO zgam_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Usikhie vugufikhe akhasuha umbombi vavalimi va misabibu ukyopila ukhuhuma khumwene isekhe n'cha gunda gwa misabibu. ");
INSERT INTO zgam_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Vakhibata, vakhatola, va khambun'cha bila kheinu. ");
INSERT INTO zgam_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Akhasuha umbombi uyunge vupe vakha vomba vule vule vakhabuda, vakhavavombela vingi imbombo ndin'cho vakha va buda. ");
INSERT INTO zgam_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Badu akhasuha uyunge yope vakha buda vakhataga. ");
INSERT INTO zgam_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ale nu munu uyunge uvakhusuha, umwana va mwene. Ugane uyu ale va muisyo ukhusuha khuvene. Akhata, “Vinchii khuudwada umwana vango.” ");
INSERT INTO zgam_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pu avapangaji vakha nchova na vavo khwa vavo, “Vakhata tumuibate. Tubude, uvuhale wiwa weito.” ");
INSERT INTO zgam_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Vakha muuibata, vakhabuda vakhataga khunji khukhialo kya misabibu. ");
INSERT INTO zgam_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Pu apo, womba! Kheikhii unyakyalo kya misabibu? Ikhuiincha nukhuvabuda voni avalemi va misabibu nukhuvapa avange avalimi va gunda gwa misabibu. ");
INSERT INTO zgam_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Samuumbile uvuvigi wa imenyu lilei? Eiluwe lilyo vabelile avanchengi livile liwe livaha lya khulukanji. ");
INSERT INTO zgam_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Eeli lya humile khwa akada na lya khusuiga pamiho ga vanu.” ");
INSERT INTO zgam_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Valikhulonda ukhumuubata u Yesu, pa khuva valikhudwada ululundamano, lwee vanu valumanyile ukhuta anchovile ei vene. Pvakhandekha vakhanda ukhuluta. ");
INSERT INTO zgam_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Puvakhavasuha vaninie avafalisayo namaherodia vategele khumamenyu. ");
INSERT INTO zgam_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Vuvafikhe, vakhambula, “Imanyisi, tulumanyile ukhuta savujali eikheinu kyoni. Oasavuvonesya uvupendelelo khu vanu ila vumanyeisya einjila ya Nguluve khuvu yii luleli. Niwa yiluleli ukhuhomba eisongo khwa Kaisalia yee? Tuwesya ukhuhomba ewo ate? ");
INSERT INTO zgam_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","U Yesu avumanyile uvudesi wa vene, '“Nukhovavula kheikhii mukhungela? Mume ei ulutalama neilole.” ");
INSERT INTO zgam_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Vakhagega yimo khwa Yesu, akhavavula, “Eisula! Ei Yee yani nuvusimbe uvuwani va khata, “Fya Kesali.” ");
INSERT INTO zgam_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","UYesu akhata, “Mumpe u Kesali ikya Kesalia na mumpe Unguluve.” Vakhawiga. ");
INSERT INTO zgam_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pu amasadukayo, avavita vasikhuli uvunchukha vakha nchutila nu khumbuncha vakhata, ");
INSERT INTO zgam_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Imanyisi, u Mose atusimbile ukhuta ulukololwe va munu angave ifya ikhundekha udala kheisita vana udala uyu iwesya ukhuhalwa nuyonge nukhu ngolela avana khunjila ya lukololwe.' ");
INSERT INTO zgam_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Khuuale nava lukolo saba, uvakhwanja (uvalutanchi) akhafya kha mwana. ");
INSERT INTO zgam_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nayuvavile vupe akhafywa sakhandekha umwana na yuvadatu vule vule. ");
INSERT INTO zgam_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nuva saba akhafya bila khundekha umwana. Khuvumalilo nayunchala akhafya. ");
INSERT INTO zgam_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Usikhegwa vanchukha udala uyu iva vani vuvanchukhilevoni? Khuvalukolo vala saba avavale vagosinva mwene.” ");
INSERT INTO zgam_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","U Yesu akhavavula, “Ei! ye njila ya khuvanchana pakhuva samulumanyile, eili vangeli lya Nguluve?” ");
INSERT INTO zgam_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Usikhei gwa vunchkha wa wafulile, savale tola nu khuingila khavile mumbutegulane viva ndava sahwa khwa khukianya. ");
INSERT INTO zgam_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pu lino, ukhuhumana nuvunchukha, wa! Vanu avinchusiwa samuimbile mukhitabu kya Mose, ululagilo lwa khei nchakha, 'Unguluve vuanchovile une neneNguluve va Abrahamu, mu Isaka, nu Yakobo?' ");
INSERT INTO zgam_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Umwene sio Nguluve vave fuile Nguluve vumi. Luleli muyagilwe.” ");
INSERT INTO zgam_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yumo mugati muvandisyii akhincha mukhu pulehencha einchovele ya vene; akhavona u Yesu avajibile luleli. Akhambuncha lulagilo lulikhu ulunogiwa khulikho nchoni?” ");
INSERT INTO zgam_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","U Yesu akhajibu, “Akhata uye yinogwa y eiyei, “Puleheencha uve Islaeli, Unguluve vito, ali yumo. ");
INSERT INTO zgam_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pu yinogwa ukhukonga Unguluve vakho nee numbula yakho yoni namasage gakho goni, nuluhala lwakho lwoni namakha gakho goni.' ");
INSERT INTO zgam_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ululagilo ulwa khauile, 'Luuulu unganage ujirani nduvu vukhei gana uve.' Lusikhuli ululagilo ulunge uluvaha pa nchii.” ");
INSERT INTO zgam_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Usimbi akhata, “Lunonu mumanyisi! Unchovile luleli ukhuta Unguluve ali yumo, nu khuta asikhuli uyunge khumwene. ");
INSERT INTO zgam_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ukhugana umwene ne numbula yoni, nuluhala luunono, namakha goni, nukhugana ujirani nchuu wiganile lunonu vincho khulikho isadakha ncha khunyanya.” ");
INSERT INTO zgam_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Vu u Yesu ahuminche alijibu lya luhala, akhavavula, “Uve sulie khutali nuludeva lwa Nguluve.” Ukhwanjila apo asipali uviambunchinche u Yesu ama swali. ");
INSERT INTO zgam_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nu Yesu avajibile, vuimani sya mutembile, akhata, “Ava! Simbi vila u Yesu mwana va Davudi? ");
INSERT INTO zgam_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","UDavudi yoywa khu mepo umbalanche, akhata, 'Udaada achovile khwadaada vango utame eikhivokho kyango eikyandwo, ei mpakhaneva vekhe avavini vakho pasi pamalunde gakho.' ");
INSERT INTO zgam_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Udavudi yuywa ikhumwela nga Ukristi, 'Daada' Pu! Mwana va Davudi khunjila?” Yelekhu nululundamano uluvaha lukha pulehencha nuluhekhelo. ");
INSERT INTO zgam_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mulumanyisyo lwa Yesu akhata, “Muakyoli na vasimbi, avavinongwa ukhuluala emienda emitali nu khuponiwa mu sokhoni. ");
INSERT INTO zgam_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nu khutama mufigoda fya vavaha muma sinagogi mu sikukuu (muselehe) Khumamenyu ga vavaha. ");
INSERT INTO zgam_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Vilya munyumba ncha va fyela nu khwieisaya intesaya inali vavavone avanu. Avanu ava vipokhela uvuhegi uvuvaha.” ");
INSERT INTO zgam_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Pu u Yesu akhatama pasi pipi neli sadukha lya sadakhamugati mu tembile; alikhulola avanu vuvigenda nu khulaha ihela muli sandukha lya sadakha. Vingi avanu avatajili vakhalaha ihela nchuu nyingi. ");
INSERT INTO zgam_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pu udala yumo ufwele uganchu akhincha khuilaha ifipande vivile fya sendi. ");
INSERT INTO zgam_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Pu akha vilanga avakongi ya mwene nukhuvavula, “Luleli nukhuvavula, udala uyu ufwile alahile nchu nyingi khulikho voni auatalile ukhulaha mulisandukha lya hela. ");
INSERT INTO zgam_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Pakhuva vingi vahuminche ukhu humana nu wingiwa vibanafya vene. Udala ufyile uyu, ukhuhuma khuganchu wa mulene ahuminche ihela nchooni inchinchi khale ncha khuntanga mbwumi wa mwene.” ");
INSERT INTO zgam_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","U Yesu vulgenda mutembile, ukongi yumo akhambuncha, “Imanyisi, lola amaule aga ga khu suugesya na majengo!” ");
INSERT INTO zgam_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Akhambula, wilola amajengo amavaha aga? Lisikhuli eliwe elevakhwa lisigala pakianya paliwe elenge lilyo salelogwa pasi.” ");
INSERT INTO zgam_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Umwene vu atamile pa khiamba kya miseituni khu sana khu tembile, u Peteli, u Yakobo, u Yohani nu Ndeleya vakhapuncha khuvutitu, ");
INSERT INTO zgam_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Imbombo, inchii nchiwa va ndeli? Hange kheilekhu eikhe hwani kya yene?” ");
INSERT INTO zgam_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","U Yesu akhatengula ukhuvavula, “Muve mcho umunu vevoni asite ukhuva siova. ");
INSERT INTO zgam_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Vingi vikhuincha khulitawa lyango vitinchaga, 'Une nene luleli,' na vikhivayancha vingi. ");
INSERT INTO zgam_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Vumupulekha embancha nenchovele ncha mbancha musite ukhudwada pakhuva imbombo ncha lasima ukhuhumila pakhuva umwisyo badu. ");
INSERT INTO zgam_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Pakhuva ikhilunga khiihe galekhuta khuilwa nekhilunga ekhenge. Pivane khesenyenge isehemu nyingi, ne njala. Ugu gumwanjo gwa luvavo. ");
INSERT INTO zgam_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Muve miho. Vuvikhuva helakha mu balasa, nukhu vatova muma Sinagogi. Gavene vikhu vimikha khuvulungolo khuva vaha na khuva kuludeva khunjila yango, nduvu suhuda khuvene. ");
INSERT INTO zgam_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Welemenyu linogiwa lilumbileliwe khuvanya panji voni. ");
INSERT INTO zgam_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Vuvikhuvibata nukhuva kabisi, msite ukhudwada eikhei yakhei va muunchova. Mugati musikhe ugwa, vikhuvapa kheikhi eikya khunchova; samuuva mulemule umuli yakhiva umepo umbalanche. ");
INSERT INTO zgam_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ulukolo ikhusitakha ulukololule ukhufya, ubaba nu mwana va mulene. Ava navikhweima vunge navo dada yavo nukhuva vikha vabudiwe. ");
INSERT INTO zgam_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","(Mtachukiwa na kila mtu kwa sababu ya jina langu. Lakini atakayevumilia mpaka mwisho, mtu huyo ataokoka. ");
INSERT INTO zgam_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Vumlolile uluvipolwa vuvivi lweimile pala apasapi nogiwa ukhumwema(uvikhweimba na alumanye), pu avavali nugati mwa Yuda vanyilelanga khufiamba, ");
INSERT INTO zgam_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nu vialei khukianya khu nyumba, ikhage pasi pa nyumba, ewo khutola kyukyoni ei khele khunji, ");
INSERT INTO zgam_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nu vialei khukhialo asite ukhuvaya khulola eimlenda gwa mwene. ");
INSERT INTO zgam_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Lwa vene avadala avanya vinchitu navi khwosya isikhu incho! ");
INSERT INTO zgam_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mudovage ukhuta yeisite ukhuhumila usikhe gwa mepu. ");
INSERT INTO zgam_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Pakhuwa khuiva nei sida eimbaha eiyesayegele yeihumile, ukhuhuma Unguluve vuivumba eikheilunga, mpakha lino, sayegelile ukhuhumila na sayi ulesya ukhumila. ");
INSERT INTO zgam_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Impakha udaada vuapuungwisye isikhu, gusikhuli mbilei ufu vakhova gumii pona, pakhuva khunjila ya vagolofu, avayakhiva ikhuva hala, ipungusya inamba ocha sikhu. ");
INSERT INTO zgam_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Usikheli ugwa unga umunu ukhuvavula, ukhuta, u Yesu Kristi alei khunu! Awo alei apa!' msite ukhwudikha. ");
INSERT INTO zgam_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Pakhuva ava Kristi avavudesi navanyamalago avavudesi vihumila na vihumiaga ifihwani, ni fisaugo puvavasiove hate avagalola. ");
INSERT INTO zgam_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Muve miho! Nei vavalile aga goni vu badu akhasikhe. ");
INSERT INTO zgam_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ulwakhuva vayihumila eitasu va sikhu icho, eilinchuva liva hisi, umulenchi saguu humwa ulumuli lwa lwene, ");
INSERT INTO zgam_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Inondwe nchiigwa ukhuhuma khuuki anya namakha agali khukianya gisiekhanikha. ");
INSERT INTO zgam_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Puvikhombona umwana va Adamu vuikhuincha, mumavingo khuu makha mingi nuvu dwadwa. ");
INSERT INTO zgam_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pu isuha avasuhwa va mwene ukhuvalunga manwa pu paninei avagolofu va mwene uvupande vune wa khilunga, ukhuhuma khumwi syo wa gwa khulunga mpakha umwisyo gwa khukianya. ");
INSERT INTO zgam_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Khubikheli mumanyilage ubukha vusaguwesya ukhu vikha amaswalinkhei mbeivi pu mukhulumanya ukhuta eikhei nchuva kheifikhe. ");
INSERT INTO zgam_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","vuyueiwo, vumivona imbombo inchii nchihumila mulumanye ukhuta alipipi nuundiango. ");
INSERT INTO zgam_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Luleli, nikhuvavula, ukhuta eikheivumbukho akhei sakhuluta khutali vu imbombo nchii sanchii humile. ");
INSERT INTO zgam_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Khukianya na pasi filuta, lakhini amamenyu gango safiluta lusikhu. ");
INSERT INTO zgam_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Pakhuva eisikhu nelinchova na khasikhei asipali uviakhamanyile navavasuhwa vakhukianya nayu mwana, ila udaada. ");
INSERT INTO zgam_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mave miho, lola, samulumanyile isikhei mukhii gi humile. (Zingatia: Mstari huu, “Muwe waangalifu, Tazameni na ombeni kwa sababu...” haumo kwenye nakala za kale). ");
INSERT INTO zgam_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Muve miho lolaga nu khudova pakhuva: yilii ndumunu uvei isafili ikhuyilekha enyamba ya mwene nukhumbikho umbombi va mwene ukhuva undoleli va nyumba, khula munu ne mbombo ya mwene. Nukhumbula undindilenchi ukhutama miho. ");
INSERT INTO zgam_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Muve miho! Pakhuva samlumanyile ndeli umbaha vanyumba ivuya muvomba, yiwesekhana lyakheimihe, pakilo pagati usikhei elikongove vulivikha eulo vukilo. ");
INSERT INTO zgam_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Eingave ikhwincha khunjila ya khukenyemula, asite ukhukhuvona ugonelile. ");
INSERT INTO zgam_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kheila eikhei ninchova khuliuve ninchova khwu khila munu: muve miho”! ");
INSERT INTO zgam_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Chiikhale isikhu ivili vubadu uluhekholo lwa pasakha va visyesye ifisafi lahiwe eikhei luve. Avanchungaji avavaha na vasimbi valikhulonda einjilaya khumwibata u Yesu nukhumbuda. ");
INSERT INTO zgam_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pakhuva vanchovile ukhuta yei site ukhuva usikhe gwa luhekhelo avanu vasiya ukhuvomba amatata (iluyo).” ");
INSERT INTO zgam_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Vuu u Yesu alikhu Bethania munyumba ya Simoni ukoma, vu chuta pa mesa, udala yumo akheincha khumuene akhava nei chupa ya mono inonu incha galama eimbaha, akhafungula eichupa nu khududilila inonu pantuwe gwa mwene. Pu ");
INSERT INTO zgam_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","vale na vanu avavavipile (avakolile) vakhavulana vavo khu vavo kheikhi uvuvivi nduvu? ");
INSERT INTO zgam_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Imono nchikhale nchigunchiwa ihela cnhuu nyingi tu khuva pa avaganchu. ");
INSERT INTO zgam_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pu u Yesu akhata, “Mundekhe mwene. Msite ukhugatancha avombile inonu khuli une. ");
INSERT INTO zgam_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Isikhu nchooni mulinavo, avaganchu pakhuva une samwiva nune eimisikhe guioni. ");
INSERT INTO zgam_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Avombile khila eikhyu lulesa: apakhile umbiligwango imono khuujili ya khusila. ");
INSERT INTO zgam_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Luleli ni khuvavula, khila ponu upulilumbileluwa elimenyu, mukhilunga kyoni khila eikhiei avombile umama uyu khiikumbukhiwagwa. ");
INSERT INTO zgam_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pu u Yuda sikalioti, vumo mugati mu vakongi khei nchigo na vavile akhaluta khuvachungaji avavaha alikhunogwa ambikhe mavokho ga vene. ");
INSERT INTO zgam_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Vu avava va vachungaji vapulikhe nchii vaho, wikhe nukhwahidi ukhumpa ihela. Pu alikhulonda enjila ya khukabusi khu vene. ");
INSERT INTO zgam_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Isikhu ya lutanchi ya fisyesye ifisafi, vikhiwe eikhei luve usikhe uguvahuminche ing'osi ya pasakha (luhekhelo) avakongi va mwene vakhambula, “Winogwa ndakhu tukhandale ulya eipasakha paninie nufye?” ");
INSERT INTO zgam_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Akhasuha avakongi vavile nukhuvavula, “Mulutage khujini, mukhumbona ugosi agegile eikhi vya ikhwagana numwe. Mukongage. ");
INSERT INTO zgam_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Munyumba eyakhuva ikhwingila, mukongage na mumbule unyanyumba ukhula umanyisi atile, “Khei lindakhu eikhei yumba kya vageni alile eipasakha na vakongi va mwene?” ");
INSERT INTO zgam_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","IKhuvavonesya ikhiyumba khukianya ikhiei vaha kheikyo kheilei tayali. Pu muvombe amandalasi khujili yuito pala” ");
INSERT INTO zgam_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Avakongi vakhahega ukhuta khuujini; vakhavona kheila khanu nduvaa nchovile navakhandala eikyakyuya kya pasakha. ");
INSERT INTO zgam_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Vuyifikhe lilya kheimihe akhiincha navala kheinchigona vavili. ");
INSERT INTO zgam_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Vuvale pipi nei mesa nu khulya, u Yesu akhata, “Lakhanchova, yumo mugati ndiomwe uvei ilya paninie nune ikhumbuda. ");
INSERT INTO zgam_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","“Voni vakhasikhi tekha yumo yumo vakhambula luleli syoo nene?” ");
INSERT INTO zgam_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","U Yesu akhanchova akhavavula, “Yumo mugati mu kheinchigo na vavilii yumo, uviuyu ilaha ikhei vokho mubakhuli paninie nune. ");
INSERT INTO zgam_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Pakhuva umwana va Adamu iluta induvu eilemenyu leinchovile pakianya pamwene. Pu lwa mwene umunu ula ukhugendela khu mwene umwana va Adamu ibudiwa yekhele huba umunu uywa asite ukhuhouwa.” ");
INSERT INTO zgam_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Vuvalei pakhuli, u Yesu akhalola ukata leikhasyesye, akhasaya nukhumenyula akha vapa akhata lakhanchova. Mtole ugu gumbili gwago.” ");
INSERT INTO zgam_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Akhalola eikheilovo, akheisaya akhavapa voni vakhanywa. ");
INSERT INTO zgam_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Akhavavula akhata, “Ugu guukisa gwago gwa luleidehano, ukisa ugugududeikha khuujili ya vongi. ");
INSERT INTO zgam_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Luleli nukhuvavula, saniinywa khavile eikheinyalelo kya nsabibu impakha neilavaninywa upya nchu cheva lwa Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Voueimbile ulwembo, vakhahuma panji pa khiamba kya miseituni. ");
INSERT INTO zgam_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","U Yesu akhavavula akhata, “Umwee mulee voni mukhei kwega khutali nune pakhuva levegilwe (lesimbiule) Nikhuntova unchungaji va ngosi na ngosi nchinyila.' ");
INSERT INTO zgam_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pavu nchukha khwango nikhu valongola ukhuluta khuu Galilaya.” ");
INSERT INTO zgam_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ndingave voni vikhukhulekha une sani khukhulekha.” ");
INSERT INTO zgam_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","U Yesu akhata, “Luleli nukhukhuvula, eikhilo eiye, vusale vikhile eiakongove mala khavili, uve vukhumbela mara khadatu.” ");
INSERT INTO zgam_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pu u Peteli akhanchova, “Puulino vinogiwa ukhufya paninie nuve sanikhukhulekha.” Voni vakhahumya enjovele yilayila. ");
INSERT INTO zgam_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Vakhiincha khuli eneo eleli khuieilangilwa Gethsemene, nu Yesu akhavavula, “Avahongi va mulene tama apavunikhei saya.” ");
INSERT INTO zgam_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","UYesu akhatu pavutali padebe akhagwa pasi akhadova yengive yenogile akhasikha akha khandekhe. ");
INSERT INTO zgam_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ee numbula, “Yango yelinulususuvalo nukhufya sigala apa muve miho. ");
INSERT INTO zgam_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Akhanchova akhata ee daada imbombo nchoni khuliuve nchii wesekhana uhenche eikheitova eikhei syoondu vuninogwa une ila ulunogwe wakho. ");
INSERT INTO zgam_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Akhakilivukha akhavona vagonelile. Akhambula u Peteli Simoni yee ugonelile savoulesya ukhukina nune ningave eisaa yimo.” ");
INSERT INTO zgam_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Akhakilivukha akhavona vagonelile, akhammbula u Peteli, “Simoni, ye ugonelile? Savoulesya ukhukina nune ndingave eisaa yimo? ");
INSERT INTO zgam_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Muvemiho mudovage musite ukhuuingila mungelo. Lweli enumbula yeletayari, umbilii gubela.” (intamu) ");
INSERT INTO zgam_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Akhaluta kha vilii khudova akhanchova amamenyu gala gala. ");
INSERT INTO zgam_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Akhincha khavili akhavona vagonelile amiho gavene gale machitu savakhalumanya kheikhii ekyakhumbula. ");
INSERT INTO zgam_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Akhiin'cha ulwadatu nukhuvavula, “Badu mugonile nunkhugalalukha? Yekhwelile! Usikhe gufikhe. Lola! Umwana va Adamu vikhumbikha mumavokho gavatula nongwa. ");
INSERT INTO zgam_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Sisimukha, tuvukhe. Lola, ula uviinogwa ukhumbuda aleipipi.” ");
INSERT INTO zgam_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Vu badu ipin'chova uYuda, vumo vavala khenchingo na vavili, akhafikha nelipuga elivaha ukhuhuma khuvavaha va vachungaji avasimbi navagogalo nimundu ni mbunda. ");
INSERT INTO zgam_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Usikhe ughwa umbivi va mwena akhava avapile eikhimanjilo ukhuta uviyakheiva nukhumwanga vi uyu. Mumwubatage nukhumbeikha pasi pavuloleli.” ");
INSERT INTO zgam_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Usiekhei uYuda vuafikhee moja khwa moja akhaluta khwa Yesu nukhunchova, “Imanyisye!” Nu khumwanga. ");
INSERT INTO zgam_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Pu vakhambeekha pasi pa vuloleli nukhumubata. ");
INSERT INTO zgam_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yumo aemile pagati pavene akhahoma ne mundu ya mwene akhatova umbombi va vatekhenchi nukhugeda eembulukhutu. ");
INSERT INTO zgam_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","U Yesu akhavavula akhata, “Mwin'chile khukhunyibata ni mundu ni mbunda nduu ndiasi? ");
INSERT INTO zgam_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Useikhee gwooni nekhale numwe pelikhumanyeisya mutembile samulikhunyibata eele levombikhe eelimenyu letimile. ");
INSERT INTO zgam_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Vla voni avavale nu Yesu vakhanyila vakhandekha. ");
INSERT INTO zgam_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ukheejana yumo alikhukonga uveafualile umwenda ee fekhile ukhunchungula; vakha mwibata pakhuva ");
INSERT INTO zgam_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","akhatolokha akhatilekha emasindikha ya mwene akhanyila vufula. ");
INSERT INTO zgam_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Vakhandongon'cha uYesu khutekhen'chi umbaha pala upuva eevanganinche paninie nave, avatekhen'chi avavaha voni navagogolo, na vasimbi. ");
INSERT INTO zgam_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","U Peteli vope alikhukonga uYesu khuvutali ukhuluta khuluvanja lwa ntekhenchi umbaha. Akhatama paninie navalolenchi, avavali pipi nu mwoto valie khuota vakhave amafukhe. ");
INSERT INTO zgam_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Usikhe ugwa avatekhen'chi avavaha voni nili Balasa lyooni valikhulonda uvusaidi vakhave apa khumbudila savakhave. ");
INSERT INTO zgam_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Pakhuva avanu vingi vagegile uvusuhuda wa vudesi khuu mulene vakhanchova vakhata. ");
INSERT INTO zgam_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Pakhuva avanu vingi vagegile khuu mwene; vakhan'chova vakhata, ");
INSERT INTO zgam_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","'Tukhapulikhe ita ninanganwa etembile eieyein'chengiwe na mavokho, mugati musikhu idatu nin'chenga eeyenge iyesayinhengiwa na mavokho.” ");
INSERT INTO zgam_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pakhuva uvusaidi wa vene savuhuanine. ");
INSERT INTO zgam_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Untekhen'chi umbaha akhima pagati pavene akhambun'cha uYesu, “Ye, ulien'chila kyakhunchova avavisudila kheekhii khuliuve?” ");
INSERT INTO zgam_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Akhan'chiga myee sakhanchova kheinu. Puuntekhenchii tembaha akhambuncha khavili, “Uve veve Kelisiti, Usayiwa?” ");
INSERT INTO zgam_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","U Yesu akhan'chova akhata, “Une nene. Mukhombona Umwana va Adamu atamile eikhieivokho kyandwo eikyamakha ikhwin'cha na mavingo ga khukianya.” ");
INSERT INTO zgam_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Utekhen'chii umbaha akhalalavula emienda gwaa mwene nukhuta, “Badu vapi nogwa avasaidi? ");
INSERT INTO zgam_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mupulikhe ulubado lwa mwene umwe mwita kheekhii?” Voni vakhang'eega ukhuva vakhubudiwa. ");
INSERT INTO zgam_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Avange vakhatengula ukhubehela amati nukhugombekhiila khumiho nukhuntova nukhumbula, “Temage!” Avavaha vakhantola nukhuntova. ");
INSERT INTO zgam_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","U Peteli vubadu alieipasi ung'ein'cha yumo umbombi va va tekhen'chii avavaha akhiin'cha khumwene. ");
INSERT INTO zgam_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Vuambwene uPeteli amile ikyota umwoto akhandola pavupipi akhata nayuve uukhale nu Yesu vakhu Nazaleti, Yesu”. ");
INSERT INTO zgam_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pu akhalola akhata, “Saneimanyile umunu uywa!” Akhahega akhaluta khunji. (Zingatia; Mstari huu, “Na jogoo akawika” haumo kwenye nakala za kale). ");
INSERT INTO zgam_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pu umbombi udala pala vuambweneakhatengula ukhuvavula vala avava eimula pala, “Umunu uyu viininile!” ");
INSERT INTO zgam_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pu akhabuda khavili pu vala vuakinile vadebe vakhata Peteli, “Lweli uve ulei ninwe va uyu pakhuva nayuve ulei Galilaya.” ");
INSERT INTO zgam_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pu akhatengula ukhweivikha yuywa mulukoto nukweiei lapa(jiega), “Sanimanyile umunu uyu uvimwin'chova.” ");
INSERT INTO zgam_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Eelikongove leikha vikha ulwa vile. Pu uPeteli akhakumbukha amamenyu aga ambulile uYesu vusayivekhile ehukhu vukhumbela mala khadatu.” Akhagwa pasi akhatengula ukhulila. ");
INSERT INTO zgam_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Vakhalava vukilo avavahava vate khenchii vakhaganila pu paninie na vagogolo na vasimbi neli balasa lionieya vagogolo vakhang'udula u Yesu vakha ng'ulikha khwa Pilati. UPilati akhambuncha uve veve khuludeva (Ntwa) vava Yahudi?” ");
INSERT INTO zgam_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","“Akhata akhanchova, “Uveveve unchovile lulo.” ");
INSERT INTO zgam_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Avavaha va vate khenchii vakhanchova inongwa nchuu nyingi khwa Yesu. ");
INSERT INTO zgam_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Upilati akhambuncha kha, “Vilii savunchova? khenu sawilona vuvikhukhu sitaka ni nongwa nchuunyingi? ");
INSERT INTO zgam_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","UYesu sakhanchova pu uPilati akhanswiga. ");
INSERT INTO zgam_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ee khawaida pa luhekhelo vavikhudeinchulila ukugwa yumo, ukugwa uviadovile. ");
INSERT INTO zgam_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pu valipo avavivi mulumandena vabudi avavale mugati mukhutumikhela inongwa ncha vene. Pu alipo umunu yumo viibaraba badala ya mwene. ");
INSERT INTO zgam_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Uvumati wa vanu vukheinchakhwa Pilati, nukhudova avombe nduvu avombile khusana. ");
INSERT INTO zgam_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","UPilati akhajibu khavile, “Nukhuta mwinogwe neidindulile neifumgulile Untwa vava Yahudi?” ");
INSERT INTO zgam_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pakhuva alumanyile ukhuta lioyo lya vatekhenchii avavaha vakha mwibata u Yesu nukhugega khuumwene. ");
INSERT INTO zgam_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pu avava vavatekhenchelii vakhanchoochela khuvanu ukhu yuleega khuu savuti eimbaha adinduliwe u Baraba umwene asigale. ");
INSERT INTO zgam_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","U Pilati akhajibu khavili akhata, “Neivombe kheikhii khu Ntwa vavayahudi? ");
INSERT INTO zgam_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Vakha yuleege, “Asulusiwe!” ");
INSERT INTO zgam_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","U Pilati akhata, “Avombile mbombo nyikhei imbivii?” Pu vakhendelela ukhu yulega sana “Asulusiwe (abuduwe).” ");
INSERT INTO zgam_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","U Pilati vuunogwa ukhuvali sesya uvumati, wa vanu akha olindulela u Baraba. Akhantova u Yesu nei michapi akhangu mya abuchiwe (Asuhubule). ");
INSERT INTO zgam_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Usikhali akhandongoncha mugati mulivuva (lila lila eilya mukambi) vaei vunganinche pu paninie ava sikhali. ");
INSERT INTO zgam_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Vakha fyalincha u Yesu eimienda gwa sambalawe, va khahona eikheili kya vuntwa vakha fyalincha. ");
INSERT INTO zgam_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Vakhatengula ukhubedamwa nukhuta, “Ugonile vintwa vava yahudi!” ");
INSERT INTO zgam_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Vakhantova khuntwe nelilanji nukhubehela amati. Vakhafungama khuvulongolo ukhudwada. ");
INSERT INTO zgam_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Vuvamalile ukhubedanwa vakhafula ei kanjo ya mwene, ei ya sambalawe nukhufyalincha emienda gwaa mwene, yakhang'uumya khunji nukhuluta khukhubuda. ");
INSERT INTO zgam_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Vakhandasimisya ugenda njila ukhuntanga uvialutaga khuujini ahumile khukhialo uvialilangiwaga Simoni Mkirene (Ubabaye usikanda rufo); vakhandasimisya ukhugega eikhi damilihani kya Yesu. ");
INSERT INTO zgam_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Avasikhali vakha gega u Yesu aponu apapi khuei langiwa Goligota (eimana ya yene eikhee nchege kya ntwe). ");
INSERT INTO zgam_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Vakhampa eimunu eimikali eigee vahanjinuee ne manemane, akha bela ukhunywa. ");
INSERT INTO zgam_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Vakhantovelela vakhagavana emienda gwa mwene, vakhatova nee kula veni usikhali umbaha akhave. ");
INSERT INTO zgam_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yale ndei sau idatu vukhilo upuvatovelelaga. ");
INSERT INTO zgam_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Vikha vikha khuntule eikhei bavo eikhe vasimbile inongwa umbaha (untwa vava yahudi).” ");
INSERT INTO zgam_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Vanto velile paninie navaliasi vavile, uyunge eikhivokho kyandwo uyunge eikhei vokho kya hegei. ");
INSERT INTO zgam_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Pu elimenyu likhatimila ulyu lyanchovile. ");
INSERT INTO zgam_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Vala avava gendaga vakhadukha nukhuta, ehee uvivudenya eetembile nukhunchenga isikhu idatu, ");
INSERT INTO zgam_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Eepokheyuve wikhee pasi uhege pa kheedanilihani!” ");
INSERT INTO zgam_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Vivule vule na vavaha va vatekhenche va khabedanwa paninie navasimbi nukhuta, “Akhapokhile avange eilemwa ukhwei pokha yoywa. ");
INSERT INTO zgam_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","UKristi untwa vavaislaeli, eekha pasi lino uhega pa khida milihanwe navala avava oveleliwe paninie vope vakha bedanwa. ");
INSERT INTO zgam_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Vuyefikhe esaa fifa eihisi yei khincha pakianya pakhilunga kyoni mpakha pa saa tisa. ");
INSERT INTO zgam_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Usikhe gwa saa tisa, u Yesu akhaywega eisavuti eemba, “Eli, Eli, lama saba katani?” Nguluve vango, Nguluve vango, kheekhii undekhile?” ");
INSERT INTO zgam_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Pu vala avava emile vuvapulikhe vakhata, “Lola, ikhimuilanga u Eliya.” ");
INSERT INTO zgam_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Umunu yumo akhanyila, akhadincha eisikhii musiponji akhavekha mulilanji akhampa anyule. Umunu yumo akhata indekhetulole ndii khuuincha u Eliya khukhuu mwisya pasi.” ");
INSERT INTO zgam_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pu u Yesu akhalila khu savuti embaha akhafya. ");
INSERT INTO zgam_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Pu eelipasia lya tembile leikha banchukha ifipande fivili ukhuhuma khukianya mpakha pasi. ");
INSERT INTO zgam_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Umwembi yumo uviaemile alikhuluta khwa Yesu, vu alole vuifyandalula akhata luleli umunu uyu akhale mwana va Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Valipo avadala avavalolaga khuvutali pagati pavene alipo Umaliamu (umama va Yakobo ununave va Yose), nu Salome. ");
INSERT INTO zgam_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ukhii uguvale khu Galilaya vakongile nukhu mbombela navadala avange vingi vakongine nave ukhu fikhakhu Yerusalemu. ");
INSERT INTO zgam_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Vuyefikhe lyakheimihe ulwakhuva yale sikhu ya khuu yandala ukhugalalukha, ");
INSERT INTO zgam_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","UYosefu vakhu Almathaya akhincha pala ale mbombi valibalasa uveidwadewa umunu uviugulela uludeva lwa Nguluve. Namakha akhalula khwa Pilati, khudova umbili gwa Yesu. ");
INSERT INTO zgam_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","UPilati akhaswiga ukhuta u Yesu afyuile; akhamwe langa u ofisa akhambuncha ingave Yesu afyile. ");
INSERT INTO zgam_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Vu apatile eihabari ukhuta u Yesu afyile, akhanchuhusu u Yusufu ukhutola umbile gwa Yesu. ");
INSERT INTO zgam_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","UYosefu agulile umweenda akhamwisya ukhuhuma pa kheidamilihani akhabina mumwenda nukhumbeikha mulipumba. ");
INSERT INTO zgam_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Umaliamu Magdalene nu Maliamu umamaye Yose vakhalola upuvasielile u Yesu. ");
INSERT INTO zgam_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Vugusilele usikhe gwa khu gatalukha, Maliamu Magdalene nu Maliamu umamaye u Yakobo, nu Salome, vagulile imono inonu, valute vakhabakhe umbili gwa Yesu khujili ya khusiala. ");
INSERT INTO zgam_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Vukilo ee sikhu ya lutanchi ya juma, vakhaluta khuli pumba vu eilinchuva lihuma. ");
INSERT INTO zgam_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Vakhanchovana vavo khu vavo, “Veni unchii mulipumba?” ");
INSERT INTO zgam_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Vuvilola, vakha vona umunu akihwusye eelue eeliliale livaha fincho. ");
INSERT INTO zgam_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Vakhiingila mulipumba vakhambona ukheijana afualile eimienda eimivalafu alamile eikhei vakho kyandwuo, vakhasuniiga. ");
INSERT INTO zgam_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Akhata msite, “Ukhuduada. Mukhundonda u Yesu, vakhu Nazaleti, uviakhabudiwe. Anchukhite! Asipali apa. Lola upu vakhagoninc'he. ");
INSERT INTO zgam_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Lutaga mukha vavule avakongi vamwene nu Peteli ukhuta avalonguule ukhuluka khuu Galilaya. Ukhu munchi khumbona, nduvuakhavavulile.” ");
INSERT INTO zgam_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Vakhahega nu khunyila ukhuhuma mulipumba; vakhatetema nukhuswiiga savakhanchova kheinu khumunu vevoni pakhuva vadwadile sana. ");
INSERT INTO zgam_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Vukilo eisikhu ya lutanchii mujuma, vuanchukhile akhang'umila Umaliamu Magdalene, uviuyu ukhuhuma khumwene ang'uuminche imipepo saba. ");
INSERT INTO zgam_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Abhahega nukhuvavuli avanine avavale paninie nave vuisikhitikha nu khulila. ");
INSERT INTO zgam_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Vakhapulikha ukhuta muumi avonikhe lakhuini savakhanumi. ");
INSERT INTO zgam_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Vuugahumile ago, akhavone kha hange khuvanu vavili, vuigenda mukhei lung. ");
INSERT INTO zgam_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Vakhaluta khukho vavula avakongi avange vavo vakhasigile, pope savakhakela. ");
INSERT INTO zgam_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","U Yesu pongela akhahumila khuvala kheinchigo na yumo vuvalagine pa tisi akhava dukha pa khu sila ukhueidekha khwa vene, nuvukhe fuewa numbula ncha vene pakhuva savalei khuueidekha vuvikhuvavula vala avalole vu anchukhile ukhuhuma khuu vufye. ");
INSERT INTO zgam_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Akhata, “Mulutage mukhilunga kyooni nu khulumbilila eilimenyu lya Nguluve khukhila munu. ");
INSERT INTO zgam_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Vevoni uvi uvikhuueidikha nu khuuonciwa ipona nula uvei sikhuleidekha alaheigiwa. ");
INSERT INTO zgam_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ifihwani ifi figendaga paninie na voni avikhuleedekha eilitawa lango. Vihenchoga eimipepo. Vinchovaga einchovele eimya. ");
INSERT INTO zgam_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Vikhuuibataga injokha namavokho gaveni ndavanyule ifinu fyoni ifya khubuda safigaha kheinu. savifya vive khaga amavokho khuvatanu viponaga.” ");
INSERT INTO zgam_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Vu anchovile navo akhatoliwa khukianya atamile eikhivokho kyandwo eikya Nguluve. ");
INSERT INTO zgam_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Avakongi vakhahenga nukhulumbilila khila ponu usikhii ugwa u Yesu alekhuvomba eimbombo novo nukhu vonesya elimenyu nukhuponwa nifihwani fikhalongonchana navo. ");
INSERT INTO zgam_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Vingi vitangile ukhuvikho vunonu amamenyu (simulizi) amamenyu galo ugukavombikhe kati yunyo, ");
INSERT INTO zgam_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nduvuvatupile ufwe, yufwe ukhuhuma khuvutengulilo twalolile na miho gito na vavombi va limenyu. ");
INSERT INTO zgam_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Pwu nayune, vwu nilolile vunonu uvutengulilo wa mbombo inchi nchoni ukuhuma khuvute ngulilo - nikwene lunonu kulyune ukhukhwandikila vunonu mhesimiwa fincho Theofilo. ");
INSERT INTO zgam_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Inave vwinogwa ulumanye uvwa yihwe li vwa mbombo iyumanyile. ");
INSERT INTO zgam_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mfigono fya Herode, umbaha va Yuta, ali pwa ukuhani yumo ale vi Sakhaliya, va khikolo kya Abiya. UU dala ahumile khyu kuvana va Haruni, ni litavwa lya mwene ale vi Elizabeti. ");
INSERT INTO zgam_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Voni vale va yilweli kuvulongolo kwa Nguluve; valikugenda khisita lunoninoni mu ndagilo nchoni ncha Nguluve. ");
INSERT INTO zgam_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Khange savakhale nu mwana, ulwa khuva u sabati ale gumba, khange voni vala vagogolo fincho. ");
INSERT INTO zgam_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Pwu lino yikhahumila ukhuva u sakhaliya ale va Nguluve, vwivomba imbombo ya vukuhani msamu ya mwene. ");
INSERT INTO zgam_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ukhukongana nu lwiho ulwa khuhala vi kuhani alikhu uvi ya khave ivomba, vahalaga ni kura ukhwingile mmtembile ya Nguluve nu ukhufukhutila uvumba. ");
INSERT INTO zgam_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ikhipuga kyoni kya vanu lili kudova khunji unsikhi gwa kufukhutila uvumba. ");
INSERT INTO zgam_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Pwu usungwa va Nguluve akha ngumila nu khoima khunelyo khwu nekhelo ya khufukhutila. ");
INSERT INTO zgam_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Usakhelia akha dwada vu ambene uvudwanchi vukhagwila. ");
INSERT INTO zgam_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pwu unsugwa akhambula akhata ulekhe ukhudwada, “Sakhaliya, ulwakhuva uludovo lwakho lupulikhikhe. UU ndala vakho uelisabeti ikhukhuholela umwana. Elifavwa lya mwene vukhumwilanya Yohana. ");
INSERT INTO zgam_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Vwiva nu luhekhelo nu khukimagila, khenye vingi vikhv khuhovokhele ukhu holiwa khumwene ");
INSERT INTO zgam_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","is ulwakhuva iva mbahahi pavulongolo pamiho ga mmbaha. Sakhanywinchage idivai na ikivinywa ikhikali, khange iva adigile nu mepo umbanche, ukhuma mwitumbu mwa mamaye. ");
INSERT INTO zgam_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Na vanu vingi va mu Israeli vi vipindukha kwa nkuludeva Unguluve va vene. ");
INSERT INTO zgam_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ihitage khuvulongolo khumiho ga Ntwa nu mepo na makha ga Eliya. Ayivomba evo ukhukilivula inumbula ya baba kwu vana, uvu savidwa yavitota nu luhala lwa avalinu vwa yihweli. Ayimba wvo ukhuvika kwa Ntwa avanu uvu vavikhwe khu nongwa ya mwene.” ");
INSERT INTO zgam_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakhalia akambula usungwa, “Nikulumanyandakhekhe ukhulu manya eeli? Ulwakhuva une niligogolo na yu ndala vanga imgakha gya mwene givile mingi fincho.” ");
INSERT INTO zgam_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Usung'wa akhambula akhata, “Une nene gabileli, uvikhwima pamiho ga Nguluve nikhasuhiwe kukhumbula, ukhukhugegela inongwa iyi inonu. ");
INSERT INTO zgam_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ulolage, sayawilola, vwivamye, sukhanchove mpaka isikhu yila yakhave yihumila. Yehumile ulwakhuva amamenyu ganyo yagihumila khunsikhi unonu.” ");
INSERT INTO zgam_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Pwu lino avanu vali khugulila u Sakhalia. Walikudega ukhuta unsikhi gwoni ale mtembile. ");
INSERT INTO zgam_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Vwu ahumile khunji alikhulemwa ukhunchova na vene. Vakhalumanya ukhuta upile amagono fivi vwali mtembile, alikhupi vonesya mufihwano akhanchiga mye. ");
INSERT INTO zgam_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Yukhahumela ukhuta amanchuva ga vuvombi vwa mwene vuvusilile akhahega ukhuvuya khumiave. ");
INSERT INTO zgam_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Usakheliya vu avuyile khumiave ukhuhuma khuvuvombi wa mwene mu tembile, uu dala va mwene va akhava nu luleme. Navope sakhahuma mu nyumba ya mwene khu mienchi gihano akhata, ");
INSERT INTO zgam_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ili lyu utwa avombile khulione upwa khandolile kwu vupendelelo ahenche isoni khuliune khange pamiho ga vanu.” ");
INSERT INTO zgam_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Pwu lino umwenchi ugwa ntunato gwa mimba gya Elisabeti, Unguluve akhambula unsung'wa Gabilieli ukhuhila ikhilunga khya Mgalilaya khu khwilangiwa Nasaleti, ");
INSERT INTO zgam_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Khu ng'inja uvyalondwe nu gosi uvi ikhwilangiwa vi Yusufu. Umwene ale va khivumbu kho kya Ndaveli, khange ilifavwa lya g'inja uyu ale vi Ihaliya. ");
INSERT INTO zgam_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Akhincha khumwene nukhuta, “Nikukhuponia, uveve vyu pokhile uluhungu uluvaha! Untwa ahovwikhe nuve.” ");
INSERT INTO zgam_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Limo amamenyu ga Nsungwa ga nja nchiche nu khusifa ukhulumanya khekhi unusungwa akhatile nikhu khupoia (salaam) ukhuu nchakhudege khu mwene. ");
INSERT INTO zgam_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Unsungwa akhambula, “Ulekhe ukhu dwadwa, Maliya, ulwakhuva vwupilile uhehungu ukhuhuma khwa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Khange lola, vwigega uheleme mulitumbu lyakho vwihola umwana. Nayuve yavukhumwilaga ilitavwa lyamwene vi 'Yisu.' ");
INSERT INTO zgam_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Iva mmbaha ikwilangiwaga mwa ve khukhanya fincho. Utwa Unguluve ikhumpa ikhigoda ikhinyahwangulo ikya Ndaveli ubaha va mwene. ");
INSERT INTO zgam_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ayilongoncha pa kyanya pa kwumbu kho kya Yakhobo myakha gyoni nu ludeva lwa mwene lwiva luchila vumalilo. ");
INSERT INTO zgam_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Umaliya akhambula unsung'wa, ili lihumela ndekhekhi ulwakhuva sanegele nigone nu ng'osi uvi ave, nchaga? ");
INSERT INTO zgam_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Usung'wa akhamwanda nu khumbula, “Umepo umbalancho ikhwo khwinchela paliyuve pwu lina umbalanche uviyakhave iholiwa ayikhwi langivwa mwane va va Nguluve. ");
INSERT INTO zgam_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Pwu lola, uhekhulolwakho u Elisabeti alinuleme lwa mwana khu vutamo wa vugogolo vwa mwene. Ugu mwenchigwa sita khumwene, uvivalikhu ihwilanya igomba. ");
INSERT INTO zgam_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Uhwakhuva lisikhuli ilyo likhuntola Unguluve.” ");
INSERT INTO zgam_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Umaliya akhala, “Lola une nili mbombi va khidala va Nguluve. Ilakhe lwe yive vule vule khulione nduvo ilimenyu lyakho.” Pwu unsung'wa akhandekha. ");
INSERT INTO zgam_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pwu pafigono ifyo Umaliya akhahega khimbivi mbivi akhaluta khukhelunga khya twamba, khu jini gwa khilonga ya Yuta. ");
INSERT INTO zgam_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Khaluta mnyumba ya Sakhaliya nu khumponia Uelisabeti. ");
INSERT INTO zgam_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pyu yikhahumila ukhuta Usabeti avile apolikhe uheponio mwene akhanchumba, nu Sabeti akhadiga umepo umbalenche. ");
INSERT INTO zgam_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Akhatoncha ilimenyu lya mwene nu khunchova khulinyu ili vaha, “Usayivwe uve mumbadala, nu mwana uvyalimwitumbu lyakho asayivwe. ");
INSERT INTO zgam_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Khange yiva ndakhikhi kyulune ukhuva, mama va Nkuludeva vango ukhuta inche khulione? ");
INSERT INTO zgam_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ulwakhuva, likhavile lipulikhikhemu mbulukhutu nchango ilimenyu lya khuponia uve umwana mwandileme lyango akhanchumbo nu hehovokho. ");
INSERT INTO zgam_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Khange asayivwage dala uvi alikwidikha ukhuta vukhala vuhumila khuvumalilo vwa Nkhuludeva.” ");
INSERT INTO zgam_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariamu akasema, nafsi yangu inamsifu Bwana, ");
INSERT INTO zgam_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nu mepo yango yihovwikhile mwa Nguluve umpokhi vango. ");
INSERT INTO zgam_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Uhwa khuva alolile pasi pa mbombi va mwene udala. Lola, ukhuhuma lino ifipepo fyoni fikhunyi langaga insayiwa. ");
INSERT INTO zgam_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ulwa khuva umwene ummanyi avombile imbombo imbaha khuliune, khulitavwa lya mwene ilivalenche. ");
INSERT INTO zgam_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Uluhungu lwa mwene lutama khipaponi khipato khuvala avikhudwada umwene. ");
INSERT INTO zgam_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Avonisye amakha kwu khwa khivokho kya mwene; avahaselihimie vala ava likwiginie pa masago ga numbula yu vene. ");
INSERT INTO zgam_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Avisinche pasi avana va vavaha ukhuhuma kwu fitamilo fya vene ifinya hvangulo nu khuvavikha kwu khyanya uvavale va pasi. ");
INSERT INTO zgam_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Alikuvigusya avalininjala kwu finu ifinonu, pwu atayili avaswimile mavakho gene. ");
INSERT INTO zgam_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ahuminche uvutangile kwa Israeli umbombi va mwene, ukhukumbu kha ukhuvonesya uhihungu lwa mwene ");
INSERT INTO zgam_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","(Nduvu anchovile kwa dada yetu) khwa Abrahamu ni khipapo kya mwene milele.” ");
INSERT INTO zgam_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Umaliya akhatama nu Elisabeti iminchi gidatu ndee pwa khavuya kwu nyumba ya mwene. ");
INSERT INTO zgam_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Pwu lino unsikhi gukhavile guhege lile ugwa Elisabeti ukhuhola umwana udimi. ");
INSERT INTO zgam_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Awambunchege na vahukhulolwe vakhapu likha umwu unkuludeva vwa kunchinche uluhunge hwa mwene, pwu vakhahovokha paninie nu mwene. ");
INSERT INTO zgam_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pwu yikhahumila ikhigono ikya nane ukhuta vali kwincha kwigida umwana. Yikhenong'ikwa ukhumwilanga ilitavwa lya mwene, “Zekaria,” Ukhuva liyavwa lya dada va mwene, ");
INSERT INTO zgam_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pwa mama va mwene akhamula akhata, “Ate; ikwilangiwa Yohana.” ");
INSERT INTO zgam_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Vakhambula, asikhuli nu via liyumo mukikolo kyako uviikwila ngiwa nilitawa ili.” ");
INSERT INTO zgam_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Vakhambombela ikhimanyilo udadaye ukhumbula umwene ukhuta alikunongwa ampe ilitavwa iliveni. ");
INSERT INTO zgam_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Udadaye alikhunongwa ikbavo kya kwandika, pwu akhandikha, “Ilitavwa lya mwene vi Yohana.” Voni valikhudegu pa ili. ");
INSERT INTO zgam_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Unsikhi ndugu undomo kwa mwene gulichadinduliwa nu lulimi lwa mwene lulikukyega. Alikhunchova nu khuginia u Nguluve. ");
INSERT INTO zgam_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Uwudwanchi vukhevinchele voni uvuvatamaga paninie nevene. Imbimbo nchikhagenda ikhulunga kyoni ikya fyamba fya Yuta. ");
INSERT INTO zgam_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Pwu voni uvuvapulikhe vakha gavika munumbula ncha vene vita, “Umwana uyu viva ndekhekhi nela khekhi?” Ulwakhuva ikhivokho kya Nkuludeva khi khale nu mwene. ");
INSERT INTO zgam_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Udadaye va Sakhaliya adigile umepo umbalanche nu khuhumya uvunyamalago, akhata, ");
INSERT INTO zgam_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Aginivwage Unkuludeva, Unguluve va Israeli, ulwakhuva atangile nu khuvombela uvapokhi vwa vanu va mwene. ");
INSERT INTO zgam_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Atwimikile ulusuga lwa vupokhi mnyumba ya mbombi va mwene Undaveti, ukuhuhuma mkhikolo kya mbombi va mwene Undaveti, ");
INSERT INTO zgam_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nduvu anchovvile kwu ndomo gwa va nyamalago va mwene uvulalepwo imisi khi ikya khatele. ");
INSERT INTO zgam_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ikhutupokha khuvavivi vito nu khumyammavoko ga voni avikhutuvipila. ");
INSERT INTO zgam_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ayivomba evwo ukhuvonesya ikisa khuva dada vito, nu khumbukha uhwidihano lwa mwene uluvalanche, ");
INSERT INTO zgam_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ulwidiko ulwu anchovile kwa Abrahamu udada vito. ");
INSERT INTO zgam_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Akhidiga ukhugangancha ukhuta yiwesekhano ukhumbombela U Nguluve khesita vudwanchi, vwu tupokiwe ukhuma mumavokho ga vavivi veto. ");
INSERT INTO zgam_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Mu vuvalanche nu vwa yehweli mbolongolo mmwene ifigono fyeto fyoni. ");
INSERT INTO zgam_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ena, na yuve mwana, vwikhwalaa ngivwa nyamalago va uvali khu kyanya fincho, ulwakhuva ayigendelaga mmbolongolo mwa Nkuludeva ukhuvavikhila injila, ukhuvavikha avanu ukhumulu pilila, umwene, ");
INSERT INTO zgam_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ukhuvavula avanu ukhuta ya vipokhi vwa kwu njila ya khusyikheliwa imbivincha vene. ");
INSERT INTO zgam_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ili yalihumila ulwakhuva khisa kya Nguluve vito, ulwakhuva ilinehuva ukhuhuma khukhenya likhutinchela ");
INSERT INTO zgam_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ukhuvala khuvala avitama mhisi na mnu mwafuli gwa vufwe ayivombavo ugalongoncha amalunde gitu kwu njila ya lunonchehencho.” ");
INSERT INTO zgam_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Pwu, mwana ula akhavula nu khuva na makha mumepo pwa akatama mchagalawe mpakha ihincho lya khuhumila umwene khu Israeli. ");
INSERT INTO zgam_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Pwu ifigono ifyo, yikhahumila ukhuta Ukaisari Agusto akhahumya ululagilo lwa alikuvavula ukhuta yitowwe mbalilo ya vanu voni avitama nkilunga. ");
INSERT INTO zgam_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Iyi yale mbalilo ya kwanda vyuyavombiwe imisikhi gya kvenio vu imbaha va Siria. ");
INSERT INTO zgam_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Pwu kila munu uviavinchaga akhaluta khukhilunga kya mwene kusimba mbalilo. ");
INSERT INTO zgam_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nu Yusufu akhaga novope mkhilungwe kya Nasaleti ya Mgalilaya pwu ali khugenda mkhilunga kya mbetelehemu, kya manyikhikhe ukhuta khilunga kya Ndaveti, ulwakhuva ahumile mu khikholo kya Ndaveli. ");
INSERT INTO zgam_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Akhalufa ukhwa khukhisimba paninie nu Maliya, uvi uyu ali ng'ija va mwene khange alikhwihuvila umwana. ");
INSERT INTO zgam_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pwu yikhahumila ukhuta, vuvalyukhu unsikhi gwa mwene gwa khuhola umwana gukhe fikhe. ");
INSERT INTO zgam_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Akhifungula umwana undemi, ung'oliwa va mwene uva khwanja, akhamfwalincha imienda yilekha ukhwingila imepu umwana pwa akhambikha mlitenchi ilya khulela ifikonu, ulwakhuva yikhasikuli inyumba ya vugenji. ");
INSERT INTO zgam_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Pwu apene apo, valepo avademi vali khutama khufyalo valikudema ifipuga fya Ng'osi ncha vene pakhilo. ");
INSERT INTO zgam_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Gafla, usungwa va Nkuludeva akhavahumila, nu lumuli lwa Nkuludeva lukhamulikha ukhuvanchungula, pwu vakhava nu vudwanchi fincho. ");
INSERT INTO zgam_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pwu usung'wa akhavavula, mlekhe ukhudwada, ulwakhuva ni khuvagegela inongwa imonu iyuyigega uluhekhelo uluvaha khivanu voni. ");
INSERT INTO zgam_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ilelo umpokhi aholiwe khuliumwe mkhilunga kya Daveli! Umwene vi Nkristi Unkuludeva! ");
INSERT INTO zgam_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ikhi khyu khimanyilo ni khuvapa, mkumbona umwana apinyiwe imyanda igona mkhitanchi kya khulisihincha ifikanu.” ");
INSERT INTO zgam_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","14","Gafla khkha na avasikhali vingi ilya khukhyanya likhalungana nane usung'wa uywa valikunginia Unguluve, valinkuta, “Uvuvalanche vwa Unguluve uvyahikhu khyanya fincho nu hinonchehencho luve Nkilunga kuvoni uvu onongwa.” ");
INSERT INTO zgam_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pwu yikheva Avasungwa avile vahegile ukhuluta khukhyanya, avademi vakhincho fanji vako, “Tuvukhe lino kwu Betelehemu, tu khalole ikhinu ikhi ikhihumile, ambacho Bwana ametufahamisha.” ");
INSERT INTO zgam_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Vagaha khimbivi mbivi ukhu vakhembona Umaliya nu Yusufu, pwu vakha mbona nu mwana igona mu khetenchi kya fiko. ");
INSERT INTO zgam_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Vavila valolile evwo vakhavavula avanu ikyu vavuliwe khu mwana. ");
INSERT INTO zgam_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Voni avapulike inongwa iyi valikudega ikhichovivwe ni vademi. ");
INSERT INTO zgam_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pwu Umaliya alikupisaga khugoni ugwo apulikhe, akhagavikha munumbula ya mwene. ");
INSERT INTO zgam_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Avademi vakhavuya nu khuginia Unguluve kwu fyoni ifyu vapulikhe nu khulola, nduvu vwu lilikhuchovivwa khuvone. ");
INSERT INTO zgam_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kyavilekhefikhe ikhigono ikya nene gwale gunsikhi gwa ukhukeketa umwana, vakhamwilanga ilitavwa lya mwene vi Yisu, ilitavwa ilyu ampile unsung'wa vusahifikhe uvuchitu mwitumbu. ");
INSERT INTO zgam_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Inchavene inchilikulunchiwa uvuvalanche vu chilutile, ukhukongana ni ndagilo cha Mose, u Yusufu nu Maliya vukhangilikha khutembile khukhumbikha khuvulongolo kwa Nkuludeva. ");
INSERT INTO zgam_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Nduvu yisimbiwe mndagilo cha nuludeva, “Khila ngosi uvi idindula ilitumbu ikhwilangiwa uvinchumichiwe nekhelo kwu kuludeva.” ");
INSERT INTO zgam_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Na vope valikhwicha kwihumya inekhelo ukhukongana ni kyu khicho vivwa mu ndagila vha Nkuludeva, “Injiva au ifyana fya Njiva.” ");
INSERT INTO zgam_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Lola, pale nu munu mu Yelusalemu ailangivwaga vi Simeoni, umunu uyu ali nu wayilweli munu va Nguluve. Umwene alikupu likhila uvakuchesya mu Israeli, nu mepo umbalawe ale khumwene. ");
INSERT INTO zgam_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Yikhadenduliwe khumwene ukhugendela kwa mepo umbalache ukhuta umwene sakhale ifwa vwu sambwene Ukristi va Nkuludeva. ");
INSERT INTO zgam_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ikhigono ikhinge akhicha mgati mtembile, akhalongochiwa nu mepu umbalache upwu avahonchi vakhandata umwana, Yesu, ukhumbombela gala aginogiwa ukhukongana ni ndagilo, ");
INSERT INTO zgam_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","pwu Simoni akhamwupilila mmavoko ga mwene, akhaginia Unguluve nu khuta, ");
INSERT INTO zgam_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Lino ing'eche umbonbi vakho alutage nu lunochehecho lwa Ntwa, ukhuvongano ni limenyu lyako. ");
INSERT INTO zgam_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ukhwakhuva miho gango gavuwene uvupokhi vwakho, ");
INSERT INTO zgam_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","uvwo vuvonikhe pamiho gavanu voni. ");
INSERT INTO zgam_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Umwene ve humhli kuluvonekhelo khufihunga nu vuvalache vwa vane va Israeli.” ");
INSERT INTO zgam_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Udada ni mama va mwana vulikudeva imbombo ichilikhuchovi vwa kwu mwene. ");
INSERT INTO zgam_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Pwu Usimoni akhavasaya akhatakhwa Maliya umamaye, “Pulihicha vunonu umwana uyu yiva nongwa ya khuyancha nu khupokha kwu vanu vingi mu OIsraeli khange khimanyilo ikhyu ikhi avanu vingi ya vi becha. Khange panga iyu yikave yi nyanya inyivonelo chakho yuve, yive amasago ga numbula ya vingi yivonesye.” ");
INSERT INTO zgam_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Unyamalago udala uvialikwilanyiwa Ana nevopo alemwo mtembile. Umwene ale mwana va Fanueli ukhuhuma mkhivumbu kho kya asheri. Ale ni figono fingi ficho. Navope alikhutama nu gosi va mwene imiaka saba vuvatoline, ");
INSERT INTO zgam_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","pwu akha ijane imiakha themanini na minne. Navope sagala ahage mtembile alikhugendelela ukhudova Unguluve nu khudova, pakhilo na pamusi. ");
INSERT INTO zgam_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Khunsikhu ug'wa akhicha pala upwu valipwo akhatengula ukhundimya Unguluve. Alikhuchova inongwa cha mwana kwu munu nu munu uviavechaga uvialikhugulila uvupokhi vwa Yerusalemu. ");
INSERT INTO zgam_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Vuvamalile kila khila khinu ikhyu khinogiwa ukhuvomba ukhukongana ni ndagilo cha Nkuludeva, vakhakhivokha kwu Galilaya, kwu khilunga kya vene, Nazareti. ");
INSERT INTO zgam_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Umwana akhekula, akhava na makha, alikhukula nu luhala, nu luhunga lwa Nguluve lukhava khumwene. ");
INSERT INTO zgam_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Avahochi va mwene gunafike umwakha valikhula khu Yerusalemu kwu sikhukhuu ya Pasaka. ");
INSERT INTO zgam_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Avile iva ni miakha kumiho miwili, vakhaluta khange khu nsikhi gwa nyiho kwu sikhukhuu. ");
INSERT INTO zgam_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Vu vasigile isikhu choni kwu sikhukhuu, vakhatengula ukhuvuya khumiavo, pwu udemi u Yisu akha sigala khusana Myerusalemu khange avahochi savakhalumanya. ");
INSERT INTO zgam_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Valikhuta pwale alimlipuga ilivali kugendania, pwu vakhagenda ficho ulugendo lwa sikhu. Pwu vakhatengula ukhuhunela muvalukhulo lwavo, mvamanyani. ");
INSERT INTO zgam_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Vavile valemwile ukhumbona, vakhaki lwukha kwu Yerusalemu pwu vakhatengula ukhundanda umwa. ");
INSERT INTO zgam_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yikhahumila ukhuta vuchifikhe iskhu itetu, vakhambona Mtembile, achige atamila pagati pa vamanyisi, ikhuvapulihiche nu kuvavucha. ");
INSERT INTO zgam_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Voni uvuva mpulihiche valikhudega nu luhala lwa mwene ni nyandilo che mwene. ");
INSERT INTO zgam_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Vuvile vumbwene, valikudega. Uvanina akhambula, “Manango, khekhiutuvombile evwo? Pulihicha udada vakha nayune tulikhukhulonda nu vudwachi vuvaha.” ");
INSERT INTO zgam_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Akhavanda, “Khekhi mlikhondonda? Samukhalumanye ukhuta une nive kwu nyumba ya Dada vango? ");
INSERT INTO zgam_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pope savakhalumanya inogwa ukhuta khekhi mmanyu aga. ");
INSERT INTO zgam_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pu akhahega paninie na vene, ukhu fikha khumyavoyo kwu Nazareti khange ale mwidihichi khuvene. Uvanina akhavikha aga munumbula ya mwene. ");
INSERT INTO zgam_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Pwu Yisu alikhula nu luhala na kutoga, nu khuganiwa nu Nguluve na vanu. ");
INSERT INTO zgam_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Lino umwakha gwa kumi na tano ugwa nkilunga kesari Tiberia, imisikhi Pontio Pilati ale gavana va va yuta, Uherode alimbaha va nkoa gwa Galilaya, nu Filipo ulukololwe ale imbaha va unkoa gwa Iturea na kwu Trakoniti, na Lisania ale mmbaha va nkoa gwa Abilene, ");
INSERT INTO zgam_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","nu nsikhi gwa kuhani umbaha u Anasi nu Kayafa, ilimenyu lya Nguluve likha mwichela u Yohana umwana va Sakhaliya, khulunalawe. ");
INSERT INTO zgam_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Agendile unkoa gwoni ukhuchungula Inyanja Yolidani, alikhulumbilila ulwocho lwa khupela ulusyiekhilo lwa mbivi ");
INSERT INTO zgam_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nduvu yisimbiwe amemenyu mwa myamalago u Isaya, “Elimenyu lya munu uviilela mundunyikha, “Mnochage Injila ya Nkuludeva, Mnochage umwigendela umwene yigolokhage. ");
INSERT INTO zgam_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Amaguli goni gisyeliwa, ifyamba nu twamba finovhiwa, imisewe ugubendile gigolokha, ninjila imbivi chigolokha. ");
INSERT INTO zgam_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Avanu voni yavikhovovona uvupokhi vwa Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Pwo, Yohana akhavavula anyaulundamano uhivaha lwa vanu uvuvagendile lekhe vochiwe nu mwene, “Umwe mwi khipapo kya njokha muvele ni sumu veni uviavavolile ukhunjila uvuhigi uvuyakhave vukhwicha? ");
INSERT INTO zgam_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Holaga Isekhe khikongana nu lukhuto pwo mlekhe ukhuchova mgati nayomwe, “Tulinu Ibrakimu vi dada veto; ulwakuva ni khuvavula ukhuta Unguluve, iwesya ukhuhalila u Ibrahimu avana ndagave mawe aga. ");
INSERT INTO zgam_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Lino isokha yivikhivwe pa malela ga mmbikhi pwu lino umbikhi gwu gwoni ugusagwihola isekhe inonu, gugidiwa nu khutaga mmwoto. ");
INSERT INTO zgam_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Pwu avanu palulundamano vakha mbucha vakhata,” Pwu yinogwa tugahendakhikhi?” ");
INSERT INTO zgam_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Akhavanda akhata, “Umunu unyalini khanzu ivili ahumye yimo ampe uyunge uvialivuvule ficho ingave alini khyalya agahe evwo.” ");
INSERT INTO zgam_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pwu avange avasonga songa vakhicho khwukwochiwa, pwu vakhembula, “Immanyiai, Tunongivwa tugale ndakhekhi? ");
INSERT INTO zgam_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Akhavavula, “Mlekhe ukhutola indalana nyingi ficho icho sayinogiwa ukhutola.” ");
INSERT INTO zgam_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Avange avasikhali navope vakha mbucha, “Na yufwe? Tulondiwa tugahe ndakhe khi?” Akhavavula mlekhe ukhutola khumunu uvi avechaga khumakha khange mlekhe ukisile khumunu uvi avechaga kuvudesi, mkelage ni misahala gyimyo.” ");
INSERT INTO zgam_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pwu lino ulwakhuva avanu vukhale nuvunogwqe vwa khugula u Kristi uviye khave ikwicha, khila akhava isaga munumbula ya mwene ukhuta u Yohana pange iva vi Kristi. ");
INSERT INTO zgam_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","UYohana akhanda akhavavula voni, “Une nikhuvocha umwe na magasi, pwu kwali umpamato ayikwicha uvi alinamakha khulina, khage saninogile ukhuvupola imilegeha gya fikato fya mwene ikwu vocha umwe nu mepo umbalache nu mwoto. ");
INSERT INTO zgam_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Uluhelo lwa mwene lulimmavokho ga mwene ukhonocho vunonu uwanda vwa mwene nu ukhupetela mgano nu khulundamania nkibana kya mwene. Pwu, ayinyunyania amapunji nu mwoto ugwu sagichima. ");
INSERT INTO zgam_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kumavungu agange mingi khange, alikhulumbilila inongwa inonu kwa Yesu. ");
INSERT INTO zgam_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","UYohana akhadukha khange khwa Herode umbaha va nkoa pa khutola u Herodia, ichinge nyingi icho Herode alikhuvomba. ");
INSERT INTO zgam_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pwu khuvulongolo u Herode akhavomba uvuvivi uvunge uvuvala ficho akhandindila uYohani mligelesya. ");
INSERT INTO zgam_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pwu yikhahumila ukhuta, unsikhu avanu voni upwu valikhwochiwa nu Yohana, na yu Yisu alikhwochiwa. Unsikhi upwa likhwisaya, khukhanya khukhadi ndukha. ");
INSERT INTO zgam_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Umepo Umbalache akhikha pakhanya pa mwene ikhwoni kya khivili vili kifane njiva, unsikhi gugugwa ilimenyu likhicha ukhuhuma khukhaya iyitu, “Uve mwana vango ugane, ndiganile ficho na yue.” ");
INSERT INTO zgam_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Pwu u Yisu yuywa avile tenguluve ukhumanyisya akhale ni miakha salasini. Ale mwana (nauvu yivalile) uva Yusufu, mwana va Eli, ");
INSERT INTO zgam_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","mwana va Mathati, mwana va Lawi, mwana wa Melki, mwana wa Yana, mwana wa Yusufu, ");
INSERT INTO zgam_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Mwana va Mtathia, mwana va Amosi, mwana va Nahumu, mwana va Eli, mwana va Nagai, ");
INSERT INTO zgam_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","mwana va Maati, mwana va Matathia, mwana va Semeini, mwana va Yusufu, mwana va Yuda, ");
INSERT INTO zgam_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Mwana va Yoanani, mwana wa Resa, mwana wa Zeerubabeli, mwana va Shealtieli, mwana va Neri, ");
INSERT INTO zgam_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mwana va Melki, mwana va Adi, mwana va Kosamu, mwana va Elmadamu, mwana va Eri, ");
INSERT INTO zgam_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","mwana va Yoshua, mwana va Eliezeri, mwana va Yorimu, mwana va Matathi, mwana va Lawi, ");
INSERT INTO zgam_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","mwana va Simeoni, mwana va Yuda, mwana va Yusufu, mwana va Yonamu, mwana va Eliyakimu, ");
INSERT INTO zgam_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","mwana va Melea, mwana va Mena, mwana va Matatha, mwana va Nathani, mwana va Daudi, ");
INSERT INTO zgam_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","mwana va Yese, mwana va Obedi, mwana va Boazi, mwana va Salmoni, mwana va Nashoni, ");
INSERT INTO zgam_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","mwana va Abinadabu, mwana va Aramu, mwana va Hesroni, mwana va Peresi, mwana va Yuda, ");
INSERT INTO zgam_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","mwana va Yakobo, mwana va Isaka, mwana va Ibrahiumu, mwana va Tera, mwana va Nahori, ");
INSERT INTO zgam_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","mwana va Seruig, mwana va Ragau, mwana va Pelegi, mwana va Eberi, mwana va Sala, ");
INSERT INTO zgam_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Mwana va Kenani, mwana va Arfaksadi, mwana va Shemu, mwana va Nuhu, mwana va Lameki, ");
INSERT INTO zgam_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","mwana va Methusela, mwana va Henoko, mwana va Yaredi, mwana va Mahalaleli, mwana wa Kenani, ");
INSERT INTO zgam_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","mwana wa Enoshi, mwana va Sethi, mwana va Adamu, mwana va Nguluve. ");
INSERT INTO zgam_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Pwu, Yisu vwu adigile umepo umbalache akhakhuya ukhuma khu khihulu kya Yoldani, akhagegiwa nu Mepo Umbalache ");
INSERT INTO zgam_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kwu figono alubaini, ukwa alikhugeliwa nu setano. Unsikhi ugwa salikulya njala. ");
INSERT INTO zgam_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Usetano akhambula, “Ingave uveve ulimwana va Nguluve, pinelula iliwe live nkate.” ");
INSERT INTO zgam_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","UYisu akhambula, “Yisimbiwe; 'umnu sakhatame nu nkata vuvule.” ");
INSERT INTO zgam_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pwu setano akhandogocha kwu vu malilo vwa kyamba akhambonesya uvutwa, vwoni wa khilunga kwu nsikhi unsupi. ");
INSERT INTO zgam_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Usetano akhata ni khukhupa, “Nikhukhupo uvwa yilweli vwa khalongocha uvuvaha uvwu woni paninie, nu vuvaha vwa pene. Nigaha evwo ulwakhuva foni amile one mfidemage, nu khumpa umunu uvininogwa ukhumpa. ");
INSERT INTO zgam_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Pwu lino, ingave vugundama ni kwisaya, ifinu ifi fyoni fiva fyakho.” ");
INSERT INTO zgam_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pwu Yisu akhanda akhata, “Yesimbiwe, “Vwisayage kwa Nguluve vakho, nu khumbombela umwene vuvule.” ");
INSERT INTO zgam_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pwu setano akhandongocha u Yisu khu Yerusalemu nu khumbikha pakyanya ficho pu nyumba ya tembile nu khumbula, “Ingave uveve ulimwana va Nguluve, ila hilile pasi ukhuhuma apa. ");
INSERT INTO zgam_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ulwakhuva yisimbiwe, “Ilagicha avasungwa va mwene va khuvikhe nu khukhudima, ");
INSERT INTO zgam_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","hange yavikwukwinola mmavokho gavene ulekhe ukhulemala amalunde gakho nilivwe.” ");
INSERT INTO zgam_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","UYisu akhanda akhata, “Lichovivwe, “Ulanngela ukuludeva Unguluve vakho.” ");
INSERT INTO zgam_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Usetano vwa malile ukhugela u Yisu, akhahega nu khundekha upwu gufikhaga unsikhi ugunge. ");
INSERT INTO zgam_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pwu Yisu akhavuya kwu Galilaya na makha ga mepo, ni nongwa cha mwene chikhaluta ifikongo fyoni ifili paninie. ");
INSERT INTO zgam_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Alikumanyisya mtembile cha vene, pwu munu nu munu alikhuginia. ");
INSERT INTO zgam_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ikhinge ikhigono akhaluta Mnazareti, ikhilunga ikhyu atamile nu khu kila, neluvuyivile ulwiho lwa mwene akhingela mtembile ikhigono kya sabato, pwu khima ni kwimba uvusimbe. ");
INSERT INTO zgam_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Vakhampa iligombo lya nyamalogo u Isaya, pwu, pwu akhadindula iligombo, nu khulonda upwu yisimbiwe, ");
INSERT INTO zgam_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Umepo va Nkuludeva alipakyanya paliune ulwakhuva ambakhile i mono ukhulumbilila inongwa inonu kwu va lemilwe. Asuhile kuvavula uvuvopolwe kwuvakungiwe ukhuvavikha uvusa vilola valolage khange. Ukhuvavikha mbuvapolwa avigatachivwa, ");
INSERT INTO zgam_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ukhuvavula umwakhe ugwu ukhuludeva ikhovavonesya ulugano lwa mwene.” ");
INSERT INTO zgam_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pwa akhadinda iligombo, lya mwene akhankilivolela undongochi va tembile, pwu akhatama pasi. Amiho ga vanu voni uvuvala mu tembile valikundola umwene. ");
INSERT INTO zgam_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Akhatengula ukhuchova navo alikhuta, “Ilelo uvusimbe uvwu vufkhe mu mbulukhutu chenyo.” ");
INSERT INTO zgam_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Pala khila munu alikhulola ikyu alikhuchova u Yisu, nu vingi uvuvalepwo valikhudega na mamenyu ga luhala ugwa galikhu kumo mundomo gwa mwene. valinkuta, “Uyu mwana vuvule va Yosefu, savu yilivwo?” ");
INSERT INTO zgam_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","UYisu au havavula, “Lweli yamwichova ikhihnicho ikhi kyulyune, 'Uliganga iponie yuve. kyoyoni ikyutupulikhe ulikhuvomba kwu kapernaumu, uvombe pakhijiji kyakho apa.” ");
INSERT INTO zgam_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Khange akhata, “lweli nikhuvavula umwe, asikhuli unyamalago uvevi khumwidikha mkilunga kya kya mwene.” ");
INSERT INTO zgam_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Pwu nikhuvavula umwe lweli ukhuta valipwo avalekhwa vingi mu Israeli imisikhi gya Eliya, khukhanya kwa dindiwe khulekhe ukhuva ni fula imiakha kidatu ne nusu, vwukhulini njala imbaha ikhilunga kywoni. ");
INSERT INTO zgam_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Khange u Eliya sakhasuhiwe kwu munu nuvalyumo, pwu khunde kwa yumo vuvule uviatamaga Mselepta pipi na khunji ni ugwa Msidoni. ");
INSERT INTO zgam_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Khange, vale ekhwo na boba vingi imiakha gya Elisha unyamalago, pwa asikhuli nuvalyomo uvi aponile yu Naamani umunu va msiria. ");
INSERT INTO zgam_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Avanu voni mgati mutembile vadigile ilyoyo vavile vipulikhe aga goni. ");
INSERT INTO zgam_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Vakhima nukhu kuhugecha khunji khujini, nukhundungocha ukhufikha kuvumelilo vwa jini upwu ujini kwa vene kwa chengiwe khukyanya, pwu vantage pasi. ");
INSERT INTO zgam_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pwu akhaluta vunonu pagati pavene akhilutila. ");
INSERT INTO zgam_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Pwu khikha mu Kapernaumu, mjini ugwa Galilaya. Isabato yimo alikumanyisye avanu mgato nu mtembile. ");
INSERT INTO zgam_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Valikudega nulumanyisyo lwa vene, ulwa khuva alikhumanyisya khu makha. ");
INSERT INTO zgam_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Pwu ikhigono ikhyo mgati mtembile, ale epwo umunu unyamepo imbivi, pwu akhalila khulimenyu ilya kukhyanya, ");
INSERT INTO zgam_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Tulinikhekhi nuve, Yesu va Mnasareti? Wichile kukhotuyocha? Nihemanyila uve veve veni! Veve mbalache va Nguluve!” ");
INSERT INTO zgam_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","UYisu akhadukha khumepo akhata, “Nunala mye, khange uhume mu munu oyu!” Imepo ila yikhataga umunu ule pasi pagati pavene, akhahuma mu munu khange sakivone uluvavo. ");
INSERT INTO zgam_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Avanu voni valikudega, khange valikupichova imbombo iyo umunu nu nunine. Valikuta, “Gomanyu makhi aga?” Ilamula imepo imbivi khuvutwa na makha vevihege.” ");
INSERT INTO zgam_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Pwu, imongwa cha Yisu chilikhuluta kwoni mu khilunga ikhichongotile unkoa ugwa. ");
INSERT INTO zgam_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Pwu Yisu akhahega mjini vgwa pwa akhingela munyumba ya Simoni. Pwu, unkwive nu Simoni alikhuva vivwa ihoma ingali, pwu vakhammbembelesya avange. ");
INSERT INTO zgam_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Pwu, u Yisuakhang'elelela, akhadukha ihoma yikhandekha. Pwu akhima akhatengula ukhuvavombela. ");
INSERT INTO zgam_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ilichova vulikhwingela, avanu vakhendetela u Yisu umunu nuvotamu vwa uvwavechaga. Alikhuvikha amavokho gamwene pa kyanya pa ntamu pwu vakhapona voni. ");
INSERT INTO zgam_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Imepo chope chikhavahumaavingi vali kulila kwu elimenyu nukhuta, “Uve veve mwana va Nguluve!” UYisu akhadukha imipepo nukuvavula vachove, ulwakhuva valumanyile ukhuta umwene akhala vi Kristi. ");
INSERT INTO zgam_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Unsikhi vu khutandalukha, akhaluta ukhuvasikuli na vanu. Ululundamano lwa vanu valikhundonda pwu vakhichaukwu likwo. Vagela ukhukihivula alekhe ukhuluta khutali na vene. ");
INSERT INTO zgam_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pwu akhavavula, “Lasima nilumbilile ilimenyu ilinonu lya vutwa vwa Nguluve mu miji iginge mingi, ulwakhuva khyu mene nisuhivwe apa.” ");
INSERT INTO zgam_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Pwu alikhuluta khulumbilila mgati mtembile mumbuyahudi mwoni. ");
INSERT INTO zgam_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Pwu lino gukhahumila unsikhi avanu upu valundamine nu khunchungula u Yisu nu khupulihicha ilimenyu lya Nguluve, upwu akhimile palukanji mndisiva lya Genesaleti. ");
INSERT INTO zgam_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Akhavuvona uvwato vuvili vwimile khulukanji khulisiva. Avilova vakhavile vahumile pwu valikusukha inyafu cha vene. ");
INSERT INTO zgam_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","UYisu akhingila mmbwato vumo uvwa Simoni nu khudova ahilikhe mundugasi patali padebe na khuvulagafu. Pwu akhatama nu khumanyisya ukhuhumile khuwato. ");
INSERT INTO zgam_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ukhuchova akhambula u Simoni, “Hilikauwato wako pamagasi pagati nu khwisya inyafu chakho pwalove isomba.” ");
INSERT INTO zgam_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","USimoni akhanda akhata, Ikuludeva, tuvombile imbombo ikilo yoni, salukhibate, kwu limenyu lyakho, nikwisya inyafu. ");
INSERT INTO zgam_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Vavugahile evwo vakhahundamania isomba nyingi ni nyafu chavene chakhatengula ukhudumukha. ");
INSERT INTO zgam_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Pwu vakhavavula avayavo avakhuvwato uvunge viche khutangila. Vakhiche vakhadicha uvwato vwoni, chikhatangula ukhuyuvama. ");
INSERT INTO zgam_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pwu Simoni Petro, avile alolile evo, akhagwa pa mafugamilo ga Yisu akhata, “Hega khuliune, ulwakhuve une nilumunu ntulanongwa Inkuludeva.” ");
INSERT INTO zgam_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ulwakhuva valikudega, ne voni uvuvalipwo nu mwene, pakhulova isomba uvuvakhavombile. ");
INSERT INTO zgam_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ili likhavalundaminio uyakhobo nu Yohana umwana va Sebedayo, uvu ava vakhale paninie nu Simoni. Nu Yisu akhambula u Simoni, “ulekhe ukhudwada, ulwakuva ukhuhuma lino vulutoga kwilova avanu.” ");
INSERT INTO zgam_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Vuvavile valelile vwato khuvuchila lugasi, vakhakhikha kila khinu nu khunkonga umwene. ");
INSERT INTO zgam_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Pwu yikha humila ukhuta ujini gumo, umunu uvia digile iboba ale ukhwa. Unsikhi avile ikhumbona u Yisu, akhagwa akhinamila amiho ga mwene mpakha pasi nu khutova, akhata, “Inkuludeva, ingave vwinogwa, wiwesya ukuhumbalacha.” ");
INSERT INTO zgam_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Pwu Yisu akhagolola ikhivokho kya mwene nu khumwabasya, akhata, “Ninogwa. Valela.” Unsikhu gula gula ibuba yikhandekha. ");
INSERT INTO zgam_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","“Akhandagila alikhe ukhumbula umunu pwu akhambula, “Lutaga ukhavonesye, kumakuhani nu khumie isadaka ya vuvalacho vwakho, khi hwanini nu lulagilo lwa Mose ukhulola khuvene.” ");
INSERT INTO zgam_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pwu inongwa icha mwene chukhaluta khuvutali ficho, ni khipuga kya vanu khekhicha paninie khukho mpulihicha vwi manyisya nu khuponia amatamu gavene. ");
INSERT INTO zgam_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pwu imisikhi gyoni alikwiyepusya khuvutitu nu khwisaya. ");
INSERT INTO zgam_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pu yeikhava mumanchuva ngala eilinchuva leimo pu amanyisyangha, ava Farisai navamanyisi vanda ngeilo valaamile baho, avuvahumile muvunchenghe vwoni uvwa Mungalileya na mumbu Yuta, na khu Yelusalemu. Pu navuvuvahaha wa Nkuludeva vwalepwo ukhuta pwa ponianghe avatamu. ");
INSERT INTO zgam_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Avanu valive vakhancha, vagegde mulitefu umunu uvei aposinche, vakhalonda einjila ya khu mwing'eincha eigati va gonei pasi khuva longolo khwa Yisu. ");
INSERT INTO zgam_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pu leino vavile valemilwe apa khunghenda pakhuva pale pafinye pasipali apakhuluta avanu vale vingi eilipungha eilivaha, pu vakhatongha khukyanya khukanu pavakha pelelencha mumapamba angha khukyanya puvakhamwisya utamu mukhei hangha khya mwene panghati pavalongolo upu ale u Yisu. ");
INSERT INTO zgam_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Alolile uweedechi wayene, u Yisu akhaachove, “Imanyani, imbivi nchakho usyei khiliwe.” ");
INSERT INTO zgam_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pu leino avamanya kalata nava Farisai valeinkuta, vei veni uyu uveinchova amamenyu ngha imbedo, veni uvyaleinamakha ngha khusyeikheila inogwa, pu nyakhusyei kheila alei yu Nguluve mwene?” ");
INSERT INTO zgam_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","UYisu, wikhulumanya khekhi ikhyo visaga, akhavanda akhata khekhi mkhivucha vucha ili munumbula chinyo? ");
INSERT INTO zgam_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Khilekhu khejebepe ukhuta inongwa chakho chisyekheliwe nukhuta 'Ima ugendage?' ");
INSERT INTO zgam_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mlamanye ukhuta umwana va Adamu alinago amakha nkilunga ga khusiekhela inongwa, nukuvavula, 'Uveve sisimokha, tola ilitefu lyakho ulutage khu nyumba yakho.” ");
INSERT INTO zgam_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Unsikhi gugugwa akhasisimokha kuvulongolo khuvene pwu akhatola ilitefu lya mwene ilyu alikhugonela. Pwu alinkuvuya khu Unguluve. ");
INSERT INTO zgam_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Umunu nu munu alinkhudega nu khunginia Unguluve. Vakhadiga nu uvudwacji, nu khuta, “Tuchiwene imbombo cha khudega ilelo.” ");
INSERT INTO zgam_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Imbombo ichi vuchihomile, u Yisu akhahuma ukhwa akhambona unsonga songa uvialikwelangiwa Lawi atamile apakhusongecha isongo. Akhambula, “Ingongege.” ");
INSERT INTO zgam_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Pwu u Lawi akhavikha nu khunkonga, akhafilekha kila khinu khunsana. ");
INSERT INTO zgam_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ulawi akhavikha ikhyakha ikhiva na khu nyumbaya mwene iya Yisu. Vakhavepo asonga songo vingi navanu vingi vatamile na vene. ");
INSERT INTO zgam_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ava Mafarisai na vasimbi vavo vali kuvasikhitile avakonga, vali uta, “Khekhi mwilya nu khunywa na vatule nongwa na vasonga songo na vanu avange avatula ningwa?” ");
INSERT INTO zgam_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","UYisu akavanda, “Avanu avanonu savilonela uganga, vala aratamu vu ya vikhondanda yumo. ");
INSERT INTO zgam_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Sanikhichile kukalonda avayihweli vapale hata nikhuviolanga avatula no ngwa vapele.” ");
INSERT INTO zgam_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Vakhavavula, “Avakongi va Yohana imisikhi gyoni nu valikhudinda nu khudova, avakongi va Mafarisai navope vivomba vule vule. Pwu avakongi vako vilya nu khunywa.” ");
INSERT INTO zgam_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","UYisu akhavavula, “Yiwesekhana umunu nu munu vala awafikhe khundoa ya nya ndoa widinda wu unyandoa vu bado pu paninie? ");
INSERT INTO zgam_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pwu ifigono fikhwicha unsikhi gwa nyandoayavikhung'echa kuvenu pwo ifigono ifyo yavidinda.” ");
INSERT INTO zgam_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Khange u Yisu akhachova navene kwu khihwani. “Asikhuli uvilekha na ikhupicha kya mwenda ukhuhuma khumwenda umpya ukhunocha khumwenda ugwa khatale. Ingave ngavombe evwo, ikhugolekha umwenda umpya, na ikhipicha kya mwenda ukhuhuma umwenda umpya sakhinogelanila ukhuvomba nu mwenda unkulu. ");
INSERT INTO zgam_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Khange, asikhuli umunu uvivekha idivai imya kufikopo ifya katale. Ingave ivomba ewo, idivai imya yikhale yibachola ikyombo, nayi divai yikhale yidudekha, ifichupa fikhala finangikho. ");
INSERT INTO zgam_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Idivai imya lunonu ukhuvikha mufichupa ifipya. ");
INSERT INTO zgam_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mwikho umunu vwa nywile idivai lya khatale, ukhunogwa imya, ulwakhuva ita, 'Iya khatale nonu.'” ");
INSERT INTO zgam_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pwu lino ikhahumila kwu sabato u Yisu alikugenda pagati pa kyalo kya finu na vanyasyule va mwene valinkuyava isocho cha finu, vakhasegeya na mavokho ga vene vakhalya ifinu. ");
INSERT INTO zgam_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Avange ava Mafarisai vakhata, “Khekhi mvomba ikhinu khikho salweli khi lulagilo ikhigono kya sabati?” ");
INSERT INTO zgam_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Uyisu, akhavanda, akhata, “Sangele mwembe ikyu Ndaveti avombile vwu aliminjala, umwene na vagosi uvwuvali paninie nu mwene? ");
INSERT INTO zgam_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Akhaluta munyumba ya Nguluve, akhatola imikhata imivalache ni iginge ukhyulya, ni iginge ukhuvatolela avanu avuale navo nu khulyu, gigyo gikhele gyu va Makuhani ukhulya.” ");
INSERT INTO zgam_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Pwu akhata, “Umwana va Adamu vi mbaha va sabato.” ");
INSERT INTO zgam_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ikhahumila isabato iyinge akhaluta kwu tembile nu khuva manyisya avanu ukwa. Alepwo umunu uvi ikhivokho kya mwene ikyandyo khika posiche. ");
INSERT INTO zgam_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Avamanyisi na va Mafarisai valikundola vunonu ukhulola ingave ayi kumponia umunu ilichova lya sabato, vayivone inyila ya khusi takho ukhuvomba imbivi. ");
INSERT INTO zgam_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Alumanyile khi khekhi ikyo visaga pwu akhata khwo mnu uvikhifula ikhivokho, “Sisimokha, ima apa pagati pa munu nu munu.”Pwa umunu uyo akhasisimokha nu kwima bahapo. ");
INSERT INTO zgam_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","UYisu akhachova kuvene, “Nikhuvavucha umwe, lweli ukhuvomba inonu kya apange ukhuvomba imbivi ukhupokha uwaomi au ukhunanga ikhigono kya sabato?” Akhavalola voni nu khumbula umunu, ");
INSERT INTO zgam_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","“Golosya ikhivokha kyako akhagaha evwu, ni khivokho kya mwene khikhapona. ");
INSERT INTO zgam_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Vakhadiga ne ilyoyo valikwichofya nja vavo vagahe ndakhekhi khwa Yisu. ");
INSERT INTO zgam_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ikhahumila isikhu kho icho alotile khwu khyamba khukhisaya. ikilo yoni alikundova Unguluve. ");
INSERT INTO zgam_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Vuvukila akhavilanga avasyule va mwene ku mwene, na mbili avange akhavilanga, “Mitume.” ");
INSERT INTO zgam_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Amatewa ga va mitume gu aga Simoni(uvi alikhumwilanga Peteli) nu Andeleya ikhikolo kya mwene, u Yakobo, u Yohana, u Filipo, Bartolomayo, ");
INSERT INTO zgam_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mathayo, Tomaso nu Yahobo mwana va Alfayo, Simoni, uvivali kumwilanga Zelote, ");
INSERT INTO zgam_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuta mwana va Yakobo nu Yuda Iskariote, uviale insongelehani. ");
INSERT INTO zgam_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","UYisu akhikha paninie na vene ukhuhuma khu khyamba nu khwima paluvindi ikhipuga ikhivaha kya vakongi va mwene vale ukho, paninie ni khipuga ikhivaha kya vanu ukhuhuma khuvuyahudi na khuyerusalemu na khulukanji mu Tiro na khu Sidoni. ");
INSERT INTO zgam_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Vakhicha khupulehecha nu kunia uvutamu vwa vene. Avanu uvu valikugatachiwa ne mipepo imivivi vakhevaponia. ");
INSERT INTO zgam_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Umunu na munu pakhipuga ikyo alikhugela khwu mwabasya, ukwa kuva amakha ga khuponia mgati nmwene, akhavaponia voni. ");
INSERT INTO zgam_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Pwu akhalola avakongi va mwene, nu khuta, “Msayiwe umwe mwimvile vagachu, ulwakhuva uludeva lwa Nguluve lwinyo. ");
INSERT INTO zgam_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Msayiwe umwe mwemvile ne njala lino, ulwakhuva ya mwihekha. ");
INSERT INTO zgam_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Msayiwe umwe mwi avanu yavi khuvakalila nu khuvatenga, umwe ukhuta mlivavuvu, kwu nongwa ya mwana va Ndaveli. ");
INSERT INTO zgam_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Hovokhanga isikhu iyo nu khuchumba chumba, ulwakhuva lweli ya mwiva nu luhombo luvaha khu khyanya, ulwakhuva avadade va veve vavavombile evo avanyamalago. ");
INSERT INTO zgam_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Lwinyo umwe mwemvile vatayili! Uhwakhuva mpatile ulucheso lwanyo. ");
INSERT INTO zgam_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Lwinyo umwe mwemwigwite lino! Ulwakhuva ya mwivona njala kuvolongolo. Lwenyo mwe mwiheka lino! Ulwakhuva ya mkuta nu khulila khuvolongolo. ");
INSERT INTO zgam_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Lwinyo umwe, mwiyaakhave mginiwa na vanu voni! Ulwakhuva udada va vene vavavombile avamanyalago va vodesi vulavula. ");
INSERT INTO zgam_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Nichova khuliomwe mwemkhumlihicha, vaganage uvumsoline nu khuvomba inonu khuvala avavikhuvakalalila. ");
INSERT INTO zgam_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Vasayage vala avavikhuvakotola umwenu khuvadonela vala avavikhuvavonela. ");
INSERT INTO zgam_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Khumwene uvi ikhakhota uvuchuga vumo, impendulile nu wa vili. Ingave umunu ipokha ilijoho lyakho ulekhe ummbecha ni kanju. ");
INSERT INTO zgam_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Umpichaga uvidova. Ingave umunu ipokha ikhinu khyakho, ulekha ukhudova akhukilivolile. ");
INSERT INTO zgam_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nduvumwinogwa avanu vavavombele, nayumwe vavombele vole vole. ");
INSERT INTO zgam_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Mngavagane avanu uvumvaganile umwe uhwa lwokhelo lukhikhulyumwe? Ulwakhuva navavatula nongwa vikhuvagana vala avava ganile. ");
INSERT INTO zgam_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ingave mkhuvavombela inonu kala uvavikhuvavombela inonu umwe, vule vule luhombo lukhi khu lyumwe? Ulwakhuva navatula nongwa vigaha vule vule. ");
INSERT INTO zgam_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ingave vukhumwachimela umunu ekhenu uvivukhihuvila khukilivola, vue vule luhombo lukhi khuhomwe? Navavatula nongwa, vikhihuvila ukhupila khikhikyo khange. ");
INSERT INTO zgam_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pwu vaganage uvumlingofyo nu khuvavombela inonu. Vachimelage mlekhe uvudwachi khunongwa ya khukilivola, nu luhombo lwinyo lwiva luvaha. Mwiva vana va pakhianya, tu ulwakhuva yumweni vinonu khu vanu uvuvachila nu lusano na vavivi. ");
INSERT INTO zgam_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mvichage ni khisa, nduvu eDada vinyo vwalimkhisa. ");
INSERT INTO zgam_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Mlekhe ukhuhiga, nayumwe sayamhegiwa. Mlekhe ukhukotola, na yumwesaya mkotoliwa. Syiekhilaga avange, nayumwe msekhiliwa. ");
INSERT INTO zgam_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Vapichage avange, nayumwe mwipata. Ikhigelo kya vudekhe dekhe - uvusindile, nu khukihina nu khududekha - khidudekha mmafugamilo ginyo, ulwakhuva khugelelo kyokyoni ikyo mgelela ikhupima, ikhigelelo khikhikyo ya khimbekha ukhuva gelela umwe.” ");
INSERT INTO zgam_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Pwu akhavavula ikhihwani. “Akhata Umunu uvi abofwile ikhundongocha umunu uyunge uvia abofwile? Ingave avombile evwo, pwu voni vakhale vikhwingila mliguli, je savakhale vikhwingela? ");
INSERT INTO zgam_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Uva syule sakhave mmbaha ukhuhutilila umanyisi va mwene, pwu umunu angamanyisiwe vononu iva imanyisi va mwene. ");
INSERT INTO zgam_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ikhekhi wilola ikhibanji ikhiligati mliho lya lukolohwo, ni libonti ililigati mliho lyakho sawilola? ");
INSERT INTO zgam_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Vukhwima ndapi ukhumbula uheko lolwo, lukholo hecha ikhibanji ikhigati mliho lyakho,'nayuve sawilola ibiboriti ililindiho lyako yuve? Ulidesi uve! Tala hecha iliboriti mndiho lyakho yuve, pwu wilola vononu ukhuhecha ikhibanji mndiho lya lukololwo. ");
INSERT INTO zgam_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ulwakhuva gusikhuli umbikhi unonu ugu gwihola isekhe imbivi, khange gusikhuli umbikhe umbivi ugwihola isekhe inonu. ");
INSERT INTO zgam_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ulwakhuva umbikhe gumanyikhikha msekhe cha gwene. Ulwakhuva avanu savitungula isekhe khuhuma khumidodi, khange savitungula isabibu ukhuhuma khumichongoma. ");
INSERT INTO zgam_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Umunu unonu mukhibana kya mwene ikhinonu ikya numbula ya mwene ihumya agavile amanonu, nu munu umbivi mkhibana kya mwene ikhivivi ikya numbula ya mwene ihumya amavivi. Ulwakhuva undomo gwa mwene khova gala ugugadigile munumbula ya mwene. ");
INSERT INTO zgam_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Khekhi mkhunyilanga, 'Ikolodeva, koludeva, 'wu samvomba igumichava? ");
INSERT INTO zgam_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Umunu uvikwicha khulivne nu khupulikha amamenyu gango nu khuvombela imbombo ni khuvavonesya umwanavelile. ");
INSERT INTO zgam_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ihwanana nu munu mnyumba ya mwene uvinyava pasi ficho, nu khujenga uhvutu lwa nyumba ya pakyanya pa lunalawe ulukapu. Vugikhwikha amapolomokho ga magasi agakhatova inyumba, sayili khutikhisekho ulwakhuva yi yikhache ngiwe vunonu. ");
INSERT INTO zgam_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Uvi ipulikha ilimenyu lyango salikhuli dwadwa ikhihwani kya pene vi munu uviachengile inyumba pakyanya palufumbe upwu lusipali uhwutu, ulugasiti vuhikhwicha na makha inyumba yagwile fivi ficho. ");
INSERT INTO zgam_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","UYisu wa malile khila khinu ikyu alikhuchova khuvanu uvuvalinkumpulihicha, akhingila mkaprinaumu. ");
INSERT INTO zgam_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ummbanda yumo va akida, uvi ale inonu ficho kumwene, ale intamu ficho ale pipi ukhufwa. ");
INSERT INTO zgam_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Vu apulikha inongwa cha Yisu, ua Kida ula akhansuha undongochi va vayuta, kukhodova iche amponie umbanda va mwene alekhe ukufwa. ");
INSERT INTO zgam_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pawipi nu Yisu, vakhandova nukhuta, “Anogile ukhuvomba ewo ku mwene, ");
INSERT INTO zgam_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ulwakhuva akhiganile ikhilunga kyetu, khange viachengile ne tempeli yitu.” ");
INSERT INTO zgam_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","UYisu alikhuta nulugendo lwa mwene paninie na vene. Vusafike patali ne nyumba, umbaha yumo akhavasuha avamanyani kwichova nu mwene. “Imbaha, ulekhe ukwigatacho vi mwene ulwakhuva une saninogile uve ukwingila kwu kano yango. ");
INSERT INTO zgam_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ulwakhuva na yune sanikhasage ukhuta nayune ninogile ukwicha khulive, uve chova ilimenyu vuvule umbombi vango ipona. ");
INSERT INTO zgam_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ulwakhuva nayune nivikhiwe kuvuvaho nilina vasikhali pasi paliune. Ni ngati” Kutaniluta” Nuyunge ni ngata, icha”Ikwicha, na yumbombi vango, “Vomba ikhi” Navope ivomba.” ");
INSERT INTO zgam_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","UYisu avile apulikhe aga akhadega, nu khuvapindukhila avanyalulundamano uvuvalikhunkonga nukhuta. “Nukhutanikhuvavula, ata Muisraeli, sanegele ukhulola umunu unyalwidikho uluvaha ndulo. ");
INSERT INTO zgam_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Vala avakhasuhiwe vakhavuya khu myavoyo nukhumbona umbombi monu. ");
INSERT INTO zgam_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Vwa malile aga, ikhahumila u Yisu alikhugenda ukhuluta mu njioni gwa Naini. Avakongi va mwene vakhaluta paninie va khakongana ni khipuga kya vanu vanu. ");
INSERT INTO zgam_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Vu alipa khufika pa ndiango gwa muji, lola, umunu uviafwile va khagegile, umwana uvialimwene mwa khwa vanina. Uchila gosi, nikhipuga kya vikhumbikhilicha ukhuhuma kwu jini vakhale paninie. ");
INSERT INTO zgam_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Avile ambwene unkolodeva akhahegelela khukhisa ikhivoha ficho pa mwene akhata, “Ulalilaga.” ");
INSERT INTO zgam_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Pwu akhahegelela pavulongolo akhabasya ilisanduka ilyu vagegile umbili, vala avagegile vakhima akhata”Indume nita sisimokha” ");
INSERT INTO zgam_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Uviafwile akhasisimokha nu khutama pasi akhatengula ukhuchova. Pwu Yisu akhampa uvanina. ");
INSERT INTO zgam_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pwu uvudwachi vokhavibata voni. Valinkunginia Unguluve valikuta”unyamalago umbaha imekhiwe yumo indyufwe” nu '“Nguluve ikhuvalola avanu va mwene” ");
INSERT INTO zgam_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Inongwa ichiinonu icha Yisu chikhaluta mu Yudaa yoni ni filunga fyoni ifilipipi. ");
INSERT INTO zgam_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Avakongi va Yohana vakhembula goni. ");
INSERT INTO zgam_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Pwu Yohana akhavilanga avakongi vavili nu kuvasuha khu kuludeva nu khuta “UYohani umwochi atusuhile tugojele? ");
INSERT INTO zgam_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Vavila valipa khufikha pa Yisu avavakhata, “UYohani umwochi atusuhile khuliove tute, 'Veve vi ula uvikwicha apange khulimu munu uyunge tugojelage?” ");
INSERT INTO zgam_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Khusitakhi ugwa avaponiche avanu vingi ukhuhuma mbutamunu luvavo, ukhuhuma kwu mepo imbivi, na khuvanu uvusa vilola vali nkulola. ");
INSERT INTO zgam_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","UYisu akhavanda nu khuchova navo. “Vu mlotile ukhumuhamile mkhambula uYohana ikyo mlolile nu khupulikha. Uvusavilola vikwupilila ukhulola na afuguywike vigenda, avanya boba vivalachiwa, uvusavipulikha vipulikha, avafwile vichokha nu khuva vumi, avalemilwe vivoli wa inongwa inonu. ");
INSERT INTO zgam_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nu munu uvi ingave sikhundekha une kwu mbombo yango asayiwe.” ");
INSERT INTO zgam_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Vala avasuhiwe nu Yohani ukhukili vokha ukhuvahumile, Uyisu akhatengula ukhuchova na vanya nkutano kwu nongwa ya Yohana, “Mkhalutile khunji kwilola khekhi, ililanji walisikhanikha ni mepo? ");
INSERT INTO zgam_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","pwu mlikhuluta kweki, kwilola uviafwalila vunonu? Lola avanu vala uvuvifwala imyenda gya kuvutwa nu kutama uvutamo uvunonu valikhuvolongolo kuvutwa, ");
INSERT INTO zgam_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","pwu mwilola khunji kwilola khekhi unyamalango? Ena, nichova khuhumwe ficho ficho sayivile kyu myamalago. ");
INSERT INTO zgam_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Uyuviandikhwe, “Lola, nikhunsuha umbanda vango pamiho genyo, uviyakhave ivikha injila yango, ");
INSERT INTO zgam_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nichova khuhumwe, khuvala avaholiwe nu dala, asikhuli umbaha ndu Yohana, umunu yuywa savamana ficho uviyakhave itama nu Nguluve upwalipo umwene, iva imbaha pakyanya pa Yohani.” ");
INSERT INTO zgam_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Avanu voni vuvapolikhe aga paninie na vasongo songo, vakhatangasya ukhuta Unguluve viva yelweli. Vakhavepo vala avochiwe nu Yohana. ");
INSERT INTO zgam_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ava Mafarisai na avachimanyile indagilo cha va Yuta, uvasavakha chiwe nu mwene vakhabela uluhala lwa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Khange ni kuvahwananicha nikhe uhi ikhipapo ikhi? Lino mlinda khakhi? ");
INSERT INTO zgam_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Vihwanene na vana akyega khuluvingilo, lwa sokoni, uvuvitama nu kwilangana yumo yumo nu khuta, “Tupulile ifilimbi samlikhunema, tulikwililisya samli kulila.' ");
INSERT INTO zgam_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","U Yohana umwochi akhicha sakhalia unkata na khu khunywa idivai, mkhata”Alinimepo. ");
INSERT INTO zgam_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Umwana va munu ichile alile nu khunywa mkhata, “Ilye no igachi imanyani va vasonga songa na vatula nongwa! ");
INSERT INTO zgam_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pwu uluhala luvonikhe ukhuva khulinuwayelweli khuvana va mwene voni.” ");
INSERT INTO zgam_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Umfarisayo yumo akhadova u Yisu alute kwilya nu mwene. u Yisu wi kwingila mu nyumba ya Farisayo, akhalete ikhiyegamicha pa mesa pwu alye. ");
INSERT INTO zgam_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Pwu lola ale pwo undala yumo mu khijiji ikyo uviale itula nongwa akhalumanya ukhuta atamile kwa Farisayo, akhaleta ikichupa kya mafuta. ");
INSERT INTO zgam_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Akhima khunsana gwa mwene pipi na malunde gar mwene khunu ilila. Khange akhatangula ukhulove kha amalunde ga mwene, ni nyiho chi, nu khupulusya ni njwele chacha ntwe gwa mwene alikubusu amalunde, gamwene nu khulyema amanukhato. ");
INSERT INTO zgam_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ufarisayo ula uviamwilangile u Yisu avile awene ewo akhasaya yu ywa akhata, “Umunu uyu angale ave inyamalago akhale ikhulumanya uyu veveni khange idala muki uvikhumwa basya, ukhuta itula nongwa. ");
INSERT INTO zgam_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","UYisu akhanda akhata, “Simoni nilinikhinu kya kukuvula. “Akhata” “Chova vuvula imanyisi!” ");
INSERT INTO zgam_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","U Yisu akhata “Vala avo nya madeni vavili kwu viavakopile yumo. Uyunge alikudayiwa idinari miatano uvavili alikhudayiwa idinari hamsini. ");
INSERT INTO zgam_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Vakhavile valivuvula isilingibcha khuhomba akhavasyo khelo voni. Pwu veni uvikhugana ficho? ");
INSERT INTO zgam_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Usimoni akhanda akhata, “Nisaga uviasyekhelewe ficho.” UYisu akhambula, “Uhigile vunonu.” ");
INSERT INTO zgam_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","UYisu akhampendukhile udala nu khuchova nu Simoni, “Umbwene udala uyu. Niingile munyumba yako. Sakhame amagasi uyu ni nyihochi cha mwene, alovi khe amalunde gango nu khupukhuta ni njwele cha mwene. ");
INSERT INTO zgam_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Sakhambusu, umwene, ukhuhuma ikwingila umu sakhelekwile ukhumbusu amalunde gango. ");
INSERT INTO zgam_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Sakhabakhe amalunde gango amafuta, abakhile amalunde gango mafuta. ");
INSERT INTO zgam_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kwu ili, nikhu khuvula nita akhale ni nongwa nyingi asyekhaliwe ficho, khange akhanogilwe ficho. Pavuge uvyasiekheliwe padebe inogwa padebe vuvule.” ");
INSERT INTO zgam_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Pwu akhambula udala, “Inongwa chakho chisiekheliwe” ");
INSERT INTO zgam_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Vula avakhatamile pamasa paninie nu mwene vakhatangula ukwichofanja vavo kwa vavo, “Uyu veni isiekhela na chinongwa?” ");
INSERT INTO zgam_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","U Yisu akhambula udala, “Ulwidikho lwakho lukhupokhile. Lutaga nu lunochehecho” ");
INSERT INTO zgam_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yahumila unsikhi usupi u Yisu akhava nu lugendo mu miji ni mijiji fingi alikukumbilila nu khuvavula inongwa inonu icha ludeva lwa Nguluve na vala kumi na mbili vakhaluta paninie nu mwene, ");
INSERT INTO zgam_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","navavange avadala uvuva khaponile ukhuhuma kumepo imbivi nu mutamu ulipapingi. Vakhale vi Mariamu uviali kwilangiwa magadalena uvi va khahumiche imepo saba. ");
INSERT INTO zgam_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","UYoana udala va kuza nu numbaha va Herode, Susana, na vadala avange vingi, uvuvakhahumicha ifyuma fyavene. ");
INSERT INTO zgam_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Eikhipungha khya vanu vavile valundamine papanie ukhuhuma mwonimwoni mbunchenge, vu ava anchovangha navo mfihwananincho. Pa akhanchova eikheihwani akhata. ");
INSERT INTO zgam_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“alekhyo umunu uvei avyalyangha eimbiyu, avile ivyala, imbiyu inchinghe ncha nghwinchangha mundukanji munjeila pu avanu vakanya na malunde ifidenghe fya khukyanya fikhalya imbiyu incho. ");
INSERT INTO zgam_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Inchinge imbiyu ncha nghwile pang'ang'a unghwa palunalawe ncha vile nchimelile vuuchi kula punchilikhunialalukha ulwakhuva sapale na magasi. ");
INSERT INTO zgam_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Imbiyu inchinge nchikhanghwamumitwinyo pungheileinkula pupanie punchikheivunghuteila. ");
INSERT INTO zgam_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Puleino imbeyu inchinge vu ilaha pakhuvyala palinkunghwa mung'ang'a unghunya mbolela nchikhamotekha punchikhahola isekhe nchunyingi. “Pu u Yisu avile anchovile ndavule pu akhanchova neilimenyu eilivaha fincho akhata, “Ula uvyaleini mbulukhuta inchakhupuleikha puapuleikhanghe.” ");
INSERT INTO zgam_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Pu khange avakongi va mwene vakhambuncha ikheihwani eikhyo khyukhuta kheikhi, ");
INSERT INTO zgam_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","U Yisu akhavavula akhata, “Umwe muleihuba pakhuva munchimanyile nchila incha khuludeva lwa Nguluve. Pu leino avange vimanyeisiwangwa mfihwananincho, khuta pu vangalole valekhe ukhufivona, vangapuleikha valekhe ukhweliwa.' ");
INSERT INTO zgam_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Pu leino ikheihwananincho ikhei vakhiita, khukhuta. Eimbeyu lyulimenyu lya Nguluve. ");
INSERT INTO zgam_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Imbeyu nchila inchanghwile mundukanji munjeila vyu vanu avavipuleikha eilimenyu, pu ponghela undunghu usetano ikhwincha munumbula nvhavo puihencha eilimenyu leila eilyuvaleipulikhe ukhuta puvalekhe ukhulyeideikha nu khupokhiwa. ");
INSERT INTO zgam_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Pu leino nchiila inchanghwile palunalawe vyu vanu vala avipuleikha eilimenyu nu khulyupeileila nu luhekhelo pu leino valei vula milela eighya khweitotekha, puvikhweideikha paseikhei unghwa khunghelivwa puvinghwa. ");
INSERT INTO zgam_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nchombe imbeyu nchila incha nghwile mumatoni vyu vanu vala vavo vipukikha eilimenyu, pu leino inchankilunga nchikhuvapeinjeileihania imbombo incha vukavi ni fyuma nuvunonghwe uvwankeilunga pu savihola isekhe. ");
INSERT INTO zgam_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pu leino imbeyu nchincho ncha nghwile ming'anga unghunya mote pakhuva nghuleineimbolela vyu vanu, vala avadekhedekhe ni numbula inonu, vavapulikhe eilimenyu vikhulibaleileila nu khuleikonga puvihola ni sekhe incha khweliyumeleincha. ");
INSERT INTO zgam_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Pu leino asikhuli umunu na yumo, uvi iwasya einyali nu khunghubeikheila nei ndelema hange siveikha pasi pakheisanja. Pu iveikha pa kyanya pavuhanghufu pakheisanja ukhuta avanu vavikhwingeila vavenchanghe vanu vakhula vukhuvalafu. ");
INSERT INTO zgam_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ulwakhuva kheisikhuli eikheiyakheiva khifihama, leve lyu limenyu leilyo saleikhamange ikheikhe nukhuva pavavalofu. ");
INSERT INTO zgam_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Pu leino muvenchanghe vanu vakhupuleikha nukhunchingahe incha nchila unchuvu puleikha pakhuva avyalei na khyo, uywavifikhyongelelangha vikhupinchangha, pu ula uvyaleivuvula na kheilakheila eikheidebe eikhya leinakhyo puvipokhangha khyope.” ");
INSERT INTO zgam_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Pu leino uvaninemwe va Yeisu na valukololwe puvakhanduteila pasavahenghelele pamwene savuli ya kheipungha khya vanu eikhyanchunghutile. ");
INSERT INTO zgam_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Pu vakhambula vakhata, “Uvanine mwa vakho navalukololyo veimile panchi vilonda ukhwa nghanila nuve. ");
INSERT INTO zgam_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pu leino, u Yeisu akhata”, Ujyuva vango navalukolo lwango vyu vala avikhuleipuleikha eilimenyu lya Nguluve nukhuleikonga.” ");
INSERT INTO zgam_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pu yeikhava eiliinchuva leimo u Yeisu navakongi vamwene vakhingeila muvwato, pu akhavavula akhata, “Pu tulove khe einyanja tulute khumwambo, puvakhatesyania uvwato. ");
INSERT INTO zgam_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pu vavile valei munyanja vinghenda, u Yeisu akhanghonelela itulu pu umbelo umbaha nghukha tenghula ukhukulunghuta, pu uvwato vwavo vukhanja ukhudeingha amanghasi pa vakhavmumbupala uvwakhufwa. ");
INSERT INTO zgam_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Pu avakongi vamwene vakhaluta upwanghonile u Yisu vakhasisimula, vakhata, “Nkuludeva Nkuludeva! Tuleipakhufwa!” Pu akhasisimukha akhanghutaneila umbelo unghunyakulunghuto, pu amanghasi anghambelo nu kulunghuto nghakhalitama vuvule. ");
INSERT INTO zgam_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pu akhavavula akhata, “Ulwelideikho lweinyo luleindakhu?” Vakhadwada nukhudengha vavo kheila munu aleinkudeingha nukhuta, “Uyu vei munu, mukhi pakhuva umbelo nghwa manghasi anghanyakulunghuto nghikhupuleikha nukhumweideikha?” ");
INSERT INTO zgam_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Puvakha`nchifikhe khuvunchenge uvwa kheilunga eikhya Nghelaseni uvanchenge uvulei khulavafu ulwakhusana mu Nghalilaya. ");
INSERT INTO zgam_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Avile ahumile muvwato pukhava mukheilunga eikhya mwambo khunyanja pu akhanghanila nu munu umo uvambunghenge vula, pu umana uyu ale namakha nghamepo imbivi. Pa finghono fingi akhava sifwala eimyenda, hange saleikhuta munyumba, aleikhutama khuvunghuli vwa vanu avafwile. ");
INSERT INTO zgam_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Avile ambwene u Yisu pu akhakutafincho puakhanghwa pasi mbulungholo khwa Yeisu, akhakuta nukhyovela fincho aleikhuta, neivombile khinu kheikhi khulyuve, Yeisu vei mwana va Nguluve uvakhukyanya? Nikhukhudova, ulekhe ukhumbunga une” ");
INSERT INTO zgam_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Pu u Yeisu akhayeilangeila eimepo eimbivi akhata, humangha, ulwakhuva isikhunchoni umepo umbivi aleikhung'usania khyoni khyoni ukhwanukhwa. Pu avanine valeikhundolela nu khunkunga eiminyololo pwaleikhudumulania imepo imbivi nchilikhundongoncha impakha mundunkunghu mumakha ngha mepo ula. ");
INSERT INTO zgam_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","U Yeisu akhambuncha akhata, “Eiliyavwa lyakho veve veni?” Pu akhamula akhata, “Nene kheipungha” Ulwakhuva imepo imbivi nchunyingi nchingile mumwene. ");
INSERT INTO zgam_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Pu imepo imbivi nchisikhupisima khwa Yeisu ukhuta siwo ulekhe ukhututangha munghunghenge. ");
INSERT INTO zgam_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Pu leino khyale epwo eikheipungha khya nghube eikhivaha kheikhalya eilinyasi pakhyamba. Puvakhaduva nu khusima ukhuta avatavulile vinghile munghube incho pu u Yeisu akhavatavula munghube incho. ");
INSERT INTO zgam_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Pu leino imepo imbivi nchikhala uma khumunu ula panchikhingeila mu nghube nchile, pu eikhipungha kheila pukheikhei landaveikha palunghenge kheikheitangha munyanja nchikhadwiveila. ");
INSERT INTO zgam_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Avanu vala avadumangha einghube vavile vakheivwene eikheihumile ndavule puvakhava vanu vakhuluta nimbeilo nu khuvuleisya inongwa inchi mwoni mwoni khuvanu va mbunchenghe vwoni. ");
INSERT INTO zgam_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Avanu vuvapuleikhe inongwa ndenchi puvakhaluta khukheilolela vavo eikheihumila, puvakhincha khwa Yeisu vakhambona imbivi leino nchihumile pu umunu ula akhava ulunonghile. Akhava atamile pamalunde ngha Yeisu, puvakhadwada. ");
INSERT INTO zgam_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Pavala vavo valolile puvakhavavula inchihumila khumunu ula uveiakhanghatanchivwangha nu vulongonchi vwa mepo imbivi u aponile. ");
INSERT INTO zgam_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Avanu voni avakheihungha eikhya mu Nghelasini na mufilonga ifya ndukanchi pu khavona ukhuta u Yeisu ahenghanghe khuvene pakhuva vale nuvudwanchi uvuvaha. Pu akhingheila muvwato aleikhuvaya. ");
INSERT INTO zgam_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Umunu ula uvei imepo chahumile puakhasima khwa Yeisu akhata vahenghanghe njeila. Pu leino u Yeisu akhambula akhata alutanghe khukaya ya mwene akhata, ");
INSERT INTO zgam_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Vuya khukaya yakho pu ukheisanghele nchila nchoni inchu u Yeisu akhuvombile. ");
INSERT INTO zgam_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pu U Yeisu avile, avuyile avanu eikheipungha vakhamwambeileila pakhuva voni valeikhunghuleila. ");
INSERT INTO zgam_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Pu akhavonakha nu munu umo uvu alilangivwanghwa vei. Yailo ale manyisi mbaha paninie navamanyisi munyumba ya khweisayeila. Yailo uyu avile afikhe pamalunde ngha Yeisu pwaeikhwaeibeilusya nukhusima ukhuta idova alute pakaya ya mwene, ");
INSERT INTO zgam_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","pakhuva alei nu mwaleive umo vuvule uludeingha unymiakha kheinchingo na ngheiveilei aleilamu fincho nduvyaleipakhufwa. Pu u Yeisu avile iluta eikheipungha khya vanu kheileikhu mbunghuteileila. ");
INSERT INTO zgam_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Hange na Yudala umo uveiavenchangha khwimali ifinghono fyoni eimiakha kheinchingho neingheiveilei pu nakheikhyuma khyamwene amalile khuvanghanga alepwo pakhipungha kheila, pu asikhuli na yumo unghanga aveiayavile eilimali lyamwene, Pu udala ula akhafuyenye lukha pakhelipunga ");
INSERT INTO zgam_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","akhanchiva pasana nghwa Yeisu akhabasya mukheihundwa khya Yeisu khumalunde. Pu akhasekhe ndakhaleikhu eilimali lya mwene leikhadungha akhava aponile. ");
INSERT INTO zgam_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","U Yeisu pu akhata, “Veeni uveianyabasinche?” Vooni vakhabela, pu u Peteli akhata, Nkuludeva, avanu avavakhuvunghuleilile nukhukhu kulungha.” ");
INSERT INTO zgam_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pu Yeisu leino akhata, “Umunu umo anyabasinche pakhuva neivwene ukhuta amakha nghavile mapepe nghasimuli ndyune.” ");
INSERT INTO zgam_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pu udala ula avile avwene ilemwa ukhweimyesya eikhyu avombile, akhahengelela pa Yeisu khunu itetema pu akhanghwa pasi akhava munu uvei ikheilata inchipelile ukhumwabasya nukhupona eilimali paalapala. ");
INSERT INTO zgam_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Pu leino u Yeisu akhata, “Eingh'ienja, ulwaideikho lwa kho lukhuponiche. Pu wei luteilanghe nulunonchehencho.” ");
INSERT INTO zgam_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Pu avile iinchova ndavule, umunu umo akhincha ukhuma khu kya ya ula umbaha vanyumba ya kweisayeila, akhata, “Umwaleivo amalile ukhufwa. ulekhe ukhunghatancha umanyisi.” ");
INSERT INTO zgam_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pu leino u Yeisu avile, apulikhe ndavuleakhamula akhata, “Ulekhe. Ukhudwada vweideikhevuvule navope ipokhivwa.” ");
INSERT INTO zgam_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pu leino avile afikhe pakaya nukhweingeila munyumba, pusantavuleile munu ukhwingeila paninie nu mwene, pu u Peteli, nu Yohani nu Yakobo, vise va ngh'eincha, nu vaninemwa veene. ");
INSERT INTO zgam_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pu avanu voni valeikhuleila nukhyovela savuli ya mwana ula uvyafwile, pu u Yeisu akhata, “Mulekhe ukhyovela, safwile, anghonelile vuvule.” ");
INSERT INTO zgam_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pu leino avanu vakhang'ekha nukhubedana, pakhuva valumanyile ukhuta afwile. ");
INSERT INTO zgam_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pu umwene, u Yeisu akhamwibata ikhivokho u ngh'eincha ula, pu akheilanga neilimenyu eilivaha akhata, “Vei mwana, uve sisimukha” ");
INSERT INTO zgam_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","pu u mwuyu nghwa mwene nghukhakilivukha, pu akhasisimukha useikhei nghulanghula, pu akhalangheila akhata vampe kheininie alye. ");
INSERT INTO zgam_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Avahonchi vamwene vakhaswingha, pu leino akhavavula ululangeilo ukhuta valambu langha munu inongwa inchi. ");
INSERT INTO zgam_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Avilangile vala khnche na vavili pupaminye, avapile uluhala nu vulweli uwa masetano nu kuponyiy avatamu. ");
INSERT INTO zgam_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Akhavasuha ukhuluta kuluvubilila uvutwa wa Nguluve nu khuponiya avatamu. ");
INSERT INTO zgam_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Akhavavula, “Mlatolaga ikhya venjaga khu njila yinyo luve lubikhi, na gupakho, nu khata na nchi ndalam naliligwanda. ");
INSERT INTO zgam_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Inyumba nchoni inchiyakhiva mukhwingiela mtamage umwya isiku nchoni, mupakha upayikhiva mwichega aponu apo. ");
INSERT INTO zgam_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Khu vala avikhuvabela ukhu vapokhela, mungehegage apo, isanyanage lndukhulu lwoni mumalunde genyo nu khunjova khuvene.” ");
INSERT INTO zgam_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Vakhahega nu khuluta ikhu gendela mukhaya vuvunchova ilimenyu nu khuponiya avanu na nduvungilo. ");
INSERT INTO zgam_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Lino uvakhilunga u Herode, uvilolelaikhilunga, akhapulika agavonikhe, agatanchiwe lweli ulwakhuwa lyanehowiwe na vange ukhuta Yohani ikhwoncha anchukhile ukhuhuma khuguli, ");
INSERT INTO zgam_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Na vange, u Elia amalile ukhuhumila na vange panineye na vanyamalago avakhalale au chukhile khuvuguli. ");
INSERT INTO zgam_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","U Herode akhata, “Nakhegite khura Yohani, lino uyu viweni uviyakhiva nikhupulikha uvunchofi? Nu Herode akha landa inchila iya khuvulona U Yisu. ");
INSERT INTO zgam_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Unsikhi ugwa vuvakhiliwekhe vala avava sukhile, vakhambula khila khinu ikhivavombile. Akhavatola pipamuye, akhaluta mwene khu Bethsadia. ");
INSERT INTO zgam_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ulwakhuva ululundano valupulikhe vakhakhonga, nu khuvahegencha nu khunjova navo ukhuta uludeva ulwa Nguluve, nukhu vasaye avavidikhe ukhupokhiwa. ");
INSERT INTO zgam_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Liuchova likhasila, na vala khinjigo na vavili vakhaluta khumwene khukhunchova, “Vavahenchie avanya lulundamano walute khukhaya icha pawpimu juni vakalonde apakhugatalukha ni khyakhulya ulwakhuva puutule khulinyasi.” ");
INSERT INTO zgam_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ulwakhu akhavavula, “Umwe vakhanchova.”Tulivuvule ukhulutilila utuvungutulilo tuhano utwa khisyesye ne somba ivili, ulwakhuva tukhetwiluta nu khugula ikhikyakhila kya lulundamano ulwa vani.” Kwale na vagosi avaelfu vahano. ");
INSERT INTO zgam_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Akhavavula avakhangi vamwene. “Muvatamikhe avanu pasi kipuga avanu havisinihanisini. ");
INSERT INTO zgam_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Puvakhavomba evo pu avanu vakhatawa pasi khipugakhipuga. ");
INSERT INTO zgam_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Akhatola ifisyesye fivili akhalola khukyanya akhafisaya nu khumenyuluna tuvinituvini, nu khuvopa avakhangi, ukhuta vavagivile avanyalulunelamano. ");
INSERT INTO zgam_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Valile avanu voni vakhiguta nukhusigancha, amalagalila ga kyakhula, vakhalola nukhudincha ifitundu khinchigo na fivili. ");
INSERT INTO zgam_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Usikhi vuikhisaya alimwene, avakhongi vamwene vale paninie, nukhuvavuncha ukhuta, “Avanu vita une nene veni?” ");
INSERT INTO zgam_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Vakhanda vakta, “Vita veveYohani uvikhwoncha, na vange vinchova vita veve Eliya, nu yunge ita ulinyamalago nu uskhi ugwa khatale ulwakhuva anchokhile.” ");
INSERT INTO zgam_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Akhavavula, “Akhala umwe mwita une niene veni?” U Petro akhatave, “Kriste ukhuhuma khwa Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ulwakhuva, ukhuvavunga, ukhusita ukhunchova imbombo inchi, ");
INSERT INTO zgam_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Umwana va Adamu akhanchova akhata, huba ukhuvungiwa ne mbombo inyingi nu khubeliwa ne vagogolo na vavakha avakhilungana vavingi, ukhuta ibudiwa ne sikhu uyadatu inchokha. ");
INSERT INTO zgam_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Akhavavula voni, “Akhata umunu anganogwe ukhungonga ihumye yuywa, atole ikhhikovekhano khu ifigono fyoni ang'onge. ");
INSERT INTO zgam_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Uvanchage agelale ukhugapokha imitamilo ayikhugayancha, luno uvavenchaga uviikhugayancha initanilo gujamwene mukhupilila khuvuvaha wango, ayipokha imitanulo gyaniwene. ");
INSERT INTO zgam_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Lino khikhutanga khikhi umunu, angave ikhupila inchakhilunga nchoni, upu iyancha nukhuwopila uvuvivi munubili gwamwene? ");
INSERT INTO zgam_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Uvavenchaga ikhumbonela isoni une na mamenyu gango, khumwene, umwana va Adamu ayikhumbonela isone upuyakhiva khuvuvalanche, nu vuvalanche wa Dada na vasugwa avavalanche. ");
INSERT INTO zgam_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Lino nikhuvavula uvuwa jilweli, khuvale avannge khulwimwe savalafwa, bakhu alava ikhuvuvona uvutwa wa Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Neha fike isikhu khunsi khi u Yisu akhanchova amamenyu ukhuta akhavatola paninye u Petro, Yohana nu, Yakobo, vakhatoga khukyamba khukhisaya. ");
INSERT INTO zgam_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Usikhi uguale pagwisaya, uvuvonekhi wa miho wahambwikhe, nagimweyenda gwiyahambwikhe, gikhava miwalafu nukhulangala. ");
INSERT INTO zgam_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Lola, pale na vagosi vavili u Mose nu Eliya, ");
INSERT INTO zgam_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","valikhunchova nave, Vavonikhe khu vuvalanche. Vanchovaga ukhega kwamwene, yalembombo yakhuhegelela ukhumala khu Yelusalemu. ");
INSERT INTO zgam_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Lino u Peteli na vanine avu vale paninie vale ni tulo inchitu. Lino vuvasisimwikhe, vakhavuvona uvuvalanche, na avagosi vawili vaimile pupaniny nu mwene. ");
INSERT INTO zgam_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Yikhahumila ukhuta, vuvihega khwa u Yisu, Petro akhanchova, “Itwa, lunavu khulyufwe ukhutama bahapa yinogyiwa tunchenga ifivanga vitatu. Ikyavi Yisu ikya Eliya nu Mose, “Salumanye ikhianchovaga. ");
INSERT INTO zgam_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Usikhi uguanchovaga ago, likhinchailifunde; likhavagubikha vakhadwadavuvilola viwonavanjonguliwe na mafunde. ");
INSERT INTO zgam_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Inyilango ikhaluma khumafunde iyiyita, “Uywuya mwana vango uviahalilwe. Mupulikhage umwene.” ");
INSERT INTO zgam_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Inyilango vuyiutsige mye, u Yisu akhava mwene. Vatemile miyee, khusikulyo nu khusita unchova khinu ukhwa venjaga muvala avalivwene. ");
INSERT INTO zgam_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Isikhu iyiyakhongile, vuvahuvunile khukyamba, lulundamano uluvaha ulwa vanu vakhagana nave. ");
INSERT INTO zgam_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Lola, gosi ukhuhuma khululundamano alyelile khulimenyu, ilivaha akhata, “Imanyisi nikhukhudova uudole u mwana vango, ulwakhuva mwana vango alimwene yuyuywa. ");
INSERT INTO zgam_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wilola inumbula injafu nu khwibata, nukwava mukhuvikha ihya nchelihano nu khuhuma amatutumelo mundomo. ");
INSERT INTO zgam_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Lyoyihuma khulususuvelo, iyeyikhumbikhauluvavo uluvivi. Navumilinche avakhongi ukhulole ihume savawesye.” ");
INSERT INTO zgam_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","UYisu aandile akhanchova, “Umwe mwikhikholo ikhisakhwidikha na khila ikhiyagile, ukhuhumaga ndili nu khutama numwe nukhutolana iminjigo numwe? Undete umwana.” ");
INSERT INTO zgam_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Udimi uyu ainchaga, unumbula ikhagwisa pasi nu khusukhanje khumakha. Lino u Yisu adukhile inumbula imbivi, pu akhaponya udimi, nu khupa udadaye. ");
INSERT INTO zgam_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Voni vadegile nu uvuvaha uwa uwa Nguluve. Upu vale valikhudega mambo goni ugukhavombikhe, anchovile na vakhongi vamwene, ");
INSERT INTO zgam_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Amamenyu gatamage vuvubulukhutu mbene, ulwakhuva u Mwana va Adamu ayihumya mumovokho ga vanu.” ");
INSERT INTO zgam_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ulwakhuva savalumanye amamenyu ago ukhuta gafihiwe muuliho gavene mukhuta vakekhe ukulumanya, vadwadile ukhuvuncha khulimenyu ilyo. ");
INSERT INTO zgam_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Pu uvuhomelehaniye vukhatengula mumbene vene uvakhuva imbaha. ");
INSERT INTO zgam_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pu u Yisu vualumanyile ikhivavuncha niyaga muvumbula nchavene, akhatola umwana ndebe, nu khuvikha khumwene, ");
INSERT INTO zgam_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Pu akhata, “Umunu uvikwipila umwana udebe, khulitawa lyango, amakhile une nu vavenchaga, angamokhele une apokhile uviasuhile, umwe, veni udebe umwe mwivoni viiva imbakha” ");
INSERT INTO zgam_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","U Yohani akhanda akhata, “ITwa, twambene unu vuivinga ilungoluve khuliwa lyakho pu tukhabencha, ulwa khuva sigenda nufwe.” ");
INSERT INTO zgam_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pu u Yisu akhambula, “Mlabenchaga, alekhe ukhuva khusana khulyomwe vinyo” ");
INSERT INTO zgam_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Usikhi vugufikhe ugwa khuluta khukyanya, amicho gamwene galikhulola khu Yelusalemo. ");
INSERT INTO zgam_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Akhasukha avafuasi khuvolongolo khumwenen, na vene vakhaluta nu kwingela khukhi jiji ikyava Samaria vavunganiye apakhuva. ");
INSERT INTO zgam_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pu avanu avakhusamaria savapokhele, ulwakhuva alolile anuho khu Yelusalemu. ");
INSERT INTO zgam_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Avakhongi va mwene u Yakobo nu Yohani vuvalolile eli, vakhanchova, “UTwa inongwa tulamule umwoto gwikhe pasi ukhuhuma khukyanya gavanyanye?” ");
INSERT INTO zgam_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pu akhavasyetukhila akhava dukha. ");
INSERT INTO zgam_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Pu vakhaluta ikhijii iginge. ");
INSERT INTO zgam_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Vuviluta munjila ya vene umunu yumo akhavavula, nikhuvakhonga padebepadebe khuwiluta.” ");
INSERT INTO zgam_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","U Yisu akhambula akhata, “Mbweha valineliguli ifidege ifya khukyanya filine nu uvufumba, lino mwana wa Adamu imbula apakhuvikha utwe gwamwe.” ");
INSERT INTO zgam_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Pu akhambula umunu uyunge, “Ung'ongagae pu umwene akhanjova akhata, “ITwa, nidova tasi nikha siyele udada vango,” ");
INSERT INTO zgam_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Pu umwene akhambula, “Valekhe vasilanage avafyule, vavasilye avafu, lino uve lutaga ukhanchovage uvuvakha wa Nguluve ikhilunga kyoni.” ");
INSERT INTO zgam_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Pu umu uyunge akhata. “Nikhukhukhonga, Utwa, pu nita uwe isikhi tasi nikhilage khuvanu avitami khunyumba yango.” ");
INSERT INTO zgam_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pu u Yisu ambula akhata asikhuli umunu uvikwingi ncha amavokho ga mwene ukhulima nu khulola khusana uviiva nu ludeva ulwa khukyanya khwa Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pu usikhi ugwa mbombo eyo, Utwa akhanchagula avange “70” nukhuvasuha, vavili vavili vamtalile ukhufikha, ukhu anogwa gwa ukhuluta. ");
INSERT INTO zgam_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Akhavavula, “Uvubeni wingi, lino avavomba mbombo vadebe. Pu tuolove Utwa uvi ibene, pu asuhe nambevi avavomba mbomboavakhubena. ");
INSERT INTO zgam_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Lutaga ikhi lunga kyoni. Mulolage, nikhuvasukha ndi ng'osi pagatinapagati pa Mbwa mwitu. ");
INSERT INTO zgam_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mulugeka upakho ugwa hela, nu pakho ugwa vigenda, na viatu mlekhaga nu khusamusya umunu, munchela. ");
INSERT INTO zgam_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Munyuba iyakhiva mukwingela mutenchage, ulunonchehencho luvenchage nuve munyumba iyi.' ");
INSERT INTO zgam_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Pu umunu angave nu lunonchenchencho iva pwale, ulunonchehencho lwinyo lusigala pamwene lino ingave bakho, lukhilivukha khulyumwe. ");
INSERT INTO zgam_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Sigalaga munyumba iyo, mulinchage nu khunywa ikhiyakhiva vihumya, ilwakhuva umbombambomba inogiwa ukhupata usahara. Mlahegaga nu khuluta inyumba iyinge. ");
INSERT INTO zgam_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Uvunjenge uwavenchaga umuyakhiva mukwingila nu khuwapakhela, linchaga kyokyoni ikhuyakhiva vikhuvaletela khumiho agenyo au khundongolo, ");
INSERT INTO zgam_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ponyaga avatamu avamuvale nukhuvavula. Uvutwa wa, “Nguluve vukwinha vulipipi' ");
INSERT INTO zgam_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Lino imbunjenge uwavenchage umuyakhiva mukwingila nukhusita ukhuvapokhela mlutage khu, namunchila nchovaga, ");
INSERT INTO zgam_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Utundukhulu imbunchenge wenyo ulyumilile mumalunde gyito tusanyana khulyumwe! Pu mulumanyage, uvutuna wa Nguluve vuhegelile.' ");
INSERT INTO zgam_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ni khuvavula ukhuta uvuhigi vuhegulile ukhulutilila khu Sodoma. ");
INSERT INTO zgam_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ikyole umwe mwi va Korazini, mwekyale mwi va khu Bethsaida! Ingave imbombo imbaha incha vombikhe mugati indyumwe, yavombeliwe khu Tiro nu Sidoni, vavidova uvusyikhilo ukhuhuma khatale fincho, vagave vitama mugati mumwenda igya magunila ne lyela. ");
INSERT INTO zgam_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Lino yiva nu khwiyumilincha fincho nu khuhigiwa nu Tiro nu Sidoni fincho numwe. ");
INSERT INTO zgam_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Uve vi Kapernamaumu, vusaga ayuvikhugwimekha ukhuluta khukyanya? Bakho, yuvikhukwisya pasi khuvunchukha. ");
INSERT INTO zgam_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mvikhuvapulehyincha umweikhumulihincha une, nu vavnchaga uviyakhiva ukhuvabela ikhumbela vune, nuyakhiva ikhumbela une ambelilyeuviansuhile” ");
INSERT INTO zgam_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Avo 70 vakhilikhe nu khuhovokha, puvalikhu nchova, “Utwa, na gamanguluve gikhutwidikhila khulitava lyakho.” ");
INSERT INTO zgam_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yisu akhavavula akhata, “Nambwene undugu vuigwa ukhuhuma khukyaya ndi enjasi. ");
INSERT INTO zgam_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Lola, nivapile imbombo nu khukhada injokha ne enge, na makha goni nu khu sinda undugu, sa khulikhinu ikhiyakhiva mulemwa khu njila iyo khiyakhiva khikhuvale mauncha. ");
INSERT INTO zgam_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Lino mlekhe ukhuviginya ukhuta inumbula nyikhuvidikhila, pulino muhovokhsge ingave amatawa ginyo gasimbiwe khukyanya.” ");
INSERT INTO zgam_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Pu uskhi gulagula ahowikhe fincho khu mepo umbalanche, nu khunchova, “Nikhukhugyiniya uve, Dada, Vitwa va khukyanya na pasi pa khilunga, ukhuva ufihile imbombo inchi ukhuhuma khuvanyavulweli nu luhala, nu khugagubatula khu vala avasavimanyisiwa, khuvanaavadebe. Khemene, Dada, ahowikhe khumiho khuvaene.” ");
INSERT INTO zgam_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Pukhila khinu kyavikhiwwe khulyone nu Dada vango, khisikhu ikyakyumanya umwana viveni nu Dada, pu asikhuli uvikhulumanya u Dada viveni nu mwana. “Nu vyavenchaga, ukhuva umwana ainogwa ukwigubatula khumwene.” ");
INSERT INTO zgam_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Avasyetukhile avakhongi, nu khunchova, khwa khwiyuvilila, “Msayiwe vumukhugavona aga ukhuva umwe, mukhugavona. ");
INSERT INTO zgam_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nikhuvavula umwe, ukhuta avanyamalago vingi na Vatwa vanogilwe ukhulola imbombo i nchomukhunchivona, pusavanchiwene nu khupulikha, savagapulikhe.” ");
INSERT INTO zgam_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Lola, umanyisi umongi uvandagilo incha khuyahudi avenule nu khugela, akhanchova, akhata, “Imanyisi, negahe ndakhikhi ukhuta nincheningile khuwomi uwasikhu nchoni?” ");
INSERT INTO zgam_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","U Yisu akhambula, “Kyandikhiwe khikhi mululagilo? iyi vukhwimba khikhi?” ");
INSERT INTO zgam_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Akhanda akhata, “Vukhugana Utwa Unguluve vakho ne numbula yakho yoni, ulwakhuva inumbula yakho yoni, yilinamakha goni nu luhala lwoni nu yunywa mubadihine nu mbili gwakho yuve.” ");
INSERT INTO zgam_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","U Yisu akhanchova akhanda, “Nu vuyilweli woni. Vomba nde vutamaga.” ");
INSERT INTO zgam_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pu umanyisi, anogwaga ukhwivalila uvuyilweli mwene, Akhambula u Yiau, “Nu uvivabadilikhine iva veni?” ");
INSERT INTO zgam_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","U Yisu akhanda, “Umunu unongi aikhaga ukhuhuma khu Yerusalemu ukhuluta khu Yeriko. Akhangwela pagati pa vanyambuna, vakhapakha ikyuma kyoni nu khutova nu khundekha pu akha pipi nu khufwa. ");
INSERT INTO zgam_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Khukhafika usikhi ukuhani aikhaga khu njila yiyiyo, vualolile akhagenda injila iyinge. ");
INSERT INTO zgam_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Na yu Mlawi navope, afikhe pa nchila akhambona vope akhagenda khulukha nji. ");
INSERT INTO zgam_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pu Usamaria yumo, vuigenda munchila, akhambona umunu agatile ilonda ukhufwa, khikhambona ikhisa. ");
INSERT INTO zgam_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Akhahegelela nu khukhunga ifikholo fyamwene nu khubakha imono mufikhoho ne divai pakyanya pa mwene. Akhatoncha pakyanya pa khikhanu kyamwene nu khung'elikha khunyumba iya vahesya nu khundolela. ");
INSERT INTO zgam_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Isikhuiyikhongile atolile dinali ivili akhapa uviandolelaga nukhumbula, antangaga khukyavenchaga ikhiyakhiva khilutilila ayunihomba vunikhiliwikhe.' ");
INSERT INTO zgam_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Pu veni khuvanu vadatu, uvinubadisine va pa wipi, khumunu uviagwile na vanyambuda’?” ");
INSERT INTO zgam_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Umanyisi akhanchova akhata, “Vi ula uviavonisye ikisakhu mwene, “U Yisu akhata, “Lutaga ukhavombaga vulevule” ");
INSERT INTO zgam_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Lino vuvigenga vaingile khu vunjenge, nu dala yumo ilitawa vi Matha amwopilile munyumba iya mwene. ");
INSERT INTO zgam_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ale nu nunave uvialilangiwaga Mariamu, atamile mumalunde ga Ntwa nu phupulihincha ilimenyu lye mwene. ");
INSERT INTO zgam_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Lino nu Martha aitwikhile imbombo nchoni incha ukhutelekha ikyakhulya. Alutile khwa Yisu, nu khuta, “Itwa, pusewusaga ukhuta umbaha vango andekhile punivomba? Lino imbule anange imbombo.” ");
INSERT INTO zgam_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pu U Twa akhanda nu khumbula, “Martha, Martha, vukhigatancha khu mbombo inyingi, ");
INSERT INTO zgam_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","lino khukhile ikhinu khimo ikhinonu, Mariamu alondile ikhinu ikhinonu, ikhisakhilahega, ukhuhuma khumwene.” ");
INSERT INTO zgam_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Gwahunule usikhiU Yisu upu eusayaga mwene, ukhongiyumo ambulile, “Itwa, utumanyisye ufwe ukhwisaya ndu Yohani umuavaama nyisye avakhongi vamwene.' ");
INSERT INTO zgam_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","U Yisu akhavavula, vumukhisaya, 'Munjovage, 'Dada, ilitawa lyako limikhiwe. uvutwa wakho winchage. ");
INSERT INTO zgam_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Utupinchage ikhisyesye kyitu ikya sikhu nchoni. ");
INSERT INTO zgam_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Utusyiekhilage inogwa nchitu, ndavutukhuvasyikhila avange voni avatunangile. Utatuvikhaga indugelo.” ");
INSERT INTO zgam_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","U Yisu akhavavula, “Veni khulyumwe iva nu gane va mwene, uvikhunelutila pakhilo nu khubula ugane ukhuta unyanchime ifisyesye fidatu. ");
INSERT INTO zgam_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ukhuva umanyani vango anyinchile lino ukhuhuma khusafari, une nilinchila khinu ikya khupa.' ");
INSERT INTO zgam_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nulu ungale igati akhanda, ulangata nchaga, undyango gufungiwe na vavana vango, tumalile ukhuluta gwigona saniwesye ukhusisinuka ne khupe uve ikhi syesye. ");
INSERT INTO zgam_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nikhuvavula, ndave sisimkha nu khukhupa ikhisyesye ingave umanyani vakho ikwendelela ukhugonga khisita isoni, isisimukha nu khukhupa ifivungutikhilo inya khisyesye ukhuhwanana nu muvunogelwa uve. ");
INSERT INTO zgam_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Navyune nikhuvavula nita, wiwisayage, ayumwikwidikhiwa lomelaga yumwipata, hodenchaga ikhikhuvadintulila. ");
INSERT INTO zgam_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ulwakhuva umunu uviavenchaga angadovage vikhupa uviilonda ikhupilila, nu vikhohona vikhudindulila. ");
INSERT INTO zgam_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Veni udada mugati indyufwe umwana, angadove isomba ikhupa injokha? ");
INSERT INTO zgam_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Angadove ilikhala ikhupa inge? ");
INSERT INTO zgam_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Lino, ulwakhuva umwe mlinuwwivu, mlumanyile ukhuvapa avana vinyu uluhovokhilo ulunonu, lino udada uvakhu kyanya syio fincho? Ukhuta ikhuvapa umepo umbalanche khu vala avikhudova?” ");
INSERT INTO zgam_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pu ugunge usikhi, u Yisu alikhu vinga khuminguluve, nu munu unyaminguluve nu nyamisetano akhava khitanchova. Ilisetano lyavile lihegile khumunu uyo, umunu uyo awesinche ukhunchova avanu vadegile fincho. ");
INSERT INTO zgam_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Avange vagelile wakhata uyu ihencha amanguluve aga Beelzebul, umbaha va mnguluve ");
INSERT INTO zgam_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Avange vagelile nukhulondo avavonesyie ulugelo ukhuhuma khukyanya. ");
INSERT INTO zgam_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pu u Yisu agamanyile amasago gaaaavene nukhuvavu, “Uvutwa uvuyakhiva vugava yumwa wene, ne khya yiyo yigavile yuyigwa. ");
INSERT INTO zgam_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ingave undugu usetano iva agevile, uvutwa wamwene ayuvukwima ndakhikhi? Ulwakhuva mwinchova, mwita ncheucha amanguluve aga Belzebuli ");
INSERT INTO zgam_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ingave une nihencha amanguluve ga Beelzebuli, lino avanyinyo vihencha amanguluve khu nchila yilikhu? ulwakhuva iyi, avene yuvikhu vahiga umwe ");
INSERT INTO zgam_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Lino, umwe ingave muhencha amanguluve khu khivokho kya Nguluve, pu uvutwa wa Nguluve vuvinchile. ");
INSERT INTO zgam_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Umunu uvyalinamakha alinifilwilo ifyakhulolela uvunjenge wa mwene, ikyuma ni finu fitaneavunonu. ");
INSERT INTO zgam_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Lino vangavamile umunu unyamakha ukhulutilila, nu munu uvya linamakha angapokhe ifilwilo vyamwene, nu khutola ikyuma kyamwene kyoni. ");
INSERT INTO zgam_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Umwene uvialikhutali nune hange, khusana khulyune nu khusitaukhulundanya paniye une niyevaniya. ");
INSERT INTO zgam_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Amanguluve amavivi agagihuma khumunu, gagiluta nu khulonda baho amagasi pungale nu khukhekha. Upuyakhiva awene alemilwe, pu inchova, ninogwa ukhukhilivusukho ukhunahumile. ");
INSERT INTO zgam_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Angavuye nu khuvona uvunjenge wa mwene, vukhuniwe nu khutama vunonu. ");
INSERT INTO zgam_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Lino puiluta khulonda amanguluve 7 avavivi ukhulutilila umwene nu khuvagega vatame upualipo. Nu munu numunu uyo iviva nu vupala fincho, ukhulutilila.” ");
INSERT INTO zgam_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Wahumile ukhunchova amamenyu ago udala yumo ahuminche ilimenyu khuvukhali, ukhulutilila khuvoni khululundamano ulwa vanu nu khunchova, ");
INSERT INTO zgam_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","“Ligatalufu ilitumbu ililyakhu holilene livele iliwaohile” Umwene akhanchova akhata vasayiwe avavipulikha ilimenyu lwa Nguluve nu khulivika vunonu. ");
INSERT INTO zgam_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Pu usikhi ugwa vanuvuvikhindamaniya nu kwongesekha, u Yisu akhatengula ukhunchova “Ikhivumbukho ikhi ikhivumbukho vuvivi, khilonda khuvonesya nu khuta khisikhuli ikya khuvonesya ikhivapatile ukhulutilila nu Yona ");
INSERT INTO zgam_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Uvunonu nu Yona upuale nu khuvanesya khu vanu ava khu Ninawi, vuyayiva nu mwana va Adamu uvuyakhivaiva ukhuvonesya khu khisasi ikhi ");
INSERT INTO zgam_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","U Malkia vakhu kusini ayikwima ikhigano ikya vuhigi na vanu ava khisasi ikhi nu khuvahiga avene ilwakhuva avene vahumile khu vumalilo wa khilunga ukhuta inche apulihinche uvuelwada uva Solomoni, na apo pwale uviale imbaha ukhulutilila. ");
INSERT INTO zgam_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Avanu va khu Ninawi ayuvikwima khu vuhigi, ulwakhuva va khuti uvusiyiekhilo uva limenyu ilya Yona nu khulola, apa khwale umbaha, ukhulutilila u Yona. ");
INSERT INTO zgam_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Asikhuli umunu avavenchaga uvikhunga ikhoroboi nu khuvikha pasi pa hisi yilekhe ukhuvone kha pasi pa khitunda, umwene ikhunga nu khuvikha pa kyanya pa khunu ukhuta umunu nu munu uvikwingila aluvonage ulumuli. ");
INSERT INTO zgam_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Iliho lyakho lumuli lwa mbili gwakho iliho ligave linonu nu mbili gwiva inonu gwiva ndumuli. ");
INSERT INTO zgam_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Lino iliho lyakho lingawe liva liviviv numbili gwiva imbivi gwoni gwiva muhisi. Lino mwilolelaga, ukhuta ulumuli lulwa lulimugati indyumwe lulekhe ukhuvikhiwa ihisi. ");
INSERT INTO zgam_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Lino valume ingave, umbili gwakho gwoni guli mundumuli pu khusikhuli ukhuva muhisi, pu khukhuta umbili gwakho gu hwanana ne khorobui iyikhwakha nu khuhumya ulumuli khulyumwe.” ");
INSERT INTO zgam_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Avile amalile ukhunejova, Farisayo adovile akhale ikyakhulya khukya ya mwene. Nu U Yisu akhungila mgati nu khuva pa nuye numwene. ");
INSERT INTO zgam_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Na Vafarisayo vakhaswiga ukhuva sakhalave amavokho vusategwile ukhulya ikyakhulya ikhya khukhimihe. ");
INSERT INTO zgam_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pu khuludeva akhavavula, “Umwemwi Vafarisayo mwisukha ifikhombe khunchi ne bakhuli, humbe mugati indyumwe mudigile unogwe uvuvi. ");
INSERT INTO zgam_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Umwe mwi vanu yumwe munchila khulumanya, ingave uviapelile khunchi lino sa pele na gati? ");
INSERT INTO zgam_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Vapinchage avaganju agagati ni mbombo nchoni nchiva nonu khulyamwe. ");
INSERT INTO zgam_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Lino mwilolilage Vafarisayo, ukhuta muhumya isadaka iya mnanaa nu chicha ni kyavenchago ukhuhuma khukyalo. Pu umwe mugalekhile agavuyilweli nu khubela agaNguluve. Lunonu fincho ukhuvomba agavuyelweli nu khugana u Nguluve, khista khuvomba ago. ");
INSERT INTO zgam_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Mwikyole mwiVafarisayo ukhuva mwinogwa ukhutama mufigoda ifya khuvulongolo khu masinagogi nu khukhuponya ukhufugamo. ");
INSERT INTO zgam_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mwilolelage mukwanana na mapuvuba aganchila khimanyilo kya munu pe avanu vigenda pa kyanya khista khulunya.” ");
INSERT INTO zgam_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Umanyisi yamo uva ndagilo incha vayahudi akhanda nu khuvavula, “Imanyisi, ikhiwinchova khikhutukhalanja nayufwe.” ");
INSERT INTO zgam_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","U Yisu akhanchova, “Mwilolelage, indagilo ulwakhuva mukhuvapa avanu iminchigo imivaha igisaviwesye ukhwitwikha, lino umwe samu palamasya iminchigo igyo vulevule ukhutwanana mekhi melelenchi ikya mavokho gito. ");
INSERT INTO zgam_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mwilolelage ulwakhuva mujenga nukhuvikha ikhi khumbuhincha khu khumapumba agavanyamalago avuvabudiwe na vakhukhu vito. ");
INSERT INTO zgam_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Lino numwe mukhwidikiwa nu khwidikha khumbombo inchivavobile avakhukhu vito ulwakhuva vavabudile avanyamalago kya mapumba gavene. ");
INSERT INTO zgam_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ulwakhuva khuvunonu uwa Nguluve inchova ita, “Nikhuvasuhila avanyamalago na valumbeleli avene vikhuvatesya nnu khuvabuda avange. ");
INSERT INTO zgam_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ikhivumbukhu ikhi yukhivomba khukhisa ugwa vanyamalago avuvabudiwe ukhuhuma pavutengulilo wa khilunga, ");
INSERT INTO zgam_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ukhuhuma ukhisa gwa Abeli nukhisa ugwa Zakaria, uviabudiwe pagati pa khitekhela pa vuvalanche. Lweli, ni khuvavula umwe, mwe vakhivumbukho ikhi ayukhivomba. ");
INSERT INTO zgam_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mwilolelage mwi vamanyisi va ndagilo incha khiyahudi, ulwakhuva mtolile indindulilo incha vutwa, nu mwe samukhwingila, na vavinogwa ukhwingela, mukhuvakhilwala.” ");
INSERT INTO zgam_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Usikhi u Yisu ugwa khuhega pala, avavigi na Mafarisayo vabelile nu khugatanchiwa nu khuhigiwa, khu mbombo inyingi. ");
INSERT INTO zgam_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Vagelile ukhumwibeta khumamenyu ga mwene. ");
INSERT INTO zgam_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Khu nsikhi ugwa amakhindiga ga vanu valundamane pupaninye nu khukhadana, akhatengula ukhunchova na vakhongi va mwene tasi, mwilolelage ni khiluve ikya Vafarisayo avuvene, “Viva vanyalubedo” ");
INSERT INTO zgam_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Sapakhave ne siri iyifihime iyiyo sayigubatuliwe, nikhunu khikyo khikhafihime, khile khe ukhuvonekha. ");
INSERT INTO zgam_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Linio lola ilyumwa nchovaga vumilimuhisi, pulipuli khikha vulimu ndumuli. Nu vavenchaga vumukhu ganchova mumbulukhutu igati mu nyumba nchenyo ivikhungiwe filanchovaga khu kyanya khu nyumba. ");
INSERT INTO zgam_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nikhuvavulamincha vayangamula dwadaga avibuda umbili, ulwakhuva va livuvule ukhinu ikya khuvomba, ");
INSERT INTO zgam_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Lino nikhuva vunga uvakhu dwada. Mudwadage ula uvuyakhiva ibuda nu anayelweli woni nu khutaga khujehanamu. Kweli, nikhuvavula umwe mudwadage ujwua. ");
INSERT INTO zgam_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","limo shamoro5 savigunchi wa kundalama ivili? Pu asikhuli numo uvi yakhuva ga Nguluve. ");
INSERT INTO zgam_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Lino pu mulumanye ukhuta, injweli ncha twe gwinyo nchivaliwe mulwadwadaga. Umwe mulivavaha nukhu dwanchiwa. Khuvuvaha khisita ishomoro inyinyingi. ");
INSERT INTO zgam_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nikhuva, vula uviavenchoga uviyakhiva ikhunjidikha une khumiho ga vanu, nu Mwana va Adamu ayikhumwidikha khumiho ga vasung'wa va Nguluve. ");
INSERT INTO zgam_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Umunu uvavenchaga uviyakhiva inchova ilimenyu ilivivi khu mwana va Adamu, ayisikhiliwa, ");
INSERT INTO zgam_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","lino uvavenchaga, uviibeda khu mepo umbalanche, sakhasyekhiliwe. ");
INSERT INTO zgam_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Vuyakhiva vikhuvahilikha khuvulongolo khu vavaha avasinagogi, na vatwa na vakhilunga mulwadwada nu khu nchova nu khunchova vu mukhitetela, ");
INSERT INTO zgam_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","khikyo mwinchova, Pu umepo umbalanche ayikhuva manyisya umwa khunchovela khu sikhi ugwa.” ");
INSERT INTO zgam_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Umunu umo nu lulundamano akhambula, “Umanyisi, umbule ulukhololwango angavile uluvafu lwango.” ");
INSERT INTO zgam_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","U Yisu akhanda, veni uviambikhile ukhuva indamunchi nu khulihava imbulongolo winyo? ");
INSERT INTO zgam_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Pu akha vavula, mwilolelage mu mhombo iya vunogwe, ulwakhuva uvumi wa munu vusi khuli nu vumofu uwa finu ifi alinavyo.” ");
INSERT INTO zgam_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","U Yisu akhavavula ikhihwa na nicho, akhanchova akhata, ikyalo kya munu yumo utayili, ");
INSERT INTO zgam_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","kya motikhe fincho, Akhivuncha mugati akhata, nelivuvule apakhuvikha imote yango? ");
INSERT INTO zgam_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Akhanchova, nivomba ndeenidenyanya ifibana vyango ifidebe nu khunjenga ifibana ifivaha, nu khuvikha imote yoni ni finu ifinge vyoni. ");
INSERT INTO zgam_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nu khuyivula inumbula ukhuta,” numbula wivekhile ikhibana ne vinu vyooni khusikhi ikya miakha gimingi. Tama, nu khuhovokha, uliuchage nukhunjwa nu khuhovokha.” ");
INSERT INTO zgam_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Lino UNguluve akhambula, uve vi munu ulipelwa, ikhilo iyi vinogwa inumbula yakho ukhuhuma khulyuve, ni finuvyoni ifiwavekhile fiva vyani? ");
INSERT INTO zgam_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Vunyilava umunu nu munu uvivekha ikyuma ulekhe ukhwita yilisya khu Twa. ");
INSERT INTO zgam_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","U Yisu akhavavula avakhongi vamwene, pu lino nikhuvavula ukhuta, mlekhe ukhu susuvala khukya muhiitamile ginyo ukhuta mwilya khikhi, mufwala khikhi. ");
INSERT INTO zgam_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ulwakhuva imitamile khulutilile mukyakhulya, nu mbili gulutilile mumyenda. ");
INSERT INTO zgam_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mulolage ifidege ivya khukyanya, safilina nu khubena. Valivuvule inyumba na khikhi bana ikya khuvikhila, lino uDada veto, ikhikhuvalisya. Umwe samuli vananu ukhulutilila fincho ndi fidege! ");
INSERT INTO zgam_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Pu pwale veni uvi ikhigatancha imbutamilo wa mwene? ");
INSERT INTO zgam_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ingavesanuvomba imbombo indebe khikhukhwi gatancha na gange goni? ");
INSERT INTO zgam_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mulolage amavuva - vugimela. Sagivomba nu khubota ulwakhuva. Nikhumbula, na yu Sulemani khu vuvaha wa mwene woni savikhiwe ukhuva vope pwale, ");
INSERT INTO zgam_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ingave Unguluve si vikha vunonu ilinyasi khuvunambalililo, ne lelo pugale, khilavo vitaga khumwota. Lino silutilila ukhuvavikha umwe? Umwe mwi valwidikho ulusupi! ");
INSERT INTO zgam_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mulagatalaga ukhuta twilya khikhi nu khunywa khikhi mulavenchaga nu vugwanchi. ");
INSERT INTO zgam_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ukhuva avavaha va khilunga vigatanchiwa ne nchakhilunga. Nu Dada vito ulumanyile ukhuta mulonda ago. ");
INSERT INTO zgam_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Lino mulondage uludeva tasi pu agange ikhuvongelenchaga, ");
INSERT INTO zgam_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Muladwadaga, umwe mwikhipunga ikhidebe, ulwakhuva u Dada veto ihavokha ukhutupo ufwe uludeva. ");
INSERT INTO zgam_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gunchaga ikyuma kyoni nu khuvapa avaganchu, mwivikhile imepakho_igisagisila ne lakhiba khu kyanya iyisayisila upu avalyasi savakhahedelele na yi nondo sayikhawese ukhubungua. ");
INSERT INTO zgam_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ulwakhuva upunyilipo iakhiba puyilipo na yi numbula yakho. ");
INSERT INTO zgam_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Imwenda gieto give nutali give gikhungiwe nu khanda, gwa taa nchinyo nu khulola ukhuta nchikwe ndelela ukhwakha, ");
INSERT INTO zgam_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nu khuva nda vanu avikhundola Utwa vavene ukhuhuma khuluhekhelo ulwa vutegulani, ukhuta aginche nu khuta, puvi khudindulila undyango na mbivi igele. ");
INSERT INTO zgam_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Vasayiwe avavombi avuvene Utwa ayikhuvavona valimiho. Lweli ayikhunga mienda imitali nu khanda, nu khuvatamikha pasi khukhulya nu khuvapa linchaga. ");
INSERT INTO zgam_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ingave Utwa ikhwincha khusikhisikhi pu uvuloleli uwa pakhilo nu wa sikhi khadatu (3) yu vuloleli nu khuvavona ukhuva viyandalile, viva vagatalufu avavombi avo. ");
INSERT INTO zgam_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ukhulutilila nago, mungalumanye ukhuta umunu ikhwincha khuhincha sakhale ikhuyilekha inyumba vebomole. ");
INSERT INTO zgam_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Muvenchage miho, ulwakhuva samulumanyile usikhi ugu ikhwincha umwana va Adamu. ");
INSERT INTO zgam_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","u Petro anchovile akhata, “Itwa, vukhutuvula yufwe ifi khwani, nukhumbula umunu nu munu? ");
INSERT INTO zgam_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","U Twa akhavavula akhata, “Veni umbanda unonu nu nyaluhala, uve Utwa va mwene ikhu mbikha khukyanya khuva mbombo avange ukhuta avapinchage ikyakhulya kyavene khunsikhi ugwa venchaga? ");
INSERT INTO zgam_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Asayiwe umbaha uvi Utwa va mwene anginche ivona ivomba imbombo yila iyakhambulule ukhuvomba. ");
INSERT INTO zgam_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Lweli nikhuvavula umwe ukhuta ikhu mbikha khukyanya khu kyuma kyoni. ");
INSERT INTO zgam_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lino umbaha ula anchovile munumbula mumwene, “Utwa vango inchelewa ukhukhilivu kha; pu akhatengula ukhuvatova avambombo voni, avagosi na vadala pu akhatengula ukhulya nu khunywa nu khugala, ");
INSERT INTO zgam_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","utwa vamwene nu mbanda ayikhwincha pa khigono ikhisakhivo nekha nu sikhi gugwa sugumanyile, nu mwene ayigida tusekhele tusekhele, nu khuvikha pupaninye na avasava vikhwelewa' ");
INSERT INTO zgam_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Umbaha, uvyalumanyile uvugane wa Ntwa wa mwene nu mwene sakhivikhe vuuonu nu khuvomba vuuonu nu vugane wa mwene, nu khutoviwa ne mbikhi inyingi. ");
INSERT INTO zgam_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Lino umbaha uvesalumanyile uvugani wa NTwa va mwene, pu akhavomba agilondiwa, ayitova imbikhi ndebe, ulwa khuva uvivapile fingi, ifingi vikhufilonda u khuhuma khu mwene, nu mwene uvivamwamini khu fihele likhe, khu mwene ayufilondiwa ifihelelikhe ukhulutilila. ");
INSERT INTO zgam_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ninchile khukhoncha umwoto mukhilunga, ninogwa guve gwakhile, ");
INSERT INTO zgam_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pu luno nelinulwoncho ulwa khwonchiva, nu khuva nulususuvalo ukhufikha khuvumalilo! ");
INSERT INTO zgam_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Lino, usaga mwita ninchile khukhuvapa ulwidikho mukhilunga? Bakho, nikhuvavulanincha, ukhuta neletile ukhulekhehana. ");
INSERT INTO zgam_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ukhuma lino nu khwendelela yukhuva na vanu 5 munjengo yimo nukhugavaniya radatu viva khusana na vavili, na vavili viva khusana na vadatu. (3). ");
INSERT INTO zgam_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yuvikhigava, udada iva khusana nu mwana, nu mwana ayiva khusana nu dadaye, uvanina iva khusana nu ng'inchava mwene, nu vanina ukwive iva khusana nu khwive va mwene. ");
INSERT INTO zgam_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","U Yisu akha vavula avanyalulundamano nave, “Ukhuta vumuvona amafunde vugihumila khuvuhumo, mwinchova usikhi ugwa fula gufikhe vuyilivo vuyakhiva yiva, ");
INSERT INTO zgam_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ne mepo ukhuhuma khuvutegulilo wa khilunga nu khuluguto, mwinchova, pupalava na mafukhe amakhali, vuyilava. ");
INSERT INTO zgam_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Umwe mwe vanyagila, muwesya ukhulesya imigendele igiya khilunga na khukyanya, lino yuyiwa ndakhikhi samukhawese ukhwelesya usikhi ugupugule? ");
INSERT INTO zgam_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Khikhi umunu nu munu alekhe ukhukhwihiga ilya lweli? Khu mwene ukhu vomba usikhi ugwalinago nu sikhi ugwakhuvomba evo? ");
INSERT INTO zgam_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ungave vuluta nu vihegiwa vakhe khuvulongolo khwa uhakhimu, nitangage ukhwibatana nu vihigiwa vakho vulimumule mulinchila alekhe ukhukhuhilikha khwa akhimu, nu hakhimu akhuhilikhe khu ofisa, nu ofisa akhakhutaga khulumande. ");
INSERT INTO zgam_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ni khuvavula, ukhuhuma ukhwa akhuhombile ukhuhuma khumwisyo ne senti iya mwisyo. ");
INSERT INTO zgam_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Khunsikhi gugugwa, khwale na vanu avambulile ukhuta avagalatia avu u Pilato avabudile nu khuhanjaniya nu khisa gwavo ne ni vyavupe. ");
INSERT INTO zgam_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","U Yisu aandile nu khuvavula, “Lino mwita avagalatia avo vale nu vutula nogwa ukhulutilila avagalatia avange voni khe mene vupilile nu vavivi iuwa? ");
INSERT INTO zgam_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Bakho, nikhuvavula, nete mungave samkhute, umwe ayumwiyaga vutevule. ");
INSERT INTO zgam_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Upu vale avanu “18” khusiloomu upu unara gwagyile nu khuvabudi pumsaga ukhuta avene vale nuvulula nogwa ukhulutilila khu vanu avange khu Yerusalemu? ");
INSERT INTO zgam_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Bakho, une ninchova, mungalekhe ukhukhuta, umwe mwivoni punikhwavela. ");
INSERT INTO zgam_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","U Yisu avavulile ikhikhwani ikhi, “Umunu umo ale ne libikhi avyalile khu khyalo khya mwene nu khuluta khulonda isekhe khukya na sapate. ");
INSERT INTO zgam_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Akhambula uvi alolelaga ikyalo, 'Lola, khu miakha gi datu nainchile nukhugela ukhulonda isekhe khu bikhi ugwa sanapate khinu. Udumule. Ulwa khuva gutela uvuvivi uwa khilunga? ");
INSERT INTO zgam_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Uvi lolela ikyalo aandile nukhunchova ukhuta, 'Ugulekhe umwakha ugu nilinilile nu khuvikha imbolela, pakyanya. ");
INSERT INTO zgam_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Gunguhupe isekhe umwakha ugukhwincha lunovu, pu; gungave saguhupa, ugide!” ");
INSERT INTO zgam_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Lino u Yisu ale nu khumanyisya khu vanu vaninye na vasinagogi khusikhi ugwa sabato. ");
INSERT INTO zgam_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Lola, alepwale ujiu umo uvi ale ne miakha “18” ale ne mumbula inchafu, nu mwene ale abudiwe imbula mbaubo iyave nchaga na khukhwima. ");
INSERT INTO zgam_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","U Yisu vuambwene, akhamwilanga, “akhambula, “Jiu, uvikhwe ukhuva mbulegefu ukhuhuma imbupepe wakho.” ");
INSERT INTO zgam_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Akhambikha amavokho gwa mwene pa kyanya pa mbili ugwa mwene akhimikha amavokho nu khuginiya Unguluve. ");
INSERT INTO zgam_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pu umbaha va sinagogi avipile ukhuva u Yisu aponinche umunu isikhu iya sabato. Lino umbaha va khilunga akhanda akhavavula avanyalulundamano, “Khulo isikhu 6 incha khuvomba imbombo. Mwinchage khupokhiwa wonela isikhu iya sabato. ' ");
INSERT INTO zgam_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Utwa akhanda nu khunchava, “avanyagila vasikhuli nu mo ukhudindula ipunda yakho, isenga ukhuhuma khulipalo nu khwalongoncha ukhulua khwinuwa isikhu iya sabato? ");
INSERT INTO zgam_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Lino avahincha va Abrahamu, avuvene undugu akhungile khu miakha “18” lino wanogilwe ikhi khungilwa ikhyo khilekhe ukhudinduliwa isikhu iya sabato?” ");
INSERT INTO zgam_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Vu inchova amamenyu ago vala voni avabelile vakhavona soni, pu avanyalulundamano voni na vange valulutile ulwakhuva amambo agakhudega agu avombile. ");
INSERT INTO zgam_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","U Yisu akhanchova, “Uvutwa wa Nguluve vukhwanine ne khikhi, vuwesya ukhukhwananincha ne khikhi? ");
INSERT INTO zgam_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nilindi mbegu iya haradai iyiatolile umunu umo nu khuyivyala mukyalo kya mwene nu khumela ukhuva libikhi ilivaha, ni ifidehe ifya khukhyanya vikhajenga uvufumba wavo mumasesi aga bikhi. ");
INSERT INTO zgam_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Hange akhanchova, “Nu khukhwananincha nu vutwa uwa Nguluve? ");
INSERT INTO zgam_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yale ukhuta khiluve ikhi udala atolile nu khuhanchaniya khuvigelelo fidatu “3” ifya vutine nu khutoga.” ");
INSERT INTO zgam_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","U Yisu agendile imbunchengene vijiji munjila vuiluta khu Yerusalemu nu khuvamanyisya. ");
INSERT INTO zgam_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Umunu umo avunchehe, “Itwa, vuvale avayakhiva vipokhiwa?” Lino akhavavula, ");
INSERT INTO zgam_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Witange ukhwingila ukhugendela undyango usekhele, ulwakhuva vingi yu vigela nu khusita ukhwingila. ");
INSERT INTO zgam_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nu sikhi ugwa undoleli va nyumba ukhima nu khudinda undyango, pu mukhwima khunji nu khugonga ndindulilo nu khunchova, Itwa, Itwa, tudindulile, umwene akhanda nu khuvavula, sanivamanyile umwe nu khuvuhuma.' ");
INSERT INTO zgam_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Pu yumwinchova, Twalile nu khunywa khuvulongoo khu vene, wa manyisye khuvunchenge uweto.” ");
INSERT INTO zgam_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pu umwene akhavanda, sanivamanyile ukhumwihuma, hega khulyune, umwe mwivavomba imbivi!' ");
INSERT INTO zgam_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Khulova nu khulila nu khuheveta amino khusikhi ugulava mkhuvavona u Abrahamu, Isaka, Yakobo na avanyaalago voni khu vutwa u wa Nguluve, nu umwe yumwe mutagiwe khunji. ");
INSERT INTO zgam_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Valincha ukhuhua khu vuhumo, na khuvusemo, khunena na khusikha, nu khugatalukha khu khisancha iya khya khulya ikya pa khimihe khu vutwa uwa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ne lumanyile ukhuta uva khuvumalilo iva vakhuvumalilo.” ");
INSERT INTO zgam_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Usikhiusupi, pongela gwiva gwaMafarisayo vainchilenu khumbula, “Luta nu khuhega apa ulwakhuva u Herode inogwa ukhubuda.” ");
INSERT INTO zgam_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","U Yisu akhanchova, “Mulutage mukhambule imbweha yila, 'Lola, nikhugavinga amanguluve nu khuvomba ukhuponiya ilelo na khilavo ne isikhu iya datu yu nivomba uvigane wango. ");
INSERT INTO zgam_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pu usikhi ugwa venchaga unonu khu khuvunogwe wango ukhuluta ilelo, khilavo na khusikhu iyikhongile khuvala avasavisayiwa ukhubuda unyamalago khutali ne Yerusalemu. ");
INSERT INTO zgam_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yerusalemu, Yerusalemu, veni uvibuda avanyamalago nu khuvatova na mawe vala avasuhiwa khulimwe, khalikhalingi nenogilwe ukhuvalunde maniya avana avadebe khulyu mwe ndi hukhu vuyilundamaniye inyamahukhu ifya pasi mumapapalilo aga hukhu, ingawa samwa nogwe ili. ");
INSERT INTO zgam_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Lola, uvunjenge wakho vulekhiwe. Nune nikhuvavula, samukhawesye ukhumbona nu muyakhiva mwinchova 'Asayiwe uvikhincha khulitawa ilya ITWA.'” ");
INSERT INTO zgam_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yahumile isikhu iya Sabato, pu avile iluta khu njengo khwa munu yumo aviale imbaha va Mafarisayo kwilya ikhisyesye avene valikhundolela pa wipi. ");
INSERT INTO zgam_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Lola, pavulongolo pa mwene pale nu munu uviagatanchiwaga nu vufimbe. ");
INSERT INTO zgam_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","U Yisu avunchi nje khu vamanya ndagilo va Vayahudi na Vamafalisayo, “Lino, lweli ukhuponniya isikhu iya sikhu iya Sabato, lino lweli?” ");
INSERT INTO zgam_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pi avene vakhava mye, pu uYisu akhamwibata, akhaponiya nu khupa uvugatalufu akhavuya khu myave. ");
INSERT INTO zgam_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Umwene akhavavula, “Veni umunu khulyumwe uvi ali nu mwana isenga iyiyingile mukhihulu ikya magasi isikhu iya Sabato sakha khwege khuuchi na mbivi?” ");
INSERT INTO zgam_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Avene savakhava ne lwakhuunchova khukhuhumya ilijibu khu mbombo yoni. ");
INSERT INTO zgam_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Usikhi uYisu alumanyile ukhuta vala avilangiwe vave vanchaguliwe alumanyile ukhuta vala avilangiwe vave vanchaguliwe, ifigoda ifya ifidwadiwa akhavavula ikhikhwani, akhavavula, ");
INSERT INTO zgam_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Usikhi vuvikhuhwilanga khuvutolani, ulekhe ukhutama khuvavaha, ulwakhuva khwale umunu umbaha uvevi khudwada avanu voni. ");
INSERT INTO zgam_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Usikhi umunu uviavilangile umwe mwivavili angafikhe, ikhukhuvula uve, hega umunu uyu itama apa, nu ve vuhega khusoni soni, vutengula ukhuluta khutama khu vumalilo. ");
INSERT INTO zgam_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Pu uve vangakhwilange, luta ukhatame khuvumalilo nu sikhi ugu umunu akhwilangile khululundamano vuinchile akhuvule, gwe higo, injango luta khuvulongolo ukhulutilila, `Pu wiva akhwimikhe khuvolongolo ukhulutilila voni avatamile nu mwene pa mesa. ");
INSERT INTO zgam_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ulwakhuva uviikhiyinula ayikhwisiwa, nu vikhwikha ayikhwinuliwa. ' ");
INSERT INTO zgam_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pu uYisu ambulile umunu uviamwilangile, 'Vuwihumya ikyakhula ikya pamusi na khukhimihe, ulekhe ukwilanga avaninyo nu valukhololwo nakho, avamubadihine vakho, avambadihine vakho na vatayili, ulwakhuva wita vinche vakhwilange nu yuve khukhwupila uluhombo. ");
INSERT INTO zgam_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pu lino, w wovuvomba uluhekhelo, uvalondage avalemilwe avaganchu avasavigenda na vasavilola. ");
INSERT INTO zgam_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","pu uve wiva insayiwa, ulwakhuva savakhakhuhombe. Pu uve ulahombwa khuvunchukhwa uwa nyavulweli.” ");
INSERT INTO zgam_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Usikhi gumo khuvala avatamile pa mesa paniniye nu Yisu avile apulikhe ago, nu mwene akhavavula, “Asayiwe ula uviyakhiva ilya ikhi syesye khu Vutwa wa Nguluve!” ");
INSERT INTO zgam_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pu uYisu akhavavula, “Umunu umo aitesaninche ukhuvikha uluhekhelo uluvakha alundenine avanu avingi. ");
INSERT INTO zgam_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Vu usikhi ugwa luhekhelo gufikhe, asuhile umbombi va mwene ukhavavule vala avanilangile, `'Mwinchage, ulwakhuva ifinu fyoni fivekhiwe nu khwincha khwilya. ");
INSERT INTO zgam_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Voni, vakhatengula ukhudova uvusikhilo. Uvakhwancha akhanjova, 'Imbaha, nigulile ikyalo, niluta khwilola. Nikhukhudova usikhile.' ");
INSERT INTO zgam_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nu yunge akhanchova, negulile isenga incha khulimila niluta khukhugala ndanchilima, nidova uvusyekhilo.' ");
INSERT INTO zgam_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Umunu uyunge akhanchova akhata, 'Nilinuwinga saniwesya ukhundakha udala vango mwene sanikhinche.' ");
INSERT INTO zgam_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Umbaha akhavuya khumyave nu khumbula utwa va mwene imbombo incho. Umunu uva vuujenge uwa avipile, akhavavula avambombo va mwene, `'Mulutage munchila ujoni na nduhengo munjengo mukhavalete apa, avaganchu, avalemilwe, avasavilola, nu vavosavigenda.” ");
INSERT INTO zgam_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Uvambombo akhanchova, `Itwa, goni aga gagoukhalagile ni malile ukhuvomba lino inafasi payile.' ");
INSERT INTO zgam_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Utwa akhambula umbombi, 'Luta munchila nchoni, nchila malekhano na munchila imbaha incha khu visolisoli uvumilinche avanu vigile inyumba yango yidige. ");
INSERT INTO zgam_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ulwakhuva nikhuvavula khu vala avilangiwe ukhuhuma khuvutengulilo asikhuli uviyakhiva ivoncha uluhekhelo lwango. ' ");
INSERT INTO zgam_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Lino avanyalulundamano uluvaha valutaga pupaninye nu mwene, nu mwene akhavasyetukhila nukhuvavula, ");
INSERT INTO zgam_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","'Ingave umunu ikhwincha khulyune, uvisikhugatancha udadaye va mwen, nu vanina va mwene nu dala va mwene, avagosi na vadala- lweli, na mbutamilo wa vene savakhawesya ukhuva vakhongi vango. ");
INSERT INTO zgam_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Umunu uvisitola ikhidamili ng'ani khumwene nu khwincha khusana gwa mwene siwesya ukhuva ikhongi vango. ");
INSERT INTO zgam_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Pu veni khulyumwe, uviinongwa ukhusimikha unara sakhatame tasi ukhusaga imbalilo ilingi, ikhi inogwa ukhumalana nikyo? ");
INSERT INTO zgam_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ulwakhuva, vu avikhile ulwuoto nu khulemwa ukhumala, voni valiwene vitengula ukhukhinela nu benapula, ");
INSERT INTO zgam_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","valikhunchova, Umunu uyu ategwile ukhusimukha, akhavambula makha aga khumala.' ");
INSERT INTO zgam_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Pu itwa mukhi, anganogwe ukhuluta khutovana nu Ntwa uyunge khwilwa uvisitama pasi nu khusaga ukhulonda ulwidihano, ukhuta lino yuniwesya, paniniye na vanu ava elfukhinchigo ukhutovana nu Ntwa uyunge uvikhwincha khukyanya khu mwene na vanu elfu ishirini(20, 000)? ");
INSERT INTO zgam_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Upu ingave usikhi sagufikhe, ugwa khipuga ikhinge khili khuvutali, pu visuha undoleli khulonda uvunonu lunonchehencho. ");
INSERT INTO zgam_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ulwakhuva uva venchaga mugati mundyiumwe, uvisikhufilekha fyoni, ifyalinafye, siwesya ukhuva ikhongi vango. ");
INSERT INTO zgam_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Umwinyo inonu, lino gungave umwinyo guanchinche ukhunoga, wigaha ndakhi ukhuta guve mwinyo? ");
INSERT INTO zgam_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Gusikhuli nu khuguvombela khulifu na khumbolela, gutagiwa khuvutali. Umwene uviali nu mbulukhutu incha khupulihincha pu apulikhe.” ");
INSERT INTO zgam_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pu avasonga songo voni na vange avatula nogwa valutile khwa Yisu nu khupulihincha. ");
INSERT INTO zgam_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pu Avikhwandikha vavipile nukhunchova, “Umunu uyu ikhuvahegelencha avanyasambi nu khulya paniniye na vene.” ");
INSERT INTO zgam_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Puu uYisu akhanchova ikhihwani khuvene akhanchova akhata ");
INSERT INTO zgam_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Veni khulyumwe uvi alining'osi “100” nchingayage yimo, pu sakhahege khulonda yila yimo iyiyagile sikhunchilekha “99” iluta khulonda yila yimo, iluta khulonda iyi yagile nu khuyivona? ");
INSERT INTO zgam_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nu mwene wayiwene pu ikhumibikha palivega nu khuhovokha. ");
INSERT INTO zgam_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nifikha khunjengo, ikhuvilanga avanine na avabadihine akhavavula akhata muhovokhage paniniye nune, ukhuva niyiwene ing'osi yango iyi khayagile. ");
INSERT INTO zgam_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","nikhuvavula vulevule ukhuta khulava nu khuhovokha umo unyasambi vuipela nu khukhuta, ukhulutilila avanyavulwel vala “99” avu vene vanchila khusita khupela ");
INSERT INTO zgam_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Khwale veni udala uvi iyancha ihela “10” nu khuyancha ihela yimo sa khatole ikhisikhi nukhumwemwesya nukhuhuma ukhulonda na makha goni nukhupata ihela yimo? ");
INSERT INTO zgam_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Vu awene iyiwene ihela ya mwene ikhuvilonga avanine nu khuvilanga avanine nukhuvilanga avabadihine nukhuta muhovokhage panine nune ukhuva niyiwene ihela iyikhayagile. ");
INSERT INTO zgam_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Pu nikhuvavula nita khukhule ukhuhovokha khuvulongolo khunsuhwa nu Nguluve ulwakhuva unyasambi yumo apelile.” ");
INSERT INTO zgam_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Nu Yisu akhanchova, “Umunu umo ale na vana vavili ");
INSERT INTO zgam_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","umwana udebe akhambula udadaye, Dada ume iligavo ilya vuhele uwa kyuma iyinogilwe khulyione nu vuhale. Pu akhagava ikyuma mugati imbene. ");
INSERT INTO zgam_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Pu isikhu nchi nyingi umwana udebe akhalundamana fyoni ifyalinafyo akhaluta khukhilunga ikya khuvutali nukhu, akha khinila ihela nchoni, nu khugula ifinu ifipelwapelwa, ifi vivi nu khutaganiya ikyuma nu khuhovokha ne khilunga. ");
INSERT INTO zgam_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Umwene vualile ikyuma kyooni, inchala imbaha yikhingila ikhilunga khila pu akhava ne njela imbaha. ");
INSERT INTO zgam_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Akhaluta khulonda imbombo khu munu uva khilunga khila, nu mwene akhang'ilikha khukyalo khya mwene ukhudima ingube. ");
INSERT INTO zgam_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pu alikhunogwa ukhulya nu khwiguta na makhandi aganchisinche ingube, ulwakhuva, asikhuli umunu uvi apile ikyakhulya. ");
INSERT INTO zgam_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pu umwana udebe akhasaga munumbula ya mwene, akhanchova va vombi, akhanchova vavombi valingi khwa dada vilya nu khunywa ifingi nune nifwa ne nchala! ");
INSERT INTO zgam_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nune nihega nilutakhwa dada vango, nukhumbula, “Dada usyikhile khukyanya na pa khilunga na khumiho gakho. ");
INSERT INTO zgam_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Sanenogile ukhuta neve mwana vakho; umbikhe ndumbomba mbombo vakho.” ");
INSERT INTO zgam_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Pu akhahega akhaluta khwa dada va mwene. Vu anchige khuvutali udada va mwene akhambona nu khuvona ikhisa akhaluta na mbivoi nu khunyila nu khukhumbata nu khubusu. ");
INSERT INTO zgam_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Pu umwana ula akhambula akhata, 'dada nelimalunde gakho, usikhile khukyanya na pasi apa na khuvulongolo khumiho gakho savinogile ukhwilangiwa ukhuta neli mwana wako.' ");
INSERT INTO zgam_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pu udada akhavavula avavombi va mwene, mulote umwenda unonu mufwali nche, pete nu khufwa lincha ifilato mumalende. ");
INSERT INTO zgam_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pu mukhatole isenga iyi dutwive mubude tulye nu khuhekhela. ");
INSERT INTO zgam_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ulwakhuva umwana vango afyulelino mwuoni. Ayagile lino avonikhe pu vakhatengula ukhuhekhela. ");
INSERT INTO zgam_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Pu lino umwanaumbaha ale khukyalo, vu ikhwincha nu khuhegelela khukyaya akhapulikha inyimbo nu khwovela nu khukhina. ");
INSERT INTO zgam_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Akhilanga uveimbombo yumo akhambuncha, khulikhikhi khukhuta khikhi? ");
INSERT INTO zgam_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Umbomba mbombo akhata uvuvavo iuchile nu dada vakho abudile isenga iyidutwive ulwakhuva avuyile vunonu.' ");
INSERT INTO zgam_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Umwana umbaha avipile ukhulutilila, akhabela nu khwingila mnyumba gati nu dada akhabembelesya ingile. ");
INSERT INTO zgam_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pu akhambula udadaye, 'Lola une, nekhuvombili imiakha gimingi, nu khwibata indagilo nchoni sugele ukhuma mwenamene, ukhuta ne hekhele na vayango. ");
INSERT INTO zgam_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ulwakhuva, vuinchile umwana vakho uve avangile ikhyama kyakho kyoni nu khulya ne valiguubudile igwada iyedutwive. ");
INSERT INTO zgam_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Udada akhambula akhata, 'Mwana vango, uve ukhale nune isikhu nchoni, nune vyoni ifi nelinafyo vyakho. ");
INSERT INTO zgam_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pu yikhale lunonu khulyufwe ukhuhekhela nu khuhovokha, vu ulukhololwu avonikhe vu akhayagile, akhafyule lino alikhuwumi; na avonikhe.” ");
INSERT INTO zgam_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","U Yisu avavulile khange avakhongi vamwene vamwene, “Pale nu munu umo unkhavi nu vavaha avulilwe ukhuta umbaha uyu inangaviya ikyuma kya mwene. ");
INSERT INTO zgam_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Pu unkhavi akhamwilanga akhambula, “Khinukhi ikhi nipulikha khulyuve? Humya imbalilo incha mbaha vakho, ulwakhuva sawiwesya ukhuva mbaha lino.' ");
INSERT INTO zgam_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Umbaha ula akhanchova munumbula mumwene, Nivombe khikhi, uvunonu wa ntwa vango ikhung'encha mu mbombo yango iya vuvaha? Nelivuvule amakha aga khulima nu khudova dova nevona soni. ");
INSERT INTO zgam_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nelulumanyile eliyakhiva nie vomba upuyakhiva vikhung'e ncha mu mbombo yango iya vuloleli uwa vanu pu avene va ng'egelenche mu mbunchenge wa vene. ");
INSERT INTO zgam_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Pu umbaha va vuloleli akhavilanga avanyamikolegwia ntwa va mwene, akhambula uva khwancha, 'vudayiwa ilingi nu ntwa vango?' ");
INSERT INTO zgam_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Akhanchova ifipimilo khinchigo ifya mono, akhambula 'tola ilikhuratasi uvige “50” hamsini.” ");
INSERT INTO zgam_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","hange ambula uyunge nuve ulinilikhole ilingi?' akhanchova akhata nilinilikhole ilya fipimo “100” ifya vutineuwa ngano.' Akhambula akhatatola ikyandikhilo wandikhe “80”.' ");
INSERT INTO zgam_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Pu untwa akhagwiya umbaha umbivi vu avombile khu vala avanyamakhole. Ulwakhuva avana va khilunga ikhi valinu luhala ukhulutilila nu khuvomba khuluhala ulwa pakyanya pu avanu avaluvafu ulwa vene valipakyanya pa vanya lumuli. ");
INSERT INTO zgam_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nune nikhuvavula mwivombelage ukhuva na vayinyikhu kyuma ikya vuviviukhuta puyakhiva sawipata vavahegelenche khu vutavuo uwa sikhu nchoni. ");
INSERT INTO zgam_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Uviale vaviyilweli khuvudebe iva vayilweli khuvu vaha. na aliye dhalimu katika lililo dogo huwa dhalimu katika lililo kubwa pia. ");
INSERT INTO zgam_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ingave umwe samkhali vayilweli khu kyuma ikya vuvivi pu veni iva vayelweli khu kyuma ikya lweli? ");
INSERT INTO zgam_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Pu ingave mukhale vasita khuva vayilweli pa khu vombela ikyuma kya munu uyunge veni uviyakhiva ikhuvapa ikhiyakhiva ikhuvapa ikhikhivile khinyo yumwe? ");
INSERT INTO zgam_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Asikhuli umbomba mbombo uviiwesya ukhuvavombela avatwa vavili, ulwakhuva ayigugane yumo nu khusula uyunge nu khwiyibata nuyu nu khubeda uyu. Samukhawesye ukhumombela Unguluve ne kyuma.” ");
INSERT INTO zgam_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pu Avafalisayo vuvavo valikhunogwa ihela, pu vagapulikhe aga goni pu vakhabeda. ");
INSERT INTO zgam_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Pu akhavavula, “Umwe ukhuta mukhiginiya khuvulongolo khuvanu, pu Unguluve akhanchimanya inumbula nchetu. Ulwakhuva ilimikhiwe khu munu liva livivi khuvulongolo khwa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Indagilo ncha vanyamalago nchale punchile vu uYohani vuinchile. Ukhuhuma usikhi ugwa imola inonu incha vutwa wa Nguluve ukwinchofancha, nu munu uvavenchaga igela ukhwigila khu makha. ");
INSERT INTO zgam_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ukhuva ikhilunga khipepe fihege ukhuhuma endagilo yimo yihege. ");
INSERT INTO zgam_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Uvi ikhundekha udala nu khugula uyunge nu khutola vatamaniyege iva aligwipe nukhuva indigu, nu yunge uvi ikhutola ula uvialekhilwe nu gosi, ivaindigu. ");
INSERT INTO zgam_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Khwale nu munu umo utayili afwalile iyenda igya mavuva igi ngaladikha igya zambarau ne kitani ikhi nonu, pu alikhuhovokha imisikhi gyoni nu vukhavi wa mwene uvuvaha. ");
INSERT INTO zgam_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nu ganchu umo ilitawa lya mwene ele vi Lazaro avikhiwe pa ndyango ugwa tayili, pu ale ni fikhoho. ");
INSERT INTO zgam_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Pu umwene anogwagwa ukhulya amalagalila agagwile pasi aga fyakhulya pa mesa iya tayili uchili khu myianga ifikho ho ifya uganchu. ");
INSERT INTO zgam_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Pu ula uganchu akhefwa nu khutoliwa nu unsuhwa nu khumbikha khukhifwa ikya Ibrahimu pu khifwa ikya Irahimu. Pu utayili vope akhafwa nu khusyila. ");
INSERT INTO zgam_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Na khuvufwe vuigatanchiwa nu vugatale, akhalola amiho khu kyanya akhambona uIrahamu khuvutale nu Lazaro pa khifuva ikya Irahimu. ");
INSERT INTO zgam_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Akhalila akhanchova, 'Dada rahamu, umbonele ikhisa, usuhe uLazaro anyofye ikhimelelencha ikya fikhonche mumagasi, ahovosye ululimi lwango; ulwakhuva ni gatanchiwa nu mwoto ugu. ");
INSERT INTO zgam_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pu Brahamu akhanchova, 'Mwanavango usage imbukhulilo wakho uvombile imbombo ilingi ivinonu, nu Lazaro nave apilile amavivi. Lino alyapa ihekhela, nuve pu vugatanchiwa. ");
INSERT INTO zgam_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Khu goni ago khuvikhiwe iliguli ilivaha nu vutale pa gati, ukhuta avinogwa ukhuhuma nu khulovokha, ukhwivicha khulyumwe valemwage na va khulyumwe vope valemwage ukhwincha ukhwa.' ");
INSERT INTO zgam_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Utayili akhanchova, 'Nukhudova Dada Brahamu, nikhukhudova usuhe khukha khwa dada vango ");
INSERT INTO zgam_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","khu khaya khuvale avalukholo lwango vahano ukhuta avavunge khuluvipi ukhuta vope yuvikhwincha khunu, khulivupala fincho, valekhe ukhwincha. ' ");
INSERT INTO zgam_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pu u Brahamu akhanchova, 'Khuvale avanyamalago nu Mose vilekhelwe vavapulehinchage avo. ");
INSERT INTO zgam_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Pu untayili akhanchova, 'asikhuli, Dada uBrahamu, lino ingave umunu ihuma khuvunchukha pu ya vipela.' ");
INSERT INTO zgam_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pu Brahamu akhavavula, 'vangave savikhuvapulikha avo uMose na vanyamalago savakhidikhe nela pwu hume umunu khuvunchukha savakhawesye ukhupulikha. ");
INSERT INTO zgam_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","U Yesu akhavavula avakongi va mwene, “Imbombo inchi khuva pa lela avanu ukhutula inongwa nchinoge lanile ukhwinelia, lwamwene umunu uveiuhunchitalencha! ");
INSERT INTO zgam_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yeve hei umunu uywa alwikhugiwe eliwe ilichitu ilyakhuhevetela msingo nukhu tagiwa khunyanja, khwomela ukhuva elela avana avadebe ukhuta vatule enongwa. ");
INSERT INTO zgam_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","4","Mwelolelage. ulukhololwo angakumagile umbunge, umwene agapele usyekhile. Agakhunagile mara saba khusiku yemo khage mara saba khusiku yemo aginche khuliuve nukhunchova, 'nipelile, 'usyekhile!” ");
INSERT INTO zgam_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Avasukhwa vamwene vakhambula Dada, “Twogelekhenche ulwedekho lweto.” ");
INSERT INTO zgam_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","UYesu akhanchova, “Mwamuvinchage nulwedekho ulwa mbegu eya haradarii, mkhale mkhukuvula ubekhi ukhu ugwa nkuyu, 'hega pwu khukhamele munyanja,'gwope gwakhukhuvapulikha. ");
INSERT INTO zgam_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Pwu veni pagati paliume, uvialinumbombi uveilema ikhyalo au uveidema igo'si, uveikhumbula wa humile khukyalo, inchaga nambivi utame ulye ikhyakhulya? ");
INSERT INTO zgam_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Sakhambula, 'nelekhele ikhyakhulya nilye, pwu vikhuge utivo umbombelage impakha apya ni mala ukhulya nu khunywa. Pwa apo nayuve wilya nu kunywa? ");
INSERT INTO zgam_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Sakhasane umbombi uywa ulwakhuva avombile nchila inchavuliwe? ");
INSERT INTO zgam_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Vule vule nayumwe mughavombe inchomuvuliwe munchovage 'ufwe twevavombi twisatunogelanile. Tuvombile nchila inchonchikhano gelanile ukhuvomba.' ");
INSERT INTO zgam_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yakhumile wu ilota khuyerusalemu, agendile mundupakha ulwa khusamaria na khugalilaya. ");
INSERT INTO zgam_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Avile ikhwigela mumbonchege vumo, ikhwa aagine na vanu khinchigo avuvale nuvukoma. Vakhima khuvutali ");
INSERT INTO zgam_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Vakhapwata vakhata “Yesu, Nkhuludeva tukholele ikhisa.” ");
INSERT INTO zgam_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Avile avawene akhavavula, “Mlutage mkavonekhe khuva vatwa makhuhani.”Navene vavile viluta vakhavalanchiwa. ");
INSERT INTO zgam_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yumo avileaponile, akhiliwike khukhuginia U Nguluve. ");
INSERT INTO zgam_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Akhafugama mumalunde ga Yesu akhademya. Umwene ale Samaria. ");
INSERT INTO zgam_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","U Yesu akhanda, akhata, “Savaponole voni khinelugo? Valendakhu avange vala tisa? ");
INSERT INTO zgam_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Asikhuli nayumo uviavonikhe ukhukilivukha khukhuginia U Nguluve, ila uyu ugesya?” ");
INSERT INTO zgam_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Akhambula, “Ema ulutage ulwidikho lwakho lukhuponinche.” ");
INSERT INTO zgam_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Avileavunchiwe na avofarisayo uludeva lwaNguluve lwikhwincha ndeli, U Yesu akhanda akhata, “Uludeva lwa Nguluve sakhivile ndekhinu ikhivonekha. ");
INSERT INTO zgam_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Avanu savalanchova, 'Mulolage khunu!' au, 'Mulole khu! Ulwakhuva uludeva lwa Nguluve lulemugati mundimwe.” ");
INSERT INTO zgam_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","UYesu akhavavula avakhongi va mwene, “akhavalilo yukhifikha mlanogwagwa ukhulola ikhigano khimo ikheya mwana va ndavite, samulakhuvona. ");
INSERT INTO zgam_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Akhavavula, 'Mlolage, ukhu! Mlolage apa!' Mlekhe ukhuluta khwilola, nu khuvakhonga, ");
INSERT INTO zgam_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ndulumuli ulwa nchasi ulumulikha mkhiluga ulutegulila kuvunge nu khuluta khuvuge. Vule vule umwana va Ndaveti alincha ewo khukhigono ikhya mwene. ");
INSERT INTO zgam_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","khuvutegulilo yenogiwa ukhugatanchiwa ni nongwa inyingi nukhubeliwa ne kkivumbumbukha ekhi. ");
INSERT INTO zgam_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nduwuyale ifigono ifya Nwakha, wuyilava woikhwincha umwana va Ndaveti. Valikulya, valikhunywa, ");
INSERT INTO zgam_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","valikhutola nu khutoliwa ipakha akhavalilo akha UNwakha aingile mugalava yekhincha nukhuvabuda voni. ");
INSERT INTO zgam_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Wuyale khumisikhi igya ");
INSERT INTO zgam_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","U Loti, avile akhegile khusodoma, yekhafima ifula iya mwoto ne kiviliti ukhuma khukhiya vakhabudiwa voni. ");
INSERT INTO zgam_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Vwoyilava ewo ilinchova elyakhyu alincha umwana va Ndavati alavaivonekha. ");
INSERT INTO zgam_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ikhigono ikhyo, ulekheukhutavula uvalikhukhano munyumba ikhe atole ifinu munyumba. Na ulekhe ukhutavula uvialekhukyalo ukhuvuya khukaya. ");
INSERT INTO zgam_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mkhumbukhe udala va Loti. ");
INSERT INTO zgam_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Uveavenchaga uveinogwa ukhupokha uvumi wa mwene ikhuvuyanchi, uveavenchaga avealeyancha uwumi wa mwene alapona. ");
INSERT INTO zgam_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nikhuvavula, ikhilo iyo khulava na vanu vaveli pakhihaga khimo. Yumo itoliwa, uyuge isigala. ");
INSERT INTO zgam_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Khulava na vadala vaveli viheveta panie, yumo itoliwa uyuge isigala.” ");
INSERT INTO zgam_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wakamwuliza, “Wapi, Mungu?” Akawaambia, “Pale ulipo mzoga, ndipo tai hukusanyika kwa pamoja.” ");
INSERT INTO zgam_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Akhavavula ikhikhwani umwakhudovela, valekheukhugatala. ");
INSERT INTO zgam_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Akhanchova, “khwale nug'egi khujini uguge, uvisadwadage UNguluve na salikhuvadwadwa avanu. ");
INSERT INTO zgam_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kkwale nufwele khulijiji ilyo, mwope adutelaga mara khingi, alekhuta,'unugeukhukhava uwoyelweli ukhuhuma khumbivi vago.' ");
INSERT INTO zgam_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Khusekhi utali sale tayari ukhutanga, usekhi gwagwavile gulutile akhanchova munumbula ya mwene, 'Ndayeve une sanikhudwadwa U Nguluve au sanikhumwimikha umunu, ");
INSERT INTO zgam_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ulwakhuva ufwele uyu ikhugatancha nikhutanga ukhukava uwayelweli wa mwene, alekhe ukhu gatancha ukhunyinchila khita sekhi.” ");
INSERT INTO zgam_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Untwa akhanchova, 'Polekhincha uwoanchovile ug'egi umbivi. ");
INSERT INTO zgam_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","U Nguluve salagega uwayelweli khuvavalanche va mwene avikhu delila pamusi na pakhilo? Umwene, sakhumilaga khuvene? ");
INSERT INTO zgam_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nikhuvavula ukhuta ig'ega uvugolofu khuvene nambivi. Ulwakhuva umwene va Ndavati alavaikhwincha, alaluvona ulwidikho mkhilunga?' ");
INSERT INTO zgam_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Pwa akhavavula ikhikhwani ikhi khuvanu avavikhivona valinuwa yelweli nukhuvabeda avanu avange, ");
INSERT INTO zgam_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Avavuvavili vatogileukhuluta khutembile khukhwisaya: Yumo U Farisai nuyuge usongasogo. ");
INSERT INTO zgam_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","U Farisai aklima akhadova inogwa inchi inchi mwene yuywa, 'Nguluve, nikhukhulemya ulwakhuva une sanikhwanine ndavage avanu avipokha afya vanu, avanu avavili avaligu, nduyu usogencha songo. ");
INSERT INTO zgam_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nidenda mara khavili khulugo. Nikhumya isadakha ukhuma khuvukhavi wangu. ' ");
INSERT INTO zgam_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pwu usogasongo akhima khuvutali, alemilwe ukwinula amiho sa'mwene khukyanya, alikhutova ekhifuva khya mwene akhata, 'Dada usyekhile une netula nongwa.' ");
INSERT INTO zgam_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nikhuvavula, umunu uyu avayilekhu khaya mwavasyekiliwa imbivi, khulikho ula uyug'e, ulwakhuva ula uveikhwiginia ikhwisiwa, uveikhweyisya ikhwinuliwa. ' ");
INSERT INTO zgam_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Avanu vavagegile avana avadebe, avabasye, avakhogi vavilevalolile ewo, vakhavasikha. ");
INSERT INTO zgam_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","U Yesu akhavilaga khumwene akhata, “Valekhe avana avadebe vinchag'e khulyune, mlekhe ukhuvasiga. Lwa vanu ndava. ");
INSERT INTO zgam_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mwidekhage, nikhuvavula, umunu uviavenchaga uvesikhwambelila uludeva lwa Nguluve ndu mwana lweli salig'ela. ' ");
INSERT INTO zgam_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Undogonchi yumo akhambuncha, akhandova, 'Imanyisi inonu, negahe ndakhikhi pwu nikhave uvumi uwa sikhunchoni?' ");
INSERT INTO zgam_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","U Yesu akhanchova, 'khikhi mkhuyilanga nilinonu? Osikhuli umunu unonu, yu Nguluve mwene. ");
INSERT INTO zgam_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Unchimayile indagilo, ulaligupaga, ulabudaga, ulakhenchaga, uladetaga uvudesi, uvadwadege adadayo na vava vanyokho. ");
INSERT INTO zgam_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Undogonchi akhanchova, 'inogwa inchi nibite ukhuhuma nilidemi.' ");
INSERT INTO zgam_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","U Yesu avileapulikhe inchi akhambula, “Khisigile ikhenu kimo. Ugunche fyoni ufyolinafyo uwape avalemilwe nuve wiva nekhebana khukyanya, pwu winche ug'ogaga. ' ");
INSERT INTO zgam_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Utayari avileapolikhe ewo, akhalile lweli, ulwakha ale mofu. ");
INSERT INTO zgam_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Pwu U Yesu, akhambona wvavipile lweli akhanchova, uwuyelava tabu khuvakhani ukwing'ela khuludeva lwa Nguluve! ");
INSERT INTO zgam_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ulwakhuva yilava khilele tingamila pkhalyango akhasindano, ukhulutala kavi ukhwigeila kuludeva lwa Nguluve. ' ");
INSERT INTO zgam_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Avapulikhe incho, vakhanchova, 'Veni lino, uviyakhiva ipona?' ");
INSERT INTO zgam_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","U Yesu akhanda, 'Inogwa inchile mchine khuvanu kuwa Nguluve inchikhwidekhana.” ");
INSERT INTO zgam_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","U Peteli akhanchova, 'ufwe, tufile khile fyoni tukhukhogile uve. ' ");
INSERT INTO zgam_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Pwu U Yesu akhavavula, Mwidikhag'e, nikhuvavula asikhuli umunu uveayelekhile inyumba, udala, avalukhololwe, avahonchi na vana, khuludeva lwa Nguluve, ");
INSERT INTO zgam_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Uvesalakhava ifingi pakhilunga ikhi, nakhukhilunga ikhikhwincha alakhava uwumi uwa sikhunchoni. ' ");
INSERT INTO zgam_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Avile avalundaminye vale khinchigo na vaveli, akhavavula, 'Mlolage, twitoga ukhuluta khu Yerusalemu, inogwa nchoni inchisimbiwe na vayamalago khu mwana va Adamu nchinchivombekha. ");
INSERT INTO zgam_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ulwakhuva evekhikhiwa mumavokho ga vayapanchi vikhumbombela imbivi, nukhube hela ");
INSERT INTO zgam_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","amati. Wuvatovile ni ngomo vikhumbuda isikhu iya datu inchukha. ' ");
INSERT INTO zgam_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Savanchimaye inongwa nchi, nelimenyu ililyafihiwe khuvene, na savalumaye inongwa inchinchoviwa. ");
INSERT INTO zgam_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","U Yesu avileahegelile ku Yeriko, umunu yumo uviabofwile atamile mudu khanchi musewe alikhudova ulutagilo, ");
INSERT INTO zgam_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Akhapulikha avanu wu vigenda akhavuncha khenukhekhi ikhivone kha. ");
INSERT INTO zgam_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Vakhambula vakhata U Yesu uva Munazareti igenda. ");
INSERT INTO zgam_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Pwu ubofule akhalila fincho, akhata, 'Yesu, vi mwana va Ndaveti, ug'olele ikhisa.' ");
INSERT INTO zgam_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Avagendaga vakhabencha ula ubofule, vakhara anunale. Umwene akhendelela ukhulila fincho, 'Mwana va Ndaveti, ug'oleleikhisa. ");
INSERT INTO zgam_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","U Yesu akhima akhavavula umunu ula akhilikhiwe khumwene. ");
INSERT INTO zgam_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Ubofule avile ahegelelile, U Yesu akhambuncha, Winogwa nikhuvombelekhikhi?' Akhanda, 'Dada, ninogwa ukhulola.' ");
INSERT INTO zgam_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","U Yesu akhambula, 'Ulolage. Ulwidikho lwakho lukhuponinche.' ");
INSERT INTO zgam_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Usikhi ugwa alikhulola, akha khonga U Yesu nukhuginia U Nguluve. Vavilevalolile ewo avanu voni vakhaginia U Nguluve. ");
INSERT INTO zgam_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","U Yesu aingile akhagenda pagati pa Yeriko. ");
INSERT INTO zgam_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Napo pale nu munu yumo alikhulambuliwa Sakhaye. Ale mbaha va vasongasogo khageale momafu. ");
INSERT INTO zgam_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Anokhwagwa ukhumbona U Yesu munu vandakhikhi, alemilwe ukhumbona ulwakhuva avanu vodegile, umwene ale isupi fincho. ");
INSERT INTO zgam_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Pwu, akhalogola nambivi khuvanu, akhatoga mbinkhi ambone U Yesu ulwakhuva U Yesu agendile injila ila. ");
INSERT INTO zgam_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","U Yesu avileafikhe pala akhalola khukhiya akhambula, sakhayo ikha nambivi, ulwakhuva ilelo nilenda munyumba yako.' ");
INSERT INTO zgam_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Akha gakha nambivi, akhikha akhamwambelila khuluhekhelo. ");
INSERT INTO zgam_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Avanu voni vavilevalole incho, vakhakhuta, vakhata, 'Alutile khukhugendela umunu utulanogwa.' ");
INSERT INTO zgam_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","U sakhai akhima akhanchova Ntwa, Lola Ntwa nusu ya khyuma kyango nikhuvapo avalemilwe, yegave nepokhile khumunu ikhinu, nikhumbunchekhencha mara khane. ' ");
INSERT INTO zgam_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","U Yesu akhambula, elelo uvupokhi vufikhe mnyumba eye, ulwakhuva mwape mwana va Abrahamu. ");
INSERT INTO zgam_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ulwakhuva umwana va munu inchile khulonda nu khuvapo kha avanu avayagile. ' ");
INSERT INTO zgam_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Vavile vapulikhe ewo, akhedelela ukhunchova akhakhumya ikhihwani, ulwakhuva alepipi ne Yerusalemu, avene vakhata uludeva lwa Nguluve lukhegelile lulepakhuvonekha nambivi. ");
INSERT INTO zgam_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Pwu akhavavula, “Ukhalani yumo alutile khukhilunga ikhyakuvutali akhambilile uludeva nu khukhilivukha. ");
INSERT INTO zgam_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Akhavilanga avavombi vamwene khinchigo, akhavapa ifineigo kumi, akhavavula, 'Mvombage iligunchi mpakha nelavanikhi ilivukha.' ");
INSERT INTO zgam_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pwu avanuva mwene vakhambi pela vakhasuha avakhape tamu valute vakhoge nukhuta, satwinogwa umunu uyo atulogonchage.' ");
INSERT INTO zgam_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pwu avileakhiliwikhe khukhaya wuvapile uvutwa, akhavavula avavombi uwuavalekhile indalama velagiwe khumwene, alumaye utengo ugwavapatile khumbo iyuvakhavokhavombelega. ");
INSERT INTO zgam_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Uvakwanda akhincha, akhanchova, 'Ntwa, ikhibina khyako kiholile amabina kumi khuvulogolo. ' ");
INSERT INTO zgam_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Pwu ukalani akhambula, lunonu, ulembombi inonu. Ulwa khuva ukhale mwidekhinchi khumbombo endebe, wiva mwemelenchi khu vunchege khinchigo. ' ");
INSERT INTO zgam_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Uvaveli akhincha, akhata, 'Ntwa, ikhibina khyakho kholile amabina gakhano.' ");
INSERT INTO zgam_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ukalani akhambula,'Tola uvuloleli khuvunchegi vukhano. ' ");
INSERT INTO zgam_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nu yuge akhincha, akhata, 'Ntwa ulupa ulutalama lwakho, Ngalubinile vunonu mumwenda, ");
INSERT INTO zgam_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ulwakhuva gadwadile uve ulemunu ikhali. Vutola khila ikhyuvekhile nukhubena ikhu suvyalile. ' ");
INSERT INTO zgam_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ukalani akhambula, 'Khumamenyu gakho nilhukhuhega, vivombi vembivi. Ukhalumayile ukhuta une numunu nkali, nitolaikhi sanivikhile nu khubena ikhisa nivyalile. ");
INSERT INTO zgam_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Khikhi, sukhavekhe ulutalama lwago khubengi, wunikhilivukha nitole paninie nulutitu? ");
INSERT INTO zgam_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ukalani akhavavula avanu avaemile pale, 'Pokhaga ubina mkhape ula unyamibina khinchigo.' ");
INSERT INTO zgam_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Vakhambula, 'Ntwa, umwene alenemibina khinchigo. ' ");
INSERT INTO zgam_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nikhuvavula, khila avyalinafyo akhwogelenchiwa afinge, uvialivuvule, vitola nafilafila afialienafyo. ");
INSERT INTO zgam_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ulwakhuva avalugu vago, sawa khanogwa ukhata nive nkhu ludeva vavo, vag'eg'e apa mvabude khuvulogolo khulyune.” ");
INSERT INTO zgam_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Avile anchovile ewo, alikhulule kuvulogolo alikhutoga ukhuluta ku Yerusalemu. ");
INSERT INTO zgam_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Avile akhagelile khu Bethfage, na ku Bethania, pawipi nekhikyamba ikhya Mizeituni, akhava sukha avakuongi vavile, ");
INSERT INTO zgam_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Akhata: 'Mlutage mumbunchege uvulipipi. wumwingile, mkha londage ikhyana khya ligodowe ikyusakhitogiwe. Muhudulage, mukhag'eg'e khulyune. ");
INSERT INTO zgam_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Umunu agavavunche, 'khikhi mukhwavula? 'Munchova, “Ntwa ikhuyelonda.” ");
INSERT INTO zgam_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Avasukhiwe vakhaluta vakhayivona inyana ya ligodowe nduwvu U Yesu avavulile. ");
INSERT INTO zgam_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Vavilevikhwavula inyana ya ligodowe, avanyaligodowe vakhavavula, 'Khikhi mukhwavula inyana ya ligodowe ile?' ");
INSERT INTO zgam_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Vakhanchova, 'U Ntwa ikhuyelonda. ' ");
INSERT INTO zgam_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pwu vakhahelekha kwa Yesu, vakhatandikha imienda giavo pakyanya panyana ya ligodowe vakhantoncha U Yesu pakhinya. ");
INSERT INTO zgam_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Avileiluta avanuvalikhutandancha imienda ngivo musevo. ");
INSERT INTO zgam_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Avileikhwi mkhiyamba ikhiya Mizeituni, ikhipuga khoni ikhiya vakongi valikhululitela na khuginya U Nguluve khumamenyu amavakha, khumbombo imbakha inchovanchiwene, ");
INSERT INTO zgam_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Valikhula, 'Uyu usayiwa ukurudeva uviikuwineha khulitawa lya Ntwa! Ulukhugu khukyanya, nulunonehekhencho khukyanya!' ");
INSERT INTO zgam_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Avafarisai palulundamano vakhambula, Ndemi, vanunanche avakhongi vakho. ' ");
INSERT INTO zgam_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","U Yesu akhanda, akhata, 'Nivavule, vagave ava vinunula amaganga giywegapa fincho. ' ");
INSERT INTO zgam_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","U Yesu avileakhegelile mumbo nchege akhalila, ");
INSERT INTO zgam_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Akhanchova mwalemulumaye nayumwe ikhigono ikhyilelo imbombo inchikhugegela uluhungu! Lino nchifikha mikhe pamikho gakho. ");
INSERT INTO zgam_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ulwakhuva ifigono fikhwincha udugu vakho alanchenga uvunehege panie nuve, nukhukhu naugula nukhukhudidelencha ukhuma khwoni. ");
INSERT INTO zgam_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Vikhukhugwisya pasi uve na vana vakho. Savakhakhulekhele iliwe limo pakhya panige, ulwakha sawalumaye usikhikhi U Nguruve apwavakhanogwagwa ukhukhupokha.' ");
INSERT INTO zgam_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","U Yesu akhigila Mtempeli, akhategula ukhuvamanyisya avagunchaga, ");
INSERT INTO zgam_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Akhavavula, “Yesimbiwe, “Inyumba yago yiva nyumba ya khuvisayila, 'Umwe mvekhile ukhuva lipagala lya vakhenchi.” ");
INSERT INTO zgam_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","U Yesu alikhumanyisya khila khigono Mtempeli. Avantwa na vamayisi va ndagilo na valogonchi va vanu vakhanogwa ukhumbuda, ");
INSERT INTO zgam_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pwu vakhahemwa injila iya khugakha fwo, ulwakhuva avanu voni valikhupulikhencha nulukhala. ");
INSERT INTO zgam_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ikhava ikhigono khimo, U Yesu alikhumayisya avanu mtembile nu khulumbilila elimenyu, avatwa avavakha na vamayisi ava dagilo vakhadutela paninie na vagogolo. ");
INSERT INTO zgam_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Vakhanchova, valikhumbula, 'Utuvule khumakha agani vuvu mbaimbombo inchi? Veni akhupile uvuvakha uvu?” ");
INSERT INTO zgam_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Umwene akhanda, akhavavula, 'Nayune leno nikhuvavuncha ikhulongu. Numbule ");
INSERT INTO zgam_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohani. Lwakhumile kukhiya au khuvanu? ' ");
INSERT INTO zgam_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Valikhukhanikhana vavo khwavavo, valikhuta,'Tunganchove, 'Lwakhumile khukyanya, ikhutuvuncha khekhi samulekhwi dekha?' ");
INSERT INTO zgam_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pwu tuganchova; lwakhumile khu vanu; avanu vaniapa vikhutova na magaga, ulwakhuva voni vikhwedekha ukha U Yohana ale Nsug'wa.' ");
INSERT INTO zgam_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Pwu, vakhanda ukhuta savalumayile ukhwulukhumile. ");
INSERT INTO zgam_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","U Yesu akhavavula, '“Une sani khuvavula umwe ukha khumakha gani nivomba inchi.” ");
INSERT INTO zgam_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Akhavavula avanu eikhihwani ekhi, “Umunu yumo avyalile emizabibu, mukhyalo akhalila khuvanu avaya fyalo ifya mizabibu, pwa akhaluta ikhilunga ikhinge khusekhi untali. ");
INSERT INTO zgam_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Khusekhi ugwa vekluve, akhasukha umbombi khuvayafyalo ifya mizabibu, ukhuta vampe iligavo lya sekhe mugunda ugwa mizabibu. Pwu awayafyalo ifya mizabibu vakhabela, vakhakilivula amavokho gene. ");
INSERT INTO zgam_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Akhasuha umbombi uyuge ave vakhantova, nukhumbombela fivi, vakhakhilivula amavokho gene. ");
INSERT INTO zgam_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Akhasuha uvadatu mwope vakha ndemancha nukhutaga khunchi. ");
INSERT INTO zgam_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Unyagunda akhata, nigakha ndakhikhi? Nikhusukha uswambago ugane. Opange yuvikhudwada. ' ");
INSERT INTO zgam_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pwu avanyafyalo ifya mizabibu vavilevikhumbona, valikhukhanihana vavo khwa vavo valikhunchova, 'uyu vinyavuhale. Tumbode, uvukhale wa mwene vuve wetu. ' ");
INSERT INTO zgam_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Vakhag'umia khinji khugunda ugwa mizabibu nu khumbuda. Pwu unyagunda ikhuvagakha ndeti? ");
INSERT INTO zgam_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ikhwincha khukhuvabuda uyafya fyalo ifya mizabibu nukhuvapa ugunda ukhwa avange. “Avene vavilevapulikhe ewo, vakhata, 'Unguluve abelie' ");
INSERT INTO zgam_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pwu U Yesu akhvalola akhata, “Uvusimbe uvu vulienuvufumbue vuki? 'Iliw ilyovobabelile avanyanyakhunchenga, livele liwe lya palukhanchi? ");
INSERT INTO zgam_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Khila munu uveigwa pakhyanya paliwe ilyo, idenyekha fipande fipande. Ulauveyakhiva likhugwila, likhundemancha.' ");
INSERT INTO zgam_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Avasimbi na vatekhenchi valikhulonda injila iyakhumwibata usekhi gugwa, valumanyile ukhuta anchovile ekhihwani khuvene. Pwuvalikhudwada avanu. ");
INSERT INTO zgam_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Vakhendola khukhisa, vakhasuha avapelelesi avalikhwivona ukhuta vogolofu, valikhulonda inogwa ukhuhuma mumbulumbileli vwa mwene, pwu vamwibata vakhelekhe khu vavakha ");
INSERT INTO zgam_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Avene vakhambunha, vakhata, “imanyisi tulumayile ukhuta winhova nukhuumasya uwayelweli savusogiwa nu munu uviavenchaga, uve vumanyisya uwayelweli khunjila iya Nguluve. ");
INSERT INTO zgam_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ufwe yenogile ukhukhomba isongo khwa Kaisari, au vudesi?” ");
INSERT INTO zgam_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","U Yesu akhagamanya amasago gavene, akhavavula, ");
INSERT INTO zgam_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mumbonesye edinari. Esura nuvusimbe wani pakhyo?” Vakhanchova, 'Wa Kaisaria.” ");
INSERT INTO zgam_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Umwene akhaakhavavula pwumupenchage UKaisari ifya mwene nu Nguluve mpenchage ifya Nguluve. ");
INSERT INTO zgam_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Avasimbi na vatekhenchi vakhalemwa ukhubencha akhyoanchovile khuvulugolo khuvanu. Valikhuswiga anyadile ya mwene savakhanchova khinu. ");
INSERT INTO zgam_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Pwu avamasadukhayo vakhadutela, avachoraga ukhuta khusikhwuli ukhuchukha, ");
INSERT INTO zgam_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Vakhambuncha, vakhata, “Imanyisi, U Mose atusimbile ukhuta umunu agafyilelwe nulukhololwa unyadala unchila mwana yenogiwa ukhutola udala uvalukhololwe nukhuhole nawe. ");
INSERT INTO zgam_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Khwale na vanamunu saba uvakhwanda atolile, akhafwa khetandekha umwana, ");
INSERT INTO zgam_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nayuvavili mwope. ");
INSERT INTO zgam_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Uvadatu akhantola vulevule uvasaba sandekhe umwana akhafwa. ");
INSERT INTO zgam_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Usikhi wwukhulutile undala mwope akhafwa. ");
INSERT INTO zgam_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Pwu khuvunchukha ivadala vani? Ulwakhuva voni saba vatolile. ' ");
INSERT INTO zgam_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","U Yesu akhavavula, “Avana vakhiluga ekhi vitola nukhutuliwa. ");
INSERT INTO zgam_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Avanogelanile ukhwambilila uvuchukha wavafwile nukhwigela khuludeva lwa khukhya savitola wala ukhutoliwa. ");
INSERT INTO zgam_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Savifwa khavili, ulwakhuva vakha wanine ndavasug'wa na vanava Nguluve uvana va vunchukha. ");
INSERT INTO zgam_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pwu avafwile vinchusiwa, nu Mose avanisye pakhisitu, pala pwuamwelagile Untwa vi Nguluve va Abrahamu nu Nguluve va Isakha nu Nguluve va Yakobo. ");
INSERT INTO zgam_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Lino, umwene sio ve Nguluve vavafwile, ila avumi, ulwakhuva voni vitama khumwene.” ");
INSERT INTO zgam_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Avag'e avamanyisi vandagilo vakha mwanda, 'Imanyisi, uchovile vononu. ' ");
INSERT INTO zgam_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Vakhadwada ukhumbuncha amameyu agange. ");
INSERT INTO zgam_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","U Yesu akhavavula, “Khekhi avanu vita Kreste mwana va Ndaveti? ");
INSERT INTO zgam_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daudi anasema mwenyewe katika zaburi: U Dada ambulile Dada vango: ");
INSERT INTO zgam_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Tama khukhivoko ikhyando, Ipakha nivavekhe avavivi vakho pasi pamalunde gakho. ' ");
INSERT INTO zgam_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","U Ndaveti akhamwelaga Kreste 'Daada,' yivandakhikhi mwana va Ndaveti?” ");
INSERT INTO zgam_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Avanu voni vavilevikhupulekhencha akhavavula avakhongi va mwene, ' ");
INSERT INTO zgam_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Mwilolelage na vasimbi, avinogwa ukhugenda vafwalile imienda imitali, vinogwa ukhusamusiwa khusokhoni nukhutema ifigoda ifitali mtembile, na amamenyu akhakhisa. ");
INSERT INTO zgam_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Avene pwa vilya khuyumba encha vafwele, vigaha ukhuta vikhwesaya ulwesayo ulutali. Ava valaambilela uvukhegi uvuvakha fincho. ' ");
INSERT INTO zgam_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","U Yesu alolile akhavavona avagosi avatayeni avavikhaga ikhela chavene khubengi. ");
INSERT INTO zgam_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Akhambona ufwele yumo ug'anchu vuvivekha indalama chamwene ivele. ");
INSERT INTO zgam_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Pwu akhanchova, “Lweli nikhuvavula, uyu ufwele uganchu avekhile nyingi uuhusinda avage voni. ");
INSERT INTO zgam_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Avage voni vakhuminche ikhela ukhukhogana nuvumofu wavo. Ufwile uyu, mumboganchu wa mwene, ne ahuminche indalama nchoni inchoa khale nacho mumbwumi wa mwene.” ");
INSERT INTO zgam_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Avagevavilevinchova itembile, umunu vayenochekhinehe na mawe amanonu ne enekhelo, akhanchova, ");
INSERT INTO zgam_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ukhunogwa inchomukhunchivona, isiku nchikhincha inchu iliwe salilasigala pakhyanya paliweilege ililakhenchiwa.” ");
INSERT INTO zgam_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Pwu vakhambuncha, vakhata, “Imanyisi, inogwa inchi nchilahumela ndeli? Filahumilago ifidegofikhu ukhuta inogwanchi nchilepakhumila?” ");
INSERT INTO zgam_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","U Yesu akhanda, “Muve nuluhala mlekhe ukhusiviwa. ");
INSERT INTO zgam_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mkhapulikhe iligoha nefujo, mlekhe ukhudwadwa, ulwakhuva inogwa inchi mpakha nchihumile, uvusilelo savukhahumile nambivi.” ");
INSERT INTO zgam_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Pwu akhavavula, “Ikhiluga khilima ukhulwa ni khiluga ikhige, uvutwa nu vuywa uvunge. ");
INSERT INTO zgam_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Khulava nekheseyenge ikhivaha, nenjala nitavuni khuvutali na khuvuli. Khulava ninogwaincha khudwancha nifidego ifyakho dwancha ukhuma khukyanya. ");
INSERT INTO zgam_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Wunchikhale inogwa incho nchoni, vivekha amakho gavo nukhuvatesya. Vikhuhelekha khutembile na khukhikugwa, ukhuvagega khuvatwa na valo gonchi khulitawa lwago. ");
INSERT INTO zgam_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Eye yelavapa uvulegefu khulwelekho lweyo. ");
INSERT INTO zgam_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pwu mulamulage munumbila nchiya ukhulekha ukhwitetela, ");
INSERT INTO zgam_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ulwakhavanikhuvapa amameyu akhaluhala, uluawavivi venyo savakhanesye ukhukanika au ukhubela. ");
INSERT INTO zgam_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","aAvahonchi veyo vala vabelagha, avalukhulolwenyo, avamanyani vuyo valabudivaga avageavayenyo. ");
INSERT INTO zgam_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Valavakha lalila avanu voni khulitawa lyango. ");
INSERT INTO zgam_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Lusikhuli uluyele khalalumo ulalayaga khumitwe gienyo. ");
INSERT INTO zgam_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Vwu mukhwumilila mlanchipokha inumbula ncheyo. ");
INSERT INTO zgam_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Apayamwivona Yerusalemu yenchova guliwe na vasikhali, mlumaye ukhuta uvunagi vukhegelile. ");
INSERT INTO zgam_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Avale ku Yudea vayililage khufyamba, navala avalipagati pa vunchege vakhegage, valekhe ukhuvalekha avalekhu vijiji ukhukhilivukha. ");
INSERT INTO zgam_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ulwakhuva isikhu nchi ncha vukhuvelwa, pwuinogwa nchoni nchasimbiwa nchikwele. ");
INSERT INTO zgam_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Vukhuvelwa khuvala avanyavunchita navala avikwisya umesekhi ikhyo! Ulwakhuva kulava netabu imbaha mukhihuga, nuvuhegi khuvanu ava. ");
INSERT INTO zgam_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Valatemiwa ni mundu valatoliwa vavanda khufiluga fyoni, ne Yerusalemu yelakhayiwa na vaya panchi, ipakha usekhi ugwa vanu avanyapanchi gulavakhukwela. ");
INSERT INTO zgam_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Khulava nefidego khulinchuva, nu mwenchi ninodwa. Khukilunga khulava nenjala ya vanyapanchi, ukhugatala khula humananunchwego gwa Nyanja numbelo. ");
INSERT INTO zgam_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Khulava navanu avichilekha khuvudwanchi, wuvikhuvila inogwa inchoyakhiva nchihuilo mukhilunga, ulwakhuva amakha ga khiluga galatetema. ");
INSERT INTO zgam_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Pwuvalambona umwana va Ndaveti waikhwikha mumavego na makha nu vuvalanche uvuvakha. ");
INSERT INTO zgam_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Inogwa nchi apyachitegula ukhuhumila, mwimage, mwunulage imitwe gwinyo, ulwakhuva uvupokhi wenyo vulugelile pawipi.” ");
INSERT INTO zgam_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","U Yesuakhavavula khukhihwani, “Mlolage umbekhi, nemibekhi gwoni. ");
INSERT INTO zgam_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Vwuvukhumila uvuluva, mukhilolela yumwe nukhulumanya ukhuta ikhinchuva khihegelile. ");
INSERT INTO zgam_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Vulevule, mwumilola imbombo ncho nchihumila, umwe mulumanyage ukhuta uludeva lwa Nguluve luhegelile. ");
INSERT INTO zgam_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Elweli, nikhuvavula, ikhipaponkhi sakhikhalute, nupakha inogwa nchi apyanchikhumila. ");
INSERT INTO zgam_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Khukyanya napasi vilaluta, amameyu g'ago sakhagalaluta lusikhu. ");
INSERT INTO zgam_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Mwilolage yumwe, ukhuta inumbula nchayo nchila vatola nuvulwasi, uvuganchi, nukhuhagayekha nifyakhiluga ikhi. ");
INSERT INTO zgam_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ulwakhuvaikhigono khile khilincha nambiwe Ndulutambo. Ulwakhuva yelavakhwakhila munu uvitama pasi pamiho ga khilunga khyoni. ");
INSERT INTO zgam_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pwumume mikho imisikhe gwini, mudovageukhuta muvevunonu ukhuhene inogwa ncho apyachihumila, nukhwima khumiho khumwana va Ndaveti.” ");
INSERT INTO zgam_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Pamusi amanyisyaga mutembile pakhilo alikhuhuma khunji, nu khuluta khukyamba ikhitambuliwa Mizeituni. ");
INSERT INTO zgam_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Avanu voni vamwinchile panavusi khu vwukhilo khukhupulehencha mugati mutembile. ");
INSERT INTO zgam_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Esikhukhu iya fivanda yahegelile, iyitambuliwa pasakha. ");
INSERT INTO zgam_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Avatwa navasimbi vakhavunchana umwa khubudela U Yesu, ulwakhuva valikhuva dwada avanu. ");
INSERT INTO zgam_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Utavagwa akhigila mugati mwa Yuda Isikariote, uninje navakhogi khinchunigo na fiveli. ");
INSERT INTO zgam_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","U Yuda akhaluta khuvunchania na vatwa umwakhug'elekhila U Yesu khuvene. ");
INSERT INTO zgam_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Vahowikhe, nukhwidekhana ukhumpa indalama. ");
INSERT INTO zgam_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Umwene aedikhe, alikhulonda usekhi ugwakhug'elekha U Y esu khuvene khuvutali nchukhunchi lya vanu. ");
INSERT INTO zgam_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ikhigono ikhya fivanda ikhafikha, upwuyinogiwa ig'osi iya Pasakha yekhuminchiwe. ");
INSERT INTO zgam_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","U Yesu akhavasuha U Peteri nu Yohani, akhanchova, “Mulutage mkhatunonchehenche ikhyakhulya ikhya Pasakha twinche tulye.” ");
INSERT INTO zgam_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Vakhambuncha, “Ndakhuwinogwa tukhavombe imbmbo iyo?” ");
INSERT INTO zgam_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Akhavanda, “Mpulikhinchage, apya munchikhwigile mumbunchege, khumbona ugosi itwekhile incilo ya magasi ivapaninie numwe. ");
INSERT INTO zgam_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mkhogage khuyumba iyu akhivaikhwigile. Pwumumbulage unyayumba, “Umanyisi ikhukhuvula, “khilindakhe ikhiyumba ikhyavageni, upwunino gwa ukhulya ipasakha navakhogi vango?” ");
INSERT INTO zgam_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ikhuvavonesya ikhiyumba ikhya khukyanya khitayani. Mkhutesaniage umwa.” ");
INSERT INTO zgam_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Pwu vakhaluta, vakhakhanchivona khila khinu nduavavulila. Vakha noncha ikyakhula ikhyapasakha. ");
INSERT INTO zgam_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Usekhi gwa vilekhufikhe atamilena vakongi va mwene. ");
INSERT INTO zgam_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Pwu akhavavula, “Ninogwa lweli ukhulya ipasakha numwe usekhi wusakhutegwile ugwavukhuvita wago. ");
INSERT INTO zgam_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ulwakhuva nikhuvavula, sanikhalye khavili ipakha ipyayekhwalanile khuludeva lwa Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","U Yesu akhatola ikhiywelo, avile adovile, akhata, “Mtolage ikhimga vane yumwe khwa yumwe. ");
INSERT INTO zgam_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ulwakhuva nikhuvavula, sanekhalye khavile unsabibu, impakha uludeva lwa Nguluve apialufikhe.” ");
INSERT INTO zgam_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pwu akhatola akhivanda, akhisaya, akhameyula, akhavapa, akhanchova, “Ugu gwumbili gwago ugukhume nchiwe khulwimwe. Mgakhage vulevule mwumkhug'umbukha une.” ");
INSERT INTO zgam_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Akhatova ikhiyelo vulevule wuvigonikhe akhata, “Ikhiywelo ikhi lwidekhano ulupya khukhisa gwago, ukhududikhe khumbivi ncheyo. ");
INSERT INTO zgam_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pwu mlolage. Ulauveikhumbuda pwale panienune pamesa. ");
INSERT INTO zgam_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ulwakhava umwana va Ndavati iluta nduwa yasimbiwe. Pwu elolelageumunu uviukhugendela umwene umwana va Ndaveti ibudiwa!” ");
INSERT INTO zgam_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Vakhategula ukhuvanchana vavo khwa vavo, veni pagati palwufwe aviimbomba ewo. ");
INSERT INTO zgam_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Lukhahumila ulukhani pagati pavene ukhata veni uveyaivaimba imbakha khuvoni. ");
INSERT INTO zgam_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Akhavavula, “Avakhuludeva va vanu avanyapanchi valinavakha khuvene, navala avanyamakha khukhyanya khuvene vikhuvatambula vavaha valoleli. ");
INSERT INTO zgam_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Sayinogiwe lweli ukhuva ewo khulyumwe. Pwu mwilekhelwe ula umbakha khulyumwe ave ndu mwana udebe. Nulauvalutogo fincho aveduve ivomba. ");
INSERT INTO zgam_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Pwu alikhu umbakha, ulauveitamapamesa, au ula uveivomba? Syulouveitama pamesa? Nayune neledula uveivomba pagati palyumwe. ");
INSERT INTO zgam_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Umwemwemwe mwivapanie nune mumbukhuvilwa wangu. ");
INSERT INTO zgam_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nikhuvapa umwe uludeva, nduwuudada amile uneuludeva, Pwumulinchage nakhuywa khuludeva lwago. ");
INSERT INTO zgam_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mtamamfitamelo ifya ludeva wumukhuvahega ifivu mbukho khinchigo na vivile ifya vayaisivaeli. ");
INSERT INTO zgam_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simioni, Simioni, ulumanya ukhuta, utavago adovile ukhuta avapete ndinganu. ");
INSERT INTO zgam_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ulwakhuva nikhudovile, ulwedikho lwakho lulekhe ukhufwa. Apya ukhiliwikhe kavili uvakhaganchage, avalu khololo.” ");
INSERT INTO zgam_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","U Peteri akhambula, “Dada, nili tayari ukhuluta nunu khukhikugwanakhuvufwe.” ");
INSERT INTO zgam_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","U Yesu akhanda, “Nikhukhuvula, Peteri, ilikhogove salikhavike ilelo, wusumbelile mara khadatu ukhuta umayile.” ");
INSERT INTO zgam_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pwu U Yesu akhambula, “Navile nevakhelikhe umwe khinchila mpakho, ikhitundu ikhya finu, au ifilato, pwu mkhalemilwe khinu?” Vakhanda ate.” ");
INSERT INTO zgam_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Akhavavula, “Lino, khilaunyapako, agutole ponie nekhitundu ikhyafi akula. Ulauvealivuvule emundu yenogile agunche ikhanjo ya mwene agule khimo. ");
INSERT INTO zgam_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ulwakhuva nikhuvavula, nchoni inchisimbiwe khuliune ipakha nchikwela, 'Atoliwe ndumunu uviadenyile indagilo; Ulwakhuva khila ikhyanchoviwe khulyone khikwelile.” ");
INSERT INTO zgam_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Pwu akhanehove, Dada, lola! Pwunchile apa imundu ivele.” Pwuakhavavula “yekhwelile.” ");
INSERT INTO zgam_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Wuvalile ikhyakhulya ikhyakhu kimihe, U Yesu akhahega, nduwu akhavombage imisekhe gwini, akhaluta khukyamba ikhya Mizeituni, vkhongi vakhakhonga. ");
INSERT INTO zgam_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Vavilevafikhe, akhavavula, “Mdovage ukhuta mlekhe ukhwigela mudugelo.” ");
INSERT INTO zgam_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Akhaluta khuvutali navene ndu khulaha iliwe, akhafugama akhadova. ");
INSERT INTO zgam_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Akhata, “Dada, unasewinogwa ghe nchechenche ikhiywelo ikhi. Yelekhe ukhuva nduwuninogwa une, uvunogwe wakho vukhogiwage.” ");
INSERT INTO zgam_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Avasug'wa ukhuhuma khukhyanya akhagihumila, akhampa amakha. ");
INSERT INTO zgam_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Wualipakhutamwa, akhadova khunumbula yoni, nedwinga amavaha agakhisa galikhugwa pasi. ");
INSERT INTO zgam_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Avileasisimwikhe ukhuhuma khukhwisaya, akaluta khuvakhogi, akhavona vagonelile ulwakheva vasusuvile, ");
INSERT INTO zgam_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Akhavuncha, khikhi mugonelela? Sisimukha mudovage, ukhulamulekhe ukhwigila mudogelo.” ");
INSERT INTO zgam_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Avile baduipinchova, lola, ikhipuga ikhivaha ikhya vanu khikha humila nu Yudaiskariote, ukhukogi va mwene akhava logoncha. Akhincha karibu nu Yesu ukhuta amwabasye, ");
INSERT INTO zgam_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pwu u Yesu akhambula, “Yuda, lweli vukhubuda umwana va Ndaveti nukhumwabasya?” ");
INSERT INTO zgam_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Usikhi gulaavelepawipi nu Yesu vavile valolile ncho, vakhanchova, Dada, tuvegede ni mundu?” ");
INSERT INTO zgam_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Pwu yumo akhantova umbombi va Ntwa, akhageda imbulukhutu iya khudio. ");
INSERT INTO zgam_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","U Yesu akhanda, “Iyeyekhwelile. Akhabasya imbolukhutu yamwene akhaponia. ");
INSERT INTO zgam_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","U Yesu akhanchova khuNtwa umbakha, nakhuvavaha vatembile, nakhuvadyakoni avainchile khiyume numwene. Pwu mwikhwincha ndavanu aviluluta khwilwa navalyasi, ninyambunda ni mundu? ");
INSERT INTO zgam_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Upwanekhale numwe isinchuchooni mtembile, samkhavigha amavokho giyo khutwe khulione. Lin khavalilo khako, nuvuvaha uwakhisi.” ");
INSERT INTO zgam_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Vakhamwibata, vakhandogoncha, vakhaghilikha khunyumba iya Ntwa umbaha. U Peteri alikhukonga khuvutali. ");
INSERT INTO zgam_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Vavile vapulile umwoto musebule iyagati vakhatama panie, u Peteri akhatama pagati pavene. ");
INSERT INTO zgam_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Umbombi yumo undala akhambona u Peteri u pwu atamile palumuli uluhumana nu mwoto, akhandola akhambula, “Uyu umunu akhalepaninie nave.” ");
INSERT INTO zgam_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","U Peteri akhabeva, akhata, “Vindala uve, unesanimajile.” ");
INSERT INTO zgam_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pwu akhasikhe khadebe, umunu uyuge akhambona akhata, “Nayeve ulipaninie nave.” U Peteri akhanda, “Vigosi uve, une sionene.” ");
INSERT INTO zgam_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Baada ya khavalino khamo ugosi yumo akhamumilincha akhata, “Lweli umunu uyu mwope akhale paninie nawe, ulwakhuva Ngalilo ya.” ");
INSERT INTO zgam_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pwu u Peteri akhanchova, “Vigosi uve, sanelemayile uliwunchova.” Avileinchova, ilikhogove likhavikha. ");
INSERT INTO zgam_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Akhasyetukha, Untwa akhandola U Peteri. Nu Peteri akha kumbukha ilimenyu lya Ntwa pala upwuambulile, “Wulikhale ukhuvekha ilikhogove vukhumbela une mara khadatu.” ");
INSERT INTO zgam_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Akhaluta khunji, u Peteri akhalila khukhisa lweli. ");
INSERT INTO zgam_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Vala avagosi avandolelaga u Yesu, valikhukhinda nukhu ntova. ");
INSERT INTO zgam_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Vakhagubekha amikho, vakhambuncha, vakhata, “Langula! Veni uveakhutovile?” ");
INSERT INTO zgam_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Vakhanchova inogwa inyingi incho savombele u Yesu nukhumbeda umwene. ");
INSERT INTO zgam_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Wavilevukhile panavusikhu, avangyakhoni vakhalundamana paninie, navavahavavatwa na vasimbi. ");
INSERT INTO zgam_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Vakhaghilikha khubalasa, Vakhata, “Unane uve vevekreste utuvule.' ");
INSERT INTO zgam_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","'Umwene akhavavula, “Ndanivavula, samukhanyedeke, Ndanivavunche, samukhanyande.” ");
INSERT INTO zgam_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ukhutegulila lino nukhwendelela, umwana va Ndaveti iva atemile khukhivoko ikhyandyo ikhya Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Voni vakhanchova, “Khwukhwuta uve ulemwana va Nguluve?” Pwu u Yesu akhavavula, umwe munchovile une nene.” ");
INSERT INTO zgam_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Vakhanchova, “Khekhi tupilonda uvusaidi? Ulwakhava nayofwe tupulikhe ukhuhuma mondomo gwa mwene.” ");
INSERT INTO zgam_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ululundamano lwoli lukhima, vakhaghilikha u Yesu khwa Pilato. ");
INSERT INTO zgam_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Vakhategula uuhumbeda, vakhaya, “Tumbwene munu uyo iyanche ikhilunga kyeto, wuibencha uuhuhumya isongo khutwa, pwu akhinchova umwene ukhuta vekreste, ukhurudeva.” ");
INSERT INTO zgam_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","U Pilati akhambunchaakhata, “Uve veve khuludeva vavayuta?” U Yesu akhanda akhata, “Uve vevewichova iwo.” ");
INSERT INTO zgam_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","U Pilati akhambula Untwa umbakha na vayaluluneleno, ");
INSERT INTO zgam_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","“Sanikhuyevona inongwa khu munu uyu.” Avene vakhagega vakhata, “Akhasogelenchaga avanu, alikhumanyisya khuvuyahudi khwoni, ukhutengulila khugalilea lino aliapa.” ");
INSERT INTO zgam_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","U Pilati avileapulikhe inchi, akhavuncha umunu uyuva khugalile? ");
INSERT INTO zgam_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Avilealumanyile ukhuta alepasi pavulongonchi wa Herode, namwope ale khu Yerusalemu khufigono vila. ");
INSERT INTO zgam_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herode avile ambwene u Yesu, akhowikhe fincho ulwa uhava alondaga uuhumbona isikhu nyingi. Apolikhe inogwa ncha mwene alekhunogwa ukhulola ifichago ifivombukha nu mwene. ");
INSERT INTO zgam_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herode akhambula u Yesu amamenyu amingi, u Yesu sakhanda khinu. ");
INSERT INTO zgam_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Avatwa avavakha paninie na vasimbi vakhima nuluvipo nukhughiga. ");
INSERT INTO zgam_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","U Herode paninie na vasikhali vamwene, vakhadukhila nukhumbelda, nu khufwekha imienda iminonu, pwavakha khilivula u Yesu khwa Pilati. ");
INSERT INTO zgam_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herode nu pilati vakhavavumanyani uuhuma isikhu ila, (khuwadilo valefitina). ");
INSERT INTO zgam_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","U Pilati akhavilaga paninie avatwa avavakha na valogonchi na vanu voni, ");
INSERT INTO zgam_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Akhavavula, “Mugegile umunu uyu ndu munu uveilogoncha avanu vavombage imbivi mulolage, wune mbunche khuvulogolo ukhuliumwe, saniyewene inogwa khumunu uyu khunogwa nchoni inchu umwe msitakhile umwene. ");
INSERT INTO zgam_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Akhabela, u Herode, akhiwile khuliufwe, lolaga khisikhuli khikhwoni akhiavombile iklunogelanice itabu iya vufwe. ");
INSERT INTO zgam_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Pwu nikhug'ega nukhundakha. ");
INSERT INTO zgam_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Lulwakhuva u Pilati adendulile ukhugwa yumo khuvayahudi usikhe ukhwa lukhekhelo. ");
INSERT INTO zgam_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Voni vakhapwata, vakhata, “Mug'enche uywa, mutodendulile u Baraba!” ");
INSERT INTO zgam_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","U Baraba akhugiwe khunogwa ncha mwene mumbunchege nukhuluda. ");
INSERT INTO zgam_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","U Pilati akhambula khavili, alikhunogwa ukhundekha u Yesu. ");
INSERT INTO zgam_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Avenevalikhupwuta, valikhuta, “Abudiwage, abudiwage.” ");
INSERT INTO zgam_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Akhavavuncha ulwadatu, “Umunu uyu avombile vuvivivukhi? Saneyewene inongwa iyikhugegela ufwe umwene. Apyaniemalile ukhuntova nikhindikhesya.” ");
INSERT INTO zgam_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pwu valikhukhasya khulupwate uluvakha, valikhukhunogwa abudiwage. Amameyu gavenu galikhugiga u Pilati. ");
INSERT INTO zgam_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pwu u Pilati akhalamula ukhavapa uvunogwa wavo. ");
INSERT INTO zgam_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Akhandekhesya ulauvivanogwagwa uveakhugiwe khunogwa iya mbivi nukhubuda. Pwu akhag'umya u Yesu khuvunogwe wavo. ");
INSERT INTO zgam_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Valivelikhug'elekha, vakhamwibata umunu yumo alikhutambuliwa Simioni uvakhukirene, akhumilekhukhilunga, vakhatwekha ikhidamig'ania, au khukhoga u Yesu. ");
INSERT INTO zgam_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ululundamano lwa vanu, na vadala avavipele nuuhulila khwaajili ya mwene, valikhukhonga. ");
INSERT INTO zgam_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pwu akhavasyetukhila, u Yesu akhavavula, “Mwivakhencha vamu Yerusalemu, mlekhe ukhudilila una, mwililelage yumwe navana vinyo. ");
INSERT INTO zgam_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Lolaga, ifigonofi khwincha valata, “Vasayiwe avasavikhola na matumbu gagosaulilola, namavele ugasagosinche. ");
INSERT INTO zgam_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Pwuvalafivulaga ifyamba, “Mtugwele, 'Nutwamba, 'Mtugubekhile.' ");
INSERT INTO zgam_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Vanavevivombo inogwa incho khubikhi umwigu, yiva ndakhekhi gugavekhuvumile?” ");
INSERT INTO zgam_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Avagosi vavili avage, avanangi vaveli, vagegiwa paninie vakhabudiwe. ");
INSERT INTO zgam_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Vavilevafikhe apitambuliwa Fuvu lya twe, pwuvakhambuda paninie navala avatulanogwa, yumo khungyo nuyuge khuhege. ");
INSERT INTO zgam_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","U Yesu akhata, “Dada uvasyekhele, ulwakhuva savalumayile inchovivomba. “Avene vakhatova ekura, ukhugava emienda gwemwene. ");
INSERT INTO zgam_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Avanu vaimile valikhulola avalogonchi vavo wuvikhubeda, vita, “Avapokhile avage, lino wipokha yuve, anave umwene ve Kreste umwana va Nguluve, umbalanche.” ");
INSERT INTO zgam_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Avasikhali navope valikhubeda, vakhahegelela khumwene, nukhupa isiki, ");
INSERT INTO zgam_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Valikhuta, “unave uve ulikhiludeva vavayuta wipokhe yove” ");
INSERT INTO zgam_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","khwale nuvusimbe pakyanya uwasimbiwe”UYU VE KHULUDEVA VAVAYULE.” ");
INSERT INTO zgam_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Utulanogwa yumo akhadukha akhata, “Uve siveve Krete? Wipokhe yove nafwe” ");
INSERT INTO zgam_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pwu uyugekhanda akhanda, akhadukha akhata, “Uve savukhudwada u Nguluve, nayuve ulimbukhegi vuvuwa? ");
INSERT INTO zgam_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ufwe pwutuleapa khuvuyelweli, ulwakhuva ufwe tukhwambilila khila ikhinogelanile khumbomboncheto. Umunu uyovombile ikhivivi.” ");
INSERT INTO zgam_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Akhogelenche, “Yesu, ugumbukhage apyawukhigela khuludwa lwakho.” ");
INSERT INTO zgam_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","U Yesu akhambula, “Wideghage nikhuuhuvula, ilelo iye wivapaninie nunu khuludeva.” ");
INSERT INTO zgam_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Apogwale usikhi saa tisa, ikhisi yekhincha ikhiluga khyoni mpakha saa tisa, ");
INSERT INTO zgam_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ulumuli lwa linchuva lukhanchima. Pwu umwenda ugwamutembile gukha diefukha pagati ukhuhuma khukyanya. ");
INSERT INTO zgam_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Akhalila fincho, u Yesu akhata, “Dada mmavokho gakho nikhuyevikha inumbula yago, “Avileachovile ewo akhafwa. ");
INSERT INTO zgam_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pwu u Akhida avileawenenchivombikhe ewo akhag'inia Unguluve akhata, “Lweli umunu uyu akhale golofu.” ");
INSERT INTO zgam_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ululundamano lwa vanu avainchila paninie kwilola vavilevalolile imbombo inchivombikhe, valikhuvuya vitova ififuvafyavene. ");
INSERT INTO zgam_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pwu avamanyani vamwene, navadala avakhogile ukhukhuma khugalitaya vaimilekhuvutali valikhulola imbombo incho. ");
INSERT INTO zgam_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Lola, pale numunu alikhutambuliwa Yusufu, alepanie na vakhagi, umunu unonu ugolofu, ");
INSERT INTO zgam_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","(Saidekhane nuvulamunchi wa mbombo nchavo), ukhukhuma, kukhu Arimathayo mumbunchege uwa vavayula, uwapulikhega uludeva lwa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Umunu uyu, akhahegelela khwa Pilati, akhadova umbili gwa Yesu. ");
INSERT INTO zgam_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Akhamwisya, nukhubina numwenda akhambikha mumbuguli uwapunji wa iliwe, ilyoasikhuli umunuaviagelile ukhufyeliwa. ");
INSERT INTO zgam_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Khyale khigono, khyakhutegulila Isabato wuyekhagelile. ");
INSERT INTO zgam_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Avadala, avakhumile nave khutalilenya, valikhukonga, vakhalola ilipumba numbile gwamwenu wuvagoninche. ");
INSERT INTO zgam_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Vakhavuya nukhutegula ukhuboda, imono inonu, ikhigono ikhya sabato vakhagatolukha ukhukhoga indagilo. ");
INSERT INTO zgam_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Isikhu iya khwanja iya mulungu panavusikhu wukhilo, vakhincha khulipumba, vakhagega imono inchuvavikhile. ");
INSERT INTO zgam_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Vakhavona iliwe libelwikhe khuvutali nelipumba. ");
INSERT INTO zgam_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Vakhigila mugati, savakhuvuna umbili ukhwa kuludeva u Yesu. ");
INSERT INTO zgam_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ikhahumila ukhuta usikhi wuvancha ganyikhiwe khueli, nambivi, avanu vavili vakhima pagati pavene vafualile imienda ig'iga ragadekhaa. ");
INSERT INTO zgam_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Avadala vakhadega ulususuvalo vakhasulekha imifwe givo pasi, vakhavula avadala, “Khekhi mukhondonda uvianchukhile kufwe? ");
INSERT INTO zgam_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Asipali apa, anchukhile! mkumbukhe uwoachovile numwe wualikhu Galilaya, ");
INSERT INTO zgam_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Akhanchova ukhuta umwana va Ndaveti mpakha ahumenchiwe mumavokho gavatula nungwa nukhutefiwe, isikhu iyadatu, anchukhe khavili.” ");
INSERT INTO zgam_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Avadala valavakha khumbukhe amaneyu gamwene, ");
INSERT INTO zgam_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Vakhakhilivukha ukhuhuma khulipumba vakhavavula inogwa incho nchoni vala khinchigo nayumo paninie navagevoni. ");
INSERT INTO zgam_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Pwu uMaria Magadarene, Joana, Maria u mama va Yakhobo, navadala avage paninie vakhakhumiya udomo ugu khuvasukhiwa. ");
INSERT INTO zgam_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pwu amameyu agha khagha vonekha vudesi khuvasukhiwa, savakhavidekha avadala vala. ");
INSERT INTO zgam_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","U Peteli akhasisimukha, akhagilaukhuluta khulipumba, alikhu hugila nukhulola mugati, akhayevona isandayene. Pwu u Peteli akhahega ukhuluta khu nyumba ya mwene, alikhudega khikhi khihumile. ");
INSERT INTO zgam_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lola, vavili pakhati pavene valikhulutaikhigono khilakhila mumbunchege uvotambuliwa Emmau, khuyeleimaili sitini ukhuma khu Yerusalemu. ");
INSERT INTO zgam_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Valikhunchova vavokhwa vavo inogwa nchoni inchihumile. ");
INSERT INTO zgam_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Usekhe vavile vikhinchofancha nukhu vunchana amaswali, u Yesu akhahegelela pawipi akhalogonchana navo. ");
INSERT INTO zgam_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Amikho gavene gakhadendiwa ukhumanya umwene. ");
INSERT INTO zgam_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","U Yesu akhavavula, “Khinu khikhi ikhyumwinchova umwe vavili mwu mugenda?” Vakhima pala vakhava na lususuvalo. ");
INSERT INTO zgam_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yumu ilitawalyamwene vecleopa, akhanda, '“Uve veve munu vimwe ne apa pa Yerusalemu yuwe supulikhe inogwa inchihumile khunu iskhu inchi?” ");
INSERT INTO zgam_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","U Yesu akhavavula, “Nogwa nyikhi?” Vakhanda, “Inogwa incha Yesu Unazareti, uviakhale Nyamalago, unyamakha khumbombo na mameyu khumiho ga Nguluve na khuvanu voni. ");
INSERT INTO zgam_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Avatwa navalogonchi veto vakhaghu minche khuhegiwa uvufwe nu khu budiwa. ");
INSERT INTO zgam_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tulikhuhuvila ukhuta umwene veikhuvavikha mumbolegefu avaya Israeli. Paninie ninchi nchoni, ilelo khigano khyadatu ukhuhuma imbombo inchi nchivombekha. ");
INSERT INTO zgam_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pwu vaninie avadala ukhuhuma khukhipuga khyeto vakhatudwaanchinehe, wuvalutile panavusikhu khulipumba. ");
INSERT INTO zgam_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Swaguwene umbili gwa mwene, vinaile vinchova ukhuta vakha lolile avasug'wa avakhakha nchovile ukhuta anchukhile mwumi. ");
INSERT INTO zgam_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Avagosiavage avakhalale paninie nufwe vakhalutile kulipumba, vanchiwene nduwuvakha nchovile avadala. Savakhambone umwene.” ");
INSERT INTO zgam_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","U Yesu akhavavula, “umwe mwavanu vapelwa mleninumbula inchifu inchakhulekha ukhwidikha nchoni unchovachovile avayamalago! ");
INSERT INTO zgam_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Sayalelweli u Yesu ukhutesiwa khunogwa incho, nukhwigila kuludeva kwa mwene?” ");
INSERT INTO zgam_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ukhutegulila khwa Mose na vasug'wa voni, u Yesu akhavavula imbombo inchamwene inchilembufimbe woni. ");
INSERT INTO zgam_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Vavile vakhegelile mumbunchege vula, valikhuluta u Yesu akhava inogwa ukhwendelela khuvulugolo. ");
INSERT INTO zgam_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Vakhamwumilencha, vakhata, “Lama paninie nufwe, ilwakhuva lino wilile nesikhu yesilile.”Pwu u Yesu akhigila khutama navo. ");
INSERT INTO zgam_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yakhumile ukhuta, avile atamile navo pakhulya, akhatola ikhivanda akhakhisaya, nukhumenyula, akhavapa. ");
INSERT INTO zgam_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Pwu amikho gavene gakhadenduliwa vakhamanye, akhayaganikha nambivi khumikho gavene. ");
INSERT INTO zgam_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Vakhavunchena vavo khwa vavo, “Ulu inumbula ncheta sanchikhavikhe mugati ndufwe, usekhe wuinchova nufwe munjila, wuikhutundindulila uvusimbe?” ");
INSERT INTO zgam_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Vakhema usikhe gugwa, nukhukhilivukha khu Yerusalemu. Vakhavavona vala khinchigo nayumo valundamine paninie, navalaavale paninie navo, ");
INSERT INTO zgam_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Vakhata, Untwa anchukhile lweli lweli, agumile u Simoni.” ");
INSERT INTO zgam_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Pwuvakhavavula imbombo inchihumile munchele, nuwu u Yesu avonikhe khuvene khuvene pakhumeyule inchivanda. ");
INSERT INTO zgam_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Wuvinchova inogwa incho, u Yesu yuywa akhema pagati pavene, akhavavula, “uluhungu luve numwe.” ");
INSERT INTO zgam_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Vakhadwada lukhadega ulutende, vali khusaga ukhuta vayewene inumbula. ");
INSERT INTO zgam_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","U Yesu akhavavula, khekhi msikhitikha? Khekhi amameyu gilihuma munumbula ncheyo? ");
INSERT INTO zgam_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mlolage amavokho gago namalunde gago, ukhuta neneyune. Muyilate mlole. Ulwakhwa inimbula yenchila nyamana manchege, nduwumwilola une nilinafyo.” ");
INSERT INTO zgam_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Avileamale akhunchova, ewo, akhavavonesya amavokho gamwene namalunde gamwene. ");
INSERT INTO zgam_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Vavilebadu vakhowike nukhulekha ukhwidikha, nukhuswiga, u Yesu akhavavula, “Mulinakhyo akhyakula?” ");
INSERT INTO zgam_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Vakhampaekhemegu khyasomba iyuvanyanyile. ");
INSERT INTO zgam_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","U Yesu akhatola nukhula khuvulogolo uhuvene. ");
INSERT INTO zgam_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Akhavavula, “Upwunekhale numwe, nikhavavulile ukhuta nchoni inchisi mbiwe khudagilo invha Mose navanyamalago ne Zaburi impakha nchi khwela nile.” ");
INSERT INTO zgam_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Pwu akhadendula igala nchova, ukhuta vavumaye uvusimbe. ");
INSERT INTO zgam_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Akhavavula, “Ukhuta yesimbiwe, u Kreste mpakha atesekhe, nukhunchhukha ukhuhuma kuvufwe ikhigono ikhya datu. ");
INSERT INTO zgam_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ukhupela nukhusyekheliwa imbivi impakha nchilumbeliliwe khulitawa lya mwene khuviluga fyoni, ukhuma khu Yerusalemu. ");
INSERT INTO zgam_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Numwe mlivamasaidi va nogwa inchi. ");
INSERT INTO zgam_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mlolage, nikhuvahelekhela ululegilo lwa Dada vago khukyanya khulimwe. Pwu mpulikhele bahapa mumbunchega mpakha apyamvikhava amakha ukhuhuma khukyanya. ");
INSERT INTO zgam_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pwu u Yesu akhavalogoncha ichunji impakha vavilevafikhe khu Bethania. Akhinula amavokho gamwe khu khyanya, akhavasaya. ");
INSERT INTO zgam_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ikhahumila avile ikhuvasaya, akhava lekha akhapimbiwa ukhuluta khukhya ");
INSERT INTO zgam_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pwu vakhamindekha, nukhuvuya khu Yerusalemu vahowikhe. ");
INSERT INTO zgam_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Valikhupitama mtembile wuvikhudova Unguluve. ");
INSERT INTO zgam_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Pavutengulelo pala nie limenyu, nie limenyu lwale paninie nu Nguluve, nie limenyu ahava ve Nguluve. ");
INSERT INTO zgam_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Elimenyu elwavutengulile lwale paninie nu Nguluve. ");
INSERT INTO zgam_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ifinu fyoni fyavombikhe ukhugendela khumwene, upwasipali umwene sakhikhavombekha ekhenu khyokhyoni. ");
INSERT INTO zgam_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Igati mumwene mwalemo nu wumi, nu wumu uwa wale lumuli lwa vanuvoni. ");
INSERT INTO zgam_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Utumuli lumulekha mukhisi, pakhuva ekhisi sayikhanchimye. ");
INSERT INTO zgam_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pale nu munu uvyasukhiwe ukhuma khwa Nguluve, uve mwene elitawa ve Yohana. ");
INSERT INTO zgam_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ainchile wila imwemwelenchi khulolela ulumuli lulla, khukhula voni vawesye ukhwedekha ukhugendela mumwene. ");
INSERT INTO zgam_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","U Yohana sale velumuli, khukhuta akhinchile khwilola ulumuli. ");
INSERT INTO zgam_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ulwa lwale lulumuli ulwayelweli ululwa inchile inkelunga khukhombekha ulumuli vevoni. ");
INSERT INTO zgam_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Alepo pakhelunga, nekhelunga khyavombiwe ukhugendela mumwene, ne khelunga sakhikhamanya. ");
INSERT INTO zgam_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ainchile ni vinu fya mwene, na vanu vamwene savakhamwupelela. ");
INSERT INTO zgam_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pakhuva avingi avakhamwedikhe, avakhedikhe elitawa elwa mwene, pwa vapile elweli ukhuva vana va Nguluve. ");
INSERT INTO zgam_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Avakholiwe, sio khunkisa, wala khuvunogwe uwambele, khukhuta khuvuga ne uwa munu, pakhuva yu Nguluve mweve. ");
INSERT INTO zgam_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nelimenyu lwavombiwe imbele lyatamile igati mulyufwe, tuluwene, uluginwo lwa mene, uluginwo ulwa munu uyale mwene khwa baba, adenchiwe uluhungu ulwayelweli. ");
INSERT INTO zgam_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","U Yohana emivele egwamwene, pwa khaloncha elimenyu akhata, “Uyo ve mwene venekhanchoovile ululagelo ulwa mwene, “Uyikhwincha khusana khulyune vembakha khuvoni, ulwakhuva alepo kabla yango.” ");
INSERT INTO zgam_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Pakhuva pakhukhuma pavugolofu wa mwene, pakhuva twevoni twupelile emivombele paa mivombele. ");
INSERT INTO zgam_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Pakhuva ululagelo lwainchile ukhugendela khwa Musa. Uluhungu ulwayelweli lwainchile ukhugendela khwa Yesu Klisiti. ");
INSERT INTO zgam_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Asikhuli umunu avambwene u Nguluve usekhe gwoni. Umu ve mwene uNguluve, uvalepakhefuva ekhwa Nguluve, ambikhile umwene amanyekhe. ");
INSERT INTO zgam_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Pa khuva ege gyu mivele gya Yohana akhasekhe akhademi uvakhulawi avasukhiwe khumwene Avayahudi khukhomboja, “Uve ve veni?” ");
INSERT INTO zgam_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Pakhuva tudwadadwada nivi sipali pwa khavone, “Une sio Klisiti.” ");
INSERT INTO zgam_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Pu vakhambuncha, “Uve ve venile no?” Uve ve Eliya? Ahanchova, “Akhata one siyo.” Vakhanchoova, Uve ve nyamalago? Akhanchova,” akhata amuna.” ");
INSERT INTO zgam_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tena puvakhambula, “Uve ve veni, khukhuta tuvavule anda avavatu sukhile”? Vukhevekhela ndeti emivele vemwene?” ");
INSERT INTO zgam_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ahanchoova, “Ahata une nene limenyu elelikhwelanga ndu gima: 'Golosya enjela eyambakha,' ndo lwa nyamalago u Isaya vuakhanchoovile.” ");
INSERT INTO zgam_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pakhuva pale na vanu avavasukhiwe ukhukhuma khwa Vafalisayo. Vakhambuncha nukhunchoova, ");
INSERT INTO zgam_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Pa khuva khekhi vukhwoncho inave uveve sio ve Klisiti vala Eliya vala nyamalago?” ");
INSERT INTO zgam_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","U Yohana avandile akhanchoova, “Nikhwoncha khu magasi. Pakhuva, inganti indyumwe ayikhwema umunu uyusamumanyile. ");
INSERT INTO zgam_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Uyo veikhwincha usekhe ugwango. Une saninogelanile ukhulege sya indegekhe incha filatu ifya mwene.” ");
INSERT INTO zgam_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Imbombo inchi nchavombiwe hu Bethania, khumwambo khu Yordani, aponu upwalekhuvomba uYohana ukhwonchaa. ");
INSERT INTO zgam_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Emisekhe egegwakokile u Yohana akhambona u Yesu ikhwincha khumwene inchoova, “Lola eng'osi eya Nguluve yikhwincha khulola imbivi incha khelunga! ");
INSERT INTO zgam_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","oyo venekhanchovile ukhuta indagelo inchamwene nekhanchova, “Umwene uvikhwincha khu sana khulyune vembakha khulutelela one, ulwakhuva ale mbolongolo indyune.' ");
INSERT INTO zgam_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Sanekhagundule yeyoni, pakhuva yavombiwe eve ukhuta adendoliwe mu Israeli, pakhuva nainchile khukhwoncho na magasi.” ");
INSERT INTO zgam_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","U Yohana ale nemivele, “Nekhalolile umepo ikhwikha ukhukhu makhukwanya nekhekhwani ekhwa khengondya, puyikhasigile pakanya pa mwene. ");
INSERT INTO zgam_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Unene sanekhagundule ila umwene asukhile nonche na magasi ambolile, 'Ula uvevukhombona nu mepo vuikhwikha nukhwikha nukhutama nu mwene, Pakhuva oywa veikhwoncha nu mepo umbalanche.' ");
INSERT INTO zgam_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nelolile ne mivele ukhuta oyu ve swambe va Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pakhuva akhasekhe akhakhalikhukongo u Yohana akhamile paninie na vakongi vamwene vavele, ");
INSERT INTO zgam_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","vambwene u Yesu igenda nu Yohana akhanchova, “Lola, eng'osi eya Nguluve!” ");
INSERT INTO zgam_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Avakongi vavile vakhapulekha oyoha na voinchova ita tukongage o Yesu. ");
INSERT INTO zgam_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Pu Yesu akhapendukha akhavavona avakongi vikhokonga, pwa khavavula, “Mwinongwa ekhekhi?” Vakhanda, “Rabbi, (Pakhuva pene 'indongonchi,' vutama ndakhu?” ");
INSERT INTO zgam_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Akhavavula, “Mwinche mulole. “Puva khaluta vakhalola esehemu eyi tamaa, vatamile pupaninie esikhu eyo, ulwa khuva yale ukhuta khasekhe kha lwakhemikhe. ");
INSERT INTO zgam_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yumo paninie pavale vavele uveakhapulikhe u Yohana voinchova ukhuta tukonge uyise ale ve Andrea, lokololwe va Simoni Petro. ");
INSERT INTO zgam_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Akhambona olokololwe u Simoni nukhumbula, “Tumbwene umasihi” (Uvinchovivwa ukhutave Klisiti). ");
INSERT INTO zgam_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Akhagega khwa Yesu. U Yesu akhandola nukhuncova, “Uve ve Simoni veswambe va Yohana ya vukhelangiwa ve Kefa,” (pakhuva ve 'Petro'). ");
INSERT INTO zgam_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Akhasekhe akhakhakongile uYesu vuinogwa ukhukhega ukhuluta khu Galilaya, akhambona o Filipo nu khumbula, “In'ongage one.” ");
INSERT INTO zgam_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","U Filipo atamaga khu Bethsaida, ekhelunga ekhwa Andrea nu Petro. ");
INSERT INTO zgam_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ufilipo akhambwene Unathanaeli nukhumbula, tumbwene uyakhatile Umusa andikhe indagelo incha mwene nu lulagelo uluva nyamalago. U Yesu uswambe va Yusufu, ukhukhuma khu Nazareti. ");
INSERT INTO zgam_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathanaeli akhambula, “Je ekhenu khweto khiwesya ukhukhumila khu Nazareti?” U Filipo akhambula, Wincho ulole.” ");
INSERT INTO zgam_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","U Yesu akhambona Nathanaeli vu ikhwincha khumwene nukhunchova, “Lola, Mwisraeli lweli lweli uyo sideta igati mumwene!” ");
INSERT INTO zgam_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanaeli akhanchova, “Umanyile ndakhekhi one?” U Yesu akhanda akhambula, “Pakhuva u Filipo vu sakhwelangile vulepasi pabebhe, ne khakhuwene.” ");
INSERT INTO zgam_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","U Nathanaeli akhanda, “Rabi uve uleswambe va Nguluve! Uveve ve intwa vakhu Israeli!” ");
INSERT INTO zgam_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","U Yesu akhanda akhambula, ulwa khuva nakhuvulile 'nakhuwene pasi pabekhe' je vukhwekha? Yuwilola amambo amavakha khuligo aga.” ");
INSERT INTO zgam_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","U Yesu akhanchova, “Lweli lweli mula khevona ekhelunga vukhelunga vukhidendukha, nukhuvavona avasung'wa vovitoga nu khwikha pa kwanya paswambe va Adamu.” ");
INSERT INTO zgam_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Osekhe ugwa sikhu idatu, khwalekho nu weng'ani khu Kana eya Galilaya nu mamaye Yesu alekho okhwa. ");
INSERT INTO zgam_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","U Yesu na vakongi va mwene vailangiwe khuweng'ani. ");
INSERT INTO zgam_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Osekhe uguyasilile edivai, uma maye Yesu akhavavula, “Valevu vule divai.” ");
INSERT INTO zgam_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","UYesu akhanda, “Uvedala eyoyi khonanga ekhekhi one? Usekhe gwango one bado sagufikhe.” ");
INSERT INTO zgam_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Umamaye akhavavula avavombi, “Khyokhyoni egeyakhuva vikhuva vula vombaga.” ");
INSERT INTO zgam_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Pakhuva pale na majelo sita agaliwe agavavekheli gakhukala va paselekhe eya vayahudi, khela lijelo lwale nuvujitu vwa mbili tatu. ");
INSERT INTO zgam_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","U Yesu akhanchova, “Mudenche amagasi mumajelo aga mawe.” Vakhadencha impakha pakhwanya. ");
INSERT INTO zgam_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pu akhavavula avavombi vala, “Tola khedebe mukhelekhe khumbombi ombakha uva mesa.” Vavombile nduluvasukhiwe. ");
INSERT INTO zgam_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ombombi ombakha akhavonja amagasi agagagevwikhe ukhuva divai, pakhuva sakhalumanya ukhugakhumile (pakhuva avavombi avavatumile amagasi vagamanyile ukhugikhuma). Puakhamwelanga umbakha va wekhani. ");
INSERT INTO zgam_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Akhambula, “Khela munu ikhwanja ukhuvupilincha avanu edivai enonu vangagale ikhuvapa yeyo sanonu. Pakhuva uveve uvekhile edivai enonu mpakha olo” ");
INSERT INTO zgam_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ekhedego ekhwa khu Kana ya Galilaya, lwale lulutengulelo ulwa mivonekhelo egwa khedego ekhwavombile u Yesu, vukhwinula uluginwo ulwa mwene, pakhuva avakongi vamwene vakhamwidekha. ");
INSERT INTO zgam_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Osekhe ogo, Yesu, umama vamwene, avalokololwe vamwene na vakongi vamwene valutile khukhelunga khwa Kapernaum puvakhatama okhwa akhasekhe khadebe. ");
INSERT INTO zgam_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pakhuva ekhwakha khwa Vayahudi khekhasogile, pakhuva u Yesu akhalutile khu Yerusalemu. ");
INSERT INTO zgam_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Avavwene avagujanchi ava senga, ing'osi ne vingundya mugati mutembile. Navavi khupesanwe indalama vale igati mutembile. ");
INSERT INTO zgam_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","U Yesu akhatengenesya ondegekhe ugule nefikhodekho, avakhuminehe vooni avale igati mutembile, pupaninie isenga nei ngosi akhadiuda indalama incha vavikhwu pesanya indalama nukhugevusya imeza inchavene. ");
INSERT INTO zgam_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Khuvala avaviguncha ifingondya, “Khencha ifinu ifi khutali naapa, bekhela okhovomba etembile eya Nguluve vango ukhuva khevanja khwa sokhoni.” ");
INSERT INTO zgam_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Avakongi va mwene vakumbwikhe ukhuta yasimbiwe, “Uwivu uwa nyumba yakho vulandya.” ");
INSERT INTO zgam_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Avavakha Avayahudi vakhanda, vakhambula, Yu njila yilekhu eyakha vuvonesya pakhuva vuvomba imbombo inchi?” ");
INSERT INTO zgam_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","U Yesu akhanda, mugwesye etembile eye nayune nikhuyemekha akhasekhe kha sigono sidatu.” ");
INSERT INTO zgam_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Leno avavakha va Vayahudi vakhanchova, “Lwatolile akhasekhe akhamilongo arobaini na sita ukhujenga etembile eye nuve wita vukhulejenga akhasekhe kha sigono vitatu?” ");
INSERT INTO zgam_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Inave, omwene anchovile ukhuta etembile eya mbele ugwa mwene. ");
INSERT INTO zgam_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Pakhuva usekhe na khasekhe akhakhunchukha umwene ukhukhuma khuvafwile, avakongi vamwene valumanyile ukhuta anchovile evo, vakhedekha ovosimbe ne limenyu elyu Yesu akhumile pakhunchova. ");
INSERT INTO zgam_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pakhuva vuale khu Yerusalemu akhasekhe akha Pasaka, asekhe ugwa sikukuu avanu vingi valekongile elitawa lwamwene, pakhuva vakhalolile ekhedego ekhe khavombikhe. ");
INSERT INTO zgam_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pakhuva u Yesu alenchila lwedekho navene pakhuva ava manyile avanu vooni. ");
INSERT INTO zgam_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Salekhunogwa umunu vevoni ukhumbula vuvalevo avanu pakhuva akhemanyile ekhelegati muvene. ");
INSERT INTO zgam_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Pakhuva pale nu Falisayo ovikhela ngiwa Nikodemo, paninie na vafumbwe vavakhegi va Vayahudi. ");
INSERT INTO zgam_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Umunu oyo akhandutile umbakha u Yesu pakelo nukhumbula, “Rabi, tulumanyile ukhuta ulemanyisi ukhukhuma khwa Nguluve, pakhuva asikholi uyiwesya ukhavomba indagelo nchooni incha Nguluve pupaninie numwene.” ");
INSERT INTO zgam_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","U Yesuakhanda, “Lweli, lweli, umunu siwesya ukhwingela muvotwa ovwa Nguluve angalekhe okhokholiwe mala ya vele.” ");
INSERT INTO zgam_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Unikodemo akhanchova, “Umunu iwesya ndakhekhi okhokholiwa angave igogolo? Siwesya okhwingila igati mulitumbo elwa mama vamwene mala ya vele nu khukholwa, je yiwesekhana?” ");
INSERT INTO zgam_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","U Yesu akhavanda, “Lweli, lweli umunu inave sikholiwa na magasi nu Mepo, siwesya okhwingila muvutwa owa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ekhekholiwe nu mbele khya mbele, ne khekholiwe khu Mepo khwa mepo. ");
INSERT INTO zgam_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mulekhe okhosyiga pakhuva nekhavavolile, vinogiwa okhokholiwa akhasekhe akhavele.' ");
INSERT INTO zgam_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Emepu yikula khwakhwoni okhuyinogwa ne savoti ya yene mukhuyipolekha, pakhuva samukhweliwa ukhuwikhuma khuwi luta. Voyelevo ehali eyakholiwe nu mepo. ");
INSERT INTO zgam_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Unikodemo akhanda, nu khunchova, “Imbombo inchi nchiwesekhana ndeti?” ");
INSERT INTO zgam_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","U Yesu akhanda, “Uveve ve ndogonchi vava Israeli, pakhuva sunchimanyile imbombo inchi? ");
INSERT INTO zgam_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Lweli, lweli, nikhokhovula, khela ekhetu khemanyile nemivele nukholola. Pakhuva samukhwopelela emivele gweto. ");
INSERT INTO zgam_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Inave nevavalile imbombo incha pakhelunga samukhwedekha, yamuwesya okhwedekha ningavavole imbombo incha khukwanya? ");
INSERT INTO zgam_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Pakhuva asikholi oya togile khukwanya pakhuva khukwanya pakhuva umwene oyoakhikhile, oswambe va Adamu. ");
INSERT INTO zgam_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Pu yengave ndo Musa uluakhayemikhe enjokha khulijangwa, vovolevole umwaleve va Adamu lasima emenchiwe, ");
INSERT INTO zgam_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","pakhuva vooni avavikhumwedekha vave nu wumi uwa sikhu nchooni. ");
INSERT INTO zgam_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Pakhuva khunjila eye Unguluve akheganile ekhelunga, khukhuta oswambe va mwene, khukhuta amunu oyikhamwedekha alekhe okhosaga ila ave nu wumi wa sikhu nchooni. ");
INSERT INTO zgam_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pakhuva u Nguluve sakhasukhe oswambe pakhelunga ili akhege ekhelunga, khukhuta ekhelunga khepone okhogendela omwene. ");
INSERT INTO zgam_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Oyikhomwamini sakhakhegiwe. Oyosikhomwamini tayali akhegiwe pukhuva salwaminile ilitawa elwa swambe va Nguluve. ");
INSERT INTO zgam_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Eye yonjila ya vukhegi, pakhuta olomuli lwinchile nkelunga, pakhuva avanu vakhano gwa ekelo saidi ya olomuli pakhuva imbombo inchavo nchale mu mbivi. ");
INSERT INTO zgam_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Pakhuva oyivomba imbivi ikholovipela alomuli pukhuva sigenda ndomuli idwada ukhuta imbombo inchamwene yanchivonekha. ");
INSERT INTO zgam_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pakhuva, oyivomba elweli ikhwincha ndomuli ni mbombo incha mwene nchivonekha ukhuta nchilimbogolofu wa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Akhasekhe akha, o Yesu paninie na vakongi vamwene vakhaluta khukhelunga khwa Yudea. Okwa atolile akhasekhe paninie na vene alevooncha. ");
INSERT INTO zgam_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Pakhuva u Yohana alekhwoncha khukhukhwu Ainea igati mu Salim pakhuva pale na magasi mingi avanu valekhwincha khumwene nu khwonchiwa, ");
INSERT INTO zgam_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","pakhuva Oyohana sakhadendeliwa igati. ");
INSERT INTO zgam_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Pakhuva savalekhwelevana avakongi Yohana na Vayahudi ukhokhusu ishelekhe incha lwesayo. ");
INSERT INTO zgam_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Vakhaluta khwa Yohana vakhata, “Rabi, umwene uvekhale nave khumwabo khulo gasi olu Yorodani, uvemukhalolile emivele ni mbombo incha mwene, lola, ikhwoncha vooni viluta vikhukonga.” ");
INSERT INTO zgam_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","U Yohana akhanda akhata umunu siwesya ukhwupelela ekhenu khyokhyoni pekhuva apeviwe ukhukhuma khwa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Yumwe nemivele gwenyo mwinchova ukhuta, 'one si Klisiti', pakhuva ya pene nekhanchovile, 'nesukhiwa khuvolongolo khumwene.' ");
INSERT INTO zgam_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Umwene ovale nu bibi arusi ale mbakha va harusi. Leno olokololwe va mbakha va harusi, oyikhwema nukhupulekhencha imbakha sinchopakhuva khulimenyu elya mbakha va harusi olo lulukhekhelo ulwango olwedikhe. ");
INSERT INTO zgam_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Inogiwa okhotoga, nayone ninogiwa okhwikha. ");
INSERT INTO zgam_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ovikhuma khukyanya, alekhukyanya khugoni. Umwene uvakhelunga ikhuma mukhelunga puinchova imbombo incha khelunga. Ovikhuma khwa Nguluve alekhukyanya khugoni. ");
INSERT INTO zgam_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Omwene veinchova agalolile nukhupulekha, Pakhuva asipali ovikhwopelela emivele gwa mwene. ");
INSERT INTO zgam_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Umwene uvikhwopela emivele egwa mwene edikhe ukhu u Nguluve ve lweli. ");
INSERT INTO zgam_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Pakhuva avasukhiwe nu Nguluve inchova amamenyu aga Nguluve. Pakhuva sikhupa Umepo khwa khupima. ");
INSERT INTO zgam_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ubaba aganile oswambe ikhupa vyooni ifilemavokho aga mwene. ");
INSERT INTO zgam_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Uvikhomwedekha oswambe ale nu wumi lweli, pakhuva oyosikhi mwedekha sikhovovona awumi, pakhuva uvukalale ovwa Nguluve wikhwibatana nu mwene. ");
INSERT INTO zgam_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Pakhuva u Yesu avile alomanyile ukhuta Mafalisayo vapulikhe ukhuta u Yesu alena vakongi nukhuvoncha khulikho u Yohana, ");
INSERT INTO zgam_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(pakhuva Yesu yumwene salekhwoncha ila avakongi vamwene), ");
INSERT INTO zgam_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","akhumile khu Yudea akhaluta khu Galilaya. ");
INSERT INTO zgam_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Evo yale lasima okhugendela khu Samalia. ");
INSERT INTO zgam_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pu akhafikha khukhelunga ekhwa Samalia, ekhekhikhelangiwa Siakari, uvuvubadaninie ne khelunga akhyapile u Yakobo oswambe u Yusufu. ");
INSERT INTO zgam_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ne khekholo khwa Yakobo khwalepo apo. U Yesu agatile nukhugenda pwa khatama palukanji pakhekhulu. Khale khasekhe khapa musi. ");
INSERT INTO zgam_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Udala Osamalia ainchile khunega amagasi, nu Yesu akhanchova, “Ime amagasi nenywe.” ");
INSERT INTO zgam_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Pakhuva avakongi vamwene vakhalutile khujini khwigula ekhyakhula. ");
INSERT INTO zgam_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Udala ola akhambula, “Ndakhekhi uvenjahudi, akhondoma one nedala ne Samalia, akhenu ekhwa khunywa?” Pakhuva Avayahudi savikhekhanjanwa na Vasamalia. ");
INSERT INTO zgam_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","U Yesu akhanda, “Inave akhemanyile ekhikungelwa ekhwa Nguluve, nu munu avikhukhuvola, 'Ime magasi,' ukhalevukhodova, akhale ikhukhupa amagasi aga wumi.” ");
INSERT INTO zgam_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Udala khanda, “Imbakha ulevovole endovo eyakhunegela, ne khekholo khetali. Vukhugavona ndakhu amagasi aga wumi? ");
INSERT INTO zgam_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Uveve ve mbakha, khuliko ababa veto o Yakobo, avakhatupile ekhekholo ekhe, yu mwene na vana va mwene voni paninie ni senga incha mwene nchikhanywa amagasi pa khekholo ekhe?” ");
INSERT INTO zgam_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","UYesu akhanda, “vevoni uyinywa amagasi aga ipata ekhamu tena, ");
INSERT INTO zgam_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","inave uvinywa amagasi aganikhupa one siwesya okhupata ekhemu tena. Pakhuva amagasi aganikhupa giva lumiminukho ulolukhwedekha isikhu nchooni.” ");
INSERT INTO zgam_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Udala ola akhambula, “Imbakha nidove amagasi ago nelekhe okhwumila tena, nelekhe okhotesekha okhwincha apa khwinega amagasi.” ");
INSERT INTO zgam_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","U Yesu akhambula, “Luta khamwilango ogosi, pu vuye.” ");
INSERT INTO zgam_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Udala akhambula, “Nelevovole ogosi.” UYesu akhanda, “Onchovile vononu, 'Ulevovole ugosi;' ");
INSERT INTO zgam_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pakhuva uvile na vagosi vakhano tena oveulenave leno sio igosi vakho, pakhuva unchovile lweli!” ");
INSERT INTO zgam_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Udala akhambula, “Imbakha nivona ukhuta oveve ve nyamalago. ");
INSERT INTO zgam_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ava baba veto vaisayile mukhe wamba ekhe. Pakhuva omwe mwinchova mwita Yelusalemu lyo lieneo alwa vanu lwa khwesayela.” ");
INSERT INTO zgam_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","U Yesu akhanda, “Ovedala, inyedekhe, akhasekhe khikhwincha sokhesaye khwa Baba pa khewa mba ekhe au Yerusalemu. ");
INSERT INTO zgam_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mwe vanu mukhesaya ekhesa mukhevona, pakhuva twikhesaya ekhetukhevona, pakhuva ovolokhole vukhuma khu Vayahudi.” ");
INSERT INTO zgam_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Inave evo, osekhe gukhwincha, leno ogo apa, osekhe ogu vovikhesaya elweli yuvikhesaya khwa Baba khu mepo nelweli, pakhuva u Baba ikhovalonda avanu ndava ukhuta vanu vamwene avavi khesaya. ");
INSERT INTO zgam_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","U Nguluve ve Mepo, na avavikhesaya yenogelanile okhwesaya khu mepo ne lweli.” ");
INSERT INTO zgam_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Udala akhambula, “Nelumanyile ukhuta u Yesu ikhwincha, (Ovikhelangiwa Klisiti). Oywa voikhwincha ikhotuvula gooni.” U Yesu akhavavola, ");
INSERT INTO zgam_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","“One vevunchova nene.” ");
INSERT INTO zgam_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Osekhe gugugwa avakongi vamwene vakhakilivokha. Navope vakhaswiga khekhi inchoova nudala, pakhu akhasipali avakhavonchinche, “Vunogwa ekhekhi?” au khekhi vunchovanave oyo?” ");
INSERT INTO zgam_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pu dala akhalelekha elitenchi akhalula khujini khuvavola avanu, ");
INSERT INTO zgam_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mwinche mulole umunu ovyanchovile imbombo nchooni inchinevombile, te yiwesekhana ukhuta ve Klisiti?” ");
INSERT INTO zgam_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Vakhakhuma khumuji vakhincha khu mwene. ");
INSERT INTO zgam_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Akhasekhe khapamusi avakongi va mwene vakhanchova, “Rabi lwiya ekhwakhula.” ");
INSERT INTO zgam_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pakhuva omwene akhanchova, “One nelenakhwo ekhyakholwa ekhesamukhemanyile omwe.” ");
INSERT INTO zgam_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Avakongi vakhavolana, asipali uva ndetile ekhenu khyokhyoni, “Je vakhaletite?” ");
INSERT INTO zgam_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","U Yesu akhavavula, “Ekhyakholwa khyango khuvomba uvonogelanile vwa mwene avyasukhile nu khuvomba indagelo incha mwene. ");
INSERT INTO zgam_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Te, samunchova, 'Pakhuva akhasekhe khadebe uvubeni vyango vuva tayali?' Nikhuvavula lolaga ifyalo vofilitayali khu vubeni! ");
INSERT INTO zgam_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Omwene ovibena ikhupelela emisahala nukhuvundanwa isekhe incha wumi wa sikhu nchoni, pakhuva uyivilwa nu vibena va lakhekhelaga pupaninie. ");
INSERT INTO zgam_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Pakhuva ovonchovi ovu wayelweli, 'Oyunge iviala oyunge ibena.' ");
INSERT INTO zgam_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Navasukhile khwibene ekhe tava samukhavombele, avange vavombile embombo omwe mwingile ndo khekhelo olwa mbombo eyavene.” ");
INSERT INTO zgam_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Avasamalia vingi vakhamwedekha pakhuva khululagelo ulwa dala ole avale khunchova ne mivele, “Ovekhambulile imbombo nchooni inchine khavombile.” ");
INSERT INTO zgam_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Pakhuva Avasamalia vavile vinchile vakhadova okhutama navo pupaninie navene puakhatama khuvene isikhu ivele. ");
INSERT INTO zgam_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Vuvingi vakhamwedekha pakhuva khumamenyu gavene. ");
INSERT INTO zgam_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Vakhambula udala ola, “Tukhwekha sio khumamenyu gakho, pakhuva yufwe tupulikhe, leno putulumanyile ukhuta umwene ve mbakha va khelunga.” ");
INSERT INTO zgam_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Osekhe ogwa vigono vivele, akhakhega nukhuluta khu Galilaya. ");
INSERT INTO zgam_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Pakhuva yumwene akhanchovile ukhuta venyamalago alevovole ulwedekho khukhelunga khya mwene. ");
INSERT INTO zgam_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Vuinchile okhukhuma khu Galilaya, ava Galilaya vakhamwupelela, vakhanchiwene imbombo nchooni inchakhavombile khu Yerusalemu mu shelekhe, pakhuva navope vule muvale mushelekhe. ");
INSERT INTO zgam_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Akhincha tena khu Kana eya Galilaya ukhwa ukhwagewisye amagasi ukhuva inkisa. Palepo nu mbakha oswambe ale intamu khu Kapernaumu. ");
INSERT INTO zgam_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Vuapulikhe ukhuta u Yesu akhumile khu Yudea nu khuluta khu Galilaya, akhaluta khwa Yesu nu khudova amwokhole omuialeve, avale kholonda okhufwa. ");
INSERT INTO zgam_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Pu Yesu akhambula, “Umwe mungalekhe okholola ishara ne vidego samukhawesye ukhwedekha. ");
INSERT INTO zgam_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ondongonchi akhanchova, “Imbakha ekha pasi khetave omwalevango safwile.” ");
INSERT INTO zgam_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","U Yesu akhambula lutaga omwalevo inkafu, “Umunu ola akhedekha elimenyu alelekhanchoviwe nu Yesu akhekhegela. ");
INSERT INTO zgam_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Pu avile avavombi vamwene vakhamwopela nukhumbula umwaleve ale inkafu. ");
INSERT INTO zgam_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Pu akhavavuncha osekhe gule khu akhale khuba. Vakhanda, “Pamikhe akhasekhe akha saa saba ovotamu vokhandekha.” ");
INSERT INTO zgam_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Pu babaye akhagundula okhuta akhasekhe khala khala akhanchovile uYesu, “Omwalevo inkafu.” Pu mwene na valokololwe vakhamwedekha. ");
INSERT INTO zgam_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Eye yale ishala ya vele eya vombile u Yesu voakhumile khu Yudea ukhuluta khu Galilaya. ");
INSERT INTO zgam_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Osekhe ogwalepo neselekhe eyavayahudi, nu Yesu akhatoga okhuluta khu Yerusalemu. ");
INSERT INTO zgam_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na khu Yerusalemu khwalekho nelibilikha pandyango ugwa ng'osi, lelekhwelangiwa khu lugha eya Kiebrania Bethzatha, nalyope lwale na matao gakhano. ");
INSERT INTO zgam_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Enafasi embakha eya vatamu yalemo, ovesilola, ovesigenda, au avavapoosile vavile vagonile mu matao ago. {Pulekhencha: Amamenyu aga vusimbe uwa datu 3 sagivonekha munakala inonu inchakhatale. “Vovigulela amagasi okhunangiwa.”) Payelweli osekhe fula ni unsung'wa akhikha igati mu mbakha nu khunanga amagasi. ");
INSERT INTO zgam_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Pakhuva, ovale va khwanja okhwingila igati pakhuva amagasi gakhatibikhwe akhavombiwe okhuva inkafu okhukhumana ne khyokhyoni ekhekhamwibite khu sekhe gula. ");
INSERT INTO zgam_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nu munu yumo uyakhatamwile osekhe gwa miakha thelathini na minne ale igati mu matao. ");
INSERT INTO zgam_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","U Yesu avile ambwene vuigona igati mu matao pakhuva sakhalumanye ukhuta agonelile mula khusekhe untali u Yesu akhambula, Je vunogwa ukhova nkafu?” ");
INSERT INTO zgam_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Otamu ola akhanchova, “Imbakha nelevovole umunu, uvakhumbikhela pagati amagasi vugitiboliwa. Vunigela okhwingela omunu oyunge ikhwingela.” ");
INSERT INTO zgam_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","U Yesu akhambula, “Weme otole eligodoro lwakho ulutage.” ");
INSERT INTO zgam_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Pu munu ola akhapona, akhatola ekhetanda khya mwene akhaluta. Ne sikhu eyo yale Sabato. ");
INSERT INTO zgam_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Pu Avayahudi vakhambula omunu aveakhaponile, “Elelo sikhu ya Sabato, savulukhusiwa okhogega eligodolo lwakho.” ");
INSERT INTO zgam_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Akhanda, omwene oveamoni nche vemwene veambumbile, “Tola eligodoro lwakho olutage.” ");
INSERT INTO zgam_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Vakhavuncha, “Veveni oveatolile 'Tola eligodoro lwakho olutage?” ");
INSERT INTO zgam_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Inave, ola ovwa poninche sakhamanye, pakhuva u Yesu akhegile khu siri. Pakhuva pale na vanu vingi amaeneo gala. ");
INSERT INTO zgam_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pakhuva uYesu akhambona umunu ola mutembile akhambula, “Lola, oponile! “Olekhe okhovomba imbivi tena yuvukhwincha vukhwibatwa ni mbombo imbivi sincho.” ");
INSERT INTO zgam_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Umunu ola akhaluta nukhuvavola Avayahudi okhuta o Yesu veaponinche. ");
INSERT INTO zgam_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Evo, pakhuva ni mbombo inchi Avayahudi vakhatesya oYesu, pakhuva akhavombile imbombo inchi pa Sabato. ");
INSERT INTO zgam_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","U Yesu akhambula, “Ubaba vango ivomba embombo impakha leo nayune nivomba imbombo.” ");
INSERT INTO zgam_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Pakhuva Avayahudi vakhongelencha okhundonda ili vabudesio pakhuva okhudenya eSabato, pakhuva akhamwelanga Unguluve baba va mwene, vuikhevekha sawa ndo Nguluve. ");
INSERT INTO zgam_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","U Yesu akhavanda, “Lweli, lweli, omwana siwesya okhuvomba khyokhyoni pakhuva ekhyambwene obabaye voivomba, pakhuva khyokhyoni akhivomba obaba akhivomba khyu ekhyo omwana khevomba. ");
INSERT INTO zgam_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Pakhuva obaba aganile oswambe, nukhundaga khela khenu ekhivomba nu khumbonesya imbombo imbakha okhulutelela inchi ili vendelele okhoswiga.” ");
INSERT INTO zgam_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Pakhuva nduluyelevo obaba voikho vanchosya avafwe nu khuvapa uwumi, ukhulingana nu mwana ikhupa vevoni oveaganile. ");
INSERT INTO zgam_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Pakhuva obaba sikhong'ega vevoni, olwakhova apile omwana avokhege vwoni ");
INSERT INTO zgam_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ili voni vamweshimu omwana ndulu mwana ovoikhomweshi Obaba. Ovesikhomweshimu obaba avasungile. ");
INSERT INTO zgam_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Lweli, lweli, omwene uvipulekha elimenyu lwango nukhunyidekha one uveasukhile alenu wumi uwa sikhu nchoni na sakhakhegiwe. Pakhuva omwene, agendile khuvufwe nu khwingela khu wumi. ");
INSERT INTO zgam_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Lweli, lweli, nikhuvavola osekhe gukhwincha ugo avafwe vipolekha esavoti eya swambe va Nguluve, vooni avayakha vipolekha vitamaga. ");
INSERT INTO zgam_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Pakhuva ndu Baba vualenu wumi igati mumwene, ");
INSERT INTO zgam_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","pakhuva ampile oswambi owumi igati mu mwene, nu Baba ampile oswambe onsung'wa pakhuta akhege olwakhuva iswambe va Adamu. ");
INSERT INTO zgam_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mlekhe okhoswiga ele, pakhuva akhasekhe khikhwincha akha vafwe vooni avale makabuli ya vipolekha esavuti eya mwene ");
INSERT INTO zgam_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na vope yavikhuma khunji: Avavavombile amanonu vinchokha khu wumi, na avavombile imbivi vinchokha khuvukhegi. ");
INSERT INTO zgam_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Saniwesya okhovomba ekhenu khyokhyoni ukhukhuma khulyune nemwene, ndolunipulekha, vuevo vunikhega nu khukhega khwango elweli pakhuva saninogwa wango, pakhuva uvogane owa mwene ovwasukhile. ");
INSERT INTO zgam_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Inave nikhevombela emivele nemwene, emivele gwango sagyagiva ne lweli. ");
INSERT INTO zgam_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Khuleyunge oyilola emivele ukhukongana nune nelumanyile ukhuta emivele egevukhumbula mivele gwa ye lweli. ");
INSERT INTO zgam_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Musukhile khwa Yohana ne mivele gya lweli. ");
INSERT INTO zgam_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pakhuva, emivele nupelile sagikhuma khu munu. Ninchova aga pakhuta mupone. ");
INSERT INTO zgam_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","U Yohana ale lumuli ululekhung'ala, mukhale tiali okhokhovokha khu sekhe ontale mulumuli lwa mwene. ");
INSERT INTO zgam_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Emivele egenelenagwa mivakha ukhulutelele egwa Yohana, khumbombo incho Baba amile khukamelesya. Imbombo incho inchinivomba nchivoneysa okhuta obaba asukhile. ");
INSERT INTO zgam_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Obaba avasukhile one agewene emivele okhokongana nune, samugele ukhupulikha esavuli eya mwene wala okhulevona eliumbo lwa mwene osekhe gwogwoni. ");
INSERT INTO zgam_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Lesipali elimenyu elwa mwene ele litama igati ndyumwe pakhuva samu khumwedekha aveavasukhile. ");
INSERT INTO zgam_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mukhovololela ovosimbe mwita igati mwene mulenu wumi wa sikhu nchooni, nu vosimbe vunchovela imbombo nchango ");
INSERT INTO zgam_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","samwinogwa okhwincha khulyune muve nu wumi wa sikhu nchooni. ");
INSERT INTO zgam_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Sanikhwupela ovononu ukhukhuma khuvanu, ");
INSERT INTO zgam_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","pakhuva nelumanyile ukhuta ulugano lusimoli igati mulyumwe omwe. ");
INSERT INTO zgam_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ninchile khulitawa elya Baba vango, samukhawesye okhumokhela. Ndo yunge anginche khulitawa elya mwene mukhupokhela. ");
INSERT INTO zgam_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Je muwesya ndeti okhwedekha omwe yumwe mukhwupela ovononu okhukhuma khwa munu yumo yumo pakhuva samulonda ovononu ovovukhuma khwa Nguluve mwene? ");
INSERT INTO zgam_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Yamwita one nikhovakhega igati mwa Baba. Oyikhovakonga omweve Musa, oyu omwe muvekhile olwedekho khu mwene. ");
INSERT INTO zgam_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Inave mungemwedekha o Musa, mukhale mukhonyedekha none pakhuva akhasimbile ihabali inchango. ");
INSERT INTO zgam_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Inave samukhwedekha ovosimbe vwa mwene, muwesya ndakhekhi okhwedekha amamenyu agango? ");
INSERT INTO zgam_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Akhasekhe kha imbombo inchi, o Yesu alobile isekhemu incha nyanja ya Galilaya, yikhelangiwa nyanja ya Tiberia. ");
INSERT INTO zgam_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ululundamano luvakha lulekhukonga pakhuva vakhalolile embombo inchalekhovomba khuvale vatamu. ");
INSERT INTO zgam_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","U Yesu akhatoga khukyanya impakha uvupanda vwa khukyanya owa khewamba akhatama okhwa navakongi va mwene. ");
INSERT INTO zgam_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Vukhutesiwa khya Yesu, nulukhovokhelo ulwa Vayahudi lukhasogelile). ");
INSERT INTO zgam_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","U Yesu akhinula amikho gamwene nukholola khukyanya nu khuvona uvumati vwa vamu vukhwincha khumwene, akhavomba Filipo, “Tuluta ndakhu khugula emikate ili avanu ava valye”? ");
INSERT INTO zgam_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Pakhuva o Yesu anchovile aga khwa Filipo alekhugela pakhuva omwene alumanyile ekhivomba). ");
INSERT INTO zgam_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","O Filipo akhanda, “Ata mikate egwa dinari sagekhale gikwela hata munu yumo okhupata ekhepande ekhedebe.” ");
INSERT INTO zgam_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","U Andrea, oninie va vakongi va Yesu olokololwe va Simoni Petro akhavavula ");
INSERT INTO zgam_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","o Yesu, “Khule nudemi ale no mikate gekhano ni somba ivele, pakhuva eye sayikwincha khuvanu avingi ndavandulo?” ");
INSERT INTO zgam_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","U Yesu akhavavula, “Vatamisye avanu pasi” (Pale nelinyasi lingi amaeneo gala). Pakhuva avagosi vale okhuta elfu tano vakhatama pasi. ");
INSERT INTO zgam_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Pu Yesu akhatola emikate gekhano akhesasaya akhavapaza vavakhatamile. Pu akhavagavila isomba okhokongana nuluvotamile. ");
INSERT INTO zgam_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Avanu vavile vigwite, akhavavula avakongi va mwene, “Vilundanie ivipande vwa somba ili vile ukhusigala vwokwoni.” ");
INSERT INTO zgam_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Pu vakhalundanie ivitundu kumi na viwili, vipande ivwa mikate vikhano ifya shayiri- ifikhasa ziwe na vakhasigile. ");
INSERT INTO zgam_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Avanu vakhavile valolile agavombile vakhanchova, “Lweli oyu venyamalago oviywincha nkelunga.” ");
INSERT INTO zgam_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","U Yesu avile agundyile ukhuta vinogwa okhumwibata ili vambombe ukhuva intwa va vene, akhavakwepa, puakhaluta khukhewamba mwene. ");
INSERT INTO zgam_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Yevile lwakhemikhe, avakongi vawene vakhikha khu nyanja. ");
INSERT INTO zgam_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Vakhatogo mungalava valekho lovokha okhuluta khumwambi khu Kapernaumu. (Ekhisi yivile yingile o Yesu avile bado sinchile khuvene). ");
INSERT INTO zgam_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Osekhe ogwa emepo eng'ali yele khukula, ne nyanja yilekhwendelela okhulama. ");
INSERT INTO zgam_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pu avakongi va mwene vavile vatovile amakasi ishirini ama thelathini, vakhambona o Yesu igenda pakyanya pa nyanja ikhogosogelela untumbwi, pu vakhadwada. ");
INSERT INTO zgam_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pu Yesu akhavavula, “Nene mulekhe okhodwada.” ");
INSERT INTO zgam_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Vakhavile tayali okhogega mutumbwi, pu tumbwi gukhafikha pakhelunga upuvalekhuluta. ");
INSERT INTO zgam_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Esikhu eyekhakongile, ululundamano ulukhemile uvupande wa nyanja vakhavona otumbwi gusi pasi ugunge ila uguvakhatogile avakongi va Yesu ugosavakhatoge pakhuva avakongi vamwene vakhaluta vene. ");
INSERT INTO zgam_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","(Pakhuva, pakhavile ne mitumbwi egegekhomile khu Tiberia karibu ne sekhemu eyivakhalile emikate pakhuva ombakha akhakhu minche emwalemi). ");
INSERT INTO zgam_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Osekhe ululundamano lukhagundula khukhuta sio Yesu ama vakongi va mwene vakhale okho, vovene vakhatoga mu mitumbwi vakhaluta khu Kapernaumu vovikhondonda o Yesu. ");
INSERT INTO zgam_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Akhasekhe vavile vambwene uluvafu olonge lwa nyanja vakhambuncha, “Rabbi winchile ndeli khono?” ");
INSERT INTO zgam_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","O Yesu akhanda, akhavavola, Lweli, lweli, mukhondonda one, sio pakhuva mukhagawene imiujiza, pakhuva mwalile emikate nu khwiguta. ");
INSERT INTO zgam_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Bekhela okhokhevombela ekhwakholwa ekhekhinangikha ila mukhevombele ekhyakhula ekhyakhudumu isikhu nchooni ekheikhovapa omwaleve va Adamu pakhuva u Nguluve Ubaba avekhile ung'uli pakyanya pavene.” ");
INSERT INTO zgam_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Pu vakhambula, “Pukhenukhekhi khinogiwa okhovomba imbombo incha Nguluve?” ");
INSERT INTO zgam_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","O Yesu akhanda, “Eye yu mbombo ya Nguluve: Khukhuta mumwedekhe omwene avasung'ile.” ");
INSERT INTO zgam_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Basi puvakhambula, “Ncho mbombo nchilekhu inchiyakhavuvomba pakhuta tukhonchedekha nukhunchivombela? Vuvomba ekhekhi? ");
INSERT INTO zgam_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Avababa veto vakharile imanna khu polini, “Avapile emikate ukhukhuma khukyanya ili valwe.” ");
INSERT INTO zgam_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Pu Yesu akhavanda, “Lweli, lweli, si ve Musa uyakhavapile emikate ukhukhuma khukyanya, pakhuva Obaba vango ve ikhovapa emikate pakhuva gikhuma khukyanya. ");
INSERT INTO zgam_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Pakhuva okate ugwa Nguluve gukhuma khukyanya, nukhuleta uwumi nkerunga. ");
INSERT INTO zgam_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Basi vakhambula, “Imbakha utupe ekate ego isiku nchooni.” ");
INSERT INTO zgam_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","U Yesu akhavavula, “Onene ikate gwa wumi, omwene uvikhwincha khulyune salava nenjala nukhwedekha salavona kiu tena.” ");
INSERT INTO zgam_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pakhuva nekhavavulile ukhuta, mumbwene, pusamukhwedekha. ");
INSERT INTO zgam_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Vooni avavikhoma Obaba vikhwincha kholyune, vevoni uvikhwincha khulyune sanikhutaga sikhu khonji khabisa. ");
INSERT INTO zgam_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Pakhuva nikhile okhukhuma khukyanya, sio khwa khuvomba ovogane wango, pakhuva ovugane wamwene ovuakhasukhile. ");
INSERT INTO zgam_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nuvo vuvugane wango uvonesukhile, khukhuta nerekhe okhotaga hata yumo avamile, pakhuva nelavanchusya esikhu eyamwisho. ");
INSERT INTO zgam_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Pakhuva uvu vuvugane vwa Baba oveasukhile, khukhuta vevoni ovilola mwana nu khumwedekha ave nu wumi wa sikhu nchooni; nayune nikhonchosya esikhu eya mwisyo. ");
INSERT INTO zgam_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Pu avayahudi vakhasikhitikha ukhukongana nukhuta akhanchovile, “One nekate ugu gukhumile khukyanya.” ");
INSERT INTO zgam_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Vakhanchova, “Oyo sio ve Yesu omwana va Yusufu, uve ubabaye nu mamaye tumanyile? Yivile ndakhekhi leno inchova, 'Nikhile okhukhuma khukyanya?” ");
INSERT INTO zgam_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","O Yesu akhanda, akhavavula, “Mulekhe ukhukuta igati yumwe. ");
INSERT INTO zgam_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Asikholi umunu oyikhwincha kholione inave salusiwe nu Baba vango ovesung'ire, nayone yani khunchusya ekhegono khya mwisho. ");
INSERT INTO zgam_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Pakhuva yesimbiwe muvaragonchi, 'Yuvidemiwa nu Nguluve.' Khela uveapulikhe efundisye ukhukhuma khwa Baba, ikhwincha kholyune. ");
INSERT INTO zgam_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Sio ukhuta khule munu uvambwene Obaba, pakhuva omwene oveakhumile khwa Nguluve- ambwene Obaba. ");
INSERT INTO zgam_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Lweli, weli uvikhwekha alenu wumi uwa sikhu nchooni. ");
INSERT INTO zgam_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","One ne kate gwa wumu. ");
INSERT INTO zgam_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Avababa venyo vakhalile imanna khurijangwa, na vakhafwa. ");
INSERT INTO zgam_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ugo gu kate ugugukhumile khukyanya, ili umunu ale enafasi eya mwene alekhe ukhufwa. ");
INSERT INTO zgam_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Une ne kate ugogutama ugogwikhile ukhukhuma khukyanya. Inave umunu ilwa okate ogwa itama esikhu nchooni, ukate uguyakha nikhomwa imbele gwando khunjila eya wumi wa khelunga.” ");
INSERT INTO zgam_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Avayahudi vakhakaranchava vavo khuvavo vakhanja okhusutana nukhunchova, “Umunu oyo iwesya ndeti okhutupa ombele ugwa mwene tulinchage?” ");
INSERT INTO zgam_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Pu Yesu akhavavula, “Lweli, lweli, mungalekhe ukhulya nu khunywa unkisa ugwa mwene, samukhave nu wumi igati ndyumwe. ");
INSERT INTO zgam_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Vevoni uvilya umbile gwang'o nu khunywa unkisa gwango ale nu wumi uwa sikhu nchoni, na yune yanikhunchosya esikhu eya mwisyo. ");
INSERT INTO zgam_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Pakhuva ombele gwango khwa kholwa khwa lweli, nu nkisa gwango mgasi ga lweli. ");
INSERT INTO zgam_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Umwene uvilwa ombele gwango nu khunywa unkisa gwango itama igati mulyune, na yune mumwene. ");
INSERT INTO zgam_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Inave Obaba uveale nu wumi via sukhile, ndolunitama pakhuva ya Baba, nu mwene ayitama pakhuva yango. ");
INSERT INTO zgam_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ugo gukate ugogwikhwikha okhukhuma khukyanya, sio nduluva Baba vakhalya vakhafwa, omwene uvilye vakhafwa, omwene uvilye okate ogo alenu wumi owasikhu nchooni. ");
INSERT INTO zgam_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","O Yesu anchovile imbombo inchi vuale mulisinagogi avile ikhuvamanyesya khu Kapernaumu. ");
INSERT INTO zgam_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Pu vingi vavakongi va mwene vakhagapolekha aga, vakhanchova, “Ele limanyesyo ligumu veni iwesya okhupelela?” ");
INSERT INTO zgam_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","O Yesu alumanyile ukhuta avakongi va mwene valekhumikha embombo eye, akhavavula akhata embombo eye yikhovapenja? ");
INSERT INTO zgam_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yayiva ndakhekhi vomukhombo na omwana va Adamu voikhwikha ukhukhuma ukhwale ulutanchi? ");
INSERT INTO zgam_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ve Mepo ovikhomya uwumi. Ombele sagupata ekhenu khyokhyoni. Amamenyu aganenchovile khulyumwe ve mepo nu wumi. ");
INSERT INTO zgam_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pakhuva khulenavanu igati mulyumwe avasa vikhwedekha.” Pakhuva o Yesu alumanyile ukhukhuma palutanchi uvesiwesya okhwedekha umwene avale ikhobela. ");
INSERT INTO zgam_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Akhavavula, pakhuva khulugendo olu asikholi umu uvikhwincha kholyune pakhuva apeviwe nu Baba.” ");
INSERT INTO zgam_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Akhasekhe akha avakongi vingi vakhavuyilesincho khusana pusavakhakongana nave tena. ");
INSERT INTO zgam_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","O Yesu akhavavula vale kumi na wawili, “Je mwemwe munogwa okhokhega?” ");
INSERT INTO zgam_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Petro akhanda, “Imbakha tuluta khwani khulyuve khuvule uwumi wa sikhu nchoni, ");
INSERT INTO zgam_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","twedikhe nukhukera ukhuta uve ve mbaranche va Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","O Yesu akhavavula, “Je one sanikhavachagule omwe, pu paninie yumo mdugo? ");
INSERT INTO zgam_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Leno pwalekhunchova okholenga khwa Yuda, omwana va Simoni Iskariote, pakhuva ale vemwene ale paninie na vale kumi na wawili, aveale ikhubera o Yesu. ");
INSERT INTO zgam_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Akhasekhe kha mbombo nchoni o Yesu akhaluta leno khu Galilaya, pakhuva sakhanogwe ukhuluta khuvuyahudi pakhuva avayakhudi valekhovomba amipango egwakhubuda. ");
INSERT INTO zgam_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Leno olonemele olwa Vayahudi, olonemelo olwa vitembe, vwale pakhufikha. ");
INSERT INTO zgam_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Pu avalokololwe vakhambula, “Khega apa ulutage khuvuyahudi, khuta avakongi va mwene valole imbombo inchivomba. ");
INSERT INTO zgam_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Asipali uvivomba lyolyoni khu siri pakhuva yuhwa inogwa ukhuvonekha pavuvalafu. Inave vuvomba imbombo inchi, evonesye yuve khuvakhelunga.” ");
INSERT INTO zgam_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ata avalokololye sa vakhamwedekha. ");
INSERT INTO zgam_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Pu Yesu akhambula, “Akhasekhe khango sakhafighe bado, pakhuva akhasekhe akhenyo khela sekhekhale tayali. ");
INSERT INTO zgam_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ekherunga sakhiwesya ukhuvakalalila omwe, pukhikhong'ararena one pakhuva nikhuvavoneswa isivombo pakhuta utovombo tuvivi. ");
INSERT INTO zgam_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tagaga mulutage khulonemero; one saniluta khurunemero olo pakhuva osekhe gwango sagukwelile bado.” ");
INSERT INTO zgam_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Osekhe ogwa khunchova imbombo incho khuvene, akhanchiga khu Galilaya. ");
INSERT INTO zgam_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Inave evo, avalokorolwe vavile valutile kholonemelo, navope puakhaluta, sio pavuvalafu nukhwefikha. ");
INSERT INTO zgam_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Avayahudi valekhundonda upuvale palonemelo nukhunchova, “Ale ndakhu?” ");
INSERT INTO zgam_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Pale na mamenyu mingi igati mululundamo ukhulingana nu mwene. Vingi vakhanchovile, “Munu inonu.” Avange vakhata, “Hamuna, ikhoruyancha ululundamano.” ");
INSERT INTO zgam_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Hata evo akhasipali uvekha nchovile pavuvarafu ukhukongana nukhuva dwada Avayahudi. ");
INSERT INTO zgam_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ulunemelo luvile lufike pagati, o Yesu akhatoga pakyanya patembile nukhumanyisya. ");
INSERT INTO zgam_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Avayahudi valekhuswiga nukhunchova, “Khu njila elekhu umunu oyo anchimanyile imbombo nyingi? Sasomile mwee.” ");
INSERT INTO zgam_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","O Yesu akhavanda nukhuvavula, “Olumanyisyo lwango sio lwango, pakhuva lwamwene uyasukhile. ");
INSERT INTO zgam_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Inave vevoni ovinogwa okhovomba ovuvalanche vwa mwene, ikhulumanya ulumanyisyo olu, inave gikhuma khwa Nguluve, inave ninchova khulyune nemwene. ");
INSERT INTO zgam_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Uninchova gikhuma khumwene ilonda uluginwo ulwamwene pakhuva uyilonda oluginwo ulwa vasung'ire, umunu uyo va lweli, mugati mumwene pasipali okhovomba elweli. ");
INSERT INTO zgam_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","U Musa sakhavapa omwe ululagero? Pakhuva asipali ate yumo igati indyumwe uvivomba ovulagelo. Khekhi munogwa okhumbuda? ");
INSERT INTO zgam_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ululundamano lukhanda, “Ulene lipepo. Veni inogwa ukhukhubuda?” ");
INSERT INTO zgam_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","O Yesu akhavanda akhavavula, “Nevombile embombo yemo, na yumwe muswigire pakhuva ya mwene. ");
INSERT INTO zgam_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","U Musa avapile etohara (Sio ukhuta yikhuma khwa Musa, pakhuva yikhuma khuva baba), ne Sabato mukhotahili umunu. ");
INSERT INTO zgam_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Inave umunu ikhwopelela etokhara esikhu eya Sabato khukhuta ululagero ulwa Musa lulekhe ukhung'ararera one pakhuva nevombile umunu ukhuva inkafu pa sikhu ya Sabato? ");
INSERT INTO zgam_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mulekhe okhokhega okhokongana nu luvonekho, bali khegaga khu ye lweli. ");
INSERT INTO zgam_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Pakhuva eyavene yikhuma khu Yerusalemu puvinchova, “Sio ve oyo ovevikhondonda ukhubuda? ");
INSERT INTO zgam_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Lola, vuinchova pavuvalafu, na savinchova khyokhyoni khumwene. Sayiwesekhana ukhuta avalongonchi valumanyile elweli ukhuta oyo ve Klisiti, yiwesya ukhuva? ");
INSERT INTO zgam_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Tulumanyile umunu oyo ikhomila ndakhu. Uklisiti voikhwincha, pakhuva evo asipali ovealumanyile ukhuyakha ikhoma.” ");
INSERT INTO zgam_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","O Yesu akhatoja elimenyu elwa mwene khutembile, akhamanyisya nukhunchova, “Omwe mwe voni mumanyile one nukhunikhoma. Sanekhinche khu nafsi yango pakhuva aveasukhile vwali ne lweli, pu mumanyile omwene. ");
INSERT INTO zgam_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nemanyile omwene pakhuva nekhumile khumwene veasukhile.” ");
INSERT INTO zgam_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Vakhagela okhomwibata, pakhuva akhasipali ata yumo uvakhagera ukhwinura ekhevokho khukyanya pakhuva akhasekhe khamwene khale bado sakhafikhe. ");
INSERT INTO zgam_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Hata evo, vingi mululundamano vakhamwedikhe. Vakhanchova, “Oklisiti alava ikhwincha, ayivomba imbombo nyingi khulikho inchavombile umunu oyo?” ");
INSERT INTO zgam_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Avafalisayo vakhapulekha avanya rurundamano vovivunguma imbombo incha Yesu, avavakha na valongonchi vavafalisayo vakhavasukha avanu khulikho mwibata. ");
INSERT INTO zgam_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Pu Yesu puakhanchovile, “Nele nakhasekhe khadebe nepupaninie numye, pongera puniluta khumwene uve asukhile. ");
INSERT INTO zgam_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yamukhondonda samukhambone; ukhuyakha niluta.” ");
INSERT INTO zgam_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Pu Avayahudi valekhonchovanchova, “Umunu oyo puayiluta ndakhu tulekhe okhupona? Ayiluta khu Vayevanikhe pagati pa Wayunani nukhuvamanyesya Avayunani? ");
INSERT INTO zgam_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Limenyu likhi elya nehovile, 'Yamukhundonda samukhambone; okhuyakha niluta samukhawesye okhwincha'?” ");
INSERT INTO zgam_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pu leno akhasekhe akhamwisyo, akhasekhe akhavakha akharonemelo, o Yesu akhima akhatoncha esavoti, akhanchova, inave vevoni alenekhyumila inche anywe. ");
INSERT INTO zgam_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Omwene uvikhumwedekha, ndu vusimbe vovinchova, ukhukhuma igati mumwene yagikhwikha amagasi aga wumi.” ");
INSERT INTO zgam_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Pakhuva akhanchovile aga ukhukongana nu Mepo, avavi khumwedekha voni vamwopelile; Omepo ale bado sakhumenchiwe pakhuva o Yesu sakhinoliwe bado. ");
INSERT INTO zgam_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Pu ululundamana, vavile vapulikhe amamenyu aga, vakhanchova, “Lweli oyo venyamalago.” ");
INSERT INTO zgam_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Avange vakhanchova, “Oyo ve Klisiti.” Pu avange vakhanchova, “Khekhi, Klisiti iwesya ukhukhuma khu Galilaya? ");
INSERT INTO zgam_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Uvosimbe savunchovile ukhuta u Klisiti ukhuta Klisiti ayikhumele ekhekoro khya Daudi nukhukhuma khu Bethlehemu, ekhejiji ekhe alemo u Daudi? ");
INSERT INTO zgam_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Evo, pugukhakhumila ugavanye kho pagati parurundamano olwa Yesu. ");
INSERT INTO zgam_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Avange pagati pavene vakhale vikhomwibata, pakhuva akhasipali oyakhakhusinche ekhevokho khokyanya khumwene. ");
INSERT INTO zgam_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Pu ava ofisa vakhavuya khuvavakha vavalongonchi Avafalisayo na vope vakhavavola, “Pu khekhi samundetile?” ");
INSERT INTO zgam_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Avaofisa vakhanda, “Asipali umunu ovagelile okhonchova nduyu kabla.” ");
INSERT INTO zgam_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pu Avafalisayo vakhanda, “Nayumwe musanchiwe? ");
INSERT INTO zgam_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Pukhwale vevoni muvalongonchi ovikhomwedekha, au vevoni Uvamafalisayo? ");
INSERT INTO zgam_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pakhuva avalulundamano avasalumanyile wrulagelo - vaberiwe.” ");
INSERT INTO zgam_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","O Nikodemo akhavavula (Omwene uviakhandundile o Yesu khatale, ale paninie na Vafarisayo), ");
INSERT INTO zgam_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Je urulagero lweto lukhung'ega umunu pakhuva vikhopulekhencha tale nukhulumanya ekhivomba?” ");
INSERT INTO zgam_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Vakhanda nu khumbura, “Na yuve vukhumela khu Galilaya? Olonde nulole ukhuta asipali onyamarago aveakhomile khu Galilaya.” ");
INSERT INTO zgam_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pu khela munu akhaluta khunyumba yamwene. ");
INSERT INTO zgam_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Unkoludeva alutile pakhewamba khyo Mizeituni. ");
INSERT INTO zgam_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Akhalava panavosihu akhincha khutembile na vanu voni vahandotela; akhatana nukhuva manyesya. ");
INSERT INTO zgam_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Usimbi avandisi usimbaji va Mafalisayo vakhatwalela udada uyibatiwe khumbombo ya voligu vakhambeha pagati. ");
INSERT INTO zgam_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Povakhambola u Yesu, “Umanyesi, udala uyu ibatiwe huvuligu, ikhohevomba elyeli. ");
INSERT INTO zgam_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Leno, hulu lulagelo, u Musa atuvulile alile tuvapondange amawe avanu ndava, wita ndakhehi khumwene? ");
INSERT INTO zgam_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Vakhanchovile aga ukhugela leno vapate enjela ya khung'ega, u Yesu akhinama pasi akhasimba pakhelonga khuhedole khyamwene. ");
INSERT INTO zgam_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Vavile vendelile uhumbuncha, akhema nokhuvavola, “Uyunchila mbivi avevakhwancha ukhutaviwa amawe.” ");
INSERT INTO zgam_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Akhinama tena pasi, akhandikha khuhedole khya mwene. ");
INSERT INTO zgam_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Vavapidikhe ago, akhahega yumo bada ya yumo, ukhyanjela ugogole. Humwisyo u Yesu vakhandeha mwene, nu dala uyuvavile pagati pavene. ");
INSERT INTO zgam_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","U Yesu akhima nuhuvavola, “Un'dala, avahuhekile valindahu? Asipali khata yumo uyahuhegile?” ");
INSERT INTO zgam_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Akhan'chova, “Asikholi khata yumo Itwa.” U Yesu akhanchova, “Ate une sanikhohohega lutaga injela yaho; ukhuma lene nukhwendelela usite uvombe imbivi.” ");
INSERT INTO zgam_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","U Yesu anchava na vanu akhata, “Unene nene lumuli lwa n'gelunga; Yuywa ihofyata sigenda muhisi poiva nulumuli ulwa womi.” ");
INSERT INTO zgam_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Avamafalisayo vahambola, wihesuhudela yuve; uvosuhuda wakho sio wayelweli.” ");
INSERT INTO zgam_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","U Yesu akhajbu akhavavola, “Ndaneve nikhesuhudela yune, nekhumanyile ukhunehomile nuhuniluta, ulwa khova umwe samukhumanyile uponikhoma nakhohwa nilota. ");
INSERT INTO zgam_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Umwe mwikhega umbele, unesanikhega yeyoni. ");
INSERT INTO zgam_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Une ndanekhege, uwakhegi wango wayelweli ulwa khova sanelenemwene, ulwa khova tulenu baba uya suhile. ");
INSERT INTO zgam_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ilweli, nululagelo lwenyo lusimbiwe uhuta uvosuhuda wa vanu vavele wilweli. ");
INSERT INTO zgam_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Une nene nikhesuhudela wa vanu vavele wolweli.” ");
INSERT INTO zgam_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Vakhambola, “Uwiso vaho alendahu?” U Yesu ukhanda, “umwesamumanjile oda ubaba vango samumumanyile; muamuvinchage mumanyile une, ndani mumanyile ubaba vango.” ");
INSERT INTO zgam_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Akhanchovile amamenyu aga akhavilejilani ne hazina ahavile imanyesya pa tembile, akhasipali khata yumo uyamwibite ulwakhova usekhe gwa mwene ngovile bado san'gofihe. ");
INSERT INTO zgam_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Akhavavola hange, “Niluta inchango; yamukhondonda nayamwifwa mumbivi ngenyo. Uhuniluta, samukhawesye uhwincha.” ");
INSERT INTO zgam_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Avayahudi vakhachova, “Ihebuda yuywa, yuywa ahachovile, 'Ukhuniluta samuhawesye uhwincha'?” ");
INSERT INTO zgam_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","U Yesu ahannchova, “Mhuma pasi; une nihuma hukyanya. Umwe mlevakelunga ekhei une sio nelevangelunga ekhe. ");
INSERT INTO zgam_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ulwahova, nawavolile uhuta mwifwa ni mbivi nchenye. La sivyo munyamini uhuta UNENE NENE, mwifya musambi nchenyo.” ");
INSERT INTO zgam_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Po wakhambula, “Uwe veve veni?” Yesu akhavavola, aganevavolile ukhuhuma khuvutengolelo. ");
INSERT INTO zgam_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nelena mambo mingi agakhanchova nuvukhegi hulwomwe. Ata eve, uyasuhile vayelyeli; na mambo aganepolihe ukhuhuma khumwene, amambo aganinchova khuvakelunga.” ");
INSERT INTO zgam_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Savahamveliwe uhuta alenkonchova ukhuhusu Udada. ");
INSERT INTO zgam_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","U Yesu akhachova, “Upoyaheva mukhomwinula umwana va munu, poyamuhumanya ukhuta nene, nuhuta sanivomba lyo lyoni khunafisi yange. ");
INSERT INTO zgam_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ulyahovo udada afundisye, ninchava amambo aga. Yuywa asuhile alepopaninye nane, nu mwene sandehile nemwene, ulyahuva khela isekhe nivamba agaganeliwa.” ");
INSERT INTO zgam_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","U Yesu woichova amambo aga, vingi va khamwedihe. ");
INSERT INTO zgam_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","U Yesu akhachova uvayahudi avamwedikhe, “Munganogwe ndimenyu lyango, pomwiva vasyole vango elweli, ");
INSERT INTO zgam_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","numwe muhuyemanya elweli, yihuvaveha hulu.” Vakhanda, ");
INSERT INTO zgam_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","“Ufye tulevaholiva va Ibrahimu nasatugele tuve pasi ya wotumwa wayeyoni, “Twiva hulu?” ");
INSERT INTO zgam_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","U Yesu akhanda, “Lweli, lweli, ukhuta, yuywa ivamba imbivi iva itimwa va mbivi. ");
INSERT INTO zgam_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Utumwa sitama hukaya umuda gwani; umwana itama isihu nchoni. ");
INSERT INTO zgam_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ulwahova, umwana ikhovaveha hulu, mwiva hulu elweli.” ");
INSERT INTO zgam_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nelumanyile uhuta umwe mlevaholiwa va Ibrahimu; Mulunda ukhumbuda ulwahova elimenyu lyango lesimoli lelevovole enafasi ingati ndimwe. ");
INSERT INTO zgam_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ninchova amamba gago negawene nu dada vango, nayomwe velevote muvamba amambo agamupolihe uhuhuma khwa dada venyo.” ");
INSERT INTO zgam_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Vakhanda nuhuvavola, “Udada veto ve Ibrahimu.” U Yesu akhanda, mwamuvinchage vana va Ibrahimu, muhamuvumbaga imbombo ncha Ibrahimu. ");
INSERT INTO zgam_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ata leno mulonda uhumbuda, umunu uya vavolile uvolyeli uhuta akhapolikhe uhuhuma khwa Nguluve. Uabrahamu sahavombe evo. ");
INSERT INTO zgam_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mvombe imbombo ncha Dada venyo.” Vahambola, “Satuhoheliwe mboligu, tuleno Dada yomo, Unguluve.” ");
INSERT INTO zgam_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","U Yesu ahavavola, “Ingave Unguluve vedada venyo, mhale muhongana une, ulwahova nchomile khwa Nguluve; sanchinche hunafsi yango, umwene vyahasuhile. ");
INSERT INTO zgam_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Hekhi samuhugeliwa amamenyu gango? Ulwahova samuhawesye uhufamelela uhugapoleha amamenyu gango. ");
INSERT INTO zgam_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Umwe malevadada venyo, utavangwa, namwinogwa uhuvomba uvonogwe wadada venyo. Ahavile ibadi uhuhima hwutengolelelo nasahawesye uhwema huvoyelweli ulwahova uwoyelweli vosimoli igati mumwene. Uluichova uvadesi lohova uhuhuma huasili yamwene ulwahova idesi nubabaye idesi. ");
INSERT INTO zgam_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Hata leno, ninchova yeyo yelweli, samuhonyamini (samuhunyedeha). ");
INSERT INTO zgam_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Veni kati yenyo iyihoshuhudele uhuta nele ni mbivi? Ingava nichova uvolweli, mbana samuhonyedeha? ");
INSERT INTO zgam_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Uyalenu Nguluve ipoleha amamenyu ga Nguluve; umwe sampoleha ulyahuva samleva Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Avayahudi vahanda nohumbula, satunchovile uvolweli uhuta uveve ulesamalia nole no mepo?” ");
INSERT INTO zgam_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","U Yesu ahanda, nilivovole ilipepo ulwahuva nihumwesimu udada vango, numwe samuhonyesimu. ");
INSERT INTO zgam_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Sanilonda ulyonginyo lwango; khwale yomo iyilonda nuhuhega. ");
INSERT INTO zgam_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nihovavola, nihovavola, uhuta, uyaheva yeyoni iholibata elimenyu lyango, sihuvovona uvofya habisa.” ");
INSERT INTO zgam_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Avayahudi vahambola, “Leno tulumanyile uhita ulenelipepo. U Abrahamu na vanyamalaga vahafwile; ulwahuva winchova, 'Ingave umunu ihulipata ilimenyu lyango, sihovova uvofye'. ");
INSERT INTO zgam_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Uveve sidembaho luliko udada veto Abrahamu uyafyule, avanyamalago vope vafyile. Uwe powihefyanya veve veni?” ");
INSERT INTO zgam_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","U Yesu akhanda, “Nengave nihetoja yune, khwetoja hwango hwa vovole; u Dada vango valionoja - yuywa muhunchova uhuta ve Nguluve venyo. ");
INSERT INTO zgam_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Umwe samumanyile umwene, une nemanyile umwene. Nengave nichova, 'sanemanyile,' niva kama umwe, vadesi. Ata leno, nelumanyile namamenyu gamwene negibite. ");
INSERT INTO zgam_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Udada venyo u Abrahamu ayihovaha yaheva ihoyevona isihu yango; ahayawene ahahovaha.” ");
INSERT INTO zgam_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Avayahudi vahambula, “Sofihinche ulimuli wa miaha hamsini bado, nuve umbwene u Ibrahimu?” ");
INSERT INTO zgam_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","U Yesu ahambola, “Nihovavola, nihovavola, nichova, tangu U Abrahamu saholiwe, UNE HUNELE.” ");
INSERT INTO zgam_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Povahahola amawe vanje uhutova, po u Yesu ahefiha nahahoma hunji hutembile. ");
INSERT INTO zgam_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Usekhe, u Yesu wigenda, ahambwene umunu uyusilola khuma iholiwa. ");
INSERT INTO zgam_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Avasiole vamwene vakhamboncha, “Rabi, veni ayavambile imbivi, umunu uyu au avahonohi vamwene, ipakha akhaliwe silola?” ");
INSERT INTO zgam_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","UYesu akhanda, “Sio umunu oyu wala avakhoji vamwene vavombile imbivi, ili embombo ya Nguluve yepate ukhuvonekha ukhugendela khumwene. ");
INSERT INTO zgam_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yinogiwa ukhovamba embombo yamweni uyasukhile usekhe vabado musi. Eikhisi yikhwincha usekhe gugwa hakuna uyakheva iwesya uhuvomba embombo. ");
INSERT INTO zgam_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ulwahova ekhelonga, une nene lumumuli lwa khelunga.” ");
INSERT INTO zgam_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ulwakhanchovile amamenyu aga, akhabekha pakhelunga, avekha elidope khumate, akhabaha umunu ula minukho nelidope. ");
INSERT INTO zgam_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Akhambula, ulute ukhoge ikhesiva kha Siloam (Uye yitafisiliwa kama 'uyasuhiwe').” Umunu uywa akhaluta, akhakalava, akhakilivokha, ilola. ");
INSERT INTO zgam_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Avajilani va munu uywa avalikhombona ukhuma khuvotengolelo ukhumbona kama idofi vakhachava, Uyu! sio vemunu uyakhatamaga idova?” Avange vakhachova, “Ve mwene.” ");
INSERT INTO zgam_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Avange vakhachova, “Ate, ila ikhwanana numwene.” Lakini alengonchava alen'kota, “Nene.” ");
INSERT INTO zgam_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Vakhambola, “Isainchi amikho gakho gafumbiliwe nekhehi?” ");
INSERT INTO zgam_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Akhanda, umunu uyuikhuelangiwa ve Yesu akhaveha alidope nukhubaha amikho gango nukhumbula, “Luta khu Siloam ukhakalave.' Ponekhaluta, nekhakalava, nekhavona nilola khange.” ");
INSERT INTO zgam_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Vakhambola, “Alendakhu?” Akhanda. “Sanelumanyile.” ");
INSERT INTO zgam_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Vakhan'gelekha umunu uywa uyagele ukhuva silola khuvamafalisayo. ");
INSERT INTO zgam_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yekhale sikhu ya Sabato po u Yesu akhatengenisye ilidope nukhufumbula amikho gamwene. ");
INSERT INTO zgam_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Avamafalisayo vahamboncha tena ukhugahile ndakhehi ipakha ukhalola. Aliwaambia, “Aliweka tope katika macho yangu, nikanawa na sasa naweza kuona.” ");
INSERT INTO zgam_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Avange Avamafalisayo vakhachova, “Umunu uywa sakhomile khwa Nguluve ulwakhova sibite Esabato.” Avange vakhanchova, “Yiwesehana ndakhehi umunu unyambivi ivomba imbombo inchi?” Pe vakhaga venyekha vawo. ");
INSERT INTO zgam_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Po vakhambon'cha uyusilola ukhepofu khange, “Wita ndakhehi khomwene ulyakhova akhafumbwile amio gakho?” Ukhopofu akhachova, “Inyamalago.” ");
INSERT INTO zgam_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ipakha isaliin'chi avayahudi sava khedekhe ukhuta silola navope apatile ukhulola ipakha avelangile avakhon'chi vamwene uyawesije ukhulola. ");
INSERT INTO zgam_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Vakhavovoncha avakhonchi, Je, uyu mwana venyo uyumwichova ukhuta akhaholiwe silola? Agakhile ndakhehi ukhulola?” ");
INSERT INTO zgam_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Avakhonchi vamwene vakhanda, “Tulumanyile ukhuta uya mwana venyo naakha khaliwe silola. ");
INSERT INTO zgam_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ndakhehi leno ilola, satolomanyile, navopo uya dendwile amikho gamwene, satomanyile. Imbon'che yuywa. Munu imbakha. Iwesya ukhweyelesya yuywa.” ");
INSERT INTO zgam_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Avakhon'chi vamwene vakhanchova amambo aga, ulwakhova vakhadwada Avayahudi ulwakhova Avayahudi vakhavile vedekhine tayali ukhuta, angave yeyoni ikhwedekha ukhuta u Yesu Klisiti, itengiwa ne Tembile. ");
INSERT INTO zgam_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ulwa khuva, uvakhon'chi vamwene vakhachovile, “Munu igoge imbakha imbonche yuywa.” ");
INSERT INTO zgam_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ulwa vele, vakhamwelanga umunu ula uyegelile ukhuva silola nukhumbula, “Ipe u Nguluve uluginyo. Tulumanyile ukhuta umunu uyu inya mbivi.” ");
INSERT INTO zgam_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Umunu ula akhanda, “Angave inya mbivi, une salumanyile. Ekhenu khemo ekhenelumanyile: Nekhale sanetekholola, isaliichi nilola.” ");
INSERT INTO zgam_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Po vakhambola, “Akhovambile khehi? Akhadendela amikho gakho?” ");
INSERT INTO zgam_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Akhanda, “Nekhavavolile tayali, numwe samukhapolekhenche! Khehi mwinogwa ukhupolekha khange? Numwe samwinogwa ukhova vasite vamwene, eti? ");
INSERT INTO zgam_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Vakhadokha vakhanchova, uveve ulevasiole vamwene, ufyefye tolevasiole va Musa. ");
INSERT INTO zgam_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tulumanyile ukhuta u Nguluve akhanchovile nu Musa, khomunu uyu, satokhomanyile ukhwikhoma.” ");
INSERT INTO zgam_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Umunu ula akhanda nukhuvavola, “Kwa nini, ele lijambo lwakhoswigencha, Unguluve ikhopolekhencha. ");
INSERT INTO zgam_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tulumanyile ukhuta u Nguluve sikhova polekhencha avanya sambi, ingave umunu idova khwa Nguluve ivomba umwanogile mwene, Unguluve ikhopolekhencha. ");
INSERT INTO zgam_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ukhuma khitengola ikhelunga sayegele yekhomele wala ukhupolekha ukhuta yeyoni alalile amikho gamunu uyakhalwe silola. ");
INSERT INTO zgam_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ingave umunu uyu sakhahuma khwa Nguluve, sakhaivomba khokhoni.” ");
INSERT INTO zgam_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Vakhanda vakhombola, “Ukhaholiwe mumbivi hani, buve vukhutumanyesyaga ufye?” Po vakhaswema ukhutembile. ");
INSERT INTO zgam_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","U Yesu akhapolekhe ukhuta van'genchinche ukhutembile. Akhombona nukhumbula, vukhu mwedekha umwana va munu?” ");
INSERT INTO zgam_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Akhanda nukhuchova, “Veni, Intwa, nayone nemwedekhe?” ");
INSERT INTO zgam_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","U Yesu akhambula, “Umbwene, uyuwinchova nave vemwene.” ");
INSERT INTO zgam_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Umunu ula akhanchova, “Intwa, Nikhwamini.” Pokhamwinamela. ");
INSERT INTO zgam_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","U Yesu akhanda, “Khuvakhegi ninchile in'kelunga umu vavo savilola valolage navavo vilola vavenchage savilola.” ");
INSERT INTO zgam_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Avange Avamafalisayo vakhale popaninye vape vakhapolekha amamenyu ago vakhamboja, “Na yofye satulola?” ");
INSERT INTO zgam_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","U Yesu avavola, “Mukhemvinchage samwilola, samukhale mwiva ni mbivi. Ata leno, mwinchova, 'Twilola,' imbivi nchenyo nchitama.” ");
INSERT INTO zgam_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Nikhovavola, Nikhovavola umwe uyusikhwingela ukhugendela mdwango gwa khevaga ikhya n'gosi, ulwa khova igenda khunjela eyenge, umunu uywa indwasi nayoipokha. ");
INSERT INTO zgam_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Uyikhwingela mndwango idema ngosi. ");
INSERT INTO zgam_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Khumwene uyikhondelela undwango ukhodendolela. In'gosi nchipolekha isawati ya mwene nukhunchelanga in'gosi ncha mwene khomatawa gavene nokhovakhamwa khonji. ");
INSERT INTO zgam_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yakheva ikhomwa khonji avavile vamwene ivalongola, ne n'gosi yikhokonga, ulwakhova vayemanyile esavoti yamwene. ");
INSERT INTO zgam_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Savakhafuate ugeni vikhwanja ukhunge gala, ulwa khuva savanchimanyile isawoti ncha vageni.” ");
INSERT INTO zgam_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","U Yesu akhanchova ufyano ugwa khuvene, ulwakhova savalekweliwa amambo aga, agalen'konchova khuvene. ");
INSERT INTO zgam_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","8","U Yesu akhanchova navo khange, “Nikhovavola, nikhovavola, umwe, une nene ndyango gwa n'gosi. Voni avalongwile valyasi navavo vipokha, ulwa khova in'gosi sanchikha vapolekhenche. ");
INSERT INTO zgam_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Une nene ndyango. Yeyoni uyikhingela ukhugendela une, ikhwokholiwa; ikhwingila igati nukhukhuma vapo ikhepatela ukhulwa. ");
INSERT INTO zgam_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Undyasi ikhincha ukhencha, ukhubuda, ukhwangamencha. Ninchile vapate uwomi vave nawo wingi. ");
INSERT INTO zgam_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Une neledemaji inonu. Ndemaji unonu ikhomwa wamwene khongosi. ");
INSERT INTO zgam_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Umbombi uyasukhiwe, nayoywa sio idemaji, yuywa ingosi sio nchamwene, ikhonchiva na imbwa incha mwinyasi vondukhwincha ikhonchilekha nukhunyila in'gosi. ");
INSERT INTO zgam_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ni mbwa incha mwinyasi nchikhwibata nukhusambasya inyila ulyakhova imbombi vakhwajiliwa sikhonchijali in'gosi. ");
INSERT INTO zgam_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Une neledimi inonu nevamanyile avango, navavo vavile vango vamanyile une. ");
INSERT INTO zgam_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Udada amanyile, nayone nemanyile Udada, nayone nikhumya uwami wango khon'gosi. ");
INSERT INTO zgam_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nelenancho in'gosi nyingi vava sio vakhevaga ekhe. Navo, yinogiwa ukhuvalete, navape vikhoyepolekha isawati yango ili pavepo ilikundi lemo nudemaji yumo. ");
INSERT INTO zgam_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Yu sababu eyo udala anganile: Nekhwomwe uwomi wango alafu newotole khange. ");
INSERT INTO zgam_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Hakuna uyusitola ukhuma khulyone, une nikhomya yone. Nelenago amadalakha agakhumya, nelenago amadalakha agakhotola, khange. Nepokhile ululagelo ulu ukhukhuma khya Dada.” ");
INSERT INTO zgam_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ukhutengana khukhakhoma khuvayahudi khumamenyu aga. ");
INSERT INTO zgam_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Avingi vakhanchova, “Ale nelipepo nekhenchaa. Khekhi mukhopolekhencha?” ");
INSERT INTO zgam_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Avange vakhanchova, “Aga sio mamenyu gamunu uyibatiwe na mapepo. Elipepo liwesya ukhudendola amikho gago sagilola?” ");
INSERT INTO zgam_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Po yekhincha eselekhe yakhovekhiwa vanonu Eyerusalemu. ");
INSERT INTO zgam_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Gokhale isekhe gwa mepu, u Yesu alenkugenda khutembile mbekumbi wa Selemani. ");
INSERT INTO zgam_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Avayahudi vakhandongola nukhumbula, “Ipakha ndeli vukhatuvekha masyakha? Kama ulekhelesiti, tuvule pavo valafu. ");
INSERT INTO zgam_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","U Yesu akhavavola, “Mbona nevavolile samukhonyedekha. Imbombo nchonivomba kholitawa lya Dada vango, incho nchisukhudela kholyone. ");
INSERT INTO zgam_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ata leno samukhonyedekha ulyakhova umwe samule n'gosi nchango. ");
INSERT INTO zgam_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","In'gosi nchango nchipolekha esawoti yango; Nevamanyile, navope vikhifyata une. ");
INSERT INTO zgam_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nevapile uwomi wasikhu nchoni; Khakheva ivatola ukhuma mavokho gango. ");
INSERT INTO zgam_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Udada vango, amile avo, imbakha khovani, khakunakhata yomo uyavile novowesyo ukhuvatola ukhuma mavakho ga Dada. ");
INSERT INTO zgam_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Une nu Dada tuleyomo.” ");
INSERT INTO zgam_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Vakhagega amawe ilivatove khange. ");
INSERT INTO zgam_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","U Yesu akhanda, “nevavanisye imbombo inonu ukhuma khya Dada. Khumbombo nchilekhu mvinogwa ukhunava namawe?” ");
INSERT INTO zgam_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Avayahudi vakhanda, “Satukhokhotova namawe khombombo yoyoni enonu, ulyakhuva khulugihyo, uveve yuve munu, wikhefyanya ule Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","UYesu akhanda, “Sayandekhive mululagelo lyenyo, 'Nekhanchova, “Umwe mwe va Nguluve”?” ");
INSERT INTO zgam_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Akhavelanga misetano, khuvala vavo elimenyu lya Nguluve livinchile (nuvosime sa vokhawesye ukhedenyiwa), ");
INSERT INTO zgam_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Mukhonchova yuywa akhangominche Udada nukhusukha ikelunga, 'Wibeda,' ulya khova akhonchovile, 'une nele mwana va Nguluve'? ");
INSERT INTO zgam_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Nengave sanivomba embomba ncha Dada vango, musite ukhunyedekha. ");
INSERT INTO zgam_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ata leno, nenga nivamba, khata kama samukhunyedekha, munchimanye imbombo ili muvesye ukhulumanya ukhuta u Dada ale agati ndyone nayone nelengati mwa Dada.” ");
INSERT INTO zgam_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Vakhegela ukhumwibata u Yesu, akhakhega ukhuma mavokho gavene. ");
INSERT INTO zgam_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","U Yesu akhuluta khange khumwambo ya Yordani esemu yeyo uyokhana alekhuonda tasi akhatama ukhwa. ");
INSERT INTO zgam_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Avanu vingi vakhadega khya Yesu. Vakhendelela ukhunchova, “Uyohana vopo sakhavombe eishara yoyoni, amambo goni aga nchovile uyukhana khunu hu uyu gavolweli.” ");
INSERT INTO zgam_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Avanu vingi akhamwedekha u Yesu apo. ");
INSERT INTO zgam_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Po umunu yumo elitawa lyamwene ve Lazaro akhale itamu. Akhakhomile kho Bethania, ikhejiji khya Mariamu na dada vamwene u Martha. ");
INSERT INTO zgam_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Akhale ve Mariamu yuywa akhabakha Untwa amafuta nukhufuta amalunde gamwene kho jwele ncha mwene yuywa ulokololwe va Lazaro akhale itamu. ");
INSERT INTO zgam_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Po avadada ava vakhasukha endomi khya Yesu nokhochova, “Intwa, ulole ugane vakho itamu.” ");
INSERT INTO zgam_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","U Yesu akhapolekha akhachova, “Uvutamu uvo sio wakhufya, ulwakhova, uwa voyane wa Nguluve uswambe va Nguluve agimive kho votamu.” ");
INSERT INTO zgam_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","U Yesu akhanganile u Martha nu dada vamwene u Lazaro. ");
INSERT INTO zgam_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Avile apolikhe ukhata u Lazaro itamu, u Yesu akhatama isikhu ivele upwakhale. ");
INSERT INTO zgam_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Popoele akhavavola avasyole vamwene, “Tuvokhe khovoyahudi khange.” ");
INSERT INTO zgam_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Avasyole vakhambola, “Imanyesi, vangagele ukhututa na mawe, nuve vunogwa ukhukilivokha ukhya khange?” ");
INSERT INTO zgam_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","U Yesu akhanda, “Amasaa gapamusi galekumi na mbili? Umunu ungenda pamusi siwesya ukhyekovencha, ulukhuva ilola khulumuli lwa pamusi. ");
INSERT INTO zgam_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Hata evo, angagende pakhelo, ikhyekovencha ulyakhova ulumuli lumoli igati mumwene.” ");
INSERT INTO zgam_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","U Yesu akhachova amambo aga, baada ya mambo aga, “Urafiki vato u Lazaro ugonelile, nilota khukhusisimula ukhuma mutulo.” ");
INSERT INTO zgam_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Po avasyole vakhambola, “Intwa, inave agonelile, isisimokha. ");
INSERT INTO zgam_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Usekhe ugwa u Yesu alegonchova ikhabari ncha lofye wa Lazaro, avene vakhata inchova ikhabari ncha toro. ");
INSERT INTO zgam_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","U Yesu akhanchova pavovalafu, “U Lazaro afyile. ");
INSERT INTO zgam_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nekhowikhe numwe, sanekhalepo ukhu ilimpate ukhunyedekha. Tuvokhe khumwene.” ");
INSERT INTO zgam_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Po u Tomaso, uyakhelangiwo lipancha, akhavavola avasyole vamwene, “Nayofye tevukhe tukhafye popaninye nu Yesu.” ");
INSERT INTO zgam_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","U Yesu voinchile, akhavono u Lazaro tayari alendipomba isikhu inne. ");
INSERT INTO zgam_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Yope e Bethania yakhale kalibu ne Yerusalemu uvutali ikilomita arobaini na tano ulu. ");
INSERT INTO zgam_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Avingi Avayahudi vakhincha khwa Martha nu Mariamu ukhuvasuvancha khya ajili ya lukololwe vavene. ");
INSERT INTO zgam_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","U Martha akhapolekha ukhuta u Yesu ikhwincha, akhaluta akhagane nave u Mariamu akhendelela ukhutama khukaya. ");
INSERT INTO zgam_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","U Martha akhambula u Yesu, “Intwa, ukhale uvinchage apa, ungancha vango sakha ifya. ");
INSERT INTO zgam_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ata leno, nelumanyile ukhuta lyolyoni eleyakheva vudova ukhuma khya Ngolove, wipata.” ");
INSERT INTO zgam_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","U Yesu akhavola, unyanchavo isisimukha khange.” ");
INSERT INTO zgam_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","U Martha akhambola, nelumanyile ukhutu isisimokha isikhu ya mwisyo.” ");
INSERT INTO zgam_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","U Yesu akhambola, “Une nene wofufuo howomi; yuywa ikhonyedekha, atakama isisi mokha, ataleno itamaga; ");
INSERT INTO zgam_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","yuywa ikhonyedekha une ifya. Ukholyamini ele?” ");
INSERT INTO zgam_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Akhavavola, “Sawa, Intwa mkhokhwedekho uveve veve Klisiti, Mwana va Ngolove, uyikhwincha nkelunga.” ");
INSERT INTO zgam_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Avile achovile ile, akhaluta khukhomwelanga udada vamwene u Mariamu khesili. Akhachova, “Umanyesi aleapa khokhwelanga.” ");
INSERT INTO zgam_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","U Mariamu avile apolikhe eve, akhema khembe ve akhaluta kya Yesu. ");
INSERT INTO zgam_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Nu Yesu akhava sijile tayali ikhejiji, akhavile bado khukhya vagine nu Martha. ");
INSERT INTO zgam_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Avayahudi vakhale nu Mariamu munyumba navavo vakhalemo visovancha, vavile vikhombona ikhyinokha khembeve ikhoma khonji, vakhakonga; vavile vatile vilota khulipomba khyilela ukwa. ");
INSERT INTO zgam_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Po u Mariamu, avile afikhe pala u Yesu akhambona, akhagwa pasi pamalonde gamwene nukhumbula, “Intwa, ukhale uvinchage apa, ulukololyango nda safyile.” ");
INSERT INTO zgam_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","U Yesu avile ambwene ilela, nawayahudi avinchile papaninwe valen'kolela voni, akhalola munumbula nukhusikhitekha; ");
INSERT INTO zgam_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Akhanchova, “Mgoninche ndapi? vakhambola, Intwa, ancha olole.” ");
INSERT INTO zgam_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","U Yesu akhalela. ");
INSERT INTO zgam_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Po Avayahudi vakhanchova, “Mulole wagonile u Lazaro!” ");
INSERT INTO zgam_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Avange vakhanchova, “Sio uyu, umunu uyabungwile amikho uyusilola, akhaiwesya ukhumbekha umunu uyu asite ukhufya?” ");
INSERT INTO zgam_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Po u Yesu, woilela munumbula mumwene, akhaluta ndipomba, yekhale manga, iliwe livekhwiwe pakhyanya pamwene. ");
INSERT INTO zgam_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","U Yesu akhanchova, “Khencha eliwe.” U Martha, udada vamwene no Lazaro, yuywa afyile, akhambola u Yesu, “Intwa, khusekhe ugu, umbele gwiva govolile ulyakhova avile muvofye khosikhu inne.” ");
INSERT INTO zgam_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","U Yesu ambola, “Sanekhavavole ukhuta, inave ukhunyedekha, wukhovovono uvovakhuwa Ngolove?” ");
INSERT INTO zgam_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Po vakhakhencha eliwe. U Yesu akhinula amikho khokyanya nukhunchova, “Baba, nimwalencha ulyakhova vakhomulekhencha. ");
INSERT INTO zgam_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nelemanyile ukhuta vukhomolekhencha khela isekhe, ulyakhova ukusanyikho gwemile ukhunyedekha ukhuta veve usukhile.” ");
INSERT INTO zgam_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Avile anchovile aga, akhalela esawoti embakha, “Lazaro, khuma khonji!” ");
INSERT INTO zgam_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Uyafyile akhakhoma khonji ankongiwe amavokho na malunde, khumikho ankongiwe ekhefambala.” U Yesu akhanchova, “Ifungule alutage.” ");
INSERT INTO zgam_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Po Avayahudi avingi vavile vinchile khwa Mariamu nukhulola u Yesu ekhya vombile, vakhamwedekha; ");
INSERT INTO zgam_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Avange lakhaluta khuva Mafarisayo khukhavavola amambo agavombile u Yesu. ");
INSERT INTO zgam_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Po avavakha va vatekheji na Vamafarisayo vakhakusanyekha popaninye ndi balasa nukhunchova, “Tuvomba ndakhihi? Umunu uyu ivomba amambo mingi. ");
INSERT INTO zgam_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tungave tukhondekha mwene, voni vikhomwedekha; Avarumi vikhwincha vitola fyoni imali ncheto nekhelonga kheto.” ");
INSERT INTO zgam_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ata evo, umunu yumu pavene, ve Kayafa, uyakhale intekheji imbukha umwakha ugwa, akhavavola, “Samkhemanyile khokhoni. ");
INSERT INTO zgam_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Samusaga ukhuta yifaa kholyomwe ukhuta umunu yumo inogiwa ukhufya khujili ya vanu khulikho ukhufyu ekhelonga khyoni.” ");
INSERT INTO zgam_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Aga sakhanchove mwene, po umwene, ulwakhova akhale atekheji imbakha umwakha gola, akhalagwile ukhuta u Yesu ifya khokhelunga; ");
INSERT INTO zgam_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Sio ekhelunga khine, ili u Yesu apate velevole ukhuvakusanya avana va Ngolove avagavanyikhe sekhemu eye neye. ");
INSERT INTO zgam_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ukhuma esikhu eyo nukhyendelela vakhapanga enjela ya khubuda u Yesu. ");
INSERT INTO zgam_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","U Yesu sakhagende khange pavovalafu khuva yakhudi, akhakhega pala nokholota khohelunga jilani nolokove usekhemu yikhwelangiwa Efraimu. Apo akhatama na vasyole. ");
INSERT INTO zgam_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ekhakho khya Vayahudi khekhale jilani avingi vakhatoga ukhuluta khu Yerusalemu khonji ya khelunga wosakhefikhe ekhaha ili vapate ukhwesukha vavo. ");
INSERT INTO zgam_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Valenkondonda u Yesu, nukhuchova khela muu vovemile pakhekalu, msaga khehi? Ukhuta sikhwicha khushelekhe?” ");
INSERT INTO zgam_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Usekhe ugwa avavakha va vatekheji na Vamafalisayo vavile, vakhominchi ululagero ukhuta ave yomo ikholuma u Yesu upwalepo, inogiwa ukhumya endomi ili vamwibate. ");
INSERT INTO zgam_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Isikhu sita kabla ya ikhaha, u Yesu akhaluta khu Bethania, ukhyakhale u Lazaro, uyakhanchosinehe ukhuhuma khuwofye. ");
INSERT INTO zgam_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Po vakhamwandalela ekhatio lya ekhanalyakhemikhe ukhya, nu Martha akhambombela, usekhe ugwa u Lazaro akhale paninye vavala vakhatamile pakhyakho lya paninye no Yesu. ");
INSERT INTO zgam_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Po u Mariamu akhatora elati ya mafuta gago gatengenesiwe nardo enonu, yeyo yelenesamani embakha, akhabukha u Yesu mmalunde, nukhupukhuta mmalunde khunjwele ncha mwene enyumba yoni yekhadega ekharufu ya amafuta (amanukato). ");
INSERT INTO zgam_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yuda Iskariote, yumo va vasiole vamwene, yuywa uyakheva ikhosaliti u Yesu, akhanchova, ");
INSERT INTO zgam_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Khekhi amafuta aga gakhagagonchiwe khukhela dinali mia tatu vakhavapewiwe avaganchu?” ");
INSERT INTO zgam_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Vope akhaganchova ago, sio ikhova kolela ekhesa avaganchu, ulyakhova akhale indyesi: umwene veibite upakho gw khela alekotola baadhi ya vifyo vivekhiwe umwa khojili ya mwene. ");
INSERT INTO zgam_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","U Yesu akhanchova, “Indekhe avekhe ekhyalenakho khojili ya sikhu ya khosiela kholyone. ");
INSERT INTO zgam_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Avaganchu mwiva navo isikhu nchoni; lene samukhave nune isikhu nchoni.” ");
INSERT INTO zgam_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Po elipoga elivakha lya Vayahudi povakhalumanya khuta u Yesu aleukhya, navakhincha, sio khwa Yesu tuu, ila vambone u Lazaro yuywa u Yesu akhasielyule ukhukhuma khuvofye. ");
INSERT INTO zgam_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Navope avavakha va vatekhenchi vakhedekhana ili vabude u Lazaro; ");
INSERT INTO zgam_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","maana khiyili ya mwene avingi Avayakhudi vakhaluta vakhamwedekha u Yesu. ");
INSERT INTO zgam_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Isikhu ya vele elipoga divakha vakhincha khushelehe. Vavapolikhe ukhuta u Yesu ikhyincha kho Yerusalemu, ");
INSERT INTO zgam_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","vakhatola amatawi ga mibekhe ga matende nokhokhoma khinji ukhuluta khu khopokhela nokhotova ekelele, “Khosana! Asayiwe uyikhyincha kholitawa lya Ntwa, Umbakha va Israeli.” ");
INSERT INTO zgam_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","U Yesu akhapata umwa punda; kama uluyandekhiiwe, ");
INSERT INTO zgam_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Usite, ukhudyada, ng'enja Sayuni; lola, Umbakha vakho ikhwincha, etogile emwana- punda.” ");
INSERT INTO zgam_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Avasiole vamwene savakhageliwe ago pavotengolelo; u Yesu avile aginiwe, bakhopo povakhakombokha imbombo inchi akhasimba umwene nokhota vavombile imbombo inchi khomwene. ");
INSERT INTO zgam_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Po lela elipoga lya vanu vavo vakhale popaninye nu Yesu vova mwelangile u Lazaro ukhuma ndipomba, vakholola khuvange. ");
INSERT INTO zgam_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Po yekhale khosababu eye ukhuta elipoga lya vanu vakhalotile khukho pokhela khusababu vakhapolikhe ukhuta akhavombile eishara eyo. ");
INSERT INTO zgam_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Avamafarisayo vakhonchovana vavo kho vavo, “Lola, leno samukhawesye ukhuvomba khokhoni; lola, ekhelunga khelutile khumwene.” ");
INSERT INTO zgam_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Po avange avayunani vakhale miongoni mwa vala avakhale valekolota khu khesaya khu shelekhe. ");
INSERT INTO zgam_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ava vakhandotela u Filipo, yuywa akhomile kho Bethsaida ya Galilaya, vakhadava vakhanchova, “Intwa, ufye twinogwa akhombona u Yesu.” ");
INSERT INTO zgam_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","U Filipo akhalota akhombola u Andrea; u Andrea nu Filipo vakhalota nokhombola u Yesu. ");
INSERT INTO zgam_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","U Yesu akhanda, akhanchova, lene yefikhe khojili ya mwana va Adamu ukhuginiwa. ");
INSERT INTO zgam_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ninchova, ninchova, nikhovavola, epunje ya ngano yegasite ukhugwa ikelunga yakhafya, yitama ekhali yela yela yene, po yengafye, yikhala isekhe imbakha. ");
INSERT INTO zgam_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Umwene uyavoganile uwomi wa mwene ikhovoyancha; khoba uyikalala uwomi wa mwene ikelunga uma ikheponya khata uwomi wa sikhu nchoni. ");
INSERT INTO zgam_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Umunu yoyoni uyikhombombela une, ang'onge; uponelepo une, po nayosukhya vango ivapwale. Umunu yeyoni uyakheva ikhombombela, udada ikhoginya. ");
INSERT INTO zgam_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Leno inumbula yango yesikhitikhe na yone nenchove ndakhekhi'? 'Dada, unyokhole isaliinchi'? Khulugano ulu nefikhe isainchi. ");
INSERT INTO zgam_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Daada, leginiwe elitawa lyakho.” Po esawoti yekhencha ukhuma khokyanya nokhonchova, neligininche nayone nikhdeginya khange.” ");
INSERT INTO zgam_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Po lipoga elekhemile jilani navope vakha polekha, vakhanchova vakhata, khuvile numwongulumo. Avange vakhanchova, “Usukhwa inchova nave.” ");
INSERT INTO zgam_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","U Yesu akhanda akhanchova, esawoti eye sayekhinche kholyone, bali kholyomwe. ");
INSERT INTO zgam_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Leno uvokhegi wa khelonga ekhe khovole: Umbakha va khelunga ekhe itagiwa khonji. ");
INSERT INTO zgam_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nayone nengotojiwe khokyanya ikhelonga, nikhovakwega voni kholyone.” ");
INSERT INTO zgam_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Akhanchova ago akhavonesya wofye wokhi uvoyakheva ifya. ");
INSERT INTO zgam_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Elipoga lekhanda, “Ufye topolikhe ululagele ukhuta u Klisiti itama khata isikhu nchoni. Nayove wita ndakhekhi, 'Umwana va Adamu lazima inoliwe khokyanya'? Uyu Umwana va munu veni?” ");
INSERT INTO zgam_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Po u Yesu akhavavola, ulumuli lungave popaninye numwe usekhe idebe. Mulutage ulukhova mule nulumuli, ekhisi yiwesya yevibate. Uyilota mukhisi salumanyile ukhyilota. ");
INSERT INTO zgam_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ulyakhova mnchige nulumuli, mulyedekhe ulumuli ulya mpate ukhova vana va lumuli.” U Yesu akhanchova ago po akhaluta akhefikha vasite ukhumbona. ");
INSERT INTO zgam_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ulyakhova u Yesu avombile amambo mingi khovolongolo khovene, bado savakha mwedekhe ");
INSERT INTO zgam_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ili letimele elimenyu lyanyamalago u Isaya, elyakhonchovile: “Intwa, veni uyanchipolikhe ikhabali ncheto? Nekhevokho khantwa afunuliwe veni?” ");
INSERT INTO zgam_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ndiomana avene savakhamwedekhe ulyakhova u Isaya akhanchovile khange, ");
INSERT INTO zgam_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Avabudile amikho, ayevikhile ngafu inumbula yavene; vasite ukhulola khomikho gavene navakhalumanya khunumbula ncha vene, ayavikhwokhokha na yone nikhovaponya.” ");
INSERT INTO zgam_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","U Isaya akhanchova amamenyu ago ulya khova akhavowene uvovakha wa Yesu nakhanchova ikhabari ncha mwene. ");
INSERT INTO zgam_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ulyakhova, ata avavakha vingi vakhamwedikhe u Yesu; ulyakhova Avamafarisayo, savakhedekhe ukhuta ayavitengiwa na avamasinagogi. ");
INSERT INTO zgam_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Vakhanogile uluginyo ulya vanu khulikho uluginyo ulolukhomana nu Ngoluve. ");
INSERT INTO zgam_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","U Yesu akhatoncha esawati no khonchova, “Yuywa ikhonyedekha une, sikhonyedekha une tuu bali nayoywa akhasukhile une, ");
INSERT INTO zgam_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","navope uyikhombona une ikhombona yuywa asukhile. ");
INSERT INTO zgam_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Une ninchile kama lumuli ikelunga ili khela munu uyikhonyedekha une asite ukhutama mkhisi. ");
INSERT INTO zgam_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ingave umu yeyoni ikhogapolekha amamenyu gango lakini asite ukhugibata, une sanikhon'gega; maana sanekhinche ili nekhege ekhelunga, bali nevokhole avakelunga. ");
INSERT INTO zgam_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yuywa ikhobela une nayoywa sikhyedekha amamenyu gango, nayoywa ikhongega: elimenyu ilyo lelyo nenchovile lyulyene lelangega esikhu ya mwisyo. ");
INSERT INTO zgam_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Une sanekhenchove khunumbula yango tuu. Ve Dada uyakhan'gelikhe yuywa umwene andaginche aga yakheva ninchova. ");
INSERT INTO zgam_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na yone nelumanyile ukhuta ululagelo lya mwene lya womi wa sikhu nchoni pogago ninchova une - kama Udada umwa mbolile, ponikhovavola avene.” ");
INSERT INTO zgam_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Po leno kabla ya sikukuu ya pasaka, ulyakhova u Yesu akhalumanyile ukhuta esaa lyamwene yeyo ikhega ikelungo ekhe ilota khwa daada, ingave avaganile avanu va mwene vavo vakhale ikelunga, akhavaganile sana. ");
INSERT INTO zgam_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","No tavangwa avile avekhiwe tayari munumbula ya Yuda Isikariote, umwana va Simoni, ukhusaliti u Yesu. ");
INSERT INTO zgam_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","U Yesu akhalumanyile ukhuta udaada avekhile ifinu fyoni mumavokho gamwene nukhuta akhomile khya Ngolove naalekolota khange khya Ngolove. ");
INSERT INTO zgam_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Akha sisimokha mkyakholya akhata ndekha pasi umwenda ugwa khonji. Akhatola ilitawalo akhekonga yoywa. ");
INSERT INTO zgam_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Akhavekha amagasi mbakholi akhanja ukhuvakalafya amalunde avasiole vamwene nukhuvafuta ne litawolo lelyo akhekongile yomwene. ");
INSERT INTO zgam_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Akhincha khya Simoni Petro, nu Petro akhambola, “Intwa, winogwa ukho ng'olyafya amalunde une?” ");
INSERT INTO zgam_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","U Yesu akhanda nukhumbula, elenilomba solemanyile isalinchi, wikhweliwa pongela.” ");
INSERT INTO zgam_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","U Petro akhambola, “Sakhasukhe amalunde gango khani.” U Yesu akhanda, ingave sanikhokhosukha, sukhave sekhemu paninye nune.” ");
INSERT INTO zgam_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","U Simoni u Petro vakhombola, “Intwa, usite ukhusukha amalunde gango tuu, bali namavokho nuntwe gwango.” ");
INSERT INTO zgam_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","U Yesu akhambola, “Yeyoni yoywa tayari ogile sinogiwa ukhwoga isipokua amalonde gamwene, na avile isafi umbele gwa mwene gwoni; umwe muvile safi, lakini sio mwevoni.” ");
INSERT INTO zgam_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ulyakhova u Yesu akhalumanyile yoywa ikhosaliti; eye yosababu akhanchovile, sio mwevoni mle safi.” ");
INSERT INTO zgam_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Uwokati u Yesu avile avasukhile amalunde gavene naavile atolile umwenola gwa mwene nukhutama khange, akhavavola, “Je Mweliwe khekhyo nevavombile? ");
INSERT INTO zgam_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mukhonyelanga une “Imanyesi” Intwa uyu mnchova volyeli, ulyakhova mnevelile. ");
INSERT INTO zgam_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Engave une Intwa na imanyesi, nevasukhile amalunde genyo, nayomwe mnogilye ukhuvasukha amalunde avayenye. ");
INSERT INTO zgam_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ulyakhova nevapile ufyano ili ukhota nayomwe khange muvombe kama une ulunevombile kholyomwe. ");
INSERT INTO zgam_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ninchova, Ninchova, nikhuvavola, usukhwa siimbakha kholikho untwa vamwene; wala yoywa asukhiwe imbakha khulikho yoywa asukhile. ");
INSERT INTO zgam_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ungave ulumanyile amambo aga, usayiwe ungagawombe. ");
INSERT INTO zgam_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Saninchova kholyomwe mwovoni, ulya khova nevamanyile avanevanchagwile - ila ninchova aga ili ukhuta uwosimbe wo wowese ukhutimela: 'Yoywa ilya ukate gwango anyemekhinche ekhesukhululu khwa mwene.' ");
INSERT INTO zgam_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nikhovavala ele kabla salekhomile ili yakheva lekhomile, muwesye ukhunyedekha ukhuta une NENE. ");
INSERT INTO zgam_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","“Ninchova, ninchova, nikhuvavola, uyuikhomokhela une, ikhopokhela yuywa nikhosukha, nayoywa ikhopokhela une ikho pokhela yuywa asukhile une.” ");
INSERT INTO zgam_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Po u Yesu avile anchovile aga, akhatesekha munumbula, akhalulola nukhunchova, “Ninchova, ninchova, nikhovavola ukhuta umpo venye ikhosaliti.” ");
INSERT INTO zgam_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Avasyole vakhalolana, vakha swiga akhanchovile khwani. ");
INSERT INTO zgam_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Vakhale pa mesa, yumo uvasiole vamwene egime ikefuva khya Yesu yuywa akhaganile. ");
INSERT INTO zgam_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","U Simoni Petro akhamboncha uvasiole uywa nukhunchova, “Tuvole veni yuywa khomwene ikhonchova.” ");
INSERT INTO zgam_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Uvasiole yuywa akhegime ikefuva kha Yesu akhambola, “Intwa veeni?” ");
INSERT INTO zgam_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","U Yesu akhanda, “Khu yuywa ninyofya ekhe pande khya kata ni khopa.” Avile anyofinche ukata, akhapa u Yuda umwana va Simoni Iskariote. ");
INSERT INTO zgam_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Baada ya kata, Usetani akhamwingila. U Yesu akhambola, “Khekho winogwa ukhuvomba ukhevombe khembeve.” ");
INSERT INTO zgam_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Po leno khakuna umunu pa mesa akhalumanya esababu ya Yesu ukhunchova elijambo ele khumwene. ");
INSERT INTO zgam_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ange vakhatile upakho gwa khela, u Yesu akhambola, “Ugule ifinu ifitwinogwa kwa ajili ya Sikukuu,” au inogiwa akhomye ekhenu khu ganchu. ");
INSERT INTO zgam_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Baada ya Yuda ukhupokhela ukata, akhakhuma khonji khembeve, yekhale pakelo. ");
INSERT INTO zgam_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","U Yuda avile akhegile, u Yesu akhanchova, “Leno umwana va Adamu inoliwe, u Ngoluve aginiwe khomwene. ");
INSERT INTO zgam_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","U Ngolove ikho ginyu khu mwene, na ayaikhoginya khembeve. ");
INSERT INTO zgam_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Avana avadebe, nele numbe usekhe idebe. Mukhondonda, nalulya nevavolile Avayahudi, 'Ukhunilota, samukhawesye ukhwincha.' Leno nikhovavola umwe, khange. ");
INSERT INTO zgam_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nikhovapa ululagelo ulupya, ukhota mganane; kama une ulunekhavaganile umwe, nayomwe, khange nayomwe mgananage yomwe khwa yomwe. ");
INSERT INTO zgam_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kho ele avani vitambolaga ukhuta umwe mole vasiole vango, mgave mlenologano khokhela yomo nu yunge.” ");
INSERT INTO zgam_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","U Simoni u Petro akhambola, “Intwa, wilota ndakhu?” U Yesu akhanda, “Esekhemu eyenilota lene samukha wesye ukhufyata (ukhung'onga), lakini mkhong'anga pongela.” ");
INSERT INTO zgam_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","U Petro akhambola, “Intwa, khekhi nesite ukhukhukonga khata leno? Une nikhomya uwomi wango khijili yakho.” ");
INSERT INTO zgam_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","U Yesu akhanda, “Je wikhomwa uwomi wakho khokili yango? Ninchova, ninchova nikhokhuvola, elikongove yukheva livekha vobelile mara khadatu.” ");
INSERT INTO zgam_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Usite ukhoyelukhusu enumbula yakho ukhukhangayekha. Vukhumwedekha u Nguluve mwedekhe na yone. ");
INSERT INTO zgam_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Munyumba ya Daada vango mlenembombo nyingi ya khutama; kama yekhale yivinchage, nakhale nikhokhovula, ulya khuva nilota khojili yakho. ");
INSERT INTO zgam_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kama niluta khukhovandalela amakhali, nikhwincha khange khukho vakhalibesya kholyone, ili amakhali bakho nelepo nyomwe mvepo. ");
INSERT INTO zgam_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Muyemanyikle enjela amakhali ukhuniluta.” ");
INSERT INTO zgam_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","U Tomaso akhambola u Yesu, “Intwa, satolumanyile amakhali upowilota; Je! Tukhoyemanya ndakhekhi enjela? ");
INSERT INTO zgam_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","U Yesu akhavavola, “Une nene njela, yavolweli, nu womi; asikholi uyiwesya ukhwincha khya Daada isipokua ukhugendela kholyone. ");
INSERT INTO zgam_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mukhale munchage mumanyile une, mukhale mwiva mumanyile Udaada vango khange; ukhwanjela isaliinchi nukhokhyendela mumanyile numumbwene umwene.” ");
INSERT INTO zgam_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","U Filipo akhambola u Yesu, “Intwa, tuvonesye Udaada, neyo yiva yetokwelile.” ");
INSERT INTO zgam_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","U Yesu akhavavula, “Sanevile paninye numwe khusekhe itali, bado somanyile une, Filipo? Yeyoni uyambwene une ambwene Udaada; winchova ndakhekhi, 'Tuvonesye Udaada'? ");
INSERT INTO zgam_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Samulumanyile ukhuta une nelegati ya Daada, nu Daada alegati ndine? Amamenyu aganincho khulyomwe sanincho kho khusuda yango yone; badala ya mwene, yo Odaada uyoitama igati ndyone uyoivomba embombo ya mwene. ");
INSERT INTO zgam_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Inyadikhe une, ukhuta nelegati ya Daada, nu Daada alegati nalyone; mwovoni inyedekhe une khosababu ya mbombo nchango khasa. ");
INSERT INTO zgam_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ninchova, ninchova, nikhovavola, yuywa ikhonyedekha, une imbombo nchila inchonivomba, ikhonchivomba imbombo inchi khange, na ayaivomba imbombo imbakha ulya khova nilota khya Daada. ");
INSERT INTO zgam_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Khokhoni ekhe mudova kholitawa lyango, ekhyonivomba Udaada awesye ukhu giniwa khu Mwana. ");
INSERT INTO zgam_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kama mnfadove ekhena khokhoni kholitawa lyango, elyo nivomba. ");
INSERT INTO zgam_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kama mwinogwa, mwikhwibata ululagelo. ");
INSERT INTO zgam_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Na ayanikhodova Udaada, Navape ikhovapa usaidizi uyonge ili ukhuta awesye ukhuva paninye isikhu nchoni, ");
INSERT INTO zgam_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Umepo va yelweli. Ekhelunga sakhiwesya ukhupokhela umwene ulwakhova sawukhombona, au ukhumanya umwene, ata ewo umwe, mmanyile umwene, kwani itama popaninye numwe naiva igati ndimwe. ");
INSERT INTO zgam_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Sanikhovalekha mwevene; Nivuyakho lyomwe. ");
INSERT INTO zgam_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Khosekhe idebe, ekhelunga sakhikhombona khange, umwe mukhombonaga, ulyakhova nitama, nuyumwe mtama khange. ");
INSERT INTO zgam_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kho sikhu eyo mlalomanya ukhuta une nilegati nu daada, nayomwe mlegati ndyone, nayone nelegati ndyone. ");
INSERT INTO zgam_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yeyoni uyikhwibata ululagelo lwango nukhuluvomba, veyoywa uyanganile une; na yoywa anganile une iganiwa nu Daada vango, naayanikhogana naayanikhevonesya yune nemwe khomwene.” ");
INSERT INTO zgam_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda (sio Iskariote) akhambola u Yesu, “Intwa, Je! Khenukhehi ekheyakha khohomela ukhota vukhevonyesya yuve kholyofwe na sio khokhelunga? ");
INSERT INTO zgam_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","U Yesu akhanda akhambola, “Kama yeyoni uyanganile ikholibata ilimenyu lwango, u Daada vango ikhogaza, natukhwincha khomwene tuvekha ukhutama puninye nave. ");
INSERT INTO zgam_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yeyoni yoywa sanganile une, sikhibata amamenyu gango. Elimenyu lyelyo mkholepolekha sio lyango bali lya Daada yoywa asukhile. ");
INSERT INTO zgam_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Neganchovile amambo aga kholyomwe, uwakati nitama numwe. ");
INSERT INTO zgam_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Khata eve, ufariji, Umepo umbalanche, yuywa Udaada ikhusukha khujili yango, ikhova ikhovamanyesya amambo goni ikhovamanyesya mkombokhage goni aganenchovile kholyomwe. ");
INSERT INTO zgam_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Eamani nikhovapa eamani yango umwe, sanikhovapa khama ekhelunga uwokhinogwa. Msite ukhuvekha inumbula yenyo ukhakhangayekha. ");
INSERT INTO zgam_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mkhapolikhe ulunekhavavolile, 'Niluta inchango, na ayanivaya kholyomwe, mkhale mnganage une, mukhale mwiva nolukhekhelo ulyakhova nilola khya Daada, ulyakhova u Daada imloakho kholikho une. ");
INSERT INTO zgam_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Lene nevavolile kabla sayekhomile ili ukhuta, yengakhomele, muwesye ukhunyedekha. ");
INSERT INTO zgam_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Sanekhanchove numwe amamenyu mingi ulya khova umbakha vakhelunga ekhe iva inchile. Umwene alevovole amakha kholyone, ");
INSERT INTO zgam_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ili ukhota ekhelunga khelumanye ukhuta nenganile u Daada, nivomba khekhyo asukhile une, kama ulyamile ululagelo, tukhume aponu apa. ");
INSERT INTO zgam_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Une nele usabibu ugwa lweli nu dada vango indemaji vaa usanbibu. ");
INSERT INTO zgam_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Hela ulusiamba lulegati ndiune ulusafi siwa hela usiamba ulusalu hola isehe ihuluhecha ili lupate uhuhola sana. ");
INSERT INTO zgam_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Umwe lenu mvile vanonu msababu mvile vasuhwa uhuva nevile nevavulile. ");
INSERT INTO zgam_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mtame mgati ndione nayune netame gati ndiumwe kama ulusiambalulwa saluwesia uhu hola luene isio uhuva usanbibu nayumwe mnasitu uhutama igati ndiune. ");
INSERT INTO zgam_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Une nele usanbibu umwe mlelusamba uveidumu mgati ndiumwe umnu uyu ihola isehe nyingi uhuva pasipo une samhaweze uhuvomba imbombo yuyoni. ");
INSERT INTO zgam_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Inave umnu yuyoni sivemo gati ndiune itagiwa kama ulusiamba nuhuuma avanu yavi kusanya amasamba nuhutaga humoto, nuhutehetela. ");
INSERT INTO zgam_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mnave mtama gati ndiune na kama amamenyu ya gitama gati ndiune dova lelioni ilimwinogwa numwe mvombeliwa. ");
INSERT INTO zgam_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Huele udada vango ihwinuliwa yamwi hola isehe nyini nuhuva vasiule vango. ");
INSERT INTO zgam_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kama udada vango umwa nganile une nayune nevaganile umwe; mdamage mlugano lwango. ");
INSERT INTO zgam_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mnave mhwibata indagele chango mtama mlugano lwango kama umni batile indagelo icha dada yangu nuhutama mvugane wamwene. ");
INSERT INTO zgam_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nenchovile aga hulemwe ili uh hovuha hwenyo huve gati ndiune ili uhuhovona hwenyo hevombehe ehele kamilifu. ");
INSERT INTO zgam_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ulu lulu lagelo lwango uhuta mganane yumwe hwa yumwe kama umone vaganilune. ");
INSERT INTO zgam_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Hakuna umnu uvale nulugano ulu vaha hulihune ehumiee uvutamo uwa mwene hwa ajili ya lafiki avanine. ");
INSERT INTO zgam_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Umwe mlelafiki vango mnave mvomba aganihuvasuha. ");
INSERT INTO zgam_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Sanihuve langa kama vatesiwa uhuva utesiwa sihwelewa hehuva utesiwa sihwelewa hehwo ivomba umbaha vamwene nevelangile kama malafiki uhuva nevavulile amambo goni aga uhuhuma hwa Dada. ");
INSERT INTO zgam_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Samwa njagule une bali une navachagiile umwe nuhwasuha mlute isehe nisehe chenyo chipate uhuhola isehe nesehe chenyo chipate uhu tama hela ehe mwinogwa uhudova hwa Dada mdove hulitawa ilengo ihuvapa. ");
INSERT INTO zgam_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Amambo aga nihuvasuha hela mnu agana nage na vanine. ");
INSERT INTO zgam_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Kama ehelunga hihuvakala lela welewe uhuta umwe mngalalile une kabula saheva kalalile umwe. ");
INSERT INTO zgam_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Inave mwale va helonga ehelunga hehale hihuvagana umwe leno uhusa sio mlevahelunga uhuva nava chagile uhuhuma mhe lunga ndi ehelunga hihuva kalalela. ");
INSERT INTO zgam_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kumbuha elimenyu elenavavulile uviteseha siwesia uhwa mbaha va mwene uhuva vanesiche une vihuvatesi nayumwe kama mwaibite amamenyu gango vahale vihwibata naga genyo. ");
INSERT INTO zgam_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Vavombiee amambo goni hulitawa iliango uhuva samhwelewa uveasuhile. ");
INSERT INTO zgam_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kama nenga site uhwicha uhuva vula ndaleno, savavombile uvutulanongwa; lakini usehe ugu savahabeche uvutula nogwa wavene. ");
INSERT INTO zgam_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Uviihung'alalela une ihukala lela Udada pia. ");
INSERT INTO zgam_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nenave sanevombile embombo mvene ambapo asipali yumo uveavombile vahale viva nu vutula nongwa ule leno va vombile goni gavele vambwene nuhung'alalelaune nu Dada vango. ");
INSERT INTO zgam_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ele lihumla ili elimenyu letimela lelwo lesimbiwe hululagelo luavo: 'Vihungalalela une bila sababu.' ");
INSERT INTO zgam_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Wakati ubembelesaji ichile uvepile nihusuha hulimwe uhuhuma hwa Dada, uyu vemepo uvalweli uvihuma hwa Dada ihusuhudela. ");
INSERT INTO zgam_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Umwe pia mhusuhudela uhuva mvile pamoja nune tangu huvutengulilo. ");
INSERT INTO zgam_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nevavulile amamba ago ili msite uhukwaseha. ");
INSERT INTO zgam_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Yavihuva humia mmasinagogi uhuva usehe ya gufiha uve ipya ihuvabuda ayisaga uhuta ivombe inono hwa ajili ya Nguluve. ");
INSERT INTO zgam_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yavihuvavombela amamba aga savi helewa udada uhuva savamanyile une. ");
INSERT INTO zgam_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nevavulile amambo aga usihe gulafiha vuaga gahumile yamweswa uhuga kumbuha na mneva vulile yumwe sanavavule amambo aga uhuhuma pavutengulilo uhuva nele pamoja numwe. ");
INSERT INTO zgam_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Uhuva usehe ugu niluta huyuywa asuhile; lakini hakuna katikati yetu uvihumbocha, “Wiluta ndahu?” ");
INSERT INTO zgam_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Uhuva nechovile amamenyu aga huliomwe amasago gadegile munumbula. ");
INSERT INTO zgam_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Hata leno, nihuva vula uvu yelweli nilononu huliumwe nenahege, uhuva nenasite uhuhega uvibembe liesiasahiche; lakini nenahege nihusuha huliomwe. ");
INSERT INTO zgam_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Aniche uvibembeleswa ayihuva manya uhuhumana nuvutula nongwa uhuhumana nuvuyelweli nu huhumana hegiwa. ");
INSERT INTO zgam_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Uhuhumana nuvutulanongwa uhuva savanyamini une, ");
INSERT INTO zgam_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","uhuhumana nu vuyelweli uhuva niluta mwa dada, nasamhambone tena; ");
INSERT INTO zgam_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","nuhuhumana nuvuhegi uhwa vuvaha wa helunga iva ahegiwe. ");
INSERT INTO zgam_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nelenago mingi agahuvavula, lakini samhagelewe ino. ");
INSERT INTO zgam_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Lakini, Umepo uvaye lweli aniche ihuva dema huga yelweli goni uhuva saha chove hwa ajili ya mwene, lakini gugoni agapya ipuleha goni ayichova amambo ago ayihuga chova amambo agapya gihwicha. ");
INSERT INTO zgam_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Umwene ayihunginia une uhuva ayitole amambo gango ayihuvavula umwe. ");
INSERT INTO zgam_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ivinu vyoni ifialenavyo Udada vyango; uhuva nechovile humepo itola amambo gango ayihuva voneswa umwe. ");
INSERT INTO zgam_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Bado usehe ufupi samha mbone tena; na baada ya usehe ufupi tena, yamhumbona tena.” ");
INSERT INTO zgam_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Baadae avasiule vamwene vaha chovana henuhehi ehihotovula, “usehe ufupi, ita samhambona uhuva niluta hwa Dada?” ");
INSERT INTO zgam_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Hwa hiyo vahachova henuhehi ehihu tuchova, 'Bado usehe usupi'? Satu hwelewa ichi chova.” ");
INSERT INTO zgam_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","U Yesu alulile uhuta avavinogwa uhumbucha, navope ahavavula, “Mhevucha mwevene uhuhusu ele, umnechovile,'Uhuta bado usehe usupi, samhambone tena na baada ya usehe usupi mhumbona tena'? ");
INSERT INTO zgam_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Edeha, edeha, nihuvavula, yamwilela nuhueleleswa, lakini ehelunga yahihuva dega yamwiva na masago lakini amasago genyo ya gipendoha nuhuhovoha. ");
INSERT INTO zgam_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Udala iva nuluvavo wakati avile nuluvavo (au amasago) wakati wa huho lahufihe; leno apila ihola umwana, isamwa tena uluvavo husababu ya huhuvoha hwamwene uhupata umwana uvahuliwe mhelunga. ");
INSERT INTO zgam_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Umwe msaga leno, lakini nihuvavona tena; ni numbula chenyo chihovoha hakuna umnu uveipia ihuvahecha uhuhovoha hwenyo. ");
INSERT INTO zgam_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Esihu eyo samlambucha amaswali. Edeha, Edeha, nihuvavula, mne saye lilioni hwa Dada, ihuvapa hulitawa eliango. ");
INSERT INTO zgam_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ipaha usehugu samhesaya lilioni hulitawa eliango esaye mwipata ili ohohovoha hwenyo hukamimilehe. ");
INSERT INTO zgam_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nechovile numwe hu lugha iyesaye yelevihe, lakini ulu usehe gufihe upusanehachove hu lugha eyesio yihweleveha lakini baada yaleno ni huvavula waziwazi uhuhusu Udada. ");
INSERT INTO zgam_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Isihu eyo yamhesaya hulitawa eliango nasanehava vule uhuta yanihesaya haajili ya Dada venyo; ");
INSERT INTO zgam_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","uhuva Udada venyo avaganile uhuva mnganile une uhuva mnye dihe uhuva nehumile hwa Dada. ");
INSERT INTO zgam_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nehumile hwa Dada nichile huhelunga; tena, nehega mhelunga naniluta hwa Dada”. ");
INSERT INTO zgam_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Avasiule vamwene vahambula, “Ulolile uhuta wichova wasi wasi sautumela amafumbo. ");
INSERT INTO zgam_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ulu leno, tulumanyile uhuta uga manyile amambo goni sawinogwa umunu yoyoni ahuvuche amaswali uhuva tuhwamini uhuva uhumile hwa Ngolove. ");
INSERT INTO zgam_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","U Yesu ahajibu, “Usehugu mmanyile mhunyamini?” ");
INSERT INTO zgam_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Lula leno usehe gufihe sawa usehe gufihe ambapo yampechela lanila hela yumu na huvene mhundeha nemwene. Lakini sio nelene mwene puale Udada ale nune. ");
INSERT INTO zgam_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nihuvavula amambo aga ili mve nulu no chehecho mhelunga mle na fujo (mlena matata), lakini mweyepe enumbula nesindile ehelunga. ");
INSERT INTO zgam_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","U Yesu achovile amambo aga; ahinola amiho gamwene uhuluta hukianya ahachova, “Dada, usehe gufihe uminule umwana navope ahwinole uvewe - ");
INSERT INTO zgam_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","kama umpelile uvuvaha hukianya huoni ivia mbile ili avape uludeva ulwa hukianya vala avoni vavo uvapile. ");
INSERT INTO zgam_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Uvu vuvu tamo uwa hukianya uhuta vahumanye uve ve Nguluve vivalueli yuve, mwene nuve usuhile u Yesu Klisiti. ");
INSERT INTO zgam_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nahuinuile apa pahelunga nuhuye kamelesia embombo iyeuhamile neyevombe. ");
INSERT INTO zgam_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Dada, unyinule leno pamoja nuve vemwene ulueyinulo ulunale nalwo pamoja nuve kabula ya ehelunga uhuvumbiwa. ");
INSERT INTO zgam_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Navavonise ilitawa eli vanu uvuwamile pahelunga vale vanu vaho; lakini wang'abiswe unie vaibete amamenyu gaho. ");
INSERT INTO zgam_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ululeno vihwelewa uhuta hela henu ehumile hehumile huliuve, ");
INSERT INTO zgam_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","humamenyu gala uguvile umile une nevapile vavo amamenyu ago. Vapokhile yelweli vahalumanya uhuta une nihumile huliove vahaminzi uhuta veve usuhile. ");
INSERT INTO zgam_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nihuvadovela avene. Sanihuva dovela ehelunga bali vala uvuumile uhuva vaho. ");
INSERT INTO zgam_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ifinu vyoni iviango nifiaho na fiope iviolenavyo uve fiango na yune nihwinoliwa huifio. ");
INSERT INTO zgam_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Une nesimoli tena mhelunga basi avene vuvale helunga nayune ni huicha huliove Dada vevalweli vatunje hulitawa eliaho lela elu umile ufwe ili tuve nu vumoja, kama une nuve umtuvile nuvu moja. ");
INSERT INTO zgam_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nalitenele navo, navalolelile hutita waelewa mile navalendelile, hakuna umnu atayumo uviayagile isipokuwa umwana uviheyacha ili uvusime vutimele. ");
INSERT INTO zgam_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ululeno nihwicha huliove ulu leno nichova ili ehelunga hehovohe igati mvene vavo. ");
INSERT INTO zgam_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nevapile elimenyu liaho ehelunga hevakalalile uhuva avene sio vakelunga, kama une leno nuvunevile sio vakelunga. ");
INSERT INTO zgam_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Sanihuvasaya uhuvahecha mhelunga bali uvalendelele ni mbombo imbivi. ");
INSERT INTO zgam_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Avene sio vahelunga kama une sio nelevahelunga. ");
INSERT INTO zgam_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Uvaveve huvuyelweli huli uve vemwene katika uvuyelweli; elimenyu lwahoni layelweli. ");
INSERT INTO zgam_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Uhasuhile mhelunga nayune nevesuhile mhelunga. ");
INSERT INTO zgam_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Hwa ajili yavene une nihehumia huli uve ili navope vehumie huvuyelweli. ");
INSERT INTO zgam_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Sio ava avanihuva dovela bali navala ava pia vihunyedeha uhugendela mlimenyu elivene, ");
INSERT INTO zgam_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ili vope vave nuvumoja, kama vile uve Dada, kama umovile gati ndiune nihuva dove lauhuta vope vave gati ili ehelunga hepate uhwamini uhuta veveusuhile. ");
INSERT INTO zgam_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Uwinuhe vula uvuumile une - nevapile vavo, ili vave nuvumoja - ");
INSERT INTO zgam_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Une igati mvene navope gati ndiune, ili vaweswe uhukamelesiwa katika uvumoja; ili ehelunga hepate uhwelewa uhuta uve veve usuhile nuhuvagana, kama uhuvagana nduvu nganile, une. ");
INSERT INTO zgam_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Dada, hela ehiumile une - Ninogwa vope vave pamoja nune mahali upunelepo vawese uhumbona uvuvaha wango, vula uvumile: uhuva uve wanganile une sana kula ya uhuvumbiwa ehelunga. ");
INSERT INTO zgam_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Dada venyahaki, ehelunga sahiehumanye uveve, navaeliwe uhuta wasuhile. ");
INSERT INTO zgam_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nehavombile elitawa lelevehe huliuve nayanivumba lelevehe ili ulugano ulumile une luwesie uhuva igali mvene nayunene vemgati mvene.” ");
INSERT INTO zgam_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Baada ya uhuchova amamenyu aga, ahegile navasiule vamwene uhuluta hulivende elia Kidron, umule ne bustani, ambaho avasiule ingile igati mmwene. ");
INSERT INTO zgam_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ululeno u Yuda, uvanogwaga uhu uhuchongela vabude navope a eliwe esehemu eyo tena u Yesu alutaga lutaga esehemu eyo navasiule vamwene. ");
INSERT INTO zgam_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nu Yuda, avile apatile kundi la avalendeleli na avasomi (avembi) avavaha avalongochi vahicha ni nulumli kulunzi ni silaha. ");
INSERT INTO zgam_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Nu Yesu, salwe hela henu hehio helenu umbeha hwa ajili yamwene aha humile huvu longolo ahavavucha, “Mhundonda uveni?” ");
INSERT INTO zgam_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Navene vahajibu, “Yesu Mnazareth.” U Yesu ahava vula, “Une nene” Nu Yuda usaliti aemile pamoja navasihali. ");
INSERT INTO zgam_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Hwa iyo nihuvavula, “Une nene” apa vahakilivoha hesana sana nu hugwa pasi. ");
INSERT INTO zgam_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ahavavucha tena, “Veni uvemhu ndonda? navope vahajibu tena “Yesu mnazareth.” ");
INSERT INTO zgam_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","U Yesu ahajivajibu nemalile uhuva vula uhuta nene apa kama mhundonda une, valehe avange awo valutage.” ");
INSERT INTO zgam_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Aga gahale mamenyu ili atimele papo achovile katiha wale uvuwa mile sana vayache hata yumo.” ");
INSERT INTO zgam_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ndipo Simon Petro, alene mndu ahayekwega nuhugeda embaha huto eya kulia undongochi umbaha nelitawa eliamwene undongochi liale ve Malko. ");
INSERT INTO zgam_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","U Yesu ahambula u Petro, “Kilivula emundu yaho husito yaho hwanini uhuta nenyele ehekombe hea ihia mile Udada?” ");
INSERT INTO zgam_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Basi lela elikundi eliavalende lechi avavaha navalongochi Avayahudi vahambata u Yesu nuhukunga. ");
INSERT INTO zgam_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Navene vahandongocha hwanza ipaha hwa anasi uhuva umwene aledala va Kayafa, amaye alevembaha sana humwana ugwa. ");
INSERT INTO zgam_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Usehe ugu Uhayafa vemwene avapile uvusauli Avayahudi uhuta yehanogiwaga umunu yumo afwe huajili ya vanu. ");
INSERT INTO zgam_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","U Simoni Petro akongile u Yesu, vulevule avasiule uyunge. Nula uvasiule amanyihe hundongochi umbaha numwene ahingela pamoja nu Yesu katika engalawa eyandongochi umbaha; ");
INSERT INTO zgam_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","lakini u Petro aemile hunje hundiango basi uvasiule uva manyile nondongochi umbaha ahahumela hunzi ahanza uhuchova nu dala vaundongochi uvaalendelelaga undiango nu humwingicha u Petro igati. ");
INSERT INTO zgam_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Basi ufanyakazi uvalehu lendelela undiango ahambula u Petro, “Siuveve yuve ulenjela vavasiule vauyu umnu?” Navope ahachova, “Une sio.” ");
INSERT INTO zgam_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Na vala avalongochi na avavaha vahema maha pale vakochiche umoto ugwa namna hwale nemepu ataleno vale huota umoto ili vapate amafuhe nu Petro alenevene alehuota umoto ahava achige emile. ");
INSERT INTO zgam_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Undongochi umbaha ahambucha u Yesu juu ya avasiule avamwene nulumanyesio uluamwene. ");
INSERT INTO zgam_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","U Yesu ahajibu, “Nehevulile ehelunga wazi une nemanyiswe mala kwa mala mamasinagogi na mmatembile papo Avayahudi vikusanyiha nayune saneha chova lulioni husili. ");
INSERT INTO zgam_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Hehi ulehumbucha? Vavuche avale humlehecha hehio nele huchova. Avanu ava vagamanyile amambo gagonelehuchova. ");
INSERT INTO zgam_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","U Yesu avile achovile evo umbaha vavavaha ahava emile ahatova u Yesu huma voho gamwene, “Je, vuyitahiwa uhujibu undongochi umbaha?” ");
INSERT INTO zgam_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Nu Yesu ahajibu, “Kama nechovile elimenyu lioni elivivi basi uve sahidi hu ajili ya mbivi, kama nechovile vunonu hwa nini vuhunova? ");
INSERT INTO zgam_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ndipo Anasi ahagega u Yesu hwa Kayafa undongochi umbaha ahava akungiwe. ");
INSERT INTO zgam_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","U Simoni Petro ahavile emile alehupasia amafuhe mwene. Avanu vala vahambucha vahata. “Je, uvesio mlemamoja navasiule vamwene becha ahachuva “Une sinene.” ");
INSERT INTO zgam_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Yumo undongochi umbaha hale lukololwe va gosi amaye Petro agedile embuluhuto ahachova, “Je sio veve nehuwene hubustani?” ");
INSERT INTO zgam_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","U Petro ahabele tena, na mala elikongove lehaveha. ");
INSERT INTO zgam_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kisha vahatola u Yesu kwa Kayafa ipaha hu Praitorio. Yale manavusihu sana avene vavo savahingile mela Praitorio ili vasite uhweyingecha humbivi nu huyelwe epasaka. ");
INSERT INTO zgam_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Hwa iyo u Pilato ahaluta ahachova ahata nongwa nyihi eyehegiwa umunu uyu?” ");
INSERT INTO zgam_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Vahajibu vahambula, “Kama umnu uyu alavebila mbivi tuhale satahale tuhundeta huliuve.” ");
INSERT INTO zgam_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","U Pilato ahavavula, “Itole yumwe mwevene, mhahege uhulingana neselia yenyo.” Navayahudi vahambula, “Eselia saye hutu luhusu uhubuda umunu yoyoni.” ");
INSERT INTO zgam_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Vahachova evo ili elimenyu letimele elimenye eliachovile elelihufu uhufwa hwa mwene. ");
INSERT INTO zgam_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Basi u Pilato ahingela tena Praitorio ahamwelanga u Yesu ahambula, “Je, veve mbaha vavayahudi?” ");
INSERT INTO zgam_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","U Yesu ahajibu, “Je, uve vuhumbucha eliswali uhuva winogwa uhwelewa uhuva vingi vahusuhili uhuta umbuche une?” ");
INSERT INTO zgam_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Nayu Pilato ahajibu, “Une sanele Nyahudi, au sivyo?” Ehelunga hiaho navo vombi avavaha vuhaha huleta huliune uve uvombilehehi? ");
INSERT INTO zgam_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","U Yesu ahajibu; “Uvaha wango sio wahelunga ehe, kama uvuvaha wango wa vuve nesehemu katika ehelonga ehe aviteseha vango vahale vihunga nganela ilinesito uhuhuwa huvayahudi hwuyelweli, uvuvaha sawihume apa” ");
INSERT INTO zgam_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","U Pilato ahambula ahata, “Je, uve vevembaha?” U Yesu ahajibu, “uve ndivyo wowichova uhuta une nelembaha uhuva une naholiwe, sababu eye une nichile ielonga ili neve sadi vavuyelweli yuyoni uvalenuvuye lweli ipole hecha esavuti yango. ");
INSERT INTO zgam_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","U Pilato ahambocha, “Uvuyelweli vululehu avile i chovevo ahaluta huva yahudi ahambula sanihulevona lulioni umnu uyu. ");
INSERT INTO zgam_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Umwe mle nuvutamaduni uvuvuvomba nefungulele ukongwa yumo usehe gwa pasaka. Je mwinogwa nefungulele avayahudi.” ");
INSERT INTO zgam_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kisha vahatova ekelele vahachova siyo uyu tudendolele Baraba alepohaji. ");
INSERT INTO zgam_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Basi u Pilato atolile u Yesu nu hutova. ");
INSERT INTO zgam_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Vala avasihali vahasohota amatoni nuhutengenesia elitaji. Vahaveha hukianya hutwa ugwa Yesu nu hufualecha umwenda ugasamalawe. ");
INSERT INTO zgam_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Vahamwichela nuhuchova, “Uve veve imbaha vavayahudi! navahatova humavoho gavene. ");
INSERT INTO zgam_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","U Pilato ahumile hunji na huvavula avanu, “Lola nihuvaletela umunu uyu huliumwe ili mmanye uhuta alebila nongwa yuyoni.” ");
INSERT INTO zgam_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","U Yesu ahumile hunji afwalile amavuva gamatoni nemienda egwa sambalawe. Ndipo u Pilato ahavavula, “Lola umnu uyu apa!” ");
INSERT INTO zgam_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Usehe ugwa ndongochi umbaha vavile vambwane u Yesu, vahatova ikelele vahata, “Isulubeswe, sulubeswe.” U Pilato ahavavula, “Itole yumwemha sulubeswe uhuva une sanevu uvutula nogwa mgati mmwene.” ");
INSERT INTO zgam_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Avayahudi vahajibu Pilato vahata, “Ufwe tule bila seliya, neseliya tule vuvule eya hunogwa uhubuda uhuva umwene ahefanyile uhuta mwana va Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","U Pilato avileipoleha amamenyu aga ahanja uhuduada, ");
INSERT INTO zgam_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ahingela Praitorio tena nuhumbula u Yesu, “Uve uhumile ndahu? hata hivyo u Yesu sahajibu. ");
INSERT INTO zgam_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","U Pilato ahavuliwa, “Je, uve sawichova nune? Je, uvesulumanyile uhuta une nelena mamlaka ga huhufungula na mamlaka ahuhu sulubisia?” ");
INSERT INTO zgam_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","U Yesu ahajibu, “Ahata suhale wiva ni ngofu uhusidi hulione kamauhale sitolile hukianya. Ivyo umnu uva ang'echiche huliove alenimbivi imaha.” ");
INSERT INTO zgam_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Uhuhumana nelijibu eli, u Pilato ahanogwa uhundeha hulu, lakini Avayahudi vaha tova ekelele vahachova, “Kama vuhundeha hulu uve sio ule lafiki va Kaisari: Hela uvivomba henyune hundongochi umbaha iva henyume nu Kaisari.” ");
INSERT INTO zgam_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","U Pilato avileihugapoleha amamenyu aga, ahandeta u Yesu hunzi kisha ahatama nave huhegoda ehia vuhegi pama hali papo pijulehana mahali pasumenti, lakini huhe kiebrania, Gabatha. ");
INSERT INTO zgam_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ya maandalizi ga pasaha yavile yefihe pasehe uga saa sita. Pilato ahavavula Avayahudi, “Lola umbaha venyu uyu apa!” ");
INSERT INTO zgam_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Vagatova ekelele, “asulubiswe umbaha vennyo undongochi umbaha ahajibu ufwe tule bila undongochi umbaha isipo kuwa Kaisari.” ");
INSERT INTO zgam_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ndipo u Pilato aha ngumia u Yesu vuvene ili asubihe. ");
INSERT INTO zgam_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Navene vahatola u Yesu numwene ahahuma hali ahagega ehe da miling'na hiamwine ipaha huli eneo ilihelangiwa fuvu lia intwe huheebrania Golgotha. ");
INSERT INTO zgam_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Apo pavahasulubisia u Yesu, pamoja navagosi vavele yumo uvupande uvu nuyunge uvupande uvu nu Yesu katikati yavene. ");
INSERT INTO zgam_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","U Pilato ahasimba ealama nuhuyeveha hukianya mheda miling'ana apo pasimbiwe: YESU MNAZARETH, MFALME WA WAYAHUDI. ");
INSERT INTO zgam_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Vingi Avayahudi vale huemba eyo amahali apo pasulubisie u Yesu pale kalibu nu mji. Ealama eya ya simbiwe hujovele ya Kiebrania, huhe lumi ne Heyunani. ");
INSERT INTO zgam_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Avalongochi avavaha ava vayahudi vahambula u Pilato, “Usite, 'Uhusimba umbaha vavayahudi.” ");
INSERT INTO zgam_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nu Pilato ahavajibu gago, “Nesimbile gunesimbile.” ");
INSERT INTO zgam_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Baada avasihali uhusulubisia u Yesu, vahatola emienda egia mwene nuhugaha katika amafungu gane, hela usihali fungu lemo, ne kanzu nayope nayekanzo yale sayahoniwe ya suhiwe uhuhuma hukianya. ");
INSERT INTO zgam_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kisha vahachovana vavo hwa vavo, “Tusite, uhugeda katikati bali tuyetovele ikula yiva ya veni.” Elio lia humile ili uvusimbe votimesiwe, lelio liachoviwe vagivine emwenda giango, neligandaliango vahale tovela ekula.” ");
INSERT INTO zgam_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","vahavomba amambo aga. Umama yake u Yesu, udada va mamaye, u Mariamu udala va Kleopa nu Mariamu Magdalena - avadala ava va emile kalibu neheda milingana enja Yesu. ");
INSERT INTO zgam_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","U Yesu avile ambwene. Umama yake nula uvasiule uvaganile vuvemile kalibu ahambula umama vamwene, “Udala, lola, umwana vaho uyu apa!” ");
INSERT INTO zgam_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ahambula uvasiule, “Lola, umama vaho uyu apa. “Uhuhuma usehe ugwa uvasiule ahatola uhuluta hunyumba yamwene. ");
INSERT INTO zgam_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Baada ya ago, u Yesu ahelawa ahata aga gatali gasilile ili uvusimbe vitimesiwe ahachova ahata numilwe. ");
INSERT INTO zgam_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Uhwa hwale ehiombo hia degile siki basi va hahanjani isifongo eyeye degile siki hukianya hulusitu ulwa hisopo, vahaelehela mndomo. ");
INSERT INTO zgam_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Basi u Yesu avile ipohela siki ahachova yesilile ahainamamisia. Utwe ahavula enumbula yamwene. ");
INSERT INTO zgam_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","avayahudi kwa sababu ya maandalio emivele gesite uhutama hukianya auhedamilingana esihu ya Sabato (maana esabato yake sihu baha vahadova u Pilato amalunde vadenye vahaswemiwe. ");
INSERT INTO zgam_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Basi avasihalivahaluta vahadenya amalunde uva huanza nu vavele aliye na Yesu pamoja nu mwene. ");
INSERT INTO zgam_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Lakini vavile vandutile u Yesu nu hulola vahavuna ahamalile uhufwe savaha keda amalunde. ");
INSERT INTO zgam_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Lakini uasihali yumo ahang'ome paluvafu mala ahahumi ukisa na magasi. ");
INSERT INTO zgam_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nayumwene avalolile asihudile uvusuhuda wamwene aweni vuyelweli uvusuhuda wamwene aweni vuyelweli ili nayofwetupate uhusadihi. ");
INSERT INTO zgam_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Uhuva ago gahumile ili uvusimbe vutimele, “Hapana elichege ilipia lidenyeha”. ");
INSERT INTO zgam_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Netena uvusimbe wichova, wingi “Valandola yuywa valehungoma” ");
INSERT INTO zgam_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Baada ya Yusufu wa Arimathaya, navope vasiule va Yesu lakini husili ya woduachi wa Vayahudi ahadova u Pilato ang'eche umbele ugwa Yesu. Nu Pilato ahapa uluhusa. Bali ahaluta ahahecha umbele gwa mwene. ");
INSERT INTO zgam_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ahaluta u Nikodemo navope ula uvi ahandutile pakelo hapo huanza ahaheleha amachanganyo ga mamenyu aga udi yapata uvuchito wa ratili mia moja. ");
INSERT INTO zgam_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Basi vahagutola umbele gwa Yesu vahagukonga umwenda kitani pamoja mafuta agamanukato, kama vuyelevu imila chavayahudi katika kuzika. ");
INSERT INTO zgam_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na pala apasulubiswe pale ne bustani; na igati mbustani mwale nelipomba ilipya abalo savasilile umnu yuyoni igati umwa. ");
INSERT INTO zgam_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Basi hwasababu ya isimbe cha Vayahudi vahambeha u Yesu huhwa elikabuli lele kalibu, basi wakamlaza Yesu ndani yake. ");
INSERT INTO zgam_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Vukelo esihi ya huanza iya juma, wakati bado kilo, Mariamu Magdalena ahichile kaburini; ahalevone eliganga lehegile kaburini. ");
INSERT INTO zgam_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Basi ahaluta mbelo ahafiha kwa Simon Petro na haula uvasiule uyunge ambaye u Yesu aganile ahava vula vangechiche Bwana kaburini, wala satuhwelewa uhuva mbihile.” ");
INSERT INTO zgam_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Basi u Petro ahahega nuvasiule uyunge vahibata enjela eya huluta kaburini. ");
INSERT INTO zgam_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Vahaluta mbilo voni; vavile nayula uvasiule uyunge ahaluta luvelo kuliko u Petro ahava va huanza uhufiha kaburini. ");
INSERT INTO zgam_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ahinama nuhuhungela ahafivono ivitamala ifia sanda (mwenda) figonile lakini sahingela. ");
INSERT INTO zgam_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Basi ahicha nu Simoni Petro ahakonga ahingela igati mlikaburi. Ahavilola ifitambala ififi gonile ");
INSERT INTO zgam_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","neleso eyehavile huntwe pale sayeha gane pamoja ni fitambala sihava patali patali pavutali aponu papo pale pene. ");
INSERT INTO zgam_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Basi avile ahingela na yola uvasiule uyunge uvahale vahuanza uhufiha kaburini ahalola nuhuamini. ");
INSERT INTO zgam_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Uhuva bado savavomanyile uvusimbe eyahuta itahiwa uhuchuha. ");
INSERT INTO zgam_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Basi vala avasiule vahaluta tena humiave hunyumba chavene. ");
INSERT INTO zgam_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Lakini u Mariamu ahava emile jilani nelikaburi hunzi humwene alehulela basi ahalila ivi ahainama nuluvipo igati mlikaburi. ");
INSERT INTO zgam_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ahavavona avasuhiwa vaveli avali nimienda emivalafu vatamile yumo huntwe yumo humalunde apo upu gugonile umbile ugwa Yesu. ");
INSERT INTO zgam_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Navope vahambula, “Umama vulele la hehi ahavavula, “Uhuva vange chiche u Nguluve vango, walune sanihwelewa uhuvambihile.” ");
INSERT INTO zgam_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nayumwene avile achovile evo aha gewoha husana aha mbona u Yesu imile, ahasita uhwelewa uhuta uyuve Yesu. ");
INSERT INTO zgam_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","U Yesu ahambula, “Umamaye vulelela hehi vuhondonda veni umwene uyu akizani uyu vetunzaji ebustani ahambula, “Bwana, inave utolile uve umbule uhumbihile, une nengeche. ");
INSERT INTO zgam_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","U Yesu ahambula, “U Mariamu.” Umwene ahagevuha ahambula u Mariamu hune Kiaramu, “Raboni,” yani, “mwalimu vango.” ");
INSERT INTO zgam_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu ahavavula, “Usite, uhunyibata uhuva sanehegile uhuluta hwa dada; lakini niluta huvalukolo lwango uhavavule niluta hua dada vango navope vedada venyo hwa Nguluve vango nayumwe vi Nguluve venyo.” ");
INSERT INTO zgam_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mariamu Magdalena ahaluta ahavavola avasiule, ehabali eya huta “Nebwene Bwana,” nuhuta avavulile ago. ");
INSERT INTO zgam_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Yelale jioni, esihu ela, eya huanza eya juma, pale upuvahale avasiule emiliango gedendiwe huvudwachiwa vayahudi ahicha u Yesu ahema katikati ahavavula ahata, “Eamani yeve huliumwe.” ");
INSERT INTO zgam_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Navape avile achovile ago aha vavoneswa uluvafu ulwa mwene vala avasiule vaha hovoha avile vambwene Bwana. ");
INSERT INTO zgam_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Basi uYesu ahavavula ten, “Amani yeve hulimwe kama udada umwa suhile huliomwe une nihuvasuha umwe.” ");
INSERT INTO zgam_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Avile amalile uhuchova ago ahava vuvia ahavavula, pohela Umepo umbalache. ");
INSERT INTO zgam_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Vuvoni avapia mhuva heja uvutula nongwa vahecheliwe navuvoni avapia mhuvadendela uvutulanongwa viva vadendeliwe.” ");
INSERT INTO zgam_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Walakini yumu unine thenashala Tomaso, uvale hwelandiwa pacha savahale pamoja avile ihwicha u Yesu. ");
INSERT INTO zgam_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Basi avasiule vingi vahambola, “Tumbwene u Nguluve.” Ahavavula une, nenasite uhuga vuna amakovu ga misumali nuhuhwingecha amavoho gango, katika uluvafu luango sana hakele hata padebe. ");
INSERT INTO zgam_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Basi baada ya sihu nane avasiule vamwene vahava gati tena nayu Thomaso pamoja navope ahicha u Yesu nemiliango gedendiwe ahema katikati ahachova ahata, “Amani yeve huliomwe.” ");
INSERT INTO zgam_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kisha ahambula u Thomaso, leta apa ehedole hiaho ugalole amavoho gango ulete namavono gaho wingeche mluvafu luango wala uve yuve savuhwamini bali uvihuamini” ");
INSERT INTO zgam_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomaso akajibu ahava vula, “Bwana wangu na Nguluve vango.” ");
INSERT INTO zgam_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","U Yesu ahambula, ahata uve uhuva umbwene usadihi. Heli vavosava mbene vahasadiki.” ");
INSERT INTO zgam_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Basi matukio mingi aga vombile u Yesu huvulongolo huva siule vamwene, chicho sachihwandehiwe huhetabu ehe; ");
INSERT INTO zgam_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","lakini ichi chisimbiwe ili mpate uhwamini uhuta u Yesu ve Klisiti, mwana va Ngulove na nahwaho mwamini mve nuvusima hulitawa elia mwene. ");
INSERT INTO zgam_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Baada ya mambo ago u Yesu ahavonesia tena avasiule katika enyanza Tiberia; hivyo ahevonesia yumwene: ");
INSERT INTO zgam_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","U Simoni Petro nu Thomaso uviihelangiwa pacha nu Didimas, u Nathanaeli uva Kana ya Galilaya, naana va Zebedayo navange vavile avasiule wamwene vale pamoja. ");
INSERT INTO zgam_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Petro ahavavula, “Niluta hwi vua isomba.” Navope vahambula, “Na yufwe, twilutania nuve basivahahega vahepahela mhiombo ila ekelo eyo savahapata henu. ");
INSERT INTO zgam_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Hata panavusihu wavile vukile Yesu ahema ufuoni, lakini avasiule savahelewa uhuta uyu ve Yesu. ");
INSERT INTO zgam_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Basi u Yesu ahavavula, “Vanango mlene hetoeo kakula?” Vahajibu, “La.” ");
INSERT INTO zgam_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ahavavula, “Taga jalife uvupande uwa kiume wa hiombo, nayomwe mwipata basivaha taga wala savahawesia uhulekwe gatena kwa sababu ya huvanyingi isamaki. ");
INSERT INTO zgam_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Basi ula uvasiule uve aganile u Yesu ahambula u Petro, “Ve Nguluve.” Navope u Simoni Petro avile ipuleha uhuta ve Nguluve ahekunga eligwanda limwene uhuva alehebwinda ahetaga mnyanza. ");
INSERT INTO zgam_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Na avasiule avange vahieha katika mashua mana savahale hutali nehelunga ehekavu ila yapata futi mia mbili huno valehukohota elizalife elele ni somba. ");
INSERT INTO zgam_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Vavile vihuiha pwani vahaguvona umoto gwa kala napakianya pamoto vahachivona isomba nu kate. ");
INSERT INTO zgam_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","U Yesu ahavavula, “Tetani apa baasi ya isomba chicho mlovile ulu leno.” ");
INSERT INTO zgam_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Basi Simoni Petro ahatoga mhiombo ahale kwega jalife pwani ledechiche isamaki, imbaha mia moja hamsini ni datu 153; japokuwa chivile nyingi, namna eyo jalife salihabachuha. ");
INSERT INTO zgam_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","U Yesu ahavavula ichaa mdendule undomo wala hakuna uvasile yuyoni uvahalutile huhombo cha veveni uve vovihelewa uhuta uyu ve Nguluve. ");
INSERT INTO zgam_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","U Yesu ahaluta, ahatola ukate, ahavapa ni samaki vulevule. ");
INSERT INTO zgam_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ivyo ndivyo mala ya datu ya u Yesu uhuvoneha navasiule vamwene baada ya huchuha huvufwe. ");
INSERT INTO zgam_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Basi vavile u Yesu ahambula u Simoni Petro, “Simoni mwana wa Yohana je, uve unganile kuliho ava?” Ahavavula mwene Bwana; “Uve wuhelewa uhuta nehuganile aha vavula leswa ingosi chango.” ");
INSERT INTO zgam_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ahavavula tene mala yavele, “Simoni va Yohana anganile ahavavula sawa, Bwana uve ulumanyile uhuta nehuganile ahavavula, demaga ingosi chango.” ");
INSERT INTO zgam_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ahavavula mala hadatu, “Simon, va Yohana, u Petro ahakalala ulwa mbuchiche mala hadatu, unganile ahavavula, “Bwana, uve ulumanyile goni uve ulumanyile uhuta nuhuganile u Yesu ahavavula leswa ing'osi chango. ");
INSERT INTO zgam_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ahachova, amini, amini, nihuhuvula uwakati uchigehijana ule huva vuhekunga vimwene nuhuluta uhuwinogwa; lakini upia wiva gogolo yavunyosia amavono gaho nayuyunge ayihuhukunga nuhuhutola uhusa winogwa.” ");
INSERT INTO zgam_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ahachova elimenyu elio hwa hwevonesia huvufwe vulehu apia ihumwemeha u Ngoluve navope avile ago ahavavula mngongale. ");
INSERT INTO zgam_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","U Petro ahapenduha ahambona ula uvasiule uva aganine nu Yesu ihukonga veuyo uve hagine pahe pambaga pamwene wakati vilia ehia hulia ehia liiemihe ahachova ahata veni uvihuhusaliti?” ");
INSERT INTO zgam_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Basi u Petro ahambona uywa ahambula u Yesu, “Bwana, Na yuyu yu je?” ");
INSERT INTO zgam_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","U Yesu ahavavula, “Inave ninogwa atame hata nepia nivepo elio lihuhusu hehi ng'ongage. ");
INSERT INTO zgam_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Basi amamenyu gaha puleheha katikati ya vana hekolo yahuta uvasiule sifwa. Lakini u Yesu sahambule uhuta ifwa basi ineve ninogwa atamage ipaha apya nihwicha yihahuhusuhehi uve. ");
INSERT INTO zgam_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Uyo vevasiule uvealolile uvuyelweli na uveasimbile aga nayufwe tuhelewa uhuta uyu, ichova agayelueli. ");
INSERT INTO zgam_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Hule mambo minogi mingi agavombile u Yesu agago anasimbe lamo lemo nadhani ata ehelonga hioni sahiha toswee hwa jili ya ivitabu ifihale fihwandihiwa. ");
INSERT INTO zgam_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ikhitabu ikhya khatali nikhyandikhe, Theofilo, vunijova goni Yesu uvatengwile ukhuvomba nu khumanyisia, ");
INSERT INTO zgam_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ipakha isikhu Yeyo umwene apokheliwe khukhyanya. Iyi yale baada ya khuhumia iamuli ukhumela khu Mepo Umbalan'che. Khuvavitume uveavan'chaguile. ");
INSERT INTO zgam_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Baada ya mateso ga mwene, Umwene avonikhe khuvene vumwumi ni fisibitisio fingi filikhuvavula. Khu sikhu alubaini aevonisye khuvene, alikhun'chova ukhuhusu uvutwa wa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Avile ikhwagana paninie na vene, avavulile vasite ukhukhega khu Yelusalemu, lino vapulekhile khu ahadi ya Dada, yeyo, anchovile, “Mwale pulikhe ukhuhuma khuliune ");
INSERT INTO zgam_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ukhuta uYohana aonvhinche weli khumagasi, lino mukhuo n'chiwa khu Mepo Umbalanche khu sikhu in'cho n'choni.” ");
INSERT INTO zgam_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Vavile vakusanyikhe paninie va mbun'chinche, “Dada, ugu gusekhe lino ugu gusekhe ugwakhuvakilivula ava Israeli uvutwa?” ");
INSERT INTO zgam_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Umwene akhavavula, “Siyo lueli khulweli khuliumwe ukhuluma usikhi gugya uDada isegile khumamulakha ga mwene.” ");
INSERT INTO zgam_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Leno mupokhela amakha, usekhe Umepo Umbalan'che upukheva ikhyin'cha khuliumwe, na yumwe mwiva vasaidi vango khuoni khu Yelusalemu na khu Vuyahudi yoni na Samaliya ipakha umwisyo gwa khilunga.” ");
INSERT INTO zgam_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Untwa uYesu avile agan'chovile aga, vakhava vilolana khukianya, Umwene akhapembiwa khukianya, nilivango likhafunekha vasite ukhombona khumiho gavene. ");
INSERT INTO zgam_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Usekhe vuvilola khukianya fincho akhaluta, ghafla, avanu vavele vaemile pagati pavene vafualilee imienda imivalafa. ");
INSERT INTO zgam_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Van'chovile, “Mwe vanu umwe na va Galilaya, khekhe mukhuma apa vumwilola khukyanya?” Uyu uYesu uviatogile khukyanya ikilivokha vulevule nduvumukha mbwene vuilota khukyanya. ");
INSERT INTO zgam_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Puvakiliwikhe ukhuhuma khu kyamba ikha mizeituni, khikhwo khiupipi ni Yelusalemu, ulugendo ulwa sikhu Saba. ");
INSERT INTO zgam_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Wavile vafikhe vakhaluta ghorofani ukhuvavile vitama. Avo nu Petulo, uYohana, uYakobo, uAndelea, uFilipo, uTomasi, uBatulumayo, uMatayo, uYakobo Umwana va Alufayo, uSimoni Zelote nu Yuda Umwana va Yakobo. ");
INSERT INTO zgam_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Voni valungine ndumunu yumo, khumakha valikhwe ndevela khulwisayo. Paninie navo avakhale puvale avadala, uMaliamu umamaye va Yesu, na vakakhaye va mwene. ");
INSERT INTO zgam_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Khusekhe gula uPetulo aemile pagati pa lukolo, avanu 120, an'choville, ");
INSERT INTO zgam_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Valukolo, ikhala lasima amandikho gafimikhikhe, gago khatali Umepo Umbalan'che an'chovive khukhinywa khya Davudi ukhuhusiana Yuda, yuywa avelesinche vala avamwibite uYesu. ");
INSERT INTO zgam_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ulukhuva umwene akhala yumo veto apokhile ilifungu liamwene iliafaida khuhuduma.” ");
INSERT INTO zgam_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Lino umunu uyu agulile eneo khu khela ikhyapokhile khuvuvivi wa mwene napo agyile akhalongon'cha utwe, umbili gukhaban'chukha na mafumbu ga mwene goni gakhara pavuvalafu gakhadudikha. ");
INSERT INTO zgam_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Voni avakhatamile khu Yelusalemu vapulikhe ukhuhusu ili, lino elieneo elio vakhalilanga khu lugha yavene “Akheldama” ikho khyalo khya khisa.”) ");
INSERT INTO zgam_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Khukhitabu ikhya Zaburi khyandikhwa, 'Pulikhila ilieneo lya mwene live hame na lisite ukhuluhusiwa ate yumo ukhutama pala;' ni, 'Ruhusu umunu uyunge atole inafasi ya mwene iya uwongosi.' ");
INSERT INTO zgam_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Iyo ya muhimu, khuiyo, yumo uva vagosi wavotukongonchihne nufwe usekhe Untwa uYesu avile ahumile nu khwingela palyufe, ");
INSERT INTO zgam_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ukhutengolela khulwon'cho ulwa Yohana ipakha isikhu yeyo atoliwe khu kyanya, lasima ave insaidi va khun'chukha paninie nufwe. ");
INSERT INTO zgam_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","“Vakhavekha khuvulongolo avagosi vavele, uYusufu uvikhyilangiwe Yusito na Mathia. ");
INSERT INTO zgam_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Avene vadovile vakhata, “Uveve, Vutwa, uvuugemanyile imioyo gya vanu voni, leno uvekhe wasi veni veni khuvavele ava yuywa un'chagwile ");
INSERT INTO zgam_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ukhutola inafwasi khuhuduma nu usuhe, bakho uYuda avombile uvuvivi nukhuluta apamwene.” ");
INSERT INTO zgam_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Vakhatova ikula khwaajili yavene, ni kula n'chighagwele uMathia yuywa avaliwe paninie na wala ava mitume kumi na moja. ");
INSERT INTO zgam_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yavile ifikhe esikhu iya Pendekosti, woni vale pupaninye. ");
INSERT INTO zgam_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Gafula gukhahumila umungulumo ukhuhuma khukianya ndimepu ing'ali. Gukhadincha inyumba yoni avakhale muvale vatamile. ");
INSERT INTO zgam_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Apo n'chikhava khumila indimi, wita ndimi ncha mwoto nchigavanyikhe, nchikhava mukhwanya muwene khela yomo. ");
INSERT INTO zgam_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Voni vakhadenchiwa nu Mepo Umbalan'che vakhatengula ukhun'chova khun'chovele inchige, ndu Mepo uveava vekhile van'chovage. ");
INSERT INTO zgam_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Lenu vakhalipwo avayahudi avakhatamaga khu Yelusalemu, avikhuginia Unguluve, ukhuhuma khela khelunga pasi khukhianya. ");
INSERT INTO zgam_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ingurumo inchi vonchipolekhiwa, ilikundi lia vanu likhincha pupaninye wakha nu wasiwasi ukhuva khila munu avapulikhe vovin'cho khunjovele ya mwene. ");
INSERT INTO zgam_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","vasitwikhe nu khudegiwa, avene vakhanchova, “Lweli, ava voni avin'chova sio Wagalilaya? ");
INSERT INTO zgam_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Khikhi ufwe tukhuvapulikha, khela yumo khunchove n'chin'cho tutoliwe inon'cho? ");
INSERT INTO zgam_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Waparthia na Wamedi na Waelamu, navo vitama Mesopotamia, khu Vuyahudi, na Kapedokia, na khu Ponto na Asia, ");
INSERT INTO zgam_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","pa Frigia, Pamfilia, khu Misri, na khu Libya nakhu Kirene, na vageni navagemi ukhuhuma Rumi, ");
INSERT INTO zgam_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Wayahudi na waongofu, Wakrete na Waarabu, tukhuvapulihin'cha vovinchovaa khun'chovele ncheto ukhuhusu imbombo ya vuweso wa Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Voni vale nu vuduwaa nukhuchanganyikhiwa; valikhon'chovana vavo khwa vavo, “Iyi yilinama makhi?” ");
INSERT INTO zgam_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Lino avange vabedile vakhata ava vanywile vagalile.” ");
INSERT INTO zgam_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ila uPetro aemile paninie na wala kumi na moja, akhajova navo, “Avanu va Yudea mwevoni yumwe mtama apo pa Yelusalemu, ili lijulikhane khuliumwe, mpulikhin'che vunonu amamenyu gango. ");
INSERT INTO zgam_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Awanu ava savagalile nduvu musagela, imisekhe gia panavusikhu saa tatu. ");
INSERT INTO zgam_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Lino ili lilikhunchoviwa ukhugendela khwa nabii Yoeli: ");
INSERT INTO zgam_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Yuyiva khusikhu incha mwisyo; Unguluve ita, yuniduda Inumbula yango khuvanu voni. Avana venye na avakhenja vinyo, vihumia uvunabii, avadimi venyo vikhugavona amaono, navasehe vinyo yuvigogwa injosi. ");
INSERT INTO zgam_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Vulevule avavombi vango na vavombi vango avakhenja khusikhu incho, niduda Inumbula yango, wope yuvitabiri. ");
INSERT INTO zgam_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Yunivonesya maajabu khukyanya ni ishara pasi pakhilunga, ukhisa, umwoto, na mafusho ga liosi. ");
INSERT INTO zgam_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Nilinchuva libadelesiwa ukhuva hisi nu mwenchi gyiva ikhisa, vubadu sayin'chile esikhu imbaha iya ajabu iya Ntwa. ");
INSERT INTO zgam_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","yuyiva ukhuta khila munu uwikhulilangelo ilitawa li Ntwa ikhokha.' ");
INSERT INTO zgam_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Mwiva va Israeli, pulihincha amamenyu aga: Yesu wa Nazareti, munu uvyatambuliwe nu Nguluve khuliumwe khumbombo iyivombiwa na maajabu, uguigendela Unguluve pagati paliumwe, umwe yumwe mulumanyile- ");
INSERT INTO zgam_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ulwakhuva upango kwatenguliwe pakhwanja na malifwa ga Nguluve, ahumen'chiwa numwe, khumavokho ga vanu avawafu, mwasulubisye nu khubuda, ");
INSERT INTO zgam_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","uvingave Unguluve amwinuile, akhavuhen'cha uluvavo ulwakhufua khumwene, ukhuva sayawesakhanaga khumwene ukhumilikhiwa nuwa. ");
INSERT INTO zgam_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ewo uDaudi in'chova ukhuhusu yuywa, 'Nambwene Untwa lweli khuvulongolo khumiho gango, umwene mwale mukhevokho khango ikhakhudia leno sanikhegelen'chiwa. ");
INSERT INTO zgam_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Leno inumbula yango ya howikhe na lulimi lwango. Lwahuvokhilwe nagumbili gwango gutama vononu. ");
INSERT INTO zgam_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Sukhayelekhe inafsi yango yelute khuvufwe, tena yokhanduhusu umwedekhi vakho ukhulola uvuvolile. ");
INSERT INTO zgam_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Uve unyaminisye une injila ya wumi; vukhumbomba nedige uluhovokho khuvulongolo khumiho gakho.' ");
INSERT INTO zgam_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Lukolo lwango, niwesya ukhun'chova khuliumwe khumakha ukhuhusu dada veto Daudi: umwene afyule akhasyeliwe, nilikabuli lya mwene lili paninie nufwe ipakha elelo. ");
INSERT INTO zgam_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ewo, ale imbombi alumanyile ukhuta Unguluve ambekhile lweli khuvuyelweli wa mwene, ukhuta ivekha yumo mumbuhon'chi wa mwene khukhikiti khya milele. ");
INSERT INTO zgam_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Aliwene ili imbivi nakhan'chova ukhuhusu ukhun'chukha khwa Klisto, 'salekhiwa wafuile, na gumbele gwa mwene sagwalekhiwe ukhovola.' ");
INSERT INTO zgam_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Uyu uYesu - Unguluve afufule, ufue twivoni tulivasaidi. ");
INSERT INTO zgam_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Lenu, vuinuliwe mukhevokho ikha khindia ikha Nguluve, wapokhile iahadi ya Mepo Umbalan'che ukhuhuma khwa Dada, umwene amimine iahadi, yeyo umwe mwilola nu khupulikha. ");
INSERT INTO zgam_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kkhekhi uDaudi saayoge ukhuluta khukyanya, lino inchova, 'DADA an'chovile khwa Dada wango, ");
INSERT INTO zgam_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","“tama khivokho khyango khya khundio, ipakha upukhe vanivomba ava aduvi wakho khigoda khumalunde gakho. ");
INSERT INTO zgam_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Lino inyumba yoni iya Isirahili nayelumanye khwaleli ukhuta Unguluve ambombile umwene ukhuva Vitwa na viKelesto, uyu Yesu yuywa mwasulubisie.” ");
INSERT INTO zgam_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Linu vuvapulikhe ago vakhanyiwa munumbula n'chavo, vakhambula uPetulo na vamitume avange, “Lokolo, tugakhendeti?” ");
INSERT INTO zgam_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nu Petulo akhavavula, “Mupele na Mwon'chiwe, khila munu vunyo, khulitawa ilya Yesu Kilesto ukhuva musyekheliwa imbivi n'chenyo, na mupokhela izawadi Umepo Umbalan'che. ");
INSERT INTO zgam_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Lweli iye ahadi na khuvana venyo na vala voni avalikhutali, avanu vingi Untwa Unguluve veto upukhiva ikhuvilanga.” ");
INSERT INTO zgam_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Khumamenyu mingi avavulile nukhuvadova; akhajova, “Mwiyokhole muhume mukhizazi ihi ikhinangi.” ");
INSERT INTO zgam_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Puva khagapokhela amamenyu gamwene vakhongesekha khusikhu iyo avanu elufu tatu. ");
INSERT INTO zgam_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Vakhendelela khu mafundisyo aga mitume vale pupaninie, pakhumenyula ukhate na pakhwisaya. ");
INSERT INTO zgam_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Hofu ikhin'cha mugati, na maajabu mingi ne ishara nchikhavombekha ukhumela khu mitume. ");
INSERT INTO zgam_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Voni avaamini vale paninie ni finu fyavene pupaninie, ");
INSERT INTO zgam_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","na vagun'chin'che ifinu fya vene nu khugavania khuvoni ukhukongana numu ikhiinogwa. ");
INSERT INTO zgam_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ewo isikhu baada ya sikhu vaendelile vakhava nililengo limo khutembile, puva menyula ukate mu kaya, ikhyakhulya khuluhovokho nuvunyenyekhefu wa munumbula; ");
INSERT INTO zgam_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","vasifile Unguluve na vakhava nikhibali avanu woni. Untwa akhavaongelen'cha sikhu khwa sikhu vala vavo valikhokholiwa. ");
INSERT INTO zgam_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pakhuva u Petro nu Yohana vavile vilola khutembile osekhe ugwa khwesaya, akhasekhe akha saa tisa. ");
INSERT INTO zgam_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Umunu uyonge, ondema okhuma okhukholiwa, alekhupapiwa osikhu jonii alekhugona pa ndyango ugwatembile onony palekhuhuma khudova enekhelo iya vanu avavalekhuluta khutembile. ");
INSERT INTO zgam_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Upwavawene uPetro nu Yohana vale pakhufikha pa tembile, akhadova enekhelo. ");
INSERT INTO zgam_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","U Petro, vuikasya amikho, paninee nu Yohana, akhanchovile, “Utulolage ofwe.” ");
INSERT INTO zgam_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ondema akhavalola, akhakhuvela okhupewa ekhenu ukhuhumya khu mwene. ");
INSERT INTO zgam_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ulwakhu uPetro akhanchovile, “Ikhela nulutalama one nelevo vole, pakhuva ekhenelenakhyo nikhumwa ulwomwe. ukhugendela nditawa elwa Yesu Klisiti uvakhu Nazarethi, gendaga.” ");
INSERT INTO zgam_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","U Petro akhatola khukhevoho khwa mwene khwandwa, akhapemba khukwanya: Usekhe gumuamalunde ga mwene ififundo ifwa machege agavene fikhapatile amakha. ");
INSERT INTO zgam_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Akhanyelile khukyanya, umunu ondema akhemile nu khutengula ughugenda; akhingela mutembile pupaninie nu Petro nu Yohana, vu igenda, vuinyela, nu khuginwya uNguluve. ");
INSERT INTO zgam_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Avanu voni vakhambwene vo igendo nu khuginwya uNguluve. ");
INSERT INTO zgam_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Vakhalumanya vemunu ula uvekhale idova enekhelo pandwango ononu ngwa tembile, vakhadenchiwe nukhuswiga ulwa khuva ekhekhakhumile khumwene. ");
INSERT INTO zgam_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ulwa khuva avibatelile oPetro nu Yohana, avanu voni pupaniniye vakhanyilelile khulinyumba elwa Sulemani, vakhaswiga sana. ");
INSERT INTO zgam_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","U Petro avile alewene ele, '“Omwene vanu vakhu Israeli, pakhuva khekhi muswigaa? Pakhuva khekhi mukhelekha amikho genyo khulwumwene nu vuchaji weto?”. ");
INSERT INTO zgam_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","U Nguluve va Ibrahimu, nu va Isaka, nu va Yakobo, uNguluve uva Dada veto, amwinule ombombi va mwene u Yesu. Oyo ve mwene mukhambekhile nu khubela pa mikho aga Pilato, ulwa khuva umwene akhapangile ukhumbekha mwavukhe. ");
INSERT INTO zgam_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mukhabelile umbalanche nu vayelweli, pakhuva mukhanogilwe ukhuta ubudi avekhiwe mwavukhe. ");
INSERT INTO zgam_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Umwe mukhabudile unkuludeva uvawumi, uvekha nchusinche uNguluve ukhukhuma khuva nchukhile - Ufwe fwe vemelenehi va ele. ");
INSERT INTO zgam_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Leno, khu lwidiko ndi tawa lwa mwene, umunu uyo uvemu khumanya nukhumbona, avombiwe ukhuva na maha. Ulwidiko ulalugendela mwa Yesu lupile umwene eafya endagafu, khuvulongo khulwumwe mwe voni. ");
INSERT INTO zgam_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Leno, valokolo, nelomanyile ukhuta mwavombile mbukonyofu, vuvakhavombile na valongonchi venyoo. ");
INSERT INTO zgam_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pakhuva imbombo inchakhavavulile u Nguluve na mbeve mu milomo ugwa valagunchi vavoo, ukhuta u Klisiti ayiteswkha, leno agamalile. ");
INSERT INTO zgam_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ulwa khuva, pelaga nu khuswelukha, ili imbivi nchenyo nchikhenchiwe khabisa, ukhuta khinche akhasekhe akhwe nemela ukhukhumana nu vuwepo uwa mbaha. ");
INSERT INTO zgam_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ulwa khuva iwesya ukhusuha u Klisiti uyachagoliwe khu lugendo lwenyo, Yesu. ");
INSERT INTO zgam_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ulwa khuva umwene vevikhupokhela khukyanya impakha akhasekhe akhakhukhelekha ivinu vwoni, ulwa khuva uNguluve akhanchoovile khusana ne milomo egwa vala gunchi avavalanche. ");
INSERT INTO zgam_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ulwa khuva uMusa ahanchovile, 'Umbakha u Nguluve alambikha undagunchii ndone ukhukhuma khuvalokolo l wencho. Mukhopulekhencha khelakhenu ekheyava ikhu vavula umwe. ");
INSERT INTO zgam_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Yayikhumele ukhuta umunu uyu sikhupulekhencha undogunchii ayiteswa nukhubeliwa pa vanu.' ");
INSERT INTO zgam_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Lweli, na valagunchi vooni ukhukhuma khwa Samweli nava khakongile pasana pamwene, vakhanchovile nu khwenesya isikhu inchii. ");
INSERT INTO zgam_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Umwe mulevana va valagunchii nulwedikho u Nguluve avombile paninie na vakukhu, ndulwa khanchoovile hwa Abrahamu, 'Mu mbeyu eyako inyumba ne hooni incha nkelunga nchikhwinohiwa.' ");
INSERT INTO zgam_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Pakhuva uNguluve amwimvile ombombi va mwene, akhasung'a khulwumwe lale, ili avasaye umwe nukhu badelikha ukhukhuma khumbivi nchenyo.” ");
INSERT INTO zgam_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Akhasekhe akha Petro nu yohana puvalekhunchova na vanu, avalongonchi na valendeleli awatembile na masadukayo vakhavalutile. ");
INSERT INTO zgam_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pakhuva vakhakarile sincho uhwakhuva u petro nu yohana valekhumanyisya avanu ukhumanya uyiesu nu khwenesya ukhunchukha khwamwene uhkukhuma khuvafwile. ");
INSERT INTO zgam_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Vakhavibata nukhuvavikha murigelresa impakha esikhu eyeyekongire, uhwakhuva yikhalelwa khenikhe. ");
INSERT INTO zgam_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pakhuva avanu vingi avakhapolakhe uvufumbwe vakhedikhe, pakhuva enafasi eyavagosi avakhedikhe vale elfu tano. ");
INSERT INTO zgam_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Puyekhafikhe vukhelo esikhu eyikhonga, ukhuta avavakha vavene, avagogoro na vavisimba, pupaninie vakhelundamana khu Yerusalemu. ");
INSERT INTO zgam_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","U Anasi ondongonchi umbakhaalepo, mukayafa, nu Yohana, Isakanda, na voni avavale bokoro nu ndongonchi umbakha. ");
INSERT INTO zgam_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Puvakhavavekhile o Petro nu Yohana pagati pavene, vakhavavonchinche, “Khuvuwesyo vulekhu, au khulitawa lelekhu muvombile aga?” ");
INSERT INTO zgam_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ohwakhuva, o petro, andehwiwe omepo umbarache, akhavavula, “Umwe mwevavakha va vanu, na vagogoro. ");
INSERT INTO zgam_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Inave ufwe esikhu eye tovu nehiwa pakhuva embomboenonu yevombiwe khumunu utamuoyo khuchila yelekhu umunu oyo - khuchila yelekhuumunu oyo avombiwe ukhuva inkhafu? ");
INSERT INTO zgam_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Navonelemanyekhe elwa khuvanu voni avakhu Israel, ukhutakhulitawa elya yiesu kristi uvakhunazareti, uvengave mukhatesinchi uvunane unguruve anchusinch ukhukhuma khuvafwe, pakhuva khulugendo ulwamwene ukhuta umunu oyo ayikhwema pavolongolo pabyumwe iva nu wumii. ");
INSERT INTO zgam_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","O yiesu kristi liwe elevabedile ava vinchenga, uhwakhuva levombiwe ukhuva liwe livakha lwa parukanchi. ");
INSERT INTO zgam_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Vusipali uvolokhole khu munu uyunge yeyonii, olwakhuva lesipali elitawa elenge pasi pakherunga eletupeviwe twe vanu, elyunave khu elyo tuwesya ukhwedikhiwa”. ");
INSERT INTO zgam_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","pakhuva vavile valolile ovojasi owa petro nu Yohana, puvakhe riwe ukhuta vanu va khawaida avasavimbii, vakhaswigile, vakhavu manya ukhuta o Petro nu Yohana vale pupaninie nu Yiesu. ");
INSERT INTO zgam_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Pakhuva vakhabwene umunu uya khaponile emile paninie navene, vale vovole ekhenii ekhyakhune hoova khu ele. ");
INSERT INTO zgam_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Pakhuva vavile vamwile ukhuta avasuhiwa vakhege pavorongoro palulundamano ulwanongwa, vanchoovile venekhuvene. ");
INSERT INTO zgam_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Vachoovile, tikhuvagakhandakhekhi avanu ava? vuyweli ukhuta amazingara gavombikhe uhkugendele khuveneguma nyikhe khela munu uyitama khuyerusalemu; satuwesya okhurebera ele. ");
INSERT INTO zgam_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pakhuva, elevombiwe ele lesite ukhugenda muvanu, zekha tuvalole valekhe okhonchoova tena khumunu vevoni ukhugendela elitawa ele. ");
INSERT INTO zgam_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Vakhavelangile o Petro nu Yohana igati nukhuvavola ukhuta valekhe okhunchoova nukhumanyisya khu litawa lwa Yiesu. ");
INSERT INTO zgam_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pakhuva o petro nu Yohana vakhavavulile ukhuta, “Inave hoeli pa mikho aga nguruve ukhuvedekha umwekhuriko Nguruve, kheganiaga yumwe. ");
INSERT INTO zgam_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Pakhuva ufwe satuwesya ukhube khera ukhunchoova imbombo inchu tumchimwene nukhupulekhba “. ");
INSERT INTO zgam_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Usekhe ugwakhuvavunga sineho o petro nu Yohana, vakhavalekha valutange, savakhawesye ukhupata eyira uwwakhuvatovela, ulwakhuva avawu vowi vavokhupatagiwie u Nguruve khu khela ekhikhavo rubikhe. ");
INSERT INTO zgam_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","umunu uvakhupelile ekhuedego ekhupona nesigono arobaini. ");
INSERT INTO zgam_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","akhasekhe akhavavikhere vavokhe, o Petro nu Yohana vainchile khuvanu vavene nukhuva gooni avalongonchi avavakha na vagogoro agavavovile. ");
INSERT INTO zgam_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Vuvapulikhe, vakhatoncha nguruve nukhunchova, “vimbkha, vemwene vewavombile khukyanya ne kherunga ne nyanja ni vinufyoni ifiregati. ");
INSERT INTO zgam_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Vemwene ukhata, khumepo umbarache, khundomo ungwa dada vetu udaudi, umbombi vakho, anchovile, “pukhekhi avanu avakhe rungavavombile eghasia, avanu vasagile imbombo inchisanchino geranile? ");
INSERT INTO zgam_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Avatwa avakherunga vemilepo paninie, navavakha valundaminie pupaninie umbakha wayu kristi va mwene”. ");
INSERT INTO zgam_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Je lweli, vooni o Herode nu Pontio Pilato, paninie na vanu va nkerunga na vanu va Israel, vakherundanie pupaninie pakherunga ekhenundongonchi vaakho u Yiesu umbala nche, uvikhabakhile imono. ");
INSERT INTO zgam_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Vakharundaminie pupaninie ukhuvomba gooni gago ekhevokho khwakho nuwegane wakho vulamwile ukhukhuma pawancho pakhuva sagakhakhumile. ");
INSERT INTO zgam_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Leno umbakha, lolaga uvudwado avu, ukhavalongonche avavombii vakho ukhunchoova elimwenyu lwakhokho vujasi wooni. ");
INSERT INTO zgam_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ukhuta vuvukherekha ekhevokho khwakho khuponya, ifinu ifwakhudega viwesye ukhukhumila ukhugendela nditawaelwa ndongonchi vaakho umbalamehe u Yiesu '\". ");
INSERT INTO zgam_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Vuvamalile ukhwesaya, esekhemu eyiv khalundeminie pupaninie yikhasukhanikha, khukhuta vanchoovile elimenyu elwa Nguruve nu vujasi. ");
INSERT INTO zgam_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Akhasekhe khavakhu avavedikhe valene numbula yemo nu mepo yumo, pakhuva asiparina umo muvene uyanchovile ukhuta khyokhyoni ekhewibite khwale khwamwene yuywa, pakhuva vale ni fiinu vyooru paninie. ");
INSERT INTO zgam_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","khumakha gooni avasuhiwa pakhuva valekhunchova ludagano lnchakhunchukha khwa mbakha o Yiesu, nu luhungu uluvakha lukhale pakwanya pavene vooni. ");
INSERT INTO zgam_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Sapalepo numunu vevoni pagati pavene evesinogo uvuhitiji, pakhuva avanu vooni vale nu vuweso uwamjumba, vakhagonchi nche nukhu leta ikhhela incha vinu ifivakhago nchinche. ");
INSERT INTO zgam_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Nu khufivekha pasi pavasuhiwa mulugavo lukhavombikhe ukhule ngana nu keresiti, ukhulengano nu vunogwe wa khela munu. ");
INSERT INTO zgam_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","O Yusuphu, ondawi, umunu ukhukhuma kipro, apeviwe elitawonve Barnabas na vasuhiwa (eyo ikitafasiriwa, ve mwana va lukhungu). ");
INSERT INTO zgam_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ale ne khwale, agonchicnhe akha leta ikhela, avekhile pasi pa vasuhiwa. ");
INSERT INTO zgam_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ewo, umunu yumo ikhielangiwa Anania, nudala va mwene uSafira vakhagoja esekhemu ya khumali, ");
INSERT INTO zgam_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","akhafikha esehemu ya khele eyevagonchinche (udala va mwene akhalemanyile ele), akhagega esekhemu eyesigile nukhuyiveli ka malunde ga sukhwa. ");
INSERT INTO zgam_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Po uPetro akhanchova, “Anania, khehi usetano(utavangwa) ayedenchiche inumbula yakho ukhunchova uvudesi kho Mepo Umbalanche nukhufikha elieneo la khyoma khyalo? ");
INSERT INTO zgam_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Wosalegojiwe sakhekhave khima khyaho? Nawoyegonchiwe, yekhale ndakhehi elijambo ele usage munumbula? Sio uvasyovile avanu, usivile Unguluve.” ");
INSERT INTO zgam_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Avile ipokhela amamenyu aga, uAnania akhagwa pasi akhadumukha enumbula uwasiwasi uvovakha vokhavinchala vani vavo vakhapolikhe ele. ");
INSERT INTO zgam_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Avademi vukhincha khovolongalo khukhombekha msanda vakhangelekha khoji khukhosiela. ");
INSERT INTO zgam_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Usekhe gwa masaa gadatu, udala vamwene akhingela igati, asite ukhulumanya khekhyo khekhomile. ");
INSERT INTO zgam_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","U Petro akhombola, “Imbole mukhogonchinche ekhalo khulela eyo.” Akhachova, “Ee, khu samani eyo.” ");
INSERT INTO zgam_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Po uPetro akhombola, “Yevile ndakhekhi ukhuta mpatane popaninye ukhugela Umepo va Ntwa? Ulole, amalunde gavavo vasyelile ugosi vakho gale pandyango vikhogega vikhokhelekha khonji.” ");
INSERT INTO zgam_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Gafula akhagwa mmalunde ga Peturo, enumbula yekhagedekha, avademi vala vakhincha igati vakhambona afyile. Vakhagego ukhung'omya khunji, nukhusiela jilani no gosi. ");
INSERT INTO zgam_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ekhofu embakha yekhicha khotembile engoge, navani avapolikhe amambo aga. ");
INSERT INTO zgam_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Amambo mingi gatekhomela khovanu ukhugende mavokho ga syukhwa. Vakhale popaninye mbokumbi wa Sulemani. ");
INSERT INTO zgam_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ulwakhuva, akhasikholi umunu uyunge tofauti uyakhate nuvonchasili uwakhwibatana navo; ata ewe, vakheshimikhe sana na vanu. ");
INSERT INTO zgam_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ata ewe, avedekha vingi valekyongesekha khu Ntwa, esekhemu embakha yavagosi na vadala, ");
INSERT INTO zgam_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","valegovagega avatamu mitaa, nukhuvagonya vitanda na makochi, uPeturo wigenda ekhanchinchimela khyamwene khikhe khovene. ");
INSERT INTO zgam_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Apo, avanu vingi valekwincha ukhuhuma esekhemu yeyoyenchongolile eYelusalemu, nukhuvatwala avatamu navava vanchanga nikhiwe ni mepo imbivi, novoni vakhapona. ");
INSERT INTO zgam_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Poutekhenchi umbakha akhinokha, navo ni avakhale popaninye (vavo vakhavile valizekhebe lya masadukayo); vakhadegile no wivu ");
INSERT INTO zgam_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","vakhanyosya amavokho gavene vakhavibata avasukhwa nukhuvavekha igati mundibalasa elya moja khya moja. ");
INSERT INTO zgam_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Usekhe gwa pakelo avasukhwa ua Ntwa vakhedendala imilyango egya balasa nukhuvalongoncha khonji nukhunchova, ");
INSERT INTO zgam_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Mulutage mukheme khutembile nukhuvavola avanu amamenyu ga Womi uvu.” ");
INSERT INTO zgam_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Vavapolikhe evo, vakhingela khutembile wekhwikya nukhumanyesya. Po utekheji umbakha akhincha na vani avakhale nave injela, nukhulyalanga elibalasa lyoni popaninye navasekhe voni vavanu va Izilaeli, nukhuvasukha khulibalasa khuvatola avasukhya. ");
INSERT INTO zgam_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Poavavombi vavovalutile, savakhavavone ndibalasa, povakhavuya khukhumya etalifa, ");
INSERT INTO zgam_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Tuwene ilibalasa ledendiwe vononu navava vilendelela vamile pandango, votovile tudendola, satukhambone umunu igati.” ");
INSERT INTO zgam_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Poliseke umbakha vatembile nutekheji umbakha vovapolikhe amamenyu aga, vakhingeliwa ne khofu embakha khovene visaga yiva ndakhekhi embakha khovene visaga yiva ndakhekhi elijambo ele. ");
INSERT INTO zgam_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Yumo akhincha khukhovavola, “Avanu vavo mukhavavekhile ndi balasa vemile khutembile vikhovamanyesya avanu.” ");
INSERT INTO zgam_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ewo ujemedari lumbakho akhaluta popaninye na vavombi, vakhajivatwala, savakhavombe efujo, vakhavadwada avanu vakhaviwesya ukhuvatova na mawe. ");
INSERT INTO zgam_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Vova jikhovatolile, vakhavavekha khovolongolo khubalasa. Utekheji umbakha akhavavoncha ");
INSERT INTO zgam_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","akhachova, “Tukhavabelile msite ukhufundesya khulitawa ele, bado mudenchinche eYelusalemu khulifusyo elenyo, namunogwa ukhuleta ukisa gwa munu uyu khalyofye.” ");
INSERT INTO zgam_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Po uPetro bu vasukhya vakhanda, “Lazima tumwedekhe Unguluve sio avanu. ");
INSERT INTO zgam_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Unguluve va dada veto akhanchosinche uYeesu, uyumukhabudile, nukhumbekha khukyanya khu bekhe. ");
INSERT INTO zgam_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Unguluve akhaginga khokhevokho kya mwene khyakhege, nukhumbakha ukhuva Imbakha vagombonchi, ikhomya ulyeyisyo khoisilaele nolosikhelo lya mbivi.” ");
INSERT INTO zgam_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ufye tulevashahidi va mambo aga, nu Mepo Umbalan'che, yuywa Unguluve akhominche khovavo vikhomwedekha.” ");
INSERT INTO zgam_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Avajumbe va balasa vovapolekhe evo, vakhibatiwa ne lyoyo vakhanogwa ukhuva buda avasukhya. ");
INSERT INTO zgam_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ufalisayo uyelangiwe Gamalieli, umanyesi va lulagelo, uyikhweshimiwa na vanu voni akhema nukhuvavola avasukhya vatoliwe khonji khusekhe idebe. ");
INSERT INTO zgam_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Akha vavola, “Avagosi va Isilaeli, muvinchage makini nekhenu ukheyakheva mukhovavombela ava. ");
INSERT INTO zgam_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ulyakhova, khate sana, uTheuda akhinu kha nukhyedai ukhuva munu imbakha neidadi ya vanu vakhakonga, vakhale mia nne valekhokanga. Akhabuda, na vanu vavo valekhomwedekha vakhasambalate kha vakhayaga. ");
INSERT INTO zgam_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Puu munu uyu, uYuda mgalilaya, akhema esikhu yela yakhosimbiwa esensa, akhakwega avanu vingi khusana. Na vope vakhayaga navoni avakhakongaga vakhayaga. ");
INSERT INTO zgam_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nalola nikhuvavola, mweyeposye na vanu ava muvalekhe vene, ulyakhova kama upango ugu au embombo ege yavanu yitagiwa. ");
INSERT INTO zgam_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kama ya Ngolove, samukhawesye ukhuvabencha, muwesye muvone msindana nu Nguluve.” Ewo, vakhedekha na mamenyu ga mwene. ");
INSERT INTO zgam_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Po vakhavelanga avasukhya igati nukhuvatova nukhuvavola vasite ukhunchova ilitawa lya Yeesu, vakhavalekha valutage. ");
INSERT INTO zgam_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Vakhakhega khovolongolo kholi balasa vakhowikhe ulyakhova vakhesabilwe nu khunogiwa nukhutesekha nukhuginiwa khuli Litawa elyo. ");
INSERT INTO zgam_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kho evo, khela sikhu, igati mtembile na enyumba khadi enyumba vakhendelela ukhumanyesya no khulumbelela uYeesu ukhuta ve Mesia. ");
INSERT INTO zgam_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Leno isikhu inchi, eidadi ya vasiole vikhongesekha, elilalamekho lya Vayakhudi na Kiyunani vakhategwile ipakha Avaeblania, ulyakhova ugovo vavene vale kosamiwe vovigava ugovo gwa khya kholya. ");
INSERT INTO zgam_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Avasukhya kumi na mbili vakhavelanga khulikusanyekho lyoni lya vasiule nukhunchova, “Sio ulyeli khulyofye ukhulelekha ilimenyu lya Ngolove ukhudumela emesa. ");
INSERT INTO zgam_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Po, valokolo, nchagula, avagosi saba, ukhuhuma khulyumwe, avana avanonu, avadegile, enumbula nekhekima vavatuwesya ukhuvalekhela embombo eye. ");
INSERT INTO zgam_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nayofye, tukhendelelaga dama ukhudova nakhombombo ya limwenyu.” ");
INSERT INTO zgam_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ekhitabu yavene yekhanogela pakutano guvoni. Apo, vakhanchagola uSitefano, umunu uyudegile ulyedeho nu Mepo Umbalanche, nu Filipo, Prokoro, Nikanori, Timoni, Parmena, na Nikolao, utakatifu ukhuhuma kho Antiokia. ");
INSERT INTO zgam_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Avaumini vakhava twala avanu ava khuvolongolo khuvasukhya, vakhodova pongela vakhavavekhela amavokho gavo. ");
INSERT INTO zgam_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ewo, elimenyu lya Ngolove lekheneile; eidadi ya vasiole yekhongesekha ukhya khu Yelusalemu; eidadi embakha ya vatekheji vakha yedekhe eimani. ");
INSERT INTO zgam_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","No Sitefano, uyadegile ulyedekho ni ngofu, alenkovomba amaajabu ne ishara imbakha khuvanu. ");
INSERT INTO zgam_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Po apo lekhinokha avanu avange avafuasi va sinagogi likhyelangiwa Sinagogi lya Mahuru, elya Wakirene nelya Waeskandelaa, na vange ukhuhuma khu Kilikia na khu Asia. Avanu ava valen'kovonchana nu Sitefano. ");
INSERT INTO zgam_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Po, savakhawesye ukhusinda nekhekima yo Mepo yeyo akhalenayo uSitefano ayekohumela ukhunchova. ");
INSERT INTO zgam_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Po vakhasonga avange avanu khu vutitu ukhuta “Tupolikhe uSitefano inchova amamenyu gakufulu zaidi ya Musa na zaidi ya Ngolove.” ");
INSERT INTO zgam_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Vakhavatesya avanu, avasekhe, navasimbi, nukhundutela uSitefano, vakhamwibata, nukhutwala khuvulongolo khulibalasa. ");
INSERT INTO zgam_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","vakhavaleta avasakhidi va vodesi, vavovakhanchovile, “umunu uya sibekhela ukhunchova amamenyu amavivi zaidi ya lieneo ele elitakatifu lya lulagelo. ");
INSERT INTO zgam_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Mbona tupolikhe voichova ukhuta uYeesu va Nazaleti ikhopananga aponu apa nukhubadelesya(mila) destuli inchatupile uMusa.” ");
INSERT INTO zgam_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Khila yomo uyakhale ndibalasa, vakhalola amikha gavo khya Sitefano, navope vakhavovona khumikho khya mwene vuvile kama vouso wa sukhwa(malaika). ");
INSERT INTO zgam_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Utekhen'chi umbaha akhachova imbombo in'chin'cha leli”? ");
INSERT INTO zgam_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","U Sitefano akhan'chova akhata, “Valukolo lwango numwe va baba vango, mumulehen'che une: Unguluve va vudwadwa an'gulume ubaba vito u Abrahamu walipa Masopotamia, vabadu satamile khu Halani,' ");
INSERT INTO zgam_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","uhege mukilunga kyakho navalukololo ulutage khukhilunga eikhi ya khiva mkhokhovonesya'. ");
INSERT INTO zgam_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Puu akhahege mukilunga kya Ukaludayo alukhutama khu Halani, ukhuhuma apo, ubaba va mwene vu afuile, Unguluve akhandeta mukhilunga eikhii eikhi vitama lino. ");
INSERT INTO zgam_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Sakhampa khinu nduvu hale wa mwene, sapale nei nafasi ei ya khuvikha amalunde. Pakhuva uAbrahamu avuliwee vubadu sapatile umwana ukhuta ipata ikhulunga ukhuva vahale wa mwene na vana va mwene. ");
INSERT INTO zgam_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Unguluve akhan'chova nave akhata avaholiwa va mwene vakhali vatamaga eikhulunga kya vageni, nukhuta avaholiwa va ukhu vikhu vavikha ukhuva vatumwa nukhuvavombela fivi usikhe gwa miakha ei mia nne. ");
INSERT INTO zgam_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nu Nguluve akhata nihega ikhilunga eikhi yakhuva khikhuvavikha vatumwa, pakhuva vihega nukhuiei saya uluvalu ulu.' ");
INSERT INTO zgam_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Puu akhampa uAbrahamu ulwidehano nukhukeketa, uAbrahamu akhava baba va Esikaka akha nkenketa ei lichuva lya nane; u Esikaka akhava baba va Yakovo, nu Yakovo akhava baba va vakukhu vito khechigo na vavili. ");
INSERT INTO zgam_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Avakukhu yetu vakhamboneha uwifu uYusufu vakhagucha khu Misili, nu Nguluve akhava paninee nave, ");
INSERT INTO zgam_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","akhanpokha pa tabu(sida) ya mwene akhampa nuluhala pamiho ga Falao unbaha vakhu Misili. U Falao akhambekha akhava imbaha vava Misili nei nyumba ya mwene yoni. ");
INSERT INTO zgam_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Pu khukhava nee njala ei mbaha nee tabu ei mbaha khu Misili na khu Kanani, nava baba veto savakhapata ukyakhulwa. ");
INSERT INTO zgam_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pu uYakobo vuapulikhe ukhuta khuli kyakhulwa khu Misili, akhavasuha ava baba veto ututan'chi. ");
INSERT INTO zgam_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ulwavile uYusufu akhivonesya khuva lukololwe eikhivumbukho kya Yusufu khikhamanyikha khwa Falao. ");
INSERT INTO zgam_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","U Yusufu akhavasuha avalukololwe ukhuluta khukhumbula uYakobo ubaba yevo in'che khu Misili, paninie navalukololwe, ekhikalo kya mwene vale avanu sabini na vahano. ");
INSERT INTO zgam_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","U Yakobo akhikhe khu Misili; akhafya paninwe nava baba yeto. ");
INSERT INTO zgam_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Vakhatoliwa khu Shekemu vakhasyiliwa mulipumba eilwu udada yavo uAbrahamu agulile nii hela n'cho khuhuma khuvana va Hamori ukhuu khu Shekemu. ");
INSERT INTO zgam_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Pa khasikhiei akha Unguluve aedihine nu Abrahamu vu ahegelile pa vanu, valikhwongelela khu Misili, ");
INSERT INTO zgam_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","usikhiei ugwa akhima undogon'chi uyunge khuu Misili, undogon'chi uvisa manyile uYusufu. ");
INSERT INTO zgam_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Undogon'chi uyunge uywa akhavasiova avanu vito nukhuvavombela imbivi avadada yeto, nukhuvataga avana vavene avadebe valekhe ukhutama. ");
INSERT INTO zgam_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Khu sikhei ugwa uMose akhaholiwa; ale nonu pamiho ga Nguluve, akhaleliwa eimin'chi gedatu munyumba yadadaye. ");
INSERT INTO zgam_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Usikhei uguatagine ung'echa vakhwa Falao akhatola akhagega nduu mwana va mwene. ");
INSERT INTO zgam_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","U Mose akhamanyeisiwa amafundisyo goni aga khu Misili; vu alina makha na mamenyu ni mbombo. ");
INSERT INTO zgam_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Vua fikhile eimiakha alubaini gakhamwin'chila amasage gakhu vagendele avalukololwe avanya Isilaeli. ");
INSERT INTO zgam_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Vuambwene Umwisilaeli ivomba imbivi, uMose akhakolela eikhisa nukhuhomben'cha uvuvivi khwaula uviukhutova uva khu Misili: ");
INSERT INTO zgam_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","akhasaga ukhuta avalukololwe vikhuvumanya ukhuta Unguluve ukhuvapokha mukhivokho kya mwene, pakhuva savamanye. ");
INSERT INTO zgam_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Eilin'chuya eilikongile akhaluta khuvanya Isilaeli avavatovanaga akhagela ukhuva sayaniwa; akhan'chova,' Vahego, Umue mulilokolo; mbona mwilwa yumwe khwa yumwe? ");
INSERT INTO zgam_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ula uvaakoseminche ula uvivale paninwe akhakulugila khuvutali, nukhun'chova, 'Veni akhuvikhile uvetavala nukhuva eing'igi veto? ");
INSERT INTO zgam_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Uve winogwa ukhumbuda nduvu kha mbudile uMisili pamuhe?” ");
INSERT INTO zgam_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","U Mose akhakimbila vuapulikhe in'cho; akhava eigeni mukhilunga kya Midiani, akhava baba va vana vavilei. ");
INSERT INTO zgam_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Vug'isilile ei mikha ulubaini usuhwa va Nguluve akhambonekhela mulukongu lwa kyamba kya Sinai, mukhiei situ mugati gukhwakha umwoto. ");
INSERT INTO zgam_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Vu uMose alolile umwoto alikhunyomokha nukhukenyemukha khu khila ikhiei ikhukhivona, pu alikhuhegelela alole, eisavuti ya Nguluve eikhin'cha eikhan'chova, ");
INSERT INTO zgam_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","'Une nene Nguluve va baba vakho, Nguluve va Abrahamu, uIsakha, nu Yakobo'. U Mose alikhutetema nukhusita ukhulola. ");
INSERT INTO zgam_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Unguluve akhambula akhata, 'Fula ifilato apa upuwimile pavalan'che. ");
INSERT INTO zgam_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nelolile eisida ya vanu vango khu Misili; Nipulikhe ukhulamwa khwa vene, numwe mkhilenei vapolikhe; lino win'che, nikhukhusuha uve khu Misili.' ");
INSERT INTO zgam_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Uyu uMose uvaabelile ukhuta veni akhuvikhile uve imbaha nukhuva indamun'chi veto?'_ viuyu Unguluve ambikhile ukhuva imbaha nuvuvupoli. Unguluve akhasuha khukhivokho kya suhwa uviang'umile uMose pakhisitu. ");
INSERT INTO zgam_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","U Mose akhavalongon'cha ukhuhuma khu Misili vu avombile ifiswigo vya khuswiga khu Misili na munyanja ya Shamu, na katika jangwa mukhasikhikha miakha alubaini. ");
INSERT INTO zgam_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","U Mose viuyu avavuule avanu va Isilaeli ukhuta, 'Unguluve ukhuve mikhila undogon'chi uyonge ukhuhuma mukhivumbukho kyenyo, undongon'chi ndune'. ");
INSERT INTO zgam_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Uyu vei munu uviale pa khipuga nusuhwa mulukongu uvianchovile nave pa kyamba kya Sinai. Huyu ndiye mtu ambaye alikuwa na baba zetu, huyu ni mtu ambaye alipokea neno lililo hai na kutupatia sisi. ");
INSERT INTO zgam_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Uyu vi munu uvi ale na vababa vito vabelile ukhumwedikha; vakhakulugila khuvutali, munumbula n'cha vene vakhasyetukhila khu Misili. ");
INSERT INTO zgam_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Pu usikhi ugwa vakhambula uHaluni.'ukhuta ututengenesehen'che ei minguluve egywa khutulongon'cha. U Mose, uviakhatulongon'chaga khu Misili, satumanyile n'chi n'chi mbwene.' ");
INSERT INTO zgam_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Vakhatengenesya eisenga isikhu in'cho puvakhahumya ne sadakha khuusenga iyo vakhahovoka pa mbombo n'cha mavokho gavene. ");
INSERT INTO zgam_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Unguluve akhapindula akhavapa inondwa n'cha khukhianya, nduvulisimbiwe mkhitabu kya vanyamalago, 'Ye Mungumehin'che une einekhelo ya senga einchimuhinjile ndukungu musikhi ugwa myakha ulubaini, munyumba ya Isilaeli? ");
INSERT INTO zgam_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mweidikhe munyumba ya kwaganila nu Moleki ni nondwe n'cha minguluve gwa refani, nifihwani ifi mutengenisye nukhuisaya khu fiene: nikhuvahilekha khuvutali saidi yakhu Babeli.' ");
INSERT INTO zgam_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Avababa yito vale ni nyumba yakhwaganila mundukungu, nduvu Unguluve avavulile avile an'chovile nu Mose, ukhuta akhale in'chega ndeikhihwani khila eikhi mukhakhiwene. ");
INSERT INTO zgam_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Eiye yu nyumba uvu avababa vagegiwe nu Yosua. Eiye yahumile usikhi ugu vaingile khutavala khuvanu vavo Unguluve avasweimile vubadu avadada yeito. Eye yale ewo mupakha akhasikhe kha Davudi, ");
INSERT INTO zgam_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","uyu vii akhavile uluhusa khumiho ga Nguluve akhadova khwa Nguluve uva Yakovo. ");
INSERT INTO zgam_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","U Selemani akhan'chengela enyumba ya Nguluve. ");
INSERT INTO zgam_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pakhuva uvialikhukianya sitama inyumba n'chi van'chengile namavokho; eye vinduvu an'chovile unyamalago, ");
INSERT INTO zgam_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Khukyanya khigoda kyango kya vutwa, ne khilunga luvafu lwa khukanya amalunde gango. Nyumba yilindakhikhii eiyakhiva mukhunjengela?, in'chova Ubaba: ndapi apa khugatalukha? ");
INSERT INTO zgam_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Mavokho gango agavombile ifi vyoni?' ");
INSERT INTO zgam_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Umwe mwei vanu mwiei vanya singo ng'afu umwei samnon'chiche inumbula nii mbulukhutu, kila misikhi mukhubela Umepo Umbalan'che,' mvomba nduvu vakha vombaga ava dada yenyo. ");
INSERT INTO zgam_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nyamalago veni uviava dada yenyo sivatesin'che? Vavabudile avanyamalago va badu sin'chile Umwene unya Leli,'na lino muvile vachova fivi nuvubudi khumwene, ");
INSERT INTO zgam_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","umwe mwei vanu umwei mupokhile indagilo in'chilagililwe nusuhwa samukhun'chibata.” ");
INSERT INTO zgam_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Puu avavaha va balasa vuvapulikhe imbombo in'chi n'chiikhavahoma inumbula n'cha vene vakhagwegwedulila amino uSitefani. ");
INSERT INTO zgam_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pakhuva umwene adigile Umepo Umbalan'che alolile khukianya vunonu nukhuvuvona uvu dwadwa wa Nguluve,' nukhumbona uYesu eimile eikhivokho ei kyandwo eikya Nguluve. ");
INSERT INTO zgam_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","U Sitefani akhan'chova, “Niluwene uludeva ludindwikhe, nu Mwana va Nguluve eimile eikhivokho kyandwo kya Nguluve.” ");
INSERT INTO zgam_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Puu avavaha va ndagilo vakhaywega nukhudinda imbulukhutu vakhanyalila pupaninie, ");
INSERT INTO zgam_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","vakhan'taga khunji nukhutova na mawe: navasaidi vakhafula eimienda gwa vene eigwa khunji vakhavikha pasi pamalonde ga Savuli. ");
INSERT INTO zgam_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Vuvitova na mawe khuva Sitefani, akhendelela ukhwiimwilanga Udaada nukhun'chova, “Uvii vi Yesu, upila ei numbula yango,”. ");
INSERT INTO zgam_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Akhafugama nukhwilanga khu savuti eimbaha, “Baaba, usite ukhuvavalilei inongwa eiyee. “Vu an'chovile n'chi, akhafywa. ");
INSERT INTO zgam_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","U Savuli ale pamidihano nuuvuufye wa mwene. eisikhu eyo pu akhanja ukhuvatesya nduvusayiliwo eitembile ya khu Yelusalemu; navakilisiti voni avava yaganikhe mumajimbo ga Yudea nakhu Samalia, isipokuwa mitume. ");
INSERT INTO zgam_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Puu avanu mwidikhe Unguluve vakhasila uSitefani nukhundilila ikhililo ikhivaha. ");
INSERT INTO zgam_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","U Savuli anangila pavaha eitembile einyumba nei nyumba nukhuvatesya avadala na vagosi, nukhuvakunga mujiela. ");
INSERT INTO zgam_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pu avakilisiti avavakha yaganikhe vakhendelela ukhulumbilila eilimenyu. ");
INSERT INTO zgam_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","U Filipo akhikha khu Samalia nukhunchova eilimenyu lya Yesu ukhwa. ");
INSERT INTO zgam_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Puu ululundamano vululolile nukhupulikha ifihwani ifi avombile uFilipo vakhavikha mug'ati munumbula eikhi anchovile. ");
INSERT INTO zgam_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ukhuhuma apo avanu vingi avavapulikhe, eimepu imbivi in'chi humile khuvanu ukhwa vakhalila fin'cho navingi avavalemilwe navalema vakhapona. ");
INSERT INTO zgam_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Puuu khwale nuluhekhelo uluvaha mu mitava. ");
INSERT INTO zgam_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pu alipo umunu yumo mutava ugwa eilitawa vei Simoni, yuywa avombaga fincho uvuhavi; uvu avasigenchaga fincho avanu vakhu Samalia, vuita umwene munu inonu fincho. ");
INSERT INTO zgam_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Avasamalia voni avavaha navadebe, vakhapilehin'cha; nukhuta;”umunu uyuu gumakha ga Nguluve amavaha.” ");
INSERT INTO zgam_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Vakhapulehin'cha, pakhuva avaswiginche usikhi untali nuvuhaviwa mwene. ");
INSERT INTO zgam_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Vuvapulikhi uFilipo alumbilile in'cha ludeva lwa khukianya ulwa Nguluve vakhedikha nukhwon'chiwa, avadala navagosi. ");
INSERT INTO zgam_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Nu Simoni vope akhidikha vuon'chiwe akhava panin'wee nu Filipo; vualolile ifiswigo ifivombekha. ");
INSERT INTO zgam_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Pu avasuhiwa va khu Yelusalemu vuvapulikhe ukhuta khu Samalia vupelile elimenyu lya Nguluve, vakhavasuha uPeteli na Yohani. ");
INSERT INTO zgam_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Vuvikhwikha vakhavadovela ukhuta vapokhele Umepo Umbalanc'he. ");
INSERT INTO zgam_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Khu sikhi ugwa, Umepo Umbalan'che akhava badu savikhile ete yumo; va on'chiwe khulitawa lya Bwana Yesu. ");
INSERT INTO zgam_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pu uPeteli nu Yohani vakhavavikhila amavokho, vope puvakhapokhela Umepo Umbalan'che. ");
INSERT INTO zgam_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Vu uSimoni alolile Umepo ahumile ukhugendela amavokho navasuhiwa; akhanogwa ukhuvapa ehela, ");
INSERT INTO zgam_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Akhata, “Mume nayune amakha, vunivikha amavokho khu khila munu upililage Umepo Umbalan'che.” ");
INSERT INTO zgam_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","U Peteli akhambula akhata; indalama n'chakho paninwe nuve fiyage khuvutali, pakhuva utile eikhikungilwa kya Nguluve khivonekha ni ndalama. ");
INSERT INTO zgam_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ulin'chila luvafu ne mbombo eiyee pakhuva einumbula yakho sayile vononu pamiho ga Nguluve. ");
INSERT INTO zgam_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Pu yinogiwa upile inongwa n'chakho nukhudova Unguluve pamo ukhukhusyikhila inongwa ncha numbula yakho. ");
INSERT INTO zgam_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Pakhuva nivona ulie mugati muluvipo lwa vutulanongwa.” ");
INSERT INTO zgam_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","U Simoni akhanchova akhata, “Mudove Unguluve khujili yango, pakhuva imbombo nchoni inchimunchovile n'chiwesya ukhuhumila. ");
INSERT INTO zgam_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Puu uPeteli nu Yohani vuvalumbilile eilimenyu lya Nguluve, vakhavuya khu Yelusalemu khu njila eyo; valumbilile eilemenyu mu fijiji vingi ifya Samaria. ");
INSERT INTO zgam_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Puu usuhwa va Nguluve akhanchova nu Filipo na kusema, “Ulole khusikha einjila ya pasi ya khu Yelusalemu ukhuluta Gaza.” (Einjila eiye yelindukungu). ");
INSERT INTO zgam_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Akhalola nukhuluta. Lola, pakhava nu munu vakhu Ethiopia, utowasi unyavulamun'chi uvuvaha pasi pa kandase; umbaha pakhianya pakhibana kya mwene kyoni; vope alutile khu Yelusalemu khukhwisaya. ");
INSERT INTO zgam_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Alikhuvuyatamile mumutukha ya mwene ukhwemba eilivangili kya Isaya. ");
INSERT INTO zgam_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Umepo akhanchova nu Filipo, “Hegelela pa mutukha eiyee ulutagenayo. ");
INSERT INTO zgam_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","“U Filipo akhanyila uluvilo, akhambona ukhwemba elivangile khwa Isaya; akhata, Ukhimanyile eikhivukhwimba?” ");
INSERT INTO zgam_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Umwethiopia akhata, “nialesya ndakhekhi umunu vusandongwin'che?” Akhadovo uFilipo eipakhile eimutukha atame paninwe nu mwene. ");
INSERT INTO zgam_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Lino elivangili uli ukhimbaga Mwethiopia lwu ile; alongon'chiwe ndei ng'osi ukhuluta khuhenjiwa; ndei ng'osi eiyin'chige myee; na kama kondoo alinyamaza kimya, sayidendiwe undomo: ");
INSERT INTO zgam_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Palususuvalo lwa mwene uvuhigi wa mwene vukhahega: Veni alen'chova ikhivumbukho kya mwene? Uvutamo wa mwene vahegile mukhilunga.” ");
INSERT INTO zgam_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Puu utowashi akhambun'cha uFilipo, akhata, “nidova, veni unyamalago uviinchova imbombo n'cha mwene, ewo n'cha munu uyunge”? ");
INSERT INTO zgam_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","U Filipo akhanja ukhunchova eikhulongwi ya limenyu lya khwa Isayi ukhulumbilila eilimenyu lya Yesu. ");
INSERT INTO zgam_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Vuvali munjila, vakhafikha pamagasi,' utowashi akhata, “Apapali namagasi khekhi khikhusiga nesite ukhuonchiwa?, ");
INSERT INTO zgam_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","amamenyu aga, “Uumwethiopia gakhakola “akhata nedikhe ukhuta uYesu Kristi Mwana va Nguluve,” aga gasimuli mulivangile ilitan'chi). Pu Umwethiopia akhimikha ei mutukha. ");
INSERT INTO zgam_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Vakhaluta pamagasi nu Filipo nu towasi, uFilipo akhamwon'cha. ");
INSERT INTO zgam_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Vuvahumile mumagasi, Umepo va Nguluve akhang'ilekha khuvutali uFilipo; utowasi sakhambona akhagenda einjila ya mwene nuluhekhelo. ");
INSERT INTO zgam_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pu uFilipo akhahumila khuu Azoto. Akhagenda mukhilunga khila nu khulumbilila eilimenyu mu fijiji vyoni akhafikha khu Kaisaria. ");
INSERT INTO zgam_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Puu uSavuli, akhendelela ukhunchova nuvukali uwawufye khuvakongi va Yesu, akhaluta khu tekhen'chi umbaha ");
INSERT INTO zgam_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nu khudova eikalata khuajili ya masinagogi ukhu khu Demesiki, pu ukhuta angambone umunu avedala, ave gosi avapinye nukhuvagega khu Yelusalemu. ");
INSERT INTO zgam_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Hata vu igenda alipa khufikha khuu Damesitiki lukhambona ulumuli ukhuhuma khukianya,' ");
INSERT INTO zgam_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","pu akhagwa pasi nukhupulikha einyilango eiyita,”Savuli, Savuli, khekhi vukhung'alan'cha?” ");
INSERT INTO zgam_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","U Savuli akhata, Veve veni Dada? Pu uDaada akhanchova, “Nene Yeisu yune vukhung'alancha; ");
INSERT INTO zgam_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Pu lino ema, ulutage khujini, nuve vuviliwa eikyakhuvomba ");
INSERT INTO zgam_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Puu avanu vala avuvale paninwe nave nu Savuli vakhan'chiga myee nukhupulihen'cha ei savuti, nukhusita khumbona munu. ");
INSERT INTO zgam_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Puu uSavuli akhima ukhuhuma pasi vuandendwile amiho sakhakhivona khinu, vakhamwibata eikhivokho vakhagega eikhivokho vakhagega khu Damesitiki. ");
INSERT INTO zgam_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ifigono vidatu silya na khukhunywa. ");
INSERT INTO zgam_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Puu alepwale ukongi yumo khu Damesitiki eilitawa vii Ananiya, Unguluve anchovile nave munyivonelo(munjosi), “Ananiya.” Akhata, “Tazama, nili apa, Baba. ");
INSERT INTO zgam_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","“Unguluve akhambula akhata eima ulutage mutava ugugwikhilangiwa ugolofu munyumba ya Yuda ukhavun'che umunu uve ahumile khu Tarso eilitawa vei Savuli; manyabadu ipidova; ");
INSERT INTO zgam_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ambwene munyivonelo umunu uvivivta Ananiya akhingila nukhumbikhila amavokho akave ukhulola. ");
INSERT INTO zgam_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","U Ananiya akhata, “Daada, nepulikhe inogwa nyingi in'cha munu uyu in'chi avombile imbivi khuvavalan'che va Nguluve avakhu Yelusalemu; ");
INSERT INTO zgam_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Apa alenululagilo ukhuhuma khutekhen'chi umbaha ukhumwibata khila munu uviinchova eilitawa lya Yesu. ");
INSERT INTO zgam_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Puu Unguluve akhambula, “Akhata lutaga khila kyombo khihaliwa khuliune, alitole elitawa lyangu khu Vanyapanji na vatwa na vana vanya Isilaeli. ");
INSERT INTO zgam_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Manya nikhuvavonesya inyingi in'chi khumbona nukhutesekha khulitawa lyango”. ");
INSERT INTO zgam_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","U Ananiya akhaluta, akhingila munyumba; Akhambikhila amavokho akhata, Lukololwango Savuli, U Yesu, ula uviakhuhumile khunjila yila eiyukhagendaga vii uyu asuhile ukhave ukhulotu khavili indin'chiwe Umepo Umbalan'che. ");
INSERT INTO zgam_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Puu vikhagwa ifinu ukhuhuma mumiho ndamaganda, akhanja ukhulola, akhima akhon'chiwa akhalya eikyakyulya akhakava amakha. ");
INSERT INTO zgam_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Akhatama paninwe navakongi isikhu nchunyingi khu Damesitiki. ");
INSERT INTO zgam_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Uusikhi ugwa alikhun'chova uYesu mumasinagogi, ukhuta uYesu Mwana va Nguluve. ");
INSERT INTO zgam_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Na voni avava pulikhe valikhuswiga nukhun'chova, “Umunu uyu sii ula uve akhava nangile avanu avakhalin'chovaga eili Tawa eili khu Yelusalemu? Napa akhinchile khunjila ya khuvakunga nukhuva heilikha khuvatekhen'chi.” ");
INSERT INTO zgam_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Puu uSavuli atangiliwe nukhukava amakha nukhulumbilila nukhuvavikha Avayahudi avavatamaga khu Damesitiki van'changa nyikhiwe nukhuta uyu vii Yesu Kelisiti. ");
INSERT INTO zgam_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Vuu usikhi gulutile, Avayahudi vakhavomba eilivuto lya paninie vambude. ");
INSERT INTO zgam_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Puu eli vuto lya paninie vambude. Puu elivuto lya vene likhavonekha nu Savuli. Vakhagonela pakilo na pamusi vakave ukhumbuda. ");
INSERT INTO zgam_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Puu avakongi va mwene vakhantola pakilo vakhamwisya mu huimato pasi mukheikapo. ");
INSERT INTO zgam_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nu Savuli vuafikhe khu Yelusalemu, akhagela ukwii lungana vakongi lakhini valukhudwada savalukhukela ukhuta vape ikongi. ");
INSERT INTO zgam_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Puu uBarnaba akhantola akhang'ulikha khu vasuhwa akhavavuli umuambonile uYesu munjila nu Yesu vuan'chovile nave, nuvu uSavuli alumbilile na makha eilitawa lya Yesu khu Damesitiki. ");
INSERT INTO zgam_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","aagine navo vuvingile nukhuhuma khu Yelusalemu. Akhan'chova nuvukifu khu litawa lya Yesu Kelisite, ");
INSERT INTO zgam_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","akhavun'chana na Vayahudi ava Khiyunani kila misikhe valikhulonda ukhubuda. ");
INSERT INTO zgam_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Vu avalokololwe valumanyile eimbombo eye vakhantole mpakha khuu Kaisaria, vang'ilekhe atutage khu Tarso. ");
INSERT INTO zgam_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Puu eitembile yoni vakhu Yahudi, Galilaya nakhu Samariya, yale nulunon'chehe yikhan'chengiwa nukhugenda mumbwa yilweli ura Nguluve nulunon'chehen'cho lwa Mepo Umbalan'che, eitembileyikha kula nu k'yongelela eimbalilo. ");
INSERT INTO zgam_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pu yikhahumila uPeteli vu in'chungula khunu na khunu mu mikoa, akhavagendela avakilesite ava vitama Lida. ");
INSERT INTO zgam_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Akhambona ukywa umunu vii eilitawa vii Ainea, umunu uyura atamile mukhihaga eimikha nane; manya ale ndemale. ");
INSERT INTO zgam_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","U Peteli akhambula akhata, “Ainea, uYesu Kilesiti akhuponwe; Sisimukha utandikhe eikhihaga kyakho, “Pu akhasisimukha. ");
INSERT INTO zgam_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Pu avanu vani avakhatamaga khu Lida nu Sharoni vuva mbwene umunu uywa, vakhapindukhila Unguluve. ");
INSERT INTO zgam_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Puu alikho ukongi khu Yafa uvii khwilangiwa Tabita, eilelefasiliwa ukhuta “Dorcas” Udala uyu adigile imbombo inanu nulusikhilo uluavombaga khuvalemale khuvagan'chu. ");
INSERT INTO zgam_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Yahumile usikhi gumo akhatamwa akhafya; vuva mwon'chinche vakhambikha khukhianya khu golofywa vakhagonwa. ");
INSERT INTO zgam_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Pakhuva eLida yale pipi ne Yafa, navakongi vuva pulikhe ukhuta uPeteli ali ukhu vakhavasuha avanu vavile khumwene, vadove alute khuvene khimbive”. ");
INSERT INTO zgam_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","U Peteli akhasisimukha nukhuga paninie navo vuafikhe vakhagega khukhiyumba kya khukianya. Nava fyile vono vakhima paninie nu mwene vakhalila nukhumbonesya amakoti ne mienda eigi akhavapinchaga Dorcas avahonele vualipaninie navo. ");
INSERT INTO zgam_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","U Peteli akhava humya voni khunji khukhiyumba, akhafugama akhisaya, akhagusetukhila umbile, akhata, “Tabita, sisimukha”. Akhadendula amiho vuambwene uPeteli akhatama pasi. ");
INSERT INTO zgam_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Puu uPeteli akhampa eikhivokho akhamwinula, vuavilangile avedikhi nave fuele akhavapa akhava mwumi ");
INSERT INTO zgam_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ee lijambo eili likhavonekha khu Yafa yoni, na vanu vingi vakhakonga Unguluve. ");
INSERT INTO zgam_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pu yikhahumila uPeteli akhatama isikhu n'chunyingi khu Yafa paninie nu munu uve vita vi Simoni, uviihona ingwembe. ");
INSERT INTO zgam_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Khwale nu munu yumo mutava gwa Kaisalia, eilitawa Kornelio, alie imbaha va khipuga kya Khiitalia. ");
INSERT INTO zgam_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ale munu va Nguluve nukhukonga Unguluve nee nyumba ya mwene yoni; ahumin'che ihela n'chuu nyingi nukhudova Unguluve eemishe gwioini. ");
INSERT INTO zgam_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Usikhei gwa saa tisa pamusi, akhalola einyeivonelo usuhwa va Nguluve ukhwin'cha khu mwene. Usuhwa akhambula “Kolinelio! ");
INSERT INTO zgam_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","U Kolinelio akhandola usuhwa ale nuludwan'chi uvuvaha akhan'chova “Eekhei khekhi imbaha?” Usuhwa akhambula akhata “Eiisayo n'chakho ni sawadi n'chakho khuvagan'chun'chiitogile khukianya ndulukumbuhinchoo khumiho ga Nguluve”. ");
INSERT INTO zgam_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Lino suha avanu ukhuluta khu Yafa ukhugega umunu yumo uviikhwilangiwa ve Simoni eilenge vii Peteli. ");
INSERT INTO zgam_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Itama nukhuhona ingwembe uviikhwilangiwa vei Simoni einyumba ya mwene yilikhulukanji khunyanja.” ");
INSERT INTO zgam_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Vuu usuhwa uviakhan'cho vaganave ukhuhega, uKolinelio akhavilaga avavombi va mwene vavili, nu sikhali uvii uyu ali khumwidikha Unguluve pagati pa vasikhali avakhambombelaga. ");
INSERT INTO zgam_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","U Kolinelio akhavavula n'choni einchihumile nukhuvasuha khu Yafa. ");
INSERT INTO zgam_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ee sikhu eiyekongile usekhe gwa pamusi(pa saa sita) vuvale munjila valipakhufikha khujini, uPeteli akhatoga khukianya khudali khudova. (khukhisaya). ");
INSERT INTO zgam_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ale nei njala alondaga ei khinu kya khulya, vuavanu vitelekha eikyakhulya avone siule einyivonelo, ");
INSERT INTO zgam_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","akhavona khukianya khudendwikhe, nekyombo khikhwikha ndu mulenda mbaha gukhwikha pasi pakhilunga ingutu n'choni n'chuline. ");
INSERT INTO zgam_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mugati mukyene mulale ni fikanu vyoni ifinya malune gane, haitigenda pasi nifinyela khukianya. ");
INSERT INTO zgam_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nee savuti yekhan'chova khumwene, “Sisimukha, Petro uhenje ulye.” ");
INSERT INTO zgam_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pu u Perto akhata, “Ate, Bwana sanigelile ukhulya eikhinu khukhoni eekhi vivi neikhin'chafu. ");
INSERT INTO zgam_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Pu eisavuti yekhin'cha khumwene mala ya vile “Eikyasayile Unguluve usite ukhuta khivivi nu vun'chafu.” ");
INSERT INTO zgam_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Eiye yekha humile mala khadatu, eikvombo khila khikha toliwa khavile khu kianya. ");
INSERT INTO zgam_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nu Petro ale musikhe gwa khwihanjile hanwaa pa nyivonelo n'chivonesya khekhi, pu avanu vakhava vasuhiwe nu Kornelio vakhima khu vulongolo khundiango, vakhavun'cha einjila ya khuluta khunyumba. ");
INSERT INTO zgam_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Vakhilanga nukhuvun'cha ukhuta ndavi Simoni uviikhwelangwile Peteli akhatamaga pala. ");
INSERT INTO zgam_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Usikhe ugwa u Peteli vuisaga pa nyevonelo, Umepo akhachova nave, “Lola avanu vadatu vikhukhulonda. ");
INSERT INTO zgam_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Sisimukha wikhe pasi ulutage navo. Usite ukhudwada ukhuluta navo, pakhuva nevasuhile.” ");
INSERT INTO zgam_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","U Peteli akhikha pasi nukhunchova navo une nene mukhundonda khekhi mwin'chile?” ");
INSERT INTO zgam_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Umbaha yumo eilitawa vi Kornelio, umunu vavu yelweli inogwa ukhumwimikha Unguluve, na vanu vikhun'chova vunonu ikhilunga kyoni eikyakiyahudi, avali ule nusuhwa va Nguluve ukhunyumba ya mwene, pu apuliheonchi eikhulonguva ukhuhuma khuliuve.” ");
INSERT INTO zgam_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","U Peteli akha vakalibisya ukhwingela mugati nukhutama paninie nave. Vukhilu akhasisi mukha alukhuheta paninie na valukololule vadebe ukhuhuma khu Yafa vakhalongo n'chana nave. ");
INSERT INTO zgam_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Eisikhu ei yekongile vakhin'cha khu Kaisaria. Nu Kornelio alikhu vagulila; pu avei langile avalukololwe navamanyani vamwene avalipipi. ");
INSERT INTO zgam_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Usikhei u Peteli ingile mugati u Kornelio akha kalibisya nukhwinama pasi pamalunde ga mwene nukhue muleimikha. ");
INSERT INTO zgam_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pu u Peteli akhamwinula nukhun'chova ukhuta nayune neilimu.” ");
INSERT INTO zgam_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","akhasikhe Upeteli ein'chova nave, akhaluta mungati akhavona avame vei vungani n'che pupanei. ");
INSERT INTO zgam_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Akhavavula yumwe mwei vene mulumanyile ukhuta indagilo n'cha khiei yahudi ukhwi vungani pu panei nukhugendelanila nu munu yuywa savakhikolo eikhi pakhuva u Nguluve ambonisye une ukhuta sani nogiwa ukhumwilanga umuntu vivoni ukhuta imbivi ewo ichafu. ");
INSERT INTO zgam_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kyvu ngave nin'chile khesita khuben'cha, vunei suhiwe khujili ya in'chi nevavun'che khekhi musuhiwe khuujili yango.” ");
INSERT INTO zgam_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ukornelio akhata, “Isikhu nne in'chilutile, usikhei ndugu nulikhwesaya usikhei gwa saa tisa pamusi mugati munyumba yango; Nikhavona umunu aimile afualile eimienda eimivalafu, ");
INSERT INTO zgam_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Akhambula “Kornelio inyesayo n'chakho n'chifikhe pamiho ga Nguluve, nei sawadi n'chakho khuva lemilwe nchivile vukumbuhincho khuvulongolo khwa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pu lino suha umunu khu Yafa akah mweilange umunu yumo eilitawa vei Simoni in'che khulive eilitawa eilengeve Peteli. uvei itama khung'ona Ngulembe yumo eilitawa vei Simoni einyumba ya mwene yeilekhulukanji khuu nyanja. ");
INSERT INTO zgam_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Zingatia: Mmstari huu, “Nu mwene veikhwincha in'chova numwe,” haumo kwenye maandiko ya kale. ");
INSERT INTO zgam_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","uPeteli akhadundula undomo gwa mwene nukhun'chova “Lweli, niedikhe ukhuta Unguluve in'chila vapendelelo. ");
INSERT INTO zgam_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ukhuva khila munu uviikhumwidikha nukhuvomba imbombo n'cha lweli ikhwiidekhiwa khumwene. ");
INSERT INTO zgam_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ulumanyile ukhuta ee khulongungwi yeihumile khuvanya Isilaeli, vuipulisya eilimenyu lya lunon'chehen'cho lwa Kilisiti uviuyu vii Daada va voni- ");
INSERT INTO zgam_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","yumwe mwevene mulumanyile eilele humile eilihumile khu Yudea yoni leitengulie khu Galilaya, palwon'cho ulu an'chovaga uYohani. ");
INSERT INTO zgam_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ee khulongwi yeilekhundonda uYesu Kelisiti uvi Unguluve abakhile umono khuunjila ya Mepo Umbalan'che na makha. Akhaluta akhavomba inonu nukhuponwa voni avatesiwe nu setano, pakhuva Unguluve ale panie nave. ");
INSERT INTO zgam_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ufye tulivasaidi vambombo n'choni inchi vombikhe khu khilunga kya khu Vuyahudi nakhu Yelusalemu- uyu vei Yesu uvivabudile nukhutulikha mubikhi. ");
INSERT INTO zgam_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Umunu uyu Unguluve an'chusin'che eisikhu ya datu nukhupa ukhumanyikha, ");
INSERT INTO zgam_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","syoo khuvanu voni khuvasaidi avahaliwe nu Nguluve. - yufye twiivene twaalile nave tukhanywa nave vusan'chukhile ukhuma khu vufye. ");
INSERT INTO zgam_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Atulagile ukhulumbilila khu vanu nukhusuhudila ukhuta uyu vi uyu Unguluve ang'alile vandamunchi vavumi navafuile. ");
INSERT INTO zgam_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ukhugendela umwene avasuhwa voni van'chova, khila munu uvei ukhwedikha ukhugendela umwene ipokhela uvusyekhilo wa mbivi ukhugendela eilitawa lya mwene.” ");
INSERT INTO zgam_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Vu uPeteli ikhwendelela ukhunchova n'chii, Umepo Umbalan'che akhadiga khuvoni avavapulihin'chaga eilimenyu lya mwene. ");
INSERT INTO zgam_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Avanu vala avihusikha neikhepuga kya viidikhi na vasaiule- vala voni avavin'chile nu Peteli- valikhuswiga pakhikungilwa kya Mepo Umbalan'che uviadudeliwe khu vanyapanji. ");
INSERT INTO zgam_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Pakhuva vapulikhe avanya panji ava vinchova einjovele eiyinge nukhu mwidikha Unguluve. U Peteli akhata(akhanchova), ");
INSERT INTO zgam_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Khuli munu vivnoni iwesya ukhusigila amagasi avanu vasite ukhwon'chiwa, Avanu ava vapokhile Umepo Umbalan'che ndufye?” ");
INSERT INTO zgam_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Puu akhavaluhusu vonchiwe khulitawa lya Yesu Kelisiti. Puvakhadova atame navo isikhu ndebe. ");
INSERT INTO zgam_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Avasuhwa na valukolo avavale khu Yudea vakhapulikha ukhuta avanyapanji vupilile eilimenyu lya Nguluve. ");
INSERT INTO zgam_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","U Peteli vu ein'chile ukhu khu Yelusalemu, eikhipuga kya vanu avagolofu vakhanja ukhuben'cha, Nukhun'chova, ");
INSERT INTO zgam_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Wibatine na vanu avasavagolofu nu khulya navo!” ");
INSERT INTO zgam_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pu uPeteli akhatengula ukhunchova eilihumile; akhata, ");
INSERT INTO zgam_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nele khweisaya mkhilunga kya khuu Yafa, nei khalolo einyevonelo mu kyombo fikhwikha pasi nduu mwenda umbaha ugugukhwikha ukhuhuma khu kianya ingutu n'choni a'chwine. Khikhwikha khuliune. ");
INSERT INTO zgam_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nikhalola nukhusaga pakianya pa kiene. Nei khavona ifikanu ifinyamalunde gane ifitama pasi pakhilunga nifikanu mwinyasi nifikanu itifi khwa fula ni fidege ifya khukianya. ");
INSERT INTO zgam_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nikha pulikha eisavuti yin'chova nune, “Sisimukha, Peteli, un'chinje ulye!” ");
INSERT INTO zgam_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nikhata, “Siyo ewo, Daada, mundomo gwango sakhingile eikhinu kyu kyoni eikhivivi neikhi n'chafu” ");
INSERT INTO zgam_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Pu eisavuti yekhan'chova ukhuhuma Khukianya, kheila Unguluve avalin'che savuwesya ukhuta kheivivi, ");
INSERT INTO zgam_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ei ye yakhahumile mala kha datu, khila khinu khekhatoliwa khu kianya khavili. ");
INSERT INTO zgam_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ukhulola, avanu vadatu vimile khuvulongolo khunyumba umutwale vasuhiwe ukhuma khu Kaisalia ukhwincha khuliune. ");
INSERT INTO zgam_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Umepo akhambula ukhuluta navo, neisite ukhukalan'chana navo. Ava gosi sita vakhaluta paninie nune lwalutile munyumba ya munu yumo. ");
INSERT INTO zgam_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Akhativula umwambonile usuhwa va Nguluve umu eimile munyumba ya mwene akhata(akhanchova), ““Nitume Yafa nisuhe khwa simoni uyu eilitawa eilenge vii Peteli. ");
INSERT INTO zgam_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Inchova eilimenyu khuliuve ei limunyu eilelikhukhupokha uvene nyumba yakhoyoni.” ");
INSERT INTO zgam_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Vunetangule ukhun'chova navyo, Umepo umbalan'che akhadega khuvene nduvu ainchile khuliufye khuvutengulilo. ");
INSERT INTO zgam_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nikhumbukha amamenyu ga Nguluve, agaan'chovile, “uYohani aonchaga na magasi, leno nkhwonchaga nu Mepo Umbalan'che.” ");
INSERT INTO zgam_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nduvu Unguluve ahumin'che eisawadi nduvu atupile ufye vatweidikhe mwa Kelisiti uYesu, une nene veni, niwesya ukhuben'cha Unguluve? ");
INSERT INTO zgam_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Vuvapulikha imbombo n'chi, savakhavuncha, vakhagimwa Unguluve nu khun'chova, “Unguluve ahumin'che uvusyikhila khuvanjapanji vope” ");
INSERT INTO zgam_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Puvakhidikhi eitabu eiyatengwile ukhuhuma khuvofye khwa Sitefani vayaganikhe ukhuhuma khu Yelusalemu- aveidikhi ava vakhaluta khutali, khuu Foinike, Kipro nakhu Antiokia. Vakhavavula eilimenyu lya Yesu mwene khuvayahudi nasyoo khu vanu avange vuvoni. ");
INSERT INTO zgam_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pa khuva avanu avange vahumile khu Kipro na khu Krene, vainchile khu Antiokia nukhun'chova navayunani nukhundumbilila uYesu. ");
INSERT INTO zgam_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nikhivokho kya Nguluve kyale paninie navene, na vanu vingi vakhedikha nukupindukhila Unguluve. ");
INSERT INTO zgam_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Imbombo n'cha vene n'chii khafikha mumbula khutun'cha tembile yakhu Yelusalemu: nukhusuha uBarnaba alute khu Antiokia. ");
INSERT INTO zgam_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Vu einchile nukhulola eikhikungilwa kya Nguluve akhahovokha nukhuvapa amakha voni ukhusigala nu Nguluve munumbula n'cha vene. ");
INSERT INTO zgam_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Pakhuva alie munu iinonu adin'chine Umepo Umbalan'che vakhongelela mwa Kilisti. ");
INSERT INTO zgam_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pongela uBarnaba akhatuta khu Tarso khukhombona uSavuli. ");
INSERT INTO zgam_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Vu ambwene akhagega khu Antiokia. Yikhava umwakha uguge vakhalundamana paninie nei tembile nukhuvamanyisya avanu vingi. Na vakongi vakhilangiwa vakelesiti avatan'chii khu Antiokia. ");
INSERT INTO zgam_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Pu isikhu in'cho avasuhwa vakhikha ukhuhuma khu Yelusalemu vakhafikha khu Antiokia. ");
INSERT INTO zgam_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Uninie yumo vi Agabo lyu litawa lya mwene, akhima nukhuvuliwa nu Mepo ukhuta khuiva ne njala eing'ala yihumila mukhilunga kyoni. Eiyei yihumila usikhe gwa Kraudio. ");
INSERT INTO zgam_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Pu khila ikongi yumo uvei anogile alamwile ukhumlekha uvutangili khuvalukolo lwe avalekhu Vuyahudi. ");
INSERT INTO zgam_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Vavombile ewe; Vakhahumya ihela khukhivokho kya Barnabva nu Savuli. ");
INSERT INTO zgam_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Usikhei ugwa Untwa akhagolosya eikhi vokho khu vala avalundamine alikhunogwa ukhuvatesya. ");
INSERT INTO zgam_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Akhabuda uYakovo ulukololwe nu Yohani nei mundu. ");
INSERT INTO zgam_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Vualelele ukhuta yeva ganile Avayahudi, akhamwibata nu Peteli khavili. eiye yale usikhe gwa mikata eimin'chila khuve. ");
INSERT INTO zgam_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Vuamubite akhadindila mulugadun'cho nukhuvikha ifipuga vine ifya vasikhali findolelage vu igulile ukhung'iukha khuvanu vuyisilile eiPasakha. ");
INSERT INTO zgam_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","U Peteli akhavikhiwa mundugadun'cho inyeisayo n'chikhavombekha namakha nulundamano lwa vanu khunjila ya mwene nu Nguluve. ");
INSERT INTO zgam_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Akhasikhi uHelodi salutile khukhung'umya, Eikilo iyo uPeteli agonelile pagati pavasikhali vavile khunu apinyiwe nei miinyololo gevile navasikhali pavulongolo pa ndiango valikhulindilila ulugadun'cho. ");
INSERT INTO zgam_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Pu usuhwa va Nguluve akhahumila nulumuli lukha ng'ala mugati. Akhatova uPeteli paluvafu nukhusisimula akhata(akhachova), “Sisimukha khimbevi.”pu eiminyololo eifevakhakunjile gikhadumukha mumavokho ga mwene. ");
INSERT INTO zgam_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Usuhwa akhambula akhata, “Fuala emienda gwakho ni filato.” U Peteli akhagaha ewo. Usuhwa akhambula akhata, “Fuala umwenda gwakho ung'ongange.” ");
INSERT INTO zgam_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pu uPeteli akhakonga usuhwa akhahuma khunji. Salukhukela eikhivombikhe nusuhwandaa lweli. Akhata pamo igogwa njosi(magonafivi). ");
INSERT INTO zgam_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Vu agendile eikhilindokua khwanja nei kyavile vakhafikha paligeti la kyumaeilya khwingila khu jini ukhadendukha lyene khujili ya vene. Vakhahuma panji vakhikha mutava, Nusuhwa akhandekha. ");
INSERT INTO zgam_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","U Peteli vueiwene, akhanchova akhata, “Lino neidikhe ukhuta Unguluve usuhile usuhwa va mwene ukhuta ang'enche mukevokho kya Helode, na masage gooni aga vayahudi.” ");
INSERT INTO zgam_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Vuagamanyile aga akhinche khu nyumba ya Mariamu umamaye va Yohani uviivii Markho; Vaeivunganin'che nukhweisaya(ukhudova). ");
INSERT INTO zgam_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Vu ahodin'che pa ndiango ugusigiwe, umbombi yumo ei litawa vei Roda akhincha khudendula. ");
INSERT INTO zgam_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Vualumanyile ukhuta eisavuti ei yeya Peteli, nuluhekhelo akhalemwa ukhudendula undiango; badala yake, akhanyila mugati mkheyumba; nukhuvavula ukhuta uPeteli eimile panji Pandiango. ");
INSERT INTO zgam_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Puvakhata khumwene, “Uve un'changanyikhiwe” akhandelela ukhuta vimwene lweli. Vakhata “Uyu visuhwa va mwene.” ");
INSERT INTO zgam_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","U Peteli akhendelela ukhudindin'cha vuvadinduule undiango vakhambona nukhuswiga. U Peteli akhava nunan'cha ni khivokho kheimyemye vakhavula na Unguluve vu ang'umin'che mundugadun'cho(akhata), ");
INSERT INTO zgam_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","“Muvavuli eimbombo n'chei uYakobo navalukololwe.” Pu akhahega akhaluta khuvunge. ");
INSERT INTO zgam_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Vuvukhile khukhava nulususuvalo khuvasikhali ukhuhumana na khila eikhei humile khwa Peteli. ");
INSERT INTO zgam_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Vu uHelode andondile ambwene akhavavun'cha avasikhali akhalamula ukhuta vabudiwe. akhaluta khuvuyahudi akhafikha khu Kaisalia akhatuma ukhwa. ");
INSERT INTO zgam_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","U Helodi ali neilioyo na vanu vakhu Tiro nakhu Sidoni, vakhaluta pupaninei khumwene vakhava muvumanyani nu Brasto untangili va ntwa, avatange, vakhadova nulunon'chehencho pakhuva ikhilunga kyavene kya pokhile eikyakhulya ukhuhuma khu ntwa. ");
INSERT INTO zgam_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Eisikhu eiyenogiwe uHelode akhafuala eimienda gwa vuntwa nukhutama pakhiigoda kya vutwa, nukhuvavula. ");
INSERT INTO zgam_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Avanu vakhaywega, “Eiyee savuti ya nguluve syoo savuti ya munu!” ");
INSERT INTO zgam_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Puu usuhwa va Nguluve akhantova pakhuva saa ampe uvudwadwa akhaliuva ni chango akhafywa ");
INSERT INTO zgam_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pu eilimenyu lya Nguluve likhakula nukhwenela. ");
INSERT INTO zgam_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Pu uBarnaba nu Savuli vuvamalesinche eimbombo vakhahuma pala vakhaluta khu Yelusalemu, vakhantova nu Yohani uvi eilitawa lya mwene ulyakhuholiwa vei Marko. ");
INSERT INTO zgam_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Leno mutembuile ya khu Antiokia, palena vasuhwa na vamanyisi. Vale uBarnaba, Simeoni(uviaei languvaga Nigeri). U Lukio uva khu Kirene, Manaeni( ulikoloeun'chila kisa gwa Helode undogonchi va koa), nu Savuli. ");
INSERT INTO zgam_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Vuvalipakhukonga udaada nukhudinda, Umepo Umbalan'che akhan'chova, “Mumbeikhile palukhanji uBarnaba nu Savuli, vavombe ei mbombo eiyunivilangile.” ");
INSERT INTO zgam_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Vu ei Tembile yeidendile nukhudova, nukhuvikha amavokho pakianya pa vanu ava, vakhavalekha valutage. ");
INSERT INTO zgam_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Pu uBarnaba nu Savuli vakha mweidikha Umepo Umbalan'che vakhikha ukhuluta khu Seleukia; ukhuhums ukhu vagendile munyanje ukhuta khu kisiva kya Kipro. ");
INSERT INTO zgam_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Vuvalimkhilunga kya Salam, valiei khun'chova eilimenyu lya Nguluve mu Masinagogi ga Vayahudi. Vale pupaninei nu Yohani nu Marko nduu ntangili vavene. ");
INSERT INTO zgam_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Vuvalutile mukhisi va kyoni eikya Kipro vakhambona umunu ung'avi, Unjahudi undagunchi va vudesi, uvei eilitawa lya mwene ale vei Bar Yesu. ");
INSERT INTO zgam_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ung'avi uyu vale paninie nu Liwali Sergio Paulus, ale munu einyaluhala. Umunu uyu avakaribisye uBarnaba nu Savuli, pakhuva anogwa ga ukhupulikha eilimenyu lya Nguluve. ");
INSERT INTO zgam_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pu uElima “ung'avi vulele ulo eilitawa” (ya mwene alukhuvabencha) agelile nukhupendula uliwali ahege mu ndweidikho. ");
INSERT INTO zgam_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Pu uSavuli uviaeilangiwaga Paulo, adin'chiwe Umepo Umbalan'che akhakaseihein'cha amiho ");
INSERT INTO zgam_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","na akhambula “Uve mwana va setano, uden'chine khila khinu kya vudesi. Nuvupepe uve uliaduvi va lweli. Savukhelekhelwa ukhupedula einjila n'cha n'cha Daada, einchi golwikhe vuwesya? ");
INSERT INTO zgam_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Lino lola eikhivokho kya Daada khelipakianya paliuve, vubosokha amiho. Savukhulevona eilin'chova khuusikhei” mala khamo uluhwela nei hisi fikhagwa pakianya pa Elimas; akhatengula ukhun'chungula nukhudova avanu vandogon'che nukhumwibatelila eikhivokho. ");
INSERT INTO zgam_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Pu umbaha vualolile eikhei humile, akheidikha, pakhuva aswigile amafundisyo ukhuhusu Udaada. ");
INSERT INTO zgam_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pu uPavuli navaninee vakhagenda munjila ukhuhuma khu Pafo vakhafikha khu Perge khuu Pamfilia. U Yohani avalekhile nukhuvuya khu Yelusalemu. ");
INSERT INTO zgam_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","U Pavuli nulukololwe vagendile ukhuhuma khu Perge vakhafikha khu Antiokia ya Pisidia. Ukhu vakhaluta mumasinagogi eisikhu ya Sabati nukhutama pasi. ");
INSERT INTO zgam_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Vu veimbile ululagilo lya vanyamalago, na valongon'chi va masinagogi avasuhile ei ndumi ukhuta, “Valukolo ei ngave muleneindumi vakhuvapa amakha apa avanu n'chova” ");
INSERT INTO zgam_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pu uPavuli akheima nukhuvapungeila amavokho; akhanchova, “Mweivagosi vakhu Esilaeli numwe umwei mukhukonga Unguluve mumuleihen'che. ");
INSERT INTO zgam_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Unguluve va vanu ava ava Isilaeli avahalile avadada yenyo ukhuvavikha vanu vingi vuvatamile khu Misili, nakhu khivokho kya mwene akhinuliwa nukhuvahumya khunji. ");
INSERT INTO zgam_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Khu miakha alubaini akhavafumeilila mulukunguu. ");
INSERT INTO zgam_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Vu anangile ifivumbukho saba ifyakhuu Kaanani akhavapa avanu vetoeikhelunga khivuhale. ");
INSERT INTO zgam_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Imbombo n'chiin'chooni n'cha humile emikha mia ine na hamsini. Pafinu ifi fyooni Unguluve akhavapa undamchi mpakha uSamweli Unyamalago. ");
INSERT INTO zgam_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Vuvavombile aga avanu vakhadova ukhuludeva, pu Unguluve akhavapa uSavuli umwana va Kishi, umunu va kheivumbukho kya Benjamini, ukhuva iikhuludeva eimiakha alubaini(40). ");
INSERT INTO zgam_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Vu Unguluve ang'een'chinche (mumbukhuludede) akhamwemikha uDavudi ukhuva iikhuludeva vavene. Vale ukhung'usu uDavudi ukhuta Unguluve an'chovile, 'Neipile uDavudi umwana va Yese ukhuva munu uveianogelanile nei numbula yango; ukhuta ivomba kheila kheinu eikheininogwa.' ");
INSERT INTO zgam_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ukhuhuma mukheikolo kya munu uyu Unguluve agegile ei Isilaeli umbopoli, uYesu, nduvu aeilapile ukhuvomba. ");
INSERT INTO zgam_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Eile lyaandile ukhuhumila va badu uYesu sin'chile, uYohani akhatengula ukhunchova ulwon'cho lwa vusikhelo khuvanu voni avanya Isilaeli. ");
INSERT INTO zgam_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nu Yohani vualipa khumala ei mbombo ya mwene akhan'chova mukhusagila unene ukhuta nene veni? une syoo ula. Ila pulehen'cha, uvei ikhwin'cha khusana khuliune, sanei nogile ukhulegesya ifilato vya malunde ga mwene.' ");
INSERT INTO zgam_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Valukolo mwei vanavakheikolo kya Abrahamu, navala aviiliei pagati paliumwe avikhumwudikha Unguluve, khuujili yeto ukhuta eikhulongwi yavovopalwa yeisuhiwe. ");
INSERT INTO zgam_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Khuvala avitama khu Yelusalemu, na vavaha vavene, savamanye uvufumbule wa vanyamalago uvuvu khweimbiwa mu Sabato; pu vakhamalisya ufumbwe wa vanjamalago pakhung'eiga uvufye uYesu. ");
INSERT INTO zgam_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ndangave savapate uwayei lweli vunonu uwakhung'eiga uvufye mugati mumwene, vakhadova uPilato alamule. ");
INSERT INTO zgam_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Vuvaamalile imbombo n'choni inchisimbiwe ukhuhusu umwene, vakhamwisya muubeikhi nukhugonwa mulipumba. ");
INSERT INTO zgam_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pu Unguluve akhan'chusya ukhuhuma khuvafyile. ");
INSERT INTO zgam_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Avanekhe isikhu n'chuu nyingi khuvala avavalutaga paninie nave ukhuhuma khu Galilaya ukhuluta khu Yeusalemu. Avanu ava lino vakheti va vanu. ");
INSERT INTO zgam_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Leno tukhuvagegela eikhulongi einonu va lulagilo uluvava pue avadada yeto. ");
INSERT INTO zgam_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Unguluve avikheile indagilo in'chii mundiufye, avana vavene, pa ei ele an'chusin'che uYesu nukhukilivula khaveilei khu wumi eileilee lyandikhiwe mu Sabuli va veile: 'Veve mwana vango eilelo neivile daadayo' ");
INSERT INTO zgam_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Uvuayilweli uvuan'chusin'che ukhuhuma khuvufye umbile gwa mwene gusite ukhunang'eikha, an'chovile ndee: 'Nikhukhupa uvuvalan'che nulusayo lwa lweli ulwa Davudi' ");
INSERT INTO zgam_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Eiyei yuan'chovile khavile muu sabuli eiyeinge, 'Sanikhweidekha umbalan'che vango ukhuvola.' ");
INSERT INTO zgam_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Pakhuva vu uDavudi vuatimisye indagilo ncha Nguluve mukhei vumbukho kya mwene akhagonelela, vakhagonwa pupaninie navababa va mwene avuwene uvuvivi(uvunangikhe), ");
INSERT INTO zgam_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pakhuva uvian'chusiwe nu Nguluve sikhuvuvona uvuvivi(uvunangikhe). ");
INSERT INTO zgam_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Pu yeimanyikhe khuliumwe, valukolo, ukhugendela umunu uyu, uvusyeikhilo wa mbivi vulumbiileliwe. ");
INSERT INTO zgam_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Pakhuva khila munu uviikhwedikha ivaleliwa uwayelweli yoni iyei indagilo n'cha Mose sanchikhale n'chi khuvaeilweli. ");
INSERT INTO zgam_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Puyiinogiwa muve miho ukhuta khila khei eikhiva nchovile avanyamalago kheisite ukhuhuma khuliumwe: ");
INSERT INTO zgam_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Pu mulole, umwe yumwe mwibela mukhaswiige nukhwangamila; pakhuva nivomba eimbombo pasikhun'chenyo, imbombo in'chii samuwesya ukhwiidekha ndavavule umunu.” ");
INSERT INTO zgam_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Vu uPavuli nu Barnaba vahegile avanu vakhavadova van'chove amamenyu aga pasikhu ya Sabato eiyeikhwincha. ");
INSERT INTO zgam_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Vuusikhei gwa n'kutano gwa siinagogi gusilile, Avayahudi vingi avagolofu fin'cho vakhavakonga uPauli nu Barnaba, avavan'chovila navo ukhuta vagendelelage nukheisa kya Nguluve. ");
INSERT INTO zgam_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Eisabato eiyekongile, umuji ugunge gwa hegelile khupulihin'cha eilimenyu lya Nguluve. ");
INSERT INTO zgam_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Avayahudi vuvalolile ukhutano, vakhava nu wifu nukhun'chova amamenyu aga khuben'cha ifinu ifincho viwe nu Pavuli nukhudukha. ");
INSERT INTO zgam_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pu uPauli nu Barnaba vakhan'chova nuvukifu nukuta, “Yeikhanogile eilimenyu lya Nguluve lin'choviwe khuliumwe. Pakhuva mukhwei kulugila kuvutali ukhuhuma khuliumwe. Nuukhweivona ukhuta samudogile ukhuhava uludeva lya sikhu n'choni mulolage tukhava peindukhila Avanyapanji. ");
INSERT INTO zgam_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nduvu uDaada atuvulile, akhata(akhanchova), 'Nivavikhile umwe nduu lumali khuvanu na khuvanu avanyapanji, ukhuta mugege uvupokhiei eingutu n'chooni nchweine n'cha kheilunga.” ");
INSERT INTO zgam_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Avanyapanji vuvapulikhen'chi vakhahovokha nukhuleng'inwa eilimenyu lya Nguluve. Vingi avahaliwe khuu wumi wa sikhu n'chooni vaaeidikhe. ");
INSERT INTO zgam_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Eelimenyu lya Nguluve likhenela eikhilunga kyooni. ");
INSERT INTO zgam_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pu avayahudi vakhavadova avei humin'che avadala navalongon'chi va miji. Aga ganchoon'chi eitabu khwa Pauli nu Barnaba vakhavataga khunjii khuu mipakha gwa miji. ");
INSERT INTO zgam_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pu uPavuli nu Barnaba vakhang'una eifumbe ya malunde gavene. Puvakhaluta khuu miji eigwa Ikonia. ");
INSERT INTO zgam_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Navakongi vakhadeiga nuluhekhilo paninie nu Mepo Umbalan'che. ");
INSERT INTO zgam_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Puyeikhahumila mugati mu Ikonio uPavuli nu Barnaba vaingile paninie mugati mu sinagogi lya Vayahudi nakhunchova umueikhei kundi eikhei vaha kya vanu Avayahudi na Vayunani vakheidikha. ");
INSERT INTO zgam_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Na Vayahudi avasavikhwedikha vakhan'chon'cheela uluhala khuvanya panji ukhuvavikha vavevivi khuvalukolo lwavo. ");
INSERT INTO zgam_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Puvakhatama ukhuu suikhei utali, nukhun'chova khumakha ga Daada, khunu vihumya uwayilweli ukhuhusu eikulongwi ya kheisa kya mwene. Avombile n'chei nukhuhumya iishara nifiswigo vivombekhe khumavokho ga Pauli nu Barnaba. ");
INSERT INTO zgam_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pu eilimenyu eilivaha lukhamenyukha: vaninie avanu vakhava paninie na Vayahudi, na vange vakhava paninie navasuhwa. ");
INSERT INTO zgam_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Vu avanya panji na Vayahudi vuvigela ukhuvavala avalongon'chi ukhuvavomba fivi nukhuvaponda na mawe uPauli nu Barnaba, ");
INSERT INTO zgam_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","vakhalimanya eilyo nukhunyilila khu Liakonia, Listra nakhu Derbe, namamenyu ag'inchungutila pala, ");
INSERT INTO zgam_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","nukhu vakhalumbilila eilimenyu(eilivangeili). ");
INSERT INTO zgam_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Nukhu khu Listra khwale nu munu yumo uvaatamaga bila makha mumalunde ga mwene, indemale ukhuhuma mulitumbu lya mamaye sagelile ukhugenda. ");
INSERT INTO zgam_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Umunu uyu ampulikhe upuuli vuinchova uPavuli akhakaseihin'cha amiho nu khivoni ukhuta alei nuluedikho lya khupona. ");
INSERT INTO zgam_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Pu akhanchova khumwe nei savuti eimbaha, “Eimanamalunde gakho.” Nu munu ula akhanyela khu kianya nukhutengu ukhugenda. ");
INSERT INTO zgam_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Avanu vuvalolile eikhiavo mbile uPavuli, vakhinula isavuti n'cha vene vakhata mu lahaja ya Kilikaonio, “eiminguluve gikhile mukhivokho kya munu.” ");
INSERT INTO zgam_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Vakhamwii langa uBarnaba “Zeu,” nu Paulo “Herme” pakhuva aliinchovajiimbaha. ");
INSERT INTO zgam_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Unchungaji umbaha va Zeu, uvi uyu eitembile ya mwene yale khunji khuu mji aletile eisenga nu tungo gwa mavuva eipakha pandiango gwa muji umwene na vanu voni vanogwagwa ukhuhumya ei sadakha. ");
INSERT INTO zgam_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pu avasuhwa, nu Barnaba nu Paul vuva pulikhe eleivakhalalula emienda gywa vene vakhanyila uluvilo khunji khuvanu, vakhalila ");
INSERT INTO zgam_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","nu khun'chova, “Umwe mwei vanu, kheikhii muvomba imbombo iinchii? Na yufye tulivanu vanyalioyo ndumwe tuvagegile eikhulongwei enonu ukhuta mupeendukha ukhuhuma mufinu ifi ifisafinogile nukhundola Unguluve umwumii, uviavumbile khukianya nei khuilunga iinyanja nifinu fyooni ifivonekha. ");
INSERT INTO zgam_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Musikhei Unguluve avalufutisye avanyapanji ukhugenda munjila n'cha vene vavo. ");
INSERT INTO zgam_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pakhuva badu, sahen'chiin'che kheinchila saidi, pa eilei avombile vunonu akhavapa eifula ukhuhuma khukianya usikhei gwa kyakhulya akhavadin'cheihein'cha inumbula n'cheinyo nei fyakhulya nuluhekhelo” ");
INSERT INTO zgam_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ate mumamenyu aga, uPauli nu Barnaba khuu sida vavasigile avanu ukhuhumya esadakha. ");
INSERT INTO zgam_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pu avanu va khuhuma khu Vayahudi va khuu Antiokia nakhu Ikonio vikhiincha khukhuvasawisi. Vakhantove uPauli na mawe nu khundundun'cha mpakha khunji vakhakhei hamo afuile. ");
INSERT INTO zgam_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pakhuva avakongi va emile kalibu nave akhasisimukha akheingila mjini. Eisikhu ya veile akhaluta khu Derbe nu Barnaba. ");
INSERT INTO zgam_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Vuamanyisye eilimenyu mumiji gula nukhuvavikha avakongi vingi, vikhavuya khuu Listra, hadi Ikoniamu hadi Antiokia. ");
INSERT INTO zgam_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Vaendelile ukhudulusya inumbula n'cha vakongi nukhuvapa amakha ukhun'chiga mu ndwedikho, akhanchova(akhata), “Pupanogile ukhuta twingile mundudeva lya Nguluve eisida(eitabu) yu nyingi.” ");
INSERT INTO zgam_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Vuvavahalile khuunjila ya vagogolo kheila lulundamano lya veidekhii vakhava vadovile nukhufunga, vava vekhiile mwa Daada, uvi uyuva mweidekhee. ");
INSERT INTO zgam_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pu vakhagenda khuu Pisidia, vakhafikha khuu Pamfilia. ");
INSERT INTO zgam_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Vuvanchovile amamenyu khuu Perga, vakhikha ukhuluta khuu Atalia. ");
INSERT INTO zgam_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ukhuhuma ukhu vaipakhile ei meli ipakhaa khu Antiokia khukhwa vaeihumin'che khuu kheisa kya Nguluve khuu mbombo yeiyo vamaleisin'ehe. ");
INSERT INTO zgam_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Vuvafikhee ukhu khu Antiokia, nukhuvunganwa(ukhulundamanwa) ululundamano lya paninie vakhahumya ei taarifa ya mbombo eiye Unguluve avombile khuu vene nei njila yeyo Unguluve avadindulile undiango gwa lunon'chehencho khuu vanu Avanyapanji. ");
INSERT INTO zgam_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Vaataamile usikhei utali navakongi. ");
INSERT INTO zgam_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Avanu avange vaikhile ukhuhuma khu Uyahudi nu khuvvamanyisya avalukkholo, valekhuta, “Mungasite ukhukeketiwa ndi nyikho incha Mose, samukhapokhiwe.” ");
INSERT INTO zgam_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","U Pavuli nu Barnaba vuvilwa navo mbukhanihani navene, avalukholo vakhalamula ukhuta uPauli, Barnaba na avange valotage khu Yelusalemu khu vasukhiwa navavakha ukhugamula ele. ");
INSERT INTO zgam_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Pwu khwa khusuhiwa khuvene nu mpelela, vakhagendela Foinike na Samaria valekhutangasya ukhusyetuliwa inumbula avakhelunga. Vakhagega ulukhovokho khu valokolo voni, ");
INSERT INTO zgam_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Vuwinchile khu Yelusalemu, vakhopelelwa navampelela na vasukhiwa na vavakha, vakhavapangela imbombo nchoni inchavombile Unguluve khuvene. ");
INSERT INTO zgam_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pwu avange avanu aveedikhe, avavale ndipuga elya Valongonchi, vakhema nukhuta, “lononu ukhuvakheketa nukhuvalagela ukhwibata indagelo incha Mose.” ");
INSERT INTO zgam_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Pwu avasukhiwa na vavakha vakhema paninie ukhulesagela elimenu elyo. ");
INSERT INTO zgam_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Vuvenchovanchinje, Peteli akhema nu khuchova khuvene, “Valokholo mulumanyile ukhuta imisekhe eminonu egelutile Unguluve avombile uvukhale khulyofwe, ukhuta ndomo gwango avakhelunga vapulekhe elimenyu lya Nguluve, nu khwedekha. ");
INSERT INTO zgam_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Unguluve, uveanchimanyile inumbula, ikhovavula, ikhovapa Umepo Umbalanche, ndavovwa avombile khulyofwe; ");
INSERT INTO zgam_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","satesaninche ukhusita ukhuhwanene ufwe navene, akhanchivekha inumbula inchavene ukhuva nonu nu lwidekho. ");
INSERT INTO zgam_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Pwu, khekhi mukhogela Unguluve ukhuta muvekwe iyikhongelwa mu singo incha vakhongi fifyo na vadadavetu fyavatohile ukhusipa? ");
INSERT INTO zgam_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ulwa khuva twihwedekha ukhuta twikha uvwupokhi khu luhungu lwa Ntwa uYiisu, ndavovwa vale ");
INSERT INTO zgam_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ululundamano lwoni lukhanchiga mie vwuvikhuvapalehencha uBarnaba nu Pauli vwuvihomia elimenyu elya fikhwani ni fidekho fifyo Unguluve avombile paninie navene nava khelinga. ");
INSERT INTO zgam_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Vwu velekhilwe ukhunchova, Yakobo akhanda akhata, “Valokholo mumolekhenche. ");
INSERT INTO zgam_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni avavolile ukhuta Unguluve khuluhungu avatangile avakhelunga nu khuhoma khuvene avakhave avanu khu litawa lya mwene. ");
INSERT INTO zgam_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Amamenyu ga vanyamalago gihwedekhananele ndavovwa lesimbiwe. ");
INSERT INTO zgam_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","'Vwu nchivombikhe inchi nelavwuya khunjenga elyeve lya Daudi, elegwile pasi; yanikhwimikha nukhutesania ukhunengekha, ");
INSERT INTO zgam_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","pwu avanu vava vasigile vandondage Untwa, popaninie na vanu Avakhelunga avelangilwe khu litawa lyango.' ");
INSERT INTO zgam_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Uvwu vwunchova Untwa oveavombile imbombo inchi inchimanyelihihe ukhuhoma khatale. ");
INSERT INTO zgam_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Pwu leno, uvutangeli vwango vwu uvu, ukhuta tusite ukhuvagatanche Avakhelunga vavo vamwedikhe Unguluve; ");
INSERT INTO zgam_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","pwu tusimbe khuvene ukhuta vave khutali nu vunangi uvwa fikhwani, uvunogwe uvwa mbivi nu fifyo finyongotolilwe, nu nkhisa. ");
INSERT INTO zgam_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ukhuhuma ifipapo ifya vakhetali khuvale avanu vavo khela n-jini avilumbelela nu khumwemba uMose mu masinagogi mu Sabato.” ");
INSERT INTO zgam_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Pwu yekhavonekha ukhuvakhosovya avasukhiwa na vavakhe, nu umpelela gyoni, ukhung'ala uYuda uveaelangwagwa Barsaba, nu Silas, avale valongonchi va mpelela, nu khuvasukhe khu Antiokia nu Pauli nu Barnaba. ");
INSERT INTO zgam_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Vasimbile ukhuta, “Vasukhiwa, vavakha na valokholo, khu valokholo Vankhelunga avale khu Antiokia, Shamu nu Kilikia, tukhuvaponia. ");
INSERT INTO zgam_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Twapolikhe ukhuta khule vanu vavo satwavape ululagelo ulwa, vakhumile khulyofwe nu khuvagatancha khu vumanyisi uvwukhuvapelela uvugatafumu numbula nchenyo. ");
INSERT INTO zgam_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Pwu luvile lunonu khu twevoni ukhuhaga avanu nu khuvasukha khulyomwe ne vagane vetu uBranaba nu Pauli, ");
INSERT INTO zgam_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","avanu vavo vaekhominche uvwumi vwa vene khu litawa lya Ntwa Yiisu Kriste. ");
INSERT INTO zgam_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Pwu tavasukhile uYuda nu Sila, vikhovavola imbombo nchichicho. ");
INSERT INTO zgam_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ulwakhuva yavonikhe ukhuva lunonu khu Mepo Umbalanche na khulyofwe, ukhusita ukhuvapelela ifinu ifinchitu ukhulutelela imbombo incha khuva mu mbolongolo: ");
INSERT INTO zgam_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ukhuta msyetukhe ukhuhuma khu finu ifilakhiwe khu fikhwani, unkisa, ifinu iyinyongiwe. Nu uvuligu.” ");
INSERT INTO zgam_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Pwu vavo wapanchanile, vakhihela khu Antiokia; vwu valundamine ululundamano pwu paninie, vakhehelekha ekhalata. ");
INSERT INTO zgam_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Vwu vayembilwe, vakhahovokha ukhukanganchwa inumbula. ");
INSERT INTO zgam_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","U Yuda nu Sila, na avanyamalago, vavahanginche avalokholo khu mamenyu mingi nu khuvapa amakha. ");
INSERT INTO zgam_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Vwu vatamile misekhe ukhwa, vakhapanchanila khu lukhungu ukhuhome khu valukholo khu vavo vakhavasukhile. ");
INSERT INTO zgam_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","U Pauli ne vange avatamaga khu Antiokia paninie na vange vingi, pwu vamanyisye nu khulambelela elimenyu lya Ntwa. ");
INSERT INTO zgam_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Vwu galutile amanchuva madebe Pauli akhata khwa Barnaba, “Ole leno tavuye khuhovagendela avalokholo mumwa twalombelile elimenyu lya Ntwa, nu khuvalola vovalevwo. ");
INSERT INTO zgam_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","U Barnaba akhanogwa ukhuluta neve nu Yohani uveatambuliwagwa Marko. ");
INSERT INTO zgam_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","U Pauli akhasaga ukhuta salwiva lunonu ukhuntola uMarko, yoywa avalekhile khu Pamfilia akhasita ukhuvombania embombo. ");
INSERT INTO zgam_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Pwu lukhahomela ukhukhanekhena ukhuvakha bakhalekhehana, uBarnaba akhantola uMarko vakhalutania mu mbwato khu Kipro, ");
INSERT INTO zgam_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","U Pavuli akhang'ala nu Sila nu khuhega, vwuvupelile ulukhungu lwa Ntwa ukhuhuma khu valokholo. ");
INSERT INTO zgam_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Akhaluta ukhugendela khu Shamu na Kilikia, alekhungekhenganche imipelela. ");
INSERT INTO zgam_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","U Pauli vope akhincha khu Derbe nu Lystra; bakho alepo onkhongi uvealangagwa Timotheo, ale n-demi aveakholiwe nu vanine va Uyahudi alemwedekhi nu dadaye ale Mgiriki. ");
INSERT INTO zgam_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Avanu va Listra nu Ikonia vamwedikhe vononu. ");
INSERT INTO zgam_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pauli akhanogwa ukhuta elongonche neve, pwu akhantola nu khunkegeta ulwa khuva Wayahudi avale ukhwa vammanyile ukhuta udadaye Mgiriki. ");
INSERT INTO zgam_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Vwuviluta vakhagenda mu miji nukhulagela mu- mipelela ukhwedekha indagelo incho inchasimbiwe na vasukhiwa na vavakha vakhju Yelusalemu. ");
INSERT INTO zgam_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Pwu imipelela gekhahangala mu lukungu na vedekhi vakhava vingi amanchuva goni. ");
INSERT INTO zgam_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pauli nevanine vakhaluta khu Firigia na khu Galatia, ulwa khuva Umepo va Nguluve avabenchiche ukhulombelela elimenyu okhwa khu Asia. ");
INSERT INTO zgam_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Vwu valepakhifikha Misia, vakhagela ukhuluta khu Bithinia, pwu Umepo va Yiisu akhavabencha. ");
INSERT INTO zgam_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Pwu vakhalutanincha pa Misisa vakhincha pa Troa. ");
INSERT INTO zgam_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","U Pauli akhagogwa pakhelo, pale nu munu va Makedonia emile, alekhwelanga ukhuta, “Mwinchage mututange khu Makedonia”. ");
INSERT INTO zgam_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pauli vwu agogilwe, pwu tukhetesania ukhuluta khu Makedonia, akhalumanya ukhuta u-Nguluve atwelangile ukhuluta khulumbelela elimenyu. ");
INSERT INTO zgam_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Pwu tukhahega khu Troa, tukhaluta khu Samothrake, ne elinchuva elekhongile tukhafikha khu Neapoli. ");
INSERT INTO zgam_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ukhohuma apo tukhaluta khu Filipi ugwale nnjini gwa Makedonia, gwale nnjini ugwa emelivwagwa nava Rumi pwu tukhatama amanchuva madebe. ");
INSERT INTO zgam_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Elinchuva lya Sabato, tukhaluta khonji tukhagenda mu- ndogasi, pakho twasagile ukhuta piva pakhovombela ulwesayo. Twatamile pasi nu khunchova na vadala avainchile popaninie. ");
INSERT INTO zgam_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Udala yomo aveaelangagwa Lidia, akonchega e zambarau, akhomile khu Tiatria, unyakhwisaya khwa Nguluve, atopalekhinche. Untwa akhadendula enumbula ya mwene akhavekhe amamenyu aganchovwagwa nu Pauli. ");
INSERT INTO zgam_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Vwu onchiwe, umwene nu vunchenge vwa mwene, akhatudova ukhuta “nelemwedekhi khwa Ntwa, nikhovadova mwingele nu khutama khulyone”. Akhatovadova fincho. ");
INSERT INTO zgam_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Vwu twilota pa khwesaya, ung'enja yomo oveale ni mepo indagwunchi akhagane nufwe. Agegile u munu va mwene uvukhavi mu - mbulagunchi. ");
INSERT INTO zgam_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Udala ayo akhankonga uPauli paninie nufwe alekhuywega ukhuta “Ava gosi vavombi va Nguluve umbakha, vikhovavola umwe elimenyu lya vwupokhi”. ");
INSERT INTO zgam_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Akhavomba evo amanchuva mingi, uPauli lya nkaliunche elyoavombaga, akhasyefukha nukhunchivola imepo, “Nikhoholagela khu litawa lya Yiisu ukhume khu dala ayo.” Imepo nchikhahuma nu khundekha udala. ");
INSERT INTO zgam_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Avavakha va mwene vuvavwene ukhuta uvwutang'eli vwukhegile vakhavinata uPauli nu Sila nu khuluta navo khu sokhoni khuvene - avavakha va selekhali. ");
INSERT INTO zgam_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Vwu vafikhe navo khuvahegi, vakhata, “Avagosi ava Wayahudi vivomba amatata amavakhe pa nnjini gweto. ");
INSERT INTO zgam_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Vimanyisya imbombo nchicho sio lulagelololwa satwaopele khu Varumi.” ");
INSERT INTO zgam_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ululundamano lukhava khenyume nu Pauli nu Sila, avakhegi vakhadyefula emiendegya vene nu khuvafula vakopiwe, ni mbekhe. ");
INSERT INTO zgam_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Vwu vakopiwe ni mbekhe nyingi, vakhahelekhwa mu - khekongwa - nu kuvalagela avasikhali ukhuvalolela vononu. ");
INSERT INTO zgam_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Vwu vapokhile ululagelo, avasikhali va nkekongwa akhevingenche mu - kheyumba ekhya gati, akhavakonga amahunde ga vene khuhwa avavekhile. ");
INSERT INTO zgam_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Emisekhe gya pakhelo pagati, uPauli nu Sila vakekwisaya nu khwimba inyemboincha khuginia uNguluve khunu avakhongwa avange vikhovapolehencha, ");
INSERT INTO zgam_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Pwu khehahomela ekhesenyende ekhevakha ekhekhongwa, ne minyororo gya vakhongwa voni gekhasupuliwa. ");
INSERT INTO zgam_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ondoleli va khekongwa akhasisimukha ukhuhuma mu - tulo pwu akhavona emilyango gyoni egya khekongwa; gedenduliwe akhatola emundu ya mwene anogwaga ukhwebuda ulwa khuva asagile ukhuta avakhongwa voni vanyilile, ");
INSERT INTO zgam_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pwu, uPauli akhaywega khu limenyu elivakha, akhata “usite ukhwelemanche ulwa khuva twe voni potole apa”. ");
INSERT INTO zgam_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ondoleli va khekongwa akhadova alumuli akhingela mu - khekongwa na mbeve, alekhutetema nu khudwada, akhafugama pa Pauli nu Sila, ");
INSERT INTO zgam_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","akhavakhomia khunji akheta, “Vavakhanevombe khehi nekhave uwupokhi?” ");
INSERT INTO zgam_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Avene vakhambala ukhuta, “Mwedekhe Untwa uYiisu pwu vwikheva uvwupokhi nu vunchenge.” ");
INSERT INTO zgam_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Vakhanchova elimenyu lya Ntwa khumwene, paninie na vanu voni avambunchenge vwa mwene, ");
INSERT INTO zgam_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ondoleli va khekongwa akhavatola ekhelo ela, akhavakhalafya mumwa valemile, omwene paninie navanu va mumbunchenge vwa mwene valihonchiwa. ");
INSERT INTO zgam_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Akhavagega uPauli nu Sila mumbunchenge uvwa mwene nukhuvatelekhela ekhahulya. Pwu akhava lulokhovokho ulwakhe paninie navanu va mbunchenge vwa mwene ulwakhuva vamwedikhe uNguluve. ");
INSERT INTO zgam_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Guvile gufikhe umusi, avakhegi vakhasuha avanu khu ndoleli vakhekongwa ukhuta, “Ovatavule avanu vala valotage”, ");
INSERT INTO zgam_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ondoleli va khekongwa akhambula uPauli amamenyu ago ukhuta, “Avakhegi vasukhile ukhuta mukhegage: mukhome khunji mulotage nulunon'chehencho.” ");
INSERT INTO zgam_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pwu Pauli akhavavola, “Vatotovile pa vuvalafu, avanu vavo Varumi khetatukhega nu khulamula ukhutukhonga mu khekongwa; leno vinogwa ukhutuhomia khuvutitu? Ate, satukhwedekha, vinche vavo vatokhomie apa”. ");
INSERT INTO zgam_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Avaloleli vakhavavola avakhegi amamenyu gala, avakhegi vakhadwada vavile valumanyile ukhuta uPauli nu Sila vale Varumi. ");
INSERT INTO zgam_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Avakhagi vakhinche khuhovadova vakhome vwu vavakhominche khunji khukhekongwa vakhadova uPauli nu Sila vakhome khunji ya khelunga khavo. ");
INSERT INTO zgam_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pwu uPauli nu Sila vakhahuma khunji uhukhekongwa vakhinja mu mbunchenge uvwa Lidia. Pauli nu Sila vovavavwene avalokholo vakhavapa amakha mu numbula nu khuhega mu khelonga ekhyo. ");
INSERT INTO zgam_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pu vakhanghenda mumbunchenghe uwa Amfipoli na Apolonia, puvakhafikha kuvunchenge uwa khu Tesalonikhe ukhuyale ekhyo einyumba eiya khwisayeila Avayuta. ");
INSERT INTO zgam_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Nduvulwale ulwiho lwa Pavuli pu akhingeila khuvene pu aleikhwinchojanja navo, amamenyu ngha mbusimbe emilungu nghei datu einghya Sabati. ");
INSERT INTO zgam_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Pu aleikhuvadeinduleila uvusimbe nukhuvavulanincha ukhuta, ya nonghile uKeilesite ukhunkuveilwa pu anchukhe khange ukhuhuma khuvunchukha. Pu akhavavula, “Akhata uYeisu uveinikhuvavula inongwa ncha mwene yei Keilesite” ");
INSERT INTO zgam_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Pu avange Muvayuta vakhakela nukhweideikha puvakhahangana paninie nu Pavuli nu Sila, pu navava Vagiliki vope vavo va mweimeikhangha avuva eidikhe nukhukava uvupokhi valepyo neikheipungha eikheivaha eikhya vanu. ");
INSERT INTO zgam_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pu Avayuta vale nakhavini savaleiveideikhi puvakhanchi lundamania avanu vuvingi puvakhava veidikhi avanu avapanji puvakhava khipunga nukhupela eimbwato pavunchenge, hange pukhayuvukhila nayeinyumba eiya Yasoni, vuvilonda ukhuvubata Pavuli nu Sila nukhuva nahengha pavanu. ");
INSERT INTO zgam_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pu leino vavile valemilwe ukhuvavona puvakhamwibala uYasoni navakeilesite avange vakhavaheileikha khuvavaha vavunchenge puvakhata nukhyovela valeikhuta, “Avanu ava vyu vala vavo vikhuvakilivula avanu avankilunga khyoni puvinchile nakhunu khunu, ");
INSERT INTO zgam_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","U Yasoni vei avupeilile, pu avanu ava savikonga ululangheio lwa Kesali, pu vita khwale unkuludeva uyunge viita vei Yeisu” ");
INSERT INTO zgam_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Pu avanu eikhipungha khyoni navavaha vavunhenge vakhatimbukha mwitumbu vavile vapulikhe ewo. ");
INSERT INTO zgam_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Pu uYasoni nava nine vavile vahombile ihela puvakhavavopola, vakhavelekha valutanghe. ");
INSERT INTO zgam_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Pu avakeileisite vayavo eikilo yeila yeila puvakhavalavuleila uPavuli nu Sila na yu Beloya. Vavile vafikhe ukhupuvakhinghila munyumba iyuvikheisayeila Avayuta. ");
INSERT INTO zgam_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Avanu vala vale nuluhala ukhululeila vala avakhu Tesalonikhe ulwakhuva va lyupeilile eilimenyu neinumbula. eingolofu puvaleikhukongelela uvusimbe ifinghono fyoni ukhuta puvalumanye nghangho nghincho viwa vunghaleivwo. ");
INSERT INTO zgam_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Pu leino avingi muveene vakhalyeideikha eilimenyu, avadala na vanghosi ava Gilikhi vuveingi. ");
INSERT INTO zgam_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pu ieino Avayuta avakhu Tesalonike vavile vwene ukhuta uPavuli eilumbeileila eilimenyu lya Nguluve ukhu khu Veloya, puvakhaluta ukhwa puvakhanchi khyavanu eikhipungha khyavanu vakhava neimbwato khuvanu. ");
INSERT INTO zgam_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Khya hanila, avakeileisite vala puvakhangh'eileikha uPavuli alutanghe khunyanja, pu leino uSila nu Timoti vakhasinginghala palapala. ");
INSERT INTO zgam_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Avakeileisite vala vavile vangh'eili khe uPavuli puvakhandhifikha nave nakhu Atene, puvakhandekha uPavuli ukhwa, puvakhupeila khumwene unghwavalanghile ukhuta uSila nu Timoti vinche khumwene khyahanila. ");
INSERT INTO zgam_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pu avile ikhuvanghuleila ukhukhu Athene, enumbula y amwene yeikhavipa fincho umu alolile uvunchenge vula umuvudeinghile ifiihwani fyufingi. ");
INSERT INTO zgam_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Pu leinu valemunyumba ya khweisayeila puakhinchofanja na Vayuta vavo vale veideikhi khwa Nguluve na vala vooni uvuanghanile navo isikhu nchoni palinghunchi. ");
INSERT INTO zgam_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Pu leino avanghana luhala ava epikuli nava sitoiki vakhamweideikha. Pu avange vakhata, “Inchova khinu kheikhi uyu unchofi uteta? Avange vakhata, “ivonekha ukhuta ilumbeileila inongwa inchaminguluve inongwa ncha Yeisu nu vunchukha. ");
INSERT INTO zgam_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Piuvakhatola uPavuli vakhaluta nave pakheigima eikhyu vatenchangha pu pa -Alyopangho, valeikhuta, “Tuvaheile ukhunghamanya unghuvumanyeisya amanghenji angha? ");
INSERT INTO zgam_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ulwakhuva vwinghengha nghangho manghenji mumbulukhutu ncheito. Pu leino lwinonghwa ukhulumanya angha khukhuta khwikhi?” ");
INSERT INTO zgam_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Ulwakhuva ava atene nava nghenji avatamangha ukhwa vale vwaseikhi unghwa khunchova khyukhyoni pu valekhuva vanu va khupuleiheincha inongwa imya.) ");
INSERT INTO zgam_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pu leino uPavuli akheima pa nghati na nghali pavanu ava khu Aleopago nukhuta, “Umwe mweivanu va mu Atene, nivona ukhuta umwe muleivanu vamanguluve, ");
INSERT INTO zgam_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Pakhuva nukhunghenda khwango nukhulola ifinu fyeinyo ifyumukhufyeimeikha puneivwene amamenyu anghaveinghivwe pakheitekhelelo khyeinyo, anghita “KWA NGULUVE UVEISAMANYEIKHIKHE”. Pu leino uywa uvei mukhumweimeikha nukhwisaya pakhusita khumanya, vei uyu uveinukhuvavula umwe. ");
INSERT INTO zgam_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Unguluve umpeli vakhilunga ni finu fyoni ifilimunghati, ulwakhuva vei nkuludeva va kyanya na pasi pakheilunga, savahile ukhutama mutembile inchipeliwe na mavokho. ");
INSERT INTO zgam_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Pu khange umavokho ngha vanu punghikhunghaheila ukhuta pamo inonghwa khininie khuvene, pakhuva umwene yu mwene ikhuvapa avanu uvwumi nu mwuya ni finu ifinge fyoni. ");
INSERT INTO zgam_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Pu ukhunghendela khumunu umo, pu akhapela ifivumbukhu fyoni ifya vanu avavitama pakhilunga, hange akhavaveikhila eimiseikhi ni makha neha khilunga umuvitama. ");
INSERT INTO zgam_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Pu lieno, pavandonde Unguluve ndapuyeingave pakhupalamasya puvakhambone, hange saleipavutali nu munu umo umo ndyufwe. ");
INSERT INTO zgam_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Khumwene mututameila, tunghenda nukhuva nuvwumi vweito, nduvu usimbi va lweimboatile tuleivaholiwa va mwene.' ");
INSERT INTO zgam_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Pu lieno eingave ufwe tuleivaholwa va Nguluve sayeinonghile ukhusangha ukhuta uvu Nguluve khinu khya lutalama pange khahel apange khalinghanga ukhu umunu ipunja nulwunchi eikheihwani vunonu na masanghongha vanu. ");
INSERT INTO zgam_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Pu Unguluve ale mya eimise ikhei ngheila einghya vupelwa pu leino eilangheila ukhuta avanu voni upuvalepwo vapelonghe. ");
INSERT INTO zgam_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ulwakhuva aveikhile eikhingho eikhyakhuheingheila eikheilunga mbwayeilweli khumunu ula uvei ahaliwe. Unguluve ahuminche uvumanyi vwa munu uyu khumunu uveiavenchangha pala upu anchusinche ukhuhuma khuvunchukha. ");
INSERT INTO zgam_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pu na vanu ava khu Atene vavile vapulekhe einongwa eiya vunchukha vwa vafwile avange mbene pakhangh'ekha uPavuli, pu avange vakhata “Putukhukhupuleiheinchangha khange khulimenyu lya nongwa eiyei. ");
INSERT INTO zgam_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pu apo leino, uPavuli akhavalekha. ");
INSERT INTO zgam_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pu leino avanu avange vakhakongana nave vakheideikha uyunge mu avo vei Ndyonisi uva Mwareopago, nu Dala uvei ikheilangivwa Damali navange paninie na vene. ");
INSERT INTO zgam_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pu pongela ngavile nghavombikhe anglo uPavuli akhahengha khu Atene ukhuluta khu Kolito. ");
INSERT INTO zgam_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Pu akhanghana nu munu umo uva khu Vuyuta aleikhweilangivwa akhwila uvankeivumbukhu khya Ponto, pu umwene nu mwene va mwena uveikheilangivwa Prisila vainchile ukhuhuma khu Italiya ulwakhuva ukilavuti umbaha vasikhali alanghile ukhuta Avayuta voni vahenghanghe khu Loma; Pu uPauli akhincha khuvene; ");
INSERT INTO zgam_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pu uPavuli aleikhulama nu khuvomba navo eimbombo pakhuva umwene alikhuvomba eimbombo eiyeilehine nei ya vene. Ulwakhuva avene vale vahona mahema. ");
INSERT INTO zgam_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pu uPavuli aleikhunchova navo munyumba ncha khwisayila ifinghono fyoni ifya Sabati. Aleikhuvankuveileila Ava yuta nava Giliki. ");
INSERT INTO zgam_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Pu lieno uSila nu Timoti vavile vinchile ukhuhuma khu Makedonia, ya pu uPavuli akhavavwa munumbula pu akhava munu vakhuva vula nincha Avayuta ukhuta uYeisu vei Keileisite. ");
INSERT INTO zgam_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pu avene Avayuta vavile vikhumwilula nukhunghekha uPavuli, pu akhakuhuna umwenda nghwa mwene ulujumbe pa miho nghavo, nu khuvavula, ukhuta, “Unkisa ngweinyo nghuveinchanghe pa ntwe palyumwe yumwe; Une saneileinangi neilei ngholofu. Ukhuhulumangha leino ni sikhu inchikonga puniekhuva luteila Avakaya”. ");
INSERT INTO zgam_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pu leino akhahengha ukhuhumangha pala pu akhaluta khu kaya ya Tito Yusito, Umunu umweideikhi va Nguluve. Einyumba ya mwene yeileipipi nei nyumba ya khweisayeila. ");
INSERT INTO zgam_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Pu uKilisipo, undonghonchi vanyumba ya khweisayeila paninie na vanu avanyumba ya mwene vakhamweideikha Unkuludeva. Avanu vingi avamu Kolinti vapulikhe uPavuli vuinchova vakheideikha nu khyonchivwa. ");
INSERT INTO zgam_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Pu unkuludeva akhambula uPavuli munjosi inchiita, “Ulekhe uvudwanchi puleino unchovanghe eilmenyu ulekhe ukhumunala. ");
INSERT INTO zgam_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Pakhuva une neilei paninie nuve, pu asikhuli uveiyakheiva einghela ukhukhyuvukhila pa nakhukhulemancha, pakhuva na vanu vingi pa vunchenge uvu”. ");
INSERT INTO zgam_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","U Pavuli akhatama ukhwa pa seikhi unghwa mwakha nghumo nei mienchi intanato pakyanya vuimanyeisya eilimenyu lya Nguluve mumbeene. ");
INSERT INTO zgam_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Pu lieno u Gailo navile aveikhivwe ukhwa indoleli vakheilunga eikhya mu Akaya, Avayuta vakheima vakhava vamwuvukhile uPavuli puvakhangileikha pavuheinghi, ");
INSERT INTO zgam_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","valeikhuta, “Umunu uyu ikhuvasyova avanu lita vamweideikha uNguluve umusalunchevela ululangheilo”. ");
INSERT INTO zgam_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pu uPavuli avile inonghwa ukhudeindula undomo anchove pu u nghalioni akhavavula Avayuta akhata, “Umwe mwei Vayuta, engale yeive uyunge aveyangile eilweli ewo vunangi pu yale yiva iweli ukhuta neivapulieheinche. ");
INSERT INTO zgam_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Leino ulwakhuva mamenyu ngha matavwa ni ndangeilo ncheinyo, pu leino heinghangha yumwe. Une saninonghwa ukhuva ingh'einghi khunongwa incho.” ");
INSERT INTO zgam_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","U Nghailo avalangheila ukhuta vahenghe pavulongolo vwa vutamo vwa vuheinghi, ");
INSERT INTO zgam_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Pwu, leino voni puvakha mwibata u Sositeni, undongonchi va vakhatova pavulongolo pa khingoda eikhya vuheinghi. Pu uNgalio ni saleikhusangha khinu eikhyu vivomba. ");
INSERT INTO zgam_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","U Pavule avile atamile pala akhaseikhei akhingi pu akhalekhahana na vakeileisite, akhingeila mungalava akhaluta khu Siliya paninie nu Plisila nu Akwila. Vuvakhale ukhuhengha pu akhakeeta inchweile pakhuva nchale ncha Lweijyiengho. ");
INSERT INTO zgam_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Vavile vafikhe khu Efesi, uPavuli akhandekha u Prisila nu Ankwila, pu leino umwene yuywa akhingheila munyumba eiya khwisayeila nukhwinchofanja na Vayuta. ");
INSERT INTO zgam_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Vavile vambulile uPavuli ukhuta ave navo paseikhi nghumwingi umwene pwakhabela. ");
INSERT INTO zgam_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Pu akhahenhga khuvene akhavavula ukhuta, “Yanikilivukha khange khulyumwe, eingave vunghane vwa Nghuluve”. Pu pala akhahengha nei ngalava ukhuhuma khu Efesi. ");
INSERT INTO zgam_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Avile afkhe khu Kesaliya, pu akhatongha ukhuluta khwiponia upelela unghwa khu Yelusalemu, pu akhavaya akhiikha khusikha khupelela unghwa khu Antiokia. ");
INSERT INTO zgam_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Avile atamile khaseikhi pala pu uPavuli akhahenga akhanghendela khukhilunga eikhya mu Nghalatiya na mu Filingiya pu nukhuvakangancha avakongi voni. ");
INSERT INTO zgam_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","U Nchahudi umo eikheilangivwa vei Apolo, uvei aholiwe khu Alekhisanda, ainchile khu Efesi. Alei kuluhala fincho pakhunchova hange ale manyi va mamenyu anghasimbiwe. ");
INSERT INTO zgam_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","U Apolo avuliwe mumamenyu ngha Nkhuludeva, u muavelile nulunghimbo mu mepo, pualeikhunchova nukhungholokha vunonu pakhumanyisya ulumanyisyo lwa Yeisu pu leino alumanyile iwene ulwoncho lwa Yohani. ");
INSERT INTO zgam_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","U Apolo akhatenghula ukhunchova muvukifu mu tembile. Pu uPlisila nu nkwila vavile vapulikhe puvakhava vumanyani nu mwene puvakhambula einjeila ncha Nghuluve vunonu. ");
INSERT INTO zgam_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Avile inonghwa ukhuhengha ukhuluta khu Akaya, aveideikhi vakhakangancha einumbula nukhuvasimbeila eikalata avakongi avale khu Akaya ukhuta vave vanu vakhu mwambeileila. Avile afikhe mu nduhungu avatangile fincho aveideikhi vala. ");
INSERT INTO zgam_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Khumakha nu vumanyi vwa mwene, u Apolo avaluleilile Avayuta pavuvalafu vuivonesya ukhukongana nuvusimbe uvwakhuta uYeisu vei Keileisite. ");
INSERT INTO zgam_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Pu yeikhava uApolo avile alei khu Koritho, Pavuli akhava amalile ukhunghendela eikhilunga eikhyapanghati pu akhafikha khuvunchenge uvwakhu Efeso, ukhwa avavona avakongi avange. ");
INSERT INTO zgam_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","U Pavuli akhavavula akhata, “Mwaupeilile Umepo Umbalanche mwavile mweideikhe?” Vakhata, “Ndeili hange satwapulikhe ukhunkongana nu Mepou Umbalanche ukhuta khwale.” ");
INSERT INTO zgam_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pu Pavuli, “Leino umwe mwaonchiwe ndakheikhi?” Vakhata twa onchiwe ulwoncho lwa Yohani. ");
INSERT INTO zgam_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pu uPavuli akhanda akhata, “U Yohani avonchangha ulwoncho ulwakhupela inongwa. Pa akhavavula akhata panonghile ukhumweideikha wa uvei ikhwincha uYohani vwamalile imbombo pu uywa vei, Yeisu.” ");
INSERT INTO zgam_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Pu avanu vavile vapulikhe ndavule ukhuta panonghile ukhumweideikha u Yeisu, pu vakhonchivwa mu nditavwa lya Yeisu unkuludeva. ");
INSERT INTO zgam_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pu uPavuli avile aveikhile amavokho ngha mwene pavene, u Mepo Umbalanche akhinja mumbeene, pu vakhatenghula ukhunchova munchovele incha ndeimi imya nu khulangha uvunyamalangho. ");
INSERT INTO zgam_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Pu avene vooni vale avagosi eikhinchingho navaveili. ");
INSERT INTO zgam_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pu uPavuli akhaluta akhingheila munyumba eiya vayuta eiyakhweisayila. Pu akhava nkifu pakhunchova inongwa kheisita khufiha amalile eimyenchi ngheidatu. Puu aleikhuvalonghocha avanu pakhweinchofancha nukhuvuhovosya avanu mundi menyu eilya ludeva lwa Nguluve puvei lekhukonga. ");
INSERT INTO zgam_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Pu leino aAvayuta avange vale na matingo inumbula nchavo nchanghilimbile. Pa valeikhunchovela mbuvivi ukhukangana nei ni mbombo ncha Keileisite pa kheipungha khya vanu. Pa uPavuli akhalekhehana navo. Akhavaveikha ponu sakhava paninie navene, Pu leino amanchova nghoni aleikhunchova navo munyumba ya Tilani. ");
INSERT INTO zgam_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Akhava munu vakhuvomba ndavule eimyakha ngheiveili, pu leino voni vavo vatamangha khukhilunga eikhya mu Asiya valeipulikhe eilimenyu lya nkuludeva avanu voni Avayuta navava Gilikhi. ");
INSERT INTO zgam_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Unguluve pwakhavomba ifidengho ifivaha, vulinkuvombekha mumavokho ngha Pavuli, ");
INSERT INTO zgam_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","pakhuva navavatamu va ponangha, imepo imbivi nchavahumangha vuvatolile ifitambala nei myenda einghyahumile mumbeilei nghwa Pavuli. ");
INSERT INTO zgam_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Pu valeipo Avayuta avahumya imepo imbivi vanghendangha nghendangha mukhilunga eikhyo, puvaleikhuleivombela eilitawa lya Yeisu mumbuvombeli vwavo vuvule. Pavaleikhuta khuvala avanya mepo imbivi; Valeikhuta, “Ni nchova nukhuvavula munditavwa iya Yeisu uvei uPavuli ikhundumbeleila.” ");
INSERT INTO zgam_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Avavombangha ewo vale avana va Fikeva utekhenchi Umbaha mu Vayuta, vale avana lekhela khumo. ");
INSERT INTO zgam_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Imepo imbivi nchikhamula nchikhata, “U Yeisu tumanyile uPavuli vope tumanyile; pu lieno umwe mwemwe vaveni?” ");
INSERT INTO zgam_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Pu umepo umbivi pu akhahuma khumunu ula akhavanchumbeila akhavavola amakha nukhuvatola. Pu vakhanyila ukhuhuma munyumba yeila vuvalei vubwinda nukhulemala. ");
INSERT INTO zgam_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Pu einongwa eiyei yeikha manyeikheikha khu vanu voni khuva Yuta na va Gilikhi, vatamangha ukhu khu Efesi. Pu vakhava nuvudwaanchi fincho, pulei eililavwa lya Nkuludeva pulei leikhweimeikhivwa. ");
INSERT INTO zgam_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Pu khangi avaedeikhi vu vingi vakhincha pakhupela inongwa nchavo nukhuvonia vuvule imbombo imbivii inchuva vombile. ");
INSERT INTO zgam_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Avange vavingi vavo vavombangha ineha vuhavi vakhalundani ikalata nchavo incha vuhavi puvakhanchikoncha mumwoto pavanu voni vuvilola. Avane va vile vavalile vuhavi utengonghwa kalata ncha vuhavi vakhavona ava elufu eimilevulu nghihano(50, 000) einghya ndalama. ");
INSERT INTO zgam_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Pu leino eilimenyu ilya Nkuludeva eikheilunga khyoni namakha. ");
INSERT INTO zgam_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","pu nchavile nchimalile ukhuvombekha nchooni inchi pu uPavuli akheisangheila munumbula ukhuluta khu Yelusalemu ukhunghendela khu Makedoniya na khu Akaya; Walei khu Efesi.” ");
INSERT INTO zgam_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","U Pavuli akhavasuha khu Makedoniaya avakongi va mwene vaveilei, uTimoti nu Elasito, vavo vatangile. Pu umwene yuywa pakhaseikhi akhadebe. ");
INSERT INTO zgam_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Pa seikhi unghwa khwale nu khusita khupuleihana fincho khu Efesi ukhukongana neincheila ila. ");
INSERT INTO zgam_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ulwakhuva umunu umo eilitavwa lya mwene vei Demetilio, uve ale punchi va hela ncha Nguluve Dyana, pu aleikhuvapa uvukavi avamang'anyi. ");
INSERT INTO zgam_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Pu leino akhavalundamania avamang'angi vambombo eiyo nu khuta, “Vavaha mulumanyile ukhuta mu mbombo eiya vukavi eiyi twikava indalama nyingi. ");
INSERT INTO zgam_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mwilola nukhupuleikha ukhuta, sayeilei bahapa pa Efesi, pu yeilei mu Asiya yooni, uPavuli uyu ukhuvakilivula avanu vuvingi. Pu ita ngheisikhuli eimi Nghuluve eingheipeliwe na mavokho. ");
INSERT INTO zgam_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Pu sakhukhuta imbombo eiyo yene, punakhuta eimbo yavukavi eiyo yeilei mbubapala uvwakhusita kweimeikhiwa sayeikhavombeikhanghe na yei tembile eiy Nghuluve udala uvei veimbaha u Dyana pa ivonekhangha ukhuta sivumbuleila vuvuvaha vwa mwene uvei ei Asiya nei kheilunga khyooni khikhumweimeikha.” ");
INSERT INTO zgam_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Vavile vapuleikhe inchi vakhadunghumbana nuluvipo pu vakhovela, vakhala, “u Dyana va mu Efesi vei mbaha.” ");
INSERT INTO zgam_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Pu uvunchenge vwoni vakhanunchwengho savaleikhu paleihana pu avanu vanyila pupaninie vakhingheila munyumba ya finchangho. Pu vakhavibata avanghe ncheila avanine va Pavuli, uGayo nu Alisitalikho, vavo vahumile khu Makedonia. ");
INSERT INTO zgam_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","U Pavuli anonghilwe ukhweingheila pa kheipungha khya vanu pu lieno avakongi vamwene vakhabencha. ");
INSERT INTO zgam_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Itenge navange avavaha ava pakheilunga eikhya mu Asiya avavale vamanyani va mwene vakhasuheila undomo unghukhudova ukhuta ulekhe ukhwingheila munyumba ya finchangho. ");
INSERT INTO zgam_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Pu avanu avenge valeikhuta nda avange nde pakhuva eikheipungha khya vanu khyoni khyanchangheileihine, avingi mumbene valeimwa nakhukhulumanya kheikhi vakhinchile. ");
INSERT INTO zgam_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Pu avange vakhangh'umya u Fikanda khunchi khukheipungha khya vanu pavakhambeikha pakyanya pa khipungha khya vanu. Pu umwene uFikanda akhatineila eikheivokho ukhuta pu anchove khu vanu. ");
INSERT INTO zgam_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Pu leino vavile valumanyile ukhuta umwene munu va khuva Yuta vooni pavakhovela neilimenyu leino, “uDyana veimbaha va mu Efesi.” ");
INSERT INTO zgam_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Pu usimbi va vunchenye ukhukheinunancha eikhipungha, akhata, 'Umwe mwei vanghosi va mu Efesi, veeni uvei salumanyile ukhuta uvunchenge uvu uvwa Efesi nghulo ila khwembi le ya Dyana umbaha nei kheihwani kheila eikhya nghwile ukhuhuma khu kyanya? ");
INSERT INTO zgam_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ulwakhuva imbombo inchi sanhibenchivwa pupanonghile ukhununala vuvule khisita khutingha pakhuvomba kheikhyoni. ");
INSERT INTO zgam_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Pakhuva muveilangile avanu ava pa nyumba ya vuheinghi avanu vavo savalyasi va tembile savanu avikhubeingha Unguluve veito udala. ");
INSERT INTO zgam_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Pu lieno, eingave uDemetelio na vamang'anyi uvwaleipaninie navo visinana pa munu yuyoni, inyumba ncha vuheinghi nchilimwanchi puvanghenghananghe ukwa hange avaloleli vakhilunga khyuvale. Pavanghenghiwe pavuheinghi. ");
INSERT INTO zgam_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Pu leino uve ungave vukhunchilonda imbombo nchila ukhukongana ni nchinge, puyanchivombiwa pakhitama ikhinonghela nile. ");
INSERT INTO zgam_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ncha yeilweli tuleimbupala uvwakhuheinghivwa savuli ya khumpela imbancha eyeivombikhe eilelo eiyei. Khuleinchila nongwa eiyakhupela eimbancha eiyei. Hange satukhave na makha ngha khyolelencha. ");
INSERT INTO zgam_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Pu avile anchovile inchi akhava lavulila ikhipungha khya vanu. ");
INSERT INTO zgam_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Yavileimbancha yesilile, u-Pavuli akhavilaga avakhongi nukhuvakha gancha. Pwu akhitavula nukhuhega ukhuluta khu Makedonia. ");
INSERT INTO zgam_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Wuagendile imikhoa ikhyo alikhuva khagancha avakhriste, akhigela khu Vuyunani. ");
INSERT INTO zgam_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Avile elipala khusekhi ugwa mienchi gidatu, ilisongo likhasogiwa khumwene na Vayahudi avileikhola ukhuhega khu Shamu, pwu akhalamula ukhukhilivukha ukhugenda iya khu Makedonia. ");
INSERT INTO zgam_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Avalogonchine nave mpakha khu Asia vale Sopatro, umwana va Pirho ukhuhuma uhu Berea; Aristariko na Sekhundo, voni vakiriste vakhu Thesalonike; Gayo wa Derbe; Timotheo; Tikiko nu Trofimo ukhuma khu Asia. ");
INSERT INTO zgam_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Avanu ava valogwile valikhutupulikhila ukhu khu Troa. ");
INSERT INTO zgam_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Khunjila iya fivanda ifyosafilulile, pwu amanchuva gakhano takhafikha ukhu Troa. Twatamile ukhu ifigono saba. ");
INSERT INTO zgam_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Pwuikhigozi ikhya kwanda ikhya nilungu twaviletulundamine paninie ukhumenuyla ikhivanda, u-Pavuli akhanchova na Vakrisite. Alikuwelaga ukhuta ikhega ekhegono ikya veli, pwaalikhupinchova impakha pakhilo. ");
INSERT INTO zgam_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Khwele niyale inyingi mukhiyumba ikhakhukhyanya, umwutwalundamine paninie. ");
INSERT INTO zgam_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Paridirisa atamile udemi yumo ilitawa lya mwene ve Utiko, agonelileitulu. U-Pavuli wuilumbilila udemi uyuagonelile itulu, akhagwa pasi ukhuhuma igorofa iya datu akhapembiwa wuafwile. ");
INSERT INTO zgam_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","U-Pavuli akhikha pasi, akhigolola yuywa umwene pakhyanya, akhamwibatelila. Pwu akhata, “Mleghe ukhugatala, ulwakhuva mwumi.” ");
INSERT INTO zgam_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pwu akhatoga khavile khugolofa akhamenyula ikhivanda, akhalya. Avileanchovile nao kusekhi untali mpakha wumi khya, akhahega. ");
INSERT INTO zgam_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Vakhahelikha udemi ula wumwumi vakhahovokha lweli. ");
INSERT INTO zgam_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ufwe yufwe tukhalongwile khuvulogolo khwa Pavuli nengalava tulikhuluta khu Aso, ufwe twalamwile ukhutola u-Pavuli ukhu. Ikhye kyumwene akhanogwaga ukhugenda injila iya pasi. ");
INSERT INTO zgam_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Avileatufikhile khu Aso, tukhapakhila mu Galava tukhaluta khu Mitilene. ");
INSERT INTO zgam_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ufwe tukhagatalukha wutuulumile ukho ikhigono ikya vile tukhafikha uvupande uwavili uwakhisiva ikhya Kio. Ikhigono ikhikhogile, tukhafikha khukisiva ikhya Samo, ilyakhilavo tukhafikha mumbunchege uwa Mileto. ");
INSERT INTO zgam_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ulwakhuva u-Pavuli alamwile ulugendela khu Efeso, ulwakhuva salikhunogwa ukhuyancha usikhi khu Asia; alikhunogwa ukhufikha na mbivi khu Yelusalemu khusikhu iya khwikha khwa Mepo Umbalanche, yayivalunonu umwene ukhugaha ewo. ");
INSERT INTO zgam_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ukhuhuma khu Mileto akhasuha avanu khu Efeso nukhuvilega avandyakhoni. ");
INSERT INTO zgam_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Vavile vafikhe khumwene, akhavavula, umwe yumwe mulumanyile ukhuma isikhu iya khwanda navile nikhayile apa pa Asia, uwunevile khulyumwe usikhi gwoni. ");
INSERT INTO zgam_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nimbombile Untwa khuludwado lwoni nukhulila, nuvukhuvilwa uvukhanyibite une nuvudesi uwaVayuta. ");
INSERT INTO zgam_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mlumanyile ukhuta sanelikhunchiga mie ukhunchova khulyumwe inogwa imbakha, nune nilikhuvamanyisye pavuvalafu nukhuluta inyumba ne nyumba. ");
INSERT INTO zgam_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mlumanyile une wuni khavavugaga Avayahudi ukhupele khwa Nguluve nulwedekho khu Ntwa vito u-Yesu. ");
INSERT INTO zgam_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Mlolaghe une wuni khudwada Umepo Umbalanche ukhuluta khu Yelusalemu, sanenchimayile inogwa inchakhiva naikhombona une ukhwa, ");
INSERT INTO zgam_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ulwakhuva Umepo Umbalanche ikhumbula une khila vunchege pwainchova ukhuta imireghehe nu vukhuvilwa fikhumulekhilei. ");
INSERT INTO zgam_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ulwakhuva une sagasege ukhuta uwumi wango wa maana khulyune, pwunemale ulugendo lwangu nembombo iyunapokhile ukhuhuma khu Ntwa u-Yesu, ukhulumbilila ilimenyu lya lukhugu lwa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Pwu lno, mlolage, nelumanyile ukhuta voni, vala uvunavalumbililaga Uludeva, samukhambone khumiho khaga. ");
INSERT INTO zgam_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Pwu nikhuvavula ilelo iye, ukhuta nelinchila nogwa khu khisa gwa munu aveavenchage. ");
INSERT INTO zgam_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ulwakhuva sanelikhunchiga ukhuva vula uvunogwa wa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mivinchage mikho uymwe mwevene, nakhukipuga khyoni ikhyu Umepo Umbalanche avavekhile umwe ukhuva valolile. Mivichage mikho ukhudema ikhipuga khya Ntwa, ikhyuagulile nukhisa gwa mwene yuywa. ");
INSERT INTO zgam_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nilumanyile ukhuta wuninekhegile une, imbwa in'gali nchikhwincha khulyumwe, nukhunagania ikhikundi. ");
INSERT INTO zgam_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Nelimanyile ukhuta pagati paliumwe yumwe avage avanu yuvikhwincha nukhunchova inogwa imbimbi, ukhuvakhwega avakongi vavakhogage avene. ");
INSERT INTO zgam_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Pwu nuve mikho. mkhumbukha ukhuta imiakha gedatu sanekhelekha iwe ukhuvamayisya khila munu khuyikhonchi pakhilo na pamusi. ");
INSERT INTO zgam_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Leno une nikhuvavekha khwa Nguluve, na khulimenyu ilya lukhugu lwa mene ulwuyakhiva lukhuvataga ukhuvapa uvukhale paninie navo voni avavekhiwe uvuvalanche khwa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Sanelikhunogwa indalama, idhahabu, ne mienda. ");
INSERT INTO zgam_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mlumanyile yumwe ukhuta amavokho aga gamile uvunogwe wangu yune na vunogwe wa vala uwutwalepaninie nune. ");
INSERT INTO zgam_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Khumbombo nchoni nikhavapile ikhwani umwakhuvatagila avalemilwe nu khuvomba imbombo, nukhukumbukha amamenyu ga Ntwa u-Yesu, amamenyu ugwuanchovile yuywa umwene: “Khuba ukhuhumya khulikho ukhwa mbilela.” ");
INSERT INTO zgam_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Avileanchovile ewo, akhafugama akhadova paninie navo. ");
INSERT INTO zgam_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Voni vakhalila fincho nukhugwila u-Pavuli khusingo nukhumiaga. ");
INSERT INTO zgam_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Vakhavipa fincho ulwakhuva anehovile, ukhuta savakhambone khage khumikho khavili. Pwu vakhambikhilincha khugalava. ");
INSERT INTO zgam_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Twavile tulekhehine navo, tugenda muganja, tukhafikha moja khwa moja mumbunchege kwa khukosi, ikhigono ikhyavili tukhafikha mumbunchege uwa Rodo, ukhuhuma ukhu tukhafikha mumbunchage kwa Patara. ");
INSERT INTO zgam_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Twavile tukhavile igalava iyilovokha ukhuluta khui Foinike, tukhitoga tulikhugenda. ");
INSERT INTO zgam_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Twavile tufikhe khuvulugolo khukhisiva ikhya Kipro, tukhayelekha ikhivokho ikhya khuhege, tukhagenda mpakha khu Siria, tukhagatalukha mumbunchege uwa mu Tiro, ulwakhuva ukhwa igalava vaisyaga imichiga. ");
INSERT INTO zgam_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Vutuvawene avakongi, tukhatama ukhu ifigono saba. Avakhongi ava vakhambula u-Pavuli ukhugendela khu Mepo ukhuta umwene alekhe ukhuluta khu Yelusalemu. ");
INSERT INTO zgam_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Twavile tumalile isikhu ila, ufwe tukhahega tulikhuluta. Twevoni paninie, navadala vavo na vana vavo, vakhatuvikhilincha khunjila ncheto mpakha twavile tukhumile khunji. Khuvunchege tukhafugama, tukhadova, tukhalekhehana khela munu. ");
INSERT INTO zgam_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Tukhitoga igalava, ukhu avevalikhuvuya khunjavoyo khavili. ");
INSERT INTO zgam_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Twavile tumalile isafwari yeto ukhuma khu Tiro, tukhafikha khu Tolemai. Pala tukhaponia avalukhu, tukhatama navo ikhigono khimo. ");
INSERT INTO zgam_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ilya khilavo tukhahega tukhaluta khu Kaisaria. Ufwe tukhigela munyumba iya Filipo, udumbeleli va limenyu, avealepaninie na vala saba, nafwe tukhatama paninie nave. ");
INSERT INTO zgam_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Umunu uyu alenavakhencha vane uvusavahudekhile avene valagulaga. ");
INSERT INTO zgam_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Twavile tutamile ukhu akhikha uyamalago ukhuhuma khu Vuyahudi alikhutambuliwa Agabo. ");
INSERT INTO zgam_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Umwene akhincha khulyufwe pwu akhatola ukhanda gwa Pavuli. akhikuga amalunde namavokho ga mwene nu khunchova, “Umepo Umbalanche inchova nde,” “Avayahudi ava mu Yerusalemu vikhukhuga umunu uveilolela ukhanda ugu, pwa avene vikhumbikha mumavokho ga vanyapanji.” ");
INSERT INTO zgam_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Twavile tupulikhe inogwa incho, ufwe paninie na vanu avatamaga pala tukhadova u-Pavuli alekhe ukhutoga ukhuluta khu Yerusalemu. ");
INSERT INTO zgam_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pwu u-Pavuli akhanda, “Mwigakha ndeti mwilela nukhudeya amakha gago? Ulwakhuva nilitayari, sio ukhukugiwa, hata ukhufwila ukwa khu Yerusalemu khulitawa Ntwa uYesu.” ");
INSERT INTO zgam_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ulwakhuva u-Pavuli salikhunogwa ukhuvuliwa, tukhelekhelwa ukhunchuva, “Uvunogwe wa Ntwa vikhogiwagwe.” ");
INSERT INTO zgam_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Tukhatola imielugo gweto tulikhutoga ukhuluta khu Yelusalemu. ");
INSERT INTO zgam_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Avage avakhongi ukhuhuma khu Kaisalia tukhakhogenehaninia nufwe. Vakhagega umunu yumo alikhutambuliwa Mnasoni, umunu uva khu Kipro, ukhogi uvakhatali, uvitwale nave. ");
INSERT INTO zgam_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Twavile tifikhe khu Yerusalemu, avalukolo vakhatwambilila khuluhekhelo. ");
INSERT INTO zgam_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ilya khilavo uPavuli akhaluta paninie nufwe khwa Yakobo, avadyakhoni voni valepwuvale. ");
INSERT INTO zgam_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Twavile tuvaponinche, alikhuvapa indegilo yemo yemo incha mbombo ncha Nguluve inchuavombile nifilunga ukhugendela imbombo ya mwene. ");
INSERT INTO zgam_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Vavile vapulikhe incho, vakhaginia Unguluve, nukhuvunimbila, “Wilola, lukholo, ulwiemaelfu galengi vidikhe ukhuluma khuVayuta. Voni vinogwa ukhwibata indegilo. ");
INSERT INTO zgam_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Vavuliwe uve ukhuta vumayisya Avayahudi avitama khuvuyapanzi ukhulekhehona nu Mose, nukhuta vukhuvavula valekhe ukhukoga iyikho incha khatari. ");
INSERT INTO zgam_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Tunogiwa tugahendeti? vipulikha ukhuta uve winelile. ");
INSERT INTO zgam_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Pwu uvombe khila ikhyutukhuvula lino: tuli navanu vane avavikhiwe nekhelo. ");
INSERT INTO zgam_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Vavoleavanu avawivalanche yuve paninie navene, pwu uvahombele indalama nchavene, vakhate imitwe giavene. Pwu khila munu alumanye ukhuta inogwa inchuvakhavuliwe ukhuhusu uve ncha vudesi. Vimeyila ukhuta uve vukonga indagilo. ");
INSERT INTO zgam_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Khunogwa incha vanyapanji uvuvene vavile vakilisite, tukhasimbile nukhuhumya ululagilo ukhuta vinogiwa ukhufilekha ifinu ifya khumatekhelo nukhisa, ukhuluma ulukhila ikhyuvaniogwile, vavulekhe uvuligu.” ");
INSERT INTO zgam_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Pwu, u-Pavuli akhavatola avagosi isikhu iyavile akhivalancha umwene paninie navo, akhigila Mutembile, ukhulagila usikhe ugwa sikhu incha khuevalancha impaka isadakha yekhuminchiwe khuvulila munu. ");
INSERT INTO zgam_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Isikhu incho saba nchavile chikhegelile ukhusila, Avayahudi vadebe ukhuhuma khu Asia vakhambona u-Pavuli Mutembile, avakeresite vakhavipa, valikhumwinulila amavokho. ");
INSERT INTO zgam_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Valikhu pwuta, “Vanu vakhu Israeli, tutage. Uyu ve munu uveimayisya avanu khila ponu inogwa inchilitofauti na vanu, indegilo, ncha apa. Pwu akhuvagega Avayunani Mutembile nukhupananga pavuvalanche.” ");
INSERT INTO zgam_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ulwakhuva pakhutagula vakhambwene Trofimo Mwefeso akhale nave mumbuchege, avene valikhusaga ukhuta u-Pavuli agegile mutembile. ");
INSERT INTO zgam_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Uvunchege woni vakhava nuludwada avanu vakhayilapanie nukhumwibata u-Pavuli. Vakhagumia mu Tembile, imilya gu gikhadediwa. ");
INSERT INTO zgam_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Wuvigela ukhumbuda, inogwa neivikha fikhile usikhakhali umbakha ukhuta khu Yelusalemu khwoni khudegile ifujo. ");
INSERT INTO zgam_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Usikhe ugwa akhavatola avasikhali alikhuyila khululundamano. Avanu vavile vambwene umbaha va vasikhali, na vasikhali vakhelekhelwa ukhunto u-Pavuli. ");
INSERT INTO zgam_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Umbakha vavasikhali akhakhegelela akhamwibata u-Pavuli, akhalamula akhugiwe imiregekhe gevile. Akhambucha umwene veni na agakhile khikhi. ");
INSERT INTO zgam_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Avanu palulundamano valikhupwuta uyuge ili uyuge ulwakhuva ambakha va vasikhali savavule khinu ukhukogana nu ywego. Akhalagila u-Pavuli vagelikhe munyumba. ");
INSERT INTO zgam_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Avile ifikha mugeto akhatoliwa na vasikhali ukhuhumana nifujo ncha vayalulumdamano. ");
INSERT INTO zgam_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ululundano lwe vanu valikhukoga nu khupwata, “Mugenche uyu!” ");
INSERT INTO zgam_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","U-Pavuli avileikhelekhiwa mugati akhambula umbakha va vasikhali, “Niwesya ukhukhuvula ikhinu?” Umbakha va vasikhali akhata, “Winchova ikhi Yunani? ");
INSERT INTO zgam_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Uve, siyo veve Imisiri uvealonginche uvutulanogwa, akhatola avabudi elfu nne khufwimba?” ");
INSERT INTO zgam_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","U-Pavuli ukhata, “Une nili Njahudi, ukhuhuma mumbuchege uwa khu Tarso iya khu Kilikia. Une nilivambunchege uvuvakha, nidova, mnavuleninchove na vanu.” ");
INSERT INTO zgam_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Avile umbakha va vasikhali antamile, u-Pavuli akhima mugeto akhahumya eishala khuvanu khukhivokho khya mwene. Ulwale mie, akhanchovanavo khukhi Ebrania. Akhata, ");
INSERT INTO zgam_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Valukholo lwago, numwe vadada vango pulekhincha ukhwetetela khwango nivomba lino khulyume.” ");
INSERT INTO zgam_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ululandamano vavile vapulikhe u-Pavuli inchova navo ikhiebrania, vakhanunala. Akhanchova, ");
INSERT INTO zgam_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Une nilinjahudi, nikholiwe mumbunchege uwa Tarso mukijiji ikhya Kilikia, naembile isyule mumbunchege umu, mumalunde aga Gamalieli. Namayesiwe ukhukhogana ni njila inonu incha ndagilo incha vadada veto. Une nilinamakha ga Nguluve, ndumwe uwu mulewo elelo. ");
INSERT INTO zgam_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Navatesinche khunjila iyi mpakha ukhufwa; nikhavakhuga avagosi na vadala nukhuvavekha mubalasa. ");
INSERT INTO zgam_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Untwa umbakha na vadyakhoni voni viwesya ukhunchova ukhata napatile ikhalata ukhuhuma khuvene khwajili yavalukholweto avalikhu Damesiki, une ukhuluta ukho. Yale nivagege avanu khu Yelusalemu khu njila yila yila vakhugiwe nukhutowiwa. ");
INSERT INTO zgam_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Yikhahumila, unsiki navilenigenda nifikha khu Dameski, usinchi ugwa pamusi ulumuli uluvakha lukhahumila khu khyanya lukhategula ukhumulekha. ");
INSERT INTO zgam_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nikhagwa pasi nukhupulikha ilimenyu ilikhumbula, 'Savuli, Savuli khikhi vukhug'alancha?' ");
INSERT INTO zgam_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nikhanda, 'uve veve veni, Dada?' Akhambula, 'Une nene Yesu va Mnazaleti, uviuve vukhug'alancha.' ");
INSERT INTO zgam_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Vala avelapanie nune vakhaluvona ulumuli, savakhapulikha ilimenyu lya ula uviachova nune. ");
INSERT INTO zgam_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nikhata, 'Nigakhe ndakhikhi, Dada?' Udada akhambula, 'Ima ukhigele khu Damesiki; ukhwa vunchivuliwa khila khinu ikhya khuvomba.' ");
INSERT INTO zgam_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Sanawesye ukhulola ukhuhomana nulumlula, pwunikhuluta khu Dameski vakhayibata amavokho vala avale paninie nune. ");
INSERT INTO zgam_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Ukhu gagana nu munu uviatambuliwa gwa Anania, ale munu aveimbite indagilo na adwadiwagwa khu Vayahudi voni avatamaga ukho. ");
INSERT INTO zgam_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Akhincha khulyune, akhima khuvulogolo khulyune, akhata, 'Lukhululwagwa Savuli, ulologe.'Usekhe gula gula nilikhulola. ");
INSERT INTO zgam_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Akhata, 'Unguluve uva dada veto akhuhalile uve unelimaye inyikho ncha mwene ukhumbona ula ugolofu, nukhupulikha ilimenyu ilikhuma mudomo gwa mwene. ");
INSERT INTO zgam_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ulwakhuva wivasaidi va mwene khuvanu voni khunchila inchochiwene nukupulikhawe. ");
INSERT INTO zgam_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Basi sasa kwa nini unasubiri? Ukhasukhe inogwa nchakho, wilagage ilitawa lya mwene.' ");
INSERT INTO zgam_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Avile akhiliwikhe khu Yerusalemu, navile nikhyisaya mutembile, ikhahumila nigogilwe injonsi. ");
INSERT INTO zgam_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nikhambona akhambula, 'Ulwu huma mu Yerusalemu nambivi, ulwakhuva savakhidikhe ukhulumbiliela khwakho ukhuhusu une.' ");
INSERT INTO zgam_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nikhata, 'Dada, vavo avene valumanyile navakhugile mubalasa nukhuvatova vala avaisaya mtembile. ");
INSERT INTO zgam_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Nu nkhisa ugwa Stefano usaidi vaka une, naemile pawipi nukhwidikha nilikhulidilila imienda g'avala avambuda.' ");
INSERT INTO zgam_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Pwu akhambula, 'Lutaga, ulwakhuva une nikhukhusuha ulute khuvutali khuva nyapanji.'” ");
INSERT INTO zgam_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Avanu vakhatavula anchove ilimenyu ili. Pwu vakhategula ukhupwata nukhuta, “mung'enche umunu uyu mkhilunga: ulwakhuva sio lweli atamage.” ");
INSERT INTO zgam_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Vavile vipwata nukhutaga imienda giavo nukhutaga ulufumbe khukhyanya, ");
INSERT INTO zgam_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","usikhali umbakha akhalamula u-Pavuli vag'elikhe munyumba. Akhalagela avunchiwoge khunu itoviwa ifibokho, umwene alumanye ukhuta khekhi vikhupwatela vule vule. ");
INSERT INTO zgam_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Vavile vakhugile nemilegekhe, u-Pavuli akambola ula uakida uveaemile pawipi numwene, “Pwu! lweli khulyumwe ukhutova umunu bila ya kug'ega?” ");
INSERT INTO zgam_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","U akida avileapolikhe amamenyu aga, akhaluta khusikhali umbakha nukhumbula, “Winogwa ukhugakha dakhekhi? Ulwakhuva umunu uyu ni mrumi.” ");
INSERT INTO zgam_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Usikhali umbakha akhincha akhambula, “Umbule uve ulimunu vakhu Roma?” U-Pavuli akhanda, “Ena.” ");
INSERT INTO zgam_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Usikhali umbakha akhanda, “Nakhominche indalama inyigi pwagapata uvulaia.” Pwu u-Pavuli akhambula, “Une nilindumi ukhuholiwa.” ");
INSERT INTO zgam_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Avale tayali ukhuluta khukhumbunuha vakhaliga vakhandekha vakhegula gala. Nu sikhali akhadwada avile alumayile uPavuli Mrumi, ulwakhuva akhugiwe. ");
INSERT INTO zgam_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ikhegono ikhyakogile, usikhali umbaha akhanogwa ukhulumanya uwayelweli inogwa incha Vuyuta ukhusu u-Pavuli. Pwu akhasodula indegekhe akhalagila avatwa na vakhegi voni vagane. Akhagega u-Pavuli pasi, akhambikha pagati pavene. ");
INSERT INTO zgam_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","U Paulo akhavalola avanu avahieghi nukhuta, “Valukholo lwango, nitamile phamiho ga Nguluve khumasage amanonu ukhudugha eilelo.” ");
INSERT INTO zgam_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Untekhenchi umbaha u Anania akhavavula vala vavo avaiemile pawipi phamwene vantove pandomo ugwamwene. ");
INSERT INTO zgam_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pwu uPavuli akhambula, “UNguluve akhuta ayikhukhutova uve, ulwimato uluvamati nu ng'angha umbalafu. Uve atamile vukhng'iegha ukhunkhongha nululaghilo, pwu vutavula ukhuta nietoviwagwe ululaghielo vusalwita?” ");
INSERT INTO zgam_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Vala avaiemile pawipi numwene vakhanchova, “vumuhkudhukha ewo undongonchi umbaha uva Nguluve?”. ");
INSERT INTO zgam_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","upavuli akhanchova, “valukhololwango, une saniekhalumanye ukhuta uyu vintwa umbaha, ulwakhuva liesimbiwe, salanchova fivi khuvalongonchi vavanu vako.” ");
INSERT INTO zgam_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Upavuli avielealumanyile uluvafu lumo lolile akhavona vamasadukhayo na avange vama falisayo, akhatoncha iliemunyu nukhunchova, “valukhololwango, line nili falisayo, nili nswambe va mafalisayo, pa inchi nihuvila khumakha uluvonekelo ulwa avafwile uvunihiegiwa nawo”. ");
INSERT INTO zgam_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Avile anchove aaga, eisongelehinie imbaha yikhahumila khuva mafalisayo nava masadukayo, na avalundamine vakhagavika. ");
INSERT INTO zgam_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Kuva masadudukayo vita lusikhuli uluvonekhelo, avasukhwa vasikuli munumbula, apange ava mafalisayo incho ukhuta punchile. ");
INSERT INTO zgam_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ukhupuliehana khukhava khusikhuli muvasimib uvuvale khuluvafu ulwava mafalisayo vakhima nukhu nchova, valikhuta, “satukhiwene khinu iekhivivi muugaati munu uyu, ndakhikhi ingave umepo apange unsuhwa anchovile numwene? “. ");
INSERT INTO zgam_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Unsiekhi upwulukhahumile ulupango uluvaha, umbaha va ligoha adwadile ukhuva upavuli vakhale vikhubuda nukhukhegetania na vene, pwa akhamu khuvasikhali vikhe pasi vakhampiembe khumakha ukhuhuma kuvahiegi valibalasya, nukhunglilikha kuboma. ");
INSERT INTO zgam_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ikhilo iyakhongile linkuludeva akhiem pawipi numwene akhanchora,” uladwadaga, ulwakhuva unchovile mu yelusalamu, pwu nayufue tunchivonesya uvulweli mu roma inongwa incha khubudiwa khwa pavuli.” ");
INSERT INTO zgam_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","vuvukhile, avayahudi avanghe vakhijiagha nukhwikho tila vavoi vakhata svakhalye nu ukhunywa khinu upwuvakhieva vibudu khw pavuli. ");
INSERT INTO zgam_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Khwale na vanu avalutilile khuatobini vavo valondagha injila inchakhubuuda. ");
INSERT INTO zgam_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Vakhaluta khuvavaha va vantwa na vaghogholo nukhunchova, “twiviekhi ijufwe mundukhoto uluvaha, tulekhe ukhulya khinu impakha upwakhiva tubudile kwa pavuli. ");
INSERT INTO zgam_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Lieno, avahieghi vambule lindoghonchi umbaha avalighoha andete upavuli khuvene, ndumunu uviilamula ukhumala ienongwa ijamwene vunonu ufwe tupulikhela twietesaniche ukhumbuda vusafike upwutuliepho pwapha.” ");
INSERT INTO zgam_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ulwakhuva umwana vang'anchave va pavuli akhapulika ukhuta vilonda ukhubuda, akhaluta akhingila mughaati muboma akhambula upavuli. ");
INSERT INTO zgam_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Upavuli akhamwilangha umbaha yumo akhanchova, “mntole udiemi uyu khwa kumbahu valigoha, ulwakhuva alienilimenyu ilyakhumbula.” ");
INSERT INTO zgam_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Pwu umbaha akhantola udiemu akhang'ielika khumbaha valigooha akhambula, “upavuli uvyakhungiwe anyielanghele niekhugeghe vindiemi uve khulyuve. alinilimenyu ilyakhukhuvula.” ");
INSERT INTO zgam_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ula undongonchi umbaha akhamwibata eikhivoko akhima nave palukanji, nukhumbuncha, “khinu khikhi ikhiwinogwa ukhumbula?” ");
INSERT INTO zgam_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Udiemu ulakanchova, “avayahudi vanchovie ukhukhudova uvahilikhile khilavo upavuli khuvuhighi ndukhuva vinogwa ukhunchimanya inongwa nchamwene mumbulweli. ");
INSERT INTO zgam_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Uve ulekhe ukwidika ulwakhuva khuvale avanu valutilile khuarobaini vieyuvilile. vikhungile ulukhoto, ukhuleka ukhulya na khukhunywa amaghaasi iempaka vabude. ata uluu valiemiho vipuliekhila, uve uvatavulile. ");
INSERT INTO zgam_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Pwu umbaha valighoha akhandeka undiemi ula aghodokhage akhambuli “ulekhe ukhumbu umunu uviavenchagha ukhuta umbulile inchi”. ");
INSERT INTO zgam_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Akhavitanga avatongonchi vavile akhavula mukhavatesanie avasikali avamia avile ukhuluta khukaisaria na vasikhali avakhimanyile ukhutoghaifarasi sabini, avanyangoha avamia vavile, mwuehege pakhilo unsienki ugwaa isaa idatu. ");
INSERT INTO zgam_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Akhavavula vatesanie ifikha nu fifyo upavuli ayivombela nukhuvitola vunonu khw feliki untwa. ");
INSERT INTO zgam_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Akhasima ikalata ndee. ");
INSERT INTO zgam_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Klaudio lisia kuntwa limbalanche feliki, lighonile. ");
INSERT INTO zgam_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Umunu uywa aibatiwana vayahudi alondiwe ukhubudiwa, punikhaluta nikhipuga ikya vasikhali nikhampokha, navile nipulikhe ukhuta munu va khutoma. ");
INSERT INTO zgam_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nanoghile ukulu manya ukhuta khikhi vikhungilega, pwu nikhang'ieka khuvuhighi. ");
INSERT INTO zgam_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nikavono akhahigiwagwa kundaghilo nchavene, sakhasitakhiwe khulimenyu ilyavienchaga ilyakhuta abudiwagwe nukhukungiwa. ");
INSERT INTO zgam_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Pwu nchikhavonike pavuvalafu palyune ukhuta une nene nilonda injila inchakhumbuda umwene, pwanikhansuhile khulyuve iembive, pwunikhavasukhile avikhung'iega valete inchuvikhunghegha umwene pavulongoto pako. valikhubielukha.” ");
INSERT INTO zgam_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Pwu vala avasikhali vakhidikha ululagilo, vakhantola upavuli vakhangielikha khu antipathi pakhilo. ");
INSERT INTO zgam_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ikhigono ikhikhakhongile, avasikari vingi vakhavatekha vala avikhetoga ifalasi valutage pwupaninie mumwene, ewene vakhagoodoka khuvene ukhuvitama. ");
INSERT INTO zgam_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Avikietoka ifalasi vavile vafike khu kaisali, nukumpa untwa ikalata, vakhangielika upavuli pavulongo pamwene. ");
INSERT INTO zgam_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Untwa vuiembi ikalata, akhambuncha upavuli ahumile ikhilunga khilikhu; Avile alumanyile ukkhuta munu va khu kilika, ");
INSERT INTO zgam_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","akhanchova, “nikhukhu pulihinchaga uve akhieva vikijincha avakhakhusitakhile”, akhavatavula vambikhe mu nyumba iyantwa herode. ");
INSERT INTO zgam_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Vufilutile ifighono fihano, unaniya utnekhenchi umbaha, mungaati mbavaha avagogoto na unchofi yumo uvievita vie teltulo, akhaluta pala. avanu avaa vagheghile einongwa iya pavuli khukuludeva. ");
INSERT INTO zgam_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Upavuli vuiemile pavulongolo pa nkuludeva, uteltulo akhatengula ukhunsitanki nu khujoova khwa nkhuludeva, “ulwakhuva veve tulienulu nonchehencho uluvaha, khumasagho alinienyevonekhelo ghagho aghighegha uvusyetulo uvunonu mnkilunga kyietu; ");
INSERT INTO zgam_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Khulusano iwoni tukwupielila khilakhinu iekyuvuvomba, nikhukhuponia viendwanchiwa feliki. ");
INSERT INTO zgam_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Saniekhakhusakhinche ukhulutiliela, nikhukhudova wiemulihinche ninchove padebe agiilocha khulyuve. ");
INSERT INTO zgam_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ulwakhuva umunu uyu imbivi hange insongelehani veikhuvavikha ava-yahudi voni ukwitengha khilunga hanghe viendonghonchi vamipelela igya va-wanazoloyo. ");
INSERT INTO zgam_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Hange agelile ukhuviekha wuvivi mpelela pwutukhamwibata, uvusimolie mumbusimbe uvunonu awakatale). (nchingahiencha; uvusimbe uvwu ");
INSERT INTO zgam_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Lisiasi, likhuludeva, ainchile akhantola khumakha mumavokho gietu, na mumbusimbe uwavighwle vunonu uwakhatale). ");
INSERT INTO zgam_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ungambunche upavuli kyumbmboinchi sakhalumanye khulikhikhi akhinu eikyuvikhung'iega”. ");
INSERT INTO zgam_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Avayahudi vope vakhansitakha upavuli, v akhata imbombo inchi nchikhale ncha lweli. ");
INSERT INTO zgam_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Untwa akhinula ikhivokho ukhuta upavuli anchove, upavuli akhamula, “nilumanyile ukhuta khwu mijiaka imingi ukhale ndamuli vakhilunga iekhi, nilienuluhekhelo ukiviyelesya yune khulyuve. ");
INSERT INTO zgam_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Vukhuluanya ukhuta safilutile ifighoono khinchigo na fivile ukhuhuma upunalutile khukwiesaya kuyelusalemu. ");
INSERT INTO zgam_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Vuvambwene muntembile, sanakanihane numunu, khange sanavombe uvugalo mnkutano, numumipelela na munkilunga; ");
INSERT INTO zgam_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Na savakhawesye ukhunchova vwayile khunongwa iinchuvikhung'iega une. ");
INSERT INTO zgam_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ulwakhuva paiele nikwiedika khulyuve, ukhuta khulungendo lula uluvaeilangile umpelela, khulungeendo lululwa nikhumbombe laga u Nguluve uvadada veitu. une nilimwiedikhi khugooni agaalindlagielo na mbusiimbe uwavanyamalongo. ");
INSERT INTO zgam_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nilienamakha galagala khwa u Nguluve, uguu na vope vikhunchuka uwavafwile, khuvoni avalivuvuli imbivi na avalienimbivi voni; ");
INSERT INTO zgam_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","khwu ilie nayune ni vomba imbomba khuta nive ninumbu inchiilambivi pavulongolo wa Nguluve napamiho pavano ukhugeendele imbombo nchoni. ");
INSERT INTO zgam_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Leino vugielutile imyakha vugielutilile ninchile kuleta ulutangielo nkiilunga kyago nukhuvonola nindalama. ");
INSERT INTO zgam_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Navile nievombile iewo, avayahudi avange avakhu asia vakhambona vunielinduhekhelo ulwa wumi mungaati mutembile, vuvasipali avanu vingi khange pakhava myiee. ");
INSERT INTO zgam_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Avanu ava uvuvakhanogile ukhuva pamiho ghakho lieno ulwa vanchove ukyuvalienakyo ikyango ndavalienesela ayavinchaga. ");
INSERT INTO zgam_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Apange avanu ava vanchove eikyuniekhanangile iekyuvakhiwene khulyune vuneimile pavulongolo pavuhigii uwa va yahudi; ");
INSERT INTO zgam_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ukhuva nikhanchovile iekhinu khimo khumakha upwuniekhimile pagati pavene, “ulwakhuva uvuchukha uwavafue umwe mukhung'iega.” ");
INSERT INTO zgam_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Ufeliki akhavuliwe vunonu injiela, pwakhae lulekha ululundamano akhanchova “lisia nkuludeva akhiva itolga ukhuhuma khu yelusalemu pwuyunilamu ukhuhiegiwa khulyume.” ");
INSERT INTO zgam_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Pwu akahalamuta untwa andolelage upavuli, hange ave nunsiekhi alekhe umunu uvakhuvabencha avamanyani vamwene ukhuta valekhe ukhuntanga hange valekhe ukhungeendela. ");
INSERT INTO zgam_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Vufilutile ifighono fidebe akhincha undala vamwene u-dlusila uviale injahudi, khasuha khukhumwianga upavuli apulihinche amamenyu agalwidiko mungaati wa klisite uyesu. ");
INSERT INTO zgam_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Upavuli vuvinchovana numwene mumbulweli, ukhuleka ukhulutilila akhiva vilamula pavuhighi uvukwincha, ufeliki akhava nuvundwanchi akhamula, “lutaka khuvutali lino, nienghapate unsiekhe nikhukwilangha. ");
INSERT INTO zgam_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","unsiekhe ugwaa ahuile ukhuta upavuli ikhumpa indalama pwa akhamwilangha khanghe akhachova nave. ");
INSERT INTO zgam_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Imyaka ghewile vughisilile, upolkio ufesto akhava nuntwa khandekha efeliki, ulwakhuva ufeliki unogwa ukwihegelencha khuvayahudi, pwakandekha upavuli mwondyongomencho. ");
INSERT INTO zgam_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Vuu ufesto ainghile mukhilungha khila watmile ifigono fidatu pwakhaluta khu kaisali akhafika khu yelusalemu. ");
INSERT INTO zgam_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Untwa umbaha uva va yahudi undwanchiwa vakhang'elikhila inongwa iya pavuli khwa festo, pwu vakhanchova vakholehencha nchoninamakha khwa festo. ");
INSERT INTO zgam_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Vakhandoova ufesto nikhisa khu mamenyu agha pavuli ukhuta amwielange khu yelusalemu ukhuva vinogwa ukhumbuuda upavuli munjiela. ");
INSERT INTO zgam_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","U Festo akhavavula akhata upavuli akhungiwe mukaisari, nukhuta navope ayivuya khukhukwa imbieve. ");
INSERT INTO zgam_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Anchovile “ulwakhuva, vala aviwesya, ukhuluta ukwa nufwe. inave khukhile ikhinu ikhivivi khumunu uyuu, mlondiwa ukhung'iega.” ");
INSERT INTO zgam_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Vuvatamile ifighono nane nukhulutila, akavuya ukaisari. ikhighono ikyankongile akhatama pakhighoda ikyavuhieghi nukhulamula ukhuta vandete upavuli khumwene. ");
INSERT INTO zgam_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Avile afikhe avayahudi ukhuhuma khu yelusalemu vakhima pawipi, pwu vakhanchova imbombo inongw inchieluteilile inchakhumbikha mbuhiegi vvuvivi nchimanyile. ");
INSERT INTO zgam_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Upavuli akhabela akhanchova, sanchakhulitawa ilya vayahudi, sanchakesari, nivombile imbivi.' ");
INSERT INTO zgam_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ulwakhuva ufesto anogwagwa ukhuta avoneeke inonu kuvayahudi, pwu akhamwanda upavuli akhata, nawigwa ukhuluta kuyelusalemu khuhiegiwa nune khumbombo inchi? ");
INSERT INTO zgam_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Upavuli akhanda akhanchova, “nikwiema pavulongolo pakhigoda ikyavuhieghi ikya kaisari upwupilondiwa une ukhuhighiwa. sanievakhosehinche avayahudi nduvulumanyile. ");
INSERT INTO zgam_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Inave nielininongwa pwu ienghave nivombile nilondiwa ukhuhigiwa ukhufwa, sanibela ukhufwa. ulwakhuva uvuhieghi wa veine khulyune vusikhuli, asikhuli umunu uviwesya unkhunglielikakhuvene. nikhundova ukaisali. ");
INSERT INTO zgam_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ufesto wa nchovile navahiegi akhamula, “vukhundova ukaisali, uyuwiluta khwa kaisari.” ");
INSERT INTO zgam_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Vufilutile ifigoono, untwa uaglipa nu belnike vakhincha kukaisalia, ukhugeendela ufesto. ");
INSERT INTO zgam_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Vuvatamile apo ifigono fingi, ufesto akhahilikha inongwa ya pavuli khu ntwa, akhata, “umunu yuoma vakhandekhile apha pha feliki ndumunu uvakhungiwe. ");
INSERT INTO zgam_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Upwunikale khuyelusalemu avantwa avavaha na avaghogholo avakivu vayahudi vakhaleta inongwa incha munu ouyu khulyune, navene pwuvaliekhuvuncha ukhuhigiwa khumuuyu umuvahigiele. ");
INSERT INTO zgam_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Une nikhavamula nikhata salulaghilelo ulya valoma ukhung'umya umunu vusapanogilele ukhung'umya. ");
INSERT INTO zgam_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Pwu vavile vinchile apa pupaninie, saniekhawesye ukhupulikiela, apange ikhigono ikhikhankongile nikhatama pakhigoda ikyavuhiegi nukhulamula ukhuta umunu uywa vagheighe mughati. ");
INSERT INTO zgam_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Unsiekhi avansitakhagha vuviemile nukhunchova, nikhasaga nikhata nchisikhuli inongwa imbaha inchakungliegha nchincho valetiele inchakhung'ega umunu uyu. ");
INSERT INTO zgam_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Puvakava, nukhubenchana numwene khulwiedikho ulwavene ulwa yesu uviafwile, hange upavuli akhavavula ukhuta mwumi. ");
INSERT INTO zgam_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Niekhale ninisisilile ukhunchinghahiencha ienongwa ieyi, nikhambuncha iengave ayiluta khu yelusalemu khuhiegiwa khunongwa inchi. ");
INSERT INTO zgam_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Upavuli vuielangiwa ukhuva vambikhe pavuloleili vuvipulikhila uvulamunchi wa ntwa. ");
INSERT INTO zgam_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Uaglipa akhanchova nu Festo “nikhanogilwa ukhumpulihiencha umunu uyu” ufesto akanchova, akhata “khilavo uyuvukhumulihincha”. ");
INSERT INTO zgam_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","pwu intondo, uaglipa nu belnike vakhincha nuluhekhelo lwingi; vakhafika khuliboma ilyavavaha avasikali avaligoha, na vanu avanyamakha pakhiluga. nu ufesto wahuminche ululagielo, ulwakhundeta upavuli khuvene. ");
INSERT INTO zgam_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ufesto akhanchova, “untwa uaglipa, na vanu voni vavo pwuvale apa pwupaninie nufwe, mukhumbona umunu uyu; ululundamano lwoni ulwa vayahudi ulya khu yelusalemu napa vanogile ukhuta nivatange, na vene pwu vakhatoncha ilimenyu ukhuta umunu uyu vakhufwa. ");
INSERT INTO zgam_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","nikhavona sakhavombe khinu ikyakhunanga ukhuta nifwe; ulwakhuva amwilangi untwa, nikhalamwile ukhumbika khumwene. ");
INSERT INTO zgam_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Nilivuvule khitu ikyakwandika khuntwa. ulwakhuva une niendetile khulyuve uve, vintwa viegbipa, ukhuva nive nikhinu ikyakhusimba khunongwa ieyi. ");
INSERT INTO zgam_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ulwakhuva nilola nivona sakhulikhinu ikyakhuhilika unkungwa walivuvule inchakhung'iega ukhuhiegiwa. ");
INSERT INTO zgam_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","U Aglipa pwakhambula uPavuli, `Akhata lieno vuwesya ukhunchova. 'Pwu uPavuli akhinula ikhivokho kyamwene akhitetela. ");
INSERT INTO zgam_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Akhata nikhipuliekha luhekhelo, Mumbwumi wango, Vitwa Eglipa, ukhuva eilelo puninchovanikhetetela inongwa nchango inchuava Yahudi vakhang'iegaga une. ");
INSERT INTO zgam_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ulwakhuva uve uliemanyi unchimanyi indagielo ninchu vivuncha. Pwu nikhukhudova wiemuliekhenche nukwiyumilincha. ");
INSERT INTO zgam_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Lweli, Avayahudi voni vamanyi uune ukhuhuma uvudebe namumikhulile gyango mukhilunga kyango khu Yelusalemu. ");
INSERT INTO zgam_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Une vamanyile ukhuhuma khuvutengulilo vanogiile ukwidika ukhuta undumbilieli, mumpelela ugulinulwedienkho ululuti mumbuklisiti wienyo. ");
INSERT INTO zgam_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Leino nimile aapa pakhuhigwa ulwakhuva une nilola ululagielo ulwa Nguluve avombile khuvadada vetu. ");
INSERT INTO zgam_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ulu lululagielo lulwa ifikoolo fwietu khinchigho nifivieli fihuvile ukhupokele inave fikwupilila ienava finkhumwidikha Unguluve nukwiyumilincha pankhilo na pamusi. Ni kwa ajili ya tumaini hili, mfalme Agripa, kwamba Wayahudi wananishitaki. ");
INSERT INTO zgam_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Khukhuta khikhi muugaati ndyumwe musaagaa ukhuta nchiva ncha khudegha ukhuta Unguluve inchusya avafwile? ");
INSERT INTO zgam_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Unsiekhi ugwinge nasagiele yune ni mwene ukhuta ninogiiiwe ukhuvomba imbombo nyingi incha litawa ilya Yesu uva mu Nasaleti. ");
INSERT INTO zgam_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Nivomba inchi mu Yelusalemu; Navakhungile aveidikhi avingi avavalanche nikhava na makha agaakhutamula ukhuhuma khuvavaha va vatekhenchi vuvibudiwa une nene niliekhulamula. ");
INSERT INTO zgam_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Papingi navatesinche vuvali mtembile nchavene ukhuta vabelaghe ulwidiko ulwavene. Nikhava nilyoyo ilaluvipo ulukali khuvene khange nilikhuvaswema munkhilunga ikya khuvugeni. ");
INSERT INTO zgam_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Vunivombo inchi, nalutile ku Dameski, vunielina makha nindagielo ukhuhuma khuvalumbili avavaha; ");
INSERT INTO zgam_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","vunielimunjila pamusi, Untwa ninkhavona ulumuli ululuti khulinchuva lukhamulikha ukhunjula une na vanu uvutwa geendanga nnjela nune. ");
INSERT INTO zgam_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Twivoni tukhagwa pasi, pwuniekhapulikha ilimenyu linchova nune munjovela iya Khieblania: `Savuli, Savuli! Khikhi ikyuvukunesya? Khupala khulyuve ukhuvanya nilivalo khunchokoo. ");
INSERT INTO zgam_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Pwu nikhanchova, 'Uve veveni, Nkuludeva?' Unkuludeva akhamula, 'Une nene Yesu yuune vukhuneesya. ");
INSERT INTO zgam_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Lino wieme na malunde ghakho; ulwakhuva uvunogwe wango une nievonike khulyuve, niekhuhalile ukhuva imbombi nukhuva inchovi khumbombo iyuyimanyile ieyango lino nie mbombo nchincho uyuniekhukhuvonesyaga pavulongolo; ");
INSERT INTO zgam_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","khange nikhukhupoka khuvanu uwayikhiva nikhukhusuha Avankilunga ukwakhiva nikhukhusuha, ");
INSERT INTO zgam_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ukhuvadiendula amiho gaavene nukhuvahencha iehisi ukhuloncha khulumulu nukhuhuma khumaka agaa ntavangwa ukhuta vamwidikhe Unguluve; ukhuta vupiliele ulusyiekhilo ukhuhuma khwa Nguluve uvusyiekhilo uwa mbivi nuvuhale. ");
INSERT INTO zgam_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Ulwakhuva, vintwa Eglipa, saninkilwe une unkhujileka ienyevonelo incha khukyanya, ");
INSERT INTO zgam_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ulwakhuva, khuvala avakhatamaga khu Damesika, nakhu Yelusalemu na avankhilunga kyoni ikya Yudea, na vanu avange avafikholo ifinge, nikhavalumbilile ukhuta vanchileke imbivi vasayiwe vasyetuke vankonge Unguluve, vavombage imbombo inchikuvavonesya ukhuta vikhudwada Unguluve. ");
INSERT INTO zgam_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Kumbombo incho Avayahudi vakhanyibata mutembile, valikhunogwa ukhumbuda. ");
INSERT INTO zgam_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Unguluve anangile puunoefikhile aapa, pwu nikwima nukhunchova khuvanu voni avanini na vavaha khu nchila inchuvachovile avanyamalago nu Musa vanchovile ukhuta inchi nchilavoneka; ");
INSERT INTO zgam_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ukhuta uKlisite alatesekha hange alatala ukhunchuka ukhuhuma khuvufwe nukhuvonesya ulumuli khuvavu Avayahudi na khuvanu amufilunga. ");
INSERT INTO zgam_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","U Pavuli wamaliele ukhunchova ukwipala, uFesito pwakhanchova akhatoncha ilimenyu ilievaha, 'Pavuli, ulienulunkwale! uluhala lwako uluwiembile lukhupiele ulunkwale. ");
INSERT INTO zgam_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","U Pavuli akata, Une sanielinulukwale, Fesito; vindwanchiwa ulwakhuva winchova incha wanyielweli nchene. ");
INSERT INTO zgam_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ulwakhuva vintwa ulumanyile khwu mbombo inchii; pwuninchova saniedwadwa khumwene, ulwakhuma nilumanyile ukhuta khiesikuli iekhefihime khumwene, ulwakhuva eile salikhavombekhaga kuvutitu. ");
INSERT INTO zgam_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Te, uve Pavuli, vukhuvidikha avanyamalago, Untwa uAglipa? Nielumanile ukhuta vukhumwidika. ");
INSERT INTO zgam_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","'U Aglipa akhambula uPavuli, 'Khwu nsiekhe udeebe vuwesya ukhunchova nune ukhuta nipiendukhe ukhuva Nklistie? ");
INSERT INTO zgam_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","U Pavuli akhanchova, '“Nikhundova Unguluve ukhuta, khunsiekhi unsupu apange untwali, syo uve viemwene, avanu voni avinkhumolieka ielelo vave ndune, hange savakhave niendegehe incha mukheikhungwa.” ");
INSERT INTO zgam_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Untwa pwa akhima, nu mbombi, nu Bernike, vope navakhatamile pwupaninie navo, ");
INSERT INTO zgam_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","wuvuvahegiila valikhunchova vavo valikhuta, 'Umunu uyu sapanogile ukhuta afwe nakhukhukhungiwa.' ");
INSERT INTO zgam_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","U Aglipa akhambula uFesito akhata, “Umunu uyu akhalondiwa alekhe ukhuloleliwa ave ndunonchehencho akhale uvuvopolwa khwa Kaisali.” ");
INSERT INTO zgam_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Vakhavile valamwile khuta uyutugeenda mumagasi ukhuluta khu Italia, pwu vakambikha uPavuli navankhungwa avange vakhampa umbaha valighoha ilya Kiloma uvivatinchaga vie Julio, uvakhipuga ikya Agusitani. ");
INSERT INTO zgam_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Tukhatoga mungalava ukhuhuma khu Adlamitamu, lyageendaga mundunkhanji munyanja iya Asia. Pwu tukhingila khunyanja. U Alistako ukhuhuma khu Thesolanike iya Makedonia akhaluta pwu paninie nufye. ");
INSERT INTO zgam_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ilinchuva ilyakhongile tukhima khu Sidoni, khukwa uPavuli ambombile uwipa pwu akhantavula ukhuluta khuvamanyani vamwene khukwupila uwipa wavo. ");
INSERT INTO zgam_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Vutuhumile apo tukhageenda munyanja tukhanchungula ikhiesiwa ikya Kiplo ikya diendile ukhuluguto, ulwakhuva unkhuluguto gwale pwuguli. ");
INSERT INTO zgam_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Vutugeendile mumagaasi agaale pawipi nakhu Kilikia na khu Pamfilia, tukhincha khu Mira, ikhielunga ikya Lisia. ");
INSERT INTO zgam_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Pala umbaha valigoha ilyo Kiloma, akayivome ingalava iyihumile khu Alexandlia yiyo yikhale yakhuluta khu Italia. Akhatupakhila umwa. ");
INSERT INTO zgam_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Twageendile malamola amanchuva galutilile ulugeendo ukhava luvivi salwanogelanile tukhahegelela khu Kinidasi, unkuluguto gwale mmbaha tukhalemwa ukhugeenda, pwu tukhageenda mundukanji kanji pasi pa Klete tukakhingila khu Salmone. ");
INSERT INTO zgam_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Twageendile mulukhanji munyanja khuvutatamu, pwutukhingila ukhuvita Fali Haveni ukwa khuliepawipi niekhilunga ikya Lasi. ");
INSERT INTO zgam_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Twangeendile amachuva mingi inoo, unsiekhi ugwa Avayhudi vaielekhilwa ukhulya unsiekhi ugwakwielekela ukhulya guukhava gulutile. Pwu khukava nuvudwanchi ukhuva tungeendage. Pwu uPavuli akhatukhilivula, ");
INSERT INTO zgam_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","akhanchova akhata, “Mwivagosi, nilola nivona ulugeendo ulututengula uyuyiva mbivi hange uyuyiva yakhuyaga, sanita ifivo ifyutugeegile nie ngalava navuwumi weitu.” ");
INSERT INTO zgam_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Umbaha valigoha ilya Khiloma umbaha vamwene nu munu unyangalava, akhajilekha ukhunkonga nchila inchuanchovile uPavuli. ");
INSERT INTO zgam_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ulwakhuva upwuvafikhile sapanogiele ukhutama unsiekhe ugwa mepu, avavombambombo avamungalava tugeenda ukhufikha ukhu, tungietange ukwingiela khukhilunga ikya Foinike, tukhatame ukhu unseikhe ugwa mepu. Khu Foinike khulikhulukanji khu nyanja khu Klete, yilkola khunena khuvuhumo na khusikha khuvuhumo. ");
INSERT INTO zgam_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Imepo incha kusika vunchitengwile ukhupula malamola, avavombi va munyanja vakhasaga vakhata vakhavile khila ikyuvakhalondaga. Vakhahencha ingalava vakhatengula ukhughenda khulukhanji khu Klete ukhuhegelela khu maghasi amadhebe. ");
INSERT INTO zgam_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Vutukhinile padebe gukhatengula unkhuluguto, ugwuvatili gwu gwa kunene khuvuhumo, gwukhakhula khumakha. ");
INSERT INTO zgam_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Pwu ingalava yiekhalemwa ukhugeenda ukhuva ukhulughuto gwale mbaha, tukhidiehana nienchihumila gwukhatutola nayufwe. ");
INSERT INTO zgam_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Tukhanyila uluvafu ulunghe khukhisiva ikyuvatichaga Kauda; twatigile ieno ukhupoka uwato. ");
INSERT INTO zgam_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Vuvawesinche ukhuhwega, nululeghehe uluvakhungile mungalava. Vadwadile ukhuta tukhale twiluta khunsanga ugwa Syiti, vakhimikha vakhatoliwa vule vule. ");
INSERT INTO zgam_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Twatoviwe nu mbele, twavile tugonile pavusikhu avavombi va mngalava vakhatengula ukhutaga iminchigo khunji ukhuhuma mungalava. ");
INSERT INTO zgam_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ikhigono ikyadatu avavombi vamungalava vakhatengula ukhutuma magasi namavoka gaavene. ");
INSERT INTO zgam_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ilinchuva nie nondwe sanchavonekhe khufigono fingi, ukhuluguto nu mbelo guuliekhukhula tukhava vanu vakhata ukhupona khusikhuli. ");
INSERT INTO zgam_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Vuvatamile unsiekhi intali khisita khulya ikyakhula, uPavuli pwa khima akhata, “Vagosi, mukhale mumulihienchage une samukhale mwihencha ingalava ukhuhuma khu Klete, ukhungaikha kyoni khukhale kyuvi khusikhuli. ");
INSERT INTO zgam_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Lino nita muve vanu vakweikhasya ulwakhuva asipali umunu uvyakhiva iyaga ingalava yuyinangikha. ");
INSERT INTO zgam_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ulwakhuva ikhilo iyielelo unsung'wa va Nguluve, yuywa une nilievamwene, hange une vininkhusana vyakhimile palukhanji palyune ");
INSERT INTO zgam_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","alikhuta, “Uladwadaga Pavuli. Upwu wukwimaga pavulongolo pa Kaisali, hange ulole, Unguluve khukhisa kyamwene akhupile avanu voni uvumugeendanjila nuve. ");
INSERT INTO zgam_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Mwie, vagoosi, mwikhasyage, ulwakhuva nikhumwidiekha Unguluve, ulwakhuva uyunchiva nduvuniekhavulile. ");
INSERT INTO zgam_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Khumbe tutakhiwa totoviwe khufisiwa ifinge.” ");
INSERT INTO zgam_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Vuyiefikhe iekhilo iya kumi na nne, avavombi vamungalava vutwiyuuga ukwa nukiwa khunyanja iya Adlatik, pakhilo pagati avavomba mbombo avamungalava vakhasaga vakhata apange tuliepakhufika khukhilunga ikhilievuvule amagasi. ");
INSERT INTO zgam_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Vakhavombela ilimenyu ukhulihania ukhulola uvutali pasi pamagasi vakhavona ikhipimilo khita salasini na sita, vakhalihania khange vakhavona ifipimilo ishilini na saba. ");
INSERT INTO zgam_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Vakhatala vakhadwada ukhuta uyuutukhietika mulunalawe vakhisya ifyombo fine ukhuma uluvafu ulwakwimiencha puvalikhudova ukhuta vukhale vukhinchage iembeevi. ");
INSERT INTO zgam_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Avavomba mbombo vamungalava pwu valiekhulonda ukhuyielekha ingalava palapala, vakhisya uwato uwakhuvapoka ukhufwa, vakhava vilaha khuvulongo khuwato. ");
INSERT INTO zgam_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","U Pavuli pwalikhuvavula avalonghonchi avalighoha ilya Khiloma na vasikhali, “Samukhawesye ukhupona hange avanu ava visigala mu ngalava”. ");
INSERT INTO zgam_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Pwu avasikhali vala vakha dumula iemilegeehe igya wato vakhavulekha vukhagwa mumagasi. ");
INSERT INTO zgam_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Vuvuliepakhukya, uPavuli akhavadova voni valye ikyakhula. Akhanchova, “Eekhi khigono kya khinchigho nifine mwikhina khitalya khinu. ");
INSERT INTO zgam_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nikhuvadova mtote ikyakhula khidebe mulye, ulwakhuva khuvupokhi weinyo, ulwakhuva asikhuli umunu yuywa akhiva lwihega uluywiele lumo khuntwe. ");
INSERT INTO zgam_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Avile anchovi eiwo akhatota, akhatota eikhisyesye akhansana Unguluve pamiho pavene. Akhamanyula ikhisyesye akhatengula ukhulya. ");
INSERT INTO zgam_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Voni vakhanogwa pwu vakhatola ifinu vakhalya. ");
INSERT INTO zgam_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Mungalava twate twivanu 276. ");
INSERT INTO zgam_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Vavile valile vakhigwuuta, valikhutola einganu valikhutaga munyanja ingalava yilikhuva mepe. ");
INSERT INTO zgam_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Yuvile yievile musi pwu vakhalalumnya ukhuta valikhukhilunga inkhincha magasi hange pwu valikhuvona ikhilunga ikhingile mugaati magasi ikhili nunsanga umwingi. ");
INSERT INTO zgam_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Pwu valikhunchova ukhuta inave viwesya ukhugeendencha ingalava ukhuluta ukhwa. Pwu valiekhuhudula iendeghehe nukhunchilekha munyanja. Unsiekhi ugwa valikhudula indeghehe incha ngalava nukhupiemba khuvulongolo ukhuluta ukhuyileikho imepu, pwu valiekhuhegelela khunsanga. ");
INSERT INTO zgam_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Vakhahegela khuvulongolo vakafika aponu upwu amaga agaa inyanja ivieli nchagiine. Ingalava pwu yikhima yiliekhulemwa ukhugeenda pwu yikhatengula ingalava ukhudenyeekha ulwakhuva umbelo gwale mbaha. ");
INSERT INTO zgam_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Avasikhali vanchovine ukhuvabuuda avankungwa voni, ulwakhuva akhee iva asipali umunu yuywa akhale iwesya ukwogela nukhuhega aponu apo. ");
INSERT INTO zgam_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ulwakhuva unsikhali valigoha ilya Kiloma alikhunogwa ukhumpoka uPavuli, pwakhimikha inchuvasagiile; pwa akhatavula vala aviwesya ukwogela, vanyele ukhuhuma mungalava vatale ukhuluta ukhugasikhuli amagasi. ");
INSERT INTO zgam_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Pwu avagosi avange valiekhulonda umwakhumile ukwieyibatilila mumbavo na mufinu ifinge ukhuta vahume mungalava. Vavile vagahile ewo pwu vakhapona voni vakhahuma vunonu khunji khukoa amagasi gasikhuli. ");
INSERT INTO zgam_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Vutughendile vunonu, putukhalumanya ukhuta ikisiva khila vitambula ukhuta malta. ");
INSERT INTO zgam_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Avanu avaponu pala vakhatupokhela nu lughano ululutilile, vakhakhoncha umwoto vakhatupokhela nie niemepu ni fula yiliekhutima. ");
INSERT INTO zgam_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Upavuli akhahagala inyagala unjigho akhakhoncha pa mwoto, munjigho gwa nyagala yale muyile injokha iyeilinugoda unkhali yiekhakhuma munyagala khumafuke ghaa mwoto, pwu yikhienianga mukhievoko kya mwene. ");
INSERT INTO zgam_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Avanu avenyeji va pala, vuvawene injokha ijielumbela mukhivoka, vakhavulana vavo vakhata, “lweli umunu uyu iva imbudi atolwikhe khu nyaja, sapanogile ukhuta atamage nkilunga.” ");
INSERT INTO zgam_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pwu upavuli akhayitahita injokha iela mumwoto khange sayandume. ");
INSERT INTO zgam_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Avene valiekhulolela ukhuta khifimba ikhivoko pwu ingwa nukhufwa imbievie. hange vuvalolile khwu nseikhi untali vakhavona sakhuliekhinu ikhihumila khumwene, vakhatengula ukhusaga vuunge nukhunchova ukhuta akhale Nguluve. ");
INSERT INTO zgam_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Upavule pala pawipi pale nikyalo ikhivaha kyale kya mbava va khisia uvivahtambulaga ukhuta vie pablio, uviatupokliele vunonu nukhutuliesya amanchuva gadatu. ");
INSERT INTO zgam_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Udadaye ua pablio akhatamwa liliekhuvava eilitumbu alikhuhaliesya. upavuli akhaluta khumwe akhadoovela, akahavieka amavoko pantwe gwa mwene akhapona. ");
INSERT INTO zgam_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Vuvalolie inchi inchihumile, avanu avingi avamukhisiva khila avale vatamuvakhaluta vope vakhapona. ");
INSERT INTO zgam_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Avanu valiekhutudwada khulisima ilivaha. vutwikhola ukhuhega tugeendage, vakhatupa ifinu fyoni ifyutwalonga. ");
INSERT INTO zgam_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Vugiesilie imyeenchi geidatu tukhageenda mungalava iya isakanda yiyobomoliwe niemepu pala pakhisiva, yiyo avalongonchi vayene vale mapasya vavile uyunge ale vie kasta nu polukusi. ");
INSERT INTO zgam_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Twavile tufikhe khukhilunga ikya silakusa, twatamile pala amachuva gadatu. ");
INSERT INTO zgam_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ukhuhuma pala tukhageenda tukhafika khukhilunga ikya legio, vulilutile ilinchuva limo imepo iya khusikha yiekhincha imbieve, tukhagenda manchuva gavili tukhilkunga ikya putoli. ");
INSERT INTO zgam_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ukwa tukhavavona navalukhololweto, vakhatupokhela vunonu tukhatama nawo amanchuva saba pwutukha hegha ukhuluta impakha khu roma. ");
INSERT INTO zgam_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Avalukhololwetu avakhu loma vuvapulikhe inongwa nchitu, vakhincha khukhotwupilila khuliguunchi ilya apiasi upwuvieta “migahava giedatu”. vakhansana u Nghuluve. ");
INSERT INTO zgam_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Vutufikhe khu loma, upavuli vakhatavula ukhutama mwene nundindilinchi uviandolelaga. ");
INSERT INTO zgam_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Vughlutile amanchuva ghudatu upavuli akhavielanga avaghosi uvuvale valongonchi muva yahudi. vuvinchile paninie, akhanchova akhata, “valunkololwangwa une sanienangile khinu khulyumwe khuvanu ava apange ukhuvomba umusavakhanogwagwa mumigeendele igya dada vienyo avatalile, une vanoili ndunkungwa ukhuhuma khu yelusalemu ukhugugaa mumavokho agavaloma. ");
INSERT INTO zgam_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Avene vuvikhumbuncha valikhuvona nilievuvule einogwa valikhunogwa inchikhumbiekha ukhuta niehigiwe ukhufwa. ");
INSERT INTO zgam_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ulwakhuva avayahudi vakhanchova vakhapiendula umuvienogwa avene, une pwuniekhadova kwa kaisari, khuta inongwa yango yilutage kuvulongolo, ulwakhuva sanaleta inongwa ya nkilunga kyango. ");
INSERT INTO zgam_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ulwakhuva natile inongwa yango yillutaghe kuvulongolo, pwunikhadova ukhuta nienchove numwe. ulwakhuva uluhuvilo lwa islaeli lukhungiwe nunyololo. ");
INSERT INTO zgam_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Vakhambula vakhata, “satwupilile inkhalata ukhuhuma khuvayahudi iyiekhukhunchova uuve, hange asikhuli ululkololwo uvieinchile kwinchova eilimenyu eilivivi eililoncha khulyuve. ");
INSERT INTO zgam_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Leino pwutwinogwa ukhupulikha khuluyve vusaga khihki khuvanu ava, ilwakhuva guupuliekhikhi khwoni ukhuta savikhwidihana ukhukhongana. ");
INSERT INTO zgam_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","vakhavika ielinchuva ilyakhuchova nu vanu, avanu valikhutunga valiekwincha upualeikhutama ukhuma vuwikya ukhuduga iyakhimihe, pualikhuvavula inongwa incha yesu ni ncha ludeva ulya Nguluve, ukhuma mundagielo incha mose navanyamalago. ");
INSERT INTO zgam_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Avanu avange wu valikwidihana nagiichoviwa avange valiekhubela, savaliekwidihana. ");
INSERT INTO zgam_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Vuvalemilwe ukhupuliehana vavo vakhahega, vavile vihega upavuli akhanchova ilieminyu limo “umepo umbalanche anchovile vunonu khuvadada vienyo ukhugendela unyamalango uisaya incha ntwa uyesu. ");
INSERT INTO zgam_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Akhata, ulutage khuvanu ava ukhatiinchage, “khumbulukhutu nchiento mupulikhagha hange samukhanchimanyage; khumiho gienyo muiolaga hange siimukhanchinovage. ");
INSERT INTO zgam_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ukhuva inumbula incha vanu ava ndekhedekhe, imbuluukhutu nchaveni sanchipulika vunonu, amiho gavene, nukhupulikha khumbulukhutu nchavo, inumbua nchavo nchilumanyage nukhusyetukha une nikhuvapokha. ");
INSERT INTO zgam_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pwu mulumanye ukhuta, uvupokhi uwa Nguluve vulutile khuvanyapanyi hanga uyuvikhumpuliekha.” (Unchingahienche: uvusimbe uvu ");
INSERT INTO zgam_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Unsienkhi uguuvavulanga amamenyu aaga, avayahudi vakhahega, vakhava nienchakwievuncha imbava mumbene). ");
INSERT INTO zgam_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Upavuli atamili munyumba yieyo yale sayamwene imyaakha gievile, alikhuvapo khela voni avaluutaga khukhuombona. ");
INSERT INTO zgam_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Avombaga ukhulumbiliela uvuntwa uwa Nguluve hange aliekhumanyisya inongwa incha ntwa uyesu klisite khumakha goni, akhava asipali uviekhunsinga. ");
INSERT INTO zgam_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ne Paulo, nembombi va Yesu Klisite yune nilaghiwe ukhusuhiwa, nukhulekhehana ne livagili lya Nguluve. ");
INSERT INTO zgam_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Ele lyu livangili ililyanchoviwe khatali na vouyamalango vamwene mumbusimbe uvuvalanche. ");
INSERT INTO zgam_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Nchinchova umwana va mwene, uveakholiwe mukhivumbukho ikhya Daudi khunjila eya mbili. ");
INSERT INTO zgam_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Umwene anchoviwe ukhuta Mwana va Nguluve khuu makha ga mepo umbanche khuluvoneklulo lwa vafwele, u Yesu Klisite Dada veto. ");
INSERT INTO zgam_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Khugendela umwene tupokhile uvupokhi wa kusuhiwa nu wedesi uwa lwidekho panie nekhe khelunga, khulitawa lya mwene. ");
INSERT INTO zgam_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Pagati pa khilunga ekhi, nayumwe mwelagiwe ukhuva va Yesu Klisite. ");
INSERT INTO zgam_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ikalata eye ya mwevoni yumwe mtama khu va Rumi, vagane nu Nguluve, mwaelagiwe ukhuva vanu vavalanche. Ulukhugu luve kwenu, nu lugano ukhuma kwa Dada veto na khuswambe uYesu Klisite. ");
INSERT INTO zgam_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Mumbologolo nikhundemya uNguluve vago khwa Yesu Kliste khuliumwe mwevoni, ulwakhuva ulwedekho lulombeliliwa mukheluga vyoni. ");
INSERT INTO zgam_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Ulwakhuva u Nguluve isaidi vango, uvenikhumbombela ni numbula yango, kulimeyu ilya mwana va mwene, nduwu nitama ukhuvatambula. ");
INSERT INTO zgam_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Daima nchoni nidova muyesayo nchago ukhuta khujela iyavenchaga ninche nive numwe khukya khulya mwe. ");
INSERT INTO zgam_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ninogwa ukhuvavona, ukhuta nevape efikhogelwa fya numbula, ninche nivayilenche. ");
INSERT INTO zgam_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Pwu ninogwa nekhave amakha paninie numwe, khunjila iya lwidekho lwa khila munu. ");
INSERT INTO zgam_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Lino valukholo, saninogwa mlemwe ukhulumanya ukhuta, ukhuta imesekhe mingi nesagile ukhincha khulyume, lenosesigiwe. Nikha nogwaga lino ukuva nisekhe khulyumwe ndawuyelekhu vanu ava khilunga. ");
INSERT INTO zgam_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Nidayiwa na vayunani na vahesya, avalemale na vapelwa. ");
INSERT INTO zgam_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ulwakhuva une nilitayari ukhulumbelela elimenyu khulimwe nayumwe mwemulekhu Roma. ");
INSERT INTO zgam_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ulwa khuva sanivona soni khulimeyu, ulwakhuva makha ga Nguluve ukhutopokha khukhila munu uveekhwedekha, khua vayahudi avakhwanda na khuva Yunani vope. ");
INSERT INTO zgam_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ulwakhuva wayelweli wa Nguluve vuvonikhe ukhuma ulwedekho, mpauha ulwedekho, nduwuyesimbiwe, “Unya lwidikho itamaga nulwidikho.” ");
INSERT INTO zgam_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Ulwakhuva uvuhegi wa Nguluve vuvonikhe ukhuma kukhyanya ni mbivi nuvutola nogwa woni uwa vanu, uvuvivi wifikha uwayelweli. ");
INSERT INTO zgam_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Ulwakhuva, goni givonekha khwa Nguluve galipavuvalafu khuvene. Ulwakhuva uNguluve owavulile. ");
INSERT INTO zgam_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Imbombo ncha mwene enchosanchi vonekha vunonu nchivile pavuvalafu ukhuma khiliwa ulimwenguni. Khikwelevekha ukhugendela ifinu ifipeliwe. Imbombo incho makha ga mwene khihumana nu vufwa uwa khukhuma kuvutegulilo wa vuNguluve. Ukhuma, avanu ava viva vanchila vulegefu. ");
INSERT INTO zgam_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ulwakhuva, va mayile uNguluve, savandolelage umwene khama Nguluve, savalikhusana, vavile vakhoyofu khumasage gavene, ni numbula nchavo incha vukhoyofu yaigile ekhisa. ");
INSERT INTO zgam_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Valikhwiyilaga veuiyaluhara, vakhava vapelwa. ");
INSERT INTO zgam_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Vakhalwandulania uvufwa wa Nguluve uvunchila vunagi khuvihwani khya munu uveanagikhe, ndiefidege, amakhanu akhayama lunde gane, ni fikhano ifikhwa fula. ");
INSERT INTO zgam_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","U Nguluve akhavalekha vakhogage uvunogwe wa numbula nchavo imbivi, emivili givo kilikubediwa. ");
INSERT INTO zgam_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Na vene vayadwile elweli ya Nguluve ukhuva vudesi, valikhwesaya nu khugevombela imiguluve igige vakhandeka upelivavo, uviekhwi mekhiwa isikhu nchoni. Amina. ");
INSERT INTO zgam_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ulwakuva, u Nguluve avalekhile vakhogage imbimbi nchavo enchiyasoni, ulwakhuva vaandulinie imbombo encha khatali vakha nchilekha incha khatali. ");
INSERT INTO zgam_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Vulevule, avagosi vakhanchilekha imbombo nchao ncha khatali khuvehe vavo nu khuva nu vuligu khuvene vavo. Ava vagosi khuva gosi ewavombaga inchi sancho nogelanile, valikhutole ulukoto khumbombo nchavo. ");
INSERT INTO zgam_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ulwakhuva vabelile ukhuvanu Nguluve khuluhala lwavo, avalekhile vakhogage lyale, nchao imbivi, vavombage imbombo incho sanchinogelanile. ");
INSERT INTO zgam_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Vadigile nuvutulanogwa, uvuvivi, uvunogwe uvuvivi, vadigile uvunogwe, uvubudi, imbancha. Uvusyovi, na amasage amavivi. ");
INSERT INTO zgam_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Vavo vavile vasyovi, ava khehi navi khukalalila u Nguluve. Avayambancha, amatingo, ulwiginio, avene vavombo imbivi, nu vusavikhuva dwada avahonchi vavo. ");
INSERT INTO zgam_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Avene vanchila lukhala, savikhwidekha, vanchila lugano ulwa khwanda, vanchila lugano. ");
INSERT INTO zgam_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Vanchimayile indagilo ncha Nguluve, ukhuta vala avivombo imbombo incho, vanegiwa vabudiwe. Inave vivombo imbomob incho pwu viva vikhweelehana na vavo vivomba imbo incho. ");
INSERT INTO zgam_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ule vovole uluhusa, yuve wikhega inungwa, ulyakhova yuve wikhega agavanino wikefunga yuve, ulyahuva yuwe wikhega wiwomba gagago. ");
INSERT INTO zgam_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ulyahova tulumanyile khota uvokhegi wa Nguluve wayelyeli khuvavo vivomba amambo kama aga. ");
INSERT INTO zgam_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Uvewe usage uele, uvewikhega khuvawo vivomba imbombo incho nayove wiwomba amambo gagago. Poyowukhepa uvokhegi uwa Nguluve? ");
INSERT INTO zgam_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Apange wisaga sana khunyingi inchavombile uNguluve, ukhuncheliwa khuadhabu ya mwene, nuwovumefu wa mwene? sulumanyile ukhuta uvononu wamwene, wukhuhuvula khuhusayiwa? ");
INSERT INTO zgam_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Khuvogumu wa numbula yakho ugulevovole ulyesayo, wikhevehela yuve eakiba ya uwoheyi ukhisu uvukhegi khusihu yela yawo wonesiwa wa wokhegi yawolyeli ya Nguluve. ");
INSERT INTO zgam_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Umwene ikhopinchaga khela munu ekhepimo sava ninogwa ncha mwene. ");
INSERT INTO zgam_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Khuwawo valenowoyelweli na mambo amanonu vilonda esifa uludwado nukhunangekha, ikhuvapa uwomi wa sihu nchoni. ");
INSERT INTO zgam_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Kuvawo vihetenga, vavo savidwada uwoyelyeli vinogwa uhupoliwa uwukhegi nelyoyo elikali yikhwincha. ");
INSERT INTO zgam_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","U Nguluve ayitwala etabu khumunu uyivomba imbivi, khunchandi tasi, numyuna tena ");
INSERT INTO zgam_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ulyeginye, uvodyado eamani yikhuja khumunu iyivomba inonu, khumuyahudi na nyunani. ");
INSERT INTO zgam_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Uluva khosiholi ukhupendela, ulugano khya Nguluve. ");
INSERT INTO zgam_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Khuvange vakasinche ululagelo viyaga bila lulagelo, khuvale avange vakosije ukhukosa ulu lagelo, ayavikegiwa khululagelo. ");
INSERT INTO zgam_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Avavipoleka ululagelo avanya wolyeli kuvulongolu khwa Nguluve, vavo viwomba ululagolo yavivaleliwe uvuyelyeli. ");
INSERT INTO zgam_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Kuvanu vakelungu, avalevovole ululagelo vivomba kutabia ululagelo, avene vavile lulagelo kunumbula nchaivwo, avene valevovole ululagelo. ");
INSERT INTO zgam_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Yivoneka ukuta amambo khululagelo ghandechiwe igati munumbula nchavene. ezamili, yavene yikhovahega avene, amasage gavene vavo au ukhuvahega vikhuvedema vavo. ");
INSERT INTO zgam_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Nukhua Nguluve. Aga ayagikhomela khosihu inchiyaha ikhega inogwa ncha vanu voni, sawa nelimenyu lya mwene, khwa Yesu Klisite. ");
INSERT INTO zgam_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Tunchove tute wikheyelanga yuve myahudi, uyatamile mlulagele, usangelela ukhusifu uNguluve. ");
INSERT INTO zgam_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ulumanye ulugano lya mwene, ukhupina amamba uguletofauti nago khuliho ukhulagenchiwa nu lulagelo. ");
INSERT INTO zgam_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Tunchove tute ulekhafu khuyuve vemwene ulendongoji khepofu, ulumuli khuvavo va lemuhisi, ");
INSERT INTO zgam_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","uyisahihisya avanchila lohola, umanyisi va vana, nukhuta ulenalyo ululagelo nuvumanyisi uwayelyeli. ");
INSERT INTO zgam_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Yuve, vukhondombelela uyunge sawihemanyisa yove? Yuve wilombelela ukhuhencha, uveve savukhencha? ");
INSERT INTO zgam_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Yuve winchova ukhuta savuvomba uvuligu, savuvomba? yuve wikalala ekhehwani, savuhencha khukanisa? ");
INSERT INTO zgam_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Yuve wikheginya khululagelo, savuhonyongonyola u Nguluve khwa hudenya ululagelo? ");
INSERT INTO zgam_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Khulimenyu lya Nguluve eliwenyu linangekha huvanu va kelunga husababu yeto,” ndowayandikhiwe. ");
INSERT INTO zgam_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ukhuhakikisiwa khwawoyelyeli hunogiwa ungakongongage ululagelo, ungawe savukonga ululagelo, ukhoha khwaho khwivasio khwohoha. ");
INSERT INTO zgam_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Angave umunu asayiwe, ikhwendelela ukhwibala ululagelo, ukhwesaya khwa mwene hiwva sahuvoneha ukhuta ikwesaya. ");
INSERT INTO zgam_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Nu mwene iyikhwesaya khuasili alalakhegiwa angatimesye ululagelo? Uwo wosimbe uwaandekhiwe ne tohara bado ulesaliti va lulagelo. ");
INSERT INTO zgam_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Umwene sio myahudi uya vile vahonji, uhutahiliwa sio khuahonji tu kumbele. ");
INSERT INTO zgam_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Umwene Myahudi uva gati ne, tyesoyo lya gati, munumbula sio ndimenyu, ulyeginyo ulya saluhumana na vanu lyukhoma kwa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Pwu Myahudi ikhava khehi? Ukhukhekhetiwa khwikhava khehii? ");
INSERT INTO zgam_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Lononu fincho khela njela. Khuvwutengulilo, avayahudi vapevilwe ulovonekhelo ukhukhuma khwa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Pwu yayiva ndeti ingave Avayahudi avange valevovole ulwedekho? ukhu sitakhwedekha khwavene khukhokhovekha uvugolofu wa Nguluve ukhuva vovivi? ");
INSERT INTO zgam_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ate padebe, ulwa khuva, nndekhe Nguluve avonekhe ukhuta va yelweli, ndayeve khela munu nn'desi. Ingave umuyasimbiwe, “Ukhuta pwu uvonekhe ukhuva ulevayelweli mu mamenyu gaakho, ukhulotelela vwuvukhwingela pa vukhegi. ");
INSERT INTO zgam_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Engave imbivi nchetu nchivonesya elweli eya Nguluve, pwu tute khekhi? uNguluve si mbivi vwu ikhumya elyoyo lya mwene khukhuta ale evo? Ninchova ukhukhumana na lweli yavwu munu. ");
INSERT INTO zgam_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Ate! ndakhekhi u Nguluve umuyakhiva ikhikhekhega ekhilunga? ");
INSERT INTO zgam_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Engave lweli ya Nguluve ukhugendela uvwodesi vwango ikhumia ulwiginio khu mwene, khekhi nipi khegiwa ndu ntula nongwa? ");
INSERT INTO zgam_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Khekhi tunchove ndu vovya tudeteliwa na avange vikhwedekhana ukhuta twinchova, “Tuvombe imbivi, pwu ginche amananu? Uvukhegi khuvene vwa yelweli. ");
INSERT INTO zgam_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Khenu khehi? Ukhwetetela yofwe? Losikhuli, ulwa khuva ufwe tuvadetile avayahudi na Wayunani voni paninie, ukhuta vale pasi pa mbivi. ");
INSERT INTO zgam_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ele ndavovwalesimbiwe: Asikhiwi uvayelweli, nu uve aliyumo. ");
INSERT INTO zgam_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Asikhuli umunu yuywa ikhweliwa. Asikhuli umunu uveikhondonda u Nguluve. ");
INSERT INTO zgam_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Voni vasyetwikhe, voni paninie wakhosinche ulwedekhano. Asikhuli uveivomba inonu na aleomo. ");
INSERT INTO zgam_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Emisingo gya vene vuguli uvole mwanchi. Indimi incha vene nchidetile, ugoda gwa njokha guli pasi mumilomo gya vene. ");
INSERT INTO zgam_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Emilomo gya vene gedekhile ulukhoto nu luvavo. ");
INSERT INTO zgam_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Amalunde ga vene ginyilela ukhududa ukhisa. ");
INSERT INTO zgam_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Uvunangi nu vukhuvilwa filimnjila ncha vene. ");
INSERT INTO zgam_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Avanu ava savayemanyile enjela ya lweli. ");
INSERT INTO zgam_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Lusimuli uludwado lwa Nguluve pa mikho gavo.” ");
INSERT INTO zgam_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Leno tulumanyile ukhuta khyokyoni ekhenchoviwa nu lulagelo, khinchova khuvavo valepasi palulagilo pwu khela ndomo gudendiwe, pwu ekhelunga khyoni khendondage u Nguluve. ");
INSERT INTO zgam_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Ulwa khuva gusipali umbeli uguyakheva guvaleliwa vwa yelweli khu mbombo ncha lulagelo khu mwene. Ulwa khuva ukhugendela mu lukhwincha ulukhala lwa mbivi. ");
INSERT INTO zgam_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ulwa khuva leno bila lulagelo, elweli ya Nguluve yemanyikhikhe, yavonikhe khululagelo lwa vanya malango. ");
INSERT INTO zgam_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Eye yu lweli ya Nguluve ukhugendela elweli eya Yesu klisite khuvavo vikhumwedekha. ");
INSERT INTO zgam_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Ulwa khuva voni vavombile imbivi nu khuva nu uvuvalanche vudebe uvwa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Vavaleliwe uvwayelweli vulevule khu lukhungu lwa mwene khu njila iya vupokhi vuvwa vule mwa Klisite Yesu. ");
INSERT INTO zgam_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Ulwa khuva u Nguluve ang'ominche u Klisite Yesu ave lusayano khu njila ya yelweli mu nkhisa gwa mwene. Ang'ominshe Klisite ndu ntangeli va yelweli eya mwene, ukhunchisye khela inongwa inchilutile. ");
INSERT INTO zgam_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Pa khwiyumilincha pamwene aga gone gakhumile pwu elweli ya mwene yevonekhe khu misekhe ege. Eye yale pwu ivonesye uvwa yelweli vwa mwene, pwu livonekhe ukhuta ikhombalela umunu alavenchaga elweli mwa Klisite. ");
INSERT INTO zgam_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Pwu khulindakhu ukhwiginia? khulekhekhine khu mbombo ilekhu? Ulutu lwa mbombo? Ate, ulutu lwa yelweli. ");
INSERT INTO zgam_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Pwu tumalela ukhuta umunu ivaleliwa elweli khu luhungu hetavomba imbombo incha lulagilo. ");
INSERT INTO zgam_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Tute uNguluve avile Nguluve va Wayahudi vene? Umwene savile Nguluve va vanu va khilunga khyoni? Eena va khilunga khyoni. ");
INSERT INTO zgam_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Yengave ya lweli u Nguluve aleyomo, alavavalela elweli avakhekhetiwe huluhungu, na vavo savakhekhetiwe khu njila eya luhungu. ");
INSERT INTO zgam_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Pwu ufwe tukhulwandula ululagilo lwa luhungu, ate ufwe tukhulwedekha ululagilo. ");
INSERT INTO zgam_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Twichova khikhi khwa Abrahamu, ubaba veto khunjila ya mbili, avomnikhe? ");
INSERT INTO zgam_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Pakhuva u Abrahamu avalilewe ei lweli khunjila ya mbombo akhali eva nekhinu kya khwigin'wa sio khumiho ga Nguluve. ");
INSERT INTO zgam_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","UAbrahamu amuidikhe u Nguluve akha valili wa ei lweli ukhuva lweli. ");
INSERT INTO zgam_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Lino khumunu uvivomba ei mbombo uluhombo lwa mwene saluvaliwa ukhuva lusayo, ila gwiva ikole. ");
INSERT INTO zgam_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Nakhumunu uvivomba ei mbombo nukhumwidikha ula viavaheliwe ei lweli, yuywa sio igolofu, ulwidekho lwa munu uywa luvalili wa ukhuva haki. ");
INSERT INTO zgam_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","U Daudi vope inchova ulusayo pakianya pamunu uvi uyu u Nguluve ambalile ei lweli khunjila ya mbombo. ");
INSERT INTO zgam_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Achovile, “Vasayiwe vala avaimbivi ncha vene n'chisekheliwe nisambi n'cha vene n'chigube khiliwe. ");
INSERT INTO zgam_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Asayiwe umunu ula uvi u Nguluve sikhu mbalila uvutula nongwa. ");
INSERT INTO zgam_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Puulusayo ulu lwa vanu ava keketwe vene, emo khuvala avasava keketiwe, pakhuvatwi n'chova, khwa Abrahamu ulwidikho lwa mwene luvaliliwe ukhuva lweli.” ");
INSERT INTO zgam_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Pu avaliliue ndeti vu badusu keketiwe, ewo vusaakeketiwe? Salemumbu kegete vu badu sakeketiwe. ");
INSERT INTO zgam_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","U Abrahamu apokhile alama hwani eikhwa khusita ukhu keketiwa gula gwali ei ng'uli gwa vuvilweli wa lwidekho uluale nalo tayari, vabadu sakeketiwe uluvonekhelo ulu vale njila ya khuvonekha ukhuva baba va voni. Avi khwidikha hata ndava ngave badu sava keketiwe. ");
INSERT INTO zgam_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Eyi yavonisye ukhuva uAbrahamu avombikhe ukhuva baba va vukeketie sio khuvala tu avavinogwa ukhu keketiwa bakhoila kuvala avavikhu n'chi konga ingendele n'cheto n'cha baba vito u Abrahamu. nulu lwidekho uluake nalwo khuvala ava savakeketiwe. ");
INSERT INTO zgam_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Pakhuva salwale lulagilo ululwa home n'chiwe khwa Abrahamu na vana va mwene, ulwidehano ulu salwale ukhuta viva nuvu halie wa khilunga, ila lwale ukhugendela ei lweli ya lwidiko. ");
INSERT INTO zgam_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Eingave vala ava ndagilo vuva vu hale, ulwidiko lwiva lusipali ei ahadi yave yebadelekhe. ");
INSERT INTO zgam_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Pakhuva indagilo n'chileta uluvipo, pakhuva pala upu ululagilo ukhupulikha khu sikhuli. ");
INSERT INTO zgam_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Khunjila eiye luleta ulwidikho ili luve khukhisa, pwu ululagilo ulu lwiva pavuvalafu pakhi vumbukho khoni navaholiwa ava sio vala avan'chi manyile eindagilo, ila vala ava lwidekho lwa Abrahamu. Pakhuva umwene vibaba veto twivoni. ");
INSERT INTO zgam_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Pakhuva vegiwe ei lwakhuta ni khukhuvikha u veve ukhuva baba vavingi ukhu konga khila eikhinchoviwe u Abrahamu ale uvo, pande waula ava amwidikhe yaani uNguluve uvikhuvapa avafyile uwomi nukhugavikha agasipaliukhwa pugale. ");
INSERT INTO zgam_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Paninei nicho n'choni n'cha khunje, u Abrahamu ale nuvu kifu amwidikhe uNguluve khusikhu n'chi khwincha akhava baba va vanu vingi, ukhukongana na khila ekhi n'choviwe,” Vuyiva khukhi vumbukho kyakho. ");
INSERT INTO zgam_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Umwene ale pepe ndwidiko. UAbrahamu aidikhe ukhuva umbele gwa mwene yuywa gwa silile ukhu fya, ale ne miakha mia yimo. Pia alikubaliana na hali ya kufyakwa litumsu lwa Sara. ");
INSERT INTO zgam_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ulwakhuva uNguluve alagile, uAbrahamu akhava mwidehin'chi akha va amagha mundweidikho nukhuginwa uNguluve. ");
INSERT INTO zgam_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Alumanyile ukhuta kila eikya lagile uNguluve alei nuvuwesyo uwa khutimesya. ");
INSERT INTO zgam_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Eiye yuya vahiwe khumwene ukhuva lweli. ");
INSERT INTO zgam_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Sio gasimbiwe ukhuva faida ya mwene ukhuvaliliwa khumwene. ");
INSERT INTO zgam_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Lwasimbiwe khwaajili yeto, nakhuvala ava avavavaliliwe ei mbalelo nufye avavikhwidekha ukhuta an'chusinche udada vito uYesu Klisite ukhuma khuvana avafule. ");
INSERT INTO zgam_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Uyu viula uvi ahumenchiwe khunjila ya nongwa ncheto, nukhunchusiwa ili tukave ukhuvali hiwa ei lweli. ");
INSERT INTO zgam_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Ulwakhuva tuvalilive khuuchila iyalwidikho tulinulwi elikho ulwidikho nu Nguluve munjila ya Ntwa vitu uYesu Klisite. ");
INSERT INTO zgam_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Ukhugendela inchila iyi na yufwe tulinusikhi ugwa lwidikho nu luhungu mugati nukwima. Tuhovokha nu vunonu uvu ikhutupa uNguluve khusikhi, uvunonu uwakhulundamana, imbuvalanche uwa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ulwakhuva tuhovokha nu vukhuvilwa weto tukhulumanya ukhuta uvukhuvilwa wihola uvugatalufu. ");
INSERT INTO zgam_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Uvugatalufu wihola ukwidikhiwa nu khwidika ukhuhola uvukhifu uwa nsikhi. ");
INSERT INTO zgam_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","uvukhifu uvu savugatala ulwakhuva ulugano ulwa Nguluve lududiwe munumbula nchito ukhugendela mumepo umbalanche, uvya huminche khulyufwe. ");
INSERT INTO zgam_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Uputwale vapepe khusikhi ugu mwa Klisite afwile khunanya mbivi. ");
INSERT INTO zgam_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Yiva ng'afu ukhufwa uwuno umo uviifwa nu wayilweli alekhe ukhufwa umunu unonu. ");
INSERT INTO zgam_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Lugave ulugano edikhile yuywa ukhutwale vanya sambi, iyi ng'afu yumo ukhufu khu nyalwidikho. ");
INSERT INTO zgam_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Ukhuva khugoni tuvaliwe nu suyilweli mukhisa gwa mwene twipona ukhuhuma khuluvipo ulwa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Usikhi ugutwale nu ndugu, u Nguluve, uNguluve akhatusyikhila khu nchila iya vufwe, uwa mwana va mwene, pasikhi ugu amalile ukhutusyikhila akhatupokha nu vutamo wito. ");
INSERT INTO zgam_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Lino syo nduvu, pu tuhekhela nu Nguluve ukhugendela khutwa u Yesu Klisite, umwene uvi lino twupilile uvugatalufu uvu. ");
INSERT INTO zgam_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Lino ukhugendela mumunu imbivi nchaingile mukhilunga khunchela iya vufwe, nu vufwe vukhalutilila khu vanu voni, ulwakhuva voni vavombi isambi. ");
INSERT INTO zgam_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Ipakha lino ululagilo, lwa nogwa wale wa nkhilunga, lino imbivi sanjivaliwa vivusikhi ugwa lulagilo lusikhuli. ");
INSERT INTO zgam_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Na vulevule uvufwe ukhuhuma khwa nyakhatale u Adamu ipakha usikhi u gwa Mose, khuvala avasavavombe imbivi, ukhusita ukhwidika uvuvivi akhale ikhwincha, vingi va fwile khukhisa kya Nguluve nu vunonu wa khisa wa munu, Yesu Klisite vulutilile ukhulutilila khuvingi. ");
INSERT INTO zgam_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Uvunonu twupilile vuvule khuvuvwi, ulwa khuva uvutulanogwa uwayumo vingi vafyile, vuvule khu khisa khya Nguluve nu khutupa uvunonu mukhisa vuvule ikhya munu yumo, u Yesu Klisite ilutilile khuvingi. ");
INSERT INTO zgam_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Ukhusana sakhulihewuile ndu muwu uvyavombile imbivi. khuluvafu ulunge uvuhigi nu lukhungu lwa inchile uluvofu ulunge, ikhi khungilwa kya vuvule, ikhihihuma ukhuvaliliwa nu vulweli wainchile mvimbuvivi. ");
INSERT INTO zgam_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Uvulweli wa imbivi incha vufwe uwa munu umu wa endelile ukhulutilila na vala avikhwupilila uluhungu ulwingi pupavunye ni khikhungiwa ikyalweli vikhikhungiwa ukhugendela mumivele igwa Yesu Kliste. ");
INSERT INTO zgam_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Linu ingave inogwa incha yuwu ni ncha vanu voni vainjile khuhigiwa, ukhugendela mumbombo yimo iya lweli satwavaliliwe mumbili ugwa lweli mumbanu voni. ");
INSERT INTO zgam_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Ulwakhuva ukhugendela mumunu nu khusita ukhwidikha yumu, vingi vavombeliwe inongwa, ugendela ukhusita ukhwidika khwa yumo nu khuvikha na lweli. ");
INSERT INTO zgam_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Lino ululagilo lwaingile pupaninye ni mbivi ukhuta njendelelage. Nu vuvivi wolikhuongesekha, na uluhungu lwope lulikhwongesekha. ");
INSERT INTO zgam_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Iyi yahumile ukhuta isambi umunchongesikhe, nu khufwa, khukhuta ikisa khiwesya ukhulutilila ukhugendela muvulweli ni mivele khigieto khusikhu njoni ukhugendela mupokhi u Yesu Klisite Utwe veto. ");
INSERT INTO zgam_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Khumbe tunchove khihi? Tughendelelage ukhuvomba imbivi ukhuta ulusayo lyongelele? ");
INSERT INTO zgam_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Bakhoo. Ufwe twafwile mumbivi, tuwesya ndakhikhi, ukhutama umwa khange? ");
INSERT INTO zgam_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Tee samulumanyile ukhuta vala avonchiwe mwa Klisite vaonchiwe mumbufwe wa mwene? ");
INSERT INTO zgam_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Twasyieliwa pupaninie nu mwene ukhughendela khulwonoho mumbufwe. Ile lyavombike ukhuta u Klisite waghiniwe ukhuma khuvufwe ukhughendele uvutwa wa Dada, ukuta nayufwa tuwesyaghe ukhughenda mumbupya wa khutama. ");
INSERT INTO zgam_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Ulwakhuva tuhungile pupaninie nu mwene khukhihwani kya vufwe uwamwene, pwu tulahanga pupaninie mumbunchuka uwamwene. ");
INSERT INTO zgam_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Ufwe tulumanyile ndee uvumunu wietu uwakhatale wavungiwe pupaninie nu mwene, ukhuta umbile ugwa mbivi ghunangeikhage eile lyahumile ukhuta tulekhe ukhuva vasuhiwa va mbivi. ");
INSERT INTO zgam_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Umwene uvyafwile aviekhiwe ukhuva vayilweli ukhukongana ni mbivi. ");
INSERT INTO zgam_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ukhuva tufwile pupaninie nu Klisite, tukwidikha ukhuta tutamaga pupaninie nu mwene. ");
INSERT INTO zgam_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Tulumanyi ukhuta uYesu anchukhile ukhuma khuvufwe, nukhuta samunu uvyafiwile tena. Uvufwe savukhunkonga kavile. ");
INSERT INTO zgam_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Khuvufwe uwafyelile khu nongwa incha mbivi, afyile khamo ukhuvafyela voni. Nakhukhutama ukhuitama, itama mumakha nga Nguluve. ");
INSERT INTO zgam_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Khunjila iyo yiyiyo, nayumwe khulondiwa avanu avafwile ukhuva avanu avafwile mumbivi, ulwakhuva kwa Nguluve mwa Yesu Klisite. ");
INSERT INTO zgam_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Kwu baako ukhuta ukhunogwa kwa mbieli khulekhe ukhukwile imbivi ukhuta umbilie gwukongage umuguunogela uvunonu uwakhunogwa. ");
INSERT INTO zgam_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Ulekhe ukhughava uluvafu lwa mbili gwakho khumbivi nifivombelo ifisafinogiwa, pwu twihumiaghe yufwe khwa Nguluve, nda vumi avahumile kwa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Tulekhe ukhuta imbivi ukwutumilila, ulwakhuva samliepasi pa fyombo ifya lweli kwa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Khikhi khumbe? Tuvombe imbivi ulwakhuva tulipasi pa ndageilo, ila pasi palusayo? Kwu bakho. ");
INSERT INTO zgam_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Samulumanyile ukhuta khumwene yuywa uviikhuminche yuywa ukhuva imbombi vei mwene umwe mulivavombi va mwene, umwene vipanogile ukhumpulikhincha? Iye lweli nupwu mungave umwe mulivavomba mbivi inchikhuvahilika khuvufwe, apange mlivasuhiwa avakwidikila ukuvahilika kuvufwe, apange mlievasuhiwa va wayilweli. ");
INSERT INTO zgam_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Pwu aginiwagwe uNguluve! ulwakhuva mukhale vavombi va mbivi, ulwakhuva mwidikhe ukhuma munumbula ukhukongana nulumanyisyo ulumwapokhile. ");
INSERT INTO zgam_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Muviekhiwe mumbwavukhe ukhuhuma kwumbivi, khange muvikhiwe vavombi va vuyilweli. ");
INSERT INTO zgam_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Ninchova ndumunu ulwakhuva yavudekhe dekhe wa mivile gyitu. Ulwakhuva mukhahuminchi mumivili gyinyo ukhuva vasuhiwa vayilweli kuvu vanche. ");
INSERT INTO zgam_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Upwumukha vasuhiwa va mbivi, mukhale mbuleghefu pavutali ni lweli. ");
INSERT INTO zgam_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Kwuu nsieki ugwa mkha ni niesekhe yilikhu kwu kumbombo iyumukhuyivona leino mwivona soni khuieyo? ulwakhuva khuvusilo wa mbombo incho wiwa vufwe. ");
INSERT INTO zgam_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ulwakhuva lino vavavikhile mumbwa vokhe khuvutali ni mbivi na muvikhiwe vasuhiwa kwa Nguluve, mlieniseke mbuvalanche. Khuvusililo uwumi wasikunchoni. ");
INSERT INTO zgam_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Ulwakhuva uvivomba imbivi iekhigavilo kya mwene uvufwe, khange iekhikhungilwa ikya vuvule ikya Nguluve uwumi uwa kusila lusiku mwa Yesu Klisite untwe vetu. ");
INSERT INTO zgam_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Au samulumanyile, valokolo lwango (olwakhuva nijova na vanu avalumanyile urulagero), khukhuta urulagero lukhundo ngoja umunu vobado inkafu? ");
INSERT INTO zgam_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Olwakhuva udala avatoliwe akungiwe nululagelo khwa gosi va mwene, vunkafu mave ogosi va mwene ifiwa iva avikhilwe ukhuva mwavukhe ukhukhuma na nurulagero lwa khutolana. ");
INSERT INTO zgam_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Nevetwita, osekhe ugosi va mwene witama, inave nogosi uyunge, ikhelangiwa indigu, inave ogosi va mwene afwele, iva mwuvukhe nululagero, evo siva ndigu angave itama nu gosi uyunge. ");
INSERT INTO zgam_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Ulwakhuva, valokolo lwango, umwe mwavombiwe ukhuva wafwe nurulagero khu njila iya Klisite. Evilendete uhutama pupaninie nu ninoo, khu mwene uyakhanchukhile ukhukhuma khu vufwe ili tuwesye ukhung'olela u Nguluve isekhe. ");
INSERT INTO zgam_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Ulwakhuva vutukhale pa hali iyambele, uvunogwe uwambivi fikhasi simwile ifikhancho fweto khunjila iya lugalero nukhu vuholela uvufwe isekhe. ");
INSERT INTO zgam_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ulwakhuva tudenduliwe ukhukhuma mu rulagelo. Tuyefwelile iyekhube jekhana. Ili tuvoese ukhuvombekhe uvupya mwa mepo, nufwe uwahatale uwa vusimbe. ");
INSERT INTO zgam_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Tutekhekhi? ululagero ulwa mbivi? La hasha. Inave evoo, sananikhulumanya imbivi, waleusite ukhuva munjila iya lulagero. ulwakhuva sananikhulumanya ukhuno gwa inave ululagero salwalwinchoova, “Olekhe okhonogwa.” ");
INSERT INTO zgam_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Olwakhova imbivi nchapeviwe indagero nu khuleta igati indyu ne khela namna iya khunogwa. Ulwakhuva imbivi khesita rulagelo nchifwile. ");
INSERT INTO zgam_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Nayune nale mwumi pavulongonchi uwa ndagero, upuyainchilem dagero, imbivi nchapewiwe uwumi, one nafwe. ");
INSERT INTO zgam_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Ululagero ululwale lwa khukhu khelekhela uwumi lwapendwi khe ukhuva vufwe khulwune. ");
INSERT INTO zgam_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Ulwakhuva imbivi nchapeviwe akhavalelo pa lulagero ulwa vudesi. Ukhugendela ululagero, nafwile. ");
INSERT INTO zgam_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Leno ululagero luvalanche, ulwakhuva indagero nchivalanchiwe, yalweli nu vusalaama. ");
INSERT INTO zgam_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Ulwa khuva iyiyale nonu khulwune wale vufwe khulwune? Isite ukhuva eve mwee. Ulwakhuva imbivi, ili yevonekhe ukhuta mbivivi yinogiwa yegendele munonu, yevekhu uwufu igati ndyune. Yale ukhugendela ululagero imbivi nchikhwendelela ukhuva sinchoo. ");
INSERT INTO zgam_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Ulwa khuva tulumanyile ukhuta imbivi nchikhuma nukhutengulile munumbula ulwakhuva one nelemunu va mbele. Nigonchiwe pasi pa vulongonchi mwambivi. ");
INSERT INTO zgam_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ulwakhuva ilenivomba, sanikhweliwa liwa hoeli. Ulwakhuva eleninogwa ukhuvomba, sanivomba, na ele elekalalile, lwuelyo elenivomba. ");
INSERT INTO zgam_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Ulwakhuva nengavombe elesani nogwa, nikhwedekhana nululagero ukhuta ululagero lunonu. ");
INSERT INTO zgam_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Ulwakhuva sio nene ne nikhogo avombela ago, ulwakhuva nchu mbivi inchinchilekhulwune igati. ");
INSERT INTO zgam_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Ulwa khuva nelumanyile ukhuta igati ndyune, ila sanikhule vombela. ");
INSERT INTO zgam_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Ulwakhuva elinonu eleninogwa soni khulevombela, ila elivivi ele saninogwa lwunikhulevombela. ");
INSERT INTO zgam_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Leno kama nivomba elesanino gwa, sinene yune nikhulevomba, ulwakhuva yu yila embivi iyeyitama igati ndyune. ");
INSERT INTO zgam_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Nelumanyile, mwele indagero igati ndyune iyakhunogwa ukhuvomba amanonu, ulwakhuva uvovivi nuvule igati ndyunee. ");
INSERT INTO zgam_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Ulwakhuva nikhurukhovokhela ululagero ulwa Nguluve igati ndyune. ");
INSERT INTO zgam_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Ulwakhuva nivona imbinu inchiilivonge muvikhanjo ifya mbele ugwango. Yietova hubancha embombe enya eyahekhara lwango. Yikhumbikha une neledovwava mbivi inchili vikhancho ifyambele gwango. ");
INSERT INTO zgam_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Une nele munu va lukuto! veve ni uyaha ikhonyokhora nu mbile ogu ugwa vufwe? ");
INSERT INTO zgam_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Inave ukhu mwale khwa Nguluve nu Yesu Klisite umbaha vetu! Leno. One nemwene nulukhala lwango nikho lovombela ululagelo ulwa Nguluve. Pakhuva, khumbile nikhunchivombela embombo imbivi. ");
INSERT INTO zgam_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Yesipali ehukumu ya viboko havalemwe Yesu Klisite. ");
INSERT INTO zgam_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Uhuva eshelia ya numbula ya hukianya hwa Yesu Klisite yembwene une nivile hulu ni mbivi nuvufwe. ");
INSERT INTO zgam_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Uhuva eshelia yichile mbali ni mbivi yalemilwe uhuvomba uhuva naamu umbile uNguluve avombile asuhile umwana yumo avenesadaha eya mbivi ahayehega embivi ya mbivi. ");
INSERT INTO zgam_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Avombile ivo masuhano ga ndagelo yetimizwe igati yeto ugwe tusite uhukonga umbile lakini avavikonga enumbula. ");
INSERT INTO zgam_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Vavo vikonga umbile visaga amambo gambile leno avikonga amambo ganumbula vovi saga amambo ganumbula. ");
INSERT INTO zgam_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Uhuva amalengo gambile ga vufwe bali ama lengo ganumbula uwavuhe. ");
INSERT INTO zgam_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Uhuva amalengo gambile gale nuhukalala nu Nguluve uhuva sayihedeha idagelo icha Nguluve wala sayiwesie uhudeha. ");
INSERT INTO zgam_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Vala avikonga umbele saviwe sia uhugana uNguluve. ");
INSERT INTO zgam_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Hata leno samlehumbeli bali mlehunumbula kama mle hunumbula mutama gati lakini kama mle hunumbula mutama gati lakini kama munu alebila nembula ya Klisite uywa sio vamwene. ");
INSERT INTO zgam_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Kama uKlisite alegati ndiomwe umbele gufwile humambo ga mbivi bali numbula yeehige nonu. ");
INSERT INTO zgam_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Uhuva enumbala ya yula uvia chusiche uYesu uhuhuma huvufwe itama gati mliomwe yuywe achu siche uYesu Klisite uhuhuma huvufwe wamivele gienyo egi vufwe uvi tama munumbula chenyo. ");
INSERT INTO zgam_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Ululeno valukololiwanga ufwe tulenu kole, lakini uvwe tutamaa simbile. ");
INSERT INTO zgam_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Kama tutama numbile mle kalibu uhufwa lakini umnave hunumbula mwiviha engendelo ulwa mbilemtama. ");
INSERT INTO zgam_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Nduvovi vibuwo nsoswa ne numbula ya Nguluve avo vuvana va Nguluve. ");
INSERT INTO zgam_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Uhuva samwa pohele inumbula ya mateso ate uhuduada badala mwapohile enumbula yahuva vana tulela, “Abba, Baba!” ");
INSERT INTO zgam_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Enumbula yeyeni yehwelewa pamoja ne numbula pahuva tule vana va Nguluve. ");
INSERT INTO zgam_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Tunave tulevana tulisile hwa Nguluve uvwe tulisili pamoja nu Klisite tunave tuteseha nu Klisite ili tupate uhuginiwa nu mwene. ");
INSERT INTO zgam_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Uhuva ni valela amateso agawakati uvu uhuva ufwe twelungile nuvuvaha uwa tuvonehile huliufwe. ");
INSERT INTO zgam_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Uhuva iviumbe fioni vilola yuywa uhuvoneha kuvana ava Nguluve. ");
INSERT INTO zgam_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Uhuva uvuumbaji wavombiwe nnbiki sio huhiali yeto ilakwa sababu yayuywa na hutesemela. ");
INSERT INTO zgam_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Uvuvumbaji uwa mwenye vulavehiwa huru nuhuhuma humateso ga vuvivi nu hwingila mbovuhulu wa vana va Nguluve. ");
INSERT INTO zgam_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Uhuva tuhwelewa uvuvumaji nuhuteseha nuvu chungu hata leno. ");
INSERT INTO zgam_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Siyo yufwe tuliona malipuko ya numbula ufwe tutamwa hunafasi cheto vutugojela uhu vombiwa humivele gieto. ");
INSERT INTO zgam_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Uhuva twa pohiwe lakini ehenu hihio nekonihe uhuva nehe wene vani ugojela ehehivoneha? ");
INSERT INTO zgam_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Bali tuhuhepulehela tuhegojela kwa saburi. ");
INSERT INTO zgam_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Hunjela yeyeyo enumbula yope yehututana uvusaifu weto uhuva samanyile usaya jinsi umyinogela uhwesaya lakini enumbula yihutudavela huhwa sahudoveha. ");
INSERT INTO zgam_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Na mwene uviichungusiva inumbu uhuyelewa uluhala lwa numbula sababu vidova huniaba ya vene ava vihwamini idova huniaba yao vaamini humapenzi ga Nguluve. ");
INSERT INTO zgam_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Nufwe tuhelewa wote avaganile uNguluve umweneivomba embombo pamoja huvunonu huvanu avihelangiwa humalengo gwa mwene. ");
INSERT INTO zgam_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Husababu voni ava avavamanyile tangu hatale na avacheguile tangu hatale vahwanane nufuno ugwa mwana va mwene i umwene aholiwe ave vya hunza miongoni mwovalukolo vingi. ");
INSERT INTO zgam_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Na vala avavachagwile ako avelangile navala avavela ngile avavalile uvuyeleli navala avavalile uvuyelweli avo avaginiche. ");
INSERT INTO zgam_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Tuchove hehe juu mambo aga? uNguluve angave uvupate weto veni uvale hukianya huliufwe? ");
INSERT INTO zgam_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Uvepila sihundeha umwana va mwene bali ahuniche huzili yeto tuvanu twevoni iweza uhu kosia uhutu tanga na mambo goni pamoja nufwe? ");
INSERT INTO zgam_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Veni uve ilvesia uhuva sitaha uNguluve vemwene ihuva valela uvuye lweli. ");
INSERT INTO zgam_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Veni uvepia ihukahega adhabu? Klisite Yesu veafule hu ajili yetu nuhuvahuago umwene alifufuka umwene itavala mahali pa heshima na tena viihuto dovela. ");
INSERT INTO zgam_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Veni uve ihutu gava nuvugane uwa Klisite Yesu etabu, au amateso, au enjala au hebwinda au hatali au emundu? ");
INSERT INTO zgam_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Kama umoyasimbiwe kwa faida yaho tuifwa imsi yoni twavaleliwe kama ngosi ya hubudiwa.” ");
INSERT INTO zgam_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Katika mambo ufwe tule vasiti vavasindi katika yeya uvatu ganile. ");
INSERT INTO zgam_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Uhuva na malile uhukela kwamba wala uvufwe wala uludeva wala usuhiwa wala mamlaka wala ifinu ifilipo wala ifinu vivyozavyo wala amaha, ");
INSERT INTO zgam_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","Wala agalehukianya wala agale pasi wala kiumbe hio hioni sahehaweswe uhutugava nulugano la Nguluve ambaye ve Klisite Yesu utwa veto. ");
INSERT INTO zgam_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ninchova icha yelweli mwa Klisite. Saninchova uvudesi, ni nyievonelo nchengo nchikhumbula paninie nune mumepo umbalanche, ");
INSERT INTO zgam_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Ukhuta khulinulusu valo uluvaha nuluvavo ulusalwisila ngati munumbula yango. ");
INSERT INTO zgam_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Ukhuta nale ninogwe une nie mwene ukhukotoliwa nu khutengiwa patali nu Klisite khunogwa ya valokolo lwango, uvuvahwani nune khimbili. ");
INSERT INTO zgam_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Avene vanya Israeli, uvalivumbikhe vana, va vuvalanche, nu lwokhelo lwa lutagilo, ukhwisa ya khwa Nguluve nu lwokhelo. ");
INSERT INTO zgam_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Avene vuvalongonchi u Klisite wa inchile kwu lisima ukhofwala umbili ugu - umwene vi Nguluve va fyoni. Navope agini vwage imiaka. Amina. ");
INSERT INTO zgam_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Khange sakhukhuta ulwidihano lwa Nguluve lukemilwe ukhutimila. Ulwakhuva sakhilo munu uviavile inya Israeli vi muIsrael lweli. ");
INSERT INTO zgam_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Ate ne khikhipapo kya Abrahamu ukhuva vana va mwene lweli, “Pwu ukhugendela kwa Isaka ikhipago kyoko khikhwelangiwa.” ");
INSERT INTO zgam_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Ukhuta avana va mbili savana va Nguluve. Pwu avanu va lwidihano viloliwa ukhuva khipapo. ");
INSERT INTO zgam_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Uhwakhuva ili lyu limenyu lya lwidiheno: “Mwu misinkhi haya nikhwincha, nu Sara iva nu mwana.” ");
INSERT INTO zgam_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Salili vuvule, nayu Rebeka ukhukhava unchigo khu munu yumo, u Isaka udada vitu- ");
INSERT INTO zgam_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Ukhuta avana vakhasigalile ukhu holiwa khange sakha vomba imbombo yoyoni inonu apange imbivi, apange uvunogwe wa Nguluve ukhukongana nu vuhale wime, sio khu mbombo, ulwakhuva ukuta. ");
INSERT INTO zgam_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Lyanchovile khu mwene, “Umbaha ikhumbombela udebe.” ");
INSERT INTO zgam_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Nduvuyisimbiwe: U Yakobo naaganile, pwu Esau ansulile.” ");
INSERT INTO zgam_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Pwu lino pwu twinchova ikhikhi? Khuli vuvivi khwa Nguluve? Ata. ");
INSERT INTO zgam_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Ulwakuva inchova kwa Mose, “Niva nikhisa kwulo uvinikwu nsyikhela, niva nu lusyikhilo kwa ula uviya nikwu n'syikhila, khange niva huruma khu yule uvinikwusyikila. ");
INSERT INTO zgam_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Pwu lino sayivile umwene uviinogwa khange sa lwakuva inyile uviivonesya ikhisa. ");
INSERT INTO zgam_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Ulwakuva uvusimbe vwita kwa Farao, “Khuvunogwe uvu uvuvamana nikha khwimikha une nivonesye amakha gango khulyuve, nukuva ilitavwa lyango linchovivwage ikhilunga kyoni.” ");
INSERT INTO zgam_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Pwu lino uNguluve iva ni khisa khumunu yoni uvyaganile, na uvyaganile, ikhumbikhe ukhuvanya ngani. ");
INSERT INTO zgam_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Pwu yawita khulione, “Pwu khikhi vupilola uvuvivi? Pwu alikhi uviegumilinche uvunogwe vwa mwene?” ");
INSERT INTO zgam_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Vi munu veve veni vi vukhumbulo vunge uNguluve? vwiwesya ukhulumanye ikhinu ikyu vumbile ukunchova kwu munu uvya khivumbile, “Khekhi ukhambikhile evwo une?” ");
INSERT INTO zgam_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Khukhu uvivumba inchila vwa yelweli kwu ng'anga ukhuvumba ikhivombelo ukhumana nu ng'anga gula gule, ni khyombo khinge khu mbombo yi figono fyoni? ");
INSERT INTO zgam_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Ndakhekhi ingave, uNguluve, uvi alinuvunu vwa khuvonesya uvuvivi vwa uvuvivi vwa mwene nu khuvomba ne makhaga mwene ukhuvoneka, akhanogile ukwiyumilinche, iatbu iyuyivikhiwe kwa khuyancho? ");
INSERT INTO zgam_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Ndakhikhi ingave avombile evo avonesye uwingi vwa vulancha vwa mwene kwu fyombo fya khisa, ifyo ifi fikhavikhilwe kwu vuvalanche? ");
INSERT INTO zgam_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Ndakhikhi ingave akhavombile khuvanu va khilunga? ");
INSERT INTO zgam_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Nduvwichova khange khwa Hosea: “Nikhuvilanga avanu vango uvuvale savanu vangu nu ngane va mwene uvisakhe ngane. ");
INSERT INTO zgam_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Khange yayiva ukhuta pala upwa khanchovivivwe kuvene, 'Umwe samlivanu vango,' pala vikhilangiwa 'vana va Nguluve umwumi.'” ");
INSERT INTO zgam_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Uyisaya ilila ukhukongano ni Israeli, “Ingave imbalilo ncha vana va Israeli ncha chivenchage ndu nganga ugwa nyanja, igiva gu melagalila legu giva masigalila uvu yavipokiwa. ");
INSERT INTO zgam_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Ulwakhuva unkuludeva ayikulitola ilimenyu lya mwene pakhanya pakhilunga, khimbivi nu uvukwilanile. ");
INSERT INTO zgam_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Nduvu Isaya vu anchovile, “Ingave unkuludeva vavasikhali sa khatulekhe khunsana kwu khivumbukho kyito, tukhale twiva ndu Sodoma, na tuvombivwa nda Mgomora. ");
INSERT INTO zgam_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","twita khekhi lino? Ukhuta avanu va nkilunga uvu savalikhulonda uvwa yilweli, uvwa yilweli wa lwidincho. ");
INSERT INTO zgam_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Pwu lino unya Israeli, vyalikhulobda ululagilo lwe vwa yilweli sakhefikha. ");
INSERT INTO zgam_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Khekhi sayikhale ivwo? Ulwakhuva savalikhu nu lwidikho, valikholonde kwu mbombo. Vakhi khuvancha pakyanya paliwe ilya kwi kuvancho, ");
INSERT INTO zgam_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Nduvuyivile yisimbiwe, “Lola, nivikhile ilivwe lya kwi kuvancha mSayuni nu umwene uviikhwidikha salasukha.” ");
INSERT INTO zgam_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Valukolo inumbula yango nulwisayo lwango khwa Nguluve, khuvene khwa jili ya vupokhi, ukhuva nukhuvavula ukhuta, valene mbombo ya Nguluve sio kwa jili ya luhala. ");
INSERT INTO zgam_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Ukhuva ni khuvavula ukhuta vale nembombo ya Nguluve. Leno sio ukhuta valenu welewa. ");
INSERT INTO zgam_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Ukhuva Sara yemanyile ilweli ya Nguluve, vilonda ukhujenga elweli yavene vavo. savale videkhi khuvulyeu wa Nguluve. ");
INSERT INTO zgam_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Ukhuva uKlisite vitimilifu indagelo khuvulweli wakhila munu uvikhwami. ");
INSERT INTO zgam_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Ukhuva uMusa viasimbile ukhuhusu elweli ukhumana nululagelo: Umunu uvaivomba elweli ya lulagelo itamaga ni lwali iyi.” ");
INSERT INTO zgam_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Inava ilule yivonekha nu ulwidikho vun'cho lweli, “Usite ukhujova munumbula yakho, 'Vani ukhutoga khukianya?' (Khu khu ndata uKlisite pasi). ");
INSERT INTO zgam_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Usite ukho jova munumbula yakho veni a uvikhava ikhwikha pali guli iya yuyikhundata uKlisite khukhanya ukhuma khura fuile). ");
INSERT INTO zgam_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Lakini yijova khekhi? “Ilimonyu lelepipi nuve, mundomo gwakho na munumbula yakho.” Ilwo ni limenyu ilya lwidakho.” Lilyo tukholejova. ");
INSERT INTO zgam_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Ukhuva undomo gwakho gwipela khwa Yesu ukhuva vitwa, nukhwamini munumbula yakho ukhuta vu Nguluve ukhunchukha, wipona. ");
INSERT INTO zgam_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Ukhuva khunumbula umunu ikhedekha nukhupela lweli, na khundomo ukhupela nukhupokhela uvulokhole. ");
INSERT INTO zgam_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Ukhuva eliandikho linchova khila uvikhumwamini sakhasukha.” ");
INSERT INTO zgam_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Ukhuva lisikhuli lilyo salihwaninia Myahudi nu Myunani. ukhuva utwa yula yula vitwa vavoni vitayeli kuvoni avavikhumwilanga. ");
INSERT INTO zgam_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Ukhuva khila umunu uvikhule langela ilitawa lya Utwa ikhokhokha. ");
INSERT INTO zgam_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Khulitawa lilikhu viwesya ukhu mwilanga umwene vusava mpulikhi? liuvikhupulikha wasipali uvi lumbelela? ");
INSERT INTO zgam_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Vigaha ndati vawesya ukhulumbilila, vangasite ukusuhiwa? nduvuliandikhiwe. ");
INSERT INTO zgam_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Ukhuva voni savapulekheje ilimenyu ukhuva u Isaya ijova, “Utwa, veni uva pulikhe ilimenyu lieto?” ");
INSERT INTO zgam_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Ulwedekhe lukhuja ukhuhumila mulimenyu lya Klisite. ");
INSERT INTO zgam_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Leno nijova, “Lweli savakha pilikhe?” Lweli khabisa ilimenyu iyavene likhegile mughelunga khyoni na mamenyu gavene ukhuluta khu mwisio wa khelunga. ");
INSERT INTO zgam_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Khugoni, nijova, Lweli Israel sakhalumanye?” Ulwakhwanja u Musa akhajova, nukhuvan'chogosya ukhuvavikhila uwifu khuvanu vavo sio vataifa. Khujela yeyo sio ya vanu vataifa lelwo lejila vumanyi nikhuva nchonchela mpakha muvipe.” ");
INSERT INTO zgam_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Nu Isaya ikhifu fin'cho ukhujova, “Navonikha khuvala avasavakha kha ndo ndaga navonikhe khuvala vavo savalikhunogwa.” ");
INSERT INTO zgam_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Linu khuva Israeli ukhun'chova, “Isikhu joni nanyosinche amavokho gango khuvala avasavikhumulikha na khuvanu vango.” ");
INSERT INTO zgam_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Pu leino niita, pu, uNguluve avabeilile avanu vamwene? Ndeili na padebe. Ulwakhuva une nayune neili Mwisraeli, eikhivumbukhu khya Abrahamu, vakhikolo eikhya Benyamini. ");
INSERT INTO zgam_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","UNguluve savabele avanu vamwene, uvuavamanyile ukhuhuma khuvulenguleilo. Pu samlumanyile uvuveige wiita khiikhi ukhukongana nu Eliya, umuasimeleihinche khwa uNguluve savuli ya Vaisraeli? ");
INSERT INTO zgam_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Ntwa vavabudile avasuhwa vakho, navene vanchinanginie inekhelo nchakho, une nei mwene nene niesiigile, navene vilonda uwumi wango.” ");
INSERT INTO zgam_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Pu uwamule wa Nguluve wiita khiikhi khyulyuve? “Neileiveikhile savuli yango avaalufu saba yango avusavikhufugameela amafugamilo uBaali.” ");
INSERT INTO zgam_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Paninie neiyo, usiekhe ugu leino pu khuvaale uvuvasigile savu ya vuhale wa luhungu. ");
INSERT INTO zgam_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Pui leino yiengave savuli ya luhungu, pusayiva mumivombele. pu apo uluhungu pusalwiva luhungu. ");
INSERT INTO zgam_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Khyu khinu khikhi leino? eikhyu uIsrael alikhulonda, sakhivone, pu avahaliwa vakhiwene, na vaange vakhasya. ");
INSERT INTO zgam_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Nduvuyeisimbiwe: “Unguluve avapile einumbula eiyavubungefu, amiho ukhula valekhe ukhulola, ni mbulukhutu ukhuta valekhe ukhupuleikha, pupakha eilelo eiye.” ");
INSERT INTO zgam_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Vape uDaudi iita, “Nchilekhe imesa nchavo nchive nyaafu, neimitego gwa khwipeinja, nukhwitavuleila khuvene. ");
INSERT INTO zgam_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Galekhe amiho gavo gave niehisi pu valekhe ukhulola. Ukhavinamye emisana gyavo khitaduga.” ");
INSERT INTO zgam_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Leino niita, “Puvei, kuvinche nu khugwa?” Yelekhe ukhuva ewo lusikhu. Puleino ukhulemwa khwa veene, uvupokhi vufikhe khuvapanji, ukhuta avene vavo vavone wifu. ");
INSERT INTO zgam_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Leino einave ukhulemwa khwavo vukaviwa khilunga, nu puyiengave uvufuve waavo vukavi wavapanji, pukhigelelo khiekhi eikhilutelile puyeve khunkwila nila khwavo? ");
INSERT INTO zgam_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Na leino leino ninchova numwe mwie vunu va panji, neivile isuhwa khuvanu avajilunga ifinge, nikhigineihincha eimbombo ya vutangeli wango. ");
INSERT INTO zgam_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Pamo yanikhuvapela uwifu avaleimbeili gumo nune, pano ya tukhuvapokha vaninie. ");
INSERT INTO zgam_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Pu eingave ukhubeliwa khwavo lweideha no lwa khilunga, ukhyupeileiliwa khwavo ya khwiva ndakhikhi pu uwumi uwakhuhuma khuvunchukha? ");
INSERT INTO zgam_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Einave isekhe itanchi khibana vuyileiwo khu nongeya vutine. Einave undela khibana pu amasasi nagope wuwuwa. ");
INSERT INTO zgam_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Pu einave amasasi maninie gageidewe, uve, lisasi lya msitu lya Mzeituni, ugugwavyaliwe muvene nu pungave waleepyo paninie navene eimilela gya vukani wa Mizeituni. ");
INSERT INTO zgam_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Ulekhe ukhwiginia mumasasi, pu unave vukhiginia saveve yuve vukhugitanga emilela, pu emilela gikhukhutanga uve. ");
INSERT INTO zgam_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Puleino ayawita, “Amaswato gagidiewe ukhuta neivuliwe mukhikolo. ");
INSERT INTO zgam_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Eiyo lweli, savuli ya khusita ukhwideekha khwavo vagedeiwe, pu uve wa eimile ulukangafu savuli ya lweideikho lwakho. Ulekhe ukwisageila yuve pakyanya fincho pu dwaadage. ");
INSERT INTO zgam_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Pu ulwakhuva eingave uNguluve sagalekhe lenche amaswato amatengule, sakha khuhigile uve na yuve. ");
INSERT INTO zgam_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Lola, leino, imbombo inonu nu vukali wa Nguluve. Khuluvafu lumo, uvukali wa inchile khuva yuta vala avagwile. Pu khuluvafu ulunge, uluhungu lwa Nguluve lukhwincha palyuve ungave yawinchiga muvunonu wa mwene. Einave ate uve nayuveayavubeiliwa. ");
INSERT INTO zgam_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Na eingave savakhendelelage mukhusitakhwideekha kwavo, yavi valiwa khange. Ulwa khuva uNguluve alei na makha agakhuvyaleila khange. ");
INSERT INTO zgam_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Pu ulwakhuva umwe mungave mwageidewe khunji khugugwa gwa mbutengulielo Mzeituni gwa msitu, puleino eikyavulenguleilo khileivunge Mzeituni unonu pu sayiva fiva ukhulutilila fincho ava yuta? ");
INSERT INTO zgam_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Ulwa khuva valokolo saninogwa msite ughulumanya ukhukongana ukhu kongana nei siri eiye, ukhuta mulekhe ukhuva nu luhala mumisagiele gyienyo yumwe. Ei siri eiye khukhuta uvukafu vuhumile mu Israeli, imakha ukhunchikwilanila khwa filunga yakhiva khwinchile. ");
INSERT INTO zgam_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Puleino ava Israeli vooni yavipokhiwa, ndu unyeisimbiwe: “Ukhuhuma khu Sayuni ikhwincha upokhi, pu ayihencha uvuvivi ukhuhuma khwa Yakobo. ");
INSERT INTO zgam_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Na eili puyaliva ndagano pu paninie na veene useikhi uguyakhiva nihencha imbivi nchaavo.” ");
INSERT INTO zgam_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Khuluvafu lumo ukhu kongana neilivangeili, vivipeiliwa savuli yienyo. Khuluvafu ulunge ukhukonga na vuhale wa Nguluve, vavyaliwe savuli ya vankukhu yavo. ");
INSERT INTO zgam_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Ulwa khuv uluhombo ni nyeilango yu Nguluve sayigevukha. ");
INSERT INTO zgam_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Ulwakhuva pakhwanda umwe mwale vagolo va Nguluve, puleino mulyupeilile uluhungu lwa Nguluve savuli ya khugalukha kwavo. ");
INSERT INTO zgam_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Khunjila yeiyeiyo, leino ava yuta ava vagalwikhe, pu eilyu leivonikhe khukhuta savuli ya khisa ikyu muhungukhiwe umwe mvahile ukhwambeilila uluhungu. ");
INSERT INTO zgam_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Ulwakhuva uNguluve avadeindile avanu vooni muvugalukhi, ukhuta pwava vonele eikhisa vooni. ");
INSERT INTO zgam_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Umunchi velile mbaha uvukavi nu luhungu nu vumanyi wa Nguluve! Savunchingakhimchi wa uvuheigi wa mwene, ni njeila ncha mwene sanchi manyikhikha! ");
INSERT INTO zgam_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","“Pu veini uvyakhavu manyile uvufumbwe wantwa? puveini va masago khumwene? ");
INSERT INTO zgam_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Pu veini taasi agelieli ukhupa eikhinu uNguluve pu ahombiwe khange?” ");
INSERT INTO zgam_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Ulwa khuva ukhuhuma khumwene, na khunjila ya mwene na khumwene, ifinu fyooni pufile, khumwene luve ludwando isikhu nchooni. Amina. ");
INSERT INTO zgam_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Mwi evalunkidwangwa, niekhuvadova, khukhisa ikya Nguluve, muhumyie eimivieli gyienyo yieve nekhelo ienyumi, imbalanche, iyienoghelanile pamiho agha Nguluve. Ulwa lwu lyesayo lyenyo ulunonu. ");
INSERT INTO zgam_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Mlakhikhonga ikheilunga eikhi, musyetukhe ukhuva vapya vamusango ghienyo. Muyiemanye eilweli iyalugano ulwa Nguluve uluunonu, ulunoghelaniele nukhwidihana. ");
INSERT INTO zgam_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Ulwa khuva ulusayo uluniekhaviele nikhumbula khila munu uvyaliekhulyumwe alekhage ukhunchova amavaha aghalutilile nduvugakhanughiwagwa, avinchage nukhwilola nukhuduga, nduvu uNguluve aghavile khila munu eikhighavilo lyueidikho. ");
INSERT INTO zgam_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Nduvuwu umbieli ghumu ghuliniefi ifilungielo fingi, ifilunghili ifi safiliene imbombo yeimo. ");
INSERT INTO zgam_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Nayufye tulievinigi, tulie umbieli ghumo mwa Klisiti, na yufwe khila munu alienikhilungielo ikya mwene khunine. ");
INSERT INTO zgam_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Tulinifikhungielwa ifisafi hwanine khiela munu ukhukhongana nulusayo ulutukhavile. ");
INSERT INTO zgam_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Tungave mukhutangiela tutangielage, avanyakhumanyisya vamanyisyaghe. ");
INSERT INTO zgam_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Unya khuvunga, avungaghe, unyanumbula ienonu avombaghe khunumbula, uvilongoncha alongonchaghe na makha, unyakhisa avoneisyaghe ulukheghelo. ");
INSERT INTO zgam_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Ulughano lulekhaghe ukhuva lwa vudetelenchi; uliekhalalielaghe ielivivi, wibatieliele eilinonu. ");
INSERT INTO zgam_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Muughananage yumwe khulughano ulwa khilukholo. Khulughano muvalongonchaghe ava yienyo. ");
INSERT INTO zgam_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Mlekhaghe ukhuva voolo, muvinchaghe nukwiyumilincha, munumbula vumukhumbombela Untwa. ");
INSERT INTO zgam_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Khuluhuvielo, muhovokhaghe mumbupala vumupuliekhiela, mukyiesaya, mwieyumilienchage. ");
INSERT INTO zgam_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Vukhundiwa khuvavalanche vumunkhonga uvudekhedekhe, ukhuvupieliela avagheni mwintangaghe. ");
INSERT INTO zgam_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Muvasayaghe avikhuvaviphiencha; muvasayaghe mulekhe ukhuva kholola. ");
INSERT INTO zgam_vpl VALUES ("RM12_15