﻿USE sofia;
DROP TABLE IF EXISTS sofia.zcaNT_vpl;
CREATE TABLE zcaNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zcaNT_vpl WRITE;
INSERT INTO zcaNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kure' lë rë men xa' ngok ben che'n Jesukrist, Me nzë ben che'n rey Dabi, mbaino nu ben che'n Abraham. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Xga'n Abraham ngok Isaac, lë' xga'n Isaac ngok Jakob, mbaino lë' xga'n Jakob ngok Judá kun rë wech Judá. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","No lë' rë xga'n Judá ngok Fares mbaino Zara, no xna' bixa' ngok Tamar. No xga'n Fares ngok Esrom, mbaino lë' xga'n Esrom ngok Aram. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","No lë' xga'n Aram ngok Aminadab, lë' xga'n Aminadab ngok Naasón, no lë' xga'n Naasón ngok Salmón. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Lë' xga'n Salmón ngok Booz, mbaino lë' xna' Booz ngok Rahab. No lë' xga'n Booz ngok Obed, lë' xna' Obed ngok Rut. No lë' xga'n Obed ngok Isaí. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Mbaino lë' xga'n Isaí ngok rey Dabi, no lë' xga'n rey Dabi ngok Salomón, no lë' xna' Salomón ngok tsa' Urías. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","No lë' xga'n Salomón ngok Roboam, lë' xga'n Roboam ngok Abías, mbaino lë' xga'n Abías ngok Asa. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","No lë' xga'n Asa ngok Josafat, mbaino lë' xga'n Josafat ngok Joram, no lë' xga'n Joram ngok Uzías. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Lë' xga'n Uzías ngok Jotam, no lë' xga'n Jotam ngok Akaz, mbaino lë' xga'n Akaz ngok Hezekías. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Lë' xga'n Hezekías ngok Manasés, no lë' xga'n Manasés ngok Amón. Lë' xga'n Amón ngok Josías. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Lë' rë xga'n Josías ngok Jecunías kun rë wech Jecunías. Le'n rë ngubizh ze' ñanu rey Babilonia rë men yezh Judá. Lazh men ze' ngok bixa' nela rë men nado ga', dox nguzakzi bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Or mile' Dios nguro' bixa' lazh men Babilonia, ñë'd bixa' lazh bixa'. Orze' lë' xga'n Jecunías ngok Salatiel, no lë' xga'n Salatiel ngok Zorobabel. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Lë' xga'n Zorobabel ngok Abihud, lë' xga'n Abihud ngok Eliakim, mbaino lë' xga'n Eliakim ngok Azor. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Lë' xga'n Azor ngok Sadok, lë' xga'n Sadok ngok Akim, lë' xga'n Akim ngok Eliud. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Lë' xga'n Eliud ngok Eleazar, mbaino lë' xga'n Eleazar ngok Matán, lë' xga'n Matán ngok Jakob, ");
INSERT INTO zcaNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","no lë' xga'n Jakob ngok Che, xa' ngok tsa' Mari, no lë' Mari ngok xna' Jesús, Me lë Krist. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kuze', dizde zhë che'n Abraham haxta zhë che'n Dabi nded chida tiemp kwa'n niban tu men, orze' nguio xtu chida tiemp kwa'n niban tu men dizde zhë che'n Dabi haxta zhë kwa'n ñanu rey Babilonia rë men yezh Judea par lazh men Babilonia. No dizde zhë kwa'n nguro' bixa' lazh men Babilonia haxta zhë kwa'n ngol Krist, nded xtu chida tiemp kwa'n niban tu men. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Se' ngok or ngol Jesukrist: lë' Mari, xna' Jesukrist, nzo xti'zh kun Che; per nagat ban bixa' junt, lë' Mari mbi'y xin la por Sprit che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Lë' Che xa' ngok tsa' Mari, ter nak xa' tu miyi' xa' dox nile' kwa'n nzobni' lo ley kwa'n mila' Dios lo Muisés, per gat nzhaklat xa' xo'bdi'zh xa' kwan nak Mari, orze' mile' xa' xigab, xla'n la' xa' Mari. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","No dub kile' xa' xigab kure', lë'chi ngurulo tu ganj che'n Dios lo xa' le'n mika'l, nzhab ganj: ―Che, xga'n Dabi, nazhebtal banal kun Mari par gak tsa'l; lë' Mari nakxin por Sprit che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Lë' una' gap tu më'd xibyi', mbaino ku'lël më'd JESÚS; lë' më'd re' ko' rë men che'n Dios lo rë kwa'n nzë'b xki bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ngok rë kure' par mile' Dios rë kwa'n mila' Dios di'zh lo tu rë profet, xa' midi'zh por Dios, or nzhab Dios: ");
INSERT INTO zcaNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Biwi' go, lë' tu una' ye'n wei' xin, no gap una' tu më'd xibyi', mbaino ku'lë bixa' më'd Emanuel. Widi'zh re' gab: Dios nzo kun be. ");
INSERT INTO zcaNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Or nguro' mika'l lo Che, mile' xa' nela xmod mile' ganj mandad ga'. Orze' nguziyël xa' ngok Mari tsa' xa', ");
INSERT INTO zcaNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","per nanga't bixa' junt, haxta or ngol xin una' më'd re'; no ngulo'lë Che më'd JESÚS. ");
INSERT INTO zcaNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Lë' Jesús ngol yezh Belén kwa'n ña'n lazh men Judea; le'n rë ngubizh ze' nak Herodes rey. Orze' nded pla men yezh Jerusalén, rë xa' nane xmod nak rë mbël lo yibë', zit nzë bixa' al nez plo nilen ngubizh, no nzhab bixa': ");
INSERT INTO zcaNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","―¿Ma më'do' kwa'n ngol ze', më'd nak rey che'n rë men Israel? Lë'no une tu mbël che'n më'd re' lo yibë'. Nzë no par di'zh no nazhon më'd. ");
INSERT INTO zcaNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Or mbin rey Herodes kure' kun rë xa' nzho yezh Jerusalén, net bixa' kwan le' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Orze' mikan Herodes rë ngulëi' xa' más nile' mandad, no rë xa' nilu' ley par minabdi'zh Herodes: —¿Plo nak di'zh, gal Krist? ");
INSERT INTO zcaNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Orze' nkab bixa': ―Yezh Belene, kwa'n ña'n lazh men Judea, porke se' nzhab tu xa' midi'zh por Dios: ");
INSERT INTO zcaNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Lu, yezh Belén, kwa'n ña'n lazh men Judea, nagaktra'l tu yezh kwa'n natsakt kwa'n nzho xid rë yezh kwa'n tsak lazh men Judea, lë' xid rë men xa' nzho lol, rozi' tu xa' le' mandad, par kina rë men da, men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Orze' xla'n ngurezh Herodes rë xa' nane xmod nak mbël lo yibë', par minabdi'zh Herodes, pok ka nguluxo'b mbël ze', ");
INSERT INTO zcaNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","no or mixë'l Herodes bixa' par yezh Belén, nzhab Herodes lo bixa': ―Wa go ba' par wanabdi'zh go cho ka më'd ba'. No or yazhël go më'd, ne go rëi lon, par nu da yadi'zh nazhon më'd. ");
INSERT INTO zcaNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","No or milox mbin bixa' kwa'n nzhab rey, orze' nzha bixa'. No une bixa' mbël lo yibë' nzha dilant lo bixa'; no or ngulëz mbël, nali laka ze' nzho më'd. ");
INSERT INTO zcaNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Or une rë xa' ze' ngulëz mbël, dox mizak laxto' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Or nguio bixa' le'n yo' ze', une bixa' më'd kun xna' më'd, orze' nguzuxib bixa' lo më'd mbaino midi'zh bixa' nazhon më'd. No ngulo' bixa' rë kwa'n nzhanu bixa', rë or, kun ya'l, mbaino nits nax che'n mirra. Rë kure' ngok kwa'n miza' bixa' par lë' më'd. ");
INSERT INTO zcaNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Or milox ngok kure', nzhab Dios lo bixa' le'n mika'l, nayubretra' bixa' lo Herodes. Orze' xa' nez ña bixa' par lazh bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mbaino or ña rë xa' nane xmod nak mbël lo yibë', orze' ngurulo tu ganj che'n Dios lo Che le'n mika'l, nzhab ganj: ―Waxche, bi'y më'd kun xna' më'd, bizë go lazh men egipto, no ba'gaka guyo go haxta na ka gani pok ro' go ba'; lë' Herodes kwa'n më'd ye'n par gut xa' më'd. ");
INSERT INTO zcaNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Orze' lwega' ngwaxche Che, nguzen xa' më'd ye'n kun xna' më'd or yë'l ze', nguio xa' nez, ña xa' lazh men egipto, ");
INSERT INTO zcaNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","no ba'gaka nguio bixa' haxta or ngut Herodes, par ngok rë kwa'n mila' Dios di'zh lo tu xa' midi'zh por Dios or nzhab xa': “Dizde lazh men egipto ngurezha Xga'na.” ");
INSERT INTO zcaNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","No or une Herodes, lë' rë xa' nane xmod nak mbël lo yibë' ze' mikide xa', dox miyi'xian Herodes, no mile' xa' mandad, gat rë nak më'd xibyi' kwa'n nzhap haxta chop li'n. Nguzen Herodes dizde zhë kwa'n midi'zhnu xa' rë xa' kwa'n une nguluxo'b mbël ze' lo yibë'; rë më'd ye'n mbit xa' kwa'n nzho yezh Belén mbaino rë më'd kwa'n nzho más rë yezh kwa'n nzhin naka'n yezh Belén, ");
INSERT INTO zcaNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","par ngok widi'zh che'n Dios kwa'n mizobni' Jeremías, rë widi'zh kwa'n nzhab se': ");
INSERT INTO zcaNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Dox tu yalnawin nzho lazh men Ramá, dox niwin laxto' Raquel, nzho'n xa' naye; nibizhyë xa' por rë xmë'd xa', no nanetra' yalnawin che'n xa' kwëz, por niyen ra' rë xmë'd xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","No or ngut Herodes, xtu wëlt ngurulo tu ganj che'n Dios lo Che le'n mika'l lazh men egipto, ");
INSERT INTO zcaNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","nzhab ganj: ―Waxche, bi'y më'd kun xna' më'd; bizë go lazh men Israel; lë' rë xa' nzhakla gut më'd, lë' rë bixa' ngut la. ");
INSERT INTO zcaNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ngwaxche Che, mbi'y xa' më'd kun xna' më'd, nguiubre bixa' lazh men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Per or mbin Che, lë' Lao nile' mandad lazh men Judea lugar che'n Herodes xuz xa', dox nizheb Che bi xa' ze'; orze' nzhab Dios lo xa' le'n mika'l, bi xa' lazh men Galilea, ");
INSERT INTO zcaNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","no or mizhin xa' ze', ña xa' tu yezh lë Nazaret, par ngok rë widi'zh kwa'n midi'zh tu profet or nzhab xa': “Lë' xa' ru'lë xa' nzë yezh Nazaret.” ");
INSERT INTO zcaNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Le'n rë ngubizh ze', Juan xa' nililëi' men le'n nits, nguio xa' le'n yuo bizh kwa'n ña'n lo yuo che'n men Judea, kidi'zh xa' lo rë men, ");
INSERT INTO zcaNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","nzhab xa': ―Bila' go rë kwa'n gat lë' nak go; lë' zhë nzhazhin la, ne go xmod ban go kun Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","No Juan re' mize't Isaías, tu xa' midi'zh por Dios chi tiemp or nzhab xa': Dizde le'n yuo bizh, naye kibizhyë tu xa', kidi'zh: “Bizuxkwa' go laxto' go par Dios; bila' go rë kwa'n gat lë' kwa'n nak go.” ");
INSERT INTO zcaNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nakxao' xab Juan kun yich che'n kamey, no nazi' tu sint yid laxto' xa'; kwa'n nzhao Juan nak nab tsa xanch kun mizhin che'n rë mbëz dan. ");
INSERT INTO zcaNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Rë men re' ñayon kwa'n nidi'zh Juan: rë men yezh Jerusalén kun rë men xa' nzho lazh men Judea, mbaino rë men xa' nzho naka'n ro' you' Jordán. ");
INSERT INTO zcaNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Or nixo'bdol bixa' lo Juan, nili'lëi' Juan bixa' le'n you' Jordán. ");
INSERT INTO zcaNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","No or une Juan, nayax rë men fariseo kun nayax men saduceo, nzë bixa' par lilëi' Juan bixa', orze' nzhab Juan: ―¡Rë go, men nakap, xa' nak nela mbë'l nayi' ga'! ¿Cho ne lo go, nab por gaklëi' go, le' go gan lo kwa'n nazhe'b kwa'n xë'l Dios par rë men kwa'n nzë'b xki lo Me? ");
INSERT INTO zcaNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nal bilu' go, walika mila' go rë kwa'n gat lë' nak go, ");
INSERT INTO zcaNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","mbaino nagabt go, yent kwa'n le' Dios kun go por nzë go ben che'n Abraham, porke nin lo go, haxta kun rë ke re', gak le' Dios, gake rë men xa' nzë ben che'n Abraham, ");
INSERT INTO zcaNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","no lë' yi'b ya nzo la xan rë ya, par cho'i rë ya kwa'n gat niza' xlë wen, orze' yole. ");
INSERT INTO zcaNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Walika, nab tsa nililë̱i'ña̱ men le'n nits or walika nila' bixa' rë kwa'n gat lë' nak bixa' lo Dios. Per nzho xtu xa', xa' nzadkë ticha, xa' re' nililëi' men kun Sprit che'n Dios, no más tsak xa' lon. Per ni gat ñal lan yalyid che'n xa' ni' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","No nzen la xa' pal par tsumbe xa' triu, no tu lad ko' xa' yix. Or lox tsumbe xa'i, orze' kan xa' triu par kichao' xa'i, per lë' yix zë'k xa' plo gat ñalt bël. ");
INSERT INTO zcaNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nalse nzha Jesús plo nzo Juan par lilëi' Juan Me le'n nits; dizde lazh men Galilea nguro' Me par mizhin Me ro' you' Jordán plo nzo Juan. ");
INSERT INTO zcaNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Or galo laka nanet Juan lilëi' Juan Jesús, nzhab Juan: ―¿Taxa na lilë̱i̱ña̱l? ¡Maska lu lilëi' da! ");
INSERT INTO zcaNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Per nzhab Jesús: ―Por nal, la' be gake se', par le' be rë kwa'n nzhakla Dios gak. Orze' mililëi' Juan Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","No or milox ngoklëi' Jesús, tuli nguro' Me le'n nits, lë'chi mixa'l lo yibë', une Jesús ngulayët Sprit che'n Dios yek Me, nela tu palom ga', ");
INSERT INTO zcaNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","lë'chi mien tu widi'zh dizde lo yibë' kwa'n nzhab: ―Xa' re' Xga'na xa' nazhi' da; dox nizak laxto'n por xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Or nguio Sprit che'n Dios laxto' Jesús, mbi'y Sprit Jesús plo más zit le'n yuo bizh par nabei chi zile' Mizhab gan kide Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nzhala cho' ngubizh no cho' yë'l di nzo Me ze', dub orze' gat gao Me, orze' dox mila'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Lë'chi nguzubi Mizhab par zenbe' Mizhab Jesús (wi' Mizhab xmod nak Jesús), nzhab Mizhab: ―Chi walika Lu nak Xga'n Dios, bile' ke re' gake yët gawal. ");
INSERT INTO zcaNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Orze' nzhab Jesús: ―Se' nzobni' lo Yech che'n Dios: “Gat lë't nab yët gak gao men par ban men; nab tsa kun widi'zh kwa'n niro' ro' Dios gak ban men.” ");
INSERT INTO zcaNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Orze' mbi'y Mizhab Jesús yek yado' Jerusalén plo más ya, ");
INSERT INTO zcaNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","par nzhab Mizhab: ―Chi walika nakal Xga'n Dios, bila' gabal dizde re' haxta lo yuo; nela nzobni' ka lo Yech che'n Dios: “Xë'l Me rë ganj che'n Me par kinal, no zen rë ganj ya'l par nayachinal lo ke.” ");
INSERT INTO zcaNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Per nzhab Jesús: ―Nuska nzobni' lo Yech che'n Dios: “Nazenbe'tal Dios che'nal, Me nile' mandadal.” ");
INSERT INTO zcaNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Lult mbi'y Mizhab Jesús yek tu yi' dox kwa'ro; di ze' milu' Mizhab rë nak lazh men, plo nzhin men yizhyuo, mbaino rë kwa'n tsak che'n bixa', ");
INSERT INTO zcaNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","no nzhab Mizhab: ―Na ne rë nak kure' ka'l, chi lë'l ne, nazhon da, mbaino zuxibal xan ni'n haxta gal lol lo yuo. ");
INSERT INTO zcaNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Orze' nzhab Jesús: ―¡Yubchi lon, Mizhab! Nela nzobni' ka lo Yech che'n Dios: “Nabtsa lo Dios, Me nile' mandadal, di'zhal nazhon Me, mbaino gonal ro' Me.” ");
INSERT INTO zcaNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Orze'se nguiubchi Mizhab lo Jesús, lë'chi nguzubi pla ganj che'n Dios, miza' rë kwa'n naki'n Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Or mbin Jesús, lë' Juan nzho lizhyi'b, nzha Me lazh men Galilea. ");
INSERT INTO zcaNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Mila' Me yezh Nazaret, ña Me yezh Capernaúm, kwa'n nzhin ro' lagún plo nazhë'l rë men yezh Zabulón no rë men yezh Neftalí, ");
INSERT INTO zcaNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Se' ngok rë kwa'n mizobni' Isaías, xa' midi'zh por Dios, or nzhab xa': ");
INSERT INTO zcaNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Bin goi, men yezh Zabulón, mbaino men yezh Neftalí, kwa'n nzhin al nez ro' nitsdo' al xtu ro' you' Jordán; no bin goi, rë men yezh Galilea, rë xa' gat lë't men Israel: ");
INSERT INTO zcaNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ter naban go lo nakao, per lë' tu ki ro zini lo go; rë go xa' dox nizheb gat mbaino lox lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","No dizde orze' nguzublo kidi'zh Jesús lo rë men, nzhab Me: ―Bila' go rë kwa'n gat lë' nak go lo Dios; lë' nzhazhin la gak go men che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Dub nikizë Jesús ro' nits kwa'n ña'n lazh men Galilea, une Me rop wech tu miyi'. Tu xa' lë Simón Per, mbaino xtu xa' lë Ndres. Zhi'n che'n bixa' nizen bixa' mbël, no mer ngulubi bixa' yex le'n nits par zen bixa' mbël, ");
INSERT INTO zcaNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","lë'chi nzhab Jesús lo bixa': ―Dikë go ticha, na le kan go men nela mbël ga'. ");
INSERT INTO zcaNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tuli mila' bixa' rë yex kwa'n nizen bixa' mbël, nzhakë bixa' tich Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","No nguzë Jesús xche'p, une Me rop wech xchop miyi', tu xa' lë Jakob no xtu xa' lë Juan, xuz bixa' lë Zebedeo; nzho bixa' le'n bark kun xuz bixa', kiliwen bixa' rë yex kwa'n nizen bixa' mbël. Orze' ngurezh Jesús bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Mbaino tuli mila' bixa' xuz bixa' le'n bark, lë' bixa' nzhakë tich Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","No dub lazh men Galilea, nikizë Jesús, kilu' Me widi'zh che'n Dios le'n rë yo' plo nitse'd men widi'zh che'n Dios, kidi'zh Me xmod le' men, gak men, men che'n Dios; mbaino miliwen Me rë lo yalyizh no rë yalne kwa'n kinu rë men. ");
INSERT INTO zcaNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","No dub lazh men Siria nguxo'b xti'zh Jesús, ngwanu rë men lo Jesús rë xa' nzhakne, wanei cho yalyizh nizak bixa', mbaino cho yalne kinu bixa'; rë xa' nzho mbi mal laxto' no rë xa' nizak yalyizh nikao, mbaino rë xa' nizak yalyizh kwa'n nagakt win men; rë bixa' miliwen Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Dox tu bëd men nzhakë tich Jesús: men Galilea no rë men yezh Decápolis, no nu rë men yezh Jerusalén, mbaino rë men yezh Judea, kun rë men xa' nzë xtu ro' you' Jordán; rë men re' nzhakë tich Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Or une Jesús nayax dox men nzhakë tich Me, nkili Me yek tu lom, ze' nguzob Me, orze' nguzubi rë men che'n Me lo Me, ");
INSERT INTO zcaNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","mbaino nguzublo Me kilu' Me widi'zh che'n Dios lo rë men, nzhab Me: ");
INSERT INTO zcaNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Nazhon nzha rë men xa' nane, dox naki'n bixa' Dios, porke che'n bixa' nak rë kwa'n kinu Dios par rë men che'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Nazhon nzha rë men xa' nzho'n nalre'; lë' Dios tsiyal laxto' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Nazhon nzha rë men xa' niwi' nab tsa lo Dios por rë kwa'n naki'n bixa'; kuze' lë' bixa' gal kwa'n mila' Dios di'zh. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Nazhon nzha rë men, xa' nizak nela or nila'n tu men ga', mbaino nizak xa' nela or nizëi' laxto' tu men ga', por tanta nzhakla xa' ban xa' nela xmod nzhakla Dios ga', orze' dimás za' Dios kwa'n ka' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Nazhon nzha rë men xa' nilats laxto' xtu men; lë' Dios lats ska laxto' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Nazhon nzha rë men xa' nambe laxto' lo Dios; lë' bixa' ne Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Nazhon nzha rë men xa' nile' nibin tu men wen kun xtu men; lë bixa' ru'lë xmë'd Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Nazhon nzha rë men, xa' niyi' men nine men por nile' bixa' kwa'n nzhakla Dios; kuze' lë' bixa' yo plo nzho yalnazhon che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Nazhon nzha go or nichao' yek men tu bëd kwa'n gat lë' nak go, no or dox nakap men lo go, mbaino or nidi'zh men tu bëd kwa'n mbël nak go, por nak go men da. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Dox bizak laxto' go por kuba'; lë' dox tu kwa'ro ne' Dios ka' go lo yibë'. Sa' nguzak rë men nzhala xa' midi'zh por Dios, rë xa' miban galo lo go. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Lë' go nak nela zed ga' yizhyuo re', per chi lë' zed gat nazhira', orze' yent kwan zu'i; lë'i yubi, mbaino lo men loi. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Go nak nela tu ki ga' lo yizhyuo re', nela tu yezh nzhin yek tu lom nilu' lakai; ");
INSERT INTO zcaNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","no yent cho tsinki tu biani par zob xa'i le'n tu kaj; lë' xa' zobe al ya' par ziniy lo rë men nzho le'ño'. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Gok go nela tu biani ga', nes par ne men xa naban go, orze' lë' men di'zh nazhon Xuz go Dios, Me nzho lo yibë'. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Nale't go xigab, nzhala par chila ley kwa'n mila' Dios lo Muisés, o nzhala par kubchin rë widi'zh kwa'n mikë' rë xa' midi'zh por Dios nzhala; na nzhal par len, gak rë kwa'n nzobni' lo ley, mbaino par gak rë kwa'n mikë' rë xa' midi'zh por Dios nzhala. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Walika kwa'n nin lo go, dub nzho gaka yibë' no yizhyuo, rë kwa'n nzobni' lo ley gak; haxta rë kwa'n más kwa'n win, rëi gak. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kuze', tu xa' nane la kwa'n nzobni' lo ley, ter más che'ptsa nilu' tsake, no chi nilu' xa' re' lo men, gat naki'nt le' men kwa'n che'ptsa nilu' tsak re', orze' xa' re' gak xa' más che'p tsak plo nile' Dios mandad. Per men nile' rë kwa'n nzobni' lo ley, no nilu' xa'i lo más men par nu bixa' le'i, orze' xa' re' dox xa' ro gak xa' plo nile' Dios mandad. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nin lo go, chi lë' go nale' gan le' go más rë kwa'n nzobni' lo ley che'n Muisés lo rë men fariseo, mbaino lo rë men nilu' ley re', orze' por kuba' nayot go plo nile' Dios mandad. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","No nu nzhab Me: ―Lë' go nane ka, se' nak widi'zh kwa'n mbin rë xuz go xa' nzhala: “Naguttal men, porke xa' nzhut men, lë' gustis wei' xa' par kix xa' kwa'n mile' xa'.” ");
INSERT INTO zcaNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Per na ni lo go, wanei cho men, xa' niyi' kun xtu men, orze' lë' gustis gab kwan ñal xa' re'; no wanei cho men nzhab lo xtu xa': “Tont gox”, guzhë nzë'b xki xa' ze' lo gustis xa' más tsak; mbaino wanei cho nzhab: “Le'n bël loxal”, lo xtu men, orze' por midi'zh xa' re' sa', lë' xa' re' nzho rriez bi le'n gabil. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’No chi dub kiza'l tu gon lo Dios, mbaino nanel, lë'l kinu tu kwent kun wechal, ");
INSERT INTO zcaNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","orze' más wen nalta' za'l gon lo Dios, galo laka watsiya'l laxto' wechal, orze' yubre'l, za'l gon lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’No chi wei' tu menal lo gustis, dub nzha go nez, bitsiyal laxto' xa' re', nes par nachi xa' lu lo gustis xa' nile' mandad, napa' wei' xa' re' lu lo xa' nikina lizhyi'b; no xa' nikina lizhyi'b re' kol lizhyi'b. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Walika kwa'n nin, nako't bixa' lu lizhyi'b haxta ke kixal rë kwa'n nzë'bal. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","No nzhab Jesús: ―Lë' go mbin la kure': “Nabant go kun men gat lë' tsa' go.” ");
INSERT INTO zcaNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Per na ni lo go, wanei cho tu miyi' niwi' lo tu una' no niwix xa' ban xa' kun una' ze', guzhë nzë'b xki xa' re' lo Dios por kuba'. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kuze', chi lë' zalol lad direch nile', nzë'b xkil, neka gulo'i tuli; más wen gak jwalt tu plol ke par dubal bi le'n gabil. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","No chi lë' ya'l lad direch nile' nzë'b xkil, neka bicho'i tuli; más wen yent xtu plol ke par bi dubal le'n gabil. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’No nu mbin la go: “Wanei cho tu men lë' kun tsa', naki'n yats tu yech par gak ban xa' kun xtu men.” ");
INSERT INTO zcaNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Per na ni lo go, chi tu miyi' lë' kun tsa', no chi gat lë' por ngop la una' re' xtu miyi'y, orze' kure' le', nzë'b xki una' lo Dios, mbaino miyi' xa' ban kun una' re', por kure' nu ska xa' nzë'b xki lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’No mbin la go xmod midi'zh Dios lo rë xuz go chi tiemp or nzhab Dios: “Naya'lt laxto' go, le' go kwa'n mila' go di'zh lon.” ");
INSERT INTO zcaNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Per na ni, naze't go lë Dios lo ni tu kwa'n or ña'n go di'zh le' go tu kwa'n, ni por yibë', porke lë'i nak plo nzob Dios; ");
INSERT INTO zcaNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","no ni naze't go yizhyuo or ña'n go di'zh tu kwa'n, porke lë' yizhyuo nak nela plo nizo ni' Dios; no ni naze't go yezh Jerusalén, porke lë'i nak yezh che'n rey, Me más tsak. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","No ni naze't go yek go or ña'n go di'zh le' go tu kwa'n, porke nagakt le' go naguzh o nagats ni tu yich yek go. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Naki'n gab go “Yoo”, o “A'a” namás, porke chi gab go más kwa'n, che'n Mizhab kuze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’No mbin la go se' nzhab di'zh: “Men kwa'n kich zalo xtu men, se'ska kix xa'i; mbaino xa' ko' kilëi xtu men, se'ska kix xa'i.” ");
INSERT INTO zcaNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Per na ni, nagakt go nela men xa' nile' kwa'n nakap lo go; más wen chi nzho tu xa' kë' tube ta' ro' go, orze' biza' go xtu lad. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","No chi cho men nzhakla chi go lo gustis par lat xa' xkamiset go, orze' bila' go wei' xa' ter nu xkamis go. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","No chi tu men ki'l go par wei' go tu kwa'n ne' tu kilómetro garol, neka bi'y goi chon kilómetro; ");
INSERT INTO zcaNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","no wanei cho tu men na'b tu kwa'n jwers lo go, biza' goi; no cho tu men ki'n tu kwa'n lo go, la't go bi xa' nab ya' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’No nu mbin go se' nzhab di'zh: “Bichizhi' go tsa' men go, per xa' niyi' nine go, biyi' ska go, une go xa'.” ");
INSERT INTO zcaNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Per na ni: Bichizhi' go xa' niyi' nine go, no bina'b go lo Dios por rë xa' niru'kë tich go, ");
INSERT INTO zcaNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","nes par gak go xmë'd Dios, Me nzho lo yibë'; porke Dios nile' niro' ngubizh par niziniy lo rë men wen no lo rë men nakap; mbaino nila Dios yiu par rë men, xa' nile' kwa'n nzhakla Dios no par rë men xa' nile' kwa'n gat lë' lo Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","No chi chizhi' go nab tsa xa' nazhi' go, ¿kwan gab go, ne' Dios tu kwa'n wen ka' go, por nak go sa'?, porke haxta nu rë xa' nikan dimi che'n rey Roma nak sa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","No chi nab tsa lo rë melizh go nini' go, ¿kwan gab go, más wen kwa'n kile' go, par lo rë men, xa' gat nilibe't Dios?, porke haxta nu rë xa' nikan dimi che'n rey Roma nak sa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Gok go wen kun rë men, nela wen Dios Xuz go, Me nzho lo yibë', kun rë men. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","No nzhab Jesús: ―Or le' go tu kwa'n wen, nale't goi namás par ne mene, porke chi nak go sa', ni tu kwa'n wen nane't Xuz go ka' go, Me nzho lo yibë'. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kuze' or gaknu go tu men prob nali, naxo'bdi'zht goi lo men, nela xmod nile' rë xa' chigab walika men wen, or nizo bixa' le'n rë yo' plo nitse'd men widi'zh che'n Dios, no le'n rë nez, par di'zh men wen tich bixa' namás. No walika kwa'n nin, yalnak bixa' sa', nab tsa lo rë men yizhyuo ña'n bixa' wen, per par lo Dios, yent kwan gal bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Per go, or gaknu go tu men yent kwan nzhap, nadi'zht goi ni lo xa' más nichë'l go; ");
INSERT INTO zcaNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","bile' goi namás, porke lë' Xuz go Me nzho lo yibë', niwi' lo rë kwa'n nzhak xla'n, orze' lë' Me ne' tu kwa'n wen ka' go, por kwa'n mile' go ba'. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Or na'b go lo Dios, nale't go nela xmod nile' rë xa' chigab walika men wen, rë xa' ño laxto' nina'b lo Dios, dub nzoli le'n rë yo' plo nitse'd men widi'zh che'n Dios, mbaino le'n rë nez, no plo nzhak xbi', par xo'b xti'zh bixa' namás. No walika kwa'n nin, yalnak bixa' sa', nab tsa lo rë men yizhyuo ña'n bixa' wen, per par lo Dios, yent kwan gal bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Per go, or na'b go lo Dios, guyo go le'n yo', no bitsao' go ro'i, orze' xla'n bina'b go lo Dios Xuz go; no lë' Xuz go niwi' kwa'n kile' go xla'n, lë' Me ne' tu kwa'n wen par go dilant lo rë men. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","No dub kina'b go lo Me, nadi'zht go tutsa kwa'n garga'l, nela nile' rë men, xa' gat nilibe't Dios. Lë' bixa' gab, por nile' bixa' sa', gon Dios kwa'n nina'b bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kuze' nale't go nela rë men ba', porke lë' Xuz go, Me nzho lo yibë', nane la kwan naki'n go, antis di na'b goi lo Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Or na'b go lo Xuz go Dios, se' guzh go: Xuz no, Me nzho lo yibë', dox ñal di'zh rë men, nazhon Go; ");
INSERT INTO zcaNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","nzhakla no, rë men yizhyuo ziyël le' Go mandad lo bixa', nela xmod nile' Go lo yibë' ga'; ");
INSERT INTO zcaNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","bine' Go kwa'n gao no, no kwa'n naki'n no zilita'; ");
INSERT INTO zcaNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","biya'l laxto' Go rë kwa'n gat lë' nile' no lo Go; sa' ska ya'l laxto' no rë kwa'n gat lë' nile' men lo no. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","No nala't Go zenbe' Mizhab no (wi' Mizhab xmod nak no); gulo' Go no lo rë kwa'n nzhakla xa' li'nu xa' no. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’No chi lë' go ya'l laxto' rë kwa'n gat lë' nile' xtu men lo go, orze' nu ska Xuz go Me nzho lo yibë', ya'l laxto' rë kwa'n gat lë' nile' go lo Me, ");
INSERT INTO zcaNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","per chi naya'lt laxto' go rë kwa'n gat lë' nile' xtu men lo go, orze' nu ska Xuz go Me nzho lo yibë', naya'lt ska laxto' Me rë kwa'n nile' go. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’No or na'b go lo Dios dub xlats go; nale't go nalats lo go nela nile' rë xa' chigab walika men wen; nalats nile' bixa' lo bixa' or nina'b bixa' lo Dios xlats bixa' par ne mene namás. No walika kwa'n nin, yalnak bixa' sa', nab tsa lo rë men yizhyuo ña'n bixa' wen, per par lo Dios, yent kwan gal bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Per go, or zo go xlats go lo Dios par na'b go lo Me, bichob go aseit yek go no bizët go lo go, ");
INSERT INTO zcaNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","nes par nane rë men, nzo go xlats go lo Dios; no Xuz go Dios Me niwi' lo rë kwa'n nzhak xla'n; lë' Me ne' tu kwa'n wen ka' go por nile' go sa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Naku'chao't go rë kwa'n tsak nzho yizhyuo re', plo nilox rë kwa'n nzhao mbëze, mbaino nikibëowe, plo ño rë men wa'n, niliwa'ne; ");
INSERT INTO zcaNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","más wen bile'o xigab xmod le'o kwa'n tsak lo Dios, no por rë kure' gal go tu kwa'n lo yibë' kwa'n más tsak, plo nagaot mbëz kwa'n, mbaino ni nakibëowe, no ni rë wa'n nayo ze' par liwa'ne. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","No plo kinu go kwa'n tsak che'n go, ze' nzo xigab che'n go. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Lë' yalnaban che'n men nak nela tu biani par dub men. Chi lë' yalnaban kwa'n kinul nizini, orze' dubal ñani; per chi gat nizini yalnaban che'nal, orze' dubal nzo lo nakao; ");
INSERT INTO zcaNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","no chi dubal nzo lo nakao por gat nizini yalnaban che'nal, orze', ¡dox nazhe'b nzhal! ");
INSERT INTO zcaNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Yent cho tu mos gak le' zhi'n che'n chop xa' nile' mandad lo xa' tutsa or; porke lë' mos yi' ne tu xa', no xtu xa' chizhi' mos; o ro' tu xa' gon mos, mbaino ro' xtu xa' nagont mos. Kuze', nagakt le' go kwa'n nzhakla Dios, mbaino wix go gap go dimi. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Kuze' nin lo go: Nale't go be's xigab por kwa'n gao go, o por kwa'n go go par ban go; no ni nale' go dox xigab por kwa'n gak go. ¿Chi nanet go, más tsak yalnaban che'n men lo kwa'n nzhao men, mbaino más tsak men lo xab men? ");
INSERT INTO zcaNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Biwi' go lo rë miyin kwa'n nikizë lo yibë'; naban ma no ni gat nzha'n ma, mbaino ni gat nikan ma yalgo'n, par kuchao' ma kwa'n gao ma; per Dios Xuz go Me nzho lo yibë', niza' kwa'n nzhao ma. No, ¿chi nanet go, más tsak go lo rë miyin? ");
INSERT INTO zcaNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","No ter dox nile' go xigab, ¿xmod le' go par ban go xtu or más lo rë li'n, kwa'n mine' Dios ban go yizhyuo re'? ");
INSERT INTO zcaNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Chon nile' go be's xigab plo ro' xab go? Bile' go xigab por rë ye' dan, xmod niro'be: Gat nikëte zhi'n, no ni gat nitibe lar. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Per ni rey Salomón, ter dox miar kwa'n ngop xa', no nangakt xab xa' nela xmod nilu' tu ye' ga'. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","No chi sa' nile' Dios nilu' rë yix kwa'n nzhi'b dan nal, mbaino yë', lë'i yëk la lo ki, orze', ¿chi nale't Dios más kwa'n por go? Tatu nazhe'b nak go, gat nzhont goi, we'tsa ñila go Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kuze', nagabt go nal: “¿Plo ro' kwa'n gao be no kwa'n go be, mbaino lar gak be?”, ");
INSERT INTO zcaNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","porke kure' nile' rë men, xa' gat nili'be't Dios; per go, lë' Xuz go Me nzho lo yibë', nane la, lë' go naki'n rë kure'. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kuze' galo laka biwi' go lo Dios por rë kwa'n naki'n go, mbaino ban go nela xmod nzhakla Me, orze' lë' Me zilazh rë kwa'n naki'n go ba'. ");
INSERT INTO zcaNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kuze' nale't go be's xigab por rë kwa'n naki'n go yë'. Kad ngubizh nzadnu kwa'n nizob xigab yek men, kuze' gat ñalt le' go xigab par yë'. ");
INSERT INTO zcaNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Nagabtal kwan ñal tu men or nile' xa' tu kwa'n gat lë', nes par nazakzi Diosal or nul nile'i, ");
INSERT INTO zcaNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","porke or nini'l tich tu men por xmod nak xa', sa' ska le' Dios kun lu. ");
INSERT INTO zcaNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Chon nila'chal por yix kwa'n nzho zalo xtu men, no chi nanetal, lë' tu kwa'n más kwa'ro nzho zalol? ");
INSERT INTO zcaNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","No chi más tu kwa'ro nzho zalol, ¿xmod gabal lo wechal: “Dinu lol, kon yix”? ");
INSERT INTO zcaNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Tatu nazhe'b nakal, chigab walika men wenal! Galo laka gulo' yix ro kwa'n nzho lol ba', nes par gak wi'l wen no ko'l yix kwa'n nzho zalo wechal ba'. ");
INSERT INTO zcaNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Naza't go kwa'n nazhon che'n Dios ka' rë xa' gat nzhont nzho Dios, par nayëk bixa' dil bixa' kun go, orze' lo'x bixa' go tuli. Mbaino naza't go rë kwa'n tsak che'n Dios par ka' wanei cho xa' gat nambet laxto' lo Dios; nayot laxto' bixa' yalnazhon che'n Dios, nitsinu bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","No nzhab Jesús: ―Dubta' bina'b go kwa'n naki'n go lo Dios, lë' Me ne'i; dubta' bikwa'n goi lo Dios, lë' Me le' yazhël go kwa'n naki'n go; mbaino zilita' bikwe'zh go ro' yo', lë' Dios xa'le, ");
INSERT INTO zcaNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","porke tu men nina'b tu kwa'n lo Dios, lë' Dios za'i; mbaino xa' nikwa'n tu kwa'n, lë' xa' yazhële por Dios; no xa' nikwe'zh ro' yo', lë' Dios xa'le. ");
INSERT INTO zcaNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","O, ¿cho tu go, za' tu ke gao xmë'd go or nina'b më'd tu yët gao më'd lo go?; ");
INSERT INTO zcaNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","o, ¿chi ziza' go tu mbë'l gao më'd or nina'b më'd tu mbël gao më'd? ");
INSERT INTO zcaNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","No chi nzhak go niza' go kwa'n wen par xin go ter nile' go kwa'n gat lë' lo Dios, per Xuz go Diose, Me nzho lo yibë', más nzhak Me niza' Me kwa'n wen ka' rë men, xa' nina'be lo Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Chi se' nazhi' Dios go, se'ska bile' go kun men, nela xmod nzhakla go le' men kun go ga'; porke kure' nzobni' lo ley che'n Muisés; no se'ga' midi'zh rë profet, rë xa' midi'zh por Dios nzhala. ");
INSERT INTO zcaNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Bile' pa' go por yo go ro' puert naya, porke pwert mbaino nez kwa'n ña par gabil, dox naxene, no dox nayax men ño ze'; ");
INSERT INTO zcaNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","per naya nez no naya pwert kwa'n ña plo nzho Dios, Me niza' yalnaban par dubta' ka' men; kuze' che'ptsa men ño ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Bikina go go lo rë xa' chigab walika nidi'zh por Dios; ter nilu' nado' bixa' nela tu mbëkxi'l ga', per le'n laxto' bixa' nak bixa' nela tu ma nazhe'b ga', ");
INSERT INTO zcaNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","per por zhi'n kwa'n nile' bixa', li'be' go cho men bixa'; lë' go nane ka, gat nikët gub lo cho la ya, no ni nzhao' gat nikëte lo ya yich. ");
INSERT INTO zcaNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kuze' rë ya wen niza' xlë wen, mbaino rë ya nazu't, xlë nazu't ska niza'i, ");
INSERT INTO zcaNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","porke tu ya wen za'te xlë nazu't, no ni tu ya nazu't naza'te xlë wen. ");
INSERT INTO zcaNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","No rë nak ya kwa'n gat niza't xlë wen, lë'i ro'g no yoi lo ki par yole. ");
INSERT INTO zcaNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Sa' ska por kwa'n nile' bixa', ne go cho men bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Gat lë't rë xa' nine lon: “¡Señor, señor!”, yo plo nile' Dios mandad; lë'i nab tsa rë xa' nile' kwa'n nzhakla Xuza Me nzho lo yibë', yo ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Zhë ze', nayax men ne lon: “¡Señor, señor! No midi'zh widi'zh che'n go lo men, no por yalnazhon che'n go ngulo' no mbi mal laxto' rë men, mbaino nayax kwa'n nazhon mile' no por yalnazhon che'n go.” ");
INSERT INTO zcaNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Per orze' lë'da gap: “Lalta' gat libe'n go; yubchi go lon, ¡rë go xa' mila' ley che'n Dios tu lad, nayi'lazh go!” ");
INSERT INTO zcaNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Kuze', rë xa' nzhon xti'zha no nile' xa' kwa'n nzhapa, men ze' nak nela tu men natsin, kwa'n michao' tu lizh yek tu ke ro. ");
INSERT INTO zcaNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","No or ngula tu yiubi nazhe'b, miro'b you', naye ndin nits ta' yo' ze', per ni nangayalai, por nzobe lo ke. ");
INSERT INTO zcaNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Per rë xa' nzhon xti'zha, no gat nile't xa' kwa'n nzhapa, rë men ze' nak nela tu men yent xigab kwa'n michao' tu lizh lo pura yux. ");
INSERT INTO zcaNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","No or ngula yiubi nazhe'b, miro'b you', naye ndin nits ta' yo' ze', ngubixchei, orze' milao'we. ");
INSERT INTO zcaNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","No or milox midi'zh Jesús kure' lo rë xa' nzhin ze', xe mia'n bixa' tuli por kwa'n midi'zh Me, ");
INSERT INTO zcaNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","porke nitse'd Me men nela tu xa' nile' ka mandad, no gat nakt Me nela rë maestr xa' nilu' ley che'n Moiseze. ");
INSERT INTO zcaNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","No or ñala Jesús yek lom ze', nayax dox men nzadkë tich Me, ");
INSERT INTO zcaNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","lë'chi nguzubi tu miyi' lo Jesús, tuli ngo't kuslo xa' lo Me; no miyi' re' nizak tu yalyizh kwa'n lë lepra, orze' nzhab xa' lo Jesús: ―Lë' go, chi lë'o nzhaklai, gak liyak go da. ");
INSERT INTO zcaNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Orze' mitsiga' Jesús ya', no migal Me yek miyi' re', nzhab Me: ―Nzhaklan niwenal. Orze' lwega' miak xa' re', no mimbe xa', ");
INSERT INTO zcaNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","orze' nzhab Jesús: ―Wi'le, nadi'zhtle lo men, maska wa lo ngulëi' par rël xa' lu, no biza' gon nela xa nzobni' lo ley che'n Muisés par ne xa', lë'l uniwen la. ");
INSERT INTO zcaNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","No or nguio Jesús yezh Capernaúm, nguzubi tu capitán xa' nzë Roma lo Me, dox nalats mile' xa', nguna'b xa' lo Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","nzhab xa': ―Lë' go, kinun tu mos da, nax nzhakne, nagakt win xa', no dox yalne kinu xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Orze' nzhab Jesús: ―Lë'da yal, liyaka xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Orze' nzhab capitán ze': ―Lë' go, gat ñalt da yi'd go lizha; namás bile' go mandad por xti'zh go, lë' mos da niwen, ");
INSERT INTO zcaNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","porke kinun más rë xa' nile' mandad lon, no nu ska da kinu rë sondad xa' nile' kwa'n nzhapa; chi gapa lo tu xa': “Wa”, lë' xa' ya; no chi gapa lo xtu xa': “Dë'”, no lë' xa' yë'd; no or gapa lo tu mos da: “Bile' kure'”, no lë' xa' le'i. ");
INSERT INTO zcaNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Or mbin Jesús kure', xe miwi' Me, orze' nzhab Me lo rë xa' nzhakë tich Me: ―Walika kwa'n nin lo go; per ni xid rë men Israel gat nen tu xa' ñila xti'zha nela miyi' re', ");
INSERT INTO zcaNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","no nin lo go, nayax men yi'd nez plo nilen ngubizh, no nez plo ña'z ngubizh, par gao bixa' lo mes kun Abraham no kun Isaac, mbaino kun Jakob plo nile' Dios mandad, ");
INSERT INTO zcaNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","per rë men Israel xa' gat nzhont widi'zh che'n Dios, lë' Dios xë'l bixa' plo nakao no plo go'n bixa' lo yalne, haxta kwezh lëi bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Orze' nzhab Jesús lo capitán ze': ―Bizë lizhal; sa' gake nela xmod ngwayilal da. No mis orze', tuli miak mos che'n capitán ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","No or mizhin Jesús lizh Per, une Me, lë' xna'zha'p Per nax lo lo'n, nizak xlë', ");
INSERT INTO zcaNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","no migal tsa Jesús ya' xa' una' re', tuli nguro' xlë' xa', no ngwaxche xa', orze' miza' una' re' kwa'n ndao Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","No or nzhazhëlalyuo, nzhanu men nayax xa' nzho mbi mal laxto', lo Jesús; no kun widi'zh che'n Jesús namás, mile' Me mandad nguro' rë mbi mal laxto' rë men ze'; no nu miliyak Jesús rë nak rë xa' nzhakne nzhin ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Rë kure' ngok par mizhin rë kwa'n midi'zh Isaías, tu xa' midi'zh por Dios nzhala, or nzhab xa': “Lë' xa' re' mbi'y yalyizh che'n be, no ñanu xa' yalne che'n be.” ");
INSERT INTO zcaNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","No or une Jesús, nayax men nzhin naka'n plo nzo Me, orze' mile' Me mandad, ded Me kun rë men che'n Me xtu ro' lagún, ");
INSERT INTO zcaNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","no ze' nguzubi tu maestr lo Jesús, tu xa' nilu' ley kwa'n mila' Dios lo Muisés, no nzhab xa': ―Maestr, nzhaklan yi'd kë'n tich go rë plo ya go. ");
INSERT INTO zcaNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Orze' nzhab Jesús: ―Rë mbëëz kinu lizh, no rë miyin kinu yo che'n, per Xga'n Dios Me nu nak tu men yizhyuo, gat kinut ni plo ga'. ");
INSERT INTO zcaNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Orze' nzhab xtu men che'n Jesús: ―Gulëz go, galo laka nzhakacha xuza, orze' yi'dkë'n tich go. ");
INSERT INTO zcaNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Per nzhab Jesús: ―Tuli di'kë ticha, bila' ka'ch rë men, xa' nak nela men ngut ba', tsa' men ngut bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","No or nkë Jesús le'n tu bark, rë men che'n Me nzha kun lë' Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","No or nzha la bixa' garol sao' nits, lë'chi nguro' tu yiubi nazhe'b le'n nits, no kun rë bol che'n nits, nila' yitlo bark le'ne, per lë' Jesús naxnaa, ");
INSERT INTO zcaNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","orze' ngwalixche men che'n Me Me, nzhab bixa': ―¡Lë'o, nala't go ya'zyuo' no le'n nits! ");
INSERT INTO zcaNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Orze' nzhab Jesús: ―¿Chon dox nizheb go? Kuba' nak por gat ñila go Dios be's. Or midi'zh Me kure', ngwatsuli Me no mile' Me mandad par kwëz yiubi no nits, orze' rëi mia'n xe, ");
INSERT INTO zcaNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","orze' xe mia'n rë men che'n Me, no nzhab bixa' lo wech bixa': ―¿Plo nzë xa' re' se? ¡Haxta yiubi no nits nzhon ro' xa'! ");
INSERT INTO zcaNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","No or mizhin Jesús xtu ro' lagún, plo ña'n lazh men Gadara, ze' mizhë'l Jesús chop xa' nzho dox mbi mal laxto'; nguro' bixa' le'n panteón, no dox nayi'lazh bixa', kuze' ni tu men gat nidedt ze', ");
INSERT INTO zcaNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","lë'chi nguruzhië bixa', nzhab bixa': ―¿Kwan nzhaklal linul no, Jesús Xga'n Dios? ¿Chi nzë'l par zakzil no dub naga gal zhë or gab Dios xmod gak kun no? ");
INSERT INTO zcaNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","No gax laka ze' nzhin tu bëd kuch kiyao; ");
INSERT INTO zcaNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","nalats midi'zh rë mbi kwa'n nzho laxto' rop rë men re' lo Jesús, nzhabe: ―Chi lë'l kutin no laxto' rë xa' re', neka bila' bi no laxto' rë kuch ba'. ");
INSERT INTO zcaNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Orze' nzhab Jesús: ―¡Bizë go! Or nguro' rë mbi mal ze' laxto' rop miyi' ze', par ñai le'n rë kuch ze', lë'chi ñaoxo'n rë ma, no ngula bima ro' tu bilë' plo nak ro' nits, ze' ngwap bima, ");
INSERT INTO zcaNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","no or une rë xa' kikina rë kuch ze' kure', mikë' bixa' karre, ña bixa'; no or mizhin bixa' yezh plo nzho bixa', midi'zh bixa' rë nak kwa'n une bixa', no xmod ngulo' Jesús rë mbi mal kwa'n nguio laxto' rop men ze', ");
INSERT INTO zcaNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","lë'chi rë nak men yezh ze' nguro' bixa' par nzhatsi' bixa' plo nzo Jesús; no or mizhin bixa' plo nzo Me, orze' mina'b bixa' ro' Jesús ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","No or milo'x ngok rë kure', nkë Jesús le'n tu bark par nded Me xtu ro' lagún, orze' mizhin Me lazh Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ze' mizhinu pla miyi' tu men nzhakne nax xa' lo tu tapexk, no nagakt win xa'; no or une Jesús dox ñila rë xa' re' Me, orze' nzhab Me lo men nzhakne ze': ―Bizak laxto' xga'n; lë' rë kwa'n nzë'b xkil mizhe' la lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Lë'chi ze' nzhin pla maestr, xa' nilu' ley che'n Muisés, orze' xla'n nzhab bixa' lo wech bixa': ―¡Nayi' kwa'n midi'zh xa' re' par Dios! ");
INSERT INTO zcaNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Or une Jesús cho xigab kile' rë xa' re', tuli nzhab Me lo bixa': ―¿Chon tatu gat lë' kwa'n kile' go xigab? ");
INSERT INTO zcaNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Kwan más jwals gapa?: “Lë' rë kwa'n nzë'b xkil lo Dios mizhe' la”, o gapa: “Waxche, no nguzë.” ");
INSERT INTO zcaNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","No par ne go, na Xga'n Dios, no nak da tu men yizhyuo, mbaino kinun yalnazhon par che'n rë kwa'n nzë'b xki men. Orze' nzhab Me lo xa' nagakt win re': ―Waxche, gulits kwa'n naxal lo, no bizë lizhal. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tuli ngwaxche xa' nagakt win ze', mbaino ña xa' lizh xa', ");
INSERT INTO zcaNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","no rë xa' nzhin ze', or une bixa' kwa'n mile' Jesús, mizheb bixa' tuli, orze' nguzublo kidi'zh bixa', dox nazhon Dios mbaino niza' Dios yalnazhon nka' rë men par le' bixa' kwa'n nazhon. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","No or nguro' Jesús ze', une Me tu miyi' xa' lë Mateo, xa' nikan dimi che'n rey César, nzob xa' lo mes plo ñatix men dimi che'n rey; orze' nzhab Jesús lo xa': ―Dikë ticha. Tuli ngwatsuli Mateo, nzhakë xa' tich Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","No or nzob Jesús lo mes lizh Mateo, no kiyao bixa', lë'chi ze' mizhin nayax xa' nikan dimi che'n rey César, kun más rë xa' gat nile't kwa'n nzobni' lo ley che'n Muisés; rë bixa' nzob lo mes kun Jesús, mbaino kun rë men che'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Or une rë men fariseo kure', orze' nzhab bixa' lo rë men che'n Jesús: ―¿Chon tutsa nzhao maestr che'n go kun rë xa' nikan dimi che'n rey César, no kun rë men nzë'b xki lo Dios? ");
INSERT INTO zcaNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Or mbin Jesús kure', nzhab Me: ―Rë men gat nzhaknet, gat naki'nt xa' doctor, nab tsa rë xa' nzhakne naki'n doctor. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kuze' bile' pa' go por tse'd go kwa'n nzhab widi'zh che'n Dios re': “Na nzhakla, lats laxto' go xtu men, ke par ne' go gon lon”, porke gat nzhalta par kwezha rë xa' nile' kwa'n nzhakla Dios; na nzhal par kwezha rë men nzë'b xki lo Dios, par la' bixa' rë kwa'n gat lë' nak bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Orze' lo Jesús nguzubi pla rë men che'n Juan xa' nili'lëi' men le'n nits, par nzhab bixa': ―Lë' no, mbaino rë men fariseo, dox nizo no xlats no or nina'b no lo Dios; per rë men che'n go, gat nizot bixa' xlats bixa' par na'b bixa' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Orze' nzhab Jesús: ―¿Chi zak zo men xlats men, na'b men lo Dios, dub nzo xa' gak jwandang che'n ze'? Per or zhin zhë yubchi miyi' ze', orze'se lë' bixa' zo xlats, na'b bixa' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","No yent cho cho' tlë' vestid kub par kë' xa' rëmiënd tu vestid go'x; porke nazhëlt lar kub kun lar go'x, porke xekt lar go'x, lë'i rëz; ");
INSERT INTO zcaNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","no ni nako men vin kub le'n tu kwa'n go'x; porke lë' vin kub chëz kwa'n go'x ze', orze' rope nazu'tra'. Kuze' naki'n yo vin kub le'n tu kwa'n kubska, nes par rope zu'. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Dub kidi'zh Jesús kure', lë'chi mizhin tu miyi' xa' nile' mandad xid rë men Israel, tuli ngo't kuslo xa' lo Jesús, nzhab xa': ―Lë' xcha'pa nzë'b ngut, per chi lë' go yi'd mbaino xo'b go ya' go yek ne', lë' ne' ruban. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Orze' ngwatsuli Jesús, ñakë Me tich xa' ze' kun rë men che'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","No xid rë men ze' nzha tu una', xa' nzhala tu dusen li'n nzhakne, nizak xa' kwa'n, orze' nguzubi xa' al tich Jesús par migal xa' xi' xab Me, ");
INSERT INTO zcaNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","porke mile' xa' xigab: “Sol gala xi' xab Jesús namás, lë'da yak.” ");
INSERT INTO zcaNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tuli miëk Jesús, no or une Me una' ze', nzhab Me: ―Xcha'p, bizak laxto'; nab tsa por ngwayilal da, lë'l niwen la. Orze', uniwen una'. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","No or mizhin Jesús lizh xa' nile' mandad ze', une Me kiyo'l la musk par yaka'ch bixa' mizhwin ye'n re', mbaino dox nibizhyë men, no kiyo'n bixa', ");
INSERT INTO zcaNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","orze' nzhab Jesús: ―Bizë go lizh go, porke gat lë't ngut mizhwin ye'n re', ka naxnaa më'd. Orze' mixizhnu rë men Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","per or ña rë men ze', nguio Jesús plo nax më'd re', nguzen Me ya' më'd, orze' nguruban më'd mbaino ngwaxche më'd, ");
INSERT INTO zcaNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","no nguxo'bdi'zh kure' rë nak yezh kwa'n nzhin naka'n ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","No or nguro' Jesús ze', nzhakë chop men nikal lo tich Jesús, nibizhyë bixa' nzhab bixa': ―¡Bilats laxto' no, xga'n Dabi! ");
INSERT INTO zcaNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","No or nguio Jesús le'n tu yo', nguzubi rop xa' re' lo Jesús, orze' nzhab Jesús lo bixa': ―¿Chi ñila go, gak len yani lo go? Orze' nzhab bixa': ―Lë' no ñila ka, lë' go gak ka le'i. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Orze' migal Jesús zalo bixa', mbaino nzhab Me: ―Sa' gak kun go nela xmod ñila go da. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Orze' ngwani zalo rop bixa', no chop-chon nzhab Jesús lo bixa': ―Yent cho lo gab go kure'. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Per mas nguro' bixa' ze', tuli mixo'b di'zh bixa'i rë yezh kwa'n nzhin naka'n ze', kwa'n mile' Jesús por lë' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","No kwanti gatsa di nguro' rop xa' miak zalo ze', orze' mizhinnu pla men tu miyi' nagakt di'zh lo Jesús, por nzho mbi mal laxto' xa', ");
INSERT INTO zcaNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","no or ngulo' Jesús mbi mal laxto' miyi' ze', tuli ka nguzublo kidi'zh xa', no rë men nzhin ze', xe mia'n bixa' tuli, no nzhab bixa': ―¡Lalta' gat ne men tu kwa'n se'ta' lazh men Israel! ");
INSERT INTO zcaNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Per nzhab men fariseo: ―Lë' Mizhab kwa'n nile' mandad lo rë mbi mal, miza' yalnazhon nka' miyi' ba', kuze' nzhak nigo' xa' mbi mal laxto' men. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","No se'ga' nikizë Jesús rë yezh no rë rranch, kilu' Me xmod nak widi'zh nazhon che'n Dios par yo men plo nile' Dios mandad, kilu' Mei le'n rë yo' plo nitse'd men Israel widi'zh che'n Dios, mbaino kiliyak Me rë lo yalyizh no yalne kwa'n nizak men. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Or une Jesús rë men ze', dox milats laxto' Me bixa', porke yentra' cho gaknu bixa', ngwazha bixa' naban bixa', nak bixa' nela rë mbëkxi'l kwa'n niyent cho nikina ga', ");
INSERT INTO zcaNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","orze' nzhab Me lo rë men che'n Me: ―Walika, nzho nayax dox men yizhyuo, xa' nagat gon xti'zha, per che'ptsa men kinun, xa' nilu' widi'zh che'n Dios lo rë men, xa' nak nela tu yalgo'n kwa'n une la yats, no che'ptsa mos nzhin par litse. ");
INSERT INTO zcaNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kuze', naki'n na'b go lo Xuza, Me nak che'n rë yalgo'n re', par xë'l Me más mos par kane. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","No or ngurezh Jesús za tu dusen xa' mixë'l Me par le' rë zhi'n nazhon che'n Me, orze' miza' Me yalnazhon nka' bixa' par ko' bixa' mbi mal laxto' men, no liyak bixa' men nizak wanei cho yalyizh, no cho yalne. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Se' lë rë za tu dusen apost: xa' galo laka lë Simón Per, kun wech xa' xa' lë Ndres; no Jakob kun wech xa' Juan; xuz rop xa' re' lë Zebedeo; ");
INSERT INTO zcaNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","mbaino Lip kun Bartolomé, no Max, kun Mateo xa' mikan dimi che'n rey César; mbaino Jakob xga'n Alfeo, no tu xa' lë Lebeo xa' nzhab ska men lë Tadeo; ");
INSERT INTO zcaNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","mbaino Simón xa' nzë xid men Kananist, no Judas Iscariote, xa' michi Jesús lo rë men par ngut Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Or mixë'l Jesús za tu dusen men che'n Me par yalu' bixa' xmod gak men, men che'n Dios, kure' mile' Jesús mandad lo bixa', nzhab Me: ―Nayat go rë yezh plo nzho rë xa' gat lë't men Israel, no ni naya go lazh men Samaria. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nabtsa wa go rë yezh plo nzho men Israel, rë xa' nak nela rë mbëkxi'l nguziwan dan ga', ");
INSERT INTO zcaNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","par gab go lo bixa': “Bila' go rë kwa'n gat lë' nak go lo Dios; lë' zhë mizhin la gak go men che'n Dios.” ");
INSERT INTO zcaNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","No biliyak go rë men nzhakne, mbaino bile' go ruban rë men ngut, no biliyak go rë men nizak yalyizh lepra, mbaino gulutin go mbi mal laxto' rë men. Ka minen yalnazhon re' ka' go; se'ska bile' go, ka bile' go rë kwa'n nazhon kun rë men rë plo ya go. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nawei't go dimi or, no ni dimi plat, mbaino ni dimi kwa'n kobr; ");
INSERT INTO zcaNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yent kwan wei' go nez, no ni nawei' go chop nez xab go, no ni xtu nez yalyid che'n go nawei't go, mbaino ni tu bar wei't go, porke xa' nikë zhi'n, ñal za' men kwa'n gao xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’No wanei plo zhin go, ze' gunabdi'zh go plo nzho tu men wen laxto'; lizh xa' ze' biya'n go haxta or ya go xtu plo. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","No or zhin go lizh xa' re', guzh go, lë' Dios le' ya rë bixa' wen, xa' nzho ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","No chi niwi' go, ñal ka bixa' rë widi'zh kwa'n nzhab go par lë' bixa', orze' lë' widi'zh ze' ya'n par lë' bixa'. Per chi gat ñal bixa' widi'zh nazhon re', orze' lë'i yëk ska lo go. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","No chi nzho bixa' gat nzhaklat ya go lizh bixa', o ni gat nzhakla bixa' gon bixa' widi'zh kwa'n lu' go lo bixa'; or ya go xtu plo, guzhib go ni' go par gab rë zhen yuo ze'. Kure' gak nela tu señ ga', lë' bixa' nzë'b xki lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Walika kwa'n nin, zhë gab Dios xmod gak kun rë men yizhyuo, más zakzi bixa' lo rë men yezh Sodoma no lo rë men yezh Gomorra. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’¡Biwi' go! Lë'da xël go nela mbëkxi'l ga', xid rë men xa' nak nela ma nazhe'b ga'; kuze' gok go natsin nela mbë'l ga', per gok go nado' nela palom ga'. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","No bikina go go lo rë men, porke lë' rë men chi go lo gustis, mbaino lë' bixa' kin go le'n rë yo' plo nitse'd men widi'zh che'n Dios, ");
INSERT INTO zcaNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","no haxta wei' bixa' go lo rë xa' nak gobiernador, mbaino lo rë rey, por nak go men da; nes par nu rë xa' ba' gon xti'zha, no haxta rë men xa' gat lë't men Israel gon xti'zha. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Per or chi bixa' go lo rë xa' nile' mandad, nale't go xigab xmod di'zh go, o kwan kab go lo bixa', porke or di'zh go, Dios ka ne' xigab ka' go par gak di'zh go lo bixa' lë'tsa kwa'n ñal, ");
INSERT INTO zcaNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","porke gat lë't go di'zh lo bixa'; lë' Sprit che'n Dios Xuz go, di'zh por go. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Rë men da mis wech xa', chi xa' par gat xa'; no mis xuz xa' chi xin xa', mbaino mis xin xa' chi xuz xa' no xna' xa', par gat bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","’No rë men yizhyuo yi' ne go por nak go men da. Per xa' naro't nez da dubta' nak xa' men da, xa' re' gap yalnaban dubta' kun Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Chi tu rë men yezh ru'kë tich go, bizë go xtu yezh; walika kwa'n nin, ni naga lox go kizë go rë yezh che'n men Israel, lë' Xga'n Dios, Me nak tu men yizhyuo, yubre la xtu wëlt. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Yent cho tu men más tsak lo xa' nitse'd xa', mbaino se'ska, yent cho tu mos nado más tsak xa' lo xa' nile' mandad xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kuze', nab tsa naki'n gak xa' nitse'd nela nak maestr che'n xa' ga', no rë mos nado lo xtu men, nab tsa ñal gak xa' nela men xa' nile' mandad lo xa'. No chi nidi'zh men na Mizhab, xa' lë Beelzebú, orze' se'ska di'zh men go. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Kuze' nazhebt go di'zh go rë kwa'n mbin go nin, porke yent tu kwa'n naga'ch midizha lo go nagon men; mbaino yent tu kwa'n xla'n milun lo go naded nagon men. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Rë kwa'n midizha lo go or yë'l, zhë bidi'zh goi lo men; mbaino rë kwa'n midi'zha xla'n lo go, guruzhië goi naye dizde yek yo' lo rë men. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nazhebt go lo xa' nzhut men, porke nab tsa kwerp nzhut bixa', per alm che'n go nagakt gal xa'. Más wen nab tsa lo Dios bizheb go, porke Dios gak gut go, mbaino gak xë'l Dios go le'n gabil par dubta'. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Lë' go nane ka, dox che'p tsak rë miyin ye'n or nido bine', per Dios nazhi' bima; no ni tu bima gat nzhat chi gat lë' por Dios Xuz goi. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Per go, más nazhi' Dios go, haxta rë yich yek go, nane Dios pla. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kuze' nazhebt go, porke más tsak go lo rë miyin. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Kuze', wanei cho tu xa' di'zh lo rë men, lë' xa' nak tu men da, nu ska da gap lo Xuza Me nzho lo yibë', xa' re' nak tu men da; ");
INSERT INTO zcaNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","per xa' gab lo rë men, gat nilibe't xa' da, se'ska gapa lo Xuza, Me nzho lo yibë', gat nilibe'tska xa' ba'. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Nagabt go nzhala par len kwin men wen yizhyuo re'; na nzhal par len lë' men, tu xa' kun xtu xa': ");
INSERT INTO zcaNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Na nzhal par lë' miyi' kun xuz miyi', no una' lë' kun xna' una', mbaino xix una' lë' kun xna'ye'. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kuze' mis kun rë xa' lizh men, gak xa' yi' ne men. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Men xa' más le' por xuz o por xna' ke por da, nazu't xa' ze' par gak xa' men da; mbaino xa' más le' por xga'n o por xcha'p ke por da, nazu't ska xa' gak xa' men da. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","No xa' tula por nak xa' men da, no naziyël xa' zakzi xa', mbaino ni gat xa', nazu't ska xa' re' gak xa' tu men da. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mbaino xa' nile' más por kwa'n yizhyuo re', nagakt ban xa' re' kun Dios; per xa' más nile' por kwa'n nak che'n Dios ke por kwa'n yizhyuo re', xa' re' ban kun Dios par dubta'. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Rë men, xa' niwi' wen lo go por nak go men da, lon niwi' xa' wen; no xa' niwi' wen lon, nu ska lo Xuza niwi' xa' wen, Me mixë'l da lo yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","No tu men, xa' za' lizh, ya'n tu xa' nidi'zh por Dios, Dios za' kwa'n ka' xa' nak lizh ze', nela kwa'n nika' xa' nidi'zh widi'zh che'n Dios. Mbaino se'ska men, xa' niza' lizh, par ya'n tu men xa' nile' kwa'n nzhakla Dios, se'ska kwa'n gal xa' nak lizh ze', nela kwa'n nika' men xa' nile' kwa'n nzhakla Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","No wanei cho tu xa' za' che'p nits nayag go tu men ye'n, xa' nak tu men da; walika kwa'n nin, por nits kwa'n miza' xa', lë' xa' gal tu kwa'n nazhon. ");
INSERT INTO zcaNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","No or milox nzhab Jesús lo za dusen men che'n Me xmod le' bixa' zhi'n nazhon che'n Me, orze' nguro' Me ze' par nzhalu' Me widi'zh che'n Dios rë yezh kwa'n ña'n lazh men Galilea. ");
INSERT INTO zcaNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","No Juan xa' nililëi' men le'n nits, dub nzho xa' lizhyi'b, mbin xa' rë kwa'n nazhon nile' Jesús, Me nak Krist, kuze' mixë'l xa' pla men che'n xa', ");
INSERT INTO zcaNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","par ngwana'bdi'zh bixa' lo Jesús, chi lë'ka Jesús nak Krist, o kwëz bixa' zhin xtu men. ");
INSERT INTO zcaNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Orze' nzhab Jesús: ―Wayab go lo Juan rë kwa'n une go no rë kwa'n mbin go; ");
INSERT INTO zcaNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","guzh go, rë' xa' nikal lo, niwi'; no rë men nagakt zë, nizë; mbaino rë xa' nizak yalyizh kwa'n lë lepra, nzhakwen; no rë xa' sord, nixa'l nzha; mbaino rë men ngut, niruban; no rë xa' yent kwan nzhap, lë' bixa' nzhon widi'zh nazhon che'n Dios, no niro' bixa' lo rë kwa'n nzë'b xki bixa' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Dox wen nzha rë xa' nayot la', yila da! ");
INSERT INTO zcaNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","No or ña rë xa' mixë'l Juan, orze' nguzublo kidi'zh Jesús kwent che'n Juan lo rë men, nzhab Me: ―Or ngwa go le'n yuo bizh, ¿cho une go ba'? ¿Chi une go tu men xa' nile' chop xigab or nile' xa' tu kwa'n, nela tu yaxtil kwa'n nikwin mbi rë lad? ");
INSERT INTO zcaNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Chi nangane go tu xa' sa', ¿cho ska xa' une gox? o, ¿une go tu xa' nak lar wen? Per rë xa' nzhak lar wen, nab tsa lizh rë rey nine men rë xa' ba'. ");
INSERT INTO zcaNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Per cho ka une gox? ¿Chi une go tu profet, xa' nidi'zh por Dios? Na ni walika, más tsak xa' une go ba' lo tu profet, xa' nidi'zh por Dios, ");
INSERT INTO zcaNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","porke kwent che'n Juan re' nize't ley che'n Dios, plo nzobni': Biwi', antis di yi'dal, galo laka tu xa' xëla par kuxkwa' nez dedal. ");
INSERT INTO zcaNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Walika kwa'n nin lo go, xid rë men yizhyuo, rë profet xa' midi'zh por Dios, Juan más tsak lo bixa'; per xid rë men da, plo nile' Dios mandad, xa' más che'p tsak, más tsak xa' re' lo Juan. ");
INSERT INTO zcaNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Dizde zhë nguzublo kidi'zh Juan widi'zh che'n Dios haxta nalzhë re', nab tsa men xa' nile' tutsa xigab gak le' gan yo plo nile' Dios mandad; nab tsa rë xa' nile' jwers yo, nak che'ne. ");
INSERT INTO zcaNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Rë profet xa' midi'zh por Dios, no rë kwa'n nzobni' lo ley, haxta zhë che'n Juan namás midi'y. ");
INSERT INTO zcaNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ter yila go kure' o nayilat goi, or midi'zh Dios por rë profet che'n Me, xë'l Me Li, mbaino Juan nak xa' mize't Me orze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Chi lë' go kiyon kwa'n kinin, bizobyek goi. ");
INSERT INTO zcaNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Per nal, ¿kun cho chë'lala rë men nal? Nak bixa' nela pla rë mbwin nizob le'n nez plo nzhak xbi' par niyit bimbwin; se' nidi'zh bimbwin lo zipla rë mbwin kwa'n nzhin ze': ");
INSERT INTO zcaNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“¿Chon nanet go kit go kun no? Mbi'l no bizhi, no nangolni't go; mbaino mikë' no kant nalats, per nango'nt go”, ");
INSERT INTO zcaNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","porke mbi'd Juan, xa' nizo xlats nayax wëlt, par nidi'zh xa' lo Dios, mbaino gat nzhot xa' vin; no nzhab go: “Mbi che'n Mizhab nzho laxto' xa'.” ");
INSERT INTO zcaNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Per na nzhala lo go, nzha̱o̱wa̱ mbaino nzho'n, no ne go lon: “¿Chon nzhao doxal, no nzhol vin? ¡No nichë'lal kun rë men xa' nikan dimi che'n rey César, mbaino kun rë xa' gat nile't kwa'n nzobni' lo ley che'n Muisés!” Per kwa'n nilun mbaino kwa'n nilu' Juan, nilu' lë'tsa lë' kwa'n nidi'zh no, por rë men nzhone no naban xa' xmod nidi'zh no. ");
INSERT INTO zcaNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Orze' nguzublo kidi'zh Jesús por rë kwa'n gat lë' nak rë men xa' nzho rë yezh plo mile' Me nayax kwa'n nazhon, per nangala't bixa' rë kwa'n gat lë' nak bixa' lo Dios, kuze' nzhab Jesús: ");
INSERT INTO zcaNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Zhe'b nalats nzha go, men yezh Korazín, no men yezh Betsaida! Chi lo rë men yezh Tiro, no lo rë men yezh Sidón, ngalen rë nak kwa'n nazhon kwa'n milen xid go, orze' rë men ze' ngayila da mbaino ngala' bixa' rë kwa'n gat lë' nak bixa' lo Dios, no ngak bixa' lar nagats, mbaino ngazob bixa' le'n kubde, par lu' bixa', lë' bixa' nizi, nzë'b xki bixa' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kuze', or gab Dios xmod gak kun kad men yizhyuo, más zakzi Dios men yezh Korazín no men yezh Betsaida ke rë men yezh Tiro no yezh Sidón. ");
INSERT INTO zcaNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","No rë go men yezh Capernaúm, ¿chi nile' go xigab bi go lo yibë' plo nzho Dios? Gat lë't sa'i. Na ni, ¡lë' go bi le'n bël!, porke chi yezh Sodoma ngalen rë kwa'n nazhon kwa'n milen lo go, orze' se'gaka ngabin yezh ze' haxta nalzhë re'. ");
INSERT INTO zcaNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kuze' nin lo go, zhë kwa'n gab Dios xmod gak kun rë men yizhyuo, más zakzi Dios go, lo rë men yezh Sodoma. ");
INSERT INTO zcaNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Orze' nzhab Jesús lo Xuz Me Dios: ―Dios, xkix Go, Payë', Me nile' mandad yibë' no yizhyuo, porke ngulu'ka'ch Go kure' lo rë xa' nzhak, no lo men natsin; mbaino ngulu'xo'b Goi lo rë men nado', xa' nak nela tu më'd ga'. ");
INSERT INTO zcaNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Walikai Xuza, porke sa' ngokla Go. ");
INSERT INTO zcaNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Lë' Xuza mila' rë kwa'n ya'n, no yent cho nili'be' Xga'n Xuza, nab tsa Xuza nilibe'; no yent cho nilibe' Xuza, nab tsa Xga'n Me nilibe', kun rë xa' ngule Xga'n Xuza, par libe' bixa' Xuza. ");
INSERT INTO zcaNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Dë' go lon, rë go xa' ngwazha naban lo rë kwa'n nizak go; na le xax go loi. ");
INSERT INTO zcaNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","No bitse'd go le' go kwa'n nin, no bitse'd go xmod nak da, porke na nak tu men nado' laxto', mbaino nizine laxto'n go, orze' lë' alm che'n go xax lo rë kwa'n nizak go, ");
INSERT INTO zcaNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","porke rë kwa'n nika'ba lo go, naxax laka le' goi; no rë kwa'n nilan di'zh lo go, gat nagant le' goi. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tu zhë kwa'n nayi' kë men Israel zhi'n, nzhaded Jesús kun rë men che'n Me plo ngo'n men triu. No mer orze' nila'n bixa', orze' nguzublo kikib bixa' do che'n triu no ndao bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Per or une pla men fariseo kure', orze' nzhab bixa' lo Jesús: ―Biwi', lë' rë men che'nal kile' kwa'n gat ñalt le' bixa', zhë kwa'n nayi' kë men Israel zhi'n. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Orze' nzhab Jesús: ―¿Chi nagat go'l go plo nzobni' kwa'n mile' Dabi, tu or mila'n xa' kun rë men che'n xa'? ");
INSERT INTO zcaNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nguio xa' le'n yo' che'n Dios, no ndao bixa' pan kwa'n niza' men par gon che'n Dios, no pan re' gat ñalt gao bixa'i, no ni rë men che'n xa'; nab tsa rë ngulëi' ñal gawe. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","O, ¿chi nagat go'l go kwa'n nzobni' lo ley kwa'n mila' Dios lo Muisés, xmod nile' rë ngulëi' le'n yado', zhë kwa'n nayi' kë men Israel zhi'n? Mbaino gat nile't bixa' diskans zhë ze', no gat nayi'te par lë' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Per na ni lo go, re' nzo tu xa' más tsak lo yado'. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Per go nazobyekt go widi'zh kwa'n nzobni' re': “Gat nzhaklata ne'u go gon Da; kwa'n nzhaklan, lats laxto' go tsa' men go.” Per chi ngazobyek go widi'zh re', orze' nangakë't go kixu' men yent kwan nak. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Lë' Xga'n Dios Me nu nak tu men yizhyuo, gak gab Me lo rë men, kwan ñal le' men, zhë kwa'n nayi' kë rë men Israel zhi'n. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Or mila' Jesús rë men ze', nguio Me le'n tu yo' plo nitse'd men Israel widi'zh che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","No ze', nzob tu miyi' xa' mibizh tu ya', no pla men Israel xa' nzhin ze', kikwa'n bixa' mod par kë' bixa' kixu' Jesús, kuze' nzhab bixa' lo Me: ―¿Chi nzhab ley che'n Muisés, gak liyakal tu men zhë kwa'n nayi' kë rë men Israel zhi'n? ");
INSERT INTO zcaNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Orze' nzhab Jesús: ―Cho tu men xid go kinu tu mbëkxi'l, no chi lë' ma la le'n tu zo, zhë kwa'n nayi' kë go zhi'n, ¿gat lë'o ko' ma orze', chi tlë' ma zake zhë ze'? ");
INSERT INTO zcaNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Chi nanet go, más tsak tu men lo tu ma? Kuze', gak ka le' men kwa'n wen, ter zhë kwa'n nayi' kë go zhi'n. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Orze' nzhab Me lo xa' mibizh ya' ze': ―Bitsiga' ya'l. No or mitsiga' xa' ya' xa', tuli miake, ngoke nela nak ka xtu ya' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Per or nguro' rë men fariseo ze', orze' midi'zh rë bixa' xmod le' bixa' par gut bixa' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Per or ngwanu laxto' Jesús kwan kile' rë men fariseo ze' xigab, tuli nguro' Me ze', no dox men nzhakë tich Me, mbaino miliyak Me rë lo yalyizh kwa'n nizak rë men ze', ");
INSERT INTO zcaNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","no nu mile' Me mandad lo rë men, naxo'bdi'zht bixa' kwa'n nile' Me, ");
INSERT INTO zcaNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","nes par ngok widi'zh kwa'n midi'zh Isaías, tu xa' midi'zh por Dios chi tiemp or nzhab xa': ");
INSERT INTO zcaNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Biwi' go, lë' mos da re', xa' kwa'n ngulen, no xa' nazhi' da; nizak laxto'n por lë' xa'; lë' Sprit da zan ka' xa', par lu' xa' lo rë men xmod ko' Dios rë lo men lo rë kwa'n gat lë'. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nachë'lro't xa' kun men, no ni nakuzhië xa' lo men, mbaino ni nagon men chi xa' le'n nez. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Gat naya't xa' kun rë men xa' che'ptsa ñila Dios, mbaino nakubchit xa' men, xa' pe'n nzo lo Dios, lë'la más chi xa' men lo Dios, ");
INSERT INTO zcaNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","no rë men xa' gat lë't men Israel yila widi'zh che'n xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","No ngwanu bixa' tu miyi' lo Jesús, tu xa' nzen tu mbi mal; nikal lo xa' mbaino mud xa'; orze' miliyak Jesús miyi' re', ngwani lo xa' no midi'zh xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","No rë nak xa' nzhin ze', xe miwi' bixa' tuli, orze' kina'bdi'zh bixa' lo wech bixa': ―¿Chi gat lë't xa' re' Xga'n Dabi? ");
INSERT INTO zcaNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Or mbin rë men fariseo kure', orze' nzhab bixa': ―Lë' xa' re' nigo' mbi mal laxto' men por mandad che'n Beelzebú, yub Mizhab kwa'n nile' mandad lo rë mbi mal. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Per lë' Jesús nane la cho xigab kile' bixa', orze' nzhab Me: ―Rë gobier, chi gat nzhin bixa' wen kun rë men che'n xa', lë' bixa' lë'; se'ska rë men yezh, chi gat nzhin bixa' wen, lë' bixa' lë'; mbaino se'ska rë men kun rë xa' lizh xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Se'ska, chi dil yub Mizhab, kun rë mbi mal che'n xa', lë' bixa' bil. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","No chi na nigo' mbi mal laxto' men por Beelzebú, xa' nak yub Mizhab, orze', ¿chi nu rë men che'n go nigo' mbi mal laxto' men por Beelzebú? Kuze', por di'zh yix go, lo mis men che'n go ne kwan ñal go. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Per chi na nigo' mbi mal laxto' rë men por Sprit che'n Dios; kure' nilu', lë' Dios mizhin la lo go, par lat Me go ya' Mizhab. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Xmod le' tu men, yo xa' lizh tu miyi' xa' dox nzhak nidil, par liwa'n xa' rë kwa'n kinu miyi' re'? Naki'n galo laka li'bdo' xa' miyi', par gak lat xa' rë che'n miyi' re'. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Kuze', xa' gat nzhaknu da, xa' ze' nidil kuda; mbaino xa' gat nidi'zh xti'zha lo men, par gak men, men da, xa' ze' nichubla men lon. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Kuze' nin lo go, gak zhe' rë kwa'n nzë'b xki men lo Dios, no rë widi'zh gat lë' kwa'n nidi'zh men lo Dios. Per tu men nidi'zh kwa'n gat lë' por Sprit che'n Dios, ya nayotra' zhe' kwa'n nzë'b xki men re'. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","No cho tu xa' di'zh Da gat lë', Na, Me nak Xga'n Dios mbaino nak Da tu men yizhyuo, gak zhe' kwa'n nzë'b xki xa' re'; per xa' di'zh tu kwa'n gat lë' tich Sprit che'n Dios, nayotra' zhe' kwa'n nzë'b xki men re', ni lo yizhyuo re' mbaino ni lo yizhyuo kwa'n laore yo. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Chi lë'o kinu tu ya wen, xlë wenska za'i; per chi kinu go tu ya yent kwan zu', xlë zu'tska za'i. Nakbe' ya por xlë kwa'n niza'i. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Rë go nak nela rë mbë'l nayi' ga'! ¿Xmod di'zh go kwa'n wen, lë' go men nakap? Rë widi'zh kwa'n gat lë' kwa'n nzho laxto' go, kuze' niro' ro' go. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Men wen, kwa'n wen nidi'zh xa', porke kwa'n wen nzho laxto' xa'; no men nakap, kwa'n nakap ska nidi'zh xa', porke kwa'n nakap nzho laxto' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","No walika kwa'n nin re', zhë kwa'n gab Dios xmod gak kun kad men yizhyuo, rë widi'zh kwa'n gat lë' kwa'n midi'zh bixa' dub miban bixa' yizhyuo re', rëi na'b Dios kwent lo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Por rë widi'zh kwa'n niro' ro' go, ne Dios xa nak go, chi men wen go, o men nakap go. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Orze' pla rë men fariseo kun pla rë maestr xa' nilu' ley che'n Muisés, nzhab bixa' lo Jesús: ―Maestr, nzhakla no, ne no le'l tu kwa'n nazhon. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Orze' nzhab Jesús lo bixa': ―Minu la go lo Dios, mbaino nak go lo Dios nela rë xa' nile' burr tsa' ga'; kuze' kina'b go ne go tu kwa'n nazhon, per nanet goi. Nabtsa kwa'n mile' Dios nguzak profet Jonás ne go. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nela nguio Jonás laxto' mbël, chon ngubizh no chon yë'l, se'ska yo Xga'n Dios, Me nu nak tu men yizhyuo, chon ska ngubizh no chon ska yë'l, yo Me plo más na'ch le'n yuo. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","No rë men yezh Nínive, or gab Dios xmod gak kun kad men yizhyuo, lë' nu bixa' zo par gab bixa' lo Dios kwa'n nak go, par más zakzi Dios go; porke rë men yezh Nínive ze', mila' bixa' rë kwa'n gat lë' nak bixa' lo Dios or ngwadi'zh Jonás widi'zh che'n Dios lo bixa'; no biwi' go, na kidi'zh lo go, no más tsak da lo Jonás. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","No tu una' xa' mile' mandad lazh men Seba, or gab Dios xmod gak kun kad men yizhyuo, lë' nu una' zo kun rë men nal re', par gab una' rë kwa'n nak go par más zakzi Dios go; porke dox zit nguro' una' lazh una' par ngwayon una' rë widi'zh kwa'n nzhak Salomón; no biwi' go, na kidi'zh lo go, no más tsak da lo Salomón. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’No or niro' tu mbi mal laxto' tu men, orze' niki'zëi mont plo ni nits niyen, kikwa'ne plo kwëze; no or gat ñayazhële plo kwëze, ");
INSERT INTO zcaNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","orze' nile'i xigab: “Lë'da yëkska lizha plo nguro'n.” No or yëk mbi mal ze' laxto' men re', nak laxto' xa' nela le'n tu yo', plo nalo'b nambe ga', mbaino rë kwa'n le'ne nzhin chul, ");
INSERT INTO zcaNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","orze' ya mbi ze', yaka'i xtu gazh mbi más nakap, par yo rëi laxto' men re'; orze' lë' men re' gak más nakap, ke lë'la xmod nak xa' galo. No se'ska zak rë men nakap, xa' nzhin lo yizhyuo nal re'. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Dub kidi'zh Jesús kure' lo rë men, lë'chi mizhin xna' Jesús kun rë wech Me, nzhin bixa' tich, nzhakla bixa' di'zh bixa' kun lë' Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Orze' ngwayab tu men lo Jesús: ―Lë' xna' go no rë wech go nzo al tich, nzhakla bixa' di'zh bixa' kun go. ");
INSERT INTO zcaNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Orze' nzhab Jesús lo xa' ze': ―¿Cho xna'n, no cho rë wecha? ");
INSERT INTO zcaNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Orze' milu' Me rë men che' Me, xa' nizikë tich Me, no nzhab Me: ―Biwi' go, rë men re' nak xna'n no rë wecha, ");
INSERT INTO zcaNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","porke xa' nile' kwa'n nzhakla Xuza, xa' ze' wecha, no bizana, mbaino xna'n. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","No zhë ze' nguro' Jesús le'n yo' ze' par ngwa Me ro' lagún; ze' nguzob Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Por dox nayax men migan ze', nkë Jesús le'n tu bark, nguzob Me le'ne, no lë' rë men nzhin ro' nits. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Orze' midi'zh Me nayax kwa'n lo rë men ze' kun pura kwent, nzhab Me: ―Bingole, tu wëlt nzha tu men, nzhaya'n lazh triu lo yuo. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","No or ngwache'ch xa'i, pla lazhe ngob le'n nez, ndao miyine. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","No más lazhe ngob lo yuo ke; lwega' ngulëne, per niyent be's yuo ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Or ngulen ngubizh, no or mina ngubizh nayi', mike'x ngubizhe por niyen luche; mibizhe. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","No ziplai ngob le'n ya yich, per or miro'b ya yich, ngala't ya yich ngabane, orze' ngute. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Per ziplai ngob lo yuo wen, miro'be, no dox miza'i. Tu lazhe miza' tu gayo'i, xtu lazhe miza' chon gale, mbaino xtu lazhe miza' gal bichi'y. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡Chi lë' go mbine, bizobyek goi! ");
INSERT INTO zcaNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Orze' nguzubi rë men che'n Me lo Me par nzhab bixa': ―¿Chon nidi'zh go kun pura kwent tsa lo rë men? ");
INSERT INTO zcaNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Orze' nzhab Jesús lo rë men che'n Me: ―Nabtsa go mila' Dios, ne go kwa'n naga'ch kwa'n kinu Dios plo nile' Dios mandad; per rë xa' ba', nangala't Dios ngane bixa'i, ");
INSERT INTO zcaNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","porke rë xa' kwa'n nzhakla zobyeke, mbaino le' rë kwa'n nidizha, rë xa' re' xa' nzhaknu Dios par más zobyek bixa'i; per rë xa' gat nzhaklat be's zobyek kwa'n nidizha, haxta che'p tsa kwa'n nile' xa' xigab ya nane la xa', per lë'i yubchi lo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kuze' midizha lo rë xa' ba' kun pura kwent tsa, par une bixa'i per nanganet bixa' kwane; mbaino par mbin bixa'i, per nangazobyekt bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kuze', par yek rë xa' ba' nzha widi'zh kwa'n mizobni' Isaías kwa'n nzhab se': Ter más gon bixa'i, per nazobyekt bixa'i, no ter más ne bixa'i, per nanet bixa' kwane, ");
INSERT INTO zcaNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","porke dox nad laxto' rë men re'. No gat nzhont nzha bixa'i; no nak bixa' nela tu men nikal lo ga'. No chi nangak bixa' sa', lë' bixa' nganei kun zalo bixa', no ngon bixa'i kun nzha bixa', no ngazobyek bixa'i dub la bixa', orze' ngala' bixa' rë kwa'n gat lë' nak bixa', par ngago' Dios bixa' lo rë kwa'n nazhe'b. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Per go, wen nzha go por une goi, no wen nzha go por mbin goi. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Walika kwa'n nin lo go, nayax xa' midi'zh por Dios, mbaino nayax men, xa' mile' rë kwa'n nzhakla Dios, ngokla bixa' ngane bixa' rë kwa'n kine go, per nanganet bixa'i; mbaino ngokla bixa' ngon bixa' rë kwa'n kiyon go, per nangont bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Bin go xmod nak kwent che'n nzha'n men lazh triu ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Or nzhon tu men widi'zh che'n Dios no gat nizobyekt xa'i, orze' laxto' men re' nak nela yuo le'n nez ze', porke or nzhon xa'i, gat ñat laxto' xa', kuze' nizhin Mizhab, nigo' Mizhab kwa'n mixë'n Dios laxto' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","No lazh kwa'n ngob lo yuo ke ze', nak rë men mbin widi'zh che'n Dios, no or mbin xa'i, nizak laxto' xa', ");
INSERT INTO zcaNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","per yent be's luche, che'ptsa midi'y. Se' nak rë men, or nizak xa' tu kwa'n nalats, o niyi' men nine xa' por nak xa' men che'n Dios; orze' por kure' tuli nila' xa' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","No lazh kwa'n ngob le'n ya yich ze', nak rë men ngwayila widi'zh che'n Dios, per por dox nile' xa' xigab por rë kwa'n naki'n xa' yizhyuo re', mbaino por niwix xa' gap xa' dimi, kuze' ña'l laxto' xa' Dios; nak xa' nela tu ya kwa'n gat niza't xlë ga'. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Per lazh kwa'n ngob lo yuo wen ze', nak rë xa' nzhon widi'zh che'n Dios, no nizobyek xa'i, orze' nile' xa' rë kwa'n nzhakla Dios; nak xa' nela tu yalgo'n kwa'n dox miza', nela tu do che'n triu ga' kwa'n miza' tu gayo' lazhe, no xtube miza' zichon gale, mbaino xtube miza' zigal bichi'y. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","No midi'zh Jesús xtu kwent lo rë men ze', nzhab Me: ―Nu plo nile' Dios mandad nak nela tu miyi' kwa'n ngo'n lazh triu wen lo yuo che'n, ");
INSERT INTO zcaNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","no lë' rë men che'n xa' nax, lë'chi mizhin tu xa' nidil xa', par ngwaxë'n xa' yix kwa'n lë cizaña, xid rë triu ze', orze' ña xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","No or miro'b triu, no miza'i do; orze' nu yix ze' nguluxo'b, ");
INSERT INTO zcaNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","orze' ngwayab rë mos lo xa' nak che'n triu ze': “Lë'o, ¿chi gat lë't nab tsa lazh triu mixë'n go? No nal, ¿plo nguro' yix kwa'n nzhi'b le'ne re'?” ");
INSERT INTO zcaNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Orze' nzhab xa' nak che'ne: “Tu xa' niyi' nine da mixë'n kure'.” No nzhab rë mos ze': “¿Chi nzhakla go yaki'b no yix kwa'n nazu't ba'?” ");
INSERT INTO zcaNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Per nzhab xa': “Naki'bta' goi nal, napa' nu triu ki'b go. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Más wen bila' go ro'be tutsa haxta or yats yalgo'n; orze' xëla go par kan go galo laka yix kwa'n nazu't ba', orze' li'b goi, le' go manoje par yëke; orze'se kan go triu no kichao' goi plo niguchao' go rë kwa'n.” ");
INSERT INTO zcaNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","No midi'zh Jesús xtu kwent lo rë men, nzhab Me: ―No nu plo nile' Dios mandad nak nela tu lazh win mostas kwa'n mixë'n tu xa' le'n yuo che'n. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ter más win lazh mostas, lo rë lazh ya kwa'n nixë'n men, per or niro'be, lë'i más nzhak kwa'ro, lo rë ya kwa'n nzhi'b tutsa kun lë'i, no lo rë rram che'ne, ñi'd rë miyin, nixo'b yo che'n. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","No midi'zh Jesús xtu kwent, nzhab Me: ―No se'ska nak plo nile' Dios mandad; nake nela levadur kwa'n nguzen tu una' par migoch una'i, le'n tu bëd harin, par zubeche. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Midi'zh Jesús rë nak kure' lo rë men kun nab tsa kwent; yent kwan ngadi'zh Me lo bixa' chi gat lë' kun kwente, ");
INSERT INTO zcaNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","par ngok rë kwa'n midi'zh tu xa' midi'zh por Dios or nzhab xa': Kun pura kwent tsa dizha lo rë men, Rë kwa'n naga'ch che'n Dios kwa'n kinu Me or ni naga ko Me yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Or ngulunez Jesús rë men ze', nguio Me le'n yo', orze' nguzubi rë men che'n Me lo Me, par mina'bdi'zh bixa', kwan gab kwent che'n yix kwa'n nazu't ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Orze' nzhab Jesús: ―Xa' mixë'n lazh triu kwa'n wen ze' nak Xga'n Dios Me nu nak tu men yizhyuo, ");
INSERT INTO zcaNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","mbaino lë' yuo che'n Me nak rë men yizhyuo re'. Lazh triu wen ze' nak rë men che'n Dios, no lë' yix kwa'n nazu't ze' nak rë men che'n Mizhab. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Lë' men kwa'n ngwaxë'n yix nazu't ze' nak Mizhab, mbaino lë' yalgo'n nak or gab Dios xmod gak kun kad men yizhyuo, mbaino rë xa' kan yalgo'n nak rë ganj che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nela nigan yix kwa'n nazu't par yëke, se'ta' gak kun rë xa' chigab walika men che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Na, Xga'n Dios, mbaino nak Da tu men yizhyuo, xëla rë ganj da, par ko' bixa' xid rë men da, rë men kwa'n nile' nzhap xtu men dol lo Dios, mbaino rë xa' naban ngokla ngwa xid rë men che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Rë men re' ko' rë ganj da par bi bixa' le'n bël che'n gabil, plo go'n bixa' no kwezh lëi bixa' por dox yalne. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Orze'se rë men xa' nile' kwa'n nzhakla Dios, gak bixa' nela biani che'n ngubizh plo nile' Xuz bixa' Dios mandad. ¡Chi lë' go mbin kure', bizobyek goi! ");
INSERT INTO zcaNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Plo nile' Dios mandad nak nela tu kwa'n dox tsak, nzhuka'che le'n yuo, no or ngwazhël tu miyi'y, nguluka'ch ska xa'i. Por dox nizak laxto' xa', miëk xa' lizh xa', ngwato xa' rë kwa'n kinu xa' par nguzi' xa' dub yuo ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","No nzhab Jesús: ―Nu plo nile' Dios mandad nak nela tu xa' nito no nizi', kikwa'n xa' ke chul. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","No or ngwachib xa' lo ke chul kwa'n dox tsak, orze' miëk xa' lizh xa', mito xa' rë nak kwa'n kinu xa' par nguzi' xa' ke tsak re'. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’No nela tu yex kwa'n nizen rë lo mbël, se'ta' nak plo nile' Dios mandad. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Or ñazhëi di mbël, nigo' mene ro' nits par nibe bixa' ma wen tsa, niguchao' bixa'. No lë' rë ma nazu', nigubi bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Sa'ta' le' Dios kun rë men or gab Dios xmod gak kun kad men yizhyuo. Xë'l Me rë ganj che'n Me par kutin rë men nakap xid rë men wen, ");
INSERT INTO zcaNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","par bi rë men nakap ze' le'n bël che'n gabil. Ze' go'n bixa', haxta kwezh lëi bixa' por dox yalne. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Orze' nzhab Jesús lo rë men che'n Me: —¿Chi mizobyek go rë kwa'n midizha lo go re'? Nkab bixa': ―Lë'i mizobyek ka no. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Orze' nzhab Jesús lo bixa': ―Wenkai. Chi tu xa' nane ley kwa'n mila' Dios lo Muisés, mbaino nizobyek xa' rë kwa'n nilun, xa' re' nak nela tu xa' nak lizh tu yo' ga'; xid rë kwa'n kinuchao' xa', nane xa' xmod le' xa' kun kwa'n kub mbaino kun kwa'n go'x. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Or milox midi'zh Jesús kure', nguro' Me ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Or mizhin Me yezh Nazaret plo nak lazh Me, tuli ka nguzublo Me milu' Me widi'zh che'n Dios lo rë men nzhin le'n yo' plo nitse'd bixa' widi'zh che'n Dios. Xe mia'n bixa' tuli por kwa'n milu' Jesús, orze' nzhab bixa': ―¿Plo mitse'd xa' re' kwa'n nzhak xa', no rë kwa'n nazhon kwa'n nile' xa'? ");
INSERT INTO zcaNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Chi gat lë't xa' re' xga'n xa' nichao' mes, no Mari lë xna' xa', no gat rë wech xa' lë Jakob, Che, Simón, no Judas? ");
INSERT INTO zcaNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿No chi gat lë't rë bizan xa' nzo kun be re'? ¿Plo ska mitse'd xa' re' rë kwa'n nzhak xa'? ");
INSERT INTO zcaNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","No por nak bixa' sa', kuze' nangayilat bixa' widi'zh che'n Dios kwa'n milu' Jesús, per nzhab Jesús lo bixa': ―Rë plo, lë' men ñila ka tu xa' nidi'zh por Dios; per mis rë men lazh xa' no rë men lizh xa', nayilat kwa'n nidi'zh xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","No por nangayila rë men ze'i, kuze' nangale't Jesús nayax kwa'n nazhon ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Le'n rë ngubizh ze' nak Herodes gobiernador lazh rë men Galilea, no mbin xa' rë kwa'n nzhudi'zh men por Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","kuze' nzhab Herodes lo rë men xa' nile' mandad che'n xa': ―Lë'la Juan xa' nililëi' men le'n nits nguruban, kuze' nile' xa' re' rë kwa'n nazhon ba'. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Porke lë' Herodes mile' mandad, ngwaga' Juan, mili'b xa' Juan kun kaden, orze' ngulo xa' Juan lizhyi'b por Herodías, una' che'n Lip wech xa', ");
INSERT INTO zcaNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","por nzhab Juan lo Herodes: “Gat went ka'l una' che'n wechal.” ");
INSERT INTO zcaNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Orze' ngokla Herodes ngut xa' Juan, per nangale't xa'i por nizheb xa' lo rë men, porke lë' rë men nane, lë' Juan nidi'zh por Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Per or ngol lani che'n Herodes, nguio xcha'p Herodías, mbilni' xid bixa', orze' nguio laxto' Herodes kun rë xa' kwa'n nzob lo mes kun lë' xa', xmod mbilni' una'. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Mize't xa' Dios or nzhab xa' lo una', lë' xa' za' wanei kwan na'b una' lo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Per lë' xna' una' miki'l la una', kuze' nzhab una' lo Herodes: “Nzhaklan yi'dnu go yek Juan, le'n tu plat.” ");
INSERT INTO zcaNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","No or mbin Herodes kure', miwin laxto' xa', per por lë' xa' mia'n la tutsa dilant lo rë men nzob kun lë' xa', lë' xa' za' wanei kwan na'b una', kuze' nguziyël xa' za' xa' kwa'n nguna'b una', ");
INSERT INTO zcaNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","orze' mile' xa' mandad, miro'g yek Juan le'n lizhyi'b, ");
INSERT INTO zcaNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","no ñadnu bixa' yek Juan, nzhoi le'n tu chë', par miza' bixa'i ka' una', orze' lë' una' miza'i ka' xna'. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Orze' mizhin rë men che'n Juan par ngwats Juan, mbi'y xa' Juan par miga'ch xa', orze' ngwayab bixa'i lo Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Or mbin Jesús lë' Juan ngut, orze' nguro' Jesús ze' kun dub tu dusen men che'n Me, nkë Me le'n tu bark, nzha Me tu plo yent men. Per lë' rë men, or mbin bixa' plo nzha Me, rë yezh nguro' men, nzhakë bixa' ni' bixa', tich Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Or ngula Jesús bark, une Me, lë' tu bëd men nzhin la ze', orze' milats laxto' Me men, miliyak Me rë men nzhakne xa' nzho xid rë men ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Per or nzhala la yë'l, nguzubi rë men che'n Me lo Me nzhab bixa': ―Ya cho gor la nal, no yent kwa'n nak dan re'. Guzh go lo rë men, bi bixa', yazi' bixa' kwa'n gao bixa' rë yezh win kwa'n nzhin naka'n re'. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Per nzhab Jesús: ―Gat naki'nt bi bixa'; ¡yub go biza' kwa'n gao bixa'! ");
INSERT INTO zcaNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Orze' nkab rë men che'n Me: ―Gat kinut no nayax kwa'n gao rë xa' re', nab tsa gai' pan kun chop mbël kinu no. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Orze' nzhab Jesús: ―Dinu goi re'. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Orze' mile' Me mandad, nguzob rë men ze' lo gozh, nguzen Me za gai' pan ze' kun rop mbël ze', miwi' Me lo yibë', miza' Me xkix lo Dios. Orze' michi'x Mei, no miza' Mei ka' rë men che'n Me; par lë' bixa' ki'ze gao rë men. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","No rë men ze' ndao haxta plo nguzhë bixa'. No mikan bixa' rë bilao kwa'n mia'n sobr; michizhë bixa' tu dusen kardor. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Rë xa' ndao re', nab tsa xa' miyi', paste gai' mil bixa', no ngalabt bixa' rë una' no rë më'd. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Or milox ngok rë kure', tuli mile' Me mandad, nkili rë men che'n Me le'n bark par kubner ga' bixa' xtu ro' nits plo lë Betsaida; mbaino lë' Jesús mia'n par une Me xmod ña rë men. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Or milox mire'chbe rë men ze', nkili Jesús yek yi' par nguna'b Me lo Dios. Nab Me nzo ze' or ngula la yë'l. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","No dox la zit ñazë bark di plo mia'n Me, une Me labai-larei kikwin mbi bark por nzha bixa' nez nzë mbi. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","No paste las tres garzi'l, nzhazë Jesús lo nits nez nzë bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Or une bixa' ñë'dzë Me lo nits, nguruzhië bixa': “¡Tu komale!”, por dox mizheb bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tuli midi'zh Me, nzhab Me: ―¡Nazhebt go! ¡Ka nai! ");
INSERT INTO zcaNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Orze' nzhab Per lo Me: ―¡Lë' go!, chi walika go kuba', gurezh go da yala lo go. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Orze' nzhab Me: ―¡Dë'x! Tuli nguro' Per le'n bark, nguzublo nzhazë xa' nali laka lo Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","per or une Per, dox naye nzo mbi, mizheb xa', no or nguzublo nzhaya'zyuo xa' le'n nits, orze' nguruzhië xa', nzhab xa': ―¡Lë'o!, ¡nala't go gat da! ");
INSERT INTO zcaNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tuli nguzen Jesús ya' Per, nzhab Jesús: ―¿Chon tatu lo ya ñayilal da? ");
INSERT INTO zcaNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","No or unkë Me le'n bark kun Per, xega ngulëz mbi, ");
INSERT INTO zcaNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","orze' nguzuxib rë men che'n Me lo Me, nzhab bixa': ―¡Walika go nak Xga'n Dios! ");
INSERT INTO zcaNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Or milox nded bixa' le'n nits ze', mizhin bixa' lazh men Genesaret. ");
INSERT INTO zcaNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Or mili'be' rë men yezh ze' Jesús, mixo'bdi'zh bixa', lë' Jesús mizhin ze', lo rë yezh kwa'n nzhin naka'n ze'. Orze' ngwanu men rë xa' nzhakne lo Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","no dox nguna'b bixa' ziyël Jesús, namás gal bixa' xi' xab Me, no rë xa' migale, miak bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Yezh Jerusalén nzë pla men fariseo, kun pla men, xa' nilu' ley che'n Muisés; nguzubi bixa' lo Jesús, nzhab bixa': ");
INSERT INTO zcaNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Chon gat nizet rë men che'nal ya' bixa' or nzhao bixa'; gat nile't bixa' rë kostumbr kwa'n mila' rë men che'n be, xa' tiemp? ");
INSERT INTO zcaNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Orze' nkab Jesús: ―Nu ska go, ¿chon gat nile' go kwa'n nzobni' lo Yech che'n Dios, lë'la rë kostumbr che'n men tiemp nile' go?, ");
INSERT INTO zcaNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","porke se' nzobni' lo Yech che'n Dios: “Gop kwent xuzal mbaino xna'l”, mbaino: “Men ke xuz o xna', gat xa' re' tuli.” ");
INSERT INTO zcaNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Per go nzhab: “Lë' men gak ka gab lo xuz o lo xna': Nagakt gaknun go; lë' rë kwa'n kinun, lë'i mizala par Dios”, ");
INSERT INTO zcaNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","namás par nile' go, gat naki'ntra' gaknu men xuz men o xna' men. Wen go par nile' go, natsaktra' kwa'n mile' Dios mandad. Más nile' go por rë kwa'n michao'yek rë men tiemp. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Tatu nazheb nak go, chigab walika men wen go! Kuze' ka, por go mizobni' Isaías widi'zh re' lo yech: ");
INSERT INTO zcaNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Rë men re'; ka lo ya nidi'zh bixa', nazhi' xa' da, per le'n laxto' bixa', yent kwan nize'n bixa' por Da. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yent kwan zu' nidi'zh bixa' nazhon Da, mbaino rë kwa'n nilu' bixa' lo men, pura kwa'n nichao'yek mene. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Orze' ngurezh Me rë men lo Me, nzhab Me: ―Bin go kure' no bizobyek goi: ");
INSERT INTO zcaNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Gat lë't por kwa'n nzhao men nile' ña'n gat nambe men lo Dios; por widi'zh kwa'n niro' ro' men, nile' ña'n gat nambe men lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Orze' nguzubi rë men che'n Jesús lo Jesús, nzhab bixa': ―¿Chi une go, lë' rë men fariseo miyi' or mbin bixa' rë kwa'n midi'zh go? ");
INSERT INTO zcaNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Orze' nzhab Jesús: ―Rë ya kwa'n nangaxë'nt Xuza, Me nzho lo yibë', lë'i yi'b dub luche. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nachë'lt go kun rë men ba'. Ter nak bixa' nela men nikal lo ga', per zak bixa' lë' bixa' lu' nez lo rë xa' nakao nak yek lo rë che'n Dios, per gakt lu' tu men nikal lo nez lo xtu xa' nikal lo, porke lë' rop bixa' yachin le'n tu ye'r. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Orze' nzhab Per: ―Bineo lo no kwan gab widi'zh ba'. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Orze' nzhab Jesús: ―¿Taxa nu go, gat nizobyekt kure'? ");
INSERT INTO zcaNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Chi nanet go, kwa'n nzhao met nibi laxto' met, orze' niro'i or ña met bi'x? ");
INSERT INTO zcaNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Per rë widi'zh gat lë' kwa'n niro' ro' men, le'n laxto' men nzëi; kure'se nile' ña'n gat nambe men lo Dios, ");
INSERT INTO zcaNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","porke dizde le'n laxto' men nzë rë xigab gat lë' re': Rë kwa'n nzhut men men; no rë kwa'n ban men kun tsa' xtu men o kun xa' gat lë' tsa' men; mbaino rë kwa'n niliwa'n men; no rë kwa'n nile' nikë' men kixu' men; mbaino rë kwa'n niye men Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Rë kure' nile', ña'n gat nambe men lo Dios, no gat lë't por gao men dub be'd ya' mene. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Or nguro' Jesús ze', nzha Me al nez plo nzhin yezh Tiro no yezh Sidón. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ze' nzho tu una' ben rë xa' cananea; or une una' Jesús, tuli nguzubi una' no nguruzhië una', nzhab una': ―¡Lë'o Xga'n Dabi, bilats laxto'u da! ¡Lë' tu mbi mal nzen xcha'pa, dox kizakziy una'! ");
INSERT INTO zcaNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Per nangakabt Jesús lo una', orze' nguzubi rë men che'n Jesús lo Jesús par mina'b bixa' lo Me, nzhab bixa': ―Bichubla go una' ba', lë' una' nzadkë tich be, nibizhyë una'. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Orze' nzhab Jesús lo una' ze': ―Per Dios mixë'l da nab tsa par gaknun rë men Israel, xa' nak nela rë mbëkxi'l ma nguziwan dan ga'. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Per nguzuxib una' re' lo Jesús, no nzhab una': ―¡Lë'o, kina'ba lo go, gaknu go da! ");
INSERT INTO zcaNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Orze' nzhab Jesús: ―Gat ñalt kwe men yët lo xmë'd men, par za' xa'i gao mbëk. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Per nkab una': ―Walika goi; per nu ka mbëk nikan rë biyo ye'n kwa'n nzhab xan mes, che'n xa' nak che'n ma. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Orze' nzhab Jesús: ―¡Ay una'yo, luse dox ñilal da! Kwa'n una'bal ba', lë'i gak. No mis orze', miak xcha'p una'. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Or nguro' Jesús ze', mizhin Me nez ro' lagún che'n men Galilea, orze' nkë Me yek tu lom, ze' nguzob Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","No ze' migan dox nayax men lo Jesús. Xid rë men ze' nzho rë xa' nzhanu men nzhakne, xa' nagakt zë, xa' nikal lo, mbaino xa' nagakt di'zh, xa' ma'nk, no más rë men nzhakne; rë xa' re' mizhinu men lo Jesús, no rë bixa' miliyak Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Xe mia'n rë men tuli or une bixa' men nagakt di'zh, nzhudi'zh; no men ma'nk uniwen; men nagakt zë, nizë; no men nikal lo, miwi'. Orze' nzhab rë men, dox nazhon Dios che'n rë men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Orze' ngurezh Jesús rë men che'n Me, nzhab Me: ―Nilats laxto'n rë men re', re' yon ngubizh nzhin bixa' lon, no gat kinut bixa' kwa'n gao bixa'. Gat nzhaklata bi bixa' xlats bixa', nzha ska yazha bixa' nez. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Orze' nzhab rë men che'n Jesús: ―¿Per plo yaka' be kwa'n gao rë nak men re'? No plo nzhin be re', yent lizh mene. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Orze' mina'bdi'zh Jesús lo bixa': ―¿Pla pan kinu go? ―Gazhtsai, no pla mbël win ―nkab bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Or mile' Me mandad, nguzob rë men ze' lo yuo, ");
INSERT INTO zcaNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","nguzen Me za gazh pan ze' kun pla mbël ze'. Or milox miza' Me xkix lo Dios por lë'i, michix Mei no miza' Mei, ka' rë men che'n Me, par ndi'z bixa'i gao rë men ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Rë men ndao haxta plo ngwazhë bixa', no or milox ndao bixa', mikan ra' bixa' zigazh kardor rë bilao kwa'n mila' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Rë xa' ndao ze', nab tsa xa' miyi', paste tap mil bixa', no ngalabt bixa' rë una' no ni rë më'd. ");
INSERT INTO zcaNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Orze' ngulunez Jesús rë men, no lë' Me nkë le'n tu bark par nzha Me rë yezh kwa'n nzhin lazh men Magdala. ");
INSERT INTO zcaNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nguzubi pla rë men fariseo kun zipla men saduceo lo Jesús, nzhakla bixa' zenbe' bixa' Me (wi' bixa' xmod nak Me), nabei chi walika Dios mixë'l Me; kuze' nzhakla bixa', lu' Jesús tu kwa'n nazhon le' Dios, ");
INSERT INTO zcaNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","orze' nzhab Jesús lo bixa': ―Or mizhëlyuo, chi naxne nilu' lo yibë', nzhab go: “Biwi', gat lë't kwa'n la yiu yë', lë' lo yibë' nilu' naxne”; ");
INSERT INTO zcaNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","no or garzi'l nzhab go: “Biwi', nadedt lë' yiu la, dox nazhon nilu' xkao lo yibë'.” No chi nilibe' go rë señ kwa'n ño lo yibë', ¿chon nalibe'o rë kwa'n nazhon kile' Dios rë zhë re'? ");
INSERT INTO zcaNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Men nakap go, gat nile't go kwa'n nzhakla Dios, mbaino nal nzhakla go, ne go tu kwa'n nazhon le' Dios. Per nanet goi; nab tsa kwa'n nazhon kwa'n mile' Dios kun Jonás, ne go. Orze' mila' Jesús rë men ze', nzha Me xtu plo. ");
INSERT INTO zcaNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Or nded Jesús kun rë men che'n Me xtu ro' lagún, no mia'l laxto' bixa' ngwei' bixa' kwa'n gao bixa', ");
INSERT INTO zcaNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","orze' nzhab Me lo bixa': ―Ne go, nazen go levadur che'n rë men fariseo, no che'n rë men saduceo. ");
INSERT INTO zcaNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Orze' nzhab bixa' lo wech bixa': ―Ne xa' kuba' lo be, pas por nangayi'dnu be kwa'n gao bei. ");
INSERT INTO zcaNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Per nane la Jesús cho xigab kile' bixa', kuze' nzhab Me: ―¿Chon dox kile' go xigab por gat nzadnut go kwa'n gao be? ¡Dox wë' ñila go da! ");
INSERT INTO zcaNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Chi gat zobyek go kwa'n nin ba'?, no, ¿chi mia'l la laxto' go kwan ngok kun gai' tsa pan no ngole ndao gai' mil men, mbaino zipla kardore mia'n sobr? ");
INSERT INTO zcaNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","No, ¿chi nu mia'l laxto' go kwan ngok kun gazh tsa pan, no tap mil men ndaowe, no pla kardore mia'n sobr? ");
INSERT INTO zcaNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Chon nanganut laxto' go kwa'n midizha lo go, gat lë't pan midizha? Kwa'n nin lo go, ne go nayë'de go rë kwa'n nak rë men fariseo no men saduceo; lë' bixa' nak nela levadur kwa'n nitsibech kwa'n ga'. ");
INSERT INTO zcaNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Orze' mizobyek bixa', gat lë't levadur che'n pan midi'zh Jesús; kwa'n midi'zh Me nak rë kwa'n nilu' rë men fariseo kun men saduceo lo más rë men. ");
INSERT INTO zcaNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Or mizhin Jesús kun rë men che'n Me yezh Cesarea plo nile' Lip wech Herodes mandad, orze' mina'bdi'zh Jesús lo rë men che'n Jesús, nzhab Me: ―¿Cho da nzhab men? ");
INSERT INTO zcaNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Orze' nzhab rë men che'n Me: ―Nzho men nidi'zh, go Juan xa' mili'lëi' men le'n nits; más bixa' nzhab, go Li; no xtu ben men nidi'zh go Jeremías, o xtu rë xa' midi'zh por Dios nzhala. ");
INSERT INTO zcaNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Orze' nzhab Jesús: ―Go ga', ¿cho da nile' go xigab? ");
INSERT INTO zcaNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tuli mikab Simón Per, nzhab xa': ―Go Krist, Xga'n Dios, Me kinu yalnaban par dubta'. ");
INSERT INTO zcaNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Orze' nzhab Jesús: ―Wen nzhal, Simón xga'n Jonás; gat lë't men milu'i lol, lë' Xuza Me nzho lo yibë' milu'i lol. ");
INSERT INTO zcaNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na ni, lël rulë Per (kwa'n gab ke ro), mbaino lo ke re' cha̱o̱wa̱ yado' da xa' nak rë men da, no per ni Mizhab nale't gan chil yado' re'. ");
INSERT INTO zcaNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","No lu zo lo rë men da: Rë kwa'n nzhaklal gak lo yizhyuo re', lë' Dios ziyël le'i; no rë kwa'n gat nzhaklatal gak lo yizhyuo re', nagakte. ");
INSERT INTO zcaNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Orze' mile' Jesús mandad lo rë men che'n Me, par yent cho lo di'zh bixa', lë' Me Krist. ");
INSERT INTO zcaNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Dizde zhë ze' nguzublo Jesús midi'zh Jesús lo rë men che'n Jesús, naki'n ya Me yezh Jerusalén. Ze' zakzi rë men Me, rë xa' nak zhi'n lo rë men Israel, no kun rë ngulëi' xa' nile' mandad lo más rë ngulëi', mbaino kun rë xa' nilu' ley che'n Muisés; no nu nzhab Me: ―Lë' bixa' gut da, per ngubizh yon lë'da ruban. ");
INSERT INTO zcaNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Orze' ngulo' Per Jesús tu lad, nzhab Per: ―Lë' go, ¡Dios lats laxto' go! ¡Nayot la' Dios zak go rë kuba'! ");
INSERT INTO zcaNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Per miëk Jesús lo Per, nzhab Me: ―¡Chi lon Mizhab! ¡Ka nzhaklal chil da lo kwa'n gat lë'; kwa'n nzhaklal, gat lë't lo Dios nzëi; xigab che'n men kuba'! ");
INSERT INTO zcaNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Orze' nzhab Me lo rë men che'n Me: ―Chi nzhakla tu go yi'dkë go ticha, bila' go kwa'n nzhakla go yizhyuo re', no biye laxto' go ter gat go por nak go men da, orze'se di'kë go ticha. ");
INSERT INTO zcaNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Xa' nane gak men da por nizheb xa' gat xa', lë' xa' lox lo Dios; per xa' niye laxto' gat por nak xa' men da, lë' xa' ban dubta' lo Dios, ");
INSERT INTO zcaNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","no, ¿kwan zu' par tu men, ter che'n xa' dub yizhyuo, per lo Dios lë' xa' lox? ");
INSERT INTO zcaNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Na, Xga'n Dios no nak Da tu men yizhyuo, nadedte lë' da yal xtu wëlt kun yalnazhon che'n Xuza, no kun rë ganj che'n Me, orze' zan kwa'n gal kad men por rë kwa'n mile' bixa', wanei chi kwa'n wene o kwa'n nakape. ");
INSERT INTO zcaNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Walika kwa'n nin lo go, nzho pla go nzo re', naban gaka go lë' go ne or yala kun rë yalnazhon Da par len mandad. ");
INSERT INTO zcaNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Unded xo'p ngubizh, ngwanu Jesús Per, no Jakob, mbaino Juan wech Jakob, yek tu yi' ro. ");
INSERT INTO zcaNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ze', ngubixlo Jesús dilant lo bixa': milu' lo Me nela biani che'n ngubizh ga', no xab Me bëo laka no ñaz bële. ");
INSERT INTO zcaNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Lë'chi ¡di!, nguro'xo'b Li, rop xa' kun Muisés, kidi'zh bixa' kun Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Orze' nzhab Per: ―¡Lë' go, wen dox nzo be re'! Chi nzhakla go, cha̱u̱ chon rranch re'; tube par go, xtube par Muisés, no xtube par Li. ");
INSERT INTO zcaNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Dub kidi'zh Per kure', lë'chi ¡di!, maska ña'zbël tu xkao ngula yek bixa', ngwani dub plo nzhin bixa'; le'n xkao ze' mien tu widi'zh kwa'n nzhab se': ―¡Xa' re' Xga'na, Xa' nazhi' da!, dox nizak laxto'n por lë' Xa'; ¡bin go ro' Xa'! ");
INSERT INTO zcaNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Or mbin yon men che'n Jesús widi'zh re', tuli ngo't kuslo bixa' lo yuo, dox mizheb bixa', ");
INSERT INTO zcaNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","orze' nguzubi Jesús lo bixa', migal Me bixa', no nzhab Me: ―Waxche go, nanzhebt go. ");
INSERT INTO zcaNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Or ngulits bixa' lo bixa', yentra' cho nak, nab tsa Jesús nzo ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","No dub ñadla bixa' yek yi' ze', nzhab Me lo yon xa' re': ―Yent cho lo di'zh go kwa'n une go re', haxta or ruban Xga'n Dios, Me nu nak tu men yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Orze' minabdi'zh bixa' kure' lo Me: ―¿Chon nidi'zh rë xa' nilu' ley che'n Muisés, galo laka Li yi'd? ");
INSERT INTO zcaNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Orze' nzhab Jesús: ―Walika, galo Li yi'd, par le' xa' yëk rë men lo Dios, ");
INSERT INTO zcaNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","per na ni lo go, lë' Li mbi'd la, no maska bixa' ngon ro' Li, lë'la mili'nu bixa' Li kwa'n nzhakla bixa'. Se'ska le' men kun Xga'n Dios, Me nu nak tu men yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Orze' mizobyek yon men che'n Me, ka Juan xa' mililëi' men le'n nits, mize't Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Or mizhin Jesús plo nzhin nayax men, nguzubi tu miyi' plo nzo Jesús, no nguzuxib xa' lo Me, nzhab xa': ");
INSERT INTO zcaNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Lë' go, bilats laxto'u xga'na, dox nalats kwa'n nizak xa', tutsa or nikao xa' maska ñëk xa'; nayax wëlt ñachin xa' plo nzhab xa' le'n bël o le'n nits. ");
INSERT INTO zcaNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Na mbi'dnu la xa' lo rë men che'n go, per nangale't bixa' gan, nganiwen xga'na. ");
INSERT INTO zcaNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Orze' nzhab Jesús: ―¡Taxa nagat yila go rë kwa'n nin lo go! ¡Tatu nad go par yila go rë kwa'n nazhon che'n Dios! ¡Dox kixek da lo go, nagat zobyek go rë kwa'n nin lo go! Orze' nzhab Jesús: ―¡Dinu xmë'dal re'! ");
INSERT INTO zcaNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Orze' mile' Jesús mandad, ro' mbi mal ze' laxto' miyi' ze'; no tuli miak miyi' dizde zhë ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Or nzo Me tu lad, nguzubi rë men che'n Me lo Me par nzhab bixa': ―¿Chon nangakt ngago' no mbi mal laxto' miyi' ze'? ");
INSERT INTO zcaNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Orze' nzhab Jesús: ―Por ña-ñë'd xigab che'n go kun Diose. Walika kwa'n nin lo go, chi kwa'n ñila go Dios ngak nela tu lazh mostas ga', or gab go lo yi' ba': “Yubchi, bizë xtu plo”, no lë'i yubchi, no yent cho tu kwa'n nagak le' go. ");
INSERT INTO zcaNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Lë' mbi mal kwa'n ngulon laxto' miyi' ze', nayot ro'i chi nana'b men lo Dios xche, no xlats men. ");
INSERT INTO zcaNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Dub nzho Jesús lazh men Galilea kun rë men che'n Me, nzhab Me lo bixa': ―Na, Xga'n Dios, nu nak Da tu men yizhyuo, lë' rë men zen da no wei' bixa' da lo rë xa' nile' mandad. ");
INSERT INTO zcaNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Lë' bixa' gut da, per ngubizh yon, lë'da ruban. Orze' dox miwin laxto' rë men che'n Me por kure'. ");
INSERT INTO zcaNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Or mizhin Jesús kun rë men che'n Me yezh Capernaúm, ze' nguzubi pla miyi' lo Per, rë xa' nikan dimi par yado', nzhab bixa': ―¿Taxa chi gat niza't Maestr che'nal dimi par yado'? ");
INSERT INTO zcaNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nkab Per: ―Lë'i niza' ka Xa'. Or nguio Per le'n yo', tuli ka nzhab Jesús: ―Di xigab che'nal Simón, ¿xmod nile' rë rey yizhyuo re'? ¿Cho lo nikan bixa' dimi? ¿Chi mis lo rë xin xa'i, o lo xa' rë mene? ");
INSERT INTO zcaNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Orze' nzhab Per: ―Lo xa' rë mene. Orze' nzhab Me: ―Kuze' nal, rë xin rey, gat naki'nt za' bixa' dimi ba', ");
INSERT INTO zcaNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","per par naki'xian be rë men ba', wa ro' nits, bi'y kwa'n nizenal mbël; no mbël galo laka zenal, xa'lal ro' ma, ze' nzho tu pes, guzene par wati'x cheda mbaino che'nal. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mis orze', nguzubi rë men che'n Jesús, par mina'bdi'zh bixa' lo Me: ―¿Cho xa' más tsak xid rë men che'n Dios? ");
INSERT INTO zcaNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Orze' ngurezh Jesús tu më'd, mizo Me më'd garol sao' plo nzhin bixa', ");
INSERT INTO zcaNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","no nzhab Me: ―Walika kwa'n nin lo go, rë go, chi nachë'u xmod nak go, mbaino nagak go nela më'd re', orze' gakt yo go plo nile' Dios mandad. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Men xa' nado' laxto' lo Dios nela më'd re', xa' re' más tsak plo nile' Dios mandad, ");
INSERT INTO zcaNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","no xa' chizhi' tu men, ter tu xa' yent kwan tsak par lo rë men nela më'd re', per por nak xa' tu men da, orze' kun na mile' xa'i. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’No wanei cho tu men le' zë'b xki tu men da xa' yent kwan tsak par lo men, xa' le' kure' ñal gat xa' le'n nitsdo', dub nikili'b tu ke ro yën xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Dox rë kwa'n gat lë' nzho yizhyuo, mbaino yent cho kwë'ze; wene namás par zë'b xki men lo Dios, ¡per zhe'b nalats nzha xa' nile', nzë'b xki xtu men lo Dios! ");
INSERT INTO zcaNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","No chi por ya' go o ni' go nile' go tu kwa'n gat lë', par la' go widi'zh da, neka bicho' goi, porke más wen yent ya' go o tu ni' go yizhyuo re', per ban go vid nazhon kwa'n niza' Dios par dubta', ke par dub go bi le'n gabil par dubta'. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","No chi por tu zalo go le' go kwa'n le' par la' go widi'zh da, neka gulo' goi; más wen ban go yizhyuo re' vid nazhon dub sa' go ke par dub nak go bi le'n gabil par dubta'. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Biwi'u, par nale' go naya' lo rë men da, xa' chigab natsakt be's lo rë men, porke rë ganj kwa'n nikina bixa', zilita' ñayab rë kwa'n nizak bixa' lo Xuza, Me nzho lo yibë'. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Na, Xga'n Dios, no nak Da tu men yizhyuo, mixë'l Dios Da par lo rë men nzë'b xki lo Dios par kon bixa' lo rë kwa'n nazhe'b nzho bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","No nzhab Jesús: ―¿Cho xigab che'n go? Chi tu men kinu tu gayo' mbëkxi'l, no chi nguziwan tu ma, ¿chi zila' xa' nzhin dub tap gal nzho chi'n bitap ma, par yakwa'n xa' ma nguziwan ze'? ");
INSERT INTO zcaNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","No or yazhël xa' ma, kwa'n nanen, más zak laxto' xa' por ma re', ke par dub tap gal nzho chi'n bitap ma kwa'n nzhin ka lo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Se'ska Xuz go Me nzho lo yibë', gat nzhaklat Me yitlo ni tu rë men da, rë xa' chigab natsakt be's. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’No chi lë' wech go mile' tu kwa'n gat lë' lo go, bidi'zh roptsa go, guzh go gat lë't kwa'n mile' xa'. No chi mizi xa' kwa'n nak xa', orze' guzhë mile' go gan, gak yo xa' xid go xtu wëlt. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","No chi nangazi xa' kwa'n nak xa', orze' gurezh go xtu men o xchop xa' par gon bixa' kwan ya'n go. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","No chi nane xa' gon xa' kwa'n nak xa', orze' gurezh go rë men yado'; no chi ni sa' nane xa' zi xa' kwan nak xa', orze' nachë'lt ra' go kun lë' xa', no gop go kwent xa' nela tu men gat nzhont widi'zh che'n Dios, o nela tu men nikan dimi che'n rey. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Walika kwa'n nin lo go; rë nak kwa'n nzë'b xki men, kwa'n ya'l laxto' go lo yizhyuo re', nu ska Dios ya'l laxto' rë nak kure'; no rë kwa'n gat lë' kwa'n naya'lt laxto' go che'n rë men yizhyuo re', nayu'bchitskai lo Dios lo yibë'. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’No nu walika kwa'n nin re', chi chop go ya'n tutsa kwa'n yizhyuo re' par na'b goi lo Xuza Me nzho lo yibë', orze' lë' Me ne' kwa'n na'b go lo Me, ");
INSERT INTO zcaNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","porke plo nzo chop tsa go o chon go par na'b go tu kwa'n lo Xuza por nak go men Da, orze' ze' nzon kun go. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Orze' nguzubi Per lo Jesús, nzhab Per: ―Lë'o, ¿mási pla wëlt le' wecha kwa'n gat lë' lon, no naki'n ya'l laxto'n kwa'n mile' xa'? ¿Chi haxta gazh wëlte? ");
INSERT INTO zcaNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Orze' nzhab Jesús: ―Gat lë't sa'i; lë'i nak haxta nagakt lab met pla wëlte. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Plo nile' Dios mandad nak nela tu rey xa' nguna'b kwent plak nzë'b tuga' rë mos che'n xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","No or nguzublo rey kina'b xa' kwent, ngwanu bixa' lo rey tu mos xa' nzë'b más di tu miyon pes pura kwa'n plat. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","No lë' mos re' gat kinut mos dimi par kix xa' rë kwa'n nzë'b xa', orze' mile' rey mandad, do mos re' nela tu ma ga' kun rë lizh xa', mbaino kun rë kwa'n kinu xa', por rë kwa'n nzë'b xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Orze' ngo't kuslo mos re', mile' xa' nalats lo rey, nzhab xa': “Lë'o, bilats laxto' go da, gulëz go xche'p, lë'da kix ka rë kwa'n nzë'ba lo go.” ");
INSERT INTO zcaNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Orze' milats laxto' rey xa', nzhab rey: “Bila' nakixtra'le, yentra' kwan nzë'bal lon”, no miliya' rey xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Milox nguro' xa' re' lizh rey, lë'chi mizhë'l xa' xtu tsa' mos xa', nzë'b ne' re' lo xa' re' dimi kwa'n nile' men gan chon mbëo' garol nikë men zhi'n, per nguzen xa' yën ne' re', mitsi' xa'i no nzhab xa': “¡Xaxa udix kwa'n nzë'bal lon!” ");
INSERT INTO zcaNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Orze' ngo't kuslo ne' re' lo xa', nalatsa mile' ne' lo xa', mbaino nzhab ne': “¡Bilats laxto' go da, gulëz go xche'p, lë'da kix ka rë kwa'n nzë'ba lo go!” ");
INSERT INTO zcaNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Per nangaziyëlt xa', lë'la ngulo xa' ne' lizhyi'b haxta kix ne' kwa'n nzë'b ne' lo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Or une más rë mos che'n rey kure', dox miwin laxto' bixa', orze' ngwayab bixa'i lo rey. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Or mbin rey kure', orze'se miyi' rey no ngurezh rey mos nakap re', no nzhab rey: “¡Mos mal laxto', tatu nazhe'b nakal! Na mia'l laxto' rë kwa'n nzë'bal lon por miwi'n nalats mile'l lon. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ñal ngalats ka laxto'l tsa' mosal ba' nela xmod milen kun lu ga'.” ");
INSERT INTO zcaNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","No por dox miyi'xian rey, tuli michi xa' mos re' lo rë xa' nikina lizhyi'b par zakzi bixa' mos re' haxta kix mos re' rë kwa'n nzë'b mos. ");
INSERT INTO zcaNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","No nu nzhab Jesús: ―Se'ska linu Xuza Me nzho lo yibë', tuga' go, chi naya'l laxto' go rë kwa'n gat lë' nile' xtu men lo go, per naki'n le' goi kun dub laxto' go. ");
INSERT INTO zcaNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Or milox midi'zh Jesús rë kure', orze' nguro' Me lazh men Galilea, nzha Me lazh men Judea, xtu ro' you' Jordán nez plo nilen ngubizh. ");
INSERT INTO zcaNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tu bëd men nzhakë tich Me; ze' miliyak Me rë men nzhakne xa' nzho xid rë men ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Orze' nguzubi pla men fariseo lo Jesús par zenbe' bixa' Me (wi' bixa' xmod nak Me), kuze' nzhab bixa': ―Lo ley che'n Muisés, ¿chi zak la' tu miyi' tsa' xa' por wanei kwan tu kwa'n? ");
INSERT INTO zcaNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Per nzhab Jesús: ―¿Chi nagat go'l go lo Yech che'n Dios, plo nzobni', dizde galo laka, or ngulo Me rë kwa'n, Dios ngulo miyi' no una' par ban bixa' tutsa? ");
INSERT INTO zcaNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","No nu se' nzobni' lo Yech che'n Dios: “Por una', lë' miyi' la' xuz no xna' par ban xa' tutsa kun tsa' xa', mbaino rop xa' gak tutsa men.” ");
INSERT INTO zcaNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","No gat lë'tra' chop xa', lë' xa' ngok tutsa men. Kuze', miyi' xa' mizo Dios tsa', nagaktra' lë' xa' kun tsa' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Orze' nzhab rë xa' re' lo Jesús: ―¿Chon ska mile' Muisés mandad: “Yats tu yech par za' miyi'y ka' una', nes gak la' xa' una'”? ");
INSERT INTO zcaNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Orze' nzhab Jesús: ―Por niyent kwan gon goi, kuze' nguziyël Muisés la' nzë'b go tsa' go, per or galo gat lë't sa'i. ");
INSERT INTO zcaNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Per na ni lo go, cho la' nzë'b una' che'n, no gat lë't por milibe' la una' miyi'y or naga ban una' kun miyi' re', no chi ban miyi' kun xtu una', nzë'b xki xa' lo Dios orze'. No nu ska, xa' ban kun una' re', nzë'b xki ska xa' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Orze' nzhab rë men che'n Jesús: ―Chi lë'i sa' nak kwent che'n men nzhap una', neka más wen nakwa'nt xa' una'. ");
INSERT INTO zcaNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Orze' nzhab Jesús: ―Gat lë't rë go gak zobyek kure', nab tsa rë xa' mile' Dios gak zobyeke, zobyeke. ");
INSERT INTO zcaNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Per nzho miyi' nagakt gap una', dizde or ngol xa', nak xa' sa'; no nzho miyi', nagakt gap una', por men mile' xa' sa'; mbaino nzho miyi' gakt ska gap una', par le' bixa' rë zhi'n nazhon che'n Dios kwa'n nile' bixa'. Kuze', xa' gak zobyek kure', lë' xa' zobyeke. ");
INSERT INTO zcaNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","No ngwanu rë men rë më'd lo Jesús par xo'b Me ya' Me yek bimë'd, mbaino na'b Me ya rë më'd wen, orze' nala't rë men che'n Me zubi rë më'd lo Me, ");
INSERT INTO zcaNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","per nzhab Me lo rë men che'n Me: ―Bila' go yi'd rë më'd ba' lon, naka'nt go lo bimë'd, porke plo nile' Dios mandad, nak che'n rë men, xa' nak nela më'd ga'. ");
INSERT INTO zcaNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Or milo'x mixo'b Me ya' Me yek rë më'd ze', nzha Me xtu plo. ");
INSERT INTO zcaNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Lë'chi nguio lo Jesús, mizhin tu miyi' xi, nzhana'bdi'zh miyi' lo Me, nzhab miyi': ―Maestr, ¿cho kwa'n naki'n len par nen, lë' da ban dubta' lo Dios? ");
INSERT INTO zcaNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Orze' nzhab Jesús: ―¿Chon mina'bdi'zhal lon, kwan wen? Nabtsa Dios wen. Chi nzhaklal banal dubta' lo Dios, bile' rë nak kwa'n nzobni' lo ley che'n Muisés. ");
INSERT INTO zcaNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Orze' nzhab miyi' re': ―¿Cho pa' kwa'ne? Mikab Jesús: ―Nagutal men, nabantal kun una' gat lë' tsa'l, no naliwa'ntal, mbaino nakë'tal kixu' xa' yent kwan nak, ");
INSERT INTO zcaNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","gop kwent xuzal mbaino xna'l, no bichizhi' xtu men nela lu ka. ");
INSERT INTO zcaNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Orze' nzhab miyi' xi re': ―Rë kure' mile la, dizde or win da. ¿Kwan ra' más jwalt len? ");
INSERT INTO zcaNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Orze'se nzhab Jesús kure': ―Chi walika nzhaklal gakal tu men nile' rëi lo Dios, bito rë nak kwa'n kinul, orze' biza'i, ka' rë xa' yent kwan kinu, nes gapal yalrrik lo yibë'; orze' dikë ticha. ");
INSERT INTO zcaNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Or mbin miyi' xi kure', dub niwin laxto' xa', ña xa', porke dox rrik xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Orze' nzhab Jesús lo rë men che'n: ―¡Walika kwa'n kinin lo go, dox nagan, yo tu rrik plo nile' Dios mandad! ");
INSERT INTO zcaNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Xtu wëlt nin lo go, más jwals ded tu kamey xan tu yaguj, ke par yo tu rrik plo nile' Dios mandad. ");
INSERT INTO zcaNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Or mbin rë men che'n Me kure', xe mia'n bixa' tuli, orze' nzhab bixa' lo wech bixa': ―Chi lë'i sba', ¡pas yent cho men le' gan, ro' lo rë kwa'n nazhe'b nzho men! ");
INSERT INTO zcaNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Orze' xe miwi' Jesús lo bixa', no nzhab Jesús: ―Par rë men, nzho kwa'n nagakt le' men; per Dios, yent cho tu kwa'n nagakt le' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Orze' nzhab Per: ―Biwi'u, no mila' rë kwa'n, par nzadkë no tich go; nal, ¿kwan gal no por kure'? ");
INSERT INTO zcaNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Mikab Jesús: ―Walika kwa'n nin lo go, xtu yizhyuo kwa'n laore yo, or zob Xga'n Dios Me nu nak tu men yizhyuo, par le' Me mandad; no rë go xa' mbidkë ticha, se'ska zob za tu dusen go, par kube' go lo dub tu dusen ben men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","No rë xa' la' lizh, o wech, o bizan, o xuz o xna', o xmë'd, o yuo che'n; por nak xa' men da; no xtu gayo' wëlt más nayaxe gap xa' lo yizhyuo re'; no lo xtu yizhyuo kwa'n laore yo, ya nayotra' gat xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Per nayax xa' galo, xa' ze' gak xa' lult; no xa' lult gak xa' galo. ");
INSERT INTO zcaNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Nu nak plo nile' Dios mandad nela tu xa' nak che'n tlë' yuo. Garzi'l laka nguro' xa', ngwakwa'n xa' mos par kë zhi'n lo yuo plo kinu xa' ya gub che'n xa', ");
INSERT INTO zcaNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","no mia'n xa' di'zh plak kix xa' ka' rë mos ze' tu ngubizh zhi'n; orze' mixë'l xa' rë mos ze' plo nzhi'b ya gub che'n xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","No mis zhë ze', paste las nueve garzi'l, xtu wëlt ngwa xa'. Or une xa' lo xbi', zipla xa' yent kwan kile', ka nzhin ze', ");
INSERT INTO zcaNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","orze' nzhab xa' kinu zhi'n ze': “Nu go wa zhi'n plo nzhi'b ya gub da, na kix ka' go kwa'n ñal.” Orze' nu bixa' nzha zhi'n. ");
INSERT INTO zcaNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","No xtu wëlt ngwa xa' nak che'n yuo ze', paste nzhala garol zhë, no nu ngwa xa' paste nzhala las tres zhë, no se'ga' mile' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","No lult or par lox la ngubizh, ngwa xa' paste las cinco guzhe ngwakwa'n xa' más mos kë nzhin che'n xa', lë'chi une xa' zipla xa' ka nzhin ze', orze' nzhab xa' kinu zhi'n re': “¿Chon dub zhë nzhin go re', yent kwan kile' go?” ");
INSERT INTO zcaNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Orze' nkab rë mos re': “Yent cho ngale' no par kë no zhi'n.” Orze' nzhab xa' re': “Sas go, nu go wa zhi'n plo nzhi'b ya gub da.” ");
INSERT INTO zcaNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","No or mizhëlyuo, nzhab xa' nak che'n rë ya gub ze' lo mos xa' nile' mandad lo más rë mos: “Gurezh rë mos par gudix ka' bixa'; guzublo kun rë xa' nguio lult lo zhi'n, orze' lult gudix ka' rë xa' nguio galo laka lo zhi'n.” ");
INSERT INTO zcaNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Or nguzubi rë mos kwa'n nguio lo zhi'n paste las cinco guzhe, ngox nka' bixa' kwa'n nzhax ka' tu men nikë zhi'n dub zhë. ");
INSERT INTO zcaNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Or nguzubi rë mos kwa'n nkë zhi'n dub zhë, mile' bixa' xigab, más ngax ka' bixa'; per tuga' bixa' ngox ka' kwa'n nzhax ka' tu men tu ngubizh zhi'n. ");
INSERT INTO zcaNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kuze', or nguzen bixa' dimi, nguzublo midi'zh bixa' gat lë' lo xa' nak che'n zhi'n ze', ");
INSERT INTO zcaNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","nzhab bixa': “Rë mos, xa' nkë zhi'n tutsa or, lal ndix go nka' no kun lë' bixa', mbaino dub zhë nkë no zhi'n no dub lo nëi'.” ");
INSERT INTO zcaNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Orze' nzhab xa' nak che'n zhi'n lo tu rë xa' ze': “Wen da kun lu; ni tu kwa'n gat lë' milen kun lu. ¿Chi gat lë't sa' mia'n be, kixa ka'l che'n tu ngubizh zhi'n? ");
INSERT INTO zcaNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Guzen kwa'n ngox ka'l ba', bizë; porke na nzhakla kixa ka' xa' nguio lult lo zhi'n nela kwa'n ndixa ka'l ga'. ");
INSERT INTO zcaNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Na gak le kwa'n nzhaklan kun dimi da, o, ¿chi niyi'l por wen da kun men?” ");
INSERT INTO zcaNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kuze', xa' lult gak xa' galo, no xa' galo gak xa' lult. ");
INSERT INTO zcaNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Dub nzha Jesús nez yezh Jerusalén, lë'chi tu lad ngurezh Me za tu dusen men che'n Me, nzhab Me: ");
INSERT INTO zcaNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Biwi' go, lë' be nzha yezh Jerusalén; na Xga'n Dios no nu nak da tu men yizhyuo; ba' lë' rë men chi da lo rë ngulëi' xa' nile' mandad lo más rë ngulëi', no lo rë maestr xa' nilu' ley che'n Muisés; orze' lë' bixa' na'b gat da. ");
INSERT INTO zcaNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","No chi bixa' da lo rë men gat lë't men Israel; lë' rë xa' re' xizhnu da, no chël bixa'i ticha, mbaino kë' bixa' da lo krus; per ngubizh yon lë'da ruban. ");
INSERT INTO zcaNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Orze', lo Jesús nguzubi xna' rop xga'n Zebedeo, Jakob no Juan, tuli ngo't kuslo una' par na'b una' le' Me tu kwa'n, ");
INSERT INTO zcaNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","orze' nzhab Jesús lo una': ―¿Kwan nzhaklal len por lu? Orze' mikab una': ―Or gak go rey, le' go mandad, nzhaklan zob tuga' xga'na re' kad ta' go. ");
INSERT INTO zcaNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Per nzhab Jesús: ―Nanet go kwan kina'b go; ¿chi zo go kwa'n nala kwa'n go'n? Orze' mikab bixa': ―Lë'i gak ka go no. ");
INSERT INTO zcaNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Orze' nzhab Jesús: ―Ter go go kwa'n nala kwa'n go'n, per gat lë't na kube' cho zob kad ta'n; nab tsa Xuza nane cho rë xa' gak zob ta'n. ");
INSERT INTO zcaNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Or mbin zichi' men che'n Jesús kure', orze' niyi' bixa' lo Jakob no lo Juan, ");
INSERT INTO zcaNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","per ngurezh Jesús za chi' xa' re' par nzhab Me: ―Lë' go nane ka, xmod nak rë xa' nile' mandad xid rë men gat lë't men Israel, dox naye nikë xa' men zhi'n; mbaino rë xa' ro, xa' nzho xid bixa', kwa'n nzhakla bixa' nilinu bixa' men, ");
INSERT INTO zcaNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","per go, nagakt go sa'; porke xa' nzhakla le' mandad xid go, xa' ze' gak nela tu mos ga' xid go; ");
INSERT INTO zcaNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","mbaino xa' nzhakla gak xa' galo xid go, xa' ze' gak xa' lult, nela tu mos nado lo xtu men ga', ");
INSERT INTO zcaNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","porke na ni, ter nak da Xga'n Dios, no nak da tu men yizhyuo; per nagaxë'lt Dios da par len mandad lo rë men; lë'da nzhal par len kwa'n ne bixa', mbaino haxta gat da por lë' bixa', par kixa rë kwa'n nzë'b xki bixa' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Or nzharo' la Jesús yezh Jericó kun rë men che'n Me, no nayax men nzhakë tich Me; ");
INSERT INTO zcaNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","lë'chi ro' nez ze' nzob chop men nikal lo. Or mbin bixa' lë' Jesús nzhaded ze', tuli nguruzhië bixa': ―¡Lë' go, Xga'n Dabi, bilats laxto' go no! ");
INSERT INTO zcaNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Orze' niyi' rë men nguruzhyë bixa', per más naye nguruzhië bixa', nzhab bixa': ―¡Lë' go, Xga'n Dabi, bilats laxto' go no! ");
INSERT INTO zcaNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Orze' ngulëz Jesús, no ngurezh Me rop xa' nikal lo re', mbaino nzhab Me lo bixa': ―¿Kwan nzhakla go len kun go? ");
INSERT INTO zcaNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Orze' mikab bixa': ―Lë' go, nzhakla no le' go yani lo no. ");
INSERT INTO zcaNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","No milats laxto' Jesús bixa', migal Me lo bixa', lë'chi tuli ngwaniy, orze' nzhakë bixa' tich Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nzhazhin la Jesús yezh Jerusalén, per galo mizhin Me tu yezh win yezh kwa'n lë Betfagé; gax mont Olivos ña'ne. Ze' mixë'l Me chop men che'n Me, ");
INSERT INTO zcaNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nzhab Me lo bixa': ―Wa go yezh win kwa'n nzhin nali laka re'; or zhin go plo nikido' tu burr gol kun tu burrit, bixëk go ma no di'nu go ma, ");
INSERT INTO zcaNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","no chi na'bdi'zh tu men: “¿Plo wei' go burr ba'?”, orze' guzh go: “Lë' Señor naki'n ma, no lë' xa' zhire ska ma lwega'”, orze' lë' xa' la' yi'dnu go ma, ");
INSERT INTO zcaNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","nes ngok kwa'n midi'zh tu profet, xa' kwa'n midi'zh por Dios, or nzhab xa': ");
INSERT INTO zcaNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Guzh go lo rë men yezh Sion: “Biwi'u; lë' rey che'n go nzë, tu xa' nado', Nzob xa' tich tu burrit.” ");
INSERT INTO zcaNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","No ngwa rop men che'n Jesús ze', mile' bixa' nela xmod nzhab Jesús lo bixa', ");
INSERT INTO zcaNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ñadnu bixa' burr gol ze' kun xmë'd ma plo nzo Jesús, no mixo'b bixa' xab bixa' tich ma par nguzob Jesús ma. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Dox nayax men nzha ze', kiyix bixa' xab bixa' nez; nzho bixa' kicho' rram ya, par kiyix bixa'i plo nzhaded Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Rë xa' nzhubner plo nzha Jesús kun rë xa' nzhakë tich Me, kibizhyë bixa', nayë nzhab bixa': ―¡Par dubta' yo Xga'n Dabi! ¡Wen nzha xa' mixë'l Dios! ¡No par dubta' nzho Me nzho lo yibë'! ");
INSERT INTO zcaNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","No or nguio Jesús yezh Jerusalén, net men kwan le' men di tanta nizak laxto' men, nzhab bixa' lo wech bixa': ―¿Cho xa' ba'? ");
INSERT INTO zcaNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mikab más rë men nzha kun lë' Me: ―Lë' Jesuze, xa' nidi'zh por Dios, no yezh Nazaret nzë xa', kwa'n ña'n lazh men Galilea. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Or nguio Jesús lo luwe che'n yado', ngulo'tin Me rë xa' nile' xbi' ze', no michixche Me rë mes che'n rë xa' nichi'l dimi; no michixche Me rë plo nizob rë xa' nito palom, ");
INSERT INTO zcaNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","orze' nzhab Me lo bixa': ―Se' nzobni': “Lë' lizha ñal gak plo na'b men Lon”, ¡per go kile'i nela plo nibin wa'n ga'! ");
INSERT INTO zcaNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","No ze' nguzubi rë xa' nikal lo, no rë xa' ko'j lo Jesús, no miliyak Me bixa', ");
INSERT INTO zcaNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","orze' niyi' rë ngulëi' xa' nile' mandad lo más ngulëi'; kun rë xa' nilu' ley che'n Muisés or une bixa' rë kwa'n nazhon kwa'n kile' Jesús, no nu haxta rë më'd kibizhyë, lo luwe che'n yado', midi'zh bimë'd: “¡Par dubta' yo Xga'n Dabi!”, ");
INSERT INTO zcaNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","orze' nzhab rë xa' ze' lo Jesús: ―Biwi', ¿chi gat kiyontal kwan kidi'zh rë më'd ba'? ―Lë'i kiyon ka —mikab Jesús— ¿Chi nagat go'l go kwa'n nzobni' lo Yech che'n Dios?, widi'zh kwa'n nzhab: Widi'zh che'n rë mbwin, No kun widi'zh che'n mëdo' kwa'n nzho chich, Mile'l, nu bixa' midi'zh, nazhon Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Orze' mila' Jesús rë men ze', nguro' Me ze', ña Me yezh Betania plo mite'd Me yë'l kun rë men che'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","No xtu riyë'l, dub se' ñë'd Me di yezh Jerusalén, lë'chi mbi'd tu yalnila'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","No ro' nez une Me tu ya nzhao', no ngwatswi' Me, nabei chi nikë xlë loi per pura la nzhi'be, orze' nzhab Jesús: ―Ya nayotra' yi'd men gao men xlë lo ya re'. No mis orze', tuli mibizh ya nzhao' ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Or une rë men che'n Jesús kure', mia'n xe bixa' tuli, no nzhab bixa': ―¡Tatu mibizh ya nzhao' re' tuli! ");
INSERT INTO zcaNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Orze' nzhab Jesús: ―Walika kwa'n nin lo go, chi lë' go ñila widi'zh che'n Dios, no nale't go chop xigab, orze' lë' nu go le' kwa'n milen kun ya nzhao' ba', no haxta gab go lo yi' ba': “Chi ba', bizë haxta le'n nits”, no lë'i gak. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kuze' nin, rë kwa'n na'b go lo Dios, wayila goi namás, lë' Dios ne'i. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Or milox midi'zh Jesús widi'zh re', nguio Me lo luwe che'n yado', no dub kilu' Me widi'zh che'n Dios ze', nguzubi rë xa' nile' mandad lo rë ngulëi', kun rë xa' nzo lo rë men Israel, plo nzo Me, no nzhab bixa': ―¿Cho mile' mandadal kile'l rë kure'; no cho mixë'lal par le'le? ");
INSERT INTO zcaNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Orze' mikab Jesús: ―Nu da, na'bdi'zh ska tu kwa'n lo go. Bineo, ¿cho mixë'l Juan xa' mili'lëi' men le'n nits? ¿Chi Dios mixë'l xa', o mene? No chi lë' go ne choi, orze' ganin, cho mile' mandad da, kilen rë kure'. Orze' kidi'zh bixa' lo wech bixa': ―¿Chi gab be?: “Diose”, orze' lë' xa' ne lo be: “¿Chon ska nangayila go Juan?”; ");
INSERT INTO zcaNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","no chi gab be: “Men mixë'l xa'”, nazhe'b be par be, porke rë men zak, Juan tu xa' midi'zh por Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Orze' mikab bixa' lo Jesús: ―Nanet no cho mixë'l xa'. Orze' nzhab Jesús: ―Nuska da, nanita cho mixë'l da kilen rë kure'. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Orze' nzhab Jesús: ―¿Xmod nile' go xigab por kure'? Tu miyi' kinu chop xga'n, nzhab xa' lo xga'n galo xa': “Xga'n, wa zhi'n lo yuo plo nzhi'b ya gub che'n be.” ");
INSERT INTO zcaNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mikab xga'n xa': “¡Nayata!”; per guzhëla ze' xtu xigab mile' miyi', ngwa miyi'. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","No se' ska nzhab xuz bixa' lo xtu xga'n xa', per miyi' re' nzhab: “Lë'o, lë'da ya ka”, no nangat miyi'. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","No di lo rop miyi' re', ¿cho miyi' mbin ro' xuz? Mikab bixa': ―Miyi' mile' xa' mandad galo lakai. Orze' nzhab Jesús: ―Walika kwa'n nin lo go, rë xa' nikan dimi che'n Roma, kun rë una' le'n kai (kwa' gal), galo laka bixa' yo lo go plo nile' Dios mandad, ");
INSERT INTO zcaNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","porke Juan xa' mili'lëi' men le'n nits, mbi'dlu' lo go xmod ban go nali lo Dios, no nangont go ro' xa'; per rë xa' nikan dimi che'n rey kun rë una' le'n kai (kwa' gal), ngwayila bixa' xti'zh Juan. Per go, ter une go kure', per nangala't go rë kwa'n gat lë' kwa'n nak go orze' ngayila go xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Gon go xtu kwent re': Nguio tu miyi', mixë'n ya gub lo yuo che'n; mitsao' xa' naka'n ro'i, no mizuxkwa' xa' tu plo tsi' xa' gub che'n xa', nu mizuxkwa' xa' tu plo ya par kina xa'i. Sa' mila' xa'i par ga'n xtu mene, orze' nguro' xa' xche, nzha xa' xtu lazh men. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Or ngol tiemp miza'i, mixë'l xa' nak che'ne pla mos par na'b xa' lo xa' ngo'ne ze' kwa'n ñal xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Per rë xa' ngo'n yuo che'n xa', nguzen bixa' rë mos ze'; tu mos michël bixa'i tich, xtu mos mbit bixa', no xtu mos mbit bixa' kun ke. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Orze' mixë'l xa' nak che'n yuo ze', más nayax mos ke lë'la or galo, per sa' ska milinu bixa' rë mos ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Lult, mixë'l xa' tugaka xga'n xa' kwa'n kinu xa', mile' xa' xigab: “Ro' xga'nase gon rë xa' ba'.” ");
INSERT INTO zcaNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Per or une rë xa' ngo'n yuo ze', xga'n xa' nak che'ne, nzhab bixa' lo wech bixa': “Xa' re' ya'nu rë kure'; cha'o gut be xa' nes ya'nu be rë che'n xa'.” ");
INSERT INTO zcaNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Orze' nguzen bixa' miyi' re', ngulo' bixa' miyi' le'n ya gub, orze' mbit bixa' miyi'. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","No nal, or yë'd xa' nak che'n ya gub ze', ¿kwan li'nu xa' rë xa' ngo'n yuo che'n xa'? ");
INSERT INTO zcaNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Orze' nzhab bixa': ―Lë' xa' yë'd dub xian xa' par lo'x xa' rë men nakap kwa'n ngo'n yuo che'n xa', mbaino lë' xa' za' yuo ga'n xtu ben men; rë xa' re'se za' kwa'n ñal gal xa', kad or za' ya gub che'n xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Orze' nzhab Jesús lo bixa': —¿Chi nagat go'l go kure' kwa'n nzobni' lo Yech che'n Dios?: Lë' ke kwa'n ngulubi rë xa' nichao' yo', lë'i ngok ke kwa'n nzen dub yo'; kure' mile' Dios par rë men wi' xe. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kuze' nin lo go, por gat nzhont go ro' xa' mixë'l Dios lou, nazotra' go kina go rë men che'n Dios; xa'la men zo, rë xa' nzhon ro' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Mbaino ke kwa'n ngulubi go re', rë xa' yachin loi, lë' xa' xix; per chi lë'i gab yek tu men, de laka le'i xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Or mbin rë men, xa' nile' mandad lo ngulëi', kun men fariseo, widi'zh re'; ngwanu laxto' bixa', par yek bixa' nzha kwa'n midi'zh Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Mis orze' ngokla bixa' ngazen bixa' Jesús, per nangale't bixa'i por men mizheb bixa', porke rë men nzhin ze' zak, lë' Jesús nak tu profet, xa' nidi'zh por Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Xtu kwent midi'zh Jesús, nzhab Me: ");
INSERT INTO zcaNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Plo nile' Dios mandad nak nela tu rey xa' mile' jwandang che'n xga'n, ");
INSERT INTO zcaNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","mixë'l xa' rë mos che'n xa' ngwane lo men par yi'd bixa' jwandang; per net bixa' ngayi'd bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Orze' xtu wëlt mixë'l rey ze' xtu ben mos che'n xa' par ngwayab: “Dë' go, lë' kwa'n gao be nzhin la; lë'da mbit la rë ngo'n da kun rë ma más nacha', rëi nzhin la; kuze', dë' go le' be lani.” ");
INSERT INTO zcaNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Per mile' bixa' naya'; nzho bixa' ngwa zhi'n lo yuo che'n, no nzho bixa' ngwa xbi', ");
INSERT INTO zcaNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","no más bixa' nguzen rë mos che'n rey, ndin bixa' haxta mbit bixa' rë mos ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Orze' niyi' rey no mixë'l rey rë sondad che'n xa' par ngwayut rë xa' nzhut men ze', no haxta lazh rë men nakap ze' mizë'k bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Lult nzhab rey lo rë mos che'n: “Lë' rëi nzhin la par le' be jwandang, per rë men xa' nak di'zh ngayi'd, gat ñalt bixa' kure'; ");
INSERT INTO zcaNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","nalse wa go rë nez, waka'o cho la rë men yazhë'l go par yi'd bixa' jwandang.” ");
INSERT INTO zcaNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Orze' ngwa rë mos che'n rey, rë nez mikan bixa' dike men ngwazhë'l bixa', men wene o men nakape, haxta ngwazhë plo nzhin bixa' kile' bixa' jwandang. ");
INSERT INTO zcaNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Per or nguio rey par ne xa' rë men nzhin lo mes, no une xa' tu men nzob ze', no gat nakt xa' lar kwa'n nzhak men lo jwandang, ");
INSERT INTO zcaNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","orze' nzhab xa' lo men ze': “Lë' mbe', ¿chi niye laxto'l nzol re', ter gat naktal lar kwa'n ñal gak men lo jwandang?” Per yent kwan ngab xa' re' lo rey. ");
INSERT INTO zcaNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Orze' nzhab rey lo rë mos che'n xa': “Bili'b go ya' xa' no ni' xa', no gulo' go xa' tich lo nakao, plo go'n xa' haxta kwezh lëi xa' lo yalne”, ");
INSERT INTO zcaNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","porke nayax men nibezh Dios par gak men che'n Me, per che'ptsa men nile' kwa'n nzhakla Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Or milox midi'zh Jesús kure', nguiubchi rë men fariseo plo nzo Jesús par mia'n bixa' di'zh, le' bixa' gab Me tu kwa'n gat lë', ");
INSERT INTO zcaNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","kuze' tutsa mixë'l bixa' pla men che'n bixa' kun pla men che'n Herodes par nzhab rë xa' re' kure' lo Jesús: ―Maestr, nane no, lë'tsa lë' kwa'n nidi'zhal, no dox nzhakal nilu'l xmod nak nez che'n Dios; mbaino or nigobe'l tu kwa'n, gat nibetal men. ");
INSERT INTO zcaNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nal bine lo no, ¿xmod nak xigab che'nal? ¿Chi ñal kix no dimi kwa'n nzhax lo rey César, o gat ñalt gaxe? ");
INSERT INTO zcaNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Per lë' Jesús nane la xmod nak xigab che'n bixa', kuze' nzhab Jesús: ―¡Mbël gox, chigab walika men wen go! ¿Chon nzhakla go zenbe' go da? (wi' go xmod nak da) ");
INSERT INTO zcaNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Bilu' go tu pes kwa'n nzhax lo rey César. No milu' bixa' tu pes kwa'n lë denario, ");
INSERT INTO zcaNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","orze' minabdi'zh Jesús lo bixa': ―¿Cho nikë lo pes re', no cho lë nikë loi? ");
INSERT INTO zcaNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Orze' nzhab bixa': ―César nikë loi. Orze' mikab Jesús: ―Ne goix, biza' go che'n César kwa'n nak che'n César, no biza' go che'n Dios kwa'n nak che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Or mbin bixa' kure', xe mia'n bixa' tuli, net bixa' kwan le' bixa', orze' mila' bixa' Jesús, ña bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mis zhë ze', ngwa pla men saduceo lo Jesús, rë xa' nidi'zh: “Gat walit ruban men ngut”, ");
INSERT INTO zcaNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","orze' nzhab bixa': ―Maestr, lë' Muisés mila' di'zh lo no: “Chi lë' tu miyi' gat, no nangapt xa' më'd kun una' che'n xa', orze' lë' wech xa' naki'n ban kun lë' una' par gap xa' më'd por kwent che'n xa' ngut re'.” ");
INSERT INTO zcaNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mbaino nguio tu xa' xid no, ngop gazh wech; xa' galo ngop tu una', per ngut xa' no nangapt xa' më'd; orze' wech mirop xa' miban kun lë' una', ");
INSERT INTO zcaNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","per nu ska xa' re' ngut no nangapt ska xa' më'd kun lë' una'; no se'ska kun xa' mion, haxta kun za gazh xa', rë xa' ngut, ni tu xa' nangapt më'd; ");
INSERT INTO zcaNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","no lult, nu una' ngut. ");
INSERT INTO zcaNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Or ruban bixa', ¿cho xa' ya'n kun lë' una'?, porke za gazh xa' miban kun lë' una'. ");
INSERT INTO zcaNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Orze' mikab Jesús: ―Men migoch yek go, kuze' nagakt zobyek go rë kwa'n nzobni' lo Yech che'n Dios; no ni yalnazhon che'n Dios nanet go kwan. ");
INSERT INTO zcaNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Or ruban men, yentra' cho ban kun una', no ni yentra' cho za' xcha'p ban kun miyi'; porke lë' bixa' gak nela rë ganj che'n Dios, Me nzho lo yibë'. ");
INSERT INTO zcaNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","No por kwa'n ruban men ngut, ¿chi nagat go'l go kwan midi'zh mis Dios or midi'zh Me se': ");
INSERT INTO zcaNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Na nak Dios che'n Abraham, no Dios che'n Isaac, no Dios che'n Jakob”? Porke Dios, gat lë't Dios che'n rë mengute, lë' Dios nak Dios che'n rë men naban. ");
INSERT INTO zcaNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Or mbin rë men nzhin ze' kure', xe mia'n bixa' por rë widi'zh kwa'n milu' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Or mbin rë men fariseo, lë' Jesús mitsao' ro' rë men saduceo ze', orze' migan bixa' lo Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","no xid rë xa' re', tu xa' nilu' ley mina'bdi'zh kure' lo Jesús par zenbe' xa' Me: ");
INSERT INTO zcaNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestr, ¿kwan más naki'n le' men xid rë kwa'n nzobni' lo ley? ");
INSERT INTO zcaNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nkab Jesús: ―“Bichizhi' Señor Dios che'nal kun dub laxto'l, kun dub lal, mbaino kun rë xigab che'nal.” ");
INSERT INTO zcaNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kure' kwa'n más naki'n le' men galo laka lo rëi; ");
INSERT INTO zcaNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","No kwa'n rop kwa'n naki'n le' men nak kure': “Bichizhi' xtu men, nela lu ka.” ");
INSERT INTO zcaNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Rop gaka kure' más kwa'ro xid rë kwa'n nzobni' lo ley, mbaino xid rë kwa'n midi'zh rë profet, xa' midi'zh por Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Dub nzhin rë men fariseo ze', mina'bdi'zh Jesús lo bixa', ");
INSERT INTO zcaNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","nzhab Me: ―¿Xmod nile' go xigab, plo nzë Krist? ¿Cho Xuz Krist? Nkab bixa': ―Dabi nzhak xuz Krist. ");
INSERT INTO zcaNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Per nzhab Me: ―¿Chon midi'zh Dabi, por Sprit che'n Dios, or nzhab xa': “Lë' Krist, Me nile' mandad da”, porke yub Dabi nzhab: ");
INSERT INTO zcaNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Lë' Dios nzhab lo Me nile' mandad da: “Guzob ta'n lad direch haxta or len, che'ptsa (bi'ch laka) gak rë xa' nidilal, xan ni'l”? ");
INSERT INTO zcaNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Chi yub Dabi nzhab: “Krist Me nile' mandad da”, orze', ¿xmod gak Dabi Xuz Krist? ");
INSERT INTO zcaNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","No ni tu bixa' nangakt ngakab ni tu widi'zh lo Jesús, no dizde orze', yent ra' cho ngaye laxto' ngana'bdi'zh más kwa'n lo Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Orze' nzhab Jesús kure' lo rë xa' nzhin ze' no lo rë men che'n Me: ");
INSERT INTO zcaNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Rë xa' nilu' ley che'n Muisés, no rë men fariseo, nzhab bixa', lë'gaka bixa' nilu'i nela xmod ñalkai. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nin lo go, bin go widi'zh che'n bixa', no bile' go kwa'n ne bixa', per nagakt go nela lë' bixa'; nidi'zh bixa' tu kwa'n, no xa' kwa'n nile' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kwa'n nilu' bixa' lo men nak nela tu kwa'n dox ne' ga', no jwers wei' mene nzhakla bixa'; mbaino lë' bixa' ni ya' bixa' gat nigo bixa' ta'i par wei' mene. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Se' nile' bixa' par ña'n bixa' wen lo más rë men; no ño laxto' bixa', kë tu yech lo xchuzh bixa' plo nzobni' widi'zh che'n Dios; no nzhak bixa' lar no'l xlox, nes par gab men, walika men che'n Dios bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","No ño laxto' bixa', galo laka bixa' zob plo nizob rë xa' tsak plo nzhak tu lani no le'n rë yo' plo nitse'd men widi'zh che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","No nu nzhakla bixa' zen men ya' bixa' dub lo men, mbaino gab men lo bixa': “Maestr”. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Per nzhab Jesús lo rë men che'n Me: ―Xid go, gat ñalt ne men Maestr lo go, porke tutsa wech rë go por nak go men da; no tutsa maestr kinu go, Me nak Krist. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","No ni nagab go: “Pa”, lo tu men gat lë't xuz go, porke tutsa Xuz go kinu go, Me nzho lo yibë'. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","No naziyëlt go kulë men go: “Maestr”, porke tutsa Krist nak Maestr che'n go. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Men xa' nzhakla gak xa' más tsak xid go, xa' ze' gak xa' le' kwa'n gab go, ");
INSERT INTO zcaNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","porke xa' nzhakla gak xa', xa' tsak; lë' Dios layët xa'; per xa' gat nzhaklat gak xa', xa' tsak, lë' Dios le' gak xa' tu men tsak. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Orze' nzhab Jesús lo rë men nilu' ley mbaino lo rë men fariseo: ―¡Nal ne goi, go xa' nilu' ley, no go, men fariseo, chigab walika men wen go! Net go, xa'l go ro' pwert plo nile' Dios mandad par yo más rë men; no ni mis go nanet yo, mbaino ni nala' go yo xtu men, xa' nzhakla yo. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Nal ne goi, go xa' nilu' ley, kun go men fariseo! ¡Tatu nazhe'b nak go! Nilat go lizh rë una' ngut xmiyi', no xche nile' go nina'b go lo Dios. Por nak go sa', más zakzi Dios go. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Nal ne goi, go xa' nilu' ley kun go men fariseo, chigab walika men wen go! Nikizë go xtu ro' nitsdo' mbaino rë plo nzhin men par le' go gan tse'd men widi'zh che'n Dios nela go ga', no or milox mitse'd go bixa', más nzhak bixa' xin Mizhab lo go, kuze' galo laka bixa' bi le'n gabil lo go. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Nal ne goi, go xa' nak nela tu men nikal lo ga'!, per nzhakla go lu' go nez lo xtu men. Nzhab go lo rë men, chi la' tu men di'zh, le' xa' tu kwa'n por yado', nzhab go, yent kwane ter nale't xa'i; per chi la' tu men di'zh le' xa' tu kwa'n por rë kwa'n gor che'n yado', orze'se naki'n le' xa'i, nzhab go. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Taxa chi miao' yek go! ¿Chi gat ñanit lo go? ¿Kwan más tsak? ¿Chi rë kwa'n gor che'n yado'i, o yub yado' kwa'n nile' ña'n nazhon rë kuba'i? ");
INSERT INTO zcaNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","No nu nzhab go, chi tu men mila' di'zh le' xa' tu kwa'n por biko' che'n yado', gat naki'nt le' xa'i; per chi mila' xa' di'zh le' xa' tu kwa'n, por gon kwa'n nixo'b lo biko', orze'se naki'n le' xa' kwa'n mila' xa' di'zh. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Miao' yek go mbaino nikal lo go! ¿Kwan más tsak? ¿Chi gone, o biko' kwa'n nile' ña'n gon nazhone?, ");
INSERT INTO zcaNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","porke xa' nila' di'zh, le' tu kwa'n por biko', gat lë't nab por biko' nidi'zh xa'i; nu por rë kwa'n nixo'b lo biko' nile' xa'i. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","No rë xa' ze't yado' or nila' xa' di'zh le' xa' tu kwa'n, no gat lë't nab yado' kize't xa', nu Dios Me nak che'n yado' kize't xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mbaino rë xa' nize't yibë' or nila' xa' di'zh le' xa' tu kwa'n, gat nabt yibë' nize't xa'; nu plo nizob Dios, no haxta nu Dios, Me nizob ze' kize't xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Nal ne goi, rë go xa' nilu' ley, kun rë go, men fariseo, chigab walika men wen go! Niza' go diezmo lo Dios che'n rë kwa'n nixë'n go: rë yix ment, no rë anís, mbaino rë kumin. Per gat nile't go rë kwa'n tsak re': le' go kwa'n ñal kun kad men, no lats laxto' go men, mbaino ban go nab tsa par Dios. Galo laka re' kure' ñal le' go kwa'n nzobni' lo ley per naya'lt laxto' go le' go rë más rë kwa'n menes tsak. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Ter nak go nela men nikal lo ga', per nzhakla go, go lu' nez che'n Dios lo más rë men! Nak go nela tu men nigo' tu nguru'zh le'n tu vas nits, per nanet xa' tu ma más kwa'ro niyëb xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Nal ne goi, rë go xa' nilu' ley kun rë go xa' fariseo, chigab walika men wen go! Nizët go tich vas no tich plat, no lë' yek go ngwazhëi di rë xigab liwa'n go, no naxekt go ka'n go lo kwa'n nzhakla kwerp che'n go. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Men fariseo, nikal lo go! Galo laka bizët go le'n vas no le'n plat, nes par ya'n nambe tiche. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Nal ne goi, rë go xa' nilu' ley, kun rë go men fariseo, chigab walika men wen go! Nak go nela rë ba': chul nilu'i al tich, per al le'ne, ngwazhë di hues che'n yinto', kun más rë kwa'n gat nambe. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sa' nak go: al tich nilu' go nela men dox nile' kwa'n nzhakla Dios, no lo rë más men; per al le'n laxto' go, zhëi di kwa'n nikide go men, no rë kwa'n nayi'lazh go lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Nal ne goi, xa' nilu' ley, kun go, men fariseo, chigab walika men wen go! Chul nizuxkwa' go rë ba' che'n rë profet xa' midi'zh por Dios nzhala, mbaino rë ba' che'n rë men xa' mile' rë kwa'n nzhakla Dios, par nitsila men bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","No nidi'zh go: “Chi ngak nzo la be rë zhë or miban rë xa' kwa'n midi'zh por Dios chi tiemp, ngala't be ngut men rë profet ze'.” ");
INSERT INTO zcaNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Por nidi'zh go sa', kuba' nilu' tutsa nak go kun rë xa' mbit rë profet ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kuze', ¡bilo'x go kwa'n mizublo rë xuz go, xa' mbit rë men che'n Dios ze'! ");
INSERT INTO zcaNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Rë go nak nela mbë'l ga'! ¡Nzë go ben che'n mbë'l nayi'! Biwi' go xmod le' go gan, par nalox go le'n gabil. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kuze', lë' da xël rë profet da lo go, xa' nidi'zh por Dios, kun rë xa' dox nzhak, mbaino rë xa' kwa'n nilu' xti'zha lo go; per lë' go gut bixa', kë' go bixa' lo krus; no más bixa' chël goi tich le'n rë yo' plo nitse'd men widi'zh che'n Dios; no nzho bixa' ru'kë go tich tu yezh, xtu yezh, ");
INSERT INTO zcaNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","nes par yek go xo'b Dios rë ren che'n rë men, xa' ngut por mile' bixa' rë kwa'n nzhakla Dios, dizde Abel haxta Zacarías, xga'n Berequías, xa' ngut lo luwe che'n yado' plo nzob biko', por mandad che'n rë xuz go. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Walika kwa'n nin lo go, Dios na'b kwent ren che'n rë xa' re' lo rë men nal re'. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Yezh Jerusalén, yezh Jerusalén, rë men che'nal nzhut rë profet, xa' nidi'zh por Dios, no nigo' ke bixa' rë men nixë'l Dios lo bixa'! ¡Nayax wëlt, ngoklan tutsa ngazhina bixa', nela or niye'zh nguid rë xmë'd ma le'n xi'l ma, per naya' mile' bixa' lon! ");
INSERT INTO zcaNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nal ne bixa'i, lë' yado' che'nal ya'n nzë'b. ");
INSERT INTO zcaNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ya nanetra' bixa' da haxta or zhin zhë gab bixa': “¡Wen nzha xa' le' mandad lo be, xa' mixë'l Dios!” ");
INSERT INTO zcaNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Or nzharo' Jesús le'n yado', nguzubi pla rë men che'n Me lo Me, nzhab bixa', tatu chul yado' re', kun más rë yo' che'ne, ");
INSERT INTO zcaNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","per nzhab Jesús: ―¿Chi niwi' go por chule? Walika kwa'n nin, lë' zhë zhin, ni tu rë ke kwa'n nakxao'we re', naya'nte tich weche; rëi bil. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Or nzha bixa' yek lom kwa'n lë Olivos, dub nzob Jesús ze', lë'chi nguzubi nab rë men che'n Me lo Me, par nzhab bixa' lo Me: ―Bine go lo no, ¿pok gak rë kwa'n midi'zh go ba'?, no, ¿kwan pa' yo yizhyuo or nzhazhin la yë'd go xtu wëlt yizhyuo?, mbaino, ¿kwan pa' gak yizhyuo or nzhazhin la loxe? ");
INSERT INTO zcaNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Orze' nzhab Jesús: ―Neu nakide men go, ");
INSERT INTO zcaNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","lë' nayax men yo xa' di'zh: “Na nak Krist”, no nayax men kide bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Rë plo gon go kidil men, per yent kwan zheb go, lë' rë kure' naki'n gak per jwalt ra' lox yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Lë' tu gubier dil kun xtu gubier, no tu yezh kun xtu yezh dil, mbaino rë plo yo yalwin no win xo. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Per laore lo yalne re', kwa'n yo yizhyuo re', nela yalne kwa'n nine tu una' gal xin ga'. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Lë' men zen go no wei' bixa' go lo rë gustis; lë' bixa' gut go, mbaino rë men yi' ne go por nak go men da. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Le'n rë zhë ze', nayax men da nayilat ra' bixa' da, mis lë' bixa' chi más bixa' par gut rë xa' nak zhi'n bixa', mbaino yi' bixa' ne bixa' wech bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","No nu yo nayax men, xa' chigab walika tu profet xa' nidi'zh por Dios, mbaino kide bixa' nayax men. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","No por dox yar rë xa' la' ley che'n Dios tu lad, por nayi'lazh bixa', kuze' nayax men la' nazinet ra' laxto' bixa' men. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Per xa' zo naye lo kwa'n ñila xa' Da dub nzhak rë kure', xa' re' gap yalnaban dubta' kun Dios, ");
INSERT INTO zcaNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","no dub yizhyuo, yadi'zh men xmod yo men plo nile' Dios mandad, nes par gon rë lo ben mene, orze' lox yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","No nu nzhab Jesús: —Se' mizobni' profet Daniel. Tu ngubizh lë' men yala' tu gon dox gat nambet le'n yado' che'n Dios plo más nazhon. Xa' go'l kure' naki'n zobyek xa'i. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Orze' rë men xa' nzho lazh men Judea, naki'n kë' bixa' karre, bi bixa' dan, ");
INSERT INTO zcaNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","no rë xa' nikë yek yo' le'n rë ngubizh ze', naza't la bixa' par ko' bixa' rë che'n bixa' le'n yo'; ");
INSERT INTO zcaNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","no rë xa' nzo dan, naza't yubre bixa' lizh bixa' yaka' bixa' xab bixa'; ");
INSERT INTO zcaNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","mbaino rë una' nakxin no rë una' naka' më'do' rë zhë ze', zhe'b nalats nzha bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bina'b go lo Dios par nagak kure' rë mbëo' nayag, no ni zhë kwa'n nayi' kë men zhi'n, ");
INSERT INTO zcaNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","porke dox nazhe'b kwa'n ne men rë zhë ze', rë kwa'n lalta' nagat ne men dizde nguiuxkwa' yizhyuo, no ni nayora' ne mene. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Chi lë' Dios nakwë'zt ra' rë kure', rë zhë ze', orze' yot men le' gan loi; per lë' Dios le' kwë'ze, por rë xa' ngule Dios, nak men che'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’No chi cho ne lo go, le'n rë ngubizh ze': “Biwi' go; lë' Krist nzo re'”, o “Lë' Krist ba'”, nayilat goi. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Lë' nayax men yo, kide bixa' men, gab bixa' lë' bixa' Krist, no nu gab bixa', nidi'zh bixa' por Dios; haxta le' bixa' nayax rë kwa'n chigab nazhon par kide bixa' men, no haxta nu rë men xa' ngule Dios gak men che'n Me, nzho rriez kide bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Biwi' go, nes par or gak rë kure', non la goi (nane la goi). ");
INSERT INTO zcaNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kuze', chi cho ne lo go: “Biwi'u, lë' Krist nzo le'n yuo bizh”, nayilat goi; o chi ne bixa' lo go: “Biwi' go, lë' Me nzo le'n yo' re'”, nayilat ska goi, ");
INSERT INTO zcaNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","porke nela or nine men nzha' tu do'zi', niziniy tu lad no xtu lad lo yibë', se'ta' ne rë men or yala. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nela or nine men tu plo nidal ngulbech, ze' sigur ka nax tu ma ngut. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Or lox rë yalzi kwa'n yo yizhyuo, orze' tuli ka kao lo ngubizh, no nazinit ra' mbëo', mbaino rë mbël lo yibë' gab; no haxta xiz rë kwa'n nzho lo yibë'. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Orze' luxo'b señ che'n Xga'n Dios Me nu nak tu men yizhyuo, rë ben men yizhyuo go'n di zheb or ne bixa' yala le'n xkao par len mandad lo rëi, kun biani ro che'n yalnazhon da. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","No or yen kwezh tu trompet nayë, xëla rë ganj Da par kan rë men ngulen dap lad lo yizhyuo, dizde tu ro' haxta xtu ro'. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Or niwi' go lo ya nzhao' nzë bixiche, nane la go, lë' mbëo' nëi' nzhazhin. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","No se'ga', or ne go kiyak rë kwa'n yizhyuo; lë' go nane la, lë'da nzhazhin la yal; nzo la ro' yo'. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Walika kwa'n nin lo go, rë kure' gak antis dike gat rë men xa' nzho orze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yibë' no yizhyuo lë'i lox; per widi'zh da, par dubta' yoi. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Per rë ngubizh or gak rë kwa'n yizhyuo, yent cho nanei; ni rë ganj yibë', no ni Na; tugaka Xuza nane poke. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’No nela rë zhë or miban Noé, se'ta' gak zhë or yala. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Le'n rë zhë ze', or naga la yiu nazhe'b, ndao men, ngu' men, ngok jwandang che'n men, no miza' men xcha'p men ngok jwandang che'n haxta zhë or nguio Noé le'n yo'ya, ");
INSERT INTO zcaNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","no ni xigab nangale' bixa', lë'chi ngula yiu nazhe'b, milo'xe rë nak bixa'; se'ska rë men nal re', ni xigab nale' bixa', lë'chi ne bixa' ruxo'ba. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Le'n rë zhë ze', chop miyi' nzo dan; tu miyi' wë̱i̱ñ, lë' xtu miyi' ya'n; ");
INSERT INTO zcaNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","o chop una' kiyo; tu una' wë̱i̱ñ, lë' xtu una' ya'n. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Kuze' bikina go go, porke nanet go, zhë or yala. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Per nane ka go, chi tu xa' nak lizh tu yo', nzhon xa' cho or yo wa'n lizh xa' yë'l, lë' xa' kina par yent cho liwa'n lizh xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kuze' bikina go go, porke lë'da yal zhë nale't go xigab. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Lë' go nane ka, tu mos nzhon di'zh no natsin; or nizo xa' nile' mandad mos re' par kina lizh xa', no za' mos re' kwa'n gao más tsa' mos xa', ");
INSERT INTO zcaNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","wen nzha mos re', or yëk xa' nile' mandad xa', lë' xa' ne, kile' ka mos re' kwa'n ñal le' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Walika nin lo go, lë' xa' la' rë nak kwa'n kinu xa' lizh xa' ya' mos. ");
INSERT INTO zcaNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Per chi lë' mos re' gak tu mos nakap, gab mos: “Lë' xa' nile' mandad da nayë'd gat”, ");
INSERT INTO zcaNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","orze' zublo mos za' lao' más rë tsa' mos xa', mbaino zo xa' xid rë nguy par gao xa' no go xa' kun rë nguy, ");
INSERT INTO zcaNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","no xa' nile' mandad ze' yë'd or nale't mos re' xigab, ");
INSERT INTO zcaNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","orze' dox zakzi xa' mos re', no xë'l xa' mos plo nzho rë men nikide men; ze' go'n mos di yalne, haxta kwezh lëi mos. ");
INSERT INTO zcaNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’No nu plo nile' Dios mandad nak nela kwent che'n chi' una' ye'n, xa' kinu kwa'n nizini kun aseit, par nzha bixa' jwandang. Dub kimbëz bixa' zhin miyi' xa' nak che'n jwandang ze', ");
INSERT INTO zcaNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","gai' una' ye'n re', xa' naro'b laxto', mbaino zigai' una' ye'n, xa' natsin. ");
INSERT INTO zcaNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Rë una' ye'n, xa' naro'b laxto' re', nzhanu ka bixa' kwa'n nizini, per nangwei't bixa' xche'p aseit part par yo le'n kwa'n nizini kwa'n nzen bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Per rë una' natsin re', nzhanu bixa' kwa'n nizini no part ka nzhanu bixa' xche'p aseit. ");
INSERT INTO zcaNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","No por dox milë' xa' nak che'n jwandang re', orze' rë una' ye'n ze' nzë mika'l lo, no nguzen mika'l bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Paste garol yë'l, mien nibizhyë tu men: “¡Biwi' go, lë' xa' nak che'n jwandang mizhin la! ¡Guro' rë go par kwin go kun lë' xa'!” ");
INSERT INTO zcaNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Orze' rë una' ye'n ngwaxche, mitsinki bixa' kwa'n nizini re', ");
INSERT INTO zcaNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","orze' nzhab rë una' ye'n, xa' naro'b laxto' ze', lo rë una' natsin re': “Tatu wen gak go, ne' go che'p aseit che'n go ka' no, porke kwa'n kizini no re', nzadlox aseit le'ne.” ");
INSERT INTO zcaNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Orze' nzhab rë una' natsin ze': “Nane't noi, nzha ska nagale par no. Neka wazi' goi par go.” ");
INSERT INTO zcaNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","No dub nzhazi' rë una' ze' aseit par lë' bixa', lë'chi mizhin miyi' gak jwandang che'n ze', no za gai' una' natsin nguio le'n yo' kun lë' miyi', orze' miao' ro' yo'. ");
INSERT INTO zcaNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","No guzhëla ze', mizhin rë una' ye'n, rë xa' naro'b laxto' ze', ro' yo'; orze' nzhab bixa': “¡Señor, señor! ¡Bixa'l go ro' yo' yo no!” ");
INSERT INTO zcaNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Orze' nzhab miyi' nak che'n jwandang ze': “Walika kwa'n nin, nalibe'ta' go.” ");
INSERT INTO zcaNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kuze' nzhab Jesús: ―Gok go natsin, porke nanet go cho zhë no ni or yala. ");
INSERT INTO zcaNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’No nu ska, plo nile' Dios mandad nak nela xmod mile' tu miyi'; jwaltra' di ro' xa' lazh xa' tu tiemp, ngurezh xa' rë mos che'n xa' par mila' xa' rë dimi che'n xa', kë rë xa' re' zhi'n kun lë'i. ");
INSERT INTO zcaNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Lo tu xa' mila' xa' gai' mile, no lo xtu xa' mila' xa' chop mile, mbaino lo xtu xa' mila' xa' tu mile; lo tu ga' rë mos mila' xa' dimi kwa'n zu'tsa bixa', orze' nzha xa' nak che'ne. ");
INSERT INTO zcaNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","No mos kwa'n mia'nnu gai' mile, tuli ka unkë xa' zhi'n kun lë'i, no mile' xa' gan xtu gai' mile. ");
INSERT INTO zcaNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","No sa' ska mos xa' mia'nnu chop mile, mile' xa' gan xchop mile. ");
INSERT INTO zcaNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Per mos xa' mia'nnu tu miltsai, nde'n xa' tu ye'r le'n yuo par nguluka'ch xa' dimi che'n xa' nile' mandad lo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’No dox la xche nzhai, lë'chi ñë'd xa' nile' mandad lo rë mos, orze' ngurezh xa' rë mos che'n xa' par mina'b xa' kwent lo tu ga' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Galo laka, nded xa' mia'nnu gai' mile, miza' xa' zigai' mile kwa'n mile' xa' gan, no nzhab xa': “Lë'o, go mila' gai' mile lon, per biwi' go, lë' xtimi go mile' gan xtu gai' mile dimás.” ");
INSERT INTO zcaNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Orze' nzhab xa' nile' mandad lo xa': “Lë'ska lë' kwa'n mile'l, mos wenal mbaino nzhonal di'zh. Kun che'ptsai, wen mile'l; lë'da ne kwa'n más kwa'ro ka'l. Guded lizha, no bizak laxto' kuda.” ");
INSERT INTO zcaNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Orze' nded xtu mos xa' mia'nnu chop mile, nzhab xa': “Lë'o, go mila' chop mile lon, mbaino lë' xchop mil xine re' kwa'n mile'i gan.” ");
INSERT INTO zcaNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Orze' nzhab xa' nile' mandad lo xa': “Lë'ska lë' kwa'n mile'l, mos wenal mbaino nzhonal di'zh. Kun che'ptsai, wen mile'l; lë'da ne kwa'n más kwa'ro ka'l. Guded lizha, no bizak laxto' kuda.” ");
INSERT INTO zcaNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Per or nded mos kwa'n mia'nnu tu mile, nzhab mos lo xa' nile' mandad re': “Lë'o, na nzhakbe' go, go nak tu men nina'b kwent dimás, no nilits go yalgo'n plo gat nzha'nt go, mbaino niguchao' go kwa'n gat lë' che'n go. ");
INSERT INTO zcaNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kuze', mizheb da lo go, ngulu'cha̱u̱a̱ dimi che'n go le'n yuo, per nal lë'i re'.” ");
INSERT INTO zcaNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Orze' nzhab xa' nile' mandad lo mos re': “¡Tatu nakapal mbaino jlojal! Chi lë'l nane, nak da tu men nina'b kwent dimás, no nilitsa plo gat nzha'nta, mbaino nigucha̱o̱ kwa'n gat lë' cheda, ");
INSERT INTO zcaNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","orze', ¿chon ska nangagol dimi da bank par ngale'i gan xine?” ");
INSERT INTO zcaNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Orze' nzhab xa' nile' mandad ze' lo más xa' nzhin ze': “Gulat go dub tu mil dimi ba' lo xa', no biza' goi ka' mos xa' kinu chi' mile ba', ");
INSERT INTO zcaNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","porke xa' mile' lë'tsa lë' kun kwa'n mizan nka' xa', xa' ze' zan más nayaxe ka'; per xa' mile' gat lë' kun kwa'n mizan nka' xa', ter che'ptsa kwa'n kinu xa', lë'i kubchin lo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Orze' wala' go mos xa' nazu't re' al tich lo nakao, plo nzho yalnawin no yalne, haxta kwezh lëi mos.” ");
INSERT INTO zcaNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Or yi'd Xga'n Dios, Me nu nak tu men yizhyuo, kun rë yalnazhon no kun rë ganj che'n Xuz Me, par zob Me plo nazhon, ");
INSERT INTO zcaNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","mbaino rë men yizhyuo kwin lo Me par lë' Me men che'n Me xid más rë men, nela nigo' men mbëkxi'l xid rë chib; ");
INSERT INTO zcaNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","lë' lad direch che'n Me zhin Me rë men che'n Me xa' nak nela mbëkxi'l ga', no lë' lad skierd che'n Me zhin Me rë men xa' nak nela chib ga'. ");
INSERT INTO zcaNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Orze' gab rey lo rë xa' nzhin lad direch che'n Me: “Dë' go, porke go nak xa' niwi' Xuza wen lo, par gal go rë kwa'n kinu Me par go dizde or naga yuxkwa' yizhyuo, ");
INSERT INTO zcaNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","porke or mila'n da, mine' go kwa'n nda̱u̱; no or mizei' laxto'n, mine' go kwa'n ngu'n; mbaino or ngok da nela tu men nzë zit, mine' go tu plo mia'n da; ");
INSERT INTO zcaNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","no or niyen xaba, mine' go kwa'n ngoka; no or ngokne da, mbi'dtswi' go ma da; mbaino or nguio'n lizhyi'b, mbi'dtswi' go lon.” ");
INSERT INTO zcaNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Orze' gab rë xa' mile' kwa'n nzhakla Dios: “Lë'o, ¿pok une no mila'n go, no mine' no kwa'n ndao go?, o, ¿pok une no, mizei' laxto' go, no mine' no kwa'n ngu' go?, ");
INSERT INTO zcaNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","mbaino, ¿pok une no nkizë go nela tu men zit ga' no mine' no tu plo mia'n go?, o, ¿pok mia'n go niyent xab go no mine' no kwa'n ngok go?, ");
INSERT INTO zcaNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","o, ¿pok une no ngokne go, o nguio go lizhyi'b, mbaino mbi'dtswi' no ma go?” ");
INSERT INTO zcaNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Orze' lë' rey gab: “Walika kwa'n nin, rë kwa'n mile' go por tu rë wecha, xa' chigab natsakt be's, kun na mile' goi.” ");
INSERT INTO zcaNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Orze' gab rey lo rë xa' nzhin lad skierd che'n Xa': “Chi go lon, go xa' nzhi'b de; bizë go plo ñol bël kwa'n nayot yal, kwa'n ngokxao' par Mizhab no par rë ganj che'n xa', ");
INSERT INTO zcaNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","porke or mila'n da, nangane't go kwa'n nga̱u̱; no or mizei' laxto'n, nangane't go kwa'n ngo'n; ");
INSERT INTO zcaNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","no nkizë'n nela tu men zit ga', no nangane't go tu plo ngayana; ngok jwalt xaba, no nangane't go lar ngaka; mbaino ngokne da no nguio'n lizhyi'b, nangayi'dtsi't go ma da.” ");
INSERT INTO zcaNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Orze' gab rë men ze': “Lë'o, ¿pok une no go mila'n go, o nizëi' laxto' go, o nkizë go nela tu men zit ga', u or ngok jwalt xab go, o ngokne go o nguio go lizhyi'b, mbaino ngaknut no go?” ");
INSERT INTO zcaNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Orze' lë' rey gab lo bixa': “Walika kwa'n nin, por nangaknu go ni tu rë men nzhin re', xa' nile' kwa'n nzhapa, ter chigab natsakt xa' be's, no por mile' go sa' kun lë' bixa', kuna mile' goi.” ");
INSERT INTO zcaNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Rë men re' bi plo zakzi bixa' par dubta', mbaino rë xa' mile' kwa'n nzhakla Dios, lë' bixa' ban par dubta' kun Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Or milox midi'zh Jesús kure', nzhab Me lo rë men che'n Me: ");
INSERT INTO zcaNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Lë' go nane ka, nzhak jwalt chop ngubizh par gal lani Pask, mbaino lë' men chi da, na Xga'n Dios, no nak da tu men yizhyuo, par kë' men da lo krus. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Le'n rë ngubizh ze', lo luwe che'n Caifás, xa' nak yub ngulëi' ro, ze' migan rë ngulëi', rë xa' nile' mandad xid más rë ngulëi', no kun rë xa' kwa'n nilu' ley, mbaino kun rë xa' nzo lo rë men Israel, ");
INSERT INTO zcaNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","par mia'n bixa' di'zh xmod zen bixa' Jesús xla'n par gut bixa' Me, no nu nzhab bixa': ");
INSERT INTO zcaNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","―Nale't bei dub kiyak lani, par nachëldil be men. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","No or nzo Jesús yezh Betania, ngwatao Me lizh Simón xa' nguzak tu yalyizh kwa'n lë lepra. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Or nzob Jesús lo mes, mizhin tu una' kun tu bidr ónice kwa'n dox tsak; le'ne nzho aseit kwa'n lë nardo kwa'n viv, no dox tsake, no michob una' rëtsai yek Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Or une rë men che'n Jesús kure', niyi' bixa', no nzhab bixa': —¿Chon mitsinu una' aseit ba'? ");
INSERT INTO zcaNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ngak ngado aseit nax ba' nayax dimi, orze' ngaga'z dimi ze', ngaka' rë men yent kwan nzhap. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Per or mbin Jesús kure', nzhab Me: ―¿Chon niyi' go lo una' re'? Dox tu kwa'n nazhon mile' una' por da; ");
INSERT INTO zcaNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","rë men yent kwan nzhap, zilita' yo bixa' xid go, per na gat lë't zilita' zon kun go. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kwa'n mile' una' re', or michob una' aseit nax yeka, mile' xa'i par mizuxkwa' xa' kwerp da or ga'ch da. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Walika kwa'n nin; rë plo di'zh men widi'zh nazhon che'n Dios por da, nu ska kwa'n nazhon kwa'n mile' una' re' yët, nes par rë men gon kwa'n mile' una' re'. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Orze', lë' Judas Iscariote, xa' nzho xid za tu dusen men che'n Jesús, ngwa xa' lo rë ngulëi' ro, par chi xa' Jesús lo rë xa' re', ");
INSERT INTO zcaNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","no nzhab Judas: ―¿Plak kix go kan nes chi'n Jesús lo go? Undix rë xa' re' nka' Judas, gal bichi' pes kwa'n plat, ");
INSERT INTO zcaNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","no dizde orze', mikwa'n Judas xmod, chi xa' Jesús lo rë men ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","No zhë galo laka che'n lani Pask, or nzhao men Israel pan yent levadur, orze' nguzubi rë men che'n Jesús, par nzhab bixa' lo Me, plo chao' bixa' kwa'n gao bixa' yë'l lani Pask. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Orze' nzhab Jesús: ―Wa go le'n yezh; ze' yazhë'l go tu miyi', no guzh go lo xa': “Lë' Maestr ne: Lë' or da nzhazhin la, no lizhal len lani Pask kun rë men da.” ");
INSERT INTO zcaNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","No mile' rë men che'n Me dike xmod nzhab Me; ze' michao' bixa' kwa'n gao bixa' yë'l ze', par le' bixa' lani Pask. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Or ngula yë'l, nzob Jesús lo mes kun za tu dusen men che'n Me, ");
INSERT INTO zcaNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","no dub kiyao bixa', nzhab Me: ―Walika kwa'n nin, yub tu rë go re', gak xa' chi da lo rë xa' gut da. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Orze' dox miwin laxto' bixa', nguzublo mina'bdi'zh tu ga' bixa' lo Jesús, nzhab bixa': ―Lë' go, ¿chi nai? ");
INSERT INTO zcaNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Per nkab Jesús: ―Mis tu rë xa' kwa'n nikë pan che'n le'n kwa'n nzha̱u̱ne. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Lë' Xga'n Dios Me nu nak tu men yizhyuo, lë' Me gat nela xmod nzobni' ka lo Yech che'n Dios, per, ¡zhe'b nalats nzha men chi Me! Más wen nangalt xa' ze' yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Orze' nzhab Judas, xa' kwa'n le' kure': ―Maestr, ¿chi nai? Nkab Jesús: ―Mis lu nei. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","No dub kiyao bixa', nguzen Jesús pan, miza' Me xkix lo Dios, orze' michix Mei, no miza' Mei, ka' rë men che'n Me, mbaino nzhab Me: ―Kure' nak kwerp da; guzen goi, gao go. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Orze' nguzen Me tu vas nits gub; se'ska miza' Me xkix lo Dios, no miza' Mei, ka' rë men che'n Me, nzhab Me: ―Gu' rë go kure'; ");
INSERT INTO zcaNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","kure' nak ren da kwa'n xon; por lë'i ya'n Dios di'zh lo rë men da par che' Dios rë kwa'n nzë'b xki nayax men lo Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Lë' da ni lo go, nago'tra' nits gub xtu wëlt nela xmod kiyo'ne nalre'; or go'ne xtu wëlt kun go plo nile' Dios mandad, xa'la mod gake. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Or milox mikë' bixa' tu kant che'n Salmo lo Dios, orze' nzha bixa' yek lom plo lë Olivo, ");
INSERT INTO zcaNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","orze' nzhab Jesús lo rë men che'n Me: ―Nal yë'l re', lë'u la' nzë'b da, porke se' nzobni' lo Yech che'n Dios: “Lë'da gut miyi' kwa'n nikina mbëkxi'l, no lë' rë mbëkxi'l re'chbe.” ");
INSERT INTO zcaNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Per or ruban da, lazh men Galilea kwëza yi'd go. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Orze' nzhab Per: ―Ter rë xa' re', la' nzë'b go, per nase, nalata go. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Orze' nzhab Jesús: ―Walika kwa'n nin lol, mis nal yë'l re', wëlt yon or lox gabal gat nili'be'tal da, orze' kë' tu nguid gai kant. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Per garga'l nzhab Per: ―¡Ter tutsa gat da kun go, per nalata go! No se'ska nzhab rë bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Lult ngwa bixa' tu plo lë Getsemaní, ze' nzhab Jesús lo rë men che'n Me: ―Re'ga guzob go; lë' da nzhana'b lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","No or nzhanu Me nab tsa Per, kun Jakob, mbaino Juan, orze' tuli nguzublo niyentra' jwers Me por tanta nizheb Me, no netra' Me kwan le' Me, ");
INSERT INTO zcaNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","orze' nzhab Me lo yon xa' re': ―Nazhe'b dox nizi da, nela tu men naxiat ga'; biya'n go re', naga't go; bikina go da. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Orze' nguzë Jesús xche'p dilant; ze' ngo't kuslo Me lo yuo, no mina'b Me lo Dios, nzhab Me: ―Xuza, par Lu rëi gak le'l. ¿Chi zak kubchil da lo rë kwa'n nzadkë ticha re'? Per gat lë't kwa'n nin kuze' gak, nab tsa kwa'n nzhaklale. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Orze' nguiubre Jesús plo nzhin yon men che'n Me re'; per une Me, lë' yon xa' naxnaa la. Orze' nzhab Me lo Per: ―¿Chi nguzen la mika'l go? ¿Chi naxekt go ni tu rrat win tsa, ga'na go par kina go da? ");
INSERT INTO zcaNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bikina go go no guna'b go lo Dios, par nayachin go lo che'n Mizhab. Le'n laxto' go nzhakla ka go che'n Dios, per kwerp che'n go gat nzhaklate. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Orze' ngwana'b Jesús xtu wëlt lo Xuz Me Dios, nzhab Me: ―Xuza, chi nagak ded rë kwa'n nazhe'b zaka re', gak kwa'n nzhaklal. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Or nguiubre Jesús, xtu wëlt naxnaa la rë men che'n Me, porke dox nzë mika'l lo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Orze' mila' Jesús naxnaa bixa', wëlt mion ngwana'b Me lo Xuz Me Dios, se'ga' nzhab Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Lult miëk Me plo nzhin yon men che'n Me, nzhab Me: ―¿Taxa, se' gaka naxnaa go no kile' go diskans? Biwi' go, lë' or ngol la, lë' Xga'n Dios, Me nu nak tu men yizhyuo, lë' men chi Da lo rë men nzë'b xki lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Waxche go, cha' go, ro' be re'; biwi' go, lë' xa' chi da nzë la ba'. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Se'gaka kidi'zh Jesús kure', lë'chi mizhin Judas, yub tu xa' nzho xid za tu dusen men che'n Jesús, kun tu bëd men; cho bixa' nzen spad no más bixa' nzen yarrot. Rë xa' re' nzë por mandad che'n rë ngulëi' ro no por rë xa' nzo lo rë men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","No xa' chi Jesús, nzhab xa', le' xa'i kun tu señ: “Xa' chiro'n ta' kwats, xa' ze'i, guzen go xa'.” ");
INSERT INTO zcaNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Or nguzubi xa' lo Jesús, nzhab xa': ―¡Mal maestr! Orze' michiro' xa' ta' kwats Me, ");
INSERT INTO zcaNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","no nzhab Jesús lo Judas: ―Wech, kwa'n nzël, tuli bile'i. Orze' nguzubi men, no nguzen bixa' Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","lë'chi tu rë xa' nzo kun lë' Me, ngulo' spad che'n, micho' xa' nzha tu rë mos che'n ngulëi' ro, ");
INSERT INTO zcaNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","orze' nzhab Jesús lo xa' re': ―Gulu'chao' spad che'nal, ¡bila'o unelai!, porke rë xa' nidil kun spad, kun lë'skai gat xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Chi nanetal, lë'da gak na'b lo Xuza, no tuli xë'l Me más di tu dusen mil ganj, par dil kun rë men re'? ");
INSERT INTO zcaNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Per, ¿xmod ka gak widi'zh kwa'n nzobni' lo Yech che'n Dios, se'ka naki'n gak? ");
INSERT INTO zcaNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Orze' nzhab Jesús lo men nayax ze': ―¿Chon nzë go kun spad mbaino kun yarrot? ¿Chigab tu men wa'n zen go? Zilita' nguzon lo luwe che'n yado', milun widi'zh che'n Dios lo go, no nangazent go da. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Per rë kure' nzhak par gak rë kwa'n mizobni' rë profet, rë xa' midi'zh por Dios. Orze', rë men che'n Jesús mikë' karre, mila' nzë'b bixa' Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Orze' mbi'y bixa' Jesús lo Caifás, ngulëi' ro; plo nzhin rë xa' nilu' ley, kun rë xa' nzo lo rë men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","No lë' Per zit-zit nzhakë tich Jesús, haxta mizhin xa' lo luwe che'n ngulëi' ro. Orze' nguzob Per xid rë xa' nikina yado', par kila'ch Per, nabei kwan pa' li'nu bixa' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Rë ngulëi' ro, no rë xa' nzo lo rë men Israel, mbaino rë gustis xa' más tsak, kikwa'n bixa' tu men, kë' kixu' Jesús, tu kwa'n ñal gat Me, par gut bixa' Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Per yent kwan ngane bixa' nak Jesús, ter nayax men kikë' kixu' Me. Per lult mizhin xchop xa' kwa'n nzhab: ");
INSERT INTO zcaNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","―Mbin no midi'zh xa' ba', nzhab xa': “Na chil yado' che'n Dios, mbaino chontsa ngubizh, kuxkwane xtu wëlt.” ");
INSERT INTO zcaNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Orze' nguzuli ngulëi' ro, par nzhab xa' lo Jesús: ―¿Chon gat nikabal? Biwi', kwan kine rë xa' re' nakal. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Per yent kwa'n ngakab Jesús. Orze' minabdi'zh ngulëi' ro xtu wëlt, nzhab xa': ―Por Dios, Me naban par dubta', bine lo no, chi lu ka nak Krist, Xga'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Orze' nzhab Jesús: ―Yub go ne dai. Per nin lo rë go, lë' go ne, Xga'n Dios, Me nu nak tu men yizhyuo; lë' Me zob lad direch che'n Dios, Me nile' mandad lo rëi; mbaino ne go, lë' da yal le'n tu xkao lo yibë'. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Orze' michëz ngulëi' ro xab, nela tu señ, lë' Jesús midi'zh tu kwa'n nakap par lo Dios. Orze'se nzhab xa': ―Rë go mbin, lë' xa' midi'zh tu kwa'n nakap lo Dios. ¿Kwan ra' gakla be, ne men, xtu kwa'n nak xa' re'? Rë go mbin kwa'n midi'zh xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nal, ¿kwan ne go ñal xa'? Orze' nkab rë men ze': ―Nzhap xa' dol, no ñal gat xa' por kuba'. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Orze' michuk bixa' lo Jesús, no ndin men Me; mitsao' bixa' lo Me orze' ndich men ro' Me, ");
INSERT INTO zcaNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","no nzhab bixa': ―Chi walika lu nak Krist, ¡guro' divin cho ndinal, nabei! ");
INSERT INTO zcaNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Dub kiyak rë kure', lë' Per nzob al tich, lo luwe, lë'chi nguzubi una' nak mos che'n ngulëi' ro lo Per, nzhab una': ―Nu ka lu, nikizë' kun Jesús, xa' nzë Galilea. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Per dilant lo rë nak men nzhin ze', nzhab Per lo una': ―¡Gat nuta' da! ¡Neta kwan kidi'zhal you! ");
INSERT INTO zcaNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Or nguro' Per ro' yo', une xtu kriad che'n ngulëi' ro Per, nzhab una' lo más rë men nzhin ze': ―¡Lë' nu ka xa' re', nikizë kun Jesús Nazareno! ");
INSERT INTO zcaNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Per xtu wëlt mize't Per Dios, nzhab Per: ―Lë Dios, gat nilibe'ta' xa' ba'. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Guzhëla di ze', pla rë xa' nzhin ze' nguzubi lo Per, nzhab bixa': ―¡Walika, nukal nak tu rë men che'n xa' ba', porke dox nakbe'i di xmod nidi'zhal namás! ");
INSERT INTO zcaNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Orze' xtu wëlt mize't xa' Dios, nzhab xa': ―¡Lë Dios, walika, gat nilibe'ta' xa' ba'! Lë'chi orze' mikë' nguid gai kant. ");
INSERT INTO zcaNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","No mitsila Per kwa'n nzhab Jesús: “Walika kwa'n nin lol, mis nal yë'l re', wëlt yon or lox gabal gat nili'be'tal da, orze' kë' tu nguid gai kant.” Orze' nguro' Per ze', dox nzho'n Per. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Xtu riyë'l garzi'l laka, rë ngulëi' xa' nile' mandad kun rë xa' nzo lo rë men Israel, mikwa'n bixa' mod par gut bixa' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nali'b Jesús mbi'y bixa' Me lo Pilat, xa' nak gobiernador lo rë men Roma. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, xa' mito Jesús, or une xa' nzhab rë ngulëi' xa' nile' mandad, kun rë xa' nzo lo rë men Israel, lë' Jesús gat, dox mizine xa'i. Kuze' ngwazhireska xa' dub gal bichi' pes dimi plat lo rë xa' re', ");
INSERT INTO zcaNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","no nzhab Judas lo bixa': ―Dox nzë'b xkin lo Dios, por michi'n tu men lo go por dimi, tu xa' yent kwan nzë'b par ñal gat xa'. Orze' nzhab rë xa' re': ―¡Tlë't no miki'lal! ¡Kuba' xkwentalx! ");
INSERT INTO zcaNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Or ngulubi Judas rë dimi ze' le'n yado', tuli ka ña xa', ngulo xa' do' yën xa', yub xa' mbit xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Orze' rë ngulëi' xa' nile' mandad lo más rë ngulëi', mikan bixa' dimi ze', orze' nzhab bixa': ―Dimi re' nzhi'b de la, lë'i ngox ngut men; lo ley che'n be nzobni', nagakt yo dimi gat lë' plo nzho dimi che'n yado'. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Orze' mia'n bixa' di'zh, kun dimi ze', zi' bixa' tlë' yuo plo lë, yuo che'n xa' nichao' rë kwa'n bitsi'n, par ga'ch rë men zit. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kuze' ngulolë men yuo ze', Yuo Ren, haxta zhë nalzhë, ");
INSERT INTO zcaNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","nes par ngok rë widi'zh kwa'n midi'zh profet Jeremías, tu xa' midi'zh por Dios, or nzhab xa': “Nguzen bixa' gal bichi' pes dimi plat, pres kwa'n nzhab rë men Israel tsak men Da. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Kun dimi re', nguzi' bixa' yuo che'n xa' nichao' rë kwa'n bitsi'n, nela xmod mile' ka Dios mandad da.” ");
INSERT INTO zcaNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Or michi bixa' Jesús lo Pilat, xa' nak gobiernador, nzhab Pilat lo Jesús: ―¿Chi lu nak rey che'n rë men Israel? Nkab Jesús: ―Yub go kine dai. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","No or kikë' rë xa' re' kixu' Jesús; rë ngulëi' xa' más nile' mandad, kun rë xa' nzo lo rë men Israel, yent kwan ngakab Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Lult mina'bdi'zh Pilat lo Jesús, nzhab Pilat: ―Taxa, ¿chi gat kiyontal, dox kwa'n kine rë xa' re', nakal? ");
INSERT INTO zcaNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Per yent kwan ngakab Jesús, orze' xe mia'n Pilat tuli, net xa' kwan le' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","No kad li'n or nzhal lani Pask, kinu Pilat tu kostumbr, niliya' xa' tu men nzho lizhyi'b, dike xa' gab rë men. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","No nzho tu miyi' lë Barrabás lizhyi'b, tu xa' dox nzho'b xti'zh nakap. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Or migan nayax men lo Pilat, par nabei, cho xa' liya' xa', kuze' nzhab Pilat lo rë xa' kikë' kixu' Jesús: ―¿Cho nzhakla go liyan? ¿Chi Jesús Barrabáze, o Jesús xa' lë Kriste? ");
INSERT INTO zcaNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Sa' nzhab Pilat porke ngwanu laxto' xa', lë' rë xa' nak zhi'n ze', michi Jesús por mal laxto' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Dub nzob Pilat plo nile' xa' yalgustis, mixë'l una' che'n xa' tu abis lo xa', nzhab una': “Nale'tal ni tu kwa'n kun miyi', xa' nile' kwa'n nzhakla Dios ba'; por lë' xa', dox nazhe'b micha' laxto'n na'guxin.” ");
INSERT INTO zcaNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Per lë' rë ngulëi', xa' más nile' mandad, kun rë xa' nzo lo rë men Israel, mile' bixa' gan, miki'l bixa' men, par na'b bixa' lo Pilat, liya' xa' Barrabás, no lë' Jesús, gab bixa' gat. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Orze' nzhab Pilat xtu wëlt lo rë men: ―Di lo rop xa' re', ¿cho xa' nzhakla go, liyan? Nkab rë men: ―¡Barrabáze! ");
INSERT INTO zcaNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Per nzhab Pilat: ―Bai kun Jesús, xa' nzhab go lë Krist, ¿xmod gak xa'? Orze' rë men nkab: ―¡Kë xa' lo krus! ");
INSERT INTO zcaNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Orze' nzhab Pilat: ―¿Per chon? ¿Kwan tu kwa'n gat lë' mile' xa' re'? Per xtu wëlt nguruzhië rë men: ―¡Kë xa' lo krus! ");
INSERT INTO zcaNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Or une Pilat, yentra' kwan nzhon rë men, no haxta kun Pilat, niyi' la bixa', orze' mile' Pilat mandad ñë'd nits, nde'b ya' xa' dilant lo rë men, no nzhab xa': ―Gat lë't yeka xo'b kwa'n gat miyi' ba'; kuba' xkwent go. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Orze' nkab rë men: ―¡Yek no xo'b kwa'n gat xa' ba', mbaino yek rë xmë'd no! ");
INSERT INTO zcaNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Orze'se miliya' Pilat Barrabás, no lë' Jesús, mile' xa' mandad, ngurële tich; mbaino michi xa' Jesús lo rë sondad che'n xa' par kë' bixa' Jesús lo krus. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","No mbi'y rë sondad Jesús ro' yalao kwa'n lë ‘pretorio’. Ze' migan pas xo'p gayo' sondad román naka'n lo Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Or ngulo' bixa' xab Jesús, migak bixa' Me tu lar naxne, chigab che'n tu rey ga'. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","No mizuxkwa' bixa' tu koron yich par mizob bixa'i yek Jesús, mbaino ngulo bixa' tu bar ya' Me lad direch, orze' nguzuxib bixa', kiyitnu bixa' Me, nzhab bixa': ―¡Rey che'n rë men Israel, par dubta' ban go! ");
INSERT INTO zcaNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","No michuk bixa' lo Jesús, mbaino mis bar kwa'n nzho ya' Me, mikë' bixa'i yek Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Or milox nguzhitnu bixa' Jesús, ngulo' bixa' lar naxne ze' yen Jesús, orze' migak ska bixa' Me xab Me, orze' ñanu bixa' Jesús par kë Me lo krus. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Or nzharo' bixa' ro' yezh, mizhë'l bixa' tu miyi' yezh Cirene xa' lë Simón, jwers mile' rë sondad, mbi'y xa' re' krus che'n Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Orze' ñanu bixa' Jesús plo lë Gólgota. Widi'zh re' gab, Wes Yek Men Ngut. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ze' miza' bixa' vin kwa'n noch mirra par go Jesús; per or mile' Me prebe, nangot Mei. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Orze' mikë' bixa' Me lo krus, no nguzhit bixa' di cho le' gan xab Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ze' nguzob rë sondad kikina par yent cho la Me lo krus. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","No yek krus che'n Jesús, mikë' bixa' por kwan ngut Me, no se' mizob bixa': “Xa' re' Jesus, rey che'n rë men Israel.” ");
INSERT INTO zcaNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","No nu chop wa'n mikë' bixa' lo krus orze'; tu xa' lad direch, no xtu xa' lad izkierd che'n Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","No rë xa' nided ze', maska nikwin bixa' yek bixa', kidi'zh bixa' nakap lo Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","nzhab bixa': ―¡Lu kwa'n nidi'zh, chilal yado', no chontsa ngwizh, kuxkwa'le xtu wëlt; nal, bile' nagattal! Chi lë'i walika, nakal Xga'n Dios, nal, ¡gula lo krus ba'! ");
INSERT INTO zcaNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Se'ska midi'zh rë xa' re' nakap lo Jesús: rë ngulëi' xa' nile' mandad, kun rë xa' nilu' ley, mbaino kun rë xa' nzo lo rë men Israel; nzhab bixa': ");
INSERT INTO zcaNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Nayax men miliyak xa', per kun lë' xa' yent kwan gak le' xa'. No chi lë' xa' walika nak rey lo rë men Israel, ¡nal la xa' lo krus, nes par yila be xa'! ");
INSERT INTO zcaNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nidi'zh xa', ñila xa' Dios, nal nabei chi zaknu Dios xa' chi lë' Dios wali nazhi' xa'. ¿Gat lë' xa' nidi'zh, Xga'n Dios xa'? ");
INSERT INTO zcaNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","No haxta rop wa'n, xa' nikë lo krus tu ga' lad che'n Jesús, midi'zh nakap lo Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Dizde garol ngubizh nguzublo mikao dub yizhyuo, haxta las tres zhë midi'y, ");
INSERT INTO zcaNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","no mis orze', paste las tres, naye nguruzhië Jesús, nzhab Me: ―¡Eloi, Eloi!, ¿lama sabactani? (Widi'zh re' gab: ¡Dios da! ¡Dios da!, ¿chon mila' nzë'b go da?) ");
INSERT INTO zcaNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","No pla men nzhin ze' mbin widi'zh re'; orze' nzhab bixa': ―Bingole, Li kibezh xa' re', tu xa' mixë'l Dios nzhala. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Orze' tuli ngwa tu xa' ngwagazh tlë' sponj le'n vin ni; mizob xa'i yek tu yaxtil, orze' michi xa'i ro' Jesús par ngu' Mei, ");
INSERT INTO zcaNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","per nzhab más rë men: ―Bila' go nabei, chi ziyi'd Li gaknu xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Orze' xtu wëlt nguru'zhië Jesús, mizi' la Me, ngut Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Lë'chi ngurëzla lar nikë le'n yado' plo lë santuar, plo más nazhon, chop lë' ngoke tuli, di al ya haxta al yët; no miwin xo, ngo't bech le'n rë ke; ");
INSERT INTO zcaNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","mixa'l le'n rë ba', nayax rë men che'n Dios nguruban, ");
INSERT INTO zcaNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","nguro' bixa' le'n ba', no dispwes di nguruban Jesús, nguio bixa' yezh Jerusalén, mbaino une nayax men rë xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Lë' capitán Roma kun rë sondad che'n xa', rë xa' kikina Jesús; or une bixa', lë' xo miwin kun más rë kwa'n kiyak, dox mizheb bixa', orze' nzhab bixa': ―Walika, Xga'n Dios miyi' re'. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","No nayax rë una', xa' ngoknu Jesús, dizde lazh men Galilea nza'dkë bixa' tich Me; zit nzhin bixa', kiwi' bixa' kwa'n nzhak ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Xid rë una' ze' nzo Mari Madalen, no Mari xna' Jakob mbaino xna' Che, kun xna' rë xga'n Zebedeo. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Or ngula yë'l, orze' mizhin tu miyi' rrik xa' lë Che, xa' nzë yezh Arimatea, no nu xa' men che'n Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ngwa xa' re' lo Pilat par ngwana'b xa' kwerp che'n Jesús, orze' mile' Pilat mandad, za' bixa'i, wei' Che. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Or mila Che kwerp che'n Jesús lo krus, michël xa'i tu sab nambe kwa'n lë lar lino, ");
INSERT INTO zcaNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","orze' mika'ch xa' Me le'n tu ba' kub kwa'n nade'n le'n ke; orze' mitsao' xa' ro'i kun tu ke ro, no ña xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","No Mari Madalen kun xtu Mari, nzob bixa' ro' ba' plo miga'ch Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Xtu riyë'l, or nded la zhë kwa'n nichao' rë men Israel kwa'n nzhao bixa' lani Pask; rë ngulëi' xa' nile' mandad lo más rë ngulëi', kun rë men fariseo, ngwa bixa' lo Pilat, ");
INSERT INTO zcaNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","nzhab bixa': ―Lë'o, nitsila no, miyi' xa' nikide men ze', or naga gat xa', nidi'zh xa', ngubizh yon di gat xa', lë' xa' ruban. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kuze' nal, bixë'l go pla sondad che'n go par kina ro' ba', haxta za yon ngubizh; napa' ya rë men che'n xa', yaliwa'n kwerp che'n xa', orze' di'zh rë men che'n xa', lë' xa' nguruban. No kwa'n kide xa' men re', más gat lë't gake ke or galo. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Orze' nzhab Pilat: ―Bi'y go dike rë sondad naki'n go, par kina haxta plo nzhakla go. ");
INSERT INTO zcaNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Orze' ngwa bixa' ro' ba', no mikë' bixa' sey che'n gobier lo ke kwa'n miao' ro' ba' ze', mbaino mizhin bixa' rë sondad kikina ro' ba'. ");
INSERT INTO zcaNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Or nded zhë sabd ze' xtu riyë'l, Mari Madalen kun xtu Mari, ngwatswi' bixa' ro' ba' plo miga'ch Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Lë'chi miwin tu xo ro, ngulali tu ganj che'n Dios lo yibë', nguzubi ganj re' ro' ba', no mizubchi xa' ke kwa'n nayao' ro'i, orze' nguzob xa' lo ke ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nilu' lo ganj re' nela ki che'n tu do'zi' ga', mbaino xab xa', bëo laka nela yeg ga'. ");
INSERT INTO zcaNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Or une rë sondad xa' kikina ro' ba' ze' rë ganj re', dox nizheb bixa' maska nixiz bixa' haxta ngwachin bixa', mia'n bixa' nela men ngut ga'; ");
INSERT INTO zcaNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","per nzhab ganj lo rë una' re': ―Nazhebt go, lë'da nane ka lë' go kikwa'n Jesús, Me ngut lo krus. ");
INSERT INTO zcaNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yent ra' Me re', lë' Me nguruban la, nela xmod midi'zh ka Me lo go, ter dë' go, biwi' go plo nguxo'b Me. ");
INSERT INTO zcaNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Bizë go tuli, wayab goi lo rë men che'n Me, lë' Me nguruban; no or ya go lazh men Galilea, biwi' go, lë' Me nzhubner la lo go; ze' ne go Me, kimbëz la Me zhin go; kure' nzadnin lo go. ");
INSERT INTO zcaNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Orze' ñaoxo'n rë una' ze' nzhayab bixa'i lo rë men che'n Jesús; dox nizheb bixa' per nu ska dox nizak laxto' bixa' por kure'. ");
INSERT INTO zcaNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Lë'chi, ngurulo Jesús lo biuna' nez, no nzhab Me: “¡Wen ya go!”, orze' nguzubi bixa' lo Jesús, nzhab bixa' lo Me nazhon Me, no nde'zh bixa' ni' Me, ");
INSERT INTO zcaNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","orze' nzhab Jesús: ―Nazhebt go; wayab go lo rë wecha, ya bixa' lazh men Galilea; ba' ne bixa' da. ");
INSERT INTO zcaNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Dub ña rë una' ze', lë'chi rë sondad xa' mikina ro' ba', nzha bixa' yezh Jerusalén, par ngwayab bixa' rë kwa'n ngok ro' ba', lo rë ngulëi' xa' nile' mandad lo más rë ngulëi'. ");
INSERT INTO zcaNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Orze' ngwadi'zhnu rë ngulëi' ze', rë xa' nzo lo rë men Israel, par mia'n bixa' di'zh xmod le' bixa', no ndix bixa' nayax dimi, nka' rë sondad ze', ");
INSERT INTO zcaNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","mbaino nzhab bixa': ―Sa' guzh go lo rë men: “Rë xa' nak men che'n Jesús, yë'l mbi'd bixa' or naxnaa no, miliwa'n bixa' kwerp che'n Jesús”, ");
INSERT INTO zcaNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","no chi lë' Pilat gon kure', la'u no dizhnu xa' par niyent kwan le' xa' kun go. ");
INSERT INTO zcaNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Orze' nguzen rë sondad ze' dimi, no mile' bixa' nela xmod nzhab ka rë xa' re'; no rë widi'zh kwa'n michao' yek rë men re', haxta zhë nalzhë, se'gaka nidi'zh men Israele. ");
INSERT INTO zcaNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Dub za chi' bitub men che'n Jesús, ngwa bixa' mont kwa'n ña'n lazh men Galilea, plo nzhab Jesús ya bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Or une bixa' Jesús, nzho bixa' nzhab lo Me, lë' Me nazhon, no nzho bixa' nangayilat chi lë' Mei. ");
INSERT INTO zcaNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","No nguzubi Jesús lo bixa', nzhab Me: ―Nalse na nile mandad lo yibë' no lo yizhyuo; ");
INSERT INTO zcaNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","kuze' wa go, gudi'zh go xti'zha lo rë lo ben men yizhyuo par gak bixa' men da, no bililëi' go bixa' por lë Dios Xuz go, no por lë Xga'n Me, mbaino por lë Sprit che'n Dios; ");
INSERT INTO zcaNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","no nu bilu' go lo bixa', le' bixa' rë kwa'n milen mandad lo go; no bitsila go, na nzo kun rë men da dubta', haxta or lox yizhyuo.");
INSERT INTO zcaNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Se' nguzublo widi'zh nazhon che'n Dios por Jesukrist, Me nak Xga'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Lo yech che'n profet Isaías, tu xa' midi'zh por Dios chi tiemp, se' nzhab: Biwi', nzhab Dios lo Xga'n Me, dilant lol xëla tu xa' di'zh por Lu, par kuxkwa' xa' nez dedal. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Lo yuo bizh, naye di'zh xa' re' lo rë men: “Bizuxkwa' go nez che'n Dios, nali laka bile' go nez ro che'n Me.” ");
INSERT INTO zcaNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kuze' nguio Juan le'n yuo bizh, nililëi' Juan men le'n nits, nu nzhab Juan: ―Bila' go rë kwa'n gat lë' nak go, orze' goklëi' go par lu' go, walika mila' go kwa'n nak go, nes par che' Dios rë kwa'n nzë'b xki go. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","No rë men xa' nzë lazh men Judea, kun rë men yezh Jerusalén, ngwa bixa' lo Juan, ngwaxo'bdol bixa', orze' mililëi' Juan bixa' le'n you' Jordán. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","No xab Juan nakxao' yich che'n kamey, mbaino nazi' tu yid laxto' xa'; no kwa'n nzhao xa' nak rë ma nela xanch ga' no mizhin ser. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","No se' kidi'zh Juan widi'zh che'n Dios, nzhab Juan: ―Xa' nzadkë ticha más tsak xa' lon; no ni gat ñal da, zi' xa' da nela tu mos ga'. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Na mililëi' go kun nits, per xa' nzë re' li'lëi' go kun Sprit che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Le'n rë ngubizh ze' nguro' Jesús yezh Nazaret, kwa'n ña'n lo yuo che'n men Galilea, par li'lëi' Juan Me you' Jordán, ");
INSERT INTO zcaNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","no or nguro' Jesús le'n nits, une Jesús mixa'l lo yibë', no ngula Sprit che'n Dios yek Me nela tu palom ga'. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Lë'chi nguro' tu widi'zh lo yibë' kwa'n nzhab: ―Lu Xga'na xa' nazhi' da; nizak laxto'n por Lu. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Orze' tuli mbi'y Sprit che'n Dios Jesús le'n yuo bizh. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ze' nguio Me cho' ngubizh no cho' yë'l xid rë ma nazhe'b kwa'n nzho dan; ze' plo ngokla Mizhab ngakide Jesús, no lë' rë ganj che'n Dios miza' kwa'n naki'n Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","No or nzho Juan lizhyi'b, nguiubre Jesús par lazh men Galilea, plo kidi'zh Me widi'zh nazhon che'n Dios par ne men xmod yo men plo nile' Dios mandad, ");
INSERT INTO zcaNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","nzhab Me: ―Mizhin la zhë ne men xmod gak men, men che'n Dios; kuze' bila' go rë kwa'n gat lë' nak go, no wayila go widi'zh nazhon re'. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","No tu ngubizh dub nzhaded Jesús ro' lagún kwa'n ña'n lazh men Galilea, ze' une Me rop wech xa' re', Simón no Ndres; kigubi bixa' yex le'n nits par zen bixa' mbël, porke kure' zhi'n che'n bixa', ");
INSERT INTO zcaNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","orze' nzhab Jesús: ―Di'kë go ticha, porke dizde nal, len, lë' go kan men lugar di mbël. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","No tuli nzhakë bixa' tich Jesús or mbin bixa' kure', mila' bixa' yex che'n bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","No xche'p dilant ze' une Jesús Jakob xga'n Zebedeo, no wech xa' Juan, rop xa' re' nzob le'n bark, kizuxkwa' bixa' yex che'n bixa', ");
INSERT INTO zcaNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","orze' tuli ngurezh Jesús bixa', mila' bixa' Zebedeo xuz bixa' le'n bark kun rë mos che'n xa', no lë' bixa' nzhakë tich Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Or mizhin bixa' yezh Capernaúm, zhë kwa'n nayi' kë rë men Israel zhi'n, nguio Jesús le'n yo' plo nitse'd bixa' widi'zh che'n Dios, orze' nguzublo kilu' Me widi'zh che'n Dios lo rë men nzhin ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Xe mia'n rë men ze' tuli por kwa'n kilu' Jesús, porke kidi'zh Me nela men nile' ka mandad ga', no tlë't nela rë men xa' nilu' leye. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Lë'chi ze' nzo tu miyi', nzho tu mbi mal laxto', naye nguru'zhië miyi' re', nzhab xa': ");
INSERT INTO zcaNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿Kwan nizakal kun no, Jesús kwa'n nzë Nazaret? ¿Chi nzël par lo'xal no? ¡Na nane ka cho lu, Lu nak xa' Nazhon che'n Dios! ");
INSERT INTO zcaNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Orze' nzhab Jesús: ―¡Kiex, bitsao' ro'l, no guro' laxto' miyi' re'! ");
INSERT INTO zcaNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Orze' mile' mbi mal ze' mikao miyi' re', no nguru'zhyëi naye, orze' nguro'tine. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Rë men xe mia'n por kwa'n ngok re', mbaino kidi'zh bixa': ―¿Kwan kure'? Kwa'n mile' xa' ba' nilu', lë' xa' nak tu xa' walika nile' mandad, porke, ¡haxta nu rë mbi mal nzhon ro' xa'! ");
INSERT INTO zcaNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Orze' nayen laka nguxo'b di'zh, rë kwa'n nile' Me, rë yezh kwa'n nzhin naka'n lazh men Galilea. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","No or nguro' Me le'n yo' plo nitse'd men widi'zh che'n Dios, tuli nzha Me par lizh Simón plo nak ska lizh Ndres, no Jakob kun Juan nzha kun lë' Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","No lë' xa'zha'p Simón nax kun xlë', orze' lwega' nzhab bixa'i lo Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Orze' nguzubi Jesús, nguzen Me ya' xa' una' re' par ngwaxche xa', orze' tuli nguro' xlë' xa', mbaino lë' xa' miza' kwa'n ndao rë xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","No mizhël la lyuo ngwa'z la ngubizh, rë xa' yezh ze' ngwanu rë men nzhakne, no rë xa' kwa'n nzho mbi mal laxto' lo Jesús par yak bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Rë bixa' migwa' ro' yo' plo nzo Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","orze' miliyak Jesús nayax rë xa' nizak rë lo yalyizh, no ngulo' Me mbi mal laxto' nayax men, per nangala't Jesús ngadi'zh rë mbi ze', porke nzhakbe'i cho nak Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","No xtu riyë'l, garzi'l laka, nakao ra'; nguro' Jesús par nzhadi'zh Me tu lad lo Dios plo yent cho nak. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","No Simón kun rë xa' nzo kun lë' xa', nzhakwa'n bixa' Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","no or une bixa' plo nzo Me, nzhab bixa' lo Me: ―Rë men re' kizikwa'n go. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Orze' nzhab Jesús: ―Cha'o nzha be rë yezh kwa'n ña'n gax re', par dizha widi'zh nazhon che'n Dios rë ze'; par kuze' ka nzhala re'. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Orze' nkizë Jesús rë yezh kwa'n ña'n lazh men Galilea, par ngwalu' Me widi'zh che'n Dios le'n rë yo' plo nitse'd men widi'zh che'n Dios, mbaino ngulo' Me rë mbi mal laxto' rë men. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","No ze' nguzubi tu men lo Jesús, xa' re' nizak yalyizh kwa'n lë lepra, no nguzuxib xa' re' par mina'b xa' lo Jesús, nzhab xa': ―Chi lë'o nzhaklai, gak liyak go da. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Dox milats laxto' Jesús xa' re', orze' migal Me xa', mbaino nzhab Me: ―Nzhaklan yakal; lë'l miakla. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","No tuli mitlo yalyizh ze', mimbe xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","No ngulunez Jesús xa', per dox nzhab Me lo xa': ");
INSERT INTO zcaNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Biwi', yent cho lo gable, nab tsa wa lo ngulëi' par ne xa'i, no biza' gon kwa'n nzobni' lo ley kwa'n mila' Dios lo Muisés por yalyizh che'nal kwa'n miak ba', par gon xtu mene. ");
INSERT INTO zcaNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Per miyi' re', laore nguro' xa' nez, tuli ka mixo'bdi'zh xa'i, orze' rë plo mire'che, kuze' nangaktra' ngayo Jesús rë yezh dub niwi' men. Por kuba' mia'n Me plo yent cho nak, per ni kun ter, rë plo nguro' men, nzha bixa' lo Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nded pla ngubizh, nguiubre Jesús xtu wëlt yezh Capernaúm, no mbin rë men lë' Jesús nzho la yo', ");
INSERT INTO zcaNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","orze' lwega' dox men migan ze', haxta yentra' plo kwin bixa', haxta ni ro' yo' nagaktra' kwin bixa'; mbaino midi'zh Jesús widi'zh che'n Dios lo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ze' mizhinu tap miyi' tu men nzhakne, tu xa' nagakt win. ");
INSERT INTO zcaNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","No por nagakt yo bixa' plo nzo Jesús por tanta men, kuze' nkili bixa' yek yo' par michil bixa'i par ngok mila bixa' miyi' re' nali laka plo nzo Jesús dub nax xa' lo kwa'n. ");
INSERT INTO zcaNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Or une Jesús dox ñila bixa' Me, kuze' nzhab Jesús lo xa' nagakt win re': ―Xga'na, lë' rë kwa'n nzë'b xkil mizhe' la lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Per ze' nzob pla rë xa' nilu' ley, mile' bixa' xigab: ");
INSERT INTO zcaNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Chon midi'zh xa' ba' sa'? ¡Midi'zh xa' kwa'n nayi' par lo Dios, porke yent cho men gak che' kwa'n nzë'b xki xtu men! ¡Nabtsa Dios gak le'i!” ");
INSERT INTO zcaNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","No lwega' ngwanu laxto' Jesús cho xigab kile' bixa', kuze' nzhab Jesús lo bixa': ―¿Chon kile' go xigab sa' le'n laxto' go? ");
INSERT INTO zcaNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Kwan más jwals gapa lo xa' nzhakne rë? ¿Chi gapa: “Rë kwa'n nzë'b xkil, mizhe' la lo Dios”, o gapa: “Waxche, gulits kwa'n naxal lo, no guzë”? ");
INSERT INTO zcaNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nal par ne go, na nak Xga'n Dios mbaino nak da tu men yizhyuo, no mile' Dios mandad da par che'n rë kwa'n nzë'b xki men lo Dios —kuze' nzhab Jesús lo xa' nagakt win re'―, ");
INSERT INTO zcaNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","lol nin, waxche, gulits kwa'n ngo'tal lo, bizë lizhal. ");
INSERT INTO zcaNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Orze' tuli ngwaxche miyi' re', no ngulits xa' kwa'n ngo't xa' lo, no ña xa', xe niwi' rë men nzhin ze', mbaino kidi'zh bixa': “¡Dox nazhon Dios!” No nzhab bixa': “¡Lalta' gat ne be tu kure'!” ");
INSERT INTO zcaNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Orze' nguro' Jesús par ngwa Me xtu wëlt, ro' lagún kwa'n ña'n lazh men Galilea; orze' migan tu bëd men lo Jesús, no ze' nguzublo kilu' Me widi'zh che'n Dios lo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","No or nzhaded Me ze', une Me Leví xga'n Alfeo nzob plo nzhax dimi che'n gobier Roma. Orze' nzhab Jesús lo xa': —Di'kë ticha. Lë'chi tuli nzhakë xa' tich Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Uzhëla di orze', nzob Jesús lo mes lizh Leví, kiyao Me kun nayax xa' nikan dimi che'n gobier Roma, no kun rë xa' gat nzhont ley; kiyao rë bixa' kun Jesús mbaino kun rë men che'n Me, no dox la nayax xa' nzhakë tich Jesús nzhin ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Per or une rë men nilu' ley kun rë men fariseo, lë' Jesús kiyao kun rë xa' gat nzhont ley no kun rë xa' nikan dimi che'n gobier Roma, orze' nzhab bixa' lo rë men che'n Jesús: ―¿Chon kiyao xa' nitse'd go, kun rë men gat nzhont ley che'n Dios, mbaino kun rë xa' nikan dimi che'n gobier Roma? ");
INSERT INTO zcaNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Or mbin Jesús kure', nzhab Me: ―Rë xa' wen, gat naki'nt xa' doctor; sino ke nab tsa xa' nzhakne naki'n doctor; porke nangaxë'lt Dios da lo rë men yent kwan nak lo Dios; Dios mixë'l da lo rë men xa' nzë'b xki lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","No ngol tu ngubizh nzo xlats pla rë men che'n Juan xa' nili'lëi' men le'n nits, no pla rë men fariseo, par kina'b bixa' lo Dios, kuze' ngwa pla rë xa' plo nzo Jesús, mina'bdi'zh bixa' lo Me, nzhab bixa': ―Rë men che'n Juan mbaino rë men che'n rë xa' fariseo nizo bixa' xlats bixa' or nina'b bixa' lo Dios, per rë men che'nalse, gat nizot bixa' xlats bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Orze' nzhab Jesús: ―¿Taxa plo gon go, zo men xlats men lo jwandang, dub nzo xa' disposad ze'? ");
INSERT INTO zcaNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Per or yalo jwandang or bi disposad, orze'se lë' bixa' zo xlats. ");
INSERT INTO zcaNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yent cho kë' rremiend tu bistid go'x kun tlë' lar kub, porke lë' lar kub nido'p no nichëze bistid go'x, orze' más nakap nzhake. ");
INSERT INTO zcaNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","No yent cho ko vin nax le'n tu pump go'x, porke lë'i chëz pump go'x, orze' zu't rope. Más wen ko men vin nax le'n pump kub. ");
INSERT INTO zcaNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tu ngubizh nzhaded Jesús tu plo nzhi'b triu, zhë kwa'n nayi' kë men Israel zhi'n. Orze', nguzublo rë men che'n Me kikib do che'ne, no kiyao bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","no ze' nzhin pla men fariseo, nzhab lo Jesús: ―Biwi', ¿chon kile' rë men che'nal kuba', zhë kwa'n nayi' kë men Israel zhi'n? ");
INSERT INTO zcaNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Per nzhab Jesús: ―¿Taxa, chi nagat go'l go kwa'n mile' Dabi tu wëlt, lë' xa' no rë men che'n xa', or niyent kwa'n gao bixa' no dox nila'n bixa'? ");
INSERT INTO zcaNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Orze' miye laxto' xa' nguio xa' le'n yo' che'n Dios or nak Abiatar ngulëi' ro; ndao xa' pan kwa'n nab tsa ngulëi' nzhak nzhao; no nu rë men che'n xa' miza' xa'i ndao. ");
INSERT INTO zcaNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","No nu nzhab Jesús: ―Zhë kwa'n nile' men diskans; Dios nguloi par ya men wen, no nangagot Diose par zakzi men por nile' xa' be's xigab. ");
INSERT INTO zcaNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kuze', na, Xga'n Dios, mbaino nak ska da tu men yizhyuo, no na nile' mandad zhë re'. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","No xtu wëlt nguio Jesús le'n yo' plo nitse'd men widi'zh che'n Dios; no ze' nzo tu miyi' xa' mibizh ya'. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Xe kila'ch bixa' par nabei chi lë' Jesús liyak miyi' ze' zhë re', nes par gak kë' bixa' kixu' Jesús lo rë xa' nak zhi'n. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Orze' nzhab Jesús lo miyi' xa' mibizh ya' re': ―Watso, guzo garol sao' rë. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mbaino nzhab Jesús lo rë más xa' nzhin ze': ―¿Kwan nzhab ley che'n Muisés gak le' met, zhë kwa'n nayi' kë men Israel zhi'n? ¿Chi tu kwa'n wene o tu kwa'n nakape? ¿Chi gaknu be tu men par nagat xa', o la' be gat xa'? Per yent cho ngakab, xe mia'n bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Lë'chi miëk Jesús nayi', miwi' Me lo rë men nzhin naka'n ze', mbaino miwin laxto' Me por tanta mal laxto' bixa'; orze' nzhab Me lo miyi' ze': ―Bitsiga' ya'l. No mitsiga' miyi'y, mbaino uni wene, ");
INSERT INTO zcaNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","per or nguro' rë men fariseo al tich, orze' midi'zh bixa' kun rë men che'n Herodes, par xmod gut bixa' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Orze' nguiubchi Jesús kun rë men che'n Me, par nzha Me ro' lagún kwa'n ña'n lo yuo che'n men Galilea. No nayax men Galilea, mbaino tu bëd men xa' nzë lazh men Judea, nzhakë bixa' tich Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","No nu rë xa' nzë Jerusalén, kun rë xa' nzë lazh men Idumea, kun más rë xa' nzë xtu ro' you' Jordán, no haxta rë xa' nzë naka'n plo ña'n yezh Tiro no Sidón; rë men re' miza plo nzo Jesús, par gon bixa' rë kwa'n nile' Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kuze' mile' Jesús mandad rë men che'n Me, par list yi'dnu bixa' tu bark, por tanta men, par nakotip men Me, ");
INSERT INTO zcaNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","porke dox men miliyak Jesús, kuze' rë xa' nzhakne nila' kobi bixa' Jesús par gal bixa' ta' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mbaino rë men xa' nzho mbi mal laxto' re', or une bixa' Jesús, ngo't kuslo bixa' lo Me, orze' nguruzhië bixa', nzhab bixa': “¡Lu nak Xga'n Dios!” ");
INSERT INTO zcaNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Per mile' Jesús mandad nadi'zhtra' bixa' cho nak Me lo rë men. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Orze' nkili Jesús yek tu lom, dizde ze' ngurezh Me cho xa' gak men che'n Me, orze' nguzubi bixa' lo Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Xid rë xa' ze' ngule Me tu dusen xa' kizë kun lë' Me, no par xë'l Me bixa', yadi'zh bixa' widi'zh che'n Dios lo rë men, ");
INSERT INTO zcaNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","mbaino par le' bixa' mandad, ro' rë mbi mal laxto' rë men. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","No dub tu dusen bixa' lë se': Simón, xa' nzhab Jesús lë Per; ");
INSERT INTO zcaNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","no rop wech Jakob kun Juan, xga'n Zebedeo, xa' kwa'n ngulu'lë Jesús, Boanerges (widi'zh re' gab: Xga'n nguzi'); ");
INSERT INTO zcaNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","no Ndrés, mbaino Lip, no Bartol, no Mateo, mbaino Max, no xtu Jakob xga'n Alfeo, kun Tadeo, mbaino Simón xa' nzë xid men Kananist, ");
INSERT INTO zcaNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","no nu Judas Iscariote, xa' chi Jesús lo rë men xa' gut Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Or mizhin Jesús le'n tu yo' kun rë men che'n Me, orze' dox men migan xtu wëlt plo nzo Me, no por tanta men, haxta ni nangakt ngao Me kun rë men che'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Or mbin rë melizh Jesús kure', orze' ngokla bixa' ngazen bixa' Jesús, porke mile' bixa' xigab, pas nzhak miyizh xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","No nzë pla xa' dizde Jerusalén, xa' nilu' ley kwa'n mila' Dios lo Muisés, nzhab bixa': —Lë' Beelzebú, mizhab xa' nile' mandad lo rë mbi mal, nile' nigo' miyi' re', rë mbi mal laxto' rë men. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Orze' ngurezh Jesús rë xa' nilu' ley ze', par midi'zh Me kun kwent lo bixa', nes par zobyek bixa'i, nzhab Me: ―¿Xmod ko' Mizhab, xtu tsa' mbi mal xa', laxto' men? ");
INSERT INTO zcaNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Chi tu yezh men nidil kun mis rë men che'n xa', orze' lë' bixa' lox. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","No chi dil mis men nzho tutsa yo', tu xa' kun xtu xa', lë' bixa' lox. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","No chi dil Mizhab kun mis rë mbi mal che'n xa', lë' bixa' lox; orze' yentra' kwan gak le' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","No lizh tu miyi' xa' dox nzhak nidil, nagakt yo men par li'wa'n men rë kwa'n kinu xa'. Par gak liwa'n men che'n xa', naki'n galo laka li'b xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Walika kwa'n nin lo go re': Rë kwa'n gat lë' nile' men lo Dios, no rë kwa'n gat lë' nidi'zh men por Dios; rëi che' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Per xa' nidi'zh gat lë' por Sprit che'n Dios, nayotra' zhe' che'n xa', lë' xa' nzë'b xki lo Dios par dubta'. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Kure' nzhab Jesús, porke lë' bixa' nidi'zh: “Lë' Jesús kinu mbi che'n Mizhab.” ");
INSERT INTO zcaNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Orze' mizhin xna' Jesús kun rë wech Me, al tich nzo bixa', orze' mixë'l bixa' gavis ya Jesús lo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","No dub kidi'zh Jesús lo rë xa' nzhin naka'n lo Me, lë'chi nzhab tu rë xa' ze': ―Lë'o; lë' xna' go no rë wech go, nzhin al tich; lë' bixa' kibezh go. ");
INSERT INTO zcaNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Orze' mikab Jesús: ―¿Cho xa' nak xna'n, no rë wecha? ");
INSERT INTO zcaNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Orze' miëk Me lo rë men nzhin naka'n ze', no nzhab Me: ―Rë xa' re' nak xna'n, no rë wecha, ");
INSERT INTO zcaNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","porke rë xa' nile' kwa'n nzhakla Dios; xa' ze' nak wecha, no bizana, mbaino xna'n. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Xtu wëlt nguzublo kilu' Jesús widi'zh che'n Dios lo rë men, ro' lagún kwa'n ña'n lazh men Galilea. Ze' dox men migan plo nzo Jesús, orze' nkë Me le'n tu bark par ña Me xche'p al le'n nits. Orze' nguzob Me, no lë' rë men nzhin ro' nits. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Orze' nguzublo Jesús, milu' Me nayax kwa'n lo bixa' kun pura kwent. Kuze' miza' Me kwent re', nzhab Me: ");
INSERT INTO zcaNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Bin go kure'. Nguro' tu xa' nzhaya'n lazh triu nzhache'ch xa'i. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Or ngo'n xa'i, che'pe ngob le'n nez, ngula miyin loi ndao mai. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","No xche'pe ngob lo yuo ke, no por niyen be's yuo ze', lwega' ngulene. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Per or ngulen ngubizh, migo'le; no por gat kinui be's luch, mibizhe. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","No xche'pe ngob xid ya yich; no or miro'b rë ya yich re', nangala't rë kure' ngaro'be, kuze' nangaza'te. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Per máse ngob lo yuo wen, miro'be no miaxe; orze' dox miza'i. Nzhoi miza' gal bichi' lazhe, nzhoi miza' chon gal lazhe; mbaino nzhoi miza' haxta tu gayo' lazhe. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Orze' nzhab Jesús: ―Go kinu nzha par gone, bin goi. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Or mia'n nab Jesús, rë xa' nzhin naka'n lo Me, kun za tu dusen men che'n Me xa' más nile' mandad, mina'bdi'zh bixa' lo Me, nzhab bixa': —¿Kwan gab kwent kwa'n midi'zh go ba'? ");
INSERT INTO zcaNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Orze' nzhab Jesús: ―Lo go nin rë kwa'n naga'ch che'n Dios kwa'n kinu Me plo nile' Me mandad; per lo rë xa' nzo al tich, kun pura kwent nilune lo bixa', ");
INSERT INTO zcaNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","porke, Ter une bixa'i, per yent cho xigab ngale' bixa' por lë'i; no ter mbin bixa'i, per nangazobyekt bixa'i. Kuze' nangala't bixa' rë kwa'n gat lë' nak bixa', mbaino nangache't Dios rë kwa'n nzë'b xki bixa' lo Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Orze' nzhab Jesús: ―¿Chi lë' go nangazob yekt kwent re'? Orze', ¿xmod zob yek go más kwa'n? ");
INSERT INTO zcaNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Men xa' nzha'n ze' nak xa' nidi'zh widi'zh che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","No yuo le'n nez nak xa' mbin widi'zh che'n Dios, per por nangayilat xa'i, orze' lwega' ngwa Mizhab, mizubchi widi'zh che'n Dios kwa'n nzho laxto' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","No yuo ke nak xa' mbin widi'zh che'n Dios, dub nizak laxto' xa', ");
INSERT INTO zcaNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","per por gat ña laxto' xa' kun rë che'n Dios, kuze' or nizak xa' tu kwa'n, o nidi'zh men tich xa' por widi'zh che'n Dios, orze' nila' xa' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","No yuo plo nzhi'b ya yich nak xa' nzhon widi'zh che'n Dios, ");
INSERT INTO zcaNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","per por dox nile' xa' xigab por kwa'n naki'n xa', no por niwix xa' gap xa' máse, mbaino por más rë kwa'n nizë'bla xa'; kuze' yent cho kwent nak xa' men che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Per yuo wen nak xa' nzhon widi'zh che'n Dios, no nile' xa' kwa'n nzhab Dios; no por mod niban xa', nak xa' nela yuo kwa'n miza' tu yalgo'n ro, nzhoi miza' gal bichi'y, nzhoi miza' chon gale, mbaino nzhoi miza' haxta tu gayo' lazhe. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nu nzhab Jesús: ―Yent cho tu men tsinki tu biani, orze' zob xa'i xan tu kaj o xan tu lo'n. Gat lë' xa' zobe al ya par ziniy dub le'n yo', ");
INSERT INTO zcaNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","porke rë kwa'n naga'ch nilun lo go, lë'i xo'bdi'zh go lo men. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Cho go nzhakla gon kwa'n nin, bizobyek goi. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mbaino nzhab Jesús: ―No bizobyek go kwa'n nin re': Chi lë' go gone, orze' más kwa'n gak zobyek go, ");
INSERT INTO zcaNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","porke xa' nile' kwa'n nzhapa, ngubizh kun ngubizh más kwa'n zobyek xa'; per xa' gat nile' kwa'n nzhapa, haxta rë kwa'n mbin xa' midizha, yubchi lo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Mbaino nu nzhab Jesús: ―Plo nile' Dios mandad nak nela tu miyi' kwa'n ngo'n lazh triu lo yuo che'n. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ño xa' nzha' xa' no ñaxche xa'; mbaino ngaza't xa' kwent xmod ngulene no miro'b lazh kwa'n mixë'n xa' ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Lë' yuo nile' nilene, orze' niru'xo'b lai, no niru'xo'b doi, orze' niza'i lazhe. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mbaino or ngwagale miza'i lazhe, orze' lë' men ngo'ne, lwega' nilits xa' rë kwa'n miza'i, porke ngol la tiemp yatse. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Orze' nzhab Jesús: ―¿Kun kwan tutsa nak plo nile' Dios mandad?, o, ¿kun kwan chë'l lal bei, par ne be xmod nake? ");
INSERT INTO zcaNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nake nela tu lazh mostás kwa'n mixë'n tu men lo yuo che'n, ter nake tu lazh kwa'n más kwa'n win, lo rë lazh kwa'n nzho yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Per or mixë'n xa'i, orze' miro'be, haxta ngoke tu ya más kwa'ro xid rë ya nayë' kwa'n nzhi'b ze', haxta miyin michao' yo che'n lo rë rram che'ne. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kun nayaxra' kwent milu' Jesús widi'zh che'n Dios lo rë men, par ne bixa' xmod nile' Dios kun rë men yizhyuo, haxta plo ngwazha bixa' mbin bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kun pura kwenttsa nilu' Jesús widi'zh che'n Dios lo rë men, per nab tsa lo rë men che'n Me, nzhab Me kwan nzhab kad kwent. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","No or nzhala la yë'l, nzhab Jesús lo rë men che'n Me: ―Cha' go nzha be xtu ro' nits ba'. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Orze' mia'n rë men nzhin ze', mbaino lë' rë men che'n Jesús ña bixa' le'n bark plo nzob la Jesús; no nu más rë bark che'n xtu ben men, ñakë tich Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Dub nzha bixa' le'n bark, lë'chi tu yiwbi dox nguro'; no por tanta niwin nits, haxta nguioi le'n bark no nzhaya'z yo'i le'n nits. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","No lë' Jesús naxnaa al xan bark, nako' Me lo tu almad. Lë'chi milixche bixa' Me, nzhab bixa': ―¡Maestr! ¿Chi yent kwan ña laxto'l, lë'be gat le'n nits? ");
INSERT INTO zcaNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Orze' ngwaxche Jesús, mikwë'z Me mbi, no nzhab Me lo nits: ―¡Nawintra'l! ¡Xe gulëz! Orze' tuli ngulëz mbi, no rëi mia'n xe. ");
INSERT INTO zcaNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Orze' nzhab Me lo rë men che'n Me: ―¿Chon dox nizheb go? ¿Chon naga yila go Dios? ");
INSERT INTO zcaNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Orze' dox mizheb bixa', no nzhab bixa' lo wech bixa': ―¿Cho xa' re'? ¡Haxta mbi no nits nzhon ro' xa'! ");
INSERT INTO zcaNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Or mizhin bixa' xtu ro' lagún kwa'n ña'n lazh men Gadara, ");
INSERT INTO zcaNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","laore ngula Jesús bark, tuli nguzubi tu miyi' nzhak miyizh lo Me, zilita' nzho xa' re' le'n panteón no dox nzho mbi mal laxto' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mbaino yent cho le' gan li'bdo' xa', ni kun kaden, ");
INSERT INTO zcaNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","porke nayax wëlt mili'b ni' xa' kun kaden; no rë wëlt micho' xa'i, kuze' yent cho xek lo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Zhëy-yë'le nikizë xa' le'n panteón no le'n mont, mbaino nibizhyë xa', no nikë' xa' ke ta' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Per or une miyi' re' Jesús zitra', karre nguzubi xa' no nguzuxib xa' lo Me, ");
INSERT INTO zcaNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","no naye nguru'zhië xa', nzhab xa': ―¡Yent kwan nizaka kun lu, Jesús Xga'n Dios, Me nzho lo yibë'! ¡Kina'ba lol por Dios, nazakzital da! ");
INSERT INTO zcaNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Sa' midi'zh xa' por rë mbi mal kwa'n nzho laxto' xa', porke lë' Jesús kiyab lo xa': ―¡Mbi mal, guro' laxto' miyi' re'! ");
INSERT INTO zcaNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mbaino nu mina'bdi'zh Jesús lo mbi mal ze': ―¿Xmod lël? ―nzhab Jesús. Orze' mikab mbi mal ze': ―Na lë legión, porke dox nayax no. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","No nu dox kina'b rë mbi mal re' lo Jesús, par naxë'l Me rë mbi re' xtu lazh men. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","No gax laka ze', ta' tu lom; nzhin tu bëd kuch, kiyao ma, ");
INSERT INTO zcaNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","no dox kina'b rë mbi mal ze' lo Jesús par ziyël Jesús biy laxto' rë kuch kwa'n nzhin ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Orze' nguziyël Jesús, nguro' rë mbi mal ze' par ñai laxto' rë kuch ze', pas como tu chop mil ma; lë'chi nguzublo mikë' rë bima karre yek tu lom par ngob bima haxta le'n barrank plo nzho nits; ze' ngut bima. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Or une rë xa' nikina kuch ze'i, karre ña bixa' par ngwayab bixa'i lo rë men yezh, mbaino lo rë men nzho dan. Orze', rë men ngwatswi' kwan ngok ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Or mizhin bixa' lo Jesús, une bixa' xa' ngok miyizh ze', nzob la xa' no nak la xa' lar, no menaye la nilu' xa'; no xa' re', xa' nguio mbi mal laxto'; orze' rë men mizheb. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","No rë xa' une kwa'n ngok kun xa' ngok miyizh re', mbaino kwa'n ngok kun rë kuch nzhin ze', kidi'zh bixa'i lo más rë men, ");
INSERT INTO zcaNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","orze' nguzublo dox kina'b bixa' lo Jesús, par yubchi Jesús lo yuo che'n bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Or nzhakë Jesús le'n bark par bi Me, mbaino lë' miyi' kwa'n ngok miyizh ze', dox kina'b miyi' par ngakë miyi' tich Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","per nangaziyëlt Jesús, sino ke nzhab Jesús: ―Bizë lo rë men lizhal, no guzh rë kwa'n mile' Dios por lu, no xmod milats laxto' Diosal. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Orze' ña miyi' ze', no nguzublo kiyab miyi'y lo rë men kwa'n nzho rë yezh kwa'n ña'n lazh men Decápolis, kwa'n mile' Jesús por lë' xa'. No rë men niwi' lo miyi' re', xe mia'n bixa' tuli. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Or nguiubre Jesús kun bark xtu wëlt, al xtu ro' nits, ze' migan tu bëd men naka'n lo Jesús, ro' nits plo ngula Me bark ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ze' mizhin tu xa' lë Jairo, xa' nile' mandad le'n yo' plo nitse'd men widi'zh che'n Dios. Or une xa' Jesús, tuli nguzuxib xa' lo Me, ");
INSERT INTO zcaNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","mbaino dox nalats midi'zh xa' or kina'b xa' lo Jesús, nzhab xa': ―Lë' xcha'pa naxiat la; cha'o par xo'b go ya' go yek xcha'pa, par yak xcha'pa no par ban una'. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Orze' nguziyël Jesús nzha bixa', no nu tu bëd men nzhakë, haxta kiche'p guchin bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","No xid rë men re', nzho tu una' nzhakne, nizak xa' kwa'n, nzhala tu dusen li'n. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","No dox la nguzakzi xa' por kwa'n mile' nayax doctor kun lë' xa', no ni kon ter milo'x xa' rë kwa'n kinu xa'; per yent kwa'n ngazu'i, lë'la más mixo' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Or mbin xa', rë kwa'n nile' Jesús, orze' nguzubi xa' al tich Jesús, xid rë men ze', par migal xa' xab Me, ");
INSERT INTO zcaNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","porke mile' xa' xigab: “Namás gala xab xa' re', lë'da yak ka.” ");
INSERT INTO zcaNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","No tuli ngulëz kwa'n nizak una' no mize'n una' lë' una' miak la. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Per lwega', mizi Jesús, lë' yalnazhon kwa'n kinu Me, miliyak tu men. Orze' miëk Me lo rë men, nzhab Me: —¿Cho migal xaba? ");
INSERT INTO zcaNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Orze' nzhab rë men che'n Me: ―Lë' go nane ka, dox men kiche'p go rë lad, no kinabdi'zh go, ¿cho migal go? ");
INSERT INTO zcaNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Per Jesús xe kiwi' Me naka'n, par ne Me, cho men migal ta' Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Orze' dox nizheb una' haxta nizhiz una', no por mizi una' lë' una' miak, orze' nguzubi una' no nguzuxib una' lo Jesús, mbaino mixë'lro' una' rëi. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Orze' nzhab Jesús: ―Xcha'p, por ngwayilal da, miakal. Bizë, nale'tra'l xigab. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Stubi kidi'zh Jesús kun lë' una' re', lë'chi mizhin pla xa' nguro' lizh Jairo, nzhab xa' lo Jairo: ―Lë' xcha'pal ngut la; bila' nalicha'btra'l Maestr. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Or mbin Jesús widi'zh re', lwega' nzhab Me lo Jairo: ―Nazhebtal, wayila da namás. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","No nangaziyëltra' Jesús nga más men lizh Jairo; nab tsa Per, no Jakob, mbaino Juan wech Jakob nzha kun lë' Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Or mizhin bixa' lizh Jairo, une Jesús dox nazhe'b kile' men, kibizhië bixa', kiyo'n bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Or nguio Jesús, nzhab Me: ―¿Chon dox nazhe'b kile' go, kiyo'n go? Lë' mizhwin re', gat lë'ta' ngut mizhwin; ka naxnaa mizhwin. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Orze' mixizhnu men Jesús, per Jesús mile' nguro' rë men, orze' mbi'y Me nab tsa rop xa' nak xine re', no kun yon men che'n Jesús, nguio bixa' plo nax mizhwin ngut re'. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Orze' nguzen Jesús ya' mizhwin, no nzhab Me: ―¡Talita kumi! (Widi'zh rë gab: Mizhwin, lë'da kini lol: “¡Waxche!”) ");
INSERT INTO zcaNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Orze' tuli ngwaxche mizhwin kwa'n nzhap tu dusen li'n re', no nguzublo nguzë mizhwin, no rë men une kure', xe mia'n bixa' tuli. ");
INSERT INTO zcaNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Orze' mile' Jesús mandad, yent cho lo gab bixa' kure'; no nzhab Me, za' bixa' kwa'n gao mizhwin re'. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Orze' nguro' Jesús ze' par ngwa Me yezh Nazaret plo mixen Me, no rë men che'n Me nzhakë tich Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Or ngol zhë kwa'n nayi' kë men Israel zhi'n, orze' ngwalu' Jesús widi'zh che'n Dios le'n yo' plo nitse'd bixa' widi'zh che'n Dios. No rë xa' mbin kwa'n midi'zh Me, xe mia'n bixa' tuli por xmod nilu' Jesús widi'zh che'n Dios, orze' nzhab bixa' lo wech bixa': ―¿Plo ngwatse'd xa' re', dox kwa'n nzhak xa'? ¿Plo ngwatse'd xa' rë kwa'n nzhak xa' re', no rë kwa'n nazhon nile' xa'? ");
INSERT INTO zcaNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Per chi gat lë't xa' re' karpinter, xga'n Mari; no wech Jakob, no Che, no Judas, mbaino Simón? No, ¿chi gat lë't rë bizan xa' re', nzo kun be? Kuze', nangayilat bixa' Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Orze' nzhab Jesús: ―Rë plo ñila men tu profet, xa' nidi'zh por Dios. Nabtsa rë men lazh xa', no rë melizh xa', mbaino rë xa' nzhin kun lë' xa' gat ñilat xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nangakt ngale' Jesús nayax zhi'n nazhon lazh Me. Nabtsa pla men nzhakne miliyak Me or mixo'b Me ya' Me yek bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","No xe mia'n Jesús por tanta nad rë men lazh Me, par yila bixa' Jesús. No nkizë Jesús naka'n rë yezh win kwa'n nzhin ze', par milu' Me widi'zh che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Orze' ngurezh Me dub tu dusen men che'n Me, par mixë'l Me bixa' kad yezh, chop ga bixa'; no miza' Me yalnazhon ka' bixa' par ko' bixa' mbi mal laxto' rë men. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","orze' mile' Me mandad, yent kwa'n wei' bixa' nez; nab tsa tu bordón; no ni nawei' bixa' kwa'n gao bixa', no ni tu bols, no ni dimi; ");
INSERT INTO zcaNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","no ni nawei' bixa' xtu nez yalyid, no ni xtu nez lar. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","No nzhab Me: ―Wanei plo zhin go lizh tu men, biya'n go ze' haxta or ya go xtu yezh. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","No wanei cho yezh plo naziyël bixa' gon bixa' kwa'n gab go; or ro' go ze', kwib go yuo xan xkalyid go, nela tu señ ga', ke lë' bixa' nzë'b xki lo Dios. (Kuze' walika kwa'n nin lo go, más zakzi rë men ze' lo rë men yezh Sodoma kun yezh Gomorra, or gab Dios xmod gak kun kad men yizhyuo.) ");
INSERT INTO zcaNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Orze' nguro' bixa' par nzhadi'zh bixa' widi'zh che'n Dios lo rë men Israel, par la' rë men ze' rë kwa'n gat lë' nile' bixa' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Orze' ngulo' bixa' nayax mbi mal laxto' rë men, mbaino nayax men nzhakne mitsa' bixa' aseit, par miak rë men ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","No mbin rey Herodes rë kwa'n nile' Jesús no rë kwa'n nile' rë men che'n Me, porke rë plo nguxo'b di'zhe, kuze' nguio men nzhab: —Pas Juan xa' nili'lëi' men le'n nits, nguruban, no nzhaknu Dios xa' par nile' xa' rë kwa'n nazhon ba'. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","No zipla men nzhab: —Li xa' ba'. Mbaino zipla men nzhab: —Xa' ba' xa' nak xtu xa' nidi'zh por Dios, xa' nguio nzhala. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","No or mbin Herodes kwa'n nidi'zh men, orze' nzhab xa': ―¡Juan xa' ba'! ¡Na mile mandad miro'g yek xa', no nal nguruban xa'! ");
INSERT INTO zcaNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Se' midi'zh Herodes, porke mis lë' xa' mile' mandad ngwaga' Juan par mili'b xa' Juan kun kaden, no ngulo xa' Juan lizhyi'b, por ro' Herodías, una' che'n wech xa' Lip, por ngok jwandang che'n Herodes kun lë' una', ");
INSERT INTO zcaNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","porke nzhab Juan lo Herodes: “Gat ñalt, banal kun una' che'n wechal”, ");
INSERT INTO zcaNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","kuze' xian re' kinu Herodías kun Juan, orze' mikwa'n una' mod par gat Juan, per nangakta' ngut una' Juan, ");
INSERT INTO zcaNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","porke Herodes nizheb nine Juan, porke nane Herodes dox wen rë kwa'n nile' Juan, mbaino nab tsa par Dios naban Juan. Kuze' nikina xa' Juan par niyent kwan zak Juan. No or mbin Herodes rë kwa'n nidi'zh Juan, orze' net xa' kwan le' xa', mbaino mizheb xa', per ño laxto' xa' nzhon xa' kwa'n nidi'zh Juan. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Per ngol tu ngubizh, ngwazhël Herodías xmod gut xa' Juan. Or ngol lani che'n Herodes, miza' Herodes kwa'n gao rë men che'n xa', xa' nile' mandad, mbaino rë xa' nile' mandad lo rë sondad, no rë xa' más tsak yezh Galilea. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","No plo kiyao rë xa' re', nguio xcha'p Herodías no kiyolni' una'. Orze' nguio laxto' Herodes kure', no rë xa' kwa'n nzob lo mes kun lë' xa', orze' nzhab Herodes lo una': —Bina'b kwa'n nzhaklal lon, na nei. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","No haxta mize't Herodes Dios, za' xa' wanei kwan na'b una', mbaino haxta za' xa' garol rë kwa'n kinu xa' par lë' una'. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Orze' nguro' una', nzhab una' lo xna' una': ―¿Kwan na'ba? Orze' nzhab xa': ―Yek Juan xa' nililëi' men le'n nits nguna'b. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Orze' lwega' ña ska una' plo nzob Herodes par nzhab una' kure': ―Nzhaklan nal re' tuli, ne' go yek Juan xa' nili'lëi' men le'n nits kan; le'n tu che'. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Orze' dox miwin laxto' Herodes por Juan, per lë' xa' nzhablai lo Dios, no lo rë xa' ngurezh xa', kuze' nangakt ngab xa': “Gakte.” ");
INSERT INTO zcaNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Orze' lwega' mile' rey Herodes mandad par nzha tu sondad che'n xa', nzhacho' yek Juan le'n lizhyi'b, ");
INSERT INTO zcaNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","mbaino ñadnu xa' yek Juan le'n tu chë', miza' xa'i ka' una', no lë' una' miza'i nka' xna' una'. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Or mbin rë men che'n Juan kure', ngwaka' bixa' kwerp che'n Juan par mika'ch bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Orze' ñë'd rë apost, men che'n Jesús xa' más nile' mandad, migan bixa' lo Me, no midi'zh bixa' rë kwa'n nazhon kwa'n mile' bixa', no rë kwa'n milu' bixa', ");
INSERT INTO zcaNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","orze' nzhab Me lo rë men che'n Me: ―Guro' go xid rë men ba'; cha' go nzha be plo yent cho nak, par le' go diskans che'p. Porke dox men nzhin lo bixa', cho ña la, no cho laore nzë; kuze' ni nangak ngao bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Orze' ña Me kun rë men che'n Me le'n tu bark, plo yent cho nak. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Per nayax men une nzha Jesús kun rë men che'n Me, no ngwanu laxto' bixa' plo nzha Jesús. Orze', rë bixa' nzha ni' plo nzha Jesús, no galo bixa' mizhin plo zhin Me kun rë men che'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Or ngula Jesús bark, une Me dox nayax men nzhin la, orze' milats laxto' Me rë men ze', porke nzhin bixa' chigab nela rë mbëkxi'l kwa'n yent cho nikina ga'. Orze' nguzublo milu' Jesús nayax kwa'n lo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","No nzhazhëlalyuo, orze' nguzubi rë men che'n Me, nzhab: ―Yent kwa'n nak dan re', no cho or la nal. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Más ñal guzh go lo rë men ba', bi bixa' lo rë xa' nzho dan mbaino lo rë xa' nzho yezh win, par yazi' bixa' kwa'n gao bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Orze' nzhab Jesús: ―¡Biza' go kwa'n gao bixa'! Orze' nzhab rë men che'n Me: ―¿Taxa nzhakla go yazi' no kwa'n gao bixa', kun dimi kwa'n nile' men gan chop gayo' ngubizh zhi'n? ");
INSERT INTO zcaNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Orze' nzhab Jesús: ―Biwi' go pla pan kinu go. No or milab bixa'i, orze' nzhab bixa': ―Kinu no ga'ytsa pan, no chop mbël. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Orze' mile' Me mandad, nguzhin tu montón ga' bixa', lo gozh nayë'. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","No nguzhin montón bixa', por gayo' bixa', no por cho' bichi' ga' bixa', por montón. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Orze' nguzen Me za gai' pan ze' no rop mbël ze', no or miwi' Me lo yibë', no miza' Me xkix lo Dios, orze' michi'x Mei, no miza' Mei ka' rë men che'n Me, par ki'z rë men che'n Mei gao rë men ze'. No se'ga' mile' Me kun rop mbël ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","No rë men ndao haxta plo une ndao bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","No mikan bixa' rë bilao kwa'n mia'n sobr ndao rë men ze'; michizhë bixa' tu dusen kardor. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","No rë men ndao re', nab tsa rë xa' miyi', como gai' mil bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","No lwega' mile' Jesús mandad, nkë rë men che'n Me le'n bark, par ñaner ga' bixa' xtu ro' nits plo lë Betsaida; no lë' Me mia'n tras par miwi' Me xmod ña rë men ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","No or milox ña rë men ze', orze' nzha Jesús le'n mont par nzhana'b Me lo Xuz Me Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","No or ngula yë'l, lë' bark nzha la garol sao' nits, no lë' Jesús nzo gak ka lo yuo. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","No une Me rë men che'n Me, dox vid kitsë' bixa' bark kun ya' bixa', porke nzo dox mbi no kichë'l-lo bixa' mbi. No paste las tres or garzi'l, nzhazë Me lo nits plo nzhazë bixa'. No ngokla Jesús, ngazhubner lo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Per or une bixa', lë' Jesús nzhazë lo nits, mile' bixa' xigab: “¡Paste tu komale!”, kuze' haxta nguruzhië bixa', ");
INSERT INTO zcaNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","porke rë bixa' une Jesús, dox mizheb bixa', per lwega' midi'zh Jesús lo bixa', nzhab Me: ―¡Nazhebt go! ¡Ka nai! ");
INSERT INTO zcaNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Orze' nkë Jesús le'n bark, no ngulëz mbi. Orze' rë bixa' xe mia'n tuli por kure'. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Se' nguzak bixa', porke nagat zobyek bixa' kwa'n mile' Jesús kun rë pan ze'; porke nayao' yek bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","No or milox nded bixa' le'n nits, orze' mizhin bixa' par lazh men Genesaret, orze' mikido' bixa' bark ro' nits. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","no or ngula bixa' bark, lwega' ngokbe' men Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","orze' rë men nzhin naka'n yezh ze', karre ñanu bixa' rë men nzhakne lo ya, plo mbin bixa' mizhin Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Rë plo ña Jesús, ter yezh ro o yezh win, o haxta rë dan plo nzho men; le'n rë nez ñanu bixa' men nzhakne, no nina'b bixa' lo Jesús ke namás la' Jesús gal bixa' xab Jesús. No rë xa' kwa'n nigale ze', ñak bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pla men fariseo kun zipla xa' nilu' ley kwa'n mila' Dios lo Muisés, nguzubi bixa' naka'n lo Jesús. Rë xa' re' nzë yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","No une bixa', pla men che'n Jesús kiyao bixa' dub be'd ya' bixa' orze' midi'zh bixa': “Gat ñalte.” ");
INSERT INTO zcaNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Se' mbi'd yek bixa', porke rë men fariseo, nela más rë men Israel xa' más delikad por ley che'n Muisés, dox nabe laxto' bixa'. Chi nazëtt xa' ya' xa', nagaot xa', par le' xa' rë kostumbr che'n rë xuz xa', xa' tiemp. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","No or ñë'd xa' di lo xbi', nagaot xa' chi nagaz xa' galo, par le' xa' kostumbr che'n bixa'; mbaino más rë kostumbr kwa'n kinu bixa', nela nizët bixa' rë vas no rë jarr, mbaino rë traxt che'n xa' kwa'n yi'b brons; no haxta lo'n kwa'n nzha' bixa' nizët bixa'.) ");
INSERT INTO zcaNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kuze' rë men fariseo kun rë xa' nilu' ley, mina'bdi'zh bixa' lo Jesús: ―¿Chon nzhao rë men che'nal dub be'd ya' bixa', gat nile't bixa' rë kostumbr che'n rë men nzhala? ");
INSERT INTO zcaNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Orze' nzhab Jesús: ―¡Mbël gox! Walika kwa'n midi'zh Dios por Isaías por go or mizobni' Isaías kure': Rë men re'; nidi'zh bixa' nazhi' bixa' da, per niyent kwan nize'n bixa' kun laxto' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yent cho kwent nidi'zh bixa' nazhon Da; porke rë kwa'n nilu' bixa' por Da, pura che'n mene. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Porke go, tu lad nila' go che'n Dios, namás par nile' go kostumbr che'n men. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","No nu nzhab Jesús: ―¡Walika natsin go par nitsinu go che'n Dios namás, par nile' go rë kostumbr che'n go!, ");
INSERT INTO zcaNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","porke se' midi'zh Muisés: “Gop kwent xuzal mbaino xna'l”, no, “Cho xa' ke xuz xa' o xna' xa', ñal gat xa' ze'.” ");
INSERT INTO zcaNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Per go nzhab: “Lë' men gak ka gab lo xuz o lo xna': Nagakt gaknun lu, porke rë kwa'n kinun, lë'i mizala par Dios.” ");
INSERT INTO zcaNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kuze' nala't go gaknu men xuz men o xna' men. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Por rë kostumbr che'n go, nile' go natsaktra' widi'zh che'n Dios, no nzho más rë kwa'n, kwa'n nile' go. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Orze' ngurezh Jesús rë men, par nzhab Me: ―Bin rë go kure', no bizobyek goi: ");
INSERT INTO zcaNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Gat lë't por kwa'n nzhao men o por kwa'n nzho men, nzhak gat nambe men lo Dios, sino por kwa'n gat lë' nzho laxto' mene. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Cho go nzob nzha, bin goi. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","No or mila' Jesús rë nak men ze', nguio Me le'n yo', orze' nzhab rë men che'n Me lo Me: ―¿Kwan gab widi'zh kwa'n milu' go ba'? ");
INSERT INTO zcaNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Orze' nzhab Me: ―¿Taxa nu go, nagakt zobyek go kure'? ¿Chi gat nanet go, yent cho tu kwa'n nzhao men, nile' ña'n gat nambet men lo Dios?, ");
INSERT INTO zcaNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","porke rë kwa'n nzhao men, gat nibite corazón che'n men, sino ke lë'i nibi laxto' men, orze' niro'skai or ña xa' bi'x. Kure' nzhab Me, par zobyek mene, ke lë' rë kwa'n nzhao men, rëi nambe. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","No nzhab Me: ―Xigab gat lë' kwa'n niro' dizde laxto' men, kure' nile', nzhak gat nambet men lo Dios, ");
INSERT INTO zcaNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","porke laxto' men niro' rë xigab gat lë' re': Rë xigab ban men kun kwaliskier xtu men, rë xigab liwa'n men che'n xtu men, no gut xa' men; ");
INSERT INTO zcaNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","mbaino rë xigab zen men una' che'n xtu men, rë xigab gap men kwa'n dimás, rë xigab dox gat lë', rë xigab kide men xtu men, rë xigab ban men kun tu men xtu men, rë xigab wix men gap men kwa'n kinu xtu men, rë widi'zh nakap nidi'zh men Dios, rë xigab marian, mbaino rë xigab kwa'n yent yek. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Rë kwa'n gat lë' re' niro' laxto' men, no por lë'i, ña'n gat nambet men lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Di ze' nguro' Jesús par nzha Me lazh men Tiro mbaino par lazh men Sidón. Orze' nguio Me le'n tu yo' par nanet men Me, per nangakt ngayuka'ch Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Lwega', mbin tu una', lë' Jesús nzho ze'; no una' re' kinu tu më'd una', nzho tu mbi mal laxto' më'd. Orze' mizhin una' lo Jesús, no ngo't kuslo una' lo Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","No una' re' tlë't men Israel xa', lë' xa' nzë yezh sirofenicia. Dox nguna'b una' lo Jesús par ko' Me mbi mal laxto' xmë'd una', ");
INSERT INTO zcaNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","orze' nzhab Jesús lo una': ―Bila' gao rë xmë'd Dios galo; porke gat ñalt, kubi men lo mbëk rë kwa'n kiyao rë xmë'd Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Orze' nzhab una': ―Walika goi Señor, per no ska ño mbëk xan mes plo nzhao rë xmë'd Dios, par gao ma rë biyo ye'n kwa'n nzhab lo yuo. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Orze' nzhab Jesús: ―Por kwa'n nel re', bizë; nale'tra'l xigab, lë' mbi mal nguro' la laxto' xmë'dal. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","No or nguiubre una' par lizh una', lë' xmë'd una' nax la lo lo'n, no lë' mbi mal nguro' la laxto' më'd. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Orze' nguro' Jesús lazh men Tiro, no nded Me lazh men Sidón mbaino lazh men Decápolis, par mizhin Me ro' lagún kwa'n ña'n lazh men Galilea. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ze' ñanu pla men tu miyi' sord, no gat nirolant kwa'n nidi'zh xa'; no kwa'n dox mina'b bixa' lo Jesús, par xo'b Me ya' Me yek miyi' re'. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Orze' ngulo' Jesús miyi' re' tu lad xid rë men, par ngulo Me bikwen ya' Me le'n nzha miyi' re', orze' michuk Me par migal Me lo luzh miyi' re' kun nzhuk che'n Me, ");
INSERT INTO zcaNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","orze' ngulits Me lo Me lo yibë', no mizi' laxto' Me, nzhab Me: ―¡Efata! (Widi'zh re' gab: “Bixa'l”). ");
INSERT INTO zcaNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","No mis orze', mixa'l nzha xa' no nguruban luzh xa', midi'zh xa' klar laka. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Orze' mila' Jesús di'zh, yent cho lo gab bixa'i; per ter mile' Jesús mandad, nadi'zht bixa'i, ngont bixa'i, más midi'zh bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Orze' dox xche mia'n kiwi' rë xa' nzhin ze' por kwa'n ngok re', orze' nzhab bixa': ―¡Rë kwa'n niliyak Jesús! Haxta rë men sord, nzhon kwa'n; mbaino rë men nagakt di'zh, nzhudi'zh xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Le'n rë ngubizh ze', migan tu bëd men xtu wëlt, no gat kinut bixa' kwa'n gao bixa'; orze' ngurezh Jesús rë men che'n Me par nzhab Me: ");
INSERT INTO zcaNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Dox nilats laxto'n rë men re', porke nzhala chon ngubizh nzhin bixa' lon, no gat kinut bixa' kwa'n gao bixa', ");
INSERT INTO zcaNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","no chi xëla bixa', bi bixa' lizh xa', sin naga gao bixa', nzho rriez gu'zh bixa' nez, porke nzho xa' nzë zit. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Orze' nzhab rë men che'n Me: ―Per, ¿xmod za' met kwa'n nayax gao rë men re', plo niyent kwan nak re'? ");
INSERT INTO zcaNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Orze' minabdi'zh Jesús pla pan kinu bixa', no nzhab bixa': ―Gazhe. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Orze' mile' Jesús mandad, zob rë men ze' lo yuo, no or nguzen Me za gazh pan, no miza' Me xkix lo Dios, orze' michix Mei no miza' Mei ka' rë men che'n Me par ki'z bixa'i gao rë men ze', no ndi'z bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","No nu pla mbël win kinu bixa'; xtu wëlt miza' Me xkix lo Dios por lë'i, no mile' Me mandad, par ndi'z bixa'i xid rë men ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Rë men ndao haxta plo une ndao bixa', no mikan bixa' rë bilao; gazh kardore. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Rë xa' ndao re', paste como tap mil bixa'. Orze' ngulunez Jesús bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","No lwega' nkë Me bark kun rë men che'n Me, par nzha bixa' lazh men Dalmanuta. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Or mizhin bixa' ze', nu pla rë men fariseo migan lo Jesús, par michë'lro' bixa', porke nzhakla bixa', le' Jesús tu kwa'n nazhon kwa'n nzë lo yibë', par zenbe' bixa' Me (wi' bixa' xmod nak Me), chi Dios ka mixë'l Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Orze' mizi' laxto' Jesús, no nzhab Me: ―¿Chon nina'b rë men re', ne xa' tu kwa'n nazhon? Per na ni, walika ni tu kwa'n nazhon nanet bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Orze' mia'n nzhin tsa rë men ze', lë' Jesús nkë bark xtu wëlt, par nzha Me al xtu ro' lagún. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","No mia'l laxto' bixa' ngazi' bixa' más pan, namás tutsa pan nzadnu bixa' le'n bark. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Orze' nzhab Jesús lo rë men che'n Me: ―Bikina go go lo rë men fariseo, mbaino lo rë men che'n Herodes, kun levadur che'n bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Orze' kidi'zh rë men che'n Me: ―Pas, por gat nzadnu be pan, gao bei. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Per ngwanu laxto' Jesús kwan kidi'zh bixa', kuze' nzhab Me: ―¿Chon dox xigab kile' go, por gat nzadnu go pan? ¿Chi nagat zobyek go kwa'n nin re'? ¿Chon stubi nayao' yek go, par ne goi? ");
INSERT INTO zcaNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¡No ter niwi' go, per gat ne goi; no nzob nzha go, per gat gon goi; mbaino nat laxto' go! ");
INSERT INTO zcaNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Or ndi'za gai' pan xid gai' mil men, ¿pla kardor rë kwa'n bilao mikan go? Orze' nzhab bixa': ―Tu dusene. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","No nzhab Jesús: ―¿No or ndi'za gazh pan xid tap mil men, pla kardor rë kwa'n bilao mikan go? Orze' mikab bixa': ―Gazhe. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Orze' nzhab Jesús: ―¿Taxa nagat zobyek goi orze'? ");
INSERT INTO zcaNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Orze' mizhin bixa' yezh Betsaida, ze' mizhinnu men tu xa' nikal lo, par nguna'b xa' gal Jesús kwerp che'n xa' nikal lo re'. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Orze' nguzen Jesús ya' miyi' re', par ñanu Jesús xa' ro' yezh; orze' michuk Jesús lo xa', no mixo'b Me ya' Me lo xa' re', orze' minabdi'zh Jesús lo xa', nzhab Me: —¿Chi nilu' la kwa'n lol? ");
INSERT INTO zcaNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Orze' ngulits xa' lo xa', no nzhab xa': —Nilu' la men lon, per nilu' bixa' nela rë ya ñazë ga'. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Orze' xtu wëlt mixo'b Me ya' Me lo miyi' re', orze' mixa'l lo xa', haxta zit nilu' kwa'n lo xa', klar laka nilu' rë men lo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Orze' mixë'l Jesús xa', ña xa' lizh xa', per nzhab Jesús: ―Ni nayubrera'l yezh plo nzhin rë men ba'. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Orze' nguro' Jesús kun rë men che'n Me, par nzha bixa' rë yezh win kwa'n ña'n lazh men Cesarea Filipo. Dub nzhazë bixa' nez, orze' minabdi'zh Jesús lo rë men che'n Me, nzhab Me: ―¿Cho da, nzhab men? ");
INSERT INTO zcaNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Orze' nzhab bixa': ―Nzho xa' nidi'zh, Lu Juan bautist; no más xa' nzhab, Lu Li; no zipla xa' nzhab, Lu nak xtu men midi'zh por Dios, xa' nzhala. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Orze' nzhab Jesús xtu wëlt: ―Par go ga'; ¿cho da? Orze' nzhab Per: ―Go nak Krist. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Orze' mile' Jesús mandad lo rë men che'n Me, yent cho lo gab bixa' cho nak Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Orze' nguzublo kilu' Jesús lo rë men che'n Me, nzhab Me: ―Na nak Xga'n Dios, no nu nak da tu men yizhyuo; por xigab che'n Dios, nayax men zakzi da. Rë xa' re' nayilat da: Rë xa' nzo lo rë men Israel, kun rë ngulëi' ro, mbaino kun rë xa' nilu' ley kwa'n mila' Dios lo Muisés. No lë' bixa' chi da lo men par gat da. Per ngubizh yon, lë'da ruban. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Rë kure' midi'zh Me klar laka, per orze' ngulo' Per Jesús tu lad, nzhab Per: ―¡Nadi'zhtra' go kuba'! ");
INSERT INTO zcaNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Orze' miëk Jesús, niwi' Me lo rë men che'n Me, orze' miyi' Me lo Per, nzhab Me: ―¡Chi lon, Mizhab!, porke gat nile'tal xigab che'n Dios; pura che'n men nzho yekal. ");
INSERT INTO zcaNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Orze' ngurezh Me rë men che'n Me, no rë men nzhin ze', par nzhab Me: ―Chi nzho tu go nzhakla yi'dkë ticha, nale't go kwa'n nzhakla go, no bi'y go krus che'n go par di'kë go ticha, ");
INSERT INTO zcaNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","porke xa' nzhakla kina vid che'n par naloxe, lë'i lox lo Dios; per xa' gat por da o por widi'zh nazhon kwa'n nilun, nayot lox xa' re' lo Dios, ");
INSERT INTO zcaNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","porke, ¿kwan zu' par tu men, le' xa' gan ter dub yizhyuo, per lo Dios lox xa'? ");
INSERT INTO zcaNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","No, ¿kwan za' tu men par naloxt xa' lo Dios?, ");
INSERT INTO zcaNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","porke cho rë men la' da, o la' xa' widi'zh nazhon da, dilant lo rë xa' mia'l laxto' widi'zh che'n Dios, rë xa' gat nzhont ro' Dios; nu ska da la bixa', or yala, kun rë yalnazhon che'n Xuza, no kun rë ganj nazhon che'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","No nu nzhab Jesús: ―Walika kwa'n nin, pla xa' nzho xid rë men re', nagatta' bixa' chi naga ne bixa', xmod zhin zhë or luxo'b yalnazhon che'n Dios par le' Me mandad. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","No nded xo'p ngubizh, nzhanu Jesús nab tsa Per, no Jakob, mbaino Juan, tu lad yek tu yi' ro. No ze' mizhë' lo Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","No xab Jesús milu' bëo laka no ñaz bële; no per ni tu men yizhyuo nale'ta' gan zët tu lar par ya'ne sa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","No ze' ngurulo Li, rop xa' kun Muisés, no kidi'zh bixa' kun Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Orze' nzhab Per: ―¡Maestr, wen dox nzo be re'! ¡Bila' go chao' no chon rranch; tube par go, xtube par Muisés, no xtube par Li! ");
INSERT INTO zcaNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Porke dox mizheb rë men che'n Jesús re', kuze' net Per kwan di'zh xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Orze' plo nzhin bixa', ngula tu xkao yek bixa', no mien tu widi'zh le'n xkao kwa'n nzhab: ―¡Xa' re' nak Xga'na xa' nazhi' da! ¡Bin go ro' Xa'! ");
INSERT INTO zcaNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Orze' lwega' miwi' bixa' naka'n, yentra' cho ngane bixa', nab tsa Jesús nzo. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Or ñadla bixa' yek yi', orze' mile' Jesús mandad, yent plo di'zh bixa' kwa'n une bixa', haxta or ruban Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Orze' ngulu'chao' bixa'i laxto' bixa', no midi'zh bixa' entre lë' bixa', ¿kwan kwa'n ruban menx? ");
INSERT INTO zcaNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Orze' minabdi'zh bixa' lo Jesús, nzhab bixa': ―¿Chon nidi'zh rë xa' nilu' ley kwa'n mila' Dios lo Muisés, galo laka Li yi'd? ");
INSERT INTO zcaNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Orze' nzhab Jesús: ―Walika, lë' Li galo yi'd, no lë' xa' le' yëk rë men lo Dios, mbaino, ¿chon nzobni' lo Yech che'n Dios, lë' Xga'n Dios Me nu nak tu men yizhyuo, kwa'n dox zakzi xa', no nayilat men xa'? ");
INSERT INTO zcaNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Per na ni lo go, lë' Li mbi'd la, no rë men mile' kwa'n ngokla bixa' kun lë' xa', nela xmod nzobni' ka lo Yech che'n Dios, kwa'n nguzak xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","No or mizhin bixa' plo nzhin más rë men che'n Me, une Jesús lë' tu bëd men nzhin la naka'n, no kichë'lro' pla rë men nilu' ley kun más rë men che'n Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","No or une rë men Jesús, xe mia'n bixa', orze' karre nguzubi bixa' par uni' bixa' lo Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","orze' nzhab Jesús: ―¿Kwan kichë'lro' go kun rë xa' ba'? ");
INSERT INTO zcaNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Orze' nzhab tu xa' xid rë men ze': ―Maestr, lë'da nzëdnu xmë'da lol, porke nzho tu mbi mal laxto' më'd, kwa'n nile' nagakta' di'zh më'd, ");
INSERT INTO zcaNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","porke rë or nizen mbi re' më'd, haxta niyixkaowe më'd no nigubiy më'd; orze' ñax bichi'n ro' më'd no nidao'lëi më'd, orze' niyezh më'd; no mina'bla da lo rë men che'nal par ngago' bixa' mbi mal re', per nangakta' ngale' bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Orze' mikab Me, no nzhab Me: ―¡Men xa' gat ñilat Dios! ¿Haxta pok zon kun go par yila go Dios? ¿Haxta pok xek da lo go? ¡Dinu xmë'dalx! ");
INSERT INTO zcaNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Orze' mbi'y bixa' mbwin lo Jesús; per or une mbi mal Jesús, orze' mile'i lwega' mikao mbwin, no ngwachin mbwin lo yuo, orze' maska ñaxyo mbwin, no ñax bichi'n ro' mbwin. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Orze' mina'bdi'zh Jesús lo xuz mbwin: ―¿Plak nzha di nizak mbwin kure'? Orze' nkab xuz mbwin: ―Dizde win mbwine. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","No nayax wëlt nigobiy mbwin lo bël no le'n nits, par nzhaklai gute mbwin; per chi zak le'l tu kwa'n, bilats laxto' go no, no goknu go no. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Orze' nzhab Jesús: ―¿Chon nel: “Chi zak le'le”?, porke xa' ñila Dios, ¡rëi gak le' xa'! ");
INSERT INTO zcaNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Orze' lwega' nguruzhië xuz mbwin, nzhab xa': ―¡Na ñilaka lu; no goknu da, kwa'n nagak yilan! ");
INSERT INTO zcaNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","No une Jesús, tu bëd men nzhazubi karre plo nzo Jesús, orze' nayi' midi'zh Jesús lo mbi mal ze', nzhab Me: ―¡Mbi che'n Mizhab kwa'n nile' nzhak sord men no nagakta' di'zh men, na kile' mandadal, gurutin laxto' mbwin re', no nayëktra'l xtu wëlt lo mbwin! ");
INSERT INTO zcaNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Orze' nguru'zhië mbi mal ze', no mile'i mikao mbwin xtu wëlt, no nguzhibe mbwin dox naye, orze' nguro'i; no lë' mbwin mia'n nela tu men ngut ga', haxta rë men nzhin ze' nzhab: “Ngut mbwin.” ");
INSERT INTO zcaNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Per Jesús nguzen ya' mbwin, ngoknu Me nguzuli mbwin. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Or nguio Jesús le'n tu yo', orze' minabdi'zh rë men che'n Me lo nab Me, nzhab bixa': ―¿Chon nangakt ngago' no mbi mal ba', laxto' mbwin ba'? ");
INSERT INTO zcaNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nkab Jesús: ―Rë lo mbi mal kwa'n nak sa', nagakt ro'i chi nana'b men xche lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Or nguro' bixa' ze', nded bixa' par lazh men Galilea; no nanet Jesús, gon rë men plo nzha Me, ");
INSERT INTO zcaNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","porke lë' Me kilu' lo rë men che'n Me kwan zak Me, kuze' nzhab Me: ―Lë'da nak Xga'n Dios no nak da tu men yizhyuo; no lë' rë men zen da par chi bixa' da plo gat da; per ngubizh yon, lë'da ruban. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Per lë' rë men che'n Me, nangazobyekt bixa' widi'zh re', no nizheb bixa' nganabdi'zh bixa' kwane. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Or mizhin bixa' yezh Capernaúm, no or nzhin la bixa' le'n yo', nzhab Me lo rë men che'n Me: ―¿Kwan kichë'l ro' go, or nzë be nez? ");
INSERT INTO zcaNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Per yent cho ngakab; porke or nzë bixa' nez, mis lë' bixa' kichë'l ro', kidi'zh bixa', nabei cho gak xa' le' mandad xid bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Orze' nguzob Jesús, no ngurezh Me dub tu dusen men che'n Me, orze' nzhab Me: ―Cho go nzhakla, gak xa' nile' mandad; xa' ze' gak xa' lult, no nela tu mos ga' gak xa' xid go. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Orze' mizo Me tu më'd lo bixa', no nde'zh Me më'd, nzhab Me: ");
INSERT INTO zcaNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Men niwi' wen lo më'd win re' por nak më'd re' men da, gat lë'ta' lo më'de, sino ke lon miwi' xa' wen; mbaino xa' miwi' wen lon, gat lë'ta' lone, sino ke lo Xuza Me mixë'l da, miwi' xa' wen. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Orze' nzhab Juan: ―Maestr, une no tu xa' kigo' mbi mal, kize't xa' lë go. Orze' nzhab no lo xa', nale'tra' xa'i, porke gat lë't men che'n be xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Orze' nzhab Jesús: ―Bila' go kile' xa'i, porke yent cho tu xa' le' tu zhi'n nazhon por lën, no guzhëla di orze', di'zh xa' gat lë' ticha, ");
INSERT INTO zcaNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","porke xa' gat niyi' nine be, man che'n be ño xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","No kwaliskier men ne' che'p nits go go, por nak go men da, walika nin, por kuze' lë' Dios za' tu kwa'n wen ka' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","No nu nzhab Jesús: ―Wanei cho tu xa' le', ya'l laxto' xtu xa' Dios, tu xa' laore ngwayila da; más wen ya xa' le'n nitsdo', xo'b tu ke ro yën xa', nes yachin xa' par gat xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","No chi lë' ya'l nile' nizë'b xkil lo Dios; mejor bicho'i. Más wen gat kinutal rop ya'l, per banal dubta' kun Dios, ke par bil le'n bël, rop lad ya'l, plo ñol bël par dubta', ");
INSERT INTO zcaNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","plo nzhao miyëz men, no gat ñot nzhat ma; ni bël gat ñalt. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","No chi lë' ni'l nile' nizë'b xkil lo Dios, más wen bicho'i. Más wen banal dubta' kun Dios kun tutsa ni'l, ke par bil plo gat ñalt bël, kun rop lad ni'l, ");
INSERT INTO zcaNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","plo nzhao miyëz men, no gat ñot nzhat ma; ni bël gat ñalt. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","No chi lë' zalol nile' nizë'b xkil lo Dios; más wen gulo'i, mbaino yol plo nile' Dios mandad kun tutsa zalol, ke par bil kun rop zalol plo ñol bël par dubta', ");
INSERT INTO zcaNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","plo nzhao miyëz men, no gat ñot nzhat ma; ni bël gat ñalt, ");
INSERT INTO zcaNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","porke lë' Dios xë'l bël xid rë men, nela nigo men zed lo kwa'n gao men ga'. ");
INSERT INTO zcaNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Lë' zed nizu'; per chi gat nazhi'y, yentra' kwan zu'i. Gok wen go nela zed ga', par kwin go wen, tu go kun xtu go. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Orze' nguro' Jesús yezh Capernaúm, nzha Me lazh men Judea, xtu ro' you' Jordán. No ze', xtu wëlt, migan tu bëd men lo Jesús, no nguzublo Jesús, milu' Me widi'zh che'n Dios lo bixa' xtu wëlt, nela xmod nile' ka Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Orze' nguzubi pla men fariseo minabdi'zh bixa' lo Jesús par zenbe' bixa' Me (wi' bixa' xmod nak Me), nzhab bixa': ―¿Chi zak lë' tu miyi' kun tsa' xa', lo ley kwa'n mila' Dios lo Muisés? ");
INSERT INTO zcaNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Orze' nzhab Jesús: ―¿Kwan mizobni' Muisés lo ley por kuba'? ");
INSERT INTO zcaNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Orze' nzhab bixa': ―Lë' Muisés mizobni'; chi tu miyi' lë' kun tsa', orze' gakxao' tu yech par yanu una', par gak la' miyi' una'. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Per nzhab Jesús: ―Sa' mizobni' Muisés por dox nakap go, ");
INSERT INTO zcaNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","per dizde or mizuxkwa' Dios yizhyuo, se' nzobni': “Dios ngulo miyi' no una'.” ");
INSERT INTO zcaNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","No nu nzobni': “Por una', lë' miyi' la' xuz no xna', ");
INSERT INTO zcaNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","par ban xa' tutsa kun tsa' xa'.” No nu nzhab Jesús: ―No gat lë'tra' chop xa', lë' xa' ngok tutsa men. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kuze', miyi' xa' mizo Dios tsa', nagaktra' lë' xa' kun tsa' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","No or ña la rë bixa' le'n yo', orze' mina'bdi'zh rë men che'n Jesús por kwa'n midi'zh Me re', ");
INSERT INTO zcaNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","orze' nzhab Me: ―Wanei cho la' nzë'b una' che'n, no ban xa' kun xtu una', nzë'b xki xa' lo Dios por kure'. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","No chi lë' una' la' tsa', no ban xa' kun xtu miyi', nzë'b xki ska xa' lo Dios por kure'. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Orze' nzhanu men pla më'd lo Jesús, par na'b Me lo Dios por lë' bimë'd; orze' ngala't rë men che'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Per or une Jesús kure', miyi' Me, orze' nzhab Me: ―Bila' go zubi më'd lon, naka'nt go lo bimë'd, porke rë men nak nela rë më'd, xa' ze' yo plo nile' Dios mandad. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","No walika kwa'n nin, xa' nagak nela tu më'd ga', nagakt yo xa' plo nile' Dios mandad. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Orze' nde'zh Me rë më'd, no mixo'b Me ya' Me yek bimë'd, par miza' Me yalnazhon che'n Me ka' bimë'd. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Or mer nzharo' Jesús nez par nzha Me xtu plo, karre mizhin tu miyi' xi, nguzuxib lo Jesús, mbaino minabdi'zh miyi' re': ―Maestr wen, ¿kwan naki'n len par gapa yalnaban dubta' lo Dios? ―nzhab miyi'. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Orze' nzhab Jesús: ―¿Chon nel, wen da? Yent cho wen, nab tsa Dios wen. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Lu nane la rë ley che'n Dios: “Nagutal men, nabantal kun una' che'n men, no naliwa'ntal, nakë'tal kixu' men, no nakidetal men par ka'l che'n xa'; mbaino gop kwent xuzal mbaino xna'l.” ");
INSERT INTO zcaNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Orze' nzhab miyi' xi re': ―Maestr, rë kure' kilen, dizde win da. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Orze' miwi' Jesús lo miyi', michizhi' Me miyi', mbaino nzhab Me: ―Xtutsa kwa'n jwalt le'l: Bito rë nak kwa'n kinul, orze' biza'i, ka' rë men xa' yent kwan nzhap, nes par gapal rë kwa'n dox tsak lo yibë'; orze' di'kë ticha. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Or mbin miyi' re' kure', xe mia'n xa' tuli di miwin laxto' xa', orze' dox nalats ña xa', porke dox kwa'n nzhap xa', ");
INSERT INTO zcaNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","mbaino miwi' Jesús naka'n lo rë men che'n Me; no nzhab Me: ―¡Tatu nagan yo tu rrik plo nile' Dios mandad! ");
INSERT INTO zcaNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Or mbin bixa' widi'zh re', xe mia'n rë men che'n Me tuli, no nzhab Jesús xtu wëlt: ―Bin goi xga'n, ¡tatu nagan yo tu rrik plo nile' Dios mandad! ");
INSERT INTO zcaNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Más jwals ded tu kamey xan tu yaguj, ke par yo tu rrik plo nile' Dios mandad. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Or mbin bixa' kure', más mia'n xe bixa', orze' nzhab bixa' lo wech bixa': ―Chi lë'i sa', ¡pas yent cho men gak ro' lo rë kwa'n nazhe'b kwa'n nzëdkë tich men! ―nzhab bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Orze' xe miwi' Jesús lo bixa', no nzhab Me: ―Par rë men, nzho kwa'n nagakt le' men; per Dios, yent cho tu kwa'n nagak le' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Orze' nguzublo nzhab Per: ―Biwi' go, no mila' rë kwa'n, par nzadkë no tich go. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nkab Jesús: ―Walika kwa'n nin lo go, rë xa' la' lizh, o wech xa', o bizan xa', o xuz xa' o xna' xa', o xmë'd xa', o yuo che'n xa', por ñila xa' da; ");
INSERT INTO zcaNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","per rë kwa'n mila' xa', xtu gayo' wëlt máse gap xa' mis yizhyuo re'; mbaino nu yi' men ne men xa' por da; no xtu yizhyuo kwa'n laore yi'd, lë' xa' ban par dubta'. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Per nayax xa' galo nal re', gak xa' lult laka; no xa' lult laka nal re', gak xa' galo laka. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Or nzha Jesús nez kun rë men che'n Me par yezh Jerusalén, nzhubner Me lo bixa'; orze' xe mia'n rë men che'n Me niwi' bixa' lo Me; mbaino nu rë men se'ga, dub nizheb bixa' nzadkë bixa' tich rë men che'n Me. Orze' ngurezh Jesús za tu dusen men che'n Me tu lad, nguzublo kidi'zh Me lo bixa' kwan zak Me, ");
INSERT INTO zcaNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","nzhab Me: ―Biwi'u, lë' be nzha yezh Jerusalén plo zen bixa' da, par chi bixa' da lo rë ngulëi' ro, no lo rë xa' nilu' ley; no lë' rë xa' re' gab, ñal gat da; orze' chi bixa' da lo rë men gat lë't men Israel par gut rë men re' da, ");
INSERT INTO zcaNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","mbaino xizhnu bixa' da, chuk bixa' lon, no kin bixa' da; orze' gut bixa' da, per ngubizh yon, lë'da ruban. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Orze' nguzubi Jakob kun Juan xga'n Zebedeo lo Jesús, par nzhab bixa': ―Maestr, nzhakla no, le' go tu kwa'n na'b no lo go. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nkab Jesús: ―¿Kwan nzhakla go len por go? ");
INSERT INTO zcaNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Orze' nzhab bixa': ―Or gak go rey, gap go rë kwa'n, ziyël go zob tuga' no, kad ta' go. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Per nzhab Jesús: ―Nanet go kwan kina'b go. ¿Chi zo go kwa'n nala kwa'n go'n, no chi xek go ne go kwa'n nazhe'b kwa'n zak da? ");
INSERT INTO zcaNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Orze' nkab bixa': ―Lë' no xek ka loi. Per nzhab Jesús: ―Lë' go go ka kwa'n nala kwa'n go'n; mbaino lë' go zakka kwa'n nazhe'b kwa'n zak da, ");
INSERT INTO zcaNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","per par zob tuga' go ta'n, nagakta' nene; nab tsa Xuza kobe' (wi') cho zob kad ta'n. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Or mbin za chi' men che'n Jesús kure', orze' niyi' bixa' lo Jakob no lo Juan, ");
INSERT INTO zcaNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","per ngurezh Jesús za chi' bixa' re' par nzhab Me: ―Nane ka go xmod nak rë xa' nile' mandad xid rë men gat lë't men Israel, dox naye nikë rë xa' re' men zhi'n; mbaino rë xa' ro xid rë men ba', mod nzhakla xa' nilinu xa' rë men. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Per go, nagakt go sa'; men kwa'n nzhakla le' mandad xid go, xa' ze' gak nela tu mos ga' lo go, ");
INSERT INTO zcaNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","no xa' nzhakla gak xa' tsak xid go, xa' ze' gak xa' le' mandad che'n más go; ");
INSERT INTO zcaNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","lë'la na, nak da Xga'n Dios mbaino nak da tu men yizhyuo; gat nzhalta par len mandad lo rë men; lë'da nzhal par len mandad che'n bixa', mbaino gat da por nayax men yizhyuo par ban bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Or mizhin bixa' yezh Jeriko no or nzharo' la Jesús yezh ze' kun rë men che'n Me, mbaino kun nayax men se'ga nzhakë tich Me, no ro' nez ze' nzob tu xa' nikal lo lë Bartimeo, xga'n tu xa' lë Timeo, kina'b xa' gon. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Or mbin xa' nikal lo re', lë' Jesús nzë yezh Nazaret nzhaded ze', nguzublo kibizhië xa' re', naye nzhab xa': ―¡Jesús, Xga'n Dabi, bilats laxto' da! ");
INSERT INTO zcaNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Orze' nzhab rë men: “¡Kiex, nakuzhiëtra'l!”, per más nayë nguruzhië xa', nzhab xa': ―¡Xga'n Dabi, bilats laxto' da! ");
INSERT INTO zcaNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Lë'chi ngulëz Jesús, mbaino nzhab Me: ―Waka' go xa' ba'. Orze' nzhab rë men lo xa' nikal lo re': ―¡Nazhebtal, watso; lë' Jesús kibezhal! ");
INSERT INTO zcaNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Orze' xa' nikal lo re', ngulubi xa' lar kwa'n nzho'b tich xa', nayen laka ngwatso xa', mizhin xa' lo Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","no minabdi'zh Jesús lo xa', nzhab Me: ―¿Kwan nzhaklal len pur lu? Mikab xa' nikal lo re': ―Maestr, nzhaklan yani lon. ");
INSERT INTO zcaNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Orze' nzhab Jesús: ―Bizë, guzhë ngwani lol por ngwayilal da. No mis orze', tuli ngwani lo xa' re', orze' nzhakë xa' tich Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Dub nzhazhin Jesús yezh Jerusalén, nzhaded la Me ro' xchop yezh win kwa'n nzhin ze'; tube lë Betfagé, no xtube lë Betania, gax lom plo lë Olivos; orze' mixë'l Me chop men che'n Me, ");
INSERT INTO zcaNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","nzhab Me: ―Wa go yezh win kwa'n nilu' ba', lë' go zhin plo nikido' tu burrit kwa'n gat zob ni tu men; bixëk go ma no di'nu go ma, ");
INSERT INTO zcaNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","no chi cho ne lo go: “¿Plo wei' go burrit ba'?”, orze' gab go: “Lë' Señor naki'n ma, per lwega' yi'dla' no ma.” ");
INSERT INTO zcaNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Orze' ngwa bixa', no une bixa' burrit nikido' le'n nez ro' tu pwert, no mixëk bixa' ma. ");
INSERT INTO zcaNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ze' nzo pla men, xa' nzhab: ―¿Chon kixëk go burrit ba'? ");
INSERT INTO zcaNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Orze' nzhab rë men che'n Jesús nela xmod nzhab ka Jesús lo bixa', kuze' mila' rë xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Orze' ñano bixa' burrit re' lo Jesús, mbaino mixo'b bixa' xab bixa' tich ma no nguzob Jesús ma. ");
INSERT INTO zcaNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","No dox men ndix xab dilant plo ded Jesús, no nzho bixa' ndix rram la kwa'n micho' bixa' dan, ");
INSERT INTO zcaNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","no xa' nzha dilant, no rë xa' nzë tras, naye kibizhië bixa', nzhab bixa': ¡Bidi'zh go wen nzha xa' mixë'l Dios! ");
INSERT INTO zcaNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Wen nzha xa' nzë ben che'n xuz be Dabi par le' mandad lo be! ¡Bidi'zh go nazhon Dios, Me nzho lo yibë'! ");
INSERT INTO zcaNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","No or nguio Jesús yezh Jerusalén, ngwa Me yado'; no or miwi' Me rë plo, une Me rë kwa'n nzhak ze', orze' nzha Me kun dub tu dusen men che'n Me par yezh Betania, porke ya cho gor la. ");
INSERT INTO zcaNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","No xtu riyë'l, or nguro' bixa' yezh Betania, orze' mbi'd nila'n Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","no zitra', une Jesús tu ya nzhao' nayë', no ngwatswi' Me, nabei chi nzo nzhao' loi; no or mizhin Me xan ya, yent kwan nak loi, nab lai, porke gat lë't tiemp kwa'n niza'i orze'. ");
INSERT INTO zcaNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kuze' mizhi'bde Jesús ya nzhao' ze', nzhab Me: ―Ya nayotra' yi'd men, gao men nzhao' che'nal. No kiyon rë men che'n Mei. ");
INSERT INTO zcaNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Or nguio bixa' yezh Jerusalén, mizhin Jesús lo luwe che'n yado'; orze' nguzublo kigo'tin Me rë xa' kile'xbi' no rë xa' kwa'n kizi' ze', mbaino michixche Me rë mes che'n rë xa' nichi'l dimi che'n men, no plo nito men palom, no michixche Me plo nizob bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","No nangala'tra' Jesús ngaded men kun kwa'n lo luwe ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Orze' nguzublo kilu' Me lo rë men nzhin ze', nzhab Me: ―¿Chi nanet go, se' nzobni' lo Yech che'n Dios: “Lizha yi'd rë nak men yizhyuo, par yi'di'zh bixa' lon”? ¡Per go kile'i nela plo nibin rë wa'n ga'! ");
INSERT INTO zcaNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","No or mbin rë ngulëi' ro kure', kun rë xa' nilu' ley, orze' mikwa'n bixa' mod par gut bixa' Jesús, porke or nilu' Me widi'zh che'n Dios, rë men ña'n xe. Kuze' nizheb bixa' nine bixa' Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","No or nzhala yë'l, nguro' Jesús kun rë men che'n Me, yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","No xtu riyë'l ze', or garzi'l; dub nzha bixa' nez, une bixa', lë' ya nzhao' ze' mibizh la, dub luche. ");
INSERT INTO zcaNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","No Per mitsila or mizhi'bde Jesús ya ze', kuze' nzhab Per: ―Maestr, lë' ya nzhao' kwa'n mizhi'bde go ze', ¡mibizhe biwi'ule! ");
INSERT INTO zcaNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Orze' nkab Jesús: ―Kuze' la nin, wayila go Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Walika kwa'n nin, wanei cho men gab lo yi' ba': “Chi ba', bizë le'n nitsdo'”, no nale't xa' chop xigab or gab xa'i, sino yila xa' rë kwa'n gab xa', orze' lë'i gak, lë' Dios le'i. ");
INSERT INTO zcaNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kuze' kinin, rë kwa'n na'b go lo Dios, wayila goi, lë'i gap go; lë'i zhin lo go. ");
INSERT INTO zcaNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","No or kina'b go lo Dios, biya'l laxto' go rë kwa'n nile' men lo go, nes par lë' Xuz go, Me nzho lo yibë', ya'l laxto' Me rë kwa'n nzë'b xki go lo Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Per chi naya'l laxto' go rë kwa'n nile' men lo go, nu ska Xuz go, Me nzho lo yibë', naya'lt laxto' Me rë kwa'n nzë'b xki go lo Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Orze' nguiubre Jesús xtu wëlt yezh Jerusalén kun rë men che'n Me. No or nzo Me lo luwe che'n yado', lë'chi nguzubi rë ngulëi' ro lo Me, kun rë xa' nilu' ley, mbaino kun rë xa' nak zhi'n yezh, ");
INSERT INTO zcaNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","par nzhab bixa': ―¿Cho mile' mandadal kile'l rë kure', o cho mixë'lal par le'le? ");
INSERT INTO zcaNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Orze' nkab Jesús: ―Nuska da nabdi'zh tu kwa'n lo go; no chi lë' go nei, orze' ganin cho mile' mandad da kilen rë kure'. ");
INSERT INTO zcaNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nal bine go, ¿cho mixë'l Juan, xa' mili'lëi' men le'n nits? ¿Chi Diose, o mene? ");
INSERT INTO zcaNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Orze' kidi'zh bixa' entre lë' bixa': ―Chi gab be: “Diose”, orze' lë' xa' ne lo be: “¿Chon ska nangayila go xa'?” ");
INSERT INTO zcaNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","No por rë men, nazhe'b be par be, kuze' nagakt gab be: “Men mixë'l Juan”. Porke rë men nidi'zh, walika Dios mixë'l Juan, ");
INSERT INTO zcaNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","kuze', se' mikab bixa' lo Jesús: ―Nanet no choi. Orze' nzhab ska Jesús: ―Nuska da nanita, cho mixë'l da, kilen rë kure'. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Orze' nguzublo kidi'zh Jesús kun pura kwent lo rë men, nzhab Me: ―Nguio tu miyi', ngo'n ya gub lo yuo che'n; orze' mitsao' xa' naka'n ro' yuo che'n xa', mbaino mizuxkwa' xa' tu plo tsi' xa' gub che'n xa', no nu mizuxkwa' xa' tu plo ya par kina xa'i. Orze' miza' xa'i med par ga'n xtu mene, mbaino nguro' xa' lazh xa', nzha xa' che'p. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Or ngol tiemp za'i, mixë'l xa' nak che'n yuo ze' tu mos, par na'b mos lo xa' ngo'ne, kwa'n ñal gal xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Per rë xa' ngo'n loi ze', lë'la migal bixa' mos, no ndin xa' mos, mbaino se'tsa mixë'l bixa' mos. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Orze' mixë'l xa' ze' xtu mos, per ngulë' bixa' yek mos re', no ngokla ngwa midi'zh bixa' lo mos. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Orze' mixë'l xa' ze' xtu mos, per mbit bixa' mos re'. Orze' mixë'l xa' más mos, per nzho mos ndin bixa' mbaino mbit bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’No xa' nak che'n yuo re', nab tsa xga'n xa' kinu xa', miyi' nazhi' xa'; orze' nzhab xa': “Lë'da xë'l tugaka xga'na kwa'n kinun re'; ro' xa' re'se, gon bixa'.” ");
INSERT INTO zcaNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Per rë xa' kwa'n ngo'n yuo re', or une bixa' miyi' re', nzhab bixa' lo wech bixa': “Xa' re' xa' ya'nu rë kure', cha'o gut bixa', par ya'nu be rë che'n xa'.” ");
INSERT INTO zcaNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Orze' nguzen bixa' xga'n xa' ze', mbit bixa' miyi', mbaino zit ngulubi bixa' miyi' re'. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","No nu nzhab Jesús: ―Nal, ¿kwa'n le' xa' nak che'n yuo ze'? Lë' xa' yë'd par lo'x xa' rë men nakap kwa'n ngo'n yuo che'n xa', no lë' xa' za'i ga'n xtu ben men. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Taxa, ¿nanet go kwa'n nzobni' lo Yech che'n Dios?: Lë' ke kwa'n ngulubi rë xa' nichao' yo', lë'i ngok ke galo laka kwa'n nzen dub yo'. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kure' mile' Dios, par tuli xe mia'n rë men. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Orze' ngokla bixa' ngazen bixa' Jesús par ngayo Me lizhyi'b, porke mizi bixa', par yek bixa' nzha widi'zh re'. Per mizheb bixa' por rë men nzhin ze', orze' ña bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Orze' mixë'l bixa' pla men fariseo lo Jesús par zenbe' bixa' Me (wi' bixa' xmod nak Me), no pla men che'n Herodes, par nabei chi zab Jesús tu kwa'n gat ñal, par gak kë' bixa' kixu' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Orze' mizhin rë men re', nzhab bixa': ―Maestr, nane no, go nidi'zh pura kwa'n wali, gat ñot go man che'n ni tu men, no nali nidi'zh go xmod ñal ban men lo Dios. Bine go lo no, lo ley che'n be, ¿chi lë'ka kix be kwa'n nina'b César, o gat lë'te? ¿Chi ñal za' bei, o gat ñalte? ");
INSERT INTO zcaNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Per lë' Jesús nane la, ka kina'bdi'zh bixa'i, kuze' nzhab Me: ―¿Chon kizenbe' go da? Ka ta go tu pes le. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","No miza' bixa'i, orze' nzhab Jesús: ―¿Cho nikë lo pes re', mbaino cho lë nikë loi? Orze' nzhab bixa': ―César nikë loi. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Orze' nzhab Jesús: ―Ñal za' go che'n César kwa'n nak che'n César, no za' go che'n Dios kwa'n nak che'n Dios. Orze' xe mia'n bixa' tuli por kwa'n nzhab Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Orze' nguzubi pla men saduceo lo Jesús, xa' nidi'zh: “Gat walit nzho xtu vid”, orze' minabdi'zh bixa' kure': ");
INSERT INTO zcaNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestr, Muisés mizobni' lo ley: “Chi tu miyi' kinu una' mbaino gat xa' sin nangap xa' më'd kun lë' una', orze' lë' wech xa' naki'n ban kun lë' una', par gap wech xa' tu më'd por kwent che'n xa' ngut re'.” ");
INSERT INTO zcaNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mbaino nguio tu xa' ngop gazh wech; xa' galo ngok tsa' tu una' per ngut xa' sin nangap xa' më'd; ");
INSERT INTO zcaNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","orze' xa' mirop miban kun lë' una', per ngut ska xa', se'ga' nangapt ska xa' më'd. No kun xa' mion, se'ska. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kun za gazh xa' miban una' re', no kun ni tu xa' nangapta' xa' më'd, mbaino rë xa' ngut. Lult, nu una' ngut. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","No or ruban bixa' xtu wëlt, di lo rë xa', ¿cho xa' ya'n kun lë' una'?, porke za gazh xa' miban kun lë' una'. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Orze' nkab Jesús: ―Ñagan go por nane go kwa'n nzobni' lo Yech che'n Dios, no ni yalnazhon che'n Dios nanet go, ");
INSERT INTO zcaNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","porke or ruban men, yentra' cho ban kun una', no ni yentra' cho gak jwandang che'n; lë' bixa' gak nela rë ganj che'n Dios ga'. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","No por rë men ngut xa' ruban, taxa, ¿nanet go widi'zh kwa'n mizobni' Muisés lo yech, or mize't xa' tu ya yich zobyol? Dios nzhab lo Muisés: “Na nak Dios che'n Abraham, no Dios che'n Isaac, mbaino Dios che'n Jakob.” ");
INSERT INTO zcaNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kuze' nane be, Dios re', gat lë't Dios che'n men ngute, sino lë' Me Dios che'n men naban. ¿Chi nagat zobyekt go kure'? ");
INSERT INTO zcaNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Orze' nguzubi tu xa' nilu' ley, plo nzo Jesús. Or mbin xa' xmod midi'zh Jesús lo rë men ze', porke une xa', dox wen mikab Jesús; kuze' minabdi'zh xa': ―Xid rë kwa'n mizobni' Muisés, ¿cho kwa'n galo naki'n le' men? ");
INSERT INTO zcaNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Orze' nkab Jesús, nzhab Me: ―Kure' galo laka naki'n le'l, men Israel: “Bine: tutsa Señor Dios che'nal nzho. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bichizhi' Señor Dios che'nal kun dub laxto'l, no kun dub lal, no kun rë xigab che'nal, mbaino kun rë jwers che'nal.” ");
INSERT INTO zcaNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","No kwa'n rop xid rë kwa'n nzobni' nak kure': “Bichizhi' xtu men nela lu ga'.” Yentra' xtu kwa'n mile' Dios mandad, más kwa'ro lo rop kure'. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Orze' nzhab xa' nilu' ley ze' lo Jesús: ―Dox wen kwa'n nel ba', maestr; walika, tutsa Dios, no yentra' xtu Dios más lo Dios re'. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","No kwa'n chizhi' men kun dub laxto' men Dios, no kun rë xigab che'n men, mbaino kun rë jwers; no chizhi' men xtu men nela lë'ka xa', más tsake lo rë kwa'n zak men chigab walika nazhon par men, mbaino kun más rë gon niza' men lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Or une Jesús, lë' xa' re' mikab nela xmod ñale, orze' nzhab Jesús: ―Gat zitra' nzol par yol plo nile' Dios mandad. No dizde orze', ya ni yentra' cho ngaye laxto', ngana'bdi'zh más kwa'n lo Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Dub kilu' Jesús widi'zh che'n Dios lo luwe che'n yado', lë'chi nzhab Me: ―¿Chon nidi'zh rë xa' nilu' ley, lë' Krist nak xga'n Dabi? ");
INSERT INTO zcaNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mbaino mis Dabi nzhab por Sprit che'n Dios: Lë' Señor nzhab lo Xa' nile' mandad da: “Guzob lad direch da, haxta or len, che'ptsa gak rë xa' nidilal xan ni'l.” ");
INSERT INTO zcaNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nal, ¿xmod nak lë' Krist nak xga'n Dabi?, porke mis Dabi nzhab: “Xa' re', Me nile' mandad da.” ¿Chon ska, nake xga'n Dabi? No tu bëd men kwa'n nzhin ze', ño laxto' bixa' xmod kidi'zh Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","No dub kilu' Jesús widi'zh che'n Dios, nzhab Me: ―Bikina go go lo rë xa' kwa'n nilu' ley, lë' bixa' ño laxto' nzhak bixa' lar no'l; mbaino ño laxto' bixa', nini' men lo bixa' dub lo xbi'. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mbaino ño laxto' bixa' zob galo laka bixa' plo nizob rë xa' ro, le'n yo' plo nitse'd men widi'zh che'n Dios; no nu plo nzhak tu lani galo laka bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mbaino niliwa'n bixa' che'n rë una' ngut xmiyi'; no par gab men, menaye bixa', xche nina'b bixa' lo Dios. Kuze', más nazhe'b kwa'n zak bixa' or gab Dios xmod gak kun kad men yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Orze' nguzob Jesús dilant plo ñuchao' rë gon; xe kiwi' Me xmod kila rë men ze' gon, no tu bëd men rrik kila nayax dimi. ");
INSERT INTO zcaNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Lë'chi mizhin tu una' ngut xmiyi', no prob xa'; orze' le'n ze' mila una' chop dimi kwa'n natsakt be's, ");
INSERT INTO zcaNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","orze' ngurezh Jesús rë men che'n Me, nzhab Me: ―Walika nin, una' prob kwa'n ngut xmiyi' re', par Dios, más nayaxe miza' una' ke rë xa' rrik ba'; ");
INSERT INTO zcaNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","rë xa' rrik ba' miza' kwa'n mia'n sobr lo bixa', per una' re', dub lo yalprob che'n xa', rë tsa dimi kwa'n kinu xa' par gao xa', miza' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","No or nzharo' Jesús lo luwe che'n yado', orze' nzhab tu rë men che'n Me: ―Maestr, biwi' go tatu kwa'ro yado' re'; no tatu nazhe'b rë ke nzho ta'i. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Per nzhab Jesús: ―¿Chi niwi'l dox kwa'roi? Per zhin zhë ni tu ke che'ne naya'nte tich weche; rëi bil. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Orze' nzha Me yek lom kwa'n lë Olivos, ze' nilu' laka yado', orze' nguzob Me, no za dap rë xa' re' mina'bdi'zh lo Me: Per kun Jakob no Juan mbaino Ndres; nzhab bixa': ");
INSERT INTO zcaNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Bine go lo no, ¿pok gak rë kure', no xmod lu' or nzhazhin la rë kure'? ");
INSERT INTO zcaNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Orze' nguzublo kidi'zh Jesús, nzhab Me: ―Bikina go go, par yent cho kide go, ");
INSERT INTO zcaNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","porke dox men di'zh: “Na nak Krist”, no dox men kide bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’No or gon go, laba'i-lare'i kidil men, nayat laxto' go; rë kure' gak galo laka, per stubi nilë'ra' lox yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Lë' tu gubier dil kun xtu gubier, no tu yezh kun xtu yezh; mbaino rë plo win xo, no yo yalwin. Kure' galo laka yalzi kwa'n zublo zak rë men yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Per bikina go go, lë' rë men zen go no chi bixa' go lo rë gustis, no kin bixa' go le'n rë yo' plo nitse'd men widi'zh che'n Dios; mbaino wei' bixa' go lo rë gobier no lo rë rey por nak go men da; kure' gak par di'zh go cho da lo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","No antis di lox yizhyuo, naki'n re'ch widi'zh nazhon che'n Dios lo rë ben men yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Or zen bixa' go par wei' bixa' go lo rë xa' nile' mandad ze', no nale't go xigab xmod kab go lo bixa'; lë' Sprit che'n Dios di'zh por go. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","No lë' men chi mis wech men par gat wech xa', mbaino xuz men mis lë' xa' chi rë xin xa', no rë xin xa' chi xuz xa' par mis lë' bixa' le' gat rë melizh bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Sa' li'nu nayax men go por nak go men da, per xa' xek lo rë kure', xa' ze' ban bid nazhon kwa'n niza' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","‘No or ne go, yo tu kwa'n dox gat nambet plo nzho yalnazhon che'n Dios (xa' go'l kure', lë' xa' zobyeke), orze' rë men nzho lazh men Judea, lë' bixa' yuka'ch dan; ");
INSERT INTO zcaNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","no rë men nzo yek yo', naza'tra' la bixa' par ko' bixa' rë che'n bixa'; ");
INSERT INTO zcaNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","mbaino xa' nzo dan, naza'tra' yubre xa' ni par yaka' xa' xab xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","No zhë ze', ¡zhe'b nalats nzha rë una' nak xin, mbaino rë una' naka' më'd! ");
INSERT INTO zcaNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bina'b go lo Dios, par zhë zhin rë kure' nagakte rë mbëo' nayag. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Dub di mizuxkwa' Dios yizhyuo, lalta', nagat zakzi men nela zak bixa' rë zhë ze', nab tsa orze'i; no ni nayo ra' ne men xtu kwa'n nela kwa'n yi'd ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","No chi xche di' rë kure', yent cho men yizhyuo ya'n naban, rë' xa' lox; per por nazhi' Dios rë men xa' ngule Me, la'ta' Dios di' rë kure' xche. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’No chi cho ne lo go: “¡Biwi', lë' Krist nzo re'!”, o “¡Biwi', lë' Krist nzo ba'!”, nayilat goi, ");
INSERT INTO zcaNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","lë' nayax men yo di'zh: “Na nak Krist”, mbaino yo nayax men gab lo men: “Na nidizh por Dios”, no le' bixa' rë señ nazhon par kide bixa' rë men; no nzho rriez kide bixa' nu rë men ngule Dios gak men che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kuze' bikina go go; lë'da ni la rë kure' lo go nes par nzhon la goi. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","No nzhab Jesús: ―Le'n rë ngubizh ze', or lox rë yalzi kwa'n nzho yizhyuo, orze' lo ngubizh kao, no lo mbëo' nayanitra', ");
INSERT INTO zcaNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","mbaino gab rë mbël lo yibë'; no nu bil rë kwa'n nzen kwa'n nzho lo yibë'. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Orze' rë men ne, yala le'n xkao kun rë ganj che'n Xuza, mbaino kun rë yalnazhon da. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","No xëla rë ganj che'n Xuza par kan rë men da xa' ngulen dap lad yizhyuo, dizde tu ro' yizhyuo haxta xtu ro' yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Biwi' go xmod nak ya nzhao'; or nixiche, orze' nane go, lë' biyiu nzhazhin la. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Se'ga' or ne go, kiyak rë kwa'n nazhe'b re'; nane la go, lë'da nzhazhin la yal. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Walika kwa'n kinin, or zublo gak rë kure', rë men yizhyuo xa' mia'n naban orze', se'gaka naban bixa' or lox gak rë kure'. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yibë' no yizhyuo, lë'i lox; per rë widi'zh kwa'n kinin re', nadedte, rëi gak. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Per zhë ze', or zhin gak rë kure', yent cho nanei; ni rë ganj kwa'n nzho lo yibë', mbaino ni na; nab tsa Xuza Dios nanei. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kuze' biwi' go kwan le' go, no gok natsin go; porke nanet go or zhin rë kure'. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Rë kure' nak nela tu miyi' nguro' nzha lazh men. Antis di ya xa', mila' xa' tuga' rë mos che'n xa' par kina rë che'n xa', mbaino mika'b xa' lo tu rë mos re' kina ro' pwert. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","No go nak nela rë mos re', bikina go; porke nanet go cho or yë'd xa' nak che'n yo' re', chi mizhëlalyuoi, o garol yë'le, o or nikë' nguid gay kante, o garzi'le; ");
INSERT INTO zcaNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","nes par or yala de rrepent, yent kwan ya laxto' go. ");
INSERT INTO zcaNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","No kwa'n nin lo go re', gat lë't par nab go nzhai, sino par rë men yizhyuoi; ¡gok natsin go! ");
INSERT INTO zcaNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nzhak jwalt xchop ngubizh par gal lani Pask, zhë nzhao men pan kwa'n yent levadur. Lë' rë ngulëi' ro kun rë xa' nilu' ley, kikwa'n bixa' mod zen bixa' Jesús xla'n, par gut bixa' Me, ");
INSERT INTO zcaNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","mbaino kidi'zh bixa': ―Nale't bei zhë lani, par nayent kwan le' rë men. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","No or nzo Jesús yezh Betania, ngwatao Me lizh Simón xa' lë “Lepros”. Or nzob Jesús lo mes, mizhin tu una' kun tu bot win kwa'n nakxao' kun ke ónice, dox tsake; viv aseit nardo nzho le'ne. Orze' ngulë' una' kwa'n nzho aseit re', michob una'i yek Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Per pla xa' nzhin ze', nangayot laxto' bixa'i, nzhab bixa' lo wech bixa': —¿Chon mitsinu una' re' aseit ba'? ");
INSERT INTO zcaNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ngak ngado aseit ba' kwa'n tsak chi' mbëo' kë men zhi'n che'n men, par ngaga'z dimi ze', ngaka' rë men yent kwan nzhap. Kuze', ndil bixa' una' ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Orze' nzhab Jesús: ―La' go, nadilt go una' re'; ¿chon kikixian go xa'?, porke dox wen tu kwa'n mile' xa' por da; ");
INSERT INTO zcaNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","rë men prob, zilita' yo bixa' xid go, gak gaknu go bixa' or nzhakla go; per na gat lë'ta' dubta' zon kun go. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mbaino una' re', mile' kwa'n ngok mile' xa'; michob xa' aseit nax da, nes par or ga'ch da mile' la xa'i. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","No walika kwa'n nin; rë plo re'ch widi'zh nazhon che'n Dios, nu ka kwa'n mile' una' re' yët, par tsila bixa' una'. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Orze', lë' Judas Iscariote, xa' nzho xid za tu dusen men che'n Jesús, ngwa xa' lo rë ngulëi' ro, par chi xa' Jesús lo rë xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Or mbin bixa' kure', dox nizak laxto' bixa', no nzhab bixa', za' bixa' dimi ka' Judas. No dizde orze', nguzublo kikwa'n Judas mod, kiwi' xa' cho or za'i, par gak chi xa' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mer ngubizh galo che'n lani pask, or nzhao men Israel pan kwa'n niyent levadur, zhë ze' niza' men Israel tu gon lo Dios, or nzhut bixa' tu mbëkxi'l. Orze' mina'bdi'zh rë men che'n Jesús, nzhab bixa': ―¿Plo nzhakla go yachao' no kwa'n gao be nal yë'l re', lani Pask re'? ");
INSERT INTO zcaNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Orze' mixë'l Me chop men che'n Me, nzhab Me: ―Wa go le'n yezh; ba' ne go tu miyi' ñanu tu re' nits, no wakë go tich xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mbaino plo zhin xa', guzh go lo xa' nak lizhe ze': “Lë' Maestr ne lol: ¿Plo nak yo' kwa'n ne'l, par ga̱o̱ kun rë men da, lani Pask re'?” ");
INSERT INTO zcaNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Orze' lë' xa' lu' tu yo' nzob yek al ya, naxene, no nazuxkwa' la le'ne; ze' bizuxkwa' go kwa'n gao be. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Orze' nzha rop men che'n Jesús par yezh; no rëi ngok nela xmod nzhab ka Jesús lo bixa'; ze' michao' bixa' kwa'n gao bixa' lani Pask. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","No or ngula yë'l, mizhin Jesús ze', kun dub tu dusen men che'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","No dub kiyao bixa' lo mes, nzhab Jesús: ―Walika kwa'n nin, mis tu rë go kiyao kuda re', chi da lo rë men par gut bixa' da. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","No rë bixa' miwin laxto', orze' nguzublo minabdi'zh tuga' bixa' lo Jesús, nzhab bixa': ―¿Taxa le' go xigab nai? ");
INSERT INTO zcaNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Orze' nzhab Jesús lo bixa': ―Mis tu rë xa' nzho xid tu dusen goi, xa' kwa'n kigazh pan le'n plat dai. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Na Xga'n Dios no nu tu men yizhyuo da; lë'da zak rë kwa'n nzobni' lo Yech che'n Dios, ¡per nazhe'b nalats nzha miyi' xa' chi da lo rë men! Más wen nangayot ngal xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","No dub kiyao bixa', nguzen Me pan, miza' Me xkix lo Dios, no michix Mei, miza' Mei ka' rë men che'n Me, orze' nzhab Me: ―Mbai go, kure' nak kwerp da. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","No nguzen Me tu vas nits gub, miza' Me xkix lo Dios, orze' miza' Mei ka' rë men che'n Me, rë bixa' ngu'y, ");
INSERT INTO zcaNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","mbaino nzhab Me: ―Kure' nak ren da kwa'n xon, par ya'n nayax men nambe lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Walika kwa'n nin, nago'tra' nits gub yizhyuo re'. Or go'ne xtu wëlt plo nile' Dios mandad, xa'la mode. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","No or milox mikë' bixa' tu kant lo Dios, nguro' bixa' nzha bixa' yek lom kwa'n lë Olivos, ");
INSERT INTO zcaNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","orze' nzhab Me lo bixa': ―Rë go la' nzë'b da, porke se' nzobni' lo Yech che'n Dios: “Lë'da gut miyi' nikina mbëkxi'l, orze' lë' rë ma re'ch.” ");
INSERT INTO zcaNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Per or ruban da, lazh men Galilea kwëza yi'd go. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Orze' nzhab Per: ―Ter rë xa' re' la' nzë'b go; per na, nalat go. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Per nzhab Jesús: ―Walika kwa'n nin, nal yë'l re', ni naga kë' nguid gai kant chop wëlt, lë'l gab chon wëlt gat nili'be'tal da. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Per garga'l nzhab Per: ―¡Per na nalat go ter nu da gat kun go! No se'ska nzhab rë bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Orze' ngwa bixa' tu plo lë Getsemaní, ze' nzhab Jesús lo rë men che'n Me: ―Riga guzob go, lë'da nzhana'b lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Orze' nzhanu Me Per, no Jakob, mbaino Juan; orze' nguzublo niyentra' jwers Me por tanta nizheb Me, haxta netra' Me kwan le' Me, ");
INSERT INTO zcaNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","no orze' nzhab Me lo yon xa' re': ―Nzho tu yalnawin dox laxto'n, ya naxektra' da; biya'n go re' no bikina go; naga't go. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Orze' nguzë Jesús xche'p dilant; ze' ngo't kuslo Me lo yuo, no mina'b Me lo Dios, chi lë'i gak le' Dios, nazhint rë kwa'n zak Me orze'. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Or kina'b Me lo Dios, nzhab Me: ―Payë', par go, rëi gak le' go. ¿Chi zak kubchi go da lo rë kwa'n nzë par da? Per gat lë't kwa'n nin, kuze' gak; sino kwa'n ne goi. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Orze' miëk Me plo nzhin yon men che'n Me ze'; no mizhin Me, lë' yon xa' nax la. Orze' nzhab Me lo Per: ―Simón, ¿chi naxnal? Nangaxektal ni tu or, ngakinal. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Bikina go no guna'b go lo Dios, par nayachin go lo che'n Mizhab. Le'n laxto' go nzhakla ka go che'n Dios, per kwerp che'n go gat nzhaklat che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Orze' ngwa Jesús xtu wëlt, par ngwana'b Me lo Xuz Me Dios, mis kwa'n nzhab la Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Or miëk Me xtu wëlt, lë' bixa' nax la, porke dox nzë mika'l lo bixa'; orze' net bixa' xmod kab bixa' lo Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","No wëlt mion nzhab Me: ―¿Stubi nax go, kile' go diskans? Porke xa' chi da, ngox la nka'. Biwi' go, lë' or mizhin la, lë' Xga'n Dios Me nu nak tu men yizhyuo, yo ya' rë xa' nzë'b xki lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Waxche go, cha'o, ro' be re'; biwi' go, lë' xa' chi da nzë la ba'. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mis orze', stubi kidi'zh Jesús; lë'chi mizhin Judas, mis tu xa' nak tu dusen men che'n Me, kun tu bëd men, nzho bixa' nzen spad mbaino yarrot. Rë xa' re' mixë'l rë ngulëi' ro, kun rë xa' nilu' ley, mbaino rë men Israel xa' nak zhi'n. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","No xa' le' entreg Jesús, nzhab xa' tu señ le' xa': “Xa' kwa'n chiro'n ta' kwats, xa' ze' guzen go no bi'y go xa'; no neo, nale' xa' gan.” ");
INSERT INTO zcaNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Or mizhin Judas lo Jesús, lwega' nguzubi xa', nzhab xa': ―¿Ma go Maestr? Orze' michiro' xa' ta' kwats Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","mbaino nguzubi rë men par nguzen bixa' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Orze' xtu rë xa' nzo ze', kun spad micho' xa' tu nzha mos che'n ngulëi' ro, ");
INSERT INTO zcaNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","orze' midi'zh Jesús lo rë men ze': ―¿Chon nzë go kun spad mbaino kun yarrot? ¿Chigab tu men wa'n nzatsen go? ");
INSERT INTO zcaNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Zilita' nguzon xid go le'n yado', plo nidi'zha widi'zh che'n Dios; no nangazent go da. Per rë kure' nzhak par gak rë kwa'n nzobni' lo Yech che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Orze', rë men che'n Jesús mikë' karre, mia'n nab tsa Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Per tu miyi' xi nzhakë tich Jesús, narël xa' nab tsa tu sab, per nu xa' nguzen men, ");
INSERT INTO zcaNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","per nguro'tin xa' ya' men, mia'ntsa sab che'n xa' ya' rë men ze', kache' xa' mile' xa' gan. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Orze' mbi'y bixa' Jesús lo ngulëi' ro; no ze' nzhin más ngulëi' kwa'n nile' mandad lo más ngulëi', kun rë men Israel xa' nak zhi'n, mbaino rë xa' nilu' ley kwa'n mila' Dios lo Muisés. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Per lë' Per ngwakë zit tich Jesús, haxta lo luwe che'n ngulëi' ro mizhin Per. Ze' nguzob Per xid rë xa' nikina yado', kibizh bixa' junt lo ki. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","No rë ngulëi' ro, mbaino kun más rë gustis xa' más nile' mandad, kikwa'n bixa' cho men gab, nak Jesús tu kwa'n ñal gat Me, par gut bixa' Jesús; per yent kwan ngane bixa', nak Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","No nayax men midi'zh kwa'n nak Jesús, per pura nikë bixa' di'zh, tu xa' kun xtu xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","No nzho xa' mikë' mbël nzhab: ");
INSERT INTO zcaNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Mbin no midi'zh xa': “Na chil yado' kwa'n michao' men, mbaino chontsa ngubizh kuxkwa'n xtube, per gat lë't kwa'n nichao' ya' mene.” ");
INSERT INTO zcaNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Per ni kwa'n nzhab xa' re', gat nakte tutsa kun rë kwa'n nidi'zh más bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Orze' nguzuli ngulëi' ro, par nguzo xa' sao' rë men ze', orze' minabdi'zh xa' lo Jesús: ―¿Chon nanel kabal? ¿Kwan kine rë xa' re' nakal? ");
INSERT INTO zcaNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Per yent kwan ngakab Jesús. Orze' minabdi'zh ngulëi' ro xtu wëlt, nzhab xa': ―¿Chi lu nak Krist, Xga'n Dios Me nidi'zh rë men nazhon? ");
INSERT INTO zcaNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Orze' nzhab Jesús: ―Nai. No rë go ne, lë' Xga'n Dios, Me nu nak tu men yizhyuo; lë' Me zob lad direch che'n Dios Me nile' rëi; no yë'd Me le'n xkao lo yibë'. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Orze' michëz ngulëi' ro lar kwa'n nzho'b tich xa', nela tu señ ga' ke lë' Jesús midi'zh tu kwa'n gat lë' lo Dios. Orze' nzhab xa': ―¿Kwan ra' gakla be, ne men, xtu kwa'n nak xa' re'? ");
INSERT INTO zcaNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Rë go mbin, midi'zh xa' di'zh gat lë' lo Dios. ¿Kwan nile'u xigab ñal xa'? No rë bixa', tutsa midi'zh bixa', ke ñal gat Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","No nzho bixa' nguzublo michuk lo Jesús; no mitsao' bixa' lo Jesús kun tu lar, no mikë' bixa' puñet yek Jesús, orze' nzhab bixa': ―¡Bine cho mikë'i yekal! No nu rë xa' nikina yado', mixa't bixa'i ta'ro' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","No lë' Per nzob al yët lo luwe, lë'chi mizhin tu una' nikë zhi'n che'n ngulëi' ro, ");
INSERT INTO zcaNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","no or une una' lë' Per kibizh, xe miwi' una', nzhab una': ―Nuka lu, niki'zë kun Jesús Nazareno. ");
INSERT INTO zcaNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Orze' nzhab Per: ―¡A'a! ¡Ni nanen kwan kidi'zhal! Orze' nguro' Per ro' yo' al tich. (No lwega' mikë' tu nguid gai kant.) ");
INSERT INTO zcaNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","No or une kriad Per xtu wëlt, nguzublo nzhab una' xid rë men nzhin ze': ―¡Nuka xa' re', tu xa' nikizë kun lë' bixa'! ");
INSERT INTO zcaNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Per xtu wëlt nzhab Per: “Nalibe'ta' xa' ba'”, no uzhëla ze', rë xa' nzhin ze' nzhab bixa' lo Per: ―¡Sigur nukal nikizël kun lë' bixa', porke lu nzë lazh men Galilea! ");
INSERT INTO zcaNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Orze' nguzublo kize't Per Dios, nzhab Per: ―¡Dios zakzi da chi lë'da ka kini rë kure'! ");
INSERT INTO zcaNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Lë'chi mis orze', mikë' nguid gai kant xtu wëlt. Orze' mitsila Per kwa'n nzhab Jesús: “Antis di kë' nguid gai kant chop wëlt, lë'l gab chon wëlt: Gat nili'be'ta' xa' ba'.” Orze' dox mbi'n Per. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","No riyë'l, garzi'l laka migan rë ngulëi' xa' nile' mandad lo más ngulëi', no kun rë men Israel xa' nak zhi'n, mbaino kun rë xa' nilu' ley, no kun más rë gustis xa' más nile' mandad; rë xa' re' tutsa midi'zh bixa'. Orze' mili'b bixa' Jesús par mbi'y bixa' Me lo Pilat. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Orze' minabdi'zh Pilat lo Jesús, nzhab xa': ―¿Chi lu nak rey lo rë men Israel? Orze' nzhab Jesús: ―Go nei. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","No rë ngulëi' xa' nile' mandad lo más ngulëi', por dox kixu' kikë' bixa' Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","kuze' xtu wëlt minabdi'zh Pilat, nzhab xa' lo Jesús: ―¿Chon nanel kabal ni tu kwa'n? Biwi', dox kwa'n ne bixa' nakal. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Per yent kwan ngakab Jesús, kuze' haxta net Pilat, xmod le' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","No or nzhal lani Pask, kinu Pilat kostumbr, niliya' xa' tu men nzho lizhyi'b, dike cho men gakla rë men ro' lizhyi'b. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","No tu miyi' lë Barrabás nzho lizhyi'b orze', kun zipla xa' mbit men kun lë' xa', or ngok tu dil kun gubier César. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Orze' mizhin rë men lo Pilat, nguna'b bixa', ziyël Pilat ko' xa' tu men nela xmod nile' ka xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","orze' nzhab Pilat: ―¿Chi nzhakla go liyan xa' nak rey che'n rë men Israel? ");
INSERT INTO zcaNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Porke ngwanu laxto' Pilat, lë' rë ngulëi' ro xa' nile' mandad, michi Jesús por mbidios bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Per lë' rë ngulëi' xa' nile' mandad ze', más mile' bixa' par nzhab rë men, liya' Pilat Barrabás mejor. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Orze' minabdi'zh Pilat: ―¿Nal, kwan nzhakla go len kun xa' kwa'n nzhab go nak rey lo rë men Israel? ");
INSERT INTO zcaNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Orze' nzhab rë men, kibizhië bixa': ―¡Bikë' xa' lo krus! ");
INSERT INTO zcaNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Orze' nzhab Pilat: ―¿Per kwan tu kwa'n nazhe'b mile' xa' re'? Per rë men, xtu wëlt nguruzhië bixa': ―¡Bikë' xa' lo krus! ");
INSERT INTO zcaNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","No par ya'n Pilat wen kun rë men, miliya' xa' Barrabás, no dispwes di mile' xa' mandad ndin bixa' Jesús, orze' michi xa' Jesús lo men par kë' bixa' Jesús lo krus. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Orze' lë' rë sondad mbi'y Jesús lo luwe plo nzob palas, kwa'n lë ‘pretorio.’ Ze' migan pas como xo'p gayo' sondad román. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","No mila bixa' tu lar naxne yën Jesús, nela che'n tu rey ga'. Orze' mizuxkwa' bixa' tu koron yich, par mizob bixa'i yek Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","orze' nguzublo nibizhyë bixa', nzhab bixa': ―¡Wen nzha rey che'n rë men Israel! ");
INSERT INTO zcaNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Orze' mixa't bixa' ya yek Jesús, no michuk bixa' lo Me, mbaino nguzuxib bixa' par mile' bixa' nela nile' men kun tu rey ga' lo Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","No or milox mixizhnu bixa' Jesús, orze' ngulo' bixa' lar naxne ze' yën Me, orze' migak ska bixa' xab ka Me, orze' ngulo' bixa' Jesús par kë' bixa' Jesús lo krus. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","No tu miyi' lë Simón, xa' nzë yezh Cirene, xa' nak xuz Lejandr no Ruf; ñë'd xa' di dan. Or nded xa' ze', orze' mile' rë sondad, mbi'y xa' krus che'n Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Orze' nzhanu bixa' Jesús plo lë Gólgota (Widi'zh re' gab, Yek Men Ngut). ");
INSERT INTO zcaNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","No nzhakla bixa' ngaza' bixa' vin kwa'n noch mirra, par go' Jesús, per nangot Mei. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Orze' mikë' bixa' Jesús lo krus, orze' nguzhit bixa' di swert, par ne bixa', cho ya'n kun xab Jesús, no kwan le' kad bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Pas como las nueve garzi'l, mikë' bixa' Jesús lo krus. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","No mikë' bixa' tu letr por kwan ngut Jesús, kwa'n nzhab se': “Xa' re' rey che'n rë men Israel.” ");
INSERT INTO zcaNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","No nu chop wa'n mikë' bixa' lo krus orze'; tu xa' lad direch, no xtu xa' lad izkierd che'n Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","par ngok tu widi'zh kwa'n nzobni' lo Yech che'n Dios kwa'n nzhab se': “No nu xa' nguio kwent, xid rë xa' kwa'n nzë'b xki lo Dios.” ");
INSERT INTO zcaNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","No rë men nided ze', nidi'zh bixa' kwa'n gat lë', nikwin bixa' yek bixa', nzhab bixa': ―¡Taxa! ¡Lu kwa'n nidi'zh, chilal yado'; no chontsa ngubizh, kuxkwa'le! ");
INSERT INTO zcaNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Gula lo krus ba'; no mis lu, la'tal gatal! ");
INSERT INTO zcaNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Se'ska nzhab rë ngulëi' xa' nile' mandad, kun rë xa' nilu' ley kwa'n mila' Dios lo Muisés, mixizhnu bixa' Jesús; kidi'zh bixa' lo wech bixa': ―Nayax men miliyak xa'; per kun lë' xa', nangale't xa'i. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Chi lë' xa' walika nak Krist, no rey lo rë men Israel; ¡nzhakla no la xa' yub xa' lo krus, par ne noi, orze' yayila no xa'! No haxta rop xa' nikë lo krus kun lë' Jesús, midi'zh bixa' gat lë' lo Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","No or ngol garol ngubizh, dub yizhyuo mikao haxta las tres guzhe, ");
INSERT INTO zcaNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","no mis orze', midi'zh Jesús naye: ―¡Eloi, Eloi!, ¿lama sabactani? (Widi'zh re' gab: ¡Dios da, Dios da!, ¿chon mila' nzë'b go da?) ");
INSERT INTO zcaNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","No pla rë men nzhin ze' mbin widi'zh re'; nzhab bixa': “Bin go, lë' xa' kibezh Li, tu xa' mixë'l Dios nzhala.” ");
INSERT INTO zcaNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Orze' karre ngwa tu xa', migazh tlë' sponj le'n vin nala; orze' mili'b xa'i yek tu ya, no michi xa'i ro' Jesús par ngo Mei, orze' nzhab xa': ―Bila' go, nabei chi ziyi'd Li, par la xa' lo krus. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Per orze' naye nguru'zhië Jesús, no mizi'la Me; ngut Me, ");
INSERT INTO zcaNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","lë'chi ngurëz lar kwa'n nayao' le'n yado' plo dox nazhon; chop lë' ngoke tuli, dizde al ya haxta al yët. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","No une capitán che'n rë sondad, xa' nzo gax lo Jesús, xmod ngut Jesús, orze' nzhab xa': ―Walika, Xga'n Dios miyi' re'. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","No nu ska pla rë una' kwa'n nzhin zit ze', une rë kure'. Xid rë una' re' nzo Mari Madalén, mbaino xtu Mari xna' Jakob xa' más xi, no xna' Che; no xtu una' lë Salomé. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Rë una' re', or stubi nzo Jesús Galilea, ngwakë bixa' tich Me, no mile' bixa' mandad che'n Jesús; no nu más rë una' nzhin ze', xa' kwa'n ngwakë tich Jesús par yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","No or ngwa'z ngubizh zhë Vier, nguzublo zhë bispr che'n sabd, zhë kwa'n nayi' kë men Israel zhi'n, ");
INSERT INTO zcaNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","orze' tu miyi' lë Che, xa' nzë yezh Arimatea, no nak xa' tu xa' nak zhi'n xid rë gustis xa' más nile' mandad che'n men Israel, no nu miyi' re' kimbëz yo plo nile' Dios mandad; xa' re' mile' rriez, ngwa lo Pilat, par nguna'b xa' kwerp che'n Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Orze' xe mia'n Pilat or mbin xa', lë' Jesús ngut la; orze' ngurezh xa' capitán che'n rë sondad kwa'n mikë' Jesús lo krus, par minabdi'zh xa', nabei chi walika ngut la Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Or mbin xa': “Walikai”, nzhab capitán, orze' miza' xa' kwerp che'n Jesús wei' Che. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Orze' nguzi' Che tu lar yex; no or milox mila xa' kwerp lo krus, orze' michël xa' lar yex kwerp che'n Jesús, ngwaka'ch xa'i le'n tu ba' kwa'n nade'n la le'n pura ke; no mitsao' xa' ro'i kun tu ke ro. ");
INSERT INTO zcaNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","No Mari Madalen kun xtu Mari xna' Che, une bixa' plo miga'ch kwerp che'n Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Or nded zhë sabd ze', lë' Mari Madalen mbaino xtu Mari xna' Jakob, kun una' lë Salomé; ngwazi' bixa' aseit nax par chob bixa'i kwerp che'n Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","No primer zhë che'n sman, garzi'l laka laore ngulen laka ngubizh, nzha rë una' re' ro' ba'. ");
INSERT INTO zcaNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Dub nzha bixa' nez, nzhab tu una' lo xtu una': ―¿Cho gaknu be par kubchi ke, ro' ba' se? ");
INSERT INTO zcaNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Per or nzhazhin la bixa' gax, lë'chi une bixa', lë' ke ze' nax la tu lad. No dox kwa'ro ke ze'. ");
INSERT INTO zcaNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Or nguio bixa' le'n ba', une bixa' tu miyi' xi nak tu lar bëo laka, nzob lad derech; orze' dox mizhe'b biuna', ");
INSERT INTO zcaNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","orze' nzhab miyi' xi re': ―Nazhebt go. ¿Chi Jesús Nazareno, Me nkë lo krus, kikwa'n go? Yentra' Me re', lë' Me nguruban la. Biwi' go plo nguxo'b Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Per nal bizë go, no wayab goi lo rë men che'n Me, mbaino lo Per; lë' Me kimbëz la lazh che'n men Galilea; ze' ne go Me, nela xmod mila' ka Me di'zh. ");
INSERT INTO zcaNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Orze' nguro' rë una' ze' karre le'n ba', porke dox mizheb bixa' haxta nixiz bixa'; per yent cho lo ngab bixa'i nez, porke dox mizheb bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","No dispwes di nguruban Jesús garzi'l laka ngubizh galo che'n sman, orze' ngurulo Me galo laka lo Mari Madalen, una' kwa'n ngulo' Jesús gazh mbi mal laxto'. ");
INSERT INTO zcaNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Orze' lë' una' ngwayabe lo rë men che'n Jesús, porke dox niwin laxto' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","No or mbin bixa', lë' Jesús nguruban, no lë' una' re' une Me; per net bixa' ngayila bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Dispwés di kure', ngurulo Jesús xtu mod lo xchop men che'n Me, or nzo bixa' dan. ");
INSERT INTO zcaNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Orze', rop xa' re' ngwayabe lo más bixa', per nangayilatska rë xa' ze'i. ");
INSERT INTO zcaNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Lult laka ngurulo Jesús lo za chi' bitub men che'n Me or nzob bixa' lo mes; orze' ndil Jesús bixa' por gat ñila bixa'i, por tanta nad bixa', nangayilat bixa' rë kwa'n nzhab, rë xa' une nguruban Me. ");
INSERT INTO zcaNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Orze' nzhab Jesús: ―Wa go dub yizhyuo, par wadi'zh go kwa'n nazhon che'n Dios re', lo kwantsa men. ");
INSERT INTO zcaNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Xa' yila da no gaklëi' xa', lë' xa' gal vid nazhon kwa'n niza' Dios; per xa' nayila da, lë' Dios zakzi xa'. ");
INSERT INTO zcaNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","No rë señ re' le' rë xa' ñila da: Por lën, kutin xa' mbi mal; di'zh xa' xtu ben di'zh kwa'n za' Dios ka' men; ");
INSERT INTO zcaNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","no ter zen xa' mbë'l, o go xa' tu kwa'n nile' nzhat men, per yent kwa'n zak bixa'; no or xo'b bixa' ya' bixa' yek rë men nzhakne, lë' rë men ze' yak. ");
INSERT INTO zcaNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","No or milox nzhab Me rë kure', orze' nkili Me lo yibë' par nguzob Me lad derech che'n Xuz Me Dios. ");
INSERT INTO zcaNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","No rë men che'n Me, nguro' bixa' rë plo, par ngwadi'zh bixa' widi'zh nazhon che'n Dios por Jesukrist. No lë' Me ngoknu bixa' por rë señ nazhon kwa'n mile' Me por lë' bixa'.");
INSERT INTO zcaNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nayax men, xa' nak men che'n Jesukrist, mizuxkwa' la bixa' kwent che'n kwa'n mile' Dios xid be, ");
INSERT INTO zcaNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","no nela xmod milu' ka men dizde or galo, rë xa' kwa'n une kure' kun zalo bixa', no nu rë xa' kwa'n milu' widi'zh che'n Jesukrist lo men. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kuze', nu ska da mile xigab kë'n rë kure' lo yech, or milox mina'b dizha, miwi'n wena-wen, xmod ngok kwent che'n Jesukrist, dizde or nagat gal Me, O Tioj, lu xa' dox tsak, ");
INSERT INTO zcaNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","par ganel, walika widi'zh kwa'n milu' men lol, kwent che'n Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","No or nak Herodes rey lo rë men Judea, nzho tu ngulëi' xa' lë Zacarías, tu xa' nzë ben che'n Abías, tu xa' tiemp. No una' che'n xa' lë Sabel, una' re' nzë ben che'n ngulëi' Aarón. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","No wen nikizë bixa' lo Dios, mbaino nzhon bixa' ro' Dios, nile' bixa' rë kwa'n nzhab Señor. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Per gat kinut bixa' xin bixa', porke lë' Sabel nagakt gap më'd, mbaino rop bixa' ya ngwagal la. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Per ngol tu ngubizh, lë' ben tsa' ngulëi' Zacarías ngol, le' zhi'n lo Dios, orze' Zacarías ngol xa' le' zhi'n lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Le'n rë ngubizh ze', se' nak kostumbr che'n rë ngulëi', lë' Zacarías ngol yo le'n yado', par lazh ya'l lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","No dub kilazhya'l xa' lo biko', lë' nayax men nzhin tich, kina'b bixa' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Lë'chi ngurulo tu ganj che'n Dios lo Zacarías, al nez lad direch che'n biko' plo nilazhya'l rë ngulëi'. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","No or une Zacarías ganj re', net xa' kwan le' xa', dox mizheb xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Orze' nzhab ganj: ―Zacarías, nazhebtal, porke lë' kwa'n guna'bal lo Dios, lë' Me mbin kai, lë' una' che'nal Sabel gap tu xmë'dal, mbaino ku'lël më'd Juan, ");
INSERT INTO zcaNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","no dox zak laxto'l, mbaino zak laxto' rë men, or gal më'd re', ");
INSERT INTO zcaNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","porke lë' më'd re', dox tu miyi' gak xa' lo Dios, no nayot go xa' kwa'n nile' nizuzh men, mbaino dub naga gal më'd re', lë' Sprit che'n Dios nzho la laxto' më'd. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","No lë' më'd re', le' nayax men Israel, lë' bixa' la' kwa'n gat lë't nile' bixa', mbaino yëk bixa' lo Dios che'n bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Juan re' yi'd galo laka lo Señor kun mis poder kwa'n miza' Sprit che'n Dios nka' Li, tu xa' tiemp, par kwin xuz men wen kun xin xa', mbaino par rë men nayi' lazh, tse'd bixa' gon bixa' ro' rë xa' nile' kwa'n ñal, nes par zobyek men widi'zh che'n Dios, Me yë'd re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Orze' minabdi'zh Zacarías lo ganj ze': ―¿Xmod nen chi walika rë kwa'n kinel lon? Porke na dadgol la, no nu ska una' da mengol la. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Orze' nzhab ganj: ―Na lë Gabriel, no nzon lo Dios par len mandad che'n Dios. Lë' Dios mixë'l da par dizha kulu, nzadnin tu widi'zh wen kwa'n le' zak laxto'l. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","No biwi', por nangayilal kwa'n nin lol, lë'l ya'n mud, nagaktra' di'zhal, haxta ke zhin zhë gak rë kure'. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","No dub kiyak rë kure', no lë' rë men nzhin al tich kimbëz bixa' ro' Zacarías, no kile' bixa' xigab: “¿Chon zhe'b xche nzho xa' re' le'n yado'?” ");
INSERT INTO zcaNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","No or nguro' Zacarías le'n yado', nangaktra' ngadi'zh xa' lo rë men. Orze' ngwanu laxto' rë men, lë' Dios milu' tu kwa'n lo xa' le'n yado', mbaino maska ya' Zacarías nzhak, kidi'zh xa' kun pura señ, orze' mia'n xa' mud. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","No or milox mitsa Zacarías rë ngubizh che'n xa' kwa'n nile' xa' zhi'n le'n yado', orze' ña xa' lizh xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","No or nded rë ngubizh ze', lë' Sabel, una' che'n xa' nak xin la, no nangaro't una' lizh una' dub gai' mbëo', kile' una' xigab re': ");
INSERT INTO zcaNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Lë' Dios mile' kure' kuda, par naxizhnu ra' men da, por nagapa më'd.” ");
INSERT INTO zcaNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nzha xo'p mbëo' di ngok kure', orze' mixë'l Dios ganj Gabriel tu yezh kwa'n lë Nazaret, kwa'n ña'n lazh men Galilea, ");
INSERT INTO zcaNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","plo nzho tu una' ye'n lë Mari, nzo xti'zh par ban kun tu miyi' lë Che; miyi' re' nzë ben che'n rey Dabi. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nguio ganj le'n yo' plo nzho Mari, orze' nzhab ganj: ―¿Mal Mari? ¡Dios niwi' wen lol, no Dios nzo kun lu! ");
INSERT INTO zcaNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","No or mbin Mari widi'zh re', net Mari xmod le' Mari, mile' Mari xigab: “¿Chon ne xa' ba' kure' lon?” ");
INSERT INTO zcaNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Orze' nzhab ganj: ―Mari, nazhebtal, porke nazhon nzhal, lë' Dios niwi' lol. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nal biwi', lë'l wei'xin, lë'l gap tu më'd xibyi', mbaino ku'lël më'd JESÚS. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Dox tu miyi' tsak gak më'd re' lo Dios, mbaino lë' më'd re' rulë Xmë'd pa' Dios, Me nzho lo yibë', no lë' Señor Dios le', gak më'd re' rey, nela ngok Dabi ga', tu xa' kwa'n ngok mis ben më'd re'; ");
INSERT INTO zcaNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","par le' më'd re' mandad par dubta' lo rë men Israel, no nayot lox le' më'd re' mandad. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Orze' nzhab Mari lo ganj: ―¿Xmod gak kure', porke gat kinuta' miyi'? ");
INSERT INTO zcaNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Orze' nzhab ganj: ―Lë' Sprit che'n Dios yi'd lol, mbaino kun poder che'n Dios, dubal yao' kun xkal che'n Me, kuze' lë' më'd gapal ba', rulë Xmë'd pa' Dios, më'd nazhon kwa'n le' rë tsa kwa'n nzhakla Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","No biwi', nu ska tu bël ye'nal, xa' lë Sabel, nzha la xo'p mbëo' nakxin xa', no ter mengol la xa', xa' kwa'n nidi'zh men nagakt gap më'd, ");
INSERT INTO zcaNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","porke par Dios, yent kwan nagak le' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Orze' nzhab Mari: ―Biwi' go, Dios nak Me nile' mandad da; le' Dios kuna nela xmod nel lon ba'. Orze' ña ganj. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","No le'n rë ngubizh ze', nayen nzha Mari plo nzho Sabel, tu yezh kwa'n nzhin le'n rë yi', kwa'n ña'n lazh men Judea. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","No or nguio Mari lizh Zacarías, nzhab Mari: ―¿Mal, Sabel? ");
INSERT INTO zcaNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","No or mbin Sabel widi'zh che'n Mari, tuli miwin më'd laxto' Sabel, orze' mile' Sprit che'n Dios naye midi'zh Sabel lo Mari, nzhab una': ―Nazhon nzhal mile' Dios, más ke lo rë una' nzho yizhyuo; mbaino nu nazhon nzha xmë'dal lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Cho da, par yi'dtswi' xna' Señor da, ma da?, ");
INSERT INTO zcaNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","porke biwi', or mbina midi'zhal, miwin xmë'da laxto'n di tanta nizak laxto' më'd. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nazhon nzhal, por ngwayilal gak rë widi'zh che'n Dios, kwa'n ne ganj lol. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Orze' nzhab Mari: Kun dub laxto'n, zan xkix lo Dios por nazhon Me, ");
INSERT INTO zcaNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","no nizak laxto'n por Dios da, Me kwa'n ngulo' da lo rë kwa'n nzë'b xkin, ");
INSERT INTO zcaNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","porke Dios miwi' lon, ter nak da nela tu mos nado ga' lo Dios, tu men kwa'n natsakt tuli. Per biwi', dizde nal ra', rë men kwa'n yo yizhyuo, di'zh nazhon nzhan, ");
INSERT INTO zcaNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","porke lë' Dios Me kwa'n nzhak nile' rë kwa'n, mile' kwa'n dox kwa'ro kuda, no nazhon lë Me. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","No nilats laxto' Dios rë xa' nzhon ro' Dios, dizde xmë'd xa' haxta rë xa' gak ben che'n xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Mile' Dios kwa'n nazhon kun poder che'n Dios. Mika'n Dios lo rë xigab che'n rë men nizi dox tsak, ");
INSERT INTO zcaNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","no ngulutin Dios rë xa' nile' mandad, par ngulo Dios rë men nado' xlugar bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","No miza' Dios nayax kwa'n wen ka' rë men prob, no lë' men rrik, mile' Dios mia'n bixa' se'tsa. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ngoknu Dios rë men che'n Dios, rë men Israel; nangaya'lt laxto' Dios, lë' Dios nilats laxto' bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","nela xmod mila' ka Dios di'zh lo rë xuz be, xa' tiemp; lo Abraham, no lo rë xa' nzë ben che'n xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","No como chon mbëo' mia'n Mari lizh Sabel, orze' nguiubre Mari, ña Mari lizh Mari. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","No or ngol ngubizh gal xin Sabel, orze' ngol xin xa' tu më'd xibyi'. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Or mbin rë xa' kwa'n nzho gax kun lë' una', no rë melizh una', lë' Dios milats laxto' una', orze' nu bixa' nizak laxto' kun lë' una'. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","No or nded xon ngubizh, ngwa bixa' lo më'd, mikë' bixa' señ kwa'n lë circuncisión ze' më'd, no nzhakla bixa' ngarolë më'd nela lë xuz më'd, Zacarías. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Orze' nzhab xna' më'd: ―Narulët më'd sa', lë' më'd rulë Juan. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Orze' nzhab bixa': ―Per yent cho melizhal lë Juan. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Orze' minabdi'zh bixa' kun pura señ lo xuz më'd, par gab xuz më'd xmod rulë më'd. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Orze' mina'b xuz më'd tlë' tab win, mizobni' xa': “Lë' më'd lë Juan.” Orze' xe mia'n rë men tuli. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Haxta orze', ngok midi'zh Zacarías, tuli ka nzhab xa': “¡Dox nazhon Dios!” ");
INSERT INTO zcaNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Orze' rë xa' nzhin xa' gax kun lë', mizheb bixa' tuli, no rë xa' nzho rë yezh kwa'n nzhin le'n rë yi' lazh men Judea, mbin bixa' rë kure'. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","No rë xa' ze', mile' bixa' xigab: “¿Kwan le' më'd re' or ro'b më'd?”, porke dox nazhon kwa'n mile' Dios kun lë' më'd. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Orze' mile' Sprit che'n Dios midi'zh Zacarías, nzhab xa': ");
INSERT INTO zcaNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Dox nazhon Dios che'n rë men Israel, yi'dgo' Me be, lo rë kwa'n nzë'b xki be. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Lë' Dios xë'l tu xa' dox kinu poder xa' ko' be lo kwa'n nazhe'b. Xa' re' yi'd ben che'n rey Dabi. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Lë'i gak nela xmod midi'zh Dios lo rë men che'n be, xa' ngok profet, ");
INSERT INTO zcaNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","par lat Me be lo rë xa' nidil be, mbaino par ko' xa' be ya' rë xa' kwa'n niyi' nine be, ");
INSERT INTO zcaNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","par ne be, lë' Dios se'gaka nilats laxto' rë xuz be, xa' tiemp, mbaino par lu' Dios, lë' Me se'gaka nitsila kwa'n mila' Me di'zh lo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Se' mila' Dios di'zh lo xuz be Abraham, xa' tiemp. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Lë' Dios lat be ya' rë men xa' niyi' nine be, par niyentra' kwan zheb be, le' be kwa'n nzhakla Dios, ");
INSERT INTO zcaNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","dub nambe laxto' be lo Dios, dub tiemp kwa'n naban be nali yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","No lu, xmë'da, lë'l rulë xa' nidi'zh por Dios, Me kwa'n nzho lo yibë', porke lo Señor yal, par xa'lal nez che'n Señor, ");
INSERT INTO zcaNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","par le'l ne men che'n Dios, xmod nak nabantra' bixa' lo kwa'n gat lë', par ro' bixa' lo rë kwa'n nzë'b xki bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","porke por nazhi' Dios men no nizine laxto' Me men. Kuze', dizde al ya' lo yibë' yi'd Me, par yani laxto' men, nela or ñanilyuo xtu zhë ga', ");
INSERT INTO zcaNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","par zini Me lo rë xa' naban lo yalzi che'n xki bixa', mbaino zini Me lo rë xa' nazubxax yalgut tich, par ku'nez Me be plo zi be chul. ");
INSERT INTO zcaNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","No nzharo'b më'd, no nzharo'b nu më'd rë jwers, par nile' më'd gan lo rë kwa'n gat lë', no pura rë plo yent men nguio xa', haxta zhë or ngurulo xa' lo rë men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","No le'n rë ngubizh ze', Augusto César mile' mandad, zoblë rë nak men rë yezh plo nile' xa' mandad. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kure' ngok primer wëlt mile' xa' zoblë men, or nak Cirenio gobiernador lazh men Siria. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","No kad men ngwazobni' lë plo ngol bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kuze' nguro' Che yezh Nazaret kwa'n ña'n lazh men Galilea, par nzha xa' yezh Belén, kwa'n ña'n lazh men Judea, plo ngol rey Dabi, porke ben che'n rey Dabi nzë Che. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Junt ngwazobni' Che lë Che kun Mari, una' kwa'n nak di'zh gak tsa' xa', mbaino nakxin la Mari. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","No dub nzhin bixa' ze', ngol zhë kwa'n gal xin Mari. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Or mizhin bixa' plo ya'n bixa', yentra' lugar ngaya'n bixa', kuze' ña bixa' plo nzhin ma, no ze' ngol xin Mari, më'd galo, no michël xa' lar më'd, orze' ndix xa' më'd plo nzhao ma. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","No gax yezh Belén, or yë'l ze', nzhin pla men dan, xa' nikina mbëkxi'l. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Lë'chi orze' ngurulo tu ganj che'n Dios lo bixa', no dub plo nzhin bixa' nkë tu biani kwa'n maska ña'zbël che'n Señor, orze' dox mizheb bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","per nzhab ganj lo bixa': ―Nazhebt go, no biwi' go, lë'da nzadni tu widi'zh wen lo go kwa'n le' dox zak laxto' rë nak men yizhyuo, ");
INSERT INTO zcaNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","porke nalyë'l re', yezh che'n Dabi, ngol tu më'd kwa'n nak Krist no Señor, Me kwa'n ko' men lo rë kwa'n nzë'b xki men lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kure' nak nela tu señ ga', par ne go rë kwa'n kinin, lë'i walika; lë' go yazhël më'd, narël më'd lar, nax më'd plo nzhao ma. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Lë'chi orze', nguruxo'b tu bëd ganj lo yibë', kikë' kant lo Dios kwa'n nzhab se': ");
INSERT INTO zcaNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Dox nazhon Dios, Me nzho lo yibë', no lo yizhyuo, mial laxto' Dios kun rë men, rë xa' kwa'n niwi' Dios wen lo! ");
INSERT INTO zcaNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","No or ña rë ganj lo yibë', orze' nzhab rë xa' niki'na mbëkxi'l ze' lo wech bixa': ―Chao' nzha be yezh Belén, par ne be rë kwa'n bi'dne ganj che'n Dios lo be re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Orze' nzha bixa' nayen-nayen, no ngwazhël bixa' Mari no Che, no më'd ye'n nax plo nzhao ma. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","No or une bixa' më'd ye'n, orze' miza' bixa' kwente lo Mari no lo Che, por kwa'n ngwayab ganj lo bixa' por më'd ye'n re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","No rë xa' kwa'n mbin kure', xe mia'n bixa' tuli, por rë kwa'n midi'zh rë xa' nikina mbëkxi'l re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mbaino Mari, rë kure' kiguchao' xa' laxto' xa', no kile' xa' xigab por lë'i. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Orze' rë xa' nikina mbëkxi'l ze', miëk bixa', mbaino kidi'zh bixa' nazhon Dios por rë kwa'n mbin bixa' no kwa'n une bixa', porke rëi ngok nela xmod nzhab ka ganj lo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Or nzhap më'd xon ngubizh, orze' ngwanu xuz më'd, më'd, par nkë señ plo naban më'd; orze' ngulo'lë bixa' më'd JESÚS, nela xmod nzhab ka ganj lo Mari, antis di wei'xin Mari. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","No or miza ngubizh che'n Mari, or gak la yo Mari le'n yado', ya mimbe la kwerp che'n xa', nela xmod nzobni' lo ley kwa'n mila' Dios lo Muisés, orze' nzhanu bixa' më'd yado' kwa'n nzob yezh Jerusalén, par lu' bixa' më'd lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Se' mile' bixa', porke se' nzobni' lo ley kwa'n mila' Dios lo Muisés: “Rë më'd miyi' kwa'n galo laka gal, gak par Dios.” ");
INSERT INTO zcaNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","No miza' bixa' tu gon lo Dios, nela xmod nzobni' ka lo ley che'n Muisés; chop ngog o chop palom. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","No le'n rë ngubizh ze', yezh Jerusalén nzho tu miyi' xa' lë Simeón. Nambe naban xa' lo Dios, nile' xa' rë nak kwa'n nzhab Dios, mbaino kimbëz xa' re', lë' Dios xë'l tu xa' lat rë men Israel, ya' rë xa' kwa'n nidil xa' kun lë'. No Lë' Sprit che'n Dios nzo kun lë' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Lë' Sprit che'n Dios milu' la lo xa', lë' xa' ne Krist, Me kwa'n xë'l Dios antis di gat xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kuze' mbiy' Sprit che'n Dios xa' le'n yado'. No or mbiy' xuz më'd no xna' më'd, më'd le'n yado', par le' bixa' kun lë' më'd rë kostumbr kwa'n nzobni' lo ley che'n Dios, ");
INSERT INTO zcaNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","orze' nde'x Simeón më'd, nzhab xa': ");
INSERT INTO zcaNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","O Dios Señor da, yent kwane bila' gat da nal, porke lë'l milu'la kwan nel lon por Sprit che'nal, ");
INSERT INTO zcaNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","porke lë'da unela xa' kwa'n ko' men lo rë kwa'n nzë'b xki men lo Dios, ");
INSERT INTO zcaNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","më'd kwa'n mixë'lal lo rë nak men, ");
INSERT INTO zcaNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","par le' më'd, ne rë xa' gat lë't men Israel, xmod ko' Dios bixa' lo kwa'n nzë'b xki bixa' lo Dios. No por më'd re', rë men Israel ya wen. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","No Che kun xna' Jesús, xe mia'n bixa' por rë kwa'n midi'zh Simeón por më'd re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Orze' ngurezh Simeón yalnaza'k par Che no par Mari xna' Jesús, per nu nzhab Simeón lo Mari: ―Biwi', por më'd re', nayax men Israel lox lo Dios, mbaino nu nayax bixa' por më'd re', lë' bixa' ro' lo rë kwa'n nzë'b xki bixa' lo Dios; mbaino më'd re' lu' lo rë men xmod nak xigab che'n Dios kun rë men, per nayax men le' naya', gaklat xa' gon xa' kwa'n di'zh më'd re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kure' gak nela tu yalne, mbaino nela tu yalnawin dox par lu, Mari. Por më'd re', rube' xmod nak kad men, xa' wen no xa' nakap. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","No nu tu una' xa' lë Gan nzo ze'; tu una' kwa'n nidi'zh por Dios. Xa' re' nak xcha'p Fanuel, tu xa' nzë ben che'n Aser. No dox la ngwagal xa'. Di ngok jwandang che'n xa', gazhtsa li'n miban xa' kun xmiyi' xa', ");
INSERT INTO zcaNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","no or nzhap xa' tap gal nzho tap li'n, ngut xmiyi' xa'. Zhëy-yë'le nzho xa' yado'. Nzho or gat nzhaot xa' par nina'b xa' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","No mis orze', nguzubi xa' lë Gan re', orze' nguzublo miza' xa' xkix lo Dios, mbaino kidi'zh xa' por më'd re', no midi'zh xa', lë' Dios le', ro' rë men Jerusalén lo rë kwa'n nzë'b xki bixa' lo Dios, rë xa' kwa'n kimbëz gaknu Dios bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","No or milox mile' xuz Jesús, rë nak kwa'n nzobni' lo ley kwa'n mila' Dios lo Muisés, orze' miëk bixa' par lazh men Galilea, par ña bixa' yezh Nazaret, plo nak lazh bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Orze' nzharo'b më'd, mbaino nzharo'b xigab che'n më'd; dox nzhak më'd che'n Dios mbaino nane më'd xmod nak tu men; no nilu', lë' Dios kiyaknu më'd. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","No xuz Jesús kun xna' Jesús, rë li'n ña bixa' yezh Jerusalén, or nzhal lani Pask. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","No or nzhap Jesús tu dusen li'n, ngwa rë bixa' lani yezh Jerusalén, nela xmod nile' ka bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","No or ngwalo lani ze', miëk xuz Jesús kun xna' Jesús, ña bixa' lizh bixa', no nanganet bixa', mia'n më'd yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mile' bixa' xigab, ñë'd ka më'd xid rë xa' ñë'd bixa' kun lë', no dub tu ngubizh nguzë la bixa' nez, per or mikwa'n bixa' Jesús xid rë melizh bixa' no xid rë xa' nzhakbe' bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","per nangazhëlt bixa' më'd. Orze' miëk bixa' yezh Jerusalén par nzhakwa'n bixa' më'd. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nzha chon ngubizh di niyent më'd, lë'chi ngwazhël bixa' më'd le'n yado'; nzob më'd xid rë xa' nilu' ley, kiyon më'd kwa'n kidi'zh bixa', no kinabdi'zh më'd rë kwa'n lo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","No rë xa' kwa'n mbin kidi'zh më'd, xe mia'n bixa' tuli, por tanta natsin më'd, no dox natsin më'd lo rë kwa'n nikab më'd. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","No or une xuz më'd no xna' më'd plo nzo më'd; xe mia'n bixa' tuli; orze' nzhab xna' më'd: ―Xmë'da, ¿chon mile'l kure' kun no? ¡Biwi', xuzal no da kikwa'n no lu, no dox kile' no xigab che'nal! ");
INSERT INTO zcaNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Orze' mikab më'd: ―¿Chon kikwa'n go da? Lë'da nile xigab, nane ka go lë'da naki'n le rë kwa'n nak che'n Xuza. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Per nangazobyekt bixa' kwa'n midi'zh më'd. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Orze' ña më'd kun lë' bixa' lazh bixa', plo miban më'd, no mile' më'd rë kwa'n nzhab bixa'. Per xna' më'd nguluchao' rë kure' laxto' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","No nzharo'b më'd, no nzharo'b xigab che'n më'd, no kad ngubizh más nilu' nzo Dios kun lë' më'd, no rë men, wen niwi' bixa' lo më'd. ");
INSERT INTO zcaNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Or nzha chi'n li'n nak Tiberio César rey lo rë men Roma, lë' Pons Pilat nak gobiernador lo rë men Judea; no Herodes nak gobiernador lo rë men Galilea; lë' wech xa' Lip nake lo rë men Iturea no lo rë men Traconite; mbaino lë' Lisanias nak gobiernador lo rë men Abilinia. ");
INSERT INTO zcaNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Le'n mis rë ngubizh ze', lë' Anás no Caifás nak ngulëi' ro. Orze' midi'zh Dios lo Juan, xga'n Zacarías or nzho xa' le'n yuo bizh. ");
INSERT INTO zcaNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nguzublo Juan nded xa' rë yezh kwa'n ña'n plo nak you' Jordán, kiyab xa' lo rë men, naki'n la' bixa' rë kwa'n gat lë' nile' bixa', orze' gaklëi' bixa' le'n nits par lu', walika mila' bixa' kwa'n nak bixa', nes par che' Dios rë kwa'n nzë'b xki bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kure' ngok nela xmod midi'zh ka Isaías, tu xa' midi'zh por Dios, or nzhab xa': Gon go tu men nzo le'n yuo bizh, kidi'zh xa' naye: “Bizuxkwa' go laxto' go par yo Dios laxto' go, nale'tra' go kwa'n gat lë', ");
INSERT INTO zcaNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","porke rë men nado', lë' Dios le' gak xa' men tsak, per rë xa' nile' xigab dox tsak xa', lë' Dios le', che'ptsa zi xa' lo men. Rë men nikizë nez gat lë', naki'n ban xa' nali, no rë xa' di'zhyix, naki'n di'zh xa' kwa'n ñal, ");
INSERT INTO zcaNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","mbaino rë men yizhyuo libe' xa' kwa'n xë'l Dios, par ko' men lo rë kwa'n nazhe'b nzho bixa'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","No or nzha men par gaklëi' men le'n nits lo Juan, per nzhab Juan lo bixa': ―¡Rë go, men nakap, xa' nak nela mbë'l nayi' ga'! ¿Cho ne lo go, nab por gaklëi' go, le' go gan lo kwa'n nazhe'b kwa'n xë'l Dios par rë men kwa'n nzë'b xki lo Me? ");
INSERT INTO zcaNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nal bilu' go walika, mila' go rë kwa'n gat lë' nile' go. Mbaino nagabt go por nzë go ben che'n Abraham, xmë'd Dios go, porke Dios gak le' kun rë ke nzhin re', gake xa' nzë ben che'n Abraham, ");
INSERT INTO zcaNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","porke rë go nak nela rë ya kwa'n nazu't ga'. Kuze' biwi'u, lë' yi'b ya nzo la list par cho' haxta rë luch che'n rë nak ya kwa'n gat niza't xlë wen, orze' yubiy par yoi lo ki. ");
INSERT INTO zcaNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Orze' nzhab rë men lo Juan: ―Nal, ¿kwan naki'n le' no? ");
INSERT INTO zcaNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Orze' nzhab Juan: ―Rë xa' kinu chop nez xab, naki'n za' xa' tube ka' xa' kwa'n gat kinute, mbaino xa' kinu kwa'n gao, naki'n ki'z xa'i, gao xtu xa' gat kinute. ");
INSERT INTO zcaNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","No ngwa pla xa' nikan dimi che'n gubier Roma lo Juan par gaklëi' bixa', mbaino nzhab bixa' lo Juan: ―Maestr, no ga', ¿kwan naki'n le' no? ");
INSERT INTO zcaNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Orze' nzhab Juan: ―Guna'b go dimi kwa'n ñal na'b go namás, nana'bt goi di más. ");
INSERT INTO zcaNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","No nu pla sondad gunabdi'zh, nzhab bixa': ―Mbaino no ga', ¿kwan naki'n le' no? Orze' nzhab Juan: ―Nalat go dimi jwers lo men, no ni nakë' go kixu' men; mbaino bizak laxto' go kun kwa'n nzhax ka' go namás. ");
INSERT INTO zcaNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","No nal, rë xa' kwa'n dox xigab nile', pok xë'l Dios Krist; mile' bixa' xigab paste lë' Juan nak Krist, ");
INSERT INTO zcaNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","per nzhab Juan lo rë men: ―Walika, nililëi'ya men le'n nits namás, per xtu xa' yi'd más tsak lon. Per ni gat ñal da gak da tu mos che'n xa', porke yent kwan tsak da par lë' xa'. Xa' re' li'lëi' go kun Sprit che'n Dios, no kun bël. ");
INSERT INTO zcaNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","No lë' Me nzen la kwa'n par tsumbe Me triu, par ki'b Me yix le'ne. No kan Me triu par kuchao' Mei le'n yo', no lë' yix kwa'n yi'b le'ne, kubi Me le'n bël kwa'n nayot yal. ");
INSERT INTO zcaNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Se' midi'zh Juan lo rë men, no kun más rë widi'zh par nzhab xa' xmod ko' Dios men lo rë kwa'n nazhe'b nzho men. ");
INSERT INTO zcaNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","No nu ndil Juan Herodes, xa' nile' mandad lazh men Galilea, por kinu xa' Herodías, una' che'n wech xa' Lip, no por más rë kwa'n gat lë' kwa'n nak Herodes. ");
INSERT INTO zcaNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","No xid rë kwa'n gat lë' kwa'n mile' Herodes, mile' xa' xtu kure'; ngulo xa' Juan lizhyi'b. ");
INSERT INTO zcaNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","No or kililëi' Juan men le'n nits, nu Jesús ngoklëi' lo Juan; no dub kina'b Jesús lo Dios, mixa'l lo yibë', ");
INSERT INTO zcaNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","orze' milu' ngula Sprit che'n Dios yek Jesús nela tu palom ga', no mien tu widi'zh lo yibë' kwa'n nzhab se': ―Lu nak Xga'na, kwa'n nazhi' da; mbaino dox nizak laxto'n, niwi'n lol. ");
INSERT INTO zcaNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nzhap Jesús gal bichi' li'n or nguzublo nkë Jesús zhi'n nazhon che'n Dios. Nzhab men, lë' Che ngok xuz Jesús, lë' Elí ngok xuz Che. ");
INSERT INTO zcaNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Lë' Matat ngok xuz Elí, lë' Leví ngok xuz Matat, lë' Melqui ngok xuz Leví, lë' Jana ngok xuz Melqui, lë' Che ngok xuz Jana, ");
INSERT INTO zcaNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","lë' Matatías ngok xuz Che, lë' Amós ngok xuz Matatías, lë' Nahum ngok xuz Amós, lë' Esli ngok xuz Nahum, lë' Nagai ngok xuz Esli, ");
INSERT INTO zcaNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","lë' Maat ngok xuz Nagai, lë' Matatías ngok xuz Maat, lë' Semei ngok xuz Matatías, lë' Che ngok xuz Semei, lë' Judá ngok xuz Che, ");
INSERT INTO zcaNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","lë' Joana ngok xuz Judá, lë' Resa ngok xuz Joana, lë' Zorobabel ngok xuz Resa, lë' Salatiel ngok xuz Zorobabel, lë Neri ngok xuz Salatiel, ");
INSERT INTO zcaNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","lë' Melqui ngok xuz Neri, lë' Adi ngok xuz Melqui, lë' Cosam ngok xuz Adi, lë' Elmodam ngok xuz Cosam, lë' Er ngok xuz Elmodam, ");
INSERT INTO zcaNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","lë' Josué ngok xuz Er, lë' Elieser ngok xuz Josué, lë' Jorim ngok xuz Elieser, lë' Matat ngok xuz Jorim, ");
INSERT INTO zcaNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","lë' Leví ngok xuz Matat, lë' Simeón ngok xuz Leví, lë' Judá ngok xuz Simeón, lë' Che ngok xuz Judá, lë' Jonán ngok xuz Che, lë' Eliaquim ngok xuz Jonán, ");
INSERT INTO zcaNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","lë' Melea ngok xuz Eliaquim, lë' Mainán ngok xuz Melea, lë' Matata ngok xuz Mainán, lë' Natán ngok xuz Matata. ");
INSERT INTO zcaNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Lë' Dabi ngok xuz Natán, lë' Isaí ngok xuz Dabi, lë' Obed ngok xuz Isaí, lë' Booz ngok xuz Obed, lë' Salmón ngok xuz Booz, lë' Naasón ngok xuz Salmón, ");
INSERT INTO zcaNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","lë' Aminadab ngok xuz Naasón, lë' Aram ngok xuz Aminadab, lë' Esrom ngok xuz Aram, lë' Fares ngok xuz Esrom, lë' Judá ngok xuz Fares, ");
INSERT INTO zcaNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","lë' Jakob ngok xuz Judá, lë' Isaac ngok xuz Jakob, lë' Abraham ngok xuz Isaac, lë' Taré ngok xuz Abraham, lë' Nacor ngok xuz Taré, ");
INSERT INTO zcaNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","lë' Serug ngok xuz Nacor, lë' Ragao ngok xuz Serug, lë' Peleg ngok xuz Ragao, lë' Heber ngok xuz Peleg, lë' Sala ngok xuz Heber, ");
INSERT INTO zcaNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","lë' Cainán ngok xuz Sala, lë' Arfaxad ngok xuz Cainán, lë' Sem ngok xuz Arfaxad, lë' Noé ngok xuz Sem, lë' Lamec ngok xuz Noé, ");
INSERT INTO zcaNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","lë' Matusalén ngok xuz Lamec, lë' Enoc ngok xuz Matusalén, lë' Jared ngok xuz Enoc, lë' Mahalaleel ngok xuz Jared, lë' Cainán ngok xuz Mahalaleel, ");
INSERT INTO zcaNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","lë' Enós ngok xuz Cainán, lë' Set ngok xuz Enós, lë' Adán ngok xuz Set, lë' Dios ngok xuz Adán. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","No dox nzho Sprit che'n Dios laxto' Jesús, nguiubre Jesús plo nak you' Jordán, no mbiy' Sprit che'n Dios Jesús le'n yuo bizh plo yent cho nak. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ze' nguio Jesús dub cho' ngubizh, mbaino yent kwan ngao Jesús. Per or nded rë ngubizh re', mila'n Jesús, no ngokla Mizhab ngazenbe' Jesús (ngawi' Mizhab xmod nak Jesús), ");
INSERT INTO zcaNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","kuze' nzhab Mizhab: ―Chi walika nakal Xga'n Dios, guzh lo ke re' gake yët. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Per nzhab Jesús: ―Se' nzobni' lo Yech che'n Dios: “Gat lë't nab kun yët gak ban men, sino kun nab tsa rë widi'zh kwa'n niro' ro' Dios.” ");
INSERT INTO zcaNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Orze' ngwanu Mizhab Jesús yek tu yi' ro, no tu rratsa milu' Mizhab rë lazh men plo nzhin men yizhyuo, ");
INSERT INTO zcaNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","orze' nzhab Mizhab lo Jesús: ―Na ne rë nak kure' ka'l, par le'l mandade, mbaino rë kwa'n tsak che'ne, porke na nile' mandade, no na zai ka' cho nzhaklan. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Chi lë'l ne nazhon da, mbaino zuxibal lon, che'nal rëi. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Orze' nzhab Jesús: ―¡Chi lon Mizhab!, porke se' nzobni' lo Yech che'n Dios: “Nabtsa lo Dios Me nile' mandadal, zuxibal lo, mbaino gabal nazhon.” ");
INSERT INTO zcaNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Orze' mbiy' Mizhab Jesús haxta yek laka yado' Jerusalén, no nzhab Mizhab: ―Chi lë'l walika nak Xga'n Dios, dizde re' wats haxta lo yuo, ");
INSERT INTO zcaNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","porke se' nzobni' lo Yech che'n Dios: Dios xë'l rë ganj che'n Dios par gaknul mbaino kinal; ");
INSERT INTO zcaNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","mbaino zen rë ganj ya'l par nakë ke ni'l, nes par nayachinal. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Orze' nzhab Jesús: ―Nuska nzob lo Yech che'n Dios: “Nagakta' le'l mandad lo Dios, jwers le' Dios tu kwa'n or nzhaklal.” ");
INSERT INTO zcaNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","No or une Mizhab, nangakt ngakide xa' Jesús, orze' nguiubchi Mizhab che'p lo Jesús, haxta or le' xa'i xtu wëlt, orze' zubi xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Orze' miëk Jesús lazh men Galilea, dox kile' Sprit che'n Dios kwa'n nazhon kun Jesús, no rë yezh kwa'n nzhin naka'n ze', nzhon men kwa'n nile' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","No ñalu' Jesús widi'zh che'n Dios lo rë men plo nzob rë yo' plo nitse'd men widi'zh che'n Dios, kwa'n nzob kad yezh ze', mbaino dox wen ñët Jesús xid rë men. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Orze' ngwa Jesús yezh Nazaret plo mixen Me. No zhë kwa'n nayi' kë men Israel zhi'n, nguio Jesús le'n yo' plo nitse'd men widi'zh che'n Dios, nela xmod nile' ka Jesús, nguzuli Me par go'l Me widi'zh che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Orze' miza' men yech go'l Me, yech kwa'n mikë' profet Isaías, tu xa' kwa'n midi'zh por Dios; no or mixa'l Me loi, mbi'l Me plo nzobni' widi'zh re': ");
INSERT INTO zcaNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Lë' Sprit che'n Dios kiyaknu da, porke ngule Dios da par dizha widi'zh wen lo rë men prob; no mixë'l Dios da par rë xa' nayao' yo', par kon bixa' lizhyi'b; no rë xa' kwa'n nikal lo, lë' da le wi' bixa', mbaino kotina rë xa' nzho ya' Mizhab; ");
INSERT INTO zcaNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","mbaino par dizha lo rë nak men: “¡Mizhin la zhë ko' Dios men lo rë kwa'n nazhe'b kwa'n nzadkë tich men!” ");
INSERT INTO zcaNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Orze' mitsao' Jesús lo yech, no miza' ska Mei ka' xa' niguchao'we, orze' nguzob Me. No rë xa' nzhin ze', xe niwi' bixa' lo Me, ");
INSERT INTO zcaNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","orze' nzhab Jesús lo rë men nzhin ze': ―Mis nal re' mizhin ngok rë widi'zh kwa'n nzobni', kwa'n milox mbin go re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Orze' rë men midi'zh wen por Jesús, no xe mia'n bixa' tuli por rë kwa'n wen midi'zh Jesús, orze' nzhab bixa' lo wech bixa': ―Gat xa' re' nak xga'n Che. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Orze' nzhab Jesús: ―Sigur ka, lë' go ne widi'zh re' lon: “Doctor, biliwen mis lu”; no nu ne go: “Kwa'n mile'l Capernaúm yezh ye'n ba', se'ska bile'i lazhal re'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Per nzhab Jesús: ―Walika da kwa'n nin re', rë xa' kwa'n nidi'zh por Dios, mis rë xa' lazh xa' nayilat kwa'n di'zh xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mbaino walika, nayax una' kwa'n ngut xmiyi', nguio lazh men Israel zhë che'n Li, or nangalat yiu chon li'n garol, no dub rë ze' nguio yalwin, ");
INSERT INTO zcaNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","per nangaxë'lt Dios Li lo ni tu rë una' men Israel ze', sino ke nab tsa lo tu una' gat lë't men Israel mixë'l Dios Li, tu una' ngut xmiyi' xa' nzë yezh Sarepta, plo nile' lazh men Sidón mandad. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","No zhë che'n profet Eliseo, tu xa' midi'zh por Dios, nguio dox men Israel xa' nzhakne di yalyizh kwa'n lë lepra, no per ni tu rë xa' re' ngaliwent Eliseo; sino ke nab tsa Naamán miliwen Eliseo, tu men gat lë't men Israel, tu xa' nzë lazh men Siria. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Or mbin rë men kure', rë xa' kwa'n nzhin plo nitse'd men widi'zh che'n Dios, dox miyi'xian bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","orze' rë bixa' ngwatso par ngulo' bixa' Jesús haxta ro' yezh yek lom plo nzhin yezh re', par ze', ngache'p bixa' Jesús le'n barrank. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Per nded Jesús xid bixa', ña Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Orze' ña Jesús yezh Capernaúm, plo nile' lazh men Galilea mandad. Ze' kilu' Jesús widi'zh che'n Dios lo rë men, rë zhë kwa'n nayi' kë men Israel zhi'n. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","No xe ña'n rë men tuli, por xmod nilu' Jesús widi'zh che'n Dios, porke nilu' Me, lë' Me kinu poder che'n Dios par le' Me mandad. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","No le'n yo' ze' plo nitse'd men widi'zh che'n Dios, nzo tu miyi' kwa'n nzho mbi mal laxto'; naye nguruzhië xa', nzhab xa': ");
INSERT INTO zcaNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¡Bila' no! ¿Chon nzël lo no Jesús, xa' nzë yezh Nazaret? ¿Chi nzël par lo'xal no? ¡Lë'da nilibe'kal, lu nak Me Nazhon che'n Dios! ");
INSERT INTO zcaNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Orze'se ngalatra' Jesús ngadi'zh mbi mal ze', nzhab Jesús: ―¡Nadi'zhtra'l; biliya' miyi' re'! Orze' milichin mbi mal ze' miyi' re' lo rë nak men, mbaino nguro'i; yent kwan ngali'noi miyi' re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Orze' rë nak xa' nzhin ze', xe mia'n bixa' tuli pur kure', no kidi'zh bixa', tu xa' kun xtu xa': ―¿Xmod nak rë widi'zh re'? ¡Porke kinu xa' poder par nile' xa' mandad lo rë mbi mal, mbaino niliya'i men! ");
INSERT INTO zcaNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","No rë yezh kwa'n nzhin naka'n ze', ñët kwa'n nile' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","No or nguro' Jesús le'n yo' plo nitse'd men widi'zh che'n Dios, no ña Jesús lizh Simón, lë' xna'zha'p Simón nzhakne, dox nzho xlë' xa'; no mina'b bixa' lo Jesús par liwen Me xa' re', ");
INSERT INTO zcaNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","orze' nguzobda' Jesús plo nax me una' re', mbaino mile' Jesús mandad nguro' xlë', mbaino lwega' ngwaxche xa' una' re' par miza' xa' kwa'n gao rë xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Lë' ngubizh ngwa'z, lë' rë men nzhanu rë xa' nzhakne, nizak rë lo yalyizh, orze' migal Jesús tu ga' bixa', no rë bixa' miak. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","No nu nayax men nzhakne nguro' mbi mal laxto', naye nguruzhië rë mbi ze' lo Jesús: ―¡Lu Xga'n Dios! Per Jesús midi'zh nayi' lo rë mbi ze' par nakuzhiëtra'i, porke lë' rë mbi ze' nzhakbe', lë' Jesús nak Krist. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Or ngwanilyuo, nguro' Jesús yezh ze' par nzha Me plo yent cho nak, per rë men kikwa'n Me, no or ngwazhël bixa' Me, gat nzhaklatra' bixa' bi Me xtu plo, ");
INSERT INTO zcaNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","per nzhab Jesús: ―Per más rë yezh plo nzhin men, naki'n yalun widi'zh che'n Dios, kwa'n le' zak laxto' men par gon bixa' xmod yo bixa' plo nile' Dios mandad, porke par kure' mixë'l Dios da yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","No se' nikizë Jesús, ñalu' Jesús widi'zh che'n Dios le'n rë yo' kwa'n nzob lazh men Judea, plo nitse'd men widi'zh che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","No ngol tu ngubizh, nzo Jesús ro' lagún kwa'n lë Genesaret. No nayax men mizhin ze' haxta kiche'p bixa' Jesús por tanta men nzhakla gon widi'zh che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","No ze' une Jesús nzob chop bark ro' nits, yent cho nak le'ne. Lë' rë xa' nak che'ne kizët yex, kwa'n nizen bixa' mbël. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Orze' nkë Jesús le'n tu rë bark re' kwa'n nak che'n Simón, no mina'b Jesús lo Simón, chi Simón xche'pe par le'n nits, orze' nguzob Jesús le'ne, ze' nguzublo kilu' Jesús widi'zh che'n Dios lo rë men. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","No or milox midi'zh Jesús lo rë men nzhin ze', orze' nzhab Me lo Simón: ―Bi'y bark más al xan, plo más na'ch nits; ba' kubi go yex che'n go, zen go mbël. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Orze' nzhab Simón: ―Maestr, dub yë'l kile' no por zen no mbël, no per ni tu ma gat zen no, per lë' go nei, lë'da kubi yex da re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","No or ngulubi bixa'i le'n nits, dox mbël nguzen bixa', haxta nila'rëz yex che'n bixa', por tanta lë' ma ngwaga'. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Orze' milu' bixa' señ lo más rë xpen bixa', rë xa' nzho le'n xtu bark, par gaknu bixa'. Orze' ngoknu bixa', no michizhë bixa' rop bark haxta mer ngaya'zyo'i le'n nits, por tanta zhëi. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","No or une Simón Per kure', orze' nguzuxib xa' lo Jesús, nzhab xa': ―Yubchi lon, Señor, porke lë'da tu men dox nzë'b xki lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Porke Simón Per, no rë xa' kwa'n nzhin kun lë' xa', dox mizheb bixa' por tanta mbël ngwaga'. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Mbaino rop xga'n Zebedeo, Jakob no Juan, rë xa' nikë zhi'n kun Simón, nu bixa' mizheb; per nzhab Jesús lo Simón: ―Nazhebtra'l. Dizde nal re', lë'l kan tu bëd men, nela mbël kwa'n nguzenal ba'. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Orze' ngulo' bixa' bark che'n bixa' le'n nits, mila' bixa' rëi, par nzhakë bixa' tich Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","No tu wëlt nzo Jesús tu yezh kwa'n nzhin ze', lë'chi ze' mizhin tu miyi' kwa'n nizak tu yalyizh lë lepra, dub nak xa' nizake. Or une xa' Jesús, ngo't kuslo xa' lo yuo tuli lo Jesús, orze' guna'b xa' lo Jesús, nzhab xa': ―Señor, chi lë'o nzhaklai, gak tsumbe go da lo yalyizh re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Orze' mitsiga' Jesús ya', migal Me xa' nzhakne re', orze' nzhab Me: ―Nzhaklan mbel lo yalyizh re'. Mbaino mis orze', miak xa' nzhakne re', ");
INSERT INTO zcaNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","orze' nzhab Jesús: ―Yent cho lo di'zhle, maska wa lo ngulëi', par rël xa' lu, no za'l gon kwa'n na'b xa' par ya'n nambe kwerp che'nal, nela xmod nzobni' lo ley kwa'n mila' Dios lo Muisés, nes par ne ngulëi', lë'l mimbe la. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Per zilita' ñët kwa'n nile' Jesús, no dox men nibin par gon widi'zh che'n Jesús, no par liwen Jesús rë xa' nzhakne. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Per ña Jesús rë plo yent cho nak, par nidi'zh Me lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","No ngol tu ngubizh, dub kilu' Jesús widi'zh che'n Dios lo rë men; ze' nzob rë men fariseo kun rë xa' nilu' ley. Rë xa' re' nzë rë yezh che'n rë men Galilea, no rë yezh che'n rë men Judea, mbaino nzho bixa' nzë yezh Jerusalén. No dox kinu Jesús yalnazhon che'n Dios, par liwen Me men nzhakne. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Lë'chi nzhanu pla miyi' tu men nzhakne lo ya, tu xa' nagakt win. No nzhakla bixa' ko bixa' xa' re' le'n yo' plo nzo Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","per nagakt yo bixa' por tanta men nzhin al le'n. Kuze' nkë bixa' yek yo', mixa'l bixa' tu plo par mila bixa' xa' nzhakne re' nali laka plo nzo Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Or une Jesús, dox ñila rë xa' re' Jesús, orze' nzhab Me lo xa' nzhakne re': ―Lë' you, rë kwa'n nzë'b xkil lo Dios, lë'i mizhe' la. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Orze' rë men, rë xa' nilu' ley kun rë men fariseo nguzublo kile' bixa' xigab: “¿Cho xa' re'? Tatu nakap kidi'zh xa' Dios, porke yent cho gak che' rë kwa'n nzë'b xki men lo Dios. ¡Nabtsa Dios gak le'i!” ");
INSERT INTO zcaNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Per lë' Jesús nane la kwan kile' bixa' xigab, kuze' nzhab Me: ―¿Chon tatu xigab dox kile' go por kwa'n nzhapa ba'? ");
INSERT INTO zcaNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Kwan más jwals gapa: “Lë' rë kwa'n nzë'b xkil lo Dios mizhe' la”, o gapa: “Waxche, bizë lizhal”? ");
INSERT INTO zcaNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pwes par ne go, Lë'da nak Xga'n Dios no nak da tu men yizhyuo; Lë' Da kinu yalnazhon par che'n rë kwa'n nzë'b xki men lo Dios. Orze' nzhab Me lo xa' nzhakne re': ―Lë'da kini lol, waxche, gulits kwa'n naxal lo ba', orze' bizë lizhal. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Lwega' ngwaxche xa' nzhakne re' lo rë men, ngulits xa' kwa'n nax xa' lo, orze' ña xa', mbaino kidi'zh xa' nazhon Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","No rë men, xe mia'n bixa' tuli, no nzhab bixa': ―¡Dox nazhon Dios! No nu por tanta mizheb bixa', nzhab bixa': ―Nal une be, mile' Dios rë kwa'n gat ne be. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Or milox ngok rë kure', nguro' Jesús, no une Me tu men nikan dimi che'n rey César, tu miyi' lë Leví, nzob xa' plo ñatix men dimi che'n rey, orze' nzhab Jesús lo xa' re': ―Dikë ticha. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Orze' ngwatso Leví, mila' xa' rë kwa'n kinu xa' ze', nzhakë xa' tich Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Orze' mile' Leví tu lani lizh xa' par Jesús, no nu nayax xa' nikan dimi che'n rey César, tutsa plo nzob bixa' kun Jesús lo mes, mbaino kun más rë xa' kwa'n nichë'l Leví. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Per pla rë men fariseo, kun rë xa' kwa'n nilu' ley; nguzublo kidi'zh bixa' nakap lo rë men che'n Jesús, nzhab bixa': ―¿Chon kiyao go kiyo go, kun rë xa' nikan dimi che'n rey César, mbaino kun rë xa' gat nzhakt ley kwa'n mila' Dios lo Muisés, rë xa' ba' más nzë'b xki lo Dios? ");
INSERT INTO zcaNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Orze' nzhab Jesús: ―Rë men wen gat naki'n ya xa' lo doctor, nab tsa men nzhakne naki'n ya. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Na, gat nzhalta par kwezha rë xa' nile' kwa'n nzhakla Dios; na nzhal par kwezha rë xa' nzë'b xki lo Dios, par la' bixa' rë kwa'n gat lë' nak bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Minabdi'zh pla bixa' lo Jesús, nzhab bixa': ―¿Chon nayax wëlt gat nzhaot rë xpen Juan, or nina'b bixa' lo Dios, no se'ga' rë men che'n rë men fariseo, per rë xpenal, zilita' nzhao bixa' no nzho bixa'? ");
INSERT INTO zcaNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Orze' nzhab Jesús: ―¿Chi zak gab go jwers, nagaot rë men, rë xa' kwa'n nzë jwandang, dub nzhak jwandang che'n miyi' kwa'n nzo xti'zh re'? ");
INSERT INTO zcaNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Per or zhin zhë, yubchi miyi' re' xid rë xpen miyi', orze'se nagaot bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nuska midi'zh Jesús tu kwent re', nzhab Me: ―Yent cho tu men cho' tlë' xab kub xa', par kë' xa' remiend tu xab go'x xa'; porke nazhë'lt kwa'n kub kun kwa'n go'x. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mbaino yent cho tu men ko bin kwa'n laore nguro' le'n tu yeg go'x; porke lë' bin kwa'n laore ngokxao' chëz yeg go'x ze', orze' lë'i xo. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kuze' ñal ko men bin kwa'n laore nguro' le'n yeg kub, par yent chi gake. ");
INSERT INTO zcaNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","No yent cho xa' mië' la nzho bin kwa'n nayan, gakla xa' go xa' kwa'n nax, porke lë' xa' gab: “Más nix kwa'n nayan.” ");
INSERT INTO zcaNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","No tu ngubizh kwa'n nile' men Israel diskans, nzhaded Jesús kun rë men che'n Me plo nzha'n men triu. No por nila'n bixa', nguzublo kikib bixa' do che'ne, no kigo' bixa' lazhe par kiyao bixa'i, ");
INSERT INTO zcaNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","orze' nzhab pla men fariseo lo bixa': ―¿Chon nile' go kwa'n gat ñal, zhë kwa'n nayi' kë men Israel zhi'n? ");
INSERT INTO zcaNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Orze' nzhab Jesús: ―¿Chi nagat go'l go plo nikë kwa'n mile' Dabi tu zhë or mila'n xa' kun rë xpen xa'?, ");
INSERT INTO zcaNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","or nguio xa' le'n yo' che'n Dios par ndao xa' pan kwa'n miza' men par gon lo Dios, no ngwatao xa'i no miza' xa'i gao rë xpen xa', no lë' pan ze' nab tsa rë ngulëi' gak gawe. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","No nu nzhab Jesús lo bixa': ―Na Xga'n Dios mbaino nak da tu men yizhyuo, kinun poder par len mandad, kwan ñal le' men zhë kwa'n nayi' kë men Israel zhi'n. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Or ngol xtu zhë kwa'n nayi' kë men Israel zhi'n, nguio Jesús le'n yo' plo nitse'd men widi'zh che'n Dios, no nguzublo kilu' Jesús widi'zh che'n Dios lo rë men nzhin ze'. Ze' nzo tu miyi' kwa'n ngut tu lad ya' lad direch. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","No ze', nzo pla xa' nilu' ley kun rë men fariseo, kila'ch bixa', nabei chi liwen Jesús xa' re', zhë kwa'n nayi' kë men Israel zhi'n, nes par kinu bixa' tu kwa'n gab bixa', nak Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Per lë' Jesús nane la cho xigab kile' rë men re', kuze' nzhab Jesús lo miyi' nzhakne re': ―Watsuli, guded garol tsao' re'. Orze' ngwatsuli miyi' re', nguzubi xa' lo Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Orze' nzhab Jesús lo rë men kila'ch ze': ―Nzhaklan nabdi'zha tu kwa'n lo go: ¿Kwan más ñal le' met zhë kwa'n nayi' kë men Israel zhi'n? ¿Chi tu kwa'n wene o tu kwa'n male? ¿Chi ko' be tu men lo tu kwa'n nazhe'b nizak xa', o la' be gat xa'? ");
INSERT INTO zcaNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Orze' miwi' Jesús lo rë xa' nzo naka'n plo nzo Me, mbaino nzhab Me lo miyi' ngut ya' re': ―Bitsiga' ya'l. Orze', mitsiga' miyi' ya' miyi', mbaino miake. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Per rë xa' nilu' ley kun rë men fariseo nded niyi'xian bixa', orze' nzhab bixa' lo wech bixa': “Nal, ¿kwan li'nu be Jesús?” ");
INSERT INTO zcaNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Le'n rë ngubizh ze', ngwa Jesús yek tu yi' par guna'b Me lo Dios, orze' dub yë'l guna'b Me lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Or ngwanilyuo, ngurezh Me rë xa' kizikë tich Me, no xid rë xa' re' ngule Me tu dusen rë xa' ngulo'lë Me apost. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tu rë xa' re' lë Simón, xa' kwa'n nu ngurulë Me Per; no xtu xa' lë Ndres, wech Simón; no Jakob mbaino Juan; no Lip, no Tol; ");
INSERT INTO zcaNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","orze' Mateo no Max; mbaino Jakob xga'n Alfeo; no Simón xa' nguio xlad men Kananist; ");
INSERT INTO zcaNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","no Judas, xga'n Jakob; mbaino xtu Judas Iscariote, kwa'n michi Jesús lo rë men kwa'n mbit Me. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Or ngula Jesús yek yi' ze' kun rë men che'n Me, orze' ngulëz Me lo tu lach, no ze' miza tu bëd xa' kizikë tich Me, mbaino nu nayax xa' nzë rë yezh che'n lazh men Judea no rë xa' nzë yezh Jerusalén, kun nayax xa' nzho ro' nitsdo' che'n yezh Tiro mbaino kun rë men yezh Sidón. Rë men re' nzhin par gon bixa' widi'zh che'n Jesús no par liwen Jesús yalyizh che'n bixa'; ");
INSERT INTO zcaNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","no miak rë xa' kwa'n nzhakne por mbi mal. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kuze' rë nak men ze' nzhakla namás gal xa' kwerp che'n Jesús, porke kwerp che'n Jesús niro' rë yalnazhon kwa'n niliwen rë men nzhakne. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Orze' miwi' Jesús lo rë men che'n Me, nzhab Me: ―Rë go, xa' prob nal re', wen nzha go; porke lë' go ya nzho la ya' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’No go, xa' nila'n nal re', wen nzha go, porke lë' Dios ne' kwa'n na'b go lo Me. ’No go, xa' nzho'n nal re', wen nzha go, porke kaxche'ptsa lë' go zak laxto'. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’No wen nzha go, go xa' niyi' men nine nal re', no or nigotin xa' go xid bixa', no or niye xa' go, no nidi'zh xa' go, rë kwa'n gat walit nak go, por nak go men da. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Bizak laxto' go zhë ze', haxta wats go, porke lë' Dios ne' tu kwa'n tsak ka' go por rë kwa'n nilinu men go; porke sa' ska nguzak rë profet, rë xa' kwa'n midi'zh por Dios chi tiemp. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Per zhe'b nalats nzha go, rë go xa' rrik nal re'; porke lë' go kinu la rë kwa'n gap go par dubta'. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’No zhe'b nalats nzha go, rë go xa' ndao la haxta plo une, porke lë' zhë zhin, lox go di yalnila'n. ’Mbaino zhe'b nalats nzha rë go, xa' nizak laxto' nal re', per lë' zhë zhin, lë' go go'n di yalnawin haxta plo nagakra'i. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Zhe'b nalats nzha go, por nidi'zh men dox tsak go nal re'; porke sa' ska midi'zh men lo rë xa' kwa'n chigab walika profet che'n Dios, per ka mbële. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Per rë go xa' nzhon kwa'n nin, bichizhi' go rë xa' nidil go, no bile' go wen lo rë xa' niyi' nine go; ");
INSERT INTO zcaNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","no guna'b go lo Dios, ya bixa' wen, rë xa' kwa'n nizhi'bde go, mbaino nu bina'b go lo Dios por rë xa' kwa'n nile' nakap lo go. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","No cho tu xa' kë' tube ta' ro' go, bila' go ter nu xtu lad kë' xa'i, no chi cho lat chiket che'n go, bila' go wei' xa' ter nu kamis che'n go. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Xa' na'b tu kwa'n lo go, biza' goi, mbaino xa' zen tu kwa'n nak che'n go, nagabt go lo xa' zhire ska xa'i. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Bile' go kun rë men nela xmod nzhakla go le' men kun go. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’No chi nazhi' go nab tsa rë men kwa'n nazhi' go, ¿xmod le' go tu kwa'n wen chi nak go sa'?, porke haxta rë men más nzë'b xki, nak sa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","No chi nile' go wen lo nab tsa rë xa' nile' wen kun go, ¿xmod le' go tu kwa'n wen chi nak go sa'?, porke haxta rë men más nzë'b xki, nak sa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mbaino chi lë' go le' prext kwa'n ka' nab tsa rë men xa' zak go nilu' ka kixe, orze', ¿xmod le' go tu kwa'n wen chi le' go sa'?, porke nu ska haxta rë men más nzë'b xki, nile' bixa' prext kwa'n ka' guchin bixa', orze' kimbëz bixa' zhire ska xa' ze'i. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Per rë go, ñal chizhi' go rë xa' nikwa'n dil kun go, no bile' go wen; no bile' go prext kwa'n ka' men sin nakwëz go kix xa'i, nes par ne' Dios tu kwa'n dox tsak ka' go, no par lu' go nak go xmë'd Dios, Me kwa'n nzho lo yibë', porke Dios nazhi' haxta rë xa' gat niza't xkix lo Dios, no rë xa' minu la yentra' kwan tsak, nazhi' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kuze', naki'n lats laxto' go xtu men nela Xuz go Dios nizine laxto' Me go. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Nagabt go kwan ñal tu xa' nzhap dol, nes par nale' Dios kix go kwa'n nak go; mbaino nana'bt go zakzi Dios xtu men por kwa'n nak xa', nes par Dios nazakzit ska go por xmod nak go. Más wen biya'l laxto' go kwa'n nile' men lo go, nes par Dios che' rë kwa'n nzë'b xki go. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","No biza' go kwa'n ka' men, nes par Dios zilazh mase ka' go, haxta ya'n sobre; nela xmod niza' goi ka' men, se' ska ne' Diose ka' go. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","No nu miza' Jesús tu kwent re': ―¿Chi zak tu men nikal lo, lu' xa' nez lo xtu xa' nikal lo? ¿Gat rop bixa' yachin le'n tu zo? ");
INSERT INTO zcaNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","No yent cho tu men más nzhak lo maestr che'n xa', sino ke or lox tse'd xa', lë' xa' gak nela xa' kwa'n milu'i lo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Chon niwi'l por tu kwa'n nak xtu men, mbaino lë' rë kwa'n más nazhe'b nakal gat niwi'tal? Kure' nak nela tu yix win kwa'n nzho lo wechal, no lë' yix ro kwa'n nzho lol gat niwi'tal. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Chon nzhabal lo wechal: “Bila' kon yix win kwa'n nzho lol re'”, no chi gat nizital, más tu kwa'ro nzho lol? ¡Tatu nazhe'b nakal, chigab walika men wenal! Mejor galo laka ngulo' kwa'n nzho lol ba', nes par gak ko'l kwa'n nzho lo wechal ba'. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’No yent cho tu ya wen za' rë xlë nazu't, mbaino ni rë ya kwa'n nazu't, za' xlë wen, ");
INSERT INTO zcaNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","porke kad ya nakbe' por xlë kwa'n niza'i, porke gat nikant men nzhao' le'n ya yich, no yent cho cho' tu rosim gub lo tu ya zhii'. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Lë' menaye nidi'zh pura rë kwa'n ñal, porke kwa'n wen nzho laxto' xa'; mbaino lë' men nakap nidi'zh pura kwa'n gat lë', porke kure' nzho laxto' xa', porke kwa'n nzho laxto' men, kuze' nidi'zh men. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","No nzhab Jesús: ―¿Chon nine go lon: “Señor, Señor”, mbaino gat nile't go kwa'n nin? ");
INSERT INTO zcaNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nal nin lo go, xmod nak men kwa'n nizubi lon, mbaino nile' xa' kwa'n nzhapa. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nak xa' nela tu men michao' tu yo'. Galo laka nde'n xa' na'ch lo ke, ze' michao' xa' simient che'ne. No or miro'b you', dub jwers nkë nits ta' yo' re', no per ni nangawine, porke lë'i nzob lo ke. ");
INSERT INTO zcaNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Per xa' nzhon xtizha namás, no gat nile't xa' kwa'n nzhapa, nak xa' nela tu xa' michao' tu lizh plo pura yuo, gat nayet nzobe, porke nangachao't xa'i kun simient. No or miro'b you', dub jwers nkë nits ta'i, orze' michil nitse. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","No or milox midi'zh Jesús lo rë men, orze' ña Me yezh Capernaúm. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Yezh re' nibëz tu xa' nile' mandad lo tu gayo' sondad román, kinu xa' tu mos che'n xa', no dox nazhi' xa' mos re'; mbaino nzhakne ne', mer gat ne'. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Or mbin xa' nile' mandad re', kidi'zh men nikizë Jesús gax ze', orze' mixë'l xa' pla xa' nzo lo men Israel, par ngwayab bixa' yi'd Jesús, liwen mos che'n xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","No or mizhin rë xa' re' plo nzo Jesús, garga'l kiyab bixa': —Cha'o ña be par gaknu go xa' nile' mandad ze', ");
INSERT INTO zcaNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","porke dox nazhi' xa' re', rë be men Israel; mbaino lë' xa' re' mizuxkwa' tu yo' plo nitse'd be widi'zh che'n Dios yezh re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Orze' nzha Jesús kun lë' bixa'. Per or nzhazhin la bixa' gax lizh xa' re', orze' mixë'l xa' nile' mandad re' pla rë xa' kwa'n nichë'l xa' par ngwayab bixa' lo Jesús: ―Señor, zit go gat lë', porke gat ñalta da par yi'd go lizha. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kuze' ni nangaye laxto'n ngayal yuba lo go; namás bile' go mandad por xti'zh go, yak mos da. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Porke nu ka da, nzhona ro' xa' nile' mandad lon, no kinu ska men nilen mandad or gapa lo tu xa': “Wa”, lë' xa' ya; no or gapa lo xtu xa': “Dë'”, lë' xa' yë'd. Mbaino or gapa lo tu mos da, le' xa' tu kwa'n, lë'i le' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","No or mbin Jesús widi'zh re', xe mia'n Me, orze' miwi' Me lo rë xa' nzhakë tich Me, no nzhab Me: ―Walika kwa'n nin lo go, per ni tu men Israel gat nen yila widi'zh da nela xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","No or nguiubre rë xa' kwa'n mixë'l xa' nile' mandad re', lë' mos che'n xa' miak la. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","No xtu riyë'l, nzha Jesús tu yezh kwa'n lë Naín kun rë men che'n Me, no nayax men nzhakë tich Me. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","No or nzhazhin Jesús ro' yezh re', lë'chi une Me nzhaka'ch men tu yinto'. No yinto' re', tutsa miyi' nak xga'n tu una' kwa'n ngut xmiyi'. No dox men yezh ze' nzhaka'ch bixa' xga'n una' re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","No or une Jesús una' re', milats laxto' Me una', orze' nzhab Me lo una': ―Nago'ntra'l. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Orze' nguzubi Jesús, migal Jesús ta' kwa'n nzho'b yinto' lo, orze' xe ngulëz rë xa' nzhanu yinto', orze' nzhab Jesús lo yinto': ―Miyi' xi, lë'da ni lol: ¡Waxche! ");
INSERT INTO zcaNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Orze' nguzob miyi' xa' ngut re', mbaino nguzublo kidi'zh miyi', orze' nzhab Jesús lo xna' miyi': “Lë' xga'nal re'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","No or une rë men kure', mizheb bixa', orze' nguzublo kidi'zh bixa' dox nazhon Dios, mbaino nzhab bixa': ―¡Dox tu profet ro, xa' nidi'zh widi'zh che'n Dios, mizhin lo be! No nzhab bixa': —¡Nzatsiwi' Dios rë men che'n Dios! ");
INSERT INTO zcaNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","No rë xa' nzë lazh men Judea kun rë xa' nzho naka'n rë yezh kwa'n ña'n ze', mbin bixa' kwa'n mile' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","No rë xpen Juan ngwayab lo Juan, rë kwa'n nile' Jesús xid rë men, no or ngurezh Juan chop xpen xa', ");
INSERT INTO zcaNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","orze' mixë'l xa' rop rë xa' re' par wayab bixa' lo Jesús: “¿Chi lu ka nak Krist, kwa'n nak di'zh yi'd lo no, o kwëz no yi'd xtu xa'?” ");
INSERT INTO zcaNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","No or mizhin rop xpen Juan re' plo nzo Jesús, orze' nguzubi bixa', nzhab bixa': ―Lë' Juan xa' nililëi' men le'n nits, mixë'l no par nabdi'zh no lol, ¿chi lu ka nak Krist kwa'n nak di'zh yi'd, o kwëz no yi'd xtu xa'? ");
INSERT INTO zcaNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","No mis orze', dox men nzhakne kiliwen Jesús, no nu rë xa' nizak yalnawin, no rë xa' nzho mbi mal laxto', no haxta rë xa' nikal lo, mile' Jesús miwi' bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","orze' nzhab Jesús lo rë xpen Juan: ―Wayab go lo Juan rë kwa'n une go, no rë kwa'n mbin go. Guzh go, lë' rë men nikal lo, niwi'; no rë men nagakt zë, nizë; no rë xa' nizak yalyizh kwa'n lë lepra, nimbe bixa'; no rë men sord, nixa'l nzha; no rë men ngut, niruban; mbaino rë men prob, kiyon widi'zh nazhon che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡No nazhon nzha men yila da dubta'! ");
INSERT INTO zcaNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","No or ña rë xa' mixë'l Juan, orze' nguzublo kidi'zh Jesús kwent che'n Juan lo rë men, nzhab Me: ―¿Cho xa' kwa'n ngwatsi' go lo, plo nak yuo bizh ze'? ¿Chi lo tu xa' ña-ñë'd xigab che'ne, nela yix kwa'n nzhuwei' mbi rë plo? ");
INSERT INTO zcaNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","No chi gat lë't kuba' une go, ¿kwan ska une go orze'? ¿Chi une go tu miyi' nak lar wen? Per nane ka go, cho rë xa' kwa'n nzhak lar wen, rë xa' ze' nzho lizh rë rey, plo nzho bixa' mod nzhakla bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Per cho ska xa' ngwatsi' go lo? ¿Chi ngwatsi' go lo tu men nak profet, xa' nidi'zh por Dios? Na ni, lë' xa' kwa'n ngwatsi' go lo re', más tsak xa' ke lo tu profet, ");
INSERT INTO zcaNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","porke kwent che'n Juan re', nidi'zh Yech che'n Dios or nzhabe se': Biwi', lë Da xë'l xa' di'zh xtizha dilant lol, par kuxkwa' xa' laxto' rë men par gon bixa' ro' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nin lo go, xid rë men yizhyuo, nangayota' tu xa' más tsak lo Juan. Per rë xa' más natsakt, xid rë xa' nzho plo nile' Dios mandad, nak rë xa' kwa'n más tsak lo Juan. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Or mbin rë nak men kure', rë xa' kwa'n mililëi' Juan le'n nits, no haxta rë men nikan dimi che'n rey, milibe' bixa', dox ñal kwa'n nile' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Per rë men fariseo no rë xa' nilu' ley, mile' bixa' naya' lo rë kwa'n ngokla Dios par lë' bixa', porke nangaziyëlt bixa' ngaklëi' bixa' xmod nzhab Juan. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Orze' nzhab Jesús lo rë xa' ze': ―¿Xmod gapa nak rë men nal; nela kun cho chëla bixa'? ");
INSERT INTO zcaNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nak bixa' nela rë mbwin, kwa'n nzhin le'n nez plo nzhak xbi', kiyab mbwin lo wech mbwin kwa'n nzhin ze': “¿Chon nanet go ngolni' go or kiyo'l no bizhi, no ni nango'nt go or kikë' no kant nalats?” ");
INSERT INTO zcaNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Porke mbi'd Juan, xa' nililëi' men le'n nits, gat nzhawt xa' yët no gat nzhot xa' bin, no nzhab go: “Mbi mal nzho laxto' xa'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","No or nzhala, nak da Xga'n Dios mbaino nak da men yizhyuo, nzha̱o̱wa̱ no nzho'n, no ne go: “Biwi', nzhao cho'l, mbaino nzho cho'l kwa'n; no nichë'lal kun rë men nikan dimi che'n rey no kun rë men más nzho'b xti'zh nzë'b xki.” ");
INSERT INTO zcaNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Per bitsila go, rë xa' kwa'n ñila widi'zh che'n Dios, nilu' walika nazhone por xmod naban bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","No ngurezh tu men fariseo Jesús, par gao Jesús lizh xa'; orze' ngwa Jesús, no or nguio Me lizh xa', nguzob Me lo mes. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","No yezh ze' nzho tu una' kwa'n más nzho'b xti'zh dox nzë'b xki. Or mbin una', lë' Jesús nzhatao lizh men fariseo re', orze' mizhinnu una' tu bot win zhëi di aseit nax, mbaino tsak doxe, haxta nu bot kwa'n nzhoi re', dox tsak. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","No or nguzo una' xan ni' Jesús, dub kiyo'n una', orze' migazh una' kun nits nzho'n una' ni' Me, no dub kichiro' una'i, kitsibizh una'i kun yich yek una'; no nu micho'n una' aseit nax ni' Me. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","No or une xa' fariseo ze' kure', xa' kwa'n ngurezh Jesús lizh, mile' xa' xigab: “Chi lë' xa' re' walika nak tu profet, xa' nidi'zh por Dios, lë' xa' nganu la, cho una' kwa'n kigal ni' xa', tu una' zhe'b nzë'b xki.” ");
INSERT INTO zcaNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Orze' nzhab Jesús lo xa' fariseo re': ―Simón, nzhaklan ganin tu kwa'n lol. Orze' nzhab Simón: ―Bineu xkwane, Maestr. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Orze' nzhab Jesús: ―Nguio chop men, nzë'b dimi lo tu xa' kwa'n nile' prexte. Tu xa' nzë'b dimi kwa'n nile' men gan tu li'n garol lo pura zhi'n, lë' xtu xa' nzë'b dimi kwa'n nile' men gan, pas como chop mbëo', di lo zhi'n. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","No nangale't rop xa' gan ngayix bixa'i lo xa' nak che'ne, orze' milats laxto' xa' nak che'n dimi ze' rop xa' ze'. Orze' nzhab Jesús: ―¿Di lo rop xa' ze', cho xa' más nazhi' xa' kwa'n nak che'n dimi ze'? ");
INSERT INTO zcaNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Orze' nzhab Simón: ―Zaka, xa' kwa'n más nayax dimi nzë'b ze'i. Orze' nzhab Jesús: ―Lë'ka kwa'n nel. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Orze' miwi' Jesús lo una' ze', mbaino nzhab Me lo Simón: ―¿Chi niwi'l lo una' re'? Or nguio'n lizhal, nangane'tal nits par yët ni'n, per lë' una' re' migazh ni'n kun nits nzho'n xa', no mitsibizh xa'i kun mis yichyek xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nangachiro'tal ta' kwatsa or mizhi'na lizhal, per una' re', dizde mizhin xa' lon, kichiro' xa' ni'n, no haxta nal stubi kichiro' xa'i. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nangacho'btal aseit nax yeka, per lë' una' re' micho'be ni'n. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kuze' nin lol, lë' rë kwa'n zhe'b nzë'b xki una' re', mizhe' la lo Dios, porke dox nazhi' xa' Dios. Per men kwa'n nagat za' kwent cho pa' xtol xa' miche' Dios, che'p tsa nazhi' xa' re' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Orze' nzhab Jesús lo una' re': ―Lë' rë kwa'n nzë'b xkil lo Dios, lë'i mizhe' la. ");
INSERT INTO zcaNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Orze' rë xa' kwa'n nzhin lo mes ze', nguzublo kiyab bixa' lo wech bixa': ―¿Cho xa' re'? ¡Haxta nu rë kwa'n nzë'b xki men lo Dios, niche' xa'! ");
INSERT INTO zcaNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Per nu nzhab Jesús lo una' re': ―Por ngwayilal da, lë'l nguro' la lo rë kwa'n nazhe'b nzadkë tichal. Nal, dub bizë, bizak laxto'. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","No dispwés di ngok rë kure', nikizë Jesús kun dub tu dusen men che'n Me, nayax yezh no rë rranch win, kidi'zh Jesús widi'zh nazhon che'n Dios par xmod gak men, men che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","No nu zipla una' ngoknu Jesús. Xid rë una' re' nzho una' kwa'n miliwen Jesús yalyizh che'n, kun zipla una' kwa'n ngulo' Jesús mbi mal laxto'. Tu rë una' re' lë Mari Madalén; una' kwa'n nguro' gazh mbi mal laxto'. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","No xtu rë una' re' lë Juan xa' nak una' che'n Chuza, miyi' kwa'n nzo lo rë kwa'n nak che'n gobiernador Herodes; no xtu una' re' lë San; no nguio más rë una' kwa'n ngoknu Jesús kun rë kwa'n nak che'n biuna'. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","No nayax men kwa'n nzho rë yezh kwa'n nzhin naka'n ze', nguro' bixa' par ngwatsi' bixa' lo Jesús, no or migan nayax men plo nzo Jesús, orze' miza' Jesús kwent che'n men nzha'n triu, nzhab Me: ");
INSERT INTO zcaNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Nguro' tu miyi', nzhaya'n xa' lazh triu, no or miche'ch xa' lazhe, plai ngob le'n nez, no milo men loi, mbaino ndao miyine. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","No mase ngob lo yuo ke, no or ngulene, lwega' mibizhe, porke yent gop ze'. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","No mase ngob le'n ya yich, no ngulene junt kun rë ya yich, no ngala't ya yich ngaro'be, orze' ngute. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","No xche'pe ngob lo yuo wen, orze' miro'be, no dox miza'i. Tu lazhe miza' xtu gayo'i dimás. No or milox midi'zh Jesús kure', orze' naye midi'zh Me, nzhab Me: ―¡Chi lë'l mbine, bizobyeke! ");
INSERT INTO zcaNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Orze' minabdi'zh rë men che'n Me lo Me, nzhab bixa': —¿Kwan gab kwent kwa'n miza' go ba'? ");
INSERT INTO zcaNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Orze' nzhab Jesús: ―Lo go nin rë kwa'n naga'ch kwa'n kinu Dios plo nile' Dios mandad; per lo más men nidizha kun pura kwent lo bixa', par ne bixa'i, per nangalibe't bixa'i; no par gon bixa'i, per nangazobyekt bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","No nzhab Jesús: —No nal, lë'da ni lo go kwan gab kwent ba'. Lë' widi'zh che'n Dios nak nela lazh kwa'n nzha'n men. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Lë' lazh triu kwa'n ngob le'n nez, nak nela tu men kwa'n mbin widi'zh che'n Dios, per ña Mizhab nizubchiy laxto' xa', par nayila xa'i, no par naro' xa' lo kwa'n nazhe'b nzho xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","No lë' kwa'n ngob lo yuo ke, nak nela men mbin widi'zh che'n Dios, no ngwayila xa'i, nizak laxto' xa', per gat nzot xa' naye lo che'n Dios. Ñila xa'i che'p, per or nizak xa' tu kwa'n nazhe'b, orze' nila' xa' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mbaino lë' lazh triu kwa'n ngob le'n ya yich, nak rë men mbin widi'zh che'n Dios, per che'p ga' che'p ga', ña'l laxto' xa'i, por rë xigab kwa'n nile' xa', xmod ban xa', mbaino por ño laxto' xa' le' xa' kwa'n nzhakla xa', no por niwix xa' gap xa' dimi; kuze' gat nile't xa' kwa'n nzhakla Dios le' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mbaino lë' lazh triu kwa'n ngob le'n yuo wen, nak nela men kwa'n mbin widi'zh che'n Dios kun dub laxto' xa', no ngwayila xa'i, no mia'ne laxto' xa'. Mbaino ter nizak xa' rë kwa'n nazhe'b, per nile' xa' rë kwa'n nzhakla Dios le' xa'. Orze' nak xa' nela tu ya xlë, kwa'n dox niza' xlë wen. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","No nu nzhab Jesús: ―Yent cho tsinki tu biani no tsao' xa' loi, o zob xa'i lo yuo xan lo'n, sino ke al ya zob xa'i, par ziniy lo rë xa' yo le'n yo', ");
INSERT INTO zcaNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","porke yent tu kwa'n naga'ch, naro' al tich; no ni kwa'n xla'n, naded gon men, sino ke rëi ro' al tich. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Kuze', biwi' go xmod le' go, por rë kwa'n nidizha lo go; porke rë xa' kwa'n nzhakla zobyek, mbaino le' rë kwa'n nidizha, rë xa' re' xa' nzhaknu Dios, par más zobyek bixa'i; per xa' gat nzhaklat be's zobyek kwa'n nidizha, haxta che'p tsa kwa'n nile' xa' xigab, ya nane la xa', per lë'i yubchi lo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Orze' nzha xna' Jesús, kun rë wech Jesús plo nzo Me, per nangakt ngazubi bixa' lo Me, porke dox nayax men nzhin ze', ");
INSERT INTO zcaNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","orze' ngwayab tu men lo Jesús: ―Lë' xna' go mbaino rë wech go nzo al tich, nzhakla bixa' di'zh bixa' kun go. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Per nzhab Jesús: ―Lë' xna'n mbaino rë wecha, nak rë xa' kwa'n nzhon widi'zh che'n Dios, mbaino nile' bixa' kwa'n nzhakla Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tu ngubizh, nkë Jesús le'n tu bark kun rë men che'n Me, no nzhab Me: ―Chao' nzha be xtu ro' nits. Orze' nzha bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","No or nzha la bixa' le'n nits, no nguzen mika'l Jesús, lë'chi nguzublo tu yiubi nazhe'b le'n nits, orze' nguzublo nguio nits le'n bark, no mer ya'zyo'i. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Orze' ngwalixche bixa' Jesús, nzhab bixa': ―¡Maestr, Maestr, lë' bark nzhakla ya'zyo' le'n nits! Orze' ngwaxche Jesús, no naye midi'zh Me lo mbi, no lo rë bol che'n nits, no ngulëz yiubi, xe mia'n rëi. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Orze' nzhab Jesús lo rë men che'n Me: ―Ñal más yila go da. Per rë bixa' mizheb, no xe mia'n bixa' tuli, orze' nzhab bixa' lo wech bixa': ―¿Cho xa' re'? ¡Haxta lo mbi, no lo nits nidi'zh xa', mbaino nzhone kwa'n nzhab xa'! ");
INSERT INTO zcaNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Orze' mizhin bixa' lazh men Gadara, kwa'n nzhin xtu ro' nits dilant lazh men Galilea. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","No or ngula Jesús bark, orze' nguzubi tu men yezh ze' lo Jesús, tu xa' kwa'n dox nzhala nzho mbi mal laxto'. No kache' xa', mbaino ni gat nzho xa' lizh xa', le'n panteón nzho xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","No or une xa' Jesús, nguzuxib xa' lo Jesús, no naye nguruzhië xa', nzhab xa': ―¿Kwan nizakal kuda, Jesús Xga'n Dios, Me nzho lo yibë'? ¡Kina'ba lol, zakzital da! ");
INSERT INTO zcaNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Se' nzhab mbi mal ze' lo Jesús, porke lë' Jesús mile' mandad, par liya' mbi mal ze' miyi' re'. Nayax wëlt, nilinu rë mbi re' miyi' re' kwa'n nzhaklai, no ter nili'b men ya' xa', no ni' xa' kun kaden, no ter nikina men xa' par nayent plo ya xa', per nicho' xa' kaden, nixëk xa', orze' nizhinu rë mbi mal xa', plo niyent cho nak. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Orze' nzhab Jesús lo xa' re': ―¿Xmod lël? Orze' nzhab xa': ―Lë'da lë Legión. Se' nzhab xa', porke dox nayax mbi mal nzho laxto' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","No nzhab rë mbi mal ze' lo Jesús: ―Naxë'ltal no, plo nazhe'b na'ch no nakao. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","No ze' nzhin nayax kuch, kiyao ma ta' tu lom, no guna'b rë mbi mal ze', la' Jesús biy le'n rë kuch kwa'n nzhin ze', orze' nguziyël Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Orze' nguro' rë mbi mal laxto' miyi' re', par ñai le'n rë kuch, orze' mikë' bima karre, ngula bima ro' bilë' plo nak ro' nits, ze' ngwap rë kuch. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","No rë xa' kwa'n kikina rë kuch re', or une bixa' kure', mikë' bixa' karre, ngwayab bixa'i lo rë men yezh ze', no lo rë xa' nzho dan. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Orze' rë men ngwatswi', por kwan mbin xa' ngok re'; or mizhin men plo nzo Jesús, une bixa' miyi' kwa'n nzhak miyizh ze', lë' xa' wen la, mbaino nak xab la xa', nzob xa' xan ni' Jesús, orze' rë men mizheb tuli. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","No rop xa' kwa'n une, xmod uniwen xa' kwa'n ngok miyizh ze', midi'zh bixa'i, lo más rë men kwa'n ngwatswi' ze', ");
INSERT INTO zcaNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","kuze' guna'b rë nak men, kwa'n nzho rë yezh kwa'n ña'n lazh men Gadara, nzhab bixa', ro' Jesús ze', porke dox nizheb bixa' lo Jesús. Orze' nkë Jesús le'n bark, par ña Me kun rë men che'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","No miyi' kwa'n miliya' mbi mal ze', guna'b xa' lo Jesús, yakë xa' tich Jesús; per nzhab Jesús lo xa': ");
INSERT INTO zcaNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Biyëk lizhal, no guzh lo rë men, rë kwa'n mile' Dios kun lu. Orze' ña miyi' ze', dub lazh men Gadara, midi'zh xa', lë' Jesús miliwen xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","No or miëk Jesús di xtu ro' nits, rë men nzhin ze', nizak laxto' or mizhin Jesús lo bixa', porke lë' bixa' kimbëz lo la. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Lë'chi, ze' mizhin tu xa' lë Jairo, nak xa' tu men xa' nile' mandad le'n yo' plo nitse'd men widi'zh che'n Dios, orze' tuli nguzuxib xa' xan ni' Jesús, kina'b xa' ya Jesús lizh xa', ");
INSERT INTO zcaNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","porke mer gat, tutsa xcha'pye'n xa' kwa'n nzhap xa', nzhap la më'd tu dusen li'n. No dub nzha Jesús lizh më'd re', nayax men nzhakë tich Me, haxta kigotip men Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Xid rë men re', nzho tu una' kwa'n nzhakne, nzhala tu dusen li'n nizak xa' kwa'n. Milo'x xa' rë kwa'n kinu xa', lo rë doctor, no yent cho doctor ngaliwen xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","No nguzubi una' re' al tich Jesús, par migal una' punt xab Me, no mis orze' ngulëz ren kwa'n nizak una'. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Orze' nzhab Jesús: ―¿Cho migal ta'n? Rë men nzhab, yent cho migale, orze' nzhab Per: ―Maestr, ka rë men kitao'w go, no kiche'p xa' go rë lad. ¿Chon kinabdi'zh go: “Cho migal da”? ");
INSERT INTO zcaNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Per garga'l nzhab Jesús: ―Nzho ka cho migal ta'n, lë' da mizi, por yalnazhon kwa'n kinun, lë' tu men miak. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","No or une una' re', nagaktra' ka'ch una' kure', maska nixiz una', nguzuxib una' xan ni' Jesús, no mixë'l ro' una' lo rë men, nzhab una': —Na migal punt xab Jesús, mbaino lwega' miak da. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Orze' nzhab Jesús: ―Xcha'p, lë'l ngokwen la por ngwayilal da, nal bizë, no bizak laxto'. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Stubi ra' kidi'zh Jesús, orze' mizhin tu xa' kwa'n nzho lizh Jairo, nzhab xa' lo Jairo: ―Lë' mizhwin che'nal ngut la; bila' nayi'dnutra'l Maestr. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","No or mbin Jesús kure', orze' nzhab Me lo Jairo: ―Nazhebtal, na gaknu mizhwin, lë' mizhwin che'nal yak ka. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","No or mizhin bixa' lizh Jairo, yentra' cho ngala' Jesús ngaded al le'n, nab tsa Per no Jakob mbaino Juan no xuz mizhwin, kun xna' mizhwin nguio al le'n. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","No maska kiyo'n rë men di yalnawin, kigal bixa' laz bixa' por mizhwin re', per nzhab Jesús lo rë men: ―Nagontra' go; gat lë't ngut mizhwin, lë' mizhwin ka naxnaa. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Per kixizhnu rë men Jesús, porke nane bixa' lë' mizhwin ngut la. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Orze' nguzen Jesús ya' mizhwin, no naye nzhab Me: ―¡Mizhwina, waxche! ");
INSERT INTO zcaNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Orze' nguruban mizhwin, no tuli ngwaxche mizhwin; mbaino mile' Jesús mandad, za' bixa' kwa'n gao mizhwin re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Orze' xe mia'n rop xa' nak xine re' tuli, per mile' Jesús mandad, yent cho lo di'zh bixa' kwa'n ngok re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","No mizhin Jesús dub tu dusen men che'n Me, par miza' Me yalnazhon nka' bixa', par le' bixa' mandad lo rë mbi mal, mbaino par liwen bixa' rë men nzhakne; ");
INSERT INTO zcaNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","no mixë'l Jesús bixa' par di'zh bixa' lo rë men, xmod gak men, men che'n Dios, no par liwen bixa' rë lo yalyizh, ");
INSERT INTO zcaNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","mbaino nzhab Jesús lo bixa': ―Yent kwa'n wei' go nez; nawei't go ni tu bar, ni tu bols, no ni yët, mbaino ni dimi, no lar nak tsa go bi'y go namás. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","No or zhin go kwalisquier tu lizh men, plo wi' bixa' wen lo go, ze' biya'n go haxta or ya go xtu plo, ro' go ze'. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","No wanei tu plo nawi' men wen lo go, guro' go ze', guzhi'b go ni' go lo rë men yezh ze', nela tu señ ga', lë' bixa' mile' naya' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Orze' ngwa bixa' rë nak yezh win, kwa'n nzhin naka'n ze', midi'zh bixa' widi'zh nazhon che'n Dios, no miliwen bixa' rë men nzhakne. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Or mbin gobiernador Herodes rë kwa'n kile' Jesús, orze' dox xigab nguzob yek Herodes, porke nzho men nidi'zh, lë' Juan nguruban, ");
INSERT INTO zcaNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","más men nidi'zh ka profet Li nguruban, mbaino nzho men nidi'zh, ka tu rë profet xa' tiemp nguruban, ");
INSERT INTO zcaNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","per nzhab Herodes: ―Na mile' mandad, miro'g yek Juan, ¿per cho ska xa' kwa'n nidi'zh men, xa' nzhona nile' rë kuba'? Kuze' dox nzhakla Herodes ne xa' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","No or miëk rë apost, miza' bixa' kwent lo Jesús rë nak kwa'n mile' bixa', orze' nzhanu Jesús bixa' tu lad di ro' yezh kwa'n lë Betsaida. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Per or mbin rë men plo nzha Jesús, rë bixa' ngwakë. No milats laxto' Me rë men ze'. Midi'zh Jesús lo bixa', xmod gak bixa' men che'n Dios, no miliwen Jesús rë nak men nzhakne nzho xid bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","No or nzhazhëlyuo, dub tu dusen men che'n Jesús, nguzubi bixa' lo Me, nzhab bixa': ―Bi rë men re', guzh go, par yakwa'n bixa' plo ga' bixa', no kwa'n gao bixa', ya bixa' rë rranch no rë yezh kwa'n ña'n gax re', porke plo nzhin be re', yent kwan nak. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Per nzhab Jesús: ―¡Biza' go kwa'n gao rë men re'! Orze' nzhab bixa': ―Gai'tsa yët kinu no, no choptsa mbël, o ¿chi yazi' no kwa'n gao rë men re'? ");
INSERT INTO zcaNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nzhin ze' pas tu gai' mil men nab tsa miyi'. Per nzhab Jesús lo rë men che'n Jesús: ―Guzh go zob rë men, cho' bichi'ga' bixa' bizhin go. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Orze' mile' bixa' nguzob men. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Orze' nguzen Jesús za gai' yët kun rop mbël ze', miwi' Me lo yibë' miza' Me xkix lo Dios por kwa'n gao bixa', orze' michi'x Mei, miza' Mei ka' rë men che'n Me, par lë' bixa' ki'ze gao rë men. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Rë nak men ze' ndao, haxta plo ngwazhë bixa'; no or milox ndao bixa', mikan rë men che'n Jesús, tu dusen kardor kwa'n mia'n sobr lo kwa'n ndao bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","No ngol tu ngubizh, nab Jesús kina'b lo Dios, no rë men che'n Me nzhin kun lë' Me, orze' nzhab Me lo bixa': ―¿Cho da nzhab men? ");
INSERT INTO zcaNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Orze' nzhab rë men che'n Me: ―Pla men nidi'zh, lu nak Juan xa' nililëi' men le'n nits, más men nidi'zh, lu nak Li, no nzho men nidi'zh lu nak tu rë profet xa' tiemp nguruban. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Orze' nzhab Jesús lo bixa': ―Mbai go ga', ¿cho da par go? Orze' nzhab Per: ―Go nak Krist Me mixë'l Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Orze' dox mika'b Jesús, nadi'zht bixa' kure', ");
INSERT INTO zcaNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","No nzhab Me: ―Na Xga'n Dios no nak da tu men yizhyuo, dox naki'n zakzi da; mbaino nayilat rë xa' kwa'n nak zhi'n, xid rë men Israel da, no ni rë xa' nile' mandad lo rë ngulëi', mbaino ni rë xa' kwa'n nilu' ley, nayilat da; no mis rë xa' re' le' mandad gat da, per ngubizh yon lë'da ruban. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","No nzhab Jesús lo rë nak men nzhin ze': ―Chi tu go nzhakla gak xpena, naki'n ya'l laxto' go rë kwa'n nzhakla go le' go, par le' go kwa'n nzhaklan, mbaino nazolia'zht go (le't go naya') or naki'n zakzi go, haxta ter gat go por da, ");
INSERT INTO zcaNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","porke xa' gat nzhaklat gak xa' men da par le' xa' kwa'n nzhakla xa', orze' mila' xa' kwa'n ban xa' par dubta' lo Dios; per xa' la' kwa'n nzhakla xa' le' xa', por nak xa' men da, orze' lë' xa' ban par dubta' lo Dios, ");
INSERT INTO zcaNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","porke, yent kwan zu' par tu men, ka' xa' rë nak kwa'n nzho yizhyuo, por mile' xa' kwa'n nzhakla xa', no or gat xa', lë' xa' lox lo Dios par dubta'. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Chi tu go le' naya' lon no lo rë widi'zh da, nu ska da le naya', nawi'ta' lo go, or yala kun biani da kwa'n más ke ngubizh, mbaino kun biani che'n Xuza, no che'n rë ganj nazhon che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","No walika kwa'n nin lo go, nzho pla xa' xid go nalre', nagata' xa' antis dike ne bixa', xmod nile' Dios mandad kun yalnazhon che'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nzha xon ngubizh di midi'zh Jesús kure', orze' nzha Me yek tu yi' par na'b Me lo Dios, no nzhanu Me Per kun Juan no Jakob. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","No or kina'b Me lo Dios, orze' ngubixlo lo Me; no xab Me milu' bëo laka, no ña'zbële. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Lë'chi nguruxo'b xchop miyi', kidi'zh bixa' kun Jesús. Tu xa' re' Muisés, no xtu xa' Li. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","No nzhin bixa' le'n tu biani maska ña'zbël, kidi'zh bixa' rë kwa'n mizhin la zak Jesús yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","No Per kun xchop xa' kwa'n nzo kun lë' xa', dub nzë mika'l lo bixa', mixek bixa' nanga't bixa', no une bixa' biani kwa'n maska ña'zbël che'n Jesús, kun xchop xa' kwa'n nzo kun Jesús re'; ");
INSERT INTO zcaNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","no or nguiubchi rë xa' ze' lo Jesús, orze' nzhab Per lo Jesús: ―Maestr, ¡zhe'b wen nzhin be re'! Bila' go chao' no chon yo' yix; tube par go, xtube par Muisés, no xtube par Li. Se' midi'zh Per porke gat naya't Per par di'zh Per. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","No dub kidi'zh Per, mbi'd tu xkao, ngulai plo nzhin yon bixa', orze' mizheb bixa' nzho bixa' le'n xkao re', ");
INSERT INTO zcaNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","no mbin bixa' le'n xkao re', nguro' tu widi'zh kwa'n nzhab se': ―¡Xa' re' nak Xga'na Me nazhi' da, no Me ngulen nak Krist; bile' go kwa'n ne Me! ");
INSERT INTO zcaNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","No or milox mbin bixa' widi'zh ze', une bixa' lë' nab Jesús nzo, orze' nab bixa' nane kure', le'n rë ngubizh ze', yent cho lo ngadi'zh bixa' kwa'n une bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","No xtu riyë'l, or ngula bixa' yek lom ze', nayax men nzhachëlo Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","lë'chi xid rë men re' nguro' tu miyi' nibizhyë naye, nzhab xa' lo Jesús: ―Maestr, kina'ba lol, liwenal xmë'da re', porke tutsa mbwin re' nzhapa. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nizen tu mbi mal mbwin, nikuzhiëi mbwin, no nile'i dox nixiz mbwin, no niro' bichi'n ro' mbwin, orze' pe'n nila'i mbwin. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Dox la nzhapne lo rë xpenal par ko' bixa' mbi mal re', per nangale't bixa' gan ngaro'i. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Orze' nzhab Jesús lo rë men ze': ―¡Taxa nagat yila go kwa'n nin lo go! ¡Tatu nad go par yila go rë kwa'n wen che'n Dios! ¡Dox kixek da lo go, nagat zobyek go kwa'n nin lo go! Orze' nzhab Jesús: ―¡Dinu xmë'dal re'! ");
INSERT INTO zcaNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","No or nguzubi mbwin lo Jesús, milichin mbi mal re' mbwin, mbaino maska nixiz mbwin; per ngulo' Jesús mbi mal re' laxto' mbwin, miliwen Jesús mbwin, orze' nzhab Jesús lo xuz mbwin: “Lë' xmë'dal re'”. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","No rë men xe mia'n bixa' tuli, or une bixa' yalnazhon ro kwa'n mile' Dios. Dub niwi' rë men kwa'n mile' Jesús, orze' nzhab Jesús lo rë men che'n Me: ");
INSERT INTO zcaNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Bizobyek go kure', no naya'lt laxto' goi: Na nak Xga'n Dios, no nak da tu men yizhyuo, lë' men chi Da lo rë men niyi' nine da par gut bixa' Da. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Per nangazobyekt bixa' kwa'n nzhab Jesús, porke stubi gat xa'l yek bixa', par ne bixa' kwane; mbaino nu nizheb bixa' nabdi'zh bixa', kwan gab widi'zh ba' lo Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","No nguzublo kichëlro' rë men che'n Jesús par nabei, ¿cho xa' gak más xa' tsak xid bixa'?, ");
INSERT INTO zcaNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","per lwega' mizi Jesús cho xigab kile' bixa', orze' nguzen Me tu më'd win, no mizo Me më'd ta' Me, ");
INSERT INTO zcaNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","orze' nzhab Me: ―Men kwa'n niwi' wen lo më'd win re' por nak më'd men da, pwes lon niwi' xa' wen; no xa' kwa'n niwi' wen lon, lo Xuza, Me mixë'l da, niwi' xa' wen lo. Kuze' men yent kwan tsak xid go, xa' ze' xa' más tsak lo go. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Orze' nzhab Juan lo Jesús: ―Maestr, une no tu xa' kigotin mbi mal laxto' tu men por lël, no nzhab no lo xa' nale'tra' xa'i, porke gat nikizët xa' kun be. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Orze' nzhab Jesús: ―Bila' go kile' xa'i, porke xa' gat niyi' nine be, lad che'n be nzho xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","No or nzhazhin la zhë, bi Jesús lo yibë', mbaino ter nane la Me rë kwa'n zak Me yezh Jerusalén, per tutsa xigab mile' Me, lë' Me ya ka yezh Jerusalén, ");
INSERT INTO zcaNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","orze' mixë'l Me pla men che'n Me par ya bixa' tu rë yezh lazh men Samaria, yakwa'n bixa' plo ya'n bixa' kun lë' Me. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Per rë men Samaria, nangaza't bixa' plo ya'n Jesús kun rë men che'n, porke nane bixa', lë' Jesús kile' xigab ya par yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Orze' nzhab Jakob kun Juan lo Jesús: ―Señor, ¿chi ziyël go na'b no lo Dios, gab bël lo yibë', par lo'xe rë men re'? ");
INSERT INTO zcaNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Orze' miëk Jesús, miwi' Me lo bixa', orze' nzhab Jesús: ―¡Nanet go cho rë mbi mal nzo lo go, par kidi'zh go kuba'! ");
INSERT INTO zcaNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Na Xga'n Dios, no nu tu men yizhyuo da, nangayalta par loxa men; na nzhal, par kon men lo rë kwa'n nazhe'b, nzadkë tich men. Orze' ña bixa' xtu yezh win. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Or nzha bixa' nez, nzhab tu miyi' lo Jesús: ―Señor, nzhaklan yi'dkë'n tichal, rë plo yal. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Orze' nzhab Jesús: ―Lë' mbëz kinu ma lizh ma, no lë' rë miyin kinu yo che'n, per na Xga'n Dios, mbaino nak da tu men yizhyuo, per gat kinuta' ni plo ga'n. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","No nzhab Jesús lo xtu xa': ―Di'kë ticha. Orze' nzhab xa' re': ―Señor, bila' go galo laka nzhakacha xuza. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Orze' nzhab Jesús: ―Kwa'n más naki'n le'l nal re', wadi'zh lo rë men, xmod gak bixa' men che'n Dios, no bila' yaka'ch rë xa' nak nela mengut ga', tsa' mengut bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Xtu men nzhab lo Jesús: ―Señor, nzhaklan yi'dkë'n tichal, per bila' galo, yayapne lo rë xa' lizha. ");
INSERT INTO zcaNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Orze' nzhab Jesús: ―Nagakt gak men tu men che'n Dios, or nak xa' nela tu men nzha'n, xa' nazu't. Xa' kwa'n nile' rrëi yuo mbaino yëk xa' al tich xa', orze' lë' rrëi che'n xa' xub. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Or milox midi'zh Jesús rë kure', ngule Jesús zi xchon gal nzho chi' men par mixë'l Me chop ga' bixa' nez plo ya Me, rë yezh no rë plo nak di'zh ya Me, ");
INSERT INTO zcaNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","no nzhab Jesús lo bixa': ―Walika, dox nayax yalgo'n, per rë xa' nikan yalgo'n, pla tsa bixa'; kuze' bina'b go lo xa' nak che'n yalgo'n par xë'l xa' más xa' kan yalgo'n. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Wa go nal, biwi' go lë'da mixël go, nela mbëkxi'l xid rë xa' nak nela ma nazhe'b ga'. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nawei't go ni tu bols, no ni dimi, ni xtu nez yalyid che'n go; no ni nakwëz go nez, di'zhnu go men. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Or yo go lizh tu men, galo laka se' guzh go: “Dios le', kwin men chul xa' nzho re'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","No chi ze' nzho men, xa' ño laxto' wi' Dios wen lo xa', orze' lë' kwan midi'zh go ya'n par lë' xa'; per chi nayo laxto' xa', wi' Dios wen lo xa', orze' lë' kwa'n nazhon kwa'n midi'zh go, naya'nte lo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Biya'n go yo' plo wi' men wen lo go, no dao go no gu' go rë kwa'n ne' xa', porke xa' nikë zhi'n, ñal gax ka' xa'; no naya'nt go tu yo' xtu yo', mbaino tutsa plo biya'n go haxta or ro' go, ya go xtu plo. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","No or zhin go yezh plo wi' men wen lo go, dao go kwa'n ne' xa', ");
INSERT INTO zcaNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","no biliwen go rë nak men nzhakne nzho ze', no guzh go lo men, le' zhë mizhin la, gak xa' men che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Per chi zhin go tu yezh plo nawi' men wen lo go, guro' go nez, no guzh go: ");
INSERT INTO zcaNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Haxta zhen yuo lazh go, kwa'n nkë ni' no, nal lë'i kwib no par ne go, lë' go mile' naya' lo Dios; per bin go kure', lë' zhë mizhin la gak rë men, men che'n Dios, per go nagakt goi.” ");
INSERT INTO zcaNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kuze' kinin lo go, or gab Dios xmod gak kun kad men yizhyuo, más zakzi rë men yezh re', ke rë men yezh Sodoma. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","No nu nzhab Jesús: ―¡Zhe'b nalats nzha go, men yezh Corazín, kun rë men yezh Betsaida! Dox mile' Dios kwa'n nazhon xid go, ¡per yent kwan ngazu'i par go! No chi rë men yezh Tiro kun rë men yezh Sidón ngane rë yalnazhon ba', orze' lë' bixa' ngayila Dios, no ngak bixa' lar nagats, no ngazob bixa' le'n kubde, par lu' bixa', lë' bixa' nizi, nzë'b xki bixa' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kuze', or gab Dios xmod gak kun kad men yizhyuo, más zakzi Dios go, ke rë men yezh Tiro kun yezh Sidón. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","No rë go, men yezh Capernaúm, ¿chi nile' go xigab, bi go lo yibë' plo nzho Dios? Per nabit go, sino ke, ¡lë' go bi le'n gabil! ");
INSERT INTO zcaNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Orze' nzhab Jesús lo rë men che'n Me: ―Rë xa' yila kwa'n di'zh go, orze' na ngwayila xa'; mbaino xa' nangayilat kwa'n di'zh go, orze' na nangayilat xa'; no xa' nangayilat da, orze' nangayilat xa' Xuza, Me kwa'n mixë'l da. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","No za chon gal nzho chi' xa' kwa'n mixë'l Jesús, nguiubre bixa', nizak laxto' bixa', nzhab bixa': ―Señor, haxta rë mbi mal nzhon ro' no, or nize't no lë go. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Orze' nzhab Jesús lo bixa': ―Walikai, porke na une lë' Mizhab ngob lo yibë', nela tu do'zi' ga'. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Biwi' go, na mine' kwa'n ka' go par le' go mandad lo rë mbi mal, kwa'n nak nela mbë'l nayi' ga' mbaino nela nixguy nayi' ga', nes par le' go, che'ptsa (bi'ch laka) gak Mizhab lo go, mbaino yent kwa'n zak go. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Per nazakt laxto' go por nzhon mbi mal ro' go; más wen bizak laxto' go, lë' lë go nzobni' la lo yibë'. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Orze' mile' Sprit che'n Dios, dox nizak laxto' Jesús, orze' nzhab Me: ―Payë', dox nazhonal, Lu Me nile' mandad lo yibë' no lo yizhyuo, porke nguluka'chal rë kure' lo rë men natsin, no lo rë men nzhak; mbaino milu'le lo rë xa' nak nela më'd ga'. Sa' mile'l Payë', porke sa' nguio laxto'l. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Orze' nzhab Jesús lo rë men nzhin ze': —Lë' Xuza mine' rë nak kwa'n kinu Me kan. Mbaino yent cho nane cho Da, nab tsa Xuza nanei. No yent cho nane cho nak Xuza, nab tsa Da nanei, no nab tsa rë xa' nzhaklan lun, cho nak Xuza, lë' bixa' nei. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Orze' miëk Jesús, no miwi' Me lo nab tsa rë men che'n Me, orze' nzhab Me: ―Wen nzha go, por milu' Dios lo go, rë nak kwa'n kiyak nal re', ");
INSERT INTO zcaNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","porke nin lo go, nayax rë profet, xa' midi'zh por Dios chi tiemp, kun rë xa' ngok rey; dox ngokla bixa' ngane bixa' kwa'n une go nal re', per nanganet bixa'i; no ngokla bixa' ngon bixa', kwa'n mbin go nal re', per nangont bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Lë'chi nguzubi tu xa' nilu' ley lo Jesús, par zenbe' xa' Jesús (wi' xa' xmod nak Jesús), nabei chi walika nzhak Me, kuze' nzhab xa': ―Maestr, ¿xmod len par ban da dubta' lo Dios? ");
INSERT INTO zcaNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Orze' nzhab Jesús: ―¿Kwan nzobni' lo ley, mbaino xmod nizobyekle? ");
INSERT INTO zcaNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Orze' nzhab xa' nilu' ley ze': ―“Bichizhi' Dios che'nal, dub laxto'l, no kun dub lal, mbaino kun rë jwers che'nal, no kun rë xigab che'nal. No bichizhi' xtu men nela lu ka.” ");
INSERT INTO zcaNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Orze' nzhab Jesús: ―Wenka kwa'n nel; chi lë'l le' kuba', lë'l ban lo Dios par dubta'. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Per xa' nilu' ley ze', nzhakla namás par gab men, dox nzhak xa', kuze' nzhab xa': ―¿Cho xa' ñal chizhi' da, nela da ka? ");
INSERT INTO zcaNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Orze' nzhab Jesús: ―Tu miyi' nguro' yezh Jerusalén par nzha xa' yezh Jericó, no nez nguro' pla wa'n lo xa', kwa'n milat rë che'n xa', haxta xab xa'; no ndin wa'n xa', orze' pe'n nak xa' mila' wa'n xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Orze', lë'ska nez plo nax xa' re', nded tu ngulëi', no or une ngulëi' miyi' miwe' re', maska nded nka'n ngulëi', ña ngulëi'. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Se'ska xtu xa' kwa'n nzhaknu ngulëi', or une xa', lë' miyi' re' naxbi, nu ska xa' maska nded nez xa', ña xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Per nded xtu xa' nez ze', tu xa' nzë lazh men Samaria. Or une xa', miyi' naxbi re', milats laxto' xa' miyi' re', ");
INSERT INTO zcaNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","orze' nguzubi xa' lo miyi' re', no mile' xa' rumed plo miwe' xa' re' kun aseit no kun bin; no michël xa' lar plo miwe' xa' re', orze' mixo'b xa' miyi' re', tich ma che'n xa', par mbiy' xa' xa' re' tu plo ya'n xa'; ze' mikina xa' miyi' re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","No xtu riyë'l, ngulo' xa' kwa'n nile' tu men gan, che'n chop ngubizh lo zhi'n, miza' xa'i ka' xa' nak che'n yo' ze', orze' nzhab xa': “Bikina miyi' re', no chi lë'l le' gaxt más dimi por lë' xa', or yubren, kixne.” ");
INSERT INTO zcaNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Orze' nzhab Jesús lo xa' nilu' ley re': ―No nal, di lo yon xa' re', ¿cho xa' kwa'n michizhi' xa' kwa'n undin wa'n ze', nela lë'ka xa'? ");
INSERT INTO zcaNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Orze' nzhab xa' nilu' ley re': ―Xa' kwa'n milats laxto' men kwa'n ndin wa'n ze'i. Orze' nzhab Jesús lo xa': ―Bizë, no sa' ska bile'. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","No or nzha Jesús nez kun rë men che'n Me, mizhin Me tu yezh win, ze' nibëz tu una' lë Mart, no ngurezh una' Jesús lizh una'. ");
INSERT INTO zcaNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mart kinu tu bël lë Mari. Or mizhin Jesús, nguzubi Mari xan ni' Jesús par kiyon Mari kwa'n kidi'zh Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","per Mart dox ñen laxto' xa', kile' xa' rë kwa'n ro' yarde, kuze' nguzubi Mart, nzhab Mart lo Jesús: ―Señor, ¿chi gat niwi'tal?, lë' bëla mila' nab da ro' yarde re'. ¡Guzh, gaknu una' da! ");
INSERT INTO zcaNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Orze' nzhab Jesús: ―¡Mart, Mart, dox ñen laxto'l, mbaino ña-ñë'dal por rë kwa'n kile'l! ");
INSERT INTO zcaNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Per nzho tutsa kwa'n más naki'n le'l, no Mari kile' la kure', no yent cho kubchiy lo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","No ngol tu zhë, nzo Jesús tu plo, kina'b Me lo Dios; no or milox guna'b Me, nzhab tu rë men che'n Me: ―Señor, bitse'd no par xmod na'b no lo Dios, nela xmod mitse'd Juan rë xpen Juan ga'. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Orze' nzhab Jesús: ―Or na'b go lo Dios, se' guzh go: Xuz no, Me nzho lo yibë', dox nazhon lël. Nzhaklan zhin zhë, le'l mandad lo yizhyuo re', nela xmod nile'le lo yibë' ga'. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Bine' kwa'n gao no nalzhë. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Biche' rë kwa'n nzë'b xki no lol, porke nu ka no ña'l laxto' rë kwa'n gat lë' nile' men lo no. No nala'tal wei' rë kwa'n no, rë kwa'n le', nzë'b xki no Lol, sino ke gulo' no lo rë kwa'n gat lë'. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","No nu nzhab Jesús: ―Gab be, tu go kinu tu xa' nichë'l go, no zhin xa' lizh go garol yë'l, mbaino ne xa' lo go: “Wech, le'l prext chon yët kan; ");
INSERT INTO zcaNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","porke nzë'b mizhin tu xa' nichëla lizha, mbaino yent kwa'n kinun par zhina lo xa'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","No dizde le'n yo', lë' xa' ne lo go: “Nakixiantal da mbee'; lë' da mitsa̱o̱ la ro' yo', mbaino lë'da nax la kun rë xmë'da, nayaxcheta' nen kwa'n ka'l.” ");
INSERT INTO zcaNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nin lo go, yaxchet xa' por nichë'l xa' kun go, sino ke lë' xa' yaxche no ne' xa' kwa'n naki'n go, par nalixolt ra' go xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kuze' nin lo go, sa' bina'b go kwa'n lo Dios, no lë' Dios ne'i; mbaino sa' bikwa'n go kwa'n lo Dios, no lë' go yazhële; no sa' ska gurezh go ro' yo', mbaino lë'i xa'l, par zhin kwa'n nzhakla go, ");
INSERT INTO zcaNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","porke xa' nile' se' or nina'b xa' kwa'n lo Dios, lë' Dios za'i; no xa' nile' sa', or nikwa'n xa' tu kwa'n, lë' xa' yazhële; mbaino xa' nile' sa' or kwezh xa' ro' yo', lë'i xa'l par zhin kwa'n nzhakla xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’O, ¿chi nzho tu go kinu tu më'd, chi ziye la go za' go tu ke gao më'd, or nina'b më'd tu yët lo go? O, ¿chi ziza' go tu mbë'l, or nina'b më'd tu mbël gao më'd lo go? ");
INSERT INTO zcaNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O, ¿chi ziye laxto' go za' go tu nixguy or nina'b më'd tu ngo, gao më'd lo go? ");
INSERT INTO zcaNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","No ter men nakap go, per nane go niza' go kwa'n wen, par xmë'd go; no ter nak go sa', ¡Dios nazolia'zht (le't Dios naya') or na'b go Sprit che'n Dios par yo laxto' go, por nded nazhi' Dios go! ");
INSERT INTO zcaNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kigo' Jesús tu mbi mal, laxto' tu miyi' xa' mia'n mud por mbi re'. Or nguro'i, nguzublo midi'zh xa' re', no rë xa' une kure', xe mia'n bixa' tuli. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Per pla men nzhab: ―Lë' xa' ba' nigo' mbi mal laxto' men, por mandad che'n Beelzebú, xtu lë Mizhab, xa' kwa'n nile' mandad lo rë mbi mal. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mbaino lë' más men, guna'b xa' lo Jesús, le' Me tu kwa'n nazhon, par ne bixa', nabei, chi walika Dios mixë'l Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Per lë' Jesús nane la, kwan kile' bixa' xigab, orze' nzhab Me: ―Rë lazh men plo nile' tu gobier mandad, no or gat nzhin bixa' wen, orze' zhin xtu ben xa' nzë xtu plo, lë' bixa' lo'x ze'; mbaino rë lizh men plo gat nzhin men wen, lë' bixa' lë'. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","No se'ska, chi mis yub Mizhab, dil kun rë mbi mal che'n xa', orze', nagaktra' le' Mizhab rë kwa'n nile' xa'. Kuba' nin lo go, porke lë' go kidi'zh mbël, ne go, lë'da nigo' mbi mal, por mandad che'n Beelzebú. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","No chi lë' go ne, lë' da nile' mandad che'n Beelzebú, orze', lo mis go kidi'zh nu rë xpen go, nigo' mbi mal laxto' rë men, por mandad che'n Beelzebú. Kuze' mis rë xpen go ne kwan ñal go, por mbël go. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Per na nigo mbi mal laxto' rë men por mandad che'n Dios; kure'se nilu', lë' Dios mizhin la lo go par lat Me go lo Mizhab, ");
INSERT INTO zcaNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","porke or nzho tu miyi' kwa'n dox naye, no kinu xa' yi'b par kina xa' lizh xa', orze' yent cho liwa'n rë kwa'n kinu xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Per chi zhin xtu xa' más naye lo xa' re', no dil bixa'; xa' más naye ze' le' gan, lat rë yi'b kwa'n kinu xa' re' lizh xa', orze' xa' mile' gan ze', ki'z rë kwa'n ngulat xa' par ka' rë men che'n xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Kuze', xa' gat nzhaknu da, xa' ze' nidil kuda; mbaino xa' gat nidi'zh xtizha lo men, par gak men, men da, xa' ze' nichubla men lon. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’No or niro' tu mbi mal laxto' tu men, orze' nikizëi mont plo ni nits niyen, nikwa'ne plo kwëze; no or gat ñayazhële plo kwëze, orze' nile'i xigab: “Lë'da yubre ska lizha plo nguro'n.” ");
INSERT INTO zcaNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","No or nguiubre mbi ze' laxto' men re', nak laxto' xa' nela le'n tu yo', nalo'b nambe ga', mbaino rë kwa'n le'ne nzhin chul, ");
INSERT INTO zcaNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","orze' ya mbi ze', yaka'i xtu gazh mbi más nakap, par yo rëi laxto' men re'; orze' lë' xa' re' gak más nakap, ke lë'la ngok xa' or galo. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","No or dub kidi'zh Jesús rë kure', lë'chi nguro' tu una' xid men, naye nguruzhië una', nzhab una': ―¡Wen dox nzha una' kwa'n mizol yizhyuo re', xa' kwa'n mine' chich ngu'l! ");
INSERT INTO zcaNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Per nzhab Jesús: ―¡Más wen nzha rë xa' nzhon widi'zh che'n Dios, mbaino nile' bixa' kwa'n nzhab Dios! ");
INSERT INTO zcaNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","No más men nzhagan plo nzo Jesús, orze' nguzublo kidi'zh Me, nzhab Me: ―Rë men nal re', minu la bixa' lo Dios, mbaino nzhakla bixa', ne bixa' tu kwa'n nazhon nile' Dios, per nab tsa kwa'n mile' Dios kun Jonás ne bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","porke nela kwa'n nguzak Jonás ga' une rë men yezh Nínive, ke lë' Dios mixë'l Jonás lo bixa', se'ska kwa'n zak da, na xa' nak Xga'n Dios mbaino nak da tu men yizhyuo, par ne rë men nal re', lë' Dios mixë'l da. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Or zhin zhë kwa'n gab Dios, xmod gak kun kad men yizhyuo, orze' tu una' xa' mile' mandad, lo rë xa' nguio plo ña'n lazh men, kwa'n nguzhin al nez al yët, una' re' zo par gab una' kwan ñal rë men nal re'; porke dizde zit nguro' una', par ngwayon una' rë widi'zh che'n Salomón, porke Salomón ngok tu men dox nzhak. Per na kidi'zh lo go, no más tsak da lo Salomón. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","No rë men yezh Nínive, nu bixa' zo zhë ze', par gab bixa' kwan ñal rë men nal re', porke men yezh Nínive mila' bixa' rë kwa'n nakap nak bixa' lo Dios, or mbin bixa' kwa'n midi'zh Jonás lo bixa', mbaino na, más tsak da lo Jonás. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","No nzhab Jesús: ―No yent cho tsinki tu biani, orze' zob xa'i tu plo naga'ch, o zob xa'i le'n tu kaj; sino ke lë' xa' zobe al ya, par ziniy lo rë xa' yo le'n yo' ze'. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lë' sprit che'n men nak nela tu biani ga' par dub men. No chi lë' sprit che'nal wen, dubal ñani orze'; per chi lë' sprit che'nal nzhakne, orze' dubal nzo lo nakao. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Neo, napa' yal biani kwa'n kinu go ba', orze' ya'n go lo nakao. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Per chi dub le'n laxto'l nikë biani, orze' gakal nela tu biani ga' par zinil lo más rë men. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","No or milox midi'zh Jesús rë kure', orze' ngurezh tu men fariseo Jesús par gao Me lizh xa'. Orze' ngwa Jesús. No or nguio Jesús le'n yo', nguzob Me lo mes. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","No men fariseo re', xe mia'n xa' tuli por nangale't Jesús rë kwa'n mila' rë me tiemp che'n men Israel, por nangazët Jesús ya' Me or gao Me, ");
INSERT INTO zcaNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","per nzhab Jesús: ―Rë go men fariseo, nizët go tich bas no tich plat, lë' laxto' go nzho rë xigab kwa'n niliwa'n go, no rë kwa'n gat lë' nak go. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Nakao nak yek go! ¿Chi nanet go, Dios mizuxkwa' rë kwa'n al tich, mbaino nu ska rë kwa'n al le'n? ");
INSERT INTO zcaNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Más wen biza' go kwa'n kinu go, ka' rë men yent kwan kinu, nes ya'n nambe laxto' go lo Dios orze'. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Dox mal nzha go, men fariseo!, porke niyix go rë diezmo che'n menta, no che'n rrud, mbaino che'n rë nak kwa'n nayë', kwa'n nzha'n go; mbaino kun rë men gat nile't go kwa'n ñal, mbaino ni gat nazhi' go Dios mbaino ni rë men. Per kure' galo laka naki'n le' go, orze' le' go rë kuba'. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Dox nazhe'b kwa'n zak go, men fariseo!, porke ño laxto' go, nizob go plo nizob men tsak, le'n yo' plo nitse'd men widi'zh che'n Dios, mbaino ño laxto' go, lo más men, zen men ya' go, kun rop lad ya' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Dox nazhe'b kwa'n nzadkë tich go, rë go xa' nilu' ley, kun rë go men fariseo, chigab walika men wen go! Lë' go nak nela ba' che'n yinto' kwa'n mizhë' la, ter nilo men tiche. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Orze' nzhab tu xa' kwa'n nilu' ley: ―Maestr, nu par yek no nzha kwa'n midi'zhal ba'. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Orze' nzhab Jesús: ―¡Nu par go, xa' nilu' ley, nazhe'b mal nzha go!, porke nzhab go lo más men, wei' xa' kwa'n ne' dox, kwa'n naxekt men lo; no go, ni gat nikwin goi. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Lë' go kixe!, porke nizuxkwa' go rë ke, nile' go par tsila men rë profet, xa' tiemp, rë xa' kwa'n mbit mis rë xuz go xa' tiemp. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kuba', nilu' tutsa nak go kun rë xuz go, xa' tiemp, por rë kwa'n mile' bixa'; lë' bixa' mbit rë profet, no mis go nizuxkwa' rë ke par nile' go nitsila men rë profet re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kuze', midi'zh Dios por rë kwa'n nane la Dios gak, nzhab Dios: “Lë'da xël rë profet, no rë apost, par di'zh bixa' por Da, per pla rë xa' re' gut go, no zipla bixa' rukë go tich.” ");
INSERT INTO zcaNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Mbaino nu nzhab Jesús: —Kuze' nal, lo rë go, Dios ne xmod gak kun go, por rë ren che'n rë profet, xa' ngut por Dios, dizde or mizuxkwa' Dios yizhyuo, ");
INSERT INTO zcaNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","dizde ren che'n Abel no haxta ren che'n Zacarías, xa' ngut lo luwe plo nak biko' che'n Dios, nadedta' lë' Dios na'b ka kwent che'n rë xa' re', lo rë go. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Rë go xa' nilu' ley, ¡dox mal nzha go!, porke lë' go kinu la kwa'n xa'l go, plo nzho rë kwa'n nak che'n Dios, per naya' nile' go par yo go, mbaino nika go par yo xtu men. ");
INSERT INTO zcaNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Or nguro' Jesús ze', rë men fariseo no rë xa' kwa'n nilu' ley, dox gat lë' mizi bixa', porke ngwaxo'b rë kwa'n nak bixa', orze' nguzublo kikixian bixa' Jesús, kinabdi'zh bixa' más kwa'n, ");
INSERT INTO zcaNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","par ngadi'zh Jesús tu kwa'n gat ñal, nes par ngaza' gab bixa' tu kwa'n nak Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","No or migan nayax dox men, plo nzo Jesús, por mil bixa', haxta kigotip bixa' wech bixa', orze' nguzublo Jesús galo laka midi'zh Me lo rë men che'n Me, nzhab Me: ―Bikina go go lo rë men fariseo, napa' nu go ye'd xmod nak bixa'; porke nak bixa' chigab men walika nzhon ro' Dios, ");
INSERT INTO zcaNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","porke yent ni tu kwa'n naga'ch midizha lo go nagon men; mbaino yent ni tu kwa'n xla'n milun lo go naded nagon mene. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","No rë nak kwa'n nidi'zh go lo nakao, zhë laka gon mene; no rë kwa'n nidi'zh go xla'n le'n yo', lë' xtu men kuzhyëi dizde yek yo' al ya. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","No nzhab Jesús: ―Kinin lo go, rë go xa' nichëla; nazhebt go ne go xa' nzhut men, porke nab tsa kuba' gak le' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Per na ni cho lo más ñal zheb go: Lo Dios bizheb go, porke lë' Dios, dispwés di gat men, Dios gak le' mandad, yo men le'n bël. Nab tsa lo Dios bizheb go. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Nane ka go, dox che'p tsak rë miyin ye'n or nido bine', per nikë ka laxto' Dios bine'. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","No chi lë' Dios nikë laxto' miyin ye'n, ¿chi nanet go, más nazhi' Dios go?, porke haxta rë yich yek go nane Dios pla. Kuze' nazhebt go, porke lo rë miyin, go más tsak. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Kidizha lo rë go, xa' kwa'n xë'lro' lo rë men: “Na men che'n Jesús”, nu ska da, xa' nak Xga'n Dios nu nak da tu men yizhyuo, gapa lo rë ganj che'n Dios: “Lë' xa' ba' nak tu men da”, ");
INSERT INTO zcaNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","per xa' naxë'lro' lo rë men, nak xa' tu men da, orze', nu ska da gap lo rë ganj che'n Dios: “Gat lë'ta' men da xa' ba'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’No chi di'zh men tu kwa'n gat lë' por da, mbaino na nak Xga'n Dios nu nak da tu men yizhyuo, per Dios che' kwa'n nzë'b xki xa' re' por kure'; per tu xa' di'zh kwa'n gat lë' por Sprit che'n Dios, nayotra' zhe' kwa'n nzë'b xki xa' por kure'. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’No or chi men go lo rë xa' kwa'n nile' mandad le'n rë yo' plo nitse'd men widi'zh che'n Dios, o lo rë xa' nak nela rey ga', o lo rë xa' nak nela gobiernador ga', o lo rë gustis xa' más nile' mandad; per le't go xigab xmod kab go lo bixa', o kwan di'zh go lo bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","porke or di'zh go lo bixa', lë' Sprit che'n Dios ne lo go xmod di'zh go lo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","No xid rë men nayax ze', nguro' tu xa' nzhab lo Jesús: ―Maestr, guzh lo wecha, ne' tlë' yuo kwa'n mila' xuza par gal da. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Per nzhab Jesús: ―Lë' you, yent cho mizo da xid go, par kobe'n o par ki'za kwa'n xid go. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nu nzhab Jesús: ―Bikina go go, nawixt go gap go más kwa'n di lo rë kwa'n naki'n go, lo yizhyuo re', porke gat lë'ta' ba' nzë yalnaban par men. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Orze' miza' Jesús kwent re' lo bixa', nzhab Me: ―Nguio tu men rrik, mbaino rë yuo che'n xa' nded miza'i, ");
INSERT INTO zcaNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","orze' mile' xa' rrik re' xigab: “¡Neta kwan len, porke gat kinuta' plo kucha̱u̱ rë yalgo'n re'!” ");
INSERT INTO zcaNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Guzhë la ze' mile' xa' xigab: “¡Neka kwan len! Lë'da chil lizha par cha̱u̱ tu kwa'n más kwa'ro, par kucha̱u̱ rë yalgo'n re', mbaino rë kwa'n kinun.” ");
INSERT INTO zcaNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Orze' mile' xa' xigab: “Nalse nzho kwa'n ga̱u̱wa̱ nayax li'n; xchë nakëtra' zhi'n; ga̱u̱ mbaino go'n, nazhon nzhan.” ");
INSERT INTO zcaNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Per nzhab Dios lo xa': “¿Chi miao' yekal kwan kile'l? Nanetal, nal yë'l re', lë'l gat, no rë kwa'n kinuchao'wal ba', ¿par choi?” ");
INSERT INTO zcaNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Sa' nizak men nitsiyar yalrrik yizhyuo re', per lo Dios, yent kwan kinu xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Orze' nzhab Jesús lo rë men che'n Me: ―Kuze' nin lo go, le't go xigab por kwa'n gao go par ban go, no ni por xab go kwa'n gak go, ");
INSERT INTO zcaNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","porke más tsak bid che'n go lo kwa'n gao go; no más tsak kwerp che'n go lo xab go. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Biwi' go lo rë nga, gat nzha'nt ma mbaino gat nikant ma yalgo'n, per lë' Dios niza' kwa'n nzhao ma; mbaino go, ¡más tsak go ke rë miyin! ");
INSERT INTO zcaNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","O, ¿cho tu go por dox nile' go xigab, gak ro'b go zigarol metr dimás? ");
INSERT INTO zcaNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","No chi ni tu kwa'n win nagakt le' go, orze', ¿chon nile' go xigab por rë kwa'n nagan, rë kwa'n nagakt le' go? ");
INSERT INTO zcaNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Biwi' go xmod niro'b ye', nabe nilu'i nabé, nela tu men or nzhak xa' tu lar chul ga'; no nin lo go, ni rey Salomón, nangabet xa' nela xmod nabé nilu' tu ye' ga'. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","No chi lë' Dios nile', chul nilu' rë ye' che'n rë yix dan, kwa'n nixek tutsa ngubizh, orze' nibizhe, orze' nikan mene par yëke, or nichao' bixa' pan par nzhao bixa', pwes Dios más gak libe' go ke nela xmod nilu' tu ye' ga'. ¿Chon gat ñilat go be's, lë' Dios ne' kwa'n gak go? ");
INSERT INTO zcaNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nin lo go, nale't go xigab por kwa'n gao go, no ni por kwa'n go go, ");
INSERT INTO zcaNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","porke rë men yizhyuo, dox nile' bixa' xigab por rë kure'; per go kinu Xuz go, Me kwa'n nane la, lë' go naki'n rë kure'. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mejor bile' go xigab, kwa'n go, galo laka rë kwa'n nazhon che'n Dios, orze' Dios zilazh rë kwa'n naki'n go yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Rë go, xa' dox nazhi' da, nale't go be's xigab, porke lë' Xuz be Dios ne' rë kwa'n naki'n be. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kuze' bito go rë kwa'n kinu go yizhyuo re', par za' goi ka' rë men gat kinui, nes par gap go yalnaza'k kwa'n nayot lox lo yibë', porke ba', yent cho liwa'ne, mbaino ni nagao mbëze, ");
INSERT INTO zcaNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","porke plo kinu go kwa'n tsak, ze' nzo xigab chego. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","’Guzo go list, nala't go yal biani che'n go, nela xmod nile' rë mos, xa' kimbëz yë'd miyi' xa' gak jwandang che'n, nes par or zhin xa' re', lwega' xa'l rë mos ro' pwert. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Wen nzha rë mos xa' nzo list kikina, or yë'd xa' kwa'n nile' mandad bixa'. Walika nin lo go, lë' xa' le' zob rë mos lo mes, no mis xa' nile' mandad re', ki'z kwa'n gao rë xa' re' lo mes. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Wanei, ter garol yë'l yë'd xa' re', o garzi'l lakai, per yazhël xa' rë mos kikina ka bixa', orze' nazhon nzha rë mos re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Bin go kure': Chi tu xa' nak lizh tu yo', nzhon la cho or yo wa'n lizh xa', sigurka nala't xa' yo wa'n lizh xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nuska go, naki'n zo go list; porke na yal, or nale't go xigab. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Orze' minabdi'zh Per lo Jesús, nzhab xa': ―Señor, ¿chi nab par yek no nzha kuba', o nu par rë men nzhai? ");
INSERT INTO zcaNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Orze' nzhab Jesús: ―Mos nzhon di'zh mbaino natsin, xa' re' nizo xa' nile' mandad par kina lizh xa', mbaino rë che'n xa', no par za' mos re', kwa'n gao más tsa' mos xa', or nila'n rë xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Wen nzha mos nzhon di'zh, or yë'd xa' nile' mandad, or ne xa' lë' mos re' kile' ka kwa'n nzhab xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Walika kwa'n nin lo go, lë' xa' nile' mandad re', la' rë nak kwa'n kinu xa', par kina mos kwa'n nzhon di'zh re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Per chi lë' mos re' le' xigab: “Lë' xa' nile' mandad yë'd gaat xa' lizh xa'”, orze' zublo kin xa' rë mos miyi' no rë mos una', no gao dox xa' mbaino go xa'i haxta zuzh xa', ");
INSERT INTO zcaNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","orze' lë' xa' nile' mandad re', yë'd or nale't mos re' xigab, orze' chix xa' mos re' tuli, nela nzhak kun rë mos xa' gat nzhon di'zh. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’No mos xa' nane la, kwan nzhakla xa' nile' mandad xa', per gat nile't xa' por le' xa'i, orze' dox kin xa' mos re', haxta plo nagakra'i; ");
INSERT INTO zcaNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","per mos xa' nile' rë kwa'n gat ñal, sin nane mos, chi ñal zakzi mos por lë'i, por kuba' che'ptsa zakzi mos. Xa' kwa'n mila' Dios nayax kwa'n lo, pwes nayax ska kwa'n na'b Dios kwent lo xa' por kure'; mbaino xa' kwa'n mizo Dios par le' mandad, nu ska lo xa' na'b Dios kwent nayax kwa'n. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","No nzhab Jesús: ―Na nzhal nela tu men kwa'n tsinki yizhyuo re'; ¡oj zinkigai nzhaklan! ");
INSERT INTO zcaNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Naki'n de'da lo tu kwa'n nazhe'b, mbaino dox trixt nizi da, haxta or lox de'da lo kwa'n nazhe'b re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Chi nile' go xigab nzhala par len, kwin men wen yizhyuo re'? Per gat lë't sa'i; na nzhal par len lë' men, ");
INSERT INTO zcaNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","porke re' par dilant, gai' xa' nzho le'n tu yo', lë' bixa' lë'; chon xa' dil kun chop xa', no chop xa' dil kun chon xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Lë' xuz xa' kun xga'n xa', no lë' xga'n xa' kun xuz xa'; no lë' xna' xa' lë' kun xcha'p xa', no xcha'p xa' lë' kun xna' xa'; lë' xix xa' lë' kun xna'ye' xa', no lë' xnaye' xa' lë' kun xix xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nu nzhab Jesús lo nayax men: ―Or ne go nzhakxao' xkao al ya, orze' nzhab go: “Lë' yiu la”, mbaino nila ka yiu; ");
INSERT INTO zcaNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","no or nzhakidan mbi dizde al yët, orze' nzhab go: “Lë' nëi' gak”, no sa' ka nzhake. ");
INSERT INTO zcaNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Tatu nazhe'b nak go, chigab walika men wen go! No chi lë' go nilibe' señ lo yibë' no lo yizhyuo; orze', ¿chon gat nizobyek go rë kwa'n nile' Dios nal re'? ");
INSERT INTO zcaNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’No, ¿chon nawi' mis go, kwan rë kwa'n ñal le' go? ");
INSERT INTO zcaNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Chi ne tu xa' nzhap go dol por tu kwa'n mile' go, no wei' xa' go lo gustis por kure', no dub nzha go lo gustis, bikwa'n go mod par tsiyal go laxto' xa', par nachi xa' go lo gustis, porke lë' gustis le' mandad yo go lizhyi'b; ");
INSERT INTO zcaNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","porke sigur ka, naro't go lizhyi'b haxta ke kix go rë kwa'n nzë'b go. ");
INSERT INTO zcaNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Orze' nguzubi pla men lo Jesús par nzhab xa': “Lë' Pilat mbit pla men Galilea, no migoch xa' ren che'n rë men re', kun ren che'n rë ma, kwa'n miza' rë men re' gon lo Dios.” ");
INSERT INTO zcaNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Orze' nzhab Jesús: ―¿Kwan gab go nal? Ngut rë men ba' por más nzë'b xki bixa', lo más rë men lazh xa', men Galilea. ");
INSERT INTO zcaNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Per gat lë't sa'i. No chi lë' go nala' rë kwa'n nakap nak go lo Dios, lë' go lox ska. ");
INSERT INTO zcaNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Kwan gab go?, or ngut dub chi'n bichon men, or nguiuxche torr Siloé yek bixa', ¿gab go por más nzë'b xki bixa'i, lo más rë men yezh Jerusalén, por nguzak bixa' kuba'? ");
INSERT INTO zcaNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Per gat lë't sa'i. No chi lë' go nala' xmod nak go lo Dios, lë' nu ska go lox. ");
INSERT INTO zcaNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Orze' midi'zh Jesús kwent re' lo rë men, nzhab Me: ―Nguio tu miyi' kinu tu ya nzhao' xid rë ya gub che'n xa', no ngwatsi' xa' chi nzo xlë loi, per yent kwan ngaza'i. ");
INSERT INTO zcaNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Orze' nzhab xa' lo xa' nikina ya xlë che'n xa': “Biwi', nzha chon li'n, ñidkwana xlë lo ya re', no gat yazhël da ni tu xlë loi. Más wen bicho'i, porke yent por kwan nzobe lo yuo re'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Orze' nzhab xa' nikina ya xlë re': “Señor, bila' nzobe nal li'n re', lë'da tsiyëch yuo xane, no kon bone, ");
INSERT INTO zcaNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","par ne be chi ziza'i xlë. No chi naza'i, orze' ro'ge.” ");
INSERT INTO zcaNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ngol tu ngubizh, kwa'n nile' men Israel diskans, lë' Jesús kilu' widi'zh che'n Dios le'n yo' plo nitse'd bixa' widi'zh che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","No ze' nzo tu una' kwa'n nzhakne nzhala chi'n bichon li'n, nzho tu mbi mal laxto' xa', no nile'i bech xa', gakt li xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Or une Jesús una' re', ngurezh Jesús una', nzhab Me: ―Una', lë'l miak la lo yalyizh che'nal. ");
INSERT INTO zcaNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","No mixo'b Me ya' Me tich una', orze' lwega' mili una', no nguzublo kidi'zh una' nazhon Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Per xa' nile' mandad le'n yo' ze', niyi' xa' por miliwen Jesús una' re', zhë kwa'n nayi' kë men Israel zhi'n, orze' nzhab xa' nile' mandad lo rë men nzhin ze': ―Nzho xo'p ngubizh kwa'n kë men zhi'n, nab tsa rë ngubizh re' ñal yi'd go par gak wen go; yi'dt go zhë re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Orze' nzhab Jesús lo xa' re': ―¡Tatu nazhe'b nak go, chigab walika men wen go! ¿Chi gat nixëkt go ngo'n che'n go, o burr che'n go zhë nile' men diskans, par za' go nits go ma?, ");
INSERT INTO zcaNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","porke una' re' nzë ben che'n Abraham, per lë' Mizhab mile' ngokne una' chi'n bichon li'n; no nal, ¿chi nayi' ngok wen una' re', zhë kwa'n nayi' kë men Israel zhi'n? ");
INSERT INTO zcaNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","No or nzhab Jesús rë kure', rë xa' nile' mandad kwa'n nikwa'n dil kun Jesús, mitula bixa', per más men mizak laxto' or une bixa', rë kwa'n nazhon nile' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Orze' nzhab Jesús: ―¿Kwan tu kwa'n nak nela xmod nile' Dios mandad lo rë men che'n Me, no kun kwan chë'l bei? ");
INSERT INTO zcaNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nake nela tu lazh win mostás ga', kwa'n mixë'n tu miyi', lo yuo plo kinu xa' rë ya xlë che'n xa', no miro'be, no ngoke tu ya ro, haxta miyin michao' yo rram che'ne. ");
INSERT INTO zcaNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nu nzhab Jesús: ―¿Kwan xtu kwa'n nak nela xmod nile' Dios mandad lo rë men che'n Me? ");
INSERT INTO zcaNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nake nela levadur kwa'n nguzen tu una', no migoch una'i, le'n gal biga'i kil harín kwa'n mitsibech rë harín re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Or nzha Jesús nez Jerusalén, kilu' Me widi'zh che'n Dios le'n rë yezh, no rë rranch plo nzhaded Me, ");
INSERT INTO zcaNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","no nguro' tu men minabdi'zh lo Jesús, nzhab xa': ―Señor, ¿chi che'p tsa men ro' lo rë kwa'n nazhe'b kwa'n nzadkë tich bixa'? Orze' nzhab Jesús: ");
INSERT INTO zcaNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Dox pe'n le' men gan, yo men plo nile' Dios mandad. Nake nela or nided men ro' tu pwert dox nayaa ga'. Bile' go jwers, yo go ro' pwert re', porke nin lo go, nayax men gakla yo ro' pwert re', per che'p tsa men yo. ");
INSERT INTO zcaNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","No lult, lë' xa' nak che'n yo' kwa'n kinu pwert nayaa re', yaxche tsao' ro' yo', no rë go ya'n al tich, orze' kwezh go ro' yo', gab go: “Señor, bixa'l go ro' yo'”, per lë' xa' ne lo go orze': “Yent cho nzhak da go.” ");
INSERT INTO zcaNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Orze' gab go lo xa': “¡Per nzho ka cho nzhak no go! Lë' be tutsa ndao, mbaino tutsa ngu' be, no go milu' widi'zh che'n go lo no, le'n rë nez che'n lazh be.” ");
INSERT INTO zcaNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Orze' ne xa' lo go: “Lë'da ni la, yent cho nzhak da go; ¡rë go xa' nile' kwa'n gat lë', chi go lon!” ");
INSERT INTO zcaNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ze' go'n go, no dao' ley go or ne go Abraham, Isaac, Jakob, no rë profet xa' midi'zh por Dios chi tiemp, nzho bixa' plo nile' Dios mandad, no lë' go nzhin al tich, ");
INSERT INTO zcaNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","porke lë' rë lad yizhyuo, yi'd men, par zob xa' lo mes, plo nile' Dios mandad par gao bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","No biwi' go, nzho xa' nile' go xigab, más tsak nal re', per más dispwés, xa' ze' gak xa' menes tsak; no xa' nile' go xigab menes tsak nal re', xa' ze' gak xa' más tsak dispwés. ");
INSERT INTO zcaNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","No mis zhë ze', mizhin pla men fariseo, nzhab lo Jesús: ―Chi, bizë laba'; porke lë' Herodes nzhakla gutal. ");
INSERT INTO zcaNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Orze' nzhab Jesús: ―Wa go wayab go lo xa' nizi dox ya ba', se' ne Jesús: “Biwi', nalzhë, no yë', kubchin mbi mal laxto' rë men, no liwena rë men nzhakne; no ngubizh yon loxa rë zhi'n da.” ");
INSERT INTO zcaNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","No ter sa' nile' Herodes xigab kun na, per lë'da naki'n ka ya nez da dub nalzhë re', no yë' mbaino wizh par len rë kwa'n naki'n len; porke nagatta' da ni xtu rë plo, nab tsa Jerusalén naki'n gat da, porke nab tsa ba', nzhut men rë xa' kwa'n nixë'l Dios par nidi'zh widi'zh che'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Men Jerusalén, men Jerusalén, go kwa'n nzhut rë profet, no nigo ke go rë men kwa'n nixë'l Dios lo go! ¡Nayax wëlt ngoklan ngazhina junt rë go, nela nguid niye'zh rë xmë'd le'n xi'l ga', per nangaziyëlt go! ");
INSERT INTO zcaNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Per biwi' go, lë' yado' che'n go ya'n nzë'b, mbaino zit ya'n go di lo Dios; no nanetra' go da más, haxta zhin zhë kwa'n gab go: “¡Wen nzha xa' kwa'n mixë'l Señor!” ");
INSERT INTO zcaNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","No ngol tu zhë kwa'n nayi' kë men Israel zhi'n, ngwatao Jesús lizh tu men fariseo, xa' nile' mandad, no rë men zhin ze' kila'ch bixa', nabei kwan le' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Se' kile' bixa' porke lo Jesús nzo tu miyi' nzhakne, ngwazhë di ki. ");
INSERT INTO zcaNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Orze' minabdi'zh Jesús lo rë xa' nilu' ley, no lo rë men fariseo kwa'n nzhin ze', nzhab Jesús: ―¿Chi zak liwena tu men nzhakne, zhë kwa'n nayi' kë men Israel zhi'n, o nagakte? ");
INSERT INTO zcaNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Per yent kwan ngakab bixa'. Orze' nguzen Jesús ya' xa' re', mbaino miliwen Jesús xa', orze' nzhab Me lo xa': “Bizë lizhal.” ");
INSERT INTO zcaNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mbaino lo rë men fariseo ze' nzhab Jesús: ―No chi tu go kinu tu xin, o tu ngo'n, no chi ngula ma le'n zo, ter zhë kwa'n nayi' kë men Israel zhi'n, orze', ¿chi nako't go ma lwega'? ");
INSERT INTO zcaNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Orze' yent kwan ngakab bixa' lo Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","No or une Jesús, rë xa' kwa'n ngwane xa' lo par nzë jwandang, or nizhin bixa', nibe bixa' plo nizob pura xa' ro par zob bixa', orze' nzhab Jesús: ");
INSERT INTO zcaNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Or kwezh tu men go ya go tu jwandang, nazobt go plo nizob rë men xa' ro, nzha ska zhin xtu xa' más tsak lo go, ");
INSERT INTO zcaNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","no xa' ngurezh go re' zubi lo go par ne xa': “Watso par zob xa' re'”, no orze' lë' go tula, mbaino haxta tras zob go. ");
INSERT INTO zcaNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Más wen haxta tras zob go or kwezh men go, orze' lë' xa' ngurezh go ne lo go: “Guded lare' weech, re' ñal zobal”, orze' rë men xa' nzobal kun lë' lo mes, lë' bixa' le' kasal, ");
INSERT INTO zcaNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","porke xa' kwa'n nzhakla le' men kas, per ni nawi' men lo xa'; mbaino xa' kwa'n gat nizi ya, lë' men le' kas xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Orze', nzhab Jesús lo xa' kwa'n ñanu Jesús lizh xa': ―Or za'l tu kwa'n gao men, nakwezhtal xa' nichë'lal, ni wechal, ni melizhal, ni tu men rrik; porke lë' rë xa' re', se'ska le' bixa' kun lu, par kix bixa'i lol. ");
INSERT INTO zcaNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mejor or za'l tu kwa'n gao men, gurezh rë xa' prob, rë xa' ma'nk, no rë xa' ne ni', mbaino rë xa' nikal lo, ");
INSERT INTO zcaNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","par yal wen; porke rë xa' re', nagakt kixe lol; per Dios ne' tu kwa'n ka'l or ruban rë men xa' nile' kwa'n nzhakla Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Or mbin tu rë xa' kwa'n nzob lo mes ze' kure', orze' nzhab xa' lo Jesús: ―¡Nazhon nzha rë xa' gao plo nile' Dios mandad! ");
INSERT INTO zcaNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Orze' nzhab Jesús: ―Nguio tu miyi' miza' tu xche' ro gao rë men, orze' mile' xa' mandad yi'd nayax men. ");
INSERT INTO zcaNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Or ngol or gao bixa', mixë'l xa' nile' mandad ze' tu mos che'n xa', par nzhab xa' lo rë men xa' nak di'zh yi'd: “Dë' go nal, porke lë' ye'n ya nzhin la.” ");
INSERT INTO zcaNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Per rë bixa' tutsa mia'nkë bixa' di'zh. Xa' galo nzhab: “Milox nguzin tlë' yuo, lë'da nzha za wëlt loi. Le' dispense, nagakt yala.” ");
INSERT INTO zcaNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","No xtu xa' nzhab: “Lë'da nguzi' gai' nez ngo'n, lë'da nzhale' preb ma; le' dispense, nagakt yala.” ");
INSERT INTO zcaNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","No lë' xtu xa' nzhab: “Lë' jwandang da laore ngok laka; kuze' nagakt yala.” ");
INSERT INTO zcaNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","No or miëk mos ze', nzhab xa' rë kure' lo xa' za' kwa'n gao men re'. Orze' dox niyi'xian xa', no nzhab xa' lo mos ze': “Le' purad, le'n rë nez ro che'n yezh re', no rë bered, par waka' rë men xa' prob, no rë xa' ma'nk, mbaino rë xa' nikal lo, no rë xa' ko'j.” ");
INSERT INTO zcaNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Guzhël la ze' nzhab mos: “Señor, lë'da mile la kwa'n mile'l mandad, per stubi nzho lugar.” ");
INSERT INTO zcaNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Orze' nzhab xa' nile' mandad re': “Wa le'n rë nez, mbaino wa ro' rë yalo, no jwers guzh yi'd rë men, par yazhë lizha. ");
INSERT INTO zcaNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kuze' nin lo go, ni tu rë xa' kwa'n ngurezha galo ba', gaoxche't lizha.” ");
INSERT INTO zcaNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","No dox nayax men nzhakë tich Jesús, orze' miëk Me, miwi' Me lo bixa', nzhab Me: ");
INSERT INTO zcaNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Chi nzho tu go nzadkë ticha, no más nile' go por xuz go, o por xna' go, o por tsa' go, o por xmë'd go, o por wech go, o por bizan go, o nile' go más por rë kwa'n nile' go xigab; no chi más nazhi' go rë kuba' lon, orze' nagakt gak go tu men da. ");
INSERT INTO zcaNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mbaino nu chi tu go nzadkë ticha, no nizheb go zakzi go o gat go por nak go men da; no chi sa' nak go, pwes nagakt gak go men da. ");
INSERT INTO zcaNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","O chi nzho tu go nile' xigab kuxkwa' go tu yo' nayax pis, ¿gat galo laka zob go par le' go xigab, plak dimi gal par yaloi?, ");
INSERT INTO zcaNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","porke chi zob go nab tsa simient che'ne, nalo'xt go kuxkwa' goi, orze' lë' rë men xizhnu go, ");
INSERT INTO zcaNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","gab bixa': “Biwi', nangakt ngalo'x xa' ngazuxkwa' xa' lizh xa'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O chi tu rey nzhakla dil kun xtu rey, ¿gat galo laka naki'n le' xa' xigab, chi zixek chi' mil sondad che'n xa' lo gal mil sondad che'n xtu rey xa' nidil xa'? ");
INSERT INTO zcaNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","No chi niwi' xa' naxekt xpen xa', orze' antis di ke yi'd xtu rey par dil xa', lë' xa' xë'l abis par kwëz dil. ");
INSERT INTO zcaNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Se'ska, chi nzho tu go xa' nak men da, per más nazhi' go rë kwa'n lon, rë kwa'n kinu go ba', pwes nagakt gak go men da. ");
INSERT INTO zcaNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Nu nzhab Jesús: ―Wen zed, per chi gat nazhi'ra'i, ¿xmod dao'we zed? ");
INSERT INTO zcaNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nazu'tra'i ni par yuo, no ni par bon. Orze' mejor re'che. Chi lë' go mbin kure', bizobyek goi. ");
INSERT INTO zcaNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Rë men xa' nikan dimi che'n rey, no rë men xa' kwa'n nzho'b xti'zh más nzë'b xki lo Dios, nguzubi bixa' lo Jesús par gon bixa' kwa'n kidi'zh Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kuze' rë men fariseo no rë xa' nilu' ley, dox nakap kidi'zh bixa' tich Jesús, nzhab bixa': ―Lë' xa' re' nichë'l kun rë men xa' más nzë'b xki lo Dios, mbaino nu nzhao xa' kun rë men re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kuze' midi'zh Jesús kwent re' lo bixa', nzhab Me: ");
INSERT INTO zcaNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Chi nzho tu go kinu tu gayo' mbëkxi'l, no or ziwan tu ma, ¿chi nala't go dub tap gal nzho chi'n bitap ma re' dan, par yakwa'n go ma nguziwan re', haxta ke yazhël go ma? ");
INSERT INTO zcaNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","No or yazhël go ma, nizak laxto' go, yi'dnu go ma yën go; ");
INSERT INTO zcaNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","no or zhin go lizh go, kan go rë xa' nichë'l go, no rë xa' nzho go gax kun lë', no gab go lo bixa': “Bizak laxto' go kuna; porke lë'da ngwazhël la mbëkxi'l da ma nguziwan ze'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nin lo go, se'ska más nzho yalnizak laxto' lo yibë', or nizi tu men xmod nak xa' lo Dios, par ban xa' nela xmod nzhakla Dios, ke por dub tap gal nzho chi'n bitap men xa' nizi, yent kwan nak, nambe laxto' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Se'ga' tu una' kwa'n kinu chi' pes kwa'n plat, no miziwan tube, orze', ¿chi nakë't xa' tu biani, no lo'b xa' dub le'n yo', par kwa'n xa'i nambe, haxta ke yazhël xa'i? ");
INSERT INTO zcaNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","No or yazhël xa'i, kan xa' rë xa' nichë'l xa', no rë xa' nzho gax plo nzho xa', gab xa': “Bizak laxto' go kun na, porke lë'da ngwazhël la dimi da, kwa'n nguziwan ze'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nin lo go, se'ga' nizak laxto' rë ganj che'n Dios, or nizi tu men xmod nak xa' lo Dios, par ban xa' nela xmod nzhakla Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","No nu midi'zh Jesús kwent re' lo rë men, nzhab Me: ―Nguio tu miyi', kinu chop xga'n, ");
INSERT INTO zcaNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","miyi' más win nzhab lo xuz: “Lë'o Pa, nzhaklan ne'u kwa'n gal da.” Orze' ndi'z xuz bimiyi' kwa'n ñal kad bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","No xche'p dispwés, miyi' win re', mikan rë nak kwa'n nak che'n, orze' nzha xa' zit xtu lazh men. Ze' mile' xa' gaxt rë nak che'n xa' lo rë kwa'n gat lë', miban xa' nela xmod nzhakla xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Or milo'x la xa' rë che'n xa', no plo nzho xa' nguio tu yalwin dox, orze' nguzublo ngok jwalt kwa'n lo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Orze' mikwa'n xa' zhi'n lo tu men yezh ze', xa' ze' mixë'l xa' plo nax yuo che'n xa' re', par za' xa' kwa'n gao kuch. ");
INSERT INTO zcaNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","No por tanta nila'n xa', nzhakla xa' ngao xa' kwa'n ro' kuch, porke yent cho za' kwa'n gao xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Lult mile' xa' xigab: “¡Dox nayax mos kinu xuza, no di sobr nzho kwa'n gao bixa', mbaino na, gat da di yalwin re'! ");
INSERT INTO zcaNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Neka lë'da yëk lo xuza, gapa lo xa': Payë', milen kwa'n gat lë' lo Dios mbaino lo go. ");
INSERT INTO zcaNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nal gat ñalt ro'lë da xga'n go; biwi' go lon nela lo tu mos che'n go.” ");
INSERT INTO zcaNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Orze' nguzen miyi' nez, ñë'd miyi' par lo xuz miyi'. ’No jwaltra' di zhin miyi' lo xuz miyi', lë' xa' une la miyi'. Orze' milats laxto' xa' miyi', karre ngwachë'lo xa' xga'n xa', nde'x xa' yën miyi', no michiro' xa' ta' kwats miyi'. ");
INSERT INTO zcaNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Orze' nzhab miyi' lo xuz miyi': “Payë', milen kwa'n gat lë' lo Dios, mbaino lo go, gat ñaltra' da ro'lë da xin go.” ");
INSERT INTO zcaNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Per nzhab xuz miyi' lo rë mos xa' nguzi' xa': “Karre waka' go lar más kwa'n wen, no bigak goi xga'na re', no ngulo go yani ya' xa', no bikë' go kwa'n ni' xa', ");
INSERT INTO zcaNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","no waka' go bicerr kwa'n más nacha', no bit go ma par gao be, no le' be lani, ");
INSERT INTO zcaNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","porke lë' xga'na re', milen xigab ngut la xa', no nal, nguiubre xa' naban xa'; miziwan xa', per nal ngwazhël xa'.” Orze' mile' bixa' lani. ");
INSERT INTO zcaNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Per xga'n galo xa' re' nzo dan, no or ñë'd xa' par lizh xa', mbin xa' kiyo'l musk, no kiyolni' men, ");
INSERT INTO zcaNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","orze' ngurezh miyi' re' tu mos, par minabdi'zh xa': “¿Kwan kile' rë men ba'?” ");
INSERT INTO zcaNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Orze' nzhab mos: “Lë' wechal miëk, no lë' xuzal mile' mandad ngut bicerr más nacha', porke lë' wechal nguiubre wen, mbaino yent kwa'n nizak xa'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Per maska miyi' re' ngazak laxto', lë'la niyi' miyi' re', net xa' ngayo xa' le'n yo'. Orze' nguro' xuz miyi', par mila xa' yek miyi' ngayo miyi' le'n yo', ");
INSERT INTO zcaNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","per nzhab miyi' lo xuz miyi': “Biwi', pla li'n nzha nikën zhi'n lol, no dubta' nzhona kwa'n nel, no per ni tu chib ye'n gat ne'l par ga̱u̱ kun rë xa' nichëla, ");
INSERT INTO zcaNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","per lë' xga'nal mbee' nguiubre re', mile' gaxt rë kwa'n miza'l ka' xa', lo rë una' le'n kai (kwa' gal), ¡no nal mile'l mandad, ngut bicerr kwa'n más nacha'!” ");
INSERT INTO zcaNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Orze' nzhab xuz miyi': “Xga'na, lu dubta' nzol kun na; no rë kwa'n kinun, che'nle. ");
INSERT INTO zcaNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Per nalre', ñal ngok lani, nizak laxto' be, porke lë' wechal re' ngut, per nguruban xa'; miziwan xa', per nal, ngwazhël xa'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","No midi'zh Jesús kure' lo rë men che'n Me: ―Nguio tu miyi' rrik, kinu xa' tu xa' nikina rë che'n xa', no ngwayab zipla mos che'n miyi' re': “Xa' nikina rë che'nal ba', gat lë't kile' xa'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Orze' ngurezh xa' rrik re' miyi' re' par nzhab xa': “¿Chi wali gat lë't kile'l kun rë cheda? Bite'd kwent rë kwa'n kile'l, porke nakinatra'l rë cheda.” ");
INSERT INTO zcaNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Orze' mile' xa' nikina re' xigab: “¿Xmod len nal, lë' xa' nile' mandad da re' milat zhi'n lon? No naxekt da ga'na yuo, no nitulan na'ba karida. ");
INSERT INTO zcaNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Ah! Ne ka kwan len, par kwezh men da lizh xa', or niyenra' zhi'n kën.” ");
INSERT INTO zcaNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Orze' ngurezh xa' nikina re', tuga' rë xa' nzë'b lo xa' nile' mandad xa'; nzhab xa' lo xa' galo laka mizhin: “¿Plak nzë'bal lo xa' nile' mandad da?” ");
INSERT INTO zcaNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Orze' nzhab xa' re': “Lë'da nzë'b tu gayo' barril aseit.” Orze' nzhab xa' nikina re': “Lë' yech kwa'n nzë'bal re', karre nguzob, bizuxkwa' xtu yech, bizob cho' bichi' tsa barril aseit nzë'bal.” ");
INSERT INTO zcaNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Orze' nzhab xa' lo xtu xa' nzë'b: “Lu ga', ¿plak nzë'bal?” Orze' nzhab xa' ze': “Tu gayo' dabed triu.” Orze' nzhab xa' nikina re': “Lë' yech kwa'n nzë'bal re', bizuxkwa' xtu yech, bizob tap galtsa dabed loi.” ");
INSERT INTO zcaNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","No or une xa' rrik re', lë' mos xa' gat nite'd kwent kumplet re', dox natsin por xmod mile' xa', orze' nzhab xa' rrik re' lo mos re': “Dox natsinal.” Kuze' nzhab Jesús: ―Porke rë men yizhyuo re', nzho xa' más natsin lo rë kwa'n nile' xa' kun rë men, ke xmod nile' rë men xa' nidi'zh, nilibe' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’No nin lo go, bikwa'n go xmod chë'l go kun rë men yent kwan nzhap, kun yalrrik kwa'n gat lë' kwa'n nzho yizhyuo re'. No or lox yalrrik lo go, lë' Dios wei' go plo yo go par dubta'. ");
INSERT INTO zcaNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’No men xa' nile' wen lo tu kwa'n che'p, pwes nu ska lo kwa'n nayax nile' xa' wen; mbaino xa' nile' kwa'n gat lë' lo tu kwa'n che'p, nu ska lo kwa'n nayax le' xa' kwa'n gat lë'. ");
INSERT INTO zcaNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","No, chi nile' go kwa'n gat lë' lo rë kwa'n tsak lo yizhyuo re', orze', nagabt go, lë' Dios la' yalrrik kwa'n nidi' par dubta' par kina go. ");
INSERT INTO zcaNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","No chi gat nile' go xmod ñal kun rë kwa'n nak che'n xtu men, orze', ¿xmod zhin rë kwa'n nak che'n go? ");
INSERT INTO zcaNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Yent cho tu mos gak kë zhi'n lo chop xa' nile' mandad xa', porke tu xa' re' yi' mos ne mos, no lë' xtu xa' chizhi' mos; o ro' tu rë xa' re' gon mos, no lo xtu xa' le' mos naya'. Kuze' nagakt chizhi' men Dios no orze' chizhi' men dimi nela tu dios ga'. ");
INSERT INTO zcaNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Orze' mixizhnu rë men fariseo Jesús, porke dox nazhi' bixa' dimi, ");
INSERT INTO zcaNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","orze' nzhab Jesús lo bixa': ―Mis go nidi'zh wen go lo rë men; per lë' Dios nane ka xmod nak laxto' go; porke rë kwa'n zak men dox tsak, per par Dios nikap laxto' Diose. ");
INSERT INTO zcaNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","No nzhab Jesús: ―Haxta zhë che'n Juan, une naki'n mile' men kwa'n nzhab ley mbaino rë widi'zh kwa'n midi'zh rë profet. Dizde orze', nzhon men xmod yo men plo nile' Dios mandad, no jwers nile' men par yo men ze', ");
INSERT INTO zcaNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","per más jwals lox yibë' no yizhyuo ke par ded tu rë kwa'n nzobni' lo ley; sino ke rëi gak. ");
INSERT INTO zcaNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’No chi tu miyi' lë' kun una' che'n xa', no ban xa' kun xtu una', orze' nzë'b xki miyi' re' lo Dios por lë'i; mbaino miyi' kwa'n ban kun una' kwa'n milë' kun xmiyi' re', nzë'b xki ska xa' re', por kure'. ");
INSERT INTO zcaNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Nguio tu men rrik, dox nabe xa', no pura lar wen nzhak xa'; no zilita' nile' xa' lani, no dox kwa'n kar nizi' xa' par nile' xa' lani. ");
INSERT INTO zcaNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","No nguio tu men prob, xa' lë Lásaro, dub kwerp che'n xa' nzhazh lai; mbaino ro' pwert che'n rrik re' ñanu men xa' par nizob xa' ze'. ");
INSERT INTO zcaNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","No haxta rë kwa'n nzhab xan mes che'n rrik niwix xa' gao xa', no rë mbëk nizubi mizup ta' xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Per ngol tu ngubizh, ngut Lásaro, no mbiy' rë ganj che'n Dios Lásaro plo nzho Abraham; mbaino nu ska rrik ngut no miga'ch xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","No dizde le'n gabil plo nzho rrik, naxektra' xa' di yalne; no ngulits xa' lo xa' dizde zit une xa' Abraham no Lásaro nzo kun Abraham. ");
INSERT INTO zcaNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Orze' nguruzhië rrik: “¡Xuza Abraham!, bilats laxto' da, bixë'l Lásaro par gazh xa' yek bikwen ya' xa' kun nits, par gazh luzha, porke naxektra' da le'n bël re'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Per nzhab Abraham: “Xga'na, bitsila dox wen mibanal, no lë' Lásaro dox nalats miban; no nal, milox yalnalats kwa'n une xa', per lu kine kwa'n nazhe'b nal. ");
INSERT INTO zcaNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mbaino nu ska garol tsao' plo nzo go, no plo nzo no, nided tu barrank kwa'n yent cho nane plak na'ch. Kuze', rë xa' kwa'n nzho re', nagakt yi'd xa' ba', no ni rë xa' kwa'n nzho ba', nagakt yi'd xa' re'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Orze' nzhab rrik: “Kina'ba lol xuza Abraham, xë'lal Lásaro lizh xuza, ");
INSERT INTO zcaNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","plo kinun gai' wecha, nes par nayi'd bixa' plo nazhe'b nizakzi men re'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Per nzhab Abraham: “Lë' bixa' kinu ka ley kwa'n mila' Dios lo Muisés, no rë kwa'n midi'zh rë profet; rë kuba' ñal gon bixa'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Orze' nzhab rrik: “Nagont bixa' ro' rë xa' ba', xuza Abraham; naki'n ruban tu xa', par yayab rë kure' lo rë wecha, par la' bixa' rë kwa'n gat lë' nak bixa', mbaino ban bixa' nela xmod nzhakla Dios.” ");
INSERT INTO zcaNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Per nzhab Abraham: “Per chi gat ñila bixa' rë widi'zh che'n Muisés, no rë widi'zh che'n rë profet, rë xa' kwa'n midi'zh por Dios, nayot yila bixa'i, ter tu men ngut ruban, yadi'zhe lo bixa'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","No nu nzhab Jesús lo rë men che'n Me: ―Nagakt ka'n men lo kwa'n nile' nzë'b xki men lo Dios, per dox nazhe'b nzha men xa' le', nzë'b xki xtu men lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mejor wei' Dios xa' re' tuli, ke par le' xa', nzë'b xki xtu men lo Dios, tu xa' laore ngwayila Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kuze', biwi' go, chi tu wech go le' tu kwa'n gat lë' lo go, guzh go lo xa' nale'tra' xa'i; no chi mbin xa'i, orze' biya'l laxto' go kwa'n mile' xa' lo go. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","No ter gazh wëlt le' xa' kwa'n gat lë' lo go tu ngubizh, per dub gazh wëlt yubre xa' lo go ne xa': “Nale'tra'ne”, orze' biya'l laxto' go kwa'n mile' xa' lo go. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Orze' nzhab rë apost lo Señor: ―Maestr, goknu go no par más yila no Dios, par le' no rë kwa'n nazhon nela xmod nile' go ga'. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Per nzhab Jesús: ―Ter we'tsa ñila go Dios, nela xmod win lazh tu mostás ga', orze' gak gab go lo tu ya ro ba': “Yubchi ba', bizë le'n nitsdo'”, no lë'i gon kwa'n gab go. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Gab be, kinu tu rë go tu mos xa' nzha'n dan, o nikina xa' ma che'n go; no or yë'd mos di dan, nagabt go lo xa': “Guded, guzob gawal”, ");
INSERT INTO zcaNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","sino ke lë' go gab: “Bikë' kwa'n lol, par bichao' kwa'n ga̱u̱, orze' kol kwa'n ga̱u̱ no kwa'n go'n; no lu nalta' gawal no gol.” ");
INSERT INTO zcaNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","No ni xkix naza't go lo mos, por rë mandad kwa'n mile' mos re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Se'ska go, or lox le' go rë kwa'n mile' Dios mandad go, orze' ñal gab go: “No nak mos xa' niyent kwan zu', porke nab tsa kwa'n ñal le' no, mile' no.” ");
INSERT INTO zcaNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Or nzha Jesús yezh Jerusalén, nded Me sao' rë yezh kwa'n ña'n lazh men Samaria, mbaino sao' rë yezh kwa'n nzhin lazh men Galilea. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","No or nzhazhin Me ro' tu yezh, ngwachë'l lo Me chi' miyi' xa' nizak tu yalyizh kwa'n lë lepra, per haxta zit nzo bixa' lo Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","orze' nguruzhië rë xa' re', nzhab bixa': ―¡Jesús, Maestr, bilats laxto' go no! ");
INSERT INTO zcaNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","No or une Jesús bixa', nzhab Jesús: ―Wa go lo rë ngulëi', par rël xa' go. Mbaino di nzha bixa' nez, lë' bixa' ngokwen la lo yalyizh che'n bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Or une tu rë xa' re', lë' xa' miak la; orze' nguiubre xa' lo Jesús, kidi'zh xa' naye, dox nazhon Dios, ");
INSERT INTO zcaNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","mbaino ngo't kuslo xa' xan ni' Jesús par miza' xa' xkix lo Me; no xa' re' nzë yezh Samaria. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Orze' nzhab Jesús: ―Per, ¿chi gat lë't za chi' go mimbe lo yalyizh che'n go? ¿Ma ska zi yë' bixa'? ");
INSERT INTO zcaNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Chi nab tsa miyi' xa' nzë zit re', nguiubre par miza' xkix lo Dios? ");
INSERT INTO zcaNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Orze' nzhab Jesús lo xa' re': ―Watsoli no bizë; lë'l mimbe la por ngwayilal da. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Orze' minabdi'zh rë men fariseo lo Jesús, xmod lu' rë zhë, or le' Dios mandad lo yizhyuo; orze' nzhab Jesús: ―Or zhin rë zhë le' Dios mandad, gat lë't kwa'n lu' zhine lo rë men, ");
INSERT INTO zcaNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","no ni yent cho gab: “Lë'i re'”, o “Lë'i ba'”, porke lë' Dios kile' la mandad xid rë men nzho nal re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Orze' nzhab Jesús lo rë men che'n Me: ―Lë' zhë zhin, lë' go gakla ne, ter tutsa ngubizh che'n rë zhë or yala, per nayot ne goi. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","’No lë' rë men di'zh: “Lë'i re'”, o “Lë'i ba'”, per nayat go, no ni nayakë go tich bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","porke lë' zhë yala lu', nela or nikë tu do'zi' ga', niziniy tu lad no xtu lad lo yibë'. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Per galo ñal, zakzi dox da, no rë men nal re' le' naya' lon. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","No nela xmod ngok rë zhë che'n Noé, se'ga' gak zhë or yala, na Xga'n Dios no nak da tu men yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","’Le'n rë zhë che'n Noé, ndao men ngu' men, mikwa'n bixa' una', ngok jwandang che'n bixa'; haxta or mizhin zhë nguio Noé le'n yo'ya, une mile' bixa' rë kuba', orze' ngula yiu nazhe'b milo'xe rë bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","No se'ga' ngok le'n rë zhë kwa'n miban Lot; ndao men ngu' men, nguzi' bixa' mito bixa', ngo'n bixa', no michao' bixa' yo'. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Per or nguro' Lot yezh Sodoma, ngula bël no kubde ki lo yibë', par milox rë nak men ze'. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Se'ska gak zhë or ruxoba lo rë men, na Xga'n Dios no nak da tu men yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Zhë ze', tu xa' nzo yek yo' naza't la xa' par ko' xa' che'n xa' le'n yo'; o tu xa' nzo dan, naza't yëk xa' lizh xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Bitsila go kwa'n nguzak una' che'n Lot. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Xa' gat nzhaklat gak xa' men da, par le' xa' kwa'n nzhakla xa', orze' mila' xa' kwa'n ban xa' par dubta' lo Dios; per xa' la' kwa'n nzhakla xa' le' xa' por nak xa' men da, orze' lë' xa' ban par dubta' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Nin lo go, yë'l ze' or yala, nax chop xa' lo tutsa lo'n, lë' tu xa' bi, no lë' xtu xa' ya'n. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","O chop una' kiyo tutsa; lë' tu una' wë̱i̱, lë' xtu una' ya'n. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","No zhë ze', chop miyi' nzo dan; tu miyi' bi, lë' xtu miyi' ya'n. ");
INSERT INTO zcaNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Orze' minabdi'zh bixa' lo Jesús, nzhab bixa': ―Señor, ¿plo gak rë kure'? Orze' nzhab Jesús: ―Rë go nane, plo nidal ngulbech, ze' naxbi ma ngut. Sa' gak or yala: Rë men ne or zhin rë kure'. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Midi'zh Jesús kwent re', par milu' Me xmod ñal na'b men che'n Me rë wëlt lo Dios, par nacha'b bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","nzhab Jesús lo rë men: ―Le'n tu yezh nguio tu jwes kwa'n gat nzhont nzho Dios, no niyent cho nzhon xa' nzho, ");
INSERT INTO zcaNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","mbaino mis yezh ze' nzho tu una' ngut tsa'; zilita' ña una' lo jwes re' par le' jwes yalgustis kun xa' nidil una' kun lë'. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","No tu tiemp xche, net jwes ngaknu una' re', no lult mile' jwes xigab: “Ter gat nzhonta nzho Dios, no yent cho nzhona nzho, ");
INSERT INTO zcaNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","per dox nicha'b da ñi'd una' re' lon garga'l; mejor len kwa'n ne xa' par nayi'dra' xa' lon, no par nakixianra' una' re' da.” ");
INSERT INTO zcaNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Orze' nzhab Jesús: ―Bin go kwa'n nzhab jwes naya' re'; ");
INSERT INTO zcaNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","orze', ¿chi nale't Dios yalgustis por rë xa' ngule Dios par gak men che'n Me, xa' nina'b zhëy-yë'le lo Dios? ¿Chi xche par le' Diose? ");
INSERT INTO zcaNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Per na ni lo go, lë' Dios le'i lwega'. Per or yala, ¿chi yazhëlra' da rë men da, xa' ñila len yalgustis, kun rë xa' nidil bixa'? ");
INSERT INTO zcaNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","No midi'zh Jesús kure', lo pla men xa' nidi'zh, mis lë' bixa' dox nzhon bixa' ro' Dios, per rrajón bixa' lo más rë men: ");
INSERT INTO zcaNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Nguio chop miyi', ngwa bixa' le'n yado' par guna'b bixa' lo Dios. Tu xa' fariseo, lë' xtu xa' nikan dimi che'n rey. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Xa' fariseo re', dub nzuli xa', guna'b xa' lo Dios, se' nzhab xa': “O Dios; xkixal porke gat nakt da nela más rë men; rë men wa'n, no rë men kwa'n nile' kwa'n gat lë', no rë xa' nika' men gat lë't tsa'; no ni gat nakt da nela men nikan dimi che'n rey re'; ");
INSERT INTO zcaNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","na nizo xlatsa chop ngubizh le'n sman, no nizan diezmo che'n rë nak kwa'n nilen gan.” ");
INSERT INTO zcaNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Per xa' kwa'n nikan dimi che'n rey ze', zit nguzo xa', no milayët xa' lo xa', maska kikë' xa'i laz xa', no nzhab xa': “¡O Dios, bilats laxto' da, lë'da tu men nzë'b xki lol!” ");
INSERT INTO zcaNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Orze' nzhab Jesús: ―Nin lo go, or ña men nikan dimi ze' lizh, miwi' Dios lo xa', nela lo tu men yent kwan nzë'b ga'; per lo men fariseo re', nangawi't Dios wen, porke rë xa' mis lë' nidi'zh nzhon ro' Dios, lë' xa' tula; per xa' kwa'n nilibe' xmod nak, lë' Dios le', gak xa' tu men tsak. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nu nzhanu men, haxta rë më'do', par gal Jesús bimë'd, per or une rë men che'n Jesús kure', nangala'tra' bixa' ngwei' rë men më'd lo Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","per ngurezh Jesús rë më'd, mbaino nzhab Me lo rë men che'n Me: ―Nakat go yi'd rë më'd lon; porke men nak nela tu më'd ga', xa' re' yo plo nile' Dios mandad. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Walika kwa'n nin lo go; xa' kwa'n nagak nela tu më'd ga', plo nile' Dios mandad nayot xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Orze' tu xa' nile' mandad, minabdi'zh lo Jesús, nzhab xa': ―Maestr wen, ¿kwan len par ban da par dubta' lo Dios? ");
INSERT INTO zcaNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Orze' nzhab Jesús: ―¿Chon nel wen da? Yent cho wen, nab tsa Dios wen. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Lu nane la rë kwa'n nzhab ley: “Naka'tal una' gat lë't tsa'l, nagutal men, naliwa'ntal, nakë'tal kixu' xtu men yent kwan nzë'b, no gop kwent xuzal mbaino xna'l.” ");
INSERT INTO zcaNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Orze' nzhab miyi' rrik re': ―Rë nak kuba' milela dizde or win da. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Or mbin Jesús kure', orze' nzhab Me: ―Nzho xtu kwa'n jwalt le'l: Bito rë nak kwa'n kinul, orze' gudi'ze ka' rë men prob, par gapal kwa'n tsak lo yibë', orze' di'kë ticha. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Per or mbin miyi' rrik rë kure', dox trixt mizi xa', porke dox rrik xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","No or une Jesús, xmod mizi miyi' re', orze' nzhab Me: ―¡Dox nagan par tu men rrik ziyël xa' le' Dios mandad xa'! ");
INSERT INTO zcaNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Más jwals ded tu kamey xan tu yaguj, ke par yo tu rrik plo nile' Dios mandad. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Orze', rë xa' kwa'n mbin kure', nzhab bixa': ―Chi lë'i sa', ¡pas yent cho ro' lo kwa'n nazhe'b kwa'n nzho met! ");
INSERT INTO zcaNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Orze' nzhab Jesús: ―Par rë men, nzho kwa'n nagakt le' men; per Dios, yent cho tu kwa'n nagakt le' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Orze' nzhab Per lo Jesús: ―Biwi' go, lë' no mila' rë nak kwa'n kinu no, par nzadkë no tich go. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Orze' nzhab Jesús: ―Walika kwa'n nin lo go, rë xa' mila' lizh, o xuz, o xna', o wech, o bizan, o una', o xmë'd, par yo xa' plo nile' Dios mandad; ");
INSERT INTO zcaNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","no dub ban xa' yizhyuo re', más nayax kwa'n gap xa', ke rë kwa'n mila' xa' par nzadkë xa' ticha, mbaino lë' xa' ban par dubta' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ngurezh Jesús tu lad, za tu dusen men che'n Me par nzhab Me: ―Biwi'u, lë'be nzha yezh Jerusalén, plo gak rë kwa'n zaka, rë kwa'n nzobni' lo yech por rë profet, xa' midi'zh por Dios; ");
INSERT INTO zcaNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","lë' rë men chi da lo xtu ben men, xa' gat lë't men Israel, no kitnu rë men re' da, mbaino ke bixa' da, no chuk bixa' lon. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Mbaino lë' bixa' chële ticha, orze' gut bixa' da; per ngubizh yon lë'da ruban. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Per rë men che'n Me ngazobyekt bixa' widi'zh re'; porke nagakt zobyek bixa'i, porke nake rë kwa'n nanet bixa' kwan. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Or nzhazhin Jesús gax yezh Jericó, ze' nzob tu xa' nikal lo ro' nez, kina'b xa' gon. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Or mbin xa' re', nzhaded nayax men ze', minabdi'zh xa': “¿Cho rë xa' ze' ga'?” ");
INSERT INTO zcaNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Orze' nzhab men lo xa': ―Lë' Jesús xa' nzë yezh Nazaret nzhaded re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Orze' naye nguruzhië xa' nikal lo re', nzhab xa': ―¡Jesús, Xga'n Dabi! ¡Bilats laxto' da! ");
INSERT INTO zcaNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Orze' rë xa' nzha dilant, nzhab bixa' lo xa' nikal lo re': “¡Kiex, bitsao' ro'l!”, per más naye nzhab xa': ―Xga'n Dabi, ¡bilats laxto' da! ");
INSERT INTO zcaNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Orze' ngulëz Jesús, mile' Me mandad ñë'd xa' nikal lo re' lo Me, orze' nzhab Jesús lo xa': ");
INSERT INTO zcaNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Kwan tu kwa'n nzhaklal gaknun lu? Orze' nzhab xa' nikal lo re': ―Señor, nzhaklan yani lon. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Orze' nzhab Jesús: ―¡Guzhë ngwani lol!, por ngwayilal da. ");
INSERT INTO zcaNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Orze' lwega' ngwani lo xa', no nzhakë xa' tich Jesús, mbaino kidi'zh xa' dox nazhon Dios; no rë xa' une kure', nu bixa' kidi'zh nazhon Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Or mizhin Jesús ro' yezh Jericó, no or nzhaded Me le'n yezh, ");
INSERT INTO zcaNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ze' nibëz tu men rrik xa' lë Zaqueo; tu xa' nile' mandad lo rë men nikan dimi che'n rey. ");
INSERT INTO zcaNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Dox nzhakla xa' re' libe' xa' Jesús, per nagakte por tanta nayax men nzhaded ze', no nu por dox win xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Orze' mikë' Zaqueo karre, nkë xa' lo tu ya kwa'n lë sicómoro, dilant plo ded Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","No or nzhaded Jesús ze', miwi' Me al ya', une Me Zaqueo, orze' nzhab Me: ―Zaqueo, karre gula ba', porke nal, naki'n yana lizhal. ");
INSERT INTO zcaNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Orze' nayen ngula Zaqueo, nizak laxto' xa' ñanu xa' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Or une rë men kure', rë xa' nguzublo kidi'zh nakap tich Jesús, nzhab bixa': ―¡Biwi'ule!, lë' Jesús ya'n lizh tu men dox nzë'b xki lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Orze' nguzuli Zaqueo lo Jesús, nzhab xa': ―Biwi' Señor; lë'da za garol kwa'n kinun, ka' rë men prob; no chi miliwana che'n tu men, por mikiden xa', nal lë'da zhireskai tap wëlt más nayaxe. ");
INSERT INTO zcaNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Orze' nzhab Jesús: ―Nalzhë re', lë' rë xa' lizh go, lë' go ro' lo rë kwa'n nazhe'b nzadkë tich go, porke nukal nzë ben che'n Abraham. ");
INSERT INTO zcaNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Na nak Xga'n Dios, no nak da tu men yizhyuo, nzhala par nzakwana, rë xa' kilox lo rë kwa'n nzë'b xki xa' lo Dios, par kon bixa' lo rë kwa'n nazhe'b, kwa'n nzadkë tich bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Rë kwa'n kidi'zh Jesús kiyon men, no nu midi'zh Jesús tu kwent re', porke lë' Jesús gax la nzo Me par yezh Jerusalén, no rë men xa' nzhakë tich Me mile' bixa' xigab, ngane bixa' di repent, ngarulo xmod le' Dios mandad dub yizhyuo, ");
INSERT INTO zcaNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","kuze' nzhab Jesús: ―Nguio tu miyi' xga'n tu xa' ro, ngwa xa' xtu lazh men zit, par gak xa' rey lo rë melazh xa' or yubre xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","No antis di ya xa', ngurezh xa' chi' mos che'n xa' par miza' xa' tu tant ga' dimi ka' kad bixa', orze' nzhab xa': “Gukë go zhi'n kun dimi re', haxta or yala.” ");
INSERT INTO zcaNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Per rë melazh xa', niyi' nine xa', no or nzha xa' gak rey re', mixë'l rë men lazh xa' pla xa' kwa'n nguzhubner ngwayab lo xa' más nile' mandad: “Gat nzhaklat no gak xa' re' rey lo no.” ");
INSERT INTO zcaNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Per or miëk xa' re' lazh xa', lë' xa' nak la rey; orze' ngurezh rey re' rë mos che'n xa' kwa'n miza' xa' dimi ze', par ne xa' plak mile' tuga' xa' gan. ");
INSERT INTO zcaNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Xa' galo nguzubi, nzhab: “Señor, lë' xtimi go mile' gan chi' wëlt más nayaxe.” ");
INSERT INTO zcaNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Orze' nzhab rey lo xa' re': “Dox wen mile'l, kun che'p tsa kwa'n milan lol, mos wenal. Nal lë'l le' mandad lo chi' yezh.” ");
INSERT INTO zcaNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Orze' nguzubi mos rop, nzhab: “Señor, lë' dimi che'n go mile' gan gai' wëlt xtu tante.” ");
INSERT INTO zcaNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Orze' nu lo xa' re' nzhab rey: “Nal lë'l le' mandad lo gai' yezh.” ");
INSERT INTO zcaNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Per xtu mos nguzubi, nzhab: “Señor, lë' xtimi go re', lë'da ngulucha̱we̱ lo tu pañit; ");
INSERT INTO zcaNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","porke mizheb da lo go, go nak tu men nina'b kwent dimás; porke nina'b go kwa'n gat niza' go, mbaino nikan go kwa'n plo gat nzha'nt go.” ");
INSERT INTO zcaNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Orze' nzhab rey: “¡Minu la xigab che'nal! Nal nele por kwa'n nel ba'. Chi lë'l nane ka, na tu men nina'b kwent dimás, mbaino nina'ba kwa'n gat nizan, no nikana kwa'n plo gat nzha'na, ");
INSERT INTO zcaNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","orze', ¿chon nangagotal dimi da bank, par or ngayala, ngazene kun xine?” ");
INSERT INTO zcaNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Orze' nzhab rey lo rë men nzhin ze': “Bilat go dimi lo xa' re', no biza' goi, ka' xa' kwa'n mile' gan zichi'y dimás.” ");
INSERT INTO zcaNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Orze' nzhab rë xa' nzhin ze': “Señor, xa' ba' kinu la zi chi'y más.” ");
INSERT INTO zcaNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Orze' nzhab rey: “Pwes nin lo go, xa' kinu lai, mase ka' xa'; per xa' gat kinui, haxta kwa'n nile' xa' xigab kinu xa', ro' ya' xa'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Orze' nzhab rey: “Nu rë xa' kwa'n gat nzhaklat gak da rey lo ba', waka' go bixa', no bit go bixa', dilant lon.” ");
INSERT INTO zcaNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","No or milox midi'zh Jesús rë kure', orze' nzha Jesús par nez Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","No or nzhazhin la Me gax plo nzhin rë rranch kwa'n lë Betfagé no Betania, kwa'n ña'n gax plo ña'n lom kwa'n lë Olivo, orze' mixë'l Jesús chop men che'n Me, ");
INSERT INTO zcaNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","nzhab Me lo bixa': ―Wa go rranch kwa'n nzhin ba', ba' ne go tu burrit nikido', no nagat zob ni tu men tich ma; bixëk go ma no di'nu go ma, ");
INSERT INTO zcaNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","no chi nabdi'zh tu men: “¿Chon kixëk go burrit ba'?”, orze' guzh go: “Lë' Señor naki'n ma.” ");
INSERT INTO zcaNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Orze' nzha rop xa' re', mbaino se'ka ngoke, nela xmod nzhab ka Jesús lo bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","no or kixëk bixa' burrit re', orze' nzhab rë xa' nak che'n ma: ―Lë'go, ¿chon kixëk go burr ye'n ba' ga'? ");
INSERT INTO zcaNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Mikab rop xa' re': ―Lë' Señor naki'n ma. ");
INSERT INTO zcaNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Orze' ngwala' bixa' ma lo Jesús, no mixo'b bixa' xab bixa' tich ma, mbaino mizob bixa' Jesús tich ma. ");
INSERT INTO zcaNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Dub nzhazë ma nzob Jesús tich ma, no rë men ndix bixa' xab bixa' plo ded Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Or nzhalayët la Me, tich lom kwa'n lë Olivo, plo nilu' la yezh Jerusalén, orze' rë men che'n Me nguzublo kibizhië bixa' di nizak laxto' bixa', kidi'zh bixa' dox nazhon Dios, por rë kwa'n nazhon une bixa', mile' Dios, ");
INSERT INTO zcaNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","nzhab bixa': ―¡Wen nzha rey xa' mixë'l Dios! ¡Mial laxto' Dios kun rë men!, mbaino rë men yizhyuo ñal di'zh: “¡Lë' Dios nazhon mbaino wen!” ");
INSERT INTO zcaNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Orze' xid rë men re', nzhab pla men fariseo: ―¡Maestr, guzh lo rë men che'nal, di'zhtra' bixa', lu nak rey! ");
INSERT INTO zcaNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Per nzhab Jesús: ―Nin lo go, chi lë' rë men re' la', nadi'zhtra', orze', ¡lë' rë ke di'zh por lë' bixa'! ");
INSERT INTO zcaNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Or nzhazhin Jesús gax yezh Jerusalén, or une Mei, mbi'n Me por lë'i, ");
INSERT INTO zcaNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","nzhab Me: ―¡Men yezh Jerusalén, oj nal zhë re', gak libe' go Me kwa'n le', yal laxto' Dios kun go!, per nela xmod nak go nal re', nagakt libe' go Me, ");
INSERT INTO zcaNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","porke zhin zhë, lë' rë men kwa'n niyi' nine go, kurral le' bixa' go, par yent plo le' go gan, ");
INSERT INTO zcaNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","mbaino rë go gut bixa', yent kwan zine laxto' bixa' go, mbaino lo'x bixa' yezh che'n go, ni tu ke naya'nte tich weche, rë kwa'n ngokxao'we, porke nangalibe't go, zhë mbi'dtswi' Dios go. ");
INSERT INTO zcaNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","No dispwés di kure', ña Me plo nak lo luwe che'n yado' yezh Jerusalén, orze' nguzublo kigotin Me rë xa' nito, no rë xa' nizi' ze', ");
INSERT INTO zcaNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","no nzhab Me: ―Se' nzobni': “Lë' lizha nak plo nidi'zh men Lon”, ¡per go kile'i nela plo nibin rë wa'n ga', par lat xa' che'n rë men! ");
INSERT INTO zcaNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","No zilita' nilu' Jesús widi'zh che'n Dios, lo luwe che'n yado', per rë xa' kwa'n nile' mandad lo rë ngulëi', no rë xa' nilu' ley, kun rë xa' nak zhi'n yezh; kikwa'n bixa' mod par gut bixa' Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","per nangakt le' bixa'i, porke rë men yezh ze', dubla bixa' nzhon bixa' rë kwa'n nidi'zh Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","No ngol tu ngubizh, nzo Jesús lo luwe che'n yado', kilu' Me widi'zh che'n Dios lo rë xa' nzhin ze', orze' ze', mizhin rë xa' nile' mandad lo rë ngulëi', no rë xa' nilu' ley, kun rë xa' nak zhi'n yezh, ");
INSERT INTO zcaNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","nzhab rë xa' re' lo Jesús: ―Bine lo no, ¿kwan nakal par kile'l rë kure', mbaino cho mixë'lal par le'le? ");
INSERT INTO zcaNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Orze' nzhab Jesús: ―Nuka da, nabdi'zh tu kwa'n lo go, no bine goi: ");
INSERT INTO zcaNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Cho mixë'l Juan par lilëi' Juan men le'n nits? ¿Chi Diose, o mene? ");
INSERT INTO zcaNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Orze' nguzublo kidi'zh bixa' lo wech bixa': ―Chi gab be: “Lë' Dios mixë'l Juan”, orze' lë' xa' ne lo be: “¿Chonska nangayila go xa'?” ");
INSERT INTO zcaNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","No chi gab be: “Men mixë'l Juan”, orze' lë' rë men re' koke be, porke rë men zak, lë' Juan ngok tu profet, xa' midi'zh por Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Orze' nzhab bixa': ―Nanet no cho mixë'l Juan. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Orze' nzhab Jesús lo bixa': ―Nuska da, nanita cho mixë'l da kilen rë kure'. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Orze' midi'zh Jesús kwent re', lo rë men nzhin ze', nzhab Me: ―Tu miyi' mixë'n tu pedas ya gub, orze' miza' xa'i med lo rë men ga'ne; orze' nguro' xa' tu tiemp xche. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Or ngol tiemp miza'i, mixë'l xa' nak che'n ya gub re', tu mos che'n xa' par na'b xa' lo rë men ngo'ne, kwa'n gal xa'. Per rë xa' ngo'ne re', ndin bixa' mos re', no mizhire bixa' mos re' nab ya' mos. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Orze' mixë'l xa' xtu mos, no nu ska mos re' ndin bixa', no che'ptsa mile' bixa' ne', no mizhire bixa' mos re', nab ya' ska mos. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Orze' mixë'l xa' mos yon; nu ska xa' re' mitsiwe' bixa', no ngulutin bixa' mos re' al tich. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Orze' mile' xa' nak che'n ya gub re' xigab: “¿Kwan len nal? Mejor yub xga'na xëla, xa' nazhi' da, pas ro' xa' re'se gon bixa'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Per or une rë men ngo'n yuo re', xga'n xa' kwa'n nak che'ne, tutsa mia'n bixa' nzhab bixa': “Xa' re' nak che'n rëi; chao' gut be xa', par ka' be rë nak kure'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Orze' ngulutin bixa', xga'n xa' nak che'ne al tich, par mbit bixa' miyi' re'. Orze' nzhab Jesús lo rë men nzhin ze': ―Nal, ¿kwan le' xa' nak che'n ya gub re'? ");
INSERT INTO zcaNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Lë' xa' yë'd par lo'x xa' rë xa' kwa'n ngo'n ya gub che'n xa', mbaino lë' xa' za'i ga'n xtu ben men. No or mbin rë men nzhin ze' kure', nzhab bixa': ―¡Kuba'se nayot gak! ");
INSERT INTO zcaNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Per or miwi' Jesús xe lo bixa', nzhab Me: ―Aja, kwan gab widi'zh kwan nzobni' re'x: Lë' ke kwa'n ngulubi rë xa' nichao' yo', zak bixa' nazu'te, per lë'i ngok ke galo laka, kwa'n nzen dub yo'. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","No rë men yachin lo ke re', lë'i gut xa'; no chi lë' ke re' gab yek tu men, lë'i ta'ch xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Rë xa' nile' mandad lo rë ngulëi', no rë xa' nilu' ley; mis orze' ngokla bixa' ngazen bixa' Jesús, porke mizi bixa' par yek bixa' nzha kwa'n midi'zh Jesús. Per nangakt ngale' bixa'i, porke nizheb bixa' lo más rë men nzhin ze'. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kuze', mixë'l bixa' pla miyi' kwa'n le', chigab walika nzhakla bixa' ne bixa' tu kwa'n, per ka namás par la'ch bixa'i, par ne bixa' gab Jesús tu kwa'n gat ñal, par za' chi bixa' Me lo gobier che'n men Roma. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Orze' kuze' nzhab bixa' lo Jesús: ―Maestr, nzhon no kwa'n nidi'zh go, no kwa'n nilu' go, pura kwa'n ñale; no gat nibet go men or nile' go tu kwa'n par men; no nilu' go gon men ro' Dios nela xmod nzhakla ka Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Lë'o, ¿kwan ne go? ¿Chi lë'ka kix met dimi che'n rreyse, o gat lë'te? ");
INSERT INTO zcaNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Per lwega' mizi Jesús cho xigab kile' bixa'; orze' nzhab Me: ―¿Chon kizenbe' go da (kiwi' go xmod nak da)? ");
INSERT INTO zcaNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Gulo' go tu pes, par ne be xmod nake. No bineu, ¿cho nikë loi, mbaino cho lë kinui? Orze' nzhab bixa': ―César nikë loi. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Orze' nzhab Jesús: ―Ne goix, biza' go che'n César kwa'n nak che'n César; mbaino che'n Dios kwa'n nak che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","No nangaktra' ngakab bixa' lo rë men; xe mia'n bixa' tuli por xmod nkab Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Orze' nguzubi pla men saduceo lo Jesús, no rë xa' re' gat ñilat chi wali ruban men ngut, minabdi'zh bixa' kure': ");
INSERT INTO zcaNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maestr, lë' Muisés mizob lo yech, or gat tu miyi' no la' xa' una' che'n xa', mbaino nangapt xa' më'd kun lë' una', orze' wech xa' naki'n ban kun una' re' par gap xa' ngut re' më'd kun lë' una'. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pwes nguio gazh miyi' tutsa wech; xa' galo ngok tsa' tu una', no ngut xa' sin nangap xa' më'd. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Xa' mirop se'ga', ");
INSERT INTO zcaNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","no wech mion xa' se'ska, haxta za gazh bixa' ngut, sin nangapt bixa' më'd kun lë' una' re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","No lult, nu ska una' re' ngut. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","No nal, or ruban bixa', ¿cho xa' gak che'n una' re'?, porke za gazh bixa' miban kun lë' una'. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Orze' nzhab Jesús: ―Yizhyuo re', miyi' kun una' niban bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","per rë men xa' wi' Dios, ñal ban xtu yizhyuo kwa'n kinu Dios, or ruban bixa', nagaptra' bixa' una', ni nagak jwandang che'n bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","porke orze', nayotra' gat bixa', lë' bixa' gak nela ganj che'n Dios ga', no gak bixa' xmë'd Dios porke nguruban bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","No par yila go lë' rë men ngut ruban, ¿chi nagat go'l go, kwa'n midi'zh Dios lo Muisés, or une Muisés tu ya yich nzobyol? Lë' Dios nzhab: “Na nak Dios che'n Abraham, no Dios che'n Isaac, mbaino Dios che'n Jakob.” ");
INSERT INTO zcaNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Rë widi'zh re' nilu', lë' Dios gat nakt Dios, Dios che'n rë men ngut; lë' Dios nak Dios che'n rë men naban; porke lo Dios rë men naban. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Orze' nzhab pla maestr xa' nilu' ley: ―Maestr, dox wen kwa'n midi'zhal. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Orze' nangayetra' laxto' bixa', nganabdi'zh bixa' más kwa'n lo Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Orze' nzhab Jesús: ―¿Xmod nzhab men, lë' Krist nak xga'n Dabi?, ");
INSERT INTO zcaNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","porke mis Dabi mizob lo libr che'n Salmos widi'zh re': Lë' Señor nzhab lo Señor da: “Guzob lad direch da plo más tsak, ");
INSERT INTO zcaNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","haxta ke len, che'ptsa (bi'ch laka) gak rë xa' nidilal kun lë'.” ");
INSERT INTO zcaNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Orze', ¿xmod gak Krist Xga'n Dabi?, porke mis Dabi nzhab: “Lë' Krist nak Señor da.” ");
INSERT INTO zcaNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","No dub kiyon rë men kwa'n kidi'zh Jesús, orze' nzhab Me lo rë men che'n Me: ");
INSERT INTO zcaNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Neu kun rë xa' nilu' ley, napa' ke'd bixa' kwa'n nak bixa' go. Lë' bixa' ño laxto' nzhak bixa' pura lar wen, mbaino ño laxto' bixa', or nini' men lo bixa', kun rop lad ya' men zen men ya' bixa', mbaino lo rë men ño laxto' bixa' le' men se' kun lë' bixa'; no nizob bixa' pura plo nizob rë men tsak, le'n yo' plo nitse'd men widi'zh che'n Dios, mbaino lo rë lani, se'ska nile' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","No nilat bixa' haxta lizh una' ngut xmiyi'. No chigab walika men che'n Dios bixa', xche nidi'zh bixa' lo Dios; kuze' más zakzi Dios bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Dub nzo Jesús lo luwe che'n yado' kun rë men che'n Me, lë'chi ngulits Me lo Me, une Me xmod kiza' rë men rrik gon, kila bixa'i le'n alkansí che'n yado', ");
INSERT INTO zcaNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","no nu une Jesús tu una' ngut xmiyi', no prob una'; mila una' chop tsa dimi win kwa'n dox che'p tsak le'n alkansí ze', ");
INSERT INTO zcaNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","orze' nzhab Jesús lo rë men che'n Me: ―Walika kwa'n nin lo go, más kwa'n miza' una' ba' ke más rë men ba', ");
INSERT INTO zcaNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","porke rë xa' ba', kwa'n mia'n sobr lo xa', miza' bixa' gon, per una' re'se, dub niyente nizak una', miza' una' gon, rë tsa dimi kwa'n kinu una' par gao una'. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","No pla rë men che'n Jesús, kidi'zh bixa' xmod ngokxao' yado', no tatu chul rë ke nzho ta'i, no rë dimi kwa'n ngoknu men, par milu'i chul, orze' nzhab Jesús: ");
INSERT INTO zcaNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Lë' tu zhë zhin, lë' rë nak kwa'n kiwi' go lo rë, ley bil; ni tu ke kwa'n nakxao'we, ya'nte tich weche. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Orze' minabdi'zh bixa', nzhab bixa': ―Maestr, ¿pok gak rë kure'? No, ¿xmod lu' rë zhë mizhin la gak rë kure'? ");
INSERT INTO zcaNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Orze' nzhab Jesús: ―Biwi' go par yent cho kide go, porke nayax men yi'd, ded bixa' nela da ga', di'zh bixa' lo men: “Na nak Krist”; mbaino nu di'zh bixa': “Mizhin gaxla zhë lox yizhyuo”, per nayilat go bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","No or gon go kidil rë gobier, kun tsa' gubier bixa', no or kidil men kun mis gubier che'n bixa', nazhebt go kwa'n dox; porke rë kure' galo laka gak, per jwaltra' lox yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","No nzhab Jesús: ―Lë' tu lazh men dil kun xtu lazh men, no tu gubier dil kun xtu gubier, ");
INSERT INTO zcaNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","no dox rë xo ro win nayax plo, rë zhë ze', no yo yalwin no yalyizh; mbaino lo yibë' lu' rë kwa'n nazhe'b, no rë señ nazhe'b dox. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’No antis di ke gak rë kure', lë' men zen go par zakzi bixa' go, no chi bixa' go lo rë xa' nile' mandad le'n yo' plo nitse'd men widi'zh che'n Dios; no ko bixa' go lizhyi'b; no haxta chi xa' go lo rë xa' más nile' mandad, haxta lo rë rey no lo rë gobiernador, por nak go men da, ");
INSERT INTO zcaNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","nes par za' di'zh go xtizha lo rë men. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kuze', nale't go xigab kwan di'zh go lo bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","porke na gane xigab ka' go, par xmod kab go lo bixa'; mbaino ni tu bixa' gakt kab lo kwa'n di'zh go lo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Per go, haxta rë xuz go, no rë xna' go no rë wech go, mbaino rë melizh go, no rë xa' nichë'l go; mis rë xa' re' chi go lo rë men, par gut bixa' pla go; ");
INSERT INTO zcaNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","no rë nak men yi' ne' go por nak go men da; ");
INSERT INTO zcaNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","no ter zak go rë kure', per Dios kina ka go. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Por ñila go da dub kizak go rë kure', kuze' le' go ban par dubta' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Or ne go, naka'n ro' yezh Jerusalén nzhin sondad, nane la go mizhin la loxe, ");
INSERT INTO zcaNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","orze' lë' rë men Judea, ñal yuka'ch bixa' le'n rë mont, no rë xa' nzho yezh Jerusalén, ñal ro' bixa'; no rë xa' nzhin dan, ñal nayëktra' bixa' lizh bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","porke zhë re', gak zhë kwa'n gab Dios xmod gak kun rë men Israel, par gak rë kwa'n nzobni' lo ley che'n Muisés mbaino rë kwa'n mikë' rë xa' midi'zh por Dios chi tiemp. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Zhe'b nalats, nzha rë una' xa' nak xin rë zhë ze', no rë una' xa' naka' më'd orze', porke dox nazhe'b kwa'n yi'd yizhyuo rë zhë re'; no rë men yezh re', dox kwa'n nazhe'b ne bixa'! ");
INSERT INTO zcaNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","No gat bixa' kun spad, no más bixa' wei' men, par gak bixa' mos nado lo xtu men, lo más rë lazh men; no yezh Jerusalén, rë men xa' gat lë't men Israel, gak che'ne mbaino le' mandade, per lë' zhë zhin, nagaktra'i che'n bixa', mbaino nale'tra' xa' mandade. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","No nzhab Jesús: ―No yo nayax señ lo ngubizh, no lo mbëo', no lo rë mbël. Mbaino lo yizhyuo, rë lazh men yo yalnazhe'b, net men kwan le' men por dox naye nibezh nitsdo' kiyite. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Lë' rë men te'dyë'l por tanta zhe'b, por rë kwa'n gak yizhyuo re'; porke haxta rë kwa'n nzen rë kwa'n nzho lo yibë', lë'i ro' xlugare. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Orze' rë men yizhyuo ne, lë' Xga'n Dios xa' nak ska tu men yizhyuo yi'd le'n tu xkao, mbaino kun biani kwa'n nizini nayi' dox, no dox kinu Me jwers par lë' Me mandad no par le' Me rë kwa'n, kwa'n niyent cho gak le'. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Or zublo gak rë kure', list guzo go, gulits go lo go lo yibë', porke ya nzhazhin la, ro' go lo rë kwa'n nazhe'b, mbaino ban go kun lë' Me. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","No midi'zh Jesús kwent re': ―Biwi' go lo ya nzhao', no lo más rë ya; ");
INSERT INTO zcaNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","or ne go nzhaxichla rë rram che'ne, lë' go niza' kwent, lë' mbëo' nëi' nzhazhin la; ");
INSERT INTO zcaNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","no se'ga', or ne go, kiyak rë kure'; nane la go, nzhazhin la zhë, le' Dios mandad dub yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Walika kwa'n nin lo go, rë kure' gak antis dike gat rë men xa' nzho orze'. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yibë' no yizhyuo lë'i lox; per rë kwa'n nidizha, rëi lë'i zhin gak. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Bikina go go, nala't go yo rë xigab laxto' go, kwa'n le' wei' go lo rë kwa'n nzhakla kwerp che'n go, no lo rë xigab ña-ñë'd yek go, xmod pa' le' go yizhyuo re', no di repent zhin zhë nazhe'b re' lo go, ");
INSERT INTO zcaNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","porke zhë re' zhin ¡di! lo rë nak men nzhin yizhyuo, nela or nizen tramp mizin ga', yaga' men loi. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kuze' list guzou biwi'u, no guna'b go zilita' lo Dios, par le' go gan lo rë kwa'n nazhe'b yi'd yizhyuo re', mbaino par yent kwan zheb go, or zhin go lo Xga'n Dios, Me nu nak tu men yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Or zhë, nilu' Jesús widi'zh che'n Dios lo luwe che'n yado', mbaino lë' yë'l, ña Me mont kwa'n lë Olivo. ");
INSERT INTO zcaNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","No rë men nibin garzi'l laka lo luwe che'n yado', par gon bixa' kwa'n nidi'zh Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nzhazhin la lani Pask, or nzhao rë men Israel pan kwa'n niyent levadur; ");
INSERT INTO zcaNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","no rë xa' nile' mandad lo rë ngulëi', no rë xa' nilu' ley, mia'n bixa' di'zh gut bixa' Jesús xla'n, nes par naxo'b mene yek bixa', porke nizheb bixa' gon mene. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Orze' nguio Mizhab laxto' Judas Iscariote, mis tu rë xa' kwa'n nak tu dusen men che'n Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ngwa xa' re' lo rë xa' nile' mandad lo rë ngulëi', mbaino lo rë xa' nile' mandad rë xa' nikina yado', par midi'zhnu Judas rë xa' re', xmod chi Judas Jesús lo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Orze' nizak laxto' rë xa' re', no mia'n bixa' di'zh, kix bixa' ka' Judas por kure'. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Orze' nguziyël Judas. No dizde orze', nguzublo kikwa'n Judas mod par chi xa' Jesús lo rë xa' re', tu or kwa'n nayent men lo Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mizhin zhë kwa'n nzhal lani Pask, or nzhao men Israel pan kwa'n niyent levadur; zhë re' nzhut men tu mbëkxi'l. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Orze' mixë'l Jesús Per kun Juan, nzhab Me: ―Wa go, wachao' go kwa'n gao be lani pask re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Orze' nzhab bixa' lo Jesús: ―¿Plo nzhaklal yachao' noi? ");
INSERT INTO zcaNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Orze' nzhab Jesús: ―Biwi' go, or zhin go yezh Jerusalén, ze' zhë'l go tu miyi' kwa'n ñanu tu re nits, wakë' go tich xa' haxta or zhin xa' lizh xa', ");
INSERT INTO zcaNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","orze' gab go lo xa' kwa'n nak che'n yo' ze': “Lë' Maestr ne: ¿Lu' go plo gao Maestr kun rë men che'n Maestr nal lani re'?” ");
INSERT INTO zcaNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Orze' lë' xa' lu' tu kwart ro lo go, kwa'n nzob xtu pis ya, no rë kwa'n nzhin la le'ne; orze' ze' bichao' go kwa'n gao be. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Orze' ngwa bixa', no se'ka ngoke nela xmod nzhab ka Jesús lo bixa', orze' ze' michao' bixa' kwa'n gao bixa' lani pask re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","No or ngol or, nguzob Jesús lo mes kun rë apost che'n Me, ");
INSERT INTO zcaNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","orze' nzhab Me: ―¡Dox nzhapa gan gao be lani Pask re', antis di zakzi da mbaino gat da!, ");
INSERT INTO zcaNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","porke nin lo go, nayotra' ga̱u̱n lani pask re'; haxta or le' Dios mandad, orze' ga̱u̱ne xtu xëlt. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Orze' nguzen Me tu bas, miza' Me xkix lo Dios, nzhab Me: ―Gu' go kure', no gudi'z goi xid rë go, ");
INSERT INTO zcaNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","porke lult nal go'n nits gub yizhyuo re'. Or go'ne xtu wëlt plo nile' Dios mandad, xa'la mode. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Orze' nguzen Me pan, miza' Me xkix lo Dios, orze' michi'x Mei, no miza' Mei ka' rë men che'n Me, orze' nzhab Me: ―Kure' nak kwerp da kwa'n zan por rë go; se' bile' go dubta', nela xmod kilen re', par tsila go da. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","No se'ska mile' Me, or milox ndao xche' bixa', nguzen Me kwa'n nzho bin, orze' nzhab Me: ―Bin re' nak di nueb, kwa'n mila' Dios di'zh par rë men da, za' Dios yalnazhon ka' bixa', por ren da kwa'n xo por rë go. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Per biwi'u, xa' chi da lo rë men, lë' xa' nzob kuda lo mes re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Na, Xga'n Dios mbaino nak da tu men yizhyuo; nak la di'zh zakzi da, per xa' kwa'n chi da lo rë men, ¡nazhe'b mal nzha xa' re'! ");
INSERT INTO zcaNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Orze' nguzublo kidi'zh rë men che'n Me: “¿Cho xa' kwa'n nzho xid be, gak xa' kwa'n le' kure'?” ");
INSERT INTO zcaNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","No rë men che'n Me nguzublo kichëlro' bixa', par nabei cho gak xa' le' mandad xid bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","orze' nzhab Jesús lo bixa': ―Rë xa' nak rey lo rë men gat lë't men Israel, dox nile' bixa' provech rë men re'; mbaino rë más rë xa' nile' mandad lo rë men re', mis lë' bixa' nidi'zh dox wen nile' bixa' rë kwa'n. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Per go, nale't go sa'. Mejor cho go nzhakla le' mandad, go ze' gak xa' más win; no xa' nizo dilant, nak nela tu mos ga'. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","No, ¿cho más nile' mandad? ¿Chi men nizob lo mese, o xa' nichi kwa'n gao mene? ¿Chi gat lë't xa' nizob lo mese? Per na, nak xid go nela tu men nichi kwa'n lo men ga'. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’No go, dubta' nguzo go kuna, or nguzaka rë kwa'n milinu men da. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kuze', nela mine' Xuza poder par len mandad, se'ska nene ka' go par le' go mandad, ");
INSERT INTO zcaNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","nes par gao go, no go go lo mes da, plo nilen mandad; no zob go plo le' go mandad lo za tu dusen ben men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","No nu nzhab Señor: ―Simón, Simón; biwi' lë' Mizhab guna'b par nabei, cho go le' xa' gan ko' xa' lon, nela xmod nitsumbe men triu ga', ");
INSERT INTO zcaNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","per na guna'b lo Dios por lu, par nala'l yilal da; no or yëkal lon, goknu rë wechal par zo bixa' naye lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Orze' nzhab Per: ―Señor, ter lizhyi'b yo'n kun go, no haxta ter gat da kun go. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Orze' nzhab Jesús: ―Nin lol Per; antis di ke kë' gai kant, lë'l gab chon wëlt gat nilibe'tal da. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Orze' nzhab Jesús: ―Or mixëla go, nin yent kwa'n wei' go nez; ni tu bols, ni kwa'n nigo go dimi che'n go, ni yalyid che'n go, no, ¿chi ngok jwalt tu kwa'n lo go? Orze' nzhab bixa': ―Yent kwan ngak jwalt lo no. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Orze' nzhab Jesús: ―Per nal nin lo go, xa' kinu bols, wei' xa'i; no xa' kinu dimi, wei' xa'i; no xa' gat kinu spad, to xa' kwa'n nzhak xa' par zi' xa' tube, ");
INSERT INTO zcaNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","porke nin lo go, nak la di'zh gak rë kwa'n nzobni' por da, widi'zh kwa'n nzhab: “Nu xa' nzho xid rë xa' más nzë'b xki lo men.” Walika rë kwa'n nzob lo yech por da, lë'i gak. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Orze' nzhab rë men che'n Jesús: ―Señor, biwi' go, lë' chop spad re'. Orze' nzhab Jesús: ―Une lai, nadi'zhtra' go. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Orze' nguro' Jesús nela xmod nile' ka Me, nzha Me mont plo lë Olivos, nu rë men che'n Me, nzhakë tich Me. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","No or mizhin Me ze', nzhab Me lo rë men che'n Me: ―Bina'b go lo Dios, par nayachin go lo kwa'n gat lë'. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Orze' nguruya' Jesús tu lad di plo nzhin rë men che'n Me, zit nela plo nichizhin men tu ke ya' men ga'; ze' nguzuxib Me, par kina'b Me lo Dios, ");
INSERT INTO zcaNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","nzhab Me: ―Payë', chi nzhaklal, gulo' da lo kwa'n nazhe'b re'. Per gat lë't kwa'n nin gak, sino kwa'n nzhaklale. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Orze' nguruxo'b tu ganj lo yibë', par miza' jwers ka' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","No nazhe'b niwin laxto' Jesús nela tu men naxiat ga', orze' más naye kina'b Me lo Xuz Me; no nits nzhaknei' Me ngob lo yuo, rë lan ro nela ren ga'. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Or milox guna'b Jesús, ngwatso Me ña Me lo rë men che'n Me, orze' rë men che'n Me naxnaa por dox niwin laxto' bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","orze' nzhab Jesús lo bixa': ―¿Chon naxnaa go? Waxche go, no guna'b go lo Dios, par nayachin go lo kwa'n gat lë'. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Stubi kidi'zh Me, lë'chi mizhin tu bëd men, no xa' kwa'n lë Judas, mis tu rë xa' kwa'n nzho xid tu dusen men che'n Jesús, dilant laka xa' re', orze' nguzubi xa' lo Jesús par michiro' xa' ta' kwats Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","orze' nzhab Jesús: ―Judas, na Xga'n Dios no nak da tu men yizhyuo, no ¿chi par chil da lo rë men re', chiro'l ta' kwatsa? ");
INSERT INTO zcaNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","No rë men che'n Jesús, or une bixa' kure', nzhab bixa': ―Señor, ¿dil no kun spad? ");
INSERT INTO zcaNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","No tu rë men che'n Jesús, micho' tu nzha mos che'n ngulëi' ro, lad direch, ");
INSERT INTO zcaNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","orze' nzhab Jesús lo rë men che'n Me: ―¡Bila' go, unelai! Orze' migal Jesús nzha mos ze', no lwega' miliwen Jesuze. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","No nzhab Jesús lo rë xa' kwa'n nile' mandad, no lo rë ngulëi'; mbaino lo rë xa' nikina yado', no lo rë xa' nak zhi'n, rë xa' kwa'n nzë par zen Jesús: ―¿Chon nzatsen go da kun spad no kun yarrot? Chigab tu wa'n nzatsen go. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Rë ngubizh nguzon kun go le'n yado', no nangazent go da; per nal yë'l re' nak or che'n go, no or che'n Mizhab. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Orze' nguzen bixa' Jesús, ñanu bixa' Me lizh ngulëi' ro; no lë' Per zit-zit nzhakë Per tich rë men ñanu Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","No or mizo'l bixa' tu ki lo luwe, orze' nguzob bixa' naka'n par bizh bixa', mbaino nu Per nguzob xid bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","No tu una' kwa'n nikë zhi'n ze', nzob gax plo kichë' Per, xe miwi' una' lo Per, orze' nzhab una': ―¡Nuka miyi' re' nikizë kun Jesús! ");
INSERT INTO zcaNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Orze' mika'ch Per, nzhab Per: ―Wi'le una', nalibe'ta' xa' ba'. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Guzhël la di ze', xtu xa' nzhab lo Per: ―¡Nuka lu nak tu xpen xa' ba'! Per nzhab Per: ―A'a mbee', gat nakt dai. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","No dispwés, pas nzha tu or, lë'chi xtu xa' kiyab garga'l: ―¡Sigurka, nu ka xa' re' nikizë kun xa' ba', porke nu ka xa' re' nzë lazh men Galilea! ");
INSERT INTO zcaNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Orze' nzhab Per lo xa' re': ―Per mbee', ¡naneta kwan kidi'zhal! No stubi kidi'zh Per kure', lë'chi mikë' tu gai kant, ");
INSERT INTO zcaNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","orze' miëk Jesús, miwi' lo Per, orze' mitsila Per kwa'n nzhab Señor: “Chon wëlt gabal: Gat nilibe'ta'l da, antis di kë' nguidgai kant.” ");
INSERT INTO zcaNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Orze' nguro' Per tich, dox nzho'n Per. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Rë xa' kikina Jesús, dub kiyin bixa' Me, kixizhnu bixa' Me, ");
INSERT INTO zcaNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","nu mitsao' bixa' lo Jesús, no nzhab bixa': ―¡Bine, cho kiyinal nabei! ");
INSERT INTO zcaNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","No nu nzhab bixa' más kwa'n gat lë' lo Jesús par nde bixa' Me. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","No or ngwanilyuo, migan rë xa' nak zhi'n yezh, no rë xa' nile' mandad lo rë ngulëi', mbaino rë xa' nilu' ley, no mbiy' bixa' Jesús plo nzhin rë gustis xa' más nile' mandad, ze' minabdi'zh bixa' lo Me, nzhab bixa': ");
INSERT INTO zcaNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Bine lo no, chi lu ka nak Krist. Orze' nzhab Jesús: ―Chi nin: “Nakai”, nayilat goi, ");
INSERT INTO zcaNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","no chi nabdi'zha tu kwa'n lo go, nanet goi. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Per dizde nal re', lë' Xga'n Dios, xa' nak ska tu men yizhyuo, zob lad direch che'n Dios, Me kwa'n nile' rë kwa'n. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Orze' rë bixa' minabdi'zh, nzhab bixa': ―¿Chi lu ka nak Xga'n Dios? Orze' nzhab Jesús: ―Go kine nai. ");
INSERT INTO zcaNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Orze' nzhab bixa': ―Gat naki'ntra' be, más men ne kwa'n lo be. Pwes mis be mbin kwa'n midi'zh xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Orze', ngwatso rë bixa', ñanu bixa' Jesús lo Pilat. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ze' michao' bixa' di'zhyix, nzhab bixa': ―Lë' xa' re' kikide men lazh no, no ne xa', gat ñalt gax dimi che'n rey César; no nidi'zh xa', lë' xa' nak Krist, mbaino nu nak xa' rey nidi'zh xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Orze' nzhab Pilat lo Jesús: ―¿Chi lu ka nak rey che'n rë men Israel? Orze' nzhab Jesús: ―Go kine nai. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Orze' nzhab Pilat lo rë xa' nile' mandad rë ngulëi', no lo más rë men nzhin ze': ―Neule, na miwi', yent kwan nak xa' re' par ganin, lë' xa' nzhap dol. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Per más naye kibizhië bixa', nzhab bixa': ―Xa' re' kiki'l rë nak men Judea kun rë kwa'n kilu' xa'. Dizde kun rë men Galilea nguzublo xa', no nal, haxta re' kile' xa'i. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","No or mbin Pilat rë kure', minabdi'zh xa': ―¿Chi lazh men Galilea nzë miyi' ba'? ");
INSERT INTO zcaNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Orze' nzhab rë men ze': ―Walikai, men Galilea xa'. No or mbin Pilat, lë' Jesús nzë plo nile' Herodes mandad, orze' mixë'l Pilat Jesús lo Herodes, no lë' Herodes le'n rë ngubizh ze', mer nzo xa' yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","No or une Herodes Jesús, dox nizak laxto' xa', porke nzhala, nzhakla Herodes ne xa' Jesús por rë kwa'n nzhon xa' nile' Jesús; kuze' nzhakla xa' ne xa' le' Jesús tu señ nazhon. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nayax dox kwa'n minabdi'zh Herodes lo Jesús, per yent kwa'n ngakab Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Rë xa' nile' mandad lo rë ngulëi', no rë xa' nilu' ley nzhin ze', dox kikë' bixa' kixu' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Orze' Herodes no rë sondad che'n xa', nguzhitnu bixa' no mixizhnu bixa' Jesús; migak bixa' tu lar wen Jesús, kwa'n nzhak rey; orze' mixë'lska xa' Jesús lo Pilat xtu wëlt. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","No mis zhë ze', michë'l Pilat no Herodes, porke nzhala ze', lë' bixa' nidil. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Orze' mikan Pilat rë xa' nile' mandad lo rë ngulëi', no rë xa' nak zhi'n yezh, mbaino rë men yezh, ");
INSERT INTO zcaNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","orze' nzhab Pilat lo bixa': ―Biwi'u, go michi xa' re' lon, no ne go, lë' xa' kichëldil men, per na minabdi'zh lo xa' lo rë nak go; no ni tu kwa'n ne go nak xa', gat walit. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","No nu ska Herodes nane, gat nzhapt xa' dol, kuze' mixë'l Herodes xa' lon xtu wëlt, ne goi nal, yent kwa'n nzë'b xa' par ñal gat xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nal re', dispwés di rële tich xa', lë' xa' liyan. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","No rë lani Pask, niliya' Pilat tu men nzho lizhyi'b, ");
INSERT INTO zcaNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","per rë bixa' nguruzhië: ―¡Naliya't go xa' re', biliya' go Barrabás! ");
INSERT INTO zcaNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","No lë' Barrabás nzho lizhyi'b por michëldil xa' men yezh, no por mbit xa' men. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Per Pilat ngokla ngaliya' Jesús, no nzhab xa'i xtu wëlt, ");
INSERT INTO zcaNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","per rë men ze' garga'l nguruzhië bixa', nzhab bixa': ―¡Bikë' go xa' lo krus! ¡Bikë' go xa' lo krus! ");
INSERT INTO zcaNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","No wëlt yon nzhab Pilat lo bixa': ―Per, ¿kwan tu kwa'n mal mile' xa' re'? Na miwi', yent kwan nak xa', par ñal gat xa'. Nal re', lox rële tich xa', orze' liyan xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Per más naye kibizhië bixa': “¡Bikë' go xa' lo krus!”, haxta ke mile' bixa' gan kwa'n nzhakla bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Orze' nguziyël Pilat kwa'n mina'b bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","no miliya' Pilat, xa' kwa'n michëldil men no xa' kwa'n mbit men, porke xa' re' ngokla bixa'; orze' michi Pilat Jesús lo rë men, par mile' bixa' kwa'n nzhakla bixa' kun lë' Me. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Or ñanu bixa' Jesús plo gat Me, nez nguzen bixa' tu miyi' xa' lë Simón, xa' nzë lazh men Cirene, se' ñë'd xa' re' di dan, no mile' bixa' mbiy' xa' re' krus che'n Jesús yën xa', nzhakë xa' tich Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nayax men nzhakë, no nayax una' nzho'n naye, di yalnawin por kwa'n kizak Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Orze' miëk Jesús lo rë una' ze', nzhab Me: ―Rë go una' Jerusalén, nago'nt go por na; mejor bi'n go por mis go no por rë xmë'd go, ");
INSERT INTO zcaNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","porke biwi'u, lë' zhë zhin gab men: “Wen nzha rë una' kwa'n nangapt më'd, no rë una' kwa'n nangayot ngaza' chich ngo më'd.” ");
INSERT INTO zcaNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Orze' gab men lo rë yi': “Gob yek no”, no lo rë lom: “Bitsao' no”, ");
INSERT INTO zcaNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","porke chi kun tu ya nayë' nile' bixa' kure', no nal kun ya bizh, ¿kwan le' bixa' kun lë'i? ");
INSERT INTO zcaNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","No nu ñanu bixa' chop men mal, par nu bixa' gat kun Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","No or mizhin bixa' lugar kwa'n lë Kalaber, ze' mikë' bixa' Jesús lo krus; mbaino xchop men mal ze', tu xa' lad direch, no xtu xa' lad skierd che'n Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Orze' nzhab Jesús lo Dios: ―Payë', biche' go kwa'n nzë'b xki rë men re', porke nanet bixa' kwan kile' bixa'. No rë sondad nguzhit bixa', par cho le' gan xab Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","no rë men nzhin ze' niwi'; no haxta pla rë xa' nak zhi'n mixizhnu bixa' Jesús, nzhab bixa': ―¡Nayax men miliwen xa' ba', nal nabei, chi walika nak xa' Krist, xa' kwa'n ngule Dios, pwes ñal mis lë' xa' le', nagat xa'! ");
INSERT INTO zcaNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nu rë sondad mixizhnu Jesús, nguzubi bixa' kiza' bixa' nits yi'n binagr go Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","no nzhab bixa': ―Chi lë'i lu nak rey lo rë men Israel, ¡bile', nagattal! ");
INSERT INTO zcaNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","No lo tu tab, nkë tu widi'zh yek krus che'n Me kun letr grieg, no letr latín, mbaino letr hebreo. Se' nzhabe: “Xa' re' nak rey che'n rë men Israel.” ");
INSERT INTO zcaNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","No tu rë miyi' xa' nikë lo krus, xa' mal ze', midi'zh xa' kwa'n gat lë' lo Jesús, nzhab xa': ―¡Pwes lu nak Krist! ¡Bile' nagatta'l, mbaino nu no nala'tal gat! ");
INSERT INTO zcaNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Per xtu xa' kwa'n nikë xtu lad ta' krus, nzhab xa' lo xa' ze': ―¿Chi gat nizhebtal ninel Dios, ter sa' kizakzil? ");
INSERT INTO zcaNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Be ñalkai kizakzi be por kwa'n mile' be, per xa' re', yent cho tu kwa'n mal mile' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Orze' nzhab xa' re' lo Jesús: ―Jesús, bitsila go da or yë'd go, le' go mandad. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Orze' nzhab Jesús: ―Sigurka, mis nal re', lë'l yo kuna lo yibë'. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Pas como garol ngubizh nguzublo mikao dub lo yizhyuo, midi'y como chon or; ");
INSERT INTO zcaNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","mikao lo ngubizh, no ngurëz lar kwa'n nikë le'n yado', garolta' ngoke, ");
INSERT INTO zcaNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","orze' naye guna'b Jesús lo Dios, nzhab Me: ―¡Payë'! ¡Le'n ya'l, lan sprit da! Or milox midi'zh Jesús kure', ngut Me. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","No or une xa' nile' mandad lo rë sondad román, kwa'n ngok re', midi'zh xa' nazhon Dios, nzhab xa': ―Walika, yent kwan nzë'b miyi' re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","No rë xa' kwa'n nzhin ze', or une bixa' kwa'n ngok re', ña bixa' maska kiyich bixa' laz bixa' por tanta nalats kure'. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Per rë xa' kwa'n nilibe' Jesús, no rë una' kwa'n nkizë tich Jesús dizde or nkizë Me lazh men Galilea, zit nzo bixa', kiwi' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","No nzho tu miyi' lë Che, nu xa' nak zhi'n xid rë gustis xa' más nile' mandad lo rë men Israel. Dox wen miyi' re', no menaye xa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Gat nut xa' re' nzho lad che'n rë xa' mbit Jesús, porke nu ka miyi' re', kimbëz or zhin zhë le' Dios mandad. No yezh Arimatea nzë xa' re', kwa'n ña'n lazh men Judea. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Miyi' re' ngwa lo Pilat, par guna'b xa' kwerp che'n Jesús par ga'che. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","No or mila xa' kwerp che'n Jesús lo krus, orze' michël xa' lare', orze' ngwaka'ch xa' Jesús le'n tu ba' pura ke, plo nagat ga'ch ni tu men. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","No zhë re', zhë kwa'n nichao' xa' kwa'n, par zublo zhë kwa'n nayi' kë men Israel zhi'n, no mer gal or kwa'n zublo zhë re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","No rë una' kwa'n nkizë tich Jesús dizde lazh men Galilea, ngwatsi' bixa' ro' ba', par une bixa' xmod nzho'b kwerp che'n Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Or miëk rë una' re' par lizh, michao' bixa' aseit nax par ko bixa'i kwerp che'n Jesús; orze' mile' bixa' diskans ngubizh ze', nela xmod nzobni' ka lo ley kwa'n mila' Dios lo Muisés. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","No primer zhë che'n sman, garzi'l laka ngwa rë una' ro' ba', no nzhanu bixa' aseit nax kwa'n michao' bixa', no nzho zipla una' xid bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","No une bixa', lë' ke kwa'n nayao' ro' ba', nax la tu lad; ");
INSERT INTO zcaNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","no or nguio bixa' le'n ba', une bixa' yentra' kwerp che'n Señor Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","orze' xe mia'n bixa' tuli por kure', lë'chi, ¡di! nguruxo'b chop miyi' plo nzhin bixa', maska ñaz bël xab rop miyi' re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","No por tanta mizheb rë una' re', haxta lo yuo ngo't kuslo biuna', no nzhab rop miyi' ze': ―¿Chon kikwa'n go Me naban xid rë men ngut? ");
INSERT INTO zcaNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yentra' Me re', lë' Me nguruban. Bitsila go xmod midi'zh Me lo go, or stubi nzo Me lazh men Galilea, ");
INSERT INTO zcaNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","or midi'zh Me: “Na nak Xga'n Dios, no nak ska da tu men yizhyuo, lë' men kwa'n más nzë'b xki lo Dios zen da, mbaino kë' bixa' da lo krus; per ngubizh yon, lë'da ruban.” ");
INSERT INTO zcaNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Orze' mitsila rë una' ze' widi'zh che'n Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","No or miëk bixa' di ro' ba', ngwayab bixa' rë kure' lo za chi' bitub men che'n Jesús, no lo más rë xa' kwa'n nzhin ze'. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Rë una' kwa'n ngwayab rë kure' lo rë apost nak Mari Madalén, no Juan, mbaino Mari xna' Jakob, no kun zipla ra' una'. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Per rë miyi' re', xa' nak men che'n Jesús, mile' bixa' xigab, gat lë't xti'zh menaye rë kwa'n ngwayab rë una' re', kuze' nangayilat bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Per orze' nguro' Per, karre nzha Per ro' ba', no or ndixni xa' le'n ba', une Per, nab tsa lar kwa'n ngurël Jesús nax tsa ze'. Lwega' miëk Per, net xa' kwan le' xa' por kwan ngok re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","No mis zhë ze', nzha chop men che'n Jesús yezh kwa'n lë Emaús, ze' ña'n chi' bitub kilómetro par yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Dub nzha rop xa' re' nez, kiza' bixa' kwent lo wech bixa', rë kwa'n ngok yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","No dub kidi'zh bixa' rë kure', lë'chi nguzubi Jesús, ñazë Jesús kun lë' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Per mitsao' Dios lo rop xa' re', par nangalibe' bixa' choi, ");
INSERT INTO zcaNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","orze' nzhab Jesús lo bixa': ―¿Kwan kidi'zh go dub nzë go nez? Orze' ngulëz bixa', dub niwin laxto' bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","orze' nzhab tu xa' lë Cleofas: ―¿Chi nab tsa lu nzë zit, nanetal kwa'n laore ngok laka yezh Jerusalén ba'? ");
INSERT INTO zcaNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Orze' nzhab Jesús lo bixa': ―¿Per kwan ngokx? Orze' nzhab bixa': ―Lë' Jesús xa' nzë yezh Nazaret, tu xa' midi'zh por Dios; milu' xa' kwa'n dox poder che'n Dios kinu xa', por rë kwa'n mile' xa', no por rë kwa'n midi'zh xa'. Rë kure' milu', walika mixë'l Dios xa', no milibe' mene. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","No rë xa' nile' mandad lo rë ngulëi', no rë xa' nzo lo no, michi bixa' Jesús, lo rë xpen gubier Roma, par mile' bixa' mandad, ngut Jesús, mbaino mikë' bixa' Jesús lo krus. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Mbaino, no kimbëz, lë' xa' re' xa' mixë'l Dios, par ko' rë men Israel ya' xtu ben rë men nakap; no nalre' nzhala chon ngubizh ngok rë kure'. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","No nu pla una' xa' nikizë kun no, mile' bixa' mia'n xe no tuli, nal garzi'l re', or ne bixa' ngwa bixa' ro' ba'; ");
INSERT INTO zcaNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","une bixa' yentra' kwerp che'n Jesús le'n ba', mbaino nu nguruxo'b chop ganj lo bixa' kwa'n nzhab: “Lë' Jesús nguruban.” ");
INSERT INTO zcaNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","No ngwatsi' pla rë xpen no ro' ba', no nu bixa' une, nela xmod midi'zh ka rë una' ze', per nanganet bixa' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Orze' nzhab Jesús: ―¡Dox naxeen go par zobyek go rë kwa'n, no nazhe'b nen par yila go rë kwa'n midi'zh rë profet, xa' midi'zh por Dios nzhala! ");
INSERT INTO zcaNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","No, ¿chi gat naki'nt zakzi Krist, zak Krist rë nak kure', antis di ke ruxo'b Me le'n biani ro, par le' Me mandad? ");
INSERT INTO zcaNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Orze' nguzublo kidi'zh Jesús, dizde kwent che'n Muisés, haxta kwent che'n rë profet xa' midi'zh por Dios. Midi'zh Me rë nak plo nzobni' kwent che'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","No or nzhazhin bixa' tu yezh win kwa'n nzha bixa', mile' Jesús nela tu men nzha más zit ga', ");
INSERT INTO zcaNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","per mikwë'z bixa' Jesús, nzhab bixa': ―Más wen biya'n go kun no, porke nzhazhëlalyuo, lë' yë'l nzadla la. Orze' nguio Jesús par ya'n Jesús kun lë' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","No or nguzob bixa' lo mes par gao bixa', orze' nguzen Me pan, miza' Me xkix lo Dios, orze' michi'x Mei no miza' Mei ka' rop xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Orze' mixa'l lo bixa', milibe' bixa' Jesús; per mitlo Jesús lo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Orze' nzhab tu xa' lo xtu xa': ―Kuze' ka, mizi be tu kwa'n le'n laxto' be, or kidi'zh Me rë kwa'n nzobni' lo yech lo be. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mis orze' miëk bixa' par yezh Jerusalén, plo nzhin za chi' bitub men che'n Jesús kun más rë men, ");
INSERT INTO zcaNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","no nzhab más rë xa' nzhin ze': ―Walika, nguruban Señor, porke nuka lo Per ngurulo Me. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Orze' midi'zh rop xa' re', rë kwa'n nguzak bixa' nez, no xmod ngokbe' bixa' Jesús, or michi'x Jesús pan lo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","No stubi kidi'zh bixa' kure', lë'chi ngurulo Jesús, nguzo Me garol tsao' plo nzhin bixa', no nzhab Me: ―Chul guzhin go. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Orze' dox mizheb bixa', no mile' bixa' xigab, paste tu mbi che'n tu men ngut une bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","orze' nzhab Jesús: ―¿Chon nizheb go?, no, ¿chon kwan kile' go xigab le'n laxto' go, ke gat lë't dai? ");
INSERT INTO zcaNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Biwi' go ya'n no ni'n; lë'i na ka. Bigal go da par ne goi; porke lë' tu mbi che'n tu men ngut, gat kinute bë'l no ni wes, per na biwi'u, lë'i kinun. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","No or milox nzhab Me kure', milu' Me ya' Me no ni' Me, ");
INSERT INTO zcaNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","per rë men che'n Me stubi gat ñilat bixa'i, por tanta nizak laxto' bixa'; net bixa' kwan le' bixa', orze' nzhab Jesús: ―¿Kwan tu kwa'n kinu go gao be re'? ");
INSERT INTO zcaNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Orze' miza' bixa' tlë' mbël kwa'n ngu'y lo ki, no che'p mizhin ser, ");
INSERT INTO zcaNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","no nguzen Jesuze no ndao Mei lo rë bixa', ");
INSERT INTO zcaNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","orze' nzhab Me: ―Rë kwa'n nguzaka re', lë'i ni ka lo go or stubi nzon kun go; naki'n gak rë kwa'n nzobni' lo ley kwa'n mila' Dios lo Muisés por da, no rë kwa'n midi'zh rë profet, rë xa' kwa'n midi'zh por Dios, mbaino rë kwa'n nzobni' lo Salmos. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Orze' mile' Jesús mixa'l yek bixa', par zobyek bixa' rë kwa'n nzobni' lo Yech che'n Dios, ");
INSERT INTO zcaNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","no nzhab Jesús lo bixa': ―Se' nzobni': Lë' Krist naki'n zakzi, per ngubizh yon lë' Me ruban; ");
INSERT INTO zcaNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","no nu nzobni', naki'n re'ch widi'zh che'n Me, par gon rë men xmod nigo' Me men lo kwa'n nzë'b xki men lo Dios chi lë' men chë' xmod nak men lo Dios, mbaino yila bixa' Krist; galo laka yezh Jerusalén zublo gon men kure'. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Rë go nak xa' mbin kure', no une go rë kwa'n ngok por da; ");
INSERT INTO zcaNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","no biwi'u, nal lë'da xë'l kwa'n ne' Xuza ka' go; per biya'n go yezh Jerusalén, haxta or yo Sprit che'n Dios laxto' go. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Orze' ñanu Jesús rë men che'n Me haxta yezh Betania, no ngulits Me ya' Me, guna'b Me ya rë men che'n Me wen, ");
INSERT INTO zcaNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","no dub kidi'zh Jesús kure', nkili Me lo yibë' haxta mitlo Me. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","No dispwés di miza' rë men che'n Me xkix lo Dios, orze' miëk bixa' yezh Jerusalén, dox nizak laxto' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","No zilita', rë zhë nizo bixa' yado', nidi'zh bixa' nazhon Dios no niza' bixa' xkix lo Me.");
INSERT INTO zcaNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ni naga yo yizhyuo, lë' Widi'zh che'n Dios ya nzho la; no kun Dios nzho Widi'zh ze' no yub Dios nak Widi'zh ze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Dizde orze', lë' Me re' ya nzho la kun Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Por lë' Me re' ngulo Dios rë nak kwa'n, orze' rëi nguio; no chi gat lë' por lë' Me re'i, yent kwan ngayo. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Por lë' Me re' nzho yalnaban kun Dios par rë men, no lë' yalnaban kwa'n kinu Me re' nak ki par rë men. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Lë' ki re' nizini lo nakao, mbaino nagakt tsiyal nakao ki re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nguio tu xa' nguru'lë Juan. Dios mixë'l xa' re' ");
INSERT INTO zcaNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","par midi'zh xa' kwent che'n Me nak Ki re', par yila rë men widi'zh che'n Me re' por kwa'n midi'zh Juan lo men. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Gat lë't Juan nak Ki re', per mbi'd Juan par milu' xa' lo men cho xa' nak Ki re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ki kwa'n nizini lo rë men yizhyuo re', lë' Ki re' nzhazhin la gax yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Lë' Me nak Ki re', miban Me yizhyuo re', no por Me re' nguio yizhyuo re'; per rë men yizhyuo nangalibe't bixa' Me nak Ki re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mbi'd Me re' lo rë men Israel, xa' nak melazh Me, per rë men re' nangalibe't bixa' Me nak Ki re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Per par rë xa' ñila widi'zh che'n Me no rë xa' nzhon ro' Me re', mile' Me ngok bixa' xmë'd Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Rë xa' re' Dios mile' bixa' xmë'd Dios; per or ngol rë xa' re', nangalnut bixa' kure', sino por xigab che'n Dios mile' Dios bixa' xmë'd Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kuze' lë' Me nak Widi'zh re' ngol nela xmod nzhalka tu men se'ga, no miban Me re' xid no, no une no yalnazhon che'n Me, yalnazhon kwa'n nab tsa Me nak Xga'n Xuz be Dios. No milu' Me haxta plo nazhi' Dios be mbaino xmod pa' nak Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan midi'zh lo rë men por kwent che'n Jesús; se' midi'zh Juan naye lo rë men: ―Lë' Me re', Me mizeta lo go or nin: “Lë' Me nzadkë ticha re' más tsak lon, porke ni naga gal da, lë' Me nzho la.” ");
INSERT INTO zcaNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Mile' Me, kad no kinu yalnaban nela lë' Me ga', no tich guchin kwa'n nazhon nixë'l Me par no zilita'. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Por Muisés mile' Dios milibe' men Ley; per por Jesukrist, mile' Dios milibe' be dox nazhi' Dios be, no xmod pa' nak Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Lalta' yent cho gat ne Dios; nab tsa Xga'n Dios nane, Me nak yub Dios no Me nzho tutsa kun Dios; lë' Me re' milu' lo be xmod nak Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Xa' nzo lo rë men Israel xa' nzho yezh Jerusalén, mixë'l bixa' pla ngulëi' kun pla levita par mina'bdi'zh bixa' cho nak Juan. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Orze' tuli nzhab Juan lo bixa': ―Gat lë't da nak Krist xa' nak di'zh yi'd. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Orze' nzhab bixa' lo Juan: ―¿Cho ska lux, mbaino kwan nakal? ¿Chi lu profet Li, xa' midi'zh por Dios nzhala? Orze' nzhab Juan: ―Gat lë't dai. Orze' nzhab bixa' xtu wëlt: ―¿Chi lu profet xa' nzobni' lo Yech che'n Dios, xa' nak di'zh yi'd ze'? Orze' unkab Juan: ―Gat lë't dai. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","—¿Orze' cho ska lux, mbaino kwan ka nakalx? —nzhab bixa' —porke lë' no naki'n yayab noi lo rë xa' mixë'l no. Kuze', bine cho lux. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Orze' nzhab Juan: ―Na nak tu xa' nibizhyë naye le'n yuo bizh, nela xmod midi'zh ka profet Isaías por Dios: “Bitsimbe go laxto' go par yila go Dios.” ");
INSERT INTO zcaNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","No rë xa' mina'bdi'zh ze', men fariseo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Orze' nzhab bixa' lo Juan: ―No chi gat nakal ni Krist, no ni Li, no ni profet xa' nak di'zh yi'd ze', ¿chon ska nililëi'yal men le'n nits orze'? ");
INSERT INTO zcaNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Orze' nzhab Juan: ―Na nililëi' men nab tsa le'n nits, per xid go nzo tu xa' gat nilibe't go; ");
INSERT INTO zcaNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","xa' re' nzadkë ticha, per natsakt da par lë' xa'; no ni gat ñal gak da tu mos che'n xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kure' ngok ro' you' Jordán plo nililëi' Juan men le'n nits, kwa'n ña'n yezh Betania, al nez plo nilen ngubizh. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","No xtu riyë'l, une Juan lë' Jesús nzhazhin plo nzo Juan, orze' nzhab Juan lo más rë men nzhin ze': ―¡Biwi' go! Me re' nak Me ngule la Dios par gat Me nela tu mbëkxi'l ga', nes par kubchi Me rë kwa'n nzë'b xki rë men yizhyuo lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Me re' Me mizeta lo go or nin: “Ticha nzadkë xtu xa' más tsak lon, porke or naga gal da, lë' Me re' ya nzho la”, ");
INSERT INTO zcaNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","per naneta kwan nak Me re'; na nzhal par lilë̱i̱ña̱ men Israel le'n nits, par libe' bixa' cho Me re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","No nzhab Juan: ―Na une, ngula Sprit che'n Dios lo yibë' yek Me re' nela tu palom ga', no ngulëz palom ze' yek Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Naneta kwan nak Me, per Dios, Me mixë'l da lilë̱i̱ña̱ men le'n nits, ne lon: “Or nel, lë' Sprit che'n Dios la lo yibë' yek tu xa', orze' xa' re' lilëi' men kun Sprit che'n Dios”, ");
INSERT INTO zcaNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","No une lon, se' ngok; kuze' nidizha, Me re' nak Xga'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","No xtu riyë'l, nzo Juan kun choptsa men che'n xa', ");
INSERT INTO zcaNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","no ze' une xa' xtu wëlt lë' Jesús nzë nez plo nzo bixa', orze' nzhab Juan: ―¡Biwi' go! Lë' Me ba' nak Me ngule la Dios gat nela tu mbëkxi'l ga' par kubchi Me rë kwa'n nzë'b xki rë men lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","No or mbin rop men che'n Juan kwa'n midi'zh Juan, tuli ngwakë bixa' tich Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Orze' miëk Jesús no une Me, lë' bixa' nzhakë tich Me, orze' nzhab Jesús: ―¿Chon nzadkë go ticha? Orze' nzhab bixa': ―Maestr, ¿plo nzhol? ");
INSERT INTO zcaNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Orze' nzhab Jesús: ―Cha'o par ne goi. Orze' ngwatsi' bixa' plo nzho Jesús. Ze' mia'n bixa' porke nzhazhëlalyuo, pas las cuatro orze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Di lo rop rë xa' kwa'n mbin kwa'n midi'zh Juan por Jesús, tu rë xa' re' lë Ndres, wech Simón Per, kuze' ngwakë bixa' tich Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Orze' mikwa'n Ndres wech Ndres, xa' lë Simón par nzhab xa': ―Lë'no mizhë'l Me nak Mesías ze' (widi'zh kwa'n gab Krist). ");
INSERT INTO zcaNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Orze' mbi'dnu Ndres wech xa' Simón plo nzo Jesús; no or une Jesús Simón, nzhab Me: ―Lu lë Simón, xga'n Jonás; per nal lë'l ru'lë Cefas (widi'zh kwa'n gab Per). ");
INSERT INTO zcaNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","No xtu riyë'l, mile' Jesús xigab ya Me par lazh men Galilea; zhë ze' mizhë'l Me Lip, orze' nzhab Me: ―Di'kë' ticha. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","No Lip re' nak tu men yezh Betsaida, lo mis plo nak lazh Ndres kun Per. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","No or mizhë'l Lip Natanael, lwega' nzhab xa' lo Natanael: ―Lë'no mizhë'l Me kwa'n nize't ley kwa'n mila' Dios lo Muisés no Me kwa'n mize'tska rë men nzhala xa' midi'zh por Dios; Me re' nak Jesús, xga'n Che, xa' nzë yezh Nazaret. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Orze' nzhab Natanael: ―¿Taxa yezh Nazaret rozi' tu men wen? Orze' nzhab Lip: ―Dë' re' par nel Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","No or une Jesús nzhazubi Natanael plo nzo Me, orze' nzhab Me: ―Re' nzë tu xa' Israel, tu xa' walika nile' kwa'n nzhakla Dios, tu xa' gat nikidet men. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Orze' nzhab Natanael lo Jesús: ―¿Xmod nilibe'l da? Orze' nzhab Jesús: ―Lë'da une la lu xan tu ya nzhao' or naga yi'dnu Lipal lon. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Orze' nzhab Natanael: ―Maestr, ¡lu nak Xga'n Dios, mbaino nakal rey lo rë men Israel! ");
INSERT INTO zcaNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Orze' nzhab Jesús: ―¿Chi por nin lol, unen lu xan ya nzhao', kuze' ñilal da? Re' par dilant, lë'l ne más kwa'ro lo kure'. ");
INSERT INTO zcaNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","No nu nzhab Jesús: ―Walika kwa'n nin lo go, lë' go ne, xa'l lo yibë', no ne go rë ganj che'n Dios maska nikiya-nilayët yek Xga'n Dios, Me nu nak tu men yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Chon ngubizh nzha di ngok kure', nguio tu jwandang yezh Caná kwa'n ña'n lazh men Galilea. No ze' nzo xna' Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","mbaino nu lo Jesús no lo rë men che'n Me ngwane bixa' par ngwa jwandang ze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","No or milox vin kwa'n kiyo rë men lo jwandang ze', orze' nzhab xna' Jesús lo Me: ―Milox kwa'n kiyo rë men re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Orze' nzhab Jesús: ―Lë' go una', ¿chon kine go kuba' lon? Gat gal or da. ");
INSERT INTO zcaNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Orze' nzhab xna' Jesús lo rë xa' nizhin ye'n lo rë men: ―Bile' go rë kwa'n ne Jesús lo go. ");
INSERT INTO zcaNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ze' nzhin xo'p re ke kwa'n nzho nits kwa'n nizen rë men Israel par nzhak nambe bixa' lo Dios. No kad tu rë re re' nzhuwei'ye pas tu gayo' litr nits. ");
INSERT INTO zcaNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Orze' nzhab Jesús lo rë xa' nizhin ye'n lo men: ―Bichizhë go rë re ba' di nits. Orze' michizhë ro' bixa' rëi, ");
INSERT INTO zcaNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","orze' nzhab Jesús lo bixa': ―Nal wala' go che'pe lo xa' kwa'n nzo kile' mandad lo jwandang ba', par le' xa' prebe. Orze' ngwala' bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Orze' mile' xa' nile' mandad lo jwandang re' preb che'p nits kwa'n ngubixlo ngok vin re', per nanet xa' re' plo nguro' vin re', nab tsa rë xa' nizhin ye'n lo men nane kure'. Orze' ngurezh xa' nile' mandad lo jwandang re' miyi' xa' nzhak jwandang che'n re', ");
INSERT INTO zcaNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","par nzhab xa': ―Rë men galo laka vin wen nzho bixa', no or nilox niza' bixa'i go men, orze' nigo' bixa' vin korrient; per lu se, lult laka ngulo'l vin kwa'n más wen. ");
INSERT INTO zcaNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kure' galo laka yalnazhon kwa'n mile' Jesús yezh Caná kwa'n ña'n lazh men Galilea, par milu' Me xmod nak yalnazhon che'n Me; kuze' haxta nu rë men che'n Jesús ngwayila bixa' Me más. ");
INSERT INTO zcaNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Dispwés di kure', orze' nzha Jesús kun xna' Me, kun rë wech Me mbaino kun rë men che'n Me, par yezh Capernaúm; ze' mia'n bixa' pla ra' ngubizh. ");
INSERT INTO zcaNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","No lë' lani Pask che'n men Israel nzhazhin la, par tsila bixa' yë'l kwa'n mile' Dios ngut dox nayax men egipto; lani ze' nzha Jesús par yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","No or mizhin Me le'n yado' ro ze', une Me, ze' nzhin rë xa' nile' xbi' lo luwe che'n yado', nito bixa' ma: ngo'na, mbëkxi'la, mbaino paloma; no rë xa' nichi'l dimi che'n rë men zit. ");
INSERT INTO zcaNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Or une Jesús kure', orze' mizuxkwa' Me tu bins kun do' par ngulo'tin Me rë men re' al tich kun rë ma che'n bixa'; no zhaga' miche'ch Me dimi che'n rë xa' nichi'l dimi re', no haxta rë mes che'n bixa' michixche Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","No lo rë xa' nito palom ze' nzhab Me: ―¡Gulo'tin go rë kure'! ¡Nale't go lizh Xuza nela plo nzhak xbi' ga'! ");
INSERT INTO zcaNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Orze' mitsila rë men che'n Me rë widi'zh kwa'n nzobni' lo Yech che'n Dios kwa'n nzhab se': “Niyi'xian da por kwa'n kile' men kun lizhal; lë'da gat por lë'i.” ");
INSERT INTO zcaNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Orze' pla men Israel xa' nak zhi'n, mina'bdi'zh lo Jesús, nzhab bixa': ―¿Kwan tu kwa'n nazhon le'l lo no par ne no, walika kinul kwa'n par le'l mandad, par le'l rë kure'? ");
INSERT INTO zcaNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Orze' nzhab Jesús: ―Bichil go yado' re', no zixchon ngubizh lë'da zuxkwa' skai xtu wëlt. ");
INSERT INTO zcaNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Orze' nzhab rë men Israel ze': ―Por cho' bixo'p li'n nguiuxkwa' yado' re', mbaino lu ne, ¡chon tsa ngubizh kuxkwa'le xtu wëlt! ");
INSERT INTO zcaNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Per yado' kwa'n midi'zh Jesús lo rë men Israel ze' nak yub kwerp che'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kuze', or nguruban Jesús, mitsila rë men che'n Me widi'zh re', no ngwayila bixa' kwa'n nzobni' lo Yech che'n Dios no rë kwa'n midi'zh Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","No or nzo Jesús yezh Jerusalén dub kiyak lani Pask che'n rë men Israel, nayax men ngwayila widi'zh che'n Me porke une bixa' rë señ nazhon kwa'n mile' Jesús ze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Per nangayilat Jesús rë men ze', porke nane Me xmod nak rë men. ");
INSERT INTO zcaNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Gat naki'nt Me cho gab xmod nak tu men lo Me, porke lë' Jesús ya nane la cho xigab nile' rë men. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nguio tu men fariseo xa' lë Nicodemo, no nile' xa' mandad xid rë men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Miyi' re', or yë'l ngwatswi' xa' lo Jesús, nzhab xa': ―Maestr, nane no, Dios ka mixë'l go par tse'd go no, porke yent cho tu men gak le' rë zhi'n nazhon kwa'n nile' go re' chi gat nzo Dios kun lë' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Orze' nzhab Jesús: ―Walika kwa'n ganin lol, men nagal xtu wëlt, nagakt yo xa' plo nile' Dios mandad. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Orze' nzhab Nicodemo: ―Per, ¿xmod gal tu men xtu wëlt, tu xa' ya ngwagal la? ¿Chi zak yo xa' laxto' xna' xa' par gal xa' xtu wëlt? ");
INSERT INTO zcaNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Orze' nzhab Jesús: ―Walika kwa'n nin lol re', men nagal kun nits no kun Sprit che'n Dios, nagakt yo xa' plo nile' Dios mandad. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Or nzhal rë men yizhyuo, men se'ga bixa' namás; per rë xa' nzhal xtu wëlt por Sprit che'n Dios, men che'n Dios bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Naya'ntal xe por widi'zh re': “Rë men naki'n gal xtu wëlt.” ");
INSERT INTO zcaNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Lë' mbi nzo rë plo, no ter nzhonal nzhaxe, per nanetal plo nzëi no plo ñai. Kuze' rë men se'ga nagakt zobyek bixa' xmod nzhal tu men por Sprit che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Orze' nzhab Nicodemo xtu wëlt: ―¿Taxa xmod nzhak kure' kun rë men? ");
INSERT INTO zcaNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Orze' nzhab Jesús: ―Taxa, lu dox nzho'b xti'zhal por dox nzhakal nilu'l Ley lo rë men Israel, mbaino, ¿chi nanetal kure' orze'? ");
INSERT INTO zcaNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Walika kwa'n nin, lë' no nidi'zh kwa'n nane no, no nidi'zh no kwa'n une no, per gat ñilat go kwa'n nidi'zh no. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Chi gat ñilat go or nidizha rë kwa'n nzho yizhyuo re', orze', ¿xmod yila go or dizha rë kwa'n nzho lo yibë'? ");
INSERT INTO zcaNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Yent cho gat ya lo yibë', nab tsa Me ngulali lo yibë' nane kure', no Me re' nak Xga'n Dios; mbaino nak ska Me tu men yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","No nela xmod ngulitsya Muisés tu mbë'l yi'b le'n yuo bizh ga', se'ska litsya men Xga'n Dios lo krus, Me nak ska tu men yizhyuo, ");
INSERT INTO zcaNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","per rë xa' yila da, lë' bixa' ban par dubta' kun Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Kwa'dox nazhi' Dios rë men yizhyuo, kuze' tugaka Xga'n Me kwa'n nzhap Me mixë'l Me yizhyuo re', nes par rë xa' yila Xga'n Dios, nayot lox bixa' lo Dios, sino ke lë' bixa' ban par dubta' kun Dios, ");
INSERT INTO zcaNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","porke nangaxë'lta' Dios Xga'n Dios lo rë men yizhyuo re' par gab Xga'n Me kwan nak bixa', sino par kubchi Xga'n Me rë kwa'n nzë'b xki bixa' lo Dios, kuze' mixë'l Dios Xga'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Men xa' yila Xga'n Dios, nana'bta' Dios kwent lo xa' por kwa'n nzë'b xki xa' lo Dios; per xa' gat ñilat Xga'n Dios, men re' kix rë kwa'n nzë'b xki xa' por nangayilat xa' tugaka Xga'n Dios kwa'n nzhap Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Rë xa' gat ñilat Xga'n Dios, nzë'b xki la bixa' lo Dios, no por nile' bixa' kwa'n gat lë', kuze' or mbi'd Me nak Ki lo rë men yizhyuo, más nguio laxto' bixa' zo bixa' lo nakao ke par zo bixa' lo Ki che'n Dios, ");
INSERT INTO zcaNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","porke rë xa' gat nile't rë kwa'n milu' la Dios lo bixa', kuze' gat nzhaklat bixa' zubi bixa' lo Ki che'n Dios par nayaxo'b kwa'n nak bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Per lë' rë men, xa' walika nile' rë kwa'n milu' la Dios lo bixa', nizubi bixa' lo Ki che'n Dios, par lu', lë' rë kwa'n nile' bixa', nzë lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Dispwés di ngok kure', orze' ngwa Jesús kun rë men che'n Me lazh men Judea plo mia'n bixa' pla ra' ngubizh, no nu rë men che'n Jesús mililëi' rë men Judea le'n nits. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Mbaino lë' Juan kililëi' men le'n nits yezh Enón, gax plo ña'n yezh Salim, porke dox nikë nits ze', no rë xa' nzha lo Juan, ze' ngoklëi' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","No or mile' Juan rë kure', stubi gat yo Juan lizhyi'b, ");
INSERT INTO zcaNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","per pla rë men che'n Juan michë'lro' bixa' kun más rë men Israel por xmod nimbe men lo Dios kun nits, ");
INSERT INTO zcaNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","orze' ngwayab rë men che'n Juane lo Juan, nzhab bixa': ―Maestr, chi nitsilal miyi' kwa'n nguzo kun lu xtu ro' you' Jordán, xa' kwa'n midi'zhal más tsak lol ze', nal nu xa' kililëi' men le'n nits, no rë men ñakë tich xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Orze' nzhab Juan: ―Yent cho gak le' tu kwa'n nazhon chi gat nzo Dios kun lë' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mis go mbin kwa'n midizha, gat lë't da nak Krist Me yi'd. Per Dios mixë'l da nzhala lo Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Porke lo tu jwandang, lë' xa' gak jwandang che'n ze', men ze' nak xa' más tsak; mbaino lë' men nichë'l xa' kwa'n nzo ta' xa', dox nizak laxto' xa' nzhon xa' chi miyi' xa' nzhak jwandang che'n. No se'ta' nizak laxto'n por miyi' ba'. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nal, rë zhi'n nazhon kwa'n nile' miyi' ba' naki'n re'che rë plo, per rë zhi'n nazhon kwa'n nilen, naki'n loxe. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","No nzhab Juan: ―Me nzë lo yibë', Me ze' más tsak lo rë men yizhyuo; mbaino xa' nzë yizhyuo re', nab tsa rë kwa'n yizhyuo re' nane xa'. Per Me nzë al ya, Me re' nane rëi, ");
INSERT INTO zcaNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","mbaino nidi'zh Me rë kwa'n nane Me no rë kwa'n nzhon Me, per yent cho ñila kwa'n nidi'zh Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","No chi yila tu men kwa'n nidi'zh Me nzë lo yibë', orze' men ze' nane, walika kwa'n nidi'zh Dios, ");
INSERT INTO zcaNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","porke xa' mixë'l Dios par le' zhi'n nazhon che'n Dios yizhyuo re', nab tsa widi'zh che'n Dios nidi'zh xa', porke Dios miza' rë tsa yalnazhon che'n Dios nka' xa' re' por Sprit che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Lë' Xuz be Dios nazhi' Me Xga'n Me, no rë tsa kwa'n kinu Me miza' Me yanu Xga'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Men yila Xga'n Dios, xa' ze' par dubta' ban xa' kun Dios; per xa' gat ñila Xga'n Dios, nabant xa' lo Dios, sino ke kwa'n kimbëz par lë' xa' nak yalzi kwa'n nazhe'b dox kwa'n xë'l Dios par rë men xa' nzë'b xki lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Or mbin Jesús, lë' rë men fariseo nane, más nayax men kinu Me mbaino nililëi' Me, mbaino lë' Juan más che'p men kinu nidi'zh bixa', ");
INSERT INTO zcaNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","no ter gat lë't yub Jesús nililëi' men len nits sino rë men che'n Mei, ");
INSERT INTO zcaNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","kuze' nguro' Jesús lazh men Judea, par ña ska Me lazh men Galilea. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","No par zhin Me lazh men Galilea, naki'n ded Me lazh men Samaria. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Or mizhin Me tu yezh kwa'n lë Sicar, kwa'n ña'n lazh men Samaria, plo nax tlë' yuo kwa'n mila' tu xa' tiemp lë Jakob par xga'n xa' Che, ");
INSERT INTO zcaNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ze' nzob tu zo kwa'n nde'n Jakob. No tanta ngwazha Jesús di nguzë Me, ro' zo ze' nguzob Me che'p, mbaino paste garol zhë orze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","No lë' rë men che'n Jesús nzha bixa' le'n yezh par nzhazi' bixa' kwa'n gao bixa'. Lë'chi mizhin tu una' Samaria nzhaka' nits ro' zo ze', orze' nzhab Jesús lo una': ―Ne'l che'p nits go'n. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","No lë' rë men Israel gat nichë'lt bixa' kun rë men Samaria, kuze' nzhab una' ze': ―¿Chon kina'b go nits go go lon, go men Israel, mbaino na men Samaria? ");
INSERT INTO zcaNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Orze' nzhab Jesús: ―Per chi nel kwan niza' Dios ka' men, no chi libe'l cho xa' kina'b nits lol, orze' lë'l na'b nits gol lo xa', kwa'n le' banal par dubta'. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Orze' nzhab una' ze': ―Señor, per yent kwan kinou par ko'u nits, mbaino dox na'ch nzho nits le'n zo re'; ¿plo kinuo nits ne'u go'n kwa'n le', ban da par dubta'? ");
INSERT INTO zcaNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Chi más tsak go lo xuz no Jakob xa' tiemp ze'? Porke lë' xa' mila' zo re' par no, no re' ngu' xa' nits no rë xin xa', mbaino rë ma che'n xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Orze' nzhab Jesús: ―Rë xa' nzho nits le'n zo re', lë' xa' zëi' laxto' xtu wëlt, ");
INSERT INTO zcaNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","per rë xa' go nits kwa'n zan, nayotra' zëi' laxto' xa', porke nits kwa'n zan go xa', gake le'n laxto' xa' nela plo nilen nits ga', no le'i ban xa' kun Dios par dubta'. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Orze' nzhab una' re': ―Lë' go, ne'u nits ze' go'n par nazëi'ra' laxto'n, no par nayi'dkara' da nits re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Orze' nzhab Jesús: ―Bizë, waka' tsa'l, orze' yi'dskal xtu wëlt. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Per nzhab una': ―Gat kinuta tsa'n. Orze' nzhab Jesús: ―Walika kwa'n nel, ");
INSERT INTO zcaNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","porke nzha la gai' tsa'l nzhayapal, mbaino miyi' kwa'n kinul nal re', gat lë't ska tsa'le. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Or mbin una' widi'zh re', nzhab una': ―Lë' go, walika nak go tu men nidi'zh por Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Rë xa' tiemp, xa' ngok xuz no, xa' miban re', nguzuxib bixa' lo Dios le'n yi' re'; per rë go men Israel, nidi'zh go, nab tsa yezh Jerusalén naki'n zuxib men lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Orze' nzhab Jesús: Una', wayila kwa'n nin; lë' zhë zhin, lë' go zuxib lo Dios Xuz no, gat naki'ntra' ya go yi' ba', no ni gat naki'n ya go yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nal, net go cho lo nizuxib go; per no men Israel, nane ka no cho lo nizuxib no, porke xid rë men Israel yi'd Me ko' rë men lo kwa'n nazhe'b kwa'n nzho bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Per lë' zhë zhin, no lë' zhë ze' mizhin la, rë men xa' walika men che'n Dios, por Sprit che'n Dios lë' bixa' zuxib lo Me walika Dios; porke por Sprit che'n Dios libe' bixa', xmod ka nak Dios. Sa' nzhakla Dios zuxib men lo Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios nak sprit, no xa' zuxib lo Dios naki'n le' xa'i por Sprit che'n Dios, porke sa' nzhakla Dios le' men. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Orze' nzhab una': ―Lë'da nzhonka lë' Mesías yi'd, widi'zh re' gab Krist; or yi'd Me re', orze' ne Me rë kwa'n lo no. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Orze' nzhab Jesús: ―Na xa' ze', xa' kidi'zh kun lu nal re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Lë'chi orze' nguiubre rë men che'n Jesús, no xe miwi' bixa', lë' Jesús kidi'zh kun tu una', per ni yent cho ngaye laxto' ngana'bdi'zh kwan nzhakla una' ba' o kwan kidi'zh Jesús kun lë' una', ");
INSERT INTO zcaNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","orze' mila' una' ree che'n una' par nzhayab una' lo rë men: ");
INSERT INTO zcaNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―¡Dë'ule, ne go tu miyi', xa' ne rë kwa'n nak da! ¿Pas xa' re' Krist, xa' nak di'zh yi'd? ");
INSERT INTO zcaNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Orze' nguro' rë men yezh ze', nzhatswi' bixa' plo nzo Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Dub nzha rë men ze' plo nzo Jesús, orze' nzhab rë men che'n Me lo Me: ―Maestr, dao go nal. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Per nzhab Jesús: ―Na kinu ka kwa'n ga̱u̱, kwa'n nanet go kwan. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Orze' kina'bdi'zh rë men che'n Me lo tu xa' kun xtu xa': ―Taxa, ¿chi nzho cho mbi'dla' la kwa'n gao Me? ");
INSERT INTO zcaNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Per nzhab Jesús: ―Kwa'n ga̱u̱ re' nak, len rë kwa'n nzhakla Me mixë'l da, no loxa len rë kwa'n ne Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Lë' go nidi'zh, zitap mbëo' par za' yalgo'n; per na ni lo go, biwi' go, lë' yalgo'n une la par yatse. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Xa' nikan yalgo'n, nzhax ka' xa'; no yalgo'n kwa'n nikan xa', lë'i nak ban men kun Dios par dubta', nes par xa' nzha'n mbaino xa' nilits yalgo'n, lal nizak laxto' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kuze' walika kwa'n nzhab di'zh: “Xa' cho nzha'n no xa' cho nikan yalgo'n.” ");
INSERT INTO zcaNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Na mixël go par kan go yalgo'n plo nanga'nt go, yent cho zhi'n mizoi lo go; xa' men ngo'ne per go ngulits yalgo'n loi, par bien che'n go. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","No nayax men yezh Sicar, kwa'n ña'n lazh men Samaria, ngwayila bixa' widi'zh che'n Jesús por widi'zh kwa'n nzhab una' re' lo men: “Ne xa' rë kwan nak da.” ");
INSERT INTO zcaNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kuze', or mizhin nayax men Samaria plo nzo Jesús, nzhab bixa' ya'n Jesús kun lë' bixa', orze' mia'n Jesús ze' chop ngubizh kun rë men ze', ");
INSERT INTO zcaNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","no ngwayila ra' más men Jesús, rë xa' nzho ze', or mbin bixa' kwa'n midi'zh yub Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","mbaino nu nzhab bixa' lo una' ze': ―Nalse ngwayila noi, gat lë't por nab kwa'n nele, sino ke por mis no mbin kwa'n midi'zh Me, walika Me re' nak Krist, Me niza' yalnaban par dubta' ka' men. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Unded chop ngubizh, orze' nguro' Jesús lazh men Samaria par nzha Me lazh men Galilea, ");
INSERT INTO zcaNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","porke mis lë'ka Me nzhab kure': “Tu men nidi'zh por Dios, nayilat men lazh xa' kwa'n nidi'zh xa'.” ");
INSERT INTO zcaNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","No or mizhin Me lazh men Galilea, rë men yezh ze' miwi' wen lo Me, porke rë men re' une rë kwa'n mile' Jesús Jerusalén or ngok lani Pask, porke nu ka rë men re' ngwa lani orze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Orze' miëk ska Jesús yezh Caná lazh men Galilea, plo mile' Jesús ngubixlo nits, ngoke vin, ze' nzo tu xa' nak zhi'n che'n gobier, no kinu xa' tu xga'n xa' nzhakne nzho yezh Capernaúm. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Or mbin xa' re', lë' Jesús ñë'd di lazh men Judea par mizhin Me lazh men Galilea, orze' ngwakinez xa' Jesús, no dox una'b xa' ya Jesús lizh xa', par liwen Me xga'n xa', porke pe'n nak xga'n xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Orze' nzhab Jesús: ―Go haxta neu tu kwa'n nilu' no tu kwa'n nazhon, orze' yayilao da. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Orze' nzhab xa' nak zhi'n ze': ―Lë' go, bikën laxto' go, napa gat xga'na. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Orze' nzhab Jesús: ―Biyëk lizhal, lë' xga'nal miak la. Orze' ngwayila xa' re' kwa'n nzhab Jesús, orze' ña xa', ");
INSERT INTO zcaNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","no jwaltra' di zhin xa', lë' rë mos che'n xa' ngwakinez la xa' par nzhab bixa': ―¡Karri! ¡Lë' xmë'dal miak la! ");
INSERT INTO zcaNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Orze' mina'bdi'zh xa', cho or nguzublo miak xga'n xa', orze' nzhab mos: ―Na'g, como la una zhë, nguro' xlë'. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Orze' mitsila xa' nak xmë'de re', mer orze' nzhab Jesús lo xa': “Lë' xga'nal miak la”, orze' dub lizh xa' ngwayila Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kun kure' mirop kwa'n nazhon mile' Jesús, or nguro' Me lazh men Judea, par miëk Me lazh men Galilea. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Or milox ngok rë kure', nguio tu lani che'n rë men Israel, kuze' nzha Jesús yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","No yezh Jerusalén ze', nikë tu tank nits gax laka plo lë Puert che'n mbëkxi'l; tank re' lë Betzata kun widi'zh che'n men hebreo, mbaino kinui gai' corredor. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ro' rë corredor ze' nzhin nayax men nzhakne, men nikal-lo, no men ko'j, mbaino rë men mibizh tu plo; ze' nax bixa' kimbëz bixa' or win nits le'n tank ze', ");
INSERT INTO zcaNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","porke kad pok nilali tu ganj che'n Dios par nikwin ganj ze' nits kwa'n nzho le'n tank, no men galo laka ño dub niwin nits, ñak xa' wanei cho yalyizh nizak xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","No ze' nax tu miyi' nzhakne nzhala galbichi' bixon li'n. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Or une Jesús nax xa' ze', lë' Jesús nane la, dox nzhala nzhakne xa', orze' nzhab Jesús lo xa': ―¿Chi nzhaklal yakal? ");
INSERT INTO zcaNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Orze' nkab xa': ―Lë' go, yent cho gaknu da yo'n le'n tank or niwin nits, kad or nzhaklan yo'n, xtu xa' ño galo lon. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Orze' nzhab Jesús: ―Waxche, gulits kwa'n naxal lo, no bizë. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Orze' lwega' miak miyi' ze', ngulits xa' kwa'n ngo't xa' lo, no nguzublo nguzë xa', mbaino zhë ze', zhë kwa'n nayi' kë men Israel zhi'n. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Orze' nzhab pla men Israel lo miyi' miak re': ―Nalzhë, zhë nile' met diskans, kuze' gat ñalt wei'yal kwa'n ngo'tal lo ba'. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Orze' nzhab miyi' ze' lo bixa': ―Xa' miliyak da, ne lon: “Gulits kwa'n naxal lo ba', no bizë.” ");
INSERT INTO zcaNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Orze' mina'bdi'zh bixa': ―¿Cho xa' ne lol: “Gulits kwa'n ngo'tal lo ba', no bizë”? ");
INSERT INTO zcaNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Per miyi' re' nanet xa' cho miliyak xa', porke lwega' nguzë'b Jesús xid rë men nzhin ze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Guzhëla ze', mizhë'l Jesús miyi' re' le'n yado', orze' nzhab Jesús lo xa': ―Biwi', lë'l miak la nal, nale'tra'l kwa'n gat lë' lo Dios, par nazakal xtu kwa'n más nazhe'b. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Orze' ña miyi' ze', no ngwayab xa'i lo rë men xa' nzo lo rë men Israel, lë' Jesús miliyak xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","No por kuze', ngokla bixa' ngazen bixa' Me, por miliyak Me men zhë kwa'n nile' rë men Israel diskans, ");
INSERT INTO zcaNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","per nzhab Jesús lo bixa': ―Lë' Xuza nu zhë re' nikë Me zhi'n, kuze' nu da nikë zhi'n zhë re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Por kwa'n nzhab Jesús re', más ngokla rë men Israel ze', ngagal bixa' Me, gat lë't nab por nikë Me zhi'n zhë kwa'n nile' rë men Israel diskanse, sino ke nu por nzhab Me: “Lë' Dios nak Xuza”, mbaino nu Me nile' rë kwa'n nile' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Orze' nzhab Jesús: ―Walika kwa'n nin lo go, nagakt le' Xga'n Dios ni tu kwa'n xigab yek, nab tsa nile' Me rë kwa'n niwi' Me nile' Xuz Me, no rë kwa'n nile' Xuz Me nile' Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Lë' Xuz Me nazhi' Me, kuze' rë kwa'n nile' Xuz Me, nilu' Xuz Me lo Me, mbaino lë' Xuz Me laore lu' kwa'n más nazhon lo Me, kwa'n le' ya'n xe go tuli, ");
INSERT INTO zcaNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","no nela nile' Xuz Me niruban rë men, par niza' Dios yalnaban ka' bixa', se'ska niza' Xga'n Dios yalnaban ka' men, xa' nzhakla Me za' Mei, ");
INSERT INTO zcaNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","no Xuz Me nagabt kwan ñal rë men por kwa'n nzë'b xki bixa', sino ke lo Xga'n Me mila' Me kure', par lë' Xga'n Me gab kwan gak kun tu ga' rë men por kwa'n nzë'b xki bixa', ");
INSERT INTO zcaNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","nes par rë men gap kwent kwa'n nidi'zh Xga'n Dios nela xmod nzhap men kwent yub pa' Dios, Me mixë'l Me re'. No xa' nazo'b di'zh kwa'n nidi'zh Xga'n Dios, gat lë't kun Xga'n Dios mile' xa' kure' sino ke kun yub pa' Diose. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","No nzhab Jesús: —Dox wali kwa'n nin, xa' gon kwa'n nidizha, mbaino yila xa' Me mixë'l da, por kure' ban xa' kun Dios par dubta'. No nana'btra' Dios kwent lo xa' por kwa'n mile' xa'. No nale'tra' xa' kwa'n gat lë' par nalox xa' lo Dios, sino ke zublo ban xa' kun Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Pwes walika kwa'n nin lo go, lë' zhë zhin, mbaino lë' zhë ze' mizhin la, lë' rë men xa' nzo zit lo Dios, lë' bixa' gon widi'zh che'n Xga'n Dios, no rë xa' yila widi'zh che'n Xga'n Me re', por kure' lë' bixa' ban par dubta' kun Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nela xmod kinu Dios yalnazhon par niza' Me yalnaban ka' men par dubta', se'ska miza' Dios yalnazhon re' ka' Xga'n Me, par nile' Xga'n Me ban men dubta' kun Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Mbaino nu mizo Dios Xga'n Me par na'b Xga'n Dios kwent lo rë men yizhyuo por rë kwa'n nzë'b xki bixa', no nu por nak Xga'n Dios tu men yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nawi't go lon xe por rë kwa'n kidizha lo go re', porke lë' zhë zhin, lë' rë xa' nzho le'n ba' gon widi'zh che'n Xga'n Dios, ");
INSERT INTO zcaNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","orze' ruban bixa', no rë xa' mile' kwa'n wen, lë' bixa' ban par dubta' kun Dios; per rë xa' mile' kwa'n gat lë', lë' bixa' ruban par dubta' zakzi bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","No nzhab Jesús: ―Nagakt len ni tu kwa'n xigab yeka, nab tsa nilen nela xmod ne Xuza lon. Kuze' nali nigobe'n xmod nak men, porke gat nile'ta' kwa'n nzhaklan, sino kwa'n nzhakla Xuza, Me mixë'l da, kuze' nilen. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Chi por xigab yeka nidizha, pues gat walit kwa'n nidizha orze', ");
INSERT INTO zcaNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","per nzho xtu Me nidi'zh por na, mbaino nanen, walika rë kwa'n nidi'zh Me por da. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Lë' go mixë'l men par ngwana'bdi'zh bixa' lo Juan, no walika kwa'n midi'zh Juan por da. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Per na gat naki'nt da di'zh men cho da; nin cho da lo go par ro' go lo rë kwa'n nazhe'b nzho go. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Rë widi'zh kwa'n milu' Juan lo go ngok nela tu ki kwa'n nizini lo nakao ga'; mbaino por kwa'n milu' Juan lo go re', che'ptsa mizak laxto' go mile'i. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Per na kinu kwa'n más nilu' cho da, mbaino más tsake lo rë kwa'n milu' Juan: Rë zhi'n nazhon kwa'n nilen, tutsa nake kun rë zhi'n nazhon kwa'n mika'b Xuza len. Kure' nilu', Xuzka mixë'l da. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","No Xuza Me mixë'l da, lë' Me midi'zh la cho da, no ter naga gon go chi Me, no ni naga ne go Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kun ro' go nidi'zh go ñila go Dios, per gat niguchao't go widi'zh che'n Me laxto' go, porke gat ñilat go da, mbaino lë' Me mixë'l dax. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Lë' go niwi' laka go kwa'n nzho'l go lo Widi'zh che'n Dios, nes par gab go, sa' yazhël go xmod ban go dubta' kun Dios, mbaino rë kwa'n nzho'l go ze', na ka nize'te; ");
INSERT INTO zcaNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","per nanet go yila go da par len ban go dubta' kun Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Par na, yent kwan tsak di'zh men wen da, ");
INSERT INTO zcaNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","per por nilibe'n go, wenawen nanen, gat nazhi't go Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mbaino Me re' nak Xuza, Me mixë'l da lo go, per nanet go yila go da; lë'la cho la xtu ñila go, xa' nidi'zh kwa'n xigab yek xa' lo go. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¡Kuze' ka, gat ñila go dax!, porke dox ño laxto' go di'zh men lë' go wen; per gat nikwa'nt go xmod ya'n go wen kun Dios, ter lë'gaka nab Me nak Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nagabt go nal, na gap lo Xuza rë kwa'n nak go. Per yub Muisés gab kwan nak go, ter nile' go xigab, Muisés ko' go lo rë de kwa'n nzadkë tich go. ");
INSERT INTO zcaNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Chi walika ngayila go kwa'n mizobni' Muisés, orze' nu ska da ngayila go, porke na nize't kwa'n mizobni' Muisés, ");
INSERT INTO zcaNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","per por gat wali ñila go kwa'n mizobni' Muisés, kuze' nu da, gat ñilat go kwa'n nidizha. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Or milox midi'zh Jesús rë kure', ña Jesús xtu ro' lagun kwa'n ña'n lazh men Galilea, plo nu nzhab men lë lagun che'n men Tiberias. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","No nayax men nzhakë tich Me, porke une bixa' rë kwa'n nazhon mile' Me, miliyak Me rë men nzhakne, ");
INSERT INTO zcaNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","orze' nkili Jesús yek tu yi', ze' nguzob Me kun rë men che'n Me; ");
INSERT INTO zcaNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","no mer la gal lani Pask kwa'n nile' rë men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Or une Jesús dox men nzhakë tich Me, orze' nzhab Me lo Lip: ―¿Plo zi' be kwa'n gao rë men re'? ");
INSERT INTO zcaNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Kizenbe' Me Lip par nabei kwan gab xa' (kiwi' Me xmod nak Lip), porke lë' Jesús nane la kwan le' Me, ");
INSERT INTO zcaNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","orze' nzhab Lip: ―Ni di dimi kwa'n le' men gan chop gayo' ngubizh lo zhi'n nagalte zi' met kwa'n gao rë men re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","No tu men che'n Jesús xa' lë Ndres wech Simón Per, nzhab xa' lo Jesús: ");
INSERT INTO zcaNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Tu mbwin nzo re' kinu gai' pan sebad, mbaino chop mbël, per, ¿chi zal kure' par rë men re'? ");
INSERT INTO zcaNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Orze' nzhab Jesús lo rë men che'n Me: ―Guzh go lo rë men ba' zob. Mbaino dox nzhi'b yixyë ze', orze' rë men nguzob, no nab tsa xa' miyi' paste gai' mil bixa', ");
INSERT INTO zcaNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","orze' nguzen Jesús za gai' pan ze'; or milox miza' Me xkix lo Xuz Me Dios, orze' miza' Mei ka' rë men che'n Me, par ndi'z bixa'i xid rë men nayax ze', no se'ska mile' Jesús kun rop mbël ze'; rë men ndao haxta plo ngwazhë bixa', ");
INSERT INTO zcaNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","no or unela ndao bixa', orze' nzhab Jesús lo rë men che'n Me: ―Bikan go rë bilao kwa'n mia'n ba', par yent kwan nu. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Orze' mikan bixa' rë bilao kwa'n mia'n lo kwa'n ndao bixa', michizhë bixa' tu dusen kardor win. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Or une rë men re' kwa'n mile' Jesús, orze' nzhab bixa' lo wech bixa': ―Walika, profet xa' re', xa' nidi'zh por Dios, mbaino xa' nak di'zh zhin yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","No lë' Jesús nane la, lë' rë men ze' nzhakla, ter nane Me, lë' bixa' wei' Me par gak Me rey lo bixa'. Kuze' nguiubchi Me lo bixa', ña Me yek yi', ze' mia'n nab Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","No or ngula yë'l, ngulayët rë men che'n Jesús ro' lagun, ");
INSERT INTO zcaNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ze' nkë bixa' le'n tu bark par ña bixa' xtu ro' nits nez yezh Capernaúm, per ngula la yë'l orze', no lë' Jesús nagat yubre Me lo bixa', ");
INSERT INTO zcaNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","lë'chi orze' nguro' tu mbi ro le'n nits plo ña bixa', ");
INSERT INTO zcaNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","no ñazë la bixa' paste gai' o xo'p mil metr le'n nits, lë'chi une bixa' Jesús, ñëdzë Me lo nits, nzhazhin Me lo bixa', orze' mizheb bixa', ");
INSERT INTO zcaNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","per nzhab Jesús lo bixa': ―¡Ka nai, nazhebt go! ");
INSERT INTO zcaNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Orze' dox nizak laxto' bixa' nguio Jesús le'n bark kun lë' bixa', orze' lwega' mizhin bixa' yezh plo nzha bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","No xtu riyë'l, lë' rë xa' nzhin xtu ro' nits plo nguro' rë men che'n Jesús ze', une bixa', lë' rë men che'n Jesús ña le'n tugaka bark kwa'n nzob ze', per nangabit Jesús kun rë men che'n Me, ");
INSERT INTO zcaNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","no kwantgatsa orze', mizhin zipla bark kwa'n nzë yezh Tiberias, no ze' ña'n gax laka plo miza' Jesús pan ndao rë men nayax ze', or miza' Me xkix lo Dios por lë'i. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","No or une rë men ze', yent Jesús no ni rë men che'n Me, orze' nkë rë men re' le'n pla bark par nzhakwa'n bixa' Jesús al nez yezh Capernaúm. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","No or mizhin bixa' xtu ro' nits, ze' mizhë'l bixa' Jesús, orze' nzhab bixa': ―Maestr, ¿pok ka mizhinal re'? ");
INSERT INTO zcaNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Orze' nzhab Jesús lo bixa': ―Walika kwa'n nin lo go, kikwa'n go da por ndao go haxta plo une go; no gat lë't por une go cho ka dai, por zhi'n nazhon kwa'n une go milen ba'. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nale't go be's xigab por kwa'n nzhao go yizhyuo re', sino ke bile' go xigab por kwa'n nayot lox, kwa'n le' ban men dubta' kun Dios. Kwa'n gao go re' nak kwa'n ninen ka' go, na nak Xga'n Dios no nak ska da tu men yizhyuo, porke lë' Xuza Dios milu' la lo rë men cho ka da. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Orze' mina'bdi'zh rë men ze': ―¿Xmod le' no par le' no kwa'n nzhakla Dios? ");
INSERT INTO zcaNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Orze' nzhab Jesús: ―Nabtsa kwa'n nzhakla Dios le' go, yila go Me kwa'n mixë'l Dios yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Orze' mina'bdi'zh bixa' lo Jesús, nzhab bixa': ―¿Kwan tu kwa'n nazhon le'l lo no, nes yila no lu?, mbaino, ¿cho pa' zhi'n wen lë'l par no? ");
INSERT INTO zcaNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Rë xuz no xa' nzhala, ndao bixa' pan kwa'n lë maná or nguzë bixa' le'n yuo bizh, nela xmod nzobni' ka lo Yech che'n Dios: “Dios miza' pan kwa'n ngula lo yibë', ndao bixa'.” ");
INSERT INTO zcaNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Orze' nzhab Jesús: ―Walika kwa'n nin lo go, gat lë't Muisés miza' pan kwa'n ngula lo yibë' ndao bixa', sino ke lë' Xuza Dios miza'i; per nal, lë' Xuza Dios miza' kwa'n walika pan kwa'n nzë lo yibë', ");
INSERT INTO zcaNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","porke lë' pan kwa'n nzë lo yibë' re', pan re' niza' yalnaban ka' rë men yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Orze' nzhab bixa' lo Jesús: ―Lë' go, ne'u pan re' gao no dubta'. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Orze' nzhab Jesús: ―Lë'da nak pan kwa'n niza' yalnaban; rë men xa' gak men da, nayotra' la'n bixa'; mbaino rë men xa' yila da, nayotra' zëi' laxto' bixa', ");
INSERT INTO zcaNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","per lë'da ni la, ter nane go cho da, per nayilat go da. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Rë men xa' ngule Xuza gak men da, lë' bixa' yi'd lon; mbaino xa' yi'd lon, nayot zhë kubchin xa' lon. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nzhala lo yibë', gat lë't par len kwa'n nzhaklan yizhyuo re'i, sino nzhala par len kwa'n nzhakla Xuzai, Me nzho lo yibë'. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","No kure' nak kwa'n nzhakla Xuza, Me mixë'l da: Rë men xa' ngule Xuza gak men da, nayot lox ni tu bixa' lo Dios; na le ruban rë bixa' or yala xtu wëlt, ");
INSERT INTO zcaNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","porke kure' nak xigab che'n Xuza Me nzho lo yibë': Rë men xa' nilibe' cho da no ñila bixa' da, lë' bixa' ban dubta' kun Dios, mbaino len ruban bixa' or yala xtu wëlt. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Orze' por kwa'n nzhab Jesús: “Na nak pan kwa'n nzë lo yibë'”, nguzublo kidi'zh rë men Israel, gat lë' por Jesús, rë xa' nak zhi'n, ");
INSERT INTO zcaNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","nzhab bixa': ―¿Chi gat lë't Jesús re', xga'n Che? Be nilibe' ka xuz xa' re' no xna' xa'. ¿No chon kidi'zh xa', lë' xa' nzë lo yibë'? ");
INSERT INTO zcaNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Orze' nzhab Jesús lo bixa': ―Nadi'zhtra' go da gat lë'. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ni tu go nagakt gak men da, chi gat lë' Xuza Me mixë'l da yi'dnu go lon; mbaino rë xa' nak men da, na le ruban bixa' or yala xtu wëlt, ");
INSERT INTO zcaNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","porke se' ka mizobni' rë xa' midi'zh por Dios: “Dios tse'd rë men.” Kuze', rë men xa' nzhon ro' Dios no tse'd bixa' lo Me, rë xa' ze' gak men da. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Gat lë't por nin kure' kidizha, nzho cho ya une la lo Xuza; nab tsa Xga'n Dios Me nzë lo yibë', une Xuz. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Walika kwa'n nin lo go; xa' yila da, xa' ze' kinu la yalnaban dubta' kun Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Na nak pan kwa'n niza' yalnaban par rë men, xa' yila da. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ter ndao rë xuz go xa' tiemp, pan kwa'n lë maná or nkizë bixa' le'n yuo bizh, no ngut ka bixa'; ");
INSERT INTO zcaNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","per rë men xa' gao yub pan kwa'n nzë lo yibë' re', nayotra' gat bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","No na nak pan kwa'n nzë lo yibë' re', kwa'n niza' yalnaban par dubta' ka' men; no xa' gao pan re', lë' xa' ban dubta' kun Dios, no pan kwa'n zan gao men re' nak kwerp da kwa'n zan par rë men yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Orze' rë xa' nzhin ze', xa' nzo lo rë men Israel, nguzublo kichë'lro' mis lë' bixa', nzhab bixa' lo wech bixa': ―¡Taxa!, ¿xmod ne' xa' re' kwerp che'n xa' gao be? ");
INSERT INTO zcaNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Orze' nzhab Jesús: ―Walika kwa'n nin lo go, chi lë' go nagao kwerp che'n Xga'n Dios, Me nak ska tu men yizhyuo, no chi nago go ren che'n Me, nabant go dubta' kun Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Rë xa' gao kwerp da no go xa' ren da, men re' kinu yalnaban dubta' kun Dios; mbaino len ruban xa' or yala xtu wëlt, ");
INSERT INTO zcaNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","porke lë' kwerp da nak wali pa' pan kwa'n gao rë men, no ren da nak kwa'n wali pa' naki'n go rë men. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Men xa' gao kwerp da mbaino go xa' ren da, men re' dubta' zo kun na, no na kun lë' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Lë' Xuza, Me mixë'l da yizhyuo re', kinu yalnaban par dubta', no por lë' Me kinun yalnaban. Se'ska, rë men xa' gao kwerp da, dubta' kinu xa' yalnaban por da. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kure' nak pan kwa'n nzë lo yibë', no gat nakte nela pan maná kwa'n ndao rë xuz go, xa' nzhala or nkizë bixa' le'n yuo bizh, mbaino ngut ka bixa'. Per xa' gao pan kwa'n nzë lo yibë' re', xa' re' ban dubta' kun Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Rë kure' midi'zh Jesús or kilu' Me widi'zh che'n Dios le'n yo' plo nitse'd rë men Israel widi'zh che'n Dios, kwa'n nzob yezh Capernaúm. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","No or mbin rë men che'n Jesús widi'zh re', nzhab bixa': ―Dox nagan widi'zh re' par zobyek mene; pas yent cho gak zobyeke. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Or une Jesús, lë' rë men che'n Me kidi'zh gat lë' por kwa'n midi'zh Me, kuze' nzhab Me: ―¿Chi por kwa'n midizha ba', nzho go la', nayilatra' go da? ");
INSERT INTO zcaNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Per chi ne go, kilin plo nzho'n or naga yala yizhyuo re'? ");
INSERT INTO zcaNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Lë' Sprit che'n Dios niza' yalnaban ka' men; chi gat lë' por Sprite, yent kwa'n zu' kwerp che'n men; no widi'zh kwa'n nin lo go nzë por Sprit che'n Dios, mbaino nile'i niban men dubta' kun Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Per xid go stubi nzho zipla go xa' gat ñilat widi'zh kwa'n nidizha. Lë' Jesús nane la dizde or galo, cho rë xa' gat ñilat rë kwa'n nidi'zh Me, mbaino cho xa' chi Me par gat Me, ");
INSERT INTO zcaNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","orze' nzhab Jesús: ―Kuze' nin lo go, yent cho gak, gak men da chi gat lë't por Xuza zhin bixa' lon. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","No dizde orze' nayax rë xa' nzhakë tich Jesús, mila' bixa', nangakëtra' bixa' tich Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Orze' mina'bdi'zh Jesús lo za tu dusen men che'n Me, nzhab Me: ―Mbaino go ga', orze', ¿chi nu go la' da? ");
INSERT INTO zcaNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Lë'chi orze' nzhab Simón Per: ―Señor, ¿cho tich yakë no?, porke nab gaka go kinu widi'zh kwa'n nile' ban men dubta' kun Dios, ");
INSERT INTO zcaNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","porke no ngwayila la go, mbaino nane ka no, go nak Krist, Me Nazhon che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Orze' nzhab Jesús: ―Ter na ngule za tu dusen go, ¡per tu go, nzho Mizhab laxto'! ");
INSERT INTO zcaNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Kure' midi'zh Jesús por Judas, xga'n Simón Iscariote; porke lë' Judas nak xa' michi Jesús par ngut Me, no ter nu Judas nzho xid za tu dusen men che'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Or milox midi'zh Jesús rë kure', nikizë Jesús lazh men Galilea; no gat nzhaklat Jesús yo Me lazh men Judea, porke ze' rë xa' nak zhi'n Israel kikwa'n bixa' Me par gut bixa' Me, ");
INSERT INTO zcaNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","no nzhazhin gax la lani che'n rë men Israel, or nizuxkwa' bixa' rranch, ");
INSERT INTO zcaNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","orze' nzhab rë wech Jesús lo Me: ―Naya'ntal re'; wa lazh men Judea, par nu rë men che'nal xa' nzhin ba', ne bixa' rë zhi'n nazhon kwa'n nile'l ba', ");
INSERT INTO zcaNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","porke or nzhakla tu men xo'b xti'zh xa', gat nile't xa' che'n xa' naga'ch; kuze' chi lë'l kile' rë zhi'n ba', bile'i lo rë nak men yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Se' nzhab bixa', porke ni tu rë wech Jesús, gat ñilat bixa' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Orze' nzhab Jesús lo bixa': ―Par go rë or wen, per par na gat gal or yan lani. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Rë men yizhyuo re', gat niyi't bixa' nine bixa' go; per na niyi' bixa' nine bixa', por nidizha rë kwa'n gat lë' nile' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Go wa lani ba'. Na nayat, porke gat gal or yan. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","No or milox midi'zh Jesús kure', ngulëzra' Me xche'p lazh men Galilea. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","No or nzha la rë wech Jesús lani ze', orze' nu Jesús ngwa lani re' xla'n, ");
INSERT INTO zcaNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","no rë xa' nak zhi'n Israel, kikwa'n bixa' Jesús lo lani ze', nzhab bixa': ―¿Ma miyi' ze' re'? ");
INSERT INTO zcaNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Xid rë men ze', rë mod nize't bixa' Jesús, nzho bixa' kidi'zh: “Wenka Jesús”, mbaino más bixa' kidi'zh: “A'a, nikide xa' ze' men.” ");
INSERT INTO zcaNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ter rë men kize't xmod nak Jesús, per xla'n kidi'zh bixa'i por nizheb bixa' lo rë men xa' nzo lo rë men Israel, ");
INSERT INTO zcaNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","per mer garol la nzha lani, lë'chi nguio Jesús le'n yado', nguzublo Me kilu' Me widi'zh che'n Dios lo rë men nzhin ze', ");
INSERT INTO zcaNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","orze' rë men Israel xa' nile' mandad nzhin ze', xe mia'n bixa' tuli no nzhab bixa': ―¿Plo mitse'd kure', tatu nazhe'b nzhak xa', rëi nane xa', mbaino nangat xa' skwel? ");
INSERT INTO zcaNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Orze' nzhab Jesús: ―Rë widi'zh kwa'n nilun lo go, gat lë't chedai; che'n Dios Me mixë'l dai. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Chi nzho tu men nzhakla, le' kwa'n nzhakla Dios; orze' ne xa' plo nzë kwa'n nilun lo go; chi lo Diose, o por xigab yekai. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Men xa' nidi'zh por mis lë' xa', nidi'zh xa' par yët xa' wen namás; per xa' nikwa'n di'zh men wen por xa' mixë'l xa' yizhyuo re', xa' ze' se nidi'zh nab tsa kwa'n nzhakla xa' mixë'l xa', no yent cho widi'zh mbël nzho laxto' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","No, ¿chi nangane't Muisés ley, ka'o? Mbaino, ¿chon ni tu go gat nile't kwa'n nzobni' lo ley? No, ¿chon nzhakla go gut go da orze'? ");
INSERT INTO zcaNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Orze' nzhab rë men nzhin ze': ―¡Tu mbi mal nzenal! ¿Kwan nidi'zhal? ¿Cho nzhakla gutal? ");
INSERT INTO zcaNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Orze' nzhab Jesús: ―Por milen tu kwa'n nazhon, zhë kwa'n nile' go diskans, kuze' rë go niwi' nayi' lon. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Per nu go nile' zhi'n, ter zhë kwa'n nayi' kë men Israel zhi'n. Lë' Muisés mizobni' lo ley, naki'n kë' go señ kwerp che'n xga'n go (ter gat lë't Muisés ngulo ley re', sino ke rë xuz go xa' nzhala nguloi), no ter zhë re' nile' go kure', nikë' go señ plo nak xa' miyi'. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","No chi par le' go kwa'n nzobni' lo ley, nikë' go señ kwerp che'n men, ter zhë kwa'n nile' go diskans; orze', ¿chon niyi' go por miliyaka tu men mis zhë re'? ");
INSERT INTO zcaNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nadi'zht go kwan nak tu men por xmod nilu' xa' namás, sin naga ne go, chi walika nzhap xa' dol. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Orze' nguzublo mina'bdi'zh pla men yezh Jerusalén, nzhab bixa': ―¿Chi gat lë't xa' ba', xa' kikwa'n rë xa' nak zhi'n, par gut bixa' miyi' ba'? ");
INSERT INTO zcaNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","No kidi'zh miyi' lo rë nak men, mbaino yent kwan nzhab rë xa' nak zhi'n lo xa'. ¿Pas nu rë xa' nak zhi'n ba', ngwayila la, lë' miyi' ba' nak Krist? ");
INSERT INTO zcaNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Per be nane ka plo nzë miyi' ba'; per or yi'd xa' nak Krist, yent cho nane plo yi'd xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","No mer kilu' Me widi'zh che'n Dios le'n yado', lë'chi mbin Me kwa'n nzhab rë xa' re', orze' naye midi'zh Me, nzhab Me lo rë xa' nzhin ze': ―Go, ter niwi' go lon, per nanet go cho da, mbaino ni nane go plo nzhala. Per gat nzhalta por xigab yeka, sino ke nzho ka tu Me mixë'l da, no Me re' Me ñal yila go; ter gat nilibe't go Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Per na nilibe' ka Me, porke lo Me nguro'n, no lë' Me mixë'l da. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Orze' ngokla pla rë men ze' ngazen bixa' Jesús, per ni tu bixa' nangayet la ngale'i, porke gat gal or che'n Me, ");
INSERT INTO zcaNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","per nayax men nzhin ze' ngwayila bixa' Jesús, no nzhab bixa': ―Taxa, ¿chi másra' rë kwa'n nazhon le' Krist or yi'd Krist ke lo xa' re'? ");
INSERT INTO zcaNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","No or mbin rë men fariseo kwa'n kidi'zh rë men, orze' rë men fariseo ze' kun rë ngulëi' xa' nile' mandad, mixë'l bixa' pla xa' nikina yado' par ngazen bixa' Jesús, ngago bixa' Me lizhyi'b, ");
INSERT INTO zcaNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","orze' nzhab Jesús lo rë xa' ze': ―Xche'ptsa nzon kun go, lë'da bi' la lo Me mixë'l da yizhyuo re'; ");
INSERT INTO zcaNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","lë' go kwa'n da per nayazhë'lt go da, porke nagakt yi'd go plo yo'n. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Orze' nguzublo kina'bdi'zh bixa' lo wech bixa', nzhab bixa': ―¿Plo bi xa' re', mbaino nayazhëlt be xa'? ¿Pas plo nzhin rë men Israel, xa' nzho lazh men grieg bi xa', par lu' xa'i lo rë xa' ze'? ");
INSERT INTO zcaNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Kwan gab widi'zh kwa'n ne kure' lo be: “Lë' go kwa'n da per nayazhë'lt go da, porke nagakt yi'd go plo yo'n”? ");
INSERT INTO zcaNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","No lult zhë lani ze', nak zhë kwa'n más tsak, no zhë ze' dox naye midi'zh Jesús lo rë men Israel xa' nzhin ze', nzhab Me: ―¡Cho go nizëi' laxto', yi'd go lon par go go nits kwa'n niza' yalnaban par dubta'! ");
INSERT INTO zcaNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nela xmod nzobni' ka lo Yech che'n Dios, laxto' xa' yila da, gak nela le'n tu you' plo nilen nits kwa'n niza' yalnaban par dubta'. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Sa' midi'zh Jesús par nzhab Me xmod gak kun rë xa' yila Me, lë' Sprit che'n Dios yo laxto' bixa'; porke nagata' xë'l Dios Sprit che'n Dios, porke lë' Jesús nagata' bi lo yibë'. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","No pla rë xa' nzhin ze', or mbin bixa' rë kwa'n midi'zh Jesús, orze' nzhab bixa': ―Walika miyi' ba' nak xa' nidi'zh por Dios, xa' nak di'zh yi'd, nela xmod nzobni' ka lo Yech che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","No más bixa' nzhab: ―Lë'ka Me ba' nak Krist, Me kimbëz be yi'd. Per zipla men nzhab: ―Per gat lë't xa' ba' nak Krist, porke nagakt yi'd Krist lazh men Galilea, ");
INSERT INTO zcaNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","porke lo Yech che'n Dios nzobni', lë' Krist naki'n yi'd ben che'n Dabi, no yezh Belén naki'n gal Me, plo ngok ska lazh rey Dabi. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","No por kuze', rë men nzhin ze', ziyën xigab mile' bixa' por Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nzho bixa' ngokla, ngakë' Jesús lizhyi'b, per ni tu bixa' nangayet laxto' ngale'i. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Orze' miëkska rë xa' nikina yado' ze', plo nzhin rë men fariseo, no kun rë xa' nile' mandad lo rë ngulëi', orze' mina'bdi'zh rë xa' re', nzhab bixa': ―¿Chon nangayi'dnu go miyi' ze'? ");
INSERT INTO zcaNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Orze' nzhab rë xa' nikina yado' ze': ―¡Yent cho nidi'zh nela xa' re' ga'! ");
INSERT INTO zcaNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Orze' nzhab rë men fariseo ze': ―¿Chi nu go mila' mikide xa' ba' go? ");
INSERT INTO zcaNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Porke nagat yila tu rë xa' nzo lo no xa' ba', no ni tu rë xa' fariseo, nagate. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","¡Per rë men re', rë bixa' nanet kwan nzobni' lo ley, kuze' rë bixa' nzhi'bde! ");
INSERT INTO zcaNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","No Nicodemo, xa' ngwatsi' lo Jesús or yë'l, nu xa' re' nak tu men fariseo no nzho xa' xid rë men ze'; orze' nzhab xa': ");
INSERT INTO zcaNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Per lo yech che'n be nzobni', nagakt kë' be kixu' tu men sin naga ne be kwan mile' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Orze' ndil bixa' Nicodemo, nzhab bixa': ―¡O nul nzë lazh men Galilea! Biwi' lo Yech che'n Dios par nel, lë' yezh Galilea, lalta' nagat rozi' tu xa' nidi'zh por Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Orze' kad bixa' ña lizh bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Mbaino lë' Jesús nzha par dan kwa'n lë Olivo. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","No xtu riyë'l, garzi'l laka nzha Jesús le'n yado' xtu wëlt, orze' nguzubi rë men lo Me; orze' nguzob Jesús ze' no nguzublo Me kilu' Me widi'zh che'n Dios lo rë men ze', ");
INSERT INTO zcaNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","lë'chi mizhin pla xa' kwa'n nilu' ley kun zipla men fariseo, no nzhanu bixa' tu una' lo Jesús kwa'n ngwaga' kun xtu miyi', no mizo bixa' una' ze' garol sao' lo más rë men nzhin ze', ");
INSERT INTO zcaNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","orze' nzhab bixa' lo Jesús: ―Maestr, lë' una' re' ngwaga' kun xtu miyi', ");
INSERT INTO zcaNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","no lo ley kwa'n mila' Muisés lo be, rë una' kwa'n nak sa' naki'n gat kun ke; no lu ga', ¿kwan nel? ");
INSERT INTO zcaNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Se' midi'zh bixa' par ne bixa' nabei, xmod kab Jesús lo kure', nes par gak gab bixa' lo rë xa' nile' mandad, lë' Jesús nzë'b xki. Orze' nguzobda' Jesús lo yuo par kë' Me letr kun bikwen ya' Me, ");
INSERT INTO zcaNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","no como stubi kina'bdi'zh bixa' lo Jesús, orze' nguzuliska Me par nzhab Me: ―Xa' nzo xid go, xa' yent kwan nzë'b xki lo Dios, xa' ze' galo laka kë' tu ke. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Orze' nguzobda' Me xtu wëlt lo yuo par mikë' Me más kwa'n. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Or mbin rë xa' re' kwa'n midi'zh Jesús, orze' mizi bixa', lë' bixa' nzë'b xki lo Dios, orze' nguzublo tuga' bixa' ña, galo laka rë xa' más ngwagal orze' lult rë xa' xi, lult mia'n nab tsa Jesús kun una' ze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","No or nguzuli Jesús, nzhab Me lo una' ze': ―Una', ¿ma rë xa' michil lon ze'? ¿Chi yent ni tu rë xa' ne, lë'l nzë'b xki? ");
INSERT INTO zcaNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Orze' nzhab una' re' lo Jesús: ―Lë' go, yent ni tu bixa'. Orze' nzhab Jesús: ―Ni na, gat nita lë'l nzë'b xki; nal bizë, per ya nale'tra'le. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús midi'zh lo rë men xtu wëlt, nzhab Me: ―Lë'da nak ki par rë men yizhyuo re'; xa' yi'dkë ticha, lë' xa' gap ki kwa'n le', dubta' ban xa' kun Dios, no nayot zhë ban xa' lo nakao. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Orze' nzhab rë men fariseo: ―Per yubal kidi'zh por lu, kuze' yent cho yila kwa'n nidi'zhal. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Orze' nzhab Jesús: ―Ter yuba nidi'zh por da, per walika kwa'n nidizha; lë' da nane ka plo nzhala no nane ka plo bi'n; per go nanet go plo nzhala no ni nane go plo bi'n. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Lë' go nigobe' xmod nak men di xmod nzë yek go, per na gat nigobe'ta xmod nak men kun mis xigab da, ");
INSERT INTO zcaNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","per chi kobe'n xmod nak men, orze' na lei nela xmod ñal kai, porke gat nabta' nzo par lene, sino ke rop no nzo kun Xuza, Me mixë'l da. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Haxta nu lo ley che'n go nzobni', or chop men nidi'zh tutsa kwa'n, orze' kwa'n nidi'zh rop xa' re', lë'i walika. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mbaino na, walika kwa'n nidizha por da, no Xuza Me mixë'l da, nu ska Me nidi'zh, walika kwa'n nidizha. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Orze' mina'bdi'zh bixa': ―¿Ma xuzal nal? Orze' mikab Jesús: ―Go gat nilibe't go da, no ni Xuza gat nilibe't go. No chi ngalibe' go cho da, nu ska Xuza ngalibe' go orze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Rë widi'zh re' midi'zh Jesús dub kilu' Me widi'zh che'n Dios le'n yado', nez plo nzob kwa'n nila men gon; no yent cho ngazen Jesús, porke nagat gal or gut bixa' Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Orze' nzhab Jesús xtu wëlt: ―Lë'da bi', no lë' go kwa'n da, per lë' go lox lo Dios por naban go lo rë kwa'n gat lë'; no plo bi'n, nagakt bi go. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Orze' nzhab rë men Israel, xa' nak zhi'n: ―¿Taxa mis lë' xa' gut xa'? ¿Chon nzhab xa': “Plo bi'n nagakt bi go”? ");
INSERT INTO zcaNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","No nu nzhab Jesús: —Go nak men xa' nzhak kwa'n nzho yizhyuo re' namás, per na nzhak rë kwa'n nzho lo yibë'; kuze' nin lo go, lë' go nak men yizhyuo re', per na gat lë't men yizhyuo re' da. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kuze' nin lo go, lë' go lox lo Dios por naban go lo rë kwa'n gat lë'; no chi lë' go gat ñila cho da, lë' go lox lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Orze' mina'bdi'zh bixa': ―¿Cho lux? ―nzhab bixa'. Orze' nzhab Jesús: ―Lë'da nilai lo go, dizde or galo laka. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nzho dox kwa'n ganin lo go por rë kwa'n gat lë' kwa'n nak go; no Me mixë'l da, walika kwa'n nidi'zh Me nak go, no rë widi'zh kwa'n nidizha lo rë men, Me mixë'l da nei lon. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Per nanganut laxto' bixa', yub Dios midi'zh Jesús or nzhab Me, lë' Xuz Me mixë'l Me, ");
INSERT INTO zcaNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","kuze' nzhab Jesús: ―Or lox le' go rë kwa'n nzhakla go le' go kun Xga'n Dios, Me nak ska tu men yizhyuo, orze' ne go cho da, no yent kwan gak len por mis da, nab tsa nilun lo go kwa'n milu' Xuza lon, ");
INSERT INTO zcaNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","porke Me mixë'l da nzo tutsa kun na; no gat nila't Xuza naba, porke zilita' nilen kwa'n nzhakla Me gak, no kwa'n ño laxto' Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","No or milox midi'zh Jesús kure', dox nayax men ngwayila Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Orze' nzhab Jesús lo rë men Israel, xa' ñila Jesús: ―Chi lë' go ban dubta' nela xmod midizha lo go, orze' walika nak go men da, ");
INSERT INTO zcaNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","mbaino lë' go libe' Yub pa' Dios, Me walika Dios; orze' nagaktra' go nela mos nado lo xtu men ga'. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Orze' nzhab rë men Israel ze': ―Lë' no nzë ben che'n Abraham, no lalta' gat, gak no nela mos nado lo ni tu men; no ¿chon nel, nagaktra' no mos nado lo xtu men? ");
INSERT INTO zcaNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Orze' nzhab Jesús: ―Walika kwa'n nin, rë xa' naban lo kwa'n gat lë', lë'i nile' mandad lo bixa', nela xmod nile' tu men mandad lo tu mos che'n men. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tu xa' nak mos nado lo xtu men, naya'nt xa' lizh xa' nikë xa' zhi'n che'n dub tiemp ban xa'; nab tsa xga'n pa' xa' nile' mandad ze', ya'n lizh xuz dub tiemp ban xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","No chi lë' Xga'n Dios le', ro' go lo kwa'n gat lë', walika kwa'n nin, nagaktra' go nela tu mos nado lo xtu men. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Na nane ka, lë' go nzë ben che'n Abraham, per nzhakla go gut go da, por gat ñila go kwa'n nidizha. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mbaino rë kwa'n nidizha lo go, lo Xuza mitse'dai; no sa' ska go, nile' go rë kwa'n mitse'd go lo xuz go. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Orze' nzhab bixa' lo Jesús: ―Per no se, ¡Abraham nak xuz no! Orze' nzhab Jesús: ―Chi lë' go walika nzë ben che'n Abraham, orze' ñal ban go nela xmod miban Abraham ga', ");
INSERT INTO zcaNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","mbaino dubta' midizha lo go nela xmod nzhakla Dios, mbaino dub sa' nzhakla go gut go da; ¡per Abraham nangayot ngak xa' sa'! ");
INSERT INTO zcaNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Rë kwa'n nile' xuz go kuze' nile' go. Orze' nzhab bixa': ―Gat lë't chola men nak xuz no; ¡nab tsa Dios nak Xuz no! ");
INSERT INTO zcaNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Orze' nzhab Jesús: ―Chi lë'i walika Dios nak Xuz go, orze' lë' go ngachizhi' da, porke Dios mixë'l da, nzon kun go re'; no gat lë't tli nzhala, Dios ka mixë'l da yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Gat nizobyekt go widi'zh da por gat nzhaklat go gon goi. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Lë' yub Mizhab nak xuz go, por nile' go kwa'n nzhakla xa'. Lë' Mizhab nak tu xa' nzhut men dizde or nguio yizhyuo, no lalta' gat nzhudi'zht xa' kwa'n wali. Or nikë' xa' mbël, orze' nilu' kwan nak xa'; pura kwa'n mbël nidi'zh xa' porke lë' xa' niki'l men nidi'zh men kwa'n mbël. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ter kidizha kwa'n wali, per gat ñilat goi. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Cho tu go gak ne, kwan tu kwa'n nak da? No chi nidizha kwa'n wali, orze', ¿chonska gat ñila go da? ");
INSERT INTO zcaNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Xa' nak men che'n Dios, nzhon xa' widi'zh che'n Dios, per go, gat nzhont go widi'zh che'n Dios, kuze' gat lë't men che'n Dios go. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Orze' nzhab rë men Israel ze': ―¡Walika kwa'n ne no: Lu tu men Samaria, mbaino nzhak miyizhal, mbi mal nzho laxto'l! ¿Kwan nidi'zhal? ");
INSERT INTO zcaNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Orze' nzhab Jesús lo bixa': ―Ni tu mbi mal gat nzhot laxto'n, no nab tsa nidizha pura kwa'n wen por Xuza; per go gat nzhont go nzho'n. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Na gat nikwanta' di'zh men wen ticha, per nzho xtu Me nzhakla di'zh men wen por da, no Me re' ñal kobe' (wi') xmod nak da. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Dox wali kwa'n nin lo go, xa' yila widi'zh da, nayot gat xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Orze' nzhab rë men Israel ze': ―¡Nalse walika, nzho mbi mal laxto'l! Abraham no rë xa' midi'zh por Dios, ngut ka bixa', no nel lo no: “¡Men xa' yila widi'zh da nayot gat xa'!” ");
INSERT INTO zcaNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Chi más tsakal lo xuz no Abraham orze'? Lë' xa' ngut, no más rë xa' midi'zh por Dios nzhala, no lu, ¿cho nile'l xigab nakal? ");
INSERT INTO zcaNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Orze' nzhab Jesús: ―Chi mis da nidizh wen da, orze' natsakt kwa'n nidizha; per Me nidi'zh wen por da nak Xuza; yub Me kwa'n nidi'zh go nak Dios che'n go, ");
INSERT INTO zcaNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","per nangayot ngalibe' go Me, per na nilibe' ka Me. No chi nin lo go, gat nilibe'ta' Me, mbël da orze' nela go ga'. Per na ni, lë'da nilibe' ka Me, no nilen kwa'n mika'b Me lon. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham xa' ngok xuz go nzhala, dox mizak laxto' xa' or mbin xa' zhin zhë yala, no une xa'i, orze' más mizak laxto' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Orze' nzhab rë men Israel ze' lo Jesús: ―Nagat gapal ni cho' bichi' li'n, ¿no nidi'zhal, unel Abraham? ");
INSERT INTO zcaNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Orze' nzhab Jesús: ―Dox wali kwa'n nin lo go, ni naga gal Abraham, lë'da nzho' la. ");
INSERT INTO zcaNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Orze' nguzen bixa' ke par kë' bixa'i ta' Jesús, per nguiuka'ch Jesús lo bixa', orze' nguro' Jesús le'n yado'. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","No or nzhaded Jesús tu plo, une Me tu miyi' ngolnu nikal-lo, ");
INSERT INTO zcaNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","orze' mina'bdi'zh rë men che'n Me lo Me, nzhab bixa': ―Maestr, ¿chon dizde ngol miyi' ba' nikal-lo xa'? ¿Chi por dol che'n xuz xa'i o por che'n xna' xa'i; o por mis xtol xa'i? ");
INSERT INTO zcaNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Orze' nzhab Jesús: ―Gat lë't por xtol xa'i, no ni gat lë' por che'n xuz xa'i, no ni gat lë' por che'n xna' xa'i; lë'i nak par ne men, yalnazhon che'n Dios por xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Dub ñani zhë, naki'n le' be zhi'n nazhon che'n Dios, Me mixë'l da, porke or nzhala yë'l, yentra' cho gak le' zhi'n; ");
INSERT INTO zcaNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","dub nzon yizhyuo re', lë'da nak Ki kwa'n nizini lo rë men yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Or milox midi'zh Jesús kure', michuk Me lo yuo, no kun nzhuk re' michao' Me che'p ben, orze' mitsa' Mei zalo miyi' re', ");
INSERT INTO zcaNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","orze' nzhab Me: ―Wazët lol kun nits le'n tank kwa'n lë Siloé (widi'zh kwa'n gab: “Mixë'l xa'”). No ze' ngwazët xa' nikal-lo re' lo xa', no or miëk xa' plo nzo Jesús, lë' lo xa' ñani la. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","No rë xa' nzho gax kun lë' xa', no rë xa' nilibe' xa' nina'b xa' gon, nzhab rë men re' lo wech bixa': ―¿Chi gat lë't miyi' re' xa' nizob nina'b gon ze'? ");
INSERT INTO zcaNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nzho xa' nzhab: —Lë' xa'i. No más bixa' nzhab: —Gat lë't xa'i, per se'ta' nilu' xa'. Per yub miyi' re' nzhab: —Na ka xa' ze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Orze' minabdi'zh rë men ze' lo miyi' re': ―¿Xmod ska ngwani lol ga'? ");
INSERT INTO zcaNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mikab miyi' ze', nzhab xa': ―Lë' xa' lë Jesús ze', michao' che'p ben no mitsa' xa'i zalon, orze' ne xa': “Wazët lol kun nits le'n tank kwa'n lë Siloé.” No ngwan ze', mizeta lon, lë'chi tuli ngwani lon. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Orze' nzhab rë xa' re': ―¿Ma xa' ze' nal? Per nzhab xa' ngwani lo re': ―Naneta da ma xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Orze' mbi'y bixa' miyi' xa' ngwani lo ze' lo rë men fariseo, ");
INSERT INTO zcaNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","no zhë kwa'n mitsa' Jesús ben lo miyi' kwa'n nikal-lo ze', ngoke tu zhë kwa'n nile' rë men Israel diskans. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Orze' minabdi'zh rë men fariseo ze' lo miyi' xa' ngwani lo re': “Xmod ngok ngwani lol”, nzhab bixa'. Orze' nzhab miyi' re': ―Mitsa' Jesús ben zalon, orze' mizëtai, no nal nzhak niwi'n. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","No nzhab pla men fariseo ze': ―Xa' mile' kure', gat lë't men che'n Dios xa', porke gat nzhont xa' nzho zhë kwa'n nile' be diskans. Per más bixa' nzhab: ―No chi lë' xa' ba' nzë'b xki lo Dios, orze' nagakt le' xa' tu rë kwa'n nazhon ba'. Kuze' ngok chop mod mile' rë men ze' xigab. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kuze' xtu wëlt mina'bdi'zh bixa' lo miyi' ngwani lo re': ―Nal lu, por ngwani lol, ¿kwan nel por xa' re'? Nkab miyi' re': ―Xa' re' nak tu xa' nidi'zh por Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kuze' rë men Israel ze' nangayilat bixa', chi walika mikal-lo xa' re' por niwi' xa' nal, haxta ngurezh bixa' xuz xa' re' no xna' xa', ");
INSERT INTO zcaNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","no mina'bdi'zh rë men fariseo ze', nzhab bixa': ―¿Chi xga'n go miyi' re', xa' nidi'zh men, ngolnu nikal-lo? ¿Mbaino xmod ngok niwi' xa' nal? ");
INSERT INTO zcaNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Orze' nzhab rop xa' nak xga'ne ze': ―Walika xga'n no xa' re', no nane no, ngolnu xa' kure', ");
INSERT INTO zcaNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","per nanet no xmod ngok miwi' xa', no ni nane no cho mile' miwi' xa'. Una'bdi'zh go lo miyi', lë' xa' plo la, yub xa' gak ne lo go, cho mile' ngwani lo miyi'. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Sa' midi'zh rë xa' nak xga'ne ze', porke nizheb bixa', lë' rë xa' nile' mandad xid rë men Israel mia'n la di'zh, lë' bixa' kutin rë men le'n yo' plo nitse'd bixa' widi'zh che'n Dios, chi cho gon bixa' di'zh, lë' Jesús nak Krist. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kuze'la, se' nzhab rop xa' nak xga'ne ze': “Bina'bdi'zh go lo mbe, porke lë' mbe plo la.” ");
INSERT INTO zcaNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Orze' ngurezh rë xa' fariseo ze' miyi' kwa'n ngok nikal-lo ze' xtu wëlt par nzhab bixa': ―Bine kwa'n wali lo no, no lo Dios, porke no nane, lë' miyi' ba' nzë'b xki la lo Dios por gat nzhon xa' nzho zhë ro. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Orze' nzhab xa' ngwani lo ze': ―Naneta mblë go, chi wali nzë'b xki xa' lo Dios o gat walite; nab tsa kwa'n nanen, lë'da ngol gat ñanit lon, no nal niwi'n. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Per xtu wëlt minabdi'zh bixa', nzhab bixa': ―¿Kwan ka mile' xa' kun lu? ¿Xmod mile' xa' par ngwani lol? ");
INSERT INTO zcaNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Orze' nzhab xa' ngwani lo ze': ―Lë'da ni lai lo go, per gat ñilat goi. ¿Chon nzhakla go nine xtu wëlt?, o, ¿kwan nu go nzhakla, gak go men che'n xa'? ");
INSERT INTO zcaNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Orze' gat lë't mikab bixa' lo miyi' re', nzhab bixa': ―¡Lu nak xpen miyi' ba', per no nak men che'n Muisés!, ");
INSERT INTO zcaNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","porke no nane ka, Dios midi'zh lo Muisés, per xa' re', ¡ni nane no plo nzë xa'! ");
INSERT INTO zcaNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Orze' nzhab miyi' re': ―¿Kwan kure' nalx? ¡Nanet go plo nzë xa' re', per mile' xa' ngwani lon! ");
INSERT INTO zcaNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Mbai rë be nane ka, Dios gat nzhont kwa'n nidi'zh men kwa'n nile' kwa'n gat lë'; nab tsa nile' Dios kwa'n nina'b men xa' nzhon ro' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Lalta' gat gon men, yo tu men le' yani lo xtu men nikal-lo dizde or ngol. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","No chi gat lë' Dios mixë'l miyi' re', orze' nagakt le' xa' ni tu rë zhi'n nazhon re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Orze' nzhab bixa' lo miyi' re': ―¡Lu, por nzë'b xkil lo Dios, kuze' dizde ngolal nikal-lol! No nal, ¿ti lu nzhakla tse'dal no che'n Dios? Kuze' ngulo'tin bixa' miyi' re' le'n yo' plo nitse'd bixa' widi'zh che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","No or mbin Jesús, ngulo'tin bixa' miyi' xa' ngwani lo ze', le'n yo' plo nitse'd bixa' widi'zh che'n Dios, no or ngwazhë'l Jesús miyi' xa' ngwani lo re', orze' mina'bdi'zh Jesús lo xa': ―¿Chi ñilal Xga'n Dios, xa' nu nak tu men yizhyuo? ");
INSERT INTO zcaNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Orze' nzhab miyi' re': ―Lë' go, bine go lon, cho xa' ze' par yilan xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Nkab Jesús: ―Niwi'l lo xa' ze' nal; kun lë' xa' kidi'zhal; na xa' ze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Lë'chi nguzuxib miyi' re' lo Jesús, nzhab xa': ―Lë' go, na ñila go. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Orze' nzhab Jesús: ―Na nzhal yizhyuo re' par kobe'n xmod nak men, nes par rë xa' nikal-lo, lë' bixa' yani lo; no rë xa' zak ñani lo; lë' bixa' ya'n nela men nikal-lo ga'. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","No pla rë men fariseo xa' nzo kun Jesús ze', or mbin bixa' widi'zh re', orze' nzhab bixa' lo Jesús: ―¿Kwan gabal, nikal-lo no orze'? Per gat nikalt lo no. ");
INSERT INTO zcaNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Orze' nzhab Jesús lo bixa': ―Chi zi go, nak go nela tu men nikal-lo ga', nagapt go dol lo Dios orze', porke lë' Ki che'n Dios zini lo go; per por zak go ñani lo go nal, kuze' net go zubi go lo Ki che'n Dios, no se'gaka ña'n go lo kwa'n nzë'b xki go lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Orze' nzhab Jesús: ―Walika kwa'n nin lo go; xa' gat ño ro' kurral plo nzho rë mbëkxi'l, wa'n xa' ze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Per xa' ño ro' kurral, xa' ze' nak xa' walika xa' nikina rë mbëkxi'l. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","No lë' xa' nikina ro' kurral, nixa'l xa'i par ño xa' nikina rë mbëkxi'l ze', no nilibe' rë mbëkxi'l ze' chi baxtor che'n bima. No or nigo' xa' bima, nibezh xa' tuga' rë mbëkxi'l ze' kun lë bima. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","No or nilox nigoche xa' rë mbëkxi'l ze', orze' nizhubner xa' lo bima, orze' rë ma ñakë tich xa', porke nilibe' bima chi xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Per tu xa' gat nilibe't rë mbëkxi'l ze', nayakët bima tich xa', lë'la karre nikë' bima lo xa', gat nzhakbe't bima chi xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Midi'zh Jesús kure' par nabei chi nganu laxto' bixa' kwan gab widi'zh re', per nangazobyekt bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Orze' nzhab Jesús xtu wëlt: ―Walika kwa'n nin, na nak nela ro' kurral plo ño rë xa' nak nela mbëkxi'l da ga'. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Rë xa' mbi'd lo go or naga yala lo go, ngok bixa' nela rë men wa'n ga', no nela rë men nzhut men ga'; per rë men da xa' nak nela mbëkxi'l ga', une bixa' gat lë't Dios mixë'l rë men ze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Na nak nela ro' kurral ga', no rë xa' ño le'n kurral che'n Dios por na, lë' bixa' ro' lo kwa'n nazhe'b kwa'n nzho bixa', no gak bixa' nela rë mbëkxi'l ma ño no niro' le'n kurral par nzhao ma yix nayë'. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Per rë xa' nzë namás par liwa'n, no par chil xa' rë men da xa' nak nela mbëkxi'l ga'; per na nzhal par nen yalnaban kwa'n nayot lox par go. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Lë'da nak baxtor xa' nazhi' rë ma che'n, mbaino ter gat da por lë' bima, ");
INSERT INTO zcaNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","per rë xa' nikë zhi'n nab tsa por dimi, or nine xa' lë' tu ma nazhe'b nzë, orze' nila' nzë'b xa' rë mbëkxi'l, nikë' xa' karre, porke gat lë't xa' xa' nak che'n ma; orze' nizen ma nazhe'b ze' rë mbëkxi'l, mbaino más ma nire'chbe orze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Men nzhax ka' ze', nikë' xa' karre or nine xa' ma nazhe'b ze', nila' nzë'b xa' rë mbëkxi'l, lë' xa' nile' por dimi namás. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Orze' nzhab Jesús: ―Nase nazhi' rë mbëkxi'l da, no nilibe'n rë ma da; mbaino rë ma da, nilibe' ska rë ma da. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Se'ska nilibe' Xuza da, no nilibe'n Xuza; mbaino ter gat da por rë men da, xa' nak nela mbëkxi'l ga'. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mbaino kinun más men, xa' nak nela mbëkxi'l, ma naga yo le'n kurral da; kuze' naki'n nu bixa' yakan; no gon bixa' kwa'n gapa par kwin bixa' tutsa kun más rë men da xa' nzho le'n kurral da, mbaino tutsa da kina rë bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Lë' Xuza Dios nazhi' da, por niye laxto'n gat da, par ruban da xtu wëlt. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Yent cho men gak gut da chi lë'da naziyël gat da. Zak len gat da, mbaino zak len ruban da. Kure' nak kwa'n ne Xuza len. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","No or mbin rë xa' nile' mandad xid rë men Israel xtu wëlt rë widi'zh re', orze' xtu wëlt chop mod ngok xigab che'n rë bixa', ");
INSERT INTO zcaNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","nzho bixa' nzhab: ―¿Chon nzhon go kwa'n nidi'zh xa' ba'? ¡Ka mbi mal nzen xa' ba', kuze' nzhak miyizh xa'! ");
INSERT INTO zcaNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Per más bixa' nzhab: ―¡Wenka xa', porke nagakt di'zh tu xa' nzho mbi mal laxto' sa'! ¿No xmod liyak tu xa' nzho mbi mal laxto' tu men nikal-lo? ");
INSERT INTO zcaNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Le'n rë zhë ze', mer rë mbëo' nayag, or nzhal lani kwa'n nile' bixa' gazob li'n che'n yado' yezh Jerusalén, ");
INSERT INTO zcaNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","dub nikizë Jesús ro' yado' gax laka Ro' Pwert che'n Salomón, ");
INSERT INTO zcaNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","no ze' migan nayax men xa' nile' mandad xid rë men Israel, naka'n plo nzo Jesús, par nzhab bixa': ―¿Pok ka nel lo no cho lux? Chi lu nak Krist, naka'chtal; binei lo no tuli. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Orze' nzhab Jesús: ―Lë'da ni lai lo go, per gat ñilat go da; por rë zhi'n nazhon kwa'n nilen por mandad che'n Xuza nilu', cho ka da, ");
INSERT INTO zcaNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","per gat ñilat go da, porke gat lë't men da go. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Rë xa' nak men da, nzhon bixa' widi'zh da mbaino nilibe'n bixa', no ñi'dkë bixa' ticha; ");
INSERT INTO zcaNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","mbaino len, ban bixa' kun Dios par dubta', no ni nayora' zhë lox bixa' lon, no yent cho kubchi bixa' lon. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Lë' Xuza michi bixa' lon, no lë'gaka Me más kwa'ro lo rë kwa'n nzho, no yent cho gak kubchi rë men da lo Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Lë' Xuza Dios no na, tutsa nak no. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Xtu wëlt, nguzen rë men Israel ze' ke par ngakë' bixa'i ta' Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","per nzhab Jesús lo bixa': ―Por mandad che'n Xuza milen rë zhi'n nazhon xid go; no nal, ¿por cho tu rë zhi'n nazhon re' nzhakla go gut go da kun ke? ");
INSERT INTO zcaNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Orze' nzhab rë men Israel ze': ―Nakot no kel por ni tu rë kwa'n nazhon mile'l ba', sino por midi'zhal kwa'n gat lë' lo Dios; nzhabal, nakal yubska Dios, mbaino ¡men yizhyuolx! ");
INSERT INTO zcaNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Per nzhab Jesús lo bixa': ―¿Chi gat lë't lo ley che'n go nzobni' widi'zh re': “Na ni, lë' go nak dios”? ");
INSERT INTO zcaNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nane be, par dubta' wali kwa'n nzobni' lo Ley che'n Dios, yent cho gak chë'i. Men miza' Dios widi'zh re', nzhab Me, xa' re' nak nela Dios ga'. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","No chi lë' Dios ngule da par mixë'l Me da yizhyuo re', orze', ¿chon nidi'zh go, midizha kwa'n gat lë' lo Dios, por midizha, nak da Xga'n Dios? ");
INSERT INTO zcaNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","No chi lë'da gat nile rë kwa'n nzhakla Xuza gak, orze' bila' go nayilat go da; ");
INSERT INTO zcaNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","per chi nilene, ter nayilat go da, namás biwi' go por rë kwa'n nilen, par ne goi no par zobyek go, lë'da tutsa nak kun Xuza, no tutsa nak ska Xuza kun na. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Orze' xtu wëlt ngokla bixa' ngazen bixa' Jesús, per mile' Jesús gan ya' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Orze' miëk Jesús par xtu ro' you' Jordán, plo mililëi' Juan men le'n nits, ze' mia'n Jesús che'p, ");
INSERT INTO zcaNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","no ze', nayax men ngwatswi' lo Jesús, kidi'zh bixa': ―Ter nangale't Juan ni tu rë zhi'n nazhon, per rë kwa'n midi'zh Juan por miyi' re', lë'i walika. ");
INSERT INTO zcaNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","No ze' nayax men ngwayila Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ngol tu zhë, ngokne tu miyi' xa' lë Lásaro, no yezh Betania nzë xa' kun Mari no Mart, bizan xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mari una' ze' michob aseit ni' Jesús no mitsibizh una'i kun yich yek una'. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Rop una' re' nak bizan Lásaro, mixë'l biuna' razón lo Jesús, nzhab bixa': ―Lë' go, lë' xa' nichë'l go ze', nzhakne. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","No or mbin Jesús kure', nzhab Me: ―Yalyizh re' nale'te gat Lásaro par dubta', sino lë'i zu' par ne men, xmod nak yalnazhon che'n Dios, mbaino yalnazhon che'n Xga'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","No dox nazhi' Jesús Mart, no Mari, mbaino Lásaro. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","No or mbin Me, lë' Lásaro nzhakne, ngulëz Me xchop ngubizh plo nzo Me, ");
INSERT INTO zcaNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","no or nded rop zhë ze', orze' nzhab Jesús lo rë men che'n Me: ―Cha'o nzha be xtu wëlt lazh men Judea. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Orze' nzhab rë men che'n Me lo Me: ―Maestr, nal laka ngokla rë men Israel xa' nzho ze', ngut bixa' go kun ke, ¿no nal xtu wëlt nzhakla go ya go ze'? ");
INSERT INTO zcaNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Orze' nzhab Jesús: ―¿Chi gat lë't tu dusen or kinu tu ngubizh? No tu xa' nizë or zhë, ni por más nayachint xa', porke ñani plo nizë xa', ");
INSERT INTO zcaNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","per xa' nizë lo nakao, lë' xa' yachin, porke gat kinut xa' biani. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","No nu nzhab Jesús: ―Lë'da nzhalixche Lásaro, xa' nichë'l be ze', lë' xa' naxnaa. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Orze' nzhab rë men che'n Me: ―Lë' go, chi lë' xa' naxnaa, lë' xa' yak ka orze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Nzhab Jesús kure' por ngut Lázaroi, ter mile' rë men che'n Me xigab, naxnaa ka Lásaro, ");
INSERT INTO zcaNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","orze'se tuli nzhab Jesús: ―Lë' Lásaro ngut, ");
INSERT INTO zcaNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","no nizak laxto'n por gat nzon ze', más wene par go, par más yila go da. Nal cha' go, nzha be lo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Orze' lë' Max, xa' nidi'zh men kwach ze', nzhab xa' lo más rë men che'n Jesús: ―Cha'o nzha be, par nu be gat kun lë' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","No or mizhin Jesús yezh Betania, nzha la tap ngubizh di miga'ch Lázaro. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","No yezh re' ña'n paste chon kilómetro di yezh Jerusalén, ");
INSERT INTO zcaNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","no nayax men xa' nzë lazh men Judea ngwatswi' bixa' ma Mart kun Mari, par tsiyal bixa' laxto' rë una' re' por yalnawin che'n bizan bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Or mbin Mart, lë' Jesús nzhazhin la gax ze', orze' nzhakinez una' Jesús, mbaino lë' Mari mia'n yo'. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Nzhab Mart lo Jesús: ―Lë' go, chi ngak re' nzou, nangatta' bizana, ");
INSERT INTO zcaNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","per ter gat nzou orze', lë'da nane ka, lë' Dios le' rë kwa'n na'b go lo Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Orze' nzhab Jesús: ―Lë' bizanal ruban ka. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Orze' nzhab Mart: ―Na nane ka, lë' bizana ruban zhë lult, or ruban rë men ngut, yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Orze' nzhab Jesús: ―Na nile niruban men, mbaino nilen, niban men dubta' kun Dios; no xa' yila da, ter ngut la xa', lë' xa' ruban ka, ");
INSERT INTO zcaNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","no rë xa' naban nalre', mbaino ñila bixa' da, nayot gat xa' par dubta'. ¿Chi ñilal kure'? ");
INSERT INTO zcaNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Orze' nzhab Mart: ―Na ñila ka Go. Go nak Krist, Xga'n Dios, Me nak di'zh yi'd yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","No or milox midi'zh Mart kure', orze' miëk una' lizh una', no xla'n ngurezh una' Mari bël una', par nzhab una': ―Lë', lë' maestr nzo re', kibezh Me lu. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","No or mbin Mari kure', tuli ngwa una' lo Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","No lë' Jesús stubi nagat yo Me ro' yezh, ñë'dzë Me plo ngwakinez Mart Me, ");
INSERT INTO zcaNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","no pla rë men Israel xa' nzhatsiyal laxto' Mari ze', or une bixa' nzha Mari, nu bixa' nzhakë, mile' bixa' xigab pas ro' ba' nzha una' re', nzhayo'n una'. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Or mizhin Mari lo Jesús, tuli nguzuxib una' lo Me, no nzhab una': ―Lë' go, chi ngak nzo go re', nangatta' bizana. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","No or une Jesús nzho'n Mari kun rë men Israel xa' nzë kun lë' una', orze' dox gat lë' mizi Jesús, mbaino miwin laxto' Me, ");
INSERT INTO zcaNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","orze' nzhab Jesús: ―¿Plo mika'ch go xa'? Nkab bixa': ―Al re'i, wi'gole. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Orze' mbi'n Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","no kidi'zh rë men Israel xa' nzhin ze': ―Biwi'ule, tatu nazhi' xa' Lásaro. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Per más bixa' kidi'zh: ―Xa' ba' mile' ngwani lo tu xa' dizde or ngol nikal-lo; ¿taxa, chi nangakt ngale' xa' tu kwa'n par nangatta' Lásaro? ");
INSERT INTO zcaNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Orze', xtu wëlt dox gat lë't mizi Jesús, no nguzubi Me haxta ro' ba' che'n Lásaro, le'n tu ba' kwa'n nak pura ke, mbaino nayao' ro'i kun tu ke ro, ");
INSERT INTO zcaNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","no nzhab Me: ―Gure go ke ba'. Per nzhab Mart bizan yinto' re': ―Lë' go, guzhë nila' xa' re', porke nzha la tap ngubizh miga'ch xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Orze' nzhab Jesús: ―Lë'da ni la lol, chi lë'l yila da, lë'l ne yalnazhon che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ngure bixa' ke orze', no miwi' Jesús al ya' lo yibë', nzhab Me: ―Xuza, kinin xkixal por mbinal kwa'n mina'ba lol. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Na nane ka, rë or nzhonal kwa'n nina'ba lol, per por rë xa' nzhin re' kinin kure', par yila bixa', Lu ka Me mixë'l da. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","No or milo'x midi'zh Me kure', orze' naye nzhab Jesús: ―¡Lásaro, gurutin ba'! ");
INSERT INTO zcaNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nguro' xa' ngut re' le'n ba' orze', dub xa' narël lar, mbaino nali'b ya' xa' no ni' xa', no nayao' lo xa' kun xtu lar, orze' nzhab Jesús: ―Bixëk go xa' no bila' go bi xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kuze' nayax men Israel xa' ngwakë tich Mari, ngwayila bixa' Jesús, or une bixa' kure', ");
INSERT INTO zcaNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","per zipla bixa' ngwayab lo rë men fariseo rë kwa'n mile' Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","orze' migan rë ngulëi' ro xa' nile' mandad lo más rë ngulëi', kun rë men fariseo par mikan bixa' rë jwes, xa' más nile' mandad, orze' nzhab bixa': ―¿Xmod le' be nal? ¡Dox rë kwa'n nazhon kile' mbe ba'!, ");
INSERT INTO zcaNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","no chi la' be, lë' rë men yila miyi' ba', orze' lë' rë men Roma, xa' nak zhi'n xid be, yi'dchil yado' che'n be mbaino lo'x bixa' rë men lazh be. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","No xid rë xa' nzhin ze', nzho tu ngulëi' lë Caifás, xa' nak ngulëi' ro li'n ze', orze' nzhab xa' re': ―Rë go, yent kwan nane go, ");
INSERT INTO zcaNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿chi gat nile't go xigab, más wen gat tutsa men ke par lox rë men lazh be? ");
INSERT INTO zcaNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Per Caifás nangadi'zht xa' kure' por mis xigab yek xa', sino ke Dios mile' nzhab xa'i, por nak xa' ngulëi' ro li'n ze', kuze' nzhab xa', naki'n gat Jesús par nalox rë men Israel, ");
INSERT INTO zcaNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","no gat lë't par nalox nab rë men Israele, nu par nalox rë men che'n Dios xa' nzhin dub yizhyuoi, nes par gak bixa' tutsa ben men. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Orze', dizde zhë ze', nguzublo kikwa'n rë men Israel ze' mod gut bixa' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kuze', nangakizëtra' Jesús xid rë men Israel xa' nak zhi'n ze', sino ke nguro' Me lazh men Judea, nzha Me tu yezh kwa'n lë Efraín, kwa'n ña'n gax le'n yuo bizh; ze' mia'n Me kun rë men che'n Me, ");
INSERT INTO zcaNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","no xplatsa ngubizh jwalt antis di gal lani Pask che'n rë men Israel, kuze' rë men yezh Israel, nzha bixa' yezh Jerusalén par mbe bixa' lo Dios antis de gal lani, nela xmod nzobni' lo ley ga'. ");
INSERT INTO zcaNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Dub nzhin rë men ro' yado', ze' kikwa'n bixa' Jesús, kidi'zh bixa' lo wech bixa': ―¿Chi neuse, pas nayi'dt miyi' ze' nal lani re'? ");
INSERT INTO zcaNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","No lë' rë men fariseo kun rë xa' nzo lo rë ngulëi', mia'n bixa' di'zh, chi tu men ne Jesús, naki'n yayab xa'i lo rë men xa' nzo lo más rë men par yatsen bixa' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nzhak jwalt zixo'p ngubizh par gal lani Pask, orze' ngwa Jesús tu yezh kwa'n lë Betania, plo nzho Lásaro, miyi' kwa'n mile' Jesús nguruban ze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","No ze' mizuxkwa' bixa' tu kwa'n ndaoxche' bixa' kun Jesús; lë' Mart mizhine lo bixa', no nu Lásaro nak tu rë xa' nzob lo mes par gao xche' kun Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","orze' nguzen Mari pas garol litr aseit kwa'n viv kwa'n lë nardo, no dox tsake, no nix nixla'i; orze' michob una'i ni' Jesús, no kun yich yek una' mitsibizh una'i, mbaino dub le'n yo' ze' mixla'i. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Orze' lë' Judas Iscariote, xa' nak tu rë men che'n Jesús, no xa' re' xa' kwa'n chi Jesús par gat Me, orze' nzhab xa': ");
INSERT INTO zcaNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Chon nangado nits nax re' kwa'n tsak dimi kwa'n nile' men gan chon gayo' ngubizh zhi'n, par ngaga'z dimi re' ka' rë men yent kwan nzhap? ");
INSERT INTO zcaNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Per gat lë't por nilats laxto' Judas rë men prob nzhab Judas kure', sino por lë' xa' niguchao' dimi kwa'n nigan, no nu niliwa'n xa'i, ");
INSERT INTO zcaNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","kuze' nzhab Jesús: ―Bila' chob una' re'i ni'n, lë' xa' kinuchao' aseit re' par zhë or ga'ch da. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Rë men prob, zilita' yo bixa' xid go, per na gat lë't dubta' nzon kun go. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","No dox nayax men Israel mbin, lë' Jesús nzho yezh Betania, kuze' ngwa bixa' ze', per gat lë't nab Jesús nzhatsi' bixa' ma, nu par ne bixa' Lázaroi, xa' mile' Jesús, nguruban ze', ");
INSERT INTO zcaNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","orze' lë' rë ngulëi' xa' nile' mandad lo más rë ngulëi', mia'n bixa' di'zh nu Lásaro gut bixa', ");
INSERT INTO zcaNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","porke por xa' re' namás, dox nayax men Israel ngwayila Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nayax men ngwa lani yezh Jerusalén, no xtu riyë'l mbin men lë' Jesús nzhazhin la yezh re', ");
INSERT INTO zcaNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","orze' ngwakinez bixa' Me, micho' bixa' la che'n ya yin par ndi'x bixa'i nez plo ded Jesús, no nguruzhië bixa' naye, nzhab bixa': ―¡Guzh go nazhon Dios! ¡No wen nzha xa' mixë'l Dios nak rey lo rë men Israel! ");
INSERT INTO zcaNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Orze' mizhë'l Jesús tu burrit, no nguzob Me tich ma, nela nzobni' ka lo Yech che'n Dios: ");
INSERT INTO zcaNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Nazhebt go men yezh Sion; biwi' go, lë' rey che'n go nzë, nzob xa' tich tu burrit. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Or galo laka, nanganut laxto' rë men che'n Jesús kwa'n ngok re', per or nguruban Jesús, orze' miza' bixa' kwent, lë'i ngok porke lë'i nzobni' la lo Widi'zh che'n Dios kwa'n zak Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","No rë men kwa'n une, or mile' Jesús nguruban Lázaro le'n ba', kidi'zh bixa'i xid men rë kwa'n ngok, ");
INSERT INTO zcaNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","kuze' nguro' nayax men yezh Jerusalén par ngwakinez bixa' Jesús por mile' Jesús tu kwa'n nagat ne men, ");
INSERT INTO zcaNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","orze' nzhab rë men fariseo lo wech bixa': ―¡Biwi'u, yent kwan gak le' be par ka'n be lo men! ¡Yub ka bixa' nzhakë tich xa' ba'! ");
INSERT INTO zcaNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Xid rë xa' nzë lani Pask kwa'n gal yezh Jerusalén, nu pla men grieg nzë xid rë men ze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nguzubi rë men grieg re' lo Lip, xa' nzë yezh Betsaida kwa'n ña'n lazh men Galilea, par mina'bdi'zh bixa' lo Lip, nzhab bixa': ―Lë' go, ¿xmod le' no ne no Jesús? ");
INSERT INTO zcaNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Mbaino ngwayab Lipe lo Ndrés, orze' rop bixa' ngwayabe lo Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","orze' nzhab Jesús: ―Ngol la or libe' men cho ka nak Xga'n Dios, Me nu nak tu men yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Walika kwa'n nin lo go, chi lë' tu lazh triu nayo lo yuo no chi nayao' yoi, nalënte, mbaino naza'te; per chi yao' yoi no lëne, orze' lë'i za'. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Men xa' naban xigab yek yizhyuo re', lë' xa' yitlo lo Dios; per xa' naban xmod nzhakla Dios yizhyuo re', xa' ze' ban kun Dios par dubta'. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Chi nzho cho go nzhakla gak men da, naki'n yi'dkë go ticha; no plo yo'n, nu go yo ze'; no cho go nile' zhi'n da, lë' Xuza Dios di'zh wen por go ze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’No dox nakwan nizi da nal re'; ¿no kwan gapa nal? ¿Chi zapa?: “Xuza, gulo' Go da lo rë kwa'n nazhe'b re'.” Per na nane ka, por rë kure' ka nzhala yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Xuza, bile' go par di'zh men, dox nazhon go. Lë'chi mbin rë xa' nzhin ze' tu widi'zh kwa'n nguro' lo yibë', nzhab se': ―Lë'da mile lai, per lë'da lei xtu wëlt, lë' men di'zh nazhon da. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","No rë xa' mbin kure', rë xa' nzhin ze', nzhab: “Nguzi' kure'”, no más bixa' nzhab: “Ka tu ganje.” ");
INSERT INTO zcaNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Orze' nzhab Jesús: ―Gat lë't par da mbin go widi'zh re'; par go kai, ");
INSERT INTO zcaNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","mbaino nalse mizhin la zhë, gab Dios xmod gak kun rë men yizhyuo re'; no nalse lë' Dios kutin xa' nile' mandad yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","No na, or kë' bixa' da lo krus, orze' kwantsa men kana par da. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kure' midi'zh Me par nzhab Me xmod gat Me, ");
INSERT INTO zcaNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","orze' nzhab rë men: ―No nane, lë' lo ley nzobni': “Lë' Krist nayot gat, lë' Me ban par dubta'.” No, ¿chon nidi'zhal, lë' Xga'n Dios Me nu nak tu men yizhyuo, naki'n kë lo krus? ¿No cho nak Xga'n Dios xa' kize'tal re'? ");
INSERT INTO zcaNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Orze' nzhab Jesús: ―Stubi nzo Me nak Ki re' kun go, per kaxche'p nzo Me re' kun go. Kuze' guzë go lo biani che'n Me lë'ga nzo Me kun go; napa zë go lo nakao, porke xa' nizë lo nakao, nanet xa' plo nizë xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Wayila go Me nak Ki re' lë'ga' nzo Me kun go, par gak go men che'n Me, xa' nzhin lo biani. No or milox midi'zh Me widi'zh re' lo rë men Israel ze', nguibchi Me lo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","No ter nayax kwa'n nazhon milu' Jesús lo rë men Israel, per ni se' nangayilat bixa' Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","par ngok ka kwa'n mizobni' Isaías lo yech, kwa'n nzhab: Dios da, ¿cho ngwayila widi'zh che'n be, no cho lo milu' go yalnazhon che'n go? ");
INSERT INTO zcaNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kuze' nangakt ngayila bixa'i, porke nu se' mizobni' Isaías lo yech: ");
INSERT INTO zcaNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dios mile' nagakt lu'i lo go, no nu mile' Dios, ngok nad laxto' go; par nagak ne goi, no par nayila goi kun dub laxto' go; par ngayëk go lon, orze' ngache'n rë kwa'n nzë'b xki go, no rë kwa'n nzadkë tich go. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Mikë' Isaías widi'zh re' porke lë' Dios milu' la rë yalnazhon che'n Jesús, mbaino rë kwa'n le' Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","No ter se' unkë lo yech, per nayax men Israel ngwayila bixa' Jesús, haxta nu pla rë xa' nzo lo bixa' ngwayilai, per nangadi'zht bixa'i lo rë men porke nizheb bixa' lo rë men fariseo, napa' kutin rë xa' re' bixa' le'n yo' plo nitse'd bixa' widi'zh che'n Dios, ");
INSERT INTO zcaNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","porke rë xa' ngwayilai re', más ño laxto' bixa' ya'n bixa' wen kun men, ke par ya'n bixa' wen kun Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Orze' midi'zh Jesús naye: ―Rë xa' ñila da, gat lë't nab da ngwayila xa'; nu Xuza Me mixë'l da, ngwayila bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Or nzon xid go, nak nela yub Xuza, Me mixë'l da, nzo kun go. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Na nak Ki lo rë men yizhyuo re'; xa' yayila da, nakizëtra' xa' lo nakao, ");
INSERT INTO zcaNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","no cho xa' nzhon widi'zh da, per gat nile't xa' kwa'n nzhapa, nana'bta kwent lo bixa', porke gat nzhalta par kobe'n kwan nak men yizhyuo re'; nab tsa nzhala par kon men lo rë kwa'n nazhe'b kwa'n nzadkë tich men. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Men xa' nzhab yent kwane rë kwa'n nidizha, nzho ra' cho kobe' (wi') kwan nak xa', lë' rë widi'zh da kobe'i, or zhin zhë gab Dios xmod gak kun kad men. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Porke gat lë't por xigab yeka kinin kure', lë'ka Xuza Dios ne lon kwan ñal dizha, no kwan ñal lun. ");
INSERT INTO zcaNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","No nanen, lë' widi'zh che'n Xuza Dios, nile' niban men par dubta' lo Dios. Kuze' nidizha lo go, rë kwa'n mile' Xuza mandad gon go. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nzhazhin gax la lani Pask, lë' Jesús nane la, nzhazhin la zhë bi Me yizhyuo re' par yëk ska Me lo Xuz Me. Dub mbi'd Jesús yizhyuo re', kun dub la Me michizhi' Me rë men che'n Me haxta zhë ña Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Or kiyao xche' Jesús kun rë men che'n Me, ze' nzob Judas Iscariote, xga'n Simón, no lë' Mizhab migoch la yek xa' par chi xa' Jesús lo rë men Israel xa' nak zhi'n. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Per lë' Jesús nane la, lë' Xuz Me Dios mila' la rëi ya' Me, no nane Jesús, Dios mixë'l Me, no lë' Me yëk ska lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Or dub kiyao Jesús lo mes, ngwatsuli Me, orze' ngulo' Me kaxkem che'n Me, no nguzen Me tu lar, mili'b Mei laxto' Me, ");
INSERT INTO zcaNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","orze' ngulo Me che'p nits le'n tu chë', nguzublo Me kizët Me ni' rë men che'n Me, no kun lar ze' kitsibizh Me ni' tuga' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","No or mizhin Me lo Simón Per, nzhab Per: ―Lë' go, ¿taxa Go zët ni'n? ");
INSERT INTO zcaNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Orze' nzhab Jesús: ―Nal nanetal kwa'n kilen, per lë'l zobyek ka kwane. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Orze' nzhab Per: ―¡Nase lata zët go ni'n! Per nzhab Jesús: ―Chi lë' Da nazët ni'l, nagaktal men da. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Orze' nzhab Simón Per: ―¡Lë' go, nazëta' go nab ni'n, nu ya'n nu yeka bizët go! ");
INSERT INTO zcaNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Orze' nzhab Jesús: ―Rë xa' laore ngoz, gat naki'ntra' gaz xa' xtu wëlt, nab tsa ni' xa' naki'n yët; lë' rë go nambe la, ter gat lë't rë nak goi. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Midi'zh Me, gat lë't rë nak bixa' nambe; lë' Me nane la cho chi Me lo rë xa' nile' mandad. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","No or milox mizët Jesús ni' rë nak men che'n Me, orze' ngok Me kaxkem che'n Me, no nguzobska Me, orze' nzhab Me: ―¿Chi mizobyek go kwan milen kun go? ");
INSERT INTO zcaNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Lë' go nine lon: “Maestr”; mbaino nine go, na nile mandad go; no walika go nak dai. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Pwes chi lë'i Da nak Maestr che'n go, mbaino xa' nile' mandad lo go, no dub sba' mizeta ni' go; no se'ska ñal zët go ni' rë men Da. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Na milu lo go, xmod ñal le' go, par nu go le' kwa'n milen. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Go nane ka, yent cho tu mos nado más tsak xa' lo xa' nguzi' xa'; mbaino ni tu xa' ña mandad natsakt más lo xa' nixë'l xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Chi lë' go zobyek kure', mbaino le' goi, dox wen ya go. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Gabt go por rë go kidizha kure'; na nili'be' ka rë xa' ngulen, per naki'n gak widi'zh kwa'n nzobni' lo Yech che'n Dios por Da: “Men nzhao kun na, men ze' niyi' nine da.” ");
INSERT INTO zcaNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kure' nin lo go, lë'ga' naga gak rë kure', nes par or gake, orze' yila go, na nak xa' nzhapa nak da. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Walika kwa'n nin lo go, xa' le' wen lo men Da, lon mile' xa'i; mbaino xa' le' wen lon, lo Xuza mile' xa'i, Me mixë'l da. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","No or milox midi'zh Jesús kure', dox niwin laxto' Me, no tuli nzhab Mei: ―Walika kwa'n nin lo go, mis tu rë go re', chi da lo rë xa' nile' mandad. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Orze' nguzublo niwi' rë men che'n Jesús lo wech bixa', per nanet bixa' par cho yek nzha kure'. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","No tu rë men che'n Jesús, xa' dox nichë'l Me kun lë', nzob kiyao gax ta' Me, ");
INSERT INTO zcaNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","orze' milu' Simón Per tu señ lo xa' re', par na'bdi'zh xa' re' lo Jesús, cho ka xa' ze', ");
INSERT INTO zcaNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","orze' nguzubi xa' re' xche'p gax ta' Jesús, par nzhab xa': ―Lë' go, ¿cho ka xa' ze' ga'? ");
INSERT INTO zcaNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Orze' nzhab Jesús: ―Lë'da gazh tlë' pan, no zane ka' xa', xa' ze'i orze'. Orze' migazh Jesús tlë' pan, no miza' Mei nka' Judas, xga'n Simón Iscariote. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","No or milox ndao Judas tu bok pan re', orze' nguio Mizhab laxto' xa', kuze' nzhab Jesús lo Judas: ―Kwa'n nile'l xigab le'l, bile'i tuli. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Per ni tu rë men che'n Jesús, xa' nzhin kiyao xche' ze', nangazobyekt bixa', chon midi'zh Jesús lo Judas se', ");
INSERT INTO zcaNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","no por lë' Judas nak xa' niguchao' dimi, kuze' mile' zipla bixa' xigab, pas nzhab Jesús, zi' Judas más kwa'n gao bixa' par zhë lani, o ki'z xa' dimi ka' rë men prob, ");
INSERT INTO zcaNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","no or milox ndao Judas bok pan re', tuli nguro' xa', no yë'l la orze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","No or nguro' la Judas, orze' nzhab Jesús lo más rë men che'n Me, xa' mia'n ze': ―Mizhin zhë, rulo yalnazhon kwa'n kinu Xga'n Dios, Me nu nak tu men yizhyuo; mbaino por Xga'n Dios, rulo yalnazhon che'n Dios, ");
INSERT INTO zcaNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","no chi lë' Xga'n Dios lu' xmod nak yalnazhon che'n Dios, nu ska Dios lu' xmod nak yalnazhon che'n Xga'n Me; no lu' Mei tuli. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Rë xmë'da, nin lo go, kaxche'ptsa nzon kun go; lë' go kwa'n da, per nela nzhap ka lo rë xa' nile' mandad lo rë men Israel, se'ska nin lo go nal: Nagakt bi go plo bi'n. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Lë'da lu xtu mod ban go: Bichizhi' go wech go. Nela xa nazhi' da go ga', se' bichizhi' go tu go kun xtu go. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Chi lë' go chizhi' tu go kun xtu go, orze' lë' rë men yizhyuo ne, lë' go nak men da. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Orze' mina'bdi'zh Simón Per lo Jesús, nzhab xa': ―Lë' go, ¿plo biu? ―Plo bi'n, ―nzhab Jesús― nagakt yi'dkël ticha nalre', per zhin zhë, lë'l yi'dkë ticha. ");
INSERT INTO zcaNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Orze' nzhab Per: ―Lë' go, ¿chon nagakt yi'dkë'n ticha go nalre'? ¡Wanei kwane lë'da re', ter gat da por go! ");
INSERT INTO zcaNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Orze' nzhab Jesús: ―¿Chi walikal, ter gatal por da? No kwa'n nanen, ni naga kë' gai kant, chon wëlt ka'chal, gabal, nalibe'ta'l da. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Orze' nzhab Jesús lo bixa': ―Nawint laxto' go; wayila go Dios no wayila go da. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Plo nak lizh Xuza, nzho dox plo yo go, no chi gat lë' se' nake, naganita lo go; lë'da yazuxkwa' plo yo go. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Or lox zu'xkwa'n plo yo go, lë'da yëk ska par yi'dkan go, nes tutsa plo yo be. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","No lë' go nane la plo niro' nez par bi'n. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Orze' nzhab Max lo Jesús: ―Lë' go, nanet no plo biu; no, ¿chon ne go, lë' no nane la nez? ");
INSERT INTO zcaNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Orze' nzhab Jesús: ―Lë'da nak nez, no por na gak libe' men Dios, mbaino por na, gap men yalnaban kun Dios par dubta'; kuze' nab tsa por na gak zhin go plo nzho Xuza Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Chi lë' go nilibe' da, nu ska Xuza nili'be' go; no nal ra' re' nili'be' go Me, no lo Me kiwi' go nal re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Orze' nzhab Lip lo Me: ―Lë' go, bilu'o Xuz be Dios lo no; nes yentra' kwan ne no lo go. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Orze' nzhab Jesús: ―¿Taxa Lip, dox nzhala nzon kun go?, no, ¿chi stubi nagat li'be'l da? Men xa' une da, yub Xuza une xa'. ¿Chon nzhaklal, lun Xuza Dios lol? ");
INSERT INTO zcaNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Chi gat ñilatal, tutsa no kun Xuza, no lë' Xuza Dios tutsa Me kun na? Rë kwa'n nin lo go, no rë kwa'n une go milen, nangaletne xigab yeka; lë' Xuza, Me tutsa no kun lë', lë' Me nile' kun na rë kwa'n nzhakla Me gak. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Wayila go, lë'da tutsa kun Xuza Dios, no lë' Xuza Dios tutsa kun na; chi naga yila go da, wayila go da por rë kwa'n une go, milen. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Walika kwa'n nin lo go, xa' yila da, lë' xa' le' mis rë kwa'n nilen; no haxta más rë kwa'ro le' xa' ze', porke lë'da bi' plo nzho Xuza. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na le rë kwa'n na'b go lo Xuza por nak go men da, nes par lun xmod nak yalnazhon che'n Xuza. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Na le rë kwa'n na'b go por lën. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nzhab Me: ―Chi lë'o nazhi' da, lë'o le' kwa'n nin. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Na na'b lo Xuza, par xë'l Me Sprit che'n Me par gaknu go lo rë kwa'n, mbaino zo Me kun go par dubta'. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Lë' Sprit che'n Dios re' lu' kwan pa' nak che'n Dios. Per rë men yizhyuo, gat ñilat xa' rë kwa'n nzë por Sprit che'n Dios, porke gat ñilat xa' kwa'n gat nilu' lo xa', kuze' gakt libe' xa' Sprit che'n Dios. Per go, nilibe' ka Me, nzo Me kun go, mbaino yo Me laxto' go. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nalata nab go nela tu më'd wizëb ga', lë'da yëk ska xtu wëlt lo go. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","No kaxche'p, lë' rë men yizhyuo re', nanetra' bixa' da; per go, lë' go ne ka da, porke ter gat da, lë'da ruban ska; mbaino or gat go, lë'da le, nu ska go ruban. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","No zhë yala ze', lë' go ne, tutsa no kun Xuza; no tutsa go kun na, mbaino tutsa nak da kun go. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Xa' nzhak widi'zh da, no nile' xa' kwa'n nzhapa, walika nazhi' xa' ze' da; no xa' kwa'n nazhi' da, lë' Xuza chizhi' ska xa', no na chizhi' xa' ze', no lun lo xa' cho ka nak da. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Orze' xtu Judas (xa' gat lë't Iscariote) nzhab xa' lo Jesús: ―Lë' go, ¿chon nab tsa lo no, lu' go cho nak go, no gat nut lo más rë men yizhyuo re'? ");
INSERT INTO zcaNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Orze' nzhab Jesús: ―Chi cho xa' nazhi' da, lë' xa' le' kwa'n nzhapa, orze' lë' Xuza chizhi' xa' ze', mbaino yo no laxto' xa' ze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Per xa' gat nazhi' da, gat nzhont xa' kwa'n nzhapa. Rë widi'zh kwa'n nin lo go re', gat lë't chedai, che'n Xuzai, Me mixë'l da yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Lë'ga' nzon kun go, kinin kure' lo go. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Lë' Xuza xë'l Sprit che'n Me yo laxto' go, por nak go men da; lë' Sprit che'n Dios lu' lo go rë kwa'n jwaltra' ne go, nu par tsila go rë kwa'n ninin lo go dizde or galo. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Lë' go ya'n, per lë'da le chul zi laxto' go; no kwa'n len zi go chul re' gat nakte nela xmod nizi rë men yizhyuo, xa' nzho chul. Nawint laxto' go, mbaino ni nazheb go. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nal, lë' go mbin la kwa'n nin, lë'da bi', per lë'da yëk ska. No chi lë' go walika nazhi' da, lë' go zak laxto' mbin go, lë'da ña plo nzho Xuza, no lë' Me más tsak lon. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Lë'da kini la rë kure' lo go nal re', nes par or gake, orze' yila go rë kwa'n ni la. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Yentra' kwan ganin lo go nal re', lë' xa' nile' mandad yizhyuo re' nzë la, per yent kwan gak le' xa' kun na. ");
INSERT INTO zcaNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Per ñal ka gake se', par ne rë men yizhyuo, lë'da nazhi' Xuza no nilen rë kwa'n nine Me. Nal cha' go, yubchi be re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Nzhab Jesús: ―Na nak nela xan tu ya gub ga', lë' Xuza nak xa' nikinai. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Lë' rë men da nak nela ya'i ga'. No chi tu rë ya'i re' naza' xlë por nzë'b nale lo yuo, orze' lë' xa' nikinai litse par nabei chi ziza'i; no rram kwa'n kiza', lë' xa' tsimbei par za'i más. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","No lë' rë go mimbe la por rë widi'zh kwa'n midizha lo go. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Biwi' go dubta' lon, nes nuska da wi' lo go. Tu rram ya gub nagakt za'i nabe chi gat lë' por xane. No se'ska go, nagakt le' go zhi'n nazhon da chi lë' go nawi' lon. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","No nzhab Jesús: ―Na nak nela xan tu ya gub ga', no lë' go nak nela ya'i ga'. Men dubta' wi' lon, orze' tutsa gak da kun men ze', no xa' ze' dox za' xlë, nela ya gub ga'; no chi lë' go nawi' lon, yent kwan tsak rë kwa'n le' go lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Men nawi' lon dubta', orze' lë' xa' gak nela rram bizh che'n tu ya gub ga' kwa'n zu' par yol namás. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Chi lë' go dubta' wi' go lon, no chi zilita' nile' go kwa'n milun lo go; orze' una'b go kwa'n nzhakla go lo Xuza, no lë' Me ne'i. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Or nile' go kwa'n nzhakla Dios, orze' nilu' walika men da go, no por kure', lë' rë men di'zh nazhon Xuza Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nela xmod nazhi' Xuza da, se'ska nazhi' da go; no se' ga', bile' go dubta' tu go kun xtu go. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Chi dubta' le' go kwa'n nzhaklan, orze' ne go xmod nazhi' da go, nela nanen xmod nazhi' Xuza da por nilen kwa'n nzhakla Xuza. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Nin kure' lo go par dox zak laxto' go, nela nizak laxto'n ga'. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Kure' nin lo go le' go: Bichizhi' go tu go kun xtu go, nela xmod nazhi' da go ga'. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Yalnazhi' más kwa'ro nak, ziyël tu men gat xa' por xa' nichë'l xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Lë' go nak xa' nichëla chi lë' go le' kwa'n nzhaklan, orze' nak go xa' nichëla. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nanitra' lo go mos, porke xa' nguzi' tu mos, gat nidi'zht xa' lo ne' rë kwa'n nile' xa'. Lë'da kulë go, xa' nichëla, porke nidizha lo go, rë kwa'n ne Xuza lon. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Gat lë't go ngule da; na ngule go; kwa'n kina'ba lo go, gak go nela rë ya kwa'n niza' nayax dox xlë dubta', nes par lë' Xuza, ne' rë nak kwa'n na'b go lo Me, por nak go men da. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kure' kina'ba lo go le' go: Bichizhi' go tu go kun xtu go. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Chi lë' rë men yizhyuo yi' ne go, bitsila go, galo laka kun na mile' bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Chi ngak lal go kun rë men yizhyuo, orze' lë' bixa' chizhi' go nela nazhi' bixa' rë men che'n bixa'. Per por ngulen go xid bixa', kuze' niyi' bixa' nine bixa' go. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Bitsila go kwa'n nin lo go re': “Ni tu mos nado lo xtu men, natsakt más lo xa' nile' mandad xa'.” Chi ngurukë bixa' ticha par zakzi bixa' da, nu ska kun go le' bixa'i; no chi mile' bixa' kwa'n nzhapa, nu ska kwa'n gab go le' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Rë kure' le' bixa' kun go, por nak go men da, porke gat nilibe't bixa', Me mixë'l da. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Chi ngayila bixa' da or nzhapa, na Me mixë'l Dios, orze' nangazë'bxkit bixa' lo Dios. Per por nangayila bixa' da, kuze', gaktra' ka'ch bixa', lë' bixa' nzë'b xki lo Dios; ");
INSERT INTO zcaNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","no rë xa' niyi' nine da, nu ska Xuza niyi' bixa' nine bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Yent cho dol ngap bixa' chi nangane bixa' ngalen ni tu rë zhi'n nazhon kwa'n niyent cho gat le' xid bixa'. Per une bixa'i, no lë'la niyi' bixa' nine bixa' da no Xuza. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Se' ka nak bixa' par ngok widi'zh kwa'n nzobni' lo ley che'n bixa' kwa'n nzhab: “Yent por kwan niyi' bixa' nine bixa' da.” ");
INSERT INTO zcaNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Per or yi'd Sprit che'n Dios, Me xëla par gaknu go, lë' Me di'zh cho nak da. Lo Xuza ro' Sprit re', no pura che'n Dios di'zh Sprit re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","No nu ska go di'zh cho da, porke dizde or nguzublon kilun widi'zh che'n Dios, nzo go kuda. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Lë'ga naga zakzi go, ni ga' da rë kure' lo go por nak go men da, nes par or zhin rë kure' lo go, naye zo go lo kwa'n ngwayila go da, ");
INSERT INTO zcaNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","porke lë' zhë zhin, lë' bixa' ko'tin go le'n plo nibin go nitse'd go widi'zh che'n Dios; no zhin zhë, lë' bixa' gut go, gab bixa' por kuze' zak laxto' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Se' le'nu bixa' go, por gat nilibe' bixa' Xuza no na. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kure' nin lo go, par or gak rë kure', orze' tsila go, lë'da ni lai lo go. ’Nanganita kure' lo go or galo, lë'da nzo ka kun go; ");
INSERT INTO zcaNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","nal, lë'da bi' la lo Xuza, Me mixë'l da yizhyuo re'; per yent cho ngane lon: “¿Plo bi go?”, ");
INSERT INTO zcaNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","lë'la miwin laxto' go por mbin go kure'. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Per walika kwa'n nin re'; más wen ya go chi bi'n. No chi nabi'n, nayi'dt Sprit che'n Dios lo go, Me gaknu go lo rë kwa'n. Chi lë'da bi', lë'da xël Me par yo Me laxto' go. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Or yi'd Sprit che'n Dios lo rë men yizhyuo re', lë' Me kobe' (wi') cho nzhap dol, no cho yent kwan nak, mbaino gab Sprit che'n Dios xmod gak kun xa' nzhap dol ze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Rë xa' gat ñila da, xa' ze' nzë'b xki lo Dios; ");
INSERT INTO zcaNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","per da gat nzë'b xkita, kuze' lë'da bi' plo nzho Xuza, no nanetra' go da. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","No xa' nzhap dol ze', xa' nile' mandad yizhyuo re', lë' xa' kix rë kwa'n nak xa', kuze' nayotra' le' xa' mandad yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Dox kwa'n nzhora' ganin lo go, per xekt go gon goi rëi nal re', ");
INSERT INTO zcaNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","per or yi'd Sprit che'n Dios, lë' Me lu' lo go, rë kwa'n nzhakla Dios gon go. Gat nidi'zht Sprit che'n Dios kwa'n xigab yek Me, lë' Me nidi'zh nab tsa kwa'n nzhakla Xuza Dios, par di'zh Me lo go rë kwa'n naga gak. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Lë' Sprit che'n Dios le', di'zh men da wen, porke lë' Me ka' rë cheda par lu' Mei lo go. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Rë che'n Xuza nak cheda; kuze' midi'zha lo go, lë' Sprit che'n Dios ka' rë cheda par lu' Me xmod nake lo go. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Xche'ptsa nanetra' go da, lë't ne go da xche'p. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Orze' nzhab pla rë men che'n Jesús lo wech bixa': ―¿Kwan gab widi'zh re' kwa'n ne Jesús lo be: “Xche'ptsa nanetra' go da, lë't ne go da xche'p”, mbaino, “Lë'da bi' lo Xuza”? ");
INSERT INTO zcaNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Kwan gab widi'zh kwa'n ne xa': “Kaxche'p”, re'? Nazobyekt be kure'. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","No nane Jesús, lë' bixa' nzhakla na'bdi'zh lo Me por kwa'n midi'zh Me ze', orze' nzhab Me: ―¿Chi nzhakla go gon go kwan gab kwa'n nin lo go ze'? ¿Chi kuba' kina'bdi'zh go lo wech go? ");
INSERT INTO zcaNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kwa'n nanen, lë' go go'n, no win laxto' go, no lë' rë men yizhyuo zak laxto'; per lë' yalnawin kwa'n zak go ba', lë'i gak yalnizak laxto' go. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Tu una' or gal xin una', kun yalne nzhap una' më'd; per or ngol la më'd, di nizak laxto' xa' ña'l laxto' xa' yalne ze' por niwi' xa' lo më'd. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Se' ska go nal re', nzho yalnawin laxto' go, per or yala lo go xtu wëlt, orze' lë' go zak laxto' ne go da, no yalnizak laxto' go re', yent cho kubchiy lo go. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","No rë zhë ze', yentra' kwan na'b go lon. Walika kwa'n nin lo go re', lë' Xuza Dios ne' rë kwa'n na'b go lo Me, por nak go men da. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Haxta nal, nagat na'b go lo Me por lën; nal bina'b goi par zhine lo go, nes par zak laxto' go. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Lë'da midi'zh kure' lo go nela xmod nak tu kwa'n ga', per zhin zhë ya nadizhtra' se' lo go, tuli ganin xmod nak rë che'n Xuza lo go. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Zhë ze' gat naki'ntra' na'ba tu kwa'n lo Xuza por go; yub go na'be lo Me por nak go men da, ");
INSERT INTO zcaNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","porke yub Xuza nazhi' go, no por nazhi' go da, kuze' nazhi' Xuza go, no por ñila go, lë' Me mixë'l da. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nzhala lo yizhyuo re', lë' Xuza mixë'l da; nal lë'da la ska yizhyuo re' par ña ska lo Xuza. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Orze' nzhab rë men che'n Jesús lo Me: ―Nalse tuli ne goi lo no, gat kidi'zht goi xtu mod; ");
INSERT INTO zcaNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","nalse nane no, gat naki'ntra' na'bdi'zh no tu kwa'n lo go, porke rëi nane la go; kuze' ñila no, lë' Dios mixë'l go yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Orze' nzhab Jesús: ―¿Haxta nalse ngwayila go da? ");
INSERT INTO zcaNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Lë' or ngol la, lë' rë go re'chbe, la' nzë'b go da; per naya'nta' naba, lë' Xuza nzo ka kuda. ");
INSERT INTO zcaNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nin kure' lo go par zi go chul, porke lë' go nak tutsa kuda. Lo yizhyuo re', lë' go ded lo rë kwa'n gat lë', per nazhebt go, na mile' la gan lo rë kwa'n gat lë' nzho yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","No or milox midi'zh Jesús rë widi'zh re', orze' miwi' Me lo yibë' no nzhab Me: ―Payë', lë' or ngol la: Nalse bilu' Go lo rë men tugaka Xga'n go kinu yalnazhon, par lu' Xga'n go lo rë men, Go gaka kinu yalnazhon. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Go mizo Da par gapa kwan ñal le' rë men, mbaino par zan yalnaban par dubta' ka' rë men, xa' ngule Go gak men Da. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kure' nak ban men par dubta'; libe' men, Go gaka nak Dios, mbaino na, nak Jesukrist, Me mixë'l Go lo yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Por milen rë kwa'n ne Go yizhyuo re', kuze' milun lo rë men, tugaka Go Dios nazhon. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Payë', nalse bilu' Go lo rë men, tugaka Xga'n Go kinu yalnazhon tutsa kun Go, yalnazhon kwa'n kinu be or ni naga zuxkwa' yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Lë'da milu xmod nak Go lo rë men xa' mine' Go nak men Da lo yizhyuo re'; men che'n Go bixa' mbaino mine' Go bixa' gak men da, no nile' bixa' rë kwa'n ne Go. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nal une bixa' lë' rë kwa'n kinun, Go mine'i; ");
INSERT INTO zcaNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","porke milun lo bixa' rë widi'zh kwa'n ne Go lon. No por une bixa', walika Go mixë'l Da, kuze' ngwayila bixa' Da. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Nal kina'ba lo Go por lë' bixa'; gat nina'bta por rë men yizhyuo re', sino por nab tsa rë xa' mine' Go gak men Da, porke men che'n Go bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Rë kwa'n kinun nak che'n Go, no rë che'n Go nak chedaska; no nilu' xmod nak yalnazhon da por rë men da re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Nal ya nazotra' más yizhyuo re', per lë' bixa' kwin ra' lo yizhyuo re'. No dub yala lo Go Payë', Go gaka Me Nazhon, bikina Go bixa' kun yalnazhon che'n Go, kun mis yalnazhon che'n Go kwa'n mine' Go unkan, par kwin bixa' tutsa nela Go no na ga'. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Dub di nguzon kun lë' bixa' yizhyuo re', mikinan bixa' kun mis yalnazhon che'n Go kwa'n mine' Go unkan, no ni tu bixa' nangaro't nez che'n Go, sino nab tsa xa', xa' nak la di'zh lox lo Dios, milox; nes ngok rë kwa'n nzobni' lo Yech che'n Go. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’No nal, lë'da yal ska lo Go, no nin rë kure' dub nzon yizhyuo re', par se' dubta' zak laxto' rë men da, nela xmod nizak laxto'n ga'. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Na milu widi'zh che'n Go lo rë men Da re', kuze' niyi' men yizhyuo nine bixa', porke gat nikizëtra' bixa' nela más rë men yizhyuo, nela Da, gat nileta kwa'n nile' men yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Gat kina'bta' lo Go, ko' Go bixa' yizhyuo re'; kwa'n kina'ba kina Go bixa' lo Mizhab. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","No nela Da gat lë't xa' yizhyuo Da, se'ska lë' bixa' gat lë't men yizhyuo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Bile' Go gak bixa' nab tsa par Go kun widi'zh che'n Go kwa'n milun lo bixa'; lë' widi'zh che'n Go nilu' xmod nak Go. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nela mixë'l Go da lo rë men yizhyuo, se'ska nixëla bixa' xid más rë men yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Dub Da minen par len nab tsa zhi'n nazhon che'n Go, nes par nab tsa rë zhi'n nazhon che'n Go le' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","No gat kina'bta' nab tsa por rë men da re'; lë'da kina'b lo Go por rë xa' laore yila widi'zh da por rë men da re', ");
INSERT INTO zcaNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","par gak bixa' tutsa. Payë', kina'ba par rë bixa' gak tutsa kun be, nela Go kun na ga' nak be tutsa. Nzhaklan gak bixa' tutsa, par se' yila rë men yizhyuo, lë' Go mixë'l da yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Na miza yalnazhon kwa'n mine' Go unkan, par nka' bixa', par gak bixa' tutsa men, nela nak da kun Go ga'; ");
INSERT INTO zcaNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","na kun lë' bixa', no Go kun na, par se' gak bixa' tutsa, no se' ne rë men yizhyuo, lë' Go mixë'l da yizhyuo re', no nazhi' Go bixa' nela nazhi' Go da ga'. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Payë', Go mine' bixa' gak men Da, no kina'ba yo bixa' lomis plo yo'n, par ne bixa' yalnazhon kwa'n mine' Go unkan, porke nazhi' Go da dizde or ni naga yuxkwa' yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Payë', Go nile' rë kwa'n nali; men yizhyuo, gat nilibe't bixa' Go, per na nilibe'ka Go, no nu rë xa' mine' Go gak men Da, lë' bixa' nane ka, Go mixë'l da. ");
INSERT INTO zcaNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Lë'da mile la, milibe' bixa' cho Go, no lë'i le ra', par chizhi' bixa' más men nela nazhi' Go da ga', no nu par ban bixa' tutsa kun xigab kwa'n kinun. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","No or milox midi'zh Jesús rë widi'zh re', orze' nguro' Me kun rë men che'n Me par nzha bixa', nded bixa' xtu ro' yux kwa'n lë Cedrón. Ze' nzhi'b tu bëd ya kwa'n lë olib, ze' mia'n bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","No Judas, xa' chi Jesús lo rë men Israel xa' nak zhi'n, nane xa' plo nzhi'b rë ya ze', porke ze' nayax wëlt nzhaya Jesús kun rë men che'n Me par nibin bixa' ze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Orze', ze' mizhin Judas kun tu bëd sondad román, kun zipla xa' nikina yado'; rë men re' nzë ze' por mandad che'n rë ngulëi' xa' nile' mandad lo más rë ngulëi', no por mandad che'n rë men fariseo. Nzhanu bixa' kwa'n nizini lo bixa' mbaino kun rë bël yer, no nu nzhanu bixa' kwa'n dil bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Per lë' Jesús nane la rë kwa'n gak, orze' mina'bdi'zh Me lo rë men ze', nzhab Me: ―¿Cho kikwa'n go? ");
INSERT INTO zcaNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Mikab rë men ze': ―Lë' Jesús xa' nzë yezh Nazarete. Lë'chi nzhab Jesús: ―Na xa' ze'. Mbaino nu Judas xa' chi Jesús lo rë men ze', nzho xid rë xa' re', ");
INSERT INTO zcaNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","no or nzhab Jesús: “Nai”, no orze' lwega' miëk bixa' al tich bixa', no ngwachin bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Orze' xtu wëlt nzhab Jesús lo bixa': ―¿Cho kikwa'n go? Mikab rë men ze': ―Jesús xa' nzë yezh Nazarete. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Per nzhab Jesús lo bixa': ―Lë'da ni lai lo go, nai. Lë'i na kikwa'n go; bila' go bi rë men re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Rë kure' ngok nes ngok rë widi'zh kwa'n midi'zh Jesús, or nzhab Me lo Xuz Me: “Rë xa' mine' Go gak men da, ni tu bixa' nangaro't nez che'n Go.” ");
INSERT INTO zcaNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","No lë' Simón Per kinu tu spad, orze' ngulo' xa'i, no micho' xa' tu lad direch nzha tu xa' lë Malco, mos che'n ngulëi' ro, ");
INSERT INTO zcaNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","orze' nzhab Jesús lo Per: —Guluchao' spad ba' plo nzhoi; no chi lë' Xuza nzhakla de'da lo kwa'n nazhe'b re', lë'i de'da. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","No lë' rë sondad, kun xa' nile' mandad lo bixa', mbaino kun rë xa' nikina yado', nguzen bixa' Jesús, mili'b bixa' Me, ");
INSERT INTO zcaNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","orze' mbi'y bixa' Jesús galo laka lo Anás, xa' nak xa'zha'p Caifás, xa' nak ngulëi' ro le'n li'n ze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nzhab xa' lë Caifás re' lo rë men Israel, más wen gat tutsa miyi' re' ke par gat dub yezh men. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Lë' Simón Per kun xtu men che'n Jesús, nzhakë bixa' tich Jesús, no lë' xtu men che'n Jesús ze', nilibe' ngulëi' ro xa', kuze' ngok nguio xa' re' lo luwe che'n ngulëi' ro, plo ñanu men Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","no lë' Per mia'n al tich, gax ro' pwert; per men che'n Jesús xa' nilibe' ngulëi' ro ze', midi'zhnu xa' re' xa' nikina ro' pwert, par mila' xa' nguio Per. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Orze' mina'bdi'zh una' kwa'n nikina ro' puert ze' lo Per, nzhab una': ―¿Chi gat nutal nak tu rë men che'n miyi' ba'? Mikab Per: ―A'a, gat nut da. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","No ze' nzo pla rë mos che'n ngulëi' ro kun rë xa' nikina yado', kizo'l bixa' tu ki por dox nayag, par kichë' bixa'; orze' nu Per nguzubi, kichë' xid rë xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Orze' nguzublo kina'bdi'zh Anás lo Jesús, kwan nak rë men che'n Me, mbaino xkwan nilu' Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Unkab Jesús: ―Midi'zha lo rë nak men, no zilita' milune le'n rë yo' plo nibin rë men Israel, par nitse'd bixa' widi'zh che'n Dios, no haxta le'n yado' milune; nangalutne xla'n. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Chon kinabdi'zh go lon? Bina'bdi'zh go lo rë xa' mbin rë kwa'n midizha, no lë' bixa' ne lo go kwan milun lo bixa', porke lë' bixa' mbine. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","No or milox midi'zh Jesús kure', orze' mikë' tu xa' nikina yado' ze' tube ro' Me, no nzhab xa': ―¿Chi sa' kabal lo xa' nak ngulëi' ro ba'? ");
INSERT INTO zcaNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Unkab Jesús: ―Chi midizha tu widi'zh kwa'n gat ñal dizha, bine go kwane; per chi midizha kwa'n ñal ka dizha, ¿chon mikë' goi ro'n? ");
INSERT INTO zcaNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Orze' mixë'l Anás Jesús nali'b do' Me lo Caifás, xa' mer ngulëi' ro. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Stubi nzo Simón Per ze', kichë' xa', lë'chi mina'bdi'zh rë xa' ze' lo Per, nzhab bixa': ―¿Chi gat nutal nak tu rë men che'n miyi' ba'? Unkab Per: ―A'a, gat nut da. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Lwega' mina'bdi'zh tu mis rë mos che'n ngulëi' ro, tu mos kwa'n nak melizh Malco, xa' micho' Per nzha ze', nzhab xa': ―¡Lë'i lu ka unen nikizë kun mbe ba', plo nzhi'b ya olib! ");
INSERT INTO zcaNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Orze' xtu wëlt nzhab Per: ―¡Gat lë't nai! Lë'chi mikë' nguid gai kant. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","No di lizh Caifás, ze' ñanu bixa' Jesús par yalao plo nzob gobiernador, no ya nzhanilyuo la orze'; per nangayot rë men Israel le'n yalao, porke nayi'y nzhab ley che'n bixa', napa' nagakt gao bixa' lani Pask ze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kuze' nguro' Pilat al tich par mina'bdi'zh xa' lo rë men ze', nzhab xa': ―¿Kwan nzhab go nak xa' re'? ");
INSERT INTO zcaNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Orze' nzhab rë men ze': ―No chi yent kwan nak xa', nangayi'dnut no xa' lo go. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Per nzhab Pilat: ―Bi'y mis yub go xa', par kube' go kwan ñal xa', nela xmod nzhab ley che'n go. Orze' nzhab rë men xa' nzo lo rë men Israel ze': ―¡Lo ley che'n go, nagakt gut no ni tu men! ");
INSERT INTO zcaNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Sa' midi'zh bixa' par ngok rë widi'zh kwa'n midi'zh Jesús xmod gat Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Orze' ña ska Pilat le'n yalao xtu wëlt, par ngurezh xa' Jesús, nzhab xa' lo Me: ―¿Chi walika lu nak rey che'n rë men Israel? ");
INSERT INTO zcaNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Unkab Jesús: ―¿Chi mis lu kina'bdi'zh kuba', o nzho cho xtu men nei lol? ");
INSERT INTO zcaNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Orze' nzhab Pilat: ―¿Chi nu da nak tu men Israelx par nel kuba' lon? Men lazhal kun rë ngulëi' xa' nile' mandad lo más ngulëi'; lë' rë xa' re' nzadnul lon. ¿Kwan mile'lx? ");
INSERT INTO zcaNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nkab Jesús: ―Yalgobier da gat lë't kwa'n yizhyuo re'i; no chi ngake kwa'n yizhyuo re', orze' lë' rë men da ngadil par nangazen rë men Israel da, per yalgobier kwa'n kinun, gat lë't kwa're'i. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Orze' nzhab Pilat: ―Ah, ¿chi reyal orze'? Unkab Jesús: ―Lu ne, lë'da rey; lë'da ngol par nzhala yizhyuo re', no par dizha kwa'n wali. No rë xa' nzhon widi'zh wali kwa'n nidizha, orze' nile' bixa' kwa'n nzhapa. ");
INSERT INTO zcaNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Per nzhab Pilat: ―¿Cho ka ne kwa'n walix? No or milox midi'zh Pilat widi'zh re', nguro' xa' xtu wëlt par midi'zh xa' lo rë men Israel, nzhab xa': ―Na ngurël, yent kwan nak miyi' re', ");
INSERT INTO zcaNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","per go kinu kostumbr, nina'b go, niliyan tu men nzho lizhyi'b, dub nzhak lani Pask. ¿Cho nzhakla go liyan? ¿Chi liyan rey che'n rë men Israel? ");
INSERT INTO zcaNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Lë'chi rë bixa' nguruzhië: ―¡Naliya't go miyi' ba'! ¡Más wen biliya' go Barrabás! No ter nak Barrabás tu xa' nichëldil men kun gubier. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Orze' mile' Pilat mandad, ndin bixa' Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","no mizuxkwa' rë sondad ze' tu koron yich, mbaino mizo'b xa'i yek Jesús, mbaino mixo'b bixa' tu kap kulor yind tich Jesús, nela nile' men kun tu rey ga', ");
INSERT INTO zcaNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","orze' nguzubi bixa' lo Jesús par nzhab bixa': ―¡Rey che'n rë men Israel, par dubta' banal! Mbaino mikë' bixa'i ro' Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Xtu wëlt nguro' Pilat al tich, lo rë men Israel xa' nzhin ze', par nzhab xa': ―Biwi' go, lë'da zo xa' lo go par ne goi, na ngurël, yent kwan nak miyi' re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Orze' nguro' Jesús lo rë men ze', nzob koron yich ze' yek Me, mbaino nzho'b kap yind ze' tich Me, orze' nzhab Pilat: ―¡Biwi'u! ¡Lë' miyi' re' re'! ");
INSERT INTO zcaNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","No or une rë ngulëi' ro ze' Jesús, kun rë xa' nikina yado', nguzublo nguruzhië bixa': ―¡Bikë'u xa' lo krus! ¡Bikë'u xa' lo krus! Orze' nzhab Pilat: ―Bi'y go xa', no go bikë' xa' lo krus; na ngurël, yent kwan nak xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Per nzhab rë men Israel ze' lo Pilat: ―¡Lo ley che'n no nidi'zh, ñal gat xa', porke lë' xa' nidi'zh, Xga'n Dios xa'! ");
INSERT INTO zcaNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Or mbin Pilat kure', más mizheb xa'; ");
INSERT INTO zcaNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","nguio xa' xtu wëlt le'n yalao par xtu wëlt mina'bdi'zh xa' lo Jesús, nzhab xa': ―¿Plo ka nzël? Per nangakabt Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","orze' nzhab Pilat: ―¿Chon gat nikabal lon? ¿Chi nanetal, na gak le mandad kël lo krus, mbaino gak len mandad, liya' bixa' lu? ");
INSERT INTO zcaNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Per nzhab Jesús: ―Nagakt le'l ni tu yalgustis kun na chi lë' Dios naziyël; xa' michi da lol, más nzë'b xki xa' ze' ke lu. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","No dizde orze', mikwa'n Pilat mod par ngaliya' xa' Jesús, per lë' rë men Israel más naye nguruzhië bixa' lo Pilat: ―¡Chi lë'l liya' miyi' ba', nagaktal xa' kwa'n nichë'l César, porke rë men xa' gak rey, chi gat lë't César kubi xa', xa' ze' nak xa' nidil kun César! ");
INSERT INTO zcaNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","No or mbin Pilat kure', nguro' xa' kun Jesús al tich no nguzob xa' plo nile' xa' yalgustis, plo lë kun widi'zh grieg, Enlosado, no lë' kun widi'zh hebreo lëi, Gabata (kun xtu widi'zh kure' gab, Plo Nax Ke Wen). ");
INSERT INTO zcaNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Lë' zhë ze' nak zhë kwa'n nizuxkwa' men kwa'n par lani Pask, no pas mer garol zhë orze', lë'chi ngwayab Pilat lo rë men Israel ze': ―¡Biwi' go, lë' rey che'n go re'! ");
INSERT INTO zcaNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Orze' naye nguruzhië bixa': ―¡Gulutin go xa' ba'! ¡Gulutin go xa' ba'! ¡Bikë' go xa' lo krus! Per nzhab Pilat: ―¿Taxa kë'n rey che'n go lo krus? Orze' nzhab rë kwa'n nak ngulëi' ro ze': ―¡Yentra' cho xtu rey kinu no, nab tsa César! ");
INSERT INTO zcaNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Mbaino michi Pilat Jesús lo bixa', par kë' bixa' Jesús lo krus, orze' ñanu bixa' Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","No mile' bixa' mis Jesús mbi'y krus che'n Me yën Me, par nzhanu bixa' Jesús plo lë Kalaber (kun widi'zh hebreo lëi Gólgota), ");
INSERT INTO zcaNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ze' mikë' bixa' Jesús lo krus, no nu xchop men mikë' bixa' lo krus; tu ga' xa' kad lad che'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","No yek krus che'n Jesús, mile' Pilat mandad nkë widi'zh kwa'n nzhab se': “Jesús xa' nzë yezh Nazaret, rey che'n rë men Israel.” ");
INSERT INTO zcaNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nayax men Israel mbi'l widi'zh re', porke plo mikë' bixa' Jesús lo krus, gax ña'ne par yezh Jerusalén, no rë widi'zh ze' nzobni'y kun widi'zh hebreo, no kun widi'zh latín, mbaino kun widi'zh grieg. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","No por kure' nzhab rë ngulëi' ro che'n rë men Israel lo Pilat: ―Nakë'tal sa': “Xa' re' nak rey che'n rë men Israel”, neka bizob: “Xa' re' nidi'zh, nak xa' rey lo rë men Israel.” ");
INSERT INTO zcaNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Per nzhab Pilat: ―Kwa'n mikë'n, sa' ya'ne. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","No or milox mikë' rë sondad Jesús lo krus, orze' mia'n bixa' kun xab Jesús kwa'n al tich, mile' bixa'i tap lë' par tlë'gai' nka' bixa'; no nu xab Jesús kwa'n al le'n, lë túnica, nguzen bixa'i, no lë'i gat nadibt, tutsa lë' nakxao' lar ze', ");
INSERT INTO zcaNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","orze' nzhab rë sondad ze' lo wech bixa': ―Nachëzt be lar re'; neka kit be par ne be, cho ya'n kun lë'i, Sa' mile' bixa' par ngok rë widi'zh kwa'n nzobni' lo Yech che'n Dios plo nzobni': Michëz bixa' xaba par mia'n bixa' kun lë'i, no nguzhit bixa' par mia'n bixa' kun túnica da. Kure' mile' rë sondad, ");
INSERT INTO zcaNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","per xan krus plo nikë Jesús, nzo xna' Me mbaino nzo bël xna' Me, no nzo Mari tsa' Cleofas, no nu Mari Madalén nzo ze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kuze', or une Me xna' Me, nzo xna' Me gax laka kun tu rë men che'n Me xa' más nichë'l Me, orze' nzhab Me lo xna' Me: ―Una', lë' xga'nal ba'. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Mbaino lo xa' ze' nzhab Me: ―Lë' xna'l ba'. No dizde orze' mbi'y xa' ze', xna' Me lizh xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","No or milox rë kure', lë' Jesús ya nane la, lë' rëi ngok la, no nes par lox gak rë widi'zh che'n Dios kwa'n nzobni' por lë' Me, kuze' nzhab Jesús: ―Nizëi' laxto'n. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","No ze' nzo tu jar nits gub ni, orze' yek tu ram ya kwa'n lë hisopo, michël bixa' tlë' lar xi'l, orze' mikë bixa' kure' le'n jar re', no michi bixa'i ro' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Or milox ngu' Jesús kure', orze' nzhab Me: ―Lë' rëi milox la ngok. Orze' mirek Me lo yuo, miza' Me alm che'n Me lo Xuz Me Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Lë' zhë ze' nak zhë kwa'n nizuxkwa' men kwa'n par lani Pask, per lë' rë xa' nak zhi'n lo rë men Israel, gat nzhaklat bixa' ya'n kwerp che'n Jesús, mbaino kwerp che'n xchop rë miyi' ze' lo krus, mer zhë kwa'n gal lani ze', porke zhë ze' nak zhë más tsak par rë men Israel. Kuze' mina'b bixa' lo Pilat, par ki'ch bixa' ni' rë xa' nikë lo krus ze', nes par gat ga' bixa', no la ga' bixa' lo krus mis zhë ze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Orze' ngwa rë sondad par ndi'ch bixa' ni' galo laka xa' kwa'n nkë lo krus ta' Jesús, no sa' ska mile' bixa' kun xtu xa' kwa'n nkë xtu lad ta' Jesús, ");
INSERT INTO zcaNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","per or nguzubi bixa' plo nikë Jesús, une bixa', lë' Jesús ngut la. Kuze' nangayi'cht bixa' ni' Me, ");
INSERT INTO zcaNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","per tu rë sondad ze' ndid tu lans ta' koxti che'n Jesús, orze' lwega' nguro' ren kun nits plo ndid xa' kure'. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","No xa' midi'zh kure', lë' xa' une loi, no walika kwa'n une xa' no kwa'n nidi'zh xa', nes par nu go, yilai. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Se' ngok nes par ngok widi'zh re' kwa'n nzobni' lo Yech che'n Dios kwa'n nzhab se': “Ni tu wes che'n Me nangacht.” ");
INSERT INTO zcaNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","No xtu plo se' nzobni': “Une men or nguzhid bixa' kun lans ta' Me.” ");
INSERT INTO zcaNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Or milox ngok kure', orze' ngwa Che xa' nak tu men yezh Arimatea lo Pilat par mina'b xa' lo Pilat, wei' xa' kwerp che'n Jesús, mbaino nguziyël Pilat. No Che re' nak tu men che'n Jesús, per yent cho lo nzhabt xa'i por nizheb xa' lo rë xa' nak zhi'n lo rë men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","No nu Nicodemo xa' ngwadi'zhnu Jesús tu or yë'l, nzhanu xa' kwa'n nixla' nax mbaino noche kun mirra mbaino áloe; no naga'i nzhi'bra' gal bichi' kil. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Orze' Che kun Nicodemo mila bixa' kwerp che'n Jesús, no michël bixa' lare, mbaino ngulo bixa' kwa'n nixla' nax ze' kwerp che'n Me. Se' nile' rë men Israel or nika'ch bixa' men. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","No plo mikë' bixa' Jesús lo krus, nzhi'b tu bëd ya, no ze' nakxao' tu ba' plo ni tu men nagat ga'ch. ");
INSERT INTO zcaNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ze' mika'ch bixa' Jesús, porke ña'ne gax laka plo nkë Me lo krus, mbaino nu mizhin gax la lani che'n rë men Israel, kuze' nayen laka mika'ch bixa' Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","No zhë galo laka che'n sman, dox garzi'l, nakao ra' ngwa Mari Madalen ro' ba' plo miga'ch Jesús, orze' une xa', lë' ke kwa'n nayao' ro' ba', nax la tu lad. ");
INSERT INTO zcaNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Orze' karre miëk una' plo nzho Simón Per kun xtu men che'n Jesús xa' más nichë'l Me, nzhab una': ―¡Pas nzho cho ngulo' kwerp che'n Señor che'n be le'n ba', no ñanu xa'i, mbaino yent cho nane plo ñanu xa'i! ");
INSERT INTO zcaNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Orze' nzhatswi' Per kun xtu xa' nak men che'n Jesús ze' ro' ba'. ");
INSERT INTO zcaNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Karre nzha rop bixa' ro' ba', per galo laka xa' ze' mizhin ro' ba' lo Per. ");
INSERT INTO zcaNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Orze' ndixni xa' le'n ba', une xa' nax nab tsa lar kwa'n ngurël Jesús ze', per nangayot xa' le'n ba'. ");
INSERT INTO zcaNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","No gax tich xa' re' mizhin Simón Per, no tuli nguio Per le'n ba', orze' une xa' nab tsa lar ze' nax, ");
INSERT INTO zcaNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","no nu une xa', lar kwa'n ngurël yek Jesús or miga'ch Me, naxtsai tu lad, chul laka nayë'che gax plo nax lar kwa'n ngurël Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Orze' nu xa' kwa'n mizhin galo laka ze' nguio le'n ba'. Or une xa' rë kure', ngwayila xa'i. ");
INSERT INTO zcaNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ter nzobni' lo Yech che'n Dios, lë' Jesús naki'n ruban, per nagat zobyek bixa' kure'. ");
INSERT INTO zcaNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Orze' ña rë men che'n Me ze' par lizh bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","No lë' Mari mia'n ro' ba', kiyo'n xa'; no dub kiyo'n xa', ndixni xa' le'n ba', ");
INSERT INTO zcaNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","orze' une xa', chop ganj nak lar bëo laka; tu xa' nzob plo una yek Jesús, mbaino xtu xa' nzob plo una ni' Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Lë'chi minabdi'zh rop ganj re' lo Mari, nzhab bixa': ―Una', ¿chon kiyo'nal? Unkab Mari: ―Kiyona porke naneta cho ñanu kwerp che'p Señor da, no naneta plo ngwala' bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","No laore milox midi'zh Mari kure', lë'chi miëk xa' al tich xa', no une xa', lë' Jesús nzo ze', per nangalibe't xa' chi Jesuze, ");
INSERT INTO zcaNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","orze' nzhab Jesús lo xa': ―Una', ¿chon kiyo'nal? ¿Cho kikwa'nal? Per lë' Mari mile' xigab, xa' nikina rë ya nzhi'b ze' xa' re', kuze' nzhab Mari lo xa' re': ―Lë' go, chi go mbi'y kwerp che'n Señor da, bineu plo ngwala' goi, par yakane. ");
INSERT INTO zcaNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Lë'chi nzhab Jesús: ―¡Mari! Orze' miëk Mari, milibe' Mari Jesuze, no kun widi'zh hebreo midi'zh Mari: ―¡Rabuni! (widi'zh kwa'n gab Maestr). ");
INSERT INTO zcaNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Orze' nzhab Jesús: ―Nazenta'l da, porke lë'da laore bi' plo nzho Xuza, per bizë no guzhe lo rë men da, lë'da bi' plo nzho Xuza, Me nak ska Xuz go; lo Dios da, Me nak ska Dios che'n go. ");
INSERT INTO zcaNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Orze' ngwayab Mari Madalene lo más rë men che'n Jesús, nzhab xa', lë' xa' une Jesús, mbaino nzhab xa' rë kwa'n nzhab Jesús lo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","No mis zhë ze', or mizhël la lyuo, zhë galo laka che'n sman, nzhin rë men che'n Jesús le'n yo', naye nayao' ro'i por nizheb bixa' lo rë men Israel, xa' nak zhi'n. Lë'chi nguio Jesús ze' plo nzhin rë men che'n Me, no nguzo Me garol sao' plo nzhin bixa', no nzhab Me: ―¡Dios le' ya go wen! ");
INSERT INTO zcaNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","No or midi'zh Me kure', orze' milu' Me ya' Me plo nguzob rë klab ze', no ta' laxto' Me plo ndid xa' lans, orze' dox nizak laxto' rë men che'n Me or une bixa' Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kuze' xtu wëlt nzhab Jesús: ―¡Dios le' ya go wen! Mbaino nela mixë'l Xuza da, se'ska xëla go. ");
INSERT INTO zcaNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Orze' milabi Me lo rë men che'n Me, no nzhab Me: ―Yo Sprit che'n Dios laxto' go, ");
INSERT INTO zcaNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","nes par or gab go, gat nzë'bxkitra' tu men, orze' Dios miche' la rë kwa'n nzë'b xki xa' re'; per rë xa' kwa'n gab go, nache't Dios kwa'n nzë'b xki xa', orze' sa' ka gake. ");
INSERT INTO zcaNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Lë' Max nak tu xa' nzho xid dub tu dusen men che'n Jesús, no nu nzhab men lë xa': “Xa' kwach”, no gat nzot Max kun lë' bixa' or ngurulo Me lo bixa', ");
INSERT INTO zcaNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","kuze' nzhab bixa' lo Max: ―Lë'no une Señor che'n be. Per unkab Max: ―Chi nanen plo ngwa klab ya' Me, no chi nakon bikwen ya'n ze', mbaino chi nayo ya'n plo ndid xa' lans, nayilatne. ");
INSERT INTO zcaNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Or nded xon ngubizh, xtu wëlt migan rë men che'n Jesús le'n yo' ze', orze' nu Max nzho xid bixa', no naye nayao' ro' yo', orze' nguio Jesús ze', no nguzo Me garol sao' plo nzhin bixa', orze' nzhab Me lo bixa': ―¡Dios le' ya go wen! ");
INSERT INTO zcaNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tuli ka nzhab Jesús lo Max: ―Di'nu bikwen ya'l re', no biwi' ya'n; no di'nu ya'l ta' laxto'n re'. Nagaktra'l tu xa' nen par yilai, sino gok tu xa' ñila da. ");
INSERT INTO zcaNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Mikab Max orze': ―¡Go nak Señor da, mbaino Dios da! ");
INSERT INTO zcaNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Nzhab Jesús: ―Por unel rë kure', ngwayilal da. Per rë xa' ñila da ter gat ne xa' da, orze' nazhon nzha rë xa' re' kun Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Dilant lo rë men che'n Me, nayax ra' kwa'n nazhon mile' Jesús kwa'n gat zobni't lo yech re', ");
INSERT INTO zcaNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","per rë kwa'n nzobni' lo yech re', lë'i nzobni' par yila go, lë' Jesús nak Krist, Xga'n Dios; no por yila go Me, lë' go ban par dubta' kun Dios. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nzha pla ra' ngubizh di ngok rë kure', ngurulo Jesús xtu wëlt lo rë men che'n Me, plo nikë lagún kwa'n ña'n lazh men Tiberias. Se' ngurulo Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Rë nak rë xa' re' nzhin: Simón Per, no Max xa' nzhab men lë Kwach, kun Natanael xa' nzë yezh Caná kwa'n ña'n lazh men Galilea, no nu rop xga'n Zebedeo kun xchop rë men che'n Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Nzhab Simón Per lo bixa': ―Lë'da nzhatsen mbël. Unkab rë xa' ze': ―Nu no ya kun lu. Orze' nzha bixa' le'n tu bark, per yë'l ze', ni tu mbël nangazent bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","No ya nzënilyuo la, lë'chi ro' lagun ze' ngurulo Jesús, per nangalibe't rë men che'n Me chi lë' Mei. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Mina'bdi'zh Jesús lo bixa', nzhab Me: ―Lë' go xga'n, ¿chi nagat zen go ni tu mbël? Unkab bixa': ―Ni tu ma. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Orze' nzhab Jesús: ―Gulubiu yex lad direch ta' bark, lë' go zen ma. Sa' mile' bixa', no haxta ni naxekt bixa' ngago' bixa' yex mbël ze' le'n nits por dox zhëi di mbël. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Orze' tu men che'n Jesús xa' más nichë'l Jesús, nzhab xa' lo Per: ―¡Lë'la Señor che'n be xa' ba'! No or mbin Simón Per, lë'i Jesús, tuli ngok xa' xab xa' kwa'n ngulo' xa' par unkë xa' zhi'n, tuli ngula xa' le'n nits, nzha xa' lo Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","No zipla rë men che'n Me, ñë'd bixa' le'n bark, kizubxax bixa' yex kwa'n zhë di mbël, no plo ñë'd bixa' par ro' yuo bizh, nzhoi pas tu gayo' metr. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","No or ngula bixa' bark ze', une bixa', nzhin la ki ze', no kiyay mbël loi no pan. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Orze' nzhab Jesús lo bixa': ―Dinou pla mbël kwa'n laore nguzen go ba'. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kuze' nkë Simón Per le'n bark par mizubxax xa' yex kwa'n nzho mbël ze' haxta ro' nits, mbaino zhëi di mbël ro; nzho paste tu gayo' nzho cho' bichi' bichon ma le'ne; no ter dox nayax mbël per nangarëzt yex ze'. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Orze' nzhab Jesús lo bixa': ―Dë'u gaosi'l go. No ni tu rë men che'n Me, nangayetla, ngab: “¿Cho go ga'?” Lë' bixa' nane la, lë'i lë' Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","No tuli nguzubi Jesús lo bixa', miza' Me pan par gao rë men che'n Me; no se' ga' miza' Me mbël par gao rë men che'n Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kure' nak wëlt mion ngurulo Jesús lo rë men che'n Me dizde or nguruban Me. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","No or milox ndaosi'l bixa', orze' mina'bdi'zh Jesús lo Simón Per, nzhab Me: ―Simón, xga'n Jonás, ¿chi más ka nazhi'l da lo rë men re'? Orze' nzhab Per: ―Señor; Go nane ka, nichëla kun Go. Nzhab Jesús orze': ―Bikina rë men da, xa' nak nela mbëkxi'l ye'n ga'. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Wëlt rop mina'bdi'zh Jesús, nzhab Me: ―Simón, xga'n Jonás, ¿chi walipa' nazhi'l da? Orze' nzhab Per: ―Señor; go nane ka, lë'da nichël ka kun Go. Orze' nzhab Jesús: ―Bikina rë men da, xa' nak nela mbëkxi'l ga'. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","No wëlt mion, mina'bdi'zh Jesús lo Per, nzhab Me: ―Simón, xga'n Jonás, ¿chi walikal nichë'lal kuna? Orze' miwin laxto' Per por nzhab Jesús kure', orze' nzhab Per: ―Lë'i walika Señor; rëi nane Go, lë' Go nane ka lë'da nichël ka kun Go. Orze' nzhab Jesús: ―Bikina rë men da xa' nak nela mbëkxi'l ga'. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Walika kwa'n nin lol, or xil, nzhak xabal par yal plo nzhaklal; per or gakal mengol, chi'lal ya'l no xtu men gak xabal, wei' xa' lu plo gat nzhaklatal yal. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kure' midi'zh Jesús lo Per, par midi'zh Me xmod gat Per, mbaino por kuba' di'zh men, lë' Dios nazhon. Orze' nzhab Me lo Per: ―Di'kë ticha. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","No or miëk Per, une Per nzhakë men che'n Jesús xa' más nichë'l Me tich bixa'. Xa' re' nguzobkë ta' Jesús or lult ndao xche' Me kun rë men che'n Me, no xa' re' xa' kwa'n nzhab lo Jesús: “Señor, ¿cho chi go lo rë men?” ");
INSERT INTO zcaNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","No or une Per xa' re', orze' nzhab Per lo Jesús: ―Lë'o, ¿xmod yazë xa' re' ga'? ");
INSERT INTO zcaNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Orze' nzhab Jesús lo Per: ―Chi nzhaklan se'gaka ban xa' re' haxta or yala xtu wëlt, ¿kwane par lu ga'? Lu di'kë ticha namás. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","No widi'zh re' mire'ch xid rë men che'n Jesukrist, mile' bixa' xigab, lë' men che'n Jesús re', nayot gat xa', per lë' Jesús gat nzhabt, nayot gat xa', sino ke nzhab Me: “Chi nzhaklan ban xa' re' haxta or yala xtu wëlt, ¿kwane par lu ga'?” ");
INSERT INTO zcaNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","No mis men che'n Jesús re', midi'zh rë kure', no mis lë' xa' mizobni'y lo yech; no nane be, walika rë kwa'n mizobni' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","No mile' Jesús nayaxra' rë kwa'n nazhon kwa'n gat nzobni't lo yech re', no chi ngazobni' rëi, nagalt dub yizhyuo par kwin rë libr plo ngazobni' rë kure'.");
INSERT INTO zcaNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tioj, xa' nichëla, lo primer yech kwa'n mixëla lol, mizobni'n rë kwa'n mile' Jesús, no rë kwa'n milu' Me, dizde or galo laka, ");
INSERT INTO zcaNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","haxta zhë kwa'n ña Jesús lo yibë'. No antis di bi Me, por Sprit che'n Dios milu' Jesús lo rë apost, rë kwa'n naki'n le' bixa', rë xa' kwa'n ngule Me. ");
INSERT INTO zcaNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","No dispwés di ngut Jesús, milu' Me lë' Me nguruban. No dub cho' ngubizh, nayax wëlt ngurulo Jesús lo rë men che'n Me, par ne bixa', walika, nguruban Me. No nu milu' Me xmod nile' Dios mandad lo rë men. ");
INSERT INTO zcaNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","No or stubi nzo Jesús kun rë apost, mile' Me mandad, naro't bixa' yezh Jerusalén, nzhab Me: ―Gulëz go, zhin rë kwa'n mila' Xuza di'zh par go, no kure' yanila lo go. ");
INSERT INTO zcaNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Walika, lë' Juan mililëi' men kun nits, per go, zipla ngubizh lë' go gaklëi' kun Sprit che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Orze', rë xa' nzhin kun Jesús, guna'bdi'zh bixa' lo Me, nzhab bixa': ―Señor, ¿chi mizhin la gaknul no, rë no men Israel, nes par yubre mis tu rë no re' le' mandad lazh no? ");
INSERT INTO zcaNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Orze' nzhab Jesús: ―Gat ñalt ne go zhë o tiemp kwa'n nab tsa Xuza nane, porke lë' Me nile' mandad. ");
INSERT INTO zcaNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Per or yo Sprit che'n Dios laxto' go, orze' gaknu Me go par yalu' go xtizha rë plo. Galo laka, zublou yezh Jerusalén, no rë yezh kwa'n ña'n lazh men Judea, mbaino dub lazh men Samaria, orze' dub yizhyuo. ");
INSERT INTO zcaNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","No or milox midi'zh Jesús rë widi'zh re', nkili Me yibë'; no dub niwi' lo rë xa' nzhin ze', mitlo Me le'n tu xkao, no nanganetra' bixa' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","No dub kiwi' bixa' lo yibë' xmod ña Jesús, lë'chi nguruxo'b chop ganj nak lar bëo laka, plo nzhin bixa', ");
INSERT INTO zcaNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","orze' nzhab rop ganj ze': ―Men Galilea, ¿chon xe kiwi' go lo yibë'? Lë' Jesús Me nguzo xid go ba', no Me kwa'n une go ña lo yibë' nal, nela xmod une go ña Jesús nal re', se'ska yubre Me xtu wëlt. ");
INSERT INTO zcaNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Orze' miëk bixa' par Jerusalén dizde yek lom kwa'n lë Olivos, no lom ze' ña'n gax ro' yezh Jerusalén, nela tu tant kwa'n nila' ley che'n Muisés, zë men zhë kwa'n nile' men Israel diskans. ");
INSERT INTO zcaNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Or mizhin bixa' yezh Jerusalén, ña bixa' kwart al ya yek yo' chop pis. Ze' nzo Per, no Jakob, no Juan, mbaino Ndres, no Lip, no Max, no Tol, mbaino Mateo, no Jakob xga'n Alfeo, kun Simón xa' nguio xlad men cananist, no Judas wech Jakob. ");
INSERT INTO zcaNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Rë xa' re', dubta' nibin bixa' par nina'b bixa' lo Dios, kun rë una', mbaino kun rë wech Jesús, no kun Mari xna' Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","No le'n rë ngubizh ze', nguzo Per garol tsao' plo nzhin bixa', como tu gayo' nzho gal men che'n Jesús, orze' nzhab Per lo bixa': ");
INSERT INTO zcaNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Nin lo go wech no bizan, men Israel; rë kwa'n ngok re', midi'zh la Dabi por Sprit che'n Dios, or midi'zh Dabi kwent che'n Judas, xa' mile' entreg Jesús lo rë xa' nguzen Me. ");
INSERT INTO zcaNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","No Judas, mis tu rë xpen be ngok xa', mbaino mile' xa' tutsa zhi'n kun be, ");
INSERT INTO zcaNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","per nguzen xa' dimi kwa'n ngox ka' xa' por mal kwa'n mile' xa', no kun dimi re' nguzi' xa' tlë' yuo, orze' ngula xa' al yek xa', no ngurez laxto' xa', nguro' rë xtrip xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","No or mbin rë men yezh Jerusalén, se' ngok, kuze' ngulo'lë bixa' yo ze' Acéldama, widi'zh re' gab, yo ren, ");
INSERT INTO zcaNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","porke se' nzobni' lo yech kwa'n lë Salmos: Ya'n nzë'b lizh xa'; yent cho yo le'ne, mbaino: Xtu xa' yo xlugar xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’No nal, naki'n kwe be lo mis tu rë xa' kwa'n nkizë kun be, rë ngubizh kwa'n nguzinu Señor Jesús be, par yo xlugar Judas. ");
INSERT INTO zcaNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","No naki'n nkizë xa' re' kun be dizde zhë kwa'n mililëi' Juan men le'n nits, haxta or ña Jesús lo yibë'; par gaknu xa' re' be, di'zh be lo rë men, lë' Jesús nguruban. ");
INSERT INTO zcaNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Orze' ngule bixa' chop miyi', tu xa' kinu chop lë; tu lë xa' lë Che Barsabás, xtube lë Justo. No xtu miyi' lë Matías. ");
INSERT INTO zcaNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Orze', se' mina'b bixa' lo Dios: ―O Señor, Lu kwa'n nzhakbe' laxto' rë nak men; bilu' cho miyi' kwa'n kwel, lo rop xa' re', ");
INSERT INTO zcaNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","par zen xa' zhi'n re', gak xa' apost, le' xa' rë zhi'n kwa'n mila' Judas, par ña Judas lugar plo ñal xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Orze' nguzhit bixa' dado, par ne bixa' cho ya'n xlugar Judas. No lë' Matías ngol swert, nguio xid za chi' bitub apost che'n Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Or mizhin ngol lani Pask, tutsa junt nzhin rë men che'n Jesukrist le'n tu yo', ");
INSERT INTO zcaNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","no di repent, ngurezh tu rruid naye kwa'n nzë lo yibë', nela tu mbi naye dox ga', nguioi dub le'n yo' plo nzhin bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Orze' al ya yek kad bixa', nguluxo'b tuga' bël kwa'n nak nela luzh men ga'. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Orze' nguio Sprit che'n Dios laxto' rë bixa', no nguzublo kidi'zh bixa' rë lo widi'zh, nela xmod nzhakla Sprit che'n Dios, di'zh bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","No le'n rë ngubizh ze', yezh Jerusalén nzhin nayax men Israel, rë xa' kwa'n nzhon widi'zh che'n Muisés; rë plo nguro' bixa' par nzë bixa' lani Pask yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Or mbin men rruid ro re', migan rë nak bixa' ze'; no xe kiwi' bixa', mbaino net bixa' chon, porke kad bixa' kiyon kidi'zh rë men che'n Jesukrist widi'zh kwa'n ngolnu bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","No por net bixa' kwan le' bixa' por kwa'n kiyak re', orze' kidi'zh bixa': ―Per rë men re' nzë lazh men Galilea. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Mbaino, ¿chon ska kiyon be kidi'zh bixa' widi'zh kwa'n ngolnu kad be?, ");
INSERT INTO zcaNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","porke re' nzhin rë men nzë lazh men Partia, no xa' nzë lazh men Media, no xa' nzë lazh men Elam, mbaino xa' nzë lazh men Mesopotamia, no xa' nzë lazh men Judea, mbaino xa' nzë lazh men Capadocia, no xa' nzë lazh men Ponto, no rë men xa' nzë lazh men Asia; ");
INSERT INTO zcaNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","no xa' nzë lazh men Frigia, no xa' nzë lazh men Panfilia, mbaino xa' nzë lazh men Egipto, no xa' nzë lazh men Libia kwa'n nzhin gax lazh men Cirene, kwa'n ña'n lo yuo che'n men Africa; no rë men yezh Roma, rë xa' kwa'n nzho re'. No nzho bixa' kwa'n gat lë't men Israel per nzhon bixa' widi'zh che'n Muisés, kun rë xa' dizde ngol, nak men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","No nzho xa' nzë lazh men Creta, mbaino xa' nzë lo yuo Arabia; mbin no kidi'zh bixa' yalnazhon che'n Dios kun widi'zh kwa'n nidi'zh kad no. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","No rë bixa' net bixa' kwan le' bixa' xigab, orze' kinabdi'zh tuga' bixa' lo wech bixa', nzhab bixa': ―¿Kwan kure' nal? ");
INSERT INTO zcaNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Per nzho men kixizhnu rë men che'n Jesukrist, nzhab bixa': ―Ka nizuzh rë xa' ba'. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Orze' ngwatso Per kun za chi' bitub men che'n Jesukrist, par midi'zh Per naye, nzhab Per: ―Biwi' go men Judea, no rë xa' nzho yezh Jerusalén; bin go widi'zh kwa'n ganin lo go nal re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Gat nizuzht rë xa' re', nela xmod nile' go xigab ga', porke garzi'l nal, laore las nueve, ");
INSERT INTO zcaNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","sino ke rë kwa'n kiyak re', lë'i midi'zh la profet Joel, or midi'zh xa' se' por Dios: ");
INSERT INTO zcaNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Rë zhë lult, se' gak, nzhab Dios, lë'da xë'l Sprit da, par yo laxto' rë lo men, no xga'n xa' kun xcha'p xa', lë'da le di'zh bixa', rë kwa'n nagat gak. Mbaino len, rë xa' xi kwa'n nzho xid bixa', lë' bixa' ne rë kwa'n, no rë men ngol, lë' bixa' cha' laxto'. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","No xëla Sprit da yo laxto' rë men da; miyi'y no una'i, no di'zh bixa' por na. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Al ya lo yibë' ne go, gak rë kwa'n ya'n xe men tuli, no lo yizhyuo ne go rë señ, no ren, no bël, mbaino zhen. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","No gak nakao lo ngubizh; no lo mbëo' lë'i lu' nela ren ga'. Naki'n rë kure' gak antis di ke zhin zhë che'n Señor, or lu' Me biani che'n Me kwa'n maska ña'zbël, no gab Me xmod gak kun kad men, zhë kwa'n ne men, lalta' rë kwa'n nagat ne men. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","No rë xa' nibezh lë Dios or nina'b bixa' lo Dios, lë' Dios kubchi rë kwa'n nzë'b xki bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","No nu nzhab Per: ―Rë go, men Israel; bin go widi'zh kwa'n nin re'. Lë' Dios milu' la lo go, cho nak Jesús kwa'n nzë Nazaret, por rë zhi'n nazhon kwa'n mile' Jesús, zhi'n kwa'n mile' mia'n go xe; no por rë señ nazhon kwa'n mile' Jesús lo go. Lë' Dios miza' poder ka' Jesús, mbaino mis go une la rë kure'. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Per lë' miyi' re', por rë xigab che'n Dios, no por rë kwa'n nzhakla Dios gak, nguzen go miyi', no mikë' go xa' lo krus, mbit rë men mal xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Per mile' Dios nguruban xa', ngulo' Dios xa' ya' la mwert, porke nangakt ngakwë'z la mwert xa' re' par dubta', ");
INSERT INTO zcaNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","porke Dabi midi'zh la kwent che'n Jesús, or nzhab Dabi: Zilita' unen nzol dilant lon, Señor, porke Lu nzo lad direch da, par niyent kwan zheb da. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kuze', nizak laxto'n, mbaino ro'n nikë' kant dub nizak laxto'n, porke lu le', ruban da or gat da. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","No nala'tal ya'n da le'n ba', no ni nala'l yëb kwerp da, por nak da tu xpenal kwa'n más nzhon ro'l. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Milu'l xmod ban da par dubta', no nile'l, nizak laxto'n, or nzol kuda. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","No nzhab Per: ―Lë' go wech, walika kwa'n nin; nzhala ngut rey Dabi, mbaino miga'ch xa', no ba' che'n xa' nane be plo nax, haxta zhë nalzhë. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dabi ngok profet, midi'zh xa' por Dios, mbaino nane Dabi, lë' Dios mila' di'zh lo xa', lë' Dios le' rey lo mis tu rë xa' nzë ben che'n xa' kwa'n ngurulë Krist, par zob xlugar xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Milu' Dios rë kure' lo rey Dabi, kuze' nzhab xa', lë' Krist ruban, no ni nala' Dios ya'n alm che'n Krist le'n ba', no ni nala' Dios, yëb kwerp che'n Krist. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Kuze' mile' Dios, nguruban Jesukrist; no nak no men che'n Me kwa'n une ngut Me, no une no nguruban Me. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ngurezh Dios Jesukrist, ña Me lo yibë'. No ba' nzob Jesukrist lad direch che'n Dios, plo nile' Me mandad. No miza' Dios Sprit che'n Dios nka' Jesukrist par rë men che'n Me, porke se' mila' Dios di'zh par Jesukrist. No nal, Jesukrist mixë'l Sprit che'n Dios par nguio laxto' no, lë'i rë kwa'n une go, no rë kwa'n mbin go nal re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","No Dabi, nangakilit lo yibë', per lë' Dabi nzhab por Dios: Nzhab Dios lo Señor da: “Guzob lad direch da, ");
INSERT INTO zcaNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","haxta zhin zhë len, che'ptsa (bi'ch laka) gak rë men dilant lol, rë xa' kwa'n nidilal kun lë'.” ");
INSERT INTO zcaNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Orze' nzhab Per: ―Bin goi, men Israel, lë' go rë xa' kwa'n mikë' Jesukrist lo krus. Lë' Dios mizo Jesukrist lo be, par gak Me Señor che'n be, mbaino Krist; Me kwa'n mixë'l Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Or mbin bixa' kure', orze' dox mizi bixa' nzë'b xki bixa' lo Dios, orze' nzhab bixa' lo Per, no lo zipla apost: ―¡Lë'o wech!, ¿kwan naki'n le' no nal? ");
INSERT INTO zcaNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Orze' nzhab Per: ―Bila' go rë kwa'n nakap nile' go lo Dios, no nu goklëi' go le'n nits nela xmod mile' ka Jesukrist mandad, no che' Dios rë kwa'n nzë'b xki go, no ne' Dios Sprit che'n Dios yo laxto' go, ");
INSERT INTO zcaNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","porke par go mila' Dios di'zh kure', no par rë xmë'd go, mbaino par xtu ben rë men zit, haxta par rë xa' kwezh Dios par gak men che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","No se' midi'zh Per, no kun más rë widi'zh, par miza' Per kunsej, nzhab Per: ―Guro' go xid rë men nakap kwa'n nzho nalre', par nagal go yalzi kwa'n zak bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","No rë xa' ngwayila widi'zh che'n Dios kwa'n midi'zh Per, ngoklëi' bixa'. Zhë ze', migan pas chon mil men, par nguio bixa' xid más rë men che'n Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","No dubta', nikizë rë xa' re', nela xmod mitse'd rë apost bixa', no nguzhin bixa' wen, no nu nzhao bixa' lizh kad wech bixa', mbaino junt nina'b bixa' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","No por rë señ nazhon kwa'n nile' Dios por rë apost, rë men nizheb lo Dios, no wen nidi'zh bixa' por Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","No rë xa' kwa'n ngwayila widi'zh che'n Dios por Jesukrist, tutsa nzhin bixa', no tutsa kinu bixa' rë kwa'n. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","No mito bixa' rë kwa'n nak che'n bixa', par ndi'z bixa' dimi, ka' rë xa' kwa'n naki'ne, rë xa' kwa'n nzho xid bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","No zilita' nigan bixa' le'n yado', no tutsa xigab nile' bixa'. No nigan bixa' lizh kad wech bixa' par nzhao bixa' junt, mbaino nizak laxto' bixa', nile' bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","No nidi'zh bixa' dox nazhon Dios, no wen nidi'zh rë men tich bixa', por Jesukrist. No kad zhë nile' Señor ñar men yado', rë xa' kwa'n kibezh Dios par chë' Dios xmod naban bixa', mbaino za' Dios kwa'n nazhon ka' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ngol tu zhë, nzha Per kun Juan yado', paste las tres guzhe, or kwa'n nina'b men lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","No ro' pwert yado' kwa'n lë Chul, ze' nizob tu miyi' kwa'n nagakt zë dizde ngol xa'. Zilita' ñanu men xa' ro' yado' ze', par nina'b xa' gon lo rë xa' ña yado'. ");
INSERT INTO zcaNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Or une xa' ko'j re', lë' Per no Juan nzhayo le'n yado', orze' guna'b xa' gon lo rë xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Orze' miwi' Per kun Juan lo xa' re', nzhab Per lo xa': ―Biwi' lo no. ");
INSERT INTO zcaNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Orze' list kimbëz xa' re', mile' xa' xigab zen xa' tu kwa'n ya' rë xa' re', ");
INSERT INTO zcaNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","orze' nzhab Per lo xa': ―Gat kinuta' plat ni or, per kwa'n kinun, lë'i nen ka'l: Por yalnazhon che'n Jesukrist Me nzë yezh Nazaret, ¡ngwatsuli no guzë! ");
INSERT INTO zcaNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Orze' nguzen Per ya' xa' re' lad direch par nguzo xa', no lwega' mili ni' xa', nka'i jwers, ");
INSERT INTO zcaNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","orze' nguzuli xa' ko'j re' no ngwats xa' tuli, no nguzublo nguzë xa', orze' nguio xa' kun Per no kun Juan le'n yado'; maska ñats xa', no kidi'zh xa': —¡Dox nazhon Dios! ");
INSERT INTO zcaNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","No rë xa' nzhin ze', une bixa' nguzë xa' ko'j re', mbaino kidi'zh xa' dox nazhon Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Orze' xe mia'n rë men tuli, net bixa' kwan le' bixa' por kwa'n une bixa', porke nane men, lë' xa' re' nikan gon, no nizob xa' ro' pwert yado' kwa'n nzhab men lë Chul. ");
INSERT INTO zcaNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Per net xa' miak re' liya' xa' Per no Juan, no rë men nzhin ze', xe niwi' bixa', no karre nguzubi bixa' ro' pwert che'n Salomón, plo nzhin rë xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Or une Per kure', orze' nzhab xa' lo rë men ze': ―Men Israel, ¿chon xe mia'n go tuli por kwa'n ngok re', no niwi' go lo no, nela chigab yub no miliwen miyi' re', no nguzë xa' por mis poder che'n no, o por dox nzhon no ro' Dios, kuze' miak xa' re'? ");
INSERT INTO zcaNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kure' ngok por Dios che'n Abraham, che'n Isaac, che'n Jakob, mbaino Dios che'n más rë xtit be. Lë' Dios re' milu' dox nazhon Jesús, Me mile' rë kwa'n ngokla Dios, mbaino Me kwa'n michi go lo Pilat. No or ngokla Pilat ngaliya' Jesús, nangaziyëlt go. ");
INSERT INTO zcaNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Maska go ngaziyëlt ngaliya' Pilat Jesús, Me nazhon no Me nile' rë kwa'n nzhab Dios, lë'la guna'b go, liya' Pilat men nzhut men, ");
INSERT INTO zcaNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","mbaino mbit go Jesús, Me kwa'n niza' yalnaban par dubta' ka' men, per mile' Dios nguruban Jesús, mbaino une no, lë' Me nguruban. ");
INSERT INTO zcaNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","¿Chi niwi' go lo xa' re', no chi nilibe' go xa'? Lë' yalnazhon che'n Jesukrist miliwen xa' re', por ngwayila xa' Jesukrist. Kuze' miak ni' xa', kwa'n milox une go nal re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","No nzhab Per: ―Nal wech, lë'da nane la; ni go mbaino ni rë xa' nile' mandad lo go, nanet go kwan mile' go or mbit go Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Per se' ngoke, porke se' nzobni' lo Yech che'n Dios kwa'n mikë' rë profet, rë xa' kwa'n midi'zh por Dios chi tiemp, ke lë' Krist naki'n zakzi, Me kwa'n mixë'l Dios, nes par ngok rë kwa'n mile' Dios xigab. ");
INSERT INTO zcaNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kuze' nal, bila' go rë kwa'n nakap kile' go lo Dios, par kubchi Dios rë kwa'n nzë'b xki go lo Dios, no par tsumbe Dios laxto' go, no rë xigab che'n go, ");
INSERT INTO zcaNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","par xë'l Dios rë tiemp kwa'n le' go diskans. Xë'l Dios Jesukrist, Me kwa'n mbin la go dizde or galo. ");
INSERT INTO zcaNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Per nal, lë' Jesukrist nzho lo yibë', haxta zhin zhë, le' Dios gak kub rë kwa'n nzho nal, nela xmod midi'zh ka Dios por rë profet, rë xa' tiemp dox, rë xa' kwa'n nkizë nambe lo Dios, ");
INSERT INTO zcaNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","porke nzhala ze', walika nzhab Muisés: “Lë' Señor Dios che'n go, le' gak tu xa' profet xid go, nela da ga'. Naki'n gon go ro' xa' re' dike kwa'n ne xa', ");
INSERT INTO zcaNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","porke rë xa' naziyël gon kwa'n gab profet re', lë' Dios kubchi xa' lo rë men che'n Dios, par lox xa'.” ");
INSERT INTO zcaNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","No nzhab Per: ―Dizde profet Samuel par dilant, rë profet xa' midi'zh por Dios, midi'zh la bixa' kwa'n nzhak nal re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Lë' go nzë ben che'n rë profet, rë xa' kwa'n midi'zh por Dios, no par go rë kwa'n mila' Dios di'zh par rë xuz be xa' nzhala, kun Abraham, or nzhab Dios lo xa': “Por tu xmë'dal, rë ben men yizhyuo ya wen.” ");
INSERT INTO zcaNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","No or mile' Dios nguruban Jesukrist, galo laka lo go mixë'l Dios Jesukrist, par le' Dios ya go wen, nes par la' go, nale'tra' go kwa'n gat lë'. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","No stubi kidi'zh Per kun Juan lo rë men nzhin ze', lë'chi mizhin pla ngulëi', no kun rë xa' nikina yado', no kun zipla xa' lë saduceo. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Niyi' bixa' por kilu' Per kun Juan lo rë men, lë' rë men ngut ruban, porke Jesukrist nguruban. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kuze' nguzen bixa' Per kun Juan, par ngulo bixa' rë xa' re' lizhyi'b haxta xtu riyë'l, porke orze' nzhazhëlalyuo. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Per dox nayax men kwa'n mbin widi'zh che'n Dios por Jesukrist kwa'n midi'zh Per, no ngwayila bixa'i. Nabtsa men miyi' miza como gai' mil bixa' zhë ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Xtu riyë'l, yezh Jerusalén nguzhin rë xa' nile' mandad, kun rë xa' kwa'n nak zhi'n, mbaino rë xa' nilu' ley; ");
INSERT INTO zcaNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","no Anás xa' nile' mandad lo rë ngulëi', kun Caifás, no Juan, no Jand, no rë nak melizh ngulëi' ro'; nguzhin bixa' ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Orze' mile' bixa' mandad ñë'd Per kun Juan, no miyi' kwa'n miak re', par nguzo yon xa' re', garol tsao' plo nzhin bixa'. Orze' nzhab bixa' lo Per no lo Juan: ―¿Cho che'n mandad kile' go rë kure'?, o, ¿cho mixë'l go par kile' goi? ");
INSERT INTO zcaNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Orze' midi'zh Per lo bixa' por Sprit che'n Dios, nzhab Per: ―Nin lo rë go, xa' nile' mandad no, no lo rë go xa' nak zhi'n: ");
INSERT INTO zcaNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Lë' go kinabdi'zh xmod uniwen xa' ngokne re' par ne go, xmod ngokwen xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Lë' no nei lo go, no lo rë men Israel. Mikë' go Jesukrist Me nzë yezh Nazaret lo krus, per mile' Dios nguruban Me. Por lë Jesukrist, miak xa' re', xa' nzo lo go re', yent kwa'n nizak xa' nal. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Gat ñilat go Jesukrist. Lë' Me nak nela tu ke ga', kwa'n nibe men kwa'n nichao' yo'. Lë' go ngulubi ke re', per lë' Dios mile' nak Jesukrist nela primer ke che'n simient ga'. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yent cho xtu xa' gak liwen be; xid rë xa' kwa'n mixë'l Dios, nab tsa xa' re', xa' ngule Dios par gak ko' be lo rë kwa'n nzë'b xki be. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Or mbin bixa' kwan midi'zh Per, xe mia'n bixa', porke nangazhebt Per kun Juan, midi'zh bixa' rë widi'zh re'. Orze' kidi'zh rë xa' nile' mandad ze' lo rë wech bixa': “Per nane be, nangat rë xa' re' skwel, no men se'ga bixa'.” Orze' mitsila bixa' lë' rë xa' re' nki'zë kun Jesukrist, ");
INSERT INTO zcaNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","kuze' nangadi'zhtra' bixa', porke une bixa', lë' miyi' re' miak. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Orze' mile' rë ngulëi' mandad, nguro' Per tu lad kun Juan, no kun miyi' xa' miak re', par midi'zh nab bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Orze' kidi'zh entre lë' bixa', nzhab bixa': ―¿Kwan le' be nal kun rë mbe re'?, porke rë men Jerusalén mbin la yalnazhon kwa'n mile' Dios kun miyi' re'. No nagakt gab be: “Gat walite”, porke lë' rë men mbin lai. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Per par nare'chra' xti'zh Jesús xtu plo, mejor lë' be che'b yon bixa', par nadi'zhra' bixa'i ni xtu plo. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Orze' ngurezh bixa' Per kun Juan, nzhab bixa': ―Nadi'zhtra' go xti'zh Jesús, no ni naze't go lë Jesús ni xtu plo. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Per nzhab Per kun Juan lo rë ngulëi' ze': ―Bine go lo no, ¿cho ro' más ñal gon no? ¿Chi ro' goi, o ro' Diose?, ");
INSERT INTO zcaNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","porke no naka'cht no kwa'n une no, mbaino kwa'n mbin no. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","No une rë ngulëi' ze', yentra' kwan ngak ngale' bixa' kun Per no kun Juan. Orze' midi'zh bixa' nayi' par ngazheb yon xa' re'. Orze' miliya' bixa' Per no Juan, mbaino xa' miak re', porke rë men yezh Jerusalén nidi'zh dox nazhon Dios, por kwa'n mile' Dios kun miyi' re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","No miyi' kwa'n miliwen Dios re', nzhap la xa' más di cho' li'n. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","No or miliya' rë xa' nak zhi'n Per no Juan, mbaino xa' miak re', orze' ña bixa' plo nibin más rë men che'n Jesukrist. Ze' midi'zh bixa' rë kwa'n midi'zh rë ngulëi' ro, no rë kwa'n midi'zh más rë xa' nak zhi'n, lo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Or mbin rë men che'n Jesukrist rë widi'zh re', orze' junt guna'b bixa' tutsa kwa'n lo Dios, nzhab bixa': ―O Dios Señor che'n no, Lu kwa'n mizuxkwa' yibë', no yizhyuo, mbaino nitsdo', no rë kwa'n nzhin loi. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Lu mile' midi'zh Dabi xti'zhal por Sprit che'nal, kuze' mikë' xa' widi'zh re': ¿Chon tatu nazhe'b nile' rë men gat lë't men Israel, niyi' bixa' nine bixa' Dios? ¿Chon nile' rë men Israel xigab kwa'n niyent yek, dil bixa' kun Dios? ");
INSERT INTO zcaNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Migan rë rey yizhyuo, kun rë xa' nak zhi'n rë yezh, tutsa nguzhin bixa' par dil bixa' kun Lu Señor, no kun Krist, Me kwa'n mixë'l Señor. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Lë' widi'zh re' ngok, porke yezh re', lë' Herodes no kun Pons Pilat, no kun rë men Israel, mbaino kun rë xa' gat lë't men Israel, migan bixa' re' par dil bixa' kun Lu Dios, no kun Xga'n nazhonal kwa'n mixë'lal, ");
INSERT INTO zcaNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","nes par mile' bixa' rë kwa'n mile'lal xigab gak, porke se' ngoklal. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nal biwi', O Señor, rë kwa'n gat lë' kwa'n midi'zh bixa', zakzi bixa' no. Per lë' no le' zhi'n che'nal. Kuze', kina'b no lol, gaknul no, par xek no, no nazhebt no di'zh no xti'zhal lo rë men. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","No bilu' yalnazhon che'nal, par gak wen men nzhakne, como tu señ lë'l nzo kun no; no bile' rë kwa'n ña'n men xe, por lë Xga'nal Jesús, Me nambe laxto' no nazhon. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Or milox mina'b bixa' lo Dios, miwin tu xo dub le'n yo' plo nzhin bixa'. Orze' más nguio Sprit che'n Dios laxto' bixa', no dubta' nangazhebt bixa' midi'zh bixa' widi'zh che'n Dios por Jesukrist rë plo. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Rë bixa' kwa'n ñila widi'zh che'n Dios por Jesukrist, tutsa nizi bixa', no tutsa nile' bixa' xigab. Yent cho gab: “Che'n naba kure'”, sino ke che'n rë bixa' tu kwa'n. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ngoknu Dios rë apost par midi'zh bixa' walika nguruban Jesukrist, no dox ngoknu Dios rë bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","No yent cho tu xa' kwa'n ngok jwalt tu kwa'n lo, porke rë xa' kwa'n kinu yuo o yo', mito bixa'i, ");
INSERT INTO zcaNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","orze' dimi ze' nzhuwei' bixa'i lo rë apost, orze' rë xa' re' niyi'ze lo kad xa' naki'ne. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","No nguio tu miyi' xa' lë Che, tu xa' nzë lazh men Chipre, kwa'n nzhin tsao' nitsdo'. Nak xa' tu men Levita, no rë apost ngulo'lë xa' Bernabé; widi'zh re' gab: Men nitsiyal laxto' men. ");
INSERT INTO zcaNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","No lë' Bernabé mito tlë' yuo che'n xa', orze' ngwala' xa' dimi kwa'n midoi lo rë apost. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Per nguio tu miyi' xa' lë Ananías, no tsa' xa' lë Safira, no mito bixa' tlë' yuo che'n bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Per mia'nnu bixa' xche'p dimi che'n yuo, no nane lo una' che'n xa' kure', lë' más dimi ngwala' xa' lo rë apost. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Orze' nzhab Per lo xa': ―Ananías, ¿chon mila'l ngulo Mizhab xigab gat lë't yekal? ¿Chon nzhaklal ngakidel Sprit che'n Dios?, mia'nal kun xche'p dimi kwa'n mitol yuo, ");
INSERT INTO zcaNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","porke antis dike ngatol yuo, ¿chi gat lë't che'nle? No or nguzenal dimi, ¿chi gat lë't lu nile' mandade? Orze', ¿chon mila'l mbi'd xigab re' yekal, kikë'l mbël?, porke gat lë't men kikidel, sino Diose. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Or mbin Ananías widi'zh re', kwa'n nzhab Per, orze' ngwachin xa' no ngut xa' tuli. No rë men kwa'n mbin kure', rë bixa' mizheb. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Lwega' nguzubi pla miyi' xi, no michël bixa' lar xa' ngut re', orze' ngwaka'ch bixa' xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nzha como chon or di ngok kure', lë'chi mizhin tsa' xa', xa' lë Safira, net xa' kwan ngok. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Orze' nzhab Per lo una': ―Bine lon, ¿chi sa'ka mito go yuo che'n go, nela xmod ne xmiyi'l? Orze' nzhab una': ―Sa' kai. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Orze' nzhab Per: ―¿Chon tutsa mia'n go par kide go Sprit che'n Dios? Biwi', lë' rë xa' kwa'n ngwaka'ch xmiyi'l ñë'd la ro' pwert ba'. No nal, nuskal yaka'ch bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","No mis orze' ngwachin Safira xan ni' Per, ngut una'. No or mizhin rë xa' xi re', une bixa' lë' una' re' ngut la, orze' ngwaka'ch bixa' una' lo mis plo miga'ch xmiyi' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Orze' rë men che'n Jesukrist dox mizheb bixa', no kun rë men yezh, or mbin bixa' kure'. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Por rë apost, mile' Dios nayax señ nazhon kun rë kwa'n mile' mia'n men xe. No migan rë men che'n Jesukrist le'n corredor che'n Salomón. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nzho nayax men yezh Jerusalén kwa'n nangayet laxto' ngabin kun rë men che'n Jesukrist, ter dox wen nidi'zh rë men yezh tich rë xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","No le'n rë ngubizh ze', mile' Dios niza nayax xa' ñila widi'zh che'n Dios por Jesukrist, miyi'y no una'i. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","No haxta ngulo' men, rë xa' nzhakne lo lo'n par le'n nez, par gal namás xkal che'n Per lo bixa', or ded Per, par yak bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","No nayax men kwa'n nzë rë yezh kwa'n nzhin naka'n yezh Jerusalén, mizhinnu bixa' men nzhakne, no rë xa' nzho mbi mal laxto'. No rë bixa' miak. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Orze' ngulëi' ro kun rë xa' nichë'l xa', rë xa' kwa'n lë saduceo, dox niyi'xian bixa' por ¿chon ñakë dox men tich rë apost? ");
INSERT INTO zcaNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kuze' nguzen bixa' rë apost, par mikë' bixa' rë xa' re' lizhyi'b. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Per or yë'l ze', ngwa tu ganj che'n Dios mixa'l ro' lizhyi'b, par nguro' rë apost, orze' nzhab ganj lo bixa': ");
INSERT INTO zcaNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Wa go lo rë men yado', par wadi'zh go lo bixa', lë' Dios nichë' mod niban men. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Or mbin bixa' kure', garzi'l laka ngwa bixa' yado' par ngwadi'zh bixa' widi'zh che'n Dios por Jesukrist lo rë men nzhin ze'. No ngulëi' ro', no kun rë xa' kwa'n nichë'l xa', ngurezh bixa' rë xa' nak gustis kwa'n más tsak par mizhin bixa' tu junt. Orze' mile' bixa' mandad lo rë xa' nikina lizhyi'b, par yaka' bixa' rë apost, rë xa' nzho lizhyi'b re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Per or mizhin bixa' ro' lizhyi'b, une bixa' yentra' cho nak; orze' nguiubre' bixa', mile' bixa' abis, nzhab bixa': ");
INSERT INTO zcaNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","―Or mizhin no ro' lizhyi'b, no ro' pwert che'ne naye ka nayao', no rë sondad kwa'n nikina, lë' bixa' nzhin ka; or mixa'l no ro' pwert, yentra' cho nak. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Or mbin ngulëi' roi, kun rë xa' nile' mandad lo rë xa' nikina yado', mbaino kun más rë ngulëi' xa' nile' mandad lo xtu ben rë ngulëi'; orze' net bixa' haxta plo zhin rë kure', ");
INSERT INTO zcaNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","orze' mizhin tu miyi', nzhab: ―Lë' rë xa' kwa'n ngulo go lizhyi'b ze', lë' bixa' nzo la le'n yado', kilu' bixa' xti'zh Jesús lo rë men. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Orze' xa' kwa'n nile' mandad, ngwa xa' yado' kun rë sondad che'n xa', par ngwaka' bixa' rë apost. Per nangayint bixa' rë xa' re', porke nizheb bixa', napa' ko men ke bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","No or ñë'dnu bixa' rë apost, mizo bixa' rë xa' re' lo rë gustis xa' más nile' mandad, orze' nzhab ngulëi' ro': ");
INSERT INTO zcaNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―¿Chi nangont go kwa'n ne no, nadi'zhtra' go xti'zh Jesús lo rë men? Mbaino nal, ¡lo rë men yezh Jerusalén kilu' go xti'zh Jesús! No nikë' go kixu' no, nidi'zh go, ¡no mbit Jesús! ");
INSERT INTO zcaNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Orze' nzhab Per, kun más rë apost, lo bixa': ―Naki'n gon be ro' Dios, más ke ro' men. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Dios, Me ngwayila rë xtit be, me tiemp, mile' nguruban Jesukrist, mis Me kwa'n mbit go, mile' go nkë Me lo krus. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","No mizo Dios Jesukrist lad direch che'n Dios, par le' Jesukrist mandad lo rë be, no par ngulo' Jesukrist be lo rë kwa'n nzë'b xki be, no par yëk rë men Israel lo Dios, nes par che' Dios rë kwa'n nzë'b xki be. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Une no rë kwa'n mile' Dios, kuze' nidi'zh noi lo rë men. No Sprit che'n Dios nile' kwa'n nazhon kun rë señ por no. No men xa' nzhon ro' Dios, niza' Dios Sprit che'n Dios, yo laxto' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Or mbin rë ngulëi', kun rë xa' nak zhi'n, widi'zh re', dox miyi'xian bixa', no haxta ngokla bixa' gut bixa' rë apost re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Per orze' ngwatsuli tu miyi' xa' lë Gamaliel, tu xa' fariseo kwa'n nilu' ley kwa'n mila' Dios lo Muisés, no rë men nidi'zh: “Dox nzhak xa' re'.” Orze' nzhab Gamaliel: “Ro' rë apost tu rrat al tich.” ");
INSERT INTO zcaNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Orze' nzhab Gamaliel lo rë ngulëi', no lo más men xa' nzhin ze': ―Rë go, men Israel; bile' go xigab xmod le' go kun rë miyi' re', ");
INSERT INTO zcaNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","porke bitsila go, nzhala, nguio tu miyi' xa' lë Teudas; nzhab xa' nak xa' tu men xa' nile' mandad, ngop xa' como tap gayo' men, xa' nguzukë tich xa', per or ngut xa', rë xpen xa' mire'ch, milox bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","No le'n rë ngubizh che'n sens, se'ska nguio xtu xa' lë Judas kwa'n nzë Galilea. Nuska xa' ngop nayax xa' nguzukë tich xa', per or ngut xa', rë ska xpen xa' mire'ch, orze' milox bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kuze' nin lo go; bila' go nzhin rë miyi' re', yent kwan le' go lo bixa', porke chi yek bixa' nguro' rë kuba', lë'i yitlo. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Per chi zhi'n nazhon che'n Dios kile' bixa', nagakt kwë'z goi, neu namás, nzha ska kun Dios kidil go. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","No rë bixa' mbin ro' Gamaliel. Orze' ngurezh bixa' rë apost, no mile' bixa' mandad ngurële tich rë apost, mbaino mile' bixa' mandad, ke ya nadi'zhtra' bixa' widi'zh che'n Jesús. Orze' miliya' bixa' rë apost. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Or nguro' rë apost xid rë xa' nak zhi'n ze', no por ngurële tich bixa' por Jesukrist, dox nizak laxto' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","No zilita', le'n yado', no rë lizh men, ñadi'zh bixa' widi'zh nazhon che'n Dios por Jesukrist rë plo. ");
INSERT INTO zcaNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Le'n rë ngubizh ze', miza nayax men che'n Jesukrist. Per nguzublo kichëlro' rë men che'n Jesukrist, xa' nidi'zh widi'zh grieg, lo xtu ben xa' kwa'n nidi'zh widi'zh hebreo, nzhab rë xa' grieg re': ―¿Chon lë' rë una' hebreo xa' ngut xmiyi', más nayax kwa'n nzhao biuna' niga'z, no lë' rë una' grieg, xa' ngut ska xmiyi', más che'pe nzhal bixa'? ");
INSERT INTO zcaNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Orze' dub tu dusen apost, mikan bixa' rë men che'n Jesukrist, orze' nzhab bixa': ―Gat lë't la' no, yadi'zh no widi'zh che'n Dios por Jesukrist, par ki'z no kwa'n gao rë men. ");
INSERT INTO zcaNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kuze', naki'n kwe go gazh miyi' xid go, rë xa' nidi'zh men wen tich, no rë xa' kwa'n nilu' ka nzho Sprit che'n Dios laxto', mbaino rë xa' nzhak par le' bixa' zhi'n re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Mbaino lë' no zilita' na'b no lo Dios, no yalu' no widi'zh che'n Dios por Jesukrist lo rë men. ");
INSERT INTO zcaNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","No nguio laxto' rë men che'n Jesukrist kure', orze' ngule bixa' tu miyi' xa' lë Teb. Miyi' re', dox ñila xa' widi'zh che'n Jesukrist, mbaino dox nzho Sprit che'n Dios laxto' xa'. No ngule bixa' xtu xa' lë Lip, kun Prócoro, mbaino Nor, no Timón, no xtu xa' lë Parmenás, no Kulás. Xa' re' nzë yezh Antioquía, gat lë't men Israel xa', per nzhon xa' ley kwa'n mila' Dios lo Muisés antis di gak xa' tu men che'n Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Orze' ngwanu men che'n Jesukrist rë miyi' re' lo rë apost, par guna'b bixa' lo Dios par gaknu Dios rë miyi' re', orze' mixo'b rë apost ya' bixa' yek kad rë xa' re', par gaknu Dios bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Mbaino más men kiyon widi'zh che'n Dios por Jesukrist, no más nayax men che'n Jesukrist miza yezh Jerusalén, no nayax ngulëi' ngok men che'n Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","No dox nilu' nzo Dios kun Teb; por Teb, nile' Dios dox kwa'n nazhon xid rë men, rë kwa'n nile' ña'n men xe, mbaino por rë kwa'n nile' xa', nilu' lë' Dios nzo kun lë' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Per michëlro' pla rë men kun Teb, no rë men re' nak xa' nzë plo lë Kapi che'n rë men libr la. Xid rë men re' nzho xa' nzë yezh Cirene, no nzho xa' nzë yezh Alejandría, mbaino nzho xa' nzë lazh men Cilicia kun zipla bixa' kwa'n nzë lazh men Asia. ");
INSERT INTO zcaNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","No ni tu kwa'n nagakt kab bixa' lo Teb, porke dox nzhak Teb nidi'zh por Sprit che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Orze' ndix rë men re', ka' pla miyi' par mikë' bixa' kixu' Teb, nzhab bixa' midi'zh Teb tu kwa'n gat lë' por ley kwa'n mila' Dios lo Muisés, no por Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Se' mile' bixa' par miyi'xian rë men yezh ze'. Orze' mizhin pla xa' nak zhi'n kun zipla xa' nilu' ley che'n Muisés, par nguzen bixa' Teb. Orze' ngwala' bixa' Teb plo nzhin rë gustis xa' más nile' mandad. ");
INSERT INTO zcaNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","No lo rë gustis re' mizo bixa' pla miyi' kwa'n mikë' kixu' Teb, nzhab rë miyi' re': ―Xa' re', zilita' dox nakap nidi'zh xa' tich yado' nazhon che'n Dios, mbaino nidi'zh xa' gat lë' tich ley kwa'n mila' Dios lo Muisés. ");
INSERT INTO zcaNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","No mbin no midi'zh miyi' re': “Lë' Jesús xa' nzë Nazaret, chil yado' re', mbaino kubchi xa' rë kostumbr kwa'n mila' Muisés lo be.” ");
INSERT INTO zcaNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Orze', rë xa' kwa'n nile' mandad ze', xe mia'n bixa', niwi' bixa' lo Teb, no nilu' lo Teb nela lo tu ganj che'n Dios ga'. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Orze' minabdi'zh ngulëi' kwa'n más nile' mandad, nzhab xa' lo Teb: ―¿Chi walika, sa' midi'zhal? ");
INSERT INTO zcaNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Orze' mikab Teb, nzhab Teb: ―Rë go dad, mbaino wech, bin go rë kwa'n ganin lo go; lë' Dios Nazhon, ngurulo Me lo xuz be Abraham, or nzho xa' lazh men Mesopotamia, or antis di yo xa' lazh men Harán. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Per nzhab Dios lo Abraham: “Guro' lazhal no bila' rë melizhal, par yal plo ganin.” ");
INSERT INTO zcaNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Orze' nguro' Abraham lazh men Caldea, par yo xa' lazh men Harán. No ze' plo ngut xuz xa'. Orze' ñadnu Dios Abraham lo yuo plo nzho be nal re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Per nangaza't Dios ni tlë' yo ngal Abraham, ni plo zo tu ni' xa'. Per nzhab Dios, yuo ze' ka' rë men kwa'n gak ben che'n Abraham. No stubi, yent xin Abraham orze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Per nzhab Dios lo Abraham: “Lë' rë xa' gak ben che'nal gak men zit, lazh xtu ben men plo gak bixa' mos nado lo xtu men, lë' bine' le' zhi'n ter nane bine' lo rë men ze', no zakzi rë men ze' bixa', como tap gayo' li'n.” ");
INSERT INTO zcaNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","No nu nzhab Dios lo Abraham: “Per lë'da zakzi rë men xa' zakzi rë men kwa'n yi'd ben che'nal, no kon bixa' ya' rë xa' ze', par zuxib bixa' lon lo yuo re'.” ");
INSERT INTO zcaNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","No nzhab Teb: ―Mila' Dios di'zh lo Abraham. Mile' Dios mandad nkë señ kwerp che'n xa', no por señ re' nilu', walika mila' Dios di'zh par Abraham. No or ngol tu xga'n Abraham kwa'n ngurulë Isaac, no or nzhap Isaac xon ngubizh, mikë' Abraham señ re' kwerp che'n Isaac. Se'ska mile' Isaac kun xga'n Isaac kwa'n lë Jakob, no se'ga' mile' Jakob kun rë xga'n xa', rë xa' kwa'n ngok xuz dub tu dusen ben men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Per xid xga'n Jakob kwa'n ngok rë xuz be, nguio tu xa' lë Che, no lë' rë wech xa' ngok mbidios, mito bixa' Che lo tu xa' mbiy' Che lazh men Egipto; per Dios nzo kun Che. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Or nguzak Che rë kwa'n nalats dox lazh men Egipto, mile' Dios ngok Che tu men dox nzhak, mbaino tu men kwa'n dox wen niwi' Faraón lo, kuze' mizo Faraón Che par le' xa' mandad dub lazh men Egipto, no haxta nu mile' Che mandad rë nak kwa'n kinu Faraón. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’No or mizhin tu yalwin dox rë yezh che'n rë men Egipto, no rë yezh che'n rë men Canaán, orze' rë xuz be, xa' nzhala, dox nguzakzi bixa', yent kwa'n gao bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Per or mbin Jakob, nzho kwa'n gao men lazh men Egipto, orze' mixë'l Jakob pla xga'n xa' ze', primer wëlt. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","No or mirop wëlt ngwa bixa', orze' nzhab Che lo bixa', lë' Che nak wech bixa', orze' milibe' Faraón melizh Che. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Orze' dispwés, mile' Che mandad, ñë'd Jakob, xuz Che, no rë melizh xa', par Egipto, no di lo rë bixa' nak bixa' chon gal nzho chi'n men. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Orze' ña Jakob lazh men Egipto, ze' ngut xa' kun más rë xuz be, xa' tiemp. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Orze' más bixa' mbiy', wes che'n rë xa' kwa'n ngut re', par miga'che lo yuo Siquem, kwa'n nguzi' Abraham, lo rë xin Hamor plo nak yezh Siquem. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’No or nzha como tap gayo' li'n nzho rë xuz be xa' tiemp lazh men Egipto, nela xmod mila' Dios di'zh par Abraham, no miar dox bixa' ze', ");
INSERT INTO zcaNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","orze' nguio xtu rey Egipto xa' gat nilibe't Che, nanet xa' kwan mile' Dios por Che. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Lë' rey re' mile' nakap lo rë xuz be. Mile' rey mandad, ngulubi bixa' rë nak më'do' xibyi' kwa'n laore ngol, par nayar ra' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Le'n rë ngubizh ze' ngol Muisés, no Dios nguio laxto' më'd. No chontsa mbëo' mixë'n xuz më'd, më'd. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","No or mila' nzë'b bixa' Muisés, lë' xcha'p Faraón mixë'n më'd, nela tu xmë'd xa' ga'. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Sa' ngok mitse'd Muisés rë nak kwa'n nzhak men Egipto, no ngok xa' tu miyi' dox natsin lo rë kwa'n midi'zh xa', no lo rë kwa'n mile' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’No or nzhap la Muisés cho' li'n, mbi'd yek xa', ngwatsi' xa', ma rë melazh xa', rë men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","No or une Muisés, kizakzi tu men Egipto tu rë men Israel, orze' ngwalat xa' xa' ze', mbaino migal Muisés xa' re', ");
INSERT INTO zcaNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","porke mile' Muisés xigab, pas nganu ka laxto' men Israel, lë' Dios lat bixa' por Muisés, per nanganut laxto' bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","No xtu riyë'l une Muisés, kidil chop men Israel, orze' nzhab Muisés lo bixa': “¿Chon kidil go?, gat went mis kun wech go dil go.” ");
INSERT INTO zcaNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Orze' nguzubi xa' nzhap dol re', miche'p xa' Muisés, nzhab xa': “¿Cho mizol par le'l mandad lo no, no par kube'l xid no? ");
INSERT INTO zcaNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Pas nzhaklal galal da, nela xmod migalal men Egipto na'g ze'.” ");
INSERT INTO zcaNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Or mbin Muisés kure', mikë' xa' karre, ña xa' lazh men Madián; ze' miban xa', no ngok xa' tu men kwa'n nzë xtu plo xid rë men ze', mbaino ngop xa' chop xga'n xa' ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Or nded cho' li'n, lo yuo bizh che'n mont Sinaí nguruxo'b tu ganj le'n bël che'n tu ya yich zobyol, ");
INSERT INTO zcaNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","no xe miwi' Muisés or une xa' ya nzobyol ze', orze' nguzubi xa' más gax par wi' xa' kwane, orze' midi'zh Dios lo xa', nzhab Dios: ");
INSERT INTO zcaNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Na nak Dios che'n rë xuzal: Dios che'n Abraham, Dios che'n Isaac, no Dios che'n Jakob.” Orze' nguzublo nixiz Muisés di zhe'b, nangalistra' xa' lo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Orze' nzhab Dios: “Bila xkalyidal ni'l, porke plo nzol, dox nazhone. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Walika lë'da une xmod kizakzi rë men Egipto rë men da, no mbina rë yalne kwa'n kizakzi bixa'. Kuze' nzhala par gaknun bixa'. Nal, dë' re', par xëla lu Egipto.” ");
INSERT INTO zcaNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’No Muisés re', xa' gat nzhaklat bixa', or nzhab bixa': “¿Cho mizol par le'l mandad lo no, o par kube'l xid no?”, no xa' re', xa' mixë'l Dios como xa' le' mandad no xa' kwa'n gaknu bixa' por ganj kwa'n nguruxo'b le'n ya yich nzobyol ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","No por Muisés, mile' Dios nayax señ nazhon lazh men Egipto, mbaino ro' nitsdo' Naxne, mbaino lo yuo bizh plo nded bixa' dub cho' li'n. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","No mis Muisés re' nzhab lo rë men Israel: “Xid go kwe Dios tu miyi', xa' gak profet, di'zh xa' por Dios nela da ga', no naki'n gon go ro' xa' re'.” ");
INSERT INTO zcaNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","No Muisés re', xa' kwa'n nguio xid rë men che'n Dios plo nguzhin bixa' lo yuo bizh, no midi'zhnu xa' ganj yek yi' kwa'n lë Sinaí. Ze' mbin xa' widi'zh che'n Dios, Dios Me nilu' xmod ñal ban be, no widi'zh re' mite'd xa' lo be. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Per rë xuz be xa' nzhala, no maska bixa' ngon ro' Muisés, lë'la ngokla bixa' ngayëk bixa' xtu wëlt par lazh men Egipto. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Mbaino nzhab bixa' lo Aarón, or ngwa Muisés xche yek yi' Sinaí: “Bizuxkwa' go pla dios par lu' nez lo no, porke Muisés re' kwa'n ngulo' no lazh men Egipto, nanet no ma xa'.” ");
INSERT INTO zcaNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Orze' michao' bixa' tu winab kwa'n nak nela tu bicerr ga', no mbit bixa' rë ma par miza' bixa' gon lo winab ze', par mile' bixa' tu lani por kwa'n michao' mis lë' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kuze' mila' Dios, nguzuxib bixa' haxta lo rë kwa'n nzho lo yibë', nela xmod nzobni' lo yech kwa'n mikë' rë profet, xa' midi'zh por Dios, se' mizobni' bixa': Go men Israel, ¿chi mbit go rë ma par Da? ¿Chi mine' go ren che'n rë ma, dub cho' li'n kwa'n mite'd go lo yuo bizh? ");
INSERT INTO zcaNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Per lë'la yën go mbiy' go yo' yid plo nzob winab che'n Moloc, no plo nzob winab che'n mbël kwa'n lë Renfán, rë winab kwa'n mis go michao' par nidi'zh go nazhone. Kuze' lë'da chubla go, lë' go bi más zit ke lazh men Babilonia. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’No lo yuo bizh plo nzhin bixa', kinu rë xuz be, xa' nzhala, tu yo' yid, kwa'n ngok yado' che'n bixa'. Le'n ze' midi'zh bixa' lo Dios, nela xmod nzhab Dios lo Muisés, le' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Yo' yid ze' mia'nnu rë xuz be, xa' nzhala, or nguzhin bixa' lo yuo Canaán. Orze' Josué mia'n xlugar Muisés, no por Josué, ngulat bixa' yuo ze' lo rë men nzhin Canaán. No dub nguio rë xuz be lo yuo Canaán, guna'b bixa' lo Dios le'n yo' yid ze', haxta or ngok Dabi rey lo bixa', une guna'b bixa' lo Dios le'n yo' yid ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Por wen miwi' Dios lo rey Dabi, kuze', nzhab Dabi lo Dios: “Nzhaklan kuxkwa'n tu lugar par lu, Dios che'n Jakob.” ");
INSERT INTO zcaNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Per Salomón mizuxkwa' yado' che'n Dios, ");
INSERT INTO zcaNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ter yo' kwa'n nichao' men, gat naki'nta' Diose par yo Dios, nela xmod nzhab ka tu profet, xa' midi'zh por Dios: ");
INSERT INTO zcaNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Yibë' nak plo nzo'ba, par nilen mandad, no lo yizhyuo nak plo nizo ni'n. ¿Xmod nak yo' kwa'n kuxkwa' go par da? O, ¿ma lugar kwa'n ne' go par len diskans?, ");
INSERT INTO zcaNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","porke na mizuxkwa' rë kure', yizhyuo no yibë'. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","No nu nzhab Teb: —Per go, ¡zhe'b nad yek go! Nangont go widi'zh che'n Dios, porke nayao' nzha go no laxto' go. Dubta' gat nzhont go kwa'n nidi'zh Sprit che'n Dios, no nak go nela ngok rë xuz go, xa' nzhala. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mizakzi rë xuz go rë profet, xa' midi'zh por Dios. Haxta mbit rë xuz go rë xa' kwa'n mila' widi'zh re': “Lë' Dios xë'l tu Xa' kwa'n le' rë kwa'n gab Dios.” No nal, Xa' re' mbi'd la, ¡per michi go Xa' lo rë xa' kwa'n mbit Xa'! ");
INSERT INTO zcaNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","No go re', xa' kwa'n mia'nnu ley kwa'n miza' ganj che'n Dios lo Muisés, per nangale't go kwa'n nzhakla ley. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Or mbin bixa' widi'zh re', dox niyi'xian bixa', haxta mitao' lëi bixa' por kwa'n nzhab Teb. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Per lë' Teb, nzho dox Sprit che'n Dios laxto' xa', no miwi' xa' lo yibë', une xa' biani che'n Dios, maska ña'zbële, no Jesukrist nzo lad direch che'n Xuz Me Dios, ");
INSERT INTO zcaNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","orze' nzhab Teb lo bixa': ―¡Biwi' go!, lë'da niwi' lë' lo yibë' naxa'l; no lë' Xga'n Dios Me kwa'n nak ska tu men yizhyuo, nzo la direch che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Orze', naye ngurezhië rë men nzhin ze', no mitsao' bixa' nzha bixa', orze' rë bixa' tutsa mile' bixa' xigab, nguxo'b bixa' tich Teb, ");
INSERT INTO zcaNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","orze' ngulo' bixa' Teb ro' yezh, par nguluke bixa' Teb; no rë xa' kwa'n mbin kwa'n nzhab Teb re', ngulo' bixa' kaxkem che'n bixa', no ngwala' bixa'i lo tu miyi' xi xa' lë Saulo. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","No dub kigo ke bixa' Teb, naye midi'zh Teb lo Dios, nzhab Teb: ―O Señor Jesús, bi'y alm da. ");
INSERT INTO zcaNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Orze' nguzuxib Teb, nzhab Teb naye: ―¡O Señor, nana'btal kwent lo bixa' por rë yalki kwa'n kile' bixa' nal re'! Or milox midi'zh Teb kure', ngut xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Tutsa nak xigab che'n Saulo kun rë xa' mbit Teb. Mis zhë re', nguzublo nguzakzi dox rë men che'n Jesukrist xa' nzho yezh Jerusalén. Orze' nzho bixa' mire'ch par rë yezh kwa'n ña'n lazh men Judea, no más bixa' ña rë yezh kwa'n ña'n lazh men Samaria; no nab tsa rë apost mia'n yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","No pla rë men xa' nzhon ro' Dios, mika'ch bixa' kwerp che'n Teb, no dox mbi'n bixa' por Teb. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Per Saulo nguzublo kizakzi rë men xa' nak men che'n Jesukrist, rë xa' kwa'n nzho yezh Jerusalén; ño xa' yo' por yo', una'i miyi'y nizubxax xa', mbaino nigo xa' men lizhyi'b. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","No lë' rë men che'n Jesukrist kwa'n mire'ch ze', kidi'zh bixa' widi'zh nazhon che'n Dios por Jesukrist rë plo. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Tu xa' ze' lë Lip, ngwa xa' tu rë yezh kwa'n ña'n lazh men Samaria; ze' nguzublo kidi'zh xa' widi'zh che'n Jesukrist lo rë men ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","No rë men yezh ze', tutsa plo nigan bixa' par nzhon bixa' rë widi'zh kwa'n nidi'zh Lip, por rë señ nazhon kwa'n nine bixa' nile' Dios por Lip. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Miak nayax xa' nzho mbi mal laxto', no or niro' rë mbi ze', haxta naye nibizhyëi; no nayax men xa' nagakt win ñak bixa', mbaino nayax men xa' nagakt zë nizë bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kuze' dox nizak laxto' rë men yezh ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","No yezh Samaria re', nzho tu miyi' xa' lë Simón, dizde nzhala, nzhak xa' kwa'n mal, no nikide xa' rë men yezh re', nidi'zh xa' lë' xa' dox nzhak. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Rë men yezh ze', dizde më'd win haxta rë mengol, xe nine bixa' kwa'n nile' Simón, no nidi'zh bixa': ―Xa' re'se, kinu poder che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","No dizde nzhala, nazhe'b nile' rë men lo xa', por rë señ kwa'n nile' xa' por nzhak xa' kwa'n mal, ");
INSERT INTO zcaNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","per or midi'zh Lip lo rë men, xmod yo bixa' ya' Dios, mbaino xmod ban bixa' bid kwa'n niza' Jesukrist, no ngwayila bixa'i, ngoklëi' bixa' le'n nits, miyi'y no una'i. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","No nu ska Simón, xa' nzhak kwa'n mal re', ngwayila widi'zh re', orze' ngoklëi' xa' le'n nits, no ñakë xa' tich Lip rë plo ña Lip, mbaino xe ña'n xa' tuli or nine xa' rë kwa'n nazhon kwa'n nile' Dios por Lip. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Or mbin rë apost, rë xa' kwa'n mia'n yezh Jerusalén, lë' nu rë men Samaria ñila widi'zh che'n Dios por Jesukrist, orze' mixë'l bixa' Per kun Juan yezh Samaria re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Or mizhin Per kun Juan ze', mina'b bixa' lo Dios por rë xa' nzhin ze', xa' ñayila widi'zh che'n Jesukrist, par yo Sprit che'n Dios laxto' bixa', ");
INSERT INTO zcaNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","porke stubi gat yo Sprit che'n Dios laxto' bixa', nab tsa ngoklëi' bixa' le'n nits nela xmod mile' ka Señor Jesús mandad. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Orze' mixo'b Per kun Juan ya' bixa', yek rë xa' re', par nguio Sprit che'n Dios laxto' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","No or une Simón, ka nixo'b rop apost, ya' bixa' yek rë men ze', orze' ño Sprit che'n Dios laxto' rë xa' re', orze' mizë'b Simón dimi lo rë apost, ");
INSERT INTO zcaNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","no nzhab xa': ―To go poder ba' kan, nes par nu da, or xo'ba ya'n yek rë men, yo Sprit che'n Dios laxto' men. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Per nzhab Per lo xa': ―¡Lox xtimil kun lu! ¿Kwan gabal, kun dimi zi'l kwa'n niza' Dios? ");
INSERT INTO zcaNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Gat ñalta'l le'l kwa'n nile' no, porke gat nambet laxto'l lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Naki'n la'l, nale'tra'l xigab mal ba', no bina'b lo Dios, pas kinkitla nabei, che' Dios rë kwa'n nzë'bxkil, por rë xigab kwa'n nzho laxto'l ba'. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nal niwi'n, nagakt la'l, rë kwa'n gat lë' kwa'n nzho laxto'l ba'. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Orze' nzhab Simón lo bixa': ―Guna'b go lo Dios por da, par nazhin ni tu rë kwa'n ne go ba' lon. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","No or milox midi'zh rop apost rë kure', nazhe'be chi nayo men ya' Dios, mbaino or milox midi'zh bixa' kwa'n milu' Señor Jesukrist, orze' ña bixa' par Jerusalén, mbaino biña bixa' nez, kidi'zh bixa' widi'zh che'n Dios por Jesukrist rë yezh kwa'n ña'n lazh men Samaria. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Dispwés di kure', nzhab tu ganj che'n Dios lo Lip: ―Nayen wa nez kwa'n niro' nali laka yezh Jerusalén no yezh Gaza. No nez re' nided plo nak pura yuo bizh. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Orze' nzha Lip, lë'chi mizhë'l xa' tu men nzë lazh men Etiopía, tu xa' nagakt gap una'. No xa' re' naka' kwent niguchao' dimi che'n rreyna Candace, tu una' kwa'n nile' mandad lo rë men etiope. No lë' miyi' re', ngwa yado' Jerusalén, par ngwazuxib xa' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","No se' ñë'd la xa' par ña xa' lazh xa', nzob xa' le'n karret che'n xa', no kiyo'l xa' yech kwa'n mikë' profet Isaías, tu xa' kwa'n midi'zh por Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Orze' nzhab Sprit che'n Dios lo Lip: ―Guzubi ta' karret ba'. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","No or nguzubi Lip ta' karret re', orze' mbin Lip, lë' xa' etiope re' kiyo'l yech kwa'n mikë' Isaías, orze' nzhab Lip lo xa' re': ―¿Chi kizobyek ka go kwa'n kiyo'l go ba'? ");
INSERT INTO zcaNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Orze' nzhab xa' re': ―¿Xmod ganen kwan nzhabe chi niyent cho lu'i lon? Orze' nzhab xa' lo Lip, kili Lip plo nzob xa', par zob Lip ta' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","No yech kwa'n kiyo'l xa', nzhab se': Ngut xa', nela nzhat tu mbëkxi'l ga', no or mizakzi men xa', ni tu widi'zh nangabt xa' lo rë xa' mbit xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Mile' men kwa'n nzhakla men kun lë' xa', no yent cho ngadi'zh por lë' xa', mbaino nala't xa' ben che'n xa', porke lë' bid che'n xa' ngulubchi men yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Orze' minabdi'zh men etiope re' lo Lip, nzhab xa': ―Le'l jabor nel, ¿cho xa' kize't profet, xa' kwa'n nzob lo yech re'? ¿Chi mis lë' profet nguzake, o xtu mene? ");
INSERT INTO zcaNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Orze' nguzublo Lip, kilu' kwa'n nzob lo yech ze', no milu' Lip rë widi'zh nazhon che'n Dios por Jesukrist lo xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","No or nded bixa' tu plo nikë nits, nzhab xa' re' lo Lip: ―Re' nikë nits. ¿Chi zak gaklëi' da re'? ");
INSERT INTO zcaNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Orze' nzhab Lip: ―Chi lë'l walika ñilai, gak gaklëi'yal re'. Orze' nzhab xa' re': ―Na ñila, lë' Jesukrist nak Xga'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Orze' mikwë'z xa' karret che'n xa', no ngula rop bixa' le'n nits, orze' mililëi' Lip xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","No or nguro' bixa' le'n nits, di repent ñanu Sprit che'n Dios Lip, no nganetra' xa' re' Lip, orze' ña xa', no nizak laxto' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Mbaino nguruxo'b Lip haxta yezh Azoto, kidi'zh xa' widi'zh nazhon che'n Dios por Jesukrist lo rë men, haxta or mizhin xa' yezh Cesarea. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Per stubi ra' nidi'zh Saulo, lë' xa' gut rë men che'n Jesukrist, kuze' ngwa xa' lo rë ngulëi' ro', ");
INSERT INTO zcaNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","par ngwalo' xa' tu yech kwa'n kinu permis, par yala' xa'i lo rë xa' nile' mandad le'n rë yo' plo nitse'd rë men Israel widi'zh che'n Dios yezh Damasco, par yatsen Saulo rë men che'n Jesukrist kwa'n nzhin ze', miyi'y no una'i, par wei' Saulo bixa' yezh Jerusalén par yo bixa' lizhyi'b. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Or nzhazhin la Saulo yezh Damasco kun rë men xa' nzha xa' kun lë', lë'chi nguluxo'b tu ki dizde lo yibë' kwa'n mizini nayi' al naka'n plo nzhazë bixa', ");
INSERT INTO zcaNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","orze' ngwachin Saulo lo yuo, mbaino mbin xa' tu widi'zh kwa'n nzhab lo xa': ―¡Saulo, Saulo! ¿Chon kirukël ticha par dilal kun na? ");
INSERT INTO zcaNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Orze' nzhab Saulo: ―¿Cho lu, Señor? Orze' nzhab widi'zh re': ―Na Jesús kwa'n kirukël tich, mbaino kidilal kun lë'; chi lë'l dil kuna, lo mis lu kikwa'n yalne che'nal. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Orze' maska nixiz xa' di zhe'b, orze' nzhab xa': ―Señor, ¿kwan nzhakla go len? Orze' nzhab widi'zh ze': ―Waxche, no wa yezh Damasco; ze' ne tu xa' kwan ñal le'l. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","No rë xa' nzha kun Saulo, xe mia'n bixa' tuli, nangaktra' ngadi'zh bixa'; mbin bixa' widi'zh ze', per yent cho ngane bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","No or ngwaxche Saulo lo yuo, mikal lo xa' tuli. Orze' men nguzen ya' xa', par mizhin xa' yezh Damasco. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ze' nguio xa' chon ngubizh, no nikal lo xa', nangaot xa', mbaino ni nits nangot xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","No yezh Damasco nibëz tu men che'n Jesukrist xa' lë Ananías. Ngurulo Jesukrist lo xa' re' kun widi'zh re': ―¿Mal Ananías? Orze' nzhab Ananías: ―Lë'da re', Señor. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Orze' nzhab Jesukrist: ―Nayen wa nez kwa'n lë Direch, plo nzob lizh Judas. Ze' bina'bdi'zh por tu xa' lë Saulo, tu xa' kwa'n nzë yezh Tarso; porke mer kina'b xa' re' lon nalre', ");
INSERT INTO zcaNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","no lë' Dios milu' la lo Saulo, tu miyi' xa' lë Ananías xo'b xa' ya' xa' yek Saulo par yani lo xa' xtu wëlt. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Or milox mbin Ananías widi'zh re', orze' nzhab Ananías: ―Per Señor, dox nzhona, lë' miyi' ba' nizakzi rë xpenal, rë xa' kwa'n nzho yezh Jerusalén, ");
INSERT INTO zcaNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","no nu re', kinu xa' permis che'n rë ngulëi' ro, par ko xa' rë xpenal lizhyi'b. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Orze' nzhab Jesukrist: ―Wa, porke lë'da ngule la xa' re', par di'zh xa' xtizha lo rë men gat lë't men Israel, no lo rë rey, mbaino lo rë men Israel, ");
INSERT INTO zcaNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","porke lë'da lu lo miyi' ba', por da, dox naki'n zakzi xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Orze' ngwa Ananías plo nzho Saulo, no or mizhin xa', migal xa' Saulo, mbaino nzhab xa': ―¿Mal, wecha Saulo? Lë' mis Señor Jesús kwa'n ngurulo lol, or nzël nez, lë' Me mixë'l da par yani lol xtu wëlt, mbaino par yo Sprit che'n Dios laxto'l. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Mis orze', ngob rë kwa'n lo Saulo, rë kwa'n nak nela kwa'n nzho'b tich mbël ga', orze' ngok ngwani lo Saulo xtu wëlt. Orze' ngwatso xa' par ngoklëi' xa' le'n nits, ");
INSERT INTO zcaNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","mbaino ndao xa' par nka' la xa' xtu wëlt, no mia'n xa' zipla ngubizh kun rë men che'n Jesukrist kwa'n nzho yezh Damasco. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","No nguzublo kilu' Saulo widi'zh che'n Dios por Jesukrist le'n rë yo' plo nitse'd men widi'zh che'n Dios, yezh Damasco; ze' galo laka midi'zh Saulo lë' Jesukrist nak Xga'n Dios, Me nzho lo yibë'. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","No or mbin rë men kure', xe mia'n bixa' tuli, mbaino kidi'zh bixa': ―¿Chi gat lë't miyi' re', xa' kwa'n kizakzi rë men che'n Jesukrist xa' nzho yezh Jerusalén? ¿No chi gat lë't mis xa' re', xa' nzë re' par zen xa' rë men che'n Jesukrist, par wei' xa' bixa' lo rë ngulëi' ro? ");
INSERT INTO zcaNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Per Saulo, kad ngubizh más dub la xa', kidi'zh xa' widi'zh che'n Dios por Jesukrist; haxta mile' xa' net rë men Israel kwan le' xa', rë xa' kwa'n nzhin Damasco, porke milu' xa', walika lë' Dios mixë'l Jesús, Me kwa'n nak Krist. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nayax ngubizh nded, lë'chi tutsa mia'n rë men Israel kwa'n nzhin yezh Damasco, par gut bixa' Saulo, ");
INSERT INTO zcaNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","per mbin Saulo cho xigab nile' bixa', zhëy-yë'le kimbëz bixa', ro' rë pwert che'n yezh Damasco, par gut bixa' Saulo. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Per rë men che'n Jesukrist, yë'l ngulo' bixa' Saulo, ngulo bixa' Saulo le'n tu kardor, par mila bixa' Saulo xtu tich simient ke kwa'n nzho naka'n ro' yezh ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Or mizhin Saulo yezh Jerusalén, ngokla xa' ngabin xa' kun rë men che'n Jesukrist, kwa'n nzho ze', per nangayilat bixa', chi walika nak Saulo tu men che'n Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Orze' xtu men che'n Jesukrist xa' lë Bernabé, ngwanu xa' Saulo lo rë apost, no nzhab Bernabé lo rë xa' re': “Lë' Saulo une Señor or nzha xa' nez Damasco, no midi'zh Señor lo xa', mbaino yezh Damasco lë' Saulo midi'zh widi'zh che'n Dios por Jesús dub la xa'.” ");
INSERT INTO zcaNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Orze' mia'n Saulo yezh Jerusalén, nguzhin xa' kun rë men che'n Jesukrist kwa'n nzhin ze', no ni nangazheb xa' midi'zh xa' widi'zh che'n Dios por Jesukrist, ");
INSERT INTO zcaNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","no michëlro' Saulo kun rë men Israel kwa'n nidi'zh widi'zh grieg, per rë xa' re' kikwa'n mod par gut bixa' Saulo. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Or mbin rë men che'n Jesukrist kure', lwega' mbiy' pla bixa' Saulo par yezh Cesarea, di ze' ña xa' par yezh Tarso. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mbaino lë' rë men che'n Jesukrist kwa'n nzho yezh Judea, no yezh Galilea, mbaino kun rë xa' yezh Samaria, dox chul nzhin bixa', mbaino más nzharo'b xigab che'n bixa' lo rë che'n Dios, no más nzhon bixa' ro' Dios, naban bixa' nela xmod nzhakla Dios; no mile' Sprit che'n Dios, más miar bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","No or nikizë Per nayax rë yezh, ñatsi' xa' rë men che'n Jesukrist, orze' nu rë men che'n Jesukrist kwa'n nzho yezh Lida ngwatsi' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ze' nzho tu miyi' xa' lë Eneas. Nzha xon li'n, na'x xa' lo lo'n, nagakt win xa', ");
INSERT INTO zcaNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","orze' nzhab Per lo xa': ―Eneas, lë' Jesukrist miliwen lal. Waxche, no gulits lo'n che'nal. Lwega' ngwaxche Eneas, ");
INSERT INTO zcaNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","no rë men xa' nzho yezh Lida, kun más rë men xa' nzho tu lach kwa'n lë Sarón, or une bixa' miak Eneas, nu bixa' ngwayila widi'zh che'n Dios por Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","No le'n yezh kwa'n lë Jope, ze' nibëz tu men che'n Jesukrist, tu una' lë Tabita (widi'zh kwa'n gab Dorcas). Una' re', dub tiemp miban xa', mile' xa' wen, mbaino nzhaknu xa' rë men prob. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Le'n rë ngubizh ze', una' re' ngokne no ngut una'. Or milox mizët bixa' kwerp che'n una' re', orze' mbiy' bixa' kwerp che'n una' re' le'n tu kwart al ya, yek yo'. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","No mbin rë men che'n Jesukrist kwa'n nibëz yezh Jope, lë' Per nzo gax laka yezh Lida, gax laka par ze', orze' mixë'l bixa' chop miyi' kwa'n ngwayab lo Per, nzhab bixa': ―Le' go jabor, lwega' dë' go yezh Jope re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Or mizhin Per kun rop xa' re', mbiy' xa' Per yek yo' al ya plo nzho'b una' re', no rë una' ngut xmiyi' nzhin ze', nzho'n biuna' lo Per, no milu' biuna' rë lar kamis no bestid kwa'n mitib una' re' or naban ra' una'. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Mbaino nzhab Per, ro' rë xa' re' le'n kwart ze'. Orze' nguzuxib Per par mina'b xa' lo Dios, no or milox mina'b xa' lo Dios, miëk Per lo una' re', nzhab Per: ―Tabita, waxche. Orze' miwi' una', une una' Per; lwega' ngwaxche una', no nguzob una'. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Or nguzen Per ya' una', mizuli xa' una'. No or ngurezh Per rë una' xa' ngut xmiyi' ze', kun más rë men che'n Jesukrist kwa'n nzhin tich ze', ze' milu' Per, lë' una' nguruban. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","No rë men yezh Jope, mbin bixa' kwa'n nguzak Tabita, kuze' nayax men kwa'n nzho ze', ngwayila bixa' widi'zh che'n Dios por Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","No nayax ngubizh mia'n Per yezh Jope, lizh tu miyi' xa' lë Simón, tu xa' nizuxkwa' yid. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Le'n yezh Cesarea, nguio tu miyi' xa' lë Cornelio, tu xa' nile' mandad lo tu gayo' sondad italiano. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Dox wen xa' re', no wen rë melizh xa', mbaino nzhon xa' ro' Dios, no dox nzhaknu xa' nayax men Israel kun dimi che'n xa', no zilita' nina'b xa' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","No ngol tu ngubizh, paste las tres guzhe, ngurulo tu ganj che'n Dios plo nzo xa', nzhab ganj lo xa': ―¡Cornelio! ");
INSERT INTO zcaNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Orze' dox mizheb xa', xe miwi' xa', mbaino nzhab xa': ―¿Kwan nzhaklal, Señor? Orze' nzhab ganj: ―Rë kwa'n nina'bal lo Dios, no rë kwa'n nile'l nzhaknul rë men prob, nake nela tu gon kwa'n ño laxto' Dios ga'. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","No nal, bixë'l pla xpenal yezh Jope, par yaka' bixa' tu xa' lë Simón Per. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Xa' re' nzho lizh tu xa' lë Simón, tu xa' kwa'n nizuxkwa' yid, xa' re' nibëz gax laka ro' nitsdo'. Xa' re' ne kwan naki'n le'l. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","No or ña ganj kwa'n midi'zh kun Cornelio re', orze' ngurezh Cornelio chop mos che'n xa', kun tu sondad xa' nzhon ro' Dios, tu xa' kwa'n nzho xid rë xa' kwa'n nzhaknu xa' zilita'. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Orze' miza' xa' kwente lo rë xa' re', kwan nguzak xa', orze' mixë'l xa' rë miyi' re' par yezh Jope. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Xtu riyë'l, or nzhazë rë miyi' re', no nzhazhin la bixa' yezh Jope, no lë' Per nkë yek yo', paste ngol garol zhë, par na'b xa' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Mbaino nila'n Per, nzhakla xa' gao xa', no dub kiline men tu kwa'n gao xa', lë'chi milu' Dios tu kwa'n lo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Mixa'l lo yibë', orze' ngulayët tu kwa'n nak nela tu lar ro ga' haxta plo nzo Per, no kad skine nali'b. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Lo lar ro re' nikë rë klas ma kwa'n nizë kun rop ni' no rop ya', no rë ma kwa'n nizë nadu'b laxto', mbaino kun rë ma kwa'n nzob xi'l. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Orze' mbin Per tu widi'zh kwa'n nzhab se': ―Per, watso no bit rë ma re' no dao ma. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Orze' nzhab Per: ―¡A'a Señor!, lalta' gat ga̱u̱ tu kwa'n nayi' gao men nzhab Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Orze' xtu wëlt nzhab widi'zh ze' lo Per: ―Rë kwa'n mitsumbe la Dios, nagabtra'l nayi' gao mene. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Chon wëlt ngok kure', orze' nguiubre ska lar ro re' lo yibë'. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Dub net Per kwan le' Per por kwa'n une Per, lë'chi mis orze' mizhin rë miyi' kwa'n mixë'l Cornelio, kinabdi'zh bixa' plo nzob lizh Simón, mizhin bixa' ro' yo'. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Naye kinabdi'zh bixa', nzhab bixa': “¿Chi re' nzho tu xa' kwa'n lë Simón Per?” ");
INSERT INTO zcaNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Stubi kile' Per xigab por lar ro kwa'n une Per, lë'chi nzhab Sprit che'n Dios lo Per: ―Biwi', lë' chon miyi' kikwa'nal. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Watso no gula, wa lo bixa'. Nale'tal xigab, porke na mixë'l bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Orze' ngula Per, nzhab Per lo rë xa' re': ―Na xa' kwa'n kikwa'n go ze'. ¿Kwan ne go? ");
INSERT INTO zcaNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Orze' nzhab bixa': ―Lë' Cornelio mixë'l no, tu xa' kwa'n nile' mandad lo tu gayo' sondad, tu xa' menaye, no nzhon xa' ro' Dios, mbaino tu xa' wen ñët xid rë men Israel. Lo xa' re' ngurulo tu ganj kwa'n nzhab ya go lizh xa' ne, par gab go lo xa' kwa'n naki'n gab go. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Orze' mite'd Per bixa' le'n yo', mia'n bixa' ze' kun Per yë'l ze'. Orze' xtu riyë'l, nzha Per kun lë' bixa', no kun zipla men che'n Jesukrist xa' nzho yezh Jope mile' kumpañ Per. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","No xtu ngubizh, or mizhin bixa' yezh Cesarea, ze' lë' Cornelio mikan la rë melizh xa' kun zipla xa' dox nichë'l xa', kimbëz la bixa' zhin Per. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Or mizhin Per lizh Cornelio, nguro' Cornelio ngwakinez xa' Per, orze' nguzuxib xa' xani' Per, nzhab xa': “Dox nazhon go.” ");
INSERT INTO zcaNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Per militso Per xa', nzhab Per lo xa': ―Watsuli, porke tutsa nak ka be. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Bin kidi'zh Per kun lë' xa', ña bixa' le'n yo', une Per, nayax men nzhin la ze', ");
INSERT INTO zcaNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","orze' nzhab Per: ―Rë go nane, lo ley che'n men Israel, nagakt zhë'l tu men Israel kun tu men xa' gat lë't men Israel, no per ni gat ña bixa' lizh men ze'. Per Dios milu' lon, gat ñalt gapa lo ni tu men: “Men ba', gat niwi't Dios lo.” ");
INSERT INTO zcaNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kuze' lwega' nzhala or mile' bixa' abis lon, nangakta' da naya'. Per nal nzhaklan gona, ¿kwan ngurezh go da? ");
INSERT INTO zcaNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Orze' nzhab Cornelio: ―Nzha tap ngubizh, or nal ta' re', paste las tres guzhe, duba xlatsa kina'ba lo Dios, lë'chi ngurulo tu miyi' nak lar ña'zbël laka lon, ");
INSERT INTO zcaNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ne xa': “Rë kwa'n nina'bal, no rë kwa'n nile'l nzhaknul rë men prob, nake nela tu gon kwa'n ño laxto' Dios ga'. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","No nal, bixë'l pla men par yezh Jope, par yaka' bixa' tu xa' lë Simón Per. Xa' re' ne kwan naki'n le'l, xa' re' nzho lizh tu xa' kwa'n nibëz gax ro' nitsdo', tu xa' lë Simón, kwa'n nizuxkwa' yid.” ");
INSERT INTO zcaNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kuze' mixëla pla xa' lo go, par yi'dka' xa' go, no wen go nzëka go lo no. Lë' rë no nzhin re' lo Dios, nal nzhakla no gon no rë kwa'n mile' Dios mandad go, ne go. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Orze' nguzublo midi'zh Per, nzhab Per: ―Nal unen, walika, gat nibet Dios men, ");
INSERT INTO zcaNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","sino ke men nzhon ro' Dios no nile' bixa' kwa'n ñal, wen niwi' Dios lo bixa', wanei plo nzë xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","No kure' nak widi'zh kwa'n mila' Dios lo rë men Israel, or mixë'l Dios Jesukrist, Me kwa'n nile' mandad lo rë men. No por widi'zh re', nibin rë men wen kun Dios, wanei cho mene, xa' ñilai. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","No lë' go nane ka widi'zh re' mire'ch rë yezh che'n rë men Israel, galo laka kun rë men Galilea mire'che. Per antis di zublo re'ch widi'zh re', Juan midi'zh la, naki'n la' men rë kwa'n nakap kwa'n nak men, ban xa' xtu mod kun Dios, mbaino gaklëi' bixa' le'n nits. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","No nane go, ke lë' Dios miza' dox poder, mbaino miza' Dios Sprit che'n Dios yo laxto' Jesús, Me nzë yezh Nazaret; porke Dios nzo kun lë' Me, nkizë Me miliwen Me rë xa' nzhakne mbaino rë xa' kile' Mizhab bid naban. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Mbaino no, rë xa' kwa'n une, rë kwa'n mile' Jesús, lazh men Israel, no yezh Jerusalén, dispwés di mikë' bixa' Jesús lo krus par ngut Me. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Per mile' Dios nguruban Me ngubizh yon, no mile' Dios ngurulo Me lo no. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Per gat lë'ta' lo rë men ngurulo Me, sino lo nab tsa rë xa' kwa'n ngule Dios par ne rë kure'. No nak rë xa' kwa'n ndao no ngu' kun lë' Me dispwés di nguruban Me. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Mbaino Jesús mixë'l no par di'zh no lo rë men, ke lë' Dios ngule Jesús, par gab Me xmod gak kun kad men por kwa'n mile' bixa', men naban no men ngut. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","No rë profet, rë xa' kwa'n midi'zh por Dios, midi'zh la bixa' rë kure', ke rë men xa' yila Jesús, lë Dios che' rë kwa'n nzë'b xki bixa' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Stubi kidi'zh Per widi'zh re', lë'chi nguio Sprit che'n Dios laxto' kad bixa' kwa'n mbin widi'zh re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","No más rë men Israel, men che'n Jesukrist kwa'n nzë kun Per ze', mia'n xe bixa' tuli, or une bixa', lë' nu rë xa' gat lë't men Israel, nguio Sprit che'n Dios laxto', ");
INSERT INTO zcaNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","porke mbin bixa', kidi'zh rë men nzhin ze' lo Dios kun xtu ben di'zh, nzhab bixa', dox nazhon Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Orze' nzhab Per lo rë men Israel xa' nzhin ze': ―¿Chi zak gab be lo rë xa' ba', nagakt gaklëi' rë men re' le'n nits, rë xa' kwa'n nguio Sprit che'n Dios laxto', nela be ga'? ");
INSERT INTO zcaNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Orze' mile' Per mandad, ngoklëi' rë xa' re' le'n nits, nela mile' ka Jesukrist mandad. Orze' nzhab rë men ngoklëi' ze' lo Per: “Biya'n go pla ngubizh kun no.” ");
INSERT INTO zcaNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","No rë apost, kun más rë men che'n Jesukrist xa' nzhin rë yezh kwa'n ña'n lazh men Judea, mbin bixa' lë' nu rë men, xa' gat lë't men Israel, ngwayila widi'zh che'n Dios por Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Or miëk Per yezh Jerusalén, ze' nzho pla men che'n Jesukrist xa' nidi'zh, cho nzhakla gak men che'n Jesukrist, naki'n kë señ kwa'n lë circuncisión kwerp che'n xa', nela xmod nzob lo ley che'n men Israel. Rë xa' re' nzhab lo Per, gat lë't mile' Per por rë kwa'n nzob lo ley, ");
INSERT INTO zcaNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","nzhab bixa': ―¿Chon ngwatsi'l rë xa' gat nikët señ kwa'n lë circuncisión kwerp che'n, mbaino ndawal kun lë' bixa'? ");
INSERT INTO zcaNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Orze' midi'zh Per, dizde xmod ngok rë kwa'n une xa', nzhab xa': ");
INSERT INTO zcaNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Na nzho' yezh Jope, no or kina'ba lo Dios, orze' mixa'l lo yibë', milu' Dios tu kwa'n lon, nzhalayët tu kwa'n nela tu lar ro ga' plo nzon, no kad skine nali'b. ");
INSERT INTO zcaNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Orze' xe miwi'n loi, no loi nikë rë nak ma kwa'n nizë kun rop ni' no rop ya', no rë ma kwa'n nzho dan, mbaino rë ma kwa'n nizë nadu'b laxto', no rë ma kwa'n nzob xi'l. ");
INSERT INTO zcaNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Orze' mbina tu widi'zh kwa'n ne lon: “Per, ngwaxche bit pla ma re', mbaino dao ma.” ");
INSERT INTO zcaNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Orze' nzhapa: “¡A'a Señor, lalta' gat ga̱u̱ tu kwa'n nzhab ley che'n men Israel nagakt gao met!” ");
INSERT INTO zcaNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Orze' ne widi'zh ze' lon wëlt rop: “Rë kwa'n mitsumbe la Dios, nagabtra'l nagakt gaole.” ");
INSERT INTO zcaNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Chon wëlt mbina widi'zh re', orze' ña ska lar ro ze' lo yibë', ");
INSERT INTO zcaNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","lë'chi mizhin chon miyi' ro' yo' plo nzho'n. Nzë bixa' dizde yezh Cesarea par nzaka' bixa' da. ");
INSERT INTO zcaNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Orze' ne Sprit che'n Dios lon: “Wa kun rë miyi' ba', yent cho xigab le'l.” No nu za xo'p wech be re', rë no ngwa lizh xa' kwa'n gat lë't men Israel re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Orze' miza' Cornelio kwent lo no, xmod ngurulo tu ganj che'n Dios lo xa', nzho xa' lizh xa', nzhab ganj ze' lo xa': “Bixë'l pla men yezh Jope, par yaka' bixa' tu xa' lë Simón Per, ");
INSERT INTO zcaNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","xa' re' ne lol, xmod le'l par nazakzi Diosal no rë xa' lizhal por kwa'n nzë'b xki go lo Dios.” ");
INSERT INTO zcaNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Orze' nguzublon kidizha widi'zh che'n Dios por Jesukrist lo rë xa' kwa'n nzhin ze', no nguio Sprit che'n Dios laxto' bixa', nela xmod nguio Sprit che'n Dios laxto' be galo laka. ");
INSERT INTO zcaNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Orze' mitsilan widi'zh kwa'n midi'zh Jesukrist lo be or ne Me: “Lë' Juan mililëi' men kun nits, per go gaklëi' kun Sprit che'n Dios.” ");
INSERT INTO zcaNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","No chi lë' Dios miza' Sprit che'n Me, yo laxto' rë men ze', nela mine' Dios Sprit che'n Dios yo laxto' be, or ngwayila be Señor Jesukrist, orze', ¿cho da par gapa lo Dios: “Naza'tal Sprit che'nal yo laxto' rë men ba'”? ");
INSERT INTO zcaNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Or mbin rë men che'n Jesukrist ze', rë xa' kwa'n nidi'zh kë señ kwerp che'n men, rë widi'zh kwa'n nzhab Per re', yentra' kwa'n ngab bixa', sino ke midi'zh bixa', nazhon Dios, mbaino nzhab bixa': ―¡Tatu nu rë men gat lë't men Israel, nguziyël Dios, niza' Dios xtu mod ban bixa' chi lë' bixa' la' rë kwa'n gat lë' nile' bixa' lo Dios! ");
INSERT INTO zcaNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Or ngut Teb, orze' mire'ch rë men che'n Jesukrist rë yezh. Nzho bixa' ña lazh men Chipre, no nzho bixa' ña lazh men Fenicia, no más bixa' ña yezh Antioquía. Nangadi'zhtra' bixa' widi'zh che'n Dios por Jesukrist más lo más rë men, sino ke nab tsa lo rë men Israel midi'zh bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Per nzho pla men che'n Jesukrist xid bixa' kwa'n nzë lazh men Chipre, mbaino rë xa' nzë lazh men Cirene. Or mizhin bixa' yezh Antioquía, ze' midi'zh bixa' widi'zh che'n Dios por Jesukrist, mbaino nu lo rë xa' nidi'zh widi'zh grieg midi'zh bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nayax dox rë men ze' kwa'n gat lë't men Israel, ngwayila bixa' widi'zh che'n Dios por Jesukrist, porke ngoknu Dios rë men che'n Jesukrist, or midi'zh bixa' widi'zh che'n Dios lo rë men re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Or mbin men che'n Jesukrist, rë xa' kwa'n nzho yezh Jerusalén kure', mixë'l bixa' Bernabé par yezh Antioquía. ");
INSERT INTO zcaNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","No or une Bernabé, rë kwa'n wen nile' Dios xid rë men gat lë't men Israel, nizak laxto' xa', no nzhab xa': ―Tutsa xigab bile' go, no dubta' bile' go kwa'n nzhakla Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Se' mile' Bernabé par más mixobla bixa' Dios, porke Bernabé, tu xa' dox wen, no dox nzho Sprit che'n Dios laxto' xa', no dox ñila xa' widi'zh che'n Dios, kuze' dox men nguzubi lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","No dispwés di kure', ngwa Bernabé yezh Tarso, par ngwakwa'n xa' Saulo. ");
INSERT INTO zcaNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","No or ngwazhël Bernabé Saulo, orze' ñë'dnu xa' Saulo par yezh Antioquía. Ze' mia'n bixa' tu li'n kun rë men che'n Jesukrist kwa'n nzho yezh ze', no milu' bixa' widi'zh che'n Dios por Jesukrist lo nayax men. Yezh Antioquía, plo galo laka ngurulë rë men che'n Jesukrist, kristian. ");
INSERT INTO zcaNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Le'n rë ngubizh ze', pla profet, xa' kwa'n nidi'zh por Dios, nguro' bixa' yezh Jerusalén, par ngwa bixa' yezh Antioquía. ");
INSERT INTO zcaNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Tu rë xa' re' lë Agabo, ngwatso xa' midi'zh xa' por Sprit che'n Dios, nzhab xa': “Lë' tu yalwin dox yo yizhyuo”, no se'ka ngoke. Yalwin re' nguio or nak Claudio rey ro. ");
INSERT INTO zcaNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Orze', lë' rë men che'n Jesukrist kwa'n nzho yezh Antioquía, mia'n bixa' di'zh kad bixa' za' dimi kwa'n zu' bixa', par gaknu bixa' rë men che'n Jesukrist kwa'n nzho lazh men Judea. ");
INSERT INTO zcaNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","No se' mile' bixa', lë' Bernabé no Saulo ngwala' rë dimi kwa'n migan ze' lo rë xa' nzo lo rë men che'n Jesukrist kwa'n nzho lazh men Judea. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Le'n rë ngubizh ze', lë' rey Herodes nguzublo kizen pla men che'n Jesukrist par yo bixa' lizhyi'b, nes par zakzi rey Herodes bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Orze' mile' Herodes mandad ngut Jakob, wech Juan, kun spad. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","No or une Herodes, dox nguio laxto' rë men Israel kure', kuze' nu Per mile' xa' mandad, ngwaga', par nguio lizhyi'b. Kure' ngok rë zhë or nzhao rë men Israel pan kwa'n niyent levadur, or nzhal lani Pask. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Dispwés di ngwaga' Per, orze' ngulo Herodes Per lizhyi'b, plo kikina tap grup sondad, tap ga' sondad kad grup. Mile' Herodes xigab chi xa' Per lo rë men, or lox ded lani Pask. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","No lë' Per nikë lizhyi'b plo dox kikina xa', per rë men che'n Jesukrist zilita' kina'b lo Dios por Per. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","No mis yë'l par yanilyuo xtu ngubizh, or chi Herodes Per lo rë men, naxnaa Per lad che'n chop sondad, nali'b xa' kun chop kaden, no lë' zipla sondad kikina ro' pwert lizhyi'b. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Lë'chi ngurulo tu ganj che'n Dios, orze' dub le'n lizhyi'b ngwani, no migal ganj ta' Per, par nguro' mika'l lo xa', orze' nzhab ganj: ―¡Nayen waxche! Orze' lwega' mixëk kaden rop lad ya' Per, ");
INSERT INTO zcaNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","orze' nzhab ganj: ―¡Gok xabal, no bikë' kwa'n ni'l! Orze', se' mile' Per, no nzhab ganj: ―¡Gok kaxkem che'nal, no dikë ticha! ");
INSERT INTO zcaNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Orze' nzhakë Per tich ganj, net Per chi waliy o gat walit kwa'n kizak Per; zak Per ka kicha' laxto' Per. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nded bixa' tu ro' pwert, no or nded bixa' pwert rop lugar plo kikina sondad; or mizhin bixa' ro' pwert yi'b kwa'n nina le'n nez, nabe mixa'l ro'i, nguro' bixa'. Or zit la ñazë bixa', orze' mila' ganj, nab Per ña. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Orze' une Per, walika rë kwa'n kizak Per, orze' mile' Per xigab le'n laxto' Per: ―Nal unen, walika lë' Dios mixë'l tu ganj che'n par ngoknu da, par nguro'n ya' Herodes, no lo rë kwa'n mile' men Israel xigab ngale'nu xa' da. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Or milox une Per, walika rë kwa'n kizak Per, orze' ña xa' lizh Mari xna' Juan Mark, plo nzhin nayax men che'n Jesukrist, kina'b bixa' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Mikwe'zh Per ro' pwert, kwa'n nina le'n nez, orze' tu una' xi kwa'n lë Rode, ngwatsi' nabei choi. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Or mbin una' chi Per, no por tanta nizak laxto' una', nangaxa'lta' una'i; karre miëk una', ngwayab una', lë' Per nzo ro' pwert. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Orze' nzhab rë men nzhin ze' lo Rode: ―¡Pas nzhak miyizhal!, ¿kwan kidi'zhal? Per garga'l kiyab una'i, orze' nzhab bixa': ―Ka ganj che'n Pere. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Per stubi kikwe'zh Per ro' yo', no or mixa'l bixa' ro' yo', une bixa' walika lë' Pere, xe mia'n bixa' tuli. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Orze' milu' Per tu señ kun ya' Per lo bixa', par yentra' cho di'zh tuli, par nzhab Per xmod ngulo' Dios Per lizhyi'b, mbaino nzhab Per lo bixa': ―Guzh go kure' lo Jakob, no lo más rë wech be. Orze' nguro' Per, ña xa' xtu plo. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Or ngwanilyuo xtu riyë'l, dox mizheb rë sondad, kichëlro' bixa' por nanet bixa' ma Per. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Orze' lë' Herodes mile' mandad ngwakwa'n rë sondad Per; per nangazhëlt bixa' Per. Or milox minabdi'zh Herodes lo rë sondad ma Per, orze' mile' xa' mandad, ngut rë sondad xa' nki'na ze'. Orze' nguro' Herodes yezh kwa'n ña'n lazh men Judea, par ña xa' yezh Cesarea, ze' miban xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes dox niyi' xa' nine xa' rë men yezh Tiro no rë men yezh Sidón. Rop rë yezh re', tutsa mia'n rë men re', ngwadi'zhnu bixa' tu xa' lë Blasto, tu xa' nak tu zhi'n ro lo Herodes. Por xa' lë Blasto re', mile' rë men yezh re' gan kwa'n nzhakla bixa', diltra' Herodes kun lë' bixa', porke lazh Herodes ñazi' bixa' kwa'n nzhao bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","No or ngol ngubizh kwa'n mia'n bixa' di'zh, di'zh Herodes lo bixa', ngok Herodes lar wen kwa'n nzhak xa' or nile' xa' yalgustis, orze' nguzob xa' plo nile' xa' yalgustis; no midi'zh xa' kwa'n naki'n gab xa', lo rë men nzhin ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Orze', nguzublo kibizhië rë men nzhin ze', nzhab bixa': ―¡Xa' kidi'zh re', diose, gat lë't mene! ");
INSERT INTO zcaNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","No mis orze', tu ganj che'n Dios mile' nzhakne Herodes, por nangab Herodes lo rë men: “Net go nazhon da; nab tsa lo Dios ñal widi'zh ba'”; kuze' ngut xa', maska miyëz nidal xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Mbaino rë men nzhon widi'zh che'n Dios por Jesukrist, más kiyar bixa', rë plo kire'ch widi'zh che'n Dios por Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","No or milox ngwala' Bernabé kun Saulo dimi yezh Jerusalén kwa'n mikan bixa', orze' ña bixa' yezh Antioquía, no ñanu bixa' Juan Mark. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Xid rë men che'n Jesukrist xa' nzho yezh Antioquía, nzho xa' nak profet, xa' kwa'n nidi'zh por Dios, no nzho xa' nak maestr, xa' kwa'n nilu' widi'zh che'n Dios lo men. Tu rë xa' re' nak Bernabé, no Simón Triyeñ, no Lus, xa' nzë yezh Cirene, mbaino xa' lë Manaén, xa' kwa'n mixen tutsa kun gobiernador Herodes, xa' kwa'n mile' mandad lazh men Galilea, mbaino nu Saulo nzho xid rë xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","No ngol tu ngubizh, dub kile' bixa' kult lo Dios, mbaino kina'b bixa' lo Dios dub xlats bixa', orze' nzhab Sprit che'n Dios lo bixa': ―Gulo' go Bernabé kun Saulo part, par kë bixa' zhi'n da, porke par kure' ngulen bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","No or milox mina'b bixa' lo Dios dub nzo bixa' xlats bixa', mixo'b rë xa' re' ya' bixa' yek Bernabé no yek Saulo, orze' nzhab bixa', le' Bernabé no Saulo, kwa'n nzhab Sprit che'n Dios ñal le' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Orze' Bernabé no Saulo nzhanu Sprit che'n Dios bixa', par yezh Seleucia kwa'n nzhin ro' nitsdo', no ze' nkë bixa' bark par nzha bixa' Chipre, kwa'n nzhin tsao' nitsdo'. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","No or mizhin bixa' pwert plo lë Salamina, ze' nguzublo milu' bixa' widi'zh che'n Dios por Jesukrist, le'n rë yo' plo nitse'd rë men Israel widi'zh che'n Dios. No nu Juan Mark, nzha kun lë' bixa', par gaknu bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Orze' nguro' bixa' pwert Salamina par nkizë bixa' dub lazh men Chipre, haxta mizhin bixa' xtu yezh kwa'n lë Pafos. Ze' mizhë'l bixa' tu men Israel xa' lë Barjesús, tu xa' bruj kwa'n nikide men; nzhab xa' nidi'zh Dios por lë' xa', per gat walite. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Bruj re' nichë'l kun gobiernador Sergio Paulo, xa' nile' mandad lazh men Chipre. No dox natsin gobiernador re'. Or mbin xa', lë' Bernabé kun Saulo nikizë ze', orze' ngurezh xa' rop xa' re', por nzhakla xa' gon xa' widi'zh che'n Dios por Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Per Barjesús kinu xtu lë, lë xa' Elimas (widi'zh kwa'n gab bruj); gat lë't midi'zh xa' por widi'zh che'n Dios por Jesukrist, porke gat nzhaklat xa' yila gobiernadore. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Per Saulo, xa' nu kinu xtu lë, lë Pab; mile' Sprit che'n Dios ngwani laxto' Pab, orze' xe miwi' xa' lo bruj re', ");
INSERT INTO zcaNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","nzhab Pab lo xa': ―¡Mbël goxa, kwa'n mal laxto', xin Mizhaba, kwa'n niyi' nine rë nak kwa'n wen che'n Dios! ¡Zilita' nikwa'nal mod, par tsinul rë nez nali che'n Dios! ");
INSERT INTO zcaNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nal nel kwan li'nu Diosal, lë' lol kal, nanetra'l biani che'n ngubizh tu tiemp. Mis orze', lwega' mikal lo xa', orze' maska nzha ya' xa', kikwa'n xa' cho zen ya' xa' par wei' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Or une gobiernador kure', ngwayila xa' widi'zh che'n Dios por Jesukrist, xe mia'n xa' tuli or une xa' xmod nak widi'zh che'n Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Orze' nkë Pab bark, kun más rë xa' nzha kun lë' xa'; orze' nguro' bixa' yezh Pafos kwa'n nzhin lazh men Chipre, par nded bixa' xtu lad ro' nits par nzha bixa' yezh Perge, kwa'n ña'n lazh men Panfilia. Ze' mila' Juan Mark bixa', ña Juan par yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Orze' nguro' Pab kun Bernabé yezh Perge par nzha bixa' yezh Antioquía kwa'n ña'n lazh men Pisidia. Ze' mizhin bixa' tu zhë sabd, zhë kwa'n nile' men Israel diskans. Nguio bixa' plo nitse'd rë xa' re' widi'zh che'n Dios, orze' nguzob bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","No or milox mbi'l men widi'zh kwa'n nzobni' lo ley, no lo yech kwa'n mikë' rë profet, rë xa' kwa'n midi'zh por Dios, orze' mixë'l xa' nile' mandad le'n yo' ze', pla xa' kwa'n ngwayab lo Pab no lo Bernabé: ―Wech; chi kinu go tu widi'zh wen par rë men re', gak di'zh goi nal re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Orze' ngwatsuli Pab, no mile' xa' señ kun ya' xa' lo rë men nzhin ze', par gon bixa' kwan di'zh Pab, orze' nzhab Pab: ―Bin goi rë men Israel, no rë go xa' nzhon ro' Dios, ter gat lë't men Israel go: ");
INSERT INTO zcaNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Lë' Dios che'n be ngule rë xa' kwa'n ngok xuz be nzhala, mile' Dios miar dox bixa' or miban bixa' lazh men Egipto, ngok bixa' men zit lo rë xa' ze', per ngol ngubizh ngulo' Dios bixa' lazh men Egipto kun poder che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","No dub cho' li'n mixek Dios nangont bixa' ro' Dios, ngok nayi'lazh bixa' or nguzhin bixa' lo yuo bizh. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","No milo'x Dios za gazh ben men, kwa'n nguzhin lo yuo che'n men Canaán, par ndi'z Dios rë yuo che'n rë men ze', par nka' rë xa' nzhala, xa' ngok ben che'n be. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Rë kure' midi'y como tap gayo' garol li'n. Dispwés, ngulo Dios rë xa' ngok jwes lo bixa', no haxta zhë che'n profet Samuel, une nguio jwes xid bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Orze' mina'b men Israel tu rey lo Samuel, par le' mandad lo bixa'. Kuze' mile' Dios ngok Saúl rey lo bixa'; no xuz Saúl ngurulë Kis, xa' kwa'n nzë ben che'n Benjamín; cho' li'n midi'y li'n che'n Saúl. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","No or ngulutin Dios Saúl, orze' mile' Dios ngok Dabi rey lo bixa'. No por Dabi re' midi'zh Dios se': “Lë'da ngule Dabi xga'n Isaí, porke lë' Dabi tu miyi' kwa'n naban nela xmod nzhaklan, mbaino tu xa' kwa'n le' rë kwa'n gapa.” ");
INSERT INTO zcaNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","No mis tu rë xa' kwa'n nzë ben che'n Dabi ngok Jesús, Me kwa'n mixë'l Dios par che' rë kwa'n nzë'b xki men Israel lo Dios, nela xmod mila' ka Dios di'zh ga'. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","No antis di xë'l Dios Jesús, lë' Juan midi'zh la widi'zh che'n Dios lo rë men Israel, nzhab Juan: “Bichë' go xmod nile' go xigab, no xmod naban go lo Dios, nale'tra' go kwa'n gat lë' lo Dios, no goklëi' go le'n nits.” ");
INSERT INTO zcaNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","No or mer milox la nkë Juan zhi'n nazhon che'n Dios, nzhab Juan lo rë men: “¿Cho nile' go xigab nak da? Gat lë't da nak Krist, per ticha nzë xtu xa' más tsak lon, per ni gat ñal da gak da tu mos che'n xa'.” ");
INSERT INTO zcaNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Orze' nzhab Pab: ―Wecha, rë go xa' nzë ben che'n Abraham, no rë go xa' nzhon ro' Dios, ter gat lë't men Israel go: Par be mixë'l Dios widi'zh re', par che' Dios rë kwa'n nzë'b xki be lo Dios, mbaino par ban be nela xmod nzhakla Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Pwes rë men xa' nzho Jerusalén, kun rë xa' kwa'n nile' mandad lo bixa', nangalibe't bixa' cho nak Jesús, mbaino ni nangazobyekt bixa' rë widi'zh che'n rë profet kwa'n nzho'l men rë zhë kwa'n nile' men Israel diskans. Kuze', mis lë' bixa' mile' ngok rë kwa'n nzobni' la, or michi bixa' Jesús lo rë men par ngut Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","No ter yent cho dol nzhap Jesukrist, par gat Me, per mina'b bixa' lo Pilat, rutin Jesús yizhyuo re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","No or ngok rë kwa'n nzobni' lo yech por Jesukrist, orze' mila bixa' kwerp che'n Me lo krus, orze' mika'ch bixa' Me. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Per mile' Dios nguruban Jesukrist, ");
INSERT INTO zcaNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","no nayax ngubizh, ngurulo Jesús lo rë xa' kwa'n nguzukë tich Me, or naban Me, dizde lazh men Galilea, haxta mizhin Me yezh Jerusalén. No rë xa' re' nzhudi'zh lo rë men, lë' Jesús nguruban. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’No nal, nu no nzadnu rë widi'zh nazhon rë lo go, widi'zh kwa'n mila' Dios lo rë xuz be xa' nzhala. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Rë kure' ngok la, une la be, rë be kwa'n nak ben che'n men mila' Dios di'zh re', or mile' Dios nguruban Jesús, nela xmod nzobni' ka lo Salmo kwa'n mirop kwa'n nzhab se': “Lu nak Xga'na. Nalzhë re' Na mizol, par nakal Xa' nile' mandad lo rëi.” ");
INSERT INTO zcaNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","No más plo midi'zh Dios nzobni', lë' Dios le' ruban Jesukrist, mbaino nzhab Dios nayotra' gat Jesukrist xtu wëlt, no ni nayëb kwerp che'n Me le'n ba', porke se' nzhab Dios: “Lë'da le rë kwa'n milan di'zh lo Dabi, rë kwa'n wali no rë kwa'n nazhon”, ");
INSERT INTO zcaNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","nela xmod nzob ska xtu plo lo Salmos, kwa'n nzhab: “Nala'tal yëb kwerp che'n Me Nazhon che'nal”, ");
INSERT INTO zcaNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","porke walika lë' Dabi, dispwés di mile' Dabi zhi'n nazhon che'n Dios xid rë men tiemp che'n xa', nela xmod mile' Dios mandad, orze' ngut xa', ña xa' plo nzho rë xuz xa', no miëb kwerp che'n xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Per lë' kwerp che'n Me kwa'n mile' Dios nguruban, nangayot ngayëbe. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","No rë go wech, nal naki'n ne go, kidi'zh no lo go: Por Jesukrist nizhe' rë kwa'n nzë'b xki men lo Dios, rë men kwa'n ñila Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Gat lë'ta' por gon men ley kwa'n mila' Dios lo Muisés nizhe' rë kwa'n nzë'b men lo Dios, sino ke nab tsa por ñila men Jesukriste. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Biwi' gox, par nazakt go, rë kwa'n midi'zh rë profet, rë xa' kwa'n midi'zh por Dios or nzhab bixa': ");
INSERT INTO zcaNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Biwi' rë gox kwa'n nixizhnu Da. Per ni nagakra' di'zh go di zhe'b, lë' go ya'n xe, haxta lox go tuli, porke rë ngubizh che'n go, lë' Da le tu zhi'n nazhon, mbaino ter za' men kwente lo go, per nayot yila goi. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","No or nguro' Pab kun Bernabé le'n yo' ze', nzhab men lo bixa': ―Sabd xtu sman, nzhakla no di'zh go kure' lo no xtu wëlt. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","No or milox nguzhin xa' le'n yo' ze', nayax rë men Israel no nayax rë men xa' gat lë't men Israel per nzhon bixa' ley kwa'n mila' Dios lo Muisés, orze' ngwayila bixa' widi'zh che'n Dios por Jesukrist, nzhakë bixa' tich Pab no tich Bernabé. Orze' nzhab Pab kun Bernabé lo bixa': ―Naya'lt laxto' go xmod ngurezh Dios go, por nazhi' Dios go. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Or ngol zhë Sabd ze', zhë kwa'n nile' men Israel diskans, nila' dub yezh ze' nguzhin par mbin bixa' widi'zh che'n Dios por Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Per or une rë men Israel xa' nak zhi'n, lë' dox men miza, orze' dox niyi'xian bixa', no nakap midi'zh bixa' tich kwa'n nidi'zh Pab, no unde bixa' Pab, ");
INSERT INTO zcaNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","per yent kwan ngazheb Pab kun Bernabé, sino ke nzhab bixa': ―Galo laka lo go, naki'n di'zh no widi'zh che'n Dios por Jesukrist, porke go men Israel. Per nal, mis go nzhap dol, porke mis go nile' naya', ban go bid kwa'n niza' Dios par dubta'. Per nal nzho ra' xa' nzhaklai, kuze' lë' no yalu' widi'zh che'n Dios lo xtu ben men, xa' gat lë't men Israel, ");
INSERT INTO zcaNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","porke se' mile' Dios mandad no, Dios Me kwa'n naban par dubta', ne Me: Lë'l xëla rë plo kwa'n nzhin men dub yizhyuo, par gakal nela tu biani ga' lo xtu ben men zit, par ro' bixa' lo kwa'n nzë'b xki bixa' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Or mbin rë men zit kure', dox nizak laxto' bixa', orze' nzhab bixa': “Dox nazhon widi'zh che'n Dios”; no ngwayila rë mene, xa' kwa'n ngule la Dios, par ban bid kwa'n niza' Dios par dubta'. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Se' ngok mire'ch widi'zh che'n Dios por Jesukrist rë yezh kwa'n nzhin naka'n ze', ");
INSERT INTO zcaNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","per rë men Israel xa' nak zhi'n kwa'n nzho yezh ze', miki'l bixa' rë una' kwa'n más nzhon ley che'n Muisés, rë una' xa' más tsak yezh ze', no kun rë miyi' kwa'n nile' mandad yezh ze'. Se' mile' rë men Israel yezh ze', par tutsa mia'n bixa' di'zh, orze' ngurukë bixa' tich Pab no tich Bernabé yezh ze', no par nayara' Pab kun Bernabé rë yezh kwa'n nzhin naka'n ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Orze' lë' Pab kun Bernabé, nguzhib bixa' ni' bixa', nela tu señ ga', par ne rë men Israel ze', lë' bixa' mile' naya' lo Dios. Orze' nguro' bixa' ze', Pab kun Bernabé, par ña bixa' yezh Iconio. ");
INSERT INTO zcaNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","No rë men che'n Jesukrist kwa'n nzho yezh Antioquía ze', dox nizak laxto' bixa', no dox nzho Sprit che'n Dios laxto' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","No or mizhin Pab kun Bernabé yezh Iconio, nguio bixa' le'n yo' plo nitse'd men Israel widi'zh che'n Dios, no milu' bixa' widi'zh che'n Dios por Jesukrist lo rë men nzhin ze'. No ze' nayax bixa' ngwayila widi'zh che'n Dios por Jesukrist, no xid rë xa' re' nzho men Israel, no dox nayax xa' gat lë't men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Per rë men Israel xa' gat ñilat widi'zh che'n Dios por Jesukrist, miki'l bixa' rë men xa' gat lë't men Israel, par le' bixa' nakap lo rë men che'n Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Kuze', mia'n Pab kun Bernabé yezh ze' tu tiemp xche, yent kwan ngazheb bixa', milu' bixa' widi'zh che'n Dios por Jesukrist lo rë men yezh ze'. Por rë señ nazhon kwa'n mile' Dios ya' Pab no ya' Bernabé, rë kwa'n mile' mia'n men xe tuli, milu' Dios walika nazhon rë widi'zh che'n Dios kwa'n nilu' Pab no Bernabé. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Per rë men yezh ze', chop ngok bixa'. Garol bixa' ño man che'n rë men Israel, rë xa' gat ñilat widi'zh che'n Dios por Jesukrist; no zigarol bixa' ño man che'n rop apost che'n Jesukrist, Pab no Bernabé. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Orze' tutsa mia'n rë men Israel kun zipla men gat lë't men Israel, mbaino kun rë xa' nak zhi'n yezh ze', ngokla bixa' ngazakzi bixa' Pab kun Bernabé, mbaino ngagoke bixa' rop xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Per or mbin Pab kun Bernabé kure', orze' mikë' bixa' karre, ña bixa' par yezh Listra, no yezh Derbe, kun más rë yezh kwa'n nzhin naka'n ze'; no rë yezh re', yezh Licaonia nile' mandade. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","No le'n rë yezh re', milu' bixa' rë widi'zh nazhon che'n Dios kwa'n nile', gax ga' ñë'd laxto' men. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","No le'n yezh kwa'n lë Listra ze', nzho tu miyi' kwa'n nagakt zë dizde or ngol xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Xa' re' nzob kiyon widi'zh kwa'n kidi'zh Pab, no or miwi' Pab xe lo miyi' re', ngwanu laxto' Pab, lë' miyi' re' ñila widi'zh che'n Dios, no haxta par liwen Dios xa', ñila xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Orze', naye nzhab Pab lo xa': ―¡Watsuli, nali bizo ni'l! Orze' ngwatsuli xa' haxta ngwats xa', no nguzë xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","No or une rë men yezh Licaonia, xa' nzhin ze', se' kwa'n mile' Pab, nguzublo kibizhië rë men, kun widi'zh kwa'n nidi'zh men Licaonia nzhab bixa': ―¡Lë' rë dios ngulali lo be nela men ga'! ");
INSERT INTO zcaNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","No ngulo'lë bixa' Bernabé, dios Júpiter; no lë' Pab ngulo'lë bixa', dios Mercurio, porke nab tsa Pab kidi'zh lo bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","No ngulëi' kwa'n nile' rë zhi'n le'n yado' che'n Júpiter, kwa'n nzob ro' yezh ze', nzhanu xa' ngo'n no kun biga' kwa'n nak nela ye' ga', tutsa junt kun rë men yezh, par za' bixa' gon lo Pab no lo Bernabé. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Per or une Bernabé kun Pab kure', michëzla bixa' xab bixa', orze' nguzë'b bixa' xid men, no naye nzhab bixa': ");
INSERT INTO zcaNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―¡Lë' go! ¿Chon kile' go kure' kun no?, porke, ¡no men nela go ka! Nabtsa nzë no namás par nzadi'zh no widi'zh nazhon por Jesukrist, par la' go rë kwa'n nazu't re', no yila go Dios, Me kinu yalnaban par dubta', Dios kwa'n mizuxkwa' yibë' no yizhyuo, no nitsdo', no rë kwa'n nzhin loi. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Dios galo mila', mile' rë men nzhala, rë xa' gat lë't men Israel, rë kwa'n nzhakla bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","No ter sa' ngok bixa', per nangayot ngala' Dios, ngale' Dios rë kwa'n wen, par ne be, xmod nak Dios. Dios nila yiu par nzhak rë kwa'n, par ño nayax kwa'n nzhao men, no par nizak laxto' men. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","No ter se' midi'zh Pab kun Bernabé lo rë men ze', per pe'n mile' bixa' gan, par nangut rë men ze' ngo'n como tu gon ga' lo Pab no lo Bernabé. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Lë'chi mis orze' mizhin pla men Israel kwa'n nzë yezh Antioquía, mbaino yezh Iconio. Miki'l bixa' rë men xa' ngokla ngaza' gon ze', par ngulo ke bixa' Pab, no mizubxax bixa' Pab haxta ro' yezh. Mile' bixa' xigab, ya ngut la Pab. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Per or miza rë men che'n Jesukrist naka'n plo na'xbi Pab, lwega' ngwaxche xa', no miëk xa' yezh ze' xtu wëlt. No or ngwanilyuo, nguro' Pab ze', kun Bernabé, par ña bixa' yezh Derbe. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","No or milox milu' bixa' widi'zh nazhon che'n Dios por Jesukrist lo rë men yezh Derbe, nayax rë men ze' ngwayila widi'zh wen re'. Orze' miëk Pab kun Bernabé xtu wëlt par yezh Listra, yezh Iconio, mbaino kun yezh Antioquía kwa'n ña'n lazh men Pisidia, ");
INSERT INTO zcaNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","par midi'zhnu Pab kun Bernabé rë men che'n Jesukrist kwa'n nzho rë yezh ze', par más ngop bixa' jwers lo widi'zh che'n Dios por Jesukrist, par nala' bixa' Dios. No nzhab Pab kun Bernabé lo bixa': ―Naki'n zo be wen lo widi'zh che'n Dios kwa'n ñila be, ter dox zakzi be, par gal be rë kwa'n wen kwa'n kinu Dios par be. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Mbaino nu ngule Pab kun Bernabé, pla rë men par gak zhi'n xid rë men che'n Jesukrist kwa'n nzho kad yezh ze'. No or midi'zh Pab kun Bernabé xlats bixa' lo Dios, orze' ngulo bixa' rë xa' ze' ya' Dios, Dios kwa'n ngwayila bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Or nded Pab kun Bernabé lazh men Pisidia, orze' mizhin bixa' rë yezh kwa'n ña'n lazh men Panfilia. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","No or milox midi'zh Pab kun Bernabé widi'zh che'n Dios por Jesukrist lo rë men yezh Perge, orze' nzha bixa' yezh Atalia. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Or mizhin bixa', ze' nkë bixa' bark par ña bixa' yezh Antioquía kwa'n ña'n lazh men Siria, plo kwa'n guna'b rë men che'n Jesukrist lo Dios, par kë Pab kun Bernabé zhi'n nazhon che'n Dios, no nal, zhi'n re' mile' la bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","No or mizhin bixa' yezh Antioquía kwa'n ña'n lazh men Siria, mikan bixa' rë men che'n Jesukrist kwa'n nzho yezh ze', par midi'zh bixa' kwan pa' mile' Dios kun lë' bixa', no xmod mile' Dios, nayax xa' gat lë't men Israel ngwayila widi'zh che'n Dios por Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","No yezh ze', xche mia'n Pab kun Bernabé, lo rë men che'n Jesukrist kwa'n nzho ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Le'n rë ngubizh ze', mizhin pla miyi' kwa'n nzë lazh men Judea, mizhin bixa' yezh Antioquía kwa'n ña'n lazh men Siria, kilu' bixa' lo rë men che'n Jesukrist xa' nzho ze', nzhab rë miyi' re': ―Chi lë' kwerp che'n rë miyi' nakë señ kwa'n lë circuncisión nela xmod nzobni' lo ley kwa'n mila' Dios lo Muisés, nazubchit Dios rë kwa'n nzë'b xki go lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Or mbin Pab kun Bernabé kure', dox michëlro' bixa' kun rë miyi' ze'. Orze' mizo rë men che'n Jesukrist Pab kun Bernabé, no kun zipla men, par ya bixa' yezh Jerusalén, yadi'zh bixa' kure' lo rë apost no lo rë xa' nzo lo rë men che'n Jesukrist, xa' nzho yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","No dub nzha bixa' nez kun más rë men che'n Jesukrist, nded bixa' rë yezh kwa'n ña'n lazh men Fenicia no rë yezh kwa'n ña'n lazh men Samaria, no dub rë ze' midi'zh bixa' lo rë men che'n Jesukrist, nzhab bixa': ―Nu nayax men gat lë't men Israel, mila' bixa' rë kwa'n nazu't, rë kwa'n ñila bixa', par ngwayila bixa' widi'zh che'n Dios por Jesukrist. Orze' dox nizak laxto' rë men che'n Jesukrist mbin kure'. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","No or mizhin Pab kun Bernabé yezh Jerusalén, orze' rë apost kun rë xa' nzo lo rë men che'n Jesukrist, kun más rë men che'n Jesukrist xa' nzhin ze'; dox wen miwi' bixa' lo rë xa' re', orze' miza' Pab kwent kun Bernabé, rë kwa'n mile' Dios por lë' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Per ngwatsuli pla men fariseo kwa'n ñila widi'zh che'n Dios por Jesukrist, par nzhab bixa' lo rë nak xa' nzhin ze': ―Naki'n kë señ kwa'n lë circuncisión kwerp che'n rë men che'n Jesukrist, rë xa' kwa'n gat lë't men Israel, xa' miyi', mbaino rë men che'n Jesukrist naki'n le' rë kwa'n nzobni' lo ley kwa'n mila' Dios lo Muisés. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Orze' migan rë apost kun rë xa' nzo lo rë men che'n Jesukrist, par le' bixa' xigab xmod gak rë kure'. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","No guzhël-la di michëlro' bixa' por kure', lë'chi ngwatsuli Per, nzhab Per lo rë men ze': ―Biwi' go wech, lë' go nane, dizde nzhala ngule Dios da xid go, par lun widi'zh nazhon che'n Dios por Jesukrist lo rë men xa' gat lë't men Israel, par nu bixa' yilai. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Lë' Dios, Me nilibe' laxto' rë men, lë' Me milu' ke nu bixa' niwi' Dios wen lo, niza' Dios Sprit che'n Dios yo laxto' bixa', nela xmod mine' Dios Sprit che'n Dios nguio laxto' be. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Tutsa mod nile' Dios kun be, no kun rë men xa' gat lë't men Israel, porke nitsumbe Dios laxto' rë men, xa' ñila widi'zh che'n Dios por Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","No nal, ¿chon kikixian go Dios? ¿Chon kile' go, par le' rë men che'n Jesukrist rë kwa'n nzobni' ley, kwa'n mila' Dios lo Muisés, no per ni rë xuz be xa' tiemp nangakt ngale'i; mbaino ni be? ");
INSERT INTO zcaNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Per be, men Israel, ñila be, namás por wen laxto' Señor Jesukrist, mizubchi Me rë kwa'n nzë'b xki be lo Dios. Se'ska nile' Dios kun rë men, xa' gat lë't men Israel, chi lë' bixa' yila Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","No or midi'zh Per kure', xe nguzhin men, mbin bixa'i. Orze' midi'zh Bernabé kun Pab xmod mile' Dios rë kwa'n nazhon no rë kwa'n mile' ña'n xe men. Mile' Diose xid rë men gat lë't men Israel por Pab no por Bernabé. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","No or milox midi'zh bixa' kure', orze' nzhab Jakob: ―Wech, bin go rë kwa'n ganin. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Midi'zh Simón Per lo be, xmod dizde galo miwi' Dios lo xtu ben xa' gat lë't men Israel, par ngule Me cho gak men che'n Me xid rë xa' re', ");
INSERT INTO zcaNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","nela xa mizobni' ka rë profet, rë xa' midi'zh por Dios, or mizobni' bixa' kure': ");
INSERT INTO zcaNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Na nak Dios che'n go, Me nile' mandad go, lë'da yal xtu wëlt, par zon tu xa' kwa'n nzë ben che'n rey Dabi, par le' mandad lo go. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Or zhin zhë, gak rë kure', lë' xtu ben men zit zubi Lon, xa' kwa'n kwezha par gak men Da. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Na nak Dios che'n go, Me nile' mandad go, no dizde nzhala, milan di'zh kure'. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","No nzhab Jakob: ―Kuze', nilen xigab: Nale't be zi rë men ba' gat lë', rë xa' gat lë't men Israel, rë xa' ñila Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Neka xë'l be tu yech lo bixa', par nagao bixa' rë kwa'n nixo'b lo gaim. No gat ñalt ka' bixa' men gat lë't tsa' bixa', no ni nagao bixa' rë ma ngut nab, nangaxot ren, mbaino ni nagao bixa' ren; ");
INSERT INTO zcaNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","porke dizde nzhala, rë yezh, le'n rë yo' plo nitse'd rë men Israel widi'zh che'n Dios, nilu' men ley kwa'n mila' Dios lo Muisés, rë zhë kwa'n nile' men Israel diskans. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","No widi'zh re', nguio laxto' rë apost, no rë xa' nzo lo rë men che'n Jesukrist, kun más rë men che'n Jesukrist kwa'n nzhin ze'. Orze' ngule bixa' Judas Barsabás, kun Silas, par wei' rë xa' re', Pab kun Bernabé, par yezh Antioquía. No Judas kun Silas, dox menaye rë xa' re', xid rë men che'n Jesukrist, xa' nzho yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","No mixë'l rë xa' nzo lo rë men che'n Jesukrist, rë xa' nzho yezh Jerusalén, tu yech wei' Pab no Bernabé; se' nzobni' loi: “No xa' nak rë apost, no kun rë wech be xa' nak zhi'n, no kun más rë wech be; mixë'l no tu widi'zh wen par rë go, wech, xa' gat lë't men Israel, xa' nzho yezh Antioquía; no par rë go, xa' nzho lazh men Siria, mbaino par rë go, xa' nzho lazh men Cilicia. Ne no lo rë go bizak laxto' go. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Mbin no, nguro' pla bixa' lare', mbaino gat lë't no mixë'l bixa' lo go, mikixian bixa' go por kwa'n ne bixa'. Milu' bixa' lo go, niki'n kë señ kwa'n lë circuncisión kwerp che'n go, nela xa nzobni' ka lo ley kwa'n mila' Dios lo Muisés, mbaino ne bixa', le' go rë kwa'n nzhab ley ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kuze', mia'n no tutsa, ngule no pla xa' mile' kumpañ rop wech nazhi' be re', Bernabé no Pab, par nzë bixa' lo go, ");
INSERT INTO zcaNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","porke rop miyi' re', gat nizhebt gat por Señor Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kuze', mixë'l no Judas kun Silas, par ne yub bixa'i lo go, ");
INSERT INTO zcaNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","porke lë' Sprit che'n Dios milu' lo no, gat ñalt ne no, le' go rë kwa'n nzobni' lo ley kwa'n mila' Dios lo Muisés. Nabtsa kure' bin go no bile' go: ");
INSERT INTO zcaNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Nagaot go rë bë'l che'n rë ma kwa'n nzhat plo nile' men lani che'n winab, mbaino ni nagao go rë ma kwa'n nzhat nab, gat nigo't ren; no ni nagao go ren, no naka't go xa' gat lë't tsa' go. Chi lë' go le' rë kure', dox wen le' go. Rëtsa kure' ne no le' go. Mbaino ne no, bizak laxto' go.” ");
INSERT INTO zcaNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Or milox nzhab bixa' kure', orze' mixë'l rë men che'n Jesukrist Judas kun Silas, par le' bixa' kumpañ Pab kun Bernabé yezh Antioquía. Or mizhin bixa' ze', mikan bixa' rë men che'n Jesukrist kwa'n nzho yezh ze', par miza' bixa' yech ze', kwa'n mixë'l rë apost xa' nzho yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Or mbi'l rë xa' re'i, dox nizak laxto' bixa', porke dox wen widi'zh kwa'n nzobni' lo yech re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","No como lë' Judas kun Silas nak bixa' profet, xa' kwa'n nidi'zh por Dios, xche midi'zh bixa' par miza' bixa' konsej rë men che'n Jesukrist, par más ngop bixa' jwers lo widi'zh che'n Dios por Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Orze' mia'n bixa' tu tiemp yezh Antioquía ze'. No or nguiubre bixa' par yezh Jerusalén, orze' rë men che'n Jesukrist kwa'n nzho yezh Antioquía ze', nzhab bixa': “Bizë go kun Dios.” ");
INSERT INTO zcaNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Per lë' Silas mile' xigab ya'n xa' yezh Antioquía. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Nu Pab kun Bernabé mia'n bixa' yezh Antioquía ze', par milu' bixa' widi'zh che'n Dios por Jesukrist lo rë men nzho ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","No or nded pla ngubizh, nzhab Pab lo Bernabé: ―Cha' nzhatsi' be ma rë wech be, rë yezh plo midi'zh be widi'zh che'n Dios, par ne be xmod nzhin bixa' ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","No lë' Bernabé ngokla ngwei' Juan Mark par ngale' kumpañ bixa', ");
INSERT INTO zcaNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","per net Pab nga xa' re', porke mila' nzë'b xa' re' Pab kun Bernabé or nzho bixa' lazh men Panfilia, nangaknut Juan Mark, ngakë bixa' zhi'n nazhon che'n Dios ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Dox michëlro' bixa' por kure', haxta mile'i milë' bixa'. Lë' Bernabé nzhanu Juan Mark, nguzen bixa' bark par nzha bixa' lazh men Chipre, ");
INSERT INTO zcaNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","no lë' Pab ngule Silas, par le' kumpañ xa', orze' rë men che'n Jesukrist guna'b lo Dios por rop xa' re', par gaknu Dios bixa', orze' nzha bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Orze' nded bixa' rë yezh che'n men Siria, kun rë yezh che'n men Cilicia, par miza' rop xa' re' konsej rë men che'n Jesukrist xa' nzho kad yezh ze', par ngop rë xa' ze' más jwers lo che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Orze' mizhin Pab kun Silas yezh Derbe, no yezh Listra. Ze' mizhë'l bixa' tu men che'n Jesukrist lë Timoteo, xga'n tu una' kwa'n nak men Israel, tu men che'n Jesukrist, per xuz Timoteo nak tu xa' grieg. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Rë men che'n Jesukrist kwa'n nzho yezh Listra kun yezh Iconio ze', wen nidi'zh bixa' por Timoteo. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Mile' Pab xigab wei' xa' Timoteo, per galo laka mikë' Pab señ kwerp che'n Timoteo, kwa'n nikë rë men Israel, par yent kwan di'zh rë men Israel kwa'n nzho ze', porke rë bixa' nane, lë' xuz Timoteo nak tu xa' grieg. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","No or mizhin bixa' kad yezh plo nded bixa', mbi'l bixa' yech lo rë men che'n Jesukrist kwa'n nzho rë ze', yech kwa'n mizuxkwa' rë apost yezh Jerusalén, kun rë xa' nzo lo rë men che'n Jesukrist, par le' rë men che'n Jesukrist rë kwa'n nzobni' loi, rë plo. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Se' mile' Pab par miro'b bixa' lo rë kwa'n nak che'n Dios, no zilita' niza más nayax men xa' ñila widi'zh che'n Dios por Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","No nangaziyëlt Sprit che'n Dios ngalu' bixa' widi'zh che'n Dios rë yezh kwa'n ña'n lazh men Frigia, no rë yezh kwa'n ña'n lazh men Galacia mbaino lazh men Asia. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","No or mizhin bixa' gax plo nak lazh men Misia, no mile' bixa' xigab, nga bixa' rë yezh kwa'n ña'n lazh men Bitinia, per nangaziyëlt Sprit che'n Dios nga bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kuze' ndedka'n bixa' namás lazh men Misia, par mizhin bixa' yezh Troas. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ze' une Pab le'n mika'l, tu miyi' yezh Macedonia, nzuli xa', dox kina'b xa' lo Pab, nzhab xa': “Guded par lazh men Macedonia re' par gaknul no.” ");
INSERT INTO zcaNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Riyë'l xtu ngubizh or une Pab kure', lwega' nzha no par lazh men Macedonia, porke nane ka no, lë' Dios ngurezh no ba', par yayab no widi'zh che'n Dios por Jesukrist lo rë men ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nkë no bark yezh Troas ze', par nzha no nali laka tu yezh kwa'n lë Samotracia, kwa'n nzhin tsao' nitsdo', no xtu riyë'l, mizhin no yezh Neápolis. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","No ze' ngwa no par yezh Filipos, tu yezh kwa'n más kwa'ro, kwa'n nzhin lazh men Macedonia, mbaino men Roma michao'we. No pla ra' ngubizh mia'n no ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","No tu zhë Sabd kwa'n nile' men diskans, nguro' no ro' yezh ze' par ngwa no ro' tu you' plo nina'b xa' lo Dios. Ze' nguzob no par midi'zh no lo pla una' kwa'n nzhin ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Xid rë una' re' nzho tu una' kwa'n lë Lidia, xa' nzë yezh Tiatira, tu una' xa' nito lar morad kwa'n tsak dox. Una' re' nzhon ro' Dios. No mixa'l Dios laxto' una', mizob yek una' kwa'n midi'zh Pab por Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Orze' ngoklëi' una' kun rë xa' lizh una', mbaino mina'b una' lo no, ne una': ―Chi walika nigobe' go nak da tu men che'n Jesukrist, cha' go ña be lizha par ya'n go. No mile' una' mia'n no lizh una'. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","No tu wëlt, dub nzha no plo nina'b men lo Dios, lë'chi zhi'n mile' tu una' nile' divín, mbi'dchël-lo una' no. Una' re' por poder che'n Mizhab, nile' xa' kure', no dox nile' xa' gan dimi, por rë xa' nak xa' mos lo. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Orze' nzadkë una' re' tich no plo nzha no kun Pab, mbaino tich no, naye kibizhië una' lo men, nzhab una': ―¡Lë' rë miyi' re' nak rë men che'n Dios, Me kwa'n nile' mandad dub yizhyuo, no nilu' rë miyi' re' xmod nigo' Dios men lo rë kwa'n nzë'b xki men! ");
INSERT INTO zcaNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","No nayax ngubizh mile' una' kure', haxta ke miyi'xian Pab por kure', orze' miëk Pab nzhab Pab lo mbi mal kwa'n nzho laxto' una' re': ―¡Por lë Jesukrist kilen mandad, guro' laxto' una' re'! No mis orze', lwega' nguro' mbi ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Per or une rë xa' kwa'n nile' mandad una' re', nagaktra' le' bixa' gan dimi por lë' una', porke ngulëz nile' una' divín, orze' nguzen bixa' Pab kun Silas, mizubxax bixa' rë xa' re' haxta plo nak xbi', par ngwala' bixa' Pab kun Silas lo gustis. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","No or michi bixa' Pab kun Silas lo gustis, orze' nzhab bixa': ―Lë' rë miyi' re', xa' nak men Israel, dox kichëldil bixa' men lazh be, ");
INSERT INTO zcaNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","kidi'zh bixa' le' rë men lazh be xtu rë kostumbr kwa'n gat ñalt le' be, porke lë' be men Roma. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Orze' rë men niyi' lo Pab no lo Silas. Orze' jwers ngulo' rë gustis xab Pab no xab Silas, orze' mile' bixa' mandad ngurële tich rë xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","No dispwés di ngurële tich bixa', orze' ngulo bixa' rop xa' re' lizhyi'b, no nzhab rë gustis lo xa' nikina lizhyi'b: “¡Naye bitsao'yo' go rop xa' re'!” ");
INSERT INTO zcaNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Or mbin xa' nikina lizhyi'b kure'; ngwala' xa' Pab kun Silas más al xan, orze' ngulo xa' ni' Pab no ni' Silas le'n tu ya nzob ye'r. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","No pas como garol yë'l, kina'b Pab kun Silas lo Dios, no kikë' bixa' kant por tanta nazhon Dios, no nu más rë xa' nzho lizhyi'b ze' kiyone. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Lë'chi dox tu xo ro miwin, no dub lizhyi'b nguzhibe, haxta rë simient che'ne. Orze' lwega' mixa'l rë pwert, no rë kaden kwa'n nali'b rë men xa' nzho lizhyi'b, mixëk. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","No or nguro' mika'l lo xa' nikina lizhyi'b re', une xa' naxa'l rë nak pwert ro' lizhyi'b, orze' ngulo' xa' spad che'n xa' par gut yub xa' xa', porke mile' xa' xigab: “Rë nak rë xa' re', mikë' karre.” ");
INSERT INTO zcaNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Orze' naye midi'zh Pab lo xa', nzhab Pab: ―¡Nale'tal ni tu kwa'n gat lë', porke rë no nzhin ka re'! ");
INSERT INTO zcaNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Orze' guna'b xa' nikina lizhyi'b re' tu biani, orze' karre nguio xa', no dub nixiz xa' di yalzhe'b, nguzuxib xa' lo Pab no lo Silas, ");
INSERT INTO zcaNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","orze' ngulo' xa' Pab kun Silas, no nzhab xa': ―Lë'o, ¿kwan naki'n len par che' Dios rë kwa'n nzë'bxkin lo Dios? ");
INSERT INTO zcaNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Orze' nzhab Pab kun Silas: ―Wayila Señor Jesukrist, par che' Dios rë kwa'n nzë'b xkil, no rë kwa'n nzë'b xki rë xa' lizhal lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Orze' milu' bixa' widi'zh che'n Dios por Jesukrist lo xa' nikina lizhyi'b re', mbaino lo rë xa' lizh xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","No mis yë'l ze', mbiy' xa' nikina lizhyi'b re', Pab kun Silas, par mizët xa' plo miwe' rë xa' re', orze' ngoklëi' xa' nikina lizhyi'b re', kun rë xa' lizh xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Orze' mbiy' xa' Pab kun Silas al lizh xa', no miza' xa' kwa'n ndao rë xa' re'. No dox nizak laxto' xa' kun rë xa' lizh xa', por ngwayila bixa' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Xtu riyë'l, mixë'l rë gustis pla xpen xa', lo xa' nikina lizhyi'b ze', par liya' xa' Pab kun Silas, ");
INSERT INTO zcaNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","orze' nzhab xa' nikina lizhyi'b re' lo Pab no lo Silas: ―Lë' rë gustis, mixë'l pla xpen bixa' lon, par liyan go, nal gak bi go, yentra' kwan nak kun go. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Per nzhab Pab lo rë xpen gustis: ―No nak men Roma, porke ñal ngawi' bixa' chi walika kinu no dol, lë'la michël bixa'i tich no lo rë men, ngulo xa' no lizhyi'b. No nal, ¿ko' xa' no xla'n nzhakla xa'? Per nagakte. Mejor yi'd yub bixa', par liya' bixa' no. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","No or mbin rë gustis kure', lë' Pab no lë' Silas men Roma, orze' dox mizheb bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Orze' ngwa rë gustis lo Pab no lo Silas, par ngwatsiyal bixa' laxto' rë xa' re', orze' miliya' bixa' Pab no Silas, no nzhab rë gustis: “Bizë go, no guro' go yezh re'.” ");
INSERT INTO zcaNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","No or nguro' bixa' lizhyi'b, ña bixa' lizh Lidia. No rë men che'n Jesukrist kwa'n nzhin ze', midi'zhnu Pab bixa' kun Silas, par más mixubla bixa' Dios. Orze' nka' Pab nez, ña xa' kun Silas xtu plo. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","No or nded Pab kun Silas yezh Anfípolis kun yezh Apolonia, orze' mizhin bixa' yezh Tesalónica. Le'n yezh ze' nzob tu yo' plo nitse'd men Israel widi'zh che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","No ngwa Pab le'n yo' ze' nela xmod nile' ka xa', chon sabd ngwa xa' gazob sman, no michëlro' xa' por widi'zh che'n Dios kun rë xa' nibin ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","No milu' Pab lo rë men ze', nzhab xa' lë' Jesukrist naki'n zakzi, mbaino gat, per ngubizh yon, lë' Jesukrist ruban, porke se' nzobni' lo Yech che'n Dios. No nzhab Pab lo rë men ze': ―Jesús Me kidizha lo go re', nak Krist Me mixë'l Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","No pla ra' xa' re' ngwayilai, no nguio bixa' xlad Pab kun Silas. No nu tu bëd men grieg kwa'n nzhon ro' Dios, no kun pla ra' una' kwa'n tsak yezh ze', nu bixa' nguzhin kun Pab no kun Silas. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Per rë men Israel kwa'n gat ñilat widi'zh che'n Dios por Jesukrist, dox niyi'xian bixa', nine bixa' Pab kun Silas, orze' mikan bixa' pla rë xa' minu la xmod nak, par chëldil bixa' Pab kun rë men yezh ze'. Orze' jwers nguio bixa' lizh tu xa' lë Jasón, ngwakwa'n bixa' Pab kun Silas, par chi bixa' rop rë xa' re' lo rë men yezh ze' par zakzi men rë xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","No por nangaga' Pab kun Silas ya' bixa', orze' mizubxax bixa' Jasón kun zipla rë men che'n Jesukrist kwa'n nzho ze', par michi bixa' rë xa' re' lo gustis kwa'n nile' mandad yezh ze', orze' naye kibizhië bixa', nzhab bixa': ―¡Lë' rë miyi' re' kwa'n nikizë rë plo, kile' bixa' par nagon men ro' gubier! ¡No nal, nu lazh be kile' bixa'i! ");
INSERT INTO zcaNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","No Jasón ngurezh bixa' lizh Jasón. ¡Rë xa' re' kichil ley che'n César, porke kidi'zh bixa' nzho xtu rey xa' lë Jesús! ");
INSERT INTO zcaNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Or mbin rë men widi'zh re' kun rë gustis xa' nzhin ze', dox gat lë't mizi men, mizheb bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Orze' mile' rë gustis ndix Jasón tu mult, kun rë xa' nichë'l xa', par ngok ña bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Lwega', or yë'l ze', rë men che'n Jesukrist kwa'n nzho yezh ze', mixë'l bixa' Pab kun Silas, par yezh Berea lo mis orze'. No or mizhin Pab kun Silas yezh ze', nguio bixa' le'n yo' plo nitse'd rë men Israel widi'zh che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","No rë men Israel kwa'n nzho yezh ze', más naxa'l yek bixa', ke rë men Tesalónica. Dub la bixa' nzhon bixa' widi'zh che'n Dios kwa'n nilu' Pab, no zilita' nzho'l bixa' kwa'n nzobni' lo Yech che'n Dios, par ne bixa' chi walika nzobni' kwa'n nidi'zh Pab. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Kuze', nayax bixa' ngwayilai, no nayax rë una' grieg xa' tsak, no nu tu bëd miyi' ngwayilai. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Per or mbin rë men Israel kwa'n nzho yezh Tesalónica, lë' Pab kun Silas kilu' widi'zh che'n Dios por Jesukrist yezh Berea, orze' lwega' micheb bixa' rë men yezh ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Per rë men che'n Jesukrist xa' nzho ze', lwega' mixë'l bixa' Pab, par ro' nitsdo', no lë' Silas kun Timoteo, mia'n bixa' ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","No rë men xa' nkina Pab, ngulunez bixa' Pab haxta yezh Atenas. Orze' nguiubre ska bixa' par mbi'dyab bixa' kwa'n nzhab Pab, par ya Silas kun Timoteo lwega' plo kimbëz Pab. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","No dub kimbëz Pab or zhin Silas kun Timoteo yezh Atenas ze', dox miwin laxto' Pab or une Pab, lë' rë men yezh ze', dox ñakë bixa' tich rë winab, no nazhi' bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kuze' midi'zhnu Pab rë men Israel mbaino rë men grieg xa' nzhon ro' Dios plo nitse'd bixa' widi'zh che'n Dios; mbaino se'ska, zilita' midi'zhnu Pab rë men plo nzhin xbi'. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ze' midi'zhnu Pab pla maestr che'n men epikúrio xa' nilu', ngulen yizhyuo nabe, mbaino gak ban men xmod nzhakla men, no pla maestr che'n estóiko xa' nilu', nazakt laxto' men no ni nawin laxto' men kwa'dox, mbaino xek men lo rë kwa'n nizak men. Rë xa' re' michëlro' kun Pab. Tu ben xa' nzhab: ―¿Kwan pa' dox kidi'zh xa' re'? Kilu' xa' kwa'n pas ni lë' xa' nanet. Mbaino xtu ben xa' nzhab: ―Xa' re' kilu' kwent che'n rë dios kwa'n gat nakbe't. Se' kidi'zh bixa', porke lë' Pab kilu' widi'zh wen che'n Jesukrist, mbaino xmod nguruban Me. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Orze' mbiy' bixa' Pab tu lad plo lë Areópago. Ze' nzob tu yo' nela yalao ga', orze' nzhab bixa' lo Pab: ―¿Chi zak di'zhal lo no, rë kwa'n kub kwa'n kilu'l ba'?, ");
INSERT INTO zcaNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","porke nel lo no, rë kwa'n nanet no kwan, no nzhakla no gon no kwane. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Se' nzhab bixa' lo Pab, porke rë men yezh Atenas kun rë xa' zit kwa'n nzho ze', dox ño laxto' bixa', di'zh bixa' o gon bixa' tu kwa'n laore nzhak. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Orze' ngwatsuli Pab xid rë xa' nzhin ze', nzhab Pab: ―Rë go men Atenas, bin go widi'zh re'. Niwi'n xmod nak go, nazhi' go rë winab che'n go, como nela tu dios ga'. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","No or nikizë'n le'n yezh re', unen nayax plo kinu go, nile' go lani par winab che'n go, no xid rë kure', unen nzobni' widi'zh re': “Kure' tu dios Me gat nakbe't.” No nal, Dios Me gat nilibe't go nidi'zh go nak dios che'n go, mbaino Dios re' kidizha lo go nal re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Dios re' mizuxkwa' dub yizhyuo, kun rë kwa'n nzhin loi. No Dios re' nile' mandad lo yibë' mbaino lo yuo; no gat nzhot Dios re' le'n yado' kwa'n nizuxkwa' men. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Lë' Dios re' gat naki'n le' men ni tu kwa'n, par gaknu men Dios, sino ke Dios re' niza' yalnaban ka' rë men, nikina Dios men, mbaino niza' Dios rë kwa'n par men. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’No kun tutsa miyi' mile' Dios miar xa' yizhyuo re', par mire'ch men rë plo; no ngulo Dios tiemp par yo kad ben men, mbaino plo ban bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Kure' mile' Dios par kwa'n bixa' Dios, no ter nadi'b lo men, lë' men yazhël ka Dios. No nzhapa segur, gat zit nzo Dios lo kad be. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","No por yalnazhon che'n Dios naban be, mbaino nizë be, no nzhin be yizhyuo re', como lë'la midi'zh ka pla rë xa' kwa'n nzhak nizuxkwa' di'zh chul xid go, midi'zh bixa': “Lë' be nzë ben che'n Dios.” ");
INSERT INTO zcaNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","No chi lë' be nzë ben che'n Dios, gat ñalt le' be xigab, lë' Dios nak nela rë winab kwa'n nizuxkwa' men kun or, no kun plat, o kun ya, o kun ke, nela xmod nzë yek bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Per Dios nangale't kas rë kwa'n nile' men, rë tiemp kwa'n nangale' men kwa'n wen, por nagane men cho Dios. Per nal, mile' Dios mandad lo rë nak men yizhyuo rë plo, la' bixa' rë kwa'n nakap kile' bixa' lo Dios, par le' bixa' kwa'n wen lo Dios, ");
INSERT INTO zcaNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","porke kinu Dios tu ngubizh, lë' Jesukrist gab xmod gak kun kad men, por kwa'n nile' xa', wanei choi. Mile' Dios nguruban Jesukrist, par ne be, lë' nab Jesukrist nile' mandad lo rë kwa'n nzho. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Or mbin rë men nzhin ze', lë' Jesukrist nguruban, nzho xa' mixizhnu Pab no nzho xa' nzhab lo Pab: ―Ba' pokta' nel kure' lo no xtu wëlt. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Orze' mila' Pab bixa', nzha Pab xtu plo. ");
INSERT INTO zcaNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Per pla xa' ngwayilai, xa' ze' nzhakë tich Pab. Xid rë xa' re' nzho tu xa' lë Dionisio, tu xa' kwa'n nzho partid kwa'n lë Areópago. No xtu xa' nak tu una' xa' lë Dámaris, kun zipla men. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Orze' nguro' Pab yezh Atenas, par ña xa' yezh Corinto. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ze' mizhë'l xa' tu miyi' tu xa' Israel xa' lë Aquila, tu xa' nzë lazh men Ponto; nzë'b ñë'd xa' di Italia kun tsa' xa' una' lë Priscila, porke lë' rey ro Claudio mile' mandad, ro' rë men Israel kwa'n nzho yezh Roma. Orze' ngwatswi' Pab lo rop tsa' xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","No lë' zhi'n kwa'n nzhak Pab nizuxkwa' xa' yo' yid, no mis zhi'n ska re' nile' rop tsa' xa' re', kuze' junt nkë bixa' zhi'n. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","No kad ngubizh kwa'n nile' men Israel diskans, ñalu' Pab widi'zh che'n Dios por Jesukrist le'n yo' plo nitse'd bixa' widi'zh che'n Dios, par la Pab yek bixa' yila bixa'i, no nzho men ngwayila kwa'n milu' Pab, men Israel no men grieg. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Or nguro' Silas kun Timoteo yezh Macedonia, par zhin bixa' yezh Corinto, orze'se nguzublo Pab, zilita' nilu' Pab widi'zh che'n Dios lo rë men Israel, nidi'zh Pab: “Lë' Jesús nak Krist, Me kwa'n más tsak lo rë xa' kwa'n mixë'l Dios xid rë men Israel.” ");
INSERT INTO zcaNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Per mile' rë men Israel ze' nakap lo Pab, mbaino nde bixa' Pab, orze' nguzhib Pab xab Pab nela tu señ ga' ke nzë'b xki rë xa' ze' lo Dios, orze' nzhab Pab: ―Lë'o lox lo Dios, mis go nzhap dol por kuba'. No nal, lë'da yalu widi'zh che'n Dios por Jesukrist lo xtu ben men, xa' gat lë't men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Orze' nguro' Pab le'n yo' ze', no ngwa xa' lizh tu xa' lë Ticio Justo, tu xa' nzhon ro' Dios, no lizh xa' ze' nzob gax ta' yo' plo nitse'd men Israel widi'zh che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","No Crispo, xa' kwa'n nile' mandad le'n yo' plo nitse'd men Israel widi'zh che'n Dios; nu xa' ngwayila widi'zh che'n Dios por Jesukrist, kun dub lizh xa'. Mbaino nu pla rë men Corinto ngwayilai, or mbin bixa' widi'zh re', ngoklëi' rë bixa' le'n nits. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","No tu yë'l, ngurulo Jesukrist lo Pab, nzhab Me: ―Pab, nazhebtal; bidi'zh xtizha zilita', natsao'tal ro'l; ");
INSERT INTO zcaNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","porke na nzo kun lu, yent cho gak galal, porke dox men kinun yezh re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kuze' mia'n Pab tu li'n garol yezh Corinto ze', par milu' xa' widi'zh che'n Dios xid rë men ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Per or ngok Galión gobiernador lazh men Acaya, orze' tutsa midi'zh nayax men Israel, par mbiy' bixa' Pab yalao plo nzob gobiernador Galión. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Orze' nzhab bixa' lo Galión: ―Miyi' re' kiki'l men par zubi men lo Dios xtu mod, per gat lë't nela xmod nzob lo ley che'n noi. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Laore nzhakla Pab ngadi'zh Pab tu kwa'n, lë'chi nkab Galión lo rë men Israel ze', nzhab xa': ―Chi mile' xa' re' tu kwa'n gat lë', o mile' xa' tu kwa'n nazhe'b dox, orze'se gak di'zh go rë kwa'n nzhakla go, mblëgo men Israel; ");
INSERT INTO zcaNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","per go, dox rë kwa'n kinabdi'zh go por rë kwa'n milu' rë xpen go, kwent che'n cho pa' ngok rë men che'n go, mbaino kwent che'n rë kwa'n nzobni' lo ley che'n go. Kuze', go wane kuxkwa' go kuba', porke na, gat lë't kwent da kuba', par len yalgustis. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Orze' ngulutin Galión rë bixa' le'n yalao. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Orze' nguzen rë men ze' Sóstenes, xa' nile' mandad le'n yo' plo nitse'd rë men Israel widi'zh che'n Dios, par miza' bixa' lao' Sóstenes, ro' yalao lo Galión, no per ni kas nangale't Galión kure'. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Per Pab mia'n pla ra' ngubizh yezh Corinto. Orze' nzhab xa' lo rë men che'n Jesukrist: “Lë'da ña xtu plo.” Orze' nkë xa' bark kun Priscila no kun Aquila, par nzha bixa' rë yezh che'n men Siria. Orze' mizhin bark yezh Cencrea, ze' ngula Pab bark par mizhi'b yek xa', par mile' xa' tu kwa'n mia'n xa' di'zh lo Dios. Orze' nkë xa' bark xtu wëlt par nzha xa' nez che'n xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","No or mizhin bark yezh Efeso, ze' milë' Pab kun Priscila no kun Aquila, orze' ngwa xa' le'n yo' plo nitse'd men Israel widi'zh che'n Dios. Ze' midi'zh xa' lo rë men Israel kwa'n nibin ze' par ngala Pab yek bixa', par gon bixa' widi'zh che'n Dios por Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","No dox ngokla bixa' ngaya'n Pab xche kun lë' bixa' ze', per nangaziyëlt Pab, ");
INSERT INTO zcaNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","sino ke ña Pab, no nzhab Pab: ―Lë'da nzha lani kwa'n mer gal yezh Jerusalén, per chi ziyël Dios, lë'da yubre ska re' xtu wëlt. Orze' nkë xa' bark xtu wëlt, nguro' xa' yezh Efeso. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Or mizhin Pab yezh Cesarea, orze' ngwatswi' xa' ma rë men che'n Jesukrist kwa'n nzho ze'. Orze' nguzen xa' nez xtu wëlt par yezh Antioquía, kwa'n ña'n lazh men Siria. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","No pla ra' ngubizh mia'n Pab yezh Antioquía, orze' ngwa xa' xtu wëlt pla ra' yezh kwa'n nzhin lazh men Galacia no lazh men Frigia, par ngwadi'zh Pab lo rë men che'n Jesukrist rë xa' nzho ze', par más mixo'b yek bixa' Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Le'n rë ngubizh ze', mizhin tu men Israel xa' lë Pol yezh Efeso. Xa' re' ngol yezh Alejandría, dox nix nidi'zh xa' par la xa' yek men, mbaino dox nzhak xa' widi'zh che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Xa' re' nilibe' la che'p widi'zh che'n Dios por Jesukrist, no dubla xa' nidi'zh xa'i, mbaino lë'tsa lë' widi'zh che'n Jesukrist nilu' xa' or nidi'zh xa' lo rë men, no ter nab tsa xmod mililëi' Juan men kun nits, nane xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","No yent kwan nizheb xa', nguzublo kidi'zh xa' widi'zh che'n Dios, le'n yo' plo nitse'd men Israel widi'zh che'n Dios. Per or mbin Priscila kun tsa' xa' Aquila xmod kidi'zh xa' re', orze' mbiy' bixa' Pol tu lad, par milu' bixa' más widi'zh che'n Dios por Jesukrist nela xmod nzhakla Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","No or ngokla Pol ya Pol par lazh men Acaya, orze' mixë'l men che'n Jesukrist xa' nzho yezh Efeso, tu yech par lu' Pol lo más rë men che'n Jesukrist, xa' nzho lazh men Acaya, par wi' bixa' wen lo Pol or zhin Pol ze'. No or mizhin Pol ze', dox ngoknu Pol rë men che'n Jesukrist xa' nzho ze', par más mixo'byek bixa' Dios, rë xa' kwa'n ngwayila widi'zh che'n Dios por nilats laxto' Dios bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Se' mile' Pol, porke lo nayax men, dox naye midi'zh Pol, mile' Pol gan une rë nak men Israel kwa'n michëlro' xa' kun lë', lë' Jesús walika nak Krist, nela xmod nzobni' lo Yech che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Dub nzho Pol yezh Corinto, nzhaded Pab rë yezh kwa'n ña'n le'n rë yi', orze' mizhin xa' haxta yezh Efeso. Ze' mizhë'l xa' pla men che'n Jesukrist, ");
INSERT INTO zcaNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","orze' minabdi'zh Pab, nzhab Pab lo bixa': ―¿Chi nguio Sprit che'n Dios laxto' go, or ngwayila go Jesukrist? Orze' nzhab bixa': ―Per ni naga gon no chi nzho Sprit che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Orze' nzhab Pab: ―¿Xmod ska ngoklëi' go? Orze' nzhab bixa': ―Ngoklëi' no nela xmod milu' Juane. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Orze' nzhab Pab: ―Walika, Juan mililëi' men le'n nits, par milu' walika mizi bixa' rë mod gat lë' nak bixa' lo Dios par ban bixa' xtu mod; per nzhab ska Juan: “Naki'n yila go Me kwa'n nzadkë ticha.” No Me kwa'n mize't Juan re', nak Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","No or mbin bixa' kure', lwega' ngoklëi' bixa' le'n nits, nela xmod mile' ka Jesukrist mandad, ");
INSERT INTO zcaNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","orze' mixo'b Pab ya' Pab yek rë men ze', mbaino nguio Sprit che'n Dios laxto' rë bixa', no midi'zh bixa' xtu ben widi'zh kwa'n yent cho nane, mbaino midi'zh bixa' por Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Di lo rë miyi' re', nak bixa' tu dusen men. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","No ze', dub chon mbëo' milu' Pab widi'zh che'n Dios por Jesukrist le'n yo' plo nitse'd men widi'zh che'n Dios, no nangazhebt xa' midi'zh xa'i, no mile' xa' por ngala xa' yek rë men ze', par gak bixa' men che'n Dios por Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Per nzho pla xa' nad dox, gat nzhont xa'i, dox nakap nidi'zh bixa' tich widi'zh che'n Dios por Jesukrist lo rë nak men nzhin ze'. Orze' nguiubchi Pab ze', kun zipla men xa' ñila widi'zh che'n Dios por Jesukrist, orze' ngwanu Pab bixa' le'n tu yo' skwel che'n tu xa' lë Tirano, no ze', zilita' ñadi'zh Pab widi'zh che'n Dios lo rë xa' ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Se' mile' Pab dub chop li'n, par mbin rë xa' nzho lazh men Asia, rë men Israel kun rë men grieg, xmod nak widi'zh che'n Dios por Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","No por Pab, mile' Dios rë kwa'n nazhon kwa'n nagat ne men. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Haxta mbiy' men pañit o tlë' lar lo Pab par nzhale ta' Pab, orze' nzhuwei' mene lo rë xa' nzhakne, no niwen men, mbaino rë mbi mal nirutine laxto' men. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Per nzho pla miyi' Israel, xa' nikizë yezh por yezh, nu bixa' nzhakla kutin mbi mal laxto' rë men por lë Jesukrist, nela Pab ga'. Se' midi'zh bixa' lo rë xa' nzho mbi mal laxto': ―Por lë Jesús kwa'n nidi'zh Pab lo rë men, lë'da ni, ¡guro'tin ba'! ");
INSERT INTO zcaNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Se' mile' gazh xga'n tu xa' lë Esceva, tu men Israel, tu xa' nile' mandad lo pla ngulëi'. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Per tu wëlt, se' mikab mbi mal lo rë miyi' ze': ―Nilibe'n Jesukrist no nanen cho Pab, per go, ¿cho gox? ");
INSERT INTO zcaNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Mbaino miyi' kwa'n nzho mbi mal laxto' ze', nguxo'b xa' tich rë xa' re', no miza' xa' lao' rë miyi' re', haxta michëz xa' xab rë xa' re', orze' mikë' rë miyi' re' karre; nzho xa' miwe', no nzho xa' ña kache'. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kuze', rë men nzho yezh Efeso, men Israel no kun rë men grieg, or mbin bixa' kwan nguzak rë miyi' re', orze' rë men dox mizheb bixa', no rë plo midi'zh men: “Dox nazhon Jesukrist.” ");
INSERT INTO zcaNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","No por kwa'n ngok re', nayax men ngwayila widi'zh che'n Dios por Jesukrist, no nu ngwa bixa' lo rë men che'n Jesukrist par mixëlro' bixa' rë kwa'n mal no rë yalbruj kwa'n nzhak bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","No nu nayax xa' mitse'd yech che'n Mizhab, mbiy' bixa'i par mizë'k bixa'i lo rë men. No ngulo' bixa' kwent plak tsak rë yech ze', orze' nzhab bixa' tsake como cho' bi chi' mil dimi kwa'n nakxao' kun plat. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Por rë kure', más mire'ch widi'zh che'n Dios por Jesukrist rë plo, por une men dox nazhon Dios, mbaino más miar men xa' ñila widi'zh che'n Dios por Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","No or milox ngok rë kure', midi'zh Sprit che'n Dios lo Pab, ya xa' lazh men Macedonia, mbaino lazh men Acaya. No or gat ya Pab ze', nzhab Pab: —Or lox yan yezh Jerusalén, naki'n yan, nu yezh Roma. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Orze' mixë'l Pab chop men xa' nzhaknu Pab, par ya bixa' rë yezh kwa'n nzhin lazh men Macedonia. Tu xa' re' lë Timoteo, mbaino xtu xa' lë Rast. No mia'n Pab zipla ngubizh lazh men Asia. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Le'n rë ngubizh ze', rë men yezh Efeso, dox nazheb mile' bixa' por widi'zh che'n Dios por Jesukrist kwa'n nilu' Pab, gat nzhaklat bixa' re'che lazh bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Xid rë xa' re' nzho tu xa' más nichëldil men, tu xa' lë Met. Xa' re' nichao' rë nich ye'n kwa'n nakxao' kun pura yi'b de plat, kwa'n nak nela yado' che'n winab che'n bixa' kwa'n lë Diana. Lë' Met kun más rë xa' kwa'n nichao' rë nich ye'n re', nayax dimi nile' bixa' gan por zhi'n re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Orze' mikan Met rë xa' nikë zhi'n re', par nzhab xa' lo rë xa' re': ―Rë be nane, por zhi'n re', rrik be. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Lë' go nane la, no nzhon la go, lë' xa' lë Pab re' kila yek rë men, ke rë winab kwa'n nichao' ya' men, gat lë't Diose. Mbaino gat lë't nab yezh re' kile' xa'i, sino ke dub lazh men Asia kile' xa' sa'. No dox men mile' la xa' gan ngula yek. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Dox nazhe'b kure'. Paste lë' zhi'n che'n be lox. No gat lë't nab kure'i, nu nale'tra' men lani che'n naxnax Diana che'n be, Me kwa'n nazhon par rë men. ¡Mbaino, gat lë't nab yezh re' gake se', no nu dub lazh men Asia, no pas haxta dub yizhyuo jwals gak rë kure'! ");
INSERT INTO zcaNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Or mbin men kure', rë xa' kwa'n nikë Met zhi'n kun lë', orze' dox niyi'xian bixa', kibizhië bixa', nzhab bixa': ―¡Dox nazhon naxnax Diana che'n men yezh Efeso! ");
INSERT INTO zcaNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Orze' rë men yezh ze', dox miyi'xian bixa'; orze' tutsa nguxo'b rë bixa' tich Gayo no tich Aristarco, rop miyi' kwa'n nzë lazh men Macedonia, xa' kwa'n nikizë tich Pab; orze' mbiy' bixa' rop xa' re', haxta plo nibin bixa', nile' bixa' junt. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Lë' Pab ngokla ngazubi xid rë xa' ze', per rë men xa' nikizë kun Pab, ngala't bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","No pla gustis, xa' nzë lazh men Asia, rë xa' kwa'n nichë'l Pab, mile' bixa' abis, guna'b bixa' jwers nayat Pab plo nzhin junt ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","No lo junt ze', dox nazhe'b kile' men. Xid rë xa' ze', nzho xa' kibizhië naye tu kwa'n, no nzho xa' kibizhië naye xtu kwa'n, no más bixa' ni nane chon nguzhin junt ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Orze', pla rë men nzhin lo junt ze', ngulo' bixa' tu miyi' lë Jand tu lad, par mbin miyi' re', cho nzhap dol ngulen rë kure'; orze' miche'p pla rë men Israel Jand, tsao' plo nzhin rë xa' kizhin junt ze'. Orze' milu' Jand tu señ kun ya' xa' par nachao' men rruid, par di'zh xa' ke yent cho dol nzhap rë men Israel, rë xa' kwa'n nzho yezh re', por rë kwa'n nzhak re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Per or une rë men nzhin ze', lë' nu Jand nak men Israel, orze' tutsa kwa'n midi'zh rë bixa', se' nguruzhië bixa' pas chop or: ―¡Dox nazhon naxnax Diana che'n men yezh Efeso! ");
INSERT INTO zcaNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Per haxta xa' nak sekretar mile' ngulëz nguruzhië men, nzhab sekretar: ―Bin goi men Efeso, rë men yizhyuo nane, lë' yezh Efeso nikina yado' che'n naxnax Diana, me dox nazhon, mbaino winab che'n Diana kwa'n ngulali yibë'. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nal, rë be nane, kure' walika. Bila' go, nale'tra' go nazhe'b, mbaino biwi' go kwan le'u, par nale'u tu kwa'n nayen. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","¿Chon nguzen go rop miyi' re'? Yent ni tu kwa'n gat lë' mile' bixa' le'n yado' che'n be, mbaino ni nangadi'zh bixa' ni tu kwa'n nakap tich naxnax che'n be. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","No nal, chi nzhakla Met, kun rë xa' nikë xa' zhi'n kun lë', yi'd bixa' gake, chi nzho tu kwa'n nak tu men, lë' rë yalao naxa'l ka, no lë' rë gustis nzhin ka, nes par rube' cho nzhap dol. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","No chi nzho xtu kwa'n naki'n kuxkwa' go, naki'n le' goi xtu ngubizh, per le' goix nela xmod nidi'zhka ley che'n be, ");
INSERT INTO zcaNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","porke jwals gab gobier, nzhap be dol por kwa'n ngok nalzhë re', no orze' yent kwan gak di'zh be por kuba'. ");
INSERT INTO zcaNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Or milox midi'zh sekretar kure', orze' mile' xa', ña rë men. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","No or mire'chbe rë men nzhin ze', orze' ngurezh Pab rë men che'n Jesukrist xa' nzho yezh re', par miza' xa' konsej rë xa' re', orze' nzhab xa': “Lë'da ña la”, orze' nzha xa' par lazh men Macedonia. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","No or nded xa' rë yezh ze', mile' xa' más mixobla rë men che'n Jesukrist widi'zh che'n Dios, rë xa' kwa'n nzho ze'. No or milox nded Pab rë ze', ña xa' par lazh men Grecia, ");
INSERT INTO zcaNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","plo kwa'n mia'n xa' chon mbëo', mbaino mer ñen xa' kë xa' bark par nga xa' lazh men Siria, per or mbin Pab, lë' rë men Israel kila'ch la par gut rë men re' xa', orze' tutsa xigab mile' xa' yëk ska xa', par lazh men Macedonia, per neka ni' xa' ya xa', nes par zhin xa' lazh men Siria. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","No or nguio xa' nez par ded xa' lazh men Asia, nzhanu xa' rë xa' kwa'n lë Sópater, xga'n tu xa' lë Pirro, tu men yezh Berea; kun xtu xa' lë Aristarco, no kun tu xa' lë Segundo, tu xa' yezh Tesalónica; mbaino kun xtu xa' lë Gayo, tu xa' yezh Derbe, no kun Timoteo; mbaino kun Tíquico, no kun Trófimo, tu xa' kwa'n nzë lazh men Asia. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Rë miyi' re' nguzhubner lo no, no ngulëz bixa' yezh Troas. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","No or nded lani kwa'n nzhao men Israel pan kwa'n niyent levadur, orze' nguro' no yezh Filipos, par nkë no bark ña no yezh Troas. Gai' ngubizh nguio no le'n bark, par mizhin no yezh Troas. Ze' nguio no gazh ngubizh, plo mizhë'l no rë xa' kwa'n nguzhubner lo no ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Or ngol primer ngubizh che'n sman, nguzhin rë no par ndao no pan, orze' haxta garol yë'l ngulëz midi'zh Pab lo rë men che'n Jesukrist kwa'n nzho yezh Troas, porke riyë'l lë' xa' ro' la, par ya xa' xtu plo. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Le'n kwart al ya plo nguzhin no ze', nayax biani nikë. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mbaino lë' tu mbwin kwa'n lë Eutiko, nzob ro' tu bentán che'n kwart ze'. No por dox xche kidi'zh Pab, kuze' nguzen mika'l mbwin re', orze' ngob mbwin lo yuo haxta pis yon, no or ngwalits men mbwin, lë' mbwin ngut la. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Orze' ngula Pab lo yuo nguxo'b Pab ro' laxto' mbwin, orze' nde'x xa' mbwin, no nzhab xa' lo rë men che'n Jesukrist, xa' nzhin ze': ―Nazhebt go. Lë' mbwin naban ka. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Lwega' miëk Pab le'n kwart al ya xtu wëlt, no or ndi'z xa' pan par ndao bixa', orze' haxta ngwanilyuo une midi'zh Pab, orze' ña xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Mbaino mbwin re', ngwala' bixa' mbwin lizh mbwin, naban mbwin, kure' mile' más ngop rë men ze' jwers lo che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Orze' nkë no bark, par nguzhubner no lo Pab par nzha no yezh Asón, ze' ngulëz no, porke lë' Pab mile' la xigab, zhin xa' ni' xa' yezh ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","No or mizhin xa' plo kimbëz no, orze' nkë no bark kun lë' xa', par ngwa no yezh Mitilene. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","No or nguro' no plo nkë no bark, xtu riyë'l nded no kun bark ta' tu yezh win kwa'n lë Quío, kwa'n nzhin tsao' nitsdo', no lë' xtu riyë'l, nded no pwert Samos. No or nded no yezh Trogilio, ze' mile' no tu diskans tu rrat, no haxta xtu riyë'l, mizhin no yezh Mileto. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Se' ngokla Pab, porke net xa' kwëz xa' xche lazh men Asia, ni yezh Efeso nangat xa', porke dox ñen laxto' xa' zhin xa' yezh Jerusalén, par gal xa' lani kwa'n lë Pentecostés kwa'n nzhazhin la. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Or nzho Pab yezh Mileto, ngurezh xa' rë xa' nizo dilant, xid rë men che'n Jesukrist yezh Efeso. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","No or mizhin bixa' lo Pab, nzhab Pab lo bixa': ―Lë' go nane ka xmod miban da xid go lazh men Asia. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Aunke ter dox bid nde'da, mbaino mbina por rë kwa'n mile' men lazha kun na, no kun yalnado' milen rë kwa'n mile' Señor mandad da, or nguio'n xid go. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Rë go nane ka, nangakachta ni tu kwa'n wen lo go. Dilant lo rë go midizhai, mbaino nu lizh go mbidnine. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Dub lan minen konsej go, gat lë't nab rë men Israel mizane, sino ke nu rë men gat lë't men Israel mizane, par la' go rë kwa'n gat lë' kwa'n nak go, mbaino yila go Señor Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","No biwi'u nal, lë' Sprit che'n Dios mile' mandad da, lë' da ya yezh Jerusalén, no naneta kwan pa' zaka ba', ");
INSERT INTO zcaNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","per lë'da nane la, lë' Sprit che'n Dios ya ne la lon, kad yezh kwa'n yan, lë'da yo' lizhyi'b, mbaino dox zakzi men da. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Per yent kwa'n lë'i, zaka rë kuba'; ter haxta gat da; per naki'n loxa rë zhi'n kwa'n mine' Jesukrist len yizhyuo re', porke nile' Dios nizak laka laxto'n, or nidizha lo rë men, lë' Jesukrist niza' xtu mod ban men chul lo Dios, por nazhi' Dios men. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’No nal biwi'u, rë go xa' mbin, or milun rë wëlt, xmod ban men kun Dios, porke lë' da nane la, ya nayotra' ne go da. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kuze', nal kinin lo go, nagapta' dol lo Dios chi lë' go yitlo par dubta' lo Dios, ");
INSERT INTO zcaNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","porke yent kwan ngazheb da por men; rë kwa'n nzhakla Dios midizha lo go. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Kuze', mis go bikina go go, no bikina go rë men che'n Jesukrist kwa'n mika'b Sprit che'n Dios lo go, par kina go rë xa' kwa'n mixo Jesukrist ren por lë', nela xmod nile' rë baxtor nikina ma ga'. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Lë'da nane la, or yubchin lo go, orze' lë' xtu ben men yi'd xid go, nela rë ma nazhe'b kwa'n nzhao ma ga', par lo'x bixa' rë men nikina go. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Mis xid go yo rë xa' ki'l rë xa' nikina go, par yakë bixa' tich rë xa' re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kuze' biwi' go no bitsila go, lë'da dub chon li'n, zhë-yë'le dubta' minen konsej go, haxta mbina por kad go. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","’No nal wecha, lë'da la go ya' Dios par kina Me go, no bitsila go rë widi'zh che'n Dios kwa'n nidi'zh, nazhi' Dios men, par xobyek go Dios; mbaino par ne' Dios rë kwa'n wen ka' go, nela xmod mila' Dios di'zh za' Diose, ka' rë men che'n Dios, rë xa' kwa'n nambe laxto'. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","’No na, nangaklata ngayix go ngakan, no ni nangaklan ngane' go lar gaka, ");
INSERT INTO zcaNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","sino ke kun yub ya'n nkën zhi'n, par ngopa rë kwa'n naki'n da, no par mizan rë kwa'n naki'n rë xa' kwa'n nkizë kuda lo zhi'n nazhon che'n Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Se' milun lo go, par le' go zhi'n, no par gaknu go rë xa' kwa'n naki'n gaknu go, no par tsila go rë widi'zh kwa'n midi'zh Señor Jesús or nzhab Me: “Más wen nzha men xa' za' kwa'n ka' men, ke xa' za' mene ka'.” ");
INSERT INTO zcaNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","No or milox midi'zh Pab rë kure', orze' nguzuxib Pab kun más rë men par mina'b bixa' lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Orze' rë bixa' nzho'n, mbaino nde'zh bixa' Pab, no michiro' bixa' ta' kwats Pab, por tanta nazhi' bixa' wech bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","No dox miwin laxto' bixa', por kwa'n nzhab Pab: “Ya nayotra' ne go da xtu wëlt.” No ngulunez bixa' Pab, haxta nkili Pab bark. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","No or mila' no rë men che'n Jesukrist ze', orze' nkë no bark, par ngwa no nali laka lazh men Cos, tu yezh win kwa'n nzhin tsao' nitsdo'. No xtu riyë'l, mizhin no lazh men Rodas, xtu yezh win kwa'n nzhin ska tsao' nitsdo'. No di ze' ngwa no yezh Pátara, kwa'n nzhin ro' nitsdo'. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","No yezh Pátara nkë no xtu bark, kwa'n ña par lazh men Fenicia. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","No dub nzho no le'n bark ze', al lad izkierd che'n no mia'n yezh Chipre, kwa'n nzhin tsao' nitsdo'; orze' nzha no par lazh men Siria. No or mizhin no yezh Tiro, mila bixa' rë kwa'n nzho le'n bark. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ze', mizhë'l no pla men che'n Jesukrist kwa'n nzho yezh ze', no mia'n no kun lë' bixa' gazh ngubizh. No por Sprit che'n Dios, nzhab rë xa' re', nayat Pab yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Per or nded gazh ngubizh ze', nka' no nez ña no, orze' ngulunez rë men che'n Jesukrist ze' no, kun rë una' che'n bixa' no kun rë xmë'd bixa'. No ngulunez bixa' no zit par ro' yezh. No or mizhin no ro' nitsdo', ze' nguzuxib no, par guna'b no lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Orze' nzhab no lo bixa': “Lë' no ña”, nkili no bark, orze' miëk rë xa' kwa'n ngulunez no ze' par lizh bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nguro' no pwert Tiro, par mizhin no yezh Tolemaida, ze' ngula no bark, par ngwatsi' no ma rë men che'n Jesukrist xa' nzho ze', orze' mia'n no kun lë' bixa' tu ngubizh. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","No xtu riyë'l, nguro' no yezh ze' par mizhin no yezh Cesarea, ze' mizhin no lizh tu men che'n Jesukrist xa' lë Lip, tu xa' nilu' widi'zh che'n Dios por Jesukrist lo rë men, no lë' xa' re' nak tu rë miyi' kwa'n nguio xid za gazh miyi' kwa'n ndi'z kwa'n ndao rë men che'n Jesukrist yezh Jerusalén. Lizh xa' re' mia'n no. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Mbaino Lip nzhap tap xcha'p, no dap una' nab; no rë una' re' nidi'zh por Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","No pla ra' ngubizh nzha nzho no lizh Lip, no ze' mizhin tu xa' lë Agabo, xtu xa' nidi'zh por Dios; nzë xa' lazh men Judea. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Or mizhin xa' re' lo no, nguzen xa' sinch kwa'n nibin laxto' Pab, kun lë'i mis yub xa' mili'b xa' ya' xa' no ni' xa', orze' nzhab xa': ―Se' ne Sprit che'n Dios: “Se' li'nu rë men Israel kwa'n nzho yezh Jerusalén miyi' kwa'n nak che'n sinch re', mbaino chi bixa' miyi' re' lo xtu ben men, gat lë't men Israel.” ");
INSERT INTO zcaNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Or mbin no kure', kun más rë xa' nzhin ze', kwa'dox nzhab no lo Pab: —¡Nayatal yezh Jerusalén! ");
INSERT INTO zcaNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Orze' se' mikab Pab lo no: ―¿Chon nzho'n go, nile' go niwin laxto'n? Lë'da nzo la list, gat lë't nab par li'b dai, sino ke nu haxta par gat da yezh Jerusalén, por Señor Jesús. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ngale't no gan, ngala yek xa', kuze' nzhab no: ―Lë' Señor wane kwan le' Señor kun lë' xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","No or nded rë kure', mizuxkwa' no rë che'n no, orze' nguro' no yezh Cesarea, par nzha no yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","No nu pla men che'n Jesukrist kwa'n nzho yezh Cesarea, ngulunez bixa' no, par lizh tu xa' lë Mnasón, tu xa' kwa'n nzë tu yezh win lë Chipre, no dizde nzhala nak xa' re' tu men che'n Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","No or mizhin no yezh Jerusalén lo rë men che'n Jesukrist xa' nzho ze', dox wen mile' bixa' kun no. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","No xtu riyë'l, ngwa no kun Pab, ngwatsi' no ma Jakob, no nu ze' une no, nzhin rë xa' nzo lo rë men che'n Jesukrist, xa' nzho yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","No or milox minabdi'zh Pab chi wen ka bixa', orze' nzhab Pab lo bixa', tuga' rë zhi'n nazhon kwa'n mile' Dios xid rë men gat lë't men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","No or milox mbin bixa' rë kure', orze' nzhab bixa': “¡Dox nazhon Dios!”, no nzhab bixa' lo Pab: ―Lë' wech, lë'l nane ka, xid rë men Israel, nzho nayax men xa' ñila widi'zh che'n Dios por Jesukrist, per dox nguloyek bixa' le' bixa' ley kwa'n mila' Dios lo Muisés. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Per nzho men nzhab lo bixa', lu nilu' lo rë men Israel, rë xa' kwa'n nzho lazh men gat lë't men Israel, nzhabal nale'tra' bixa' kwa'n nzobni' lo ley kwa'n mila' Dios lo Muisés; mbaino nzhabal nakë't bixa' señ kwerp che'n rë xga'n bixa', mbaino ni nale' bixa' rë kostumbr che'n rë men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Xmod le' be nal, par ne men, gat lë't sa' nilu'l lo rë men?, porke rë men gon ka, lë'l mizhin re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Nal le'l kwa'n ne no lol re': Nzho tap miyi' xid no, xa' mila' di'zh le' tu kwa'n lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Wanu bixa', no bile' nela xmod le' bixa' kwa'n nzobni' lo ley kwa'n mila' Dios lo Muisés, par mbe laxto' rë go lo Dios. Gudix rë nak gaxt che'n bixa', no or milox mile' goi, orze' gak zhi'b yek go. Chi le'l se', rë men gab, gat walit kwa'n nidi'zh men por lu, nes par gab men, lë' nukal nile' ley kwa'n mila' Dios lo Muisés. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","No lu nane ka, mixë'l no yech lo rë men che'n Jesukrist, rë xa' gat lë't men Israel, par nzhab no: Nagaotra' bixa' kwa'n nixo'b lo winab, no ni nagao bixa' rë ma ngut di mizi'yen, mbaino ni nagao bixa' ren, no ni naka' bixa' men kwa'n gat lë't tsa' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Orze' ngwanu Pab dap miyi' ze', no xtu riyë'l ngwa Pab kun lë' bixa' par mbe bixa' nela xmod nzobni' lo ley kwa'n mila' Dios lo Muisés, orze' lwega' nguio Pab le'n yado' Jerusalén, par ngwayab xa' lo rë ngulëi' pok za zhë kwa'n mbe bixa', nez wei' kad bixa' tu gon lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Per ya mer la lox za gazh ngubizh par mbe bixa', lë'chi une pla men Israel, rë xa' kwa'n nzë lazh men Asia, lë' Pab nzo le'n yado' Jerusalén. Orze' ngulo rë men re' di'zh lo más rë men nzhin ze', par mile' bixa' nazhe'b, orze' nguzen rë xa' nzë Asia ze' Pab, ");
INSERT INTO zcaNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","naye kibizhië bixa': ―¡Rë go men Israel, goknu go zakzi be miyi' re'!, porke rë plo nikizë xa', kilu' xa' lo rë men, nidi'zh xa' gat lë't kwa'n nile' rë men Israel, no nu ley kwa'n mila' Dios lo Muisés gat ñalt le' be, mbaino nu yado' che'n be, nazu't nidi'zh xa'. ¡No haxta nu ngulo xa' pla men grieg, xa' gat nambet, le'n yado' che'n be, par mitsinu xa' lugar nazhon re'! ");
INSERT INTO zcaNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Kure' midi'zh bixa', porke lë' bixa' une la, nikizë Pab kun Trófimo yezh Jerusalén, no lë' Trófimo nzë yezh Efeso, kuze' mile' bixa' xigab, lë' Pab mbiy' rë xa' re' yado' Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","No rë nak xa' nzho yezh Jerusalén, nazhe'b mile' bixa', orze' karre migan rë men, nguzen bixa' Pab, no mizubxax bixa' Pab dizde le'n yado' haxta al tich, orze' lwega' mitsao' bixa' ro' yado'. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","No rë men re', mer ñen bixa' gut bixa' Pab, lë'chi karre ngwayab tu men lo komandant che'n rë sondad Roma, kwa'n nzhin yezh Jerusalén, lë' rë men yezh Jerusalén kile' nazhe'b. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","No lwega' nzhanu komandant re' rë sondad che'n xa', kun pla capitán, karre mizhin bixa' xid rë men ze'. Or une rë men kile' nazhe'b ze' lë' komandant nzhazhin lo bixa' kun rë sondad, orze' mila' bixa' nangayintra' bixa' Pab. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","No nguzubi komandant lo Pab, nguzen xa' Pab, orze' mile' xa' mandad, mili'b Pab kun chop kaden, orze' minabdi'zh xa' lo rë men nzhin ze': “¿Cho xa' re', mbaino kwan mile' xa'?” ");
INSERT INTO zcaNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Per tu xa' nibizhyë tu kwa'n, no xtu xa' xtu kwa'n, kuze' nangont komandant kwane por dox kibizhië men, orze' mile' komandant mandad, mbiy' sondad Pab plo nibin bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","No or mizhinnu sondad Pab plo nikë skaler par kili bixa' al ya, orze' mixo'b yën sondad Pab, par mbiy' bixa' Pab al nez plo nibin bixa', por dox nazhe'b kile' rë men ze', ");
INSERT INTO zcaNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","mbaino rë men nzadkë tras kibizhië bixa': ―¡Bit go xa' ba' tuli! ");
INSERT INTO zcaNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","No or mer nzhayo bixa' al le'n, orze' nzhab Pab lo komandant: ―¿Chi zak ganin tu kwa'n lo go? Orze' nzhab komandant: ―¿Chi nzhak nidi'zhal widi'zh grieg? ");
INSERT INTO zcaNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Orze' nzhab komandant xtu wëlt: ―¿No chi gat lë't lazh men egipto nzël, xa' mile' nangont men ro' gubier, nkizë xa' le'n yuo bizh, kun tap mil miyi' kwa'n nzhut men? ");
INSERT INTO zcaNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Orze' nzhab Pab: ―Na nak tu men Israel, xa' nzë yezh Tarso, tu yezh kwa'n nakbe' kwa'n ña'n lazh men Cilicia, kuze' kinin lo go, chi ziyël go dizha lo rë men re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","No or nguziyël komandant, orze' nguzo Pab plo nikë skaler, no mile' Pab tu señ kun ya' Pab, par nachao' men rruid, rë xa' nzhin ze'. No or nguzhin men xe, orze' nguzublo midi'zh Pab lo bixa' kun widi'zh hebreo: ");
INSERT INTO zcaNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","―Bin rë go wech, no dad, bin go kwa'n ganin lo go, par ne go, yent kwan nak da. ");
INSERT INTO zcaNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","No or mbin bixa' kidi'zh Pab lo mis widi'zh hebreo kwa'n nidi'zh bixa', más xe nguzhin bixa', orze' sigue kidi'zh Pab: ");
INSERT INTO zcaNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","―Na nak tu men Israel xa' ngol yezh Tarso, lazh men Cilicia, per miro'b da yezh Jerusalén. Lo Gamaliel mitse'da dike xmod nak rë ley che'n rë xuz be, no mixo'byeka len rë ley che'n Dios, nela xmod nile' go nal re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","No dox ngok nakap da lo rë xa' ñila widi'zh che'n Dios por Jesukrist, haxta ngoknun ngut pla bixa'. No nzho bixa' mili'bdo'n, par nguio bixa' lizhyi'b, wanei choi, miyi'y no una'i. ");
INSERT INTO zcaNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Lë' ngulëi' ro, kun rë xa' más nile' mandad le'n yado', rë xa' re' gak ne, lë' rë kwa'n kinin lo go, lë'i walika. Lë' bixa' mine' yech kan, mile' bixa' mandad da, mbi̱ña̱ yech lo rë wech be, men Israel, xa' nzho yezh Damasco, par ngali'bdo'n rë men che'n Jesukrist kwa'n nzho ze', orze' ngayidnun bixa' re' par ngazakzi bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","’Per or mer la nzhazhi'na yezh Damasco, pas mer garol zhë, lë'chi nguro' tu biani ro di lo yibë', miziniy naka'n plo nzhazë'n, ");
INSERT INTO zcaNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","orze' ngwachin da lo yuo, mbaino mbina tu widi'zh kwa'n ne lon: “¡Saulo, Saulo!, ¿chon yent por kwan kirukël ticha?” ");
INSERT INTO zcaNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Orze' nzhapa: “¿Cho go, Señor?” Orze' ne widi'zh ze': “Na nak Jesús, xa' nzë yezh Nazaret, xa' kirukël tich, yent por kwan.” ");
INSERT INTO zcaNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","No rë men xa' nzha kun na, nab biani ro ze' une bixa', per nangont bixa' widi'zh kwa'n midi'zh lon re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Orze' nzhapa: “Señor, ¿kwan nzhakla go len?” Orze' ne Señor lon: “Waxche no wa yezh Damasco. Ze' nzho tu xa' ne par kwan ngulen lu.” ");
INSERT INTO zcaNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","No por mile' yalnazhon che'n biani re' mikal lon, kuze' lë' rë xa' nzha no kun lë' nguzen ya'n, par mizhi'na yezh Damasco. ");
INSERT INTO zcaNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","’Ze' nzho tu miyi' xa' lë Ananías, tu xa' nzhon ro' Dios, no nzhon xa' ley kwa'n mila' Dios lo Muisés. No rë men Israel xa' nzho yezh Damasco re', wen ñët xa' re' xid bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Mbi'd Ananías plo nzho'n, orze' nguzubi xa' lon, ne xa': “¡Wecha Saulo!, biwi' xtu wëlt”, orze' ngulitsa lon, unen Ananías. ");
INSERT INTO zcaNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Orze' ne xa' lon: “Lë' Dios che'n rë xuz be xa' nzhala, dizde nzhala ngule Me lu, par nel xmod nak xigab che'n Me kun lu, no par ne yubal Me nile' rë kwa'n nzhakla Dios; mbaino par gonal yub widi'zh che'n Me kwa'n kibezhal, ");
INSERT INTO zcaNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","porke gakal xa' nidi'zh por lë' Me lo rë men, por rë kwa'n unel, no por rë kwa'n mbinal. ");
INSERT INTO zcaNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","No nal, ¿chon kimbëzal? Watsuli, no goklëi' le'n nits, no bina'b lo Señor par kubchi Me rë kwa'n nzë'b xkil.” ");
INSERT INTO zcaNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","’No or nguiubren yezh Jerusalén, orze' nguio'n le'n yado' re', no dub kina'ba lo Dios, milu' Dios tu kwa'n lon, ");
INSERT INTO zcaNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ne Me: “¡Karre guro' yezh Jerusalén!, porke nayilat men yezh re' kwa'n gabal lo bixa' por da.” ");
INSERT INTO zcaNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Orze' nzhapa lo Me: “Señor, rë men yezh re' nane, xmod nigotina rë xpenal le'n rë yo' plo nitse'd men widi'zh che'n Dios, par nigon bixa' lizhyi'b, no niyina bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","No or mbit men Teb xa' midi'zh xti'zhal lo rë men, mbaino mis na nzo orze', mbaino mis na nzhap ñal ka xa'i, no haxta xab rë xa' mbit Teb, mikinan.” ");
INSERT INTO zcaNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Orze' ne Señor lon: “Wa, porke lë'da xë'lal zit lo xtu ben men, gat lë't men Israel.” ");
INSERT INTO zcaNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","No lult kure' mixek men midi'zh Pab, orze' nguzublo, ngurezhië bixa' xtu wëlt, nzhab bixa': ―¡Gat ñaltra' ban miyi' re' yizhyuo re'! ¡Bit go xa' tuli! ");
INSERT INTO zcaNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","No dub kibizhië bixa', ngulo' bixa' lar kwa'n nak bixa' al tich, orze' kicho'n bixa' yuo al ya. ");
INSERT INTO zcaNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","No or une komandant se' kile' bixa', orze' mile' xa' mandad, ñanu sondad Pab plo nibin bixa', par rële tich Pab, no par gab Pab chon niyi' rë men, nine men Pab. ");
INSERT INTO zcaNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Per or nali'b la Pab par rële tich xa', orze' nzhab Pab lo tu capitán xa' nzo ze': ―¿Chi zak chël goi tich tu men Roma, tu xa' naga ne go kwan nak? ");
INSERT INTO zcaNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Or mbin capitán kwa'n midi'zh Pab, orze' ngwayab xa'i lo komandant: ―Nal, ¿kwan le' go kun miyi' ba'?, porke lë' xa' ne, nak xa' tu men yezh Roma. ");
INSERT INTO zcaNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Orze' nguzubi komandant re' lo Pab, nzhab xa': ―Bine lon, ¿chi walika, men Roma lu? Orze' nzhab Pab: ―Lë'i walika. ");
INSERT INTO zcaNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Orze' nzhab komandant: ―Nayax dox dimi milen gaxt par ngok da tu men Roma. Orze' nzhab Pab: ―Per na, nake dizde ngol da. ");
INSERT INTO zcaNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","No rë sondad kwa'n nzhakla ngachële tich Pab, or mbin bixa', lë' Pab men Roma, lwega' nguibchi bixa' lo Pab; orze' haxta nu komandant mizheb or mbin xa' kure', porke lë' xa' mile' mandad mili'b Pab. ");
INSERT INTO zcaNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","No xtu riyë'l ze', stubi nzhakla komandant ze' ne xa', chon nzhakla rë men Israel, gat Pab. Orze' ngurezh xa' rë ngulëi' ro, no kun rë gustis xa' más nile' mandad, orze' ngulo' komandant Pab al tich ze', mizo xa' Pab tsao' che'n rë xa' nile' mandad ze'. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Orze' xe miwi' Pab lo rë gustis ze', no nzhab Pab lo bixa': ―Wecha, dub naban da, haxta zhë nalzhë, nambe laxto'n lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Orze' nzhab ngulëi' ro', xa' lë Ananías, lo rë men nzo gax plo nzo Pab: —¡Bikë' go tube ro' xa' ba'! ");
INSERT INTO zcaNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Orze' nzhab Pab lo Ananías: ―¡Dios zakzil mbël goxa, chigab walika men wenal! ¿Chi nzobal ba' par kube'l, chi lë'da gat nile ley kwa'n mila' Dios lo Muisés, orze' nzë'b xkin? No chi walika nile'l kwa'n nzhab ley, orze', ¿chon kile'l mandad kë' xa'i ro'n? ");
INSERT INTO zcaNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Lë'chi mikab rë xa' nzhin ze', nzhab xa': ―¿Chi sa' di'zhal nazhe'b lo ngulëi' ro che'n Dios? ");
INSERT INTO zcaNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Orze' nzhab Pab: ―Wecha, naneta chi xa' ba' nak ngulëi' ro; porke se' nzobni' lo ley che'n Dios: “Naketal men nile' mandad lo rë men che'n Dios.” ");
INSERT INTO zcaNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Orze' une Pab, chop ben nak rë men ze'; tu ben bixa' nak men saduceo, no xtu ben bixa' nak men fariseo, orze' naye midi'zh Pab lo bixa': ―¡Wecha, nu ska da nzhal ben men fariseo! No nal, ¿chi nigube' go nzhapa dol, por ñilan lë' rë men ngut ruban? ");
INSERT INTO zcaNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Or nzhab Pab kure', orze' nguzublo kichëlro' rë men saduceo kun rë men fariseo, orze' milë' bixa', ngok bixa' chop montón, ");
INSERT INTO zcaNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","porke rë men saduceo nidi'zh: “Gat walit ruban rë men ngut, no gat walit nzho rë ganj che'n Dios, mbaino ni gat wali nzho rë mbi mal, mbaino ni sprit che'n men”; per lë' rë men fariseo xtu mod ñila bixa', ke lë' rë men ngut ruban, no walika nzho rë ganj che'n Dios, mbaino nzho ka mbi mal no walika nzho sprit che'n men. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","No di tanta kibizhië men, orze' ngwatsuli pla men kwa'n nzë xid men fariseo, xa' nilu' ley kwa'n mila' Dios lo Muisés, nzhab bixa': ―¡Yent ni tu kwa'n gat lë' mile' mbe re'; pas wali ka midi'zh tu sprit lo xa', o pas tu rë ganj midi'zh lo xa'! ");
INSERT INTO zcaNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","No di tanta nazhe'b kile' men, mizheb komandant, napa' chix bixa' Pab, orze' mile' komandant mandad rë sondad, ngulo' bixa' Pab jwers xid rë men ze', orze' mbiy' bixa' Pab xtu wëlt plo nibin bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","No mis zhë ze' or yë'l, ngurulo Jesukrist lo Pab, nzhab Me: ―Nazhebtal Pab; nela xmod midi'zhal xtizha lo rë men Jerusalén, se'ska naki'n di'zhle lo rë men yezh Roma. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","No riyë'l, nguzhin nayax men Israel, par kikwa'n bixa' mod gut bixa' Pab. Haxta mia'n bixa' di'zh lo Dios, zakzi Dios bixa' chi lë' bixa' gao no go bixa', no naga gut bixa' Pab. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","No más di cho' men, xa' mia'n di'zh le' kure'. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Rë xa' re' ngwayab lo rë ngulëi' xa' nile' mandad lo más rë ngulëi', no kun lo rë xa' kwa'n nzo lo rë men Israel, nzhab bixa': ―Lë' no mia'n di'zh lo Dios, lë' Dios zakzi no chi lë' no gao, no go no, chi naga gut no Pab. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Nal, go kun rë gustis xa' más nile' mandad, guzh go lo komandant yi'dnu xa' Pab lo go, par nabdi'zh go kwan pa' más nak xa'. Orze' lë' no kwëz la nez, par gut no xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Per mbin tu xga'n bizan Pab kwa'n midi'zh rë xa' re', orze' lwega' ngwa mbwin plo kinu sondad Pab, par nzhab mbwine lo Pab, ");
INSERT INTO zcaNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","orze' ngurezh Pab tu capitán nzo ze', nzhab Pab: ―Wanu go mbwin re' lo komandant, porke lë' mbwin kinu tu kwa'n gab mbwin lo xa' ba'. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Orze' ngwanu capitán mbwin re' lo komandant, nzhab capitán: ―Lë' Pab xa' nzho lizhyi'b re', ne lon: “Wanu mbwin re' lo komandant”, porke lë' mbwin re' kinu tu kwa'n ne lo go. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Orze' nguzen komandant ya' mbwin re', ñanu xa' mbwin tu lad, orze' nzhab komandant: ―¿Kwan nzhaklal nel lon? ");
INSERT INTO zcaNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Orze' nzhab mbwin re': ―Lë' rë men Israel tutsa mia'n bixa' di'zh, par ne bixa' lo go, xë'l go Pab yë' lo rë gustis xa' más nile' mandad, par rël bixa', kwan pa' más nak Pab. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Per nala't go, kide bixa' go, porke más di cho' bixa', mia'n bixa' di'zh lo Dios, zakzi Dios bixa' chi lë' bixa' gao no go bixa', no naga gut bixa' Pab. No nal, lë' bixa' kimbëz la nez, namás xë'l go Pab. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Orze' nzhab comandant lo mbwin re': ―Bizë, no yent cho lo gabal kure'. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Orze' ngurezh komandant chop capitán che'n xa', nzhab xa': ―Bikan go chop gayo' sondad kwa'n ya ni', mbaino chon gal nzho chi' sondad kwa'n ya kun kabai, no chop gayo' sondad xa' ya kun lans, par ya go yezh Cesarea nal guxin re', a las nueve. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","No za' go tu kabai zob Pab, par yent kwa'n zak xa' nez, no zhin xa' wen lo Jwels, xa' nak gobiernador. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Orze' mixë'l komandant ze' tu yech kwa'n nzhab se': ");
INSERT INTO zcaNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Lë'da lë Claudio Lisias, mixëla yech re' lo go, go gobiernador Jwels, xa' dox tsak. Kinin lo go ya go wen. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Lë' miyi' re', rë men Israel nguzen bixa' miyi', mbaino mer ngut bixa' miyi', per or unen, lë' miyi' re' tu men Roma, orze' ngwalata miyi' re' kun rë sondad da. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","No por nzhaklan nganen, por chon nzhab bixa', nzhap miyi' re' dol, kuze' mbi̱ña̱ miyi' re' lo rë gustis xa' más nile' mandad xid rë men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Orze' mbina, por ley che'n bixa', nzhab bixa' lë' miyi' re' nzë'b xki; per por ley che'n be yent kwa'n nak xa', mbaino ni gat ñal gat xa', no ni lizhyi'b gat ñalt yo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Per or mbina xla'n, lë' rë men Israel kila'ch par gut bixa' miyi' re', kuze' lwega' mixëla miyi' re' lo go. No milen mandad, yi'd rë xa' kwa'n nzhab, lë' miyi' re' nzë'b xki, par ne bixa' lo go por kwan nzhap miyi' re' dol. Rëtsa kuba' nin lo go. Ba' zhë'l be.” ");
INSERT INTO zcaNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Orze' mile' rë sondad ze' nela xmod mile' komandant mandad. Mis yë'l ze', mbiy' bixa' Pab tu yezh kwa'n lë Antípatris. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","No xtu riyë'l, rë sondad kwa'n nzha ni', nguiubre bixa' plo nibin bixa'; no lë' rë xa' kwa'n nzha kun kabai, nzhala' bixa' Pab yezh Cesarea. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Or mizhin bixa' yezh Cesarea, orze' miza' bixa' yech ka' Jwels, xa' nak gobiernador; mbaino nu Pab ngwala' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","No or milox mbi'l gobiernador yech re', orze' minabdi'zh xa' plo nzë Pab. Or mbin xa' lë' Pab nzë tu rë yezh lazh men Cilicia, ");
INSERT INTO zcaNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","orze' nzhab xa' lo Pab: ―Or zhin rë xa' kwa'n nidi'zh, lë'l nzë'b xki, orze' gona kwan di'zhal. Orze' mile' xa' mandad rë sondad che'n xa', par kina bixa' Pab le'n yalao che'n Herodes. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Or nded gai' ngubizh, lë'chi mizhin Ananías yezh Cesarea, xa' nak ngulëi' ro, kun pla rë men Israel xa' nak zhi'n, mbaino kun tu abogad xa' lë Tértulo. Rë xa' re' nzadnu Tértulo lo gobiernador, par gab bixa' kwan nak Pab. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","No or ngurezh gobiernador Pab, orze' kimbëz la abogad Tértulo, par gab xa' kwan nak Pab lo gobiernador. Galo laka, se' midi'zh xa': ―Xkix go, gobiernador; por go, dox wen naban no, por kizuxkwa' go rë kwa'n gat nak wen lazh no, por dox nane go kwa'n nile' go. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Dub lazh men Israel, ñët rë zhi'n wen kwa'n nile' go, O Jwels xa' dox tsak. Kun dub laxto'n, kinin xkix lo go. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","No par nadizha be's xche, kina'ba lo go, por wen laxto' go, tu rrat win tsa gon go kwa'n ganin lo go, ");
INSERT INTO zcaNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","porke une no miyi' re' nak nela tu yalyizh che'n Dios ga', rë men kike'd xa'i, porke rë plo nikizë xa', kichëldil xa' rë men Israel. Mbaino lë' xa' nak xa' nile' mandad xid rë xa' lë nazareno. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Mbaino haxta nu yado' lazh no, ngokla xa' ngatsinu xa', par nangakra'i nazhon, kuze' nguzen no xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Lë'chi orze' mizhin komandant Lisias, ngulutin xa' miyi' re' ya' no, dub xian xa', ");
INSERT INTO zcaNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","no ne xa' lo no, zob no demand xa' lo go re'. Per más wen, yub go nabdi'zh lo xa', par ne go, por kwan nzhab no lë' xa' nzhap dol. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","No nu rë men Israel xa' nak zhi'n, xa' nzhin ze' nzhab xa': ―¡Walika kwa'n midi'zh abogad re'! ");
INSERT INTO zcaNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Or milu' gobiernador ya' lo Pab par di'zh Pab, orze' nzhab Pab: ―Dub laxto'n dizha lo go, por rë kwa'n kikë' men kixu' da lo go, dizde nzhala, nak go gustis xid rë men lazh no. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Yub go gak nabdi'zh lo men par ne go, laore nzha tu dusen ngubizh, ngwan yado' Jerusalén par ngwazuxiba lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Or une bixa' da, yent cho ngane nzon le'n yado', kichëlro'n kun men, no ni nangane men kichëldila men le'n yado', mbaino ni le'n rë yo' plo nitse'd men Israel widi'zh che'n Dios, ni xtu rë plo nganet men da, kilen rë kuba'. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","No rë men re', yent ni tu kwa'n gak lu' bixa', par ne bixa', walika nak da rë kwa'n kikë' bixa' kixu' da lo go re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Per kwa'n nin lo go walika nak da, na nile rë kwa'n nzobni' lo Yech che'n Dios kwa'n mila' Me lo rë xuza xa' tiemp, lo mis kwa'n nak Nez Kub che'n Jesukrist, kwa'n nidi'zh men gat went. Lo mis se'ska nilen rë kwa'n nzobni' lo yech che'n ley, mbaino rë widi'zh kwa'n midi'zh rë profet, xa' kwa'n midi'zh por Dios chi tiemp. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mbaino na, ñila nela xmod ñila bixa', ke lë' rë men ngut ruban, xa' wene mbaino xa' gat nile't kwa'n wene; rë men ruban. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Kuze', dox niwi'n xmod nikizë'n, nela xmod nikizë rë xa' re', par ya'n da wen lo rë kwa'n nilen, nes par nambe laxto'n lo Dios, mbaino lo rë men. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","’No pla ra' li'n ngwan lazh xtu ben men, orze' nguiubren lazha, ñadnun nayax dimi, par rë men prob nzho lazha, mbaino mizan rë ma, par gon lo Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Kure' kilen le'n yado' or une pla men Israel da, xa' nzë lazh men Asia. Orze' laore mitsa laka rë zhë kwa'n ngok nambe da lo Dios, milen nela xmod nzobni' lo ley che'n rë men Israel. No ni nangane bixa' da kun tu bëd men, mbaino ni nangane bixa' da kilen tu kwa'n nazhe'b. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Per nal, ñal yid yub rë men nzë Asia ze', rë xa' kwa'n une da, par ne yub bixa' chi nzho tu kwan nizak bixa' kuda. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","O ne yub rë xa' nzhin re', chi une bixa' nzhapa dol por tu kwa'n gat lë', or mbiy' bixa' da lo rë gustis xa' más nile' mandad. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","O pas por midizha naye xid rë xa' nzhin ze', nzhab bixa' nzhapa dol por nzhapa: “¡Lë' rë men ngut ruban!” ");
INSERT INTO zcaNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Or mbin gobiernador Jwels rë widi'zh re', porke lë' xa' ya nane la, xmod nak Nez Kub che'n Jesukrist, kuze' nzhab xa': ―Or yi'd komandant Lisias, orze' ganin xmod gak kwent che'nal. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Orze' mile' Jwels mandad tu capitán, par kina xa' Pab, per gat lë'tra' nali'b Pabe, mbaino gak yatsi' rë men nichë'l Pab, lo Pab. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","No or nded pla ngubizh, nguiubre Jwels xtu wëlt kun tsa' xa', una' kwa'n lë Drusila, tu una' Israel. Orze' ngurezh xa' Pab par di'zh Pab lo rop tsa' xa' re', xmod pa' nak ñila men widi'zh che'n Jesukrist. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Per or midi'zh Pab, xmod nzhakla Dios ban men, mbaino midi'zh Pab nale'tra' men kwa'n nzhakla kwerp che'n men, porke lë' Dios gab xmod gak kun kad men por rë kwa'n nile' men yizhyuo re', orze' mizheb Jwels, no nzhab Jwels lo Pab: ―Bizë; ba' or gapa tiemp, kwezha lu xtu wëlt. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Per ka dimi nzhakla Jwels za' Pab par liya' xa' Pab, kuze' nayax wëlt ngurezh xa' Pab, par di'zh xa' kun Pab. ");
INSERT INTO zcaNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Per nded chop li'n, nguro' Jwels di gobiernador. Orze' nguio xtu xa' lë Porcio Festo xlugar xa'. No par ya'n Jwels wen kun rë men Israel, mila' xa' nzho Pab lizhyi'b. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Or mion ngubizh nzha di nak Festo gobiernador, orze' nguro' xa' yezh Cesarea par nzha xa' yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ze' rë ngulëi' kwa'n más nile' mandad, kun más rë men Israel xa' nak zhi'n, xla'n ngwayab bixa' kwa'n nak Pab lo gobiernador Festo, no dox guna'b bixa', ");
INSERT INTO zcaNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","par le' Festo jabor, xë'l xa' Pab par yezh Jerusalén, no lë' rë xa' re' midi'zh la, la'ch bixa' nez, par gut bixa' Pab. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Per nzhab gobiernador Festo lo bixa': ―Nabit Pab Jerusalén, neka nzho xa' ba', porke lë'da yubre ska yezh Cesarea lwega'. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","No nu nzhab Festo: ―Rë xa' más nile' mandad xid go, gak le' xa' kumpañ da par yezh Cesarea, no chi lë' mbe ba' mile' tu kwa'n gat ñal, orze' ba' gak ne goi lon. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","No or nded tu sman o chi' ngubizh nzha di nzho gobiernador Festo yezh Jerusalén, orze' miëk xa' par yezh Cesarea. No xtu riyë'l, nguzob gobiernador Festo plo nile' xa' yalgustis, orze' mile' xa' mandad, ñë'd Pab plo nzob xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","No or mizhin Pab, rë men Israel kwa'n nzë yezh Jerusalén, rë bixa' nguzhin naka'n plo nzo Pab, orze' nayax kwa'n nazhe'b mikë' bixa' kixu' Pab, no per ni tu rë kwa'n nzhab bixa' nak Pab, ngakt ngalu' bixa'i. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Per nzhab Pab lo Festo: ―Gat nakt da ni tu rë kuba', nangaleta ni tu kwa'n gat lë' kun kwa'n nzobni' lo ley che'n men Israel, no ni kun yado' che'n bixa', mbaino ni kun rey César nangaleta tu kwa'n gat ñal len. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Per lë' Festo nzhakla ya'n wen kun rë men Israel, kuze' nzhab xa' lo Pab: ―¿Chi nzhaklal, bil yezh Jerusalén, par ba' ganin, xmod gak rë kwent che'nal? ");
INSERT INTO zcaNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Orze' nzhab Pab: ―Nzon lo go, porke go tu xa' ngule rey César par le' yalgustis yezh Cesarea re'. Kuze', re' ñal, ne bixa' kwa'n nak da lo go. Mbaino lë' go, wena-wen nane go, ni tu kwa'n gat lë' nangaleta lo rë men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Chi nzho tu kwa'n nazhe'b milen par ñal gat da, pwes yent kwane gat da. Per chi gat nzë'ba ni tu kwa'n ne bixa' nak da, yent cho nzhap direch, chi da lo rë men Israel kwa'n niyi' nine da. Nal nina'ba lo go, mejor yub César kube' kwent da. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","No or midi'zhnu Festo rë xpen xa', rë xa' más nzhak ley, orze' nzhab xa' lo Pab: ―Lu mina'b bil lo rey César par lë' xa' kube' xmod gak che'nal. Nal lë'l bi lo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Nzha pla ra' ngubizh, lë' rey Agripa no Berenice bizan xa', ngwa bixa' yezh Cesarea par ngwatsi' bixa' ma Festo. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","No nayax ngubizh nzha nzho rey Agripa plo nzho Festo, kuze' ngok miza' Festo kwent che'n Pab lo rey, nzhab xa': ―Re' nzho tu mbe lë Pab nikë xa' lizhyi'b dizde li'n che'n Jwels ra'. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","No or ngwan yezh Jerusalén, xla'n mbi'dne rë ngulëi' ro lon, rë xa' kwa'n más nile' mandad, mbaino kun rë xa' nak zhi'n lo rë men Israel, nzhakla bixa' ngalen mandad, gat mbe re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Per nzhapa lo rë xa' re': “Rë no men Roma, gat kinut no ley, gut no tu men, si naga zhë'ldi'zh kwan nak xa' lo xa' kwa'n nzhab, nzhap xa' dol.” ");
INSERT INTO zcaNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kuze' or mbi'd rë men Israel lon, lwega' xtu riyë'l nguzo'ba plo nilen yalgustis, no milen mandad rë men da, par ñë'dnu bixa' mbe re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","No rë xa' mbi'dne kwan nak mbe re' lon; nanganet bixa' ni tu rë kwa'n nazhe'b, kwa'n milen xigab nak mbe re'. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Per nab tsa kwa'n mbina ne bixa' nak mbe re', por kwa'n xmod ñila mbe re' Dios, no por nize't mbe re' tu xa' lë Jesús, tu xa' ngut; per lë' mbe nidi'zh, lë' xa' nguruban. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Mbaino na, neta xmod kube'n rë kwent re', kuze' nzhapa lo mbe re': “¿Chi nzhaklal bil Jerusalén, par ba' ganin xmod gak kwent che'nal?” ");
INSERT INTO zcaNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Per lë' xa' lë Pab re' nzhakla, lë' rey César kube' kwent che'n xa'. Orze' milan nzho xa' lizhyi'b, lë'da ga' xë'l xa' lo rey, haxta or gake. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Orze' nzhab rey Agripa lo Festo: ―Nu da nzhakla gon, kwan ka nidi'zh mbe ba'x. Orze' nzhab Festo: ―Yë' gonle le. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","No xtu riyë'l, mizhin rey Agripa kun Berenice plo nibin junt, dox niwi' men lo bixa', orze' nzhab men, dox xa' ro rë xa' re'. Mbaino tutsa nzha bixa' kun rë komandant, mbaino kun rë xa' más tsak xa' nzho yezh ze'. Orze' mile' Festo mandad sondad che'n xa', ngwaka' xa' Pab. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Orze' nzhab Festo lo rë xa' mizhin ze': ―Rey Agripa, kun más rë go xa' nzhin re', lë' mbe re' nzë re'; rë men Israel kwa'n nzho yezh Jerusalén, no rë xa' kwa'n nzho yezh Cesarea re'; rë xa' re', haxta nguruzhië bixa', dox nazhe'b guna'b bixa' lon, ne bixa' gat mbe re' tuli. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Per na zak, yent cho dol kinu mbe re' par ñal gat mbe re'; per mis yub miyi' nzhakla, lë' rey César kube' kwent che'n miyi', kuze' milen xigab xëla miyi' lo xa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Nal re', neta kwan zo'ba lo yech, par xëla lo rey César. Kuze' milen mandad nzo xa' lo rë go re', per na niwi' lo go, xkwan ne go, or lox nabdi'zh go lo mbe re', go rey Agripa, porke dox nzhak go nigobe' go kwent che'n men, nes par ganen xmod zo'ba lo yech, or xëla mbe re' lo rey César, ");
INSERT INTO zcaNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","porke nilen xigab, chi xëla tu men nzho lizhyi'b, sin naga nen kwan nak xa', orze' gab men, yent yek kwa'n nilen. ");
INSERT INTO zcaNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Orze' nzhab rey Agripa lo Pab: ―Gak di'zhal por lu. Orze' ngulits Pab ya' Pab lo men, se' nguzublo midi'zh Pab, nzhab Pab: ");
INSERT INTO zcaNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","―Rey Agripa, dox wen nzhan nzon lo go, par dizha, gat walit nak da ni tu kwa'n ne men Israel nak da, ");
INSERT INTO zcaNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","porke go nane ka xmod nak rë kostumbr che'n rë men Israel, no rë kwa'n nichë'lro' bixa' xid bixa'. Kuze' kina'ba lo go gon go che'p kwa'n ganin lo go. ");
INSERT INTO zcaNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Orze' nzhab Pab: ―Rë men Israel nane ka xmod miban da xid bixa' dizde or win da, mbaino nane bixa' xmod miban da yezh Jerusalén. ");
INSERT INTO zcaNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","No por dizde nzhala nilibe' bixa' da, mbaino nu, chi nzhakla bixa'i, gak ne bixa'i, na ngok tu men fariseo, xa' kwa'n más nile' ley kwa'n mila' Dios lo Muisés, mbaino rë kostumbr kwa'n ñal le' no par ñakë no tich Dios. ");
INSERT INTO zcaNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","No nal, namás por ñilan, lë' rë men ngut ruban, nela xmod mila' Dios di'zh lo rë xuz no xa' tiemp, por kure' nzadnu bixa' da lo go, par le' go yalgustis kuda. ");
INSERT INTO zcaNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Mbaino dub tu dusen ben men Israel ñila kure'. Kuze' kun dub la bixa', zhëy-yë'le, nile' bixa' kult lo Dios. No nal, por ñilan kure', o rey Agripa, ne bixa' nzë'b xkin. ");
INSERT INTO zcaNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Rë go men Israel, nidi'zh go ñila go, lë' rë men ngut ruban, mbaino, ¿chon tatu nen par yila go lë' Jesús nguruban? ");
INSERT INTO zcaNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","’Nzhala, nu ka da mile xigab, dox ñal kwa'n milen, ngurukë'n tich rë men che'n Jesukrist, xa' nzë yezh Nazaret, par kana lo rë kwa'n nile' bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Nu yezh Jerusalén milen rë kure'. Guna'ba lo rë ngulëi', xa' más nile' mandad, par mine' bixa' permis, mitsao'yo'n rë xa' ñila Jesukrist. Mbaino nu or mile' rë ngulëi' mandad gat rë men che'n Jesukrist, nu da nzhap ñal ka rë xa' ba'i. ");
INSERT INTO zcaNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Nayax wëlt milen, mizakzin rë men che'n Jesukrist, par ngoklan ngala' bixa' ngayilatra' bixa' widi'zh che'n Jesukrist. Se'ga' milen rë plo nitse'd men Israel widi'zh che'n Dios. No por dox niyi' da ninen bixa', haxta lazh rë men zit ngwakwana bixa' par ngazakzin bixa'. ");
INSERT INTO zcaNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","’Kure' nzhalen, nzhan yezh Damasco, nzhatsena rë men che'n Jesukrist, por mandad che'n rë ngulëi' ro. ");
INSERT INTO zcaNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Per or nzhan nez, O rey Agripa, paste como garol zhë, lë'chi nguro' tu ki dizde lo yibë' kwa'n más nayi' nizini ke ngubizh, miziniy naka'n plo nzhan kun rë xa' kwa'n nzha kuda. ");
INSERT INTO zcaNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Orze' ngwachin rë no, no mbina tu widi'zh hebreo kwa'n ne lon: “Saulo, Saulo, ¿chon kirukël ticha? Chi lë'l dil kuda, lo mis lu kikwa'n yalne che'nal.” ");
INSERT INTO zcaNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Orze' nzhapa: “¿Cho go Señor?”, orze' ne widi'zh ze': “Na Jesús, no ticha kirukël. ");
INSERT INTO zcaNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nal waxche no watsuli. Ngurulon lol porke lu ngulen, par gakal tu xpena, mbaino par di'zhal rë kwa'n milun lol nal, no rë kwa'n laore lun lol. ");
INSERT INTO zcaNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Lë'da xë'lal lo rë men Israel par di'zhal lo bixa' por da, mbaino nu lo rë xa' gat lë't men Israel yal; per nalata gal ni tu rë men ba' lu, ");
INSERT INTO zcaNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","par xa'lal lo bixa', nes par nale'ra' bixa' kwa'n gat lë', sino ke le' bixa' kwa'n wen; no par rutin bixa' ya' Mizhab, orze' gon bixa' ro' Dios; nes par yubchi rë kwa'n nzë'b xki bixa' lo Dios, mbaino par yo bixa' xid rë men mixo'byek Dios, por ngwayila bixa' Da.” ");
INSERT INTO zcaNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","’Kuze' nin lo go, o rey Agripa, nangakta' da nad lo widi'zh kwa'n nguro' lo yibë' ze', ");
INSERT INTO zcaNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","sino ke galo laka yezh Damasco midizhne, dispwés ngwadizhne yezh Jerusalén, orze' midizhne dub lazh men Judea, mbaino lult midizhne lo rë men gat lë't men Israel; no midizhne kad plo, la' bixa' rë kwa'n nakap kile' bixa', par gon bixa' ro' Dios, mbaino le' bixa' kwa'n lu', walika mila' bixa' rë kwa'n nakap. ");
INSERT INTO zcaNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Por rë kure', nguzen rë men Israel da le'n yado', no ngokla bixa' ngut bixa' da. ");
INSERT INTO zcaNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Per por kiyaknu Dios da haxta zhë nalzhë re'; stubi naban da no nzon lo go, par dizha, walika lë' Jesús nak Krist, lo rë men wanei choi, xa' tsake o xa' natsakte. Nabtsa kwa'n nidizha nak kwa'n midi'zh rë profet, rë xa' midi'zh por Dios, haxta nu Muisés midi'zh la kure'. Rë bixa' midi'zh la, lë' rë kure' gak. ");
INSERT INTO zcaNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Rë bixa' midi'zh la, naki'n zakzi Krist, no haxta gat Krist. Per nu midi'zh bixa', lë' Me gak xa' galo laka ruban, par galo laka rë men Israel, xa'l Dios yek, mbaino xa'l Dios yek rë men, xa' gat lë't men Israel. ");
INSERT INTO zcaNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Stubi kidi'zh Pab kure' lo rey Agripa, lë'chi naye nzhab Festo: ―¡Pab, nzhak miyizhal! ¡Por tanta nzhakal yech, kuze' ngok miyizhal! ");
INSERT INTO zcaNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Orze' nzhab Pab lo gobiernador Festo: ―Gat lë't nzhak miyizh da, Festo, go xa' dox tsak; porke kwa'n nin lo go re' dox waliy, mbaino dox ñale. ");
INSERT INTO zcaNT_vpl VALUES ("AC26_26","074_26