﻿USE sofia;
DROP TABLE IF EXISTS sofia.zbu_vpl;
CREATE TABLE zbu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zbu_vpl WRITE;
INSERT INTO zbu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Gopti shilǝn ki Yesu almasihu, yakǝn ki Lya kǝnngu. ");
INSERT INTO zbu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kan u nǝɗa ki laci ge' lwatbati ki Ishaya mulnjeshinkǝn u, ti ussu, “In ngu an shin mulshinkǝn i ni tǝnnda kina, mulnǝ ti likǝni ki shitu u. ");
INSERT INTO zbu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Yal mul tati bi age' dǝlgǝn ti ussu, likǝni Lya shitu nǝ mbatldlwakǝn, likǝnǝ shituwasi.” ");
INSERT INTO zbu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yahaya mul baptisma mbi gawasi ge' dǝlgǝn, ti dlǝp shilǝn ki Lya, “Tǝ mbalǝn za pǝl bezǝn lǝɓa a pǝlsi baptisma tingaki tǝ pacisi bezǝn lǝɓa wasǝn ɗa.” ");
INSERT INTO zbu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mbalǝn ki galt ki Yahudiya nǝ kum mbalǝn ki Ulushalima is go' mbǝ' mati, a si dlǝp bezan lǝɓa u nǝs pǝli u, i pǝlsi baptisma a dlilka ki Uldun. ");
INSERT INTO zbu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yahaya ti nǝ ulki laki a dli ki medlǝn ki Lakumi, nǝ ulkǝndǝdlom ki bati amisi, ulki ɗami wasi zhita nǝ mal du. ");
INSERT INTO zbu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ati dlǝp shilǝn ki Lya, i' usu, “Mulǝn ɗǝ mbǝti ge kalini mul nalti ngǝdlǝni, zhim kaptalan wasi ambǝci ta ngusi a ɓatli wai. ");
INSERT INTO zbu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","A miɓo ge mal kǝn ami pǝlikin baptisma, tiɓo nǝ Yal ki mbatl ki Lya ki zeki ti pǝlikini.” ");
INSERT INTO zbu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nǝgu dǝmi Yesu i' mbǝ te' Nazillat ge atl ki Galili, i Yahaya pǝli' baptisma a dlilka ki Uldun. ");
INSERT INTO zbu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ɗǝ petuwasi to' ge mali i' en lya abuli, i Yal ki mbatl ki Lya pesul lya kǝnǝ kulu. ");
INSERT INTO zbu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","I kum yalon sul lya ɗǝ ussu, “Kiki yakuyini gunǝ ami lyamti, nǝti ami holtugi iye.” ");
INSERT INTO zbu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Alǝbi alǝbi i Yalkimbatl ki Lya dloti i' te' ge' dǝlgǝn, ");
INSERT INTO zbu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","A tiki dǝmi, mutti kutl kutl lǝbi upsi, a Shedan ɗǝ cibǝlti, atine' tlu kige' dǝlgǝn a mi' shinkǝnki Lya ɗǝ pǝlliti kyautǝn. ");
INSERT INTO zbu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kalki dlǝl Yahaya, I Yesu te ge' atli ki Galili, ati dlǝm shilǝn ki Lya. ");
INSERT INTO zbu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ati ussu “Cini apoyi gunki Lya ɓalnja i. Zakǝn pǝtl byazǝn lǝɓa ndǝnǝ nǝ shilǝn ki Lya.” ");
INSERT INTO zbu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ati ɓeuti abi dlilka ki Galili, i' en ki Bitlus nǝ Andalawus yelse wasi, asi lati lekku a dlilka tǝngaki si mi' gopti Kes kǝnǝ. ");
INSERT INTO zbu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","I Yesu ulsisu “bǝlǝnnǝn kali, an palkini adǝmni mi' ngau mbalǝn.” ");
INSERT INTO zbu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Alǝbi alǝbi is za lati lekku wasǝn is bǝlti kali. ");
INSERT INTO zbu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nǝs ɓeu kina ten i' en Yakubu nǝ yelse wasi Yahaya, mil ki Zabadi, a ge Kudǝlǝn ki mali asi likǝ' lekku. ");
INSERT INTO zbu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nǝ' takisi bi'u Alǝbi alǝbi is bǝlti kali. Is za bwaswasǝn Zabadi age Kudǝlǝn ne' mil pǝliti kyautǝn. ");
INSERT INTO zbu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Is tege gatl ki Kapalnahum cin shuti, i' Yesu tege lu dopga ki Yahudawa ati kulcisi shǝlǝn ki Lya ɗaɗanu. ");
INSERT INTO zbu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Is en ulki gagashinti tǝn ulnǝ ti kulcissi u, tǝn gaki ti kulcissi kǝnǝ gunǝ ti kumti nǝ ndǝlton u, bǝ kǝnǝ mi' lashti zhil ki Musa wai. ");
INSERT INTO zbu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mulǝn ɗa, mul du mi'gatli a ge'lu dopga wasǝn, i' la yali, ");
INSERT INTO zbu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","I' usu, “Yalamineki Yesu yakǝn nazalet? Ki mbǝni ki hwotimi bezǝn lǝɓa ya? A manini ki wokǝni, ki yakǝn ki Lya mul zo'mbadl kǝni!” ");
INSERT INTO zbu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","I Yesu mati mi'gatli ki geti, i' usu, “Dǝm shot! Pe' ɗǝ ge mulu!” ");
INSERT INTO zbu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","I ki i bezǝn mi'gatli i' u mulisi. I' la yali, i' petaka geti. ");
INSERT INTO zbu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kum mbalǝn en ulki gagashinti, is go' gyep yelsǝni, a si u'su, “Yakǝn nǝgu u? A sǝti pyal kushti won ngǝ! Mulu tinǝ ndǝtl ki pi' du mi'gatliyi shilǝn, a si kup shilǝn wasi!” ");
INSERT INTO zbu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Alǝbi alǝbi shilǝnni zǝga ko una ge' atl ki Galili. ");
INSERT INTO zbu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nǝ petwasǝn ge' lu dopga ki Yahudawa, ki Yakubu nǝ Yahaya is te libi ki Bitlus nǝ Andalawus. ");
INSERT INTO zbu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kom ki Bitlus ki muɗi atli ti gonti, nǝ te ki Yesu, is piti. ");
INSERT INTO zbu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","I' lǝ mati, i' gopi' toh i' tliltilya, i' ndoki, i' hilya ma i' pǝlisi kyautǝn. ");
INSERT INTO zbu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","A suti, kalki ki nda ki cin, is mbǝlli Yesu mi' gonti, nǝ mil mi'gatli. ");
INSERT INTO zbu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","I mbalǝn ki ge' gatli kup si domga a kina dlabi. ");
INSERT INTO zbu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","I' ndokǝl mbalǝn diɓǝli, ko wongi nǝ unndi gontuwasi, iki pe'kǝl mil mi'gatli diɓǝlli. Ta ndǝgi tǝ mi'gatli shilǝn wai, tǝn gaki simanǝnti. ");
INSERT INTO zbu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nǝ kyau, balu a pa' ciltuwai, I Yesu hilya i' peki, i' zǝga gelu u nǝ bǝ mbalǝn ɗawai u, i' zǝga ɗǝ shilǝn nǝ Lya tyaka ");
INSERT INTO zbu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","I Siman nǝ mbalǝn u nǝ tinesi u is zǝga ɗǝ ngauti. ");
INSERT INTO zbu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nǝs mbitu, is ultisu, “kup mbalǝn ɗǝ ngauki.” ");
INSERT INTO zbu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","I Yesu ulsisu, “Mǝlǝn ge' gatlu gunǝ kina u, ta dlǝm shilǝn ki Lya ɗa ɗanu. Ulnǝ laki yambǝɗa ungu.” ");
INSERT INTO zbu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","I kup ti tya'tya ge' atl ki Galili a ti dlǝm shilǝn ki Lya a ge' lu dopga ki Yahudawa, a ti pyakǝli' mbalǝn mi'gatli. ");
INSERT INTO zbu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mul go' ki dakǝlti i'mbǝ ma Yesu, i' ngusiti i'ngemti, a ti ussu, “Inka ndǝgu, kin ma'paltǝn mul lǝshi ɗa'ti. ");
INSERT INTO zbu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","I ci' gontuwasi gop Yesu, i' ta toh wasi i' tǝnti, i' ultisu, a ndǝgi, a ndokǝlki, dǝmi mul lǝshi ɗati!” ");
INSERT INTO zbu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Alǝbi alǝbi i dakǝltisi zati, i' dǝm mul lǝshi ɗati. ");
INSERT INTO zbu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","I ki i Yesu pi' shilǝn mul ndǝlti, nǝ tǝs zǝga u. ");
INSERT INTO zbu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","I' ultisu, “Bǝ pi mullǝn wai. Mǝllǝ le' en lǝɓa, a bǝl Lya ulki okǝtl bezǝn lǝɓa kanwunǝ Musa dlǝmi u tǝn gaki wokǝlti. Pǝli nǝgu tǝngaki tǝ mbalǝn mani ɗa ka ndoki.” ");
INSERT INTO zbu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ge' shuki nǝgu, i muli peki i go' dlǝp shilǝnni tyai. I gu la Yesu ta man te' ge gatlon a dwaɗǝn ɗǝ ye' dwaɗǝnwai, i' go' dǝp gelu u nǝ mbalǝn ɗa wai u. Ngo nǝ nǝgu, mbalǝn go' mbǝ mati, te' ge lu en. ");
INSERT INTO zbu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kal ki mutti ten, nǝ palte' Kapalnahum, is kummi ti a libi. ");
INSERT INTO zbu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","I' mbalǝn dom ga diɓǝlli, lu zǝ' a sǝn ma ɗawai, abi dlabi ma. A Yesu ɗǝ pi'si shilǝn ki Lya. ");
INSERT INTO zbu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mbalǝn upsi is mbǝ, is kam Mulǝn tyai ki tle ki mi'gatli. ");
INSERT INTO zbu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Saman tǝla'ti ma Yesu wai tǝngaki diɓǝtl ki mbalǝn, is mbulǝn gabini tu' malu u nǝ Yesu ɗa u nǝs mbul gabini u, is shim muli suɗi, nǝ lu muttuwasi. ");
INSERT INTO zbu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nǝ Yesu en lati mbatluwasǝn u i' ulmul ki tle ki mi'gatlisu, “Yakuyini a paci bazǝn lǝɓa wagi.” ");
INSERT INTO zbu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mbalǝn mi' lashti zhil ki Musa siki dǝmi a lǝbi, a si shilǝn a mbadli, ");
INSERT INTO zbu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","A si ussu, “Ya lakiɗa mulu ɗǝ shilǝn nǝgu? Pǝli' Lya bezǝn lǝɓa ti ɗa! Wokǝn ma' wokǝli yakǝn mbalǝn bezǝn lǝɓa wasi ǝnbǝ Lya kǝn nǝmmwai u?” ");
INSERT INTO zbu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Alǝbi alǝbi i Yesu man ulnǝ si dlǝmti a mbadlu, i Yesu ulsisu, “Yakǝn laki ɗa ki unndi shilǝn u a mbadlwakǝn? ");
INSERT INTO zbu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Gukǝn ngǝtli nǝ mbǝlǝ, ti ulmul ki tle usu, ‘A wokǝli bezǝn lǝɓa wagi’ nǝ ta usu, ‘Hilya kam lumuttwagi ki zǝgaya?’ ");
INSERT INTO zbu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ami lyamti ki manini Yakǝn mbalǝn ti nǝ ndǝtl ki wokǝl bezǝn lǝɓa a dǝplaɓa.” I' ul mul ki tle ki mi'gatli su ");
INSERT INTO zbu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“A ulkisu, hilya kam lumuttuwagi ki zǝga libi.” ");
INSERT INTO zbu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","I Alǝbi alǝbi tǝ hilya, i' kam lumuttuwa si, i' peki a kum mbalǝn ɗǝ yetti, a si kup gagashinti, a si natl Lya asi ussu, “Ma en ulǝn nǝgu gason wai.” ");
INSERT INTO zbu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu peki i' lǝ bi Dlǝlka ki Galili ɗa ɗanu, Mbalǝn diɓǝli is domga a malgǝn wasi, ati kulcisi. ");
INSERT INTO zbu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","A ti beuti, i' en Lawi yakǝn ki Halpa ki dǝmi ati kyautǝn ki ka' upki ban. I Yesu ultisu, “Bǝlǝn kali.” I' hilya i' bǝlti kali. ");
INSERT INTO zbu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Gason Yesu ɗǝ ɗap ulki ɗami a libi ki Lawi, mul ka' upki ban ne mi'bezǝn lǝɓa nǝ mbalǝn diɓǝli si ɗamti ne'ti ne mil kushti wasi, tǝn gaki mil diɓǝlti gesi mi' bǝtlti ni; ");
INSERT INTO zbu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nǝ mi' lashti zhil ki Musa si palisiyawani is enti ɗǝ ɗamti nesi, nǝ mi'bezǝn lǝɓa nǝ mi' ka' upki ban u, is ul mi' kushti wasisu, “Ya laki ti ɗamti nǝ tleti ne' mi' kap upki ban nǝ mi'bezǝn lǝɓa ɗa?” ");
INSERT INTO zbu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nǝ Yesu kumi nǝgu u, i' ulsisu, “Mi' ginǝ bǝ ɗa gontwai u sikǝn lǝ' mamul pǝtl igǝn wai, mi' gonti si ɗǝ ngau mul igǝn. Tǝn gaki mi' pǝtl ze kautǝnkǝn a mbǝɗawai, tǝn gagi mi' bezǝn lǝɓa ni.” ");
INSERT INTO zbu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mi' kushti ki Yahaya mul baptisma nǝ ki palisiyawa si pǝtl kuzǝn mali. Mbalǝn en ngem Yesu is usu, “Yalaki ɗa mi' kushti ki Yahaya nǝ ki palisiyawa si kuzǝn mali gwaɓo si ɗa pǝtl ti wai?” ");
INSERT INTO zbu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","I Yesu ulsisu, “Yelǝnsi ki mul kutleti sǝn pǝtl kuzǝn mali a mul kutleti nesiya? Tunnǝ mul kutleti nesi u sǝkǝn pǝtl kuzǝn malilwai, ");
INSERT INTO zbu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Cin ɗǝ mbǝti sinkap mul kutletiyi taka ɗǝ masi. Cinisini sǝn pǝtl kuzǝn mali. ");
INSERT INTO zbu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kǝn ca'ti mbulǝn gǝsi nǝ pyal lulutwai. In a caki nǝ nali u, pyal luluti nǝn kyeshti gus lulutisi, nǝn ngǝtlti ki kal nǝ kyeshti. ");
INSERT INTO zbu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kǝn bǝna pyal mal ki mil pǝ' ki annabi ge gus kal ki bati wai. Mun nǝ a bine u, mali si nǝn tatlti kal ki bati si, a hol kal nǝ mal innabi isi. Pyal mal ki mil pǝ' ki innabi, sai nǝ pyal kal ki bati.” ");
INSERT INTO zbu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Gason cin shuti, Yesu ne mil kustiwasi si ɓeuti ge' gu ki alkama. Sige ɓeuti i mil kusti ki Yesu is go' catl ga alkama en. ");
INSERT INTO zbu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","I palisiyawa ultisu, “En ulnǝ mil kushtiwa ɗǝ pǝlti u. Ya laki ɗa si pǝtl ulnǝ zhil ki Musa a ndigi ti pǝlti cin ki shutwai u?” ");
INSERT INTO zbu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","I Yesu njesi shilǝn nisi i' ulsisu, ka kummǝn shilǝn ki ulnǝ Dawuda pǝli u waiya, cin u nǝ kuzǝn gopti, ti ne' yelǝnsi lǝtwaswaiya? ");
INSERT INTO zbu_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Hwon u nǝ Abiyatal tiki bal lǝɓa, Dauda tege' Libi ki Lya, i' ɗam biledi gunǝ zǝdli u iki bǝl yalǝnsiwasi ginǝ ne'tu, ki ɗami ki lǝɓasi ni nǝgwasǝn mulǝn kǝn ɗamtwai. ");
INSERT INTO zbu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","I Yesu ulsisu, “Pǝlǝn cin shuti tǝngaki mbalǝn, ba pǝlǝn mbalǝn gaki cin shutuwai. ");
INSERT INTO zbu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yakǝn mbalǝn kǝnki mulban ki shuti nǝ ki cin shuti.” ");
INSERT INTO zbu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","I Yesu te ge' lu dopga ki Yahudawa, mulǝn ɗa alǝbi mul toh kitle ki mi'gadli. ");
INSERT INTO zbu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tǝn gaki sǝmbi shitu ki gopti Yesu ɗa. I mbalǝn yen zid dwaɗǝn, tǝn ndokǝl mulisi cin shutwa? ");
INSERT INTO zbu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","I Yesu ulmul toh ki tle yisu, “Pete' ki akina.” ");
INSERT INTO zbu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","I Yesu ulsisu, “Ambuni tǝ pǝl ze' lǝɓa ko bezǝn lǝɓa cin shuta? Ti pekǝl mul mǝshti, ko ti tlota?” Is dǝm shot. ");
INSERT INTO zbu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nǝ' yasi nǝ mbadli ki lewi u, ati du mbadli nǝ ɗashti ki mbadlwasǝn, i' ul mulisisu, “Ta' toh wa'teɗi.” Ittakit tye, i toh was pal lǝbi. ");
INSERT INTO zbu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nǝ palisiwa yani nǝgu u is peki, Alǝbi alǝbi is dlil shilǝn nǝ mbalǝn ki Hilidus a tǝnti, kau u nǝ si' tlotu. ");
INSERT INTO zbu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","I Yesu hilya ne' mil kushtiwasi, is za'gatli is lǝ tya bi dlǝlka ki Galili. Mbalǝn mi' diɓǝlti iye ki Galili is bǝlti kali. ");
INSERT INTO zbu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Nǝs kum ulnǝ ti pǝlti u, mbalǝn is mbǝ te' Yahudiya nǝ Ulushalima, nǝ atl ki Edom, nǝ te' bǝ gasi ki dlǝlka ki Uldum, nǝ te'ge luki Taya nǝ Sidom, bal dopga mbǝ mati, tǝn gaki si' kum ulnǝ ti pǝlti u. ");
INSERT INTO zbu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tǝn kitǝlli' ɓa mbalǝn diɓǝli gyemti, i ul mil kushtiwassu shakǝli nǝn kudǝlǝn ki mali nǝm teɗi. ");
INSERT INTO zbu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ti' pǝlin nǝgu u tǝn gaki ta ndokǝl mbalǝn diɓǝlli, i laki ɗa kum mbalǝn mi' gonti si shimga te' mati tǝn gaki si' tǝnti. ");
INSERT INTO zbu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Du mi'gatli, ko anǝmi si enti, as nda kinawasi asi lati yali, asi ussu, “Ki yakǝn ki Lya kǝnǝ.” ");
INSERT INTO zbu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","I' dlǝmisi bǝs pi mbalǝn okǝnki ti wai. ");
INSERT INTO zbu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","I' Yesu totǝn zǝnga, i' taki ginǝ ti lyap siyi bi, is lǝ mati. ");
INSERT INTO zbu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","A gesi is zabǝl mbalǝn kutl nǝ lop si' dǝm neti, tǝn gaki ti'go' shi'si asi dlǝm shilǝn ki Lya, ");
INSERT INTO zbu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","I' bǝlsi dǝlti ki pekǝl du mi'gatli. ");
INSERT INTO zbu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ginǝs zabǝl siyi kǝngyi, Bitlus, ");
INSERT INTO zbu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Nǝ Yakubu yakǝn ki Zabadi, Nǝ yalkewasi Yahaya, i' bǝlsi shin Buwanaljis' mil ki ndaltannaca. ");
INSERT INTO zbu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Iki ɗaɗanu i' zabǝl Andalawus, nǝ Pilibus nǝ Baltamawas, nǝ Matiyu, nǝ Toma, nǝ Yakubu yakǝn ki Halpa, nǝ Taddawus, nǝ Saminu Bakan'ane, ");
INSERT INTO zbu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Nǝ Yahuza Iskaliyoti gunǝ bǝl Yesu. ");
INSERT INTO zbu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","I Yesu te' libi won, iki i mbalǝn dopga ɗaɗanu hal saman ɗap ulki ɗami wai ti ne' mil kushtiwasi. ");
INSERT INTO zbu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nǝ yelsǝnǝ wasi kumi nǝ gu u, iki is lǝ ɗǝ goptiti, tǝn gaki si usu, “Ga agǝliti.” ");
INSERT INTO zbu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mi' kushti zhil ki Musa gǝnǝ pete' Ulushalima is usu, “Ba'alzabul kǝn totǝnti! Nǝ ndǝtl ki guu mi'gatlkǝn ti pekǝtl mi'gatli.” ");
INSERT INTO zbu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","I Yesu takisibi, i' cimbǝlisi i' usu, “A u kǝn ti Shaɗan man pekǝtl Shaɗan? ");
INSERT INTO zbu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","In gu' a bwasi a tǝn nge yelsǝni u, guntu kǝn lǝ' kinawai. ");
INSERT INTO zbu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nǝgu in libi a bwasi a tǝn nge' yelsǝni u, libi u kǝn lǝ' kinawai. ");
INSERT INTO zbu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","In shaiɗan a dlani ga wasu, a bwasi, kǝn lǝ'kinawai, patwas kǝnmbǝ. ");
INSERT INTO zbu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mul ma' te' ge libi ki mul ndǝlti a' em galwasi ɗawai. In ba' kǝndi mul ndǝlti wai u, iki annda yep gal ki libini. ");
INSERT INTO zbu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Bali ami pi'kini nǝn paci ko mulu kǝn bezǝn lǝɓawasi, nǝ bezǝn shilǝn u nǝ' tǝpǝli u. ");
INSERT INTO zbu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Gunǝ a pǝli Yalkimbatl ki Lya ki gunti bezǝn lǝɓa u, kǝn paci tiwai, nǝ ngatlti ki dǝp lǝɓa.” ");
INSERT INTO zbu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Gi ɓo si usu, “Du mi'gatli ni'ɗa.” ");
INSERT INTO zbu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Iki dya ki Yesu ne' yelsǝniwasi is mbǝ. Is dlil a dla, is ta' shinkǝn timmbǝ. ");
INSERT INTO zbu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Dop ga ki mbalǝn ki dǝmi a malgǝn wasi, is ultisu, “Dya wa' kǝngu nǝ yelsǝni wagi si kauki a dla.” ");
INSERT INTO zbu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","I' gyemsi, “ki wokǝn ki dya ini nǝ yelsǝni ini?” ");
INSERT INTO zbu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","I' ya ginǝ a malgǝn wasi, i' usu, “Dya ikǝngu nǝ yelsǝni ini! ");
INSERT INTO zbu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ko mulu kǝn pǝl ulnǝ Lya ɗǝ lyamti u, tiki dya ini nǝ yelsǝni ini, tiki koli ini ɗaɗanu.” ");
INSERT INTO zbu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ɗaɗanu Yesu a gop kulci'si shilǝn ki Lya abi dlilka u ɓalu, I' mbalǝn mil diɓǝlti domga amati, I lati, i'te ge' kundǝlǝn ki mali, Adlǝlka, i' dǝm a giɓi. I' dopga ki mbalǝn dlǝl atǝn bǝgasi abi dlǝlka isi. ");
INSERT INTO zbu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","I' kulcisi lǝɓa diɓǝli nǝ cibǝlti. A ge kulcisiwasi i' ulsisu, ");
INSERT INTO zbu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ga kǝn kum! Mulǝn mul kotllu won ɗa is zǝga gegu tǝn gaki ti' wotl o'. ");
INSERT INTO zbu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tige dlati wundi lǝɓa, Ina wundiyen nda tǝn shutu, i yatli ɗakǝn unndiyisi. ");
INSERT INTO zbu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Un ndiyen is nda age lu mul zǝnga luwu nǝ bǝ atl ɗa iye wai u. Alǝbi alǝbi is te' tǝn gaki atli loluwai. ");
INSERT INTO zbu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nǝ cin peku, Is landǝli, tǝn gaki dlǝlgwasǝn loluwai, Is kwakǝni. ");
INSERT INTO zbu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","I gyen nda age ili, I ili sǝnkǝlsi, Sa man pǝtl gwewai. ");
INSERT INTO zbu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","I gyen ɗaɗanu is nda gye lu atl ki zeki, Is te' kizeki, Is nali, Is pǝl gwe, I gyen pǝl gwe kutl kutl lǝbi maki, Gyen kutl kutl lǝbi mǝkka, Gyen kutl kutl lǝbi kutl.” I Yesu usu, ");
INSERT INTO zbu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","“Mul kǝm ki kumti tǝ'kumi.” ");
INSERT INTO zbu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nǝs pal mal gǝni u, Mil bǝtlti nǝ kutl nǝ lopiyi iki is gyemti yakǝn cimbǝlti u ɗǝ dlǝmti. ");
INSERT INTO zbu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Iki i' ulsisu, “Kini ɓo, a ndǝgikini i kimannǝn tuki libi ki Lya, Gyen ginǝ bǝ ɗa gyekini wai u, Sai nǝ cimbǝlti. ");
INSERT INTO zbu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","“ ‘Yenti nǝ dwaɗǝn ɓo, Sa yeniyi, bǝ a mbatldlwai. Kumti ɓo, Sa kumiyi, Sa man ulnǝ ɗǝ dlǝmti u wai, Tǝn gaki, ɓaspaltyai a pacisi bezǝn lǝɓa wasǝn ɗa.’ ” ");
INSERT INTO zbu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu ulsisu, “A!, Kimanǝn ciɓǝlti uwayya? Tu i mi kǝnkimanǝn na ciɓǝlti en ɗa? ");
INSERT INTO zbu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mul wotlti o' u, Shilǝn ki Lya kǝnti wotlti. ");
INSERT INTO zbu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ginǝ ndatǝn shutu u ɓo, Siki ciɓǝlti ki gǝnǝ wotl shilǝn ki Lya a mbatl dlwasǝn u. Sǝn kup shilǝn nisi, Alǝbi alǝbi a shaidan kam shilǝn u nǝ wotldli a mbadlwasǝn u. ");
INSERT INTO zbu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nǝguni ɗaɗanu gunǝ wotl unndi o' a ge lu zǝnga u, Siki ginǝ sǝn kup shilǝn ki Lya as kami nǝ hwoltugi. ");
INSERT INTO zbu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Si ɓo, Gǝs nisi ɗawai, si kǝn dǝm iye wai, ko ulukǝn hwossi tǝngaki shilǝn ki Lya u, Alǝbi alǝbi as pal nǝ kali. ");
INSERT INTO zbu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Unndi ginǝ nda gelu ili u, iki ciɓǝlti ki mbalǝn u nǝ kum shilǝn ki Lya u, ");
INSERT INTO zbu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Dǝp lǝɓa a hwosi u, nǝ lyap usǝn u, Nǝ laki lǝɓa u, Nǝnte'ti gesi asǝnkǝl shilǝn nisi, Ashilǝn nisi kǝn dǝmti kizeki masiwai. ");
INSERT INTO zbu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Undi u nǝ nda age luki zeki u, iki cimbǝlti ki mbalǝn u nǝkum shilǝnisi, Sǝn kamti, As pǝl kyautǝn nǝ nali, As mbi mbǝlti tǝnki gyen kutl kutl lǝbi maki, Gyen kutl kutl lǝbi mǝkka, Gyenɓo kutl kutl lǝbi kutl.” ");
INSERT INTO zbu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu ulsisu, “Nǝn mbǝtl pitila teɗi a idlati nǝ bal gala, ko nǝnzǝdli agǝs lumutti, kin zǝti atǝn lu dǝmtuwa swaya? ");
INSERT INTO zbu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kum ulnǝ ki hwundǝli u, nǝn pekǝlti. Ulnǝ ki kuppi u, nǝn ɗutiti. ");
INSERT INTO zbu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mul kǝm ki kumti, ti' kumi.” ");
INSERT INTO zbu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesu ulsisu, “Kumini, ko'talaku' nǝ cimbǝlin ɗa u, nǝ nali si' cimbǝlliki, hal ma as mbǝli ɗa. ");
INSERT INTO zbu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tǝngaki mulnǝ ulǝn ni'ɗa u, sim mbǝli' tiɗa, mulnǝ ulǝn ni' ɗawai u, na' ulnǝ nitu sin kamiti taka.” ");
INSERT INTO zbu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu ulsisu, “Gu' ki libi ki Lya kǝnǝ mul dlati u'kǝni a atli. ");
INSERT INTO zbu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mutti nǝ hillya i undi te, i nali, timan kan u nǝ pǝl dli uwai. ");
INSERT INTO zbu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Atli nǝ gawasi ti bǝtl lǝɓa, ki nǝm iki ulnǝ ɗǝ te'ti, sai ga, nǝ balgye laɓa tǝnki. ");
INSERT INTO zbu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","In gwe yi a nyau, iki alǝbi alǝbi atlo'dli nǝ kwaltǝn, gis acilu ngu.” ");
INSERT INTO zbu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","I' usu ɗaɗanu, “Nǝ yakǝn tǝn cimbǝlǝn gu' ki Lya? Ko nǝ yakǝn tǝn cimbǝlǝnti? ");
INSERT INTO zbu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kǝnǝ gwe mastad kǝnɗa, gunǝ, iki yakǝn gwe lǝɓa gunǝ ɗǝ wotlti adǝp lǝɓa u, ");
INSERT INTO zbu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ngo nǝ nǝgu in wotl tu, an ngǝtl kap na dwa nǝ nalti, ap pǝlbas mil toh, yatl ma as man nda a gwasǝn wasi.” ");
INSERT INTO zbu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nǝ cimbǝlti diɓǝli Yesu dlǝm misi shilǝn ki Lya, ndace nǝ mantiwasǝn. ");
INSERT INTO zbu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ti ɗa pissi ulǝnwai, sai nǝ cimbǝlti. Iki ti pi' mil kushtiwasi ko yanngi a malgǝni bǝ nǝ cimbǝltiwai. ");
INSERT INTO zbu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Age'cinisi, nǝ cin ɓalnja ti nda u, i Yesu ul mil kushti wassu, “Mi' ɗakǝcin tyatǝn bi dlǝlka ka.” ");
INSERT INTO zbu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nǝsza dopga ki mbalǝn akalu, is zǝga neti kau u nǝ tiɗa u age kundǝlǝn ki mali, na kundǝlǝn ki mali si amalgǝn wasi. ");
INSERT INTO zbu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","I bal lya ki mali mul yetǝl dlitoɗi, i bǝski mali go' tliti lya ɗǝ lyap jakǝ' kuɗǝlǝ nisi. ");
INSERT INTO zbu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu ɓo ati tu kal age kundǝlǝn ki mali atǝn lumutti, ati nde enbuɗi. Iki mil kushtiwasi is dlilti ɗǝ enɓuɗi, is ultisu, “Mul lashti, mun mǝshti kin ɗa entiwaya?” ");
INSERT INTO zbu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","I' hilya ɗǝ enɓuɗi, i' mati etǝlli, i ultisu “dǝm shot!” Iki i yetǝlli muɗi, i kumlu dǝm shot. ");
INSERT INTO zbu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","I' ulsisu, “Tǝn gaki yakǝn lakiɗa ikumǝn ɓanti nǝgu? Hal nǝgun lati mbatl kǝn nuna?” ");
INSERT INTO zbu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Iskum ɓanti iye, is ulyelsǝnisu, “Wo kǝngu? Yetǝl nǝ mali ki dlika si bǝtl shilǝn wasi!” ");
INSERT INTO zbu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","A Yesu ne mil kushtiwasi is ɓǝci bidlilka age atl ki Galasinawa. ");
INSERT INTO zbu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nǝ pe'tuwasi ɗige kundǝlǝn ki mali, iki mul du mi'gatlon kǝngu te' gelu gum mbalǝn i mbǝ ma Yesu. ");
INSERT INTO zbu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ti ɓo lugum mbalǝn kǝn ki lǝ dǝm tuwasi. Mul ma'kǝndǝtti ɗawai, ko nǝ ulkǝndǝ mbalǝn kidom. ");
INSERT INTO zbu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tǝn a tle kǝndǝti toh nǝ asǝn nǝ ulkǝndǝ mbalǝn ki dom, ati ɓaɓatlti, a cacal dom ki tǝn asǝni. Mul ma'pǝliti ulǝn ɗawai. ");
INSERT INTO zbu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Gasi nǝ dloncin a gelu gum mbalǝn ti dǝmti, nǝ tǝn zǝga, ati latiyali, ati gǝlǝshti dli wasi nǝ zǝnga. ");
INSERT INTO zbu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nǝ en Yesu te' lolu u, i' em kitǝl tya mati i' gus akinawasi. ");
INSERT INTO zbu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","I' layali i' usu, “Yesu yakǝn ki Lya mul nalti, ya lakǝnmiki? A maki nǝ Lya yi, bǝ hwoti besǝn lǝɓa wai.” ");
INSERT INTO zbu_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Tǝ ndan akinawasi nǝgu u tǝn gaki Yesu ultisu, “Za mulu, Ki du mi'gatli!” ");
INSERT INTO zbu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","I Yesu gyemti, “Ya kǝn ki shinwagi?” I' ultisu, “Shin i kǝnki, hututu, iki mi dimbǝli.” ");
INSERT INTO zbu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Iki i' go' gyep Yesu bǝ'katsi ɗǝ kiwai ");
INSERT INTO zbu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Amalǝbisi lu byatl dǝs kiban ɗa suttǝn mis calgadli. ");
INSERT INTO zbu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Mi'gatli gyemti is usu, “In kandǝgu katmi swa ge dǝs kiban yi, tǝn te gesi.” ");
INSERT INTO zbu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","I Yesu ndǝgisi. Iki yi du mi'gatli peki, is te ge dǝs kiban nisi. Dǝbǝtl ki dǝs kiban nisi sǝn pǝtl zangu lop, is hilya nǝ kitǝl, suttǝn mis calgadli is ndage mali ki dlilka is gǝli. ");
INSERT INTO zbu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Aki kǝn mil byatl dǝs kiban ni tlǝ nǝ kitǝl, is su dlǝm shilǝnni age bas gatli nǝ mil gatli. I mbalǝn ɓǝ si' en ulnǝ nda u. ");
INSERT INTO zbu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nǝs ɓǝ ma Yesu u is en mul nǝs pekǝli mi'gatli ngu ki dǝmi, nǝ luluti ki laki adli, ti ge dliwasi ɗaɗanu, is kum ɓanti. ");
INSERT INTO zbu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ginǝs pǝl ulisi a tǝn dwaɗǝn wasǝn u, is go' palli' mbalǝn shilǝn ki ulnǝ nda u nǝ mul mi'gatli nǝ dǝs kiban yi u ");
INSERT INTO zbu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","I mbalǝn nisi pi Yesu ti' zaki atlwasǝn. ");
INSERT INTO zbu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ti te'ge kundǝlǝn ki mali kǝn ngu, mulnǝ da du mi'gatli ɗa u bǝltibi ti' dǝm mati. ");
INSERT INTO zbu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu a ndǝgi tuwai, i Yesu ultisu, “Lǝ libi ma yalsǝnǝ wagi, a pisi bas ulnǝ Lya pǝliku, nǝ ci'gontuwagu nǝ' eni u.” ");
INSERT INTO zbu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","I' zǝga libi, i' tege dlǝm shilǝni a Dikapolis ki bas lǝɓa u nǝ Yesu pǝlitu. I kum mbalǝn i kum ulki gagashinti. ");
INSERT INTO zbu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nǝ Yesu ɗakǝci tyatǝn bǝgasi gwa u ge kundǝlǝn ki mali ɗaɗanu u, I bal dopga ki mbalǝn gandǝlti. Ati abi dlilka. ");
INSERT INTO zbu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Iki mulǝn ngu age bas mul kina ki lu dopga ki Yahudawa, mul shin Yayilus. Nǝ en Yesu u in nda akina wasi, ");
INSERT INTO zbu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","I' bǝlti bi balbali, i' ultisu, “Yakuyini yakǝnkǝli ti abiki mǝshti. Ami bǝtlki bi ngaɗi ki zittoh tǝngaki tin ndoɗa.” ");
INSERT INTO zbu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iki is zǝga neti. Bal dopga ki mbalǝn ɗǝ bǝlti kali, asi gyepti. ");
INSERT INTO zbu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Iki kǝli won ngu ta pǝl hwon kutl nǝ lobpi a hwula ɗǝ binetti, ");
INSERT INTO zbu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kǝli u ta tle bal bǝna a toh ki mil bǝlt igǝn diɓǝli, ta gǝl kum ulnǝ ni' ɗa u, i ngo nǝnǝgu tambi ndotuwai, kina kina gonti ɗa. ");
INSERT INTO zbu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nǝ kumi ɗǝ dlǝm Yesu u, i' molti te' kalki Yesu age dopga nisi, i' tǝn bi lulugǝl ki Yesu. ");
INSERT INTO zbu_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tǝn ti usu a mbatl tluwasi, “Lulugǝl ma atǝni u, an ndoti.” ");
INSERT INTO zbu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Alǝbi bina' ki hwulawasi dlǝli, i' kumi a dliwasi ta ndoki gontuwasi. ");
INSERT INTO zbu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Alǝbi alǝbi nǝ Yesu kumi ndǝlton a peɗi getu, iki i' go' yalu age dopga, i' usu, “Wokǝn tǝn lulugǝlni?” ");
INSERT INTO zbu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Iki i mil kushtiwasi ultisu, “Ki ye' dopga ki mbalǝn nǝgu, a usu, wokǝn tǝnka?” ");
INSERT INTO zbu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Iki i Yesu yalu kali tǝngaki ti' en mulnǝ pǝli' nǝgu u. ");
INSERT INTO zbu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kǝli yi nǝ man ulnǝ ndaniti u, iki i' ɓǝ nǝ ɓanti, ati nyepti ki dli i' nda a kina ki Yesu, i kǝliyi pi Yesu bali. ");
INSERT INTO zbu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","I Yesu ul kǝli usu, “Yakuyini, lati mbatluwagi a ndokǝlki. Mboci lau, ka ndo ɗǝ gontuwagi.” ");
INSERT INTO zbu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","A tige shilǝn, iki gyenkǝnngi te' libi ki Yayilus, is usu, “Yakuwagi ta mǝci, yalakiɗa ki'la' mul lashti ɗǝ bǝnaɗa?” ");
INSERT INTO zbu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu a pal kǝm tǝn ulnǝ si dlǝmti uwai, i' ul Yayilus su, “Bi kum ɓantuwai, la mbatl katl” ");
INSERT INTO zbu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ta za mulǝn a bǝlsi kaluwai iki Bitlus, nǝ Yakubu, nǝ Yahaya yalse ki Yakubu si bǝlti kali ");
INSERT INTO zbu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nǝs mbǝci libi ki Yayilus mul kina ki lu dopga ki Yahudawa u, is kumi wotilu, nǝ kulu, nǝ latiyali yenti ɗawai ba kumti ɗawai. ");
INSERT INTO zbu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nǝ te' gibi u, i' Yesu ulsisu, “Yalaki ɗa ki wotilu nǝ kulu ɗa nǝgu? Yakǝni kimǝci tiɗawai, nde yemmbukǝn tiɗa.” ");
INSERT INTO zbu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Iki is pǝli gyetlti ki mbǝlti. Kalki ki Yesu a pekǝl mbalǝn nǝsi kumwasǝn tuwa dlayi, iki i' kan bwasi ki yakǝnkǝliyi nǝ dyawasi nǝ mil kushtiwasi guni netu, is te' gelu u nǝ yakǝn kǝliyi ɗa u. ");
INSERT INTO zbu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","I' Yesu goppi toh, i' ultisu, “Talita kumi”, iki, “Yakǝnkǝli, ami utlkisu, hilya.” ");
INSERT INTO zbu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Alǝbi alǝbi yakǝnkǝliyi hilya i' go' lǝti. Tǝngaki timul hwon kutl nǝ lop kǝni. Gu lakisi ulki gagashinti iye ");
INSERT INTO zbu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Iki i' matisi bǝ mulǝn kum shilǝn uwai, i' ulsisu ɗaɗanu si' bǝl yakǝn kǝliyi ulki ɗami. ");
INSERT INTO zbu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","I Yesu za' lǝbisi ippal tiya ge' gatluwasi, I mil kushti wasi is bǝltikal. ");
INSERT INTO zbu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nǝ Cin shuti pǝ' u, i' gop kulcissi age'lu dopga ki Yahudawa, diɓǝl mbalǝn yi nǝ lǝbi u si ga'ti kǝmu is kum gagashinti, asi ussu, “A ukǝn mulu mbi ulu nǝgu u?” Is ngemti, “Undi mallaɓa ukǝn ninnǝgu? Undi gagashintu kǝn ti pǝlti nǝgu? ");
INSERT INTO zbu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Guki mul tlatti lǝɓa u waiwa? Yakǝn ki Malyamu nǝ yelse ki Yakubu, nǝ Yusupu, nǝ Yahuza nǝ Saminu? Yelsǝni was mudli simi ne'sǝ a kiwu waiwa?” Is nge'ti. ");
INSERT INTO zbu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","I Yesu ulsisu, “Mulnjeshinkǝn nǝnɗa mbin nalti ge'gatluwaswai nǝ ge' yelsǝniwasi nǝ a libi wasi.” ");
INSERT INTO zbu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Taman pǝtl ulki gagashit tiya kawai, iki is zi mi'gonti ginǝ bǝs diɓǝllwai u toh is ndoki. ");
INSERT INTO zbu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","I' kum gagashinti nǝ hotl la'ti mbadlawasǝn. I'go' duk tiya ge mil gatli ati kulcissi. ");
INSERT INTO zbu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Immbe mil kushti kutlh nǝ lopi bi is shinsi lob lob. Ibbǝlsi ndǝlti tǝn du mi'gatlǝ. ");
INSERT INTO zbu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ippisi i' usu, “Bǝ kamǝn ulǝnwai ɗǝ lǝ tuwasǝnwai kumɓǝlkǝn ki kamin katl bǝs kan ulki ɗamiwai bǝ kamǝn kulu wai bǝ kamǝn ulpwai. ");
INSERT INTO zbu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Shimǝn kaptǝlan, ngo nǝnǝgu bi mbǝlǝn lu'lǝgǝl tǝnkiwai. ");
INSERT INTO zbu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Libi u nǝ ka shitin lǝbi u a' dǝmni lǝbi hal a' za'kǝn gatliɗa. ");
INSERT INTO zbu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Lu u nǝ bǝsa njekiniwai u ko sa nge kupkini u, za'kǝn gatli abatǝn kushka ki asǝnwakǝn taka gaki tǝdǝm dǝtlkǝm ɗa ma'si.” ");
INSERT INTO zbu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nǝgu si peki asi dlǝmi' mbalǝn shilǝn ki Lya gaki sǝ' za' pǝtl bezǝn lǝɓa. ");
INSERT INTO zbu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Is pekǝl mi'gatli diɓǝli, is suwati mi'gonti diɓǝli mili is ndoki. ");
INSERT INTO zbu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nǝ guu Hilidus kumi nǝgu u, tǝn gaki Yesu apǝl shin i, gemma si usu, “Yahaya mul pǝli mbalǝn baptisma ti tlilya ge' mi' mǝshti, I lakiɗa ti nǝ ndǝlki kyautǝn ki gagashinti ɗǝ pǝ' ma'tiɗa.” ");
INSERT INTO zbu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Gen ɗǝ usu Iliya ni, gen ne si usu, “Nǝm kǝn ge mul njeshinkǝn ki Lya ki ɗigini.” ");
INSERT INTO zbu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nǝ Hilidus kumi nǝgu u, I' usu, “Yahaya u na patti ga taka u hilya ge' mil mushti!” ");
INSERT INTO zbu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ti Hilidus nǝ gawasi illaki sǝ' gop Yahaya, is ki ndǝti as la'ti ge'lu kǝnndǝ'mbalǝn. Tǝ pǝllǝn gu gaki Hilidiya kǝli ki yelse wasi Philip, gunǝ' kanti ippalti ɗǝ kǝliwasi. ");
INSERT INTO zbu_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Tǝn gaki Yahaya ul Hilidus su, “A mbuni ki dǝm nǝ kǝliki yelse wagwai” ");
INSERT INTO zbu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tǝn gaki nǝgu Hilidiya ngap Yahaya a mbatldli, ti lyamti tǝ' tloti, ngo' nǝnǝgu tamaniwai gaki Hilidus. ");
INSERT INTO zbu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hilidus ɗǝ' ɓanti Yahaya, gaki ti mani Yahaya mulzo' mbatl kǝni mul pǝtl lǝɓa kizokini, I lakiɗa bǝ tiɗa za'ti ulǝn ti nda nǝtiwai. Hilidus in tikum shilǝn ki Yahaya u ɗǝ hwottiti, ngo nǝnǝgu ti ɓalɗǝ kupti ɗǝ shilǝn u, ti kup hwol mbatl nǝ kup ti. ");
INSERT INTO zbu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Iki ipmbi shitu nǝ cin ki zǝ'ti mbǝ u, ip pǝli Gumsisi wasi nǝ bas mi'kina ki dlati ne' bas mbalǝn ki Galili daddaɓǝl. ");
INSERT INTO zbu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nǝ yakǝn ki hiludiya tete' dlom ɗǝ nyeptu, i mbuni Hilidus ne'sǝbǝlswasi. I Guu ul yakǝn kǝlisu, ngem ulnǝ ki lyamti u an bǝlki. ");
INSERT INTO zbu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","I Hilidus ndǝgiti nǝzal ulnǝ ka ngemi u an bǝlki, “Ko ti bwasti dlom ki guntikǝni.” ");
INSERT INTO zbu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ippeki, in ngem dyawasi, “Yakǝn ta ngemi?” I dyani usu, “Gaki Yahaya mul pǝli' mbalǝn baptisma.” ");
INSERT INTO zbu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","A lǝbi alǝbi is susu' nǝ dleuti, ma' guu i' ultisu, “Ami lyamti nǝgun nǝguni ki bǝlǝn ga ki Yahaya mul pǝtl baptisma, age' gal ki pǝti.” ");
INSERT INTO zbu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","I mbatl ki guu lewi, Ngo nǝnǝgu gaki ta ultisuyi nǝzal akina ɗǝ sǝmbǝlswasi, tǝkǝn lyapti ti' ultisu zakiwai. ");
INSERT INTO zbu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","A lǝbi i guu la' mul shinkǝn wasi, illaki sǝm mbǝl ga ki Yahaya. I mul shinkǝni le' kotl ga ki Yahaya teɗi a ge'lu zǝm mbalǝn. ");
INSERT INTO zbu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Im mbǝl gami age' galpǝti, ib bǝl yakǝn kǝliyi, i yakǝn kǝliyi bǝl dyawasi. ");
INSERT INTO zbu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nǝ mil kushti ki Yahaya kum shilǝni u, is mbǝ is kan dli i, is guti. ");
INSERT INTO zbu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","I mil shinkǝn ki Yesu is pal te' ma'ti, is dlimi' mus ulnǝs pǝli u, nǝ ulnǝs kulci u. ");
INSERT INTO zbu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","I Yesu ulsisu nganni tǝn na' shu'ni ge' lu u nǝbǝ mbalǝn ɗa wai u, gaki mbalǝn diɗǝli si lǝti asi palti, mbi' dlil ɗǝ ɗamtima mil shinkǝn ki Yesu ma sambiwai. ");
INSERT INTO zbu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Is zǝga ge' kundǝlǝn ki mali si nǝgwasǝn lu u nǝ bǝ mbalǝn ɗa wai u. ");
INSERT INTO zbu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Iki mbalǝn diɓǝl, is yen zǝ'ga wasǝn, si mansi, mus mbalǝn kige gadli nǝ lǝbi u is dululu is ngǝtl nǝ mbǝkǝsti. ");
INSERT INTO zbu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nǝ pe'ti ki Yesu ɗige' kundǝlǝn ki malu, i'yen diɓǝl mbalǝn i' kum ci' gon twasǝn, gaki si kǝnǝ mbǝla u nǝbǝ mil be'lsi ɗawai u. I' go' kulcissi lǝɓa diɓǝli. ");
INSERT INTO zbu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nǝ cin ɓal nja tǝnda u i mil kushti wasi mbǝ ma'ti, is ultisu, “Lǝbisi ngu mbalǝn ɗawai, i ngu cin ɓal nja ti ndayi. ");
INSERT INTO zbu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Za' mbalǝn nisi sǝ' zǝga tiya ge' gatlu nǝ nja aki u, sǝ' uli gawasǝn ulki ɗamiɗa.” ");
INSERT INTO zbu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","I' ulsisu, “Kiniɓo bǝlǝnsi ulki ɗamiɗa” Is ul Yesu usu, “Ulki ɗamiwasǝn nǝ pǝtl bwasti dlom ki upki lii hwon nǝm kikyautǝn ki yakǝn mbalǝn, tǝn ullisi ulki ɗami ɗangwa?” ");
INSERT INTO zbu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","I Yesu ngemsi, “Ulki ɗami nǝmi nikini? Su' yanini.” Nǝs yani toɗu, is ultisu, “Lǝpa nantam kǝni, nǝ kes lob.” ");
INSERT INTO zbu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","I Yesu ul mil kushti wasi usu sǝ' bwas mbalǝn tiya as dǝm atli tiya tǝn di'me. ");
INSERT INTO zbu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","I mbalǝn dǝm atli swai nami kutl kutl lǝbǝ kutl, nami kutl kutl lǝbǝ nantam. ");
INSERT INTO zbu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","I Yesu kan lǝpa nantami nǝ kes gudǝl lopisi, it taki lya, i' gode Lya, i' caccal lǝpa i, ib bǝl mil kushti wasi sǝ' buwasi mbalǝn, is buwasisi kes lopi ɗaɗanu. ");
INSERT INTO zbu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Muswasǝn is ɗami i kǝmsi. ");
INSERT INTO zbu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","I mil kushti wasi yem dǝs kutl nǝ lop ki lǝpa gunǝ sa u nǝ kesi. ");
INSERT INTO zbu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Diɓǝl ki mwani yi nǝ ɗami u sa tǝla zangu nantam. ");
INSERT INTO zbu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nǝguni i Yesu la' mil kushti wasi sǝ' tege' kudǝlǝn ki mali sǝ' ngǝtl ti ɗǝ ɗakǝshti tiya Basaida, tiya ge'lu yiwon ki bal mal, i ul mbalǝn su sǝ' zǝga. ");
INSERT INTO zbu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nǝ' zasi u i totǝn zǝnga ɗǝ gyem Lya. ");
INSERT INTO zbu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nǝ gas pǝ'u, kudǝlǝni tiya dlom mali, Yesu tǝn bǝgasi nǝm nǝ gwasi. ");
INSERT INTO zbu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nǝ' en dǝl kudǝlǝn ɗǝ hwottisi u, tǝn gaki ndǝl ki yetǝl, adlom gasi i'go lǝ te'tǝnsi, a ti lǝ'tǝn mali. Ippǝli kǝnǝ tǝ' ɗakǝsh si, ");
INSERT INTO zbu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nǝs yen ti ɗǝ lǝ' tǝn malu, is yeni kǝnǝ nul kǝni, is la' yali. ");
INSERT INTO zbu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tǝn gaki kapuwasǝn i ɓa'gobsi nǝs yentu. I Yesu ɓulisi bi alǝbi, i' ulsisu, “Bǝ ɓanniwai amini.” ");
INSERT INTO zbu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Iki it tege' kudǝlǝn ne'si, i yetǝli muɗi. I gagashi' gob mil kushti wasi, ");
INSERT INTO zbu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","gaki saman ulǝn tǝn lǝpa gunǝ bǝl mbalǝn zangu nantam is ɗamti ɗa uwai, gaki mbatldlowasǝn a kangǝli. ");
INSERT INTO zbu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nǝs ɗakǝci, is mbǝci ge' atl ki Jenisalata, is kǝndǝ kudǝlǝni tǝn bigasi. ");
INSERT INTO zbu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nǝs pe' ɗige' kundǝlǝni u i mbalǝni mansi. ");
INSERT INTO zbu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Is ngwal atlisi nǝ kitǝl, is go' ka' mi'go' tottǝn lumut si tala'si tiya ge'lu u nǝs kumi ti ɗa u. ");
INSERT INTO zbu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mus lu u nǝ Yesu lǝɗa u, bal gatli ko yakǝn gatli, as mbǝllic mi' gonti abi lu dobga, as ngemti sǝttin bi lulǝ gǝlwasma. Ginǝ tǝntu is ndoki. ");
INSERT INTO zbu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nǝ palisiyawa nǝ gyen mi' bǝtl lashti zhil ki Musa ginǝ mbǝ te' Ulshelima is domga ma' Yesu. ");
INSERT INTO zbu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Is yeni na mil kushti wasi si ɗamti siɗa o'kǝl towai tǝngaki bǝtl lǝɓa ki mi' kina. ");
INSERT INTO zbu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Palisiyawa ne' Yehudawa sǝn ɗa ɗamti pawai senǝ sa o'kǝl toh pa, gaki si bǝtl lǝɓa ki mi' kina. ");
INSERT INTO zbu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","In sa pal te'ge'lu dobga ki ulti nǝ ulti taka u, sǝnɗa ɗamtipawai senǝ sa utisi mal takapa. Undǝ laɓa enɗa diɓǝli nǝsmbima' mi'kina wasǝn asi pǝlti, kǝnǝ ki o'kǝl gali ne' ki twom mali ne' kal ki dom. ");
INSERT INTO zbu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","I palisiyawa ne' mi' kulci' mbalǝn zhil ki Musa is ngemti, “Ya lakiɗa mil kushti wagi siɗa bǝtl ulnǝs mbima mi'kina wasǝn u wai, si ɗamti bǝsiɗa o'kǝtl towai?” ");
INSERT INTO zbu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","I' ulsisu, “Bali Ishaya dlǝmi tǝnkini, mi' bǝna ki dwaɗǝn, kan u nǝ ɗa ki laci u: “ ‘Mbalǝnyi agabi ki naltǝni, mbadlwakǝn lolu nǝ ami. ");
INSERT INTO zbu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bǝtl Lya wasǝn u bali wai, ge'shu ki zhil ki Lya, zhil ki mbalǝn kǝn si kulcissi.’ ");
INSERT INTO zbu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ka lakǝn zhil ki Lya taka i, ka ngapǝn zhil ki mi' kina i.” ");
INSERT INTO zbu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","I' ulsisu, “Kimanǝn shitu ki la'ti zhil ki Lya taka huti aki ngapti zhil ki mi' kina. ");
INSERT INTO zbu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Gaki Musa usu, ‘Nal bwagi nǝ dyawagi,’ ‘Mulnǝ, abyal bwasu ko dyawasu, a tloti.’ ");
INSERT INTO zbu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ngo nǝnǝgu kini ki usu, in mulnǝ azi ulǝn tǝngaki ti' ɗǝl bwasi nǝ dyawasi adǝm Kolban i', (iki, abǝl Lya i) ");
INSERT INTO zbu_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","nǝgu katl, kǝkǝn za'titi tǝ'pǝli bwasi ko dyawasi kyautǝn ki ulǝnwai. ");
INSERT INTO zbu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nǝgu lakiɗa ki ɗa katshilǝn ki Lya baliwai gaki bǝtl zhil ki mi' kina. Ki njikǝ' pǝtl undigi.” ");
INSERT INTO zbu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ɗaɗanu i Yesu taki diɓǝl mbalǝn bi, i' ulsisu, “Kumǝnnǝni muswakǝn, a'manangu. ");
INSERT INTO zbu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ulnǝ ɗǝ su' ge' yakǝn mbalǝn tu'dla u i ɗǝ bezǝtiwai, ulnǝ ɗǝ pe'tito' ge'tu ɗǝ bezǝti.” ");
INSERT INTO zbu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mul kǝm ki kumti, ti' kumi, ");
INSERT INTO zbu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kalki za'ti hwu'mbalǝn i, nǝtte libi u, i mil kushti wasi is ngemti yakǝn cimbǝlti u ɗǝ dlǝmti. ");
INSERT INTO zbu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","I' ulsisu, “Kinima kimaniniwaiya?” “Ulnǝ ɗǝ suge' mbalǝn tu'dla u, kǝn bezǝtiwai, ");
INSERT INTO zbu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nǝbǝ ambadlwas kǝn suwai u, atu'ɗa'ka su, tu'nǝgu tǝpekki.” Nǝnǝgu Yesu pal mus ulki ɗami ki zeki. ");
INSERT INTO zbu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","I' usu, “Ulnǝ ɗǝpe'ti to'ge' tu'ki yakǝn mbalǝn u iɗǝ bezǝt'ti. ");
INSERT INTO zbu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","A tugi, age' mbadl ki yakǝn mbalǝn, kǝn bezǝn lǝɓa ɗǝpe'ti, kǝnǝ kwonti, nǝ mǝgǝlti, nǝ tlom mbalǝn, ");
INSERT INTO zbu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nǝ pǝti, nǝ lyap lǝɓa, nǝ ngashti, nǝ ship totugi, nǝ nge Lya, nǝ ndau bishitu, nǝ bezǝn dǝmti, nǝ nalkiga, nǝ kon nǝmbalǝn, nǝ ndokǝnti. ");
INSERT INTO zbu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mus bezǝn lǝɓagi atu'kǝn sipe'titoɗi, si ɗǝ bezǝn mbalǝn.” ");
INSERT INTO zbu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","I Yesu za'lǝbi illǝ Taya nǝ Sidon. It tege' libiwon, ta lyami tǝmulǝn maniwai ngo' nǝnǝgu a hwunwai. ");
INSERT INTO zbu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kǝliwon, gunǝ du mi'gatli gob yakuwasi, nǝkumi Yesu ɗa ki u, illǝ in ndakina ɗakka. ");
INSERT INTO zbu_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Kǝliyisi yakǝn Helinawa ni, atlki zǝtti iki Solopinikiya ni. In ngem Yesu tǝp pekkǝli yakuwasi du mi'gatl taka. ");
INSERT INTO zbu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","I Yesu ultisu, “Hwe tǝkǝm mil pa, gaki a'mbuni akan ulki ɗami ki milwai tǝbǝl kaɗiwai.” ");
INSERT INTO zbu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","I kǝliyi ndǝgiti i'ultisu, “Mul nalti, ey nǝguɗa, ngo'nǝnǝgu kaɗi nǝnɗǝ ɗab bi ki mil.” ");
INSERT INTO zbu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","I Yesu ultisu, “Gaki shilǝnwa'gu, paltya, du mi'gatli aza' yakuwagi yakǝnkǝli.” ");
INSERT INTO zbu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nǝ' paltya libi u ille'mbi yakuwasi kǝmuɗi tǝn lumutti, du mi'gatli apeki. ");
INSERT INTO zbu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","I Yesu za' lukǝ Taya, i' bǝli Sidon tǝn shitu i' bǝli Dikapolis illǝ dlilka ki Galili. ");
INSERT INTO zbu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Is mbǝlli' mulnǝ bǝɗa kub kǝmwai u mul ɗǝɗɗǝtibi, is ngemti tǝszitto. ");
INSERT INTO zbu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","I Yesu Kanti ispal malgǝni' ki hwu' mbalǝn, i Yesu shim mil toh age' kǝm ki mulisi, ibbeza makkǝn, ittǝn lǝgawasi. ");
INSERT INTO zbu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Illa'ga lya immbǝ mbadli, i'ultisu, “Ippata!” (Iki, “ɓuli!”) ");
INSERT INTO zbu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","I kǝmwas ɓuli, i lǝgawas laki, i'gob shilǝn. ");
INSERT INTO zbu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","I Yesu dlimisi bǝs dlimi mulǝnwai. Sine se mbǝtl dlǝmtitǝnki siɗa. ");
INSERT INTO zbu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Is kumgagashinti, is usu, “Tapǝl mus lǝɓa mbuni! Mulnǝ bǝ ɗa kubkǝmwai u ma ta kumi i, mul ɗǝɗɗǝti bima taman shilǝn I.” ");
INSERT INTO zbu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Age cinisi i hwu' mbalǝn domga ɗaɗanu. Ulki ɗami nisi ɗawai, i Yesu imbe milkushti wasbi, i' ulsisu, ");
INSERT INTO zbu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ami kub go'kǝ' hwu mbalǝnyi, gaki asǝti mutti maki ngu asi ne'kǝni, ulki ɗami nisiɗawai. ");
INSERT INTO zbu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","In a zasi sa zǝga libi nǝ kuzǝn u, sǝkǝn ma'mbǝkǝshti libiwai, i ngu nami pe'ni lolu.” ");
INSERT INTO zbu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","I mil kushti wasi ndǝgiti is ultisu, “A ukǝn tǝ mbalǝn mbi ulki ɗami u nǝtǝ kǝm mbalǝn age'dǝlgǝn u?” ");
INSERT INTO zbu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","I Yesu ngemsi, “Lǝpa nǝmi nikini?” Is usu, “Ninngi.” ");
INSERT INTO zbu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","I' ul diɓǝl mbalǝnsu sǝ'dǝm atli. Nǝ'kan lǝpa ninngiyi, i' gode Lya ɗa, iccacali, i'go' bǝtl milkushti wasi sǝ' bwasi mbalǝn, is pǝli nugu. ");
INSERT INTO zbu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kwesen nisiɗa ten ngulen. Nǝ' gode Lya u, ippi milkushti wasi sǝ'bwasi mbalǝn. ");
INSERT INTO zbu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","I mbalǝn ɗami i kǝmsi, i milkushti wasi yemi is njikǝn dǝs ninngi nǝgunǝ sa u. ");
INSERT INTO zbu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mbalǝnisi sa pǝl zangu upsi. Kal ki pallisibi, ");
INSERT INTO zbu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ittege' kundǝlǝn ne' mik kushti wasi, illǝge' luki Dalmanuta. ");
INSERT INTO zbu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","I palisiyawa gop ngep Yesu. Tǝn sǝ' cimbǝlti ɗa, is ngemti, tǝn gaki tǝn mbokisi toh tǝn lwaɗon sul lya. ");
INSERT INTO zbu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","I Yesu mbǝ mbadli lolu, i'usu, “Ya lakiɗa kini mbalǝn kinǝgun ki ngep lwadɗa? Bali amipi' kini, kǝnbǝtlkin lwaɗon sul lyawai.” ");
INSERT INTO zbu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Iki is izza'si, ittege'kundǝlǝn ki mal, idɗakaci tiyatǝn bigasika. ");
INSERT INTO zbu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Imilkushti was musni sa kan bilediwai, lǝpa nǝm kǝn nisi katl ge'kundǝlǝni. ");
INSERT INTO zbu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","I Yesu dǝllisi kǝm, i'ulsisu, “Yanǝn lu kizoki, apǝn ɗemɗem nǝ yiski palisiyawa nǝki Hilidus.” ");
INSERT INTO zbu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Is shilǝn ɗaɗɗasi, “Is usu tǝn gaki biledi niminɗawai.” ");
INSERT INTO zbu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu man ulnǝ si dlimti u, i Yesu ulsisu, “Ya lakiɗa iki usu biledi nikin ɗawai? Hal nǝguni ka manini uwaiya? Hal nǝgun kin ɗa yentiniwaiya? Mba dlwakǝn a ndǝdǝli kikǝn mantiniwaiya? ");
INSERT INTO zbu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Dwaɗǝn nikinɗa bǝki enluwaiya nǝ kǝm nikinɗa bǝki kumtiwaiya? Kǝnɗa dabǝtl kiniwaiya? ");
INSERT INTO zbu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Na chali mbalǝn zangu nantam lǝpa nantamu, mbutu nǝmi ki yemini ki bigeyi gunǝ sa u?” Is ultisu, “Kutl nǝ lop” ");
INSERT INTO zbu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","I Yesu ngemsi lǝpa ningi u na chali zangu upsi u pa? Mbutu nǝmi ki yemini? Is ultisu, “Ningi.” ");
INSERT INTO zbu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","I ulsisu, “Hal nǝgun ma, ka manini u waiya?” ");
INSERT INTO zbu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Is mbǝkǝci a Batsaida, i mbalǝn en mbǝlli' dwawon, is bǝlti bi tǝttǝnti. ");
INSERT INTO zbu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","In ngapi dwanisi toh, it mbǝti malgǝn gatli. Ibbezze'makǝn a dwaɗǝn, izzǝ'toh, i Yesu ultisu, “Kǝn ɗǝ ye' ulunya?” ");
INSERT INTO zbu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","I dwani ya lulya, i'usu, “Ami yen mbalǝn; kǝnǝ pǝti asi duti” ");
INSERT INTO zbu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","I Yesu zǝ'toh tǝn dwaɗǝni ɗaɗanu. I dwanisi ɓul dwaɗǝn wasi, in ndoki, i'yen lu kizoki. ");
INSERT INTO zbu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","I Yesu ultisu, “Paltya libi, bǝ tege' yakǝn gatluwai.” ");
INSERT INTO zbu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","I Yesu ne' milkushtiwasi, is tege' mil gatlki Kaisaliya Pilibi. Tǝn shitu in ngemsi, “Ya mbalǝn ɗǝ mbetǝni?” ");
INSERT INTO zbu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Is ultisu, “Yahaya mulpǝtl baptisma; gyenne, Iliya; gyenne ɗaɗanu, si usu nǝm ge' mik nje'shinkǝn ki Lya kǝni.” ");
INSERT INTO zbu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","In ngemsi, “Kinipa yaki mbetǝni?” Bitlus ndǝgiti i'ultisu, “Kikǝ Almasihu.” ");
INSERT INTO zbu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","I Yesu dǝlisi kǝm bǝs dlǝmi mulǝn ulǝn tǝntwai. ");
INSERT INTO zbu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","I'gop kulcissi, yakǝn mbalǝn nǝn tlebbǝna diɓǝli a ngeti, ma mikkina, ne' bas lǝɓasi, ne'mik bǝtl lashti zhil ki Musa, sǝn tloti, kalki mutti maki tǝn tlǝti lya ɗaɗanu. ");
INSERT INTO zbu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","I Yesu dlǝmisi shilǝni kan unǝ sǝ'mani ɗa u. I Bitlus dǝlti malgǝni, i'gop matiti. ");
INSERT INTO zbu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ngonǝnǝgu nǝ Yesu yalu kalu i'ya milkushtiwasi, im mati Bitlus i'ultisu, “Pǝlolu nǝ ami sheɗan! Ge mbatlwagi laɓa ki Lya ɗawai sai ki mbalǝn.” ");
INSERT INTO zbu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Imbe hwu mbalǝni bi ne'milkushtiwasi, i' ulsisu, “Mul lyab dǝp mul kushti ini, tǝnge' gawasi, a'kan gǝdlǝnnga ki bǝnawasi, abbǝlǝn kali. ");
INSERT INTO zbu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mul lyab gawasi, tǝnholti, mulnǝ a hol gawas gayi u, gaki shilǝn ki Lya u, ziti tiɗa. ");
INSERT INTO zbu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Yakǝn ti yankǝn mbalǝn mbi intambi dǝb lǝɓa mus, ge shu ki gawasu? ");
INSERT INTO zbu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Yakǝn ɗaɗanu ti yakǝn mbalǝn bǝli tǝn gaki ti'ul mbatlwas ɗa? ");
INSERT INTO zbu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","In mulnǝ a kubsha i u nǝ shilǝn i u, age' hwon ki nge' ngapti ga nǝ pǝtl bezǝn lǝɓa, yakǝn mbalǝn ma tǝnkub shaki matti, inta mbǝ ge' natl ki mulzǝtti u ne' milshinkǝn ki Lya kizoki.” ");
INSERT INTO zbu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","I' ulsisu, “Bali bali ami dlǝmikini, genɗa ki dlǝli aki sǝkkǝn yen mǝshtwai, sai nǝ sayen gukki Lya a mbǝ nǝ ndǝlti.” ");
INSERT INTO zbu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kalki mutti mǝkka i Yesu kan Bitlus, nǝ Yakubu, nǝ Yahaya, sinǝ gwasǝn it tolsi tǝn pyasti zǝnga. I dliwas shoti. ");
INSERT INTO zbu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","I lulǝgǝlwas hwali sol aɗi kaddwaɗǝn, kan u nǝbǝ mulǝn kǝn ma' pǝlti nǝgu tǝn dǝp lǝɓawai u. ");
INSERT INTO zbu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","I Iliya nǝ Musa is pekkisi, a shilǝn ne' Yesu. ");
INSERT INTO zbu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","I Bitlus ul Yesu su, “Mul lashti, a mbuni nǝmini ki u. Hwe tǝn pǝlǝn kǝs maki, gudǝl nǝm gwagi, nǝm ki Musa, nǝm ne ki Iliya.” ");
INSERT INTO zbu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Ta hwol ulnǝ tǝtl dlǝmi u yi, gaki sa kum ɓanti.) ");
INSERT INTO zbu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","I lyawon tlǝttoɗi i idlasi, i kum yalon ge'lyanisi, ti usu, “Guki yakuyini ki lyami. Kumǝnti.” ");
INSERT INTO zbu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Bǝnǝ mantiwasǝnwai sige nǝgu is yalu malgǝn ɗasi sayen mulǝnwai, Yesu ka'tl ne'si. ");
INSERT INTO zbu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Sige' pe'ti suttǝn Zǝga, I Yesu pisi bǝs dlǝmi mulǝn ulnǝs yeni u wai, sai nǝ yakǝn mbalǝn a hilya ɗige' mi'mǝshti. ");
INSERT INTO zbu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Is za'shilǝni ge' dlomwasǝn, asi shilǝn ne' yelsǝni yakǝnki “Hillya ge' mi' mǝshti.” ");
INSERT INTO zbu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Is ngemti is ultisu, “Ya lakiɗa mi' bǝtl lashti zhil ki Musa ɗǝ ussu Iliya ki mulpatl su' pa?” ");
INSERT INTO zbu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","I' ulsisu, “Iliya ki mulpatl pa, appal mus lǝɓa. Imikǝnɗa ki laci tǝn yakǝn mbalǝn, tǝn tle'bǝna diɓǝli, as ngeti? ");
INSERT INTO zbu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ami pikkini, Iliya a lǝge tambǝyi, sa pǝlit ulnǝ tǝmisiɗa u i, kan unǝ ɗa ki laci tǝntu.” ");
INSERT INTO zbu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nǝs palte' ma' na mil kushti wasu, is yen hwu mbalǝn aga ndǝlsi i, mi' bǝtl lashti zhil ki Musa ɗǝ shottibi ne'si. ");
INSERT INTO zbu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nǝ ye' Yesu, mus hwu mbalǝnyi is kum gagashinti, is lǝtemma'ti nǝkitǝl, sǝ' shinnitti. ");
INSERT INTO zbu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","In ngemsi, “Shoti bi kiyakǝn kiniɗa ne'si?” ");
INSERT INTO zbu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","I gudǝl nǝm ge'mbalǝni ndǝgiti, i'ultisu, “Mul lashti, i ngu, a mbǝlli' yakuyini, gunǝ mi'gatli ki nge' shilǝn nidɗa. ");
INSERT INTO zbu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nǝta totǝntu, sai nǝ tala'ti atli, a biwas ɗǝpǝ't pukǝtkǝt, a ti ashti shinwasi, ati pǝ'sanganga. Adlimi milkushti wagiyi sǝppe'kǝlti, sa maniwai.” ");
INSERT INTO zbu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","I Yesu ndǝgisi i'ulsisu, “Kini mbalǝn ki nǝgun u nǝbǝ kiɗa la'ti mbadlwai u! Anǝmi taman dǝp ne'kini? Anǝmi taman ngashtibi nǝkini? Mbǝlli nǝn yakǝni.” ");
INSERT INTO zbu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Is mbǝlli' yakǝni. Nǝ mi'gatli yen Yesu u, alǝbi alǝbi i mi'gatli bat yakǝni, i dliwas gon nyepti, in nda atli i'go' bǝdǝlti, a biwas ɗǝ pǝt pukǝtkǝt. ");
INSERT INTO zbu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu ngem mul zǝ'yakǝni, “Kǝnǝ anǝmi uli mbitu?” I bwasisi usu, “Adɗi na' yakǝn. ");
INSERT INTO zbu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ta tle la'titi ge' utu ko mali, gaki tǝ'tlotiɗa. Ngo nǝnǝgu kǝn ma'pǝl ulǝn u, kum gontinǝn a ɗǝlmi.” ");
INSERT INTO zbu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“ ‘In kǝn manti u?’ ” I Yesu ultisu, “Mus lǝɓa mul pǝ'kǝni ma'mul la'ti mbadlǝ.” ");
INSERT INTO zbu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Alǝbi alǝbi i bwas ki yakǝni usu “A la' mbadlǝ. Kati lǝshi la'ti mbadlǝ taka!” ");
INSERT INTO zbu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nǝ Yesu yen hwu mbalǝn ɗǝ kitǝl teɗu, im mati du mi'gatli i'ultisu, “Ki, mi'gatlu mul nge' kup kǝm nǝ shilǝn u, a piki bwaski kiti, bǝ tege'ti nǝwai.” ");
INSERT INTO zbu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kalki la'ti yalki mi'gatli, illi'ti nǝ ndǝlti, dlǝwas ɗǝ nepti, ibbwasti nǝti. I yakǝni palkǝni hwum mbalǝn, i ge' mbalǝn kilǝbi diɓǝli nami usu, “Tamǝcci” ");
INSERT INTO zbu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","I Yesu gobto wasi it tlǝlti lya, i' hilya gal. ");
INSERT INTO zbu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","I Yesu telibi u i mil kushtiwas ungemti a malgǝni is ultisu, “Ya lakiɗa ma man pekkǝltiwai?” ");
INSERT INTO zbu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","I Yesu ulsisu, “Undiyi nǝnɗa pe'twai sainǝ ngeb lya.” ");
INSERT INTO zbu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Is hilya ɗilǝbi, is ɓeu tiya Galili, Yesu alyami tǝ mullǝn maniwai, ");
INSERT INTO zbu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","gaki ti kulci' mil kushtiwasi, ti ulsisu, “Sǝnbǝl yakǝn mbalǝn ma'mbalǝn, sin tlotti, in sa tlotu kuma, kalki mutti maki tǝn tlǝti lya.” ");
INSERT INTO zbu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Sine saman shilǝnǝwai, si ɓanti'ngepti. ");
INSERT INTO zbu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Is mbǝ kapalnahum. Nǝ'te'libi u in ngemsi, “Yaki dlimtin tǝn shitu?” ");
INSERT INTO zbu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ama sa shilǝnwai, gaki tǝn shitu sa shilǝn i tǝn okǝnki baliwasǝn. ");
INSERT INTO zbu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iddǝm atli, imbe milkushti was kutl nǝ lopi bi, i'ulsisu, “Mulnǝ ɗǝ lyamti tǝt dǝm mulkina u, tikǝ mul dǝb yakǝni, addǝm zheli ki mbalǝn.” ");
INSERT INTO zbu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","I'kan na'yakuwon, izziti adlom ɗasi, illuti adli, i'ul sisu, ");
INSERT INTO zbu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mulnǝ a nje na'yakǝn kǝnǝ gu u gaki shin i u, ami tǝ njeni. Mulnǝ nje u, ami tǝh njewai, mulnǝ shinǝn suɗuh tǝ njeti.” ");
INSERT INTO zbu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","I Yahaya ultisu, “Mul lashti, miyen mulǝn ɗǝ pekkǝtl mi'gatli nǝ shin wagi, in ultisu tǝs zaki, gaki tiɗa bǝlmi kalwai.” ");
INSERT INTO zbu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","I Yesu usu, bi hane twai. Mulǝn kǝn pǝl gagashiti nǝ shinyini, apa alǝbi alǝbi abbyalǝnwai. ");
INSERT INTO zbu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mulnǝ bǝ ɗa leu badl nǝmini wai u, ginǝn kǝni. ");
INSERT INTO zbu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mulnǝ abǝlkin mbǝga mal nǝm gaki kini ki Almasihu u, bali ami pikkini, tǝkǝn hol ulnǝ sǝbbǝltwai. ");
INSERT INTO zbu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Nǝtǝ mulnǝn la'gon ge'na'mili mi'la'ti mbatl nǝ ami tǝppǝl bes lǝɓa, nǝn ngǝtlitti sǝllaki'bal yegǝn nǝ'ti hwu a yalɗakka, a la'ti swage'bal mali. ");
INSERT INTO zbu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","In towa'ɗǝ la'tiki ɗǝpǝl beslǝɓa u, a pocitaka. Nǝn ngǝtli' ki, ki tege' gukki lya nǝ ndola toh, ɗǝ gunǝ ki' tege' utu nǝ toh lopu, utuyi mul pǝshtiwai. ");
INSERT INTO zbu_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Alǝbi zhiɓǝl mi'cissi nǝnɗa mǝshtwai, nǝnɗa mbǝshti utuyiwai. ");
INSERT INTO zbu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","In asǝnwa' ɗǝ la'tiki ɗǝ pǝl beslǝɓa u, a pocitaka. Nǝn ngǝtli' ki, ki' tege'gu'ki Lya nǝ ndola asǝn, nǝ sǝllaki ge' ban utu nǝ asǝn lop. ");
INSERT INTO zbu_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Alǝbi zhiɓǝl mi'cissi nǝnɗa mǝshtwai, nǝnɗa mbǝshti utuyiwai. ");
INSERT INTO zbu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","In dwaɗǝn wa'ɗǝ la'tiki ɗǝ pǝl beslǝɓa u, a ngongoli taka. Nǝn ngǝtlikki ki'tege' gukki Lya nǝ dwaɗǝn nǝm, nǝtǝ' laki age'ban utu nǝ dwaɗǝ lop. ");
INSERT INTO zbu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Alǝbi zhiɓil mi'cissi nǝnɗa mǝshtwai, nǝnɗa mbǝshti utuyiwai. ");
INSERT INTO zbu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nǝ utu sǝ'okkǝl mbalǝn, kan unǝ ɗǝ okkǝl lǝɓa nǝ kukkudu u. ");
INSERT INTO zbu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Kukkudu ulki zekkini, in kukkudu i a hammu, nǝ yakǝn tǝ mbili' tǝptǝnki? A' dǝmni nǝ kukkudu ge' mba dlwakǝn. Pǝlǝn dǝbki zeki ne'yelsǝni.” ");
INSERT INTO zbu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","I Yesu hilya ɗǝlǝbi, illǝ ge' Atl ki Yehudiya, ne' tǝn bigasi ki dlǝlka Uldun. I hwu' mbalǝn maga ma'ti ɗaɗanu, i'kulcisi kan u nǝ'kuɗa u. ");
INSERT INTO zbu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","I palisiyawayen mbǝ ma'ti gaki sǝccimbǝlti, is ngemti is ultisu, “Kizoɗa tǝ yakǝn mbalǝn la' kǝli wasa?” ");
INSERT INTO zbu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Inndǝgisi i'usu, “Ya Musa pikini?” ");
INSERT INTO zbu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Is usu, “Musa bǝl mbalǝn sǝllash lwabbatki tlot kutleti, ala kǝliyisi.” ");
INSERT INTO zbu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu ulsisu, “Gaki ndǝlki gawakǝn lakiɗa i Musa lacikin zhiluɗa. ");
INSERT INTO zbu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Amma teɗi ‘Lya kǝnǝnsi, mwani nǝ kǝli. ");
INSERT INTO zbu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Gaki nǝgu a mulǝn za'dyawasi nǝ bwasi, an ngap kǝliwasi.’ ");
INSERT INTO zbu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nǝguni si lopi as dǝm dlinǝm. Akinaki nǝmkǝni sǝkǝn dǝmti dli lopkǝnwai. ");
INSERT INTO zbu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ulnǝ Lya a mani u, bǝ mbalǝn bwasiwai.” ");
INSERT INTO zbu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","A gip libine i milkushtiwas ngemti ɗaɗanu tǝn shilǝngu. ");
INSERT INTO zbu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","I' ulsisu, “Mulnǝ ala kǝliwasu, in ngau kundu u, ko'kǝn ti pǝlti nǝki lopi. ");
INSERT INTO zbu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","In kǝliyi ala mwani wasu in ngau kundu u, tapǝl kontu ɓalu.” ");
INSERT INTO zbu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mbalǝn ɗǝ mbǝllit Yesu na' mil gaki tǝttǝnsiɗa, i milkushtiwas matisi. ");
INSERT INTO zbu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nǝ Yesu yeni nǝgu u i uli cillo'si. I' ulsisu “Zakǝn na'mil sǝmmbǝ makkǝni, bi hanesiwai. Gu'ki Lya ki unduwasǝnkǝni. ");
INSERT INTO zbu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ami dlǝmikkini, mus mulnǝ andǝ nǝ gukki Lya kǝnǝ gunǝ na yakǝn ɗǝpǝlti wai u, tǝkǝn teti ge'guntiwai.” ");
INSERT INTO zbu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","I Yesu kansi twadli, ati zissito, ati laki'si albalka. ");
INSERT INTO zbu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nǝ Yesu gollǝtu, i mulǝn pe'tetnǝkitǝl, inngus kinaɗakka, in ngemti i'ultisu, “Mullashti mul zo'mbadlǝ, yakǝntapǝli tambi dlǝwu nǝbǝ kǝnpa'twai u?” ");
INSERT INTO zbu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","I Yesu ultisu, “Yalakiɗa i'mbeki zo'mbadlǝ? Mul zo'mbatl nǝnɗawai sai Lya nǝgwasi. ");
INSERT INTO zbu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Man zhilgi, ‘bǝtlo mbalǝnwai. Bǝ pǝl kontwai. Bǝ mǝgǝlwai, bǝdlǝm laga' tǝn mulǝnwai, bǝ dlu mbalǝnwai. Nal mikzǝ'ki.’ ” ");
INSERT INTO zbu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","I'ultisu, “Mullashti, mus apǝl undigi a ami na yakǝn.” ");
INSERT INTO zbu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","I Yesu yati ya'ki lyamti, i'ultisu, “Ul nǝmkǝn ɓaliki lǝ ki'ul ulnǝ ni'zi u taka, a'bǝl mingi nǝbǝ ulǝn nisi ɗawai u, kǝn mbi lǝɓa a Lya. Apa a'mbǝ a'bǝlǝnkal.” ");
INSERT INTO zbu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nǝ kub shilǝni i kinawasnda, izzǝga ati du mbadlǝ, gaki usǝn nǝdɗa eye. ");
INSERT INTO zbu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","A lǝbi I Yesu ya milkushtiwasi, i'ulsisu, “Nǝn lotiɗa tǝmi' usǝn tege'gu'ki Lya!” ");
INSERT INTO zbu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Milkushti yi kum gagashit ki shilǝnwasi. I Yesu ulsisu ɗaɗanu, “Kini milini, nǝn lotiɗa te'ge guki Lya! ");
INSERT INTO zbu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nǝte'kǝ mul usǝn ge'guki Lya, nǝn ngǝtlǝ' tǝ lakumi tǝbɓeu ge'shuki allula.” ");
INSERT INTO zbu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Is kum gagashit mulndǝlti, is ultisu, “In nǝgu uɓo, wokǝn mbi pekkǝlkǝn ngu?” ");
INSERT INTO zbu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","I Yesu yasi, i'usu, “Ma'mbalǝnɓo mulpǝkkǝnwai, ama bǝ ma'Lya wai. Gaki muslǝɓa mulpǝkǝni ma' Lya.” ");
INSERT INTO zbu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","I Bitlus ultisu, “Mi ngu ma za'lǝɓayi mabǝlkikali.” ");
INSERT INTO zbu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu usu, “Bali ami dlǝmi'kini, mulǝn kǝn za'ti libi, ko yelsǝniwas mudlǝ, ko yelsǝniwas mwani, ko dyawasi, ko bwasi, ko milwasi, ko guwasi, gayini nǝkuma shilǝnki Lya, ");
INSERT INTO zbu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","apa a'hwol mbi' diɓǝl lǝɓa kutlkutl lǝbi kutl ge' dǝpki nǝguni, nǝ libi, nǝ yelsǝni mudlǝ, nǝ yelsǝni mwani, ne' mi'zǝtti mudlǝ, ne'mil, ne'guh, i ngu kuma nǝ bǝna. A lahila ne, ammbi dliwunǝbǝ kǝn pa'twai u. ");
INSERT INTO zbu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Diɓǝli kǝkina nǝnpaltikali, kikali nǝnpalti kina.” ");
INSERT INTO zbu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Si to'ulshelima, Yesu ɗǝ lǝ'akinaɗasi, a milkushtiwas ɗǝ kup gagashinti, mbalǝnyi nǝ ɗǝ bǝdl si kalu sima asi kupɓanti. Im mbǝ' kutl nǝ lopiy, amalgǝni i'go'dlimissi ulnǝ tǝ mbitu. ");
INSERT INTO zbu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","I' usu, “I ngu mi sutin Ulshelima, sǝn bǝdl yakǝnmbalǝn ma'bas lǝɓasi ki Lya ne'mi'lashti zhil ki Musa, sin pocitti shilǝnki mǝshti, as bǝl mingi nǝbǝs man Lya wai u. ");
INSERT INTO zbu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Sin lakkitti bi, as bezze'makǝn, as li'ti, as tloti, kalki mutti maki kuma atli lya.” ");
INSERT INTO zbu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakubu nǝ Yahaya, milki Zabadi, is sha'temma'ti, is ultisu, “Mullashti, mingepki ki pǝlimi ulǝn.” ");
INSERT INTO zbu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","I ulsisu, “Yaki lyamtini ta pǝlikini?” ");
INSERT INTO zbu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Is ultisu, “Ndǝgimi, cinkǝ te'ge' naltwagi, tǝ nǝm dǝm tǝn toshimtwagi, nǝm tǝn tonawagi.” ");
INSERT INTO zbu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","I Yesu ulsisu, “Kimanǝn ulnǝ ngemtini uwai. Kǝn ma'tleti ge'mbǝga malunǝtta tlewa? Ko nǝn ma'pǝlikkin baptisma unǝssǝ' pǝlitǝnwa?” ");
INSERT INTO zbu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Is ultisu, “Mǝn manti.” I Yesu ulsisu, “Mbǝgamalunǝ tatle nǝnali u, nǝnali ki tleni, baptisma u nǝsǝ'pǝli u, nǝnali sǝppǝli kini. ");
INSERT INTO zbu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ama dǝptǝn toh shimtini, ko tǝn tohna yini, gikǝnwai gunǝ nǝ halta bǝli u. Ai, kǝginǝs pǝli gawasǝn uni.” ");
INSERT INTO zbu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nǝ milkushtiwas kutli kumi nǝgu u, is gob kub dutu'ki Yakubu nǝ Yahaya. ");
INSERT INTO zbu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","I Yesu takisibi i'ulsisu, “Ki manini ginǝ mansi nǝ bǝ Yahudawawai u gumsisi wasǝn sǝnɗǝ nu ne' mbalǝnwasǝn kǝmti sǝnɗǝ pǝlisi ndǝlti. ");
INSERT INTO zbu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kǝndǝmti nǝgu ge' dlomwakǝnwai, amma mulnǝ ɗǝ lyamti tǝ'dǝm bali age' kini u, sainǝ tadǝm zheli wakǝn. ");
INSERT INTO zbu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mulnǝ ɗǝlyab dǝb mulkina wakǝn u, sainǝ tadǝm zheli ki kowonngi. ");
INSERT INTO zbu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Gaki yakǝn mbalǝn ma tǝ mbǝni sǝppǝli'bǝna ɗawai, gaki tima tǝppǝl bǝnaɗani, abbǝl dlǝwasi gaki diɓǝl mbalǝn.” ");
INSERT INTO zbu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Is mbǝkǝci a Yaliko. Ti pe'ti ɗǝ Yaliko ngu, nǝti ne'mikkushtiwasi, nǝ bal dwobgakǝ diɓǝl mbalǝn, i dwa won mul ngeplu shinwasi Baltimawus, yakǝnki Timawus, tiki dǝmi a bishitu. ");
INSERT INTO zbu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nǝkkumi Yesu mul Nazalat kǝn u, i'go' tlǝl yali ati usu, “Yesu yakǝnki Dauda, kum gontini!” ");
INSERT INTO zbu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","I diɓǝl mbalǝn matiti, tǝn bǝshilǝnnuwai. Amma i'gob mbǝtl tlǝl yaltinki, ti usu, “yakǝnki Dauda kum gontini!” ");
INSERT INTO zbu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","I Yesu dlili i'usu, “Takitibi teh.” Is taki dwanisi bi teɗi is ultisu, “Albishiliwagi! Leteɗi, ti mbekkibi.” ");
INSERT INTO zbu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Illa' ul idlatti taka, ittlǝtyama' Yesu. ");
INSERT INTO zbu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","I Yesu ultisu, “Yaki lyamti ta pǝliki?” Idwani ultisu, “mullashti, tambi yellu!” ");
INSERT INTO zbu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","I Yesu ultisu, “Zǝgawagi, la'ti mbalwa' a ndokǝlki.” Alǝbi i'ellu, ibbǝl Yesu kal izzǝga. ");
INSERT INTO zbu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nǝs ɓalnja' nǝ Ulshelima u nǝ Betapaji, nǝ Betanya, a ma' Zǝnga Ki zaitun, i' Yesu shin mil kushtiwasi lob, ");
INSERT INTO zbu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","I Yesu ulsisu, “Tenge' yakǝn gatlu nǝ kina wakǝn u, Nǝte' twakǝn kǝn en' yakǝn zhaki ki kǝndi, gunǝ bǝmulǝn a to tǝnti gason wai u. A' tǝgǝlǝn ti suɗi. ");
INSERT INTO zbu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","In mulǝn a ulkinsu, ‘Ya kipǝlin ɗa nǝgu?’ A ulǝnsisu ‘Mulban kǝn ɗǝ lyapti, tǝn patltisut nǝguni.’ ” ");
INSERT INTO zbu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Is zǝga, is le'mbi yakǝn zhaki a kina dlabi a bishitu, is tǝngǝlti. ");
INSERT INTO zbu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mɓalǝn inǝ ki dlǝli a lǝbi u, is ulsisu, “Ya laki ki tǝngǝtl yakǝn zhaki u ɗa?” ");
INSERT INTO zbu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Is dlǝmisi ulnǝ Yesu pisi u. I mbalǝnni za'si is zǝga, ");
INSERT INTO zbu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nǝs mbǝlli Yesu yakǝn zhaki u, is lala lulutwasǝn tǝnti, it toh tǝnti. ");
INSERT INTO zbu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","I' hwu' mbalǝn lala lulutwasǝn tǝn shitu i'nami caldwa te' ge' dǝlgǝn i gen' dizhan dwai nǝscali te'ge' dǝlgǝni u. ");
INSERT INTO zbu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mi' ki kina nǝ mi' bǝtl kalwasi asi tlǝl yali asi ussu, “Hosanna! Albalka tǝn mul mbǝ ge' shin ki Lya! ");
INSERT INTO zbu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Albalka ki gut mul mbǝti, ki bwasinǝn Dauda! Hosanna ki Lya!” ");
INSERT INTO zbu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","I Yesu te' Ulshelima, i' te'ge libi ki Lya. Nǝ yaya lutya u nǝ' enlu a gemtu, ippeki illǝ Betǝnya nǝ kult nǝ loppi. ");
INSERT INTO zbu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Cilkǝlu nǝ za'ti betanya wasǝn, a Yesu ɗǝ kum kuzǝn. ");
INSERT INTO zbu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nǝ' en pǝkkǝ kah tel lolu u mul dwa lede, Nǝllǝ' ya ni u tambi mil tǝnkiwai. Nǝm mbǝci ma'tu, tambi ulǝn tǝnkiwai amma dwakatl, gaki luɓal kǝpǝtl mil ki kah u wai. ");
INSERT INTO zbu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","I ul kah nisisu, “Bǝmulǝn ɗam mil lwanǝwai hal patwagi!” Amilkushtiwas ɗǝ kubti. ");
INSERT INTO zbu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Is mbǝci Ulshelima, I Yesu tye ge' libi ki Lya i'gop katti mil ultitaka alǝbi, i'dǝzhanisi kundǝn ki ulpwasǝn taka, ne' mil shotti ulpi, ne'mil utl balutaka, ");
INSERT INTO zbu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Taza'si sǝllǝ ge' libi ki Lya nǝ ulǝn nǝwai, ");
INSERT INTO zbu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ippisi shilǝn, i ulsisu, “Kilaciɗa: ‘Libi ini nǝndemti libi shilǝn ki Lya ki mi' dǝplǝɓa’ ki ni ɓo ka palliniyi lu dǝpki mǝgǝlsi.” ");
INSERT INTO zbu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nǝbas lǝɓasi nemi' lashti zhil ki Musa nǝskumshilǝni u is gop ngau shitu kigoptiti sǝ'tloti, gaki mbalǝn diɓǝli sikupɓultwasi, mus dopga ki mbalǝn si kup gagashit ki kushtiwasi. ");
INSERT INTO zbu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nǝ su' pǝ u Yesu ne' milkushtiwasi is pe' ɗǝ ge'gadli. ");
INSERT INTO zbu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nǝkyau si ɓeuti, is ye'kah nǝsi akokkǝnyi hal nǝ tlilgisi, ");
INSERT INTO zbu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Bitlus dambǝlti i' ul Yesu su, “Mullashti, nǝya! Kah u nǝ' pǝlibbi u. Akokkǝn i!” ");
INSERT INTO zbu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","I Yesu ndǝgi. I' ulsisu, “Lakǝn mbadli tǝn Lya” ");
INSERT INTO zbu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","“Bali a mipi'kini, in mulnǝ a ndǝ nǝ Lya u, tǝn ma' utl calgatl usu, ‘Ndus ɗǝki nda swa ge' dlǝlka u’ abǝ ta bwas mba dlwa swai u nǝn pǝlitti ulisi. ");
INSERT INTO zbu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Gaki nǝgu a mi pikkini ulnǝ ka gyemin ge' shilǝn nǝ Lya u, i' ndǝ nǝ nali u, kǝm mbitini. ");
INSERT INTO zbu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kogassi u kǝn kidlǝlni ɗǝ gyep Lya u, in ka ngapǝn mullǝn mbatlu, a tusintaka, Gaki bwaswakǝn ki lya ma tǝn tusi'kin bezǝn lǝɓawakǝn taka. ");
INSERT INTO zbu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Inkiɗa tusti mulnǝ ngapǝnti mbatl takawai u bwaswakǝn ki lya ma tikǝn ndusi'kin ulnǝ ki pǝliti u takawai.” ");
INSERT INTO zbu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nǝspalswa Ulshelima u, ti dut tyagelu libi ki Lya, i Lǝɓasi ne'mi'bǝl lashti zhil ki Musa, nǝ mi'kina ki mbalǝn is mbǝ ma'ti, ");
INSERT INTO zbu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Is ul Yesu su, “Nǝ shitu u kǝn kipǝl usiɗa u? Wokǝn bǝlkishitu kǝpǝlti nǝgu?” ");
INSERT INTO zbu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu i' ulsisu, “Ta pǝllikin undi gyepton. A ndǝgi nǝni, amine adlǝmi'kini nǝ ndǝtl ki okǝn amipǝl usi ɗa. ");
INSERT INTO zbu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Baptisma ki Yahaya sul lya, kǝnpeka koki mbalǝn kǝni? Dlǝminǝni!” ");
INSERT INTO zbu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Is gob shottibi ne' elsǝni asi usu, “In ma ulnǝsu, ‘Sul lya kǝn pe'ku’ tǝn ulminsu ‘Ya lakiɗa bǝma ndǝ ninǝti ɗawai?’ ");
INSERT INTO zbu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ngo nǝnǝgu sa ussu, ‘Ki mbalǝn kǝn u’ ” (Siɓulti' hwu'mbalǝn, nǝ kowongi simani Yahaya mul nje shinkǝ ki Lya kǝni.) ");
INSERT INTO zbu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Is ndǝgi' Yesu, “Simani wai.” I Yesu usu, “Akǝn pi'kini nǝ ndǝltu kǝn amipǝl usi ɗawai.” ");
INSERT INTO zbu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu pǝlisi shilǝn nǝ cibǝlti, i ulsisu, “Mullǝn ɗa mulnǝ pǝl gu inabi. I' gandǝli, i' ɗushu ki cetti mill inabi isi. I' kǝn yakǝn kǝs ki mul ɓutti gu. Ip bǝl mbalǝn yen mi' kwolu kǝ lǝbi. Ilǝge Atliwon. ");
INSERT INTO zbu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nǝgis cilu, i shin zheliwasi ma mi' kwolu i tǝ'kami' na mil inabi i te'ɗi. ");
INSERT INTO zbu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ngo nǝnǝgu mi'kwolluyi is gobti, is liti is katti tohwas koni. ");
INSERT INTO zbu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","I' shin zheli won' ɗanu ma'si; is li'muli aga, is lati ge'sha. ");
INSERT INTO zbu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","I' shin gon'ɗanu, tiɓo, is tloti. I shin gen ɗanu diɓǝli; genwasǝn gen'ɓo is tlosi, genwasǝn ge'si ɓo is li'si. ");
INSERT INTO zbu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Hal nǝgunma Yakǝn, nǝm ɗiti. Gunǝ ti lyapti u. Ibpa' shi' yakǝni swamasi, i' usu, ‘nǝgon as yen naltwasi.’ ");
INSERT INTO zbu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ngo nǝnǝgu mi'kollu i ma is ul elsǝsu ‘Yakuwas kǝngu, mulgu tiɗǝ nje' bwasi nganni, Mi tloti, alǝɓayi dǝmginǝn.’ ");
INSERT INTO zbu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Is gobti is tloti, is latitaka tyakalbi. ");
INSERT INTO zbu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yakǝn tǝ mulgu i pǝli? Tǝn mbǝti a tlwami' kwollu i si, ab bǝlmbalǝn yen gu isi. ");
INSERT INTO zbu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kiniɓo ka yanǝn shilǝn ki Lya ki laci gasonwaiya? Ki laci ɗa ɗǝ ussu, ‘Zǝnga u nǝ mi' kǝbbi nge u, i dǝm zǝnga gǝsbi ki ze'ki. ");
INSERT INTO zbu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Gu kyautǝn ki Lya kǝni, ma'mini ulki gagashi'kǝni.’ ” ");
INSERT INTO zbu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bal lǝɓa, nǝ mi' bǝtl lashti zhil ki Musa ne' mi'kina is ngau shitu ki gobtiti, simani cimɓǝlti u tǝnsi ni, is kum ɓulti ki hwu mbalǝn. Gaki nǝgu is zati, is ziga wasǝn. ");
INSERT INTO zbu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Is shin palisiyawa yentey nǝ mbalǝn ki Hilidus, gaki si hwodǝl Yesu geshilǝ wasi. ");
INSERT INTO zbu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nǝs mbǝ u, is ultisu, “Mul, lashti mimani ki mul dlǝb balini, kiɗa olt mbalǝn wai, i' kan kowonngi ndatce, sai kullcit mbalǝn shitu ki Lya kǝnkiɗa. A ndalini ki tǝnɓalt upki banya, ki Kaisalya bal gu ki Loma, ko imi? ");
INSERT INTO zbu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tǝm ɓatliya kobǝn ɓatliwai?” Ti'ma nǝm mangashtwasǝn u nǝsikǝn ndǝtti u, I'ulsisu, “Yalaki i ki cimbǝltǝn ɗa? Nǝ kaminǝn ulpu te'ɗi tanǝyani.” ");
INSERT INTO zbu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Is kamiktai. I ulsisu, “Shin ki wokǝni nǝ shishipti ki wokǝntǝnki? Is ultisu, ki Kaisalkǝni.” ");
INSERT INTO zbu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","I Yesu ulsisu, “Bǝlǝn Kaisal, ulnǝ ki Kaisal u, a'bǝlǝn Lya ulnǝ ki Lya u.” Is kum gagashinti ki Yesu. ");
INSERT INTO zbu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadukiyawa, si ussu, tlǝllya ki mi' mǝshtiɗawai, is mbǝ ma ti, nǝ gyemti, ");
INSERT INTO zbu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mul lashti” is usu, “Musa alacimi, ǝn yelse ki mulǝn amǝcu, isza kǝliwasi bǝ yakǝn ni'ɗawai u, adǝmi hwel ki kan kǝlisi, azi yelse wagisi mil. ");
INSERT INTO zbu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Is, pǝl mbalǝnyen elsǝni ini mwani gudǝl ninngi. Nǝm pǝl kutleti, immǝci taza yakǝnwai. ");
INSERT INTO zbu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kilopisi ma i kǝnkǝli i, tima immǝci, tambi Yakǝn sitwai. Ki maki ma nǝgu. ");
INSERT INTO zbu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nǝgu must ningi i sambi yakǝn ne'twai. Patibisi ikǝli i mǝci. ");
INSERT INTO zbu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Gas, tlǝllya kǝmik mashti, kǝli kǝwo kǝntidǝmi age' si? Gaki muswasǝn sadǝm nǝkǝli isi i.” ");
INSERT INTO zbu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","I Yesu ulsisu, “Gaki nǝgu ki gǝlni ɗawaiwa? Gaki kimanǝn lwabatwai, bǝmanǝn pǝlti ki Lya wai. ");
INSERT INTO zbu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Gas tlǝllya kǝmik mǝshti kuletti nǝn ɗawai, abǝkǝndǝti nǝn ɗawai, sitdǝm kǝnǝ milshinkǝn ki Lya kǝni. ");
INSERT INTO zbu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Gaki tlǝl lya kimi mǝshti, kataɓa, dlap lashti ki lwabakki musa waiya, kǝnǝgunǝ Lya ultisu, ‘Ami ki Lya ki Iblahim, nǝ Ishaku nǝ Yakubu waiya?’ ");
INSERT INTO zbu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Gi'nǝ Lya wasǝn bǝ mul mushtiwai u, Lya wasǝn kamini. Balini kagǝlni i.” ");
INSERT INTO zbu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","I mul bǝl lashti won ki Musa immbǝ immbisi ɗǝ shotti bi ne yelsǝni. Nǝ' en Yesu apǝlisi shilǝn ki zeki u in gyem Yesu, “Zhilu kǝnki mul natl kǝni?” ");
INSERT INTO zbu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","I Yesu ndǝgiti i ultisu “Mul nalti tikǝ, ‘Kumini mi' Islaila, Lya i nǝn, Lya nǝmkǝni. ");
INSERT INTO zbu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Lyam Lya wagi nǝ mbadlwagi, nǝ dliwagi, nǝmanti wagi, nǝ ndǝl twagi.’ ");
INSERT INTO zbu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mul bǝtlti iki, ‘ki Lyam yelsewagi kǝnǝ gawagi.’ Zho ulǝn nǝnɗa ti ngǝtl gu nǝnaltwai.” ");
INSERT INTO zbu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","I' mul lashti zhil ki Musa i ultisu, “A ndǝgi balini mul lashti, Lya nǝm kǝni, gonnǝn ɗawai saiti, ");
INSERT INTO zbu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","A' lyam Lya nǝ mus mbatlwagi, nǝ mus mantiwagi, nǝ mus ndǝltwagi, a' lyam yel'sewagi kǝnǝ gawagi, Ai ngǝtl ulnǝ ki kyeli Lya u nǝ poshti poshti u nǝ kini ɗa u lolu.” ");
INSERT INTO zbu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nǝ Yesu Ye'ni tapǝlli shilǝn ki zeki u, I ultisu, “Kiɗa lolu nǝ gu'ki Lya wai.” Pa'ti bisi mulǝn a ngemti nǝ ndǝl ki mbatl ki ullǝn nuwai. ");
INSERT INTO zbu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nǝ Yesu ɗǝ, kulcik mbalǝn age libi ki Lya i' usu, “Yalaki i mi' lashti zhil ki Musa usu almasihu yakǝnkǝ Dauda ni? ");
INSERT INTO zbu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dauda gawasi, tǝn ndǝl ki yalki mbatl ki Lya ki gunti I usu, “ ‘Lya ul Lya i usu, “Dǝm tǝn toh shimtini, he nǝ azǝkki a ga ɗǝ mik ngekki.” ’ ");
INSERT INTO zbu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dauda gawasi immɓe' ki ‘Lya.’ Yala'ti atdǝm yakuwasɗa?” Hwu mbalǝn is ga'ki' kǝm nǝ holtugi. ");
INSERT INTO zbu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","A ge'lu kulcik mbalǝn ki Yesu, i' usu, “Pǝn ɗemɗem nǝmi bǝtl lashti zhil ki Musa, mi' lyap dunnǝ bas lulugǝl, lyamtiwasǝn tǝ mbalǝn gob shinnissi age'lu ulti nǝ ultitaka, ");
INSERT INTO zbu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","lyamtiwasǝn tǝ mbalǝn bǝtlsi ludǝp kizeki age'lu dopga ki Yahudawa, nǝlu daddabǝl. ");
INSERT INTO zbu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Siki mi'ɗap lǝɓa ki mudliyi nǝ mwani mǝcisi u, nǝ pǝtl pyasi' shilǝn nǝ Lya gaki gǝl assan. Sisǝ' pocisi batlti mulndǝlti.” ");
INSERT INTO zbu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","I Yesu dǝm malgun kǝlu kap up ki libi ki Lya, ati ya' ulpu nǝsi uttti agibɓi u. Hwu mbalǝn mik ulki toh asi utti ulpi milnalti. ");
INSERT INTO zbu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Amma guli kǝliwonmbǝ gunǝ bǝ ullǝn nǝɗawai u gunǝ mwaniwas mǝci i bǝl bwasti dlom ki kobo, iki kobo nǝm, ");
INSERT INTO zbu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","I Yesu taki milkushtiwas bi, i ulsisu, “Balini, amipikkini, ulnǝ guli u utti u gunǝ bǝ ulǝn nǝɗa wai u ngǝl ki mbalǝn kap. ");
INSERT INTO zbu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Musswasǝn si bǝlini tǝngaki usǝn wasǝn, ti ɓo jwa ulnǝ nǝtoh u tǝbǝli, gunǝ itidǝmiti.” ");
INSERT INTO zbu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu ɗǝpeti tet libi ki Lya, nǝm age'mil kushtiwasi i ultisu, “Mullashti, nǝyen undi zǝnga i nǝ kǝpbi i!” ");
INSERT INTO zbu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","I Yesu ultisu, “Kǝn ɗǝye' unndibas kǝpbi iwa?” Ba zǝnga u nǝ bǝkǝn dizhatti takawai u. ");
INSERT INTO zbu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu kǝdǝmi atǝn zǝga Zaitun gunǝ ɗǝ ya' libi ki Lya u iki Bitlus, nǝ Yakubu, nǝ Yahaya, nǝ Andalawas is gyemti amalgǝni ");
INSERT INTO zbu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Dlǝmimi anǝmi sǝppǝl usi u? Undi ulu kǝntǝn yeni gasi u nǝɗǝ lyap ndatu?” ");
INSERT INTO zbu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","I Yesu ulsisu, “Maninca bǝ mulǝn gǝl kiniwai. ");
INSERT INTO zbu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mbalǝn diɓǝli sǝn bǝti ge' shin ini, asi ussu ‘Siki ami,’ hal Sǝngǝl mbalǝn diɓǝli. ");
INSERT INTO zbu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Inki kup shilǝn ki dlati dlati nǝ kumini kumini wasǝn u bǝ ɓatlwakǝn tlǝwai. Hwel nǝgu tǝnda, amma pati bisi i' ɓalla u wai. ");
INSERT INTO zbu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mɓalǝn nǝntli yelsǝni mbalǝn, gunti, nǝntli gunti. Nǝngotti kup nyapti ki atli agǝ luyen, nǝ kuzǝn. Ngo nǝnǝgu la'ti gǝs ki bǝnani.” ");
INSERT INTO zbu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Pǝn ɗemɗem nǝ gawakǝn, gakisǝn tilakin kina ɗǝ mik atli, as likin age lu dopga ki Yahudawa. Gaki shin ini, kin dliti akina ɗǝmik kǝndǝdlom nǝ gumsi tǝn gaki ki pisi ulnǝ' manini u. ");
INSERT INTO zbu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Adǝmi hwel gopti shilǝn ki Lya kǝn pa tǝn dlǝmi mbalǝn. ");
INSERT INTO zbu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ga'si unǝ satǝlakin kina ɗǝ gumsi' u, bǝ hwok kiniwai, ngo nǝnǝgu kini kǝmil shilǝnwai, Yalkimbatl ki Lya kǝn bǝtl kin ulki dlǝmi. ");
INSERT INTO zbu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Yel'se nǝn bǝtl yel'sewasi as tloti, bwasi tǝn bǝtl yakuwasi mil nǝn tlǝlli' mikzi'si as laki a tlosi. ");
INSERT INTO zbu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mbalǝn nǝnnge'kini gaki shin ini, ngo nǝnǝgu mulnǝ a ngashbi nǝpatwasu tǝnpeti.” ");
INSERT INTO zbu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ka yenǝn a dllǝl bezǝn kyautǝn mull cik zhenti gelu unǝ bǝ a mbunwai u (mull dlǝm lashti tǝmmanica), Ginǝ ge' atl ki Yahudiya u as kitǝli as tege'zǝnga. ");
INSERT INTO zbu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mulnǝ ge libi ki lya u bǝppe' suɗi atte' libi gaki ka' ullǝnwai. ");
INSERT INTO zbu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mulnǝ agegu u bǝ pal te' ɗǝ ka' lulutwai. ");
INSERT INTO zbu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mi' tugi nǝ mi' mil kali age'cin u ulki cik go'kǝni! ");
INSERT INTO zbu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Shilǝnni nǝ Lya bǝ ulu nda age' watlǝnwai. ");
INSERT INTO zbu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Age cin u nǝnpǝl bezǝn lǝɓa u nǝ bǝ a pǝldlǝ gason wai u, tun nǝ Lya pǝl dǝplǝɓa, i mbǝl cin ki sǝti, kǝnpǝl u ndwas nǝwai, nǝpatiki dǝplǝɓa. ");
INSERT INTO zbu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","“Tǝ' Lya abosǝn mutti takawai u, da mulǝn kǝnsatwai, gaki ginǝ olsi i, in ndokǝl mutti taka. ");
INSERT INTO zbu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Age cin u inmullǝn a ulkisu, ‘Yen Almasihu ngu u!’ Ko ‘yenǝn, ti ngwa!’ Bǝ ndǝniwai. ");
INSERT INTO zbu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Gaki almasihu ki lǝgati nǝ mik njeshinkǝn ki Lya ki lǝgatti sǝn peti teɗi asi pǝl ulkǝ gagashinti tǝn gaki sǝ'gǝl ginǝ' olsi i, ǝnnǝn pǝtu. ");
INSERT INTO zbu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tǝngaki nǝgu a' pǝn ɗemɗem; apikini mus lǝɓa u nǝ nǝn ndatu.” ");
INSERT INTO zbu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Amma age' muttyi, kalki bǝna, “ ‘Cin nǝndǝp dǝmshal, Liy kǝn cil nuwai. ");
INSERT INTO zbu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Cadlǝl nǝn gobti nda sullya, Nǝn wu' bas lǝɓa ki lya.’ ");
INSERT INTO zbu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Age' cin u mbalǝn nǝn ye' Yakǝn mbalǝn ɗǝ mbǝtige' ku'kuti, nǝ naltwasi nǝ ndǝlti. ");
INSERT INTO zbu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tǝnshik mil shinkǝnwas suɗi as dom ginǝ' olsi kal nǝ kina, tohna nǝ tohshimti, nǝ ngwatlti ki dǝplǝɓa nǝ ki lya.” ");
INSERT INTO zbu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Kulcin ulǝn tǝn pǝt ki kah: Kayenǝn tǝɓal dǝltu, manini watlǝn ɓal nja i. ");
INSERT INTO zbu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ɗaɗanu kayenǝn u ndigi ɗǝ ndatu, manini tǝɓal nja i, tǝn bidlabi kǝn tiɓali. ");
INSERT INTO zbu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Balini, amipikkini, hwonnu kǝnpatwai, sainǝ mus usi a nda. ");
INSERT INTO zbu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Lya nǝ atli nǝn pati amma shilǝn yini kǝnpa'twai.” ");
INSERT INTO zbu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Amma cini nǝ gasi isi, mullǝn maniwai ko mik shinkǝni ko Yakǝni, mul zǝtti mani katl. ");
INSERT INTO zbu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Pǝn ɗemɗem! Dǝmni nǝ manti aki shilǝn nǝ Lya! Gaki ki manǝn gasi u nǝtǝ cin u mbǝ uwai. ");
INSERT INTO zbu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kǝnǝ mullǝ'lo kǝni: Isza' libiwasi ipbǝl zheliwasi kyautǝn ko gukǝni nǝ kyautǝnwasi, i'ul mul kitǝn dlabi usu Dlǝlgal. ");
INSERT INTO zbu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Dlǝlnigal, gaki kǝmanǝn gasi unǝ tǝmullibini paluwai, ko asuti ko agasi ko abilucili ko nǝ kyau. ");
INSERT INTO zbu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Bǝm mbǝ katl, ambikin ɗǝ nde' Yemmbuɗwai. ");
INSERT INTO zbu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ulna dlǝmmikini u, I ami pikkini: ‘dlǝlni galt!’ ” ");
INSERT INTO zbu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mutti lob kǝn ɗǝ as pǝl daddaɓǝl ki ɗakǝshti ki biledi u' nǝ bǝ Yis ɗagibiwai u, I bas lǝɓasi ki Lya nǝ mi'lashti zhil ki Musa is ngau shitu u nǝ sǝ' gob Yesu ɗa u ki hwuni sǝ' tloti. ");
INSERT INTO zbu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Is usu “Bǝspǝli ge' daddaɓǝl luwai, gaki ɓa mbalǝn tlǝl dlati.” ");
INSERT INTO zbu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu a Betaniya a libi ki mulnǝ si mbeti ki Saminu dakǝl. Ti ɗamti ngu, I kǝliwon mbǝ nǝ yakǝn lǝda gunǝs pǝli nǝ zǝnga ki onis, nǝ mil a giɓi ki naldi mul ulpi. It tatl lǝda mili, it ci ndǝlli' Yesu aga. ");
INSERT INTO zbu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ginǝ a lǝbi u is kum lwetl ki mbadlǝ, is ul yelsǝni su, “Ya lak kon nǝ milu ɗa nǝgu? ");
INSERT INTO zbu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tǝ'sa ulin taka u, ngǝtl upki ndacin ki hwon nǝm as bǝlginǝ bǝ ulǝn nisi ɗawai u, da nǝn gǝtlti!” Is mati kǝli isi. ");
INSERT INTO zbu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Iki i Yesu usu. “Zakǝnti, Ya laki iki hwottiti ɗa? Ulki zokki tǝpǝlini. ");
INSERT INTO zbu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ginǝ bǝ ulǝn nisiɗawai u sinekkini ko gasiukǝni. Ko gasiukǝn ki lyamtini kin pǝlissi zo'lǝɓa, gaki ko gasi u kǝn kine'kǝnwai. ");
INSERT INTO zbu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","I kǝliyi pǝl pǝl tiwasi. It bene mil adli it li'kǝnǝni kamin gutǝni. ");
INSERT INTO zbu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Balini amipikkini, mus lu unǝ tǝ dlǝp shilǝn ki Lya tǝn dǝplǝɓa u, sin gobti dlǝb ulnǝ kǝli u pǝli u gaki da mbǝtlti.” ");
INSERT INTO zbu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","I Yahuza Iskalyoti, nǝm ge' mil kushtiwasi kutl nǝ lobpi, illǝma bas lǝɓasi ki Lya gaki tǝbbǝl yesu masi ɗa. ");
INSERT INTO zbu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nǝskumi nǝgu u is pǝlhwol mbatli, is ndigi sǝ'bǝlti ulpi. I' Yahuda ngwau shitu ki bǝlti. ");
INSERT INTO zbu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Cin ki nǝm ki dadabǝl ki biledi gunǝbǝ yis ɗagiɓiwai u, a kuɗi pǝtl dli i ɗǝ poshti yakǝn mbǝla gaki dadabǝl ki ɗakǝshti, i mil kushtiwas gyemti is usu, “A ukǝn ki lyamti tǝn le' likǝni' lu ɗap dadabǝl ki ɗakushti?” ");
INSERT INTO zbu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","I' shin mil kushtiwasi gudǝl lob, i' ulsisu, “Ten ge'gatli, kin mati nǝ mullǝn ki kami nǝ tobmal a' bǝlǝnti kali. ");
INSERT INTO zbu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ulǝn mullibi u nǝ' te giɓi usu, ‘Mul lashti ɗǝ ngau: kǝbsi nǝtǝ' dǝmi ti' ɗap ulki ɗami ki dadaɓǝl ki ɗakǝshti ne mil kushtiwasu?’ ");
INSERT INTO zbu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tǝn mbokikin toh tǝnbal kǝpson ki libi ki lya, gunǝ ki likǝni ki zoki. A lǝbi ki likǝnimi.” ");
INSERT INTO zbu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","I' mil kushtiyi za'lǝbi, is su ge'gatli, is mbi ulisi kǝnǝ gunǝ Yesu dlǝmisi u. Is likǝn dadabǝl ki ɗakǝshti. ");
INSERT INTO zbu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nǝ bisu pǝ u, i Yesu mbǝ ne' milkushtiwas kutl nǝ lob. ");
INSERT INTO zbu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Asi ɗap ulki ɗami ngu, i Yesu usu, “balini amipi'kini, nǝm agekini tin bǝltǝni, gunǝ ti ɗamti nǝ ami u.” ");
INSERT INTO zbu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","I mikushwasi ispǝl du'tugi, asi ultisu nǝ nǝm nǝm, “ko a mini?” ");
INSERT INTO zbu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","I' ulsisu, “Nǝm ge' kutl nǝ lobpi gunǝ ami ɗamti ge' gal nǝm miti. ");
INSERT INTO zbu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ya'kǝn mbalǝn nǝn zǝ'ga, kan u nǝɗa kǝlaci tǝntu. Amma ulki zǝ'go'kǝni tǝnmulnǝ nǝn bǝtl yakǝn mbalǝn u, nǝn ngǝtli' muli tǝ azǝntwai.” ");
INSERT INTO zbu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Si ge' ɗamti, i Yasu kan biledi, nǝn ngem Lya u, iccaccali, ibbǝl mil kushti wasi, i' usu, “Kamini; guɓo dliyikǝni.” ");
INSERT INTO zbu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Iki i'kan mbǝgamal, kimal ki innabi iki in ngem Lya, ibbǝlsi, muswasǝn is tle a giɓi. ");
INSERT INTO zbu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","“Guki hwulayini ki njikǝ' alkawali, gunǝ bǝna dli gaki mbalǝn u” i' ulsisu. ");
INSERT INTO zbu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","“Bali ami pikkini, akǝn tle' malki innabi nuwai, sai gasiwu nǝta tle pyale' i ge' gu'ki Lya u.” ");
INSERT INTO zbu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nǝs ulwul ki ndwa'ti Lya u, is peki is totǝn zǝga ki zaitun. ");
INSERT INTO zbu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","I Yesu ulsisu, “Muswakǝn kǝn ndatini, ki laciɗa: ‘An li'ti mul byatl mbǝla i', mbǝla i nǝn dla'ti ga.’ ");
INSERT INTO zbu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Amma kal ki tlǝl lya ini, an ngǝtltikin ɗǝ mbǝkǝshti a Galili.” ");
INSERT INTO zbu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","I Bitlus usu, “In muswasǝn sǝn ndatu, ami akǝn ndatwai.” ");
INSERT INTO zbu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","I Yesu ultisu, “Bali ami dlǝmi'ki, age' gasu, kapǝn tǝ guda la'yal asǝn lop, kǝn usu kǝmanǝn wai asǝn maki.” ");
INSERT INTO zbu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","I Bitlus go' dlǝmti nǝndǝlti ati usu, “In nǝn tlotǝn imimiku, akǝn nge' makkiwai.” Muswasǝnma nǝgu sǝ dlǝmi. ");
INSERT INTO zbu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Is lǝge'luwon nǝɗǝ mbettiki Gatsemani, i' ul mil kushtiwasisu, “dǝmniki ta shilǝn nǝ Lya.” ");
INSERT INTO zbu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","I' kan Bitlus nǝ Yakubu, nǝ Yahaya, a ge'nǝgu i wuli gop hwottiti a mbadlwasi, i wuli tlwedli. ");
INSERT INTO zbu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","I' ulsisu “Mbadli ɗǝ bǝna, kǝnǝ ta mǝci. Dlilni aki, a dlilni gal.” ");
INSERT INTO zbu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nǝ' ɓeukina ten ngulen u, in nda atli, in ngem Lya, i' usu, in nǝn pǝtu akami' bǝna u taka. ");
INSERT INTO zbu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","I' usu, “Abba, Bwasinǝn, mus lǝɓa mul pǝkǝni amaki. Kami mbǝgamalu taka. Musnǝ nǝgu bǝ manti ki gayiwai, gwagi.” ");
INSERT INTO zbu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ippal te ma' mil kushtiwasi im mbǝsi ɗǝ nde' yemmbuɗi, i' ul Bitlus su, “Bitlus! Nde' embukǝn kiɗaya? Kǝkǝn maddǝb kǝpǝdǝliwaiya? ");
INSERT INTO zbu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Dǝmni ki pǝdǝli a ngemǝn Lya, ɓa'ndan ge' cibǝlti, yalki mbatl ki lya akami i' amma dli a ndǝlwai.” ");
INSERT INTO zbu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ippal tya ɗaɗɗanu, in ngem Lya, kǝnǝ kiɗigi. ");
INSERT INTO zbu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nǝppal te'ɗu, im mbisi ɗǝ nde' yemmbuɗi, gaki yemmbu' a njikǝn dwaɗǝn wasǝn. Is hwol ulnǝ sǝ' dlǝmitu. ");
INSERT INTO zbu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Patl te' ki makisi, i' ulsisu, “Kiɗi nde' yemmbuɗi aki shu'ta? Anjikǝn i! Cin ambǝ i. Yanini, sabǝl yakǝn mbalǝn a toh ɗǝ mi' pǝtl bezǝn laɓa i'. ");
INSERT INTO zbu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Hillya! Mǝzǝnga! Mul bǝltǝn u ɓalu!” ");
INSERT INTO zbu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ti ge' shilǝn, Yahuda ngu, nǝm ge' mil kushtiwasi kutl nǝ lopi, im mbǝ ne' hwu' mbalǝn siki ngapi nǝ bas pǝga nǝ kumbǝl, bas lǝɓasi ki Lya, mi' lashti zhil ki Musa, ne' mi'kina shinsi suɗi. ");
INSERT INTO zbu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mulbǝtlti u, takǝndi nesi i, “Mulnǝ akucenttu, tiki mullisi: a'gobpǝnti, a'zǝngane'ti a'ngappǝnti kizeki.” ");
INSERT INTO zbu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nǝ mbǝkki Yahuza, I'lǝmak Yesu, I' ultisu, “mullashti!” I'kucenti. ");
INSERT INTO zbu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Imbalǝni gob Yesu is ngapti nǝ ndǝlti. ");
INSERT INTO zbu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nǝm ge' milkushti ki Yesu ki dlǝli nja nǝti, in ndust pǝga wasi ittele zheli ki bali ki bas lǝɓasi ki Lya nde'ti, ippa'ti kǝm. ");
INSERT INTO zbu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","I Yesu ulsisu, “kipe'ni ton nǝ bas pǝga nǝ kuɓǝl wakǝn ki' gobpǝnnǝn ɗama ami mǝgǝlkǝma? ");
INSERT INTO zbu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ko gasiwu kǝni amine'kini, age' libi ki Lya ami dlǝp shilǝn ki Lya, kagobnǝnwai. Pǝlǝn dli nǝgu gaki tǝ shilǝnki Lya njikǝnǝnɗa.” ");
INSERT INTO zbu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Musswasǝn alǝbi is za'ti, is kitǝli. ");
INSERT INTO zbu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Yakǝn giɗǝnsiwon gunǝ bǝ ulǝn nidɗa dliwai u amma ul idlatlti katl, ati bǝtl Yesu kal. ");
INSERT INTO zbu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Nǝs'gob Yesu u, i' kitǝli bǝ ulǝn nidɗa dliwai, is zakkisi ul idlatti. ");
INSERT INTO zbu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Is tǝla Yesu ma' ki bali ki bas lǝɓasi ki Lya, mus bas lǝɓasi, ne' mi'kina, ne' mi'lashti zhil ki Musa is domga ma'ti. ");
INSERT INTO zbu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","I Bitlus bǝlti kali, alolu lolu, swa dlomban ɗǝ ki bali ki bas lǝɓasi ki Lya. Alǝbi iddǝm ne' mi'ɓutti dlabi, a ti ko'utu. ");
INSERT INTO zbu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bas laɓasi ne'mi'dlil shilǝn si ngau ulnǝ sǝm mbi tǝn Yesu u tǝdǝmki ta pǝl byaslǝɓayi sǝm mbi sǝ'tlotti ɗa, sa mbiwai. ");
INSERT INTO zbu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mbalǝn diɓǝli is lige'ga, biwasǝn anda nǝmwai. ");
INSERT INTO zbu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","A ge' kale igyen, shali Yesu lǝga'ga: ");
INSERT INTO zbu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Mǝkum ti usu, ‘Tǝn batti libi ki lya u nǝ mbalǝn kǝni nǝ toh u, a'kǝn kundu ge'mutti maki, gunǝ'bǝ kǝntiki toh wai u.’ ” ");
INSERT INTO zbu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mus nǝ nǝgu biwasǝn a nda nǝmwai. ");
INSERT INTO zbu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","I ki bali ki bas lǝɓasi ki Lya hiliya akinawasǝn, ingem Yesu, i'ultisu, “Ulki dlimi ni'ɗawaiya? Shilǝn u nǝsi dlimti tǝnkupa?” ");
INSERT INTO zbu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesu a shilǝn wai ta dlǝmi' ulǝnwai. I ki bali ki bas lǝɓasi ki Lya ngemti ɗaɗɗanu, “Ko kiki Almasihu yakǝn ki mulnaltwa?” ");
INSERT INTO zbu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu usu, “Amini, kǝn ye' yakǝn mbalǝn kidǝmi tǝntohship ki mul ndǝl ki Lya, ti sussuɗi ge' kukkuti.” ");
INSERT INTO zbu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","I ki bali ki bas lǝɓasi kye'kyesh lulugǝllwasi. In gyemi, “Undǝ sheda ukǝn tǝn ngayin ɗaɗanu? ");
INSERT INTO zbu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ka kumǝn musǝn Lya u nǝppǝli uwaiya. Ya kiyanǝni?” Mus i mbalǝni pochi shilǝn gaki sǝ'tloti. ");
INSERT INTO zbu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","I gen gob bezetti makǝn, is kǝndi' dwaɗǝn, is lili'ti, si ultisu, “Dlǝmimi okǝn liki!” Mik ɓutti dlabi ki libi ki Lya is gob lilititi. ");
INSERT INTO zbu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Bitlus a atli adlomban ge' libini, I zheli Yakǝn kǝli kǝ bali ki bas lǝɓasi mbǝ. ");
INSERT INTO zbu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nǝ en Bitlus ɗiko' utu u, I' yati kizekki. I' ultisu, “Kima a yenǝnki nǝ Yesu, Banazelet tu!” ");
INSERT INTO zbu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Amma i musǝn matti, i' usu, “Aman ulnǝ ki dlǝmti uwaima.” Nǝdl dlǝmi nǝgu u, i' hilya illǝbidla, alǝmdǝmtwai i guda la'yali. ");
INSERT INTO zbu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","I zheli yakǝn kiliyi yenti, itl dlǝmi ginǝ ki dlǝli alǝbi u, “Guma age' si tiɗa.” ");
INSERT INTO zbu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Immusǝnte ɗaɗanu. Alǝn dǝmtwai, iki dlili i is ul Bitlus su, “Kima nǝmwasǝn kǝni, gaki kimul Galilini.” ");
INSERT INTO zbu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","I Bitlus pǝli gawas bi. Ati Lenceti, ati ussu, “Aman mulnǝ kishilǝn tǝntuwai.” ");
INSERT INTO zbu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Alǝbi alǝbi i guda la'yali asǝn lob. I Bitlus dambǝl shilǝn unǝ Yesu pitu, “Kapǝn tǝgunda la'yali ki asǝn lob, kǝnmusǝnti nǝ ami asǝn maki.” Nǝ' dambǝlli u, iki immbutlgekulu. ");
INSERT INTO zbu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nǝcil kǝlu, bas lǝɓasi ki Lya nǝ mikkina ki lashti zhil ki Musa, mus mi' dlil shilǝn is dlǝl shilǝn. Tǝngaki sǝ' kǝndǝ Yesu, is ziga nǝti, is bǝl Bilatus ti. ");
INSERT INTO zbu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","I Bilatus gyemti i' ultisu “Kiki guu ki Yahudawaya?” I Yesu ndǝgiti i'usu, “Nǝgu ki dlǝmi.” ");
INSERT INTO zbu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","I bas lǝɓasi ki Lya is gob dagǝtlti tǝnlǝɓa diɓǝli. ");
INSERT INTO zbu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","I Bilatus gyemti ɗanu i' ultisu, “Ki ngu, si dagǝtlti tǝn lǝɓa diɓǝli, kikǝn ndǝgissi waiya?” ");
INSERT INTO zbu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Amma hal nǝguni Yesu appallisi shilǝnwai, i uli hwot Bilatus. ");
INSERT INTO zbu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ulnǝ guu kuɗi pelti agas cin ki dadabǝl tǝn zakkissi mulnǝmi nǝm kige' kulkuku gunǝ mbalǝn ngemi u. ");
INSERT INTO zbu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mulǝnɗa si mbettiki Balnabas gunǝ ki kǝndǝ age' kulkuku u, ne'mi'ndǝlkiga ginǝ mbǝ mǝshti age' cin ki ndǝlkiga. ");
INSERT INTO zbu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","I dobga ki hwu mbalǝn is mbǝ ma'Bǝlatus tǝppǝlisi ulnǝ' kuɗǝ pǝlti u. ");
INSERT INTO zbu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","I Bǝlatus ngemsi i'usu, “Ki lyamtini ta zakikkin guu ki Yahudawaya?” ");
INSERT INTO zbu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Gaki tamaniyi si usu gaki ngetti lakiɗa i bas lǝɓasi ki Lya bǝl Yesu a tohwasi. ");
INSERT INTO zbu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","I bas lǝɓasi ki Lya is datti mbalǝn shilǝn bi, sǝ'usu tǝzzakisi Balnabas ge'shuki Yesu. ");
INSERT INTO zbu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","I Bǝlatus ngyemsi ɗaɗanu, “I mikǝn ta pǝli nǝmulnǝ ki mbetti ki guu ki Yahudawa u?” ");
INSERT INTO zbu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Is mbǝl la'ti yal tǝnki ɗaɗanu asi usu, “Tolǝnti tǝn gadlǝnnga!” ");
INSERT INTO zbu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","I Bǝlatus ngemsi, “Yalakiɗa? Bezǝn lǝɓa yakǝn tǝpǝli?” Is mbǝl tlǝlyal tǝnki asi usu, “Loti!” ");
INSERT INTO zbu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Bǝlatus ɗǝ lyamti tǝppǝli mbalǝn ulnǝ mba tlwasǝn ɗǝ lyamti u, is zakisi Balnabas. Illaki is lǝ' Yesu u, ibbǝli, sǝ' tolti tǝn gadlǝnnga. ");
INSERT INTO zbu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","I sojoji zǝga nǝti a tya bidla ɗǝ guu, (iki bidla ki gunti) is domi diɓǝl sojoji ga. ");
INSERT INTO zbu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Is laki'lulǝgǝl undi ki gumsi mul hwula gagi, is pǝl kulu gawon ki gumsi ki ili, is shimi'ga. ");
INSERT INTO zbu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Is go'shinitti si usu, “Tǝ Lya pǝli'pyasti ki mutti guu ki Yahudawa!” ");
INSERT INTO zbu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Is go'li'titi aga nǝ kumbǝl, asi bezetti makǝn. Is ngus atli tǝnsi bǝtlti nalti. ");
INSERT INTO zbu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nǝspa' lakkitti bi nǝgu u, is tusi' lulǝgǝl ki guntisi taka, is lakki' lulǝgǝlwasi. Iki is sulti dla gaki sǝ'tloti. ");
INSERT INTO zbu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sige'zǝgga, sai mulǝn kǝngu ɗǝ ɓeuti, mulshin Siman, mulki Sayilin, mul zǝg Elekzanda nǝ Lupus, ti petite'ge' yakǝn gatlon, is la'ti nǝngesi ɗǝka' gadlǝnga ki Yesu. ");
INSERT INTO zbu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Is tǝla Yesu ge'luwon si mbellǝbisi ki golgota, (iki “Luga mbalǝn”). ");
INSERT INTO zbu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Alǝbi sitaki' malki inabi kigushli nǝ mul in nge tleti. ");
INSERT INTO zbu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Iki is tolti tǝn gadlǝnga. Is bwas lulǝgǝlwasi age' dlomwasǝn, is pǝl kuli a tǝn gaki sǝ'en ulnǝ tǝ kowon ngi mbi u. ");
INSERT INTO zbu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nǝ dom ki nǝtapsi ki nikyeukǝn si tolti tǝn gadlǝnnga. ");
INSERT INTO zbu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Is lash shilǝn ki dagǝtlti aga ɗa'ka, “Tiki Guki Yahudawa.” ");
INSERT INTO zbu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Is tol mǝgǝlsi lop tǝn gadlǝnnga ne'ti, gudǝl nǝm tǝn toh shimti, gudǝl nǝm tǝn tohna. ");
INSERT INTO zbu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Gukǝ njikǝ'ki nasi u nǝ' usu, “Sa ɓǝtlti ge'mi' pǝl byas lǝɓa.” ");
INSERT INTO zbu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mi'ɓeuti is go'pitti du shilǝn du shilǝn ya' shuge mbalǝn, asi wuga, asi ussu, “Kiwunǝ kin batti libi ki Lya, a'kǝni ge'mutti makwa, ");
INSERT INTO zbu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Pe'sutɗǝtǝn gǝdlǝnnga uɗa, a' Pe'kǝl gawa' ɗa!” ");
INSERT INTO zbu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nǝgu bas lǝɓasi ki Lya ne'mi' lashti zhil ki Musa is gob lakkittibi age' dlomwasǝn asi ussu, “Tapekǝl gen i', bǝtaman pekǝl gawa swai! ");
INSERT INTO zbu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Almasihu u, guki isla'ila, tǝppe'sudɗǝ tǝn gǝdlǝnnga nǝgun ɗa, mima anyeni anla' mbatlɗa.” Ginǝs tloti ne'tu sima is gob byalti. ");
INSERT INTO zbu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","A bal dloncin, i dǝmshal idla atli, i dom maki ki su'pǝɗa. ");
INSERT INTO zbu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nǝ dom maki ki su'ti, i Yesu shilǝn nǝ ndǝlti i'usu, “Eloi, eloi, blama sabaktani?” (Iki, “Lya yini, Lya yini, ya lakiɗa i'lakǝntaka?”) ");
INSERT INTO zbu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nǝ ginǝ ki dlili alǝbi kumi nǝgu u, is usu, “In ngu, timbe' Iliya bi.” ");
INSERT INTO zbu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nǝ mwasǝn kitǝli, i lap soso ge'mbya mal ishimi tǝn kumbǝl It taki Yesu gaki tǝtle, i ussu, “Dlilni tǝn ya nini ko Iliya nǝn pekǝlti suɗi.” ");
INSERT INTO zbu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","I Yesu shilǝn nǝ ndǝlti, iki mǝshtwasi. ");
INSERT INTO zbu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Iki labule kige libi ki Lya bwasi lǝbi lop, nǝ alya nǝ tli. ");
INSERT INTO zbu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mwani mul ndǝl ki mbalt, gunǝ ki dlǝlli akina ɗǝ Yesu u, nǝ' yen mǝshti, ki Yesu u i' usu, “Balini, mulu yakǝn ki Lya kǝni!” ");
INSERT INTO zbu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mudli yen is dlǝltel lolu ɗǝ yallu. Ge'si Malyamu Magadaliya, nǝ Malyamu dyaki Yakubu Yakǝni nǝ Yusupu, nǝ Salomi. ");
INSERT INTO zbu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","A te' Galili mudliyi bǝlti kali asi pǝlitti kyautǝn. Mudli yen ɗaɗanu diɓǝli nǝs mbǝne'ti a Ulshelima asi lǝbi. ");
INSERT INTO zbu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","A suti, ɗǝ mbǝtti tǝlu cillu cin ki shuti ki Yadudawa. ");
INSERT INTO zbu_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yusupu mbǝ, mulki Almatiya, mul dlil shilǝn kǝni, mul pǝli'mbalǝn zo'lǝɓa, mul ɓutti gukki Lya u, tǝ mbǝ. Ippǝl ndǝlki mbadli illǝma'Bilatus, in ngemi sǝ'bǝlti dliki Yesu. ");
INSERT INTO zbu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","I Bilatus kum gagashinti nǝ'kumi Yesu a mǝccu. Imbe soja yibi in ngemti balima Yesu a mǝccuwa? ");
INSERT INTO zbu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nǝm mani nǝgu u abiɗi soja u, ibbǝl Yusupu dli i. ");
INSERT INTO zbu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","I Yusupu wul likkapani ki lilin. Nǝ'shi' Yesu u, illa'ti ge'li'kapani ki lili i, illa'ti ge'lu gum mbalǝn gunǝs ɗugi ge' zǝnga u, ibbǝdǝl zǝga i tǝn bishu gun mbalǝni. ");
INSERT INTO zbu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Malyamu Magadaliya nǝ Malyamu dyaki Yusupu is yen lu u nǝs guti ɗa u. ");
INSERT INTO zbu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nǝ cin shuti ɓe u, Malyamu Magadaliya, nǝ Malyamu dya ki Yakubu, nǝ Salomi, is ul mil ki tukǝni dli mul tǝmti, gaki sǝlle' tukǝ dli ki Yesu. ");
INSERT INTO zbu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Gas cin ki kina ki shuti, a bilucili petito' kǝccin is lǝge'lu u nǝs gutiɗa u. ");
INSERT INTO zbu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Asi tǝn shitu is ngem yelsǝnisu, “Okǝn jakǝnimmin yegǝn u taka ɗǝbi shu ki gum mbalǝn u?” ");
INSERT INTO zbu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nǝs tlil ga lya u, is yeni, a jakǝn yegǝni taka malgǝni i, in ngu, balini. ");
INSERT INTO zbu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Sisu'ge'lu gum mbalǝni, is yen yakǝn giɗǝnsiwon ki dǝmi tǝn toh shimti, ki dlili nǝ hwol lulǝgǝl. Is kum ɓanti. ");
INSERT INTO zbu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tine i'ulsisu, “Bǝ kumǝn ɓantwai. Yesu mul Nazalat kǝnki ngauhtiya? Gunǝs tolti tǝn gadlǝnngawa? Ta hilya tiɗawai. Yenǝn lu u nes la'ti ɗa u! ");
INSERT INTO zbu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nǝgun u zǝnga ki dlimi mil kushtiwasi, nǝ Bitlus, ‘Yesu yinǝn ngǝltikin nǝ mbǝkǝshti a Galili, tyaka ki yenǝnti kǝnǝ kan u nǝ' dlimikini u.’ ” ");
INSERT INTO zbu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","I mudliyi pe'nǝ kitǝl, uli a hwossi i asi nepti ki dli. Sa ul mulǝnsu ulǝnwai, gaki sikub ɓanti. ");
INSERT INTO zbu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nǝ Yesu hilya ge' mi'mǝshtu nǝ kyeu gascin kǝkina ki shuti, im mbǝl gawas ma' Malyamu ki Magadala, kǝli u nǝ Yesu pe'kǝli' mi'gatli ningi u. ");
INSERT INTO zbu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tine is zǝga ille'dlǝmi mbalǝnyi nǝ, sine' Yesu teɗu, ginǝ si du mbadli, asi kulu. ");
INSERT INTO zbu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nǝs kumi Yesu a mǝci ta hilya u, tima kǝliyi i'enti, sine sala' mbatl nǝtiwai. ");
INSERT INTO zbu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kalki nǝgu i Yesu bǝ gedli kishoti Immbǝl gawasi ma' mbalǝn yen'lob age' mil kushtiwasi asi lǝti ge' ya'kǝn gatlon. ");
INSERT INTO zbu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","I lopi paltya is dlimi na yelsǝniyi nǝ sine' siyi, is nge nditi nǝ dlimtiwasǝn. ");
INSERT INTO zbu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Age' kale immbǝl gawas ma'kutl nǝ nǝmisi, sigawasǝn, nǝsi ɗamti u. Immatisi tǝn ngela'ti mbadlwasǝn nǝ ndilkǝ gawasǝn, sa ndi'nǝ ginǝ yen hillya wasuwai. ");
INSERT INTO zbu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","I'ulsisu, “Zǝnga ge'dǝplǝɓa, ki'dlǝmi mus mbalǝn shilǝn ki Lya. ");
INSERT INTO zbu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mus ginǝ ala'mbadlu, i pǝlisi baptisma u, sǝm mbi' pe'ti. Mulnǝ a nge la'ti mbadlu tǝkǝn mbi' pe'twai. ");
INSERT INTO zbu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nǝn ye' ulki gagashinti ma' mi'la'ti mbadli, nǝ shinyikǝn sǝppekkǝl mi'gatli, sǝn shilǝnti nǝ undi biyen, ");
INSERT INTO zbu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Sǝmma' ka' uci nǝ toh, sǝmma' tle' byaslǝɓa, kǝn pǝlissi ulǝnwai, sǝmma'zǝ' mil gottoh as ndoki.” ");
INSERT INTO zbu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ge' kalki Yesu apa pissi shilǝn i, is kanti twalya, iddǝm tǝn toshipki Lya. ");
INSERT INTO zbu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","I mil kushtiwas peki, is go'dlǝb shilǝnki Lya, a Lya go' ɗǝtl isi, is mani bali shilǝn u nǝ' dlimisi u tu'tǝn ye'gagashintu nǝsi pǝli.");
INSERT INTO zbu_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Age lwatbati ki nǝm, Tiyapolos, na laci atǝn mus unnǝ Yesu gop pǝlti nǝ kushti u, ");
INSERT INTO zbu_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","i mbǝl cin u nǝs kanti twalya u, kal ki ta bǝl zhili tu'ma Yal ki mbatl ki Lya ma mi'shinkǝn u nǝ'shinsi u. ");
INSERT INTO zbu_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kal ki tle bǝnawasi immbǝl gawasi masi tǝn sǝ' mani kami tiɗa nǝ ndǝlti mul nalti, ati mbǝ ma'si dlepdlep mutti kutl kutl lǝbi upsi, ati dlǝp shilǝn ki libi ki gu' ki Lya. ");
INSERT INTO zbu_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Age cin won, ati ɗap ulki ɗami nesi, immbǝlsi zhil gu “Bǝs zǝga ɗǝ Ulushelima pa wai, sǝ' mbu' njikǝ' ki shilǝn u nǝ mul ban pǝli u, gunǝ' kumin abi i u, ");
INSERT INTO zbu_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yahaya ɓo, nǝ mal kǝn tǝ pǝli mbalǝn batisma, amma kal ki mutti ten nǝ Yal ki mbatl ki Lya kǝn tǝ' pǝlikin batisma.” ");
INSERT INTO zbu_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","I mil shinkǝnwas domga ma'ti is gyemti, “Mulban, nǝgun u ki' palli Islaila gunta?” ");
INSERT INTO zbu_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","I' ulsisu: “Mat cin ko hwon nǝ mulban guu Lya zi' tǝn ndǝltwasi gwakǝnkǝnwai. ");
INSERT INTO zbu_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Amma kǝn nje ndǝlti in Yal ki mbatl ki Lya a suikin suɗu; kǝn dǝmitǝn mi' yenti nǝ dwaɗi a Ulshelima, nǝ a Yahudiya nǝ Samaliya, nǝ pa'ti ki dǝp lǝɓa.” ");
INSERT INTO zbu_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kal ki ta dlǝm gu i, i kanti twa lya atǝn dwaɗǝnwasǝn, i kukuti idlati, sa yenti nuwai. ");
INSERT INTO zbu_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Sǝge yallu twalya ati zǝ'ga, iki mbalǝn loppen kǝnngi ge' hwol luluti amalgunwasǝn. ");
INSERT INTO zbu_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Is ussu, “Mbalǝn ki Galili, yalakiɗa i' dlǝlni aki, aki ya'lu twalya ɗa? Nǝm Yesu u, nǝs kanti twalya u, tǝn palti kan u nǝs kanti taka ɗǝ ma'kini twalya u.” ");
INSERT INTO zbu_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Iki i mi'shinkǝn paltya Ulshelima nǝs palsud tǝn zǝnga gunǝ ɗǝ mbetti ki Zǝnga Zaitun, gunǝ nja nǝ gadl ki Ulshelima lǝ' ki mil nǝm. ");
INSERT INTO zbu_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nǝs mbǝci' u, is toge' kǝpsi ki lya gunǝ si dǝp a giɓi u. Ginǝ mbǝyi siki Bitlus, Yahaya, Yakubu nǝ Andalawus, Pilibus, nǝ Toma, Baltholomawus nǝ Matiyu, Yakubu yakǝn ki Halpa nǝ Siman Zaloti, nǝ Yahuza yakǝn ki Yakubu ɗaɗanu. ");
INSERT INTO zbu_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mus is dom ga nǝ mbatl nǝm asi shilǝn nǝ Lya, ne' mudli yen nǝ Maliyamu dya ki Yesu, nǝ yelsǝni ki Yesu. ");
INSERT INTO zbu_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Age muttiyi Bitlus hillya gal adlom ki mil bǝtl Yesu kal (dopga ki mbalǝni kutl cen nǝm nǝ kutl lǝbi lop) ");
INSERT INTO zbu_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Kini “Yelsǝni ini mwani nǝ mudli, hwel kǝn tǝn njikǝn lwatbatu gunǝ Yal ki mbatl ki Lya shilǝni tu' bi ɗǝ Dauda teɗi tǝn Yahuza, gunǝ nde mi' gopti Yesu kina u. ");
INSERT INTO zbu_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Tima nǝmkǝni ge'mini teɗi gunǝ olti tǝppǝl kyautǝn ki Lya ne'mini u.” ");
INSERT INTO zbu_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Nǝ ulnǝs bǝlti ki bezǝn kyautǝnwasi, Yahuza ul lu ɗa; a kikǝn tǝ nda nǝ ga, i tugwas mbutli, i mus o'twas bena. ");
INSERT INTO zbu_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","I kowonngi a Ulushalima kumgu, iki is mbe lǝbisi nǝ biwasǝn Akaldama, iki, lu ki hwula.) ");
INSERT INTO zbu_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Bitlus usu, “Tǝn gaki ki laci ɗa ge' lwatbati ki Zabula: “ ‘Libi wasi nǝn dǝmti ko'ni, bǝ mulǝn dǝmgiɓiwai.’ ‘Naltwasi tǝ mulǝn akami.’ ” ");
INSERT INTO zbu_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Nǝguɗa, hwel kǝni tǝn ollǝn mulǝn age' mbalǝn i nǝ ne'mini u, mus cin u nǝ Mulban inǝn Yesu ɗǝ dǝp ne'mini u, ");
INSERT INTO zbu_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Gopi tǝn batisma unǝ Yahaya pǝli u, i mbǝl cin u nǝs kan Yesu ɗǝma'mini u. Hwel kǝni nǝm age' mbalǝn gi, ti' pǝl yenti nǝ dwaɗǝn ki hillya ki Yesu ge' mi'mǝshti, ne'mini.” ");
INSERT INTO zbu_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Is mbo' tohtǝn mbalǝn lop: Yusupu gunǝ si mbeti ki Balsaba (si mbeti ɗaɗanu ki Yustus) nǝ Matiyes. ");
INSERT INTO zbu_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Iki is shilǝn nǝ Lya, is usu, “Mulban inǝn ki mul ma' mbalt ki mus mbalǝn. Age' mbalǝn lopi mbokimi tohtǝn gunǝ' oltu, ");
INSERT INTO zbu_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","tǝ' dǝp mulshinkǝn ki kyautǝn gunǝ Yahuza zaki is zǝga ge'lu unǝ mbunnitu.” ");
INSERT INTO zbu_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Iki is pǝl olti, i ndatǝn Matiyes; i mbǝltǝn kutl nǝ nǝm mi. ");
INSERT INTO zbu_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nǝ cinkǝ penticos mbǝ u, kummwasǝn mi'kushti asi gelu kǝnǝmi. ");
INSERT INTO zbu_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sige nǝgu i kum otiluwon sullya, kǝnǝ mbǝ' ki bal yetǝl, i mbǝ i ikǝn libi u nǝ siki dǝmi giɓi u. ");
INSERT INTO zbu_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","I uliyen kǝnǝ lǝga ki bǝlǝn utu i bwasi tya tǝn gawasǝn. ");
INSERT INTO zbu_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kummwasǝn is ikǝn nǝ Yal ki batl ki Lya is gop shilǝn nǝ unndi biyen nǝ Yal ki batl ki Lya bǝlsi u. ");
INSERT INTO zbu_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Yahudawa yen ɗa mi' bǝtl zhil ki Musa, asi ki dǝmi a Ulushelima, nǝs pete'ge atlen ki dǝplǝɓa. ");
INSERT INTO zbu_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nǝs kum o'tilu u, i dopga ki mbalǝn mani, ilu hwodǝli, tǝngaki kowonngi ɗǝ kupsi asi shilǝn nǝ bishilǝnwasǝn. ");
INSERT INTO zbu_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Iki is kum gagashinti, asi usu, “Mi' Galili ɗǝ shilǝn u waiwa? ");
INSERT INTO zbu_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ya lakiɗa musinǝn mi kupsi ɗǝ shilǝn nǝ bi inǝn? ");
INSERT INTO zbu_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Mingu paltiyawani nǝ Madiyana nǝ Elamawa, mi' dǝp ki atl ki Bagadaza, nǝ ki Yahudiya nǝ ki Kapadokiya, nǝ ki Pantas nǝ ki Asiya, ");
INSERT INTO zbu_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","nǝ ki Pilijiya, nǝ ki Bampiliya, nǝ ki Masal, nǝ kuma yanki Kulane ki atl ki Libiya nǝ sǝmbǝlsi te' Loma, wato mi ginǝ zǝmi ge' bǝtl Lya ki Yahudawa, nǝ mbalǝnyi nǝ tege' bǝtl Lya undi ki Yahudawa u, ");
INSERT INTO zbu_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","nǝ Kalitawa nǝ Lalabawa, mus mi kupsi ɗǝ shilǝn ki bas lǝɓa ki Lya nǝ bi kige' gatlinǝn.” ");
INSERT INTO zbu_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Mus is kum gagashinti, is hwoɗǝli, is gop gyep yelsǝni, “Yakǝn ngu?” ");
INSERT INTO zbu_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","I gyen, ngayisi shilǝn is usu, “Mal ki innabi si tle iye.” ");
INSERT INTO zbu_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Iki i Bitlus hilya nǝ kutl nǝ nǝm mi, i' tlǝl Yal i' shilǝn nǝ diɓǝl mbalǝn, i' usu, “Yelsǝni ini Yahudawa nǝ mus mi' dǝp a Ulshelima, hwe ta pikin shilǝn u; gakǝn kǝm ki zeki tǝn ulnǝ ta dlǝmi u. ");
INSERT INTO zbu_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mbalǝn yi sǝ tle mal ki innabiwai, kan u nǝki zitini uwai, nǝgun dom ki nǝtapsi katl kinǝkyau! ");
INSERT INTO zbu_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Guki ulnǝ Joyel mul nje shinkǝn ki Lya shilǝn tǝnki u ti usu: ");
INSERT INTO zbu_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“ ‘Age pa'ti ki dǝp lǝɓa, Lya usu, anbine' mus mbalǝn Yal ki mbatl ki Lya suɗi. Millwakǝn mwani nǝ mudli sǝn shilǝnti nǝ ndǝtl ki Lya, tlu'ti nǝn mbi mil giɗǝnsiwakǝn, kolsiwakǝn sǝn tlu'ti. ");
INSERT INTO zbu_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nǝguɗa, ge' muttu zhelsi ini mwani nǝ mudli anbine'si Yal ki mbatl ki Lya suɗi sǝn shilǝnti nǝ ndǝtl ki Lya ɗaɗanu. ");
INSERT INTO zbu_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Anpǝli'si ulki gagashinti a lya, nǝ lwaɗi su'atli, iki hwula, nǝ utu, nǝ hillya ki cil. ");
INSERT INTO zbu_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kapǝn mbǝ ki Mulban balcin mul naltu, cin nǝ patl dǝpshal lyi nǝn patl hwula. ");
INSERT INTO zbu_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Age' cin u nǝn dǝmti mus mulnǝ mbe' shin ki Lya u tǝn mbi pe'ti.’ ” ");
INSERT INTO zbu_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Kini yelsǝni ini Isla'ilawa gakǝn kǝm tǝn shilǝn u: Yesu mul Nazalat gunǝ Lya kǝni ma'kini tu tǝn, pǝl ulki ki gagashinti, nǝ ulki ngaptibi nǝ lwaɗi, gunǝ Lya pǝli ge' kini tumati, gunǝn yeninini nǝ dwaɗǝwakǝn u. ");
INSERT INTO zbu_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Mul gu, Lya nǝ gawasi ti bǝlkinti a toh wakǝn nǝ kan u nǝs zi nǝ mantiwasi nǝ ndǝ'twasi, kini nǝ ɗǝlki mil bezǝn lǝɓa, ki tolinti tǝn gadlǝnnga i' tloti. ");
INSERT INTO zbu_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ngonǝ nǝgu i Lya tlǝlti ɗǝ ge' mi'mǝshti, tǝngaki mushti aman ngaptiwai. Lya tlǝlti ɗǝ ge' mi'mǝshti, tǝngaki mushti aman ngaptiwai. ");
INSERT INTO zbu_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dauda shilǝn tǝnti i' usu: “ ‘Ko gaswukǝni Mulban akina ini, ti tǝn toh shimtini, tǝn gaki ɓa wuni. ");
INSERT INTO zbu_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Tǝngaki nǝgu mbatlini ɗǝ hwoltugi, lǝga ini ɗǝ utl ulki hwoltugi, dli ini nǝn dǝmti nǝ lati mbatli, ");
INSERT INTO zbu_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","tǝngaki nǝgu tikǝn zati dli ini age zuɗiwai, ki kǝn zati mulguntwagi apɓoswai. ");
INSERT INTO zbu_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tǝn la'ti aman shitu ki mbadli. Tǝn ikǝntǝn nǝ hwoltugi akinawasi.’ ");
INSERT INTO zbu_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Yelsǝni ini Isla'ila, amma' pi'kin shilǝn bǝnǝ catl mbadlwai atǝn bwas ki bwasinǝn Dawuda. Dawuda ta mǝci, akupti. Zuɗiwasi ama'mini hal nǝguni. ");
INSERT INTO zbu_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Amma ti mul njeshinkǝn ki Lya kǝni timanini Lya apǝli' ndǝ'ti nǝ ndaltannaca, tǝn zǝ'nǝm ge' gǝswasi tǝn guntwasi. ");
INSERT INTO zbu_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tun teɗi Dawuda a yenini, i' shilǝni tǝn hillya ki Almasihu ɗǝ ge' mi' mǝshti, tǝkǝn zatiti age zuɗiwai, dliwas kǝn ɓostwai. ");
INSERT INTO zbu_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","I Lya tlilti Yesu ɗǝ ge mi' mǝshti, mussinǝn ɗaɗanu mi' yenti nǝ dwaɗǝn kǝni. ");
INSERT INTO zbu_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ngo nǝnǝgu a nalti tǝn tohship ki Lya i, ta nje Yal ki mbatl ki zoki mul gunti ma bwasi, kan u nǝppǝl ndǝ'ti, tin bina' Yal ki mbatl ki Lya tǝn ga inǝn, i mbǝl ulnǝ yenini u nǝ ulnǝ kumini u. ");
INSERT INTO zbu_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dawuda tolyawai, tinǝ gawasi, i' usu, “ ‘Mulban ul mulban isu, “dǝm a tohshimtini, ");
INSERT INTO zbu_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Sai nǝ ala' mi'ngeki agǝs asǝn wagi.” ’ ");
INSERT INTO zbu_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Tǝn gaki nǝgu, mus Isla'ila sǝnmanica Yesu u nǝ' tolti tǝn gadlǝnnga u, Lya apalti mulban nǝ Almasihu.” ");
INSERT INTO zbu_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nǝ mbalǝn kumi nǝgu u, i shilǝnisi tǝnisi mbadli, is ul Bitlus nǝ na mi'shinkǝn usu, “Yelsǝni, yakǝn tǝn pǝlini?” ");
INSERT INTO zbu_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","I Bitlus pisi, “Zakǝn pǝtl bezǝn lǝɓa a pǝlikin Batisma, kowonngi, ge' shinki Yesu Almasihu tǝn ti' paci kin bezǝn lǝɓawakǝnɗa. Kǝn mbi bǝlti ki Yal ki mbatl ki Lya ki zoki. ");
INSERT INTO zbu_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ndǝ'tu kini pǝli kini nǝ milwakǝn nǝ ginǝ lolu, nǝ mus ginǝ mulban Lya nǝn mbessibi u.” ");
INSERT INTO zbu_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Nǝ shilǝn mul diɓǝtl kǝn ti dǝlisi kǝm; i' matisi, “Pekǝlǝn gawakǝn ɗǝge' besǝn hwon ki nǝguni.” ");
INSERT INTO zbu_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ginǝ kum shilǝn u ipǝlisi Batisma, ge'cin u mbalǝn zangu maki mbǝltǝnsi. ");
INSERT INTO zbu_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Is ga'kǝm, tǝn kushti ki mi' shinkǝn ɗǝ pǝlti u, asi ma'ga nǝ yelsǝni, asi ɗamti gelu kǝnǝmi, asi shilǝn nǝ Lya. ");
INSERT INTO zbu_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Is kum ɓanti, nǝ ulki gagashin nǝ lwaɗi nǝ Lya pǝli ma mi' shinkǝn u. ");
INSERT INTO zbu_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Mus mi'bǝtl Yesu si ge'lu kǝnǝmi mus lǝɓawasǝn ge'lu kǝnǝmi. ");
INSERT INTO zbu_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Is ul lǝɓawasǝn taka nǝ nisiɗa u asi bwasi' yelsǝni wasǝn ulpisi ginǝ bǝnisi ɗawai u tǝn lyamtiwasǝn. ");
INSERT INTO zbu_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ko gasiwukǝni si dopga age' libi ki Lya nǝ mbatl nǝm. Asi ɗap ulki ɗami a libiwasǝn ge'lu kǝnǝmi, si ɗapti asi tleti nǝ hwoltugi, nǝ ndǝti ki mbatli. ");
INSERT INTO zbu_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Is dǝmshot si ngep Lya asi mbi hwol hwula ma mbalǝn. Ko cin u kǝni a Lya ɗǝ mbǝl diɓǝltwasǝn tǝnki ginǝs pe'tu. ");
INSERT INTO zbu_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Gasiwon Bitlus nǝ Yahaya silǝ' libi ki Lya cin ki shilǝn nǝ Lya, dom ki maki ki cin su'ti. ");
INSERT INTO zbu_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","I ki mulǝn kǝn ngu gunǝs zǝ'ti dakǝl, si mbǝtlti a bidlabi libi ki Lya guni ɗǝ mbe'ti zeki, alǝbi si zǝ'ti ko anǝmi ɗǝ ngeplu ma' ginǝ ɗǝ te'ge libi ki Lya u. ");
INSERT INTO zbu_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nǝ'yen ki Bitlus nǝ Yahaya u ɗǝ te' libi ki Lya u. I' ngemsi ɗǝ ulpi. ");
INSERT INTO zbu_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","I Bitlus utti' dwaɗǝn, isi Yahaya. I Bitlus usu, “Yami!” ");
INSERT INTO zbu_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","I mus i' ga'kisi kǝm, nǝ lati mbatli ki mbi ulǝn ma'si. ");
INSERT INTO zbu_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","I Bitlus usu, “Upɓo ni ɗawai, tǝn gaki nǝgu ulnǝ ni ɗa u ita bǝlki. Ge shinki Yesu ki Nazalat, ɗaki lǝ.” ");
INSERT INTO zbu_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","I ki i Bitlus ngap tohwasi ki tohshmti, i' tliltilya, nǝ dleuti asǝnwasi nǝ Yal asǝnwasi i ndǝli. ");
INSERT INTO zbu_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nǝ dleuti ippe'lya tǝn asǝnwasi i' gop lǝti. Illǝ libi ki Lya ne'si, ati lǝti nǝ pe'ti lya ɗǝ natl Lya. ");
INSERT INTO zbu_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nǝ mus mbalǝn yenti ɗǝ lǝti ati natl Lya u, ");
INSERT INTO zbu_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Is manti tikuɗǝ dǝb abidlabi libi ki Lya ɗǝ ngeplu, is ikǝn nǝ ulki ngaptibi nǝ ulki gagashinti atǝn ndo'twasi. ");
INSERT INTO zbu_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Amuli ɗǝ bǝtl ki Bitlus kal nǝ Yohanna, Mus mbalǝn mbǝ nǝ kitǝl ma'si age' libi ki Lya gunǝ si mbettikǝ lu shu'ti ki Sulemanu u, asi ngapti bi. ");
INSERT INTO zbu_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nǝ Bitlus yen gu u, i' ulsisu: “Yelsǝni ini Isla'ilawa, yalakiɗa ullu ɗǝ bǝtlkin ngaptibiɗa? Tǝngaki yakǝn ki ya'miɗa nǝgu, ki yenti ndǝltinǝn ko bǝtl Lya inǝn kǝn laki i mulu lǝ'ɗaya? ");
INSERT INTO zbu_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Lya ki Iblahim, nǝ Ishaku, nǝ Yakubu, Lya ki mi'zǝ mi'zǝ'mini, innal zheliwasi Yesu. I ngeti a kina ki Bilatus, nǝl lyami tǝs za'tu, gunǝ' bǝlǝnti is tloti. ");
INSERT INTO zbu_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","I' ngeti mulguntu nǝ zo'mbatlu i' ngemini sǝ' zakikin mul tlo mbalǝn u. ");
INSERT INTO zbu_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","I' tlo gǝs ki mbadli, iki i Lya tlǝlti ɗǝ ge' mi' mǝshti. Nǝgu mi yeni ndatǝn dwaɗǝn inǝn. ");
INSERT INTO zbu_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nǝ la'ti mbatl ge' shin ki Yesu, mulu nǝ' yenintu, nǝ' manǝntu, mulnǝ bǝlti ndǝltu tiki Yesu, nǝ la'ti mbatl nǝ shinwasi tu'mati tǝmbi ndokǝl ti mul gu nǝ muswakǝn ki yetti u. ");
INSERT INTO zbu_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Nǝgun, yelsǝnǝ ini Isla'ila amani ge' lǝshi ma' ulǝnkǝn ki tloti ɗa kan u nǝ mi'kina wakǝn pǝli u. ");
INSERT INTO zbu_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ngonǝ nǝgu Lya a ikǝn ulnǝ' dlǝmi tun te'ɗu abi ki mus mi'nje shikǝn ki Lya, ɗǝ usu Almasihu wasi tǝn tle' bǝna. ");
INSERT INTO zbu_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Zakǝn pǝtl bezǝn lǝɓa, a' palnitai ma Lya, tǝngaki tǝ' santikin bezǝn lǝɓawakǝnɗa, an ndǝllikin mbadli, ");
INSERT INTO zbu_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","i'shin Almasihu, gunǝ' olikini u tun te'ɗi, tiki Yesu. ");
INSERT INTO zbu_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Hwelkǝn tǝ Yesu dǝm twa lya hal gasi u nǝtǝ Lya patl mus usi pyale u, nǝ Lya dlǝl shilǝn tun te'ɗigi abi ɗǝ mi'nje shinkǝnwasu. ");
INSERT INTO zbu_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musa usu, ‘Mulban Lya wakǝn nǝn tlǝli' kin mul njeshinkǝn ki Lya won kǝnǝ ami age mbalǝn wakǝn; hwelkǝn ki gakǝn kǝm tǝn mus ulnǝ ti' pikini u ");
INSERT INTO zbu_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mulnǝ a nge gakitti kǝmu nǝn pe'kǝtlti ɗǝ ge' mbalǝnwasi.’ ");
INSERT INTO zbu_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Nǝguɗa, i gopi tun tǝn Sama'ila, i lǝtǝn ginǝ mbǝ kali is shilǝn tǝn mutti. ");
INSERT INTO zbu_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kini ki gǝskǝ mi'njeshinkǝn, kini ki mi'nje ndǝti nǝ Lya pǝli mi'zǝ'mi'zǝ'kini. I' ul Iblahim su, ‘Tu'ma'gǝs ki mbalǝn wa'kǝn mus mbalǝn mi'dǝp lǝɓa nǝn mbin nalti.’ ");
INSERT INTO zbu_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nǝ Lya a tlǝl zheli was suɗu, makini tishinti pa, tǝ zikin toh ki patl kowonngi tet taka ɗǝ tǝn shitu ki ɗashti ki tugi.” ");
INSERT INTO zbu_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Lǝɓasi, nǝ mi'kina ki ɓutti dlabi ki libi ki Lya nǝ Sadukiyawa is mbǝ ma' Bitlus nǝ Yahaya asi ge' shilǝn nǝ mbalǝn. ");
INSERT INTO zbu_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Is lyau mbadli nǝ mi' kushti ki Yesu tǝngaki si kulci' mbalǝn, tǝn hillya ki Yesu ge' mi' mǝshti. ");
INSERT INTO zbu_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Is gop ki Bitlus nǝ Yahaya is idlasi sai nǝ lu acili tǝngaki su' kǝn ɓali. ");
INSERT INTO zbu_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Amma ginǝ kum shilǝn ki Bitlus is ndǝ'nǝnali u; diɓǝltwasǝn sa tǝla zangu nantam. ");
INSERT INTO zbu_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Lu cilisi mi'kinawasǝn nǝ kolsiwasǝn nǝ mi'bǝtl lashti zhil ki Musa is ma a Ulshelima. ");
INSERT INTO zbu_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nǝ Hanana bal lǝɓa ki Lya ti alǝbi nǝ Kayapa nǝ Yahaya nǝ Iskandali nǝ mus gǝskǝ ki bali ki bas lǝɓasi ki Lya, ");
INSERT INTO zbu_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nǝs mbǝl ki Bitlus nǝ Yahaya akina u is gop ngepsi: “Nǝ ndǝltu kǝni ko nǝ shin u kǝn, ki pǝltin nǝgu?” ");
INSERT INTO zbu_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Bitlus, ki ikǝni nǝ Yal ki mbatl ki Lya, i' ulsisu: “Kini gumsisi nǝ kolsi! ");
INSERT INTO zbu_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ki takimibi asǝti tǝn ki ngepmǝnmi tǝn ze' ulnǝ pǝli dakǝl mulu nǝ tu' imi kǝnti ndoɗa, ");
INSERT INTO zbu_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","manǝnngu, kinǝ mus mbalǝn ki Isla'ila: Mul gu nǝ ki dlǝli kinawakǝn ki ndoki u nǝ shin ki Yesu almasihu Mulnazalat, gunǝ tolǝnti tǝn gadlǝnnga u guni Lya tlǝlti ɗǝ ge' mi'mǝshtu, ");
INSERT INTO zbu_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu tiki, “ ‘Zǝnnga gunǝ kini mi'kǝpbi nge u, iddǝm zǝnnga ki zoki ki kǝpbi.’ ");
INSERT INTO zbu_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Peti kǝn mbidli ma mulunwai, kuma shinwonɗawai guni bǝldli a lya nǝ atli nǝ ge' mbalǝn adǝplǝɓa hwel ma'ti tǝnmbi peti.” ");
INSERT INTO zbu_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nǝs yen ndǝtl ki mbatl ki Bitlus nǝ Yahaya u, is mani sa pǝl lashtiwai, mi'lǝshi usun kǝni ɗaɗanu, is kum ngaptibi is mansi mbalǝn gi teɗi ne' Yesu siɗa. ");
INSERT INTO zbu_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Amma nǝs yen mulnǝs ndokǝltu ki dlǝli nesi u, is hwol ulki dlǝmi. ");
INSERT INTO zbu_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ngo' nǝnǝgu is bǝlsi zhil ki sǝ'peki ɗǝ bidla nǝ sǝ'shilǝn nǝ yelsǝni u, ");
INSERT INTO zbu_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","is usu, “yakǝn tǝn pǝlin nǝ mbalǝnyi? Mus mi'dǝp a Ulshelima sǝ mani sa pǝlin ulki gagashinti, tu'imi kǝntǝn pǝlin nǝ mbalǝn i u mǝkǝn ma'ussu sa pǝl ulǝn wai. ");
INSERT INTO zbu_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Amma tǝngagi ɓa ulisi mbǝl du'tǝnki ge' mbalǝn, tǝn dǝlǝsi kǝm bǝs shilǝn nǝ mulin a ge' shin u nuwai.” ");
INSERT INTO zbu_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Iki is takisi bi te' ɗaɗanu is dǝlisi kǝm bǝs shilǝn ko kushti ge' shin ki Yesu nuwai. ");
INSERT INTO zbu_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Amma Bitlus nǝ Yahaya is pallisi shilǝn is usu, “Shilǝn ki Lya kǝn tǝn bǝliya ko gwakǝn? Dambǝlǝn kini. ");
INSERT INTO zbu_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Miɓo, mǝkǝn ma'dǝb shot tǝn ulnǝn yeni u nǝ ulnǝn kumi uwai.” ");
INSERT INTO zbu_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kal ki samatisi i, is za'si, tǝngaki sahwol kan u nǝ si'hwotisi ishɗa u i tǝngaki mbalǝn, mus malǝn si natl Lya tǝngaki ulnǝ nda u. ");
INSERT INTO zbu_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mul gu nǝ pǝli' ulki gagashinti ki ndokǝltu ta bǝl hwon kutl lǝbi upsi kali. ");
INSERT INTO zbu_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nǝs za'ki Bitlus nǝ Yahaya u, is lǝma' mbalǝnwasǝn, is palisi shilǝn u nǝ lǝɓasi ne' mi'kina pisi u. ");
INSERT INTO zbu_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Si ɗaɗanu nǝ kumti nǝgu, is tlǝl yali musswasǝn nǝ mbatl nǝm asi shilǝn nǝ Lya, is usu, “Lya mulnalti,” ki pǝl lya nǝ atli nǝ bal mali, nǝ mus ulnǝ giɓi u. ");
INSERT INTO zbu_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ki shilǝn tu'ma' Yal ki mbatl ki Lya nǝ tubi ki zheliwagi, bwasinǝn Dauda “ ‘Yalakiɗa ginǝ bǝ Yahudawawai u imbatl lewisi? Mbalǝn ɗaɗanu is dambǝl ulnǝ ɗa baliwai u? ");
INSERT INTO zbu_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Gumsi ki dǝp lǝɓa is kǝndǝ gǝski dlati, Mi'kǝndǝdlom is maga, is nge Lya, nǝ Almasihuwasi ɗaɗanu.’ ");
INSERT INTO zbu_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Bali nǝguɗa Hilidus nǝ Buntus Bilatus sa maga i age' gatlu ne' ginǝ ba Yahudawai u nǝ mbalǝn ki Isla'ila si dutu' nǝ Yesu zheli wagi mul guunti, gunǝ' palti Almasihu u. ");
INSERT INTO zbu_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Sa domga i tǝngaki sǝppǝl mus ulnǝ kǝndǝ tǝn ndǝltwagi nǝ lyamtiwagi tǝnda u. ");
INSERT INTO zbu_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nǝguni, Lya, yani si lyap hane'mi kyautǝn, bǝtl zhelisiwagi ndǝtl ki mbadli ki dlǝp shilǝnwagi nǝ ndǝtl ki mbatli, ");
INSERT INTO zbu_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ta' tohwagi ki ndokǝtl mbalǝn, apǝl ulki gagashinti nǝ lwaɗi tu'ma' shinki zheliwagi guu Yesu.” ");
INSERT INTO zbu_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kalki sa shilǝn nǝ Lya i, lu u nǝs domga u igo' nyapti. I mus is ikǝnsi nǝ Yal ki mbatl ki Lya, is gop dlǝp shilǝn ki Lya bǝ nǝ ɓantwai. ");
INSERT INTO zbu_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Mus dopga ginǝ ɗǝ duk nǝ Yesu u, ko yangiwasǝn nǝm kǝnǝ, mbadlwasǝn nǝm, mulǝn ɗa tǝ' usu ulkǝ tohwasi gwaskǝn nǝ gwaswai, koyangni mus gwasǝn kǝni. ");
INSERT INTO zbu_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","I mi'shinkǝn ndakina nǝ dlǝmi'mbalǝn ɗaɗanu tǝnpatl ki Yesu kami ndǝ'ti ki shilǝn mul ndǝlti tǝn hillya ki mulban Yesu ge' mi'mǝshti. Ulkǝ zo'ki mul nalti tǝn kowon ngi ge'si, ");
INSERT INTO zbu_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","hal ma mul hwol ulǝn ɗa ge'siwai, tǝngaki mus mi'gu ko libi sa ulitaka i, is mbǝl ulpisi, ");
INSERT INTO zbu_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","is zi' akina ɗǝ mi'shikǝn, i bwasi kowonngi nda'ce nǝ ulkipǝliwasi. ");
INSERT INTO zbu_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Age nǝgu iki Yusupu, mul Balawiye, gǝswasi mul ki tsibilin Kublus, gunǝ mi'shinkǝn ɗǝ mbetti ki Balnaba, (ikǝ mul ndǝtl mbadli), ");
INSERT INTO zbu_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","i' ul guwastaka, immbǝl ulpisi i'zi akina ɗǝ mi'shikǝn. ");
INSERT INTO zbu_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Amma mulǝn mul shin Hananiya, nǝ kǝliwasi Sapilatu, i' ul ulǝn ginǝ nidɗa u taka. ");
INSERT INTO zbu_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Isǝ' kǝliwasi is hwundǝl nami age' ulpisi, iki is mbǝl na ulpisi akina ɗǝ milshinkǝn. ");
INSERT INTO zbu_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","I Bitlus usu, “Ki, Hananiya, tu' imi kǝn Shaiɗa ikkǝn mbatlwagi, hal i lǝge Yal ki mbatl ki Lya, i' hwundǝl na up ki gu wa'ɗa? ");
INSERT INTO zbu_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nǝ'uli taka u ɓo gu i ɓo gwa'kǝn waiya? Kal ki ka uli taka i ɗaɗanu, ulpisi gwakǝn waya? Yalaki i' dambǝlki i' pǝl unndi uluɗa? Mbalǝn kǝn ki ligesiwai Lya kǝn ki ligeti.” ");
INSERT INTO zbu_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nǝ Hananiya kum gu u, i' nda atli alǝbi alǝbi immǝci. Mus ginǝ kumi u, i bal ɓa' gopsi. ");
INSERT INTO zbu_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","I giɗǝnsiyen tlǝte'ɗi, is kan hwuni is lati ge' lumutti is gadǝlti, is kanti is pekǝlti taka, is le' guti. ");
INSERT INTO zbu_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kal ki cimbǝlti ki dom maki i kǝliwasi teteɗi, bǝnǝ ma' ulnǝ nda uwai. ");
INSERT INTO zbu_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","I Bitlus ul kǝli su, “Dlǝmini, nǝgu ki ulǝn gu u takawa?” Iki i' usu, “e nǝguni.” ");
INSERT INTO zbu_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","I Bitlus ultisu, “Tu' imi kǝn ki manǝn bi ki cimbǝlǝn Yal ki mbatl ki mulban ɗa? Kum lǝ' ki ginǝ gwu' mwaniwagu, hal sambǝci dlabi i, sǝn ka'ki, as pe'nǝ hwunwagi.” ");
INSERT INTO zbu_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Alǝbi alǝbi in nda a kinawasi immǝci. Nǝ milgiɗǝsi i teteɗu, is mbiti mǝci, is kanti is pekǝlti taka, is guti ma'mwaniwasi. ");
INSERT INTO zbu_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Iki i bal ɓa' gop Ikilisiya musswasǝn, nǝ mus ginǝ kum shilǝn ki usi nǝ nda u. ");
INSERT INTO zbu_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Milshikǝn pǝl lwaɗi nǝ ulki gagashinti mul diɓǝlti age' mbalǝn. Mi'bǝtl Yesu kal musswasǝn nǝ mbatl nǝm kǝn si mati age lu shu'ti ki Sulemanu. ");
INSERT INTO zbu_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Amma age' na mbalǝn gon apǝl ndǝtl ki mbatl ki te' ge'siwai, ngonǝnǝgu mbalǝn ɗǝ natlsi. ");
INSERT INTO zbu_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Mus nǝnǝgu mi' ndǝ'ti nǝti mwani nǝ mudli mbǝtltin ki siɗa ngǝtl ki kali. ");
INSERT INTO zbu_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Hal atala gunǝ si pekǝtl mi'gonti tǝn bishitu ɗǝ latisi tǝn lumutti ki dom nǝ lumutti tǝngaki Bitlus ɓal ɓeutu ko gwasǝnwas ma abǝli tǝn nami wasǝn. ");
INSERT INTO zbu_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Mbalǝn ɓo is gop dopga te'ge' gatlen nǝ ki gandǝli nǝ Ulshelima u, is gop mbǝtl mi'gonti nǝ ginǝ dumi'gatdli ɗǝ hwottisi u, musswasǝn is ndoki. ");
INSERT INTO zbu_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Iki i bal lǝɓa ki Lya tlǝte' lya, nǝ musginǝ ne'tu, nǝ mi' ɗalika ki Sadukiyawa, si kub dutu' iye, ");
INSERT INTO zbu_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","is gop milshinkǝn yi, is la'si gelu kǝndǝ'mbalǝn. ");
INSERT INTO zbu_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Amma age' gasi iki mul nje shinkǝn ki Lya kǝn ngu i' ɓub'ɓul dlabi ki lu kǝndǝ' mbalinisi, i' pekǝlsi toɗi, i' ulsisu, ");
INSERT INTO zbu_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Zǝn ga, a' dlǝlni age' libi ki Lya, adlǝmi mus mbalǝn pyal shitu ki Lya.” ");
INSERT INTO zbu_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nǝs kumi nǝgu u, is tege' libi ki Lya nǝ kyau, is go' kulci mbalǝn. Nǝ bal lǝɓa ki Lya ne' ginǝ si ne'tu mbǝ u, is taki mi' dlǝl shilǝn bi, nǝ mus mi'kina ki Isla'ilawa, is ta shinkǝn tya ge'lu kǝndǝ'mbalǝn sǝm mbǝlsi. ");
INSERT INTO zbu_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Amma nǝ mi' kǝnndǝ dlom mbǝkǝci ge'lu kǝndǝ'mbalǝn nisi u, sa mbisi lǝbiwai. Iki is palteɗi' is palsi shinkǝn, ");
INSERT INTO zbu_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Illǝ illembi lu kǝndǝ'mbalǝn nisi ki idle, mi' ɓutti dlabi sikǝ dlili abi dlabi, amma nǝn ɓuli u, ma mbi mulǝn agiɓiwai.” ");
INSERT INTO zbu_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nǝ mi' kina ki ɓutti dlabi ki libi ki Lya nǝ bas laɓasi nǝs kumi nǝgu u, is hwodǝli iye tǝn gawasǝn, yakǝn tǝ ulu mbǝlli. ");
INSERT INTO zbu_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Iki i' mulǝn mbǝ i' usu, “Yanini! Mulu nǝ' lakǝnti gelu kǝndǝ'mbalǝn u si ngi ki dlǝli a libi ki Lya, si kulci' mbalǝn.” ");
INSERT INTO zbu_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Iki i mul kina ki mi'kǝndǝ'dlom nǝ mil kyautǝn wasi is lǝ is mbǝl milshikǝn nisi. Sa shimsi nǝ ngeswai gaki si ɓulti ɓa mbalǝn la'si nǝ zǝnnga. ");
INSERT INTO zbu_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nǝs mbǝl milshinkǝn isi abidla shilǝn u, is dlǝlsi akina ɗǝ mi' dlǝlshilǝn. Iki i bal lǝɓa ngemsi, ");
INSERT INTO zbu_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","i' usu, “Ma ndǝlinkin kǝm bǝ kulcin ge' shin u waiwa, in ngu kushtiwakǝn a dutya Ulshelima i, hal kilyamti ki zimi alhaki ki hwula ki mulu aga inǝn.” ");
INSERT INTO zbu_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","I Bitlus ne' mi'kina is pallisi is usu, “Hwelkǝn tǝn kumi Lya bi ngǝtl mbalǝn. ");
INSERT INTO zbu_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Lya ki kolsisi inǝn ta tlǝl Yesu i, gunǝ tǝn gadlǝnnga ki tlwotu. ");
INSERT INTO zbu_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ti Lya nalti a toh shimtwasi, mul kina nǝ mul pe'kǝtl mbalǝn, tǝngaki tǝ' ɓuli Isla'ila dlabi ki pe'ti ɗǝ ge bezǝn lǝɓa i, as mbi pashti ki bezǝn lǝɓawasǝn ɗa ɗaɗanu. ");
INSERT INTO zbu_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Mi ɓo mi'yenti nǝ dwuɗǝnwas kǝni atǝn usi, nǝgu ɗaɗanu Yal ki mbatl ki Lya, gunǝ Lya bǝl ginǝ ɗǝ pǝlitti kubbi u.” ");
INSERT INTO zbu_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nǝs kumi nǝgu u, iki i mbatl lyewisi iye, asi lyamti kǝnǝ sǝ' tlosi. ");
INSERT INTO zbu_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Amma mul Palise won mul shin Gamaliyal, mul kushti zhil ki Musa, gunǝ mus mbalǝn ɗǝ natlti, i' hilya age' ludlǝtl shilǝn, ibbǝl zhil ki sǝ' pyakǝl mbalǝnisi swadla pa. ");
INSERT INTO zbu_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Aki kǝn tǝ usu, “Kini mil Isla'ilawa, pǝn ɗemɗem tǝn ulnǝ ki lyamti ki' pǝli mbalǝn gi u. ");
INSERT INTO zbu_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Hwon u nǝ ɓew u i mulun mbǝ, kise ti Tudas, ti patl gawasi ulǝn, mbalǝn kutl cen kutl lǝbi upsi ɗǝ bǝtlti, amma i tloti, i mi' bǝtlti dla'ga, is koni. ");
INSERT INTO zbu_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kalwasi ɗaɗanu, imulǝn mul Galili mul shin Yahuza mbǝ age' hwon ki ɓǝtl mbalǝn, illa diɓǝl mbalǝn ɗǝ bǝtlti. Tima is tloti, mil bǝtlti mus is dla'ga. ");
INSERT INTO zbu_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Tǝngaki nǝgu, ulu tǝn ki ami pi'kin shilǝn, zakǝn mbalǝn sǝ zǝga, in ulnǝ si lyap pǝlti u ko kyautǝn wasǝn ki mbalǝn u, nǝn dlatiga. ");
INSERT INTO zbu_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Amma in ki Lya kǝn u, kikǝn ma'dlǝl mbalǝn iwai. Seko ki' dǝmni mi'nge'ulnǝ Lya pǝli u.” ");
INSERT INTO zbu_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Iki is bǝlshilǝn ki Gamaliyal, is taki milshinkǝn nisi bi is te' giɓi is li'si. Is matisi bǝs saka shilǝn ge' shin ki Yesu u nuwai, is za'si is zǝga. ");
INSERT INTO zbu_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","I' milshinkǝn nisi hilya is peki a kina ki mi'dlǝlshilǝn, nǝ hol tugi tǝngaki sayeni i sakǝmi sǝ' tle bǝna tǝngaki shin ki Yesu i. ");
INSERT INTO zbu_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Hu cin u kǝni, a libi ki Lya nǝ a libi nǝ libi, saza' kulci' mbalǝn shilǝn ki Lya wai, si ussu Yesu tiki Almasihu. ");
INSERT INTO zbu_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","A ge' muttu nǝ mi'kushti ɗǝ mbǝtltǝnki u, iki Yahudawa mi' kup Helinanci is gob nalǝn tǝn Iblaniyawa tǝngaki sǝɗa bǝtl mudli ginǝ mwani mǝcisi u ulki ɗami wai, kǝnǝ ngen wai, a ge' lu bwasti ulki ɗami ki ko cin u kǝni. ");
INSERT INTO zbu_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Iki kutl nǝ lopi is taki mus mbalǝn mi'bǝtl Yesu kal bi, is usu, “Ambuni, tǝnza' dlǝb shilǝn ki Lya wai tǝndǝm tǝn shilǝn ki ulki ɗami katla wai. ");
INSERT INTO zbu_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yelsǝni mwani nǝ mudli, olǝn mbalǝn nǝnngi a ge' kini ginǝ' manǝnsi u sǝkǝ njikǝn nǝ Yal ki batl ki Lya nǝ ma' ulǝn, ginǝ tǝn bǝlǝnsi kyautǝn u. ");
INSERT INTO zbu_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Mini an bǝlǝn mba dlinǝn tǝn shilǝn nǝ Lya nǝ kushti shilǝn ki Yesu.” ");
INSERT INTO zbu_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ulnǝs dlǝmi u i mus tǝmi mbalǝn bi, iki is ol Istipanus, mulnǝ ki ikǝni nǝ la'ti mbatl u nǝ Yal ki mbatl ki Lya mul gunti nǝ Pilibus, nǝ Bulokolas, nǝ Nikanal, nǝ Timan, nǝ Balminas, nǝ Nikolas mulkǝ Antakiya gunǝ teɗǝ ittege' atdini ki Yahudawa u. ");
INSERT INTO zbu_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Gi kǝn si mbǝlsi kina ki milshinkǝn. Kal ki sa shilǝn nǝ Lya i, is zisi toh. ");
INSERT INTO zbu_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Shilǝn ki Lya mbǝl tǝnki ɗa, dǝɓǝtl ki mi'bǝtl Lya ge' gatl ki Ulshelima mbǝtl tinki ɗa iye, lǝɓasi mi'diɓǝlti iye is ndǝ nǝ la'ti mbadl tǝn Yesu. ");
INSERT INTO zbu_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Lya bǝl Istapanus, ze'lǝɓa wasi nǝ ndǝlti, ki pǝl ulki gagashinti mul nalti nǝ lwaɗi a ge' mbalǝn. ");
INSERT INTO zbu_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","I genge' ginǝ pe'to' ge' ginǝ mbi gawsǝn. Sǝ pe'to' ge' gatl ki Yahudawa ki Sayilin nǝ Aleszandaliya, nǝ atl ki Silisiya nǝ Asiya, is gob shotibi ne' Istipanas, ");
INSERT INTO zbu_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Amma ko ten sa mbǝ'ci sǝ'sho' bi ne'twai tǝngaki ta pǝl shilǝn nǝ mallǝɓa i, nǝ Yal ki mbatl ki Lya ɗǝ dlotiti. ");
INSERT INTO zbu_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Is hom mbalǝn ki hwundǝli, si usu, “Mǝ kumi Istipanus ɗǝ byatl' Musa ati konnǝ shinkǝ Lya.” ");
INSERT INTO zbu_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nǝnǝgu is tlǝli mbalǝn mbadli nǝ kolsi, nǝ mi'bǝtl lashti zhil ki Musa, sine is nde' ga, is gopti, is mbǝlti a kina ɗǝ mi' dlǝtl shilǝn. ");
INSERT INTO zbu_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Iki is mbǝl mi' dlǝb ulnǝ bǝ sayeniwai u, is usu, “Mulu tǝɗa bwastiti nǝ dlǝp du shilǝn tǝn libi ki Lya u wai, nǝ kushti ki Musa, ");
INSERT INTO zbu_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","tǝn gaki mǝ kum Istipanus ti ussu Yesu mulnazalat nǝn batti lu u, at shot ulnǝ Musa zaki mini u.” ");
INSERT INTO zbu_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","I mus mbalǝn ki bidla i is uti' Istipanus dwaɗǝn, is yen kinawasi kǝnǝ ki mul shinkǝn ki Lya. ");
INSERT INTO zbu_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","I bal lǝɓa ki Lya ngem Istipanas, “Gu nǝgu ɗaya?” ");
INSERT INTO zbu_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Istipanas usu: “Yelsǝni ini nǝ mi'kina, gaki nǝn kǝm. Lya mul nalti i' mbǝlgawasi ma' mul zǝmini Iblahim, age muttu nǝ ti a Bagadaza u, bǝ ta dǝm a Halan uwai, ");
INSERT INTO zbu_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","i' Lya ultisu, ‘Hilya ɗǝ ge' atlwakǝn, nǝ ɗǝge' yelsǝniwagi, ki lǝge' atlu nǝ ta mboki toh tǝnki u.’ ");
INSERT INTO zbu_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Iki i' hilya ɗǝ ge' atl ki Kaldiyawa, i' dǝm a Halam. Tyaka ɗaɗanu, kal ki mǝshti ki bwasi, i Lya bǝlti atlu nǝ nǝgun kini ki dǝmi alǝbi u. ");
INSERT INTO zbu_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Amma Lya a bǝlti, na' atl ko ki zi' asǝn wai aki, iki i Lya pǝlli' ndǝti ge' kalwasi tǝn bǝtlti atlisi ɗǝ gwasi, ge' cinisi amma Ibilahim yakǝn ni' ɗawai. ");
INSERT INTO zbu_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","I Lya shilǝn nǝ Ibilahim: ‘Gǝswasi sǝn dǝmti sǝmbǝlsi ge' gatlu nǝ bǝ gwasǝn kǝn wai u, mbalǝn kige' gatli nǝn patlsi zheli as hwotisi bǝna hal hwon kutl cetl upsi.’ ");
INSERT INTO zbu_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","I Lya usu, ‘amma an hwoti atlu nǝ palkin zhelu u bezǝn lǝɓa,’ kalki nǝgu sǝn pe'ti ɗǝ ge' gatlu as nallǝn agelu u.’ ");
INSERT INTO zbu_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ta pǝli Ibilahim ndǝti ki sǝlkǝn. Nǝ Ibilahim zǝ' Ishayaku u mutti usǝpsi nǝ zǝ'ti is sǝlti. I Ishiyaku zǝ' Yakubu, i Yakubu zǝ mi'zǝ'mini kutl nǝ lopi. ");
INSERT INTO zbu_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Mi'zǝ'miniyi ne, tǝngaki si dutugi nǝ Yusupu, is ulti taka, i talati Masal. Amma Lya nǝ ti, ");
INSERT INTO zbu_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","i Lya pe'kǝlti ɗǝ ge' mus bǝnawasi. I' bǝl Yusupu ma'lǝɓa nǝ hwol hwula ma pil'auna Gu ki Masal. Ti Pil'auna ne i' palti mul gunti ki Masal, i kan mus mbalǝn ki libiwasi. ");
INSERT INTO zbu_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Iki, i kuzǝn nde mus atl ki Masal nǝ Kan'ana, tǝngaki bezǝn bǝna u, hal mi'zǝ' mi'zǝ'mini is hol ulki ɗami. ");
INSERT INTO zbu_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Amma nǝ Yakubu kumi alkama ɗa a Masal u, lǝ'ki nǝn i' shin mi'zǝ' mi'zǝmini. ");
INSERT INTO zbu_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ɗǝ lǝtwasǝn ki lop, i Yusupu ɓulisi gawasi ma' yelsǝnwasi, i Pil'auna man mbalǝn ki Yusupu. ");
INSERT INTO zbu_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Iki i Yusupu shinshinkǝn tǝn Yakubu bwasi tǝn mbǝ, nǝ mus yelsǝniwasi, mbalǝn kutl kutl lǝbi ningi nǝ namtam. ");
INSERT INTO zbu_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Iki i Yakubu lǝ Masal. Ti ne' mi'zǝ' mi'zǝmini a tya ka si mǝci. ");
INSERT INTO zbu_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Iki is yem hwun wasǝn te'ɗi is palsi tya Shekem, i la'si ge zǝɗi u nǝ Iblahim uli nǝ upki azulpa ama' mil ki Hamol aki a Shekem. ");
INSERT INTO zbu_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Nǝ cin ɓalli Lya nja tǝ' ikǝni Iblahim pǝtl ndǝtwasu, dǝbǝtl ki mbalǝn nisi a Masal a mbǝltǝnkiyi iye. ");
INSERT INTO zbu_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","I ki i pǝl pyal guu won a Masal, gunǝ bǝ'man wokǝn ki Yusupu wai u.’ ");
INSERT INTO zbu_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Guu u ta tlǝ dlǝ' mbalǝnyinǝn i', ati hwoti' mi'zǝmini ishi ati la'tisi sǝ' la' hwal mil gunǝ zǝsi u taka. ");
INSERT INTO zbu_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Age' muttisi sǝ zǝ Musa, yakǝni mbunini. Lii maki a ɗǝ ngaptiti a libi ɗǝ bwasi. ");
INSERT INTO zbu_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nǝ zǝti a dla u, yakǝn ki Pil'auna yakǝnkǝli it kanti it kyetǝlti kǝni yakuwasi. ");
INSERT INTO zbu_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Iki i kulci Musa mus ma' lǝɓa ki Masalawa, ti kuma mul ndǝtl kǝni age' shilǝn nǝ kautǝnwasi. ");
INSERT INTO zbu_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Nǝ Musa pǝl hwon kutl lǝbi upsi u, i' kǝndi a mbatlwasi tǝ le' ya mbalǝnwasi, Isla'ilawa. ");
INSERT INTO zbu_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nǝ' eni si hwoti yelsewas ishu, iki illǝ ɗǝ dǝtlti i' li' mul masali im mǝci. ");
INSERT INTO zbu_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa ɗǝ ziti mbalǝnwas mani tu mati tǝ Lya pǝl kautǝn ki pekǝtlsi, amma sima niwai. ");
INSERT INTO zbu_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Lu cili nǝ Musa mbǝ ma'lu u nǝ mi' Isla'ilawa lop ɗǝ dlatu. Il lyami tǝ masi tǝn shitu ki ussu, ‘Kini mbalǝn kǝnǝmini yalaki ki lyap kumi' yelsǝni ciwo ɗa?’ ");
INSERT INTO zbu_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Amma mulnǝ kumi yelsewas ciwo u i' jakǝn Musa i' ussu, ‘Wokǝn laki ɗǝ gunti nǝ pǝtl shilǝn tǝnmi? ");
INSERT INTO zbu_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Lyamti kiɗa ki tloni kǝnǝ gunǝ tlo mulmasal a hwuɗwa?’ ");
INSERT INTO zbu_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nǝ Musa kumi nǝgu u, i' kitǝli ippǝl dǝpki sǝmbǝl tya Madayana, ge'lu u tǝ zǝ mil mwani lop. ");
INSERT INTO zbu_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Kalki hwon kutl kutl lǝbi upsi, i mul nje shinkǝn ki Lya mbǝ ma Musa ge bǝlǝn utu, ge dǝlgǝn nja nǝ zǝnga Sinai. ");
INSERT INTO zbu_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nǝ Musa yen gu u, i' kum gagashinti nǝ unnǝ yeni u. Nǝ' sha'tya ɗǝ yati u, i' kum yalki Lya ɗǝ usu, ");
INSERT INTO zbu_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ami ki Lya ki mul zǝ' mulzǝ' ki, Lya ki Iblahim nǝ Ishayaku nǝ Yakubu.’ Iki i dli ki Musa gop nyapti, ta pǝtl ndǝtl ki mbatl ki yatiwai. ");
INSERT INTO zbu_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Iki i' Lya ultisu, ‘Tus kapptilanwagi lu u nǝ kiɗa ki dlǝli u, lu mul gu'kǝni. ");
INSERT INTO zbu_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Balini, a en bezǝn lǝɓa u nǝ si pǝli' mbalǝn i'ni ki Masal u i, a kum kuluwasǝn i ki kup dli, a pe'sul lya i tǝngaki ta pekǝlsi. Nǝguni, mbǝ ta shinki tya Masal.’ ");
INSERT INTO zbu_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ti Musa u nǝs ngetu asi ussu, ‘Okǝn laki ɗǝ mul kina inǝn nǝ mul pǝtl shilǝn?’ Ti Lya nǝ gawaskǝn shinti suɗi tǝ dǝm mul kina, nǝ mul pekǝtl mbalǝn, tuma' mul shikǝn ki Lya u nǝ mbǝ mati age dǝlgǝn ge' bǝlǝn utu. ");
INSERT INTO zbu_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ti pekǝlsi ɗǝ Masal, kalki pǝtl ulki gagashinti nǝ lwaɗi a ge' atl ki Masal, nǝ ɗakǝshti gǝu dlǝlka, nǝ hwon kutl kutl lǝbi upsi a ge dǝlgǝn. ");
INSERT INTO zbu_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Guki Musa u nǝ ul Isla'ilawa usu, ‘Lya nǝn tlǝli'kin mul nje' shinkǝn ki Lya ge' yelsǝniwakǝn kǝni ami.’ ");
INSERT INTO zbu_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ti ne'kini u age dǝlgǝn, nǝ mul nje shinkǝn ki Lya u nǝ shilǝn nǝti, tǝn zǝnnga Sinai u, ne' mi'zǝ'mi'zǝ'mini ɗaɗanu. Ti kan shilǝn mul bǝtl mbatli summa Lya im mbǝlli mini. ");
INSERT INTO zbu_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Amma mi'zǝmi'zǝmini nge bǝli'ti, is ngeti i mbatlwasǝn pal tya Masal. ");
INSERT INTO zbu_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Is ul Haluna usu, ‘Pǝlimi lya gunǝ tǝn ndemi kina u. Tǝn gaki Musa u, nǝ' pekǝlmi te' Masal u, mǝman unnǝ ndanǝtiwuwai.’ ");
INSERT INTO zbu_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Age' cinisi iki is kǝn yakǝn tla. Is mbǝli' haɗaya is pǝl hwoltuki nǝ kautǝn u nǝs pǝli nǝ tohwasǝn u. ");
INSERT INTO zbu_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tǝngaki nǝ gu i Lya bǝlsi kal, is zasi ɗǝ bǝtl cin nǝ lyi nǝ cadlǝl. Kan u nǝɗa ki laci ge' lwat bati ki mi'njeshinkǝn ki Lya u, i' usu, “ ‘Kini Mbalǝn ki Isla'ila ami ki mbǝllinǝn haɗaya ki tlu ki ban hwon kutl kutl lǝbǝ upsi ge' dǝlgǝnya? ");
INSERT INTO zbu_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ai, du'ni nǝ kǝs ki Molek nǝ lwa' cadlǝl ki Lapan, lya unǝ pǝlini aki ngepti u. Ami ne am patlkin tya kina ɗǝ Babila.’ ");
INSERT INTO zbu_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Mi'zǝmi'zǝmini si nǝ libi ki Lya amasi age' dǝlgǝn. Gunǝ pǝltli kan u nǝ Lya pi Musa u, kǝnǝ kan u nǝ' eni u. ");
INSERT INTO zbu_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kal ki nje libi ki Lya, mi'zǝmi'zǝmini mbi is mbǝ nǝnali ge' atlu ge' hwon ki Joshuwa, kalki sa kan atlisi i mbalǝn ginǝ Lya katsi tǝn duwaɗǝnwasǝn u. Libi ki Lya u ɗa i mbǝl hwon ki Dawuda, ");
INSERT INTO zbu_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","gunǝ mbi holhwula ma' Lya u i' gyemi tǝ pǝlli Lya ki Yakubu libi. ");
INSERT INTO zbu_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Amma Sulemanu kǝn kǝni' libi nisi. ");
INSERT INTO zbu_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Mus nǝ nǝgu mul nalti tǝn ɗa dǝp ge' libi i nǝ yakǝn mbalǝn kǝni nǝ tohwai. Kan u nǝ mul nje shikǝn ki Lya dlǝmi u: ");
INSERT INTO zbu_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Lya usu, “ ‘Twa lya kǝn ki lu dǝptini ki guntini, a atl kǝn ki luzǝ' asǝn ini. Unndi libi u kǝn ki kǝninǝni? Ko kuma awu kǝn ki lushutini? ");
INSERT INTO zbu_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ami nǝ gayikǝn a pǝl usi wai ya?’ ");
INSERT INTO zbu_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Kini mbalǝn mil ndǝtl ki ga, nǝ ndǝtl ki kǝm. Kǝnǝ mi'zǝmi'zǝkini kini ɗa: ko anǝmi ki pǝli Yal ki mbatl ki Lya natl ki ga. ");
INSERT INTO zbu_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Age' mi' nje shinkǝn ki Lya gukǝn mi'zǝmi'zǝkini a hwotisi bezǝn lǝbawai? Kuma is tlo ginǝ dlǝm shilǝn atǝn mbǝ ki mul ze' mbatlu, nǝ ngeti i tloti, ");
INSERT INTO zbu_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","kini kamǝn zhil ma' mi' shinkǝn ki Lya, amma ka bǝliniwai.” ");
INSERT INTO zbu_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nǝ mil dlǝl shilǝn kumi nǝgu u, is kum du tuki hal is ash bi ki hwoɗi tǝn gaki kup du tugi tǝnti. ");
INSERT INTO zbu_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Amma Istipanus, ki ikǝni nǝ Yal ki mbatl ki Lya ki gunti, i ut duwa ɗǝn twa lya, i' en natl ki Lya, a Yesu ki dlǝli tǝn toh shipti ki Lya. ");
INSERT INTO zbu_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","I' usu, “Yanini, a en lya ki ɓuliyi yakǝn mbalǝn ki dlǝli atǝn tohship ki Lya.” ");
INSERT INTO zbu_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Amma is ca kǝmwasǝn, is tlǝl yali, is nde ga nǝ mbatl nǝm, ");
INSERT INTO zbu_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","is pekǝlti tya kal gatli is gop lalati nǝ zǝnga. Kuma, mil enti nǝ dwaɗǝn is zi lulutuwasǝn ma yakǝn giɗǝn siwon shinwasi Shawulu. ");
INSERT INTO zbu_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Asi lalatiti nǝ zǝnga, a Istipanus ɗǝ shilǝn nǝ Lya, “Mulban Yesu, kan mbadlini.” ");
INSERT INTO zbu_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Iki i' ngus nǝ ga hwulǝn i' tlil Yal nǝ dǝlti, i' usu, “Mul ban, bǝ zisi bezǝn lǝɓa u agawasǝnwai.” Nǝ usu nǝgu u, i' nde yenmbuɗi. ");
INSERT INTO zbu_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Shawulu ɗǝ bǝtlkal ki tlo' istipanus. Agasisi, i bal bǝna mbi Ikilisiya ki Ulshelima mus is dla'ga tyage' atl ki Yahudiya nǝ Samaliya, sai milshikǝn kǝn katl. ");
INSERT INTO zbu_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","I mi'bǝtl Lya kalen gu Istipanus is kuli gawasi. ");
INSERT INTO zbu_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Amma i Shawulu go' pǝli' Ikilisiya bezǝn pǝlti. A ti bǝtl libi libi, ti dǝdl mwani nǝ mudli a ti la'tisi ge'lu kǝndǝ' mbalǝn. ");
INSERT INTO zbu_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ginǝs dlakisi gayi is go' dlib shilǝn ki Lya mus lu unǝs lǝɗa u. ");
INSERT INTO zbu_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","I Pilibus su ge' gatl ki Samaliya ti dlǝb shilǝn ki Almasihu. ");
INSERT INTO zbu_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nǝ hwu' mbalǝn kumi is yen gagashintu nǝ Pilibus ɗǝ pǝlti u, i mus sǝpǝ ɗemɗem nǝ ulnǝ' dlǝmi u ");
INSERT INTO zbu_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nǝ la'ti Yal i du mi'gatli pe' ɗǝge' mbalǝn diɓǝli, mi'tle ki dli ne' dakkǝlsi diɓǝli is mbi ndo'ti ");
INSERT INTO zbu_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","I hwoltu' pǝldli bali a ge' gatli. ");
INSERT INTO zbu_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mulǝnɗa mulshin Saminu, teɗi ti pǝtl gonti age' gatli, hal ɗǝ bǝtl mus mbalǝn ki Samaliyawa gagashinti. Ti ɗagagga ti usu ti bal mbalǝn kǝni, ");
INSERT INTO zbu_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Mus mbalǝn, bazi ni mil, is gakki' kǝm asi usu, “Mulu ɗǝ mbettiki dǝtl ki Lya mul nalti.” ");
INSERT INTO zbu_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Si bǝlti kal tǝngaki ta lǝndǝp ɗǝ pǝlisi gagashiti nǝ pǝltl gontwasu i. ");
INSERT INTO zbu_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Amma nǝs la'mbatl nǝ dlǝb shilǝn ki gu' ki Lya nǝ shin ki Yesu ki Pilibus, i pǝlisi baptisma mudli nǝ mwani. ");
INSERT INTO zbu_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saminu gawasi illa' badli i pǝli' baptisma. Iki ibbǝl Pilibus kali, i' kup ɓanti nǝ ye' bal ulki gagashintu. ");
INSERT INTO zbu_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nǝ milshikǝn ki Ulshelima kumi mi' Samaliya a ndǝ'nǝ shilǝn ki Lya u, is shin Bitlus nǝ Yahaya tya Samaliya. ");
INSERT INTO zbu_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nǝs mbǝkǝci u, is shilǝn nǝ Lya gaki mi'pyal bǝtl Yesu kal gaki sǝmmbi Yal ki mbatl ki Lya ɗa, ");
INSERT INTO zbu_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Gaki Yal ki mbatl ki Lya a mbi gon wasǝn uwai; a pǝlisi baptisma i katl ge'shinki Yesu. ");
INSERT INTO zbu_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","I Bitlus nǝ Yahaya zǝsi toh, is mbi Yal ki mbatl ki Lya. ");
INSERT INTO zbu_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nǝ Saminu eni zǝttoh ki milshinkǝn ɗǝ bǝtl Yal ki mbatl ki Lya u, ibbǝlsi ulpi. ");
INSERT INTO zbu_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","I' usu, “Amima bǝlǝnnǝn manti u gaki mus mulnǝ a zǝttoh u ammbi Yal mbatl ki Lya ɗa.” ");
INSERT INTO zbu_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","I Bitlus ndǝgi i' usu: “Mǝshnǝ ulpwagi, gaki ki enti kǝn ma'ultl bǝlti ki Lya nǝ ulpa! ");
INSERT INTO zbu_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ulǝn a lakki nǝ uluwai, gaki mbadlwa'ɗa nǝm akina ɗǝ Lya wai. ");
INSERT INTO zbu_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Gaki nǝgu za'pǝtl bezǝn lǝɓa a' ngem Lya ɗǝgon a' okǝlki ɗǝ ge' ulnǝ' ngapi ge' mbadlwa gu. ");
INSERT INTO zbu_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Gaki a eni i ka njikǝn nǝ ɗashti nǝ ngapti bezǝn lǝɓa i.” ");
INSERT INTO zbu_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","I Saminu ndǝgi, “Ngemǝn Lya gayini gaki ulnǝ' dlimini u ɓa ndanǝ ami.” ");
INSERT INTO zbu_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Kalkǝ dlib shilǝn ki Lya wasǝn nǝ ndǝ'twasǝn nǝ Yesu, Bitlus nǝ Yahaya is paltya Ulshelima, si dlib shilǝn ki Lya ge' mil gatl ki Samaliya dǝɓili. ");
INSERT INTO zbu_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","I mul shinkǝn ki Lya ul Pilibus su, “Lǝ tu'tǝn tona ki shitu dǝlgǝn gunǝ pe'te' Ulshelima ɗǝlǝ Gaza u.” ");
INSERT INTO zbu_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","I' hilya ippeki, tǝn shitu wasi imma isǝ mul Habasha Ndami bal mbalǝn mul nalti, gu' ni'ɗa ge' gu' ki Kandakatu, tikǝ mul zi' lǝɓa (Kǝ “Salauniya ki Habasha”). Muli mbǝ Ulshelima ɗǝ ngep Lya, ");
INSERT INTO zbu_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ti patl tya libi tiki dǝmi ge' Bǝsdomwasi, ti dlib lashti kǝge' lwabbat ki Ishaya. ");
INSERT INTO zbu_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","I Yal ki mbatl ki Lya ul Pilibus su, “Sha'tya ma' Bǝsdomu.” ");
INSERT INTO zbu_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","I Pilibus kitǝl tyage' Bǝsdomi, i' kum muli ɗǝ dlib lashti kǝge' lwabbat ki Ishaya. “Kimanǝn ulnǝ ki dlimti ge' lashti uwa?” Pilibus usu. ");
INSERT INTO zbu_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","“A mani una,” i' usu, “Ai se nǝ mulǝn adlimini.” Immbe Pilibus bi sǝddǝm siti. ");
INSERT INTO zbu_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Gukǝ shilǝn ki Lya unǝ ti dlimti u: “A dǝlti kǝnǝ mbila ge' lu poshtiti, kǝnǝ kan unǝ bǝgǝmdla ɗa atoh ɗǝ mul swattiti u, nǝgu ta ɓulbiwai. ");
INSERT INTO zbu_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","A ge' shidǝtlgawasi is nge bǝtlti baliwasi. Wokǝn matl dlib gǝs ki mbalǝnwasi? Akan dliwas taka ɗǝtǝn dǝb lǝɓa i.” ");
INSERT INTO zbu_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","I bali i ngem Pilibus, “Dlimini, mul nje'shinkǝn ki Lya u, shilǝn ki o ti dlimti, gwasa ko ki mulǝn?” ");
INSERT INTO zbu_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","I pilibus gob dlib shilǝn ki Lya itl dlimi' shilǝn ki Yesu. ");
INSERT INTO zbu_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Si ge' lǝti is mbǝkǝci ma' bal malon i bali i usu, “Ya mal kǝn ngu. Ya la'tiɗa bǝ kǝkkǝn pǝlitǝn baptisma wai?” ");
INSERT INTO zbu_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","I pilibus usu, inka la'mbatlu, nǝ mbatl nǝm mu, nǝn pǝliki batisma.” I bali i ndǝgiti i' usu, “A ndǝgi Yesu yakǝn ki Lya kǝni.” ");
INSERT INTO zbu_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ibbǝl zhil tǝ dlil bǝsdomi. Ndǝn wasǝn Pilibus isǝ Bali i is suge' mali i Pilibus pǝli' baptima. ");
INSERT INTO zbu_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nǝs pe'todɗǝ ge' mali u, i Yal ki mbatl ki Lya kan Pilibus, Bali i a yenti nuwai. Izzǝga ati pǝtl hwoltugi. ");
INSERT INTO zbu_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ngonǝnǝ gu i Pilibus lǝ' mbi gawasi a Azontus. Ibbǝl gatl tyai, a ti dlib shilǝn ki Lya mus ge' gatli hal immbǝcci Kaisaliya ɗa. ");
INSERT INTO zbu_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Shawulu ɗǝ ngalcik mi'bǝlt Lya kali, ti usu tǝn ti tlosi, i' lǝ ma' bali ki bas lǝɓasi, ");
INSERT INTO zbu_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","i' gyebti ndǝgini ki laci lwabati ki gǝlu dopga ki yahudawa ki Dimaskus, gaki nǝgu in a mbi mil bǝlt shitu u mwani nǝ mudli, a mbǝlsi ge' galt ki Ulshelima a kǝndǝsi. ");
INSERT INTO zbu_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ti lǝk kǝn ngu, nǝ' ɓal nja ma' Dimasku u, bǝnǝ man tiwasau swai chilton kǝn ngu sul lya ki ga ndǝli nǝti. ");
INSERT INTO zbu_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","I' nda atli i' kum yalon ɗǝ usu “Shawulu, Shawulu ya lakiɗa ki ngalci tǝnɗa?” ");
INSERT INTO zbu_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ti kuma i' usu, “Kiwokǝni Mulnalti?” I usu, “Amiki Yesu u nǝ ki ngalcitǝ u. ");
INSERT INTO zbu_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Amma hilya kǝlǝ ge' gatli, tya ka sǝ dlǝmi' ulnǝ ki pǝli u.” ");
INSERT INTO zbu_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ellǝnsi u nǝ si lǝ ne'tu is hol ulki dlǝmi, si kup yali sayen mullan wai. ");
INSERT INTO zbu_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","I Shawulu hilya, nǝ bul dwaɗǝn u taman yeluwai. Is nde' kina is sulti Dimasku. ");
INSERT INTO zbu_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Muttu maki bǝti ɗa yelluwai, bǝtiɗa ɗamtiwai bǝtiɗa tletiwai. ");
INSERT INTO zbu_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Mulan ɗa mul bǝlti a Dimasku shinwasi Hananiya. I Mulban shilniti age' dluti i' usu “Hananiya.” I' ndǝgi amingu Mulban.” ");
INSERT INTO zbu_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","I mulban ultisu, “Hilya ki bǝl shitu u nǝ ɗǝ mbeti kitaki, a gyemi a libi ɗǝ Yahuza ko mul Talsus nǝn ki, mul shin Shawulu, ti ngu ɗǝ shilǝn nǝ Lya. ");
INSERT INTO zbu_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","A ge' tlu'ti i' en mullǝn mul shin Hananiya i' zi' toh ga gaki tǝ' yelluɗa.” ");
INSERT INTO zbu_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ngonǝnǝgu i Hananiya ndǝgi i'usu, “Mulban, a lǝm mutti ɗǝ kub shilǝn ki muluyi ma' mbalǝn di mbǝli, ti pǝli' mi'bǝtl Lya besǝn lǝɓa a Ulshelima. ");
INSERT INTO zbu_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","In ngu bas lǝɓasi sa bǝlti ndǝti tǝ' gob mus mi' mbe shinwagi.” ");
INSERT INTO zbu_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ngonǝnagu mulban i' ul Hananiya su, lǝma' mulna oltu tǝ'dlǝm shin ini ma' ginǝ bǝ Yahudawa wai u nǝ gumsi nǝ mbalǝn ki Isla'ila. ");
INSERT INTO zbu_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ami nǝ ga ini an mbokiti toh tǝn mbǝna u nǝtǝ' tle u gaki shin ini.” ");
INSERT INTO zbu_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Iki Hananiya lǝ i' tege' libini i'zi shawulu toh ga, “Yelse ini Shawulu, mulban kǝn shinǝni, Yesu unǝ peki tǝn shitu u nǝ bǝli u, ti shinǝni gawagi ki yellu ɗa ɗaɗanu, a' nji kǝn nǝ Yal ki mbatl ki Lya ki gunti.” ");
INSERT INTO zbu_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Alǝbi alǝbi i ulǝn pekki Shawulu ɗǝ dwaɗǝn kǝnǝ kal pǝti, i'go' yellu ɗaɗanu. Iki i' hilya i pǝli' baptisma, ");
INSERT INTO zbu_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","kal ki nǝ' ɗami u, i ndǝltwas pallǝbi. Shawulu lǝm mutti a Damasku ne' mi'bǝdl Yesu kal. ");
INSERT INTO zbu_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Alǝbi alǝbi i' gop dlǝb shilǝn ki Lya age' lu dobga ki Yahudawa, tǝn Yesu yakǝn ki Lya kǝni. ");
INSERT INTO zbu_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Mus mi' ginǝ kumti is kum gagashinti is ngemi, “Tikǝ mul nǝ dlaki mi' shilǝn nǝ Lya ga nǝ shin u, a Ulshelima u waiwa? Tǝ mbǝnki gaki tǝ' tǝlasi akina ɗǝ bal lǝɓa ki kǝndi.” ");
INSERT INTO zbu_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","I Shawulu mbǝl ndǝtl tǝnki, ti hwotti mbatl ki Yahudawa yi nǝ ɗǝ dǝb a Damasku, ti ussu Yesu tikǝ Almasihu. ");
INSERT INTO zbu_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kal ki lǝb mutti i Yahudawa kǝndǝ bi tǝn sǝ' tloti. ");
INSERT INTO zbu_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Amma i Shawulu kum ulnǝs kǝndǝ u. Gasi nǝ dloncin asi ɓutti dlabi gatli gaki sǝ' tloti ɗa. ");
INSERT INTO zbu_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Amma a gasi i mil kushtiwas kanti is shimti ge' dǝsi is shimti swage' dlabiwon tǝn dli gatl bi. ");
INSERT INTO zbu_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nǝm mbǝ Ulshelima u i' hilya ɗǝ te'ge' mi' bǝtl Yesu kal, amma mus is kum ɓantwasi gaki sa la'mbatl nǝ ti mul bǝtl Yesu kal kǝn wai. ");
INSERT INTO zbu_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","I Balnaba kanti it tǝlati ma' mi'shinkǝn. Ippisi kan unǝ Shawulu yen Lya tǝn shitu u, i Lya shilǝn nǝti, nǝ kan unǝ' dlǝm shilǝn ki Lya ge' shin ki Yesu bǝni ɓatwai a Damasku u. ");
INSERT INTO zbu_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","I Shawulu dǝm ne'si ati du' ne'si a Ulshelima, a ti dlǝb shilǝn ki Lya nǝ mbatl nǝm age' shin ki Yesu. ");
INSERT INTO zbu_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ti shilǝn ne' Yahudawa mil kup bi ki Helinawa, ti shotti bi ne'si, amma is gob ngau shitu ki tlotti. ");
INSERT INTO zbu_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nǝ mi' bǝtl Yesu kal mani nǝgu u, is mbǝlti a Kaisaliya is shinti tya Talsus. ");
INSERT INTO zbu_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Iki i mus dobga ki mi' bǝtl Yesu kal ki atl ki Yahudiya, nǝkǝ Galili nǝkǝ Samaliya i mbi dǝb ki zoki, si pǝtl lǝɓawasǝn nǝ ɓanti Lya, a yal kǝ mbatl ki Lya ɗǝ ɗǝtlsi, is mbǝl tǝnki ɗa. ");
INSERT INTO zbu_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","To nǝ Bitlus gandǝl atli mussu, illǝ ɗǝ shini' mbalǝn ki Lya mi'dǝb a Lidda. ");
INSERT INTO zbu_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Alǝbi tǝ mbi mulǝn mul shin Iniyasu, tinǝ tle' ki dli hwon usǝpsi tǝn lumutti. ");
INSERT INTO zbu_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","I Bitlus ultisu “Iniyasu, Yesu Almasihu a ndokǝlki. Hilya ki gadǝl lumut twagi.” Alǝbi it hilya. ");
INSERT INTO zbu_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","I mus mbalǝn ki Lidda nǝ ki atl ki Salona nǝs yentu, is pal temma Lya. ");
INSERT INTO zbu_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","A Yapa mul bǝtl Yesu kalon ɗa mul shin Tabita gunǝ ɗǝ mbetti kǝ Dokas ɗaɗanu, ti pǝtl ulkǝ zoki ati ɗǝtl mi'gini bǝ ulǝn nisi ɗawai u. ");
INSERT INTO zbu_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","I' goni immǝci, nǝs uti' malu, is zǝti twage' kǝps ki lya. ");
INSERT INTO zbu_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lidda nja nǝ Yapa ɗa; Nǝ mi' bǝtl Yesu kal ki Lidda kumi Bitlus a Lidda u, is shin mbalǝn lop tya ma'ti, sǝ' ngemti, tǝtl dlewti tem ma'si. ");
INSERT INTO zbu_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","I Bitlus zǝga ne'si, nǝm mbǝkǝci u is tolti twage' kǝps ki lya ni. Mudli i nǝ mwani wasǝn mǝci is dlil nja nǝti, asi kulu, asi mbo'ti toh tǝn lu'lǝgǝl gini Dokas pǝlisi teɗi nǝsi ne'tu. ");
INSERT INTO zbu_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Amma i Bitlus pyakǝlsi mus swadla, in ngus atli in ngem Lya. It juyati temma hwunisi, i' usu, “Tabita, hilya.” Ibɓul dwaɗǝn, i' en Bitlus, ih hilya iddǝm nǝ gǝsi. ");
INSERT INTO zbu_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","It takit toh itl tlǝlti lya. Im mbe mi' ki Lya bi ne' mudli gini mwani wasǝn mǝcu ibbǝlsiti kami. ");
INSERT INTO zbu_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","I gu mandli mus a Yapa, i mbalǝn diɓǝli la'mbatl nǝ Lya. ");
INSERT INTO zbu_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Illǝm mutti diɓǝli a Yapa a libi ɗǝ mul pǝtl bati mul shin Saminu. ");
INSERT INTO zbu_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","A Kaisaliya i pǝl mulǝn mul shin Kaliniyas, mul kumti nǝ gawasi age' mi' dobga ki sojoji gunǝ ɗǝ mbetti ki dobga ki Ataliya. ");
INSERT INTO zbu_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ti mulbǝlt Lya kǝni nǝ ɓulti Lya nǝ mbalǝn ki libiwasi ti bǝlt mbalǝn ulkǝ toh wasi nǝ mbalt nǝm, ati shilǝn ngwash ngwash nǝ Lya. ");
INSERT INTO zbu_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Gason dom maki ki su'ti, i' en mul shinkǝn ki Lya age' tluti, immbǝ i' ultisu, ki “Kaliniyas!” ");
INSERT INTO zbu_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kaliniyas utti dwaɗǝn nǝ ɓanti, i' usu mulban yakǝni? I mul shinkǝn ki Lya ultisu, shilǝn nǝ Lya nǝ bǝlti wagi a mbǝ kina ɗǝ Lya i. ");
INSERT INTO zbu_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nǝ gun u pǝl shinkǝn swa Yapa sǝ' taki Saminu bi gunǝ si mbetti ki Bitlus su. ");
INSERT INTO zbu_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ishiti ma' Saminu mul motti bati guna libi was nja ma' bal malu.” ");
INSERT INTO zbu_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nǝ mul shinkǝn ki Lya nǝ shin nitu zǝga u, i Kaniliyas taki zheli was lob bi, nǝ mul kǝndǝtl dlomon mul bǝtl shilǝn ki Lya ge' ginǝ ɗǝ pǝlliti kyautǝn hu gasi u kǝni. ");
INSERT INTO zbu_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Nǝdl dlimisi mus ulnǝ nda u is shinsi tya Yapa. ");
INSERT INTO zbu_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Lucili a dloncin ɓal nja i, sǝ ɓal nja nǝ gatlu ngu, i Bitlus toge' kǝpsi ki lya ɗǝ shilǝn nǝ Lya. ");
INSERT INTO zbu_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kuzǝn a gobti, ti lyap ɗamti, amma ɗǝ pǝtl ulki ɗami i, i tluti mbiti. ");
INSERT INTO zbu_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","I'en lya a ɓuli, ulǝn ɗǝ sussuɗi kǝnǝ bal ul idlam mbalǝn, ɗǝ shitti su' atli ge' zheltwas upsi. ");
INSERT INTO zbu_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","A giɓi mus lǝɓa ki dǝlgǝn nǝki ban, nǝmi' dǝtl tugi, nǝ gala'sa nǝ yadli. ");
INSERT INTO zbu_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","I yalon ultisu, “Bitlus hilya, ki' poci a' ɗami.” ");
INSERT INTO zbu_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Amma i Bitlus usu o o, a ɗam bezǝn ulǝn gason wai ko ulnǝ bǝ mbunwai u. ");
INSERT INTO zbu_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","I' kum yali ɗaɗanu, ki lop, usu, “Ulnǝ Lya a li'ni' u, bǝ palli besniwai.” ");
INSERT INTO zbu_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","I gu pǝ asǝn maki, alǝbǝ alǝbǝ i dǝl ulisi twalya. ");
INSERT INTO zbu_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Uli ɗǝ hwotti Bitlus kǝn ngu tǝn tlutu nǝs pǝlitu, iki i mbalǝn i nǝ Kaliniyas shinsi teɗu, tǝn dlabi, sa lǝge sa ngem libi ki Saminu i. ");
INSERT INTO zbu_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Is tabi is ngemi Saminu gunǝ ɗǝ mbetti ki Bitlus nǝn ɗawa. ");
INSERT INTO zbu_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Tun a Bitlus ɗǝ dambǝtlti tǝn tlutu, i Yal ki mbatl ki Lya ultisu, “I ngu mbalǝn maki ɗǝ ngauki. ");
INSERT INTO zbu_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Hilya ki' pe'swai, ki bǝlsi kali. Bǝkum ɓantwai, gaki ami shinsi teɗi. ");
INSERT INTO zbu_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","I Bitlus pe'swa ma' mbalǝni, i' ulsisu, “Ami ki ngautǝma. Ya mbǝlkini?” ");
INSERT INTO zbu_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Mbalǝni usu, “Mǝ mbǝni te'ma' ndǝl mulǝn mul kina ki mil kǝndǝ dlom gǝni ɗǝ mbetti ki Kaliniyas, mul zo' mbadli, mul ɓanti Lya, gunǝ mus mbalǝn ki Yahudawa ɗǝ ndwa'titi, mul shinkǝn ki Lya mul gunti ultisu, ti ta shinkǝn, ki lǝ libi ɗakka, tǝ' kum ulnǝ ki' dlimi u.” ");
INSERT INTO zbu_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","I Bitlus mbǝlsi a libini. Nǝ lucilu i' hilya is zǝga ne'si is dǝm sǝmbǝlswasi, ge' mi' bǝtl Yesu kal ki Yapa is la'ti shitu. ");
INSERT INTO zbu_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Lucili im mbǝkǝci a Kaisaliya. Kaliniyas ɗǝ la'ti mbatl ki mbǝ twasǝn, im mbe yelsǝni bi nǝ yelǝnsi wasi. ");
INSERT INTO zbu_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Bitlus ɗǝ te' libi ni ngu, i Kaliniyas njeti in nda kina ɗa'ka, in nalti. ");
INSERT INTO zbu_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Amma i Bitlus tlǝlti lya, i' usu, “Hilya, amima yakǝn mbalǝn kǝni.” ");
INSERT INTO zbu_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Nǝ Bitlus ɗǝ shilǝn situ, it te' giɓi in mbi mbalǝn diɓǝli a domga i. ");
INSERT INTO zbu_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","I' ulsisu, “Kini nǝ gawakǝn ki manini, a mbunwai tǝ mul Yahudiya maga ko sǝl le' shinni mulnǝ bǝ biwas kǝn wai u. Amma Lya a mboki toh ba ul mulǝnsu mul bezǝn mbadlwai, ko mul ulkǝ ci'zhentwai. ");
INSERT INTO zbu_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Gaki nǝgu, nǝs ta shinkǝn ta mbǝ u, a ngewai. To nǝgun ami lyamti ta kumi ya laki i' takinǝn biɗa.” ");
INSERT INTO zbu_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","I Kaliniyas usu, “Asǝti mutti maki ngu, lu nǝguni, ami shilǝn nǝ Lya ki dom maki ki su'ti a libi ɗa ka, bǝnǝ mantiwai sai mulǝn kǝn ngu ki dlili nǝ hwol lulǝgǝl akina ɗa ka. ");
INSERT INTO zbu_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","I muli usu, Kaliniyas, Lya akum shilǝn nǝtiwagi, bǝlti wagi a dǝm ulki dambǝlti akina ɗǝ Lya. ");
INSERT INTO zbu_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Gaki nǝgu a' shin shinkǝ tya Yapa ti taki Saminu bi, gunǝ ɗǝ mbetti ki Bitlus su, am mbǝ a libi ɗǝ Saminu mul pǝtl bati abi bal mal.’ ");
INSERT INTO zbu_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Alǝbi alǝbi ya taki' shinkǝn, a mbuni ni' mbǝ u, to nǝguni i ngu mus ma mbǝ a kina ɗǝ Lya i, gaki tǝn kum undi zhili u nǝ Lya piku.” ");
INSERT INTO zbu_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","I Bitlus pisi i' usu “Nǝgun amani balini Lya ɗa nge mbalǝnwai. ");
INSERT INTO zbu_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Amma mus mbalǝn milɓantiti nǝ mul pǝl ulki zoki ulkǝ kamini amatti. ");
INSERT INTO zbu_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Lya ta shinkǝn tu'ma' mbalǝn ki Isilaila, asi pitsi shilǝn multǝmti ki holtugi tu'ma' Yesu Almasihu, tikǝ Lya kǝ kowagi. ");
INSERT INTO zbu_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kǝmanǝn shilǝn u nǝ dla'ga age' alt ki Yahudiya, tun te' Galili kal ki pǝli' mbalǝn batisma ki Yahaya atipi' mbalǝn shilǝn ki Lya ");
INSERT INTO zbu_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","mǝkum shilǝn ki Yesu Banazalat gunǝ Lya swati nǝ Yal ki mbalt ki Lya kǝ zoki mul ndǝltti, i' gobduti ati pǝtl ulkǝ zoki, ati ndokǝl mus ginǝ sheɗan ɗǝ bǝlsi kalu gaki Lya matti. ");
INSERT INTO zbu_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Mine mi'enti nǝ dwaɗǝkǝni ki Yesu nǝ mus ulnǝ pǝli age' alt ki Yahudiya nǝ Ulshelima u. Iki is tlotti atǝn gadlǝtga, ");
INSERT INTO zbu_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Amma i Lya tlǝti age' mutti maki i' mbǝlgawas ge' mbalǝn. ");
INSERT INTO zbu_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ma' mbalǝn mus kǝn tǝ mbǝlgawa swai, se mami' enti nǝ dwaɗǝnwasi ginǝ Lya oli tun te'ɗi wato mini u nǝn ɗamini i' tle ne' tu kal ki hilyawas ge' mi'mǝshti. ");
INSERT INTO zbu_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ippimini tǝn dlǝmi mbalǝn shilǝn ki Lya, mini ne mi'enti nǝ dwaɗǝnwaskǝni tǝn ti Lya latti mul pǝli' mbalǝn mi'dli nǝ mi'mǝshti shilǝn. ");
INSERT INTO zbu_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Mus milnjeshinkǝn is pǝl enti nǝ dwaɗǝn ɗǝ ussu tu' ma shin wasi mus mulnǝ alambatl tu' ma'tu tǝn mbi' pekǝlti.” ");
INSERT INTO zbu_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Bitlus age' shilǝn kǝngu, i Yal ki mbatl ki Lya i nde mus mi' kubti suɗi. ");
INSERT INTO zbu_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","I Yahudawa mi' ndǝti nǝ sǝlkǝn is mbǝ ne' Bitlus su is kub gagashiti hal ginǝ bǝ Yahudawa wai u is mbi bǝlti ki Yal ki mbatl ki Lya ki gunti. ");
INSERT INTO zbu_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ama is kubmi si shilǝn nǝ bi diɓǝli asi natl Lya. I Bitlus usu, ");
INSERT INTO zbu_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Mul ma' hana pǝlit mbalǝn i baptisma nǝ mal nǝn ɗaya? Sima sa mbi Yal ki mbalt ki Lya i kan u nǝn mbini u.” ");
INSERT INTO zbu_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","I Bitlus bǝlsi zhil sǝpǝlisi Baptisma age' shin ki Yesu Almasihu is ngemti tǝdǝm kǝ mutti lob ne' si. ");
INSERT INTO zbu_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mi'shinkǝn ne' yelsǝni gini ge' atl ki Yahudiya nǝs kumi, mi' ginǝ bǝ Yahudawai u sa ndǝ' nǝ shilǝn ki Lya i. ");
INSERT INTO zbu_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nǝ Bitlus mbǝ Ulshelima u, ginǝs ndǝ' nǝ sǝlkǝn u is shimi' shilǝn, ");
INSERT INTO zbu_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","is usu, “I ngu ka te libi ɗǝ min ginǝ bǝ sa sǝlsiwai u i, i' ɗami ne'si.” ");
INSERT INTO zbu_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","I Bitlus gop dlǝmissi mus shilǝn nisi, ");
INSERT INTO zbu_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ami, a ge' gatl ki Yapa ami shilǝn nǝ Lya, i tlu'ti mbi ni, yayen ulǝn sul lya ɗǝ sussuɗi kǝnǝ bal ul idla mbalǝn, tuge' malgǝn upsi, i mbǝ ma'kǝni. ");
INSERT INTO zbu_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Na wutti' dwaɗǝn u, yayen tlu ki dǝlgǝn nǝ ki ban mi' asǝn upsi ki ge dǝp lǝɓa, ne' mi'dǝl tugi, ne' yadlǝ a giɓi. ");
INSERT INTO zbu_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ya kum yalon ah ulǝnsu i', ‘Bitlus. Hilya, ki' poci, aɗami.’ ");
INSERT INTO zbu_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ya' usu, a nge i, mulban, gaki bezǝn lǝɓawon a tee bi gasonwai.’ ");
INSERT INTO zbu_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","I Yal shilǝn sullya ki lop, i' usu, ‘Ulnǝ Lya a li'ni' u, bǝ mbe besniwai.’ ");
INSERT INTO zbu_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","I pǝlgu asǝn maki, iki i dǝl uli twalya ɗaɗanu. ");
INSERT INTO zbu_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Bǝnǝ mantiwai he mbalǝn maki ngi ki dlǝli abidlabi u nǝ amiɗa u, sǝ shinǝnsi ma'kǝni te' Kaisaliya. ");
INSERT INTO zbu_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","I Yal ki mbatl ki Lya ulǝnsu ta zǝga ne'si, bǝnǝ cetl mbadlwai. Yelsǝni gi mǝkka i is zǝga ne' kǝni, illǝ libi ɗǝ muli. ");
INSERT INTO zbu_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Itl dlǝmimi kan unǝ en mul shinkǝn ki Lya mbǝl gawasi a libi ɗakka u, ti ussu, ‘Pǝshinkǝn swa Yapa sǝttaki Saminu bi, gunǝ simbetti ki Bitlus, ");
INSERT INTO zbu_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Tǝh dlǝmikkin shilǝn u, nǝ ki nǝ mus libi wagi ki mbi pekǝtl ɗa.’ ");
INSERT INTO zbu_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Nǝ gopti shilǝn ini, i Yal ki mbatl ki Lya ndesi suɗi, kan unǝ ndemi suɗi te' kalu. ");
INSERT INTO zbu_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ya dambǝl shilǝn ki mulban, kan u' nǝ' usu, ‘Yahaya ɓo, nǝ mal kǝn ti pǝli' mbalǝn batisma, kini ɓo nǝ Yal ki mbatl ki Lya kǝn sǝppǝlikini.’ ");
INSERT INTO zbu_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kan u nǝ Lya bǝlsi manti u ndace nǝ gunǝ bǝlǝnmini u, nǝ la'ti mbatl nǝ mulban Yesu Almasihu u, ami ki wongi ta dlǝli nǝ Lya!” ");
INSERT INTO zbu_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nǝs kumi nǝgu u, is hol ulnǝ sǝdlǝmi u, is nal Lya is usu, “Ai, ginǝ' bǝ Yahudawa wai u Lya a bǝlsi pe'ti ɗǝ ge' bezǝn lǝɓa nǝ mbim mbatldli.” ");
INSERT INTO zbu_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ginǝ dla' ga tǝn gaki bǝna u nǝ nda gunǝ mbǝl tlo Istipanǝs su, is lǝ tyage' atl ki pinikiya, nǝ calgatl ki Kubulus, nǝ gatl ki Antakiya, sǝɗa dlǝmi' mulǝn shilǝn ki Lya wai Yahudawa katl. ");
INSERT INTO zbu_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Genwasǝn, mbalǝn ki Kubulus ne' ki Kulane, is lǝ Antikiya is go' dlǝmi' mi' ginǝ bǝ Yahudawa wai u, zo' shilǝn tǝn Yesu. ");
INSERT INTO zbu_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Toh ki Lya tǝnsi, i mbalǝn dǝɓǝli la'mbadli is pal temma' mulban. ");
INSERT INTO zbu_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","I shilǝni mbǝ'ci ge'lu libi ki mi' bǝtl Lya kal ki Ulshelima, iki is shin Balnabas tya Antakiya. ");
INSERT INTO zbu_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nǝn mbǝkǝci u i' en ulki zoki u nǝ Lya pǝlisi u, ippǝl hwol tugi, in ndǝllisi mbadli sǝ'dlil nǝ bali tǝn Lya nǝ mus mbadlwasǝn. ");
INSERT INTO zbu_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ti mul zo' mbatl kǝni, ki njǝkǝni nǝ Yal ki mbatl ki Lya nǝ la'ti mbadli, i dǝɓǝl mbalǝn mbǝ ma' Mulban. ");
INSERT INTO zbu_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Iki i Balnabas lǝ tya Talsus ɗǝ ngau Shawulu, ");
INSERT INTO zbu_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Iki nǝm mbitu, im mbǝlti Antakiya, i hwon njikǝn ɗa Balnabas isi Shawulu asi ma'ga ge' libi ki Lya asi kulci' dǝɓǝl mbalǝn a Antakiya sǝ go' mbe' mi' bǝdl Yesu kal ki Kilista. ");
INSERT INTO zbu_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","To a hwonisi mi'nje shikǝn kǝ Lya en pe'te' Ulshelima is mbǝ Antakiya. ");
INSERT INTO zbu_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Nǝm age' si, mul shin Agabus, i' hilya il dlǝmi nǝ ndǝl ki Yal ki mbatl ki Lya nǝn pǝtl bal kuzǝn won ge' atl ki gu' kǝ Lomawa. (Pǝlǝn dli ge' hwon ci' gu' ki Kalaudiyas.) ");
INSERT INTO zbu_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","I milkushti dlilli, hu wonngi tǝn ndǝl twasi, tǝnma' ɗǝtl yelsǝni ginǝ ɗǝ dǝb a Yahudiya u. ");
INSERT INTO zbu_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nǝgu sǝpǝli, is shin bǝltiwasǝn gaki ɗǝtl mi'kina tu'ma' Balnabas isi shawulu. ");
INSERT INTO zbu_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Age' cini i Guu Hilidus gop mil bǝtl Yesu kal tǝngaki tǝ' hwotisi bǝnaɗa. ");
INSERT INTO zbu_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Il laki i tlo Yakubu yelse ki Yahaya nǝ bal pǝga. ");
INSERT INTO zbu_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nǝ' en gu a mbuni Yahudawa u, i' gob Bitlus ɗaɗanu. Gu ndani ge' hwon ki dobga ki daddaɓǝl ki ulki ɗami u nǝbǝ yis nidɗawai u. ");
INSERT INTO zbu_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kal ki gobtiti, illa'ti ge'lu kǝndǝ mbalǝn, ibbǝl sojoji upsi upsi lǝbi upsi sǝ' ɓutti, lyamti ki Hilidus tǝm mbilti kina ɗǝ mbalǝn, kal ki daddaɓǝl ki ɗakǝshti. ");
INSERT INTO zbu_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Iki is zǝ Bitlus a ge'lu kǝndǝ' mbalǝn, dobga ki mi' bǝtl Yesu kal is go' shilǝn nǝ Lya gawasi. ");
INSERT INTO zbu_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","A ge' gasu nǝ ǝnlu a cilu nǝ Hilidus ti lyabti tǝ pekǝlti kina dǝ mbalǝn, Bitlus ati nde'emmbuɗi ge' dlom ki mi' kǝndǝ dlom lop, ki kǝndǝ nǝ zhimdom lop, ami' ɓutti dlabi atǝn bidlabi. ");
INSERT INTO zbu_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","I mul shinkǝn ki Lya won mbǝ i lu kǝndǝ mbalǝn ni cili. Illi' Bitlus tǝn malgǝn itl tlilti lya, i' usu, “Dleuki, ɗǝ tlǝl lya!” Iki zhim domi waki Bitlus ɗǝ toh. ");
INSERT INTO zbu_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","I mul shinkǝn ki Lya ni ultisu, “La' lu'lǝgǝl a shim kaptalanwagi.” I Bitlus pǝli nǝgu. “Dla' ul idlakiwagi a' bǝlǝnkal,” ");
INSERT INTO zbu_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","I Bitlus bǝlti kal is pe' ɗǝge' lu kǝndǝ mbalǝni, amma tǝman ulnǝ mul shinkǝn ki Lya ɗǝ pǝlti u kǝnǝ baliwai; enti tiɗa kǝnǝ tlu'ti. ");
INSERT INTO zbu_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Is ɗakǝsh mi' ɓutti ki nǝm nǝ ki lop is mbǝ tǝn dlabi ki dom ki te' ge' gatli. I dlabini ɓulisi nigawasi, is petya giɓi. Nǝs gollǝtu is mbǝkǝci lu unǝ bal shitu i pa'ɗa u, a lǝbi a lǝbi i mul shinkǝn ki Lya ni za'ti. ");
INSERT INTO zbu_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Nǝ Bitlus pal ge' dliwasu i' usu, “Nǝguni amani i, bǝnǝ bwasti mbadlwai Lya kǝn shin mul shinkǝn was suɗi tǝppe'kǝlǝn te' toh ɗǝ Hilidus nǝ mus ulnǝ Yahudawa ɗǝ la'ti mbatl ki ndatwa su.” ");
INSERT INTO zbu_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nǝgu ndanǝti u, illǝ libi ɗǝ Maliyamu dyaki Yahaya, gunǝ ɗǝ mbetti ki Malkus ɗaɗanu, lu u'nǝ mbalǝn domga ɗǝ shilǝn nǝ Lya ɗa u. ");
INSERT INTO zbu_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","I Bitlus du dlalabi ki dla, i zheli won mul shin Loda lǝte' ɗǝ ya' woki mul du' dlabi ni. ");
INSERT INTO zbu_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nǝm mani yal ki Bitlus kǝn u, ta ɓul dlabi niwai i' kum hwoltugi ippal tya nǝ kal nǝ kitǝl itl dlǝmi, “Bitlus tǝn dlabi. ");
INSERT INTO zbu_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Is ultisu “Ama ga niki ɗawa. Nǝ'go' dlǝmissi nǝgu ɗa u, is usu, mul shinkǝnki Lya was kǝni.” ");
INSERT INTO zbu_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Amma i Bitlus go' du' dlabi ni, nǝs ɓul dlabi ni u is enti, is kum gagashinti. ");
INSERT INTO zbu_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","I Bitlus u nisi toh sǝddǝm shot itl dlǝmisi kan unǝ Lya pekkǝlti ɗǝge' lu kǝndǝ mbalǝn u. I' usu, “Dlǝmi Yakubu ne' yelsǝni mwani nǝ mudli tǝn ulu,” is za'si illǝ ge' kundu lu. ");
INSERT INTO zbu_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nǝ lu cilu i bal dlatl nda ge dlom ki mi' kǝndǝ dlom tǝn ulnǝ nda nǝ Bitlus su. ");
INSERT INTO zbu_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Kal ki nǝ Hilidus ngauti ta mbitwai u, i' gop pǝtl mi' ɓuttiti i nǝ shilǝn il laki tǝ tlosi. Iki i Hilidus za' Yahudiya illǝ Kaisaliya iddǝm tyaka. ");
INSERT INTO zbu_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hilidus ɗǝ leuwi mbatl tǝn mbalǝn ki Taya nǝ Sidon; is maga is mbǝmati nǝ mbatl nǝm, kal ki ngau ɗǝtl ma' Bilastasa, zheli ki guu is ngau dǝp ki zoki, gaki tǝn atl ki guu nisi ɗǝ ga'tisi si mbǝ' ulki ɗami ɗa. ");
INSERT INTO zbu_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","A tǝn cin unǝ zǝdli, i Hilidus la'lu'lǝgǝl guntwasi, it dǝmtǝn lu dǝmti ki gunti ippǝli mbalǝn shilǝn. ");
INSERT INTO zbu_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Is la'yali, “Guki Yal ki lya, ki mbalǝnwai.” ");
INSERT INTO zbu_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Alǝbi alǝbi, gaki Hilidus a nal Lya wai, imul shinkǝn ki Lya li'ti atli, i zhǝɓǝl gob ɗapti in mǝtci. ");
INSERT INTO zbu_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Amma iki shilǝn ki Lya gop mbǝtl tǝnki a ɗǝ ɓulti. ");
INSERT INTO zbu_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Balnabas nǝ Shawulu nǝs ngatl kautǝn wasǝn u, is palsu' Ulshelima, is mbǝ ne' Yahaya, gunǝ ɗǝ mbetti ki Malkus ɗaɗanu u. ");
INSERT INTO zbu_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Age' lu dobga ki mi'bǝtl Yesu kal ki Antakiya, mi'nje'shinkǝn ki Lya en ɗa nǝ mi'lashti: Balnabas, nǝ Saminu guni ɗǝ mbetti ki Baki, nǝ Lukiyas ki Kulane, nǝ Manayan gunǝs nal to'ɗi isǝ Guu Hilidus nǝ Shawulu. ");
INSERT INTO zbu_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nǝsi natl Lya nǝ ngaptibi ɗaɗanu u, i Yal ki batl ki Lya ki gunti usu, “A'wolinǝn Balnabas nǝ Shawulu gaki kyautǝn u na mbesibi ɗa u.” ");
INSERT INTO zbu_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kalki ngaptibi nǝ ngep Lya wasǝn, is zǝsi toh, is pallisi bi. ");
INSERT INTO zbu_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Si lopi, tǝn shitu wasǝn nǝ Yal ki batl ki Lya shinsi u, is lǝ Salukiya tyaka is tege' kundǝlǝn ki mal is lǝ Kubulus. ");
INSERT INTO zbu_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nǝs mbǝkǝci a Salami u, is dlǝmisi shilǝn ki Lya ge'lu lu dobga ki Yahudawa, Yahaya ne'si ti ɗǝtlsi. ");
INSERT INTO zbu_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Is gadǝl cal gatli hal is mbǝ a Bapusa. A tyaka is mah ne' mul Yahude won mul pǝtl gonti, mul nje'shinkǝn ki lǝgati, mul shin Balyashuwa’ ");
INSERT INTO zbu_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","gunǝ isǝ mukaddas Saljiyas Baulus, mul mallǝɓa, it taki ki Balnabas bi isǝ shawulu gaki ti lyap kup shilǝn ki Lya. ");
INSERT INTO zbu_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Amma Alimas mul idlatl dwaɗǝn u (gu iki shinwasi) in nge' shilǝnwasǝn, in ngayi tǝb bwas mukaddasiyi ɗǝ tǝn la'ti mbadlwasi nǝ Lya. ");
INSERT INTO zbu_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Iki Shawulu, gunǝ ɗǝ mbettiki Bulus ɗaɗanu u, ki njikǝnǝ, nǝ Yal ki batl ki Lya, i'uti Alimas dwaɗǝn i' usu, ");
INSERT INTO zbu_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Ki yakan ki shedan kǝnǝ, mul dutuki, nǝ lǝɓa kizoki! Ka njikǝn i nǝ gǝdl mbalǝn nǝ shiptotugi. Kikǝn za'ti jitti shitu ki Lya waya? ");
INSERT INTO zbu_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","In ngu toh ki Lya ɗǝ leuh mbatl nǝki. Kǝn dǝmti dwa ki lǝpdǝmti, ki kǝn ma'etcitl ki cinwai.” Alǝbi alǝbi i wolkǝnndi nǝ dǝmshal idlati, i'go' ngauti, tǝ mulǝn dǝllit toh. ");
INSERT INTO zbu_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nǝmul mukaddasi yen ulnǝ nda u, illa' mbadlǝ, i' kum ngapti bi tǝn shilǝn ki Mulban. ");
INSERT INTO zbu_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","A te' Basusa, Bulus ne' yelǝnsi wasi is tege' kundǝlǝn ki mali is mbǝkǝci Baliyata ki Bampiliya, alǝbi Yahaya za'si ippal tya Ulshelima. ");
INSERT INTO zbu_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","A te' Baliyata is lǝ tya Bisidiya ge' atl ki Antakiya. Gas cinshu'ti is tege' ludopga ki Yahudawa is dǝm atli. ");
INSERT INTO zbu_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kal ki dlǝmissi lashti zhil ki Musa nǝ lwatbat ki mi'nje' shinkǝn ki Lya, mi'kina ki lu dobga ki Yahudawa shin shinkǝn tǝnsi, is usu, “Yelsǝni, in shilǝn nikinɗa ki ndǝlli' mbalǝn mbadlu a' dlǝmini.” ");
INSERT INTO zbu_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","I Bulus hilya i' unisi toh, i' usu kumǝnnǝni, “Kini Yelsǝni Isla'ilawa nǝ kini mi' bǝtl Lya ginǝ bǝ Yahudawa u. ");
INSERT INTO zbu_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Lya ki mi' Isla'ila i' ol mi'zǝ' mi'zinmini; in nal mbalǝn wasi nǝs dǝm a Masallu; nǝ ndǝtl ki naltwaskǝn tǝ pekkǝlsi ɗǝ ge'atli; ");
INSERT INTO zbu_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Hwon kutl kutl lǝbi upsi ati ngashtibi nǝsi age' dǝlgǝn; ");
INSERT INTO zbu_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Itl tlwa mbalǝn gatl ninngi a Kan'ana, ibbǝl mbalǝnwas atlwasǝn ɗǝ gwasǝn. ");
INSERT INTO zbu_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Musgi akan hwon kutl cen upsi nǝ kutl lǝbi nantam (450). “Kal kigu, i Lya bǝlsi mi'pǝtl shilǝn hal cin ki mbǝ ki Sama ila mul nje'shinkǝn ki Lya. ");
INSERT INTO zbu_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","I mbalǝn ngawi tǝ bǝlsi gunti, Ibbǝlsi Saul yakǝn ki Kish, mulisi ge' bi ki Bilyaminu, ippǝl gunti ki hwon kutl kutl lǝbi upsi. ");
INSERT INTO zbu_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kalki tusti Saul taka, ippal Dauda ɗǝ guu wasǝn. I Lya ndǝ'nǝti, i' usu, ‘A mbi Dauda i, yakǝn ki Jessi, mulnǝ ami lyapti ge' mbadli u; tǝn pǝtl mus ulnǝ ami lyamti tǝppǝli u.’ ");
INSERT INTO zbu_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Age' gǝskǝ mulgu Lya mbilli Isla ila mul pekkǝtl si Yesu, kan u nǝ dlǝlli u. ");
INSERT INTO zbu_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kapǝn mbǝ' ki Yesu,Yahaya a dlǝmi Isla ilawa sǝ'za'pǝtl bezǝn lǝɓa appǝlisi baptisma muswasǝn. ");
INSERT INTO zbu_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nǝ Yahaya ɓal nja ki ngwatlti kyautǝn wasu, i' usu: ‘Wokǝn ki paltǝni? Ami ki gunǝ ki ɓuttǝn uwa. Amma mulǝn ɗa ti mbǝ' ge' kalini gunǝ zhim kaptǝlan wasi akǝn mat tǝngǝltiwai.’ ");
INSERT INTO zbu_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Kini mil ki Iblahim nǝ na mi'ɓantil Lya age' kini, mini shinimin shinkǝn ki pekkǝltu suɗi. ");
INSERT INTO zbu_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Mbalǝn ki Ulshelima ne' guumsisi wasǝn saman Yesu wai, ngo'nǝ konnǝtti u is njikǝn dlǝmti ki mi'nje'shinkǝn gunǝ ɗǝ dlipdli huh gas cin shu'tu. ");
INSERT INTO zbu_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ko nǝbǝ sa mbiti nǝ bezǝn lǝɓa ki tlotwai u, is ngem Bilatus tǝtl tloti. ");
INSERT INTO zbu_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nǝs njikǝn mus ulnǝ lashdli tǝntu, is shitti suɗɗǝ tǝn gǝdlǝnnga is la'ti ge' zuɗi. ");
INSERT INTO zbu_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Amma i Lya tlǝlti ɗǝge' mǝshti, ");
INSERT INTO zbu_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Mutti diɓǝli ati ɓǝtl gawasi ma' ginǝ mbǝ ne'ti a Ulshelima te Galili nǝguni siki mi' yenti nǝ dwaɗǝnwasi ma' mbǝlǝn i nǝn. ");
INSERT INTO zbu_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Mi dlǝmikin zo'shilǝn: Ki ndǝtu nǝ Lya pǝli' mi'zǝ'mi'zinmini u. ");
INSERT INTO zbu_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ta njikǝnimini i, mini milwasi, tǝn tlǝtl Yesu lya. Kan unǝ ɗa ki laci u ge' Zabula ki lop: “ ‘Ki yakuyi kǝni; Asǝti adǝm bwagi. ");
INSERT INTO zbu_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Lya tlǝlti ge' mi'mǝshti tǝngaki tǝkǝn patl ge' shukǝ ɓostinuwai, Lya usu, “ ‘An bǝtlkin albalka kizoki u na pǝli Dauda dlǝliti u.’ ");
INSERT INTO zbu_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Tǝn gaki Zabula won a dlǝmini: “ ‘Kikǝn za'ti mul guntwagi tǝb ɓoswai.’ ");
INSERT INTO zbu_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Dauda ɓo, i' pǝl ulnǝ Lya pitu age' hwonwasi, in nde yemmbuɗi; i guti ne'mi'ziǝ'mi'zitti i dliwas ɓosi. ");
INSERT INTO zbu_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Amma gu nǝ Lya tlǝlti ɗǝ ge' mi' mǝshtuwai ta ɓoswai. ");
INSERT INTO zbu_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Gaki nugu yelǝnsiyini, ami lyamti ki'manini tu'ma' Yesu dlimi kini pashti bezǝn lǝɓa. ");
INSERT INTO zbu_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Tu' ma'ti mus mulnǝ ala' mbadlu ta mbi pekǝltu ngu ɗǝge' mus byaslǝɓa, gunǝ bǝ kushti ki Musa taman pekǝtl kiniwai u. ");
INSERT INTO zbu_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","A' yanǝn lu gaki ɓa ulnǝ mi'nje'shinkǝn dlimi u ndanǝ kini. ");
INSERT INTO zbu_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“ ‘Ya nini, kini mi'mbǝtl lǝɓa. Kǝn pǝtl ga gashinti a gǝlni, an pǝtl ulǝn ge' hwonwakǝn gunǝ kǝkkǝn la'ti mbatl nǝ nali wai u, ko tǝ mulǝn dlimi kini.’ ” ");
INSERT INTO zbu_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Nǝki Bulus isǝ Balnabas ɗǝ pe'ti ɗǝge' lu dopga ki Yahudawa u, i mbalǝn mbesi bi sǝmmbil dlǝmisi shilǝn tǝn usi gas cin shuti mul mbǝti. ");
INSERT INTO zbu_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nǝ dopga ki mbalǝn zǝgga u, Yahudawa dǝɓǝli ne' mi' ginǝ te'ge' undi bǝlti ki Yahudawa is bǝl ki Bulus kal isǝ Balnabas, sine is pisi shilǝn asi ndǝllisi mbadlǝ sǝcci kina ɗa, ge'alheli ki Lya. ");
INSERT INTO zbu_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Nǝ cin shuti mbǝ ɗaɗanu u kǝnǝ mus mbalǝn kige' gatli domga tǝngaki sǝ'kum shilǝn ki Lya. ");
INSERT INTO zbu_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nǝ Yahudawa en hwu' mbalǝn u, is kum dutugi, is gob nge' ulnǝ Bulus ɗǝ dlǝmti u asi byatlti. ");
INSERT INTO zbu_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","I Bulus isǝ Balnabas is ndǝgisi nǝ ndǝtl ki mbadli: “Kini mi' dlǝmikin shilǝn ki Lya pa. Amma tun nǝ' ka ngeni u, adǝmi ki ɗa lyap mbatl mul lǝshi pa'twai, mǝnpalti tya ma'gini bǝ Yahudawa wai u. ");
INSERT INTO zbu_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tǝn gu Lya zimi zhil: “ ‘A la'ki, cili ge' mi'ginǝ bǝs man Lya wai u, gaki ki dǝm shitu mbi pe'kǝtl ki mbǝlǝn ɗa hal pa'ti ki dǝp lǝɓaɗa. ");
INSERT INTO zbu_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nǝ ginǝ bǝ Yahudawa wai u kumgu u, is kum hwoltugi is nal shilǝn ki Lya; i mus mi'mbi dli unǝ bǝ kǝn mǝshtwai u is la'mbadli. ");
INSERT INTO zbu_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","I shilǝn ki Lya mbǝl lǝllolu' tǝnki mus age' atli. ");
INSERT INTO zbu_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Amma Yahudawa gob hotti na mudli en mi'ɓantil Lya mi'bas lu kyautǝn ne' mi'kina kige' gatli. Is tlǝl ngashti tǝn Bulus isǝ Balnabas, is katsi ɗǝge' atlwasǝn. ");
INSERT INTO zbu_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Sine is bǝkǝt kushka ki asǝn wasǝn taka tǝ dǝm dǝtlkǝmɗa tǝnsi is lǝ tya Ikoniya. ");
INSERT INTO zbu_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Milkushtiwas njikǝn nǝ hwol tugi nǝ Yal ki batl ki Lya. ");
INSERT INTO zbu_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","A Ikoniya Bulus isǝ Balnabas is tege' lu dobga ki Yahudawa kan u nǝs kuɗa u is dlǝm shilǝn ki Lya hal i hwu' Yahudawa ne' ginǝ bǝ Yahudawa wai u la'mbadli. ");
INSERT INTO zbu_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Amma Yahudawa ginǝ nge la'ti mbadli is ho' ginǝ bǝ Yahudawa wai u is kon nǝ dlomwasǝn ne' yelsǝniwasǝn. ");
INSERT INTO zbu_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","I ki Bulus nǝ Balnabas is lǝmdǝp tyaka, si dlǝp shilǝn ki Lya nǝ ndǝtl ki mbadli, i' pǝl enti nǝ dwaɗǝn tǝn shilǝn ki alheli wasi gunǝ la'si ɗǝ pǝtl ulki gagashintu. ");
INSERT INTO zbu_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","I mbalǝn ki ge' gatli bwassi; nami tǝn Yahudawa, genne si tǝn kal ki mi'shinkǝn. ");
INSERT INTO zbu_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","I ki gyen ginǝ bǝ Yahudawa wai u nǝ Yahudawa ne' mi'kinawasǝn, is kǝndi sǝl la'si ge' sha as la'si nǝ zǝnga. ");
INSERT INTO zbu_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Amma nǝs kum shilǝn nǝ u, is kitǝl tyage' gatl ki Likoniya ki Listila nǝ Dalba, nǝ atl ki malgǝni. ");
INSERT INTO zbu_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Alǝbǝ sǝ mbǝl dlǝp shilǝn ki Lya tǝnki. ");
INSERT INTO zbu_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","A Listila mulǝn ɗa ki dǝmi atli dakǝlkǝni, nǝgu sǝ'zǝtti ta lǝm lǝ' gason wai. ");
INSERT INTO zbu_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ti ga'ki' shilǝn ki Bulus kǝm, i Bulus uti' dwaɗǝn, i' en la'ti mbatl ni'ɗa akǝm ki ndo'twasi, ");
INSERT INTO zbu_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","it ultisu nǝ ndǝlti, “Hilya tǝn asǝnwagi!” Gaki nǝgu, i muli pe' lya i' gob lǝti. ");
INSERT INTO zbu_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nǝ hwu' mbalǝn yen ulnǝ Bulus pǝli u, is la' yali nǝbi ki Likoniya is usu, “Inngu lya yen a ndemin suɗǝ kǝnǝ mbalǝn!” ");
INSERT INTO zbu_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Balnabas is mbekki Zapsa, tine Bulus is mbekki Hamisa gaki tikǝ mulkina ki shilǝn. ");
INSERT INTO zbu_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Iki i laɓa ki zapsa, gunǝ libi pǝtl gontwas a kal gatlu, immbǝl bas tla nǝ dwaɗǝn ki buzha pǝtti abidlabi gatli, gaki ti ne' mbalǝn si lyap pǝli'si hadaya. ");
INSERT INTO zbu_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Amma ki Balnabas isǝ Bulus, nǝs kumgu' u, is kyash lu'lǝgǝlwasǝn is te'ge' mbalǝni nǝ kitǝl, asi tlǝlyal: ");
INSERT INTO zbu_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Yelǝnsi, ya laki i' pǝlǝn nǝ guɗa? Mima mbalǝnni, kǝnǝ kini. Shilǝn ki Lya kǝn mi mbǝlli' kini, ɗǝ utlkinsu ki' zakǝn ulnǝ bǝ mbunwai u, a' palni ma' Lya mul mbadli, gunǝ pǝl lya nǝ atlu, nǝ basmal, nǝ mus ulnǝ ge'si u. ");
INSERT INTO zbu_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tini tun teɗi is za' mbalǝn sǝ' bǝl shitu u nǝ si lyamti u. ");
INSERT INTO zbu_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ngo nǝnǝgu taza' gawas ba mi' enti nǝ dwaɗǝwai, tǝn gaki ti pǝli' alheli, ti gunǝ ɗǝ pǝli'kin mal ki lya ne' lǝɓa ki ge' gu ki watlin; ti bǝtlkin ulki ɗami iye, ti njǝkǝnkin nǝ hwoltugi.” ");
INSERT INTO zbu_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mus nǝ shilǝngi, nǝ ngeskǝn sǝ hane mbalǝn hadaya gawasǝn. ");
INSERT INTO zbu_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","I Yahudawa yen pe'te' Antakiya nǝ Ikoniya is shel mbalǝni. Is lalla' Bulus is dǝlti kal gatli, si yenti kǝnǝ ta mǝcci. ");
INSERT INTO zbu_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Amma i mi' bǝtl Yesu kal is dopga is gadǝlti, i' hilya ippaltya ge' gatli. Lucili is lǝ Dalba isǝ Balnabas. ");
INSERT INTO zbu_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Is dlim shilǝn ki Lya a ge gatli is mbi mi' bǝtl Yesu kal diɓǝli. Iki is paltya Listila nǝ Ikoniya nǝ kuma Antakiya, ");
INSERT INTO zbu_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Si ndǝlli' mi' bǝtl Yesu kal mbadli, si dǝlissi kǝm sǝ' dlil tǝn la'ti mbalwasǝn. “Nǝ bǝna mul diɓǝtl kǝn tǝn ten ge' gu' ki Lya,” Is usu. ");
INSERT INTO zbu_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Bulus nǝ Balnabas is ollisi mi'kina hu lu dobga ki mi' bǝtl Yesu kalu kǝni, nǝ shilǝn nǝ Lya nǝ ngap tibi, is za'si a toh ɗǝ Lya, gunǝ tǝnti sǝ la' mbadlu. ");
INSERT INTO zbu_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nǝs pa' du' a Bisidiya u, is mbǝ a Bampiliya. ");
INSERT INTO zbu_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nǝs dlǝm shilǝn ki Lya a Baliyata u, is su Ataliya. ");
INSERT INTO zbu_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Te' Ataliya is paltya Antakiya ge' kudǝlǝn ki mal, ge' lu' u nǝ teɗi shilǝn nǝ Lya gawasǝn ɗa u is mbi alheli ki pa'ti kyautǝn ɗa. ");
INSERT INTO zbu_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Mbǝkǝshtiwasǝn tyaka, is domi mi' bǝtl Yesu kal ga is dlǝm mus ulnǝ Lya pǝli tu' ma'si u, nǝ kan unǝ' ɓuldlabi imi' gǝnǝ bǝ Yahudawai u mbi pe'tu. ");
INSERT INTO zbu_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Is lǝm dǝp tya ka ne' mi' bǝtl Yesu kal. ");
INSERT INTO zbu_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","I mbalǝn yen pe'te' Yahudiya is mbǝ Antakiya si kulci' mi'bǝtl Yesu kal: si usu “In a sǝlkin kan u nǝ mbidli ma' Musa u wai u, kikǝn mbi' pe'kǝltwai.” ");
INSERT INTO zbu_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Tǝn shilǝn gu mbǝlli ki Bulus nǝ Balnabas shotti bi mul ndǝlti ne' si. Is la'ki tǝkǝ Bulus nǝ Balnabas, ne' mi'bǝtl Yesu kalen, sǝtto Ulushelima ma' milshinkǝn ne' kolsi tǝn shilǝ ni. ");
INSERT INTO zbu_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","A si tǝn shitu wasǝn, kǝlǝ' tya pinikiya nǝ Samaliya, i Ikilisiya la'si shitu, asi dlib kan unǝ ginǝ bǝ Yahudawawai u bǝl Yesu kal. Shilǝn gu i laki mus mi'bǝtl Yesu kal is kum hwoltugi. ");
INSERT INTO zbu_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Nǝs mbǝkǝci Ulshelima u, i mil Ikilisiya nǝ mil shinkǝn nǝ kolsi ulisi ɗem, sine is dlimisi mus ulnǝ Lya pǝli tu'ma'si u. ");
INSERT INTO zbu_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Na mi'bǝtl Yesu kalen, mi'bǝtl ɗalika ki Palisiyawa is hilya is usu, “Ginǝ bǝ Yahudawa wai u nǝn sǝtlsi la'si nǝ ngesi amus sǝbbǝl zhil ki Musa.” ");
INSERT INTO zbu_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","I milshikǝn ne' Kolsi is maga sǝ'ya shilǝn u. ");
INSERT INTO zbu_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Kal ki shotti bi wasǝn mul ndǝlti, i Bitlus hilya idlǝmisi shilǝn: “Yelsǝni, kimanini te' ge' cinyen te' ka Lya a wolin nǝn ge' kini, abi ɗaka ginǝ bǝ Yahudawa wai u sǝ'kum shilǝn ki Lya as la' mbadli. ");
INSERT INTO zbu_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Lya mul ma' mbadli, ta mbo toh i ta ndǝ'nǝsi i, hal ibbǝlsi Yal ki mbatl ki Lya mul gunti, kan unǝ' bǝlmi u. ");
INSERT INTO zbu_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ta bwas dlominǝn ne'siwai, gaki ta okǝl mbadlwasǝn taka i gaki la'ti mbadlwasǝn. ");
INSERT INTO zbu_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Gaki nǝgu, ya lakiɗa iki lyap cimbǝtl Lya ɗa, ka zi mi'bǝtl Yesu kali kaya unnǝ mini ne' mi'zǝ' mi'zǝ'mini ma, mamanǝn kanti wai u? ");
INSERT INTO zbu_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ma la' mbatli tǝn alheli ki Yesu mǝ mbi pe'kǝtl ɗa, kǝnǝ kan u nǝs mbi u.” ");
INSERT INTO zbu_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","I mus hwu' mbalǝn i dǝm shot, si gakki' Balnabas isi Bulus kǝm, nǝsi dlǝmissi gagashintu nǝ Lya pǝli ge' ginǝ bǝ Yahudawawai u tu'ma'si. ");
INSERT INTO zbu_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Nǝs paki u, i Yakubu shilǝni. “Kini yelsǝni,” Kumǝnnǝni. ");
INSERT INTO zbu_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Bitlus dlimmimmi kan unǝ Lya gob likǝnti i otl mbalǝn ge'shin wasi te'ge' ginǝ bǝ Yahudawawai u. ");
INSERT INTO zbu_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Shilǝn ki mi'nje shinkǝn nda'ce kǝnɗa nǝgu, kan unǝ ɗaki laci' u: ");
INSERT INTO zbu_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“ ‘Kal ki gu an palti, ɗaɗanu akǝn libi ki Dauda gunǝ nda u. Ankǝnti a dlilli lǝbi. ");
INSERT INTO zbu_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Gaki tǝ mbalǝnyi nǝ sa' i, sǝ ngau Lya ɗa, hal ne' ginǝ bǝ Yahudawawai u nǝɗǝ mbe' shin i u, Lya usu, mulnǝ pǝl usi u.’ ");
INSERT INTO zbu_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Lǝɓa ki Lya ki maniɗa mati tun teɗi. ");
INSERT INTO zbu_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Gaki nǝgu, yenti ini, ginǝ bǝ Yahudawa wai u, a mbunwai tǝn zisi bal ulǝngawai mi'patl te'ma' Lya i. ");
INSERT INTO zbu_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Age' shuki nǝgu tǝn laccisi an dlimisi bǝs ɗam ulki ɗami ki lya ki mi'pǝtlgontwai, nǝ pǝtl kontwai, nǝ ɗab tlu'unǝ bǝ apocwai u, nǝ ɗab hwula. ");
INSERT INTO zbu_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Gaki shilǝn ki zhil ki Musa a dlimǝn dli mus ge'gatli tun teɗi, ɗǝ dlǝp lashti ge' lu dopga ki Yahudawa hwu gas cin shutu kǝnǝ.” ");
INSERT INTO zbu_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","I milshinkǝn, nǝ kolsi nǝ mus mi' Ikilisiya mus is kǝndǝ sǝppekǝl gen age' si as shinsi tya Antakiya nǝ Bulus isǝ Balnabas. Is pekkǝl Yahuza (gunǝɗǝ mbettiki Balsaba u) nǝ Sila, si mi'kinani ge' mi'bǝtl Yesu kal. ");
INSERT INTO zbu_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Is bǝlsi shinkǝn ki lwatbati mul ussu, Ma' yelsini wakǝn milshinkǝn nǝ kolsi, mil bǝtl Yesu kal, ma' yelsǝni inǝn ginǝ bǝ Yahudawawai u ki Antakiya, nǝ Suliya nǝ Kilikiya: shinniti. ");
INSERT INTO zbu_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Mǝ kumi gen pekki ɗǝ ge'mi bǝ nǝ ndǝtinǝnwai, si tlǝlinkin kin mbadli, ulnǝs dlimi u a ɗǝ hwoti kini. ");
INSERT INTO zbu_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","In ndǝgi musinǝn tǝn pekkǝl gen inǝn an shinsi tya ma'kini nǝ yelǝnsi inǝn ki Balnabas nǝ Bulus, ");
INSERT INTO zbu_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","mbalǝn ginǝ bǝlgawasǝn gaki shinkǝ Yesu Almasihu u. ");
INSERT INTO zbu_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Gaki nǝgu, mashin Yahuza nǝ Silas sǝ' dlimikin ulnǝn laci u nǝ biwasǝn. ");
INSERT INTO zbu_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Gaki a mbuni Yal ki mbatl ki Lya i nǝ mi, bǝn zikin ulǝn mul diɓǝtl aga tǝ ngǝtl ginǝ ɗǝ lyapdli u wai. ");
INSERT INTO zbu_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Bǝ ɗamǝn ulnǝs poci lya ki mi'pǝtlgontwai, nǝ ɗap tlu nǝ hwula giɓi, nǝ ɗap tlu u nǝs modǝli' yalu nǝ pǝttya ne' mbalǝn. Kǝn dǝmti lau ǝn ka zakǝn pǝtl undi gi u. Se agason. ");
INSERT INTO zbu_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Sine nǝs pallisi bi u, is su swa Antakiya, alǝbi is dom mi' Ikilisiya is bǝlsi lwabbati. ");
INSERT INTO zbu_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nǝ mbalǝn dlǝm lashti u is kum hwol tu' nǝ shikǝn ki ndǝlli' si mbatlu. ");
INSERT INTO zbu_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yahuza nǝ Silas, si ma gawasǝn mi'nje'shinkǝn kǝni, is dlǝm shilǝn ki ndǝlli' si mbadli iye. ");
INSERT INTO zbu_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Kal ki lǝp muttwasǝn tyaka, i mi'bǝtl Yesu kal pallisi bi nǝ hwoltugi, is paltwa ma'ginǝ shinsi suɗi. ");
INSERT INTO zbu_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silas yeni ambuni tǝtdǝm lǝbi. ");
INSERT INTO zbu_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Amma Bulus nǝ Balnabas is dlil a Antakiya, alǝbi si ne' gen diɓǝli asi kulci'si shilǝn ki Lya. ");
INSERT INTO zbu_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kal ki lǝpmutti i Bulus ul Balnabas usu, “Tǝn paltyai ma' mi'bǝtl Yesu kal ki ge'gatlu nǝ mus nǝn dlǝm shilǝn ki Lya ɗa u an ya kan unǝ si ɗa u.” ");
INSERT INTO zbu_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Balnabas ɗǝ lyamti sǝ' zǝga nǝ Yahaya, gunǝ ɗǝ mbetti ki Malkus, ne'si. ");
INSERT INTO zbu_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Amma Bulus yeni a mbuni sǝ' zǝga ne'twai, gaki ta za'si a Bampiliya i, ta ɓeukina ne'si ɗǝ kyautǝni wai. ");
INSERT INTO zbu_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","I lǝshi manti tegge' dlomwasǝn, Hal is bwassi. I Balnabas kan Malkus is te'ge' kundǝlǝn ki mal is lǝ tya Kublus. ");
INSERT INTO zbu_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Amma i Bulus wol silas is zǝga, mi'bǝtl Yesu kal is shilǝn nǝ Lya gawasi tǝ alheli ki Lya bǝli nǝti. ");
INSERT INTO zbu_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Is du tya ge' atl ki Suliya nǝ ki Kilikiya, ti ndǝlli' Ikilisiya i mbadli. ");
INSERT INTO zbu_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bulus mbǝ a Dalba nǝ a Listila. Mul kushti wonɗa mul shin Timothy, dyawasi mul Yehudiya ni, ti mul bǝtl Yesu kal kǝnǝ amma bwasi mul Helinawa ni. ");
INSERT INTO zbu_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Mi' bǝtl Yesu kal ki Listila nǝ ki Ikoniya si dlǝb zo' shilǝn tǝnti. ");
INSERT INTO zbu_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Bulus ɗǝ lyamti sǝ' zǝga siti, is zǝga siti i' sǝlti ɗa gaki Yahudawa yi nǝɗǝ dǝb a lǝbi u, mus simani bwasi mul Helinawani. ");
INSERT INTO zbu_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Nǝsi bǝtl gatl nǝ gatl tya u, is gob dlimi' mbalǝn zhilu nǝ mi'kina ne' kolso ki Ikilisiya kǝndǝ a Ulshelima u, gaki tǝ mbalǝn shindǝl ga ɗa. ");
INSERT INTO zbu_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Nǝnǝgu i mi'bǝtl Yesu kal ndǝndǝl ge' la'ti mbadlwasǝn ɗa, hu gasi ukǝni si mbil tǝnki. ");
INSERT INTO zbu_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Bulus nǝ mbalǝnwasi is gadǝl atl ki Pilijiya nǝ Galatiya, gaki Yal ki mbatl ki Lya a ndǝgisi i sǝ'dlǝm shilǝn ki mulban age' atl ki Asiya wai. ");
INSERT INTO zbu_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Nǝsbǝ tǝn bisi ki atl ki Misiya u, is lyami sǝttege' atl ki Bitiniya, amma Yal ki mbatl ki Yesu a ndǝgisiwai. ");
INSERT INTO zbu_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Is bǝli malgǝn Misiya, is ɓeu swa Talwasa. ");
INSERT INTO zbu_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","A gasi i Bulus tlu ki tǝn mul Makidoniya tikǝ dlǝlli ti ngepti, “Mbǝ a Makidoniya ki ɗǝlmi.” ");
INSERT INTO zbu_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kal ki tlu'ti ki Bulus, in hilya ɗǝ lǝ' Makidoniya, ma mani i Lya kǝn taki mibi tǝn dlimisi shǝlǝn wasi. ");
INSERT INTO zbu_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","In hilya ɗǝ Taluwasa in tege' kundǝlǝn ki mal illǝ tya Samutalas, lucili illǝ Niyabolis. ");
INSERT INTO zbu_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Te' lǝbi in zǝga tya Pilibi, gatlu nǝ Lomawa pǝlisi gunti bal gatl kǝnǝ Macidoniya. Illǝm mutti tyaka. ");
INSERT INTO zbu_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Gas cin shuti in pe' abidlabi gatli in su dlǝlka, ge'lu' u nǝmi la'ti mbadli mǝn mbi' lu shilǝn nǝ Lya u. In dǝm atli in gob dlǝmi' mudlǝ i nǝ domga lǝbi i shilǝn. ");
INSERT INTO zbu_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nǝm ge' mi'gaki'mi kǝm kǝli ki ge' gatl ki Tayatila mul shin Lidiya, mul utl gou lulut taka, mul bǝtl Lya kǝni. I Lya ɓul mbadlwasi i' ga'kǝm tǝn shilǝn ki Bulus. ");
INSERT INTO zbu_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kal ki pǝli' kǝliyi baptisma ne' mi' libiwasu, im mbemi bi a libi ɗa'ka. I' usu “Ən ka ndǝ' ni ami mul bǝtl Lya kal kǝn u,” “Nganni ki' dǝmni libi ɗaka.” I' shelmi. ");
INSERT INTO zbu_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Gason mi zǝ'ga ge'lu shilǝn nǝ Lya, in ma ne' zheli yakǝn kǝli mul yallu, ti domi' mulbanwas lǝɓa nǝ yalluwasu. ");
INSERT INTO zbu_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ibbǝl Bulus kal ne' mi, a ti la'ti Yal, “Mbalǝn gi mi' ki Lya kǝni, si dlimi' kin shitu ki pe'ti.” ");
INSERT INTO zbu_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ip pǝtl gu mutti diɓǝli. Il le'ci Bulus lo'si i' yalu kal i' ul mul yallu isu, “Ge' shin ki Yesu ami bǝtl ki zhil pe' ɗǝge'ti!” Alǝbi i mi'gatli za'ti. ");
INSERT INTO zbu_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nǝ mulban yeni shitu mbi' ulpwasǝn a caku, is gob Bulus nǝ Sila is dǝlsi swa bi lu dobga ki utl lǝɓa taka akina ɗǝ mi' pǝtl shilǝn. ");
INSERT INTO zbu_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Is tǝlasi kina ɗǝ mi'pǝtl shilǝn is usu, “Mbalǝngi Yahudawani, ko animi si tlǝli'mi gatl lya. ");
INSERT INTO zbu_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Si kulci' mi shilǝn u nǝ bǝ ambuni tǝn bǝliwai u tǝngaki mi Lomawa ni.” ");
INSERT INTO zbu_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","I hwu mbalǝn dopga tǝn ki Bulus isǝ Silas, i mul pǝtl shilǝni laki tǝ tusisi lu' lǝgǝl a li'si nǝ kumbǝl ki dom. ");
INSERT INTO zbu_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Kal ki li'tisi iye, is la'si age'lu kǝndǝ' mbalǝn, i la'mul kǝndǝ' mbalǝni tǝp ɓu'si ki zoki. ");
INSERT INTO zbu_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nǝ' kan zhilu u, is sulsi swa giɓi i' ki ndǝsi tǝn ancin ki ngapti asǝn. ");
INSERT INTO zbu_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Age' dlom gasi Bulus nǝ silas si shilǝn nǝ Lya asi utl ul ki natl Lya, nami' ki ge'lu kǝndǝ mbalǝn ɗǝ gakisi kǝm. ");
INSERT INTO zbu_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Nǝgu katl, i pǝl bal ukkǝ atli sai nǝ gǝsbi ki lu kǝndǝ mbalǝni uni. Alǝbi alǝbi i dlabi ki lu kǝndǝ mbalǝni ɓuli, i mus zhim dom ki kǝndǝ mi'ki kǝndǝyi ɓaɓatli. ");
INSERT INTO zbu_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nǝ mul kǝndǝ' mbalǝni hilya u, nǝ' en dlabi ni ki ɓuli u, ittus bal pǝga tǝtl tlogawasi, gaki ti yenti mi'kǝ kǝndǝ i sa kitǝli. ");
INSERT INTO zbu_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","I Bulus tlǝl Yal i usu, “Bǝ kumi gawa'! Ciwowai musinǝn miɗa!” ");
INSERT INTO zbu_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","I mul kǝndǝ mbalǝni ta' bi tǝ mbǝlli' cilti, is su giɓi in nda kina ɗǝ Bulus nǝ Silas nǝ nepti ki dli. ");
INSERT INTO zbu_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","I ki ippekkǝlsi totldla i' usu, “Mi'kina, ya tapǝli ta mbi pe'ti ɗa u?” ");
INSERT INTO zbu_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Is ndǝgi, “La'mbatl nǝ Yesu, kǝn mbi' pe'ti ki nǝ libiwagi.” ");
INSERT INTO zbu_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Iki is dlǝmi' shilǝn ki Lya ti mus ne' mi'libi wasi. ");
INSERT INTO zbu_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Age' gasu imul kǝndǝ mballǝni yemsi i' okkǝlisi usuwasǝn taka; Alǝbi ti mus ne' libiwasi i pǝlisi baptisma. ");
INSERT INTO zbu_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Im mbǝlsi libi ɗakka im mbǝllisi ulki ɗami; in njǝkǝn nǝ hwol mbadli gaki ta la'mbatl nǝ Lya i mus nǝ mi' libiwasi. ");
INSERT INTO zbu_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Nǝlu cilu, i mi' pǝtl shilǝni shin mil shinkǝn ki guu, summa mul kǝndǝ mbalǝni nǝ zhil: “Tǝ za' mbalǝn i.” ");
INSERT INTO zbu_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","I mul kǝndǝ' mbalǝni ul Bulus su, “Mi'pǝtl shilǝn a bil zhili ki tǝ zakkini ki zǝnga. Nǝ guni kǝn ma'zǝgga. Zǝnga nǝ hwol tugi.” ");
INSERT INTO zbu_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Amma i Bulus ul mi'kina i su: “Age' mbalǝn kǝn sǝ li'mi bǝma pǝlisi ulǝnwai, mus nǝ mima Lomawa u, is la'mi ge'lu kǝndǝ mbalǝn. Nǝgun si lyap pe'kǝtl mi shota? Hwe sǝm mbǝ nǝgawasǝn sǝppekkǝlmi. ");
INSERT INTO zbu_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","I mi' kǝndǝ dlom mi dlimi mi'pǝtl shilǝni, nǝs kumi Bulus nǝ Silas mi' Lomawa u, is kum ɓanti. ");
INSERT INTO zbu_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Is mbǝ ɗǝ ngep pashti ma'si, is pekǝlsi ɗǝ ge'lu kǝndǝ mbalǝni, ɗǝ ngepsi sǝ'za'gatli. ");
INSERT INTO zbu_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Kalki pe'ti ki Bulus nǝ Silas ɗǝge' lu kǝndǝ mbalǝn u, is lǝ libi ɗǝ Lidiya, lu unǝs ma ne' yelsǝni mil bǝtl Lya mwani nǝ mudli is ndillisi mbadli. Is zǝga. ");
INSERT INTO zbu_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Bulus nǝ Sila is ɓeu tya Ampibolis nǝ Apolloniya, is mbǝ Tasalonika, lu u' nǝ lu dobga ki Yahudawa ɗa. ");
INSERT INTO zbu_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kan unǝ kuɗa u, i Bulus te'ge' lu dobga, gas cin shuti maki ati shoti bi ne'si ge' lwabbati, ");
INSERT INTO zbu_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ti dlimissi nǝ ndǝlti tǝn Almasihu nǝn tlebbǝna atl hiliya ɗǝge' mi'mǝshti. I' usu, “Yesu u nǝ ami dlǝmikini u tikǝ Almasihu.” ");
INSERT INTO zbu_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Genge' Yahudawa is dǝgi is maga nǝ Bulus isǝ Sila, nǝgu hwu' mi' Helinawa mi'ɓanti' Lya ne' bas mudli bǝ tengulen wai. ");
INSERT INTO zbu_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Amma na Yahudawa yen kum dutugi; is yem mi' ndǝtl ki ga tye' ge'lu utl lǝɓa taka, is dom mbalǝn is tlǝl dlati age' gatli. Is lǝ libi ki Yason, si ngau Bulus isǝ Silas gaki sǝppekkǝlsi to' kina ɗǝ hwu' mbalǝn. ");
INSERT INTO zbu_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ama nǝbǝ sa mbisi wai u, is dǝl Yason ne' na mi'bǝdl Yesu kal te' akina ɗǝ mi'kǝndǝ' dlom kige' gatli, asi la'ti Yal si usu: “Mbalǝn i nǝ ɗǝ tlǝl gatllya i sinngi sa mbǝki i, ");
INSERT INTO zbu_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","i Yason njesi libi ɗa'ka. Muswasǝn si nge' bǝtl zhil ki Kaisal, si usu, gu wonɗa, si mbeti ki Yesu.” ");
INSERT INTO zbu_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Nǝs kum gu u, i hwu' mbalǝn ne' mi' kǝndǝ' dlom kige gatli i mbadlwasǝn tlǝh. ");
INSERT INTO zbu_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Sa za'si pa is zǝgawai sai nǝs kan up ɓatlti ma' Yason ne' yelsǝniwasi. ");
INSERT INTO zbu_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Nǝ gas pǝ u, i mi'bǝdl Yesu kal shin Bulus nǝ Silas Tya Biliya. Nǝs mbǝkǝci tya ka u, is tege' lu dobga ki Yahudawa. ");
INSERT INTO zbu_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Yahudawa ki Biliya ngǝtl ki Tasalonika nǝ zo' mbadli, gaki sa kan shilǝni nǝ lyamti, asi ya' lwabbati hu anǝmi sǝ' eni ko ulnǝ Bulus dlimi u balini. ");
INSERT INTO zbu_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Gaki gu, dǝɓǝli ge'si is la'mbadli, hal ne' bas mudli ki Helinawa ne' mwani Helinawa diɓǝli. ");
INSERT INTO zbu_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Amma nǝ Yahudawa ki Tasalonika kum Bulus ɗǝ dlib shilǝn ki Lya a Biliya u, i gen lǝ tyaka asi co'tisi asi tlǝl mbadlwasǝn. ");
INSERT INTO zbu_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Alǝbi alǝbi i mi'bǝtl Yesu kal shin Bulus tya dlǝlka, amma Silas nǝ Timoty is dlil a Biliya. ");
INSERT INTO zbu_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Gini la' Bulus shitu i is mbilti a Atina, i Bulus za'si nǝ zhil sǝppi Silas nǝ Timothy sǝ'su mbǝti. ");
INSERT INTO zbu_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nǝ Bulus ɗǝ ɓuttisi a Atina u, i'kum dutugi gaki gatli a njikǝn i nǝ lya ki mi' pǝtl gonti. ");
INSERT INTO zbu_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","I' gob shotti bi ne' Yahudawa nǝ Helinawa mi'ɓanti' Lya age' lu dobga ki Yahudawa, nǝ ge'lu dobga ki ulti nǝ ulti taka hu cin u kǝnǝ ginǝ ta mbisi lǝbi u. ");
INSERT INTO zbu_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","I dobga ki Abikuliyawa nǝ Sitokiyawa mi' ma' lǝɓa is gob shotti bi ne'ti. Nami ge'si ngemi, “Ya mul shilǝn hutu ɗǝ lyap dlǝmti ngu?” I gen usu, “Ɗǝ yedli mul bǝtl lya ki Atlen kǝni.” Sǝ dlǝmǝn gu u gaki Bulus ɗǝ dlǝp shilǝn mul tǝmti tǝn Yesu nǝ hillya was ge' mi'mǝshti. ");
INSERT INTO zbu_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Is kanti is tolti tǝn ɗani ki Alasa, lu unǝ mil dlǝtl shilǝn ɗǝ dopga ɗa u alǝbi is ultisu, “Kǝn dlimimi yakǝn pyal kushti u ɗǝ mbillitiya? ");
INSERT INTO zbu_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ki mbǝllimi sǝmbǝl shilǝn a kǝm ɗami, mi' lyamti tǝn man ulnǝ ɗǝ dlǝmti u.” ");
INSERT INTO zbu_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Mus Atinawa ne' sǝmbǝlsi ginǝ ɗǝ dǝb Atina u, si dǝb katl ba pǝtl ulǝn, amma sai kub sǝmbǝl shilǝn, nǝ mbǝlti tǝnki.) ");
INSERT INTO zbu_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","I Bulus hilya a dlom ki mi' dlǝtl shilǝn i' usu: “Mbalǝn ki Atina! Ayeni i hu tǝn shitu u kǝni kini mi' ngau ma' Lya kǝni. ");
INSERT INTO zbu_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nǝ ami duttya u, ami ya' ulnǝ ki pǝli' mi'bǝtl Lya u, hal ya mbi bagadi ki kyetl lǝɓa nǝ lashti tǝnki ɗǝ usu: Tǝn Lya u nǝ bǝ mantwai u. To ulnǝ ki bǝtlti kalu ki manǝntwai gu a mbǝ ta dlimi kini. ");
INSERT INTO zbu_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Lya unǝ pǝl dǝb lǝɓa nǝ mus ulnǝ giɓi u tikǝ Lya ki lya nǝ atli tiɗa dǝbge' lu dobga u nǝ mbalǝn kǝni nǝ toh uwai. ");
INSERT INTO zbu_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nǝgu ni tiɗa ngau ɗǝtl ma' mbalǝnwai. Amma t inǝ gawas kǝn tibǝl mus mbalǝn dli nǝ shu'ti nǝ mus lǝɓa. ");
INSERT INTO zbu_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Tǝn mul nǝm kǝn tǝpǝl mus mbalǝn, gaki sǝ dǝb hu una adǝp lǝɓa ɗa; idlillisi dǝmtwasǝn nǝ bisi ki atlwasǝn. ");
INSERT INTO zbu_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Lya pǝlǝn gu u gaki sǝn ngauti ɗa agon as mbiti, ko nǝ bǝ tiɗa lolu nǝ nǝmi nǝn wai u. ");
INSERT INTO zbu_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Gaki tu' ma'ti mǝ mbi dli ɗa, ami mallǝd ɗa nǝ ndal lǝɓa inǝn ɗa.’ Kan unǝ na mi' utl ulwakǝn dlimi' u, ‘Mima u nduwas kǝni.’ ");
INSERT INTO zbu_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Gaki nǝgu tun nǝ mini gǝski Lya kǝn u, mǝkǝn usu kǝnǝ zinaliya ko azulpa, ko yegǝn wai, ulnǝ mulǝn pǝli' nǝ manti wasi. ");
INSERT INTO zbu_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","A te'ɓo Lya a zakǝn mbalǝn ge' lǝshi matiwasǝn, amma nǝguni ti bǝl mbalǝn zhil hu a una sǝppal tem ma' Lya. ");
INSERT INTO zbu_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Tun nǝ ta zi dǝblǝɓa cin ki zǝ' ɓatlti ki ci'gontu, tu' ma' mulnǝ' la'tu. Tǝn tlǝlti mulu ɗǝ ge' mi'mǝshti ila mbalǝn ɗǝ ndǝti.” ");
INSERT INTO zbu_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nǝs kum shilǝn ki mi'tlǝllya ge' mi'mǝshtu, i nami la'ki'bi, amma i nami usu, “Mi lyab kub ki ɗaɗanu tǝn shilǝn u.” ");
INSERT INTO zbu_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Tǝn gu Bulus za'si. ");
INSERT INTO zbu_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nami ge' mbalǝni is bǝl Bulus kal is la'mbadli. Age' si hal ni Diyonisiya, yakǝn majelisa ki Alasa, nǝ kǝlion mul shin Damalisa, ne'gen. ");
INSERT INTO zbu_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Kalkǝ gu, i Bulus za' Atina illǝ Kolanti. ");
INSERT INTO zbu_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Tyaka is ma isǝ mul Yahudu won mul shin Akila, atl zǝtti ki Pantas, ta lǝndǝb patl su' Italiya uwai nǝ kǝli wasi Biliskila, gaki Kalaudiyas bǝl zhil mus Yahudawa sǝ'za' Loma. I Bulus lǝɗǝ yas si. ");
INSERT INTO zbu_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Gaki kyautǝn wasǝn nǝm kǝni ki tlotlti tanti ni, iddǝmi ati kyautǝn ne'si. ");
INSERT INTO zbu_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Mus cin shuti ati shotti bi nesi a ge'lu dobga ki Yahudawa, ati tle ga ki Yahudawa ne' ginǝ bǝ Yahudawa wai u. ");
INSERT INTO zbu_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nǝki Sila nǝ Timothy pe'te' Makidoniya, i Bulus gob mbǝtl dlǝb shilǝn ki Lya tǝnki, ati mboki Yahudawa toh Yesu tikǝ Almasihu. ");
INSERT INTO zbu_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Amma is nge dlǝmti ki Bulus asi byatlti, ibba bat lulutwas taka i' ulsisu, “Hwula wakǝn a ga wakǝn! Ulǝn alakǝn wai. Nǝguni an lǝti ma' ginǝ bǝ Yahudawai u. ");
INSERT INTO zbu_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","I Bulus za'lu dobga ki Yahudawa illǝtǝn dlabi libi ki Titus Yustus, mul bǝdl Lya libi wasi nja nǝ lu dopga ki Yahudawa. ");
INSERT INTO zbu_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","I Kilibus, mul kina ki lu dobga, ne' mus libi wasi is la' mbatl nǝ Lya; Kolantiyawa dǝɓǝli mi' kub Bulus is la' mbadlǝ i pǝlisi baptisma. ");
INSERT INTO zbu_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","A ge' gason i Lya shilǝn nǝ Bulus ge' tlu'ti: “Bǝkum ɓantwai; gob shilǝn ki Lya, bi dǝm shotwai. ");
INSERT INTO zbu_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Gaki ami miki, mulǝn kǝn tile' ki dlati a' kumi' ciwowai, ami nǝ mbalǝn diɓǝli age' gatlu.” ");
INSERT INTO zbu_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","I Bulus dǝm a Kolanti ti kulcissi shilǝn ki Lya, hwon nǝm nǝ bwasti dlom. ");
INSERT INTO zbu_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Amma nǝ Galiyo ɗǝ mul kina ki atl ki Akaya u, i Yahudawa ki Kolinti is maga is tlih Bulus nǝ mbatl nǝm is mbǝlti akina ɗǝ mi'pǝlt shilǝn. ");
INSERT INTO zbu_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“Mulgu,” si usu, “Ti tle ga ki mbalǝn sǝbbǝl Lya tǝn shitu u nǝ bǝ zhil kǝn wai u.” ");
INSERT INTO zbu_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Nǝ Bulus ɗǝ lyap shilǝn u, i Galiyo ulsisu, “Kini Yahudawa ki shilǝn tǝn lati asǝn giɓi u, tǝ kapbi pǝldli ma u, da an gaki' kin kǝm. ");
INSERT INTO zbu_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Amma tun nǝ shoti bi katl ki lǝntu, nǝ shin nǝ zhil lwakǝn u likǝnin nǝ gawakǝn. Akǝn shilǝnti tǝn undǝ giwai.” ");
INSERT INTO zbu_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Iki i' katsi taka ɗǝ bidla pǝtl shilǝn. ");
INSERT INTO zbu_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","I mbalǝn ki lǝbi is gop Sastanisu mul kina ki lu dobga is li'ti a kina ɗǝ lu pǝtl shilǝn; amma Galiyo ta pǝl ulǝn tǝn kiwai. ");
INSERT INTO zbu_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","I Bulus lǝm mutti a Kolinti. Is za' yelsǝni mudli nǝ mwanǝ it tege' kundǝlǝn ki mal illǝ Siliya, nǝ Biliskila nǝ Akila. Kapin tǝzzaga, i' utl ga taka a Kakiliya gaki dlǝtlti u nǝ' pǝli u. ");
INSERT INTO zbu_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Is mbǝkǝci Apisa, alǝbi Bulus za' Biliskila nǝ Akila. Tinǝ gawasi it te'ge' lu dobga ti shotti bi ne' Yahudawa. ");
INSERT INTO zbu_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Nǝs ngemti tǝl lǝm dǝp ne' si u, in nge. ");
INSERT INTO zbu_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Amma nǝ' pal bi ne' si u, i' usu, “Anpalti teɗi in Lya a ndǝgu.” Iki is za' Apisa i' tege' kundǝlǝn ki mal. ");
INSERT INTO zbu_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Nǝm mbǝkǝci a Kaisaliya u, illǝ Ulshelima it shin ni Ikilisiya iki illǝ Antakiya. ");
INSERT INTO zbu_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Kalki lǝb muttwas tya Antakiya, i Bulus hiliya ɗǝlǝbi i' gob lǝt tya ge' lu nǝ lu ge' atl ki Galatiya nǝ Palijiya, ati ndǝlli' mi' bǝtl Yesu kal mbadli. ");
INSERT INTO zbu_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Iki i mul Yahudiya won mul shin Apolos, atl ki zǝtti ki Iskandaliya, immbǝ Apisa. Mul mallǝɓa ni, tǝ man shilǝn ki Lya ki lwabbati iye. ");
INSERT INTO zbu_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","A kulci' shitu ki mal Lya yi, ti shilǝn ki Lya nǝ mbotlti, ti dlib lǝɓa tin Yesu kǝnǝ kan unǝ ɗa u, amma baptisma ki Yahaya tǝ mani katl. ");
INSERT INTO zbu_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Iki gob dlib shilǝn ki Lya bǝ nǝ ɓultwai age' lu dobga ki yahudawa. Amma nǝki Bilkisu nǝ Akila kumtu, is mbebbi a libi ɗasi ka is mbǝl dlimitti shitu ki mal Lya ɗa iye. ");
INSERT INTO zbu_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nǝ Apolos lyam ɗakǝshti tya Akaya u, i yalsǝni ɗǝlti is laci mi'bǝtl Yesu kal sǝn njeti in ta mbǝ u, Mbǝkǝshtwasi ma ginǝ lambatl nǝ Yesu tu tǝn zo' lǝɓa ki mulban i dǝm nǝ dǝlti iye tǝnsi. ");
INSERT INTO zbu_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Gaki ta la' Yahudawa nǝ shotti bi mul ndǝlti iye ge' mbalǝn i, ti dlimissi tu' ge' lwabbati Yesu tikǝ Almasihu. ");
INSERT INTO zbu_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos a Kolanti, i Bulus gandǝli ge'atli immbǝkǝci Apisa. Alǝbi immbi mil kushti yen. ");
INSERT INTO zbu_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","I' ul sisu, “Nǝ' lakǝn mbadlu ka mbi Yal ki mbatl ki Lya wa?” Is ndǝgi, “Is ultisu, ma kum mbǝkǝ Yal ki mbatl ki Lya wai.” ");
INSERT INTO zbu_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","I Bulus ngemi, “To unndǝ baptisma ukǝn ki mbini?” Baptisma ki Yahaya ni is usu. ");
INSERT INTO zbu_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","I Bulus usu, “Baptisma ki Yahaya ɓo baptisma ki za'ti bezǝn lǝɓa ti pǝlti. Ti dlǝmi' mbalǝn sǝlla' mbatl nǝ mul mbǝ ge' kalwasi, tiki Yesu.” ");
INSERT INTO zbu_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nǝs kumi nǝ gu u, i pǝlisi baptisma ge' shin ki mulban Yesu. ");
INSERT INTO zbu_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Nǝ Bulus zisi toh u, i Yal ki mbatl ki Lya mbisi, is gob shilǝn nǝ biyen, asi dlǝb shilǝn tǝn lǝɓa ki Lya. ");
INSERT INTO zbu_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Si mus mbalǝn kutl nǝ lop kǝn katl. ");
INSERT INTO zbu_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","I Bulus tegge lu dobga ki Yahudawa ti' dlǝb shilǝn ki Lya bǝnǝ ɓantwai lii maki, ati shotti bi ne' si ati patlsi tettǝn shitu guk ki Lya. ");
INSERT INTO zbu_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Amma i nami pǝl ndǝtl ki ga is nge la'ti mbadli, si byatl shitu i akina ɗǝ mbalǝn. I Bulus za'si. I' emmi' bǝtl Yesu kal ati shilǝn ne' si hu cin ukǝni age' lu kushti ki lashti a Tilanas. ");
INSERT INTO zbu_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Hwon lob aɗǝ pǝtl gu, hal i mus Yahudawa ne' ginǝ bǝ Yahudawa wai u, ginǝ ɗǝ dǝb ge' atl ki Asiya u, is kum shilǝn ki Lya. ");
INSERT INTO zbu_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Tu' ma' Bulus, i Lya pǝl gagashin gunǝ bǝ a ki ɗǝ pǝtl dliwai u ");
INSERT INTO zbu_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Hal hankicin ko lulutwasi in sa tile mi' gontu, as ndoki a du mi' gatli za'si. ");
INSERT INTO zbu_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Na Yahudawa yen ginǝ ɗǝ duti ɗǝ katti du mi' gatli is lyap pǝtl shilǝn nǝ shin ki Yesu tǝn mi' bǝna nǝ du mi' gatli. Si ussu, “Ge'shin ki Yesu unǝ Bulus ɗǝ dlib shilǝn wasu, ami bǝtl kin zhil ki pe' ni.” ");
INSERT INTO zbu_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Mil nin ngi ki Siba, bal lǝɓa ki Yahudawa, siɗǝ pǝtl gu. ");
INSERT INTO zbu_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Gason i du mi'gatli ulsisu, “Aman Yesu, a man Bulus, amma kini ki wokǝni?” ");
INSERT INTO zbu_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","I mul du mi' gatli pe' lya inndesi ga inngǝtl si nǝ ndǝlti mus. Ippǝlisi li'ton hal is pe'ɗǝ libini nǝ kitǝl bǝ nǝ lulutwai nǝ hwula adli. ");
INSERT INTO zbu_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Nǝgu, man dli ge' Yahudawa u, ne' Helinawa mi' dǝp Apisa, i kummwasǝn ɓutl gobsi, i shin ki Yesu mbi nalti. ");
INSERT INTO zbu_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Diɓǝli ge' mi' la'ti mbadli is mbǝ bǝ ki hwuniwai a si dlǝb ulnǝs pǝli u. ");
INSERT INTO zbu_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Mbalǝn diɓǝli mi' pǝtl gonti is mbil ulpǝtl gontwasǝn ge' lu kǝnǝmi i kwetldli a kina ɗǝ mbalǝn. Nǝs cimbǝl natl ki lwabbatu is en nǝn pǝt up ki azulpa zangu kutl lǝbi nantam. ");
INSERT INTO zbu_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Tu' nǝgu i shilǝn ki Lya mbǝl tǝnki nǝ ndilti. ");
INSERT INTO zbu_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Kalki ndakkǝ mus usi, i Bulus kǝndi ge' mbadlwasi tǝs su' Ulshelima, abbǝli tu' Makidoniya nǝ a Akaya. I' usu, kal ki alǝ tya ka, nǝ ngessi kǝn ta suti Loma.” ");
INSERT INTO zbu_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","I' shin lop mi' ɗǝtlti, Timothy nǝ Alastas, swa Makidoniya, tine inna' lǝmdǝp ge' atl ki Asiya. ");
INSERT INTO zbu_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Age' cin u ndǝl dlakǝn pǝl dli a tǝn shitu ki bǝtl Yesu. ");
INSERT INTO zbu_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Mul guptishugupon ɗa ti gubti palpalu mul shin Dimitiliyas, mul pǝtl Azulpa ki lu dobga ki Altimas, ɗǝ mbǝlli' mi' pǝtl ulti nǝ ultitaka lǝkkina alǝbi. ");
INSERT INTO zbu_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Immbe sibi ge' lu kǝnǝmi, ne' mi' kyautǝn ginǝ ɗǝ pǝtl undi ulti nǝ ulti taka u, i' usu: “Kini yelǝnsi, ini ki manini ma mbi lǝkkinaki zoki i tǝn ulti nǝ ultita gu i. ");
INSERT INTO zbu_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ki yenti a ki kumti kan unǝ mi' bǝtl Bulus kal ɗǝ tle ga ki mbalǝn aki a Apisa, nǝ mus Atlki Asiya. Ti usu lya unǝ pǝldli nǝ toh u lya kǝn wai. ");
INSERT INTO zbu_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","I ngu kuma bǝna ɗa kina kǝni, bǝ ulti nǝ ultitaka u ti hwol zo'shin wai, amma hal nǝ bal libi ki lya ki Altimas nǝn dǝmti kǝnǝ baliwai; ginǝ ɗǝ bǝtl lya a Asiya nǝ tǝn dib lǝɓa u, nǝn bwastiti nǝ naltwasi.” ");
INSERT INTO zbu_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nǝs kum gu u, i mbatl lewisi is tlǝl yal lya: “Natl tǝn Altimas ki Apisawa!” ");
INSERT INTO zbu_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Lǝbdǝb ten i gatli hwodǝli. Imbalǝn gob dǝtl Gayus nǝ Alistalkus, yelǝnsi dukkǝ Bulus su' Makidoniya, muswasǝn is dlewsi tya lu dopga. ");
INSERT INTO zbu_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Bulus lyam lǝ' kina ɗǝ hwu mbalǝn, amma imil kushtiwas haneti. ");
INSERT INTO zbu_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Hal ne' na bas mbalǝn ki atl ki Asiya, yelǝnsi ki Bulus, is taki' shinkǝn tǝn bǝga shelti tǝppe' dlawai. ");
INSERT INTO zbu_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Mbalǝn i nǝ dom ga u is hwodǝli: Nami ɗǝ tlǝl Yal ɗǝ dlǝb gwasǝn a gen ɗǝ dlǝb gwasǝn. Na mbalǝni sǝman ulnǝ lakiɗa is domga uwai. ");
INSERT INTO zbu_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","I Yahudawa kǝge mbalǝni is jakǝn Iskanadali tya kina, is tlǝl Yal si pǝtl shilǝn tǝnti. I' uu toh tǝ dǝm shot gaki ɓulti' dlati. ");
INSERT INTO zbu_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Amma nǝs mani mul Yahudiya u, i mus sǝ tlǝl yel lya ki dom lop: asi usu, “Natl tǝn Altimas ki Apisawa!” ");
INSERT INTO zbu_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Nǝ mul kina ki Lashti lwabbat kǝge' gatli shel mbalǝn u, i' usu: “Kini Apisawa, okǝn mani ki gatl ki Apisawa ɗǝ ɓutti bal libi nǝ shishipti ki Altimas swai, nǝ yegǝn u nǝ nda sul lya uwaiya? ");
INSERT INTO zbu_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Tun nǝ bǝkǝn ma'shot tibi tǝn usi wai u, nǝn mbunti ki muɗǝlǝn mbadlwakǝn bǝ' pǝlǝn ulǝn nǝ kitilwai. ");
INSERT INTO zbu_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","I ngu ka mbǝllǝn mbalǝn i ki i, si kuma sa mǝgǝl age' libi niwai bǝ sa pǝl bezǝn ulǝn alǝbi wai. ");
INSERT INTO zbu_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","In Dimitiliyas ne' yelǝnsi ultitakawasi shilǝn nisiɗa ne' mulǝn u, lu pǝtl shilǝn kǝnngu ki ɓuli mi' dlǝtl shilǝn kǝnngi. A' tǝla dlǝmti. ");
INSERT INTO zbu_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Amma in ulǝn ki lyab mbǝlliti u, to a' telen kina ɗǝ mi' dlǝtl shilǝn. ");
INSERT INTO zbu_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Nǝguɗa mige' bǝna ki, pǝtl shilǝn ki nditl kiga ki ulnǝ nda sǝti u. Tǝn shilǝn gu mǝkǝn ma' dlib ulǝn tǝnkiwai, tun nǝ bǝ shutu was ɗawai u.” ");
INSERT INTO zbu_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Kal ki dlǝb gu, ippalli mbalǝn bi. ");
INSERT INTO zbu_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kal ki mutti ki mbatl ki mbalǝn, i Bulus mbe milkushti was bi kal ki ndǝllissi mbadlǝ, ippallisi bi illǝ tya Makidoniya. ");
INSERT INTO zbu_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Iddu tya ge' lǝbǝ, ti dlǝmi' mbalǝn dǝɓǝli shilǝn ki ndǝtlki mbadlǝ, ngwaltwasi immbǝ'ci ge' atl ki Hellas, ");
INSERT INTO zbu_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","akikǝn tǝ dǝmmi li maki. Nǝ na Yahudawa yen akǝndǝ biwasu, nǝ' ɓal nja ki tǝ' tege' kundǝlǝn ki malu tǝllǝ Suluya, i' kǝndi tǝ patl tya tu' Makidoniya. ");
INSERT INTO zbu_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ti isǝ' Sopata yakǝnkǝ Palus te' Beleya, Alistalkus nǝ Sakundas mbalǝn ki Tasalonika, nǝ Gayus mul Dalbe, Timoti nǝ Tikikus nǝ Talopimas, mbalǝn ki atl ki Asiya. ");
INSERT INTO zbu_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Mbalǝn ginǝs zǝga kina u is ɓummi a Taluwasa. ");
INSERT INTO zbu_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Amma in za' Pilibi ge' kundǝlǝn ki mal kal daddaɓǝl gunǝ bǝ yisti nit ɗawai u, in mbisi a Taluwasa kalki mutti nantam. In dǝm lǝbi mutti ningi. ");
INSERT INTO zbu_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ge' cin ki nǝm ki mutti ningi in mbǝ ɗǝ ɗamti ki catl bǝledi. I Bulus dlǝmi mbalǝn shilǝn, gaki ti lyab zǝ'ga lucili, i' gob dlǝb shilǝni hal a dlom gasi. ");
INSERT INTO zbu_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Cilti ɗa dǝɓǝli ge' libi ki lya u nǝn domga ɗa u. ");
INSERT INTO zbu_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Yakǝn gidǝnsi won ti ki dǝmi tǝn dlabi ko' yetil mulshin Aptikos, i yemmbu' kanti nǝ Bulus lǝndǝp ɗǝ shilǝn u. Nǝ yemmbu' kantu, tikǝ dǝmi ge' kǝps ki lya mul lu tom maki innda su'atli i kanti hwuni. ");
INSERT INTO zbu_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","I Bulus pe'su' atli, im muttwatǝn yakǝn giɗǝnsi isi it kucenti, i'usu. “Bǝ hwok kiniwai,” “Ti kami!” ");
INSERT INTO zbu_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","I ki ippal twage' kǝps ki lya ni ɗaɗanu itcel biledi it ɗami. I' gob shilǝn halcitlkǝlu izza' lǝbǝ. ");
INSERT INTO zbu_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","I mbalǝn kan yakǝn giɗinsi i tya libi kahmi, is kum hwoltugi iye. ");
INSERT INTO zbu_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Mine in ndakina in tege' kundǝlǝn ki mali illǝ tya Asus, ge'lu unǝ tǝn kan Bulus ɗa u. Nǝgu tǝ kǝndini tǝn tǝllǝ tyaka tǝn asǝn. ");
INSERT INTO zbu_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nǝm mbimi a Asus u, inkanti ge' kundǝlǝn ki mal in mbǝ a Mitilini. ");
INSERT INTO zbu_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Lucili in tege' kundǝlǝn ki mal tekka in mbǝ'ci a Kiyos. Lucili ɗanu in ɗakǝci tya Samas, lucili ɗanu in mbǝkǝci a Militas. ");
INSERT INTO zbu_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Bulus kǝndi tǝd ɗakǝsh Apisa ge' kundǝlǝn ki mal gaki kitǝli' dlǝtl a Asiya, gaki ti dleuti tǝm mbǝkǝci Ulshelima ɗa, in nǝn pǝtu, tǝn cinkǝ pentikos. ");
INSERT INTO zbu_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Te' a Milita, i Bulus shinshin kǝn tya Apisa tǝn kolsi ki ge'lu dobga ki shilǝn ki Lya. ");
INSERT INTO zbu_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Nǝs mbǝci matu, i' ulsisu: “Ki manǝn kan u nadǝm ge' kini u, tun ga siu na mbǝ ge' atlki Asiya u. ");
INSERT INTO zbu_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ami bǝtl' Lya nǝ zo' mbadli hal nǝ luu, nǝ bǝna diɓǝli na tle gaki ɗashti ki tu' ki na Yahudawa. ");
INSERT INTO zbu_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ki manǝn kan u nǝ bǝ a kum ɓakkǝ dlib ulnǝ nǝn ɗǝtl kini uwai u, ya dlimikini ge' mbalǝn nǝ libi libi bǝkǝ hwuniwai. ");
INSERT INTO zbu_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ami dlimi' Yahudawa ne' mi' ginǝ bǝ Yahudawa wai u sǝppal ma' Lya nǝ ngesi as dlim bezǝn lǝɓawasǝn as la'mbatl tǝn Yesu. ");
INSERT INTO zbu_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","In ngu Yal ki mbatl ki Lya, ɗǝ tǝntǝni talǝ Ulshelima, aman ulnǝ tǝ ndani ami uwai. ");
INSERT INTO zbu_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Amani katl hu gatlu kǝni Yal ki mbatl ki Lya ɗǝ dlimitǝni kǝndǝti nǝ tle' bǝna ɗǝ ɓuttǝni. ");
INSERT INTO zbu_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ngo' nǝnǝgu, a pal gayi ulǝnwai; Lyamti ki mbadlini iki ta pa' taltu a njikǝn ulnǝ Yesu bǝlǝn u, dlǝb zo shilǝn tǝmi ki Lya. ");
INSERT INTO zbu_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Nǝguni a mani muswakǝn kǝkǝn yentǝn nǝwai, kini u na bǝlkin tyai ɗǝ dlǝb shilǝn ki guk ki Lya u. ");
INSERT INTO zbu_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Gaki nǝgu, ami dlǝmikkin asǝti, ape' ɗǝge' alhaki ki hwula wakǝn i. ");
INSERT INTO zbu_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Gaki a kum ɓakkǝ dlimikkin mus ngati ki Lya wai. ");
INSERT INTO zbu_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ɓutǝn gawakǝn, nǝ kuma mus hwu mbalǝn nǝ Yal ki mbatl ki Lya pǝli kini, dǝmni mi'zǝ' dwaɗǝn tǝnsi u, dǝmni mi' byatl mi'bǝtl Yesu kal ginǝ' ulsi nǝ hwulawasu. ");
INSERT INTO zbu_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Amani kal ki zǝgga ini, mi'ɗashti ki tugen nǝn teti ge' kini, sǝkǝn kub ciggokǝ hwu mbalan i wai. ");
INSERT INTO zbu_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Age' kini ma mbalǝn yen nǝn tlǝttoɗi, as gǝl bali gaki sǝddǝli gawasǝn mi'bǝtlsi kal ɗa. ");
INSERT INTO zbu_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Gaki nǝgu dlilni gal! Dambilini, hwon maki ngu aza' pikkin shilǝn wai gasi nǝ dloncin, hal nǝ lu. ");
INSERT INTO zbu_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Nǝguni ami za'tikin toh ɗǝ Lya, nǝ zo shilǝn wasi, i likǝ' kini abbǝlkin gado ne' mus mi'zo' mbadli. ");
INSERT INTO zbu_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Azi dwaɗǝn tǝn upki ko lulut ki mulǝnwai. ");
INSERT INTO zbu_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kini nǝgawakǝn ki manini toh i kǝn ɗǝ bǝltǝn ulnǝ ami lyamti u, nǝ ki mi'ginǝ ami ne'si u. ");
INSERT INTO zbu_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Age' mus ulna pǝli u, ami nune' kini, tu'tǝn ɓotlti kyautǝn hwel kǝn tǝ ɗǝlǝn mi'lǝshi ndǝtl ɗa, aki dambǝtl shilǝn ki Yesu nǝ usu: “Bǝlti ngǝtl kanti nǝ albalka.’ ” ");
INSERT INTO zbu_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Nǝ Bulus ngwatl shilǝn wasu, in ngus atl mus ne'si is shilǝn nǝ Lya. ");
INSERT INTO zbu_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","I muswasǝn is go' kulu, is kucen Bulus asi swattiti. ");
INSERT INTO zbu_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ulnǝ mbǝllisi du mbadlu iki shilǝn wasu nǝ' usu sǝkǝn yetti nuwai u. Iki is la'ti shitu tyama' kundǝlǝn ki mal. ");
INSERT INTO zbu_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Kal ki bwastimi ne'si, inte ge' kundǝlǝn inta'mi swa Kos, lucili insu Lodas nǝ Patala. ");
INSERT INTO zbu_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Nǝm mbi kundǝlǝn mul ɗakǝshti tya ge' atli ki Pinikiya u, inte giɓi inziga. ");
INSERT INTO zbu_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Nǝn yen Saipulus te'ka u inpalti tǝn tona, in ɓew kina ɗǝlǝ' ge atl ki Suliya, in shiti a Taya, alǝbi tǝ kundǝlǝn ki mali shi' kayawasi. ");
INSERT INTO zbu_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nǝn mbi lu u nǝ milkushti ɗa u in dǝm ne'si mutti ningi. Tǝn ndǝtl ki Yal ki mbatl is pi Bulus bǝllǝ Ulshelima wai. ");
INSERT INTO zbu_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Amma nǝ cin tlǝti nǝn pǝ u, in hilya in ɓew kina ɗǝ lǝti. Muswasǝn, mudli nǝ mil, is la'mi shitu tya kal gatli, iki ingus a tǝn bǝgasi in shilǝn nǝ Lya. ");
INSERT INTO zbu_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Kal ki palli' yelsǝni bi inǝn, inte ge' kundǝlǝn, sine ispal tya libi. ");
INSERT INTO zbu_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","In gop lǝti nǝn a Taya u in mbǝci Talamayas, inshinni yelsǝni, in mun nǝm ma'si. ");
INSERT INTO zbu_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Lucili in hilya inmbǝ Kaisaliya, in tye libi ki Pilibus mul dlǝp shilǝn ki Lya, gunǝ nǝmkǝni ge' ningi i' u. ");
INSERT INTO zbu_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Tinǝ mil mudli upsi, ginǝ bǝ apǝl ki nditi wai u ginǝ ɗǝ dlǝb lǝɓa ki Lya. ");
INSERT INTO zbu_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Kal ki mutti ten alǝbi, i mul njeshinkǝn ki Lya won mbǝ, shinwasi Agabus immbǝ te' atl Yahudiya. ");
INSERT INTO zbu_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nǝmmbǝ ma'mi u, i' kan ul kǝndǝ dlom ki Bulus i' kǝndǝ toh nǝ asǝnwasi, i' usu “Ulnǝ Yal ki mbatl ki Lya dlǝmi u ngu, ‘Nǝgu Yahudawa ki Ulshelima sǝn kǝndǝ mul ul kǝndǝ dlom u a bǝtlti atoh ɗǝ ginǝ bǝ Yahudawa wai u.’ ” ");
INSERT INTO zbu_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nǝn kumi nǝgu u, mi ne' mbalǝn i nǝ lǝbi u in bǝl Bulus bi bǝ su Ulshelima wai. ");
INSERT INTO zbu_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","I Bulus usu, I' usu “Yakǝn ki kulu aki calitǝn mbatl ɗa? A miɓo galkǝn aminɗa, amiɗa ɓultti' kǝndǝ twai sǝ lyami as tlo a Ulshelima tǝn shin ki mulban Yesu.” ");
INSERT INTO zbu_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nǝ bǝta kum sheltwai u, indǝm shot, in usu “Tǝ Lya pǝl ulnǝ mbunitu.” ");
INSERT INTO zbu_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kal ki gu, in kan shitu ki su' Ulshelima. ");
INSERT INTO zbu_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Na milkushti yen te' Kaisaliya is la'mi shitu is mbǝlmi libi ki mulshin Manason, lu unǝtǝn dlǝlɗa u. Mul ki Saipulus mul bǝl Lya hwon di ɓǝli. ");
INSERT INTO zbu_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nǝm mbǝ Ulshelima u, Yelsǝni inǝn njemi nǝ hwol tugi. ");
INSERT INTO zbu_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Nǝ cilt kǝlu i Bulus ziga ne'mi swa ma' Yakubu, kolsi Ki Ikilisiya mus asi ɗa. ");
INSERT INTO zbu_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Nǝ Bulus shinnissi u, itl' dlǝmisi shilǝn bi nǝ bi kǝ ulnǝ Lya pǝllitu age' mi'ginǝ bǝ Yahudawa wai u atǝn kyautǝn wasi. ");
INSERT INTO zbu_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Nǝs kumi nǝgu u, is nalt Lya. Is ul Bulus su: “Yani, zangu nǝmi Yelsǝni, Yahudawa bǝl mbadlwasǝn, ma' Lya singu mi'ndǝtl kǝ'mbatl kǝni ge' bǝtl zhil ki Musa. ");
INSERT INTO zbu_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Mbalǝn tle kup su usu tǝnki ɗǝ kulci' mus Yahudwa ginǝ bǝɗa ge' mbalan ki Musa wai u sǝ'dlat zhil ki Musa taka, ki dlǝmmisi bǝst sǝl millwasǝn ko as bǝl Lǝɓa ki kolsi inǝn wai. ");
INSERT INTO zbu_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Yakǝn tǝm pǝlini ngǝ? Katlti ɗawai sǝn kub mbǝtwa gi. ");
INSERT INTO zbu_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Gaki nǝgu pǝl ulnǝ tǝn piku. Mbalǝn upsi ni miɗa ginǝ kan dlǝlliti u. ");
INSERT INTO zbu_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Kan mbalǝn i, a bǝlǝn zhil ki kushti ki zo'ki mus, a' ɓatl mus ulpi sǝmbi sǝ' utl gaɗa. Tu' tǝn shitu gu, mus nǝn ma'dli ulnǝs dlǝmisi tǝnku, bali ɗa giɓiwai, amma ki gawagi ki bǝtl zhil ki Musa. ");
INSERT INTO zbu_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Tǝn ginǝ bǝ Yahudawa wai u mi'bǝtl Yesu kal, mashin lwabbat swai i tǝngaki bǝs ɗam ulki ɗami ki lya ki mi' pǝtl gontwai, bǝs pǝl kontwai bǝs ɗam tlu u nǝs ceti' yalu wai nǝ ɗap tlu nǝ hwula wai ");
INSERT INTO zbu_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Nǝlu cilu i Bulus kan mbalǝni asa likǝn gawasǝn i. I ki i' tege' libi ki Lya tǝ' dlǝmisi cin ngatlti ki likǝ' gawasǝn, nǝ bǝtl Lya lǝɓa ki ulkǝ okǝtl bezǝn lǝɓa ki ko wonngi wasǝn. ");
INSERT INTO zbu_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nǝ mutti ningi ɓal nja nǝpa'tu, gen ge' Yahudawa te'ge atl ki Asiya is yen Bulus ge' libi ki Lya. Is cokǝl hwu mbalǝn is gobti, ");
INSERT INTO zbu_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","asi dulle asi ussu Yelsǝni inǝn Isla'ilawa, ɗǝlǝn mi! Mulgu ti ɗǝ kushti mbalǝn sǝ mbǝl mbalǝn inǝn nǝ zhilin nǝn nǝ lu u ɗaɗanu, immbǝl Helenawa yen i kon nǝ lu bǝlt Lya.” ");
INSERT INTO zbu_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Gaki teɗi sa yen Bulus isǝ Tulopimus, mul Apisa, age' gatli, is eni kǝnǝ Bulus mbǝllǝnti ge' libi ki Lya.) ");
INSERT INTO zbu_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Mus gatli is hwodǝli mbalǝn is tlǝlte' nǝ kitǝl is gob Bulus is dǝlti twa dla ɗǝ ge' libi ki Lya, is dleusi ɗǝ le'dlabiyi. ");
INSERT INTO zbu_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Si ge' ngau shitu ki tlotti gu' u, i shilǝn lǝkina ɗǝ bali ki mi' ki ndǝ dlom ki Loman kise mus gatl ki Ulshelima ɗǝ dlati. ");
INSERT INTO zbu_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Alǝbi i' em mi'kǝ ndǝ'dlom ki Loma nǝ na ki bazi ki mi'kǝ ndǝ'dlom is tlǝ swa ge' hwu mbalǝn. Nǝ mbalǝni yen ki bali ki mi'kǝ ndǝ dlom nǝ mi'kǝ ndǝ' dlomwasu, is za' liti Bulus. ");
INSERT INTO zbu_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","I bal mulkina ki ndǝ dlomi hilya i' gobti, i' laki sǝ'kǝndǝti nǝ zhim dom lob. Iki in gyem mi tikǝ on ngi ya tǝ pǝli. ");
INSERT INTO zbu_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Nami ge' hwu mbalǝn ni si la'ti yali gi ɗǝ dlǝp shilǝnwasi gen ɗǝ dlǝb gwasǝn. Gaki o'tilu diɓǝli hal bali i' ambi gǝs ki bal shilǝni wai, il laki sǝ'tǝla Bulus ge'lu dǝb kǝmi' kǝndǝ'dlom. ");
INSERT INTO zbu_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Nǝ Bulus mbǝ tǝn lu dǝkǝsti u, sai nǝ mi'kǝndǝ'dlom kanti ki kami gaki tlǝl mi'gatl ki mbalǝn. ");
INSERT INTO zbu_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Dopga ki mbalǝn i nǝ bǝlsi teɗu asi la'ti yali asi ussu, “Mi tloti!” ");
INSERT INTO zbu_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Nǝ ɓal ki mi'kǝndǝ'dlom tǝla Bulus a ge'lu dǝb ki mi'kǝndǝ dlomu, i' ul mulkina ki mi'kǝndǝ'dlomi su, “Kǝn ndǝti ta shilǝn mika?” “Ki manǝn shilǝn “Nǝbi ki Hellenanci ɓo?” ");
INSERT INTO zbu_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“Kikǝ’ mul masal mulu wai wa? Gunǝ hwon ki te'kal nǝ ɓye u, i' tlǝlli mbalǝn ndǝlt Kǝga, hal it dǝl mbalǝn za'ngu upsi mi'tlwam mbalǝn a ge' delgǝn u” ");
INSERT INTO zbu_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","I Bulus ndǝgi, Ami mul Yahudiya ni, te' Talsus age' atl Ki Kilikiya, ami Yakan gatl kǝni gatlu nǝ si kumti nǝ nali u. Mmi bǝtl ki bi zakǝni tapi Mbalǝn i shilǝn.” ");
INSERT INTO zbu_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Nǝmul kina ki mi'kǝndǝ dlom bǝlti shilǝn u, i Bulus dlǝltǝn gǝbsi i' ta'ki hwu' mbalǝn toh lya is dǝm shot, muswasǝn ishinnisi nǝ bikǝ Alamaya. ");
INSERT INTO zbu_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Yelsǝni nemi' zǝ'mini, kumǝn nǝ ni ta dlǝmikin ulnǝ nda u, gaki ta pikini a pǝl bezǝn ulǝn wai.” ");
INSERT INTO zbu_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Nǝs kummi tashin nisi nǝ biki Alamaya u, is dǝmciw. I Bulus usu ");
INSERT INTO zbu_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ami mul Yahudiyani, zǝkkǝ Talsus ki Kilikiya, age' gatlu anali. Ami mul kushtini amalgǝn ɗǝ Gamaliel gunǝ kulci zhil ki mi'zǝ'mi'zǝm mini u. Ami nǝ ɓotlti ki bǝlt Lya kǝnǝ kan unǝ muswakǝn ki pǝltin sǝ'ti u. ");
INSERT INTO zbu_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Hal a la ki mbalǝn ɓutl ki bǝtl shitu u i, ami gobti mwani nǝ mudli a kǝndǝsi a atlosi. ");
INSERT INTO zbu_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Bal lǝɓa nǝ mus mi' dlǝtl shilǝnwasi nǝn ziti nǝ dwaɗǝn. Ama'si akan shinkǝn ki elsǝni ini Yahudawa yasuli swa Dimascus, Ya ɓeu ɗǝ gopti mbalǝn ta sulsi ge' lu kǝnndǝ' mbalǝn ki Ulshelima as pǝlisi bezǝn'lǝɓa. ");
INSERT INTO zbu_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Amige' lǝti a bal dloncin na ɓal nja nǝ Dimashku u, bǝnǝ mantiwai i bal ciltton pe'sul lya i ga ndǝlǝni. ");
INSERT INTO zbu_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ya nda atli yakum ya lon ɗǝ ultǝnsu, Shawulu! Shawulu! Yaki pǝlitǝn bezǝn lǝɓaɗa?’ ");
INSERT INTO zbu_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Yandǝgi ‘Ki wokǝni, mul ban?’ I' ulǝnsu. ‘Amiki Yesu mul Nazaleh, mulnǝ ki pǝllitti ngashtu.’ ");
INSERT INTO zbu_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","To, ginǝ ne' kǝn i yen ciltisi, amma sakum yal ki mul shilǝn nǝ amiwai. ");
INSERT INTO zbu_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ya usu ‘To, ya tapǝli, mulban?’ I mul ban ulǝnsu “ ‘hilya, ki'lǝ Dimascus, tyaka sǝ' dlǝmi' ulnǝ' ki' pǝli u.’ ");
INSERT INTO zbu_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Na dǝm dwa u gaki ciltu. Mbalǝn i nǝ' ne' kǝn u is goppi toh is sullǝn swa Damascus, ");
INSERT INTO zbu_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Mulǝn ɗa mulshin Hananiyi immbǝ makǝni. Ti mul bǝtl zhil ki musa mulnǝ mus Yahudawa ki dǝmi alǝbi ɗǝ ndwatiti u. ");
INSERT INTO zbu_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Nǝ' dlǝl malgǝn ɗa kǝn u, i' ulǝnsu, Yelse ini Shawulu, tǝ Yelluwa' pali!’ A lǝbi a lǝbi idwaɗǝn i ɓuli Ya yenti. ");
INSERT INTO zbu_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","I' usu, ‘Lya ki kolsi inǝn a olki gaki ki man ulnǝ ge' mbadlwasu, Kin ye' mul zoki mbatlu, kǝn kub shilǝn abiwasi. ");
INSERT INTO zbu_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kǝn dǝp mul pǝtl yenti ki dwaɗǝn wasi ma' mus mbalǝn tǝn ulnǝ' enini nǝ ulnǝ kumini u. ");
INSERT INTO zbu_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","To nǝgun u yaki ɓutti? Hilya, tǝ pǝli' Baptisma a o'kǝli' Bezǝn lǝɓawa' taka, tu' ma' mbe' shinwasi.’ ");
INSERT INTO zbu_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Na patl te' Ulshelima a ami shilǝn nǝ Lya age' libi ki Lya, i tlu'ti mbini. ");
INSERT INTO zbu_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ya yen mulban ɗǝ shilǝn nǝ ami. I' usu, dlewki! Ki'za' Ulshelima, gaki mbalǝn aki sǝkǝn ndǝ'ti nǝ pǝtl yenti ki dwaɗǝn u nǝ ki dlǝmti tǝn kǝn uwai.’ ");
INSERT INTO zbu_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“ ‘Amine ya usu, mulban, ‘Sima gawasǝn sǝmani hu lu dobga ukǝni a kǝndǝ mbalǝn ginǝ la'mbatl tǝnku ya li'li'si. ");
INSERT INTO zbu_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Gasi unǝs bǝna hwula ki Istipanusu, mul pǝtl enti ki dwaɗinwagu, a ami lǝbi ki dlǝli, ami bǝlt kal ki ulnǝs pǝli u, amine ya ɓu' lulu' kǝmi' tlotti.’ ");
INSERT INTO zbu_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“I mulban ulǝnsu, ‘Hilya; ta shinki tya lolu ma' ginǝ bǝ Yahudawa wai u.’ ” ");
INSERT INTO zbu_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","I mbalǝn dobga ɗǝ ga'ti kǝm tǝn shilǝn ki Bulus hal immbǝ tǝn shilǝn u ɗa, is tlǝl yal is usu “Tloti! Tǝ bwas undi mulu nǝ dǝb lǝɓa a mbuni tǝt dǝm tǝn lǝɓa wai!” ");
INSERT INTO zbu_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Asi matlti asi pe'ti lya nǝ dla'ti lulutwasǝn asi tlǝl kushka lya. ");
INSERT INTO zbu_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Imul kina wasǝn bǝl zhil ki sutl Bulus ge'lu dǝb ki mi'kǝndǝ' dlom. A gyemti nǝ dlamtǝl, gaki tǝn man shitu u nǝ laki i mbalǝn ɗǝ lakitti Yal ɗa nǝgu u. ");
INSERT INTO zbu_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Amma nǝ kǝndǝtti nǝ zhimu, i Bulus ul balmul kǝndǝ dlomu nǝ nja nǝti usu “A mbunni ki pǝli mul alt ki Loma dlamtǝlla, bǝka mbiti nǝ lati asǝn gimbi waiya?” ");
INSERT INTO zbu_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Nǝ bal mul kǝndǝ dlom ki Loma kumi nǝgu u, illǝmak mul bǝtl zhil ki kǝndǝ dlom i' ultisu, “Yaki lyab pǝltini? Mulu mul Loma ni.” ");
INSERT INTO zbu_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Imul bǝtl zhil ki kǝndǝ dlomi' ul Bulus su, “Dlǝmini ki mul Loma kǝma?” I' usu, “E.’’ ");
INSERT INTO zbu_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Imul bǝtl zhil ki kǝndǝ dlom, i' usu, amiciɓo sai na ɓatl bal ulpi ya mbi dǝb yakǝn atlɗa.” I Bulus usu, amiɓo nǝ nali sǝ zǝnni.” ");
INSERT INTO zbu_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Gaki nǝgu, ginǝ ɗǝ lyab gyebti u, is mbǝ gi nǝ kali alǝbi alǝbi. Mul bǝtl zhil ki kǝndǝ dlomi nǝm mani, ti gawasi ta kǝndǝ Bulus mul Loma u, i bult gopti, in ngu talǝge ta kǝndǝti. ");
INSERT INTO zbu_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Nǝ lucilu mul bǝtl zhil ki kǝndǝ dlomi illyami tǝm man ulnǝ Yahudawa tǝla shilǝn tǝn Bulus ɗa u, ittǝngǝlti, idlǝllisi zhil nǝ bas lǝɓasi nǝ mik attli sǝddomga, apa immbǝl Bulus idl dlǝlti a kina wasǝn. ");
INSERT INTO zbu_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","I Bulus uti mi'dlǝl shilǝn ki atl dwaɗǝn i' usu, “Yelsǝni ini, bǝtl Lya kǝn amiɗa nǝ mbatl ki zoki hal i mbǝl cin ki sǝti ɗa.” ");
INSERT INTO zbu_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ananiya bal lǝɓa ki Lya ul ginǝ ki dlǝli nja ma' Bulus su sǝ'op biwasi. ");
INSERT INTO zbu_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","I Bulus ultisu, “Ki mul ngashtu, “Lya nǝn litiki, ase, ki dǝmni ki u ɓo zitǝn zhil kǝn ki ɗaya, ki ngu ɗǝ usu tǝ duni, gu shot nǝ zhil ki Musa ");
INSERT INTO zbu_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ginǝ ki dlǝli nja nǝ Bulus su is usu, “Bal lǝɓa ki Lya kǝn ki byel twa?” ");
INSERT INTO zbu_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","I Bulus ulsisu, “Yelse ini, amani ti bal lǝɓa ki Lya kǝn wai, Ki laciɗa: ‘Bǝ'dlǝm bezen lǝɓa tǝn mul kina ki mbalǝn wai.’ ” ");
INSERT INTO zbu_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Nǝ Bulus yeni, nami Sadukiyawa ni nǝ gen Palisiyawa u, itltlǝl yal age' lu domga i' usu “Yelsǝni ini, A mi' mul palisiyawani, yakǝn Palisiyawa. Tǝn a dlil mbadli i tǝn tlǝl lya ki mi' mǝshti i ami tleb bǝna ɗa.” ");
INSERT INTO zbu_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nǝ' dlǝmi nǝgu u, i dlan nda ge' dlom ki palisiyawa nǝ sadukiyawa, i dob gani bwǝsi. ");
INSERT INTO zbu_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Amma Sadukiyawa sa ndǝ nǝ hillya gǝ' ki mi'mǝshti twai, bǝ mi'shinkǝn ki Lya ɗawai, bǝ yal ki mbatl ki Lya ɗawai, amma mus palisiyawa is ndǝ' nǝ nali.) ");
INSERT INTO zbu_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","I bal dla' hillya, gen ge' mi'lashti ki ɗalika ki palisiyawa is tlǝlyal asi shottibi. Asi ussu “Miɓo mambi mulu nǝ bezen ulǝn wai,” is ussu. “Ko yalkǝ mbatl ki Lya ko mulshinkǝn ki Lya kǝn shilǝn nǝti u pa?” ");
INSERT INTO zbu_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Nǝ shotti bi i ndǝndǝlu i mul kǝndǝdlom kum mɓulti ɓas kyakkyash Bulus. I' bǝlsi zhil tǝ mi' kǝndǝdlom susuɗi sǝ' kanti ɗǝ ma'si nǝ ndǝlti sǝ' tǝlati ge'lu dobga ki mi' kǝndǝdlom. ");
INSERT INTO zbu_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Nǝ gas pǝ u i mulban dlǝl nja Nǝ Bulus i' ultisu, “Ndǝl mbadli kan u nǝ'pǝl enti nǝ dwaɗǝn a tǝnkǝn a Ulshelima u, nǝgu ki' pǝl enti nǝ dwaɗǝn ini ɗaɗanu a Loma.” ");
INSERT INTO zbu_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Nǝ lucilu i Yahudawa mabi is usu nǝ ndaltannaca sǝ' kǝn ɗamti nǝ tletiwai sai nǝ sa tlo Bulus. ");
INSERT INTO zbu_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ginǝ kǝndǝ shilǝn u sǝ'ngǝtl mbalǝn kǝtl lǝbi upsi. ");
INSERT INTO zbu_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Is lǝ ma' bas lǝɓasi ki Lya nǝ mi'kina is usu, ma dlil bal tannaca i mǝkǝn ɗamtiwai nǝ tletiwai sai nǝ ma' tlo Bulus. ");
INSERT INTO zbu_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Gaki nǝgu kini nǝ mi'dlǝtl shilǝn dlǝmi mul'kina ki kǝndǝdlom sǝ' mbǝlli kinti, kǝnǝ ki' mbǝlǝn ngep gǝs ki shilǝn was tǝn kini iye mi kuma ki dlǝli tǝn asǝn kǝn mi'ɗa tǝn tloti nǝ mbǝtwasi. ");
INSERT INTO zbu_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Nǝ yakǝn ki yelse ki Bulus kumi nǝgu u i' suge' lukǝndǝ mbalǝnisi idlǝmi Bulus. ");
INSERT INTO zbu_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Iki Bulus taki bal mulkina ki kǝndǝ dlom gudǝl nǝm bi i' usu, “Kan yakǝn giɗǝnsi u ki tǝlati ma' mulkina; tinǝ shilǝn u nǝ tǝtl dlǝmi tu.” ");
INSERT INTO zbu_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","I' kanti it tǝlati ma'mulkina, i' usu, “Bulus, ki lu ki kǝndǝn mbalǝn, shinǝni takami' yakǝn giɗǝsi u teɗi tǝn gaki ulki dlǝmi ni' ɗa.” ");
INSERT INTO zbu_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","I mulkina ki kǝndǝ dlom goppi yakan giɗǝsi i' toh teɗi, amalgǝni in gyemti, “Yaki lyamti ki' dlǝmini?” ");
INSERT INTO zbu_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","I usu: Yahudawa sa kǝndǝ i sǝ' gyemki ki mbǝlisi Bulus ma mi'dlǝl shilǝn akyau kǝnǝ sǝ' gyemti ki zokini tǝn shilǝnwasi. ");
INSERT INTO zbu_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Amma bǝ ndǝgisiwai, gaki mbalan ginǝ ngǝtl kutl lǝbi upsi siɓuttiti age' dǝlgǝn. Sa dlil bal ndaltannaca i sǝkǝn ɗamtiwai nǝ tletiwai sai nǝ sa tloti ɓutti sǝɗa katl ki ndǝgisi.” ");
INSERT INTO zbu_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","I mul ki ndǝdlomi dǝlli' kǝmu i' za' yakǝngiɗǝnsi isi is zǝga nǝ: “Bǝ' dlǝmi mullǝn shilǝn u nǝ' dlǝmi uwai.” ");
INSERT INTO zbu_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","I mulkina mbe bas mi' kǝndǝdlom was gudǝli lob bi i' ulsisu, “Gadlǝn mi' kǝndǝ dlom kutlt cen lob nǝ mi' kǝndǝ dlom mi'to'tǝn bǝtsi, kult lǝbi ninngi, nǝ mi' dlati nǝ zo kult cen lob sǝ'su Kaisaliya nǝ dom nǝtapsi ki gasi. ");
INSERT INTO zbu_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ngayi Bulus bǝtsi tǝto' tǝnki asulǝnti ma' gobna ki Pelis.” ");
INSERT INTO zbu_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","I mulkina ki mi' kǝndǝ dlom lash lwabati kǝnǝ nǝgu: ");
INSERT INTO zbu_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Te'ma' Kaldiwus Lisiyas, tu Ma'mulnalti, Gobna Pelis. Shilniti mul nalti. ");
INSERT INTO zbu_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Mulgu Yahudawa si lyam tloti, amma yalǝ nǝ mi' kǝndǝ dlommini yakwacati, a kumi timul dǝm ki pit a Loman kǝni. ");
INSERT INTO zbu_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ami lyamti taman yakǝn laki singettiɗa, ya mbǝlti ma' mi'dlǝtl shilǝnwasǝn ɗa. ");
INSERT INTO zbu_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Yambi si dakǝtti tǝn shilǝn ki kushtiwasǝn, amma bezǝn lǝɓa u nǝs zitu atala ki kǝndǝti ko tlotwai. ");
INSERT INTO zbu_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","“Nakumi sa kǝndi bezǝ' ulǝntintu, iki ya shini sǝ'talati maki. Ya ul mi' pǝtlti nǝ shilǝn ni su sǝ' dlǝm ulnǝ pǝli u akina wagi. ");
INSERT INTO zbu_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Tǝn gaki nǝgu imi' kǝndǝ dlom kan Bulus ne'si a gasi is talati Antipatlis. ");
INSERT INTO zbu_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Nǝ lucilu is za' mi'kǝndǝ dlom mi'tottǝn bǝtsi sǝ'zǝgane'ti, is paltya gelu dǝmtwasan. ");
INSERT INTO zbu_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Nǝ mi'kǝndǝ dlom mi'tottǝn bǝtsi mbǝci Kaisaliya u, is bǝl Gobna i lwabati is za' Bulus atoh wasi. ");
INSERT INTO zbu_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Nǝ gobna ya lwabatisi u, i' gyem Bulus kiɓo age'lu u kǝnkiɗa. Nǝ'kumi a Kilikiya u, ");
INSERT INTO zbu_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","i' usu, “Anga'kiki kǝm ǝn mi' pǝtl ki nǝ shilǝn sa mbǝ u.” I gobna i bǝl zhil sǝ', dlǝl Bulus a bidla ki Hilidus. ");
INSERT INTO zbu_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Kal ki mutti nantam i bal lǝɓa, Ananiyas, is su Kaisaliya nǝ mi'kinayen nǝ lauya mulshin Taltulus, is tǝla shilǝn ki Bulus akina ɗǝ gobna. ");
INSERT INTO zbu_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Nǝ sul Bulus giɓi u, i Taltulus mbǝl shilǝn akina ɗǝ Apilikus: “Mul nalti tu'maki mbalǝn mbi dǝp kizoki mul mbunti, tu'ma' yellu loluwa' kǝn likǝn dǝb ki mbalǝn inǝn ɗa. ");
INSERT INTO zbu_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ko a nǝmi, mbalǝn inǝn si godeki ko a una. ");
INSERT INTO zbu_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Amma gaki ɓa dǝmbǝl ki, Ami ngepki nǝ zo' mbadlwa gu ga' kimi kǝm tǝn ndo'lǝs ulnǝ tǝn dlǝmiku. ");
INSERT INTO zbu_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Mǝ mbi mulu mul ngaushilǝn kǝni, mul mbǝlt dlatl kǝni adlom ki Yahudawa nǝ ko a u nǝ age' dǝb lǝɓa, kuma tikǝ mulkina ki ɗalika ki Nazalawa. ");
INSERT INTO zbu_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Hal ti lyap kon nǝ libi ki Lya; in gobti. Nǝ lati mbatl ki tǝn pǝli' shilǝn tǝn zhillinǝn. ");
INSERT INTO zbu_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Amma mul kina Lisiyas kǝm shilǝni u i' mbǝ i' kanti ɗǝ mami nǝdǝlti. ");
INSERT INTO zbu_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","In ka cetti nǝ gawagu, kǝn ma' bali tǝn mus ulnǝ mi dlǝmti tǝntu.” ");
INSERT INTO zbu_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","I na Yahudawa yen pǝ kal ki shilǝnisi, is ndǝgi shilǝni nǝguɗa. ");
INSERT INTO zbu_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Nǝ gobnayi ndǝgiti tǝ' shilǝn u, “I Bulus usu, amani hwon dimbǝlli ka tle pǝli' mbalǝn i shilǝn i. Nǝ hwol mbatl kǝn ta pal shilǝn ini. ");
INSERT INTO zbu_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Kimanini a ngǝl muttu kult nǝ lob nǝ patl tai ini a Ulshelima ɗǝ shilǝn nǝ Lya wai. ");
INSERT INTO zbu_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Mi' mbǝtl shilǝn i sa mbi ɗǝ shot bi nǝ tlilt gatl lya nǝ mbalǝn age' libi ki Lya wai, nǝ age lu dopga ki Yahudawa nǝ age' gatli. ");
INSERT INTO zbu_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Sǝ'kǝn ma' dlǝmi'ki ulnǝ lakiɗa is mbǝllǝn ɗa makuwai. ");
INSERT INTO zbu_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Amma a ndǝgi, nǝ shitu u nǝsi mbeti ki ‘Dalika u, nǝ ami bǝtl Lya ki kolsi i nǝn ɗa u, ami lati mbatl nǝ mus ulnǝ ki laci ge zhil ki Musa nǝ ge lwatbat ki mi' nje shinkǝn ki Lya u. ");
INSERT INTO zbu_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ami la'ti mbatl nǝ Lya, kan u nǝ gi ɗǝ La'ti mbadlu, nǝn tlǝtl mi'mǝshti, mi'zo'mbadli nǝ mi'besǝn mbadli. ");
INSERT INTO zbu_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Gaki nǝgu, ko a nǝmi ami ɗǝtl mbadli gaki ɓadǝm ulkǝ dlǝmi ma' mbalǝn nǝ ma' Lya. ");
INSERT INTO zbu_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Kal ki zati Ulshelima nǝ hwon ten ngulen, Ya paltya ta ɗǝtl mbalǝn inǝn, a bǝlsi ulki toh ini nǝ ulki keli' Lya. ");
INSERT INTO zbu_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","A mi ge' pǝlti nǝgu is mbi nǝ ki peshti age' libi ki Lya. Bǝ ami ɗa ne' hwu' mbalǝn wai bǝ a tlili mbalǝn mbadlwai. ");
INSERT INTO zbu_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Amma Yahudawa yen ɗa tye'ge' atl ki Asiya, ginǝ a mbuni asi ki a kina ɗa'ka, si tǝlla shilǝn i ma'ki ǝn shilǝn won nisiɗa tǝnkǝn u. ");
INSERT INTO zbu_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ko aza Mbalǝni sǝ' dlǝb lati asǝn giɓi u nǝs mbi nǝ nali u, gasi u nǝ a dlǝl kina ki mi'dlǝtl shilǝn u, ");
INSERT INTO zbu_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Atǝn shilǝn nǝmon kǝn katl na tlǝl yali a ami ki dlili akina ɗa si, ya usu ‘Gaki tlǝtl lya ki mi' mǝshti si pǝlitǝn shilǝnɗa akina wakǝn a sǝtti.’ ” ");
INSERT INTO zbu_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Pilikus nǝ dǝm niki timul ma'lǝɓa a tǝn shitu u, i' dlǝtlsi. I' usu, “In Lisiya mulkina a mbǝ u,” “An poci'kin shilǝni.” ");
INSERT INTO zbu_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ibbǝl bal mul kǝndǝ'dlom bǝl zhil tǝl le Bulus, amma ibbǝltti mbul ki tǝza' yelǝnsi wasi sǝmɓǝ sǝ ngawi' wunnǝ ti lyamti u. ");
INSERT INTO zbu_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Kalkǝ lǝb mutti i Pilikiya mbǝnǝ kǝliwasi Dulisila, yakǝn Yahudiya. I' shin shin kǝn sǝ'mbǝlli' Bulus i' gakki' kǝm tǝn la'ti mbatl nǝ Almasihu Yesu wasu. ");
INSERT INTO zbu_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Nǝ Bulus ɗǝ dlǝb ulkǝ zoki, nǝ ngapti ga nǝ zǝ' ɓatltu nǝɗǝ bǝtu, I Pelikus kum ɓulti i' usu, “Nǝ guni apǝ i! Kǝn ma'zǝ'ga. In a mbi mbulu an ta'ki ki bi.” ");
INSERT INTO zbu_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Gaki ti la'ti mbadli ɗǝgon a Bulus bǝlti ulpi, i lakiɗa i' gob takinti biɗa ati shilǝn siti. ");
INSERT INTO zbu_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Kalki hown lob, Bolkiyes pestas nje Pilikus. Pilikus ne gaki ngau holhuwla ma' Yahudawa i'za' Bulus age' lukǝndǝn mbalǝn. ");
INSERT INTO zbu_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Nǝ Pestus mbǝ'ci ge' atlwasu, Kal ki mutti maki i' za' Kaisaliya illǝ Ulshelima, ");
INSERT INTO zbu_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Iki i bas lǝɓasi nǝ mi'kina ki Yahudawa is tǝla shilǝn ki Bulus ma'ti. Is bǝl Pestus bi ");
INSERT INTO zbu_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","tǝ' ɗǝlsi, sǝm mbǝl Bulus a Ulshelima, amma is kǝndi tǝ gen hwun tǝn shitu gaki sǝ' tloti. ");
INSERT INTO zbu_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Amma i Pestus ndǝgi i' usu, “Bulus ki i dle Akaisaliya, ami nǝ gayini ami lyab lǝti tyaka ge' muttuni. ");
INSERT INTO zbu_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Hwe tǝ na mi'kina wakǝn mbǝ ne' kǝni, in a mbi mullisi nǝ lati asǝn giɓi u as mbǝl shilǝn wasi.” ");
INSERT INTO zbu_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Pestus a ngǝtl mutti usǝpsi ko kutl a tine'siwai, i lǝ Kaisaliya. Lucili i' totǝn kundǝn guntwasi, illaki sǝm mbǝl Bulus a kina ɗa'ka. ");
INSERT INTO zbu_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Nǝ Bulus tette' giɓi u, I Yahudwa ginǝ mbǝ te' Ulshelima i is gadǝl ti galgal. Asi mbǝtl shilǝn dimɓǝli tǝnti besni, gini sima bǝs Mani wai u. ");
INSERT INTO zbu_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","I Bulus dlǝli gawasi: i' usu “Amiɓo a lew nǝ zhil ki Yahudawa wai ko libi ki Lya ko Kaisallwai.” ");
INSERT INTO zbu_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Pestus, ne gaki ngau hwol hwula ma' Yahudawa, i' ul Bulus su, kǝn ndǝ'ti ki'su Ulshelima sǝp pǝli shilǝn a kina ɗaka tǝn usi nǝsi zi'ki gawa?” ");
INSERT INTO zbu_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","I Bulus usu: “Nǝgun u ki dlǝli ami ɗa abidla shilǝn ki Kaisal, a ge'lu unǝ mbuni tǝ pǝli shilǝn ɗa u. A pǝli Yahudawa ulǝn wai, ki gawagi ki mani nǝguɗa. ");
INSERT INTO zbu_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","In lati asǝn gibi i u atala tlotu, ai, a kǝn dlali mǝshtwai. Amma in bal shilǝn nisi ɗa tǝn ulnǝ si ngauti tǝn kǝn u wai u, to mul bǝtl Yahudawa ami ɗawai. Ya ngayi tǝ mbǝl' shilǝn ini a kina ɗǝ Kaisal!” ");
INSERT INTO zbu_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Kalkǝ shilǝn ki Pestus ne' mi'dlǝdl shilǝn wasi, indǝgi i' usu, “To ka ngayi tǝ tala shilǝn wa' kina ɗǝ Kaisal. To ma' Kaisal kǝn ki'lǝ!” ");
INSERT INTO zbu_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Nǝ tlǝp mutti tenngulen u, i Guu Agaliba nǝ Banis is mbǝ Kaisaliya gaki sǝ' uli Pestus ɗem. ");
INSERT INTO zbu_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Is lǝm mutti tyaka diɓǝlu, iki i Pestus dlǝm shilǝn tǝn Bulus isǝ Guu. I' usu: “Mulǝn aki gunǝ Pelis za'ti ge'lu ki ndǝ mbalǝn. ");
INSERT INTO zbu_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Na lǝ Ulshelima u, i bas laɓasi nǝ kolsisi ki Yahudawa is mbǝl shilǝn tǝnti, is usu ta poci' shilǝn. ");
INSERT INTO zbu_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Amne ya ulsisu Lomawa aku ɗǝ pǝlt guwai, tǝ'zi mul lati asǝn giɓi ɓatltwai, gaki tǝla' mulǝn ɗǝ hwol tugwai, sai nǝti nǝ mi'pǝlti nǝ shilǝn sa mbǝ sa makina ɗǝ pǝtl shilǝn, ammbi abmbun gawas tǝn shilǝn u nǝs mbǝli tǝntu. ");
INSERT INTO zbu_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Nǝs mbǝ kummwasǝn u, a dǝmbǝl shilǝni wai, citl ki lu ya totǝn kundǝn guntini ya bǝl zhil sǝm mbǝli mulisi. ");
INSERT INTO zbu_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Nǝ mi'ship shilǝn hilya u, a kum bezǝn shilǝn u nǝ a la'mbadli sǝn dlǝmti tǝn tuwai. ");
INSERT INTO zbu_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Sai hwu'shilǝn yen kǝn sǝ mbǝlli tǝnti tǝn bǝtl Lya wasǝn, nǝ mulǝn kise Yesu, gunǝ mǝcu, amma i Bulus dlǝl katl tǝn ta mǝcuwai. ");
INSERT INTO zbu_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Amine a hol kan unǝ ta bǝl gǝs ki shilǝn u ɗa u i: Ya usu ko tǝn suti Ulshelima gaki sǝ' pǝllit shilǝn swaka. ");
INSERT INTO zbu_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Amma i Bulus ngayi sǝ' dlǝl shilǝn wasi, i Augustas ya shilǝn nisi, iki ya bǝl zhil sǝ' idlati sai gasi u nǝ a taki Kaisal ti u.” ");
INSERT INTO zbu_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","I Agilipa ul Pestus su, “Ami gayi ma ami lyap kup ulnǝ tǝ mulu dlǝmi u.” I Pestus usu Akyeu kǝn kubti.” ");
INSERT INTO zbu_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Nǝ citl kǝlu Agilipa nǝ Balniki is mbǝ age' naltwasǝn ki gunti is te'ge' kǝs ki dlǝl shilǝn ne' mi'kina ki dlati nǝ bas mbalǝn kige' gatli. I Pestus, bǝlsi zhil sǝn mbǝl Bulus. ");
INSERT INTO zbu_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","I Pestus usu, “Guu Agilipa, nǝ mus mbalǝn i nǝ ne' mini u, kǝn ɗǝ ye' muluwa gunǝ Yahudawa mbǝl shilǝn was a Ulshelima nǝ a ki a Kiasaliya, asi matltti ambuni tǝzati tǝ' dǝm tǝn diwai. ");
INSERT INTO zbu_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","A yen ulnǝ' pǝli i a kǝmmǝsh tuwai, tun nǝ ti nǝ gawas kǝn tǝ ngauyi sǝ' palshilǝni akina ki Augustas, ya usu an takkitki tiswai. ");
INSERT INTO zbu_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Amma ulǝn niɗa gunǝ ta laci mul ban ini gawa suwai. Tǝn gaki nǝgu ambǝlti kina wakǝn ɗa, nǝ akina ɗa'ka Guu Agilipa, ko gaki kal ki gyepti an ammbi ulnǝ talaci u. ");
INSERT INTO zbu_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Tǝn yati ini, ndokkǝkkǝni tǝta' mul ki kǝndi bǝnǝ mbitti nǝ ulnǝ' pǝli uwai.” ");
INSERT INTO zbu_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Iki i Aglippa ul Bulus su, “A ndǝgi ki'shilǝni a'dlǝli gawagi.” I Bulus ta'toh lya I'gob shilǝn I'usu: ");
INSERT INTO zbu_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“A mbi zo' asǝn i Guu Aglippa, nǝ dǝmniki akina ɗa'ka ta dlǝli ta shilǝn asǝti u tǝn mus ship shilǝn u nǝ Yahudawa pǝli u, ");
INSERT INTO zbu_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Nǝ dǝm niki Ki mul ma' lǝɓani ge'dǝb ki Yahudawa u nǝ shilǝn wasǝn u. Ami ngepki ki' ga'ki kǝm nǝ ngaptibi. ");
INSERT INTO zbu_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Mus mbalǝn ki Yahudawa sǝman dǝmtini a ɗǝ ya'ni, tun tlǝ tini age atlini, nǝ a Ulshelima. ");
INSERT INTO zbu_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Sǝman nǝni tun teɗe ǝn sǝn dlǝb ulnǝs mani tǝnkǝn u, Sǝmani ami mul bǝtl ɗalika mul ndǝl tuni ge' bǝtl Lya inǝn, a pǝlǝn dǝpkǝ mul palisa. ");
INSERT INTO zbu_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Nǝguni tǝn gaki la'tti mbadlǝ tǝn dlǝlliti u nǝ Lya pǝli mi'zǝ' mi'zǝm mini u i lakiɗa ami ki dlǝli tǝ pǝli shilǝn ɗa asǝti. ");
INSERT INTO zbu_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Guki dlǝlliti ki bi inǝn kutl nǝ lop ginǝ ɗǝ la'ti mbatl nǝ bǝtl Lya gasi nǝ dloncin si la'ti mbadli sǝ'en njikǝn twasi. Guu Aglippa, gaki la'ti mbaldlu Yahudwa ɗǝ pǝltǝn nǝ shilǝn ɗa. ");
INSERT INTO zbu_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Yalaki ɗa tǝn yenti wakǝn Lya kǝn ma'tlil mi'mǝshtwaiya? ");
INSERT INTO zbu_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Teɗi ammi gayi ni ya yeni kǝnǝ mbunni tapǝl lǝɓa iye' ki kon nǝshin ki Yesu mul nazalat. ");
INSERT INTO zbu_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Nǝgu apǝli a Ulshelima. Tǝn ndǝ'ti ki bas lǝɓasi ala' mbalǝn mi'bǝtl Yesu kal dimbǝli age'lu kǝndǝ' mbalǝn, hal ɓal tlwassi u, ami pǝ' kal ki nǝgu. ");
INSERT INTO zbu_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Cin diɓǝli atle bǝtl lu dobga ki Yahudawa a ami pǝlissi ngashti, ami la'tisi sǝn nge Lya. Gaki kub dutugwasǝn, a ami bǝtlsi kali hal tyage' atlen a ami pǝli'si ngashti. ");
INSERT INTO zbu_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Age' nǝguni, ami lǝ' Dimaskus nǝ ndǝ'ti ki bas lǝɓasi nǝ shinkǝn wasǝn. ");
INSERT INTO zbu_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Adlocin, Guu Aglippa, ami tǝn shitu nǝgu, yayen chilti sul lya, ngǝtl chin, nǝ chilti, ɗǝ chitl a malgǝn ini ne' elsǝni dutini. ");
INSERT INTO zbu_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Musi nǝn in nda atli, yakum yalon ɗǝ ussu nǝbi ki Alamai, ‘shaulu, shaulu, Yaki pǝlitǝn besǝn lǝɓaɗa? Bǝna ki ɗa katl nǝki nge tǝn u.’ ");
INSERT INTO zbu_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Ya usu ki okǝni, mul nalti?’ I mul ban usu. “Amiki Yesu, gunǝ ki pǝlitǝn ngashtu,’ ");
INSERT INTO zbu_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Hilya ki' dlǝl tǝn Asǝn wagi. A mbǝn ma'ku ki'dǝm mul kyautǝn i ɗani, a' dlǝm ulnǝ' eni tǝnkǝn u ɗa, nǝ ulnǝ ta dlǝmi' a kina ki u. ");
INSERT INTO zbu_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","An pekǝtl ki ɗǝge' mbalǝn wagi nǝ ginǝ bǝ Yahudawa wai u, ginǝ tashin ki swa ma si u. ");
INSERT INTO zbu_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Gaki ki' ɓulisi dwaɗǝn, sǝppete ɗǝge' dǝmshal, as paltya' tǝn chilti, as pe'ɗǝge' gukki shedan as paltǝn guk ki Lya, nǝnǝgu nǝn pacisi besǝn laɓa wasǝn ɗa sǝn dǝm ne' mus nǝginǝ peshsi u, tǝn gaki sa la'mbatl nǝ ami i.’ ");
INSERT INTO zbu_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Gaki nǝgu, Guu Aglippa, a nge ndǝ'ti nǝ tlu'tu nǝ pe'sul lya uwai. ");
INSERT INTO zbu_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","A Damascu a pisi shilǝn ki Lya pa, nǝ a Ulshelima nǝ mus alt ki Yahudiya, a pa ya pǝli mi'ginǝ bǝ Yahudawa wai u, shilǝn ki Lya sǝ'za'pǝtl bezǝn lǝɓawasǝn sǝ' palte' ma' Lya aspǝl kyautǝn u nǝ mbo'totin patl te ma' Lya wasǝn u. ");
INSERT INTO zbu_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Gaki nǝgu Yahudawa goppǝn ɗa a ge'libi ki Lya is ngayi sǝ'tloɗa. ");
INSERT INTO zbu_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Amma i Lya ɗǝlǝni hal i mbǝl nǝguni; i laki ɗa ami dlǝmi' mbalǝn shilǝn ki Lya bazi nǝ mil a ami dlǝb ulnǝ bǝ a shoti nǝ mi'nje'shinkǝn ki Lya nǝ Musa dlǝmi nǝn ndatu. ");
INSERT INTO zbu_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Sǝ usu Almasihu nǝn tle' bǝna ti hilya ɗǝ ge'mi'mǝshti pa, atl dlǝmi Yahudawa cilti ki pe'ti nǝ ginǝ bǝ Yahudawa wai u.” ");
INSERT INTO zbu_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Bulus age' shilǝn kǝn ngu, i Pestus tlǝl yali nǝ ndǝlti i ultisu! “Ki Bulus ga a gǝliki, “Pǝtl lashtiwa' eye u ɗǝ gǝlli'ga.” ");
INSERT INTO zbu_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Amma i Bulus usu. “Mulnalti Pestus,” Ga a gǝliwai, “Balini ami dlǝmti nǝ mbatl nǝm. ");
INSERT INTO zbu_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Guu Aglippa amma' shilǝn nǝki nǝ mbatl nǝm. A mani ka zi mus usi nǝ dwaɗǝ, pǝlin dli ki hwundǝliwai. ");
INSERT INTO zbu_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Guu Agilipa, ka ndǝ' ni nǝmi' nje shinkǝn ki Lyawa? Amani ka ndǝgi.” ");
INSERT INTO zbu_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","I Agilipa ul Bulus su, “Kǝn ɗǝ yenti ge' yakǝn cin u kǝn la'tǝni adǝm Kilista ya?” ");
INSERT INTO zbu_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","I Bulus usu, “Ko ge' yakǝn cin, koge' pya'si, ami shilǝn nǝ Lya bǝ ki nǝmwai nǝ mus ginǝ ɗǝ gakti kǝm asǝti u, sǝn dǝmti kǝnǝ ami, kidai bannǝ zhim domu.” ");
INSERT INTO zbu_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","I Guu hilya, nǝ mul kina Pestus nǝ Balniki, nǝ ginǝ ki dǝmi ne'tu. ");
INSERT INTO zbu_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Kalkǝ za'ti kǝb swasǝn, is pal shilǝn ne'elsǝni, “Mulgu tapǝl ulnǝ tǝ mbalǝn tloti ko kǝndǝ'twai. ");
INSERT INTO zbu_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agilipa ul Pestus su, “Tǝ gaki tǝ ɓewlǝn shilǝn u kina ma' Kaisal lwai u, a ndali tǝ za' mulu.” ");
INSERT INTO zbu_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Nǝ kǝndi ɗǝ hilya ɗǝ su' Italiya ge' kundǝlǝn ki malu, is ta' Bulus a toh ɗǝ bal mul kǝndǝ' dlom ne' na mi' ginǝ ge' kǝs kǝndǝ' mbalen u, mulshin Yuliyas, nǝm age' mi' kǝndǝ' dlom ki domga ki Agusta. ");
INSERT INTO zbu_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Nǝn te ge' kundǝlǝn te' Adalamatiya mul lyap su'ge' gatlen a malgǝn Asiya u, in gob lǝti, a Alistalkus mul Tasolonika won ki atl ki Makidoniya, tine' mi. ");
INSERT INTO zbu_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Nǝ lucilu in mbǝci a Sidom. Yuliyas ne ippǝli Bulus ulki zoki, is za'ti tǝs su ma yelǝnsi wasi gaki sǝ' ɗǝlti ɗa. ");
INSERT INTO zbu_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Nǝn tlǝ aki age' kundǝllǝn ki mallu gaki ki etǝl tlǝtl tetǝn kina inǝn, in gandǝl tu kal calgatl ki Kublus. ");
INSERT INTO zbu_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Nǝn peɗǝ ge bal mallu nǝ nja nǝ atl ki Kilikiya nǝki Bampiliya u, in mbǝ'ci Mila a ge' atl ki Likiya. ");
INSERT INTO zbu_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Bal mul kǝndǝ' dlom mbi kundǝlǝn ki Iskandaliya mul lǝ' ge' altki Italiya, illa'mi a giɓi. ");
INSERT INTO zbu_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","In lǝm mutti ami lǝti' ten ten, nǝ ngeskǝn mǝ mbǝci nja nǝ Kinidas. Nǝ bǝ yetǝl a zamiwai u, in gandǝli akal calgatl ki Kalita nja nǝ Salmoni. ");
INSERT INTO zbu_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Nǝ nges kǝn mǝ ɓew nja nǝ bǝgasi in mbǝci ge' lu u nǝ ɗǝ mbeti hwu' ki zoki, nja nǝ gatlt ki Lisiya. ");
INSERT INTO zbu_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nǝ dǝmniki lǝtisi a dlewtwai u, lǝti sima i' dǝm ulki ci' ɓanti, cinkǝ ngaptibima a ɓewyi, i Bulus dǝlisi kǝm, ");
INSERT INTO zbu_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","I' ulsisu, “Ami yenti lǝtinǝn u nǝn dǝmti ulki ki ci' bulti, bǝ hwotl lǝɓa nǝ kundǝlǝn ki malu katlwai, nǝ dli inǝn ma.” ");
INSERT INTO zbu_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Amma bal mul ki ndǝ'dlom a ndǝ' nǝ ulnǝ Bulus dlǝmi u wai, tǝ gǝtli nǝ kub shilǝn ki mul kundǝlǝni nǝ mul dǝtl kundǝlǝn u. ");
INSERT INTO zbu_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Nǝ dǝm niki lu hwuntu a mbuni kundǝlǝn i' sǝ' ci watlǝn agimbi wai u, mbalǝn diɓǝli is mbǝl shilǝn sǝ'tlǝ ɗǝki, kowongi si ngashti bi mbǝci tya Ponokiya sǝ'dǝm tya ka. Age' lu hwu ki calgalt ki Kalita, gunǝ ɗǝya' bǝgasi ki alewa nǝ kudu u. ");
INSERT INTO zbu_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Nǝ yetǝlu gop hotti te'ɗi ten ten u, tǝn lati mbadl ki mbalǝnisi sambi ulnǝ si lyamti u i; is dǝl kundǝlǝn ki mali nǝ kali nǝ zhim dom is bǝli tya malgǝn calgalt ki Kalita nja nǝ bigasi. ");
INSERT INTO zbu_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Alǝm dǝmtwai, i bal etǝl tlǝtoh ge' calgatli gunǝ ɗǝ mbeti ki Yulokilidon. ");
INSERT INTO zbu_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Nǝ etǝl li' ku ndǝllǝn ki malisi u, hal taman nga'ti etǝli ndan wai, in zaki katl i etǝlli si go' jakǝnmi. ");
INSERT INTO zbu_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nǝn bǝli kal yakǝn calgatlon u mulshin Kauda, lu unǝ etǝl bosɗa u, nǝngeskǝn mi dlǝl ya kǝn kundǝllǝni. ");
INSERT INTO zbu_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Is sul yakǝn kundǝllǝnni swa ge' bali u, si kupɓanti is kǝ'kǝndǝ zhim is gandǝl bal kundǝllǝni ɗa, gaki ɓa suge tisǝn ki bǝgasi ki Siltis mul sǝga' mus lǝɓa, iki is shit luluti ki tǝn kǝndǝlǝnnisikǝ tǝn gaki tǝ yetǝl jakǝn kundǝlǝni siɗa. ");
INSERT INTO zbu_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Gaki bundǝlǝn mul ndǝlti ɗǝ kundǝlǝnni eye', nǝ citlkǝlu i mi' ndǝtl kundǝllǝni gop utti kaya taka swage'mal. ");
INSERT INTO zbu_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Nǝ mutti maki nǝ toh wasan kǝn sǝdla' ul kyautǝn ki kundǝllǝni taka. ");
INSERT INTO zbu_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Mutti di ɓǝli mayen cin nǝ cadlǝllwai, sai bal yetǝlon kǝn ɗǝ li'ti mi, in pe'kǝl mbadl ki pe'ti. ");
INSERT INTO zbu_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nǝ dǝm niki alǝm mutti ba ɗap ulki ɗami, i Bulus hilya gal adlom ɗa si i'usu: “Mbalǝn, tǝ'ka kumǝn shilǝn i u tǝn bǝ zakǝn calgatl ki Kalita wai u, da kǝ'kǝn ndati ge' ulkǝ ci' bultuwai nǝ hwol lǝɓa u wai. ");
INSERT INTO zbu_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ammi ndǝllǝn mbadli, gaki nǝgu mullǝn gudǝl nǝm kǝn gǝtl age' kini wai, sai dai tǝ hwol ku ndǝlǝni. ");
INSERT INTO zbu_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Age' gaski hwuɗi mul shikǝn ki Lya shilǝn nǝ ami. Ami zheli ki Lya kǝni, ti ami pǝlitti bǝna. I' shin mul shinkǝ wassuɗi tǝm mbǝ makǝni. ");
INSERT INTO zbu_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","I usu, ‘Bǝkum ɓantwai Bulus. Kǝn dlǝlti kina ɗǝ Kaisal, i ngu Lya a kumki ta ndǝgi mus yelǝnsi lǝtwagi sǝn pe'ti.’ ");
INSERT INTO zbu_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Gaki nǝgu ndǝllǝn mbadlwakǝn, kini mbalǝn, a la' mbatl nǝ Lya tǝn ussu, kan u nǝs dlǝmi u, nǝgu tǝ pǝldli. ");
INSERT INTO zbu_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Amma nǝ ngeti etǝl nǝn la'timin tya tǝn bǝgasi.” ");
INSERT INTO zbu_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Age' gas ki mutti kutl nǝ upsi asi dǝtl mi age' dlǝlka ki Adaliya, abal gasi mi'dǝtl kundǝlǝni siyenti mǝ ɓal nja nǝ bǝgasi i. ");
INSERT INTO zbu_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Is cimbǝl lolu' ki mali is mbi asan kutl cen nǝm nǝ kutl lǝbi lop. Nǝn lǝ kina ten ngulen u is cimbǝli ɗaɗanu is mbi lolu tisi asan kutl lǝbi nǝtapsi. ");
INSERT INTO zbu_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Gaki kitǝli' li'ti zǝnga, is la' dom gudǝl upsi ki kal kundǝlǝni, is shilǝn nǝ Lya tǝ lu dlewti ɗǝ cilti. ");
INSERT INTO zbu_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Mi'dǝtl kundǝlǝni is ngau kitǝl ɗǝ ge' kundǝlǝni, hal sashi' yakǝn kundǝlǝn age' mali, gaki tǝ yen dli kǝnǝ sǝ shit dom ki bikina ki kundǝlǝni ni is za'si. ");
INSERT INTO zbu_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","I Bulus ul bal mul kǝndǝ dlom ki Loma su nǝ mi'kǝndǝ dlom, in mbalǝn i adlǝl ge' kundǝlǝn uwai u, ka mbǝ'cini ki' pe' twai.” ");
INSERT INTO zbu_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","I mi'kǝndǝ dlomi is ɓaɓatl zhim ki tǝn yakǝn kundǝlǝni is za' kundǝlǝni i mal kami. ");
INSERT INTO zbu_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Nǝ lu ɓal nja tǝ cilu. I Bulus ulsisu sǝn na'ɗam ulǝn, “A sǝti mutti kutl nǝ upsi ngu, aki dǝp ki ɓutti, bǝ ka ɗamǝn ulǝn wai.” ");
INSERT INTO zbu_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Gaki nǝgu ami shetl kini ki'ɗamini, gaki dliwakǝn, gaki nǝgu mulǝn gudǝl nǝm medlǝn ki gawakǝn kǝn gǝltwai. ");
INSERT INTO zbu_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Nǝtl dlǝmi nǝgu u, i' kan biledi i' shilǝn nǝ Lya akina wasan, i' chali it gop ɗamti. ");
INSERT INTO zbu_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Musswasǝn is kum ndǝlti, sima is ɗam ulki ɗami. ");
INSERT INTO zbu_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Musi nǝn age' kundǝlǝni mi kutl cen lop nǝ kutl lǝbi ningi nǝ mǝ'ka ni. ");
INSERT INTO zbu_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Nǝs ɗami nǝ kǝmsi u, is gop bosi' kundǝlǝni di ɓǝtl taka, is gop utti alkama swa ge' mali. ");
INSERT INTO zbu_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Nǝlucilu, saman atlu nǝsi lǝbi uwai, amma is yen luwon multisǝn is kǝndǝ shilǝn is ussu in mul pǝkkǝn u as tǝla kundǝlǝni atǝn tisǝni. ");
INSERT INTO zbu_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Is ɓaɓatl zhim domi taka is zaki age' mali, age' cini a si tǝngǝl ul jakkǝ kundǝlǝni, is tlǝl lulut ki tǝn kina ki kundǝlǝni tǝn kina yetǝl. Is nga bigasi tya. ");
INSERT INTO zbu_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Amma nǝm mbǝci gelu unǝ dlǝlka pǝl dandle u, is jakǝn kundǝlǝni i gami te'ge' tisǝn, hal kundǝlǝni taman utti nuwai i kal kundǝlǝni kan tatlti gaki tlitti ki bǝs ki mal. ");
INSERT INTO zbu_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Amma mi'kǝndǝ dlomi lyami sǝ'tlwa mi' ginǝ ge'lu kǝndǝ mbalǝn i, ɓas pe' ge' mali as kitǝli. ");
INSERT INTO zbu_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Amma nǝ bal mul kǝndǝ dlom ki Loma lyami tǝ pekǝl Bulus su, in nge. I' balsi zhil i' ulsisu mulnǝ man malu as ndaswa ge' malu as lǝ tǝn bigasi, ");
INSERT INTO zbu_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Gen ne is to'tǝn ancin ki kunɗǝlǝn genne tǝn use ki kundǝlǝnisi. Nǝnǝgu is mbǝci lau. ");
INSERT INTO zbu_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Kal ki ma pe'ti nǝn in kumi shin ki ɗani i ki Malta. ");
INSERT INTO zbu_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Mbalǝn ki lǝbi is pǝlimi ulkǝ zoki is njemi mus, is hwotimi utu gaki mal ɗǝ mbǝti a etǝtl kǝn ngu. ");
INSERT INTO zbu_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Bulus dwam ancin te'ɗi ti utti utu ngu, i uci won pe'toɗi nǝn kum utu i' gobpi Bulus toh. ");
INSERT INTO zbu_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Nǝ mbalǝn ki lǝbi yen uci a sǝnkǝli Bulus toh u, is ul elsǝnisu, “Mulu mul tlo' mbalǝn kǝni; ko nǝ' ta pe' ki bal malu, ngonǝnagu ngashtwas ɗǝ bǝtlti kali sai nǝ ta mǝci.” ");
INSERT INTO zbu_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Amma I Bulus dladla'toh wasi idldla'uci i swa utu amma ulǝn a mbitwai. ");
INSERT INTO zbu_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Mbalǝn ni ɗǝ yenti lǝbi nǝn kǝtti ko anda ammǝci, amma kalkǝ lǝb dǝmti nǝbǝ sa yen ulǝn a mbitwai u, is shilǝn ɗaɗanu is usu ti lya won kǝni. ");
INSERT INTO zbu_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Nja nǝ Lǝbi, lu ki mul kina ki ɗani i, mul shin Pubilus. Ti njemi a libi ɗakka, i' shimmi ge' nalti hal mutti maki. ");
INSERT INTO zbu_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Mulzǝ' Babiliyas tǝ ki muɗi atli ti gonti. I Bulus su mati, i' shilǝn nǝ Lya i' zi' toh ga i muli ndokki. ");
INSERT INTO zbu_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Nǝ nda nǝgu u, i mus ginǝ ɗǝ gonti kitǝn ɗa ni, is gop mbǝti asi mbi' ndo'ti. ");
INSERT INTO zbu_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Is nalmi tǝn shitu dimbǝli; nǝtǝn tlǝ ge' kundǝlǝn ki malu, is domimi mus ulnǝ mi lyamti u. ");
INSERT INTO zbu_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Kal ki limaki in tlǝ ge' kundǝlǝn ki mali ki Iskandaliya, gunǝ ci watlǝn atǝn ɗani u. A pǝli' lwaɗi kǝnǝ ngugǝs ki lyayen. ");
INSERT INTO zbu_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Nǝm mbǝci silakusu in mu'maki alǝbi. ");
INSERT INTO zbu_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Nǝn za'lǝbǝ u in gandǝli mingu sai a Lhegium. Nǝm muɗu, i etǝl tlǝte'kudu Nǝ lucilu in mbǝ'ci a puteoli. ");
INSERT INTO zbu_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","A kikǝn mǝma ne'elsǝni mi'bǝlti, is ngyemmi tǝn pǝl mutti ningi ne'si. Nǝnǝgu immbǝci Loma. ");
INSERT INTO zbu_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Nǝ elsǝni inǝn mi' bǝlti ki Lom kum mbǝtinǝn u, is mbǝ sǝ ullimi ɗem hal Age'lu dobga ki Abiyus, gu nǝ si mbetti ki maciya maki. Nǝ Bulus ma ne'mbalǝ ni u, i'gode Lya i ndǝtl mbiti. ");
INSERT INTO zbu_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nǝn tye Loma u, i ndǝgi Bulus tǝ'dǝm tǝn gawasi nǝ mul kǝndǝ'dlom mul ɓuttiti u. ");
INSERT INTO zbu_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Kalkǝ mutti maki, i Bulus taki bas mi' kina ki Yahudawa bi. Nǝs domga u, I Bulus ulsisu: “Yelsǝni ini, ko nǝbǝ aleu wi mbalǝn inǝn mbadlwai u, ko pǝtl gokkǝ mi'zǝ'mini, ngonǝ nǝgu is goppǝni a Ulshelima is bǝl ami ki kǝndi a toh ɗǝ Lomawa. ");
INSERT INTO zbu_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Nǝs ngyemǝn u si' lyamti sǝ za kǝni, gaki a pǝl bezǝn ulnǝ tǝla tlotu wai. ");
INSERT INTO zbu_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Nǝ Yahudawa nge' ndǝtu, i dǝmi hwel ta tǝla shilǝn u a kina ɗǝ Kaisal. Gaki mbalǝn i kǝn ta tǝla shilǝni ɗawai. ");
INSERT INTO zbu_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","I laki ya lyam shilǝn ne ki ɗa, gaki zǝ' mbatl ki Isla ilawa i ami ki ki kǝndi nǝ zhim dom ɗa.” ");
INSERT INTO zbu_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Is ndǝgiti, “Miɓo ma mbi lwabbaton ma' Yahudawa gawagwai, mulǝn a mbǝl shilǝn wa' gi ge elsǝni inǝn wai, ko idlǝm besǝn shilǝn won tǝn kwai. ");
INSERT INTO zbu_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Amma mi lyamti tǝn kum shilǝn a bi wagi, mǝ mani mbalǝn hu a una si dlǝb bezǝn shilǝn tǝn pyal kushti kǝlagatu.” ");
INSERT INTO zbu_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Nǝs zǝ cin ki ma' ne' Bulus, sǝ' en Bulus age' cin u nǝs dlǝlli u, Is mbǝ nǝ mbalǝn diɓǝli age' lu unǝ tiɗa nǝ dǝmtu. I' pallisi shilǝn daga nǝ kyau hal a su'ti, ati dlǝmissi shilǝn atǝn gu' ki Lya, ati lyap shetlsi tǝ ndǝlsi te' ma' Yesu tǝn shitu zhil ki Musa nǝ lwabat ki mi'nje' shin kǝn ki Lya. ");
INSERT INTO zbu_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Gen is ndǝ nǝ shilǝn wasi gen ne is nge'ndǝtti. ");
INSERT INTO zbu_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Nǝs nge ndǝtti nǝ elsǝni ɗaɗɗasi u, nǝs ɓalkǝ sǝ'za' lǝbi u i Bulus dlǝmisi shilǝn nǝm i'usu, “Ase yal ki mbatl ki Lya a dlǝm bali, nǝ' dlǝmi mi'zǝ'mi zǝ'kini tu'bi ɗǝ Ishaya mul nje'shinkǝn ki Lya ɗǝ usu, ");
INSERT INTO zbu_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“ ‘Lǝma' mbalǝn i ki' usu, “Kǝn kumtini amma kǝkǝn mantini wai; kǝn yentini amma kǝkǝn mantini wai.” ");
INSERT INTO zbu_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Gaki mbatl ki mbalǝn i a ndǝndǝli, sa cak kǝmwa sǝn i sa idla dwaɗǝn wasǝn i. Gaki ɓas yeni nǝ dwaɗǝn wasǝn as kumi nǝ kǝmmwasǝn. Gaki sǝp mani nǝ' mbadlwasǝn as palte' makǝni a ndokǝlsi.” ");
INSERT INTO zbu_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“To manin ca, Lya shinkǝn ki pekǝtl mbalǝn, hal ginǝ bǝ Yahudawa wai u, sikuma sǝn ga'ti kǝm!” ");
INSERT INTO zbu_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","(Nǝdlǝmi nǝgu u, i Yahuawa hilya is gob shotibi ne' elsǝni.) ");
INSERT INTO zbu_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Hal hwon lop a Bulus ki dǝmi age' libi ki ɓatlti, ti nje'mus ginǝ mbǝ ma'ti sǝ' entu. ");
INSERT INTO zbu_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","A ti dlǝb shilǝn ki te' ge' gugkǝ Lya ati kulci' mbǝlǝn lǝɓa ki mulban Yesu Almasihu nǝ ndǝtl ki mbadli bǝnǝ ɓultwai!");
INSERT INTO zbu_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","Tuˈmaˈ Yakubu, zheli ki Lya, nǝ mulban Yesu Almasihu, swamak gǝs kǝ kutl nǝ lopi ginǝ dlaˈga tǝn dǝp lǝɓa u. shinniˈ mulnalti. ");
INSERT INTO zbu_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","Yelsǝni ini, ǝn undiˈ bǝna kǝ shoti a mbi kini u aˈ pǝllin hwol tugi, ");
INSERT INTO zbu_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","Kǝ manini cimbitl laˈti mbadlwakǝn u, nǝn ɗǝ zǝˈ ngashtibi. ");
INSERT INTO zbu_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","Ikǝ ngashtibi nǝn njikǝˈ kyautǝn wasi, nǝn laˈti aˈ dǝm mul nalti nǝ ngaptiga, i laˈti bǝ kǝkǝn hwotl ullǝn wai. ");
INSERT INTO zbu_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","In gonwakǝn a hwol maˈulǝn u, an ngyem Lya, mul bǝlti nǝ toh kǝ zoki , bǝnǝ laˈti biwai, Lya nǝn bǝtlti. ");
INSERT INTO zbu_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","Amma an gyemi nǝ laˈti mbadli, bǝnǝ cetl mbadlwai, gaki mul cetl mbadli kǝnǝ lakumi kǝgeˈ balmal kǝn siɗa, ginǝ etǝl ɗǝ katti u, a ɗǝ jakǝnti ");
INSERT INTO zbu_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","7","Bǝ undi mulu laˈmbadli tǝn mbiˈ ulǝn ama mulban wai. ");
INSERT INTO zbu_vpl VALUES ("JM1_8","089_1_8","JAS","1","8","8","Gaki timul mbatl lob kǝni, tiɗa zǝm mbatlwas nǝmmwai ageˈ lu mus kyautǝn waswai. ");
INSERT INTO zbu_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","Mul shindǝtl ga tǝppǝ ɓulmǝn nǝ nal twasi. ");
INSERT INTO zbu_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","mul usǝn tǝmpǝtl ɓulmǝn nǝshindǝtl gawasi, ama tǝm paˈti kǝnǝ buzhame. ");
INSERT INTO zbu_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","In cin a celga nǝ mattwasu, me nǝn kokǝnti, a buzhewas lwaki a mbuntwas gǝli. nǝgu tǝmul usǝn gǝli geˈ dlom kǝ tǝleti nǝ palliti wasi. ");
INSERT INTO zbu_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","Albalka tǝn mul ngacciˈ cimbǝtl bi, inta ngash bi geˈ cimbǝltu, tǝn mbiˈ ul kǝndǝ ga kǝ Gu kǝ mbidli, gunǝ mulban pǝli miˈ lyapti ndǝtu. ");
INSERT INTO zbu_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","In ka mbi cimbil tu, bǝˈ usu “Lya kǝn ɗǝ cimbitl ki wai.” Gaki Lya ɗa cimbitl mulǝn nǝ bezǝn lǝɓa wai, kǝn pǝti a cimbǝlǝn Lya nǝ bezǝn wai; ");
INSERT INTO zbu_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","Amma in mulǝn ambi gawas geˈ cimbiltu lawaskǝn shelti, a tle gawasi. ");
INSERT INTO zbu_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","Bezǝn lyap lǝɓa in apǝl tugu, nǝnzǝˈ byas lǝɓa. in byas lǝɓa analu nǝn mbǝtl mǝshti. ");
INSERT INTO zbu_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","Bǝs gǝl kini waica, mil yelsǝni ini mudli nǝ mwani. ");
INSERT INTO zbu_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","Mus mbuni bǝlti ki njǝˈni, sul lya kǝn ɗǝ peˈti, mul mbǝˈsum maˈ Mulban kǝ cilti, gunǝ bǝ ɗa shottwai u kǝnǝ gwasǝn mul shaˈti. ");
INSERT INTO zbu_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","Iˈ oli tǝp bǝlǝn min zǝti tuˈma shilǝn ki bali, gaki tǝn dǝmni kǝnǝ nyoh ki kina kǝ mus halitta wasi ");
INSERT INTO zbu_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","Mil yelsǝni ini mudli nǝ mwani, manǝngu: dleuwonkin ɗǝ gaˈti kǝm, bǝ dlewon kin ɗǝ shilǝn ko ɗǝ leutl mbadli wai, ");
INSERT INTO zbu_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","gaki leukǝ mbatl ki yakǝn mbalǝn ɗa talaˈti ɗǝ pǝtl kyautǝn ki zoki ki Lya wai. ");
INSERT INTO zbu_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","Gaki nǝgu, aˈ lakǝn mus kyautǝn ki bezǝn lǝɓa taka nǝ ngyem mbiti ki mbalǝn, shilǝn u nǝ dlilli geˈ mbadlwakǝn u, ndǝˈni nǝ nali geˈ shindǝtl ga, gaki tinǝ ndǝtl kǝ pekkǝtl dliwakǝn. ");
INSERT INTO zbu_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","Dǝmni miˈ petl shilǝni, bǝmiˈ kumti katlwai, aki shatl gawakǝn wai. ");
INSERT INTO zbu_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","gaki mus mulnǝ mul kup shilǝni katlu, bǝ mul pǝltiwai u, kǝnǝ mul nǝ ɗǝ yak kinawas age' boka u ni. ");
INSERT INTO zbu_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","gaki tǝn yak kinawasi azzǝga, alǝbi alǝbi am musni nǝ tetwasi. ");
INSERT INTO zbu_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","Amma mus mul nǝ ɗǝ yaˈ njikǝˈkǝ zhil ki mbiˈ ga u, inngash bi tǝnki u, tadǝm mul kumtikatl ammus niwai, addǝm mul pǝlti nǝ ɓotlti, gu sǝppǝliˈ albalka ageˈulnǝ ti pǝlti u. ");
INSERT INTO zbu_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","In mulǝn ɗǝ patl gawasi ti mul bǝtl Lya kǝn u, amma bǝ ta ngab biwaswai u, iki bǝtl Lya wasu bali wai. ");
INSERT INTO zbu_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","Bǝtl Lya ki zoki gunǝ bǝ bezǝn ulǝn ɗa giɓi wai u, akina ɗǝ Lya bwasinǝnˈ, iki kizi gulsi mudli, nǝˈ milu nǝ bǝ miˈ zǝssi ɗawai u, dwaɗǝn geˈ bǝna wasǝn u, aˈ pekkǝl gawaˈtaka ɗǝgeˈ bezǝn lǝɓa ki dǝp lǝɓa. ");
INSERT INTO zbu_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","Yelsǝni ini mudli nǝ mwani, miˈ laˈti mbatl tǝn Yesu Almasihu mul nalti, bǝˈ shimǝn otl elsǝni geˈ mbadlwakǝn wai. ");
INSERT INTO zbu_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","In mul ulkǝ shimi toh kǝ zinaliya nǝ luˈ lǝgǝl kǝ zokki a mbǝ geˈlu dobga wakǝn u, i mul nǝ bǝ ulǝn nidɗawai u a teteˈ kǝ dlili nǝ keci luˈlǝgǝlu. ");
INSERT INTO zbu_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","In ka ngǝtlin nǝ natl mul laˈti zoˈ luˈlǝgǝlu, iˈ ulǝn tisu, “Kundǝn kǝngu kǝ zoki gawagi,” Amma iˈ ulǝn mul nǝ bǝ ulǝn nidɗawai usu, “dlil tyaka” ko “kuma dǝm atli a kina ɗaka,” ");
INSERT INTO zbu_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","Ase bǝ otl elsǝni geˈ dlomwa kǝn nǝ dambǝtl kǝ ngashti ageˈ dlomwakǝn wai wa? ");
INSERT INTO zbu_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","Kumini yelsǝni ini mudli nǝ mwani: Ase, Lya wolǝn miˈ lǝshi ulǝn kǝ dǝp lǝɓa sǝddǝm miˈ usǝn geˈ laˈti mbadlwaiya? si kǝ miˈ mbiˈ guˈ kǝ Lya nǝ pǝl dlǝlti tǝn ginǝ ɗǝ lyapti uwai ya? ");
INSERT INTO zbu_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","Amma ki mbǝtl miˈgini bǝ ulǝn nisi ɗawai u. Ase, miˈusǝni ɗǝ mbitl kini waiwa? siɗǝ dǝtl kin twakina ɗǝ miˈpǝtl shilǝn waiwa? ");
INSERT INTO zbu_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","Si ɗǝ dlǝb shilǝn kǝ kabbi tǝn shin mul naltu nǝ ɗǝ mbekkin nǝ nali uwai wa? ");
INSERT INTO zbu_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","In ka shindǝlǝn ga tǝn kushti kǝ guˈ kǝ Lya u gunǝ geˈ shilǝn kǝ Lya kǝ laci u ɗǝ ussu, “lyam else dǝm twagi kǝnǝ gawagi,” ka pǝlin kǝ zokki i. ");
INSERT INTO zbu_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","Amma in ka pǝlǝn lyab ga geˈ dlomwakǝn u, ka pǝlǝn bezǝn lǝɓa u ngu, tǝn kushti kǝ Musa ka dǝmni miˈ cetl zhili. ");
INSERT INTO zbu_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","Amma mus mul nǝ ɗǝ katliˈ zhil kǝ Musa u, amma it cel gudǝl nǝmu, to mus ta cel zhilu ɓalu. ");
INSERT INTO zbu_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","To ti u nǝˈ usu, “Bǝ pǝl kontwai u” Ti usu ɗaɗa nu, “Bǝ tlo mbalǝn wai.” To, in kapǝl kontwai u, amma iˈ tlo mbalǝn u, to, ka dǝm mul cetl zhilu ɓalu. ");
INSERT INTO zbu_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","Gaki nǝgu, shilǝn wakǝn nǝ kyautǝn wakǝn tǝ dǝm kǝ miˈ ginǝ nǝn pǝlissi shilǝn kǝ zhil kǝ mbiˈ ga. ");
INSERT INTO zbu_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","Amma gas pǝtl shilǝn Lya kǝn zǝˈ gontwai maˈmulnǝ bǝ ɗa zǝˈ gontwai u. Amma zǝˈ gonti nǝn ɗǝ tleˈ ga kǝ zǝˈ ɓatlti. ");
INSERT INTO zbu_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","Kini yelsǝni ini, ya kǝ mbuntwasi tǝ yakǝn mbalǝn usu laˈti mbatl nidɗa, bǝ kyautǝn was ɗawai u? anya, laˈti mbadlwasu nǝn pekkǝtl ti wa? ");
INSERT INTO zbu_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","Cibǝlti, in yelsǝni mudli ko mwani, si dǝmti bǝ lulut nisi ɗawai u, hu anǝmi bǝ ulkǝ ɗami ɗa kǝpsiwai. ");
INSERT INTO zbu_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","In gon wakǝn a ulsisu,“To, mbǝkǝcin swaca, tǝ Lya bǝlkin ulkǝ ɗami nǝ ulkǝ tle, nǝ ulkǝ laki” Bǝka bǝlǝnsi ulǝnwai u, mbuntwas nuna? ");
INSERT INTO zbu_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","Nǝgu ɗa laˈti mbadli nǝm nǝ gwasi, bǝnǝ kyautǝn waswai u mǝcini. ");
INSERT INTO zbu_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","Amma mulǝn nǝn ussu“ ai, kiɓo laˈti mbatl niˈ ɗa, ami ne ɓo sai kyautǝn.” To, mboki toh tǝn laˈti mbadlwagu, bǝ nǝ kyautǝn wai u, ami ne a mbokiˈ toh tǝn kyautǝn, yenti kǝ dwaɗǝn kǝ laˈti mbadli. ");
INSERT INTO zbu_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","Ka ndǝgi Lya ɓo nǝm kǝma? A mbuni! to miˈgatl ma sa laˈmbatl nǝti i, amma hal si nepti kǝ dli nǝ ɓanti. ");
INSERT INTO zbu_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","Ki mul lǝshi maˈ ulǝn! ko kǝnɗǝ lyamti hal nǝguni kiˈmani laˈti mbadli bǝ nǝ kyautǝn kǝn wai u, use kǝma? ");
INSERT INTO zbu_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","Cin u nǝ bwasi nǝn Ablahim taˈ yakuwas Ishiyaku tǝn lu kyetl ulnǝ ɗǝ mbilliˈ Lya u, ashe gaki kyautǝn waskǝn manti ti mul zoˈ mbatl kǝn waiya? ");
INSERT INTO zbu_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","Ka yeni laˈti mbadlwas ɗǝ lǝˈ neˈ kyautǝn wasi, kuma laˈti mbadwas a njikǝn tuˈ maˈ kyautǝn wasi. ");
INSERT INTO zbu_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","I njikǝn shilǝn kǝ Lya nǝ usu,“Iblahim a laˈmbatl nǝ Lya i, laˈti mbadlwasu i ɓildli mbatl kǝ zokini maˈti,” I mbekki yelǝn ki Lya. ");
INSERT INTO zbu_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","To ka yenini, Lya ɗǝ pekkǝtl yakǝn mbalǝn gaki kyautǝn wasi, bǝ gaki laˈti mbadlwas nǝmwai. ");
INSERT INTO zbu_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","Gaki nǝgu Lahab mul pǝn neˈ mwani mbi peˈti gaki kyautǝn wa swaya? nǝn nje miˈshinkǝn i u, ippekkǝlsi tuˈtǝn shitu won. ");
INSERT INTO zbu_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","Kǝnǝ kan unǝ dli ɗa bǝ lu shuˈti nidɗa wai u hwunini, nǝguma laˈti mbadli bǝnǝ kyautǝn wai u hwunini. ");
INSERT INTO zbu_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","Kini yelsǝni ini, bǝ dǝmni kumwakǝn miˈkulciˈ mbalǝn wai, gaki manti wakǝn kǝni, mi miˈkulciˈ mbalǝn nǝn pǝlimmi shilǝn nǝ bǝna iye. ");
INSERT INTO zbu_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","Gaki musinǝn mini miˈlwetini diɓǝli, in yakǝn mbalǝn ɗa dlǝb use geˈ shilǝn wa swai u, to muli kǝ njǝˈni tiɗa, tǝn maˈngapti mus kutlakǝn ki dli wasi. ");
INSERT INTO zbu_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","Cibǝlti ngu, in a shimi bǝs ul kǝndǝ bi u gaki tǝˈ kumimi bi ɗani, nǝnǝgu mǝn maˈbǝlti nǝti mus lu u nǝmi lyamti u. ");
INSERT INTO zbu_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","Nǝ yanǝn kundǝlǝn kǝ mal, ko nǝ si bazi u ndǝtl kǝ yetǝl ɗǝ jakǝˈsi, mus nǝnǝgu nǝ yakǝn domkǝn mul dǝlti ɗǝ gandǝtl ti mus lu u nǝ tin ngaki ɗa u. ");
INSERT INTO zbu_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","Nǝ gu lǝga ma ɗa, tigu yakǝn ulǝn kǝni, sai bas laˈtibi! yanǝn kan unǝ yakǝn masɗi ɗǝ lakik bal dǝlgǝn utu u. ");
INSERT INTO zbu_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","Lǝga ma utu ca! Ageˈ mus ku tlakǝn kǝ dli inǝn, lǝga tikǝ gǝskǝ bezǝn lǝɓa ti kon nǝ mus dli, mul hotti mbadli atliti, tine libi kǝ utu ɗǝ hottiti. ");
INSERT INTO zbu_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","Yakǝn mbalǝn nǝn maˈ tlegga kǝ mus lǝɓa kǝ dǝlgǝn nǝkǝ ban, nǝkǝ geˈ mali nǝ yadli nǝ miˈ dǝtl tugi. ");
INSERT INTO zbu_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","Amma yakǝn mbalǝn kǝn maˈ tlegga ki lǝga wai, ngashti ni gunǝ bǝkǝn maˈ dlǝtl ti wai u, kǝ njiˈni ɗa nǝ igǝn kǝ tloti. ");
INSERT INTO zbu_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","Nǝ nali mi natl mul ban nǝ bwasi nǝn, nǝ nali mi byatl mbalǝn ginǝ pǝlsi geˈ teˈkǝ Lya u. ");
INSERT INTO zbu_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","Nǝ bi nǝm kǝn ɗǝ natlti, nǝ byalti ɗaɗanu, yelsini ini, ai, gu a mbunwai! ");
INSERT INTO zbu_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","Ko shu mal nǝm nǝn maˈ bǝtl mal mul tǝmtǝ, nǝ mal mul kukkudu ya? ");
INSERT INTO zbu_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","Mil yelsini ini, pǝkkǝ ka nǝm maˈ utti mil kǝ zaitu ya? ko pǝkkǝ innabi nǝm maˈ zǝm mil kǝ ka ya? Tuˈ nǝgu shu mal mul bǝtl mal kǝ kukkudu kǝn bǝtl mal tǝmiwai. ");
INSERT INTO zbu_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","Mul manti nuna nǝ mul kal lǝɓa laplap a geˈ kini? An mboˈ tohtǝnki tuma zoˈdǝm twasi, nǝ kyautǝn kǝ zoki gunǝ ti pǝlti nǝ shindǝtl ga gunǝ ɗǝ peˈti geˈ ma' ulǝn u. ");
INSERT INTO zbu_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","Amma in bezǝn nget mbalǝn nikin ɗa nǝ lyap ga u ageˈ mbadlwakǝn u, bǝˈpǝn ɓulmǝn nǝ nǝ guwai, aki nget baliwai. ");
INSERT INTO zbu_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","Undi manti gu sul lya kǝn ɗǝ ndassuɗwai kǝ dǝp lǝɓani, kǝ lyap mbatl kǝni kǝ sheɗan. ");
INSERT INTO zbu_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","mus geˈlu unǝ nget ɗa nǝ lyap ga u, alǝbi dlati nǝ mus bezǝn lǝɓa ma ɗa. ");
INSERT INTO zbu_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","Amma manti kǝ sul lya u, kǝ kina kǝ zokini, mul shindǝtl ga kǝni, mul natl kǝ ga kǝn wai, mul zoˈ mbadli, mul lyap dǝb kǝ zoki, alhelini, mul zoˈ mbadli mul bi nǝm, mul pǝtl bali, mul nǝ bǝ ɗa wotl mbalǝn wai u. ");
INSERT INTO zbu_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","Undi mutti kǝ mbadli gunǝ u miˈ bwasti dlati ɗǝ watlti u, i mbǝtl zoˈ mbadli. ");
INSERT INTO zbu_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","Yakǝn ɗǝ mbǝtl ngeˈ elsǝni nǝ dlati a geˈ dlomwakǝn? ase, bǝ lyap lǝɓa hukkǝn ɗǝ latikin ɗǝ dlan nǝ yelsǝni ambadwakǝn wai ya? ");
INSERT INTO zbu_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","Kǝn lyap lǝɓa aˈ hwolini, aˈtlo mbalǝn. kǝn lyap lǝɓa, bǝ kǝkkǝn mbitini wai, aˈ tlilǝn dlati. Ki hwoltini gaki ki ɗa shilǝn nǝ Lya wai kǝni. ");
INSERT INTO zbu_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","Kǝn shilǝnti nǝ Lya aˈ hwolini, gaki ki nǝ bezǝn mbatl kǝn ki pǝlini, gaki ki konni nǝ nali tǝn kup tǝp kǝ gawakǝn. ");
INSERT INTO zbu_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","Kini miˈ lǝshi zoˈmbadli! Ki manini yelǝn nǝ dǝp lǝɓa ngel Lya kǝn waiya? gaki nǝgu, mus mulnǝ ɗǝ lyap pǝtl yelǝn nǝ dǝp lǝɓa u, ta pal gawas mul ngel lya u ngu. ");
INSERT INTO zbu_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","Kin nǝ yentini tǝn swi kǝn shilǝn kǝ Lya usu, “Yal kǝ mbatl kǝ Lya gunǝ Lya shimi geˈ mini u nǝn ɗǝ mbuttimi iye ya? ");
INSERT INTO zbu_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","Amma ti bǝtl min alheli diɓǝli. I laki ɗa shilǝn kǝ Lya usu: “Lya ɗǝ ngeˈmiˈnatl kǝ ga, amma ti pǝliˈmiˈshindǝtl ga alheli.” ");
INSERT INTO zbu_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","Gaki nǝgu takkǝn gawakǝn maˈLya, aˈnge lǝɓa kǝ shedan, ti kuma tǝn kitǝlliˈkini. ");
INSERT INTO zbu_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","Shaˈni maˈLya tima tǝn shaˈti makini. Dǝmni nǝ mbatl kǝ zokki, kini miˈbezǝn mbadli, wokǝlǝn mbadlwakǝn taka, kini miˈmbatl lop. ");
INSERT INTO zbu_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","Pǝlǝn du mbadli, kulni, pǝlǝn lu. hwe tǝ getltwakǝn pal kulu, hwol tuggwakǝn tǝpal du mbadli. ");
INSERT INTO zbu_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","Shindǝlǝn gawakǝn maˈmulban, tima tǝn natl kini. ");
INSERT INTO zbu_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","Kini mil yesǝni ini, bǝˈbyalǝn yelsǝni wai. Gaki ko wokǝn byal yelse wasi mul bǝlti, ko mul nǝ a zi yelse was kapbi u, ta byal pǝtl shilǝn u ɓalu, ta ziˈkapbi u ngu. In ka zi pǝtl shilǝn kapbi u, ki mul bitl tiwai, ki mul zitti kapbi ni. ");
INSERT INTO zbu_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","Mul bǝtl shilǝn nǝm kǝni, tikǝ mul pǝtl ti, tikǝ mul ndǝltl kǝ pekkǝlti nǝ mǝcǝlti. to, kikǝ wongi kiˈzi yelke waˈkapbi? ");
INSERT INTO zbu_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","Gakǝn kǝm, kini u nǝ ɗǝ usu,“Asǝti ko akyau mǝn lǝti geˈgatl gwaˈ, an pǝl hwon tyaka, ami ulti nǝ ulti taka am mbi ulpi.” ");
INSERT INTO zbu_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","I ngu kǝ manǝn ulnǝ tǝ nda kyau uwai. Undǝ dli ukǝn nikini? ai, kǝnǝ wolkǝndǝ ɗa, alǝm dǝmtu nǝn gǝlti. ");
INSERT INTO zbu_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","Mbun ni kǝ ulnisu,“ In Lya a ndǝgu, in mi geˈmiˈdli u, mǝn pǝtl gu nǝ gu.” ");
INSERT INTO zbu_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","Amma i ngu, nǝguni ki laˈtibi nǝ dun ngesi. Undǝ laˈtibi gu bezǝn ulǝn kǝnǝ. ");
INSERT INTO zbu_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","Gaki nǝgu, mus mulnǝ a man zoˈlǝɓa u, in nge pǝlti u, ta pǝl bezǝn lǝɓa u ngu. ");
INSERT INTO zbu_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","To kumini kini miˈ usǝn! Kulni nǝ laˈti yali gaki bǝna u nǝtǝ mbǝtǝn kini u. ");
INSERT INTO zbu_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","Usǝn wakǝn mus ɓosini, luˈlǝgǝllwakǝn mus shisshil a ɗam i. ");
INSERT INTO zbu_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","Zinaliya nǝ azulpa wakǝn sa koni, kontwasǝn u nǝn dǝmti yenti kǝ dwaɗǝn tǝn kini, kǝn ɗap tlu kǝ dli ɗakini kǝnǝ utu. Ka domi gawakǝn usǝn i ageˈ paˈti kǝ ndallǝɓa i. ");
INSERT INTO zbu_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","Yanini! upkǝ miˈkyautǝn u nǝˈ nge ɓatl tisi u si kulu maˈ Lya. Kulu kǝ miˈ otlikin lǝɓa taka a mbǝkǝci kǝm ɗǝˈ “Lya mul nalti i. ");
INSERT INTO zbu_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","Ka pǝlǝn dǝp lǝɓa i geˈ tǝmti, ki ɗamti nǝ tleti nǝ kon nǝ lǝɓa. To, ka katlǝn gawakǝn i gaki cin kǝ poshti. ");
INSERT INTO zbu_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","Ka poci mul zoˈmbatl ɓatlti, kuma tloti, bǝ ta lwe mbatl nǝ kini wai. ");
INSERT INTO zbu_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","Gaki nǝgu mil yelsǝni, ngacem bi, hal gas patl kǝ mulban. Yanǝn kan unǝ mul kotl lu ɗǝ ngashti bi ɗǝ ɓutti cin unǝ tǝ guwas bǝl gwe kǝ zoki u.Nǝ ngashti bi iye ti ɓutti mal kǝ otlti o nǝ mal kǝ gisi. ");
INSERT INTO zbu_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","Aˈdǝmni nǝ ngashti bi. Aˈ dlǝllǝn mbadlwakǝn, gaki mbǝˈ kǝ mulban ɓal nja i. ");
INSERT INTO zbu_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","Yelsǝni bǝ nalǝn ni tǝn yelsǝni wai, gaki ɓa zikin ɓatlti, i ngu mul pǝtl shilǝn ɓaltǝn bidlabi i! ");
INSERT INTO zbu_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","Tǝn cimbǝlti nǝ ngashtibi geˈ bǝna, yelsǝni, yanǝn miˈnjeˈshinkǝn ki Lya ma nǝs shilǝn nǝ shin kǝ mulban u. ");
INSERT INTO zbu_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","I ngu, mǝnɗǝ ndwaˈti ginǝ ngashbi i, ka kumǝn un ndi ngashtibi unǝ Ayuba pǝli u, ka yenǝn un ndi paˈti bisi u nǝ “Lya kǝ njiˈni, nǝ kup ciˈgonti, mul zǝˈgonti. ");
INSERT INTO zbu_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","Amma tǝn ko yan ngi, yelsǝni, bǝˈ lenceniwai, ko nǝ lya, ko nǝ atli, ko mus undi lenceti ukǝni. Ənka ulnisu “E u,” A dǝm tǝn “E” katl, ǝn ka ulnisu “Oˈ o”, A dliltǝn “Oˈ o” i katl, gaki in nǝgu wai u nǝn zikin ɓatlti. ");
INSERT INTO zbu_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","Ən gon wakǝn ɗǝ tleˈ bǝna u, to, aˈ shilǝn nǝ “Lya, ǝn gon wakǝn ɗǝ kup hwol tuga? To, aˈul wul kǝ dwati “Lya. ");
INSERT INTO zbu_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","Ko gon wakǝn nǝn ɗǝ gonti? To, am mbe kolsi kǝ Ikilisiya bi as ngemiˈ “Lya, asi swatitti mil nǝ shin kǝ mul ban. ");
INSERT INTO zbu_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","Ngep Lya ki laˈti mbadli, nǝn ndokǝtl mul gonti Lya nǝn tlilti lya, in ma tapǝl bezǝn lǝɓa u, nǝn pecitti. ");
INSERT INTO zbu_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","Gaki nǝgu, aˈgopǝn dlimiˈ yelsǝni bezǝn lǝɓa wakǝn, a ki ngemi yelkǝni Lya, gaki kiˈ mbi doˈti ɗa. Shilǝn nǝ Lya kǝ mul zoˈmbadli kyautǝnwas ndǝlni iye. ");
INSERT INTO zbu_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","Iliya yakǝn mbalǝn kǝni kǝnǝ mini, amma nǝˈ gob ngep Lya u gaki bǝ mal mbǝwai u, sai nǝpǝl hwon maki nǝ li mǝkka bǝ mal a mbǝ geˈ atliwai. ");
INSERT INTO zbu_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","Kal ki nǝgu nǝn ngem Lya ɗaɗanu u, i mal mbǝ sul lya, atl ne ibbǝl gwei lǝɓa wasi. ");
INSERT INTO zbu_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","Yelsǝni ini, in gon wakǝn a zaˈshitu kǝ Lya u, a gon wakǝn palti teˈtǝn shitu. ");
INSERT INTO zbu_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","Am maninca mus mulnǝ a pal mul pǝtl bezǝn lǝɓa teˈtǝn shitu u ta pekkǝl mul bezǝn lǝɓa i ɗǝgeˈ mǝshti, gu nǝn dǝmti shitu kǝ peshti lipǝn diɓǝli.");
ALTER TABLE zbu_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
