﻿USE sofia;
DROP TABLE IF EXISTS sofia.zawNT_vpl;
CREATE TABLE zawNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zawNT_vpl WRITE;
INSERT INTO zawNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Guijtz ni rusule' laj retoxpeṉgoldoo xten Jesucrist xi'n toDavid, xi'n toAbraham. ");
INSERT INTO zawNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham gujc xtad Isaac, Isaac gujc xtad Jacob, Jacob gujc xtad Judá con rebejtzni. ");
INSERT INTO zawNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá con Tamar gujc xcuzajn Fares con Zara. Fares gujc xtad Esrom, Esrom gujc xtad Aram. ");
INSERT INTO zawNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram gujc xtad Aminadab. Aminadab gujc xtad Naasón. Naasón gujc xtad Salmón. ");
INSERT INTO zawNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón con Rahab gujc xcuzajn Booz. Booz con Rut gujc xcuzajn Obed. Obed gujc xtad Isaí. ");
INSERT INTO zawNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí gujc xtad ṟeii David. David con nani gujc chääl Urías gujc xcuzajn Salomón. ");
INSERT INTO zawNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón gujc xtad Roboam. Roboam gujc xtad Abías. Abías gujc xtad Asa. ");
INSERT INTO zawNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa gujc xtad Josafat. Josafat gujc xtad Joram. Joram gujc xtad Uzías. ");
INSERT INTO zawNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías gujc xtad Jotam. Jotam gujc xtad Acaz. Acaz gujc xtad Ezequías. ");
INSERT INTO zawNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías gujc xtad Manasés. Manasés gujc xtad Amón. Amón gujc xtad Josías. ");
INSERT INTO zawNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías gujc xtad Jeconías con rebetzni cheni huij rebeṉ Israel pres lo guedx Babilonia. ");
INSERT INTO zawNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Che gudejd huij rebejṉga pres Babilonia, dxejc guyu' xi'n Jeconías, Salatiel. Salatiel gujc xtad Zorobabel. ");
INSERT INTO zawNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel gujc xtad Abiud. Abiud gujc xtad Eliaquim. Eliaquim gujc xtad Azor. ");
INSERT INTO zawNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor gujc xtad Sadoc. Sadoc gujc xtad Aquim. Aquim gujc xtad Eliud. ");
INSERT INTO zawNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud gujc xtad Eleazar. Eleazar gujc xtad Matán. Matán gujc xtad Jacob. ");
INSERT INTO zawNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob gujc xtad José chääl Marii nani gujc xnan Jesús ni birilaj Crist. ");
INSERT INTO zawNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ni'cni gujc tzudaj xfamiḻ reni agudejd gubi'reni lo guedxliujre che gubajṉli toAbram cheni gubajṉliza toṟeii David. Tzudajza rexagdoo najc reni gudejd cheni gubajṉli toDavid cheni huijli rebeṉ Israel pres Babilonia. Stzudaj rexagdoo najc reni gudejd cheni biriilireni pres Babilonia che gojlli Crist. ");
INSERT INTO zawNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Scree gujc cheni gojl Jesucrist. Abia'n xnanni, Marii, diidx guchṉaani José ni gac chäälni. Per ansde xca' sa'reni, Marii agac nuxi'nni sa'csi biääd Sprit Dxan xten Dios lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José com najcni te beṉsa'c, di rlajzni nuṟo'nni Marii nez loj rebejṉ te niacbeereni, ni'c bejnni xhigab Guṟonxhiga'tzni Marii. ");
INSERT INTO zawNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Xhigabga cayujnni cheni baluiloj te xangl Dios lojni, lo bacaḻ räjpni lojni: ―José xajg toDavid, na'c guidxejblu xca'lu Marii gacni chäällu sa'csi xi'nni nani chu najc xten Sprit Dxan xten Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Che gaal xi'nni cuälajluni Jesús sa'csi laani gusḻaani rexpejṉni lo rextojḻreni. ");
INSERT INTO zawNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Guiraa redee gujc si'c te guzojb diidx ni gunii tej ni bacuaa xtidx Dios. Räjpni: ");
INSERT INTO zawNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Suu te dxapxteeb bäz, sajl te xingaanni nani guirilaj: Emanuel, (lajni säloj Dios nabajṉ con nuure). ");
INSERT INTO zawNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Che gubajṉ José lo bacaḻ, bejnni si'cni räjp xangl Dad lojni. Cua'ni Marii gujc chäälni. ");
INSERT INTO zawNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Luxh dini niembeeni si'c chäälni dxejli cheni gudejd gojl xingangalojni ni gulälajni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Cheni gojl Jesús neṉ guedx Belén xten guedx Judea, najc Herodes ṟeii xten guedx Judea. Dxejc bidzujṉ rebeṉnajn ni najc remagos, siäädreni nejz cadro rliejn gubijdx, bidzujṉreni guedx Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Rniabdiidxreni: ―¿Con ṟeii xten rebeṉ Israel nani golgaj, ä? Nurnu abihuiinu xpajlni laadxlinu, ni'cni siopdoṉnuni. ");
INSERT INTO zawNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Che biejn diajg ṟeii Herodes diidxga, guyuduxhni yärsia' näjza guiraa rebeṉ Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Dxejcti batie'ni guiraa rebixhojzro ni rnibee loj rebixhojz, näjza guiraa renani ruluii xleii Moisés lo rebejṉ te gunabdiidxni lojreni: ―¿Caro gaal Crist? ");
INSERT INTO zawNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Laareni räjpreni: ―Neṉ guedx Belén xten guedx Judea sa'csi si'c gunii niguii ni bacuaa xtidx Dios che räjpni: ");
INSERT INTO zawNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Luj guedx Belén xten guedx Judea, dilu gajc maazru huin loj reguedxro xten guedx Judea sa'csi neṉ guejdxre guirii tej nani guinibee, te ni ga'p rexpeṉä Israel. ");
INSERT INTO zawNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Dxejcti guredx-xhiga'tz Herodes remagos te gunabdiidxni gucti biricaj bajl nani bahuiireni. ");
INSERT INTO zawNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Dxejcti baxhaḻnireni guedx Belén, räjpni lojreni: ―Coḻchäj ro'c, coḻnabdiidxsa'c xcuent biuuxga te che abidxältuni jiädniitu loä te näjza narä chagaṉäni. ");
INSERT INTO zawNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Che biejn diajgreni xtidx ṟeii, sä'tireni. Bajl nani bahuiireni lagajc lajdxreni laḻtis nijdni lojreni. Che bidzujṉlireni cadro yu' bäzga, dxejcru guzobdxi bajlga. ");
INSERT INTO zawNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Che bahuii remagos loj bajlga, rbalazduxhreni. ");
INSERT INTO zawNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Si'c bidzujṉreni. Che biu'reni neṉ yu', bahuiireni lo bäzga con xnanni Marii. Dxejcti bazuxhijbreni, gojṉreni bäzga, baxhalreni rexcäḻnasa'creni bazalajzreni oor, näjza yaal näjza yalnejxh. ");
INSERT INTO zawNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Che agojl guibi'reni, gunixcäḻreni, räjp Dios lojreni: ―Na'c guibi'tu nez loj Herodes. Dxejcti gunaazreni garenca nez yuj, gubi'reni lajdxreni. ");
INSERT INTO zawNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Che sii remagos lajdxreni, biääd te xangl Dios baluilojni lo José lo bacaḻ, räjpni: ―Huistie, cua' biuxe're näjza xnanni, huinäreni Egipto. Ro'c guläjz che guiniäli lojlu. Siguiil Herodes biuxe're sa'csi rlajzni ju'tnini. ");
INSERT INTO zawNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Dxejc huistiegajc José, cua'ni biuxe're näjza xnanni, lagajc yäälga biriireni, siireni nez Egipto. ");
INSERT INTO zawNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ro'c guyu'reni cheni gujtli Herodes. Guiraa dee guzajc te guzojb diidx ni bacuaa niguii ni gunii xtidx Dios che räjpni: “Egiptoli guredxä xi'nä.” ");
INSERT INTO zawNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Che gucbee Herodes abasguee remagosni, bidxechduxhni. Gunibeeni guet guiraa rebiuxniguii ni yu' tio'p ijz näjza rebiuxe' ni yu' guxiiru dxej, guideb neṉ guedx Belén näjza reguejdx ni re' gabiga, si'cti redxej ni räjp remagos lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Dxejc guzojb diidx ni bacuaa Jeremías ni gunii xtidx Dios che räjpni: ");
INSERT INTO zawNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Biejn xse' bejṉ neṉ guedx Ramá, te yäḻhuinduxh, te yäḻrbedxdij, yäḻrbedxneṉ: laa Raquel ni roon yejc rexi'nni. Naaddini jiäjḻ lajzni sa'csi agujt rexi'nni. ");
INSERT INTO zawNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Cheni gujt Herodes, dxejc lo te bacaḻ huiluiloj xangl Dios loj José neṉ Egipto. ");
INSERT INTO zawNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Räjpni: ―Huistie, cua' biuxe're näjza xnanni, gubisac nez Israel sa'csi agujt renani rlajz ju't biuxe're. ");
INSERT INTO zawNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Dxejcti huistie José, cua'ni biuxe' näjza xnanni. Gubi'reni Israel. ");
INSERT INTO zawNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Luxh che biejn diajgni rnibee Arquelao guejdx Judea lacuaa Herodes, xtadni, bidxejbni nuiini ro'c. Dxejc gunisac Dios lojni loj te bacaḻ, ni'c huijni lo reguejdx xten Galilee. ");
INSERT INTO zawNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Dxejc biädläjzni neṉ guejdx ni laa Nazare't te si'c guzojb diidx ni bacuaa niguii ni gunii xtidx Dios cheni räjpni: “Sirilajni nazareṉ.” ");
INSERT INTO zawNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Neṉ redxejga biääd Juan Bautist lo reyubijdz xten guedx Judea, ro'c cagulijdxni, ");
INSERT INTO zawNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","cayäjpni: ―Coḻgusiechlajztu rextojḻtu sa'csi xcäḻrnibee Dios abidzuṉgajxhni. ");
INSERT INTO zawNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan najc nani basä't Isaías, te niguii ni gunii xtidx Dios, cheni bacuaani: Riejn xse' te ni rbedxa' nez lo reyubijdz: “Coḻguslii xnezyuj Dad, coḻguslii xnezyulajzni.” ");
INSERT INTO zawNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Najcw Juan xquichlajd cameii. Naliib te duguijd xque'ni. Rajwni guxha't näjza dzujn xten baseerguijxh. ");
INSERT INTO zawNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Riääd rebeṉ guedx Jerusalén näj guiraa rebeṉ Judea näjza rebejṉ ni tre' gajxh nez ro' gueu Jordán, riädcuadiajgreni xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Che ruxhobdojḻreni xtojḻreni, rutiobnis Juanreni ro' gueu Jordán. ");
INSERT INTO zawNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Che bahuiini siääd xhidajl rebeṉ guidoo ni najc refarisee näjza ni najc resaducee, rlajzreni gutiobnisnireni, räjpni lojreni: ―La'tu beṉguidxduxh, najctu si'c bäḻ. ¿Chu balijdxtu guxuṉtu loj xcäḻrdxe'ch Dios ni siääd? ");
INSERT INTO zawNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Coḻguibaṉsa'c si'cni nungäjḻ te fiipac rebejṉ guliipac abasiechlajztu. ");
INSERT INTO zawNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Na'c litis guntu xhigab naatu: “¡Ni nurnu najcnu rexagdoo toAbram!” Rniliä lojtu, sajc xca' Dios reguijre gunni gacreni rexi'n toAbram. ");
INSERT INTO zawNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Asojb guibyajg lo xlobaa reyajg, luxh guiraa reyajg nani di ninexhsa'c xcaj lojni, sidinni te checni. ");
INSERT INTO zawNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Narä guliicani rustiobnisä con nis si'c te seen cheni abasiechlajztu, abaxhobdojḻtu. Niluxh nani siääd detzä sutiobnisni la'tu con Sprit Dxan xten Dios näjza con guiboo. Rnibeeruni loä. Beṉsacduxhni. Nicla xcura'chni digacdi chanää́. ");
INSERT INTO zawNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Aca'ni xhi cojn gusiani triuu xtenni te chuchee triuuga neṉ ngodx xtenni. Dxejcti guixhtriuuga, suze'cni guijxhga lo guiboo ni rejc par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Dxejc birii Jesús nez Galilee, bidzujṉni ro' gueu Jordán cadro yu' Juan te gutiobnis Juanni. ");
INSERT INTO zawNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Niluxh naaddi Juan gutiobnis Jesús. Räjp Juan lojni: ―Luj nanab gutiobnislu narä, niluxh ṉaj alga luj siäädlu loä te gutiobnisälu. ");
INSERT INTO zawNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Dxejc räjp Jesús lojni: ―Basaan gacni si'c ṉaj, sa'csi nanab gusoobnu guiraa ni rlajz Dios gac. Dxejctiru batiobnis Juan Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Cheni gulujx gurobnis Jesús, birigajcni lo nis. Dxejc bixal xhaguibaa, bahuiini siädyäjt Sprit Dxan xten Dios si'c te palom, biäjtni lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Dxejc xhaguibaali biejn diajgreni te xse' ni räjp: ―Dee najc xi'nä ni sanälazä. Laani rbanälazä. ");
INSERT INTO zawNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Dxejc bejn Sprit Dxan xten Dios huij Jesús nez lo reyubijdz te nejzga nuhuaḻ beṉdxab Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Che gulujx bacua'n Jesús tiuu gubijdx, tiuu guxhijṉ, gulaanni. ");
INSERT INTO zawNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sas biääd beṉdxab lojni, räjpni: ―Palga guliilu Xi'n Dioslu, gunibee gac reguijre yätxtiil. ");
INSERT INTO zawNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Badzu' Jesús diidxre lojni, räjpni: ―Loj reguijtz xten Dios caj scree: “Xhet ganaxdi yäḻtxtiil guibajṉ rebejṉ; sibajṉzani con guiraa diidx nani rnii Dios.” ");
INSERT INTO zawNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Dxejcti huinä beṉdxab Jesús guedx Jerusalén. Gulä'pnini jiaa yejc xques guidoro. Dxejcru räjp beṉdxab lojni: ");
INSERT INTO zawNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","―Palga Xi'n Dios luj, bitiäjs lo yujli, sa'csi scree caj loj rexquijtz Dios: Sinibee Dios rexanglni ga'preni luj; siliäsreni luj con ṉaareni didi gacnaj ni'lu lo reguijga. ");
INSERT INTO zawNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Badzu' Jesús diidxre lojni, räjpni: ―Caj loj rexquijtz Dios: “Na'c faḻlu Dad ni najc Xtioslu.” ");
INSERT INTO zawNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Stee huält huinä beṉdxab Jesús yejc te danro. Dxejcti baluiini lojni guiraa reguejdx, reguedxro ni tre' lo guedxliuj näj guiraa xcäḻnasa'creni. ");
INSERT INTO zawNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Dxejcti räjpni loj Jesús: ―Guiraa redee sunidxä lojlu palga guzuxhijblu nez loä te gaṉlu narä. ");
INSERT INTO zawNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Dxejcti räjp Jesús lojni: ―¡Huij nez rec beṉdxab! Scree caj loj rexquijtz Dios: “Dad Xtiostislu gaṉlu; lojtisni chulu.” ");
INSERT INTO zawNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Dxejcti gubicaj beṉdxab loj Jesús. Dxejc biääd rexangl Dios biädhuiireni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Che biejn diajg Jesús yu' Juan neṉ ladzguiib, huijni nez Galilee. ");
INSERT INTO zawNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Dxejcti gudejdni guedx Nasare't, huiläjzni guedx Capernaum ni tre' gajxh nez ro' nis, nez reguejdx Zabulón con Neftalí. ");
INSERT INTO zawNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Si'c gujc te guzojb diidx ni bacuaa Isaías ni gunii xtidx Dios: ");
INSERT INTO zawNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Lajdx Zabulón, lajdx Neftalí, nezyuj ni rij nez ro' nisdoo, stelaad gueu Jordán, Galilee cadro rbäjz rebejṉ nani di gac rexpeṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Rebejṉ nani rbäjz neṉ te yäḻcäjy abahuiireni te bajlga, luxh bajlga basanij xcäriejn renani nabajṉ lo xcäḻrdxejb, lo xpalaa yäḻgujt. ");
INSERT INTO zawNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Dxejcli gusloj cagulijdx Jesús, räjpni: ―Coḻgusiejchlajztu, coḻguxhobdojḻ te guibaṉsa'ctu sa'csi abidzuṉgajxh xcäḻrnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sasaj Jesús nez ro' nisdoo xten Galilee che bahuiini lo tio'p niguii. Tejni laa Simón, ni laaza Pedr. Steeni najc lagajc bejtzni, ni laa Andrés. Dzuun ni rujnreni najc rniaazreni bäjl, ni'c cacuaareni guijxh lo nisdoo. ");
INSERT INTO zawNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Dxejcti räjp Jesús lojreni: ―Coḻtanajl narä. N̲aj riniaaztu bäjl, niluxh narä gunä cueedxtu rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Lagajc dxejc basa'nreni xquijxhreni te sanajlreni laani. ");
INSERT INTO zawNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Che gudejdreni ro'c, bahuiini loj stio'p niguii, Jacoob con bejtzni Juan. Yu'reni neṉ te barcw con xtadreni, ni laa Zebedeo cayunsa'creni guijxh. Dxejc gurejdx Jesúsreni. ");
INSERT INTO zawNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Lagajc dxejc basa'nreni barcw näjza xtadreni te sanajlreni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Sasajti Jesús guideb nez región xten Galilee, caguluiini neṉ tejga rexquidooreni. Cagusule'ni redidxcoob xten xcäḻrnibee Dios. Cagusiajczani guiraa yäḻracxhuu ni rajc rebejṉ guejdxga, guiraa yäḻguijdx. ");
INSERT INTO zawNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Biejn diajg rebeṉ Siria diidx xcuent ni cayujn Jesús. Sas biädnäreni guiraa rebeṉracxhuu ni cayajc guiraloj yäḻguijdx, yäḻnayan; guiraa reni rajc yejcreni, guiraa reni rajc malyäḻguijdx, reni rajc yäḻguidxbej, guiraareni abixu'ṉ tiejxhreni. Dxejcti basiajc Jesús rebejṉga. ");
INSERT INTO zawNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Xhidalduxh beṉ Galilee huinajlni, näj rebeṉ reguedx Decápolis, näjza rebeṉ guedx Jerusalén, näjza rebeṉ Judea näjza rebejṉ ni tre' stelaad gueu Jordán. ");
INSERT INTO zawNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Che bahuii Jesús loj rebeṉ xhidajl, huä'pni yejc te dajn. Dxejcti gubig rexpejṉni ni gurejdxni lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Dxejc gusloj caguluii Jesús reni'c, scree räjpni: ");
INSERT INTO zawNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Sibaalajz rebejṉ nani nanchee rquinduxhreni xcäḻracnäj Dios, sa'csi laareni nungäjḻreni xcäḻrnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Sibaalajz rebejṉ nani rac-huin lajzreni xcuent rextojḻreni, sa'csi sudzucaj Dios xtojḻreni, susiäjḻni lajzreni. ");
INSERT INTO zawNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Sibaalajz rebejṉ nani nadolajz nani rlajz guntis si'cni rnibee Dios, sa'csi sacnäj Diosreni lo xcäḻnabajṉreni lo guedxliujre. ");
INSERT INTO zawNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Sibaalajz rebejṉ ni nastoocanu rliaanreni, riojlreni, sa'csi rlajzreni guibaṉsa'ctisreni nez loj Dios, sa'csi sudeed Dios lojreni guiraa ni rniabreni. ");
INSERT INTO zawNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Sibaalajz rebejṉ nani rulaslajz sa'reni, sa'csi sulaslajzza Diosreni. ");
INSERT INTO zawNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Sibaalajz rebejṉ nani najc nayatis lastooreni rujnreni rexhigabsa'c xten Dios sa'csi suhuiireni lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Sibaalajz rebejṉ nani ruscuecdxilajz sabejṉreni, sa'csi laareni sirilajreni rexi'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Sibaalajz rebejṉ nani rusutijp lajzreni che rusacsí bejṉreni sa'csi nabaṉsa'creni nez loj Dios, sa'csi xtenreni najc xcäḻrnibee Dios xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Coḻspaalajztu che gusacsí bejṉtu tiḻnäjreni la'tu, guiniireni guiraloj didx-xhii xcuent xtidxä. ");
INSERT INTO zawNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Coḻguibaalajz, coḻbalajz sa'csi xhaguibaali sunidxduxh Dios xcuent xtzuuntu. Sigajcza basacsíreni reniguii ni gubajṉ galoo ni gunii xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Räjpzani: ―La'tu najctu si'c sejd lo guedxliujre. Palga di sejd gac nadzujy, ¿xho gacsacni nadzujy? ¿Xhi gun bejṉni dxejc? Susäḻreni sejdga detz yu', suläj bejṉ yejcni. ");
INSERT INTO zawNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’La'tu najctu si'c te bianij lo guedxliujre. Te guejdx nani tre' jiaa yejc te dajn, digacdi guiga'tzni. ");
INSERT INTO zawNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Digacdi xcaguij te bajl dxejcti jiäuuni neṉ te caj. Maazru huen soobni jiaa neṉ te gandilieer te gusänijni loj guiraa rebejṉ ni tre' neṉ yu'. ");
INSERT INTO zawNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Xcäḻnabaṉsa'ctu najc si'c te bajl loj rebeṉ guedxliuj. Suhuiireni xtzunsa'ctu dxejc siliä'preni xpala'n xtadtu ni yu' xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Räjpzani: ―Na'c guntu xhigab siädgudzucaä́ leii xten toMoisés, niclaza rediidx ni baluii redad ni gunii xtidx Dios. Xhet siäddzucaä́dini, narä siälä te guluiäpacni si'cni najcni. ");
INSERT INTO zawNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Rniliä́pac, dxejli che ni nitloj guibaa näjza guedxliuj, nicla tej letr ni caj loj leii di nit. Sajcpac guiralii ni caj lo reguijtzga. ");
INSERT INTO zawNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ni'cni chutis ni rlajz gusaan te diidx nani caj loj leii, mase te didxbäzni, luxh ruluiini gun bejṉ si'c, laani guxiduxh sajcni lajdx Dios guibaa. Niluxh renani rucuadiajg xtidx leii, luxh rujnpacreni si'cni caj lo leii, ruluiizani leii, beṉsacduxh gacni lajdx Dios guibaa. ");
INSERT INTO zawNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ni'cni rniä lojtu, palga ditu gunsa'cru xtzun Dios, ditu guibaṉsa'cru loj reni najn xcuent xleii toMoisés, näjza loj rebeṉ guidoo ni laa farisee, dipactu jiu' lajdx Dios xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Räjpzani: ―Abiejnza diajgtu nani gunii rebeṉgoldoo: “Na'c ju'tlu. Chutis te nani ju't sa'ni, sinärenini lo guxhtis te jiäuuni neṉ latzguiib.” ");
INSERT INTO zawNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Niluxh narä rniä chutis nani guidxechduxh lo sa'ni sijni lo guxhtis. Chutis ni guinii didxnaj lo sa'ni, sijni lo juejz. Chutis ni gäb lo sa'ni: “beṉnayäḻlajz” sidejdni loj yäḻguxhtis xten Dios, sijni gabijl cadro cayejc guiboduxh. ");
INSERT INTO zawNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Che sanälu gojn guidoo te gusa'nluni lo bacuug, palga guinaj lajzlu yu' chu lo cadxe'chlu, ");
INSERT INTO zawNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","basansijc gojn xtenlu lagajc ro'c, huisiäḻxgaa diidx con sa'lu, dxejcti guibi'lu te gac gusa'nlu gojn xtenlu. ");
INSERT INTO zawNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Palga yu' chu rdxe'ch lojlu, basquejn basiäjḻ diidx con laani lagajc cheni sasanäjluni lonezyuj te di guteedni luj lo juejz. Luxh juejz suteedni luj loj reguixhajg te gusäureni luj neṉ latzguiib. ");
INSERT INTO zawNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Rniliä́pac lojlu: “Dilu guirii ro'c palga dilu cue'c guiralii meel nani guiniabni lojlu.” ");
INSERT INTO zawNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Räjpzani: ―Abiejn diajgtu guniireni galoo: “Na'c guesnäjtu gunaa nani di gac chäältu.” ");
INSERT INTO zawNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Narä rniä, chutis te nani fii loj te gunaa dxejcti guisia' lajzni gunaaga, abejnni dojḻ neṉ lastooni. ");
INSERT INTO zawNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Palga balojlu ladbee rujn rujnlu dojḻ, gulääni basäḻni te laad sa'csi hueenru gunijtlu te balojlu quela chää guideb tiejxhlu gabijl. ");
INSERT INTO zawNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Palga ṉaalu ladbee rujn rujnlu dojḻ, batiu'ni sa'csi hueenru gunijtlu te ṉaalu quela chää guideb tiejxhlu gabijl. ");
INSERT INTO zawNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Räjpzani: ―Abiejn diajgtu guniireni galoo: “Chutis niguii ni rlajz guṟo'n chäälni, nanabtis gudeedni te guijtz nani rnii abaṟo'nni chäälni.” ");
INSERT INTO zawNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Narä rniä, niguii nani guṟo'n chäälni niluxh xhet dojḻdi bejn chäälni, niguiiga sujn gun chäälni yäḻgubejxh, niluxh chutis ni guchṉaa gunaaga sujnzani yäḻgubejxh. ");
INSERT INTO zawNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Räjpzani: ―Abiejnza diajgtu gunii rebeṉgool: “Che ria'nlu diidx lo Dios gunlu xhi gunlu, na'c jial lajzlu; basa'pac xtiidxlu lo Dios.” ");
INSERT INTO zawNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Narä rniä, na'c gunlu juraar, nicla tej mood, nicla por xhaguibaa, sa'csi ro'c najc lajdx Dios, ");
INSERT INTO zawNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","nicla por loj guedxliuj sa'csi ro'c rsiuj ni'ni; nicla por guedx Jerusalén sa'csi ro'c najc guedxlajdx ṟeiiro, ");
INSERT INTO zawNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","niclaza por lagajc bitiuyejclu, sa'csi digacdi guncheelu te guichyas niclaza te guichnol, nicla tej guijch. ");
INSERT INTO zawNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nanab guiniitislu: “Mbaj” o “Ajndi”. Palga yu' xhiru rniilu, beṉdxab najc ni rujn rniiluni. ");
INSERT INTO zawNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Räjpzani: ―Abiejn diajgtu gunii rebeṉgool galoo: “Te baloj por ste baloj, te läjy por ste läjy, nalajznu bejn lo sa'lu si'ctis ni rujnni lojlu.” ");
INSERT INTO zawNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Narä rniä, na'c tiḻnäjlu te bejṉ ni bejn te cos guijdx lojlu. Palga chääzni ladbee lojlu badeed stelaad lojlu chääzni. ");
INSERT INTO zawNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Palga yu' chu rlajz tiḻnäjlu te xca'ni xcamangwlu, badeedza näj xsa'cwlu lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Palga yu' chu guinibee guulu xcargwni te kilómetro, huinäni tio'p kilómetro. ");
INSERT INTO zawNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nani guiniab xhi guiniabxlia'ni lojlu, badeedni. Nani guiniablaa xhi guinablaani lojlu na'c gudxojnluni lojni, na'c gäblu: “Xhetini.” ");
INSERT INTO zawNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Abiejn diajgtu gunii rebeṉgool: “Coḻchanälajz sa'tu. Coḻguidxe'ch loj renani rdxe'ch lojtu.” ");
INSERT INTO zawNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Narä rniä lojtu, coḻchanälajz rebejṉ ni rdxe'ch lojtu. Benle' yejc reni rgue lojlu. Coḻyejn dxunsa'c loj renani rdxe'ch lojtu. Coḻcuejdx, coḻnab loj Dios xcuent rebejṉ nani rdxagdijḻtu, rusacsíreni la'tu, ");
INSERT INTO zawNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","te si'c gactu xi'n xtadtu ni yu' xhaguibaa nani rujn ṟii xcubijdxni lo rebeṉsa'c sigajcza lo rebeṉ guijdx. Rujnzani riajb nisguij lo rebeṉsa'c sigajcza lo rebeṉguijdx. ");
INSERT INTO zawNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Palga la'tu chanälajztu lagajctis rebejṉ nani rinälajz la'tu, ¿xhi gaan guntu dxejc? Najctu lagajc si'c najc rebejṉ ni rutie' meel ni rajx lo gubier. ");
INSERT INTO zawNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Palga guiniitu: “Xchan”, lagajctis loj resa'tu, ¿xhini'c rujntu ni najc hueenru lo chutis bejṉ? ¿La et sigajcdiza rujn rebejṉ nani di gumbee Dios? ");
INSERT INTO zawNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Coḻyajc beṉsa'c si'c ni najc xtadtu ni yu' xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Räjpzani: ―Na'c gusäbdiidx guntu dzunsa'c nez loj rebejṉ te fiitisreni xhi rujntu. Palga gusäbdiidxtu di xtadtu ni yu' xhaguibaa guniidx xhi xca'tu. ");
INSERT INTO zawNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Che gudeedlu gojn, na'c güilu diidx xhi badeedlu. Na'c gunlu si'c rujn rebejṉ nani rusguee neṉ reguidoo, näjza lad nezyuj. Rujnsireni si'c te ruhuii rebejṉ xhi rujnreni te rliä'p rebejṉ xpala'nreni. Narä rniä acua'reni gaan xtenreni. ");
INSERT INTO zawNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Luj che gudeedlu gojn xtenlu, na'c gacbee nicla tej xamiigwlu xhi badeedlu, ");
INSERT INTO zawNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","te gac gojn xtenlu xhiga'tz. Dxejcti xtadlu ni cahuii nani bejnlu xhiga'tz, sacnäjni luj nez loj rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Räjpzani: ―Cheni rbejdx, rniabtu lo Dios, na'c guntu si'c rujn rebeṉguidoo ni rusguee. Rchaglajzreni rniabreni lo Dios rsiuliireni neṉ reyu' cadro rieḻ xtidx Dios, näjza guiraa resquiin, näjza nez ronejz te ruhuii rebejṉ xho rujnreni. Rniliä́pac, acua'reni gaan xtenreni. ");
INSERT INTO zawNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","N̲aj luj cheni cueedx, guiniablu lo Dios, biu' neṉ xyu'lu. Basäuu ro' yu'ga, dxejcti xhiga'tz gunii loj xtadlu ni yu' xhaguibaa. Dxejcti xtadlu ni cahuii xhi rujnlu xhiga'tz, sacnäjni luj nez loj rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Cheni caniitu lo Dios, na'c guinisactu balti huält rediidx nani aguniitu. Si'c rujn rebejṉ nani di gumbee Dios. Naareni sa'csi sanuutis rniireni xhidajl diidx balti huält, siejn diajg Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Na'c guntu sigajc ni rujnreni, sa'csi anajn xtadtu xhini'c rquiintu che guiniabtuni lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ni'cni scree coḻguinii lo Dios: Xtadnu ni yu' xhaguibaa dxan najc lajlu. ");
INSERT INTO zawNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Sujiääd xcäḻrnibeelu; bejn si'cni rlajzlu lo guedxliujre sigajc rujnlu xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nadxej baniidx xcu'nnu sa' ni rdaunu guira dxej. ");
INSERT INTO zawNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Basiäjḻ lajzlu redojḻ xtennu si'c riäjḻ lajznu redojḻ xten rebejṉ ni rujn dojḻ loonu. ");
INSERT INTO zawNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Na'c gusaanlu jiaabnu xhigabguijdx, basḻaa nuure lo dojḻ, sa'csi xten guejblu najc yäḻrnibee, yäḻnadip näjza yäḻrdimbicha' par tejpas. Sugacni si'c. ");
INSERT INTO zawNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Palga la'tu gusiäjḻ lajztu redojḻ ni rujn rebejṉ lojtu, xtadtu ni yu' xhaguibaa susiäjḻza lajzni rextojḻtu. ");
INSERT INTO zawNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Palga ditu gusiäjḻ lajztu redojḻ ni rujn rebejṉ lojtu, sigajcza xtadnu ni yu' xhaguibaa di lajzni jiäjḻza rextojḻtu. ");
INSERT INTO zawNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Räjpzani: ―Che rucua'ntu na'c guntu si'c rujn rebejṉ nani rusguee; rumbaa lojreni te fii rebejṉ cagucua'nreni. Rniliä acua'reni rexgaanreni. ");
INSERT INTO zawNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Niluxh la'tu, che rucua'ntu, coḻcuṉ yejctu, coḻquiib lojtu ");
INSERT INTO zawNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","te na'c gacbee rebejṉ cagucua'ntu, xtadtistu suhuii cagucuanxhiga'tztu. Xtadtu ni cahuii xhi cayunxhiga'tztu suniidxni xhi xca'tu nez loj rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Räjpzani: ―Na'c gapdajntu yäḻnasa'c lo guedxliujre cadro rajw reman o rbibtiejn xhixtentu, niluxh richu' gubaan rolijz bejṉ te rbajnreni. ");
INSERT INTO zawNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Hueenru ga'ptu xcäḻnasa'ctu xhaguibaa cadro di reman gauu, diza rexhixtentu cuibtiejn, diza regubaan jiu' te cuanreni. ");
INSERT INTO zawNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Sa'csi cadro yu' xcäḻnasa'ctu, ro'cza naga' lastootu. ");
INSERT INTO zawNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Räjpzani: ―Bianij xten tiejxhni najc balojni, ni'cni palga rhuisa'c balojtu, guideb tiejxhtu yu' lo bianij. ");
INSERT INTO zawNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Niluxh palga rebalojtu di fisa'c, guideb tiejxhtu yu' lo nacäjy, ni'cni palga bajl nani yu' tiejxhtu dini gusanij, ¡linacäiboo najc guidebtu! ");
INSERT INTO zawNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Nicla te bejṉ di gacdi gun dzuun loj tio'p lam̲ tejsi junt, sa'csi sibälazni tejni laga sanälajzni steeni. Digacdi guntu xtzuun Dios palga caguiiltistu xcäḻnasa'ctu lo guedxliujre. ");
INSERT INTO zawNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Ni'cni rniä lojtu, na'c chutu yärsia' por xcäḻnabajṉtu, xhicha gautu, xhicha yätu, niclaza naatu xhicha lajd gajcwtu. Yäḻnabajṉ sajcru lo yäḻrajw, luxh sajcru tiejxhtu lo xhajbtu. ");
INSERT INTO zawNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Coḻhuii remane' ni rtajt xhaguibaa. Direni cue'c binij, dizareni guilia' gäjl, dizareni cuchee xhi gaureni neṉ yu', luxh xtadtu ni yu' xhaguibaa rudeedni xhi rajwreni. ¿Laa xhet sajcdirutu loj remane'ga, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Chu tej la'tu sa'csi ru'tu yärsia' sajc tiobrutu ste bo'c jiaaru? ");
INSERT INTO zawNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Xhicuent runduxhtu xhigab xcuent xhajbtu? ¡Coḻhuii reguii ni tre' nesiät! ¿Xho roobreni? ¿Xho rialreni? Direni gun dzuun, dizareni guzaa xhajbreni. ");
INSERT INTO zawNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Narä rniä lojtu, nicla ṟeii Salomón guideb najcwni rexhabsa'c xtenni di nisiuchee si'c rsiuchee tej reguiiga. ");
INSERT INTO zawNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Palga Dios rujn rajc recuaan ni yu' nesiät ni rial nadxej luxh guixee ahuejcreni, ¿xhixh dini gunduxhru par la'tu, bejṉ nani guxii rililajz? ");
INSERT INTO zawNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ni'cni na'c chutu yärsia' guntu xhigab: “¿Xhicha guidaunu, xhicha guiduṉnu, xhicha gacwnu?” ");
INSERT INTO zawNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Sa'csi rebejṉ nani di gumbee Dios xhigabtisga rujnreni, caguiilreni guiraa recosga. Niluxh xtadtu ni yu' xhaguibaa anajnni xhini'c rquiintu. ");
INSERT INTO zawNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Coḻquilxgaa yäḻrnibee xten Dios näjza yäḻnabaṉsa'c si'cni rlajz Dios dxejc sica'tu guiraa ni rquiintu. ");
INSERT INTO zawNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ni'cni na'c gunduxhtu xhigab xho tedtu dxej guixee. Combast tedtu trabajw nani riääd dxej con dxej. ");
INSERT INTO zawNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Räjpzani: ―Na'c cubeetu sa'tu te na'cza cubee Dios la'tu. ");
INSERT INTO zawNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sa'csi sigacni rgubeetu sa'tu, sigajcza sigubee Dios xhi rujntu; niluxh lagajc si'cni rutiexhtu lo bejṉ, si'cza sutiexh Dios lojtu. ");
INSERT INTO zawNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Xhicuent ruhuiilu loj guijxh ni yu' baloj sa'lu, luxh dilu fii yagro nani yu' lagajc balojlu? ");
INSERT INTO zawNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Xhicuent gäblu lo sa'lu, nädoṉnu cuää́ guijxh ni yu' neṉ balojlu, luxh dilu fii loj yagro ni yu' neṉ balojlu? ");
INSERT INTO zawNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Beṉguijdx ni rusguee, guläxgaa yagro ni yu' balojlu te gac fisa'clu te cuäälu guijxh nani yu' baloj sa'lu. ");
INSERT INTO zawNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Na'c guluiitu guiraa rextidx Dios loj chutis bejṉ sa'csi yu'reni najc si'c bä'cw, xlia'si rca'renini; sibi'reni, sauya'reni luj. Sigajcza recos sa'cru, na'c gudeedtuni loj chutis bejṉ, sa'csi yu'reni najc si'c cuch rbälazreni cossa'c najcreni si'c cuch ni ruläj yejc xhitis xhi cos. ");
INSERT INTO zawNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Räjpzani: ―Coḻnab lo Dios te guniidxni nani rniabtu. Coḻquiilni te guidxäjltuni. Coḻnii rolä', te guixalni jiu'tu. ");
INSERT INTO zawNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Chutis ni rniab lo Dios sica'ni nani rniabni, nani rguiil xhi cos nez loj Dios rdxälzani nani rguiilni; nani rusejz rolä', suxhalzareni lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿La yu' chu tejtu che guiniab xi'nni te yätxtiil, alga gudeedni te guij, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O palga guiniabni te la' bäjl, ¿la sudeedni te bäḻ? ");
INSERT INTO zawNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Palga la'tu ni najc beṉ guijdx rajc rudeedtu cossa'c loj xi'ntu, aticaxh xtadtu ni yu' xhaguibaa. Laani suniidxni cossa'c loj renani guiniabni lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Ni'cni guira'ti cos ni rlajztu gunnäj bejṉ la'tu, sigajcza coḻyennäjreni, sa'csi si'c caj lo leii xten toMoisés, näjza lo diidx ni bacuaa redad ni gunii xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Coḻjiu' nez rolä' nani najc dää, sa'csi gulajg najc rolä', gulajg najcza nezyuj nani rinä bejṉ lo yäḻrunijt, luxh xhidajlreni riu' nejzga. ");
INSERT INTO zawNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Sa'csi dää najc rolä', dääza najc nezyuj nani rinä bejṉ nez loj yäḻnabajṉ, niluxh guxii najc renani rdxäl nezyujga. ");
INSERT INTO zawNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Räjpzani: ―Coḻnatiro rebejṉ nani rlajz gusguee la'tu. Rniisireni rusule'reni xtidx Dios. Rluiisi nadolajzreni si'c te xiil, niluxh direni gac. Alga si'c loob najcreni, rutie'chreni bejṉ si'c re'ch xiil che riädchu' loob lojreni. ");
INSERT INTO zawNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Dzuun nani rujnreni sujn gumbeetureni. Anajntu di uub xcaj lo reyaguejch, diza iigw xcaj lo guechbiojb. ");
INSERT INTO zawNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ni'cni lo guiraa reyagsa'c rcaj ninexhsa'c lojni, per lo guiraa reyajg ni xhet yagsa'cdi, ganax ninejxh ni di ganaxsa'c rcaj lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Digacdi xcaj ninexhdxuudx loj te yajg ninexhsa'c. Di gacdiza xcaj te ninexhsa'c loj te yajg ni di gac yagsa'c. ");
INSERT INTO zawNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Guiraa reyajg nani di ninexhsa'c xcaj lojni, nanab guidinni te checni. ");
INSERT INTO zawNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Sigajcza sajc gumbeetu beṉsa'c sa'csi rujnreni dzunsa'c. ");
INSERT INTO zawNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Räjpzani: ―Xhet guiraadi renani rnii, “Dad, Dad”, jiu' lo xcäḻrnibee Dios xhaguibaa. Ganaxtis renani rujn si'cni rlajz Xtadä ni yu' xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sidzujṉ dxej sinii xhidajl bejṉ loä: “Dad, Dad, con lajlu basule'nu xtiidxlu, con lajzalu biläänu rebeṉdxab, con lajzalu biennu remilagwr.” ");
INSERT INTO zawNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Dxejc säpä lojreni: “Dina gumbeä la'tu. Coḻbicaj loä beṉlatsiaj.” ");
INSERT INTO zawNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Räjpzani: ―Chutis nani rucuadiajg diidx nani caniä, luxh ruzoob xtidxä, laani najc si'c te beṉsiṉ nani basoob rolijzni yejc te guilaj. ");
INSERT INTO zawNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Che biajb nisguij, biäjt nis gueuu, gubi' bej, bidinreni yejc yu'ga sas di yu'ga niajb sa'csi sojbni yejc guilajga. ");
INSERT INTO zawNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nani riejn diajgni xtidxä, luxh dini guzoob xtidxä najc si'c te beṉ guyalajz nani basoob rolijzni lo yujxh. ");
INSERT INTO zawNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Che biajb nisguij, biäjt nis gueuu, gubi' beduxh bidinreni yec yu'ga. Dxejc ligurebä'n yu'ga. Lacti xhiroob banijt bejṉga. ");
INSERT INTO zawNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Che gulujx gunii Jesús rediidxga, lacti bidxeloj rebejṉ rediidx ni baluiini, ");
INSERT INTO zawNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","sa'csi baluiini rebejṉ si'cpac te nani rnibee, xhet si'c ruluiidi rebejṉ ni najn leii. ");
INSERT INTO zawNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Che biäjt Jesús yec dajn, xhidajl bejṉ huinajlni. ");
INSERT INTO zawNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Dxejcti biääd te beṉracxhuu ni raḻ tiejxhni nez loj Jesús. Bazuxhijbni, räjpni: ―Dad, palga rlajzlu, sajc gusiajclu narä. ");
INSERT INTO zawNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Dxejcti basgaa Jesús ṉaani, gudajnni dade'ga con ṉaani, räjpni: ―Rlazä jiajclu. Siajc tiejxhlu. Lagajc dxejc gubicaj guejdx ni raḻ tiejxhni. ");
INSERT INTO zawNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Dxejcti räjp Jesús lojni: ―Arniä, rut lojdi gäblu xhi guzajclu. Huijtis lo rebixhojz te badeed gojn ni gunii toMoisés gudeed bejṉ ni riajc, te fii rebixhojzga abiajclu. ");
INSERT INTO zawNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Che biu' Jesús guedx Capernaum, bidzujṉ te capitán romaṉ nani rnibee te gayuu soldaad. Gunabduxhni lo Jesús, ");
INSERT INTO zawNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","räjpni: ―Dad, xmosä naga' rolizä. Di gacdi guiniibni luxh cayanduxhni. ");
INSERT INTO zawNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Räjp Jesús: ―Do'o te gusiacäni. ");
INSERT INTO zawNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Dxejcti räjp capitán lojni: ―Dad, xhet sacädi; di nungäjḻ jiu' guejblu rolizä. Guiniitis te diidx, siacgajc xmosä. ");
INSERT INTO zawNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Narä nacäza xmos rebejṉ ni rnibee, niluxh rnibeäza te gayuu soldaad. Che rniä lo tejni: “Huij”, rijni. Che gäpä loj steeni: “Gudaa”, riädgajcni. Che gäpä loj xmosä: “Bejn dee”, rungajcnini. ");
INSERT INTO zawNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Che biejn diajg Jesús si'c, bidxeloduxhni, räjpni loj renani siädnajlni: ―Rniliä́pac lojtu, nicla neṉ guideb reguedx Israel dina nidxälä te bejṉ ni rililajz si'c rililajz dade're. ");
INSERT INTO zawNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Niluxh rniä, sirii xhidajl beṉzijt nez ladjiaa, nez ladjiät, te jiädcuenäjreni Abram, Isaac, Jacoob lajdx Dios xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Luxh rebeṉ Israel nani niajc xi'n Dios sijreni te laad lo yäḻcäjy cadro soonreni, sauya'reni läjyreni, sidejdtisreni trabajw par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Dxejcti räjp Jesús loj capitán: ―Gubi' rolijzlu. Sigajcni huililajzlu, sigajcza gacni. Dxejc lagajc oṟga biajc xmosni. ");
INSERT INTO zawNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Che bidzujṉ Jesús rolijz Pedr, bahuiini naga' xnansueegr Pedr, cayacxhuuni, yu'ni xliaa. ");
INSERT INTO zawNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Dxejc gudajntis Jesús ṉaani, birigajcni xliaaga. Dxejcti huistie nane'ga, gusloj cagudeedni xhi gau Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Che biu' guxhijṉ, biädnäreni loj Jesús xhidajl bejṉ ni yu' rebeṉdxab lostooreni; con xtiidxni gunibeeni birii guiraa rebeṉdxabga. Basiajczani guiraa rebeṉ racxhuu. ");
INSERT INTO zawNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Si'c bejnni te guzojb diidx ni bacuaa todad Isaías, ni gunii xtidx Dios, che räjpni: Lagajc laani cua'ni rexcäḻracxhuunu, sanäzani rexcäḻnayannu. ");
INSERT INTO zawNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Che bahuii Jesús tre' xhidalduxh rebejṉ guideb gabi cadro suga'ni, gunibeeni tednäjni rexpejṉpacni stelaad ro' nis. ");
INSERT INTO zawNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Dxejcti biääd te beṉnajn loj Jesús, räjpni: ―Mastr, sisiaäza cadrotis chäälu. ");
INSERT INTO zawNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Räjp Jesús lojni: ―Rebäjz rajpreni xpiliääreni, remane' ni rutajt xhaguibaa rajpreni xpitiääzreni, niluxh narä Xi'n Dios ni gujc Niguii dina gapä cadro gaa yecä. ");
INSERT INTO zawNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Stee rexpejṉpacni räjp lojni: ―Dad, basaan chaxgaä ladxä te chacuatzä xtadä. ");
INSERT INTO zawNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Räjp Jesús lojni: ―Gudanajl narä. Basaan sugucua'tz resabeṉgutreni rebejṉ nani najc si'c beṉgut sa'csi najcreni beṉdojḻ. ");
INSERT INTO zawNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Che biu' Jesús neṉ barcw, biu'za rexpejṉpacni lagajc neṉga. ");
INSERT INTO zawNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Dxejc huäjs te bedonduxh lo nisdoo. Lirusiääzni barcw neṉ nisdoo. Luxh Jesús nagayejsni. ");
INSERT INTO zawNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Dxejcti huij rexpejṉpacni huicuäänni, räjpreni: ―Dad, gucnäj nuure te di guetnu. ");
INSERT INTO zawNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Dxejc räjp Jesús: ―¿Xhicuent rdxejbtu, bejṉ ni guxii rililajz? Dxejcti huistieni, gudidxa'ni lo bej näjza lo nisdoo, te biacdxireni. ");
INSERT INTO zawNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Dxejc bidxeloduxh rexpejṉpacni, räjpreni: ―¿Chuni'c najc niguiire? ¡Ahuilaa xho rucuadiajg bej näjza nisdoo xtiidxni! ");
INSERT INTO zawNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Che bidzujṉ Jesús stelaad nisdoo cadro najc lajdx regadarenos, tio'p bejṉ ni yu' beṉdxab lastooreni biädchaglojreni Jesús. Rebejṉga riireni neṉ rebaa, nialazduxhreni, ni'cni rut rajcdi rdejd nezyujga. ");
INSERT INTO zawNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Guredxa'reni räjpreni: ―¿Xhicuent siädchu'lu loonu luj ni najc Jesús Xi'n Dios? ¿La siäädlu ree te gusacsílu nuure luxh gad gaḻdi xoṟnu, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nez te laad, zijte' cadro suga'reni, cayajp bejṉ xhidalro cuch. ");
INSERT INTO zawNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Dxejcti gunab rebeṉdxabga loj Jesús, räjpreni: ―Palga cuäälu nuure, basaan jiu'nu neṉ recuchre. ");
INSERT INTO zawNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Dxejcti räjp Jesús: ―Coḻchäj. Dxejcti biriireni neṉ lastoo redade'ga, huichu'reni neṉ recuchga. Dxejcti guiragajc recuchga caguxuṉreni, huitejbreni ro' te guilaj, biääzreni neṉ nisdoo, gujttireni neṉ nis. ");
INSERT INTO zawNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Rebejṉ ni cayajp recuchga, baxuṉreni, huijreni lajdxreni, huiyeireni diidx guiraa ni guzajcreni näjza ni guzajc redade' ni guyu' rebeṉdxab lastooreni. ");
INSERT INTO zawNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Dxejcti guiraa rebeṉguejdxga huichaglojreni Jesús. Che bahuiireni lojni, gunabduxhreni lojni, jiunejzni lajdxreni. ");
INSERT INTO zawNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Dxejcti biu' Jesús neṉ barcw. Gudejdni stelaad ro' nis te bidzujṉni lajdxni. ");
INSERT INTO zawNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ro'c biädnäreni lojni te bejṉ nani abixu'ṉ ṉaani, ni'ni. Naga'ni lo te da'. Che bahuii Jesús lacti rililajzreni, räjpni loj beṉracxhuuga: ―¡Baspaa lajzlu xi'nä! Agubicaj rextojḻlu. ");
INSERT INTO zawNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Dxejcti gaii beṉnajn ni ruluii xleii Moisés cayujnreni xhigab ensilaareni, caniyaj dee Dios con rextiidxni. ");
INSERT INTO zawNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Dxejc gucbegajc Jesús xhi xhigab cayujnreni, dxejc räjpni lojreni: ―¿Xhicuent cayujntu xhigabguijdx neṉ lastootu? ");
INSERT INTO zawNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Con ni najc guyasiru? Guiniä lo te bejṉ: “Agubicaj rextojḻlu”, o guiniä lo te bejṉ: “Huistie, guzaj.” ");
INSERT INTO zawNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Dec gunä te gacbeetu Xi'n Dios ni gujc Niguii rajp yäḻrnibee lo guedxliujre te gudzucajni dojḻ. Dxejcti räjpni loj beṉracxhuuga: ―Huistie, cua' xta'lu, huij rolijzlu. ");
INSERT INTO zawNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Dxejcti huistie beṉracxhuuga, siini rolijzni. ");
INSERT INTO zawNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Che bahuii rebejṉ lojni, bidxeloduxhreni, gulä'preni xpala'n Dios, ni badeed yäḻrnibeega loj rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Dxejcti birii Jesús cadro basiajcni beṉracxhuu, sä'tini. Dxejc bahuiini loj te dade' ni laa Mateo. Sobga'ni loj te yagxhiil cadro rbej reni ruquijx xcuent guiraloj. Dxejc räjp Jesús lojni: ―Gudanajl narä. Dxejcti huisuni, sanajlni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Cheni sobga' Jesús lo mex cayajwreni rolijz Mateo, biäädza xhidajl rebejṉ nani ruquijx xcuent guiraloj, ni najc rebejṉ ni di gac xpeṉ Israel, gurejzareni lo mex näj Jesús näjza reni najc rexpejṉpacni. ");
INSERT INTO zawNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Che bahuii rebeṉ guidoo, ni laa refarisee, xhi cayujn Jesús, räjpreni loj rexpejṉpac Jesús: ―¿Xhicuent raunäj xmastrtu rebejṉ nani ruquijx xcuent reyuj näjza rebejṉ ni di gac xpeṉ Israel? ");
INSERT INTO zawNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Che biejn diajg Jesús xhi guniireni, räjpni lojreni: ―Rebejṉ nani nadaan dini guiquiin chu gusiajcni, niluxh rebejṉ racxhuu ni'c rquiinreni chu gusiajcreni. ");
INSERT INTO zawNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Coḻchäj te coḻchaseed xhi säloj diidxre ni caj loj reguijtz: “Yäḻrulaslajz rlazä, dina rlazä guniidxtu guidxaa loä.” Sa'csi narä dina niädtedxä rebeṉsa'c, narä siädtedxä rebeṉdojḻ te gusiechlajzreni. ");
INSERT INTO zawNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Dxejcti biääd rexpejṉpac Juan loj Jesús räjpreni: ―Nuure con refarisee rcua'nnu xhidal huält, ¿xhicuent di rexpejṉpaclu gucua'n, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Räjp Jesús lojreni: ―Che ruchṉaa te bi'n, ¿xhixh rac-huin lajz regolnejdx laga suga' bi'n con laareni? Palga yu' xhi sac bi'nga, dxejc sii soonreni, sucua'nreni. ");
INSERT INTO zawNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Rut gundi remiend te ladbiejw con te la' ladcoob sa'csi sixu'n ladcoobga, sutiäjsruni ladbiejwga, sajc xhiroobru cadro biräjsga. ");
INSERT INTO zawNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Niclaza gac guida' bincoob neṉ reguidbiejw, sa'csi reguidbiejw siräjsni dxejc sixe' bin, sinijtza reguijdga. Ni'cni nanab guida' bincoob neṉ reguidcoobza, te si'c nicla tejreni di nit. ");
INSERT INTO zawNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Laḻ ni caniini rediidxga, biääd te dade' ni rnibee neṉ guidoo xten rexpejṉ Israel. Bazuxhijbni nez loj Jesús räjpni: ―Entis gujt xindxa'pä. Gudaa, badzuub ṉaalu yejcni te guibaṉsacni. ");
INSERT INTO zawNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Dxejcti huisu Jesús, sanäni Jairo. Näj rexpejṉpacni sanajlrenini. ");
INSERT INTO zawNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Luxh guyu' te gunaracxhuu nani agujc tzubitio'p ijz cayajcni yäḻguidxbäii. Bidzujṉni nez dejtz Jesús, gudajnni ro' xhajbni, ");
INSERT INTO zawNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","sa'csi bejnni xhigab neṉ lastooni: “Palga sajc canätis ro' xhajbni, siacä.” ");
INSERT INTO zawNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Dxejc gubiré Jesús bahuiini loj gunaaga, dxejc räjpni: ―Gulecdxilajzlu xindxa'pä. Yäḻrililajz xtenlu abasiajclu. Luxh lagajc dxejc biajc gunaaga. ");
INSERT INTO zawNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Cheni biu' Jesús rolijz dade' nani rnibee neṉ xquidoo rexpeṉ Israel, bahuiini rebejṉ ni ṟoḻ bizej näjza xhidajl rebejṉ ni cabedxa' cayoon, li te biejy cayajc, dxejc ");
INSERT INTO zawNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","räjpni loj rebejṉga: ―Coḻguibicaj. Nagayejstis dxa'pga, gajdni guet. Dxejc rebejṉga alga ruxhiznäjreni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Cheni abirii rebejṉ neṉ yu', biu' Jesús, gunaazni ṉaa dxape', dxejc huistie dxape'ga. ");
INSERT INTO zawNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Dxejcti bire'ch diidxga guiraa neṉ reguejdx ni tre' nejzga. ");
INSERT INTO zawNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Che birii Jesús ro'c, huinajl tio'p bejṉni nani di fii. Rbedxa'reni roonreni räjpreni: ―Balaslajz nuure, Xi'n toDavid. ");
INSERT INTO zawNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Che bidzujṉ Jesús cadro caya'nni, gubigreni lojni. Dxejcti gunabdiidx Jesús lojreni, räjpni: ―¿La rililajztu sajc gunä ni rniabtu? Redade'ga basejc diidx, räjpreni: ―Sajc gunluni, Dad. ");
INSERT INTO zawNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dxejcti gudajnni balojreni, räjpni: ―Sugacni si'cpacni rililajztu. ");
INSERT INTO zawNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Lagajc dxejc bixal balojreni. Sas räjppac Jesús lojreni: ―Arniä, na'c chayeitu diidxre, te rut gacbeedi xhi guzajctu. ");
INSERT INTO zawNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Cuantsi biriireni ro'c guslojreni cagutie'chreni diidx xcuent Jesús guideb gabi neṉ reguejdxga. ");
INSERT INTO zawNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Che biriireni cadro biajc baloj rebejṉga, biääd sgaii bejṉ biädnäreni te gop loj Jesús. Yu' xprit beṉdxab neṉ lastoo bejṉga. ");
INSERT INTO zawNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Che barilaagw Jesús xprit beṉdxab neṉ lastoo beṉgopga, guslogajcni caniini. Rdxeloduxh rebejṉ räjpreni: ―Gajdpacnu guihuii sa' redzuunre lajdx rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Dxejc rebeṉ guidoo ni najc refarisee, räjpreni: ―Rbääni rexprit beṉdxab con yäḻrnibee xten beṉdxabro. ");
INSERT INTO zawNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Gudejd Jesús guiraa reguedxro näjza reguedxbäz, basule'ni xtidx Dios neṉ reguidoo xten rexpejṉ Israel. Basääbni diidx xten xcäḻrnibee Dios. Basiajczani guiraloj yäḻracxhuu, guiraloj yäḻguijdx ni rajc bejṉ neṉ reguejdxga. ");
INSERT INTO zawNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Che bahuiini loj rebeṉ xhidajl biaduxhni rebejṉga sa'csi rdebya' lajzreni, rac-huin lajzreni, najcreni si'c najc rexiil nani di ga'p baxtoor. ");
INSERT INTO zawNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Dxejcti räjpni loj rexpejṉpacni: ―Guliipac xhidalduxh beṉ guedxliuj di gan xtidxä, luxh guxii najc reni guluiireni; najcni si'c gäjl ni agojl guilia', niluxh ruti mos ni guilia'ni. ");
INSERT INTO zawNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Coḻnab lo Dad nani najc xtenni guedxliujre te guxhaḻni rebejṉ ni sajc guluii rebeṉ guedxliujre, gacreni si'c mos ni rlia' gäjl. ");
INSERT INTO zawNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Dxejcti gurejdxni guitzubitio'p rexpejṉpacni, badeedni yäḻrnibee lojreni te gurilaagwreni rexprit beṉdxab lastoo bejṉ näjza te gusiajcreni guiraloj yäḻguijdx näjza yäḻracxhuu. ");
INSERT INTO zawNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Laj reguitzubitio'p rexpejṉni ni guleni najc: Simón, ni laaza Pedr; Andrés bejtz Simón; Jacoob xi'n Zebedeo; Juan bejtz Jacoob; ");
INSERT INTO zawNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe; Bartolomé; Tomás; Mateo, ni najc colectoor; Jacoob, xi'n Alfeo; Lebeo ni rniireni Tadeo; ");
INSERT INTO zawNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, te bejṉ ni yu' loj recananita; Judas Iscariote, nani bateed Jesús ladzṉaa rebejṉ nani rdxe'ch lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Guitzubitio'p rebejṉre baxhaḻ Jesús. Balijdxnireni räjpni: ―Na'c chäätu nez cad yu' rebejṉ ni di gumbee Dios. Na'c jiu'tu lajdx rebeṉ samaritaṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Coḻchäxgaa lo rexpejṉ Israel nani agunijt neṉ dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Coḻchäj, coḻzäbdiidx lo rebejṉ, coḻye'tz lojreni xcäḻrnibee Dios abidzuṉgajxh. ");
INSERT INTO zawNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Coḻgusiajc beṉ racxhuu, coḻgusiajc tiejxh rebejṉ ni raḻ guejch tiejxhreni, coḻguspajṉ beṉgut. Coḻgurilaagw xprit beṉdxab lastoo rebejṉ. Ligaj cua'tu yäḻrnibee, ligajza coḻyejn dzuun. ");
INSERT INTO zawNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Räjpzani: ―Na'c chanätu oor, niclaza pla't, niclaza coobr neṉ xdobdäjltu, ");
INSERT INTO zawNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","niclaza guijxh na'c chanätu lo nejz. Na'cza chanätu tio'p xhajbtu, nicla gura'ch, nicla bastoṉ sa'csi bejṉ ni rujn dzuun nungäjḻ xca'ni xhi gauni. ");
INSERT INTO zawNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Räjpzani: ―Che guidzujṉtu xhitis te guedxro, xhitis te guedxbäz, coḻquiil te beṉsa'c. Rolijztisni coḻjia'n dxejli ni jiunejztu guejdxga. ");
INSERT INTO zawNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Cheni jiu'tu neṉ yu', coḻnii xtidx Dios lo rebejṉga. ");
INSERT INTO zawNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Palga najcreni bejṉ ni numbee Dios, sujia'n yäḻrbedxilajz loj rebejṉga. Niluxh palga direni gac beṉsa'c, naaddireni xca'reni xtidx Dios, suguibi' yäḻrbedxilajzga lojtu, coḻjiunejz ro'c. ");
INSERT INTO zawNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Palga direni gusaan jiu'tu rolijzreni, palga di rlajzreni gucuadiajgreni xtiidxtu, dxejc coḻjiunejz rolijz bejṉga, o coḻjiunejz guejdxga, dxejc coḻcuijb guxhuj ni'tu si'c te seen gulälazreni xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Rniliä́pac lojtu, dxej ni gun Dios xcäḻguxhtisni, te yäḻguxhtisroru gun Dios rebejṉga, quela yälguxhtis ni gujc rebeṉ guedx Sodoma näj Gomorra. ");
INSERT INTO zawNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Räjpzani: ―¡Coḻhuiire! Narä suxhaḻä la'tu si'c xile' nez loj reloob, ni'cni coḻgacnasiṉduxh si'c najc te bäḻ, coḻyajcza nadolajz si'c te palom. ");
INSERT INTO zawNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Coḻnatiro rebejṉ sa'csi suteedreni la'tu ladzṉaa rexcuxhtisreni, siguijnzareni la'tu neṉ xquidooreni. ");
INSERT INTO zawNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Sinäzareni la'tu nez loj regubier, nez loj reṟeii xcuent rextidxä, te gusule'tu xtidxä nez lojreni näjza nez loj rebejṉ nani di gumbee Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Cheni chanäreni la'tu nez loj reguxhtis, na'c guntu xhigab xho guiniitu, niclaza guntu xhigab xhicha ni'c guiniitu, sa'csi lagajc Dios suniidx diidx guiniitu oṟga. ");
INSERT INTO zawNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Sa'csi et la'ditu ni guinii dxejc, Sprit xten Xtadtu Dios ni yu' neṉ lastootu, laani guinii neṉ lastootu. ");
INSERT INTO zawNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Luxh rebejṉ suteedreni lagajc bejtzreni ladzṉaa reni ju'treni. Redad suteedreni lagajc xi'nreni, rexi'n bejṉ sidxe'chzareni lo xcuzajnreni te ju't bejṉ xcuzajnreni. ");
INSERT INTO zawNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Guiraa rebejṉ guedxliuj sidxe'chreni lojtu xcuent xtidxä. Nani chanuu lo xtidxä dxej lultli, ni'c sujn gaan yäḻnabajṉ par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Che guirinajlreni la'tu te gusacsíreni la'tu neṉ te guejdx, coḻguxuṉ ro'c, coḻchäj stee guejdx. Rniliä lojtu, ditu gun gaan tedtu guiraa reguejdx xten rexpejṉ Israel ansde jiääd Xi'n Dios ni gujc Niguii. ");
INSERT INTO zawNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Di te bejṉ ni casieedgaj beṉroru lo xmastrni, diza te mos gac beṉroru lo xlam̲ni. ");
INSERT INTO zawNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Te bejṉ ni casieed, rsieedruni te gacni si'c najc xmastrni, sigajcza rujn mos, riuni xtidx xlam̲ni te gacni si'c najc xlam̲ni. Palga rbälajreni Beelzebú nani rnibee beṉdxab, ¿xho direni cuälajza Beelzebú rexi'nni, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Räjpzani: ―Ni'cni na'c guidxejbtu rebejṉ, sa'csi anajntu xheti te cos ni niäuu lojni ni di guidzujṉ dxej guixal lojni, te fii chutis bejṉ lojni. Xhetiza te cos xhiga'tzdi ni di guidzujṉ dxej siejn diajg bejṉ xcuentni. ");
INSERT INTO zawNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Diidx nani rniä lojtu guxhijṉ, coḻguiniini che nianij lo guedxliuj. Rediidx nani rniä chigaj rodiajgtu, coḻguiniini dip, jiaali coḻzuj, guredxa' te jiejnni. ");
INSERT INTO zawNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Na'c guidxejbtu renani rugu't bejṉ, sa'csi direni gun gaan ju'treni xaim bejṉ. Coḻguidxejbru nani rugu't tiexh bejṉ näjza xaim bejṉ neṉ gabijl. ");
INSERT INTO zawNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿La di bejṉ guto' tio'p manbäz ni rutajt por te centaab, ä? Luxh racbee Xtadnu ni yu' xhaguibaa che riajb tejni lo yuj. ");
INSERT INTO zawNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Näjza rexquidxejclu nagab tebgajreni. ");
INSERT INTO zawNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ni'cni rniä na'c guidxejbtu; sajcrutu lo te chinaa manbäz ni rutajt. ");
INSERT INTO zawNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Räjpzani: ―Chutis renani rusule' xtidxä nez loj rebejṉ, narä siniäza xcuentni nez loj xtadä ni yu' xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Guiraa renani di gusule' xtidxä nez loj rebejṉ, sigajcza narä dina guiniä xcuentni nez loj xtadä ni yu' xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Räjpzani: ―Na'c guntu xhigab siädnää́ yäḻrbedxilajz lo rebeṉ guedxliujre, xhet yäḻcuedxidi ni siädnää́, yäḻrdxagdijḻ siädnää́. ");
INSERT INTO zawNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Narä siädnää́ yäḻrdxagdijḻ te bi'n con xtadni; te dxa'p con xnanni; te gulijzni con xnansueegrni. ");
INSERT INTO zawNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ni'cni lagajc resa'tu ni yu' rolijztu sidxe'chreni lojtu. ");
INSERT INTO zawNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Nani sanälajzru xtadni, xnanni, luxh narä dini chanälajz, digacdi gacni xpeṉä; nani sanälajzru xingaanni o xindxa'pni, di gacdiza gacni xpeṉä. ");
INSERT INTO zawNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nani di guu xcrujzni, nalajznu tedni trabajw, jiädnajlni narä, di gacdi gacni xpeṉä. ");
INSERT INTO zawNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nani guidxäl xcäḻnabajṉni lo guedxliujre, sunitni yäḻnabajṉ xhaguibaa. Luxh nani gunijt xcäḻnabajṉni lo guedxliujre xcuent rextidxä, sidxälni yäḻnabaṉsa'c xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Räjpzani: ―Nani guniidx rolijzni jia'ntu, runiidxzani rolijzni jia'nä; luxh nani ruscuääz narä rolijzni, rolijzni ruscuääzzani Gueb Dios nani baxhaḻ narä. ");
INSERT INTO zawNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nani guscuääz te niguii ni rnii xtidx Dios rolijzni sa'csi baxhaḻ Dios niguiiga, sica'za bejṉga lagajc gaan ni xca' niguii ni rnii xtidx Dios. Nani guscuääz te beṉsa'c rolijzni sa'csi beṉsa'cni, sica'zani lagajc gaan ni xca' beṉsa'cga. ");
INSERT INTO zawNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Chutis nani gudeed mase te xhijgtis nis niäḻiuj xcuentä lo rebiuxe're, rniliä́pac lojtu, direni gunijt, sica'pacreni nani nungäjḻ xca'reni. ");
INSERT INTO zawNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Che gulujx baluii Jesús rexpejṉpacni xho gunreni dzuun, dxejcti biriini ro'c te saluiini, chasule'ni diidx lajdx rexpejṉpacni. ");
INSERT INTO zawNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan yu' neṉ latzguiib. Che biejn diajgni xhi cayujn Jesús, baxhaḻni tio'p xpejṉpacni ");
INSERT INTO zawNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","te huinabdiidxreni: ―¿La luj ni najc Crist ni jiääd, ä?, o ¿la silääznu chu stee bejṉ? ");
INSERT INTO zawNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Dxejcti badzu' Jesús diidxre räjpni: ―Coḻchäj, coḻye'tz loj Juan recos nani riejn diajgtu, näjza recos nani ruhuiitu. ");
INSERT INTO zawNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Reni di fii, ruhuiireni; reni di sa, arsiajreni, reni raḻ tiejxhni, abiajc tiejxhreni; reni di jien diajg, ariejn diajgreni; rebeṉgut, ahuäjzreni, gubaṉsacreni. Dxejcti loj rebejṉ proob nani cabäjz xcäḻracnäj Dios cagusule'reni xtidx Dios ni rusḻaa bejṉ neṉ dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Chicbaa renani di jieed narä. ");
INSERT INTO zawNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Cheni sii rebejṉga gusloj Jesús canii loj rebejṉ xcuent Juan: ―¿Chuni'c huihuiitu nez loj reyubijdz? ¿La te biquii ni rusniib bej, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Xhini'c huihuiitu? ¿Te bejṉ ni sucheduxh, ä? Ni najntu rebejṉ nani sucheduxh rbäjzreni rolijz reṟeii. ");
INSERT INTO zawNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","La'tu ¿xhicuent huijtu ro'c? ¿Te fiitu te niguii ni rnii xtidx Dios, ä? O'n. Rniliä lojtu, luxh dini gac bejṉtis ni rnii xtidx Dios; beṉroruni. ");
INSERT INTO zawNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Laa Juan nani rusä't ni bacuaa lo reguijtz cadro caj scree: Narä suxhaḻä te niguii nani guinii xtidxä nez lojlu; laani susucheeni nezyuj nezlojlu. ");
INSERT INTO zawNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Guliipac rniä, loj guiraa rexingaan xten gunaa, nicla tejni gajd guiricaj ni najc te beṉsacduxh loj Dios si'c ni najc Juan Bautist. Niluxh bejṉ nani najc beṉ huinru lo xcäḻrnibee Dios xhaguibaa, bejṉga maazru sajcni loj Juan. ");
INSERT INTO zawNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Cheni gucli dxej ni gusloj rusule' Juan Bautist diidx ṉajli, yu'duxh reni rlajzpac jiu'reni lo xcäḻrnibee Dios ni yu' xhaguibaa con yäḻrdxe'ch, sas reni nadxecha' rlajzreni cuäxuuni xcäḻnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Guiraa reniguii ni gunni xtidx Dios näjza xleii Moisés, gunixgaareni recos ni churu gac, galooli hasta che biäädli Juan Bautist. ");
INSERT INTO zawNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Palga rlajztu chalilajztu, lagajc Juan najc Elías, niguii xten Dios nani bia'n diidx jiääd. ");
INSERT INTO zawNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nani sobdiajg diidx, gucuadiajgni. ");
INSERT INTO zawNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Xhicojn guntebloä rebejṉ nani tre' ṉaj, ä? Najcreni si'c najc rebiuux nani rguijt nez lo guii cadro rdo', rbejdxreni lo sa'reni, ");
INSERT INTO zawNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","rniireni: “Bieḻnu bizej te guya'tu luxh ditu nuya'. Dxejcti bieḻnu redij ni nabaduxh luxh dizatu nioon.” ");
INSERT INTO zawNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Sa'csi che biääd Juan dini niajw dizani niä', luxh räjp rebejṉ najcni te xpejṉ beṉdxab. ");
INSERT INTO zawNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Dxejcti biäḻä narä, Xi'n Dios ni gujc Niguii, rauä, rä'ä dxejcti räjp rebejṉ: “Niguiire rauxha't, rätejzani bin, najcni xamigw rebeṉdojḻ näjza reniguii ni ruquijx xcuent reyuj ni rajx lo gubier.” Luxh loj rebejṉ ni najc xpejṉ Dios yuduxh xcäḻnajn Dios, ni'cni baxhaḻni guiro'p rebejṉre. ");
INSERT INTO zawNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Dxejcti gusloj Jesús gudiḻnäjni rebeṉguejdx cadro benduxhni remilaagwr, sa'csi naaddireni gusiechlajzreni xtojḻreni, sanuutis nabajṉreni neṉ dojḻ. Dxejcti räjpni: ");
INSERT INTO zawNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Gunatiru guedx Corazín! ¡Gunatiro guedx Betsaida! Paru neṉ guedx Tiro näjza guedx Sidón niajc remilaagwr nani gujc guedx lajdxtu, cadxejli nusiejch lajzreni xtojḻreni, cadxejli niajcwreni neṉ godx, nidääb cobdäj yejcreni. ");
INSERT INTO zawNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Luxh rniä lojtu: che guidzujṉ dxej ni gun Dios xcäḻguxhtisni, sidejdrutu castiigw loj rebejṉ ni guläjz guedx Tiro näjza guedx Sidón. ");
INSERT INTO zawNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Luj guedx Capernaum di gunlu xhigab chäslu xhaguibaa; jiäjt neṉ baa jiajblu, sa'csi paru neṉ guedx Sodoma niajc sa' remilaagwr nani gujc guedxlajdxlu, pet ṉajli tresijc guejdxga. ");
INSERT INTO zawNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Luxh rniä lojtu, dxej ni gun Dios xcäḻguxhtisni, trabajwduxhru tedtu loj rebejṉ Sodoma. ");
INSERT INTO zawNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Laa dxejcni räjp Jesús: ―Rliä'pä xpala'nlu Xtadä, Dad xten xhaguibaa näjza guedxliuj, sa'csi bacua'tzlu recosre lo rebeṉnajn, lo rebejṉ ni racbee, te baluiiluni loj rebeṉnadolajz ni najc si'c biuxbäz. ");
INSERT INTO zawNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","O'n. Guliini, Xtadä, sa'csi rujnlu xhigab si'c najc hueen gacni. ");
INSERT INTO zawNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Guiraa recosre abaniidx Xtadä loä, rutru numbeedi xingaanni; xtadtisni rumbeeni. Rutruza numbeedi xtadni, xtebtis xingaanni, näjza loj renani gudeed xingaanni gumbee xtadni. ");
INSERT INTO zawNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Coḻtaa loä guiraatu nani abadxajg, nani rsina', narä sunidxä yäḻrusilajz lojtu. ");
INSERT INTO zawNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Coḻguisieed guntu dzuun si'cni ruluiätu. Coḻhuii xho runä, xho nacä nadolajz, dizana gacä beṉnayedxlajz neṉ lastoä, ni'cni sidxäl xaimtu yäḻrusilajz. ");
INSERT INTO zawNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sa'csi guyasi najc xtzunä ni ruluiätu, dizani gac naganduxh. ");
INSERT INTO zawNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Che sasaj Jesús nez loj reyuj cadro naga' triuu, luxh dxejga najc dxej ni rusilajz rexpejṉ Israel, calaan rexpejṉpacni, guslojreni calädxa'reni doj lo triuu te cayajwrenini. ");
INSERT INTO zawNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Che bahuii rebeṉ guidoo ni laa farisee, räjpreni loj Jesús: ―Ahuii xho rujn rexpejṉpaclu dzuun nani di nungäjḻ gunreni dxej nani rusilajz bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Luxh laani räjpni lojreni: ―¿La gajdtu goḻ xhi caj loj reguijtz xcuent ni bejn toDavid che gulannäjni rexpejṉni, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Biu'reni xquidoo Dios, gudajwreni yätxtiil nani di nungäjḻ gauni, nicla laani, niclaza rebejṉ nani sanäni, sa'csi yätxtiilga rebixhojztis rajwni. ");
INSERT INTO zawNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","O ¿la gajdtu goḻ lo reguijtz xten leii cadro caj xcuent rebixhojz, ä? Laareni riu'reni neṉ reguidoo dxej ni rusilajz bejṉ, rujnreni xtzuunreni niluxh xhet dojḻdi rujnreni. ");
INSERT INTO zawNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Narä rniä lojtu, ree suga' tej nani sajcru loj guidooga. ");
INSERT INTO zawNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Paru niacbeetu xhi säloj dee: “Yäḻrulaslajz rlazä, xhet yäḻrejtdi guidxaa”, ditu nucuaquij redee ni xhet bejndi. ");
INSERT INTO zawNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sa'csi narä Xi'n Dios ni gujc Niguii rnibeä dxej ni rusilajz rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Che birii Jesús ro'c, biu'ni te xquidobäzreni. ");
INSERT INTO zawNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ro'c suga' te bejṉ ni gubijdz te ṉaani. Luxh sa'csi caguiilreni xho gucuaquijreni Jesús, gusloj canabdiidxreni lojni, räjpreni: ―¿La rusaan leii gusiajcni beṉracxhuu dxej ni rusilajz bejṉ, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Badzu' Jesús diidxre lojreni, räjpni: ―Chutejtu ni rajp te xiil niluxh palga guitejbni neṉ bisie che gaḻ dxej ni rusilajz bejṉ, ¿xhixh dini cuää xiilga neṉ bisie, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sacduxhru te bejṉ loj te xiil, ni'cni susaan leii gun bejṉ dzunsa'c dxej nani rusilajz bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Dxejcti räjpni loj dade'ga: ―Baslii ṉaalu. Che basliinini, dxejc biajc ṉaani, gujcni tebloj si'c najc stelaad ṉaani. ");
INSERT INTO zawNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Dxejcti birii rebeṉ guidoo ni laa farisee, bachagsa'zareni te bia'nreni diidx ju'treni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Che gucbee Jesús xhi xhigab cayujnreni, biriini ro'c. Xhidajl bejṉ sanajlni, dxejc basiajc Jesús guiraa rebeṉracxhuu. ");
INSERT INTO zawNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Dxejc räjpni lojreni: ―Na'cpac gäbreni chu najcni. ");
INSERT INTO zawNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Si'c gujc te gusojb diidx ni gunii Isaías ni gunii xtidx Dios che räjpni: ");
INSERT INTO zawNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Deeni najc xmosä nani aguleä, laani sanälazä, laani rbanälazä, sudedä sprit xtenä lojni te gusule'ni yäḻguxhtis xtenä lo guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Dini tiḻnäj bejṉ, dizani cuedxa'; rudza jiejndi diajgni xse'ni lad nezyuj. ");
INSERT INTO zawNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Dini qui'ch nicla te nijt ni cabiejc, dizani gusuii te duxiil ni cayujn guxh, dxejli che gunni gaan guinibeeni yäḻguxhtis. ");
INSERT INTO zawNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Lajtisni sustioob lastoo rebeṉ ni digac xpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Dxejcti biädnäreni loj Jesús te bejṉ ni di fii, dizani guinii, yu' te beṉdxab lastooni. Dxejcti basiajc Jesúsni, te gujc guniini, te gujcza bahuiini. ");
INSERT INTO zawNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Guiraa rebejṉ bidxelojreni, räjpreni: ―¿Xhaa laa Xi'n toDavidni, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Che biejn diajg rebeṉ guidoo ni laa farisee rediidxga, räjpreni: ―Bejṉre rbää rebeṉdxab con yäḻrnibee xten Beelzebú ni rnibee loj rebeṉdxab. ");
INSERT INTO zawNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Che gucbee Jesús xhi xhigab cayujnreni, dxejc räjpni: ―Guiraa yäḻrnibee nani rlia' sa'ni sinitloj; te guedxro sigajc te famil nani rlia' sa'reni, nani ridiḻnäj sa'reni, sinitlojreni. ");
INSERT INTO zawNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sigajcza palga beṉdxab rbää sabeṉdxabni, silia' sa'reni, dxejc ¿xho gac chanuu xcäḻrnibeereni? ");
INSERT INTO zawNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Palga narä rbää́ rebeṉdxab con yäḻrnibee xten Beelzebú, ¿chu xcäḻrnibee rajc rbää rexpejṉtu beṉdxab, ä? Ni'cni lagajc laareni suluiireni xhet laadi rujntu xhigab. ");
INSERT INTO zawNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Palga narä rbää́ rebeṉdxab con Xprit xten Dios, guliipacni abidzujṉ xcäḻrnibee Dios lojtu. ");
INSERT INTO zawNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Bahuilaare. ¿Xho gac jiu' te bejṉ cuan rolijz te beṉdaan, xho gac cuanni xhixten bejṉga, palga dini gulibxgaani beṉdaanga? Che abiliib bejṉga, sajc cuanni rexhixten bejṉga. ");
INSERT INTO zawNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Nani xhet yu'di xladä, rdxe'chni loä. Nani di jiädnajl narä, rutie'chni reni siädnajl narä. ");
INSERT INTO zawNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Ni'cni rniä guira'ti dojḻ, guira'ti yäḻrusguee xte bejṉ sajc gusiäjḻ lajzni xtebtis yäḻrniyaj Sprit Dxan xten Dios di Dios gusiäjḻ lajzni. ");
INSERT INTO zawNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Chutis ni guinii xhi te diidx yäḻrniyaj Xi'n Dios ni gujc Niguii sajc gusiäjḻ lajzni, luxh chutis ni guiniyaj Sprit Dxan xten Dios, di Dios gusiäjḻ lajzni, nicla lo guedxliujre, niclaza xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Palga nasa'c te yajg sicaj ninexhsa'c lojni, per che di yajg gac yagsa'c, xho xcaj ninexhsa'c lojni. Ni'cni huenliisi siembeetu te yajg che fiitu xho najc ninejxh ni rcaj lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Sa' la'tu beṉguijdx ni najc si'c te bäḻ niälasduxh, ¿xho gac guiniitu te didxsa'c?, ni ro' bejṉ rniitis rexhigab ni yu' neṉ lastoo bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Te beṉsa'c rniini didxsa'c, sa'csi ganax xhigabsa'c yu' neṉ lastooni, te beṉguijdx rniitisni cosguijdx sa'csi ganax xhigabguijdx yu' neṉ lastooni. ");
INSERT INTO zawNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Narä rniäza, guiraa redidxguijdx nani rnii bejṉ sudeedreni cuent lo Dios cheni gunni yäḻguxhtis, ");
INSERT INTO zawNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","sa'csi lagajc rextiidxlu sujn guinii Dios najclu beṉsa'c, lagajc rextiidxlu sujn gunijtlu lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Dxejcti rebejṉ ni ruluii xleii toMoisés näjza rebeṉ guidoo ni laa farisee, räjpreni loj Jesús: ―Mastr, nuurnu rlajznu guihuiinu te seen; bejn te milagwr te fiinuni. ");
INSERT INTO zawNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Badzu' Jesús diidxre, räjpni: ―Rebeṉguijdx ni rusguee rniab te seen, niluxh xhetru seendi fiireni xseentis Jonás, dade' ni gunii xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sa'csi lagajc si'cni guyu' Jonás xque' te bälro choṉ dxej, choṉ yääl, si'cza chu Xi'n Dios ni gujc Niguii neṉ lastoo guedxliuj choṉ dxej, choṉza yääl. ");
INSERT INTO zawNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Cheni gac yäḻguxhtis xten Dios pet sistie rebejṉ ni siääd Nínive te fiireni gac yäḻguxhtis rebejṉ ni tre' lo guedxliuj ṉaj, niluxh säjb rebejṉ Nínive abanijt rebejṉre sa'csi rebeṉ Nínive basiejch lajzreni, bia xtojḻreni che basule' Jonás xtidx Dios lojreni. Luxh nani yu' lojtu ṉaj, sacduxhruni loj Jonás. ");
INSERT INTO zawNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Näjza reiṉ xten rebeṉ sur sistieni te fiini gac yäḻguxhtis rebejṉ ni tre' lo guedxliujre ṉaj, niluxh näjzani säjbni abanijtreni. Sa'csi laani zitduxh biriini te biädcuadiajgni reyäḻnajn xten Salomón, luxh nani yu' lojtu ṉaj nanduxhruni loj Salomón. ");
INSERT INTO zawNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Räjpzani: ―Cheni ṟii te spritdxab neṉ lastoo te bejṉ, ricanzajni nez lo reyubijdz, ritiilni cadro gusilajzni, per cad rdxäldini. ");
INSERT INTO zawNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Dxejcti rujnni xhigab, naani, guibisacä cadro biriä. Cheni rbisacni ro'c, rdzujṉni si'c rdzujṉ te bejṉ neṉ te yu' ni naya neṉni, naliobsa'cni, sucheeni, luxh rut rbäjzdi ro'c. ");
INSERT INTO zawNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Dxejcti rijni, rixiini sgajdz sprit nani najc nadxuudxru lojni te jiädläznäjrenini neṉ lastoo bejṉga. Dxejcti rxhiṉduxhru bejṉga lojni gujcni galoo. Sigajcza gac rebejṉ ni tre' lo guedxliujre ṉaj. ");
INSERT INTO zawNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Laḻ ni caninäjni rebejṉ, bidzujṉ xnanni con rebejtzni, suga'reni rolä' rlajzreni guiniireni lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Dxejcti biääd tej ni räjp loj Jesús: ―Xnanlu näjza rebejtzlu suga' rolä' rlajzreni guininäjreni luj. ");
INSERT INTO zawNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Laani badzu'ni diidx lo bejṉga räjpni: ―¿Chuni'c najc xnanä? ¿Chuni'c najc rebetzä? ");
INSERT INTO zawNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Dxejcti basgaani ṉaani nez loj rexpejṉpacni, räjpni: ―¡Redee najc xnanä redeeza najc rebetzä! ");
INSERT INTO zawNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Chutis nani rujn si'cni rnibee Xtadä ni yu' xhaguibaa ni'c najc betzä, ni'c najc bisianä, ni'cza najc xnanä. ");
INSERT INTO zawNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Lagajc dxejga birii Jesús royu'ga, huicueni nez ro' nisdoo. ");
INSERT INTO zawNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Xhidalduxh bejṉ bire' cadro suga'ni, sas biu'ni neṉ te barcw, ro'c gurejni. Dxejcti rebejṉ gurej nez lo plaii. ");
INSERT INTO zawNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Dxejc gusloj caguluii Jesús con recuent, räjpni: ―Coḻcuadiajg. Birii te dade' ni rbe'c binij te cue'cni binij. ");
INSERT INTO zawNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Laḻ ni cabe'cni binij yu' binij ni bitejb gajxh nez ro' nesiuj, biääd remane' ni rutajt, sas gudajwreni binijga. ");
INSERT INTO zawNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yu' binij ni bitejb nez neṉ reguij cadro guxii yu' yuj. Gulengajc binijga sa'csi direni nibej jiät neṉ yuj. ");
INSERT INTO zawNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Che birii gubijdx, bigoḻreni sa'csi xhetiza xlobaani, dxejc gubijdzni. ");
INSERT INTO zawNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yu'za binij ni bitejb neṉ reguejch. Che guroob reguejchga, dini nusaan niroob regäjle', gubijdztireni. ");
INSERT INTO zawNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Guyu' binij ni gurej lo reyusa'c, ro'c gucduxhni. Yu' binij cuaj te gayuu, yu'za binij cuaj gayojṉni, yu'za ni cuaj gaḻbitzuuni loj cade tej binij ni gurej. ");
INSERT INTO zawNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nani rsobdiajg diidx gucuadiajgni diidxre. ");
INSERT INTO zawNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Dxejcti gubig rexpejṉpacni, gunabdiidx lojni, räjpreni: ―¿Xhicuent rusule'lu diidx loj rebejṉ con recuent? ");
INSERT INTO zawNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Dxejcti badzu' Jesús diidx rajpni lojreni: ―Sacnäj Dios la'tu te gacbeetu recos xhiga'tz xten xcäḻrnibee Dios xhaguibaa, luxh laareni digacdi gacbeerenini. ");
INSERT INTO zawNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Chutis ni arajp yäḻracbee, sica'runi te gapruni yäḻracbee. Sas nani guxii rajp yäḻracbee, guiraa yäḻracbee ni rajpni sibicaj. ");
INSERT INTO zawNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ni'cni rniä lojreni con recuent sa'csi mase cadxelojreni, direni fii, mase cacuadiajgreni di diajgreni jiejn, xhet racbeedireni. ");
INSERT INTO zawNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Laareni najcreni si'c te soob diidx ni gunii Isaías, dade' ni gunii xtidx Dios, che räjpni: Siejn diajgpactu, niluxh xhetliidi gacbeetu, sidxelojpactu, niluxh ditu fii. ");
INSERT INTO zawNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Sa'csi guyalajz rebejṉre, lastooreni najc si'c te guij, di diajgreni jiejn, luxh niäuza balojreni, didi fisa'creni con balojreni, didi jiejnza diajgreni, didi gacbeeza lastooreni, didi gusiejch lajzreni guibi'reni loä te gusiacä lastooreni. ");
INSERT INTO zawNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’La'tu coḻguibalaznäj balojtu sa'csi rhuisa'ctu, riensa'cza diajgtu. ");
INSERT INTO zawNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Rniliä́pac, xhidajl redade' ni gunii xtidx Dios, näjza xhidajl beṉsa'c rlazduxh nuhuii sa' recos ni cahuiitu, luxh direni nuhuiini, rlajzreni niejn diajgreni sa' rediidx nani cayejn diajgtu, luxh di diajgreni niejnni. ");
INSERT INTO zawNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Coḻcuadiajg xhi säloj xcuent bejṉ nani rbe'c binij. ");
INSERT INTO zawNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Rebejṉ nani rucuadiajg diidx xten xcäḻrnibee Dios, niluxh direni gacbeeni, najcreni si'c najc binij nani bitejb nez ro' nesyuj; riääd beṉdxab rudzucajni rediidx nani biu' neṉ lastooni. ");
INSERT INTO zawNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Rebinij nani bitejb nez neṉ reguij, najc si'c rebejṉ nani rucuadiajg diidx, gustli rca'reni diidxga, ");
INSERT INTO zawNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","luxh guxii yu' xlobaani, direni sutijp. Che rdejdreni trabajw, che rdxe'ch bejṉ lojreni, sa'csi rucuadiajgreni xtidx Dios, rusiejch lajzreni, rbälazni diidxga. ");
INSERT INTO zawNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Rebinij nani gurej neṉ reyaguejch säloj rebejṉ nani rucuadiajg rextidx Dios rujnrureni te gunreni dzuun te ga'preni yäḻnasa'c ni yu' lo guedxliujre. Dxejcti rexcäḻnasa'c xten guedxliujre rusgueereni. Guiraa recosre rutau lo xtidx Dios neṉ lastoo rebejṉre, dini gusaan gac te cosechsa'c neṉ lastoo rebejṉre. ");
INSERT INTO zawNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Dxejc rebinij nani rtejb lo reyusa'c, ni'c najc si'c rebejṉ nani rucuadiajg xtidx Dios, nani racbee diidxga, nani rutie'ru sa'reni te racxhidajlreni. Yu' bejṉ ni najc si'c binij ni gujc te gayuu; yu' bejṉ ni najc si'c binij ni gujc gayojṉ; yu'za bejṉ ni najc si'c binij ni gujc gaḻbitzuu. ");
INSERT INTO zawNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Dxejc bij Jesús stee cuent, räjpni: ―Xcäḻrnibee Dios xhaguibaa najc si'c te bejṉ nani gule'c ganax triusa'c lo xyujni. ");
INSERT INTO zawNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Laḻ nagaguejs bejṉga, biääd te bejṉ nani rdxe'ch lajz loj xpaxhuaan binijga, biädle'cni bedz cuanguejch lo xtriuu bejṉga, dxejcti sääni. ");
INSERT INTO zawNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Cheni gulejn triuuga, birii doj lojni, dxejc biricaj näjza cuanguejch ro'c. ");
INSERT INTO zawNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Dxejcti räjp remos lo xḻam̲reni; “Dad, ¿la et ganax triusa'c di gule'clu, ä? ¿Caxh bazaj cuanguejchre?” ");
INSERT INTO zawNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Räjp xlam̲reni: “Te bejṉ ni rdxechlajz loä biädle'cchani.” Dxejcti gunabdiidx rexmosni räjpreni: “¿La rlajz guejblu cholädxa'nu recuanguejchga, ä?” ");
INSERT INTO zawNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Dxejc räjp xlam̲reni: “Na'c, sa'csi che guiliäädxtu cuanguejchga, nägajcza triuu guiliäädxtu. ");
INSERT INTO zawNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Coḻsaan tioobreni tebloj. Che guire' cose'ch, dxejc guinibeä remos gutiexgaareni cuanguejch, guliibrenini gacni ters, dxejcti checni. Dxejcti sajc gutie'reni triuu chucheeni neṉ yu'.” ");
INSERT INTO zawNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Bijza Jesús stee cuent räjpni: ―Xcäḻrnibee Dios xhaguibaa najcni si'c te bedz muxhtas nani cue'c te bejṉ lo xyujni. ");
INSERT INTO zawNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Gulii bejdzga najc bäze'ru loj guiraa rebejdz, per che roob yajgga, rajcni guroobru loj guiralii recuaan, rajcni te yagro, luxh riääd remane' ni rutajt riädyujn xpitiääzreni lo xajcw yajgga. ");
INSERT INTO zawNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Bijzani stee cuentre, räjpni: ―Xcäḻrnibee Dios xhaguibaa najc si'c levaduur nani rugu'ch te gunaa lo choṉ mediid ariṉ, dxejc ni'c rusaguijni guideb cojbga. ");
INSERT INTO zawNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Baluii Jesús guiraa rebejṉ ganaxtis con recuent, xhetiru stee mood nuluiini, ganaxtis con cuent guniini lojreni. ");
INSERT INTO zawNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Si'c bejnni te guzojb xtidx dade' ni gunii xtidx Dios che bacuaani lo reguijtz, räjpni: Suiyä diidx con recuent, suiyä diidx xcuent recos ni naga'tz che bencheeli Dios guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Dxejcti basadiidx Jesús rebejṉ, biu'tini neṉ yu' cadro bire' rexpejṉpacni lojni, räjpreni lojni: ―Basule' loonu xcuent cuanguejch ni guyu' loniaa. ");
INSERT INTO zawNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Räjp Jesús lojreni: ―Bejṉ nani rbe'c retriusa'c, najc Xi'n Dios ni gujc Niguii; ");
INSERT INTO zawNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","loniaaga najc guedxliuj; retriusa'c najc rebejṉ nani najc xpejṉ Dios, nani rucuadiajg xtiidxni; recuanguejchga najc rebejṉ ni najc xpejṉ beṉdxab. ");
INSERT INTO zawNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Bejṉ nani rdxe'ch lajz najc lagajc beṉdxab. Cose'ch säloj che nitloj guedxliuj; reni gutie' cose'ch najc rexangl Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Sigacni guire' recuanguejch te chääni lo guiboo te checni, sigajcza gac che gac fis guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Xi'n Dios ni gujc Niguii suxhaḻ rexanglni te jiädgutie'reni, te jiädlääreni lo xcäḻrnibeeni guiraa renani rujn riajb bejṉ neṉ dojḻ, näjza reni rujn cosguijdx. ");
INSERT INTO zawNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Susäḻreni rebejṉga neṉ te oṟ cadro cayecduxh. Ro'c sonduxhreni, sauya'reni läijyreni. ");
INSERT INTO zawNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Dxejcti rebeṉsa'c sidimbicha'reni si'c gubijdx lo xcäḻrnibee Xtadreni. Palga sobdiajgtu, coḻgucuadiagsa'c. ");
INSERT INTO zawNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Räjpzani: ―Si'cza xcäḻrnibee Dios xhaguibaa najc si'c te cossacduxh ni naga'tz lo te yuj loniaa. Bidxäl te dade'ni, luxh bacuatzsacnini. Dxejcti rbalajzni, huijni, huito'ni guiraa xhixtenni te rajpni meel siini yujga. ");
INSERT INTO zawNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Räjpzani: ―Xcäḻrnibee Dios xhaguibaa najcza si'c najc te dad rapduxh nani caguiil perlsa'c te siini. ");
INSERT INTO zawNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Che bidxälni te perlsa'c, tejni sacduxh, bato'ni guiraa xhixtenni te gusiini perlga. ");
INSERT INTO zawNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Räjpzani: ―Xcäḻrnibee Dios xhaguibaa najcza si'c te guijxh ni rusäḻ bejṉ lo nis te rniaazreni guiraloj cuaa bäjl. ");
INSERT INTO zawNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Cheni agudxajni, rbäärenini nez ro' nisdoo, te ro'c rbereni loj rebäjl. Rebäjl ni najc hueen rucheeni neṉ te dxijm̲; nani di gac hueen rusäḻrenini te laad. ");
INSERT INTO zawNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Si'cza gac che gac fis guedxliuj; sirii rexangl Dios te sudzucajreni rebeṉguijdx lo rebeṉsa'c. ");
INSERT INTO zawNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Dxejcti susäḻreni rebeṉguijdx neṉ te oṟ cadro cayecduxh; ro'c sonduxhreni, sauya'reni läjyreni. ");
INSERT INTO zawNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Dxejcti gunabdiidx Jesús lojreni, räjpni: ―¿La racbeetu guiraa ni caniä lojtu, ä? Dxejcti räjpreni: ―O', racbeenuni Dad. ");
INSERT INTO zawNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Dxejcti räjpni lojreni: ―Cheni rsieed te bejṉ nani najn leii xcuent yäḻrnibee xten Dios xhaguibaa, najcni si'c te lam̲ nani rajc rbää lo rexcäḻnasa'cni recos ni nacoob, näjza recos biejw. ");
INSERT INTO zawNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Che gulujx basule'ni recuentre, biriini ro'c, sääni. ");
INSERT INTO zawNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Huijni lagajc lajdxni. Ro'c gusloj caguluiini neṉ xquidobäzreni ro'c. Dxejcti rdxeloduxh rebeṉ ro'c, räjpreni: ―¿Caro bisieedni reyäḻnajnre? ¿Xho rajc rujnni remilagwr? ");
INSERT INTO zawNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿La et laadi dee ni najc xi'n carpinteer, ä? ¿La et Mariidi najc xnanni? Dee ni najc bejtz Jacoob, José, Simón con Judas. ");
INSERT INTO zawNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Luxh rebisiajnni rbäjzreni lo guejdxre. ¿Cacharo bisieedni guiraa nani caguluiini? ");
INSERT INTO zawNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Dxejcti cayujnreni xhigab chugan la guliini, dxejc räjp Jesús lojreni: ―Guiraa rebejṉ rinälajz te niguii nani rnii xtidx Dios, biädla rebeṉ lajdxpacni direni jiu xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ni'c dini niujn xhidal milagwr ro'c sa'csi direni chalilajz xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Lagajc neṉ redxejga Herodes, ni laaza tetrarca, biejn diajgni diidx xcuent ni cayujn Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Dxejc räjpni lo rexmosni: ―Dee najc Juan Bautist. Pet agubaṉsacni lo rebeṉgut, ni'cni rajpni yäḻrnibee te rujnni remilagwr. ");
INSERT INTO zawNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Si'c gunii Herodes sa'csi laani basäuuni Juan neṉ latzguiib. Niluxh gunibeeni biliibni con cadeṉ neṉ latzguiib xcuent Herodías, ni gujc chääl bejtzni Felipe. ");
INSERT INTO zawNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Bidxe'chni sa'csi räjp Juan lo Herodes: ―Et laadi rujnlu rbäznäjlu chääl bejtzlu. ");
INSERT INTO zawNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Rlajz Herodes nugu'tni Juan, luxh rdxejbni rebeṉguejdx, sa'csi guiraareni rniireni Juan najc te niguii ni rnii xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Dxejc che gojl laj Herodes gujc lanij, birii xindxa'p Herodías te baya'ni nez loj regolnejdx. Luxh sa'csi bidxaglazduxh Herodes baya'ni, ");
INSERT INTO zawNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","räjpni loj gunaaga: ―Gunab xhitis ni rlajzlu, sa'csi gudix lazä gunidxä ni guiniabtislu. ");
INSERT INTO zawNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Dxejcti gunaaga, abalijdx xnannini, räjpni lo Herodes: ―Loj te platóṉ baniidx bitiuyejc Juan Bautist. ");
INSERT INTO zawNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Diidxga benhuin lastoo ṟeii Herodes, per sa'csi abia'n diidx, niluxh abiejn diajg rebejṉ, gunibeeni gudeedreni nani guiniab gunaaga. ");
INSERT INTO zawNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Dxejcti gunibeeni biru' yejc Juan Bautist neṉ latzguiib. ");
INSERT INTO zawNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Sas biädnäreni yejcni lo te platóṉ, badeedrenini loj gunaaga. Dxejcti gunaaga badeednini lo xnanni. ");
INSERT INTO zawNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Dxejcti bidzujṉ rexpejṉ Juan sanäreni togoolga te huicua'tzrenini. Dxejcru huisa'nreni diidx loj Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Che biejn diajg Jesús xhi guzajc Juan, xtebni huä'pni neṉ te barcw huijni stee laad nez lo reyubijdz. Che gucbee rebejṉ caro sääni, huinajlreni Jesús lo yuj. Guiraa neṉ reguejdxga biriireni. ");
INSERT INTO zawNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Che birii Jesús neṉ barcw, bahuiini loj xhidalduxh bejṉ, dxejc balazlajznireni, basiajcni rebejṉ nani racxhuu. ");
INSERT INTO zawNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Cheni acayu' guxhijṉ, gubig rexpejṉpacni lojni räjpreni: ―Rut rbäjzdi nez lo reyubijdzre, niluxh agudxej ṉaj. Basadiidx rebejṉ te jiireni nez rerench te chasiireni xhi gaureni. ");
INSERT INTO zawNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Räjp Jesús: ―Xhicuent jiireni. La'tu coḻgudeed xhi gaureni. ");
INSERT INTO zawNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Dxejcti räjpreni: ―Xhetru rajpdinu ree. Gaiitis yätxtiil näjza tio'p bäjl rajpnu. ");
INSERT INTO zawNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Laani räjpni: ―Coḻtanäni ree. ");
INSERT INTO zawNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Dxejcti gunibeeni gurej rebejṉ lo guixa'. Dxejcti cua'ni guigaii yätxtiil näjza guiro'p bäjl, guläsni lojni xhaguibaa, badeedni xquixhtios lo Dios, dxejcti gula'ni reyätxtiil. Badeednini loj rexpejṉpacni. Dxejcti rexpejṉpacni gudisrenini loj rebeṉ xhidajl. ");
INSERT INTO zawNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Guiraareni gudajw, gudxaj xque'reni. Dxejcti batie'reni yätxtilbiujy nani bia'n. Si'cti tzubitio'p dxijm̲ gudxajni. ");
INSERT INTO zawNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Renani gudajw najcreni si'cti gaii miḻ niguii, xhet näjdi regunaa niclaza rebiuux bigab. ");
INSERT INTO zawNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sas gunibee Jesús biu' rexpejṉpacni neṉ barcw te ganidreni tedreni stee lad nis laḻni casadiidxni rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Che gulujx basadiidxni rebejṉ, huä'p Jesús yecdajn te xtebni guninäjni Dios Xtadni. Che gojl guxhijṉ, ro'c sugaxteb Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Luxh barcw galäii lo nis sasaj. Cagusnibduxh reoḻ barcw, liriääzni lo nis sa'csi cabi' beduxh cadro sääreni. ");
INSERT INTO zawNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Rsildooru gubig Jesús, bidzujṉni lojreni, siädsajni lo nisdoo. ");
INSERT INTO zawNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Che bahuii rexpejṉpacni siädsajni lo nisdoo, bidxejbreni, räjpreni: ―Coḻhuii te fantasmni ―guredxa'reni sa'csi bidxebduxhreni. ");
INSERT INTO zawNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Dxejc gunii Jesús lojreni, räjpni: ―Na'c guidxejbtu, laa naräni; coḻsutijp lastootu. ");
INSERT INTO zawNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Dxejcti gunii Pedr lojni, räjpni: ―Dad, palga lujni, gunibee jiälä lojlu nez lo nisre. ");
INSERT INTO zawNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Räjp Jesús: ―Gudaa pues. Dxejcti birii Pedr neṉ barcw gusajni lo nis te sääni nez loj Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Che bahuii Pedr beduxh ni cabi', bidxejbni, dxejc gusloj cayääzni neṉ nisdoo. Guredxa'ni, räjpni: ―Dad, ¡gulää narä! ");
INSERT INTO zawNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Lagajc dxejc gunaaz Jesús ṉaani, räjpni loj Pedr: ―Guxii rajplu yäḻrililajz. ¿Xhicuent guctio'p lajzlu? ");
INSERT INTO zawNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Che huä'preni neṉ barcw, guläzgajc bej. ");
INSERT INTO zawNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Dxejcti renani sää neṉ barcw bazuxhijbreni nez loj Jesús räjpreni: ―Guliipacni najclu Xi'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Che gudejdreni lo nis, bidzujṉreni nez lo reyuj xten Genesare't. ");
INSERT INTO zawNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Che biembee rebeṉ ro'cni, batie'chreni diidx guideb gabi lajdxreni. Dxejcti biädnäreni guiraa rebeṉ racxhuu lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Gunabduxhreni gusaanni caṉreni ro' xhajbtisni. Dxejcti guiraa renani gudajn xhajbni, biajcreni. ");
INSERT INTO zawNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Dxejcti gubig gaii rebejṉ nani ruluii leii näjza rebejṉ guidoo ni laa farisee. Siäädreni guedx Jerusalén, räjpreni loj Jesús: ");
INSERT INTO zawNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Xhicuent di rexpejṉpaclu jiu xcostrumbr rebeṉgool? ¿Xhicuent direni gusoob yäḻrdiib ṉaareni che rajwreni? ");
INSERT INTO zawNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Badzu'ni diidx, räjpni: ―¿Xhicuent di la'tu gusoobzatu xtidx Dios? Dee alga riurutu rexcostumbrtu. ");
INSERT INTO zawNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dios gunibeeni xho guntu che räjpni: “Gojp xpala'n xtadlu, xnanlu”, näjza “Nani guiniyaj lo xtadni o loj xnanni, suguetni.” ");
INSERT INTO zawNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Luxh la'tu rniitu sajc gäb chutis bejṉ loj xtadni o loj xnanni: “Digacdi gacnää́tu sa'csi guiraa ni rapä abadedäni lo Dios.” ");
INSERT INTO zawNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Luxh chutis ni guinii si'c, xhetru nanabdi gacnäjni xtadni o xnani. Si'c ni cabälaztu rextidx Dios te gac chanuutu rexcostumbrtu. ");
INSERT INTO zawNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Bejṉ ni rusguee najctu! Laaca gunii Isaías, bejṉ nani gunii xtidx Dios xcuenttu cheni räjpni: ");
INSERT INTO zawNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Rebeṉguejdxre con ro'reni rliä'preni xpala'nä niluxh lastooreni zijt suga' nez loä. ");
INSERT INTO zawNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Xlia'si rajṉreni narä, sa'csi ruluiireni si'c xtidxä reyäḻrnibee xten rebeṉ guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Dxejcti gurejdxni rebejṉ, räjpni lojreni: ―Coḻcuadiajg, coḻyacbee. ");
INSERT INTO zawNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nani riu' ro' bejṉ di guxhiṉ bejṉga, sanga nani ṟii ro' bejṉga ni'cni ruxhiṉ bejṉga. ");
INSERT INTO zawNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Dxejcti rexpejṉpacni gubig lojni, räjpreni: ―¿La najnlu bidxe'ch rebejṉ farisee che biejn diajgreni diidx ni guniilu? ");
INSERT INTO zawNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Dxejc laani räjpni: ―Xhitis yajg nani di Xtadä ni yu' xhaguibaa nusuj siliädxa'ni guideb xlobaani. ");
INSERT INTO zawNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Coḻgusaanreni; lotiä'preni, ruluiireni nezyuj lo salotiä'preni. Luxh palga te beṉ lotiä'p guluii canejz chää stee lotiä'p, guiro'preni sitejbreni neṉ te gueed. ");
INSERT INTO zawNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Räjp Pedr loj Jesús: ―Basule' cuentre loonu. ");
INSERT INTO zawNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Räjp Jesús: ―¿La näjza la'tu ditu gacbee, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿La ditu gacbee guiraa ni rajw bejṉ ru' xque'ni, dxejcti che rdejdni xque'ni, abigo'ṉni? ");
INSERT INTO zawNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Niluxh diidx nani ṟii ro' bejṉ, neṉ lastoo bejṉ ṟiini; dee ni ruxhiṉ bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Sa'csi neṉ lastoo bejṉ ṟii rexhigabguijdx xten rebejṉ ni rugu't sa'ni; xten rebejṉ ni rusguee gunaa; xten rebejṉ ni rusguee chääl sa'ni; xten rebejṉ ni rbajn; xten rebejṉ ni rnii didxxhii lo sa'ni; xtenza rebejṉ ni rutijḻ sa'ni. ");
INSERT INTO zawNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Laa sa' recosre ni ruxhiṉ bejṉ. Che dini gusoob recostumbr xte yäḻrdiib ṉaani, di ni'c guxhiṉ bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Biriiti Jesús ro'c, sääni nez región xten Tiro näjza Sidón. ");
INSERT INTO zawNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nejzga rbäjz te gunaa cananee, cabedxa'ni biäädni lo Jesús, räjpni: ―Dad, xi'n toDavid, balaslajz narä. Xindxa'pä yu' xpej beṉdxab lastooni, niluxh cagusacsíduxhnini. ");
INSERT INTO zawNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Xhet räjpdi Jesús lojni. Dxejcti biädnabduxh rexpejṉpacni lojni, räjpreni: ―Barilaagw gunaare, didi rbedxa'ni siädnajlni luj. ");
INSERT INTO zawNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Dxejcti räjp Jesús lojni: ―Dios baxhaḻ narä lojtis xpeṉ Israel nani agunijt neṉ dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Dxejcti gubig gunaaga, bazuxhijbni nez loj Jesús, räjpni: ―Dad, gucnäj narä. ");
INSERT INTO zawNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Dxejc räjp Jesús lojni: ―Di gac hueen xca' bejṉ xcuxtiil rexi'nni gusäḻnini lo rebä'cw. ");
INSERT INTO zawNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Dxejc räjp gunaaga lojni: ―Guliini Dad, näjza rebä'cw rajw te la' yätxtiil ni rtejb lo mex xten xpaxhuaanni. ");
INSERT INTO zawNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Dxejcti räjp Jesús lojni: ―Nane', lacti guroob najc xcäḻrililajzlu. Sugac si'cni rlajzlu. Lagajc dxejc biajc xindxa'pni. ");
INSERT INTO zawNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Birii Jesús ro'c gudejdni nez ro' nisdoo ni laa Galilee. Huäpgajcni yejc te dajn, ro'c gurejni. ");
INSERT INTO zawNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Xhidajl bejṉ bidzujṉ cad sobga'ni. Siädnäreni rebeṉ ni rajc ni'ni, rebeṉ ni najc lotiä'p, rebeṉ gop, rebeṉ ni xheti ṉaani, näjza xhidalro beṉ racxhuu, bidzuṉnäjrenini nez loj Jesús. Dxejcti basiajcnireni. ");
INSERT INTO zawNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ni'cni lacti bidxeloduxh rebeṉ xhidajlga che bahuiireni rnii regop, riajc reni xheti ṉaani, rsiaj reni rajc ni'ni, ruhuii relotiä'p, dxejc rliä'preni xpala'n Xtios rexpeṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Gurejdx Jesús rexpejṉpacni räjpni lojreni: ―Riaä́ rebejṉre sa'csi agujc choṉ dxej yunäjreni narä luxh xhet ca'direni gaureni. Di rlazä guxhaḻäreni jiireni rolijzreni palga gajdreni gau didi guidxajgreni lo nezyuj. ");
INSERT INTO zawNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Dxejcti räjp rexpejṉpacni lojni: ―¿Xho guidxälnu xhi gau rebeṉ xhidajlre nez lo reyubijzre cadro rut rbäjzdi, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Räjp Jesús lojreni: ―¿Bal yätxtiil ca'tu? Räjpreni: ―Gajdztisni, näjza gaii bälbäze'. ");
INSERT INTO zawNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Sas gunibee Jesús cue rebejṉ lo yuj. ");
INSERT INTO zawNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Dxejc cua' Jesús guigajdz yätxtiilga näjza rebäjl, badeedni xquixtios lo Dios dxejc gula'ni reyätxtiilga näjza rebäjlga badeednireni loj rexpejṉpacni. Dxejcti laareni gudisreni yätxtiilga con rebäjlga lo rebejṉ xhidajlga. ");
INSERT INTO zawNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Guiraareni gudajw, gudxaj xque'reni. Che gulujx gudajwreni, batie'reni reyätxtiil ni bia'nga, gudxaj gajdz dxijm̲ni. ");
INSERT INTO zawNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Renani gudajwga najc si'cti tajp miḻ bejṉ, niluxh xhet näjdi regunaa niclaza rebiuux bigab. ");
INSERT INTO zawNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Dxejcti basadiidx Jesús rebejṉ, biu'tini neṉ barcw te gudejdni lo nisdoo nez región xten Magdala. ");
INSERT INTO zawNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Refarisee näjza resaducee bidzujṉreni lo Jesús, gunabreni gunni te milagwr, gudeedni te seen ni rieṉ xhaguibaali. Niluxh cagusgueesireni, sa'csi rlajzreni guiga' Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Dxejc badzu' Jesús diidxre räjpni lojreni: ―Che rajl gudxej, rniitu: “Saru gac te dxej guixee sa'csi naxniaa xhaguibaa.” ");
INSERT INTO zawNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Che rajl rsil rniitu: “Etlaadi gac te dxej nadxej sa'csi naxniaa xhaguibaa niluxh tre' za.” Xhoxh numbeetu xhi säloj reseen ni rieṉ xhaguibaa, luxh ditu gumbee xhi säloj reseen xcuent redxejre, nalajznu recos ni cayajc. ");
INSERT INTO zawNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Rebeṉ guijdxre, rebeṉ guyalajz rniab te senro, te milagwr, luxh dirureni fii stee milagwr; suhuiitisreni xsen Jonás. Dxejcti basa'n Jesúsreni ro'c, sä'tini. ");
INSERT INTO zawNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Che gudejd rexpejṉpacni stelaad nisdoo biäḻ-lajzreni ninäreni yätxtiil. ");
INSERT INTO zawNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Dxejcti räjp Jesús lojreni: ―Bacuadiajg, coḻnati levaduur xten refarisee näjza resaducee. ");
INSERT INTO zawNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Dxejcti bejnreni xhigab neṉ lastooreni: “Si'c caniini sa'csi dinu niopnä yätxtiil.” ");
INSERT INTO zawNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Luxh gucbee Jesús xhigabga, dxejc räjpni lojreni: ―¿Xhicuent rujntu xhigab xhet yätxtiildi ca'tu, ä? ¡Huinduxh najc xcäḻrililajztu! ");
INSERT INTO zawNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿La gajdtu gacbee? ¿La diza lajztu guinaj che gudisä gaii yätxtiil gudajw gaii miḻ bejṉ, ä? ¿Bal dxijm̲ni batie'tu, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿La diza lajztu guizaj che gudisä gajdz yätxtiil gudajw tap miḻ bejṉ, ä? ¿Bal dxijm̲ni batie'tu? ");
INSERT INTO zawNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Xhicuent ditu gacbee et yätxtiildi cagusä'tä cheni caniä lojtu coḻnati levaduur xten refarisee näjza resaducee? ");
INSERT INTO zawNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Dxejcru gucbeereni dini niäjp: “Coḻnati levaduur xten yätxtiil.” Laani caniini: “Coḻnaáti yäḻruluii xten refarisee näjza resaducee.” ");
INSERT INTO zawNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Che bidzujṉ Jesús región xten Cesarea xten guedx Filipo, gunabdiidx Jesús loj rexpejṉpacni, räjpni: ―¿Chu naj rebejṉ nacä narä Xi'n Dios ni gujc Niguii? ");
INSERT INTO zawNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Laareni räjpreni: ―Yu'reni naj luj najclu Juan Bautist; yu'zareni rnii luj najclu Elías, peta sgaiireni rnii luj najclu Jeremías o stee niguii ni rnii xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Dxejcti räjpni lojreni: ―La'tu, ¿chuni'c rniitu nacä? ");
INSERT INTO zawNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Dxejc räjp Simón Pedr: ―Luj najclu Crist, Xi'n Dios nani nabajṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Badzu' Jesús diidxre, räjpni: ―Chicbaalu, Simón Pedr, xi'n Jonás, sa'csi xhet bejṉdi baluii dee lojlu, Xtadätis ni yu' xhaguibaa baluiinini lojlu. ");
INSERT INTO zawNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Narä rniä lojlu, luj najclu Pedr, nani säloj: “Te guij.” Sa'csi sibäxtiejlu guidxagsa'za renani rililajz xtidxä, niluxh che guetreni, direni nitloj. ");
INSERT INTO zawNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Narä gunidxä yäḻrnibee lojlu te gulijdxlu rebejṉ nani ahuiliilajz xtidxä. Xhitis ni gusaanlu gunreni, o xhitis ni dilu gusaan gunreni, susoob Dios xtiidxlu. ");
INSERT INTO zawNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Dxejcti gunibee Jesús rutlojdi gäb rexpejṉpacni laani najc Guejb Crist. ");
INSERT INTO zawNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Lagajc dxejc gusloj cagusule' Jesús diidx lo rexpejṉpacni, guniini lojreni xho nanabpac chääni guedx Jerusalén te ro'c tedni trabajwduxh ladzṉaa rebeṉgool xten guidoo, ladzṉaa rebixhojz, näjza rebejṉ ni najn xleii Moisés. Guniizani sugu'trenini, niluxh ni riojṉ dxej sibaṉsacni lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Dxejcti huinä Pedr Jesús te laad, gusloj cadiḻnäjnini, räjpni: ―¡Gacnäj Dioslu, Dad! ¡Gurniälojlu gaclu si'c! ");
INSERT INTO zawNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Dxejc gubiré Jesús, räjpni lo Pedr: ―¡Gubicaj loä beṉdxab! Na'c rusiejytislu loä. Luj dilu gun xhigab xten Dios, alga xhigab xten rebeṉguedxliuj rujnlu. ");
INSERT INTO zawNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Dxejcti räjp Jesús loj rexpejṉpacni: ―Palga yu' chu tejtu rlajz guirinajl narä, sucuälazni lagajc laani, suguuni xcrujzni, nalajznu tedni trabajw, sujiädnajlni narä. ");
INSERT INTO zawNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sa'csi nani rlajz gunni gaan xcäḻnabajṉni, sunijtnini. Luxh nani runijt xcäḻnabajṉni por narä, sidxälni xcäḻnabajṉni par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Sa'csi ¿xhi gaan gun te bejṉ palga ga'pni guideb guedxliuj, luxh nit xaimni lo Dios, ä? o ¿la yu' xhi gudeed bejṉ te siini xaimni? ");
INSERT INTO zawNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Sa'csi narä Xi'n Dios ni gujc Niguii siälä lo yäḻrdimbicha' xten Xtadä con rexanglni, dxejcti siguixä tebgaj bejṉ si'ctis ni gujc xtzuunni. ");
INSERT INTO zawNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Rniliä́pac lojtu, loj reni tre' ree ṉaj, yu'reni di guet dxejli ni fixgaareni jiälä narä Xi'n Dios ni gujc Niguii lo xcäḻrnibeä. ");
INSERT INTO zawNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Che gudeed xho'p dxej, huinä Jesús Pedr, Jacoob, con Juan betz Jacoob, xtebreni huijreni jiaa yejc te dajn. ");
INSERT INTO zawNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Dxejcti nez lojreni bidxaa xho rujn lojni. Lojni gusloj rdimbicha' si'c gubijdx; xhajbni gujc nolbäj si'c te bajl. ");
INSERT INTO zawNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Dxejc bahuigajcreni loj Moisés näjza loj Elías, cayujyreni diidx con Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Dxejcti räjp Pedr loj Jesús: ―Dad, ¡huenduxh suga'nu ree! Palga rlajzlu, sajc jiennu choṉ yuguijxh, tejni gac xten guejblu, steeni gac xten Moisés, steeni gac xten Elías. ");
INSERT INTO zawNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Laḻni canii Pedr, biäjt te za ni rdimbicha' guideb gabireni; neṉ zaga biejn te xse' ni räjp: ―Dee najc xi'nä ni sanälazä, ruspaduxhni lazä, coḻcuadiajg xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Che biejn diajg rexpejṉpac Jesús diidxga, bazuxhijbreni, basajbreni lojreni lo yuj, bidxebduxhreni. ");
INSERT INTO zawNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Dxejcti gubig Jesús lojreni, batzuubni ṉaani yejcreni, räjpni: ―Coḻchasulii, na'c rdxejbtu. ");
INSERT INTO zawNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Che guläs lojreni, lojtis Jesús bahuiireni, rutru suganäjdini. ");
INSERT INTO zawNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Cheni sayäjtreni yejc dajnga, gunibee Jesús lojreni, räjpni: ―Rutlojdi gäbtu xhini'c bahuiitu dxejli ni guibaṉsacä narä Xi'n Dios ni gujc Niguii lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Dxejcti gunabdiidx rexpejṉpacni lojni: ―¿Xhicuent rnii rebejṉ ni najn xleii Moisés ganid Elías nanab jiääd, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Badzu' Jesús diidxre, räjpni: ―Guliini siädxgaa Elías, laani gunsa'cni guira'ti, ");
INSERT INTO zawNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","niluxh narä rniä lojtu, abiääd Elías, di rebejṉ nienbeeni, luxh bennäjrenini si'ctis ni rlajzreni, basacsíduxhrenini. Sigajcza gunnäjreni narä Xi'n Dios ni gujc Niguii, susacsíduxhreni narä. ");
INSERT INTO zawNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Dxejcti gucbee rexpejṉpacni caniini xcuent Juan Bautist. ");
INSERT INTO zawNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Cheni bidzujṉreni cadro tre' xhidajl bejṉ, gubig te bejṉ lojni bazuxhijbni, dxejc räjpni: ");
INSERT INTO zawNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Dad, balaslajz xinä sa'csi laani cayacxhuuni, rajcni yäḻguidxbej, rusacsíduxh yäḻguijdxgani, yu' huält rtejbni lo guiboo yu' huält rtejbni lo nis. ");
INSERT INTO zawNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Biädnää́ni loj rexpejṉpaclu, luxh di niajcdi nusiajcrenini. ");
INSERT INTO zawNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús badzu' diidxre lojreni räjpni: ―Beṉguijdx, bejṉ ni di chalilajz, ¿gucli yu'ä lojtu? ¿Cati gac gunä huant la'tu? ¡Coḻtanä biuuxga ree! ");
INSERT INTO zawNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Dxejcti gudiḻnäj Jesús beṉdxab ni yu' lastoo biuuxga, gunibeeni biriini, lagajc dxejc biajc biuuxga. ");
INSERT INTO zawNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Dxejc guninäj rexpejṉpacni Jesús te laad, gunabdiidxreni räjpreni: ―¿Xhicuent di niajcdi nibäänu beṉdxab neṉ lastoo biuuxga? ");
INSERT INTO zawNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús räjp lojreni: ―Sa'csi la'tu guxiduxh rililajztu. Rniliä́ lojtu, paru najc yäḻrililajz xtentu si'cti te bejdz muxhtas, sajc gäbtu loj dajn rec: “Gubicaj ro'c, gudejd stelaad”, luxh sibicaj dajnga. Palga rililajzpactu, xhetliidi yu' ni di gacdi guntu. ");
INSERT INTO zawNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Niluxh sa' beṉdxabre, dini guirii palga ditu guiniabduxh lo Dios, gucua'nzatu. ");
INSERT INTO zawNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Laḻni sasajreni nez región xten Galilee, räjp Jesús: ―Suteedreni narä Xi'n Dios ni gujc Niguii ladzṉaa rebeṉdojḻ te gusacsíreni narä. ");
INSERT INTO zawNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Niluxh sugu'treni narä, dxejc ni riojṉ dxej sibaṉsacä lo rebeṉgut. Che biejn diajgreni diidxga, guc-huinduxh lajzreni. ");
INSERT INTO zawNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Che bidzujṉ Jesús näjza rexpejṉpacni guedx Capernaum, biääd rebejṉ ni rusquijx xcuent guidoo lo Pedr, gunabdiidxreni lojni, räjpreni: ―¿La di xmastrtu quiix impuest xten guidoo? ");
INSERT INTO zawNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Räjp Pedr: ―Rguijxnini. Che biu' Pedr neṉ yu', ganid Jesús gunii lojni, räjpni: ―¿Xhi rchalolu, Simón? ¿Chuni'c rusquijx rebejṉ ni rnibee lo guedxliujre? ¿Chuni'c rguijx reimpuest, recuyo't? ¿Rebeṉ lajdxreni o rebeṉzijt? ");
INSERT INTO zawNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Badzu' Pedr diidxre räjpni: ―Rebeṉzijt. Räjp Jesús: ―Ni'cni di rexi'nreni quiixni. ");
INSERT INTO zawNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Luxh te di guidxe'chreni, huij ro' nisdoo, bacuaa ansuel, gulää bäjl ni guiniazxgaalu. Ro' bäjlga sidxällu te melpla't ni sajl te chatijxlu impuest xcuentä näjza xcuentlu. ");
INSERT INTO zawNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Laa dxejcni gubig rexpejṉpac Jesús lojni te gunabdiidxreni: ―¿Chuni'c sajcru lajdx Dios xhaguibaa? ");
INSERT INTO zawNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Dxejcti gurejdx Jesús te biuxbäz, bazujnini nez galäiireni, ");
INSERT INTO zawNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","dxejc räjpni: ―Rniliä́pac lojtu, palga ditu gusiechlajztu, palga ditu gac nadolajz si'c te biuxbäz, ditu jiu' lajdx Dios xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ni'cni chutis bejṉ nani gac nadolajz si'c biuxe're, laani gac ni sajcru lajdx Dios xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Chutis ni riu te sa' biuxe're, sa'csi rinälajzni narä, lagajc narä riuni. ");
INSERT INTO zawNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Räjpzani: ―Chutis ni gudzucaj lo xnezyuä te sa' biuxe're ni ahuililajzni xtidxä, maazru huen niliib te guij xten molin dojb yejnni, chatejbni loj nisdoo, palga gunni jiajb tej reni'c lo dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Proobza guedxliuj sa'csi yuduxh xhigabguijdx lojni. Sa'csi nanabpac chu xhigabguijdx. Gunatiro, bejṉ ni ruzobloj rexhigabguijdxre, ni rujn riajbza lo dojḻ reni rililajz xtidxä, ni najc si'c biuxe're. ");
INSERT INTO zawNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Palga ni'lu o ṉaalu gun jiajblu lo dojḻ, batiu'ni. Hueenru jiu'lu lo xcäḻnabajṉ Dios nitiujnglu o ṉatiujnglu lacuaa jiilu con guiro'p ni'lu o guiro'p ṉaalu lo balduxh ni rejc par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Palga te balojlu rujn riajblu lo dojḻ, gulääni. Hueenru jiu'lu lo xcäḻrnibee Dios najclu lotiä'p lacuaa chu guiro'p baloj chazäḻreni luj lo balduxh ni rejc par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Räjpza Jesús lojreni: ―Coḻnatiro, andi cuälaztu rebejṉ ni najc si'c biuxbäzre ni sasaj lo xnez Dios, sa'csi rexangl Dios ni cahuiireni, guiraatis dxej yu'reni loj Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Sa'csi Xi'n Dios ni gujc Niguii biääd te gusḻaani rebejṉ nani agunijt neṉ dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Räjpzani: ―¿Xho rhuiitu? Palga rajp te bejṉ te gayuu xiil, dxejc nit tejni, ¿laa dini gusaan stabitzubigaaga ni yu' neṉ gurajl te chatiilni xile' ni gunijt, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Luxh palga guidxälni xile'ga, rniliä lojtu, sibalazduxhruni xcuent xile'ga luxh guxiiru guibanäj lajzni xcuent rexiil nani di ninijt. ");
INSERT INTO zawNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sigajcza Xtadnu ni yu' xhaguibaa di rlajz nit lo Dios nicla tej reni ahuililajz xtiidxni, ni najc si'c biuxbäzre. ");
INSERT INTO zawNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Räjpzani: ―Palga gun bejtzlu te cosguijdx lojlu, guninäjni xtebtislu, gojs lojni xhi dojḻ bejnni lojlu. Palga saru gucuadiajgni xtiidxlu, abiäjḻ lajztu. ");
INSERT INTO zawNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Palga naaddini gucuadiajgni, dini jiu xtiidxlu, dxejc huinä stee o stio'p bejṉ chaninäjluni, te guiraa ni guiniitu jiejn diajg rebejṉga, te arajplu tio'p o choṉ testiigw. ");
INSERT INTO zawNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Palga di bejtzlu gucuadiajg xtidx rebejṉga, luxh dizani jiu xtiidxreni, neṉ guidoo huile'c xquejlu loj rebejṉ ni ricuadiajg xtidx Dios. Palga dizani jiu rebeṉ guidoo, sugacni nez lojlu si'c te beṉguijdx ni di gumbee xtidx Dios o si'c rebejṉ nani rusquijx loj rebejṉ nani ruto'. ");
INSERT INTO zawNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Ni'cni rniliä́pac lojtu, guiraa yäḻguxhtis xten bejṉ ni di gusiechlajz xtojḻreni ni guntu lo guedxliuj, si'c jia'nni xhaguibaa; guiraa redojḻ nani gusiäjḻ lajztu lo guedxliuj sa'csi basiechlajz beṉdojḻga, si'cza jia'nni xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Sigajcza rniä lojtu, palga tio'ptu tejsi xhigab guntu xhini'c guiniabtu lo Dios, che guiniabtuni lo Dios, Xtadä ni yu' xhaguibaa suniidxni ni rniabtu lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Sa'csi cadrotis nadxagsa' tio'p o choṉ bejṉ sa'csi rinälajzreni narä, anasuga'ä galäii rebejṉga. ");
INSERT INTO zawNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Dxejcti gubig Pedr loj Jesús, gunabdiidxni: ―Dad, ¿palga gunijt betzä loä, bal huält nanab gusiäjḻ lazä? ¿La sajl gajdzli huält, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Badzu' Jesús diidxre lojni räjpni: ―Dina guiniä gajdztis huält, rniä gayoṉbidzuu huält, nalajznu si'ctiza huält basiäjḻ lajzlu. ");
INSERT INTO zawNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Xcäḻrnibee Dios xhaguibaa najc si'c te ṟeii ni rlajz gunni cuent lac nazääb rexmosni lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Agusloj cayujnni xcuentni chela bidzuṉnäjreni te mos ni nazääb balti mil lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Luxh mosre xhet rajpdini te quiixni rexti'nni, ni'c gunibee ṟeii guido'ni si'c sclav, näjza chäälni, näjza rexi'nni, nägajcza guiralii xhixtenni, te gaxh xti'nni. ");
INSERT INTO zawNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Dxejcti mosga bazuxhijbni loj xlam̲ni, gunabduxhni lojni, räjpni: “Guläzsijc tiop-choṉ dxej, Dad, te gac quixä xti'nä.” ");
INSERT INTO zawNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Dxejcti lam̲ga balazlajzni xmosni, badzucajni guiraa ni nazääb mosga lojni, basḻaanini. ");
INSERT INTO zawNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Cheni birii mosga rolijz xlam̲ni, bidxaagni stee samosni ni nazääb bale'si beex lojni. Gunaaznini, baxhiya'ni yejnni, dxejc räjpni: “Gudijxga ni nazääblu loä.” ");
INSERT INTO zawNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Dxejcti ste mosga bazuxhijbni lojni, räjpni: “Guläzsijc. Siguixäca guiraa ni nazäbä lojlu.” ");
INSERT INTO zawNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Luxh steega naaddini, alga huisäugacni samosni neṉ latzguiib te bejnni gaan gudijxni guiraa ni nazääbni. ");
INSERT INTO zawNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Cheni bahuii sgaii mos xhini'c bejnni, gucnaduxhlajzreni, huiye'tzreni lo xlam̲reni xhi huiyejnni. ");
INSERT INTO zawNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Dxejcti gurejdx xlam̲reni mosga, räjpni lojni: “¡Mos guijdx! Narä badzucaä di'n ni nazääblu loä, sa'csi gunabduxhlu loä. ");
INSERT INTO zawNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Si'cza niunnäjlu sa'lu, nulazlajzluni sigajc ni balazlazälu.” ");
INSERT INTO zawNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Sas lacti bidxechduxh lam̲ga, gunibeeni biäuuni te gudijxni guiragajc ni nazääbni lo xlam̲ni. ");
INSERT INTO zawNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Baluux Jesús cuentga, räjpni: ―Sigajcza gunnäj Xtadä ni yu' xhaguibaa guiraa rebejṉ ni di gusiäḻlajzpac guiraa redojḻ ni rujn resa'ni lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Che gulujx gunii Jesús recuentre, biunejzni Galilee, huijni lo región xten Judea, stelaad gueu Jordán. ");
INSERT INTO zawNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Xhidajl bejṉ birinajlni, ro'c basiajcni rebeṉracxhuu, ");
INSERT INTO zawNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","dxejc gubig refarisee lojni, rlajzreni gusgueesireni Jesús ni'c räjpreni lojni: ―¿La sajc guṟo'n te niguii chäälni che rlajztisni, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Badzu' Jesús diidxre lojreni, räjpni: ―¿La gajdtu goḻ lo reguijtz nani bacuaa toMoisés cadro caj xho benchee Dios bejṉ galooli: “Niguii näjza gunaa bencheenireni”? ");
INSERT INTO zawNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Guniiza Moisés: “Ni'cni gusaan niguii xtadni con xnanni te xca'ni chäälni, dxejc dirureni gac tio'p, tejtis bejṉ najcreni.” ");
INSERT INTO zawNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ni'cni dirureni gac tio'p, anajcreni tejtis bejṉ, digacdi guilia' rebejṉ lo sa'ni nani abachagsa' Dios lo sa'ni. ");
INSERT INTO zawNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Dxejcti gunabdiidxreni lojni, räjpreni: ―¿Xhicuent gunibee Moisés gudeed niguii te guijtz lo chäälni te si'c gac guṟo'nni gunaaga, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Räjp Jesús lojreni: ―Sa'csi najc lastootu si'c te guij, ni'c basaan toMoisés baṟo'n niguii chäälni, niluxh galodoo et si'cti gujcni. ");
INSERT INTO zawNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Luxh rniä lojtu, niguii nani gusaan chäälni, luxh xhet dojḻdi bennäj chäälni stee niguii, dxejcti guchṉaani ste'ca gunaa, rujnni dojḻ. Sigajcza niguii ni guchṉaa gunaaga ni abaṟo'n chäälnini, rujnza niguiiga dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Dxejc räjp rexpejṉpacni lojni: ―Palga si'c najc xcuent niguii con chäälni, hueenru na'c guchṉaani. ");
INSERT INTO zawNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús räjp lojreni: ―Xhet guiraadi bejṉ rajc gacbee rediidxre, rebejṉtis ni rudeed Dios te xcäriensa'c ni'ctis racbee. ");
INSERT INTO zawNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yu' xhicuent digacdi guchṉaa niguii: yu'reni digacdi guchṉaa sa'csi si'c gojḻreni; yu'reni digacdi guchṉaa sa'csi baxhiṉ sabejṉreni; yu'zareni digacdi guchṉaareni sa'csi rlajzreni gunreni xtzuuntis Dios. Nani rajc racbeeni rediidxre, sugacbeenireni. ");
INSERT INTO zawNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Dxejcti biädnäreni rebiuxe' loj Jesús te gudzuubni ṉaani yejcreni, guiniabni lo Dios xcuentreni. Luxh rexpejṉpacni gudiḻnäj rebejṉ ni siädnä rebiuxe'ga. ");
INSERT INTO zawNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Dxejc räjp Jesús lojreni: ―Coḻgusaan guibig rebiuxe' loä, na'c gudxojntureni, sa'csi xcäḻrnibee Dios xhaguibaa najc xten reni nadolajz si'c najc rebiuxe're. ");
INSERT INTO zawNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Che gulujx badzuubni ṉaani yejc rebiuxe', biunejzni ro'c. ");
INSERT INTO zawNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Dxejc biääd te bi'n lo Jesús, gunabdiidxni lojni; räjpni: ―Mastr sa'c, ¿xhini'c nanab gunä te xca'ä yäḻnabajṉ lo Dios par tejpas? ");
INSERT INTO zawNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Dxejc räjp Jesús lojni: ―¿Xhicuent rniilu mastr sa'c narä? Diostis najc sa'c. Per par rlajzlu xca'lu yäḻnabajṉ lo Dios, bazoob rextidx Dios ni caj lo xleii Moisés. ");
INSERT INTO zawNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Dxejcti räjp bi'nga lojni: ―¿Xhi rediidxga? Dxejc räjp Jesús lojni: ―Na'c ju'tlu, na'c guesnäjlu bejṉ nani di gac chäällu, na'c cuanlu, na'c guiliäslu didxxhii xcuent bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Bazoob xtidx xtadlu con xnanlu, huinälajz sa'lu si'cni sanälajzlu lagajc luj. ");
INSERT INTO zawNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Dxejcti räjp bi'nga lojni: ―Guiraa rediidxre runä che nacä́li biuux. ¿Xhiruxni'c riäädx gunä? ");
INSERT INTO zawNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Dxejc räjp Jesús lojni: ―Palga rlajzlu gaclu beṉsa'c lo Dios, huij, bato' guiraa ni rajplu, dxejc gudisni lo rebeṉproob, dxejc xhaguibaa sapduxhlu xhixtenlu. Dxejcti gudaa te jiädnajllu narä. ");
INSERT INTO zawNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Cheni biejn diajg bi'nga rediidxre, guc-huinduxh lajzni sa'csi rajpni xhidalduxh xhixtenni. ");
INSERT INTO zawNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Sas Jesús räjp loj rexpejṉpacni: ―Rniliä́pac lojtu, naganduxh jiu' te beṉ rajp loj xcäḻrnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Rnisacä lojtu, guyasiru ted te cameii neṉ baloj te guux; naganduxhru jiu' te bejṉ ni rajp lo xcäḻrnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Che biejn diajg rexpejṉpacni rediidxre, bidxeloduxhreni, dxejc canabdiidx loj sa'reni: ―¿Chuni'c sajc jiu' lo xcäḻrnibee Dios? ");
INSERT INTO zawNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Dxejc bahuidzu'tz Jesús lojreni, räjpni: ―Naganduxh gun rebejṉ dee, Diostis sajc gun guiraloj. ");
INSERT INTO zawNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Dxejcti Pedr räjp lojni: ―Nuurnu basa'nnu guiraa xhixtennu te siopnalnulu. ¿Xhini'c jia'pnu ro'c? ");
INSERT INTO zawNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús räjp lojreni: ―Rniliä́pac lojtu, la'tu ni biädnajltu narä, che guscobä guiraa recos cheni cueä narä, Xi'n Dios ni gujc Niguii, lo yagxhil cadro guinibeä lo guiraa rebeṉ guedxliuj, la'tu ni siädnajltu narä sibejzatu lo tzubitio'p yagxhil te guinibeetu loj guitzubitio'p guejdx xten rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Luxh guiraa rebejṉ ni basa'n rolijzni o rebejtzni, o rebisiajnni, o xtadni, o xnanni, o chäälni, o xi'nni, o rexhujni, te siädnajlni narä, rebejṉga sajp te gayuu huält locni gojpni, nägajc ga'preni xcäḻnabajṉ Dios par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Rebejṉ nani rchalo najcreni beṉroru lo sa'reni nez loj Dios, reni'c gac bejṉ ni guxii sajc nez loj Dios. Rebejṉ nadolajz ni di guchalo sajcrureni lo sa'reni, reni'c sajcrureni nez loj Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Räjpzani: ―Xcäḻrnibee Dios najc si'c te bejṉ ni najc baxhuaan xten te renchro. Rsildooru biriini te satiilni mos gun dzuun lo xyujni, lo reyaguub. ");
INSERT INTO zawNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Che bidxälni gaii mos, bachaagni diidx. Bia'nreni diidx quiixnireni te denaar tebdxej cade tej remosga. Dxejc baxhaḻnireni loj xyujni sayujnreni dzuun. ");
INSERT INTO zawNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Birisacni, satiilni sgaii mos si'cti rcagaa, rsil. Bidxaagni sgaii bejṉ ni xhet cayujndi, suga'sireni nez lo guii. ");
INSERT INTO zawNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Räjpni lojreni: “Näjza la'tu coḻchayujn dzuun lo xyuä. Narä siguixä si'cni riäjḻ xca'tu.” Sä'ti rebejṉga lo dzuun. ");
INSERT INTO zawNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Birisac dade' si'cti läiidxej, birisaczani si'cti rcachoṉ gudxej. Bidxaagni sgaii bejṉ, sigajcza räjpni loj rebejṉga. ");
INSERT INTO zawNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Dxejc si'cti rcagaii birisacni, huijni lo guii. Ro'c bidxälni sgaii bejṉ ni xhet cayujndireni, suga'sireni nez lo guii. Dxejc räjpni lojreni: “¿Xhicuent suga'tu ree guideb dxej xhet cayujnditu?” ");
INSERT INTO zawNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Dxejc räjpreni lojni: “Sa'csi rut siädtiildinu te choyennu dzuun.” Dxejcti räjpni lojreni: “Näjza la'tu coḻchayejn dzuun lo xyuä. Narä siguixsa'cätu.” ");
INSERT INTO zawNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Che biu' guxhijṉ, räjp lam̲ lo mos ni rnibee remos: “Gurejdx remos te quiixlureni. Gudix-xgaa reni biu' gudxejru lo dzuun. Lult gudijx reni biu' ganid lo dzuun.” ");
INSERT INTO zawNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Dxejc ganid biu' remos ni agudxej biu'reni lo dzuun. Cade tejreni cua' te denaar, si'cni rca' ni rujn dzuun guideb dxej. ");
INSERT INTO zawNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Cheni biu' reni biu' lo dzuun rsildoo, bejnreni xhigab sica'rureni meel, per sigajcza laareni cua'reni te denaar cade tejreni. ");
INSERT INTO zawNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Che cua'reni xcuentreni gusloj cadxe'chreni lo baxhuaan xten dzuunga. ");
INSERT INTO zawNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Räjpreni: “Redee ni biu' lult lo dzuun pet teb oṟtis bejnreni dzuun, luxh gudijxlureni sigajcni gudijxlu nuurnu, luxh biennu dzuun guideb dxej, luxh biennu dzuun lo yäḻnanlaa.” ");
INSERT INTO zawNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Dxejc räjp lamga lo tejreni: “Xamigwä, xhet cosguijdxdi cayunä lojlu. ¿La xhet bia'ndinu diidx te denaar quixälu tebdxej? ");
INSERT INTO zawNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Huij, cua' xmeellu. Narä rlazä quixä bejṉre ni biu' lult sigajc ni gudixä lojlu. ");
INSERT INTO zawNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿La di gacdi gunä si'ctis ni rlazä con xmelä? ¿O rdxechlajzlu loä sa'csi nacä hueen, ä?” ");
INSERT INTO zawNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ni'cni reni biääd lult sajcreni tebloj con reni biääd ganid, luxh reni biääd ganid sajcreni tebloj con reni biääd lult. ");
INSERT INTO zawNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Che sasaj Jesús lo nezyuj sääni Jerusalén, huinäni rexpejṉpacni te laad te räjpni lojreni: ");
INSERT INTO zawNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―La'tu ruhuiitu sosaanu nez guedx Jerusalén. Ro'c narä, Xi'n Dios ni gujc Niguii, siabä ladzṉaa reni rnibee lo rebixhojz, näjza lo rebejṉ ni najn leii. Laareni sinibeereni guetä. ");
INSERT INTO zawNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Suteedreni narä ladzṉaa rebeṉzijt te cubeereni narä quiinreni narä, dxejc gucuaareni narä lo crujz. Luxh ni riojṉ dxej, sibaṉsacä loj rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Dxejcti gubig xnan Jacoob näjza Juan, xi'n Zebedeo loj Jesús. Bazuxhijbni nez loj Jesús, te gunabni lo Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Gunabdiidx Jesús lojni: ―¿Xhini'c rlajzlu? Räjp gunaaga lojni: ―Che jiu'lu lo xcäḻrnibeelu, gunibelaa cue tej rexi'nä xladbeelu, steeni cue xladbäjgwlu. ");
INSERT INTO zawNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Dxejc räjp Jesús: ―¡Ditu gan xhini'c rniabtu! ¿La sajc tedtu yäḻrsacsí sa'ni tedä? ¿La sajc tedtu trabajwduxh sa' ni nanab tedä? Dxejc räjpreni: ―Sajc tednuni. ");
INSERT INTO zawNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Dxejcti räjp Jesús lojreni: ―Guliipacni. Sidedxgaatu trabajw, sidedxgaazatu yäḻrsacsí. Et narädi cueä reni cue xladbägwä o xladbeä. Xtadä ni yu' xhaguibaa alaguleni rebejṉga. ");
INSERT INTO zawNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Che biejn diajg stzuu rexpejṉpac Jesús, bidxe'chreni loj guiro'p rexi'n nane'ga. ");
INSERT INTO zawNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Dxejc gurejdx Jesús reni, räjpni: ―La'tu najntu xho rujn regubier ni rnibee lo rebeṉzijt, rnibeereni rebejṉga si'c xlam̲reni. Luxh reni najc rebeṉro lojreni runnäjreni rebejṉga si'ctis ni rlajzreni. ");
INSERT INTO zawNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Et si'cni gunditu la'tu loj rebejṉ. Chutis rlajz gac beṉro lojtu, nanab gunni dzuun gacnäjni guiraliitu si'c te mos. ");
INSERT INTO zawNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Luxh chutis tejtu ni rlajz guiliä'p xpala'nni, nanab gacni si'c xmos lo guiraliitu. ");
INSERT INTO zawNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Sigajcza biääd Xi'n Dios ni gujc Niguii. Dini niniab mos chu lojni, alga laani najc xmos bejṉ, badeedzani lagajc yäḻnabajṉ xtenni te gudijxni basḻaani xhidal bejṉ ni yu' lo dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Che gojl guiriireni guedx Jericó, xhidalduxh bejṉ sanajlni. ");
INSERT INTO zawNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Dxejcti sobga' tio'p bejṉ ni di fii cuä' nez yuj. Che biejn diajgreni sadejd Jesús ro'c, gusloj cabedxa'reni: ―Dad, Xi'n toDavid, balazlajz nuurnu. ");
INSERT INTO zawNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Gudiḻnäj rebejṉreni, te gusäureni ro'reni. Luxh laareni dipru guredxa'reni: ―¡Dad, Xi'n toDavid, balazlajz nuurnu! ");
INSERT INTO zawNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Dxejc guzudxi Jesús, gurejdxni reni di fii, räjpni lojreni: ―¿Xhini'c rlajztu gunä? ");
INSERT INTO zawNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Räjpreni lojni: ―Dad, rlaaznu guixal balojnu te gac fiinu. ");
INSERT INTO zawNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Dxejc balazlajz Jesúsreni, gudajnni balojreni. Sas biacgajc balojreni, gujc bahuiireni, sanajltireni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Cheni Siäddzuṉgajxhreni guedx Jerusalén, bidzujṉreni te guedxbäz ni laa Betfagé, cuä' dajn ni laa Oliib. Baxhaḻ Jesús tio'p xpejṉpacni, ");
INSERT INTO zawNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","räjpni lojreni: ―Coḻchäj loj guedxbäzre ni tre' nez lojtu. Ro'c guidxältu te buṟgunaa caduu näjza tebuṟhuin. Coḻguxhecni, coḻtanäni loä. ");
INSERT INTO zawNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Palga yu' chu naa: “¿Xhini'c rujntu?”, coḻye'tz lojni: “Dad caquiinnini terate'. Suxhaḻgajcnini.” ");
INSERT INTO zawNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Luxh guiraa dee gujc te guzojb diidx ni gunii dade' nani bacuaa xtidx Dios agujc xchero, che räjpni: ");
INSERT INTO zawNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Coḻye'tz loj reni rbäjz guedx Sión, bahuii xṟeiilu siääd lojlu, nadolajzni bijbni te buṟbäz, te buṟbäz, xi'n man ni rujn dzuun, ni ruu cargw. ");
INSERT INTO zawNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Dxejcti huij rexpejṉpacni, bejnreni si'c gunibee Jesús gunreni. ");
INSERT INTO zawNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Biädnäreni buṟga näjza buṟbäz xi'nni. Gudixhreni xhajbreni detz buṟbäzga, dxejc gubijb Jesús buṟbäzga. ");
INSERT INTO zawNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Xhidalduxh bejṉ tre' ro'c, luxh yu' reni gudixh xhajbreni lo nez yuj, peta sgaiireni batiu' balajg te gudixhreni rebalajg lo nez yuj cadro ted Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Rebejṉ ni nijd, näjza reni siääd dejtzni gusloj cabedxa'reni, räjpreni: ―¡Xchej guibajṉ Xi'n toDavid! ¡Chicbaa ni siääd xcuent Gueb Dios! Rliä'pnu xpala'n Guejblu Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Cheni biu' Jesús neṉ guedx Jerusalén, guiraa rebeṉ guejdxga gusloj camojm̲, yu'reni canabdiidxreni loj sa'reni: ―¿Chucha najc bejṉre? ");
INSERT INTO zawNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Yu'zareni räjp: ―Dee najc Jesús, niguii ni rusule' xtidx Dios. Guedx Nazare't xten Galilee siäädni. ");
INSERT INTO zawNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Dxejc biu' Jesús neṉ guidoro xten Dios, gulääni guiraa rebejṉ ni caguto' näjza rebejṉ ni casii. Barexhätni remex xten reni ruchaa meel xten rebejṉ, näjza reyagxhil xten reni ruto' repalom. ");
INSERT INTO zawNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Dxejc räjpni lojreni: ―Loj reguijtz ni bacuaa rebeṉgaloo caj: “Sirilaj xquidoä yu' xten yäḻrbejdx, yäḻrniab loj Dios.” Niluxh la'tu abejntuni xpiliää gubaan. ");
INSERT INTO zawNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Lagajc neṉ guidooga, gubig loj Jesús gaii bejṉ ni di fii näjza gaii bejṉ ni rsiacoj, luxh basiajcnireni. ");
INSERT INTO zawNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Cheni bahuii reni rnibee loj rebixhojz, näjza reni najn leii remilagwr ni bejn Jesús, luxh biejnza diajgreni xho cabedxa' rebiuxe' caniireni: “Rliä'pnu xpala'nlu Xi'n toṟeii David”, bidxe'ch rebixhojzga. ");
INSERT INTO zawNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Dxejc räjpreni loj Jesús: ―¿La riejn diajglu xhi caniireni, ä? Badzu' Jesús diidxre lojreni räjpni: ―O'n, riejn diagäni. ¿La gadtu goḻ lo reguijtz ni bacuaa te dade' ni gunii xtidx Dios? Ro'c caj xcuent redee, cadro caj rediidxre: Abejnlu goḻ rebiuux näjza rebäznite' dij ni rliäpsa'cpac xpala'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Dxejcti basaan Jesúsreni, biunejzni ro'c sääni guedxe' ni laa Betania, ro'c gudejdni yääl. ");
INSERT INTO zawNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Cheni bara yääl, rsilru gubisac Jesús guedx Jerusalén. Laḻ ni sääni, gusloj calaanni. ");
INSERT INTO zawNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Bahuiini loj te yag iigw cuä' nezyuj. Gubigni gajxh ni' yajgga, per xhet ninejxhdi bidxälni, ganaxhtis balajg caj lo yajgga. Dxejc räjp Jesús lo yajg iigwga: ―¡Nuncru xcaj nicla tej ninejxh lojlu! Dxejcti gubidzgajc yajgga. ");
INSERT INTO zawNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Cheni bahuii rexpejṉpacni, bidxeloduxhreni, gunabdiidxreni loj Jesús: ―¿Xhi cuent gubidzgajc yajgga? ");
INSERT INTO zawNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Räjp Jesús lojreni: ―Rniliä́pac lojtu, palga chalilajzpactu, luxh ditu gun tio'p lajztu, xhet ganaxdi sa' cosre guntu, palga gäbtu lo te dajn: “Gubicaj ro'c, gusuj galäii nisdoo”, si'c gacni. ");
INSERT INTO zawNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Guiraa ni guiniabtu loj Dios, palga chalilajzpactu, suniidxnini. ");
INSERT INTO zawNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Dxejcti biu' Jesús neṉ guidoro, dxejc laḻ ni caguluiini rebejṉ gubig reni rnibee loj rebixhojz näjza rebeṉgool, gunabdiidxreni lojni: ―¿Xhi yäḻrnibee rajplu ni'cni rajc rujnlu recosre? ¿Chuni'c baniidx yäḻrnibeere lojlu? ");
INSERT INTO zawNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Badzu' Jesús diidxre lojreni räjpni: ―Sigajcza narä gunä te yäḻgunabdiidx lojtu; palga sajc gudzu'tu diidxga loä, dxejc guiniä lojtu chuni'c baniidx yäḻrnibee te runä recosre. ");
INSERT INTO zawNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Chuni'c gunibee gutiobnis Juan ni rutiobnis? ¿La Dios o la beṉ guedxliuj? Dxejc gusloj cayäjp lo sa'reni, palga jie'tznu Dios gunibeeni, dxejc sinajni loonu, ¿xhicuent ditu nililajz xtiidxni? ");
INSERT INTO zawNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Palga jie'tznu bejṉ guedxliuj gunibeeni, dxejc sixa't rebejṉ yejcnu sa'csi guiraareni rililajzreni Juan najc te Dade' ni gunii xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Dxejc räjpreni loj Jesús: ―Dinu guidon. Dxejc räjp Jesús lojreni: ―Sigajcza narä dina guiniä caro siääd yäḻrnibee te runä guiraa recosre. ");
INSERT INTO zawNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús räjp lojreni: ―Guidon xho guichalootu diidxre. Te dade' guyu' tio'p xi'nni. Räjpni loj xingangalojni: “Xi'nä, nadxej chayujnlu dzuun cadro care' uub.” ");
INSERT INTO zawNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Dxejc badzu' xi'nni diidx lojni, räjpni: “Di rlazädi cha'a.” Luxh che gojl ste ra't, basiejch lajzni säätini sayujnni xtzun xtadni. ");
INSERT INTO zawNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dxejc räjp dade'ga lo stee xi'nni: “Xi'nä, nadxej chayujnlu dzuun.” Dxejc badzu' xi'nni diidxre, räjpni: “Mbaj, dad, sia'ä.” Luxh dini nij. ");
INSERT INTO zawNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Loj guiro'preni, ¿chuni'c bejn si'cni rlajz xtadni? Dxejc räjpreni: ―Xingangalooni. Dxejcti räjp Jesús lojreni: ―Rniliä́pac lojtu, reni ruquijx guiraloj, näjza regunabdxab ganidreni jiu'reni lojtu loj xcäḻrnibee Dios, ");
INSERT INTO zawNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","sa'csi Juan ni rutiobnis biädluiini la'tu xho guibajṉtu, luxh ditu nililajz xtiidxni. Biädla reni ruquijx guiraloj, näjza regunadxab huililazduxhreni xtiidxni. Niluxh la'tu bahuiitu guiraa recosga, ditu nusiechlajz te nililajztu xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’¡Coḻcuadiajg stee cuentre! Guyu' te dade' ni najc baxhuaan xten te renchro, gule'cni yaguub loj xyujni, bateedni bazaa guideb gabi yujga. Gudäänni te gueed te gujcni te tanc te chuchee nisuubga che rxii reuub. Bencheezani te yu' ni najc jiaaro te ro'c cue te ni fii guideb loj xyujni. Badedlaani yujga loj gaii bejṉ ni rujn dzuun, sä'tini te biaj zijtro. ");
INSERT INTO zawNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Che agojl guire' cose'ch baxhaḻ baxhuaanga gaii xmosni loj xyujni te chaxiireni cose'ch ni riäjl xca' baxhuaanga. ");
INSERT INTO zawNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Dxejc reni biannäj yujga gunaazreni remosre, gudijnreni tejni, bagu'treni steeni, bacuaareni guij yejc steeni. ");
INSERT INTO zawNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Dxejc baxhaḻsac baxhuaanga sgaii mos. Niluxh reni biannäj yujga sigajcza bennäjreni remosga. ");
INSERT INTO zawNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Dxejcti bejn baxhuaanga xhigab: “Maazru huen guxhaḻä xi'nä; sucuadiajgrureni xtiidxni.” ");
INSERT INTO zawNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Cheni bahuiireni lo xi'n baxhuaan xten yujga, bejnreni xhigab: “Deeni jiannäj yujre; do'o guigu'tnuni te jiannäänu yujre.” ");
INSERT INTO zawNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Dxejcti gunaazrenini, guläärenini te laad, dxejc bagu'trenini. ");
INSERT INTO zawNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Dxejc gunabdiidx Jesús räjpni: ―Che jiääd baxhuaan xten yujga, ¿xhi gunnäjni rebejṉ nani biannäj xyujni? ");
INSERT INTO zawNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Dxejc räjpreni loj Jesús: ―Dini gulazlajz rebeṉguijdxga, sugu'tnireni, sudedlaani xyujni loj ste'ca bejṉ nani gudeed cose'ch ni riäjl xca'ni che gaḻ guire' cose'chga. ");
INSERT INTO zawNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Dxejcti räjp Jesús lojreni: ―¿La gajdtu goḻ lo reguijtz nani bacuaa dade' nani gunii xtidx Dios galoo? Rediidxre caj ro'c: Guij nani gulälaz reni runchee yu', cua' Dios lagajc guijga gudixhnini squiin yu', sajcruni loj guiraa reguij. Dee bejn Gueb Dios, luxh rdxeloduxhnu dzunrore ni bejnni. ");
INSERT INTO zawNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","’Ni'cni rniä lojtu, sibicaj xcäḻrnibee Dios lojtu, sidejdni loj rebejṉ nani gudeed ni riäjl xca' xcäḻrnibee Dios, nalajznu renani chalilajzpac xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Luxh xcuent guijga: nani jiajb lo guijga, silia'ni, per nani guitejb guijga yejcni, li siujyni, gacni däj. ");
INSERT INTO zawNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Che biejn diajg reni rnibee lo rebixhojz näjza refarisee recuent ni canii Jesús, gucbeereni cagusä'tni lagajc laareni. ");
INSERT INTO zawNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Rlajzreni niniaazrenini, per bidxejbreni rebejṉ sa'csi salilajz rebejṉ najc Jesús bejṉ ni rnii xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Guslosac canii Jesús lojreni con recuent, räjpni: ");
INSERT INTO zawNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Xcäḻrnibee Dios najc si'c te ṟeii ni bejn te sa' te guchṉaa xi'nni. ");
INSERT INTO zawNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Baxhaḻni rexmosni te saxiireni regolnejdx chääreni sa', niluxh rebejṉre di rlajzdireni. ");
INSERT INTO zawNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Dxejc baxhaḻsacni rexmosni, räjpni: “Coḻye'tz loj reni abidoṉ, agujc comiid. ¡Abagutä balti gonsa'c, gonguro'! Anacchee guira'ti yäḻrajw. Coḻtaa.” ");
INSERT INTO zawNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Niluxh reni abidoṉga di niu xtiidxreni. Tejni sahuii rexyujni, steeni sää lo rexnegosni, ");
INSERT INTO zawNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","dxejcti sgaii reni niajc biooz gunaazreni rexmos ṟeii, basacsíreni remosga, sas bagu'trenini. ");
INSERT INTO zawNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Che biejn diajg ṟeiiga, bidxe'chduxhni, baxhaḻni rexsoldaadni te sagu'treni guiraa rebeṉguijdxga, te saze'czareni guejdx cadro rbäjzreni. ");
INSERT INTO zawNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Dxejcti räjpni loj rexmosni: “Guiraa dee anacchee, di nungäjḻ jiäädru reni abidoṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Coḻchäj, pues, lo resquiin lo nezyuj, coḻcuejdx chutis bejṉ ni guidxaagtistu.” ");
INSERT INTO zawNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Birii rexmosni, sääreni lo nezyuj. Dxejc bachagsa'reni guiraatis bejṉ ni bidxaagreni, reni najc beṉguijdx sigajc reni najc beṉhueen te gudxaj rolijz ṟeiiga. ");
INSERT INTO zawNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Dxejc biu' ṟeii biädhuiini loj rebiooz. Bahuiini loj te bejṉ ni sobga' ro'c, luxh xhet xhablanijdini najcwni. ");
INSERT INTO zawNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Dxejc räjp ṟeii lojni: “Xamigwä, ¿xho bejnlu biu'lu ree luxh xhet xhablanijdilu najcwlu?” Dxitis sobga' bejṉga, xhet rniidini. ");
INSERT INTO zawNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Dxejc räjp ṟeii loj rexmosni: “Coḻguliib ni'ni näjza ṉaani, coḻsäḻni detzyu' cadro nacäjy te ro'c gonduxhni chubejli reläjyni.” ");
INSERT INTO zawNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sa'csi xhidajl najc reni bidoṉ luxh guxii najc reni bibee. ");
INSERT INTO zawNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Dxejcti sii refarisee, bia'nreni diidx siguiilreni xho gunijt Jesús te diidx te guiga'ni. ");
INSERT INTO zawNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ni'c baxhaḻreni gaii xpejṉreni näjza gaii bejṉ ni nadxaag Herodes te räjpreni loj Jesús: ―Mastr, anajnnu rniilu ganax didxlii, ruluiizalu xtiidxpac Dios, luxh dilu jiu xhi rnii rebejṉ, sa'csi dilu cue bejṉ ni sajcru lo stee bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gunii loonu, pues: ¿La laaca najc quiixnu impuest lo César ni rnibee loonu o et laadi? ");
INSERT INTO zawNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Dxejc gucbee Jesús xhet laadi xhigab cayujnreni neṉ lastooreni, dxejc räjpni lojreni: ―¡Beṉguijdx! ¿Xhicuent rlajztu guquiiltu narä? ");
INSERT INTO zawNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Coḻguluii te meel loä. Dxejc badeedreni te meel ni laa denario. ");
INSERT INTO zawNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Che bahuii Jesús loj meelga, gunabdiidxni lojreni, räjpni: ―¿Chuni'c caj lo meelre? ");
INSERT INTO zawNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Dxejc räjpreni: ―Loj César. Dxejc räjp Jesús lojreni: ―Coḻgudeed lo César ni riäjl xca' César, coḻgudeedza lo Dios ni riäjl xca' Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Che biejn diajgreni rediidxre, bidxeloduxhreni. Dxejc basaanrenini, sä'tireni. ");
INSERT INTO zawNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Lagajc dxejga bidzujṉ gaii reni laa saducee, reni di chalilajz sibaṉsac bejṉ loj rebeṉgut. Gubigreni loj Jesús, gunabdiidxreni, ");
INSERT INTO zawNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","räjpreni: ―Mastr, si'c naj toMoisés, palga yu' te bejṉ ni abachṉaa, luxh ruti xi'nni che guetni, riäjḻ guchṉaa bejtzni biuudga te chu xi'nreni xcuent bejtzni. ");
INSERT INTO zawNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mbaj. Loonu yu' gajdz niguii ni najc bejtz sa'reni. Betzgoolga bachṉaa, dxejc gujtni, luxh di xi'nni niu'. Basa'nni chäälni lo bejtzni. ");
INSERT INTO zawNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Sigajcza gusajc ni ṟo'p bejtzni; sigajcza gusajc ni riojṉ bejtzni. Si'c huinuu gujc che basa'li guigajdz bejtzga. ");
INSERT INTO zawNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Sas che gujt guiraareni, näjza gunaaga gujt. ");
INSERT INTO zawNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Che guibaṉsac rebejṉga lo rebeṉgut, ¿chu tej lo rebejtzga gac chäälpac gunaaga, ni guiraareni bachṉaareni gunaaga? ");
INSERT INTO zawNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Dxejcti badzu' Jesús diidxre lojreni, räjpni: ―Et laadi rujntu xhigab sa'csi ditu gacbee xtidx Dios niclaza xcuent xcäḻrnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ni che guibajṉ rebeṉgut, diru yäḻruchṉaa chu, diruza bejṉ gudeed rexindxa'preni guchṉaa. Dxejc sajcreni si'c rexangl Dios ni yu' xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Dxejc xcuent yäḻrbaṉsac loj rebeṉgut, ¿la gajdtu goḻ reguijtz ni bacuaa toMoisés che räjp Dios xcuent retoxtadgoldoonu: ");
INSERT INTO zawNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Narä nacä Xtios Abram, Xtios Isaac, näjza Xtios Jacoob”, ä? Dios di gac Xtios beṉgut, Xtiostis rebejṉ ni nabajṉ najcni. ");
INSERT INTO zawNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Che biejn diajg rebejṉ xtidx Jesús, bidxeloduxhreni diidx ni ruluiini. ");
INSERT INTO zawNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Che gucbee refarisee basäu Jesús ro' resaducee, bidojpreni, bachaagreni diidx. ");
INSERT INTO zawNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Dxejc tejreni nani najn leii, rlajzni guquiilni Jesús ni'c gunabdiidxni lojni räjpni: ");
INSERT INTO zawNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Mastr, ¿xhi diidx ni gunibee Dios sajcru lojreni caj lo leii? ");
INSERT INTO zawNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Räjp Jesús lojreni: ―Nani rnii scree: “Huinälajz Dad Xtioslu guideb lastoolu, guideb xaimlu, näjza guidebgajc xcäriejnlu.” ");
INSERT INTO zawNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Diidxre ni gunibee Dios najc ni sajcru, luxh ganidni siäädni loj rextidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ni ṟo'pga sigajcza najcni: “Huinälajz resa'lu sigajc ni sanälajzlu lagajc luj.” ");
INSERT INTO zawNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Guiro'p remandamientre nanab te guzoob bejṉ guiraa rediidx ni bacuaa toMoisés näjza ni bacuaa redade' nani gunii xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Laḻni tre' refarisee, gunabdiidx Jesús lojreni, räjpni: ");
INSERT INTO zawNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―¿Xhi rujntu xhigab xcuent Crist? ¿Chu xi'n najcni? Räjpreni lojni: ―Laani najc xajg toDavid. ");
INSERT INTO zawNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Räjp Jesús lojreni: ―¿Xhicuent räjp David “Xtadä” lojni che basanij Sprit Dxan xten Dios lastooni? Ni'c bacuaa toDavid rediidxre: ");
INSERT INTO zawNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Dad Dios räjp lo Xtadä, gurej xladbeä laḻ ni gudzugä guiraa reni rdxe'ch lojlu ladzni'lu. ");
INSERT INTO zawNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Palga lagajc David rnii: “Dad” lojni, ¿xho mood najcni xi'nni? ");
INSERT INTO zawNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Dxejc rut gujcdi badzu' nicla te diidx lojni, luxh dxejliga rutru gojpdi xhi diidx niniabdiidxrureni lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Dxejc räjp Jesús loj rebeṉ xhidaalga näjza loj rexpejṉpacni: ");
INSERT INTO zawNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Rebejṉ ni najn leii näjza refarisee rajp yäḻnajn te gusule'reni xleii Moisés. ");
INSERT INTO zawNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ni'cni coḻguzoob guiraa rextiidxreni, na'c guntu sa' recos ni rujnreni, sa'csi laareni rniireni xhini'c guntu, dxejcti lagajc laareni direni gun ni rnibeereni guntu. ");
INSERT INTO zawNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Rnibeereni gun rebejṉ cos naganduxh ni najc si'c te cargw naduxh ni di gac guu bejṉ, per laareni nicla con te bicueṉaareni direni gusniibni. ");
INSERT INTO zawNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Guiraa recos ni rujnreni, rujnrenini te fiitis rebejṉ. Rchaglajzreni rcaj lo cuajsreni näjza roxhajgwreni recaje' cadro yu' tla' guijtz ni caj xtidx Dios lojni. Rustioolzareni xi' xhajbreni. ");
INSERT INTO zawNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Rlajzreni ganidreni tedreni lo mex che gaḻ te lanij; rlajzreni cuereni lo rebancw ni suga' delant neṉ reguidobäz. ");
INSERT INTO zawNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Sigajcza rlajzreni guchagro' bejṉ ṉaareni nez lo guii, guiniiza rebejṉ “Mastr” lojreni. ");
INSERT INTO zawNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Na'c gusaantu guinii rebejṉ “Mastr” lojtu, sa'csi tejtisni yu' ni najc Mastr, laani najc Crist. Peta la'tu guiraatu najctu tejsi sa'tu. ");
INSERT INTO zawNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Na'c guiniitu “Xtadä” loj te beṉ guedxliuj sa'csi yu' tejtis ni najc Xtadtu, ni'c najc Dios ni yu' xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Na'cza gusaantu guiniireni lojtu “Mastr” sa'csi yu' tejtis Mastr, ni'c najc Crist. ");
INSERT INTO zawNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ni yu' si'c mos lojtu ni'c najc beṉroru loj resa'ni. ");
INSERT INTO zawNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Sa'csi chutis ni rchaloni najcni beṉro lo sa'ni, ni'c sustuiyä lojni, chutis ni najc nadolajz loj Dios, ni'c sunäni beṉro lo sa'ni. ");
INSERT INTO zawNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Proobzatu remastr xten leii näjzatu refarisee, najctu beṉguijdx! Sa'csi rudxojntu jiu' rebejṉ loj xcäḻrnibee Dios. Lagajc la'tu ditu jiu' luxh dizatu gusaan jiu' rebejṉ ni rlajz jiu'. ");
INSERT INTO zawNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Proobzatu remastr xten leii näjzatu refarisee, najctu beṉguijdx! Sa'csi rudzucajtu rolijz renanbiuud laḻsi cabedx canabduxhtu lo Dios, naatu gusgueetu bejṉ si'c. Sa'csi rujntu scree, siabduxh fis xten Dios yejctu. ");
INSERT INTO zawNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Proobzatu remastr xten leii näjzatu refarisee, najctu beṉguijdx! Zijt rijtu lo renezyuj näjza lo nisdoo te guntu gaan guchaa mase tejtis bejṉ xmoodni te gaṉni Dios si'c rajṉtuni. Luxh che ahuililajz bejṉga xtiidxtu, rujntuni tio'p huält maazru te xi'n gabijl loj ni najctu. ");
INSERT INTO zawNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Proobzatu, najctu si'c lotiä'p, rlajztu guluiitu nezyuj! La'tu ni rnii palga te bejṉ guiniliipac xtiidxni guzä'tni guidoro, xhet sajcdi xtiidxni. Palga guiniliipacni guzä'tni oor ni yu' neṉ guidoo, dxejc sii rniliini dxejc nungäjḻ guzoobni xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Beṉ nayääl, beṉlotiä'p! ¿Xhini'c sajcru? ¿La oor la guidoro ni rundxan oorga? ");
INSERT INTO zawNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Rniizatu: “Palga te bejṉ guiniliipacni guzä'tni lo bacuug ni yu' neṉ guidoro, di xcuentdi xtiidxni. Luxh palga yu' chu guiniliipac guzä'tni gojn ni dzuub lo bacuug, dxejc sii rniliipacni dxejc nungäjḻ gusoobni xtiidxni.” ");
INSERT INTO zawNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Beṉ nayääl, beṉ lotiä'p! ¿Xhini'c sajcru? ¿La gojn o la bacuug nani rundxan gojnga, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nani ruzä't lo bacuug che rniliipacni, et ganaxdi lo bacuug ruzä'tni, näjza guiraa ni tre' lo bacuug ruzä'tni. ");
INSERT INTO zawNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ni ruzä't guidoro che rniliipacni, et ganaxdi guidoro ruzä'tni, näjza Dios ni rbäjzza neṉ guidoro ruzä'tni. ");
INSERT INTO zawNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Sigajcza ni ruzä't guibaa che rniliipacni caguzä'tzani yagxhilro xten Dios näjza lagajc Dios ni sobga' ro'c. ");
INSERT INTO zawNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Proobzatu remastr xten leii näjzatu refarisee, najctu beṉguijdx! Bedzxtiil, anis näjza comiṉ ni rajptu, rudeedtu lo Dios tej tantga yejc cade te tzuu, niluxh ditu jiu ni sajcru lo xtidx Dios, cadro caj xcuent yäḻnabaṉya, yäḻrulazlajz, näjza yäḻrililajz. Deeza ni riäjḻpac guntu laḻ ni cayujnzatu steega. ");
INSERT INTO zawNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡La'tu, lotiä'p ni rlajz guluii nezyuj! Riutu rediidx ni guxii sajc, niluxh rediidx ni sacduxh ditu jiuni, najctu si'c bejṉ ni rbää te rex lo xpla'tni dxejcru räjmni te cameii. ");
INSERT INTO zawNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Proobzatu remastr xten leii näjzatu refarisee, najctu beṉguijdx! Rusiatu detz bas näjza pla't luxh neṉni najc-dxuudx. Sigajcza la'tu riuduxhtu recostumbr, luxh lastootu guidxa yäḻgubaan näjza yäḻrdxe'chlajz. ");
INSERT INTO zawNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisee ni najc lotiä'p: gudibxgaa neṉ bas näjza neṉ pla't, dxejc näj dejtzni sajc naya. ");
INSERT INTO zawNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Proobzatu remastr xten leii näjzatu refarisee, najctu beṉguijdx!, sa'csi najctu si'c rebaa ni nacchesa'c; nolbäjreni, saru rluiini, luxh neṉreni guidxa dzujt xte beṉgut näjza bälyudx. ");
INSERT INTO zawNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sigajcza najctu la'tu. Saru rujn lojtu, rchalo rebejṉ najctu beṉsa'c, niluxh lastootu guidxa yäḻrusguee näjza yäḻguyalajz. ");
INSERT INTO zawNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Proobzatu remastr xten leii näjza refarisee, najctu beṉguijdx! Runcheetu xpaa redade' ni gunii xtidx Dios galoo, rusucheezatu ro' xpaa rebejṉ ni gujc beṉsa'c, ");
INSERT INTO zawNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","dxejc rniitu: “Paru nibajṉnu neṉ redxej ni gubajṉ retoxtadgoldoonu dinu niacnäj reni bagu't redade' ni gunii xtidx Dios.” ");
INSERT INTO zawNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Lagajc con rediidxre rcäjptu najctu rexajg renani bagu't redade' nani gunii xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Coḻguscuääz guntu sa' recos ni guläxtiej retoxtadgoldootu! ");
INSERT INTO zawNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡La'tu ni najc si'c bäḻ, la'tu ni najc si'c te bitiääz guidxa bäḻnialajz! ¿Xho guntu te na'c chäätu gabijl par tejpas? ");
INSERT INTO zawNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ni'cni, guxhaḻä rexpeṉä ni guinii xtidxä, näjza beṉnajn, näjza mastr. Luxh yu'reni sugu'ttu sucuaatureni lo crujz; yu'zareni siguijntu neṉ reguidobäz, sirinajltureni guejdx por guejdx. ");
INSERT INTO zawNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Si'cza yejctu jiajb xtiejn guiraa rebeṉnadolajz ni bagu't bejṉ xchejli toAbel ni gujc nadolajz, xchejliza Zacarías, xi'n Berequías, ni bagu'ttu neṉ guidoro gajxh lo bacuug. ");
INSERT INTO zawNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Rniliä́pac lojtu, dojḻ xten guiraa recosga siajb yejc rebejṉ ni tre' lo guedxliuj ṉaj. ");
INSERT INTO zawNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Räjpza Jesús: ―¡Jerusalén, Jerusalén! Xpejṉlu rugu't redade' ni rnii xtidx Dios, rucuaazareni guij yejc rebejṉ ni ruxhaḻ Dios te gusule'reni xtiidxni lojtu. ¡Balti huält rlazä nutie'ä la'tu si'cni rutie' guidco'c rexquidbäzni neṉ xhigani, per ditu nicäjb! ");
INSERT INTO zawNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Coḻhuii xho jianxteb xquidootu cuälazrenini. ");
INSERT INTO zawNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Rnixgaä lojtu, ṉaj dirutu fii loä, dxejli che guiniitu: “Benle' Dios nani siääd xcuentni.” ");
INSERT INTO zawNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Birii Jesús neṉ guidoro te asiini, dxejc gubig rexpejṉpacni lojni, gusloj caguluiireni reyuduxhga lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Dxejc räjp Jesús lojreni: ―¿La ruhuiitu guiraa reyu're? Rniliä́pac nicla tej guij di jia'n yejc sa'ni ree; guiragajc reyu're sibijḻ. ");
INSERT INTO zawNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Dxejcti huijreni yejc te dajn ni laa Oliib. Che gurej Jesús ro'c, biääd rexpejṉpacni lojni te xhiga'tz gunabdiidxreni lojni: ―Rlaaznu guiniilu loonu guc gac guiraa recosre. ¿Xhi seen guluiloj ameer jiäädlu näjza che ameer nitloj guedxliuj? ");
INSERT INTO zawNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Dxejc räjp Jesús lojreni: ―¡Coḻnatiro te rut gusgueedi la'tu! ");
INSERT INTO zawNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Sa'csi su' xhidajl reni jiääd, naareni: “Narä nacä Crist”, luxh susgueereni xhidajl bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Siejn diajgtu xcuent cadro cayajc gueṟ, näjza xcuent cadro rlajz chu gueṟ, na'c guidxejbtu sa'csi si'c nungäjḻ gac, niluxh gajd gaḻdi nitloj guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Sa'csi siäjs te nacióṉ sidiḻnäjni stee nacióṉ; te yäḻrnibee sujn gueṟ con stee yäḻrnibee, luxh su' gubijn, su' yäḻguijdx, su'za xuduxh xhidajl lajt. ");
INSERT INTO zawNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Luxh guiraa redee cuäxtiejtis retrabajwduxh ni churu chu. ");
INSERT INTO zawNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Dxejc guteedreni la'tu ladzṉaa rebeṉdojḻ te gusacsíreni la'tu, te gugu'tzareni la'tu, luxh guiraa rebejṉ sidxe'ch lojtu sa'csi sanälajztu narä. ");
INSERT INTO zawNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Neṉ redxejga, xhidajlreni sibälaz xcäḻrililajzreni, sidxe'ch lo sa'reni, suto' sa'reni lo sa'reni. ");
INSERT INTO zawNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Dxejc siricaj xhidajl bejṉ ni rusguee, gäbreni xcuent Dios rniireni, luxh susgueereni xhidajl bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sa'csi lacti suduxh yäḻlatsiaj lo guedxliuj, diru bejṉ chanälajz sa'ni. ");
INSERT INTO zawNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Dxejcti bejṉ ni chasanäj xnezyujtis Dios, ni'c sun gaan xca'ni yäḻnabajṉ par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Luxh sisiule' xtidx Dios guideb lo guedxliuj te gacbee guiraa rebeṉ guedxliuj xtiidxni; dxejcru jiääd fis xten Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Cheni fiitu asobga' te beṉguidxduxh neṉ yu' ni najc dxan neṉ guidoro, si'cni gunixgaa toDaniel ni gunii xtidx Dios gacni, bejṉ ni goḻ dee sugacbeeni nani roḻni, ");
INSERT INTO zawNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","dxejc renani rbäjz lo guedx Judea, suguxuṉreni gucuatzlojreni neṉ dajn. ");
INSERT INTO zawNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Bejṉ ni niä'p yejc xyu'ni dxejga di gaḻdi jiäjtni te chalääni xhixtenni neṉ xyu'ni; ");
INSERT INTO zawNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","bejṉ nani cayujn dzuun lo niaa, na'c guibi'ni niclaza chaxhiini xhajbni. ");
INSERT INTO zawNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Proobza regunaa ni nuxi'n, näjza reni cagusiä' bäz neṉ redxejga! ");
INSERT INTO zawNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Coḻnabduxh loj Dios xhet neṉdi redxej ni cayacnalduxhdi nanab guxuṉditu, niclaza dxej che rusilajz bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sa'csi su' trabajwduxh neṉ redxejga, sa' ni gajd bejṉ fii dxejli ni guzobloj guedxliuj, luxh che tedni, diru guibi' chuni. ");
INSERT INTO zawNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Luxh palga di Dios gutiu' yejc redxejga, nicla tej bejṉ di ḻaa. Luxh sutiu' Dios yejc redxejga sa'csi rinälajzni reni aguleni. ");
INSERT INTO zawNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Neṉ redxejga palga yu' chu naa lojtu: “Coḻhuii, aree Crist”, o “Coḻhuii ani arec”, na'c chalilajztuni. ");
INSERT INTO zawNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Siääd xhidajl niguii ni rusguee, gäbreni najcreni crist; sidzujṉza rebejṉ ni rusguee ni gäb xtiidxpac Dios rusule'reni; luxh sujnreni remilagwr sujnzareni senro, parsi gusgueereni, susgueduxhreni rebejṉ, niluxh rlajzreni gusgueezareni rebejṉ ni agule Dios, ni rililajz xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Agunixgaä lojtu xhini'c gac. ");
INSERT INTO zawNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ni'cni palga naareni lojtu: “Bahuii, a crist yu' nez lo reyubijdz”, na'c chäätu; o palga naareni: “A crist suga' neṉ yu're”, na'c chalilajztureni. ");
INSERT INTO zawNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sa'csi si'cni guideb xhaguibaa rieṉ che rdinya' ladjiaa näjza ladjiätli, si'cza suhuiitu loä, Xi'n Dios ni gujc Niguii, cheni jiälsacä lo guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ni najntu cadro naga' te mangut, ro'c ṟe' regolbetz. ");
INSERT INTO zawNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Räjpzani: ―Cuantsi ted guiraa retrabajwduxh, sicäjy lo gubijdx, diruza bäii gusanij, sitejbza rebajl ni yu' xhaguibaa, sinibduxhza guideb xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Dxejcti suhuiireni xhaguibaa seen xten Xi'n Dios ni gujc Niguii, luxh guiraa rebejṉ ni rbäjz neṉ guiraa reguejdx lo guedxliujre, sonduxhreni suhuiireni siääd Xi'n Niguii lo reza xhaguibaali. Siäädni con yäḻrnibee näjza yäḻrdimbichaduxh. ");
INSERT INTO zawNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Dxejc suxhaḻni rexanglni con te trompet ni guscuedxa'reni dipduxh te guire' guiraa rebejṉ ni aguleni lo guidajp lajd squiin guedxliuj, guideb lo guedxliuj näjza xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’¡Coḻguisieed ni ruluii yajg iigw! Che naren reṉaani che cabääni be'n, asiääd bäi curex, ");
INSERT INTO zawNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","sigajcza cheni fiitu cayajc guiraa recosre, sacbeetu asiädgajxh fis, rolä'li abidzujṉni. ");
INSERT INTO zawNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Rniliä́pac lojtu, guiraa redee sajc laḻ ni nabajṉ gaii rebejṉ ni suga' ree ṉaj. ");
INSERT INTO zawNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Guibaa näjza guedxliuj sinitloj, niluxh xtidxä di nitloj. ");
INSERT INTO zawNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Rut najndi xhi dxej, xhioṟ gacni, nicla rexangl Dios, niclaza Xi'n Dios; Dad Diostis najn. ");
INSERT INTO zawNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Sigajcni gujc neṉ redxej che gubajṉ toNoé, si'cza gac che jiälä Xi'n Dios ni gujc Niguii. ");
INSERT INTO zawNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Neṉ redxe galoo, cheni gajd nisguiduxhga jiajb, rebejṉ ni nabajṉ dxejc cayajwreni, cayä'reni, caguchṉaareni, cagudeedza bejṉ xindxa'preni guchṉaa, dxejli cheni biu' Noé neṉ barcwro. ");
INSERT INTO zawNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Direni niacbee xtiidxni; cheni biäädli nisguiduxh ni sanä guiraareni dxejcru gucbeereni. Sigajcza gacni che jiälsacä narä Xi'n Dios ni gujc Niguii. ");
INSERT INTO zawNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Neṉ redxejga palga cayujn tio'p bejṉ dzuun lo niaa tejni guibee, steeni sia'n. ");
INSERT INTO zawNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Palga cayo't tio'p gunaa xobniil, tejni guibee, steeni sia'n. ");
INSERT INTO zawNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Ni'cni coḻsusiṉ, sa'csi ditu gan xhi dxej jiääd Dad xtentu. ");
INSERT INTO zawNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Coḻganchee, paru niacbee baxhuaan xten yu' coṟ yääl niääd gubaan ni siädlan rolijzni, nisiusiṉni dxejc, dini nusaan niu'ni rolijzni te cuanni. ");
INSERT INTO zawNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ni'cni coḻsusiṉza la'tu, sa'csi siääd Xi'n Dios ni gujc Niguii lagajc oṟ ni ditu gun xhigab jiäädni. ");
INSERT INTO zawNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Chuni'c najc mossa'c ni ruzoob diidx, ni basannäj xlam̲ni rebejṉ ni yu' rolijzni te gudeedni xhi gaureni ä? ");
INSERT INTO zawNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Chicbaa mos ni saru cayujn xtzuunni che guidzujṉ xlam̲ni. ");
INSERT INTO zawNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Rniliä́pac lojtu, lam̲ga susa'nni sa' mosga te fiini guiraa xhixtenni. ");
INSERT INTO zawNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Dxejc palga mosga di gusoob xtidx xlam̲ni, gunni xhigab: “Sacladuxh guibi' xlam̲ä”, ");
INSERT INTO zawNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","dxejc guisloj cagusacsíni resamosni, guislojni gaunäjni, yänäjni rebeṉgu. ");
INSERT INTO zawNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Dxejc sidzujṉ xlam̲ni dxej che dini gun xhigab jiäädni, luxh oṟ ni dini gan guidzujṉni. ");
INSERT INTO zawNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Dxejc siguinduxhni mosguijdxga, surilaagwnini te guidxagsa'ni sabeṉguijdxni, dxejc sonduxhni, chubejli reläjyni. ");
INSERT INTO zawNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Räjpza Jesús: ―Pues xcäḻrnibee Dios najc si'c tzuu gunadxa'p nani cua' xcandilse'treni te huijreni te sa'. ");
INSERT INTO zawNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Gaii regunaaga nasiṉ, sgaiireni nayääl. ");
INSERT INTO zawNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Reni nayäälga sanäreni xcandilreni, niluxh direni nica' sijl se't. ");
INSERT INTO zawNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Niluxh reni nasiṉga sanäreni sijl se't te guze'creni neṉ xcandilreni. ");
INSERT INTO zawNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Sa'csi bi'nga di nidzuṉgaj, gunaaz bacaḻ regunadxa'pga, gudiejstireni. ");
INSERT INTO zawNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Dxejc si'cti garol yääl, biejn te xse' ni räjp: “Bi'n asiääd, coḻchäj, coḻchachaglojni.” ");
INSERT INTO zawNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Guiraa regunaare huistieguxuṉreni, dxejc bensa'creni xcandilreni, te cuaguijreni. ");
INSERT INTO zawNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Dxejc guigaii regunayääl räjpreni loj reni nasiṉ: “Coḻgunidxlaa te bo'c se't gusanijnu xcandilnu, sa'csi arlajzni jiuiini.” ");
INSERT INTO zawNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Dxejcti regunanasiṉ räjp lojreni: “Digacdini, dxejc dini gaḻ nicla par nuurnu nicla par la'tu. Coḻchäj cadro ruto'reni se't coḻchazii xse'ttu.” ");
INSERT INTO zawNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Laḻni sasii guigaii regunaa-nayäälga se't, bidzujṉ bi'n. Regunaa-siṉ ni cabäjz bi'n biunäjrenini lo sa', biäuuti ro lä'. ");
INSERT INTO zawNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Cheni bidzujṉ regunanayäälga, räjpreni: “Dad, Dad, baxhal ro lä'.” ");
INSERT INTO zawNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Dxejc räjpni lojreni: “Rniliä́pac lojtu, dina gumbeätu.” ");
INSERT INTO zawNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Dxejc Jesús räjp lojreni: ―Coḻsusiṉza, sa'csi ditu gan nicla xhi dxej nicla xhi oṟ siääd Xi'n Dios ni gujc Niguii. ");
INSERT INTO zawNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Xcäḻrnibee Dios xhaguibaa najc si'c te bejṉ ni agojl guirii chääni zijt te biaj. Gurejdxni rexmosni, badeedni meel lojreni. ");
INSERT INTO zawNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Lo tejni badeedni si'cti gaii miḻ meel, lo steeni badeedni si'cti tio'p miḻ, dxejc steeni cua' te miḻ. Loj tejgani badeedni si'cti ni rujnni xhigab sajc gunnäjreni dzuun, dxejcti biriini xpiajni. ");
INSERT INTO zawNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ni cua' gaii miḻ meel bejn te dzunro, bejnni gaan sgaii miḻ meel. ");
INSERT INTO zawNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Sigajcza ni cua' tio'p miḻ meel, bejnni gaan stio'p miḻ. ");
INSERT INTO zawNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Dxejcti ni cua' te miḻ meel, huicua'tzni xmeel xlam̲ni neṉ te gueed ni gudäänni lo yuj. ");
INSERT INTO zawNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Gudejdti balti bäii, dxejc gubi' xlam̲ remosga, bejnni cuent loj guiraareni. ");
INSERT INTO zawNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Che bidzujṉ ni cua' gaii miḻ meel, bidzuṉnäjni sgaii miḻ meel ni bejnni gaan, räjpni loj xlam̲ni: “Dad, baniidx guejblu gaii miḻ loä. Aree sgaii miḻ meel ni benä gaan.” ");
INSERT INTO zawNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Räjp xlam̲ni lojni dxejc: “Hueenca, mos hueen najclu, rusoobzalu xtidxä. Sa'csi gujclu beṉsa'c con te cos bäz, ṉaj sunidxä guinibeelu xhiroobru. Biu' loä, bibalaznäj narä.” ");
INSERT INTO zawNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Che bidzujṉni ni cua' tio'p miḻ meelga, räjpni loj xlam̲ni: “Baniidx guejblu tio'p miḻ meel loä, aree stio'p miḻ meel ni benä gaan.” ");
INSERT INTO zawNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Räjp xlam̲ni lojni: “Mbaj. Mos hueen najclu rusoobzalu diidx. Sa'csi gujclu beṉsa'c con te cosbäz, ṉaj sunidxä guinibeelu xhiroobru. Biu' loä, bibalaznäj narä.” ");
INSERT INTO zawNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Che bidzujṉ mos ni cua' te miḻ meel, räjpni lo xlam̲ni: “Dad, ananä najclu te bejṉ ni di gulazlajz; rca'lu cose'ch cadro dilu nibe'c binij, rutojpzalu cadro dilu nutie'ch binij. ");
INSERT INTO zawNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ni'cni bidxebä, huicua'tzä xmeellu neṉ yuj. Niluxh axh aree xmeellu.” ");
INSERT INTO zawNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Dxejc räjp xlam̲ni lojni: “¡Mos guijdx, mos ploj! Najnlu rca'ä cose'ch cadro dina nibe'cä binij, rutopä cadro dina nutie'chä binij. ");
INSERT INTO zawNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Riäjḻ nisa'nlu xmelä neṉ te bancw te che nibi'ä nicasacä xmelä con xi'nni ni niujni gaan.” ");
INSERT INTO zawNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Dxejc räjpni loj reni suga' ro'c: “Coḻgudzucaj te miḻ meel ni ca'ni coḻgudeedni loj ni rajp tzuu miḻ meel. ");
INSERT INTO zawNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sa'csi loj ni rajp sudedäru, niluxh ni xhet rajpdi sudzucaä tudxe'n nani rajpni.” ");
INSERT INTO zawNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Dxejc räjpni: “Coḻca' mosre ni xhet sajcdi, colguzäḻni lo yäḻnacäjy, cadro chu yäḻronduxh, näjza yäḻrajw reläjy bejṉ.” ");
INSERT INTO zawNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Che jiädsac Xi'n Dios ni gujc Niguii con yäḻrdimbicha' xtenni, siädnäni rexangl Dios. Dxejc sibejni lo troṉ ni rdimbicha' xtenni te guinibeeni. ");
INSERT INTO zawNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dxejc sidojp nez lojni guiraa rebeṉ guedxliuj. Dxejc sibeni lojreni, silia'ni sa'reni si'c rujn te baxtoor cheni rbeni rexiil loj redxib, te rlia'reni loj sa'reni. ");
INSERT INTO zawNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Suzujni rexiil xladbeeni dxejc redxib xladbäjgwni. ");
INSERT INTO zawNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Dxejc säjb ṟeii loj reni suga' xladbeeni: “Coḻtaa, la'tu ni beṉle' Xtadä. Coḻjiu' lo yäḻrnibee ni guc-chee cheni guzoblojli guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Sa'csi che calanä la'tu baniidx xhi gudauä, che cayolä, la'tu baniidx xhi gu'ä. Che cuanzaä si'c te beṉzijt, la'tu banidxlaatu cadro bia'nä. ");
INSERT INTO zawNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Che xheti xhabä, la'tu baniidxni, che gucxhuä, la'tu biädhuiitu narä, che guyu'ä neṉ latzguiib, biädhuiitu narä.” ");
INSERT INTO zawNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Dxejc sinii reni suga' xladbeeni, säjbreni: “Dad, ¿guc bahuiinu gulaanlu, baniidxnu xhi gudajwlu? ¿Guc bahuiinu cayojllu, baniidxnu xhi gu'lu? ");
INSERT INTO zawNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Guc bahuiinu najclu si'c te beṉzijt, baniidxnu cadro bianlaalu, o biäädx xhajblu, baniidxnu xhi gojtlu? ");
INSERT INTO zawNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","O ¿guc bahuiinu cayacxhuulu, o yu'lu neṉ latzguiib, biophuiinu lojlu?” ");
INSERT INTO zawNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Dxejc ṟeiiga säjb lojreni: “Rniliä́pac lojtu, xhitis xhi bejntu loj te rexpeṉä ni rnii xtidxä mase proobreni, lagajc loä bejntu recosga.” ");
INSERT INTO zawNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Dxejc säjpzani loj reni suga' ladbäjgwni: “Coḻguibicaj loä, beṉguijdx, coḻchäj lo balduxh ni cayejc par tejpas ni cayejc par beṉdxab ni rnibee näjza rexpeṉdxabni. ");
INSERT INTO zawNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sa'csi gulanä, luxh ditu nuniidx xhi niauä; biolä, per ditu nuniidx xhi niä'ä; ");
INSERT INTO zawNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","cuanzaä si'c te beṉzijt, luxh ditu nunidxlaa cadro nia'nä, biädxza xhabä, niluxh ditu nuniidx xhi niacwä; gucxhuä, guyu'äza neṉ latzguiib, niluxh ditu niädhuii loä.” ");
INSERT INTO zawNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Dxejc laareni säjbreni: “Dad, ¿guc bihuiinu calaanlu, o cayojllu, o canzajlu si'c te beṉzijt, o cayäädx xhajblu, o cayacxhuulu, o yu'lu neṉ latzguiib, luxh dinu niacnäjlu?” ");
INSERT INTO zawNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Dxejc säjb ṟeiiga lojreni: “Rniliä́pac lojtu, loj xhitis ni ditu niacnäj rebejṉ ni rililajz xtidxä, mase proobreni naräni ditu niacnäj.” ");
INSERT INTO zawNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Dxejcti sij rebejṉre lo yäḻrusacsí par tejpas, per rebejṉ ni nadolajz, ni agule Dios, sijreni lo xcäḻnabajṉ Dios par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Che gulujx gunii Jesús rediidxre, räjpni loj rexpejṉpacni: ");
INSERT INTO zawNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Anajntu stio'p dxejtis cayäädx gac lanij ni laa pascw. Luxh suteedreni narä, Xi'n Niguii ladzṉaa reni gucuaa narä lo crujz. ");
INSERT INTO zawNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Dxejc bidojp rebejṉ ni rnibee rebixhojz, näjza remastr xten leii, näjza rebeṉgool lo rexpejṉ Israel. Lo xle' Caifás, ni rnibee loj rebixhojz, bidojpreni. ");
INSERT INTO zawNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ro'c bachaagreni diidx xho guiniaazreni Jesús con yäḻrusguee, te ju'trenini. ");
INSERT INTO zawNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Luxh räjpreni lo sa'reni: ―Na'c jiennuni neṉ redxe lanij, te di gun rebejṉ bieiduxh. ");
INSERT INTO zawNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Che yu' Jesús guedx Betania, rolijz Simón te bejṉ ni basiajcni che raḻ tiejxhni, ");
INSERT INTO zawNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ro'c gubig te gunaa lojni, ca'ni te vasguij ni laa onix, guidxani te perfum ni sajc melro. Che sobga' Jesús lo mex, bachajni perfum yejc Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Che bahuii rexpejṉpacni xhi cayujnni, bidxe'chreni, gusloj cayäjpreni: ―¿Xhicuent casäḻxlia'ni perfumga? ");
INSERT INTO zawNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Perfumre niajc nido'ni, nirii xhidajl meel lojni te niacnäjni rebeṉproob. ");
INSERT INTO zawNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Biejn diajg Jesús xhi caniireni, dxejc räjpni lojreni: ―¿Xhicuent cadxe'chnäjtu gunaare? Ni te coshueen najc dee nani bejnni loä. ");
INSERT INTO zawNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ni guirasi dxej su' rebejṉ ni xhet rajpdi lojtu, peta narä guxii dxej su'ä lojtu. ");
INSERT INTO zawNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nani bejn gunaare che bachajni perfumre guideb lagaa tiexhä, najcni par guzucheeni narä te guiga'tzä. ");
INSERT INTO zawNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Rniliä́pac lojtu, cadrotis gusule'reni xtidxä lo guideb guedxliuj, sujyreni diidx xcuent ni bennäj gunaare narä, te guinaj lajzreni gunaare. ");
INSERT INTO zawNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Dxejc lo retzubitio'p rexpeṉpac Jesús birii tej ni laa Judas Iscariote, huininäjni rebejṉ ni rnibee loj rebixhojz, ");
INSERT INTO zawNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","räjpni: ―¿Lac guniidxtu loä te gutedä Jesús ladzṉaatu? Dxejc badeedreni gaḻbitzuu melpla't lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Dxjecli caguiil Judas xho gutedni Jesús lojreni. ");
INSERT INTO zawNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Primer dxej lanij, dxej ni rajwreni yätxtiil ni di saguij, gubig rexpejṉpacni loj Jesús, räjpreni lojni: ―¿Caro rlajzlu chozucheenu te gaulu xchej xten lanipascw? ");
INSERT INTO zawNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Dxejc räjpni lojreni: ―Coḻchäj lo guejdx rolijz te dade', coḻye'tz lojni: “Si'c naj Dad mastr: Asiäddzuṉgajxh xoṟni, ni'cni rolijzlu gaunäjni rexpejṉni xchej lanipascw.” ");
INSERT INTO zawNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Bejnti rexpejṉpacni si'cni gunibee Jesús gac, bazucheereni xchej xten pascw. ");
INSERT INTO zawNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Che biu' guxhijṉ, sobga' Jesús lo mex con retzubitio'p xpejṉpacni. ");
INSERT INTO zawNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Laḻ ni cayajwreni räjpni lojreni: ―Rniliä́ lojtu, yu' tejtu ni guto' narä. ");
INSERT INTO zawNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Dxejc guc-huinduxh lajzreni, räjpreni lojni: ―Dad, ¿andi naräni? ");
INSERT INTO zawNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Dxejcti räjp Jesús lojreni: ―Ni gaunäj narä neṉ tejtis pla't, laa ni'cni guto' narä. ");
INSERT INTO zawNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Xi'n Dios ni gujc Niguii sajc si'ctis ni caj loj guijtz xten Dios, per gunatiro bejṉ ni guto'ni. Huenru na'c niajl bejṉga. ");
INSERT INTO zawNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Dxejcti gunii Judas, ni caguto' Jesús, räjpni: ―Mastr, ¿andi naräni? Jesús räjp lojni: ―O'n, lujni. ");
INSERT INTO zawNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Laḻ ni sobga'reni cayajwreni, guläs Jesús yätxtiil, badeedni xquixtios lo Dios, dxejcti gula'nini, badeednini loj rexpejṉpacni, räjpni: ―Coḻtajw; dee najc si'c tiexhä. ");
INSERT INTO zawNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Dxejc guläsni te vas, badeedni xquixtios lo Dios, dxejcti badeednini loj rexpejṉpacni, räjpni: ―Guiraatu coḻyä', ");
INSERT INTO zawNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","sa'csi dee najc si'c xtienä; ni'cni riannää́ la'tu te didxcoob, luxh rejnre sixe'ni xcuent xhidajl bejṉ te gusḻaanireni neṉ dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Luxh rniä lojtu, diruna yä'ä nis nani ṟii yejc uub, dxejlini yänäsacätu lo xcäḻrnibee Dios, Xtadä. ");
INSERT INTO zawNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Che gulujx biḻreni te dij, biriireni, sääreni lo dajn ni laa Oliib. ");
INSERT INTO zawNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Dxejc räjp Jesús lojreni: ―Guiragajctu sactio'p lajztu xcuentä, susa'ntu narä naguxhijṉ sa'csi lo reguijtz xten Dios caj scree: “Sugu'treni baxtoor dxejc sire'ch rexiil.” ");
INSERT INTO zawNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Dxejc cheni guibaṉsacä lo rebeṉgut, ganidä cha'ä región Galilee, dxejcti jiädnajltu narä. ");
INSERT INTO zawNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Dxejc räjp Pedr loj Jesús: ―Masque guiraareni cuälazlu, narä dina cuälazälu. ");
INSERT INTO zawNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Dxejc räjp Jesús lojni: ―Rniliä́pac lojlu, lagajc guxhijṉre, nicla gajd guidgaii cuedxa', luxh luj alagulälazlu narä choṉ huält. ");
INSERT INTO zawNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Räjp Pedr loj Jesús: ―Masque riäjḻ guetnää́lu, dina cuälazälu. Dxejc sigajcza gunii guiraa rexpejṉpacni. ");
INSERT INTO zawNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Dxejcti bidzujṉ Jesús näjza rexpejṉpacni te lajt ni laa Getsemaní, räjpni lojreni: ―Coḻcuésijc ree laḻ ni cuedx-guiniabä lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Dxejc sanäni Pedr näjza guiṟo'p xi'n Zebedeo, luxh gusloj cayachuinduxh lajzni, cayu'zani yärsiaduxh. ");
INSERT INTO zawNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Dxejc räjpni lojreni: ―Te yäḻhuinduxh yu' lastoä; astoocanu agojl guetä. Coḻjia'n ree, coḻtie'ch bacaḻ lojtu. ");
INSERT INTO zawNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Dxejc guzaj Jesús stla', guzuxhijbni dxejc basajb lojni lo yujli, gusloj cabedx-canabni lo Dios: ―Xtadä, palga sajcni, basanlaa tedcaj trabajwduxhre ni tedä, te na'c tedäni. Xhet si'cdi ni rlazä gacni; si'cpacni rlajzlu gac, si'c gacni. ");
INSERT INTO zawNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Dxejcti gubi'ni cadro suga' guichoṉ rexpejṉpacni, che bidzujṉni ro'c, nagayejsreni. Räjpni lo Pedr: ―¿La di niajcdi nutie'chtu bacaḻ lojtu nicla teboṟ, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Coḻguibajṉ, coḻnab lo Dios te na'c jiajbtu neṉ dojḻ. Guliipacni, lastootu nadip, niluxh tiejxhtu rdxajg. ");
INSERT INTO zawNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Gubi' Jesús stehuält, gurejdx-gunabni loj Dios, räjpni: ―Xtadä, palga digacdi tedcaj tedä trabajwre, sugacni si'ctis ni rlajzlu gacni. ");
INSERT INTO zawNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Dxejc gubisacni, bidxälni rexpejṉpacni, nagayejsreni sa'csi yuduxh bacaḻ lojreni. ");
INSERT INTO zawNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Basaannireni, dxejc säsacni, gurejdx-gunabni lo Dios ni riojṉ huält, gunisacni lagajc rediidx ni guniini galoo. ");
INSERT INTO zawNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Dxejc huijni cadro suga' rexpejṉpacni, räjpni lojreni: ―¡N̲aj sii, coḻguejs, coḻgusilajz! Abidzujṉ oṟ ni gutedreni Xi'n Dios ni gujc Niguii ladzṉaa rebeṉdojḻ. ");
INSERT INTO zawNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Coḻchastie, coḻcho', colhuii! Asiääd nani guted narä ladzṉaa rebeṉdojḻ. ");
INSERT INTO zawNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Laḻni canii Jesús bidzujṉ Judas, nani najc tej retzubitio'p xpejṉpacni. Bidzuṉnäjni xhidalduxh bejṉ ni ca' espaad, ni ca' gaṟo't, najcreni xpejṉ reni rnibee rebixhojz, näjza xpejṉ rebeṉgool xten rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas, ni bato' Jesús, abadedxgaani te seen lojreni räjpni: ―Nani guchagro'ä, ni'c najc laani; coḻguiniazgajcni. ");
INSERT INTO zawNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Dxejc gubigni loj Jesús, räjpni: ―Xchan, Dad Mastr. Dxejc bachagro'ni lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús räjp lojni: ―Xamigwä, ¿xhi siäädlu? Dxejcti gubig rebejṉ lojni, gunaazrenini. ");
INSERT INTO zawNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Per tej reni suganäj Jesús gulääni te spaad, batiu'ni diajg te mos xten rebixhojz ni rnibee. ");
INSERT INTO zawNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Dxejc räjp Jesús lojni: ―Guluchee xspaadlu loj xse'ni. Guiraa reni rucuanäj con spaad, lagajc con spaad guetreni. ");
INSERT INTO zawNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿La ditu gan sajcza guiniabä lo Xtadä, luxh laani suxhaḻgajcni gayoṉbitzubitio'p miḻ xanglni gacnäj narä? ");
INSERT INTO zawNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Dxejc xho gac soob diidx ni caj lo reguijtz xten Dios ni rnixgaa riäjḻ gac guiraa recosre lagajc si'cni cayajcni. ");
INSERT INTO zawNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Dxejc räjp Jesús loj rebejṉ xhidajlga: ―¿La siädnätu spaad näjza gaṟo't te guiniaaztu narä astoocanu nacä si'c te gubaan? Ni guirasi dxej gureä galäiitu, baluiätu neṉ guidoro, luxh ditu niniaaz narä. ");
INSERT INTO zawNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Niluxh guiraa recosre cayajc te soob rediidx ni caj lo reguijtz ni bacuaa redade' ni gunii xtidx Dios. Dxejcti guiraa rexpejṉpacni basanxtebreni Jesús, baxuṉreni lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Reni gunaaz Jesús huinänini nez loj Caifás, ni rnibee loj guiraa rebixhojz, bidzujṉreni cadro abidojp guiraa rebejṉ nani ruluii leii näjza rebeṉgool xten xpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Dxejcti zit-zijt biädnajl Pedr rebejṉga, bidzujṉlireni lole' xten bixhojz ni rnibeega. Ro'c biu'ni, gurenäjni rexquixhajg bixhojzga te ro'c bia'nni te fiini xhini'c gac. ");
INSERT INTO zawNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Reni rnibee rebixhojz, näjza rebeṉgool con guiraa reni rajp yäḻrnibee gusloj caguiilreni xhitis te diidx, masque xhet guliidini, te gucuaquijreni Jesús te guinibeereni guetni. ");
INSERT INTO zawNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Niluxh xhet bidxäldireni, luxh gubig xhidajl bejṉ, guniireni xhidajl didx-xhii xcuent Jesús. Dxejcti bidzujṉ tio'p dade' ni gunii didx-xhii, ");
INSERT INTO zawNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","räjpreni: ―Niguiire gunii scree: “Narä sajc gutzuḻä guidoro xten Dios, sajcza gunchesacäni neṉ choṉ dxej.” ");
INSERT INTO zawNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Dxejc gusulii dade' ni rnibee lo rebixhojz, räjpni loj Jesús: ―¿Xhicuent xhet rniidilu, ä? ¿Xhini'c canii reniguiire cagucuaquijreni luj? ");
INSERT INTO zawNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Niluxh dxitis suga' Jesús. Dxejcti räjp dade' ni rnibee loj rebixhojz lojni: ―Rnibeä guiniliilu, guiniliipaclu con laj Gueb Dios nani nabajṉ. Gunii don, ¿la luj najc Crist, Xi'n Dios? ");
INSERT INTO zawNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús räjp lojni: ―Lagajc guejblu naj si'c. Niluxh empac rniä lojtu, desde ṉajli suhuiitu cueä narä Xi'n Dios ni gujc Niguii xladbee Dios ni rnibee, suhuiizatu jiälä lo reza ni tre' xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Dxejc batiäjs dade' ni rnibee loj rebixhojz xhajbni, räjpni: ―¡Niguiire aguniyajni Dios con xtiidxni! ¿Xhiru testiigw rquiinnu? Abiejn diajgtu didxyaj xtenni. ");
INSERT INTO zawNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Xhi rchalotu? Dxejc basejcreni diidx: ―¡Abiga'ni! Riäjḻ guetni. ");
INSERT INTO zawNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Dxejc batiobxhejnreni lojni, gudijnrenini. Yu'reni gudajp lojni, ");
INSERT INTO zawNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","räjpreni lojni: ―Palga najclu Crist, gunii chuni'c gudijnlu. ");
INSERT INTO zawNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Laḻ ni cayajc reni'c, Pedr sobga' lole'. Dxejc gubig te dxape' ni rujn dzuun ro'c, räjpni lojni: ―Näjza luj cuansanäjlu Jesús, ni siääd nez Galilee. ");
INSERT INTO zawNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Per di Pedr nicäjp nez loj guiraareni, räjpni: ―Dina ganä xhini'c caniilu loä. ");
INSERT INTO zawNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Asii Pedr nez ro' puert, che bidxaagni stee dxape' ni rujn dzuun ro'c. Dxape're räjp loj reni suga' ro'c: ―Näjza dade're cuansanäj Jesús ni siääd Nazare't. ");
INSERT INTO zawNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Dxejc basguee Pedr stehuält, räjpni: ―Rniliä́pac dina gumbeä dade'ga. ");
INSERT INTO zawNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Che gojl sterate', gubig reni suga' ro'c loj Pedr, räjpreni: ―Guliini; näjza luj najclu te xpejṉni; huenliisi riejn diidx ni rniilu. ");
INSERT INTO zawNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Dxejcti guslojni cagueni, caguzä'tni Dios, räjpni: ―Dipacna gumbeä niguiiga. Guniitisni si'c, chela guredxa' te guidgaii. ");
INSERT INTO zawNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Dxejcru banalajz Pedr rediidx ni gunii Jesús lojni che räjpni: “Che gajdli guidgaii cuedxa', choṉ huält alaguniilu dilu gumbee narä.” Dxejc birii Pedr ro'c, gusloj cayonduxhni. ");
INSERT INTO zawNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Che bianij lo guedxliuj, guiraa reni najc rebixhojz ni rnibee näjza rebeṉgool xten rexpejṉ Israel bia'nreni diidx xho gunreni ju'treni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Baliibrenini, guläärenini ro'c, huisa'nrenini loj Poncio Pila't, ni najc gubernadoor. ");
INSERT INTO zawNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Dxejcti Judas, ni bato' Jesús, che bahuiini bacuaquijreni Jesús, basiejch lajzni, guc-huin lajzni, dxejc huidzu'ni gaḻbitzuu meel pla't loj rebixhojz ni rnibee näjza loj rebeṉgool. ");
INSERT INTO zawNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Räjpni: ―Banitduxhä lo Dios sa'csi bato'ä te bejṉ ni xhet bejndi. Dxejc räjpreni lojni: ―Xhixh gunnu. Ni'c najc xcuentlu; lujti najn. ");
INSERT INTO zawNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Dxejc bacuaa Judas meelga lo yuj neṉ guidoro, biriitini ro'c. Sas huijni, baliibni te duu guejnni, gojḻni lo te yajg, ro'cti gujtni. ");
INSERT INTO zawNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Rebixhojz ni rnibee batojpreni meelga, räjpreni: ―Di gac di guizäḻnu meelre neṉ caj gojn sa'csi najcni xcuent xtiejn te bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dxejc bia'nreni diidx con meelga siireni te la' yuj xten te dade' ni runchee guejs te ro'c gucua'tzreni rebeṉzijt. ");
INSERT INTO zawNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ni'cni ṉajli rniireni yujga: “Yurejn”. ");
INSERT INTO zawNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Si'c gusojb diidx ni gunii Jeremías, dade' ni gunii xtidx Dios galoo che räjpni: “Cua'reni gaḻbitzuu melpla'tga si'cti basoob rexi'n Israel sajc bejṉga. ");
INSERT INTO zawNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Con meelga guziireni yuj lo bejṉ ni runchee guejs, sigacni gunibee xtadnu Dios.” ");
INSERT INTO zawNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Bidzuṉnäjreni Jesús loj Pila't ni najc gubernadoor. Dxejc gunabdiidxni, räjpni lo Jesús: ―¿La luj najc ṟeii xten rexpejṉ Israel, ä? Räjp Jesús lojni: ―Najcni si'cni najlu. ");
INSERT INTO zawNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Laḻni cabe'c rebixhojz ni rnibee näjza rebeṉgool rexquej Jesús xhetliidi guniidi Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Dxejc räjp Pila't lojni: ―¿La di diajglu jiejn guiraa rediidx ni caniireni cagucuaquijreni luj, ä? ");
INSERT INTO zawNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Per xhetliidi diidxdi basejc Jesús, nicla xcuent tejsi diidx ni bacuaquijrenini. Ni'cni bidxeloduxh gubernadoorga. ");
INSERT INTO zawNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Neṉ redxe lanij rajpreni costumbr rusḻaa Pila't tej bejṉ ni cue rebejṉ loj reni yu' neṉ latzguiib. ");
INSERT INTO zawNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Neṉ redxejga guyu' te bejṉ ni sääb xtiidxni ni laa Barrabás. ");
INSERT INTO zawNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Cheni tre' guiraareni ro'c, gunabdiidx Pila't lojreni: ―¿Chuni'c rlajztu gusḻaä́, la susḻaä Barrabás o Jesús ni laa Crist? ");
INSERT INTO zawNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Sa'csi najn Pila't rdxe'chlajzreni lo Jesús, ni'c bateedrenini lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Laḻ ni sobga' Pila't lo yajgxhiil cadro rujnni yäḻguxhtis, baxhaḻ chäälni diidx lojni, räjpni: ―Xhet gundilu dade'ga ni xhet bejndi, sa'csi nuchej nadxuudx gunixcaḻä xcuentni. ");
INSERT INTO zawNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Niluxh rebixhojz ni rnibee näjza rebeṉgool baquiilreni rebejṉ te gunabreni ḻaa Barrabás, näjza te guet Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Dxejcti gunii gubernadoor stehuält, räjpni lojreni: ―¿Chu tej loj guiro'preni rlajztu gusḻaä́? Dxejc guredxa'reni, räjpreni: ―¡Barrabás! ");
INSERT INTO zawNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Gunabdiidx Pila't, räjpni: ―¿Xhi gunnää́ Jesús ni laaza Crist? Guiraareni guredxa': ―Bacuaani lo crujz. ");
INSERT INTO zawNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Dxejc räjp Pila't lojreni: ―¿Xhi latsiaj bejnni? Niluxh laareni guredxa'rureni, räjpreni: ―¡Bacuaani lo crujz! ");
INSERT INTO zawNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Che bahuii Pila't xlia'si caniini, alga gusloj rebejṉ cayujn te bieiduxh, cua'ni nis, gudiibni ṉaani nez lojreni, räjpni: ―Dina xcaquiä xtiejn bejṉre ni xhet bejndi. La'tu coḻhuii xho guntu. Xcuenttitu najcni. ");
INSERT INTO zawNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Dxejc guiraa rebejṉga badzu' diidxre, räjpreni: ―Suxcaquijnu xtiejnni, nuurnu näjza rexi'nnu. ");
INSERT INTO zawNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Dxejc basḻaa Pila't Barrabás, dxejc gunibeeni gudijnreni Jesús dxejc bateednini ladzṉaa rebejṉ te gucuaarenini lo crujz. ");
INSERT INTO zawNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Dxejc huinä resoldaad xten gubernadoor Jesús lo pretoor, yu' cadro rujnreni yäḻguxhtis, ro'c batojpreni guiraa resa'reni. ");
INSERT INTO zawNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Dxejc gulääreni xhajbni, bashuajcwrenini te lad xniaa. ");
INSERT INTO zawNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Dxejc bencheereni te coroṉ guejch, basäḻrenini yejcni, basäḻreni te yabixijl ṉaani, xladbeeni, sas bazuxhijbreni nez lojni guslogajc caguxhisnäjrenini, räjpreni: ―¡Coḻlä'p xpala'n ṟeii xten rexpejṉ Israel! ");
INSERT INTO zawNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Sas batiobxhejnreni lojni, cua'reni yabixijlga te ni'c batiäjlreni yejcni. ");
INSERT INTO zawNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Che gulujx baxhiznäjrenini, gulääreni lad xniaa ni najcwni. Dxejc bashuacwsacrenini lagajc xhajbni, sanätirenini te xcajni lo crujz. ");
INSERT INTO zawNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Cheni sariireni, bidxaagreni te bejṉ ni siääd guedx Cirene, laani Simón, basguureni dade'ga xcrujz Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Che bidzujṉreni te lajt ni laa Gólgota, nani säloj: dan Calabeer, ");
INSERT INTO zawNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ro'c badeedreni bin nu'ch cuanlaa te gu' Jesús. Te bocbäztisni gu'ni, dxejc naaddiruni niä'nini. ");
INSERT INTO zawNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Cheni abacuaareni Jesús lo crujz, gudzujt resoldaad yejc xhajbni, te si'c gudisreni xhajb Jesús cua'reni, te si'c guzojb diidx xten te dade' ni gunii xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Gurejtireni ro'c, gusloj canäjreni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yejc crujzga bacuaareni te guijtz con letrro. Lo guijtzga rcaj xhini'c najc xtojḻ nani cayejt. Lo guijtzga caj: “Dee najc Jesús ṟeii xten rexpejṉ Israel.” ");
INSERT INTO zawNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Näjza tio'p gubaan cuaj lo stio'p crujz con laani. Tejni cuaj lo te crujz xladbee Jesús, steeni cuaj xladbäjgwni. ");
INSERT INTO zawNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Luxh renani sadejd nejzga guniyajreni Jesús, cagusniibreni yejcreni, ");
INSERT INTO zawNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","cayäjpreni lojni: ―¡Ja'ä! Luj ni nutiexhlu guidoo, luxh choṉtis dxej niunchesacluni; palga gulii najclu Xi'n Dios, biäjt loj crujzga. ");
INSERT INTO zawNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Näjza rebixhojz ni rnibee, näj remastr xten leii, baxhiznäjrenini räjpreni loj sa'reni: ");
INSERT INTO zawNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Basḻaani xhidajl bejṉ, xhoxh di gacdi gusḻaani lagajc laani. Palga najcni ṟeii xten rexpejṉ Israel, sujiäjtni lo crujz naṉaj te chalilajznu xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Huinälajzni Dios, ṉaj sugusḻaa Diosni palga sanälajz Diosni; ni najni: “Narä nacä Xi'n Dios.” ");
INSERT INTO zawNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Regubaan ni caj lo recrujz sigajcza guniyajreni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Dxejcti bicäjy guideb guedxliuj läidxej hasta rcachoṉ gudxej. ");
INSERT INTO zawNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Si'cti rcachoṉ gudxej guredxa' Jesús dipduxh, räjpni: ―Elí, Elí, ¿lama sabacatani? ―dee säloj: Xtiozä, Xtiozä, ¿xhicuent gulälazlu narä? ");
INSERT INTO zawNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Yu' reni suga' ro'c, che biejn diajgreni räjpni si'c, räjpreni: ―Cabejdx Dade're Elías. ");
INSERT INTO zawNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Baxuṉgajc tejreni, huica'ni te sponj, bahuajdxnini loj binagr, bacuaanini yejc te biquii te badzugni binagrga ro' Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Dxejc reni tre' ro'c räjp: ―Basaan; guidon la siääd Elías te gusḻaanini. ");
INSERT INTO zawNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Dxejc guredxaduxh Jesús stehuält, basḻaatini xpritni. ");
INSERT INTO zawNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Lagajc oṟga biräsya' ladro ni zääb neṉ guidoro, gujcni tio'p la' jiaali hasta lo yuj. Gujc te xuro, sas gusuj bej reguiro. ");
INSERT INTO zawNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Dxejc gubicaj reguij ni niäuu ro' rebaa, luxh gubaṉsac xhidajl xpejṉ Dios ni gujt aguc xchej. ");
INSERT INTO zawNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Dxejcti, che huäjs Jesús lo rebeṉgut, biriireni neṉ baa, baluilojreni lo xhidajl bejṉ ni rbäjz guedx Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Dxejc capitán xten resoldaad näjza resoldaad ni canäj Jesús, che bahuiireni xuduxh näjza guiraa recos ni gujc ro'c, bidxejbreni, räjpreni: ―Guliipacni najc dade're Xi'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Zijtru tre' xhidajl regunaa ni biädnajl Jesús che biriini nez Galilee te bahuiirenini. Cadxelojtisreni guiraa ni cayajc ro'c. ");
INSERT INTO zawNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tej regunaaga najc Marii Magdaleṉ, steeni najc Marii xnan Jacoob näjza José, steeni najc xnan rexi'n Zebedeo. ");
INSERT INTO zawNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Che gojl gudxej, bidzujṉ te beṉrajp ni siääd guedx Arimatea; laani José. Näjza dade'ga najc tej reni birinajl Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Huij dade'ga loj Pila't, gunabni tiejxh Jesús. Dxejc gunibee Pila't gudeedrenini lojni. ");
INSERT INTO zawNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Cua'ti José tiejxh Jesús, batejbnini neṉ te bariadya, ");
INSERT INTO zawNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","huitixhnini neṉ xpaapacni. Nacoob baaga, gojnni bidäänni cuä' te guilaj. Dxejc basäuni ro' baaga con guiro, dxejcti siini. ");
INSERT INTO zawNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Sobga'za Marii Magdaleṉ näjza stee Marii nez loj baa, bahuiireni biga'tzni. ");
INSERT INTO zawNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Che gudejd dxej xten ni gulec-cheereni lanij, bara yääl bidojp rebixhojz ni rnibee näjza rebejṉ ni laa refarisee, bidzujṉreni loj Pila't, ");
INSERT INTO zawNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","räjpreni lojni: ―Dad, banaj laaznu xhi räjp bejṉ ni rusgueere. Räjpni: “Che ted choṉ dxej sibaṉsacni loj rebeṉgut.” ");
INSERT INTO zawNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ni'c baxhaḻ chu chacanäj ro' baaga dxejli guisa' choṉ dxej, te di chää rexpejṉpacni chaläärenini tiejxhni, dxejc gäbreni loj rebejṉ: “Agubaṉsacni loj rebeṉgut.” Yäḻrusgueega sajc cuentroru loj ni gujc ganid. ");
INSERT INTO zawNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Räjp Pila't lojreni: ―La'tu rajptu te cuaa soldaad; coḻchäj, basäutzu'tz ro' baaga si'ctis ni sajc guntu. ");
INSERT INTO zawNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Dxejcti sääreni, basäutzu'tzreni ro' baaga; con resoldaad bacuaareni te seii lojni te rut faḻdini. Dxejc basa'nreni resoldaad canäj ro'c. ");
INSERT INTO zawNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Che gudejd sabd, dxej ni ruzilajz rexpejṉ Israel, che gusloj cayänij lo guedxliuj te jiu' stee xmaan, bidzujṉ Marii Magdaleṉ näjza stee Mariiga, siädhuiireni lo baa. ");
INSERT INTO zawNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Luxh alagujc te xuro ni basniib lo yuj, sa'csi biääd te angl xten Dios xhaguibaali te badzucajni guij ni niäuu ro' baaga, dxejc gurejni yejc guijga. ");
INSERT INTO zawNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Rdimbichaduxhni si'c najc che rdinya', luxh xhajbni najc nolbäj si'c najc yejg ni riajb. ");
INSERT INTO zawNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Che bahuii resoldaadni, bichebduxhreni, sädiidxreni, gujcreni si'c beṉgut. ");
INSERT INTO zawNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Dxejc räjp guixhajg xte Diosga loj regunaa: ―Na'c guidxejbtu. Ananä caguiiltu Jesús ni cuaj lo crujz. ");
INSERT INTO zawNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Rutini ree sa'csi agubaṉsacni sigajc ni najni. Coḻtahuii cadro gojtni. ");
INSERT INTO zawNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Coḻguxuṉ, coḻchaye'tz loj rexpejṉpacni agubaṉsacni loj rebeṉgut. Luxh ṉaj agunijdni lojtu sääni región xten Galilee. Ro'c suhuiitu lojni. Dee najc diidx ni rniä lojtu. ");
INSERT INTO zawNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Dxejcti rusquenduxh regunaaga, biriireni ro' baaga. Cadxejbreni, cabalazduxhzareni sanäreni diidx loj rexpejṉpac Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Chela bidxaagreni Jesús lo nejz, räjpni: “Xchan”, lojreni. Sas gubigreni loj Jesús, bazuxhijbreni, gudääzreni guenni'ni, gojṉrenini. ");
INSERT INTO zawNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Dxejc räjpni lojreni: ―Na'c guidxejbtu. Coḻchanä diidx loj rexpeṉä, chääreni región Galilee, sa'csi ro'c suhuiireni loä. ");
INSERT INTO zawNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Laḻni sää regunaaga, bidzujṉ gaii soldaad ni huicanäj ro' baa lo guejdxga, huisa'nreni diidx lo rebixhojz ni rnibee xcuent guiraa ni guzajc ro' baaga. ");
INSERT INTO zawNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Dxejc rebixhojz ni rnibee bachagsa'zareni con rebeṉgool te bia'nreni diidx gudeedreni xhiroob meel lo resoldaad, ");
INSERT INTO zawNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","räjpreni lojreni: ―Scree coḻye'tz lo rebejṉ: “Laḻ ni nagayesnu, canäjnu ro' baa, biääd rexpejṉpac Jesús guläxhiga'tzreni tiejxhni.” ");
INSERT INTO zawNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Palga jiendiajg gubernadoor dee, siohuiinuni te di yu' xhi gunni la'tu. ");
INSERT INTO zawNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Dxejcti cua' resoldaad meel, bejnreni si'cni räjp rebixhojz. Luxh si'c bire'ch diidx loj guiraa rexpeṉ Israel. N̲ajli canisijcreni si'c. ");
INSERT INTO zawNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Dxejcti sää retzubiteeb xpejṉpac Jesús lo región Galilee, lo dajn cadro bia'n Jesús diidx guidxaagnireni. ");
INSERT INTO zawNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Cheni bahuiireni loj Jesús, bazuxhijbreni, gojṉrenini, per yu' reni ractio'p lajzreni. ");
INSERT INTO zawNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Dxejc gubig Jesús lojreni, guninäjnireni, räjpni: ―Arapä guiraa yäḻrnibee xhaguibaa näjza lo guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ni'cni, coḻchäj, guideb guedxliuj coḻchagajn bejṉ gac xpeṉä, coḻgutiobnisreni, con laj Gueb Dios, näj laj Xi'n Dios näjza laj Sprit Dxan xten Dios. ");
INSERT INTO zawNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Coḻguluiireni gusoobreni guiraa rediidx ni guinibeä. Luxh lagajc narä suganää́ la'tu guiraa redxej, dxejli che nitloj guedxliuj. Sugacni si'c.");
INSERT INTO zawNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Scree gusloj diidx xcuent Jesucrist, Xi'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Si'cni bacuaa toIsaías, ni gunii xtidx Dios, che räjp Dios: Bahuii gan, guxhaḻä ni chanä xtidxä, ganidni chääni lojlu te guzucheeni xnezyujlu. ");
INSERT INTO zawNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Riejn xse' ni rbedxa' nez loj reyubijdz: “Coḻyunsa'c xnezyuj Dad, coḻslii rexnezyulajzni.” ");
INSERT INTO zawNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Biricaj Juan ni rutiobnis nez loj reyubijdzga. Räpgajcni nanabpac gusiechlajzreni, tiobnisgajcreni, te jia xtojḻreni. ");
INSERT INTO zawNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Riädcuadiajg xhidajl reni rbäjz Judea, näjza reni rbäjz guedx Jerusalén. Dxejcti cheni ruxhobdojḻreni lo Dios, rustiobnis Juanreni neṉ gueu Jordán. ");
INSERT INTO zawNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Xhajb Juan nacchee con guichlajd cameii, xsindoorni nacchee con guijd, niluxh gudajwni guxha't näjza dzunbäserguijxh. ");
INSERT INTO zawNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Caguluiini rebejṉ, räpgajcni: ―Detzä siääd tej nani sajcru loä, nani nicla di nungäjḻ surloä, cuää́ xcura'chni. ");
INSERT INTO zawNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Narä abatiobnisä la'tu con nis, biädla laani guxhaḻni Sprit Dxan xten Dios te cuääzni neṉ lastootu. Si'c gustiobnis nani jiääd detzä la'tu. ");
INSERT INTO zawNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Dxejc, neṉ redxejga, birii Jesús guedx Nasare't ni yu' Galilee. Dxejcru batiobnis Juan Jesús neṉ gueu Jordán. ");
INSERT INTO zawNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Che birii Jesús neṉ nis, bahuiini bixal guibaa. siädyäjt Sprit Dxan xten Dios yejcni si'c te palom. ");
INSERT INTO zawNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Dxejcti guibaali biejn xse' te ni räjp: ―Luj najclu xi'nä ni sanälazä; rbanälazduxhälu. ");
INSERT INTO zawNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Sas baxhaḻ Sprit Dxan xten Dios Jesús lo reyubijdz. ");
INSERT INTO zawNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Dxejc guyu' Jesús ro'c tiuu dxej, guyu'ni cadro yu' reman. Sas gudiil beṉdxab nani rnibee, nani laa Satanás, xho niujnni te nusoob Jesús xtiidxni. Dxejcru biääd reangl xten Dios, biädhuiirenini. ");
INSERT INTO zawNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Basäḻreni Juan neṉ latzguiib. Dxejcti huij Jesús nez Galilee, huiluiini xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Dxejc räjp Jesús: ―Abidzujṉ dxej, luxh yäḻrnibee xten Dios abidzujṉ gajxh. Coḻsiejch lajztu, coḻchalilajz xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sasajti Jesús nez ro' nis xten Galilee, che bahuiini lo Simón näjza loj Andrés bejtz Simón. Cazäḻreni xquijxhreni lo nis, sa'csi rniaazreni bäjl. ");
INSERT INTO zawNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Dxejc räjp Jesús lojreni: ―Coḻtanajl narä, te gunä cueedxtu bejṉ lacuaa ni guiniaaztu bäjl. ");
INSERT INTO zawNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Lagajc dxejc basa'nreni rexquijxhreni, sanätirenini. ");
INSERT INTO zawNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Dxejc gusaj Jesús sche'n, sas bahuiini loj Jacoob näj Juan, rexi'n Zebedeo. Cayunsa'creni xquijxhreni neṉ xcanuureni. ");
INSERT INTO zawNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Guredxgajcni guiro'preni, dxejcti laareni basa'nreni xtadreni Zebedeo neṉ canuu, näjza rexmosni, sanätireni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bidzujṉtireni guedx Capernaum. Dxejcru sabd, dxej ni rusilajz rexpeṉ Israel, biu' Jesús neṉ guidobäz xten rexpeṉ Israel. Dxejcti baluii Jesús rebejṉ ni tre' ro'c. ");
INSERT INTO zawNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bidxelojni rebejṉ xtiidxni, sa'csi caguluiinireni si'cpac te ni rnibee, xhet si'cdi remastr xten leiidi. ");
INSERT INTO zawNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Neṉ xquidobäzreni yu' te bejṉ yu' te beṉdxab neṉ lastooni. Beṉdxabga guredxa', räjpni: ");
INSERT INTO zawNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Jesús, ni siääd Nazare't, ¿xhicuent riu'lu loonu? ¿La siädgunitlojlu nuunu? Narä numbeälu, luxh nanä luj najclu beṉdxan ni siääd lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Dxejcti gudidxa' Jesús lo beṉdxabga, räjpni lojni: ―Basäuu ro'lu, birii neṉ lastoo niguiire. ");
INSERT INTO zawNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Sas beṉdxabga batienguij niguiiga, luxh cabedxa'ni biriini neṉ lastoo niguiiga. ");
INSERT INTO zawNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bidxejbti guiraareni, canabdiidx loj sa'reni: ―¿Xhi dee? ¿Xhi dzuun nacoobre ruluiini? Niguiire rnibeeni näj rebeṉdxab, luxh ruzoobreni xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Di niaclaa gucbee rebejṉ guideb nez Galilee xhi rujn Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Che biriireni xquiidobäz rexpejṉ Israel, huinä Jesús Jacoob näj Juan rolijz Simón näjza Andrés. ");
INSERT INTO zawNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Luxh xnan suegr Simón naga', yu'ni xliaa. Dxejc räjpreni lo Jesús: ―Cayacxhuuni. ");
INSERT INTO zawNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Dxejcti gubig Jesús lojni, gunaazni ṉaani, guläsnini; lagajc dxejc biriini xliaa. Dxejc gusloj cayunireni. ");
INSERT INTO zawNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Che huääz gubijdx, luxh abiu' guxhijṉ, biädnäreni guiraa rebeṉracxhuu loj Jesús, näjza renani yu' beṉdxab neṉ lastooni. ");
INSERT INTO zawNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Luxh guideb guejdxga bidojp ro' yu'ga. ");
INSERT INTO zawNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Basiajc Jesús xhidajl renani rajc garen-garen yäḻguijdx. Niluxh gulääzani xhidajl beṉdxab, niluxh dini nusaan ninii rebeṉdxabga, sa'csi najnreni chu najcni. ");
INSERT INTO zawNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Che bara yääl, cäjyru bistie Jesús, biriini sääni te laad cadro ruti bejṉ. Ro'c cabejdx-canabni loj Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Dxejcti Simón näj resa'ni huitiilreni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Che bidxälrenini, räjpreni lojni: ―Guiraa rebejṉ caguiillu. ");
INSERT INTO zawNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Dxejc räjp Jesús lojreni: ―Coḻcho' reguejdx ni yu' gajxh, te gusuleä xtidx Dios ro'c. Par ni'cpac biäḻä. ");
INSERT INTO zawNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Dxejcru cuansaj Jesús guideb nez Galilee, caguluiini xtidx Dios neṉ reguidobäz xten rexpejṉ Israel. Gunibeezani birii rebeṉdxab neṉ lastoo xhidajl rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Gubig te beṉracxhuu ni raḻ tiejxhni loj Jesús, bazuxhijbni. Dxejcti räjpni lojni: ―Narä nanä sajc gusiajclu narä palga rlajzlu. ");
INSERT INTO zawNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Balaslajz Jesús beṉracxhuuga, gunaazni ṉaani, räpgajcni: ―Rlazä jiajclu. Biajc ṉaj. ");
INSERT INTO zawNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Cheni guniini scree, biacgajc beṉracxhuuga. ");
INSERT INTO zawNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Dxejcti gulunejz Jesús bejṉga. Per räpxgaani lojni: ");
INSERT INTO zawNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Ahuiire, rutlojdi guiniilu dee. Huiluii tiejxhlu lo bixhojz. Badedgajc lo Dios nani räjp toMoisés gudeed bejṉ lo Dios si'c te seen, te gacbee rebejṉ abiajclu. ");
INSERT INTO zawNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Dxejc sää bejṉga. Sas gusloj cayujyni diidx lo rebejṉ xcuent guiraa nani gujcni. Ni'cni diru niajcdi niu' Jesús nicla tej guejdx. Cansajni te laad cadro ruti bejṉ. Niluxh guiranejz ṟii rebejṉ, siädhuiireni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Che agudejd balti dxej, biusac Jesús neṉ guedx Capernaum. Dxejcti biejn diajg rebejṉ arbäjzni. ");
INSERT INTO zawNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bidopgajc xhidalduxh bejṉ. Gudxaj neṉ yu'. Nicla rolä' di niajḻ nisiujreni. Dxejcti caguluii Jesús xtidx Dios lo rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Dxejcti bidzujṉ tajp bejṉ, nuureni te bejṉ ni digacti guiniib; siädnärenini lo Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Luxh di niajcdi nidzujṉreni cadro suga' Jesús, sa'csi yu' xhidajl bejṉ ro'c. Ni'c baxhalreni yejc yu' nejz cadro sujni. Dxejcru cadro baxhalreni basiäjtreni da' ni naga' beṉracxhuuga lojni. ");
INSERT INTO zawNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Che bahuii Jesús rililajzreni, dxejc räjpni loj beṉrachxhuuga: ―Xi'nä, agubicaj rextojḻlu. ");
INSERT INTO zawNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Sas gaii bejṉ ni ruluii leii ni sobga' ro'c bejnreni xhigab neṉ lastooreni, naareni: ");
INSERT INTO zawNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Xhicuent rnii niguiire scree? Caniyajni Dios; rut rajcdi rudzucaj dojḻ. ¡Diostis rajc rudzucaj dojḻ!” ");
INSERT INTO zawNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Dxejcti gucbegajc Jesús xhi xhigab cayujnreni. Dxejc räjpni lojreni: ―¿Xhicuent rujntu xhigab si'c neṉ lastootu? ");
INSERT INTO zawNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿La guyasiru gäbni loj beṉracxhuure: “Agubicaj rextojḻlu”, o la gäbni: “Huistie, cua' xta'lu, gusaj”? ");
INSERT INTO zawNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Baj ṉaj, te gantu rajc rudzucaj Xi'n Dios, nani gujc Niguii, dojḻ lo guedxliujre, caniä loj beṉracxhuure: ");
INSERT INTO zawNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Lojlu rniä, ¡Huistie, cua' xta'lu, huij rolijzlu! ");
INSERT INTO zawNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Lagajc dxejc huistie beṉracxhuuga, guläzni xta'ni, biriini ro'c nez loj guiraareni. Ni'cni bidxelo guiraareni. Dxejc gulä'preni xpala'n Dios, räjpreni: ―Gajdpacnu guihuii sa' dzuunre. ");
INSERT INTO zawNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Dxejcru gubisac Jesús ro' nis xten Galilee, luxh che bidojp guiraa rebejṉ lojni, baluiini xtidx Dios lojreni. ");
INSERT INTO zawNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Sasaj Jesús che bidxaagni Leví, xi'n Alfeo. Sobga'ni cadro rusquijxni rebejṉ. Dxejc räjp Jesús lojni: ―Gudanajl narä. Sas huisuni, sanajltini Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Dxejc sobga' Jesús cayajwni rolijz Leví. Luxh sobganäj Jesús xhidajl reni rusquijx, näjza rebeṉdojḻ ni di chasanäj leii, näjza rexpejṉpacni, lo mex. Xhidajlreni tre', luxh sanajlreni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Dxejcru rebejṉ ni ruluii leii näj refarisee, che bahuiireni cayaunäjni renani rusquijx näjza rebeṉdojḻ, räjpreni loj rexpejṉpac Jesús: ―¿Xhicuent rbenäj xmastrtu reni rusquijx näj rebeṉdojḻ, luxh raunäjnireni, ränäjnireni? ");
INSERT INTO zawNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Che biejn diajg Jesús xhi caniireni, räjpni lojreni: ―Renani nadip nadaan di guiquiin doctoor, per reni racxhuu rquiin doctoor. Dina niädtedxä rebeṉsa'c, biädtedxä rebeṉdojḻ, te gusiech lajzreni. ");
INSERT INTO zawNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Cagucua'n rexpejṉ Juan näj rexpejṉ refarisee, renani najc rebeṉguidoo loj guedx Israel. Dxejc biääd gaii bejṉ loj Jesús, gunabdiidxreni lojni räjpreni: ―¿Xhicuent cagucua'n rexpejṉ Juan näj rexpejṉ refarisee luxh rexpejṉpaclu di gucua'n? ");
INSERT INTO zawNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Dxejcti räjp Jesús lojreni: ―¿La rucua'n rebejṉ ni rdoṉ chää cadro ru' yäḻruchṉaa che meer suga' bi'n? Che meer suga' bi'n lojreni, direni gucua'n. ");
INSERT INTO zawNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Per sidzujṉ dxej sibicaj bi'n lojreni, dxejc sii sucua'nreni. ");
INSERT INTO zawNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Rut rucuaadi tla' ladcoob loj tla' ladyux, sa'csi ladcoob rxu'nni luxh rutiäjzni ladyuxga, dxejc xhiroobruni räjs. ");
INSERT INTO zawNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Rutza rusäḻdi bin ni gajd guilaj neṉ guidyux ni abigaa. Sa'csi bin ni gajd guilajga sutiäjsni guijdga che guilajni, luxh sinijt binga näjza guijdga. Ni'cni nanab gusäḻni bincoob neṉ guidcoobza. ");
INSERT INTO zawNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Te sabd, dxej ni rusilajz rexpejṉ Israel, sasaj Jesús nez loj reyuya'n. Sas gusloj rexpejṉpacni caläädx doj lo triuu. ");
INSERT INTO zawNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Dxejc räjp refarisee, renani najc beṉguidoo loj guedx Israel, loj Jesús: ―Arniä, ¿xhicuent rujn rexpejṉpaclu dzuun ni di guchaag gunni neṉ dxej ni rusilajznu, ä? ");
INSERT INTO zawNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Dxejcti räjp Jesús lojreni: ―¿La gajdtu goḻ nani bejn toDavid te huält, laani näj resa'ni, ä? Che biäädx xhi gauureni, gulaanreni. ");
INSERT INTO zawNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Biu' David neṉ xyu' Dios cheni guyu' toAbiatar loj Dios. Abiatar sajcru loj rebixhojz ni guyu' neṉ xquidoo rexpejṉ Israel. Dxejc gudajw toDavid reyätxtiil ni dzuub ro'c. Badeedzanini gudajw rebejṉ ni yunäjni. Luxh rebixhojztis rajc rajw yätxtiilga. ");
INSERT INTO zawNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Räjpza Jesús lojreni: ―Dios bejn dxe sabd sa'csi najnni naquiinpac gusilajz bejṉ. Dini niujn sabd te gapda bejṉni. ");
INSERT INTO zawNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ni'cni narä, Xi'n Dios ni gujc Niguii, näjza sabd rnibeä. ");
INSERT INTO zawNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Biu' Jesús stehuält neṉ xquidobäz rexpejṉ Israel. Ro'c yu' te niguii nani nabijdz te ṉaani. ");
INSERT INTO zawNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Niluxh ro'c cagula'tz rebejṉ Jesús don la susiajcni niguiiga sabd, dxej ni rusilajz rexpejṉ Israel, sa'csi rlajzreni cue'creni xquejni loj nani rnibee rexpeṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Dxejc räjp Jesús lo niguii nani nabijdz ṉaani: ―Huistie, guzuj galäiire. ");
INSERT INTO zawNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Dxejcti gunabdidxgajcni loj gaii rebejṉga, räjpni: ―¿La laaca gunni dzunza'c, o la dzunguijdx, sabd, ä? ¿La susḻaani yäḻnabajṉ, o la sugu'tni? Luxh laareni biacdxireni. ");
INSERT INTO zawNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Dxejc nadxe'ch bahuii Jesús lojreni, luxh guc-huin lajzni, sa'csi guc najd lajzreni. Dxejc räjp Jesús loj niguiiga: ―Baslii ṉaalu. Dxejcti basliini ṉaani. Biajctini. ");
INSERT INTO zawNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Dxejcru biunejz refarisee. Guslogajcreni caguchaagreni diidx con reni nadxaag Herodes, te don xho ju'treni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús näjza rexpejṉpacni sääreni ro' nis, luxh xhidajl beṉ Galilee birinajlni. ");
INSERT INTO zawNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Che gojnreni redzunro ni rujn Jesús, xhidajlreni biääd. Yu'reni birii Judea, yu'reni birii guedx Jerusalén, yu'reni birii Idumea, yu'zareni birii nejz stelaad gueu Jordán, biriizareni nez guedx Tiro, näj nez guedx Sidón, biädhuiireni loj Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ni'cni räjp Jesús loj rexpejṉpacni quiilreni te canuu, te na'c gutää rebeṉxhidaalgani. ");
INSERT INTO zawNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Abasiajc Jesús xhidajl beṉracxhuu, ni'cni guiraasi beṉracxhuu caxa't lojni, te caṉrenini te jiajcreni. ");
INSERT INTO zawNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Niluxh che rhuii rebeṉdxab lojni, ruzuxhijbreni lojni. Dxejcti rbedxa'reni räjpreni: ―Luj najclu Xi'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Dxejcti Jesús gudidxa' lojreni te na'c niäjbreni chu najcni. ");
INSERT INTO zawNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Birii Jesús sääni lo te dajne' cadro gurejdxni renani rlajzni cueni. Gubigtireni lojni. ");
INSERT INTO zawNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Dxejcti guleni tzubitio'preni te sanäjreni laani, te guxhaḻnireni chaluiireni xtidx Dios; ");
INSERT INTO zawNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","te ga'preni yäḻrnibee te gusiajcreni beṉracxhuu, te cuääzareni rebeṉdxab. ");
INSERT INTO zawNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Retzubitio'p bejṉ ni gule Jesús najc: Simón, ni gulälajzani Pedr. ");
INSERT INTO zawNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Dxejcti Jacoob con Juan, rexi'n Zebedeo, gulälaj Jesús Boanerges. Con xtiidxnu sälojni bejṉ ni nasesya', si'c guzii. ");
INSERT INTO zawNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Näj Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacoob xi'n Alfeo, Tadeo, Simón, ni di guidxejb rnigajc, ");
INSERT INTO zawNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","näj Judas Iscariot, ni bato' Jesús loj reni rdxechlajz lojni. Sä'tireni rolijz te dade'. ");
INSERT INTO zawNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Dxejc bidopsac rebeṉxhidaalga; nicla niajc niaunäj Jesús rexpejṉpacni. ");
INSERT INTO zawNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Che biejn diajg resa' Jesús dee, biädxhiirenini, sa'csi naareni, yejcni cayajc. ");
INSERT INTO zawNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Rebejṉ ni ruluii leii ni birii guedx Jerusalén bidzujṉza lo Jesús, dxejc räjpreni: ―Beelzebú, nani rnibee rebeṉdxab, yu' neṉ lastoo niguiire. Niluxh nani rnibee rebeṉdxab rudeed yäḻrnibee lo Jesús te cuääni beṉdxab. ");
INSERT INTO zawNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Dxejc gurejdx Jesús rebejṉga, bijyni te cuent ni ruluii lojreni, räjpni: ―¿Xho gurilaagw beṉdxab lagajc sabeṉdxabni? ");
INSERT INTO zawNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Palga rebejṉ xten te yäḻrnibee la'reni, luxh tiḻnäj te cuaani ste cuaaga, di yäḻrnibeega chu xchej. ");
INSERT INTO zawNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Palga te famiḻ rdiḻnäj lagajc sa'ni, di familga chu xchej. ");
INSERT INTO zawNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Palga beṉdxab nani rnibee tiḻnäj lagajc laani, di xcäḻrnibeeni chu xchej, sa'csi ni'c gun luuxni. ");
INSERT INTO zawNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Rut gacdi jiu' rolijz te niguidaan, cuanni xhixhtenni, palga dini gulibxgaani, si'ctis sajc cuanni xhixhtenni. ");
INSERT INTO zawNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Rniliä́pac lojtu guiraa dojḻ näjza yäḻrniyaj xten rebejṉ sajc jia. ");
INSERT INTO zawNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nani guiniyaj Sprit Dxan xten Dios, digacdi guibicaj rextojḻni, anuutisni xtojḻni par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Räjpni si'c sa'csi caniireni yu' beṉdxab neṉ lastooni. ");
INSERT INTO zawNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Dxejcru bidzujṉ xnan Jesús, näj rebetzhuinni. Direni niu', baxhaḻtisreni chu huitejdxni. ");
INSERT INTO zawNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Rebejṉ ni sobga' gabi Jesús räjpreni lojni: ―Xnanlu näj rebejtzlu suga' ro lä', caguiilreni luj. ");
INSERT INTO zawNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Dxejcti räjp Jesús lojreni: ―¿Chu reni'c najc xnanä näj rebetzä? ");
INSERT INTO zawNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Bahuigajcni loj renani sobga' gabini, dxejc räjpni lojreni: ―Redee najc xnanä, rebetzä. ");
INSERT INTO zawNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Chutis ni rujn ni rlajz Dios, ni'c najc betzä, bisianä, näjza xnanä. ");
INSERT INTO zawNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Suga' Jesús ro' nis guslosac caguluiini xtidx Dios, luxh bidojp xhidajl bejṉ cadro suga'ni. Xhidalduxh najcreni, ni'cni biu' Jesús neṉ te canuu ni suga' ro' nisga. Dxejcti gurejni neṉga, biääd guiraa bejṉ bia'ntireni ro' nis. ");
INSERT INTO zawNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Dxejc baluiinireni guiraloj, ganax cuent ni ruluii guniini. Che caguluiini, räjpni lojreni: ");
INSERT INTO zawNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Gucuadiajgtu dee. Guyu' te niguii. Biriini sale'cni binij. ");
INSERT INTO zawNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Che guslojni cabe'cni, yu' lajt biajb binijga cuä' nezyuj. Sas biääd reman xhaguibaa, gudajwreni binijga. ");
INSERT INTO zawNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Stee lajt biajb binijga neṉ guij cadro xheti xhidal yuj. Binijga gulengajcni, sa'csi xheti xhidajl yuj ro'c. ");
INSERT INTO zawNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Dxejc, sa'csi lo jiaa yu' xlobaani, che birii gubijdx, bigoḻni, gubijdztini. ");
INSERT INTO zawNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Stee lajt biajb binijga neṉ yaguejch. Dxejcti biroob reyaguejchga, luxh bejnreni balaa loj binijga, ni'cni gujcni ganax biḻii. ");
INSERT INTO zawNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Per stee lajtga biajb binij lo yusa'c. Gulejn reyäjlga, guroobreni, gucsa'creni. Yu'reni cuaj gaḻbitzuu xob, yu'reni cuaj gayojṉ xob, yu'zareni cuaj tegayuu xob. ");
INSERT INTO zawNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Dxejc räjpni lojreni: ―Chutis ni rlajz guisieed, sucuadiajgni. ");
INSERT INTO zawNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Che asii xhidajl bejṉ, rebejṉ nani suga' gajxh cadro suganäj Jesús guitzubitio'p xpejṉpacni gunabdiidx lo Jesús xhi säloj cuentre. ");
INSERT INTO zawNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Dxejc räjp Jesús: ―Dios abejn gacbeetu te gantu xho najc yäḻxhiga'tz xten xcäḻrnibee Dios nani najc xhiga'tz ṉajli. Niluxh lo ste'ca bejṉ con cuenttis rniä guiraa recosre, ");
INSERT INTO zawNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","te mase cahuiireni direni gumbee, te mase cayiejn diajgreni, direni gacbee. Scree gacni, te na'c gusiejch lajzreni, te na'c guibicaj xtojḻreni. ");
INSERT INTO zawNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Räjpzani lojreni: ―¿La ditu gacbee cuentre? ¿Xhocha gacbeetu xhidajlru cuent? ");
INSERT INTO zawNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Niguiire nani sale'c binij najc si'c te nani ruluii xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yu' bejṉ ni najc si'c binij ni biajb cuä' nezyuj: riejn diajgreni xtidx Dios nani ruluii bejṉ. Dxejc che jiejn diajgreni xtidx Dios, riääd Satanás rbägajcni xtidx Dios ni yu' neṉ lastooreni. ");
INSERT INTO zawNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yu'za rebejṉ ni najc si'c binij ni biajb neṉ reguij, renani che jiejn diajgreni xtidx Dios, rbaa lajzreni rca'reni diidxga. ");
INSERT INTO zawNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Niluxh direni nisiudzu'tz, sa'csi guxii huilii lajzreni. Che rdejdreni trabajw o che rusacsí bejṉreni xcuent xtidx Dios, rusaanreni xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yu'zareni najc si'c binij ni biajb neṉ yaguejch, riejn diajgreni xtidx Dios, ");
INSERT INTO zawNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","dxejc che ru'rureni yärsia' xcuent recos guedxliujre, rsia' lajzreni ga'preni meel, rlajzreni ga'prureni guiraloj recos, dxejc riu' redee neṉ lastooreni, rusäuuni lo xtidx Dios, xlia'si biejn diajgreni xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Yu'za bejṉ ni riejn diajgreni xtidx Dios, rlii lajzreni diidxga, xhet xlia'ti biejn diajgreni xtidx Dios. Najcreni si'c binij ni biajb loj yusa'c. Yu' rebejṉ ni najc si'c nani cuaj gaḻbitzuu xob lojni, yu'za rebejṉ ni najc si'c nani cuaj gayojṉ xob lojni, yu'za rebejṉ ni najc si'c nani cuaj tegayuu xob lojni. ");
INSERT INTO zawNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Räjpza Jesús lojreni: ―¿La riädnätu te bajl te suuni dejtz te alm, o neṉ te loon, ä? ¿La xhet nanabdi suuni jiaa te guzanijni, ä? ");
INSERT INTO zawNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Xhet yuchetzu'tzdi ni di guidzujṉ dxej sisäbdiidx. Xhetiza xhicos naga'tztis. Naga'tzni ṉaj, niluxh sidzujṉ dxej sule'ni. ");
INSERT INTO zawNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Pal yu' chu rlajz guisieed, sucuadiajgni. ");
INSERT INTO zawNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Räjpza Jesús lojreni: ―Coḻyunxgaa xhigab rediidx ni riejn diajgtu. Nani rusäḻtu loj xhigabtu, ni'cza guniidx Dios xca'tu, luxh sisiojbru yejc ni xca'tu. ");
INSERT INTO zawNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Renani rajp che'n yäḻnajn, lojreni sudeedru Dios yälnajn. Luxh renani xhetru rusäḻdi loj xhigabreni, sudzucaj Dios yäḻnajn nani rajpreni. ");
INSERT INTO zawNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Guniiza Jesús lojreni: ―Yäḻrnibee xten Dios najc si'c rsiajc te niguii che rbe'cni binij lo yuj, ");
INSERT INTO zawNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","dxejc yääl riguesni, rdxee ristieni, dxejcti rliejn binijga, luxh di niguiiga gan xho ṟoobni. ");
INSERT INTO zawNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Acanajn yujga rajc binij lojni. Galoo ṟii cuane'ga, sas ṟii doj lojni. Dxejcru rdxaj bejdze' neṉ dojga. ");
INSERT INTO zawNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Dxejcti che aguyajl bedze'ga, ruxhaḻni chu ritiuugni, sa'csi abidzujṉ dxej ni guidojpni. ");
INSERT INTO zawNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Räjpza Jesús: ―¿Xhini'c najc si'c najc xcäḻrnibee Dios? ¿Xhi te cuent guiniinu te guiluiinuni? ");
INSERT INTO zawNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Si'c te bedz muxhtas ni rbej loyuj, si'c najcni. Bedz muxhtas najcni bedz bäze'ru loj guiralii bedze' ni yu' loj guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Dxejc che agurejni, ṟoobni, rajcni yagroru loj recuaan. Dxejcti ṟoob rexajcwni te rajc rujn reman xhaguibaa xpitiääzni neṉ xpaḻaani. ");
INSERT INTO zawNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Si'c ruluii Jesús rebejṉ xtidx Dios guniini xhidal cuent sa' redee, si'ctis ni rajc racbeereni. ");
INSERT INTO zawNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Con recuent ni ruluiitis gunii Jesús lojreni. Niluxh lo rexpejṉpacni basule'ni guiraa recuentre. ");
INSERT INTO zawNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lagajc gudxejga räjpni loj rexpejṉpacni: ―Coḻcho', chonnu stelaad nis xten Galilee. ");
INSERT INTO zawNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Basa'ntireni rebejṉ, sanätireni Jesús neṉ canuu cadro sobgajcni. Dxejcti sgaii canuu sanajlni. ");
INSERT INTO zawNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Chela gubi' te beduxh, gusloj cayu' nis neṉ canuuga. Cadxaj canuuga nis. ");
INSERT INTO zawNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Nagayejs Jesús dejtz canuuga, nagayejsni. Bacuäänreni Jesús, räpgajcreni lojni: ―Dad mastr, ¿la dilu jiu siääznu neṉ nis, ä? ");
INSERT INTO zawNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Dxejc huistie Jesús, gudidxa'ni lo bejga, räjpzani lo nis: ―Guredxi. Guläzgajc bej, biacdxini. ");
INSERT INTO zawNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Räjp Jesús loj rexpejṉpacni: ―¿Xhicuent cadxebduxhtu? ¿La ditu chalilajz xtidxä, ä? ");
INSERT INTO zawNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Luxh laareni bidxelojreni, räjpreni loj sa'reni: ―¿Chucha dee ni rnibee bej con nis, luxh ruzoobreni xtiidxni? ");
INSERT INTO zawNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Bidzujṉtireni stelaad ro' nisga, lo yuj xten Gadara. ");
INSERT INTO zawNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Si'ctis ni birii Jesús neṉ canuu, biädgajc te niguii lojni ni birii neṉ rebiliää cadro rga'tz beṉgut. Yu' beṉdxab neṉ lastoo niguiiga. ");
INSERT INTO zawNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Rbäjzni neṉ rebiliääga luxh rut rajcdi rucuaduuni, nicla con cadeṉguiib. ");
INSERT INTO zawNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Xhidajl huält agacbacuaduureni ni', ṉaa niguiiga con cadeṉguiib, luxh litis batiuugni recadeṉguiibga, rut rajcdi rusiacdxini. ");
INSERT INTO zawNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Si'ctis canzajni, dxej, yääl. Rbedxa'ni neṉ redajn, neṉ rebiliää, luxh cagutiuugni tiejxhni con reguij. ");
INSERT INTO zawNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Che bahuiini loj Jesús zijtru, baxuṉni huichaglojni Jesús, bazuxhijbni lojni. ");
INSERT INTO zawNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Dxejcti rbedxaduxhni, räjpni: ―¿Xhicuent siäädlu loä, Jesús, Xi'n Dios ni yu' jiaro? Rniabä lojlu nez loj Dios na'c gusacsílu narä. ");
INSERT INTO zawNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Sa'csi agac cayäjb Jesús lojni: ―Luj, beṉdxab, birii neṉ lastoo niguiiga. ");
INSERT INTO zawNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Dxejcti gunabdiidx Jesús räjpni: ―¿Chu laalu? Dxejc räjpni: ―Narä laä Legión, nani säloj xhidalro, sa'csi xhidajl najcnu. ");
INSERT INTO zawNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Sanuutis canabni lo Jesús na'c guxhaḻni rebeṉdxabga ste'ca guejdx. ");
INSERT INTO zawNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ro'c tre' xhidalduxh cuch cuä' dane'ga, cayajwreni. ");
INSERT INTO zawNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Dxejc gunab rebeṉdxabga loj Jesús, räjpreni: ―Baxhaḻ nuure loj recuchre te jiu'nu neṉ lastooreni. ");
INSERT INTO zawNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Dxejcti basaan Jesúsreni. Biriiti rebeṉdxabga neṉ niguiiga, dxejc biu'reni neṉ lastoo recuchga. Yu' si'cti tiop miḻ cuch ro'c. Baxuṉ recuchga, dxejc biroḻreni ro' guilaj, bitejbreni neṉ nis, gujttireni neṉ nisga. ");
INSERT INTO zawNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Renani cayajp recuchga baxuṉreni, huiyeiireni diidxga neṉ guejdx, näjza loniaa. Dxejc biääd bejṉ biädhuii nani gujc ro'c. ");
INSERT INTO zawNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Che bidzujṉreni cadro suga' Jesús, bahuiireni loj niguii nani guyu' rebeṉdxabga neṉ lastooni. Sobga'ni ro'c, najcwni xhajbni luxh nasa'c yejcni. Niguiire najc nani guyu' beṉdxab ni laa Legión neṉ lastooni. Bidxejbti rebejṉ nani bahuii lojni. ");
INSERT INTO zawNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Dxejcru rebejṉ ni bahuii xhi gujc ro', huiyeiireni diidx xho guzajc niguiire nani guyu' beṉdxab neṉni galoo, näjza nani guzajc recuch. ");
INSERT INTO zawNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Dxejc gusloj canabreni loj Jesús jiunejzni. ");
INSERT INTO zawNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Che biu' Jesús neṉ canuu, niguii nani guyu' beṉdxab neṉ lastooni gunabni loj Jesús, räjpni: ―Huinä narä. ");
INSERT INTO zawNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Per di Jesús nusaan nijni. Räjp Jesús lojni: ―Huij rolijzlu, lo resa'lu. Huiyeii diidx lojreni xho bennäj Dadlu, näjza xho balaslajzni luj. ");
INSERT INTO zawNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Sä'ti niguiiga, gusloj cayujyni diidx neṉ reguejdx xten Decápolis xho bennäj Jesúsni. Guiraa rebejṉ bidxeloj. ");
INSERT INTO zawNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Che bidzuṉsac Jesús stelaad ro' nisga neṉ canuu, bidzujṉ xhidalduxh bejṉ cadro suga'ni. Bia'nti Jesús ro' nisga. ");
INSERT INTO zawNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Dxejcru biääd te niguii nani laa Jairo, ni rnibee neṉ xquidobäz rexpeṉ Israel. Che bahuiini loj Jesús, bazuxhijbni lojni. ");
INSERT INTO zawNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Canabpacni lojni, räjpni: ―Xindxapä'ä acayejt. Gudaa, guzujlu ṉaalu yejcni, te jiajcni, te guibajṉni. ");
INSERT INTO zawNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Sanäti Jesús bejṉga. Xhidajl bejṉ sanajlni, luxh cagutäärenini. ");
INSERT INTO zawNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Loj rebeṉxhidaalga yu' te gunaa ni agujc tzubitio'p ijz racxhuuni yäḻguidxbäii. ");
INSERT INTO zawNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Agudedduxhni trabajw, abahuii xhidajl doctoorni. Xlia'si abanijtni guiraa nani rajpni, luxh xhet racnäjdini, alga rxuuruni. ");
INSERT INTO zawNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Sa'csi biejn diajgni xhini'c canii rebejṉ xcuent Jesús, gubig gunaaga nez dejtz Jesús, guideb neṉ rebejṉ, bahuaḻni xhajb Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Cayujnni xhigab, naani: “Palga narä faḻä xhajbtisni, siacä.” ");
INSERT INTO zawNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Lagajc dxejc guläjz caxe' xtiejnni, gucbeeza tiejxhni abirii xcäḻracxhuuni. ");
INSERT INTO zawNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Gucbegajc Jesús yu' chu abasiajcni. Gubiregajcni neṉ rebeṉxhidaalga, räjpni: ―¿Chuni'c bahuaḻ xhabä? ");
INSERT INTO zawNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Dxejcru räjp rexpejṉpacni lojni: ―Rhuiilu beṉxhidaal cagutäälu, luxh naalu: “¿Chuni'c bahuaḻ xhabä?” ");
INSERT INTO zawNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Sas cahuii Jesús nez ree, nez rec, te fiini loj nani bahuaḻni. ");
INSERT INTO zawNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Dxejc bidxejb gunaare, racsejsni, sa'csi gucbeeni xhini'c gujcni. Dxejc biäädni, bazuxhijbni loj Jesús, räbliini loj Jesús guira'ti ni bejnni. ");
INSERT INTO zawNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Dxejc räjp Jesús lojni: ―Xindxa'pä, abiajclu sa'csi huililajzlu. Gulecdxi lajzlu, huij rolijzlu, abiajc xcäḻracxhuulu. ");
INSERT INTO zawNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Canisijc Jesús si'c che bidzujṉ renani birii rolijz dade' ni rnibee neṉ xquidobäz rexpejṉ Israel. Räjpreni: ―Agujt xindxape'lu. ¿Xhicuent rusieedrulu Dad mastr? ");
INSERT INTO zawNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Dxejc che biejn diajg Jesús nani caniireni, räjpni lo dade'ga: ―Na'c guidxejblu. Bililajztis. ");
INSERT INTO zawNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Luxh dini nusaanru nij chu ninäni, Pedrtis näj Jacoob näjza Juan bejtzni. ");
INSERT INTO zawNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Che bidzujṉni rolijz dade'ga, bahuii Jesús biejy ni cayujn rebejṉ ni rbedxa' roon. ");
INSERT INTO zawNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Biu'tini räjpni: ―¿Xhicuent rujntu si'c? Gajd dxape're guet. Nagayejssini. ");
INSERT INTO zawNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Alga baxhiznäjrenini. Dxejc gunibee Jesús birii guiraa rebejṉga. Dxejcti huinäni xcuzajn dxape'ga con renani sanäni. Biu'reni cadro naga' dxape're. ");
INSERT INTO zawNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Gunaazni ṉaa dxape'ga, dxejc räjpni: ―Talita cumi ―nani säloj con xtiidxnu: Dxape', lojlu rniä, huistie. ");
INSERT INTO zawNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Dxejcti huistiegajc dxape'. Tzubitio'p ijz yu' dxape'ga. Bidxeloduxh rebejṉ ni bahuii guläs Jesús dxape'ga. ");
INSERT INTO zawNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Dxejc balijdx Jesús reni te rut lojdi chaye'tzreni xhini'c gujc. Gunibegajcni gudeedreni xhi gauu dxape'ga. ");
INSERT INTO zawNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Dxejcru birii Jesús ro'c, huijni lajdxni, sanäzani rexpejṉpacni. ");
INSERT INTO zawNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Che bidzujṉ sabd, dxej nani rusilajz rexpejṉ Israel, gusloj caguluiini neṉ xquidobäz rexpejṉ Israel. Bidxeloj xhidajl bejṉ nani biejn diajg rextiidxni, räjpreni: ―¿Caro bisieed niguiire guiraa recosre? ¿Xhi yäḻnajnre cua'ni ni'c rajc rujnni rextzunduxh Dios con ṉaani? ");
INSERT INTO zawNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿La xhet laadi carpinteer, xi'n Marii, bejtz Jacoob, näj José, näj Judas, näjza Simón dee, ä? ¿La xhet reedi rbäjz rebisianhuinni? Luxh bidxechlajzreni lojni. ");
INSERT INTO zawNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Dxejc räjp Jesús lojreni: ―Catis rinälajzreni te ni rnii xtidx Dios. Lajdxtisni, lagajc loj resa'ni, rolijztisni, ro'c rut rinälajzdini. ");
INSERT INTO zawNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Luxh di niajcdi niujn Jesús xhidajl milaagwr ro'c. Tiopchoṉtis beṉracxhuu basiajcni, bazujni ṉaani yejcreni. ");
INSERT INTO zawNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Bidxelo Jesús sa'csi di lajzreni nilii. Caguluiitini neṉ guiraa reguejdxe' ni ria'n gajxh nejzga. ");
INSERT INTO zawNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Dxejcru gurejdxni guitzubitio'p xpejṉpacni. Gusloj caguxhaḻni tiopgajreni; badeedzani yäḻrnibee lojreni te guinibeereni loj rebeṉdxab. ");
INSERT INTO zawNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Gunibeeni xhet chanädireni lo nejz, ganaxhtis te yajg te sanäjreni. Di nungäjḻ chanäreni nicla bisiuud, nicla yätxtiil, niclaza meel neṉ dobdäjl. ");
INSERT INTO zawNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nungäjḻza xcaj gura'ch ni'reni, nägajc ga'preni tejtis gamangw, xhet tio'pdini. ");
INSERT INTO zawNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Dxejcti räjpni lojreni: ―Cadrotis jiu'tu neṉ te guejdx, coḻjia'n neṉ tejtis yu' guiraa redxej ni chutu guejdxga. ");
INSERT INTO zawNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Palga yu' te guejdx cadro direni gusaan jiu'tu luxh di rlajzreni cuadiajgreni diidx ni sanätu, coḻṟii guejdxga, coḻcuijb guxhuj ni'tu si'c te seen te gacbeereni xhet laadi bejnreni. Rniliä́pac lojtu, guxiiru trabajw ted rebeṉ Sodoma näj rebeṉ Gomorra quela rebejṉ ni yu' guejdx cadro direni gusaan jiu'tu. ");
INSERT INTO zawNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Dxejc biriireni, sääreni. Cayäbgajcreni nanabpac gusiejch lajz rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Gulääzareni xhidajl beṉdxab dxejcti gudääbreni se't yejc xhidajl beṉracxhuu, luxh biajcreni. ");
INSERT INTO zawNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Herodes najc nani rnibee dxejc. Biejn diajgni xpala'n Jesús, sa'csi guiralii rebejṉ calä'p xpala'nni. Dxejc räjp Herodes: ―Juan nani rutiobnis ahuäjs loj rebeṉgut, ni'c rajc rujnni remilagwre. ");
INSERT INTO zawNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Sgaii bejṉ räjp: ―Laa Elías ni gunii xtidx Diosni. Sgaiireni räjp: ―Laa te bejṉ ni rnii xtidx Dios, o sa' te rebejṉ ni gunii xtidx Dios agujc xchero. ");
INSERT INTO zawNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Che biejn diajg Herodes si'c, räjpni: ―Laa Juan dee, nani gunibeä biru' yejcni, luxh ṉaj agubaṉsacni loj rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Sa'csi lagajc Herodes gunibee biga' Juan, dxejc bacuaduurenini con cadeṉguiib neṉ latzguiib, xcäḻnasa'c Herodías. Herodías gujc chääl Lib, bejtz Herodes, dxejc cua' Herodes gunaaga si'c chäälni. ");
INSERT INTO zawNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Räjp Juan loj Herodes: ―Xhet laadi rbäznäjlu chääl bejtzlu. ");
INSERT INTO zawNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ni'cni rdxechlajz Herodías loj Juan, luxh rlajzni ju'tnini, luxh di niajcdini ");
INSERT INTO zawNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","sa'csi rdxejb Herodes Juan, sa'csi najnni beṉsa'c, beṉdxan najc Juan, ni'cni dini nusaan niujn Herodías latsiajni. Mase dini gacbesa'c ni rnii Juan, rucuadiagsa'cni xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Niluxh guyu' xmood Herodías. Che gojḻ laj Herodes, bayaanni rexpejṉni ni rnibee, näjza rebejṉ nani sajc nez región Galilee. ");
INSERT INTO zawNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Dxejcti biu' xindxa'p Herodías cadro cayajwreni, baya'ni nez lojreni. Bidxaglazduxh Herodes näjza rexpioozni baya' gunaaga, xindxa'p Herodías. Dxejc räjp Herodes lo gunaaga: ―Gunab ni rlajztislu loä, narä sunidxäni. ");
INSERT INTO zawNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Dxejcru räplii Herodes lojni: ―Sunidxä xhitis ni guiniablu. Mase gala' yuj ni rnibeä. ");
INSERT INTO zawNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Biriitini neṉ yu', huiye'tzni loj xnanni, räjpni: ―¿Xhini'c guiniabä lojni? Dxejc räjp xnanni lojni: ―Gunab yejc Juan ni rutiobnis lojni. ");
INSERT INTO zawNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Huigajcni loj ṟeii, sas gunabni lojni, räjpni: ―Rlazä gunidxgajclu loä yejc Juan ni rutiobnis. Neṉ te pla't baniidx yejcni. ");
INSERT INTO zawNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Dxejcti guc-huinduxh lajz Herodes, sa'csi abadeedni xtiidxni lojni, luxh sa'csi abiejn diajg renani sobganäjni lo xmexni, ni'c dipac rlajzni nudxojnni nani gunab gunaaga lojni. ");
INSERT INTO zawNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Baxhaḻgajc ṟeii te soldaad ni rcanäj ro'c, baxhaḻnini, te chaxiini yejc Juan. ");
INSERT INTO zawNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ni'c huij, dxejcti bagu'tni Juan neṉ latzguiib, biädnätini yejc Juan neṉ te pla't. Badeedtinini loj gunaaga. Dxejcti gunaaga badeednini loj xnanni. ");
INSERT INTO zawNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Che biejn diajg rexpejṉpac Juan si'c, biädläsreni togoolga. Dxejcti bacua'tzrenini neṉ te baa. ");
INSERT INTO zawNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Che gubi' renani baxhaḻ Jesús, bijreni diidx guiraa ni bejnreni näjza ni baluiireni. ");
INSERT INTO zawNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Dxejc räjp Jesús lojreni: ―Coḻtaa, xtebnu choṉnu cadro rut rbäjzdi, guisilaaznu tudxe'n. Räjp Jesús si'c sa'csi yu' xhidajl bejṉ ni sää, ni siääd, nicla gaḻ gauureni. ");
INSERT INTO zawNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Dxejcti sääreni neṉ te canuu cadro rut rbäjzdi. ");
INSERT INTO zawNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bahuii xhidajl bejṉ sääreni, biembeereni Jesús. Dxejc xhidajlreni huini' ro'c, xhidajl guejdx biriireni, ganidreni bidzujṉreni loj Jesús näjza rexpejṉpacni, dxejcti bidojpreni lojni. ");
INSERT INTO zawNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Birii Jesús neṉ canuu, bahuiini loj beṉxhidaalga. Dxejc balazlajznireni, sa'csi najcreni si'c rexiil ni ruti baxtoor xtenreni. Dxejc gusloj caguluiinireni guiraloj. ");
INSERT INTO zawNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Che gojḻ gudxej, gubig rexpejṉpacni lojni, räjpreni: ―Rut rbäjzdi ree, luxh agudxej ṉaj. ");
INSERT INTO zawNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Baxhaḻ rebejṉ te chääreni lo reguejdx, näjza reṟench, te chasiireni yätxtiil gauureni sa'csi xheti xhi gauureni ree. ");
INSERT INTO zawNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Dxejc räjp Jesús lojreni: ―La'tu coḻdeed xhi gauureni. Dxejc räjpreni loj Jesús: ―¿Xhixh sajl tiop gayuu meel yätxtiil chosiinu gauu guiraa rebeṉxhidajlre? ");
INSERT INTO zawNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Dxejcti räjp Jesús lojreni: ―¿Bal yätxtiil rajptu? Coḻchahuii. Che gojnreni balni dxejc räjpreni: ―Gaii yätxtiil, näjza tiop bäjl. ");
INSERT INTO zawNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Dxejcru gunibee Jesús räjpreni loj guiraa rebejṉ: ―Coḻcuej xcua-xcuaatu loj guixhaya'. ");
INSERT INTO zawNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Sas gurej xcua-xcuaareni. Yu' lajt gurej tegayuureni, yu' lajt gurej garol gayuureni. ");
INSERT INTO zawNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Dxejcti cua' Jesús guigaii yätxtiilga näjza guiro'p bäjlga, bahuiini xhaguibaa, badeedni xquixhtios loj Dios. Dxejcti gula'ni yätxtiil näjza guiro'p bäjl, badeednini loj rexpejṉpacni te badeedrenini loj guiraa rebeṉxhidaalga. ");
INSERT INTO zawNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Dxejc gudajw guiraareni, gudxaj xque'reni. ");
INSERT INTO zawNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Dxejcru batojpreni tzubitiop dxijm̲ guidxadoo yätxtiil näjza bäjl ni bia'n. ");
INSERT INTO zawNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Luxh loj guiraa rebejṉ ni gudajw yu' si'cti gaii mil niguii. ");
INSERT INTO zawNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Gunibee Jesús jiu' rexpejṉpacni neṉ canuu, chägajcreni Betsaida, ni tre' dejtz nis stelaad, laḻni cagusadiidxni rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Che gulujx basadiidxnireni, sääni neṉ redane', sanabni lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Cheni acayu' guxhijṉ, yu' rexpejṉpacni neṉ canuu galäii nis laḻ ni suga' Jesús xtebni ro' nis. ");
INSERT INTO zawNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Dxejcti bahuii Jesús abadxajgreni cagusajreni xcanuureni, sa'csi säbduxh bej. Bejga rulanaareni nez dejtzreni stehuält. Dxejcru che acara yääl, gusaj Jesús loj nis, huijni cadro sasajreni, rlajzni ninijdni lojreni. ");
INSERT INTO zawNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Dxejc che bahuiireni sasaj Jesús loj nis, naareni pet te beṉmalni, ni'c guredxa'reni. ");
INSERT INTO zawNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Guiraareni bahuiireni lojni, bidxebduxhreni. Sas gunigajcni lojreni, räjpni: ―Coḻsutijp lajztu. Laa naräni. Na'c guidxejbtu. ");
INSERT INTO zawNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Dxejcti huä'p Jesús neṉ canuu cadro yu'reni. Lagajc dxejc biacdxi bej, luxh laareni bidxeloduxhreni, ");
INSERT INTO zawNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","sa'csi direni niacbee xhini'c bennäj Jesús reyätxtiil. Guc najd lajzreni, ni'c direni niacbee. ");
INSERT INTO zawNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Gudejdreni lo nis, bidzujṉreni lo yuj xten Genesare't. Ro'c bacuaduureni canuu ro' nis. ");
INSERT INTO zawNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Che biriireni neṉ canuu, biembegajc rebejṉ Jesús, ");
INSERT INTO zawNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","dxejcti birii rebejṉ guideb nejzga. Guslojti siädnäreni beṉracxhuu loj Jesús, naga' rebeṉracxhuuga lo da'. Cadrotis riejn diajgreni yu' Jesús riädnäreni rebeṉracxhuu. ");
INSERT INTO zawNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Niluxh cadrotis rij Jesús, neṉ reguedxbäz, neṉ reguedxro, näjza loj reṟench, rguixhreni rebeṉracxhuu cadro rajc guii. Dxejcti rniabreni loj Jesús te gac caanreni xhajbni, niluxh biajc guiralii renani gudajn xhajb Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Dxejcti refarisee, renani najc beṉguidoo loj guedx Israel, näjza gaii rebejṉ ni ruluii leii, renani birii Jerusalén, bidojpreni loj Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bahuiireni cayajw gaii rexpejṉpac Jesús, luxh canii rebejṉ nacdxuudx naareni (dee säloj direni quiib ṉaareni si'ctis ni rdiib ṉaa rebeṉ lajdxreni). Ni'cni guniyajreni rexpejṉpac Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Guiraa rebejṉ xten Israel, näjza refarisee, sasanäj nani baluii rebeṉgool ni yu' guedx Israelreni. Direni gauu palga direni quiib ṉaareni balti huält. ");
INSERT INTO zawNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Che rbi'reni rijreni lo guii, rguibsa'creni ṉaareni, lojreni, ni'reni, dxejcti rajc rajwreni. Niluxh guyu' xhidajl costumbr ni sasanäjrureni, luxh yu' mood rguiibreni rextrastreni näjza rexplooreni, näjza rextrastguiibreni, näjza rexloonreni.) ");
INSERT INTO zawNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Dxejc gunabdiidx refarisee näjza rebejṉ ni ruluii leii loj Jesús, räjpreni: ―¿Xhicuent di rexpejṉpaclu gun si'cni baluii rebeṉgool, niluxh rajwreni guideb nacdxuudx ṉaareni? ");
INSERT INTO zawNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Dxejcti gunii Jesús lojreni räjpni: ―¡Beṉ guijdx! Laaca gunii Isaías xcuenttu che guniini xtidx Dios. Scree cajni loj guijtz: Guejdxre sanälajz narä con rextiidxni, niluxh lastooreni zitro suga' loä. ");
INSERT INTO zawNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Xlia'si ruzuxhijbreni, sa'csi direni chanälajz narä. Ruluiireni si'c xtiidxpac Dios nani rnii rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Rusa'ntu xleii Dios, sasanädzu'tztu costumbr nani baluii rebeṉgool. Rdibsa'c rexploortu, rextrasttu, luxh rujnzatu xhidajlru cos sa' redee. ");
INSERT INTO zawNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Räjpza Jesús lojreni: ―Rusa'ntu xtidx Dios te risanäjtu recostumbr xtentu. ");
INSERT INTO zawNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Sa'csi räjp Moisés: “Huinälajz xtadlu con xnanlu.” Räjpzani: “Suju'tpactu nani gudzubde yejc xtadni o yejc xnanni.” ");
INSERT INTO zawNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Niluxh la'tu rniitu sajc gäb bejṉ loj xtadni o loj xnanni: “Dina gapä xhi cojn gacnää́lu” (nani säloj, abadedä guira'ti loj Dios). ");
INSERT INTO zawNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","La'tu ditu gusaan gunru bejṉ por xtadni nicla por xnanni. ");
INSERT INTO zawNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Si'c rbälaztu xtidx Dios, te sasanäjtu recostumbr nani ruluiitu, luxh xhidajl cos sa' dee rujntu. ");
INSERT INTO zawNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Gurejdx Jesús guiraa rebejṉ, dxejc räjpni loj guiraareni: ―Colcuadiajg, coḻyacbee xtidxä. ");
INSERT INTO zawNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Rexhicos yäḻrajw ni rajw bejṉ, dini gunijt bejṉga, rediidx ni ṟii neṉ lastoo bejṉ, näjza recos ni rujn bejṉ, ni'c runijt bejṉga. ");
INSERT INTO zawNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Pal yu' chu rlajz guisieed, sucuadiajgni. ");
INSERT INTO zawNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Dxejcti gula'reni loj rebeṉxhidaal, biu'reni neṉ yu'. Dxejc gunabdiidx rexpejṉpacni loj Jesús xhi säloj cuent ni guniini. ");
INSERT INTO zawNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Basejc Jesús diidx lojreni, räjpni: ―¿La näjza la'tu xheti xcäriejntu? ¿La di'tu gacbee xhitis yäḻrajw nani riu' neṉ bejṉ digacdi gunijtni lastoo bejṉ, ä? ");
INSERT INTO zawNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Sa'csi dini jiu' neṉ lastooni; riu'ni xque'ni, rdejdtini. Si'c guniini te baluiini guira'ti xhicos najc naya. ");
INSERT INTO zawNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Dxejc räjpni: ―Rediidx ni ṟii neṉ lastoo bejṉ, näjza recos ni rujn bejṉ, ni'c sii runijt lastoo bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sa'csi neṉ lastoo rebejṉ ṟii rexhigabguijdx, näjza yäḻresnäj chääl sa'ni, yäḻresnäj ni xhet najcdi chäälni, yäḻrugu't sa'ni, ");
INSERT INTO zawNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yäḻgubaan, yäḻrlajzni ga'pni xhixhten bejṉ, yäḻlatsiaj, yäḻrusgueeni, yäḻ xheti xtujy lojni, yäḻrdxechlajz, yäḻrudzubde sa'ni, yäḻnayechlajzni, yäḻguyalajz. ");
INSERT INTO zawNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Guiraa reyäḻlatsiajre neṉ lastoo bejṉ ṟiireni, luxh reni'csi runijt bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Dxejc biriini ro'c, sääni nez guedx Tiro näjza nez Sidón. Ro'c bia'nni neṉ te yu' sa'csi di rlajzni niacbee rebejṉ caro yu'ni, niluxh di niajcdi niuxhiga'tztisni. ");
INSERT INTO zawNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Biengajc diajg te gunaa ro'c yu' Jesús. Xindxape' gunaaga yu' beṉdxab neṉ lastooni. Bidzujṉ gunaaga, bazuxhijbni lo Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Gunaaga rnii griegw, najcni beṉ Sirofenicia. Gunabni lojni guinibeeni guirii beṉdxabga neṉ lastoo xi'nni. ");
INSERT INTO zawNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Dxejc räjp Jesús lojni: ―Basaan gauxgaa rebiuux, sa'csi xhet laati gudzucajni xcuxtiil rebiuux te gudeednini loj rebä'cw. ");
INSERT INTO zawNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Dxejc gunii gunaaga, räjpni loj Jesús: ―Yo, Dad. Näjza rebäcue' ni suga' neṉ mex rajw nani rtejb ro' rebiuux. ");
INSERT INTO zawNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Dxejcti räjp Jesús lojni: ―Laaca rniliilu. Huij rolijzlu. Abirii beṉdxab neṉ lastoo xindxape'lu. ");
INSERT INTO zawNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Luxh che bidzujṉ gunaare rolijzni, a dxape' naga' lo da'. Gucbegajc gunaaga abirii beṉdxab neṉ lastoo dxape'ga. ");
INSERT INTO zawNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Dxejcru birii Jesús stehuält lo rexyuj guedx Tiro, gudejdni nez Sidón näjza rexyuj Decápolis. Bidzujṉtini ro' nis xten Galilee. ");
INSERT INTO zawNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Biädnä gaii bejṉ te niguii ni nacua't diajgni lo Jesús. Digacdiza guinisa'c niguiiga. Biädnabreni lo Jesús nusujni ṉaani yejc niguiiga. ");
INSERT INTO zawNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Dxejcti badzucajnini loj rebejṉ. Baquitzgajcni rebicueṉaani neṉ diajgni, dxejcru batiobxhejnni, gudajntini lujdxni. ");
INSERT INTO zawNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Bahuiini xhaguibaa, bazaa lajzni, dxejc räjpni: ―¡Efata! ―nani säloj bixal. ");
INSERT INTO zawNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Dxejcru bixalgajc rediajgni, gubaṉgajc lujdxni, gunisa'cni. ");
INSERT INTO zawNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Dxejcti gunibee Jesús rutlojdi gäbreni, per che räjpni lojreni si'c, laareni batie'chrureni diidxga. ");
INSERT INTO zawNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Rdxeloduxhreni, räjpreni: ―Guira'ti laaca rujnni; ruxhalni diajg rediagcua't, luxh rusniini regop. ");
INSERT INTO zawNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Neṉ redxejga bidojp xhidalro bejṉ, luxh xheti xhigauureni. Dxejc gurejdx Jesús rexpejṉpacni ni rinajlni, räjpni lojreni: ");
INSERT INTO zawNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Rulazlazä rebejṉre, sa'csi ṉaj rajc choṉ dxej tre'reni loä, luxh xhet yu'di gauureni. ");
INSERT INTO zawNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Niluxh palga guxhaḻäreni rolijzreni, xliajzreni, sidxajgreni lo nejz; sa'csi yu' renani zijtru siäädreni. ");
INSERT INTO zawNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Dxejcru räjp rexpejṉpacni lojni: ―¿Caro chaca'nu yätxtiil te cha xque' rebejṉre ree, cadro rut rbäjzdi? ");
INSERT INTO zawNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Sas gunabdiidx Jesús lojreni: ―¿Bal yätxtiil rajptu? Dxejcru räjpreni: ―Gajdztisni. ");
INSERT INTO zawNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Gunibee Jesús gurej rebeṉxhidaalga loj yuj. Sas cua'ni guigajdx yätxtiilga, badeedni xquixhtios lo Dios, guḻa'ni reyätxtiilga. Dxejc badeednini loj rexpejṉpacni te guteedrenini loj rebeṉxhidaal. Bateedtireni yätxtiilga lo rebeṉxhidaalga. ");
INSERT INTO zawNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Rajpzareni gaii bälbäz, dxejcti badedsac Jesús xquixhtios lo Dios, gunibeeni bateedzareni rebälbäzre loj rebeṉxhidaalga. ");
INSERT INTO zawNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Dxejc gudajwreni, gudxaj xque'reni. Dxejc batojp rexpejṉpac Jesús gajdz dxijm̲ reyätxtiil näj rebäjl dxuc ni bia'n. ");
INSERT INTO zawNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Niluxh renani gudajwga najcreni si'cti tajp mil bejṉ. Dxejcti basadiidxnireni. ");
INSERT INTO zawNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Biunägajc Jesús rexpejṉpacni neṉ canuu, biäädreni nez Dalmanuta. ");
INSERT INTO zawNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Biääd refarisee, renani najc rebeṉguidoo loj guedx Israel, guslojreni cayeinäjreni Jesús. Canabreni gunni te senro nani Diostis ni yu' guibaa sajc gun. Cagula'tzsireni, don xhi gunni. ");
INSERT INTO zawNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Dxejcti bazaa lajz Jesús neṉ lastooni, räjpni: ―¿Xhicuent rlajz rebejṉ ni nabajṉ ṉaj fii gac resenro xten Dios? Rniliä́pac lojtu, di rebejṉ ni nabajṉ ṉaj fii nicla tej sen xhaguibaali. ");
INSERT INTO zawNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Dxejcti basa'nnireni ro'c, biusacni neṉ canuu, sä'tini stelaad nisga. ");
INSERT INTO zawNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Biaḻlajzreni nica'reni yätxtiil, luxh xhetliidi sanädireni. Tejtis yätxtiil nuureni neṉ canuu. ");
INSERT INTO zawNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Cagulijdx Jesús rexpejṉpacni, räjpni lojreni: ―Coḻsusiṉ, coḻnati levaduur xten refarisee, coḻnatiza levaduur xten Herodes. (Nalajznu, xtiidxreni najc si'c levaduur.) ");
INSERT INTO zawNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Dxejcti cayeinäj sa'reni diidx xcuent nani gunii Jesús lojreni, dxejc räjpreni: ―Sa'csi dinu jia'p yätxtiil, ni'c rniini scree. ");
INSERT INTO zawNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Che gucbee Jesús xhini'c caniireni, räjpni: ―¿Xhicuent rniitu: “Sa'csi dinu jia'p yätxtiil”? ¿La gajdtu fii, la gajdtu gacbee? ¿La laḻtis nacnajd lastootu? ");
INSERT INTO zawNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿La yu' balojtu, luxh ditu fii? ¿La sojb diajgtu luxh di diajgtu jiejn? ¿La dilajztu guizaj? ");
INSERT INTO zawNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Che guḻa'a guigaii yätxtiil te gudajw gaii mil niguii, ¿bal dxijm̲ yätxtil biujy batojptu? Sas räjpreni lojni: ―Tzubitio'pni. ");
INSERT INTO zawNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Che guḻa'a guigajdz yätxtiil te gudajw tajp mil bejṉ, ¿bal dxijm̲ yätxtil biujy batojptu? Sas räjpreni: ―Gajdzni. ");
INSERT INTO zawNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Dxejc räjpni lojreni: ―¿La gajdtu gacbesa'c xhi benä? ");
INSERT INTO zawNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bidzuṉnäj Jesús rexpejṉpacni guedx Betsaida. Dxejc biädnäreni te lotiä'p loj Jesús, gunabreni loj Jesús caanni bejṉga. ");
INSERT INTO zawNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Dxejc gunaazni ṉaa lotiä'pga, guläänini neṉ guejdx. Che batiobxhejnni neṉ rebalojni, basugajcni ṉaani yejc baloj lotiä'pga, gunabdidxgajc Jesús: ―¿La yu' xhi rhuiilu, ä? ");
INSERT INTO zawNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Luxh che bahuii bejṉga räjpni: ―Rhuiä sasaj rebejṉ, luxh si'c yajg rhuiä lojreni. ");
INSERT INTO zawNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Basusac Jesús ṉaani yejc rebaloj bejṉga. Dxejc bejn Jesús bahuii bejṉga. Biajctini, zijtru gujc bahuisa'cni lo guiraa rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Dxejcti baxhaḻ Jesúsni rolijzni, räjpni: ―Basquejn, huijga rolijzlu, na'c jiu'lu neṉ guejdx, na'c gäblu xhi gujclu lo rebejṉ ni yu' neṉ guejdx. ");
INSERT INTO zawNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Birinäj Jesús rexpejṉpacni lo reguejdx ni ria'n nez Cesarea xten Filipo. Laḻni sasajreni lo nejz räjp Jesús loj rexpejṉpacni: ―¿Chuni'c rnii rebejṉ nacä narä? ");
INSERT INTO zawNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Sas räjpreni lojni: ―Yu'reni rnii najclu Juan ni batiobnis, yu'zareni rnii najclu Elías, yu'zareni rnii najclu te rebejṉ ni gunii xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Dxejc räjpni lojreni: ―¿La'tu a'? ¿Chuni'c rniitu nacä narä? Dxejc bazejc Pedr diidx, räjpni lojni: ―Luj najclu Crist. ");
INSERT INTO zawNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Dxejcti räjp Jesús lojreni: ―Rutlojdi gäbtu chu nacä. ");
INSERT INTO zawNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Dxejcti gusloj Jesús caguluiini rexpejṉpacni, räjpni: ―Narä nacä Xi'n Dios, ni gujc Niguii. Nanabpac tedä trabajwduxh. Sibälaz rebeṉgool ni najc guxhtis neṉ guedx Israel narä, näjza renani rnibee loj rebixhojz, näjza rebejṉ ni ruluii leii: sugu'treni narä, luxh ni riojṉ dxej guibaṉsacä lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Guyasi guniini rediidxre. Sas huinä Pedr Jesús telaad, dxejc räjpni loj Jesús: ―Na'c guiniilu si'c. ");
INSERT INTO zawNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Dxejc batzuré loj Jesús, bahuiini loj rexpejṉpacni. Dxejc gudiḻṉäjni Pedr räjpni: ―Gubicaj loä, Satanás, luj dilu gun xhigab xten Dios, xhigab ni rujn rebejṉtis rujnlu. ");
INSERT INTO zawNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Dxejc gurejdxni rebeṉxhidaal con reni najc xpejṉpacni, räjpni lojreni: ―Palga yu' chu rlajz gac xpeṉäpac, sucuääz gunni ni rsia' lajzni gunni, sutedni trabajw si'c tej ni caj lo crujz, sujiädnajlni narä. ");
INSERT INTO zawNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sa'csi nani rlajz gusḻaa xcäḻnabajṉni, sunijtni xcäḻnabajṉni. Luxh nani runijt xcäḻnabajṉni xcäḻnasa'c narä, xcäḻnasa'c xtidxä, siḻiaapac xcäḻnabajṉni. ");
INSERT INTO zawNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Xlia' ga'p bejṉ guiraloj lo guedxliujre palga nitni lo Dios par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Xhet gacdi gudeed bejṉ te guibaṉnäjni Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nani guituinäj narä con rextidxä ṉaj, cheni najc rebejṉ beṉdojḻ, narä, Xi'n Dios nani gujc Niguii, situinää́zani che jiädnää́ reangl xten Dios che jiälää́ lo xcäḻrdimbicha' Xtadä. ");
INSERT INTO zawNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Dxejc räjp Jesús lojreni: ―Rniliä́pac lojtu, yu'reni suga' ree nani di guet fixgaareni abiääd xcäḻrnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Che gudejd xho'p dxej, Jesús cua' Pedr, näj Jacoob, näjza Juan, laatisreni huinäni yejc te danro. Ro'c gubixhlojni garenca lojreni. ");
INSERT INTO zawNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Gusloj rdimbicha' rexhajbni, gujc xhajbni nolbäj. Rut rajcti rusquijtz lajd lo guedxliujre si'c biquijtz xhajbni. ");
INSERT INTO zawNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Dxejc baluiiloj Elías näjza Moisés lojreni, cayuinäjreni Jesús diidx. ");
INSERT INTO zawNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Sas räjp Pedr loj Jesús: ―Dad, laaca dxunnu ree. N̲aj jiennu choṉ yuguixa', tejni xtenlu, steeni xten Moisés, steeni xten Elías. ");
INSERT INTO zawNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Si'c guniini sa'csi nicla niacbeeni xhini'c guiniini, sa'csi cadxebduxhreni. ");
INSERT INTO zawNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Dxejc biääd te za bejn balaa yejcreni. Neṉ zaga biejn xse' te ni räjp: ―Dee najc xi'nä nani sanälazä, coḻcuadiajg xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Che batzuré lojreni, bahuiireni rutru suganäjti Jesús, xtebtis Jesús suga'. ");
INSERT INTO zawNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Che siädjiäjtreni dajnga, gunibee Jesús rut lojdi guiniireni xcuent ni bahuiireni, guibaṉxgaasi Xi'n Dios nani gujc Niguii lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Basäḻcheereni rediidxre neṉ lastooreni. Dxejcru canabdiidx lo sa'reni xhicha säloj guibaṉsacni lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Sas gunabdiidxreni lojni, räjpreni: ―¿Xhicuent rnii remastr xten leii naquiinpac jiädxgaa Elías? ");
INSERT INTO zawNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Dxejcti bazejcni diidx lojreni, räjpni: ―Guliireni siädxgaapac Elías, luxh sunsa'cni guira'ti xhi cos. N̲aj a', ¿xhicuent caj lo guijtz xcuent Xi'n Dios ni gujc Niguii, sidejdni trabajwduxh, rutza jiudini? ");
INSERT INTO zawNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Luxh narä rniä lojtu, abiääd Elías, luxh bennäjrenini si'ctis ni rlajzreni, si'cpac ni caj loj guijtz ni rusule' xcuentni. ");
INSERT INTO zawNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Che asiäädreni cadro tre' sgaii rexpejṉpac Jesús, bahuiireni loj xhidalro bejṉ ni tre' lojreni, luxh cayeinäj rebejṉ ni ruluii leiireni. ");
INSERT INTO zawNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Che bahuii guiraa rebejṉ loj Jesús, bidxeloduxhreni, baxuṉreni, huiye'tzreni xchan lojni. ");
INSERT INTO zawNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Dxejc gunabdiidx Jesús lojreni: ―¿Xhini'c rusieinäjtu laareni? ");
INSERT INTO zawNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Sas gunii tej reni yu' lo beṉxhidaalga, räjpni: ―Dad, ree siädnää́ xi'nä lojlu, yu' beṉdxab neṉ lastooni, nani rujn najcni gop. ");
INSERT INTO zawNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Cheni rniaaznini, rutienta'ni xi'nä, luxh ṟiduxh bitzuṉ ro'ni, näjza rauya'ni ro'ni, luxh cabijdzni. Aräpä loj rexpejṉpaclu cuääreni beṉdxabga, niluxh di niajcdi nibäärenini. ");
INSERT INTO zawNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Dxejcti gunii Jesús lojreni, räjpni: ―La'tu, bejṉ ni di chalilajz, ¿gucli chu'ä lojtu te chalilajztu? ¿Gucli gusieedtu narä? ¡Coḻtanäni loä! ");
INSERT INTO zawNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dxejc biädnäreni biuuxga lojni. Che bahuii beṉdxab lo Jesús, basnijni bi'nga, basäḻta'tinini lo yuj. Sädiidxni, luxh caṟii bitzuṉ ro'ni. ");
INSERT INTO zawNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Gunabdiidx Jesús loj xtadni: ―¿Gucli rajcni si'c? Dxejc räjp dade'ga: ―Che gujclini biuxbäz. ");
INSERT INTO zawNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Balti huält rusäḻnini lo guiboo näjza lo nis te ju'tnini. Palga yu' xhi gac gunlu, balazlajz nuunu, gucnäj nuunu. ");
INSERT INTO zawNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Sas räjp Jesús lojni: ―¿Xhicuent rniabdiidxlu la sajc gacnää́lu? Xhitis sajc gac par nani rililajz. ");
INSERT INTO zawNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Guredxa' xtad bi'nga, räjpni: ―¡Rililazä! Gucnäj narä te chaliiru lazä. ");
INSERT INTO zawNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Che bahuii Jesús bixa't xhidajl bejṉ lojni, gudidxa'ni lo beṉdxabga räjpni lojni: ―Beṉdxab ni rujn gop, narä canibeä, birii neṉ lastoo bi'nga. Na'cru chulu neṉ lastooni. ");
INSERT INTO zawNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Dxejcru guredxa' beṉdxabga, luxh basnibzejsni bi'nga, dxejcru biriini neṉ lastooni. Astoo te beṉgut bia'n bi'nga ro'c. Xhidajl rebejṉ räjp: ―Agujtni. ");
INSERT INTO zawNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Dxejc gunaaz Jesús ṉaa bi'nga guläsnini. Guzuliiti bi'nga. ");
INSERT INTO zawNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Dxejcti che abiu' Jesús neṉ yu', gunabdiidx rexpejṉpacni lojni: ―¿Xhicuent di niajcdi nibäänu beṉdxabga? ");
INSERT INTO zawNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Dxejc räjp Jesús lojreni: ―Di gacdi cuäätu sa' beṉdxabre palga ditu cuedx-guinab lo Dios, palga ditu gucuaṉxgaa. ");
INSERT INTO zawNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Dxejc biriireni ro'c, gudejdreni Galilee. Luxh di rlajz Jesús niacbee rebejṉ sadejdreni nejzga, ");
INSERT INTO zawNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","sa'csi caguluiini rexpejṉpacni. Cayäjpni lojreni: “Xi'n Dios ni gujc Niguii sidejdni ladzṉaa rebejṉ, niluxh sugu'trenini. Che guiza' choṉ dxej gujtni, sibajṉni stehuält.” ");
INSERT INTO zawNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Niluxh laareni direni niacbee xhini'c guniini, bidxejbzareni niniabdiidxreni lojni. ");
INSERT INTO zawNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bidzujṉtireni Capernaum. Che biu'ni neṉ yu' räjpni lojreni: ―¿Xhini'c cagusiejytu lo nejz? ");
INSERT INTO zawNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Dxejc xhet guniitireni, sa'csi laareni cagusieinäj sa'reni lo nejz don chuni'c sajcru lojreni. ");
INSERT INTO zawNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sas gurej Jesús, dxejc gurejdxni guitzubitio'p xpejṉpacni, räjpni lojreni: ―Palga yu' chu rlajz gasajcru lojtu, sugacxgaani si'c te nani xhet sajcti, sugunzani xtzuun chutis. ");
INSERT INTO zawNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Dxejcti cua'ni tej biuxbäz, huinänini galäiireni. Dxejc gudääzni biuxbäzga, räjpni lojreni: ");
INSERT INTO zawNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Chutis ni gacnäj te rebiuxe're sa'csi rinälajzni narä, sacnäjni narä, luxh nani gacnäj narä, xhet narätis gacnäjtini, näjza xtadä nani baxhaḻ narä racnäjni. ");
INSERT INTO zawNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Dxejcti gunii Juan räjpni lojni: ―Bahuiinu lo te bejṉ ni rbää beṉdxab con xcäḻrnibee lajlu, niluxh dini sanäj nuunu. Sas huiye'tznu lojni na'c gunni si'c sa'csi dini sanäj nuunu. ");
INSERT INTO zawNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Dxejc räjp Jesús lojni: ―Na'c gudxojntu gunni si'c sa'csi bejṉ nani rujn milagwr con xcäḻrnibee laä digacdi guiniyagajcni narä. ");
INSERT INTO zawNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nani di guidxagdijḻ nuunu, xlaadnu yu'ni. ");
INSERT INTO zawNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Rniliä́pac lojtu, chutis ni guniidx te bas nis lojtu sa'csi najctu xpejṉpac Crist, siguijx Diosni xcuent nani bejnni. ");
INSERT INTO zawNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Chutis ni gusiu' tej rebiuxe' ni rililajz narä neṉ dojḻ, sugaḻ te guimolin yejnni dxejcti gucuaarenini lo nisdoo. ");
INSERT INTO zawNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Palga tej ṉaalu gun gunlu dojḻ, batiu'ni: hueenru natiujnglu chaläjzlu cadro yu' Dios quela sojb guiro'p ṉaalu gusäḻreni luj gabijl, loj bajl ni di jiuii, ");
INSERT INTO zawNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","cadro diza xpisiujgreni guet, diza bajl jiuii. ");
INSERT INTO zawNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Luxh palga tej ni'lu gun gunlu dojḻ, batiu'ni: hueenru nitiujnglu chaläjzlu cadro yu' Dios quela sojb guiro'p ni'lu luxh chäälu gabijl, lo bajl ni di jiuii, ");
INSERT INTO zawNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","cadro di xpisiujgreni guet, diza bajl jiuii. ");
INSERT INTO zawNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Luxh palga tej balojlu gun gunlu dojḻ, gulääni: hueenru chäälu cadro rnibee Dios natiä'p lojlu quela sojb guiro'p balojlu chäälu gabijl, ");
INSERT INTO zawNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","cadro di xpisiujgreni guet, diza bajl jiuii. ");
INSERT INTO zawNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Si'cni rloj sejd yejc xhi cos yäḻrajw, si'cza guiloj bajl yejc guiraareni. Guilojza sejd lo guira'ti ni rdeed bejṉ lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Hueen najc sejd, luxh palga agudejd yäḻnadzij yejcni, ¿xho guntu te gacsacni nadzij? Coḻyajc nadzij la'tu, coḻguibaṉnäsa'c sa'tu. ");
INSERT INTO zawNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Dxejcru birii Jesús ro'c huijni nez Judea näjza nez ro' gueu Jordán stelaad. Ro'c bidojp xhidajl bejṉ lojni stehuält, sas guslosacni caguluiinireni si'ctis ni ruluiinireni. ");
INSERT INTO zawNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Sas refarisee, renani najc rebeṉguidoo loj guedx Israel, gubigreni loj Jesús, cagula'tzreni Jesús. Ni'c gunabdiidxreni, räjpreni: ―¿La laaca gun niguii gusaan chäälni, ä? ");
INSERT INTO zawNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Dxejc laani bazejcni diidx, räjpni lojreni: ―¿Xhini'c gunibee Moisés guntu? ");
INSERT INTO zawNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Dxejcru räjpreni: ―Moisés basaan gudeedni te guitz gusaan chäälni che guṟo'nnini. ");
INSERT INTO zawNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Dxejc Jesús räjp lojreni: ―Sa'csi guyaa lajztu, ni'cni bacuaa Moisés diidxga lojtu. ");
INSERT INTO zawNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Niluxh che birixtiej beṉ guedxliuj, “niguii con gunaa benchee Diosreni.” ");
INSERT INTO zawNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Ni'cni te niguii siriini loj xtadni, loj xnanni te cuäznäjni chäälni. ");
INSERT INTO zawNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Niluxh renani gujc tiop bejṉ sajcreni si'c tejsi bejṉ”, dirureni gac tiop bejṉ, si'c tejsi bejṉ gacreni. ");
INSERT INTO zawNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Na'c gudzucaj bejṉ lo sa bejṉni nani abachaag Dios lo sa'ni. ");
INSERT INTO zawNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Che biu'reni neṉ yu' gunabdidxsac rexpejṉpacni lojni xcuent rediidxre. ");
INSERT INTO zawNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Dxejc räjpni lojreni: ―Chutis niguii ni gusaan chäälni, sas guchṉaani ste'cani, rujnni dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Niluxh palga gunaa guṟo'n chäälni sas guchṉaani ste'ca niguii, rujnzani dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Biädnäza rebejṉ biuxbäz lojni te gutzuub Jesús ṉaani yejcreni, sas gudidxa' rexpejṉpacni lojreni. ");
INSERT INTO zawNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Che bahuii Jesús xhi cayujn rexpejṉpacni, bidxe'chni räjpni lojreni: ―Coḻsaan jiääd rebiuxbäz loä. Na'c gudxojntureni, sa'csi xcäḻrnibee Dios najc xten reni najc nadolajz si'c najc biuxbäz. ");
INSERT INTO zawNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Rniliäpac lojtu, chutis ni rlajz jiu' lo xcäḻrnibee Dios nanab guzobdiajgreni xtidx Dios si'c ruzobdiajg rebiuxe' xtidx xtadreni. Palga dini gun si'c, dini jiu' lo xcäḻrnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Dxejcti gudääz Jesús rebiuxbäz, bazujzani ṉaani yejcreni, gunab Jesús gunle' Dios yejcreni. ");
INSERT INTO zawNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Che birii Jesús loj xnejzni, ruxuṉ te niguii biääd lojni, bazuxhijbni. Dxejcti gunabdiidx niguiiga lojni räjpni: ―Dad, beṉsa'c, ¿xhini'c gunä te xca'ä yäḻnabajṉ par tejpas? ");
INSERT INTO zawNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Sas räjp Jesús lojni: ―¿Xhicuent rniilu loä beṉsa'c? Tejtisni najc beṉsa'c; Diostis najc beṉsa'c. ");
INSERT INTO zawNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Najnlu xhini'c gunibee Dios gunni: “Na'c guesnäjlu chääl sa'lu, na'c ju'tlu, na'c cuanlu, na'c gusgueelu chutis, na'c cuäälu yejc xhixten sa'lu, huinälajz xtadlu, xnanlu.” ");
INSERT INTO zawNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Dxejc räjp niguiiga lojni: ―Dad, guiraa redee cayunä cheni gucäli bi'n. ");
INSERT INTO zawNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Che bahuii Jesús lojni, huinälajznini, räjpni lojni: ―Tejtis nani cayäädx gunlu. Huij, huito' guiraa xhixtenlu, badeed xcuentni loj rebejṉ nani diga'p, dxejcti guniidx Dios xhidajl xhi ga'plu xhaguibaa. Gudanajl narä, mase tedlu trabajw. ");
INSERT INTO zawNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Dxejc che biejn diajgni diidxre, guc-huin lajzni, xhet laadi yu'ni siini, sa'csi naclenduxh xhixtenni yu'. ");
INSERT INTO zawNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Dxejc bahuii Jesús guideb gabi lojreni, räjpni loj rexpejṉpacni: ―Naganduxh jiu' rebejṉ nani yu'duxh xhixtenni lo xcäḻrnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Dxejc bidxelo rexpejṉpacni che biejn diajgreni rextiidxni. Dxejc räjp Jesús lojreni stehuält: ―¡Aiitu xi'nä!, lacti naganduxh gusaan renani sanälajz xhixtenni guinibee Diosreni. ");
INSERT INTO zawNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Guyasiru ted te cameii ni' te guux quela gusaan te bejṉ ni yuduxh xhixtenni guinibee Diosni. ");
INSERT INTO zawNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Dxejc bidxeloduxhreni, räjpreni lojni: ―¿Chuxhni'c sajc ḻaa lo dojḻ? ");
INSERT INTO zawNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Dxejc bahuii Jesús lojreni, räjpni: ―Bejṉ digacdi gusḻaa sabejṉni, Diostis rajc rusḻaa bejṉ lo dojḻ, sa'csi Dios rac rujn guira'ti. ");
INSERT INTO zawNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Sas gusloj Pedr cayäjp lojni: ―N̲aj nuure ahuilälaznu guira'ti te siopnajlnu luj. ");
INSERT INTO zawNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Dxejc räjp Jesús: ―Rniliäpac lojtu, chutis nani cuälaz rolijzni, rebejtzni, rebisiajnni, xtadni, xnanni, chäälni, rexi'nni, rexyujni, xcäḻnasa'c narä, näjza xcäḻnasa'c xtidx Dios, ");
INSERT INTO zawNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","sica'ni lo guedxliujre te gayuu huält xhidajlru. Sica'ni rolijzni, rebejtzni, rebisiajnni, xnanni, rexi'nni, rexyujni. Sisiunajlrenini ṉaj, dxejc xhaguibaa sica'ni yäḻnabajṉ par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Xhidajl rebejṉ nani sajc lo guedxliujre xhet sajcdireni xhaguibaa; niluxh rebejṉ nani xhet sajcdi lo guedxliujre, xhaguibaaru gasajcreni. ");
INSERT INTO zawNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Dxejcru sasaj Jesús, nijdni lo rexpejṉpacni sääreni Jerusalén, luxh cadxelojreni. Cadxejbza rebejṉ nani sanajlreni. Dxejcti guḻäsac Jesús rexpejṉpacni lo rebejṉ, gusloj cayäjpni lojreni guira'ti nani sacni. ");
INSERT INTO zawNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Räjp Jesús: ―Sionnu Jerusalén, luxh narä, Xi'n Dios nani gujc Niguii, sidedä ladzṉaa rebixhojz nani rnibee näjza rebejṉ ni ruluii leii. Luxh sinibeereni guetä. Suteedreni narä lo rebeṉzijt nani digac xpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Suxhisnäjreni narä, siguijnreni narä, sutiobxhejnzareni loä, dxejcru sugu'treni narä. Che riojṉ dxej sibaṉsacä. ");
INSERT INTO zawNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Dxejcti gubig Jacoob näjza Juan, rexi'n Zebedeo, räjpreni lojni: ―Dad, rlaaznu gunlaalu nani guiniabnu lojlu. ");
INSERT INTO zawNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Dxejc räjp Jesús lojreni: ―¿Xhini'c rlajztu gunä xcuent la'tu? ");
INSERT INTO zawNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Räjpreni: ―Cue tejnu cuä'lu ladbee, xteenu cue cuä'lu ladbäjgw che acanibeelu. ");
INSERT INTO zawNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Dxejc räjp Jesús lojreni: ―Ditu gan xhini'c rniabtu. ¿Xhixh sajc yätu nani yä'ä? ¿Xhixh sajcza guirobnistu si'cni guirobnisä? Nalajznu, xhixh sajc tedtu trabajw nani tedä narä. ");
INSERT INTO zawNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Sas räjpreni lojni: ―Sajc tednuni. Dxejc räjp Jesús lojreni: ―Guliini sajc yätu nani yä'ä, luxh guirobnistu si'cni guirobnisä narä. ");
INSERT INTO zawNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Te cue tejtu ladbee xtenä steetu cue xladbägwä, xhet xtenä dini te gunidxäni. Rebejṉ nani agule Dios, reni'c cue xladbeä, xladbägwä. ");
INSERT INTO zawNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Luxh che biejn diajg stzuureni bidxe'chreni loj Jacoob näjza loj Juan. ");
INSERT INTO zawNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Sas gurejdx Jesúsreni, räjpni lojreni: ―La'tu najntu renani rnibee lo rebejṉ nani digac xpejṉ Israel, rdxaglajz gasajcrureni lo rebejṉ. Luxh rebejṉ ni sajc rnibeduxhreni lo rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Xhet si'cdi guntu la'tu. Chutis nani rlajz gasajcru lojtu, riäjḻ gacni mos lojtu. ");
INSERT INTO zawNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Luxh chutis la'tu nani rlajz gasajcru, riäjḻ gacni xmos guiraatu. ");
INSERT INTO zawNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Di Xi'n Dios ni gujc Niguii niääd, te ga'ptisni mos, biäädzani te quiixni con xcäḻnabajṉni te ḻaa xhidajl bejṉ lo dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Dxejcti biäädreni Jericó. Che birii Jesús ro' guedx Jericó con rexpejṉpacni näjza rebeṉxhidaal, cuä' nezyuj sobga' Bartimeo, xi'n Timeo. Natiä'p lojni. Ro'c cabääni gojn. ");
INSERT INTO zawNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Che biejn diajgni laa Jesús ni siääd Nasare't ni sadejd ro'c, guslojni rbedxa'ni, räjpni: ―Jesús, xi'n David, balazlajz narä. ");
INSERT INTO zawNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Xhidajlreni gudidxa' lojni, te jiäuu ro'ni. Dxejc laani dipru rbedxa'ni räjpni: ―Xi'n David, balazlajz narä. ");
INSERT INTO zawNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Dxejc guzudxi Jesús, gunibegajcni gucrejdx niguiiga. Gurejdxreni lotiä'pga, räjpreni lojni: ―Basutijp lajzlu, gusulii, luj cabejdxni. ");
INSERT INTO zawNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Sas roḻca xhablajzni gudixhni, huisuliini, biäädtini lo Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Dxejc räjp Jesús lojni: ―N̲aja', ¿xhini'c rlajzlu gunä? Dxejc räjp lotiä'pga loj Jesús: ―Dad, rlazä gunlu fiä. ");
INSERT INTO zawNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Dxejcti räjp Jesús lojni: ―Huij, abiajclu sa'csi rililajzlu. Lagajc dxejc gujc bahuiini. Sanajltini Jesús lo nejz. ");
INSERT INTO zawNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Cheni sadzujṉreni gajxh Jerusalén, gudejdreni neṉ reguedx Betfagé näjza neṉ guedx Betania nez cuä' dajne' ni laa dan Oliib. Baxhaḻ Jesús tiop xpejṉpacni, ");
INSERT INTO zawNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","räjpni lojreni: ―Coḻchäj guedxe' ni ria'n nez lojtu. Che guidzujṉtu ro' guejdxga, sidxältu te buṟe' ni caduu. Gajd bejṉ cuibni. Coḻxhecni, coḻtanägajcni. ");
INSERT INTO zawNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Palga yu' chu naa lojtu: “¿Xhicuent rujntu si'c?” Coḻye'tztis: “Dad caquiinni.” Dxejc suxhaḻgajcni buṟe'ga ree. ");
INSERT INTO zawNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Säätireni ro'c. Dxejcru ronejz bidxälreni te buṟe' caduu ro' te lä'. Dxejcti baxhecrenini. ");
INSERT INTO zawNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Gaii bejṉ ni tre' ro'c räjp lojreni: ―¿Xhicuent caguxhectuni? ");
INSERT INTO zawNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Dxejc räjpreni loj rebejṉga si'cni räjp Jesús lojreni gäbreni. Basangajc rebejṉga sanäreni buṟe'ga. ");
INSERT INTO zawNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Dxejcru biädnäreni buṟe'ga loj Jesús. Badzuubreni xhablajzreni dejtz buṟe'ga. Gubijbti Jesús buṟe'ga. ");
INSERT INTO zawNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Xhidajlza bejṉ gudixh xhablajzreni lo nezyuj, sgaiireni gudi'ch balajg lo reyajg te gudixhrenini lo nezyuj. ");
INSERT INTO zawNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Rebejṉ ni nijd lojni näj reni sanajl dejtzni guredxa'reni, räjpreni: ―¡Coḻguiliä'p xpala'nni! Coḻdeed xquixhtiooz loj Dios sa'csi baxhaḻni nani siääd xcuentni. ");
INSERT INTO zawNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Coḻdeed xquixhtiooz loj Dios sa'csi agubiré xcäḻrnibee toxtadnu David. ¡Coḻguiliä'p xpala'n Dios ni yu' jiaro! ");
INSERT INTO zawNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Dxejcti biu' Jesús neṉ guedx Jerusalén. Biu'zani neṉ guidoro. Che bahuii Jesús guira'ti ni cayajc neṉga, sanäni guitzubitio'p xpejṉpacni, sääreni Betania sa'csi agudxej. ");
INSERT INTO zawNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Che bara yääl, biunejzreni Betania. Dxejcti gusloj calaan Jesús, ");
INSERT INTO zawNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","bahuiini zijt sojb te yag iigw caj balajg lojni. Sas gubigni, bahuiini don gaxäjsi caj iigw lojni. Xhet bidxäldini lojni; balajgtis caj lojni, sa'csi xhet xtiempdi iigw dxejc. ");
INSERT INTO zawNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Sas gunii Jesús räjpni loj yag iigwga: ―Rutru gauudi ninejxh ni rcaj lojlu par tejpas. Biejnza diajg rexpejṉpacni. ");
INSERT INTO zawNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Dxejcti bidzujṉreni guedx Jerusalén. Biu' Jesús neṉ guidoro. Gusloj cabääni renani ruto' näj renani rsii neṉ guidooga. Niluxh batiejxhni rexmex renani ruchaa meel, näjza reyagxhil xten renani ruto' paloom. ");
INSERT INTO zawNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Diruni nusaan nidednäjreni xhicos nez neṉ guidooga. ");
INSERT INTO zawNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Dxejc caguluiinireni, räpgajcni lojreni: ―¿La et screedi caj loj guijtz? “Xyu'ä siriḻaj yu' cadro rninab guiraa rebeṉguedxliuj lo Dios.” La'tu abejntuni si'c xpiliää gubaan. ");
INSERT INTO zawNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Rebixhojz ni rnibee näjza remastr xten leii biejn diajgreni nani gunii Jesús. Sas gudiilreni xho ju'trenini, sa'csi rdxejbreni Jesús, sa'csi guiraa rebejṉ rdxeloj rextidx Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Che biu' guxhijṉ, birii Jesús guejdxga. ");
INSERT INTO zawNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Che bara yääl gudejdreni, bahuiireni agubijdz guideb yagiigw, näj rexlobaani. ");
INSERT INTO zawNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Dxejc banaj lajz Pedr, räjpni loj Jesús: ―Dad, bahuii yagiigw nani batzubdelu yejcni, agubijdzni. ");
INSERT INTO zawNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Dxejcti gunii Jesús räjpni lojni: ―Coḻchalilajz Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Rniliä́pac lojtu, chutis nani gäb loj dajnre: “Gubicaj, bitejb loj nisdoo”, luxh dini guntio'p lajzni, chalilajztisni scree gac nani guniini, sajcpac nani guniini. ");
INSERT INTO zawNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ni'cni rniä lojtu, xhitis nani guiniabtu lo Dios che rninäjtuni, coḻchalilajz xca'tuni, dxejc sica'tuni. ");
INSERT INTO zawNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Luxh che guiniabtu Dios, palga yu' chu loj rdxechlajztu, coḻsiäjlza lajztu, te näjza Xtadtu nani yu' xhaguibaa gusiäjḻza rextojḻtu. ");
INSERT INTO zawNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Palga ditu gusiäjḻ lajztu con resa'tu, diza Xtadtu nani yu' xhaguibaa gusiäjḻ lajzni rextojḻtu. ");
INSERT INTO zawNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Sas bidzuṉsacreni guedx Jerusalén. Laḻ ni sasaj Jesús neṉ guidoro, rebixhojz nani rnibee, näjza rebejṉ ni ruluii leii, näjza reguxhtis gubig lojni. ");
INSERT INTO zawNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Räjpreni lojni: ―¿Xhi yäḻrnibee rajplu, ni'c rujnlu redzuunre? ¿Chu baniidx yäḻrnibee rujnlu redzuunre? ");
INSERT INTO zawNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Dxejc räjp Jesús lojreni: ―Guiniabdidxäza lojtu. Coḻtzu'ni loä, dxejcti guiniäza xhi yäḻrnibeere rapä ni'c runä redzuunre. ");
INSERT INTO zawNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Chu baxhaḻ Juan ni batiobnis? ¿La Dios o la rebejṉ? Coḻnii loä ṉaj. ");
INSERT INTO zawNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Dxejcti gunii loj sa'reni, räjpreni: ―Palga jie'tznu “Dios”, naani “¿xhicuent ditu nililajz xtiidxni?” ");
INSERT INTO zawNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Diza niacti niäjbreni “rebejṉ” sa'csi rdxejbreni rebeṉxhidaal, sa'csi guiraa rebejṉ huililajz Juan gujc te bejṉ ni guniipac xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Dxejcti guniireni, räjpreni loj Jesús: ―Dinu guidon. Sas räjp Jesús lojreni: ―Dizana guiniä xhi yäḻrnibeere rapä runä redzuunre. ");
INSERT INTO zawNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Dxejcti gusloj caguseed Jesús rebejṉ con recuent ni ruluii, räjpni: ―Yu' te bejṉ bazuj yaguub loj xyujni, bejnzani bazaani, dxejcru gudäänni te lajt cadro jiä't uubga. Dxejcti bejnni te yu' jiaa, te ro'c cue nani ga'p lo xyujni. ’Badedlaatinini loj gaii bejṉ, sä'tini zijt. ");
INSERT INTO zawNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Che bidzujṉ xpäii uub, baxhaḻ baxhuaan uubga te xmosni loj rebejṉ ni rbäzlaa ro'c, te xca'ni uub nani riäjḻ xca' bejṉga. ");
INSERT INTO zawNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Dxejc rebejṉ ni rbäzlaa ro'c gunaazreni mosga, gudijnrenini, luxh bazejcrenini siini ganaxni. ");
INSERT INTO zawNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Dxejcru baxhaḻ baxhuaanga stee mos lojreni. Niluxh laareni bacuaareni guijni, gudiḻguijdxreni yejc mosga, xho rniajni gubi'ni. ");
INSERT INTO zawNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Dxejc baxhaḻ bejṉga stee mos, dxejc bagu'trenini. Baxhaḻni xhidajlrureni. Gaii gudiḻguijdxreni, sgaiini bagu'treni. ");
INSERT INTO zawNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Yu'za tejtis xi'nni, luxh sanälajznini. Por lult näjza xi'nni baxhaḻni, naani: “Siucareni xi'nä.” ");
INSERT INTO zawNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Dxejc rebejṉ nani rbäzlaa ro'c räjp loj sa'reni: “Dee najc laa ni jiannäj ree. Coḻtaa, guigu'tnuni, te xca'nu yujre.” ");
INSERT INTO zawNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Sas gunaazrenini, bagu'trenini. Guläätirenini lo yujga. ");
INSERT INTO zawNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’¿Xhicha gun baxhuaan yaguubga rebejṉre? Siäädni luxh sugu'tni rebejṉre, dxejcti gudeedni yujga loj ste'ca bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿La gajdtu goḻ guijtz ni rnii scree? Guij nani guläcaj renani runchee yu', ni'c agujc mastr ni guzuj galoo. ");
INSERT INTO zawNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dad xtennu bejn scree, cos sacduxhni nezlojnu. ");
INSERT INTO zawNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Dxejc rlajz reguxhtis nani bacuadiajg cuentre niniaaz Jesús, sa'csi gucbeereni laareni cacuaa Jesús diidxre. Sa'csi bidxejbreni rebeṉxhidaal, ni'c basa'nrenini, sä'tireni. ");
INSERT INTO zawNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Dxejcti baxhaḻreni gaii xpejṉ refarisee näjza gaii xpejṉ Herodes loj Jesús te gula'tzreni don xho gac guiniaazreni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Dxejcti biäädreni, räjpreni lojni: ―Dad, nadonnu luj najclu te bejṉ ni rnilii. Par luj guiraasi bejṉ sajc tebloj, sa'csi dilu fii la sajc bejṉ o la xhet sajcdi bejṉ. Luj ruluiipaclu xhini'c rlajz Dios gun bejṉ. ¿La laaca quiix bejṉ reimpuest lo xcubieer César o la xhet laadi? ¿La guidiixnu o la dinu guidiix? ");
INSERT INTO zawNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Dxejcti laani gucbegajcni rujnsireni si'cni rniabdiidxreni. Räjpni lojreni: ―¿Xhicuent runnäjtu narä scree? Coḻtanä te meelga loä, te fiä lojni. ");
INSERT INTO zawNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Badeedtireni te meel lojni, dxejc räjpni lojreni: ―¿Chu yejc caj lojni, chu laj caj lojni? Dxejc räjpreni: ―Xten César. ");
INSERT INTO zawNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Dxejc räjp Jesús lojreni: ―Coḻdeed nani najc xten César loj César; coḻdeedza nani najc xten Dios loj Dios. Baschelojni rebejṉga con xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sas biädhuii resaducee loj Jesús. Resaducee najc rebejṉ nani rnii di rebeṉgut guibaṉsac. Dxejc gunabdiidxreni lojni, räjpreni: ");
INSERT INTO zawNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Dad, xleii Moisés ruluii loonu, palga guet te niguii luxh gusa'nni chäälni ruti xi'nni, nanabpac xca' bejtzni chäälni, te chu xi'nni con laani lacua niu' xi'n tobejtzni. ");
INSERT INTO zawNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Guyu' gajdz niguii, bejtz najcreni. Sas cua' niguigalooga chäälni. Che gujtni ruti xi'nni. ");
INSERT INTO zawNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Dxejcti cua' ni rojpga gunaaga. Che gujtni, rut gajcdi xi'nni. Si'cza gusajc ni riojnga. ");
INSERT INTO zawNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Si'cza guläznäj gunaaga guigajdzreni. Per nicla tej reni di xi'nreni niu'. Dxejcti gujtza gunaaga. ");
INSERT INTO zawNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Guigajdzreni guläznäjreni gunaare. Cheni guibaṉsacreni lo rebeṉgut, ¿chu chääl gacni? ");
INSERT INTO zawNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Dxejc bazejc Jesús diidx lojreni, räjpni: ―Et laadi rniitu, sa'csi ditu gumbesa'c rextidx Dios nani bacuaa reniguii lo guijtz, dizatu gumbee yäḻrnibee xten Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Che guibaṉsacreni loj rebeṉgut, direni guchṉaa, rutza gudeedtireni te guchṉaareni. Niluxh sajcreni si'c najc rexangl Dios nani yu' xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Palga canabdiidxtu la rbaṉsac rebeṉgut, ¿la di lajztu guisaj biḻtu guijtz ni bacuaa Moisés? Moisés bacuaa nani gunii Dios lojni neṉ bajl, räjpni: “Narä nacä Xtios Abraham, Xtios Isaac, Xtios Jacoob.” ");
INSERT INTO zawNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Palga Dios najc Xtios rebejṉre, direni gac beṉgut, nabaṉnäjreni Dios. Et laadi najc xhigabtu. ");
INSERT INTO zawNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Dxejcru bidzujṉ tej rebejṉ ni najn leii, biejn diajgni xhi caniireni, biejnza diajgni laaca gunii Jesús lojreni. Dxejcti gunabdiidxni loj Jesús: ―¿Xhi mandamient sajcru lo guiraareni? ");
INSERT INTO zawNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Dxejc räjp Jesús lojni: ―Mandamient nani sajcru loj guiraareni najc dee: “Bacuadiajg luj, guejdx xten Israel, Dad Xtiosnu, Dad tejtis najcni. ");
INSERT INTO zawNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Chanälajzlu Dad Xtioslu guideb lastoolu, näj xaimlu, näj guideb xcäriejnlu, näjza guideb xcäḻnadiplajzlu.” ");
INSERT INTO zawNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Sigajcza najc mandamient ni ṟojpga: “Huinälajz sabejṉlu si'ctis sanälajzlu lagajc luj.” Redee najc remandamient nani sajcru loj guiraareni. ");
INSERT INTO zawNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Dxejcti räjp bejṉga ni najn leii lojni: ―Laaca guniilu Dad. Tejtis najc Dios, luxh ruti chu stee najc si'c laani. ");
INSERT INTO zawNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Luxh sacduxh chanälajz bejṉ Dios guideb lastooni, näj xcäriejnni, näjza xaimni, näj guideb xcäḻnadiplajzni, luxh chanälajzni resabejṉni sigajc laani. Redee sajcru loj ni rujn bejṉ che rudeedreni gojn lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Che bahuii Jesús laaca guniini, räjpni lojni: ―Guxii cayäädx te jiu'lu loj xcäḻrnibee Dios. Sas rutru biajxhdi gunabdiidx loj Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Che caguseed Jesús neṉ guidoro, räjpni: ―¿Xho mood rnii rebejṉ ni najn leii Crist najc xi'n David? ");
INSERT INTO zawNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Sprit Dxan xten Dios basnii David che bacuaani: Räjp Dios loj Dad xtenä: “Gurej ladbee xtenä, che gudzugäli reni rdxe'ch lojlu.” ");
INSERT INTO zawNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Palga lagajc David räjp: “Dad, xtenä”, che guniini xcuent Crist, ¿xhoxh najc Crist xi'n David? Rebeṉxhidaal nani yu' guejdxga bacuadiagsa'creni xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Laḻni caguseedni rebejṉ, räjpni lojreni: ―Coḻsusiṉ, na'c gu'chtu loj rebejṉ ni ruluii leii. Laareni rlajz sanäj reladsiool xtenreni. Rdxaglajzreni rnii bejṉ lojreni nez lo reguii. ");
INSERT INTO zawNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Rlajzzareni cuereni cadro rbej renani sajcru neṉ reguidoo näjza cadro ru' relanij. ");
INSERT INTO zawNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Rudzucajzareni xhixten rebiuud, rniizareni xhidalduxh diidx che roḻreni ḻe', te rusäuureni loj rebejṉ. Castigwroru gac redee. ");
INSERT INTO zawNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Dxejcti gurej Jesús cuä' caj cadro rusäḻ bejṉ gojn. Cahuiini cagusäḻ rebejṉ meel neṉ cajga. Xhidajl reni rajp cagusäḻ xhidajl meel neṉga. ");
INSERT INTO zawNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Che biääd te biud proob, basäḻni tiop melbäz ni sajc si'cti tej centaab. ");
INSERT INTO zawNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Dxejcru gurejdx Jesús rexpejṉpacni, räjpni lojreni: ―Rniliä́pac lojtu, biud proobre basäḻ xhidajlru lo guiraa renani basäḻ neṉ cajre, ");
INSERT INTO zawNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","sa'csi guiraareni abasäḻ che'nsi xhixtenreni. Luxh gunaare basäḻ guiraa nani rajpni. Ni'ctis najc nani gaunäjni. ");
INSERT INTO zawNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Cheni sariireni neṉ guidoro, räjp tej rexpejṉpacni lojni: ―Dad, bahuii lacti reguij, lacti reyu'. ");
INSERT INTO zawNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Dxejcti räjp Jesús lojni: ―¿La rhuiilu loj reyu're? Nicla tej guij dijia'n dzuub yejc sa'ni, guiraliireni sire'ch. ");
INSERT INTO zawNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Dxejc sobga' Jesús yejc dajne' ni laa dan Oliib, cahuiini nez ro' guidooga. Che sugaxhtebreni, gunabdiidx Pedr näj Jacoob näjza Juan näjza Andrés lojni, räjpreni: ");
INSERT INTO zawNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Gunii loonu, ¿guc gac dee? ¿Xhi guihuiinu te gacbeenu asiäddzuṉgajxh soob guiraa rediidxre? ");
INSERT INTO zawNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Dxejcti gusloj gunii Jesús lojreni, räjpni: ―Coḻhuii, te rut gusgueedi la'tu, ");
INSERT INTO zawNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","sa'csi xhidalduxh bejṉ jiääd con laä, gäbreni: “Narä nacä Crist”, luxh rniisireni si'c, susgueezareni xhidajl bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Che jiejn diajgtu yu' gueṟ näj yäḻnadxeeb xten gueṟ, na'c guidxejbtu. Nanabpac gacni; et dxejcdi nitloj guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Säjs nacióṉ yejc sanacioṉni, näj yäḻrnibee yejc sayäḻrnibeeni. Xhidajl lajt sajc xu, siliaanza bejṉ, luxh säjs rebejṉ yejc sa'ni. Redee najc ni guisloj guidxejb, gachuinza lajzni. ");
INSERT INTO zawNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Dxejc la'tu coḻsusiṉ sa'csi suteedreni la'tu ladzṉaa reguxhtis, siguijnzareni la'tu neṉ reguidoo. Sacrejdxtu lo regubieer näjza loj reṟeii xcäḻnasa'c narä, te si'c gac guiniitu xtidxä lojreni. ");
INSERT INTO zawNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nanabpac guirechxgaa xtidx Dios loj guiraa rebeṉ guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Che guiniaazreni la'tu, che chanäreni la'tu loj reguxhtis, na'c gunxgaatu xhigab xhi diidx guiniitu. Coḻnii nani jiäjttis yejctu dxejc, sa'csi xhet la'ditu ni guinii, Sprit Dxan xten Dios ni guinii. ");
INSERT INTO zawNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Luxh suto' bejṉ lagajc bejtzni te guet bejtzni. Suto'za dad lagajc xi'nni. Säjs rebiuux yejc rexcusajnni te guet reguzajnga. ");
INSERT INTO zawNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Sidxechlajz guiraa rebejṉ lojtu sa'csi najctu xpeṉä; nani ted guiraa retrabajwre, ni'c gudeed Dios xcäḻnabajṉni. ");
INSERT INTO zawNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Che fiitu loj nani najc yäḻrdxechlajz, nani najc yäḻrunitloj, nani gunii Daniel ni gunii xtidx Dios. Che fiitu nani suga' cadro di nunyäjḻ suuni, dxejcti suguxuṉ renani yu' nez Judea chääreni nez neṉ redajn. (Nani goḻ guijtzre sugacbeenini.) ");
INSERT INTO zawNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Bejṉ nani suga' yejc yu' na'c jiäjtni jiu'ni neṉ te yu' xca'ni gaii xhixtenni. ");
INSERT INTO zawNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nani yu' loj ṉiaa, di gaḻ jiäjt te xca'ni xhablajzni. ");
INSERT INTO zawNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Aii! Xhiza nalas chu regunaa ni nuu bäz, luxh renani rusiä' xi'nni, neṉ redxejga. ");
INSERT INTO zawNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Coḻnab loj Dios na'c sactu scree neṉ rebäinajḻ. ");
INSERT INTO zawNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Neṉ redxejga su' trabajwduxh, nani gajd chu che bencheeli Dios guedxliuj, luxh diruni chu, dxejctis chuni. ");
INSERT INTO zawNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Paru di Dad gusia'tz redxejga, nicla tej bejṉ di ḻaa. Susia'tzni redxejga sa'csi sanälajzni rexpejṉni nani aguleni. ");
INSERT INTO zawNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Dxejc palga yu' chu naa lojtu: “Coḻhuii, aree Crist”, o “Coḻhuiire, ani suga' rec”, na'c chalilajztuni. ");
INSERT INTO zawNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sa'csi su' bejṉ nani rniisi najcni Crist. Su'za reniguii nani rniisi rniireni xcuent Dios. Sujnzareni milaagwr, te gusgueereni, te palga sajcni, rlajzreni gusgueelireni renani agule Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ni'cni la'tu coḻsusiṉ; agunixgaä lojtu guira'ti ni gac. ");
INSERT INTO zawNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Neṉ redxejga, cheni luux retrabajwduxhga, sicäjy lo gubijdx, luxh diru bäii gusanij. ");
INSERT INTO zawNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Sitejb rebaḻxhaguibaa, sinibsejs recos nani nasnäj rebaḻxhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Dxejcti suhuii rebejṉ loä, Xi'n Dios nani gujc Niguii, siälä neṉ reza guideb yäḻrnibeduxh xtenä, näjza xcäḻdimbicha'ä. ");
INSERT INTO zawNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Dxejcti guxhaḻgacä rexanglä jiädtojpreni renani guleä guideb lo guedxliuj, cat nalooli guedxliuj näjza cadro nalooli guibaa. ");
INSERT INTO zawNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Coḻguisieed nani ruluii yagiigw. Cheni rii rebäte' lojni luxh che rcaj balajg lojni, acaxhnajntu bäii gusguij asadzuṉgajxh. ");
INSERT INTO zawNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Sigajcza, che fiitu acayajc recosre, sacbeetu asiädgaxhä, ameer guidzuṉä. ");
INSERT INTO zawNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Rniliä́pac lojtu, rebejṉ ni nabajṉ dxejc, direni nitloj, fixgaareni gac recosga. ");
INSERT INTO zawNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Sinitloj guibaa näjza guedxliuj, rextidxä di nitloj. ");
INSERT INTO zawNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’N̲aj, rut najndi guc gac recosga, nicla rexangl Dios ni yu' xhaguibaa, niclaza narä Xi'n Dios, Xtadätis najn. ");
INSERT INTO zawNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Coḻhuii, coḻsusiṉ, coḻnab loj Dios, sa'csi ditu gan guc guidzujṉ redxejga. ");
INSERT INTO zawNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Dee najc si'c najc te bejṉ ni birii sää zijt. Che gajdlini guirii, badeedni xtzun rexmosni, luxh gunibeezani susiṉ nani canäj rolä'. ");
INSERT INTO zawNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Si'cza coḻsusiṉ, sa'csi ditu gan guc jiääd baxhuaan yu'ga, la jiäädni gudxej, o la jiäädni garol yääl, o la cäjy, o la jiäädni ṟsil. ");
INSERT INTO zawNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Coḻsusiṉ, te di guiga'tu nagayejstu che guidzujṉni. ");
INSERT INTO zawNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Rediidx nani rniä lojtu, loj guiraa rebejṉ rniäni: coḻsusiṉ. ");
INSERT INTO zawNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Riäädx tiop dxej guidzujṉ lanij, dxej ni ruzaa lajzreni guḻaareni ladzṉaa reEgipto. Neṉ redxejga rajwreni yätxtiil nani di saguij. Rebixhojz nani rnibee neṉ guidoo xten rexpejṉ Israel näj rebejṉ ni ruluii leii rlajzreni niniaazreni Jesús con yäḻrusguee, te nugu'trenini. ");
INSERT INTO zawNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Dxejcti räjpreni lo sa'reni: ―Na'c jiennu scree neṉ redxelanij, te na'c gun beṉguejdx biejy. ");
INSERT INTO zawNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yu' Jesús Betania, rolijz Simón, nani guyu' guejch ni raḻ tiejxhni. Che sobga'ni lo mex, biääd te gunaa ca' te bo'tguij yu' setnard neṉni. Rlianexhduxhni, sacduxhni. Dxejc gudi'chni yejn bo'tguijga, te basäḻni se'tga yejc Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Yu'za gaiireni ro'c ni bidxe'ch, räjp loj sa'reni: ―¿Xhicuent banijtni setnejxhga? ");
INSERT INTO zawNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Paru nido' se'tga, nijni si'cti choṉ gayuu denar, te nica' meelga rebejṉ ni xhet rajpdi meel. Luxh caguidxa'reni loj gunaaga. ");
INSERT INTO zawNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Dxejc räjp Jesús lojreni: ―Coḻsaanni, ¿xhicuent rudxojntu nani cayujn gunaare? Cos sacduxh dee bennäjni narä. ");
INSERT INTO zawNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Guideb ni guibajṉtu, su' rebejṉ nani xhet rajpdi lojtu, luxh che rlajztu sajc gacnäjtureni. Narä et xchejdi chu'ä lojtu. ");
INSERT INTO zawNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Gunaare abejnni nani gujctis bejnni. Abaslanexhxgaani tiexhä, te chää tiexhä neṉ baa. ");
INSERT INTO zawNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Rniliä́pac lojtu, cadrotis guidzujṉ xtidx Dios, guideb lo guedxliuj, siniizareni xcuent nani bejn gunaare, te guinaj lajzreni gunaare. ");
INSERT INTO zawNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Dxejcti huij Judas Iscariot, nani najc tej retzubitio'p xpejṉpac Jesús, loj rebixhojz nani rnibee te guto'ni Jesús lojreni. ");
INSERT INTO zawNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Che biejn diajg rebixhojz xtiidxni, bibalajzreni. Räjpreni sudeedreni meel lojni. Dxejcti caguiil Judas xho guto'ni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Biu'ti xmaan che rajwreni yätxtiil ni di saguij. Dxej lanijga, rugu'treni xiil, te ruzaa lajzreni dxej ni guḻaareni ladzṉaa reEgipto. Räjp rexpejṉpacni loj Jesús: ―¿Caro rlajzlu chosucheenu te gauulu nadxej, dxelanij? ");
INSERT INTO zawNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dxejc baxhaḻni tiop rexpejṉpacni, räjpni lojreni: ―Coḻchäj neṉ guejdx, ro'c guidxaagtu te niguii ni nuu te re' nis. Coḻchanajl niguiiga. ");
INSERT INTO zawNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Cadro jiu'ni coḻye'tz loj bejṉ ni najc rolijzni ro'c: “Naj Dad mastr, ¿con yu' cadro ria'n rebiooz, cadro gaunäjni rexpejṉpacni nadxej, dxelanij?” ");
INSERT INTO zawNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Dxejcti guluiini lojtu te yu' ni sojb jiaaliga yejc sa'ni, ni asuchexgaa neṉni. Coḻyujn xhi guidauunu ro'c. ");
INSERT INTO zawNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Sas huij rexpejṉpacni, bidzujṉreni neṉ guejdxga. Bidxälreni te yu' si'cni räjp Jesús lojreni. Ro'c bejnreni xhi gudajwreni dxelanij. ");
INSERT INTO zawNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Che huääz gubijdx, bidzuṉnäj Jesús guitzubitio'p xpejṉpacni. ");
INSERT INTO zawNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Laḻni sobga'reni lo mex cayajwreni, räjp Jesús lojreni: ―Rniliä́pac lojtu, tej la'tu ni cayaunää́, suto'ni narä. ");
INSERT INTO zawNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Dxejcti gusloj cayac-huin lajzreni, räjp tebgajreni lo Jesús: ―¿La naräni? Räpgajc steeni: ―¿La naräni? ");
INSERT INTO zawNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Dxejcti guniini, räjpni lojreni: ―La tej retzubitio'p, tej ni cayajw loj xpla'tä. ");
INSERT INTO zawNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Sa'csi narä Xi'n Dios nani gujc Niguii, sia'ä, si'cpacni caj loj xtiidx Dios, per xhiza nalajz niguii ni guto' narä. Huentejti na'c niajl niguiire. ");
INSERT INTO zawNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Laḻni cayajwreni, cua' Jesús yätxtiil, badeedzani xquixhtiooz loj Dios dxejc guḻa'nini, badeednini lojreni. Dxejcti räjpni: ―Coḻca' yätxtiilre. Dee najc si'c tiexhä. ");
INSERT INTO zawNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Cuagajcni te bas. Che abadeedni xquixhtiooz loj Dios, badeednini lojreni, gu' guiraareni neṉ basga. ");
INSERT INTO zawNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Dxejcti räjp Jesús lojreni: ―Dee najc si'c xtienä ni ruluii diidx ni biä'nnu, nani guixe' xcuent xhidajl rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Rniliä́pac lojtu, diruna yä'ä bin nani ṟii yejc uub, dxejli yä'äni stehuält loj xcäḻrnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Che gulujx biḻreni te dij xten Dios, biriireni, sääreni nez dajne' ni laa dan Oliib. ");
INSERT INTO zawNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Dxejcru räjp Jesús lojreni: ―Guiraatu sibälaztu narä naguxhijṉ, sa'csi si'c cajni lo guijtz: “Sugu'tä baxhtoor luxh suxuṉ rexiil.” ");
INSERT INTO zawNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Che guibaṉsacä loj rebeṉgut, ganidä cha'a Galilee, dxejcti jiäädtu. ");
INSERT INTO zawNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Dxejc räjp Pedr loj Jesús: ―Palga guiraareni cuälazlu, narä dina cuälazälu. ");
INSERT INTO zawNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Dxejc räjp Jesús lojni: ―Rniliä́pac lojlu, lagajc guxhijṉre, nicla gajd guidgaii cuedxa' tiop huält, luj aguiniilu choṉ huält dilu gumbee narä. ");
INSERT INTO zawNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Luxh laani sanuutis xtiidxni, räjpni: ―Cadro guetlu setäza, dina guiniä dina gumbeälu. Luxh guiraa rexpejṉpacni gunii si'c. ");
INSERT INTO zawNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Dxejcti bidzujṉreni te lajt cadro laa Getsemaní. Dxejc räjpni loj rexpejṉpacni: ―Coḻcuej ree laḻni chanabä lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Dxejcru sanäni Pedr näj Jacoob näjza Juan. Dxejc gusloj cayac-huinduxh lajzni, luxh cayu'ni yäḻrsiaduxh. ");
INSERT INTO zawNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Dxejc räjpni lojreni: ―Cayac-huinduxh lazä, an sugu'tni narä. Coḻjia'n ree, coḻtie'ch bacaḻ. ");
INSERT INTO zawNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Sas gusajni tla', bazuxhijbni lo yuj, dxejcti gunabni lo Dios don la niajc nidedcaj nani sacni dxejc. ");
INSERT INTO zawNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Räjpni: ―Abba, xtadä, luj rajc rujnlu guira'ti: badzucaj retrabajwre loä. Xhet si'cni rlazädi narä, bejn si'cni rlajzlu luj. ");
INSERT INTO zawNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Dxejc biäädni gunaaznireni nagayejsreni. Dxejc räjpni lo Pedr: ―Simón, ¿la nagayejslu? ¿La nicla te rate' diniajcdi nutie'chlu bacaḻ? ");
INSERT INTO zawNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Coḻtie'ch bacaḻ, coḻnab lo Dios, te na'c guntu dojḻ. Lastootu rlajz gutie'chtu bacaḻ, luxh tiejxhtu abadxajg. ");
INSERT INTO zawNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Huij Jesús stehuält, binabni loj Dios, guniini lagajc rediidx ni guniini galoo. ");
INSERT INTO zawNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Dxejcti biädsacni cadro tre'reni, gunazsacnireni nagayejsreni, sa'csi yuduxh bacaḻ lojreni. Luxh direni nidxäl xhi niniireni lojni. ");
INSERT INTO zawNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ni riojṉ huält biäädni, dxejc räjpni lojreni: ―Agojḻ coḻguejs, coḻsilajz, agujc, abidzujṉ oṟ ni ted Xi'n Dios ni gujc Niguii ladzṉaa rebeṉdojḻ. ");
INSERT INTO zawNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Coḻchastie, coḻcho'. Asiäddzuṉgajxh ni guto' narä. ");
INSERT INTO zawNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Canisijcni scree, che bidzujṉ Judas, ni najc te retzubitio'p xpejṉpacni, siädnäni xhidajl bejṉ. Ca'reni spaad, ca'reni yajg biriireni lo rebixhojz nani rnibee, näjza rebejṉ ni ruluii leii, näjza rebeṉgool nani najc guxhtis. ");
INSERT INTO zawNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Niluxh nani ruto' Jesús abadeedni te seen lojreni, räjpni: ―Nani guchagro'ä, ni'c najc laani. Coḻnaazni, coḻyaptzu'tzni te si'c chanätuni. ");
INSERT INTO zawNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Che bidzujṉ Judas, gubigni loj Jesús, räjpni lojni: ―Dad, Dad. Sas bachagro'nini. ");
INSERT INTO zawNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dxejcru gunaazreni Jesús ro'c. ");
INSERT INTO zawNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Dxejc tej reni suga' ro'c, gulää xspaadni, gudiḻguijdxni xmos bixhojz nani sajcru, batiu'ni diajgni. ");
INSERT INTO zawNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Dxejc räjp Jesús loj rebejṉ: ―¿La siädxhiitu narä con spaad näjza garo't si'c rixiitu te gubaan? ");
INSERT INTO zawNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Guiraa dxej guyu'ä lojtu neṉ guidoo, caguluiätu xtidx Dios luxh ditu niniaaztu narä. Scree cayajcni, te soob diidx ni caj lo reguijtz. ");
INSERT INTO zawNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Dxejcru rexpejṉpacni gulälazrenini, baxuṉtireni. ");
INSERT INTO zawNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Sanajlza te bi'n Jesús, nadejbni ganaxhtis te bariaad. Si'c gunaazrenini. ");
INSERT INTO zawNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Dxejcti baxuṉni, libasa'nni bariaadga, sä'tini xhabäälni. ");
INSERT INTO zawNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Dxejc biädnäreni Jesús loj bixhojz ni sajcru. Bidojp rebixhojz nani rnibee, näj rebeṉgool ni najc guxhtis, näjza rebejṉ ni ruluii leii. ");
INSERT INTO zawNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Luxh Pedr zijt zijt sanajlni Jesús. Che bidzujṉtini lo xle' bixhojz ni sajcru, gurenäjni rebejṉ nani rajp ro'c, cagucha' lajzni lo bajl. ");
INSERT INTO zawNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Rebixhojz nani rnibee, näjza guiraa rebeṉgool ni najc guxhtis, caguiilreni xhi tej xquej Jesús nidxälreni, te nugu'treni Jesús, xhet bidxäldireni. ");
INSERT INTO zawNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Xhidajl bejṉ gunii didxxhii, räjpreni et laadi rujn Jesús, niluxh di xtiidxreni nile', sa'csi garen garen guniireni. ");
INSERT INTO zawNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Dxejc huisulii gaii bejṉ ni guniireni stee didxxhii xcuent Jesús, räjpreni: ");
INSERT INTO zawNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Nuunu biejn diaagnu guniini: “Sutiexhä xyu' Dios ni guc-chee con ṉaa rebejṉ, luxh choṉtis dxej guncheä steeni, ni nac-chee et con ṉaadi rebejṉ.” ");
INSERT INTO zawNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nicla si'c di xtiidxreni nile', sa'csi garen garenza guniireni. ");
INSERT INTO zawNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Dxejcti huisulii bixhojz ni sajcru galäii guiraa rebejṉ, gunabdiidxni loj Jesús räjpni: ―¿La digacdi guiniilu xhi guiniilu xcuent requej ni cabe'c reniguiire, ä? ");
INSERT INTO zawNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Laani niäuutis ro'ni, xhet guniidini. Dxejcti gunabdidxsac bixhojz ni sajcru lojni, räjpni: ―¿La luj ni najc Crist, xi'n Dios nani rliä'p bejṉ xpala'nni, ä? ");
INSERT INTO zawNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Dxejcti räjp Jesús lojni: ―Naräni. Suhuiitu loä, Xi'n Dios nani gujc Niguii, sobga'ä xladbee Dios ni rnibee, siäläza neṉ reza ni tre' xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Dxejcru bixhojz ni sajcruga, batiäjsni tla' xhajbni, räjpni: ―¿Xhi jienrunu guidiilnu diidx xcuentni? ");
INSERT INTO zawNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Abiejn diajgtu xho guniyajni Dios. N̲aja', ¿xhi najtu? Dxejcti guiraareni räjp nungäjḻpac guetni. ");
INSERT INTO zawNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Dxejc yu' reni gusloj cagutiobxhejn lojni, luxh basäuureni lojni, dxejc huääzrenini, räjpreni lojni: ―Gunii, ¿chuni'c huääzlu? Luxh renani canäjni gudajp lojni. ");
INSERT INTO zawNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Dxejc suga' Pedr lo yuj, nez lo le'ga, che biääd te xcriaad bixhojz ni sajcru. ");
INSERT INTO zawNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Luxh bahuiini cagucha' lajz Pedr, cadxelojni lojni. Dxejcti räjpni: ―Näj luj nadxaaglu Jesús ni siääd Nazare't. ");
INSERT INTO zawNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Dxejc Pedr basgueeni, räjpni: ―Dina gumbeäni. Dizana ganä xhini'c caniilu. Dxejcti biriini sääni ro' suaan. Dxejcti guredxa' guidgaii. ");
INSERT INTO zawNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Dxejc bahuisac criaadga lojni, räjpni loj renani suga' ro'c: ―Niguiire najc laa tejreni. ");
INSERT INTO zawNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Luxh laani basgueeni stehuält. Che gojl stera't, räpsac renani suga' ro'c loj Pedr: ―Guliipacni näj luj najclu tejreni, sa'csi beṉ Galileelu, luxh guyasi riejn rniilu si'c rnii rebeṉ Galilee. ");
INSERT INTO zawNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Dxejc gusloj canii Pedr: ―Dios gun castiigw narä palga xhet guliidi ni caniä. Dios najc testiigw, dina gumbeä niguii nani caniitu. ");
INSERT INTO zawNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Dxejcti barojp huält guredxa' guidgaii. Dxejc banalajz Pedr nani räjp Jesús lojni: “Che gajdli guidgaii cuedxa' tiop huält, luj gacla choṉ huält aräjplu dilu gumbee narä.” Dxejc guslojni cayoonni. ");
INSERT INTO zawNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Che bara yääl bidxaag sa' rebixhojz ni rnibee, näj rebeṉgool ni najc guxhtis, näjza rebejṉ ni ruluii leii, näjza guiralii reguxhtis. Dxejcti gusloj cachaagreni diidx xho gunreni. Baliibreni Jesús, sanätirenini, niluxh badeedrenini loj Pila't. ");
INSERT INTO zawNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Dxejc gunabdiidx Pila't loj Jesús räjpni: ―¿La luj ni najc ṟeii xten rexpejṉ Israel, ä? Räjp Jesús lojni: ―Si'cni guniilu, si'c najcni. ");
INSERT INTO zawNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Dxejc gusloj rebixhojz nani rnibee cabe'c rexquej Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Gunabdidxsac Pila't lojni: ―¿Xhet rniidilu ä? Ahuii lacti xquejlu cabe'creni. ");
INSERT INTO zawNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bidxeloj Pila't sa'csi nicla si'c xhetru guniidi Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Dxelanijpac rusḻaa Pila't tej rebejṉ ni yu' latzguiib. Rusḻaani chutis te ni rniab rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Lo rebejṉ ni yu' latzguiib nadxaag te niguii ni laa Barrabás. Bagu'tni te bejṉ che nu'chni lo te cuaa bejṉ ni gudiḻnäj gubieer. ");
INSERT INTO zawNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Dxejc bidojp xhidajl bejṉ loj Pila't, gunabreni lojni gunni si'ctis rujnni casob lanij. ");
INSERT INTO zawNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Dxejc gunabdiidx Pila't lojreni, räjpni: ―¿La rlajztu gusḻaä́ ṟeii xten rexpejṉ Israel, ä? ");
INSERT INTO zawNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sa'csi gucbegajcni rdxechlajz rebixhojz loj Jesús, ni'c bateedrenini lojni. ");
INSERT INTO zawNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ni'cni baquiilza rebixhojz ni rnibee rebeṉxhidaal te gäbreni lo Pila't: ―Basḻaa Barrabás loonu lacuaa ni gusḻaalu Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Dxejc räjp Pila't lojreni stehuält: ―¿Xhini'c rlajztu gunnää́ nani rniitu ṟeii xten rexpejṉ Israel? ");
INSERT INTO zawNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Dxejcru guredxa'reni: ―¡Bacuaani lo crujz! ");
INSERT INTO zawNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Dxejc räjp Pila't lojreni: ―¿Xhini'c xhet laati bejnni? Dxejcti laareni rbedxa'rureni: ―¡Bacuaani lo crujz! ");
INSERT INTO zawNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Basḻaati Pila't Barrabás, sa'csi rlajzni nuspaani lajz rebeṉxhidaal. Che gulujx gunibee Pila't, bia Jesús. Bateedti Pila't Jesús loj rexsoldaadni, te xcajni loj crujz. ");
INSERT INTO zawNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Dxejc huinä rexsoldaadni Jesús neṉ Pretoor, yu' cadro rujnreni yäḻguxhtis, ro'c batojpreni guiraa resa'reni. ");
INSERT INTO zawNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Dxejcti bashuajcwreni Jesús te lad moraad, bencheereni te coroṉ guejch basäḻreni yejcni. ");
INSERT INTO zawNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Guslogajc caguxhi näjrenini, caniireni lojni: ―¡Coḻguiliä'p xpala'n ṟeii xten rexpejṉ Israel! ");
INSERT INTO zawNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Batiäjlreni te yabixhijḻ yejcni, batiobxhejnreni lojni, luxh guzuxhijbreni te rajṉrenini. ");
INSERT INTO zawNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Che gulujx basacsíreni Jesús, gulääreni lad moraad ni najcwni, sas bashuajcwrenini xhajbpacni. Gulägajcreni Jesús te cuaarenini lo crujz. ");
INSERT INTO zawNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Te niguii ni laa Simón, ni siääd Cirene, sadejd ro'c, bazajni lo nejz. Niguiire najc xtad Alejandro näjza Rufo. Che sadejdni nejzga, la fuerz basguurenini xcrujz Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Dxejcti huinäreni Jesús cadro laa Gólgota, nani säloj: dan Calabeer. ");
INSERT INTO zawNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ro'c badeedreni lo Jesús bin nani nu'ch mir lojni, dxejc laani naaddini niä'ni binga. ");
INSERT INTO zawNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Che gulujxti bacuaareni Jesús loj crujz, gudzujtreni yejc rexhajbni, te don xhini'c xca' tejgareni. ");
INSERT INTO zawNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Agujc choṉ oṟ gulejn gubijdx che bacuaareni Jesús lo crujz. ");
INSERT INTO zawNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Letreer cadro bacuaareni xtojḻni scree bejnrenini: “R̲eii xten rexpejṉ Israel.” ");
INSERT INTO zawNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bacuaazareni lo stiop crujz tiop gubaan, tejni xladbee Jesús, xtee xladbäjgwni. ");
INSERT INTO zawNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Dxejc guzojb diidx ni caj loj guijtz nani rnii: “Loj rebeṉguijdx bigabni.” ");
INSERT INTO zawNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Luxh renani sadejd nejzga guniyajreni Jesús, cagusniibreni yejcreni, räjpreni lojni: ―¡Jaa! Luj nutiejxhlu guidoo luxh choṉtis dxej niunchesacluni. ");
INSERT INTO zawNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","N̲aj basḻaa lagajc luj, biäjt loj crujzga. ");
INSERT INTO zawNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Näjza rebixhojz ni rnibee, näj rebejṉ ni ruluii leii, baxhiznärenini, räjp loj sa'reni: ―Ste'ca bejṉ rusḻaani, xhoxh digacdi gusḻaani lagajc laani. ");
INSERT INTO zawNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","N̲aj sujiäjt Cristre, ṟeii xten rexpejṉ Israel, lo crujz te guihuiinu, te chalilaaznu. Näj regubaan ni caj lo crujz guniyajzareni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Che gojḻ läidxej, bicäjy si'cti choṉ oṟ. ");
INSERT INTO zawNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Che gudejd choṉ oṟga, guredxa' Jesús dipro, räjpni con xtiidxni: ―Eloi, Eloi, ¿lama sabactani? ―dee säloj: Xtiozä, Xtiozä, ¿xhicuent gulälazlu narä? ");
INSERT INTO zawNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Biejn diajg gaii bejṉ ni suga' ro'c räjpni si'c, dxejc räjpreni: ―Coḻcuadiajg, Elías cabejdxni. ");
INSERT INTO zawNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Sas baxuṉ tejni, bahuajdxni te sponj loj binagr. Dxejcru basäḻnini yejc te yabixhijḻ, badeednini loj Jesús te yänini, räbgajcni: ―Coḻgusaan guihuiinu don la siädläjd Elíasni loj crujz. ");
INSERT INTO zawNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Dxejcru guredxaduxh Jesús, gujttini. ");
INSERT INTO zawNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Dxejc lajd ni najḻ neṉ guidoro biräjsni, gujcni tiop la', jiaali lo yujli. ");
INSERT INTO zawNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Suga' capitán nani rnibee te gayuu soldaad nez loj Jesús, luxh che bahuiini xho guredxa' Jesús scree näj xho gujtni, räjpni: ―Guli'pacni, niguiire najc Xi'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Suga'za gaii gunaa, zijt cadxelojreni. Lojreni yu' Marii Magdaleṉ, näj Marii, xnan Jacob ni najc huinru, näjza José, näjza Salomee. ");
INSERT INTO zawNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Che guyu' Jesús Galilee birinajl regunaare Jesús, luxh bahuiirenini. Yu'za xhidajlru regunaa ni biädnajl Jesús che biäädni Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Biu' gudxhijṉ, luxh najcni dxe bispr che rusucheereni par sabd, dxej ni rusilajz rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Biääd José ni siääd Arimatea, najcni te rebejṉ ni sajc loj reguxhtis. Näjza laani cabäjzni xcäḻrnibee Dios. Guideb yäḻnabajṉ gunabni tiexh Jesús lo Pila't. ");
INSERT INTO zawNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bidxelo Pila't alagujt Jesús, sas gurejdxni capitán ni rnibee tej gayuu soldaad, gunabdiidxni lojni la balagujt Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Che räjp capitánga lojni agujt Jesús, dxejc badeed Pila't tiexh Jesús loj José. ");
INSERT INTO zawNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Agusii José te bariaad, luxh che gulätni Jesús lo crujz, batejbnini neṉ bariaadga. Dxejc gudixhni Jesús neṉ te biliää ni caj cuä' te guilaj, dxejcru batzugni te guiro ro' biliääga. ");
INSERT INTO zawNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Bahuii Marii Magdaleṉ näj Marii xnan José cadro biga'tz Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Che gudejd sabd, dxej ni rusilajz rexpejṉ Israel, Marii Magdaleṉ näj Marii xnan Jacoob näjza Salomee gusii setnejxh te chatääbreni se'tga tiexh Jesús. ");
INSERT INTO zawNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Che biu' xmaan, rsildooru, che calejn gubijdx, biäädreni ro' xpaani. ");
INSERT INTO zawNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Cayäjp loj sa'reni: ―¿Chu gudzucaj guiroga ro' xpaani te jiu'nu? ");
INSERT INTO zawNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Che gudixhlojreni, bahuiireni alagubicaj guijga, luxh najcni te guiroduxh. ");
INSERT INTO zawNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Che biu'reni neṉ biliääga, bahuiireni lo te bi'n sobga' ladbee neṉ biliääga. Najcw bi'nga te ladnol ni najc siool. Dxejc bidxejb regunaaga. ");
INSERT INTO zawNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Dxejcti räjp bi'nga lojreni: ―Na'c guidxejbtu. Caguiiltu Jesús ni siääd Nazare't, nani cuaj lo crujz. Rutiruni ree. Agubajṉni lo rebeṉgut, coḻtahuii cadro gudixhreni tiejxhni. ");
INSERT INTO zawNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Coḻchäj, coḻchaye'tz lo rexpejṉpacni, loj Pedr, ganidla Jesús guidzujṉ Galilee, dxejcti guidzujṉtu. Ro'c fiitu lojni, si'cni guniini lojtu. ");
INSERT INTO zawNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Biriitireni ro' biliääga, racsejslireni sa'csi cadxejbreni. Rut lojdi guniidireni sa'csi cadebduxhreni. ");
INSERT INTO zawNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Gubajṉ Jesús loj rebeṉgut rsildooru che biu' xmaan. Baluilojni galoo loj Marii Magdaleṉ, nani agacgulääni gajdz beṉdxab neṉ lastooni. ");
INSERT INTO zawNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Dxejcti huij Marii Magdaleṉ, huiye'tzni loj renani cuansanäj Jesús, renani cayac-huin lajzni, cayoonreni. ");
INSERT INTO zawNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Che biejn diajgreni ahuäzsac Jesús lo rebeṉgut, luxh Marii abahuii lojni, di lajzreni nilii. ");
INSERT INTO zawNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ste'ca najc Jesús baluilojni loj tio'p renani sasaj sääreni lo nejz. ");
INSERT INTO zawNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Dxejcti gubi'reni, huiye'tzreni loj sgaiiga, luxh nicla xtidx reni'c di lajzreni nilii. ");
INSERT INTO zawNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Lult baluilojni loj guitzubiteebreni che sobga'reni lo mex. Gudidxa' Jesús lojreni, sa'csi di lajzreni nilii luxh guyaa lajzreni. Di lajzreni nilii xtidx renani bahuii loj Jesús che gubaṉgajcni loj rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Räjp Jesús lojreni: ―Coḻchäj guideb lo guedxliuj, coḻnii xtidx Dios lo guiraa rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nani chalilajz luxh tiobnisni, siḻiaani loj dojḻ; biäda nani di lajzni chalii sinijtni lo dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Niluxh remilagwre jiannäj renani chalilajz: sibääreni beṉdxab xcuentä; siniireni ste'ca diidx; ");
INSERT INTO zawNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","guiniaazreni bäḻ con ṉaareni; masque yäreni xhicos ni rugu't bejṉ, xhet gacdireni; susujreni ṉaareni yejc rebeṉracxhuu luxh siajc rebeṉracxhuu. ");
INSERT INTO zawNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Gulujxti gunii Dad Jesús si'c lojreni. Dxejc huäjsni sääni xhaguibaa. Ro'c huicueni cuä' Dios ladbee. ");
INSERT INTO zawNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Dxejcti laareni bire'chreni, guniireni xtidx Dios guiranejz. Lagajc Dadga gucnäjreni, bejnni milagwr te gucbee bejṉ laapac xtidx Dios ni caniireni. Sugacni si'c.");
INSERT INTO zawNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Xhidajl bejṉ abacuaa lo guijtz xcuent guiraa redzuun ni gujc nez loonu te cuäxnejzreni redzuunga ");
INSERT INTO zawNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","si'cpac ni biääd rediidxga loonu. Rebejṉ nani bahuiloj guiraa recosre cheni guslojlireni, näjza reni gucnäj basule' xtidx Dios najc renani basule' rediidxga loonu. ");
INSERT INTO zawNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Luxh sa'csi abiḻä, abahuiloä, abenduxhä xhigab xcuent guiragajc ni gusajc che gusoblojlini, ni'c runä xhigab laaca gucuaä rediidxre, xnejz-xnejzni lo guejblu, Dad Teófilo, ");
INSERT INTO zawNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","te gacbesa'c guejblu ni najc didxlii xcuent guiraa rediidx ni abisieed guejblu. ");
INSERT INTO zawNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Cheni gujc Herodes ṟeii xten región Judea, guyu' te bixhojz ni laa Zacarías, ni nadxaag lo rexpejṉ Abías. Chäälni laa Elisabe't, ni najcza te xagdoo bixhoz Aarón. ");
INSERT INTO zawNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Guiro'preni najcreni nadolajz nez loj Dios, rusoobreni xtidx Dios näjza xleii Dios, ni'c digacdi gucuaquij bejṉreni xcuent nicla tej dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Luxh ruti xi'nreni, sa'csi chäälni digacdi chu xi'nni. Luxh guiro'preni anajcreni beṉgool. ");
INSERT INTO zawNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Te dxej, laḻ ni cayujn Zacarías dzuun neṉ guidoro si'c bixhojz nez loj Dios, ");
INSERT INTO zawNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","dxejc con daad bibee chuni'c jiu' neṉ yudxan xten guidoro te guze'creni yaal si'cni najc costumbr xten rebixhojzga. Dxejc si'c gulereni Zacarías gunni. ");
INSERT INTO zawNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Laḻ ni caguze'cni guxhyaal, suga' guiraa rebejṉ lo xle' guidoro, cabedx-canabreni lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Dxejcti baluiloj te xangl Dios lo Zacarías, suliini ladbee lo dxan cadro cayejc guxhyaal. ");
INSERT INTO zawNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Che bahuii Zacarías lo xangl Dios, di jien xhi gunni, lacti bidxebduxhni. ");
INSERT INTO zawNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Sas xangl Dios räjp lojni: ―Na'c guidxejblu, Zacaríi, sa'csi Dios abiejn diajgni xtiidxlu, luxh su' te xi'n chäälu, Elisabe't; cuälajluni Juan. ");
INSERT INTO zawNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Sibalazduxhlu, siroob lastoolu; xhidajl bejṉ sibalajz sa'csi gaalni, ");
INSERT INTO zawNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","sa'csi beṉro gac xi'nlu nez loj Dios. Dini yä bin, nicla maxcaal. Sibäjz Sprit Dxan xten Dios neṉ lastooni cheni gaallini. ");
INSERT INTO zawNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Sujnni gusiechlajz xhidajl rexpejṉ Israel, guibi'reni lo Gueb Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Juanre sinijdni loj Dad, sujni lagajc xhigab, sajpni lagajc yäḻrnibee ni gojp profe't Elías, te che jiejn diajgreni xtiidxni susiechlajz redad, susiäjḻzareni diidx con rexi'nreni. Sigajcza rebejṉ ni di gusoob xtidx Dios sisieedreni gusoobreni xtidx Dios, te si'c jiädsucheeni lastoo rebejṉ te chalilajzreni xtidx Dad ni jiääd. ");
INSERT INTO zawNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Gunabdiidx Zacaríi loj anglga, räjpni: ―¿Xho mood gacbeä guliilu? Sa'csi anacä beṉgol, sigajcza chälä. ");
INSERT INTO zawNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Dxejcti räjp anglga lojni: ―Narä nacä Gabriel, runä dzuun lo Dios. Laani baxhaḻni narä te guininää́ luj, jiädnää́ didxhueenre lojlu. ");
INSERT INTO zawNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Luxh ṉaj, sa'csi dilajzlu nilii xtidxä, sia'nlu gop, digacdiru guiniilu, cheni gaalli xi'nlu sinisaclu. Rextidxä sisiojb che guidzujṉ dxej che riäjḻ gacni. ");
INSERT INTO zawNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Laḻni cayajc dee, cadxeloj rebejṉ ni suga' nez ro' yudxan cabäjzreni guiṟii Zacaríi sa'csi cayaclaani neṉ yudxan. ");
INSERT INTO zawNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Che biṟii Zacaríi, di niajcdiru niniini loj rebejṉ; dxejc gucbeereni yu' xhi cosro bahuiini neṉ yudxan xten guidoo. Dxejc con seen guninäjni rebejṉga, sa'csi xheti xse'ni te niniini. ");
INSERT INTO zawNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Che gulujx bejnni dzuun neṉ guidoro, gubi'ni rolijzni. ");
INSERT INTO zawNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Che gudejd redxej dxejcti bazeṉ nuu Elisabe't, chäälni, bäz, gaii bäii diruni niṟii rolijzni. Bejnni xhigab, räjpni: ");
INSERT INTO zawNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Si'c bejn Dad Dios narä ṉaj, gucnäjni narä te diru bejṉ cuälaz narä sa'csi ruti xi'nä.” ");
INSERT INTO zawNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Che gudejd xho'p bäii, baxhaḻ Dios xanglni Gabriel lo te guedx Galilee ni laa Nazare't, ");
INSERT INTO zawNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","te chahuiini te dxapxteeb ni laa Marii. Agojt xtiidxni te guchṉaani te dade' ni laa José. Dade're najc xagdoo toṟeii David. ");
INSERT INTO zawNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Biu' anglre cadro sobga' dxape'ga, räjpni lojni: ―Xchan, dxa'p ni sanälajz Dios, ni agule Dios loj guiraa regunaa. Dios gacnäjlu. Abenle' Dioslu loj guiraa regunaa. ");
INSERT INTO zawNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Luxh che bahuiini lo xangl Dios bidxelojni lo rextiidxni, rujnni xhigab: “¿Xhicuent caniini si'c loä?” ");
INSERT INTO zawNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Dxejc räjp xangl Dios lojni: ―Na'c guidxejblu, Marii; agule Dios luj. ");
INSERT INTO zawNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Bacuadiajg diidx. Suulu bäz, su' te xi'nlu. Che gaalni guirilajni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Laani sajcni te bejṉ ni sacduxh. Sirilajzani Xi'n Gueb Dios ni yu' xhaguibaro. Gueb Dios sujn gacni ṟeii sigajc ni gujc toxtadgoldooni David, ");
INSERT INTO zawNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","te tejpas guinibeeni loj rexi'n Israel, luxh dipac xcäḻrnibeeni nitloj. ");
INSERT INTO zawNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Dxejc gunabdiidx Marii lo xangl Dios, räjpni: ―¿Xho mood gac dee? Ni dxapxteeb narä, gajd narä gumbeä niguii. ");
INSERT INTO zawNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Badzu' xangl Dios diidxre lojni, räjpni: ―Sprit Dxan xten Dios siääd lojlu, xcäḻrnibee Gueb Dios ni yu' xhaguibaa suhuajcwni luj si'c te za. Ni'cni bäz ni gaal sajcni te beṉdxan, sibälaj bejṉni Xi'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Näjza sa'lu Elisabe't su' te xi'nni luxh anajcni te beṉgool; ni'cni gunaa nani najreni digacdi chu xi'nni agujc xho'p bäii nuuni bäz. ");
INSERT INTO zawNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Xheti te cos ni naganduxhtej nez loj Dios ―räjp Xangl Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Dxejcti räjp Marii: ―Narä nacä xmos Xtadnu Dios; mbaj, sugunnäj Dios narä si'ctisni gunii gueblu loä. Dxejcti biunejz angl xten Dios lojni, sä'tini. ");
INSERT INTO zawNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Neṉ redxejga, basquejn Marii sääni lo te guejdx ni tre' neṉ redajn xten Judea. ");
INSERT INTO zawNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Biu'ni rolijz Zacaríi, guniini xtidxbee loj Elisabe't. ");
INSERT INTO zawNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Che biejn diajg Elisabe't guniini, biniib xi'nni xque'ni, gudxaj Sprit Dxan xten Dios lastoo Elisabe't. ");
INSERT INTO zawNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Dxejc dipduxh guniini räjpni: ―Abenle'ru Gueb Dios luj loj guiraa regunaa. Abenle'zani xi'nlu. ");
INSERT INTO zawNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Chu narä te siädhuii xnan Xtioozä narä? ");
INSERT INTO zawNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Biejntis diagä xtiidxlu, bibalazgajc xi'nä, biniibni xque'ä. ");
INSERT INTO zawNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Sibaa lajzlu, luj ni huililajz sisiojbpac nani gunii Xtadnu Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Dxejc räjp Marii: Xaimä rliä'p xpala'n Xtadnu Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Rbalazduxhza lastoä xcuent Dios ni rusḻaa narä lo dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Sa'csi agule Dios narä, nacä te mos gunaa ni xhet sajcdi, luxh ṉajli sinii rebejṉ näjza reni churu chu lo guedxliuj, chicbaani loj guiraa regunaa. ");
INSERT INTO zawNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Sa'csi Gueb Dios ni rajp guiraa yäḻrnibee abejn xhidajl cosro loä, dxanduxh najc lajni. ");
INSERT INTO zawNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Dini cuääz gulaslajzni guiraa rebejṉ ni riu xtiidxni, reni rajṉni. ");
INSERT INTO zawNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Xhidajl cosnagajn abejnni con lagajc ṉaani, abatie'chni renani rustioob lastooreni rliä'p lagajc xpala'nreni. ");
INSERT INTO zawNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Abasajbni reni rnibee, per rebeṉnadolajz bejnni gacreni beṉro. ");
INSERT INTO zawNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Bachajni xque' reni calaan, badeedni ganax cossa'c, niluxh badzu'ni rebejṉ ni yu' xhixtenreni xhet badeed dini lojreni. ");
INSERT INTO zawNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Gucnäjni nacióṉ xten xpejṉ Israel, ni najc xmos Dios. Di lajzni niäḻ nulaslajznireni ");
INSERT INTO zawNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","sa'csi si'c bia'nni diidx con retoxtadgoldoonu, sinuu gulazlajzni toAbram näjza rexagdooni par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Dxejc bia'n Marii rolijz Elisabe't si'cti choṉ bäii, dxejc gubisacni rolijzni. ");
INSERT INTO zawNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Che baza' xpäi Elisabe't, dxejc gojl xpäzni te bäz niguiini. ");
INSERT INTO zawNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Dxejc bidzujṉ rexpisiṉni näjza resa'ni biädhuiireni guiro'preni che gucbeereni lacti hueen gujc Dios con laani. Bibalaznäjrenini. ");
INSERT INTO zawNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Che gudejd xhujṉ dxej, huinäreni bäze'ga chuni bee. Rlajz rebejṉ nirilaj bäze'ga si'c laa xtadni, Zacaríi. ");
INSERT INTO zawNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Niluxh xnanni räjp: ―Na'c, guirilajpacni Juan. ");
INSERT INTO zawNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","―¿Xhicuent? ―räjpreni―. Ruti xfamiḻlu ni laa si'c. ");
INSERT INTO zawNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Dxejcti gunabdiidxreni con seen lo xtad bäze'ga te gacbeereni xho rlajzni guirilaj bäze'ga. ");
INSERT INTO zawNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Xtadni gunab te la' guijtz, dxejc bacuaani: “Lajni najc Juan.” Dxejc guiraareni bidxelojreni. ");
INSERT INTO zawNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Luxh lagajc dxejc gujc gunii Zacaríi stehuält, dxejc guslojni calä'pni xpala'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bidxeloduxh rexpisiṉreni xhini'c gujc ro'c. Luxh bire'ch diidx xcuent recosre guideb neṉ redajn xten Judea. ");
INSERT INTO zawNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Guiraa reni biejn diajg rediidxga gusloj cayujnreni xhigab, dxejc gunabdiidxreni loj sa'reni: ―¿Chuchani'c gac biuxe'ga? Si'c guniireni sa'csi huenliisi abenle' Diosni. ");
INSERT INTO zawNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Dxejcti biääd Sprit Dxan xten Dios neṉ lastoo xtadni Zacaríi, gusloj caniini rediidx ni badeed Dios lojni, räjpni: ");
INSERT INTO zawNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Guiliä'pnu xpala'n Dios, Xtios rexpejṉ Israel, sa'csi abiädhuiini loonu, ni najcnu rexpejṉni, te siädgusḻaani nuurnu neṉ dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Abaxhaḻni loonu te bejṉ ni rajp yäḻrusḻaduxh bejṉ neṉ dojḻ. Najcni te rexagdoo toxmosni David. ");
INSERT INTO zawNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Lagajc si'cni badeed Dios gunii redade' ni bacuaa xtiidxni lo guijtz galoo: ");
INSERT INTO zawNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Susḻaani nuurnu loj reni rdxe'ch loonu, näjza ladzṉaa rebejṉ ni gulälaz nurnu. ");
INSERT INTO zawNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Te gulaslajzni retoxtadgoldoonu, te soob diidx ni bia'nni con rebejṉga. ");
INSERT INTO zawNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Scree bia'nni diidx con toxtadgoldoonu, Abram: ");
INSERT INTO zawNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Susḻaani nuurnu ladzṉaa rebejṉ ni rdxe'ch loonu, te na'c guidxeebnu chunu lojni gusoobnu xtiidxni, ");
INSERT INTO zawNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","con yäḻnabaṉsa'c näjza yäḻguxhtis guiraa redxej ni guibajṉnu. ");
INSERT INTO zawNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Luxh luj, bäze', sirilajlu dade' nani rnii xtidx Gueb Dios ni yu' xhaguibaa, sa'csi sinijdlu lo Dad te gusucheelu rexnezyulajzni, ");
INSERT INTO zawNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","te gunlu gacbee rexpejṉni xho gac ḻaani lo dojḻ, te gac guibicaj xtojḻreni. ");
INSERT INTO zawNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Sa'csi Dios sanälajz bejṉ, näjza rulaslajzni bejṉ ni'cni xhaguibaali suxhaḻni xi'nni te jiädnäni te dxecoob, ");
INSERT INTO zawNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","te gusanijni lo rebejṉ ni nabajṉ lo yäḻxcäjy xten dojḻ, näjza rebejṉ ni nabajṉ lo xpalaa yäḻgujt, te guluiini xho sánu lo xnez yäḻrbecdxilajz. ");
INSERT INTO zawNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Dxejc gunís biuxe'ga, guyuduxh xcäriejnni xcuent recos xten Dios. Gubajṉni nez loj reyubijdz cheni bidzujṉli dxej che baluilojni loj rexpejṉ Israel, che gusloj cagusule'ni xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Neṉ redxejga, gunibee Augusto César xcaj laj rebejṉ guideb guedxliuj lo xquijtzni. ");
INSERT INTO zawNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ni'c nacobgujc yäḻbigabre cheni najc Cirenio gobernadoor xten Siria. ");
INSERT INTO zawNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Guiraa rebejṉ nanab chääreni lagajc lajdxreni te ro'c guigabreni. ");
INSERT INTO zawNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ni'cni biṟii José guedx Nazare't Galilee, te huijni Judea, lo guedx Belén, cadro gojl toDavid, sa'csi najc José xagdoo toDavid. ");
INSERT INTO zawNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Huinäni Marii, nani guchṉaani, huijreni guedx Belén te ro'c guigabreni. Luxh nuu Marii bäz. ");
INSERT INTO zawNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Lalsi yu'reni guedx Belén, bidzujṉ dxej ni gaal xi'n Marii. ");
INSERT INTO zawNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ro'c gojl xi'n galooni, dxejc batejbnini te xzuudni. Dxejc gudixhnini cadro rusäḻreni guijxh rajw reguidxaa sa'csi xhetiru yu' xcalaareni jia'nreni. ");
INSERT INTO zawNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Gajxh guejdxga guyu' gaii baxtoor cayajpreni xhiilreni lo niaa guxhijṉ. ");
INSERT INTO zawNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Chela baluiloj te xangl Dios, luxh bianij guideb gabireni con yäḻrdimbicha' xten Dios, dxejc bidxebduxhreni. ");
INSERT INTO zawNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Sas anglga räjp lojreni: ―Na'c guidxejbtu, narä siädnää́ lojtu te didxsa'c ni suspalajz guiraa beṉ guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","N̲adxej gojl neṉ guejdx xten toDavid, tej ni gusḻaa bejṉ neṉ dojḻ, laani najc Crist ni najc Dad. ");
INSERT INTO zawNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Dee najc te seen lojtu, sidxältu bäze'ga nadejbni neṉ te xzuudni, naga'ni cadro rusäḻreni guijxh rajw reguidxaa. ");
INSERT INTO zawNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Lagajc dxejc guideb gabi anglga baluiloj naclejn xangl Dios, gulä'preni xpala'n Dios, räjpreni: ");
INSERT INTO zawNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Coḻlä'p xpala'n Dios ni yu' xhaguibaali. Suchu yäḻrbecdxilajz lo rebeṉ guedxliuj ni balazlajzni. ");
INSERT INTO zawNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Che gubi' rexangl Dios xhaguibaa, gusloj rebaxtoor canii loj sa'reni: ―Coḻcho' guedx Belén coḻchohuii ni guzajc ro'c ni gunii Xtadnu Dios loonu. ");
INSERT INTO zawNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Rusquenduxhreni sääreni, dxejc bidxälreni Marii näjza José näjza bäze' ni naga' neṉ cadro rusäḻreni guijxh rajw reguidxaa. ");
INSERT INTO zawNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Cheni bahuiireni loj rebejṉga, bijreni diidx xhi räjp rexangl Dios lojreni xcuent bäze'ga. ");
INSERT INTO zawNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Niluxh guiraa reni biejn diajg rediidxre bidxeloduxhreni xtidx rebaxtoorga. ");
INSERT INTO zawNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Niluxh Marii gulucheeni guiraa rediidx ni biejn diajgni neṉ lastooni, rujntisni xhigab xcuent rediidxga. ");
INSERT INTO zawNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Dxejcti rebaxtoorga gubisacreni cayoḻreni, calä'pzareni xpala'n Dios xcuent guiraa rediidx ni biejn diajgreni näjza ni bahuiireni sa'csi guiraani gujc si'cni räjpreni lojreni. ");
INSERT INTO zawNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Che gudejd xhujṉ dxej, huinäreni bäze'ga chuni bee, dxejc gulälajrenini Jesús, lagajc laj ni räjp xangl Dios loj Marii guirilajni galooli guuni bäzga. ");
INSERT INTO zawNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Che basa' redxej ni gac naya te nan si'cni gunibee toMoisés loj xquijtzni, huinäjreni bäze'ga guedx Jerusalén, neṉ guidoro gunabreni gacnäj Diosni par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bejnreni scree sa'csi caj lo guijtz xten Dios: “Guiraa rexingangaloo xten bejṉ guilia'tu lo sa'reni te gunreni xtzunä”, räjp Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bidzujṉreni ro'c ca'reni te gojn si'cni rnibee rexquijtz Dios: “Tio'p gugue' o tio'p palombäz.” ");
INSERT INTO zawNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Neṉ redxejga, neṉ guedx Jerusalén rbäjz te dade' ni laa Simeón. Najcni te beṉsacduxh, raṉduxhni Dios, cabäjzni jiääd te bejṉ ni gusḻaa rexpejṉ Israel. Rbäjz Sprit Dxan xten Dios neṉ lastoo Simeón. ");
INSERT INTO zawNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Sprit Dxan abejn gacbeeni dini guet ansde fiini loj Crist ni guxhaḻ Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Dxejcti räjp Sprit Dxan xten Dios lojni chääni guidoro. Laḻni yu'ni neṉ guidoo, bidzujṉ José con Marii, biädnäreni bäz Jesús, te gunnäjreni Jesús nani rnibee xtidx Dios gunreni. ");
INSERT INTO zawNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Dxejc gudääz Simeón bäze'ga, gusloj calä'pni xpala'n Dios, räjpni: ");
INSERT INTO zawNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Dad, asajc gusaanlu guetä con yäḻrbedxilajz, sa'csi abasooblu nani bia'n diidx gunnäjlu xmoslu. ");
INSERT INTO zawNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Sa'csi abahuiloä nani siädgusḻaa nuurnu neṉ dojḻ, ");
INSERT INTO zawNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ni abasujlu nez loj guiraa rebeṉ guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Laani najc bianij ni susanij loj rebejṉ ni di gac xpejṉ Israel, näjza nani gac xpala'n rexpejṉlu guedx Israel, lajdxlu. ");
INSERT INTO zawNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Bidxeloj José näjza xnan Jesús rediidx ni canii Simeón xcuent bäze'ga. ");
INSERT INTO zawNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Dxejc benle' Simeón yejcreni, dxejc räjpni lo Marii xnan Jesús: ―Bahuii gan; bäze're biääd te loj rexpejṉ Israel chu reni sibälaz xtiidxni, te chuza reni sililajz xtiidxni. Laani gacni te seen nani sibälaz bejṉ, ");
INSERT INTO zawNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","te si'c jienloj xhi xhigab rujn cade tej rexpejṉ Israel neṉ lastooreni. Dxejcti par luj sajcni asdoo chääz te spaad lastoolu, sa'csi gac-huinduxh lastoolu. ");
INSERT INTO zawNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Suga'za te nane' ni laa Ana ro'c, rniini xtidx Dios xcuent recos ni churu gac. Najcni xindxa'p Fanuel, ni najc famiḻ xten Aser. Anajcni beṉgolduxh. Bachṉaani che najcni dxaphuin, luxh gajdztis ijz guläznäjni chäälni che bia'nni biuud. ");
INSERT INTO zawNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Najcni te gunabiuud ni yu' tajbitajp ijz. Diruni guirii guidoro, ro'ctis yu'ni dxej, yääl te yu'tisni lo Dios con yäḻrucua'n näjza yäḻrbedx-rniab lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Che gubigni lojreni lagajc dxejc, badeedni xquixtios lo Dios sa'csi abidzujṉ tej ni gusḻaa rebejṉ lo dojḻ. Dxejc gusloj caniini diidx xcuent bäz Jesús loj guiraa renani cabäjz yäḻrusḻaa xten Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Che gulujx bejn xcuzajnni guiraa recos ni caj lo xquijtz Dios gunreni, gubisacreni Galilee, lo guedx Nazare't, lajdxreni. ");
INSERT INTO zawNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Gunís biuxe'ga, guc nadaanni, guc nasiṉruzani sa'csi cayacnäj Diosni. ");
INSERT INTO zawNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Casob ijz rij rexcuzajn Jesús guedx Jerusalén te rinäreni te gojn xten lanij pascw. ");
INSERT INTO zawNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Che basa' Jesús tzubitio'p ijz, huij guiraareni guedx Jerusalén si'c najc costumbr gac lanijga. ");
INSERT INTO zawNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Che gulujx lanijga, gubisacreni. Bia'n Jesús guedx Jerusalén, luxh nicla xnanni niclaza José direni niacbee bia'nni. ");
INSERT INTO zawNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bejnreni xhigab pet siädsanäjni rebeṉsa'ni. Si'c guzajreni tebdxej, dxejc gudiilrenini loj resa'reni, näjza loj reni rumbeereni, ");
INSERT INTO zawNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","direni nidxälni. Dxejc gubisacreni guedx Jerusalén te huitiilrenini ro'c. ");
INSERT INTO zawNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Choṉ dxej gudiilrenini dxejc bidxälrenini neṉ guidoro, sobga'ni nez galäii rebejṉ ni najn leii, cacuadiajgni xtiidxreni, cayujnzani yäḻgunabdiidx lojreni. ");
INSERT INTO zawNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Luxh guiraareni cacuadiajg xtiidxni, cadxeloduxhreni yäḻnajn xtenni, näjza rediidx ni cagudzu'ni lojreni. ");
INSERT INTO zawNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Che bahuii rexcuzajnni lojni, bidxelojreni. Dxejc räjp xnanni lojni: ―Xi'nä, ¿xhicuent bennäjlu nuurnu scree? Narä näjza xtadlu cayunduxhnu xhigab caguiilnu luj nezree, nezre'c. ");
INSERT INTO zawNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Dxejcti räjp Jesús lojreni: ―¿Xhicuent caguiiltu narä? ¿La ditu gan riäjḻ gunä xtzun Xtadä, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Luxh laareni direni niacbee rediidx ni guniini lojreni. ");
INSERT INTO zawNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Dxejcti gubinäjnireni guedx Nazare't, sanuuni rusoobni xtiidxreni. Luxh Marii gulucheetisni guiraa recosre neṉ lastooni. ");
INSERT INTO zawNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Duurtis gunís Jesús, caroobruza xcäḻnajnni. Sanälajz Diosni, sanälajzza guiraa rebejṉni. ");
INSERT INTO zawNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Neṉ redxej cheni agujc tzuun ijz najc Tiberio César ṟeii, Poncio Pila't najc gobernadoor xten Judea; Herodes najc gobernadoor xten Galilee; Felipe, bejtz Herodes najc gobernadoor xten Iturea näjza Traconite; Lisanias najc gobernadoor xten Abilinia. ");
INSERT INTO zawNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Lagajc neṉ redxejga Anás näjza Caifás najc rebixhojzro xten guidoro guedx Jerusalén. Neṉ redxejga biääd xtidx Dios lo Juan, xi'n Zacaríi cheni rbäjzni nez lo reyubijdz. ");
INSERT INTO zawNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ni'c cuanzaj Juan guideb nez reyuj xten gueu Jordán, ro'c basule'ni xcuent yäḻrusiechlajz, yäḻrobnis ni nanab gunreni te gudzucaj Dios xtojḻreni. ");
INSERT INTO zawNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Si'cni caj lo xquijtz Isaías, dade' ni gunii xtidx Dios, cadro räjpni: Riejn xse' te ni rbedxa' nez loj reyubijdz: “Coḻyunsa'c xnezyuj Dad, coḻslii rexnezyulajzni.” ");
INSERT INTO zawNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Guiraa cadro sojb gueed sidxe'ni, guiraa relom̲ sibicajreni, guiraa renezyuj ni xhet naliidi, siliireni, guiraa renezyudxuudx, sacsa'creni. ");
INSERT INTO zawNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Dxejcti guiralii bejṉ suhuii loj nani guxhaḻ Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Che bahuii Juan siääd xhidalduxh bejṉ te guirobnisreni, räjpni lojreni: ―¡La'tu beṉguijdx ni najc si'c bäḻnialajz! ¿Chuni'c balijdxtu guxuṉtu loj xcäḻrdxe'ch Dios ni siädgajxh, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Coḻguchaa xmoodtu te si'c fii bejṉ guliini abasiechlajztu. Na'c cuentis rniitu lagajc neṉ lastootu “Abram najc xtadnu”, sa'csi narä rniä lojtu, sajc xca' Dios reguijre te con laareni guncheeni bejṉ gac rexagdoo toAbram. ");
INSERT INTO zawNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Aguibyajg naga' cuä' xlobaa reyajg; ni'cni guiraa reyajg nani di ninexhsa'c xcaj lojni, sidinreni te checreni. ");
INSERT INTO zawNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dxejcti gunabdiidx rebejṉ lojni, räjpreni: ―¿Xhini'c nanab jiennu? ");
INSERT INTO zawNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Dxejc badzu' Juan diidxre räjpni: ―Ni rajp tio'p xhajbni, sugudeedni tejni lo bejṉ ni xhet rajpdi. Sigajcza gun reni rajp xhi gaureni, quisrenini loj ni xheti xhi gauni. ");
INSERT INTO zawNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Näjza gaii bejṉ nani rusquijx xcuent reimpuest bidzujṉ lojni te guirobnisreni, dxejc gunabdiidxreni lo Juan räjpreni: ―Dad, mastr, ¿xhini'c nanab jiennu? ");
INSERT INTO zawNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Räjp Juan lojreni: ―Na'c gusquijxtu bejṉ maazdi ni nungäjḻ quiixreni. ");
INSERT INTO zawNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Näjza gaii resoldaad gunabdiidx lojni räjpreni: ―¿Nurnu a'? ¿Xhini'c nanab jiennu? Dxejc räjpni lojreni: ―Na'c guchejbtu bejṉ; na'c gäbtu chale'ctu xcäḻquij bejṉ ni xhet bejndi parsi guniidxreni meel lojtu; coḻbalaznäj nani rujntu gaan. ");
INSERT INTO zawNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Cadxeloj rebejṉ, cayujnreni xhigabduxh, naareni, “pet Juan najc Crist ni jiääd.” ");
INSERT INTO zawNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Dxejc badzu' Juan diidxre, räjpni loj guiraa rebejṉ: ―Guliipac rutiobnisä la'tu con nis, luxh siääd tej ni sajcru loä, nani nicla gac surloä, cuää xcura'chni. Laani sutiobnisni con Sprit Dxan xten Dios te cuääzni neṉ lastootu näjza con guiboo, sa'csi rajpruni yäḻrnibee loä. ");
INSERT INTO zawNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Aca'ni pal te gusiani triuu te cuääni triusa'c lo guijxh te cucheeni triuu neṉ ngodx xtenni, dxejcti reguixhtriuuga suze'cnini lo bajl ni rejc par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Rediidxre näjza xhidajl yäḻrulijdx gunii Juan te basule'ni redidxcoob loj rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Näjza lo Herodes ni najc gobernadoor basule' Juan diidx, gudiḻnäjnini sa'csi xhet laadi cayujnni, sa'csi rbäznäjni Herodías, chääl bejtzni Felipe, näjza xcuent sgaii dojḻ ni bejnni. ");
INSERT INTO zawNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Di Herodes niu xtidx Juan, alga bejnni stee dojḻ, basäḻni Juan neṉ latzguiib. ");
INSERT INTO zawNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Che batiobnis Juan rebejṉ, näjza Jesús birobnis. Cheni cabedx-canabni lo Dios, bixal xhaguibaa, ");
INSERT INTO zawNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","dxejc biäjt Sprit Dxan xten Dios si'c te palom̲, bidzujṉni cadro suga' Jesús. Dxejc xhaguibaali biejn xse' te ni räjp: ―Luj, najclu xi'nä ni sanälazä. Rbanälazduxhä luj. ");
INSERT INTO zawNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yu' Jesús gaḻbitzuu ijz che gusloj cayujnni dzuun ni badeed Dios gunni. Rchalo rebejṉ najcni xi'n José, xi'n Elí. ");
INSERT INTO zawNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí gujc xi'n Matat. Matat gujc xi'n Leví. Leví gujc xi'n Melqui. Melqui gujc xi'n Jana. Jana gujc xi'n José. ");
INSERT INTO zawNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José gujc xi'n Matatías. Matatías gujc xi'n Amós. Amós gujc xi'n Nahum. Nahum gujc xi'n Esli. Esli gujc xi'n Nagai. ");
INSERT INTO zawNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai gujc xi'n Maat. Maat gujc xi'n Matatías. Matatías gujc xi'n Semei. Semei gujc xi'n José. José gujc xi'n Judá. ");
INSERT INTO zawNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá gujc xi'n Joana. Joana gujc xi'n Resa. Resa gujc xi'n Zorobabel. Zorobabel gujc xi'n Salatiel. Salatiel gujc xi'n Neri. ");
INSERT INTO zawNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri gujc xi'n Melqui. Melqui gujc xi'n Adi. Adi gujc xi'n Cosam. Cosam gujc xi'n Elmodam. Elmodam gujc xi'n Er. ");
INSERT INTO zawNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er gujc xi'n Josué. Josué gujc xi'n Eliezer. Eliezer gujc xi'n Jorim. Jorim gujc xi'n Matat. ");
INSERT INTO zawNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat gujc xi'n Leví. Leví gujc xi'n Simeón. Simeón gujc xi'n Judá. Judá gujc xi'n José. José gujc xi'n Jonán. Jonán gujc xi'n Eliaquim. ");
INSERT INTO zawNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim gujc xi'n Melea. Melea gujc xi'n Mainán. Mainán gujc xi'n Matata. Matata gujc xi'n Natán. ");
INSERT INTO zawNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán gujc xi'n David. David gujc xi'n Isaí. Isaí gujc xi'n Obed. Obed gujc xi'n Booz. Booz gujc xi'n Salmón. Salmón gujc xi'n Naasón. ");
INSERT INTO zawNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón gujc xi'n Aminadab. Aminadab gujc xi'n Aram. Aram gujc xi'n Esrom. Esrom gujc xi'n Fares. Fares gujc xi'n Judá. ");
INSERT INTO zawNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá gujc xi'n Jacob. Jacob gujc xi'n Isaac. Isaac gujc xi'n Abraham. Abraham gujc xi'n Taré. Taré gujc xi'n Nacor. ");
INSERT INTO zawNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor gujc xi'n Serug. Serug gujc xi'n Ragau. Ragau gujc xi'n Peleg. Peleg gujc xi'n Heber. Heber gujc xi'n Sala. ");
INSERT INTO zawNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala gujc xi'n Cainán. Cainán gujc xi'n Arfaxad. Arfaxad gujc xi'n Sem. Sem gujc xi'n Noé. Noé gujc xi'n Lamec. ");
INSERT INTO zawNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec gujc xi'n Matusalén. Matusalén gujc xi'n Enoc. Enoc gujc xi'n Jared. Jared gujc xi'n Mahalaleel. Mahalaleel gujc xi'n Cainán. ");
INSERT INTO zawNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán gujc xi'n Enós. Enós gujc xi'n Set. Set gujc xi'n Adán. Adán gujc xi'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús, sa'csi rbäjz Sprit Dxan xten Dios lastooni, biunejzni gueu Jordán, dxejc huinä Sprit Dxan xten Diosni lo reyubijdz. ");
INSERT INTO zawNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ro'c bia'nni tiuu gubijdx, tiuu guxhijṉ. Ro'c bidzujṉ beṉdxab ni rnibee te rlajzni gunni gusoob Jesús xtiidxni. Luxh calaan Jesús, sa'csi gajdni gau guiraa neṉ redxejga. ");
INSERT INTO zawNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Dxejc räjp beṉdxab lojni: ―Palga guliilu Xi'n Dioslu, gunibee gac reguijre yätxtiil. ");
INSERT INTO zawNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Badzu' Jesús diidx lojni räjpni: ―Acaj loj reguijtz xcuent Dios: “Xhet ganaxdi yätxtiil gun sajc guibajṉ bejṉ, näjza guiraa diidx nani rnii Dios sujn guibajṉ bejṉ.” ");
INSERT INTO zawNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Dxejcti huinä beṉdxab Jesús jiaa yejc te dajn. Teratbäztis baluilojni guiraa reguedxro ni tre' lo guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Dxejc räjp beṉdxab lojni: ―Narä sunidxä guiraa yäḻrnibee näjza reyäḻnasa'c ni yu' loj reguejdxga sa'csi xtenä guiraareni, luxh sajc gudedäni lo chutis ni rlazä. ");
INSERT INTO zawNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Palga luj suzuxhijblu loä, guiliä'plu xpala'nä, guiraani sajc xtenlu. ");
INSERT INTO zawNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Dxejc Jesús badzu' diidx, räjpni lojni: ―Acaj loj xquijtz Dios: “Dad Xtiostislu gaṉlu, luxh lojtisni chulu gunlu dzuun.” ");
INSERT INTO zawNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Dxejcti huinä beṉdxabni lo guedx Jerusalén, huinänini jiaa yejc xques guidoro. Dxejc räjp beṉdxab lojni: ―Palga guliilu najclu Xi'n Dios, gutiäjs lo yuj ");
INSERT INTO zawNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","sa'csi si'c caj loj rexquijtz Dios: Suxhaḻ Dios rexanglni te ga'preni luj, ");
INSERT INTO zawNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","guiniaazreni luj didi jiajblu lo guij. ");
INSERT INTO zawNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Badzu' Jesús diidx lojni, räjpni: ―Cajza lo rexquijtz Dios: “Na'c faḻlu Dad ni najc Xtioozlu.” ");
INSERT INTO zawNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Che baluux beṉdxab rextiidxni, gubicajni lo Jesús sa'csi dini niujn gaan nusoob Jesús xtiidxni. Guläjzni guidzujṉ stee dxej te gusacsíruni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Dxejc gubi' Jesús lo rexyuj Galilee räjpni yäḻrnibee xten Sprit Dxan. Bire'ch diidx xcuentni guiraa neṉ reguejdx ni tre' nejzga. ");
INSERT INTO zawNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ruluiini neṉ reguidobäz luxh guiraa rebejṉ rliä'p xpala'nni. ");
INSERT INTO zawNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Dxejcti huij Jesús guedx Nazare't cadro gulaani. Che gojl dxej ni rusilajz rexpejṉ Israel, biu'ni neṉ guidobäz sigajc ni rujnpacni, dxejc huisuliini te biḻni ");
INSERT INTO zawNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","reguijtz xten Dios. Badeedreni lojni guijtz ni bacuaa Isaías; cheni baxhalni guijtzga, bidxälni cadro rnii scree: ");
INSERT INTO zawNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Sprit Dxan xten Dios suganäj narä, sa'csi agule Dios narä te gusule'ä xtidxcoobni lo rebeṉproob. Baxhaḻni narä te gusiacä lastoo renani di lastooreni cuedxi, te gusule'ä yäḻrusḻaa lo rebejṉ ni yu' lo dojḻ, te gusiacä baloj rebeṉ lotiä'p, te gusḻaä́ rebeṉ ni cadejd trabajw, ");
INSERT INTO zawNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","te gusule'ä abiu' ijzsa'c che rulaslajz Dios rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Dxejc basäu Jesús reguijtzga, badeednini loj bejṉ ni cayacnäj neṉ guidooga, dxejc gurejni. Sa'csi guiraa rebejṉ ni sobga' neṉ guidooga cahuidzu'tzreni lojni, ");
INSERT INTO zawNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","gusloj guniini, räjpni lojreni: ―Lagajc nadxej guzojb rediidx ni caj lo reguijtzre nez loj guiraatu. ");
INSERT INTO zawNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Guiraareni sarú guniireni xcuent Jesús, bedxeloduxhzareni redidxsaruduxh ni guniini lojreni. Gunabdiidxreni loj sa'reni, räjpreni: ―¿La et xi'ndi José dade're, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Dxejc räjp Jesús lojreni: ―Siniipactu rediidxre loä: “Doctoor, basiajc lagajc luj”; siniizatu loä: “Recos ni biejn diajgnu bejnlu nez guedx Capernaum, lagajc recosga bejn nez ree cadro najc lajdxlu.” ");
INSERT INTO zawNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Dxejc huinuu xtiidxni, räjpni lojreni: ―Rniliä́pac lojtu, nicla tej redade' ni rnii xtidx Dios, di rebeṉ lajdxreni jiu xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Luxh rniliä lojtu, che gubajṉ Elías lo guedxliuj, guyu' xhidajl gunabiuud guedx Israel che di nisguij niajb choṉ ijz garol, dxejc guyu' yäḻrlianduxh guideb guejdxga. ");
INSERT INTO zawNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Luxh di Dios nuxhaḻ Elías rolijz nicla tej regunabiuud ni guläjz guedx Israel, alga baxhaḻnini lo beṉzijt, rolijz te gunabiuud ni rbäjz Sarepta, gajxh guedx Sidón. ");
INSERT INTO zawNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Sigajcza che gubajṉ Eliseo lo guedxliuj, guyu' xhidajl beṉ racxhuu ni raḻ tiejxhreni guedx Israel, luxh dini nusiajc nicla tejreni, alga basiajcni dade' ni laa Naamán, ni siääd te guedxzijt ni laa Siria. ");
INSERT INTO zawNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Che biejn diajg reni sobga' neṉ guidoo rextidx Jesús, bidxechduxhreni, ");
INSERT INTO zawNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","huisuliireni, guläärenini neṉ guejdxga. Dxejc huinärenini yejc dajn cadro tre' guejdxga cadro yu' te balaro, te ro'c rlajzreni nustejbrenini. ");
INSERT INTO zawNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Dxejc Jesús sigaj gudejdni galäiireni, sä'tini ste'ca lajt. ");
INSERT INTO zawNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Dxejc huij Jesús guedx Capernaum, te guejdx xten Galilee. Ro'c gusloj cagusule'ni diidx loj rebejṉ che gojl dxej ni rusilajz rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Bidxeloduxhreni xtiidxni sa'csi rusule'ni si'c te beṉnajn, si'c te ni rnibee. ");
INSERT INTO zawNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Neṉ guidooga suga' te dade' ni rbäjz te beṉdxab neṉ lastooni. Guredxa'ni ");
INSERT INTO zawNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","räjpni: ―¡Aii! ¡Basaan nurnu! ¿Xhicuent riädchu'lu loonu Jesús ni siääd Nasare't? ¿La siäädlu te gunitlojlu nuurnu, ä? Narä numbeälu, nanä najclu Xin Dxan Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Gudidxa' Jesús lo beṉdxabga, räjpni lojni: ―Basäu ro'lu, birii lastoo niguiire. Dxejcti beṉdxabre basäḻ niguiiga lo yuj nez loj guiraareni, dxejc biriini neṉ lastoo dade'ga, per xhet bejndini dade'ga. ");
INSERT INTO zawNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bidxeloduxh rebejṉga, dxejc gusloj caniireni lo sa'reni, räjpreni: ―¿Xhi diidx najc redee? Bahuii xho rnibee dade're rebeṉdxab con yäḻrnibee, luxh rusoob rebeṉdxab xtiidxni, ṟiireni lastoo bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Dxejc gusääb xtidx Jesús lo guiraa reguejdx ni tre' guideb gabi guejdxga. ");
INSERT INTO zawNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Birii Jesús guidobäz, huijni rolijz Simón. Dxejc naga' xnan sueerg Simón, cayacxhuuni, yu'ni xliaduxh. Sas gunabduxhreni lojni te gusiajcnini. ");
INSERT INTO zawNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Gubig Jesús loj nane'ga, gudidxa'ni xliaaga, luxh lagajc oṟga biriini xliaa. Dxejc huistiegajcni, gusloj cayujnni mandaad, cahuiinireni. ");
INSERT INTO zawNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Laḻ ni cayääz gubijdx, guiraa reni rajp beṉracxhuu ni rajc garen garen yäḻracxhuu biädnäreni rebejṉga lo Jesús. Dxejc laani batzuubni ṉaani yejc tejgareni, dxejc biajc rebeṉracxhuuga. ");
INSERT INTO zawNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Loj rebeṉracxhuuga, yu'reni birii rebeṉdxab neṉ lastooreni, rbedxa'reni räjpreni: ―Luj najclu Xi'n Dios. Luxh Jesús gudiḻnäjni rebeṉdxab, dini nusaa niniireni sa'csi laareni najnreni najcni Crist ni cabäjzreni. ");
INSERT INTO zawNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Che bianij, biriini lo guejdx, huijni te lajt cadro rut rbäjzdi. Niluxh gudiil rebejṉni, dxejc bidzujṉreni cadro suga'ni. Rlajzreni nuscuääzrenini te di nuiini. ");
INSERT INTO zawNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Dxejc Jesús räjp lojreni: ―Nanab cha'a chasule'ä rextidx xcuent xcäḻrnibee Dios xhidajlruza guejdx, ni'cni baxhaḻpac Dios narä. ");
INSERT INTO zawNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Dxejc si'ctis cuanzaj Jesús basule'ni xtidx Dios neṉ guiraa reguidobäz neṉ reguejdx xten Galilee. ");
INSERT INTO zawNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Cheni suga' Jesús ro' nis ni laa Genesare't, gubig xhidajl bejṉ lojni te jiejn diajgreni xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Dxejc bahuii Jesús tio'p barcw ni suga' ro' nisga, rud yu'di neṉreni sa'csi rebejṉ ni rniaaz bäjl abiriireni neṉ rebarcw te caguiibreni xquijxhreni ro' nisga. ");
INSERT INTO zawNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Dxejc biu' Jesús neṉ te barcw ni najc xten Simón, dxejc gunab Jesús chää barcwga lo nis te la', te guibicajni ro' yuj. Dxejc gurej Jesús neṉ barcwga, ro'cli guslojni caguluiini rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Che gulujx xtiidxni, räjpni loj Simón: ―Huinä barcw cadro jiätru, coḻcuaa xquijxhtu lo nis te guiniaaztu bäjl. ");
INSERT INTO zawNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Räjp Simón lojni: ―Mastr, guideb yääl biennu dzuun, luxh dinu niniaaz nicla tej bäjl, niluxh ṉaj agunibeelu gusäḻsacnu guijxh lo nis. ");
INSERT INTO zawNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Cheni basäḻreni xquijxhreni lo nis, gunaazreni xhidalduxh bäjl, dxejc guslojli caräjs xquijxhreni. ");
INSERT INTO zawNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Dxejc bejnreni seen loj resa'reni ni yu' neṉ stee barcwga te jiädyacnäjreni. Bidzujṉtireni, bachajreni guiro'p barcw. Gudxaduxh rebarcw, ameer niääzreni neṉ nis. ");
INSERT INTO zawNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Che bahuii Simón Pedr recosre, bazuxhijbni nez loj Jesús, dxejc räjpni: ―Gubicaj loä Dad, sa'csi narä nacä te beṉdojḻ. ");
INSERT INTO zawNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Si'c gunii Simón sa'csi bidxejb laani näjza guiraa rebejṉ ni yunäjni sa'csi gunaazreni xhidalduxh bäjl. ");
INSERT INTO zawNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Näjza Jacoob näjza Juan, rexi'n Zebedeo, ni runnäj Simón dzuun, näjzareni bidxejbreni. Per Jesús räjp lo Simón: ―Na'c guidxejblu, ṉajli guisloj cueedxlu bejṉ lacuaa ni guiniaazlu bäjl. ");
INSERT INTO zawNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Dxejc, che bidzuṉnäjreni rebarcw ro' nis, basa'nreni guiraa xhixtenreni, te sanajlreni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Cheni guyu' Jesús tej reguejdx, bidzujṉ te bejṉ lojni ni rajc lepra te yäḻguidxduxh ni raḻ tiejxhni. Che bahuiini loj Jesús, bazuxhijbni, basajbni lojni lo yuj, räjpni lojni: ―Dad, palga rlajzlu, sajc gusiajclu narä. ");
INSERT INTO zawNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Dxejc batzuub Jesús ṉaani yejcni räjpni lojni: ―Rlazä jiajclu. Susiacälu. Che guniini rediidxre, biacgajc beṉ racxhuuga. ");
INSERT INTO zawNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Dxejcti gunibee Jesús lojni rut lojdi gäbni xhi guzajcni. Räjpni lojni: ―Huijtis lo bixhojz te fiini lojlu, huisa'nza gojn xcuent ni biajclu si'cni rnibee xleii Moisés, te filoj rebejṉ abiajclu. ");
INSERT INTO zawNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Luxh xpala'n Jesús sanuutis cayä'pruni, guixe-guixee care'ch diidx xcuentni. Rdojpza xhidalduxh bejṉ te gucuadiajgreni xtidx Jesús näjza te gusiajcni yäḻracxhuu xtenreni. ");
INSERT INTO zawNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yu'za huält riunejz Jesús rijni relajt cadro ruti rebejṉ, te ro'c rbedx-rniabni lo Xtadni Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Te dxej laḻni caguluiini rebejṉ, nejzga sobga' gaii farisee näjza gaii bejṉ ni ruluii leii garen-garen reguejdx, siäädreni guideb nez reguejdx xten Galilee, näjza región Judea, näjza guedx Jerusalén. Dxejc huenliisi rluiloj suganäj xcäḻrnibee Dios Jesús te rajc russiajcni rebeṉracxhuu. ");
INSERT INTO zawNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Dxejc bidzujṉ gaii dade' nuureni lo te lonbäz te bejṉ ni di gacdi guiniib, rlajzreni gusiu'renini neṉ yu' te quixhrenini nez loj Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Niluxh direni nidxäl canejz niu'reni sa'csi nadäduxh ro'c sa'csi tre' xhidajl rebejṉ. Dxejc huäpnäjrenini yejc yu'ga, badzucajreni gaii tej, dxejc basajbreni xloon beṉracxhuuga yejcli yu'ga te gujc bidzujṉni nez loj Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Che bahuii Jesús yäḻrililajz xtenreni, räjpni loj beṉracxhuuga: ―Dade', agubicaj xtojḻlu. ");
INSERT INTO zawNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Dxejc rebejṉ ni ruluii leii näjza refarisee gusloj cayujnreni xhigab, naareni: “¿Chucha niguiire ni caniyajni Dios con rextiidxni? Ruti te bejṉ ni sajc gudzucaj xtojḻ rebejṉ, Diostis rudzucaj dojḻ.” ");
INSERT INTO zawNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Dxejc gucbee Jesús xhi xhigab cayujnreni, ni'c räjpni lojreni: ―¿Xhicuent rujntu xhigab si'c neṉ lastootu? ");
INSERT INTO zawNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Xhini'c najc guyasiru guiniini: “Agubicaj rextojḻlu”, o guiniini: “Huistie, guzaj”, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mbaj ṉaj, suluiä nez lojtu Xi'n Dios ni gujc Xi'n Niguii rajp yäḻrnibee, yäḻnadip lo guedxliujre te gudzucajni xtojḻ rebejṉ. Dxejc räjpni lo bejṉga ni digacdi guiniib: ―Lojlu rniä, ¡huistie, guläs xloonlu, huij rolijzlu! ");
INSERT INTO zawNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Lagajc dxejc nez lojreni huistiegajc bejṉ ni digacdi guiniib, guläsni xloonni cadro naga'ni, dxejc siini rolijzni, calä'pni xpala'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Guiraareni rdxeloduxhreni recosga, dxejc guslojreni calä'preni xpala'n Dios, rdxejblireni räjpreni: ―Abihuiinu cosro, cos ni guidxeloj bejṉ nadxej. ");
INSERT INTO zawNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Che gudejd gulujx recosre, birii Jesús ro'c. Dxejc bahuiini lo te bejṉ ni rusquijx xcuent impuest, nani laa Leví. Sobga'ni lo te mex cadro rusquijxni impuest; ro'c bahuii Jesús lojni. Räjp Jesús lojni: ―Gudanajl narä. ");
INSERT INTO zawNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Dxejc huisu Leví, basa'nni guiraa recosga, dxejc sanajlni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Dxejc bejn Leví te lanij rolijzni par Jesús. Biääd xhidajl bejṉ ni rusquijx xcuent impuest näjza sgaii bejṉ; sobganäjnireni lo mex. ");
INSERT INTO zawNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Dxejcti refarisee näjza rebejṉ ni ruluii leii guslojreni cayeinäjreni rexpejṉpac Jesús, räjpreni: ―¿Xhicuent raunäjtu, ränäjtu rebejṉ ni rusquijx impuest näjza rebeṉdojḻ, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Dxejc badzu' Jesús diidxre, räjpni lojreni: ―Rebejṉ ni nadaan di guiquiin te doctoor, ganaxtis rebejṉ nani racxhuu rquiinreni te doctoor. ");
INSERT INTO zawNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Dina niädtedxä rebeṉsa'c, narä biädtedxä rebeṉdojḻ te gusiechlajzreni. ");
INSERT INTO zawNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Dxejc gunabdiidx rebejṉga loj Jesús, räjpreni: ―¿Xhicuent lacti rucua'n rexpejṉ Juan näjza rexpeṉ refarisee, lacti rbedx-rniabreni loj Dios; niluxh rexpejṉpaclu alga rajwreni, rä'reni? ");
INSERT INTO zawNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Badzu' Jesús diidxre lojreni, räjpni: ―¿La sajc gucua'n rebejṉ ni yu' lo te sa' laḻni yunäjreni bi'n, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Niluxh sidzujṉ dxej cheni sibicaj bi'n lojreni, dxejc sii sucua'nreni. ");
INSERT INTO zawNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Guniiza Jesús cuentre lojreni, räjpni: ―Rut rucuaadi te remiend ladcoob loj te ladyujxh, sa'csi che rxu'n ladcoob rutiäjzni ladyujxhga, dxejc xhiroobruni guiräjs, luxh diza ladcoob guchaag lo ladyujxh. ");
INSERT INTO zawNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Di gacdi gusäḻni bincoob neṉ te guidbiejw sa'csi bincoobga sutiäsya'ni guidbiejwga dxejc sixe' binga, sixijṉza guidbiejwga. ");
INSERT INTO zawNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ni'cni nanab gusäḻni bincoob neṉ guidcoob si'c sigucheeza guiro'preni. ");
INSERT INTO zawNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Luxh nicla tej bejṉ ni agu' bin ni yu' agujc xchej rlajz yä bincoob, sa'csi säjbni: “Bin ni yu' agujc xchej najc huenru.” ");
INSERT INTO zawNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Te dxej ni rusilajz rexpejṉ Israel sasaj Jesús näjza rexpejṉpacni nez loj reyuj cadro naga' triuu. Dxejc, sa'csi calaanreni gusloj caläädxreni doj lo triuu te cayajwrenini. ");
INSERT INTO zawNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Dxejc gunabdiidx gaii refarisee ni najc beṉguidoo, räjpreni lojreni: ―¿Xhicuent rujntu dzuun ni di nungäjḻ guntu che rajl dxej ni rusilajznu? ");
INSERT INTO zawNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Dxejc räjp Jesús lojreni: ―¿La gajdtu goḻ loj reguijtz xhi bejn toDavid cheni calannäjni rebejṉ nani sanäni, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Biu'ni neṉ xquidoo Dios, gudajwni yätxtiil nani di nungäjḻ gau bejṉ sa'csi xtebtis rebixhojz rajc rajwni, luxh badeedni yätxtiilga gudajw resa'ni. ");
INSERT INTO zawNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Räjpza Jesús lojreni: ―Sigajcza narä, Xi'n Dios ni gujc Niguii, rnibeä dxej ni rusilajztu. ");
INSERT INTO zawNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Che gojl stee dxej ni rusilajz rexpejṉ Israel, biu'ni neṉ te guidobäz, dxejc guslojni caguluiini rebejṉ. Lagajc ro'c sobga' te dade' ni nabijdz ṉaani ladbee. ");
INSERT INTO zawNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Dxejc remastr xten leii näjza refarisee cagula'tzreni te don la susiajcni bejṉga dxej ni rusilajzreni, sa'csi caguiilreni xho gucuaquijreni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Niluxh laani najnni xhi xhigab cayujnreni, dxejc guniini lo dade' ni nabijdz ṉaani, räjpni: ―¡Huisulii! ¡Gudaa nez galäiire! Dxejc huisulii bejṉga, gubigni lojni. ");
INSERT INTO zawNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Dxejc räjp Jesús lojreni: ―Rlazä guiniabdidxä lojtu dee: ¿Xhini'c najc huen gunni che rajl dxej ni rusilajznu? ¿La te dzunsa'c o la te dzunguijdx? ¿La gacnäjnu bejṉ ḻaa xcäḻnabajṉni o la gudzucajnu yäḻnabajṉni, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Che gulujx bahuii Jesús loj guiraa rebejṉ ni tre' guideb gabini, räjpni loj bejṉ ni nabijdz ṉaani: ―¡Baslii ṉaalu! Dxejc bejnni si'c, luxh biacgajc ṉaani. ");
INSERT INTO zawNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Dxejc bidxechduxh rebejṉ ni tre' ro'c, gusloj canabdiidxreni lo sa'reni xhi gunnäjreni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Neṉ redxejga, huij Jesús loj te dajn te huininäjni Xtadni Dios. Ro'c gudejdni yääl cabedx-canabni lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Che bianij lo yuj, gurejdxni rexpejṉni. Ro'c guleni tzubitio'preni te gacreni xpejṉpacni. Gulälajnireni reapost. ");
INSERT INTO zawNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Renani guleni najc Simón ni gulälajni Pedr; Andrés, bejtz Simón; Jacoob; Juan; Felipe; Bartolomé; ");
INSERT INTO zawNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo; Tomás; Jacoob xi'n Alfeo; Simón ni nagab loj rexpeṉ cananista; ");
INSERT INTO zawNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, bejtz Jacoob; näjza Judas Iscariote ni guto' Jesús loj rebixhojz. ");
INSERT INTO zawNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Che biätnäj Jesúsreni yejc dajnga, guzudxireni yejc te danbäz sa'csi suga' xhidajl bejṉ ro'c. Siäädreni guiraa nez reguedx Judea, näjza guedx Jerusalén näjza reguejdx ni tre' gajxh nisdoo Tiro con Sidón. Rebejṉga bidzujṉreni te gucuadiajgreni xtidx Jesús, te gusiajczanireni xcäḻracxhuureni. ");
INSERT INTO zawNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Guiraa ni rdejdza trabajw yu' beṉdxab neṉ lastooreni näjza reni'c biajc. ");
INSERT INTO zawNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Guiraa rebejṉ rlajz caan Jesús, sa'csi rusiajcni guiraareni con xcäḻrnibeeni. ");
INSERT INTO zawNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Dxejc bahuii Jesús loj rexpejṉpacni räjpni lojreni: ―Chicbaatu, bejṉ nani xheti xhixtentu, sa'csi xtentu najc cadro rnibee Dios xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Chicbaatu, bejṉ nani calaan ṉaj, sa'csi suniidx Dios lojtu nani rniabtu. ’Chicbaatu, bejṉ nani roon ṉaj sa'csi susiäjḻ Dios lajztu dxejcru suxhijztu. ");
INSERT INTO zawNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Chicbaatu, bejṉ nani rdxechlajz bejṉ lojtu, rbääreni la'tu te laad, rniyajreni la'tu, luxh rbälazreni lajtu si'c te cos guijdx sa'csi rililajztu xtidx Xi'n Dios ni gujc Niguii. ");
INSERT INTO zawNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Coḻguibalajz neṉ redxejga, na'c gac-huin lastootu sa'csi sunidxduxh Dios xhi xtentu xhaguibaa. Sigajcza basacsí retoxtadgoldooreni rebejṉ nani gunii xtidx Dios galoo. ");
INSERT INTO zawNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Probe'zatu, la'tu beṉrajp, sa'csi agojptu xcäḻnasa'ctu, xcäḻrbalajztu lo guedxliujre. ");
INSERT INTO zawNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Probe'tu nani rajp guiraloj xhixtentu ṉaj, sa'csi sidejdtu yäḻrliaan. ’Proobzatu ni ruxhijztu ṉaj, sa'csi sonduxhtu sidejdtu yäḻhuinduxh, yäḻnalas. ");
INSERT INTO zawNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Probe'tu palga rliä'p rebejṉ xpala'ntu ṉaj, sa'csi si'c bejn retoxtadgoldooreni rebejṉ ni gunii didx-xhii lacuaa niniireni xtiidxpac Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Räjpzani: ―La'tu ni cacuadiajgtu rextidxä rniä diidxre lojtu: coḻchanälajz rebejṉ ni rdxe'ch lojtu, coḻyujn dzunsa'c loj rebejṉ ni rdxechlajz lojtu. ");
INSERT INTO zawNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Benle' yejc rebejṉ ni rgube la'tu. Gunab lo Dios xcuent rebejṉ ni rcuaquij la'tu. ");
INSERT INTO zawNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Palga yu' chu rlajz quiin te laad lojlu, badeedza stelaad quiinni. Palga yu' chu gudzucaj xhablojiaalu, badeedza näj xcamangwlu xca'ni. ");
INSERT INTO zawNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Xhitis ni guiniabreni lojlu, badeedni; ni gudzucaj te xhi xtenlu lojlu, na'c guiniabsacluni lojni. ");
INSERT INTO zawNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Sigajc ni rlajzlu gunnäj bejṉ la'tu, si'cza la'tu coḻyennäj bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Palga la'tu sanälajztistu rebejṉ nani sanälajz la'tu, xlia'sini, sa'csi sigajcza rujn rebeṉdojḻ. ");
INSERT INTO zawNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Palga guntu hueen lojtis rebejṉ ni rujn hueen lojtu, xhet laadi cayujntu, sa'csi sigajcza rujn rebejṉ ni nabajṉ neṉ dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Palga gudedlaatu lojtis reni rujntu xhigab gunidxsacni lojtu, ¿xhi cos hueen rchalotu rujntu? Ni rebeṉdojḻ rudedlaazareni loj rebejṉ ni najnreni siguixsac ni nasääbreni. ");
INSERT INTO zawNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","La'tu, nanab chanälajztu rebejṉ ni rdxe'ch lojtu, guntu hueen lojreni, gudedlaatu loj rebejṉ, na'c gunlojtu xcasactu recos ni rudedlaatu, te si'c guroob gac nani guzalajz Dios lojtu; te si'c gactu xi'n Gueb Dios ni nabajṉ xhaguibaa. Sa'csi si'cza najc Dios huenduxh loj reni di gudeed xquixtios lojni, näjza loj rebeṉdojḻ. ");
INSERT INTO zawNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Coḻgulaslajz resa'tu si'c rulaslajz Xtadnu Dios guiraa rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Räjpzani: ―Na'c guntu yäḻguxhtis nani rujn bejṉ, naatu xhet laadi rujnni; te na'cza gun Dios yäḻguxhtis rextojḻtu. Na'c gucuaquijtu bejṉ te sigajcza di Dios gucuaquij la'tu. Coḻgusiäjḻ-lajz dojḻ ni rujn sa'tu, te si'cza gusiäjḻ-lajz Dios rextojḻtu. ");
INSERT INTO zawNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Coḻgudeed loj bejṉ ni rquiinreni te si'cza guzalajz Dios ni rquiintu. Suniidxreni xca'tu te mediid guidxadoo, sibetijp ni yu' neṉni, cupe'tlini gusäḻreni neṉ xpolstu. Dios suniidx lojtu lagajc con mediid ni rudeedtu loj rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Guniiza Jesús stee cuent räjpni: ―¿La sajc guluii te beṉ lotiä'p nez yuj lo stee beṉ lotiä'p, ä? ¿La di guiro'preni guitejb neṉ te gueed, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Te bejṉ ni casieed di gacdi guisieedruni loj ni najn xmastrni. Te bejṉ, che agulujx bisieedni, sajcni si'cni najc mastr xtenni. ");
INSERT INTO zawNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Xhicuent cahuiilu guixhe' ni yu' baloj bejtzlu, luxh dilu fii yagro ni yu' balojlu? ");
INSERT INTO zawNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","O, ¿xho mood gäblu lo bejtzlu: “Guidon cuää́ guixhe' ni yu' balojlu”; luxh dilu gacbee yu' te yagro balojlu, ä? ¡Beṉguijdx! Guläxgaa yagro ni yu' balojlu, dxejc sajc fisa'clu te cuäälu guixhbäz ni yu' baloj bejtzlu. ");
INSERT INTO zawNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Räjpzani: ―Xheti te yagsa'c ni rudeed ninejxh ni xhet sajcdi, xhetiza te yajg ni xhet sajcdi ni rudeed ninexhsa'c. ");
INSERT INTO zawNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Sa'csi tebgaj reyajg ruseṉlojni xhi yajgni xcuent ninejxh ni rcaj lojni. Di bejṉ gutie' iigw lo reyaguejch, diza bejṉ gutiu' uub lo te yag balagrejn. ");
INSERT INTO zawNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Rebeṉsa'c rnii didxsa'c, sa'csi xhigabsa'c yu' neṉ lastooni. Niluxh rebeṉguijdx rnii ganax didxguijdx sa'csi xhigabguijdx yu' neṉ lastooni, sa'csi ro'ni rnii nani yu' neṉ lastooni. ");
INSERT INTO zawNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Räjpzani: ―¿Xhicuent rniitu loä: “Dad, Dad,” luxh ditu gun nani rniä guntu? ");
INSERT INTO zawNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Guiniä lojtu chuni'c najc si'c bejṉ ni riääd loä, rucuadiajgni xtidxä luxh rusoobni xtidxä. ");
INSERT INTO zawNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Najcni si'c te bejṉ ni benchee rolijzni, ganid gudäänni jiät, dxejcti bejnni cimient yejc te guilaj. Cheni biäjt nisro ro' gueuu, bidijn nisro cuä' yu'ga, luxh nicla nusniibnini, sa'csi yu'ga sobgadzu'tz yejc te guilaj. ");
INSERT INTO zawNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Niluxh reni rcuadiajg xtidxä, dxejc direni guzoob xtidxä, najcreni si'c te bejṉ ni bejn xyu'ni loj yujxh, dini niujn cimient xten yu'ga. Dxejcni biäjt nisro, bidijnni cuä' yu'ga, dxejc li gurebä'n yu'ga, gunitlojtini. ");
INSERT INTO zawNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Che gulujx gunii Jesús loj rebejṉ, huijni te guejdx ni laa Capernaum. ");
INSERT INTO zawNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ro'c yu' te beṉ romaṉ ni rnibee, yu' te mos lojni, luxh sanälazduxhni mosga. Cayacxhuduxh mosga, ameerli guetni. ");
INSERT INTO zawNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Che biejn diajg capitán cagusä'treni Jesús, baxhaḻgajcni gaii beṉgool lo rexpejṉ Israel te chagajnreni Jesús jiäädni te gusiajcni xmos dade'ga. ");
INSERT INTO zawNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Che gubigreni loj Jesús, gusloj gunabduxhreni lojni, räjpreni lojni: ―Dade're najc beṉsa'c, nungäjḻ gacnäjluni ");
INSERT INTO zawNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","sa'csi sanälajzni lajdx rexpejṉ Israel, luxh lagajc laani gunibee guc-chee xquidobäznu. ");
INSERT INTO zawNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Dxejcti huinä Jesúsreni. Cheni siäddzuṉgajxhreni royu', baxhaḻ capitánga gaii xamiigwni, gäbreni loj Jesús: ―Si'c naj capitán: “Di rlazä gutalä xtzuunlu. ¿Chu narä te jiu'lu rolizä? Xhet sacädi. ");
INSERT INTO zawNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ni'c dina niapä baloor te lagajc narä niädganä guejblu, sa'csi rajplu yäḻrnibeduxh niluxh narä rut nacädi. Ni'cni gunibeetis jiajc xmosä, luxh laani siacgajcni. ");
INSERT INTO zawNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Sa'csi narä nacä xmos rebejṉ ni rnibee, luxh rnibeäza loj resoldaad. Che gäpä lo tejni: Huij rec, rijni; che gäpä loj steeni: Gudaa ree, riäädni; che gäpä loj xmosä: Bejn dee, rungajcnini.” ");
INSERT INTO zawNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Che biejn diajg Jesús rediidxre, bidxeloduxhni, gubiréni loj rebejṉ ni siädnajlni, räjpni lojreni: ―Rniliä́pac lojtu, nicla lo rexpejṉ Israel gajdna guidxälä te bejṉ ni rililajzduxh si'c ni rililajz capitánre. ");
INSERT INTO zawNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Che gubi' rebejṉ ni huij loj Jesús rolijz capitán, bahuiireni abiajc xmosni. ");
INSERT INTO zawNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Neṉ redxejga, huij Jesús te guejdx ni laa Naín. Huinäni rexpejṉpacni näjza xhidajl bejṉ ni sanajlni. ");
INSERT INTO zawNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Che bidzujṉni gajxh ro' guejdxga, bahuiini sacua'tzreni te beṉgut, te bi'n ni najc xtebtis xi'n te gunabiuud. Xhidalduxh bejṉ sacua'tzni. ");
INSERT INTO zawNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Che bahuii Jesús loj gunabiuudga, biani nane'ga, räjpni lojni: ―¡Na'c roonlu! ");
INSERT INTO zawNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Dxejc gubig Jesús lo rebejṉ ni sanä beṉgutga, dxejc guzudxi reni nuu beṉgutga. Dxejc räjp Jesús loj beṉgutga: ―¡Bi'n!, narä rniä lojlu; ¡Huistie! ");
INSERT INTO zawNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Dxejc huistie beṉgutga, sobga'ni guslojni caniini. Dxejc badeed Jesúsni lo xnanni. ");
INSERT INTO zawNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Che bahuiireni xhini'c gujc, bidxejbreni, bidxeloduxhreni, guslojreni calä'preni xpala'n Dios, räjpreni: ―Te niguisacduxh ni rnii xtidx Dios abidzujṉ nez loonu. Caniizareni: ―Lagajc Guejb Dios abiädhuii rexpejṉni. ");
INSERT INTO zawNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Dxejc bire'ch diidx xcuent Jesús guideb nez reguedx Judea näjza guiraa reguejdx ni tre' nejzga. ");
INSERT INTO zawNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Rexpejṉpac Juan ni rutiobnis bij rediidxga lojni che yu'ni latzguiib. ");
INSERT INTO zawNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Dxejc baxhaḻni gaiireni lo Jesús te sanabdiidxreni: “¿La guliipac najclu Crist ni jiääd o sibäjznu chu stee bejṉ, ä?” ");
INSERT INTO zawNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Dxejcti gubig rexpejṉ Juan loj Jesús, räjpreni: ―Juan ni rutiobnis baxhaḻ nuurnu te guiniabdiidxnu lojlu: “¿La luj najc Crist ni jiääd o la sibäjznu chu stee bejṉ?” ");
INSERT INTO zawNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Lagajc dxejc che bidzujṉreni, basiajc Jesús xhidajl bejṉ ni rajc garen-garen yäḻguijdx, ni yu'za rebeṉdxab lastooreni, basiajczani baloj ni di fii. ");
INSERT INTO zawNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Dxejcti badzu' Jesús diidxre, räjpni: ―Coḻchaye'tz lo Juan guiraa ni abahuiitu näjza ni abiejn diajgtu. Coḻye'tz lojni: “Relotiä'p ruhuisac; rebeṉcoj rsiasa'c; rebeṉ ni raḻ guejdx tiejxhni, abiajc tiejxhni; rediagcua't riensac diajgreni; rebeṉgut, agubaṉsacreni; luxh loj rebeṉproob nani cabäjz xcäḻracnäj Dios riejn diajgreni rsiule' xtidx Dios xcuent xho ḻaa bejṉ lo dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Chicbaa nani rumbee narä, nani di cuälaz narä.” ");
INSERT INTO zawNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Cheni sii rexpejṉ Juan, gusloj Jesús caniini xcuent Juan loj rebejṉ, räjpni: ―¿Chuni'c huihuiitu nez lo reyubijdz? ¿La te nijt ni rusniib bej, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Xhini'c huihuiitu? ¿Te bejṉ ni sucheduxh, ä? La'tu najntu rebejṉ ni sucheduxh näjza reni nabaṉsa'c, rolijz reṟeii yu'reni. ");
INSERT INTO zawNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Chuxhni'c biriitu huihuiitu? ¿Te niguii ni rnii xtidx Dios, ä? O'n, rniliä́ lojtu, luxh te ni sacduxhru loj guiraa reniguii ni rnii xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan najc niguii ni ruzä't rexquijtz Dios cadro caj scree: Narä guxhaḻä te niguii nani guinii xtidxä, te nidni lojlu, te laani guzucheeni xnezyujlu nez lojlu. ");
INSERT INTO zawNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Rniliä́pac, loj guiraa rexingaan regunaa, nicla tejni gajd guiricaj ni najc te beṉsacduxhru nez loj Dios si'c najc Juan ni rutiobnis. Niluxh nani guxiiru sajc lo xcäḻrnibee Dios ni jiääd, sajcruni loj Juan. ");
INSERT INTO zawNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Che biejn diajg rebejṉ näjza reni rusquijx impuest rextiidxni xcuent Juan, gucbeereni rujn Dios yäḻguxhtissa'c, sa'csi abatiobnis Juanreni. ");
INSERT INTO zawNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Niluxh refarisee näjza rebejṉ ni ruluii leii gulälazreni nani niujn Dios par laareni, sa'csi direni nicäjb nutiobnis Juanreni. ");
INSERT INTO zawNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Räjpza Jesús lojreni: ―¿Xhocha guiniä najc rebejṉ nani tre' ṉaj? ");
INSERT INTO zawNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Najcreni si'c rebiuxbäz nani rguijt nez lo guii cadro rdo', rbedxa'reni loj sa'reni, rniireni: “Bieḻnu te bizej te guya'tu, niluxh ditu nuya'. Bieḻzanu te dij ni nabaduxh dxejcti dizatu nioon.” ");
INSERT INTO zawNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Sa'csi che biääd Juan, dini niauxha't, dizani niä' bin, luxh räjptu: “Yu' beṉdxab lastooni.” ");
INSERT INTO zawNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Dxejcti biäḻä narä, Xi'n Dios ni gujc Niguii, rauä, rä'ä. Dxejc räjptu: “Bahuilaare, dade're rauxha't, rä'zani, najcni xamiigw rebeṉdojḻ näjza rebejṉ ni rusquijx reimpuest xten gubier.” ");
INSERT INTO zawNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ni'cni xcäḻnajn Dios huenliisi rieṉloj loj dzuun ni rujn rebejṉ ni najn. ");
INSERT INTO zawNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Dxejc tej refarisee gunii loj Jesús, räjpni: ―Jiäädlu rolizä te guidaunu. Dxejc huij Jesús rolijzni, ro'c gurejni lo mex. ");
INSERT INTO zawNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Rbäjz te gunagubejxh lo guejdxga. Che biejn diajgni satajw Jesús rolijz fariseega, bidzuṉnäjni te bo't guidxa se't nejxh, luxh bo'tga najc si'c onix, botsa'cni. ");
INSERT INTO zawNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Che biu' gunaaga, bidzujṉni lo ni' Jesús, guslojni cayoonni. Con nisbee caguiibni ni' Jesús, dxejc caguspijdzni ni'ni con xquidxejcni. Dxejc bachagro'ni ni'ni bazaazani setnejxhga ni' Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Che bahuii farisee ni gurejdx Jesús rolijzni, recosre, bejnni xhigab: “Palga gulii najc niguiire Xi'n Dios, sacbeeni chu najc näjza xho najc gunaare ni cagajn ni'ni, sacbeezani najcni te gunadoḻduxh.” ");
INSERT INTO zawNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Dxejc gunii Jesús loj fariseega, räjpni: ―Simón, yu' xhi rlazä guiniä lojlu. Dxejc räjp fariseega lojni: ―Guniini, Dad mastr. ");
INSERT INTO zawNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Dxejc räjp Jesús lojni: ―Tio'p bejṉ nazääb meel lo te bejṉ ni rudedlaa meel. Tej reni nazääb si'cti gaiigayuu meel. Steeni nazääb si'cti tiubitzuu meel. ");
INSERT INTO zawNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Cheni di niajcdi niguijxreni xti'nreni, basiäḻ lajzni xti'n guiro'preni. N̲aj gunii loä, ¿chu tejreni sianälajzru dade'ga, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Badzu' Simón diidxre lojni, räjpni: ―Rchaloä bejṉ ni nazääbru lojni. Dxejc räjp Jesús: ―Laaca rniilu. ");
INSERT INTO zawNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Dxejc gubiré Jesús, bahuiini loj gunaaga. Dxejc räjpni loj Simón: ―¡Bahuii loj gunaare! Che biu'ä rolijzlu, dilu nuniidx nis te nidiib ni'ä. Per gunaare gudibnäjni ni'ä nisbee ni birii balojni, dxejc baspijdzni ni'ä con xquidxejcni. ");
INSERT INTO zawNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Dilu nuchagro' narä, luxh laani cheli biu'ä ree, gajdni cuääz guchagro'ni ni'ä. ");
INSERT INTO zawNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Dilu nusäḻ se't yecä, niluxh laani basäḻni se't ni rlianexhduxh ni'ä. ");
INSERT INTO zawNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ni'cni rniä lojlu, dojḻ xten gunaare, luxh xhidalduxh najcreni, abadzucaj Dios redojḻga sa'csi huenliisi sanälajzni Dios. Luxh rebejṉ ni rudzucaj Dios guxii xtojḻreni, guxiiza sanälajzreni Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Dxejcti räjpni loj gunaaga: ―Agubicaj rextojḻlu. ");
INSERT INTO zawNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Dxejc rebejṉ ni sobga' lo mex con laani, che biejn diajgreni rediidxre, gusloj canii lo sa'reni, räjpreni: ―¿Chuchani'c najc niguiire, ni'cni rudzucajlini xtojḻ bejṉ, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Räjp Jesús loj gunaaga: ―Aguḻaalu lo xtojḻlu sa'csi ahuililajzlu; huij ṉaj, bascuedxi lajzlu. ");
INSERT INTO zawNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Dxejcti gusloj huij Jesús guiraa reguejdx näjza rerench, cagusule'ni xtidx Dios, caguluiini xcuent xcäḻrnibee Dios loj rebejṉ. Sanäni rexpejṉpacni ");
INSERT INTO zawNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","näjza gaii gunaa ni abasiajcni, agulääni rebeṉdxab lastooreni, näjza basiajcni xcäḻguijdxreni. Tejni laa Marii ni laaza Magdaleṉ, ni gulää Jesús gajdz beṉdxab neṉ lastooni. ");
INSERT INTO zawNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Stee gunaa laa Xuan, ni najc chääl Chuza, ni ruhuii xhixten Herodes. Stee gunaa laa Susaṉ. Guyu'za sgaii gunaa. Guiraa reni'c rudeed lagajc xhixtenreni te rio' recos ni rquiinreni. ");
INSERT INTO zawNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Dxejcti bire' xhidajl bejṉ lojni ni birii xhidajl reguejdx. Lojreni gunii Jesús con te cuent ni ruluii, räjpni: ");
INSERT INTO zawNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Birii te bejṉ sale'c binij. Cheni cabe'cni binij, yu' binij ni bitejb cuä' nezyuj. Che sadejd rebejṉ baläjreni yejc binijga, biäädza remane' ni rutajt xhaguibaa, gudajwrenini. ");
INSERT INTO zawNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yu'za lajt bitejb binijga neṉ reguij cadro xheti xhidajl yuj. Che gulejn binijga, gubidzgajcni sa'csi xheti xcojp ro'c. ");
INSERT INTO zawNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yu'za lajt bitejbni nez neṉ reyaguejch. Che gulejnni, di reyaguejch nusaan niroob gäjlga. ");
INSERT INTO zawNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Yu'za lajt bitejb binijga lo yusa'c, ro'c gucduxhni. Cheni guroobni, yu' binijga gujc te gayuu xob loj tejga binij ni gule'c dade'ga. Che gulujx guniini scree, dxejc guniini dip räjpni: ―Palga sajc gucuadiajgtu rediidxga, coḻcuadiagsa'cni. ");
INSERT INTO zawNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Dxejcti gunabdiidx rexpejṉpacni lojni räjpreni: ―¿Xhi säloj cuentre? ");
INSERT INTO zawNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Dxejc räjpni lojreni: ―Lojtu ni najc rexpejṉä suniidx Dios yäḻnajn te gacbeetu reyäḻxhiga'tz xten xcäḻrnibeeni. Loj chutis stee bejṉ, siniä recuent lojreni te mase cadxelojreni, direni fisa'c, luxh mase cacuadiajgreni, direni gacbesa'c. ");
INSERT INTO zawNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Räjpzani: ―Scree säloj cuentre, rebinij najc si'c xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Binij ni biajb lo nezyuj najc si'c rebejṉ ni rucuadiajg xtidx Dios. Dxejc riääd beṉdxab, riäddzucajni rediidxga lastooreni te na'c chalilajzreni xtidx Dios, te na'cza ḻaareni lo dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Binij ni biajb neṉ reguij najc si'c rebejṉ ni rucuadiajg xtidx Dios, rbaalajzreni; per sa'csi xheti xlobaareni, nälajznu, direni gandzu'tz xtidx Dios, rililajzreni te bo'c, per che rsacsí rebejṉreni, rbälazreni xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Binij ni biajb neṉ reyaguejch najc si'c rebejṉ ni rucuadiajg xtidx Dios, per laḻ ni sanuureni xnejzreni, rijia'nreni lo recos guedxliuj, lo yäḻnasa'c ni ruhuiireni, näjza rujnreni si'ctis ni rlajz tiejxhreni. Reni'c rujn runijtreni xtidx Dios, ni'cni direni guzoob xtidx Dios, direni chanuu te gunreni xtzunsa'c Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Binij ni riajb lo reyusa'c najc si'c rebejṉ nani rucuadiajg xtidx Dios, ni rililajz diidxga guideb te lastoya ni najc hueen. Randzu'tzreni xtidx Dios, dxejc rudeedreni te yälnasa'c, nalajznu ruzoobreni xtidx Dios, rujnreni xtzunsa'c Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Räjpzani: ―Ruti te bejṉ ni rucuaguij te bajl dxejc rusäuni te caj yejc bajlga, dizani gusujnini dejtz te loon. Alga rusoobnini neṉ candilieer loj te mex te guzanijni guideb neṉ yu'ga te reni jiu' fiireni lo bajlga. ");
INSERT INTO zawNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Xhet yu'di ni yuchetzu'tzdi ni di guidzujṉ dxej guiluiini; xhet yu'diza ni naga'tz ṉaj ni di guidzujṉ dxej gacbee bejṉni. ");
INSERT INTO zawNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Ni'cni coḻcuadiagsa'c diidx; sa'csi guiraa rebejṉ ni rajp yäḻracbee, sajprureni yäḻnajn. Luxh reni di ninuu nucuadiajg xtidx Dios, lojni sibicaj näj ni abacuadiajgni, ni rchaloni najnni. ");
INSERT INTO zawNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Dxejc bidzujṉ xnan Jesús näjza rebejtzni cadro suga'ni, niluxh di niajcdi nibigreni lojni sa'csi tre' xhidalduxh bejṉ ro'c. ");
INSERT INTO zawNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Dxejcti huisa'n te bejṉ diidx loj Jesús, räjpni: ―Xnan guejblu näjza rebejtz guejblu suga' rolä', luxh rlajzreni fiireni lo guejblu. ");
INSERT INTO zawNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Badzu' Jesús diidxre lojreni, räjpni: ―Xnanä näjza rebetzä najc rebejṉ ni rucuadiajg, ni ruzoobza xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Te dxej biu' Jesús näjza rexpejṉpacni neṉ te barcw. Dxejc räjpni lojreni: ―Coḻcho' stelaad ro' nisre. Basyu'reni barcw lo nis, sä'tireni. ");
INSERT INTO zawNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Cheni sadejdreni galäii nisga, gudiejs Jesús neṉ barcw. Dxejc gubi' te beduxh lo nisga, luxh sa'csi lacti nadip ro' bejga, gusloj cayu' nis neṉ barcw, ameerli jiääz barcwga lo nis. ");
INSERT INTO zawNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Dxejcti huicuäänreni Jesús, räjpreni lojni: ―¡Mastr! ¡Mastr! ¡Cayääznu lo nis! Che gubajṉni, huistieni, dxejc gudidxa'ni lo bejga näjza lo nis ni cayäsjiaa. Dxejc guläjz bejga, guredxiza nisga. ");
INSERT INTO zawNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Dxejc räjpni lojreni: ―¿Con xcäḻrililajztu, ä? Per laareni bidxejbreni, bidxeloduxhreni, canabdiidxreni lo sa'reni: ―¿Chuni'c najc niguiire te rnibeeni bej näjza nis, luxh rusobdiajg bej näjza nis xtiidxni? ");
INSERT INTO zawNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bidzujṉtireni lo yuj xten Gadara ni tre' stelaad ro' nis nez loj reyuj xten Galilee. ");
INSERT INTO zawNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Cheni biäjt Jesús neṉ barcw baläjni lo yuj, gubig te bejṉ ni siääd guejdxga lojni. Agujc xchej yu' rebeṉdxab neṉ lastooni. Dini gacw xhajbni, dizani cuääz neṉ yu', alga rbäjzni cadro yu' rebaa. ");
INSERT INTO zawNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Che bahuiini loj Jesús bazuxhijbni nez lojni, guredxa'ni räjpni: ―¿Xhicuent riädchu'lu loonu, luj, Jesús Xi'n Gueb Dios ni rbäjz xhaguibaa? Rniabduxhä lojlu, na'cru gusacsílu nuurnu. ");
INSERT INTO zawNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Guniini rediidxre sa'csi canibee Jesús guirii rebeṉdxabga neṉ lastoo bejṉre. Agujc xchero cazob rniaaz rebeṉdxabga bejṉga ruliib rebejṉ ni'ni, ṉaani con cadeṉguiib te guilibdzu'tzni, te xhet gundini bejṉ. Niluxh laani rutiugya'ni recadeṉ, dxejc rebeṉdxabga rinärenini nez lo reyubijdz. ");
INSERT INTO zawNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús gunabdiidx lojni, räjpni: ―¿Chu laalu? Dxejc badzu'ni diidxre loj Jesús räjpni: ―Legión najc laä. Si'c guniini sa'csi xhidalduxh najc rebeṉdxab ni yu' neṉ lastooni. ");
INSERT INTO zawNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Dxejc gunabduxhreni loj Jesús na'c guxhaḻsacnireni cadro biriireni. ");
INSERT INTO zawNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Lagajc dxejc suga' xhidajl cuch cayajwreni guixa' lagajc nejzga lo te bala'. Dxejc gunab rebeṉdxabga loj Jesús te gusaanni jiu'reni neṉ recuchga. Che cuäjb Jesús, ");
INSERT INTO zawNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","biṟii rebeṉdxabga neṉ lastoo dade'ga, biugajcreni neṉ recuchga. Che biu'reni neṉ recuch, baxuṉ recuchga bitejbreni ro' te bala', dxejc biajbreni lo nis, ro'cti gujtreni. ");
INSERT INTO zawNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Baxuṉ reni cayajp recuchga che bahuiireni xhini'c gujc ro'c, huisa'nreni diidx lo rebeṉguejdxga näjza lo rebeṉ ṟench. ");
INSERT INTO zawNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Dxejc biädhuii rebejṉ xhini'c gujc ro'c. Che bidzujṉreni cadro suga' Jesús, bahuiireni loj bejṉ ni biṟii beṉdxab lastooni. Sobga'ni cuä' ni' Jesús, najcwni xhajbni, luxh xhetru rajcdi yejcni; dxejc bidxebduxh rebejṉga. ");
INSERT INTO zawNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Sas reni bahuiloj xho gujcni, bijreni diidx xho basiajc Jesús bejṉ ni guyu' rebeṉdxabre lastooni. ");
INSERT INTO zawNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Dxejc guiraa rebeṉ Gadara näjza reguejdx ni tre' nejzga, gunabreni jiunejz Jesús ro'c sa'csi cadxebduxhreni. Ni'cni biu' Jesús neṉ barcw te gubisacni nejz cadro siäädni. ");
INSERT INTO zawNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Dade' ni biṟii rebeṉdxab lastooni gunabni lo Jesús gusaanni chanajlnini, niluxh Jesús gunibee jia'nni, räjpni lojni: ");
INSERT INTO zawNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Gubi' rolijzlu te güilu diidx recosro ni bejn Dios xcuent luj. Dxejc sääni, batie'chni diidx guideb lo guejdxga xhi bennäj Jesúsni. ");
INSERT INTO zawNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Che gubi' Jesús stelaad nis, bibalajz rebejṉ gubi'ni, sa'csi cabäjzpacreni guibisacni. ");
INSERT INTO zawNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Dxejc bidzujṉ te bejṉ ni laa Jairo, ni rnibee te guidobäz, bazuxhijbni nez loj Jesús, gunabni chanänini rolijzni ");
INSERT INTO zawNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","sa'csi yu' tejtis xindxa'pni. Yu'ni tzubitio'p ijz, luxh cayacxhuuni, ameerli guetni. Laḻsi sää Jesús rolijzni, birinajl xhidalduxh bejṉni, catäälirenini. ");
INSERT INTO zawNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Loj rebejṉga nadxaag te gunaa ni agujc tzubito'p ijz cayacxhuuni, cayajcni yäḻguidxbäii. Xlia'si abanijtni guiraa xhixtenni cua' renani rujn remeed. ");
INSERT INTO zawNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Gubig gunaaga dejtz Jesús te gudajnni ro' xhajbni. Lagajc dxejc biacgajcni. ");
INSERT INTO zawNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Dxejcti gunabdiidx Jesús räjpni: ―¿Chuni'c najc ni gudajn narä, ä? Guiraa rebejṉ räjp: ―Dinu gan. Räjpza Pedr: ―Mastr, ni yu'lu galäii rebeṉ xhidajl, luxh cagutäälireni luj. ¿Xhicuent rniabdiidxlu: “¿Chu gudajn narä?” ");
INSERT INTO zawNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Räjppac Jesús lojni: ―Yu' chu gudajn narä, sa'csi gucbeä yu' chu basiajc xcäḻrnibeä. ");
INSERT INTO zawNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Che gucbee gunaaga anajn Jesús gudajnni xhajbni, bidxejbni, racsejslini gubigni loj Jesús, bazuxhijbni lojni. nez loj guiraa rebejṉ räjpni xhicuent gudajnni xhajbni näjza xho biacgajcni. ");
INSERT INTO zawNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Dxejc räjp Jesús lojni: ―Huij. Gulecdxilajzlu, xinda'pä. Abiajclu sa'csi huililajzlu. ");
INSERT INTO zawNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Laḻni canii Jesús si'c bidzujṉ te bejṉ ni siääd rolijz Jairo, ni rnibee te guidobäz. Räjpni loj Jairo: ―Agujt xindxa'plu. Na'cru gutajllu xtzuun Dad Mastr. ");
INSERT INTO zawNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Che biejn diajg Jesús rediidxga, räjpni loj Jairo: ―Na'c guidxejblu. Huililajztis te jiac xindxa'plu. ");
INSERT INTO zawNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Che bidzujṉreni rolijzni, xtebtis Pedr, Jacoob, Juan näjza xcuzajn dxape'ga biunäjni neṉ yu'ga. Peta rebejṉ ni siädnajlni bia'nreni rolä'. ");
INSERT INTO zawNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Cayonduxh guiraa rebejṉ ni sobga' neṉ yu'. Dxejc Jesús räjp lojreni: ―Na'c roontu, gajd dxape're guet, nagayejstisni. ");
INSERT INTO zawNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Alga baxhiznäjrenini, sa'csi anajnreni agujt dxape'ga. ");
INSERT INTO zawNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Dxejcti gunaaz Jesús ṉaa dxape'ga, dip guniini, räjpni lojni: ―¡Dxape', huistie! ");
INSERT INTO zawNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Dxejc gubaṉsac dxape'ga, huistiegajcni. Dxejc gunibee Jesús gudeedreni xhi gauni. ");
INSERT INTO zawNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bidxeloduxh rexcuzajnni. Per gunibee Jesús na'c güireni diidx xhini'c gujc ro'c. ");
INSERT INTO zawNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Batie' Jesús guitzubitio'p rexpejṉpacni te badeedni yäḻrnibee lojreni te cuääreni rebeṉdxab lastoo rebejṉ, näjza te gusiajcreni rebeṉracxhuu. ");
INSERT INTO zawNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Baxhaḻnireni te gusule'reni diidx xcuent xcäḻrnibee Dios näjza te gusiajcreni rebeṉracxhuu. ");
INSERT INTO zawNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Dxejc räjpni lojreni: ―Xhet chanäditu lo nejz, nicla bastoṉ, nicla bols, nicla yätxtiil, nicla meel; na'cza chanätu tio'p xhajbtu; tejtisni chanätu. ");
INSERT INTO zawNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Chutis rolijz bejṉ cadro guidzujṉtu, ro'c coḻjia'n cheni guiriilitu lo guejdxga. ");
INSERT INTO zawNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Palga direni gusaan jiu'tu rolijzreni, che jiunejztu lo guejdxga, coḻcuijb guxhuj ni'tu si'c te seen direni nililajz xtiidxtu. ");
INSERT INTO zawNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Dxejc biriireni sääreni garen-garen reguejdx, cagusule'reni xtidx Dios, cagusiajczareni rebeṉracxhuu cadrotis rdzujṉreni. ");
INSERT INTO zawNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Che biejn diajg Herodes ni rnibee guiraa ni cayujn Jesús, guyu'ni yärsia', dini gan xho gunni xhigab, sa'csi yu' reni canii laa Juan ni agubaṉsac lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Sgaiireni canii abaluiloj Elías. Yu'zareni canii pet laa stee niguii ni gunii xtidx Dios galoo ni agubaṉsac. ");
INSERT INTO zawNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Per räjp Herodes: ―Lagajc narä gunibeä biru' yejc Juan ni rutiobnis, ¿chuchani'c najc niguiire ni riejn diagä xhidajl didxro xcuentni? Dxejc rlajzpac Herodes fii lojni. ");
INSERT INTO zawNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Che gubi' rexpejṉpacni, bijreni diidx loj Jesús xhini'c bejnreni. Sas huinä Jesúsreni te lajt cadro ruti bejṉ, gajxh te guejdx ni laa Betsaida. ");
INSERT INTO zawNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Che gucbee rebejṉ caro sääreni, huinajlrenini bidxälrenini. Che siäädreni lojni huichaglojnireni, sas gusloj cagusule'ni lojreni xcuent xcäḻrnibee Dios. Basiajczani rebejṉ ni cayacxhuu. ");
INSERT INTO zawNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Che gusloj cayääz gubijdx, gubig rexpejṉpacni loj Jesús, räjpreni lojni: ―Gojs loj rebejṉre, agojḻ jiireni te chatiilreni xhi gaureni, näjza cadro tedreni guxhijṉ lo rerench, neṉ reguedxbäz, sa'csi ree xhet yu'di. ");
INSERT INTO zawNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Dxejcti räjp Jesús loj rexpejṉpacni: ―¡La'tu coḻgudeed xhi gaureni! Dxejc räjpreni lojni: ―Xhet rajpdinu, gaiitis yätxtiil näjza tio'p bäjl. Ni'ctis yu' palga dinu chasiiru xhi gau rebeṉ xhidajlre. ");
INSERT INTO zawNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Luxh najc rebejṉga si'cti gaii miḻ niguii. Dxejc räjp Jesús loj rexpejṉpacni: ―Coḻyejtz lojreni cuereni xcua-xcuaareni, si'cti tiuubitzugajreni te cuaa. ");
INSERT INTO zawNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Si'c bejnrenini, sas gurej guiraa rebejṉga si'c. ");
INSERT INTO zawNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Dxejc cua' Jesús gaii yätxtiilga näjza tio'p bäjlga, guläsni lojni xhaguibaa, badeedni xquixtios lo Dios xcuent yäḻrajwga. Che gulujx badeedni xquixtios gula'ni reyätxtiilga näjza rebäjlga, dxejc sanuutis badeednini loj rexpejṉpacni te gudisrenini loj rebejṉga. ");
INSERT INTO zawNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Guiraa rebeṉ xhidaalga gudajw, gudxaj xque'reni. Dxejcti batojpreni ni bia'n bachajreni tzubitio'p dxijm̲ yätxtilbiujy näjza bälbiujy ni bia'n. ");
INSERT INTO zawNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Te dxej laḻni cabedx-canab Jesús lo Dios, xtebni näjza rexpejṉpacni, gunabdiidxni lojreni, räjpni: ―¿Chuni'c rnii rebejṉ nacä? ");
INSERT INTO zawNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Dxejc räjpreni lojni: ―Yu'reni rnii najclu Juan ni rutiobnis; yu'zareni rnii najclu Elías; sgaiireni rnii najclu stee niguii ni gunii xtidx Dios galoo ni agubaṉsac. ");
INSERT INTO zawNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Dxejc gunabdiidxni lojreni, räjpni: ―¿La'tu a? ¿Chuni'c rniitu nacä? Dxejc räjp Pedr lojni: ―Luj najclu Crist Xi'n Dios ni cabääznu. ");
INSERT INTO zawNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Dxejc gunibee Jesús lojreni, räjpni: ―Na'c gäbtu si'c lo rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Räjpzani lojreni: ―Nanab ted Xi'n Niguii trabajwduxh; rebeṉgool xten guidoo, näjza rebixhojz, näjza rebejṉ ni ruluii xleii Moisés sibälazreni narä, naareni dina gacä Crist ni cabääznu. Sugu'treni narä Xi'n Dios ni gujc Niguii, niluxh sibaṉsacä ni riojṉ dxej. ");
INSERT INTO zawNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Dxejc räjpni loj guiraareni: ―Palga chu tejtu rlajz guirinajl narä, nanab jiäḻlajzni xhixtenni, te guixe-guixee guntisni nani gudedä gunni. ");
INSERT INTO zawNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sa'csi nani rlajz guiniazdzu'tzni xcäḻnabajṉni, sunijtni yälnabajṉ lo Dios; luxh nani runijt xcäḻnabajṉni xcuent xtidxä, sica'ni yäḻnabajṉ par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Sa'csi ¿xhi gaan gun te bejṉ palga xca'ni guideb guedxliuj, luxh gunijtni xcäḻnabajṉni lo Dios? ");
INSERT INTO zawNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Niluxh nani guituinäj narä näjza xtidxä, sigajcza narä, Xi'n Dios ni gujc Niguii, situinää́zani cheni jiäḻä si'c ṟeii guideb yäḻrdimbicha' xten Xtadä näjza rexanglni. ");
INSERT INTO zawNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Guliipac rniä lojtu, yu' gaii reni suga' ree, ni di guet, suhuixgaareni xcäḻrnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Gudejdti xhujṉ dxej gunii Jesús diidxre, dxejcru huinä Jesús Pedr näjza Jacoob näjza Juan, huijreni jiaa yejc te dajn te guredx-gunabni loj Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Laḻni cabedx-canab Jesús lo Dios, bidxaa xho ruluii lojni; dxejc xhajbni gujc nolbäj, rdimbicha'lini. ");
INSERT INTO zawNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Biricajza tio'p dade' caninäjrenini. Redade'ga najc toMoisés näjza Elías. ");
INSERT INTO zawNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Rdimbicha'za redade'ga. Caninäjreni Jesús xcuent xho guetni guedx Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Luxh Pedr näjza resa'ni guyuduxh bacaḻ lojreni; che bire'ch bacaḻ lojreni bahuiireni lo yäḻrdimbicha' xten Jesús näjza loj guiro'p redade' ni caninäjni. ");
INSERT INTO zawNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Cheni agojl jiunejz redade'ga loj Jesús, räjp Pedr loj Jesús: ―Dad, Mastr, huenduxh suga'nu ree. Basaan jiencheenu choṉ yue', tejni par luj, tejni par Moisés, steeni par Elías. Luxh di Pedr gaan xhini'c caniini. ");
INSERT INTO zawNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Laḻni caniini si'c, bire' te za gusloj cayäjt yejcreni, dxejc bidxejbreni che biu'reni neṉ zaga. ");
INSERT INTO zawNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Dxejcti biejn diajgreni neṉ zaga te xse' te ni gunii, räjpni: ―Dee najc Xi'nä ni sanälazä, coḻcuadiajg xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Che gulujx guniini rediidxga, bahuiireni sugaxteb Jesús. Dxejc niäutis ro'reni neṉ redxejga, rut lojdi bijreni diidx xcuent ni bahuiireni ro'c. ");
INSERT INTO zawNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Barayääl cheni biäjtreni yejc dajnga, xhidalduxh bejṉ cabäjz Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Dxejcti te dade' ni nadxaag rebejṉga guredxa'ni, räjpni loj Jesús: ―Mastr, balaslajz narä, gudahuii xi'nä, sa'csi xtebtisni najcni xinganä. ");
INSERT INTO zawNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Luxh beṉdxab rniaazni, sas ruscuedxa'nini, rajcni si'c yäḻguidxbej, rbääni bitzuṉ ro'ni, rusacsíduxhnini, luxh dini gusaanni. ");
INSERT INTO zawNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Agunabä loj rexpejṉpaclu nibääreni beṉdxabga, luxh di niajcdini. ");
INSERT INTO zawNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Dxejc badzu' Jesús diidxre, räjpni: ―¡Bejṉ ni di chalilajz, beṉguijdx! ¿Gucli chunää́tu, gucli gunä huant la'tu? ¡Gudanä xi'nlu ree! ");
INSERT INTO zawNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Dxejc che cabig biuuxga lojni, basäḻta' beṉdxabga biuuxga lo yuj, sas gusloj cayajcni si'c yäḻguidxbeduxh. Dxejc gudidxa' Jesús loj beṉdxabga, basiacgajcni biuuxga, dxejc badeednini lo xtadni. ");
INSERT INTO zawNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Guiraa rebejṉ bidxeloduxh yäḻrnibeduxh xten Dios. Laḻni cadxeloj rebejṉ lo recos ni bejṉ Jesús, räjpni loj rexpejṉpacni: ");
INSERT INTO zawNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Coḻcuadiajgsa'c rediidxre, na'cza jiäḻlajztureni, sa'csi sutedreni narä Xi'n Dios ni gujc Niguii ladzṉaa rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Niluxh di rexpejṉpacni niacbee xhi säloj rextiidxni, sa'csi Dios bacua'tznini lojreni te di niacbeerenini. Bidxejbzareni niniabdiidxreni loj Jesús xhi säloj rediidxga. ");
INSERT INTO zawNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Guslojza rexpejṉ Jesús canabdiidx lo sa'reni: ―¿Chuchani'c sajcru loonu? ");
INSERT INTO zawNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Per gucbee Jesús xhi xhigab cayujnreni. Dxejc cua'ni te biuxbäz, bazujnini cuä'ni, ");
INSERT INTO zawNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","räjpni lojreni: ―Chutis ni xca' te biuxe' sa'csi sanälajzni narä, naräni rca'ni luxh ni rca' narä, rca'ni xtadä ni baxhaḻ narä. Ni najc maazru nadolajz lojtu, ni'c najc ni sajcru. ");
INSERT INTO zawNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Dxejc räjp Juan loj Jesús: ―Mastr, bihuiinu loj te bejṉ ni rbää rexpeṉdxab neṉ lastoo bejṉ con xcäḻrnibee lajlu. Dxejc rie'tznu lojni na'cru gunni si'c, sa'csi dini sanäj nuurnu. ");
INSERT INTO zawNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Dxejc räjp Jesús lojreni: ―Na'c gudxojntuni, sa'csi nani di guiniyaj nuurnu, xlaadnu yu'ni. ");
INSERT INTO zawNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Che siäddzujṉ redxej ni chää Jesús xhaguibaa, bejnni xhigab chääpacni guedx Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Baxhaḻni gaii bejṉ gunijd lojni chääreni te guejdx xten Samaria te satiilreni cadro jia'nreni ro'c. ");
INSERT INTO zawNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Luxh rebejṉ samaritaṉ di rlajzreni gudedlaareni te lajt cadro jia'nreni, sa'csi najnreni chääreni guedx Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Che biejn diajg Jacoob näj Juan, tio'p xpejṉpacni, si'c, sas räjpreni loj Jesús: ―Dad, ¿La rlajzlu guinibeenu jiäjt guiboo xhaguibaali te guze'cni guiraa rebeṉguejdxga si'cni bejn Elías? ");
INSERT INTO zawNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Dxejc bahuii Jesús lojreni, gudidxa'ni lojreni, räjpni: ―Ditu gaan chuni'c rnibee lastootu. ");
INSERT INTO zawNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Sa'csi narä Xi'n Dios ni gujc Niguii dina niäḻä te gudzucaä xcäḻnabajṉ rebejṉ. Narä biäḻä te gusḻaä́reni lo dojḻ. Dxejcti huijreni garenca guejdx. ");
INSERT INTO zawNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Laḻni sääreni lo nezyuj, biääd te bejṉ gunii loj Jesús, räjpni: ―Dad, narä rlazä jiädnalä guejblu cadrotis chää guejblu. ");
INSERT INTO zawNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Dxejc badzu' Jesús diidxre lojni, räjpni: ―Rebäjz rajp xpiliääreni, remane' ni rutajt rajp xpitiääzreni, niluxh narä Xi'n Dios ni gujc Niguii, dina gapä nicla te lajt cadro guscugä yecä. ");
INSERT INTO zawNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Dxejcti räjp Jesús lo stee bejṉ: ―Gudanajl narä. Luxh laani räjpni: ―Dad, basaan suchacua'tzxgaä́ xtadä, dxejcru jiädnalä guejblu. ");
INSERT INTO zawNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Dxejc räjp Jesús lojni: ―Basaan suchacua'tz rebejṉ ni najc si'c beṉgut, resabeṉgutreni. Per luj, huij, huisule' diidx xcuent xcäḻrnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Dxejc räjp steeni lojni: ―Dad, rlazä jiädnaḻä́lu, niluxh basanxgaa chasadidxä resa'ä ni tre' rolizä. ");
INSERT INTO zawNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Dxejc räjp Jesús lojni: ―Nani ruzuj ṉaani yejc garaad, dxejc rudzuré lojni ruhuiini nez dejtzni di gacdi gunni dzuun lo xcäḻrnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Che gulujx reni'c, gule Jesús gayoṉbitzuu bejṉ, baxhaḻnireni tio'pgajreni te basnijdnireni lojni loj reguejdx cadro nanab tedni. ");
INSERT INTO zawNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Räjpni lojreni: ―Guliipacni, cayacduxh cose'ch, niluxh guxii najc rebejṉ ni gun dzuun gutie'nini. Ni'cni coḻguiniab lo baxhuaan xten cose'ch te guxhaḻni xhidajlru bejṉ ni gun dzuun gutie' xcose'chni. ");
INSERT INTO zawNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Coḻchäj la'tu; coḻhuii xho ruxhaḻä la'tu si'c xiil galäii recuyo't sa'csi sunnäjreni la'tu si'ctisni rlajzreni. ");
INSERT INTO zawNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Na'c chanätu ngodx, niclaza guijxh, niclaza xcura'chtu, luxh na'c sudxitu guininäjtu bejṉ lo nejz. ");
INSERT INTO zawNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Cheni jiu'tu rolijz te bejṉ, ganiddoo coḻye'tz: “Sucuedxilajz reni rbäjz ree.” ");
INSERT INTO zawNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Palga najcni te bejṉ ni rdxaglajz yäḻrbecdxilajz sia'n xcäḻrbecdxilajztu ro'c, luxh palga dini gac, sibi' xcäḻrbecdxilajztu lojtu. ");
INSERT INTO zawNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Coḻjia'n lagajc rolijz bejṉ cadro guidzujṉtu. Ro'c coḻtajw, coḻyä'za xhitis ni guniidxreni, sa'csi nani rujn dzuun, riäjḻ xca'ni xcuent dzuunga. Coḻjia'n tejtis lajt dxejtis ni chutu lo guejdxga. ");
INSERT INTO zawNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Xhitis te guejdx ni jiu'tu, palga jiureni la'tu, coḻgajw xhitis ni guniidxreni lojtu. ");
INSERT INTO zawNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Coḻgusiajc rebeṉracxhuu ni yu' ro'c, coḻye'tz lojreni: “Abidzujṉgajxh xcäḻrnibee Dios.” ");
INSERT INTO zawNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Palga jiu'tu te guejdx cadro di rlajzreni gucuadiajgreni xtiidxtu, coḻṟii lo nezyuj, ro'c coḻye'tz lojreni: ");
INSERT INTO zawNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Guxhuj xten lajdxtu ni rcaj ni'nu, rudzu'nuni nez lojtu si'c te seen sa'csi ditu nililajz xtiidxnu. Coḻgacbee dee, abidzuṉgajxh xcäḻrnibee Dios lojtu.” ");
INSERT INTO zawNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ni'cni rniliä́pac lojtu, che gac fis xten Dios, nalasru gac fis xten Dios lo guejdxga loj ni gujc guedx Sodoma ni guyu' galoo. ");
INSERT INTO zawNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Räjpzani: ―¡Probe'tu beṉ guedx Corazín! ¡Probe'zatu beṉ guedx Betsaida! Paru nuhuii rebeṉzijt ni gubajṉ guedx Tiro näjza Sidón remilaagwr ni benä nez lojtu, pet gucli nusiechlajzreni, niajcwreni ladnagas, nibejzareni lo cobdäj si'c te seen abasiechlajzreni. ");
INSERT INTO zawNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Che gun Dios fis rextojḻ rebejṉ guedxliuj, guxiiru gac xfis Dios lo rebeṉzijt ni gubajṉ guedx Tiro näjza Sidón. Fisroru gun Dios reguedx Corazín näjza Betsaida. ");
INSERT INTO zawNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Luxh luj guedx Capernaum, rchalolu siäjslu xhaguibaa, alga siajblu gabijlli, cadro gaclu fisro xten Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Rajpzani lo rexpejṉpacni: ―Ni riu xtiidxtu, laa xtidxä ni riuni. Nani di jiu xtiidxtu, laa xtidxä ni dini jiu. Luxh ni di jiu xtidxä, laa xtiidx ni baxhaḻ narä ni dini jiu. ");
INSERT INTO zawNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Che gubi' regayoṉbitzuu bejṉ nani baxhaḻ Jesús, rbaduxh lajzreni, räjpreni: ―Dad, näjza rebeṉdxab rusobdiajg xtiidxnu che rusä'tnu lajlu. ");
INSERT INTO zawNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Räjp Jesús lojreni: ―O'n. Ni'cni narä bahuiä che gunijt xcäḻrnibee beṉdxab, bitejbni xhaguibaa si'c bianij xten guzii. ");
INSERT INTO zawNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Coḻgacbee. Narä runidxä yäḻrnibee lojtu te guläjtu yejc bäḻ näjza yejc naxejb; runidxäza yäḻrnibee te guntu gaan lo xcäḻrnibee beṉdxab. Xhetliidi gun daan la'tu. ");
INSERT INTO zawNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Na'c guibalajztistu sa'csi rusobdiajg rebeṉdxab xtiidxtu; coḻguibalajzru sa'csi acuaj lajtu lo xquijtz Dios xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lagajc dxejc bibalaznäj Jesús Sprit Dxan xten Dios, dxejc räjpni lo Dios: ―Rliä'pä xpala'nlu Xtadä ni rnibee xhaguibaa näjza guedxliuj, sa'csi bacua'tzlu xnezyujlu lo rebeṉ nanduxh, per baluiilu xnezyujlu loj rebejṉ ni najc nadolajz si'c te biuxbäz. O'n, Xtadä, sa'csi si'c rlajzlu gunlu. ");
INSERT INTO zawNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Guiraa recosre abaniidxlu loä Xtadä. Dadtis najn chuni'c najc Xi'nni, rutru najndi chu najcni. Rutza najndi chuni'c najc Guejblu Xtadä, xtebtis narä ni najc Xi'nlu, con rebejṉ ni rlazä gumbee luj. ");
INSERT INTO zawNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Dxejc bahuii Jesús loj rexpejṉpacni, räjpni lojtisreni: ―Chicbaa la'tu näjza renani ruhuii guiraa nani cahuilojtu. ");
INSERT INTO zawNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Sa'csi rniliä lojtu, balti redade' ni gunii xtidx Dios galoo, baltiza reṟeii rlajz nuhuiireni guiraa ni cahuilojtu, niluxh direni nuhuiini. Rlajzreni niejn diajgreni rediidxre ni cayejn diajgtu, luxh di diajgreni niejnni. ");
INSERT INTO zawNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Dxejc huisulii te mastr xten leii, huininäjni Jesús, rlajzni nuxhiidni Jesús lo xtiidxni, gunabdiidxni lojni: ―Dad, Mastr, ¿xhini'c nanab gunä te guibaṉnää́ Dios par tejpas? ");
INSERT INTO zawNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Sas räjp Jesús lojni: ―¿Xhini'c caj lo guijtz xten leii? ¿Xho roḻluni? ");
INSERT INTO zawNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Dxejc badzu'ni diidxre, räjpni: ―Chanälajzlu Dad, Xtioslu guideb lastoolu, guideb xaimlu, guideb xtijplu, näjza guideb xcäriejnlu. Huinälajzza resa'lu si'ctis ni sanälajzlu lagajc luj. ");
INSERT INTO zawNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Dxejc räjp Jesús lojni: ―O'n, laaca rudzu'lu diidx. Palga gunlu si'c, sajplu yäḻnabajṉre. ");
INSERT INTO zawNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Per mastr xten leii, rlajzni nidedbiani ni'cni gunabdiidxni loj Jesús räjpni: ―¿Chuni'c najc resa'ä? ");
INSERT INTO zawNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Dxejc räjp Jesús lojni: ―Te beṉ laadxnu birii guedx Jerusalén, sääni guedx Jericó. Dxejc lo nezyuj biricaj gaii gubaan, gulajnreni guiraa xhixtenni, näjli xhajbni ni najcwni. Sas gudijnrenini, basa'nrenini ro'c, guxii cayäädx nugu'trenini. ");
INSERT INTO zawNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Gudejd te bixhojz ni siääd laadxnu, sazaj lagajc nezyujga, cheni bahuiini lojni, alga gudejdni stee laad, sä'tini. ");
INSERT INTO zawNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Gudejdza te levita, bejṉ ni rujnza dzuun neṉ guidoo. Che bidzujṉni cadro naga' bejṉga, gudejdni stelaad, sä'tini. ");
INSERT INTO zawNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Dxejcti te beṉ Samaria, laḻni sääni biaj, gudejdni nezyujga, bidzujṉni cadro naga' bejṉga. Che bahuiini lojni, balaslajznini. ");
INSERT INTO zawNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Gubigni loj bejṉga, basäḻni se't näjza bin loj bejṉ ni nadxälguijdx, dxejc batejbnini te la' lajd. Dxejc bascuijbnini dejtz lagajc xmanni, huinänini cadro rudedlaareni yu', ro'c cuanäjnini. ");
INSERT INTO zawNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Che bara yääl, gulääni tio'p meel badeedni lo baxhuaan yu'ga. Dxejc räjpni: “Cuanälaa bejṉre; palga gunijtrulu, siguixätini lojlu che guibi'ä.” Sä'tini. ");
INSERT INTO zawNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Dxejc räjp Jesús lo mastr xten leii: ―¿Chu tej lo guidxoṉ rebejṉga najc si'c sa' xten dade' ni biajb ladzṉaa gubaan? ");
INSERT INTO zawNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Dxejc räjpni loj Jesús: ―Ni balaslajz bejṉga. Dxejc räjp Jesús lojni: ―Huij te sigajcza chayejnlu. ");
INSERT INTO zawNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Laḻni huinuu xnezyujni, bidzujṉni te guejdx. Ro'c bidxaagni te gunaa ni laa Mart ni huinänini rolijzni. ");
INSERT INTO zawNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Yu' te bäjl Mart ni laa Marii, luxh laani gurejni cuä' ni' Jesús te cacuadiajgni xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mart cagusquejṉni cayujnni xhi gaureni. Sas gubigni loj Jesús, räjpni lojni: ―¿La dilu jiu rusanxteb bälä narä te xtebä cayunä remandaad? ¡Gojs lojni gacnäjni narä! ");
INSERT INTO zawNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Dxejc räjp Jesús lojni: ―Mart, Mart, cayuduxhlu yärsia', riulu xhidajl cos, ");
INSERT INTO zawNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","luxh yu' tejtis ni nanabpac. Agule Marii ni najc huenru, rut sajcdi gudzucajnini lojni. ");
INSERT INTO zawNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Te huält cabedx-canab Jesús loj Xtadni Dios, suga'ni te lajt. Che gulujx cabedx-canabni, gunii te xpejṉpacni lojni, räjpni: ―Dad, baluii nurnu xho cuedx-guiniabnu lo Dios, si'c baluii Juan ni batiobnis rexpejṉpacni. ");
INSERT INTO zawNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Dxejc räjp Jesús lojreni: ―Che cuedx-guiniabtu lo Dios, scree coḻnii: Xtadnu ni yu' xhaguibaa, suchä'p xpala'nlu, sujiääd xcäḻrnibeelu. Sugac si'ctisni rlajzlu gac lo guedxliuj si'cpac rajcni xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Guira dxej baniidx xcu'nnu si'ctis ni rquiinnuni. ");
INSERT INTO zawNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Basiäjḻ lajzlu redojḻ xtennu si'cni riäjḻ lajznu redojḻ ni rujn rebejṉ loonu. Na'c gusaanlu jiajbnu lo xcäḻrnibee beṉdxab. Basḻaa nuurnu lo dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Dxejc räjpza Jesús lojreni: ―Paru tejtu yu' te xamiigwni, luxh guidzujṉni rolijzni garol yääl, gäbni: “Xamigwä, banidxlaa choṉ yätxtiil, ");
INSERT INTO zawNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","sa'csi bidzujṉ te xamigwä rolizä ni bazaj biaj, luxh xhet ra'pädi te gudedä xhi gauni.” ");
INSERT INTO zawNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Xhixh sinii ni naga' neṉ xyu'ni, gäbni: “Na'c riädtie'chlu bacaḻ loä. Niäu rolä' luxh rexi'nä naga' cuä'ä, digacdi chästieä te gunidxä xhi gunidxä lojlu.” ");
INSERT INTO zawNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Rniliä lojtu, mase dini chastie te gudeednini sa'csi najcni xamiigwni, sistieni, sudeedni nani rquiintisni te na'cru gutie'chni bacaḻni. ");
INSERT INTO zawNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Sigajcza rniä lojtu, palga guiniabtu xhi guiniabtu, sica'tuni. Palga chatiiltu xhi chatiiltu, sidxältuni. Palga chasejztu rolä', suxhalreni rolä' lojtu. ");
INSERT INTO zawNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sa'csi chutis ni rniab, rca'ni nani rniabni; chutis ni rguiil xhi cos, rdxälnini; nani rusejz rolä', suxhalzareni lojni. ");
INSERT INTO zawNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Paru tejtu ni najc dad, jiääd te xi'ntu guiniabni te yätxtiil lojtu, ¿la sudeedtu te guij, ä? O palga guiniabni te bäjl, ¿la sudeedtu te bäḻ, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O palga guiniabni te tzutbejt, ¿la sudeedtu te naxejb, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Palga la'tu, ni najc beṉdojḻ, rajc rudeedtu cossa'c loj rexi'ntu, aticaxh Dios ni yu' xhaguibaa sudeedni Sprit Dxan xtenni loj renani rniabni lojni. ");
INSERT INTO zawNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Gulää Jesús te beṉdxabgop lastoo te bejṉ. Che birii beṉdxabga lastoo bejṉga, guslogajc canii bejṉga, dxejc bidxeloduxh rebeṉ xhidaalga. ");
INSERT INTO zawNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Dxejc yu' reni räjp: ―Niguiire rbää rebeṉdxab con yäḻrnibee xten Beelzebú ni rnibee loj rebeṉdxab. ");
INSERT INTO zawNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Sgaiireni rlajz guquiilrenini, ni'c canabreni gunni te seen ni siääd xhaguibaali. ");
INSERT INTO zawNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Niluxh laani gucbeeni xhi xhigab cayujnreni dxejc räjpni lojreni: ―Xhitis gubieer ni rlia' sa'ni lo sa'ni, luxh tiḻnäj te cuaani stee cuaaga, di gacḻaa sinijt gubierga lo guedxliuj. Palga te famiḻ rdiḻnäj lagajc sa'ni, di gacḻaa sinitloj famiḻga. ");
INSERT INTO zawNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Palga guiliä' sa' rebeṉdxab, ¿xho mood chanuu xcäḻrnibeereni? Dee rniä sa'csi la'tu rniitu narä rbää́ rebeṉdxab con lagajc yäḻrnibee xten Beelzebú. ");
INSERT INTO zawNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Palga si'c najcni, ¿chuni'c rudeed yäḻrnibee loj rexpejṉtu te rbääreni beṉdxab? Lagajc laareni ruluii xhet laadi rujntu xhigab. ");
INSERT INTO zawNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Palga narä rbää́ rebeṉdxab con xcäḻrnibee Dios, ni'cni ruluiloj abidzujṉ xcäḻrnibee Dios lojtu. ");
INSERT INTO zawNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Cheni suga' te beṉdaan, ca'ni guiib, canäjni rolijzni, rutliidi ruhuaḻdi rexhixtenni. ");
INSERT INTO zawNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Niluxh che jiääd stee ni nadipru lo beṉdaanga, rudxagdijḻnini, rujnni gaanni, dxejc rudzucajni xquiibni ni badeed yäḻbeṉdaan lojni, dxejc sajc chanäni guiraa rexhixtenni. ");
INSERT INTO zawNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Reni xhet yu'di xladä, rdxe'chreni loä. Ni di gutopnäj narä, rutie'chni. ");
INSERT INTO zawNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Räjpzani: ―Cheni rii te beṉdxab neṉ lastoo te bejṉ, ricansajni nez lo reyubijdz, caguiilni cadro gusilajzni. Che cad rdxäldini, rujnni xhigab, naani: “Guibisacä rolizä cadro biriä.” ");
INSERT INTO zawNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Cheni guibi'ni, rdxälni lastoo bejṉga si'c te yu' ni entis gulujx bilioobni, suchesa'cni. ");
INSERT INTO zawNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Dxejcti rixiini sgajdz beṉdxab ni rujnru latsiaj lojni. Dxejc riu'reni neṉ lastoo bejṉga, dxejc nalasru ria'n bejṉga loj ni gujcni galoo. ");
INSERT INTO zawNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Laḻ ni canii Jesús rediidxre, te nane' ni yu' lo rebeṉ xhidaalga dipli guniini, räjpni: ―¡Chicbaa nan ni biädnälu guedxliuj! Chicbaaza nani basḻaa luj. ");
INSERT INTO zawNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Luxh laani räjpni: ―Xhet si'cdi najcni; chicbaaru rebejṉ ni rucuadiajg xtidx Dios, ni ruzoobza xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Sanuutis cadojp rebejṉ gabi Jesús, dxejc guslojni caniini, räjpni: ―Rebejṉ ni yu' ṉaj beṉguidxduxhreni, rniabzareni te milaagwr si'c te seen; niluxh xhetru seendi fiireni, seentis xten Jonás, dade' ni gunii xtidx Dios galoo fiireni. ");
INSERT INTO zawNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Lagajc si'c ni gujc Jonás te seen loj rebejṉ guedx Nínive, si'cza narä, Xi'n Dios ni gujc Niguii, gacä te seen lo rebejṉ ni nabajṉ ṉaj. ");
INSERT INTO zawNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Cheni guidzujṉ dxej ni gac fis sistie te nane' ni gujc rein lo reyuj ni tre' ladbäjgw, sucuaquijni rebejṉ ni tre' guedxliuj ṉaj sa'csi laani biriini zitduxh te bacuadiajgpacni yäḻnajn xten Salomón. Ree suga' galäiitu tej ni sacduxhru lo Salomón, ");
INSERT INTO zawNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","luxh ditu chalilajz xtiidxni. Rebejṉ ni guläjz guedx Nínive sisiunäj rebejṉ ni nabajṉ ṉaj neṉ redxej ni gac fis. Dxejc sucuaquijreni rebejṉ ni nabajṉ ṉaj sa'csi laareni, che huinäli Jonás xtidx Dios lojreni, basiechlajzreni, basa'nreni xtojḻreni. Ni suga' lojtu ṉaj sajcruni lo Jonás, niluxh ditu jiu xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Räjpzani: ―Rut rucuaguijdi te bajl, te gusujnini te lat xhiga'tz, niclaza neṉ te caj. Susujni bajlga jiaa te rajc ruhuisa'c chutis ni riu' neṉ yu'. ");
INSERT INTO zawNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Balojlu najc si'c bajl xten xcäriejnlu. Palga ruhuisa'c balojlu, guideb xcäriejnlu yu' si'c bianij. Palga rajc balojlu dilu fisa'c, guideb xcäriejnlu yu' si'c lo nacäjy. ");
INSERT INTO zawNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gunatiro te di gac xpianijlu yäḻnacäjy. ");
INSERT INTO zawNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Palga guideb xcäriejnlu yu' bianijtis, xheti te lajt nacäjy, sajc fisa'clu guira'ti, si'c najc che rusanij te bajl neṉ yu'. ");
INSERT INTO zawNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Che gulujx gunii Jesús, biädgajṉ te farisee Jesús chääni rolijzni te chatajwni. Sä'tireni. Che biu' Jesús, gurejni lo mex. ");
INSERT INTO zawNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Bidxeloj fariseega sa'csi dini niguiib ṉaani si'cpac caj lo xleii Moisés gunreni te gaureni, sa'csi rujnreni xhigab si'c racnayareni lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Dxejcti räjp Jesús lojni: ―La'tu ni najc refarisee, rguiibtu nez dejtz te bas näjza te pla't, niluxh la'tu guidxa lastootu yäḻgubaan näjza yäḻlatsiaj. ");
INSERT INTO zawNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Beṉ nadduxh! ¿La ditu gacbee? Nani benchee dejtzni, bencheeza neṉni. ");
INSERT INTO zawNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Coḻyajc nadolajz, coḻyacnäj rebejṉ con ni rniitu, dxejc guiraa recos sajc naya par la'tu. ");
INSERT INTO zawNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Probe'zatu, beṉ farisee! Rudeedtu lo Dios tej lo tejga tzuu ni rajptu: rudeedtu bedzxtiil näjza ruud, näj guiraa recuane' ni rajptu lo le', niluxh ditu jiu xcäḻguxhtis Dios näjza xcäḻrinälajz Dios. Dee nanab guntu ganid, luxh na'cza gusaantu guntu ni alacayujntu par Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Proobza la'tu rebeṉ farisee! Rchaglajztu rbejtu lo reyagxhil xten rebejṉ ni sajc neṉ reguidobäz; rchaglajztu saru rnii rebejṉ “xchan Dad” lojtu che rijtu lo guii. ");
INSERT INTO zawNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Probe'zatu! La'tu najctu si'c rebaa ni di guzeṉ, rsiaj rebejṉ yejc cadro naga'reni luxh direni gan. ");
INSERT INTO zawNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Dxejcti badzu' tej rebejṉ ni ruluii leii diidxre lojni, räjpni: ―Dad mastr, che rniilu rediidxre, rniyajlu nuurnu. ");
INSERT INTO zawNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Dxejc räjp Jesús lojreni: ―¡Probe'za la'tu rebejṉ ni ruluii leii! Sa'csi rnibeetu gun rebejṉ recos naganduxh ni najc si'c te cargw naduxh ni di gacdi guu bejṉ. Luxh la'tu di rlajztu faḻtuni nicla con te bicueṉabäztu. ");
INSERT INTO zawNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Proobzatu! Sa'csi runcheetu xpaa redade' ni gunii xtidx Dios galoo, luxh najctu rexajg renani bagu't redade'ga. ");
INSERT INTO zawNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ni'cni najnpactu xhi gusajcreni, rchaglajzzatu redzuun ni bejn retoxtadgoldootu; si'cza gunnäjtu narä sa'csi laareni bagu'treni redade'ga, dxejc la'tu runcheetu xpaareni. ");
INSERT INTO zawNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Ni'cni gunii Dios, sa'csi yuduxh xcäḻnajnni, räjpni: “Suxhaḻä reniguii ni guinii xtidxä näjza reapost, luxh sugu'treni gaiireni, susacsízareni sgaiireni.” ");
INSERT INTO zawNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Loj rebejṉ ni nabajṉ ṉaj siniab Dios gudeedreni cuent xcuent xtiejn guiraa redade' ni gunii xtidx Dios ni bagu'treni cheni guc-cheeli guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Guislojni xtiejn toAbel, näjza xtiejnli Zacarías ni bagu'treni galäii nez lodxan neṉ guidoro. Ni'cni rniä lojtu, siniab Dios cuent xten xcäḻgujt guiraareni loj rebejṉ ni nabajṉ ṉaj. ");
INSERT INTO zawNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Probe'za la'tu, rebejṉ ni ruluii leii! Sa'csi rniitu la'tistu rajptu yäḻnajn, luxh di rlajztu chalilajztu xtidx Dios, dizatu gusaan chalilajz rebejṉ ni rlajz chalilajz xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Cheni räjp Jesús rediidxre, bidxe'ch rebejṉ ni ruluii leii näjza refarisee lojni. Dxejc guslojreni canabdiidxreni xhidalduxh diidx, ");
INSERT INTO zawNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","te cagula'tzreni don la sajc guiga'ni lo xhitis te diidx ni guiniini. ");
INSERT INTO zawNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Laḻ ni caniini, bidojp xhidajl miḻ bejṉ ro'c, calaro'li sa'reni. Dxejc gusloj canixgaa Jesús loj rexpejṉpacni, räjpni lojreni: ―Coḻnati levaduur xten refarisee, rusgueereni rniitisreni xhidajl diidx luxh direni gunni. ");
INSERT INTO zawNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Sa'csi xheti xhi niäu lojni ni di guxal lojni luxh xheti xhi naga'tz ni di jienloj. ");
INSERT INTO zawNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ni'cni guiraa ni guniitu lo nacäjy, sieṉni lo bianij xten dxej. Luxh ni gunii xhiga'tztu neṉ reyu' ni niäudzu'tz, sibedxa'renini rediidxga yejcli reyu'. ");
INSERT INTO zawNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Räjpzani: ―Rniä lojtu, xamigwä, na'c guidxejbtu rebejṉ ni sajc ju't tiejxhtu, dxejc xhetru sajcdi gunreni. ");
INSERT INTO zawNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Guiniä lojtu chuni'c nanab guidxejbtu. Coḻguidxejb nani che abadzucajni yäḻnabajṉ rajpni yäḻrnibee gusäḻni la'tu gabijl lo bajl ni cayejc par tejpas. Ni'csii coḻguidxejb. ");
INSERT INTO zawNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Anajntu sajc jio' gaii mane' tio'p melbäz, luxh di Dios jiäḻlajz nicla tej remane'ga. ");
INSERT INTO zawNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Rexquidxejctu abigab tebgajni. Na'c guidxejbtu; la'tu sajcrutu loj xhidajl remane'ga. ");
INSERT INTO zawNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Räjpzani: ―Rniä lojtu, guiraa rebejṉ nani rcäjp rililajzni xtidxä nez loj rebejṉ, narä Xi'n Dios ni gujc Niguii sicäpä najcni xpeṉä nez loj rexangl Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Luxh reni di guicäjp rililajzni xtidxä nez loj rebejṉ, sigajcza sunnää́ni nez loj rexangl Dios xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Chutis ni guinii te didxnaj xcuentä, susiäjḻlajz Dios laani. Niluxh chutis ni guiniyaj Sprit Dxan xten Dios, di Dios gusiäjḻlajz xtojḻni. ");
INSERT INTO zawNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Cheni chanäreni la'tu nez loj rebeṉ guidobäz o nez loj reguxhtis, na'c guntu xhigab xhi gudzu'tu diidx o xhini'c guiniitu, ");
INSERT INTO zawNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","sa'csi che guidzujṉ oṟ ni guiniitu, Sprit Dxan xten Dios suluiini xhini'c guiniitu. ");
INSERT INTO zawNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Te niguii ni nadxaag rebejṉ xhidaalga räjpni loj Jesús: ―Dad, Mastr, gojs lo betzä guniidxni gala' xhixtenä ni basa'n toxtadnu loonu. ");
INSERT INTO zawNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Dxejc räjp Jesús lojni: ―Dade', ¿chuni'c gule narä gunä yäḻguxhtis o gacä abogaad lojlu, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Dxejc räjpsac Jesús lojreni: ―Coḻnatiro, coḻgantzu' te di rlajztistu ga'ptu yäḻnasa'ctis sa'csi xcäḻnabajṉ bejṉ dini gac yäḻrajptis xhidajl xhi cos. ");
INSERT INTO zawNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Dxejcti bij Jesús te cuent, räjpni lojreni: ―Guyu' te beṉ rapduxh. Racduxh cose'ch lo rexcäjlni. ");
INSERT INTO zawNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Dxejcti gusloj bejnni xhigab: “¿Xhocha gunä? Dina gapä cadro cucheä recose'ch.” ");
INSERT INTO zawNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Sas bejnni xhigab: “Ananä xhini'c gunä. Gudzuḻä reyu' cadro rgucheä recose'ch, te gustiobä reyu'ga, te ro'c cucheä guiraa recose'ch näjza rexhixtenä.” ");
INSERT INTO zawNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Dxejcti siniä lo lastoä: “Lastoä, agulucheelu xhidajl xhi cos, sajlni xhidajl ijz. Basilajz ṉaj, gudajw, gu', bibalajz.” ");
INSERT INTO zawNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Dxejc räjp Dios lojni: “¡Beṉ najd! Lagajc guxhijṉre siniabä xaimlu. ¿Dxejca'? ¿Chu xca' guiraa recos ni gulucheelu?” ");
INSERT INTO zawNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Si'c sisiajc guiraa rebejṉ ni rguiiltis xcäḻnasa'creni lo guedxliujre, niluxh xhet rajpdireni loj Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Che gojḻ stera't, räjp Jesús loj rexpejṉpacni: ―Ni'cni rniä lojtu, na'c rujntu xhigab xcuent xho guibajṉtu o xhini'c gautu te guibajṉtu, niclaza xcuent lajd ni gacwtu. ");
INSERT INTO zawNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yäḻnabajṉ sajcruni lo yäḻrajw; tiejxhni sajcruni lo lajd ni rajcw bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","¡Coḻhuii rebaloo! Direni cue'c binij, dizareni gutojp cose'ch, dizareni ga'p nicla yu' nicla te cadro chuchee cose'ch, per rudeed Dios xhi rajwreni. ¿La xhet sajcdirutu loj rebalooga, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Luxh ¿Chu tejtu palga runduxhni xhigab sajc tioobruni sgarol metr? ");
INSERT INTO zawNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Palga di gacdi guntu nicla te cosbäz, ¿xhicuent ru'tu yärsia' xcuent xhi stee cos? ");
INSERT INTO zawNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’¡Coḻhuii xho rga' reguino'ch! Direni gun dzuun, dizareni gun lajd lo dzujb, luxh rniä lojtu, nicla ṟeii Salomón con guiraa xcäḻnasa'cni, dini nisiuchee si'c rsiuchee reguiiga. ");
INSERT INTO zawNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Palga rusuchee Dios recuaan ni rga' lo niaa, ni rial nadxej, luxh guixee-huijdx, che agubijdzni, rejcni lo däj, aticaxh Dios suniidx xhi gacw la'tu, ¡bejṉ nani guxii rililajz! ");
INSERT INTO zawNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ni'cni rniä na'c runtejtu xhigab xho quiiltu xhini'c gautu, xhini'cza yätu, na'c chutistu yärsia'. ");
INSERT INTO zawNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Si'ctis rujn rebeṉguedxliuj guideb xtijpreni rguiilreni rexhicosre. Niluxh xtadtu ni yu' xhaguibaa anajnni xhini'c rquiintu. ");
INSERT INTO zawNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","La'tu coḻquiiltis xcäḻrnibee Dios, dxejcti laani suniidxzani guiraa recos ni rquiintu. ");
INSERT INTO zawNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Räjpzani: ―La'tu ni najc rexilä'ä, na'c guidxejbtu, sa'csi rbaali lajz Dios, aguleni la'tu te la'tu guntu yäḻguxhtis lo xcäḻrnibeeni. ");
INSERT INTO zawNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Coḻguto' xhixtentu, coḻgudeedni loj rebejṉ ni caquinduxhni, te si'c guntu te bols ni di jiujxh, te chu yäḻnasa'c neṉni xhaguibaa cadro di gubaan jiu' niclaza xcabäj rexhicos. ");
INSERT INTO zawNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sa'csi cadro rajptu xcäḻnasa'ctu, ro'cza yu' lastootu. ");
INSERT INTO zawNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Räjpzani: ―¡Coḻsusiṉ! ¡Coḻhualguij rebajl! ");
INSERT INTO zawNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Coḻyujn si'c remos ni cabäjz guibi' xlam̲reni ni sää te sa', te cheni guibi'ni guxhalgajcreni rolä'. ");
INSERT INTO zawNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Chicbaa remos ni susiṉ che guibi' xlam̲reni. Rniliä́pac lojtu, lagajc xlam̲reni sajcwni xhajbni sibe'cni rexmosni lo mex, dxejc lagajc laani sudeedni xhi gaureni. ");
INSERT INTO zawNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mase guidzujṉni garol yääl, mase guidzujṉni cäjyru, palga guidxälni arexmosni susiṉ, ¡chicbaa remosga! ");
INSERT INTO zawNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Coḻyacbeepac, paru gacbee baxhuaan xten yu' xhi oṟ guidzujṉ gubaan rolijzni, dini gusaan guxhalreni rolijzni te cuanreni xhixtenni. ");
INSERT INTO zawNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Näjza la'tu coḻsusiṉ, sa'csi oṟ ni ditu gun xhigab jiäädni, sidzujṉ Xi'n Dios ni gujc Niguii. ");
INSERT INTO zawNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Dxejc gunabdiidx Pedr lojni, räjpni: ―Dad, ¿la lootisnu rujylu cuentre o la najcni par guiraa rebejṉ? ");
INSERT INTO zawNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Dxejc räjp Jesús lojreni: ―¿Chuni'c najc mos hueen, mos nasiṉ, ni rusannäj xlam̲ni guiraa rexmosni te gudeedni xhi gaureni che gaḻ oor, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Chicbaa mosga palga laaca cayujnni che guibi' xlam̲ni. ");
INSERT INTO zawNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Rniliä́pac lojtu, lam̲ga sudeed guiraa rexhixtenni te xcanäj mosgani. ");
INSERT INTO zawNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Per palga gun mosga xhigab neṉ lastooni: “Saclaa guibi' xlam̲ä”, sas guislojni gusacsíni resamosni, gunaa sigajc niguii, dxejc guisloj gauni, yäni, soozni; ");
INSERT INTO zawNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","sibi' xlam̲ni te dxej ni xhet cabäjzdinini, oṟ ni dini gun xhigab guidzujṉni. Dxejc sii sudeedni te castigwro lojni, sutiäjlni te duu dejtzni dxejc sinibeeni jiini, guidxaagni rebejṉ ni di gusobdiajg diidx. ");
INSERT INTO zawNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Mosga ni najn xhini'c rlajz xlam̲ni gac, luxh dini susiṉ, dizani guzoob xtiidxni, sutiälduxhreni duu dejtzni. ");
INSERT INTO zawNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Niluxh mos ni di gan xhi rlajz xlam̲ni gac, ni'c rujnni redzuun ni di xlam̲ni guidxaglajz gac, guxiiru castiigw gacni. Reni rca' xhidajl, xhidajlza riäjḻ gudeedreni; loj reni rca' yäḻrnibeduxh, xhiroobza siniabni lojni. ");
INSERT INTO zawNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Räjpza Jesús: ―Narä biälä te gucuaguiä guedxliujre; ¡malaii alagusloj cayejcni! ");
INSERT INTO zawNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Niluxh nanab tedä te yäḻrobnis ni säloj te trabajwduxh, ni'c cayuduxhä yärsia' cheni chale'lini. ");
INSERT INTO zawNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿La rujntu xhigab biälä te jiädnää́ yäḻrbedxi loj guedxliuj, ä? Rniä lojtu, dini gac si'c. Alga biäḻä te guilia'ä bejṉ lo sa'reni. ");
INSERT INTO zawNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Silia' sa' te famiḻ; loj gaiireni, sidxe'ch choṉreni loj tio'preni, luxh tio'preni sidxe'chza lo choṉreni. ");
INSERT INTO zawNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Silia' sa'reni; sidxe'ch dad lo xingaanni, luxh xingaanga sidxe'chza lo xtadni; nane' sidxe'ch lo xindxa'pni, luxh xindxa'pga sidxe'chzani lo xnanni; nansuegr sidxe'chni lo xculijzni, luxh gulijzga sidxe'ch lo xnansuegrni. ");
INSERT INTO zawNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Caniiza Jesús lo rebeṉ xhidajlga, räjpni: ―Cheni rhuiitu räjs reza nez lad jiät, rniitu: “Siajb nisguij.” Luxh riajbni. ");
INSERT INTO zawNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Che rbi' bej nez lad danbägw, rniitu: “Sacnalaa nadxej”, luxh si'c rajcni. ");
INSERT INTO zawNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Bejṉ ni rusguee! La'tu racbeetu xhi säloj reseen ni rieṉ lo guedxliuj näjza xhaguibaa, ¿xhicuent ditu gan xhi säloj retiemp ni dxunnu ṉaj, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Räjpzani: ―¿Xhicuent ditu quiil lagajc la'tu xhini'c najc hueen, xhini'c najc laaca te guntuni? ");
INSERT INTO zawNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Sa'csi palga yu' chuni'c chale'c xquejlu lo guxhtis, laḻni sanäni luj ro jusgaad, basiäjḻ diidx con laani lo nejz, te na'c chanäni luj lo reguxhtis, sa'csi dxejc reguxhtis suteedreni luj lo reguixhajg te gusäureni luj neṉ latzguiib. ");
INSERT INTO zawNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Luxh rniä lojlu, dilu guirii ro'c hasta gusa'lu quiixlu guiraa lojreni. ");
INSERT INTO zawNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Lagajc dxejc, gubig gaii reni huisa'nreni diidx loj Jesús xcuent gaii beṉ Galilee ni bagu't Pila't neṉ guidoo, bagu'chni xtiejnreni con xtiejn reman ni siädnäreni si'c gojn lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Sas räjp Jesús lojreni: ―¿La rujntu xhigab si'c gusajc rebeṉ Galileega sa'csi najcrureni beṉdojḻ lo rebejṉ lajdxreni? ");
INSERT INTO zawNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Narä rniä, dini gac si'c. Palga di'tu gusiechlajz sigajcza sejt guiragajctu. ");
INSERT INTO zawNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","O xcuent guitzunbichoṉ rebejṉ nani gujt che gubixh te oṟ ni laa Siloé yejcreni, ¿La rujntu xhigab najcrureni beṉ dojḻ lo rebejṉ ni rbäjz guedx Jerusalén, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Narä rniä, dini gac si'c. Palga di'tu gusiechlajz, sigajcza sejt guiragajctu. ");
INSERT INTO zawNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Dxejcti gusloj bij Jesús te cuent ni ruluiini lojreni, räjpni: ―Te dade' gojp te yagiigw ni basujni lo xyujni. Sas huihuiini don la caj ninejxh lojni. Luxh xhet ninejxhdi bidxälni. ");
INSERT INTO zawNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Dxejc räjpni loj bejṉ ni canäj xyujni, agujc choṉ ijz siädtilä ninejxh lo yajgre, luxh xhetini. Batin yajgre. ¡Xlia'si sujni lo yuj! ");
INSERT INTO zawNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Luxh xmosni räjp lojni: “Dad, basaanni steb ijz, gusḻaä́ yuj ni'ni, gusäḻä aboṉni. ");
INSERT INTO zawNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Palga xcaj ninejxh lojni steb ijz, laaca, palga dini xcaj, dxejc guitinnuni.” ");
INSERT INTO zawNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Te dxej ni rusilajz rexpejṉ Israel caguluii Jesús neṉ te guidobäz. ");
INSERT INTO zawNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ro'c suga' te nane' ni agujc tzunbichoṉ ijz racxhuuni. Beṉdxab caguscoodni, niluxh di gacdi suliini. ");
INSERT INTO zawNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Che bahuii Jesús lojni, gurejdxnini, dxejc räjp Jesús lojni: ―Gunaa, abasaan yäḻguijdxga luj. ");
INSERT INTO zawNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Che basujni ṉaani yejcni, lagajc dxejc gujc gusulii nane'ga. Dxejc guslojni calä'pni xpala'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Luxh dade' ni rnibee guidobäz bidxe'chni sa'csi basiajc Jesús nane'ga che najcni dxej ni rusilajzreni, ni'c gusloj cayäjpni loj rebejṉ: ―Xho'p dxej sajc gun bejṉ dzuun; neṉ redxejga sajc jiäädtu te jiajctu, per na'c jiäädtu dxej ni rusilajz rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Dxejc badzu' Jesús diidxre, räjpni lojni: ―¡Beṉ rusguee! ¿La di chutis tejtu guxhec xconni o xpurni te chanänini yäni nis, mase najcni dxej ni rusilajz bejṉ, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Luxh nane're najc te xagdoo toAbram, nani numbee Dios, ni agujc tzunbichoṉ ijz baliib beṉdxabni, ¿la digacdi guixecni lo xcäḻguijdxni mase najcni dxej ni rusilajz bejṉ, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Che gunii Jesús rediidxre, bianxtujy rebejṉ ni rdxe'ch loj Jesús, luxh rebeṉ xhidaalga cabalazduxhreni sa'csi cayujn Dios redzunro nez lojreni. ");
INSERT INTO zawNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ni'cni räjp Jesús lojreni: ―¿Xhocha najc xcäḻrnibee Dios? ¿Xhicha cojn guiniä najcni tebloj? ");
INSERT INTO zawNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Najcni si'c te bedz muxhtas ni rbe'c te bejṉ lo xyujni. Luxh che guiroobni, rajcni te yagro. Dxejc riääd remane' ni rutajt siädyunchee xpitiääzni loj rexhajcwni. ");
INSERT INTO zawNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Guniiza Jesús stehuält te gacbeereni xho guire'ch rextidx Dios. Räjpni lojreni: ―¿Xhicha cojn guntebloä xcäḻrnibee Dios? ");
INSERT INTO zawNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Najcni si'c levaduur ni rugu'ch te gunaa lo choṉ mediid ariṉ, luxh rusaguijni guiraa cojbga. ");
INSERT INTO zawNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Huinuu Jesús xnejzni sääni guedx Jerusalén. Laḻni sadejdni reguejdx näjza rerench caguluiini rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Dxejc gunabdiidx te bejṉ lojni, räjpni: ―Dad, ¿la guxii najc rebejṉ ni caḻaa loj rextojḻreni, ä? Dxejc räjpni lojreni: ");
INSERT INTO zawNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Dää rolä' cadro jiu' bejṉ xhaguibaa. Ni'cni coḻtip lajztu te jiu'tu ro'c, sa'csi xhidajl bejṉ rlajz jiu'reni ro'c, niluxh direni gun gaan. ");
INSERT INTO zawNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Cheni abasäu baxhuaan xten yu' rolä', dxejc la'tu ni suga' detz yu' guisloj gusejstu rolä', guiniitu: “Dad, baxhal-laa rolä'”, dxejc laani sudzu'ni diidx, siniini: “Dina ganä caro siäädtu.” ");
INSERT INTO zawNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dxejc guislojtu guiniitu: “Bidxunnäänu, bidaunäänu, bidunnäänu luj, baseedlu nuurnu lo xnezyuunu.” ");
INSERT INTO zawNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Dxejc siniini lojtu: “Rniliä́ lojtu, dipacnä gumbeä la'tu. Coḻjij guiraatu, beṉlatsiaj.” ");
INSERT INTO zawNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Dxejcti sonduxhtu, chubejli läjytu che fiitu abiu' toAbram, con toIsaac, con toJacoob, näjza guiraa redade' ni gunii xtidx Dios, suga'reni lo xcäḻrnibee Dios xhaguibaa, luxh la'tu di gacdi jiu'tu. ");
INSERT INTO zawNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Dxejga sidzujṉ xhidajl beṉzijt ni siääd ladjiaa, ladjiät, ladbäjgw, näjza ladbee, te jiu'reni lo xcäḻrnibee Dios xhaguibaa, ro'c sibejzareni lo mex. ");
INSERT INTO zawNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Luxh yu' reni rujntu xhigab guxii sajcreni ṉaj, sacduxhreni dxejc. Yu'za reni rchalotu sacduxh ṉaj, xhet sajcdireni dxejc. ");
INSERT INTO zawNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Lagajc dxejga, bidzujṉ gaii refarisee, räjpreni lojni: ―Huij, biunejz ree, sa'csi Herodes rlajz ju'tlu. ");
INSERT INTO zawNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Dxejc laani badzu'ni diidxre lojreni, räjpni: ―Gojz lo bäjzga, beṉ rusguee: “¡Bahuii! cabää́ rebeṉdxab lastoo rebejṉ, cagusiacä rebejṉ ni racxhuu nadxej näjza guixee, luxh huijdxli guluxä xtzunä.” ");
INSERT INTO zawNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Niluxh mase si'c gacni nanab chanuä xnezyuä nadxej näjza guixee, huijdx, sa'csi di gacdi guet te dade' ni rnii xtidx Dios ste'ca guejdx, guejdxtis Jerusalén sajc guetni. ");
INSERT INTO zawNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Probe'tu, la'tu beṉ Jerusalén! Rugu'ttu redade' ni riädnii xtidx Dios lojtu, rucuaazatu guij yejc rebejṉ ni ruxhaḻ Dios lojtu. Balti huält rlazä nuchagä sa'tu si'c ruchagsa' te guidco'c rexquidbäzni lajd xhigani, niluxh ditu nicäjp. ");
INSERT INTO zawNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Bahuii xho bianxteb xquidootu. Ni'cni arnixgaä lojtu, dirutu fii loä cheni guidzujṉli dxej ni guiniitu loä: “Chicbaa ni siääd xcuent Dios.” ");
INSERT INTO zawNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Che gojl te dxej ni rusilajz rexpejṉ Israel, huitajw Jesús rolijz tej ni rnibee loj refarisee. Cagula'tz gaii refarisee, guidon xhini'c gun Jesús, ");
INSERT INTO zawNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","sa'csi nez loj Jesús suga' te dade' ni guidxa guij tiejxhni. ");
INSERT INTO zawNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Dxejc gunabdiidx Jesús lo rebejṉ ni ruluii leii näjza lo refarisee, räjpni lojreni: ―¿La sajc gusiajcni te beṉracxhuu dxej ni rusilajz bejṉ o la di gacdini? ");
INSERT INTO zawNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Per laareni dxitis suga'reni, niäutis ro'reni. Dxejc cua' Jesús beṉracxhuuga, basiajcnini, gunibeezani biunejzni. ");
INSERT INTO zawNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Dxejc räjpni loj refarisee: ―Chu la'tu ni rajp te buṟ o te gon, palga jiajbni neṉ te bisie, ¿la ditu chalägajcni mase najcni dxej ni rusilajz bejṉ, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Dxejc di niajcni nudzu'reni diidx lojni. ");
INSERT INTO zawNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Cheni bahuii Jesús xho rchaglajz rebejṉ rbereni latsa'c te cuereni cuä' rebejṉro, bijni te cuent ni ruluii lojreni, räjpni: ");
INSERT INTO zawNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Cheni guidoṉtu chäätu te sa', na'c guntu te cuetu cuä' rebeṉro, te di guidzujṉ te beṉroru lojlu, ");
INSERT INTO zawNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","dxejc jiääd bejṉ ni cayujn lanij, naani lojlu: “Badeed cue dade're ro'c.” Dxejc situjylilu chacuelu ste'ca lajt lo le'li. ");
INSERT INTO zawNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Maazru hueen, cheni guidoṉlu chäälu te sa', huicue lo mex ni zuj lo le' te che guidzujṉ bejṉ ni cayujn lanij, naani lojlu: “Xamigwä, gudaa cuelu neṉ yu' cadro rbej rebeṉro.” Si'c sä'p xpala'nlu nez loj guiraa rebejṉ ni sobganäjlu lo mex. ");
INSERT INTO zawNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sa'csi ni rlajz chä'p xpala'nni nez loj rebejṉ, sianxtujyni nez lojreni. Luxh bejṉ ni najc nadolajz, sä'p xpala'nni nez loj guiraa rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Räjpzani loj bejṉ ni cagudeed xhi gaureni: ―Cheni gunlu te lanij o guteedlu bejṉ lo xmexlu, na'c cueedxtislu rexamigwlu con rebejtzlu, con resa'lu, niclaza rexpisiṉlu ni najc ri'cw, sa'csi laareni sigajcza sibejdxreni luj che gunreni te lanij, luxh si'c agudijxreni ni badeedlu lojreni. ");
INSERT INTO zawNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Che gunlu te lanij, alga gurejdx rebeṉproob, rebeṉcoj, näjza rebeṉlotiä'p, ");
INSERT INTO zawNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","dxejcti sibaa lajzlu sa'csi laareni di gacdi gunidxsacreni ni badeedlu lojreni; luxh si'c siguixsac Dios ni bejnlu che gaḻ dxej ni guibaṉsac rebejṉ loj rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Che biejn diajg tej reni sobga' lo mex, räjpni loj Jesús: ―Chicbaa rebejṉ ni gau yätxtiil cadro rnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Dxejc räjp Jesús lojni: ―Guyu' te dade' ni bejn te laniro rolijzni. Gunibeeni bidoṉ xhidajl bejṉ te jiädtaunäjrenini. ");
INSERT INTO zawNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Che bidzujṉ oṟ ni gaureni, baxhaḻ dade'ga te xmosni chatejdxni rebejṉ ni abidoṉ, räjpni lojreni: “Coḻchäj, asuchee lo mex.” ");
INSERT INTO zawNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Dxejc guiragajcreni gusloj cayäjb di gacdi chääreni. Tejni räjp: “Entis gusiä te la' yuj, luxh ṉaj nanab chahuiä xho najcni. Goslaa di gacdi jiäḻä.” ");
INSERT INTO zawNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Steeni räjp: “Gusiä gaii nejs gon, luxh nanab chahuiä xho rujnreni dzuun. Goslaa di gacdi jiäḻä.” ");
INSERT INTO zawNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Steeni räjp: “Entis bachṉaä ni'cni di gacdi jiäḻä.” ");
INSERT INTO zawNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Che gubi' mosga, badeedni diidx lo xlam̲ni xhi räjp rebejṉga lojni. Dxejc bidxechduxh lam̲ga, räjpni lo xmosni: “Basquejn huij ladnezyuj näjza ladnezyuj dää, gudanä rebeṉproob, rebeṉcoj, rebeṉlotiä'p, rebeṉnatiujṉc.” ");
INSERT INTO zawNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Si'c bejn mosga. Che gubi'ni räjpni lo xlam̲ni: “Dad, abenä si'c ni gunibeelu, luxh lajtru yagxhiil.” ");
INSERT INTO zawNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Dxejc räjp lam̲ga lo xmosni: “Huij lo renezyuj ni sii loj reguedxzijt, gudanäj rebejṉ ni guidxaaglu nejzga, te cha bejṉ rolizä. ");
INSERT INTO zawNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Rniliä lojtu, nicla tej reni bidoṉ ganid di gau xhuej nani benä.” ");
INSERT INTO zawNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Laḻ sasaj Jesús lo nejz, xhidalduxh bejṉ sanajlni. Dxejc gubiréni, gusloj cayäjpni lojreni: ");
INSERT INTO zawNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Palga yu' chu tej ni jiääd loä, ni di cuälaz xtadni, xnanni, chäälni, rexi'nni, rebejtzni, näjza rebisiajnni, nägajcza xcäḻnabajṉni, di gacdi gacni te rexpeṉä. ");
INSERT INTO zawNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Palga yu' chutis tej ni di rlajz tedni trabajw te jiädnajlni narä, di gacdi gacni te rexpeṉäpac. ");
INSERT INTO zawNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Chu tejtu ni rlajz gun te yuro, ni di gunxgaa xhigab lacti meel chanä yu'ga, te guidon la sajc guluuxnini. ");
INSERT INTO zawNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Didi cheni abejnni recimient, di gacdi guluuxnini, dxejc guiraa reni fii lojni suxhiznäjrenini, ");
INSERT INTO zawNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","säjpreni: “¡Bahuilaare! Bejṉre gusloj bencheeni te yu' per di niajcdi nuluuxnini.” ");
INSERT INTO zawNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","¿Chu te ṟeii ni gun xhigab chachagdijḻni stee ṟeii, ni di gunxgaa xhigab don laa sajc gunni gaan con tzuu miḻ soldaad loj stee ṟeii ni siääd con gajḻ miḻ soldaad, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Palga di gacdi gucuanäjnini, che gacbeeni zijtli siääd stee ṟeiiga, suxhaḻni te xpejṉni chanab yäḻrbedxi lojni. ");
INSERT INTO zawNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ni'cni palga chutis tejtu di gusaan rexhixtenni te jiädnajlni narä, di gacdi gacni te rexpeṉäpac. ");
INSERT INTO zawNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Räjpzani: ―Huen najc sejd. Per cheni diruni gac nadzujy, ¿xho gacru gac nadzujyni? ");
INSERT INTO zawNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Xhetru sajcdini, nicla te chääni loj yuj, niclaza te chääni lo aboṉ. Gusäḻtis bejṉ sejdga. Reni rlajz gucuadiajg xtidxä, sucuadiagsa'creni. ");
INSERT INTO zawNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Guiraa reni rusquijx impuest näjza rebeṉdojḻ cabigreni loj Jesús, te cuadiajgreni rextiidxni. ");
INSERT INTO zawNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Refarisee näjza rebejṉ ni ruluii leii gusloj camojm̲reni, räjpreni: ―Bejṉre rusaan rbig rebeṉdojḻ lojni, luxh raunäjzanireni. ");
INSERT INTO zawNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Dxejcti bij Jesús cuent ni ruluiire lojreni, räjpni: ");
INSERT INTO zawNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Chutejtu ni rajp tegayuu xiil, palga chanijtni tejni, ¿la dini gusaan stapbitzuubigaa rexiilni lo niaa te chatiilni xile' ni gunijt, hasta guidxällinini, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Luxh che guidxälnini sibaduxh lajzni, dxejc sutzuubnini ro xhajcwni. ");
INSERT INTO zawNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Che guidzujṉni rolijzni sutojpni rexamiigwni näjza rexpisiṉni te gäbni lojreni: “Coḻguibalaznäj narä sa'csi abidxälä xile' ni gunijt.” ");
INSERT INTO zawNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Rniä lojtu, sigajcza su'ru yäḻrbalajz xhaguibaa xcuent tejtis bejṉ ni guibig lo Dios ni gusiechlajz xtojḻni quela xcuent tapbitzubigaa bejṉ ni di guiquiin gusiechlazreni xtojḻreni. ");
INSERT INTO zawNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Räjpzani: ―Sigajcza te gunaa ni rajp tzuu meel, palga chasäḻni tejni, ¿la dini gusanij te bajl te guloobni neṉ yu' hasta guidxälnini, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Luxh che guidxälnini, sutojpni rexamiigwni näjza rexpisiṉni, säjpni lojreni: “Coḻguibalaznäj narä sa'csi abidxälä meel ni gunijt.” ");
INSERT INTO zawNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Rniäza lojtu, sigajcza sibalajz rexangl Dios xhaguibaa xcuent te beṉdojḻ ni rusiechlajzni. ");
INSERT INTO zawNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Dxejc bijza Jesús cuentre lojreni: ―Guyu' te dade' ni yu' tio'p xingaanni. ");
INSERT INTO zawNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Dxejc xi'nni ni najc huinruga, räjpni lo xtadni: “Dad, baniidx yälnasa'c nani nungäjḻ xca'a.” Sas badeed xtadni xerensni. ");
INSERT INTO zawNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Di niaclaa, balsi dxej gudejd, chela bato' xinhuinni guiraa xhixtenni, dxejc sääni, bidzujṉni te guedxzijt. Ro'c banijtni guiraa xmeelni lo recosguijdx. ");
INSERT INTO zawNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Che abanijtni guiraa xhixtenni, biääd te gubinduxh guedxzijtga cadro yu'ni. Sas guslojzani calaanni. ");
INSERT INTO zawNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Dxejc huitiilni dzuun lo te beṉguejdxga. Baxhaḻ bejṉgani te huigajpni cuch lo xyuj dade'ga. ");
INSERT INTO zawNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Luxh calanduxhni bejnni xhigab malaii sajc gauni recuaan ni najc si'c lia ni cayajw recuch, niluxh rut badeeddi xhi niajwni. ");
INSERT INTO zawNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Laḻ ni cadejdni trabajwga, bianij xcäriejnni bejnni xhigab, naani: “Balti rexmos xtadä rausa'c, ria'nru xhi gaureni. Luxh narä ree calanduxhä, ameerli guetä. ");
INSERT INTO zawNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Guibi'älis ladxä, rolijz xtadä, gäpä lojni, Dad, banitä lo Dios näjza lojlu. ");
INSERT INTO zawNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Diru nungäjḻ guirilaä xi'nlu. Cua' narä si'c te xmoslu.” ");
INSERT INTO zawNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Dxejc gunazgajcni nejz te gubi'ni rolijz xtadni. ’Cheni zijtru siäädni, bahuii xtadni lojni. Dxejc balaslajznini, ruxuṉlini, huichaglojnini, sas gudääznini, bachagro'ni lojni. ");
INSERT INTO zawNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Dxejc räjp xi'nni lojni: “Dad, abanitä lo Dios näjza lojlu. Diru nungäjḻ guirilaä xi'nlu.” ");
INSERT INTO zawNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Per räjp xtadni loj rexmosni: “Coḻtanä te ladsa'c, coḻshuajcwnini xi'nä, coḻgusäḻ te niil bicueṉaani, xcajza te gura'ch ni'ni. ");
INSERT INTO zawNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Coḻtanä te biseṟ ni guro' coḻgu'tni. ¡Coḻsquejn te guidauunu, jiennu te lanij! ");
INSERT INTO zawNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sa'csi xi'näre abenä xhigab gujtni, luxh ṉaj si'cni agubaṉsacni, gunijtni niluxh ṉaj abidxäjlni.” Dxejc guslojreni bejnreni te lanij. ");
INSERT INTO zawNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Laḻ ni cayajc dee, xingangalooni cayujn dzuun lo niaa. Che gubi'ni, siäddzuṉgajxhni rolijzni, che biejn diajgni cayeḻ rolijzni, caguya'zareni. ");
INSERT INTO zawNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Dxejcti gurejdxni te mos, gunabdiidxni lojni xhi cayajc royu'. ");
INSERT INTO zawNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Dxejc räjp mosga lojni: “Gubisac bejtzlu, luxh xtadlu gunibee gujt te biseṟ guro' te gac lanij sa'csi nadaanni gubi'ni.” ");
INSERT INTO zawNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Dxejc bidxe'ch xingangalooni. Naadtini jiu'ni rolijzni. Che gucbee xtadni naadtini jiu'ni, bihuii xtadnini te gunabni jiu'gani. ");
INSERT INTO zawNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Dxejc räjpni lo xtadni: “¡Bahuilaare! Agujc xchej cayunä dzuun lojlu, luxh rusobdiagä guiraa xtiidxlu, per nicla tej huält gajdlu guniidx nicla te dxibe' loä te gunä te lanij con rexamigwä. ");
INSERT INTO zawNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Luxh ṉaj ni abidzujṉ xi'nlure, ni banijt xmeellu con regunadxab, xhoxh bagu'tlu te biseṟ guro' te cayujnlu xlanijni.” ");
INSERT INTO zawNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Dxejc räjp xtadni lojni: “Xi'nä, sugagajclu loä, luxh guiraa ni rapä najc xtenlu. ");
INSERT INTO zawNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Niluxh ṉaj riäjḻpac jiennu lanij, guibalaaznu, sa'csi bejtzlu ni benä xhigab agujt, agubi'ni ṉaj, najcni si'cni gubaṉsacni; gunijtni, ṉaj abidxäjlni.” ");
INSERT INTO zawNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Dxejc cayujyza Jesús stee cuent loj rexpejṉpacni, räjpni: ―Guyu' te beṉrajp ni guyu' lojni te ni rnibee loj rexmosni. Dxejc biääd reni badeedreni diidx lojni, räjpreni: “Bejṉ ni rnibee loj rexmoslu xhetlaadi cayujnni cagunijtni rexhixtenlu.” ");
INSERT INTO zawNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Dxejcti gurejdx xlam̲nini, räjpni lojni: “¿Xhi dee ni riejn diagä caniireni xcuentlu, ä? N̲aj guniidxlu loä cuent xte xtzuunlu, sa'csi dirulu chanuu guinibeelu lo rexmosä.” ");
INSERT INTO zawNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Dxejc bejṉga bejn xhigab: “¿Xhichani'c gunä ṉaj ni gudzucaj xlam̲ä dzuun loä? Dina ga'pä yäḻrstijp te gunä dzuun lo niaa, luxh situjyä chanabä gojn. ");
INSERT INTO zawNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ananä xhini'c gunä te che dirunä ga'pä dzuun, sibejdx rexamigwä narä rolijzreni.” ");
INSERT INTO zawNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Dxejcti gurejdxni tebgajreni rebejṉ ni nazääb lo xlam̲ni, dxejc räjpni loj ni bidzuṉxgaa: “¿Lac nazääblu lo xlam̲ä?” ");
INSERT INTO zawNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Dxejc räjpni: “Nazäbä si'c te gayuu baṟiḻ se't.” Dxejc räjpni lojni: “Basquejn, cua' guijtzre, bacuaa tiubitzuutis baṟiḻ nazääblu lojni.” ");
INSERT INTO zawNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Dxejc gunabdiidxni loj steeni, räjpni: “¿Luj a'? ¿Lac nazääblu lo xlam̲ä?” Dxejc räjpni lojni: “Te gayuu dxim̲ro triuu.” Dxejc räjpzani: “Aree xquijtzlu; bacuaa tajtis dxim̲ro.” ");
INSERT INTO zawNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Bidxeloj xlam̲ni, gulä'pni xpala'n beṉguijdxga ni gunibee sa'csi bisiṉni bejnni recosga. Dxejc räjpza Jesús, rebejṉ ni di gumbee xtidx Dios nadxällajzrureni lo rextzuunreni con sa'reni loj rebejṉ ni arumbee xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Rniä lojtu, coḻquiil rexamiigwtu con reyäḻnasa'c ni räjptu loj guedxliujre, te che abaraj xhixtentu, sica' Diostu xhaguibaa cadro yu' rolijztu par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Renani runsa'c dzuun lo te dzunbäz, sajcza gunsa'cni dzuun lo te dzunro, luxh reni di gacdi gunsa'c dzuun lo te dzunbäz, di gacdiza gunsa'creni dzuun lo te dzunro. ");
INSERT INTO zawNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ni'cni palga xhetlaadi cuarälnäjtu reyäḻnasa'c xten guedxliuj, ¡xho guniidx Dios reyäḻnasa'c xtenni lojtu! ");
INSERT INTO zawNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Palga xhetlaadi cuarälnäjtu xhixten bejṉ, ¿chu guniidx lojtu ni gac xtenpactu, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Nicla tej mos di gacdi gunni dzuun lo tio'p lam̲, sa'csi sidxe'chni lo tejni, steeni sinälajzni o susobdiajgpacni xtidx tejni, sibälazni steeni. Di gacdi gun bejṉ xtzun Dios laḻ ni sanälajztisni xcäḻnasa'cni. ");
INSERT INTO zawNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mbaj ṉaj, refarisee, sa'csi rchaglazduxhreni meel, cacuadiagdzu'tzreni xtiidxni, dxejc caguxhisnäjreni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Dxejcti räjp Jesús lojreni: ―La'tu najctu bejṉ ni ruhuii rebejṉ lojtu, naareni beṉsacduxhtu, niluxh acanajn Dios xhi xhigab rujntu neṉ lastootu. Sa'csi guiraa ni rchalojtu najc yäḻnasacduxh, guiraa ni'c rbixhlajz Diosni. ");
INSERT INTO zawNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Räjpzani: ―Dxejli ni biääd Juan ni rutiobnis, guyu' xleii Moisés, näjza xtidx redade' ni gunii xtidx Dios. Cheni biääd Juan gusloj rsule' didxsa'c xcuent xcäḻrnibee Dios, ni'cni xhidajl bejṉ cagusutijp lajzni te jiu'reni loj yälrnibeega. ");
INSERT INTO zawNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Per guyasiru nitloj xhaguibaa näjza guedxliuj quela di jialoj guiralii rediidx ni bacuaa Moisés; nicla tej diidxga di nitloj. ");
INSERT INTO zawNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Räjpzani: ―Palga guṟo'n te bejṉ chäälni, dxejc guchṉaani stee gunaa, rujnni dojḻ, luxh nani ruchṉaa te gunaa ni abaṟo'n chäälnini, niguiiga rujnzani dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Räjpzani: ―Guyu' te beṉrajp ni rchaglajz rajcwni ganax reladsacduxh, luxh guixe-guixee rujnni laniro. ");
INSERT INTO zawNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Guyu'za te beṉproob ni laa Lázaro ni rniab gojn, ricueni ro xlä' beṉrajpga, yu' guejdx ni rgaadz tiejxhni. ");
INSERT INTO zawNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Rlajzni maläii xho gunni gauni nani rtejb loj xmex beṉrajpga, luxh direni gusaan. Dxejc rebä'cw siääd rilejp loj reguejdx ni rgaadz ni guidxa tiejxhni. ");
INSERT INTO zawNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Guyu'ti te dxej gujt beṉproobga, biädläs rexangl Dios xaimni, huinärenini cadro yu' Abram xhaguibaa. Dxejcti näjza beṉrajpga gujt, huicua'tztirenini. ");
INSERT INTO zawNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Che yu'ni gabijl cadro rij guiraa rebeṉdojḻ, ro'c cadejdni trabajwduxh. Dxejcti guläsni lojni, bahuiini zitduxh cadro suganäj Abram Lázaro. ");
INSERT INTO zawNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Dxejcti guredxaduxh beṉrajpga, räjpni lo Abram: “¡Xtadä Abram! Balazlajz narä, baxhaḻ Lázaro guhuajdxni yejc bicueṉaani nis te gusiäḻyujni ludxä, sa'csi ree cadedä trabajwduxh lo guiboo.” ");
INSERT INTO zawNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Luxh räjp Abram lojni: “Xi'nä, basaa lajzlu che gubajṉlu lo guedxliuj gojplu guira'ti xhixtenlu, luxh sigajcza Lázaro gudejdni trabajwduxh. Per ṉaj ree casilajzni, ṉaj luj cadejdlu trabajwduxh. ");
INSERT INTO zawNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Luxh di gacdi jiääd Lázaro ro'c, sa'csi yu' te baladuxh ni rlia' sa'nu, te mase rlajz bejṉ guirii ree te tedreni lojlu ro'c, di gacdini. Di gacdiza ted reni yu' ro'c te jiäädreni loonu.” ");
INSERT INTO zawNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Dxejcti räjp beṉrajpga lojni: “Rniabduxhä lojlu, xtadä, baxhaḻlaa Lázaro chääni rolijz xtadä, ");
INSERT INTO zawNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","sa'csi ro'c yu' gaii betzä, te chalijdxni laareni, te gusiechlajzreni, te di näjza laareni jiäädreni ree cadro rdejd bejṉ trabajwduxh.” ");
INSERT INTO zawNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Dxejc räjp Abram lojni: “Arajpreni guijtz cadro caj xleii Moisés näjza xtidx redade' ni gunii xtidx Dios, sugusobdiajgreni rediidxga.” ");
INSERT INTO zawNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Luxh beṉrajpga badzu' diidxre, räjpni lojni: “Gulii dad Abram, per palga chäs te bejṉ loj rebeṉgut, chanii lojreni, dxejc sii pet susiechlajzreni.” ");
INSERT INTO zawNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Dxejc räjp Abram lojni: “Palga direni gusobdiajg xtidx toMoisés näjza xtidx redade' ni gunii xtidx Dios, dizareni chalilajz xtidx te bejṉ ni guibaṉsac loj rebeṉgut.” ");
INSERT INTO zawNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Räjp Jesús loj rexpejṉpacni: ―Siäädpac recos ni gun jiajb bejṉ lo dojḻ. Proobza bejṉ ni rujn riajb bejṉ lo dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Maaz guliibni te guij xten molin guejnni, gusäḻ bejṉni lo nisdoo cadro jiätro quela gunni jiajb rexi'nä ni ahuililajz xtidxä. ");
INSERT INTO zawNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Coḻsusiṉ! ’Palga gun bejtzlu dojḻ lojlu, balijdxni. Palga gusiechlajzni, basiäjḻ diidx con laani. ");
INSERT INTO zawNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Masque gajdz huält neṉ teb dxej gunni dojḻ lojlu, palga jiädniini lojlu gajdz huält, naani: “Xhet laadi benä, basiäjḻ lajzlu”, basiäjḻ lajz con laani. ");
INSERT INTO zawNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Gunii rexpejṉpacni lo Jesús, räjpreni: ―Dad, baniidxru yäḻrililajz loonu. ");
INSERT INTO zawNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Dxejc räjp Jesús lojreni: ―Palga rajptu yäḻrililajz, mase najcni si'cti te bedzbäz xten muxhtas, sajc gäbtu lo yagro rec: “Biliädxa' ro'c, guzuj galäii nisdoo”, susobdiajg yajgga xtiidxtu. ");
INSERT INTO zawNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Räjpzani: ―¿Chu tejtu ni rajp te mos ni riga'n o ni rigajp rexquidxaani ni gäbni lojni che guibi'ni lo niaa: “Biu'ga, gurej lo mex te gaulu”? ");
INSERT INTO zawNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Dini gäb si'c. Niluxh säjpni lojni: “Bachaa xhajblu. Bejn xhi gauä, gudanäni loä. Che luux gauä, yä'ä, dxejc sajc gauzalu, yäzalu.” ");
INSERT INTO zawNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Dini gudeed xquixtios lo mosga sa'csi rujnni recos ni gunibeeni sa'csi si'c riäjḻ gunni. ");
INSERT INTO zawNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Sigajcza la'tu, che luux guntu guiraa redzuun ni guniä guntu, riäjḻ guiniitu lo Dios: “Najcnu mos ni xhet sajcdi, nani riäjḻ jiennu, ni'ctis biennu.” ");
INSERT INTO zawNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Laḻ ni sasaj Jesús nez guedx Jerusalén, gudejdni loj región Samaria näjza región Galilee. ");
INSERT INTO zawNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Che biu'ni tej reguejdxga, huichagloj Jesús tzuu bejṉ ni rajc te yäḻguijdx ni raḻ tiejxhreni, niluxh zijtru guzujreni. ");
INSERT INTO zawNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Dxejc rbedxa'reni räjpreni: ―Jesús, Dad, Mastr, balaslajz nuurnu. ");
INSERT INTO zawNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Che bahuii Jesús lojreni, räjpni lojreni: ―Coḻchäj, te fii rebixhojz abiajctu. Laḻ ni sääreni, bia tiejxhreni. ");
INSERT INTO zawNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Dxejc tejreni, che bahuiini abiajcni, gubiguxuṉni, cabedxa'ni calä'pni xpala'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Bazuxhijbni nez loj Jesús, basajbni lojni lo yuj cagudeedni xquixtios loj Jesús. Luxh bejṉre najc te beṉzijt, te beṉ Samaria. ");
INSERT INTO zawNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Dxejcti räjp Jesús lojni: ―¿La et tzuudi najc reni biajc, ä? ¿Con sgaareni? ");
INSERT INTO zawNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿La rutru gubi'di loä te guiliä'preni xpala'n Dios, xtebtis beṉzijtre, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Dxejc räjp Jesús loj bejṉre: ―¡Huisulii, huij! Abiajclu sa'csi huililajzlu. ");
INSERT INTO zawNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Dxejc, sa'csi agunabdiidx refarisee loj Jesús guc guidzujṉ xcäḻrnibee Dios, badzu'ni diidxre, räjpni lojreni: ―Di xcäḻrnibee Dios guidzujṉ con seen ni sajc fiitu. ");
INSERT INTO zawNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Diza bejṉ naa: “Bahuii, aniree”, o “Anirec”, sa'csi abidzujṉ xcäḻrnibee Dios lojtu. ");
INSERT INTO zawNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Dxejc räjp Jesús lo rexpejṉpacni: ―Sidzujṉ dxej rlajzgatu fiitu te dxej sa' ni chu che jiädsac Xi'n Dios ni gujc Niguii, luxh ditu fiini. ");
INSERT INTO zawNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Luxh siniireni lojtu: “Aniree”, o “Anirec”, per na'c chäätu, na'cza chanajltu reni rihuii. ");
INSERT INTO zawNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sa'csi sigajc ni rieṉ che rdinya' te laad xhaguibaa hasta stelaad xhaguibaa, si'cza gac che jiälä narä, Xi'n Dios ni gujc Niguii, che gaḻ dxej guibi'ä. ");
INSERT INTO zawNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Luxh ganiddoo sidedä trabajwduxh, sa'csi sibälaz rebeṉ guedxliuj ni tre' ṉaj narä. ");
INSERT INTO zawNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Si'cni gujc neṉ redxej cheni gubajṉ toNoé, si'cza gac neṉ redxej che jiälä narä, Xi'n Dios ni gujc Niguii. ");
INSERT INTO zawNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Neṉ redxej ni gubajṉ toNoé gudajwreni, gu'reni, bachṉaareni, badeedzareni xindxa'preni guchṉaa bejṉ, bidzujṉli dxej cheni biu' toNoé neṉ barcwro ni bencheeni. Dxejc biääd nisguiduxh, gujt guiraa rebeṉ dojḻ, guzääbreni lo nis. ");
INSERT INTO zawNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Sigajcza gujc neṉ redxej ni gubajṉ toLo't: gudajwreni, gu'reni, gusiireni, bato'reni, gule'creni binij, bencheezareni rolijzreni. ");
INSERT INTO zawNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Niluxh cheni birii Lo't lo guedx Sodoma, biajb guiboo xhaguibaali, näjza te däj ni rudxuii, gunitlojti guiraa rebejṉ dojḻ, huejcreni. ");
INSERT INTO zawNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Sigajcza gac neṉ redxej cheni jiälä narä, Xi'n Dios ni gujc Niguii. ");
INSERT INTO zawNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Dxejga, palga yu' chu niä'p yejc yu', diru gaḻdi jiäjtni te chalääni rexhixtenni ni yuchee neṉ yu'; palga yu' chu suga' nezjiät, di gaḻdiruni guibi'ni rolijzni. ");
INSERT INTO zawNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Coḻgusnaj lajztu xhi gujc chääl toLo't. ");
INSERT INTO zawNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ni rlajz ga'p xcäḻnabajṉni lo guedxliujre, sunijtnini, nani gunijt xcäḻnabajṉni lo guedxliujre xcuent rextidxä, xcäḻnabajṉni rajpni xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Rniä lojtu, guxhijṉga ni jiälä lo tio'p reni naga' lo te da', chää tejni, steeni jia'n. ");
INSERT INTO zawNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Lo tio'p gunaa ni cayo't, chää tejni, steeni jia'n. ");
INSERT INTO zawNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Lo tio'p bejṉ ni yu' lo niaa, chää tejni, steeni jia'n. ");
INSERT INTO zawNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Che biejn diajgreni rediidxre, gunabdiidxreni lojni, räjpreni: ―Dad, ¿caro gac recosre? Badzu' Jesús diidxre, räjpni: ―Cadro naga' te mangut, ro'c rdojp regolbetz. ");
INSERT INTO zawNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Bijza Jesús te cuent ni ruluii lojreni, te guisieedreni xho riajl cuedx-guiniabreni lo Dios lacuaa gac-huin lajzreni, ");
INSERT INTO zawNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","räjpni lojreni: ―Te guejdx guyu' te juejz ni di chalilajz xtidx Dios, dizani jiu rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Lagajc guejdxga guyu' te gunabiuud. Guixe-guixee rijni lo juejz, rniabni lojni gunni yäḻguxhtis lo bejṉ ni rdxe'ch lojni. ");
INSERT INTO zawNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Balti dxej naadti juejzga gun yäḻguxhtisga. Dxejcti bejnni xhigab, naani: “Mase dina guidxebä Dios, dizana jiuä rebejṉ, ");
INSERT INTO zawNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","sa'csi gunabiuudre sanuutisni siäädni loä, abasiedliini narä, gunälis yäḻguxhtis xten gunaaga, te di chanuutis riädgusieedni narä.” ");
INSERT INTO zawNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Dxejc räjp Jesús lojreni: ―Riejn diajgtu xtidx juezguijdxga, ");
INSERT INTO zawNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","N̲aj ¿xho di Dios, ni najc hueen, gucuadiajg xtidx rexi'nni ni rbedx-rniab lojni dxej-yääl? Di gaclaa gunni yäḻguxhtis xcuent reni aguleni. ");
INSERT INTO zawNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ni'cni rniä lojtu, sungajcni yäḻguxhtis par laareni. Luxh che guibi' Xi'n Dios ni gujc Niguii, ¿la sidxälni bejṉ ni rililajz xtiidxni lo guedxliuj? ");
INSERT INTO zawNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Bij Jesús stee cuent ni ruluii loj rebejṉ ni rluiisi najc beṉsa'c, ni rchalo xhet sajcdi resabejṉreni. Räjpni: ");
INSERT INTO zawNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Tio'p dade' huij guidoo te huinabreni lo Dios. Tej ni najc farisee, steega najc te dade' ni rusquijx impuest. ");
INSERT INTO zawNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Sulii fariseega laḻ ni canabni lo Dios, räjpni: “Dad, Dios, runidxä xquixtios lojlu sa'csi dina gacä si'c najc rebejṉ ni najc gubaan, ni najc beṉ nadiplajz, ni najc beṉdojḻ, dizana gacä si'c najc bejṉre ni rusquijx impuest. ");
INSERT INTO zawNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Rucua'nä tio'p huält neṉ te xmaan, luxh rudedä te tzuu lo te beex loj guiraa ni runä gaan.” ");
INSERT INTO zawNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Niluxh bejṉ ni rusquijx impuest, zijtru suga'ni, dini guiliäs lojni xhaguibaa. Catiälṉaatisni lastooni, caniini lo Dios, räjpni: “Dad, Dios, ¡balaslajz narä, nacä te beṉdojḻ!” ");
INSERT INTO zawNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Rniliä́pac lojtu, ni rusquijx impuest rbaali lajzni gubi'ni rolijzni sa'csi badzucaj Dios rextojḻni, niluxh di Dios nudzucaj rextojḻ beṉ farisee. Sa'csi guiraa rebejṉ ni rlajz guiliä'p lagajc xpala'nni, susanxtiujy Diosreni, dxejc reni di rlajz guiliä'p lagajc xpala'nreni, siliä'p Dios xpala'nreni. ");
INSERT INTO zawNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yu'reni siädnä rexpiuxbäzreni loj Jesús te guzujni ṉaani yejcreni. Che bahuii rexpejṉpacni si'c, gusloj cadiḻdiidxreni con rebejṉ te na'c jiädnäreni rebiuxe'. ");
INSERT INTO zawNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Dxejc gurejdx Jesúsreni, räjpni lojreni: ―Coḻgusaan jiääd rebiuxe' loä, na'c gudxojntureni, sa'csi xcäḻrnibee Dios najc xten reni najc nadolajz si'c rebiuxbäze're. ");
INSERT INTO zawNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Rniliä́pac lojtu, chutis ni rlajz jiu' lo xcäḻrnibee Dios nanab gusobdiajgreni xtidx Dios si'c rusobdiajg rebiuxe' xtidx xtadreni. Palga dini gun si'c, dini jiu' lo xcäḻrnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Te bi'n ni rnibee gunabdiidx loj Jesús, räjpni: ―Dad, mastrsa'c, ¿xhini'c nanab gunä te xca'ä yäḻnabajṉ par tejpas? ");
INSERT INTO zawNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Dxejc räjp Jesús lojni: ―¿Xhicuent rniilu narä: “Mastrsa'c”? Rutru najcdi beṉsa'c, xtebtis Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Anajnlu xho najc remandamient ni caj lo xleii Moisés: “Na'c guesnäjlu gunaa ni di gac chäällu; na'c ju'tlu bejṉ; na'c cuanlu, na'c guiniilu didx-xhii xcuent bejṉ; bazoob xtidx xtadlu, xnanlu, bahuiizareni.” ");
INSERT INTO zawNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Dxejc räjp bi'nga lojni: ―Guiraa remandamientre rusobä cheni gucäli biuux. ");
INSERT INTO zawNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Che biejn diajg Jesús xtiidxni, räjpni lojni: ―Tejtis cayäädx gunlu. Bato' guiraa rexhixtenlu, gudisni loj rebejṉ ni xhet rajpdi dxejc sajplu xcäḻnasa'clu xhaguibaa. Dxejc gudanajl narä. ");
INSERT INTO zawNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Che biejn diajg bi'nga rediidxre, guc-huinduxh lajzni, sa'csi najcni te bejṉ ni rapduxh. ");
INSERT INTO zawNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Dxejc rdxelojtis Jesús lojni, guc-huinza lajzni räjpni: ―Naganduxh jiu' rebeṉrajp lo xcäḻrnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Guyasiru ted te cameii ni' te guux lo ni jiu' rebeṉrajp lo xcäḻrnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Reni biejn diajgni rediidxre, räjpreni: ―¿Chuxhni'c sajc ḻaa lo dojḻ, palga si'c najcni? ");
INSERT INTO zawNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Dxejc räjp Jesús lojreni: ―Guira'ti ni di gacdi gun rebejṉ, guyasi rajc rujn Diosni. ");
INSERT INTO zawNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Dxejc räjp Pedr lojni: ―Dad, nuurnu abasa'nnu guiraa rexhixtennu te siopnalnu luj. ");
INSERT INTO zawNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Dxejc badzu' Jesús diidxre lojni, räjpni: ―Rniliä́pac lojtu, chutis ni gusaan rolijzni näjza rexcuzajnni, rebejtzni, chäälni, xi'nni xcuent xcäḻrnibee Dios, ");
INSERT INTO zawNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","sica'ni xhiroobru lo guedxliujre, luxh sica'ni yäḻnabajṉ par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Gurejdx Jesús rexpejṉpacni te laad, te räjpni lojreni: ―N̲aj chonnu guedx Jerusalén cadro nanab soob rediidx nani bacuaa dade' ni gunii xtidx Dios galooli xcuent Xi'n Dios ni gujc Niguii. ");
INSERT INTO zawNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Sutedrenini ladzṉaa rebeṉzijt, suxhiznäjrenini, susacsírenini, sutiobxhejnlireni lojni, ");
INSERT INTO zawNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","luxh che luux quiinrenini, dxejc sugu'trenini, luxh ni riojṉ dxej sibaṉsacni loj rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Dxejc laareni direni niacbee rediidxre, dizareni gan xhini'c caniini, sa'csi najcreni diidx ni di gacdi gacbeereni. ");
INSERT INTO zawNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Cheni sadzujṉ Jesús te guejdx ni laa Jericó, sobga' te beṉ lotiä'p ro' nezyuj, canabni gojn. ");
INSERT INTO zawNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Che biejn diajgni cadejd xhidajl bejṉ lo nezyujga, gunabdiidx beṉ lotiä'pga xhini'c cayajc. ");
INSERT INTO zawNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Dxejc räjpreni: ―Jesús ni siääd Nazare't cadejdni nezga. ");
INSERT INTO zawNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Dxejc guredxa'ni räjpni: ―¡Jesús, xi'n toDavid, balaslajz narä! ");
INSERT INTO zawNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Rebejṉ ni nijd lojreni gudiḻnäjreni beṉ lotiä'pga te jiäu ro'ni, niluxh laani dipru guredxa'ni, räjpni: ―¡Xi'n toDavid, balaslajz narä! ");
INSERT INTO zawNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Dxejc guzudxi Jesús ro'c, gunibeeni jiädnäreni bejṉga lojni. Che bidzujṉni lojni, gunabdiidx Jesús lojni, räjpni: ");
INSERT INTO zawNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Xhini'c rlajzlu gunnää́ luj? Badzu' beṉ lotiä'pga diidxre, räjpni: ―Dad, rlazä jieṉ loä. ");
INSERT INTO zawNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Dxejc räjp Jesús lojni: ―¡Sujieṉ balojlu! Abiajclu sa'csi huililajzlu. ");
INSERT INTO zawNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Lagajc dxej, bieṉgajc lojni, calä'pni xpala'n Dios, huinajlni Jesús. Luxh guiraa rebejṉ ni bahuii xhi guzajcni, gulä'pzareni xpala'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Dxejc biu' Jesús guedx Jericó, sadejdzani guejdxga. ");
INSERT INTO zawNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ro'c rbäjz te beṉrapduxh, ni laa Zaqueo, ni rnibee lo reni rusquijx xcuent impuest. ");
INSERT INTO zawNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Rlajz Zaqueo fiini loj Jesús te gumbeenini, per digacdi fiini lojni sa'csi najcni te beṉxhate', luxh xhidajl bejṉ siädsaj guideb gabi Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ni'c baxuṉni gunijdni lojreni, huä'pni lo te yajgro ni suga' gajxh nez cadro ted Jesús te si'c sajc fiini loj Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Che gudejd Jesús nejzga, guläsni lojni jiaa, bahuiini cadro sobga' bejṉre. Dxejc räjpni lojni: ―Zaqueo, basquejn biäjt ro'c, lagajc nadxej rlazä chajia'nä rolijzlu. ");
INSERT INTO zawNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Dxejcti biätguxuṉ Zaqueo lo yajgga, rbalazduxhni huinäni Jesús rolijzni. ");
INSERT INTO zawNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Che bahuii guiraa rebejṉ xhi gujc, gusloj camojm̲reni, direni jiulajz, räjpreni: ―Jesús sajia'n rolijz te beṉdojḻ. ");
INSERT INTO zawNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Dxejcti huisulii Zaqueo, räjpni loj Jesús: ―Bahuilaare, Dad, gala' xhixtenä gudedä loj rebeṉproob; luxh palga yu' chu loj cua'ä xhixtenni con yäḻrusguee, sudzu'ä lojni tajp huält si'cti ni cua'ä. ");
INSERT INTO zawNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Räjp Jesús lojni: ―Lagajc nadxej gubicaj xtojḻlu näjza xtojḻ reni rbäjz rolijzlu, sa'csi guliipac najclu te xagdoo toAbram. ");
INSERT INTO zawNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Pues Xi'n Dios ni gujc Niguii biädtiil rebeṉdojḻ te gusḻaani rebejṉga ni gunijt neṉ dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Laḻ ni cagucuadiajgreni xtidx Jesús, bijzani te cuent ni ruluii, sa'csi asiäddzujṉgajxhreni guedx Jerusalén, luxh laareni rujnreni xhigab sisloj guinibee Jesús si'ctisni guidzujṉni guejdxga. ");
INSERT INTO zawNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Dxejc räjpni lojreni: ―Guyu' te bejṉ, beṉrajpni, huijni te guejdx zijtro te gacni ṟeii, dxejc guibisacni. ");
INSERT INTO zawNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Che gajdni guirii, gurejdxni tzuu xmosni, te badeedni lo tebgajreni te melpla't ni sacduxh, räjpni lojreni: “Coḻyujn dzuun con meelre che guibisacäli.” Sä'tini. ");
INSERT INTO zawNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Per rebeṉ lajdxni dipacreni guichaglajz bejṉga, ni'c baxhaḻreni gaii bejṉ te saye'tzreni: “Di rlajzdinu gacni xṟeiinu.” ");
INSERT INTO zawNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Luxh empac gujcni ṟeii, dxejc gubisacni lajdxni. Che bidzujṉni gurejdxni rexmosni ni badeedni meel cua'reni, te gacbeeni lac bejn tejgareni gaan. ");
INSERT INTO zawNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ni bidzujṉ ganid räjpni lojni: “Dad, xmeellu bejn gaan stzuu meel.” ");
INSERT INTO zawNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Dxejc räjp ṟeii lojni: “Hueenca, luj najclu te mossa'c, sa'csi laaca bejnlu dzuun lo te dzunbäz, ṉaj sunidxä guinibeelu loj tzuu guejdx.” ");
INSERT INTO zawNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Bidzujṉ stee mos lojni, räjpni: “Dad, xmeellu bejn gaan gaii meel.” ");
INSERT INTO zawNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Dxejcti räjpni lojni: “Luj guinibeelu loj gaii guejdx.” ");
INSERT INTO zawNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Bidzujṉti stee mos lojni, räjpni: “Dad, aree xmeellu, guluchedzu'tzäni neṉ te baii ");
INSERT INTO zawNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","sa'csi bidxebä guejblu, sa'csi najc guejblu te beṉ nadiplajz, rutojp guejblu cadro di guejblu nuzuj, luxh rliäs guejblu cose'ch cadro di guejblu nibe'c.” ");
INSERT INTO zawNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Dxejcti räjp ṟeii lojni: “¡Mosguijdx! lagajc ro'lu birii diidx ni gunälu yäḻguxhtis. Palga najnlu nacä te beṉ nadiplajz, najnlu rutopä cadro dina nusuä, najnlu rliäsä cose'ch cadro dina nibe'cä, ");
INSERT INTO zawNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿xhicuent dilu nisa'n xmelä neṉ te bancw te che nibi'ä nica'a xmelä nägajc xi'n meelga?” ");
INSERT INTO zawNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Dxejc räjpni loj reni suga' ro'c: “Coḻgudzucaj meelga lojni, coḻgudeedni loj ni rajp tzuu meel.” ");
INSERT INTO zawNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Laareni räjpreni: “Dad, per laani arajpni tzuu meel.” ");
INSERT INTO zawNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Dxejc badzu' ṟeii diidxre lojreni, räjpni: “Ni'cni rniä, reni rajp, sica'rureni, niluxh reni di ga'p lojreni sibicaj guiraa recosbäz ni rajpreni. ");
INSERT INTO zawNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Luxh xcuent reni rdxe'ch loä, ni di rlajz niacä ṟeii lojreni, coḻtanäreni ree, coḻgugu'treni nez loä.” ");
INSERT INTO zawNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Che gulujx guniini guiraa rediidxre, huinuuni xnejzni, sääni nez lo guejdx Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Che asadzuṉgajxhni reguejdx ni laa Betfagé näjza Betania, gajxh lo dajn ni laa Oliib, baxhaḻni tio'p rexpejṉpacni, ");
INSERT INTO zawNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","räjpni lojreni: ―Coḻchäj lo guejdxe' ni suga' lad rec. Che guidzujṉtu, guidxältu caduu te buṟ huin ni gajd bejṉ cuib. Coḻguxhecni, coḻtanäni ree. ");
INSERT INTO zawNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Palga yu' chu guiniabdiidx lojtu: “¿Xhicuent caguxhectuni?” coḻye'tz lojni: “Dad caquiinnini.” ");
INSERT INTO zawNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Sä'ti rexpejṉpacni nani baxhaḻni, bidxälreni manga sigajctisni räjp Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Cheni caguxhecreni buṟe'ga, rexpaxhuaan buṟe'ga räjp lojreni: ―¿Xhicuent caguxhectu buṟe'ga, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Dxejc badzu'reni diidxre, räjpreni: ―Sa'csi caquiin Dadni. ");
INSERT INTO zawNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Sas huinäreni buṟe'ga loj Jesús, gudixhreni xhajbreni dejtzni, te gubijb Jesúsni. ");
INSERT INTO zawNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Guideb cadro gudejd Jesús gudixhreni xhajbreni lo nezyuj cadro tedni. ");
INSERT INTO zawNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Cheni ameer guidzujṉni bajaad xten dan Oliib, gusloj cabaa lajz guiraa rebejṉ, rbedxa'lireni calä'preni xpala'n Dios sa'csi bahuiireni guiraa remilagwr ni bejnni. ");
INSERT INTO zawNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Räjpreni: Chicbaa ṟeii ni siääd xcuent Xtadnu Dios te guinibeeni loonu. Sucuedxilajz guiraa reni yu' guibaa, chä'p xpala'n Dios xhaguibaali. ");
INSERT INTO zawNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Dxejc gaii refarisee ni suga' galäii rebejṉ, räjpreni loj Jesús: ―Mastr, gudidxa' lo rebejṉ ni siädnajllu te na'cru guiniireni si'c. ");
INSERT INTO zawNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Dxejc Jesús räjp lojreni: ―Rniliä́ lojtu, palga redee gusäu ro'reni, sibedxa' reguijre. ");
INSERT INTO zawNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Che bidzujṉni gajxh, che bahuiini guedx Jerusalén, biin Jesús xcuent guejdxga, ");
INSERT INTO zawNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","räjpni: ―¡Maläii gacbeelu, masque neṉ redxejre, xhini'c sajc guniidx yäḻrbedxilajz lojlu! Per ṉaj naga'tzni, luxh digacdi fiilu lojni. ");
INSERT INTO zawNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Sidzujṉ dxejga lojlu, cheni jiääd reni rdxe'ch lojlu sujnreni si'c te guṟalyuj guideb gabilu, nez lojlu sigajc nez dejtzlu sisiujreni. ");
INSERT INTO zawNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Susäḻta'reni luj lo yujli. Sugu'treni rebejṉ ni rbäjz ro'c, luxh nicla gusaanreni cuib te guij yejc sa'ni sa'csi dilu niembee dxej ni biääd Dios biädhuiilu. ");
INSERT INTO zawNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Dxejcti biu' Jesús neṉ guidoro, guslojni cabääni rebejṉ ni caguto' näjza reni casii. ");
INSERT INTO zawNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Dxejc räjpni lojreni: ―Loj rexquijtz Dios caj rediidxre: “Rolizä sajc te yu' cadro jiädnabtu lo Dios”, niluxh la'tu abejntuni si'c te biliää xte gubaan. ");
INSERT INTO zawNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Guixe-guixee caguluii Jesús neṉ guidoro, luxh reni rnibee loj rebixhojz näjza rebejṉ ni ruluii leii, näjza rebeṉgool xte guejdxga caguiilreni mood te ju'trenini, ");
INSERT INTO zawNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","luxh direni nidxäjl xho niujnrenini sa'csi guiraa rebejṉ cacuadiagdzu'tzreni xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Te dxej suga' Jesús neṉ guidoro, caguluiini rebejṉ, cagusule'zani diidx xcuent xho guibicaj xtojḻreni, che bidzujṉ reni rnibee loj rebixhojz näjza rebejṉ ni ruluii leii näjza rebeṉgool, ");
INSERT INTO zawNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","räjpreni lojni: ―¿Xhi yäḻrnibee rujnlu recosre? ¿Chu baniidx yäḻrnibeega lojlu? ");
INSERT INTO zawNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Dxejcti räjp Jesús lojreni: ―Narä sigajcza gunä te yäḻgunabdiidx lojtu, coḻgudzu' diidxre loä, ");
INSERT INTO zawNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿chuni'c baxhaḻ Juan te gutiobnisni rebejṉ? ¿La Dios o la rebejṉ, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Niluxh laareni guslojreni canabdiidx lo sa'reni, räjpreni: ―¿Xhichani'c jie'tznu? Palga jie'tznu Dios baxhaḻni, dxejc naani loonu: “¿Xhixhcuent ditu ninilajz xtiidxni?” ");
INSERT INTO zawNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Palga jie'tznu: “Rebejṉ baxhaḻni”, guiraa rebejṉ sucuaa guij yejcnu, ju'tlireni nuurnu sa'csi laareni rujnpacreni xhigab gunii Juan xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Dxejc badzu'reni diidxre, räjpreni: ―Dinu guidon chuni'c baxhaḻ Juan te biädtiobnisni. ");
INSERT INTO zawNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Dxejc räjp Jesús lojreni: ―Dizana guiniä xhi yäḻrnibee rapä te runä recosre. ");
INSERT INTO zawNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Dxejc gusloj canii Jesús loj rebejṉ, bijni cuentre lojreni, räjpni: ―Guyu' te bejṉ bazuj yaguub lo xyujni. Dxejc badedlaanini lo gaii bejṉ chääreni meed, sä'tnini zijt, gucladuxhni ro'c. ");
INSERT INTO zawNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Che bidzujṉ dxej ni guidojp cose'ch, baxhaḻni te xmosni sanab cose'ch ni riäjḻ xca'ni. Per laareni gudijnreni mosga, xhetliidi badeedreni chanäni lo xpaxhuaan yujga. ");
INSERT INTO zawNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Dxejcti baxhaḻni stee mos lojreni. Dxejc sigajcza gudiḻnäjrenini, gudijnrenini, luxh xhetza badeeddireni lojni, ganaxni gubi'ni lo xlam̲ni. ");
INSERT INTO zawNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Dxejcti baxhaḻni ni riojṉ mos lojreni, per sigajcza gudinduxhrenini, barilaagwrenini. ");
INSERT INTO zawNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Dxejc bejn baxhuaanga xhigab, naani: “¿Xhichani'c gunä? Suxhaḻä xi'nä ni sanälazä; che fiireni lojni, pet siureni xtiidxni.” ");
INSERT INTO zawNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Dxejc che bahuii reni go'n-meed lo xi'nni, dxejc räjpreni lo sa'reni: “Laa deeni gac xtenni reyujre. Do'o guigu'tnuni te nuurnu xca'nu yujre gacni xtennu.” ");
INSERT INTO zawNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Dxejcti barilaagwrenini lo yujga, sas bagu'trenini. Dxejc gunabdiidx Jesús lojreni, räjpni: ―¿Xhichani'c gunnäj xpaxhuaan yujga rebeṉ guijdxre, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Sidzujṉni, sugu'tni guiraa reni cayujn dzun-meed lo yujga, dxejc sudeedni yujga lo garenca bejṉ. Che biejn diajgreni rediidxre, räjpreni: ―¡Na'c gusaan Dios gacni si'c! ");
INSERT INTO zawNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Bahuii Jesús lojreni, dxejc räjpni: ―¿Xhixhni'c caj lo guijtz ni bacuaa redade' ni gunii xtidx Dios galoo? Ro'c cajni: Guij nani guläcaj renani runchee yu', ni'c agujc guisa'c ni guzuj galoo. ");
INSERT INTO zawNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Chutis ni jiajb yejc guijga, sianduxhni, per nani jiajb guijga yejcni siujypacni, li däj gacni. ");
INSERT INTO zawNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Reni rnibee loj rebixhojz, näjza reni ruluii leii rlajzreni guiniaazreni Jesús lagajc oṟga, sa'csi gucbeereni lojreni gunii Jesús cuentre, luxh xhet bejndireni sa'csi rdxejbreni rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Dxejc cagula'tztisrenini, baxhaḻreni gaii bejṉ te gunsireni si'c ni najcreni beṉdxan, te gucuadiajgreni xtiidxni don gaxäjssi guiga'ni lo te diidx te guteedrenini lo yäḻguxhtis, yäḻrnibee xte gubernadoor. ");
INSERT INTO zawNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Dxejc gunabdiidxreni lojni, räjpreni: ―Dad, Mastr, nadonnu laaca rnii guejblu, laaca ruluii guejblu, luxh di guejblu fixgaa la yu' chu najc bejṉ, ruluisa'c guejblu xnez lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Gunilaa loonu, ¿la laaca guidiixnu reimpuest loj xcubieer César o la xhet laadini, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Sas gucbegajc Jesús cayujnsireni yäḻgunabdiidxga, dxejc räjpni lojreni: ―¿Xhicuent runnäjtu narä scree? ");
INSERT INTO zawNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Baluii loä te xmeeltu. ¿Chucha yejc caj lojni, chucha laj caj lojni? Dxejc räjpreni: ―Xten César. ");
INSERT INTO zawNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Dxejc räjpni lojreni: ―Coḻdeed lo César nani najc xten César; coḻdeedza lo Dios nani najc xten Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Luxh direni niujn gaan niga'ni loj nicla te diidx ni guniini nez loj rebejṉ. Rdxelojtisreni lo rextiidxni, biäuti ro'reni, guzudxireni. ");
INSERT INTO zawNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Dxejc huij gaii resaduceos huihuiireni loj Jesús. Di resaduceos chalilajz rbaṉsac bejṉ lo rebeṉgut. Ni'cni gunabdiidxreni loj Jesús, ");
INSERT INTO zawNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","räjpreni: ―Dad, Mastr, basa'n Moisés guijtz loonu, lojga caj: “Palga guet te bejṉ, gusaanni chäälni ruti xi'nni, nanabpac xca' bejtzni gunaaga te chu xi'nni con laani xcuent tobejtzni.” ");
INSERT INTO zawNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Guyu' gajdz niguii, bejtz najcreni. Sas cua' niguigalooga chäälni. Che gujtni ruti xi'nni. ");
INSERT INTO zawNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Dxejcti cua' ni ṟojpga gunaaga. Che gujtni, rutiza xi'nni. ");
INSERT INTO zawNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Sigajcza guzajc ni riojnga. Si'cza guläsnäj gunaaga guigajdzreni. Guiraareni gujt, nicla tejreni di xi'nreni niu'. ");
INSERT INTO zawNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Dxejcti näj gunaaga gujt. ");
INSERT INTO zawNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Guigajdzreni guläsnäjreni gunaare, ni'cni, che guibaṉsacreni lo rebeṉgut, ¿chu chääl gacni, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Dxejc räjp Jesús lojreni: ―Lo guedxliujre ruchṉaa rebejṉ, rudeedzareni xindxa'preni ruchṉaa. ");
INSERT INTO zawNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Niluxh rebejṉ ni agule Dios te chääreni xhaguibaa, näjza te guibaṉsacreni loj rebeṉgut, di reni'c guchṉaa, dizareni gudeed xindxa'preni guchṉaa, ");
INSERT INTO zawNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","sa'csi diru gac guetreni, anajcreni si'c najc rexangl Dios. Laareni najc xi'n Dios sa'csi abaspaṉsac Diosreni. ");
INSERT INTO zawNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moisésli basule' xcuent ni rbaṉsac rebeṉ loj rebeṉgut che bacuaani diidx xcuent yajg ni gurebajl. Ro'c gurejdxni Dios räjpni: “Xtios Abram, Xtios Isaac, näjza Xtios Jacoob”, ni'cni nabajṉpacreni lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Sa'csi di Dios gac Xtios rebeṉgut; najcni Xtios rebejṉ ni nabajṉ par tejpas, sa'csi par laani guiraa rebejṉ nabajṉ. ");
INSERT INTO zawNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Dxejc gaii reni ruluii leii badzu'reni diidxre, räjpreni lojni: ―Mastr, laaca guniilu. ");
INSERT INTO zawNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Sa'csi dirureni niajx niniabdiidxrureni lojni. ");
INSERT INTO zawNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Dxejcti räjp Jesús lojreni: ―¿Xho mood rniireni Crist najc xi'n toDavid, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ni lagajc toDavid bacuaa lo reguijtz ni laa reSalmo: Dad Dios räjp lo Xtadä: ");
INSERT INTO zawNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","“Gurej xladbeä cheni guidzujṉli dxej ni gudzugä guiraa ni rdxe'ch lojlu te gacbeereni luj rnibeelu guira'ti.” ");
INSERT INTO zawNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Xho mood gacni xi'nni palga rnii toDavid lojni “Dad”? ");
INSERT INTO zawNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Guiraa rebejṉ cagucuadiajg che räjp Jesús loj rexpejṉpacni: ");
INSERT INTO zawNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Coḻyajp cuidaad reni ruluii leii, sa'csi rdxaglajzreni rajcwreni lajd siool, rlajzreni saru guinii guiraa rebejṉ “xchan” lojreni, rlajzreni jiu bejṉreni nez loguii, rlajzreni cuereni lo reyagxhilsa'c neṉ reguidobäz, näjza cadro rajc lanij. ");
INSERT INTO zawNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Rudzucajzareni rexhixten regunabiuud, dxejc roḻreni rele' siolduxh che rniabreni lo Dios te fii rebejṉ, te naa bejṉ najcreni beṉdxan, luxh lojreni suxhaḻ Dios te castigwroru. ");
INSERT INTO zawNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Neṉ guidoro bahuii Jesús cagusäḻ rebeṉrajp gojn neṉ te guijn cadro rdojp gojn. ");
INSERT INTO zawNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Bahuiizani lo te gunabiuud, lacti proobni. Basäḻni xcojnni neṉ guijnga, tio'ptis melbäz basäḻni. ");
INSERT INTO zawNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Dxejc räjp Jesús: ―Rniliä́pac lojtu, gunabiuud proobga basäḻruni loj guiraa reni casäḻ gojn, ");
INSERT INTO zawNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","sa'csi guiraa redec ni cagusäḻ xcojnni casäḻreni tudxe'nsi xmeelreni, niluxh gunaare loj xcäḻproobni, basäḻni guiragajc ni rajpni te jio' xhi gauni. ");
INSERT INTO zawNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yu' reni cayujy diidx xcuent guidoro, räjpreni: ―Lacti sacruduxh rieṉni sa'csi guisa'c naccheeni, suchenäjzani xhidajl recossa'c ni badeed bejṉ si'c gojn. Dxejc gunii Jesús lojreni, räjpni: ");
INSERT INTO zawNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Sidzujṉ dxej sibijḻ guiralii ni cahuiitu, nicla tej guij di jia'n yejc sa'ni, guiragajcni sibijḻ. ");
INSERT INTO zawNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Dxejc gunabdiidx rexpejṉpacni lojni, räjpreni: ―Dad, Mastr, ¿guc gacni? ¿Xhi seen chu che gac recosga? ");
INSERT INTO zawNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Räjp Jesús lojreni: ―¡Coḻsusiṉ te na'c gusgueereni la'tu! Sa'csi xhidajl reni jiääd sinii: “Narä nacä Crist”, o “Asiädgajxh redxej che jiäädni”, per na'c chalilajztu xtiidxreni, na'cza chanajltureni. ");
INSERT INTO zawNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Luxh che jiejn diajgtu cayajc gueṟ cadiḻnäj sa' bejṉ, na'c guidxejbtu, sa'csi ganid recosga gac, luxh gad gaḻdi nitloj guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Dxejc sanuu cayäjpni lojreni: ―Säjs te nación, sucuanäj stee nación, näjza te ladx bejṉ sucuanäj stee lajdx bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Sajcza xuro, su' gubijn, su'za yäḻguijdx nez ree nez rec. Luxh xhaguibaali sieṉ guiraloj ni ruchejb näjza seenro. ");
INSERT INTO zawNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Luxh ganid gac recosre, siniaazreni la'tu, sirinajlreni la'tu, suteedreni la'tu trabajw. Suteedreni la'tu lo rebeṉ guidobäz, susäḻzareni la'tu neṉ latzguiib, sinäzareni la'tu nez loj ṟeii näjza gubernadoor sa'csi rinälajztu xtidxä. ");
INSERT INTO zawNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Luxh guiraa dee sajctu te gac gusule'tu xtidxä lojreni. ");
INSERT INTO zawNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Na'c gunxgaatu xhigab neṉ lastootu xhini'c guiniitu lojreni, ");
INSERT INTO zawNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","sa'csi narä sunidxä diidx guiniitu, sunidxäza yäḻnajn lojtu te digac gudzu'reni diidx lojtu niclaza gacdi guiniyajreni xtiidxtu. ");
INSERT INTO zawNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Näjza rexcuzajntu sibire lojtu, suto'reni la'tu, sigajcza rebejtztu, resa'tu, rexamiigwtu, luxh yu'tu sugu'treni. ");
INSERT INTO zawNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Guiraa rebejṉ guedxliuj sibälaz la'tu sa'csi rinälajztu xtidxä. ");
INSERT INTO zawNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Niluxh ni'cla tej xquidxejctu di nitloj. ");
INSERT INTO zawNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Luxh palga sutijptis lajztu, sajptu yäḻnabajṉ par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Che fiitu tre' xhidajl soldaad guideb gabi guedx Jerusalén coḻyacbee abidzujṉ dxej ni guibijḻni. ");
INSERT INTO zawNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Dxejc reni yu' guedx Judea, nanab guxuṉreni chacuatzlojreni neṉ redajn; reni yu' guedx Jerusalén, nanab jiunejzreni ro'c; reni suga' lo niaa, na'c guibi'reni lo guejdxga, ");
INSERT INTO zawNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","sa'csi neṉ redxejga sujn Dios fis lo guejdxga te soob rediidx ni caj lo reguijtz xten Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Probe'za regunaa ni nuu bäz neṉ redxejga, näjza regunaa ni ca' bäz, sa'csi su' yäḻhuinduxh lo guedxliuj, näjza fis ni gun Dios loj rebejṉga. ");
INSERT INTO zawNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Yu'reni guet lo gueṟ, yu'zareni chää pres, sijreni balti guedxzijt. Dxejc rebeṉzijt sinibee guedx Jerusalén che guiza'li redxej ni gusaan Dios guinibee rebejṉ ni di gac xpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Räjpzani: ―Dxejc su' seen lo gubijdx näjza lo bäii, näjza loj rebajle' ni yu' xhaguibaa. Luxh lo renacioṉ guedxliuj su' rebejṉ yärsia', di jieṉ xhi gunreni, sidxebduxhreni sa'csi siejn diajgreni chubeduxh lo nisdoo, säsduxh nis ni räjs lo nisdoo. ");
INSERT INTO zawNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Sitioḻ rebejṉ xcuent yäḻrdxebduxh che gunreni xhigab xhicharuni'c gac lo guedxliuj, sa'csi näj guideb guibaa sinibsejs. ");
INSERT INTO zawNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Dxejcti suhuiireni lo Xi'n Dios ni gujc Niguii, siäädni lo te za guideb xcäḻrnibeeni, näjza yäḻrdimbichaduxh. ");
INSERT INTO zawNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Che guisloj gac recosre, coḻsutijp lajztu, coḻguiliäs yejctu, coḻguibalajz sa'csi asadzujṉ dxej gusilajztu. ");
INSERT INTO zawNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Guniizani stee cuent lojreni, räjpni: ―¡Coḻhuii lo yagiigw näjza lo guiraa reyajg! ");
INSERT INTO zawNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Che fiitu acabääni be'n, coḻyacbee lagajc la'tu, abidzuṉgajxh bäii nisguij. ");
INSERT INTO zawNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Sigajcza che fiitu agusloj cayajc recosre, coḻyacbee asiäddzujṉ xcäḻrnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Rniliä́pac lojtu, guiraa recosre sajc ansde guet rebejṉ ni yu' ṉaj. ");
INSERT INTO zawNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Guibaa näjza guedxliuj sinitloj, rextidxä dini nitloj. ");
INSERT INTO zawNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’¡Coḻsusiṉ lagajc la'tu! Na'c gusaantu cha lajztu yäḻrausa'c, yäḻrä', yäḻga'ptu xhixtentu, dxejc ditu gacbee che bidzujṉ dxejga. ");
INSERT INTO zawNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sa'csi si'c sidzujṉ dxejga loj guiraa rebeṉ guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Coḻsusiṉ, coḻbejdx, coḻguiniabtis lo Dios, te gac ḻaatu lo guira'ti ni gac, gacza suutu nez loj Xi'n Dios ni gujc Niguii. ");
INSERT INTO zawNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Rdxee ruluii Jesús neṉ guidoro dxejc guxhijṉ sajia'nni yejc dan Oliib. ");
INSERT INTO zawNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Rsilru ristie rebejṉ te rdzujṉreni lo Jesús neṉ guidoro casob rsil, te gucuadiajgreni rextiidxni. ");
INSERT INTO zawNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Siäddzuṉgajxh dxe lanij che rajwreni yätxtiil ni di säguij, laaza lanijga pascw. ");
INSERT INTO zawNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Dxejc reni rnibee loj rebixhojz näjza rebejṉ ni ruluii leii caguiilreni xho gunreni te ju'treni Jesús, sa'csi rdxejbreni rebeṉguejdx. ");
INSERT INTO zawNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Dxejc biu' beṉdxab lastoo Judas ni laaza Iscariote, ni najc tej retzubitio'p xpejṉpacni. ");
INSERT INTO zawNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Dee huininäjni dade' ni rnibee loj rebixhojz näjza loj reni rnibee rexcuxhtis guidoo. Guninäj Judasreni xho gunni te guteedni Jesús ladzṉaareni. ");
INSERT INTO zawNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Dxejc bibalajzreni, bia'nreni diidx gudeedreni meel lojni. ");
INSERT INTO zawNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Cuäjbti Judas, dxejcni guslojni caguiilni xho gunni guteedni Jesús ladzṉaareni che rut bejṉdi suga'. ");
INSERT INTO zawNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bidzujṉ dxe lanij che rajwreni yätxtiil ni di säguij, che rugu'tzareni te xiil si'c ni caj lo xleii toMoisés. ");
INSERT INTO zawNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Dxejc baxhaḻ Jesús Pedr näjza Juan, räjpni lojreni: ―Coḻchayejn xchej xten pascw te guidaununi. ");
INSERT INTO zawNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Dxejc laareni gunabdiidxreni lojni, räjpreni: ―¿Caro rlajzlu choyennuni? ");
INSERT INTO zawNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Räjp Jesús lojreni: ―Cheni jiu'tu lo guejdx, sidxaagtu te dade' ni nuu te re' nis. Coḻchanajlni, coḻjiu' rolijz bejṉ cadro jiu'ni laani. ");
INSERT INTO zawNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Dxejc coḻye'tz lo bejṉ ni najc rolijzni ro'c: “Si'c naj Dad Mastr: ¿Con yu' cadro sajc gauxchenää́ rexpeṉä ṉaj pascw?” ");
INSERT INTO zawNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Dxejc guluiini lojtu te yu' ni sojb jiaa yejc stee yu'. Asuchexgaa yu'ga. Ro'c coḻyejn xhi guidaunu. ");
INSERT INTO zawNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Sä'tireni. Si'ctis ni räjp Jesús lojreni, si'cpac bidxälreni. Dxejc bejnreni xchej xte lanij pascw gaureni. ");
INSERT INTO zawNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Che bidzujṉ oṟ, gurenäj Jesús rexpejṉpacni lo mex. ");
INSERT INTO zawNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Dxejc räjpni lojreni: ―Guyuduxhä gaan gaunää́pactu xchej xten pascw ansde tedä trabajwduxh. ");
INSERT INTO zawNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Sa'csi rniä lojtu, diruna gaunää́ la'tu pascw cheni guidzujṉli dxej ni gacni lo xcäḻrnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Dxejc cua'ni te co'p, badeedni xquixtios lo Dios, räjpni: ―Coḻyä' dee, coḻgudeedni lo sa'tu. ");
INSERT INTO zawNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Sa'csi rniä lojtu, diruna yä'ä nis ni rii yejc uub stehuält cheni guidzujṉli xcäḻrnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Dxejcti cua'ni yätxtiil, badeedni xquixtios loj Dios, gula'nini, gudisnini lojreni, räjpni: ―Dee najc si'c tiexhä ni gudedä ju'treni xcuenttu. Coḻyejn screeza te guinalajztu narä. ");
INSERT INTO zawNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Si'cza bennäjni co'p che gulujx gudajwreni, räjpni lojreni: ―Ni yu' neṉ co'p najc si'c xtienä ni guixe' che ju'treni narä xcuenttu te si'c jiu' didxcoob ni jia'n Dios con rebejṉ ni aguleni. ");
INSERT INTO zawNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Per bahuilaare, bejṉ ni guto' narä sobganäj narä lo mexre. ");
INSERT INTO zawNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Guliipacni, Xi'n Dios ni gujc Niguii sinuu tedni loj nezyuj ni abaluii Dios lojni. Luxh proobza bejṉ ni guto' narä. ");
INSERT INTO zawNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Dxejc gusloj canabdiidxreni lo sa'reni, ¿chuchani'c gunni? ");
INSERT INTO zawNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Sas gusloj cayejyreni, don chuni'c guibee gac beṉro lojreni. ");
INSERT INTO zawNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Dxejcti räjp Jesús lojreni: ―Reṟeii ni rnibee lajdx bejṉ ni digac xpejṉ Israel, rnibeereni lojreni astoo xtenpacreni najc reguejdxga. Luxh rebeṉguejdxga rnii lacti hueen najc reṟeiiga. ");
INSERT INTO zawNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Per la'tu na'c gactu si'c. Nani najc beṉgoolru lojtu, ni'c riäjḻ gacni si'c najc ni huinru lojtu. Luxh nani rnibee riäjḻ gacni si'c mos. ");
INSERT INTO zawNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Chuni'c sajcru lo bejṉ? ¿La bejṉ ni rbej lo mex te gauni o la ni ruteed xhi gaureni lo mex? ¿La xhet sajcdiru bejṉ ni sojb lo mex, ä? Niluxh narä yu'ä lojtu si'c ni ruteed xhi gauni. ");
INSERT INTO zawNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’La'tu najctu ni gusunäj narä guideb ni gudedä retrabajw ni gudedä. ");
INSERT INTO zawNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ni'cni narä runidxä yäḻrnibee lojtu sigajc ni baniidx xtad yäḻrnibee loä, ");
INSERT INTO zawNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","te gautu, yätu lo xmexä xhaguibaa, te cuezatu lo yagxhil cadro guntu yäḻguxhtis loj rexpejṉ guitzubitio'p rexagdoo Israel. ");
INSERT INTO zawNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Räjp Jesús loj Simón: ―Simón, Simón, agunab beṉdxab ni laa Satanás luj te gusniibni luj si'c rusniib bejṉ xob te jiani. ");
INSERT INTO zawNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Narä agunabä lo Dios xcuentlu te na'c jiäädx xcäḻrililajzlu. Luxh luj che gusiejch lajzlu, guibi'lu, bastioob lastoo resa'lu. ");
INSERT INTO zawNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Räjp Simón lojni: ―Dad, narä sirinalälu; mase gusäureni luj latzguiib, näjza narä siäunää́lu; mase ju'treni luj, näjza narä setnää́lu. ");
INSERT INTO zawNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Dxejcti räjp Jesús loj Simón: ―Pedr, rniä lojlu, nicla gajd guidgaii cuedxa' nadxej niluxh luj alaräjplu choṉli huält, dipaclu gumbee narä. ");
INSERT INTO zawNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Dxejc gunabdiidx Jesús lojreni räjpni: ―Che ganaxtu baxhaḻä la'tu, xhet bolsdi sanätu, nicla carteerdi, niclaza stee gura'chdi, ¿la yu' xhi biquiintu, xhi biäädx lojtu, ä? Dxejc räjpreni: ―Xheti. ");
INSERT INTO zawNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Dxejc räjpni lojreni: ―Luxh ṉaj rniä lojtu, ni rajp bols, suchanänini; sigajcza carteer. Luxh ni di ga'p espaad, guto'ni xchamarni te siini tejni. ");
INSERT INTO zawNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Sa'csi rniä lojtu, sisiojb rediidx ni caj lo requijtz Dios xcuentä, cadro caj: “Bigabnäjni rebeṉ latsiaj.” Guiraa ni caj lo reguijtz xten Dios xcuentä nanab soobpacni. ");
INSERT INTO zawNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Dxejc räjpreni lojni: ―Dad, aree tio'p espaad. Dxejc räjpni lojreni: ―Sajl reni'c. ");
INSERT INTO zawNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Dxejcti birii Jesús, si'cni rujnpacni, sääni nez dajn ni laa Oliib. Dxejc sanajl rexpejṉpacni. ");
INSERT INTO zawNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Che bidzujṉreni ro'c, räjpni lojreni: ―Coḻcuejdx, coḻnab lo Dios te na'c jiajbtu lo dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Dxejc gubicaj Jesús lojreni, huijni te lajt zite' cadro suga'reni, si'cti cadro rdzujṉ te guij che rucuaanini. Ro'c bazuxhijbni, gurejdx-gunabni lo Dios, ");
INSERT INTO zawNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","räjpni: ―Xtadä, palga rlajzlu, basḻaa narä loj trabajwduxhre. Niluxh na'c gacni si'c ni rlazä narä. Bejn si'cni rlajzlu gunlu. ");
INSERT INTO zawNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Dxejc biricaj te xangl Dios lojni te badeedni yäḻrutiplajzni. ");
INSERT INTO zawNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Laḻni cadejdni trabajwduxh, cayac-huinduxh lajzni, cabedx-canabruni lo Dios. Guzunislini gusloj catejb lo yuj biniduxh si'c rejn lojni. ");
INSERT INTO zawNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Cheni huisuni, gulujx gurejdx-gunabni lo Dios, huijni cadro suga' rexpejṉpacni. Ro'c bidxälnireni nagayejs guiraareni sa'csi cayac-huin lajzreni. ");
INSERT INTO zawNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Dxejc räjpni lojreni: ―¿Xhicuent nagayejstu? ¡Coḻchastie! ¡Coḻnab lo Dios te na'c jiajbtu lo dojḻ! ");
INSERT INTO zawNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Laḻ ni canii Jesús lojreni, bidzujṉ xhidajl bejṉ. Tej rexpejṉpacni ni laa Judas, nijdni nez loj rebejṉga. Dxejcti gubigni loj Jesús, te bachagro'ni loj Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Dxejc räjp Jesús lojni: ―Judas, ¿la con te yäḻruchagro' ruteedlu Xi'n Dios ni gujc Niguii ladzṉaa rebejṉre, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Che bahuii reni suganäj Jesús xhini'c cayajc ro'c, gunabdiidxreni loj Jesús, räjpreni: ―Dad, ¿la sixa'tnu yejcreni con spaad, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Sas tej rexpejṉ Jesús gudiḻnäj te mos xten ni rnibee loj rebixhojz, batiu'ni diajgni ladbee. ");
INSERT INTO zawNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Dxejc räjp Jesús lojreni: ―¡Agujc! ¡Coḻgusaanreni! Dxejc gudajn Jesús diajg mosga, basiajcnini. ");
INSERT INTO zawNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Gunigajc Jesús loj reni rnibee loj rebixhojz näjza reni najc guixhajg xten guidoo näjza rebeṉgool, guiraa reni siädxiinini, räjpni: ―¿La siädnätu spaad näjza garo't, astoocanu siädxiitu te gubaan, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Cheni suga'a lojtu guixe-guixee neṉ guidoo, ditu nuhuaḻ narä. Per dee najc xoṟtu, luxh arnibee yäḻnacäjy la'tu. ");
INSERT INTO zawNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dxejcti gunaazreni Jesús huinärenini rolijz bixhojz ni rnibee lo guiraa rebixhojz. Siädnäjl Pedrni zit-zijt. ");
INSERT INTO zawNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Che bidzujṉreni gule'creni guiboo galäii lole' xten bixhojzga, gurejreni guideb gabi, te bidxa' lajzreni. Näj Pedr nadxaag lojreni gurej ro'c. ");
INSERT INTO zawNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Dxejc te gunaa ni rujn dzuun ro'c, che bahuiini sobga' Pedr ro'c, rdxelojtisni lojni, räjpni: ―Näj niguiire guyunäj Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Dxejc basuni' Pedr räjpni: ―Nan, dina gumbeäni. ");
INSERT INTO zawNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Che gojl stera't, che bahuii stee bejṉ lojni, räjpni lojni: ―Näj luj najclu te rexpejṉni. Per Pedr räjp lojni: ―Gurniälojlu, Dad, dina gacä xpejṉni. ");
INSERT INTO zawNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Che gudejd si'cti teb oṟ, räjp stee bejṉ lojni: ―Guliipacni, näj bejṉre guyunäjni, sa'csi laani najczani te beṉ Galilee. ");
INSERT INTO zawNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Dxejc räjp Pedr lojni: ―Gurniälojlu Dad, dipacna ganä xhini'c caniilu loä. Laḻni canii Pedr rediidxre, guredxa' te guidgaii, ");
INSERT INTO zawNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","luxh gubiréza Jesús, bahuidzu'tzni lo Pedr, dxejc banalajz Pedr nani gunii Jesús lojni, räjpni: “Che gajd guidgaii cuedxa', abazuni'lu choṉ huält, räjplu dilu gumbee najrä.” ");
INSERT INTO zawNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Dxejcti guc-huin lajz Pedr, biriini ro'c, ronduxhni. ");
INSERT INTO zawNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Rebejṉ ni canäj Jesús, gusloj caguxhisnäjrenini, caguijnzarenini. ");
INSERT INTO zawNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Dxejc basäureni lojni, gudajpreni lojni, räjpreni lojni: ―¡Gunii chuni'c gudijnlu! ");
INSERT INTO zawNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Luxh guiraloj cayäjbreni lojni, caniyaduxhrenini. ");
INSERT INTO zawNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Che bara yääl, bidojp rebeṉgool ni rnibee, näjza reni rnibee loj rebixhojz, näjza rebejṉ ni ruluii leii, huinäreni Jesús te suuni nez lojreni neṉ yu' cadro rujnreni yäḻguxhtis. Dxejcti räjpreni lojni: ");
INSERT INTO zawNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Palga luj najclu Crist, bicäjpni loonu. Dxejc badzu' Jesús diidxre lojreni, räjpni: ―Palga guicäpäni, ditu chalilajz. ");
INSERT INTO zawNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Luxh palga gunä te yäḻgunabdiidx lojtu xcuent Crist, ditu gudzu' diidxga loä. ");
INSERT INTO zawNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Per ṉajli sibej Xi'n Dios ni gujc Niguii xladbee Gueb Dios ni yu' xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Dxejc gunabdiidx guiraareni lojni, räjpreni: ―Mbaj pues, ¿la luj najclu Xi'n Dios, ä? Dxejc badzu' Jesús diidxre lojreni räjpni: ―Nacäni, si'cni najtu la'tu. ");
INSERT INTO zawNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Dxejc räjpreni lo sa'reni: ―¿Xhirucxhamaaz rlajztu? Dirunu guiquiin diidx guinii bejṉ, sa'csi lagajc nuurnu abiejn diajgnu diidx ni guniini lagajc laani. ");
INSERT INTO zawNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Dxejc huisu guiraareni, huinäreni Jesús nez loj Pila't. ");
INSERT INTO zawNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ro'c guslojreni cabe'creni xquejni, räjpreni: ―Bidxälnu bejṉre cayujnni biejy lo rexpejṉnu. Räjpzani xhet nanabdi quiixnu impuest lo ṟeii César. Caniizani laani najcni Crist, nalajznu najczani ṟeii. ");
INSERT INTO zawNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Dxejc gunabdiidx Pila't lojni, räjpni: ―¿La luj ni najc ṟeii xten rexpejṉ Israel, ä? Sas badzu' Jesús diidxre räjpni: ―Najcni lagajc si'c ni guniilu. ");
INSERT INTO zawNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Dxejc räjp Pila't loj reni rnibee loj rebixhojz näjza loj guiraa rebejṉ: ―Dina guidxälä nicla tej dojḻ xten bejṉre. ");
INSERT INTO zawNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Niluxh laareni sanuutis caniireni, dipru caniireni, räjpreni: ―Guiraa rebeṉ Judea cayu' yärsia' xcuent xcäḻruluiini. Guslojni guedx Galilee, luxh reeli sanuu caguluiinini. ");
INSERT INTO zawNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Che biejn diajg Pila't rediidxre, gunabdiidxni: “¿La Galilee siääd bejṉga?” ");
INSERT INTO zawNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Cheni räjpreni ro'c siäädni, baxhaḻnini loj Herodes ni najc gubernadoor xten Galilee, sa'csi neṉ redxejga yu' Herodes guedx Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Che bahuii Herodes loj Jesús, bibalajzni sa'csi agujc xchej rlajzni fiini lojni, sa'csi abiejn diagni diidx xcuent ni cayujnni. Luxh rlajzni fiini gunni te milaagwr. ");
INSERT INTO zawNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Xhidajl yäḻgunabdiidx bejn Herodes, luxh xhet guniidi Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ro'c suga'za reni rnibee loj rebixhojz näjza rebejṉ ni ruluii leii, cabecduxhrureni xquejni. ");
INSERT INTO zawNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Dxejc gulälaz Herodes näj rexsoldaadni Jesús, baxhiznäjrenini, ni'c bashuajcwrenini te ladsa'c sa' ni rajcw ṟeii, dxejcti baxhaḻsacrenini loj Pila't. ");
INSERT INTO zawNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Lagajc dxejga, Pila't näjza Herodes gujcreni amiigw, luxh galoo bidxe'ch lo sa'reni. ");
INSERT INTO zawNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Dxejc gurejdx Pila't reni rnibee loj bixhojz, näjza rebeṉgool ni najc guxhtis, näjza rebeṉguejdx. ");
INSERT INTO zawNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Dxejc räjpni lojreni: ―La'tu biädnätu bejṉre loä, najtu caguquiḻni rebejṉ gunreni biejy, luxh narä agunabdiidxä guiraloj lojni nez lojtu, luxh abahuiitu dina nidxälä nicla tej dojḻ ni cagucuaquijtuni. ");
INSERT INTO zawNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Niclaza Herodes di nidxäl nicla tej dojḻ, ni'cni baxhaḻsacnini loonu, luxh abahuiitu xhet dojḻdi bejnni te guetni. ");
INSERT INTO zawNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ni'cni quinäni, dxjecti gusḻaä́ni. ");
INSERT INTO zawNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Najc costumbr rusḻaa Pila't te bejṉ ni yu' neṉ latzguiib casob rajc lanijre. ");
INSERT INTO zawNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Per guiraareni guredxa'reni si'c tejsi bejṉ, räjpreni: ―¡Bagu't bejṉre, basḻaa Barrabás! ");
INSERT INTO zawNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás najc ni basäḻreni latzguiib sa'csi batojpni te cuaa bejṉ ni bacuanäj resoldaad xten Rom̲, näjza sa'csi yu' chu bagu'tni. ");
INSERT INTO zawNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Rlajzpac Pila't gusḻaani Jesús, ni'c gunisacni lojreni, ");
INSERT INTO zawNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","niluxh rebejṉ dipru guredxa'reni, räjpreni: ―¡Bacuaani lo crujz, bacuaani lo crujz! ");
INSERT INTO zawNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Riojṉ gunisac Pila't lojreni, räjpni: ―¿Xhi doḻduxh bejnni? Xhetlidi dojḻ rdxälä bejnni te guetni. Ni'cni siguinäni dxejc susḻaäni. ");
INSERT INTO zawNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Luxh laareni sanuutis guredxa'reni, gunabreni xcajni lo crujz. Luxh sa'csi guredxa'tisreni, bejntireni gaan gujc si'c ni rlajzreni. ");
INSERT INTO zawNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Dxejc cuäjb Pila't gunibeeni gac si'c ni gunabreni. ");
INSERT INTO zawNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Dxejc basḻaani bejṉ ni yu' latzguiib sa'csi bejnni biejy, bagu'tzani bejṉ, dxejc badeedni Jesús lojreni te gunnäjrenini si'ctis ni rlajzreni. ");
INSERT INTO zawNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Cheni sanäreni Jesús xcaj lo crujz, gunaazreni te bejṉ ni laa Simón ni siääd guedx Cirene; basaj bejṉga lo niaa. Dxejc basguurenini crujz, siädnajltini dejtz Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Siädnajlza xhidalduxh bejṉ, näjza xhidajl gunaa ni cayonduxh, cabedxa'reni sa'csi cayac-huinduxh lajzreni xcuent Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Dxejc gubiré Jesús, räjpni lojreni: ―Gunaa Jerusalén, na'c roontu xcuentä, coḻyoon lagajc xcuenttu näjza xcuent rexi'ntu. ");
INSERT INTO zawNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sa'csi sidzujṉ dxej gäbreni: “Chicbaa regunaa ni di gacdi chu xi'nni, chicbaaza reni di nuxi'n, renani di nusiä' bäz.” ");
INSERT INTO zawNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Dxejc guisloj rebejṉ gäb loj redajn: “Coḻjiajb yejcnu”, säjbzareni loj relom̲: “Coḻgucua'tz nuurnu.” ");
INSERT INTO zawNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Palga scree runnäjreni narä ni nacä si'c te yagnaga, aticaxh gunnäjreni la'tu ni najc si'c te yagbijdz. ");
INSERT INTO zawNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Sanäzareni tio'p beṉguijdx xcajzareni loj recrujz, guetnäjreni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Che bidzujṉreni te lajt ni laa Calabeer, ro'c bacuaareni Jesús lo te crujz, bacuaazareni guiro'p rebeṉguijdxga lo stio'p crujz, tejni xladbee, steeni xladbäjgwni. ");
INSERT INTO zawNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Cheni cagucuaa rebejṉ reni lo crujz, gunii Jesús, räjpni: ―Xtadä, badzucaj xtojḻ rebejṉre, sa'csi direni gan xhini'c cayujnreni. Dxejc gudzujt resoldaad daad yejc xhajbni, te gudisreni xhajbni cua'renini. ");
INSERT INTO zawNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Suga' rebejṉ ro'c cadxelojtisreni. Näjza reguxhtis caguxhisnäjreni laani, cayäjpreni: ―Balti bejṉ basḻaani, ṉaj sugusḻaani lagajc laani palga guliini laani najcni Crist ni gule Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Näjza resoldaad caguxhisnäjni, gubigreni lojni te badeedreni bin-nii yäni. ");
INSERT INTO zawNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Dxejc räjpreni lojni: ―Palga gulii najclu ṟeii xten rexpejṉ Israel, basḻaa lagajc luj. ");
INSERT INTO zawNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Luxh bacuaareni gaii diidx loj te baräjd ni cuaj yejc crujz. Con didx griegw, con didx latíṉ, näjza didx hebreo, bacuaareni scree: “Dee najc Reii xten rexpeṉ Israel.” ");
INSERT INTO zawNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Te rebeṉ guijdx ni najl lo te crujz ni caj cuä'ni caniyajni Jesús, räjpni lojni: ―Palga luj najclu Crist, basḻaa lagajc luj nägajcza nuurnu. ");
INSERT INTO zawNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Per beṉguijdx ni najl lo crujz stelaadga gudidxa'ni loj stee beṉguijdx ni caniyaj Crist, räjpni: ―¿La dilu guidxejb Dios? ¡Ni cayajczalu tejsi castiigw! ");
INSERT INTO zawNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Per nuurnu cayajcnu castiigw ni riäjḻ gacnu te guidiixnu redojḻ ni biennu. Luxh laani xhet dojḻdi bejnni. ");
INSERT INTO zawNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Dxejc räjpni loj Jesús: ―Bazalajzlu narä che guidzujṉlu lo xcäḻrnibeelu. ");
INSERT INTO zawNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Dxejc badzu' Jesús diidxre, räjpni lojni: ―Rniliä́pac lojlu, lagajc nadxej chunäjlu narä xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Agojl si'cti läidxej. Dxejc bicäjy guideb guedxliuj, si'c bianxcäjy si'cti rcachoṉti. ");
INSERT INTO zawNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Bicäjy lo gubijdx, luxh ladró ni najl neṉ yudxanro xten guidoro, biräjsni gucni tio'p la'. ");
INSERT INTO zawNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Dxejcti guredxa' Jesús, räjpni: ―Xtadä, ladzṉaalu rutedä xaimä. Che guniini si'c, gujttini. ");
INSERT INTO zawNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Che bahuii capitán ni rnibee loj resoldaad guiraa ni guzajc, gulä'pni xpala'n Dios, räjpni: ―Guliipacni, xhet dojḻdi bejn bejṉre. ");
INSERT INTO zawNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Guiraa rebejṉ ni suga' ro'c ni bahuii guiraa ni guzajc ro'c, gubi'reni rolijzreni, cayääzreni lagajc lastooreni. ");
INSERT INTO zawNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Luxh guiraa reni rumbee Jesús, näjza regunaa ni biädnajlni che biriilini Galilee, zijtru bia'nreni cahuiireni guiraa recos ni cayajcre. ");
INSERT INTO zawNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Guyu' te bejṉ ni laa José, lacti huen najcni, luxh laaca rujnni guira'ti. Siäädni guedx Arimatea, región Judea. Nadxaagzani loj reni rnibee neṉ guidoro xten rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Cabäjzza José jiääd yäḻrnibee xten Dios, ni'cni dini nidxaglajz nani bejn resa'ni. ");
INSERT INTO zawNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Dxejcti huijni lo Pila't, gunabni tiejxh Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Che gulätnini lo crujz, batejbnini neṉ te bariaad, dxejcti bacua'tznini neṉ te baa ni guc-chee cuä' te guilaj. Nacoob baaga, nicla tej bejṉ gajd guiga'tz ro'c. ");
INSERT INTO zawNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Dxejga najc dxej ni rusucheereni guira'ti, luxh agojl jiu' dxej ni rusilajzreni. ");
INSERT INTO zawNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Regunaa ni guzanäj Jesús che biriilini Galilee huihuiireni robaaga te bahuiireni xho gudixhreni togoolga neṉ baa. ");
INSERT INTO zawNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Che gubi'reni rolijzreni bencheereni recuaan ni rlianexhduxh näj te ni najc si'c te saj ni rlianexhduxh ni ruzaareni retogool. Dxejcti basilajzreni dxej ni rusilajz bejṉ, si'cni caj lo xleii Moisés gunreni. ");
INSERT INTO zawNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Dxej ni gusloj xmaanga, rsildooru huinä regunaaga robaa recuaan ni rlianejxh ni bencheereni. ");
INSERT INTO zawNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Che bidzujṉreni, bahuiireni agubicaj guij ni rusäu ro' baa. ");
INSERT INTO zawNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Dxejc che biu'reni neṉ baaga, direni nidxäl tiejxh Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Laḻ ni cadxelojreni, di jieṉ xhi gunreni, biricaj tio'p dade' gusuj cuä'reni. Rdimbichaduxh xhajbreni. ");
INSERT INTO zawNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bidxebduxh regunaaga, basajbreni lojreni lo yuj. Dxejc räjp redade'ga lojreni: ―¿Xhicuent siädtiiltu te bejṉ ni nabajṉ lo rebeṉgut, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Rutini ree. Agubaṉsacni. Coḻgusnaj lajztu rediidx ni guniini cheni guyusijcni Galilee, ");
INSERT INTO zawNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","che najni lojtu: “Riäjḻ jiajb Xi'n Dios ni gujc Niguii ladzṉaa rebeṉdojḻ, xcajzani lo crujz, dxejc ni riojṉ dxejga sibaṉsacni loj rebeṉgut.” ");
INSERT INTO zawNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Dxejc banaj lajz regunaa xtidx Jesús, ");
INSERT INTO zawNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","biriireni robaa, gubi'tireni te bijreni diidx lo retzubiteeb rexpejṉpacni näjza loj rebejṉ ni yunäjreni. ");
INSERT INTO zawNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Reni huisa'n diidx loj rexpejṉpac Jesús najc redee: Marii Magdaleṉ, näjza Xuan, näjza Marii xnan Jacoob, näjza sgaii gunaa. ");
INSERT INTO zawNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Niluxh rexpejṉpacni bejn xhigab didxnayäälni, direni nililajz xtidx regunaaga. ");
INSERT INTO zawNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Dxejc huisu Pedr, ruxuṉlini huijni ro' baa. Che gudixhlojni, bahuiini neṉ baaga, ganaxtis bariaad dzuub te laad. Dxejc gubi'ni rolijzni, rdxelojtisni xcuent ni gujc. ");
INSERT INTO zawNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lagajc dxejga, tio'p rexpejṉpacni sääreni te guejdx ni laa Emaús, ni ria'n si'cti tzubiteeb kilómetro loj guedx Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Laḻ ni sasajreni lo nezyujga, cayujyreni diidx xcuent reni gujc ro'c. ");
INSERT INTO zawNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Laḻ ni caniireni gubig Jesús lojreni, gusloj sasanäjnireni. ");
INSERT INTO zawNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Luxh mase cahuiireni lojni, yu' xhi badxojn niembeerenini. ");
INSERT INTO zawNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Dxejc gunabdiidx Jesús lojreni, räjpni: ―¿Xhini'c rujytu laḻ ni sasajtu, ä? ¿Xhicuent cayac-huin lajztu? ");
INSERT INTO zawNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tejreni ni laa Cleofas badzu' diidxre, räjpni: ―Guiraasi bejṉ najn xhi gujc neṉ guedx Jerusalén. ¿La lujtis bia'nlu neṉ guejdxga ni di gan xhi gujc ro'c, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Dxejcti räjp Jesús lojreni: ―¿Xhini'c gujc ro'c? Dxejc räjpreni lojni: ―Recos xcuent Jesús ni siääd guedx Nazare't, ni gujc te niguii ni gunii xtidx Dios, rajpni yäḻrnibeduxh xten Dios loj redzuun ni rujnni näjza loj rediidx ni rniini, nez loj Dios näjza nez loj rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Näjza xho bejn reni rnibee loj rebixhojz näjza rexcuxhtisnu, bateedrenini ladzṉaa reni gunibee guetni, dxejc bacuaarenini lo crujz. ");
INSERT INTO zawNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Niluxh nuurnu cabääznu laani gacni nani nusḻaa rexpejṉ Israel ladzṉaa rebeṉzijt. N̲aj agujc choṉ dxej ni gujc recosre. ");
INSERT INTO zawNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Luxh yu' gaii gunaa ni nadxaag loonu ni baschelojreni nuurnu. Barsil, che huijreni robaa xtenni, ");
INSERT INTO zawNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","direni nidxäl tiejxhni. Biädsa'nreni diidx loonu najreni bahuiireni lo tio'p xangl Dios ni räjp lojreni, agubaṉsac Jesús lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Dxejcti huihuii gaii sa'nu robaa, bahuiizareni najcni si'ctis ni naj regunaaga loonu, niluxh direni nuhuii loj Jesús. ");
INSERT INTO zawNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Dxejc räjp Jesús lojreni: ―¡Lacti nayääl tre' xcäriejntu! Lacti neṉ rililajztu xtidx redade' ni gunii xtidx Dios xcuent Crist. ");
INSERT INTO zawNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿La di nungäjḻ tedxgaa Crist retrabajwduxhre dxejcti jiu'ni lo xcäḻrdimbicha' Dios, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Dxejc gusloj cagusule'ni guiraa rediidx ni caj lo xquijtz Dios xcuent Crist. Guslonäjni xtidx Moisés, dxejc huinuuni basule'ni guiraa reguijtz ni bacuaa redade' ni gunii xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Che bidzujṉreni guejdx cadro sääreni, bejn Jesús si'cni chanuuni chääni lo nezyuj. ");
INSERT INTO zawNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Dxejc laareni bascuääzrenini te jiannäjnireni, räjpreni lojni: ―Biannäj nuurnu, sa'csi acayajc gudxej, agojl jiu' guxhijṉ. Dxejcti biu' Jesús te jiannäjnireni. ");
INSERT INTO zawNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Cheni sobganäjnireni lo mex, cua'ni yätxtiil, benle'nini, dxejc gula'nini, gudisnini lojreni. ");
INSERT INTO zawNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Lagajc dxejc, baxhal Dios balojreni, biembeereni Jesús, dxejc laani gunitlojni lojreni. ");
INSERT INTO zawNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Dxejcti räjpreni lo sa'reni: ―¿La di lastoonu nibeguiboo cheni siädniini loonu lo nezyuj, che cagusule'ni xtidx Dios? ");
INSERT INTO zawNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Dxejc dirureni nibäjz ro'c, alga gunasgajcreni nez, gubi'reni guedx Jerusalén. Ro'c bidxälreni abidojp xpejṉpac Jesús näjza sgaii bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Dxejcti bijreni diidx loj guiro'preni bidzujṉ, räjpreni: ―Guliipac gubaṉsac Jesucrist, luxh baluilojni loj Simón. ");
INSERT INTO zawNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dxejc guiṟo'p reni bidzujṉ bijzareni diidx ni gusajcreni lo nezyuj, näj xho biembeezareni Jesús che gula'ni yätxtiil. ");
INSERT INTO zawNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Canisi'creni rediidxre chela baluiloj lagajc Jesús galäiireni, guniini xchan lojreni, räjpni: ―¡Coḻcuecdxi lajztu! ");
INSERT INTO zawNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Per laareni rdxelojreni bidxejbreni, naareni cahuiireni lo te sprit. ");
INSERT INTO zawNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Dxejc räjp Jesús lojreni: ―¿Xhicuent cadxejbtu? ¿Xhicuent rac tio'p lastootu? ");
INSERT INTO zawNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","¡Coḻhuii reṉaä, näjza reni'ä! Lagajc naräni. Coḻcajn narä te fiipactu laa naräni, sa'csi anajntu di te sprit ga'p bääl niclaza tzujt si'c rapä narä. ");
INSERT INTO zawNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Che guniini rediidxga, baluigajcni reṉaani näjza reni'ni. ");
INSERT INTO zawNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Laḻ ni cadxelojreni, di gacdi chalilajzreni, sa'csi cabaduxh lajzreni, räjpni lojreni: ―¿La yu' xhi rajptu gauä ree, ä? ");
INSERT INTO zawNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Dxejc badeedreni te la' bälbigue', näjza te la' seer ni yu' tzujn. ");
INSERT INTO zawNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ni'c cua'ni gudajwnini nez lojreni. ");
INSERT INTO zawNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Dxejc räjpni lojreni: ―Dee najc xtidxä ni rniä lojtu cheni yusicä lojtu, rniä riäjḻ soob guiraa rediidx xcuentä ni caj lo xleii Moisés, näjza lo rexquijtz redade' ni gunii xtidx Dios näjza ni caj lo rexquitz Salmos. ");
INSERT INTO zawNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dxejcti basanijni xcäriejnreni te gucbeereni xhi säloj rediidx ni caj lo rexquijtz Dios xcuentni. ");
INSERT INTO zawNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Dxejc räjpni lojreni: ―Scree caj lo reguijtz: Nanab guet Crist, dxejc ni riojṉ dxej, guibaṉsacni loj rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Sire'chza diidx xcuent xho rusḻaa Crist rebejṉ neṉ dojḻ che rusiejchreni lajzreni, che rililajzreni xtiidxni. Guedx Jerusalén guislojni, dxejc sire'ch diidx guideb guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","La'tu najctu testiigw guiraa recosre. ");
INSERT INTO zawNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Narä suxhaḻä Sprit Dxan xten Dios lojtu, ni'c coḻjia'n guedx Jerusalén cheni jiädläjzlini neṉ lastootu, guniidxni yäḻrnibee ni siääd xhaguibaali. ");
INSERT INTO zawNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Dxejc huinä Jesúsreni stelaad guedx Jerusalén gajxh lo te guejdx ni laa Betania. Ro'c guläsni ṉaani, benle'ni yejcreni. ");
INSERT INTO zawNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Laḻ ni cayujnni si'c, gubicajni lojreni, huäjsni xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Peta laareni gulujx gojnrenini, dxejc cabalazduxhreni gubi'reni guedx Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ro'c guixe-guixee guyu'reni neṉ guidoro, calä'preni xpala'n Dios. Sugacni si'c.");
INSERT INTO zawNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Galodoo che gusloj guira'ti, ala yu' Diidx. Luxh nani najc Diidxga yunäj Dios, luxh Diidxga najc Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Che gajd gac-cheeli guedxliuj, yunäjni Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Xcuent laani benchee Dios guedxliuj näjza guira'ti ni yu' lojni. Guiraa recos ni yu' di gacdi niu'reni paru rutini. ");
INSERT INTO zawNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Laani gojp yäḻnabajṉ. Yäḻnabajṉga najc bianij xten rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Luxh bianijga rdimbicha' nez lo yäḻcäjy, niluxh yäḻcäjyga di niajcdi nusuiinini. ");
INSERT INTO zawNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Guyu' te niguii birilaj Juan, ni baxhaḻ Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Laani biäädni te basule'ni diidx. Biädsule'ni diidx xcuent bianij te nililajz guiraa rebejṉ diidx xcuent bianij. ");
INSERT INTO zawNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Laani dini gac bianij, laani biädsule'ni diidx xcuent bianij. ");
INSERT INTO zawNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Laa bianijpacga ni rusanij lastoo guiraa rebejṉ, luxh ṉaj abiäädni lo guedxliujre. ");
INSERT INTO zawNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nani najc Diidxga guyu' lo guedxliujre, xcuent laazani guc-chee guedxliujre, luxh di rebeṉ guedxliujre nililajz chu najni najcni. ");
INSERT INTO zawNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Biäädni loj rexpeṉ Israel, niluxh rexpejṉni direni nicäjb niu'ni lojreni. ");
INSERT INTO zawNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Dxejc loj guiraa reni cuäjb guyu'ni lojreni, loj renani huililajz xtiidxni, loj reni'c badeedni yäḻrnibee gacreni xi'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Laa reni'c ni di gac si'c xi'n beṉ guedxliuj, ni gojl sa'csi rlajz te biniet chu xi'nni, dee najcpacreni Xi'n Dios sa'csi sudeedni yäḻnabajṉ par tejpas lojreni. ");
INSERT INTO zawNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Diidxga gujc te beṉ guedxliuj. Guläjzni lo guedxliujre, bahuilojzanu xcäḻrdimbicha'ni, si'c yäḻrdimbicha' xten xingan xteb xtadni, laani najcpacni nani sanälajz nuurnu, nani rnii didxlii loonu. ");
INSERT INTO zawNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan gunii xcuent Jesús. Guredxa'ni, räjpni: ―Laa dee ni rniä, nani siääd detzä sajcruni loä, sa'csi laani ganidni nabajṉni loä. ");
INSERT INTO zawNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Sa'csi guiraanu cua'nu xcäḻnasacduxhni, yäḻracnäj detz yäḻracnäj. ");
INSERT INTO zawNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Leii xten Dios biädnä toMoisés, niluxh yäḻracnäj näjza redidxlii biädnä Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Rut chu tejdi abahuii lo Dios, xinxtebni ni yunäjpac Dios, laani basule'ni diidx xcuent Dios loonu. ");
INSERT INTO zawNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Dee najc diidx nani gunii Juan ni rutiobnis che baxhaḻ rexpejṉ Israel rebixhojz näjza rexpejṉ guidoo ni laa levitas, biriireni guedx Jerusalén te sanabdiidxreni lo Juan, räjpreni lojni: ―¿Luj chu najclu? ");
INSERT INTO zawNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Dxejcti bicäjpni lojreni, xhet bacua'tzdini lojreni, räjpni: ―Et narädi nacä Crist ni jiääd. ");
INSERT INTO zawNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Dxejcti gunabdiidxreni lojni, räjpreni: ―¿Chuxhni'c najclu? ¿La lujni najc Elías? Räjpni: ―Dina gacäni. Räjpreni: ―¿La najclu te dade' ni gunii xtidx Dios ni cabääznu jiääd? Dxejc räjpni: ―Dina gacäni. ");
INSERT INTO zawNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Räjpreni: ―¿Chuxhni'c najclu? Te chonänu diidx loj reni baxhaḻ nuure. ¿Xhi rniilu, chuxhni'c najclu? ");
INSERT INTO zawNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Räjp Juan: ―Narä nacä nani rbedxa' nez lo reyubijdz si'c ni gunii Isaías, ni gunii xtidx Dios scree: “Coḻyensa'c xnezyuj Dad.” ");
INSERT INTO zawNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Rebejṉ ni baxhaḻ redee najc reni rniireni “farisee”. ");
INSERT INTO zawNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Dxejc gunabdiidxreni stee, räjpreni lo Juan: ―¿Xhicuent rutiobnislu palga dilu gac Crist ni jiääd niclaza Elías niclaza stee niguii ni rnii xtidx Dios ni cabääznu jiääd, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Dxejcti räjp Juan lojreni: ―Narä rutiobnisä con nis, niluxh galäiitu yu' tej nani ditu gumbee. ");
INSERT INTO zawNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Laa dee ni siääd detzä niluxh di nungäjḻ nicla surloä cuää́ xcura'chni, sa'csi sajcruni loä. ");
INSERT INTO zawNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Guiraa recosre gujc stelaad cadro laa Betábara, ni ria'n stelaad ro' gueu Jordán cadro cagutiobnis Juan. ");
INSERT INTO zawNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Che bara yääl, bahuii Juan siääd Jesús lojni. Dxejc räjpni: ―¡Coḻhuii! Aree Xile' xten Dios nani rudzucaj xtojḻ rebeṉ guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Lagajc xcuent dee ni rniä cheni guniä lojtu: “Detzä siääd te niguii ni sajcru loä, sa'csi ganidli narä agac nabajṉni.” ");
INSERT INTO zawNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Luxh dina niembeäni, per biädtiobnisä con nis te guluiä lo rexpejṉ Israel chu najcni. ");
INSERT INTO zawNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Guniiza Juan stee diidx xcuentni, räjpni: ―Narä bahuiä biäjt Sprit Dxan xten Dios xhaguibaa si'c te palom guzudxini yejcni. ");
INSERT INTO zawNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Dina niembeäni, per nani baxhaḻ narä gutiobnisä con nis, laani najni loä: “Cheni fiilu jiäjt Sprit Dxan xten Dios xhaguibaa si'c te palom, sudxini yejc te bejṉ, laanini najc ni gutiobnis con Sprit Dxan xten Dios.” ");
INSERT INTO zawNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Narä abahuiä lojni, ni'cni rniliä: “Dee ni najc Xi'n Dios.” ");
INSERT INTO zawNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Che bara stee yääl, sugasac Juan ro'c, suganäjni tio'p rexpejṉni. ");
INSERT INTO zawNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Bahuiini lo Jesús che sasajni, dxejc gunii Juan, räjpni: ―¡Coḻhuii! ¡Laa dee ni najc Xiil xten Dios! ");
INSERT INTO zawNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Biejn diajg guiro'p rexpejṉpac Juan diidxga, dxejc sanajlreni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Che gubiré Jesús bahuiini siädnajlreni, dxejc räjpni: ―¿Xhi caguiiltu? Räjp rebejṉga: ―Mastr, ¿caro rbäjzlu? ");
INSERT INTO zawNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Badzu' Jesús diidxre, räjpni: ―Coḻtaa, te fiitu. Dxejcti huijreni te bahuiireni caro rbäjzni ro'c. Biannäjrenini ro'c sa'csi agojl si'cti rcatajp gudxej. ");
INSERT INTO zawNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tej reni biejn diajgni xtidx Juan laa Andrés, bejtz Simón Pedr dxejc huinäjḻni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ganiddoo huitiilni bejtzni, dxejc räjpni lojni: ―Abidxälnu Mesías nani sälojza Crist ni cabääznu jiääd. ");
INSERT INTO zawNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Sas huinänini loj Jesús. Che bahuii Jesús lojni, räjpni: ―Luj najclu Simón xi'n Jonás; sirilajlu Cefas nani sälojza Pedr. ");
INSERT INTO zawNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Bara yäälga rlajz Jesús chää nez Galilee. Dxejc bidxaagni Felipe, räjpni lojni: ―Gudanajl narä. ");
INSERT INTO zawNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe siääd guedx Betsaida, guedxro ni najcza lajdx Andrés näjza Pedr. ");
INSERT INTO zawNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe bidxaag Natanael räjpni lojni: ―Abidxälnu bejṉ nani bacuaa toMoisés xcuentni lo reguijtz xten leii agujc xchej, nani bazä'tza reniguii ni gunii xtidx Dios, Jesús xi'n José ni siääd Nazare't. ");
INSERT INTO zawNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Räjp Natanael: ―¿La sajc guirii te beṉsa'c guedx Nazare't, ä? Räjp Felipe lojni: ―Gudaa, te fiilu. ");
INSERT INTO zawNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Che bahuii Jesús siääd Natanael nez lojni, räjpni: ―Coḻhuii te beṉ Israelpac nani dipacni gusguee. ");
INSERT INTO zawNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Räjp Natanael: ―¿Xho numbeelu narä? Badzu' Jesús diidxre lojni räjpni: ―Che gajd Felipe cueedx luj, che suga'lilu ni' te yagiigw, bahuiä lojlu. ");
INSERT INTO zawNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Badzu' Natanael diidxre, räjpni: ―Mastr, luj najc Xi'n Dios, luj najc Reii xten rexpeṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Räjp Jesús lojni: ―Sa'csi rniä lojlu, “bahuiä suga'lu ni' yagiigw”, ¿ni'c rililajzlu, ä? Xhidajl cosroru suhuiilu. ");
INSERT INTO zawNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Dxejcti räjpzani: ―Rniliä́pac lojtu, suhuiitu guixal xhaguibaa, näjza rä'p riäjt rexangl Dios yejc Xi'n Dios ni gujc Niguii. ");
INSERT INTO zawNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Che gudejd choṉ dxej, guyu' te sa' guedx Caná xten Galilee. Ro'c guyu' xnan Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Huijza Jesús näjza rexpejṉpacni, sa'csi bidoṉreni chääreni lo sa'ga. ");
INSERT INTO zawNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Gubijdz bin. Dxejc räjp xnan Jesús lojni: ―Dirureni ga'p bin. ");
INSERT INTO zawNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Dxejc badzu' Jesús diidxre räjpni: ―¿Xhicuent rniilu si'c loä, xnanä? Gajd xhoṟä guidzujṉ. ");
INSERT INTO zawNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Niluxh räjp xnanni loj remos ni tre' ro'c: ―Coḻyejn guira'ti si'ctis ni guiniini lojtu. ");
INSERT INTO zawNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Suga' xho'p guesguij nani rdxaj nis te rdiib ṉaa rexpejṉ Israel te racnayareni te si'c guisa' xleii toMoisés. Neṉ tejga guesguijga ru' si'cti te gayuu litr nis. ");
INSERT INTO zawNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Räjp Jesús loj remos: ―Coḻguchaj reguesguijre nis. Dxejcti bachadoo rebejṉgani. ");
INSERT INTO zawNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Dxejcti räjp Jesús lojreni: ―Coḻca' che'nni ṉaj te coḻchanäni lo nani cahuii cayajc sa're. Dxejc huinä remosga che'n bin lojni. ");
INSERT INTO zawNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Che gu' dade'ga che'n nis ni gubixhloj bin (luxh dini gan caro siäädni, remostis ni gulä'p nis, ni'ctis najn). Dxejcti gurejdx dade'ga bi'n. ");
INSERT INTO zawNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Dxejcti räjpni: ―Guiraa rebejṉ rudeedreni binsa'c räxgaa rebejṉ, dxejcti che agudxaj xque'reni, rudeedreni bin nani di xcuent, niluxh luj gulucheelu binsa'cre ṉajli. ");
INSERT INTO zawNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Seenre najc ganiddoo ni gusloj bejn Jesús; bejnnini neṉ guedx Caná xten Galilee. Seenga bazäbdiidx yäḻrnibee xtenni luxh ni'cni huililajz rexpejṉpacni xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Che gudejd sa'ga, huijni guedx Capernaum con xnanni, rebejtzni näjza rexpejṉpacni. Ro'c bia'nreni tio'p-choṉ dxej. ");
INSERT INTO zawNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Sa'csi abidzuṉgajxh lanij pascw xten rexpejṉ Israel cheni rnalajzreni guxhijṉ ni gudejd guixhajg xten yäḻgujt neṉ Egipto, ni'c sää Jesús guedx Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Neṉ guidoro bidxälni xhidajl bejṉ nani ruto' gon, xiil, palom näjza reni sobga' caguchaa melzijt. ");
INSERT INTO zawNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Dxejc bejnni te chico't con gaii duu, gulääni regon con rexiil neṉ guidoo. Batie'chni xcoobr rebejṉ nani ruchaa melzijt, barexh-xhätni rexmexreni. ");
INSERT INTO zawNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Räjpzani loj reni caguto' repalom: ―Coḻcuää redee, na'c rujntu rolijz xtadä si'c te guii cadro rdo' guiraloj. ");
INSERT INTO zawNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Dxejcti banajlajz rexpejṉpacni xhi caj lo reguijtz ni bacuaa redade' ni gunii xtidx Dios: “Gucnaj lazä xcuent ni runnäjreni rolijzlu.” ");
INSERT INTO zawNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Dxejcti gunabdiidx reni najc xpejṉ Israel lojni, räjpreni: ―¿Xhi seen guluiilu loonu ṉaj te fiinu arajplu yäḻrnibee te abejnlu recosre? ");
INSERT INTO zawNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Badzu' Jesús diidxre räjpni: ―Coḻgutzujl guidoore, luxh narä neṉ choṉtis dxej sunchesacäni. ");
INSERT INTO zawNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Räjp rexpejṉ Israel lojni: ―Tiubixho'p ijz guclaa ni guc-chee guidoore, ¿xhixh sajc gunchesacluni neṉ choṉtis dxej, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Niluxh laani caniini xcuent guidoo ni najc lagajc tiejxhni. ");
INSERT INTO zawNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ni'cni cheni gubaṉsacni loj rebeṉgut, banajlajz rexpejṉpacni rediidxre ni guniini, dxejc huililajzreni nani caj lo rexquijtz Dios näjza rediidx ni gunii Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Cheni guyu' Jesús guedx Jerusalén cadro cayajc lanij pascw, laḻ ni cayajc lanijga, xhidajl rebejṉ huililajz xtiidxni, bahuiizareni remilagwr ni bejnni. ");
INSERT INTO zawNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Luxh di Jesús nililajz xtidx rebejṉga, sa'csi arumbeeni xho najc rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Niluxh dini niquiin chu gäb lojni xho najc bejṉ, sa'csi lagajc laani anancheeni xho najc lastoo tejga bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Guyu' te niguii lo rexpejṉ refarisee ni laa Nicodem̲, najcni te beṉroru loj reni rnibee rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Te guxhijṉ biädxhiga'tzni nez loj Jesús, räjpni lojni: ―Mastr, nadonnu lo Dios siäädlu si'c te ni ruluii, sa'csi rut rajcdi rujn sa' remilagwr nani rujnlu palga di Dios sunäjni. ");
INSERT INTO zawNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Dxejcti räjp Jesús lojni: ―Rniliä́pac lojlu, nani di gaal stehuält, di gacdi fiini xcäḻrnibee Dios xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Dxejcti räjp Nicodem̲ lojni: ―¿Xho gac gaal te bejṉ stehuält niluxh anajcni beṉgool? ¿Xhixh sajc chusacni xque' xnanni stehuält te galsacni, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Badzu' Jesús diidxre räjpni: ―Rniliä́pac lojlu, nani di gaal con nis, näjza con Sprit Dxan xten Dios, di gacdi jiu'ni lo xcäḻrnibee Dios xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nani rajl xi'n beṉ guedxliujre, ni'c najctisni bejṉ guedxliuj, luxh nani rajl por Sprit Dxan xten Dios, Spritza najcni. ");
INSERT INTO zawNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Na'c rdxelojlu sa'csi rniä: “Nanabpac gaallu stehuält.” ");
INSERT INTO zawNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Rbi' bej cadrotis rlajzni; riejn diajglu rubejni niluxh dilu gan caro siäädni, dizalu gan caro sääni. Si'cza rebejṉ guedxliuj direni gan xho rajl rexpejṉ Dios stehuält con Sprit Dxan xten Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Badzu' Nicodem̲ diidxre, räjpni: ―¿Xho mood sajc gac recosre? ");
INSERT INTO zawNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Räjp Jesús lojni: ―¿La najclu te mastr xten rexpejṉ Israel luxh dilu gan recosre, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Rniliä́pac lojlu, aguniinu xcuent recos ni nadonnu, abasule'nu recos ni abahuiloonu, niluxh la'tu ditu nililajz xtiidxnu. ");
INSERT INTO zawNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Palga ditu chalilajz xtiidxnu che guniinu xcuent recos guedxliuj nani rniinu: ¿Xho chalilajztu xtiidxnu palga guiniinu xcuent recos xhaguibaa? ");
INSERT INTO zawNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Rut chutejdi ahuä'p xhaguibaa, xtebtis nani biäjt xhaguibaa, lagajc Xi'n Dios ni gujc Niguii. ");
INSERT INTO zawNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Lagajc si'cni guläsjiaa toMoisés bäḻ guiib lo yajg neṉ reyubijdz, sigajcza nanab chäs Xi'n Dios ni gujc Niguii jiaa; ");
INSERT INTO zawNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","te guiraa renani chalilajz xtiidxni direni nit lo Dios, sica'reni yäḻnabajṉ par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Sa'csi huinälazduxh Dios rebejṉ guedxliuj, ni'cni badeedni biääd Xinxtebni lo guedxliuj, te guiraa renani chalilajz xtiidxni direni nit lo Dios, sa'csi sajpreni yäḻnabajṉ par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Sa'csi di Dios nuxhaḻ xi'nni te gusnijtni rebejṉ guedxliuj, alga baxhaḻnini te ḻaa rebejṉ neṉ xtojḻreni xcuentni. ");
INSERT INTO zawNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Nani chalilajz xtiidxni näjza chalilajz najcni chu najni najcni dini nit, luxh nani di chalilajz xtiidxni agunijtni sa'csi dini nililajz xtidx Xinxteb Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ni'cni dee najc yäḻnijtga: abiääd bianijga loj guedxliuj, biädnä Xi'n Diosni, niluxh rebejṉ guedxliuj bidxaglajzrureni yäḻnacäjy cadro tre'reni, gulälazreni bianijga sa'csi xhet laadi najc xtzuunreni. ");
INSERT INTO zawNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Guiraa reni rujn dzunguijdx, rbälaz bianijga, dizareni guibig loj bianijga, didi guluiloj bianijga rextzunguijdxreni. ");
INSERT INTO zawNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Luxh reni rusoob didxlii, rbigreni loj bianijga, te bianijga ruluiloj najc rextzuunreni redzunsa'c xten Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Dxejcti biääd Jesús näjza rexpejṉpacni nez lo reyuj xten Judea. Ro'c guyunäjnireni, batiobnisza rexpejṉpacni rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan ni Rutiobnis cagutiobniszani bejṉ te lajt ni laa Enón ni tre' gajxh Salim, sa'csi ro'c yu' sijl nis. Ro'c sää rebejṉ lojni te cagutiobnisnireni. ");
INSERT INTO zawNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Dxejc gajdreni gusäu Juan neṉ latzguiib. ");
INSERT INTO zawNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Dxejcti gusloj rexpejṉ Juan cayujy diidx con gaii xpejṉ Israel xcuent yäḻrdiib ṉaareni ni najc xcostumbr rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Dxejc biäädreni lo Juan, räjpreni: ―Mastr, dade' nani guyunäjlu stelaad gueu Jordán, nani basule'lu xcuentni, adade'ga cagutiobnis, luxh guiraa rebejṉ asää lojni. ");
INSERT INTO zawNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Dxejc badzu' Juan diidxre, räjpni lojreni: ―Nicla tej bejṉ digacdi ga'p te xhi cos palga di Dios gudeedni lojni. ");
INSERT INTO zawNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Lagajc la'tu nancheetu guniliä: “Dina gacä Crist ni cabäjztu jiääd.” Guniäza: “Narä nacä nani biädnijd lojni.” ");
INSERT INTO zawNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Che rajc sa', nani sobganäj dxa'p, ni'c najc bi'n ni gac chäälni, luxh xamigw bi'n nani suga' ro'c, riejn diajgni rniini, rbalazduxhni sa'csi riejn diajgni xse' bi'n. Sigajcza abibaduxh lazä xcuentni. ");
INSERT INTO zawNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nanab gacni laani beṉroru, beṉsajcru, biädla narä riajḻ gacä beṉhuinru, ni guxiiru sajc lojni. ");
INSERT INTO zawNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Nani siääd jiaali, ni'c rnibee guiralii, niluxh nani najc beṉ guedxliuj ni'c rnii xcuent recos guedxliuj. Nani siääd xhaguibaa ni'c rnibee guiralii. ");
INSERT INTO zawNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nani bahuiini, nani biejn diajgni, ni'c rusule'ni niluxh guxii rililajzreni xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nani rililajz diidx ni rusule'ni, bejṉga ruluiloj guliipac najc xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nani baxhaḻ Dios, ni'c rnii xtidx Dios sa'csi che rudeed Dios Sprit xtenni, dini gudeed guxiini. ");
INSERT INTO zawNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dad Dios sanälajzni xingaanni, abadeedzani guiraliiti chu ladzṉaani. ");
INSERT INTO zawNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nani rililajz xtidx xingaanni arajp yäḻnabajṉ par tejpas, luxh ni di chalilajz xtidx xi'nni, dini fii yäḻnabajṉ, siääd xcäḻrdxe'ch Dios yejcni, sujn Dios castiigwni. ");
INSERT INTO zawNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Che gucbee Jesús abiejn diajg refarisee xhidajlru bejṉ sanajl Jesús luxh guxiiru sanajlreni Juan, luxh cagutiobnisreni, ");
INSERT INTO zawNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(niluxh xhet Jesúsdi cagutiobnis. Rexpejṉni ni catiobnis), dxejc ");
INSERT INTO zawNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","biriini Judea gubisacni nez Galilee. ");
INSERT INTO zawNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Laḻ ni sasajni, nanab tedni nez Samaria. ");
INSERT INTO zawNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ni'c bidzujṉni te guedxro xten Samaria ni laa Sicar, gajxh nejz loj te la' yuj ni badeed toJacoob lo xi'nni toJosé. ");
INSERT INTO zawNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ro'c sojb te bisie ni rniireni “xpisie Jacoob”. Sa'csi abadxajg Jesús siädsajni, gurejni ro bisiega. Agojl läidxej. ");
INSERT INTO zawNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Bidzujṉ te gunaa siädlä'pni nis, dxejc räjp Jesús lojni: ―Baniidx che'n nis yä'ä. ");
INSERT INTO zawNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Sa'csi rexpejṉpacni asääreni guejdxga sasiireni xhi gaureni. ");
INSERT INTO zawNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Räjpti guna samaritaṉga lo Jesús: ―¿Xho mood rniablu nis loä, luj ni najc te beṉ Israel luxh narä nacä gunaa samaritaṉ? (Sa'csi di rexpejṉ Israel chanä sa'reni rebejṉ Samaria.) ");
INSERT INTO zawNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Räjp Jesús lojni: ―Paru najnlu xhini'c najc yäḻrulaslajz xten Dios, paru numbeelu chuni'c canab nis lojlu, luj siniablu lojni te laani guniidxni nisnabajṉ lojlu. ");
INSERT INTO zawNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Räjpti gunaaga lojni: ―Dad, xhet ca'dilu te guiliä'plu nis, luxh bisiere najc jiätduxh. ¿Caxh chaca'lu nisnabajṉga, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿La beṉrorulu lo toxtadgoldoonu Jacoob ni basa'n bisiere cadro huä'p nis gu'ni, gu'za rexi'nni, näjza rexquidxaani, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Badzu' Jesús diidxre lojni, räjpni: ―Guiraa reni rä' nis bisiere, siojlreni stehuält. ");
INSERT INTO zawNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Luxh nani yä nis nani gudedä, diruni jiojḻ, sa'csi nis nani gudedä neṉ lastooni sajcni si'c te bisie nani rdatis nisni te gudeedni yäḻnabajṉ par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Dxejcti räjp gunaaga lojni: ―Dad, baniidx nisga yä'ä, te na'cru jioḻä, te na'cruza guibi'ä jiädlä'pä nis ree. ");
INSERT INTO zawNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Räjp Jesús: ―Huij, huitejdx chäälu gudanäni ree. ");
INSERT INTO zawNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Räjp gunaa loj Jesús: ―Ruti chälä. Räjp Jesús lojni: ―Laaca guniilu, ");
INSERT INTO zawNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","sa'csi aguyu' gaiili chäällu. Luxh nani rbäznäjlu ṉaj dini gac chäällu; guliica najlu. ");
INSERT INTO zawNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Che biejn diajg gunaaga si'c, räjpni: ―Dad, rchaloä najclu te niguii ni rnii xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Retoxtadgoldoonu gojṉreni Dios lo dajnre, luxh la'tu rniitu guedx Jerusalén najc cadro nanab ganni Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Räjp Jesús lojni: ―Gunaa, huililajz xtidxä, sidzujṉ oṟ cheni nicla lo dajnre, niclaza guedx Jerusalén ditu chagajṉ Dad Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","La'tu rajṉtu Dios nani ditu gumbee, nuunu rajṉnu Dios nani rumbeenu; sa'csi yäḻrusḻaa bejṉ lo dojḻ siääd xcuent rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Niluxh sidzujṉ oṟ, luxh alabidzujṉni, che reni guliipac rajṉ Dad, reni'c neṉ lastooreni, lo xcäriejnreni sajṉreni Dios. Sa'csi sa' bejṉre rguiil Dad Dios te gaṉrenini. ");
INSERT INTO zawNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios najc te Sprit. Reni rajṉ Dios nanab gaṉrenini neṉ lastooreni, lo xcäriejnreni, guideb xtijpreni sa'csi rumbeerenini. ");
INSERT INTO zawNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Räjp gunaa lojni: ―Ananä siääd Mesías ni laaza Crist. Cheni jiäädni, laani susule'ni guiraliiti loonu. ");
INSERT INTO zawNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Räjp Jesús lojni: ―Narä ni caniä lojlu, nacä laani. ");
INSERT INTO zawNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Dxejc bidzujṉ rexpejṉpacni, bidxelojreni sa'csi gunii Jesús lo gunaaga, niluxh rut gunabdiidxdi xhi rlajzni, niclaza rut gunabdiidxdi xhini'c caninäjni gunaaga. ");
INSERT INTO zawNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Dxejcti basa'n gunaaga xtie'ni, sä'tini guedxroga. Dxejcti räjpni loj rebejṉ: ");
INSERT INTO zawNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Coḻtaa, fiitu te niguii ni gunii loä guira'ti nani abenä. ¿La et laadi dee Crist ni cabääznu jiääd, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Dxejc birii rebejṉguejdxga, bidzujṉtireni lojni. ");
INSERT INTO zawNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Reni najc rexpejṉpacni canabduxhreni gau Jesús, räjpreni: ―Mastr, gudajw. ");
INSERT INTO zawNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Laani räjpni: ―Narä rapä xhi gauä nani ditu gumbee. ");
INSERT INTO zawNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Dxejcti räjp rexpejṉpacni lo sa'reni: ―¿Xhaa yu' chu abiädnä xhi gudajwni, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Räjp Jesús: ―Yäḻrajw xtenä najc gunä si'cni rlajz nani baxhaḻ narä, näj guluxä xtzuunni. ");
INSERT INTO zawNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","La'tu rniitu riäädx tajp bäii te guire' cose'ch. Narä rniä coḻguiliäs lojtu, coḻfisa'c loniaa, abiquijtz regäjḻ, agojḻ guire' cose'ch. ");
INSERT INTO zawNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nani rujn dzuun rutie' cose'ch rca'ni xcuentni, luxh ni caca'ni najc par yäḻnabajṉ par tejpas, te tejsi guibalaznäj nani gule'c binij näj nani batie' cose'ch. ");
INSERT INTO zawNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Sa'csi gulii najc diidx nani rnii bejṉ, rniireni: “Tejni rbe'c binij, ste'cani rutie'ni.” ");
INSERT INTO zawNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Narä abaxhaḻä la'tu gutie'tu cose'ch nani ditu nibe'c; ste'ca najc nani bejn dzuun gule'cni binij, dxejc la'tu jiu'tu gutie'tu cose'ch loj xtzuunni. ");
INSERT INTO zawNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Xhidajl rebeṉ Samaria huililajz xtidx Jesús xcuent rediidx ni räjp gunaaga lojreni che räjpni: “Guniini loä guiralii nani abenä.” ");
INSERT INTO zawNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ni'cni, che biääd rebeṉ guedx Samaria lojni gunabreni loj Jesús jia'nni lajdxreni. Dxejc bia'nni ro'c tio'p dxej. ");
INSERT INTO zawNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Dxejc xhidajlrureni huililajz xtiidxni ni guniini lojpacreni. ");
INSERT INTO zawNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Dxejcti räjpreni loj gunaaga: ―Dirunu chalilajz ganaxtis xcuent diidx ni guniilu loonu, sa'csi lagajc nuure abiejn diajgnu xtiidxni, ni'c nancheenu dee najcpac ni rusḻaa rebejṉ guedxliuj loj dojḻ. Laani najc Crist ni cabääznu jiääd. ");
INSERT INTO zawNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Che gudejd tio'p dxej, biriini guedx Samaria, huinuuni xnezyujni nez Galilee. ");
INSERT INTO zawNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Sa'csi lagajc Jesús gunii, räjpni: Te bejṉ nani rnii xtidx Dios di rebeṉ lajdxpacni chanälajz xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Che bidzujṉni rexyuj Galilee, rebeṉ Galilee huichaglojrenini sa'csi näj laareni huijreni lanij pascw guedx Jerusalén, ro'c bahuiireni guiraa redzuun nani bejnni. ");
INSERT INTO zawNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Gubisacni, bidzujṉni guedx Caná xten Galilee cadro bejnni bidxaa nis gujcni bin. Dxejcti guyu' te dade' nani rujn xtzuun ṟeii. Guedx Capernaum naga' te xi'nni cayacxhuu. ");
INSERT INTO zawNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Che biejn diajg dade'ga abirii Jesús Judea, abidzujṉni nez Galilee, huijni lo Jesús, gunabduxhni lojni chääni te gusiajcni xi'nni nani naga' cuentro, ameerli guetni. ");
INSERT INTO zawNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Dxejcti räjp Jesús lojni: ―Paru ditu fii reseen, remilagwr, ditu chalilajz chuni'c nacä narä. ");
INSERT INTO zawNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Dade' ni rujn xtzuun ṟeii, gunii lojni, räjpni: ―Do'o Dad, te di guet xi'nä. ");
INSERT INTO zawNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Räjp Jesús lojni: ―Huij. Di xi'nlu guet. Huililajz dade'ga, sä'tini. ");
INSERT INTO zawNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Che gubi'ni rolijzni, birii rexmosni, huichaglojni, badeedreni diidx nabajṉ xi'nni. ");
INSERT INTO zawNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Dxejcti gunabdiidxni: ―¿Coṟti gusloj cayajcni? Räjpreni lojni: ―Naii si'cti rcatej gudxej biriini xliaa. ");
INSERT INTO zawNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Dxejcti gucbee dade'ga lagajc oṟga ni räjp Jesús lojni: “Di xi'nlu guet.” Dxejc dade'ga näjza guiraa rebejṉ ni yu' rolijzni huililajzreni Jesús najc ni cabäjzreni jiääd. ");
INSERT INTO zawNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Dee barojp seen ni bejn Jesús cheni biriini Judea, biu'ni Galilee. ");
INSERT INTO zawNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Che gujcti recosre, guyu' te lanij xten rexpejṉ Israel, dxejc huij Jesús guedx Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Guedx Jerusalén, gajxh ro' puert ni laa xten rexiil, yu' te guipilro nis; xtidx hebreo laani Betesda. Cuä' guipilroga caj gaii cordoor. ");
INSERT INTO zawNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ro'c naga' xhidajl bejṉ racxhuu, yu' bejṉ ni di fii, beṉcoj, näj bejṉ nani bixu'n tiejxhni. Cabäjzreni guiniib nisga ");
INSERT INTO zawNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","sa'csi gucti-guc riääd te xangl Dios rusniib nisga. Dxejc bejṉ nani gun gaan chachu' lo nis ganiddoo che guiniibni, riajcni lo xhitis yäḻguijdx ni rajcni. ");
INSERT INTO zawNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ro'c guyu' te beṉ racxhuu nani agujc gaḻbitzubixhujṉ ijz cayacxhuuni. ");
INSERT INTO zawNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Cheni bahuii Jesús naga'ni, badeedzani cuent lacti xchero raxchuuni, räjpni lojni: ―¿La rlajzlu jiajclu? ");
INSERT INTO zawNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","―Dad ―räjp beṉ racxhuuga lojni―, dina gapä chu gusäḻ narä neṉ nis cheni rniib nisre. Cheni rlazä chachu'ä lo nis, stee bejṉ rujn gaan narä, ganidni richu'ni lo nisga. ");
INSERT INTO zawNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Räjp Jesús lojni: ―Huistie, guläs xta'lu, guzaj, huij. ");
INSERT INTO zawNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Lagajc dxejc biajc bejṉga, guläsni xta'ni, gusloj gusajni. Niluxh dxejga najc dxej nani rusilajz rexpejṉ Israel, ");
INSERT INTO zawNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ni'c räjp rexpejṉ Israel lo bejṉ ni biajcga: ―Nadxej najc dxej ni rusilajz bejṉ. Di gacdi guulu xta'lu. ");
INSERT INTO zawNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Laani räjpni: ―Nani basiajc narä, laani naj loä: “Guläs xta'lu, gusaj.” ");
INSERT INTO zawNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Dxejc gunabdiidxreni lojni: ―¿Chuni'c naj lojlu “Guläs xta'lu, gusaj”? ");
INSERT INTO zawNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Dxejcti beṉ racxhuu ni biajcga dini gaan, sa'csi gunitloj Jesús, biriini ro'c laḻ ni tre' xhidajl bejṉ lajtga. ");
INSERT INTO zawNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Che bidxaagni Jesús stehuält neṉ guidoro, räjp Jesús lojni: ―Ahuii, ṉaj ni abiajclu, na'c gunlu dojḻ stehuält, didi sajclu xhi stee ni najc cuentroru. ");
INSERT INTO zawNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Sä'ti bejṉga, huiye'tzni loj rexpejṉ Israel laa Jesús ni basiajcni. ");
INSERT INTO zawNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ni'cni gusloj rexpejṉ Israel carinajlreni Jesús, rlajzreni guiga'ni te ju'trenini, sa'csi rujnni redzuunga dxej ni rusilajzreni. ");
INSERT INTO zawNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Luxh räjp Jesús lojreni: ―Xtadä Dios ṉajli cayujnni dzuun, ni'cni näjza narä cayunä dzuun. ");
INSERT INTO zawNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ni'cni rlajzru rexpejṉ Israel ju'tni, xhet ganaxdi sa'csi rujnni dzuun dxej ni rusilajzreni, per näjza sa'csi räjpni Dios najc Xtadni, rniizani tebloj najcni con Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Badzu' Jesús diidxre räjpni lojreni: ―Rniliä, rniliä́pac lojtu. Di gacdi gun Xi'n Dios dzuun xtebni, palga dini fixgaa rujn Xtadni dzuunga, sa'csi guira'tis dzuun ni rujn Xtadni, dzuunga rujnza Xi'nni sigajc rujn Xtadni. ");
INSERT INTO zawNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Sa'csi rinälajz Dad xi'nni, ruluiini lo xi'nni guiraa redzuun nani rujnni, luxh dzunroruza suluiini lojni gunni, te guidxelojtu. ");
INSERT INTO zawNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Sigajc ni rliäs Dios rebeṉgut, rudeedni yäḻnabajṉ lojreni, sigajcza sudeed xi'nni yäḻnabajṉ lo renani rlajztisni. ");
INSERT INTO zawNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nicla Dad di gun yäḻguxhtis, alga badeedni guiralii yäḻguxhtis gun Xi'nni, ");
INSERT INTO zawNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","te guiraa bejṉ guiliä'p xpala'n xi'nni si'cni rliä'preni xpala'n Dad. Nani di guiliä'p xpala'n Xi'nni, dizani guiliä'p xpala'n Xtadni ni baxhaḻni biäädni. ");
INSERT INTO zawNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Rniliä, rniliä́pac lojtu, nani rucuadiajg xtidxä, ni chalilajzzani nani baxhaḻ narä, ni'c rajpni yäḻnabajṉ par tejpas; niluxh dini ted lo yäḻguxhtis, alga abiriini lo yäḻgujt, agudejdni lo yäḻnabajṉ. ");
INSERT INTO zawNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Rniliä, rniliä́pac, sidzujṉ oṟ, luxh alabidzujṉni, cheni siejn diajg rebeṉgut xse' Xi'n Dios, luxh reni riejn diajgni diidxga sibaṉsacreni lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Si'cni rajp Dad Dios yäḻnabajṉ lagajcsi laani, sigajcza badeedni lo Xi'nni ga'pni yäḻnabajṉ lagajcsi laazani. ");
INSERT INTO zawNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Badeedzani lojni yäḻrnibee te gunni yäḻguxhtis, sa'csi najcni Xi'n Dios ni gujc Niguii. ");
INSERT INTO zawNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Na'c rdxelojtu rediidxre, sa'csi sidzujṉ oṟ cheni guiraa reni yu' neṉ baa siejn diajgreni xse'ni ");
INSERT INTO zawNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","siriizareni neṉ baa. Reni bejn dzunsa'c siriireni te guibaṉsacreni loj yäḻnabaṉsa'c, niluxh reni bejn dzunguijdx, siriireni te guibaṉsacreni te tedreni lo xcäḻguxhtis Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Xhet rajcdi runä lagajcsi narä. Sigajc ni riejn diagä, sigajcza runä yäḻguxhtis. Luxh yäḻguxhtis ni runä laaca najcni sa'csi dina quilä gunä nani rlazätis, rguilätis gunä si'c ni rlajz Dad nani baxhaḻ narä. ");
INSERT INTO zawNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Palga narätis rniä diidx lagajc xcuentä, xhet sajcdi diidxga. ");
INSERT INTO zawNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Yu' stee nani rnilii diidx xcuentä, luxh nancheä diidx ni rniini xcuentä sacduxhni, guliipacni. ");
INSERT INTO zawNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","La'tu abaxhaḻtu chu huij loj Juan, huinabdiidxreni lojni “chu najc bejṉga”, niluxh badzu'ni diidx lojreni guniini diidx guliipac xcuent chu nacä. ");
INSERT INTO zawNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Narä dina jiuä diidx nani rnii rebejṉ xcuentä luxh canisacä rediidxre te ḻaatu lo xtojḻtu. ");
INSERT INTO zawNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan gujc si'c te bajl ni ralguij, basanijzani. Luxh la'tu huihuiituni bibalajztu lo xpianijni balsi dxej. ");
INSERT INTO zawNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Luxh narä rapä xhi ruluilojru chu nacä lo diidx ni gunii Juan; sa'csi lagajc dzuun nani baniidx Xtadä gunä, lagajc redzuun ni runä, huenliisi ruluilojreni Xtadä Dios baxhaḻ narä. ");
INSERT INTO zawNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Xtadä ni baxhaḻ narä lojtu agunilii chu nacä. Gajdpactu jiejn diajg xse'ni, gajdzatu fii lojni. ");
INSERT INTO zawNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Dizatu ga'p xtiidxni neṉ lastootu, sa'csi di lajztu chalii xtiidx nani baxhaḻ narä. ");
INSERT INTO zawNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","La'tu roḻduxhtu reguijtz xten Dios sa'csi rchalotu si'c sidxältu yäḻnabajṉ par tejpas, luxh lagajc reguijtzga rusule' chu narä. ");
INSERT INTO zawNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Naadditu jiäädtu loä te ga'ptu yäḻnabajṉ par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Narä dina quilä chu bejṉ guiliä'p xpala'nä nez loä. ");
INSERT INTO zawNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Luxh narä anumbeätu, ananä ditu chanälajz Dios neṉ lastootu. ");
INSERT INTO zawNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Narä biälä xcuent Xtadä, luxh ditu gucuadiajg xtidxä; paru jiääd chu stee bejṉ xcuentcani, ni'c sii sucuadiajgtu xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Xho gac chalilajztu, ni rliä'ptu xpala'n lagajc sa'tu. Ditu quiil xho gac guiliä'p Gueb Dios xpala'ntu. ");
INSERT INTO zawNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Di naatu pet narä ni chale'cä xquejtu lo Xtadä. ToMoisés ni chale'c xquejtu, luxh rujntu xhigab lagajc xleiini gacnäj la'tu. ");
INSERT INTO zawNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Paru la'tu nililajzpactu xtidx toMoisés, dxejc niliiza lajztu xtidxä sa'csi xcuentä bacuaa toMoisés lo reguijtz. ");
INSERT INTO zawNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Palga ditu chalilajz nani bacuaani lo reguijtz, ¿xho chalilajztu rediidx nani caniä lojtu, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Che gulujx gujc recosre, dxejc sää Jesús stelaad nezro' nisdoo xten Galilee, nani rniizareni nisdoo xten Tiberias. ");
INSERT INTO zawNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Sanajl xhidajl bejṉni sa'csi rhuiireni remilagwr ni rujnni lo rebeṉracxhuu. ");
INSERT INTO zawNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Dxejcti huä'p Jesús yejc te dajn, ro'c gurenäjni rexpejṉpacni. ");
INSERT INTO zawNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Niluxh ameer gac lanij pascw xten rexpejṉ Israel, cheni rudeedreni xquixhtios lo Dios xcuent dxej ni biriireni Egipto. ");
INSERT INTO zawNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Cheni guläs Jesús lojni, bahuiini siääd xhidalduxh bejṉ, siäädreni nez lojni, dxejcti räjpni loj Felipe: ―¿Caro guisiinu yätxtiil te gau rebejṉre? ");
INSERT INTO zawNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Dxejc räjpzani si'c te don xhi xhigab gun Felipe, luxh laani anajnni xho gunni. ");
INSERT INTO zawNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Räjp Felipe lojni: ―Di tio'p gayuu beex yätxtiil gaḻ te gaureni tlagaj. ");
INSERT INTO zawNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tej rexpejṉpacni ni laa Andrés, bejtz Simón Pedr, räjp lojni: ");
INSERT INTO zawNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Ree suga' te biuux ca' gaii yätxtiil con tio'p bäjl, ¿xhixh sajl ni'c gau rebeṉ xhidajlre? ");
INSERT INTO zawNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Dxejcti räjp Jesús: ―Coḻyejtz loj rebejṉre cuereni. Yuduxh guixa' ro'c. Dxejcti gurej reniguii. Si'cti gaii miḻ najc reniguii. ");
INSERT INTO zawNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Dxejcti cua' Jesús yätxtiilga, badeedni xquixtios lo Dios, gudisni yätxtiilga lo rexpejṉpacni. Dxejcti rexpejṉpacni gudisrenini loj rebejṉ nani sobga'. Sigajcza gudisreni rebäjl si'ctisni rlajzreni gaureni. ");
INSERT INTO zawNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Che gulujx gudajwreni, gudxaj xque'reni, dxejcti räjp Jesús loj rexpejṉpacni: ―Coḻgutie' guiraa reyätxtilbiujy nani bia'n te xhet nitdi. ");
INSERT INTO zawNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Batie'tireni reyätxtilbiujy, guläsreni tzubitio'p dxijm̲ yätxtilbiujy nani bia'n lo gaii yätxtiilga nani gula' gudajwreni. ");
INSERT INTO zawNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Che bahuii rebejṉga reseen, remilagwr nani bejn Jesús, dxejc räjpreni: ―Guluiipacni, laa dee ni najc niguii ni rnii xtidx Dios nani cabääznu jiääd lo guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Sas che gucbee Jesús cayujnreni xhigab jiädnaazrenini te niujnreni gacni ṟeii te guinibeeni lojreni, biriini ro'c, xtebni gubisacni neṉ dajn. ");
INSERT INTO zawNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Che gojl guxhijṉ, bidzujṉ rexpejṉpacni lo nisdoo. ");
INSERT INTO zawNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Biu'reni neṉ te barcw te tedreni lo nisdoo nez guedx Capernaum. Abicäjy lo yuj niluxh gajd Jesús guibi' lojreni te chääni. ");
INSERT INTO zawNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Gusloj cayäjs nisdoo xcuent te beduxh nani cabi'. ");
INSERT INTO zawNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ni'cni che gusajreni si'cti gaii o xho'p kilómetro, bahuiireni siäddzuṉgajxh Jesús lo barcw, lo nisdoo siädsajni. Bidxebduxhreni. ");
INSERT INTO zawNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Luxh laani räjpni lojreni: ―Naräni. Na'c guidxejbtu. ");
INSERT INTO zawNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Dxejcru cuäjbreni biu'ni neṉ barcw. Dxejcti bidzuṉgajcreni stelaad lo yuj cadro sääreni. ");
INSERT INTO zawNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Che bara yääl, rebejṉ nani bia'n stelaad ro' nisdoo, bahuiireni asanä rexpejṉpacni barcwbäz nani suga' ro'c, niluxh di Jesús nij, xtebsireni sääreni. ");
INSERT INTO zawNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Luxh bidzuṉgajc sgaii barcw nani birii guedx Tiberias, te lajt ni tre' gajxh cadro gudajwreni yätxtiil che gulujx badeed Jesús xquixtios lo Dad. ");
INSERT INTO zawNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Che bahuii rebejṉ ruti Jesús ro'c, niclaza rexpejṉni, biu'reni neṉ rebarcw, sääreni guedx Capernaum satiilreni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Che bidxälreni Jesús stelaad ro' nisdoo, räjpreni lojni: ―Mastr, ¿guc bidzujṉlu ree? ");
INSERT INTO zawNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Badzu' Jesús diidxre, räjpni lojreni: ―Rniliä́, rniliä́pac lojtu, caguiiltu narä sa'csi gudajwtu, gudxaj xque'tu, et sa'csi bahuiiditu remilagwr nani benä. ");
INSERT INTO zawNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Na'c guntu dzuun ganax par yäḻrajw nani rnitloj. Coḻyejn dzuun par yäḻrajw nani di nitloj, ni runiidx yäḻnabajṉ par tejpas. Yaḻrajwre suniidx Xi'n Niguii, sa'csi loj rebejṉ baluii Xtadni, Diospac, laani najc Xi'npacni. ");
INSERT INTO zawNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Dxejcti räjpreni: ―¿Xhini'c jiennu te gac jienpacnu dzuun ni rlajz Dios? ");
INSERT INTO zawNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Räjp Jesús lojreni: ―Dee najc ni rlajz Dios guntu: chalilajztu xtidx narä, nani baxhaḻni. ");
INSERT INTO zawNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Räjpreni lojni: ―¿Xhi seen gunlu te guihuiinu xcäḻrnibeelu te cholilajznu xtiidxlu? ¿Xhi dzuun rujnlu? ");
INSERT INTO zawNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Retoxtadnu gudajwreni yätxtiil ni laa mana loj reyubijdz si'cni caj loj reguijtz: “Badeedni yätxtiil ni biajb xhaguibaa gudajwreni.” ");
INSERT INTO zawNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Räjpza Jesús: ―Rniliä́, rniliä́pac lojtu, xhet toMoisésdi ni badeed yätxtiil ni biajb xhaguibaa. Xtadä ni suniidx yätxtiil nani siäädpac xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sa'csi yätxtiil xten Dios najc bejṉ ni siääd xhaguibaa, niluxh laani rudeedni yäḻnabajṉ par tejpas loj rebeṉ guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Räjpreni: ―Dad, baniidx yätxtiilga loonu. ");
INSERT INTO zawNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Dxejcti räjp Jesús lojreni: ―Narä nacä yätxtiil xten yäḻnabajṉ nani riäjḻ jiääd; chutis ni jiääd loä diruni guiliaan, niluxh chutis ni rililajz xtidxä diruni jiojḻ par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aguniä lojtu, la'tu ditu chalilajz, luxh abahuiitu loä. ");
INSERT INTO zawNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Guiraa renani abaniidx Xtadä loä, siäädni loä, niluxh chutis ni jiääd loä dina cuälazäni. ");
INSERT INTO zawNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Sa'csi narä siälä xhaguibaali te gunä si'c ni rlajz Xtadä, xhet si'cdi ni rlazädi. ");
INSERT INTO zawNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Dee najc ni rlajz Xtadä nani baxhaḻ narä: na'c nit nicla tej renani baniidxni loä, te guspaṉsacä guiragajcreni che gaḻ dxej lult ni riäjḻ jiääd. ");
INSERT INTO zawNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Scree rlajz nani baxhaḻ narä: guiraa renani fii lo Xi'n Dios, näj chalilajzreni xtiidxni, xca'reni yäḻnabajṉ par tejpas niluxh narä suspaṉsacäreni che gaḻ dxej lult ni riäjḻ jiääd. ");
INSERT INTO zawNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Rediidxre bejn gusloj casiejy rexpejṉ Israel xcuent Jesús sa'csi räjpni: “Narä nacä yätxtiil ni biäjt xhaguibaa.” ");
INSERT INTO zawNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Dxejcti räjpreni: ―¿La et Jesúsdi, xi'n José dee, ä? Nuure numbeenu xtadni, xnanni, ¿xhoxh rniini xhaguibaa biäjtni? ");
INSERT INTO zawNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Dxejc räjp Jesús lojreni: ―Na'c rusieinäj sa'tu. ");
INSERT INTO zawNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Rut rajcdi riääd loä palga di Xtadä ni baxhaḻ narä jiädnäni loä, te guspaṉsacäni che gaḻ dxej lult ni riäjḻ jiääd. ");
INSERT INTO zawNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Loj reguijtz ni bacuaa redade' ni gunii xtidx Dios caj scree: “Suluii Dios guiraareni.” Ni'cni guiraa reni rucuadiajg xtidx Xtadä, reni rsieed lojni, reni'c ni jiääd loä. ");
INSERT INTO zawNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Dinä guiniä yu' chu abahuii lo Dios; tejtis ni abahuii lojni: nani baxhaḻ Dios, ni'ctis abahuii lojni. ");
INSERT INTO zawNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Rniliä lojtu che rniä: nani chalilajz xtidxä, ni'c rajp yäḻnabajṉ par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Narä nacä yätxtiil nani rudeed yäḻnabajṉ. ");
INSERT INTO zawNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Retoxtadtu gudajw mana ni bastejb Dios lo reyubijdz, dxejcti gujtzareni. ");
INSERT INTO zawNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Dee najc yätxtiil ni siääd xhaguibaa, te chutis ni gau yätxtiilga dini guet. ");
INSERT INTO zawNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Narä nacä yätxtilbajṉ ni siääd xhaguibaa. Palga yu' chu gau yätxtiilre, sibajṉni par tejpas. Yätxtiil nani runidxä narä te xca' rebeṉ guedxliuj yäḻnabajṉ najc lagajc bältiexhä. ");
INSERT INTO zawNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Dxejcti gusloj casiejy rexpejṉ Israel räjpreni: ―¿Xho gac guniidx dee bältiejxhni guidauunu, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Räjp Jesús: ―Rniliä́, rniliä́pac lojtu, palga ditu gau bältiejxh Xi'n Dios ni gujc Niguii, palga dizatu yä xtiejnni, digacdi ga'ptu yäḻnabajṉ. ");
INSERT INTO zawNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nani gau bältiexhä, nani yäza xtienä, ni'c rajp yäḻnabajṉ par tejpas, niluxh suspaṉsacäni che gaḻ redxej lult. ");
INSERT INTO zawNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Sa'csi bältiexhä najc te yäḻrausa'cpac, xtienä najcza te yäḻräsa'cpac. ");
INSERT INTO zawNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nani gau bältiexhä, nani yäza xtienä, ni'c yu'pac con narä, luxh narä yu'äza con laani. ");
INSERT INTO zawNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Xtadä ni baxhaḻ narä rajp yäḻnabajṉ par tejpas. Narä nabaṉä xcuent laani. Sigajcza nani rajw narä, sibajṉzani xcuent narä. ");
INSERT INTO zawNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Dee najc yätxtiil nani biääd xhaguibaali; dini gac si'c mana ni gudajw xtadtu dxejc empac gujtreni, sa'csi nani gau yätxtiilre sibajṉni par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Recosre baluii Jesús neṉ te guidobäz laḻ ni guyu'ni guedx Capernaum. ");
INSERT INTO zawNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Che biejn diajgreni si'c, xhidajl rexpejṉpacni räjp: ―Naganduxh najc rextiidxni. ¿Chu laa nani gac cuadiajgni? ");
INSERT INTO zawNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Dxejcti gucbee Jesús cagusiejyreni xcuent rediidxga, dxejc gunabdiidxni räjpni: ―¿La rusieed rediidxre la'tu, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Xhicha guntu paru fiitu chä'p Xi'n Dios ni gujc Niguii cadro guyu'ni galoo? ");
INSERT INTO zawNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Sprit xten Dios najc ni rudeed yäḻnabajṉ; bältiejxhni xhet rujndini gaan. Rediidx nani guniä lojtu najc didxlii xcuent recos xten Sprit, luxh rediidxga rudeed yäḻnabajṉ par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Luxh laḻtis yu' lojtu reni di chalilajz. Sa'csi Jesús nancheeni galooli chu reni'c di chalilajz, anajnzani chuni'c guto'ni, guteedni laani ladzṉaa rebeṉ dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Dxejcti räjpni: ―Ni'cni rniä lojtu, nicla tej rut sajcdi jiääd loä palga di Xtadä jiädnäni loä. ");
INSERT INTO zawNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Lagajc dxejc gusloj cabicaj xhidajl rebejṉ ni agujc xchej gusanäj Jesús, dirureni nisianäj Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Dxejcti räjp Jesús loj guidzubitio'p rexpejṉpacni: ―¿La nägajcza la'tu rlajztu jiitu, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Badzu' Simón Pedr diidxre, räjpni: ―Dad, ¿chuloj chonnu? Luj rajplu diidx ni rudeed yäḻnabajṉ par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nuure abiolilaaznu, anajnnu najclu Crist Xi'n Dios nani nabajṉ. ");
INSERT INTO zawNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Badzu' Jesús diidxre, räjpni: ―¿La et lagajc narädi guleä guitzubitio'ptu? Luxh tejtu najc beṉdxab. ");
INSERT INTO zawNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Diidxga guniini xcuent Judas Iscariote, xi'n Simón, sa'csi Judas najc ni guto'ni mase nadxaagni lo guitzubitio'p rexpejṉpac Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Che gujcti recosre, cansaj Jesús nez reyuj xten Galilee, di rlajzni jia'nni nez reguedx Judea sa'csi rlajz rebeṉ ro'c ju'tni. ");
INSERT INTO zawNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Luxh ameer gaḻ lanij xten cose'ch xten guidoguijd, te relanij xten rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ni'c räjp rebejtz Jesús lojni: ―Na'c jia'nlu ree. Huij Judea te näjza rexpejṉpaclu fii redzunro nani rujnlu. ");
INSERT INTO zawNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Sa'csi rut rujndi xtzuunni xhiga'tz palga rlajzni gacbee bejṉ xhi dzuun rujnni, te gumbee bejṉni. Palga rujnpaclu redzuunre, baluiini lo guiraa rebeṉ guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Guniireni si'c lojni sa'csi nicla rebejtzni di chalilajz xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Dxejcti räjp Jesús lojreni: ―Gajd xhoṟä guidzujṉ, niluxh par la'tu xhitis oṟ najc hueen. ");
INSERT INTO zawNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Di gacdi guidxe'ch rebeṉ guedxliuj lojtu, luxh rdxe'chreni loä sa'csi narä rniliä xcuentreni: dzunguijdx najc xtzuunreni. ");
INSERT INTO zawNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","La'tu coḻchäj lanij; narä dina cha'a lanijga sa'csi gajd xhoṟä gaḻ. ");
INSERT INTO zawNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Che gulujx guniini si'c lojreni bia'ntini nez Galilee. ");
INSERT INTO zawNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Dxejcti che asää rebejtzni lanij, dxejc näjza laani sääni lanij, luxh dini nusäbdiidx, si'c xhiga'tz sääni. ");
INSERT INTO zawNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Dxejcti caguiil rexpejṉ Israelni lo lanijga, räjpreni: ―¿Concha niguiiga? ");
INSERT INTO zawNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Lo rebejṉ xhidaalga yu' xhidajl bejṉ ni cagusiejyreni xcuentni. Yu'reni räjp: “Hueen najcni”, per sgaiireni räjp: “Dini gac hueen. Cagusgueeni rebeṉguejdx.” ");
INSERT INTO zawNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nicla tejreni xhet casäbdiidxdireni xhini'c caniireni. Direni guinii dip sa'csi rdxejbreni rexpejṉ Israel nani rnibee. ");
INSERT INTO zawNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Agurojl lanij, che biu' Jesús neṉ guidoro. Dxejcti gusloj caguluiini. ");
INSERT INTO zawNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Dxejcti rdxeloj rexpejṉ Israel nani rnibee, räjpreni: ―¿Xho najn dee guiraloj, niluxh dini nisieed xleii toMoisés? ");
INSERT INTO zawNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Badzu' Jesús diidxre, räjpni: ―Yäḻruluii nani caluiyä et xtenädini, xten nani baxhaḻ naräni. ");
INSERT INTO zawNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Palga yu' chu rlajz gun nani rlajz Dios, sacbeeni la xten Dios najc reyäḻruluii xtenä, o la lagajcsi narä rbää́ diidx ni caguluiä. ");
INSERT INTO zawNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nani rusule'ni diidx nani lagajc laani rbääni, ni'c rniini diidxga te guiliä'p rebejṉ xpala'nni, luxh nani rguiil chä'p xpala'n nani baxhaḻni, ni'c ni rnii didxlii, xheti yäḻrusguee neṉ lastooni. ");
INSERT INTO zawNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿La di toMoises nuniidx leii lojtu, ä? Niluxh nicla tejtu di gusoob xtidx leiiga. ¿Xhicuent rlajztu ju'ttu narä, pes? ");
INSERT INTO zawNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Badzu' rebeṉ xhidajlga diidxre, räjpreni: ―¡Xprit beṉdxab yu' lastoolu! ¿Chuni'c rlajz ju'tlu? ");
INSERT INTO zawNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Badzu' Jesús diidxre lojreni, räjpni: ―Tejtis dzuun benä con xcäḻrnibeä, dxejc guiraatu cadxelojtu sa'csi benäni dxej ni rusilajztu. ");
INSERT INTO zawNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ni'cni baniidx toMoisés lojtu yäḻru'tu bee, luxh etlaadini guläxtiejnini, agac guläxtiej retoxtadgoldootuni. La'tu rusäḻtu bee rebiuux mase najcni dxej nani rusilajztu. ");
INSERT INTO zawNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mbaj pes, palga rajc rusäḻtu bee bejṉ te dxej nani rusilajztu didi nit xleii Moisés, ¿xhicuent rdxe'chtu loä sa'csi basiacäpac te bejṉ te dxej nani rusilajztu, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Na'c rujntu yäḻguxhtis si'ctis ni rlajztu. Coḻyejn yäḻguxhtis con yäḻguxhtis xten Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Dxejcti gusloj gaii bejṉ Jerusalén cayujn yäḻgunabdiidx, räjpreni: ―¿La etlaadi dee ni caguiilreni te ju'trenini, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ani asuga', caniini nez loj guiraa rebeṉguejdx, niluxh rut rudxojndini. ¿Xhaa ahuililajz reguxhtis, regubier laani najcpacni Crist, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Niluxh nuure nadoncheenu caro siääd niguiire, niluxh che jiääd Crist, rut gacbeedi caro siäädni. ");
INSERT INTO zawNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Caguluii Jesús neṉ guidoo che biejn diajgni rediidxre, dxejc dipduxh guniini, räjpni: ―La'tu numbeetu narä, najntu caro siälä; luxh dina niälä lagajcsi narä; nani baxhaḻ narä guliipac nabajṉni, luxh la'tu ditu gumbeeni. ");
INSERT INTO zawNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Luxh narä numbeäni, sa'csi lojni biriä, laani baxhaḻzani narä. ");
INSERT INTO zawNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Dxejc rlajzreni niniaazrenini, niluxh rut gunaazdini, sa'csi gajd xhoṟni gaḻ. ");
INSERT INTO zawNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Xhidajl bejṉ lo rebeṉ xhidajlga huililajz xtiidxni, dxejcti räjpreni: ―Cheni jiääd Crist, ¿xhixh sujnruni milagwr loj nani rujn dee, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Che biejn diajg refarisee xhi canii rebejṉ xcuent Jesús, laareni näjza rebixhojz nani rnibee lo rebixhojz baxhaḻreni guixhajg te guiniaazreni Jesús te jiäuuni. ");
INSERT INTO zawNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Sas räjp Jesús lojreni: ―Bale'si dxej su'ä lojtu, dxejcti guibi'ä loj nani baxhaḻ narä. ");
INSERT INTO zawNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Siguiiltu narä, niluxh ditu guidxäl narä, sa'csi cadro cha'ä digacdi jiäädtu. ");
INSERT INTO zawNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ni'c gunii rexpejṉ Israel lo sa'reni; räjpreni: ―¿Cacharo chääni ni'c di gacdi guidxälnuni? ¿Xhaa sijni loj rexpejṉ Israel nani nare'ch nez lajdx regriegos te guluiini regriegos? ");
INSERT INTO zawNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Xhi säloj diidxre nani guniini loonu: “Siguiiltu narä, niluxh ditu guidxäl narä, sa'csi cadro cha'ä di gacdi jiäädtu”? ");
INSERT INTO zawNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Lult dxe lanij, ni najc dxero, gusulii Jesús dipduxh guniini, räjpni: ―Palga yu' chu cayojḻ, sujiäädni loä te yäni. ");
INSERT INTO zawNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nani chalilajz xtidxä si'cni caj lo rexquijtz Dios neṉ lastoolini siliejn nisnabajṉ. ");
INSERT INTO zawNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Rediidxre guniini xcuent Sprit Dxan nani churu jiädläjz neṉ lastoo reni rililajz xtiidxni, sa'csi gajd Sprit Dxan jiääd, sa'csi gajd Jesús guibaṉsac lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Lo rebeṉ xhidajlga yu' reni biejn diajgreni rediidxga, dxejc räjpreni: ―Guliipacni, dade're najc laapac ni siääd, si'c ni rnii xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Yu'zareni räjp: ―Dade're najc Crist ni cabääznu. Yu'za sgaii ni räjp: ―Gurniälojtu jiääd Crist nez Galilee. ");
INSERT INTO zawNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ni loj rexquijtz Dios caj riäjḻpac gac Crist te rexagdoo toṟeii David, jiäädzani guedx Belén, lagajc guejdx cadro siääd toṟeii David. ");
INSERT INTO zawNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Dxejcti gucgala' rebejṉ xcuent Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yu'reni rlajz chääni pres luxh rut biajxdi gunaazni. ");
INSERT INTO zawNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Gubi' reguixhajg xten guidoo loj rebixhojzro näjza refarisee. Dxejcti gunabdiidxreni loj reguixhajg, räjpreni: ―¿Xhicuent ditu niädnäni? ");
INSERT INTO zawNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Badzu' reguixhajg diidxre, räjpreni: ―¡Gajdpac te bejṉ guinii si'cni rnii bejṉga! ");
INSERT INTO zawNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Dxejc räjp refarisee: ―¿La näj la'tu abasgueeni, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Xhixh loj regubier o loj refarisee yu' chu tej ni ahuililajz xtiidxni, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Rebeṉ xhidajlre ni di gan xleii toMoisés, reni'c agunijtpac. ");
INSERT INTO zawNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodem̲, nani huij lojni te guxhijṉ, najc te refarisee. Laani räjpni lojreni: ");
INSERT INTO zawNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Lo xleiinu caj: digacdi guntu yäḻguxhtis te bejṉ palga gajdtu gucuadiagxgaa xtiidxni, te don xhi bejnni. ");
INSERT INTO zawNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Badzu'reni diidxre räjpreni lojni: ―¿La näjza luj siäädlu Galilee, ä? Biḻsa'c xhi caj lo xquijtz Dios, suhuiilu nicla tej niguii nani rnii xtidx Dios di jiääd nez Galilee. ");
INSERT INTO zawNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Dxejc cade tejreni sii rolijzreni. ");
INSERT INTO zawNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Dxejcti huij Jesús nez dan Oliib. ");
INSERT INTO zawNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Rsilru gubi'ni, bui'ni neṉ guidoo. Luxh sanuutis siääd guiraa rebeṉguejdx lojni. Dxejc ro'c gurejni, gusloj caguluiinireni. ");
INSERT INTO zawNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Dxejcti biääd refarisee näjza rebeṉ najn, biädnäreni te gunaa nani biga' carälguijxh con te niguii. Basujrenini galäii reni suga' ro'c. ");
INSERT INTO zawNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Räjpreni loj Jesús: ―Mastr, gunaare biganäj te niguii carälguijxhreni, niluxh yu' chäälni. ");
INSERT INTO zawNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Loj leii xten Moisés caj guicuaanu guij yejc sa' gunaaga te guetni. Luj ¿xhicha naalu? ");
INSERT INTO zawNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Si'c räjpreni lojni te gaxäjsi gunijtni te diidx te gac cue'creni xquejni. Niluxh Jesús basajbtisni lojni lo yuj, gusloj cagucuaani lo yuj con bicueṉaani. ");
INSERT INTO zawNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Dxejc sanuutisreni canabdiidxreni, huisutini, räjpni: ―Nani yu' lojtu ni xhettipac xtojḻni, ni'c ganiddoo sugucuaani guij yejc gunaare. ");
INSERT INTO zawNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Basabsac lojni lo yuj sanuutis cagucuaani con bicueṉaani lo yuj. ");
INSERT INTO zawNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Luxh laareni che biejn diajgreni diidxga, sa'csi yu' xtojḻreni, gusloj biriireni tebgajreni, ganid ni najc beṉgolru, dxejcti ni najc huinru. Dxejcti bianxteb Jesús näjza gunaa ni suga' galäiireni. ");
INSERT INTO zawNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Dxejc gusulii Jesús, luxh sa'csi rutru lojdi bahuiini, xtebtis gunaaga, räjpni lojni: ―Gunaa, ¿con reni cabe'c xquejlu? ¿La rut bacuaquijdiru luj, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Räjp Gunaaga: ―Nicla tejreni, Dad. Dxejcti räjp Jesús lojni: ―Niclaza narä dina gucuaquiäru luj. Huij, na'cru gunlu dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Gunii Jesús lo rebejṉ stehuält, räjpni lojreni: ―Narä nacä bianij xten guedxliuj; nani jiädnajl narä dini sa lo yäḻnacäjy, sica'ni bianij ni rudeedpac yäḻnabajṉ. ");
INSERT INTO zawNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Dxejcti räjp refarisee lojni: ―Luj caniilu diidx lagajcsi xcuentlu. Xhet sajcdi sa' diidxga. ");
INSERT INTO zawNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Badzu' Jesús diidxre, räjpni lojreni: ―Masque lagajc narä rniä diidx xcuentä, sajc xtidxä, guliipacni, sa'csi ananä caro siälä, ananäza caro cha'ä. Niluxh la'tu ditu gan caro siälä, niclaza caro cha'ä. ");
INSERT INTO zawNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","La'tu rujntu yäḻguxhtis si'c najctis rexhigab xten beṉ guedxliuj. Narä rut lojdi runä yäḻguxhtis. ");
INSERT INTO zawNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Palga gunä yäḻguxhtis, yäḻguxhtis xtenä laaca najcni, sa'csi et xtebädi runä yäḻguxhtis, sa'csi narä näj Xtadä ni baxhaḻ narä rieṉnuni. ");
INSERT INTO zawNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Luxh lo xleiitu caj diidxre: “Che rnii tio'p bejṉ tejsi diidx, didxliini, coḻchalilajzni.” ");
INSERT INTO zawNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Narä rniliä́pac diidx lagajc xcuentä, dxejcti Xtadä nani baxhaḻ narä rniliizani diidx xcuentä. ");
INSERT INTO zawNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Räjpreni loj Jesús: ―¿Caro yu' xtadlu? Räjp Jesús lojreni: ―Ditu gumbee nicla narä, niclaza Xtadä; paru niembeetu narä, niembeezatu Xtadä. ");
INSERT INTO zawNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Rediidxre gunii Jesús cadro ṟe' gojn, laḻ ni caguluiini neṉ guidoro niluxh rut gunaazdini sa'csi gajd xhoṟni guidzujṉ. ");
INSERT INTO zawNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Gunisac Jesús lojreni, räjpni: ―Narä sia'ä, luxh la'tu siguiiltu narä, niluxh loj xtojḻtu sejttu. Cadro cha'ä di gacdi jiäädtu. ");
INSERT INTO zawNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Räjp rexpejṉ Israel loj resa'reni: ―¿Xhaa sugu'tni lagajc laani, ni'cni najni di gacdi chonnu cadro chääni? ");
INSERT INTO zawNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Räjp Jesús lojreni: ―La'tu najctu beṉ lo yuj. Narä nacä beṉ ni siääd jiaa. La'tu najctu beṉ guedxliujre. Luxh narä dina gacätis beṉ guedxliujre. ");
INSERT INTO zawNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ni'cni guniä lojtu, sejttu lo xtojḻtu sa'csi palga ditu chalilajz nacä chu nacä, sejtpactu lo xtojḻtu. ");
INSERT INTO zawNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Dxejcti räjpreni lojni: ―¿Chuxh najclu? Dxejcti badzu' Jesús diidxre lojreni, räjpni: ―¿Xhini'c guniä lojtu galooli? ");
INSERT INTO zawNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Xhidajl diidx rlazä guiniä, xhidajlza yäḻguxhtis rlazä gunä xcuenttu sa'csi ditu chalilajz, per nani baxhaḻ narä najc beṉ guliipac; nani biejn diagä guniini, rediidxga rniä loj rebeṉ guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Luxh laareni direni niacbee la xcuent Dad Dios ni caniini. ");
INSERT INTO zawNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ni'cni räjp Jesús lojreni: ―Cheni guiliästu Xi'n Niguii jiaa, dxejc sacbeetu laa narä ni baxhaḻni, luxh xhetliidi runä lagajcsi xcuentä. Si'cni baluii Dad narä, si'ctis rniä. ");
INSERT INTO zawNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nani baxhaḻ narä suganäjni narä. Gajd Dad gusanxteb narä, sa'csi runätis ganax redzuun nani rchaglajzni. ");
INSERT INTO zawNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Laḻ ni caniini si'c, xhidajlreni huililajz xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Dxejcti räjp Jesús lo rexpejṉ Israel nani huililajzga: ―Palga la'tu sutijptu, guzoobtu xtidxä, dxejc guliipac najctu xpeṉä. ");
INSERT INTO zawNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Sumbeezatu nani najc didxgulii, niluxh didx guliiga susḻaa la'tu lo xtojḻtu. ");
INSERT INTO zawNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Räjpreni lojni: ―Rexagdoo toAbraham najcnu, rut chu lojdi gudo'nu si'c mos. ¿Xho mood naalu “siḻiaatu”? ");
INSERT INTO zawNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Räjp Jesús: ―Riniliä́, rniliä́pac lojtu, chutis ni rujn dojḻ najc mos xten dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nani najc mos, dini jia'n rolijz xlam̲ni guideb guibajṉni, niluxh nani najc xi'n lam̲ga, ni'c sii sia'n rolijz xtadni guideb guibajṉni. ");
INSERT INTO zawNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ni'cni, palga rusḻaa xi'nni la'tu lo dojḻ, dxejcsii apac guḻaatu. ");
INSERT INTO zawNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ananä najctu xagdoo toAbraham, luxh la'tu rlajztu ju'ttu narä sa'csi di xtidxä jiu' lo xcäriejntu. ");
INSERT INTO zawNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Narä rniä nani abahuiä con Xtadä; luxh la'tu rujntu nani biejnza diajgtu lo xtadtu. ");
INSERT INTO zawNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Badzu'reni diidxre, räjpreni lojni: ―Xtadnu najc toAbraham. Dxejc räjp Jesús lojreni: ―Palga la'tu najcpactu xi'n toAbraham, sujntu sa' dzuun ni bejn toAbraham. ");
INSERT INTO zawNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Luxh ṉaj rlajztu ju'ttu narä, sa'csi rniliä rediidx nani baluii Dios loä. ¡Di toAbraham niujn si'c! ");
INSERT INTO zawNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","La'tu rujntu xtzuun xtadtu. Dxejc räjpreni lojni: ―Nuure dinu gac xi'n chälbejṉdi; nuure tejtis xtadnu yu', laani najc Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Dxejcti räjp Jesús: ―Paru guliini najc xtadtu Dios, ninälajztu narä sa'csi loj Dios biriä siäḻä ree. Xhet lagajcsi xcuentä siäḻädi; Dios baxhaḻ narä. ");
INSERT INTO zawNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Xhicuent ditu gacbee rediidx ni rniä lojtu? Sa'csi di rlajztu gucuadiajgtu rextidxä. ");
INSERT INTO zawNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Xtadtu najc beṉdxab. La'tu najctu xi'nni, rlajztu guntu nani rlajztisni guntu. Xtadtu galooli najcni te ni rugu't, dini suu xlaad didxlii, sa'csi xheti didxlii neṉ lastooni. Che rniini didx-xhii, si'c rniini sa'csi si'cpac najcni, sa'csi najcni beṉ didx-xhii, najczani xtad didx-xhii. ");
INSERT INTO zawNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Niluxh narä rniä didxlii, ni'c ditu chalilajz xtidxä. ");
INSERT INTO zawNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Chu tejtu sajc guluii te dojḻ ni benä? Narä rniä didxlii. ¿Xhicuent ditu chalilajz xtidxä, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nani najc xpejṉ Dios, ni'c rucuadiajg xtidx Dios. Sa'csi la'tu ditu gac xpejṉ Dios, ni'cni ditu gucuadiajg xtidxä. ");
INSERT INTO zawNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Dxejcti badzu' rexpejṉ Israel diidxre, räjpreni lojni: ―Laaca rniinu luj najclu te bejṉ ni siääd Samaria, beṉdxab yu' lastoolu. ");
INSERT INTO zawNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Räjp Jesús lojreni: ―Xhet beṉdxabdi yu' lastoä. Nani runätis rliä'pä xpala'n Xtadä, luxh la'tu alga rbälaztu narä. ");
INSERT INTO zawNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Luxh narä dina quilä chu guiliä'p xpala'nä, yu' chu rguiil guiliä'p bejṉ xpala'nä, niluxh laani rujnni yalguxhtis. ");
INSERT INTO zawNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Rniliä́pac lojtu, nani riu, nani rusoob xtidxä, dipacni guet. ");
INSERT INTO zawNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Dxejcti räjp rexpejṉ Israel lojni: ―N̲aj agucbeepacnu yu' beṉdxab lastoolu. ToAbraham näjza reniguii nani gunii xtidx Dios, guiraareni agujt. Luxh luj rniilu: “Nani riu, nani ruzoob xtidxä, dipacni guet.” ");
INSERT INTO zawNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Xhixh sajcrulu lo toxtadnu Abraham, ä? Ni laani gujtni, gujtza reniguii ni gunii xtidx Dios. ¿Chuxh rchalolu najclu? ");
INSERT INTO zawNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Badzu' Jesús diidxre, räjpni lojreni: ―Palga lagajc narä rliä'pä xpala'nä, xhet sajcdi xpala'nä. Per nani rliä'p xpala'nä najc Xtadä, lagajcza Xtadä ni rniitu najc Xtiostu. ");
INSERT INTO zawNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Niluxh la'tu ditu gumbeeni. Narä numbeäni. Paru guiniä dina gumbeäni, sacä te beṉ didx-xhii si'c najctu la'tu. Niluxh dee, numbeäpacni, luxh riuä ni rniini, rusobä xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ToAbraham toxtadgoldootu, bibalajzni sa'csi nuhuiini dxej nani jiäḻä, niluxh bahuiinini dxejc bibalazduxhni. ");
INSERT INTO zawNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Dxejcti räjp rexpejṉ Israel lojni: ―Nicla gajdlu chu tiubitzuu ijz, ¿xho naalu abahuiilu lo toAbraham? ");
INSERT INTO zawNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Räjp Jesús lojreni: ―Rniliä́pac lojtu, che gajdli guibajṉ toAbraham, agac nabaṉä narä. ");
INSERT INTO zawNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Dxejcti cua'reni guij te nucuaareni yejc Jesús, per di Jesús niga', biriini neṉ guidoro, gudejdni galäiireni. Sä'tini. ");
INSERT INTO zawNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Che cadejd Jesús te lajt, bahuiini sobga' te bejṉ ni che gojlli bejṉga agajc natiä'p balojni. ");
INSERT INTO zawNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Dxejc gunabdiidx rexpejṉpacni lojni, räjpreni: ―Mastr, ¿chuni'c bejn dojḻ, la bejṉre o la xcuzajnni, ni'c natiä'p balojni che gojlni, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Räjp Jesús: ―Nicla laani, niclaza xcuzajnni di niujn dojḻ. Si'c gojlni te xcuent ni sajc bejṉre suhuii bejṉ xho najc xtzuun Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nanab gunä xtzuun nani baxhaḻ narä ṉaj ni najc rdxee, sa'csi cheni guidzujṉ guxhijṉ rut gacdi gun dzuun. ");
INSERT INTO zawNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Laḻni yu'ä lo rebejṉ guedxliuj, nacä xpianij guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Che gulujx guniini si'c, batiobxhejnni lo yuj, bejnni bajṉ con xhejnni, gudääbnini con bicueṉaani lo rebaloj lotiä'pga. ");
INSERT INTO zawNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Dxejcti räjpni: ―Huij, huitiib lojlu neṉ nis ni laa Siloé. Laj nisga sälojza “baxhaḻni”. Dxejcti huijni. Huitiibni lojni. Che gubi'ni, aruhuiini. ");
INSERT INTO zawNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Dxejcti rexpisiṉ lotiä'pga, näj renani galoo bahuiireni natiä'p lojni, räjpreni: ―¿La et laadi dee ni rbej te rutie'ni gojn, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Yu'reni räjp: ―Laanini. Yu'zareni räjp: ―Et laadini, rujnsi lojni si'c. Laani räjpni: ―Laa naräni. ");
INSERT INTO zawNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Räjpreni lojni: ―¿Xho mood arieṉ balojlu? ");
INSERT INTO zawNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Dxejcti räjp dade'ga nani gujc lotiä'p: ―Dade' ni laa Jesús bejn bajṉ, gudääbnini baloä, dxejcti najni: “Huitiib lojlu neṉ te nis ni laa Siloé”, dxejcti che huitibä loä, lagajc dxejc bieṉ loä. ");
INSERT INTO zawNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Dxejcti räjpreni lojni: ―¿Con dade'ga ṉaj? Räjpti bejṉga: ―Dina ganä. ");
INSERT INTO zawNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Huinäreni nani gujc lotiä'pga nez loj refarisee. ");
INSERT INTO zawNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Luxh sa'csi najcni dxej ni rusilajzreni che bejn Jesús bajṉ ni gudääbni loj lotiä'pga te biajc balojni, ");
INSERT INTO zawNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","gunabdiidxsac refarisee loj dade' nani biajc balojni, xho mood arieṉ balojni ṉaj. Laani räjpni lojreni: ―Bajṉ gudääbni loä, dxejc gudibä loä, ṉaj aruhuiä. ");
INSERT INTO zawNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Dxejc yu' refarisee ni räjp: ―Di dade' ni bejn dee gac xpejṉ Dios, sa'csi dini jiu dxej ni rusilajz xpejṉ Israel. Yu'zareni räjp: ―¿Xho gac gunni sa' remilagwrga paru najcni beṉ dojḻ? Ni'cni gula' sa'reni, gujcreni tio'p gala'. ");
INSERT INTO zawNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Dxejcti gunabdidxsacreni lo ni gujc lotiä'p: ―Luj a', ¿xhi rniilu xcuent nani basiajc balojlu? Dxejc räjp dade'ga: ―Narä rniä najcni te bejṉ nani rnii xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Luxh rexpejṉ Israel naaddireni chalii lajzreni gujcpacni te lotiä'p ni abieṉ balojni, dxejcti gurejdxreni xcuzajn dade' ni gujc lotiä'pga. ");
INSERT INTO zawNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Dxejcti gunabdiidxreni lojreni, räjpreni: ―¿Laa xi'ntu dee nani najtu cheni gojllini natiä'p lojni? ¿Xhoxh arieṉ lojni ṉaj? ");
INSERT INTO zawNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Badzu' rexcuzajnni diidxre, räjpreni: ―Nadonnu laa xi'nnuni, luxh che gojlni natiä'p lojni. ");
INSERT INTO zawNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Niluxh dinu guidon ṉaj xho mood arieṉ lojni, dizanu guidon chu basiajc balojni. Coḻguiniabdiidx lojni, anajcni beṉgool, lagajc laani sajc guiniini xhi gusajcni. ");
INSERT INTO zawNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Si'c gunii xcuzajnni sa'csi rdxejbreni rexpejṉ Israel, sa'csi agac bia'nreni diidx sibääreni, dirureni gusaan jiu' neṉ guidoo chutis te bejṉ ni naa Jesús najc Crist nani abiääd. ");
INSERT INTO zawNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ni'cni räjp rexcuzajnni: ―Anajcni bi'n ni ayu' xcäriejnni. Lojni coḻguiniabdiidx. ");
INSERT INTO zawNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Dxejcti guredxsacreni nani gujc lotiä'pga, räjpreni lojni: ―Gulä'p xpala'n Gueb Dios. Nuure nadonnu beṉ dojḻ najc dade'ga. ");
INSERT INTO zawNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Dxejcti badzu' dade'ga diidxre, räjpni: ―Dina ganä la najcni beṉ dojḻ o la dini gac. Tejtis nanä: gucä lotiä'p, luxh ṉaj arieṉ baloä. ");
INSERT INTO zawNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Stehuält gunabdiidxreni, räjpreni lojni: ―¿Xho bennäjni luj? ¿Xho bejnni basiajcni balojlu? ");
INSERT INTO zawNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Badzu' dade'ga diidxre, räjpni: ―Ni aguniä guira'ti lojtu, luxh la'tu ditu jiu xtidxä. ¿Xhicuent rlajztu guinisacäni? ¿Xhixh näj la'tu rlajztu gactu xpejṉpacni, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Dxejc gudiḻnäjrenini, räjpreni: ―Luj najclu xpejṉni, per nuure najcnu xpejṉ toMoisés. ");
INSERT INTO zawNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Anadonnu guninäj Dios toMoisés, niluxh dade're dinu guidon casiäädni. ");
INSERT INTO zawNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Dxejcti räjp dade' lojreni: ―Dee najc te cos ni guidxeloj bejṉ: la'tu ditu gan casiäädni, ¡niluxh laani basiajcni baloä! ");
INSERT INTO zawNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nadoncheenu di Dios cuadiajg xtidx rebeṉ dojḻ; palga yu' chu rajṉ Dios, ni rusoobza xtiidxni, rucuadiajg Dios xtidx sa' bejṉga. ");
INSERT INTO zawNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Che guslojli guedxliuj gajd diajgnu jiejn xcuent te bejṉ nani rusiajc baloj te beṉ lotiä'p nani natiä'p lojni cheni gojllini. ");
INSERT INTO zawNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Palga xhet lo Diosdi siääd dade're, xhet sajcdi gunni. ");
INSERT INTO zawNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Badzu'reni diidxre räjpreni lojni: ―Luj, lo dojḻpac gojllu, ¿xho jiädluiilu nuure? Dxejcti guläärenini neṉ guidoro, barilaagwrenini. ");
INSERT INTO zawNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Biejn diajg Jesús guläärenini neṉ guidoro, che bidxälnini, räjpni lojni: ―¿La rililajzlu xtidx ni najc Xi'n Dios ni gujc Niguii, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Badzu'ni diidxre, räjpni: ―¿Chuni'c najcni, Dad, te chalilazä xtiidxni? ");
INSERT INTO zawNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Räjp Jesús: ―Abahuiilu lojni, lagajcza laani caninäjlu ṉaj. ");
INSERT INTO zawNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Dxejcti räjpni: ―Rililazä Dad. Dxejcti bazuxhijbni te gojṉnini. ");
INSERT INTO zawNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Räjp Jesús: ―Par yäḻguxhtis biälä lo guedxliujre, te fii renani di lojni jieṉ, niluxh reni rieṉ lojni sajcreni lotiä'p. ");
INSERT INTO zawNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Refarisee nani suganäjreni, che biejn diajgreni diidxre, räjpreni: ―¿Xhixh najczanu beṉ lotiä'p, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Räjp Jesús: ―Paru najctu lotiä'p, rut gucuaquijditu xtojḻtu, ṉaj sa'csi rniitu rieṉ lojtu, sicaquijtu rextojḻtu. ");
INSERT INTO zawNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Rniliä́, rniliä́pac lojtu, nani di jiu' ro' gurajl xte rexiil, alga richu'ni stelaad, rä'pni cuä' gurajl, ni'c najcni te gubaan. ");
INSERT INTO zawNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nani riu' nez ro' gurajl xten rexiil, laani najc xpaxtoorreni. ");
INSERT INTO zawNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Che guidzujṉ baxtoor, ruxhal nani rcanäj ro lä', te jiu'ni. Rexiilga numbeereni xse' baxtoor, dxejctiru laani rbejdxni rexiilga, tebgaj xiilga yu' lajni, rinäzanireni cadro naga' guixasa'c. ");
INSERT INTO zawNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Che ṟii rexiilga neṉ gurajl, sanä baxtoorgareni, luxh numbee rexiilga xse'ni, ni'c rsianäjreni baxtoorga. ");
INSERT INTO zawNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Luxh dipacreni chanä te baxtoor nani direni gumbee, ruxuṉreni lojni sa'csi direni gumbee xse' garenca bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Bij Jesús rediidxga lojreni, niluxh direni niacbee xhi säloj ni guniini. ");
INSERT INTO zawNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Dxejcti gunisac Jesús diidx lojreni; räjpni: ―Rniliä́, rniliä́pac lojtu, narä nacä si'c roxlä' xcurajl rexiil. ");
INSERT INTO zawNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Guiraa reni abiääd galoo, najcreni ganax gubaan luxh di rexiil nucuadiajg xse'ni. ");
INSERT INTO zawNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Narä nacä si'c rolä' xten gurajl, nani jiu' nejzga, siḻaani loj xtojḻni, siu'ni, siriini te guidxälni guixasa'c gauni. ");
INSERT INTO zawNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Ni najc gubaan riäädtisni te cuanni, te ju'tni, te guxhiṉzani, niluxh narä siäḻä te ga'ptu yäḻnabaṉsa'c, yäḻnabajṉ par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Narä nacä baxtorsa'c; luxh baxtorsa'c sudeed lagajc xcäḻnabajṉni xcuent rexiilni. ");
INSERT INTO zawNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Niluxh te mos ni rajxh, di gac baxtoorpac, ni xhet xtendini najc rexiil, che rhuiini siääd te cuyo't, ruxuṉni, li rbälazni rexiil. Dxejc rniaaz cuyo't rexiil, rutie'chzani rexiil. ");
INSERT INTO zawNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mosga ruxuṉ sa'csi najcni mostis, luxh dini jiu xhi rsiajc rexiil. ");
INSERT INTO zawNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Narä nacä baxtorsa'c; numbeä reni najcpac rexilä; rexilä numbeezareni narä ");
INSERT INTO zawNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","sigajc numbee Xtadä narä, sigajc numbeäza Xtadä; luxh sudedä xcäḻnabaṉä xcuent rexiilga. ");
INSERT INTO zawNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Rapäza ste cuaa xiil, ni di gac xten gurajlre; näjza laareni nanab chaxiä, te gusobdiajgreni xtidxä, te guidxagsa' guiro'p cuaareni, gacreni tejtis gurajl, tejtisza baxtoor. ");
INSERT INTO zawNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Narä siguixäza xcäḻnabaṉä, guetä, te dxejcru siliässacä xcäḻnabaṉä, guibaṉsacä, ni'cni sanälajz Xtadä narä. ");
INSERT INTO zawNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Rut sajcdi ju't narä, lagajc narä gudedä xcäḻnabaṉä, guetä. Rapä yäḻrnibee te gudedä xcäḻnabaṉä, guetä, rapäza yäḻrnibee te xcasacä xcäḻnabaṉä te guibaṉsacä, sa'csi dee najc yäḻrnibee ni baniidx Xtadä loä. ");
INSERT INTO zawNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Xcuent rediidxre gula' sa' rexpejṉ Israel, gujcreni tio'p gala'. ");
INSERT INTO zawNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Xhidajlreni canii: ―¿Xhicuent riutuni? ¿La ditu gan te beṉdxab yu' lastooni? Yejcni rajc. Xhigac rcuadiajgtu xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Dxejc ste cuaareni: ―Dini gac. Di rediidxre gac xtidx te beṉdxab. ¿Xhixh sajc rusiajc beṉdxab baloj relotiä'p, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Lagajc neṉ redxejga gujc lanij xten xquidoo rexpejṉ Israel guedx Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Najcni bäi najl. Biu' Jesús guidoro, sasajni nez neṉ cordoor ni laa xten Salomón. ");
INSERT INTO zawNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Gubig rexpejṉ Israel guideb gabi Jesús, räjpreni lojni: ―¿Gucli gucua'tzlu loonu chu najclu? Palga luj najclu Crist ni cabääznu jiääd, guiniliini loonu tejpas. ");
INSERT INTO zawNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Dxejc badzu' Jesús diidxre, räjpni lojreni: ―Aguniä lojtu si'c, niluxh ditu nililajz. Redzuun nani runä xcuent xcäḻrnibee Xtadä, huenliisi ruluilojreni chuni'c nacä. ");
INSERT INTO zawNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","La'tu ditu chalilajz sa'csi ditu gac rexilä. ");
INSERT INTO zawNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Rexilä numbee xse'ä, luxh narä numbeäzareni, riädnajlzareni narä. ");
INSERT INTO zawNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Narä rudedä yäḻnabajṉ par tejpas loj rexilä, luxh direni nitloj par tejpas. Rutza laadi nani sajc gudzucajreni ladzṉaä. ");
INSERT INTO zawNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Xtadä baniidxreni loä, laani najcni guroobru, nadipru loj guiraareni. Rut laadi nani sajc gudzucajreni ladzṉaa Xtadä. ");
INSERT INTO zawNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Narä näjza Xtadä najcnu tejsi. ");
INSERT INTO zawNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Dxejc gulässac rexpejṉ Israel guij, te nucuaareni yejc Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Dxejcti räjp Jesús lojreni: ―Xhidajl dzuun xten Xtadä abaluiä lojtu, ¿lo redzuunga, xhi tej dzuun rujn gucuaatu guij yecä? ");
INSERT INTO zawNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Dxejcti räjp rexpejṉ Israel lojni: ―Xcuent redzuun ni rujnlu dinu gucuaa guijlu. Sa'csi guniyajlu, ni'c nucuaanu guij yejclu. Beṉ guedxliujlu, luxh najlu najclu tejsi con Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Badzu' Jesús diidxre, räjpni lojreni: ―¿La et loj xleiiditu caj rediidxre: “Narä rniä, la'tu najc redios”? ");
INSERT INTO zawNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nancheenu digacdi guidxaa xquijtz Dios. Palga gulalajni redios rebejṉ nani bejn yäḻguxhtis loj rexpejṉ Israel, dxejc ");
INSERT INTO zawNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ṉaj ¿xhicuent guniitu loä: “Caniyajlu Dios”, sa'csi guniä lojtu narä nacä Xi'n Dios? Ni gule Dios narä, baxhaḻni narä lo guedxliujre. ");
INSERT INTO zawNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Palga dina gunä redzuun xten Xtadä, na'c chalilajztu rextidxä. ");
INSERT INTO zawNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Luxh palga runnäni, mascä ditu chalilajz xtidxä, coḻchalilajz ni ruluii reyäḻmilagwr nani runä, te gacbeetu par tejpas, Xtadä yunäj narä, narä yunää́za laani. ");
INSERT INTO zawNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Che rlajzreni niniaazrenini stehuält, laani biriini ladzṉaareni. ");
INSERT INTO zawNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Dxejcti sääni, gubisacni nez stelaad gueu Jordán, nejzga huijia'nni, cadro gusloj batiobnis Juan. ");
INSERT INTO zawNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Xhidajl bejṉ bidzujṉ lojni ro'c, räjpreni: ―Di Juan niujn nicla tej yäḻmilagwr luxh guiraa rediidx ni gunii Juan xcuent dade're najc didxliipac. ");
INSERT INTO zawNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Xhidalduxhreni huililajz xtiidxni ro'c. ");
INSERT INTO zawNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Yu' te dade' ni cayacxhuu ni laa Larz. Rbäjzni guedx Betania, lajdxza rebisiajnni Marii näjza Mart. ");
INSERT INTO zawNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariire, bisiajn Larz, najc nane' ni basäḻ setnejxh ni' Jesús, batiaazani ni'ni con xquidxejcni. ");
INSERT INTO zawNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ni'cni baxhaḻ guiro'p bäjlre diidx loj Jesús, räjpreni lojni: ―Dad, xamiigwlu nani sanälajzlu cayacxhuu. ");
INSERT INTO zawNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Che biejn diajg Jesús rediidxga, räjpni: ―Di yäḻracxhuure ju'tni, sa'csi yäḻracxhuure najc te guluilojni xcäḻrnibee Dios. Te guluilojza yäḻracxhuure xcäḻrnibee Xi'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Sanälajz Jesús Mart, bäjlni, näjza Larz, ");
INSERT INTO zawNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","che räjpreni lojni cayacxhuu Larz, bia'nni stio'p dxej cadro yu'ni. ");
INSERT INTO zawNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Dxejcti räjpni loj rexpejṉpacni: ―Coḻcho', chonnu stehuält región Judea. ");
INSERT INTO zawNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Räjp rexpejṉni lojni: ―Mastr, gajd gac xchej rlajz rexpejṉ Israel ni rnibee nucuaa guij yejclu te nugu'treni luj, luxh ṉaj rlajzlu chäsaclu ro'c. ");
INSERT INTO zawNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Dxejcti räjp Jesús lojreni: ―¿La xhet tzubitio'p oṟdi yu' lo tebdxej, ä? Palga sa bejṉ rdxee, dini jiajb sa'csi ruhuiini lo bianij nani yu' lo guedxliujre. ");
INSERT INTO zawNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Palga chasajni guxhijṉ, siliaro'ni, sa'csi xheti bianijga. ");
INSERT INTO zawNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Dxejcti räjp Jesús lojreni: ―Nagayejs xamigwä Larz. Cha'a te chacuänäni. ");
INSERT INTO zawNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Dxejc räjp rexpejṉpacni lojni: ―Dad, palga agudiesni, pet siajcni. ");
INSERT INTO zawNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesús canii lojreni agujt Larz, niluxh rexpejṉpacni bejn xhigab caniini xcuent yäḻrejs xten bacaḻtis. ");
INSERT INTO zawNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ni'cni guniliipac Jesús räjpni lojreni: ―Agujt Larz. ");
INSERT INTO zawNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Rbalazä sa'csi rutinu ro'c, te chalilajztu xtidxä. Coḻcho' te chohuiinuni. ");
INSERT INTO zawNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Dxejcti Tomás ni rniizareni “cua'ch”, räjpni loj resa'ni: ―Coḻcho' te guetnäzanuni. ");
INSERT INTO zawNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Che bidzujṉ Jesús lo guejdxga, agujc tajp dxej biga'tz Larz. ");
INSERT INTO zawNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Guedx Betania tre' gajxh lo guedx Jerusalén, si'cti tio'p garol kilómetro. ");
INSERT INTO zawNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Xhidajl rexpejṉ Israel abidzujṉ, siädhuiireni Mart, näjza Marii, te di gac-huin lajzreni sa'csi gujt bisiajnreni. ");
INSERT INTO zawNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Che gucbee Mart abidzujṉ Jesús, biriini huichaglojnini; niluxh Marii bia'n rolijzreni. ");
INSERT INTO zawNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Dxejcti räjp Mart lo Jesús: ―Dad, paru suga'lu ree, di bisianä niejt. ");
INSERT INTO zawNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Narä nanä suniidx Dios guiraa nani guiniablu lojni. ");
INSERT INTO zawNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús räjpni lojni: ―Sibaṉsac bisiajnlu. ");
INSERT INTO zawNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Räjp Mart lojni: ―Acananä sibaṉsacni che guidzujṉ dxej ni guibaṉsac bejṉ loj rebeṉgut dxej lult che gun Dios yäḻguxhtis. ");
INSERT INTO zawNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Dxejc räjp Jesús lojni: ―Narä nacä yäḻruspaṉsac bejṉ loj rebeṉgut, näjza yäḻnabajṉ par tejpas. Nani rililajz rextidxä, masä agujtni, sibaṉsacni. ");
INSERT INTO zawNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Chutis tej bejṉ ni nabajṉ ni chalilajz xtidxä, dini nitloj par tejpas, ¿riliiga lajzluni, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Dxejcti räjp Mart lojni: ―Rililazäni, Dad. Ahuililazä luj najclu Crist, Xi'n Dios nani bia'n diidx guxhaḻ Dios lo guedxliujre. ");
INSERT INTO zawNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Che guluux gunii Mart, huitejdxni bäjlni Marii, xhiga'tz räjpni lojni: ―Abidzujṉ Mastr. Cabejdxzani luj. ");
INSERT INTO zawNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Che biejn diajg Marii rediidxga, huisugajcni, sahuiini Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Gajd Jesús jiu' guejdxga, laḻtis suga'ni cadro bidxaagni Mart. ");
INSERT INTO zawNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Rexpejṉ Israel nani biädcuenäj Marii, ni cahuii didi gac-huin lajzni, che bahuiireni huisu Marii, sääni, näjza laareni huirinajlreni Marii, naareni pet lo baa sayoonni. ");
INSERT INTO zawNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ni'cni che bidzujṉ Marii cadro suga' Jesús, bazuxhijbni lojni, räjpni: ―Dad, paru suga'lu ree, di bisianä niejt. ");
INSERT INTO zawNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Che bahuii Jesús cayoon Marii, näjza rexpejṉ Israel ni siädnajl Marii, guc-huin lastooni, biääd te rsliajz lastooni. ");
INSERT INTO zawNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Dxejcti räjpni lojreni: ―¿Caro bacua'tztuni? Räjpreni lojni: ―Dad, gudaa ree te fiilu. ");
INSERT INTO zawNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Dxejcti biin Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ni'cni cayäjp rexpejṉ Israel: ―Coḻhuii, lacti sanälajznini. ");
INSERT INTO zawNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Yu'zareni räjp: ―Dade're basiajc beṉ lotiä'p. ¿Xha di niajcdi nusiajcni bejṉre te di niejtni, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Guc-huinduxh lastoo Jesús, gubigni lo baa. Baaga najc si'c te biliää, suga' te guiro ni rusäuureni ro'ni. ");
INSERT INTO zawNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Dxejcti räjp Jesús lojreni: ―Coḻgudzucaj guijga. Mart, ni najc bisiajn beṉgutga, räjpni lojni: ―Dad, pet acaladxuudxni, sa'csi agujc tajp dxej gujtni. ");
INSERT INTO zawNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Dxejc räjp Jesús lojni: ―¿Et rniä lojlu, palga rililajztu, suhuiilu xcäḻrnibee Dios, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Dxejcti badzucajreni guijga. Guläs Jesús lojni xhaguibaa, räjpni loj Xtadni: ―Xtadä, runidxä xquixtios lojlu sa'csi abiejn diajglu xtidxä. ");
INSERT INTO zawNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Narä nanä guliica rucuadiajglu xtidxä, luxh ṉaj caniäni xcuent rebejṉ ni tre' ree, te chalilajzreni luj baxhaḻlu narä. ");
INSERT INTO zawNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Che gulujx guniini rediidxga, guredxa'ni räjpni: ―¡Larz! ¡Gudaa ree! ");
INSERT INTO zawNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Dxejc birii beṉgutga neṉ biliää. Naliib reṉaani, reni'ni, niäuu te baii lojni. Dxejcti räjp Jesús lojreni: ―Coḻgusḻaani, coḻgusaan jiini. ");
INSERT INTO zawNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Xcuent dzunrore huililajz rextidx Jesús xhidajl rexpejṉ Israel nani huinajl Marii, che bahuiireni xhi bejn Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Yu' reni huihuii loj rexpejṉ Israel ni laa farisee, bijreni diidx xhi bejn Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Dxejcti refariseega, näjza rebixhojz ni rnibee, bire'reni bidxagsa'reni lo Junt Suprem, räjpzareni: ―¿Xho jiennu? Niguiire cayujn xhidajl milagwr. ");
INSERT INTO zawNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Palga guisaannuni si'c, guiralii bejṉ sililajz xtiidxni, sinajlrenini. Dxejcti jiääd rebeṉ roman ni rnibee, gudzucajreni xcäḻrnibeenu, sudzujlzareni lajdxnu. ");
INSERT INTO zawNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Dxejc Caifás, bixhojzro ni riäjl gunibeeni lo rebixhojz ijzga, räjpni lojreni: ―La'tu xhetliidi najnditu. ");
INSERT INTO zawNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ditu gun xhigab laaca guet tejtis bejṉ xcuent guideb guejdx, didi nitloj guideb lajdxnu. ");
INSERT INTO zawNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Niluxh Caifás dini ninii diidxre xcuentcani. Sa'csi ijzga rnibeeni lo rebixhojz, lagajc Dios badeed diidxga guniini. Ni'c gunixgaani guet Jesús xcuent nacióṉ xten rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Luxh xhet ganaxtis xcuent nacioṉga, näjza te guire' guiraa rexpejṉ Dios nani nare'ch loj guideb guedxliujre. ");
INSERT INTO zawNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ni'cni dxejliga bachaag rebejṉga diidx te don xho gunreni gugu'treni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ni'cni diru Jesús nisiaj nez loj rexpejṉ Israel. Biriini región Judea, huijni te lajt gajxh nez lo reyubijdz, lo te guejdx ni laa Efraín. Ro'c biannäjni rexpejṉpacni. ");
INSERT INTO zawNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Guxii dxej cayäädx guidzujṉ lanij ni laa pascw ni rujn rexpejṉ Israel. Xhidalduxh rebeṉguejdx huij guedx Jerusalén te gusiareni lastooreni, te gac gunreni lanij xten pascw. ");
INSERT INTO zawNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Cansajreni caguiilreni Jesús; che yu'zareni neṉ guidoro, canabdiidx lo sa'reni, räjpreni: ―¿Xhi najtu? ¿La siäädni lanijre o laa dini jiääd, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Refarisee näjza rebixhojz ni rnibee loj rebixhojz, agunibeereni palga yu' chu najn caro yu' Jesús, chaye'tzni lojreni te guiniaazrenini. ");
INSERT INTO zawNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Che riäädx xho'p dxej gaḻ lanij pascw, huij Jesús guedx Betania cadro rbäjz Larz nani baspaṉsac Jesús loj rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ro'c bejnreni te xchej te gau Jesús. Mart bateed xchejga, näjza Larz sobganäj Jesús näjza rexpejṉpacni lo mex. ");
INSERT INTO zawNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Dxejcti bidzuṉnäj Marii si'cti garol litr se't ni rlianexhduxh si'c nard. Sacduxh se'tga. Dxejcti gudääbni se'tga lo reni' Jesús, baspijdzni ni'ni con xquidxejcni. Guideb neṉ yu'ga gulanejxh se'tga. ");
INSERT INTO zawNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Dxejcti räjp Judas Iscariot, xi'n Simón, ni najc te rexpejṉpac Jesús, lagajc ni abejn xhigab guto'ni Jesús, räjpni: ");
INSERT INTO zawNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Xhicuent di se'tre nido' choṉ gayuu denar te nidis meelga loj rebeṉproob? (Choṉ gayuuga najc si'cti ni xca' te niguii paru gunni dzuun tzubiteb bäii.) ");
INSERT INTO zawNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Guniini si'c, xhet sa'csi riadini reproob, per sa'csi laani najcni te gubaan, luxh laani ca'ni bols cadro ruchee meel, luxh rbääni meel lojga te rca'nini. ");
INSERT INTO zawNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ni'cni räjp Jesús lojni: ―Na'c gudxojnluni; subasäḻxgaanini, che gajd guidzujṉ dxej nani guiga'tzä. ");
INSERT INTO zawNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Dxej-yääl yu' rebeṉproob lojtu, luxh narä dina chuä lojtu xchej. ");
INSERT INTO zawNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Dxejc che gucbee xhidajl xpejṉ Israel yu' Jesús rolijz Larz ni gubaṉsac lo rebeṉgut, bidzujṉreni, xhet xcuentis Jesús. Biäädreni te fiizareni loj Larz nani baspaṉsacni lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Dxejcti rebixhojz ni rnibee bachaagzareni diidx te ju'tzareni Larz, ");
INSERT INTO zawNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","sa'csi xhidajl rexpejṉ Israel salilajzreni xtidx Jesús sa'csi bahuiireni gubaṉsac Larz. ");
INSERT INTO zawNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Che bara yääl, rebejṉ xhidajl ni bidzujṉ lanij biejn diajgreni asiäddzujṉ Jesús guedx Jerusalén, ");
INSERT INTO zawNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","dxejcti batiu'reni ṉaa reyagzijn, biriireni neṉ guejdx, sachaglojrenini. Guredxa'reni, räjpreni lo Jesús: ―¡Coḻguiliä'p xpala'n Dios! ¡Chicbaa nani siääd xcuent Dad nani najc ṟeii lo rexpejṉ Israel! ");
INSERT INTO zawNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Bidxäl Jesús te burbäz, gubijbnini, si'cni caj lo reguijtz: ");
INSERT INTO zawNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Na'c guidxejbtu, bejṉ ni rbäjz neṉ guedx Sión. ¡Coḻhuii! Reii xtentu asiääd, bijbni dejtz te burbäz. ");
INSERT INTO zawNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Di rexpejṉpacni niacbee recosga che gujcreni, niluxh che gubaṉsacni loj rebeṉgut, dxejc banaj lajzreni recos nani caj lo guijtz xcuentni, näjza guiraa recos ni bejn rebejṉ lo Jesús te guzojb rediidxga. ");
INSERT INTO zawNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Rebeṉ xhidajl ni suganäjni che gurejdxni Larz te biriini neṉ baa che baspaṉsacnini lo rebeṉgut, bijzareni diidx xcuent guiraa ni bahuiireni. ");
INSERT INTO zawNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ni'cni biädchagloj rebeṉ xhidajlgani, sa'csi abiejn diajgreni laani bejnni milagwrre. ");
INSERT INTO zawNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ni'cni räjp refarisee lo sa'reni: ―Aruhuiitu xhet sajcdi jieṉnu. ¡Coḻhuii! Empac sanajl guideb guedxliujni. ");
INSERT INTO zawNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Yu' gaii beṉgriegw nadxaag lo rebejṉ ni biädted lanij guedx Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Rebejṉre bidzujṉ loj Felipe nani siääd guedx Betsaida xten Galilee, gusloj gunabreni lojni, räjpreni: ―Dad, rlaaznu guihuiinu lo Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Biääd Felipe, räjpni loj Andrés, dxejcti guiro'preni huiye'tzreni lo Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Dxejcti räjp Jesús lojreni: ―Abidzujṉ oṟ ni chä'p xpala'n Xi'n Dios ni gujc Niguii. ");
INSERT INTO zawNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Rniliä́pac lojtu, palga di te xob binij jiajb lo yuj, neṉ xhurc cadro cueni, te rianxtebni, guetni, dini guiliejn. Luxh palga guetni, siliejnni, rajcza te nisro lojni, rajc xhidajl xob binij. ");
INSERT INTO zawNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nani sanälajz xcäḻnabajṉni, sunijtnini, luxh nani rbälaz xcäḻnabajṉni lo guedxliujre, sica'ni yäḻnabajṉ par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Palga yu' chu tej ni rlajz chu loä, sujiädnajlni xnezyuä, te cadro yu'ä, ro'cza cuääz ni ru' loä. Palga yu' chu gun xtzunä, siliä'pza Xtadä xpala'nni. ");
INSERT INTO zawNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Räjpzani: ―N̲aj cayac-huin lastoä. ¿Xhichani'cza gäpä lo Xtadä? ¿La siniä: Dad, gucnäj narä te di tedä oṟ ni siääd? Ni te tedäpac oṟga biälä lo guedxliujre. ");
INSERT INTO zawNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Xtadä, bejn si'cni riäjl gac te guiliä'p bejṉ xpala'nlu. Dxejcti xhaguibaali biejn te xse' te ni räjp: ―Agulä'pä xpala'nä, siliä'pä xpala'nä stehuält. ");
INSERT INTO zawNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ni'cni lo rebejṉ ni tre' ro'c, ni biejn diajgreni se'ga, yu' reni räjp: ―Lascanu gunii te guzii. Guyu'zareni räjp: ―Te xangl Dios ni gunii lojni. ");
INSERT INTO zawNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Dxejc räjp Jesús lojreni: ―Et xcuentädi gunii xse' ni gunii, xcuenttis la'tu guniini. ");
INSERT INTO zawNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","N̲aj abiääd xcäḻguxhtis Dios lo guedxliuj. N̲aj sibicaj xcäḻrnibee nani rnibee lo guedxliujre. ");
INSERT INTO zawNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","N̲aj, che guiliäsreni narä jiaa lo guedxliuj, te gaḻä ro'c, sutie'ä guiraa bejṉ loä. ");
INSERT INTO zawNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Rediidxre gunii Jesús te canixgaani xho guetni. ");
INSERT INTO zawNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Räjp rebejṉ lojni: ―Nuure biejn diajgnu biḻreni lo leii, Crist ni jiääd sibajṉ par tejpas. ¿Xho mood rniilu, nanab chäs Xi'n Dios ni gujc Niguii jiaa lo guedxliuj? ¿Chuxhni'c najc Xi'n Dios ni gujc Niguii ni ruzä'tlu? ");
INSERT INTO zawNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Dxejcti räjp Jesús lojreni: ―Stera'tsi yu' bianij lojtu. Coḻsaj laḻ ni rajptu bianijga, te di guiniaaz yäḻxcäjy la'tu, sa'csi ni rsiaj loj nacäjy, dini gan caro chääni. ");
INSERT INTO zawNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Laḻ ni rajptu bianij, coḻchalilajz bianijga te gactu rexi'n bianij. Gunii Jesús rediidxga lojreni, dxejcti biunejzni ro'c, bicuatzlojni. ");
INSERT INTO zawNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Xhidajl remilagwr bejn Jesús nez loj rexpejṉ Israel, niluxh direni nililajz xtiidxni, gulälazreni nani baxhaḻ Dios lojreni. ");
INSERT INTO zawNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ni'cni guzojb diidx nani gunii Isaías, ni gunii xtidx Dios galoro, räjpni: Dad, ¿chuni'c huililajz xtiidxlu? ¿Chuloj baluiilu xcäḻrnibeduxhlu, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ni'cni di niajcdi nililajzreni, sa'csi guniiza Isaías, räjpni: ");
INSERT INTO zawNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Abascäjyni lojreni, abennajdni lastooreni, te di rebalojreni fii, te di lastooreni gacbee, te di gusiejch lajzreni, te di gusiacäreni. ");
INSERT INTO zawNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Rediidxre gunii Isaías, sa'csi bahuiini xcäḻrdimbicha' Jesús xhaguibaa, dxejc guniini xcuentni. ");
INSERT INTO zawNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Dxejcti gaii rebejṉ ni rnibee huililajz xtiidxni che räjpni abaxhaḻ Diosni, niluxh bidxejbreni rebeṉ farisee, ni'c direni nicäjp ahuililajzreni, te di gurilaagwreni laareni, gudxojnreni jiu'reni neṉ guidoo. ");
INSERT INTO zawNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Sa'csi rdxaglajzrureni guiliä'p rebejṉ xpala'nreni luxh guxiiru rlajzreni guiliä'p Dios xpala'nreni. ");
INSERT INTO zawNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Dxejcti gudidxa' Jesús: ―Nani chalilajz xtidxä, et ganaxdi ni caniä rililajzni, näjza xtidx Xtadä nani baxhaḻ narä rililajzni. ");
INSERT INTO zawNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nani ruhuii loä, ruhuiizani loj ni baxhaḻ narä. ");
INSERT INTO zawNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Narä biäḻä si'c bajl lo guedxliujre, te guiraa renani chalilajz xtidxä, dirureni chu lo yäḻcäjy. ");
INSERT INTO zawNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nani riendiajg xtidxä, luxh dini gusoob rediidxga, dina gunä yäḻguxhtis lojni, sa'csi dina niälä te gunä yäḻguxhtis rebeṉguedxliuj, biäḻä te gusḻaä́ rebeṉ guedxliuj lo dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nani rbälaz narä, ni di gusoob xtidxä, yu' chu gun yäḻguxhtis xtojḻni; lagajc rediidx nani guniä gun yäḻguxhtis xtojḻreni che gaḻ lult dxej. ");
INSERT INTO zawNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Sa'csi narä dina niädniä lagajc xcuentä, lagajc Dad ni baxhaḻ narä, lagajc laani gunibeeni xhini'c guiniä, xhini'c guluiä. ");
INSERT INTO zawNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Luxh nancheä gunibeeni chu yäḻnabajṉ par tejpas. Ni'cni rediidx nani rniä, rniäreni si'cpacni gunii Xtadäni loä. ");
INSERT INTO zawNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Che gajd gaḻ dxe lanij ni laa pascw, najn Jesús asiäddzuṉgajxh xoṟni, oṟ ni jiunejzni lo guedxliujre te chääni lo Xtadni. Luxh sa'csi agajc sanälajzni rexpejṉpacni nani yu' lo guedxliujre, sinälajzzanireni par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ni'cni laḻ ni cayauxchejreni biu' beṉdxab neṉ lastoo Judas Iscariote, xi'n Simón, te guto'ni Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Sa'csi agucbee Jesús abateed Xtadni guira'ti ladzṉaani, gucbeezani loj Dios biriini, lo Dios guibi'zani, ");
INSERT INTO zawNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ni'c huisu Jesús lo xchejga, gulääni xhablojiaani, gudojbni te tuäii, batejbnini xque'ni. ");
INSERT INTO zawNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Dxejcti cua'ni nis neṉ te chaa, guslojni gudiibni ni' rexpejṉpacni, baspijdzni ni'reni con tuäiiga. ");
INSERT INTO zawNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Che bidzujṉni loj Simón Pedr, räjp Pedr lojni: ―Dad, ¿xhixh luj siguiiblu ni'ä? ");
INSERT INTO zawNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Dxejc räjp Jesús lojni: ―Nani cayunä dilu gacbeeni ṉaj, guixee-huijdx sacbeeluni. ");
INSERT INTO zawNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Räjp Pedr lojni: ―¡Dipaclu quiib ni'ä! Räjp Jesús lojni: ―Palga dina quibä ni'lu, digacdiru gaclu xpeṉä. ");
INSERT INTO zawNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Räjp Pedr lojni: ―Dad, na'c quiiblu ni'ätis näjza ṉaä näjza yecä gudiib. ");
INSERT INTO zawNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Räjp Jesús lojni: ―Nani agojz di guiquiin gazsacni; ni'tisni guidiib, sa'csi naya guidebni; nayazatu, per xhet guiraaditu naya. ");
INSERT INTO zawNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Sa'csi anajnni chu guto'ni, ni'cni guniini: “Xhet guiraaditu naya.” ");
INSERT INTO zawNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ni'cni che gulujx gudiibni ni' rexpejṉni, gotsacni xhajbni, guresacni lo mex, räjpni: ―¿La najntu xhini'c benä lojtu, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","La'tu rniitu narä, Mastr näjza Dad. Luxh laaca rniitu sa'csi nacäni. ");
INSERT INTO zawNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mbaj, palga narä ni nacä Dad, nacäza Mastr, gudibä ni'tu, la'tu sigajcza riäjl quiibtu ni' resa'tu. ");
INSERT INTO zawNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Sa'csi abaluiä lojtu xho gacni, te chanuu guntu sigajc ni benä lojtu. ");
INSERT INTO zawNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Rniliä, rniliä́pac lojtu, di te mos gac beṉroru lo xlam̲ni; diza te ni rij xmandaad bejṉ gac beṉroru loj nani baxhaḻni. ");
INSERT INTO zawNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Palga najntu recosre, chicbaazatu palga si'c guntu. ");
INSERT INTO zawNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Dina guiniä diidxre lo guiraatu. Numbeä reni aguleä, niluxh nanab soob xtidx Dios ni caj lo rexquijtzni. Scree najc rediidxga: “Nani rajw xcuxtilä, ni'c agubiréni, agulälazni narä.” ");
INSERT INTO zawNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ni'cni agunixgaäni, che gajdni gac, te che gacni chalilajztu nacä chu rniä nacä. ");
INSERT INTO zawNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Rniliä, rniliä́pac lojtu, nani riu xtidx nani ruxhaḻä, riuzani xtidxä; luxh nani riu xtidxä, riuzani xtidx nani baxhaḻ narä. ");
INSERT INTO zawNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Che gulujx gunii Jesús rediidxre, guc-huinduxh lastooni, dxejc guniliini: ―Rniliä, rniliä́pac lojtu, tejtu suto' narä. ");
INSERT INTO zawNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Dxejc gusloj cadxeloj rexpejṉni lo sa'reni, di jien chuchani'c cagusä'tni. ");
INSERT INTO zawNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tej rexpejṉni nani sanälajzruni sobga' cuä'ni. ");
INSERT INTO zawNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Dxejcti bejn Simón Pedr seen lojni te guiniabdiidxni loj Jesús chu xcuent caniini. ");
INSERT INTO zawNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Dxejc nani sobga' cuä'ni, gubigruni loj Jesús, gunabdiidxni lojni, räjpni: ―Dad, ¿chuni'c rusä'tlu? ");
INSERT INTO zawNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Dxejcti räjp Jesús lojni: ―Guhuadxä te la' yätxtiil. Loj nani gudedäni, ni'c najcni. Dxejcti bahuajdxni tla' yätxtiil, badeednini loj Judas Iscariote, xi'n Simón. ");
INSERT INTO zawNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Che gulujx gudajw Judas yätxtiilga, biu' beṉdxab lastooni. Dxejcti räjp Jesús lojni: ―Ni rlajzlu gunlu, bejngani. ");
INSERT INTO zawNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nicla tej reni sobga' lo mex direni niacbee xhicuent räjpni lojni si'c. ");
INSERT INTO zawNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Sa'csi Judas ca' bols meel, gaiireni bejn xhigab pet guniini si'c sa'csi yu' xhi chasiini par lanij, o pet yu' xhi gudeedni loj rebeṉ ni xhet rajpdi. ");
INSERT INTO zawNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Che gudajw Judas yätxtiilga, birigajcni, luxh abiu' guxhijṉ. ");
INSERT INTO zawNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Dxejcti che abirii Judas lojreni, räjp Jesús lojreni: ―N̲aj sieṉloj xcäḻrnibee Xi'n Dios ni gujc Niguii, luxh lojni sieṉloj xcäḻrnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Palga suluiloj Xi'n Dios ni gujc Niguii xcäḻrnibee Dios, dxejc suluilojza Dios xcäḻrnibee Xi'n Dios ni gujc Niguii, luxh siojb gunnini. ");
INSERT INTO zawNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Rexi'nä nani sanälazä, diru gac xchej chunää́ la'tu. La'tu siguiiltu narä, per si'cni räpä lo rexpejṉ Israel si'cza rniä lojtu ṉaj: Di gacdi jiäädtu cadro cha'a. ");
INSERT INTO zawNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Te didxcoob rnibeä guntu: Coḻchanälajz sa'tu. Sigajc ni sanälazä la'tu, sigajcza coḻchanälajz sa'tu. ");
INSERT INTO zawNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Palga rinälajz sa'tu, si'c sacbee guiraa beṉguedxliuj najcpactu rexpeṉä. ");
INSERT INTO zawNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Dxejcti räjp Simón Pedr loj Jesús: ―Dad, ¿caro chäälu? Räjp Jesús lojni: ―Cadro cha'ä digacdi jiädnajllu narä ṉaj; niluxh sidzujṉ dxej jiäädlu ro'c. ");
INSERT INTO zawNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Räjp Pedr lojni: ―Dad, ¿xhicuent digacdi jiäḻä ṉaj? Palga rquiin guetä xcuentlu, suguetä. ");
INSERT INTO zawNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Räjp Jesús lojni: ―¿La guliilu guetlu xcuentä, ä? Rniliä́pac lojlu, nicla gajd guidgaii cuedxa' choṉ huält, säjblu dilu gumbee najrä. ");
INSERT INTO zawNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Dxejcti räjp Jesucrist lojreni: ―Na'c chutu yärsia'. Rililajztu xtidx Dios, coḻchalilajzza xtidxä. ");
INSERT INTO zawNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Yu' xhidalduxh yu' cadro rbäjz Xtadä. Palga xhet si'cdi najcni, dizana niniä lojtu si'c. Sia'ä chasucheä reyu' par la'tu. ");
INSERT INTO zawNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Luxh palga chasucheä cadro cuääztu, che guluxäni, sibisacä, te chanää́tu ro'c, te cadro yu'ä, ro'cza chutu. ");
INSERT INTO zawNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","La'tu anajntu caro cha'ä, anajnzatu nezyuj ni chäätu. ");
INSERT INTO zawNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Dxejcti räjp Tomás loj Jesús: ―Dad, dinu guidon caro chäälu, ¿xho guidonnu nezyujga, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Räjp Jesús lojni: ―Narä nacä nezyuj. Narä nacä didxliipac, nacäza yäḻnabajṉ. Por narätis sajc chää bejṉ cadro rbäjz Xtadä. ");
INSERT INTO zawNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Palga la'tu niembeetu chuni'c nacä, niembeezatu Xtadä. Luxh ṉajli abiembeepactuni sa'csi acahuiitu lojni. ");
INSERT INTO zawNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Räjp Felipe loj Jesús: ―Dad, basaan guihuiinu loj Xtadlu; ni'ctis rlaaznu. ");
INSERT INTO zawNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Dxejcti räjp Jesús lojni: ―Felipe, ¿la gajdlu gumbee narä, luxh lacti xchej yu'ä lojtu, ä? Nani ruhuii loä, abahuiini lo Xtadä. ¿Xhicuent rniablu fiilu lo Xtadä, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿La dilu chalilajz najrä yunää́ Xtadä, luxh Xtadä yunäjzani narä, ä? Rediidx nani rniä dina guiniäni lagajc xcuentä, sa'csi Xtadä ni yunäj narä laani rujn lagajc rextzuunni. ");
INSERT INTO zawNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Coḻchalilajz xtidxä, che rniä narä yunää́ Xtadä, luxh Xtadä yunäj narä. O palga ditu chalilajzni sa'csi najcni xtidxä, coḻchalilajzni sa'csi abahuiitu rextzuun ni runä. ");
INSERT INTO zawNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Rniliä́pac lojtu, nani chalilajz xtidxä, sajc gunni redzuun nani runä, luxh sujnni dzunroru sa'csi sia'a cadro yu' Xtadä. ");
INSERT INTO zawNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Luxh guiraa ni guiniablu lo Xtadä xcuentä, narä sunäni, te guluiloä xcäḻrnibee Xtadä. ");
INSERT INTO zawNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Narä sunä xhitis ni guiniabtu por laä. ");
INSERT INTO zawNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Räjpzani: ―Palga sanälajztu narä, susoobtu xtidxä. ");
INSERT INTO zawNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Dxejc siniabä lo Xtadä, te guniidxni stee nani gacnäjtu te chunäjni la'tu par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nalajznu, Xprit Dxan xten Dios, ni rnilii. Di gacdi xca' rebeṉ guedxliujni, sa'csi direni fii lojni, niclaza gumbeerenini. Niluxh la'tu numbeetuni sa'csi yunäjni la'tu, yu'ni neṉ lastootu. ");
INSERT INTO zawNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Dina gusanbisiäbä la'tu; sibisacä jiädhuiä la'tu. ");
INSERT INTO zawNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Diru gac xchej, dxejc diru rebeṉ guedxliuj fii loä, niluxh la'tu suhuiitu loä. Sa'csi nabaṉä, la'tu nabajṉzatu. ");
INSERT INTO zawNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Neṉ redxejga, dxejc sacbeetu yunää́ Xtadä, la'tu yunäjtu narä, luxh narä yunää́za la'tu. ");
INSERT INTO zawNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nani numbee Xtadä, nani rusoobza xtidxä, ni'c ruluiini sanälajzpacni narä. Luxh Xtadä sinälajzza nani sanälajz narä, näjza narä chanälazä bejṉga, luxh suluiloä lagajc narä lojreni. ");
INSERT INTO zawNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Dxejcti räjp Judas (xhet Iscariótedi) lojni: ―Dad, ¿xhini'c gunlu te guluilojlu lojtisnu, xhet näjdi loj rebeṉ guedxluijdi, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Dxejcti räjp Jesús lojni: ―Nani sanälajz narä, ni'c riu xtidxä. Ni'c chanälajz Xtadä, dxejc jiopläznää́nuni guiro'pnu Xtadä. ");
INSERT INTO zawNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nani di chanälajz narä, dini jiu xtidxä. Luxh rediidx nani biejn diajgtu, et xtidxädini; xtidx Xtadäni ni baxhaḻ narä. ");
INSERT INTO zawNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Caniä guiraa rediidxre lojtu laḻni yu'ä lojtu, ");
INSERT INTO zawNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","per Sprit Dxan xten Dios nani jiädyacnäjtu, nani guxhaḻ Xtadä xcuentä, laani suluiini lojtu guira'ti, näjza susnajni lajztu guiraa rediidx nani aguniä lojtu. ");
INSERT INTO zawNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Yäḻrbecdxilajz rusa'nä lojtu, xcäḻrbecdxilazä runidxä lojtu, et si'cdini runiidx guedxliujdi najc nani runidxä lojtu. Na'c chutu yärsia', na'cza guidxejbtu. ");
INSERT INTO zawNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Abiejn diajgtu ni guniä lojtu: Sia'ä luxh siälsacä lojtu. Paru ninälajzpactu narä, sibalajztu xcuentä che guniä sia'ä lo Xtadä, sa'csi Xtadä najc beṉroru loä. ");
INSERT INTO zawNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Scree agunixgaäni lojtu, te che soobni, dxejcru chalilajztu xtidxä. ");
INSERT INTO zawNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Diruna guiniduxhä lojtu, sa'csi asiääd nani rnibee loj guedxliujre, luxh digacdi guinibeeni narä; ");
INSERT INTO zawNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","riäjḻ gac recosre te gacbee rebeṉ guedxliuj sanälazä Xtadä, rusobäza xtidx Xtadä, runä nani gunibeeni. Coḻchastie, coḻcho' jiunejznu ree. ");
INSERT INTO zawNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Räpzani: ―Narä nacä si'c te yaguub. Xtadä najc si'c nani rusuj yajgga. ");
INSERT INTO zawNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Rebejṉ najc si'c reṉaa yajgga. Guiraa reṉaa yajgga nani xhet cajdi lojni rutiuugnini. Luxh guiraa reṉaa yajgga ni caj ninejxh lojni, rusianini te xcajru ninejxh lojreni. ");
INSERT INTO zawNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","La'tu anajctu beṉnaya xcuent rediidx nani aguniä lojtu. ");
INSERT INTO zawNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Coḻguibaṉnäj narä, sigajc ni nabaṉnää́ la'tu. Digacdi xcaj ninejxh lo te ṉaa yajg palga agurujgni lo yaguub. Sigajcza la'tu, palga guibicajtu loä, di gacdi guntu xtzunä. ");
INSERT INTO zawNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Narä nacä si'c yaguub. La'tu najctu si'c reṉaa yajgga. Nani riannäj narä, naräza riannää́ni, ni'c sajc runduxhni xtzunä, sa'csi che guibicajni loä, xhet sajcdi gunni. ");
INSERT INTO zawNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nani di chupac loä, sibicajni si'c reṉaa yajg nani rdin sa'csi xhetru rcajdi lojni, dxejcti rbijdzni, rusäḻ bejṉreni lo däj te checni. ");
INSERT INTO zawNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Palga chupactu loä, palgaza chupac xtidxä lastootu, coḻnab nani rlajztistu, luxh narä sunidxäpacni. ");
INSERT INTO zawNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Che gunpactu xtzun Dios, dxejc fii bejṉ najcpactu xpeṉä, siliä'p bejṉ xpala'n Xtadä, Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Si'cpacni sanälajz Xtadä narä, sigajcza sanälazä la'tu. Coḻchanuu lo xcäḻrinälazä. ");
INSERT INTO zawNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Palga jiutu rextidxä, sinuutu lo xcäḻrinälazä, sigajc ni abasobä xtidx Xtadä, luxh rinuä lo xcäḻrinälajz Xtadä. ");
INSERT INTO zawNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Rniä rediidxre lojtu te guibalaznäjtu narä, te si'c guibalazduxhpactu. ");
INSERT INTO zawNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Dee najc diidx ni rnibeä guntu: coḻchanälajz sa'tu si'cni sanälazätu. ");
INSERT INTO zawNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Xheti te yäḻsanälajz ni guroobru lo yäḻsanälajzre, gudeed te bejṉ xcäḻnabajṉni, guetni lacuaa resa'ni. ");
INSERT INTO zawNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","La'tu najctu resa'ä palga gusoobtu diidx nani guinibeä guntu. ");
INSERT INTO zawNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Diruna cuälaä “mos” la'tu, sa'csi di remos gan xhi rujn xlam̲reni. Luxh narä agulälaä la'tu “rexamigwä”, sa'csi guira'ti rediidx ni biejn diagä lo Xtadä aguniäza rediidxga lojtu. ");
INSERT INTO zawNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Et la'ditu gule narä, narä guleä la'tu. Guleä la'tu te guntu xtzun Xtadä, te na'cza nitloj dzuunga. Te guira'tiza nani guiniabtu lo Xtadä por laä, ni'cza guniidxni lojtu. ");
INSERT INTO zawNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Dee rnibeä guntu: coḻchanälajz sa'tu. ");
INSERT INTO zawNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Palga cuälaz rebeṉ guedxliuj la'tu, anajntu agulälazxgaareni narä. ");
INSERT INTO zawNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Paru najctu beṉ guedxliujre, sinälajzreni la'tu. Per ditu gac beṉ guedxliuj, sa'csi narä guleä la'tu te jiutu xtidx Xtadä, ni'cni rbälaz rebeṉ guedxliuj la'tu. ");
INSERT INTO zawNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Coḻsnaj lajztu diidx nani guniä lojtu, 'di te mos gac beṉroru lo xlam̲ni'. Palga basacsíreni narä, susacsízareni la'tu. Palga rusoobreni xtidxä, susoobzareni xtiidxtu. ");
INSERT INTO zawNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Guiraa recosre sunnäjreni la'tu xcentä sa'csi direni gumbee nani baxhaḻ narä. ");
INSERT INTO zawNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Paru dina niädniä lojreni direni niujn dojḻ xten xcäḻrdxechlajzreni loä, per ṉaj di gacdi guiniireni direni gacbee yu' xtojḻreni. ");
INSERT INTO zawNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nani rbälaz narä, rbälazzani Xtadä. ");
INSERT INTO zawNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Palga dina niunä nez lojreni remilagwrro, sa' nani rutru rajcdi rujn, direni niajp dojḻga; sa'csi abahuiireni redzuunga, ni'c agulälazreni narä, näjza Xtadä. ");
INSERT INTO zawNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Bejnreni si'c te guzojb diidx nani cuaj lo guijtz agujc xchero: “Gulälazreni narä, luxh xhetlidi benä.” ");
INSERT INTO zawNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Che jiääd nani gacnäj la'tu, laani sinii xcuentä, chu nacä. Laani najc Sprit ni yu' lo Xtadä, siniini didxlii. Narä suxhaḻäni lojtu; lo Xtadä guiriini jiäädni lojtu. ");
INSERT INTO zawNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Näjza la'tu siniitu diidx xcuentä, chu nacä, sa'csi guyu'tu loä cheni gusloäli cagusule'ä diidxga. ");
INSERT INTO zawNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Rediidxre rnixgaä lojtu, te didi yu' xhi gun jiajbtu te gunijttu lo xtidxä. ");
INSERT INTO zawNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Sidzujṉ dxej sibääreni la'tu dirureni gusaan jiu'tu neṉ guidoro. Sidzujṉ oṟ chutis ju't tejtu, suchaloni cayacnäjni Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Guiraa recosre sujnreni sa'csi direni gumbeepac Xtadä, niclaza narä. ");
INSERT INTO zawNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Agunixgaä rediidxre lojtu, te che guidzujṉ oṟga sinaj lajztu xcuent rediidx ni guniä lojtu. ’Dina niniä rediidxre lojtu che gusloä cagusule'ä diidx, sa'csi suganää́ la'tu. ");
INSERT INTO zawNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","N̲aj agojl guibi'ä loj nani baxhaḻ narä, luxh nicla tejtu di guiniabdiidx: “¿Caro chäälu?” ");
INSERT INTO zawNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Dxejc sa'csi aguniä recosre lojtu, ni'c cayac-huin lastootu. ");
INSERT INTO zawNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Luxh rniliä́pac lojtu, hueenru par la'tu cha'ä. Palga dina cha'ä, di gacdi jiääd lojtu nani racnäj. Niluxh palga cha'ä, suxhaḻäni lojtu. ");
INSERT INTO zawNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Luxh laani, che jiäädni lo guedxliujre, susanijni xcäriejn rebejṉ te gacbeereni xcuent dojḻ, näjza xcuent xcäḻnabaṉnaya Dios, näjza xcuent yäḻguxhtis xten Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Guluiizani xcuent dojḻ lojreni sa'csi direni chalilajz xtidxä. ");
INSERT INTO zawNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Guluiini xcäḻnabaṉnaya Dios lojreni sa'csi sibisacä lo Xtadä, luxh dirutu fii loä. ");
INSERT INTO zawNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Guluiini xcuent yäḻguxhtis xten Dios lojreni sa'csi abejn Dios yäḻguxhtis loj beṉdxab nani rnibee lo guedxliujre. ");
INSERT INTO zawNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Yu' xhidajlru diidx rlazä guiniä lojtu, niluxh digacdi gacbeetureni ṉaj. ");
INSERT INTO zawNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Che jiääd Sprit xten didxlii xten Dios, laani susanijni xcäriejntu te gacbeetu guiraa redidxgulii, sa'csi dini guinii diidx xcuentcani, siniitisni ganax rediidx nani gudeed Dios lojni te guiniini. Siniizani xcuent recos nani churu gac. ");
INSERT INTO zawNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Laani siliä'pni xpala'nä sa'csi sica'ni xhixtenä, suluiinini lojtu. ");
INSERT INTO zawNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Guiraa ni rajp Xtadä najc xtenä, ni'cni rniä suluiini xhixtenä lojtu. ");
INSERT INTO zawNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Sbale'si dxej, dxejc dirutu fii loä; dxejctiru sgaii dxej suhuisactu loä sa'csi narä sia'a lo Xtadä. ");
INSERT INTO zawNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Dxejcti räjp rexpejṉpacni lo sa'reni: ―¿Xhini'c caniini loonu? Sbale'si dxej, dxejc dirutu fii loä, dxejctiru sgaii dxej suhuisactu loä, näjza: sa'csi sia'a lo Xtadä. ");
INSERT INTO zawNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ni'cni cayäjpreni lo sa'reni: ¿Xhi dee rniini, “sbale'si dxej”? Dinu gacbee xhini'c caniini. ");
INSERT INTO zawNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Gucbee Jesús xhini'c rlajzreni guiniabdiidxreni lojni, dxejcti räjpni lojreni: ―Canabdiidx lo sa'tu xhi säloj nani guniä che guniä, sbale'si dxej, dxejc dirutu fii loä; dxejcru sbale'si dxej, suhuisactu loä. ");
INSERT INTO zawNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Rniliä́pac lojtu, la'tu soontu, niluxh rebeṉ guedxliujre sibalazduxhreni. Sac-huinduxh lastootu niluxh yäḻrac-huinre sibixhlojni yäḻrbalajz. ");
INSERT INTO zawNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Te gunaa che gaal xi'nni, rdejdni trabajw, dxejcti che aguyu' xi'nni, riäḻ lajzni gudejdni trabajw, dxejc arbaa lajzni gojl xi'nni te niguii lo guedxliujre. ");
INSERT INTO zawNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ni'cni, sigajcza rac-huin lastootu ṉaj, dxejcti che jiädhuisacätu, dxejc sii sibalajztu neṉ lastootu, luxh rut gacdi gudzucajdi yäḻrbalajzga. ");
INSERT INTO zawNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Neṉ redxejga xhetiru xhi yäḻguiniabdiidxdi guntu loä. Rniliä́pac lojtu, nani guiniabtu lo xtadä xcuentä, laani suniidxnini lojtu. ");
INSERT INTO zawNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","N̲aj xhet canabditu xcuentä. Coḻnabni, te xca'tuni, te guibalajztu. ");
INSERT INTO zawNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Aguniä guiraloj lojtu con cuent ni ruluii, niluxh sidzujṉ dxej che diruna guiniä cuent ni ruluii lojtu. Siniä didxguyasi lojtu xcuent Xtadä. ");
INSERT INTO zawNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Neṉ redxejga guiniabtu por laä. Luxh dizana guiniä siniabä narä loj Xtadä par la'tu, ");
INSERT INTO zawNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","sa'csi lagajcza Xtadä sanälajzni la'tu, sa'csi la'tu sanälajztu narä, luxh ahuililajzzatu loj Dios biriä biälä lo guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Biriä lo Xtadä xhaguibaa, biäḻä lo guedxliujre, siunezäza lo guedxliujre, sibisacä lo Xtadä xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Räjp rexpejṉpacni lojni: ―N̲aj sii caniilu guyasi, dini gac si'c redidx-xhiga'tz xten cuent ni ruluii. ");
INSERT INTO zawNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","N̲aj sii gucbeenu racbeelu guira'ti rexhicos, xhetru nanabdi guiniabdiidxrunu lojlu; ni'cni ahuililajznu biriilu lo Dios ni yu' xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Räjp Jesús lojreni: ―¿La rililajzpactu ṉaj, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Asiäddzuṉgajxh teb oṟ luxh ala bidzujṉ oṟga, che guire'chtu, cade tejtu xnez-xnejztu, te gusanxtebtu narä, luxh dina jianxtebä sa'csi Xtadä suganäj narä. ");
INSERT INTO zawNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Aguniä rediidxre lojtu te cuedxi lastootu lo guedxliujre xcuentä. Lo guedxliujre sidejdpactu trabajw, coḻgusutijp lastootu sa'csi narä abenä gaan loj guedxliujre. ");
INSERT INTO zawNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Che gulujx guniini loj rexpejṉpacni rediidxga, guläsni lojni xhaguibaa, räjpni lo Dios: ―Xtadä, abidzujṉ oṟ; gulä'p xpala'n xi'nlu te guiliä'pza xi'nlu xpala'nlu, ");
INSERT INTO zawNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","sigajc ni badeedlu lojni yäḻrnibee loj guiraa rebeṉ guedxliuj, te gac gudeedni yälnabajṉ par tejpas lo guiraa renani badeedlu lojni. ");
INSERT INTO zawNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Redee rajp yäḻnabajṉ par tejpas; numbeereni luj ni najc tejtis GuebDios, näjza narä Jesucrist nani baxhaḻlu lo guedxliujre. ");
INSERT INTO zawNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Narä gulä'pä xpala'nlu lo guedxliujre, abaluxä dzuun nani baniidxlu gunä ree. ");
INSERT INTO zawNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","N̲aj Xtadä, gulä'p xpala'nä con luj, con bala'n, con yäḻrdimbicha' ni gopä galooli che gajdli guirixtiej guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Loj rebejṉ nani baniidxlu loä, ni gulelu lo rebeṉ guedxliujre, loj reni'c abasule'ä, abaluiä chu najclu. Xtenpaclu najcreni, baniidxlureni loä, luxh rapdzu'tzreni xtiidxlu. ");
INSERT INTO zawNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","N̲aj agucbeereni guiraa rediidx ni guniä lojreni lojpaclu siäädni. ");
INSERT INTO zawNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Sa'csi rediidx nani baniidxlu loä, aguniä rediidxga lojreni, luxh ahuililajzreni rediidxga, agucbeepacreni lojlu biriä, ahuililajzreni lujpac baxhaḻ narä. ");
INSERT INTO zawNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Narä rniabä xcuentreni, dina guiniabä xcuent rebeṉ guedxliujre, ganaxtis xcuent renani abaniidxlu loä, sa'csi laareni najcreni xpejṉlu. ");
INSERT INTO zawNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Guiralii ni najc xtenä, najczani xtenlu. Guira'tiza ni najc xtenlu najczani xtenä. Agulä'pzareni xpala'nä. ");
INSERT INTO zawNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Narä diruna jia'nä lo guedxliujre, laareni sia'nrureni lo guedxliujre. Luxh narä siäḻä lojlu. Xtadä ni najc Dxanro, gucnäj renani baniidxlu loä con xtiidxlu, nani baniidxlu loä te gunreni tejsi xhigab sigajcni riennu nurnu tejsi xhigab. ");
INSERT INTO zawNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Che guyunää́reni lo guedxliujre, gucnää́ con xtiidxlu guiraa renani baniidxlu loä, luxh nicla tejreni di ninitloj, xtebtis nani gunijt te gusojb ni caj lo xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Luxh ṉaj sibisacä lojlu. Caniä rediidxre laḻ ni yu'ä lo guedxliujre, sa'csi rlazä guibaa lajzreni si'c ni rbaa lazä. ");
INSERT INTO zawNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Abasule'ä xtiidxlu lojreni, luxh rebejṉ guedxliuj rdxe'chreni lojreni sa'csi direni gac bejṉ guedxliujre sigajc ni dizana gacä bejṉ guedxliujre. ");
INSERT INTO zawNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Dina guiniabä cuäälureni lo guedxliujre, rniabä gudzucajlureni loj beṉdxab. ");
INSERT INTO zawNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Direni gac bejṉ guedxliuj, sigajc ni dizana gacä narä bejṉ guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Basyareni con xtiidxlu, sa'csi xtiidxlu najc didxguliipac. ");
INSERT INTO zawNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Sigajc ni baxhaḻlu narä lo guedxliujre, sigajcza ruxhaḻäreni te chääreni guideb guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Xcuentreni rudedä lagajc narä, te näj laareni gacnayareni con xtidxguliipaclu. ");
INSERT INTO zawNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Dina guiniabä xcuent laatisreni, rniabäza xcuent guiraa renani churu chalilajz xtidxä ni gusule'reni. ");
INSERT INTO zawNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Rlazä gun guiraareni tejsi xhigab, sigajc ni rujnlu, Xtadä, si'c runäza; te sigajc ni yu'äza con luj, sigajcza chureni con nuurnu, te gacbee rebeṉ guedxliuj luj baxhaḻlu narä. ");
INSERT INTO zawNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yäḻrnibee ni baniidxlu loä, lagajc yäḻrnibeega badedä lojreni te gunreni tejsi xhigab, si'cni riennu tejsi xhigab. ");
INSERT INTO zawNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Narä cayunnää́reni dzuun, luj cayunnäjlu narä dzuun, te jiennu tejsi dzuun, te gacbee rebejṉ guedxliuj luj baxhaḻlu narä, luxh sanälajzlureni si'cni sanälajzzalu narä. ");
INSERT INTO zawNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Xtadä, guiraa renani baniidxlu loä, rlazäza chureni cadro chuä xhaguibaa, te fiireni xcäḻrnibeä nani baniidxlu, sa'csi huinälajzlu narä galooli che gajdli guirixtiej guedxliujre. ");
INSERT INTO zawNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Xtadä ni rujn cossa'ctis, di rebejṉ guedxliuj gumbeelu, luxh narä numbeälu, luxh redee agucbeezareni luj baxhaḻlu narä. ");
INSERT INTO zawNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Aräpä lojreni chu najclu; säpäzaru lojreni te chu yäḻsanälajz sa' ni rajplu par narä neṉ lastooreni, te cuäzäza neṉ lastooreni. ");
INSERT INTO zawNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Che gulujx gunii Jesús rediidxga, huinäni rexpejṉpacni dejtz gueu Cedrón. Ro'c yu' xhiroob yuj cadro sojb guiraloj reyajg. Ro'c biu' Jesús näjza rexpejṉpacni. ");
INSERT INTO zawNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Anajn Judas, nani guto' Jesús, caro rij Jesús con rexpejṉpacni sa'csi si'csi-si'c rdxaag sa'reni ro'c. ");
INSERT INTO zawNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Dxejcti Judas, che biääd lojni te cuaa soldad roman, näj rebixhojz ni rnibee, näjza refarisee, huinätinireni ro'c, ca'reni balguejd näjza lintern, näjza spaad näjza lans. ");
INSERT INTO zawNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ni'cni Jesús, sa'csi ananxgaani xhini'c sacni, gubigni lojreni, räjpni lojreni: ―¿Chu rguiiltu? ");
INSERT INTO zawNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Räjpreni lojni: ―Jesús nani siääd guedx Nazare't. Räjp Jesús lojreni: ―Laa naräni. Näjza Judas ni bato'ni suganäjnireni. ");
INSERT INTO zawNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Che gunii Jesús lojreni: “Laa naräni”, biäxhanreni, biajbreni lo yuj. ");
INSERT INTO zawNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Dxejcti gunabdidxsac Jesús lojreni: ―¿Chu rguiiltu? Dxejc räjpzareni stehuält: ―Jesús nani siääd guedx Nazare't. ");
INSERT INTO zawNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Räjp Jesús lojreni: ―Aguniä lojtu, laa naräni. Palga narä rguiiltu, coḻgusaan jii redee. ");
INSERT INTO zawNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Guniini rediidxga te gusojb rediidx nani guniini che räjpni: “Loj guiraa ni baniidxlu, nicla tejni di ninijt.” ");
INSERT INTO zawNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Dxejcti Simón Pedr, sa'csi ca'ni te spaad, guläänini, batiuugni diag ladbee xten xmos bixhojzroga. Laj mosga najc Malco. ");
INSERT INTO zawNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Dxejcti räjp Jesús lo Pedr: ―Guluchee spaad xtenlu neṉ xpaguinni. ¿La dina tedä trabajwduxh nani agunibee Xtadä tedä, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Dxejcti resoldaadga näjza comandant, näjza reguxhtis ni rnibee rexpejṉ Israel, guṉaazreni Jesús baliibrenini. ");
INSERT INTO zawNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Dxejcti ganid huinärenini lo Anás, sa'csi najcni xtadsueegr Caifás, luxh ijzga biäjl najc Caifás bixhojzro ni rnibee lo rebixhojz. ");
INSERT INTO zawNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifás najc nani balijdx rexpejṉ Israel nanab guet te niguii xcuent rebeṉguejdxga. ");
INSERT INTO zawNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedr näjza stee xpejṉpacni huinajl dejtz Jesús. Luxh numbee bixhojzro bejṉga, biunäjzani Jesús lo xle' bixhojzro. ");
INSERT INTO zawNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Bia'nti Pedr rolä'ga. Dxejc birii xpejṉpac Jesús nani numbee bixhojzroga, guniini lo nani cayajp rolä'ga, te biu' Pedr nez lo le'ga. ");
INSERT INTO zawNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Dxejcti räjp mos gunaa ni rcanäj rolä', räjpni lo Pedr: ―¿La et näjdi luj najclu te xpejṉpac Jesús, ä? Räjp Pedr loj gunaaga: ―¡Xho gacäni! ");
INSERT INTO zawNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Dxejcti sa'csi cayacnalduxh, caguse'creni boo te cagucha'lajzreni. Näjza Pedr suganäjreni, cagucha'lajzni ro guibooga. ");
INSERT INTO zawNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Dxejcti gusloj cayujn bixhojzro yäḻgunabdiidx loj Jesús xcuent chuni'c najc rexpejṉpacni näjza xcuent xhini'c ruluiini. ");
INSERT INTO zawNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Dxejcti räjp Jesús lojni: ―Narä xhet xhiga'tzdi guniä rextidxä, guniäni lo guiraa rebejṉ guedxliuj. Basule'ä diidx neṉ rexquidobäztu näjza neṉ guidoro cadro re' guiraa rexpejṉ Israel, nicla tej diidx dina ninixhiga'tzädi. ");
INSERT INTO zawNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Xhicuent cayujnlu yäḻgunabdiidxga loä? Gunabdiidx loj renani biejn diajg xhini'c guniä lojreni. Laareni najnreni xhini'c guniä. ");
INSERT INTO zawNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Che gulujx gunii Jesús rediidxre, te rexpejṉ bixhojzroga huääz loj Jesús, räjpni lojni: ―¿La si'c rudzu' bejṉ diidx loj bixhojzro, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Dxejcti räjp Jesús lojni: ―Palga xhet laadi guniä, baluii narä xhi diidxga najc xhet laadi, niluxh palga laaca najc ni guniä, ¿xhicuent huääzlu loä? ");
INSERT INTO zawNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Dxejcti guideb naliibni baxhaḻ Anásni lo bixhojzro lo ni laa Caifás. ");
INSERT INTO zawNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Sugasijc Pedr ro' guiboo, cagucha'lajzni, che räjpreni lojni: ―¿La et näjdi luj najclu te xpejṉpac niguiiga, ä? Badzu'ni diidxga räjpni: ―¡Xho gacäni! ");
INSERT INTO zawNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Dxejcti te xmos bixhojzroga, sa'csi sa'ni najc mos ni batiu' Pedr diajgni, räjpni lojni: ―¿La et lujdi ni bahuiä neṉ huert con laani, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Dxejcti räjp Pedr stehuält: ―Nicla gumbeäni. Cuantis guniini si'c, guredxagajc te guidgaii. ");
INSERT INTO zawNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Dxejc birinäjreni Jesús rolijz Caifás, huinärenini rolijz gubernadoor cadro laaza Pretorio, niluxh direni niu' ro'c sa'csi ameer guiliejn gubijdx, te di gacdxuudxreni dxejc di gacdi gaureni lani pascw. ");
INSERT INTO zawNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ni'cni birii Pila't lojreni räjpni lojreni: ―¿Xhi yäḻquij xten niguiire siädle'ctu loä? ");
INSERT INTO zawNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Dxejcti räjpreni lojni: ―Paru di niguiire niajc te beṉ latsiaj, dinu niopnäni ladzṉaa guejblu. ");
INSERT INTO zawNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Räjp Pila't lojreni: ―Coḻchanäni, coḻhuii xho gunnäjtuni yäḻguxhtis con lagajc xleiitu. Dxejc räjp rexpejṉ Israel lojni: ―Di xleiitu gusaan ju'tnu te bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Guniireni si'c te guzojb diidx nani gunii Jesús xcuent xho guetni. ");
INSERT INTO zawNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ni'cni biusac Pila't neṉ Pretorio, gurejdxni Jesús räjpni lojni: ―¿La luj najclu ṟeii xten rexpejṉ Israel, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Dxejcti räjp Jesús lojni: ―¿La lagajc luj rniilu si'c, ä? O ¿laa yu' chureni'c naj lojlu si'c? ");
INSERT INTO zawNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Dxejcti räjp Pila't lojni: ―¿Xhixh näj narä nacä te xpejṉ Israel? Lagajc rebeṉ lajdxlu näjza rebixhojz bateedlu ladzṉaä. ¿Xhi bejnlu? ");
INSERT INTO zawNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Dxejcti räjp Jesús lojni: ―Xcäḻrnibeä dini gac yäḻrnibee sa' ni yu' guedxliujre. Paru najc xcäḻrnibeä te yäḻrnibee sa' ni yu' guedxliujre, ala cagucuaa rexpeṉä te di tedä ladzṉaa rexpejṉ nani rnibee Israel. N̲aj di xcäḻrnibeä gac yäḻrnibee sa' ni yu' lo guedxliujre. ");
INSERT INTO zawNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ni'cni räjp Pila't lojni: ―¿R̲eii najclu, ä? Räjp Jesús lojni: ―Laaca najlu nacä ṟeii. Par ni'cpac golä, par ni'cpacza biäḻä lo guedxliujre, partis gusule'ä didxliipac. Guiraa renani najn didxlii, reni'c rucuadiajgreni xtidxä. ");
INSERT INTO zawNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Räjp Pila't lojni: ―¿Xhini'c najc didxlii? Che guniini si'c gunisacni loj rexpejṉ Israel: ―Dina guidxälä nicla tej xtojḻ bejnre. ");
INSERT INTO zawNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Niluxh la'tu rajptu te costumbr, casob lani pascw, rusḻaanu te bejṉ ni yu' neṉ latzguiib. ¿Xhi najtu? ¿La rlajztu gusḻaä́ ni najc ṟeii xten rexpejṉ Israel, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Dxejcti guiragajcreni guredxa', räjpreni: ―¡Na'c gusḻaalu niguiiga! ¡Basḻaa Barrabás! Niluxh Barrabás najc te gubaan. ");
INSERT INTO zawNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ni'cni gunibee Pila't gudijnreni Jesús con duu ni yu' guechguiib lojni. ");
INSERT INTO zawNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Bejn resoldaad te coroṉguejch, bazaḻrenini yejc Jesús. Dxejcti bahuajcwrenini te ladmoraad. ");
INSERT INTO zawNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Dxejcti gusloj gubigreni lojni, te räjpreni lojni: ―¡Gubajṉ par tejpas R̲eii xten rexpejṉ Israel! Dxejc huääzreni lojni. ");
INSERT INTO zawNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Dxejcti birisac Pila't, räjpni lojreni: ―¡Coḻhuii! Acabää́ni nez lojtu, te gacbeetu dina guidxäl nicla tej xtojḻni. ");
INSERT INTO zawNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Dxejcti birii Jesús nez lojreni, yu' coroṉguejch yejcni, najcwzani ladmoraadga. Dxejcti räjp Pila't lojreni: ―¡Coḻhuii! ¡Aree niguiire! ");
INSERT INTO zawNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ni'cni, che bahuii rebixhojzro näjza rexquixhajgreni lojni, guredxa'reni, räjpreni: ―¡Coḻgucuaani lo crujz! ¡Coḻgucuaani lo crujz! Räjp Pila't lojreni: ―Lagajc la'tu coḻchanäni te gucuaatuni lo crujz. Per narä dina guidxälä nicla tej xtojḻni. ");
INSERT INTO zawNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Dxejcti räjp rexpejṉ Israel lo Pila't: ―Nuurnu rajpnu te leii, luxh xcuent leiiga, nanab guetni sa'csi najni najcni Xi'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Che biejn diajg Pila't rediidxga, bidxejbruni, ");
INSERT INTO zawNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","biusacni neṉ Pretorio, räjpni loj Jesús: ―¿Caro siäädlu? Per xhet räjpdi Jesús lojni. ");
INSERT INTO zawNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Dxejcti räjp Pila't lojni: ―¿La dilu guinii loä? ¿La dilu gan narä rapä yäḻrnibee te gucuaälu lo crujz, rapäza yäḻrnibee te gusḻaä́lu, ä? ");
INSERT INTO zawNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Räjp Jesús lojni: ―Xhetliidi yäḻrnibee niajplu loä paru dilu nica'ni xhaguibaali. Ni'cni bejṉ nani bato' narä lojlu rapduxhruni dojḻ loj ni rajplu. ");
INSERT INTO zawNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ni'cni gudiil Pila't xho nusḻaani Jesús, niluxh rexpejṉ Israel rbedxaduxhrureni, räjpreni: ―Palga luj gusḻaaluni, dilu gac xamiigw ṟeii César, sa'csi chutis ni rnii najcni ṟeii, najcni xcontraar César. ");
INSERT INTO zawNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Che biejn diajg Pila't rediidxre, gulääni Jesús, dxejcti gurej Pila't lo yagxhiil cadro rujnni yäḻguxhtis, cadro laa Litóstroros con didx-griegw sälojni naga' guisa'c, con didx-hebreo laani Gabata. ");
INSERT INTO zawNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Najcni dxej vispr lani pascw, si'cti läidxej, dxejcti räjpni loj rexpejṉ Israel: ―Coḻhuii, aree xṟeiitu. ");
INSERT INTO zawNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ni'cni guredxa'reni räjpreni: ―¡Suguetni! ¡Suguetni! ¡Bacuaani lo crujz! Dxejcti räjp Pila't lojreni: ―¿La sucuaä́ xṟeiitu lo crujz, ä? Dxejcti räjp rebixhojz ni rnibee lojni: ―Rutru ṟeiidi rajpnu, Césartis najc xṟeiinu. ");
INSERT INTO zawNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ni'cni bateed Pila't Jesús lojreni te chacuaarenini lo crujz. ");
INSERT INTO zawNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Dxejcti cua'reni Jesús, biriini ro'c guideb nuuni xcrujzni, cheni bidzujṉlireni te lajt ni laa lajt xten Calabeer, con didx hebreo laani Gólgota. ");
INSERT INTO zawNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ro'c bacuaarenini lo crujz. Bacuaazareni tio'p niguii lo stio'p crujz, tejgani te laad cuä' Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Dxejc bacuaa Pila't diidx ni chää yejc xcrujzni; rediidxga najc scree: “Jesús, beṉ Nazare't, R̲eii xten rexpejṉ Israel.” ");
INSERT INTO zawNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Xhidajl bejṉ biḻ diidx ni caj yejc xcrujzni, sa'csi lajt cadro bacuaarenini lo crujz najc gajxh ro' guejdxga, luxh didx hebreo, diidx griegw, näjza didx latiṉ bacuaareni rediidxga. ");
INSERT INTO zawNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Dxejcti räjp rebixhojzro xten rexpejṉ Israel loj Pila't: ―Na'c nucuaalu: “R̲eii xten rexpejṉ Israelni”, laacaru nacuaalu: “Laani najni, najcni ṟeii xten rexpejṉ Israel”. ");
INSERT INTO zawNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Dxejcti räjp Pila't lojreni: ―Nani abacuaä́, abacuaä́. Si'c jia'nni. ");
INSERT INTO zawNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Dxejcti resoldaad, che gulujx bacuaareni Jesús lo crujz, cua'reni rexhablojiaani bejnrenini tajp la', te cade tejreni cua'reni te la'ni. Luxh yu' stee xhajbni ni laa tunica, nadijbni, guejnni hasta lo yuj guc-cheeni. ");
INSERT INTO zawNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ni'cni räjpreni lo sa'reni: ―Na'c guitiäjznuni; do'o guidzujtnu te daad lojni, te don chu xten gacni. Si'c bejnreni te gusojb xtiidx Dios cadro caj scree: “Batiäjsreni xhablojiaä; yejcza xhabä ni bia'n gudzujtreni daad.” Ni'cni bejn resoldaad recosre. ");
INSERT INTO zawNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Niluxh cuä' xcrujz Jesús suga' xnanni, con bäjl xnanni, ni laa Marii chääl Cleofas, näjza Marii Magdaleṉ. ");
INSERT INTO zawNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Che bahuii Jesús loj xnanni, dxejc bahuiizani loj xpejṉpacni nani sanälazduxhni, räjp Jesús loj xnanni: ―Nan, ¡bahuii, aro'c xi'nlu! ");
INSERT INTO zawNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Dxejcti räjp Jesús loj xpejṉpacni nani sanälazduxhni: ―¡Bahuii, aro'c xnanlu! Ni'cni dxejcli sinä nani najc xpejṉpacni xnan Jesús rolijzpacni. ");
INSERT INTO zawNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ni'cni, sa'csi najn Jesús alagujc guiraa recos ni nanab gac te soob rextidx Dios, räjpni: ―Cayoḻä nis. ");
INSERT INTO zawNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ro'c suga' te guejs vinagr, neṉga bahuajdxreni te esponj dxejc bacuaarenini lo te yajg ni laa hisopo, guläsreni esponjga batzugrenini ro'ni. ");
INSERT INTO zawNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Che gulujx gu' Jesús vinagrga, räjpni: ―Agulujxni. Dxejcti basajb yejcni, basḻaani xaimni. ");
INSERT INTO zawNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Dxejga najc dxe vispr xte lani pascw, che ru' mandaad par lanijga. Rexpejṉ Israel di rlajzreni nia'n rebejṉga lo recrujz, sa'csi dxe sabdga najc dxej ni rusilajzreni. Ni'cni gunabreni lo Pila't guxhaḻni chu qui'ch ni'reni te guetreni, te jiäjtreni loj recrujz. ");
INSERT INTO zawNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Dxejcti bidzujṉ resoldaad, gudi'chreni guiro'p ni' nani caj te laad, sigajcza bennäjreni stee ni caj ste laadga. ");
INSERT INTO zawNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Che gubigreni lo Jesús, bahuiireni alagujtni, direni nigui'ch ni'ni. ");
INSERT INTO zawNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Tej soldaadga baqui'tzni te lans ro' xcustiini, dxejc bixe' rejn näjza nis. ");
INSERT INTO zawNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Lagajc narä Juan bahuiä recosga, ni'cni caniä rediidxre, luxh diidxga guliipacni. Lagajc narä nanä didxguliipac caniä, te chaliiza lajztu xcuentni. ");
INSERT INTO zawNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Sa'csi si'c gujc guira'ti, te guzojb xtidx Dios cadro caj: “Nicla tej xtzujtni di guech.” ");
INSERT INTO zawNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Sigajcza lo stee guijtz caj diidxre: “Sidxelojreni loj nani biguijtz te lans.” ");
INSERT INTO zawNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Che gulujx recosga, dxejcti huij José, te beṉ Arimatea, nacxhiga'tzni te xpejṉ Jesús, sa'csi rdxejbni rexpejṉ Israel, ni'c huijni loj Pila't, gunabni loj Pila't te laani guiliätni Jesús lo crujz. Cuäjbza Pila't, dxejc biääd José gulätni Jesús, sanätini togoolga. ");
INSERT INTO zawNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Näjza Nicodem̲ biääd dxejc, nani galoo huininäj Jesús te guxhijṉ. Biädnäni si'cti tiuu kiḻ te dänejxh ni najc si'c yaal ni laa mirra näjza áloes. ");
INSERT INTO zawNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Dxejcti cua'reni Jesús batejbrenini te la' lad lino, basälzareni däjga ni laa mirra con áloes, sa'csi si'c najc xcostumbr rexpejṉ Israel che rucua'tzreni te togool. ");
INSERT INTO zawNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Gajxh cadro cuaj Jesús lo crujz, yu' te huert, neṉ huertga yu' te bacoob si'c te biliää, cadro nicla tej bejṉ gajd guiga'tz. ");
INSERT INTO zawNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Sa'csi abidzujṉ dxej vispr lani pascw xten rexpejṉ Israel, luxh gajxh suga' biliääga, neṉga gudixhreni Jesús; si'c biga'tztini. ");
INSERT INTO zawNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Primer dxej xten xmaanga, cäjyru, gajd lo guedxliuj jianij che huij Marii Magdaleṉ lo baaga. Che bidzujṉni ro' baaga, bahuiini agubicaj guij ni suga' ro' baaga. ");
INSERT INTO zawNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Dxejcti ruxuṉni gubi'ni te huiye'tzni lo Simón Pedr näjza lo stee xpejṉpac Jesús ni sanälazduxhni, räjpni lojreni: ―Ahuilääreni Dad neṉ baa, luxh dinu guidon caro sanärenini. ");
INSERT INTO zawNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Dxejc biriguxuṉ Pedr näjza stee bejṉga, huijreni nez lo baa. ");
INSERT INTO zawNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ruxuṉ guiro'preni. Niluxh stee bejṉga ruxuṉduxhruni loj Pedr. Laani ganid bidzujṉni lo baaga. ");
INSERT INTO zawNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Dxejcti guretäṉni te bahuiini neṉ ba-biliääga. Bahuiini te laad naga' relajdtis nani bidejb Jesús, luxh dini niu' neṉ baaga. ");
INSERT INTO zawNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Dxejc bidzuṉgajc Pedr, biugajcni neṉ baaga, bahuiini naga' relajdga te laad. ");
INSERT INTO zawNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Bahuiizani lajd ni guyu' yejcni, ni'c nie'tni saru, naga'ni te laad. ");
INSERT INTO zawNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Dxejcti biu' stee bejṉga nani bidzujṉ ganid. Che bahuiini neṉ baaga, huililajzni gubaṉsac Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Sa'csi gajdreni gacbee ni caj lo reguijtz, cadro caj nanab guibaṉsacni loj rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Dxejc gubisac guiro'p rexpejṉpacni rolijzreni. ");
INSERT INTO zawNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Laltis suga' Marii cuä' baaga, cayoonni. Ni'cni laḻ ni cayoonni, basajb lojni te bahuiini neṉ baaga. ");
INSERT INTO zawNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Dxejcti bahuiini lo tio'p xangl Dios, najcwreni ladnolbäj, sobga'reni, tejni nez cadro gojt yejc Jesús, steeni nez cadro gojt ni'ni. ");
INSERT INTO zawNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Dxejcti räjpreni lojni: ―Nane', ¿xhicuent roonlu? Räjpni lojreni: ―Sa'csi sanäreni Dad, luxh dina ganä caro huisa'nrenini. ");
INSERT INTO zawNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Che gulujx guniini si'c, gubiréni, dxejc bahuiini loj Jesús suga' ro'c, niluxh dini niembee Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Dxejc räjp Jesús lojni: ―Nane', ¿xhicuent roonlu? ¿Chu rguiillu? Marii bejn xhigab laa dade' ni rcanäj huertga, ni'c räjpni lojni: ―Dad, palga luj sanäluni, gunii caro gudixhluni te guiliäsä́ni te chanää́ni. ");
INSERT INTO zawNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Dxejcti räjp Jesús lojni: ―¡Marii! Dxejc gubiré Marii, räjpni neṉ xtidx hebreo: ―¡Raboni! (Säloj diidxga “Mastr”.) ");
INSERT INTO zawNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Dxejcti räjp Jesús lojni: ―Na'c guiniaazlu narä sa'csi gadna cha'a lo Xtadä xhaguibaa. Huij loj rebetzä, huiye'tz lojreni, cha'a lo Xtadä, näjza Xtadtu, loj Xtiozä näjza Xtiooztu. ");
INSERT INTO zawNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Dxejcti huij Marii Magdaleṉ, bidzujṉni loj rexpejṉpacni badeedni didxcoob, räjpni: ―Abahuiä lo Dad Jesús. Räjpzani lojreni guiraa recos ni gunii Jesús lojni. ");
INSERT INTO zawNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Che gojl gudxej, najcni dumingw, primer dxej xten xmaan, abiäudzu'tz ro lä' ro' yu' cadro tre' rexpejṉpacni, sa'csi rdxejbreni rexpejṉ Israel. Chela bidzujṉ Jesús, guzujni nez galäiireni, räjpni lojreni: ―Suchu yäḻrbedxi lastootu. ");
INSERT INTO zawNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Che guniini si'c, baluigajcni reṉaani lojreni näjza cuä' xcustiini. Ni'cni bibaduxhlajz rexpejṉpacni che bahuiireni lo Dad Jesús. ");
INSERT INTO zawNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Dxejc räjp Jesús lojreni stehuält: ―Suchu yäḻrbedxi lastootu. Si'c ni baxhaḻ Xtadä narä, si'cza ruxhaḻä la'tu. ");
INSERT INTO zawNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Che gulujx guniini rediidxga, balejbni yejcreni, räjpni, lojreni: ―Suguibajṉ Sprit Dxan xten Dios neṉ lastootu. ");
INSERT INTO zawNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Rextojḻ rebejṉ nani siäḻlajztu, sibicajreni. Rextojḻ rebejṉ nani ditu jiäḻlajz, siannäjreni redojḻga. ");
INSERT INTO zawNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomás, ni laaza Didimo, najcni te retzubitio'p xpejṉpac Jesús. Rutini che biääd Jesús loj rexpejṉpacni. ");
INSERT INTO zawNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Dxejcti räjp rexpejṉpacni lojni: ―Abihuiinu loj Jesús, agubaṉsacni loj rebeṉgut. Dxejcti laani räjpni lojreni: ―Palga dina fiä loj reṉaani cadro caj seen xten reclaab, palga dina guqui'tzä bicueṉaä́ cadro guyu' claabga, guqui'tzäza ṉaa cadro bixal cuä'ni, di lazä chalii gubaṉsacni loj rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Che gudejd xhujṉ dxej, tresac rexpejṉpacni neṉ yu', nadxaagza Tomás lojreni. Niäudzu'tz yu'ga, luxh chela gucbeereni abidzujṉ Jesús, guzujni galäiireni, räjpni lojreni: ―Suchu yäḻrbedxi lastootu. ");
INSERT INTO zawNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Dxejcti räjpni loj Tomás: ―Baqui'tz bicueṉaalu ree loj patṉaä, basäḻza ṉaalu cuä'äre, na'c ractio'p lajzlu, huililajzpac gubaṉsacä loj rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Dxejcti räjp Tomás lojni: ―¡Xtadä, Xtioozä! ");
INSERT INTO zawNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Dxejcti räjp Jesús lojni: ―Sa'csi abahuiilu loä, Tomás, huililajzlu. Chicbaa renani mase direni fii, rililajzreni xtidxä. ");
INSERT INTO zawNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Xhidalroduxhru dzuun bejn Jesús nez loj rexpejṉpacni, nani di nicaj lo guijtz. ");
INSERT INTO zawNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Redzuunre nani bejn Jesús nani cuaj lo guijtzre cuajni te chalilajztu diidxre: Jesús najc Crist, nani cabäjz rebejṉ jiääd, Xi'n Dios. Luxh che chalilajz te bejṉ xtiidxni, sajpni yäḻnabajṉ par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Dxejcti baluiloj Jesús loj rexpejṉni ro' nisdoo ni laa Tiberias. Scree baluilojni lojreni. ");
INSERT INTO zawNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nadxaag sa' rebejṉre: Simón Pedr, Tomás ni laaza Didimo, näjza Natanael, nani siääd Caná xten Galilee, rexi'n Zebedeo, näjza stio'p rexpejṉpacni. ");
INSERT INTO zawNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Dxejcti räjp Simón Pedr loj resa'ni: ―Chanazä bäjl. Räjpreni lojni: ―Näjza nuure chonnu. Dxejcti sääreni, huä'preni neṉ te barcw. Guideb guxhijṉga xhet bäjldi gunaazreni. ");
INSERT INTO zawNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Che acayanij loj guedxliuj, suga' Jesús ro' nisdooga, di rexpejṉni niembeeni. ");
INSERT INTO zawNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ni'cni räjp Jesús lojreni: ―Rexi'nä, ¿la xhet bäjldi rajptu, ä? Räjpreni lojni: ―Xhet rajpdinu. ");
INSERT INTO zawNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Dxejcti räjpni lojreni: ―Coḻgusäḻ xquijxhtu ladbee xten barcwga, te ro'c siniaaztuni. Dxejcti bacuaareni guijxhga ladbee xten barcwga, dxejcti ameer diniajcdi nibääreni guijxhga ro'c sa'csi gudxadotzu'tzni bäjl. ");
INSERT INTO zawNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Dxejcti bejṉ nani sanälazduxh Jesús, räjp loj Pedr: ―Laa Dad Jesús. Che biejn diajg Simón Pedr laa Dad Jesús, gotgajcni xhablojiaani sa'csi ladxhagjiättis najcwni sa'csi canaazni bäjl, dxejcti gutiäjsni lo nisdoo. ");
INSERT INTO zawNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Sgaii rexpejṉpacni biädnäreni rebarcwga sa'csi ameer guidzujṉreni ro' nisdooga, si'cti tegayuu metrtis cayäädx. Siädnäzareni guijxh guidxa rebäjl. ");
INSERT INTO zawNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Che bidzujṉreni ro' nisdoo, bahuiireni re' guiboo, ro'c dzuub te bäjl näjza yätxtiil cague'. ");
INSERT INTO zawNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Dxejcti räjp Jesús lojreni: ―Coḻtanä gaii bäjl nani entis gunaaztu. ");
INSERT INTO zawNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Dxejcti huij Simón Pedr, gulääni guijxhga, guidxani bälro. Guyu' si'cti te gayuu garol con choṉ bäjl neṉ guijxhga, niluxh dini niräsya' mase guyu' xhidalduxh bäjl neṉni. ");
INSERT INTO zawNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Dxejcti räjp Jesús lojreni: ―Coḻtaa te gauxharejntu. Nicla tej rexpejṉpacni dini niabdiidx lojni: “¿Chu luj?” sa'csi anajnreni laa Jesúsni. ");
INSERT INTO zawNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Dxejcti cua' Jesús yätxtiil, badeedni lojreni, sigajcza rebäjl. ");
INSERT INTO zawNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Dee najc ni riojṉ huält baluilojni loj rexpejṉpacni, che gubaṉsacni loj rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Che gulujx gudajwreni, räjp Jesús loj Simón Pedr: ―Simón xi'n Jonás, ¿la sanälajzrulu narä loj chu stee, ä? Räjpni lojni: ―O'n, Dad, luj najnlu sanälazä luj. Räjp Jesús lojni: ―Gojp rexilä'ä. ");
INSERT INTO zawNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Räpsacni lojni ni rojp huält: ―Simón, xi'n Jonás, ¿la sanälajzlu narä, ä? Räjpni lojni: ―O'n, Dad. Luj najnlu sanälazä luj. Räjpni lojni: ―Gojp rexilä. ");
INSERT INTO zawNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Räpsacni lojni ni riojṉ huält: ―Simón xi'n Jonás, ¿la sanälajzlu narä? Guc-huin lastoo Simón Pedr sa'csi gunabdiidx Jesús lojni choṉ huält: “¿La sanälajzlu narä?” Dxejcti räjp Simón lojni: ―Dad, luj najnlu guira'ti. Luj najnlu sanälazä luj. Räjp Jesús lojni: ―Gojp rexilä. ");
INSERT INTO zawNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Rniliä́pac lojlu, che gujclu bi'nru, lagajc luj rajcwlu xhajblu, rijlu cadrotis rlajzlu. Che anajclu beṉgool, susgaatislu ṉaalu te gushuajcw ste'ca bejṉ xhajblu, te chanäreni luj cadro di rlajzlu. ");
INSERT INTO zawNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Luxh diidxga gunii Jesús te cagusule'ni xho gugu'treni Pedr te guiliä'pni xpala'n Dios. Che gulujx guniini si'c, räjpni loj Pedr: ―Gudanajl narä. ");
INSERT INTO zawNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Che gubiré Pedr, bahuiini loj stee xpejṉni, nani sanälajzru Jesús, siädnajlni dejtzreni. Lagajc bejṉre ni gurej cuä' Jesús lo lult xchej, ni räjpza loj Jesús: “Dad, ¿chuni'c najc nani guto'lu?” ");
INSERT INTO zawNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ni'cni, che bahuii Pedr lojni, räjpni loj Jesús: ―Dad, deea', ¿xhi gun dee? ");
INSERT INTO zawNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Dxejcti räjp Jesús lojni: ―Palga rlazä jia'nni che guibisacäli loj guedxliujre, ¿xhixh najcni? Basaanni. Luj gudanajl narä. ");
INSERT INTO zawNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ni'cni bire'ch diidx lagajc loj resa'ni, di bejṉga guet. Di Jesús niäjb lojni dini guet, alga räjpni: “palga rlazä jia'nni loj guedxliujre che guibisacäli lo guedxliujre, ¿xhixh najcni?” ");
INSERT INTO zawNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Luxh bejṉga najc narä, xpejṉ Jesús nani bahuiloj guiraa recosre, nani bacuaazareni. Anadonnu didxliipac najc recos nani rniini. ");
INSERT INTO zawNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yu'ru xhidalduxh dzuun ni bejn Jesús. Palga gucuaanu guiralii redzuun ni bejn Jesús, nicla lo guedxliujre di gaḻ chu reguijtz cadro xcajni.");
INSERT INTO zawNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Xamigwä Teófilo, abacuaä lojlu xcuent guiraa recos nani bejn Jesucrist näjza nani baluii Jesucrist, che guslojlini, ");
INSERT INTO zawNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hasta dxejli ni huäjsni xhaguibaa. Gunibexgaani xhini'c gun renani guleni gac xpejṉpacni. Sprit Dxan xten Dios baluii Jesucrist xhi guiniini lojreni. ");
INSERT INTO zawNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Gudejd Jesucrist trabajwduxh, dxejcti gujtni. Dxejc gubaṉsacni lo rebeṉgut, baluilojni lo rexpejṉpacni. Tiuu dxej baluilojni loj rexpejṉpacni balti huält te gacbeereni agubaṉsacni. Guniizani lojreni xcuent xcäḻrnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Che gudejd tiuu dxejga, batojp Jesucrist rexpejṉpacni, gunibeeni na'c guiriireni guedx Jerusalén, cuääzreni jiääd Sprit Dxan xten Dios nani aguniipac Dios jiääd. Räjpni: ―Dee abiejn diajgtu guniä́ lojtu. ");
INSERT INTO zawNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan batiobnis con nis, luxh ṉaj guxii dxej cayäädx dxejcru siääd Sprit Dxan xten Dios te cuääzni neṉ lastootu. Si'c guirobnistu ―räjpni. ");
INSERT INTO zawNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Lagajc dxejc che abidojpreni loj Jesucrist, gunabdiidxreni lojni: ―¿La ṉaj gudedsaclu yäḻrnibee lo rexpejṉ Israel, ä? ");
INSERT INTO zawNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Dxejcti räjp Jesucrist loj rexpejṉpacni: ―Di riäjḻ gacbeetu xcuent redxej näjza retiemp nani abasobxgaa Dios con xcäḻrnibeeni. ");
INSERT INTO zawNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","La'tu sica'tu yäḻrnibee che abiääd Sprit Dxan xten Dios neṉ lastootu. Dxejc chatie'chtu xtidxä näjza rextzunä neṉ guedx Jerusalén, neṉ guiraa reguedx Judea, neṉ guiraa reguedx Samaria, näjza neṉ guideb guedxliuj ―räjpni. ");
INSERT INTO zawNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Gulujxtis gunii Jesucrist rediidxga, luxh laḻni cahuii rebejṉ lojni huäjsni xhaguibaa, sa'csi gurejdx Diosni. Dxejc biääd te za, biu'ni neṉ zaga. Ro'cti diru rebejṉ nuhuii lojni. ");
INSERT INTO zawNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Laḻni cadxelodxi rebejṉ xhaguibaa cadro gunitloj Jesucrist, tiop angl xten Dios ni najcw ladnol suga' gajxh cadro suga'reni. ");
INSERT INTO zawNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Dxejc räjp reangl loj rebejṉ: ―¿Xhi rajctu beṉ Galilee? ¿Xhicuent cadxelojtu xhaguibaa? Abahuiitu xho huäjs Jesucrist siini xhaguibaa. Lagajc si'c guibisacni ―räjpreni. ");
INSERT INTO zawNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Dxejc birii rebejṉ yejc dajne' ni laa Dan Oliib, siireni guedx Jerusalén. Dan Oliib suga' gajxh Jerusalén. Gusajrenini si'cni rnii leii sajc sareni dxej ni rusilajzreni. ");
INSERT INTO zawNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Che biu'reni Jerusalén, bidzujṉreni ro' yu' cadro rbäzlaareni. Yu'ga najc jiaa yejc stee yu'. Ro'c rbäzlaa Pedr näjza Jacoob, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacoob xi'n Alfeo, Simón nani laaza Zelote, näjza Judas bejtz Jacoob. ");
INSERT INTO zawNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ro'c yu' guiraareni näjza regunaa näjza Marii xnan Jesucrist näjza rebetzhuin Jesucrist. Cabejdx, canabreni loj Dios; tejsi najc xhigab xten guiraareni. ");
INSERT INTO zawNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nadxagsa' te gayuu gajḻ bejṉ. Dxejcti huisulii Pedr galäiireni, räjpni loj rebejṉ: ");
INSERT INTO zawNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Caniä lojtu, resa'ä, nanabpac soob xtidx Sprit Dxan xten Dios ni bacuaa toDavid lo guijtz xcuent Judas, nani bato' Jesucrist loj renani gunaazni. ");
INSERT INTO zawNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Gujc Judas sa'nu, bejnzani lagajc dzuun ni biennu. ");
INSERT INTO zawNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Cua' Judas meel ni badeedreni lojni che bato'ni Jesucrist. Che gulujx bejnni dzunguijdx ni bejnni, badedsacni meel lojreni. Gusiireni te la' yuj. Dxejcti lagajc Judas basäḻ duu guejnni, guzäbnajḻni lo bej, gujtni. Gusaguijni, dxejcti biräjs xque'ni birii guiraa reziini. ");
INSERT INTO zawNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Che biejn diajg rebejṉ Jerusalén si'c, gulälajreni yujre Acéldama, ni säloj yurejn. ");
INSERT INTO zawNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Neṉ guijtz ni ḻaa Salmos abacuaa toDavid rediidxre: Sujianxteb rolijzni; na'c cuääzru bejṉ rolijzni; näjza: Suxca'za ste'ca niguii xtzuunni. ");
INSERT INTO zawNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","N̲aj nanab cuenu stee niguii ―räjp Pedr―. Nanab gacni tej ni gusanäj nuunu guideb redxej ni guyunäj Jesucrist nuunu, ");
INSERT INTO zawNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","dxejli ni gusloj batiobnis Juan hasta dxej ni huäjs Jesucrist xhaguibaa. Te gacnäj niguiire nuunu gusule'nu diidx gubaṉsacpac Jesucrist lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Dxejc gulääreni tiop niguii lojreni, tejni laa José Barsabás ni rbälajreni Justo, steeni laa Matías. ");
INSERT INTO zawNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Gurejdx, gunabreni lo Dios, räjpreni: ―Dad, Dios, ni racbee lastoo guiraa rebejṉ, baluii loonu con ni najc niguii ni agulelu loj guiro'p niguiire, ");
INSERT INTO zawNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","te jiu'ni lo dzuun näjza lo yäḻapost ni basa'n Judas cheni sääni garenca nejz ―räjpreni. ");
INSERT INTO zawNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Dxejcti gudzujtreni daad te gulereni lo guiro'preni. Che biajb daad, gulereni Matías. Dxejc bigabnäj Matías stzubiteeb reapost te gujcreni tzubitio'p apost. ");
INSERT INTO zawNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Che bidzujṉ dxej ni rajc lanij xten Pentecostés, tre' guiraareni tejsi lajt neṉ te yu', ");
INSERT INTO zawNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","chela gusloj cayubej xhaguibaa si'c te beroduxh, bachajni guideb neṉ yu' cadro suga'reni. ");
INSERT INTO zawNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Dxejc bahuiireni astoo carechxteb xhidajl bale' casanij rebajlga yejc tejga reni sojb ro'c. ");
INSERT INTO zawNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Biu'ti Sprit Dxan xten Dios neṉ lastoo guiragajcreni. Dxejc gusloj caniireni garen-garen didxsaj si'ctisni badeed Sprit Dxan xten Dios guiniireni. ");
INSERT INTO zawNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Neṉ redxejga, xhidajl rexpejṉ Israel ni sasanäjpac xtidx Dios bidzujṉ guedx Jerusalén. Xhidajl lajt biriireni siäädreni. ");
INSERT INTO zawNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Che biejn diajgreni guyubej beduxhga, bidojp rebeṉ xhidaalga, bachaag sa'reni. Rdxeloduxh rebeṉ xhidalga sa'csi cayejn diajgreni canii reapost xtidxsajpac cade tejreni. ");
INSERT INTO zawNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Cadxelojreni räjpreni: ―¡Bahuilaare! ¿La et beṉ Galileedi renani canii, ä? ");
INSERT INTO zawNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Xhoxh riejn diajgnu caniireni xtiidxpacnu si'ctis ni rniinu laadxnu, ä? ");
INSERT INTO zawNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Najcnu beṉ nacióṉ Partia, beṉ nacióṉ Media, beṉ región Elam, beṉ Mesopotamia, beṉ Judea, beṉ estad Capadocia, beṉ región Ponto, näjza beṉ Asia. ");
INSERT INTO zawNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Najczanu beṉ distrit Frigia, beṉ estad Panfilia, beṉ nacióṉ Egipto, näjza bejṉ ni siääd stelaad Cirene, te estad neṉ Africa. Loj rebejṉ ni siääd Roma yu' reni najc xpejṉ Israel, yu'za reni bazuxhijb lo Dios sa'csi rililajzreni si'cni rililajz rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Yu'za beṉ Creta. Yu'za beṉ nacióṉ Arabia. Guiragajcnu riejn diajgnu caniireni xtiidxpacnu si'ctis ni rniinu laadxnu. Caniireni loonu xcuent recosroduxh ni cayujn Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bidxeloduxh rebeṉ xhidaalga, dijiejṉ xhi xhigab gunreni. Räjpreni lo sa'reni: ―¿Xhi säloj dee? ");
INSERT INTO zawNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Dxejcti guyu' rebejṉ ni baxhiznäjreni, räjpreni: ―Agusojz redee. ");
INSERT INTO zawNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Dxejcti gusulii Pedr näjza tzubiteeb sa'ni, guredxa'ni guniini lo rebeṉ xhidaalga: ―Guejbtu, rexpejṉ Israel, nani rbäjz distrit Judea näjza guedx Jerusalén. Coḻcuadiajg diidx nani guiniä. ");
INSERT INTO zawNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Xhet sojzdinu si'cni cayujntu xhigab. Rsilru ṉaj, entis gojl rcagaa. ");
INSERT INTO zawNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Dxejc scree gunii Joel che guniini xtidx Dios agujc xchero. ");
INSERT INTO zawNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Räjp Dios: Sidzujṉ dxej che guxhaḻä Xsprit Dxanä cuääzni neṉ lastoo guiraa rebejṉ. Rexingaantu näjza rexindxa'ptu sinii xtidxä xcuent recos ni gajd gac. Rexi'ntu sinixcaḻ, rextadgoldootu suluiloj bacaḻ recos nani guluiä lojreni. ");
INSERT INTO zawNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Guxhaḻä Xsprit Dxanä loj guiraa reni siädnajl narä. Siniireni rediidx ni gudedä lojreni xcuent recos nani gajd gac. ");
INSERT INTO zawNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Suluiä lojtu balti senro xhaguibaa näjza lo guedxliuj. Resenro ni gac najc rejn con guiboo, luxh guxh sire' si'c te za. ");
INSERT INTO zawNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Sicäjy loj gubijdx, sajc bäii si'c rejn. Sajc guiraa recosre, dxejcru sidzujṉ dxeduxh che jiälsacä narä, Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Dxejc guiraa rebejṉ nani cueedx guiniab gacnäj Diosreni, reni'c siḻiaa lo dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Räjp Pedr lojreni: ―Rexpejṉ Israel, coḻcuadiajg xtidxä. Dios baluii Jesucrist, beṉ Nazare't, lojtu por recosro, remilagwr, reseen nani bejnni nez lojtu. Lagajc Dios badeed yäḻrnibee loj Jesucrist te bejnni redzunroga. La'tu nancheetu dee. ");
INSERT INTO zawNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Galooli ananchee Dios xhi guntu loj Jesucrist Xi'nni. Basaanza Dios bateedtu Jesucrist ladzṉaa rebeṉguijdx te bacuaareni Jesucrist lo crujz te bagu'trenini. ");
INSERT INTO zawNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Baspaṉsac Dios Jesucrist, basḻaa Diosni ladzṉaa yäḻgujt, sa'csi di niajcdi nica' yäḻgujtni par tejpas, sa'csi laani rnibee lo yäḻgujt. ");
INSERT INTO zawNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Che gubaṉsac Jesucrist, guzojb diidx ni bacuaa David lo guijtz xcuent Jesucrist. Räjp David lo Dios: Guira dxej ruhuiä lojlu, Dios. Suga'lu xladbeä cayacnäjlu narä te di guidxejb lastoä. ");
INSERT INTO zawNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ni'cni bibalajz lastoä, guniäza lojlu lacti rbaa lazä. Rbalazä sa'csi suhuiilu narä che guetä. ");
INSERT INTO zawNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Dizalu gusaan jia'n xaimä neṉ baa. Dizalu gusaan gudx tiejxh xi'nlu nani sanälajzlu. ");
INSERT INTO zawNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Abaluiilu loä xho guibaṉä par tejpas. Sibalazduxhä sa'csi guibaṉnää́ luj, si'c räjp David xcuent Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Räjp Pedr: ―Guyasi guiniä lojtu agujc xchero gujt David. Aguyutzu'tzni neṉ baa. Sajc guihuiinu baa cadro biga'tz David. ");
INSERT INTO zawNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Gunii David xtidx Dios. Che nabajṉli David bia'n diidx gudeed Dios te xajgni ni guirilaj Crist, luxh laani gacni ṟeii si'cni gujc David. ");
INSERT INTO zawNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Sa'csi baluixgaa Dios recosre lo David, ni'c räjp David sibaṉsac Crist lo rebeṉgut sa'csi di Dios gusaan jia'n xaimni neṉ baa, dizani gusaan gudx tiejxhni. ");
INSERT INTO zawNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Guläs Dios Jesucrist lo rebeṉgut. Nuure bahuiloonuni, najcnu testiigw gubaṉsacni lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Gurejdx Dios Jesucrist. N̲aj nabajṉ Jesucrist xhaguibaa, nabejni xladbee Dios ro'c canibeeni. Badeed Dios Xsprit Dxanni loj Jesucrist si'cni bia'n diidx. N̲aj abaxhaḻ Jesucrist Sprit Dxan lo guedxliuj. Jesucrist cayujn guira'ti nani cahuiitu, nani cayejn diajgtu nadxej. ");
INSERT INTO zawNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Di David nij xhaguibaa, sa'csi lagajc David räjp: Gunii Dios lo Dad nani rnibee loä: “Gurej xladbeä ");
INSERT INTO zawNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","che guidzujṉli dxej gudzugä guiraa reni rdxe'ch lojlu te gacbeereni luj rnibeelu guira'ti.” ");
INSERT INTO zawNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Rniliä́pac lojtu ―räjp Pedr―. La'tu bacuaatu Jesús lo crujz. Ni'cni, coḻgacbee, guiraatu xpeṉ Israel, abejn Dios gac Jesúsre Dad nani rnibee loonu. ");
INSERT INTO zawNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Che biejn diajgreni laareni bacuaareni Jesús lo crujz, guc-huinduxh lajzreni. Räjpreni lo Pedr näjza lo reapost ni suga' ro'c: ―Aiilu, resa'nu, ¿xhini'c jiennu ṉaj? ");
INSERT INTO zawNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Dxejcti räjp Pedr lojreni: ―Coḻgusiech lajztu, coḻguirobnisza, sa'csi ni'c najc te seen rlajztu chanajltu Jesucrist, te si'c jia xtojḻtu. Dxejc suniidx Dios Sprit Dxan cuääz neṉ lastootu. ");
INSERT INTO zawNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Si'c rlajz Dios guniidx Xsprit Dxanni lojtu näjza loj rexi'ntu, näjza lo rebejṉ ni rbäjz zijtru, näjza loj guiragajc rebejṉ nani cueedxni ―si'c gunii Pedr lo rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Dxejcru gunii Pedr xhidajlru diidx, balijdxni rebejṉ: ―Coḻguirii loj rebeṉ latsiaj ni re' lo guedxliuj ṉaj, te ḻaatu lo dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Xhidajlreni huililajz rediidxga. Dxejcti gurobnisreni sa'csi huililajzreni xtidx Dios. Lagajc dxejga huililajz si'cti choṉ miḻ bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Sanuutis rusoobreni diidx ni baluii reapost, bibalazduxhreni sa'csi bidxaag sa'reni con rexpejṉ Jesucrist, gudaunäj sa'reni si'c gudaunäj Jesucrist rexpejṉpacni, bidojpreni tejsi lajt te guniireni lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Bidxeloduxh guiraa rebejṉ luxh bejn reapost redzunro, remilagwr. ");
INSERT INTO zawNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bichaag sa' renani huililajz xtidx Dios. Bachagsa'reni xhixtenreni te tejsi gojpreni guiraa xhixtenreni. ");
INSERT INTO zawNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bato'reni xhixtenreni, dxejcti badeedreni meel lo sa'reni si'ctis ni caquiin chutis tejreni. ");
INSERT INTO zawNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Guixe-guixee bidojpreni neṉ guidoro xten Israel. Tejsi najc rexhigabreni. Gudaunäj sa'reni rolijz cadetejreni, guiraareni bibalaznäduxh sa'reni. ");
INSERT INTO zawNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Gulä'preni xpala'n Dios. Guiraa rebejṉ gunii rexpejṉ Jesucrist najc beṉsa'c. Guixe-guixee batie' Dios xhidajlru bejṉ nani rililajz xtiidxni, badzucajni rextojḻreni, dxejc bachaagreni lo rexpejṉ Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Guyu' te dxej sää Pedr näjza Juan nez loj guidoro si'cti rcachoṉ gudxej. ");
INSERT INTO zawNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Guyu' te niguii nani racxhuu ni'ni, digacdi sani che gojllini. Guixe-guixee rile'c bejṉ niguiiga ro' puertroga xten guidoro. Puertroga laa Sacrú. Ro'c rbejni rniabni gojn lojreni riu' guidoo. ");
INSERT INTO zawNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Che bahuiini agojl jiu' Pedr näjza Juan neṉ guidoroga, gunabni te gojn lojreni. ");
INSERT INTO zawNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Dxejcti bahuii Pedr näjza Juan lojni. Räjp Pedr lojni: ―¡Bahuii loonu! ");
INSERT INTO zawNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Che biejn diajg niguiiga xtidx Pedr, bahuiini lojreni sa'csi naani sudeedreni meel lojni. ");
INSERT INTO zawNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Räjp Pedr lojni: ―Xhetliidi meeldi rapä, nani rapätis sunidxä lojlu. Xcuent xcäḻrnibee Jesucrist, beṉ Nazare't, rniä lojlu: ¡Gusulii! ¡Gusaj! ―räjpni. ");
INSERT INTO zawNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Dxejcti gunaaz Pedr ṉaani, guläsnini. Biligajc ni'ni, gusutijp ni'ni. ");
INSERT INTO zawNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Huisuyäḻni, gusajni. Biunäjni Pedr näjza Juan neṉ guidoro. Rsiajni, rtiäsni, calä'pni xpala'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bahuii xhidajl bejṉ lojni neṉ guidoro, rsiajni, calä'pzani xpala'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Biembeereni laa niguii ni rbej ro' puertro xten guidoro, rniabni gojn. Guiraareni bidxeloduxhreni bahuiireni xhi gusajc niguii ni gucxhuu ni'ni. ");
INSERT INTO zawNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ro' guidoroga yu' te cordoor ni laa Cordoor xten Salomón. Ro'c suga' Pedr näjza Juan, naztzu'tz niguiiga ṉaareni. Ruxuṉ guiraa rebejṉ bidzujṉ neṉ cordoorga. Bidxelojreni sa'csi arsiaj niguii ni gucxhuu ni'ni. ");
INSERT INTO zawNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Che bahuii Pedr lo rebejṉ räjpni lojreni: ―¿Xhicuent rdxeloj guejbtu, rexpejṉ Israel? Pet naatu nuure basiajcnu ni' niguiire. Xhet nuudire basiajcnu ni'ni. Xcuent xcäḻrnibee Jesucrist biajc ni' niguiire. ");
INSERT INTO zawNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Xtiooznu, ni najc Xtiooz toxtadgoldoonu Abram, toxtadgoldoonu Isaac, näjza toxtadgoldoonu Jacoob, lagajc Diosga abadeed yäḻrnibee loj Xi'nni Jesús. Niluxh la'tu bateedtuni ladzṉaa reguxhtis. Che rlajz Pila't ni rnibee nusḻaa Jesucrist, ditu nicäjb niriini, alga guniyajtuni nez loj Pila't. ");
INSERT INTO zawNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Niluxh la'tu baṟo'ntu Xi'n Dxan xten Dios nani rujn ganax dzunsa'c. Alga gunabtu birii te niguii nani bagu't bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jesucrist rudeed yäḻnabajṉ, luxh la'tu gunabtu bacuaareni Jesucrist lo crujz. Gulässac Dios Jesucrist lo rebeṉgut. Bahuiloonu nabajṉ Jesucrist, najcnu testiigw gubaṉsac Jesucrist lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Cahuiitu loj niguiire nani gucxhuu ni'ni, luxh rumbeetuni. Xcäḻrnibee Jesucrist abasiajc niguiire, sa'csi huililajzni. Sa'csi huililajznu xtidx Jesucrist, ni'c biajcni te najcni si'cni rhuiituni ṉaj. ");
INSERT INTO zawNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Rexpejṉ Israel, narä nanä di'tu niacbee, diza rexcuxhtistu niacbee laa Xindxan xten Dios ni bacuaatu lo crujz. ");
INSERT INTO zawNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Scree gujc te guzojb xtidx Dios ni cuaj lo guijtz agujc xchero. Diidxre bacuaa reniguii ni gunii xtidx Dios, Crist xten Dios sidejd trabajwduxh. ");
INSERT INTO zawNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ni'cni coḻsiechlajztu, coḻguibi' loj Dios te guibicaj xtojḻtu. Dxejc susiälyuj Dios lastootu, sujnni gac nacoob guira'ti, si'cni bia'n diidx gacni. ");
INSERT INTO zawNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Lojtu suxhaḻza Dios Jesucrist nani rnibee, nani aguleni galooli. ");
INSERT INTO zawNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","N̲aj nungäjḻ jia'n Jesucrist xhaguibaa dxejli guscoob Dios guiralii recos si'cni bia'n diidx gac, si'cni gunii Dios lo reniguii nani gunii xtiidxni lo retoxtadgoldootu agujc xchero. ");
INSERT INTO zawNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Scree gunii toMoisés lo retoxtadgoldoonu, räjpni: “Xtadnu Dios suxhaḻ te niguii sa' narä nani cueni lo resa'tu. Siniini xtidx Dios. Coḻgusobdiajg guiralii diidx nani guiniini lojtu. ");
INSERT INTO zawNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Renani di gusoob rextiidxni, sinitlojreni, direni gac rexpejṉ Dios.” ");
INSERT INTO zawNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Räjpza Pedr: ―Sigajcza agunii guiralii reniguii nani gunii xtidx Dios. Si'c agunixgaa toSamuel, näjza guiraa reniguii ni siädnajlni, xcuent recos ni cayajc neṉ redxejre. ");
INSERT INTO zawNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","La'tu najc xajg reniguii ni gunii xtidx Dios. La'tu biannäjtu diidx nani gunii Dios loj retoxtadgoldoonu. Bia'n diidx, räjp Dios loj toxtadgoldoonu Abram: “Jiädjiajl te xajglu ni guspalazduxh rebeṉ guedxliuj, sa'csi susḻaanireni lo dojḻ.” ");
INSERT INTO zawNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Dxejcti ganiddoo lojtu baxhaḻ Dios Jesucrist te guibaa lajztu che gusiejch lajztu, te na'cru guntu dojḻ ―räjp Pedr. ");
INSERT INTO zawNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Laḻ ni caniireni lo rebejṉ, ro'c bidzujṉ rebixhojz xten Israel näjza nani rnibee lo resoldaad xten guidoro näjza resaduceos. ");
INSERT INTO zawNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bidxe'chduxhreni sa'csi cagulijdxreni rebejṉ, cayäjpreni: ―Sibaṉsac rebejṉ lo rebeṉgut sa'csi gubaṉsac Jesucrist lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Gunaaz reguxhtisreni, biäureni sa'csi agudxej luxh abiäu jusgaad. Neṉ latzguiib barareni yääl. ");
INSERT INTO zawNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Xhidajḻ reni biejn diajg xtiidxreni huililajz xtidx Dios. Si'cti gaii mil niguii huililajz xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Che bara yääl, bachaag sa' guiraa rebeṉgool, renani rnibee guedx Jerusalén, näjza rebejṉ ni ruluii leii, ");
INSERT INTO zawNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","näjza Anás ni rnibee guiraa rebixhojz, näjza xpagojzni ni laa Caifás, näjza Juan, näjza Alejandro, näjza guiraa reniguii ni najc sa' rebixhozro ni rnibee. ");
INSERT INTO zawNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Gunibeereni biääd Pedr näjza Juan gusuj galäiireni te gunabdiidxreni lojreni: ―¿Chu xcäḻrnibee rajptu? ¿Chu laj basä'ttu te basiajctu niguiire? ");
INSERT INTO zawNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Dxejcti sa'csi cayu Pedr diidx ni canii Sprit Dxan xten Dios neṉ lastooni, räjpni lojreni: ―Caniä lo guejbtu, reguxhtis näjza rebeṉgool xten rexpejṉ Israel, ");
INSERT INTO zawNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","palga canabdiidxtu xhicuent gucnäjnu niguii nani gucxhuu ni'ni, palga canabdiidxtu xho basiajcnu niguiiga, ");
INSERT INTO zawNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","gusule'nu xcuent dee te gacbeetu te gacbeeza guiraa rexpejṉ Israel. Xtidx Jesucrist najc yäḻrnibeduxh. Diidxga abasiajc ni' niguiire, xhet rajcdini suga'ni nez lojtu. La'tu abacuaatu Jesucrist lo crujz, niluxh Dios guläsni lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Di'tu ninälajz xtidx Jesucrist. Laani najc si'c te guij nani rbäcajtu che runcheetu te yu'. Per Dios abejn najc Jesucrist si'c guij nani maazru nacsa'c, nani guyu' squiin xte yu'. ");
INSERT INTO zawNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Xtebtis Jesucrist rusḻaa bejṉ lo dojḻ, ruti stee bejṉ lo guedxliuj nani baxhaḻ Dios te gusḻaani bejṉ lo dojḻ ―si'c räjp Pedr. ");
INSERT INTO zawNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Che biejn diajgreni xtidx Pedr, bidxelojreni sa'csi di Pedr näjza Juan guidxejb, dizareni guitujy. Dxejcti räjp rebixhojz ni sajcru lo sa'reni: ―Direni ganduxh guijtz, bejṉtisreni. Dxejcti gucbeereni gusanäj redee Jesucrist, lojni bisieedreni. ");
INSERT INTO zawNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Bahuiiza rebixhojz lo niguii ni abiajc ni'ni, suganäjni guiro'preni. Ro'cti xhetru gujcdi gunii rebixhojz sa'csi laaca bejnreni. ");
INSERT INTO zawNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Dxejcti gunibee rebixhojz birii guidxojnreni telaad te bij rebixhojz diidx ensilaareni. ");
INSERT INTO zawNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Räjpreni lo sa'reni: ―¿Xhi jiennäänu reniguiire? Guiraa rebeṉ Jerusalén anajn xcuent dzunroduxhre ni cayujnreni. Digacdi gucuatzlaaznuni. ");
INSERT INTO zawNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Per te di guire'ch xtidx Jesucrist ste'ca guejdx, do'o gulijdxnu guidxojnreni te na'c guiniirureni xtidx Jesucrist ste'ca guejdx. ");
INSERT INTO zawNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Huixisac rebixhojzreni. Dxejcti räjpreni lojreni: ―Na'c guluirutu xtidx Jesucrist, na'cru guiniitu xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Dxejc gunii Pedr näjza Juan, räjpreni lojreni: ―¿Coḻguinii loonu chu xtiidx sajcru guicuadiaagnu? ¿Xtiidx la'tu, o xtiidx Dios? ");
INSERT INTO zawNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Digacdi gusäunu ro'nu. Nanabpac gusule'nu diidx xcuent recos nani abahuiinu näjza rediidx ni abiejn diajgnu. ");
INSERT INTO zawNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Balidxsac rebixhojzreni te na'cru guiniireni xtidx Jesucrist. Dxejc basḻaa rebixhojz guiro'preni, sa'csi xhetru niajcdi niujnreni lo Pedr näjza Juan, sa'csi canii rebejṉ bejnreni te dzunsa'c. Xhidajl rebejṉ gulä'pza xpala'n Dios sa'csi bahuiireni xhini'c gujc ro'c. ");
INSERT INTO zawNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Sa'csi niguii ni basiajcreni xcuent yälmilagwr agudejdni tiuu ijz. ");
INSERT INTO zawNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Che basḻaa rebixhojz guiro'preni, gubi'reni lo sa'reni ni najc rexpejṉ Jesucrist. Bijreni diidx guiraa ni gunii reguxhtis xten rebixhojz näjza rebeṉgool lojreni. ");
INSERT INTO zawNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Che biejn diajg rexpejṉ Jesucrist xtiidxreni, tejtis xhigab bejnreni guredx-gunabreni lo Dios, räjpreni: ―Xtadnu Dios, nani benchee xhaguibaa näjza guedxliuj näjza nisdoo näjza guira'ti ni yu' lojreni, neṉreni, ");
INSERT INTO zawNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","nani bejn basoob toDavid xtidx Sprit Dxan te bacuaani xtiidxlu, räjpni: ¿Xhicuent guyuduxh rebeṉ guedxliuj yärsia'? ¿Xhicuent bejn rexpejṉ Israel xhigab ni xhet sajcdi? ");
INSERT INTO zawNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bidxagsa' reṟeii lo guedxliuj näjza reguxhtis xten reguejdx te gudxojnreni xtzun Dios näjza xten Dad Crist nani baxhaḻ Dios, si'c gunii toDavid. ");
INSERT INTO zawNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Aguzojb diidxre, sa'csi lo guejdxre bidxagsa' Herodes näjza Poncio Pila't näjza rexpejṉ Israel näjza rebeṉzijt nani di gac xpejṉ Israel. Bidxechnäjreni Xi'nlu nani najc Crist ni baxhaḻlu. ");
INSERT INTO zawNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","N̲aj abejnreni dzunguijdx si'cni galooli guniilu gac. ");
INSERT INTO zawNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","N̲aj Guejblu Xtiosnu, bahuii xho cagusacsíreni nuure, gucnäj nuure te gutiplaaznu, te na'c guidxeebnu guiniinu xtiidxlu, sa'csi najcnu rexpejṉlu. ");
INSERT INTO zawNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Baniidx xcäḻrnibeelu loonu te guisiajcnu rebejṉ, te jienzanu redzunro, remilajgwr con xcäḻrnibee Xi'ndxanlu Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Che gulujx gurejdxreni lo Dios, gusloj canibsejz yu' cadro tre'reni, cayac si'c te xu. Dxejcti biääd Sprit Dxan xten Dios basutijpruni lastooreni. Dxejc dirureni nidxejb guniireni xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Guiraa renani huililajz xtidx Dios, tejsi xhigab bejnreni. Rut chu tejdireni bejn guinibexteb xhixtenni: bachaagreni sa' rexhixtenreni te xca' guiraareni nani rquiinreni. ");
INSERT INTO zawNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Gucnäj Dios reapost, gusutzu'tzreni bijreni diidx bahuilojreni loj Jesucrist che gubaṉsacni lo rebeṉgut. Gucnäj Dios guiraa rexpejṉ Jesucrist, luxh gopduxh rebeṉ guejdx respe'treni. ");
INSERT INTO zawNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ni'cla tejreni di niäädx xhixtenni sa'csi renani gojp xyujni, rolijzni, bato'renini, dxejcti biädnäreni xcuentni, ");
INSERT INTO zawNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","badeedreni meelga lo reapost. Dxejcti gudis reapost meelga lo guiraa renani rquiinni. ");
INSERT INTO zawNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Guyu' te niguii ni laa José. Lajdxni najc Chipre, ni ṟe' lo nisdoo. Najcni sa' rexfamiḻ levita. Reapost gulälajni Bernabé (ni säloj xtiidxreni bejṉ ni rbecdxi lajz sa'ni). ");
INSERT INTO zawNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Scree gulälajrenini sa'csi bato'ni te la' yuj xtenni, dxejcti badeedni meel ni cua'ni lo reapost. ");
INSERT INTO zawNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Guyu' stee niguii ni laa Ananías. Chäälni laa Safira. Bato'reni te la' yuj. ");
INSERT INTO zawNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Niguiire biannäjni gala' meel, dxejc sgala' meelga badeedni lo reapost si'c guiraa xcuent yujga luxh chäälni nanchee xhi cayujnni. ");
INSERT INTO zawNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Dxejcti räjp Pedr lojni: ―Ananías, ¿xhicuent rusooblu xtidx Satanás ni rnibee lo rebeṉdxab, ä? ¿Xhicuent rlajzlu gusgueelu Sprit Dxan xten Dios? Biannäjlu gaii meel ni cua'lu che bato'lu te la' yuj. ");
INSERT INTO zawNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Che gajdlu guto' yujga, xtenluni. Che bato'lu yujga, ¿la xhet xtendilu meel ni cua'lu? ¿Xhicuent bejnlu xhigab neṉ lastoolu gunlu dee? Loj Dios guniilu didx-xhii, xhet loodinu. ");
INSERT INTO zawNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Che biejn diajg Ananías xtidx Pedr, biajbni lo yuj, gujtni. Bidxebduxh rebejṉ che biejn diajgreni xhi gusajcni. ");
INSERT INTO zawNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Sas gubig gaii bi'n batejbreni Ananías neṉ lajd. Dxejcti sanärenini huicua'tzrenini neṉ baa. ");
INSERT INTO zawNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pet agujc choṉ oṟ gujtni chela bidzujṉ chääl Ananías. Dini gan agujt chäälni. ");
INSERT INTO zawNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Räjp Pedr lojni: ―Gunii, ¿la bato'tu xyujtu si'cni naj chäällu huijni, ä? Räjp Safira lojni: ―O'n, si'c huijni. ");
INSERT INTO zawNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Dxejcti räjp Pedr lojni: ―¿Xhicuent bejnlu tejsi xhigabguijdx con chäällu? ¿Xhicuent rlajztu gusgueetu Sprit Dxan xten Dios? Ro lä' siääd renani huicua'tz chäällu. N̲aj näjza luj chacua'tzreni neṉ baa. ");
INSERT INTO zawNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Si'ctis biajb Safira, gutgajczani. Dxejcti bidzujṉ rebi'n, bahuiireni agujtni. Dxejcti guläsrenini, biriireni huicuatzgajcrenini cuä' baa cadro biga'tz chäälni. ");
INSERT INTO zawNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Bidxebduxh guiraa rexpejṉ Jesucrist, näjza guiraa rebejṉ nani biejn diajgni recosre. ");
INSERT INTO zawNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Xhidajḻ redzunro, remilagwr bejn reapost nez loj rebeṉguejdx. Nadxaag sa' rexpejṉ Jesucrist, caguchaagreni diidx neṉ cordoor ni laa Salomón. ");
INSERT INTO zawNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Guyu' xhidajl bejṉ ni di nuchaag lo rexpejṉ Jesucrist sa'csi bidxejbreni guchaagreni lojreni. Rebeṉguejdxga guläpduxhreni xpala'n rexpejṉ Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Neṉ redxejga xhidalduxh rebejṉ huililajz xtidx Jesucrist, niguii sigajc gunaa. ");
INSERT INTO zawNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Dxejcti gulääreni lo nezyuj rebejṉ nani cayacxhuu. Siädnä rebejṉ beṉracxhuu naga' lo da', te gaxäjsi ted xpalaa Pedr yejcreni che ted Pedr ro'c, te si'c jiajcreni. ");
INSERT INTO zawNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Guedx Jerusalén bidzujṉ xhidajl rebejṉ ni siääd ste'ca guejdx. Biädnäreni rebejṉ ni cayacxhuu näjza balti bejṉ ni yu' beṉdxab neṉ lastooreni. Con xcäḻrnibee Jesucrist basiajc reapost rebeṉ racxhuu, gulääzareni rebeṉdxab neṉ lastoo balti bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Dxejcti bidxechlajz bixhojz ni rnibee, näjza reniguii ni laa saducee, sa'csi calä'p rebeṉguejdx xpala'n reapost sa'csi basiajcreni rebeṉ racxhuu. ");
INSERT INTO zawNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Gunaazreni reapost. Basäurenini neṉ latzguiib. ");
INSERT INTO zawNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Niluxh yäälga, biääd te angl xten Dios, baxhalni ro' latzguiibga. Dxejcti gulääni reapost neṉ latzguiib. Räjpni lojreni: ");
INSERT INTO zawNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Coḻchäj guidoro. Ro'c coḻguinii lo rebejṉ xho gac guibaṉnäjreni Dios par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Che biejn diajgreni si'c, rsildooru biu'reni neṉ guidoro, ro'c baluiireni xtidx Dios lo rebejṉ. Dxejc bixhojz nani rnibee, näjza rebeṉgool, bachagsa'reni gurejdxreni guiraa reguxhtis xten guidoo, näjza guiraa reguxhtis xten rexpejṉ Israel. Dxejcti gunibeereni jiädnä reguixhajg reapost nani biäu neṉ ladtguiib. ");
INSERT INTO zawNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Che bidzujṉ reguixhajg latzguiib, bahuii reguixhajg neṉ latzguiibga, niluxh rut yu'di neṉ latzguiib. Che gubi'reni biädnäreni diidx, räjpreni loj reguxhtis: ");
INSERT INTO zawNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","―Che bidzuṉnu latzguiib, niäudzu'tz ro' latzguiib luxh resoldaad ni cayajp ro' latzguiib suga' guiro'p laad. Che baxhalnu ro' latzguiib, rut yu'di neṉ latzguiib. ");
INSERT INTO zawNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Che biejn diajg bixhojz ni rnibee, näjza capitán nani rnibee resoldaad xten guidoro, näjza rebixhojz, ben tio'p lajzreni, räjp lo sa'reni: ―¿Xhini'c gujc? ¿Xhoni gac ṉaj? ―räjpreni. ");
INSERT INTO zawNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Dxejcti bidzujṉ te niguii, räjpni lojreni: ―Reniguii ni basäutu neṉ latzguiib, areni suga' neṉ guidoro, luxh caguluiireni rebejṉ ―räjpni. ");
INSERT INTO zawNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Dxejcti sanä capitán xten resoldaad rexcuxhtis guidoro te biädnäreni reapost, luxh direni nusacsí reapost sa'csi rdxejbreni nucuaareni guij yejcreni. ");
INSERT INTO zawNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Che bidzuṉnäjreni reapost, räjpreni suureni nez loj reguxhtis xten Israel, sas gunii bixhojz ni rnibee, ");
INSERT INTO zawNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","räjpni loj reapost: ―¿Et agunibeenu lojtu na'cru guiniitu xtidx Jesucrist? Xhoxh ṉaj cagutie'chtu rediidxga lo guiraa rebejṉ neṉ guedx Jerusalén. La'tu rlajztu cuaquijtu nuure bagu'tnu Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Dxejc räjp Pedr näjza reapost lojreni: ―Nanabpac gusoobnu xtidx Dios, lacuaa gusoobnu xtidx bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Bagu'ttu Jesucrist che bacuaatuni lo crujz. Niluxh Xtios xtadgoldoonu guläsni lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","N̲aj agule'c Diosni xladbeeni cadro rnibeeni, abadeedza Dios yäḻrnibee loj Jesucrist te gusḻaani nuure, te si'c rlajzni guibicaj xtojḻ guiraa rexpejṉ Israel nani gusiechlajzreni. ");
INSERT INTO zawNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Bahuiloonu xhi bejn Dios. Ni'c cagusule'nu. Nadoncheenu Sprit Dxan xten Dios cayacnäj nuure te gusule'nu rediidxre. Badeed Dios Sprit Dxan xtenni lo guiraa renani susoob xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Che biejn diajg reguxhtis rediidxga, bidxechduxhreni, rlajzreni nugu'treni reapost. ");
INSERT INTO zawNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Dxejcti huisulii te niguii ni laa Gamaliel, nani najc te farisee nani ruluii leii xten Israel, rebejṉ rapduxh respe't dade'ga. Gunibee Gamaliel guirii reapost neṉ yu'ga. ");
INSERT INTO zawNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Dxejcti räjp Gamaliel lo rebixhojz: ―Guejbtu rexpejṉ Israel, coḻyensa'c xhigab xhini'c rlajztu gunnäjtu reniguiire. ");
INSERT INTO zawNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Coḻzaa lajztu gajd gac xchej guyu' tej ni laa Teudas, räjpni rnibeduxhni. Dxejc huinajl tajp gayuu bejṉni. Che bagu'trenini, bire'ch guiraa rexpejṉni, xhetru bejndireni. ");
INSERT INTO zawNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Neṉ ijz ni guyu' cens, biriiza Judas ni siääd Galilee. Dxejc gurejdxni xhidajl bejṉ ni huinajlni. Bagu'tza bejṉni, dxejcti bire'chza guiraa reni huinajlni. ");
INSERT INTO zawNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","N̲aj rniä, coḻguibicaj, coḻgusaan reniguiire, rexpejṉ Jesús. Palga guejbcareni cayujnreni dzuunre, xtebcani sinitlojni. ");
INSERT INTO zawNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Palga xtzuun Dios ni cayujnreni, digacdi guscuääznu dzuunga, sa'csi guidiḻnu guidxe'ch Gueb Dios loonu. ");
INSERT INTO zawNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Bichaglajz rebixhojz xtiidx Gamaliel. Gurejdxreni reapost, dxejcti gudijnreni reapost, gunibeereni loj reapost na'cru guiniireni xtidx Jesús. Dxejc basḻaarenini. ");
INSERT INTO zawNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Biriitireni nez loj rebixhojz. Cabaduxh lajzreni sa'csi gujc gudejdreni trabajw xcuent Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Guixe-guixee laḻtis baluiireni xtidx Jesucrist neṉ guidoro näjza rolijz bejṉ. Cagusule'reni diidx lo rexpeṉ Israel: ―Jesús najc Crist nani cabääztu jiääd. ");
INSERT INTO zawNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Neṉ redxejga, xhidalro gujc rexpejṉ Jesucrist. Niluxh gusloj camojm̲ rexpejṉ Jesucrist nani rnii didx griegw. Räjpreni: ―Xhet laadi cayujn rebejṉ ni rnii didx hebreo. Rebiuud nani rnii didx hebreo rca'ru loj rexpiuudnu. Rebiuud ni rnii didx hebreo rca'ru xhi gaureni che rguisreni xhi gau rebiuud guixe-guixee. ");
INSERT INTO zawNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Dxejcti batie' guitzubitio'p reapost guiraa rexpejṉ Jesucrist, räjpreni lo guiraareni: ―Et laadi guisaannu guluiinu xtidx Dios te quisnu xhi gau rebiuud. ");
INSERT INTO zawNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ni'c nanab cuetu lo resa'tu gajtz niguii nani najntu najc beṉsa'c, nani rbäjz Sprit Dxan xten Dios neṉ lastooreni, nani yu' xcäriejnreni. Reniguiire quis xhi gaureni. ");
INSERT INTO zawNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Te si'c sajc chanuutis guiniabnu lo Dios, guiluiizanu xtidx Dios lo rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Guiralii rebejṉga bidxaglajzreni diidxga. Dxejcti gulereni Esteban, te niguii ni rlilajzpac xtidx Dios, rbäjzza Sprit Dxan xten Dios neṉ lastooni. Gulezareni Felipe, Prócoro, Nicanor, Timón, Parmenas; gulezareni Nicolás nani siääd guedx Antioquía. Nicolás najc te proselite, nalajznu, dini gac xpejṉ Israel, per basoobni xleii toMoisés che gajdni chalilajz xtidx Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Sas biädnä rexpejṉ Jesús guigajtz niguiiga lo reapost. Dxejcti guredx-gunab reapost lo Dios xcuent reniguiiga, batzuubreni ṉaareni yejc reniguiiga si'c te seen abiu'reni lo xtzuunreni. ");
INSERT INTO zawNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Birechduxh xtidx Dios. Xhidajl beṉ Jerusalén huililajz xtidx Dios, näjza xhidajl bixhojz. ");
INSERT INTO zawNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Gucnäduxh Dios Esteban, bejnni redzunro, remilagwr nez lo rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Dxejc rebeṉ guidoo ni laa Libertados gusloj cadiḻnäj Esteban. Lojreni nadxaag beṉ Cirene, näjza beṉ Alejandría, näjza gaii beṉ Cilicia, näjza sgaii bejṉ ni siääd reguedx Asia. ");
INSERT INTO zawNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Reniguiire di niajcdi nuzejcreni diidx lo Esteban, sa'csi nasiṉduxhni, luxh cayacnäj Sprit Dxan xten Diosni. ");
INSERT INTO zawNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Dxejcti baquiḻreni sgaii niguii ni di gac xpejṉ Jesús, te räjpreni: ―Biejn diaagnu caniyaj Esteban toMoisés näjza Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Scree gujc bache'chreni rebejṉ näjza rebejṉ ni ruluii leii näjza rebeṉgool. Dxejcti bachagsa'reni, gunaazreni Esteban. Huinärenini lo reguxhtis xten Israel. ");
INSERT INTO zawNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Dxejcti biädnäreni reniguii nani baquiḻreni te guniireni didx-xhii. Räjp reniguiire: ―Entis rniyaj Esteban leii xten toMoisés näjza guidodxanre. ");
INSERT INTO zawNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Abiejnza diaagnu gunii Esteban: “Jesús nazareno sutzujḻ guidoro, suchaazani leii nani baniidx toMoisés loonu.” ");
INSERT INTO zawNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Dxejcti guiraa rebejṉ ni sobga' ro'c bahuiireni lo Esteban, bahuiireni rujn lojni si'c rujn loj te angl xten Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Dxejcti räjp te bixhojz nani rnibee lo Esteban: ―¿La gulii si'c guniilu, ä? ");
INSERT INTO zawNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Räjp Esteban lojreni: ―Coḻgucuadiajg rextidxä, guejbtu dad, näjza resa'ä. Xtioznu ni sacduxh, ni rnibee, baluiloj lo toxtadgoldoonu Abram che guläjzni Mesopotamia, che gajdni chaläjz neṉ guedx Harán. ");
INSERT INTO zawNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Räjp Dios loj toAbram: “Birii lajdxtu, basa'n guiraa resa'lu. Huij cadrotis guluiä lojlu” ");
INSERT INTO zawNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","―räjp Esteban―. Dxejcti birii toAbram lajdx reCaldeos. Huiläjzni guedx Harán. Che gujt xtadni, biädnä Dios toAbram nez ree, cadro rbääznu ṉaj. ");
INSERT INTO zawNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Di Dios nuzalajz nicla tla' yuj cadro suu te ni' toAbram. Niluxh räjp Dios sudeedni yujga lo rexajg toAbram, jiannäjreni yujga che guet toAbram. Niluxh nicla gajd xi'n toAbram chu dxejc. ");
INSERT INTO zawNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Stee huält räjp Dios lo toAbram: “Rexi'nlu, rexagdoolu, siläjzreni si'c beṉzijt. Ladxbejṉ gacreni mos, ro'c susacsí bejṉreni si'cti tajp gayuu ijz.” ");
INSERT INTO zawNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Räjp Dios: “Narä sunä castiigw rebejṉ ni gusacsíreni che najcreni mos. Narä cuää́ rexagdoolu ro'c, te ree guzuxhijbreni loä neṉ guejdxre”, si'c räjp Dios ");
INSERT INTO zawNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","―räjpza Esteban―. Dxejcti si'c bia'n Dios diidx con toAbram, gunibee Dios gutiuug Abram lagajc laani, te chuni bee; ni'c najc te seen xten diidx ni bia'n Dios con Abram. Guyu' te xi'n toAbram, ni laa Isaac. Che guyu'ni xhujṉ dxej, basäḻza toAbram beegani si'c te seenza. Sigajcza bennäj Isaac xi'nni Jacoob. Sigajcza bennäj Jacoob guitzubitio'p rexi'nni nani najc rexpeṉgoldoo xpeṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Räjp Esteban: ―Guitzubiteb rexi'n Jacoob guyu' te yälrudxojn lo bejtzreni José. Dxejc bato'reni José lo te beṉ Egipto. Dxejc Dios goptzu'tz José. ");
INSERT INTO zawNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Che gudejd José trabajwduxh, gucnäj Diosni. Badeed Dios yäḻnasiṉduxh lojni. Bejn Dios bichaglajz ṟeii Faraón José. Badeed ṟeii Faraón gujcni gubernadoor xten Egipto. Gunibeeza José guira'ti xhixten ṟeiiga. ");
INSERT INTO zawNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Räjpza Esteban: ―Che bidzujṉ dxej gujc te gubijn, guiraa neṉ reguedx Egipto näjza guiraa neṉ reguedx Canaán, trabajwduxh cadejd guiraa rebejṉ. Xhet guyu'di xhi niajw retoxtadgoldoonu. ");
INSERT INTO zawNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Che biejn diajg xtadgoldoonu Jacoob yu' xhi gaureni neṉ reguejdx xten Egipto, ro'c baxhaḻni rexi'nni, bica'reni xhi gaureni te huält. ");
INSERT INTO zawNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Che huijreni stehuält, dxejc bazäbdiidx José lojreni laani najc bejtzreni. Biembeeza Faraón resa' José. ");
INSERT INTO zawNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Dxejcti baxhaḻ José diidx jiääd xtadni Jacoob, näjza guiraa resa'ni, cuääzreni Egipto. Najc rebejṉga si'cti gayoṉbitzubigaii bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Si'c gujc te huij Jacob guedx Egipto. Ro'c guläjzni, ro'c gujtni. Ro'c gujtza retoxtadgoldoonu. ");
INSERT INTO zawNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Dxejcti huinäreni rextzujtreni loj Siquem te biga'tzsacreni neṉ baa nani gusii toxtadgolnu Abram lo rexi'n Hamor neṉ guedx Siquem. ");
INSERT INTO zawNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Räjp Esteban: ―Che bidzuṉgajxh dxej, si'c diidx ni bia'n Dios con toxtadgoldoonu Abram, bidalduxh rexpeṉgoldoonu neṉ guedx Egipto. ");
INSERT INTO zawNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Dxejcti guyu' te xṟeii Egipto ni di gan guiraa redzunsa'c nani bejn toxtadgoldoonu José. ");
INSERT INTO zawNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","R̲eiiga basgueeni rexpeṉgoldoonu, basacsínireni, trabajwduxh bateedni rexpeṉgoldoonu. Gunibee ṟeiiga basäḻreni guiraa rebäz niguii te di ḻaareni, te guetreni. ");
INSERT INTO zawNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Neṉ redxejga, gojl Moisés. Che gujc Moisés bäz, te bäz daani, saru rujn lojni, huinälajz Diosni. Guḻaani choṉ bäii rolijzni. ");
INSERT INTO zawNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Dxejc huisäḻrenini, te guzojb xtidx Faraón. Dxejc lagajc xindxa'p Faraón bidxälni Moisés, cua'nini basḻaanini si'c xi'nni. ");
INSERT INTO zawNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Bisieed Moisés guiraa ni najn rebeṉ Egipto. Gunisa'cni diidx, bensa'cni dzuun. ");
INSERT INTO zawNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Räjp Esteban: ―Che guyu'ni tiuu ijz, banaj lajzni resa'ni ni najc xpejṉ Israel, huijni cadro rbäjzreni. ");
INSERT INTO zawNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Dxejc bahuiini casacsí te beṉ Egipto te beṉ sa'ni. Sas bagu'tni beṉ Egipto. ");
INSERT INTO zawNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Bejn Moisés xhigab pet sacbee resa'ni cayacnäj Diosni te gusḻaani rexpejṉni. Luxh di resa'ni niacbee si'c. ");
INSERT INTO zawNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Che bara yääl, bahuii Moisés cadiḻnäj sa'reni tiop xpeṉ Israel. Räjp Moisés lojreni: “Coḻcuedxi, Dad. Lagajc sa'tu cadiḻnäjtu. ¿Xhicuent rdijḻtu?” si'c gunii Moisés, te na'cru tiḻnäj sa'reni. ");
INSERT INTO zawNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Dxejcti nani cayunniälajzga, balanaani Moisés, räjpni loj Moisés: “¿Chu baniidx yäḻrnibee lojlu te jiädnibeelu nuure? ");
INSERT INTO zawNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿La rlajzlu ju'tlu narä si'c bagu'tlu beṉ Egipto naii?” ―räjpni―. ");
INSERT INTO zawNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Che biejn diajg Moisés rediidxga, baxuṉni, huijni zijt. Huiläzsijcni guedx Madián. Ro'c bachṉaani, guyu' tiop xiṉgaanni. ");
INSERT INTO zawNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Räjpza Esteban: ―Che gudejd tiuu ijz, bidzujṉ te dxej cansajni nez lo reyubijdz ni naga' guideb gabi dajn ni ḻaa Sinaí. Ro'c bahuiini te bajl neṉ te yaguejch. Neṉ bajlga baluiloj angl xten Dios lo Moisés. ");
INSERT INTO zawNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Bidxeloduxh Moisés che bahuiini si'c. Dxejcti gubigni te rlajzni nuhuisa'cni yajgga. Dxejc biejn diajgni gunii Dios, räjpni lo Moisés: ");
INSERT INTO zawNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Narä nacä Xtios rextadgoldoolu, narä nacä Dios xten Abram, näjza xten Isaac näjza xten Jacoob.” Dxejcti gucsez Moisés sa'csi bidxebduxhni, diruni nuhuisa'c yajgga. ");
INSERT INTO zawNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Dxejcti räjp Dios lojni: “Gulää xcura'chlu. Yuj cadro suga'lu najc dxan, sa'csi narä yu'ä ree. ");
INSERT INTO zawNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Abahuiä xho cagusacsí rebeṉ Egipto rexpeṉä. Abiejn diagä xho roonreni. N̲aj abiälä te gusḻaä́ rexpeṉä. Gudaa ṉaj, suxhaḻälu chäälu Egipto.” ");
INSERT INTO zawNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Räjp Esteban: ―Dios badeed yäḻrnibee lo Moisés nani baze' retoxtadgoldoonu che räjpreni: “¿Chu baniidx yäḻrnibee lojlu te jiädnibeelu nuure?” Baxhaḻ Dios Moisés te guinibeeni xpejṉ Dios, gucnäjza Dios Moisés basḻääni rexpejṉni neṉ nacióṉ Egipto si'c gunii angl xten Dios che baluilojni lo Moisés neṉ yaguejchga. ");
INSERT INTO zawNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Gulää Moisés rebejṉga. Ganiddoo bejn Moisés redzunro, yäḻrdxeloj neṉ nacióṉ Egipto näjza ro' nisdoo ni laa nisdo xniaa. Tiuu ijz cuansaj retoxtadgoldoonu neṉ yubijdzroga, ro'c bejnza Moisés redzunro, remilagwr. ");
INSERT INTO zawNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Lagajc Moisésre gunii xtidx Dios che räjpni loj rexpejṉ Israel: “Sibe Dios lo rexajgtu te niguii ni najc sigac narä. Siniini xtidx Dios. Coḻgusoob xtiidxni.” ");
INSERT INTO zawNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Lagajc Moisés guyunäj rebejṉ neṉ yubidzro. Xangl Dios guninäj Moisés neṉ dajn xten Sinaí. Dxejcti badeed Moisés rediidx ni gunibee Dios lo retoxtadgoldoonu. Laareni basa'nreni diidxga loonu. ");
INSERT INTO zawNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Räjp Esteban: ―Niluxh di retoxtadgoldoonu nusoob rextidx Moisés. Di rlajzreni guinibee Moisésreni. Canaduxhlajzreni nacióṉ Egipto. ");
INSERT INTO zawNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Che sää Moisés dajn Sinaí, räjpreni loj Aarón bejtz Moisés: “Benchee banäjb gac xtiooznu, te nidreni loonu, te chanajlnureni. Chu gan con Moisésre ni baluii nezyuj che gulääni nuure guejdx reEgipto.” ");
INSERT INTO zawNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Sas bencheereni te banäjb ni najc si'c te gonbäz. Dxejcti bagu'treni guidxaa te badeedreni rejnga lo banäjb te bazuxhijbreni lojni. Bibalazduxhreni sa'csi abencheereni banäjbga. ");
INSERT INTO zawNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Dxejcti gubicaj Dios loj rexpejṉ Israel sa'csi bejnreni si'c. Basaan Dios gojṉreni gubijdx, näjza bäii, näjza rebal xhaguibaa. Gujcni si'cni caj lo guijtz ni bejn reniguii nani bacuaa rextidx Dios. Räjp Dios: La'tu beṉ Israel, cheni cuansajtu tiuu ijz nez lo reyubijdz, ¿la par narä bagu'ttu guidxaa, ä? ¿La loä baniidxtu xtiejnreni, ä? ");
INSERT INTO zawNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Xho gacni si'c, räjp Dios. Cuansanäjtu te yu' najcw guijd cadro chu te banäjb. Neṉga guyu' banäjb ni laa Moloc, nani najtu najc xtiostu. Gojṉzatu balbäze' xten xtiostu ni laa Remfán. Redios ni bencheetistu reni'c gojṉtu. Ni'cni sibää́ la'tu ree guxhaḻä la'tu stelaad guedx Babilonia. ");
INSERT INTO zawNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Guniiru Esteban, räjpni lojreni: ―Neṉ reyubijdz gojp retoxtadgoldoonu te yu' najcwni guijd. Gujcni xquidooreni. Ro'c guninäjreni Dios. Benchee retoxtadgoldoonu yu' najcw guijdga si'cni gunibee Dios che baluiini lo Moisés xhoni gacni. ");
INSERT INTO zawNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Che gujt Moisés, Josué gunibee lacuaa toMoisés, huinäni retoxtadgoldoonu nacióṉ Canaán. Batzujḻreni yuro ni najcw guijd te näj ni'c huinäreni Canaán. Gulää Dios rebejṉ ni guläjz neṉ reguedx Canaán. Dxejcti bia'n retoxtadgoldoonu neṉ reguejdxga. Bazuxhijbreni lo Dios neṉ yuguijd ni najc xquidooreni che gojlli xtiemp ṟeii David. ");
INSERT INTO zawNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Huinälajz Dios David. Räjp David lo Dios: “Rlazä gunä te guidoo par guejblu, Dios xten nuure, rexpejṉ Israel.” ");
INSERT INTO zawNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Dxejcti di Dios nusoob xtidx David. Alga Salomón, xi'n David, ni'c benchee xquidoro Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","N̲aj di Dios guiquiin te yu' nani runchee bejṉ. Scree bacuaa te niguii nani gunii xtidx Dios. Räjp Dios: ");
INSERT INTO zawNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Si'c najc te yagxhilsa'c cadro rnibee ṟeii, si'c najc xhaguibaa cadro rbeä. Si'c te bancw cadro rsiuj ni' ṟeii, si'c najc guedxliuj nani bencheä. Dina guiquinä guncheetu te xyu'ä. Dina guiquinä te lajt cadro gusilazä, räjp Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿La et ṉaädi benchee guiraa nani ruhuiitu?, räjp Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Räjp Esteban lojreni: ―Te beṉ nadduxh najctu. Ditu jiu xtidx Dios. Niäu lastootu, niäuza diajgtu. Di'tu chanälajz xtzuun Sprit Dxan xten Dios, dizani cuääz neṉ lastootu. Si'c bejṉ retoxtadgoldootu, si'cza rujntu. ");
INSERT INTO zawNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Basacsí retoxtadgoldootu guiralii reniguii nani gunii xtidx Dios. Nicla tejni direni niu. Bagu't retoxtadgoldootu guiraa reniguii nani gunii siääd te niguidxan xten Dios. N̲aj abiääd niguidxanga, Jesucrist laani, luxh la'tu huinätuni lo guxhtis te gunibeetu gujtni. ");
INSERT INTO zawNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","La'tu biannäjtu leii nani gunii reangl xten Dios loj Moisés, luxh la'tu ditu nucuadiajg rediidxga. ");
INSERT INTO zawNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Che biejn diajgreni rextidx Esteban, bidxe'chduxhreni, rauya' läijreni sa'csi rdxe'chreni lo Esteban. ");
INSERT INTO zawNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Rbäjz Sprit Dxan xten Dios neṉ lastoo Esteban, ni'cni bahuitzu'tzni xhaguibaa, ro'c bahuiini yäḻrdimbichasejz xten Dios. Bahuiizani suga' Jesucrist xladbee Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Räjp Esteban lojreni: ―Coḻhuilaa. Narä cahuiä xhaguibaa cadro yu' Dios, ruhuiäza loj Xi'n Dios nani gujc Niguii; ani suga' xladbee Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Guredxaduxhreni basäuzareni diajgreni. Dxejcti baxuṉreni bixa'treni yejc Esteban. ");
INSERT INTO zawNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Dxejc gudobyujrenini, guḻääreni Esteban neṉ guejdxga. Ro'c bacuaareni guij yejc Esteban. Che cagucuaareni guij yejcni, guläyaḻreni xhajbreni; te niguii ni laa Saulo biannäj xhajbreni. ");
INSERT INTO zawNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Laḻ ni cagucuaareni guij yejcni, gunii Esteban loj Jesucrist räjpni: ―Guejblu, Dad Jesucrist, cua' narä. ");
INSERT INTO zawNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Dxejcti biajb Esteban, bazuxhijbni, guredxa'ni räjpni: ―Dad Jesucrist, na'c gudzuublu dojḻre yejc rebejṉre, na'c gucuaquijlureni. Gulujxsi guniini si'c, gujtni. ");
INSERT INTO zawNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Rbaduxh lajz Saulo bagu'treni Esteban. Lagajc dxejga gusloj gudejd rexpejṉ Jesucrist trabajwduxh neṉ guedx Jerusalén. Dxejcti bire'ch rexpejṉ Jesucrist. Biunejzreni ro'c sääreni nez guiraa reguedx Judea näjza nez guiraa reguedx Samaria. Xtebtis reapost bia'n Jerusalén, direni nire'ch. ");
INSERT INTO zawNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Reniguii nani sanälajz Dios huicua'tz Esteban. Cayonduxhreni sa'csi riareni gujt Esteban. ");
INSERT INTO zawNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Biäädza Saulo, guixe-guixee basacsíni rebejṉ nani huililajz xtidx Dios. Biu'ni rolijzreni, gunaazni reniguii näjza regunaa te basäunireni neṉ latzguiib. ");
INSERT INTO zawNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Che bire'ch rebejṉ nani huililajz xtidx Dios, basule'reni xtidx Dios nez cadrotis sääreni. ");
INSERT INTO zawNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Tej rebejṉga laa Felipe. Siini nez te guedx Samaria. Ro'c basule'ni xtidx Dios. Räjpni: ―Jesús najc Crist nani cabäjztu jiääd. ");
INSERT INTO zawNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ro'c bachagsa' rebejṉ bacuadiajgreni rextidx Felipe, bahuiizareni redzunro, remilagwr nani bejn Felipe. ");
INSERT INTO zawNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Gaii bejṉ yu' beṉdxab neṉ lastooreni. Che gunibee Felipe guirii rebeṉdxab lastoo rebejṉga, guredxa' rebeṉdxabga, dxejcti biriireni neṉ lastoo rebejṉga. Yu'za xhidajl bejṉ nani digacdiru guiniib, yu'za reni rajc ni'reni, ṉaareni. Con xcäḻrnibee Jesucrist basiajc Felipe guiraa rebejṉga. ");
INSERT INTO zawNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Sa'csi gujc si'c, bibalazduxh guiraa rebejṉ neṉ guejdxga. ");
INSERT INTO zawNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Guyu' te niguii ni laa Simón neṉ guejdxga. Bisieedni bejnni xhidajl redzuun yäḻbidxaa, basgueeni rebeṉguejdxga. Bidxeloduxh rebeṉguejdx lojni. Räjpni lo rebejṉ rutru chu stee bejṉ ni najc maazru beṉro lojni. ");
INSERT INTO zawNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Luxh guiraa rebejṉ, rebiuux, rebeṉgool, rebeṉrajp, rebeṉproob bacuadiajgreni xtidx bidxaaga, räjpreni: ―Laani rajpni yälrnibee xten Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Xchero basgueeni rebejṉ, bidxelojreni rextzunyäḻbidxaani. Guiraa rebejṉ huililajz xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Dxejcti baluii Felipe xcuent xcäḻrnibee Dios, näjza xcuent Jesucrist. Xhidajl rebeṉguejdxga huililajz rediidx nani gunii Felipe. Dxejcti birobnisreni, niguii näjza gunaa. ");
INSERT INTO zawNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Nägajcza Simón huililajz rediidxga dxejc gurobniszani. Dxejc guyunäj Simón Felipe. Che bahuii Simón lo redzunro, remilagwr nani cayujn Felipe, bidxeloduxh Simón. ");
INSERT INTO zawNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Che biejn diajg reapost ni yu' guedx Jerusalén huililajz rebeṉ Samaria xtidx Dios, baxhaḻreni Pedr näjza Juan ro'c. ");
INSERT INTO zawNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Che bidzujṉ guiro'preni guejdxga, gunabreni lo Dios xcuent rebejṉ ni huililajzga te gudeed Dios Sprit Dxan xtenni lojreni, ");
INSERT INTO zawNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","sa'csi gajd Sprit Dxan xten Dios jiädläjz neṉ lastooreni. Che huililajzreni, gurobnistisreni te gucbee rebejṉ chuni'c najc rexpejṉ Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Dxejc batzuub Pedr näjza Juan ṉaareni yejc tejga renani ahuililajz xtidx Dios, dxejc badeed Dios Sprit Dxan xtenni biädläjzni neṉ lastooreni. ");
INSERT INTO zawNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Che bahuii Simón biädläjz Sprit Dxan xten Dios lastoo rebejṉ ni batzuub reapost ṉaani yejcreni, rlajz Simón nudeedni meel loj reapost, ");
INSERT INTO zawNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","räjpni lojreni: ―Coḻguniidx yäḻrnibee loä te si'cza gudzubä ṉaä yejc rebejṉ, te jiu' Sprit Dxan xten Dios neṉ lastooreni. ");
INSERT INTO zawNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Dxejcti räjp Pedr lojni: ―¡Sunitloj xmeellu con luj! Xho gunlu xhigab siilu Sprit Dxan xten Dios nani rudedxlia' Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Digacdi gunlu dzuun ni riennu, sa'csi xhet laadi najc lastoolu nez loj Dios; yu' dojḻ neṉ lastoolu. ");
INSERT INTO zawNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Basie'ch lajzlu, badzucaj rexhigab guijdx xtenlu. Guredx-gunab lo Dios, top susiäjḻ lajz Dios xtojḻlu ni bejnlu neṉ lastoolu. ");
INSERT INTO zawNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","N̲aj narä nanä ruguilazduxhlu, luxh runduxhlu xhigabguijdx. ");
INSERT INTO zawNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Dxejcti räjp Simón lo guiro'preni: ―Coḻnab loj Dios xcuentä te na'c sacä si'cni caniitu. ");
INSERT INTO zawNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Che gulujxti bijreni diidx xcuent ni bahuilojreni bejn Jesucrist, che gulujx basule'reni xtidx Jesucrist loj rebeṉ Samaria, gubisacreni Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Dxejcti biääd te xangl Dios, räjpni lo Felipe: ―Huij lo nezyuj ni ṟii guedx Jerusalén, ni rij nez guedx Gaza. Nezyujga rdejd lo reyubijdz. ");
INSERT INTO zawNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Sä'ti Felipe. Che bidzujṉni lo nezyujga, bidxaagni te dade' ni siääd nacióṉ Etiopía. Najcni te eunuco, najczani xcuxhtis reina Candace. Laani rgucheeni guiraa xmeel reinaga. Biääd dade'ga guedx Jerusalén te sagajṉni Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Siädbisacni lajdxni. Sobga'ni neṉ te gaṟe't saruduxh, cayoḻni xtidx Isaías, nani bacuaa xtidx Dios agujc xchero. ");
INSERT INTO zawNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Dxejcti räjp angl xten Dios lo Felipe: ―Gubig cuä' gaṟe'tga, guninäj dade'ga. ");
INSERT INTO zawNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Che gubig Felipe cuä' gaṟe'tga, biejn diajgni cayoḻ dade'ga rextidx Isaías. Dxejcti räjp Felipe lojni: ―¿La racbeelu ni caj lo guijtz nani cayoḻlu, ä? ");
INSERT INTO zawNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Dxejcti räjp dade'ga lojni: ―¿Xho gacbeäni palga rut gusule'dini loä? Sas räjp dade'ga lo Felipe chä'pni neṉ gaṟe'tga. ");
INSERT INTO zawNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Cadro cayoḻ dade'ga neṉ guijtz ni caj xtidx Dios rnii scree: Di xiil cuedxa' che rinä bejṉni cadro guetni; dxitis raa xiil che ruhuajrenini. Si'c te xiil najc niguiire, xhet rniidini mase rusacsíduxhrenini. ");
INSERT INTO zawNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Basacsíduxhrenini. Reguxhtis ni niujn yäḻguxhtisni xhet laliidi bejnreni. Xhet si'cti nunyäjḻ gunreni. ¿Xho guiniinu yu' xpejṉni? Ni abagu'trenini. Diruni guibajṉ lo guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Dxejcti gunabdiidx beṉ Etiopía, räjpni lo Felipe: ―Gunilaa loä, chuni'c ruzä't niguii nani bacuaa reguijtzre, ¿la ruzä'tni lagajc laani o la ruzä'tni ste'ca bejṉ, ä? ");
INSERT INTO zawNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Gusloj basule' Felipe rediidx nani abiḻ dade'ga. Dxejcti basule'ni rediidx xcuent Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Laḻ ni sääreni lo nezyuj, bidzujṉreni te lajt cadro yu' nis. Dxejc räjp dade'ga lo Felipe: ―¡Bahuii, ree yu' nis! ¿Xhi rudxojn tiobnisä? ");
INSERT INTO zawNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Dxejc räjp Felipe lojni: ―Palga rililajzlu xtidx Dios neṉ lastoolu, sajc tiobnislu. Dxejc räjp dade'ga lo Felipe: ―Rililazä Jesús najc Crist Xi'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Dxejc gunibee dade'ga gusudxi gaṟe't, sas biäjt guiro'preni, biu'reni neṉ nis, ro'c batiobnis Felipe dade'ga. ");
INSERT INTO zawNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Che biriireni neṉ nis, huinä Sprit Dxan xten Dios Felipe ste'ca lajt. Dxejc diru dade'ga nuhuii lo Felipe. Sä'ti dade'ga lajdxni, cabalazduxhni. ");
INSERT INTO zawNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Dxejcti chela gucbee Felipe abidzujṉni guedx Azoto. Baluiizani xtidx Dios neṉ guiraa reguejdx che bidzujṉlini guedx Cesarea. ");
INSERT INTO zawNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Laḻtis cagusacsí Saulo rexpejṉ Jesucrist. Rlajzni ju'tni guiraareni, ni'c huijni lo bixhojz nani rnibee, ");
INSERT INTO zawNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","gunabni gac te guijtz chanäni lo reguidoo neṉ guedx Damasco te palga guidxälni reni najc xpejṉ Jesucrist neṉ reguidooga, niguii sigac gunaa, guliibnireni, jiädnänireni guedx Jerusalén te jiäureni. ");
INSERT INTO zawNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Laḻ sasajni lo nezyuj, asiäddzuṉgajxhni guedx Damasco, basaniya' te bal xhaguibaa, basanijni guideb gabi cadro siädsaj Saulo. ");
INSERT INTO zawNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Dxejc biajbni lo yuj, biejn diajgni te xse' bejṉ nani canii lojni: ―Saulo, Saulo, ¿xhicuent rusacsílu narä, näjza rexpeṉa? ");
INSERT INTO zawNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Räjp Saulo lojni: ―¿Chuluj Dad? Räjpni lo Saulo: ―Narä nacä Jesucrist, nani cagusacsíduxhlu. Niluxh lagajc luj cadejdlu trabajw si'c rajc te gon ni rucuani' yejc caru'ch. ");
INSERT INTO zawNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Bidxebduxh Saulo, racsejsni räjpni: ―Dad, ¿xhini'c rlajzlu gunä? Dxejc räjp Jesús loj Saulo: ―Huistie, biu' guedx Damasco. Ro'c suluii te niguii xhini'c gunlu. ");
INSERT INTO zawNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Rebejṉ ni siädnä Saulo sugadxireni, bidxejbreni sa'csi biejn diajgreni te xse' bejṉ, luxh rut lojdi bahuiireni. ");
INSERT INTO zawNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Che huistie Saulo lo yuj, baxhalni lojni, niluxh di lojni jieṉ. Dxejc gunaazreni ṉaani, sanärenini guedx Damasco. ");
INSERT INTO zawNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ro'c guyu'ni choṉ dxej, natiä'p balojni, dini niä', dizani niajw. ");
INSERT INTO zawNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Guedx Damasco rbäjz te xpejṉ Jesucrist ni laa Ananías. Baluiloj Jesucrist loj Ananías lo te bacaḻ, räjp Jesucrist lojni: ―Ananías. Dxejc räjp Ananías lojni: ―Anaree Dad. ");
INSERT INTO zawNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Räjp Jesucrist lojni: ―Huistie te chäälu lo nezyuj ni laa Ladbee cad rbäjz Judas. Ro'c guiniabdiidxlu con te niguii ni laa Saulo, beṉ Tarso. Cabejdx, canabni loä ṉaj. ");
INSERT INTO zawNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Lo bacaḻ abahuiini siääd te niguii ni laa Ananías te gutzuubni ṉaani yejcni te fiini stehuält. ");
INSERT INTO zawNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Dxejcti räjp Ananías lojni: ―Dad, abiejn diagä xho basacsí niguiiga rexpejṉlu neṉ guedx Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Luxh rebixhojz ni rnibee abadeed guijtz lojni te guiniaazni ree guiraa rebejṉ nani rbedx-rniab lojlu, chanänireni jiäureni. ");
INSERT INTO zawNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Dxejcti räjp Jesucrist lojni: ―Huij, narä aguleäni te gunni xtzunä. Suluiini xtidxä loj rebeṉzijt nani digac xpeṉ Israel, näjza loj reni rnibee renacioṉ, näjza loj rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Narä suluiä lo Saulo trabajwduxh ni tedni te jiädnajlni narä. ");
INSERT INTO zawNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Dxejcti sää Ananías, bidzujṉni ro yu' cadro rbäzlaa Saulo. Batzuubni ṉaani yejc Saulo. Dxejcti räjp Ananías loj Saulo: ―Betzä Saulo, Jesucrist ni rnibee, nani baluiloj lojlu lo nezyuj cheni siäädlu, lagajc laani baxhaḻni narä te fiilu stehuält, te jiädläjzza Sprit Dxan xten Dios neṉ lastoolu. ");
INSERT INTO zawNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Lagajc dxejc bitejb si'c xmelbäjl yec baloj Saulo, biacgajc balojni, bahuisa'cni stehuält. Dxejc huistieni, gurobnisgajcni. ");
INSERT INTO zawNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Dxejc gudajwni, guc nadaanni stehuält. Xchej guyunäj Saulo rexpejṉ Jesucrist neṉ guedx Damasco. ");
INSERT INTO zawNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Dxejcti gusloj basule' Saulo xtidx Dios neṉ reguidoo xten rexpejṉ Israel, räjpni: ―Jesucrist najc Xi'n Dios nani gujc Niguii. ");
INSERT INTO zawNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Che biejn diajgreni xtiidxni, bidxelojreni, räjp lo sa'reni: ―¿La xhet laadi niguiire ni rusäu rexpejṉ Jesucrist neṉ latzguiib guedx Jerusalén, ä? Lagajcza dee bidzujṉ ree te guliibni rexpejṉ Jesucrist te chanänireni guedx Jerusalén lo rebixhojz. ");
INSERT INTO zawNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Dxejcti gusutzu'tz Saulo guniini xtidx Dios. Basacajṉni rexpejṉ Israel nani rbäjz Damasco sa'csi basule'pacni Jesús najc Crist nani rnibee. ");
INSERT INTO zawNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Che gudejd xhidajl dxej, bachagsa' rexpejṉ Israel te nugu'treni Saulo. ");
INSERT INTO zawNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Dxejcti gucbee Saulo xhi xhigab bejnreni. Dxej, yääl cabäjzreni Saulo ro' guiraa renezyuj ni rdzujṉ guejdxga te ju'trenini. ");
INSERT INTO zawNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Dxejcti che gojḻ te yääl basäḻ rexpejṉ Jesucrist Saulo neṉ te dxim̲ro, basiäjtreni dxijm̲ga nez ro' te padeer ni dejd gabi guejdxga. Basiäjtrenini nez dejtz padeerga, te si'c baxuṉni guejdxga. ");
INSERT INTO zawNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Che bidzujṉ Saulo guedx Jerusalén, rlajzni nuchaagni loj reni rililajz xtidx Jesucrist, niluxh guiraareni bidxejbrenini sa'csi direni gan ahuililajzni xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Dxejcti huinä Bernabéni lo reapost, bijni diidx xcuent Saulo. Räjp Bernabé lojreni: ―Baluiloj Jesucrist lo Saulo loj nezyuj. Guninäj Xtioznu Saulo loj nezyuj, ni'cni gusutzu'tz Saulo basule'ni xtidx Jesucrist guedx Damasco. ");
INSERT INTO zawNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Dxejc bia'n Saulo guedx Jerusalén, bidxaagni lo rexpejṉ Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Dxejcti gusutzu'tz Saulo gusloj bijni xtidx Jesucrist lo rebejṉ. Dxejcti gudiḻnäj Saulo rexpejṉ Israel nani rnii didx griegw. Laareni rdxechduxhreni, rlajzreni nugu'treni Saulo sa'csi direni nichaglajz xtidx Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Che gucbee rexpejṉ Jesucrist si'c, huinäreni Saulo guedx Cesarea, ro'c gulääreni Saulo, baxhaḻrenini guedx Tarso. ");
INSERT INTO zawNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Dxejc guredxi lajz guiraa renani huililajz xtidx Dios neṉ reguedx Judea, neṉ reguedx Galilee, näjza neṉ reguedx Samaria, sa'csi diru Saulo nusacsí rexpejṉ Jesucrist, luxh guc xhidajlrureni. Basoobreni xtidx Jesucrist, bisieedrureni rextiidxni, gucnäjza Sprit Dxan xten Diosreni. ");
INSERT INTO zawNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Che gusloj sahuii Pedr guiraa renani huililajz xtidx Dios, huihuiizani rexpejṉ Jesucrist nani yu' guedx Lida. ");
INSERT INTO zawNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ro'c bidxälni te niguii ni laa Eneas. Agujc xhujṉ ijz naga' niguiiga cayacxhuuni. Abixu'ṉ tiejxhni, digacdiru guiliini. ");
INSERT INTO zawNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Dxejcti räjp Pedr lo Eneas: ―Eneas, cagusiajc Jesucrist guejblu. Huistie, guläs xta'lu. Lagajc dxejc biajcni, huistietini. ");
INSERT INTO zawNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Guiraa rebejṉ ni rbäjz guedx Lida, näjza rebeṉ ni rbäjz guedx Sarón, bahuiireni abiajc niguii ni cayacxhuu. Dxejc xhidajlreni neṉ reguejdxga huililajz xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Neṉ guedx Jope yu' te gunaa ni laa Tabita; rniizarenini Dorcas con xtidx griegw. Gunaaga huililajz xtidx Dios, rudeedzani xhi rquiin rebeṉproob, najczani huenduxh loj chutis bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Gucxhuu gunaaga, dxejc gujtni. Che gulujx bahuajz rebejṉ togoolga, huitixhrenini neṉ te yu' ni najc jiaa yejc sa'ni. ");
INSERT INTO zawNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Sa'csi gajxh guedx Jope tre' guedx Lida, luxh biejn diajg rexpejṉ Jesucrist ro'c yu' Pedr, baxhaḻreni tiop dade' saxii Pedr. Räjp redade'ga loj Pedr: ―Bejn huen salu chonnu Jope naṉajga. ");
INSERT INTO zawNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Dxejc sanägajc Pedr redade'ga. Che bidzujṉreni, huinäreni Pedr neṉ yu' cadro naga' togunaaga. Ro'c cayonduxh guiraa regunabiuud, baluiireni lo Pedr guiraa rexhajbreni nani benchee Dorcas, ni badeed Dorcas lojreni che nabajṉni. ");
INSERT INTO zawNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Dxejcti gunibee Pedr birii guirareni neṉ yu'. Dxejc bazuxhijbni, guredx-gunabni loj Dios. Dxejc gubiréni bahuiini loj togoolga, räjpni: ―Tabita, huistie. Dxejcti baxhal gunaaga balojni; che bahuiini loj Pedr, gurejni. ");
INSERT INTO zawNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Dxejc gunaaz Pedr ṉaani, basuliinini, dxejcti gurejdx Pedr regunabiuud näjza sgaii reni najc rexpejṉ Jesucrist. Baluiini gunaaga lojreni te bahuilojreni agubaṉsacni. ");
INSERT INTO zawNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Gucbegajc rebeṉ guedx Jope xhini'c gujc, dxejcti xhidajl rebejṉga huililajz xtidx Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Xchejza guyu' Pedr ro'c, guläjzni rolijz dade' ni laa Simón, nani ruscoodz guijd. ");
INSERT INTO zawNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Guedx Cesarea guyu' te niguii ni laa Cornel. Rnibeeni te gayuu resoldaad lo te cuaa ni laa Italiano. Cornel najc beṉzijt, dini gac beṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Beṉsacduxh najc Cornel, näjza guiraa resa'ni, sacruduxh rusoobreni xtidx Dios. Rudeedni gojn lo rebeṉ proob xten Israel. Guixe-guixee rbejdx, rniabni lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Te dxej, si'cti rcachoṉ gudxej, si'c lo bacaḻ bahuiini loj xangl Dios, räjpni loj Cornel: ―¿Conlu Cornel? ");
INSERT INTO zawNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Che bahuii Cornel xangl Dios, bidxejbni, bidxelojni, räjpni lojni: ―¿Xhini'c, Dad? Dxejcti räjp angl xten Dios lojni: ―Che rniilu lo Dios, riejn diajg Dios xtiidxlu, che rudeedlu meel lo rebeṉ proob, ruhuii Dios ni rujnlu, ni'cni rnalajz Dios luj. ");
INSERT INTO zawNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","N̲aj baxhaḻ tiop niguii chää guedx Jope te chaxiireni Simón Pedr. ");
INSERT INTO zawNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Rbäjzni rolijz te dade' ni laa Simón nani ruscoodz guijd. Rolijz Simón sojb gajxh ro' nisdoo. Simón Pedr gusule' xhini'c nanab gunlu. ");
INSERT INTO zawNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Che sii angl xten Dios, gule Cornel tiop mos xtenni näjza te xsoldaadni nani sanälajz Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Dxejc bij Cornel diidx lojreni xcuent ni gusajcni, dxejc baxhaḻni redade'ga guedx Jope. ");
INSERT INTO zawNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Che bara yääl, sääreni lo nezyuj. Asiäddzuṉgajxhreni guedx Jope, pet si'cti läidxejni. Lagajc oṟga huä'p Pedr yecyu' te guininäjni Guejb Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Calanduxh Pedr, rlajzni gauni. Laḻ ni cayujnreni xhi gauxhuejni, gusloj canixcaḻni. ");
INSERT INTO zawNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Bahuiini bixal xhaguibaa, bahuiizani biäjt te bariadro nani naliib guidap xi'ni. Siädjiätchäiini gajxh nez loj Pedr. ");
INSERT INTO zawNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Neṉ bariaadga yu' guiraa reman ni yu' lo guedxliuj nani rsianäj guidap ni'ni, näjza renani rxeeb si'c bäḻ, näjza renani rutajt. ");
INSERT INTO zawNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Gunii Dios lo Pedr, räjpni lojni: ―Pedr, huisu te ju'tlu man gaulu. ");
INSERT INTO zawNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Dxejc räjp Pedr lojni: ―Na'c Dad. Nunc gauä sa' remandxuudxga, abia'a dina gauä reman nani rnii xleiilu najc mandxuudx. ");
INSERT INTO zawNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Gunisac Dios loj Pedr, räjpni: ―Na'cru guiniilu nacdxuudx reman nani abasia. ");
INSERT INTO zawNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Che gujc choṉ huält gujc si'c, huä'psac bariaadga xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Laḻ ni cayujn Pedr xhigab xhichani'c säloj nani bahuiini, bidzujṉ reniguii ni baxhaḻ Cornel ro' yu'ga, sa'csi agunabdiidxreni caro rbäjz Simón nani ruscoodz guijd. ");
INSERT INTO zawNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Che bidzujṉreni rolä'ga canabdiidxreni la ro'c rbäjz te dade' ni laa Simón Pedr. ");
INSERT INTO zawNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Laḻ ni cayujn Pedr xhigab xcuent ni bahuiini, gunii Sprit Dxan xten Dios lojni, räjpni: ―Bahuii, choṉ dade' caguiillu. ");
INSERT INTO zawNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Biäjt yejc yu're te jinälureni. Na'c gunlu xhi stee xhigab, sa'csi lagajc narä baxhaḻäreni lojlu. ");
INSERT INTO zawNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Dxejcti biäjt Pedr jiaaga, bidzujṉni cadro suga' redade'ga, räjpni lojreni: ―Narä nacä ni caguiiltu. ¿Xhi siäädtu? ");
INSERT INTO zawNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Räjp reniguiiga lo Pedr: ―Cornel, nani rnibee te gayuu soldaad, te beṉsa'c, te bejṉ ni rajṉ Dios, te bejṉ ni sanälajz rexpejṉ Israel, laani baxhaḻ nuure lojlu, sa'csi räjp angl xten Dios lojni, jiopxiinu luj te jiejn diajgnu xtiidxlu. ");
INSERT INTO zawNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Dxejcti gurejdx Pedr rebejṉga, biu'reni neṉ yu'. Ro'c bia'nreni te guxhijṉ. Che bara yääl, Pedr näjza sgaii beṉ Jope ni najc xpejṉ Jesucrist, sanä redade' ni baxhaḻ Cornel. ");
INSERT INTO zawNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Che bara yääl, bidzujṉreni guedx Cesarea. Abatojp Cornel resa'ni näjza rexamigwni rolijzni. Cabäjzreni guidzujṉ Pedr. ");
INSERT INTO zawNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Che bidzujṉ Pedr ro yu', huichagloj Cornelni, bazuxhijbni lo Pedr. ");
INSERT INTO zawNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Dxejc gunaaz Pedr ṉaani, guläsnini, räjpni lojni: ―Huisulii, sa'csi narä nacä te niguiitis sigajc najclu. ");
INSERT INTO zawNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Cayuiireni diidx, biu'reni neṉ yu'. Che biu'ni bahuii Pedr nadxagsa' rebejṉ neṉ yu'. ");
INSERT INTO zawNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Räjp Pedr lojreni: ―Anajntu xhi caj lo leii xten rexpejṉ Israel: digacdi guchaag te xpejṉ Israel loj beṉzijt nani digac xpejṉ Israel, digacdiza jiu'ni rolijzreni. Niluxh agunii Dios loä lo te bacaḻ, te gacbeä digacdiru jiuä releiire. Abaluii Dios narä sajc guchagsa'ä chutis bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ni'cni, che gurejdxtu narä biälgacä. N̲aj rniabdidxä, ¿xhicuent gurejdxtu narä? ");
INSERT INTO zawNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Dxejcti räjp Cornel loj Pedr: ―Gudajp dxej si'cti rcachoṉ gudxej, cabedx-canabä lo Dios rolizä chela baluiloj te niguii najcw te ladnol ni rdimbicha'. ");
INSERT INTO zawNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Najni loä: “Cornel, che rbedx-rniablu lo Dios, riejn diajg Dios xtiidxlu, che rudeedlu meel lo rebeṉ proob, racbee Dios, di lajzni jiäḻ luj. ");
INSERT INTO zawNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ni'cni ṉaj baxhaḻ tiop dade' chää guedx Jope te chaxiireni Simón Pedr nani rbäzlaa rolijz Simón ni ruscoodz guijd. Rolijzni sojb gajxh ro' nisdoo. Che guidzujṉni, laani gusule'ni xtidx Dios lojtu.” ");
INSERT INTO zawNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Dxejc baxhaḻä chu biädxiilu. Xquixtiostelu biäädlu. N̲aj anadxagsa'nu ree nez loj Dios te jiejn diajgnu rextidx Dios ni baniidxni lojlu guiniilu loonu. ");
INSERT INTO zawNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Dxejcti räjp Pedr lojreni: ―N̲aj gucbeliä tebloj rinälajz Dios guiraa bejṉ; rebeṉzijt sigajc rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Niluxh rinälajz Dios chutis beṉ guedxliuj nani ruzuxhijb lojni, nani rusoob rextiidxni, nani laaca nabajṉ. ");
INSERT INTO zawNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Badeed Dios xtiidxni loj rexpejṉ Israel, basule' Dios biääd Jesucrist te gac chanälaaznu Dios te cuedxilajznu, sa'csi Jesucrist rnibee guideb guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Che gulujx baluii Juan ni rutiobnis xcuent yäḻrobnis, dxejc gusloj basule' Jesucrist xtidx Dios nez reguedx Galilee. La'tu najntu xho bire'ch xtidx Jesucrist guideb nez neṉ reguedx Judea. ");
INSERT INTO zawNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nancheetu xho badeed Dios yäḻrnibee loj Jesucrist, beṉ Nazare't. Badeedza Dios Sprit Dxan xtenni te cuääzni neṉ lastooni. Nancheetu xho bejnni redzunro, remilagwr, basiajcni rebejṉ nani caguteed beṉdxab trabajwduxh. Redzunroga bejnni sa'csi bennäj Diosni dzuun. ");
INSERT INTO zawNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Bahuiloonu guiraa redzuun ni bejn Jesucrist neṉ reguedx Israel näjza guedx Jerusalén. Bacuaa rexpejṉ Israel Jesucrist lo crujz, ro'c gujtni. ");
INSERT INTO zawNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Dxejcti che biojṉ dxej, guläs Dios Jesucrist lo rebeṉgut, gubaṉsacni, badeed Dios yäḻrnibee lojni te gujc biädluiloj Jesucrist loonu. ");
INSERT INTO zawNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Di Jesucrist nuluiloj loj chutis bejṉ. Lojtis renani agule Dios gutie'ch diidx gubaṉsac Jesucrist lo rebeṉgut, loj reni'c baluilojni. Nuure nadxagnu loj reni gule Dios. Bidaunänuni, bidunnäänuni che gubaṉsacni lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Baxhaḻni nuure chatie'chnu diidx loj guiraa rebejṉ, chosule'pacnu Dios gule Jesucrist te gacni juejz xte rebeṉbajṉ näjza xte rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Galooli bacuaa renani gunii xtidx Dios lo guijtz, räjpreni: “Guiraa rebejṉ ni chalilajz xtidx Jesucrist sudzucaj Dios xtojḻreni.” ");
INSERT INTO zawNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Laḻ ni canii Pedr rediidxga, biädläjz Sprit Dxan xten Dios neṉ lastoo renani huililajz xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Bidxeloj guiraa rexpejṉ Israel nani huinä Pedr sa'csi biädläjz Sprit Dxan xten Dios neṉ lastoo renani najc beṉzijt. ");
INSERT INTO zawNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Gucbeereni biu' Sprit Dxan xten Dios lastoo rebeṉzijt sa'csi bejn Sprit Dxan guniireni stee didxsaj nani gajdreni guisieed, calä'pzareni xpala'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Dxejcti räjp Pedr lo rexamiigwni: ―Chu laa ni gudxojn yäḻrobnis lo rebejṉre, ni sigajc biädläjz Sprit Dxan xten Dios neṉ lastoonu, abiädläjzni neṉ lastoo rebejṉre. ");
INSERT INTO zawNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Dxejcti gunibee Pedr gurobnisreni te gacbee bejṉ najcreni xpejṉ Jesucrist. Dxejcti gunabreni loj Pedr jia'nni ro'c tiop-choṉ dxej. ");
INSERT INTO zawNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Reapost, näjza renani huililajz xtidx Jesucrist neṉ reguedx Judea, biejn diajgreni huililajz rebeṉzijt ni digac xpejṉ Israel xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Che bidzujṉ Pedr guedx Jerusalén, rexpejṉ Israel nani rlajz chu guiraa rexpejṉ Jesucrist bee si'cni bejn toAbram, gudiḻnäjreni Pedr. ");
INSERT INTO zawNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Räjpreni lo Pedr: ―¿Xhicuent biu'lu rolijz beṉzijt nani xhet yu'di bee si'c nuure? ¿Xhicuent gudaunäjlureni, ä? ");
INSERT INTO zawNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Dxejcti basule' Pedr diidx xho gujc huijni loj rebeṉzijt: ");
INSERT INTO zawNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Yu'ä guedx Jope. Cabedx-canabä lo Dios, dxejc si'c gunixcaḻä, bahuiä bixal xhaguibaa, siädjiäjt te bariadro, naliib guidap xi'ni. Siädjiätchäiini nez loä. ");
INSERT INTO zawNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Che bahuisa'cä, neṉga yu' guiraloj reman ni yu' lo guedxliuj nani rsianäj guidap ni'ni, renani rbäjz neṉ dajn, renani rxeeb si'c bäḻ, näjza renani rutajt. ");
INSERT INTO zawNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Dxejcti biejn diagä naj Dios loä: “Pedr, huisu. Bagu't man gaulu.” ");
INSERT INTO zawNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Dxejcti räpä: “Digacdini Dad. Nicla tej gadna gauä te man nani rnii leii xtenlu najc mandxuudx.” ");
INSERT INTO zawNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Dxejc gunisac Dios loä: “Na'cru guiniilu nacdxuudx recos nani abasia Dios.” ");
INSERT INTO zawNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Che gujc choṉ huält gunii Dios si'c, huä'psac bariaadga xhaguibaa. ");
INSERT INTO zawNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Lagajc oṟga bidzujṉ choṉ dade' ro yu' cadro yu'ä. Guedx Cesarea biriireni, biädxiireni narä. ");
INSERT INTO zawNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Dxejc gunii Sprit Dxan xten Dios loä: “Huinä reniguiire. Na'c gun tiop lajzlu.” Dxejcti huinää́ xho'p beṉ Jope, dade' nani rililajz xtidx Jesucrist. Che bidzuṉnu guedx Cesarea, biu'nu rolijz Cornel. ");
INSERT INTO zawNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Basule' Cornel diidx loonu xho baluiloj te angl xten Dios lojni lagajc rolijzni. Räjp angl xten Dios lojni: “Baxhaḻ tiop dade' chää guedx Jope te chaxiireni Simón ni rniireni Pedr. ");
INSERT INTO zawNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Laani siniini xtidx Jesucrist te gacbeelu con resa'lu xhini'c nanab gunlu te gusḻaa Dios la'tu lo rextojḻtu.” ");
INSERT INTO zawNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Che gusloj cagusule'ä xtidx Dios lojreni, biu' Sprit Dxan xten Dios neṉ lastooreni si'c biu'ni lastoonu galooli. ");
INSERT INTO zawNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Dxejcti banaj lazä rextidx Dad Jesucrist che najni: “Juan abatiobnis con nistis, biädla narä suxhaḻä Sprit Dxan xten Dios te cuääzni neṉ lastootu.” ");
INSERT INTO zawNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Dxejc räjpza Pedr: ―Palga badeed Dios Sprit Dxan xtenni lojreni si'c baniidxni Sprit Dxan xtenni loonu che huililajznu xtidx Jesucrist, ¿chu narä? te niäpä lo Dios: “Na'c gudeedlu Sprit Dxan xtenlu lojreni.” ");
INSERT INTO zawNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Che biejn diajg rebeṉ Jerusalén rediidxga, biäuu ro'reni, dirureni nidiḻnäj Pedr. Alga gulä'preni xpala'n Dios, räjpreni: ―Näjza rebeṉzijt nani digac rexpejṉ Israel abasaan Dios gusiechlajzreni te guibaṉnäjreni Dios par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Che gujt Esteban bire'ch renani huililajz rextidx Jesucrist. Bire'chreni lo yuj Chipre ni ṟe' lo nisdoo, lo reguedx Fenicia, näjza lo guedx Antioquía sa'csi cadejdreni trabajwduxh. Basule'reni rextidx Jesucrist lojtis rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Lojreni nadxaag gaii beṉ Chipre, näjza gaii beṉ Cirene. Redee bidzujṉ guedx Antioquía. Ro'c gusloj caniireni lo beṉzijt nani rnii didx griegw. Basule'reni lo rebeṉzijtga guiraa xcuent Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Gucnäj Diosreni caniireni xtiidxni. Xhidajl rebejṉga huililajz xtidx Jesucrist, basoobreni xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Che biejn diajg rexpejṉ Jesucrist ni yu' guedx Jerusalén rililajzreni, baxhaḻreni Bernabé guedx Antioquía. ");
INSERT INTO zawNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Che bidzujṉ Bernabé guedx Antioquía, bibalazduxhni che bahuiini xho cayunnäj Dios rebejṉga. Dxejcti balijdx Bernabéreni: gutijp lajzreni gusoobreni xtiidxtis Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Beṉsa'c najc Bernabé. Rililazduxhni xtidx Jesucrist. Racnäjduxh Sprit Dxan xten Diosni. Xhidajl rebejṉ huililajz xtidx Jesucrist guejdxga. ");
INSERT INTO zawNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Che birii Bernabé guejdxga, huijni guedx Tarso satiilni Saulo. ");
INSERT INTO zawNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Che bidxälni Saulo, huinänini guedx Antioquía. Ro'c bia'nreni tebijz, bachagsa'reni renani huililajz te baluiireni xtidx Jesucrist lo xhidalduxh bejṉ. Ganid beṉguejdxga gulälaj “Cristianos” renani rililajz xtidx Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Neṉ redxejga birii gaii dade' nani rnii xtidx Dios. Guedx Jerusalén biriireni, bidzujṉreni guedx Antioquía. ");
INSERT INTO zawNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Huisulii te dade'ga ni laa Agabo. Gucnäj Sprit Dxan xten Diosni te guniini siääd te gubijn guideb guedxliuj. Luxh gujc gubijnga neṉ reijz ni gunibee ṟeii Claudio ni sajcru. ");
INSERT INTO zawNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Dxejcti rexpejṉ Jesucrist ni rbäjz guedx Antioquía bejn xhigab cade tejreni gudeed meel chää lo rexpejṉ Jesucrist ni rbäjz neṉ reguedx Judea. ");
INSERT INTO zawNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Batojpreni meel, baxhaḻrenini lo rebeṉgool ni rnibee rexpejṉ Jesucrist ro'c. Saulo näjza Bernabé huinä meelga che huijreni Judea. ");
INSERT INTO zawNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Neṉ redxejga, trabajwduxh bateed ṟeii Herodes gaii rexpejṉ Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Gunibeeni gujt Jacoob betz Juan, biru' guejnni. ");
INSERT INTO zawNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Che bahuii Herodes bibalazduxh rexpejṉ Israel sa'csi bagu'tni Jacoob, gunibeeni gunazgajcreni Pedr. Dee gujc neṉ redxe lanij che rajwreni yätxtiil ni di saguij. ");
INSERT INTO zawNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Che gunaazreni Pedr, biäuni neṉ latzguiib. Gunibee Herodes biääd tajp cuaa soldaad cuanäjreni ro' latzguiib. Tapgaj soldaad cuanäj ro' latzguiibga cade xho'p oṟ. Bejn Herodes xhigab cuääni Pedr te guetni nez loj rexpejṉ Israel che ted lanij. ");
INSERT INTO zawNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Yu'ti Pedr neṉ latzguiib, dxejcti durtis cabejdx, canab rexpejṉ Jesucrist lo Dios xcuent Pedr. ");
INSERT INTO zawNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Bidzujṉti dxe bispr dxej ni rlajz Herodes nibää Pedr nez loj rexpejṉ Israel. Yäälga nagayejs Pedr galäii tiop soldaad. Cadeṉ naliib guiro'p ṉaa Pedr. Stiop soldaad canäj ro' latzguiib. ");
INSERT INTO zawNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Chela baluiloj te angl xten Dios, bianij te bajl nani basanij neṉ latzguiib. Dxejcti gunaazni xhajcw Pedr, basniibnini te gubajṉni. Räjpni lo Pedr: ―Basquejnga, huistie. Dxejcti bixec recadeṉ, bitejbreni ṉaa Pedr. ");
INSERT INTO zawNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Räjp xangl Dios lo Pedr: ―Gojt xhajblu, baläj xcura'chlu. Si'c bejn Pedr, dxejc räjp xangl Dios lo Pedr: ―Gojt xhablajzlu, gudanajl narä ―räjpni. ");
INSERT INTO zawNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Biriitini latzguiib sanajlni angl xten Dios. Niluxh dini gun xhigab guliipac nani bejn xangl Dios. Bejnni xhigab pet canixcaḻni. ");
INSERT INTO zawNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Gudejdreni nez loj te soldaad, gudedgajcreni nezloj steeni, dxejc bidzujṉreni ro' puertguiib xten latzguiib nani caj lo nezyuj ni rdejd galäii guejdxga. Xtebca bixal puertroga, biriireni gusajreni tebnezyuj. Dxejcti te squiin gunitloj xangl Dios. Xtebtis Pedr sasaj lo nezyuj. ");
INSERT INTO zawNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Dxejc si'cni gubajṉ Pedr, bejnni xhigab: ―N̲aj sii nanä baxhaḻ Dios te xanglni basḻaa narä ladzṉaa Herodes te digacdi gun rexpejṉ Israel nani rlajzreni gunnäjreni narä. ");
INSERT INTO zawNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Che gucbee Pedr xhi gusajcni, huijni rolijz Marii, xnan Juan ni rniireni Marcw. Ro'c nadxagsa' xhidajl rexpejṉ Jesucrist, cabedx-canabreni lo Dios xcuent Pedr. ");
INSERT INTO zawNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Cagusejz Pedr rolä', dxejc gubig te dxa'p ni ḻaa Rode, bacuadiajgni ro lä'. ");
INSERT INTO zawNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Che biembee Rode xse' Pedr, sa'csi bibalazduxhni, biaḻlajzni nuxhalni ro lä'. Alga baxuṉni biusacni neṉ yu', räjpni lojreni: ―Pedr suga' ro lä'. ");
INSERT INTO zawNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Dxejcti räjpreni lo Rode: ―Yejclu cayajc. Dxejcti duurtis gunii dxape'ga suga' Pedr ro lä'. Dxejcti räjpreni loj Rode: ―Xho gacni Pedr. Pet biejn diajglu gunii xangl Dios ni rcanäj Pedr. ");
INSERT INTO zawNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Dxejcti laḻtis cagusejz Pedr ro lä'. Che baxhalreni ro lä' bidxeloduxhreni bahuiireni lo Pedr. ");
INSERT INTO zawNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Dxejcti bazääb Pedr ṉaani te na'cru jiejyreni. Dxejc bij Pedr diidx xho baxhal Dios ro' latzguiib. Dxejc räjpni: ―Coḻchaye'tz lo Jacoob näjza lo rexpejṉ Jesucrist guiraa ni gusacä nayääl. Dxejcti birii Pedr ro'c, huijni ste'ca lajt. ");
INSERT INTO zawNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Che bara yääl, rsildooru, bieiduxh resoldaad sa'csi direni gan xho gujc birii Pedr neṉ latzguiib. ");
INSERT INTO zawNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Gunibee Herodes huitiilreni Pedr, gunabdiidxzani lo resoldaad xho gujc birii Pedr, dxejc gunibeeni gujt resoldaad ni cuanäj latzguiib che birii Pedr. Dxejcti birii Herodes reguedx Judea, xchej huijia'nni guedx Cesarea. ");
INSERT INTO zawNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Bachechduxh rebeṉ Tiro näjza rebeṉ Sidón Herodes, ni'cni diruni gusaan guto' rebejṉ nez cadro rnibeeni xhi gau rebeṉ Tiro näjza rebeṉ Sidón. Ni'c biääd xhidajlreni te guiniabreni jiäjḻ lajzni, te na'cru guidxe'ch Herodes lojreni. Abenxgaareni xamiigwreni Blasto, mos ni yu' lo ṟeii Herodes, mos ni sajcru lo guiraa rexmos Herodes. Guninäj Blasto Herodes xcuentreni te na'cru guidxechnäj Herodes rebejṉga. ");
INSERT INTO zawNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Basoobtini te dxej te guininäjnireni. Dxejga gojt Herodes xhajb ṟeiini, gurejni lo xyacxhiḻ ṟeiini. Dxejcti gusloj caniini didxsa'c loj rebejṉga. ");
INSERT INTO zawNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Guredxa' rebejṉ räjpreni lojni: ―Huenduxh najc diidxre. Guejblu najc te dios, xhet xtiidxdi niguii najc diidxre. ");
INSERT INTO zawNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Lagajc dxejc biääd te angl xten Dios, bejnni gusloj cayacxhuu Herodes, gudajw rebisiujg Herodes, gujtni sa'csi basaanni gunii rebejṉ najcni te dios, sa'csi dini niliä'p xpala'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Xhidajl bejṉ biejn diajgni xtidx Dios, huililajzreni xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Che gulujx badeed Bernabé näjza Saulo meel ni batojp rebeṉ Antioquía lo rebeṉgool, biriireni guedx Jerusalén. Sanäreni Juan ni rniireni Marcw lo guedx Antioquía. ");
INSERT INTO zawNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Lo rexpejṉ Jesucrist ni rdxaag sa' guedx Antioquía guyu' gaii niguii ni gunii xtidx Dios, näjza gaii niguii ni rusule' xtidx Dios loj guiraa rexpejṉ Jesucrist. Loj redee nadxaag Bernabé, näj Simón ni rniireni Negr; näj Lucio, beṉ Cirene; näj Manaén ni gulanäj ṟeii Herodes gujcni si'c bejtzni; näjza Saulo. ");
INSERT INTO zawNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Bidzujṉ te dxej cagucua'nreni laḻ ni cabedx-canabreni lo Dios, dxejc räjp Sprit Dxan xten Dios lojreni: ―Coḻcue Bernabé näjza Saulo te gunreni dzuun ni rlazä gunreni. ");
INSERT INTO zawNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Che gulujx bacua'nreni, che gulujxza guredx-gunabreni lo Dios, batzuubreni ṉaareni yejc guiro'preni, te si'c baxhaḻreni Bernabé näjza Saulo te guluiireni xtidx Dios ste'ca lajt. ");
INSERT INTO zawNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Baxhaḻ Sprit Dxan xten Dios Saulo näjza Bernabé guedx Seleucia. Ro'c biu'reni neṉ barcw, sääreni nez yuj ni tre' galäii nisdoo, ni laa Chipre. ");
INSERT INTO zawNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Che bidzujṉreni Chipre, biu'reni guedx Salamina. Ro'c basule'reni xtidx Dios neṉ guiraa rexquidoo rexpejṉ Israel. Näj Marcw gucnäjreni. ");
INSERT INTO zawNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Che cuansajreni guideb yuj Chipre, bidzujṉreni guedx Pafos. Ro'c bidxaagreni te niguii ni laa Barjesús. Najcni te bidxaa, najczani te xpejṉ Israel. Cagusgueeni rebejṉ guejdxga, räjpni xtidx Dios caniini, niluxh dini gac xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Bidxaare nu'ch lo rexpejṉ Sergio Paulo, nani najc gubernadoor xten Chipre. Nasiṉduxh Sergio Paulo. Gurejdxni Bernabé näjza Saulo, sa'csi rlajzni jiejn diajgni xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Dxejcti Barjesús, ni laaza Elimas, bidxagdijḻni guiro'preni sa'csi di rlajzni chalilajz Sergio Paulo xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saulo, nani laaza Pabl, bahuitzu'tz loj Barjesús. Batijp Sprit Dxan xten Dios lastoo Pabl, räjpni loj Barjesús: ");
INSERT INTO zawNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","―Rusgueduxhlu rebejṉ, najclu beṉlatsiaj, beṉguidxduxhlu, najclu xi'n Satanás, beṉdxab ni rnibee. Rdxechnäjzalu guiraa recossa'c xten Dios. ¿Guc cuääz guxhiidlu xtidxlii Jesucrist te di chalilajz bejṉ xtidx Jesucrist? ");
INSERT INTO zawNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","N̲aj siääd xcastiigw Dios yejclu. Xhidajl dxej sicäjy lojlu, xhetliidi fiilu ―räjp Pabl. Gujcsi räjpni si'c, bicäigajc lojni. Dxejctiru cuansajni caguiilni chu guiniaaz ṉaani guluiini canejz chääni. ");
INSERT INTO zawNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Che bahuii Sergio Paulo xhi gusajcni, huililajzni xtidx Dios, sa'csi bidxeloduxhni xcuent xcäḻruluii Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Che baluux Pabl näjza resa'ni xtzuunreni guedx Pafos, biu'reni neṉ barcw, gudejdreni lo nisdoo, sääreni guedx Perge neṉ estad Panfilia. Che bidzujṉreni guejdxga, gubisac Juan, ni rniireni Marcw, Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Dxejcti birinäj Pabl resa'ni guedx Perge, sääreni guedx Antioquía neṉ distrit Pisidia. Dxejc te dxe sabd, dxej ni rusilajz rexpejṉ Israel, biu'reni neṉ xquidoo rexpejṉ Israel, ro'c gurejreni. ");
INSERT INTO zawNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Che gulujx biḻ te dade' reguijtz xten Dios ni laa leii näjza reprofe't, baxhaḻ reguxhtis xten guidoo chu huigajṉreni, räjpreni lo Pabl näjza Bernabé: ―La'tu sa'nu, palga rajptu te diidx ni gulijdx rebejṉre, coḻguiniini. ");
INSERT INTO zawNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Dxejc huisulii Pabl, guläsni ṉaani bejnni seen lo rebejṉ te cuadiajgreni xtiidxni. Räjp Pabl lojreni: ―Coḻcuadiajg, la'tu rexpejṉ Israel, guiraatu ni rajṉ Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Galooli gule Xtios rexpejṉ Israel retoxtadgoldoonu. Luxh che guläjzreni nacióṉ Egipto, bidalduxh retoxtadgoldoonu. Gucnäjduxh Diosreni bejnni remilagwr, te guḻäänireni guedx Egipto. ");
INSERT INTO zawNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Tiuu ijz guläjzreni lo reyubijdz. Xhidajl huält direni nusoob xtidx Dios, niluxh empac gucnäjza Diosreni. ");
INSERT INTO zawNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Guyu' gajtz nacióṉ guläjz neṉ reyuj ni laa Canaán. Dios bejn gunitloj reguejdxre, te gudisni reyujga loj retoxtadgoldoonu. ");
INSERT INTO zawNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Dxejcti badeed Dios reniguii ni gujc juejz, gunibeereni rebejṉ. Tajp gayugarol ijz gunibeereni rexpejṉ Israel. Samuel nani gunii xtidx Dios gujc lult juejz. ");
INSERT INTO zawNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Dxejcti gunab rexpejṉ Israel te ṟeii lo Dios te guinibee ṟeiiga lojreni. Badeedti Dios Saúl xi'n Cis, sa' toBenjamín. Gunibeeni tiuu ijz. ");
INSERT INTO zawNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Che badzucaj Dios Saúl, badeedni gunibee toṟeii David. Räjp Dios: “Agucbeä David xi'n Isaí rujn tejsi xhigab con narä. Susoobni xtidxä sujnni guiralii ni rlazä gac.” ");
INSERT INTO zawNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Räjpza Pabl: ―Galooli bia'n diidx lo rexagdoo David guxhaḻ Dios te bejṉ ni gudzucaj xtojḻnu, ni gusḻaa nuure lo dojḻ. N̲aj aguzojb diidxga. Jesucrist najc bejṉga, rudzucajni xtojḻnu, rusḻaani nuure lo dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Che gusloj cagulijdx Juan rebejṉ, baluiini nanabpac gusiechlajz rexpejṉ Israel, tiobnisreni te jia xtojḻreni. ");
INSERT INTO zawNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Niluxh guxii riäädx guluux Juan dzuun ni badeed Dios gunni che räjpni lo rebejṉ: “¿Chu rujntu xhigab nacä narä? Dina gacä Crist nani bia'n diidx guxhaḻ Dios. Coḻhuii, detzä siääd tej ni sacduxhru loä; nicla gac surloä te cuää́ xcura'chni.” ");
INSERT INTO zawNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Räjpza Pabl: ―Rniä lojtu sa'ä, rexagdoo toAbram, näjza lo chutis ni rajṉ Dios, loonu baxhaḻ Dios xtiidxni ni rusule' xho rudzucaj Jesucrist xtojḻnu, xho rusḻaani nuunu lo dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Rebejṉ Jerusalén, näjza renani rnibeereni, direni niembee Jesucrist nani rnibee, dizareni niacbee diidx xcuent Dios nani bacuaa reniguii ni gunii xtidx Dios agujc xchero, luxh ṟoḻreni xtidx Diosga gasob sabd. Niluxh che bagu'treni Jesucrist, guzojb xtidx Dios ni caj lo guijtzga. ");
INSERT INTO zawNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Balijdxreni Pila't ju'tni Jesucrist, luxh xhet bejndini te guetni. ");
INSERT INTO zawNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Che bagujc guiraa ni caj lo guijtz xcuent Jesucrist, gulätreni Jesucrist lo crujz, bacua'tzrenini neṉ baa cuä' te guilaj. ");
INSERT INTO zawNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Dxejcti guläs Dios Jesucrist lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Balti huält baluiloj Jesucrist lo rexamigwni nani biädnajlni nez rexyuj Galilee, renani biädnajlzani nez guedx Jerusalén. Bahuilojreni gubaṉsac Jesucrist lo rebeṉgut, te ṉaj rusule'reni diidx xcuent Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’N̲aj siopnänu xtidx Diosre lojtu te guibalajztu. Agujc xchero bia'n Dios diidxre con retoxtadgoldoonu. ");
INSERT INTO zawNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Guläs Dios Jesucrist te huile' diidxga par nuure, rexagdooreni. Agujc xchero gunii Dios te diidx ni caj neṉ Salmo ni bacuaa toDavid. Lo Salmo ni rojp räjp Dios: “Luj najclu xi'nä. Nadxej guleälu te guinibeelu.” ");
INSERT INTO zawNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Räjpza Pabl: ―Dxejcru stee lajt caj xcuent ni guläs Diosni lo rebeṉgut te nuncru guetni. Scree bacuaa te niguii, räjp Dios: “Sunidxä recossa'c lojlu si'c ni bia'nä diidx con toDavid.” ");
INSERT INTO zawNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ni'cni bacuaaza toDavid neṉ stee Salmo ni gunii Dios, guniini: “Dipaclu gusaan gudx tiejxh Xi'nlu nani sanälajzlu.” ");
INSERT INTO zawNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Che gulujx gunibee toDavid lo retoxtadgoldoonu, si'cni badeed Dios gunni, dxejc gujtni. Biga'tznäjni retoxtadgoldooni. Niluxh guyujdx tiejxh toDavid. ");
INSERT INTO zawNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Niluxh guläs Dios Jesucrist lo rebeṉgut, ni'c di tiejxhni niujdx. ");
INSERT INTO zawNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ni'cni coḻyacbee, la'tu resa'ä, Jesucristre, bejṉ ni caniä xcuentni, laani rudzucajni rextojḻnu. ");
INSERT INTO zawNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Chutis ni rililajz xtidx Jesucrist rusḻaa Jesucristni loj guiraa rextojḻni nani digacdi guibicaj mascä rusoobni guiralii ni caj lo leii xten toMoisés. ");
INSERT INTO zawNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Coḻsusiṉ te na'c sajctu recos ni caj lo guijtz ni bacuaa te niguii nani bacuaa xtidx Dios: ");
INSERT INTO zawNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Coḻhuilaa, la'tu ni ruxhiznäj xtidxä coḻguidxeloj, coḻnitloj, sa'csi ṉaj ni nabajṉtu sunä te dzunro, te milagwr nez lojtu, niluxh dipac lajztu chalii, mascä jiääd chu gusule'pacni lojtu. ");
INSERT INTO zawNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Gulujxti xtidx Pabl, biunejz rebejṉ. Che birinäj Pabl Bernabé biädnii rebejṉre lojreni, räjpreni: ―Jiädsactu ste xmaan te gusule'rutu rediidxre loonu. ");
INSERT INTO zawNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Che care'ch rebejṉga, xhidajl rexpejṉ Israel, näjza xhidajl rebeṉzijt nani rusoob xtidx Dios si'c rujn rexpejṉ Israel, birinajlreni Pabl näjza Bernabé. Dxejc balijdxreni rebejṉ ni siädnajlreni, räjpreni lojreni chanuutis chalilajzreni didxlii xcuent Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Che gojlti stee sabd, dxej ni rusilajz rexpejṉ Israel, xhidalduxh rebeṉguejdx bire' te gucuadiajgreni guinii Pabl xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Che bahuii rexpejṉ Israel guiraa rebejṉ ni bire', bidxechlajzreni, gucnadareni. Dxejc gusloj cadxagdijḻ rexpejṉ Israel Pabl. Che rniini te diidx, laareni rniireni “didxxhiini”. Caniyajzareni Pabl näjza Bernabé, caguereni lojreni. ");
INSERT INTO zawNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Luxh di Pabl niclaza Bernabé nidxejb. Gusutijptisreni, räjpreni lo rebejṉ: ―Nungäjḻ ganid lojtu guiniinu xtidx Dios, sa'csi la'tu najctu rexpejṉ Israel. Niluxh ditu chalilajz xtidx Dios, lagajc la'tu caniitu digacdi guibaṉnäjtu Dios par tejpas. Ni'c sibiré loonu, te guiniinu xtidx Dios lo rebeṉzijt ni digac xpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Sa'csi si'c agunibee Xtiosnu. Scree caj xtidx Dios lo guijtz: Suxhaḻätu te guluiilu rextidxä lo rebeṉzijt ni digac xpejṉ Israel, te chalilajz rebejṉga xtidxä, te ḻaareni lo xtojḻreni, cadrotis yu'reni lo guedxliuj, räjp Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Che biejn diajg rebeṉzijt rediidxre, bibalazduxhreni, gulä'preni xpala'n xtidx Dios. Renani gule Dios galooli huililajz xtidx Dios. Xhidajl najcreni. ");
INSERT INTO zawNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Bire'ch xtidx Dios guideb nez reguejdxga. ");
INSERT INTO zawNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Dxejc rexpejṉ Israel balijdx regunaa ni sajcru, näjza reniguii ni sajcru neṉ guedx Antioquía, te bidxechnäjreni Pabl näjza Bernabé, barilaagwreni Pabl näjza Bernabé te biunejzreni guedx Antioquía. ");
INSERT INTO zawNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Dxejcti Pabl näjza Bernabé gubijb guxhuj ni'reni si'c te seen te gacbee rebejṉ xhet laadi bejnreni. Sä'tireni guedx Iconio. ");
INSERT INTO zawNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Baspaa Dios lajz rexpejṉ Jesucrist guedx Antioquía xten Pisidia. Bazutijpza Sprit Dxan xten Dios lastooreni. ");
INSERT INTO zawNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Che bidzujṉ Pabl näjza Bernabé guedx Iconio, biu'reni xquidoo rexpejṉ Israel. Basule'reni xtidx Dios lo rexpejṉ Israel näjza lo rebeṉzijt. Xhidajl rebejṉga huililajz xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Niluxh sgaii rexpejṉ Israel nani di chalilajz xtidx Jesucrist balijdx rebeṉzijt te bidxechnäjreni rebejṉ nani huililajz xtidx Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ni'cni bia'n Pabl näjza Bernabé lo guejdxga balti dxej. Gusutzu'tz guiro'preni guniireni xtidx Jesucrist. Badeed Dios bejnreni redzunro, remilagwr xcuent xcäḻrnibee Dios te bahuii bejṉ cayacnäj Diosreni. ");
INSERT INTO zawNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Guyu' tiop cuaa bejṉ neṉ guejdxga. Gala' guejdxga huililajz xtidx Dios nani gunii Pabl näjza Bernabé, ");
INSERT INTO zawNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","dxejc sgala' guejdxga bacuadiajg xtidx rexpejṉ Israel. Dxejc bire' te cuaa rexpejṉ Israel, näjza beṉzijt, näjza reguxhtis, rlajzreni nidxagdijḻreni reapost, rlajzzareni nucuaareni guij yejc Pabl näjza Bernabé. ");
INSERT INTO zawNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Dxejc gucbeereni xhi rlajzreni gunreni, ni'c baxuṉreni ro'c huijreni nez reguedx Licaonia, ro'c bidzujṉreni guedx Listra, guedx Derbe, näjza reguejdx ni ṟe' nejzga. ");
INSERT INTO zawNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Che bidzujṉreni ro'c, cadrotis huijreni basule'reni xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Guedx Listra guyu' te niguii ni digacdi sa, che gojllini racxhuu ni'ni. ");
INSERT INTO zawNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Cagucuadiajg niguiiga xtidx Pabl. Che bahuii Pabl lojni, gucbee Pabl rililajz niguiiga xtidx Dios, rililajzzani sajc gusiajc Diosni. ");
INSERT INTO zawNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Dxejcti dip gunii Pabl lojni, räjpni: ―¡Huisulii! Dxejcti huisuyäḻni, gusajni. ");
INSERT INTO zawNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Che bahuii rexpejṉ Licaonia xhi bejn Pabl, lagajc xtiidxreni guniireni, räjpreni lo sa'reni: ―¡Redios abiädluiloj loonu si'c niguii! ");
INSERT INTO zawNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Gulälajreni Bernabé Júpiter, si'c laa tej rextiosreni. Dxejcti Pabl gulälajreni Mercurio, si'c laa stee rextiosreni, sa'csi laani rniiruni lo guiro'preni. ");
INSERT INTO zawNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Dxejcti te bixhojz xten xquidoo Júpiter cua' tiop gon najl guii guejnreni. Biädnäni regonga ro' xquidoo Júpiter ni suga' ro' guejdxga. Rebejṉ näjza bixhojz rlajzreni nugu'treni regon te gaṉreni Bernabé näjza Pabl si'c rajṉreni rextiosreni. ");
INSERT INTO zawNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Che biejn diajg reapost xhi cayajc, batiäjsreni tla' xhajbreni si'c te seen direni guichaglajz xhi cayujn rebejṉga. Ruxuṉreni bidzujṉreni lo rebejṉ, räjpreni lo rebejṉ: ");
INSERT INTO zawNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―Coḻcuadiajg xtiidxnu. ¿Xhicuent cayujn guejbtu recosre? Ni lagajc sabejṉtu najcnu, lagajc beṉ guedxliuj najcnu. Rusule'nu xtidx Dios lojtu te lacuaa ruzuxhijbtu lo redios ni runchee bejṉ, guzuxhijbtu lo Gueb Dios ni nabajṉ par tejpas, ni benchee xhaguibaa näjza guedxliuj, näjza nisdoo, näjza guiralii ni yu' lojreni, neṉreni, ");
INSERT INTO zawNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Galoo basaan Diosga gun rebeṉ guedxliuj si'ctis ni rlajzreni. ");
INSERT INTO zawNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Huen najc Dios, rudeedni nisguij, rudeedni rajc xhi rajw rebejṉ, rdxaj xque'reni, rbaa lajzreni. Ni'cni riembeepacnu yu' Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Xhidajl diidx guniireni te chäii bejnreni gaan guredxi rebejṉ, sa'csi rlajzpac rebejṉ nugu'treni regon. ");
INSERT INTO zawNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Dxejcti bidzujṉ gaii xpejṉ Israel siäädreni guedx Antioquía näjza guedx Iconio. Baquiilreni rebeṉ Listra te gucuaareni guij yejc Pabl. Bacuaareni guij yejc Pabl, gudobxhajxhrenini guläärenini ro' guejdxga, sa'csi naareni agujtni. ");
INSERT INTO zawNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Dxejc laḻ ni suga' rexpejṉ Jesucrist guideb gabi cadro naga' Pabl, huistieni, biusacni guejdxga. Che bara yääl, huinäni Bernabé sääreni guedx Derbe. ");
INSERT INTO zawNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Che bidzujṉreni guejdxga, basule'reni rextidx Dios lo rebejṉga. Xhidajlreni huililajz xtidx Dios. Dxejc gubi'reni, biu'reni guedx Listra, näjza guedx Iconio, näjza guedx Antioquía. ");
INSERT INTO zawNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Balijdxreni rebejṉ nani huililajz xtidx Dios, gucnäjreni rebejṉga te batiplajz rebejṉga, räjpreni lo rexpejṉ Jesucrist: ―Coḻsnaj lajztu xtidx Dios. Susacsí rebejṉ la'tu, sidejdtu trabajw te jiu'tu cadro rnibee Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Dxejcti gule reapost gaii dade' ni najc beṉgool te fiireni rexquidoo xpejṉ Jesucrist. Che gulujx bacua'nreni, laḻ ni guredx-gunabreni lo Dios, basadiidxreni rebejṉ, räjpreni: “Gacnäj Jesucrist la'tu ni huililajz xtiidxni.” ");
INSERT INTO zawNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Che gudejd Pabl näjza Bernabé distrit Pisidia, bidzujṉreni estad Panfilia. ");
INSERT INTO zawNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Basule'reni xtidx Dios lo rebeṉ Perge, dxejcti biriireni ro'c sääreni guedx Atalia. ");
INSERT INTO zawNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Che bidzujṉreni guejdxga, biu'reni neṉ barcw, gudejdreni lo nisdoo te bidzujṉreni stee guejdx ni laaza Antioquía. Ni'c najc guejdx ni biriireni che sääreni. Lo guejdxre yu' rexpejṉ Jesucrist ni gunab lo Dios xcuentreni, gacnäj Diosreni, baxhaḻreni Pabl näjza Bernabé chasule'reni xtidx Dios neṉ guiraa reguejdx. N̲aj abaluux Pabl näjza Bernabé dzuunga. ");
INSERT INTO zawNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Che bidzujṉreni guejdxga, bachagsa' rexpejṉ Jesucrist. Dxejcti bijreni diidx lo rebejṉga guira'ti ni bennäj Dios laareni, näjza xho badeed Dios huililajz rebeṉzijt nani digac rexpeṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Xchej biannäjreni rexpejṉ Jesucrist ro'c. ");
INSERT INTO zawNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Neṉ redxejga bidzujṉ gaii dade' ni siääd nez Judea, caguluiireni rexpejṉ Jesucrist, räjpreni lojreni: ―Palga ditu gusäḻ bee si'c gunibee toMoisés, di Dios gusḻaatu lo xtojḻtu. ");
INSERT INTO zawNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Che biejn diajg Pabl näjza Bernabé rediidxga, bidxagdijḻreni redade'ga. Dxejc gule rexpejṉ Jesucrist Pabl näjza Bernabé näjza sgaii rexpejṉ Jesucrist chääreni guedx Jerusalén te guininäjreni reapost näjza rebeṉgool te guidon xho gac xcuent beega. ");
INSERT INTO zawNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Huisunejz rexpejṉ Jesucrist ni najc beṉ Antioquía Pabl näjza rebejṉ ni sanäjreni, sääreni guedx Jerusalén. Gudejdreni reguedx Fenicia, näjza reguedx Samaria. Cadrotis gudejdreni bijreni diidx lo rexpejṉ Jesucrist ahuililajz rebeṉzijt xtidx Dios. Bibalazduxh rexpejṉ Jesucrist che biejn diajgreni rediidxga. ");
INSERT INTO zawNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Che bidzujṉreni guedx Jerusalén, huichagloj rexpejṉ Jesucristreni. Dxejcti bij Pabl näjza Bernabé diidx lo reapost, lo rebeṉgool nani rnibee rexpejṉ Jesucrist, näjza lo rexpejṉ Jesucrist, guiraa redzunro nani cayunnäj Diosreni. ");
INSERT INTO zawNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Dxejc huisulii gaii refarisee ni ahuililajz xtidx Dios, räjpreni lojreni: ―Che chalilajz rebeṉzijt xtidx Dios, nanab chureni bee, nanabza gusoobreni leii xten toMoisés. ");
INSERT INTO zawNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Dxejcti bachagsa' reapost näjza rebeṉgool nani rnibee rexpejṉ Jesucrist, te don xho gunreni. ");
INSERT INTO zawNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Huisulii Pedr, räjpni lojreni: ―Guejbtu, resa'ä, anajntu xho bejn Dios gubalti ijz. Gule Dios narä lo guiraanu te gusule'ä xtidx Dios loj rebeṉzijt, te chalilajzreni xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Luxh Dios, nani numbechee lastoo guiralii bejṉ, badeed seen huililajzpac rebeṉzijt xtiidxni. Badeed Dios Sprit Dxan xtenni lojreni si'c te seen te gacbee bejṉ najcreni xpejṉni. Sigac baniidxni Sprit Dxan xtenni loonu galoo, si'cza badeednini lo rebeṉzijt. ");
INSERT INTO zawNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Sigajc rinälajz Dios nuunu, sigajcza rinälajzni rebeṉzijt. Che huililajz rebeṉzijt xtiidxni, basia Dios lastooreni. ");
INSERT INTO zawNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","N̲aj ¿xhicuent rusieedtu Dios, ä? Di niajcdi nisianäj retoxtadnu releiiga, digacdiza chosanäjnu releiiga ṉaj. ¿Xhicuent rlajztu chasanäj rebeṉzijt releiiga? ");
INSERT INTO zawNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Xhet si'cti gacni sa'csi Dios rusḻaa nuure lo xtojḻnu che rililajznu xtidx Jesucrist, luxh si'cza rusḻaani rebeṉzijt lo dojḻ che rililajzreni xtidx Jesucrist ―räjp Pedr. ");
INSERT INTO zawNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Che gulujx gunii Pedr, dxitis gurej rebejṉ, bacuadiajgreni xtidx Bernabé, xtidx Pabl. Guiro'preni bijreni diidx xho cayujn Dios redzunro, remilagwr nez lo rebeṉzijt. ");
INSERT INTO zawNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Che gulujx gunii guiro'preni, xhet guniidi rebejṉ. Jacoobtis räjp lojreni: ―Sa'ä, coḻcuadiajg xtidxä. ");
INSERT INTO zawNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Agunii Simón ni rniireni Pedr lojtu xho ganiddoo baxhaḻ Dios laani lo rebeṉzijt te gurejdx Dios rexpejṉni ni nadxaag lo rebeṉzijt. ");
INSERT INTO zawNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Luxh si'cza caj lo guijtz. Agujc xcheroduxh bacuaa reniguii nani gunii xtidx Dios, che räjpni: ");
INSERT INTO zawNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Sidzujṉ dxej ni guibisacä. Sunä guzuxhijb guiraa rebejṉ nez loä si'c bazuxhijb rexpejṉ Israel che gubajṉ toDavid. Si'c gunä, ");
INSERT INTO zawNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","te jiädgajṉ rebejṉ narä te gacä Xtiosreni, näjza guiraa rebeṉzijt nani najc rexpeṉä jiädgajṉ narä, ");
INSERT INTO zawNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","si'c räjp Dios nani galooli baluiloj guiraa redzuunre. ");
INSERT INTO zawNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Dxejcti räjp Jacoob lojreni: ―Dee najc xhigab ni runä. Na'cru gusieednu rebeṉzijt ni cagusiechlajzreni, renani salilajz xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Gucuaanu te guijtz, jie'tznu lo rebeṉzijt: Na'c gaureni xhi cos ni basuj bejṉ loj rebanäjb, sa'csi dinu chalilajz xcuent rebanäjb. Na'cza guesnäjreni bejṉ ni di gac chäälni, na'cza gaureni bääl nani gurerejn, na'cza gaureni rejn. ");
INSERT INTO zawNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Dee gucuaanu te di guche'chreni xpejṉ Israel sa'csi neṉ guiraa reguejdx galooli yu' rexpejṉ Israel nani roḻ leii xten toMoisés gasob sabd ―räjp Jacoob. ");
INSERT INTO zawNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Che biejn diajg reapost näjza rebeṉgool nani rnibee, näjza guiraa rexpejṉ Jesucrist xtidx Jacoob, bichaglajzreni xtiidxni. Dxejcti gulereni tiop sa'reni chanä Pabl näjza Bernabé guedx Antioquía. Gulereni Judas ni rniireni Barsabás näjza Silas. Guiro'preni najc bejṉ ni sajcru loj rexpejṉ Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Dxejcti bejnreni guijtz huinäreni. Bacuaareni rediidxre: “Nuure reapost, näjza rebeṉgool ni rnibee, näjza rexpejṉ xquidoo Jesucrist ruxhaḻnu xtixtios lojtu, resa'nu nani rbäjz guedx Antioquía näjza estad Siria näjza estad Cilicia. ");
INSERT INTO zawNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Rucuaanu guijtzre sa'csi biejn diaagnu birii gaii resa'nu ree biädsieedreni la'tu con xtiidxreni, cayu'tu yärsia' sa'csi najreni lojtu nanab chutu bee si'c gunibee toMoisés, guibajṉzatu si'c rnii leii xten toMoisés. Xhet nuudinu gunibeenu jiädniireni si'c. ");
INSERT INTO zawNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ni'cni biennu xhigab guxhaḻnu lojtu tiop dade' ni gulenu loj resa'nu te chanäreni Bernabé näjza Pabl, nani sanälaaznu. ");
INSERT INTO zawNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Agajc balti huält rlajzreni nugu'treni Bernabé näjza Pabl, luxh direni guidxejb gusule'reni xtidx Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","N̲aj ruxhaḻnu Judas näjza Silas lojtu. Laareni susule'za guiraa rediidxre lojtu. ");
INSERT INTO zawNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Tejsi najc xhigabnu con Sprit Dxan xten Dios. Di rlaaznu gutaalrunu leii ni chasanäjtu. Releiitis nani nanab rusoobnu rucuaanu lojtu. ");
INSERT INTO zawNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Na'c gautu xhicos ni basuj bejṉ lo rebanäjb, sa'csi dirunu chalilaaz xcuent rebanäjb. Na'cru gautu rejn, na'cza gautu bääl nani gurerejn, na'cza guesnäjtu nani digac chäältu. Palga gusoobtu recosre, laaca cayujntu. Sacrú guibajṉtu. Sujiannäjtu Dios.” ");
INSERT INTO zawNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Dxejcti basadiidx rexpejṉ Jesucrist Judas näjza Silas huinäreni Pabl näjza Bernabé guedx Antioquía. Che bidzujṉreni ro'c batojpreni guiraa rebejṉ nani huililajz xtidx Dios te biḻreni guijtzga lojreni. ");
INSERT INTO zawNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Che biejn diajg rexpeṉzit Jesucrist diidx ni caj lo guijtzga, bibalazduxhreni sa'csi gulecdxi diidxga lastooreni. ");
INSERT INTO zawNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Dxejcti basule' Judas näjza Silas xtidx Dios lojreni, sa'csi rudeed Dios xtiidxni loj guiro'preni. Xhidajl diidx guniireni te balijdxreni rexpejṉ Jesucrist. Lacti gulecdxi rediidx ni guniireni lastoo guiraa rexpejṉ Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ro'c bia'nreni xchej, dxejcru cuäjb rexpejṉ Jesucrist gubi'reni te gudeedreni xtixtios loj reni baxhaḻreni. ");
INSERT INTO zawNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Dxejc Silas bejn xhigab jia'nni ro'c. ");
INSERT INTO zawNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Luxh Pabl näjza Bernabé bia'n guedx Antioquía. Guiro'preni baluii, basule'reni xtidx Dios loj rebejṉ. Guyu'za sgaii dade' ni gucnäjreni. ");
INSERT INTO zawNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Che gudejd xhidajl dxej, räjp Pabl lo Bernabé: ―Do'o guibi' lo guiraa reguejdx cadro basule'nu rextidx Dios te chohuiinu don xho yu' rexpejṉ Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Niluxh Bernabé rlajz chanäreni Juan ni laa Marcw. ");
INSERT INTO zawNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Naaddi Pabl chääni, sa'csi birii Marcw lojreni che guyu'reni nez Panfilia, diruni nisianäj Pabl näjza Bernabé. ");
INSERT INTO zawNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Dxejc gudiḻdiidxreni. Gubicajtireni lo sa'reni. Ni'c sanä Bernabé Marcw, biu'reni neṉ barcw, sääreni Chipre ni ṟe' galäii nisdoo. ");
INSERT INTO zawNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Dxejcti Pabl gule Silas te sanänini. Badeed rexpejṉ Jesucrist xtixtios lojreni, räjpreni gacnäj Diosreni. ");
INSERT INTO zawNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Laḻ ni sasajreni gudejdreni guiraa reguedx Siria näjza guiraa reguedx Cilicia, ro'c gucnäjreni guiraa rexpejṉ Jesucrist, basule'rureni xtidx Jesucrist lojreni. ");
INSERT INTO zawNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bidzuṉsac Pabl näjza Silas reguedx Derbe näjza Listra. Ro'c bidxaagreni te xpeṉ Jesucrist ni laa Timoteu. Xnanni najc beṉ Israel ni huililajz xtidx Jesucrist. Xtadni najc beṉ griegw. ");
INSERT INTO zawNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Didxsa'ctis rnii rexpeṉ Jesucrist ni yu' Listra näjza Iconio xcuent Timoteu. ");
INSERT INTO zawNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Rlajz Pabl chanäni Timoteu. Dxejcti basäḻ Pabl bee Timoteu te gujcni si'c xpeṉ Israel, te xhet naadi rexpejṉ Israel, sa'csi guiraareni nanchee xtad Timoteu najc beṉ griegw. ");
INSERT INTO zawNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Che bidzujṉreni cade tej reguejdx, basule'reni xtidx reapost näjza rebeṉgool nani rnibee xpeṉ Jesucrist guedx Jeurusalén, te gusoob rexpejṉ Jesucrist diidx ni bacuaareni lo guijtz. ");
INSERT INTO zawNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Bazutijp xtidx Dios lastoo renani huililajz xtidx Jesucrist. Guixe-guixee xhidajlru bejṉ huililajz xtidx Dios xcuent Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Che gudejdreni distrit Frigia, näjza estad Galacia, di Sprit Dxan xten Dios nusaan nusule'reni xtidx Jesucrist neṉ reguedx Asia. ");
INSERT INTO zawNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Bidzujṉtireni gajxh estad Misia. Dxejc rlajzreni nijreni estad Bitinia, niluxh di Sprit Dxan xten Dios nusaan nijreni ro'c. ");
INSERT INTO zawNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ni'c gudejdtireni stelaad estad Misia, bidzujṉreni guedx Troas. ");
INSERT INTO zawNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Te yääl si'c lo te bacaḻ bahuii Pabl suga' te beṉ Macedonia. Canabduxh niguiiga lo Pabl, räjpni: ―Gudaa ladxä, estad Macedonia, te gacnäjlu nuunu. ");
INSERT INTO zawNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Che bara yääl ni gunixcaḻ Pabl, gudilgajcnu te barcw te chonnu estad Macedonia, sa'csi gucbeenu Dios najc nani caguxhaḻ nuure te guluiini xtiidxni lo rebeṉ Macedonia. Narä, Lucas, ni cagucuaä rediidxre, gusanää Pabl näjza Silas. ");
INSERT INTO zawNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Biu'tinu neṉ barcw ro' guedx Troas. Bidzuṉnu Samotracia, te yuj ni ṟe' neṉ nisdoo. Che bara yääl bidzuṉnu guedx Neápolis. Ro'c biriinu neṉ barcw, ");
INSERT INTO zawNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","bionnu guedx Filipos, guejdx nani sajcru lo estad Macedonia. Guedx romanni. Ro'c bia'nnu tiop choṉ dxej. ");
INSERT INTO zawNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Che gojl sabd, dxej ni rusilajz rexpejṉ Israel, biriinu guejdxga bionnu ro' te gueuu, sa'csi biennu xhigab ro'c jiääd rexpejṉ Israel te guininäjreni Dios. Ro'c gurejnu, guniinu lo renane' nani bire' ro'c. ");
INSERT INTO zawNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Lojreni nadxaag te nane' ni laa Lidia, te beṉzijt ni digac xpejṉ Israel. Guedx Tiatira siäädni. Ruto'ni ladmuraad ni sacduxh. Rajṉ gunaaga Dios si'c rajṉ rexpejṉ Israelni. Bacuadiajgni xtidx Jesucrist ni cagusule' Pabl. Gucnäj Dios nane'ga te huililajzni xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Birobnisni, näjza guiraa reni rbäjz rolijzni. Dxejc guniini loonu: ―Palga ruhuiitu guliä rililazä xtidx Dios, coḻtaa rolizä te ro'c cuääztu. Lacti gunab nane'ga nuunu, ni'c huijia'nnu rolijzni. ");
INSERT INTO zawNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Te dxej cheni sionnu cadro rninäj bejṉ Dios, bidxaagnu te dxa'p nani yu' te beṉdxab neṉ lastooni. Rajp rexpaxhuaanni melduxh sa'csi rusule' dxa'pga recos ni gajd gac. ");
INSERT INTO zawNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Birinajl dxa'pga Pabl näjza nuure. Rbedxa' dxape'ga, räjpni: ―Reniguiire najc xmos Dios nani rnibee guideb guedxliuj. Ruluiireni loonu xho ḻaanu lo xtojḻnu ―räjp dxape're. ");
INSERT INTO zawNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Balti dxej birinajl dxape'ga nuure, entis caniini rediidxga lo rebejṉ. Lacti basieed dxape'ga Pabl, ni'c gubiréni, räjpni lo beṉdxab ni yu' neṉ lastoo dxape'ga: ―Xcuent xcäḻrnibee Jesucrist rniä lojlu: “Birii neṉ lastoo dxape'ga.” Lagajc dxejc birii beṉdxab neṉ lastoo dxape'ga. ");
INSERT INTO zawNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Che bahuii rexpaxhuaan dxape'ga diru dxape'ga gun gaan melro, gunaazreni Pabl näjza Silas. Dxejcti gudobxhajxhreni guiro'preni nez roguii cadro suga' reguxhtis. ");
INSERT INTO zawNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Che bidzuṉnäjreni Pabl näjza Silas lo reguxhtis, räjp rexpaxhuaanni lo reguxhtis: ―Reniguiire najc xpejṉ Israel. Cayujnreni biejy lo guejdxre. ");
INSERT INTO zawNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Caguluiireni garenca leii nani digacdi gusoobnu sa'csi najcnu beṉ roman. ");
INSERT INTO zawNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Dxejcti bidxechnäj rebejṉ Pabl näjza Silas. Gunibee rejuejz gulääreni xhajb Pabl, näjza xhajb Silas, te batiäjḻreni baar guideb tiejxh guiro'preni. ");
INSERT INTO zawNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Che gulujx gudinduxhreni Pabl näjza Silas, biäureni neṉ latzguiib. Dxejcti räjp reguxhtis lo reguixhajg: ―Coḻgapdzu'tzreni, di gusaantu guiriireni. ");
INSERT INTO zawNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Basäḻ guixhajgreni neṉ latzguiib. Guyu' ni'reni neṉ te baräjd ni sojb gueed te di guxuṉreni. ");
INSERT INTO zawNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Garolyääl guninäj Pabl näjza Silas Dios, gusloj cayoḻreni dij ni rliä'p xpala'n Dios. Biejn diajg guiraa rebejṉ ni yu' neṉ latzguiib cayoḻreni. ");
INSERT INTO zawNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Chela gujc te xuduxh, basniib guideb latzguiibga. Bixal guiraa repuert, birucya' guiraa recadeṉ, bixal ro' rebaräjd cadro naaz ni'reni. ");
INSERT INTO zawNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Che gubajṉ guixhajg ni canäj latzguiib, bahuiini naxhal latzguiib, gulääni spaad xtenni, te rlajzni nugu'tni lagajc laani, sa'csi naani abadxuṉ reni niäu neṉ latzguiib. ");
INSERT INTO zawNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Dxejc guredxa' Pabl, räjpni lo guixhajgga: ―Na'c gunlu si'c. Bahuii, guiraliinu suga'nu ree. ");
INSERT INTO zawNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Dxejc gunibee guixhajg biääd te bajl te biu'ni neṉ latzguiib. Racsejsni biäädni bazuxhijbni nez loj Pabl näjza nez loj Silas. ");
INSERT INTO zawNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Dxejcti gulää guixhajgreni neṉ latzguiib. Gunabdiidxni räjpni lojreni: ―¡Coḻguinii, dade'! ¿Xhini'c nanab gunä te gusḻaa Dios narä lo dojḻ? ");
INSERT INTO zawNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Räjp Pabl näjza Silas lo guixhajg: ―Huililajztis xtidx Dios xcuent Jesucrist, luj näjza guiraa reni yu' rolijzlu, te gusḻaa Diostu lo dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Basule' Pabl näjza Silas rextidx Dios lojni näjza loj guiraa rebejṉ ni yu' rolijzni. ");
INSERT INTO zawNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Lagajc dxejc, garol yääl, huinä guixhajgreni gudiibni dejtzreni cadro batiuug baarreni. Dxejcti batiobnisreni guixhajg näjza guiraa reni yu' rolijzni. ");
INSERT INTO zawNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Dxejc huinä guixhajgreni rolijzni, ro'c badeedni xhi gudajwreni. Laani näjza guiraa reni yu' rolijzni bibalazduxhreni sa'csi huililajzreni xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Che bara yääl, baxhaḻ reguxhtis stiop guixhajg räjpni lo guixhajg nani cuanäj latzguiib: ―Basḻaa reniguiiga. ");
INSERT INTO zawNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Dxejcti huiye'tz guixhajgga lo Pabl, räjpni: ―Anaj reguxhtis gusḻaä́tu. N̲aj coḻchäj, gacnäj Dios la'tu, saru chäätu. ");
INSERT INTO zawNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Niluxh räjp Pabl loj reguixhajg: ―Nuure najczanu beṉ roman. Batiäjḻreni baar detznu nez loj guiraa rebejṉ. Nicla niniabdiidxreni la yu' xhi dojḻ biennu. Basäureni nuure neṉ latzguiib. Leii xten roman di gusaan gac rebeṉ roman si'c. Luxh ṉaj rlajzreni gusḻaareni nuure xhiga'tz. ¡Dinu guirii si'c! Lagajc laareni sujiädsḻääreni nuunu. ");
INSERT INTO zawNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Che huiye'tz reguixhajg diidxga lo reguxhtis, bidxebduxhreni che biejn diajgreni beṉ roman najc Pabl näjza Silas. ");
INSERT INTO zawNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Dxejcti biääd reguxhtis, gulääreni Pabl näjza Silas, gunabreni jiäjḻlajzreni. Gunabduxhreni lo Pabl näjza Silas; räjpreni: ―Coḻjiunejz guejdxre. ");
INSERT INTO zawNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Che biriireni neṉ latzguiib, huijreni rolijz Lidia. Balijdxreni rexpejṉ Jesucrist, gulecdxireni lajz rexpejṉ Jesucrist. Dxejc biunejzreni guejdxga. ");
INSERT INTO zawNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Che gudejdreni reguedx Anfípolis, näjza guedx Apolonia, bidzujṉreni guedx Tesalónica cadro yu' te xquidoo rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ro'c basule' Pabl xtidx Dios si'c ni rujnpacni. Choṉ sabd, dxej ni rusilajz rexpejṉ Israel, basule'ni xtidx Dios lojreni. ");
INSERT INTO zawNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Basule' Pabl xtidx Dios ni caj lo guijtz ni bacuaa reniguii ni gunii xtidx Dios galooli. Caj lo guijtzga: “Nanab ted Crist trabajwduxh, guetni, niluxh sibaṉsacni lo rebeṉgut.” Dxejc räjp Pabl lojreni: ―Ruiä lojtu diidx xcuent Jesús; lagajc Jesúsre najc Crist ―räjpni. ");
INSERT INTO zawNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Yu' rexpejṉ Israel huililajz xtidx Dios, gusanäjreni Pabl näjza Silas. Näjza xhidalduxh beṉ griegw nani rajṉ Dios näjza xhidajl reguna griegw ni sajcru huililajz xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Luxh yu' rexpejṉ Israel ni di chalilajz, ni bidxechlajz. Batie'reni gaii beṉploj, beṉlatsiaj, bejnreni biejy nez galäii. Biu'reni rolijz Jasón caguiilreni Pabl näjza Silas te cuääreni guiro'preni nez lo rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Niluxh che direni nidxäl Pabl näjza Silas, alga Jasón gulääreni näjza gaii renani rililajz xtidx Dios, sanääreni redee lo reguxhtis, cabedxa'reni: ―Reniguiire ni abejn bieiduxh guideb guedxliuj abidzujṉreni laadxnu, ");
INSERT INTO zawNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","luxh badeed Jasón rolijzni jia'nreni. Direni gusoob leii xten César, najreni yu' stee ṟeii ni laa Jesús. ");
INSERT INTO zawNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Che biejn diajg reguxhtis näjza rebejṉ diidxre, guyu'reni yärsia'. ");
INSERT INTO zawNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Cua' reguxhtis meel lo Jasón näjza lo rexamigwni. Räjp reguxhtis sudedsacreni meelga che jii Pabl näjza Silas, jiunejzreni lo guejdxga. Dxejcti basḻaareni Jasón näjza rexamigwni. ");
INSERT INTO zawNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Che biu' guxhijṉ, baxhaḻgajc rexpejṉ Jesucrist Pabl näjza Silas ste guejdx ni laa Berea. Che bidzujṉreni guejdxga, biugajcreni xquidoo rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Hueenru najc rebeṉ Berea loj rebeṉ Tesalónica, sa'csi rbaali lajzreni bacuadiajgreni xtidx Pabl ni guniini xcuent Jesucrist. Guixe-guixee biḻreni guijtz cadro caj xtidx Dios te gucbeereni la gulii rextidx Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Xhidajl rexpejṉ Israel näjza xhidajl beṉ griegw ni sajcru, gunaa sigajc niguii, huililajz xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Che gucbee rexpejṉ Israel ni rbäjz guedx Tesalónica caguluii Pabl xtidx Dios guedx Berea, biäädreni guedx Berea. Che bidzujṉreni lo guejdxga bejnreni biejy ro'c. ");
INSERT INTO zawNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Dxejcti baxhaḻ rexpejṉ Jesucrist Pabl, huijni ro' nisdoo. Niluxh Silas näjza Timoteu bia'n guedx Berea. ");
INSERT INTO zawNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Dxejcti rebejṉ ni guzanäj Pabl huinänini guedx Atenas. Ro'c räjp Pabl lo rebejṉ ni biädnäni gudeedreni diidx lo Silas näjza Timoteu jiädgajcreni lojni. Dxejcti rebejṉ ni sanä Pabl gubisac guedx Berea. ");
INSERT INTO zawNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Laḻ ni guläjz Pabl guedx Atenas, guyuduxhni yärsia' sa'csi bahuiini rajṉ guiraa rebejṉ rebanäjb nani runchee lagajc bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ni'c neṉ xquidooreni gudiḻdiidx Pabl rexpejṉ Israel näjza rebeṉzijt ni rajṉ Dios si'c rajṉ rexpejṉ Israelni. Guixe-guixee gudiḻdiidxni chutis bejṉ ni ṟe' lo guii. ");
INSERT INTO zawNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Dxejcti biääd gaii bejṉ lojni. Yu' reni roḻduxh guijtz ni bacuaa epicúreos, yu'za renani roḻduxh guijtz ni bacuaa estoicos, gudiḻdiidxreni Pabl. Yu' reni räjp lo sa'reni: ―¿Xhicha guinii bejṉre loonu? Entis naxhal ro'ni. Yu'zareni räjp lo sa'reni: ―Pet calä'pni xpala'n tiop dioscoob. Si'c guniireni sa'csi biejn diajgreni bazä't Pabl “Jesús” näjza “Resureccion”, ni säloj yäḻgubaṉsac lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Dxejcti gunaazreni Pabl sanärenini nez dajn ni laa Areópago. Ro'c yu' si'c te jusgaad. Räjpreni lo Pabl: ―Rlaaznu gacbeenu xhi diidx ruluiilu, ");
INSERT INTO zawNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","sa'csi rujylu diidx nani dinu jiacbee. Ni'cni bejn huen, basule' diidxre loonu te gacbeenu xhi sälojreni ―räjpreni. ");
INSERT INTO zawNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Rebeṉ Atenas näjza rebeṉzijt ni yu' ro'c ruteedreni redxej rniireni didxcoob lo sa'reni, o rucuadiajgreni didxcoob. Ni'cpac rchaglajzreni. ");
INSERT INTO zawNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Galäii Areópago huisulii Pabl, räjpni lojreni: ―Coḻcuadiajg guejbtu, beṉ Atenas. Abahuiä xho raṉduxhtu xhidajl banäjb. ");
INSERT INTO zawNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Che siädsaä́ lo guejdxre, bahuiä lo rexpanäjbtu. Bahuiäza loj te piään cadro caj rediidxre: “Dios ni dinu jiembee.” Narä raṉä Diosga. Rumbeä Diosga nani rajṉtu mase ditu gumbeeni. Susule'ä xtiidxni lojtu. ");
INSERT INTO zawNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Räjp Pabl: ―Diosre benchee guedxliuj näjza guiralii ni yu' lo guedxliuj, sa'csi rnibeeni xhaguibaa näjza guedxliuj. Di Diosre cuääz lo piään niclaza neṉ reguidoo ni runchee bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Diza Diosre guiquiin chu gacnäjni sa'csi lagajc Diosre rudeed yäḻnabajṉ, yäḻnadaan, näjza guiralii nani rquiin rebeṉ guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Räjp Pabl: ―Guiralii rebeṉ guedxliuj najc rexagdoo tejsi gunaa näjza tejsi niguii. Desde galooli gunibee Diosga bal ijz chu renacioṉ, näjza cati gunibee renacioṉga. ");
INSERT INTO zawNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Benchee Dios guiraa rebeṉ guedxliuj te quiilreni Dios te chalilajzreni xtiidxni. Luxh suga' Dios gajxh cadetejnu, ");
INSERT INTO zawNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","sa'csi Dios rujn nabajṉnu lo guedxliuj, runiidxni rsiaanu lo guedxliuj, runiidxzani rdajlru xcäḻnabaṉnu lo guedxliuj. Laaca bacuaa rexpeṉnajntu: “Najcnu xi'n Dios, sa'csi benchee Diosnu.” ");
INSERT INTO zawNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ni'cni, sa'csi najcnu xi'n Dios, di nungäjḻ jiennu xhigab najc Dios si'c rebanäjb ni nac-chee pla't, o guij, o yajg si'ctis ni runchee bejṉ rexpanäjbtu. ");
INSERT INTO zawNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Neṉ redxej ni di bejṉ niembee Dios, diza Dios niujn castiigwreni. Niluxh ṉaj gunibee Dios gusiechlajz guiraa rebejṉ, ");
INSERT INTO zawNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","sa'csi abasoobni te dxej cheni gac Jesús juejz lo guiraa rebeṉ guedxliuj. Agule Diosni gacni juejz, sa'csi rumbechee Jesucrist chu najc beṉguijdx, chuza najc beṉsa'c. Rnilii Jesucrist rediidx ni najc guliitis. Guläs Dios Jesucrist, baspaṉsacnini lo rebeṉgut, te gacbeenu rajp Jesucrist yäḻrnibee lo guiraa recos. ");
INSERT INTO zawNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Che biejn diajg rebejṉga gubaṉsac Jesucrist lo rebeṉgut yu' reni baxhiznäj xtiidxni. Yu'za reni räjp: ―Sucuadiajgrunu xcuent ni rusule'lu. ");
INSERT INTO zawNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Dxejcti birii Pabl lojreni. ");
INSERT INTO zawNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Yu'za reni huinajlni, huililajzreni xtidx Dios. Lojreni nadxaag te dade' ni laa Dionisio ni najc te juejz lo Areópago; näjza te nane' ni laa Dámaris. Guyu'za sgaii bejṉ ni huililajz. ");
INSERT INTO zawNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Biriiti Pabl guedx Atenas, huijni guedx Corinto. ");
INSERT INTO zawNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ro'c bidxaagni te dade' ni najc beṉ Israel, ni laani Aquila. Ponto najc lajdxni. Biädgajni ro'c, biriini Roma, sa'csi gunibee ṟeii Claudio guirii guiraa rexpejṉ Israel guedx Roma. Birinäj Aquila Priscila chäälni. Biriireni Italia, biäädreni guedx Corinto. Bihuii Pablreni, ");
INSERT INTO zawNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","sa'csi lagajc dzuun ni rujnreni rujnzani. Tejsi lajt guläjzreni te bejn jioṉreni tejsi dzuun. Runcheereni yuguijd. ");
INSERT INTO zawNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Gasob sabd, dxej ni rusilajz rexpejṉ Israel, basule' Pabl xtidx Dios neṉ xquidoo rexpejṉ Israel. Rlajzni chalilajz rexpejṉ Israel näjza beṉ griegw ni digac xpejṉ Israel diidx ni rniini xcuent Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Dxejcti birii Silas näjza Timoteu Macedonia. Che bidzujṉreni guedx Corinto, gusloj rusule'tis Pabl xtidx Dios guixe-guixee, guniliini lo rexpejṉ Israel: ―Jesús najc Crist ni runloj rexpejṉtu guxhaḻ Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Dxejc bidxechnäj rexpejṉ Israelni, guniyajzareni xtiidxni. Dxejcti gubijb Pabl xhajbni si'c te seen diruni jiureni, caguṟo'nnireni. Räjpzani lo rexpejṉ Israel: ―Lagajc la'tu rajptu dojḻ nittu lo Dios. Xhet dojḻdi rapä narä. Aguniä xtidx Jesucrist lojtu. N̲aj lo rebejṉ nani di gac beṉ Israel gusule'ä xtidx Jesucrist ―räjpni. ");
INSERT INTO zawNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Dxejcti biriini lojreni, huijni rolijz Justo, te bejṉ ni rajṉ Dios si'c rajṉ rexpejṉ Israelni. Rolijzni sojb cuä' xquidoo rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Crisp, ni rnibee xquidoo Israel, huililajz xtidx Jesucrist. Huililajzza guiraa reni rbäjz rolijzni. Xhidajlza beṉ Corinto huililajz xtidx Jesucrist, dxejcti birobnisreni. ");
INSERT INTO zawNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Gojḻ te yääl gunii Dios lo te bacaḻ, räjpni lo Pabl: ―Na'c guidxejblu. Guniitis, na'c gusäulu ro'lu, ");
INSERT INTO zawNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","sa'csi narä suganää́ luj. Rut gacdi gun latsiajlu. Aguleä xhidalduxh bejṉ lo guejdxre te gacreni xpeṉä ―räjp Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ni'c bia'n Pabl ro'c tebizgarol. Baluiini xtidx Dios lojreni. ");
INSERT INTO zawNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Che gujc Galíon gubernadoor xten Acaya, tejsi xhigab bejn rexpejṉ Israel bidojpreni te gunaazreni Pabl. Sanäreni Pabl jusgaad cadro yu' Galíon. ");
INSERT INTO zawNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Räjpreni lo Galíon: ―Niguiire caguluii rebejṉ gaṉreni Dios garenca mood, xhet si'cti ni caj lo xleiinu ―räjpreni. ");
INSERT INTO zawNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Agojl ninii Pabl, che räjp Galíon lo rexpejṉ Israel: ―Palga gulanni o bagu'tni te bejṉ, dxejc yu' xtojḻni te gucuadiagä xtiidxtu. ");
INSERT INTO zawNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Per la'tu cadxe'chtu xcuent diidx, xcuent laj bejṉ, xcuent ni caj lo leii xtentu. Gubernadoor narä, xho gucuadiagä diidxga. Lagajc la'tu coḻchahuii xho guntu yälguxhtis ―räjp Galíon. ");
INSERT INTO zawNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Gunibee Galíon barilaagw resoldaad rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Dxejc gunaaz reGriegw Sóstenes nani rnibee xquidoo rexpejṉ Israel. Batiäjḻreni baar dejtz Sóstenes nez ro' jusgaad xten Galíon. Niluxh nicla niu Galíonreni. ");
INSERT INTO zawNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Bia'nti Pabl Corinto xchej. Dxejc badeed Pabl xtixtios lo rebejṉ nani huililaz xtidx Jesucrist, biriini ro'c. Sanäni Priscila näjza Aquila, biu'reni neṉ barcw te siireni nez estad Siria. Dxejc ganid gudejdreni guedx Cencrea, cadro bahuaj Pabl yejcni si'c te seen yu' xhi diidx bia'nni con Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Che bidzujṉreni guedx Éfeso, basa'n Pabl Priscila näjza Aquila ro'c. Biu' Pabl xquidoo rexpejṉ Israel, ro'c bachaagni diidx con rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Dxejcti che gunabreni jia'n Pabl ro'c xchej, naaddini jia'nni. ");
INSERT INTO zawNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Badeedni xtixtios, räjpni lojreni: ―Nungäjḻpac chatedä laniro guedx Jerusalén. Siälsacä ree palga gusaan Dios jiälä. Biusacni neṉ barcw, biriini guedx Éfeso. ");
INSERT INTO zawNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Che bidzujṉni guedx Cesarea, biriini neṉ barcw, huijni guedx Jerusalén. Che bidzujṉni, guniini xchan lo reapost näjza lo rexpejṉ Jesucrist. Dxejc huijni guedx Antioquía xten Siria. ");
INSERT INTO zawNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Che gudejd balti dxej, biriini guejdxga, gudejdni guideb estad Galacia näjza guideb distrit Frigia. Neṉ cade tej reguejdxga, balijdxni rexpejṉ Jesucrist te gutijpru lajzreni. ");
INSERT INTO zawNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Neṉ redxejga, te dade' ni laa Apolos bidzujṉ guedx Éfeso. Najcni xpejṉ Israel, gojlni guedx Alejandría xten Egipto. Lacti rajc rnisa'cni, nanduxhzani xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Nanduxhni xtidx Dios xcuent Jesucrist. Laaca basule'ni xtidx Dios, guideb xcäḻnabajṉni rinälajzni Dios. Niluxh xcuent Jesucrist najntisni yäḻrobnis xten Juan. ");
INSERT INTO zawNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Nicla nidxejb Apolos gusloj caniini neṉ guidoo xten rexpejṉ Israel. Che biejn diajg Priscila näjza Aquila xtiidxni, huinärenini rolijzreni. Ro'c basule'rureni xtidx Dios nani gajdni gan. ");
INSERT INTO zawNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Dxejc, sa'csi abejn Apolos xhigab chääni reguejdx ni tre' nez Acaya, bacuaa rexpejṉ Jesucrist guijtz lo rexpejṉ Jesucrist ni yu' neṉ reguejdxga te gacnäjreni Apolos. Gucnäduxh Apolos rebejṉ nani badeed Dios huililajz xtidx Dios neṉ reguejdxga, ");
INSERT INTO zawNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","sa'csi gunilii Apolos nez loj guiraa rebejṉ xhet laadi rnii rexpejṉ Israel. Di niajcdi nuzejc rexpejṉ Israel diidx lo Apolos sa'csi ganax con xtidx Dios ni bacuaa reniguii ni gunii xtidx Dios galoo basule'ni: “Jesús najc Crist nani cayunlojtu guxhaḻ Dios.” ");
INSERT INTO zawNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Laḻ ni guyu' Apolos guedx Corinto, huij Pabl xhidajl reguejdx neṉ región Asia, dxejcti bidzujṉni guedx Éfeso cadro bidxaagni gaii bejṉ nani huililajz xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Gunabdiidx Pabl lojreni: ―Che huililajztu xtidx Dios, ¿la biädlajz Sprit Dxan xten Dios neṉ lastootu, ä? Räjpreni lojni: ―Nicla gajd diajgnu jiejn la yu' te Sprit Dxan xten Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Räjp Pabl lojreni: ―¿Xho birobnistu, pues? Räjpreni lojni: ―Birobnisnu si'cni baluii Juan tiobnis bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Dxejcti räjp Pabl lojreni: ―Guliica bastiobnis Juan che basiejch lajz rebejṉ xtojḻreni. Räjpza Juan lo rebejṉ: “Coḻchalilajz xtidx bejṉ ni siääd detzä.” Bejṉ ni basä'tni najc Jesucrist ―räjp Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Che biejn diajgreni rextidx Pabl birobnisreni te gacbee rebejṉ najcreni xpejṉ Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Che batzuub Pabl ṉaani yejcreni, biu' Sprit Dxan xten Dios neṉ lastooreni. Dxejc gusloj caniireni garen-garen didxsaj. Guslojza caniireni diidx ni badeed Dios lojreni. ");
INSERT INTO zawNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Si'c tzubitio'p dade' gusajc si'c. ");
INSERT INTO zawNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Si'c choṉ bäii, guixe-guixee gunii Pabl rextidx Dios, basule'ni xcuent xcäḻrnibee Dios loj rebejṉ neṉ xquidoo rexpejṉ Israel. Dini nidxejb guniini loj rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Dxejc guyu' reni gucnajd, dirureni nililajz xtidx Dios. Che gusloj caniyajreni xtidx Dios lo rebejṉ, biunejz Pabl ro'c sanäni rexpejṉni ni rililajz xtidx Jesucrist. Sanä Pablreni te bidxagsa'reni ro scueel xten mastr Tiranno. Ro'c bidxagsa'reni te guixe-guixee basule' Pabl xtidx Dios lojreni. ");
INSERT INTO zawNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Tiop ijz bejn Pabl si'c, ni'c guiraa rebejṉ ni rbäjz Asia biejn diajgreni xtidx Dios. Rexpejṉ Israel sigajc rebeṉ griegw biejn diajgreni xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Gucnäj Dios Pabl bejnni xhidajl dzunro, remilagwr. ");
INSERT INTO zawNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ni'cni biääd bejṉ ca'reni baii, ca'reni tla' lajd te guxheebreni relajdga lo Pabl. Dxejcti rinäreni relajdga lo rebejṉ ni racxhuu, luxh riacgajc rebejṉ ni racxhuuga, ṟigajcza rebeṉdxab lastoo renani yu' beṉdxab. ");
INSERT INTO zawNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Dxejcti guyu' gaii beṉ Israel nani entis rcansaj, direni cuääz tejsi guejdx. Najcreni bejṉ ni rbää beṉdxab lastoo rebejṉ. Bejn redee xhigabcoob, naareni cuääreni beṉdxab xcuent laj Jesucrist, ni'cni räjpreni lo renani yu' beṉdxab neṉ lastooni: ―Xcuent xcäḻrnibee Jesucrist nani ruluii Pabl rnibeenu guiriilu neṉ lastoo bejṉga ―räjpreni. ");
INSERT INTO zawNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Guyu' gajdz xi'n Esceva, te beṉ Israel, nani sajcru lo rebixhojz. Rujn redee dzuun rbääreni rebeṉdxab neṉ lastoo rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Che gunii rexi'n Esceva loj beṉdxabga si'c, räjp beṉdxab ni yu' neṉ lastoo bejṉga lojreni: ―Rumbeä Jesucrist, rumbeäza Pabl. ¿La'tu, chu la'tu? Dina gumbeä la'tu. ");
INSERT INTO zawNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Dxejcti bixa't niguii nani yu' beṉdxab neṉ lastooni yejc rexi'n Esceva, gudinduxhnireni, basäḻta'nireni, batiäjsni xhajbreni. Dxejcti baxuṉreni biriireni neṉ yu'ga, bidxälguijdxzareni biräsya' xhajbreni. ");
INSERT INTO zawNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Dxejcti guiraa rebeṉ Éfeso, rexpejṉ Israel sigajc beṉ griegw, gucbee xho bennäj beṉdxab reniguiiga. Bidxebduxh rebejṉga, luxh huä'p xpala'n Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Xhidalduxh reni huililajz xtidx Dios biääd lo rexpejṉ Jesucrist. Cacäjpreni guiraa recos xhet laadi nani rujnreni. ");
INSERT INTO zawNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Xhidajl reni najc bidxaa biädnä reguijtz cadro caj yäḻnajn xten rebidxaa. Dxejcti base'creni reguijtzga nez loj guiraa rebejṉ. Bejnreni cuent lacti meel sajc reguijtzga. Sajcreni tiubitzuu miḻ melpla't. ");
INSERT INTO zawNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Xhidalduxh rebejṉ huililajz xtidx Dios. Batijp Dios lastoo rexpejṉni. Gulä'p guiraareni xpala'n Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Che gulujx recosre, bejn Pabl xhigab chääni guedx Jerusalén, niluxh tedxgaani reguejdx ni ṟe' nez Macedonia näjza Acaya, bejnzani xhigab, naani: ―Che ahua'a Jerusalén, nanabza cha'a guedx Roma. ");
INSERT INTO zawNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ni'cni baxhaḻ Pabl Timoteu näjza Erasto, tio'p renani racnäjni, huijreni Macedonia, luxh laani bia'nni Asia. ");
INSERT INTO zawNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Neṉ redxejga, guyuduxh rebejṉ yärsia' sa'csi baluii Pabl xtidx Dios. Direni nichaglajz care'ch xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Te dade' ni laa Demetrio runchee ni'ch pla't xten banäjb ni laa Diana, ni najc banäjb xten guejdxga. Demetrio näjza guiraa replateer ni rujn ni'ch xten Diana runduxhreni gaan meel ro'c. ");
INSERT INTO zawNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Gurejdx Demetrio guiraa replateer ni rujn reni'chga, räjpni lojreni: ―Coḻcuadiajg, la'tu resa'ä: najntu rbäänu melro lo dzuun ni riennu. ");
INSERT INTO zawNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Abahuiitu niguiire ni laa Pabl. Abiejnza diajgtu xtiidxni. Räjpni lo rebejṉ: “Xhet diosdi najc reni racchee con ṉaa bejṉ.” Guedx Éfeso näjza guideb nacióṉ Asia cagusiejchni lajz bejṉ, xhidalduxh bejṉ salilajz xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ni'c ries nitloj xtzuunnu palga diru bejṉ sii ni'ch ni riencheenu. Luxh riesza diru bejṉ jiädgajṉ Diana neṉ xquidoro Diana. N̲aj rebeṉ Asia, näjza guiraa rebeṉ guedxliuj raṉduxh Diana, banäjb ni sajcru, niluxh palga diru rebejṉ gaṉ Diana, pet sinitlojni ―räjpni. ");
INSERT INTO zawNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Che biejn diajg replateer xtiidxni, bidxe'chduxhreni, guredxa'reni räjpreni: ―Sacduxh Diana xtios rebeṉ Éfeso. ");
INSERT INTO zawNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Guideb guejdx guyu' biejy. Dxejcti ruxuṉreni bidxagsa'reni lo yuj cadro rajc rexjuntreni. Gunaazreni Gayo näjza Aristarco, beṉ Macedonia ni rinajl Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Rlajz Pabl niu'ni cadro bidxagsa' rebejṉ, niluxh di rexpejṉ Jesucrist nusaanni. ");
INSERT INTO zawNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Gaii guxhtis ni rnibee Asia, sa'csi najcreni xamijgw Pabl, baxhaḻreni diidx lo Pabl, räjpreni: ―Na'c chäälu cadro nadxagsa' rebejṉga ―räjpreni. ");
INSERT INTO zawNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Lo rebejṉ ni ṟe'ga, yu' reni rbedxa' tej diidx, sgaiireni rbedxa' garenca diidx. Te bieiduxh cayajc. Xhidalduxh rebejṉga nicla gan xhicuent bidxagsa'reni. ");
INSERT INTO zawNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Dxejcti gulää rexpejṉ Israel te dade' ni laa Alejandro lo rebeṉ xhidaalga, te guiniini lo rebejṉ. Dxejcti basääbni ṉaani lo rebejṉ te gac dxi rebejṉ. Rlajz Alejandro guiniini xcuent rexpejṉ Israel loj guiraa rebejṉ, te di guidxe'chreni lo rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Niluxh che gucbee rebejṉ najc Alejandro beṉ Israel, tiop oṟ guredxaduxhreni, räjpreni: ―Sacduxh Diana xtios rebeṉ Éfeso. ");
INSERT INTO zawNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Dxejcti biääd secretaar xten guejdxga lo rebejṉ, gunibeeni guc dxi rebejṉ, te räjpni lojreni: ―Coḻcuadiajg, la'tu beṉ Éfeso, caguidxäjḻ te beṉ guedxliuj ni di gacbee rebeṉ guedx Éfeso rajṉpac Diana, nani xhaguibaali bitejb lo guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Sa'csi rediidxre najc gulii, nungäjḻ cuedxitu, na'c guntu recos guijdxre. ");
INSERT INTO zawNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","¿Xhicuent gunaaztu reniguii ni siädnätu ree? Direni gac gubaan ni rbajn recos guidoo, dizareni niniyaj xtiosnu. ");
INSERT INTO zawNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","N̲aj palga rlajz Demetrio näjza rebejṉ ni najc plateer chale'c quej, naxhal jusgaad, suga' reguxhtis. Ro'c suchale'creni xquejreni. ");
INSERT INTO zawNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Niluxh palga yu' xhi stee, nanab gac te junt xte rebeṉguejdx si'c ni caj lo xleiinu. ");
INSERT INTO zawNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ries jii xquejnu lo gubier, naareni bidojpnu te guidxagdiḻnu gubier. ¿Dxejca'? ¿Xhi jie'tznu xcuent ni bidxagsa'nu ree? Dxejcti räjpni: ―Agojl, coḻjiunejz. ");
INSERT INTO zawNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Che gunii secretaar si'c, bire'ch rebejṉ, biunejzreni ro'c. ");
INSERT INTO zawNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Che bire'ch rebejṉ, gurejdx Pabl rexpejṉ Jesucrist biääd lojni, te balijdxnireni. Badeedni xtixtios lojreni. Sä'tini nez reguedx Macedonia. ");
INSERT INTO zawNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Guiraa reguejdxga cadro gudejdni, balijdxni rexpejṉ Jesucrist, basule'runi xtidx Dios lojreni. Dxejc sääni reguedx Grecia. ");
INSERT INTO zawNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Che bidzujṉni Grecia, bia'nni ro'c choṉ bäii. Dxejcti niu' Pabl neṉ barcw te nijni reguejdx Siria. Niluxh che biejn diajgni cabäz-xhiga'tz rexpejṉ Israelni te guiniaazrenini, gunaazni nezyuj, gubi'ni nez Macedonia. ");
INSERT INTO zawNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Huinäni Sópater, xi'n Pirios, te beṉ guedx Berea; näj Aristarco näjza Secondo, beṉ guedx Tesalónica; näj Gayo, beṉ guedx Derbe; näj Timoteu; näj Tíquico näjza Trófimo, beṉ Asia. ");
INSERT INTO zawNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Guiraa redee gunijd loonu, huiläjzreni nuure guedx Troas. ");
INSERT INTO zawNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Guedx Filipos bidxaag Pabl narä, Lucas. Ro'c gudejdnu lanij xten rexpejṉ Israel che rajwreni yätxtiil ni di saguij. Biriitinu guejdxga, biu'nu neṉ barcw te sonnu nez guedx Troas. Gaii dxej gusaanu neṉ barcw, dxejc bidzuṉnu guedx Troas. Ro'c bia'nnu gajdz dxej. ");
INSERT INTO zawNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Che gojl dumingw, primer dxej xman, bidxagsa'nu te bidaunu yätxtiil si'c gudaunäj Jesucrist rexpejṉpacni galoo che gajdni guet. Abejn Pabl xhigab guira yääl guiriini guejdxga. Che biu' guxhijṉ, gusloj cagusuleduxh Pabl xtidx Dios, huinuuni si'cti garolyäälli. ");
INSERT INTO zawNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Yu' cadro bidxagsa'nu najc jiaa yejc stiop yu'. Xhidalduxh balgandeel cagusanij ro'c. ");
INSERT INTO zawNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Sobga' te bi'n ni laa Eutico ro' te bentaan. Laḻ ni cagusuleduxh Pabl xtidx Dios lo rebejṉ, gunaaz bacaḻ bi'nga, gudiejsni, bitejbni lo yuj desde yu' ni riojṉ pis. Che huiläsrenini, agujtni. ");
INSERT INTO zawNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Dxejcti biäjt Pabl lo yuj cadro bitejb bi'nga. Bazuxhijb Pabl cadro naga' bi'nga, gudääznini. Dxejcti räjp Pabl lojreni: ―Na'c chutu yärsia'. Agubaṉsacni. Baspajṉ Diosni. ");
INSERT INTO zawNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Dxejcti huäpsac Pabl lo yujiaaga. Ro'c bidaunu yätxtiil si'c gudaunäj Jesucrist rexpejṉpacni galoo che gajdni guet. Gunii Pabl lojreni xchejru, che bianijli lo guedxliuj. Dxejc biunejzni. ");
INSERT INTO zawNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Xhetliidiru rajcdi bi'nga nani gubaṉsac, nani guläs Pabl. Bibalazduxhreni, huisa'nrenini rolijzni. ");
INSERT INTO zawNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Gunijdnu lo Pabl. Biu'nu neṉ barcw, sonnu guedx Asón, te ro'c guidxaagnu Pabl, sa'csi abejn Pabl xhigab ni'ni jiini guejdxga, ro'cli jiu'ni neṉ barcw. ");
INSERT INTO zawNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Che bidxaag Pabl nuunu guedx Asón, biu'ni neṉ barcw, sonnu lo nisdoo te bidzuṉnu guedx Mitilene. ");
INSERT INTO zawNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Neṉ barcw biriinu ro'c. Che bara yääl, gudejdnu yuj ni ṟe' lo nisdoo ni laa Quío. Che bara stee yääl, bidzuṉnu guedx Samos. Guedx Trogilio basilaaznu. Che bara stee yääl, bidzuṉnu guedx Mileto. ");
INSERT INTO zawNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Di rlajz Pabl jiu'nu guedx Éfeso, diza rlajzni chunu Asía xchej, sa'csi riojb lajzni guidzuṉnu guedx Jerusalén te ro'c tedni redxe lanij ni laa Pentecostés. ");
INSERT INTO zawNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Che guyu'nu guedx Mileto, baxhaḻ Pabl diidx lo rexpejṉ Jesucrist ni yu' guedx Éfeso, gurejdxni reni rnibee. ");
INSERT INTO zawNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Che bidzujṉreni lo guejdxga, räjp Pabl lojreni: ―Lagajc la'tu najntu xho nabaṉä nez lojtu, dxejli ni bidzuṉä, nabaṉnää́ Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","La'tu najntu xho runä xtzuun Jesucrist guixe-guixee, guideb xcäḻnadipä. Dina niliä'p ä xpala'nä. Najntu xho ronä che di bejṉ chalilajz xtidx Jesucrist. Che rlajz rexpejṉ Israel nugu't narä, gudedä trabajwduxh. ");
INSERT INTO zawNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","La'tu najntu xho baluiä lojtu guiralii rextidx Dios ni najc huen par la'tu. Che nadxagsa'tu baluiä xtidx Dios lojtu, näjza rolijz cade tejtu huiluiä xtidx Dios lojtu. ");
INSERT INTO zawNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Basule'ä xtidx Dios lo rexpejṉ Israel näjza lo rebeṉzijt ni di gac xpejṉ Israel. Räpä lojreni nanab gusiechlajzreni, gusa'nreni xtojḻreni, nanab chalilajzreni xtidx Jesucrist te gudzucaj Dios xtojḻreni. ");
INSERT INTO zawNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","N̲aj cadedä te laad guejdx xtentu, sia'ä guedx Jerusalén, sa'csi caguxhaḻ Sprit Dxan xten Dios narä cha'ä guedx Jerusalén. Dina ganä xhi sacä ro'c. ");
INSERT INTO zawNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Niluxh nanä cade tej reguejdx cadro rdedä rnii Sprit Dxan xten Dios loä sidedä trabajwduxh, siäuä́ neṉ latzguiib guedx Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Niluxh dina guidxebä, dizana chanälazduxhä xcäḻnabaṉätis, te guluxä dzuun nani baniidx Jesucrist gunä. Lo dzuun ni baniidx Jesucrist nanab chaye'tzä lo guiraa rebejṉ sibicaj xtojḻreni palga chalilajzreni xtidx Dios xcuent Jesucrist ―räjp Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Räjpzani: ―N̲aj agucbeä dirutu fisac loä, la'tu nani basule'ä xcäḻrnibee Dios lojtu. ");
INSERT INTO zawNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Rniliä́pac lojtu, xhet dojḻdi rapä palga yu' te bejṉ ni di chalilajz xtidx Dios, ni di Dios gudzucaj xtojḻni. ");
INSERT INTO zawNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Xhetliidi biäädxdi loj rextidx Dios ni basule'ä lojtu. Dina nucua'tzä nicla tej xtiidxni xcuent xho rlajz Dios guibaṉnu. ");
INSERT INTO zawNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Coḻga'p lagajc la'tu si'c ra'p baxhtoor xiil, si'c coḻga'p guiraa rebejṉ nani rililajz xtidx Dios sa'csi Sprit Dxan xten Dios abaniidx dzuunga guntu, ni'cni abixe' xtiejn Jesucrist lo crujz te gac gudzucaj Dios xtojḻreni. ");
INSERT INTO zawNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Anancheä che rutdiru narä, siääd bejṉ nani rlajz chalilajztu ste'ca diidx, na'c chalilajztu niclaza jiutu rebejṉga. Rusgueetisreni la'tu. Sutie'chreni la'tu lo sa'tu si'c rutie'ch cuyo't rexiil. ");
INSERT INTO zawNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Su'za lagajc sa'tu ni guinii didx-xhii lojtu te gunreni gusaan rexpejṉ Jesucrist xtidx Dios, te chanajlreni redee ni rusguee. ");
INSERT INTO zawNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Coḻhuii te di gusgueereni la'tu. Di jiäḻ-lajztu choṉ ijz, dxej yääl basule'ä xtidx Dios, ronäli balidxätu, sa'csi sanälazätu. ");
INSERT INTO zawNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Räjpza Pabl: ―Asia'are, rusa'nätu ladzṉaa Dios, gacnäj Dios la'tu. Sutijp xtidx Dios lastootu, te xca'tu guiraa ni bia'n diidx guniidx Dios lojtu, näjza loj guiraa ni abejn Dios beṉsa'c, nani najc xpejṉni. ");
INSERT INTO zawNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Dina niniabä meel, niclaza xhabä che baluiä xtidx Jesucrist lojtu. ");
INSERT INTO zawNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Anajntu lagajc narä benä dzuun con ṉaä te bio' xhi gudaunää rexamigwä. ");
INSERT INTO zawNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Si'c benä te filojtu xho guntu dzuun te gacnäjtu sa'tu ni xhet rajpdi, te guinaj lajztu xtidx Jesucrist che najni: “Huenru guideednu lo bejṉ quela xcaxlia'nu xhi cos” ―räjpni. ");
INSERT INTO zawNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Che gulujx gunii Pabl rediidxga, bazuxhibnäjni rebejṉga, guredx-gunabni lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Dxejcti ronduxh guiraareni gudääzreni guejn Pabl, bachagro'renini. ");
INSERT INTO zawNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Guc-huinduxh lajzreni dxejc sa'csi räjp Pabl dirureni fisac lojni. Dxejcti huisa'nrenini lo barcw. ");
INSERT INTO zawNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Che basa'ntinu rexpejṉ Jesucrist ro'c, biu'nu neṉ barcw, sionnu te lii nejz lo yuj ni laa Cos, ni tre' lo nisdoo. Che bara yääl, bidzuṉnu lo xyuj Rodas ni tre'za lo nisdoo. Ro'c biriinu sionnu neṉ barcw nez guedx Pátara. ");
INSERT INTO zawNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Che bidzuṉnu ro' guejdxga, bidxälnu te barcw ni sää nez reguedx Fenicia. Dxejc biu'nu neṉ barcwga te chonnu ro'c. ");
INSERT INTO zawNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Bahuiinu lo yuj Chipre ni tre' lo nisdoo, xladbäjcwnu tre' yujga, bideednu te laad. Siontinu nez Siria, ro'c bidzuṉnu guedx Tiro cadro gule'creni cargw ni nuu barcwga. ");
INSERT INTO zawNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ro'c bidxälnu rexpejṉ Jesucrist. Biannänureni gajdz dxej. Baluii Sprit Dxan xten Diosreni te guniireni lo Pabl, räjpreni: ―Na'c chäälu guedx Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Che baza' gajdz dxej, biunejznu guejdxga. Dxejc guzaj reniguii, regunaa, näjza rexi'nreni biriinu guejdxga. Ro' nisdoo bazuxhijbnu te guredx-gunabnu lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Che abazadiidxnu sa'nu, nuure biu'nu neṉ barcw, biädla laareni gubisacreni rolijzreni. ");
INSERT INTO zawNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Biriitinu guedx Tiro. Che bidzuṉnu ro' guedx Tolemaida, gulujx xpiajnu biäjtnu neṉ barcw. Dxejc biohuiinu rexpejṉ Jesucrist ni yu' guejdxga, biannänureni tejtis yääl. ");
INSERT INTO zawNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Che bara yääl, biriinu guejdxga, sonnu guedx Cesarea. Che bidzuṉnu guejdxga, bionnu rolijz Felipe, te dade' ni rusule' xtidx Dios lo bejṉ. Felipe gujc tej lo gajdz niguii nani gudis xhi gudajw rexpeṉ Jesucrist nani xhet rajpdi guedx Jerusalén. Rolijzni huijia'nnu. ");
INSERT INTO zawNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Yu' tajp xindxapxteb Felipe. Dios badeed diidx guiniireni lo bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Xhidajḻ dxej guläjznu rolijz Felipe. Laḻ ni dxunnu ro'c, bidzujṉ te niguii ni laa Agabo, biriini nez Judea. Ruzanij Dios xcäriejnni te guiniini xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Che bidzujṉni loonu, cua' Agabo xsindoor Pabl, baliibni lagajc reni'ni näjza reṉaani, najni loonu: ―Anaj Sprit Dxan xten Dios: “Scree suliib rexpejṉ Israel ni yu' guedx Jerusalén niguii ni najc xtenni sindoorre te guteedrenini ladzṉaa rebeṉzijt.” ");
INSERT INTO zawNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Che biejn diaagnu rediidxga, nuure näjza rebeṉ ro'c, gunabduxhnu lo Pabl na'c chääni guedx Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Dxejc naj Pabl loonu: ―¿Xhicuent roontu? ¿Xhicuent runhuiintu lazä? Xhet najcdi jiäuä neṉ latzguiib, xhet najcdi palga nungäḻä guetä guedx Jerusalén xcuent Jesucrist ―räjp Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Che naaddi Pabl gusiechlajzni, xhetru guniidinu lojni. Räjptisnu lojni: ―Sugac nani rlajztis Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Che gudejd redxejga, bilucheenu rexhixtennu, biriinu guejdxga, sontinu guedx Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Gaii rexpejṉ Jesucrist ni najc beṉ Cesarea huisa'n nuure guedx Jerusalén. Ro'c huinäreni nuure rolijz te dade' ni laa Mnasón, beṉ Chipre, yuj ni tre' lo nisdoo. Laani galooli huililajzni xtidx Dios. Huijia'nnu rolijzni, ro'c gulääznu. ");
INSERT INTO zawNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Che bidzuṉnu guedx Jerusalén, bibalazduxh rexpejṉ Jesucrist sa'csi siopnu ro'c. ");
INSERT INTO zawNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Che bara yääl huinänu Pabl lo Jacoob näjza lo renani rnibee guidoo xten rexpejṉ Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Dxejc gudääz Pablreni, bijni diidx xcuent tebgaj redzuun nani badeed Dios bejnni che guyunäjni rebeṉzijt nani di gac xpejṉ Israel, te biejn diajgreni xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Che biejn diajgreni xtidx Pabl, gulä'preni xpala'n Dios, räjpzareni lo Pabl: ―Guejblu, sa'nu, anajnlu lacti xhidalduxh xpejṉ Israel yu' nani rililajz xtidx Jesucrist luxh rapdaduxhreni leii xten toMoisés. ");
INSERT INTO zawNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Abiejn diajg rebejṉre xcuentlu. Abiejn diajgreni garenca ruluiilu guiraa rexpejṉ Israel nani rbäjz neṉ reguejdx xten rebeṉzijt, rulijdxlureni na'c gusäḻreni bee rexi'nreni, na'cza chazanäjrureni rexcostumbrnu. ");
INSERT INTO zawNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Xhini'c jiennu? Siejn diajgreni abidzujṉlu ree, dxejc suchagsa'reni te jiäädreni lojlu. ");
INSERT INTO zawNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","N̲aj gunlu nani guiniinu lojlu. Yu' tajp resa'nu ree nani basa'nreni diidx lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Huinäreni, näjza luj bejn si'ctis gunreni si'c ni caj lo leii xten toMoisés, te gaclu naya nez lo Dios. Luj quiixlu guiraa ni banijtreni, te che abasa'tu guiraa ni nanab gac sajc guigaj yejctu si'c te seen te gacbee guiraa rebejṉ abasoobtu leii. Dxejcti gan guiraa rebejṉ didx-xhii najc rediidx ni biejn diajgreni xcuentlu. Te gacbeereni laaca rusooblu xleii toMoisés. ");
INSERT INTO zawNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Biädla rebeṉzijt nani huililajz xtidx Jesucrist, xhet najcdi, sa'csi abacuaanu lojreni, rie'tznu lojreni: na'c gautu recos nani gule'c bejṉ si'c gojṉ loj banäjb, na'c gautu rejn, niclaza bääl nani gurerejn, na'c guesnäjtu nani di gac chäältu. ");
INSERT INTO zawNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Che bara yääl, huinä Pabl guidap niguiiga, bejnreni si'c caj lo xleii toMoisés, biu'reni neṉ xquidoo rexpejṉ Israel te huiye'tzreni lo bixhojz neṉ guidoo xhi dxej jiädnä tejgareni te man te ju't rebixhojz remanga lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Si'c nanab gunreni gajdz dxej. Che ameer guiza' redxejga, bahuii rexpejṉ Israel ni siääd Asia lo Pabl neṉ guidoroga. Gunaazreni Pabl, dxejcti gusloj cayujnreni biejy, ");
INSERT INTO zawNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","guredxa'reni räjpreni: ―¡Coḻtaa xpejṉ Israel! ¡Coḻtaa te gacnäjtu nuure! ¡Bahuilaare! Niguiire najc nani rniyaj rexpejṉ Israel cadrotis rijni. Rulijdxni bejṉ te di chazanäjrureni xleii toMoisés, riye'tzni lo bejṉ xhet sajcdi xquidoronure. Coḻhuilaa xho siädnäni ree beṉ griegw, beṉzijt ni di gac xpejṉ Israel, te gundxuudxni xquidoronu ―räjpreni. ");
INSERT INTO zawNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Si'c caniireni sa'csi te huält bahuiireni sanä Pabl Trófimos lo nezyuj. Trófimos najc te beṉzijt ni siääd guedx Éfeso. N̲aj cayujnreni xhigab laa niguiiga ni siädnä Pabl neṉ xquidoro rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Guideb guejdxga guyu' yärsia', bire' beṉguixhuj, bixa'treni yejc Pabl, gunaazrenini, gudobxhajxhreni Pabl, gulägajcrenini neṉ guidoroga. Biäugajc repuertro xten guidoro. ");
INSERT INTO zawNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Laḻ ni cayujnreni xhigab ju'trenini, yu' chu huiye'tz lo nani rnibee resoldaad ni caya'p guejdxga, räjpreni: ―Cayajc te bieiduxh neṉ guejdxre. ");
INSERT INTO zawNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Guredxgajc comandant resoldaad näjza gaii capitán, ruxuṉreni bidzujṉreni cadro tre' rebejṉ. Che bahuii rebejṉ lo comandant näjza resoldaad, guläjz caguijṉreni Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Dxejcti gubig comandant lo Pabl, gunibeeni baliib resoldaad ṉaa Pabl con tiop cadeṉguiib. Dxejcti gunabdiidxni lo Pabl, räjpni: ―¿Chu luj? ¿Xhini'c bejnlu? ");
INSERT INTO zawNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Lo rebeṉ xhidaalga yu' rexpejṉ Israel ni guredxa' tej diidx, yu'za reni guredxa' ste'ca diidx. Di comandant niujn gan niacbeeni xhicuent cayajc biejy sa'csi cabedxa' guiraa rebejṉ. Dxejc gunibeeni chanä resoldaad Pabl cadro rbäjzreni. ");
INSERT INTO zawNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Che bidzuṉnäj resoldaad Pabl ro' scaleer ni caj ro'c, biireni Pabl te bejnreni gan biunäjreni Pabl, sa'csi nialazduxh rebejṉ rlajzreni nugu'treni Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Siädnajl guiraa rebejṉ Pabl, rbedxa'reni: ―Coḻgugu'tni. ");
INSERT INTO zawNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Che agojḻ jiu' Pabl neṉ yuro xten resoldaad, räjpni lo comandant con diidx griegw: ―Rlazä guiniä tiop diidx lo guejblu. Räjp comandant lo Pabl: ―¡An rniilu xtidxsaä! ");
INSERT INTO zawNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","An dilu gac niguii ni siääd nacióṉ Egipto, nani gudiḻnäj gubier, nani huinä lo reyubijdz tajp mil niguii nani rugu't bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Dxejc räjp Pabl lojni: ―Narä nacä te beṉ Israel, te beṉ Tarso xten Cilicia. Sacduxh guejdxga lo reguedx Cilicia. Canabä gun guejblu te hueen, gusaan guejblu guiniä lo rebejṉre. ");
INSERT INTO zawNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Dxejc cuäjb comandant guinii Pabl lo rebejṉ. Lal ni suga'ni lo scaleer basääb Pabl ṉaani lo rebejṉ te gucdxireni. Che aguredxi rebejṉ, gusloj Pabl canii lojreni didxsaj hebreo, räjpni: ");
INSERT INTO zawNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","―Guejbtu beṉgool, guejbtu resa'ä, näjza la'tu dade'. Gucuadiajgtu rextidxä ―räjpni. ");
INSERT INTO zawNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Che biejn diajgreni caniini didx hebreo, dxidujru guzuj rebejṉ. Räjp Pabl lojreni: ");
INSERT INTO zawNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","―Narä nacä te xpejṉ Israel. Guedx Tarso xten Cilicia goḻä. Reepac gulaä. Lo Gamaliel bisiedä guijtz. Baluisa'cni narä guiragajc releii xten retoxtadgoldoonu. Guideb xtipä basobä ni gunibee Dios. Gucä si'cpac ni najctu ṉaj. ");
INSERT INTO zawNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Dxejcti bidxechduxhä loj renani huililajz xtidx Jesucrist, bagu'täzareni. Balibä xhidajl bejṉ, niguii näjza gunaa, con cadeṉguiib. Basäuäreni neṉ latzguiib. ");
INSERT INTO zawNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Bixhojz ni sajcru näjza guiraa rebeṉgool ni sajcru neṉ xquidootu, sajc guinii xhini'c benä. Laareni baniidxreni guijtz loä. Ni'c huinää lo rexpejṉ Israel ni yu' guedx Damasco, cadro hua'a te niniazä rebejṉ nani huililajz xtidx Jesucrist. Benä xhigab jiädnää́reni guedx Jerusalén te jiäureni neṉ latzguiib, te gusacsíreni rebejṉga. ");
INSERT INTO zawNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Räjpzani: ―Dxejc hua'a guedx Damasco. Läidxejti ameer guidzuṉä guejdxga, chela bazanij te balro guideb gabi narä. Xhaguibaali siääd bajlga. ");
INSERT INTO zawNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Biabrloä lo yuj, dxejc biejn diagä te se' ni canii loä, najni: “Saulo, Saulo, ¿xhicuent rusacsílu narä näjza rexpeṉä?” najni. ");
INSERT INTO zawNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Dxejcti räpä lojni: “¿Chuluj, Dad?” Najni loä: “Narä nacä Jesucrist ni siääd Nasare't, nani cagusacsíduxhlu.” ");
INSERT INTO zawNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Rebejṉ ni sanää́ bahuiloj bajlga, bidxejbreni, niluxh di diajgreni niejn xse' nani gunii loä. ");
INSERT INTO zawNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Räpä lojni: “Dad, ¿xhini'c gunä?” Dxejcti najni loä: “Huistie, huij guedx Damasco. Ro'c sinii te dade' lojlu guiraa ni guinibeä gunlu.” ");
INSERT INTO zawNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Bastujxh bajlga loä, diru loä nieṉ, ni'cni gunaaz resa'ä ṉaä, sontinu guedx Damasco. ");
INSERT INTO zawNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Räjp Pabl: ―Guejdxga guläjz te niguii ni laa Ananías. Rusoobni guiraa releii xten toMoisés. Guiraa rexpejṉ Israel rnii nadalajz lo dade'ga. Biääd Ananías loä. ");
INSERT INTO zawNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Cuä'ä guzujni najni loä: “¡Saulo, betzä, bahuisac!” Lagajc dxejc biajc loä, bahuiä lojni. ");
INSERT INTO zawNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Naj Ananías loä: “Xtios retoxtadgoldoonu agulelu. Gule Dios luj te jiejn diajglu rediidx ni rlajzni gunlu, te filojlu Jesucrist, Xindxan Dios, te jiejnza diajglu rextiidxpac Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Loj guiraa bejṉ susule'lu guiraa ni bahuiilu näjza nani biejn diajglu. ");
INSERT INTO zawNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","¿Xhicuent sojbtislu ro'c? Basquejn, huistie te tiobnislu. Huililajz xtidx Jesucrist, gurejdx lo Dios te gudzucajni rextojḻlu.” ");
INSERT INTO zawNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","’Che gubi'ä guedx Jerusalén, biu'ä neṉ guidoro xten rexpejṉ Israel te guredx-gunabä lo Dios. Laḻ ni cabedx-canabä lo Dios, astoo gunixcaḻä, ");
INSERT INTO zawNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","dxejc bahuiä lo Jesucrist. Najni loä: “Basquejn, birii guedx Jerusalén sa'csi di rebejṉ chalilajz xtidxä ni gusule'lu lojreni.” ");
INSERT INTO zawNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Narä räpäza lojni: “Dad, anajnreni xho biu'ä guiraa reguidoo, gunazä guiraa rebejṉ nani huililajz xtiidxlu, gudinduxhäreni, basäuäreni neṉ latzguiib. ");
INSERT INTO zawNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Che bacuaareni guij yejc Esteban nani gunii xtiidxlu, ro'c guzuä, cuäbä bejnreni si'c. Go'pä xhajb xten renani bagu't Esteban laḻ ni bacuaareni guij.” ");
INSERT INTO zawNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Dxejcti naj Jesucrist loä: “Huij. Suxhaḻä luj zitduxh. Chäälu lo guiraa rebeṉzijt ni di gac xpejṉ Israel.” ");
INSERT INTO zawNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Bacuadiajg guiraa rebejṉ laḻ ni gunii Pabl rediidxga, dxejcti guredxa'reni, räjpreni: ―Coḻgu't niguiiga. Di nunyäjḻ guibajṉruni. ");
INSERT INTO zawNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Sanuutis cabedxa'reni. Gulääreni xcamangwreni, cacuaazareni yuyoḻ jiaa. ");
INSERT INTO zawNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Dxejcti gunibee comandant lo resoldaad, räjpni: ―Coḻchanä Pabl neṉ yuro xtennu. Ro'c coḻquiin Pabl te guiniini didxgulii, te gacbeenu xhicuent rbedxaduxh rebejṉ lojni. ");
INSERT INTO zawNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Sanätireni Pabl. Entis baliibreni ni', ṉaa Pabl con duguijd te niguijnrenini che gunabdiidx Pabl lo capitán, räjpni: ―¿La rajc rguijntu te beṉ roman che gajdtu gacbee xhi dojḻ bejnni, ä? Et si'cti caj lo xleiilu. ");
INSERT INTO zawNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Che biejn diajg capitán xtiidxni, bidxejbni, huijni lo comandant, räjpni lojni: ―Coḻnati xhi gunnäjlu dade're, sa'csi najcni beṉ roman. ");
INSERT INTO zawNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Biädguxuṉ comandant lo Pabl, räjpni: ―¿La gulii najclu beṉ roman, ä? Räjp Pabl lojni: ―Guliini. ");
INSERT INTO zawNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Dxejcti räjp comandant: ―Narä badedä xhiroob meel te nacä beṉ roman. Dxejcti räjp Pabl lojni: ―Narä che goḻäli nacä beṉ roman. ");
INSERT INTO zawNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Che biejn diajg resoldaad nani niguijn Pabl si'c, basḻagajcreni reduguijd ni naliib ni', ṉaani. Che biejnza diajg comandant najc Pabl beṉ roman, bidxejbni sa'csi gunibeeni biliib Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Che bara yääl, rlajz comandant gacbeeni xhicuent rlajz rexpejṉ Israel ju't Pabl. Ni'c gunibeeni jiääd rebixhojz ni sajcru näjza reguxhtis xten guidoro. Dxejcti biädnäni Pabl, bazujnini nez loj guiraa rebejṉ ni bire' ro'c. ");
INSERT INTO zawNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Rdxelodzu'tz Pabl lo rebejṉ ni tre' ro'c laḻ ni räjpni lojreni: ―Narä gusule'ä tiop diidx lo guejbtu, beṉ Israel, sa'ä. Guideb ni nabaṉä ruzobä xtidx Dios. Di lastoä guidxejb nez lo Dios ―räjp Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Che biejn diajg Ananías, bixhojz ni sajcru, xtidx Pabl, bidxechduxhni, gunibeeni lo renani suga' gajxh lo Pabl ca'preni ro' Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Räjp Pabl lo Ananías: ―Sigajcza ca'p Dios ro'lu, beṉguijdx. Ro'c sobga'lu te gunlu yäḻguxhtis si'cni caj lo leii. ¿Xhicuent rujnlu nani rnii leiiga di nungäjḻ gun bejṉ? ¿Xhicuent gunibeelu guda'preni ro'ä? ―räjp Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Reni suga' cuä' Pabl räjp lo Pabl: ―¿La dilu gacbee laa bixhojz ni sajcru xten Dios? Na'c guiniyajluni. ");
INSERT INTO zawNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Dxejcti räjp Pabl lojreni: ―Rexamigwä, dina niacbeä caniä lo bixhojz ni sajcru, sa'csi nanä agunii Dios: “Na'c guiniyajlu reni rnibee xpejṉlu.” Si'c caj lo guijtz ni bacuaa reni gunii xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Gucbee Pabl tiop cuaa najc reni tre' ro'c. Yu' reni najc beṉ saducee, yu'za reni najc beṉ farisee. Dxejc guredxa' Pabl räjpni lojreni: ―Sa'ä, narä nacä te beṉ farisee, xi'nza te beṉ farisee narä. Rililazä sibaṉsac bejṉ lo rebeṉgut, ni'c cabe'creni xquejä ree. ");
INSERT INTO zawNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Entis guniini si'c lojreni, chela gusloj caniireni lo sa'reni. Tiop cuaa gujcreni, gala' refarisee, sgala' resaducee. ");
INSERT INTO zawNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Di lajz resaducee chalii sibaṉsac rebeṉgut, dizareni chalilajz yu' rexangl Dios, dizareni chalilajz yu' aim xten bejṉ. Niluxh refarisee rililajz guiraa rediidxga. ");
INSERT INTO zawNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Guyu' te bieiro. Dxejcti huisulii gaii farisee nani najn leii, gusloj caniduxhreni, räjpreni: ―Di niguiire gac beṉguijdx. Palga gunii te angl xten Dios o te togool lojni, alga Dios tiḻnäjnu, dxejc sidxechnäj Diosnu. ");
INSERT INTO zawNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Che gusloj cabedxaduxhreni lo sa'reni, bidxejb comandant, andi ju'treni Pabl, caxha'treni yejcni. Dxejcti gunibeeni biäjt resoldaad cadro suga' Pabl. Guideb xtijpreni gulääreni Pabl galäii rebejṉga huinäsacrenini neṉ yuro xtenreni. ");
INSERT INTO zawNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Che biu' guxhijṉ, baluiloj Jesucrist lo Pabl, guzujni cuä'ni, räjpni lojni: ―Batijp lajzlu, na'c guidxejblu, Pabl. Si'cni basule'lu xtidxä guedx Jerusalén, sigajcza nanab gusule'lu xtidxä guedx Roma. ");
INSERT INTO zawNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Che bara yääl, bachagsa' gaii xpejṉ Israel, bejnreni xhigab nugu'treni Pabl. Räjpreni lo sa'reni: ―Na'c guidaunu, na'cza guiduṉnu nis che guigu'tlinu Pabl ―räjpreni. ");
INSERT INTO zawNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Si'cti tiuu niguii bia'n diidxga. ");
INSERT INTO zawNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bidzujṉreni lo rebixhojz näjza rebeṉgool, räjpreni lojreni: ―Abia'nnu diidx, xhet guidaudinu, xhetza guiduṉdinu palga dinu guigutxgaa Pabl ―räjpreni―. ");
INSERT INTO zawNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","N̲aj la'tu näjza guiraa rebeṉgool ni rnibee rexpejṉ Israel, coḻguxhaḻ diidx lo comandant te guixee jiädnäni Pabl lojtu. Coḻyejn si'c ni rlajztu jiejnru diajgtu diidx xcuent Pabl. Che jiädnä comandant Pabl ree, nuure sugu'tnuni lo nezyuj che gajdni guidzujṉ ree ―räjp reniguiiga. ");
INSERT INTO zawNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Niluxh biejn diajg xi'n bisiajn Pabl cabäzxhiga'tz reniguiiga te ju'treni Pabl, huijni royuro xten resoldaad. Che bidzujṉni, biu'ni räjpni lo Pabl rediidx ni biejn diajgni. ");
INSERT INTO zawNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Dxejcti gurejdx Pabl te capitán, räjpni lojni: ―Huinälaa bi'nre lo comandant te gäbni te diidx lojni. ");
INSERT INTO zawNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Huinäti capitán bi'nga lo comandant, räjpni lo comandant: ―Pabl, nani niäu neṉ yuro xten resoldaad, gunab loä jiädnälaä bi'nre lo guejblu te guiniini te diidx lo guejblu ―räjpni. ");
INSERT INTO zawNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Dxejc gunaaz comandant ṉaa bi'nre, huinänini te laad cadro rut jiejndi diajgni xtiidxreni, dxejc räjpni lojni: ―¿Xhini'c rlajzlu guiniilu loä? ");
INSERT INTO zawNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Dxejc bazejcni diidx, räjpni loj comandant: ―Abia'n te cuaa xpejṉ Israel diidx siniabreni lo guejblu jiädnä guejblu Pabl ro jusgaad guixee. Sujnsireni si'c ni rlajz jiejnru diajgreni diidx xcuent Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Na'c chalilajz guejblu xtiidxreni. Tiu niguii sibäzxhiga'tz cuä' nezyuj te ju'treni Pabl. Abia'nreni diidx direni gau, dizareni yä palga direni jutxgaa Pabl. N̲aj cabäjztisreni guxhaḻ guejblu diidx sinä guejblu Pabl ro jusgaad. ");
INSERT INTO zawNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Che biejn diajg comandant diidxga, basaanni sii bi'nga rolijzni, räpxgaani lojni: ―Rut lojdipac gäblu guniilu diidxre loä. ");
INSERT INTO zawNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Dxejcti gurejdx comandant tiop capitán, räjpni lojreni: ―Coḻgutojp tiop gayuu soldaad, chää guedx Cesarea näjza gayoṉbitzuu soldaad ni bijb cabaii, näjza tiop gayuu soldaad ni ca' spaad. Rcagaa guxhijṉ guiriireni ree. ");
INSERT INTO zawNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Coḻquiil tiop cabaii cuib Pabl te xhet gacdi Pabl cheni chanätuni lo gubernador Pels ―räjpni. ");
INSERT INTO zawNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Dxejcti bejn comandant te guijtz chanäreni lo gubernadoor. ");
INSERT INTO zawNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Loj guijtzga rnii scree: “Gubernador Pels, nani sacduxh. Narä, Claudio Lisias, ruxhaḻä xtixtios lo guejblu. ");
INSERT INTO zawNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Rediidxre rucuaä́ lo guejblu. Gunaaz rexpejṉ Israel niguiire, luxh paru dina nidzuṉga'cä con resoldaad, nugu'trenini. Che gucbeä najcni beṉ roman, guläänuni ro'c. ");
INSERT INTO zawNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Rlazä niacbeä xhi quej rbe'creni, ni'c huanää́ni lo junt xten rexpejṉ Israel ni rnibee guidoro. ");
INSERT INTO zawNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Dxejc gucbeä requej ni rbe'creni najc ganax xcuent leii xtenreni, niluxh xhet bejndini te nungäjḻ guetni, niclazä nanab jiäuni neṉ latzguiib. ");
INSERT INTO zawNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Che baxhaḻreni diidx loä cabäzxhiga'tz rexpejṉ Israelni te ju'treni dade're, baxhaḻga'cäni lo guejblu. Agunibeä́za jiädle'c rexpejṉ Israelre xquejreni lo guejblu. Ni'ctis rniä lo guejblu”, si'c caj lo guijtz ni bejn comandant. ");
INSERT INTO zawNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Che biu' guxhijṉ, huixii resoldaad Pabl sanärenini guedx Antípatris si'cni gunibee comandant gunreni. ");
INSERT INTO zawNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Che bara yääl, gubi' resoldaad nani guzaj ni'reni. Resoldaad ni bijb cabaii guzanäj Pabl guedx Cesarea. ");
INSERT INTO zawNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Che bidzujṉ redee Cesarea, badeedreni xquijtz comandant lo gubernadoor, huinäzareni Pabl lojni te biembeenini. ");
INSERT INTO zawNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Che gulujx biḻni guijtzga, gunabdiidxni lo Pabl: ―¿Caro siäädlu? Che gucbeeni siääd Pabl Cilicia, ");
INSERT INTO zawNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","räjpni lo Pabl: ―Guidzujṉsi rexpejṉ Israel ni cadxechnäj luj, sucuadiaggacä xtiidxlu ―räjp gubernadoor. Gunibeeni ga'p resoldaadni neṉ yuro xten Herodes. ");
INSERT INTO zawNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Gudejdti gaii dxej, dxejc bidzujṉ Ananías, bixhojz ni sajcru, näjza gaii rebeṉgool xten guidoro, näjza te dade' ni laa Tértulo ni gunii xcuentreni. Gusloj cabe'cni xquej Pabl lo gubernadoor. ");
INSERT INTO zawNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Che biädnäreni Pabl, gusloj Tértulo cabe'c xquej Pabl lo gubernadoor. Räjpni lo gubernadoor: ―Xquixtioste guejblu dxiduxh nabaṉnu. Cayacnäduxh guejblu laadxnu con redzunsacduxh ni cayujn guejblu. ");
INSERT INTO zawNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Xquixtiosduxh guejblu, gubernadoor Pels, xcuent guiraa redzunsa'c ni rujn guejblu guira nejz. ");
INSERT INTO zawNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Luxh na'cru gusieednu guejblu, gucuadiaglaa guejblu tiop diidx. ");
INSERT INTO zawNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Agucbeenu xho najc niguiire. Beṉguidxduxhni. Cadrotis ṟijni rujnni biejy lo rexpejṉ Israel. Laani rnibee te cuaa ni laa nasareṉ, nalajznu rebejṉ nani rililajz xtidx Jesucrist ni biääd guedx Nasare't. ");
INSERT INTO zawNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Rlajzlini nuxhiṉni xquidoronu, ni'c gunaaznuni. Niennu te junt te lagajc nuure niennu yäḻguxhtisni si'cni caj lo xquijtznu. ");
INSERT INTO zawNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Niluxh bidzujṉ comandant Lisias näjza resoldaad. Diptis badzucajreni niguiiga ladzṉaanu. ");
INSERT INTO zawNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Laani gunibeeni lo guejblu jiääd reni rbe'c xquejni. N̲aj lagajc guejblu sajc guiniabdiidx lojni te gacbee guejblu gulii guiraa requej nani rbe'cnu xcuentni ―räjp Tértulo. ");
INSERT INTO zawNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Dxejcti guiraa rexpejṉ Israel ni suga' ro'c räjp guliica xtidx Tértulo. ");
INSERT INTO zawNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Dxejcti bejn gubernadoor seen lo Pabl te guiniini. Baze'c Pabl diidx, räjpni lojni: ―Rbaaliza lazä guze'cä diidx lo guejblu, sa'csi anana agujc xchero lacti huen rujn guejblu yäḻguxhtis nacióṉ Israelre ―räjp Pabl―. ");
INSERT INTO zawNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Gutzbitio'p dxejtis bidzuṉä guedx Jerusalén te sagaṉä Dios. Najn rebejṉ xhi dxej biu'ä Jerusalén, guyasi guniidxreni diidx. ");
INSERT INTO zawNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Nicla tej dina nichagdiḻä bejṉ neṉ guidoro. Nicla tej dina niunä biejy neṉ reguidobäz, nicla ro nezyuj. ");
INSERT INTO zawNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Agule'creni quej xtenä lo guejblu, niluxh nicla tej redzuunga dina niunä. Di gacdi guluipacreni lo guejblu gulii najc xtiidxreni. ");
INSERT INTO zawNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Rniliäpac lo guejblu: Raṉä Xtios retoxtadgoldoonu. Jesucrist baluii xho gaṉsa'cnu Dios. Rililazä rextiidxni. Xhidalduxh rexpejṉ Israel rniyaj xho basule' Jesucrist gaṉ bejṉ Dios. Ruzobä guiraali releii xten toMoisés. Rililazä guiraa rextidx Dios ni bacuaa reni gunii xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Rililazä xtidx Dios si'c rililajzza rebejṉre xtidx Dios. Si'c ni najnreni, si'cza nanä sidzujṉ te dxej che guibaṉsac rebeṉgut, rebeṉguijdx sigajc rebeṉsa'c. ");
INSERT INTO zawNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ni'cni racbeä laaca nabaṉä guiraa dxej, di lastoä guidxejb, nicla nez loj bejṉ niclaza nez loj Dios, sa'csi rut rajcdi guiliäs dixhii xcuentä. ");
INSERT INTO zawNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Räjp Pabl: ―Agujc xchej yu'ä zijt, lajdx garenca bejṉ, ṉaj gubinää́ meel ni baxhaḻ rebeṉ nejzga te gudedäni lo rebejṉ ni xhet rajpdi. Biädnää́za gojn xtenä gudedäni lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ni'c sanää́ guidoro. Ro'c bidxäjl rexpejṉ Israel ni siääd Asia narä. Agucnayaä si'c ni rnibee xleiinu. Xhet beṉxhidajldi suganää́, xhetza biejydi cayunä. ");
INSERT INTO zawNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","¿Con rebejṉga ṉaj? Te cue'creni quej lo guejblu palga yu' xhini'c rdxechnäjreni narä. ");
INSERT INTO zawNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","O guiniiza redee palga yu' xhini'c et laadi benä che suga'ä nez loj junt xten guiraa rebixhojz ni rnibee näjza rebeṉgool lo guedx Jerusalén ―räjp Pabl―. ");
INSERT INTO zawNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Tejtis diidx guniä che suga'ä galäiireni, guredxa'a räpä lojreni: sa'csi rililazä sibaṉsac guiraa rebejṉ lo rebeṉgut, ni'c biädnätu narä lo rebejṉre ―si'c guniä lojreni. ");
INSERT INTO zawNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Che biejn diajg Pels xtidx Pabl näjza sa'csi najne'ni xcuent diidx nani baluii Jesucrist, basoobni stee dxej guidxagsac sa'reni räjpni lojreni: ―Che jiäädli comandant Lisias dxejc gunä yäḻguxhtis ―räjp Pels. ");
INSERT INTO zawNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Dxejcti gule Pels te capitán ni rnibee te gayuu resoldaad ga'p Pabl. Niluxh räjpni lojni gusaanni gun Pabl nani rlajztisni gunni. Na'cza gudxojnni jiääd rexamigwni te fiireni lojni. ");
INSERT INTO zawNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Che gudejd balti dxej, gubi' Pels, biädnäni chäälni Drusila. Drusila najc beṉ Israel. Dxejc gurejdx Pels Pabl te gusule'ru Pabl xtidx Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Gunii Pabl xho nanab guibaṉsa'c bejṉ nez loj Dios si'c ni gunibee Dios guibajṉ bejṉ. Nanabza gacbee bejṉ na'c gun bejṉ cos guijdx, sa'csi sidzujṉ dxej gac Dios juejz loj guiraa rebejṉ te fiini xhi bejnreni. Racsesli Pels tant bidxejbni biejn diajgni diidxga. Räjpni lo Pabl: ―Huij ṉaj. Sibedxsacälu che latä stee ―räjp Pels. ");
INSERT INTO zawNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Naa Pels sudeed Pabl meel lojni te gusḻaanini, ni'c masru guet-guejt gurejdxnini te guninäjnini. ");
INSERT INTO zawNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Si'c gudejd tiop ijz. Dxejc birii Pels gubernadoor. Dxejcti biu' Porcio Festo, gujcni gubernadorcoob. Niluxh Pels rlajz chanälajz rexpejṉ Israelni, ni'c basa'nni niäusijc Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Che biu' Festo gujcni gubernadorcoob xten reguejdxga, bia'nni guedx Cesarea choṉ dxej. Dxejc biriini ro'c sääni guedx Jerusalén. ");
INSERT INTO zawNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Che bidzujṉni guejdxga, rebixhojz nani rnibee näjza reniguii ni sajcru lo rexpejṉ Israel biääd lo Festo. Gusloj cabe'creni xquej Pabl lojni. Gunabduxhreni lo Festo ");
INSERT INTO zawNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","sa'csi rlajzreni gunni te huen laareni, guinibeeni jiädnäreni Pabl guedx Jerusalén. Si'c gunabreni, sa'csi abenxgaareni xhigab cuäzxhiga'tzreni te ju'treni Pabl lo nezyuj. ");
INSERT INTO zawNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Dxejcti räjp Festo lojreni: ―Suniäu Pabl guedx Cesarea. Di gaclaa guibi'ä guedx Cesarea. ");
INSERT INTO zawNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Suchää reniguii ni sajcru lo sa'tu guedx Cesarea, te ro'c cue'creni xquej Pabl loä, don la yu' xhi dzunguijdx bejnni ―räjpni. ");
INSERT INTO zawNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Che gudejd si'cti tzuu dxej, gubi' Festo guedx Cesarea. Che bara yääl, gurejni lo yagxhil xten gubernadoor, gunibeeni biääd Pabl lojni. ");
INSERT INTO zawNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Che bidzujṉ Pabl lojni, biääd rexpejṉ Israel nani biääd guedx Jerusalén ro'c. Guzujreni guideb gabi Pabl. Gule'creni xhidalduxh xquej Pabl, luxh di niajcdi nuluiireni guliipac xtiidxreni. ");
INSERT INTO zawNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Dxejcti räjp Pabl lojreni: ―Nicla tej latsiaj dina niunä, dina niunä latsiaj loj leii xtennu, dizana niunä latsiaj lo guidoro ni sojb guedx Jerusalén, dizana niunä latsiaj loj xgubier César. ");
INSERT INTO zawNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Dxejcti Festo, sa'csi rlajzni guiliäsni xpala'nni loj rexpejṉ Israel, räjpni lo Pabl: ―¿La sisiajlu guedx Jerusalén te cue'c rexpejṉ Israel xquejlu ro'c nezloä, ä? ");
INSERT INTO zawNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Dxejcti räjp Pabl lojni: ―N̲aj suga'a loj guejblu, ni gule ṟeii César. Guejblu rnibee guiraa reguejdxre. Ree nungäjḻ cue'creni xquejä lo guejblu, xhet guedx Jerusaléndi. Ananchee guejblu xhet latsiajdi benä lo rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Palga nacä te beṉguijdx, o palga yu' xhi latsiaj benä te nungäjḻ guetä, xho dina xcäbä guetä. Palga xhet latsiajdi benä nani canii rexpejṉ Israel benä, dxejc rutliidi sajc guteed narä ladzṉaareni. Suchale'creni xquejä lo César nani najc ṟeii xten rebeṉ roman ―räjp Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Che guninäj Festo reguxhtis xten xquidoro rexpejṉ Israel, räjpni lo Pabl: ―Luj gunablu chäälu loj ṟeii César. Mbaj. Sijlu lo ṟeii César ―räjp Festo. ");
INSERT INTO zawNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Che gudejd balti dxej, bidzujṉ ṟeii Agripa näjza chäälni Berenice guedx Cesarea. Biädhuiireni gubernadoor Festo. ");
INSERT INTO zawNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Che guyu'reni ro'c xchej, bij Festo diidx lo Agripa xcuent Pabl. Räjp Festo lojni: ―Ree niäusijc te niguii ni laa Pabl ni basa'n Pels. ");
INSERT INTO zawNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Che guyu'ä guedx Jerusalén, rebixhojz ni rnibee näjza rebeṉgool xten rexpejṉ Israel gule'c xquejni loä. Rlajzreni guinibeä guetni. ");
INSERT INTO zawNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Räpä lojreni: “Di leii xten nacióṉ roman gusaan guet te bejṉ palga di bejṉ jiädxgaa te guiniireni nez lojpacni xhi bejn niguiiga, te guzejcza niguiiga diidx xcuent requej, te guiniini la guliireni.” ");
INSERT INTO zawNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ni'cni che biääd rexpejṉ Israelga lo guejdxre, che bara yääl guregacä lo yagxhil xten gubernadoor. Dxejc gunibeä huixiireni Pabl guzuj nez loä. ");
INSERT INTO zawNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Benä xhigab pet yu' xhi cosro bejnni. Luxh che gusloj cabe'creni xquejni, gucbegacä xhet latsiarodi bejn Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Alga cadiḻnäjrenini xcuent xleiireni, xcostumbrreni. Guniizareni xcuent te niguii ni laa Jesucrist. Agujtni, niluxh canii Pabl gubaṉsacni lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Guxii nanä xcuent sa' diidxre, ni'cni gunabdidxä lo Pabl top sicäjbni chanää́ni guedx Jerusalén te ro'c cue'c rexpejṉ Israel xquejni. ");
INSERT INTO zawNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Dxejc che gunii Pabl lojpac ṟeii César chale'c rexpejṉ Israel xquejni, ni'c gunibeä jiäusijcni laḻ ni gac guxhaḻäni lo César ―räjp Festo. ");
INSERT INTO zawNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Dxejcti räjp Agripa lo Festo: ―Narä rlazäza jiejn diagä xtidx niguiiga ―räjp Agripa. Dxejcti räjp Festo lojni: ―Guixee gucuadiajglu xtiidxni ―räjpni. ");
INSERT INTO zawNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Che bara yääl, biääd Agripa näjza Berenice, luxh sucheduxhreni. Näjza recapitán ni sajcru näjza rebejṉ ni sajcru lo guejdxga biu'reni neṉ yuro xten Festo. Dxejc gunibee Festo biääd Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Dxejcti räjp Festo lo guiraa reni ṟe' neṉ yuro: ―R̲eii Agripa näjza guiraa rebejṉ ni tre' ree, coḻcuadiajg. Coḻhuii lo niguiire. Reni rnibee xpejṉ Israel guedx Jerusalén näjza guejdxre agule'c xquejni loä, canabduxhreni guetni. ");
INSERT INTO zawNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Niluxh narä rchaloä xhet bejndini te nungäjḻ guinibeä guetni. Luxh lagajc laani gunabni chääni te gac César juejz lojni, ni'c runä xhigab guxhaḻäni lojni. ");
INSERT INTO zawNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","N̲aj dina ganä xhini'c gucuaä lo guijtz te guxhaḻäni lo César ni rnibee narä. Ni'c biädnää́ niguiire nez lo guiraatu, ganid nez loj guejblu, ṟeii Agripa, filaa guejblu te gaxäjsi che aguiniini xtiidxni lo guiraanu, sidxälä xhi diidx gucuaä lo guijtz ni chää lo César. ");
INSERT INTO zawNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Narä runä xhigab di nungäjḻ guxhaḻä niguiire ni niäu latzguiib lo César palga di gacdi gusule'ä xhi quej xcuentni cabe'c rexpejṉ Israel loä. ");
INSERT INTO zawNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Dxejcti räjp Agripa lo Pabl: ―Gunilaa xtiidxlu loonu. Dxejcti guläs Pabl ṉaani, gusloj cagusule'ni diidx lojreni. Räjpni: ");
INSERT INTO zawNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","―Reii Agripa, rbalazduxhä sa'csi sajc gusule'ä diidx lo guejblu, sa'csi ṉaj suze'cä diidx xcuent guiraa requej ni gule'c rexpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Sa'csi guejblu nanduxh xcuent guiraa releii xten rexpejṉ Israel. Najnza guejblu xhicuent rdxagdijḻ sa'reni. Ni'c rniabduxhä na'c jieed guejblu gucuadiaglaa guejblu guiraa rextidxä. ");
INSERT INTO zawNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Räjpza Pabl: ―Guiraa rexpejṉ Israel naṉchee xho nacä che gucäli biuux guedx Jerusalén. Galooli najc guedx Jerusalén ladxä. ");
INSERT INTO zawNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Galooliza numbeereni narä, malaii guicäjpreni gucä te farisee nani bazobduxhru xleiinu si'cni rililajznu. ");
INSERT INTO zawNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","N̲aj suga'a ree, rlajzreni jiäuä sa'csi rililazä diidx nani bia'n Dios con retoxtadgoldoonu. ");
INSERT INTO zawNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Guitzubitiop cuaa rexpejṉ Israel huililajz siliäs Dios guiraa rebeṉgut te guibaṉsacreni. Ni'cni bazuxhijbreni lo Dios dxej-yääl. N̲aj rniliä lo guejblu ṟeii Agripa, sa'csi rililazä siliäs Dios guiraa rebeṉgut te guibaṉsacreni, ni'cni rlajzreni gusäureni narä. ");
INSERT INTO zawNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Palga abejn Dios xhigab guiliäsni guiraa rebeṉgut te guibaṉsacreni, ¿xhicuent di lajztu chalii xtidx Dios? ");
INSERT INTO zawNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Räjpza Pabl: ―Narä benäza xhigab galoo nanabpac guidxe'chä loj rexpejṉ Jesucrist ni siääd Nazare't, ni'c batedäreni trabajwduxh basäuäreni neṉ latzguiib. ");
INSERT INTO zawNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Guiraa recosre benäza guedx Jerusalén. Baniidx rebixhojz ni rnibee guijtz loä te basäuä rexpejṉ Jesucrist neṉ latzguiib. Che biäureni neṉ latzguiib, narä gule'cä xquejreni te gujtreni. ");
INSERT INTO zawNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Balti huält basacsiduxhäreni lagajc neṉ reguidobäz te niniyajreni Jesucrist. Luxh basacsiduxhäreni, hua'a guideb nez reguedxzijt te ro'c huisacsíä rexpejṉ Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Räjpza Pabl: ―Ni'c sa'a nez guedx Damasco, ca'a guijtz ni baniidx rebixhojz ni rnibee. ");
INSERT INTO zawNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Rniliä lo guejblu, ṟeii, si'cti läidxej, bahuiä te bajl ni siääd xhaguibaali. Rsanijruni loj gubijdx. Basanijni guideb gabi cadro suga'a näjza reni sanää. ");
INSERT INTO zawNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Che biabrloonu lo yuj, biejn diagä xse' te ni canii loä con didx hebreo: “Saulo, Saulo, ¿xhicuent rusacsílu narä näjza rexpeṉä? Che rusacsílu narä, lagajc luj rdejdlu trabajw, si'c te gon ni rucuani' yejc gaṟu'ch.” ");
INSERT INTO zawNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Dxejcti räpä lojni: “¿Chu luj Dad?” Dxejc najni loä: “Narä nacä Jesucrist nani cagusacsíduxhlu. ");
INSERT INTO zawNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Huistie, gusulii. Narä baluiloä lojlu sa'csi rlazä gaclu te xpeṉä. Aguleälu te gusule'lu lo rebejṉ guiraa ni bahuiilu nadxej, näjza guiraa recos ni churu guluiä lojlu. ");
INSERT INTO zawNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","N̲aj suxhaḻälu loj rexpejṉ Israel näjza lo rebeṉzijt nani di gac xpejṉ Israel. Che gusacsí rexpejṉ Israel näjza rebeṉzijt luj, sacnäduxhälu, te di ju'treni luj. ");
INSERT INTO zawNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Gacnää́ lastooreni te che jiejn diajgreni xtidxä, chalilajzrenini, diru xcäriejnreni gac nayääl, sianij xcäriejnreni. Dxejc dirureni gusoob xtidx Beṉdxab ni rnibee rebeṉdxab, sa'csi susoobreni xtidx Dios. Che chalilajzreni rextidxä, sudzucaj Dios xtojḻreni. Dxejcti suchaag Diosreni loj renani anajc beṉnaya sa'csi basoobreni xtidx Dios, huililajzreni xtidxä.” ");
INSERT INTO zawNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Räjpza Pabl: ―Ni'cni rniliä lo guejblu, ṟeii Agripa, cayunä si'cni naj Jesucrist loä gunä che baluilojni loä. ");
INSERT INTO zawNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Gunixgaä xtiidxni lo rebeṉ Damasco. Räpä lojreni: “Coḻgusiechlajz, coḻgusoob xtidx Dios. Coḻyujn dzunsa'c te gacbee rebejṉ abasiechlajztu, arusoobtu xtidx Dios.” Si'cza guniä lo rebeṉ Jerusalén, näjza lo rebejṉ ni yu' reguedx Judea, näjza lo rebeṉzijt ni di gac xpejṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Sa'csi benä si'c, gunaaz rexpejṉ Israel narä neṉ guidoro, rlajzreni nugu'treni narä. ");
INSERT INTO zawNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","N̲aj racnäj Dios narä, ṉaj sanuutis cagusule'ä rediidxga lo guiraatis bejṉ. Loj rebejṉ ni xhet rajpdi sigajc loj rebejṉ ni rapduxh. Rusule'ätis nani caj lo guijtz nani bacuaa toMoisés näjza guiraa reniguii nani gunii xtidx Dios. Laareni galooli guniireni xcuent xhini'c gac ṉaj. ");
INSERT INTO zawNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Najreni sidejd Crist trabajwduxh, sugu'trenini. Niluxh sa'csi ganiddoo laani guibaṉsacni lo rebeṉgut, ganiddooza laani suluiini loj rexpejṉ Israel näjza loj guiraa rebeṉzijt guliipac xtidx Dios, sibaṉsac bejṉ lo rebeṉgut, si'c ni guniini galooli. ");
INSERT INTO zawNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Laḻ ni canii Pabl rediidxga lojreni, dip gunii Festo, räjpni lo Pabl: ―Pabl, yejclu cayajc. Pet sa'csi nanduxhlu guijtz ni'c cayajc yejclu. ");
INSERT INTO zawNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Dxejcti räjp Pabl lojni: ―Rniliä lo guejblu dad gubernador Festo, xhet rajcdi yecä. Ganax didxlii caniä. ");
INSERT INTO zawNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ree suga' ṟeii Agripa. Laani nancheeni guiraa rediidxre, ni'c guyasi caniä rediidxre lojni, dizana guidxebä sa'csi anajnni gulii guiraa ni gujc, sa'csi xhet xhiga'tzdi gujcreni. ");
INSERT INTO zawNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Guejblu ṟeii Agripa, ¿la rililajz guejblu xtidx reniguii nani bacuaa xtidx Dios, ä? Naṉcheä rililajz guejblu diidxga ―räjp Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Dxejcti räjp Agripa lo Pabl: ―Tuche'nsi riäädx gunlu gan chalilazä xtidx Jesucrist te gacä xpeṉ Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Räjp Pabl lojni: ―Xhet najcdi palga guxii o xhidajl cayäädx, narä canabä guniidx Dios chalilajz guejblu xtiidxni si'c rililazä xtiidxni, nägajcza guiraa reni cacuadiajg xtidxä te gactu si'c nacä, niluxh xhet näjdi resa' cadeṉre ―räjp Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Dxejcti huisu Agripa, Festo, Berenice, näjza rebejṉ ni sobganäjreni. ");
INSERT INTO zawNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Che gubigreni stelaad, räjpreni lo sa'reni: ―Niguiire xhet bejndini te guetni, xhetza bejndini te jiäuni. ");
INSERT INTO zawNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Dxejcti räjp Agripa lo Festo: ―Paru dini niniab chääni lo César, sajc nusḻaanuni. ");
INSERT INTO zawNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Basoobtireni dxej ni niu'nu neṉ barcw te chonnu Italia. Dxejc bateedreni Pabl näjza sgaii bejṉ nani niäuza lo capitán ni laa Julio. Rnibee Julio te gayuu soldaad, najcreni te cuaa ni laa Augusto. ");
INSERT INTO zawNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Näjza te dade' ni laa Aristarco guzaj, siäädni guedx Tesalónica xten Macedonia. Biu'nu neṉ barcw ro' guedx Cesarea. Barcwga siääd guedx Adramitio. Biriitinu, najc xhigab teednu nez reguejdx nani yu' ro' nisdoo lo reyuj xten Asia. ");
INSERT INTO zawNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Che bara yääl guläjz barcw ro' guedx Sidón. Huenduxh gujc Julio con Pabl, basaanni bihuii Pabl rexamigwni ni yu' guejdxga te bahuiireni Pabl, badeedreni xhi rquiinni. ");
INSERT INTO zawNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Che säsac barcw lo nisdoo, bideednu stelaad Chipre, yuj ni tre' lo nisdoo, sa'csi sääb te beduxh, ni'c naga' Chipre xladbäjgwnu, te guxiiru rda' bej loonu. ");
INSERT INTO zawNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Che sonnu neṉ barcw, bideednu xnisdoo reguedx Cilicia näjza xnisdoo reguedx Panfilia, te bidzuṉnu ro' guedx Mira xten Licia. ");
INSERT INTO zawNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ro'c bidxäjl capitán xten resoldaad stee barcw ni siääd guedx Alejandría. Agojl chää barcwga Italia. Bateedtini guiraanu lo barcwga. ");
INSERT INTO zawNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Balti dxej chäigaj sonnu lo nisdoo. Trabajwduxh bidzuṉnu lo nisdoo ro' guedx Gnido, sa'csi entis cabi' beduxh nez cadro sonnu. Ni'c trabajwduxh bideednu xladbäjgw yuj Creta ni tre' lo nisdoo xladbeenu. Gudejdnu guedx Salmón. ");
INSERT INTO zawNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Dxejcti chäiduxh sonnu neṉ barcw lo nisdoo nez cuä' yu Creta; si'ctis gujc bidzuṉnu te lajt ro' nisdoo ni laa Buenos Puertos cadro guxii sääb bej. Gajxh ro'c tre' guedx Lasea. ");
INSERT INTO zawNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Agujc balti dxej cayaclaanu, luxh agudejdza dxej ni rucua'n rexpejṉ Israel, guxii riäädx chaa ijz. Rebäire di bejṉ chää neṉ barcw sa'csi yuduxh riesgw lo nisdoo, ni'c balijdx Pabl rebejṉ, ");
INSERT INTO zawNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","räjpni lojreni: ―Rexamigwä, runxgaä bis guejbtu, palga chonnu neṉ barcw chanuunu xnejznu, sajc te liädxduxh. Sinitloj cargw, sibijxh barcw, luxh silo' xhidajl bejṉ, ―räjpni. ");
INSERT INTO zawNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Niluxh di capitán xten resoldaad niu xtidx Pabl. Biuruni xtidx nani rusaj barcw näjza xtidx baxhuaan xten barcw. ");
INSERT INTO zawNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Luxh sa'csi lajtga dini gajc huen tedreni rebäii naḻduxh, bejnreni xhigab hueenru guiriinu ro'c te chonnu guedx Fenice ni tre'za lo yu Creta, sa'csi di bej guibiduxh ro'c. Hueenru ro'c guilääznu ted rebäinajḻ, rajpreni. ");
INSERT INTO zawNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ni'c che gusloj cabi' te bebäz nez lad sur, naareni pet xhet najcdi guiriinu lo nisdoo con barcw. Dxejc basḻaareni barcw, sontinu ro' nisdoo gajxh cuä' Creta. ");
INSERT INTO zawNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Niluxh di niaclaa gusloj te nisguipeduxh birii nez redajn xten Creta. ");
INSERT INTO zawNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Gunaaz bejga barcw, diru gacdi gusajrenini. Basa'ntireni sanä bejga barcw cadrotis rlajzni. ");
INSERT INTO zawNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Siädgobiuj barcw te canuu. Che bidzuṉnu stelaad te yuje' ni tre' lo nisdoo ni laa Clauda, guxiiru cabi' beduxhga. Dxejcli bejnreni gaan guläsreni canuu neṉ barcw. ");
INSERT INTO zawNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Che basäḻnu canuu neṉ barcw, cua'reni gaii duro te baliibreni barcwro, bateedreni gaii duu xque' barcw te na'c guibiḻni. Cadxejbreni te di chachu' barcw lo yujxh ni laa Sirte ni yu' neṉ nisdoo. Ni'c guläjtreni ladro ni rniaaz bej te rusajni barcw, gudixhreni lajdga neṉ barcw. Sanäti beduxhga barcw cadrotis rlajzni. ");
INSERT INTO zawNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Che bara yääl caguscuä' beduxh barcw lo nisdoo. Sas basäḻreni che'n cargw lo nisdoo te bicharu barcw. ");
INSERT INTO zawNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ni riojṉ dxej, lagajc laareni basäḻreni lo nisdoo guiraa xtrast barcw. ");
INSERT INTO zawNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Che agujc balti dxej niäu lo gubijdx, diza rebale' nieṉ xhaguibaa sa'csi laḻtis cayajb nisguipeduxhga, biennu xhigab guiraanu sejtnu. ");
INSERT INTO zawNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Xchero rut rlajzdi gau. Dxejc gusuj Pabl galäii rebejṉ räjpni lojreni: ―Rexamigwä, paru nucuadiajg guejbtu xtidxä, na'c niriitu xyuj Creta, di liäädxre niajc, dizanu nidejd trabajwduxhre. ");
INSERT INTO zawNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Niluxh coḻcuecdxi lastootu. Niclatej bejṉ ni siääd lo barcw di guet. Barcwtis sinitloj. ");
INSERT INTO zawNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Nacä te xpejṉ Dios, runä xhitis ni rnibeeni gunä. Nayääl biädsuj te xangl Dios cuä'ä, ");
INSERT INTO zawNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","najni loä: “Na'c guidxejblu Pabl. Nanabpac chäälu lo ṟeii César. ¡Bahuilaa! Abasalajz Dioslu reni siädnälu; nicla tej reni yu' neṉ barcwre di guet”, najni loä. ");
INSERT INTO zawNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ni'cni caniä lo guejbtu, na'c guidxejbtu. Narä rililazä xtidx Dios. Rililazä sisiojb xtidx Dios si'c ni naj xangl Dios loä. ");
INSERT INTO zawNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Niluxh yu' cadro chalaj barcw lo yujxh neṉ nisdoo gajxh lo te yuje' ni tre' neṉ nisdoo ―räjp Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Si'cti tiop xman balaṉaa beduxhga barcw nezre, nezrec lo nisdoo ni laa Adria. Pet garol yääl ni bejn reniguii ni ruzaj barcw xhigab abidzujṉ barcw gajxh lo yuj, ");
INSERT INTO zawNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ni'c bastejbreni te guiib lo duu xhajn nisdoo, te barexhreni ro'c, dxejc gucbeereni najc nisdoo jiät si'cti gaḻbitzubixho'p metr. Che guzaj barcw stelabäze', bastebsacreni guiib con duu xajn nisdoo, dxejc gucbeereni ro'c najc nisdoo jiät si'cti gaḻbigajdz metr. ");
INSERT INTO zawNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Dxejc bidxejbreni te di chalaj barcw yejc reguij. Bacuaatireni tajp guibro si'c guench ni naliib te cadeṉ te ru'reni neṉ yujxh te ruscuääzreni barcw, te jia'nni tejsi lajt. Dxejc rlajzreni malaii jianijga lo guedxliuj. ");
INSERT INTO zawNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Dxejcti gulät remos canuu lo nisdoo cayujnsireni si'cni chastejbreni stee guench guiib lo nisdoo, niluxh rlajzreni guxuṉreni guidon la sajc guidzujṉreni ro' nisdoo. ");
INSERT INTO zawNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Dxejcti räjp Pabl lo capitán näjza lo resoldaad: ―Palga di redee jia'n neṉ barcw, di gacdi gusḻaatu xcäḻnabajṉtu ―räjpni. ");
INSERT INTO zawNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Dxejcti batiugya' resoldaad duu ni naaz canuu te bitejbni lo nisdoo, sanäti nisdoo canuuga. ");
INSERT INTO zawNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Che gusloj cayanij, gunibee Pabl, räjpni lojreni: ―Nadxej rajc tiop xman gajdtu gues, gajdzatu gau. ");
INSERT INTO zawNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","N̲aj coḻtajw te gac guixoobtu lo nisdoo. Na'c guntu xhigab guettu, nicla tej xquidxejctu di nitloj. ");
INSERT INTO zawNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Che gulujx gunii Pabl si'c, cua'ni yätxtiil, badeedni xquixtios lo Dios nez loj guiraareni. Dxejc gula'nini, gusloj cayajwnini. ");
INSERT INTO zawNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Dxejc bibaa-lajzreni, näjza laareni gusloj cayajwreni. ");
INSERT INTO zawNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Nuunu najcnu tiop gayuu gayoṉbitzubixho'p bejṉ ni yu' neṉ barcwga. ");
INSERT INTO zawNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Che agujc gudajwreni, basäḻreni triuu lo nisdoo te bicharu barcw. ");
INSERT INTO zawNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Che bianisac, direni niembee yujga, niluxh bahuiireni cadro rdzujṉ te gueubäz ro' nisdoo cadro yu' xhiroob yujxh ro' nisdooga. Rlajzreni nusiu'reni barcw ro'c. ");
INSERT INTO zawNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Dxejcti basḻaareni guidap guench guiib ni naaz barcw, bia'nreni guideb cadeṉ neṉ nisdoo, baxheczareni yajg ni ruzaj barcw, guläszareni ladro nez delant barcw te balaṉaa bej barcw. Badzuréreni barcw sääreni nez ro' nisdoo. ");
INSERT INTO zawNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Sas biu'reni te lajt cadro rdxagsa' tiop cuaa nis. Ro'c huilaj yejc barcw neṉ yujxh neṉ nisdoo, digacdiru guiniibni. Dxejcti gusloj cabijḻ dejtz barcw sa'csi sanuutis caguijn nisdoo detz barcw. ");
INSERT INTO zawNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Dxejcti rlajz resoldaad nugu't repres te di guixoobreni lo nis guxuṉreni. ");
INSERT INTO zawNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Niluxh di rlajz capitán xten resoldaad guet Pabl, ni'c dini nusaan nugu't resoldaad repres. Gunibee capitán ganiddoo renani rajc rxoob lo nis guitiäjs lo nisdoo te guidzujṉreni lo yujxh. ");
INSERT INTO zawNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Dxejcti birinajl rebejṉ ni digacdi guixoob lo nis, naazreni barajd o te la' yajg ni gula' detz barcw. Si'c gujc bidzujṉ guiragajc rebejṉ lo yujxh ro' nisdoo. Nadaanreni bidzujṉreni lo yujxhga. ");
INSERT INTO zawNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Che bidzujṉnu lo yuj ni tre' lo nisdoo, biembeenu yujga najc ni laa Malta. ");
INSERT INTO zawNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Gucnäj rebejṉ ro'c nuure, gule'creni guiboo bahuiireni nuure sa'csi cayacnaḻduxh, cayajbza nisguij. ");
INSERT INTO zawNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Ca' Pabl te dääz yajg, sale'cnini lo guiboo, chela biriyäḻ te bäḻ nialajz neṉ yajgga. Saa gudauya'ni ṉaa Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Che bahuii rebeṉ Malta li najl bäḻ nialajzga cayauya' ṉaa Pabl, gusloj cayäjbreni lo sa'reni: ―Pet rugu'tni bejṉ ni'c mase bejnni gaan lo nisdoo siguijxni xtojḻni, sejtni ṉaj. ");
INSERT INTO zawNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Gubijb Pabl ṉaani dxejcti bitejb bäḻga lo guiboo. Xhet gujcdi ṉaa Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Dxejc rebeṉ ro'c cabäjz fiireni la sisiäguij ṉaa Pabl o laa sejtni. Xchero bidxelojreni. Che bahuiireni xhet gujcdini, gusloj bejnreni ste'ca xhigab, räjpreni lo sa'reni: ―Pet dios najcni. ");
INSERT INTO zawNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Gajxh ro'c naga' xyuj te dade' ni laa Publio ni najc xcubernadoor Malta. Biojia'nnu rolijzni choṉ dxej. Huenduxh gujc dade'ga, baniidxni guiraa ni biquiinnu. ");
INSERT INTO zawNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Naga' xtad Publio cayacxhuuni, yu'ni xliaa, cayajczani yobrejn. Huihuii Pablni. Guredx-gunab Pabl lo Dios, dxejc batzuub Pabl ṉaani yejcni, basiacgajcnini. ");
INSERT INTO zawNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Che gucbee rebeṉguejdxga abasiajcni beṉ racxhuuga, bidzuṉnäjreni beṉ racxhuu lo Pabl, basiajc Pabl guiraareni. ");
INSERT INTO zawNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ni'c banidx-xliaareni xhidalduxh xhicos, luxh che biriinu ro'c, baniidxreni guiralii recos ni biquiinnu neṉ barcw. ");
INSERT INTO zawNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Agujc choṉ bäii yu'nu ro'c che biu'nu neṉ te barcw ni siääd Alejandría. Lagajc ro'c bateed barcwga rebäinajḻ che rsiäb beduxh. Yejc barcwga caj tiop figuur xten tiop biuux ni laa Cástor näjza Pólux, rexingancua'ch dios ni laa Zeus. ");
INSERT INTO zawNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Biriinu Malta sonnu neṉ barcw nez guedx Siracusa. Ro'c bia'nnu choṉ dxej. ");
INSERT INTO zawNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Dxejcti biusacnu neṉ barcw, sonnu lo nisdoo cheni bidzuṉlinu guejdx ni laa Regio. Che bara yääl, gubi' te bej birii lad sur. Biusacnu neṉ barcw. Bara yääl bidzuṉnu guedx Puteoli. ");
INSERT INTO zawNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ro'c bidxaagnu gaii xpejṉ Jesucrist. Najreni loonu: ―Coḻjiannäj nuunu ―najreni. Bia'nnu ro'c gajdz dxej. Dxejc biriinu guejdxga, ni'nu sonnu nez guedx Roma. ");
INSERT INTO zawNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Che gucbee rexpejṉ Jesucrist ni yu' guedx Roma siopsaanu nez Roma, biäädreni guedx Foro de Apio näjza stee guejdx ni laa Tres Tabernas, ro'c bidxaagreni nuure. Che bahuii Pabl lojreni, guzutijp lastooni, badeedni xquixtios lo Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Che biu'nu guedx Roma, bateed capitán repres ladzṉaa comandant, niluxh basaanni cualaa Pabl te yu' cadro cuääzni. Tejtis soldaad biannäj Pabl. ");
INSERT INTO zawNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Che gudejd choṉ dxej, gurejdx Pabl reni rnibee lo rexpejṉ Israel. Che bidxaag sa'reni cadro yu' Pabl, räjpni lojreni: ―Guejbtu rexamigwä, resa'ä, xhetliidi nani xhet laadi benä lo rexpejṉ Israel, dizana nibälazä xleii toMoisés. Niluxh basäureni narä neṉ latzguiib guedx Jerusalén, dxejcti bateedreni narä ladzṉaa reroman. ");
INSERT INTO zawNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Che biejn diajgreni xtidxä, rlajz reguxhtis roman nusḻaa narä sa'csi xhet benädi te nugu'treni narä. ");
INSERT INTO zawNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Niluxh naaddi rexpejṉ Israel gusḻaareni narä, gunabätis lojpac ṟeii César jiädle'creni quej ni cabe'creni xcuentä. Niluxh narä xhet xquejdi rexpejṉ Israel cue'cä. ");
INSERT INTO zawNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ni'cni guredxä la'tu te fiä lojtu, te guininää́ la'tu, sa'csi rililazä lagajc si'c rililajz xpejṉ Israel sibaṉsac rebeṉgut, ni'c nalibä cadeṉre. ");
INSERT INTO zawNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Dxejcti räjpreni lojni: ―Nicla tej guijtz gajd reguxhtis xten reguedx Judea guxhaḻ loonu xcuentlu, gajdza rexpejṉnu ni bidzujṉ ree jiädsa'n diidx xhet laadi bejnlu. ");
INSERT INTO zawNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Rlajznu jiejn diajgnu xtiidxlu, don xhi naalu, sa'csi racbeenu xhidajl lajt rniyajreni redidxcoob xten Jesucrist ―räjpreni. ");
INSERT INTO zawNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Guletireni te dxej guidxagsa'reni. Che bidzujṉ dxejga, bidxagsa' xhidalduxh bejṉ neṉ yu' cadro rbäjz Pabl. Guideb dxej basule' Pabl xtidx Dios lojreni. Basule'ni xho rnibee Dios lojreni. Con rediidx ni caj lo xleii toMoisés näjza diidx ni bacuaa reniguii nani gunii xtidx Dios basule'ni Jesús najc Crist nani galooli cabäjz rebeṉ Israel jiääd. ");
INSERT INTO zawNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Yu' reni huililajz xtidx Pabl, yu'za reni di nililajz xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Sa'csi di niajcdi niujnreni tejsi xhigab gusloj siireni. Ganiddoo räjp Pabl lojreni: ―Guliica naj toIsaías che badeed Sprit Dxan xten Dios rediidxre guniini, räjpni lo rextadgoldoonu: ");
INSERT INTO zawNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Huij, gunii lo rebejṉre, scree gojz lojreni: Siejn diajgtu xtidxä, niluxh ditu gacbeeni. Suhuiitu nani runä luxh ditu gumbee xhini'c ruhuiitu. ");
INSERT INTO zawNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Agucnajd lastoo rebejṉre sa'csi di rlajzreni chalilajzreni xtidxä. Direni cuadiajg xtidxä sa'csi di rlajzreni jiejn diajgreni diidx ni guliipac. Rusäuzareni balojreni te di fiireni, te di lajzreni chalii. Ni'cni direni gusiechlajzreni te gusaan gunreni dojḻ te gudzucaj Dios xtojḻreni. ");
INSERT INTO zawNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Räjp Pabl lojreni: ―Coḻgacbee. N̲ajli sisiule' xtidx Dios lo rebeṉzijt ni di gac xpejṉ Israel te gusiejch lajzreni, te gudzucaj Dios xtojḻreni. Rniliä́pac lojtu, sililajzreni rextidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Che gulujx gunii Pabl rediidxga lojreni, ensilaareni gusloj cadxagdijḻ sa'reni laḻ ni sääreni. ");
INSERT INTO zawNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Tiop ijz guläjz Pabl guejdxga neṉ yu' ni cualaani. Biuni guiralii rebejṉ ni biääd rolijzni. ");
INSERT INTO zawNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Lo guiraa rebejṉga basule'ni xho rnibee Dios lojreni. Bijzani diidx xcuent redzuun nani bejn Jesucrist. Di lastooni nidxejb, rutza badxojndi guniini.");
INSERT INTO zawNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Narä, Pabl, nacä te xmos Jesucrist, laani gule narä te gusule'ä xtidx Dios loj rebejṉ. ");
INSERT INTO zawNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Agujc xchero bia'n Dios diidx loj renani basule' xtiidxni, suniidxni diidxre loonu, luxh diidx ni bia'n Dios caj lo guijtz xten reprofe'tga. ");
INSERT INTO zawNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Rediidx ni rusule'ä najc xcuent Jesucrist, Xi'n Dios, ni najc xagdoo toṟeii David xcuent tiejxhni. ");
INSERT INTO zawNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Xcuent Xsprit Dxan Dad Jesucrist, najcni Xi'npac Dios. Badeed Dios yäḻrnibee lojni, ni'cni gubaṉsacni lo rebeṉgut. ");
INSERT INTO zawNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Laani gucnäjni narä, guleni narä te gusule'ä xtiidxni te guzobdiajgtu, te chalilajz rebejṉ ni rej guideb guedxliuj xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Luxh nadxaagtu loj rebejṉ ni guleni te chalilajzreni xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ruxhaḻä guijtzre lojtu ni yu' guedx Roma, guiraatu ni sanälajz Dios ni bibeetu gactu beṉdxan. Gacnäj Dios ni najc Xtadnu näjza Dad Jesucrist la'tu, guscuecdxireni lajztu. ");
INSERT INTO zawNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ganidtoo rudedä xquixtios loj Dios con laj Jesucrist xcuent guiraatu, sa'csi guideb guedxliuj rujy bejṉ diidx xcuent xcäḻrililajztu. ");
INSERT INTO zawNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Lagajc Dios anajn xho rniabä guet-guejt xcuent la'tu lojni. Narä runä xtzuun Dios guideb lastoä, rusule'ä diidx xcuent Xi'nni Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Sanuutis canabä lojni, top sajc jiädhuiä lojtu si'cni rlazä gunä agujc xchejli. ");
INSERT INTO zawNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Sa'csi rlazduxhä fiä lojtu, te gacnää́tu, te gulidxä la'tu xhi te xtidx Dios te sudzu'tzrutu lo xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Nalajznu, te gustioobnu lajz sa'nu xcäḻrililajz xtidx Dios xten sa'nu. ");
INSERT INTO zawNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Rebetzä rlazä gacbeetu balti huält benä xhigab jiädhuiä lojtu, luxh gajd gacdi jiäḻä. Rlazä jiädhuiä lojtu te chalilajz xhidajlru bejṉ xtidx Dios sigajcni salilajzreni guiralajt cadro hua'a loj rebejṉ ni di gac xpeṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Nungäjḻpac gusule'ä xtidx Dios loj rebejṉ nani rnii garen-garen didxsaj, sigajc loj rebeṉ griegw, loj renani nayääl, sigajc loj rebeṉ najn. ");
INSERT INTO zawNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Rbaali lazä suga'a ṉaj, te gusule' xtidx Dios näjza lojtu ni yu' guedx Roma. ");
INSERT INTO zawNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Sa'csi dina guituiä xcuent xtidx Dios, sa'csi najcni yäḻrnibee xten Dios te gusḻaani lo dojḻ chutis bejṉ nani rlajz chalilajz xtiidxni, ganidtoo reni najc rexpejṉ Israel, dxejcti näjza rebejṉ ni di gac xpeṉ Israel. ");
INSERT INTO zawNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Sa'csi xtidx Dios rusule' xho nanab chalilajz te bejṉ te gacni te beṉsa'c nez lo Dios sa'csi huililajzni xtiidxni. Lo xtidx Dios caj scree: “Palga rililajz te bejṉ xtidx Dios, najcni te beṉnaya nez lo Dios, nabaṉnäjni Dios xcuent xcäḻrililajzni.” ");
INSERT INTO zawNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Xcälrdxe'ch Dios nani yu' xhaguibaa siajbni yejc rebejṉ nani gun dojḻ, nani rlajz gun cosguijdx, nani di gusaan guisieed sabejṉreni didxgulii. ");
INSERT INTO zawNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Sa'csi anancheereni nani sajc gan bejṉ xcuent Dios, ni'cni najnreni rajpreni dojḻ, sa'csi ruluipac Dios na'c gunreni dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Cheni birixtiejli guedxliuj, recos nani di gacdi fii bejṉ xcuent Dios, si'c xcäḻrnibeeni ni najc par tejpas, si'c xtujxh xtenni, huenliisi ruzeṉreni sa'csi ruluilojreni recos ni ruzeṉ nani benchee Dios. Guiraa reni'c ruluiloj najcni Gueb Dios ni rajp yäḻrnibee par tejpas, ni'c di gacdi guiniireni loj Dios direni niembee xhini'c rlajz Dios gunreni. ");
INSERT INTO zawNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ni'cni, mase biembeereni Dios, direni niliä'p xpala'nni te gaṉreni Gueb Dios, dizareni nudeed xquixtios lojni. Alga guyalajz gujcreni, bicäjy xcäriejnreni, naareni hueen najc gunreni si'ctis ni jiajb yejcreni, si'cni rsia' lajzreni neṉ lastooreni. ");
INSERT INTO zawNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Caniireni nanduxhreni, per direni gan, nayäälreni. ");
INSERT INTO zawNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Gulälazreni xcäḻrdimbicha' Dios ni najc tejsi par tejpas, te bazuxhijbreni nez loj rebanäjb ni benchee ṉaareni, ni najc guiraa ni rujn lojni si'c rujn lo te niguii ni rnitloj, näjza guiraa ni najc si'c reman ni rutajt, näjza guiraa ni najc si'c reman ni yu' tajp ni'ni, näjza ni najc si'c rebäjl. ");
INSERT INTO zawNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Ni'cni gulälaz Diosreni, basaanni gunreni si'ctis ni rlajzreni. Bejnreni dojḻ con resa'reni. ");
INSERT INTO zawNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Sa'csi ahuililajzreni didx-xhii lacuaa nililajzreni xtidxlii Dios, ruzuxhijbzareni nez loj recos ni benchee Dios, lacuaa guzuxhijbreni loj Dios nani benchee guiraa rexhicos, Dios nacle' par tejpas. Sugacni si'c. ");
INSERT INTO zawNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ni'cni gulälaz Diosreni, subia'nreni lo xcäḻlatsiajreni, lo yäḻxtujy xtenreni. Diru regunaa guesnäj niguii, lagajc sagunaareni resnäjreni. ");
INSERT INTO zawNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Sigajcza reniguii gulälaz regunaa, rujnreni dojḻ con lagajc saniguiireni. Luxh lagajc laareni siguijxreni latsiaj ni rujnreni. ");
INSERT INTO zawNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Luxh sa'csi di rlajzreni jiureni Dios, basaanti Dios suyu' cosguijdxtis xcäriejnreni, te chanuutisreni lo xcäḻlatsiajreni, rujnreni recos ni xhet laadi. ");
INSERT INTO zawNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Guidxareni dojḻ, näjza cosguijdx, näj yäḻruguilajz xhixten sa'reni; rugu'treni bejṉ, rujnreni yäḻrsiäblajz, rucuanäjreni resa'reni, rusgueereni sa'reni, rdxechnäjreni sa'reni, rniizareni didxxhii. ");
INSERT INTO zawNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Rniyaj sa'reni, rdxe'chreni lo Dios, guyalajzreni, dipacreni guitujy, rliä'preni lagajc xpala'nreni, entis latsiacoob rbäxtiejreni, guyalajzreni lo xcuzajnreni, ");
INSERT INTO zawNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","nadduxhreni, xheti xcäriejnreni, xhet sajcdi xtiidxreni ni ria'nreni lo sabejṉreni, direni chanälajz sa'reni si'cni nungäjḻ gacni, dizareni gulaslajz sa'reni. ");
INSERT INTO zawNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Luxh mase agucbeereni gun Dios yäḻguxhtis lojreni, najnzareni nungäjḻ guetpac renani rujn recosre, nicla jiureni, rujnreni guiraa recosguijdxre, luxh rbaali lajzreni richunäjreni rebejṉ ni rujnza recosguijdxga. ");
INSERT INTO zawNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ni'cni, ¿canejz chäätu, la'tu beṉguedxliuj? Chutis luj ni rgubeelu sabejṉlu, lagajc si'c cubeezareni luj, lagajc xcuent ni'c sajclu yäḻguxhtis, sa'csi luj rgubeelu sabejṉlu, lagajcza luj rujnlu lagajc dojḻga. ");
INSERT INTO zawNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Nancheenu sujn Dios yäḻguxhtissa'c loj renani rujn sa' dojḻga. ");
INSERT INTO zawNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Beṉ guedxliuj ni rgubee loj renani rujn dojḻ, luxh sigajcza rujnlu, ¿la rujnlu xhigab sidedcaj gun Dios yäḻguxhtis lojlu xcuent xtojḻlu, ä? ");
INSERT INTO zawNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","O ¿la rbälazlu ni rujn Dios, najcni huenduxh, lacti guroob najc xcäḻrulaslajzni, rapduxhzani pasens? ¿La dilu gan dee najc ni gacnäjlu gusiechlajzlu te guibicajlu lo dojḻ, ä? ");
INSERT INTO zawNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Luxh sa'csi nadduxhlu, di lastoolu guigoodz te gusiechlajzlu, cagutajḻlu yäḻguxhtis ni gaclu che guidzujṉ dxej ni gun Dios yäḻguxhtis loj rebeṉ guedxliuj, ");
INSERT INTO zawNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","siguijx Dios loj tejgatu xcuent dzuun nani bejn tejgatu. ");
INSERT INTO zawNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Loj rebejṉ nani rlajztisreni guibaṉsa'c, ni gusoob xtiidxni, sudeed Dios yäḻnabajṉ par tejpas sa'csi gudiilreni xhaniduj näjza go'preni xpala'nreni loj Dios, rlajzreni guibajṉreni loj Dios par tejpas. ");
INSERT INTO zawNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Luxh sidxe'ch Dios, sidxe'chduxhni loj renani sanälajz lagajc laareni, nani di jiu xtidxguliini, alga rusoobreni reyäḻlatsiaj, redidxguijdx. ");
INSERT INTO zawNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Guiraa rebeṉ guedxliuj ni rujn dojḻ sidejd trabajwduxh näjza sac-huin lastooreni; ganid rexpeṉ Israel, dxejcti näjza rebeṉ griegw. ");
INSERT INTO zawNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Loj guiraa rebejṉ nani rujn cos-hueen, sudeed Dios xhaniduj, näjza bala'ṉ, näjza yäḻrbecdxi lastooreni, ganid rexpeṉ Israel, dxejcti näjza rebeṉ griegw. ");
INSERT INTO zawNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Sa'csi tebloj najc guiraasi rebejṉ nez loj Dios. ");
INSERT INTO zawNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Guiraa rebejṉ nani bejn dojḻ, luxh direni niembee xleii Dios, sinitlojreni sin leiiga; guiraa reni biembee xleii Dios, lagajc con leiiga sujn Dios yäḻguxhtisreni xcuent xtojḻreni. ");
INSERT INTO zawNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Xhet ganaxdi renani rucuadiajgtis xleii Moisés najc beṉnaya nez loj Dios; rebejṉ ni rusoobpac rexleii toMoisés, reni'c najc beṉnaya loj Dios. ");
INSERT INTO zawNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Yu' xhidal bejṉ ni di gumbee xleii toMoisés, dizareni gac rexpeṉ Israel, rujnreni recos ni caj lo leii. Najnreni xhini'c najc cos sa'c. Ni'cni lagajc xcäriejnreni najc si'c leii par laareni. ");
INSERT INTO zawNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Recossa'c ni rujnreni ruluiloj nezyusa'c ni yu' lastooreni. Xcäriejnreni ruluiloj xhini'c loj guiraa nani rujnreni najc cos sa'c, xhini'c najc dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Guiraa recosre sajc che guidzujṉ dxej ni gun Dios yäḻguxhtis guiraa rexhigabxhiga'tz ni yu' lastoo rebejṉ. Jesucrist gac juejz lojreni, dxejc sisiojb guiraa rediidx ni cagusule'ä lojtu. ");
INSERT INTO zawNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Luj ni laalu xpeṉ Israel, ni rniilu sanäpaclu xleii toMoisés, rniduxhlu najclu xpeṉ Dios, ");
INSERT INTO zawNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","rniilu nancheezalu xhini'c rlajz Dios gunlu, anajnzalu xhini'c najc hueenru sa'csi bisiedsa'cpaclu leii. ");
INSERT INTO zawNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Rchalolu sajc guluiilu nezyusa'c lo rebejṉ nani najc si'c lotiä'p, sajc guzanijlu xcäriejn reni nacäjy xcäriejnreni. ");
INSERT INTO zawNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Rchalolu najclu mastr lo renani nayääl, najczalu mastr lo rebiuux, sa'csi nansa'clu leii, luxh lojni caj guiraa yäḻnajn näjza guiraa didxguliipac. ");
INSERT INTO zawNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Ni'cni rniä lojlu, luj ni caguseed xtee bejṉ, ¿xhicuent dilu guseed lagajc luj? Luj ni rusule'lu diidx na'c cuan bejṉ, ¿xhicuent rbajnlu? ");
INSERT INTO zawNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Luj nani rniilu na'c guesnäjni te ni di gac chäälni, ¿la resnäjlu nani di gac chäällu, ä? Rdxe'chlu xcuent rebanäjb, ¿xhicuent rbäälu xhicos neṉ xquidoo rebanäjb, ä? ");
INSERT INTO zawNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Luj rlajzlu chä'p xpala'nlu sa'csi najnlu leii, ¿la rusanxtujylu Dios sa'csi dilu gusoob xtidx leiiga, ä? ");
INSERT INTO zawNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Bahuii xho rebejṉ nani di gac xpeṉ Israel rniyajreni Dios sa'csi la'tu ditu gusoob xtiidxni, rujntu dojḻ, sigajc ni caj lo xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Palga la'tu chutu bee si'cni caj lo leiiga, palga gusoobtu guiraa diidx ni caj lo leii, laaca. Luxh palga ditu gusoob guiraliipac xtidx leiiga, xlia'si guyu'tu bee, sa'csi rujntu dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ni'cni palga te bejṉ ni di chu beega, luxh rusoobni guirliipac xtidx leiiga, ¿la di gacdi guchaagni cuent najcni si'c te nani yu' beega, ä? ");
INSERT INTO zawNT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Bejṉ nani di chu beega, luxh rililajzni guiraliipac xtidx leiiga, sujnni yäḻguxhtis la'tu sa'csi mase yu'tu beega, luxh nanduxhtu leiiga, ditu gusoob xtidx leiiga, alga rujntu dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Sa'csi xhet guiraadi rebejṉ ni yu' beega najc rexpejṉ Israel, luxh di beega ni ru' bejṉ gun gusoobpac bejṉ xtidx leiiga. ");
INSERT INTO zawNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Najcpac te xpeṉ Israel nani najcni neṉ lastooni, nani yu' bee lastooni, rusoobpacni xtidx Dios xcuent Sprit xtenni, dini gunni sa'csi najctisni costumbr. Dios ni siliä'p xpala'nni, xhet bejṉdi. ");
INSERT INTO zawNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","¿Xhini'c sacnäj te bejṉ najcni te rexpeṉ Israel, ä? O ¿xhi sajc chuni beega? ");
INSERT INTO zawNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","¡Empac sacduxhni! Ganidtoo, sa'csi loj rexpeṉ Israel badeed Dios xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Mase yu' renani di nililajz diidxga, ¿la ni'cni xhet sajcdi diidx ni bia'n Dios loj rexpejṉni, ä? ");
INSERT INTO zawNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","¡Xho gacni si'c! Diostis najc guliipac, guiralii bejṉ rusguee. Scree caj lo xtidx Dios: Lagajc xtiidxlu suluii laaca rujnlu, te che gaclu yäḻguxhtis, nicla tej xtojḻlu di guidxäjl. ");
INSERT INTO zawNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Palga xcäḻlatsiajnu ruluiiru najc Dios huenduxh, ¿xhini'c guiniinu dxejc? Palga gun Dios yäḻguxhtis nurnu, dxejc tednu trabajwduxh, ¿la rujnni latsiaj loonu, ä? (Caniä si'c te beṉ guedxliuj ṉaj.) ");
INSERT INTO zawNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","¡Xho gacni si'c! Paru najcni si'c, ¿xho mood gun Dios yäḻguxhtis loj rebejṉ guedxliuj? ");
INSERT INTO zawNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Paru redidx-xhii ni rniä riliä'pru xpala'n Dios näjza xtidxliini, ¿xhicuent gunni yäḻguxhtis narä si'c te beṉdojḻ? ");
INSERT INTO zawNT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Yu'za bejṉ ni canii didx-xhii, najreni cayäjpnu lo rebejṉ: “Coḻyejn cosguijdx te guiluilojni recoshuen.” Per rebejṉ ni canii si'c sidzujṉ dxej gacreni yäḻguxhtis. ");
INSERT INTO zawNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","¿Dxejca'? ¿La najcnu beṉhuenduxhru lojreni, ä? Dini gac; tebloj abile'cnu yäḻquij xten rexpeṉ Israel con rebejṉ ni di gac xpeṉ Israel, sa'csi guiraareni yu'reni lo dojḻ. ");
INSERT INTO zawNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Si'cni caj lo guijtz: Ruti te beṉsa'c, nicla tejni. ");
INSERT INTO zawNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ruti te bejṉ ni racbee, ruti chu tej nani rguiil Dios. ");
INSERT INTO zawNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Guiragajcreni abirii lo xnejz Dios, teblojsi xhet sajcdireni. Ruti chu tej ni rujn cossa'c, nicla tejni. ");
INSERT INTO zawNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Ro'reni ṟii ganax didxguijdx, najcni si'c te baa ni naxal, rusgueereni con lujdxreni, didxlatsiaj ṟii ro'reni najcni si'c beneṉ ni yu' ro' te bäḻnialajz. ");
INSERT INTO zawNT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Ro'reni entis cague, entis canii didxrdxe'ch lo sa'reni. ");
INSERT INTO zawNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Ni'reni ruxuṉli saxhe' xtiejn sa'reni. ");
INSERT INTO zawNT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Cadrotis rijreni rujnreni latsiaj, ruteedreni sa'reni trabajw. ");
INSERT INTO zawNT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Direni gumbee nezyuj ni ruscuecdxilajz. ");
INSERT INTO zawNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Niclaza guidxelojreni Dios. ");
INSERT INTO zawNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Racbeenu najc rediidx nani caj lo xleii Dios par rebejṉ ni rnibee leii lojreni, te jiäuu ro' guiralii rebejṉ, te guiraa rebeṉ guedxliuj gacbeereni yu' xtojḻreni nez loj Dios. ");
INSERT INTO zawNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Sa'csi mase gusoob bejṉ guira'ti diidx ni caj lo leii, di leiiga gudzucaj xtojḻ bejṉga, sa'csi leiiga najc nani guluii dojḻ ni yu' neṉ lastooni. ");
INSERT INTO zawNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","N̲aj ruluii Dios stee mood guibicaj xtojḻnu, nani di gac mood ni caj lo xleii toMoisés. Luxh galooli gusloj canii Dios xcuent nezyujre, cajni lo reguijtz xten leii näjza lo reguijtz ni bejn rebejṉ nani gunii xtidx Dios galoo. ");
INSERT INTO zawNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Stee mood najc scree: Chutis ni chalilajz xtidx Jesucrist, sajc naya lastooni nez loj Dios; si'c sajc garaliiza nani salilajz, sa'csi tebloj najcnu nez lojni. ");
INSERT INTO zawNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Sa'csi guiralii rebejṉ guedxliuj abanijt lo Dios, direni guiga' guidzujṉreni lo xnezyuj Dios. ");
INSERT INTO zawNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Niluxh balaslajz Dios nuunu, banidxxlia'ni loonu yäḻnabaṉnaya nez loj Dios sa'csi Jesucristis gudijx yäḻguxhtis xten dojḻ che baxhe'ni xtiejnni lo crujz te badzucajni xtojḻnu. ");
INSERT INTO zawNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Baxhaḻ Dios xi'nni, Jesucrist, te cuajni lo crujz nez loj rebejṉ te si'c gudijxni guiraa rextojḻ chutis bejṉ ni rililajz xtidx Dios xcuent xtiejn Jesucrist. Si'c bejn Dios te guluiini xho guibaṉnaya bejṉ lojni. Galoo gojptis Dios pasens rebejṉ, dini niujn yäḻguxhtis rextojḻreni, ");
INSERT INTO zawNT_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","sa'csi acanajn Dios guc gunni yäḻguxhtis redojḻga, te si'c guiluiini xcäḻnayani nez loj guiraa rebejṉ, te Diospac gunnaya nez lojni chutis ni rililajz xtidx Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Ni'cni ¿con yäḻnaro? ¿Con yäḻbindaan? ¡Xhet sajcdini! ¿Xhi leii rudzucaj xtojḻnu? ¿La leii najc ni rnii jiennu dzunsa'c, ä? ¡Dini gac si'c! Yu' tejtis leii ni rudzucaj dojḻ, nani rnii chalilajztis bejṉ xtidx Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Dxejc sajc guiniä lojtu chutis bejṉ sajc gac naya nez loj Dios sa'csi rililajzni xtidx Jesucrist, xhet sa'csi rujnni redzunsa'c ni caj lo leii. ");
INSERT INTO zawNT_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","¿La najc Dios Xtiooztis rexpeṉ Israel, ä? ¿La dini gac näjza Dios xten rebejṉ ni di gac xpeṉ Israel? ¡Xho dini gac! Najcni Dios xten guirop cuaa bejṉ. ");
INSERT INTO zawNT_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Ruti chu stee Dios, tejtis Dios yu'. Rusḻaani lo dojḻ rebejṉ ni guyu' bee sa'csi huililajzreni xtiidxni, sigajcza rusḻaani lo dojḻ rebejṉ ni xhet beedi guyu' sa'csi huililajzzareni xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","¿La rudzucajnu leii sa'csi rililajznu, ä? Ajndi. ¡Xho gacni si'c! Alga basoobnu xtidx leiiga che huililajznu xtidx Jesucrist. ");
INSERT INTO zawNT_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","¿Xhini'c sajc guiniinu xcuent toxtadgoldoonu, Abram? ");
INSERT INTO zawNT_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Paru niajc toAbram beṉnaya nez loj Dios por redzuun ni bejnni, pet sajc guibalazduxhni, per xhet nez lojdi Dios. ");
INSERT INTO zawNT_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","¿Xhini'c caj lo xtidx Dios? Caj rediidxre: Huililajz toAbram xtidx Dios, ni'c bachaag Dios cuent najcni te beṉnaya nez lojni. ");
INSERT INTO zawNT_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Meel nani rca' te bejṉ ni rujn te dzuun, meelga najc ni riäjl xca'ni, xhet rcaxlia'dinini. ");
INSERT INTO zawNT_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Luxh nani rililajztis xtidx Dios ni rusḻaa bejṉ lo dojḻ, lacuaa naani yu' xhi dzuun sajc gunni te guibicaj xtojḻni, bejṉga najc te beṉnaya nez loj Dios, sa'csi huililajzni xtiidxni. ");
INSERT INTO zawNT_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Sigajcza naj toDavid, chicbaa bejṉ nani ruchaag Dios cuent najcni te beṉnaya luxh di niquiin niujnni redzuun ni caj lo leii. Räjpni: ");
INSERT INTO zawNT_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Chicbaa renani abasḻaa Dios lo xtojḻreni, renani abiäuu loj xtojḻreni. ");
INSERT INTO zawNT_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Chicbaa bejṉ nani diru Dios gun cuent xtojḻni. ");
INSERT INTO zawNT_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","¿La sajc guiniini chicbaa rebejṉtis nani guyu' bee, ä? ¿La et näjdiza renani di niu' bee, ä? Sa'csi rniinu: “ToAbram gujc te beṉnaya nez loj Dios sa'csi huililajzni xtidx Dios.” ");
INSERT INTO zawNT_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Guc bidxaag cuent najcni te beṉnaya nez loj Dios ¿che gajdni chu bee, ä? O ¿Laa che guyu'ni bee? Bidxaagpac xcuentni che gajdni chu bee. ");
INSERT INTO zawNT_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Dxejcti guyu'ni bee si'c te seen xten yäḻnaya sa'csi huililajzni xtidx Dios che gajdlini chu bee te gacni xtad guiraa renani rililajz laḻ ni xhet beedi yu'reni, te näjza laareni guidxaag cuent najcreni beṉnaya nez loj Dios, ");
INSERT INTO zawNT_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","te gaczani xtad guiraa renani yu' bee ni huililajzza xtidx Dios si'c huililajz toAbram cheni gajdni chu bee. ");
INSERT INTO zawNT_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Bia'n Dios diidx loj toAbram näjza loj rexagdooni, xca'ni guedxliujre si'c yäḻnasa'c xtenni. Xhet sa'csi gusoobni xtidx leii xca'nini, sica'nini sa'csi najc toAbram te beṉnaya nez loj Dios sa'csi huililajzni xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Sa'csi paru renani rusoob xtidx leiiga najc nani xca' yäḻnasa'cga, xlia'si chalilajz bejṉ xtidx Jesucrist, luxh xhetza sajcdi diidx nani bia'n Dios loj toAbram. ");
INSERT INTO zawNT_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Che yu' te leii, luxh yu' chu di gusoobni, dxejc rdxe'ch Dios loj bejṉ. Cadro xheti leii, xhetiza xtojḻreni. ");
INSERT INTO zawNT_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Ni'cni balaslajz Dios nuunu, te sudzu'tz diidx ni bia'nni loj toAbram, te guiraa rexagdooni ni rililajz sica' yälnasa'c, xhet xtebtis renani sasanäj xleii toMoisés, nägajcza renani rililajz xtidx Dios si'c huililajz toAbram, nani najc xtad guiraanu nani chalilajz xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Si'cza caj lo xtidx Dios, caj rediidxre: “Abenä gaclu xtad xhidal renacióṉ.” Si'c bia'n Dios diidx loj toAbram, Gueb Dios nani gudeed yäḻnabajṉ loj rebeṉgut, nani rnii xcuent recos nani gajd gac ascanu ala najcni. ");
INSERT INTO zawNT_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Anajn toAbram naganduxh soob diidx ni bia'n Dios con laani, luxh laani empac huililajzni, ni'c gujcni xtad xhidajl nacióṉ, te gusojb xtidx Dios ni guniini che räjpni: “Scree gac xhidajl rexagdoolu.” ");
INSERT INTO zawNT_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Di toAbram nunijt xcäḻrililajzni, mase ayu'ni tegayuu ijz, najnni anajcni beṉgool, luxh sigajcza Sara abeṉgool diru xi'nreni chu. ");
INSERT INTO zawNT_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Dini niun-tio'p lajzni xcuent rediidx nani bia'n Dios con laani, alga gusutijpruni huililajzni xtiidxni, gulä'pni xpala'n Dios, badeedni xquixtios lojni. ");
INSERT INTO zawNT_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Anajnni rajp Dios yäḻrnibee te gunni guiralii nani bia'n diidx gunni. ");
INSERT INTO zawNT_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ni'c bachaag Dios cuent najcni te beṉnaya nez lojni sa'csi huililajzni xtidx Dios. ");
INSERT INTO zawNT_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Xhet xtebtisdi xcuent toAbram cuaj rediidxre: “Bidxaag cuent najcni te beṉnaya