﻿USE sofia;
DROP TABLE IF EXISTS sofia.zavNT_vpl;
CREATE TABLE zavNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zavNT_vpl WRITE;
INSERT INTO zavNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nga cho'en dižə' c̱he de'e x̱axta'o Jesocristən' dezd gan' gwxete dia c̱he'enə'. Na' nyoɉ la yoguə'əte de'e x̱axta'ogüe' ca' gwzolaozən len de'e x̱axta'ocho Abraanṉə' xte ṉa'a. Jeso'osən' naque' xi'iṉ dia c̱he de'e Rei Dabin', na' de'e Dabin' naque' xi'iṉ dia c̱he de'e Abraanṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraanṉə' naque' x̱a Isaac, na' Isaaquən' naque' x̱a Jacob, na' Jacobən' naque' x̱a Joda len beṉə' biše'e ca' yeḻa'. ");
INSERT INTO zavNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jodan' na' Tamar zɉənaque' x̱axna' Fares na' Sara. Na' Faresən' naque' x̱a Esrom, na' Esronṉə' naque' x̱a Aram. ");
INSERT INTO zavNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aranṉə' naque' x̱a Aminadab, na' Aminadabən' naque' x̱a Naason, na' Naasonṉə' naque' x̱a Salmon. ");
INSERT INTO zavNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonṉə' na' Raab zɉənaque' x̱axna' Boos. Na' Boosən' na' Rot zɉənaque' x̱axna' Obed. Na' Obedən' naque' x̱a Isai. ");
INSERT INTO zavNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Na' Isain' naque' x̱a Rei Dabin', na' Rei Dabin' naque' x̱a Salomon. Na' xna' Salomonṉə' goque' xo'olə de'e Orias antslə ze'e yeca'a Rei Dabin' ḻe' par gaque' xo'ole'. ");
INSERT INTO zavNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Na' Salomonṉə' naque' x̱a Roboam, na' Roboanṉə' naque' x̱a Abias, na' Abiasən' naque' x̱a Asa. ");
INSERT INTO zavNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Na' Asan' naque' x̱a Josafat, na' Josafatən' naque' x̱a Joram, na' Joranṉə' naque' x̱a Osias. ");
INSERT INTO zavNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Na' Osiasən' naque' x̱a Jotam, na' Jotanṉə' naque' x̱a Acas, na' Acasən' naque' x̱a Esequias. ");
INSERT INTO zavNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Na' Esequiasən' naque' x̱a Manases, na' Manasesən' naque' x̱a Amon, na' Amonṉə' naque' x̱a Josias. ");
INSERT INTO zavNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiasən' naque' x̱a Jeconias na' biše'e ca'. Beṉə' ca gwnitə' ca tyempən' catə' beṉə' Babilonia ca' besyə'əc̱he'ex̱ax̱ɉe' de'e x̱axta'o chio'o beṉə' Izrael Babilonian'. ");
INSERT INTO zavNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Gwde besyə'əc̱he'ex̱ax̱ɉe' ḻega'aque' Babilonian', golɉə Salatiel xi'iṉ Jeconiasən'. Na' Salatielən' naque' x̱a Sorobabel. ");
INSERT INTO zavNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Na' Sorobabelən' naque' x̱a Abiod, na' Abiodən' naque' x̱a Eliaquim. Na' Eliaquinṉə' naque' x̱a Asor. ");
INSERT INTO zavNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asorən' naque' x̱a Sadoc, na' Sadoquən' naque' x̱a Aquim. Aquinṉə' naque' x̱a Eliod. ");
INSERT INTO zavNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Na' Eliodən' naque' x̱a Eleasar, na' Eleasarən' naque' x̱a Matan. Na' Matanṉə' naque' x̱a Jacob. ");
INSERT INTO zavNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Nach Jacobən' naque' x̱a Jwse ben' naquə be'en c̱he Marian'. Na' Marian' naque' xna' Jeso'os ben' nzi' Crist, zeɉe dižə' ben' gwleɉ Diozən' par gaquəlene' beṉac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Na' tyemp c̱he de'e Abraanṉə' xte tyemp c̱he de'e Dabin' goc žda' dia c̱he'enə'. Na' goszolaon tyemp c̱he de'e Dabin' xte catə'ən beṉə' Babilonia ca' besyə'əc̱he'ex̱ax̱ɉe' de'e x̱axta'o chio'o beṉə' Izrael Babilonian' gozac yežda' dia c̱he'enə'. Na' ḻeczə dezd tyemp catə'ən besyə'əc̱he'ex̱ax̱ɉe' ḻega'aque' Babilonian' xte catə'ən bžin žan' golɉə Cristən' gozac yežda' dia c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Na' quingan' goquə catə'ən golɉə Jesocristən'. Banaquən gwšagna' Marian' len Jwsen', na' ze'e ca'a Jwsen' ḻe' par gaque' xo'ole', gwsa'acbe'ine' banoa' Marian' bdao'. Goc ca' c̱hedə' Spirit c̱he Diozən' benən par nic̱h bgüendao' bda'onə' ḻo'o ḻe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Na' Jwsen' ben' banaquən si'e Marian' par gaque' xo'ole', goque' to beṉə' chon de'e güen lao Diozən'. De'e na'anə' bene' xbab cueɉyic̱hɉe' Marian' šižizə sin cui no gacbe'i par nic̱h cui əgwsi'e ḻe' zto'. ");
INSERT INTO zavNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Žlac chone' xbab gone' ca', to angl c̱he X̱ancho Diozən' blo'elaogüe'e ḻe' lao bišgal. Na' gože'ene': —Jwse, le' naco' xi'iṉ dia c̱he de'e Dabin'. Bito žebo' si'o Marian' par gaque' xo'olo'. Spirit c̱he Diozən' benən par nic̱h no'e bda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Na' sane' to bi'i byo, na' əgwsi'o labo' Jeso'os c̱hedə' yebeɉe' beṉə' gwlaž c̱hele ca' xni'a de'e malən' beṉə' se'eɉḻe' c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Na' de'en goquə yoguə' de'e ca' goc complir can' gwna Diozən' de'en bzoɉ to profet beṉə' be' xtižə' Diozən' cana', gwne': ");
INSERT INTO zavNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","To no'ol güego' beṉə' ṉenaplažə'əchgua cuine' güe'e to bi'i byo dao' na' sane'ebo'. Na' si' labo' Emanuel. Na' Emanuel zeɉe dižə': Zoczə Diozən' len chio'o. ");
INSERT INTO zavNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Na' catə' beban Jwsen' beyož gwneine' yelən' ca', beteyo bene' can' gož angl c̱he X̱ancho Diozən' ḻe'. Ɉəx̱i'e Marian' liže'enə' par goque' xo'ole'. ");
INSERT INTO zavNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero Jwsen' gwdapəcze' ḻe' respet xte catə'ən gwxane' to bi'i byo dao', xi'iṉe' nech. Na' gwxi' labo' Jeso'os. ");
INSERT INTO zavNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ca tyemp can' gwnabia' Rei Erodən', golɉə Jeso'osən' Belenṉə', to yež gan' mbane Jodean'. Na' goquən' besə'əžin to c̱hopə magos Jerosalenṉə', beṉə' za'ac galən' chla' bgüižən'. ");
INSERT INTO zavNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Na' gosə'əṉabene' beṉə' lao' syodan' gwse'e: —¿Gan' rei c̱he beṉə' Izrael ca', be'en bagolɉənə'? Ṉezeto' bagolɉe'enə' c̱hedə' bable'ito' belɉw c̱he'enə' catə'ən bla'an lažto'onə' galən' chla' bgüižən'. Na' za'ato' par nic̱h güe'ela'oto'one'. ");
INSERT INTO zavNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Catə' bene Rei Erodən' xtižə'əga'aque'enə', de'e juisy de'e goquene', na' ḻeczə ca' yoguə'əḻoḻ beṉə' lao' syoda Jerosalenṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nach btob Rei Erodən' yoguə'əḻoḻ bx̱oz əblao c̱he chio'o beṉə' Izrael na' ḻeczə yoguə' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən', con beṉə' nitə' syodan'. Na' gwṉabene' ḻega'aque' gan' naquən galɉə Cristən' ben' gwleɉ Diozən' par gaquəlene' ṉasyon c̱hechon'. ");
INSERT INTO zavNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nach gwse' beṉə' ca' Erodən': —Belen nan' galɉe', gan' mbane Jodea, la' can' na to part Xtižə' Diozən' de'en bzoɉ to profet beṉə' be' xtiže'enə' cana'. Quinga nan: ");
INSERT INTO zavNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ca naquə yež Belen gan' mbane Jodea, naquəczən yež de'e zaquə'əchgua entr yež əblao ca' de'en zɉəchi' Jodean', c̱hedə' to beṉə' Belenṉə' gaque' beṉə' gwnabia', na' ḻe' əggüia əgwye' chio'o beṉə' Izrael. ");
INSERT INTO zavNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nach Erodən' bene' mendad ɉa'ac magos ca' laogüe'enə' bgašə'əzə par nic̱h gwṉabene' ḻega'aque' tcho'a tšao' batə'əquən' besə'əle'ine' bla' belɉon'. ");
INSERT INTO zavNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nach bseḻe'e ḻega'aque' Belenṉə', gože' ḻega'aque': —Ḻe'e žɉa'ac Belenṉə' na' ḻe'e žɉəyedilɉyožə bida'onə'. Na' catə' yeželelebo' na' deyedix̱ɉue'ile nada' par nic̱h ḻeczə ša'a əžɉe'ela'ogua'abo'. ");
INSERT INTO zavNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Beyož boso'ozenag magos ca' can' gož rein' ḻega'aque', nach gwsa'aque' əzɉa'aque'. Na' ca naquə belɉon' de'en besə'əle'ine' gan' chla' bgüižən' catə' cuiṉə' sa'ac lažga'aque'enə', zdan ḻe'e yoban' žialaon laoga'aque'enə' bžinten gwzon gan' zo bida'onə', na' gwlezən. ");
INSERT INTO zavNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Na' besyə'əbeine' xte juisy ca de'en besə'əle'ine' belɉon' de'e yoblə. ");
INSERT INTO zavNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nach catə' gwso'e ḻo'o yo'onə' na' besə'əle'ine' bida'onə' len xna'abo' Marian'. Nach bosə'əzo xibga'aque' gwso'elaogüe'ebo'. Na' bosə'əsalɉo caj c̱hega'aque' ca' na' gosə'əbeɉe' or, yal na' to xnižə' yag de'en chla' zix̱ de'en ne' mirra par gwso'ebo'on. ");
INSERT INTO zavNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pero na' Diozən' gwdix̱ɉue'ine' magos ca' lao bišgal de que bito yesyə'ədie' gan' zo Rei Erodən'. De'e na'anə' besyə'əque'e yetolə nez par ɉəya'aque' lažga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Na' catə' babesa'ac magos ca', to angl c̱he X̱ancho Diozən' bloe' laogüe' Jwsen' lao bišgal, na' gože'ene': —Gwyas, gwc̱he' bida'onə' na' xna'abo'onə' ḻe'e žɉa'ac Egipton' na' sole xte catə'əch əṉia' le'e batə'əquə' guaquə yesa'acle, c̱hedə' Erodən' banži'e bia' yeyilɉe' bida'onə' par gote'ebo'. ");
INSERT INTO zavNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nach ṉencal gwyas Jwsen', gwc̱he'e bida'onə' len xna'abo'onə' zɉa'aque' Egipton'. ");
INSERT INTO zavNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nach gwnite'e Egipto na'azə xte catə'əch got Erodən'. Na' de'en gwso'one' ca' goc complir de'en bzoɉ to profet beṉə' be' xtižə' Diozən' cana'. Quinga bzoɉe' de'en gwna X̱ancho Diozən': “C̱hix̱ɉue'ida' Xi'iṉa'anə' yeze'e Egipton'.” ");
INSERT INTO zavNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Na' lao bazɉa'aque' Egipton' Erodən' ḻechguaḻe bžeɉene' catə' gocbe'ine' gosə'əx̱oayag magos ca' ḻe' de'en cuich besyə'ədie' gan' zo'enə'. Na' segon can' gwyeɉni'ine' catə' gwṉabene' ḻega'aque' antslə do batə'əquən' bla' belɉon', bseḻe'e soḻdad c̱he' ca' par ɉse'ete' yoguə'əḻoḻ bi'i byo che'eṉ dao' zelao bi'i c̱hop ize, bi'i ca' gwsa'alɉə Belenṉə' na' yeziquə'əchlə yež ca' zɉənyec̱hɉ zɉəmbi'i Belenṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Na' laogüe de'en gwso'ote' bi'i byo dao' ca', goc complir can' bzoɉ de'e profet Jeremiasən', ben' be' xtižə' Diozən' cana', gwne': ");
INSERT INTO zavNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Gaquə bgüine bgüežən' yež de'en nzi' Rama. No'ol ca' zɉənaquə xi'iṉ dia c̱he de'e Raquelən' ḻechguaḻe yesyə'əyašə' yesyə'əgüinḻaže'e c̱he yoguə' xi'iṉda'oga'aque' ca' əsa'at. Na' bito se'enene' par no yeyo'exen ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Lao ṉe'e nitə' Jwse ca' Egipton' got Erodən'. Nach to angl c̱he X̱ancho Diozən' bloe' laogüe' Jwsen' lao bišgal. ");
INSERT INTO zavNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Na' gože'ene': —Gwyas, bec̱he' bida'onə' len xna'abo'onə' na' ḻe'e žɉəya'ac Izraelən'. Bagwsa'at beṉə' ca' besyə'əyilɉ bida'onə' par so'ote'ebo'. ");
INSERT INTO zavNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nach gwyas Jwsen' bec̱he'e bida'onə' len xna'abo'onə' ɉəya'aque' lažga'aque' Izraelən'. ");
INSERT INTO zavNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero Jwsen' catə' benene' de que Arquelaon' bedie' belane' xlatɉə de'e x̱e' Erodən', bžebe' žɉəya'aque' gan' mbane Jodean'. Na' Diozən' gwdix̱ɉue'ine' ḻe' lao bišgalən' de que bito žɉəya'aque' Jodean' sino que žɉəya'aque' gan' mbane Galilean'. ");
INSERT INTO zavNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","De'e na'anə' besyə'əžine' syoda Nasaretən' na' ɉəsyə'ənite'e. Na' de'en ɉəsyə'ənite'e Nasaretən' goc complir de'en boso'ozoɉ de'e profet ca' cana' gosə'əne' c̱he Jeso'osən' de que beṉə' yesə'əsi'ene' beṉə' Nasaret. ");
INSERT INTO zavNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na' gwde zan iz, Juan ben' bc̱hoa beṉə' nis gwyeɉe' latɉə dašən' gan' mbane Jodean'. ");
INSERT INTO zavNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Na' gwdix̱ɉue'ine' beṉə' gože' ḻega'aque': —Ḻe'e yediṉɉe xtoḻə'əle ca', c̱hedə' babžin ža catə' Diozən' ben' zo yoban' ṉabi'e con notə'ətezə beṉə' əso'e latɉə. ");
INSERT INTO zavNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","De'e profet Isaiazən' ben' be' xtižə' Diozən' cana' bzoɉe' c̱he Juanṉə', gwne': To beṉə' əṉe' zižɉo latɉə dašən', əne': “Ḻe'e so probnid par əgwzenagle c̱he X̱anchon' catə'ən yide'. Na' šə sole probnid par əgwzenagle c̱he' catə'ən yide', de'en gonḻe ca' gwxaquə'əleben can' chonḻe chxi' chloale nez ca' catə' chidə to beṉə' blao.” ");
INSERT INTO zavNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Na' Juanṉə' gwyaze' lachə' de'en gwso'one' len yišə' xa cameyən'. Na' par dobey c̱he' bc̱hine' to pedas yid. Na' gwdaogüe' bišə'əzo, na' ḻeczə gwdaogüe' ši'in bia ser, bia nitə' yix̱ə'. ");
INSERT INTO zavNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Beṉə' Jerosalenṉə', na' beṉə' ca' ža' yoguə' yež ca' gan' mbane Jodean', na' ḻeczə beṉə' ža' yež ca' nyec̱hɉ mbi'i yao Jordanṉə' gwsa'aque' ɉa'aque' gan' zo Juanṉə' par boso'ozenague' xtiže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Na' bosə'əx̱oadoḻe'e lao Diozən', na' Juanṉə' bc̱hoe' ḻega'aque' nis ḻo'o yao Jordanṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Na' ḻeczə ɉa'ac zan beṉə' Izrael beṉə' ca' zɉənchoɉ zɉənzi' fariseo, na' beṉə' ca' zɉənzi' sadoseo. Ɉa'aque' par bc̱hoa Juanṉə' ḻega'aque' nis, Nach Juanṉə' gože' ḻega'aque': —Le'e nacle beṉə' gox̱oayag na' nalɉele. ¿Echaquele de que guaquə yexoṉɉele castigon' de'en əseḻə' Diozən' par le'e? ");
INSERT INTO zavNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Cheyaḻə' gonḻe de'en naquə güen par nic̱h əsa'acbe'i beṉə' yoblə de que baboša' yic̱hɉla'ažda'olen'. ");
INSERT INTO zavNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Na' bito gonḻe xbab de que Diozən' bito gone' le'e castigw c̱he xtoḻə'əlen' laogüe de'en nacle xi'iṉ dia c̱he de'e Abraanṉə'. Bito ṉacho de que ḻechguaḻe chyažɉe Diozən' le'e. Guaquə gone' par nic̱h yeɉ quinga yesyə'əyaquən xi'iṉ dia c̱he de'e Abraanṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ca naquə le'e šə cui chonḻe can' chazlažə' Diozən', gwxaquə'əlebele ca to yag frot de'e cui bi frot chbian. Na' ca naquə yoguə'əte yag frot de'e cui bi frot chon, chəsə'əc̱hog beṉə' ḻen na' chəsə'əzeye'en. ");
INSERT INTO zavNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Na' ca naquə le'e chediṉɉele xtoḻə'əle ca', nada' de'e ḻi chc̱ho'a le'e nis. Na' ze'e yidə ben' gon par nic̱h so Spirit c̱he Diozən' ḻo'o yic̱hɉla'ažda'ochon' na' ṉabi'an chio'o. Na' Spiritən' naquən ca yi' na' gwxi' gwloan yic̱hɉla'ažda'ochon' len bitə'ətezə de'e mal. Ben' yidə zaquə'əche' ca nada' na' bito zaca'a par gaca' xmose'. ");
INSERT INTO zavNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Be'enan' gone' len chio'o can' choncho catə' chdecho trigon' rner, na' chzeycho yix bebən'. Na' šə chonḻilažə'əcho Diozən', yotobe' chio'o par nic̱h socho txen len ḻe', na' beṉə' ca' cui chso'onḻilažə' ḻe', əseḻe'e ḻega'aque' lao yi' gabiḻən' de'en cuiczə cheyol. ");
INSERT INTO zavNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Na' gwza' Jeso'osən' gan' mbane Galilean' na' gwyeɉe' gan' zo Juanṉə' cho'a yao Jordanṉə' par nic̱h Juanṉə' bc̱hoe' ḻe' nis. ");
INSERT INTO zavNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Na' Juanṉə' benczə yic̱hɉlaogüe' caguə gone'ene' gwc̱hoe' Jeso'osən' nis. Gože'ene': —Chyažɉləda' əgwc̱ho' nada' nisən' na' nadə'əlan' zedeṉabdo' gwc̱hoa' le' nisən'. ");
INSERT INTO zavNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nach Jeso'osən' gože' Juanṉə': —Gone'e bc̱hoa nada' nisən'. Cheyaḻə' goncho ca' par nic̱h gaquə complir yoguə'əḻoḻ de'en non Diozən' mendad gaquə. Nach gwc̱heb Juanṉə' bc̱ho'ene' nisən'. ");
INSERT INTO zavNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Na' catə' beyož gwchoa Jeso'osən' nisən', ḻe'e bechoɉte' ḻo'o nisən', na' ḻe'e byalɉwte ḻe'e yobanə' na' ble'i Jeso'osən' gan' zo Diozən'. Ble'ine' Spirit c̱he Diozən' betɉən ca to ngolbexə na' bžinən gwzon len ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Na' gwse'enene' gwna Diozən' ben' zo yoban': —Bengan' Xi'iṉa', ben' chacda' c̱hei, ḻechguaḻe cheba chezaquə'əlaža'a ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Na' Spirit c̱he Diozən' benən par nic̱h gwyeɉ Jeso'osən' latɉə dašən', par nic̱h gwlo'oyeḻə' gwxiye'enə' ḻe' gone' de'e malən'. ");
INSERT INTO zavNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Na' bitobi gwdao Jeso'osən' lao c̱hoa ža c̱hoa yel, na' catə' gwde de'e c̱hoa žanə' gwdone'. ");
INSERT INTO zavNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Na' gwxiye'enə' bgüiguə'ən gan' zo Jeso'osən', gožə'ən ḻe': —Šə len' naco' Xi'iṉ Diozən', gož yeɉ quinga yesyə'əyaquən yetxtil. ");
INSERT INTO zavNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nach gož Jeso'osən' ḻen: —Nyoɉczə Xtižə' Diozən' nan: “Caguə yeḻə' guao na'azən' əbane chio'o beṉac̱h sino ḻeczə chyažɉecho yoguə'əḻoḻ dižə' de'en na Diozən' par əbancho.” ");
INSERT INTO zavNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Na' gwc̱he' gwxiye'enə' ḻe' yic̱hɉo' yo'odao' əblao c̱he chio'o beṉə' Izrael de'en zo Jerosalenṉə' na' gwlequən ḻe' gan' ḻe'ezelaogüe naquə sibə. ");
INSERT INTO zavNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Na' gožən ḻe': —Šə len' naco' Xi'iṉ Diozən' bexitə' nga par che'elə, la' nyoɉczən ḻe'e Xtižə' Diozən' nan: Eseḻə' Diozən' angl c̱he' ca' par əsa'aclene' le', na' əso'ox̱e'e le' par nic̱h bito əc̱hego'o no yeɉ. ");
INSERT INTO zavNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Na' gož Jeso'osən' gwxiye'enə': —Ḻeczə can' nyoɉən ḻe'e Xtižə' Diozən', nan: “Bito con goncho X̱ancho Diozən' prueb šə ḻeine' can' ne'enə'.” ");
INSERT INTO zavNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Na' gwxiye'enə' gozc̱he'en ḻe' to lao ya'a de'e naquə ḻechguaḻe sibə, na' blo'in ḻe' yoguə' ṉasyon de'en zɉəchi' lao yežlyon' ca naquə dechgua yeḻə' chnabia' c̱hega'aquənṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nach gožən ḻe': —Yoguə' de'e quinga chle'ido' nga goṉa'an le' šə gwzo xibo' laogua' nga par güe'elaogo'o nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nach gož Jeso'osən' ḻen: —Gwchi'ižə' ca'aḻə nga Satanas. Nyoɉczən ḻe'e Xtižə' Diozən' nan: “Cheyaḻə' šeɉṉi'alažə'əcho tozə X̱ancho Diozən' na' tozə ḻe' güe'ela'ocho.” ");
INSERT INTO zavNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Na' bebi'ižə' gwxiye'enə len ḻe', nach besə'əžin baḻə angl ca' ɉse'eclene'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Na' Jeso'osən' gwze'e Jodean' par gwyeɉe' Galilean' catə' benene' de que bade Juanṉə' ližyan'. ");
INSERT INTO zavNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Na' gwze'e Nasaretən' ɉsoe' syoda Capernaum de'en chi' cho'a nisda'onə' do gan' chi' distrit de'en nzi' Sabolon na' Neftali. ");
INSERT INTO zavNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Na' de'en ɉəyezoe' syodan' goc complir can' bzoɉ de'e profet Isaiazən', ben' be'e Xtižə' Diozən' cana' gan' nan: ");
INSERT INTO zavNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ḻe'e gwzenag, le'e beṉə' Galilea, le'e cui nacle beṉə' Izrael, na' nitə'əle distrit Sabolon na' Neftali de'en mbane yešḻa'alə nisda'onə' na' yao Jordanṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nc̱hoḻ yic̱hɉla'ažda'olen' pero Diozən' əseḻe'e to beṉə' cue'e be'eni' xen ḻo'o yic̱hɉla'ažda'olen'. Nacle ca beṉə' guat len yic̱hɉla'ažda'olen' por ni c̱he de'e malən' chonḻe, pero be'enə' əseḻə' Diozən' yocobe' yic̱hɉla'ažda'olen'. ");
INSERT INTO zavNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Na' dezd tyemp na', Jeso'osən' gwzolao gwdix̱ɉui'e gwne': —Ḻe'e yediṉɉe xtoḻə'əlen', c̱hedə' babžin ža ṉabia' Dioz ben' zo yoban' con notə'ətezə beṉə' əso'e latɉə. ");
INSERT INTO zavNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Na' goquən' lao zda Jeso'osən' cho'a Nisdao' Galilean' ble'ine' c̱hopə beṉə' gwxen beḻ, choso'ozaḻe'e yix̱ɉw beḻ c̱hega'aque'enə' ḻo'o nisən'. Zɉənaquə c̱hopə biše'e. Toe' le' Simon Bed, na' yetoe' Ndres. ");
INSERT INTO zavNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nach gože' ḻega'aque': —Ḻe'e da len nada'. Le'e nacle beṉə' gwxen beḻ, na' ṉa'a əgwzeɉni'ida' le'e par nic̱h gonḻe ca so'ombia' beṉə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Na' ḻe'e gosə'əbeɉyic̱hɉtega'aque' yix̱ɉw beḻ c̱hega'aque' ca' nach ɉa'aclene' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nach gwsa'aque' yelatə' na' ɉəsyə'ədi'e Jacob len Juan c̱hopə biše'e, len x̱aga'aque' Sebedeo. Že'e to ḻo'o barcw chesyə'əyone' yix̱ɉw beḻ c̱hega'aque'enə'. Na' ḻeczə gwṉabe Jeso'osən' Jacobən' len Juanṉə' par žɉa'aclene' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Na' ḻe'e bosyo'ocua'aṉlentie' x̱aga'aque' Sebedeon' barcon' na' ɉa'aclene' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Na' gozac catə' Jeso'osən' gwyeɉe' yoguə' yež ca' zɉəchi' gan' mbane Galilean', gwzolaogüe' bsed blo'ine' beṉə' ca' zɉəža' ḻo'o yo'odao' ca' gan' gwso'elao' beṉə' Izrael ca' Diozən'. Na' gwdix̱ɉui'e dižə' güen dižə' cobən' de que Diozən' ṉabi'e con notə'ətezə beṉə' əso'e latɉə. Na' Jeso'osən' beyone' yoguə' beṉə' ca' chse'i gwde gwde yižgüe'. ");
INSERT INTO zavNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Na' gosə' gwlalɉə yoguə' de'en ben Jeso'osən' doxenḻə ṉasyon Siria. Nach beṉə' Siria ca' ɉso'e yoguə' beṉə' ca' chsa'acšene laogüe'enə', beṉə' ca' chse'i zan cḻas yižgüe' na' beṉə' ca' chse'ey chesə'əla, na' len beṉə' ca' zɉəyo'o zɉəyaz de'e x̱io' yic̱hɉla'ažda'oga'aque', na' len beṉə' ca' chsa'az šon, na' beṉə' ca' zɉənat to part cuerp c̱hega'aque'enə'. Na' beyone' yoguə'ətega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Na' zan beṉə' za'ac distrit c̱he Galilea, na' beṉə' za'ac yež ca' gan' nzi' Decapolis, na' beṉə' za'ac syoda Jerosalenṉə', na' beṉə' za'ac yež ca' yeḻa' distrit c̱he Jodea, nach beṉə' za'ac yešḻa'a yao Jordanṉə' ɉəsə'ənaogüe' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Na' Jeso'osən' catə' ble'ine' beṉə' zan zɉənžag, gwloe' gwchi'e to lao ya'a. Na' gosə'əbiguə' disipl c̱he' ca' gan' chi'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nach gwzolao bsed blo'ine' ḻega'aque', gwne': ");
INSERT INTO zavNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Le'e chacbe'ile de que chyažɉele gaquəlen Diozən' le'e, zole mbalaz c̱hedə' bacho'ele latɉə chnabia' Diozən' le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Na' le'e zole trist ḻo'o yic̱hɉla'ažda'olen' por ni c̱he xtoḻə'əle ca', mbalaz sole c̱hedə' Diozən' yeyonxenḻaže'e le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Na' le'e laogüe de'en chzex̱ɉw yic̱hɉle len Diozən' na' len beṉac̱hən', mbalaz sole c̱hedə' Diozən' gone' par nic̱h gaquə güen c̱hele can' baben Diozən' lyebe. ");
INSERT INTO zavNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Na' le'e chzelažə'əchguale gacle beṉə' güen lao Diozən', zole mbalaz c̱hedə' Diozən' bachaclene' le'e par nic̱h gacle beṉə' güen laogüe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Na' le'e cheyašə'əlažə'əle beṉə' yoblə, mbalaz zole c̱hedə' ḻeczə ca' Diozən' cheyašə' cheži'ilaže'e le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Na' le'e banacle beṉə' la'aždao' xi'ilažə', zole mbalaz c̱hedə' žɉəyezole txen len Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Na' le'e chogo'ole yeḻə' chxenḻažə' c̱he beṉə' lɉuežɉle ca' chesə'ədiḻə, mbalaz zole c̱hedə' la' Diozən' bagwcue'e le'e ca xi'iṉe'. ");
INSERT INTO zavNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Na' le'e choso'oc̱hi' choso'osaquə' beṉə' le'e laogüe de'e chontezle de'en naquə güen lao Diozən', zole mbalaz c̱hedə' cho'ele latɉə chnabia' Diozən' le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Na' catə' chesə'əzi'ic̱hižə' beṉə' le'e na' chesə'əsaquə'əzi'e le'e na' chso'e yoguə' cḻaste dižə' güenḻažə' contr le'e por ni c̱he de'en chonḻilažə'əle nada', bia'aczə sole mbalaz. ");
INSERT INTO zavNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Cheyaḻə' yeba yezaquə'əlažə'əchguale ḻa'aṉə'əczə za'ac de'e ca' contr le'e c̱hedə' Diozən' gone' par nic̱h gaquəchgua de'e güen c̱hele catə' yežinḻe gan' zoe'enə'. Can' chso'one beṉə' ca' le'e ḻeczə can' gwso'one de'e x̱axta'ocho ca' de'e profet ca' beṉə' ca' gwso'e xtižə' Diozən' cana'. ");
INSERT INTO zavNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ca zedə' chaclenən par nic̱h caguə cuiayi' no yid belə', ḻe'egatezə ca' le'e chaclenḻe par nic̱h beṉac̱hən' cui chso'onteque' de'e mal. Na' šə zedə'ən bitoch bi zxi' naquən, ṉezecho bito bi gac goncho par nic̱h yeyaquən zxi' de'e yoblə. Na' bitoch bi zaquə'ən lete goschon fuerlə na' əgwleɉ əgwšošɉ beṉə' ḻen. Can' gaquə len le'e šə cuich gonḻe can' chene'e Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ca be'eni' chaclenən beṉə' par chəsə'əṉezene' gan' cheyaḻə' žɉa'aque', ca'aczən' chaclenḻe beṉə' par chəsə'əṉezene' nac chene'e Diozən' so'one'. Na' can' notə'ətezə beṉə' chac chle'ine' to syoda xen de'en chi' to lao ya'a, ca'aczən' notə'ətezə beṉə' chac chle'ine' de'e güenṉə' chonḻe. ");
INSERT INTO zavNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Catə' chgualə'əle to yi' bito chdosə'əlen žomə sino chda'alen ḻe'e ze'e par chse'eni'in len yoguə' beṉə' ža' ḻo'o yo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Na' ca naquə le'e ža, cheyaḻə' sotezə sole gonḻe de'e güenṉə' par nic̱h yesə'əle'i beṉə' ḻen na' əso'elaogüe'e X̱acho Diozən' ben' zo yoban'. ");
INSERT INTO zavNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Bito gonḻe xbab de que nada' za'a zedeyena' par nic̱h ḻei de'en bzoɉ de'e Moisezən' na' de'en boso'ozoɉ de'e profet ca' cana' cuich so'onən žin. Za'a par nic̱h gaquə complir yoguə'əḻoḻ de'en bsi' Diozən' xṉeze gaquə ca de'en boso'ozoɉ beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","De'e ḻi chnia' le'e, xte ca te c̱he yežlyo nga len de'e ca' chle'icho ḻe'e yoban', ni to ḻetr dao' ni to asento de'en nyoɉ ḻe'e ḻein' cui ten ca'azə xte que gaquə yoguə'əḻoḻ de'en chene'e Diozən' gaquə. ");
INSERT INTO zavNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","De'e na'anə' yoguə' de'e ca' zɉənyoɉ de'en chene'e Diozən' gonḻe, ḻa'aṉə'əczə šə ḻebeyožə to de'e dao', ḻegonən. Notə'ətezle šə əc̱hoele cui gonḻe can' none' mendadən', na' šə ḻeczə əgwlo'ile beṉə' yoblə cui so'one' can' none' mendadən', Diozən' bito goṉe' le'e yeḻə' bala'aṉ catə' yežinḻe yoban' gan' chnabi'enə'. Na' notə'ətezle šə gonḻe can' none' mendadən' na' šə ḻeczə gwlo'ile beṉə' yoblə so'one' can' none' mendadən', Diozən' goṉe' le'e yeḻə' bala'aṉ catə' yežinḻe yoban' gan' chnabi'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Echnia' le'e, beṉə' fariseo ca' na' beṉə' ca' choso'osed choso'olo'i ḻein' bito zɉənaquə yic̱hɉla'ažda'oga'aque'enə' güen lao Diozən'. Na' šə yic̱hɉla'ažda'olen' bito gaquəchən güen lao Diozən' cle ca c̱hega'aque'enə', bito yežinḻe yoban' gan' zo Diozən' chnabi'e. ");
INSERT INTO zavNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Na' ḻeczə bsed blo'i Jeso'osən' ḻega'aque' gwne': —Baṉezele can' gož de'e Moisezən' de'e x̱axta'ocho ca': “Cui no gotle. Na' šə no got lɉuežɉ beṉac̱he', jostis ca' c̱hoglaogüe'en c̱he' de que cheyaḻə' gate'.” ");
INSERT INTO zavNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Na' nada' chnia' le'e notə'ətezle šə chža'a lɉuežɉ beṉac̱hle zaquə'əczən par gatle ca to castigw c̱hele žalə' ca', na' notə'ətezle šə chžia chnitə'əle lɉuežɉle zaquə'əczən par so'on beṉə' golə blao ca' chəsə'ənabia' ṉasyon Izraelən' castigw c̱helen'. Na' notə'ətezle šə choḻgüiž lɉuežɉle dižə' pesad, zaquə'əczən par yoseḻə' Diozən' le'e lao yi' gabiḻ. ");
INSERT INTO zavNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Cheyaḻə' socho binḻo len lɉuežɉ beṉac̱hcho. Na' ḻa'aṉə'əczə catə' bazole ḻo'o yo'odao' par əgwnežɉwle bi de'en əgwnežɉwle güe'ela'ole Diozən', šə žɉsa'alažə'əle de que babenḻe contr to beṉə' lɉuežɉlen', ");
INSERT INTO zavNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","na'azə cheyaḻə' yocua'aṉle šlož de'en nox̱ə'əlen'. Zgua'atec žɉəyeye'exenḻe beṉə' lɉuežɉlen', nach guaquə žɉəyenežɉwle de'en bagwleɉle par güe'ela'ole Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Catə' to beṉə' gonḻe xya c̱he' na' əc̱he'e le'e lao jostis, ḻegonḻene' regl binḻo lao ngo'ole nezən' par nic̱h na' cui c̱he'e le'e lao jostisən'. Šə bito gonḻe ca' ža, catə' əžinḻe lao jostisən' gone' le'e lao na' poḻsian' par yosə'əže'e le'e ližya. ");
INSERT INTO zavNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Echnia' le'e, bito yebeɉe' le'e xte catə' c̱hixɉwle doxen de'en chaḻə'əlen'. ");
INSERT INTO zavNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Baṉezele can' gwna de'e Moisezən': “Bito co'o xtole na' bito cueɉyic̱hɉle be'en c̱hele o no'ol c̱hele par solenḻe beṉə' yoblə.” ");
INSERT INTO zavNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Na' nada' chnia' le'e de que notə'ətezle šə chgüiale to no'olə na' chzelažə'əle solenḻene', banaple doḻə' c̱hedə' tozəczə ca malən' bachonḻe ḻo'o la'ažda'olen' len de'en chon beṉə' chgo'o xtoe'. ");
INSERT INTO zavNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Na' de'e na'anə' əchnia' le'e, šə de'en chle'ile len ɉəlaole chonən par nic̱h əxople gonḻe de'e malən', nca'alə xṉeze žalə' cui žia ɉelaolen'. Len nca'alə xṉeze cueɉlen cle ca cuiayi'ile lao yi' gabiḻən' por ni c̱he ḻen. ");
INSERT INTO zavNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na' šə de'en chonḻenḻe na'ale ca' chonən par nic̱h əxople gonḻe de'e malən', nca'alə xṉeze žalə' cui žia na'ale na'anə'. Len nca'alə xṉeze c̱hogga'aclen cle ca cuiayi'ile lao yi' gabiḻən' por ni c̱he ḻega'aquən. ");
INSERT INTO zavNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ḻeczə ṉezele can' gwna de'e Moisezən': “Notə'ətezə beṉə' yele'e no'ol c̱he'enə', cheyaḻə' c̱has to act ga güe'en dižə' de que besyə'əle'enə'.” ");
INSERT INTO zavNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Na' nada' əchnia' le'e de que notə'ətezle yela'ale no'ol c̱helen', šə bito naque' to no'olə go'o xtoi, gonḻe par nic̱h gaque' ca to no'olə go'o xtoi. Na' notə'ətezle yošagna'ale len to no'olə beṉə' bela'a ben' c̱hei ḻe', ḻeczə tozəczə ca malən' chonḻe len beṉə' ca' chesə'əgo'o xtoi. ");
INSERT INTO zavNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Na' ḻeczə baṉezele can' gož de'e Moisezən' de'e x̱axta'ocho ca': “Bito əgwzole jorament lao X̱ancho Diozən' catə' ənale to de'en gonḻe šə cui gonḻe complir can' nalenə'. Catə'ən chzole jorament lao X̱ancho Diozən', cheyaḻə' gonḻe can' chonḻe lyeben' laogüe'enə'.” ");
INSERT INTO zavNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero na' nada' chnia' le'e, cuat əgwzole joramentən' por bitə'ətezə, nic por yoba c̱hedə' na'anə' zo Diozən' chnabi'e. ");
INSERT INTO zavNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Na' nic əgwzole joramentən' por yežlyon' c̱hedə' den xni'a Diozən'. Na' nic əgwzole joramentən' por syoda Jerosalenṉə' c̱hedə' naquən syoda c̱he Diozən' ben' naquə ḻe'ezelaogüe Rei blao. ");
INSERT INTO zavNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Na' nic gon yic̱hɉlen' testigw de que cho'ele dižə' ḻi, c̱hedə' bito gaquə gonḻe par nic̱h yišə' yic̱hɉlen' yeyaquən šyiš o yeyaquən gasɉ. ");
INSERT INTO zavNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Cheyaḻə' güe'ele por dižə' ḻi nic̱h cui əyažɉən əgwzole jorament par se'eɉḻe'e beṉə' c̱hele. Šə chyažɉən bichlə dižə' de'e əṉale par se'eɉḻe'e c̱hele, nacbia' gwxiye' nan' chnabia'an yic̱hɉla'ažda'olen'. ");
INSERT INTO zavNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Šə to beṉə' gone' zi' ɉelaolenə' ṉezele de que ḻei de'en bzoɉ de'e Moisezən' nan de que guaquə gonḻe zi' ɉelaogüe'enə'. Na' šə to beṉə' əx̱ope' to leyle ḻeczə ṉezele de que ḻein' nan guaquə əx̱ople to c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero na' nada' əchnia' le'e, bito əgwžonle gon beṉə' de'e mal len le'e. Šə to beṉə' cape'e šḻa'a x̱aguə'əlen', ḻe'e güe' latɉə cape'e de'en yešḻa'a. ");
INSERT INTO zavNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Šə to beṉə' chene'ene' əque'e xcamislen' laogüe de'en chaḻə'əle latə' xmeche', güe'etele latɉə əque'e len xadoṉ c̱helen'. ");
INSERT INTO zavNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Na' šə to beṉə' blao gone' byen šeɉlenḻene' gua'ale yoa' c̱he'enə' to kilometro, ḻe'e šeɉlene' gua'alen yeto kilometro. ");
INSERT INTO zavNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Na' šə bi de'en chṉabe beṉə' le'e, ḻe'e güe'en. Na' ḻe'e cueɉe šə bi de'e chṉabe' cueɉlene'. ");
INSERT INTO zavNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Na' ḻeczə baṉezele can' chəsə'əne': “Cheyaḻə' gaquele c̱he beṉə' migw c̱hele na' gue'ile beṉə' contr c̱hele.” ");
INSERT INTO zavNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero nada' əchnia' le'e, ḻe'e gaque c̱he beṉə' contr c̱helen', ḻe'e ṉabe Diozən' gaquə de'e güen c̱he beṉə' ca' choso'ožia choso'onitə' le'e. Na' ḻe'e gon de'e güen len beṉə' ca' chəsə'əgue'i le'e, na' ḻe'e gon orasyon lao Diozən' par beṉə' ca' chsa'adə' le'e dižə', na' par beṉə' chəsə'əsaquə'əzi' le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Šə gonḻe ca' na'achən' əsa'acbe'i beṉə' de que nacle xi'iṉ X̱acho Diozən' ben' zo yoban'. Ḻe'enə' chone' ca chla' bgüižən' par yoguə'əḻoḻ beṉə' ḻa'aṉə'əczə šə chso'one' de'e güen o šə chso'one' de'e mal. Na' ḻeczə chone' par nic̱h chac yeɉw par yoguə'əḻoḻ beṉə' ža' yežlyon' ḻa'aṉə'əczə šə zɉənaque' beṉə' güen o šə zɉənaque' beṉə' mal. ");
INSERT INTO zavNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Šə porzə chaquele c̱he beṉə' ca' chsa'aque c̱hele ¿bixa zedegua'atguan par le'enə'? Ḻe'egatezə can' chso'on beṉə' goc̱hixɉw ca', beṉə' ca' nale zɉənaque' beṉə' malchgua. ");
INSERT INTO zavNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na' šə con chguaple diox beṉə' lɉuežɉle ca'azə ¿əchonḻe xbabən' de que chonchle güen cle ca beṉə' yoblə? Bito chonchle güen. Can' chso'on beṉə' ca' cui zɉənombia' Diozən', con beṉə' lɉuežɉga'aque' na'azə chesə'əguape' diox. ");
INSERT INTO zavNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Cheyaḻə' gacle beṉə' šao' ca beṉə' šao' beṉə' güenṉə' naquə X̱acho Diozən' ben' zo yoban'. ");
INSERT INTO zavNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ḻe'e gon de'en naquə de'e güen pero caguə parzə nic̱h yesə'əle'i beṉə' can' chonḻen' na' so'elaogüe'e le'e, c̱hedə' šə chonḻe ca' bito güe'elao' X̱acho Diozən' ben' zo yoban' le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","De'e na'anə' šə bi de'en chene'ele əgwnežɉwle to beṉə' par gaquəlenḻene', ḻe'e əgwnežɉon pero caguə parzə nic̱h yesə'əṉeze beṉə' can' chonḻen' na' əso'elaogüe'e le'e. Beṉə' gox̱oayag ca' chəsə'ənežɉue' bi de'en chəsə'ənežɉue' beṉə' do ḻo'o yo'oda'onə' na' do lao lcue' parzə nic̱h əso'elao' beṉə' ḻega'aque'. De'e ḻi chnia' le'e, bagwyeɉlaoczəga'aque'enə' pero Diozən' bito güe'elaogüe'e ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pero na' le'e ža, šə bi de'en əgwnežɉwle to beṉə' par gaquəlenḻene', bito co'ole be' lban ca de'en chonḻe. ");
INSERT INTO zavNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Gonḻen ca cui əsa'acbe'i benə' na' cui so'elaogüe'e le'e. X̱acho Diozən' ben' chle'i yoguə' de'en choncho güe'elaogüe'e le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Catə' gonḻe orasyon bito gonḻen can' chso'on beṉə' gox̱oayag ca'. Ḻega'aque' chəsyə'əbeine' chəsə'əzeche' chso'one' orasyon ḻo'o yo'odao' c̱hega'aque' ca' gan' chso'elaogüe'e Diozən' na' do squin lquey, chso'one' orasyonṉə' par chesə'əle'i beṉə' can' chso'one'enə'. De'e ḻi chnia' le'e, bagwyeɉlaoczəga'aque'enə' na' Diozən' bito güe'elaogüe'e ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Na' catə' gonḻe orasyon ḻe'e yeyo'o ḻo'o yo'o c̱hele na' əgwseyɉwle puertən', na' gonḻe orasyonṉə' lao X̱acho Diozən' ben' cui chle'icho. Na' X̱acho Diozən' ben' chle'i yoguə' de'e choncho ḻe' güe'elaogüe'e le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","8","Ca naquə beṉə' ca' cui zɉənombia' Diozən', catə' chso'one' orasyon chso'echgüe' dižə'. Chso'one' xbab laogüe de'en chso'echgüe' dižə' Diozən' əgwzenague' c̱hega'aque'. Bito gonḻe can' chso'one'enə'. Ca naquə X̱acho Diozən', baṉezczene' bi de'en chyažɉele ze'e ṉablelene'en. ");
INSERT INTO zavNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Quingan' gonḻe orasyonṉə': X̱ato' beṉə' zo yoba, chṉabto' yoguə'əḻoḻ beṉac̱hən' əso'elaogüe'e le'. ");
INSERT INTO zavNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Chṉabto' gono' par nic̱h beṉə' zan əso'e latɉə ṉabi'o ḻega'aque'. Gaquəšga can' che'endo'onə' lao yežlyo nga, can' chac yoban'. ");
INSERT INTO zavNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Beṉšga ṉa'a de'e gaoto' tža tža. ");
INSERT INTO zavNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Na' bezi'ixenšga c̱heto' c̱hedə' ḻeczə chezi'ixento' c̱he sa'alɉuežɉ beṉac̱hto'onə' bitə'ətezə de'en chso'onene' neto'. ");
INSERT INTO zavNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Na' bito go'o latɉə gaquə de'e ṉabia' neto' len xbab c̱heto'onə' par gonto' de'e malən', mas bcuasə' bcue'eɉ neto' len gwxiye'enə'. Le'enə' chnabi'o na' napo' yeḻə' guac na' napo' yeḻə' bala'aṉ par zeɉḻicaṉe. Amen. ");
INSERT INTO zavNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Na' šə chezi'ixenḻe xtoḻə' sa'alɉuežɉ beṉac̱hlen' bitə'ətezə de'en chso'onene' le'e, ḻeczə gozi'ixen X̱acho Diozən' ben' zo yoban' xtoḻə'əlen'. ");
INSERT INTO zavNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero na' šə le'e bito chezi'ixenḻe c̱he sa'alɉuežɉ beṉac̱hlen', ḻeczə ca' X̱acho Diozən' bito yezi'ixene' c̱helen'. ");
INSERT INTO zavNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Na' catə'ən chzole sin cui che'eɉ chaole par nic̱h cho'ela'ole Diozən' bito gon cho'alaolen' ca cho'alao beṉə' chegüinchgüei can' chso'on beṉə' gox̱oayag ca'. Ḻega'aque' chso'onḻizəga'aque' ca beṉə' chegüine'e parzə nic̱h chsa'acbe'i beṉac̱hən' de que nite'e cui zɉəne'eɉ zɉənaoga'aque'. De'e ḻi əchnia' le'e bagwyeɉlaoczəga'aque'enə' na' Diozən' bito güe'elaogüe'e ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero na' le'e catə' zole sin cui ne'eɉ naole par cho'ela'ole Diozən', ḻe'e əgwpa'a yic̱hɉle na' xala'anḻe. ");
INSERT INTO zavNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ḻegon ca' par nic̱h cui əsa'acbe'i beṉac̱hən' de que zole sin cui ne'eɉ naole. Tozə X̱acho Diozən' ben' cui chle'icho ṉezene' can' chonḻe. Na' X̱acho Diozən' ben' chle'i yoguə' de'e choncho güe'elaogüe'e le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Bito gwtoble de'e zan de'e zaque'e na' de'e xoche lao zole yežlyo nga, la' yesə'əbiayi'in. Baḻən chsa'alɉən bia dao' na' chsa'ob ḻega'aquən, na' yebaḻən chzen no xc̱he'i, na' ḻeczə chaš beṉə' bguan na' so'e yesə'əque'e bi de'en deilen'. ");
INSERT INTO zavNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ḻe'e gon par nic̱h goṉ Diozən' de'e šao' de'e güenchlə c̱hele de'e cui te c̱hei catə' yežinḻe yoban' gan' zoe'enə', c̱hedə' na' bito galɉə bia dao' par əsa'ob ḻen, na' nic sen xc̱he'i par cuiayi'in, na' nic gaquə šo'o beṉə' bguan par əque'en. ");
INSERT INTO zavNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Gan' de de'en chaquele c̱hei nan' zo yic̱hɉla'ažda'olen'. ");
INSERT INTO zavNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Žia ɉelaochon' par chle'icho. Con šə bito bi chaquən chle'iczecho binḻo. ");
INSERT INTO zavNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero šə nc̱hoḻ ɉelaochon' bito chle'icho. Ca'aczən' naquən len yic̱hɉla'ažda'olen' šə nacle beṉə' la'aždao' güen yo'o be'eni' c̱he Diozən' yic̱hɉla'ažda'olen', pero šə nacle beṉə' mal nc̱hoḻ yic̱hɉla'ažda'olen'. De'e ḻi ḻechguaḻe nc̱hoḻ yic̱hɉla'aždao' le'e cui chzenagle c̱he Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Notono no gaquə so liž c̱hopə x̱an žin par gaque' xmosga'aque' tši'izə, c̱hedə' la' šə gone' ca' gue'ine' to x̱an žinṉə' na' gaquene' c̱he yetoe', o gone' žin c̱he toe' do yic̱hɉ do laže'e na' bito bi respet gape' par x̱ane'en yeto par gone' xšine'enə'. Ḻeczə can' le'e bito gaquə gonḻe xšin Diozən' do yic̱hɉ do lažə'əle na' gonte xšinḻe par gacle beṉə' gwni'a. ");
INSERT INTO zavNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","De'e na'anə' chnia' le'e, bito cuec yic̱hɉle tlaozə de'en ye'eɉ de'en gaole lao mbanḻe. Na' ḻeczə ca' cuerp c̱helen' bito cuec yic̱hɉle tlaozə de'en guacwlen'. Zaquə'əch yeḻə' mban c̱helen' ca yeḻə' guaon'. Ḻe'egatezə ca' cuerp c̱helen' zaquə'əchən ca xala'anḻen'. ");
INSERT INTO zavNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ḻegontoš xbab c̱hele, ca naquə bia ca' zɉəžia x̱ile'e bito chsa'azəb na' bito chəsyə'əlapəb na' nic bi da'a xoa' c̱hega'aquəb zo, pero na' chguaoczə X̱acho Diozən' ben' zo yoban' ḻega'aquəb. Naquəchxen' zaquə' le'e ca bia ca' zɉəžia x̱ile'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Na' ni tole bito gaquə yostoṉ cuinḻe gašɉə metr šə con cue'e yic̱hɉle ətoṉle. ");
INSERT INTO zavNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Na' ¿bixc̱hen' chbec yic̱hɉle c̱he xala'anḻe? Ḻegontoš xbab ca naquə yeɉ sosenṉə' chesə'əcha'oczən, len bitobi žin chso'onən, nic chsa'alɉən do. ");
INSERT INTO zavNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Na' əchnia' le'e, Salomonṉə' goque' lachə' xoche juisy, pero bito bžinḻaže'e xala'ane'enə' ca yeḻə' xoche c̱he yeɉ sosen ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Diozən' none' xoche yix̱ə' de'en ze yoba len to termzə zen nach choso'ozeye'en, naquəchxe gon Diozən' len le'e, güe'eczə yic̱hɉe' goṉe' yoguə'əte de'en chyažɉele, le'e cui cheɉḻe'etecle de que goṉe' de'en chyažɉele. ");
INSERT INTO zavNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Le'e ža, bitoch cuec yic̱hɉle c̱he bi de'en chyažɉele ənalizle: “¿Bin' ye'eɉ gaocho na' bin' gacwcho?” ");
INSERT INTO zavNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Con por de'e ca'azən' zɉəchi' yic̱hɉ beṉə' ca' cui chso'onḻilažə' Diozən', c̱he de'en əse'eɉ əsa'ogüe' na' c̱he xala'anga'aque'. Pero na' X̱acho Diozən' ben' zo yoban', ṉezczene' yoguə' de'e ca' chyažɉele. ");
INSERT INTO zavNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","De'en güe'elažə'əle, güe'ele latɉə par nic̱h Diozən' ṉabi'e le'e, na' güe'elažə'əle gonḻe de'en na Diozən' naquə güen. Na' yoguə' de'e ca' de'en chyažɉelen' goṉczə Diozən' ḻen, de'en ye'eɉ de'en gaolen', na' xala'anḻe. ");
INSERT INTO zavNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ḻe'e gon xbab c̱he de'en chac tža tža. Bito cuec yic̱hɉle c̱he bi de'en gaquə gwx̱e güižɉ, la' guatə'əczə de'e zan de'e cuec yic̱hɉcho c̱hei catə' əžin žan'. ");
INSERT INTO zavNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Bito gonḻe xbab de que zaquə'əle par əṉale c̱he beṉə' de que zɉənape' doḻə'. Šə əṉale c̱hega'aque' de que zɉəṉape' doḻə' ḻeczə ca' əna Diozən' c̱hele de que naple doḻə'. ");
INSERT INTO zavNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Can' chosbague'ele beṉə' de que zɉənape' doḻə' ḻe'egatezəczə can' yosbague'e Diozən' le'e de que naple doḻə'. Con can' chonḻe len beṉə', ḻe'egatezə can' gon Diozən' len le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Chle'ile güe' dao' de'en žia cožə' beṉə' lɉuežɉle, na' cabi chele'ile güe' xen de'en žia cožə'əlen'. ");
INSERT INTO zavNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Che' beṉə' lɉuežɉle: “Be'e latɉə gona' rmech güe' daon' de'en žia cožo'onə'”, na' bito chonḻe rmech güe' xen de'en žia cožə'əlen'. ");
INSERT INTO zavNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Beṉə' gox̱oayag le'e! Zgua'atec ḻe'e gon rmech güe' xenṉə' de'en žia cožə'əlen' na' techlə əṉezele naquən' gonḻe rmech güe' daon' de'en žia cožə' beṉə' lɉuežɉlen'. ");
INSERT INTO zavNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Pero na' bito güe'etezle xtižə' Diozən' len beṉə' ca' chso'onczə yic̱hɉlaoga'aque' cui chse'enene' yoso'ozenague' c̱hei, c̱hedə' la' guacte so'onene' le'e znia can' chon beco' catə'ən cho'ex̱ax̱ɉchob de'en cui cho'olažə'əb. Na' šə güe'etezle xtižə' Diozən' len beṉə' ca' chso'onczə yic̱hɉlaoga'aque' cui chse'enene' yoso'ozenague' c̱hei, con yosə'əleɉ yoso'ošošɉe' dižə' de'en güe'elenga'aclene'enə' can' chso'on coš ca' len de'en cui chse'ene'eb əsa'ob. ");
INSERT INTO zavNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Bitə'ətezə de'en chene'echo gaquə, de de'e goncho par nic̱h gaquən. Šə to de'e chene'echo so'oṉ beṉə' chio'o, chṉabchon. Šə to de'e chene'echo əželecho, chyilɉchon. Šə puert de'en chene'echo əsalɉo beṉə', chṉecho cho'a puertən' par nic̱h chsalɉue'. Na' ca'aczən' cheyaḻə' ye'echo Diozən' catə'ən de de'en chene'echo gaquə. ");
INSERT INTO zavNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Na' notə'ətezcho šə bi de'e chṉabechone' goṉe', la' de'e goṉcze'enə'. Na' notə'ətezcho šə bi de'en chṉabechone' əgwzeɉni'ine' chio'o, əgwzeɉni'iczene'. Na' notə'ətezcho šə chṉabechone' gaquə to de'en chene'echo gaquə can' chon beṉə' chṉe' cho'a puertən', la' de'e gaquəczən'. ");
INSERT INTO zavNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Na' le'e nacle x̱a bidao', šə xi'iṉlen' əṉabebo' le'e yetxtil ¿əgwnežɉwlebo' to yeɉ? ");
INSERT INTO zavNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Na' šə əṉabebo' le'e to beḻ ya'a ¿əgwnežɉwlebo' to beḻ bia nxobə ḻe'i? Cle bito gonḻe ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Le'e nacle beṉə' mal pero ṉezele chnežɉwle xi'iṉlen' de'e güen. Naquəchxe güen gon X̱acho Diozən' ben' zo yoban' len beṉə' chṉab laogüe'enə' bi de'en chyažɉene'. ");
INSERT INTO zavNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Na' can' naquən, con yoguə' de'e güen de'e chene'ele so'on beṉac̱hən' len le'e ca'atezəczən' cheyaḻə' gon le'e len ḻega'aque', c̱hedə' can' na ḻei de'en bzoɉ de'e Moisezən' na' de'en boso'ozoɉ de'e profet ca' beṉə' ca' gwso'e xtižə' Diozən' cana'. ");
INSERT INTO zavNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Lao yeḻə' mban c̱hechon' c̱hopə nez nan' de. To nez las, na' to nez laguə'. Cheyaḻə' goncho byen šo'ocho to nez šao' to nez güen ḻa'aṉə'əczə naquən ca to nez las de'e caṉe əželən na' de'e chaquecho naquən zdebə par tachon. Na' nez malən' gwxaquə'əleben ca to nez yo nez laguə' c̱hedə' chpein chio'o par nic̱h yežincho gabiḻən' gan' saquə'əzi'icho zeɉḻicaṉe. Pero beṉə' zan bazɉəyo'e nez laguə'ənə'. ");
INSERT INTO zavNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nezən' de'en yežin yoban' gan' əbancho zeɉḻicaṉe len Diozən' gwxaquə'əleben ca to nez las de'e caṉe əželən na' de'e chaquecho naquən zdebə par tachon. De'e na'anə' baḻga beṉə' chəsyə'əželene'en par chɉəsə'ənaogüe'en. ");
INSERT INTO zavNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Cheyaḻə' gapcho cuidad par nic̱h cui šeɉḻe'echo xtižə' beṉə' ca' chso'onḻaže'e chəsə'əne' de que xtižə' Diozən' chəsə'əyix̱ɉui'e. Xochechguan' chso'e dižə'ənə' par choso'opeine' chio'o, chse'enene' goncho xbab de que zɉənaque' beṉə' güen. Pero ḻega'aque' zɉənaque' beṉə' la'aždao' mal na' chse'enene' yoso'ožiayi'e chio'o. ");
INSERT INTO zavNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Segon can' naquə frot de'e chbia to to yaguən' ṉezecho bi cḻas yaguən'. Ca'aczən' gacbe'iczecho de que beṉə' ca' chəsə'əx̱oayague', segon can' chso'one' na' bin' choso'osed choso'olo'ine' beṉə'. Ca naquə yag yešən' bito chbian obas, na' nic yag bc̱ho'onən' chbian yix̱güio. ");
INSERT INTO zavNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Na' de'en naquə yag güen, frot güenczə chbian na' de'e cui naquə güen ḻeczə bito chbian frot güen. ");
INSERT INTO zavNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yag frot güenṉə' bito chbian frot de'e cui naquə güen, na' ḻeczə to yag frot de'en cui naquə güen bito chbian frot güen. ");
INSERT INTO zavNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Na' yoguə' yag frot de'e cui chesə'əbian frot güen, yesə'əc̱hogue'en na' yesə'əzeye'en. ");
INSERT INTO zavNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Na' gacbe'icho non' chəsə'əx̱oayag, segon can' chso'one' na' bin' choso'osed choso'olo'ine' beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Beṉə' zan chse'e nada': “Naco' X̱ana'”, pero caguə yogue'e yesyə'əžine' yoban' gan' chnabia' Diozən'. Beṉə' ca' chso'on can' chazlažə' X̱a' Diozən' ben' zo yoban', ḻega'acze'enə' yesyə'əžine' yoban' gan' zo'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Catə' əžin ža yoso'odie' cuent lao Diozən' beṉə' zan əse'e nada': “X̱ana', goclen neto' ṉa'a, la' beṉə' zan gwdix̱ɉue'ito' xtižo'onə'. Na' ḻeczə be'eto' la'onə' par bebeɉto' de'e x̱io' ca' zɉəyo'o zɉəyaz yic̱hɉla'aždao' beṉə'. Na' ḻeczə be'eto' la'onə' par bento' de'e zan miḻagr.” ");
INSERT INTO zavNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero na' clar yapə'əga'aca'ane': “Bito nombi'a le'e. Ḻežɉəya'ac ca'aḻə le'e beṉə' güen de'e mal.” ");
INSERT INTO zavNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Beṉə' chzenag xtiža'anə' na' chone' can' nanṉə', gwxaquə'əlebene' ca to beṉə' sin' beṉə' ben liže' na' gwleque' lanen' len yeɉ gual. ");
INSERT INTO zavNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Na' goc yeɉw zil juisy na' bchoɉchgua yaonə' na' gwyec̱hɉən liže'enə'. Na' lei bdobən be' bdon'. Pero bito gosə'əzoin par yoso'ochix̱ən ḻen, c̱hedə' gwleque' lanen' de'e gual. ");
INSERT INTO zavNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Na' beṉə' chzenag xtiža'anə' pero bito chone' can' nanṉə', gwxaquə'əlebene' ca to beṉə' faḻs beṉə' ben liže'enə' faḻs bzoe'en lao yox. ");
INSERT INTO zavNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Na' goc yeɉw zil juisy, gwyec̱hɉ be' bdon' na' bchoɉchgua yao na' beyožən gan' zo liže'enə'. Nach bebix̱ən gwžiayi'in. Na' catə' gwže'enə' xte gwṉiṉ. ");
INSERT INTO zavNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Na' catə' beyož be' Jeso'osən' dižə' ca', beṉə' zan ca' gwse'ene xtiže'enə' besyə'əbanchgüeine' can' bsed blo'ine'. ");
INSERT INTO zavNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Na' can' bzeɉni'ine' ḻega'aque' nacbia' de que napəche' yeḻə' chnabia' cle ca beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Beṉə' zan zesyə'ənaogüe' Jeso'osən' catə' beyetɉe' ya'anə'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nach to beṉə' che'i yižgüe' de'en ne' ḻepr bgüigue'e lao Jeso'osən' na' bzo xibe' laogüe'enə' gože'ene': —X̱ana' gonšguei ben par nic̱h yeyacda'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nach Jeso'osən' bḻi ne'enə' gwdane'ene' gože'ene': —Guaquəczə, beyaque. Na' ḻe'e beyactei be'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nach Jeso'osən' gože'ene': —Ni tozə cui no güe'eleno' dižə' ca naquə nga babena' len le'. Gwyeɉ lao bx̱ozən' nic̱h le'ine' bac̱h beyacdo'. Na' bnežɉue' bia yix̱ə' gote' lao Diozən' can' non de'e Moisezən' mendad par nic̱h yesə'əṉeze beṉə' de que babeyacdo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Na' catə' bežin Jeso'osən' Capernaunṉə' ḻe'e bšagte to capitan beṉə' Roma ḻe'. Na' gotə'əyoine' Jeso'osən' ");
INSERT INTO zavNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","gože'ene': —X̱ana', xmosa'an die' liža'anə', chacšenchgüeine'. Nat cuerp c̱he'enə' na' ḻechguaḻe chžaglaogüe'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nach Jeso'osən' gože' capitanṉə': —Sa'alena' le' na' yeyona'ane'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pero na' capitanṉə' gože'ene': —X̱ana', bito zaca'a par sa'o liža'anə'. Ngatezə ben mendad yeyaque xmosa'anə' nach yeyaquene'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Rein' chnabi'e nada' pero ḻeczə nitə' soḻdad c̱hia' ca' na' chnabi'aga'aca'ane' na' choso'ozenague' c̱hia'. Catə' chapa'a toe': “Gwyeɉ”, na' cheɉe', na' catə' chapa'a yetoe': “Da nga”, na' chide'. Nach catə' chapa'a xmosa'anə': “De'e nga gono'”, na' chone'en. Con benšga mendad na' ṉezda' gaquə can' na'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Na' Jeso'osən' bebanene' catə' benene' xtižə' capitanṉə', na' gože' beṉə' ca' nao ḻe'enə': —De'e ḻiczə əchnia' le'e, notono beṉə' ṉe'e žɉəti'a beṉə' gonḻilažə'ətec nada' ca benga. Ni tozə beṉə' Izrael cui chonḻilažə' nada' ca ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Echnia' le'e, beṉə' zan ža' doxenḻə yežlyon' so'onḻilaže'e nada, na' ḻega'aque' žɉəsyə'ənite'e txen len de'e x̱axta'ocho Abraanṉə' na' de'e x̱axta'ocho Isaaquən', na' de'e x̱axta'ocho Jacobən' yoban' gan' zo Diozən' chnabi'e. ");
INSERT INTO zavNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Na' ca naquə ṉasyon Izrael c̱hechon' le'en gwleɉ Diozən' par ṉabi'e, əchoɉ beṉə' zan bito so'e latɉə ṉabi'e ḻega'aque'. De'e na'anə' əseḻe'e ḻega'aque' lao yi' gabiḻən' gan' yesə'əbežyaše'e na' sa'oyeɉə leyga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Gwde gwna Jeso'osən' ca' nach gože' capitanṉə': —Guaquə yeyeɉo'. Babeyona' xmoso'onə', c̱hedə' cheɉḻi'o c̱hia'. Na' xmos capitanṉə' lao or na' ḻe'e beyacteine'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Na' gwyeɉ Jeso'osən' liž Bedən' na' ble'ine' taobin' c̱he Bedən' die' lao camən', na' yo'e de'e ḻan'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jeso'osən' bex̱e'e ne'enə' na' ḻe'e bechoɉte' de'e ḻan'. Nach ḻe'e gwyaste no'olən' bene' de'e gwsa'ogüe'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Na' catə' gwx̱en, besə'əžin beṉə' gan' zo Jeso'osən' zɉənc̱he'e beṉə' zan zɉəyo'o zɉəyaz de'e x̱io' yic̱hɉla'ažda'oga'aque'enə'. Jeso'osən' con bene' mendad na' besyə'əchoɉ de'e x̱io' ca'. Na' beyone' yoguə' beṉə' ca' chsa'acšenenə'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Can' bene' par nic̱h goc complir can' bzoɉ de'e profet Isaiazən' c̱he' cana', nan: “Ḻe'enə' yeque'e de'en chžaglaocho na' gone' ca yeyaquecho c̱he yoguə' yižgüe'.” ");
INSERT INTO zavNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Gwde na' ble'i Jeso'osən' babesə'əžin beṉə' zan zɉənyec̱hɉe' ḻe', nach bene' mendad len disipl c̱he' ca' yesə'əḻague'e yešḻa'alə nisda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Na' bchoɉ to ben' chsed chlo'i ḻei de'en bzoɉ de'e Moisezən' nach bgüigue'e lao Jeso'osən' na' gože'ene': —Maestr, gwza'alena' le' gatə'ətezə šeɉo'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Na' par nic̱h be'enə' benyaṉe'e xbab šə de'e ḻiczə che'enene' šeɉlene' ḻe', na' Jeso'osən' gože'ene': —Zɉəde liž becoyo'o ca' na' ḻeczə zɉəde liž bia ca' zo x̱ile'e bia chaš yoba, pero nada' bitobi xlatɉa' de gan' gona' dezcanz ḻa'aṉə'əczə bseḻə' Diozən' nada' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Na' bchoɉ yeto ben' nao de'en chsed chlo'i Jeso'osən' na' gože'ene': —X̱ana', gwza'alena' le' pero zgua'atec be'ešga latɉə yega'aṉlena' x̱a'anə' xte catə'əch əžin ža gate' na' əgwcuaša'ane'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jeso'osən' gože'ene': —Da len nada'. Beṉə' ca' zɉənaquə len yic̱hɉla'ažda'oga'aquen' ca beṉə' guat guaquə yesə'əcuaše'e beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Gwde be' Jeso'osən' dižə' ca', gwyo'e ḻo'o barcon' len disipl c̱he' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na' lao zda barcon' gwtas Jeso'osən'. Na' gwzolao gwyec̱hɉ to be' gual lao nisda'onə', na' gwzolao chož nisən' ḻo'o barcon'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nach bosyo'osbane' Jeso'osən' gwse'ene': —¡X̱anto'! ¡Bosla chio'o! ¡Bac̱h chbiayi'icho! ");
INSERT INTO zavNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nach Jeso'osən' gože' ḻega'aque': —Bito žeble. Ḻe'e šeɉḻe'ech c̱hia'. Nach gwyase' ṉe'e chas chatə' nisda'onə' nach bene' mendad besyə'əbe'eži nisda'onə' len be'enə', na' ḻe'e besyə'əbe'ežiten. ");
INSERT INTO zavNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Na' disipl c̱he' ca' besyə'əbanene' can' bene'enə', nach gwse' lɉuežɉga'aque': —Bitolɉa naquə benga con to beṉac̱hzə, la' ¿nacxa gon to beṉac̱h par yebecžie' be' gualən' len nisda'onə'? ");
INSERT INTO zavNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Na' besə'əžine' yešḻa'alə nisda'onə', laž beṉə' Gadara ca'. Na' catə' besyə'əchoɉe' barcon', besə'əšag c̱hopə beṉə' Jeso'osən', beṉə' zɉəyo'o zɉəyaz de'e x̱io' ḻo'o yic̱hɉla'ažda'oga'aquen'. Beṉə' quinga banitə'əte' capsant na' chesə'əchoɉe' chaše' do tnezən' gaḻə'əzə capsantən' chso'one' znia juisy len beṉə' chesə'əžague', na' caguə no chac ta tnezən'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Na' de'e x̱io' ca' gwso'osya'an gwse'en Jeso'osən': —Partlə le', na' partlə neto', Jeso'os Xi'iṉ Dioz. ¿Eza'o par əgwc̱hi'i əgwsaco'o neto' catə' cuiṉə' əžin ža əžin or par si'ito' castigw? ");
INSERT INTO zavNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na' gaḻə'əzə chaš beṉə' choso'oye' coš zan. ");
INSERT INTO zavNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nach de'e x̱io' ca' gwsa'atə'əyoin Jeso'osən' gwse'en ḻe': —Šə yebeɉo' neto' yic̱hɉla'aždao' beṉə' quinga, güe'ešgo' latɉə žɉəyežo'oto' ḻo'o la'aždao' coš ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nach gož Jeso'osən' ḻega'aquən: —Ḻeyechoɉ. Nach besyə'əchoɉən yic̱hɉla'aždao' beṉə' ca' na' ɉəsyə'əžo'on ḻo'o la'aždao' coš ca'. Nach besyə'ədiṉses coš ca' ḻe'e ya'a gan' chašəbən' na' ɉəsyə'əxopəb ḻo'o nisda'onə', na' gwsa'atəb gwse'eɉəb nisən'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Na' beṉə' ca' chosə'əye' coš ca' besa'acdoe' na' besyə'əžine' syodan', ɉəsyə'ədix̱ɉue'ine' beṉə' lao' syodan' yoguə' can' bagoc na' can' babesyə'əyaque beṉə' ca' zɉəyo'o zɉəyaz de'e x̱io'onə' yic̱hɉla'ažda'oga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nach yoguə' beṉə' ca' ža' syodan' ɉa'aque' gan' zo Jeso'osən'. Na' catə' besə'əžague' Jeso'osən' gwsa'atə'yoine' ḻe' yeze'e lažga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nach Jeso'osən' beyo'e to ḻo'o barcw len disipl c̱he' ca' na' besyə'əḻague'e yešḻa'alə nisda'onə' par besyə'əžine' Capernaum gan' bazocze'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Na' besə'əžin x̱oṉɉ beṉə' na' zɉənḻene' to beṉə' nat to part cuerp c̱he'enə', zɉənx̱oe'ene' to lao cam dao'. Ca' naquə gocbe'i Jeso'osən' de que gwso'onḻilaže'ene', nach gože' beṉə' güe'enə': —Bebei, xi'iṉdaogua'a. Babezi'ixena' xtoḻo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Na' baḻə beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' gwse'enene' de'en gož Jeso'osən' beṉə' güe'enə', na' gwso'one' xbab ḻo'o yic̱hɉla'ažda'oga'aque'enə' gosə'əne': —Benga chžia chnite'e Diozən' laogüe de'en chon cuine' ca Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jeso'osən' gocbe'ine' xbabən' chso'one'enə', nach gože' ḻega'aque': —¿Bixc̱hen' chonḻe xbab malən' ca' ḻo'o yic̱hɉla'ažda'olen'? ");
INSERT INTO zavNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Šə con yapa'ane' de que babezi'ixena' xtoḻe'enə', bito ṉezele šə napa' yeḻə' gwnabia' par yezi'ixena'an. Pero šə yapa'ane': “Gwyas na' gwda”, guatə'əbia' šə napa' yeḻə' gwnabia' par gaquə can' nia'anə'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Diozən' bseḻe'e nada' golɉa' beṉac̱h na' de'e ngan' gona' par nic̱h əṉezele de que napa' yeḻə' gwnabia' lao yežlyo nga par yezi'ixena' xtoḻə' beṉac̱hən'. Nach gože' beṉə' güe'enə': —Gwyas beyoa xcamo'onə' na' beyeɉ ližo'onə' to šao' to güen. ");
INSERT INTO zavNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Na' beyas be'enə', beze'e zɉəyede' liže'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Na' beṉə' ca' besə'əle'i can' goquən', ḻechguaḻe besə'əžebe'. Na' gwso'elaogüe'e Diozən' ca naquə bene' yeḻə' guac par nic̱h Jeso'osən' goc bene' de'e ca' zɉənac ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Gwde na' beza' Jeso'osən' na' ble'ine' to beṉə' goc̱hixɉw na' le' Matio, chi'e latɉə gan' chc̱hixɉue'enə'. Na' Jeso'osən' gože'ene': —Da len nada'. Na' Mation' ḻe'e gwzoža'ate' gwyeɉlene' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Na' goquən' chi' Jeso'osən' liž Mation' len disipl c̱he' ca' chsa'ogüe'. Na' nitə' beṉə' zan beṉə' goc̱hixɉw ca' na' nochlə beṉə' güen de'e mal ca' chsa'olene' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Na' beṉə' fariseo ca' catə' besə'əle'ine' chi' Jeso'osən' txen len beṉə' güen de'e mal ca', gwse'e disipl c̱he' ca': —Malən' chon maestr c̱helen' che'eɉ chaogüe' txen len beṉə' goc̱hixɉw ca' na' nochlə beṉə' güen de'e mal beṉə' cui chonḻento' txen. ");
INSERT INTO zavNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Na' catə' Jeso'osən' benene' xtižə'əga'aque'enə', na' gože' ḻega'aque': —Beṉə' cui chsa'acšene bito chəsə'əyažɉene' beṉə' güen rmech. Beṉə' ca' chsa'acšene ḻega'aque'enə' chəsə'əyažɉene' beṉə' güen rmech. ");
INSERT INTO zavNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ḻešeɉ na' ḻegwsed bi zeɉe Xtižə' Diozən' de'en nyoɉən nan: “Che'enda' yeyašə' yeži'ilažə'əle beṉə', caguə tlaozə gotle bia yix̱ə' par güe'ela'ole nada'.” Za'a zedəyena' par nic̱h beṉə' ca' zɉəṉezene' de que zɉənaque' beṉə' güen de'e mal yesyə'ədiṉɉene' xtoḻə'əga'aque'enə', pero bito zedəyena' par nic̱h beṉə' ca' chsa'aquene' bazɉənaque' beṉə' güen yesyə'ədiṉɉene' xtoḻə'əga'aqe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nach disipl c̱he Juan ben' bc̱hoa nis gosə'əbigue'e lao Jeso'osən', na' gwse'ene': —Zan las beṉə' fariseo ca' na' neto' chzoto' sin cui che'eɉ chaoto' par cho'ela'oto' Diozən'. Pero disipl c̱hio' ca' chse'eɉ chsa'ogüe'. ¿Bixc̱hen' ža? ");
INSERT INTO zavNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nach Jeso'osən' gože' ḻega'aque': —Catə' chac to yeḻə' gošagna' beṉə' migw c̱he be'enə' chšagna'anə' bito chəsyə'əgüine'ene' sino chse'eɉ chsa'ogüe'. Na' ca'aczən' naquən len nada' na' len disipl c̱hia' ca', chse'eɉ chsa'ogüe' lao ṉe'e zoa' len ḻega'aque'. Catə'əchən' əžin ža yesə'əc̱he'ex̱ax̱ɉ beṉə' contr c̱hia' ca' nada' cana'achən' əchoɉ catə' cuich əse'eɉ əsa'o disipl c̱hia' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Notono beṉə' zo beṉə' chc̱hine' to pedas lachə' cuiṉə' x̱oa nis par yoda' xa gole'enə' de'en bac̱h chyoe. Šə can' gone', catə' c̱hib xe'enə' yebe' lachə' cobən' na' əc̱hezəchən ḻen. ");
INSERT INTO zavNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Na' ḻeczə notono zo beṉə' chgue'e bino cobən' ḻo'o yid golən'. Šə gone' ca', bino cobən' əc̱hezə'ən yid golənə' na' lalɉə binon' na' cuiayi' yidən'. Cle la' cheyaḻə' que'e bino cobən' ḻo'o yid cobə, par nic̱h ca' bito cuiayi' binon' na' yidən'. Gože' ḻega'aque' ca' par nic̱h bzeɉni'ine' de que bito gaquə yesə'ənaogüe' costombr golə c̱hega'aque'enə' na' yesə'ənaotie' de'en chsed chlo'ine'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Na' ṉe'e cho'ete Jeso'osən' dižə' quinga, bžin to beṉə' gwnabia' bzo xibe' lao Jeso'osən' na' gože'ene': —Ze'e gotte to xi'iṉa' no'olə. Yo'ošga cano'obo', na' yebambo'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Na' ḻe'e gwzoža'ate Jeso'osən' na' txen len disipl c̱he' ca' ɉa'aclene' beṉə' gwnabian'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na' lao zɉa'aque' liž beṉə' gwnabian' ɉənao to no'olə ḻega'aque', beṉə' bagoc šižiṉ iz chzoe' bgua'a. Na' bene' byen bgüigue'e cožə' Jeso'osən' gwdane' lox xadoṉ c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","La' bene' xbab ḻo'o yic̱hɉla'ažda'ogüe'enə', gwne': “Con cana' xadoṉ c̱he'enə', goyacczəda'.” ");
INSERT INTO zavNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Na' gwyec̱hɉ Jeso'osən', ble'ine' no'olən', na' gože'ene': —Bebei xi'iṉdaogua'a. Babeyacdo' c̱hedə' chonḻilažo'o nada'. Na' ḻe'e bega'ate yižgüe' de'en che'i no'olən'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Catə' bžin Jeso'osən' liž beṉə' gwnabian', na' ble'ine' beṉə' zan zɉəža' na' nitə' beṉə' chəsə'əcuež ca bžeɉo, na' beṉə' ca' ža'anə' chəsə'əbežchgüe'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Na' gože' ḻega'aque': —Ḻe'e yechoɉ ngalə. Bito nacbo' bi'i guat, con chtasbo'onə'. Pero na' beṉə' ca' gwso'onḻe'e c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Na' beyož besyə'əbeɉe' beṉə' ca' fuerlə, nach gwyo'o Jeso'osən', bex̱e'e na' bi'i no'olə guat da'onə', na' beyasbo'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Na' ca naquə de'e güenṉə' de'en ben Jeso'osən' gosə' gwlalɉə dižə'ənə' yoguə' yež ca' zɉəchi' do na'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Na' catə' beza' Jeso'osən' len disipl c̱he' ca', ɉəsə'ənao c̱hopə beṉə' lc̱hoḻ ḻega'aque'. Na' gwsa'atə'əyoine' ḻe' gosə'əṉe' zižɉo gosə'əne': —Le' naco' xi'iṉ dia c̱he de'e Rei Dabi. Beyašə'əlažə'əšguei neto'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Na' catə' bežin Jeso'osən' len disipl c̱he' ca' liže'enə' na' besyə'əyo'e, na' ḻeczə gwso'o beṉə' lc̱hoḻ ca'. Nach Jeso'osən' gože' ḻega'aque': —¿Echeɉḻe'ele de que guac gona' par nic̱h yele'ilen'? Nach gwse'ene': —Cheɉḻe'eto' X̱anto'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nach Jeso'osən' gwdane' ɉlaoga'aque'enə', na' gože' ḻega'aque': —Yele'ile, c̱hedə' chonḻilažə'əle nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nach besyə'əle'ine'. Na' Jeso'osən' bene' mendad cui no əso'elene' dižə' ca naquə bene' par nic̱h besyə'əle'ine'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Bixa na' besa'aque' na' gatə'ətezə ɉa'aque' doxen Galilean' ɉəsyə'əye'elene' beṉə' dižə' ca naquə de'en baben Jeso'osən' len ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Na' catə' besa'ac beṉə' ca' babesyə'əle'inə', ḻe'e besə'əžinte beṉə' yoblə zɉənc̱he'e to beṉə' mod, na' yo'o yaz de'e x̱io'onə' yic̱hɉla'ažda'ogüe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jeso'osən' bebeɉe' de'e x̱i'onə' na' ḻe'e benete be'enə'. Na' beṉə' zan ca' besə'əle'i can' goquən' besyə'əbanchgüeine', na' gosə'əne': —Chio'o beṉə' Izrael de'e nechən' bable'icho ca naquə miḻagr de'en chon benga. ");
INSERT INTO zavNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero na' beṉə' fariseo ca' gosə'əne': —Gwxiye' de'en chnabia' de'e x̱io' ca'anə' chaclenən ḻe' par nic̱h chebeɉe' de'e x̱i'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Na' Jeso'osən' len disipl c̱he' ca' ɉa'aque' yo'odao' c̱he to to yež na' to to syoda gan' mbane Galilean' na' gwdix̱ɉue'ine' beṉə' dižə' güen dižə' cobən' can' ṉabia' Diozən' notə'ətezə beṉə' so'e latɉə. Na' beyone' yoguə' beṉə' ca chsa'acšene len bitə'ətezə yižgüe' de'en chse'ine'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Na' Jeso'osən' ble'ine' beṉə' zan ca' zɉəsə'ənao ḻe' na' beyašə' beži'ilaže'e ḻega'aque' c̱hedə' gocbe'ine' chsa'acžeɉlaže'e naclən' so'one' na' gocbe'ine' caguə no zo no gaquəlen ḻega'aque' len yoguə' de'en chəsə'əžaglaogüe'enə'. Gwsa'aque' ca xilə' bian' cui no x̱anga'aquəb zo par əgwye' ḻega'aquəb. ");
INSERT INTO zavNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nach gože' disipl c̱he' ca': —Nitə' beṉə' zan beṉə' yoso'ozenague' c̱he Diozən' catə' se'enene' xtiže'enə'. Na' gwxaquə'əlebəga'aque' ca to cwseš xen de'en chetoba'. Na' chyažɉda' beṉə' zan əsa'aclene' nada', la' to c̱hopgale nitə'. ");
INSERT INTO zavNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","De'e na'anə' ḻeṉabe X̱ancho Diozən' əseḻə'əche' beṉə' zanch par əsa'aclene' chio'o yetobcho cwseš c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jeso'osən' betobe' disipl c̱he' ca' šižiṉ na' bnežɉue' ḻega'aque' yeḻə' guac par nic̱h əsa'aque' yesyə'əbeɉe' de'e x̱io' zɉəyo'o zɉəyaz ḻo'o yic̱hɉla'aždao' beṉə', na' par nic̱h əsa'aque' yesyə'əyone' beṉə' bitə'ətezə yižgüe' de'en chse'ine' na' bitə'ətezəchlə de'e chsa'aquene'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Quinga zɉəle beṉə' šižiṉ ca': Simon ben' ḻeczə le' Bed, na' Ndres beṉə' bišə' Bedən', na' xi'iṉ Sebedeon' Jacob len Juanṉə', ");
INSERT INTO zavNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","na' Lip na' Bartolome, na' Tomas, na' Matio ben' goquə beṉə' goc̱hixɉw, na' Jacob xi'iṉ Alfeo, na' Lebeo, ben' ḻeczə le' Tadeo, ");
INSERT INTO zavNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","na' Simonṉə' ben' ben txen len partid Cananistən', na' Jod Iscariot ben' bdie' Jeso'osən' lao na' beṉə' contr ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Na' catə' Jeso'osən' bseḻe'e beṉə' šižiṉ quinga ɉəsə'ədix̱ɉui'e xtižə' Diozən', gože' ḻega'aque': —Chseḻa'a le'e žɉe'ele xtižə' Diozən' len yeziquə'əchlə beṉə' Izrael ca'. Na' bito əžɉa'acle laž beṉə' ca' cui zɉənaquə beṉə' Izrael, na' nic əžɉa'acle yež ca' zɉəchi' Samarian'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ḻe'e žɉa'ac porzə gan' ža' beṉə' Izrael beṉə' bazɉəmbiayi' c̱hedə' bitoṉə' so'ombi'e Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ḻe'e žɉa'ac na' ḻe'e žɉətix̱ɉue'e de que babžin ža Diozən' ben' zo yoban' ṉabi'e con notə'ətezə beṉə' əso'e latɉə. ");
INSERT INTO zavNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ḻe'e yeyon beṉə' chsa'acšene, na' ḻe'e yeyon beṉə' ca' chse'i yižgüe' de'en ne' ḻepr, na' ḻe'e yosban no beṉə' bagwsa'at, na' ḻe'e yebeɉ de'e x̱io' zɉəyo'o zɉəyaz ḻo'o yic̱hɉla'aždao' beṉə'. Diozən' babeṉe' le'e yeḻə' guac c̱he'enə' dadzə par gonḻe de'e quinga, de'e na'anə' ḻe'e gaclen beṉə' ca' dadzə. ");
INSERT INTO zavNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Bitobi gonḻe probnid gua'ale, ni mech de or, de pḻat, o de cobr ḻo'o bols mech c̱helen' lao co'ole nezən'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Na' nic gua'ale bsod, o yeto xcamisle, nic gua'ale yel, na' nic gox̱ə'əle garrot. Ca naquə le'e chonḻe xšina'anə' zaquə'əle par goṉ beṉə' de'e ye'eɉ gaole gan' seḻa'a le'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Na' gatə'ətezə syoda o yež gan' əžinḻe, ḻeṉab šə zo to beṉə' güen beṉə' yebei əgüialaogüe'e le'e liže'enə'. Na' na'atezə sole xte catə'əch yesa'acle. ");
INSERT INTO zavNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Na' catə' əžinḻe liže'enə', ḻe'e gguape' diox, na' ḻe'e ṉablažə' so cueze' binḻo len yic̱hɉla'ažda'ogüe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Na' šə na' nitə' beṉə' chse'enene' yesə'əzo yesə'əbezəga'aque' binḻo len yic̱hɉla'ažda'oga'aque'enə', na' gaquə can' əṉablažə'əle par yesə'əzo yesə'əbezəga'aque' binḻo. Pero šə bito no zo no chon ca so cueze' binḻo len yic̱hɉla'ažda'ogüe'enə', bito gaquə ca de'en bagwṉablažə'əlen'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Na' gatə'ətezə əžinḻe ga cui nono yebei əgüialao le'e, na' nic əgwzenague' c̱hele, ḻe'e yesa'ac liž be'enə' o yežən'. Na' catə' yesa'aclen', əgwsi'iṉs ṉi'alen' par yežib bišten' de'en gwžianṉə', nic̱h əgwlo'ile beṉə' ca' de que de'e malən' chso'one' cui chesə'əzenague' xtižə' Diozən' de'en cho'elen'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Diozən' bene' par byiṉɉ yi' na' sofr lao syoda Sodoman' na' syoda Gomorran' por ni c̱he de'en cui boso'ozenague' c̱he'. Na' de'e ḻi əchnia' le'e, catə' əžin ža gon Diozən' castigw zeɉḻicaṉe c̱he yoguə' beṉə' chso'on de'e malən', beṉə' ca' cui yosə'əgüialao le'e yesə'əzaquə'əzi'iche' clezə ca beṉə' ca' gwnitə' Sodoman' na' Gomorran'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ḻe'e gon xbab de que nada' əseḻa'a le'e žɉətix̱ɉue'ele xtiža'anə' len beṉə' ca' gwxaquə'əlebe ca bež, na' le'e gwxaquə'əlebele ca xilə' dao' ladɉoga'aque'enə', c̱hedə' beṉə' ca' se'enene' so'ote' le'e can' chso'on bež ca' chso'otəb xilə' dao'. Pero le'e cheyaḻə' gacle ḻechguaḻe beṉə' xenḻažə' na' ḻechguaḻe beṉə' bib par len ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nitə' beṉə' so'one le'e lao na' beṉə' gwnabia' ca' por ni c̱he de'en chonḻilažə'əle nada' na' yesə'əyine' le'e ḻo'o yo'odao' c̱hega'aque' ca'. De'e na'anə' ḻe'e c̱hilɉlažə' naclən' gonḻe par nic̱h cui gacle lao na' beṉə' contr ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nach ḻeczə por ni c̱he de'en chonḻilažə'əle nada' nitə' beṉə' yesə'əc̱he'ex̱ax̱ɉe' le'e lao no goberṉador, na' lao no rei. Na' catə' gaquə ca' güe'ele xtiža'anə' lao beṉə' gwnabia' ca', beṉə' Izrael len beṉə' cui zɉənaquə beṉə' Izrael. ");
INSERT INTO zavNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pero catə' yesə'əc̱he'ex̱ax̱ɉe' le'e lao beṉə' ca', bito cuec yic̱hɉle nac yoži'ile xtižə'əga'aque'enə'. Lao or na'atezə Diozən' əgwzeɉni'ine' le'e bin' cheyaḻə' əṉale. ");
INSERT INTO zavNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","La' caguə le'ezən' güe'ele xtiža'anə', Spirit c̱he X̱acho Diozən' əgwzeɉni'in le'e bin' cheyaḻə' ṉale. ");
INSERT INTO zavNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","22","Na' yoguə' beṉə' ca' cui zɉənombia' Diozən' yesə'əgue'ine' le'e c̱hedə' chonḻilažə'əle nada', na' xte no bišə'əle na' no x̱ale so'one' le'e lao na' beṉə' par nic̱h so'ote' le'e, na' ḻeczə xte no xi'inḻe so'one' le'e lao na' beṉə' ca' so'ot le'e. Pero šə sotezə sole gonḻilažə'əle nada' xte catə'əch əžin ža gatle, nachən' žɉəyezole len Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Šə beṉə' nitə' to yež yesyə'əlague' le'e, ḻe'e yesa'actele na' žɉəya'acle ga yoblə. Diozən' bseḻe'e nada' golɉa' beṉac̱h, na' de'e ḻi chnia' le'e bitoṉə' yeyož güe'ele xtiža'a lao yoguə' beṉə' Izrael ca' catə'ən yida' de'e yoblə. ");
INSERT INTO zavNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ṉezele can' naquən catə' to beṉə' chsede' len to maestr, bito əṉacho naque' beṉə' blaoch ca maestrən', na' to mos bito naque' blaoch ca x̱ane'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Na' ben' chsed bito cheyaḻə' gone' xbab so'on beṉə' güench len ḻe' cle ca chso'one' len maestr c̱he'enə'. Ḻe'egatezə ca' mosən' bito cheyaḻə' gone' xbab so'on beṉə' güench len ḻe' cle ca chso'one' len x̱ane'enə'. Nitə' beṉə' chesə'əne' chona' txen len de'en chnabia' de'e x̱io' ca' de'en le Beelsebo. Nadan' naca' X̱anḻe na' naquəchxe yesə'əne' c̱he le'e nacle disipl c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Na' ḻa'aṉə'əczə yoso'oc̱hi' yoso'osaquə' beṉə' le'e laogüe de'en cui chse'eɉni'ine' de que chonḻe can' chene'e Diozən' bito žeble ḻega'aque'. Guaquə can' na dicho de'en na: “Yoguə'əḻoḻ de'en ngašə' ṉa'a gwžin ža la'alaon, na' yoguə əḻoḻ de'e cui no gwse'eɉni'i antslə ḻeczə gwžin ža se'eɉni'i beṉə' ḻen.” ");
INSERT INTO zavNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","De'e zan de'en chsed chlo'ida' le'e de'en cui chsed chlo'ida' yeziquə'əchlə beṉə'. Na' le'e ža, ḻegwsed ḻegwlo'in yoguə'əḻoḻ beṉə', na' ḻe'e gon par nic̱h beṉə' zan se'eɉni'ine'en. ");
INSERT INTO zavNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Bito cheyaḻə' žeble beṉə' ca' so'ot le'e, c̱hedə' ḻega'aque' bito gaquə bi so'onene' yic̱hɉla'ažda'olen'. Cheyaḻə' žeble Diozən', la' ḻen' nape' yeḻə' chnabia' par əgwžiayi'e cuerp c̱helen' len yic̱hɉla'ažda'olen' ḻo'o yi' gabiḻən'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ṉezecho de que byiṉ dao' ca' bitobi zɉəzaquə'ətequəb, pero bito ṉacho tob gat sin cui əṉeze X̱acho Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na' ca naquə chio'o ža, de'e tant chaque Diozən' c̱hecho xte ṉezene' baḻə yišə' yic̱hɉ to tocho žia ḻa'aṉə'əczə ṉezecho bito bi zɉəzaquə' yišə' yic̱hɉchon'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","De'e na'anə' bito žeble, c̱hedə' zaquə'əch le'e cle ca bia zan byiṉ dao'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Na' notə'ətezle šə cho'ele dižə' len beṉac̱hən' de que cheɉḻe'ele c̱hia', ḻeczə ca' nada' gua'a dižə' len X̱a'anə' ben' zo yoban' de que nacle xi'iṉa'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Na' notə'ətezle šə cho'ele dižə' len beṉac̱hən' de que bito cheɉḻe'ele c̱hia', ḻeczə ca' nada' gua'a dižə' len X̱a'anə' ben' zo yoban' de que bito nacle xi'iṉa'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Bito gonḻe xbab de que beṉə' ža' yežlyo nga yesə'əzo yesə'əbeze' binḻo len lɉuežɉga'aque' laogüe de'en bida'. Bito yesə'əzo yesə'əbeze' binḻo len lɉuežɉga'aque' laogüe de'en bida' sino yesə'ədiḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Laogüe de'en babida' yediḻə beṉə' byo len x̱e'enə' na' no'olən' len xne'enə', na' yediḻə xo'oliž beṉə' len taobin' c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Entr ḻo'o yo'ozəga'aque' yesyə'ənite'e contr. ");
INSERT INTO zavNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Notə'ətezle šə chaquele c̱he x̱ale o c̱he xna'ale mazəchlə can' chaquele c̱hia' nada' bito zaquə'əle par gacle disipl c̱hia'. Ḻe'egatezə ca' šə chaquele c̱he xi'iṉle mazəchlə can' chaquele c̱hia' ḻeczə bito zaquə'əle par gacle disipl c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Na' notə'ətezle šə laogüe de'en chaquele yoso'oc̱hi' yoso'osaquə' beṉə' le'e o so'ote' le'e to ḻe'e yag coroz de'e nan' bito chonḻilažə'əle nada', bito zaquə'əle par gacle disipl c̱hia' šə ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Notə'ətezə beṉə' chaquene' gone' par nic̱h cui c̱hi' saque'e o par nic̱h cui no so'ot ḻe', be'enan' cuiayi'. Na' notə'ətezə beṉə' chsanḻažə' cuine' c̱hi' saque'e o so'ot beṉə' ḻe' por ni c̱hia', be'enan' əbane' zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Notə'ətezə beṉə' yebeine' güialaogüe' le'e nacle disipl c̱hia', nadə'əczan' yebeine' güialaogüe' šə ca'. Na' šə yebeine' güialaogüe' nada' ḻeczə Dioz na'anə' əgüialaogüe', Dioz ben' bseḻə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Beṉə' ca' chso'e xtižə' Diozən', mbalaz gaquə c̱hega'aque' catə'ən yesyə'əžine' yoban', na' notə'ətezə beṉə' yebeine' güialaogüe' ḻega'aque', ḻeczə mbalaz soe' catə'ən yežine' yoban'. Na' mbalaz gaquə c̱he beṉə' ca' chso'on can' chazlažə' Diozən' catə'ən yesyə'əžine' yoban'. Na' notə'ətezə beṉə' yebeine' güialaogüe' ḻega'aque', ḻeczə mbalaz soe' catə'ən yežine' yoban'. ");
INSERT INTO zavNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Notə'ətezə beṉə' chnežɉue' ḻa'aṉə' tbaszə nis ye'eɉ be'enə' chonḻilažə' nada', de'e liczə gona' ca soe' mbalaz catə'ən yežine' yoban', ḻa'aṉə'əczə ben' bnežɉue' nisən' cuitec bi zaque'e len beṉac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Catə' beyož ben Jeso'osən' mendad can' so'on disipl c̱he' ca' šižiṉ, beze'e latɉən'. Na' gwyeɉe' yež ca' zɉəchi' do na' ɉəsed ɉəlo'ine' xtižə' Diozən' len beṉə' ca' ža'anə'. ");
INSERT INTO zavNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na' ca naquə Juanṉə' ben' bc̱hoa beṉə' nis, lao die' ližyan' benene' dižə' ca naquə yoguə' de'en chon Jeso'osən' ben' bseḻə' Diozən' par chaclene' ṉasyon Izraelən', nach Juanṉə' bseḻe'e c̱hopə disipl c̱he' ca' gan' zo Jeso'osən', ");
INSERT INTO zavNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ɉse'eže'ene': —¿Elen' ben' naquən əseḻə' Diozən' o šə soto' lez yidə beṉə' yoblən'? ");
INSERT INTO zavNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nach Jeso'osən' gože' ḻega'aque': —Ḻe'e žɉəya'ac na' ḻe'e žɉəyeyež Juanṉə' doxen can' chenele na' can' chle'ile chona'. ");
INSERT INTO zavNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bable'ile chona' par nic̱h baḻə beṉə' lc̱hoḻ chesyə'əle'ine', na' baḻə beṉə' coj chesyə'əde', na' yebaḻə beṉə' cuež chesyə'əyenene'. Na' ḻeczə bable'ile bena' par nic̱h baḻə beṉə' gwse'i yižgüe' de'en ne' ḻepr babesyə'əyaquene'. Bable'ile bosbana' baḻə beṉə' guat, na' babenele cho'a dižə' güen dižə' cobə c̱hia'anə' len beṉə' yašə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mbalaz zo beṉə' cheɉḻe'e de que Diozən' bseḻe'e nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nach catə' besyə'əsa'ac disipl c̱he Juanṉə', nach Jeso'osən' be'elene' beṉə' ca' zɉəndobən' xtižə' Juanṉə', gože' ḻega'aque': —¿Nacxa naquə ben' ɉəle'itgüeiczele latɉə dašən'? ¿Ešayec̱hə šayen chaque'? Bito. ");
INSERT INTO zavNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Nacxan' goque' catə' ɉəle'ilene'? ¿Enyaze' lachə' šao'? ¿Ešə bito? la' beṉə' ca' zɉənyaz lachə' šao' nite'e yo'o güenchgua ca no liž rei. ");
INSERT INTO zavNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Noxan' ɉəle'ilen' ža? ¿Eto profet ben' cho'e xtižə' Diozən'? De'e ḻi naque' to profet. Pero əchnia' le'e, caguə con to profetən'. ");
INSERT INTO zavNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","C̱he bengan' nyoɉən ḻe'e Xtižə' Diozən' nan: Nada' Dioz əseḻa'a to beṉə' cuialaogüe' güe'e xtižo'onə' par nic̱h ṉitə' beṉə' probnid par əso'elaogüe'e le' catə'ən yido'. ");
INSERT INTO zavNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","De'e ḻi əchnia' le'e, notono no beṉac̱h ṉe'e so beṉə' naquəch beṉə' blaoch ca Juan ben' chc̱hoa beṉə' nis. Na' notə'ətezəchlə beṉə' güe'e latɉə ṉabia' Diozən' ḻe', ḻa'aṉə'əczə bito naque' beṉə' blao, gwžin ža catə' šeɉni'ichene' c̱hia' clezə ca Juanṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Dezd catə'ən gwzolao Juanṉə' gwdix̱ɉui'e xtižə' Diozən' na' bc̱ho'e beṉə' nis xte ža ṉeža beṉə' zan choso'ozenague' xtižə' Diozən' na' chəsə'əyilɉlaže'e naclə so'one' par nic̱h ṉabia' Diozən' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Catə' cuiṉə' solao gwzene Juanṉə' xtižə' Diozən', con ḻei de'en bzoɉ de'e Moisezən' na' de'en boso'ozoɉ yoguə' profet ca', de'e ca'azən' bzeɉni'in chio'o c̱he Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Xtižə' Diozən' de'en nyoɉən nan de que yeto beṉə' yedəyen can' ben Ḻiazən' ben' be' xtižə' Diozən' cana'. Na' c̱he Juan na'anə' boso'ozoɉe' žalə' šeɉḻe'ele. ");
INSERT INTO zavNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ḻe'e žia nagle de'e chene, ḻegwzenag xtiža'anə'. ");
INSERT INTO zavNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Nac əgwsaquə'əlebetgüeida' le'e mbanḻe ṉa'a? Egwsaquə'əlebeda' le'e ca bidao' c̱hedə' cuiczə bi de žleb c̱hele. Ca naquə bidao' ca' catə' nitə'əbo' do gan' chac ya'a chse' lɉuežɉga'acbo': ");
INSERT INTO zavNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Bento' ḻegr, bito gwyo'olažə'əle, na' babento' bgüine bgüež, peor.” ");
INSERT INTO zavNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juanṉə' bide' laole nga. Bito güe'eɉ gwdaošaogüe'e can' chse'eɉ chsa'o beṉə' yoblə. Nach gwnale c̱he': “Yo'o yaz de'e x̱io'onə' yic̱hɉla'aždaogüe'enə'.” ");
INSERT INTO zavNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Na' nada', Diozən' bseḻe'e nada' golɉa' beṉac̱h. Na' chle'ile che'eɉ chaogua' can' che'eɉ chaole. Na' nale c̱hia' de que naca' beṉə' lia na' beṉə' güe'ezo, na' ḻeczə nale de que naca' migw c̱he beṉə' goc̱hixɉw ca' na' migw c̱he yeziquə'əchlə beṉə' ca' chso'on de'e mal. Pero na' nacbia' de que Dioz na'anə' naque' ḻe'ezelaogüe beṉə' sin' por ni c̱he can' chso'on beṉə' ca' choso'ozenag c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nach Jeso'osən' be'e xtižə' beṉə' ca' ža' yež ca' gan' bene' de'e zan de'e zaquə' yesyə'əbanene', na' gwdiḻe' ḻega'aque' c̱hedə' bito besyə'ədiṉɉene' xtoḻə'əga'aque'. Nach gwne': ");
INSERT INTO zavNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Probchguazə le'e beṉə' Corasin! ¡Probchguazə le'e beṉə' Betsaida! Beṉə' ca' nitə' Tiro na' Sidon ḻe'e besyə'ədiṉɉteine' xtoḻə'əga'aque'enə' žalə' blo'iga'acda'ane' yeḻə' guac c̱hia'anə' ca de'en bablo'ida' le'e. Žalə' goquə ca', sa'azlɉe' lachə' zešə' na' zosə'əža'alɉa cuinga'aque' de par nic̱h sa'acbe'i beṉə' de que babesyə'ədiṉɉene' xtoḻə'əga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Echnia' le'e saquə'əzi'ichle clezə ca beṉə! ca' nitə' Tiro na' Sidon catə' əžin ža gon Diozən' castigw zeɉḻicaṉe c̱he yoguə' beṉə' chso'on de'e malən'. ");
INSERT INTO zavNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Le'e nitə'əle Capernaunṉə', chonḻe xbabən' de que Diozən' goṉchgüe' le'e yeḻə' bala'aṉ, pero bito goṉe' le'e yeḻə' bala'aṉ, sino goṉe' le'e castigw zeɉḻicaṉe de'en cui cheɉḻe'ele c̱hia'. Žalə' bena' de'e zaquə' yesyə'əbane beṉə' ca' gwnitə' Sodoman' can' babena' laole nga, besyə'ədiṉɉene' xtoḻə'əga'aque'enə' žalə' ca' na' ṉe'e chi' syodan' žalə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Echnia' le'e, saquə'əzi'ichle clezə ca beṉə' ca' gwnitə' Sodoman' catə' əžin ža gon Diozən' castigw zeɉḻicaṉe c̱he yoguə' beṉə' chso'on de'e malən'. ");
INSERT INTO zavNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Na' lao orən' Jeso'osən' bene' orasyon lao Diozən' gwne': —X̱a', len' chnabi'o beṉə' ža' yoban' na' yežlyon'. Na' choṉa' yeḻə' chox̱cwlen c̱hio' de que babzeɉni'ido' baḻə beṉə' can' che'endo' so'e latɉə ṉabi'o yic̱hɉla'ažda'oga'aque'enə'. Bzeɉni'ido'on beṉə' ca' gwsa'acbe'i chəsə'əyažɉene' no əgwsed əgwlo'i ḻega'aque' na' bito bzeɉni'ido'on beṉə' ca' chso'on xbab de que zɉənaque' beṉə' sin' na' beṉə' zɉənyeɉni'i. ");
INSERT INTO zavNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Beno' ca' ža X̱a', c̱hedə' can' gwyazlažo'o. ");
INSERT INTO zavNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nach gože' beṉə' ca' ža'anə': —X̱a'anə' babene' lao na'a chona' par nic̱h chombia' beṉə' ḻe'. Ḻe' nombi'ayaṉe'e nada', na' nada' nombi'ayaṉa'a ḻe'. Na' beṉə' ca' bagwleɉa' par zɉənombi'e X̱a'anə', chona' par nic̱h zɉənombi'ene' na' notono no nochlə zɉənombia' X̱a'anə' na' ni nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ḻegonḻilažə' nada', le'e zole trist tant pesad chaquele chonḻe yoguə' de'e ca' chəsə'əne' chene'e Diozən' gonḻe. Nada' gona' ca sole mbalaz. ");
INSERT INTO zavNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ḻegon can' nona' mendad gonḻe na' ḻegwzenag de'en əgwzeɉni'ida' le'e. Nada' naca' beṉə' xenḻažə' na' beṉə' gax̱ɉwlažə' na' gona' ca sole mbalaz ḻo'o yic̱hɉla'ažda'olen'. ");
INSERT INTO zavNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Na' de'en nona' mendad gonḻe bito naquən pesad, na' de'en chsed chlo'ida' bito naquən zdebə. ");
INSERT INTO zavNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Na' gozaquən to ža dezcanz Jeso'osən' gwdie' len disipl c̱he' ca' gan' nyaž trigon', na' disipl c̱he' ca' gosə'ədone', nach gosə'əlec̱hɉe' trigon' na' gwsa'ogüe'en. ");
INSERT INTO zavNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Na' besə'əle'i baḻə beṉə' fariseo ca' can' gwso'on disipl ca', na' gwse'e Jeso'osən': —Bgüiašc can' chso'on disipl c̱hio' ca' žin de'e cui de lsens goncho ža dezcanzən'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nach gož Jeso'osən' beṉə' fariseo ca': —¿Ecabi za'alažə'əle de'en bablable can' ben de'e Rei Dabin' catə' ḻe' na' beṉə' lɉuežɉe' ca' gosə'ədone'? ");
INSERT INTO zavNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Gwyeɉe' ḻo'o yo'odao' əblaonə' nach gwdaogüe' yetxtil de'en bazɉəncua' bx̱oz ca' par Diozən', na' Dabin' bnežɉue'en gwsa'o beṉə' lɉuežɉe' ca' ḻa'aṉə'əczə cui zɉənaque' bx̱oz. Na' yetxtilən' cui de lsens par gao con to beṉə' ḻen letg bx̱oz ca' chac sa'ogüe'en. ");
INSERT INTO zavNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Ena' cabi za'alažə'əle ca de'en bablable ḻe'e ḻei de'en bzoɉ de'e Moisezən' can' chso'onczə bx̱oz ca' mendad c̱he yo'oda'onə' yoguə' ža dezcanz na' bito chso'omba'aṉe' žanə'. Na' bito ṉacho de que zɉənape' doḻə' por ni c̱he de'en chso'one' mendadən' ža dezcanzən'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Echnia' le'e, nada' zoa' nga zaquə'əcha' cle ca yo'odao' əblaonə'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Xtižə' Diozən' de'en nyoɉən nan: “Che'enda' yeyašə' yeži'ilažə'əle beṉə', caguə tlaozə gotle bia yix̱ə' par güe'ela'ole nada'.” Žalə' cheɉni'ile bi zeɉenṉə' bitolɉa əṉale c̱he disipl c̱hia' quinga de que zɉənape' doḻə' por ni c̱he šə bin' bagwso'one' ža dezcanzən'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Echnia' le'e de que Diozən' bseḻe'e nada' golɉa' beṉac̱h na' naquən lao na'a əṉia' bin' naquən güen goncho ža dezcanzən'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Na' catə' Jeso'osən' beze'e latɉən', na' gwyo'e to ḻo'o yo'odao' c̱hechon'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Na' ḻo'o yo'odao' na' zo to beṉə' bambižə šḻa'a ne'enə', nach beṉə' fariseo ca' gwse'e Jeso'osən': —¿Ede lsens par yeyoncho beṉə' xiṉɉ lao ža dezcanzən'? Gwse'ene' ca' nic̱h əžel de'en yesə'əde'ine' par əsa'ogüe' xya contr Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nach Jeso'osən' gože' ḻega'aque': —Šə nitə' xilə' dao' c̱hele na' əxopə tob ḻo'o yech zitɉw lao ža dezcanzən', ¿əcabi ḻe'e yebeɉteleb ḻo'o yechən' lao žanə'? ");
INSERT INTO zavNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Na' ḻechguaḻe zaquə'əch to beṉə' cle ca to xilə' dao'. Na' əchnia' le'e de lsens gaquəlencho beṉə' lao ža dezcanzən'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nach Jeso'osən' gože' be'enə' mbižə ne'inə': —Bḻi na'onə'. Nach catə' bḻi na' be'enə' ḻe'e beyacten can' naquə de'en yešḻa'a. ");
INSERT INTO zavNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Na' beṉə' fariseo ca', catə' besa'aque' yo'oda'onə' boso'oxi'e naclə so'one' par so'ote' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Gocbe'i Jeso'osən' can' boso'oxia' beṉə' fariseo ca', na' gwze'e gwyeɉe' ga yoblə. Beṉə' zan ɉəsə'ənaogüe'ene' nach Jeso'osən' beyone' beṉə' ca' chsa'acšene. ");
INSERT INTO zavNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Na' bene' mendad cui no əso'elene' dižə' de que Dioz nan' bseḻe'ene' par gaquəlene' ṉasyon c̱hega'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Bene' ca' par nic̱h goc complir can' bzoɉ de'e profet Isaiazən' c̱he' nan: ");
INSERT INTO zavNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Bengan' naque' xmosa', ben' gwleɉa' par gone' can' chazlaža'anə'. Chacchgüeida' c̱he', na' cheba chezaquə'əlaža'a len ḻe'. Na' nada' əseḻa'a Spirit c̱hia'anə' sotezə son len ḻe'. Na' beṉə' zɉənaquə beṉə' Izrael len beṉə' cui zɉənaquə beṉə' Izrael c̱hix̱ɉue'ine' ḻega'aque' naquən' cheyaḻə' so'one'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Bito gaquəyože' beṉə', nic gosye'e, na' nic əṉe' zižɉo lao lqueyən' par əse'ene beṉə' bin' ne'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Gwnežɉue' fuers balor c̱he beṉə' ca' chsa'acbe'i cui bi fuers balor c̱hega'aque' de par so'one' de'e güen, na' yezi'ixene' c̱he beṉə' ca' chsa'aquene' cui no yezi'ixen c̱hega'aque'. Yoguə' de'e can' gone' par nic̱h əžin ža so'on beṉac̱hən' can' chazlaže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Na' beṉə' zɉənaquə beṉə' Izrael len beṉə' cui zɉənaquə beṉə' Izrael yesə'əbeze' gaquəlene' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Na' zo to beṉə' Ic̱hoḻ, na' nacte' beṉə' mod, na' yo'o yaz de'e x̱io'onə' ḻo'o yic̱hɉla'ažda'ogüe'enə' na' ɉso'ene' lao Jeso'osən'. Na' Jeso'osən' bebeɉe' de'e x̱io'onə' yo'o yaz yic̱hɉla'aždao' be'enə' na' ḻe'e bele'iteine' na' gocte beṉe'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Na' yoguə' beṉə' ca' besə'əle'i can' goquə ḻechguaḻe besyə'əbanene'. Nach gwse' lɉuežɉga'aque': —¿Enaquəlizə be'enga ben' chbezcho yidə lao dia c̱he de'e Rei Dabin'? ");
INSERT INTO zavNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Na' catə' gwse'ene beṉə' fariseo ca' dižə' quinga gwse'e baḻə beṉə' ca': —Bitobi yeḻə' guac napə benga. Con chebeɉe' de'e x̱io' ca' len yeḻə' guac c̱he Beelsebo de'en chnabia' de'e x̱io' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Gocbe'i Jeso'osən' can' gwso'on beṉə' fariseo ca' xbabən', nach gože' ḻega'aque': —Šə beṉə' ža' to ṉasyon əsa'aque' c̱hoplə na' yesə'ədiḻe' entr ḻega'aque', əgwžiayi' ṉasyon c̱hega'aque' na'anə' šə ca'. Na' ḻeczə ca' šə beṉə' nitə' to syoda əsa'aque' c̱hoplə na' yesə'ədiḻe' entr ḻega'aque', ḻeczə cuiayi' syoda c̱hega'aque' na'anə' šə ca'. Na' šə to famiḻy əsa'aque' c̱hoplə na' yesə'ədiḻe' entr ḻega'acze' ḻeczə yenit famiḻy c̱hega'aque' na'anə' šə ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ḻe'egatezə ca' šə Satanasən' yebeɉ cuinei ḻo'o yic̱hɉla'aždao' beṉə' ḻeczə cuiayi' yeḻə' chnabia' c̱hei na'anə' c̱hedə' chdiḻəlen cuinei žalə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Le'e nale de que nada' chebeɉa' de'e x̱io' ca' yo'o yaz yic̱hɉla'aždao' beṉə' len yeḻə' guac c̱he Beelsebon'. Žalə' naquən can' nalenə', ḻeczə zeɉen de que beṉə' lɉuežɉle ca' chəsyə'əbeɉe' de'e x̱io' ca' zɉəyo'o zɉəyaz yic̱hɉla'aždao' beṉə' len yeḻə' guac c̱hei žalə' ca'. Beṉə' lɉuežɉle ca' se'e le'e de que clelən' nale c̱hia' nada' can' chebeɉa'anṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Na' de'en chebeɉa' de'e x̱io' ca' len yeḻə' guac c̱he Spirit c̱he Diozən', chlo'in de que babžin ža chene'e Diozən' güe'ele latɉə ṉabi'e le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ṉezecho notono no gaquə šo' liž to beṉə' gual par žɉəlane' šinḻaze' ca' sin cui əgwc̱heɉe' x̱an yo'onə' to do. Con šə əgwc̱heɉe'ene' guaquə cuane' šinḻaze' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Šə cui chonḻe txen len nada', chonḻe contr nada'. Na' šə cui chonḻe ca se'eɉḻe' beṉə' c̱hia' zeɉe dižə' de que chonḻe par nic̱h cui yoso'ozenague' c̱hia'anə'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","De'e na'anə' əchnia' le'e, bitə'ətezə de'e mal de'en chonḻe, na' bitə'ətezə dižə' mal de'e cho'ele, Diozən' yezi'ixene' c̱hele šə yediṉɉelen, pero notə'ətezle šə güe'ele dižə' contr Spirit c̱he Diozən' cuat yezi'ixen Diozən' c̱hele. ");
INSERT INTO zavNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Na' notə'ətezle šə güe'ele dižə' contr nada', ḻa'aṉə'əczə Diozən' bseḻe'e nada' golɉa' beṉac̱h, gozi'ixencze' c̱hele šə yediṉɉele can' nale, pero šə güe'ele dižə' contr Spirit c̱he Diozən', cuat yezi'ixen Diozən' c̱hele ṉa'a na' batə'ətezə. ");
INSERT INTO zavNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ṉezecho de que to yag frot naquən yag güen o cui naquən yag güen segon nac naquə frot c̱heinə'. Ca'aczən' nacbia' šə naquən' nacle. ");
INSERT INTO zavNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ḻechguaḻe beṉə' mal nacle. Bitoczə gaquə güe'ele dižə' güen c̱hedə' nacle beṉə' la'aždao' mal. Yoguə'əte dižə' de'e chchoɉ cho'achon' la' ḻo'o yic̱hɉla'ažda'ocho na'anə' za'an. ");
INSERT INTO zavNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","To beṉə' la'aždao' xi'ilažə' cho'e dižə' güen, c̱hedə' la' can' nan ḻo'o yic̱hɉla'ažda'ogüe'e nan' cho'e dižə'. Na' to beṉə' la'aždao' mal cho'e dižə' mal la' can' nan ḻo'o yic̱hɉla'ažda'ogüe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Na' əchnia' le'e, catə'ən əžin ža gon Diozən' castigw zeɉḻicaṉe c̱he yoguə' beṉə' ca' chso'on de'e malən', cana' yoguə'əḻoḻ beṉə' yesə'ədie' cuent c̱he yoguə' dižə' de'en bagwso'e de'e bitobi zɉəzaquə'ən. ");
INSERT INTO zavNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Na' segon dižə' de'en cho'ele Diozən' c̱hoglaogüe'en c̱hele šə naple doḻə' o šə cui naple doḻə'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nach baḻə beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən', na' beṉə' fariseo ca' gwse'e Jeso'osən': —Maestr, che'eneto' gono' to miḻagr par nic̱h əṉezeto' šə de'e ḻiczə Dioz nan' bseḻe'e le'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nach Jeso'osən' gože' ḻega'aque': —Le'e mbanḻe ṉa'a, naquəchguale beṉə' yic̱hɉla'aždao' mal, na' bito chzenagle c̱he Diozən'. Na' chṉable gona' to miḻagr par nic̱h əṉezele šə ḻe Dioz nan' bseḻe'e nada'. Pero bito gona' can' chṉablenə'. De'en gon Diozən' len nada' par nic̱h əṉezele de que ḻe'enə' bseḻe'e nada', gwxaquə'əleben ca de'en bene' len de'e profet Jonasən'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Antslə ze'e šeɉe' Niniben' Diozən' bene' par nic̱h to beḻ ya'a xen gwdebob ḻe', na' šoṉə ža šoṉə yel gwyo'e ḻo'o ḻe'ebən' catə' beyebəb ḻe' mbancze'. Na' ca naquə nada', gata' na' əgaša'a, na' te šoṉə ža šoṉə yel yebana' ladɉo beṉə' guat ca' par nic̱h əṉezele de que Diozən' bseḻe'e nada' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Na' catə' əžin ža gon Diozən' castigw c̱he yoguə' beṉə' chso'on de'e malən', ža na' yesyə'əban de'e beṉə' Ninibe ca' na' lao Diozən' yesə'əcuiše' le'e mbanḻe ṉa'a, c̱hedə' besyə'ədiṉɉene' xtoḻə'əga'aque'enə' catə' de'e Jonasən' gwdix̱ɉue'ine' ḻega'aque' can' na Diozən'. Ḻe'e gonšc xbab de que nada' zoa' nga naquəcha' beṉə' blaoch cle ca' de'e Jonasən', na' bito chzenagle c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na' ḻeczə žan' gon Diozən' castigw c̱he yoguə' beṉə' chso'on de'e malən', de'e no'olən' gwnabia' beṉə' ca' gwnitə' galən' chla' bgüižən' cuiten ḻichalə yebane' len yeziquə'əchlə beṉə' guat ca' na' lao Diozən' əgwcuiše' le'e mbanḻe ṉa'a. Ca naquə ḻe' ža, gwze'e Seba gan' naquə zitə'əchgua na' bide' nga par bzenague' dižə' sin' de'en be' de'e Rei Salomonṉə' len ḻe'. Na' nada' zoa' nga naquə'əcha' beṉə' blaoch cle ca de'e Salomonṉə', na' bito chzenagle c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Na' šə to de'e x̱io' de'en yo'o yaz yic̱hɉla'aždao' beṉə' yechoɉən nach lažə'ən nil na'aḻə yeyilɉən ga son mbalaz. Na' šə bitobi latɉə želən, nach ənan: ");
INSERT INTO zavNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“De'e yobləczə žɉəyežo'a yic̱hɉla'aždao' be'enə' gan' gwyo'o gwyaza' antslə.” Na' yeyeɉən de'e yoblə gan' zo ben'. Catə' le'in de que bacheyone' xbab güen na' bazoche' binḻoch na' caguə nochlə yo'o yaz yic̱hɉla'aždaogüe'enə' de'en əgwžon yeyo'on de'e yoblə, nach yeyo'on. ");
INSERT INTO zavNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nach žɉəyetobən yegažə de'e x̱io' ca' de'en zɉənaquə maləch ca ḻen na' txenṉə' so'on ḻo'o yic̱hɉla'aždao' be'enə'. Na' šə bagwso'onən ca', bachaquəch mal c̱he be'enə' clezə can' goc c̱he' antslə. Can' goquə len benga ḻeczə ca'anə' gaquə c̱he le'e mbanḻe ṉa'a de'en nactecle beṉə' la'aždao' mal. ");
INSERT INTO zavNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ṉecho'ete Jeso'osən' dižə' chsed chlo'ine' beṉə' zan quinga, catə' bžin xne'enə' len biše'e ca'. Na' zitə'ələ gosə'əbeze' gosə'əṉabe' so'elene' ḻe' dižə'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Entr beṉə' ca' nitə' choso'ozenague' xtižə' Jeso'osən', toe' gože' Jeso'osən': —Babla' xna'onə' len bišo'o ca' na' nite'e na'ate chse'enene' əso'elene' le' dižə'. ");
INSERT INTO zavNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nach Jeso'osən' gože' ben' gwna ca': —Nitə' beṉə' yoblə beṉə' zɉənaque' ca xna'anə' na' ca biša'a. ");
INSERT INTO zavNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nach bḻi na' Jeso'osən' blo'e disipl c̱he' ca' na' gože' be'enə': —Beṉə' quinga bazɉənaque' ca xna'a, na' zɉənaque' ca biša'a. ");
INSERT INTO zavNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Can' naquən len notə'ətezə beṉə' chso'one' can' chazlažə' X̱a' Diozən' ben' zo yoban', zɉənaque' ca xna'a na' ca biša'a na' ca zana'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Na' lao ža na'atezə gwza' Jeso'osən' yo'onə' ɉəchi'e cho'a nisda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nach tant beṉə' zan juisy besə'ədobə gan' chi'enə' xte benən byen gwyo'e gwchi'e to ḻo'o barcon'. Na' yoguə' beṉə' ca' besə'ədobən' gosə'ənite'e lao yoxən'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nach Jeso'osən' bsed blo'ine' ḻega'aque' len zan jempl. Na' be'elene' ḻega'aque' to jemplən', bsaquə'əlebene' xtižə' Diozən' ca trigon'. Nach gwne': —To beṉə' gwze'e zde' güen trigw. ");
INSERT INTO zavNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Na' lao chose' trigon' baḻən ɉəsə'əchazən cho'a nez, na' bia žia x̱ile'e bia chaš ḻe'e yoban' gwsa'ob ḻen. ");
INSERT INTO zavNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Na' yebaḻən' ɉəsə'əchazən ga naquə lao yeɉ, na' bitotec bi yo žia lao yeɉən', de'e na'anə' ḻe'e bla'acten. ");
INSERT INTO zavNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pero na' catə' beža'achgua besə'əcuadən na' ḻe'e gosə'əbižten, la' bitobi loi gwso'on. ");
INSERT INTO zavNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Na' yebaḻən besə'əgo'oṉən lao yo ga nc̱hix̱ə xsa yešə' na' bla'aquən txen len xsa yešə'ənə', na' besə'əḻolə' yag yešə' ca' ḻega'aquən'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Na' yebaḻən besə'əgo'oṉən lao yo šao' na' bla'aquən'. Baḻən gosə'əbian to gueyoa güeɉə, na' yebaḻən gosə'əbian gyon gueɉə, na' yebaḻən gosə'əbian šichoa güeɉə. ");
INSERT INTO zavNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Le'e žia nagle de'e chene, ḻegwzenag. ");
INSERT INTO zavNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nach gosə'əbiguə' disipl c̱he Jeso'osən' laogüe'enə' na' gwse'ene': —¿Bixc̱hen' chsed chlo'ido' beṉə' quinga len jempl? ");
INSERT INTO zavNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Na' Jeso'osən' gože' ḻega'aque': —Diozən' chone' par nic̱h le'e ṉezele de'en cui no gwṉeze antslə de que ḻe' ṉabi'e con notə'ətezə beṉə' soe' latɉə. Pero beṉə' cui chse'eɉḻe'e xtiža'anə' bito chac se'eɉni'ine' de que ṉabi'e beṉə' soe' latɉə. ");
INSERT INTO zavNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Notə'ətezə beṉə' choso'ozenague' ca de'en bachzeɉni'i Diozən' ḻega'aque', Diozən' gwzeɉni'ichene' ḻega'aque' par nic̱h šanch de'en se'eɉni'ine'. Pero na' notə'ətezə beṉə' cui choso'ozenague' c̱he Diozən' ca de'en chsed chlo'ine' ḻega'aque', Diozən' yeque'e de'en chse'eɉni'ine'enə' ḻa'aṉə'əczə latə'əlaszə de'en bagwse'eɉni'ine'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","De'e na'anə' chsed chlo'ida' beṉə' quinga len jemplən' c̱hedə' chesə'əle'ine' de'en chona' pero bito chsa'acbe'ine' bi zeɉen, na' ḻa'aṉə'əczə chse'enene' xtiža'anə', bito chse'eɉni'ine'en. ");
INSERT INTO zavNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Len beṉə' quinga bachac complir can' bzoɉ de'e profet Isaiazən', gan' nan: De'e ḻi yenele, pero cabi šeɉni'ile bi zeɉe de'en yenele. Na' de'e ḻi le'ile, pero cabi gacbe'ile bi zeɉen de'en le'ilen'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Beṉə' Izrael quinga cuiczə bi rson chsa'aze', bac̱h nažɉoczə yic̱hɉla'ažda'oga'aque' na'anə'. Chse'enene' pero bito chse'eɉni'ine' bin' zeɉe de'en chse'enene'. Na' chesə'əle'ine' pero cabi chsa'acbe'ine' bi zeɉe de'en chəsə'əle'ine'enə' c̱hedə' bazɉənaque' beṉə' la'aždao' žod. Žalə' bito zɉənaque' beṉə' la'aždao' žod, gwse'eɉni'ine' bi zeɉen de'en chse'enene'enə', na' sa'acbe'ine' bi zeɉe de'en chesə'əle'ine'enə'. Gosyə'ədiṉɉlɉei xtoḻə'əga'aque'enə', na' gwso'elɉe' latɉə yocobə Diozən' yic̱hɉla'ažda'oga'aque'enə' žalə' chse'eɉni'ine'en na' žalə' chsa'acbe'ine'en. ");
INSERT INTO zavNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pero na' le'e ža, ḻechguaḻe mbalaz zole c̱hedə' chle'ile de'e ca' chona' na' chacbe'ile bi zeɉen, na' chzenagle xtiža'anə' na' cheɉni'ilen. ");
INSERT INTO zavNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","De'e ḻi əchnia' le'e, zan de'e profet na' zan de'e beṉə' ca' yeziquə'əchlə beṉə' boso'ozenag c̱he Diozən' cana' gwse'enene' yesə'əle'ine' de'en chle'ile, pero bitoch goḻə' yesə'əle'ine'en. Na' gwse'enene' əse'enene' de'en chenele pero bito goḻə' se'enene'en. ");
INSERT INTO zavNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Na' le'e ḻegwzenag, quingan' zeɉe jempl c̱he beṉə' güen trigon'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Xtižə' Diozən' gwxaquə'əleben ca de'en byažən'. Nitə' beṉə' chse'enene' dižə' can' chon Diozən' chnabi'e con notə'ətezə beṉə' chso'e latɉə, pero bito chse'eɉni'ine'en, na' chžin gwxiye'enə' chonən par nic̱h cuich choso'ozenague' c̱he xtižə' Diozən'. De'e na'anə' gwxaquə'əlebəga'aquene' ca trigon' de'en ɉesə'əchaz cho'a nezən'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Na' nitə' beṉə' chse'ene xtižə' Diozən' na' šložga chesyə'əbeine' chso'one'en c̱hega'aque'. Na' catə' choso'oc̱hi' choso'osaquə' beṉə' ḻega'aque' par nic̱h cui se'eɉḻe'e xtižə' Diozən', ḻe'e chesyə'əbeɉyic̱hɉtie' cuich choso'ozenague' c̱hei. Na' de'en chso'one'en gwxaquə'əleben ca de'en chac c̱he trigon' de'en besə'əgo'oṉən lao yeɉ. ");
INSERT INTO zavNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ḻe'egatezə ca' naquən len beṉə' ca' chse'ene xtižə' Diozən', pero na' lao mbanga'aque' yežlyo nga, chesyə'əlaḻ chesyə'əžeɉene' chso'on xmendadga'aque' por ni c̱he chse'enene' yesə'əni'e. Pero yoguə' de'en chso'one' chx̱oayaguən ḻega'aque', chonən par nic̱h cui c̱ha'oxen xtižə' Diozən' ḻo'o yic̱hɉla'ažda'oga'aque'enə'. Ca de'en chso'one'enə' gwxaquə'əleben ca de'en chac c̱he trigon' de'en besə'əgo'oṉən lao yo gan' nc̱hix̱ə xsa yešə'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero yebaḻə beṉə' chse'enene' xtižə' Diozən' na' chse'eɉni'ine'en na' choso'ozenague' c̱hei. Na' de'en choso'ozenague' c̱he xtižə' Diozən' gwxaquə'əleben ca trigon' de'en besə'əgo'oṉən lao yo šao'. Baḻən gosə'əbian to gueyoa güeɉə, na' yebaḻən gosə'əbian gyon güeɉə, na' yebaḻən gosə'əbian šichoa güeɉə. ");
INSERT INTO zavNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Gwde na' Jeso'osən' gozo'elene' beṉə' ca' yeto jempl, goze'e ḻega'aque': —Yeḻə' gwnabia' c̱he Dioz ben' zo yoban' gwxaquə'əleben ca de'e nga goquə. To beṉə' ɉeze' trigw biṉnə' yoba c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Na' do še'elə catə' cui no gwsa'acbe'i gwyeɉ to beṉə' contr c̱he' ɉeze' xsa bgüeyxtil gan' banazə x̱an' yežlyon' trigon', na' beyož goze' bgüeyxtilən' beze'e. ");
INSERT INTO zavNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Na' tši'izə bla'aquən, na' trigon' gwzolao chbian. Na' catə' ɉa'ac xmos x̱an trigon', gwsa'acbe'ine' nc̱hix̱ə trigon' len bgüeyxtil. ");
INSERT INTO zavNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nach ɉəya'aque' gan' zo x̱anga'aque'enə' par ɉəsyə'əyeže'ene': “Señor, ¿əcaguə trigw biṉnə' gozo' yoba c̱hio'onə'? ¿Bixc̱hen' nc̱hix̱ən len bgüeyxtilən'?” ");
INSERT INTO zavNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nach x̱anga'aque'enə' gože' ḻega'aque': “To beṉə' contr c̱hia'anə' ɉen ca'.” Nach xmose' ca' gwse'ene': “¿Eche'endo' əlažə'əto' bgüeyxtilən'?” ");
INSERT INTO zavNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nach x̱anga'aque'enə' gože' ḻega'aque': “Bito əḻažə'əlen. La' nxož əlažə'əlente trigon'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Lɉoyenṉə' par ṉa'a. Guaquə yesə'əcha'on txen, pero na' chona' mendad catə' bagoḻə yetoble cwsešən', cana' zgua'atec yebele bgüeyxtilən' na' gonḻen bnoɉ par əse'eyən. Nach te na' žɉəyetoble trigon' əgwcua'aša'olen.” ");
INSERT INTO zavNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Gwde na' gozo'elene' beṉə' ca' yeto jempl, gože': —Yeḻə' gwnabia' c̱he Dioz ben' zo yoban' gwxaquə'əleben ca to xsa moztas de'en gozə to beṉə' yežlyo c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Xsa moztasən' naquən ḻe'ebeyožə de'e dao' rizə' lao bitə'əchlə semiy. Pero na' catə' chla'an, chcha'ochən ca bichlə yix̱ə' cuan na' chaquən yag cha'o dao'. Na' xte bia ca' zɉəzo x̱ile'e chɉse'en ližda'oga'aquəb lao xoze'e ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nach gozoe' yeto jempl, gozne': —Yeḻə' gwnabia' c̱he Diozən' ben' zo yoban' gwxaquə'əleben ca xna' cuazin' de'en gwlec no'olən' len to rob yezɉ par nic̱h becha'o doxenən. ");
INSERT INTO zavNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yoguə' de'e quinga bsed blo'i Jeso'osən' beṉə' ca' besə'əžag gan' zo'enə'. Bsed blo'ine' ḻega'aque' porzə len jempl, bitobi bichlə gwne' par bzeɉni'ine' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ca' ben Jeso'osən' par nic̱h goc complir can' bzoɉ de'e profetən' c̱he', gan' nan: Egwsed əgwlo'iga'acda'ane' porzə len jempl, na' əgwzeɉni'iga'acda'ane' de'en cui no gwṉeze antslə de'en bgašə' dezd catə'ən gwxe yežlyon'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Na' catə' beyož bsed blo'i Jeso'osən' beṉə' ca' zɉəža' gan' zo'enə', bese'e ḻega'aque', na' beza' ḻe' len disipl c̱he' ca'. Na' catə' besyə'əžine' yo'o gan' nite'enə' besyə'əyo'e ḻo'inə'. Nach gosə'əbiguə' disipl c̱he' ca' cuite'enə' gwse'ene': —Bzeɉni'išguei neto' bi zeɉen jempl c̱he xsa bgüeyxtilən'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nach Jeso'osən' gože' ḻega'aque': —Quingan' zeɉen: Diozən' bseḻe'e nada' golɉa' beṉac̱h na' gwxaquə'əlebeda' ca ben' gozə trigw biṉnə'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Na' doxen yežlyo nga gwxaquə'əleben ca yoba gan' goze' trigw biṉnə', na' beṉə' ca' chso'e latɉə chnabia' Diozən' ḻega'aque' gwxaquə'əlebəga'aquene' ca trigw biṉnə'. Na' beṉə' ca' chso'e latɉə chnabia' de'e gwxiye'enə' ḻega'aque' gwxaquə'əlebəga'aquene' ca xsa bgüeyxtilən'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Gwxiye'enə' gwxaquə'əleben ca beṉə' contrən' gozə xsa bgüeyxtilən' gan' banyaž trigw biṉnə'. Na' žan' gaquə juisyən' gwxaquə'əleben ca tyempən' yosyo'otobe' trigon'. Na' anglən' zɉənaque' ca beṉə' ca' yosyo'otobə cwsešən'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Na' can' gac c̱he bgüeyxtilən' yosyo'otobe'en šeyən', can' gaquə c̱he beṉə' ca' chnabia' de'e gwxiye'enə' ḻega'aque' catə' əžin ža gaquə juisyən'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Diozən' bseḻe'e nada' golɉa' beṉac̱h na' catə' əžin žan', nada' əseḻa'a angl c̱hia' ca' par yosyo'otobe' yoguə' beṉə' ca' chesə'əgo'oyeḻe'e beṉə' yoblə so'one' de'e malən', na' yosyo'otobte' yeziquə'əchlə beṉə' ca' chso'on de'e malən'. Na' angl ca' yesyə'əbeɉe' ḻega'aque' nic̱h cuich ṉite'e txen len beṉə' ca' bagwso'e latɉə chnabia' Diozən' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nach yosə'əseḻe'e ḻega'aque' lao yi' gabiḻ gan' se'eye' zeɉḻicaṉe. Na' lao yesə'əžaglaogüe'enə' yesə'əbežyaše'e na' sa'oyeɉə leyga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Na' cana'ach X̱ancho Diozən' gone' par nic̱h beṉə' ca' chso'on de'e güenṉə' ṉite'e len ḻe' na' əsa'aque' ca yeḻə' chey che'eni' c̱he bgüižən' catə' yesyə'əžine' yoban' gan' chnabia' Diozən'. Le'e žia nagle de'en chene, ḻegwzenag. ");
INSERT INTO zavNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yeḻə' chnabia' c̱he Diozən' ben' zo yoban' gwxaquə'əleben ca de'e nga goquə. To beṉə' ɉəyedi'e mech xen de'e ngašə' to lao yežlyo. Nach bocuaše'en de'e yoblə. Na' de'e tant bebeine' de'en ɉəyedi'e mechən' nach ɉəyete'e yoguə'əḻoḻ bi de'e de c̱he' par nic̱h gwxi'e yežlyon' gan' ngašə' mechən'. Ca mbalazən' gwzo be'enə' can' mbalazən' nitə' beṉə' ca' chso'e latɉə chnabia' Diozən' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Na' yeḻə' gwnabia' c̱he Diozən' ben' zo yoban' ḻeczə gwxaquə'əleben ca de'e nga goquə. Zo to comersyant beṉə' cha'o chsi' na' cheyote'e perlas de'en ḻechguaḻe naquən xoche. ");
INSERT INTO zavNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Na' bželene' to perla de'e ḻechguaḻe zaquə'ən. Na' ḻeczə beyote'e yoguə'əḻoḻte de'en de c̱he' na' gwxi'e perlan'. Ca'aczən' gwxaquə'əlebe beṉə' ca' chsa'acbe'i de que de'e žialao əso'e latɉə ṉabia' Diozən' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Na' yeḻə' gwnabia' c̱he Diozən' ben' zo yoban' ḻeczə gwxaquə'əleben ca de'e nga goquə. Nitə' baḻə beṉə' gwxen beḻ ca' na' boso'ozaḻe'e yix̱ɉw beḻ c̱hega'aque'enə' ḻo'o nisda'onə' na' gwxenən yoguə' cḻas beḻ ya'a ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nach catə' bagwža' bia zanṉə' ḻo'o yix̱ɉon', besyə'əbeɉe' yix̱ɉon' yobižlə, na' gosə'əbi'e bia ca' zɉənaquə güen par əsa'ogüe', na' gosə'əgüe'eb ḻo'o žomə ca'. Na' bia ca' cui zɉənaquə güen, goso'oc̱ho'one'eb. ");
INSERT INTO zavNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Ca'aczən' gaquə c̱he yoguə' beṉə' catə'ən əžin ža gaquə juisyən'. Angl ca' yesə'əbeɉe' beṉə' mal ca' na' yosə'əzaḻe'e ḻega'aque' ḻo'o yi' gabiḻən' gan' yesə'əbežyaše'e na' sa'oyeɉə leyga'aque'enə' tant yesə'əžaglaogüe'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nach Jeso'osən' gože' disipl c̱he' ca': —¿Ezyeɉni'ile yoguə' de'e ca' bablo'ida' le'e? Nach gwse'ene': —Zyeɉni'ito'on X̱anto'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nach Jeso'osən' gože' ḻega'aque': —Notə'ətezle šə chac chsed chlo'ile Xtižə' Diozən' de'en byoɉ cana', na' šə ḻeczə chzenagle can' chsed chlo'ida' de que cheyaḻə' güe'ele latɉə ṉabia' Diozən' le'e, nachən' guac əgwsed əgwlo'ile beṉə' c̱hopten. Na' gwxaquə'əlebele ca to x̱an yo'o beṉə' napə yoguə' de'en chyažɉ chc̱hine famiḻy c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nach catə' beyož be'elen Jeso'osən' disipl c̱he' ca' jempl ca', beze'e latɉən' len disipl c̱he' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Na' beyeɉe' Nasaretən' gan' gwcha'ogüe'. Na' ɉəyesed ɉəyelo'ine' beṉə' ca' ḻo'o yo'odao' c̱hega'aque'enə'. Na' ḻechguaḻe besyə'əbanene' len xtiže'enə', na' gwse'e lɉuežɉga'aque': —¿Nacxa goquən' ṉezene' de'e ca' de'en naquə de'e sin'? na' ¿nacxa chac chone' miḻagr ca' chone'? ");
INSERT INTO zavNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nombi'achone', la' naque' xi'iṉ carpinterən'. Na' xne'enə' naque' no'olən' le' Maria. Nombi'acho beṉə' biše'e Jacobən', Jwsen', Simonṉə' na' Jodasən'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na' ḻeczə beṉə' zane' ca' nitə' lažcho nga. ¿Nacxa chaquən' cho'e dižə' ca' ža, na' chacte choe' miḻagr? ");
INSERT INTO zavNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Na' de'en gwso'one' xbab de que Jeso'osən' naque' con to beṉə' gwlaž c̱hega'aque', de'e na'anə' bito gwse'eɉḻe'e c̱he'. Nach gože' ḻega'aque': —Ḻa'aṉə'əczə beṉə' zan chse'eɉḻe'e c̱he beṉə' ca' chso'e xtižə' Diozən' na' chso'e ḻega'aque' yeḻə' bala'aṉ, beṉə' gwlaž c̱hega'aque' ca' na' famiḻy c̱hega'aque' ca' bito chse'eɉḻe'e c̱hega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Na' Jeso'osən' bene' con to c̱hopzə miḻagr Nasaretən' c̱hedə' bito gwse'eɉḻe'e c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Na' ca nan' Erodən' ben' naquə goberṉador c̱he Galilean', benene' dižə' ca naquə yoguə'əḻoḻ de'e güen de'en chon Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nach gože' xmose' ca': —Bengan' de'e Juanṉə' ben' bc̱hoa beṉə' nis. Babebane' ladɉo beṉə' guat ca' na' de'e na'anə' chac chone' miḻagr ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Quingan' goquə gwso'ote' Juanṉə': Erodən' beque'e Erodiasən' ca xo'ole', len Erodiasən' naque' xo'olə Lip biše'enə'. Na' Juanṉə' gože' Erodən': “Malən' beno' beca'o no'ol c̱he beṉə' bišo'on par naque' xo'olo'.” Na' de'en gož Juanṉə' Erodən' ca' de'e na'anə' Erodən' bene' mendad gosə'əzene' Juanṉə' na' gosə'əgüe'ene' ližya na' bosə'əc̱heɉe' ṉi'ane'e ca' gden. ");
INSERT INTO zavNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erodən' gone'ene' gote' Juanṉə', pero bitobi benene' ḻe' c̱hedə' bžebe' bi so'on beṉə' ca' gwse'eɉḻe'e c̱he Juanṉə' de que cho'e xtižə' Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pero na' catə' gwso'one' lṉi ža la Erodən', bi'i no'ol c̱he Erodiasən' bya'abo' lao beṉə' ca' gwnitə' lṉinə'. Na' ḻechguaḻe bebei Erodən' can' bembo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Na' tant beyazlažə' Erodən' can' bya'a no'ol güegon', bzoe' jorament de que əgwnežɉue'ebo' bitə'ətezə əṉabebo' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na' por consejw c̱he xna'abo'onə' gožbo' Erodən': —Beṉ nada' ṉa'atec ṉa'a yic̱hɉ Juanṉə' ben' chc̱hoa beṉə' nis žian to lao plat. ");
INSERT INTO zavNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Na' gwzo Erodən' trist catə' beyož gož no'ol güegon' ḻe' ca', pero na' ca naquə babzoe' jorament len ḻebo' lao beṉə' ca' zɉənaquə combidən', benšaze' mendad gaquə can' gwṉabe no'ol güegon' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ca' goquən' bene' mendad ɉəsə'əc̱hogue' yen Juanṉə' ḻo'o ližya gan' yo'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Na' boso'ožie' yic̱hɉ de'e Juanṉə' to lao plat par ɉso'en lao bi'i no'olən' na' bnežɉwbo'on xna'abo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nach disipl c̱he de'e Juanṉə' ɉəsyə'əxi'e cuerp c̱he'enə' na' ɉəsə'əcuaše'en. Gwde na' ɉa'aque' gan' zo Jeso'osən' na' ɉse'eže'ene' can' bagoquən'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Na' catə' bene Jeso'osən' can' goquə c̱he de'e Juanṉə', beze'e latɉən' len disipl c̱he' ca' na' besyə'əyo'e to ḻo'o barcw par ɉəya'aque' latɉə dašən' de'en de yešḻa'alə nisda'onə'. Na' beṉə' ca' ža' yež ca' zɉəchi' gaḻə'əzə nisda'onə' gwse'enene' rson galən' bazɉəda Jeso'osən'. Na' gwsa'aque' lažga'aque'enə' ɉa'aque' yobižlə ɉəsə'əšague' Jeso'osən' yešḻa'alə nisda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Na' catə' bžin Jeso'osən' cho'a nisda'onə', ble'ine' beṉə' zan ca' na' beyašə' beži'ilaže'e ḻega'aque'. Na' beyone' yoguə' beṉə' ca' chsa'acšene. ");
INSERT INTO zavNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Na' catə' bachaḻ, gosə'əbiguə' disipl c̱he' ca' laogüe'enə', na' gwse'ene': —Zocho to latɉə ga cui no nḻa', na' bagwde or par gaocho xgüe. Bseḻə' beṉə' quinga yež ca' de'en zɉəchi' gaḻə'əzə par nic̱h žɉəsə'ədilɉe' de'e se'eɉ əsa'ogüe'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Na' Jeso'osən' gože' ḻega'aque': —Bito cheyaḻə' žɉəya'aque'. Ḻe'e güe'ega'aque' de'e se'eɉ əsa'ogüe'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nach gwse'ene': —C̱hopga beḻ ya'a c̱hechon' de na' gueyə'əga yetxtil. ");
INSERT INTO zavNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nach Jeso'osən' gože' ḻega'aque': —Ḻe'e žɉəx̱i'in ni. ");
INSERT INTO zavNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nach ben Jeso'osən' mendad gosə'əbe' beṉə' zan ca' lao yixye daquə'ənə'. Na' gwxi'e yetxtil ca' gueyə' na' beḻ ya'a ca' c̱hopə. Na' bgüie' yobalə be'e yeḻə' chox̱cwlen c̱he Diozən'. Gwde na' bzoxɉe'en nach bnežɉue'en disipl c̱he' ca' par gosə'əyise' c̱he c̱he beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Na' yogue'e gwsa'ogüe'en xte ca gwse'elɉene'. Nach pedas ca' de'en besyə'əga'aṉnə', bosyo'otobe'en, na' goquən šižiṉ žomə. ");
INSERT INTO zavNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Na' beṉə' ca' gwsa'o yetxtilən' naquə ca do gueyə' mil beṉə' byo cui cuent no'olə na' cui cuent bidao'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Gwde na' Jeso'osən' bene' mendad yesyə'əyo'o disipl c̱he' ca' ḻo'o barcon' par yesyə'əbialaogüe' yesyə'əḻague'e yešḻa'alə nisda'onə' žlac bega'aṉ ḻe' bzeine' beṉə' zan ca' dižə'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Na' beyož bzei Jeso'osən' beṉə' ca' dižə', gwloe' to lao ya'a par ɉene' orasyon toze'. Dezd goḻte gwzo tozə Jeso'osən' lao ya'anə'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Na' ca naquə barcon' gan' zesyə'əyo'o disipl c̱he' ca', bazdan gwchoḻte nisda'onə', nžiguə'əx̱ax̱ɉ nisən' ḻen c̱hedə' chas chatə' nisda'onə' por ni c̱he chec̱hɉ be'enə' clelə. ");
INSERT INTO zavNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Na' do šbaḻ beyetɉ Jeso'osən' ya'anə' na' gwze'e tlao nisda'onə' par gwyeɉe' galən' zɉa'ac disipl c̱he' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Na' catə' besə'əle'i disipl c̱he' ca' ḻe' zde' lao nisda'onə', ḻechguaḻe besə'əžebe' xte gwso'osye'e gosə'əne': —¡To beṉə' guat chle'icho chda tlao nisən'! ");
INSERT INTO zavNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Na' ḻe'e boḻgüižte Jeso'osən' ḻega'aque', gože': —Ḻeyebei. Nada'anə'. Bito žeble. ");
INSERT INTO zavNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nach Bedən' gože'ene': —X̱anto', šə ḻe le'enə', gwna nada' sa'a tlao nisda'onə' yida' gan' zo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nach gož Jeso'osən' ḻe': —Da Bed. Na' ḻe'e bchoɉte Bedən' ḻo'o barcon' na' gwzolao gwze'e tlao nisda'onə' par zde' gan' zo Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero na' catə' gocbe'ine' ca fuertən' chec̱hɉ be'enə', bžebe' na' gwzolao chyiše'e ḻo'o nisən'. Nach bisye'e gože' Jeso'osən': —X̱ana', bosla nada', bachetɉa' xan nisən'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Na' ḻe'e bḻite na' Jeso'osən' bex̱e'ene'. Nach gože' Bedən': —Bixc̱hen' gocžeɉlažo'o? Gwyeɉḻe'ech c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Na' catə' beyo'o Jeso'osən' len Bedən' ḻo'o barcon', ḻe'e gwlezte be'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Na' beṉə' ca' ža' ḻo'o barcon' gwso'elaogüe'e Jeso'osən', gwse'ene': —De'e ḻiczə len' naco' Xi'iṉ Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nach gwza'ach barcon' xte bžinən cho'a nisda'onə' to latɉə de'en nzi' Genesaret. Na' besyə'əchoɉe' ḻo'o barcon'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Na' beṉə' ža' do Genesaretən' besyə'əyombi'e Jeso'osən', na' bosə'əseḻe'e rson yoguə' yež ca' de'en zɉəchi' gaḻə'əzə de que Jeso'osən' babžine' lažga'aque'enə'. Na' beṉə' ca' ža' yež ca' gosə'əc̱he'e yoguə' beṉə' chsa'acšene lao Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nach gosə'əṉabene' Jeso'osən' šə güene'ene' yesə'əgane' lox xadoṉ c̱he'enə'. Na' yoguə' beṉə' ca' gosə'əgan ḻen besyə'əyaquene'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Na' baḻə beṉə' fariseo ca' na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' gwsa'aque' Jerosalenṉə' na' besə'əžine' gan' zo Jeso'osən', na' gwse'ene': ");
INSERT INTO zavNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Bixc̱hen' disipl c̱hio' ca' bito chesə'ənaogüe' costombr ca' de'en bosyo'ocua'aṉlen de'e x̱axta'ocho ca' chio'o? ¿Bixc̱hen' cui chosyo'one'e zan las antslə ze'e sa'ogüe' can' chonto'? ");
INSERT INTO zavNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nach Jeso'osən' gože' ḻega'aque': —Ca naquə le'e ža, ¿bixc̱hen' chbeɉyic̱hɉle cui chonḻe can' non Diozən' mendad goncho na' con naozechle costombr c̱helen'? ");
INSERT INTO zavNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Diozən' none' mendad can' goncho, gwne': “Le'e gwnežɉo yeḻə' bala'aṉ x̱axna'ale”, na' “Notə'ətezle šə chžia chnitə'əle x̱axna'ale cheyaḻə' gatle.” ");
INSERT INTO zavNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero le'e nale de que šə beṉə' əṉe' de que babnežɉue' Diozən' mech o bien de'en cheyaḻə' əgwnežɉue' x̱axne'enə' par gaquəlene' ḻega'aque', na' bitoch bi cheyaḻə' əgwnežɉue' x̱axne'e. ");
INSERT INTO zavNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Na' de'en chonḻe ca', bachonḻe ḻei c̱he Diozən' ca to de'e cui bi bi zaque'e nic̱h ca' naozechle costombr c̱helen'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Le'e nacle beṉə' gox̱oayag. Chonḻe cayaṉə'ən bzoɉ de'e profet Isaiazən' c̱hele, gan' nan: ");
INSERT INTO zavNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Beṉə' Izrael ca' chesə'əne' de que nada' Diozən' chso'elaogüe'e, pero caguə do lažə'əga'aque'en chso'elaogüe'e nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bitobi zeɉen de'en chso'elaogüe'e nada' c̱hedə' la' choso'osed choso'olo'ine' beṉə' costombr de'en gwsa'alɉlažə' beṉac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nach Jeso'osən' bozoḻgüiže' beṉə' zan ca' zɉənžaguən' par nic̱h gosə'əbigue'e laogüe'enə', na' gože' ḻega'aque': —Ḻegwzenag de'e nga əṉia' le'e nic̱h šeɉni'ilen'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Bito ṉacho de que de'en che'eɉ chaochon' chonən manch la'ažda'ochon'. Echnia' le'e, dižə' de'en chchoɉ cho'alen', ḻenṉə' chonən manch la'ažda'olen'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nach gosə'əbiguə' disipl c̱he Jeso'osən' laogüe'enə' gwse'ene': —¿Ebito gocbe'ido' de que beṉə' fariseo ca' ḻechguaḻe besə'əže'e catə' gwse'enene' xtižo'onə'? ");
INSERT INTO zavNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Na' Jeso'osən' gože' ḻega'aque': —Gwžin ža catə' X̱a' Diozən' ben' zo yoban' gwžiayi'e yoguə'əḻoḻ beṉə' cui choso'ozenag c̱he'. Egwžiayi'e ḻega'aque' can' choncho catə' chḻažə'əcho yix̱ə' ca' chla'ac ḻo'o yel. ");
INSERT INTO zavNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Lɉosə'əye beṉə' fariseo ca'. Zɉənaquəga'aque' ca to beṉə' lc̱hoḻ beṉə' chene'ene' cue'e nez yeto beṉə' lc̱hoḻ. Chso'onczə yic̱hɉlaoga'aque' cui choso'ozenague' c̱he Diozən' na' choso'osedene' beṉə' de'en cui naquə de'e ḻi. Ṉezecho de que beṉə' lc̱hoḻən' bito gaquə cue'e nez yeto beṉə' lc̱hoḻ la' txenṉə' žɉəsə'əbix̱e' to ḻo'o yech. ");
INSERT INTO zavNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nach Bedən' gože' Jeso'osən': —Bzeɉni'išguei neto' bi zeɉen de'en gwnao' de que de'en che'eɉ chaochon' bito chonən manch la'ažda'ochon'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nach gož Jeso'osən' ḻega'aque': —¿Eḻeczə lenḻe bito cheɉni'ile de'e quinga bagwnia' le'e? ");
INSERT INTO zavNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Ecabi ṉezele de que yoguə' de'en che'eɉ chaochon' chɉc̱he'en ḻo'o ḻe'echon' na' chžin or cheden? ");
INSERT INTO zavNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero əchnia' le'e, yoguə' dižə' de'en cho'echon' chəsə'əchoɉən yic̱hɉla'ažda'ochon', na' šə cho'echo dižə' malən', ḻen chso'onən manch yic̱hɉla'ažda'ochon'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Na' ḻo'o yic̱hɉla'aždao' beṉac̱h na'anə' chchoɉ yoguə' xbab mal quinga, ca de'en nan so'ote' beṉə', na' nan yoso'ogo'o xtoga'aque', na' nan yesə'əbeɉyic̱hɉ no'ol c̱hega'aque' o ben' c̱hega'aque' par yesyə'əzolene' beṉə' yoblə na' nan yesə'əbanga'aque' bi de c̱he beṉə', na' nan so'onḻažə'əga'aque', na' nan yoso'ožia yoso'onite'e lɉuežɉ beṉac̱hga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Xbab mal ca' zɉənac ca' chso'onən manch yic̱hɉla'ažda'ochon'. Na' bito əṉacho de que de'en cui chona'acho zan las antslə ze'e gaocho chonən manch yic̱hɉla'ažda'ochon'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Beza' Jeso'osən' latɉən' len disipl c̱he' ca' par ɉa'aque' gaḻə'əzə gan' mbane Tiro na' Sidon. ");
INSERT INTO zavNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Na' to no'olə beṉə' cui naquə beṉə' Izrael, gwze'e gan' mbane Tiro na' Sidon par ɉəšague' Jeso'osən'. Na' gwṉe' zižɉo gože' Jeso'osən': —X̱ana', le' naco' xi'iṉ dia c̱he de'e Rei Dabin'. Beyašə'əšguei neto'. To bi'i no'olə c̱hia' yo'o yaz to de'e x̱io' ḻo'o yic̱hɉla'ažda'obo'onə' na' ḻechguaḻe chžaglaobo'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero Jeso'osən' bito boži'e xtižə' no'olən'. Nach disipl c̱he Jeso'osən' gosə'əbigue'e cuite'enə' na' gwsa'atə'əyoine' ḻe' gwse'ene': —Bosa'ašga no'olən' la' con naogüe' chio'o na' chatə'əyoine' le' zižɉo par gaquəleno'one'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nach Jeso'osən' gože' ḻega'aque': —Diozən' bseḻe'e nada' gaquəlena' ṉasyon Izrael na'azən', la' ḻega'aque' gwxaquə'əlebəga'aquene' ca xilə' dao' bia zɉənaquəžeɉe. ");
INSERT INTO zavNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nach no'olən' bgüigue'e bzo xibe' lao Jeso'osən', na' gože'ene': —X̱ana' go'onšguei goclen neto'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Na' Jeso'osən' gože'ene': —Bito naquən güen yeca'acho yeḻə' guao c̱he xi'iṉcho na' əgwnežɉwchon gao xicoda'ocho. ");
INSERT INTO zavNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Na' gocbe'i no'olən' bsaquə'əlebe Jeso'osən' beṉə' ca' cui zɉənaquə beṉə' Izrael ca beco', nach gože'ene': —Ḻeiczədo' X̱ana'. Pero xicocho ca' guaquə əsa'ob pedas de'e chesə'əxopə lao yon'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nach Jeso'osən' gože'ene': —No'olə, ḻechguaḻe chonḻilažo'o nada'. Guaquəlencza' le' can' che'endo'. Na' lao or na' beyaque xi'iṉ no'olən'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Gwde na' Jeso'osən' na' disipl c̱he' ca' besa'aque' latɉən' na' gwso'e nezən' de'en zda tcho'a nisdao' Galilean'. Nach gwse'epe' to lao ya'a na' ɉesə'əchi'e lao ya'anə'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Na' besə'əžin beṉə' zan lao ya'a gan' zo Jeso'osən' len disipl c̱he' ca'. Zɉənc̱he'e no beṉə' coj, na' no beṉə' lc̱hoḻ, na' no beṉə' mod, na' no beṉə' nchog ṉi'ana'aga'aque', na' zɉəlen beṉə' chse'i gwde gwde yižgüe' na boso'onite'e ḻega'aque' lao Jeso'osən'. Na' Jeso'osən' beyone' yogue'e. ");
INSERT INTO zavNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Na' ḻechguaḻe besyə'əbane beṉə' ca' catə' besə'əle'ine' can' ben Jeso'osən' beyone' beṉə' ca'. Besyə'əbanene' can' besyə'əṉe beṉə' mod ca', na' besyə'əyaque beṉə' ca' zɉənchog no ṉi'ana'aga'aque'enə', na' besyə'əda beṉə' coj ca', na' besyə'əle'i beṉə' lc̱hoḻ ca'. Nach yoguə'əḻoḻ beṉə' ca' gwso'elaogüe'e Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Gwde na' Jeso'osən' goxe' disipl c̱he' ca' na' gože' ḻega'aque': —Ḻechguaḻe cheyašə'əda' beṉə' quinga. Bagoc šoṉə ža nite'e nga len chio'o, na' bitobi de de'e sa'ogüe'. Na' bito che'enda' yosa'aga'aca'ane' sin cui sa'ogüe' par nic̱h cui yesyə'əc̱hoḻene' tnezən'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nach disipl c̱he' ca' gwse'ene': —Gan' zocho nga naquən to latɉə ga cui nono nḻa'. ¿Gaxa əželecho de'e əsa'o yoguə' beṉə' zan quinga? ");
INSERT INTO zavNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nach Jeso'osən' gože' ḻega'aque': —¿Baḻə yetxtil c̱hechon' de? Nach gwse'ene': —Gažga yetxtil dao' zɉəde na' to c̱hopga beḻ ya'a dao'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nach Jeso'osən' bene' mendad yesə'əbe' beṉə' ca' lao yon'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Na' gwxi'e yetxtil dao' ca' gažə na' len beḻ ya'a dao' ca', nach be'e yeḻə' chox̱cwlen c̱he Diozən'. Gwde na' bzoxɉe'en bnežɉue'en disipl c̱he' ca' par gwso'e c̱he yoguə' beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Na' yogue'e gwsa'ogüe' xte ca gwse'elɉene'. Nach pedas ca' de'en besyə'əga'aṉnə' bosyɔ'otobə disipl ca' ḻen, na' goquən gažə žomə. ");
INSERT INTO zavNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Na' beṉə' ca' gwsa'o yetxtilən' naquə tap mil beṉə' byo, bito cuent no'olə na' bito cuent bidao'. ");
INSERT INTO zavNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nach Jeso'osən' bose'e beṉə' ca'. Gwde na' gwyo'e to ḻo'o barcw len disipl c̱he' ca' na' ɉa'aque' distrit gan' nzi' Magdala. ");
INSERT INTO zavNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Na' goquən' baḻə beṉə' fariseo ca' na' beṉə' sadoseo ca' gosə'əbigue'e gan' zo Jeso'osən'. Na' gosə'əṉabe' gone' to miḻagr de'en yesə'əle'ine' ḻe'e yoban' de'en gwsa'aquene' cui gaquə gone'. ");
INSERT INTO zavNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nach Jeso'osən' gože' ḻega'aque': —Catə' chle'ile nḻatɉəcha ḻe'e yoban' še'elə nach nale: “Goža'a gwx̱e c̱hedə' nḻatɉəcha.” ");
INSERT INTO zavNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na' šə chi' beɉw catə'ən che'eni' nach nale: “Guaquə zag, la' chi'ichgua beɉw.” Beṉə' gox̱oayag le'e. Ṉezele šə guaquə zag o šə guaquə zeyə' catə'ən chle'ile nac naquə ḻe'e yoban', pero cabi chacbe'ile bi zeɉe de'e ca' chon Diozən' tyemp nga zocho ṉa'a. ");
INSERT INTO zavNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Le'e mbanḻe ṉa'a ḻechguaḻe beṉə' la'aždao' mal nacle, na' bagwleɉyic̱hɉle Diozən'. De'e na'anə' chṉable gona' to de'e le'ile ḻe'e yoban' par nic̱h əṉezele šə Diozən' bseḻe'e nada'. Pero bito gona' can' chṉablenə'. De'en gon Diozən' len nada' par nic̱h əṉezele de que ḻe'enə' bseḻe'e nada' gwxaquə'əleben ca de'en bene' len de'e Jonasən' ben' be' xtižə' Diozən' cana'. Na' beyož gwna Jeso'osən' ca', beze'e len disipl c̱he' ca' gan' nitə' beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Na' catə' besə'əžine' yešḻa'alə nisdao' Galilean', disipl c̱he' ca' gwsa'acbe'ine' de que gwsa'anḻaže'e yetxtil de'en əsa'ogüe'. ");
INSERT INTO zavNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nach Jeso'osən' gože' ḻega'aque': —Ḻegapə cuidad len xna' cuazi c̱he beṉə' fariseo ca' na' c̱he beṉə' sadoseo ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pero disipl c̱he' ca' bito gwse'eɉni'ine' bi zeɉe de'en gože' ḻega'aque' ca', nach gwse' lɉuežɉga'aque': —Gwne' ca' c̱hedə' gonḻažə'əcho gua'acho yetxtilən'. ");
INSERT INTO zavNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Na' Jeso'osən' gocbe'ine' xbab de'en chso'one', nach gože' ḻega'aque': —¿Bixc̱hen' chonḻe xbab c̱he yetxtilən' de'en gonḻažə'əle? ¿Ecabi ṉe'e šeɉḻe'ele de que napa' yeḻə' guac par guaogua' le'e? ");
INSERT INTO zavNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ebito cheɉni'ile bi zeɉe miḻagr ca' chona'? na' ¿əbagonḻažə'əle can' bguaogua' gueya'a mil beṉə' byo len gueyə'əzə yetxtil dao'? ¿Ena' ḻeczə bito za'alažə'əle do baḻə žomə pedas yetxtil ca' betoble de'en besyə'əga'aṉ? ");
INSERT INTO zavNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Na' ¿c̱hexa tapa mil beṉə' byo ca' bguaogua' len gažə yetxtil dao'? ¿Eza'alažə'əle baḻə žomə pedas yetxtil can' betoble gwde besyə'ədaogüe'enə'? ");
INSERT INTO zavNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Bixc̱hen' con benḻe xbab c̱he yetxtilən' catə'ən gwnia' le'e gaple cuidad len xna' cuazi c̱he beṉə' fariseo ca' na' c̱he beṉə' sadoceo ca'? ");
INSERT INTO zavNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nach disipl c̱he' ca' gwsa'acbe'ine' de que Jeso'osən' caguə bi'e dižə'ən ca' c̱he xna' cuazin' de'en chəsə'əc̱hine' par checha'o yetxtilən' sino bi'e dižə'ən ca' par nic̱h cui yoso'ozenague' c̱he de'en choso'osed choso'olo'i beṉə' fariseo ca' na' beṉə' sadoseo ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jeso'osən' len disipl c̱he' ca' ɉa'aque' gan' mbane to syoda de'en nzi' Sesarea de Filipo. Nach Jeso'osən' gože' ḻega'aque': —De'e ḻi Diozən' bseḻe'e nada' golɉa' beṉac̱h. Pero ¿bi chesə'əna beṉə'? ¿non' naca' nada'? ");
INSERT INTO zavNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nach gwse'ene': —Baḻe' chesə'əne' de que naco' de'e Juan ben' bc̱hoa beṉə' nis. Na' yebaḻe' chesə'əne' de que naco' Ḻiaz ben' be' xtižə' Diozən' cana'. Na' yebaḻe' chesə'əne' de que naco' de'e profet Jeremias, o de que naco' yeto' beṉə' be' xtižə' Diozən' cana'ate. ");
INSERT INTO zavNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nach gože' ḻega'aque': —C̱hexa le'e, ¿bi nale non' naca' nada'? ");
INSERT INTO zavNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Bedən' gože'ene': —Len' naco' Crist ben' gwleɉ Diozən' par gaquəleno' ṉasyon c̱hechon', na' naco' Xi'iṉ Dioz ben' zo zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nach Jeso'osən' gože'ene': —Simon xi'iṉ Jonas, mbalaz zo' de'en gwnao' de'e ca'. Notono beṉac̱h bzeɉni'i le' de'e ca', tozə X̱a' Diozən' ben' zo yoban', ḻe'enə' babzeɉni'ine'en le'. ");
INSERT INTO zavNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na' nada' ənia' de que len' lio' Bed na' zeɉen dižə' yeɉ. Na' can' nao' cheɉḻi'o c̱hia' gwxaquə'əleben ca to yeɉ gual de'e gaquə gwc̱hincho par lan yo'o. Na' nada' yetoba' beṉə' zan beṉə' se'eɉḻe'e de que naca' Xi'iṉ Dioz can' cheɉḻi'o c̱hia' par nic̱h ca' əsa'aque' tozə yoso'ocodə' lɉuežɉe' so'elaogüe'e nada'. Na' bitobi gaquə so'on de'e x̱io' ca' par nic̱h əžin ža catə' cuich no so'elao' nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Na' gona' lao na'o zgua'atec le' go'o xtiža'anə' len beṉə' zan par nic̱h əso'e latɉə ṉabia' Diozən' ḻega'aque', Dioz ben' zo yoban'. Na' ḻeczə gaquən lao na'o yo'o beṉə' ca' yoso'ocodə' lɉuežɉe so'ela'ogüe'e nada' bin' naquə güen so'one' na' ye'ega'aco'one' bi de'e ca' cui naquə güen so'one'. Na' Diozən' əgwzeɉni'ine' le' naquən' ye'ega'aco'one' par nic̱h ca' yediḻən len de'en na Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nach Jeso'osən' bene' mendad len ḻega'aque' de que ni toe' cui əso'e dižə' de que ḻe' na'anə' naque' Crist ben' gwleɉ Diozən' par gaquəlene' ṉasyon c̱hechon'. ");
INSERT INTO zavNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Na' ža na' Jeso'osən' gwzolaogüe' bsed blo'ine' disipl c̱he' ca' de que cheyaḻə' šeɉe' Jerosalenṉə' na' gaque' lao na' beṉə' golə blao c̱he ṉasyon Izrael c̱hechon', na' lao na' bx̱oz əblao c̱hecho ca', na' lao na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən'. Na' gwne' de que yoguə' beṉə' ca' de'e zan de'e yosə'əc̱hi' yosə'əsaque'e ḻe' na' əso'ote' ḻe'. Pero na' yeyoṉ ža yebane' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nach Bedən' gwleɉe' Jeso'osən' latə' dao' ca'aḻə na' gože'ene': —X̱ana', Diozən' gaquəlene' le'. Bitoczə gac c̱hio' de'e quinga nao' nga. ");
INSERT INTO zavNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero na' Jeso'osən' gwyec̱hɉe' bgüie' Bedən' na' gože' gwxiye'enə' de'en chnabia' yic̱hɉla'aždao' Bedən': —Gwchi'ižə' ca'aḻə Satanas. Nach gože' Bedən': —Bito che'endo' gona' can' non Diozən' mendad gona'. Chono' xbab c̱he de'en chacdo' gaquən güen na' bito chono' xbab naquən' chene'e Diozən' gaquə. ");
INSERT INTO zavNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Gwde na' Jeso'osən' gože' disipl c̱he' ca': —Notə'ətezle šə che'enele gonḻilažə'əle nada' na' gwzenagle c̱hia' cheyaḻə' əchoɉ yic̱hɉle de'en chene'ele gon cuinḻe par nic̱h gonḻe con can' chene'e Diozən' na' bitobi gaquele c̱he de'en c̱hi' saquə'əle, ḻa'aṉə'əczə šə so'ot beṉə' le'e to ḻe'e yag coroz con gonḻilažə'əle nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Notə'ətezə beṉə' chaquene' gone' par nic̱h cui c̱hi' saque'e o par nic̱h cui no so'ot ḻe', be'enan' cuiayi'. Na' notə'ətezə beṉə' chsanḻažə' cuine' c̱hi' saque'e o so'ot beṉə' ḻe' por ni c̱hia', be'enan' əbane' zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Bitobi de'e güen gaquə c̱he to beṉə' ḻa'aṉə'əczə ṉabi'e doxen yežlyon' šə cuiayi'e zeɉḻicaṉe, la' bitə'ətezə de'e gatə' c̱he', bito gaquəlenən ḻe' par nic̱h cui cui'ayi'e zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Diozən' bseḻe'e nada', golɉa' beṉac̱h, na' catə' yida' yežlyo nga de'e yoblə nsa'a yeḻə' chey che'eni' c̱he X̱a' Diozən' na' c̱hi'a angl c̱hia' ca', cana'ach gona' par nic̱h to to beṉac̱hən' ṉite'e mbalaz o yesə'əzi'e castigw segon de'e gwso'on to toga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Diozən' bseḻe'e nada' golɉa' beṉac̱h. Na' de'e ḻi chnia' ḻe'e, baḻle cabiṉə' gatle catə'ən le'ile nada' yida' de'e yoblə par yedəlo'a yeḻə' gwnabia' c̱hia'anə'. ");
INSERT INTO zavNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Gwde x̱op ža gwna Jeso'osən' de'e ca', gwc̱he'e Bedən' len Jacobən' na' Juan beṉə' bišə' Jacobən', ɉa'aque' to lao ya'a sibə. ");
INSERT INTO zavNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Na' lao nite'e lao ya'anə' beža' can' goquə Jeso'osən', beža'ateczə cho'alaogüe'enə' na' gwyey gwye'eni'in ca'aczən' chac bgüižən', na' xalane'enə' beyaquən šyiš xilə' ca'aczə be'eni'. ");
INSERT INTO zavNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Na' goquən lao nite'enə' conczə besə'əle'ine' de'e Moisezən' len profet Ḻiazən' ben' gwzo cana', na' chso'elene' Jeso'osən' dižə'. ");
INSERT INTO zavNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nach Bedən' gože'ene': —X̱anto', güenchgua zocho nga ṉa'a. ¿Egüe'endo' gonto' šoṉə ranš? ton par le', na' ton par Moisezən' na' yeton par Ḻiazən'. ");
INSERT INTO zavNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ṉe'e cho'ete' dižə'ənə' catə'əczla to beɉw de'en chactit bcuašə'ən ḻega'aque', na' ḻo'o beɉon' gwse'enene' gwna Diozən': —Benga Xi'iṉa' ben' chacchgüeida' c̱hei. Cheba chezaquə'əlaža'a len ḻe'. C̱he ḻe'enə' ḻe'e gwzenag. ");
INSERT INTO zavNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Na' catə' gwse'ene disipl ca' dižə' ca' ḻechguaḻe besə'əžebe', xte ɉesə'əchaze' gosc̱ho'alə lao yon'. ");
INSERT INTO zavNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nach bgüiguə' Jeso'osən' bx̱oa ne'enə' yic̱hɉga'aque'enə', na' gože': —Ḻeyeyas. Bito žeble. ");
INSERT INTO zavNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Na' catə' besyə'əgüie'enə', notono no nochlə besə'əle'ine' sino tozə Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Na' gwde na' lao chesyə'əyetɉe' ya'anə', gož Jeso'osən' ḻega'aque': —Ni tole cui güe'ele dižə' c̱he de'en bable'ile xte catə'əch bagwso'ot beṉə' nada' na' yebana' ladɉo beṉə' guat ca', nada' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nach disipl c̱he' ca' gwse'ene': —Beṉə' ca' choso'osed choso'olo'i ḻein' choso'osedene' neto' de que zgua'atec profet Ḻiaz ben' gwzo cana' cheyaḻə' yide' lao yežlyo nga de'e yoblə antslə ze'e yidə ben' əseḻə' Diozən' par gaquəlene' ṉasyon c̱hechon'. ¿Bixc̱hen' chəsə'əne' ca' ža? ");
INSERT INTO zavNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nach Jeso'osən' gože' ḻega'aque': —De'e ḻiczə chəsə'əne' de que zgua'atec yidə profet Ḻiazən' de'e yoblə ben' gwzo cana' par yeyone' yoguə'əḻoḻ de'e cheyaḻə' yeyac. ");
INSERT INTO zavNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero ṉa'a chnia' le'e de que babidə ben' bedəyen can' ben profet Ḻiazən', na' beṉə' Izrael gwlaž c̱hecho ca' bito gwsa'acbe'ine' de que ḻe' naque' ben' naquən yidə. Na' gwso'onene' ḻe' con can' gwse'enene' na' gwso'ote'ene'. Na' ca'aczən' so'one' len nada', Diozən' bseḻe'e nada' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nach gwsa'acbe'i disipl c̱he' ca' de que Jeso'osən' cho'e dižə' c̱he de'e Juanṉə' ben' bc̱hoa beṉə' nis. ");
INSERT INTO zavNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Na' catə' besə'əžine' gan' zɉənžag beṉə' zan, to beṉə' bšague' Jeso'osən' na' bzo xibe' laogüe'enə'. Na' gože'ene': ");
INSERT INTO zavNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—X̱ana' beyašə'əlažə'əšguei xi'iṉa' nga. Chazbo' šon na' ḻechguaḻe chžaglaobo' len ḻen. Na' zan las baɉchazbo' lao yi' na' ḻeczə ca' zan las babxopbo' ḻo'o nis. ");
INSERT INTO zavNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Baɉoa'abo' lao disipl c̱hio' ca', pero bito gwsa'aque' yesyə'əyone'ebo'. ");
INSERT INTO zavNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nach Jeso'osən' gože' beṉə' ca' ža'anə': —Le'e chonḻe clelə na' nalɉele. ¿Bixc̱hexaczxan' cui cheɉḻe'ele c̱hia'? Bachac sša zoa' napa' yeḻə' chxenḻažə' len le'e. ¿Batxan' šeɉḻe'ele c̱hia'? Nach gože' x̱a bida'onə': —Doa' bi'i c̱hio'on ni. ");
INSERT INTO zavNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nach Jeso'osən' gwdiḻe' de'e x̱io'onə' yo'o yaz yic̱hɉla'aždao' bida'onə' par nic̱h bechoɉən yic̱hɉla'ažda'obo'onə'. Na' lao or na' beyaquebo'. ");
INSERT INTO zavNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Na' gwde goc de'e ca', gosə'əbiguə' disipl c̱he Jeso'osən' gan' zoe' toze', na' gwse'ene': —¿Bixc̱hexaczxan' cui goquə yebeɉto' de'e x̱io'onə' yic̱hɉla'aždao' bida'onə'? ");
INSERT INTO zavNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jeso'osən' gože' ḻega'aque': —Bito goquə yebeɉlen c̱hedə' bito gwyeɉḻe'ele de que Diozən' gaquəlene' le'e. Xsa yag moztasən' naquən de'e dao' rizə'. Na' de'e ḻi chnia' le'e ḻa'aṉə'əczə šə de'en chonḻilažə'əle Diozən' gwxaquə'əleben ca to xsa moztasən' laogüe de'en cuiṉə' gonḻilažə'əchgualene' guac ye'ele ya'a nga: “Gwde gwzo de'e na'ate”, na' gaquə can' chonḻe mendadən'. Bito bi bi de de'e cui gaquə gonḻe con šə cheɉḻe'ele de que Diozən' chaclene' le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Na' par nic̱h yebeɉle de'e x̱io' ca' de'en zɉənaquə ca de'en bebeɉa' yic̱hɉla'aždao' bi'inə', cheyaḻə' co'o gwc̱heɉle cui ye'eɉ gaole na' gontezə gonḻe orasyon. ");
INSERT INTO zavNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Na' lao zɉezda' Jeso'osən' len disipl c̱he' ca' do gan' mbane Galilean', Jeso'osən' boszenene' ḻega'aque' de'en ze'e gac c̱he', gwne': —Diozən' bseḻe'e nada' golɉa' beṉac̱h, na' gaca' lao na' beṉə' ");
INSERT INTO zavNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","na' so'ote' nada'. Pero na' yeyoṉ ža yosban Diozən' nada' ladɉo beṉə' guat ca'. Nach disipl c̱he' ca' catə' gwse'enene' xtiže'enə', ḻechguaḻe gwnite'e trist. ");
INSERT INTO zavNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Na' catə' besyə'əžine' Capernaunṉə', baḻə beṉə' ca' chəsə'əc̱hixɉue' impuest de'en chəsə'əyixɉw to to beṉə' byo Izrael ca' par gast c̱he yo'odao' əblaonə' ɉa'aque' lao Bedən'. Na' gwse'ene': —Ca naquə maestr c̱helenə', ¿əgwyixɉue' impuest c̱he yo'oda'onə'? ");
INSERT INTO zavNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nach gož Bedən' ḻega'aque': —Gwyixɉue'en. Gwde na' Jeso'osən' len disipl c̱he ca' gwso'e ḻo'o yo'onə'. Nach Jeso'osən' ḻe'e gožte' Bedən': —¿Bi xbab chono', Bed? Ca naquə rei ca' nitə' yežlyo nga chesə'ənabi'e na' chso'one' byen chesə'əyixɉw beṉə' c̱he impuest. ¿Non' chəsə'əc̱hixɉue'en ža? ¿əfamiḻy c̱hega'aque' o šə beṉə' yoblə? ");
INSERT INTO zavNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nach Bedən' gože'ene': —Chəsə'əc̱hixɉue' beṉə' yoblə. Nach Jeso'osən' gože' Bedən': —Beṉə' zɉənaquə famiḻy c̱hega'aque' ca' bitobi chəsə'əyixɉue'. Na' ca naquə chio'o ža, naccho xi'iṉ Rei ben' zo yoban' na' bito cheyaḻə' c̱hixɉwcho impuest c̱he yo'oda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero na' par nic̱h notono no so'on xbab de que choncho contr yo'odao' əblaonə', c̱hixɉwcho impuestən'. Gwyeɉ cho'a nisda'onə', na' gwzaḻo'o yix̱ɉw beḻ c̱hio'onə', na' beḻ nech bian' seno' ḻo'o cho'ab na' əželdo' to mech. Na' yeyox̱o'on žɉətixɉo' impuest c̱hechon'. Gwdiḻəczən par c̱hixɉwcho impuest c̱he c̱hopcho. ");
INSERT INTO zavNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Na' ca orən' gosə'əbiguə' disipl c̱he Jeso'osən' cuite'enə', na' gwse'ene': —Entr neto' ¿noto' gaquəchto' blao catə'ən Diozən' ben' zo yoban' gone' par nic̱h solao ṉabi'o? ");
INSERT INTO zavNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Na' Jeso'osən' goxe' to bidao' na' bzeche'ebo' laoga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Na' gože' ḻega'aque': —De'e ḻi əchnia' le'e, notə'ətezle šə bito əgwša' xbab c̱helen' par əgwzex̱ɉw yic̱hɉle lao Diozən' can' chon bidao' nga chzex̱ɉw yic̱hɉbo' lao x̱axna'abo', bito gaquə sole len nada' catə' Diozən' ben' zo yoban' gone' par nic̱h solao ṉabi'a. ");
INSERT INTO zavNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Na' notə'ətezle šə babeyacle ca bidao' nga laogüe de'en chzex̱ɉw yic̱hɉle lao Diozən', banacle beṉə' blao len nada' catə' Diozən' ben' zo yoban' gone' par nic̱h solao ṉabi'a. ");
INSERT INTO zavNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Na' notə'ətezle šə chonḻe güen len notə'ətezə bidao' ca bi'i nga laogüe de'en chaquele c̱hia', chonczle güen len nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Probchguazə ben' chon par nic̱h əxopə to beṉə' chonḻilažə' nada' gone' de'e mal, ḻa'aṉə'əczə ben' əxopə bitotec bi zaque'e len beṉac̱hən'. Nca'alə xṉeze žalə' əgwcheɉ yene'enə' to yeɉ yišə na' žɉəxope' ḻo'o nisda'onə' na' gate', cle ca soe' əx̱ope' beṉə' gone' de'e malən'. ");
INSERT INTO zavNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Probchguazə le'e de'e zan de'e zɉəde yežlyo nga de'e chso'on par nic̱h gonḻe de'e mal. Bito ṉacho de que bitobi de de'e so'on par nic̱h əxopə le'e bachonḻilažə'əle nada'. Pero probchguazə beṉə' chon ca əxopə beṉə' yoblə gone' de'e malən'. ");
INSERT INTO zavNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Na' de'e na'anə' əchnia' le'e, šə de'en chonḻe len ṉi'ana'alen' chonən par nic̱h əxople gonḻe de'e malən' güenchlə žalə' əc̱hog ṉi'ana'ale ca' na' c̱ho'onḻen cle ca əxople gonḻe de'e malən'. Nca'alə xṉeze nacle beṉə' na' chog o beṉə' coj yežinḻe lao Diozən' na' əbanḻe zeɉḻicaṉe cle ca cuiayi'ilenḻen txen lao yi' gabiḻən'. ");
INSERT INTO zavNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na' šə de'en chle'ile len ɉelaole chonən par nic̱h əxople gonḻe de'e malən' yeɉni'alə žalə' cueɉlenṉə' na' c̱ho'onḻen, c̱hedə' nca'alə xṉeze nacle benə' lc̱hoḻ yežinḻe yoban' gan' zo Diozən' na' əbanḻe zeɉḻicaṉe, cle ca' cuiayi'ilenḻen txen lao yi' gabiḻən'. ");
INSERT INTO zavNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ḻe'e gon xbab c̱he beṉə' chso'onḻilažə' nada' beṉə' cuitec bi zɉəzaquə' len beṉac̱hən', par nic̱h cui gonḻe len notə'əteze' ca beṉə' cui bi bi zɉəzaque'e. Chnia' le'e, angl ca' chapə chye' ḻega'aque' nitə'ətezə nite'e lao X̱a' Diozən' yoban' gan' zo'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Na' ca naca' nada', Diozən' bseḻe'e nada' golɉa' beṉac̱h par nic̱h zedəlo'ida' beṉə' ca' bachəsə'əbiayi' de que nži'ilaža'a ḻega'aque'. Bseḻe'e nada' par gona' ca cui žɉəya'aque' lao yi' gabiḻən' šə so'onḻilaže'e nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Na' chnia' le'e, šə nitə' to gueyoa xilə' c̱hele na' gaquəžeɉe tob, ¿əcabi yocua'aṉle bia ca' taplalɉ tgualɉ do lao ya'a gan' zɉəža'ab na' žɉəyedilɉle bian' goquəžeɉenə' xte ca yeželeleb? ");
INSERT INTO zavNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na' əchnia' le'e, catə' yeželeleb, yebeichele de'en beželobən' clezə can' chebeile len bia ca' taplalɉ tgualɉ cui gwsa'acžeɉe. ");
INSERT INTO zavNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ca'aczə naquən len beṉə' ca' chso'onḻilažə' nada' beṉə' cuitec bi zɉəzaquə' len beṉac̱hən'. X̱acho Dioz ben' zo yoban' bito chene'ene' cuiayi' ni toga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Šə to beṉə' bišə'əle beṉə' bachonḻilažə' Diozən' chone' de'e malən' contr to le'e, tozle šeɉle žɉe'elenḻene' dižə' can' naquə de'en chone'enə' par nic̱h yediṉɉene'en, na' šə c̱haze' rson c̱he dižə' de'en žɉe'elenḻene' yezoe' binḻo len Diozən' de'e yoblə. ");
INSERT INTO zavNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero na' šə bito c̱haze' rson ca dižə' de'en žɉe'elenḻene', güench əc̱he'ele yeto o yec̱hopə beṉə' bišə'əle par nic̱h əsa'aque' testigw de que dižə' šao' bagotə'əyoile ben' yoša' xbab c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na' šə bitoczə gwzenague' c̱hele, ḻe'e güe' dižə' ca naquə de'en chone' lao yoguə'əle ncodə' lɉuežɉle cho'ela'ole Diozən'. Na' šə ni que gwzenagcze' c̱hele, cuich gonḻene' cuent entr le'e ncodə' lɉuežɉle cho'ela'ole Diozən'. Pero ḻegon cuent de que naque' txen beṉə' ca' cui chso'onḻilažə' Diozən', na' naque' txen len yeziquə'əchlə beṉə' ca' chso'on de'e malən' can' chonḻe xbab c̱he beṉə' goc̱hixɉw ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","De'e ḻi chnia' le'e, bitə'ətezə de'e əgwxia' le'e ncodə' lɉuežɉle cho'ela'ole Diozən' par əṉale naquən güen so'on beṉə' ca' əsa'ac txen len le'e, ḻeczə can' əṉa Diozən' ben' zo yoban'. Na' bitə'ətezə de'e əgwxiale əṉale cui naquən güen so'one', ḻeczə can' əṉa Diozən' ben' zo yoban'. ");
INSERT INTO zavNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Na' ḻeczə ca' chnia' le'e, šə c̱hople gwxiale bin' əṉable lao orasyonṉə', le'e nitə'əle yežlyo nga, X̱acho Diozən' ben' zo yoban' goncze' de'en əṉablenə'. ");
INSERT INTO zavNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Na' gan' nžag c̱hopə šoṉle cho'ela'ole nada', zocza' txen len le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nach Bedən' bgüigue'e gože' Jeso'osən': —X̱ana', šə beṉə' lɉuežɉa' chone' de'e mal len nada' tapteli, ¿baḻ las cheyaḻə' yezi'ixena' c̱he'? ¿əzelao do gaž las? ");
INSERT INTO zavNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nach Jeso'osən' gože'ene': —Bito nia' de que cheyaḻə' yezi'ixenḻe c̱he' zelao do gaž las. Pero de'en chnia' le'e, bito gonḻe cuent do baḻ las yezi'ixenḻe c̱he beṉə' lɉuežɉlen', con le'e yezi'ixentezə c̱he' yoguə' laste. ");
INSERT INTO zavNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ṉa'a ža, yeḻə' gwnabia' c̱he Diozən' ben' zo yoban' gwxaquə'əleben ca de'e nga goquə. Zo to rei ben' chsa'aḻə' xmose' ca' xmeche'enə'. Na' gone'ene' gone' cuent len ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Na' catə' gwzolaogüe' bezi'e cuent c̱he to toga'aque', zgua'atec bžin to xmose' ben' chaḻə' zan millon pes. ");
INSERT INTO zavNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Na' mosən' bito bi xmeche' gotə' par yonežɉue'en rein'. De'e na'anə' bene' mendad ta'oga'aque' len xo'olen', na' len xi'iṉga'aque' ca' na' len doxen de'e zɉədeine' par nic̱h gaquə yosyo'onežɉue' de'en chsa'aḻe'e c̱he rein'. ");
INSERT INTO zavNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nach mosən' bzo xibe' lao rein' gotə'əyoine' ḻe', gože'ene': “X̱ana', gwdapəšga yeḻə' chxenḻažə' len nada', na' yeyona' de'en chaḻa'a c̱hio'onə'.” ");
INSERT INTO zavNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nach rein' beyaše'ene' ḻe' na' bezi'ixene' c̱he doxen de'en chaḻe'enə' na' bsane' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pero na' catə' bechoɉe' liž rein', ḻe'e bežagte' yeto mos beṉə' chaḻə' c̱he' to c̱hop pes. Nach ḻe'e bṉizte' yene'enə' gože'ene': “Yeyoṉo' de'en chaḻo'o c̱hia'an ṉa'atec ṉa'a.” ");
INSERT INTO zavNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nach mos lɉuežɉen' bzo xibe' laogüe'enə', gože'ene': “Gwdapəšga yeḻə' chxenḻažə' c̱hia' na' yeyoṉa' doxen de'en chaḻa'a c̱hio'onə'.” ");
INSERT INTO zavNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero na' mos nechən' bito bzenague' c̱he mos lɉuežɉe'enə', ḻe'e gwyeɉte' ɉene' mendad gosə'əyix̱ɉue'ene' ližya xte ca gatə' de'en yonežɉue' c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Na' mos ca' yeḻa' catə' besə'əle'ine' can' ben mos nechən', ḻechguaḻe gwnite'e trist. Na' ɉa'aque' lao rein' ɉse'eže'ene' yoguə'əḻoḻ can' goquə. ");
INSERT INTO zavNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nach rein' goxe' mos nechən' laogüe'ene' de'e yoblə, na' gože'ene': “Le' naco' to mos malchgua. Nada' bezi'ixena' c̱he doxen de'en chaḻo'o c̱hia'anə' la' gotə'əyoido' nada' yezi'ixena' c̱hio'. ");
INSERT INTO zavNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Bixc̱hen' cui beyašə'əlažo'o mos lɉuežɉo' ben' chaḻe'e c̱hio'onə' can' beyašə'əlaža'a le'?” ");
INSERT INTO zavNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Na' de'e tant bža'a rein' bene'ene' lao na' beṉə' ca' par gosə'əyix̱ɉue'ene' ližya gan' əžaglaogüe' xte catə'əch bade de'en chaḻe'e c̱he rein'. ");
INSERT INTO zavNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nach Jeso'osən' gože' disipl c̱he' ca': —Can' gon X̱a' Diozən' ben' zo yoban' gone' castigw c̱he notə'ətezle cui chezi'ixenḻe c̱he lɉuežɉle do yic̱hɉ do lažə'əle bitə'ətezə de'en chso'onene' le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Na' Jeso'osən' catə' beyož gwne' de'e ca', beze'e Galilean' na' gwḻague'e yao Jordanṉə' par beyeɉe' gan' mbane Jodean'. ");
INSERT INTO zavNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Na' beṉə' zan ɉəsə'ənaogüe'ene', na' beyone' beṉə' ca' chsa'acšene. ");
INSERT INTO zavNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Na' beṉə' fariseo ca' ɉa'aque' gan' zo'enə' c̱hedə' gwse'enene' yesə'əbeɉe'ene' dižə' de'e yesə'əc̱hine' contr ḻe', nach gwse'ene': —¿Ede lsens par to beṉə' nšagna' yele'e xo'ole' šə bitə'ətezə de'en chone' cui cho'olažə' be'en c̱he'enə'? ");
INSERT INTO zavNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nach gože' ḻega'aque': —Bablabczle can' nyoɉ Xtižə' Diozən' nan de que catə'ən gwxe yežlyon' Diozən' bene' beṉə' nech ca' beṉə' byo na' no'olə. ");
INSERT INTO zavNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Na' gwna Diozən': “Beṉə' byonə' ḻe'e x̱axne'e par əgwšagne'e si'e to no'olə na' beṉə' ca' yoso'ošagna'anə' əsa'aque' tozə.” ");
INSERT INTO zavNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Bitoch əsa'aque' c̱hopə beṉə', sino que əsa'aque' tozə beṉə'. De'e na'anə' notono zaquə' yoḻe'e ḻega'aque' la' Dioz nan' banone' ḻega'aque' tozə cuerp. ");
INSERT INTO zavNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nach gwse'ene': —Šə ca' ža, ¿bixc̱hexan' ben de'e Moisezən' mendad catə' to beṉə' yele'e no'olə c̱he'enə', cheyaḻə' c̱has to act ga güe'en dižə' de que besyə'əle'enə'? ");
INSERT INTO zavNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jeso'osən' gože' ḻega'aque': —De'e Moisezən' be'e latɉə yela'a no'ol c̱helen' c̱hedə' nacle beṉə' yic̱hɉla'aždao' žod. Pero catə' Diozən' bene' beṉə' nech ca', bito ṉacho gwyazlaže'e yesyə'əla'aga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Echnia' le'e, notə'ətezə beṉə' chela'a no'ol c̱he'enə' par yeque'e no'olə yoblə, len ṉezene' de que no'ol c̱he'enə' bito naque' to no'olə go'o xtoi, tozəczə ca malən' chon be'enə' len de'en chon beṉə' chgo'o xtoe'. Na' notə'ətezə beṉə' yošagna'alene' to no'olə beṉə' bela'a ben' c̱hei ḻe', ḻeczə tozəczə ca malən' gone' len de'en chon be'enə' chgo'o xtoe'. ");
INSERT INTO zavNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nach disipl c̱he' ca' gwse'ene': —Šə can' naquən c̱he beṉə' byon' na' no'olən' naplən cuent cui no no gwšagna'. ");
INSERT INTO zavNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jeso'osən' gože' ḻega'aque': —Caguə yoguə' beṉə' chse'eɉni'ine' de'e ngan' sino beṉə' ca' babzeɉni'i Diozən' ḻega'aque' bi zeɉen. ");
INSERT INTO zavNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nitə' beṉə' cui nan yosə'əšagne'e c̱hedə' gwsa'alɉe' zɉənaque' beṉə' güiž, na' ḻeczə nitə' beṉə' cui yosə'əšagne'e laogüe de'en bazɉənon beṉə' ḻega'aque' güiž. Na' ḻeczə ca' nitə' beṉə' cui chesə'əšagne'e par nic̱h əso'elažə'əche' so'one' ca əsa'anch beṉə' ca' əso'e latɉə ṉabia' Dioz ben' zo yoban' ḻega'aque'. Ḻe'e gwzenag c̱he de'en bagwni'anə' šə baben Diozən' par nic̱h cheɉni'ilen. ");
INSERT INTO zavNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Na' ɉa'ac beṉə' əɉso'e bidao' lao Jeso'osən' par nic̱h əx̱oa ne'enə' yic̱hɉga'acbo'onə' na' gone' orasyon par ḻega'acbo'. Pero disipl c̱he' ca' gosə'ədiḻe' beṉə' ca' zɉənc̱he' bidao'. ");
INSERT INTO zavNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nach Jeso'osən' gože' disipl c̱he' ca': —Ḻe'e güe' latɉə la'ac bidao' ca' laogua' nga, na' cui əgwžonḻe. Na' əchnia' le'e beṉə' ca' chəsə'əzex̱ɉw yic̱hɉga'aque' lao Diozən' ca bidao' ca' chəsə'əzex̱ɉw yic̱hɉga'acbo' lao x̱axna'aga'acbo', ḻega'acze'enə' chso'e latɉə chnabia' Diozən' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Na' catə' beyož gwx̱oa na' Jeso'osən' yic̱hɉga'acbo'onə', bene' orasyon par ḻega'acbo', nach gwyeɉe' ga yoblə. ");
INSERT INTO zavNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Na' goquən' to beṉə' güego' bžine' gan' zo Jeso'osən', na' gože'ene': —Maestr, le' naco' beṉə' güen, gwna nada' bi de'e güenṉə' cheyaḻə' gona' par gatə' yeḻə' mban zeɉḻicaṉe c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jeso'osən' boži'e xtiže'enə', gože'ene': —¿Bixc̱hen' nao' de que beṉə' güen nada'? Dioz nan' naque' ḻe'ezelaogüe beṉə' güen. Pero na' šə che'endo' gatə' yeḻə' mban zeɉḻicaṉe c̱hio'onə', cheyaḻə' gono' can' na ḻei de'en bzoɉ de'e Moisezən'. ");
INSERT INTO zavNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nach be'enə' gože' Jeso'osən': —¿Noxan' de'e ca' nan ža? Nach Jeso'osən' gože'ene': —Cui gotle beṉə', cui co'o xtole na' cui cueɉyic̱hɉ be'en c̱hele o no'ol c̱hele par solenḻe beṉə' yoblə, cui cuanḻe, bito gacle testigw faḻs contr sa'alɉuežɉle. ");
INSERT INTO zavNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ḻe'e əgwnežɉo yeḻə' bala'aṉ x̱axna'ale, na' ḻegaque c̱he sa'alɉuežɉle can' chaquele c̱he cuinḻe. ");
INSERT INTO zavNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nach beṉə' güegon' gože' Jeso'osən': —Yoguə'əḻoḻ de'e quinga chzenaga' c̱hei dezd xcuidə'ətia'. ¿Bixa de'en chaquəch faḻt gona' ža? ");
INSERT INTO zavNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jeso'osən' gože'ene': —Šə de'e ḻiczə che'endo' gaco' cayaṉə'ən chene'e Diozən', ɉəyeyetə' bi de'e de c̱hio', na' mech de'en le'ido' c̱he de'e ca' bnežɉon beṉə' yašə' nach da len nada'. Na' catə' yežino' yoban' gan' zo Diozən', so' mbalaz. ");
INSERT INTO zavNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pero na' beṉə' güegon' beyož benene' can' gož Jeso'osən' ḻe', beza'achoe' trist c̱hedə' la' to beṉə' gwni'achguan'. ");
INSERT INTO zavNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Gwde na' gož Jeso'osən' disipl c̱he' ca': —De'e ḻi chnia' le'e, zdebəchgua naquən par to beṉə' gwni'a güe'e latɉə ṉabia' Diozən' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Na' ḻeczə chnia' le'e, zdebəchlə naquən c̱he to beṉə' gwni'anə' güe'e latɉə ṉabia' Diozən' ḻe' cle ca to camey teb to ḻo'o nag yešə'. ");
INSERT INTO zavNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Na' besyə'əbanchgüei disipl c̱he' ca' can' gwne'enə', nach gosə'əne': —Notono gaquə yechoɉ xni'a de'e malən' šə ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jeso'osən' bgüie' ḻega'aque' nach gože': —Ni to beṉac̱h cui gaquə yebeɉ cuine' xni'a de'e malən', pero Diozən' chaque'. Ḻe' chac chone' bitə'ətezə. ");
INSERT INTO zavNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nach Bedən' gože' Jeso'osən': —Neto' bagwleɉyic̱hɉto' famiḻy c̱heto' ca' na' len yoguə'əḻoḻ de'en deito' par chzenagto' c̱hio'. ¿Bi de'e güen gaquə c̱heto' laogüe de'en bagwleɉyic̱hɉto' famiḻy c̱heto' ca' na' len de'en deito'? ");
INSERT INTO zavNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jeso'osən' gože' ḻega'aque': —De'e ḻi chnia' le'e Diozən' bseḻe'e nada' golɉa' beṉac̱h na' catə' yocobe' yežlyon', nada' cui'a gan' chey che'eni' na' ṉabi'a, na' yoguə' le'e chonḻilažə'əle nada' cue'ele cuita'anə' na' ṉabi'ale txen len nada'. Na' le'e šižiṉle ṉabi'ale famiḻy ca' šižiṉ, beṉə' ca' zɉənaquə xi'iṉ dia c̱he de'e Izraelən'. ");
INSERT INTO zavNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na' notə'ətezle šə de'en chzenagle c̱hia' bagwleɉyic̱hɉle ližle, o bišə'əle, o zanḻe, o x̱axna'ale, o xo'olle, o xi'iṉle, o yežlyo c̱hele, Diozən' goṉe' le'e de'e zaquə'əche clezə ca de'e ca' na' beṉə' ca' gwleɉyic̱hɉle. Na' ḻeczə gon Diozən' par nic̱h əbanḻe zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Na' beṉə' zan beṉə' zɉənaquə blao ṉa'a gwžin ža catə' cuich əsa'aque' beṉə' blao. Na' beṉə' zan beṉə' cui zɉənaquə blao ṉa'a, gwžin ža catə' əsa'aque' beṉə' blao. ");
INSERT INTO zavNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nach bossed boslo'i Jeso'osən' ḻega'aque', gwne': —Yeḻə' gwnabia' c̱he Diozən' ben' zo yoban' gwxaquə'əleben ca de'e nga goquə. To beṉə' napə to güert gan' ža'achgua yag obas. Na' gwze'e liže'en to zil tempran gwyeɉe' gan' chac ya'anə', ɉtilɉe' mos par so'one' žin ḻo'o güert c̱he'enə' žanə'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Na' catə' beyož gosə'əxenḻažə' mos ca' de que to denario c̱hixɉue' to toga'aque' con ca chac mosən' tža žin, nach bseḻe'e ḻega'aque' ḻo'o güert gan' so'one' žinṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nach do cheda ga gozeɉe' gan' chac ya'anə', na' ble'ine' nitə'əch beṉə' cui bi bi žin de so'one'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Na' gože' ḻega'aque': “Ḻežɉa'ac ḻo'o güert c̱hia'anə' ḻežɉen žin na' c̱hixɉwcza' le'e.” Nach ɉa'ac beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Na' gozeɉe' de'e yoblə gan' chac ya'anə' do gobiž, nach yeto do cheda šoṉə, na' bezle'ine' nitə' beṉə' cui bi bi žin de so'one'. Nach bozseḻe'e ḻega'aque' par so'one' žin ḻo'o güert c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Na' ca do cheda gueyə' še'elə gozeɉe' de'e yoblə. Na' bezle'iczene' beṉə' zeznite'e cui bi bi žin de so'one', nach goze'e ḻega'aque': “¿Bixc̱hen' cui ɉa'acle güen žin?” ");
INSERT INTO zavNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nach gwse'ene': “Notono no gwna neto' güen žin.” Nach goze'e ḻega'aque': “Ḻe'e žɉa'ac ḻe'e gon žin ḻo'o güert c̱hia'anə'. Na' c̱hixɉwcza' le'e.” Nach ɉa'ac beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Na' catə' bžin or yosa'a x̱an güertən' xmose' ca', nach gože' mos əblao c̱he'enə': “Beyax beṉə' güen žin ca' par c̱hixɉwga'aco'one', solaoteco' c̱hixɉo' beṉə' ca' bla'ac bzebe, na' yeyožlo' len beṉə' ca' bla'ac nechte.” Nach ben mos əblaon' can' ben x̱ane'enə' mendad. ");
INSERT INTO zavNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Gwdixɉue' zgua'atec beṉə' ca' gosə'əzolaogüe' gwso'one' žin cheda gueyə' še'elə tgüeɉə denario to toga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Na' catə' gwdixɉue' beṉə' ca' gosə'əzolao chso'on žinṉə' temprante, gwsa'aque beṉə' ca' de que c̱hixɉoche' ḻega'aque' de'e sc̱ha'och laogüe de'en gosə'əzolaogüe' chso'one' žinṉə' temprante. Pero tozəczə can' gwdixɉue' yoguə'əḻoḻtega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Na' catə' beyož gosə'əzi' laxɉw beṉə' ca' gosə'əzolao žinṉə' temprante, gwsa'ade'e x̱an žinṉə' dižə'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Na' de'e tant chesə'əloque' toe' gože' x̱an žinṉə': “Bedo žanə' bžaglaochguato' lao de'e zeyə'ən bento' žin c̱hio'onə'. Na' tozəczə can' gwdixɉo' neto' len beṉə' ca' bla'ac bzebe, len yetor güeɉgan' gwso'one' žinṉə'.” ");
INSERT INTO zavNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pero na' x̱an žinṉə' gože' be'enə': “Migw c̱hia', bitobi de'e mal chona' contr le'e. ¿Ecaguə tratən' bencho de que to denario c̱hixɉua' to tole? ");
INSERT INTO zavNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Laxɉon' bagwxi'o, guaquə yeyeɉo'. Bagwdixɉua' beṉə' ca' con can' go'onda' ḻa'aṉə'əczə bla'aque' bzebe. ");
INSERT INTO zavNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Bixc̱hen' chacxi'ido' nada' ni c̱he de'en naca' beṉə' güen? Lao na'an naquən gona' con can' che'enda' len de'en deida'.” ");
INSERT INTO zavNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nach Jeso'osən' gože' beṉə' ca' bosə'əzenag jemplən': —Can' naquən, nitə' beṉə' bito zɉənaque' beṉə' blao ṉa'a pero gwžin ža catə' əsa'aque' beṉə' blao. Na' nitə' beṉə' zɉənaque' beṉə' blao ṉa'a, pero ḻeczə gwžin ža catə' ḻega'aque' bitoch əsa'aque' beṉə' blao. Diozən' chaxe' yoguə'əḻoḻ beṉə' par se'eɉḻe'e c̱he', pero baḻgue'en choso'ozenague' c̱he', na' ḻega'acze' chque'e ca xi'iṉe'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jeso'osən' na' zan disipl c̱he' ca' zɉa'aque' par Jerosalenṉə'. Na' lao zɉəngüe'e nezən' Jeso'osən' gwleɉe' partlə disipl c̱he' ca' šižiṉnə' na' gože' ḻega'aque': ");
INSERT INTO zavNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Diozən' bseḻe'e nada' golɉa' beṉac̱h, na' ṉa'a šeɉcho Jerosalenṉə' gan' gaca' lao na' bx̱oz əblao ca' na' lao na' beṉə' ca' choso'osed choso'olo'i ḻein', na' yesə'əc̱hoglaogüe'en c̱hia' de que so'ote' nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Na' ḻeczə so'one' nada' lao na' beṉə' ca' cui zɉənaquə beṉə' Izrael gwlaž c̱hecho par so'one' nada' borl, na' yesə'əyine' nada' yid sot, nach tenə' yosə'əde'e nada' ḻe'e yag corozən', pero na' yeyoṉ ža yebana' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Na' ɉa'ac xi'iṉ Sebedeon' Jacobən' len Juanṉə' na' len xna'aga'aque'enə' lao Jeso'osən'. Na' xna'aga'aque'enə' bzo xibe' lao Jeso'osən' gože'ene': —Chṉabda' le' to goclen. ");
INSERT INTO zavNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nach Jeso'osən' gože'ene': —¿Bi goclenṉə' che'endo' gona'? Nach xna'aga'aque'enə' gože'ene': —Che'enda' gono' par nic̱h xi'iṉa' quinga yesə'əbi'e šḻa'a güeɉə cuito'on catə' əžin ža ṉabi'o ṉasyon c̱hechonə'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jeso'osən' gože' Jacobən' len Juanṉə': —Bito chacbe'ile bi de'en chṉabele nada'. ¿Eguaquə saquə'əzi'ile can' saquə'əzi'anə'? ¿Egwzoile gaquə c̱hele can' gaquə c̱hia'anə'? Nach bosyo'oži'e xtiže'enə' gwse'ene': —Gwzoito'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nach Jeso'osən' gože' ḻega'aque': —De'e ḻiczə c̱hi'i saquə'əle can' c̱hi'i saca'anə', na' de'e ḻiczə gaquə c̱hele can' gaquə c̱hia'anə', pero bito naquən par əṉia' nada' non' cue' cuitan' catə'ən əžin ža ṉabi'a. Tozə X̱a' Diozən' bagwleɉe' beṉə' ca' yesə'əbe' cuita'anə'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nach disipl ca' yeši catə' gwse'enene' can' gosə'əna disipl ca' c̱hopə besə'əže'e ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nach Jeso'osən' goxe' yogue'e par nic̱h gosə'əbigue'e laogüe'enə', na' gože' ḻega'aque': —Ṉezecho nitə' beṉə' gwnabia' na' beṉə' blao c̱he to to ṉasyon, na' ḻa fuers chesə'ənabi'e beṉə' nitə' xni'aga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero caguə can' cheyaḻə' gonḻe. Šə no le'e chene'ele gacle beṉə' blao, cheyaḻə' əgwzex̱ɉw yic̱hɉle gaquəlenḻe lɉuežɉle. ");
INSERT INTO zavNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Na' šə no le'e chene'ele gacle xen entr lɉuežɉle, cheyaḻə' gon cuinḻe ca xmos beṉə' ca' yeḻa'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Diozən' bseḻe'e nada' golɉa' beṉac̱h, na' caguə bida' par nic̱h beṉac̱hən' sa'aclene' nada', sino que bida' par gaquəlena' beṉac̱hən', na' par əgwnežɉo cuina' c̱hixɉua' xtoḻə' yoguə'əḻoḻ beṉac̱hən' catə'ən so'ote' nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Na' beṉə' zan ɉəsə'ənaogüe' Jeso'osən' len disipl c̱he' ca' catə'ən besa'aque' syoda Jericon'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Na' c̱hopə beṉə' lc̱hoḻ zɉəchi' cho'a nezən' galən' zɉəyeda Jeso'osən'. Catə' gosə'əṉezene' de que Jeso'osən' chedie' laoga'aque'enə' nach gosə'əṉe' zižɉo, gwse'e Jeso'osən': —X̱anto', len' naco' xi'iṉ dia c̱he de'e Rei Dabin'. Beyašə'əlažə'əšguei neto'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nach beṉə' ca' chesyə'əde laoga'aque'enə' gosə'ədiḻe' ḻega'aque' par nic̱h ṉite'e žizə. Pero nachle gosə'əṉe' zižɉochlə gosə'əne': —X̱anto', len' naco' xi'iṉ dia c̱he de'e Rei Dabin'. Beyašə'əlažə'əšguei neto'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jeso'osən' gwleze' gan' nite'enə', nach goxe' ḻega'aque' par gosə'əbigue'e laogüe'enə'. Nach gože' ḻega'aque': —¿Bin' chene'ele gona' len le'e? ");
INSERT INTO zavNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nach gwse'ene': —X̱anto' benšga par nic̱h yele'ito'. ");
INSERT INTO zavNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jeso'osən' beyašə'əlaže'e ḻega'aque' na' gwdane' ɉlaoga'aque'enə', nach ḻe'e besyə'əle'iteine', na' ɉəsə'ənaogüe' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Na' lao zɉa'ac Jeso'osən' len disipl c̱he' ca' Jerosalenṉə' besə'əžine' Betfage, gan' zo ya'a de'en nzi' Olibos gaḻə'əzə Jerosalenṉə'. Na' Jeso'osən' gwleɉe' c̱hopə disipl c̱he' ca', ");
INSERT INTO zavNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","na' gože' ḻega'aque': —Ḻe'e žɉa'ac yež dao' de'en chi' de'e na' na' žɉəti'ile to borr bia no'olə da'ab yag na' nc̱he'ete to xi'iṉda'ob. Na' gwsežle xna'abən' na' əc̱he'eleb nga len xi'iṉda'obən'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Na' šə bi ye'e beṉə' le'e, na' ye'elene': “X̱anto' nan' chyažɉene' ḻega'aquəb.” Na' ḻe'e desyə'əsantecze'eb len le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Goc ca' par nic̱h goc complir can' bzoɉ de'e profet Zequerian' ben' be' xtižə' Diozən' cana' gwne': ");
INSERT INTO zavNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Gož beṉə' ca' nitə' Jerosalenṉə': “Ḻe'e ggüiašc baza' Rei c̱helen'. Žie' cožə' borr da'onə' ca to beṉə' cui naquə beṉə' blao.” ");
INSERT INTO zavNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Na' ɉa'ac disipl ca' yež dao' de'en gož Jeso'osən' ḻega'aque' ca', na' gwso'one' can' ben Jeso'osən' mendad. ");
INSERT INTO zavNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Na' besyə'əc̱he'e borrən' len xi'iṉəbən' lao Jeso'osən', na' besə'əx̱oa no xaga'aque' cožə'əga'aquəbən', nach gwžia Jeso'osən' bia da'onə' par gwyeɉe' Jerosalenṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Na' lao nez gan' zde'enə' beṉə' zan gwso'ela'ogüe'e Jeso'osən' boso'ošilɉue' no xaga'aque'enə' par nic̱h bleɉ borrən' ḻen na' ḻeczə gosə'əc̱hogue' no xozə' yag de'e nitə' tcho'a nezən' na' bosə'ənite'en lao nezən'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na' beṉə' zan gosə'əbialao lao Jeso'osən' na' ḻeczə beṉə' zan ɉəsə'ənao ḻe'. Nach yogue'e gosə'əgüe'e be' lban c̱he' gosə'əne': —¡Ḻechguaḻe beṉə' güen be'enga, naque' xi'iṉ dia c̱he de'e Rei Dabin'! Sošga Rei c̱hechon' mbalaz ben' baza' nga bseḻə' X̱ancho Diozən' ḻe'. Ḻedoye'ela'oche' txen len beṉə' ca' nitə' gan' zo Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Na' catə' bžin Jeso'osən' Jerosalenṉə' yoguə' beṉə' ca' ža' syodan' besyə'əbanene', na' gosə'əne: —¿Noxa benga bla' nga? ");
INSERT INTO zavNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Na' beṉə' ca' nžag Jeso'osən' catə'ən bežine' lao' syoda Jerosalenṉə' bosyo'oži'e xtižə'əga'aque'enə' gwse'e: —Benga Jeso'os beṉə' za' Nasaret gan' mbane Galilean' na' cho'e xtižə' Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Na' gwyeɉ Jeso'osən' yo'odao' əblao c̱he chio'o beṉə' Izrael na' bebeɉe' yoguə' beṉə' ca' chso'on ya'a chyo'onə'. Nach gwlo'oṉi'ane'e mes c̱he beṉə' ca' choso'oša' mech, na' ḻeczə ca' bene' len yag siy c̱he beṉə' ca' chso'otə' ngolbexə. ");
INSERT INTO zavNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Gwde beyož bene' ca' gože' ḻega'aque': —Nyoɉczən can' gwna Diozən' gwne': “Che'enda' yesə'əna beṉə' de que liža'an naquən to latɉə gan' so'on beṉə' orasyon”, pero na' le'e babenḻen ca to latɉə gan' ža' beṉə' bguan. ");
INSERT INTO zavNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na' beṉə' lc̱hoḻ ca' na' len beṉə' coj ca' gosə'əbigue'e lao Jeso'osən' žlac gwzoe' ḻo'o yo'odao'onə'. Nach beyone' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pero na' bx̱oz əblao ca' na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' ḻechguaḻe besə'əže'e catə' besə'əle'ine' miḻagr ca' de'en ben Jeso'osən'. Na' ḻeczə besə'əže'e catə' gwse'enene' can' gwso'elao' bi'i xcuidə' ca' Jeso'osən' yo'odao' əblaonə', de'en gosə'ənabo': “¡Ḻechguaḻe beṉə' güen be'enga, naque' xi'iṉ dia c̱he de'e Rei Dabin'!” ");
INSERT INTO zavNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nach gwse'e Jeso'osən': —¿Ezendo' bin' gosə'əna bi'i xcuidə' ca'? Jeso'osən' boži'en gože' ḻega'aque': —Zenda'. ¿Ecabi za'alažə'əle can' nyoɉ Xtižə' Diozən' de'en gož de'e Rei Dabin' Diozən', nan: Le' babeno' par nic̱h bi'i xcuidə' na' bi'i cho'a nižə' ca' chso'ela'obo' le' can' chazlažo'o? ");
INSERT INTO zavNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nach bechoɉe' gan' nitə' beṉə' ca', na' beze'e syodan'. Na' že' na' ɉəyega'aṉe' Betania len disipl c̱he' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na' zil beteyo besa'aque' Betanian' ɉəsya'aque' Jerosalenṉə' de'e yoblə. Na' lao zesyə'əngüe'e nezən' gwdon Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Na' ble'ine' to yag yix̱güio zon cho'a nezən' na' gwyeɉe' ɉəgüie' šə žian yix̱güion'. Pero bitobi bželene', con zlega xlague'e žia. Nach gože'en: —Caneque cuich bi bi yix̱güion' cuio'. Na' lao or ṉa' ḻe'e bgüižten. ");
INSERT INTO zavNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Catə' besə'əle'i disipl c̱he' ca' can' goquən', besyə'əbanene', nach gwse'ene': —¿Bixc̱hen' ḻe'e bgüižte yaguən'? ");
INSERT INTO zavNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Na' Jeso'osən' gože' ḻega'aque': —De'e ḻi əchnia' le'e, šə do yic̱hɉ do lažə'əle chonḻilažə'əle Diozən' na' bito chac c̱hop lažə'əle, guaquə gonḻe can' babena' par nic̱h bgüiž yaguən'. Na' ḻeczə ca' guaquə gonḻe par nic̱h ya'a nga žɉəyezon ḻo'o nisda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Na' šə chonḻilažə'əcho Diozən' do yic̱hɉ do lažə'əcho, bitə'ətezə de'en əṉabechone' lao orasyonṉə', goṉcze'en chio'o. ");
INSERT INTO zavNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nach, Jeso'osən' gozeɉe' yo'odao' əblaonə' de'e yoblə par ɉəsed ɉəlo'ine' beṉə' ca'. Na' baḻə beṉə' fariseo ca' na' yebaḻə beṉə' choso'osed choso'olo'i ḻein' gosə'əbigue'e cuit Jeso'osən'. Nach gwse'e Jeso'osən': —¿Nac goquən' gwxi'o yeḻə' gwnabia'anə' na' non' ben le' yeḻə' gwnabia'anə' par gono' de'e ca' chono'? ");
INSERT INTO zavNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nach Jeso'osən' gože' ḻega'aque': —Ḻeczə de to de'e ṉabda' le'e. Šə gwnale nada' de'en ṉabda' le'e nach əṉia' le'e non' beṉ nada' yeḻə' gwnabia' par gona' de'e ca' chona'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ḻenašc nada': ¿non' bseḻə' de'e Juanṉə' bide' bc̱hoe' beṉə' nis? ¿EDioz nan' bseḻe'ene' o šə beṉə' yoblən'? Nach boso'oxi'e gosə'əne': —Šə ye'echone' de que Dioz nan' bseḻe'e de'e Juanṉə' par bc̱hoe' beṉə' nis, na' ye'e chio'o: “¿Bixc̱hexan' bito gwyeɉḻe'ele c̱he'?” ");
INSERT INTO zavNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Na' šə ye'echone' de que to gwlazzen' bide', cuili biczən' so'one beṉə' quingan' chio'o, c̱hedə' chse'eɉḻe'e de que Diozən' bseḻe'e de'e Juanṉə' par be'e xtiže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nach gwse'e Jeso'osən': —Bito ṉezeto' non' bseḻə' de'e Juanṉə'. Nach gož Jeso'osən' ḻega'aque': —Ḻeczə ca' nada' bito əṉia' non' beṉ nada' yeḻə' gwnabia'anə' par gona' de'e ca' chona'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ḻe'e gon xbab bi zeɉe jempl nga: Gwzo to beṉə' gwnitə' c̱hopə xi'iṉe'. Na' gože' tobo': “Xi'iṉa' ṉeža che'enda' šeɉo' güen žin gan' ža' yag obas c̱hia' ca'.” ");
INSERT INTO zavNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nach xi'iṉe'enə' gožbo' ḻe': “Bito ša'a.” Pero gwdelə beyombo' xbab, nach gwyeɉbo'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nach gozeɉe' gan' zo xi'iṉe'en yeto, na' ɉeže'ebo' can' gože' bi'i bišə'əbo'onə'. Na' ḻe'e gožte bi'in ḻe': “Guaquəczə, na' ša'a.” Pero bito gwyeɉbo'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ḻe'e našc nada': ¿nobo' bi'i ca' c̱hopə boso'ozenagbo' c̱he x̱aga'acbo'onə'? Nach gwse'ene': —Bi'i nech na'. Nach Jeso'osən' gože' ḻega'aque': —Ḻeiczelen'. Na' de'e ḻi chnia' le'e beṉə' goc̱hixɉw ca' na' no'olə zargat ca' yobəch yoso'ozenague' c̱he Diozən' cle ca le'e na' yobəch əso'e latɉə ṉabia' Diozən' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ca naquə Juanṉə' ben' bc̱hoa beṉə' nis bide' laolen' na' gwdix̱ɉue'ine' le'e naquən' cheyaḻə' gonḻe par nic̱h yebei Diozən' le'e. Pero bito gwyeɉḻe'ele c̱he'. Letga beṉə' goc̱hixɉw ca' na' no'olə zargat ca' gwse'eɉḻe'e c̱he'. Na' catə' gocbe'ile de que beṉə' ca' bagwse'eɉḻe'e c̱he', bito bediṉɉele xtoḻə'əle ca' par šeɉḻe'ele c̱he de'e Juanṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ḻe'e gwzenag yeto jempl nga. Gwzo to beṉə' na' lao to pedas yežlyo c̱hen' goze' zlezə yag obas na' gwlo'e le'eɉ doxenən. Na' na'atezə bene' to tanc gan' boso'osi'e obasən' par bechoɉ xisein'. Na' ḻeczə bene' to campnary gan' yesə'əcua'a beṉə' əsa'ape' güertən'. Nach bene' güertən' lao na' beṉə' par boso'ogüia boso'oye'en, na' gwde na' gwze'e ɉəzoe' ga yoblə. ");
INSERT INTO zavNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Catə' bžin tyemp par yosyo'otobe' cwsešən', bseḻe'e to c̱hopə xmose' gan' ža' beṉə' ca' chsa'apə yag obas c̱he'enə' par žɉəsyə'əx̱i'e to tlacw cwsešən' de'en cheyaḻə' yezi'e. ");
INSERT INTO zavNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero na' beṉə' ca' chsa'apə yag obas c̱he'enə' bito bosə'əgüialaogüe' mos c̱he' ca'. Gosə'əyine' toe', na' yetoe' boso'ošiže'ene' yeɉ, nach yetoe' gwso'ote'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nach bosseḻə' x̱an yag obasən' mos zanch clezə ca beṉə' ca' bseḻe'e nech, pero ḻeczə can' gwso'onene' beṉə' nech ca' ḻeczə can' gwso'onene' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nach x̱an yag obasən' bseḻe'e cuinczə xi'iṉe'enə', goquene' əsa'ape'ene' respet na' yosyo'onežɉue'ene' cwsešən'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero na' beṉə' ca' chsa'apə güertən' catə' besə'əle'ine' xi'iṉe'enə', nach gosə'əne' entr ḻega'acze': “Be'engan' xi'iṉ x̱an yag obasən', na' ḻe'enə' yega'aṉlen bienṉə'. Ḻeda gotchone' par nic̱h yega'aṉlencho yežlyo c̱he x̱e'enə'.” ");
INSERT INTO zavNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nach boso'oṉize'ene', besyə'əbeɉe'ene' fuerlə güertən' na' gwso'ote'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Beyož be' Jeso'osən' jempl nga, gože' beṉə' ca' ža'anə': —¿Nac chactgüeile gon x̱an güertən' len beṉə' ca' bocua'aṉlene' güert c̱he'enə' catə' yežin cuine'? ");
INSERT INTO zavNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nach gwse'ene': —Gote' ḻega'aque' yeḻə' beṉə' mal c̱hega'aque'enə', na' yegüe'e güertən' lao na' beṉə' yoblə. Yegüe'en lao na' beṉə' so'on complir yosyo'onežɉue'ene' to tlacw cwseš c̱he'enə' catə' əžin ža par yesyə'ətobe'en. ");
INSERT INTO zavNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jeso'osən' gože' ḻega'aque': —Ca'aczən'. Na' ¿əcabiṉə' šeɉni'ile bi zeɉen de'en nyoɉ Xtižə' Diozən' gan' nan: Yeɉ de'en cui gwso'olažə' mues güen yo'o ca', ḻenṉə' banaquən yeɉ squin. X̱ancho Diozən' babzoe' yeɉən' gan' cheyaḻə' son na' de'e zaquə' yebanecho can' bene'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","De'e na'anə' chnia' le'e de que Diozən' cueɉyic̱hɉe' cuich ṉabi'e ṉasyon c̱helenə' na' cueɉe' beṉə' yoblə beṉə' yoso'ozenag c̱he' par ṉabi'e ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Na' ca naquə yeɉən' ža, yoguə' no cui šeɉḻe' c̱hia' gwxaquə'əlebene' ca beṉə' əxopə lao yeɉən' na' cue'ežožɉe'. Na' yoguə' no cuiṉə' šeɉḻe' c̱hia' catə' babžin žan' gaquə juisyən', gwxaquə'əlebene' ca beṉə' əxopə yeɉ laogüe'enə' na' əgwšošɉən ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na' bx̱oz əblao ca' na' beṉə' fariseo ca', catə' gwse'enene' jempl ca' de'en be' Jeso'osən', gwsa'acbe'ine' de que be'e jempl ca' por ni c̱he de'en cui chse'eɉḻe'e c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nach gwse'enene' yesə'əzene'ene' pero bitobi gwso'onene' ḻe'. Besə'əžebe' šə bi so'one beṉə' ca' nžague'enə' ḻega'aque', c̱hedə' yogue'e gwse'eɉḻe'e de que Diozən' bseḻe'e Jeso'osən' par cho'e xtiže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Na' de'e yoblə bsed blo'i Jeso'osən' beṉə' ca' len jemplən', gozne': ");
INSERT INTO zavNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Yeḻə' gwnabia' c̱he Diozən' gwxaquə'əleben ca de'e nga goquən'. Zo to rei, beṉə' ben gast catə' bšagna' xi'iṉe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Na' bene' combid beṉə' zan əžɉa'aque' liže'enə' par əsa'ogüe'. Na' catə' bžin or par solao lṉin', rein' bseḻe'e xmose' ca' par ɉəsə'əxi'e beṉə' ca' babene' combidən'. Pero notono no gwse'ene əžɉa'ac lao yeḻə' gošagna' c̱he xi'iṉe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nach gože' yex̱oṉɉ xmose' ca': “Ḻe'e žɉež beṉə' ca' zɉənaquə combidən' de que babsi'ini'a de'en gaochonə'. Babeta' xco'oṉa' ca' na' xme'edaogua'a ca' bia ca' chsa'aṉə', na' yoguə' de'e ca' yeḻa' babsi'ini'a par gaocho. Na' ye'ega'aclene' sa'aque' gaocho de'en babsi'ini'anə'.” Nach ɉa'ac mos ca' ɉse'eže' ḻega'aque' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero beṉə' ca' bito gwso'one' cas. Toe' gwyeɉe' ɉəgüie' yežlyo c̱he'enə', na' yetoe' gwyeɉe' ɉene' ṉegosy. ");
INSERT INTO zavNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Na' yebaḻe' bosə'əṉize' mos ca' bseḻə' rein' na' gosə'əzi'ic̱hiže'e ḻega'aque' na' gwso'ote' baḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Na' ḻechguaḻe bža'a rein', na' bseḻe'e soḻdad c̱he' ca' ɉse'ete' ḻega'aque' na' bosə'əzeye' syoda c̱hega'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nach rein' gože' xmose' ca': “Babsi'ini'a de'en gaocho lao lṉin', pero ca naquə beṉə' ca' bena' combidən' nacbia' bito zɉəzaque'e par la'aque' liža' nga əsa'ogüe'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ḻe'e žɉa'ac yež ca' yeḻa' na' ḻe'e žɉəta yoguə' lquey ca' na' gonḻe combid yoguə' beṉə' chaš par da'aque' sa'ogüe'.” ");
INSERT INTO zavNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Na' mos ca' ɉa'aque' yoguə' nez ca' na' ɉəsə'ətobe' con yoguə' beṉə' besə'əžague', no beṉə' naquə beṉə' güen na' no beṉə' naquə beṉə' mal, par nic̱h beža' liž rein' xte cuich bi latɉə gotə'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Pero na' catə' gwyo'o rein' ɉəgüie' beṉə' ca' bazɉənžaguən', na' entr ḻega'aque' ble'ine' to beṉə' cui nyaze' lachə' de'en chnežɉo rein' de'en chsa'aze' lao lṉinə'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nach gož rein' ḻe': “Migw c̱hia' ¿nac goquən' gwyo'o nga? la' bito nyazo' lachə' de'en cheyaḻə' c̱hazo'.” Na' be'enə' bito bželene' bi ye'e rein'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nach rein' bene' mendad yoso'oc̱heɉ xmose' ca' ṉi'ana' be'enə' na' yesyə'əbeɉe'ene' fuerlə, gan' ḻechguaḻe naquə žc̱hoḻ, gan' cuežyaše'e na' gan' gaoyeɉə leye' zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Can' naquən, Diozən' chaxe' yoguə' beṉə' par əse'eɉḻe'e c̱he', pero baḻgue'en choso'ozenague' c̱he', na' chque'e ḻega'aque' ca xi'iṉe'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nach beṉə' fariseo ca' besə'əžague' par bosə'əxi'e naclə so'one' par nic̱h yesə'əcueɉe' Jeso'osən' dižə' de'en yesə'əc̱hine' par əsa'ogüe' xya c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Na' beṉə' fariseo ca' boso'oseḻe'e baḻə beṉə' zɉənaquə cuent len ḻega'aque' lao Jeso'osən' na ḻeczə boso'oseḻe'e baḻə beṉə' chso'on txen len Erodən' par ɉse'eže'ene': —Maestr, ṉezeto' de que cho'o dižə' ḻi. Ṉezeto' de'en chsed chlo'ido' beṉə' can' chene'e Diozən' goncho naquən dižə' ḻi. Na' ṉezeto' bito chžebo' bin' yesə'əna beṉə', la' bito chono' cuent c̱he beṉə' šə naque' blao o šə bito naque'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","De'e na'anə' zedeṉabeto' le' par ənao' neto' naquən' cheyaḻə' gonto'. ¿Enaquən güen c̱hixɉwto' impuest c̱he gobierṉ roman', o šə bito cheyaḻə' c̱hixɉwto'on? ");
INSERT INTO zavNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jeso'osən' gocbe'ine' caguə do lažə'əga'aque'enə' gwse'ene' ca', nach gože' ḻega'aque': —¡Nacle beṉə' gox̱oayag! ¿Bixc̱hen' chene'ele cueɉle nada' dižə' de'en gwc̱hinḻe contr nada'? ");
INSERT INTO zavNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ḻe'e gwlo'i nada' xmechlen' de'en chyixɉwle c̱he impuestən'. Nach boso'olo'ine' ḻe' to denario. ");
INSERT INTO zavNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jeso'osən' gože' ḻega'aque': —¿No diboj c̱heinə' da' laogüenṉə', na' no lein' nyoɉ laogüenṉə'? ");
INSERT INTO zavNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nach gwse'ene': —C̱he Rei Sesar. Nach Jeso'osən' gože' ḻega'aque': —Ḻe'e əgwnežɉo Sesarən' de'en naquə c̱he' ža, na' ḻe'e əgwnežɉo Diozən' de'en cheyaḻə' əgwnežɉwlene'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nach beṉə' ca' catə' gwse'enene' xtižə' Jeso'osən' besyə'əbanene'. Na' besa'aque' gan' zoe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na' ḻe'e ža na'atezəczə besə'əzžin baḻə beṉə' sadoseo beṉə' ca' cui chse'eɉḻe' de que yesyə'əban beṉə' guat ca', na' de'e na'anə' ɉse'eže'ene': ");
INSERT INTO zavNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maestr, de'e Moisezən' bzoɉe' de que šə to beṉə' byo beṉə' nšagna' gate' na' yega'aṉ no'olə c̱he'enə' sin cui no xi'iṉe' gwzo, beṉə' bišə' be'enə' bagotən' cheyaḻə' yeque'e no'olənə' par nic̱h nitə' xi'iṉ dia c̱he de'e beṉə' biše'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bac̱h bembi'ato' gažə bišə'əga'aque'. Na' beṉə' nechən' bšagne'e, na' gote', na' notono xi'iṉe' gwzo. Na' biše'e əgwchopən' beque'e no'olən'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Na' ḻeczə got beṉə' əgwchopən' na' notono xi'iṉe' gwzo. Nach ḻe'egatezə ca' goquə len beṉə' biše'e əgwyoṉe, nach beṉə' bišə'əga'aque' ca' yeḻa', xte besyə'əyatega'aque' besyə'əque'e no'olən' na' besyə'əyatega'aque' gwsa'at, na' notoczə no xi'iṉga'aque' gwnitə'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Na' gwde gwsa'at beṉə' ca' ḻeczə got no'olən'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na' catə' yesyə'əban beṉə' guat ca', ¿noe' entr beṉə' gažə ca' gaquə be'en c̱he no'olən'? la' yogue'en bosyo'ošagna'alene' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nach gož Jeso'osən' ḻega'aque': —Bito chonḻe xbab šao' de'en nale ca', la' bito ṉezele can' na Xtižə' Diozən' de'en nyoɉən na' nic ṉezele naquən' naquə yeḻə' guac c̱he Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Catə'ən yesyə'əban beṉə' guat ca', bito gacbia' šə zoso'ošagne'e o šə cui, na' cana' caguə no yosyo'ošagna'ach. Lebzen' əsa'aque' len angl c̱he Diozən' beṉə' ca' nitə' yoban'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na' ca naquən' chaquele bito yesyə'əban beṉə' guat ca', ¿əbito za'alažə'əle can' nyoɉ Xtižə' Diozən', nan: ");
INSERT INTO zavNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Nada' naca' Dioz c̱he de'e x̱axta'ole Abraanṉə', na' Dioz c̱he de'e x̱axta'ole Isaaquən', na' Dioz c̱he de'e x̱axta'ole Jacobən'.” Na' ṉezecho beṉə' ca' nite'e len Diozən' c̱hedə' Diozən' bito naque' Dioz c̱he beṉə' guat, sino naque' Dioz c̱he beṉə' ca' zɉəmban. ");
INSERT INTO zavNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Na' beṉə' zan ca' zɉənžaguən' besyə'əbanene' catə' gwse'enene' dižə'ən de'en bsed blo'ine' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Na' catə' gwse'ene beṉə' fariseo ca' de que Jeso'osən' bzožie' beṉə' sadoseo ca', nach ɉeza'aque' lao Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Na' to ben' chsed chlo'i ḻein' ḻeczə gone'ene' cueɉe' Jeso'osən' dižə' de'e gwc̱hine' contr ḻe'. Na' gože'ene': ");
INSERT INTO zavNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Maestr, lao ḻei c̱he Diozən' ¿non' de'en none' mendad goncho naquən de'e blaoch? ");
INSERT INTO zavNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Jeso'osən' gože'ene': —De'en naquə de'e žialaoch na' de'e blaoch lao de'e ca' none' mendad goncho nan: “Cheyaḻə' gaquecho c̱he X̱ancho Diozən' do yic̱hɉ do lažə'əcho do fuers balor c̱hecho.” ");
INSERT INTO zavNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na' de'e əgwchopen' lebze nan len de'e nechen': “Cheyaḻə' gaquecho c̱he sa'alɉuežɉcho catg chaquecho c̱he cuincho.” ");
INSERT INTO zavNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","C̱hopə de'e ca' non Diozən' mendad goncho zɉənox̱ə'ən doxen de'en bzoɉ de'e Moisezən' na' de'en boso'ozoɉ beṉə' ca' gwso'e xtižə' Diozən' cana'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Na' lao ṉe'e zɉənžag beṉə' fariseo ca' lao Jeso'osən', ");
INSERT INTO zavNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","gože' ḻega'aque': —¿Bin' chontguale xbab c̱he Cristən' ben' əseḻə' Diozən' par gaquəlene' ṉasyon c̱hechon'? ¿No xi'iṉ dia c̱hei gaque'? Na' gwse'ene': —Gaque' xi'iṉ dia c̱he de'e Rei Dabin'. ");
INSERT INTO zavNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Nach Jeso'osən' gože' ḻega'aque': —De'e Dabin' bzoɉe' can' blo'i Spirit c̱he Diozən' ḻe'. Gwne' de que Cristən' naque' X̱ane'. Quinga bzoɉe': X̱ancho Diozən' gože' X̱ana'an: “Gwche'edo' cuita' nga ṉabi'acho txen, Na' gona' par nic̱h ṉitə' de'e ca' chso'on contr le' na' beṉə' contr c̱hio' ca' xni'onə'.” ");
INSERT INTO zavNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Na' de'en gwna de'e Rei Dabin' de que Cristən' naque' X̱ane', ¿əcabi zeɉen de que Cristən' naque' mazəchlə ca xi'iṉ dia c̱he' na'anə' ža? ");
INSERT INTO zavNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Na' notoch no goquə yosyo'oži'i xtiže'enə'. Na' dezd ža na' bitoch besyə'əyaxɉene' bi yesə'əṉabene' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nach Jeso'osən' gwzolao be'e dižə' len disipl c̱he' ca' na' len beṉə' zan ca' nitə' gan' zo'enə', gwne': ");
INSERT INTO zavNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Beṉə' ca' choso'osed choso'olo'i ḻein' na' beṉə' fariseo ca' bazɉənḻane' xlatɉə de'e Moisezən' par choso'ozeɉni'ine' beṉə' ḻei c̱he Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Na' de'e na'anə' ḻe'e gwzenag c̱hega'aque' catə' choso'ozenene' le'e can' na ḻein', na' ḻe'e gon can' nanṉə', pero bito gonḻe can' chso'on ḻega'aque', c̱hedə' ḻega'aque' bito chso'one' de'en chəsə'əne' cheyaḻə' gonḻe. ");
INSERT INTO zavNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ḻega'aque' chesə'əzanche' can' na ḻein', na' chso'one'en ca to yoa' de'e cuiczə no do'i na' chse'enene' soa' beṉə' yoblə ḻen, na' bito chse'ene ḻega'aque' əso'en. ");
INSERT INTO zavNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ca naquə beṉə' ca' yoguə' de'en chso'one'enə', chso'one'en parzə nic̱h yesə'əle'i beṉə' can' chso'one'enə', na' so'elaogüe'e ḻega'aque'. Ncheɉ na'aga'aque'enə' na' ncheɉ lao xgaga'aque'enə' caj dao' gan' ža' part güeɉə Xtižə' Diozən' na' chso'one' caj dao' ca' de'e cha'odao'. Na' ḻeczə chso'one' lox xadoṉ c̱hega'aque'enə' de'e toṉə. ");
INSERT INTO zavNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Chesyə'əbeine' chesə'əbi'e gan' chəsə'əbe' beṉə' blao ca' catə' chɉa'aque' gan' chac no lṉi, na' catə' chɉa'aque' yo'odao' c̱hega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Chəsyə'əbeine' catə' beṉə' ca' chəsə'əguape' ḻega'aque' diox na' catə' chesə'ənope'e na'aga'aque'en do lao lquey, na' chse'enene' yoso'osi' beṉə' ḻega'aque' maestr. ");
INSERT INTO zavNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pero əchnia' le'e, bito gonḻe byen ye'e beṉə' le'e “maestr” laogüe de'en chsed chlo'ile xtiža'anə', c̱hedə' nadə'əzan' gwleɉ Diozən' par naca' maestr c̱hele, nadan' bseḻe'e par gaquəlena' beṉac̱hən'. Na' yoguə' le'e chonḻilažə'əle nada' chaque bišə'əlɉuežɉle tole yetole. ");
INSERT INTO zavNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Na' ḻeczə bito nale c̱he notə'ətezə beṉə' de que naque' “Padrecito”. Tozə Dioz ben' zo yoba naque' X̱acho. ");
INSERT INTO zavNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Na' bito gonḻe byen ye'e beṉə' le'e “X̱ana'”, c̱hedə' ḻeczə tozə nada' Cristən' gwleɉ Diozən' par naca' X̱anḻe. ");
INSERT INTO zavNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Šə no le'e nacle beṉə' blaoch, cheyaḻə' əgwzex̱ɉw yic̱hɉle gaquəlenḻe lɉuežɉle. ");
INSERT INTO zavNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Notə'ətezle cho'elao' cuinḻe Diozən' gone' par nic̱h gacbe'ile de que bitobi zaquə'əle. Na' notə'ətezle chonḻe xbab de que bitotec bi zaquə'əle, Diozən' goṉe' le'e yeḻə' bala'aṉ. ");
INSERT INTO zavNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Probchguazə le'e chsed chlo'ile ḻein', na' probchguazə le'e beṉə' fariseo. Chx̱oayagle beṉə' par nic̱h cui so'e latɉə ṉabia' Diozən' ḻega'aque' na' ḻeczə le'e bito cho'ele latɉə ṉabia' Diozən' le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Na' probchguazə le'e chsed chlo'ile ḻein', na' probchguazə le'e beṉə' fariseo. Chx̱oayagle no no'olə gozebə par nic̱h no'ol ca' chso'oṉe' le'e ližga'aque' na' len bichlə de'en de c̱hega'aque'. Nach catə' chonḻe orasyon cho'echguale dižə' par nic̱h əx̱oayagle beṉə' əsa'aquene' nacle beṉə' güen. Goscha'och Diozən' castigw c̱helen' clezə ca c̱he beṉə' ca' cuitec zɉəṉezene' can' na ḻein'. ");
INSERT INTO zavNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Probchguazə le'e chsed chlo'ile ḻein' na' probchguazə le'e beṉə' fariseo. Nacle beṉə' gox̱oayag. Chɉa'actezə chɉa'acle chɉətilɉle beṉə' zitə' beṉə' yesə'ənao de'en chsed chlo'ile. Na' catə' chželga'aquelene' chzeɉni'iga'aquelene' par nic̱h əsa'aque' ḻechguaḻe beṉə' maləch clezə ca le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Probchguazə le'e! Nacle ca beṉə' lc̱hoḻ beṉə' chsa'aquene' guaquə yesə'əgüe'e nez beṉə' yoblə. Nale de que notə'ətezə beṉə' chzoe' joramentən' por yo'odao' əblaonə', bitobi zeɉe jorament c̱he'enə'. Pero šə chzoe' joramentən' por oro de'en de ḻo'o yo'oda'onə', nachən' zeɉen de que cheyaḻə' gone' can' chone' lyebe. ");
INSERT INTO zavNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Le'e nacle ca beṉə' lc̱hoḻ na' bitobi cheɉni'ile. Oron' bitotec bi zaquə'ən. Yo'oda'onə' gan' yo'o oron' ḻenṉə' zaquə'əchən, la' de'en yo'o oron' ḻo'inə' de'e na'anə' oron' naquən c̱he Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Na' ḻeczə nale de que šə to beṉə' chzoe' joramentən' por mes de yeɉ gan' choso'ozeye' bia yix̱ə'ən par chso'elaogüe'e Diozən', bitobi zeɉe jorament c̱he'enə'. Pero na' šə chzoe' joramentən' por de'en xoa lao mes de yeɉən', cheyaḻə' gone' can' chone' lyebe. ");
INSERT INTO zavNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Le'e nacle ca beṉə' lc̱hoḻ na' bitobi cheɉni'ile. De'en choso'ozeye' par chso'elaogüe'e Diozən' bitotec bi zaquə'ən. Mes gan' chxoa de'en chosə'ənežɉue' Diozən' ḻenṉə' zaquə'əchən, la' de'en choso'ox̱oe' de'e ca' laogüen, de'e na'anə' chsa'aquən c̱he Dioz. ");
INSERT INTO zavNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Šə beṉə' chzoe' joramentən' por mes de yeɉən' lenczə por de'en xoa laogüenṉə' chzoe'en. ");
INSERT INTO zavNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na' šə beṉə' chzoe' joramentən' por yo'oda'onə', lenczə por Dioz nan' chzoe' joramentən' c̱hedə' yo'oda'onə' naquə c̱he Diozən' na' nan' zoe'. ");
INSERT INTO zavNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na' šə beṉə' chzoe' joramentən' por yoban', por Dioz nan' chzoe'en, c̱hedə' la' nan' chi' Diozən' chnabi'e. ");
INSERT INTO zavNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Probchguazə le'e chsed chlo'ile ḻein', na' probchguazə le'e beṉə' fariseo. ¡Nacle beṉə' gox̱oayag! Ḻa'aṉə'əczə chnežɉwle Diozən' to part lao ši part c̱he yix̱güeɉ c̱hele, c̱he niz c̱hele, na' c̱he comin c̱hele, bitobi zeɉen, c̱hedə' bito chzenagle c̱he de'e ca' zɉənaquə de'e žialaoch de'en na ḻein'. Bito chonḻe de'en naquə güen lao Diozən'. Bito cheyašə'əlažə'əle sa'alɉuežɉ beṉac̱hle. Bito chonḻe complir can' nale. De'e quinga zɉənaquə de'e žialaoch gonḻe; pero bito cheyaḻə' cueɉyic̱hɉle cui əgwnežɉwle de'e ca' chnežɉoczlene'. ");
INSERT INTO zavNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nacle ca beṉə' lc̱hoḻ beṉə' chsa'aquene' guaquə yesə'əgüe'e nez beṉə' yoblə. Gwxaquə'əlebele ca to beṉə' chebeɉ bizə beb dao' nc̱hix̱ə yeḻə' guao c̱he'enə', pero bito chacbe'ine' šə nc̱hix̱ə'əchlən to de'e xen de'e zaquə' yebeɉe'. ");
INSERT INTO zavNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Probchguazə le'e chsed chlo'ile ḻein' na' probchguazə le'e beṉə' fariseo. ¡Nacle beṉə' gox̱oayag! Gwxaquə'əlebele ca tas plat de'en chc̱hin beṉə' na' cui cha'a chyibe' ḻo'inə' binḻo. Chonḻe par nic̱h chsa'aque beṉə' de que nacle beṉə' güen pero ḻechguaḻe chzelažə'əle bi de'e de c̱he beṉə' na' chebeichgüeile chca'alen. ");
INSERT INTO zavNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Le'e beṉə' fariseo, nc̱hoḻ yic̱hɉla'ažda'olen'. Ḻe'e yediṉɉe xtoḻə'əle ca' par nic̱h de'e ḻiczə gacle beṉə' güen can' chene'ele so'on beṉə' xbab nacle. ");
INSERT INTO zavNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Probchguazə le'e chsed chlo'ile ḻein' de'en bzoɉ de'e Moisezən', na' probchguazə le'e beṉə' fariseo. ¡Nacle beṉə' gox̱oayag! Gwxaquə'əlebele ca to ba de'en zɉənone' xochechgua laogüenə' pero ḻo'ilei ža' žit beṉə' guat na' chi'ichgua de'e zban. ");
INSERT INTO zavNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Chene'ele so'on beṉə' xbab c̱hele de que nacle beṉə' güen, pero len yic̱hɉla'ažda'olen' nacle beṉə' gox̱oayag na' beṉə' malchgua. ");
INSERT INTO zavNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Probchguazə le'e chsed chlo'ile ḻein'! na' ¡probchguazə le'e beṉə' fariseo! Nacle beṉə' gox̱oayag. Chonḻe moṉoment lao ba c̱he de'e profet beṉə' ca' gwso'e xtižə' Diozən' cana', na' chonḻe xochechgua lao ba c̱he yeziquə'əchlə beṉə' gwso'on de'e güen. ");
INSERT INTO zavNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Na' nale: “Žalə' chio'o bazocho ca tyemp c̱he de'e x̱axta'ocho ca', bito bencho txen len ḻega'aque' ca de'en gwso'one' gwso'ote' profet ca' beṉə' ca' gwso'e xtižə' Diozən' cana'.” ");
INSERT INTO zavNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pero na' yoguə'əḻoḻte de'en chonḻe chlo'in de que tozəczə can' nacle len de'e x̱axta'ole ca' beṉə' ca' gwso'ot de'e profet ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Šə de'e tant chebeile chonḻe de'e malən', ḻe'e gwza'alao ḻegon biquə'əchlə de'e mal de'en bito goḻə' so'on de'e x̱axta'ole ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Le'e nacle beṉə' gox̱oayag na' nalɉele. ¿Echaquele de que guaquə yexoṉɉele castigon' de'en goṉ Diozən' le'e ca de'en əseḻe'e le'e lao yi' gabiḻən'? ");
INSERT INTO zavNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Na' de'en gona' nada' əseḻa'a beṉə' so'e xtiža'anə' na' no beṉə' sin' laolenə', na' nochlə beṉə' yoso'osedene' le'e xtiža'anə'. Na' baḻe' gotle əgwda'aga'aclene' to ḻe'e yag coroz, na' yebaḻe' c̱hinḻe do ḻo'o yo'odao' c̱hele ca', na' yebaḻe' yolagzeɉə yolagzidəga'aclene' gatə'ətezə yež žɉa'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Na' de'en gonḻe ca' gaple doḻə' c̱he yeḻə' got c̱he yoguə' beṉə' ca' gwso'on de'e güen, beṉə' ca' gwso'ot de'e x̱axta'ole ca', gwzolaozən len de'e Abeḻən' xi'iṉ beṉə' nech ca' ben' naquə beṉə' güen lao Diozən' na' beyožən len de'e Zequeria xi'iṉ de'e Berequias. Zequeria na'anə' ben' gwso'ote' entr yo'odao' əblaonə' na' entr mes de yeɉ gan' choso'ozeye' bia yix̱ə' par chso'elaogüe'e Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Na' de'e ḻi le'e mbanḻe ṉa'a si'ile castigw c̱he yeḻə' got c̱he yoguə' beṉə' ca' gwso'ot de'e x̱axta'ole ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","¡Prob le'e beṉə' Jerosalen! Chotle beṉə' ca' chso'e xtižə' Diozən' na' beṉə' ca' chseḻə' Diozən' par chso'elene' le'e xtiže'enə' chšižə'əga'aclene' yeɉ. Zan las bago'onda' yotoba' le'e can' chon to ɉeid cheyež xi'iṉəb, pero bito be'ele latɉə. ");
INSERT INTO zavNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na' ṉa'a cueɉyic̱hɉ Diozən' le'e. Bitoch gone' cas c̱hele. ");
INSERT INTO zavNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Na' əchnia' le'e, bitoch le'ile nada' xte catə'əch əžin ža əṉale: “Cho'ela'oto' ben' za' nga, babseḻə' X̱ancho Diozən' ḻe'.” ");
INSERT INTO zavNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Na' catə' beza' Jeso'osən' yo'odao' əblaonə' par šeɉe' ga yoblə gosə'əbiguə' disipl c̱he' ca' gan' zo'enə' na' lao chəsə'əgüi'e yo'odao' əblaonə' gwso'e dižə' catec xoche naquən na' ḻeczə ca' yo'o ca' zɉənyec̱hɉən. ");
INSERT INTO zavNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nach Jeso'osən' gože' ḻega'aque': —Bable'ile catec xochen' naquə yoguə' de'e quinga. Na' de'e ḻi chnia' le'e ca naquə de'en chle'ile ṉa'a, gwžin ža yosyo'oc̱hiṉɉ beṉə' doxenən, na' notoch no le'i ḻega'aquən. ");
INSERT INTO zavNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Na' ɉa'aque' ya'a Olibosən' na' Jeso'osən' gwchi'e lao ya'anə' toze'. Na' gosə'əbiguə' disipl c̱he' ca' laogüe'enə' na' gwse'ene': —X̱anto', ¿do batə'əquən' gaquə de'e nga nao' nga? Na' ¿nac gaquən' gacbe'ito' de que bazon baozə yido' de'e yoblə par šo'o fin c̱he yežlyon'? ");
INSERT INTO zavNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nach Jeso'osən' gože' ḻega'aque': —Ḻe'e gon xbab par nic̱h notono əx̱oayag le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Gwžin ža catə' zan beṉə' gox̱oayag ša' lao yežlyo nga beṉə' se'ene'ene' yoso'oḻane' xlatɉa' nga. Na' yesə'əne': “Nada'an Cristən' ben' gwleɉ Diozən' par gaquəlena' le'e.” Na' beṉə' zan yesə'əx̱oayague'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Na' yene'ele dižə' de que chac gwdiḻə, o de que guaquə gwdiḻə, pero na' bito žeble, c̱hedə' zgua'atec cheyaḻə' gaquə ca'. Na' bito ḻe'e žinte žan' par šo'o fin c̱he yežlyon'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Na' yesyə'ədiḻə yež contr yež, na' ṉasyon contr ṉasyon. Na' ḻeczə zan yež de'e zɉəchi' doxenḻə yežlyon' gaquə bgua bgüin na' cue'e yižgüe', na' ḻeczə x̱o'ochgua. ");
INSERT INTO zavNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Na' te gaquə ca' ṉe'e yesə'əžaglaoch beṉə' ža' yežlyon'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Nach beṉə' ca' ža' doxen yežlyo nga yesə'əgue'ine' le'e c̱hedə' chonḻilažə'əle nada'. Na' so'one' le'e lao na' beṉə' contr ca', na' yesə'əsaquə'əzi'e le'e, nach so'ote' le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Cana' ža, beṉə' zan beṉə' bachso'onḻilažə' nada' yesə'əbeɉyic̱hɉe' cuich so'onḻilaže'e nada'. Na' ḻega'acteze' yesə'əgue'ine' lɉuežɉga'aque' beṉə' ṉe'e chso'onḻilažə' nada' na' so'one' ḻega'aque' lao na' beṉə' contr ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Na' beṉə' zan so'onḻaže'e yesə'əne' de que xtižə' Diozən' chəsə'əyix̱ɉui'e na' yesə'əx̱oayague' beṉə' zan. ");
INSERT INTO zavNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Na' laogüe de'en šanch beṉə' ca' so'on de'e malən', beṉə' zan juisy beṉə' bachso'onḻilažə' nada' cuich əsa'aquene' c̱he yeziquə'əchlə beṉə' chso'onḻilažə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero na' notə'ətezle šə co'o gwc̱heɉlažə'əle len de'en c̱hi' saquə'əle par gonḻilažə'əle nada' na' gwzenagle c̱hia' xte catə'əch əžin ža gatle, gožɉəyezole len Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Na' žɉa'ac beṉə' doxen lao yežlyon' yesə'əyix̱ɉui'e dižə' güen dižə' cobən' de que ṉabia' Diozən' con notə'ətezə beṉə' əso'e latɉə. Na' catə' bazɉəṉeze beṉə' ža' yoguə' ṉasyonṉə' ḻen, cana'achən' əžin ža šo'o fin c̱he yežlyon'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Bablable can' bzoɉ de'e profet Daniel ben' be' xtižə' Diozən' cana'. Na' de'en bzoɉe' nan de que beṉə' mal so'one' de'en naquə de'e zban juisy de'e chgue'i Diozən' ḻo'o yo'odao' əblao c̱he chio'o beṉə' Izrael na' yo'oda'onə' bitoch gonən žin. Na' catə' le'ile gaquə de'e quinga, canan' le'e nitə'əle Jodean' cheyaḻə' əgwxoṉɉle na' žɉa'acle do ya'ada'ote. Le'e chlable de'en nga ḻe'e šeɉni'in. ");
INSERT INTO zavNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Na' šə zo to beṉə' chone' dezcanz lao sotea c̱he' liže'enə', bito gaḻə' yotobe' šinḻaze' ca' ža' liže'enə', con cueɉyic̱hɉe'en. ");
INSERT INTO zavNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na' ḻeczə ca' beṉə' zda do yoba bito gaḻə' yebi'e par žɉəyexi'e xadoṉ c̱he'enə' liže'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Na' ca tyempən' ḻechguaḻe zdebə gaquən len no'olə ca' zɉənoa' bdao' na' no'ol ca' chesə'əguažə' bidao'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ḻe'e gon orasyon par nic̱h cui cheyaḻə' əgwxoṉɉle tyemp catə' chi' de'e zag o lao ža dezcanz. ");
INSERT INTO zavNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Catə' gaquə de'e ca' ḻechguaḻe c̱hi' saquə' beṉə' Izrael gwlaž c̱hecho ca'. Na' dezd catə'ən gwxe yežlyon' xte ža ṉeža bito əṉacho bagwdi' bagwxaquə' beṉə' can' c̱hi' saquə' beṉə' Izrael gwlaž c̱hecho ca', na' bito əžinḻaže'e gaquə ca' len beṉac̱hən' de'e yoblə. ");
INSERT INTO zavNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Žalə' nžia Diozən' bia' yesə'əžaglaogüe' sša ni yeto beṉə' cuich zɉəmban catə'ən yeyož yesə'əžaglaogüe'enə' žalə' ca'. Pero por ni c̱he de'en chaque Diozən' c̱he beṉə' ca' chso'onḻilažə' ḻe', beṉə' ca' bagwleɉe' par əsa'aque' xi'iṉe', de'e na'anə' cui güe'e latɉə yesə'əžaglaogüe' sša. ");
INSERT INTO zavNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","De'e na'anə' šə no əye'e le'e: “Bgüiašc nga zo Cristən' ben' gwleɉ Diozən' par gaquəlene' chio'o”, o šə əye'e le'e: “Na'alə zoe'”, bito šeɉḻe'ele c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Zan beṉə' gox̱oayag ša' lao yežlyo nga əse'e le'e de que zɉənaque' Cristən' o de que chso'e xtižə' Diozən'. Na' so'one' miḻagr na' so'one' de'e naquə yeḻə' goban par nic̱h yesə'əx̱oayague' beṉə' ca' bagwleɉ Diozən' par əsa'aque' xi'iṉe' žalə' gaquə yesə'əx̱oayague' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Baṉezele can' gaquə la' bagwdix̱ɉue'ida' le'e c̱he de'e ca' ze'e gaquə. ");
INSERT INTO zavNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","De'e na'anə' šə əse'e le'e: “Zo Cristən' latɉə dašən'”, bito gwzenagle c̱hega'aque' par əžɉa'acle. Na' šə əse'e le'e de que zo Cristən' ḻo'o yo'onə', bito šeɉḻe'ele c̱hega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Can' chac catə' chep yesən' chse'eni'in doxenḻə ḻe'e yoban' to de repentzə, ḻeczə can' gaquə catə'ən əžin ža yida' de'e yoblə. Diozən' bseḻe'e nada' golɉa' beṉac̱h, na' yida' to de repentzə na' yoguə'əḻoḻ beṉə' yesə'əle'ine' nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ngale'en chonen c̱he ben' ne': “Gan' de bia guat nan' chesə'əžag šod ca'.” ");
INSERT INTO zavNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Na' cate yeyož c̱hi' saquə' beṉac̱hən' lao ža ca', bgüižən' bitoch əgwse'eni'in, na' ḻeczə ca' bio'onə'. Na' belɉw ca' zɉəžia ḻe'e yoban' yesə'əxopən c̱hedə' Diozən' əgwsi'iṉse' yoguə' de'e ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Na' cana'ach beṉə' ža' yežlyon' yesə'əle'ine' nada' yida' de'e yoblə to ḻo'o beɉw, nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. Yida' nsa'a yeḻə' guac xen c̱hia'anə' na' yeḻə' chey che'eni' c̱hia'anə'. Na' beṉə' ža' yoguə' ṉasyon c̱he yežlyon' yesə'əbežyaše'e, beṉə' cui gwso'onḻilažə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Na' catə'ən yida' to trompetən' cuežən zižɉo, na' əseḻa'a angl c̱hia' ca' doxenḻə yežlyonə' par yesyə'ətobe' beṉə' ca' bagwleɉ Diozən' par zɉənaque' xi'iṉe' gatə'ətezə zɉənasəlase'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ṉezele can' chac do nga len yag yix̱güion', catə' bac̱h chzolao chebia xḻague'e, chacbe'ile de que bac̱h zon yela' yeɉon'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Na' ḻeczə can' catə'ən le'ile gaquə de'e mal ca' bagwnia' gaquə, cana'ach əṉezele de que bazon əžin ža šo'o fin c̱he yežlyon'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","De'e ḻi əchnia' le'e, bitoṉə' gat le'e nitə'əle lao tyemp nga ṉa'a catə' solao gaquə yoguə'əḻoḻ de'e ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ca naquə de'e ca' chle'icho ḻe'e yoban' na' yežlyon', yesə'əde c̱hei, pero ca naquə xtiža'anə' caguə de'e te cui gaquə can' nanṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Pero ca naquə bi ža bi orən' šo'o fin c̱he yežlyon', notono no ṉeze, ni que zɉəṉeze angl ca' nitə' yoban', na' ni que ṉezda' nada' naca' Xi'iṉ Diozən'. Tozə X̱a' Dioz nan' ṉeze. ");
INSERT INTO zavNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Diozən' bseḻe'e nada' golɉa' beṉac̱h, na' can' goquə ca tyemp c̱he de'e Noenə', ḻeczə can' gaquə catə'ən nada' yida' de'e yoblə. ");
INSERT INTO zavNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Beṉə' ca' gwnitə' ca tyemp c̱he de'e Noen' gwža'azeche' gwse'eɉ gwsa'ogüe' na' gwso'elaozechga'aque' boso'ošagne'e na' bosə'əšague' na' no xi'iṉga'aque'. Ṉe'e chso'onte' ca' catə'ən bžin ža gwyo'o Noen' ḻo'o barcon' len famiḻy c̱he' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bito gwsa'acbe'ine' bin' gaquə xte catə'əchən' goc yeɉw sio' juisyən' na' bia' nisən' yoguə'əḻoḻga'aque'. Ca'atezəczən' bito sa'acbe'i beṉə' bin' gaquə xte catə'əchən' yida' de'e yoblə. ");
INSERT INTO zavNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Quingan' gaquə catə'ən yida' de'e yoblə, c̱hopə beṉə' nite'e do yoba, toe' yezi' yeca' Diozən', na' yetoe' yocua'aṉe'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Na' c̱hopə no'olə nite'e chso'ote', toe' yezi' yeca' Diozən', na' yetoe' yocua'aṉe'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","De'e na'anə' ḻe'e so probnid par catə'ən yida' de'e yoblə, c̱hedə' bito ṉezele bi ža bi orən' yida' de'e yoblə, nada' naca' X̱anḻe. ");
INSERT INTO zavNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ḻe'e gon xbab c̱he de'e nga, žalə' ṉeze x̱an yo'onə' do bi or lao yelən' əžin beṉə' bguanṉə' liže'enə', la' gwṉaze' par nic̱h bito güe'e latɉə šo'o be'enə' liže'enə' par cuane' šinḻaze'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","De'e na'anə' ža, ḻe'e so probnid par catə'ən yida' de'e yoblə c̱hedə' catə'ən cui chonḻe xbab yida' ca nan' yida' de'e yoblə, nada' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Notə'ətezle šə zotezə zole probnid dote tyemp, gwxaquə'əlebele ca to mos beṉə' naque' beṉə' sin' na' beṉə' chon complir can' cheyaḻə' gone'. Na' gwxaquə'əlebele ca to mos ben' gwlo'o x̱ane'enə' lao ne'e liže'enə' catə'ən gwze'enə' par nic̱h chnežɉue' de'e chsa'o yoguə' mos c̱he' ca' yeḻa' catə' chžin or chsa'ogüe'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Šə to beṉə' mosən' chontezə chone' can' non x̱anen' mendad, mbalaz socze' catə' yežin x̱ane'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","De'e ḻi chnia' le'e, x̱ane'en cue'e lao na' xmose'enə' yoguə'əḻoḻ de'en deine'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero šə mosən' naque' beṉə' mal na' gone' xbab əṉe': “Bagwžei x̱anan'”. ");
INSERT INTO zavNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nach šə solaocle' c̱hine' mos ca' yeḻa' na' ye'eɉ gaoxatteze' len no beṉə' güe'e zo, ");
INSERT INTO zavNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","nach x̱ane'enə' yežine' to ža senyale' ḻe' to or cui nacbe'ine'. ");
INSERT INTO zavNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Na' por ni c̱he de'en cui chon mosən' can' cheyaḻə' gone', x̱ane'enə' c̱hinchgüe' ḻe' yid sotən' xte ca gate'. Gaquə c̱he' can' chac c̱he notə'ətezə beṉə' gox̱oayag, chɉəya'aque' gabiḻən' gan' chesə'əbežyašə' beṉə' na' chsa'oyeɉə leyga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Nach Jeso'osən' goze'e disipl c̱he' ca': ―Yeḻə' gwnabia' c̱he Diozən' ben' zo yoban' gwxaquə'əleben ca de'e nga goquə. Goc to yeḻə' gošagna' na' bazɉəx̱i' beṉə' gošagna'anə' xo'ole'enə'. Na' nitə' ši no'ol güego' zɉənaque' migw c̱he beṉə' ca' chesə'əšagna'anə'. Na' zɉənxobe' lintern c̱hega'aque'en ɉa'aque' ɉəsə'əleze' catə' yesyə'əchoɉ beṉə' ca' liž no'olən' par nic̱h əžɉa'aque' liž beṉə' byon' txen. ");
INSERT INTO zavNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Na' gueyə' no'ol ca' gwnite'e probnid, na' no'ol ca' yegueyə' bito gosə'ənite'e probnid. ");
INSERT INTO zavNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Catə' gwsa'aque' ližga'aque'enə', zɉənxobe' lintern c̱hega'aque'enə' pero bito gwso'ox̱e'e lmet gan' yožə petroly de'en yoso'oc̱hine' catə' yebiž de'en yožə ḻo'o lintern c̱hega'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Na' no'ol ca' gueyə' catə' gwsa'aque' ližga'aque'enə', gosə'əxobe' lintern c̱hega'aque'enə' na' gosə'əbecyic̱hɉe' gwso'ox̱e'e lmet gan' yožə petroly de'en yosə'əc̱hine' catə' yebiž de'en yožə' ḻo'o lintern c̱hega'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Na' gosə'əžei beṉə' gošagna' ca', na' yoguə' beṉə' ca' gosə'əbezə ḻega'aque' gosə'ətase' lao chesə'əbeze'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Na' do chel, to beṉə' gwne' zižɉo, gože' ḻega'aque': “Bachesyə'əchoɉ beṉə' gošagna' ca'. Ḻe'e šo'o žɉəšagga'acchone'.” ");
INSERT INTO zavNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Na' catə' gože' ḻega'aque' ca', yoguə' no'ol ca' gosə'əzeche' na' gosə'əque'e bao' de'en zo lao meš c̱he lintern c̱hega'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Na' no'ol ca' cui gosə'ənitə' probnid gwse'e no'ol ca' yegueyə': “¿Ebito goṉ latə' petroly c̱helen' neto'? la' bachebiž c̱heto'onə'.” ");
INSERT INTO zavNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nach no'ol ca' gwse'e ḻega'aque': “Bito gaquə goṉlatə'əto' c̱hele la' de'en de c̱heto' bito gaquen par yoguə'əcho. Ḻe'e žɉa'ac ḻe'e žɉəx̱i' c̱helen' gan' chso'ote'enṉə'.” ");
INSERT INTO zavNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nach no'ol ca' cui gosə'ənitə' probnidən' ɉa'aque' ɉəsə'əx̱i'e petrolyən'. Na' lao zɉa'aque' gwxi' petrolyən' besyə'əžin beṉə' ca' choso'ošagna' liž beṉə' byon'. Na' no'ol ca' gosə'ənitə' probnid gwso'e ḻo'o yo'onə' gan' chso'one' gastən' txen len beṉə' ca' chosə'əšagna'anə'. Nach mos ca' boso'oseyɉue' puertən'. ");
INSERT INTO zavNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Na' catə' besə'əžin no'ol ca' ɉəsə'əx̱i' petrolyən' na' gosə'əṉe' cho'a puertən', gwse'e ben' zo cho'a puertən': “Señor, bsalɉwšga puertən' par nic̱h šo'oto'.” ");
INSERT INTO zavNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero na' ben' zo cho'a puertən' gože' ḻega'aque': “De'e ḻi chnia' le'e, bito salɉua' par šo'ole la' bito nombi'a le'e.” ");
INSERT INTO zavNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nach goze' Jeso'osən' disipl c̱he' ca': ―Ca'aczən' cheyaḻə' sole probnid batə'əquən' yida', c̱hedə' bito ṉezele bi ža bi orən' yida' yežlyo nga de'e yoblə, nada' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Na' yeḻə' gwnabia' c̱he Diozən' ben' zo yoban' gwxaquə'əleben ca de'en nga. To beṉə' gwyeɉe' ṉasyon zitə'. Na' ze'e se'e goxe' mos c̱he' ca' na' gwlo'e lao na'aga'aque' xmeche'enə' par gwso'onene'en ṉegosy. ");
INSERT INTO zavNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Toe' bocua'aṉlene' gueya' mil pes. Na' yetoe' bocua'aṉlene' c̱hopa mil. Na' yetoe' bocua'aṉlene' tmil. Bnežɉue'en ḻega'aque' segon can' chac so'on to toga'aque'. Beyož bene' ca' gwze'e. ");
INSERT INTO zavNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ben' bocua'aṉlene' gueya' mil ḻe'e gwzolaote chone' ṉegosy len mechən' na' bene' gan yegueya' mil pes. ");
INSERT INTO zavNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ḻe'egatezə ca' ben ben' bocua'aṉlene' c̱hopa mil. Ḻe'e gwzolaote chone' ṉegosyən' len mechən' na' bene' gan yec̱hopa mil. ");
INSERT INTO zavNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Na' ben' bnežɉue' tmil gwyeɉe', ɉəcuaše'e xmech x̱ane'enə' to ḻo'o yech de'e əgwc̱he'eṉe' ḻo'o yon'. ");
INSERT INTO zavNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Goc sša gwza' x̱an mos quinga catə' bežine' nach bene' mendad ɉa'ac xmose' ca' laogüe'enə' par bosyo'odie' cuent. ");
INSERT INTO zavNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Na' mosən' ben' bocua'aṉlene' gueya' mil pes bžine' laogüe'enə' na' gože'ene': “X̱ana', ni de de'e gueya' mil de'en beṉo' nada'. Na' babena' gan yegueya' mil.” ");
INSERT INTO zavNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Na' x̱ane'enə' gože'ene': “Babeno' de'e güen. Naco' mos güen na' syempr chono' complir can' cheyaḻə' gono'. Beno' can' cheyaḻə' gono' len de'e daon' bocua'aṉlena' le', na' ṉa'a gona' lao na'o de'e xenchlə. Gwyo'o na' gona' par nic̱h so' mbalaz len nada'.” ");
INSERT INTO zavNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nach catə' bžin ben' bocua'aṉlene' c̱hopa milən' gože'ene': “X̱ana', ni de de'e c̱hopa mil pes de'en bocua'aṉleno' nada', na' babenən gan yec̱hopa mil.” ");
INSERT INTO zavNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nach gož x̱ane'en ḻe': “Babeno' de'e güen. Naco' mos güen na' syempr chono' complir can' cheyaḻə' gono'. Beno' can' cheyaḻə' gono' len de'e daon' bocua'aṉlena' le', na' ṉa'a gona' lao na'o de'e xenchlə. Gwyo'o na' gona' par nic̱h so' mbalaz len nada'.” ");
INSERT INTO zavNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nach catə' bezžin ben' bocua'aṉlene' tmil, nach gože' x̱ane'enə': “Nga de xmecho' de'en bocua'aṉleno' nada'. Ṉezda' de que le' naco' to beṉə' znia. Chelapo' de'en gwsa'az beṉə' yoblə, na' chotobo' cwseš gan' gwso'on beṉə' yoblə žin. ");
INSERT INTO zavNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","De'e na'anə' gwya'a ɉəc̱he'ena' to yech na' bcuaša'a xmecho'onə', c̱hedə' bžeba' šə əgwnitla'an. Na' ṉa'a bezi'išgan'.” ");
INSERT INTO zavNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nach x̱ane'en gože' ḻe': “¡Naco' mos mal, na' naco' xagüed! Chacdo' de que chelapa' gan' gwsa'az beṉə' yoblə, na' chotoba' cwseš gan' gwso'on beṉə' yoblə žin. ");
INSERT INTO zavNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Na' šə chacdo' chona' ca', ¿bixc̱hen' cui gwleɉo' xmecha'an beṉə' yoblə žlac cui gwzoa'? na' ṉa'a babela'a yezi'an len yic̱hɉei žalə' ca'.” ");
INSERT INTO zavNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nach gože' xmose' ca' yeḻa': “Yeca'ale mechən' de'en bocua'aṉlena' be'enə' na' əgwnežɉwlen ben' banox̱ə' ši mil pes. ");
INSERT INTO zavNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Can' naquən, ben' chon güen len de'en chnežɉo x̱ane'en ḻe', x̱ane'en gwnežɉochcze' c̱he', nic̱h gatə' de'e sc̱ha'och c̱he'. Pero na' be'enə' cui chgon žin de'en chnežɉo x̱ane'en ḻe', yeca'a x̱ane'en de'e da'on bnežɉue' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na' ca naquə mos mal nga ḻe'e yebeɉe' fuerlə gan' ḻechguaḻe naquə žc̱hoḻ na' cuežyaše'e na' gaoyeɉə leye'enə'.” ");
INSERT INTO zavNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Diozən' bseḻe'e nada' golɉa' beṉac̱h, na' catə' yida' de'e yoblə nsa'a yeḻə' chey che'eni' c̱hia'anə', na' c̱hi'a angl c̱hia' ca' na' cui'a gan' chey che'eni' na' ṉabi'a. ");
INSERT INTO zavNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Yoguə' beṉə' ban na' yoguə' beṉə' guat c̱he yoguə' ṉasyon gona' mendad da'aque' laogua'anə'. Na' catə' banitə' yogue'e na' ḻa'aga'aca'ane' can' chon to beṉə' goye xilə' catə' chbeɉe' partlə xilə' ca' na' partlə šib ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Na' beṉə' ca' zɉənaquə beṉə' güen lao Diozən' de'en baboso'ozenague' c̱hia' əgwnitə'əga'aca'ane' cuitan' ḻicha. Pero beṉə' mal ca' əgwnitə'əga'aca'ane' cuitan' yeglə. ");
INSERT INTO zavNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Na' nada' naca' Rei yapa'a beṉə' ca' ṉitə' šḻa'a ḻichan': “Baben X̱a' Diozən' par nic̱h le'e zole mba. Ḻe'e da nga par nic̱h gona' ca ṉabi'ale txen len nada' can' banžia Diozən' bia' dezd gwxe yežlyon'. ");
INSERT INTO zavNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gona' ca ṉabi'ale c̱hedə' catə' gwdona' le'e beṉle de'en gwdaogua'. Na' catə' bgüilda' nis, le'e beṉle de'e güe'eɉa'. Na' catə' goca' ca beṉə' zitə' le'e bebeile bgüialaole nada' ližlen'. ");
INSERT INTO zavNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na' catə' cui gotə' de'e c̱haza', le'e beṉle de'e gwyaza'. Na' catə' gocšenda' le'e bedətiple laža'a. Na' catə' gota'a ližya, le'e bedəlaṉə'əle nada'.” ");
INSERT INTO zavNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Na' yoguə' beṉə' güen ca' əse'e nada': “X̱anto' ¿batən' ble'ito' le' gwdono' na' beṉto' de'e gwdaogo'? Na' ¿batən' bgüildo' na' beṉto' de'e güe'eɉo'? ");
INSERT INTO zavNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Na' ¿batən' goco' ca beṉə' zitə' na' bebeito' bgüialaoto' le'? Na' ¿batən' ble'ito' le' cui gotə' de'e c̱hazo' na' beṉto' de'e gwyazo'? ");
INSERT INTO zavNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na' ¿batən' gocšendo' o goto'o ližya na' bedelaṉə'əto' le'?” ");
INSERT INTO zavNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Na' nada' naca' Rein' yapə'əga'aca'ane': “De'e ḻi chnia' le'e, laogüe de'en beyašə'əlažə'əle beṉə' ca' zɉənaquə ca biša'a na' ca zana' por ni c̱he de'en chso'onḻilaže'e nada', ḻa'aṉə'əczə cuitec bi zɉəzaque'e par len beṉac̱hən', lencza' nada'an beyašə'əlažə'əle.” ");
INSERT INTO zavNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Nach beṉə' ca' ṉitə' yeglə, beṉə' mal ca', yapə'əga'aca'ane': “Ḻe'e cui'ižə' ca'aḻə. Banchoglaon c̱hele cuiayi'ile yeḻə' güen de'e mal c̱helen'. Ḻe'e žɉa'ac ḻo'o yi' gabiḻ de'en cui chyol, yi' de'en bxen Diozən' gan' yesə'əzi' de'e gwxiye'enə' len angl bzelao c̱hei ca' castigw zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ḻe'e žɉa'ac gabiḻən' c̱hedə' catə' gwdona' bito beṉle de'en gaogua'. Catə' bgüilda' bito beṉle de'e ye'eɉa'. ");
INSERT INTO zavNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Catə' goca' ca beṉə' zitə' bito bebeile ggüialaole nada' ližle. Catə' cui gotə' de'e c̱haza' bito beṉle de'e c̱haza'. Catə' gocšenda' na' catə' gota'a ližya, bito bedəlaṉə'əle nada'.” ");
INSERT INTO zavNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nach ḻega'aque' yosyo'oži'e xtiža'a yesə'əne': “X̱anto', ¿batən' gwdono'?, ¿batən' bgüildo'? na' ¿batən' goco' beṉə' zitə'?, ¿batən' cui gotə' de'e c̱hazo'?, ¿batən' gocšendo'? na' ¿batən' goto'o ližya na' bito beyaše'eto' le'?” ");
INSERT INTO zavNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Na' catə' yeyož əsi'e nada' ca', yapə'əga'aca'ane': “Laogüe de'en cui beyašə'əlažə'əle beṉə' ca' zɉənaquə ca biša'a na' ca zana' por ni c̱he de'en chso'onḻilaže'e nada', ḻa'aṉə'əczə cuitec bi zɉəzaque'e par len beṉac̱hən', lencza' nada'an cui beyašə'əlažə'əle.” ");
INSERT INTO zavNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nach beṉə' mal ca' yesə'əzi'e castigw c̱he xtoḻə'əga'aque'enə' zeɉḻicaṉe. Pero beṉə' güen ca' yesə'əzoe' len nada' zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Catə' beyož be' Jeso'osən' dižə'ən ca', gože' disipl c̱he' ca': ");
INSERT INTO zavNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Baṉezele de que yec̱hopə žazən' gaḻə' lṉi pascw c̱hechon', na' ca na' gaca' lao na' beṉə' contr c̱hia' ca' nic̱h so'ote' nada' yosə'əde'e nada' to ḻe'e yag coroz, nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nach bx̱oz əblao ca' na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' na' beṉə' golə blao c̱he chio'o beṉə' Izrael besə'ədobe' chyo'o c̱he beṉə' gwnabia' c̱he bx̱oz ca', ben' le Caifas. ");
INSERT INTO zavNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Na' boso'oxi'e naclən' so'one' par yesə'əzene' Jeso'osən' bgašə'əzə na' so'ote'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Na' gosə'əne': —Bito gotchone' ža lṉinə', par nic̱h cui yesə'ədopə beṉə' ca' banitə' lao syodan' na' yesə'ədiḻəlene' chio'o. ");
INSERT INTO zavNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nach Jeso'osən' len disipl c̱he' ca' ɉa'aque' Betania, liž to beṉə' le' Simon. Na' Simon nan' güe'ine' yižgüe' de'en ne' ḻepr antslə. ");
INSERT INTO zavNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Na' catə' besə'əžine' liž Simonṉə' gwche' Jeso'osən' cho'a mes c̱he'enə'. Na' ca' chi'e catə'əczlə bžin to no'olə nox̱e'e to lmet de yeɉ fin de'e yožə to set de'e ḻechguaḻe zaque'e de'e chḻa' zix̱. Na' no'olən' bcuase' setən' yic̱hɉ Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Na' disipl ca' catə' besə'əle'ine' can' ben no'olən' besə'əže'e na' gwse'e lɉuežɉga'aque': —¿Bixc̱hen' con benditɉeine' setən'? ");
INSERT INTO zavNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Güenchlə žalə' bete'en na' mech xenṉə' de'en le'ine' c̱hei əgwnežɉue'en beṉə' yašə'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Na' catə' bene Jeso'osən' xtižə'əga'aque'enə', nach gože' ḻega'aque': —¿Bixc̱hen' chṉele c̱he no'olən'? Güenchgua babene' len nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ca naquə beṉə' yašə' ca' syempr nitə'əcze' len le'e, pero ca naca' nada' yešložgan' soa' len le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","De'en bcuasə no'olən' setən' yic̱hɉa'anə' bene' de'e non gone'ene' nada' žan' so'ote' nada' na' əgaša'a, can' choncho len cuerp c̱he beṉə' guatən'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","De'e ḻi chnia' le'e, catə' c̱hix̱ɉue'ile dižə' güen dižə' cobə c̱hia'anə' gasə' lalɉən doxenḻə yežlyo nga, na' ḻeczə guasə' gwlalɉə dižə'ən can' ben no'olən' nga len nada', na' beṉə' zanṉə' so'one' xbab ca güenṉə' bene'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Gwde de'e quinga, Jod Iscariotən' ben' goquə txen len disipl ca' šižiṉ gwyeɉe' lao bx̱oz əblao ca' ");
INSERT INTO zavNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","par ɉeže' ḻega'aque': —¿Ɉa'aquə'ətə' goṉle nada' na' gona' Jeso'osən' lao na'ale? Nach boso'oxia' beṉə' ca' boso'onežɉue'ene' šichoa mech pḻat. ");
INSERT INTO zavNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nach Jodən' lao orzə gwzolao gwche'enaogüe' batə'əquən' so latɉə gone' Jeso'osən' lao na'aga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na' ža nech ža lṉin' catə'ən chsa'ogüe' yetxtil sin cui bi xne'i nc̱hix̱ə, ɉa'ac disipl ca' gan' zo Jeso'osən' na' gwse'ene': —¿Ga che'endo' žɉe'eni'ato' de'en gaocho xše' lṉi pascon'? ");
INSERT INTO zavNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nach Jeso'osən' gože' ḻega'aque': —Ḻe'e žɉa'ac lao syodan' liž to beṉə' yežagle na' ye'elene': “Maestrən' ne' de que bazon əžin ža so'ote'ene' na' ližo' nga chene'ene' gaolento'one' xše' lṉi pascon'.” ");
INSERT INTO zavNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nach gwso'on disipl ca' can' ben Jeso'osən' mendad, ɉesə'əsi'ini'e de'en gwsa'olene' ḻe' xše' lṉi pascon'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Na' catə' beyož gwx̱en, Jeso'osən' len disipl c̱he' ca' šižiṉ gosə'əbi'e cho'a mesən' gwsa'ogüe'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Na' lao chsa'ogüe'enə' gož Jeso'osən' ḻega'aque': —De'e ḻi əchnia' le'e, to le'e gonḻe nada' lao na' beṉə' contr ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nach de'e juisy de'e gwsa'aquene' catə' beyož gwne' ca', nach to toe' gwse'e ḻe': —X̱ana', ¿ənada'an gona' le' lao na' beṉə' contr ca'? ");
INSERT INTO zavNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nach gože' ḻega'aque': —To ben' babne' ne'enə' txen len nada' ḻo'o platən', ḻe'enə' gone' nada' lao na' beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Banaquəczən so'ot beṉə' nada' can' nyoɉ Xtižə' Diozən' nan gaquə c̱hia', pero probchguazə be'enə' gon nada' lao na' beṉə' contr ca'. Nca'alə xṉeze žalə' cuiclə golɉe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nach Jodən', ben' bene' Jeso'osən' lao na' beṉə' contr ca', gože'ene': —Maestr, ¿ənadan' gona' le' lao na' beṉə' contr ca'? Jeso'osən' gože'ene': —Ṉezczədo' šə le'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Na' lao chsa'ogüe'enə' gwxi' Jeso'osən' yetxtilən', be'e yeḻə' chox̱cwlen c̱he Diozən'. Gwde na' bzoxɉe'en nach be'en disipl c̱he' ca', gože' ḻega'aque': —Ḻe'e gaon. Ḻenṉə' cuerp c̱hia'anə'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nach ḻeczə bex̱e'e basən' gan' yožə nis oban', na' lao nox̱e'en be'e yeḻə' chox̱cwlen c̱he Diozən' nach boznežɉue'en ḻega'aque' goze'e: —Yoguə'əle ḻe'e ye'eɉ de'en yožə ḻo'o bas nga. ");
INSERT INTO zavNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ḻenṉə' xc̱hena'anə'. Na' xc̱hena' na'anə' lalɉə par nic̱h yezi'ixen Diozən' xtoḻə' beṉə' zan, na' de'en lalɉənṉə' solao gaquə de'e cobə de'en ben Diozən' lyebe gone' par gaquəlene' beṉac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Echnia' le'e ṉa'a zelao che'eɉa' nis oban'. Pero de yeto de'e yebeichecho mazəchlə can' chebeicho nis oban', ḻenṉə' de'en socho mbalaz zeɉḻicaṉe catə'ən socho txen gan' ṉabi'a len X̱a' Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Na' beyož gwse'eɉ gwsa'ogüe' gwso'oḻe' to imno nach besə'əchoɉe' ɉa'aque' ya'a de'en nzi' Olibos. ");
INSERT INTO zavNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Na' lao zɉəngüe'e nezən' Jeso'osən' gože' disipl c̱he' ca': —Ṉeže' yoguə'əle cueɉyic̱hɉle nada' por ni c̱he de'en gaquə c̱hia'. Gaquə can' nyoɉ Xtižə' Diozən' nan: “Gota' beṉə' goye xilə'ənə' na' xilə' c̱he' ca' sa'asə'əlasəb.” ");
INSERT INTO zavNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero na' catə' yosban Diozən' nada' ladɉo beṉə' guat ca', yobəchda' nada' yeya'a Galilean' cle ca le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nach Bedən' gože' Jeso'osən': —Nada' cuat cueɉəyic̱hɉa' le' ḻa'aṉə'əczə šə yoguə' beṉə' yeziquə'əchlə yesə'əbeɉyic̱hɉle' le'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jeso'osən' gože'ene': —Bed, əchnia' le' bito cuež ḻecon' ṉeže' antslə ze'e gaquə šoṉ las cui chc̱hebo' de que nombi'o nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nach Bedən' gože'ene': —Ḻa'aṉə'əczə šə chonclən byen guatlencza' le', bito əṉia' de que bito nombi'a le'. Na' ḻeczə ca' əgwse' yoguə' disipl c̱he' ca' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Na' catə' Jeso'osən' len disipl c̱he' ca' besə'əžine' latɉən' gan' nzi' Getsemani, na' gože' ḻega'aque': —Ngazə ḻecue' žlac ša'a de'e na' žɉena' orasyon. ");
INSERT INTO zavNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Na' gwc̱he'e Bedən', len c̱hopə xi'iṉ Sebedeon' Jacobən' len Juanṉə'. Na' Jeso'osən' gwzolao gwzochgüe' trist, na' de'e juisy de'e goquene' ḻo'o yic̱hɉla'ažda'ogüe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nach gože' ḻega'aque': —Tristchgua zo yic̱hɉla'ažda'ogua'anə' xte bachonən yeḻə' got. Ḻecuezə nga na' sole əṉa'azle len nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nach gwdie' gwyeɉe' yelatə' delant na' ɉete'e gosc̱ho'alə lao yon' nach bene' orasyonṉə' gwne': —X̱a', ¿əguaquə te ca'azə de'en c̱hi' saca'anə'?, pero bito che'enda' gaquə de'e ṉia' nada', sino gaquə con can' əṉao' le'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Catə'əczlə bežine' gan' nitə' disipl ca' šoṉə ɉəyedi'e ḻega'aque' chəsə'ətase'. Na' gože' Bedən': —¿Eni to or bito bcheɉele əṉa'azle len nada'? ");
INSERT INTO zavNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ḻe'e ṉa', na' ḻe'e gon orasyon nic̱h cui co'o gwxiye'en le'e nez mal. Ṉezda' chene'ele əṉa'azle len nada', pero cui chzoile. ");
INSERT INTO zavNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Na' gosze'e gan' nite'enə' de'e yoblə, ɉezene' orasyonṉə', gwne': —X̱a', šə cui gaquə te ca'azə de'en c̱hi' saca'anə', con can' che'endo' le' gaquə. ");
INSERT INTO zavNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Na' bezžine' gan' nite'enə' de'e yoblə ɉeyezdi'icze' bachəsə'ətase' tant bachac šə tasga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Na' gwze'e de'e yoblə gan' nite'enə' ɉene' orasyonṉə' de'e əgwyoṉ lase, na' gwnacze' can' bagwne'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nach bezžine' gan' nitə' disipl ca' šoṉə nach gože' ḻega'aque': —¿Eṉe'e chtasle? ¿Eṉe'e chonḻe dezcanz? Diozən' bseḻe'e nada' golɉa' beṉac̱h na' ṉa'a bac̱h bžin or c̱hia' par gaca' lao na' beṉə' mal ca' par so'ote' nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ḻe'e secha. Ḻe'e šo'o. Baza' ben' gon nada' lažə' na' beṉə' contr ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ṉecho'ete Jeso'osən' dižə' ca' catə' bžin Jodən' ben' naquə cuent lao disipl ca' šižiṉ. Na' žague' zan beṉə' boso'oseḻə' bx̱oz əblao ca' na' beṉə' golə blao c̱he chio'o beṉə' Izrael. Na' zɉənaḻe'e spad na' zɉənḻene' no yag. ");
INSERT INTO zavNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na' Jodən' babzeɉni'ine' ḻega'aque' can' gone' par əgwdie' Jeso'osən' lao na'aga'aque'enə', gože' ḻega'aque': —Ben' gaogua' bxidən', ḻe'enə' senḻe. ");
INSERT INTO zavNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Na' catə' bžine' gan' zo Jeso'osən' ḻe'e bgüiguə'əte' cuite'enə' na' gože'ene': —Padiox Maestr. Na' gwdaogüe'ene' bxidən' pero caguə do laže'en bene' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jeso'osən' gože'ene': —Migw c̱hia', ¿bixc̱hen' za'o nga? Beyož gwne' ca' ḻe'e gosə'əbiguə'əte beṉə' ca' gwso'ox̱e'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na' to ben' naquə txen len Jeso'osən' gwleɉ spad c̱hen' gwdine'en mos c̱he beṉə' gwnabia' c̱he bx̱oz ca', gwc̱hogtechgüe' šḻa'a nague'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nach Jeso'osən' gože'ene': —Bego'o spad c̱hio'onə' ḻo'o liže, la' yoguə' beṉə' chso'ot beṉə' len spad, ḻeczə ḻen chsa'atene'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ebito ṉezdo' de que gaquə ṉaba' lao X̱a'anə' par ḻe'e seḻə'əte' mazlə gyon šižiṉa mil angl beṉə' əsa'aclen nada'? ");
INSERT INTO zavNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Šə le'e tiḻəlenḻe beṉə' quinga par yoslale nada', ¿nacxa gaquən gaquə complir can' nyoɉ Xtižə' Diozən' nan can' cheyaḻə' gaquən'? ");
INSERT INTO zavNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Na' lao bazɉənox̱e'e Jeso'osən', gože' ḻega'aque': —¿Eca to beṉə' bguanṉə' chsaquə'əlebele nada' za'acle len spad len yag zedex̱enḻe nada'? Yoguə' ža gwchi'a len le'e na' bsed blo'ida' beṉə' ḻo'o yo'odao' əblaon' na' cui gwzenḻe nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero laogüe de'en chac yoguə' de'e quinga chac complir Xtižə' Diozən' de'en boso'ozoɉ de'e profet ca' beṉə' ca' gwso'e xtiže'enə' cana'. Na' lao or na' bosyo'oxoṉɉ yoguə' disipl c̱he' ca' gosə'əbeɉyic̱hɉe'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Na' beṉə' ca' gosə'əzen Jeso'osən' gosə'əc̱he'ene' lao Caifasən' ben' naquəch bx̱oz əblao c̱he chio'o beṉə' Izrael gan' bazɉəndobə beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' na' len yeziquə'əchlə beṉə' golə blao ca' chəsə'ənabia' ṉasyon c̱hechon'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nach Bedən' ɉənaogüe' Jeso'osən' zitə' zitə'ələ xte bžinte' liž bx̱oz əblaonə', na' gwyo'e chyo'onə' na' ɉəchi'e len beṉə' ca' zɉənaquə x̱a'ag c̱he yo'odao' əblaonə', c̱hedə' gone'ene' le'ine' naquən' zelao gaquə len Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nach yoguə' bx̱oz əblao ca' na' yeziquə'əchlə beṉə' golə blao ca' chəsə'ənabia' ṉasyon Izrael c̱hechon' chəsyə'əyilɉe' beṉə' so'e dižə' contr Jeso'osən' parzə nic̱h so'ote'ene' ḻa'aṉə'əczə šə dižə' güenḻažə'ənə'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero goc sša bito besyə'əželene' c̱hopə beṉə' əso'e dižə' de'en yediḻe ḻa'aṉə'əczə beṉə' zan gosə'ənitə' testigw faḻs contr ḻe'. Gwde na' besə'əchoɉ yec̱hopə testigw faḻs ca' na' bediḻe can' gosə'əne'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Na' gosə'əne': —Benga gwne': “Nada' guaquə yoc̱hiṉɉa' yo'odao' əblao gan' cho'ela'ocho Diozən', na' lao šoṉə žazə yeyona'an.” ");
INSERT INTO zavNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nach gwzoža' ben' naquəch bx̱oz əblao gože' Jeso'osən': —¿Ebito bi de bi nao' ca naquə de'e nga chosə'əcuiš beṉə' quinga le'? ");
INSERT INTO zavNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jeso'osən' bitobi gwne'. Nach gož bx̱oz əblaonə' ḻe': —Echnia' le' gwna neto' na' bzo Dioz ben' zo zeɉḻicaṉe gaque' testigw šə ḻe len' Crist Xi'iṉ Diozən' ben' gwleɉe' par gaquəlene' ṉasyon c̱hechon'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jeso'osən' gože'ene': —Ḻe ben' nao' na' nada'. Diozən' bseḻe'e nada' golɉa' beṉac̱h. Na' əchnia' le'e, gwžin ža le'ile nada' chi'a cuit Diozən' ben' napə ḻe'ezelaogüe yeḻə' guac xen, na' ṉabi'a txen len ḻe', na' le'ile nada' yetɉa' yoban' to ḻo'o beɉw. ");
INSERT INTO zavNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Cate bene bx̱oz əblaonə' xtižə' Jeso'osən' gwšo' gwc̱hezə' xe'enə' la' par ḻe' de'e mal juisyən' gwna Jeso'osən', nach gwne': —Babenecho ṉa'a babžia bnite'e Diozən'. ¿Nochxa testigon' chyažɉecho? ");
INSERT INTO zavNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Na' ¿naquən' əṉale c̱he'? Nach beṉə' ca' bosyo'oži'en gwse'ene': —Babžia bnite'e Diozən' na' cheyaḻə' gate'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nach boso'oža' x̱ene'e cho'alao Jeso'osən', na' gosə'əbaže'ene', na' baḻe' gosə'əgape'e x̱ague'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nach gwse'ene': —Šə len' naco' Cristən' ben' gwleɉ Diozən' par gaquəleno' ṉasyon c̱hechon', gwṉeya'ašc gwna neto', ¿non' chgapə' le'? ");
INSERT INTO zavNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na' lao chac de'e quinga, chi' Bedən' chyo'onə' catə' bžin to no'ol criad c̱he Caifasən' gože'ene': —Ḻeczə leno' le' naco' txen len Jeso'os beṉə' Galilean'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Na' lao yoguə' beṉə' ca' ža'anə', Bedən' bito gwc̱hebe' šə naque' txen len Jeso'osən' na' gože' no'olən': —Bito ṉezda' bi dižə'ən cho'o. ");
INSERT INTO zavNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Gwde beyož gože' no'olən' ca' gwyeɉe' cha'ašilən', na' bezle'i yeto no'ol criadən' ḻe', na' goze'e beṉə' ca' ža'anə': —Benga naque' txen len Jeso'os beṉə' Nasaretən'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","De'e yoblə bito gwc̱hebe' šə ḻe naque' txen len Jeso'osən' nach bzoe' joramentən' lao Diozən' gože' no'olən': —Bito nombi'a be'enə' nao' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Na' chacczə šlož, gosə'əbiguə' beṉə' ca' ža'anə' gosə'əze'e Bedən': —De'e ḻiczə, chono' txen len beṉə' ca' c̱hedə' ca nga chṉio' ngazə nacbia'. ");
INSERT INTO zavNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nach Bedən' gože' ḻega'aque': —Diozən' goṉe' nada' castigw šə chonḻaža'an nia' bito nombi'a be'enə'. Chzoa' jorament lao Diozən', bito nombi'ane'. Na' ḻe'e gwchežte to ḻecw. ");
INSERT INTO zavNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nach ɉəza'alažə' Bedən' can' gož Jeso'osən' ḻe': “Šoṉ las gaquə cui chc̱hebo' šə nombi'o nada' catə' cuež ḻecon'.” Nach beza' Bedən' ḻechguaḻe gwchežyaše'e tant de'e goquene'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Na' catə' gwye'eni' beteyon', yoguə' bx̱oz əblao ca' na' yeziquə'əchlə beṉə' golə blao ca' chəsə'ənabia' ṉasyon c̱hechon' besə'ədope' jont na' gosə'əc̱hoglaogüe'en de que so'ote' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nach boso'oc̱heɉe'ene' na' ḻe'e gosə'əc̱he'ete'ene' ɉse'ene'ene' lao na' Goberṉador Ponsio Pilatən'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Na' Jodən' ben' bdie' Jeso'osən' lao na' beṉə' ca', catə' gocbe'ine' de que bagoso'oc̱hoglaogüe'en so'ote' Jeso'osən', beyeɉene' de'en bdie' ḻe' lao na' bx̱oz əblao ca' na' beṉə' golə blao ca'. Nach gwyeɉe' laoga'aque'enə' par bonežɉue' ḻega'aque' šichoa mech pḻatən'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nach gože' ḻega'aque': —Malən' bena' bdia' lao na'alen' to beṉə' cui napə doḻə'. Na' gwse'ene': —Bitobi doḻə' napə neto' de'en beno' ca', la' de'e ṉezzədo'on beno'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nach Jodən' bozaḻe'e mech ca' ḻo'o yo'odao' əblaonə', nach beze'e, na' ɉəyelo'o don' yene' par beyot cuine'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Beyož beza' Jodən', bx̱oz əblao ca' besyə'ətobe' mechən'. Na' gwse'e lɉuežɉga'aque': —Bito de lsens co'ochon ḻo'o caj gan' yo'o mech c̱he yo'oda'onə', c̱hedə' la' naquən mech de'en gwdixɉwcho par nic̱h gotcho be'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Na' boso'oxi'e yesə'əzi'e to yežlyo de'en de c̱he to beṉə' güen yesə' len mechən'. Na' gosə'əzi'en par to capsant gan' yesə'əcuaše'e beṉə' zitə'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Na' yezlyonə' nzi'in “Capsant Chen” xte ža ṉeža c̱hedə' gosə'əzi'en len mech de'en gosə'əyixɉue' par gwso'ote' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Can' goquə par nic̱h goc complir can' bzoɉ de'e profet Jeremiasən' ben' be' xtižə' Diozən' cana', gan' nan: “Besyə'əzi'e šichoa mech pḻatən', de'en gwsa'aque baḻə beṉə' Izrael zaquə' ben' besə'əgue'ine'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Na' len mechən' gosə'əzi'e yežlyo c̱he to beṉə' güen yesə', can' gwna X̱ancho Diozən' nada' gaquə.” ");
INSERT INTO zavNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na' bžin Jeso'osən' gwzeche' lao goberṉadorən', nach goberṉadorən' gože'ene': —¿Elen' naco' Rei c̱he beṉə' Izrael ca'? Nach Jeso'osən' gože'ene': —Ḻe ben' nao' na' nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Na' bito bi gwna Jeso'osən' ca de'en boso'ocuiš bx̱oz əblao ca' ḻe' na' beṉə' golə blao ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nach Pilatən' gože'ene': —¿Ebito chendo' catec de'e zan xya nga chsa'ogüe' contr le'? ");
INSERT INTO zavNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero Jeso'osən' ni to xtiže'enə' bito boži'e, xte bebanchgüeicze goberṉadorən'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na' de to costombr de que ža lṉi pascw əgwsan goberṉadorən' to pres, con beṉə' yesə'əṉab beṉə' lao' syoda ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Na' ližya na' de to pres beṉə' zechgua c̱hei naque' beṉə' mal na' le' Barrabas. ");
INSERT INTO zavNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nach Pilatən' gože' beṉə' ca' zɉəndobən': —¿Noe' beṉə' quinga chene'ele gwsana'? ¿EBarrabas na' o šə Jeso'os nga ben' chesə'əne' naquə Crist c̱hele? ");
INSERT INTO zavNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Gone'ene' əgwsane' Jeso'osən' la' ṉezene' ni c̱he de'e zɉəžiague'i bx̱oz əblao ca' Jeso'osən', de'e na'anə' boso'odie' ḻe' lao ne'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ca' chi' Pilatən' gan' chone' yeḻə' jostisən', bžin to rson de'e bseḻə' no'ol c̱he'enə' gože'ene': “Bitobi non ben' par bi castigon' əgwnežɉo'one', zdaczə ben' ḻicha. De'e zan de'e bžaglaochgua' bišyele len yel de'e gwneida' por ni c̱he de'en chac c̱he be'enə'.” ");
INSERT INTO zavNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Na' bx̱oz əblao ca' na' beṉə' golə blao ca' gosə'əgo'oyeḻe'e beṉə' ca' ža'anə' par yesə'əṉabe' əgwsane' Barrabasən' na' yesə'əṉabe' gone' mendad so'ote' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nach goberṉadorən' gože' ḻega'aque' de'e yoblə: —¿Noe' beṉə' quinga c̱hopə chene'ele gwsana'? Nach gwse'ene': —Barrabas na'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatən' gože' ḻega'aque': —¿Bixa gona' len Jeso'os, ben' chesə'əne' naquə Crist c̱hele? Na' yogue'e gwse'ene': —Bde'e ḻe'e yag corozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nach gož goberṉadorən' ḻega'aque': —¿Bixa de'e mal babene'enə'? Na' ḻega'aque' gwso'osye'e zižɉoch gosə'əne': —Bde'e ḻe'e yag corozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Gocbe'i Pilatən' cuiczə bi de gone'. Bachyalə'əch chso'one' scandl juisy. Nach bseḻe'e to beṉə' ɉəx̱i'e nis par bone'e lao beṉə' ca' ža'anə' na' gože' ḻega'aque': —Zdaczə benga ḻicha. Bitobi xbaga'a naquən ca de'en gate', c̱hedə' de'en ṉezze le'enə' gate'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nach yoguə' beṉə' ca' gosə'əne': —Xbaguə' neto' na' xbaguə' xi'iṉto' naquən c̱he yeḻə' got c̱he benga. ");
INSERT INTO zavNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nach bsan Pilatən' Barrabasən'. Gwde na' bene' mendad gosə'əyin soḻdad ca' Jeso'osən', nach bene' ḻe' lao na'aga'aque' par yosə'əde'ene' ḻe'e yag corozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nach soḻdad c̱he goberṉadorən' gosə'əc̱he'e Jeso'osən' ḻo'o yo'o c̱he goberṉadorən', nach bosyo'otobe' yoguə' soḻdad lɉuežɉga'aque' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Na' gosə'əyiṉe' xala'an Jeso'osən' na' bosə'əguacue'ene' to lachə' color əxṉa ca de'en chsa'az rei ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Na' gwso'one' to coron de yešə' boso'ožine'en yic̱hɉe'enə', na' ne'e ḻichan' boso'ogox̱e'ene' to ya. Na' boso'ozo xibe' laogüe'enə' par gwso'one'ene' borl, nach gwse'ene': —¡Biba Rei c̱he beṉə' Izrael! ");
INSERT INTO zavNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nach bosə'əža' x̱ene'e ḻe', na' besyə'əque'e yanə' de'en nox̱e'enə' na' gosə'əyine'en yic̱hɉe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Na' beyož gwso'one' ḻe' borlən', besyə'əyiṉe' lachə' color əxṉanə' de'en bosə'əguacue'ene'enə', na' besyə'əguacue'ene' xacze'. Nach gosə'əc̱he'ene' par ɉəsə'əde'ene' ḻe'e yag corozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Na' catə' besə'əchoɉe' syodan' besyə'əžague' to beṉə' Sirene le Simon na' ḻa fuers bosə'əgüe'ene' coroz c̱he Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Na' besə'əžine' to latɉə gan' nzi' Golgota, zeɉen dižə' latɉə c̱he yic̱hɉ beṉə' guat. ");
INSERT INTO zavNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Na' bosə'ənežɉue' Jeso'osən' bino corrient de'e nc̱hix̱ə to rmech zḻa' par ye'eɉe', pero ḻe' con bnix̱e'en bito güe'eɉe'en. ");
INSERT INTO zavNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Na' catə' beyož boso'ode'ene' ḻe'e yag corozən', soḻdad ca' gwso'one' xe'enə' rif par gotə'əbia' noe' yechelən. Na' de'en gwso'one' ca' goc can' bzoɉ de'e profetən' ben' be' xtižə' Diozən' cana', gwne': “Yosyo'oḻe'e xalana'anə' entr ḻega'aque', so'one'en rif.” ");
INSERT INTO zavNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nach gosə'əbi'e gwsa'ape'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Na' yic̱hɉ yag corozən' gan' de'enə' boso'ozoɉe' de'en bcuiš ḻe', na' nan: “Bengan' Jeso'osən' Rei c̱he beṉə' Izrael ca'.” ");
INSERT INTO zavNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Na' ḻeczə cana' boso'ode'e c̱hopə beṉə' bguan ḻe'e yec̱hopə yag coroz. Toe' gwda' cuit Jeso'osən' ḻicha na' yetoe' cuiten' yeglə. ");
INSERT INTO zavNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Na' beṉə' ca' chse'eɉ chəsə'əde' gan' da' Jeso'osən' chəsə'əḻoḻə yic̱hɉe'enə' gwso'onene' borl, ");
INSERT INTO zavNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","gwse'ene': —Len' gwnao' yoc̱hiṉɉo' yo'odao' əblaonə' na' šoṉə žazə yeyono'on, bosla cuino'. Šə len' naco' Xi'iṉ Diozən', beyetɉ ḻe'e yag corozən'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Na' len bx̱oz əblao ca' na' len beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' na' len beṉə' fariseo ca', na' len beṉə' golə blao ca', yogue'e gwso'one'ene' borl, na' gosə'əne': ");
INSERT INTO zavNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Yeziquə'əchlə beṉə' bosle' na' cabi chac yosla cuine'. Šə ḻen' naque' Rei c̱he chio'o beṉə' Izrael, yoletɉ cuine' ḻe'e yag corozən' ṉa'a na' šeɉḻe'echo c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ḻe' chonḻilaže'e Diozən', la' gwne': “Xi'iṉ Dioz nada'.” Na' le'icho yosla Diozən' ḻe' ṉa'a šə chaquene' c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Na' beṉə' bguan ca' zɉəda' ḻe'e yag corozən' cuite'enə' c̱hopə la'a, ḻeczə gwso'one'ene' borl. ");
INSERT INTO zavNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na' do gobiž goc žc̱hoḻ doxen yežlyon' bžinte cheda šoṉə. ");
INSERT INTO zavNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Na' do cheda šoṉə Jeso'osən' gwṉe' zižɉo gwne': —Eli, Eli, ¿lama sabactani? —zeɉen dižə': Dioz c̱hia', ¿bixc̱hen' bagwleɉyic̱hɉo' nada'? ");
INSERT INTO zavNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Na' catə' gwse'enene' xtiže'enə', baḻə beṉə' nitə' gaḻə'əzə gosə'əne': —Chaxe' profet Ḻiazən' ben' be' xtižə' Diozən' cana'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nach bchoɉ to beṉə' gwsa'adoe' ɉəx̱i'e to sponj na' bosgaže'en bino corrient de'en cui bi nc̱hix̱ə, na' bzo'en to lao ya dao' na' bosšine'en cho'a Jeso'osən' par nic̱h güe'eɉe'en. ");
INSERT INTO zavNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Na' yebaḻe' gwse'e be'enə': —Gwlezə. Yešc šə yidə Ḻiazən' par yosle'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nach bisya'a Jeso'osən' zižɉo na' be'e latɉə bchoɉ grasy c̱he'enə' gote'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Na' lao orən' catə'ən got Jeso'osən', ca naquə lachən' de'en ze ḻo'o yo'odao' əblaonə' gwchezə gwchoḻən gwza'azə yic̱hɉei bechoɉte che'elə. Na' ḻechguaḻe gwxo' xte gwso'oxɉ yeɉ ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Na' ḻeczə xte besyə'əyalɉo bloɉ ba ca'. Na' zan de'e beṉə' ca' gwso'onḻilažə' Diozən' besyə'əbane' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nach catə'ən beban Jeso'osən' ladɉo beṉə' guat ca', besyə'əchoɉe' ḻo'o ba c̱hega'aque' ca', na' ɉəya'aque' Jerosalenṉə' gan' naquə syoda c̱he Diozən'. Na' ɉəsyə'əlo'e laoga'aque' lao zan beṉə' lao' syodan'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na' ḻeczə lao orən' catə'ən got Jeso'osən', capitanṉə' len soḻdad c̱he' ca' nite'e chsa'ape' Jeso'osən'. Na' besə'əžebchgüe' catə' besə'əle'ine' can' gwxo' na' bichlə de'e ca' goquə, na' gosə'əne': —De'e ḻiczə benga naque' Xi'iṉ Dioz. ");
INSERT INTO zavNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Na' ḻeczə nitə' zan no'olə latɉən' beṉə' gosə'əzecha zitə'ələ na' besə'əle'ine' can' goquən'. No'ol quinga gosə'ənaogüe' Jeso'osən' catə' beze'e Galilean' par chsa'aclene' ḻe' len bi de'e chyažɉene'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Na' len no'ol quinga gwzo Maria beṉə' Magdala, na' ḻeczə len Maria ben' naquə xna' Jacob na' Jwse, na' ḻeczə ca' xna' Jacob na' Juan xi'iṉ Sebedeon'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Na' zo to beṉə' gwni'a beṉə' Arimatea le' Jwse, ḻeczə goque' disipl c̱he Jeso'osən'. Na' catə' bachzolao chex̱ɉw že'enə' ");
INSERT INTO zavNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jwsen' gwyeɉe' lao Pilatən' ɉəyeṉabe' cuerp c̱he Jeso'osən'. Nach Pilatən' bene' mendad bosyo'onežɉue'ene' cuerp c̱he Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nach Jwsen' bego'o lao ne'e cuerp c̱he'enə' na' blaže'ene' to lachə' de'e nyach. ");
INSERT INTO zavNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ca naquə Jwsen' bazo to bloɉ ba c̱he' de'e cobə de'e gwc̱he'ene' ḻe'e yeɉ, na' ḻo'o ba c̱he' na' gwlo'e cuerp c̱he Jeso'osən' na' bḻoḻe' to yeɉ xen de'e bseyɉue'ene' cho'a ban'. Nach beze'e. ");
INSERT INTO zavNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Na' Maria beṉə' Magdalan', na' yeto Maria yoblə, ɉesə'əchi'e cho'a banə'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Na' beteyo, gwde žan' catə'ən choso'osi'ini'e de'en chse'eɉ chsa'ogüe' ža lṉi pascon', besə'ədobə bx̱oz əblao ca' na' beṉə' fariseo ca' par ɉa'aque' gan' zo Pilatən'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Na' gwse'ene': —Señor, baɉəyeza'alažə'əto' can' gwna de'e beṉə' gox̱oayaguən' can' ṉembane' gwne': “Yeyoṉ ža yebana' ladɉo beṉə' guat ca'.” ");
INSERT INTO zavNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Bseḻə'əšga beṉə' žɉəsə'ədape' cho'a banə' lao šoṉə ža, nic̱h cui žɉa'ac disipl c̱he' ca' še'elə žɉəsyə'əleɉe' cuerp c̱he'enə' na' əse'e beṉə' de que babebane' ladɉo beṉə' guat ca'anə'. La' šə əsa'aque beṉə' de que bebane' ladɉo beṉə' guat ca', gonchən mal cle can' benən antslə catə'ən bx̱oayague' beṉə' par gwsa'aquene' de que Diozən' bseḻe'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nach Pilatən' gože' beṉə' ca': —Goṉa' le'e soḻdad ca'. Ḻe'e c̱he'ega'aque' par əsa'ape'en ga zelao yesə'əzaque'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nach ɉa'aque' len soḻdad ca' na' boso'oc̱hiše'e sey ḻe'e yeɉən', na' boso'onite'e soḻdad ca' gwsa'ape' ban'. ");
INSERT INTO zavNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Na' catə' gwde ža dezcanz c̱hechon', baḻ dmigw Maria beṉə' Magdalan', na' Maria ben' yeto, ɉa'aque' ɉəsə'əgüie' cho'a banə'. ");
INSERT INTO zavNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Na' goquən' ḻechguaḻe gwxo' c̱hedə' angl c̱he X̱anchon' betɉe' yoban', na' bžine' gwcue'e yeɉ de'en nseyɉw cho'a ban', na' gwchi'e lao yeɉən'. ");
INSERT INTO zavNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Na' anglən' ḻechguaḻe chactit cho'alaogüe'enə' caczə ga chep yes na' xala'ane'enə' naquən šyiš xilə' juisy caczə be'eyə'. ");
INSERT INTO zavNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Na' catə' besə'əle'i beṉə' gop ca' ḻe', ḻechguaḻe besə'əžebe' xte gosə'əxize' na' gosə'əbix̱e' gwsa'ate' šlat. ");
INSERT INTO zavNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pero na' anglən' gože' no'ol ca': —Bito žeble. Nada' ṉezda' de que Jeso'osən' ben' boso'ode'e ḻe'e yag coroz nan' cheyilɉle. ");
INSERT INTO zavNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Notoch no nḻa' nga. Babebane' ladɉo beṉə' guat ca', can' gwnacze'. Na' ḻe'e da ḻe'e ggüia latɉə ga nga bosə'əx̱oe' cuerp c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ḻežɉəya'acdo ḻe'e žɉəyedix̱ɉue'i disipl c̱he' ca' de que babebane' ladɉo beṉə' guat ca'. Na' ye'ega'aclene' de que gwyobe Jeso'osən' yežine' Galilean' cle ca le'e na' Galilea na' le'ilene'. Can' ben Diozən' mendad detix̱ɉue'ida' le'e. ");
INSERT INTO zavNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nach no'ol ca' besa'aque' cho'a banə' do chesə'əžebe' pero ḻechguaḻe chesyə'əbeine', zɉəya'acdoe' zɉəsyə'ədix̱ɉue'ine' disipl ca' dižə' cobən' de'en gož anglən' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Na' lao zɉəya'aque' zɉəsyə'ədix̱ɉue'ine' apostol ca' can' goquən', besyə'əžague' Jeso'osən' tnez. Nach gože' ḻega'aque': —Dioxei. Na' no'ol ca' gosə'əbigue'e gan' zo Jeso'osən', boso'ozo xibga'aque' laogüe'enə', na' gosə'əyele'e ṉi'enə' tant besyə'əbeine', na' gwso'elaogüe'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jeso'osən' gože' ḻega'aque': —Bito žeble. Ḻe'e žɉəyedix̱ɉue'i beṉə' lɉuežɉcho ca' de que cheyaḻə' əžɉa'aque' Galilean' nic̱h na' yesə'əle'ine' nada'. ");
INSERT INTO zavNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Na' catə' beza'ac no'ol ca' cho'a ban', baḻə soḻdad ca' beṉə' ca' gwsa'apə ba c̱he Jeso'osən' ɉa'aque' syodan' ɉəsyə'ədix̱ɉue'ine' bx̱oz əblao ca' can' bagoquən'. ");
INSERT INTO zavNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nach besyə'ədobə bx̱oz əblao ca' len beṉə' golə blao c̱he ṉasyon c̱hechon' bosə'əxi'e naclə so'one' ca naquə de'en əgwse' soḻdad ca' ḻega'aque'. Na' beyož boso'oxi'enə', boso'onežɉue' soḻdad ca' de'e sc̱ha'o mech. ");
INSERT INTO zavNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Gwse'e ḻega'aque': —Šə no əṉabe le'e bin' goquən', na' ye'ega'aclene' de que še'elə lao chtasle, disipl c̱he' ca' besyə'əbeɉe' cuerp c̱he'enə' ḻo'o ban' na' besyə'əyo'en ga yoblə. ");
INSERT INTO zavNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na' šə goberṉadorən' yenene' dižə' quinga, neto' žɉəyeye'exento'one' par nic̱h cui əže'e le'e na' par nic̱h cui gone' le'e castigw. ");
INSERT INTO zavNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Na' soḻdad ca' gosə'əzi'e mechən' de'en bosə'ənežɉue' ḻega'aque', nach gwso'one' con can' gwse' bx̱oz əblao ca' na' beṉə' golə blao ca' ḻega'aque'. Na' yoguə' can' gosə'əna soḻdad ca' gosə' gwlalɉən doxen gan' nitə' beṉə' Izrael gwlaž c̱hechon'. Na' xte ža ṉeža beṉə' gwlaž c̱hechon' chse'eɉḻe'e xtižə' soḻdad ca'. ");
INSERT INTO zavNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nach disipl c̱he Jeso'osən' beṉə' ca' šneɉ ɉa'aque' Galilean' par ɉəsyə'əšague' Jeso'osən' to lao ya'a gan' bene' mendad yesyə'əžague'. ");
INSERT INTO zavNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Na' catə' besə'əle'ine' Jeso'osən', gwso'elaogüe'ene'. Pero bia'aczə to c̱hope' gwsa'acžeɉlaže'e šə ḻe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nach bgüiguə' Jeso'osən' gan' nite'enə' na' gože' ḻega'aque': —Baben Diozən' par nic̱h chnabi'a doxen yoban' na' yežlyon'. ");
INSERT INTO zavNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","De'e na'anə', ḻe'e žɉa'ac ḻe'e žɉəsed ḻe'e žɉəlo'i beṉə' ca' ža' yoguə'əḻoḻ ṉasyon par nic̱h əsa'aque' disipl c̱hia'. Na' ḻe'e gwc̱hoaga'aque' nis par nic̱h yesə'əlo'e de que chso'onḻilaže'e X̱acho Diozən', na' nada' Xi'iṉe', na' Spirit c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Na' əgwsed əgwlo'iga'aquelene' par nic̱h so'one' yoguə'əḻoḻ de'en babena' mendad gonḻe. Nada' zocza' len le'e yoguə' ža xte ca te c̱he yežlyon'. De'e na'azən' chzoɉa'.");
INSERT INTO zavNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","De'en nga chzoɉa' naquən dižə' güen dižə' cobə de'en chzeɉni'in c̱he Jesocristən' ben' naquə Xi'iṉ Diozən'. Na' ṉa'a solaogua' gua'a xtiže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","De'e profet Isaiazən' ben' be' xtižə' Diozən' cana' bzoɉe' can' gož Diozən' Xi'iṉe'enə', gože'ene': Eseḻa'a to beṉə' güe'e xtižo'onə' par nic̱h ṉitə' beṉə' probnid par yoso'ozenague' c̱hio' catə'ən əžino' yežlyon'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ḻe' əṉe' zižɉo latɉə dašən', ṉe': “Ḻe'e so probnid par əgwzenagle c̱he X̱anchon' catə'ən yide'. Na' šə sole probnid par əgwzenagle c̱he' catə'ən yide', de'en gonḻe ca' gwxaquə'əleben can' chonḻe chxi' chloale nez ca' catə' chidə to beṉə' blao.” ");
INSERT INTO zavNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Na' goquən' catə' Juanṉə' ben' bc̱hoa beṉə' nis gwyeɉe' latɉə dašən', na' gwzolaogüe' gwdix̱ɉue'ine' beṉə' de que cheyaḻə' yesyə'ədiṉɉene' xtoḻə'əga'aque'enə' na' yesə'əṉabene' Diozən' əgwnitlaogüe'en, na' yesə'əchoe' nis. ");
INSERT INTO zavNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Na' beṉə' ca' za'ac yoguə' yež gan' mbane Jodean' na' beṉə' Jerosalen ca' gwsa'aque' ɉa'aque' yao Jordanṉə' gan' zo Juanṉə' par boso'ozenague' xtiže'enə'. Na' boso'ox̱oadoḻe'e lao Diozən', na' Juanṉə' bc̱hoe' ḻega'aque' nis ḻo'o yao Jordanṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juanṉə' gwyaze' lachə' de'en gwso'one' len yišə' xa camey. Na' par dobey c̱he' bc̱hine' to sint de yid. Na' gwdaogüe' bišə'əzo, na' ḻeczə gwdaogüe' ši'in bia ser bia nitə' yix̱ə'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Na' gwdix̱ɉue'ine' beṉə' gwne': —Yidə yeto beṉə' zaquə'əche ca nada', na' nada' bito zaca'a par gaca' xmose'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nada' babc̱hoa' le'e nis, pero na' be'enə' yidə gone' ca so Spirit c̱he Diozən' ḻo'o yic̱hɉla'ažda'ochon' na' ṉabi'an chio'o. ");
INSERT INTO zavNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Na' ca tyemp catə'ən bc̱hoa Juanṉə' beṉə' nis, Jeso'osən' gwze'e Nasaret gan' mbane Galilean', na' gwyeɉe' gan' zo Juanṉə' cho'a yao Jordanṉə' na' Juanṉə' bc̱ho'ene' nisən'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Na' catə' beyož gwchoa' Jeso'osən' nisən' bechoɉe' ḻo'o nisən'. Na' ḻe'e ble'iteine' byalɉo ḻe'e yoban' na' ble'ine' Spirit c̱he Diozən' betɉən ca to ngolbexə na' bžinən gwzon len ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na' benene' gwna Diozən' ben' zo yoban': —Le' naco' Xi'iṉa', na' chacchgüeida' c̱hio'. Ḻechguaḻe cheba chezaquə'əlaža'a le'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Na' Spiritən' ḻe'e benten par nic̱h gwyeɉ Jeso'osən' latɉə dašən'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Na' Jeso'osən' gwzoe' latɉə dašən' c̱hoa ža gan' chsa'aš bia znia ca'. Na' lao c̱hoa žan' Satanasən' de'en chnabia' de'e x̱io' ca' gwlo'oyeḻə'ən ḻe' gone' de'e malən'. Na' gwde cui gwzoin co'oyeḻə'ən ḻe' angl ca' besə'əžine' gwsa'aclene' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Na' gwde goso'ogüe'e Juanṉə' ližyan', Jeso'osən' gwyeɉe' gan' mbane Galilean' gwdix̱ɉue'ine' dižə' güen dižə' cobə can' ṉabia' Diozən' con notə'ətezə beṉə' əso'e latɉə. ");
INSERT INTO zavNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Na' gwne': —Babžin ža bžin or gaquə can' babžia Diozən' bia' gaquə. Na' babžin ža ṉabia' Diozən' con notə'ətezə beṉə' soe' latɉə. Ḻe'e yediṉɉe xtoḻə'əle ca' na' ḻešeɉḻe' dižə' güen dižə' cobə c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Na' Jeso'osən' gwyeɉe' cho'a nisdao' Galilean', na' lao zde' cho'inə' ble'ine' c̱hopə beṉə' gwxen beḻ, choso'ozaḻe'e yix̱ɉw beḻ c̱hega'aque'enə' ḻo'o nisda'onə'. Zɉənaquə c̱hopə biše'e. Toe' le' Simon na' ben' yeto le' Ndres. ");
INSERT INTO zavNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Nach gož Jeso'osən' ḻega'aque': —Ḻe'e da len nada'. Le'e nacle beṉə' gwxen beḻ. Pero ṉa'a gwzeɉni'ida' le'e par nic̱h gonḻe ca so'ombia' beṉə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Na' ḻe'e gosə'əbeɉyic̱hɉtega'aque' yix̱ɉw beḻ c̱hega'aque'enə' nach ɉa'aclene' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nach gwsa'aque' yelatə' na' ɉəsyə'ədi'e Jacobən' len Juanṉə' na' len x̱aga'aque' Sebedeon'. Že'e to ḻo'o barcw chesyə'əyone' yix̱ɉw beḻ c̱hega'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nach ḻe'e gwṉabtei Jeso'osən' Jacobən' na' Juanṉə' par žɉa'aclene' ḻega'aque'. Na' bosyo'ocua'aṉe' x̱aga'aquen' len xmosga'aque'en ḻo'o barcon' na' ɉa'aclene' Jeso'osən' na' beṉə' ca' banžague'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nach Jeso'osən' len disipl c̱he' ca' ɉa'aque' syoda de'en nzi' Capernaum, na' ža dezcanzən' ɉa'aque' yo'odao' c̱he neto' beṉə' Izrael na' Jeso'osən' bsed blo'ine' beṉə' ca' ža'anə'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Na' beṉə' ca' besyə'əbanene' ca naquə de'en bsed əblo'ine' ḻega'aque' la' can' bzeɉni'ine' ḻega'aque' nacbia' de que napəche' yeḻə' chnabia' cle ca beṉə' ca' choso'osed choso'olo'ine' ḻei de'en bzoɉ de'e Moisezən'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na' ḻo'o yo'odao' na' zo to beṉə' yo'o yaz de'e x̱io' yic̱hɉla'aždaogüe'enə'. Na' bgosya'an be'enə' gwnan: ");
INSERT INTO zavNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Partlə le', partlə neto' Jeso'os beṉə' Nasaret. ¿Ezedežiayi'o neto'onə'? Ṉezczeto' no le'. Le' naco' beṉə' la'aždao' xi'ilažə' juisy na' Diozən' bseḻe'e le'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jeso'osən' gwdiḻe' de'e x̱i'onə' na' gože'en: —Sšago'. Bechoɉ yic̱hɉla'aždao' benga. ");
INSERT INTO zavNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Na' de'e x̱i'onə' benən par gwyaz be'enə' šon, na' bgosya'aten ḻe' zižɉo nach bechoɉən yic̱hɉla'aždaogüe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Na' yoguə' beṉə' ca' ža'anə' ḻechguaḻe besyə'əbanene', nach gwse' lɉuežɉga'aque': —Nža' can' chzeɉni'ine' beṉə', na' nacbia' nape' yeḻə' chnabia' de'en chone' mendad yesyə'əchoɉ de'e x̱io' ca' ḻo'o yic̱hɉla'aždao' beṉə' na' chesyə'əchoɉən. ");
INSERT INTO zavNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Na' xtižə' Jeso'osən' ḻe'e gosə' gwlalɉten doxen Galilean'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nach catə' beza' Jeso'osən' yo'oda'onə' len tapte disipl c̱he' ca' ɉəya'aque' liž beṉə' ca' c̱hopə, liž Simonṉə' na' Ndresən'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na' taobin' c̱he Simonṉə' die' lao camən' yo'e de'e ḻa, nach gwse'e Jeso'osən' de que chacšenene'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jeso'osən' bgüigue'e bex̱e'e na' no'olən' na' bcose'ene'. Na' ḻe'e bechoɉte de'e ḻan', nach ḻe'e gwzoža'ate no'olən' bene' de'e gwsa'ogüe'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Baben bgüižən' catə' ɉso'e yoguə' beṉə' ca' chsa'acšenenə' na' beṉə' ca' zɉəyo'o zɉəyaz de'e x̱io' yic̱hɉla'ažda'oga'aque'enə' gan' zo Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Na' yoguə' beṉə' ža' yežən' ɉəsə'ədobe' cho'a puert liž Simonṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Na' Jeso'osən' beyone' zan beṉə' chse'i gwde gwde yižgüe', na' bebeɉe' de'e x̱io' ca' zɉəyo'o zɉəyaz yic̱hɉla'aždao' beṉə' zan. Na' bito be'e latɉə bi yesə'əna de'e x̱io' ca' c̱hedə' zɉəṉezen de que naque' Xi'iṉ Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ža beteyo, ṉencal catə' gwyas Jeso'osən' beze'e na' gwyeɉe' fuerlə syodan' to latɉə ga cui no nḻa', ɉene' orasyon. ");
INSERT INTO zavNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Na' Simonṉə' len beṉə' lɉuežɉe' ca' ɉa'aque' ɉəsyə'ədilɉe' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Na' catə' besyə'əželene' ḻe' gwse'ene': —Yoguə' beṉə' ža' syodan' chesyə'əyilɉe' le'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jeso'osən' gože' ḻega'aque': —Šeɉcho yež ca' zɉəchi' gaḻə'əzə, par nic̱h ḻeczə c̱hix̱ɉui'a xtižə' Diozən' len beṉə' ca' ža'anə', la' par na'anə' bseḻə' Diozən' nada'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ca' goquən' Jeso'osən' len disipl c̱he' ca' ɉa'aque' to to yež gan' mbane Galilean', na' ḻo'o yo'odao' c̱he neto' beṉə' Izrael de'en nitə' to to yež əbsed əblo'ine' beṉə', na' bebeɉe' de'e x̱io' ca' zɉəyo'o zɉəyaz yic̱hɉla'aždao' beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Na' goquən bgüiguə' to beṉə' lao Jeso'osən', beṉə' che'i yižgüe' de'en nzi' ḻepr, na' be'enə' bzo xibe' lao Jeso'osən' gože'ene': —Gonšguei ben par nic̱h yeyacda'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jeso'osən' beyaše'ene' ḻe', na' bḻi ne'enə' gwdane'ene' na' gože'ene': —Guacczə, beyaque. ");
INSERT INTO zavNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Na' ḻe'e beyactei be'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Nach Jeso'osən' bene' mendad len be'enə' gože'ene': —Bzenagšga. Ni tozə cui no güe'eleno' dižə' ca naquə nga babena' len le'. Gwyeɉ lao bx̱ozən' nic̱h le'ine' bac̱h beyacdo', na' bnežɉue' bia yix̱ə' gote' lao Diozən' par nic̱h yexi' yeyacho' can' na ḻei de'en bzoɉ de'e Moisezən' na' par nic̱h yesə'əṉeze beṉə' de que babeyacdo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero na' be'enə' beze'e gan' zo Jeso'osən' na' be'e dižə' len yoguə' beṉə' bežague' ca naquən' beyon Jeso'osən' ḻe'. Nach gosə' gwlalɉə dižə'ənə' xte benən ca cuich goquə šo' Jeso'osən' yež ca' na' cuich goquə te' con ca nḻa'azə. Gwde' fuerlə yež ca' gan' cui no beṉə' chaš. Pero bia'aczə zan beṉə' za'ac yoguə' yež ca' yeḻa' ɉa'aque gan' zoe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Na' goc to c̱hopə ža gwza' Jeso'osən' Capernaunṉə' catə' beyeɉe' de'e yoblə, na' gwse'ene beṉə' de que babežin Jeso'osən' liže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","3","Na' lgüegwzə besə'əžag beṉə' zan liže'enə' xte bitoch bi latɉə gotə' ḻo'o yo'o c̱he'enə' nic cho'a puertən' par šo'och beṉə'. Na' lao chsed chlo'i Jeso'osən' ḻega'aque' xtižə' Diozən', besə'əžin tap beṉə' zɉənḻene' to beṉə' nat to part cuerp c̱he'enə', zɉənx̱oe'ene' to lao cam dao'. ");
INSERT INTO zavNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Na' catə' gwsa'acbe'ine' cui gaquə yesə'əžinḻene' beṉə' güe'enə' gan' zo Jeso'osən' tant beṉə' zan ža'anə', gwse'epe' yic̱hɉo'olə. Na' boso'osalɉue' yic̱hɉo'onə' zaquə' gan' zo Jeso'osən' nach boso'oletɉe' be'enə' len xcame'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Na' gocbe'i Jeso'osən' de que gwso'onḻilažə' beṉə' ca' zɉənḻen beṉə' güe'enə', nach gože' beṉə' güe'enə': —Xi'iṉdaogua'a, babezi'ixena' xtoḻo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Pero baḻə beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' zɉəchi'e ḻo'o yo'onə'. Na' catə' gwse'enene' dižə' ca' be' Jeso'osən', gwso'one' xbab ḻo'o yic̱hɉla'ažda'oga'aque'enə': ");
INSERT INTO zavNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—¿Bixc̱hen' choe' benga dižə' quinga? Chžia chnite'e Diozən' ca de'en ne' de que chezi'ixene' xtoḻə' beṉac̱hən'. Notono gaquə yezi'ixen xtoḻə' beṉac̱hən' šə caguə tozə Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jeso'osən' ḻe'e gocbe'iteine' bi xbabən' gwso'one'enə', nach gože' ḻega'aque': —¿Bixc̱hen' chonḻe xbabən' ca' ḻo'o yic̱hɉla'ažda'olenə'? ");
INSERT INTO zavNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Šə con yapa'ane' de que babezi'ixena' xtoḻe'enə', bito ṉezele šə napa' yeḻə' gwnabia' par yezi'ixena'an. Pero šə yapa'ane': “Gwyas beyoa' xcamo'onə' na' beyeɉ ližo'onə' to šao' to güen”, guatə'əbia' šə napa' yeḻə' gwnabia'anə' par gaquə can' nia'anə'. ");
INSERT INTO zavNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Na' ṉa'a gona' par nic̱h əṉezele de que napa' yeḻə' gwnabia' lao yežlyo nga par yezi'ixena' xtoḻə' beṉac̱hən', nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. Nach gože' beṉə' güe'enə': ");
INSERT INTO zavNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Nada' əchnia' le', gwyas beyoa' xcamo'onə' na' beyeɉ ližo'onə' to šao' to güen. ");
INSERT INTO zavNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nach ḻe'e gwyasseste be'enə', na' beyoa' xcame'enə' beze'e zɉəyede' liže', chosə'əgüiate' beṉə' ca' nite'enə'. Na' yoguə' beṉə' ca' ža'anə' besyə'əbanene' na' gwso'elaogüe'e Diozən' gosə'əne': —Bitoṉə' le'icho gaquə ca de'e nga bagoc. ");
INSERT INTO zavNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Gwde na' Jeso'osən' gwyeɉe' cho'a nisda'onə' de'e yoblə na' beṉə' zan besə'əžag gan' zoe'enə' nach bsed blo'ine' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Na' catə' beyož bzeɉni'i Jeso'osən' ḻega'aque' beze'e na' lao zɉəyede'enə' ble'ine' to beṉə' goc̱hixɉw, beṉə' le Lebi xi'iṉ to beṉə' le' Alfeo, chi'e latɉə gan' chesə'əc̱hixɉue'enə'. Na' Jeso'osən' gože'ene': —Da len nada'. Nach Lebin' gwzože'e ɉənaogüe'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Na' goquən' chi' Jeso'osən' liž Lebin' len disipl c̱he' ca' chsa'ogüe'. Na' nitə' beṉə' zan beṉə' goc̱hixɉw ca' na' nochlə beṉə' güen de'e mal ca' chsa'olene' ḻega'aque'. Nitə' beṉə' zan c̱hedə' zane' choso'ozenague' c̱he' na' chso'onḻilaže'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' na' len beṉə' fariseo ca' catə' besə'əle'ine' chi' Jeso'osən' chaolene' beṉə' goc̱hixɉw ca' na' yebaḻə beṉə' güen de'e mal ca', gwse'e disipl c̱he' ca': —Malən' chon maestr c̱helen' che'eɉ chaogüe' txen len beṉə' goc̱hixɉw na' nochlə beṉə' güen de'e mal beṉə' cui chonḻento' txen. ");
INSERT INTO zavNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Na' catə' bene Jeso'osən' xtižə'əga'aque'enə', gože' ḻega'aque': —Beṉə' cui chsa'acšene bito chesə'əyažɉene' beṉə' güen rmech. Beṉə' ca' chsa'acšene ḻega'aque'enə' chesə'əyažɉene' beṉə' güen rmech. Nada' za'a zedəyena' par nic̱h beṉə' ca' zɉəṉeze de que zɉənaque' beṉə' güen de'e mal yesyə'ədiṉɉene' xtoḻə'əga'aque'enə', pero bito zedəyena' par nic̱h beṉə' ca' chsa'aquene' bazɉənaque' beṉə' güen yesyə'ədiṉɉene' xtoḻə'əga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Na' goquən' to ža catə' disipl c̱he Juanṉə' na' disipl c̱he beṉə' fariseo ca' nite'e sin cui chse'eɉ chsa'ogüe'. Na' ɉa'ac baḻə beṉə' lao Jeso'osən' na' gwse'ene': —Disipl c̱he Juanṉə' na' ḻeczə disipl c̱he beṉə' fariseo ca' chnite'e zan las sin cui chse'eɉ chsa'ogüe' par chso'ela'oche' Diozən'. Pero disipl c̱hio' ca' chse'eɉ chsa'ogüe'. ¿Bixc̱hen' ža? ");
INSERT INTO zavNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nach Jeso'osən' gože' ḻega'aque': —Catə' chac to yeḻə' gošagna' beṉə' migw c̱he be'enə' chžagna'anə' chse'eɉ chsa'ogüe'. Na' ca'aczən' naquən len nada' na' len disipl c̱hia' ca', chse'eɉ chsa'ogüe' lao ṉe'e zoa' len ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Catə'əchən' əžin ža yesə'əc̱he'ex̱ax̱ɉ beṉə' contr c̱hia' ca' nada', cana'achən' əchoɉ catə' cuich əse'eɉ əsa'o disipl c̱hia' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Notono beṉə' zo beṉə' chc̱hine' to pedas lachə' cuiṉə' x̱oa nis par yoda' xa gole'enə' de'en bac̱h chyoe. Šə can' gone', catə' c̱hib xe'enə', yebe' lachə' cobən' na' əc̱hezəchən ḻen. ");
INSERT INTO zavNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na' ḻeczə ca' notono zo beṉə' chgue'e bino cobən' ḻo'o yid golən'. Šə gone' ca', bino cobən' əc̱hezən yid golən' na' lalɉə binon' na' cuiayi' yidən'. Cle la' cheyaḻə' que'e bino cobən' ḻo'o yid cobə. Jeso'osən' gwne' ca' par bzeɉni'ine' ḻega'aque' de que bito gaquə yesə'ənaogüe' costombr gol c̱hega'aque'enə' na' yesə'ənaotie' de'en chsed chlo'ine'. ");
INSERT INTO zavNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Na' gozaquən' to ža dezcanz Jeso'osən' gwdie' len disipl c̱he' ca' gan' nyaž trigon', nach disipl c̱he' ca' gosə'əlec̱hɉe' trigon' lao gosə'ədi'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nach besə'əle'i baḻə beṉə' fariseo ca' can' gwso'on disipl ca' na' gwse'e Jeso'osən': —Bgüiašc can' chso'on disipl c̱hio' ca' žin de'e cui de lsens goncho ža dezcanzən'. ");
INSERT INTO zavNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Na' Jeso'osən' gože' ḻega'aque': —¿Ecabi za'alažə'əle de'en bablable can' ben de'e Rei Dabin' ca tyemp catə'ən goc Abiatarən' bx̱oz əblaoch? Nan de que to ža cui gotə' de'e əsa'o de'e Dabin' len beṉə' lɉuežɉe' ca' na' gosə'ədone'. Nach gwyeɉe' ḻo'o yo'odao' əblao c̱he c̱hio'o beṉə' Izrael. Na' gwxi'e yetxtil de'en bazɉəncua' bx̱oz ca' par Diozən', na' gwsa'ogüe'en len beṉə' lɉuežɉe' ca' ḻa'aṉə'əczə cui zɉənaque' bx̱oz, len yetxtilən' bito de lsens par gao notə'ətezə beṉə' ḻen, letga bx̱oz ca' chac əsa'ogüe'en. ");
INSERT INTO zavNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Na' ḻeczə gwna Jeso'osən': —Diozən' bene' beṉac̱hən' na' techlə gwleɉe' to ža lao xman par nic̱h beṉac̱hən' gaquə so'one' dezcanz. Bito gwleɉ Diozən' ža dezcanzən' parzə nic̱h so'omba'aṉe'en. ");
INSERT INTO zavNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Naquən lao na'a əṉia' bin' naquən güen goncho ža dezcanzən', nada' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Na' gozeɉ Jeso'osən' to ḻo'o yo'odao' c̱he neto' beṉə' Izrael yeto ža dezcanz. Na' ḻo'o yo'oda'onə' zo to beṉə' bambižə šḻa'a ne'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Na' beṉə' fariseo ca' ža' yo'oda'onə' chosə'əgüiateze' Jeso'osən' chesə'əbeze' šə goyone' be'enə' ža dezcanzən' par nic̱h əsa'ogüe' xya contr ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jeso'osən' gože' ben' mbižə ne'inə': —Gwzoža' na' da ngalə. Nach bgüiguə' ben' gwzeche' laogüe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jeso'osən' gože' beṉə' ca' ža' ḻo'o yo'oda'onə': —¿Ena ḻein' goncho de'e güen ža dezcanzən', o šə nan goncho de'e mal? ¿Enan goncho par nic̱h cui sa'at beṉə', o šə nan goncho par nic̱h sa'ate'? Pero beṉə' ca' ža'anə' bitobi gosə'əne'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nach Jeso'osən' bgüie' ḻega'aque' znia tant gwzoe' trist c̱hedə' cui chse'enene' se'eɉni'ine' bin' chene'e Diozən' so'one'. Nach Jeso'osən' gože' be'enə': —Bḻi na'onə'. Nach bḻi na' be'enə' na' beyaquen. ");
INSERT INTO zavNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nach beṉə' fariseo ca' catə' besa'aque' yo'oda'onə' bosə'əxi'e len beṉə' ca' chso'on txen len Erodən' naclə so'one' par so'ote' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jeso'osən' len disipl c̱he' ca' gwsa'aque' yo'oda'onə' na' ɉa'aque' cho'a nisda'onə'. Na' beṉə' zan ɉəsə'ənaogüe'ene' c̱hedə' gwse'enene' dižə' c̱he Jeso'osən' can' chone' de'e zan de'e zaque'e. Na' beṉə' ca' za'aque' do gan' mbane Galilean', na' do gan' mbane Jodean', na' do Jerosalenṉə', na' do Idomea, na' do yešḻa'a yao Jordanṉə', na' do gan' mbane Tiro na' Sidon. Za'aque' c̱hedə' gwse'enene' yesə'əle'ine' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Babeyon Jeso'osən' zan beṉə' chsa'acšene na' yoguə' beṉə' ca' ṉe'e chsa'acšene besyə'əyilɉlaže'e naclə so'one' par nic̱h yesə'əlapə na'aga'aquen' ḻe'. Tant beṉə' zan gosə'əbiadi'ene' xte boso'oc̱hi'ižoɉe'ene'. De'e na'anə' Jeso'osən' bene' mendad so'on disipl c̱he' ca' probnid to barcw par ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na' beṉə' ca' zɉəyo'o zɉəyaz de'e x̱io'on ḻo'o yic̱hɉla'ažda'oga'aquen' catə' besə'əle'ine' Jeso'osən' besə'əzo xibga'aque' laogüe'enə' na' de'e x̱io' ca' gwso'osya'an gosə'ənan: —Le' naco' Xi'iṉ Dioz. ");
INSERT INTO zavNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero Jeso'osən' bene' mendad len ḻega'aquən cui so'en dižə' non' naque'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Na' gwde na' Jeso'osən' gwloe' to lao ya'a na' goxe' yoguə' disipl c̱he' ca' par nic̱h cueɉe' beṉə' ca' əsa'ac apostol c̱he'enə', nach yogue'e gosə'əbigue'e gan' zoe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Na' gwleɉe' šižiṉ beṉə' par yesə'ədalene' ḻe' na' par nic̱h əseḻe'e ḻega'aque' žɉəsə'ədix̱ɉue'ine' beṉə' can' na Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Na' bnežɉue' ḻega'aque' yeḻə' gwnabia'anə' par nic̱h besyə'əyone' beṉə' ca' chse'i yižgüe' na' par nic̱h goc besyə'əbeɉe' de'e x̱io' ca' zɉəyo'o zɉəyaz yic̱hɉla'aždao' beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Gwleɉe' Simon ben' bsi'e Bed, ");
INSERT INTO zavNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","na' Jacobən' len Juan biše'enə' xi'iṉ Sebedeon'. Jeso'osən' bsi'e Jacobən' na' Juanṉə' Boanerges, c̱hedə' zɉənaque' beṉə' loc. ");
INSERT INTO zavNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Na' gwleɉe' Ndresən', na' Lipən', na' Bartolomen', na' Mtion', na' Tomasən', na' Jacob xi'iṉ Alfeon', na' Tadeon', na' Simon ben' chon txen len beṉə' ca' zɉənzi' cananistas. ");
INSERT INTO zavNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Nach gwleɉe' Jod Iscariotən' ben' bdie' Jeso'osən' lao na' beṉə' contr ca'. Gwde gwleɉe' disipl c̱he' ca' beyeɉe' liže'enə' len ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nach de'e yoblə besə'ədopə beṉə' zan gan' nite'enə' xte nic goquə latɉə əsa'ogüe'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Catə' gwse'ene famiḻy c̱he Jeso'osən' de que cui de latɉə c̱hega'aque' ni par əsa'ogüe', ɉa'aque' gan' zo Jeso'osən' par yesyə'əc̱he'ex̱ax̱ɉe'ene' c̱hedə' gosə'əna beṉə' de que chactonte'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Na' ḻeczə baḻə beṉə' Jerosalenṉə' beṉə' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' bla'aque', na' gosə'əne': —Beelsebo de'en chnabia' de'e x̱io' ca' yo'o yazən yic̱hɉla'aždao' benga, na' chebeɉe' de'e x̱io' ca' len yeḻə' guac c̱heinə'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nach Jeso'osən' goxe' beṉə' ca' par yesə'əbigue'e gan' zoe'enə' na' be'e jemplən' len ḻega'aque', gože': —Satanasən' de'en chnabia' de'e x̱io' ca' bito gaquə yebeɉ cuinei ḻo'o yic̱hɉla'aždao' beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Šə beṉə' ža' to ṉasyon əsa'aque' c̱hoplə na' yesyə'ədiḻe' entr ḻega'aque', əgwžiayi' ṉasyon c̱hega'aque' na'anə' šə ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na' šə to famiḻy beṉə' əsa'aque' c̱hoplə na' yesyə'ədiḻe' entr ḻega'acze', ḻeczə yenit famiḻy c̱hega'aque' na'anə' šə ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Na' ḻeczə ca' šə Satanasən' len de'e x̱io' c̱hei ca' əsa'aquən c̱hoplə na' yesyə'ədiḻən, cuiayi' yeḻə' chnabia' c̱hega'aquənṉə' šə ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ṉezecho notono no gaquə šo' liž to beṉə' gual par žɉəḻane' šinḻaze' ca' sin cui əgwc̱heɉe'ene' to do. Pero šə əgwc̱heɉe'ene' guaquə cuane' šinḻaze' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","De'e ḻi chnia' le'e, bitə'ətezə de'e mal de'en chso'on beṉac̱hən' na' bitə'ətezə dižə' mal de'e chso'e contr Diozən', Diozən' yezi'ixene' c̱hega'aque' šə yesyə'ədiṉɉene'en. ");
INSERT INTO zavNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero notə'ətezə beṉə' soe' dižə' contr Spirit c̱he Diozən' cuat yezi'ixen Diozən' c̱hega'aque'. Zeɉḻicaṉe yesə'əzi'e castigw c̱hei. ");
INSERT INTO zavNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Can' gwna Jeso'osən' c̱hedə' beṉə' ca' choso'osed choso'olo'i ḻein' gosə'əne' de que cho'o chaz de'e x̱io'onə' ḻo'o yic̱hɉla'ažda'ogüe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Gwde de'e ca' xna' Jeso'osən' len biše'e ca' besə'əžine' gan' zo Jeso'osən'. Na' chyo'olə gosə'əbeze' gosə'əṉabe' so'elene' ḻe' dižə'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na' beṉə' zan ca' zɉəchi' tcuit tcue'eɉ Jeso'osən' gwse'ene': —Xna'on len beṉə' bišo'o ca' zɉəzeche' chyo'olə na' chse'enene' əso'elene' le' dižə'. ");
INSERT INTO zavNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pero Jeso'osən' gože' ḻega'aque': —Nitə' beṉə' yoblə beṉə' bazɉənaquə ca xna'a na' ca biša'a. ");
INSERT INTO zavNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nach Jeso'osən' blo'e beṉə' ca' zɉəchi' tcuit tcue'eɉe'enə', gwne': —Beṉə' quingan' bazɉənaque' ca xna'a na' bazɉənaque' ca biša'a. ");
INSERT INTO zavNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Can' naquən len notə'ətezə beṉə' chso'one' can' chazlažə' Diozən', zɉənaque' ca xna'a na' ca biša'a na' ca zana'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Na' de'e yoblə gwzo Jeso'osən' cho'a nisda'onə' na' goszolaogüe' chsed chlo'ine'. Na' tant beṉə' zan besə'ədobə gan' zo'enə' xte benən byen gwyo'o Jeso'osən' gwchi'e to ḻo'o barcw de'en chi' gaḻə'əzə cho'a nisda'onə'. Na' yoguə' beṉə' ca' besə'ədobən' gosə'ənite'e lao yoxən'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nach Jeso'osən' bsed blo'ine' ḻega'aque' len zan jempl. Na' be'elene' ḻega'aque' to jempl bsaquə'əlebene' xtižə' Diozən' ca trigw. ");
INSERT INTO zavNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Nach gwne': —Ḻe'e gwzenag de'e nga. To beṉə' gwze'e zde' güen trigw. ");
INSERT INTO zavNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Na' lao chose' trigon' baḻən ɉəsə'əchazən cho'a nez na' bia žia x̱ile'e bia chaš ḻe'e yoban' gwsa'ob ḻen. ");
INSERT INTO zavNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Na' yebaḻən ɉəsə'əchazən ga naquə lao yeɉ ga cuitec žia yo. De'e na'anə' ḻe'e bla'acten. ");
INSERT INTO zavNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero na' catə' beža'achgua besə'əcuadən na' ḻe'e gosə'əbižten c̱hedə' bitobi loi gwso'on. ");
INSERT INTO zavNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Na' yebaḻən besə'əgo'oṉən lao yo ga nc̱hix̱ə xsa yešə' na' bla'aquən txen len xsa yešə'ənə'. Na' besə'əḻolə' yag yešə' ca' ḻega'aquən, na' bitobi gosə'əbian. ");
INSERT INTO zavNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Na' yebaḻən besə'əgo'oṉən lao yo šao' na' bla'aquən, na' gosə'əcha'on na' baḻən gosə'əbian šichoa güeɉə, na' yebaḻən gosə'əbian gyon güeɉə, na' yebaḻən gosə'əbian to gueyoa güeɉə. ");
INSERT INTO zavNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nach gož Jeso'osən' ḻega'aque': —Le'e žia nagle de'e chene ḻegwzenag. ");
INSERT INTO zavNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Na' catə' cuich nitə' beṉə' zan len Jeso'osən', disipl c̱he' ca' šižiṉ na' len yeziquə'əchlə beṉə' ca' zɉəsə'ənao ḻe', gosə'əṉabene' ḻe' bi zeɉen jemplən'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nach gože' ḻega'aque': —Diozən' chone' par nic̱h le'e əṉezele de'en cui no gwṉeze antslə de que ḻe' ṉabi'e con notə'ətezə beṉə' soe' latɉə. Pero beṉə' yeziquə'əchlə cho'elenga'aca'ane' jempl c̱hedə' bito chse'eɉḻe'e c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Chona' ca' par nic̱h yesə'əle'ine' de'en chona' na' bito sa'acbe'ine' bi zeɉen, na' par nic̱h əse'enene' xtiža'anə' na' cui se'eɉni'ine'en, c̱hedə' bazɉənaque' beṉə' la'aždao' žod. Žalə' bito zɉənaque' beṉə' la'aždao' žod, gwse'eɉni'ine' bi zeɉen de'en chse'enene'enə', na' yesyə'ədiṉɉene' xtoḻə'əga'aque'enə' na' Diozən' yezi'ixene' c̱hega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nach Jeso'osən' gože' ḻega'aque': —¿Ebitoṉə' šeɉni'ile jempl nga? Šə bito cheɉni'ilen' ¿nacxa šeɉni'ile jempl ca' yeḻa'? ");
INSERT INTO zavNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Quingan' zeɉen jempl c̱he beṉə' güen trigon'. Xtižə' Diozən' gwxaquə'əleben ca de'en gozə be'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Na' nitə' beṉə' choso'ozenague' xtižə' Diozən' na' ḻe'e chžinte Satanasən' de'en chnabia' de'e x̱io' ca' chebeɉən xtižə' Diozən' ḻo'o yic̱hɉla'aždaoga'aque'enə'. Na' chac c̱hega'aque' can' goquə len trigon' de'en ɉəsə'əchaz cho'a nezən'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Na' ḻeczə nitə' beṉə' choso'ozenague' xtižə' Diozən' na' ḻe'e chesyə'əbeiteine'en pero chac c̱hega'aque' can' goquə len trigon' de'en ɉəsə'əchaz lao yo de'en žia lao yeɉən'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Zɉənaque' ca to de'e cui bi loi chon, šložga chse'eɉḻe'e c̱he xtižə' Diozən'. Na' catə' chesə'əgue'i beṉə' ḻega'aque' na' choso'oc̱hi' choso'osaque'e ḻega'aque' laogüe de'en chse'eɉḻe'e xtižə' Diozən', nach ḻe'e chesə'əbeɉyic̱hɉte'en. ");
INSERT INTO zavNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Na' nitə' beṉə' choso'ozenague' xtižə' Diozən' na' chac c̱hega'aque' can' goquə' len trigon' de'en ɉəsə'əchaz lao yo de'en nc̱hix̱ə xsa yešə'ənə'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Chesyə'əlaḻ chesyə'əžeɉene' len bi de'en chso'one' na' chse'enene' yesə'əni'e, na' chesə'əzelaže'e gatə' bi de'en gatə' c̱hega'aque' c̱hedə' bazɉənx̱oayague' chsa'aquene' de que naquən de'e žialao. Na' de'e ca' chso'one'enə' choso'oḻolə'ən xtižə' Diozən' de'en bayo'o yic̱hɉla'aždaoga'aque'enə', na' de'e na'anə' cui chso'one' can' chazlažə' Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Na' ḻeczə nitə' beṉə' choso'ozenague' xtižə' Diozən' do yic̱hɉ do lažə'əga'aque', na' chso'one' yoguə'əḻoḻ can' chazlažə' Diozən'. Chac c̱hega'aque' can' goquə len trigon' de'en ɉəsə'əchaz lao yo güenṉə'. Baḻən gosə'əbian šichoa güeɉə, na' yebaḻən gosə'əbian gyon güeɉə, na' yebaḻən gosə'əbian to gueyoa güeɉə. ");
INSERT INTO zavNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nach Jeso'osən' be'elene' disipl c̱he' ca' yeto jempl, bsaquə'əlebene' de'en chsed chlo'ine'enə' ca to yi', gwne': —Notono no ggualə' to yi' na' gwdose'en to žomə na' nic no gwcuašə'ən xan xcamei. Syempr chde'e yi'inə' ḻe'e ze'e par nic̱h əgwse'eni'in ḻo'o cuartən'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Guaquə can' na dicho de'en na: “Yoguə'əḻoḻ de'en ngašə' ṉa'a, gwžin ža la'alaon, na' yoguə'əḻoḻ de'en cui no gwse'eɉni'i antslə, ḻeczə gwžin ža se'eɉni'i beṉə' ḻen.” ");
INSERT INTO zavNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Le'e žia nagle de'e chene, ḻegwzenag. ");
INSERT INTO zavNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Na' ḻeczə gož Jeso'osən' ḻega'aque': —Ḻe'e gon xbab c̱he de'en nga chnia' le'e. Con can' chzenagle xtiža'anə' ḻeczə can' gona' par nic̱h šeɉni'ilen, na' ca'aczə c̱ha'oxen de'en šeɉni'ile. ");
INSERT INTO zavNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Šə chzenagle xtiža'anə' əgwzeɉni'ichda' le'e. Pero na' šə bito chzenagle c̱hei, de'e daon' baṉezele ganḻažə'əlen. ");
INSERT INTO zavNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yeḻə' gwnabia' c̱he Diozən' ben' zo yoban' gwxaquə'əleben ca de'e nga: To beṉə' chɉeze' xoa' biṉnə' lao yežlyo c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Chde na' cheyeɉe' chɉəyetase' na' catə' chžin or chase' na' chase'. Na' ca'azə chac chesə'əde ža ca' na' yel ca'. Na' chla'ac yel dao' ca' na' chesə'əcha'on. Pero bito ṉeze be'enə' nac chaquən' chesə'əcha'o yel dao' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yežlyo na'anə' chonən par nic̱h chla'ac yel dao' ca' na' chesə'əcha'on na' chəsə'əbian za'a nach chaquən yez. ");
INSERT INTO zavNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Na' catə' babgüiž yezən', be'enə' gozə ḻen chelape'en c̱hedə' banaquə tyemp par chetobe' cwsešən'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nach gwna Jeso'osən': —Ṉa'a əgwlo'ida' le'e par nic̱h əṉezele naquən' gwxaquə'əlebe yeḻə' gwnabia' c̱he Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Gwxaquə'əleben ca to xsa moztas de'en chaz to beṉə' lao yežlyo c̱he'enə'. Xsa moztasən' naquən ḻe'ebeyožə de'e dao' rizə' lao bitə'ətezəchlə semiy. ");
INSERT INTO zavNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero na' catə' chla'an chcha'on na' chaquən to yag cha'odao' na' chesə'əcha'o xoze'e ca' xte bia ca' zɉəzo x̱ile'e chso'on ližga'aquəb ḻo'o xoze'e ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jeso'osən' bsed blo'ine' beṉə' zan ca' besə'əžag gan' zo'enə' porzə len jempl ca de'e quinga babzoɉa', bzeɉni'ine' beṉə' xte ga zelao gwse'eɉni'ine'en. ");
INSERT INTO zavNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Bitobi bichlə gwne' par bzeɉni'ine' ḻega'aque' sino porzə len jempl bzeɉni'ine' ḻega'aque'. Pero na' disipl c̱he' ca' bzeɉni'ine' ḻega'aque' clar bi zeɉen to to jempl ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na' ḻe'e ža ṉa'atezə do chxentg catə' Jeso'osən' gože' disipl c̱he' ca': —Eḻaguə'əcho yešḻa'alə nisda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nach disipl c̱he' ca' bosyo'ocua'aṉe' beṉə' ca' nitə'ənə' na' boso'ose'e barcon' gan' bayo'o Jeso'osən'. Nach yebaḻə barcon' gan' ža' beṉə' ca' ɉəsə'ənaon ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Na' lao zda barcon' gwzolao gwyec̱hɉ to be' gual lao nisda'onə'. Na' barcon' gwyeɉən nil na'aḻə por ni c̱he be'enə', na' chas chatə' nisən' xte gwzolao gwyož barcon' nisən'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pero na' Jeso'osən' bachtase' xni'ate barcon' lao to lmad, tant chɉx̱aque'ene'. Nach bosyo'osbane'ene' gwse'ene': —¡Maestr! ¿Ebitobi chacdo' de'en bac̱h chbiayi'ichon'? ");
INSERT INTO zavNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nach Jeso'osən' gwyase' lao ṉe'e chas chatə' nisda'onə', nach gwdiḻe' be'enə', na' bene' mendad len nisda'onə' gože'en: —Bebe'eži. Nach ḻe'e besyə'əbe'ežite be'enə' len nisda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nach Jeso'osən' gože' disipl c̱he' ca': —Bito žeble. Ḻe'e šeɉḻe'ech c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Na' ḻega'aque' besyə'əbanchgüeine' na' gwse' lɉuežɉga'aque': —Bitolɉa naquə benga con to beṉac̱hzə, la' ¿nacxa gon to beṉac̱h par yebecžie' be' gualən' len nisda'onə'? ");
INSERT INTO zavNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jeso'osən' na' disipl c̱he' ca' besə'əžine' yešḻa'alə nisda'onə' gan' naquə laž beṉə' Gadara ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Na' catə' bechoɉ Jeso'osən' ḻo'o barcon', beza' to beṉə' Gadaran' capsantən' ɉəšague' ḻe'. Na' be'enə' yo'o yaz de'e x̱io' ca' yic̱hɉla'aždaogüe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Benga con gwzoe' do capsant. Na' notoch no goquə gwc̱heɉ ḻe' ni len do gual nic len gden. ");
INSERT INTO zavNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Zan las boso'oc̱heɉe' ṉi'a ne'e ca' gden, pero syempr de'e x̱io' ca' gwso'onən ca bzoxɉ btine' gdenṉə', na' notono goquə ṉabia' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Do ža do yel gwde' do lao ya'a ca' na' do capsantən' bisye'e na' bene cuine' zi' len yeɉ. ");
INSERT INTO zavNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Na' catə' ble'ine' zda Jeso'osən' zitə'ələ na' gwsa'adoe' ɉəšague'ene' na' bzo xibe'en lao Jeso'osən' be'elaogüe'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Nach de'e x̱io' ca' yo'o yaz yic̱hɉla'aždaogüe'enə' gosə'əṉen zižɉo gosə'ənan: —Partlə le', partlə neto' Jeso'os Xi'iṉ Dioz ben' naquə ḻe'ezelaogüe beṉə' blao. Diozən' naque' testigw c̱heto' chatə'əyoito' le' cui əgwc̱hi' əgwsaco'o neto'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Gosə'ənan ca' c̱hedə' Jeso'osən' bene' mendad gože' ḻega'aquən: —De'e x̱io' ḻe'e yechoɉ yic̱hɉla'aždao' benga. ");
INSERT INTO zavNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nach gož Jeso'osən' ḻega'aquən: —¿Bi lele? Na' gosə'ənan: —Legionṉə' leto' c̱hedə' naquə zanto'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Na' be'enə' gotə'əyoine' Jeso'osən' par cui əseḻe'e de'e x̱io' ca' fuerlə laž be'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na' to ya'a de'e zo gaḻə'əzə chaš beṉə' choso'oye' coš zan. ");
INSERT INTO zavNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Na' de'e x̱io' ca' gwsa'atə'əyoin ḻe' gwse'en: —Be'ešga latɉə žɉəyežo'oto' yic̱hɉla'aždao' coš ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nach Jeso'osən' be'e latɉə. Na' besyə'əchoɉ de'e x̱io' ca' yic̱hɉla'aždao' be'enə' na' ɉəsyə'əžo'on yic̱hɉla'aždao' coš ca'. Nach besyə'ədiṉsesəb ḻe'e ya'anə' na' ɉesyə'əxopəb ḻo'o nisda'onə' na' gwsa'atəb gwse'eɉəb nisən'. Na' ca do c̱hopa mil coš can' zɉənaquə. ");
INSERT INTO zavNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Na' beṉə' ca' chosə'əye' coš ca' besə'əle'ine' de'en bagoquən' na' de'en besə'əžebchgüe' besa'acdoe' nach ɉəsyə'ədix̱ɉue'ine' beṉə' lao' syodan' na' beṉə' nitə' do yoba. Na' beṉə' ca' catə' gwse'enene' xtižə' beṉə' goye coš ca' ɉa'aque' ɉəsə'əgüie' de'en bagoquən'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Na' catə' besə'əžine' gan' zo Jeso'osən' besə'əle'ine' be'enə' gwyo'o gwyaz de'e x̱io' ca' yic̱hɉla'aždaogüe'enə', bachi'e nyaz xalane'e, na' babezošao' yic̱hɉla'aždaogüe'enə', na' besə'əžebe' de'en goquən'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Na' beṉə' ca' besə'əle'i de'en goquən', gwse'e beṉə' ca' yeḻa' can' beyaque ben' gwyo'o de'e x̱io' ca' yic̱hɉla'aždaogüe'enə' na' can' goquə len coš ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nach beṉə' ca' ža' gan' mbane Gadaran' ɉse'etə'əyoine' Jeso'osən' yeze'e lažga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Na' catə' Jeso'osən' beyo'e ḻo'o barcon' par yeze'e len disipl c̱he' ca', ben' bechoɉ de'e x̱io' ca' yic̱hɉla'aždaogüe'enə' gotə'əyoine' Jeso'osən' šeɉlene' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero Jeso'osən' bito be'e latɉə, gože'ene': —Beyeɉ ližo' gan' ža' famiḻy c̱hio' ca' na' ɉəyedix̱ɉue'iga'aquene' catec de'e mban' baben X̱ancho Diozən' len le', na' can' bacheyašə' cheži'ilaže'e le'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nach beza' be'enə' gwzolaogüe' ɉəyede' yoguə' syoda ca' gan' mbane Decapolisən' ɉəyezenene' catec de'e mban' baben Jeso'osən' len ḻe'. Na' yogue'e besyə'əbanene'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Na' catə' besḻaguə' Jeso'osən' len disipl c̱he' ca' yešḻa'alə nisda'onə' besyə'əchoɉe' ḻo'o barcon'. Na' besə'əžin beṉə' zan gan' nite'e cho'a nisda'onə', na' besyə'əga'aṉe' na'azə. ");
INSERT INTO zavNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nach bžin to beṉə' le Jairo, naque' to beṉə' gwnabia' c̱he yo'odao' c̱he neto' beṉə' Izrael. Na' catə' ble'ine' Jeso'osən' bzo xibe' laogüe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Na' gotə'əyoichgüeine' ḻe', gože'ene': —Xi'iṉa' no'olən' bachatbo'. Yo'ošga cano'obo' par nic̱h yeyaquebo' na' par nic̱h əbambo'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nach Jeso'osən' txen len disipl c̱he' ca' ɉa'aclene' beṉə' gwnabian'. Na' beṉə' zan ɉəsə'ənaogüe' ḻega'aque' xte boso'oc̱hi'ižoɉene'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na' entr beṉə' ca' len to no'olə beṉə' bagoc šižiṉ iz chzoe' bgua'a. ");
INSERT INTO zavNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Na' babžaglaogüe' gwyeɉe' lao zan beṉə' güen rmech ca' na' babenditɉei zgade xmechen' len ḻega'aque' na' notono goquə yeyon ḻe'. Con byaḻə'əch yižgüe' c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Na' no'olən' babenene' xtižə' Jeso'osən', na' bgüigue'e cožə' Jeso'osən' gan' zde' ladɉo beṉə' ca' ɉəsə'ənao ḻe' nach gwdane' xadoṉ c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Bene' xbab ḻo'o yic̱hɉla'aždaogüe'enə', gwne': —Šə con cana' xadoṉ c̱he'enə', goyacczəda'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Na' ḻe'e gwlezte bgua'a de'en chzo'enə' na' gocbe'ine' de que babeyaquene'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nach Jeso'osən' ḻeczə gocbe'ine' de que babeyone' to beṉə' len yeḻə' guac c̱he'enə', na' gwyec̱hɉe' bgüie' beṉə' ca' zɉəsə'ənao ḻe', nach gože' ḻega'aque': —¿Non' bagwdan xadoṉ c̱hia'anə'? ");
INSERT INTO zavNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nach disipl c̱he' ca' gwse'ene': —Chle'ido' nitə' beṉə' zan nga, na' choso'oc̱hi'ižoɉe' le'. Na' nao': “¿Non' gwdan nada'?” ");
INSERT INTO zavNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero na' Jeso'osən' bgüie' yogue'e par nic̱h ḻe'ine' non' gwdan ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Na' no'olən' de'en gocbe'ine' babeyaquene' na' do chaž chžebze' bgüigue'e bzo xiben' lao Jeso'osən' par gože'ene' doḻoḻ can' bagoc c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nach Jeso'osən' gože'ene': —Xi'iṉdaogua'a, babeyacdo' c̱hedə' chonḻilažo'o nada'. Beyeɉ to šao' to güen na' Diozən' gone' par nic̱h cuich gue'ido' yižgüen' nac ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ṉe'e cho'ete Jeso'osən' dižə'ən ca' catə' besə'əžin beṉə' gwsa'ac liž Jairon' ben' naquə x̱a bi'i no'olən' ɉse'eže'ene': —Bagot bi'i no'ol dao' c̱hio'onə'. Bitoch gondo' maestrən' zed. ");
INSERT INTO zavNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero Jeso'osən' bito bene' cas c̱he de'enə' ɉež be'enə', con gože' Jairon': —Bito žebo'. Con benḻilažə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Na' bito be' Jeso'osən' latɉə əžɉa'aquəch beṉə' ca' len ḻe', sino Bedən' len Jacobən' na' Juan beṉə' bišə' Jacob na'azən' ɉa'ac len ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Na' catə' besə'əžine' liž beṉə' gwnabian', Jeso'osən' ble'ine' de que beṉə' ca' ža' cha'ašilən' bachso'one' scaṉdl na' bachesə'əbežchgüe'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nach catə' gwyo'e cha'ašilən', gože' ḻega'aque': —¿Bixc̱hen' bachonḻe scaṉdl na' chbežle? Bito nacbo' bi'i guat, con chtasbo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Na' gosə'əzi'ic̱hižə' beṉə' ca' ža'anə' ḻe'. Nach Jeso'osən' bebeɉe' yoguə' beṉə' ca' ža'anə', na' gwc̱he'e x̱axna' bi'i guatən' na' beṉə' ca' zɉa'aclen ḻe' na' gwso'e ḻo'o cuartən' gan' debo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nach bex̱e'e na' bi'i no'olə guat da'onə' na' boḻgüiže'ebo' gože'ebo': —Talita comi—, zeɉe dižə': “No'ol dao', əchnia' le', beyas.” ");
INSERT INTO zavNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nach ḻe'e beyaste bi'i no'ol daon' na' bedabo'. Nacbo' bi'i šižiṉ ize. Nach x̱axna'abo'on len beṉə' ca' yeḻa' ža' ḻo'o cuartən' besyə'əbanchgüeine'. ");
INSERT INTO zavNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jeso'osən' bene' mendad cui əso'e dižə' can' goquən', na' ḻeczə bene' mendad len x̱axna'abo'on əso'ebo' de'e gaobo'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Na' Jeso'osən' len disipl c̱he' ca' besa'aque' Capernaunṉə' na' ɉəya'aque' Nasaret gan' gwcha'o Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na' ža dezcanzən' gwyeɉe' yo'odao' c̱he neto' beṉə' Izrael na' gwzolao bsed əblo'ine' beṉə'. Na' beṉə' zan beṉə' ca' gwse'enene' xtiže'enə', besyə'əbanene' na' gwse'e lɉuežɉga'aque': —¿Nacxa goquən' ṉeze benga yoguə' de'en chsed chlo'ine'en ža? ¿No bzeɉni'i ḻe' de'en naquə de'e si'inṉə'?, na' ¿nac chaquən' chone' miḻagr? ");
INSERT INTO zavNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nombi'acho benga. Ḻe'enə' carpinter xi'iṉ Marian', na' beṉə' bišə' Jacob, na' Jwse, na' Jodas, na' Simon. Nach zane' ca' nitə' lažcho nga. Na' de'en gwso'one' xbab de que Jeso'osən' naque' con to beṉə' gwlaž c̱hega'aque', de'e na'anə' bito gwse'eɉḻe'e c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Na' gož Jeso'osən' ḻega'aque': —Ḻa'aṉə'əczə beṉə' zan chso'e yeḻə' bala'aṉ c̱he beṉə' ca' chso'e xtižə' Diozən', pero beṉə' gwlaž c̱hega'aque' ca' na' famiḻy c̱hega'aque' ca' na' beṉə' ca' nitə' ližga'aque' bito chso'e ḻega'aque' yeḻə' bala'aṉ. ");
INSERT INTO zavNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Na' laogüe de'en cui gwse'eɉḻe'e c̱he Jeso'osən', bito bene' zan miḻagr Nasaretən' con de'e bene' bx̱oa ne'enə' to c̱hopə beṉə' na' besyə'əyaquene'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Na' bebane Jeso'osən' de'en cui gwse'eɉḻe'e c̱he'. Na' gwdechlə gwyeɉe' len disipl c̱he' ca' na' bzeɉni'ine' beṉə' ca' ža' yež ca' de'en zɉəchi' gaḻə'əzə. ");
INSERT INTO zavNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jeso'osən' botobe' disipl c̱he' ca' šižiṉ na' bnežɉue' ḻega'aque' yeḻə' guac par nic̱h əsa'aque' yesyə'əbeɉe' de'e x̱io' ca' zɉəyo'o zɉəyaz yic̱hɉla'aždao' beṉə'. Na' bseḻe'e c̱hopə güeɉəga'aque' ɉəsə'ədix̱ɉui'e xtiže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Na' bene' mendad len ḻega'aque' bitobi əso'ox̱e'e tnezən', sino tozə garrot. Gože' ḻega'aque' de que bito cheyaḻə' əso'e bsod, ni yet, ni mech. ");
INSERT INTO zavNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Be'e latɉə yoso'oleɉe' šcue' yel, na' əsa'aze' tozə camis. ");
INSERT INTO zavNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Na' ze'e sa'aque' catə' gože' ḻega'aque': —Catə' əžinḻe liž beṉə' yesyə'əbei yoso'ogüialao le'e, na'atezə sole na' na'atezə yesa'acle par žɉa'acle ga yoblə. ");
INSERT INTO zavNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na' gatə'ətezə əžinḻe ga cui nono yebei əgüialao le'e, na' nic yoso'ozenague' c̱hele, ḻe'e yesa'ac latɉən'. Na' catə' yesa'aclen', əgwsi'iṉs ṉi'alen' par yežib bišten' de'en gwžianṉə', nic̱h əgwlo'ile beṉə' ca' de que de'e malən' chso'one' cui choso'ozenague' xtižə' Diozən' de'en cho'elen'. Diozən' bene' par nic̱h byiṉɉ yi' na' sofr lao' syoda Sodoman' na' syoda Gomorran' por ni c̱he de'en cui boso'ozenag beṉə' ca' c̱he'. Na' de'e ḻi əchnia' le'e catə' əžin ža gon Diozən' castigw zeɉḻicaṉe c̱he yoguə' beṉə' ca' chso'on de'e malən', beṉə' ca' cui yoso'ogüialao le'e yesə'əzaquə'əzi'iche' clezə ca beṉə' ca' gwnitə' Sodoman' na' Gomorran'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nach gwsa'ac disipl ca' na' ɉəsə'ədix̱ɉui'e de que beṉac̱hən' cheyaḻə' yesyə'ədiṉɉene' xtoḻə'əga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Na' ḻeczə besyə'əbeɉe' zan de'e x̱io' de'en zɉəyo'o zɉəyaz yic̱hɉla'aždao' beṉə' na' boso'ošone' set lao cuerp c̱he zan beṉə' ca' chsa'acšene na' gwso'one' par nic̱h besyə'əyaquene'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Na' Erodən' ben' chnabia' beṉə' Galilea ca' benene' dižə' ca naquə yoguə'əḻoḻ de'e güen de'en ben Jeso'osən', la' beṉə' zan gosə'əṉezene' de'e ca' ben Jeso'osən'. Nach gwna Erodən': —Bengan' de'e Juanṉə' ben' bc̱hoa beṉə' nis. Babebane' ladɉo beṉə' guat ca', na' de'e na'anə' chac chone' miḻagr quinga. ");
INSERT INTO zavNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nach yebaḻə beṉə' gosə'əne': —Naque' profet Ḻiazən' ben' be' xtižə' Diozən' cana'. Nach yebaḻe' gosə'əne': —Naque' to profet ben' choe' xtižə' Diozən' can' gwso'on de'e profet beṉə' ca' gwnitə' cana'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pero catə' bene Erodən' xtižə' beṉə' ca' na' gwne': —Bengan' de'e Juanṉə' ben' bena' mendad gosə'əc̱hogue' yene', na' ṉa'a babebane' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Quinga goquə got Juanṉə'. Erodən' beque'e Erodiasən' ca xo'ole', len Erodiasən' naque' xo'olə Lip biše'enə'. Na' Juanṉə' gože' Erodən': “Malən' beno' beca'o no'ol c̱he beṉə' bišo'onə' par naque' xo'olo'.” Na' de'en gož Juanṉə' Erodən' ca', de'e na'anə' Erodən' bene' mendad gosə'əzene' Juanṉə' na' gosə'əgüe'ene' ližyan', na' boso'oc̱heɉe' ṉi'a ne'e ca' gden. ");
INSERT INTO zavNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Erodiasən' gwlo'olaže'e Juanṉə' por ni c̱he de'en gože' Erodən' ca', na' gone'ene' gote'ene', pero bito goquə. ");
INSERT INTO zavNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Erodən' gocbe'ine' de que Juanṉə' zdacze' ḻicha na' de que naque' to beṉə' güen. De'e na'anə' bžeb Erodən' gone' mendad so'ote' Juanṉə' na' de'e na'anə' bito be' Erodən' latɉə bi gone no'olən' Juanṉə'. Na' ḻa'aṉə'əczə bitotec gwyeɉni'i Erodən' bi de'en gwna Juanṉə', bebeine' bzenague' xtiže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero na' gotə' to latɉə par got Erodiasən' Juanṉə'. Catə'ən gwye'i Erodən' iz, bene' to lṉi par beṉə' gwnabia' c̱he' ca', na' par beṉə' gwnabia' c̱he soḻdad ca', na' par beṉə' blao ca' nitə' Galilean' gan' chnabi'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Bi'i no'ol c̱he Erodiasən' gwyo'obo' ḻo'o cuart gan' chsa'o beṉə' ca' na' bya'abo'. Na' ḻechguaḻe bebei Erodən' na' len beṉə' ca' chsa'olen ḻe' txen can' bya'abo'. Nach Rei Erodən' gože'ebo': —Gwṉab bitə'ətezə de'en che'endo' na' goṉa'an. ");
INSERT INTO zavNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Na' bene' lyebe len ḻebo' bzoe' jorament de que əgwnežɉue'ebo' bitə'ətezə de'e əṉabebo' ḻe' ḻa'aṉə'əczə šə gašɉə ṉasyon gan' chnabie'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nach bechoɉbo' na' gožbo' xna'abo'onə': —¿Bin' əṉabda'ane' goṉe'? Nach xna'abo'onə' gože'ebo': —Gwṉabene' goṉe' le' yic̱hɉ Juanṉə' ben' bc̱hoa beṉə' nis. ");
INSERT INTO zavNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nach ḻe'e beyo'oseste bi'i no'olən' gan' chaolen rein' beṉə' ca' yeḻa', na' gožbo' rein': —Beṉ nada' ṉa'atec ṉa'a yic̱hɉ Juanṉə' ben' bc̱hoa beṉə' nis bžian to lao plat. ");
INSERT INTO zavNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nach rein' gwzochgüe' trist catə' beyož gož bi'i no'olən' ḻe' ca', pero na' bac̱hlə bzoe' jorament len ḻebo' lao beṉə' ca' zɉənaquə combidən'. De'e na'anə' benšaze' can' gwṉabe bi'i no'olən' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nach ḻe'e bente rein' mendad šeɉ to soḻdad žɉəc̱hogue' zelao yen Juanṉə' na' əgwži'e yic̱hɉe'enə' to lao plat. ");
INSERT INTO zavNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nach gwyeɉ soḻdadən' ližya gan' de Juanṉə' ɉəc̱hogue' yene'enə' na' bži'en to lao plat. Nach beyox̱e'en ɉəyenežɉue'en bi'i no'olən', na' bi'i no'olən' bnežɉwbo'on xna'abo'on. ");
INSERT INTO zavNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Catə' gwse'ene disipl c̱he de'e Juanṉə' de'en goquən', ɉəsyə'əxi'e cuerp c̱he'enə' na' ɉəsə'əcuaše'en. ");
INSERT INTO zavNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Na' catə' besyə'əžin disipl c̱he Jeso'osən' gan' zoe'enə' gwso'elene'ene' dižə' can' ɉse'ene'enə', na' can' ɉəsə'ədix̱ɉui'e can' na Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jeso'osən' gože' ḻega'aque': —Ḻe'e da, šeɉcho to latɉə ga cui no nḻa' žɉencho šlož dezcanz. Gwne' ca' c̱hedə' beṉə' zan chsa'aš gan' nite'enə', na' cui goquə latɉə par gao Jeso'osən' len disipl c̱he' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nach Jeso'osən' len disipl c̱he' ca' gwso'e to ḻo'o barcw na' gosə'əḻague'e nisda'onə' par besə'əžine' to latɉə ga cui no nḻa'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero beṉə' zan besə'əle'ine' ḻega'aque' catə'ən gwsa'aque', na' besyə'əyombi'e Jeso'osən'. Nach gwsa'acdo beṉə' ca' ža' yoguə' yež ca' zɉəchi' gaḻə'əzə əzɉa'aque' zaquə' galən' əžin Jeso'osən' len disipl c̱he' ca' na' byobəch besə'əžine' cle ca Jeso'osən' len disipl c̱he' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Na' catə' besə'əžine' cho'a nisda'onə' Jeso'osən' ble'ine' beṉə' zan ca' na' beyašə'əlaže'e ḻega'aque', c̱hedə' gocbe'ine' de que zɉənaque' ca xilə' ca' bian' cui no x̱ane de. Na' Jeso'osən' bzeɉni'ine' ḻega'aque' de'e zan. ");
INSERT INTO zavNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Na' catə' bachex̱ɉw že'enə' gosə'əbiguə' disipl c̱he' ca' laogüe'enə' na' gwse'ene': —Bachaḻ ṉa'a na' zocho to latɉə ga cui no nḻa'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Bitobi de c̱he beṉə' quinga par əse'eɉ əsa'ogüe'. Bzeišgueiga'aquene' dižə' nic̱h žɉəya'aque' yež ca' de'en zɉəchi' gaḻə'əzə par nic̱h žɉəsə'əxi'e de'e se'eɉ əsa'ogüe'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nach Jeso'osən' gože' ḻega'aque': —Ḻe'e gwnežɉo de'e sa'ogüe'. Na' gwse'ene': —¿Eche'endo' šeɉcho žɉəx̱i'icho tmil pes yetxtilən' par əgwnežɉwchon əsa'o beṉə' quinga? ");
INSERT INTO zavNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nach Jeso'osən' gože' ḻega'aque': —¿Baḻə yetxtil c̱hechon' de? Ḻe'e güiašc. Na' catə' gosə'əṉezene', gwse'ene': —Gueyə' yetxtil na' c̱hopə beḻ ya'a. ");
INSERT INTO zavNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nach ben Jeso'osən' mendad gosə'əbe' beṉə' zan ca' lao yixye daquə'ənə', x̱oṉɉ güeɉe'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Na' besə'ədobə to gueyoa güeɉe' na' šiyon güeɉe' gosə'əbi'e lao daquə'ənə'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Na' Jeso'osən' gwxi'e yetxtil ca' gueyə' na' beḻ ya'a ca' c̱hopə, na' bgüie' yobalə be'e yeḻə' chox̱cwlen c̱he Diozən' na' bzoxɉe' yetxtilən'. Na' bnežɉue'en disipl c̱he' ca' par gwso'e c̱he c̱he beṉə' ca'. Ḻeczə ca' bene' len beḻ ya'a ca' c̱hopə, na' gwso'e c̱he yoguə' beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Yogue'e gwsa'ogüe'en xte ca gwse'elɉene'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Na' pedas yetxtil ca' na' beḻ ya'anə' besyə'əga'aṉ bosyo'otobe'en, na' gwsa'aquən šižiṉ žomə. ");
INSERT INTO zavNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na' beṉə' ca' gwsa'o yetxtilən' na' beḻ ya'anə' zɉənaquə gueyə' mil beṉə' byo cui cuent no'olə na' cui cuent bidao'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Gwde na' Jeso'osən' bene' mendad yesyə'əyo'o disipl c̱he' ca' ḻo'o barcon' par yesyə'əbialaogüe' yesyə'əḻague'e yešḻa'alə nisda'onə' par yesyə'əžine' Betsaidan', žlac ṉe'e bega'aṉ ḻe' bzeine' beṉə' zan ca' dižə'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Na' catə' beyož bzei Jeso'osən' beṉə' ca' dižə', gwloe' to lao ya'a par ɉene' orasyon. ");
INSERT INTO zavNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Na' catə' goḻ, barcon' gan' zesyə'əyo'o disipl c̱he' ca' bazdan gwchoḻte nisda'onə', na' yetozə Jeso'osən' bega'aṉe' lao ya'anə'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Na' ble'ine' de que naquən zdebə par yesə'əžiguə'əche' barcon' c̱hedə' chec̱hɉ be'enə' clelə. Na' do šbaḻ beyetɉ Jeso'osən' ya'anə' na' gwze'e tlao nisda'onə' na' gwyeɉe' galən' zɉa'ac disipl c̱he' ca'. Na' bene' ze te yešḻa'alə galən' zɉa'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pero na' catə' besə'əle'ine' ḻe' zde' lao nisda'onə' gwsa'aquene' de que naque' to beṉə' guat, na' gwso'osye'e. ");
INSERT INTO zavNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Yogue'e besə'əle'ine' ḻe' na' besə'əžebchgüe'. Pero na' ḻe'e boḻgüižte' ḻega'aque' na' gože': —Ḻeyebei, nada'anə'. Bito žeble. ");
INSERT INTO zavNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nach beyo'e ḻo'o barcw c̱hega'aque'enə' na' ḻe'e gwlezte be'enə'. Na' ḻechguaḻe besyə'əbanene', ");
INSERT INTO zavNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","la' bito gwsa'acbe'ine' non' naquə Jeso'osən' ḻa'aṉə'əczə bguaogüe' beṉə' zan ca' len gueyə'əzə yetxtilən' c̱hedə' ṉezɉənc̱hoḻ yic̱hɉla'aždaoga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Na' catə' beyož besyə'əḻague'e nisda'onə', besə'əžine' gan' mbane Genesaretən'. Na' besə'əchoɉe' barcon' na' boso'oc̱heɉe'en cho'a nisda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Na' ze'e besyə'əchoɉe' barcon' catə'əczlə besyə'əyombia' beṉə' ca' ža' Genesaretən' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Na' gwsa'ašdoe' yoguə' yež ca' zɉəc̱hi' doxen gan' mbane Genesaretən', na' gosə'əc̱he'e yoguə' beṉə' ca' chsa'acšene zɉəx̱oateze' lao xcamga'aque'enə' par ɉso'ene' gan' gwse'enene' rson zo Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na' gatə'ətezə gwyeɉ Jeso'osən' šə lao' syoda, o šə lao' yež ca', con boso'onite'e beṉə' ca' chsa'acšene do cho'a nezən' na' gwsa'atə'əyoine' Jeso'osən' šə güe'e latɉə yesə'əgane' ḻachga lox xadoṉ c̱he'enə'. Na' yoguə' beṉə' ca' gosə'əgan ḻen besyə'əyaquene'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Baḻə beṉə' fariseo ca' na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' gwsa'aque' Jerosalenṉə' na' besə'əžine' gan' zo Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Na' catə' besə'əle'ine' de que baḻə disipl c̱he Jeso'osən' bito bosyo'one'e zan las ze'e sa'ogüe', na' gwsa'ogüe' xya contr disipl ca' lao Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ca naquə costombr c̱he yoguə' neto' beṉə' Izrael na' mazəchlə c̱he beṉə' fariseo ca' beṉə' ca' ḻeczə zɉənaquə beṉə' gwlaž c̱heto', bito chsa'ogüe' šə cuiṉə' yosyo'one'e zan las, la' can' naquə costombr de'en gosə'ənao de'e x̱axta'oto' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Catə' chɉa'aque' gan' chac ya'anə' na' catə' chesyə'əžine' ližga'aque' bito chsa'ogüe' xte catə'əch bagwsa'a gosə'əyib cuinga'aque'. Na' dech de'e zan costombr de'e chəsə'ənaogüe' ca de'en chso'one' xi'ilažə' tas plat c̱hega'aque' ca' na' yesə' de ya, na' no mes c̱hega'aque' segon can' na costombr golən'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","De'e na'anə' beṉə' fariseo ca' na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' gwse'e Jeso'osən': —¿Bixc̱hen' disipl c̱hio' ca' bito chesə'ənaogüe' costombr ca' de'en bosyo'ocua'aṉlen de'e x̱axta'ocho ca' chio'o? ¿Bixc̱hen' cui chosyo'one'e zan las antslə ze'e sa'ogüe' can' chonto'? ");
INSERT INTO zavNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nach Jeso'osən' gože' ḻega'aque': —Naquən de'e ḻi can' bzoɉ de'e profet Isaiazən' ben' be' xtižə' Diozən' cana' c̱he le'e beṉə' gox̱oayag. Bzoɉe'en nan: Beṉə' Izrael ca' chəsə'əne' de que nada' Diozən' chso'elaogüe'e pero ḻo'o yic̱hɉla'aždaoga'aque'enə' chesə'əgue'ine' nada'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bitobi zeɉen de'en chəsə'əne' chso'elaogüe'e nada', c̱hedə' la' choso'osed choso'olo'ine' beṉə' costombr de'en gwsa'alɉlažə' beṉac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Le'e chbeɉyic̱hɉle de'en non Diozən' mendad gonḻe na' con naozechle costombr golə de'en əbx̱e beṉac̱hən', ca de'en chi'ichgua yic̱hɉle cheyible no yesə' na' no tas plat c̱hele zan las ze'e gwc̱hinḻen na' chi'ichgua yic̱hɉle gonḻe de'e zan de'e zɉənac ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Na' goze'e Jeso'osən' ḻega'aque': —¿Echaquele güenchguan' chonḻe chbeɉyic̱hɉle de'en non Diozən' mendad gonḻe parzə nic̱h naole costombr c̱helen'? ");
INSERT INTO zavNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Le'e nale de que chzenagle c̱he de'en bzoɉ de'e Moisezən'. De'e Moisezən' bzoɉe' can' gož Diozən' ḻe', nan: “Ḻe'e gwnežɉo yeḻə' bala'aṉ x̱axna'ale.” Na' ḻeczə bzoɉe': “Notə'ətezle šə chžia chnitə'əle x̱axna'ale cheyaḻə' gatle.” ");
INSERT INTO zavNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero na' le'e nale de que notə'ətezə beṉə' guac ye'e x̱axne'enə': “Bitoch gaquəlena' le'e c̱hedə' yoguə' mech o bien de'en naquə goṉa' par gaquəlena' le'e naquən Corban” (zeɉe dižə' naquən c̱he Diozən'). ");
INSERT INTO zavNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Na' šə ca' ye'e x̱axna' be'enə', ḻe'e natele de que bitoch cheyaḻə' gaquəlene' x̱axne'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Na' de'en naozechle costombr golə c̱hele de'en nale naquə de'e žialaoch, bachonḻe ḻei c̱he Diozən' ca to de'e cui bi bi zaque'e. Na' de'e zan de'e zɉənaquə ca de'e quinga chonḻe. ");
INSERT INTO zavNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nach Jeso'osən' boḻgüiže' beṉə' ca' zɉənžaguən' par gosə'əbigue'e laogüe'enə', na' gože' ḻega'aque': —Yoguə'əle ḻe'e gwzenag de'en nga əṉia' le'e nic̱h šeɉni'ilen. ");
INSERT INTO zavNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Bito ṉacho de que de'en che'eɉ chaochon' chonən manch la'aždaochon'. De'e mal de'en chchoɉ yic̱hɉla'ažda'olen' ḻenṉə' chonən manch la'ažda'olen'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Le'e žia nagle de'e chene, ḻegwzenag. ");
INSERT INTO zavNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Catə' beza' Jeso'osən' gan' nitə' beṉə' ca' na' beyo'e liže'enə' disipl c̱he' ca' gosə'əṉabene' ḻe' bi zeɉen jemplən'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nach gože' ḻega'aque': —¿Eḻezə lenḻe bito cheɉni'ile de que de'en che'eɉ chaochon' bito gaquə gonən manch la'ažda'ochon'? ");
INSERT INTO zavNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","De'en che'eɉ chaochon' bito cho'on yic̱hɉla'ažda'ochon' sino que chɉc̱he'en ḻo'o ḻe'echon' na' chžin or cheden. (Can' gwne' blo'e de que yoguə' yeḻə' guaon' zɉənaquən güen par gaochon.) ");
INSERT INTO zavNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Na' gwne': —De'en chchoɉ yic̱hɉla'ažda'olen' ḻenṉə' chonən manch la'ažda'olen'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Na' ḻo'o yic̱hɉla'aždao' beṉac̱h na'anə' chchoɉ yoguə' xbab mal quinga, ca de'en nan yesə'əgo'o xtoga'aque' na' yesə'əbeɉyic̱hɉe' no'ol c̱hega'aque' o be'en c̱hega'aque' par yesyə'əzolene' beṉə' yoblə, na' ca de'en nan so'ote' beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Na' ḻeczə ḻo'o yic̱hɉla'aždao' beṉac̱h na'anə' chchoɉ xbab mal de'en nan yesə'əbanga'aque' bi de'e de c̱he beṉə', na' yesə'əzelaže'e bi de'e de c̱he beṉə', na' so'one' de'e mal, na' yesə'əx̱oayague' beṉə', na' so'onḻene' cuerp c̱hega'aque'enə' de'en naquə de'e yeḻə' zto', na' sa'acxi'i lɉuežɉga'aque', na' yoso'ožia yoso'onite'e lɉuežɉga'aque', na' sa'alaže'e na' nan so'one' de'en cui zaque'e. ");
INSERT INTO zavNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yoguə' de'e mal ca' de'en zɉənac ca' chchoɉən yic̱hɉla'aždao' beṉə', na' chac manch la'ažda'oga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Beza' Jeso'osən' latɉən' len disipl c̱he' ca' par ɉa'aque' gaḻə'əzə gan' mbane Tiro na' Sidon. Na' gwso'e to ḻo'o yo'o na' bito gone'e Jeso'osən' no əṉeze gan' nite'enə', pero bia'aczə bito goquə yesə'əcuašə' cuinga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Na' zo to no'olə Sirofenisia beṉə' chšil dižə' griego na' zo to bi'i no'ol c̱he' yo'o yaz de'e x̱io'on yic̱hɉla'ažda'obo'onə'. Na' lgüegwzə bene no'olən' rson gan' zo Jeso'osən', na' gwyeɉe' bzo xibe' lao Jeso'osən'. Na' gotə'əyoine' Jeso'osən' yebeɉe' de'e x̱io' ca' yo'o yaz yic̱hɉla'aždao' xi'iṉe' no'olən'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero na' Jeso'osən' gože'ene': —Cheyaḻə' güe'echo latɉə zgua'atec əsa'o bi'i c̱hecho ca' na' techlə əgguao xico'ochon', c̱hedə' bito naquən güen yeca'acho yeḻə' guao c̱he xi'iṉchon' na' əgwnežɉwchon gao xico'ochon'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Na' gocbe'i no'olən' bsaquə'əlebe Jeso'osən' beṉə' ca' cui zɉənaquə beṉə' Izrael ca beco', nach gože'ene': —Ḻeiczədon' X̱ana'. Pero xico'ocho ca' bian' nitə' xan mesən' guaquə əsa'ob pedas yeḻə' guaon' de'en choso'osan xi'iṉcho ca' lao yon'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nach Jeso'osən' gože'ene': —No'olə, güenchguan' bagwnao'. Guaquə yeyeɉo' ližo'. Babechoɉ de'e x̱io' de'en gwyo'o gwyaz yic̱hɉla'aždao' xi'iṉo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Na' catə' bežin no'olən' liže'enə', xi'iṉe'enə' debo' lao xcambo'onə' na' babechoɉ de'e x̱io'onə' gwyo'o gwyaz yic̱hɉla'ažda'obo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Gwde na' Jeso'osən' len disipl c̱he' ca' besa'aque' latɉən' gan' mbane Tiro na' besyə'ədie' gan' mbane Sidonṉə' na' yež ca' zɉəchi' gan' mbane Decapolis par besyə'əžine' nisdao' Galilean'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Na' gaḻə'əzə nisda'onə' besyə'əžague' beṉə' ca' zɉənc̱he'e to beṉə' cuež na' ḻeczə bito goquə əṉe' binḻo, na' gwsa'atə'əyoine' Jeso'osən' əx̱oa ne'enə' be'enə' par nic̱h yeyaquene'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jeso'osən' gwc̱he'ene' partlə gan' cui no beṉə' nitə' na' bzeb xbene'enə' ḻo'o nag be'enə' c̱hopə ḻa'a, na' btop x̱ene'enə' xbene'enə' nach gwdane' ložə' be'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nach Jeso'osən' bgüie' yobalə, na' gwcua'alaže'e gwne': —¡Efata! —zeɉe dižə' “¡Byalɉo!”. ");
INSERT INTO zavNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nach byalɉo nag be'enə', na' ḻeczə lože'enə' beyaquen, na' goc gwṉe' binḻo. ");
INSERT INTO zavNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Na' Jeso'osən' bene' mendad len beṉə' ca' cui so'e dižə' c̱he de'en babene', pero mazəchlə gwso'one' gwso'e dižə' c̱hei. ");
INSERT INTO zavNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Na' ḻechguaḻe besyə'əbane beṉə' ca' na' gwse'e lɉuežɉga'aque': —Chac chone' yoguə'əḻoḻ na' yoguə' de'en chone' chone'en binḻo. Chone' par nic̱h chesyə'əyene beṉə' cuež ca' na' par nic̱h chesyə'əṉe beṉə' mod ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Na' goquən' besə'əžag beṉə' zan gan' zo Jeso'osən', na' bito bi de c̱hega'aque' par əsa'ogüe'. Nach Jeso'osən' goxe' disipl c̱he' ca' na' gože' ḻega'aque': ");
INSERT INTO zavNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Ḻechguaḻe cheyašə'əda' beṉə' quinga. Bagoc šoṉə ža nite'e nga len chio'o, na' bitobi de de'e əsa'ogüe'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Šə yosa'aga'aca'ane' sin cui bi əgwnežɉua' əsa'ogüe', gosyə'əc̱hoḻene' tnezən', la' baḻe' za'aque' zitə'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nach disipl c̱he' ca' gwse'ene': —Gan' zocho nga naquən to latɉə ga cui nono nḻa'. ¿Gaxa əželecho de'e əsa'o yoguə' beṉə' zan quingan'? ");
INSERT INTO zavNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nach Jeso'osən' gože' ḻega'aque': —¿Baḻə yetxtil c̱hechon' de? Nach gwse'ene': —Gažən. ");
INSERT INTO zavNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nach Jeso'osən' bene' mendad yesə'əbe' beṉə' ca' lao yon'. Na' bex̱e'e yetxtil dao' ca' gažə na' be'e yeḻə' chox̱cwlen c̱he Diozən'. Nach bzoxɉe'en bnežɉue'en disipl c̱he' ca' par gwso'e c̱he yoguə' beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Na' ḻeczə de to c̱hopə beḻ ya'a dao', na' Jeso'osən' be'e yeḻə' chox̱cwlen c̱he Diozən' por ḻega'aquəb, nach bene' mendad len disipl c̱he' ca' əso'e c̱he c̱he beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Na' yogue'e gwsa'ogüe' xte ca gwse'elɉene'. Nach pedas ca' de'en besyə'əga'aṉnə' bosyo'otobə disipl ca' ḻen, na' gwsa'aquən gažə žomə. ");
INSERT INTO zavNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Na' beṉə' ca' gwsa'o yetxtilən' len beḻ ya'anə' zɉənaquə do tapa mile'. Gwde na' bosa' Jeso'osən' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nach ḻe' gwyo'e to ḻo'o barcw len disipl c̱he' ca' na' ɉa'aque' distrit gan' nzi' Dalmanota. ");
INSERT INTO zavNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Na' besə'əžin baḻə beṉə' fariseo gan' zo Jeso'osən' na' gwzolao gwsa'acyože'ene'. Na' gosə'əṉabene' ḻe' gone' to miḻagr de'e yesə'əle'ine' ḻe'e yoban' gwsa'aquene' šə cui gaquə gone'enṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jeso'osən' gwcua'alaže'e na' gože' ḻega'aque': —Ḻe'e mbanḻe ṉa'a chṉable gona' to de'e le'ile ḻe'e yoban' par nic̱h əṉezele šə Diozən' bseḻe'e nada'. Pero de'e ḻi chnia', le'e, bitobi bi gona' de'e le'ile ḻe'e yoban'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Na' beyož gwna Jeso'osən' ca' beze'e len disipl c̱he' ca' gan' nitə' beṉə' ca', na' besyə'əyo'e ḻo'o barcon' na' besyə'əḻague'e yešḻa'alə nisda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na' disipl c̱he' ca' gwsa'acbe'ine' de que gwsa'anḻaže'e əso'ox̱e'e yetxtil de'en əsa'ogüe'. Toga yetxtilən' de c̱hega'aque' ḻo'o barcon'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nach Jeso'osən' bene' mendad len ḻega'aque' gože': —Ḻegapə cuidad len xna' cuazi c̱he beṉə' fariseo ca' na' c̱he beṉə' ca' chso'on txen len Erodən'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pero disipl c̱he' ca' bito gwse'eɉni'ine' bi zeɉen de'en gože' ḻega'aque' ca', nach gwse' ḻɉuežɉga'aque': —Gwne' ca' c̱hedə' gonḻažə'əcho gua'acho yetxtilən'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jeso'osən' gocbe'ine' can' gwse'e lɉuežɉga'aque', nach gože' ḻega'aque': —¿Bixc̱hen' chonḻe xbab c̱he yetxtilən' de'en gonḻažə'əlen'? ¿Ecabiṉə' šeɉni'ile bi zeɉe de'en gwnia' le'e? ¿əna' bito chonḻe xbab c̱hei? ¿Ebia'aczə ṉe'e nc̱hoḻ yic̱hɉla'ažda'olen'? ");
INSERT INTO zavNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Ebito chle'ile de'en chona'? na' ¿əbito chenele de'en chzeɉni'ida' le'e? ¿Ebito za'alažə'əle miḻagr de'en babena'? ");
INSERT INTO zavNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Catə'ən bguaogua' gueya'a mil beṉə' byo len gueyə'əzə yetxtil dao' ¿baḻə žomə pedas yetxtilən' botoble de'en besyə'əga'aṉ? Nach gwse'ene': —Šižiṉ žomən'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Na' gozna Jeso'osən': —Catə' bguaogua' tapa mil beṉə' byo len gažə yetxtil ¿baḻə žomə pedas yetxtil ca' botoble de'en besyə'əga'aṉ? Nach gwse'ene': —Gažə žomən. ");
INSERT INTO zavNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nach gože' ḻega'aque': —¿Ebia'aczə bitoṉə' šeɉni'ile bi zeɉen de'en gwnia' le'e? ");
INSERT INTO zavNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Gwde de'e ca' besə'əžine' Betsaidan'. Na' beṉə' Betsaida ca' ɉso'e to beṉə' lc̱hoḻ lao Jeso'osən', na' gwsa'atə'əyoine' ḻe' cane'ene' par nic̱h yele'ine'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Na' Jeso'osən' bex̱e'e na' be'enə' na' gwc̱he'ene' fuerlə yežən' na' gwdeb x̱ene'enə' ɉlao be'enə' nach gwdane'ene'. Nach gwṉabene' ḻe' šə bachac le'ine' latə'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Beṉə' lc̱hoḻən' bgüie' na' gože' Jeso'osən': —Chle'ida' beṉə' can' chle'icho yag ca', pero chesə'əde'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nach Jeso'osən' gwdane' ɉlao be'enə' de'e yoblə, nach be'enə' bgüiayaṉe'e, na' beyaque ɉelaogüe'enə' na' bele'ine' binḻo. ");
INSERT INTO zavNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nach Jeso'osən' gože'ene': —Bito šeɉo' lao' yežən', na' nic no yo'o can' babena' len le'. Na' bose'ene' beyeɉ liže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Na' Jeso'osən' len disipl c̱he' ca' gwsa'aque' ɉa'aque' yež ca' de'en zɉəchi' gan' mbane Sesarea de Filipo. Na' lao zɉa'aque' tnezən' Jeso'osən' gože' disipl c̱he' ca': —¿Bi chesə'əna beṉə', non' naca' nada'? ");
INSERT INTO zavNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nach gwse'ene': —Baḻe' chesə'əne' de que naco' de'e Juan ben' bc̱hoa beṉə' nis. Na' yebaḻe' chesə'əne' de que naco' profet Ḻiaz ben' be' xtižə' Diozən' cana'. Na' yebaḻe' chesə'əne' de que naco' yeto profet beṉə' ḻeczə be' xtižə' Diozən' cana'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nach gože' ḻega'aque': —¿C̱hexa le'e? ¿bi nale non' naca' nada'? Nach Bedən' gože'ene': —Le' naco' Cristən' ben' gwleɉ Diozən' par gaquəleno' neto' bagwleɉe' par naquəto' ṉasyon c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nach Jeso'osən' bene' mendad len ḻega'aque' de que ni toe' cui əso'e dižə' de que ḻen' naque' Cristən' ben' gwleɉ Diozən' par gaquəlene' beṉə' ca' zɉənaquə ṉasyon c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nach gwzolao Jeso'osən' bsed blo'ine' disipl c̱he' ca'. Na' bzenene' ḻega'aque' de que de'e zan cheyaḻə' c̱hi' saquə' ḻe' naque' ben' bseḻə' Diozən' golɉe' beṉac̱h. Na' gwne' de que beṉə' golə beṉə' blao c̱he ṉasyon Izrael c̱heton' na' beṉə' gwnabia' c̱he bx̱oz c̱heto' ca' na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' bito se'eɉḻe'e c̱he'. Nach gože' disipl c̱he' ca' de que beṉə' blao ca' so'ote'ene', pero na' yeyoṉ ža yebane' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yoguə' de'e ca' gož Jeso'osən' disipl c̱he' ca' clar. Nach Bedən' gwleɉe' Jeso'osən' latə' dao' ca'aḻə par gwdiḻe'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero na' Jeso'osən' gwyec̱hɉe' na' bgüie' disipl c̱he' ca' na' gwdiḻe' Bedən', gože' gwxiye'enə' de'en chnabia' yic̱hɉla'aždao' Bedən': —Gwc̱hi'ižə' ca'aḻə Satanas. Nach gože' Bedən': —Chono' xbab c̱he de'en chacdo' gaquən güen na' bito chono' xbab naquən' chene'e Diozən' gaquə. ");
INSERT INTO zavNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nach Jeso'osən' goze'e disipl c̱he' ca' na' yeziquə'əchlə beṉə' ca' zɉənžaguən' gože': —Notə'ətezle šə chene'ele gonḻilažə'əle nada' na' gwzenagle c̱hia', cheyaḻə' əchoɉyic̱hɉle de'en chene'ele gon cuinḻe par nic̱h gonḻe con can' chene'e Diozən', na' bitobi gaquele c̱he de'en c̱hi' saquə'əle ḻa'aṉə'əczə šə so'ot beṉə' le'e to ḻe'e yag coroz, con gonḻilažə'əle nada' na' gwzenagle c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Na' notə'ətezə beṉə' chaquene' gone' par nic̱h cui c̱hi' saque'e o par nic̱h cui no so'ot ḻe', be'enan' cuiayi'. Na' notə'ətezə beṉə' chsanḻažə' cuine' c̱hi' saque'e o so'ot beṉə' ḻe' c̱hedə' chonḻilaže'e nada' na' c̱hedə' cheɉḻe'e dižə' güen dižə' cobə c̱hia'anə', be'enan' əbane' zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bitobi de'e güen gaquə c̱he to beṉə' ḻa'aṉə'əczə ṉabi'e doxen yežlyon' šə cuiayi'e zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","La' bitə'ətezə de'e gatə' c̱he' bito gaquəlenən ḻe' par nic̱h cui cuiayi'e zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Notə'ətezle šə cheto'ile c̱hia' na' c̱he xtiža'anə' lao beṉə' güen de'e mal ca' beṉə' ca' cui chso'elao' Diozən', ḻeczə ca' nada' yeto'ida' c̱hele, nada' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. Yeto'ida' c̱hele catə'ən yida' de'e yoblə nsa'a yeḻə' chey che'eni' c̱he X̱a' Diozən' na' nc̱hi'a angl c̱hia' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Nach goze'e Jeso'osən' ḻega'aque': —De'e ḻi əchnia' le'e de que baḻle cabiṉə' gatle catə'ən le'ile can' gon Diozən' əgwlo'e yeḻə' guac xen c̱he'enə' par ṉabi'e beṉac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Gwde x̱op ža gwna Jeso'osən' de'e ca', gwc̱he'e Bedən' len Jacobən' len Juanṉə', con ḻega'acze' ɉa'aque' to lao ya'a sibə. Na' lao nite'e lao ya'anə' besə'əle'ine' beža' can' goquə Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Na' xalane'enə' goctitən na' beyaquən šyiš xilə' juisy. Beyaquən šyiš xilə' juisyəch cle ca c̱he notə'ətezəchlə beṉə' chac c̱hib lachə' yežlyo nga. ");
INSERT INTO zavNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Na' besə'əle'ine' Ḻiazən' ben' be' xtižə' Diozən' cana' na' ḻeczə besə'əle'ine' de'e Moisezən' chso'elene' Jeso'osən' dižə'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nach gož Bedən' Jeso'osən': —X̱anto', güenchgua zocho nga ṉa'a. ¿Egüe'endo' gonto' šoṉə ranš?, ton par le', na' ton par Moisezən' na' yeton par Ḻiazən'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Gože'ene' ca' c̱hedə' bito bene' xbab c̱he de'en gože' tant besə'əžebe'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nach betɉ to beɉw bcuašə'ən ḻega'aque', na' ḻo'o beɉon' gwse'enene' gwna Diozən': —Benga Xi'iṉa' ben' chacchgüeida' c̱hei. C̱he ḻe'enə' ḻe'e gwzenag. ");
INSERT INTO zavNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Na' choso'ogüiate' ca' catə'əczla con cuich no no besə'əle'ine' sino yetozə Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Na' gwde na' lao chesyə'əyetɉe' ya'anə', Jeso'osən' bene' mendad len ḻega'aque' cui no no əso'elene' dižə' c̱he de'en babesə'əle'ine'enə' xte catə'əch so'ot beṉə' ca' Jeso'osən' ben' bseḻə' Diozən' golɉe' beṉac̱h na' yebane' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","De'e na'anə' bito bi dižə' gwso'elene' yeziquə'əchlə beṉə'. Pero bito gwse'eɉni'ine' bi zeɉen xtižə' Jeso'osən' de'en gwne' yebane' ladɉo beṉə' guat ca' na' gosə'əṉabe' lɉuežɉga'aque' bi zeɉenṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nach gwse'e Jeso'osən': —Beṉə' ca' choso'osed choso'olo'ine' ḻein' choso'osedene' neto' de que zgua'atec profet Ḻiazən' ben' gwzo cana' cheyaḻə' yide' lao yežlyo nga de'e yoblə antslə ze'e yidə ben' əseḻə' Diozən' par gaquəlene' ṉasyon c̱hechon'. ¿Bixc̱hen' chesə'əne' ca' ža? ");
INSERT INTO zavNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nach Jeso'osən' gože' ḻega'aque': —De'e ḻiczə can' chesə'əne' de que profet Ḻiazən' ben' gwzo cana' ḻeteque' yide' de'e yoblə par yeyone' yoguə'əḻoḻ de'en cheyaḻə' yeyac. Na' ḻeczə ca' nyoɉ Xtižə' Diozən' nan de que ben' əseḻə' Diozən' galɉe' beṉac̱h na' de'e zan de'e c̱hi' saque'e. Beṉac̱hən' so'onene' ḻe' ca'aczə to beṉə' cui bi bi zaque'e. ");
INSERT INTO zavNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero na' əchnia' le'e de que babidə ben' bedəyen can' ben Ḻiazən' na' beṉə' Izrael gwlaž c̱hecho ca' gwso'onene' ḻe' con ca gwse'enene' can' nyoɉ Xtižə' Diozən' gaquə. ");
INSERT INTO zavNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Na' catə' besyə'əžine' gan' besyə'əga'aṉ disipl ca' yeḻa', besə'əle'ine' beṉə' zan, zɉənyec̱hɉe' disipl ca'. Na' ḻeczə nitə' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' chsa'acyože' disipl c̱he Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nach catə' besə'əle'i yoguə' beṉə' ca' nžaguən' Jeso'osən' besyə'əbanchgüeine'. Nach gwsa'acdoe' ɉəsə'əšague'ene' na' gwso'oḻgüiže'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nach Jeso'osən' gože' disipl c̱he' ca': —¿Bi dižə'ən cho'elenḻe beṉə' ca' choso'osed choso'olo'i ḻein'? ");
INSERT INTO zavNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nach entr beṉə' ca' zɉənžaguən' toe' gože'ene': —X̱ana', nc̱hi'a xi'iṉa' nga. Yo'o yaz de'e x̱io'on yic̱hɉla'ažda'obo'onə' na' chonən par nic̱h nacbo' mod. ");
INSERT INTO zavNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Na' gatə'ətezə zobo' catə' chṉizən ḻebo' chc̱hix̱ən ḻebo' lao yon', na' chla' bžin' cho'abo'onə', na' chaoyeɉə leybo'on na' chatbo' šlat. Bagotə'əyoida' disipl c̱hio' ca' par nic̱h yesyə'əbeɉe' de'e x̱i'onə' yo'o yaz yic̱hɉla'ažda'obo'onə', pero bito gwsa'aque' yesyə'əbeɉe'en. ");
INSERT INTO zavNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nach gož Jeso'osən' beṉə' ca' ža'anə': —Le'e nitə'əle nga, ¿bixc̱hexan' cui cheɉḻe'ele c̱hia'? Bachac sša zoa' napa' yeḻə' chxenḻažə' len le'e. ¿Batxan' šeɉḻe'ele c̱hia'? Nach gože' x̱a bida'onə': —Doa' xi'iṉo' nga. ");
INSERT INTO zavNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Na' catə' zɉso'ebo' lao Jeso'osən', ble'i de'e x̱io'onə' Jeso'osən' na' bṉizən bida'onə', na' benən par nic̱h ḻechguaḻe gwyazbo' šonṉə', na' bc̱hix̱ btoḻən ḻebo' lao yon', xte bla' bžin' cho'abo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nach Jeso'osən' gože' x̱abo'onə': —¿Šna bagoc chacbo' ca'? Nach x̱abo'onə' gože' Jeso'osən': —Dezd bida'otebo'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Zan las ben de'e x̱i'onə' par ɉec̱hazbo' do lao yi' na' bx̱opən ḻebo' do ḻo'o nis par gatbo'. Šə bi de'e guac gono' par gaquəleno' neto', beyašə'əlažə'əšguei neto'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jeso'osən' gože'ene': —Šə cheɉḻi'o c̱hia', goyona'abo', la' chac chona' bitə'ətezə, con šə cheɉḻi'o c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nach x̱abo'onə' ḻe'e gožte' Jeso'osən': —Cheɉḻi'a c̱hio'. Goclenšga nada' par nic̱h šeɉḻe'echa' c̱hio'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Na' catə' Jeso'osən' ble'ine' bachesə'əžag beṉə' zan, nach gwdiḻe' de'e x̱io'onə', gože'en: —De'e x̱io', chono' par nic̱h bi'i nga nacbo' mod na' ncuežbo'. Chona' mendad yechoɉo' yic̱hɉla'aždao' bi'i nga na' cuatəch yeyo'o yeyazo' de'e yoblə. ");
INSERT INTO zavNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nach de'e x̱io'on bgosya'an ḻebo' na' benən par nic̱h ḻechguaḻe fuert gwyazbo' šonṉə' de'e yoblə nach bechoɉən ḻebo' na' bocua'aṉən ḻebo' ca'aczə to bi'i guat. Na' beṉə' zan gosə'əne' de que gotbo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero na' Jeso'osən' bex̱e'e na'abo'onə' par bezoža'abo'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nach Jeso'osən' gwyo'e to ḻo'o yo'o na' disipl c̱he' ca' gosə'əbigue'e gan' zo toze', na' gwse'ene': —¿Bixc̱hexaczxan' cui goquə yebeɉto' de'e x̱i'onə' ža? ");
INSERT INTO zavNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nach gože' ḻega'aque': —Par nic̱h gaquə yebeɉle de'e x̱io' ca' de'en zɉənaquə ca de'en bebeɉa' yic̱hɉla'aždao' bi'i nga, cheyaḻə' co'o gwc̱heɉle cui ye'eɉ gaole nic̱h gontezə gonḻe orasyon. ");
INSERT INTO zavNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Na' catə' besa'aque' latɉən' besyə'ədie' gan' mbane Galilean', pero Jeso'osən' bito gone'ene' yesə'əṉeze beṉə' gan' zoe'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Con disipl c̱he' ca'azə əbsed əblo'ine'. Na' gože' ḻega'aque' de que ḻe' naque' ben' bseḻə' Diozən' golɉe' beṉac̱h. Na' gaque' lao na' beṉə' na' so'ote'ene', nach yeyoṉ ža yebane' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero na' disipl ca' bito gwse'eɉni'ine' dižə' de'en be' Jeso'osən' na' besə'əžebe' par yesə'əṉabene' ḻe' bi zeɉen de'e gože' ḻega'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jeso'osən' len disipl c̱he' ca' besyə'əžine' liž Jeso'osən' de'en zo Capernaunṉə', na' lao bazɉənite'e liže'enə' gože' ḻega'aque': —¿Bi porən' chacyožle tnezən'? ");
INSERT INTO zavNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nach disipl c̱he' ca' bito bosyo'oži'e xtiže'enə', c̱hedə' gwsa'aquene' zto' de'en gwsa'acyože' entr ḻega'aque' noe' naquə blaoch. ");
INSERT INTO zavNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Gocbe'i Jeso'osən' xbab c̱hega'aque'enə' na' gwchi'e na' goxe' disipl c̱he' ca' par gosə'əbigue'e laogüe'enə', na' gože' ḻega'aque': —Notə'ətezle šə chene'ele gacle beṉə' blaoch, cheyaḻə' gonḻe xbab c̱he cuinḻe de que bitobi zaquə'əle, na' cheyaḻə' gaquəlen lɉuežɉle ca to mos. ");
INSERT INTO zavNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nach goxe' to bidao' na' bzeche'ebo' laoga'aque'enə' nach gwḻene'ebo', gože' ḻega'aque': ");
INSERT INTO zavNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Šə chonḻe güen len bidao' nga o notə'ətezəchlə bidao' laogüe de'en chaquele c̱hia', chonczle güen len nada'anə'. Na' catə' chonḻe güen len nada', ḻeczə chonczle güen len Diozən' ben' bseḻə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nach Juanṉə' gože'ene': —Maestr, babežagto' to beṉə' cho'e la'onə' par chebeɉe' de'e x̱io' de'en yo'o yaz yic̱hɉla'aždao' beṉə' na' bžonto' gone' ca' c̱hedə' bito chone' txen len chio'o. ");
INSERT INTO zavNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nach Jeso'osən' gože'ene': —Bito gwžonḻe gone' ca', c̱hedə' notə'ətezə beṉə' cho'e la'anə' par gone' to miḻagr, bito gaquə bi əṉe' contr nada'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Šə to beṉə' cui chone' contr chio'o, txenczən' chone' len chio'o. ");
INSERT INTO zavNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Na' notə'ətezə beṉə' gaquəlen le'e laogüe de'en naole nada' ḻa'aṉə' tbaszə nis goṉe' ye'eɉle, be'enə' gon ca' de'e ḻiczə gona' ca soe' mbalaz catə' yežine' yoban'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Probchguazə ben' gon par nic̱h əxopə to beṉə' chonḻilažə' nada' gone' de'e mal, ḻa'aṉə'əczə ben' əxopən' cuitec bi zaque'e par len beṉac̱hən'. Nca'alə xṉeze žalə' yoso'oc̱heɉe' yen ben' chon ca' to yeɉ yišə' na' žɉəsə'əzaḻe'ene' ḻo'o nisda'onə' par gate' cle ca soe' gone' ca əxopəch beṉə' so'one' de'e malən'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Šə de'en chonḻe len na'alenə' chonən par nic̱h əxople gonḻe de'e malən', güenchlə žalə' əc̱hog na'alen' cle ca əxople gonḻe de'e malən'. Nca'alə xṉeze nacle beṉə' na' chog yežinḻe lao Diozən' na' əbanḻe zeɉḻicaṉe cle ca cuiayi'ilenḻen txen lao yi' gabiḻən' de'en cui chyol. ");
INSERT INTO zavNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Zeɉḻicaṉe yesə'əžaglaochgua beṉə' ca' yesyə'əžin lao yi' gabiḻən' c̱hedə' cuat yol yi'inə'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na' šə de'en chonḻe len ṉi'alenə' chonən par nic̱h əxople gonḻe de'e malən', güenchlə žalə' əc̱hog ṉi'alen' cle ca əxople gonḻe de'e malən'. Nca'alə xṉeze yežinḻe lao Diozən' nacle beṉə' coj na' əbanḻe zeɉḻicaṉe cle ca cuiayi'ilenḻen txen lao yi' gabiḻən' de'en cui chyol. ");
INSERT INTO zavNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Zeɉḻicaṉen' yesə'əžaglaochgua beṉə' ca' yesyə'əžin lao yi' gabiḻən' c̱hedə' cuat yol yi'inə'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na' šə de'en chle'ile len ɉelaolen' chonən par nic̱h əxople gonḻe de'e malən' yeɉni'alə žalə' cueɉlen, c̱hedə' nca'alə xṉeze nacle beṉə' lc̱hoḻ yežinḻe yoban' gan' zo Diozən' chnabi'e na' əbanḻe zeɉḻicaṉe, cle ca cuiayi'ilenḻen txen lao yi' gabiḻən'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Zeɉḻicaṉen' yesə'əžaglaochgua beṉə' ca' yesyə'əžin lao yi' gabiḻən' c̱hedə' cuat yol yi'inə'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Bx̱oz ca' chso'ose' zedə' lao xpelə' bia ca' choso'ozeye' chso'elaogüe'e Diozən' par nic̱h belə'ən chaquən xi'ilažə'. Na' de'en chsi' Diozən' xṉeze chyi' chzaquə'əcho, chone' ca' par nic̱h chaquəch yic̱hɉla'aždao' chio'o chonḻilažə'əchone' xi'ilažə'. ");
INSERT INTO zavNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ṉezecho de que zedə' naquən güen na' chonən par nic̱h cui chbiayi' yid belə'ən, pero šə zedə'ən bitoch bi zxi' naquən, bitoch bi zaquə'ən na' bito gaquə goncho ca yeyaquən zxi' de'e yoblə. Na' par nic̱h gacle ca zedə' de'en naquə zxi' cheyaḻə' gacle beṉə' la'aždao' xi'ilažə', na' so cuezle binḻo len lɉuežɉle. ");
INSERT INTO zavNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jeso'osən' len disipl c̱he' ca' besa'aque' Capernaunṉə' na' ɉa'aque' yež ca' zɉəchi' gan' mbane Jodean' na' yež ca' zɉəchi' yešḻa'alə yao Jordanṉə'. Na' besə'əžag beṉə' zan gan' zoe'enə', na' de'e yoblə bzeɉni'ine' ḻega'aque' con can' chzeɉni'iczene' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nach baḻə beṉə' fariseo ca' gosə'əbigue'e gan' zo Jeso'osən' par nic̱h yesə'əbeɉene' dižə' de'e yesə'əc̱hine' contr ḻe', na' gosə'əṉabene' ḻe' šə de lsens par beṉə' nšagna' yele'e xo'ole'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jeso'osən' gože' ḻega'aque': —¿Naquən' nyoɉ ḻei de'en bzoɉ de'e Moisezən'? ¿Bin' bene' mendad gonḻe? ");
INSERT INTO zavNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nach beṉə' fariseo ca' gwse'e Jeso'osən': —De'e Moisezən' be'e latɉə əgwcos ben' nšagna'anə' to act ga güe'en dižə' de que besyə'əle'enə', nach cueɉyic̱hɉe' no'ol c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jeso'osən' gože' ḻega'aque': —De'e Moisezən' be'e latɉə yela'a no'ol c̱hele c̱hedə' nacle beṉə' yic̱hɉla'aždao' žod. ");
INSERT INTO zavNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bablabczle can' nyoɉ Xtižə' Diozən' nan de que catə'ən gwxe yežlyon' Diozən' bene' beṉac̱hən' beṉə' byo na' no'olə. ");
INSERT INTO zavNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Na' ḻeczə nan: “Beṉə' byonə' ḻe'e x̱axne'e par əgwšagne'e si'e to no'olə. ");
INSERT INTO zavNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nach beṉə' ca' yoso'ošagna'anə' əsa'aque' tozə.” De'e na'anə' bitoch əsa'aque' c̱hopə beṉə', sino que əsa'aque' tozə beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","De'e na'anə' notono cheyaḻə' yoḻa'a ḻega'aque' la' Dioz nan' banone' ḻega'aque' tozə beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Na' catə' Jeso'osən' len disipl c̱he' ca' besyə'əžine' yo'o gan' gosə'ənitə' disipl c̱he' ca' gosə'əṉabene' ḻe' bi zeɉen de'en gože' beṉə' fariseo ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Na' Jeso'osən' gože' ḻega'aque': —Notə'ətezə beṉə' chela'a no'ol c̱he'enə' par yeque'e no'olə yoblə tozəczə ca malən' chone' len de'en chon beṉə' chgo'o xtoi. ");
INSERT INTO zavNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na' notə'ətezə no'olə yele'e be'en c̱he'enə' par yeque'e beṉə' yoblə, ḻeczə tozəczə ca malən' chon no'olən' len de'en chon beṉə' chgo'o xtoi. ");
INSERT INTO zavNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Na' ɉa'ac beṉə' əɉso'e bidao' lao Jeso'osən' par nic̱h əx̱oa ne'enə' yic̱hɉga'acbo' na' gone' orasyon c̱hega'acbo'. Pero disipl c̱he' ca' gosə'ədiḻe' beṉə' ca' zɉsoa' bidao' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Catə' ble'i Jeso'osən' can' chso'on disipl c̱he' ca', bže'e nach gože' ḻega'aque': —Ḻe'e güe' latɉə la'ac bidao' ca' laogua' nga, na' cui əgwžonḻe. Na' əchnia' le'e, beṉə' ca' choso'ozex̱ɉw yic̱hɉga'aque' lao Diozən' ca bidao' ca' choso'ozex̱ɉw yic̱hɉga'acbo' lao x̱axna'aga'acbo' ḻega'acze'enə' chso'e latɉə chnabia' Diozən' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Bidao' ca' bito chso'on cuinga'acbo' xen, na' de'e ḻi chnia' le'e, notə'ətezle šə cui yeyacle ca bidao' par güe'ele latɉə ṉabia' Diozən' le'e, bito gaquə yežinḻe yoban' gan' zo Diozən' chnabi'e. ");
INSERT INTO zavNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nach Jeso'osən' gwḻene' bidao' ca' na' gwx̱oa ne'enə' yic̱hɉga'acbo'onə', na' bene' orasyon par ḻega'acbo'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Na' ze'e yesa'aque' latɉən' to beṉə' güego' gwsa'adoe' bžine' gan' zo Jeso'osən' na' bzo xibe'en lao Jeso'osən'. Na' gože'ene': —Maestr, le' naco' beṉə' güen, gwna nada' bi de'en cheyaḻə' gona' par gatə' yeḻə' mban zeɉḻicaṉe c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Na' par nic̱h gonch be'enə' xbab c̱he de'en gwne', Jeso'osən' gože'ene': —¿Bixc̱hen' nao' de que beṉə' güen nada'? Dioz nan' naque' ḻe'ezelaogüe beṉə' güen. ");
INSERT INTO zavNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ṉezdo' bin' na ḻein': “Cui co'o xtole, na' cui cueɉyic̱hɉle be'en c̱hele o no'ol c̱hele par solenḻe beṉə' yoblə; cui gotle beṉə'; cui cuanḻe; bito gacle testigw faḻs contr sa'alɉuežɉle; bito x̱oayagle sa'alɉuežɉ beṉac̱hle; ḻegwnežɉo yeḻə' bala'aṉ x̱axna'ale.” ");
INSERT INTO zavNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nach beṉə' güegon' gože' Jeso'osən': —Maestr, yoguə'əḻoḻ de'e ca' chzenaga' c̱hei dezd xcuidə'ətia'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jeso'osən' bgüie' be'enə' na' goquene' c̱he' na' gože'ene': —Tozə de'en ṉe'e chac faḻt gono'. Ɉəyeyetə' yoguə'əḻoḻ de'en de c̱hio', na' mech de'en le'ido' c̱he de'e ca' bnežɉon beṉə' yašə'. Nach da denao nada' ḻa'aṉə'əczə šə gonclən byen gato' to ḻe'e yag coroz. Na' catə' yežino' yoban' gan' zo Diozən', so' mbalaz. ");
INSERT INTO zavNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pero na' beṉə' güegon' beyož gož Jeso'osən' ḻe' ca', ḻechguaḻe trist gwzoe' c̱hedə' la' to beṉə' gwni'achguan' naque', na' beza'achoe' trist. ");
INSERT INTO zavNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nach Jeso'osən' bgüie' beṉə' güegon', na' gože' disipl c̱he' ca': —Zdebəchgua naquən par to beṉə' gwni'a güe'e latɉə ṉabia' Diozən' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Na' besyə'əbanchgüei disipl c̱he' ca' can' gože' ḻega'aque' c̱he beṉə' gwni'anə', nach de'e yoblə goze'e Jeso'osən' ḻega'aque': —Xi'iṉdaogua'a, de'e ḻi šə to beṉə' zoe' lez gaquəlen yeḻə' gwni'a c̱he'enə' ḻe' zdebəchgua naquən par žɉəyezoe' yoban' gan' zo Diozən' chnabi'e. ");
INSERT INTO zavNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Zdebəchlə naquən c̱he to beṉə' gwni'anə' güe'e latɉə ṉabia' Diozən' ḻe' cle ca to camey teb to ḻo'o nag yešə'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nach disipl c̱he' ca' catə' gwse'enene' xtiže'enə' besyə'əbanchgüeine' na' gwse' lɉuežɉga'aque': —Notono gaquə yechoɉ xni'a de'e malən' šə ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jeso'osən' bosgüie' ḻega'aque' na' goze'e: —Beṉac̱hən' bito gaquə so'one' ca yesyə'əchoɉe' xni'a de'e malən', pero Diozən' guaquə yebeɉe' beṉə' xni'a de'e malən'. Diozən' chac chone' bitə'ətezə. ");
INSERT INTO zavNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nach Bedən' gože' Jeso'osən': —X̱anto', neto' bagwleɉyic̱hɉto' famiḻy c̱heto' ca' na' len yoguə'əḻoḻ de'en deito' par chonḻilažə'əto' le' na' chzenagto' c̱hio'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nach gož Jeso'osən' ḻega'aque': —De'e ḻi əchnia', šə nole bagwleɉyic̱hɉle' ližle, beṉə' bišə'əle, beṉə' zanḻe, x̱axna'ale, xo'olle, xi'iṉle, o yežlyo c̱hele c̱hedə' chzenagle c̱hia' na' c̱hedə' cheɉḻe'ele c̱he dižə' güen dižə' cobə c̱hia'anə', ");
INSERT INTO zavNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Diozən' goṉe' le'e de'e zaquə'əche lao yežlyo nga clezə ca beṉə' ca' na' de'e ca' gwleɉyic̱hɉlen'. Na' ḻeczə gon Diozən' par nic̱h əbanḻe zeɉḻicaṉe. Goṉe' le'e de'e ca' ḻa'aṉə'əczə lao yežlyo nga de de'e zan de'e c̱hi' saquə'əle. ");
INSERT INTO zavNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Beṉə' zan zɉənaquə beṉə' blao ṉa'a pero gwžin ža catə' cuich əsa'aque' beṉə' blao. Na' beṉə' zan beṉə' cui zɉənaquə beṉə' blao ṉa'a, pero gwžin ža catə' əsa'aque' beṉə' blao. ");
INSERT INTO zavNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nach Jeso'osən' na' zan disipl c̱he' ca' ɉa'aque' Jerosalenṉə'. Na' lao zɉəngüe'e nezən' Jeso'osən' gwžialaogüe' laoga'aque'enə', na' besyə'əbanchgüei disipl c̱he' ca' de'en šeɉe' Jerosalenṉə' gan' nitə' beṉə' ca' chse'ene so'ot ḻe'. Na' do chesə'əžebze' ɉəsə'ənaogüe'ene'. Nach partlə gwleɉ Jeso'osən' disipl c̱he' ca' šižiṉ na' gwzolaogüe' be'elene' ḻega'aque' dižə' c̱he de'e ca' gaquə c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Na' gože' ḻega'aque': —Diozən' bseḻe'e nada' golɉa' beṉac̱h, na' ṉa'a šeɉcho Jerosalenṉə' gan' gaca' lao na' beṉə' gwnabia' c̱he bx̱oz ca' na' lao na' beṉə' ca' choso'osed choso'olo'i ḻein'. Yesə'əc̱hoglaogüe'en c̱hia' de que cheyaḻə' gata', na' ḻeczə so'one' nada' lao na' beṉə' ca' cui zɉənaquə beṉə' Izrael. ");
INSERT INTO zavNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Na' so'one' nada' borl na' soe' nada' golp na' yoso'oža' x̱ene'e cho'alaogua'anə'. Nach so'ote' nada', pero yeyoṉ ža yebana' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nach xi'iṉ Sebedeon' Jacobən' len Juanṉə' gosə'əbigue'e lao Jeso'osən'. Na' gwse'ene': —X̱anto', zedəṉabeto' ḻe' to goclen. ");
INSERT INTO zavNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nach Jeso'osən' gože' ḻega'aque': —¿Bi goclenṉə' chene'ele gona'? ");
INSERT INTO zavNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nach gwse'ene': —Chene'eto' gono' par nic̱h cue'eto' cuito'onə' šḻa'a güeɉə catə'ən əžin ža ṉabi'o ṉasyon c̱hechonə'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nach Jeso'osən' gože' ḻega'aque': —Bito chacbe'ile bi de'en chṉabele nada'. ¿Eguaquə saquə'əzi'ile can' saquə'əzi'anə'? ¿Egwzoile gaquə c̱hele can' gaquə c̱hia'anə'? ");
INSERT INTO zavNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nach bosyo'oži'e xtiže'enə' gwse'ene': —Gwzoito'. Jeso'osən' gože' ḻega'aque': —De'e ḻiczə c̱hi' saquə'əle can' c̱hi' saca'anə', na' de'e ḻiczə gaquə c̱hele can' gaquə c̱hia'anə'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero bito naquən par əṉia' nada' non' cue' cuitan' catə'ən əžin ža ṉabi'anə'. X̱a' Diozən' bagwleɉe' beṉə' yesə'əbe' cuita'anə'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nach disipl ca' yeši, catə' gwse'enene' de'en gwse' Jacobən' na' Juanṉə' ḻe', besə'əže'e ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pero Jeso'osən' goxe' yogue'e par nic̱h gosə'əbigue'e laogüe'enə', na' gože' ḻega'aque': —Ṉezele nitə' beṉə' gwnabia' na' beṉə' blao c̱he to to ṉasyon, na' ḻa fuers chesə'ənabi'e beṉə' ca' nitə' xni'aga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero caguə can' cheyaḻə' gonḻe. Šə no le'e chene'ele gacle beṉə' blao, cheyaḻə' əgwzex̱ɉw yic̱hɉle na' gaquəlenḻe lɉuežɉle. ");
INSERT INTO zavNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na' šə no le'e chene'ele gaquəchle blaoch ca beṉə' lɉuežɉle ca', caguə can' cheyaḻə' gonḻe sino que cheyaḻə' gon cuiṉle ca xmos beṉə' ca' yeḻa'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Diozən' bseḻe'e nada' golɉa' beṉac̱h, na' caguə bida' par nic̱h beṉac̱hən' əsa'aclene' nada', sino que bida' par gaquəlena' beṉac̱hən', na' par əgwnežɉo cuina' c̱hixɉua' xtoḻə' yoguə'əḻoḻ beṉac̱hən' catə'ən so'ote' nada'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jeso'osən' len disipl c̱he' ca' na' len beṉə' zan ca' ɉəsə'ənao Jeso'osən' besə'əžine' syoda Jericon'. Na' catə' besa'aque' syodan' to beṉə' lc̱hoḻ le Bartimeo, xi'iṉ to beṉə' le' Timeo, chi'e cho'a nezən' chṉabe' carida. ");
INSERT INTO zavNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Na' catə' bene Bartimeon' de que Jeso'osən' be'enə' naquə beṉə' Nasaretən' bazon əžine' gan' chi'enə', nach gwzolao gwṉe' zižɉo gwne': —Jeso'os, len' naco' xi'iṉ dia c̱he de'e Rei Dabin'. Beyašə'əlažə'əšguei nada'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Beṉə' zan gosə'ədiḻe' beṉə' lc̱hoḻən' par nic̱h zoe' žizə, pero nachlə gwṉe' zižɉochlə gwne': —Jeso'os, len' naco' xi'iṉ dia c̱he de'e Rei Dabin'. Beyašə'əlažə'əšguei nada'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nach Jeso'osən' gwleze' na' gože' beṉə' ca' zɉəsə'ənao ḻe': —Ḻe'e gax be'enə'. Nach gwsa'axe' beṉə' lc̱hoḻən' par bigue'e lao Jeso'osən', na' gwse'ene': —Bebei, gwzecha c̱hedə' chaxe' le'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nach beṉə' lc̱hoḻən' bzaḻə' xadoṉ c̱he'enə' na' bxite'e bgüigue'e lao Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jeso'osən' gože'ene': —¿Bin' che'endo' gona' len le'? Nach beṉə' lc̱hoḻən' gože' Jeso'osən': —X̱ana', benšga par nic̱h yele'ida'. ");
INSERT INTO zavNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jeso'osən' gože'ene': —Guaquə yeyeɉo'. De'en chonḻilažo'o nada' bac̱h goc can' che'endo'onə'. Na' ḻe'e bele'itei be'enə' na' gwnaogüe' Jeso'osən' lao zɉa'aque' Jerosalenṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jeso'osən' len disipl c̱he' ca' na' len beṉə' ca' zɉəsə'ənao ḻega'aque' besə'əžine' gaḻə'əzə Jerosalenṉə'. Na' gaḻə'əzə Jerosalenṉə' zɉəchi' c̱hopə yež, ton Betfage na' yeton Betania. Zɉəchi'in frent to ya'a de'en nzi' Ya'a Olibos. Nach Jeso'osən' gwleɉe' c̱hopə disipl c̱he' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Na' gože' ḻega'aque': —Ḻe'e žɉa'ac yež dao' de'en chi' delant, na' catə' šo'ole lao' yežən', le'ile to borr dao' bia cui noṉə' cuia da'ab yag. Na' əsežleb na' əc̱he'eleb ngalə. ");
INSERT INTO zavNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Na' šə no ṉabe le'e bixc̱hen' chsežleb, na' ye'elene' de que nada' X̱anḻe chyažɉda'ab, na' de que lgüegwzə žɉəyesana'ab. ");
INSERT INTO zavNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nach beṉə' ca' bseḻə' Jeso'osən' gwsa'aque' zɉa'aque' na' lao zɉa'aque'enə' besə'əle'ine'eb da'ab yag cuit puert c̱he to yo'o de'en zo cho'a nezən'. Nach boso'oseže'eb. ");
INSERT INTO zavNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Na' nitə' baḻə beṉə' na' gwse'e disipl ca': —¿Bin' chonḻe? ¿Bixc̱hen' chsežle borr da'onə'? ");
INSERT INTO zavNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nach disipl ca' gwse'e beṉə' ca' can' gož Jeso'osən' ḻega'aque' yesə'əne', nach gwso'e latɉə boso'oseže'eb. ");
INSERT INTO zavNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nach gosə'əc̱he'eb lao Jeso'osən', na' boso'ox̱oa xadoṉ c̱hega'aquen' cožə'əbən', nach gwžia Jeso'osən' ḻeb. ");
INSERT INTO zavNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Na' lao nez gan' zde'enə' beṉə' zan gwso'elaogüe'ene' na' boso'ošilɉue' xaga'aque'enə' gan' zde' žie' borrən' na' yebaḻe' gosə'əc̱hogue' xozə' yag de'en ze tcho'a nezən', na' bosə'ənite'en lao nezən'. ");
INSERT INTO zavNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Na' beṉə' zan gosə'əbialao lao Jeso'osən' na' ḻeczə beṉə' zan ɉəsə'ənao ḻe'. Nach yogue'e gosə'əgüe'e be' lban c̱he' gosə'əne': —Sošgo' mbalaz le' za'o nga, babseḻə' X̱ancho Diozən' le'. Goclenšga neto'. ");
INSERT INTO zavNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Catec mba gaquə c̱hecho de'en baza' ben' ṉabia' chio'o can' gwnabia' de'e Rei Dabin' cana'. Lenczə le'e nitə'əle gan' zo Diozən' ḻedoye'ela'oche'. ");
INSERT INTO zavNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ca' goquə bežin Jeso'osən' Jerosalenṉə', na' ḻeczə catə'ən gwyo'e yo'odao' əblaonə'. Na' beyož bgüie' yoguə' de'en chac ḻo'o yo'odao' əblaonə' besa'aque' len disipl c̱he' ca' šižiṉ na' ɉa'aque' Betanian', c̱hedə' bagoḻ. ");
INSERT INTO zavNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ža beteyo catə' besa'aque' Betanian' par ɉəsya'aque' Jerosalenṉə' de'e yoblə, gwdon Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Na' zitə'ələ ble'ine' to yag yix̱güio žia xlague'e. Na' gwyeɉe' ɉəgüie' šə žian yix̱güion', pero bitobi bželene', con zlega xlague'e žia, c̱hedə' ca orən' bito naquə tyemp c̱hei. ");
INSERT INTO zavNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nach Jeso'osən' gože' yag yix̱güion': —Caṉeque cuich bi frot cuio'. Na' gwse'encze disipl c̱he' ca' can' gwne'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Gwde na' besə'əžine' Jerosalenṉə' na' catə' gwyo'o Jeso'osən' chyo'o yo'odao' əblaonə' gwzolaogüe' bebeɉe' yoguə'əḻoḻ beṉə' ca' chso'on ya'a chyo'onə'. Nach gwlo'oṉi'ane'e mes c̱he beṉə' ca' choso'oša' mech, na' ḻeczə ca' bene' len yag siy c̱he beṉə' ca' əgwso'otə' ngolbexə. ");
INSERT INTO zavNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Na' Jeso'osən' bito be'e latɉə par yesə'əde notə'ətezə beṉə' chyo'o yo'odao' əblaonə' šə zɉənoe' yoa'. ");
INSERT INTO zavNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nach bzeɉni'ine' ḻega'aque', gože': —Nyoɉczə Xtižə' Diozən' gan' nan: “Che'enda' yesə'əna beṉə' de que liža'an naquən to latɉə gan' so'on beṉə' orasyon beṉə' ža' yoguə' ṉasyon ca'.” Pero na' le'e babenḻen ca to latɉə gan' ža' beṉə' bguan. ");
INSERT INTO zavNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na' beṉə' gwnabia' c̱he bx̱oz ca' na' ḻeczə beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' gwse'enene' can' be' Jeso'osən' dižə'ənə' na' besyə'əyilɉlaže'e naclə so'one' par əso'ote'ene'. Besə'əžebe' cuich yoso'ozenag beṉə' c̱hega'aque' c̱hedə' yoguə'əte beṉə' boso'ozenague' xtiže'enə' na' besyə'əbanene' ca güenṉə' bzeɉni'ine' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Na' catə' bazon gaḻ Jeso'osən' len disipl c̱he' ca' besa'aque' syodan' na' ɉəsyə'əga'aṉe' Betanian'. ");
INSERT INTO zavNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Zil beteyo besa'aque' Betanian' par ɉəya'aque' Jerosalenṉə' besyə'ədie' gan' zo yag yix̱güion' de'en əgwṉablažə' Jeso'osən' əbiž. Na' besə'əle'i disipl c̱he' ca' babgüiž do loi. ");
INSERT INTO zavNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nach Bedən' ɉsa'alaže'e can' goquən' na' gože' Jeso'osən': —X̱ana', bgüiašc yag yix̱güion' de'en əgwṉablažo'o əbiž ṉeɉe babgüižən. ");
INSERT INTO zavNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jeso'osən' gože'ene': —Ḻe'e gonḻilažə' Diozən' na' gaquə can' əṉabelene'. ");
INSERT INTO zavNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","De'e ḻi əchnia' le'e, šə do yic̱hɉ do lažə'əle chonḻilažə'əle Diozən' guaquə ye'ele ya'a nga: “Boša' xišna'onə' na' ɉəyezo' ḻo'o nisda'onə'”, na' gaquə can' chonḻe mendadən' de'en cheɉḻe'ele sin cui chac c̱hop lažə'əle. ");
INSERT INTO zavNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","De'e na'anə' chnia' le'e de que bitə'ətezə de'en chṉabele Diozən' catə'ən chonḻe orasyonṉə', šə cheɉḻe'ele de que gone' can' chṉabelene'enə' na' guaquəczən'. ");
INSERT INTO zavNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na' catə' solao gonḻe orasyonṉə', šə yosa'alažə'əle bi de'en baben to beṉə' contr le'e, ḻeyezi'ixen c̱he', par nic̱h ḻeczə X̱acho Diozən' ben' zo yoban' yezi'ixene' xtoḻə'əlen'. ");
INSERT INTO zavNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pero šə le'e bito chezi'ixenḻe c̱he sa'alɉuežɉ beṉac̱hlen' ḻeczə ca' X̱acho Diozən' ben' zo yoban' bito yezi'ixene' xtoḻə'əlenə'. ");
INSERT INTO zavNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Na' besyə'əžine' Jerosalenṉə' de'e yoblə. Na' catə' balažə' Jeso'osən' chyo'o yo'odao' əblaonə', ben' naquəch bx̱oz əblaoch na' beṉə' ca' choso'osed choso'olo'i ḻein', na' len beṉə' golə blao c̱he neto' beṉə' Izrael gosə'əbigue'e lao Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Na' gwse'ene': —¿Nac goquən' gwxi'o yeḻə' gwnabi'anə', na' non' beṉ le' yeḻə' gwnabia'anə' par gono' de'e ca' chono'? ");
INSERT INTO zavNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jeso'osən' boži'e xtižə'əga'aque'enə' gože': —Ḻeczə de to de'e ṉabda' le'e. Šə gwnale nada' de'en ṉabda' le'e nach əṉia' le'e non' beṉ nada' yeḻə' gwnabia' par gona' de'e ca' chona'. ");
INSERT INTO zavNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ḻeṉašc nada': ¿non' bseḻə' de'e Juanṉə' bide' bc̱hoe' beṉə' nis? ¿EDioz nan' bseḻe'ene' o šə beṉə' yoblən'? ");
INSERT INTO zavNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nach boso'oxi'e entr ḻega'aque' gosə'əne': —Šə ye'echone' de que Dioz nan' bseḻe'e de'e Juanṉə' par bc̱hoe' beṉə' nis, na' ye'e chio'o: “¿Bixc̱hexan' bito gwyeɉḻe'ele c̱he'?” ");
INSERT INTO zavNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Na' nic gac ye'echone' de que beṉə' yoblən' əbseḻə' de'e Juanṉə'. Gosə'əne' ca' c̱hedə' besə'əžebe' bi so'on beṉə' ca' zɉənžaguən', la' yogue'e gwse'eɉḻe'e de que de'e ḻiczə Diozən' bseḻe'e de'e Juanṉə' par be'e xtiže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","De'e na'anə' gwse'e Jeso'osən': —Bito ṉezeto' non' bseḻə' de'e Juanṉə'. Nach gož Jeso'osən' ḻega'aque': —Ḻeczə ca' nada' bito əṉia' non' beṉ nada' yeḻə' gwnabia'anə' par gona' de'e ca' chona'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nach Jeso'osən' gwzolao be'e jempl nga bzeɉni'ine' ḻega'aque' de que notə'ətezə beṉə' šə chso'onczə yic̱hɉlaoga'aque' cui choso'ozenague' c̱he' yesə'əbi'ayi'e. Na' gwne': —To beṉə' goze' zan yag obasən' yežlyo c̱he'enə'. Na' gwlo'e le'eɉ doxenən. Na' na'atezə bene' to tanc gan' boso'osi'e obasən' par bchoɉ xisein'. Na' ḻeczə bene' to campnary gan' yesə'əcua'a beṉə' əsa'ape' güertən'. Nach bene' güertən' lao na' beṉə' par bosə'əgüia boso'oye'en, na' gwde na' gwze'e gwyeɉe' zitə'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Catə' bžin tyemp par yosyo'otobe' cwsešən', bseḻe'e to mos c̱he' par žɉəyexi'e to tlacw cwsešən' de'en cheyaḻə' yezi'e. ");
INSERT INTO zavNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero na' beṉə' ca' chsa'apə yag obas c̱he'enə' boso'oṉize' mosən', na' gosə'əyine'ene' nach bosyo'ose'ene' sin cui bi bi bosyo'onežɉue'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nach x̱an yag obasən' bseḻe'e yeto mosən', na' beṉə' ca' boso'ošiže'ene' yeɉ, na' gwso'one' güe' yic̱hɉe'enə' na' boso'ožia boso'onite'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nach bosseḻə' x̱an yag obasən' yeto mosən', na' beṉə' ca' chsa'apə yag obasən' gwso'ote' ḻe'. Na' gwdechlə x̱an yag obasən' bosseḻe'e mos zanch na' beṉə' ca' chsa'apə yag obasən' gosə'əyine' baḻe' na' yebaḻe' gwso'ote'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Na' zo xi'iṉ tlišə' x̱an yag obasən', na' chacchgüeine' c̱he'. Nach ḻe'ezelaogüe bseḻe'e ḻe'. Ḻo'o yic̱hɉla'aždaogüe'enə' goquene': “Gwsa'apəlɉe' xi'iṉan' respet yosyo'onežɉue'ebo' cwsešən'.” ");
INSERT INTO zavNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero na' beṉə' ca' chsa'apə güertən' catə' besə'əle'ine' xi'iṉe'enə' nach gwse' lɉuežɉga'aque': “Bengan' xi'iṉ x̱an yag obasən', na' ḻe'enə' yega'aṉ len bienṉə'. Ḻeda gotchone' par nic̱h yega'aṉlencho bien c̱he x̱e'enə'.” ");
INSERT INTO zavNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nach boso'oṉize'ene', gwso'ote'ene', na' besyə'əbeɉe' cuerp c̱he'enə' fuerlə güertən'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Beyož be' Jeso'osən' jempl nga, gože' beṉə' ca' ža'anə': —¿Nac chactgüeile gon x̱an güertən' len beṉə' ca'? Žɉəyeṉitlaogüe' ḻega'aque', na' yegüe'e yaguən' lao na' beṉə' yoblə. ");
INSERT INTO zavNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Ecabiṉə' šeɉni'ile bi zeɉen de'en nyoɉ Xtižə' Diozən' gan' nan: Yeɉ de'en cui gwso'olažə' mues güen yo'o ca', ḻenṉə' banaquən yeɉ squin. ");
INSERT INTO zavNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","X̱ancho Diozən' babzoe' yeɉən' gan' cheyaḻə' son na' de'e zaquə' yebanecho can' bene'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nach beṉə' fariseo ca' na' beṉə' ca' choso'osed choso'olo'i ḻein' len beṉə' golə blao ca' gwse'enene' yesə'əzene' Jeso'osən' c̱hedə' gwse'eɉni'ine' de que Jeso'osən' be'e jempl nga contr ḻega'aque' por ni c̱he de'en cui chse'eɉḻe'e c̱he'. Pero bito bi gwso'one' c̱hedə' besə'əžebe' bi so'on beṉə' ca' ža'anə'. De'e na'anə' con besa'aque' gan' zo Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Na' gwde de'e ca' boso'oseḻe'e baḻə beṉə' fariseo ca' len yebaḻə beṉə' ca' chso'on txen len Erodən' lao Jeso'osən' par yesə'əbe'enaogüe' əchoɉ dižə' cho'enə' de'en yesə'əc̱hine' par əsa'ogüe' xya contr ḻe' lao beṉə' gwnabia' c̱he gobierṉən'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nach catə' besə'əžin beṉə' can' lao Jeso'osən' na' gwse'ene': —Maestr, ṉezeto' de que cho'o dižə' ḻi na' bito chžebo' bin' yesə'əna beṉə' yoblə, c̱hedə' bito chono' cuent c̱he beṉə' šə naque' blao o šə bito naque'. Ṉezeto' can' chsed chlo'ido' beṉə' de'en chene'e Diozən' goncho naquən dižə' ḻi. De'e na'anə' zedeṉabeto' le' par əṉao' neto' naquən' cheyaḻə' gonto'. ¿Enaquən güen c̱hixɉwto' impuest c̱he gobierṉ roman' o šə bito cheyaḻə' c̱hixɉwto'on? ");
INSERT INTO zavNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jeso'osən' ḻe'e gocbe'iteine' caguə do lažə'əga'aque'enə'. Con chse'enene' ye'e ḻega'aque' to de'e yesə'əc̱hine' contr ḻe'. Nach gože' ḻega'aque': —¿Bixc̱hen' chene'ele cueɉle nada' dižə' de'e əgwc̱hinḻe contr nada'? Ḻe'e gwlo'i nada' to xmechlen'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nach boso'olo'ine' ḻe' ton na' catə' ble'i Jeso'osən' ḻen gože' ḻega'aque': —¿No diboj c̱heinə' da' laogüenṉə', na' no lein' nyoɉ laogüenṉə'? Nach gwse'ene': —C̱he Rei Sesar na'anə'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jeso'osən' gože' ḻega'aque': —Ḻe'e əgwnežɉo Sesarən' de'en naquə c̱he' ža, na' ḻe'e gwnežɉo Diozən' de'en cheyaḻə' əgwnežɉwlene'. Nach beṉə' ca' catə' gwse'enene' xtižə' Jeso'osən' besyə'əbanene' can' gože' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Na' ḻeczə besə'əžin baḻə beṉə' sadoseo ca' lao Jeso'osən'. Na' beṉə' sadoseo ca' choso'osed choso'olo'ine' de que bito yesyə'əban beṉə' guat ca'. Nach gosə'əṉabene' Jeso'osən' gwse'ene': ");
INSERT INTO zavNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestr, de'e Moisezən' bzoɉe' de que šə to beṉə' byo beṉə' nšagna' gate' na' yega'aṉ no'ol c̱he'enə' sin cui no xi'iṉe' gwzo, beṉə' bišə' be'enə' bagotən' cheyaḻə' yeque'e no'olənə' par nic̱h ṉitə' xi'iṉ dia c̱he de'e beṉə' biše'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Na' goquən' gwnitə' gažə bišə'əga'aque', na' beṉə' nechən' bšagne'e na' catə' gote' notono xi'iṉe' gwzo. ");
INSERT INTO zavNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Na' beṉə' biše'e əgwchopen' beque'e no'olən', na' ḻeczə got beṉə' əgwchopen' na' notono xi'iṉe' gwzo. Nach ḻe'egatezə ca' goquə len beṉə' biše'e əgwyoṉen'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nach ḻeczə ca' goquə len bišə'əga'aque' ca' yeḻa' xte besyə'əyatega'aque' besyə'əque'e no'olən' na' besyə'əyatega'aque' gwsa'at na' notoczə no xi'iṉga'aque' gwnitə'. Na' gwde gwsa'at beṉə' ca' ḻeczə got no'olən'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na' catə' yesyə'əban beṉə' guat ca', ¿noe' entr beṉə' ca' gažə gaquə be'en c̱he no'olən'? La' yogue'en bosyo'ošagna'alene' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Na' Jeso'osən' gože' ḻega'aque': —Bito chonḻe xbab šao', la' bito ṉezele naquən' nyoɉ Xtižə' Diozən', na' nic ṉezele naquən' naquə yeḻə' guac c̱he Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Catə'ən yesyə'əban beṉə' guat ca' bito gacbia' šə zoso'ošagne'e o šə cui. Na' cana' caguə no yosyo'ošagna'ach. Ḻebze əsa'aque' len angl c̱he Diozən' beṉə' ca' nitə' yoban'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na' ca naquən' chaquele bito yesyə'əban beṉə' guat ca', ¿əbito za'alažə'əle can' nyoɉ Xtižə' Diozən' de'en bzoɉ de'e Moisezən' can' gož Diozən' ḻe'. Moisezən' ble'ine' to yi' beḻ de'e chdoḻɉən to ḻo'o xis yešə'. Na' gož Diozən' de'e Moisezən': “Nada' naca' Dioz c̱he de'e x̱axta'ole Abraanṉə', na' Dioz c̱he de'e x̱axta'ole Isaaquən', na' Dioz c̱he de'e x̱axta'ole Jacobən'.” ");
INSERT INTO zavNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Na' ṉezecho beṉə' ca' nite'e len Diozən' c̱hedə' Diozən' bito naque' Dioz c̱he beṉə' guat, sino naque' Dioz c̱he beṉə' ca' zɉəmban. De'e na'anə' ḻechguaḻe clelən' cheɉni'ile na' chsed chlo'ile Xtižə' Diozən' clelə. ");
INSERT INTO zavNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nach bžin to beṉə' chsed chlo'i ḻei de'en bzoɉ de'e Moisezən' lao Jeso'osən', c̱hedə' benene' rson can' gwsa'acyožə beṉə' ca' Jeso'osən' na' gwṉezene' de que binḻo boži' Jeso'osən' xtižə'əga'aque'enə'. Nach gože' Jeso'osən': —Maestr, lao ḻei c̱he Diozən' ¿non' de'en none' mendad goncho naquən de'e blaoch? ");
INSERT INTO zavNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jeso'osən' gože'ene': —De'en naquə de'e žialaoch lao de'e ca' none' mendad goncho nan: “Ḻe'e gwzenag le'e beṉə' Izrael. Tozə X̱ancho Diozən' zaque'e par güe'ela'ocho. ");
INSERT INTO zavNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","De'e na'anə' cheyaḻə' gaquecho c̱he X̱ancho Diozən' do yic̱hɉ do lažə'əcho, do fuers balor c̱hecho”, ḻenṉə' naquən de'e žialaoch. ");
INSERT INTO zavNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na' de'e əgwchopen' lebze nan len de'e nechən': “Cheyaḻə' gaquecho c̱he sa'alɉuežɉcho catg chaquecho c̱he cuincho.” Bito bi de de'en non Diozən' mendad goncho de'en naquəch de'e žialaoch ca de'e ca' c̱hopə. ");
INSERT INTO zavNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nach be'enə' chsed chlo'i ḻein' gože' Jeso'osən': —De'e güen can' nao' maestr. Naquən de'e ḻi can' nao'onə' de que tozə Diozən' zo be'enə' zaquə' par güe'ela'ocho. ");
INSERT INTO zavNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na' cheyaḻə' gaquecho c̱he Diozən' do yic̱hɉ do lažə'əcho do fuers balor c̱hecho. Na' ḻeczə cheyaḻə' gaquecho c̱he sa'alɉuežɉ beṉac̱hcho catg chaquecho c̱he cuincho. Na' de'e ḻi zaquə'əchən goncho can' na de'e ca' non Diozən' mendad goncho cle ca gotcho bia yix̱ə' na' gwzeychob par güe'ela'ochone'. Zaquə'əchən cle ca' bitə'ətezəchlə de'e chnežɉwcho Diozən' cho'ela'ochone'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jeso'osən' gocbe'ine' boži'i be'enə' xtiže'en len dižə' sin', nach gož Jeso'osən' ḻe': —Bazon go'o latɉə ṉabia' Diozən' le'. Na' dezd ža na' bitoch no besyə'əyaxɉe bi de'e yesə'əṉabene' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Na' lao ṉe'e chsed chlo'i Jeso'osən' beṉə' ca' ža' ḻo'o yo'oda'onə', gože' ḻega'aque': —¿Bixc̱hen' chesə'əna beṉə' ca' choso'osed choso'olo'i ḻein' de que Cristən' naque' xi'iṉ dia c̱he de'e Rei Dabin'? ");
INSERT INTO zavNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Cuin de'e Dabin' bzoɉe' can' blo'i Spirit c̱he Diozən' ḻe' gan' nan: X̱ancho Diozən' gože' X̱ana'an: “Gwche'edo' cuita' nga ṉabi'acho txen, na' gona' par nic̱h ṉitə' de'e ca' chso'on contr le' na' beṉə' contr c̱hio' ca' xni'onə'.” ");
INSERT INTO zavNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Na' de'en gwna de'e Dabin' de que Cristən' naque' X̱ane', ¿əcabi zeɉen de que Cristən' naque' mazəchlə ca xi'iṉ dia c̱he' na'azən' ža? Nach beṉə' zan ca' besyə'əbeine' boso'ozenague' c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Na' Jeso'osən' lao bzeɉni'ine' beṉə' ca' gože' ḻega'aque': —Ḻe'e gon xbab nic̱h cui gonḻe can' chso'on beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən'. Ḻega'aque' chesyə'əbeine' chəsə'əlaže'e zɉənyaze' lachə' toṉə na' chesyə'əbeine' catə' beṉə' chəsə'əguape' ḻega'aque' diox na' chəsə'ənope'e na'aga'aque'ene' do lao lquey. ");
INSERT INTO zavNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ḻega'aque' chse'enene' yesə'əbi'e gan' chəsə'əbe' beṉə' blao catə' chɉa'aque' yo'odao' na' catə' chac lṉi. ");
INSERT INTO zavNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Na' choso'ox̱oayague' no'olə gozeb ca' par nic̱h no'ol ca' chəsə'ənežɉue' ḻega'aque' ližga'aque'en len bichlə de'en de c̱hega'aque'. Na' catə' chso'one' orasyonṉə' chso'echgüe' dižə' par nic̱h chəsə'əx̱oayague' beṉə'. Mazəchlə castigw c̱hega'aque' əgwnežɉo Diozən' clezə ca c̱he beṉə' yeziquə'əchlə c̱hedə' chso'one' de'e mal ca' zɉənac ca' len zɉəṉezene' can' na ḻein'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Na' goquən' to žlas catə' chi' Jeso'osən' ḻo'o yo'odao' əblaonə' gan' nitə' caj ca' gan' chgo'o xmech neto' beṉə' Izrael par yo'odao' əblaonə'. Na' ble'ine' beṉə' ca' catə' gosə'əgüe'e xmechga'aque'enə' ḻo'inə', na' ḻeczə ble'ine' beṉə' gwni'a ca' de'e sc̱ha'o mechən' gosə'əgüe'e. ");
INSERT INTO zavNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Na' lao chgüie' beṉə' ca', bžin to no'olə gozebə no'olə yašə' na' gwlo'e c̱hopə seṉtab dao' c̱he'enə' ḻo'o cajən'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nach Jeso'osən' goxe' disipl c̱he' ca' na' gože' ḻega'aque': —De'e ḻi əchnia' le'e, no'olə gozebən' naque' beṉə' yašə', pero bagwlo'e de'e zaquə'əch lao Diozən' ca yoguə' beṉə' ca' yeḻa'. ");
INSERT INTO zavNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ḻega'aque' gosə'əgo'o xmechga'aque' de'e checho'oṉən lao yeḻə' gwni'a c̱hega'aque'enə', pero no'olə nga lao yeḻə' yašə' yeḻə' zi' c̱he'enə' bagwlo'e yoguə' ca ga de'e dao' de c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Na' catə' beza' Jeso'osən' yo'odao' əblaonə', to disipl c̱he'enə' gože'ene': —X̱anto', bgüiašc catg xoche zɉənone' yo'odao' əblao nga, na' catg xoche yeɉ quinga zɉənonene'en. ");
INSERT INTO zavNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nach gož Jeso'osən' be'enə': —Chgüiale catec xoche naquə yoguə' de'e ca'. Pero ca naquə de'en chle'ile nga ṉa'a, gwžin ža yosyo'oc̱hiṉɉ beṉə' doxenən na' notoch no le'i ḻega'aquən. ");
INSERT INTO zavNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Na' ɉa'aque' ya'a Olibosən' de'en zo yešḻa'alə bdiṉɉən' ze frent yo'odao' əblaonə'. Na' catə' besə'əžine' lao ya'anə' gwche' Jeso'osən'. Nach Bedən', Jacobən', Juanṉə' len Ndresən' gosə'əbigue'e lao Jeso'osən' na' bgašə'əzə gwse'ene': ");
INSERT INTO zavNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Chene'eto' əṉezeto' do batə'əquən' gaquə de'e nga nao' nga. Na' ¿nac gaquə gacbe'ito' catə' bazon baozə gaquə can' na'onə'? ");
INSERT INTO zavNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jeso'osən' gože' ḻega'aque': —Ḻe'e gapə cuidad par nic̱h notono əx̱oayag le'e. ");
INSERT INTO zavNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Gwžin ža catə' zan beṉə' gox̱oayag ša' lao yežlyo nga yesə'əne' de que zɉənaque' Cristən' ben' gwleɉ Diozən' par gaquəlene' le'e. Na' beṉə' zan yesə'əx̱oayague'. ");
INSERT INTO zavNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pero na' le'e bito žeble catə' yenele dižə' de que chac gwdiḻə, o de que guaquə gwdiḻə, c̱hedə' can' cheyaḻə' gaquə. Na' ḻa'aṉə'əczə šə bachac ca' bitoṉə' əžin ža par šo'o fin c̱he yežlyon'. ");
INSERT INTO zavNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ze'e əžin žan' yesyə'ədiḻə yež contr yež, na' ṉasyon contr ṉasyon. Na' ḻeczə zan yež de'e zɉəchi' doxenḻə yežlyon' x̱o'ochgua, na' gaquə bgüin na' gaquə bichlə de'en yesə'əzaquə'əzi'e. Na' te gaquə de'e quinga ṉe'e za'aquəchczə de'en yesə'əžaglao beṉə' ža' yežlyon'. ");
INSERT INTO zavNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Na' ca naquə le'e ža, cheyaḻə' əṉezele de que beṉə' contr c̱helen' so'one' le'e lao na' beṉə' gwnabia' ca', na' yesə'əyine' le'e ḻo'o yo'odao' c̱hega'aque' ca'. Yesə'əc̱he'ex̱ax̱ɉe' le'e do lao goberṉador ca' na' do lao rei par əsa'ogüe' xya contr le'e de'en chonḻilažə'əle nada'. Can' gaquə güe'ele xtiža'anə' lao beṉə' gwnabia' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Na' ḻeczə ze'e əžin žan' šo'o fin c̱he yežlyon', žɉa'ac beṉə' doxen lao yežlyon' yesə'əyix̱ɉui'e dižə' güen dižə' cobə de'en chzeɉni'in c̱hia' len beṉə' ca' ža' yoguə' ṉasyon. ");
INSERT INTO zavNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na' catə' no yesə'əc̱he'ex̱ax̱ɉ le'e lao beṉə' gwnabia' ca' bito cue' yic̱hɉle nac yoži'ile xtižə'əga'aque'enə'. Lao or na' Spirit c̱he Diozən' əgwzeɉni'in le'e bin' ye'ega'aclene'. De'e na'anə' le'e ye'ega'aclene' con can' əgwzeɉni'i Spiritən' le'e, c̱hedə' caguə le'enə' güe'ele xtiža'anə' sino que Spirit na'anə' güe'en ḻen. ");
INSERT INTO zavNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","13","Yoguə' beṉə' cui zɉənombia' Diozən' yesə'əgue'ine' le'e c̱hedə' chonḻilažə'əle nada'. Na' xte no bišə'əle na' no x̱ale so'one' le'e lao na' beṉə' par nic̱h so'ote' le'e na' ḻeczə xte no xi'iṉle so'one' le'e lao na' beṉə' ca' so'ot le'e. Pero šə sotezə sole gonḻilažə'əle nada' xte catə'əchən' əžin ža gatle, nachən' žɉəyezole len Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Bablabczle can' bzoɉ de'e profet Danielən' ben' be' xtižə' Diozən' cana'. Na' de'en bzoɉe' nan de que beṉə' mal ca' so'one' de'en naquə de'e zban juisy de'en chgue'i Diozən' ḻo'o yo'odao' əblao c̱he chio'o beṉə' Izrael na' yo'oda'onə' bitoch gonən žin. Na' catə' le'ile gaquə de'e quinga, cana' le'e nitə'əle Jodean' cheyaḻə' əgwxoṉɉle na' žɉa'acle do ya'ada'ote. (Le'e chlable de'e nga ḻe'e šeɉni'in.) ");
INSERT INTO zavNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Na' šə zo to beṉə' chone' dezcanz lao sotea c̱he liže'enə' catə' gaquə de'e ca' bagwnia' gaquə, bito gaḻə' yotobe' šinḻaze' ca' ža' liže'enə', con cueɉyic̱hɉe'en. ");
INSERT INTO zavNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ḻeczə ca' beṉə' zda do yoba bito gaḻə' yebi'e par žɉəyexi'e xadoṉ c̱he'enə' liže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Na' ca tyempən', ḻechguaḻe zdebə gaquən len no'ol ca' zɉənoa' bdao', na' no'ol ca' chesə'əguažə' bidao'. ");
INSERT INTO zavNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ḻe'e gon orasyon par nic̱h cui cheyaḻə' əgwxoṉɉle tyemp catə' chi' de'e zag. ");
INSERT INTO zavNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Catə' gaquə de'e ca' ḻechguaḻe c̱hi' saquə' beṉə' Izrael ca' ža'anə'. Na' dezd catə'ən gwxe yežlyon' xte ža ṉeža bito əṉacho bagwdi' bagwxaquə' beṉə' can' c̱hi' saquə' beṉə' Izrael ca', na' bito əžinḻaže'e gaquə ca' len beṉac̱hən' de'e yoblə. ");
INSERT INTO zavNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Žalə' nžia Diozən' bia' yesə'əžaglaogüe' sša ni yeto beṉə' cuich zɉəmban catə'ən yeyož yesə'əžaglaogüe'enə' žalə' ca'. Pero por ni c̱he de'en chaque Diozən' c̱he beṉə' ca' chso'onḻilažə' ḻe', beṉə' ca' bagwleɉe' par zɉənaque' xi'iṉe', de'e na'anə' cui güe'e latɉə yesə'əžaglaogüe' sša. ");
INSERT INTO zavNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Na' ža, šə no əye'e le'e: “Bgüiašc nga zo Cristən' ben' əbseḻə' Diozən' par gaquəlene' chio'o”, o šə ye'e le'e: “Na'alə zoe'”, bito šeɉḻe'ele c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Zan beṉə' gox̱oayag ša' lao yežlyo nga əse'e le'e de que zɉənaque' Cristən' o de que chso'e xtižə' Diozən'. Na' so'one' miḻagr na' so'one' de'e naquə yeḻə' goban, par nic̱h yesə'əx̱oayague' beṉə' ca' bagwleɉ Diozən' par əsa'aque' xi'iṉe' pero bito gaquə yesə'əx̱oayague' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Baṉezele can' gaquə, la' bagwdix̱ɉue'ida' le'e c̱he de'e ca' ze'e gaquə. De'e na'anə' ḻe'e so probnid par nic̱h cui x̱oayagle. ");
INSERT INTO zavNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Pero na' lao ža ca' cate yeyož c̱hi' saquə' beṉac̱hən', bgüižən' bitoch əgwse'eni'in na' ḻeczə ca' bio'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Na' belɉw ca' zɉəžia ḻe'e yoban' yesə'əxopən, c̱hedə' Diozən' əgwsi'iṉse' yoguə' de'e ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Na' cana'ach beṉə' ca' ža' yežlyon' yesə'əle'ine' nada' yida' de'e yoblə to ḻo'o beɉw, nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. Yida' nsa'a yeḻə' guac xen c̱hia'anə' na' yeḻə' chey che'eni' c̱hia'anə'. ");
INSERT INTO zavNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Na' əseḻa'a angl c̱hia' ca' doxenḻə yežlyon' par yosyo'otobe' beṉə' ca' bagwleɉ Diozən' par zɉənaque' xi'iṉe' gatə'ətezə zɉənasəlase'. ");
INSERT INTO zavNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ṉezele can' chac do nga len yag yix̱güion'. Catə' bachezolao chebia xḻague'e, chacbe'ile de que bac̱h zon yela' yeɉon'. ");
INSERT INTO zavNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Na' ḻeczə can' catə'ən le'ile gaquə de'e mal ca' bagwnia' gaquə, cana'ach əṉezele de que bazon əžin ža šo'o fin c̱he yežlyon'. ");
INSERT INTO zavNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","De'e ḻi əchnia' le'e, bitoṉə' gat le'e nitə'əle tyemp nga ṉa'a catə' solao gaquə yoguə'əḻoḻ de'e ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ca naquə de'e ca' chle'icho ḻe'e yoban' na' yežlyon' yesə'əde c̱hei, pero ca naquə xtiža'anə' caguə de'e te cui gaquə can' nanṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Pero na' ca naquə bi ža bi orən' šo'o fin che yežlyon' notono no ṉeze, ni que zɉəṉeze angl ca' nitə' yoban', na' ni que ṉezda' nada' naca' Xi'iṉ Diozən'. Tozə X̱a' Dioz nan' ṉeze. ");
INSERT INTO zavNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","De'e na'anə' ḻe'e so probnid, ḻe'e gac ca beṉə' nchoɉ bišgal c̱hei na' ḻe'e gon orasyonṉə' c̱hedə' bito ṉezele batən' yida' de'e yoblə. ");
INSERT INTO zavNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Na' de'en cuezle batən' yida' de'e yoblə gwxaquə'əleben can' chac c̱he to beṉə' cheɉ zitə'. Antslə ze'e se'e liže'enə', che'e xmose' ca' bi de'en so'on to toe' na' ḻeczə ca' che'e ben' chapə puertən' gape'en do tyempte par nic̱h ca' chapəcze'en catə'ən yežine'. ");
INSERT INTO zavNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ca'aczən' naquən len le'e, ḻe'e so probnid c̱hedə' bito ṉezele batən' yida' de'e yoblə, nadan' gwxaquə'əlebeda' ca x̱an yo'onə'. Bito ṉezele šə yida' do bagoḻ o šə do chel o do šbaḻ xen o šə do che'eni'. ");
INSERT INTO zavNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ḻe'e so ca beṉə' nchoɉ bišgal c̱hei, nic̱h sole probnid na' cui senyala' le'e catə'ən yida' de'e yoblə. ");
INSERT INTO zavNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Na' de'e ca' bagwnia' le'e taple ḻeczə əchnia'an par yoguə' beṉə' chso'onḻilažə' nada'. Ḻeso probnid par catə'ən yida' de'e yoblə. ");
INSERT INTO zavNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Na' goquən' ṉe'e chac faḻt yec̱hopə ža par gaḻə' lṉi pascw c̱he neto' beṉə' Izrael Jerosalenṉə' catə'ən chaoto' yetxtil de'en cui bi xne'i nc̱hix̱ə. Na' beṉə' ca' chəsə'ənabia' bx̱oz ca' na' len beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' besyə'əyilɉe' naclə so'one' par yesə'əzene' Jeso'osən' bgašə'əzə na' so'ote'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Na' gosə'əne': —Bito gotchone' lao lṉinə' par nic̱h cui yesə'ədopə beṉə' ca' banitə' lao' syodan' na' yesə'ədiḻəlene' chio'o. ");
INSERT INTO zavNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Na' goquən' zo Jeso'osən' Betanian' liž to beṉə' le Simon be'enə' güe'i yižgüe' de'en nzi' ḻepr. Na' lao chi' Jeso'osən' cho'a mesən' chaogüe', bžin to no'olə nox̱e'e to lmet de yeɉ fin de'e yožə to cḻas set de'e nzi' nardo. Na' setən' ḻechguaḻe zix̱ chḻa'an na' ḻechguaḻe le'eyə' zaquə'ən. Na' no'olən' gwle'e lmetən' gan' yožə setən' na' bcuase'en yic̱hɉ Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nach baḻə beṉə' ca' nitə' len Jeso'osən' liž Simonṉə' besə'əže'e na' gwse' lɉuežɉga'aque': —¿Bixc̱hen' con benditɉeine' setən' nox̱e'enə'? ");
INSERT INTO zavNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Güenchlə žalə' bete'en la' mazlə tmil gueyə' gueyoa le'ine' c̱hei žalə' ca', na' mech de'en le'ine' c̱hei əgwnežɉue'en beṉə' yašə' par gaquəlene' ḻega'aque'. Na' gosə'ədiḻe' no'olən'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nach Jeso'osən' gože': —Lɉoye'enə'. ¿Bixc̱hen' chdiḻlene'? Güenchguan' babene' len nada'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ca naquə beṉə' yašə' ca' syempr nitə'əcze' len le'e, na' guaquə gaquəlenga'aclene' batə'ətezə chene'ele. Pero ca naca' nada' yešložgan' soa' len le'e. ");
INSERT INTO zavNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","De'en bcuasə' no'olən' setən' yic̱hɉa'anə' na' bežonən lao cuerp c̱hia'anə' bene' de'en non gone' len nada' žan' yoso'ocuaše'e nada', can' chonḻe chyeble set zix̱ən' cuerp c̱he beṉə' guatən'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","De'e ḻi əchnia' le'e gatə'ətezə c̱hix̱ɉue'ile dižə' güen dižə' cobə de'en chzeɉni'in c̱hia'anə' ḻeczə c̱hix̱ɉue'ile can' ben no'olə nga len nada'. Na' šanch beṉə' əso'e dižə' ca güenṉə' bene'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Gwde de'e ca' Jod Iscariotən' ben' goquə txen len disipl ca' šižiṉ, gwyeɉe' lao beṉə' ca' chəsə'ənabia' bx̱oz c̱he neto' beṉə' Izrael par gože' ḻega'aque' de que əgwdie' Jeso'osən' lao na'aga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Na' beṉə' ca' catə' gwse'enene' xtižə' Jodən' ḻechguaḻe besyə'əbeine'. Na' gwso'one' lyebe yosə'ənežɉue'ene' mech. Nach Jodən' gwzolao gwche'enaogüe' batə'əquən' so latɉə gone' Jeso'osən' lao na'aga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na' ža nech c̱he lṉi pascon' catə'ən chsa'ogüe' yetxtil de'en cui bi xne'i nc̱hix̱ə na' ḻeczə chso'ote' xilə' dao' par chɉəsyə'əzalaže'e can' bebeɉ Diozən' de'e x̱axta'oga'aque'enə' Egipton'. Na' ža na'anə' gwse' disipl c̱he Jeso'osən' ḻe': —¿Gan' che'endo' žɉe'eni'ato' de'en gaocho xše' lṉi pascon'? ");
INSERT INTO zavNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nach gwleɉe' c̱hopə disipl c̱he' ca' na' bseḻe'e ḻega'aque' lao' syodan' gože': —Ḻe'e žɉa'ac lao' syodan' na' na' yežagle to beṉə' byo beṉə' noa' che'e nisən' ya'ayene'. Na' ḻe'e žɉənaotelene'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Na' šo'ole len be'enə' na' ye'ele x̱an yo'onə': “Maestrən' ne' goṉšgo' to cuart gan' güe'eni'ato' de'en gaolento'one' xše' lṉi pascon', neto' disipl c̱he'.” ");
INSERT INTO zavNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nach əgwlo'ine' le'e to cuart xen de'e zo žcuia la'aḻə, na' ḻo'o cuartən' zo to mes, na' nitə' ga cue'ele na' bichlə de'e chyažɉele. Ḻo'o cuart na'anə' əgwsi'ini'ale de'en gaocho lao lṉi pascon'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nach gwsa'ac disipl c̱he' ca' na' catə' besə'əžine' syodan' yoguə'əḻoḻ can' gože' ḻega'aque'enə' goquə. Nach boso'osi'ini'e de'en gwsa'ogüe' xše' lṉi pascon'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Na' catə' beyož gwx̱en, Jeso'osən' len disipl c̱he' ca' šižiṉ besə'əžine' yo'onə' gan' baboso'osi'ini'e de'en əsa'ogüe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Na' lao zɉəchi'e cho'a mesən' chsa'ogüe', Jeso'osən' gože' ḻega'aque': —De'e ḻi əchnia' le'e, entr to le'e chaolenḻe nada' txen gonḻe nada' lao na' beṉə' contr ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nach de'e juisy de'e gwsa'aquene' catə' beyož gwne' ca', nach tgüeɉə tgüeɉe' gwse'e ḻe': —X̱ana' ¿ənada'an gona' le' lao na' beṉə' contr ca'? ");
INSERT INTO zavNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jeso'osən' gože' ḻega'aque': —Entr le'e šižiṉle tole chne' na'alen' ḻo'o platən' txen len nadan', gonḻe nada' lao na' beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Banaquəczən so'ot beṉə' nada' can' nyoɉ Xtižə' Diozən' nan gaquə c̱hia' nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. Pero probchguazə be'enə' gon nada' lao na' beṉə' contr ca'. Nca'alə xṉeze žalə' cuiclə golɉe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Na' lao chsa'ogüe'enə' gwxi' Jeso'osən' yetxtilən', na' be'e yeḻə' chox̱cwlen c̱he Diozən'. Gwde na' bzoxɉe'en, nach be'en disipl c̱he' ca', gože' ḻega'aque': —Ḻe'e gaon. Ḻenṉə' cuerp c̱hia'anə'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nach ḻeczə bex̱e'e basən' gan' yožə nis obasən', na' lao nox̱e'en be'e yeḻə' chox̱cwlen c̱he Diozən' nach bosnežɉue'en ḻega'aque' na' yogue'e gwse'eɉe'en. ");
INSERT INTO zavNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nach gože' ḻega'aque': —Ḻenṉə' xc̱hena'anə'. Na' xc̱hena' na'anə' ḻalɉə por ni c̱he xtoḻə' beṉac̱hən'. Na' de'en ḻalɉənṉə' solao gaquə de'e cobə de'en ben Diozən' lyebe gone' par gaquəlene' beṉac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","De'e ḻi chnia' le'e ṉa'a zelao che'eɉa' nis oban'. Pero de yeto de'e yebeichecho mazəchlə can' chebeicho che'eɉcho nis oban', ḻenṉə' de'en socho mbalaz zeɉḻicaṉe catə'ən socho txen gan' ṉabi'a len Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Na' beyož gwse'eɉ gwsa'ogüe' gwso'oḻe' to imno, nach besə'əchoɉe' ɉa'aque' ya'a de'en nzi' Olibos. ");
INSERT INTO zavNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Na' lao zɉəngüe'e nezən' Jeso'osən' gože' disipl c̱he' ca': —Ṉeže' yoguə'əle cueɉyic̱hɉle nada' por ni c̱he de'en gaquə c̱hia'. Gaquə can' nyoɉ Xtižə' Diozən' nan: “Gota' beṉə' goye xiḻə'ənə' na' xiḻə' c̱he' ca' əsa'asəlasəb.” ");
INSERT INTO zavNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero na' catə' yeyas yebana' ladɉo beṉə' guat ca', yobəchda' yeya'a Galilean' cle ca le'e. ");
INSERT INTO zavNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nach Bedən' gože' Jeso'osən': —Nada' cuat cueɉəyic̱hɉa' le' ḻa'aṉə'əczə šə yoguə' beṉə' yeziquə'əchlə yesə'əbeɉyic̱hɉle' le'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jeso'osən' gože'ene': —De'e ḻi əchnia' le' ṉeže' antslə ze'e cuež ḻecon' c̱hop las, gaquə šoṉ las cui chc̱hebo' de que nombi'o nada'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nach Bedən' gože' Jeso'osən': —Ḻa'aṉə'əczə šə chonclən byen guatlencza' le' bito əṉia' de que bito nombi'a le'. Na' ḻeczə ca' əgwse' yoguə' disipl c̱he' ca' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Na' catə' Jeso'osən' len disipl c̱he' ca' besə'əžine' latɉən' gan' nzi' Getsemani, gože' ḻega'aque': —Ngazə ḻecue' žlac ša'a de'e na' žɉena' orasyon. ");
INSERT INTO zavNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Na' gwc̱he'e Bedən' len Jacobən' na' Juanṉə', gwsa'aque' gan' nitə' disipl ca' yeḻa'. Na' Jeso'osən' gwzolao gwzochgüe' trist, na' de'e juisy de'e goquene' ḻo'o yic̱hɉla'ažda'ogüe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Na' gože' ḻega'aque': —Tristchgua zo yic̱hɉla'aždaogua'anə' xte bachonən yeḻə' got. Ḻecuezə nga na' sole əṉa'azle len nada'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nach gwdie' gwyeɉe' yelatə' delant na' ɉete'e gosc̱ho'alə lao yon'. Nach bene' orasyonṉə' gwṉabene' Diozən' šə guac te ca'azə de'en c̱hi' saque'e. ");
INSERT INTO zavNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Na' gože' X̱e'enə': —X̱a' Dioz, le' chac chono' yoguə'əḻoḻ. Benšga ca te ca'azə de'en c̱hi' saca'anə', pero bito che'enda' gaquə de'e ənia' nada', sino gaquə con can' ənao' le'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nach beyeɉe' gan' nitə' disipl ca' šoṉə, na' ɉəyedi'e ḻega'aque' chəsə'ətase'. Na' gože' Bedən': —Simon ¿əchtaso'? ¿Eni to or bito bcheɉdo' əna'azo' len nada'? ");
INSERT INTO zavNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ḻe'e ṉa', na' ḻe'e gon orasyon nic̱h cui co'o gwxiye'en le'e nez mal. Ṉezda' chene'ele əṉa'azle len nada', pero cui chzoile. ");
INSERT INTO zavNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Na' gozse'e gan' nite'enə' de'e yoblə, ɉəzene' orasyonṉə', na' gwnacze' can' bagwne'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Na' catə' bezžine' gan' nite'enə' de'e yoblə, ɉəyezdi'icze' disipl ca' šoṉə chesə'ətase', tant cuich chesə'əzoine' bišgalən'. Na' xte bito zɉəṉezene' bi əse'e ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Na' gwze'e de'e yoblə gan' nite'enə' ɉene' orasyonṉə' de'e gwyoṉ lase, na' catə' bezžine' gan' nitə' disipl ca' šoṉə, na' gože' ḻega'aque': —¿Eṉe'e chtasle? ¿Eṉe'e chonḻe dezcanz? Bac̱h goc ṉa'a. Diozən' bseḻe'e nada' golɉa' beṉac̱h na' ṉa'a bac̱h bžin or gaca' lao na' beṉə' mal ca' par so'ote' nada'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ḻe'e secha, ḻe'e šo'o. Baza' ben' gon nada' lažə' na' beṉə' contr ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ṉe'e cho'ete Jeso'osən' dižə'ən ca' catə' bžin Jodən' ben' naque' cuent len disipl ca' šižiṉ. Na' žague' zan beṉə' boso'oseḻə' beṉə' ca' chesə'ənabia' bx̱oz c̱he neto' beṉə' Izrael na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən', na' beṉə' golə blao c̱he ṉasyon c̱heto'onə'. Beṉə' ca' zɉənžag Jodən' zɉənaḻe'e spad na' zɉənḻene' no yag. ");
INSERT INTO zavNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jodən' babzeɉni'ine' ḻega'aque' can' gone' par əgwdie' Jeso'osən' lao na'aga'aque'enə', gože' ḻega'aque': —Be'enə' gaogua' bxidən', ḻe'enə' senḻe na' gwc̱heɉlene' par əc̱he'elene'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nach catə' bžine' gan' zo Jeso'osən' ḻe'e bgüiguə'əte' cuite'enə' na' gože'ene': —Maestr. Na' gwdaogüe'ene' bxidən', pero caguə do laže'enə' bene' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nach beṉə' ca' əzɉa'ac len Jodən' gwso'ox̱e'e Jeso'osən' na' gosə'əc̱he'ex̱ax̱ɉe' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Na' to beṉə' zecha gaḻə'əzə gwlec̱hɉ spad c̱he'enə' gwdine'en šḻa'a nag xmos bx̱ozən' ben' naquəch əblao, gwc̱hogtechgüe'en. ");
INSERT INTO zavNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nach Jeso'osən' gože' beṉə' ca': —Za'acle len spad na' len yag zedəx̱enḻe nada' ca to beṉə' bguan. ");
INSERT INTO zavNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yoguə' ža gwchi'a len le'e bsed blo'ida' beṉə' ḻo'o yo'odao' əblaonə' na' bito gwxenḻe nada'. Pero chac de'e quinga par nic̱h chac complir can' na' Xtižə' Diozən' de'en nyoɉən' gaquə c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Na' lao or na' bosyo'oxoṉɉ yoguə' disipl c̱he' ca' gosə'əbeɉyic̱hɉe'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Na' to beṉə' güegon' ɉənaogüe' Jeso'osən', na' nyaze' to lachə' de'e naquə ca to sabana. ");
INSERT INTO zavNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Na' ca gwso'ox̱e'ene' gwso'ox̱e'e slezə xe'enə' na' ḻe'e bchoɉte' ḻo'inə' na' bexoṉɉe' ga'alyide'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Na' beṉə' ca' gosə'əzen Jeso'osən' gosə'əc̱he'ene' lao Caifasən' ben' naquəch bx̱oz əblao c̱he neto' beṉə' Izrael. Nach besə'ədobə yoguə' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' na' len yeziquə'əchlə beṉə' golə blao ca' chəsə'ənabia' ṉasyon c̱heto'onə'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nach Bedən' ɉənaogüe' Jeso'osən' zitə' zitə' xte bžinte' liž bx̱oz əblaonə' na' gwyo'e chyo'onə'. Na' beṉə' ca' zɉənaquə x̱a'ag yo'oda'onə' zɉəchi'e cho'a yi'inə' par chəsyə'əže'ine'. Nach Bedən' ɉəc̱hi'e len ḻega'aque' cho'a yi'inə'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na' yoguə' bx̱oz əblao ca' na' yeziquə'əchlə beṉə' golə blao ca' chesə'ənabia' ṉasyon Izrael c̱heto'onə' gosə'əyilɉe' beṉə' əso'e dižə' contr Jeso'osən' par nic̱h yesə'əc̱hoglaogüe'en c̱he' de que gate', pero notono besə'əželene'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Beṉə' zan gwso'e dižə' güenḻažə' contr Jeso'osən' pero xtižə'əga'aque'enə' bito besyə'ədiḻən. ");
INSERT INTO zavNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nach baḻə beṉə' gosə'əzeche' na' gwso'e dižə' güenḻažə' contr ḻe' gosə'əne': ");
INSERT INTO zavNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Beneto' catə' gwne': “Yoc̱hiṉɉa' yo'odao' əblao nga gwso'on beṉə', na' lao šoṉə žazə gona' yeto yo'odao' əblao de'en cui gon beṉac̱hən'.” ");
INSERT INTO zavNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero bia'aczə bito bediḻe de'en gosə'əne'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nach gwzoža' ben' naquəch bx̱oz əblao gwzeche' gwchoḻga'aque'enə' gože' Jeso'osən': —¿Ebito bi nao' ca naquə de'e nga chosə'əcuiš beṉə' quinga le'? ");
INSERT INTO zavNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Na' Jeso'osən' bitobi gwne'. Nach gož ben' naquəch bx̱oz əblao ḻe': —¿Eḻe len' Cristən' ben' gwleɉ Diozən' par gaquəleno' ṉasyon c̱hechon'? ¿Elen' Xi'iṉ Dioz ben' cho'ela'ocho? ");
INSERT INTO zavNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jeso'osən' gože'ene': —Ḻe ben' nao' na' nada'. Diozən' bseḻe'e nada' golɉa' beṉac̱h na' əchnia' le'e gwžin ža le'ile nada' chi'a cuit X̱a' Diozən' ben' napə ḻe'ezelaogüe yeḻə' guac xen na' ṉabi'a txen len ḻe'. Na' le'ile nada' yetɉa' yoban' to ḻo'o beɉw. ");
INSERT INTO zavNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Catə' bene ben' naquəch bx̱oz əblao xtižə' Jeso'osən' gwšo' gwc̱hezə' xe'enə' goquene' de'e mal juisy can' gwna Jeso'osən', na' gwne': —¿Nochxa testigon' chyažɉecho? ");
INSERT INTO zavNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Babenecho chžia chnite'e Diozən' de'en ne' naque' Xi'iṉ Dioz len naque' con to beṉac̱hzə. ¿Bi nale? ¿Nac gonchone'? Nach yoguə' beṉə' ca' ža'anə' gosə'əc̱hoglaogüe'en c̱he' de que cheyaḻə' gate'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nach baḻe' boso'oža' x̱ene'enə' cho'alao Jeso'osən', na' boso'ocuaše'e cho'alaogüe'enə' len to lachə' na' gosə'əbaže'ene', gwse'ene': —Gwṉeya'ašc ¿non' chbažə' le'? Nach x̱a'ag yo'odao' ca' ḻeczə gosə'əgape'e x̱ague'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Na' lao chac de'e quinga Bedən' chi'e chyo'o c̱he ben' naquəch bx̱oz əblaoch na' na' chi'e catə' bžin to no'ol criad c̱he ben' naquəch bx̱oz əblaon'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Na' catə' ble'ine' chi' Bedən' cho'a yi'inə' par cheže'ine', no'olən' bgüiayaṉe'ene' na' gože'ene': —Ḻeczə leno' le' naco' txen Jeso'os beṉə' Nasaretən'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero Bedən' bito gwc̱hebe' šə naque' txen len Jeso'osən'. Gože' no'olən': —Bito nombi'ane' na' nic ṉezda' bi dižə'ən cho'o. Na' gwyeɉe' ɉəzeche' cho'a puert saguanṉə'. Nach ḻe'e gwchežte to ḻecw. ");
INSERT INTO zavNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nach bezle'i no'olən' ḻe' de'e yoblə na' gože' beṉə' ca' ža'anə': —Benga naque' txen len beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Na' de'e yoblə bito gwc̱hebe' šə nombi'e Jeso'osən'. Na' chaczə šlož beṉə' ca' ža'anə' gosə'əze'e Bedən': —De'e ḻiczə le' naco' txen len beṉə' ca' c̱hedə' ca nga chṉio' ngazə nacbia' de que naco' beṉə' Galilea. ");
INSERT INTO zavNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nach Bedən' bzoe' Diozən' testigw gwne': —Diozən' goṉe' nada' castigw šə chonḻaža'an əṉia' bito nombi'a ben' nale ca'. Chzoa' jorament lao Diozən', bito nombi'ane'. ");
INSERT INTO zavNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Na' ḻe'e gwchežte ḻecon' de'e yoblə. Nach ɉsa'alažə' Bedən' can' gož Jeso'osən' ḻe' de que ze'e gaquə c̱hop las cuež ḻecon' catə' gaquə šon las cui chc̱hebe' de que nombie'ene'. Na' catə' bene' xbab c̱he de'enə' gwchežyaše'e tant de'e goquene'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na' catə' gwye'eni'inə' bx̱oz əblao ca' na' yeziquə'əchlə beṉə' golə blao ca', na' len beṉə' ca' choso'osed choso'olo'i ḻein', na' len yeziquə'əchlə beṉə' ca' chesə'ənabia' ṉasyon Izraelən' besyə'ədobe' par nic̱h boso'oxi'e naclən' so'one' len Jeso'osən' na' boso'oc̱heɉe'ene' na' gosə'əc̱he'ene' ɉse'ene'ene' lao na' Pilatən'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatən' gože' Jeso'osən': —¿Elen' naco' rei c̱he beṉə' Izrael ca'? Nach Jeso'osən' gože'ene': —Ḻe be'en nao' nan' naca'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na' de'e zan de'e gosə'əna beṉə' gwnabia' c̱he bx̱oz ca' par boso'ocuiše' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nach Pilatən' goze'e Jeso'osən': —¿Ebito choži'o xtižə'əga'aque'enə'? ¿Ecabi chendo' catec de'e zan xya nga chsa'ogüe' contr le'? ");
INSERT INTO zavNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero Jeso'osən' ni to xtižə'əga'aque'enə' bito boži'e, xte bebanchgüeicze Pilatən'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na' de to costombr c̱hega'aque' de que ža lṉi pascon' əgwsan Pilatən' to pres, con beṉə' yesə'əṉab beṉə' Izrael ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Na' ližya na' de to pres beṉə' le' Barrabas txen len beṉə' ca' boso'ox̱e gwdiḻə lao syodan' na' zɉənaque' beṉə' güet beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Na' beṉə' zan ca' bazɉənžag gosə'əbigue'e lao Pilatən' na' gosə'əṉabene' ḻe' əgwsane' to pres can' naquə costombr c̱hega'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nach Pilatən' gože' ḻega'aque': —¿Echene'ele əgwsana' ben' naquə rei c̱he le'e beṉə' Izrael? ");
INSERT INTO zavNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Gwne' ca' c̱hedə' ṉezene' beṉə' ca' chesə'ənabia' bx̱oz ca' zɉəžiague'ine' Jeso'osən', de'e na'anə' boso'odie' ḻe' lao ne'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Na' beṉə' ca' chəsə'ənabia' bx̱oz ca' gosə'əgo'oyeḻe'e beṉə' zan ca' ža'anə' par yesə'əṉabe' əgwsane' Barrabasən' lgua'a Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nach Pilatən' gože' ḻega'aque': —¿Bixa gona' len Jeso'osən' ben' nale naque' rei c̱he le'e beṉə' Izrael? ");
INSERT INTO zavNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nach gwso'osye'e gwse'e Pilatən': —Bde'e ḻe'e yag corozən'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatən' gože' ḻega'aque': —¿Bixa de'e mal babene'enə'? Pero beṉə' ca' gwso'osye'e yeḻatə' zižɉoch gosə'əne': —Bde'e ḻe'e yag corozən'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Na' Pilatən' gone'ene' soe' güen len beṉə' zan ca'. De'e na'anə' bsane' Barrabasən'. Na' beyož gosə'əyin soḻdad ca' Jeso'osən', Pilatən' bene'ene' lao na'aga'aque' par yoso'ode'ene' ḻe'e yag corozən'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nach gosə'əc̱he' soḻdad ca' Jeso'osən' chyo'o c̱he yo'o gan' chi' Pilatən' na' bosyo'otobe' yoguə' soḻdad ca' yeḻa'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nach gosə'əyiṉe' xa Jeso'osən' na' boso'oguacue'ene' to lachə' morad na' gwso'one' to coron de yešə' na' boso'ožine'en yic̱hɉe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Na' gwso'onene' borl gosə'əne': —Biba rei c̱he beṉə' Izrael. ");
INSERT INTO zavNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nach soḻdad ca' gosə'əyine' yic̱hɉe'enə' to ya, na' boso'oža' x̱ene'en ḻe' na' boso'ozo xibga'aque'enə' laogüe'enə' chso'one' ca cho'elao' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Na' catə' beyož gwso'one'ene' borlən' besyə'əyiṉe' lachə' moradən' boso'oguacue'ene' na' bosyo'oguacue'ene' xacze'. Nach gosə'əc̱he'ene' par yoso'ode'ene' ḻe'e yag corozən'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","To beṉə' Sirene le' Simon x̱a Ḻjandr na' Rofo ze'e zeze'e yoba catə' bežague' beṉə' ca' zɉənc̱he'e Jeso'osən' par yoso'ode'ene' ḻe'e yag corozən'. Na' ḻa fuers boso'ode'e yag coroz c̱he Jeso'osən' cožə' Simonṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Na' gosə'əc̱he'e Jeso'osən' to latɉə de'en nzi' Golgota, zeɉen dižə' latɉə c̱he yic̱hɉ beṉə' guat. ");
INSERT INTO zavNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Na' boso'onežɉue'ene' bino corrient de'en nc̱hix̱ən len to rmech zla' de'en nzi' mirra. Pero Jeso'osən' bito güe'eɉe'en. ");
INSERT INTO zavNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nach boso'ode'ene' ḻe'e yag corozən'. Na' soḻdad ca' gwso'one' xala'ane'enə' rif entr ḻega'aque' par gosə'əṉezene' bi partən' yecheḻə to toga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Na' do cheda ga lsil boso'ode'e Jeso'osən' ḻe'e yag corozən'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Na' yic̱hɉ yag coroz c̱he'enə' boso'ozoɉe' de'en bcuiš ḻe', nan: “Bengan' Rei c̱he beṉə' Izrael ca'.” ");
INSERT INTO zavNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Na' ḻeczə cana' boso'ode'e c̱hopə beṉə' bguan ḻe'e yec̱hopə yag coroz, toe' gwda cuit Jeso'osən' ḻicha na' yetoe' cuite'en yeglə. ");
INSERT INTO zavNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Na' de'en goc ca' goc complir can' nyoɉ Xtižə' Diozən' gan' nan: “So'onene' ḻe' caczən' chso'onene' beṉə' güen de'e mal.” ");
INSERT INTO zavNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Na' beṉə' ca' chse'eɉ chəsə'əde' gan' da' Jeso'osən' chəsə'əḻoḻə' yic̱hɉga'aque'enə' gwso'onene' borl gwse'ene': —Len' gwnao' guaquə yoc̱hiṉɉo' yo'odao' əblaonə' na' šoṉə žazə yeyono'on, bosla cuino' na' beyetɉ ḻe'e yag corozən'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Na' ḻeczə ca' beṉə' gwnabia' c̱he bx̱oz ca' na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' gwso'one'ene' borl gosə'əne': —Yeziquə'əchlə beṉə' bosle' na' cabi chac yosla cuine'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Šə ḻen' naque' Cristən' ben' gwleɉ Diozən' par gaquəlene' ṉasyon c̱hechon', na' nacte' rei c̱he chio'o beṉə' Izrael, yoletɉ cuine' ḻe'e yag corozən' ṉa'a par nic̱h le'icho na' šeɉḻe'echo c̱he'. Na' beṉə' ca' zɉəda' ḻe'e yag corozən' cuite'enə' c̱hopə ḻa'a, ḻeczə gwso'onene' borl. ");
INSERT INTO zavNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Na' do gobiž goc žc̱hoḻ doxen yežlyon' bžinte cheda šoṉə. ");
INSERT INTO zavNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Na' do cheda šoṉə catə' gwṉe Jeso'osən' zižɉo gwne': —Eli, ¿lama sabactani? —zeɉe dižə': “Dioz c̱hia', ¿bixc̱hen' bagwleɉyic̱hɉo' nada'?” ");
INSERT INTO zavNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Na' beṉə' nitə' gaḻə'əzə gwse'enene' can' gwne'enə' nach gosə'əne': —Ḻe'e gwzenagšc, chaxe' Ḻiazən' ben' be' xtižə' Diozən' cana'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nach bchoɉ to beṉə' gwsa'adoe' ɉəx̱i'e to spong na' bosgaže'en bino corrient de'en cui bi nc̱hix̱ə, na' bzo'en to lao ya dao' na' bosšine'en cho'a Jeso'osən' par nic̱h güe'eɉe'en na' be'enə' gwne': —Cuezcho yešc šə yidə Ḻiazən' na' yoletɉe'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jeso'osən' bisye'e zižɉo nach gote'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Na' ca naquə lachə'ən de'en ze ḻo'o yo'odao' əblao c̱he neto' beṉə' Izrael ḻe'e gwchezə'əte gwchoḻən' gwza'azə yic̱hɉei bechoɉte che'elə. ");
INSERT INTO zavNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na' lao orən' got Jeso'osən', capitan c̱he soḻdad ca' ben' zecha lao Jeso'osən' benene' can' bisya'a Jeso'osən' na' ble'ine' can' gote' na' gwne': —De'e ḻiczə benga naque' Xi'iṉ Dioz. ");
INSERT INTO zavNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Na' ḻeczə nitə' zan no'olə latɉən' beṉə' gosə'əzecha zitə'ələ par besə'əle'ine' can' goquən'. Na' entr ḻega'aque' zɉəlen no'ol quinga: Maria beṉə' Magdala, na' Maria xna' Jwsen' na' Jacob bi'in naquəch bi'i xcuidə', na' ḻeczə len Salme. ");
INSERT INTO zavNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","No'ol ca' gosə'əzolao chso'onḻilažə' Jeso'osən' catə'ən gwzoe' Galilean' na' gwsa'aclene' ḻe' len bi de'en byažɉene', ḻega'aque' na' yezan no'olə ca' besyə'ənaogüe' Jeso'osən' catə'ən beze'e Galilean' par bežine' Jerosalenṉə'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Na' ṉe'e da' Jeso'osən' ḻe'e yag corozən' catə' gwzolao chex̱ɉw že'enə', na' ža na'anə' catə'ən choso'osi'ini'e c̱he lṉi pascon', na' bachžin or so'omba'aṉe' ža dezcanzən'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Na' gwzo to beṉə' le Jwse na' naque' beṉə' Arimatea, na' nacte' to beṉə' blao entr beṉə' ca' chesə'ənabia' ṉasyon Izrael c̱heto'onə'. Na' Jwsen' gwzoe' lez əžin ža seḻə' Diozən' beṉə' ṉabia' ṉasyon c̱heto'onə'. Na' laogüe de'en bachex̱ɉw že'enə' benc̱hec̱hlaže'e gwyeɉe' lao Pilatən' ɉəṉabe' cuerp c̱he Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatən' bebanene' de'en byob got Jeso'osən', nach goxe' capitanṉə' gwṉabene' ḻe' šə ḻe bagote'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Catə' capitanṉə' gože'ene' de que bagote', nach Pilatən' be'e ḻatɉə žɉəyeletɉ Jwsen' cuerp c̱he Jeso'osən' par yeyo'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Na' Jwsen' gwxi'e to lachə' fin nach gwyeɉe' gan' da' Jeso'osən' na' beletɉe'ene' ḻe'e yag corozən' nach bolaže'ene' lachə'ənə', na' gwlo'ene' to ḻo'o bloɉ ba de'e bagwc̱he'ene' to ḻe'e yeɉ. Na' beyož bene' de'e ca' bḻoḻe' to yeɉ xen de'e bseyɉuene' cho'a banə'. ");
INSERT INTO zavNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na' Maria beṉə' Magdalan' na' Maria xna' Jwsen' yeto, besə'əle'ine' gan' boso'ocuaše'e cuerp c̱he Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Na' catə' gwde ža dezcanzən' Maria beṉə' Magdalan', na' Maria xna' Jacobən' na' len Salmen' ɉəsə'əxi'e set zix̱ de'e yoso'oguazɉe' cuerp c̱he Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Na' zil dmigw tempran gwsa'aque' zɉa'aque' cho'a ban' na' besə'əžine' cho'a ban' do chla'atg bgüižən'. ");
INSERT INTO zavNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Na' lao zɉa'aque'enə' gwse'e lɉuežɉga'aque': —¿No gaquə yeca'a yeɉən' de'en da' cho'a ban' par nic̱h šo'ocho? ");
INSERT INTO zavNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Na' ca ṉe'e zɉa'aque' zitə'ələ gan' zo bloɉ ban' besə'əle'ine' de que yeɉ xenṉə' de'en da' cho'a ban' bac̱h bega'an. ");
INSERT INTO zavNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Catə' besə'əžine'enə' gwso'e ḻo'o bloɉən' na' besə'əle'ine' to beṉə' xcuidə' chi'e ḻo'inə' šḻa'a ḻichalə na' nyaze' to lachə' šyiš toṉə, na' no'ol ca' besə'əžebe' catə' besə'əle'ine'ene'. ");
INSERT INTO zavNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Na' gože' ḻega'aque': —Bito žeble. Nada' ṉezda' de que cheyilɉle Jeso'osən' ben' naquə beṉə' Nasaret ben' boso'ode'e ḻe'e yag corozən'. Babebane' ladɉo beṉə' guat ca'. Notoch no nḻa' nga. Ḻegüia latɉə ga nga bosə'əx̱oe' cuerp c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ḻe'e žɉəya'ac ḻe'e žɉəyedix̱ɉue'i Bedən' len disipl ca' yeḻa' de que gwyobe Jeso'osən' yežine' Galilean' ca le'e na' Galilea na' gwle'iczelene', can' gwnacze' le'e. ");
INSERT INTO zavNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nach besyə'əchoɉe' ḻo'o ban' besa'acdoe' xte gosə'əxize' tant besə'əžebe'. Na' notono gwse'e bin' goquə c̱hedə' besə'əžebe'. ");
INSERT INTO zavNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Na' zil dmigw tempran catə'ən beban Jeso'osən' ladɉo beṉə' guat ca' zgua'atec blo'e laogüe' Maria beṉə' Magdalan' ben' bebeɉe' gažə de'e x̱io' zɉəyo'o zɉəyaz yic̱hɉla'aždaogüe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ḻe' ɉəyedix̱ɉue'ine' yeziquə'əchlə beṉə' ca' de que beban Jeso'osən' ladɉo beṉə' guat ca'. Catə' bžin Marian' chəsə'əbežyašə' beṉə' ca' na' chəsyə'əgüine'ene' c̱hedə' gwso'ot beṉə' mal ca' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Na' catə' gwse'enene' de que babeban Jeso'osən' ladɉo beṉə' guat ca' na' de que Marian' bable'ine' ḻe', bito gwse'eɉḻe'e. ");
INSERT INTO zavNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Na' blo'e lao Jeso'osən' c̱hopə disipl c̱he' ca' lao zɉa'aque' yoba, pero nža'alə can' besə'əle'ine' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Na' ɉəya'aque' ɉəsyə'ədix̱ɉue'ine' beṉə' lɉuežɉga'aque' ca' pero beṉə' ca' ḻeczə bito gwse'eɉḻe'e c̱he ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Na' gwdechlə blo'e lao Jeso'osən' disipl c̱he' ca' šneɉ lao chsa'ogüe'. Na' gwdiḻe' ḻega'aque' de'en zɉənaque' beṉə' la'aždao' žod na' de'en cui gwse'eɉḻe'e de que bebane' ladɉo beṉə' guat ca' ḻa'aṉə'əczə beṉə' ca' besə'əle'i ḻe' gwse'e ḻega'aque' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nach gože' ḻega'aque': —Ḻe'e žɉa'ac ḻe'e žɉəsed ḻe'e žɉəlo'i beṉə' ca' ža' yoguə'əḻoḻ ṉasyon dižə' güen dižə' cobə de'en chzeɉni'in c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Na' beṉə' ca' so'onḻilažə' nada' na' yesə'əchoe' nis bito žɉəya'aque' lao yi' gabiḻən'. Na' beṉə' ca' cui so'onḻilažə' nada' yesə'əbiayi'e lao yi' gabiḻən'. ");
INSERT INTO zavNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na' beṉə' ca' so'onḻilažə' nada' gwnežɉoga'aca'ane' yeḻə' guac par so'one' de'e quinga: Len yeḻə' guac c̱hia'anə' yesyə'əbeɉe' de'e x̱io' ca' zɉəyo'o zɉəyaz yic̱hɉla'aždao' beṉə', na' əso'e gwde gwdelə dižə' de'en cui no chac. ");
INSERT INTO zavNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Guaquə əso'ox̱e'e no beḻ bia benen na' bitobi gaquə c̱hega'aque'. Na' šə əse'eɉe' benen bitobi gonən len ḻega'aque'. Guaquə yesə'əx̱oa' na'aga'aque'enə' yic̱hɉ beṉə' ca' chsa'acšene, na' yesyə'əyaque beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Na' catə' beyož be'e X̱ancho Jeso'osən' dižə'ən ca' len ḻega'aque', bezi' beca'a Diozən' ḻe' yoban' gan' chi'e chnabi'e txen len X̱acho Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Na' disipl c̱he' ca' ɉa'aque' doxenḻə ɉəsə'ədix̱ɉue'ine' dižə' güen dižə' cobə de'en chzeɉni'in c̱he Jeso'osən', na' ḻe' goclene' ḻega'aque' na' bene' par nic̱h gwso'one' no miḻagr len yeḻə' guac c̱he'enə' par blo'e de que xtižə'əga'aque'enə' naquən de'e ḻi. De'e na'azən' chzoɉa'.");
INSERT INTO zavNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Señor Tiofl, chzoɉa' le' dižə' quinga par nic̱h na' əṉezdo' de'e ḻi ca naquə de'en babendo' na' de'en bagoc. Beṉə' zan bac̱h boso'ozoɉe' c̱he Jeso'osən' ca naquə de'en bagoc complir par neto' chonḻilažə'əto'one'. Boso'ozoɉe'en can' bzeɉni'i beṉə' ca' neto', beṉə' ca' besə'əle'i can' goquə dezd golɉte Jeso'osən'. Na' beṉə' ca' gwse'en besə'əle'ine' can' goquən' boso'osed boso'olo'ine' beṉə' yoblə dižə' güen dižə' cobə c̱he Jesocristən'. Na' nada' catə' beyož gwṉabyoža' can' goquən', na' gwyazlaža'a gwzoɉa'an tcho'a tšao' par nic̱h əṉezdo' Señor Tiofl. ");
INSERT INTO zavNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ca tyemp can' gwnabia' Rei Erodən' gan' nzi' Jodea, na' zo to bx̱oz c̱he beṉə' Izrael ca' beṉə' le Zequeria. Bene' žin len x̱oṉɉ bx̱oz beṉə' zɉele Abias. Na' no'ol c̱he Zequerian' le' C̱habet na' naque' dia c̱he de'e bx̱oz Ronṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Na' Zequerian' len C̱habetən' zɉa'accze' ḻicha par len Diozən', na' gwso'one' yoguə'əḻoḻ de'en non X̱ancho Diozən' mendad de'en zɉənyoɉ ḻe'e ḻei c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Na' notono xi'iṉga'aque' nitə', c̱hedə' C̱habetən' naque' no'olə güiž, na' c̱hopte' bazɉənaque' beṉə' golə. ");
INSERT INTO zavNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Na' goquən' beyaḻə' Zequerian' len beṉə' lɉuežɉe' ca' beṉə' ca' zɉənaquə bx̱oz par gwso'one' de'en besyə'əyaḻe'e so'one' par gwso'elaogüe'e Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Na' de costombr c̱he bx̱oz ca' chso'one' rif par chatə'əbia' noe' əchoɉ par əgwzeye' yal ḻo'o yo'odao' əblao c̱hega'aque'enə' gan' chso'elaogüe'e X̱ancho Diozən' Jerosalenṉə'. Nach gwso'one' rif na' bchoɉ Zequerian' par bzeye' yalən' ḻo'o yo'oda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Na' žlac bzeye' yalən' gwnitə' yoguə'əḻoḻ beṉə' zan ca' chyo'olə gwso'one' orasyonṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Na' to angl c̱he X̱ancho Diozən' bloe' laogüe' Zequerian', na' gwzecha anglən' cuit mesən' ḻichalə gan' chəsə'əzeye' yalən'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Catə' ble'i Zequerian' anglən' benit bec̱hoḻ goc ḻo'o yic̱hɉla'aždaogüe'enə' na' bžebchgüe'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero anglən' gože' ḻe': ―Bito žebo' Zequeria. Diozən' babzenague' orasyon c̱hio'onə', na' no'ol c̱hio' C̱habetən' sane' to xi'iṉo', na' əgwsi'o le' Juan. ");
INSERT INTO zavNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Na' so' mbalaz na' yebeido', na' ḻeczə beṉə' zan yesyə'əbeine' šə bagolɉe', ");
INSERT INTO zavNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","c̱hedə' gaque' beṉə' blao lao Diozən'. Bito ye'eɉe' bino ni biquə'əchlə de'en chesə'əzože beṉə', na' catə' galɉe' yo'o Spirit c̱he Diozən' ḻo'o yic̱hɉla'aždaogüe'enə' par ṉabi'an ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Na' gone' par nic̱h zan beṉə' Izrael gwlaž c̱he' ca' yesə'əša' yic̱hɉla'ažda'oga'aque'enə' na' so'elaogüe'e Diozən' can' cheyaḻə' so'elaogüe'ene', Dioz ben' naquə X̱anga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Na' cuialaogüe' lao X̱anchon' na' gone' par nic̱h beṉə' ca' cui nitə' binḻo len xi'iṉga'aque' yesyə'ənite'e binḻo len xi'iṉga'aque' de'e yoblə. Na' gone' par nic̱h beṉə' godenag ca' yesə'əzenague' c̱he Diozən'. Gone' ca' par nic̱h yesə'ənitə' beṉə' probnid par əso'elaogüe'e X̱anchon' catə'ən yide'. Na' len xbab de'en yo'o yic̱hɉla'aždaogüe'enə' na' len dižə' balə de'en güe'enə' gaque' ca profet Ḻiazən' ben' gwzo cana'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nach Zequerian' gože' anglən': ―¿Nacxa gaquə əṉezda' de'e nga? Nada' bac̱h naca' beṉə' golə na' no'ol c̱hia'anə' ḻeczə beṉə' golə. ");
INSERT INTO zavNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nach anglən' gože' ḻe': ―Nada' naca' angl Gabryel. Zoa' len Diozən' na' zoa' cho'elaogua'ane'. Na' bseḻe'e nada' zedetix̱ɉue'ida' le' dižə' güen dižə' cobə quinga. ");
INSERT INTO zavNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Na' le' gaco' mod, cui gaquə əṉio' xte que catə'əch əžin ža gaquə de'e nga, c̱hedə' cui cheɉḻi'o xtiža'anə'. Na' de'e ḻiczə gwžin ža gaquə complir can' gwnia'anə'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na' beṉə' ca' ža' chyo'olə gosə'əbeze' Zequerian', nach besyə'əbanene' c̱hedə' gwžeine' ḻo'o yo'odao' əblao gan' chso'elao' beṉə' Izrael ca' Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Catə' bechoɉ Zequerian', bene' señy len ne'enə' la' bitoch goquə əṉe'. Bac̱h naque' beṉə' mod. Nach gwsa'acbe'i beṉə' ca' de que ble'ida'ogüe'ene' ḻo'o yo'oda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Na' catə' bde laze'en de'en bene' žin ḻo'o yo'odao' əblaonə' beyeɉe' liže'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Gwde na', no'ol c̱he' C̱habetən' bgüendao' bda'onə' ḻo'o ḻe'enə' na' gueyə' bio' gwzoze'. Na' gwne': ");
INSERT INTO zavNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","―Güenchgua baben X̱ana' Diozən' len nada', c̱hedə' babžin ža nži'ilaže'e nda', chone' par nic̱h bitoch so'on beṉac̱hən' xbab c̱hia' de que cui bi zaca'a. ");
INSERT INTO zavNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Goc x̱op bio' noa' C̱habetən' bda'onə', Diozən' bozseḻe'e anglən' ben' le Gabryel, gwyeɉe' to syoda de'en nzi' Nasaret gan' mbane Galilean'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Bseḻe'ene' gan' zo to no'ol güego' le' Maria. Na' Marian' ṉe'e naplažə'əchgua cuine'. Na' to beṉə' le Jwse bac̱h naquən gwšagna'alene' par gaque' xo'ole'. Na' Jwsen' naque' dia c̱he de'e Rei Dabin'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Na' bžin anglən' gwyo'e gan' zo Marian' na' gože'ene': ―Dioxei. X̱ancho Diozən' nži'ilaže'e le' na' zoe' len le'. Na' gone' par nic̱h socho' mbalaz ca yoguə'əḻoḻ no'ol ca' yeḻa'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Catə' ble'i Marian' anglən', benit bec̱hoḻ goc ḻo'o yic̱hɉla'aždaogüe'enə' por ni c̱he dižə' de'en gože' ḻe'. Na' bene' xbab bi zeɉen de'en bguape' ḻe' dioxən' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nach anglən' gože'ene': ―Bito žebo' Maria. Diozən' nži'ilaže'e le'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Na' le' gua' xi'iṉo', to bi'i byo dao', na' sano'obo', na' əgwsi'o labo' Jeso'os. ");
INSERT INTO zavNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Na' Jeso'osən' gaque' to beṉə' blao na' beṉac̱hən' yesə'əsi'ene' Xi'iṉ Dioz, Dioz ben' naquə ḻe'ezelaogüe beṉə' blao. Na' X̱ancho Diozən' gone' par nic̱h ṉabi'e ṉasyon Izraelən' can' gwnabia' de'e x̱axta'ogüe'e Rei Dabin'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Na' ḻe' ṉabi'e ṉasyon Izraelən' zeɉḻicaṉe. Na' cuat te yeḻə' gwnabia' c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nach gož Marian' anglən': ―¿Nacxa gaquə sana' bdao'? la' bitoṉə' žaga' nda' beṉə' byo. ");
INSERT INTO zavNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nach gož anglən' ḻe': ―Spirit c̱he Diozən' yidən gan' zo'onə', na' yeḻə' guac c̱he Diozən' son len le', Dioz ben' naquə ḻe'ezelaogüe beṉə' blao. De'e na'anə' bi'i la'aždao' xi'ilažə'ən galɉənə', yoso'osi'ebo' Xi'iṉ Dioz. ");
INSERT INTO zavNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na' beṉə' xna'o C̱habetən' ḻeczə bac̱h bgüenda'obo' ḻo'o ḻe'enə' ḻa'aṉə'əczə banaque' beṉə' golə. Bagoc x̱op bio' no'e to bi'i byo dao', len la' gosə'əne' c̱he' de que no'olə güižən'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bito bi bi de de'e əṉacho cui chac gon Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nach gož Marian' anglən': ―Nga zoa' naca' xmose', gaquə c̱hia' con bi na X̱ana'an. Nach beza' anglən' gan' zo Marian'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Gwde na' ḻe'e gwyeɉte Marian' to syoda de'e žia lao ya'a gan' mbane Jodean'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Na' bžine' liž Zequerian', gwyo'e bguape' C̱habetən' diox. ");
INSERT INTO zavNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Na' goquən' catə' C̱habetən' benene' choḻgüiž Marian' ḻe' nach gocbe'iteine' chxitə' chžia chac bdao' c̱he'enə' ḻo'o ḻe'enə'. Na' Spirit c̱he Diozən' gwnabi'an yic̱hɉla'aždao' C̱habetən'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Na' gwṉe' zižɉo tant bebeine', na' gože' Marian': ―Diozən' babene' par nic̱h zocho' mbalaz ca yoguə'əḻoḻ no'ol ca' yeḻa'. Na' Diozən' gone' par nic̱h gaquə mbalaz c̱he bdao' c̱hio'onə' no'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nactecxan' le' naco' xna' X̱ana'an zedəlaṉo'o nada'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mer catə' bene naga'anə' chguapo' nada' dioxən', bdao' c̱hia'anə' bebeibo' na' bxitə' bžiabo' ḻo'o ḻi'anə'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","X̱ancho Diozən' bene' par nic̱h anglən' gwne' le' de'en ze'e gaquə na' zo' mbalaz de'en gwyeɉḻi'o de que gaquə complir can' gwne'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nach Marian' gwne': ―Cho'elaogua'a X̱ana' Diozən' do yic̱hɉ do laža'a. ");
INSERT INTO zavNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Na' ḻo'o yic̱hɉla'aždaogua'an chebeichgüeida' Dioz ben' chebeɉ nada' xni'a de'e malən'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Babeyašə' beži'ilaže'e nada' naca' xmose' ḻa'aṉə'əczə cui bi zaca'a. Na' dezd ṉa'a žtia žtia beṉac̱hən' yesə'əne' de que zoa' mbalaz. ");
INSERT INTO zavNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Diozən' chac gone' de'e cui no zaquə gon, na' babene' de'e güen juisy len nada'. Ḻe'enə' naque' beṉə' la'aždao' xi'ilažə' juisy. ");
INSERT INTO zavNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Na' notə'ətezə beṉə' chsa'ape'ene' respet do yic̱hɉ do lažə'əga'aque', Diozən' cheyašə' cheži'ilaže'e ḻega'aque' na' len xi'iṉ dia c̱hega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Bac̱h blo'i Diozən' beṉac̱hən' yeḻə' guac c̱he'enə', na' babene' par nic̱h beṉə' ya'alažə' ca' baboso'ozex̱ɉw yic̱hɉga'aque'enə' laogüe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Babene' par nic̱h beṉə' gwnabia' ca' cuich gosə'ənabi'e, na' beṉə' ca' cui gwsa'ac beṉə' blao, Diozən' bcuie' ḻega'aque' par gwsa'aque' beṉə' blao. ");
INSERT INTO zavNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Na' beṉə' ca' gwsa'acbe'ine' de que chesə'əyažɉene' yeḻə' chaclen c̱he Diozən', bagoclene' ḻega'aque'. Na' beṉə' ca' gwsa'aquene' bitobi chesə'əyažɉene', bose'e ḻega'aque' sin cui bi bnežɉue' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nach bagocwlene' chio'o beṉə' Izrael naccho ca xmose'. Bablo'ine' chio'o de que bito ganḻaže'e par yeyašə' yeži'ilaže'e chio'o can' bene' lyebe. ");
INSERT INTO zavNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Na' de'en beyašə' beži'ilaže'e de'e Abraanṉə' len xi'iṉ dia c̱he', bene' complir can' gože' ḻe' len yebaḻə x̱axta'ocho ca'. Na' zocze' yeyašə' yeži'ilaže'e xi'iṉ dia c̱he de'e Abraanṉə' zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Na' catə' bagoc šoṉ bio' bega'aṉ Marian' len C̱habetən' nach beyeɉe' liže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na' catə' bžin or par san C̱habetən', gwxane' bi'i byo dao' c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Na' catə' gwse'ene beṉə' gwliž c̱hega'aque'enə' na' famiḻy c̱hega'aque'enə' de que Diozən' babeyašə' beži'ilaže'e C̱habetən', besyə'əbeichgüeine' len ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Na' ža x̱on' beṉə' ca' ɉəsə'əzo'ebo' señy de'en ne' sirconsision. Na' zeɉen de que chse'eɉḻe'e c̱he lyebe de'en ben Diozən' len de'e Abraanṉə'. Na' gwse'enene' si' labo' Zequeria can' le x̱abo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero xna'abo'onə' gwne': ―Nca, cheyaḻə' si' labon' Juan. ");
INSERT INTO zavNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nach ḻega'aque' gwse'e ḻe': ―Notono famiḻy c̱hele nitə' beṉə' zɉəle ca' na' nic x̱axta'ole. ");
INSERT INTO zavNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nach gwso'one' señy gosə'əṉabene' x̱abo'onə' nac chene'ene' si' la bda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nach bene' señy gwṉabe' to yag la' dao' gan' bzoɉe': “Si' labo' Juan.” Nach yogue'e besyə'əbanene'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ḻe'e gocte beṉe Zequerian' na' ḻe'e gwzolaote be'e dižə' be'elaogüe'e Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Na' besə'əžebchgua beṉə' gwliž c̱hega'aque'enə'. Na' xtižə'əga'aque'enə' gosə' gwlalɉən doxen yež ca' zɉəchi' lao ya'a ca' gan' mbane Jodean'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Na' yoguə'əḻoḻ beṉə' gwse'enene' dižə'ənə' gwso'one' xbab ḻo'o yic̱hɉla'ažda'oga'aque'enə' c̱he de'e ca', na' gosə'əne': ―¿Bixa gon bdao' na'anə'? Gosə'əne' ca' c̱hedə' gosə'əṉezene' de que zoczə Diozən' len ḻebo'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nach gwnabia' Spirit c̱he Diozən' yic̱hɉla'aždao' x̱abo' Zequerian'. Na' Zequerian' be'e xtižə' Diozən' gwne': ");
INSERT INTO zavNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Cho'elaogua'a X̱anchon' ben' naquə Dioz c̱he chio'o beṉə' Izrael. Cheyaše'ene' chio'o naccho ṉasyon' c̱he' na' babene' par nic̱h gaquə yechoɉcho xni'a de'e malən'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","La' babene' par nic̱h zo to beṉə' napə yeḻə' guac par yebeɉe' chio'o xni'a de'e malən', na' za' be'enə' lao dia c̱he de'e Rei Dabin' ben' goquə xmos Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Chac can' gwna Diozən' len cho'a de'e profet ca' beṉə' ca' gwleɉe' par gwsa'aque' lažə' ne'enə' cana'ate. ");
INSERT INTO zavNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Gwne' de que yosle' chio'o lao na' beṉə' contr c̱hecho ca' na' lao na' yoguə' beṉə' chəsə'əgue'i chio'o. ");
INSERT INTO zavNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Na' ḻeczə gože' de'e x̱axta'ocho ca' de que yeyašə' yeži'ilaže'e ḻega'aque' len xi'iṉ dia c̱hega'aque'. Na' can' chone' ṉa'a, chone' par nic̱h chac complir ca naquə de'en bene' lyebe gone' par gaquəlene' chio'o. ");
INSERT INTO zavNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ben Diozən' cuine' testigw lao de'e x̱axta'ocho Abraanṉə' de que gaquəczə can' bene' lyeben'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Na' gwne' de que yosle' chio'o lao na' beṉə' contr ca' par nic̱h ca' gaquə güe'ela'ochone' sin cui žebcho. ");
INSERT INTO zavNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Na' gwne' gone' par nic̱h gaquə la'ažda'ochon' xi'ilažə' par len ḻe'enə' na' gone' par nic̱h šeɉcho ḻicha güe'ela'ochone' doxen yeḻə' mban c̱hechon'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nach Zequerian' gože' bida'onə': Na' le' xi'iṉa', beṉac̱hən' yesə'əne' c̱hio' de que naco' profet beṉə' choe' xtižə' Diozən', Dioz ben' naquə ḻe'ezelaogüe beṉə' blao. Yesə'əne' ca' c̱hedə' le' cuialaogo' lao X̱anchon' na' go'o xtiže'enə' par nic̱h ṉitə' beṉə' probnid par əso'elaogüe'ene' catə'ən yide'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Egwsed əgwlo'ido' neto' can' chene'e Diozən' yebeɉe' chio'o xni'a de'e malən' na' can' chene'ene' yezi'ixene' xtoḻə'əcho ca', chio'o naccho beṉə' ṉasyon c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Diozən' cheyašə' cheži'ilaže'e chio'o na' bachseḻe'e to beṉə' gaquəlene' chio'o. Na' gwxaquə'əlebe be'enə' ca be'eni' c̱he bgüižən'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ḻe' gwzeɉni'ine' chio'o beṉac̱h naquən' goncho par nic̱h žɉəyezocho gan' zo Diozən' catə' gatcho, na' əgwzeɉni'ine' chio'o beṉac̱h naquən' so cuezcho binḻo. Can' gone' cue'e be'eni' ḻo'o yic̱hɉla'aždao' chio'o gwxaquə'əlebecho ca beṉə' chsa'aš ḻo'o de'e žc̱hoḻən'. ");
INSERT INTO zavNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Na' Juanṉə' ca bcua' chcha'ogüe', zdate chaquəch yic̱hɉla'aždaogüe'en can' chene'e Diozən'. Na' Juanṉə' ɉsoe' latɉə dašən'. Na' nan' ṉezoe' catə'ən bžin ža gwzolaogüe' gwdix̱ɉui'e xtižə' Diozən' len beṉə' Izrael ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Na' gwde de'e ca', na' ca tyempən' catə'ən gwnabia' Sesar Augosto, bene' mendad te cuent na' əsa'aḻə' yiš baḻə beṉə' ža' to to yež de'e zɉəchi' doxen ganə' chnabi'e. ");
INSERT INTO zavNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Na' bguaḻe'e yišən' lao chnabia' Sirenio gan' nzi' Siria. Na' naquən de'e nech de'en bguaḻe'e yiš baḻə beṉə' ža' to to yež. ");
INSERT INTO zavNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nach yoguə'əḻoḻ beṉə' ɉəya'aque' lažga'aque' ɉəsyə'əde cuinga'aque' cuent par gwsa'aḻə'əga'aque' yiš. ");
INSERT INTO zavNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nach Jwsen' naque' dia c̱he de'e Rei Dabin'. Na' beze'e Nasaret gan' mbane Galilean' par beyeɉe' syoda c̱he de'e Rei Dabin' de'e nzi' Belen. Na' chi' syoda Belenṉə' gan' mbane Jodean'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Beyeɉe' ɉəyede cuine' cuent na' zenc̱he'e no'ol c̱he' Marian', pero bitoṉə' yesə'əca'a lɉuežɉe'. Na' Marian' bano'e bda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Na' goquən' lao nite'e Belenṉə' bžin or par sane'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Na' bi'i nechən' gwxane' golɉbo' bi'i byo dao', na' blaže'ebo' lachə'. Na' gwlo'ebo' to ḻo'i gan' chsa'o bia yix̱ə', c̱hedə' bito bi latɉə gwyo'och mesonṉə' par ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na' lao že' na', ḻe'e yix̱ə' c̱he Belen na'atezəczə ža' beṉə' goye xilə' ṉechəsə'əṉe'e chsa'ape' xilə' c̱hega'aque' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Na' angl c̱he X̱anchon' bžine' gan' nitə' beṉə' goye xilə' ca', na' yeḻə' chey che'eni' c̱he Diozən' gwyec̱hɉən bse'eni'in gan' nite'enə'. Na' besə'əžebchgüe'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Na' gož anglən' ḻega'aque': ―Bito žeble, ṉa'a c̱hix̱ɉo'ida' le'e to dižə' güen de'e yeba yezaquə'əlažə'əchgua yoguə'əḻoḻ beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lao' syoda c̱he de'e Rei Dabin' bagolɉə ṉa'a ben' chac yebeɉ beṉə' xni'a de'e malən'. Naque' Cristən' ben' bseḻə' Diozən' par gaquəlene' beṉac̱hən' na' naque' X̱anchon'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Par yeželele bda'onə' quinga naquə: Žɉəyedi'ilebo' lažə'əbo' lachə' na' debo' ḻo'i gan' chsa'o bia yix̱ə'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Beyož gwna anglən' ca' ḻe'e besə'əžinte angl zanch gan' zo angl nechən', za'aque' gan' zo Diozən'. Na' chso'elaogüe'e ḻe', chəsə'əne': ");
INSERT INTO zavNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ḻedoye'ela'och Diozən' ben' zo yoban'. Na' lao yežlyon' gatə' yeḻə' so cuezə binḻo entr beṉə' ca' chebei Diozən' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Na' catə' besyə'əsa'ac angl ca' zɉəya'aque' yoban', nach beṉə' goye xilə' ca' gwse' lɉuežɉga'aque': ―Yeyeɉcho Belenṉə' žɉəyegüiacho de'en bagoc, ca naquə X̱anchon' bseḻe'e angl quinga bedəsə'ədix̱ɉue'ine' chio'o. ");
INSERT INTO zavNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nach besa'acses beṉə' goye xilə' ca' ɉəya'aque' Belenṉə', na' ɉəsyə'ədi'e Marian' len Jwsen' na' len bda'onə'. Na' bda'onə' debo' ḻo'i gan' chsa'o bia yix̱ə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Beyož besə'əle'ine' can' bagoquən', na' gwso'e dižə' c̱he bda'onə' len yeziquə'əchlə beṉə' ca naquə de'en gwse' angl ca' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Na' yoguə'əḻoḻ beṉə' ca' əgwse'ene dižə' de'en gwsoe' beṉə' goye xilə' ca' besyə'əbanene'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Na' Marian' ḻeczə gwlo'o yic̱hɉe' yoguə'əḻoḻ dižə' de'en gwsoe' beṉə' goye xilə' ca' na' bene' xbab ḻo'o yic̱hɉla'aždaogüe'en bi zeɉenṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nach besyə'əsa'ac beṉə' goye xilə' ca' chso'elaogüe'e Diozən' na' chso'e ḻe' yeḻə' bala'aṉ c̱he yoguə'əḻoḻ de'en bagwse'enene' na' babesə'əle'ine' ca naquə de'en gož anglən' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Catə' gwde x̱on' ža na' ɉəsə'əzo'ebo' señy de'en ne' sirconsision na' bosə'əsi'e labo' Jeso'os, can' ben anglən' mendad catə' ze'e gua'alə Marian' ḻebo'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Catə' gwde tyempən' babeyac Marian' xi'ilažə' len bda'onə' segon can' na ḻein' de'en bzoɉ de'e Moisezən', nach gosə'əlene'ebo' Jerosalenṉə' par ɉso'ebo' lao Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Gwso'one' ca' c̱hedə' nyoɉən ḻe'e ḻein': “Yoguə' bi'i byo dao' bi'i nech cheyaḻə' gacbo' lao na' Diozən', na' yoguə' bia yix̱ə' bia maš dao' bia nech ḻeczə gaquəb lao na' Diozən'.” ");
INSERT INTO zavNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Na' gwso'elaogüe'e Diozən' gwso'one' can' na ḻei c̱he X̱ancho Diozən', nyoɉən: “Cheyaḻə' gotle to csad ngolbexə o c̱hopə plomxtil.” ");
INSERT INTO zavNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Na' Jerosalenṉə' gwzo to beṉə' byo le Simeon. Be'enan' gwyecze' bene' de'e güen lao Diozən' na' be'elaogüe'ene', na' gwleze' batə'əquən' yidə Cristən' ben' gwleɉ X̱ancho Diozən' par gaquəlene' beṉac̱hən'. Na' Spirit c̱he Diozən' gwzon ḻo'o yic̱hɉla'aždao' Simeonṉə'. Na' bzene Spiritən' ḻe' de que antslə ze'e gate' le'ine' Cristən'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na' Spiritən' benən par nic̱h gwyeɉe' yo'odao' əblaonə'. Na' zoe' yo'oda'onə' catə' besə'əžin x̱axna' Jeso'osən' zɉənḻene'ebo' par nic̱h so'one' len ḻebo' can' na ḻein'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nach Simeonṉə' gwḻene'ebo', nach be'elaogüe'e Diozən' gože'ene': ");
INSERT INTO zavNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ṉa'a ža X̱ana' Dioz, bac̱h goc can' gwna'onə'. Be' latɉə yeyeda' binḻo gan' zo'onə', nada' naca' beṉə' güen žin c̱hio', ");
INSERT INTO zavNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","c̱hedə' bable'ida' ben' zedəyeleɉ neto' xni'a de'e malən'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Naque' ben' bžio' bia' əgwseḻo'o par yoguə'əḻoḻ beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Na' cue'e be'eni' ḻo'o yic̱hɉla'aždao' beṉə' cui zɉənaquə beṉə' Izrael par nic̱h se'eɉni'ine' xtižo'onə'. Na' ḻeczə gone' par nic̱h beṉə' Izrael ca' yesə'əzi'e yeḻə' bala'aṉ. ");
INSERT INTO zavNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nach x̱abo'on len xna'abo'on besyə'əbanene' ca naquə dižə' de'en be' Simeonṉə' c̱hebo'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Na' Simeonṉə' gwṉabene' Diozən' gone' par nic̱h gaquə güen c̱hega'aque', na' gože' Marian': ―Beṉə' zan beṉə' Izrael ca' yesə'əbiayi'e c̱hedə' cui so'onḻilaže'e xi'iṉo' nga, na' zane' yesə'əzi'e yeḻə' mban zeɉḻicaṉe c̱hedə' so'onḻilaže'ene', na' beṉə' zan yoso'ožia yoso'onite'ene' catə' yesəṉezene' c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Na' gone' par nic̱h gacbia' non' əgwzenag c̱he Diozən' na' non' cui. Na' caczə ga chaz to cwšiy gaquə ḻo'o yic̱hɉla'aždaogo'onə' tant əžaglaogo' de'en gac c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Na' ḻeczə gwzo to no'olə gwle Añy yo'odao' əblaonə', na' no'olən' cho'e xtižə' Diozən'. Naque' xi'iṉ de'e Fanuel, na' naque' dia c̱he de'e Aser. Bšagne'e catə'ən naque' no'ol güego', pero na' gaž izga bguan be'en c̱he'enə'. Na' Añyən' banaque' to beṉə' golə. ");
INSERT INTO zavNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Bagoc taplalɉ tap iz got be'en c̱he'enə'. Cuiczə chebiže'e yo'odao' əblaonə'. Ḻechguaḻe cho'elaogüe'e Diozən' do ža do yel, xte gwyaz tgüeɉə cui gwdaogüe' par nic̱h benche' orasyon lao Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na' goquən' bgüiguə' Añyən' gan' nitə' Jwsen' len Marian', na' be'e yeḻə' chox̱cwlen c̱he Diozən' de'en bac̱h bseḻe'e ben' gaquəlen ṉasyon Izraelən'. Na' be'e dižə' c̱he Jeso'osən' len yoguə'əḻoḻ beṉə' ca' ža' Jerosalenṉə' beṉə' chesə'əbeze' batə'əquən' əseḻə' Diozən' ben' gaquəlene' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nach Jwsen' na' Marian' catə' beyož gwso'one' yoguə'əḻoḻ de'en non ḻei c̱he Diozən' mendad so'one', ɉəya'aque' lažga'aque' Nasaret gan' mbane Galilean'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na' Jeso'osən' zda chcha'ogüe' na' zda chdipe'. Na' ca bcua' chcha'ogüe'enə' zdach cheɉni'ichene', na' nži'ilažə' Diozən' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Na' x̱axne'e ca' yoguə' iz chɉa'aque' lṉi pascw de'en chaḻə' Jerosalenṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Šižiṉ ize Jeso'osən' catə' gosə'əc̱he' x̱axne'e ca' ḻe' ɉa'aque' Jerosalenṉə'. Segon ca costombr c̱he beṉə' Izrael ca' chɉa'aque' catə' chaḻə' lṉin'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Na' catə' gwde lṉinə' x̱axne'e ca' besa'aque', pero Jeso'osən' bega'aṉe' Jerosalenṉə'. Na' xne'enə' len Jwsen' bito gwsa'acbe'ine', ");
INSERT INTO zavNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","con gwso'one' xbab šə bazɉəyede' len beṉə' ca' nžagga'aque' txenṉə'. Na' tža nez babesa'ac x̱axne'e ca' gwzolao chəsyə'əyilɉe'ene' entr famiḻy na' migw c̱hega'aque' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pero bito besyə'əželene' ḻe', nach besyə'əbi'e ɉəya'aque' Jerosalenṉə' de'e yoblə par žɉəsyə'ədilɉe'ene'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Na' goquən' beyoṉ žach besyə'əželene' Jeso'osən' ḻo'o yo'odao' əblaonə', chi'e gwchoḻ beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən'. Jeso'osən' chzenague' xtižə'əga'aque'enə' na' de'e zan chṉabene' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Na' yoguə'əḻoḻ beṉə' ca' choso'ozenag xtiže'enə' chəsyə'əbanene' c̱he yeḻə' cheɉni'i c̱he'enə' na' can' choži'e xtižə' beṉə' ca' choso'osed choso'olo'i ḻein'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Na' catə' besə'əle'i x̱axne'en ḻe' besyə'əbanene', na' gož xne'en ḻe': ―Xi'iṉdaogua'a, ¿bixc̱hen' chondo' neto' ca'? X̱ao' nga na' nada' bagwdato' beyilɉto' le' na' de'e juisy de'e chaqueto'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nach Jeso'osən' gože' ḻega'aque': ―¿Bixc̱hen' cheyilɉle nada'? ¿Ecui ṉezele de que cheyaḻə' gona' de'en na X̱a'anə' gona'anə'? ");
INSERT INTO zavNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero x̱axne'e ca' bito gwse'eɉni'ine' bi zeɉe de'en gože' ḻega'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Na' beyeɉe' Nasaretən' len x̱axne'e ca', bzenague' c̱hega'aque'. Na' gwlo'o yic̱hɉ xne'enə' yoguə'əḻoḻ de'en goquən'. ");
INSERT INTO zavNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Na' ca naquə zda gwyeɉni'iche Jeso'osən' na' zda gwcha'oche', na' Diozən' zda bebeichene' ḻe' na' ḻeczə ca' beṉac̱hən' zdach besyə'əbeichene' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Catə' goc šino' iz chnabia' Sesar Tiberion', goc Ponsio Pilatən' goberṉador c̱he Jodean'. Na' goc Erodən' goberṉador c̱he Galilean', na' goc beṉə' biše'e Lipən' goberṉador c̱he Itorea na' c̱he Traconite. Na' goc Lisanias goberṉador c̱he Abilinia. ");
INSERT INTO zavNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Nach Anas na' Caifas gwsa'aquəche' bx̱oz əblao c̱he beṉə' Izrael ca'. Iz na' xi'iṉ Zequerian', ben' gwle Juan, gwzoe' latɉə dašən' na' Diozən' be'elene' ḻe' dižə'. ");
INSERT INTO zavNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nach Juanṉə' gwyeɉe' yoguə'əḻoḻ yež de'e zɉənyec̱hɉ zɉəmbi'i yao Jordanṉə', ɉətix̱ɉue'ine' yoguə' beṉə' de que cheyaḻə' yesyə'ədiṉɉene' xtoḻə'əga'aque'enə' na' yesə'əṉabene' Diozən' əgwṉitlaogüe'en, na' yesə'əchoe' nis. ");
INSERT INTO zavNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Juanṉə' bene' can' bzoɉ de'e profet Isaiazən' ben' be' xtižə' Diozən' cana'. Quinga nan: To beṉə' əṉe' zižɉo latɉə dašən', əṉe': “Ḻe'e so probnid par əgwzenagle c̱he X̱anchon' catə'ən yide'. Na' šə sole probnid par əgwzenagle c̱he' catə'ən yide', de'en gonḻe ca' gwxaquə'əleben can' chonḻe chxi' chloale nez ca' catə' chidə to beṉə' blao. ");
INSERT INTO zavNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ḻe'e yoša' yic̱hɉla'ažda'olen' par nic̱h gaquən ca to nez güen gan' baboso'ochix̱e' ya'a yao ca' par beyaquən to leḻi. Na' gaquən ca to nez gan' baboso'oxi' baboso'oloe', na' bagosə'əc̱hogue' xiše'en par beyaquən ḻicha. ");
INSERT INTO zavNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na' gwžin ža catə' yoguə'əḻoḻ beṉə' yesə'əle'ine' ben' seḻə' Diozən' par yebeɉe' beṉə' xni'a de'e malən'.” ");
INSERT INTO zavNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Na' beṉə' zan ɉa'aque' gan' gwzo Juanṉə' par nic̱h bc̱hoe' ḻega'aque' nisən'. Na' Juanṉə' gože' ḻega'aque': ―Le'e nacle beṉə' gox̱oayag na' nalɉele. ¿Echaquele de que guaquə yexoṉɉele castigon' de'en əseḻə' Diozən' par le'e? ");
INSERT INTO zavNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Cheyaḻə' gonḻe de'en naquə güen par nic̱h sa'acbe'i beṉə' yoblə de que baboša' yic̱hɉla'ažda'olen'. Na' bito gonḻe xbab de que Diozən' cui gone' le'e castigw c̱he xtoḻə'əlen' laogüe de'en nacle xi'iṉ dia c̱he de'e Abraanṉə'. Bito ṉacho de que ḻechguaḻe chyažɉe Diozən' le'e. Guaquə gone' par nic̱h yeɉ quinga yesyə'əyaquən xi'iṉ dia c̱he de'e Abraanṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ca naquə le'e šə cui chonḻe can' chazlažə' Diozən', gwxaquə'əlebele ca to yag frot de'e cui bi frot chbian'. Na' ca naquə yoguə'əte yag frot de'e cui bi frot choṉ, chəsə'əc̱hog beṉə' ḻen na' chəsə'əzeye'en. ");
INSERT INTO zavNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nach beṉə' ca' chəsə'əzenag xtiže'enə' gosə'əṉabene' Juanṉə' gwse'ene': ―¿Bi ca de'e cheyaḻə' gonto'? ");
INSERT INTO zavNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nach gože' ḻega'aque': ―Ben' napə c̱hopə xadoṉ, cheyaḻə' əgwnežɉue' ton c̱he beṉə' cui bi bi de c̱he'. Na' ḻeczə ca' ben' de de'e gaogüe', cheyaḻə' əgwnežɉue' c̱he beṉə' cui bi bi de de'e gaogüe'. ");
INSERT INTO zavNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Na' catə' beṉə' goc̱hixɉw ca' ḻeczə ɉəsə'əbigue'e par gwc̱hoa Juanṉə' ḻega'aque' nis na' gwse'ene': ―Maestr; ¿bi ca de'e cheyaḻə'əch gonto'? ");
INSERT INTO zavNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Na' gože' ḻega'aque': ―Bito əgwc̱hixɉwle de mazəchlə ca de'en cheyaḻə' əgwc̱hixɉwle. ");
INSERT INTO zavNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Na' beṉə' ca' zɉənaque' soḻdad ḻeczə gosə'əṉabene' ḻe' gwse'ene': ―¿C̱hexa neto' ža? ¿Bi ca de'e cheyaḻə'əch gonto'? Nach Juanṉə' gože' ḻega'aque': ―Bitoch əca'ale ḻa fuers de'en de c̱he beṉə', na' nic gacle testigw faḻs contr beṉə' yoblə par əca'ale xmechga'aque'. Ḻe'e gon banez len laxɉwlen'. ");
INSERT INTO zavNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na' beṉə' Izrael ca' gwnitə' lez yidə Cristən' ben' gwleɉ Diozən' par gaquəlene' ṉasyon c̱hega'aque'enə', gwsa'aquene' ḻo'o yic̱hɉla'až daoga'aque' šə Juanṉə' naque' be'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Na' Juanṉə' gocbe'ine' xbab c̱hega'aque'enə' na' gože' yoguə'əga'aque': ―Nada' de'e ḻi chc̱hoacza' beṉə' nis, pero na' ze'e yidə ben' gone' par nic̱h so Spirit c̱he Diozən' ḻo'o yic̱hɉla'ažda'ochon' na' ṉabi'an chio'o. Na' Spiritən' naquən ca yi' na' gwxi' gwloan yic̱hɉla'ažda'ochon'. Ben' yidə zaquə'əche' ca nada' na' bito zaca'a par gaca' xmose'. ");
INSERT INTO zavNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Be'enan' gone' len chio'o can' choncho catə' chdecho trigon' rṉer na' chzeycho yix bebən'. Na' šə chonḻilažə'əchone' yotobe' chio'o par nic̱h socho txen len ḻe', na' beṉə' ca' cui chso'onḻilažə' ḻe' əseḻe'e ḻega'aque' lao yi' gabiḻən' de'en cuiczə cheyol. ");
INSERT INTO zavNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Na' de'e zanch de'e gwna Juanṉə' gwdix̱ɉue'ine' ḻega'aque' dižə' güen dižə' cobən' na' gwṉeyoine' ḻega'aque' se'eɉḻe'en. ");
INSERT INTO zavNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nach Juanṉə' be'e dižə' c̱he goberṉador Erodən' ca naquə de'e mal de'en babene'enə' beque'e Erodiasən' ca xo'ole'. La' Erodiasən' naque' xo'olə Lip beṉə' bišə' Erodən'. Na' ḻeczə be'e Juanṉə' dižə' ca naquə yoguə' de'e malən' babene'. ");
INSERT INTO zavNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Na' catə' Erodən' benene' can' choe' Juanṉə' xtiže'enə' na' bene' yeto' de'e mal, gwlo'e Juanṉə' ližya. ");
INSERT INTO zavNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Na' žlac ṉe'e chc̱hoa Juanṉə' beṉə' nis, beṉə' zan ɉa'ac laogüe'enə' par bc̱hoe' ḻega'aque' nisən' na' len Jeso'osən' gwchoe' nisən'. Na' lao orən' Jeso'osən' bene' orasyon na' ḻe'e byalɉwte yoban' na' ble'ine' gan' zo Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Na' betɉ Spirit c̱he Diozən' bžinən gwzon len ḻe' na' ca orən' naquən ca to ngolbexə. Na' gož Diozən' Jeso'osən': ―Le' naco' Xi'iṉa', na' chacchgüeida' c̱hio'. Cheba chezaquə'əlažə'əchgua' le'. ");
INSERT INTO zavNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Na' ca do šichoa ize Jeso'osən' catə' gwzolaogüe' bene' yoguə'əḻoḻ de'en zedeyene'. Na' beṉə' ca' gwnitə' na' gwso'one' xbab de que xi'iṉ Jwse na' Jeso'osən'. Na' Jeso'osən' naque' xesoa Eli. ");
INSERT INTO zavNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Na' Elin' naque' xi'iṉ Matat, na' Matatən' naque' xi'iṉ Lebi, na' Lebin' naque' xi'iṉ Melqui, na' Melquin' naque' xi'iṉ Jana, na' Janan' naque' xi'iṉ Jwse. ");
INSERT INTO zavNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Na' Jwsen' naque' xi'iṉ Matatias, na' Matatiasən' naque' xi'iṉ Amos, na' Amosən' naque' xi'iṉ Naom, na' Naonṉə' naque' xi'iṉ Esli. ");
INSERT INTO zavNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Na' Eslin' naque' xi'iṉ Nagai, na' Nagain' naque' xi'iṉ Maat, na' Maatən' naque' xi'iṉ Matatias, na' Matatiasən' naque' xi'iṉ Semei, na' Semein' naque' xi'iṉ Jwse, na' Jwsen' naque' xi'iṉ Joda. ");
INSERT INTO zavNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Na' Jodan' naque' xi'iṉ Joana, na' Joanan' naque' xi'iṉ Resa, na' Resan' naque' xi'iṉ Sorobabel, na' Sorobabelən' naque' xi'iṉ Salatiel. ");
INSERT INTO zavNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Na' Salatielən' naque' xi'iṉ Neri, na' Nerin' naque' xi'iṉ Melqui, na' Melquin' naque' xi'iṉ Adi, na' Adin' naque' xi'iṉ Cosam, na' Cosanṉə' naque' xi'iṉ Elmodam, na' Elmodanṉə' naque' xi'iṉ Er. ");
INSERT INTO zavNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Na' Erən' naque' xi'iṉ Josue, na' Josuen' naque' xi'iṉ Elieser, na' Elieserən' naque' xi'iṉ Jorim, na' Jorinṉə' naque' xi'iṉ Matat. ");
INSERT INTO zavNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Na' Matatən' naque' xi'iṉ Lebi, na' Lebin' naque' xi'iṉ Simeon, na' Simeonṉə' naque' xi'iṉ Joda, na' Jodan' naque' xi'iṉ Jwse, na' Jwsen' naque' xi'iṉ Jonan, na' Jonanṉə' naque' xi'iṉ Eliaquim. ");
INSERT INTO zavNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Na' Eliaquinṉə' naque' xi'iṉ Melea, na' Melean' naque' xi'iṉ Mainan, na' Mainanṉə' naque' xi'iṉ Matata, na' Matatan' naque' xi'iṉ Natan. ");
INSERT INTO zavNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Na' Natanṉə' naque' xi'iṉ Dabi, na' Dabin' naque' xi'iṉ Isai, na' Isain' naque' xi'iṉ Obed, na' Obedən' naque' xi'iṉ Boos, na' Boosən' naque' xi'iṉ Salmon, na' Salmonṉə' naque' xi'iṉ Naason. ");
INSERT INTO zavNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Na' Naasonṉə' naque' xi'iṉ Aminadab, na' Aminadabən' naque' xi'iṉ Aram, na' Aranṉə' naque' xi'iṉ Esrom, na' Esronṉə' naque' xi'iṉ Fares. Na' Faresən' naque' xi'iṉ Joda, ");
INSERT INTO zavNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","na' Jodan' naque' xi'iṉ Jacob, na' Jacobən' naque' xi'iṉ Isaac, na' Isaaquən' naque' xi'iṉ Abraam, na' Abraanṉə' naque' xi'iṉ Tare, na' Taren' naque' xi'iṉ Nacor. ");
INSERT INTO zavNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Na' Nacorən' naque' xi'iṉ Serog, na' Seroguən' naque' xi'iṉ Ragau, na' Ragaun' naque' xi'iṉ Peleg, na' Peleguən' naque' xi'iṉ Eber. ");
INSERT INTO zavNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Na' Eberən' naque' xi'iṉ Sala, na' Salan' naque' xi'iṉ Cainan, na' Cainanṉə' naque' xi'iṉ Arfacsad, na' Arfacsadən' naque' xi'iṉ Sem, na' Senṉə' naque' xi'iṉ Noe, na' Noen' naque' xi'iṉ Lamec. ");
INSERT INTO zavNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Na' Lamequən' naque' xi'iṉ Matosalen, na' Matosalenṉə' naque' xi'iṉ Enoc, na' Enoquən' naque' xi'iṉ Jared, na' Jaredən' naque' xi'iṉ Maalaleel. ");
INSERT INTO zavNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Na' Maalaleelən' naque' xi'iṉ Cainan, na' Cainanṉə' naque' xi'iṉ Enos, na' Enosən' naque' xi'iṉ Set, na' Setən' naque' xi'iṉ Adan, na' Adanṉə' naque' xi'iṉ Dioz. ");
INSERT INTO zavNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Na' Spirit c̱he Diozən' gwnabia'an yic̱hɉla'aždao' Jeso'osən'. Na' Jeso'osən' beze'e cho'a yao Jordanṉə', na' Spiritən' benən par nic̱h gwyeɉe' latɉə dašən'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","C̱hoa ža gwzoe' latɉə dašən', na' lao c̱hoa žan' gwxiye'enə' gwlo'oyeḻə'ən Jeso'osən' gone' de'e malən'. Na' lao de'e c̱hoa žan' bitobi gwdaogüe', na' catə' gwde c̱hoa žan' gwdone'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Na' gož gwxiye'enə' ḻe': ―Šə len' naco' Xi'iṉ Diozən', gož yeɉ nga yeyaquən yetxtil. ");
INSERT INTO zavNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nach gož Jeso'osən' ḻen: ―Nyoɉczə Xtižə' Diozən' nan: “Caguə yeḻə' guao na'azən' əbane chio'o beṉac̱h sino ḻeczə chyažɉecho yoguə'əḻoḻ dižə' de'e na Diozən' par əbancho.” ");
INSERT INTO zavNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Na' gwc̱he' gwxiye'enə' ḻe' to lao ya'a sibə, na' žalṉez blo'in ḻe' yoguə' ṉasyon de'e zɉəchi' lao yežlyon'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nach gožən ḻe': ―Doxen yeḻə' chnabia' de'e de lao yežlyo nga naquən lao na'a. Na' əgwnežɉua'an con no che'enda'. Goṉa' le' yeḻə' chnabia' c̱hia'anə' na' len yoguə' de'en naquə güen na' yoguə' de'e naquə de'e žialao c̱hia' ca naquə chnabia'a ṉasyon ca' de'en zɉəchi' yežlyo nga. ");
INSERT INTO zavNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Šə le' güe'elaogo'o nada' yoguə'əḻoḻ de'e quinga əsa'aquən c̱hio'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nach Jeso'osən' gože' gwxiye'enə': ―Gwchi'ižə' ca'aḻə nga, Satanas. Nyoɉczən ḻe'e Xtižə' Diozən' nan: “Cheyaḻə' šeɉṉi'alažə'əcho X̱ancho Diozən', na' tozə ḻe' güe'ela'ocho.” ");
INSERT INTO zavNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nach gwxiye'enə' gozc̱he'en ḻe' yic̱hɉo'o yo'odao' əblao de'en zo Jerosalenṉə', na' gwlequən ḻe' gan' naquə ḻe'ezelaogüe sibə, na' gožen ḻe': ―Šə len' naco' Xi'iṉ Diozən' bexitə' nga par che'elə, ");
INSERT INTO zavNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","la' nyoɉczən ḻe'e Xtižə' Diozən': Eseḻə' Diozən' angl c̱he' ca' par əsa'aclene' le' na' əsa'ape' le'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Na' ḻeczə ca' nan: Eso'ox̱e'e le' par nic̱h bito əc̱hego'o no yeɉ. ");
INSERT INTO zavNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nach Jeso'osən' gože'en: ―Ḻeczə ca' nyoɉczən ḻe'e Xtižə' Diozən': “Bito con goncho X̱ancho Diozən' prueb šə ḻeine' can' ne'enə'.” ");
INSERT INTO zavNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Beyož gotə'əbia' de que cui gwzoi gwxiye'enə' co'oyeḻə'ən Jeso'osən' gone' de'e malən', bebi'ižə'ən šlož len ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nach Jeso'osən' beyeɉe' Galilean', na' goclen Spirit c̱he Diozən' ḻe' len yeḻə' guac c̱heinə'. Na' yoguə'əḻoḻ beṉə' ža' yež de'en nyec̱hɉ mbi'i Galilean' gwse'enene' c̱he Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nach Jeso'osən' bsed blo'ine' ḻega'aque' ḻo'o yo'odao' c̱hega'aque' ca' na' yoguə'əḻoḻ beṉə' ca' gwso'elaogüe'e Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Na' bežin Jeso'osən' Nasaret gan' gwcha'ogüe', na' ca costombr c̱he' de'e de, gwyo'e yo'oda'onə' ža dezcanzən' na' gwzeche' blabe'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Na' ben' yo'o lao ne'i yo'oda'onə' bnežɉue'ene' rollo gan' nyoɉ de'en bzoɉ de'e profet Isaiazən', ben' be' xtižə' Diozən' cana'. Na' Jeso'osən' bsaše' rollon' na' beželene' partən' gan' nyoɉən: ");
INSERT INTO zavNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Zo Spirit c̱he Diozən' len nada', na' Diozən' gwleɉe' nada' zedegua'a dižə' güen dižə' cobə len beṉə' yašə'. Na' babseḻe'e nada' zedeyena' par nic̱h yesyə'əyaclažə' beṉə' ca' zɉənitə' trist. Na' zedətix̱ɉue'ida' beṉə' ca' nitə' xni'a gwxiye'enə' de que yebeɉa' ḻega'aque' xni'einə'. Na' zedeyena' par yesə'əle'i beṉə' lc̱hoḻ, na' beṉə' chyi' chzaquə', zedeyena' par nic̱h cuich c̱hi' saque'e. ");
INSERT INTO zavNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Na' zedetix̱ɉui'a de que babžin ža bžin or gaquəlen Diozən' beṉac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Na' botobə Jeso'osən' rollon' na' benežɉue'en ben' yo'o lao ne'i yo'oda'onə', na' Jeso'osən' gwchi'e. Nach yoguə' beṉə' ca' nitə' yo'oda'onə' chosə'əgüiachgüe'ene'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Na' gwzolao be'e dižə'ənə', gwne': ―Ža ṉeža bachac can' na Xtižə' Diozən' de'en babenele. ");
INSERT INTO zavNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Na' yoguə' beṉə' ca' gwse'ene dižə' de'en be'enə' besyə'əbanene' catec mba naquə xtižə' Jeso'osən', na' gwso'e dižə' güen c̱he'enə'. Na' gwse' lɉuežɉga'aque': ―¿Ecaguə bengan' xi'iṉ Jwsen'? ");
INSERT INTO zavNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nach gož Jeso'osən' ḻega'aque': ―Šəquə güe'ele nada' can' na dicho c̱helen' de'en na: “Beṉə' güen rmech le', beyon cuino'.” Na' güe'elɉale nada': “De'en babeneto' beno' Capernaum de'e zaquə' yebane beṉə', ḻeczə can' cheyaḻə' gono' lažcho nga.” ");
INSERT INTO zavNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nach goze'e ḻega'aque': ―De'e ḻi chnia' le'e, beṉə' gwlaž c̱he beṉə' güe' xtižə' Diozən' bito chse'eɉḻe'e c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Can' goquə ca tyemp c̱he profet Ḻiazən' bito bi bi yeɉw goquə šoṉ iz yo'o gašɉə, na' goc bgüin juisy c̱hega'aque' doxen gan' zelao mbane Izraelən'. De'e ḻi chnia' le'e, gwnitə' zan no'olə gozebə Izraelən' cana'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero bito bseḻə' Diozən' Ḻiazən' par gaquəlene' ni to ḻega'aque'. Bseḻe'ene' yetolə yež de'en nzi' Sarepta ga mbane Sidon par goclene' to no'olə gozebə. ");
INSERT INTO zavNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na' ḻeczə can' goquə tyemp c̱he de'e profet Ḻesion' gwnitə' zan beṉə' Izraelən' beṉə' gwsa'acšene len yižgüe' de'en ne' ḻepr. Ni to ḻega'aque' cui beyon Ḻesion'. Tozə Naaman beṉə' Siria beyon Ḻesion'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Na' yoguə' beṉə' ca' ža' yo'oda'onə' catə' gwse'enene' dižə' quinga besə'əža'achgüe'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Na' ḻe'e besyə'əzoža'ate' na' besyə'əbeɉe' Jeso'osən' syodan' na' gosə'əc̱he'ene' to lao ya'a gaḻə'əzə gan' chi' syodan' gwse'ene'ene' yoso'ox̱ope'ene' par che'elə, pero bito goquə bi so'onene' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Con beza' Jeso'osən' bedie' gwchoḻga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Na' ɉsoe' syoda Capernaum gan' mbane Galilean'. Na' yoguə' ža dezcanzən' bsed blo'ine' beṉə' ca' ža' ḻo'o yo'oda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Na' beṉə' ca' besyə'əbanene' ca naquə de'en bsed əblo'ine' ḻega'aque' c̱hedə' bsed blo'ine' ḻega'aque' ca'aczə to beṉə' bansed gax̱ɉw gwche'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ḻo'o yo'odao' na' gwzo to beṉə' yo'o yaz de'e x̱io' yic̱hɉla'aždaogüe'enə'. Na' bgosya'an be'enə' gwnan: ");
INSERT INTO zavNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Lɉoyeto'onə'. Partlə le', partlə neto' Jeso'os beṉə' Nasaret. ¿Ezedežiayi'o neto'onə'? Ṉezczəto' no le': Le' naco' beṉə' la'aždao' xi'ilažə' juisy na' Diozən' bseḻe'e le'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jeso'osən' gwdiḻe' de'e x̱i'onə' na' gože'en: ―Sšago'. Bechoɉ yic̱hɉla'aždao' benga. Na' bchix̱ de'e x̱i'onə' be'enə' gwchoḻ beṉə' ca' zɉəža'anə' nach bechoɉən, pero bito benen ḻe' zi'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Na' ḻechguaḻe besyə'əbane beṉə' ca' nach gwse' lɉuežɉga'aque': ―Nactequən' con gwne' ca' na' bechoɉ de'e x̱i'onə' de'en yo'o yaz yic̱hɉla'aždao' be'enə'. Nacbia' nape' yeḻə' chnabia' na' yeḻə' guac de'en chone' mendad yesyə'əchoɉ de'e x̱io' ca' na' chesyə'əchoɉən. ");
INSERT INTO zavNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Na' ca naquə de'en ben Jeso'osən' gosə' gwlalɉə dižə'ənə' doxen Galilean', na' len yež ca' de'en zɉənyec̱hɉ zɉəmbi'i gaḻə'əzə Galilean'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Na' catə' beze'e yo'oda'onə', na' gwyeɉe' liž Simonṉə'. Na' taobin' c̱he Simonṉə' chacšenene' yo'ochgüe' de'e ḻa na' gwso'oḻgüiže' Jeso'osən' yeyone' no'olən'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Na' Jeso'osən' gwzeche' cuite' gan' de'enə' na' bcheque'e gwdiḻe' de'e ḻanə' par bechoɉən no'olən'. Nach taobi'in c̱he Simonṉə' ḻe'e beyaste' na' goclene' beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Na' catə' bachen bgüižən', yoguə' beṉə' gosə'əc̱he'e con beṉə' chse'i gwde gwde yižgüe' ɉso'ene' lao Jeso'osən'. Na' Jeso'osən' gwx̱oa ne'en yic̱hɉ to toga'aque' na' beyone' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Na' ḻeczə bebeɉ Jeso'osən' de'e x̱io' ca' zɉəyo'o zɉəyaz ḻo'o yic̱hɉla'aždao' beṉə' zan ca'. Na' besyə'əchoɉən gosə'ənan zižɉo: ―Len' naco' Xi'iṉ Diozən'. Jeso'osən' gwdiḻe' ḻega'aquən na' bito be'e latɉə yesə'əṉen c̱hedə' zɉəṉezczen de que naque' Cristən' ben' gwleɉ Diozən' par gaquəlene' beṉac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Na' beteyo catə' gwye'eni', beze'e na' gwyeɉe' to latɉə gan' notono nḻa'. Na' beṉə' ca' besyə'əyilɉe'ene' na' ɉa'aque' gan' zoe'enə'. Na' bito gwse'enene' yeza' Jeso'osən' lažga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jeso'osən' gože' ḻega'aque': ―Ḻeczə beṉə' ca' nitə' syoda ca' yeḻa' cheyaḻə' žɉətix̱ɉue'iga'acda'ane' dižə' güen dižə' cobən' de que Diozən' ṉabi'e con notə'ətezə beṉə' əsoe' latɉə. Diozən' bseḻe'e nada' par nic̱h žɉətix̱ɉue'iga'acda'ane'. ");
INSERT INTO zavNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ca' goquən' Jeso'osən' gwde' to to yežən' gan' mbane Galilean' na' ḻo'o yo'odao' c̱hega'aque' ca' bsed blo'ine' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Na' goquən' lao zecha Jeso'osən' cho'a nisdaon' de'en nzi' Genesaret, gosə'əbiguə' beṉə' zan par boso'ozenague' xtižə' Diozən' de'en be'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Na' Jeso'osən' ble'ine' nitə' c̱hopə barcw dao' cho'a nisən'. Na' beṉə' gwxen beḻ ya'a ca' bac̱h besə'əžaše' ḻo'o barcw ca' na' bachesyə'əyibe' yix̱ɉw beḻ c̱hega'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Na' Jeso'osən' gwyo'e ḻo'o barcw c̱he Simonṉə' na' gwṉabene' ḻe' gocwlen par nic̱h bžigue'e barcw c̱he'enə' latə' ḻo'o nisən'. Na' gwche' Jeso'osən' ḻo'o barcon' nach bsed blo'ine' beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Na' ca beyož be'e dižə'ənə' nach gože' Simonṉə': ―Bžiguə'əch barcw c̱hio'onə' gan' naquə nisən' zitɉoch, na' ḻe'e əgwzaḻə' yix̱ɉw c̱helen' par senḻe beḻən'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nach Simonṉə' gože' Jeso'osən': ―Maestr, babento' žin bedo yel na' ni to cono no bdoḻe'eto'. Pero laogüe de'e bagwnao' le' ca', yoszaḻə'əchto' yix̱ɉw quinga. ");
INSERT INTO zavNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Na' bosə'əzaḻe'e yix̱ɉw c̱hega'aque'enə', na' catə' besyə'əbeɉga'aque'en zɉənža'achan beḻən' yelezə yesə'əchezə'ən. ");
INSERT INTO zavNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Na' beṉə' ca' gwnitə' ḻo'o barcw c̱he Simonṉə' gwsa'axe' beṉə' lɉuežɉga'aque' ca' zɉəža' ḻo'o barcon' yeto par əžɉse'eclene' ḻega'aque'. Na' catə' besə'əžin beṉə' ca' na' bosyo'osša'ache' barcw ca' xte ca bac̱h gwzolao chse'etɉən xan nisən'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nach Simonṉə' ben' ḻeczə le Bed catə' ble'ine' can' goquən', bzo xibe' lao Jeso'osən' na' gože'ene': ―Bebi'ižə'əšga len nada' X̱ana', c̱hedə' la' naca' to beṉə' güen de'e mal. ");
INSERT INTO zavNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Gwne' ca' c̱hedə' ḻe' txen len beṉə' ca' ža'alene' ḻo'o barcon' besyə'əbanchgüeine' ca naquən' gosə'əzene' beḻ zan ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Na' ḻeczə ca' besyə'əbane xi'iṉ Sebedeon' c̱hopə bišə'əte Jacobən' len Juanṉə', beṉə' ca' chso'on žin txen len Simonṉə'. Nach Jeso'osən' gože' Simonṉə': ―Bito žebo'. Le' naco' beṉə' gwxen beḻ. Pero ṉa'a gaco' beṉə' güe' xtiža'a, na' gono' par nic̱h so'ombia' beṉə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Na' catə' besyə'əžinḻene' barcw ca' yo biž, gosə'əbeɉyic̱hɉe'en na' len yoguə' šinḻazga'aque' nach ɉəsə'ənaogüe' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Na' goquən catə' zo Jeso'osən' to syoda, bžin to beṉə' chacšenchgüeine' len yižgüe' de'en ne' ḻepr. Na' be'enə' catə' ble'ine' Jeso'osən' bzo xibe' laogüe'enə', na' beḻgüiže'ene' gože'ene': ―X̱ana', gonšguei ben par nic̱h yeyacda'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nach Jeso'osən' bḻi ne'enə' gwdane'ene' na' gože'ene': ―Guacczə beyaque. Na' ḻe'e beyacteine' ca naquə yižgüe' de'en che'ine'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Na' Jeso'osən' bene' mendad ni tozə cui no no güe'elene' dižə' ca naquə de'en babene' len le', na' gože'ene': ―Gwyeɉ lao bx̱ozən' nic̱h le'ine' de que bac̱h beyacdo'. Na' gwnežɉo'one' to bia yix̱ə' gote' lao Diozən' ca de'en non de'e Moisezən' mendad par nic̱h yesə'əṉeze beṉə' de que babeyacdo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Na' tža tža gwdach dižə' ca naquə miḻagr ca' de'en chon Jeso'osən'. Na' beṉə' zan besə'ədopə besə'əžague' par boso'ozenague' xtižə' Jeso'osən' na' par nic̱h beyone' con beṉə' ca' chsa'acšene ca naquə yižgüe' de'en chse'ine'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Na' tši'i güeɉə bechoɉ Jeso'osən' beyeɉe' latɉə dašən' par ɉəyene' orasyonṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Na' goquən' to ža zo Jeso'osən' ḻo'o yo'o gan' zoe'enə' chsed chlo'ine' beṉə'. Na' gaḻə'əzə zɉəchi' to c̱hopə beṉə' Izrael beṉə' ca' babesə'əchoɉ zɉənzi' fariseo por ni c̱he can' choso'osed choso'olo'ine'. Na' yebaḻə beṉə' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' zɉəlene' ḻega'aque'. Beṉə' ca' ža' na' za'aque' yoguə'əḻoḻ yež gan' mbane Galilean' len Jodean', na' ḻeczə baḻe' za'aque' syoda Jerosalenṉə'. Na' boso'ozenague' dižə' de'en be' Jeso'osən'. Na' yeḻə' guac c̱he X̱ancho Diozən' gwzon len Jeso'osən' par beyone' beṉə' güe' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Na' besə'əžin x̱oṉɉ beṉə' zɉənḻene' to beṉə' nat to part cuerp c̱he'enə', zɉənx̱oe'ene' to lao cam dao'. Na' gwsa'aclaže'e yesə'ədie' na' əžɉso'ene' lao Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Na' tant beṉə' zan ža' caguə goquə yesə'əžinḻene' beṉə' güe'enə' gan' zo Jeso'osən'. Na' beṉə' ca' gwse'epe' yic̱hɉo'olə par boso'osalɉue' na' boso'oletɉe'ene' len xcame'enə' nic̱h bžine' lao Jeso'osən' gwchoḻ beṉə' zan ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ca naquə gocbe'i Jeso'osən' de que gwso'onḻilaže'ene', gože' beṉə' güe'enə': ―Babezi'ixena' xtoḻo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' na' beṉə' fariseo ca' gwzolao chso'one' xbab: “Benga chžia chnite'e Diozən' de'en chon cuine' ca Dioz. Notono no gaquə yezi'ixen xtoḻə' beṉac̱hən' šə caguə tozə Diozən'.” ");
INSERT INTO zavNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jeso'osən' gocbe'ine' xbabən' de'en gwso'one'enə' nach gože' ḻega'aque': ―¿Bixc̱hen' chonḻe xbabən' ca' ḻo'o yic̱hɉla'ažda'olenə'? ");
INSERT INTO zavNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Šə con yapa'ane' de que babezi'ixena' xtoḻe'enə', bito ṉezele šə napa' yeḻə' gwnabia' par yezi'ixena'an. Pero šə yapa'ane': “Gwyas na' gwda”, guatə'əbia' šə napa' yeḻə' gwnabia'anə' par gaquə can' nia'anə'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","De'e nga gona' par nic̱h əṉezele de que napa' yeḻə' gwnabia' lao yežlyo nga par yezi'ixena' xtoḻə' beṉac̱hən', nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. Nach gože' beṉə' güe'enə': ―Gwyas, beyoa' xcamo'onə' na' beyeɉ ližo'onə' to šao' to güen. ");
INSERT INTO zavNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Na' ḻe'e gwyasseste be'enə', chosə'əgüiate' beṉə' ca' nitə'ənə'. Nach beyoa' xcame'enə' gan' xoe'enə' beze'e zɉəyede' liže' cho'elaogüe'e Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Na' yoguə'əḻoḻ beṉə' ca' ža'anə' besyə'əbanene' na' gwso'elaogüe'e Diozən'. Na' do chžebga'aque' gosə'əne': ―Ṉa'a bable'icho to de'e zaquə' yebanecho. ");
INSERT INTO zavNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Gwde na' beza' Jeso'osən' na' ble'ine' to beṉə' goc̱hixɉw beṉə' le Lebi, chi'e latɉə gan' chc̱hixɉue'enə'. Na' Jeso'osən' gože'ene': ―Da len nada'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nach be'enə' ḻe'e gwzoža'ate' gwleɉyic̱hɉe' yoguə' šinḻaze' na' gwyeɉlene' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nach Lebin' bene' to lṉi xen liže'enə' par Jeso'osən'. Na' ɉa'ac beṉə' zan beṉə' goc̱hixɉw ca' na' beṉə' yeziquə'əchlə na' gosə'əbe'elene' ḻega'aque' cho'a mesən' par gwsa'ogüe'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' na' len beṉə' fariseo ca' gwsa'acyože' disipl c̱he Jeso'osən', gwse'e ḻega'aque': ―Malən' chonḻe che'eɉ chaole txen len beṉə' goc̱hixɉw na' nochlə beṉə' güen de'e mal ca' beṉə' cui chonḻento' txen. ");
INSERT INTO zavNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jeso'osən' gože' ḻega'aque': ―Benə' cui chsa'acšene bito chəsə'əyažɉene' beṉə' güen rmech. Beṉə' ca' chsa'acšene ḻega'aque'enə' chəsə'əyažɉene' beṉə' güen rmech. ");
INSERT INTO zavNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nada' za'a zedəyena' par nic̱h beṉə' ca' zɉəṉeze de que zɉənaque' beṉə' güen de'e mal yesyə'ədiṉɉene' xtoḻə'əga'aque'enə', pero bito zedeyena' par nic̱h beṉə' ca' chsa'aquene' bazɉənaque' beṉə' güen yesyə'ədiṉɉene' xtoḻə'əga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nach yebaḻə beṉə' gwse'ene': ―Zan las neto' disipl c̱he Juanṉə' na' ḻeczə ca' disipl c̱he beṉə' fariseo ca' chzoto' sin cui che'eɉ chaoto' par cho'ela'oto' Diozən' na' chonczəto' orasyon. Pero na' disipl c̱hio' ca' chse'eɉ chsa'ogüe'. ¿Bixc̱hen' ža? ");
INSERT INTO zavNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nach gož Jeso'osən' ḻega'aque': ―Catə' chac to yeḻə' gošagna' beṉə' migw c̱he be'enə' chšagna'anə' chse'eɉ chsa'ogüe'. Na' ca'aczən' naquən len nada' na' len disipl c̱hia' ca', chse'eɉ chsa'ogüe' lao ṉe'e zoa' len ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Catə'əchən' əžin ža yesə'əc̱he'ex̱ax̱ɉ beṉə' contr c̱hia' ca' nada', cana'achən' əchoɉ catə' bito əse'eɉ əsa'o disipl c̱hia' ca'. Jeso'osən' gwne' ca' bsaquə'əlebe cuine' ca beṉə' gošagna', na' disipl c̱he' ca' ca beṉə' migw c̱he beṉə' gošagna'anə'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Na' gozo'elene' ḻega'aque' to jempl par nic̱h gwsa'acbe'ine' de que bito gaquə yesə'ənaogüe' costombr gol c̱hega'aque' na' yesə'ənaotie' de'en chsed chlo'ine'. Gože' ḻega'aque': ―Notono beṉə' zo beṉə' chc̱heze'e xa cobe'en na' yode'en xa gole'enə'. Šə gone' ca' la' gwx̱iṉɉe' xa cobe' na'anə' na' xa gole'en bito gaquən lebe len pedas xa cobe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Na' ḻeczə ca' notono zo beṉə' chgue'e bino cobən' ḻo'o yid golə. Šə gone' ca' ža, bino cobən' əc̱hezə'ən yid golən' na' lalɉə binon' na' cuiayi' yidən'. ");
INSERT INTO zavNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Cle la' cheyaḻə' que'e bino cobən' ḻo'o yid cobə. ");
INSERT INTO zavNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na' ca naquə beṉə' bac̱h yo'olaogüe' che'eɉe' bino golən' bito yene'ene' ye'eɉe' bino cobən', c̱hedə' əṉe': “Bino golən' naquəchən güen.” Ḻeczə can' naquən len beṉə' bac̱h yo'o yic̱hɉe' costombr gol c̱he'enə', bito yene'ene' gwzenague' c̱he de'e cobən'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Na' gozaquən to ža dezcanz Jeso'osən' gwdie' len disipl c̱he' ca' gan' nyaž trigon'. Nach disipl c̱he' ca' gosə'əlec̱hɉe' trigon', na' gosə'əxobe'en, na' gwsa'ogüe'en. ");
INSERT INTO zavNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nach besə'əle'i baḻə beṉə' fariseo ca' can' gwso'on disipl ca' na' gwse'e ḻega'aque': ―¿Bixc̱hen' chonḻe de'en bito de lsens goncho ža dezcanzən'? ");
INSERT INTO zavNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Na' Jeso'osən' gože' ḻega'aque': ―¿Ecabi za'alažə'əle de'en bablable can' ben de'e Rei Dabin' catə' ḻe' na' beṉə' lɉuežɉe' ca' gosə'ədone'? ");
INSERT INTO zavNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Gwyeɉe' ḻo'o yo'odao' əblaonə' na' gwxi'e yetxtil de'en bazɉəncua' bx̱oz ca' par Diozən', na' gwdaogüe'en len beṉə' lɉuežɉe' ca' ḻa'aṉə'əczə cui zɉənaque' bx̱oz. Na' yetxtilən' cui de lsens par gao con to beṉə' ḻen, letg bx̱oz ca' chac əsa'ogüe'en. ");
INSERT INTO zavNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Na' ḻeczə gwna Jeso'osən': ―Naquən lao na'a əṉia' bin' naquən güen goncho ža dezcanzən', nada' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Na' yeto ža dezcanz gozeɉe' ḻo'o yo'oda'onə' na' bsed blo'ine' beṉə' ca' ža'anə'. Na' entr beṉə' ca' ža'anə' len to beṉə' bambižə ne'e ḻichan'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' na' beṉə' fariseo ca' nite'e na' chosə'əgüiateze' Jeso'osən', chəsə'əbeze' šə goyone' be'enə' ža dezcanzən' par nic̱h əsa'ogüe' xya contr ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Na' gocbe'i Jeso'osən' xbab c̱hega'aque'enə' na' gože' ben' mbižə ne'inə': ―Da ngalə. Nach bgüiguə' be'enə' gwzeche' laogüe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Na' Jeso'osən' gože' ḻega'aque': ―Ḻe'e gonšc xbab c̱helen' naquən' na ḻein'. ¿Enan goncho de'e güen ža dezcanzən', o šə nan goncho de'e mal? ¿Enan goncho par nic̱h cui sa'at beṉə' o šə nan goncho par nic̱h sa'ate'? ");
INSERT INTO zavNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jeso'osən' bgüie' yogue'e nach gože' be'enə': ―Bḻi na'onə'. Nach bḻi na' be'enə', na' beyaquen. ");
INSERT INTO zavNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Na' beṉə' ca' choso'osed choso'olo'i ḻein' na' beṉə' fariseo ca' ḻechguaḻe besə'əže'e, na' gwzolao boso'oxi'e entr ḻega'aque' naclə so'one' len Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Na' to ža gozeɉ Jeso'osən' lao ya'an ɉene' orasyon. Na' bedo yel bene' orasyon lao Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Na' catə' gwye'eni'inə' boḻgüiže' disipl ca' par gosə'əbigue'e gan' zoe'enə' nach gwleɉe' šižiṉe' na' əbsi'e ḻega'aque' apostol. ");
INSERT INTO zavNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Na' beṉə' quingan' gwleɉe': Simon ben' bsi'e Bed, na' Ndres beṉə' bišə' Bedən', na' Jacob, na' Juan, na' Lip, na' Bartolome, ");
INSERT INTO zavNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","na' Matio, na' Tomas, na' Jacob xi'iṉ Alfeo, na' Simon Selote, ");
INSERT INTO zavNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","na' Jodas xi'iṉ Jacob, nach Jod Iscariot ben' əbdie' Jeso'osən' lao na' beṉə' contr ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Na' beyetɉe' ya'anə' len ḻega'aque' na' gwzeche' gan' naquə lašə' len disipl c̱he' ca'. Na' ḻeczə nitə' beṉə' zan beṉə' za'ac doxen Jodean', do Jerosalenṉə' na' do gan' mbane Tiro na' Sidon. Na' Tiron' len Sidonṉə' zɉəchi'in cho'a nisda'onə'. Na' entr beṉə' ca' nitə' choso'ozenag xtižə' Jeso'osən' zɉəlen baḻə beṉə' chse'i yižgüe', na' Jeso'osən' beyone' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Na' beṉə' ca' zɉəyo'o zɉəyaz de'e x̱io' yic̱hɉla'aždaoga'aque'enə' Jeso'osən' bebeɉe' de'e x̱io' ca' zɉəyo'o zɉəyaze'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Na' yoguə' beṉə' besə'əyilɉlaže'e naclə so'one' par nic̱h yesə'əlapə' na'aga'aquen' ḻe' c̱hedə' len yeḻə' guac c̱he'enə' chone' par chega'a yižgüe' de'en chse'i to toga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Na' Jeso'osən' gwḻis laogüe'enə' bgüie' disipl c̱he' ca' na' gože' ḻega'aque': ―Mbalaz zo le'e beṉə' yašə' c̱hedə' cho'ele latɉə chnabia' Diozən' le'e. ");
INSERT INTO zavNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mbalaz so le'e chdonḻe ṉa'a, c̱hedə' gwžin ža catə' cuich tonḻe. Na' mbalaz so le'e chbežle ṉa'a, c̱hedə' Diozən' gone' par nic̱h yebeile. ");
INSERT INTO zavNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nada' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. Na' mbalaz sole šə por ni c̱he de'en chonḻilažə'əle nada' chəsə'əgue'i beṉə' le'e, na' šə chesyə'əbeɉe' le'e ḻo'o yo'odao' c̱hega'aque'enə', na' šə choso'ožia choso'onite'e le'e, na' šə chəsə'əne' de que nacle beṉə' mal. ");
INSERT INTO zavNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ḻeyebeichgüei catə'ən chac de'e quinga, na' ḻe'e so mbalaz, c̱hedə' Diozən' gone' par nic̱h gaquəchgua de'e güen c̱hele catə' yežinḻe gan' zoe'enə'. Can' chso'onene' le'e ca'aczən' gwso'one de'e x̱axta'oga'aque'enə' de'e profet ca' gwso'e xtižə' Diozən' cana'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pero probchguazə le'e beṉə' gwni'a. Chac güen c̱hele ṉa'a, pero caguə par zeɉḻicaṉen' gaquə güen c̱hele. ");
INSERT INTO zavNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Probchguazə le'e dechgua de'e chaole ṉa'a. Gwžin ža catə' cuich bi gatə' c̱hele. Probchguazə le'e zole ḻegr ṉa'a. Gwžin ža catə' yegüine'ele na' cuežyašə'əle. ");
INSERT INTO zavNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Probchguazə le'e chso'elao' yoguə'əḻoḻ beṉə' le'e. Ca'aczən' gwso'elao' de'e x̱axta'oga'aquen' profet gox̱oayag ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pero le'e chzenagle c̱hia', ḻe'e gaque c̱he beṉə' contr c̱hele ca', ḻe'e gontezə ḻe'e gon de'e güen len beṉə' ca' chəsə'əgue'i le'e. ");
INSERT INTO zavNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ḻe'e ṉabtezə ḻe'e ṉab par nic̱h beṉə' ca' chso'on contr le'e ṉite'e mbalaz. Ḻe'e so ḻe'e gon orasyon par beṉə' ca' choso'ožia le'e xyac̱hoḻ. ");
INSERT INTO zavNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Šə to beṉə' tie' x̱aguə'əlen' šḻa'a, ḻe'e güe'e de'en yešḻa'a. Šə to beṉə' əque'e xadoṉ c̱helen' ḻa fuers, ḻegüe' latɉə c̱hiṉe' len xcamislen'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Notə'ətezə beṉə' bi ṉabene' le'e, gwnežɉwlene'en. Šə to beṉə' əque'e bitə'ətezə de'en de c̱hele, bito yeṉablen. ");
INSERT INTO zavNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Con yoguə' de'e güen de'e chene'ele so'on beṉac̱hən' len le'e, con ca'atezəczən' cheyaḻə' gonḻe len ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Šə porzə chaquele c̱he beṉə' ca' chsa'aque c̱hele, ¿bixa yeɉlaotgualen'? Ḻe'egatezə ca' chso'on beṉə' güen de'e mal ca', chsa'aquene' c̱he beṉə' ca' chsa'aque c̱hega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ḻeczə šə chonḻe de'e güen porzə len beṉə' ca' chso'on de'e güen len le'e, ¿bixa yeɉlaotgualen'? Ḻe'egatezə can' chso'on beṉə' güen de'e mal ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Šə porzə chbeɉle bi de'en chbeɉle len beṉə' sole lez yesyə'əyoṉe'en le'e, ¿bixa yeɉlaotgualen'? Ḻe'egatezə can' chso'on beṉə' güen de'e malən', chesə'əbeɉe' bi de'en chesə'əbeɉe' lɉuežɉga'aque' na' nite'e lez yesyə'ənežɉue'en. ");
INSERT INTO zavNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero na' le'e ža, ḻe'e so ḻe'e gaque c̱he beṉə' contr c̱hele ca', na' ḻe'e so ḻe'e gon de'e güen. Na' ḻe'e so ḻe'e cueɉ bi de'en cueɉle beṉə' na' bito sole lez yesyə'əyoṉe'en. Šə gonḻe ca', gwlo'ele de que nacle xi'iṉ Dioz ben' naquə ḻe'ezelaogüe beṉə' blao, na' Diozən' goṉe' le'e yeḻə' bala'aṉ xen. Ḻe'enə' naque' gax̱ɉwlažə' len beṉə' ca' cui chso'e yeḻə' chox̱cwlen c̱he' na' yeziquə'əchlə beṉə' güen de'e mal ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Cheyaḻə' yeyašə' yeži'ilažə'əle lɉuežɉ beṉac̱hle ca X̱achon' ben' zo yoban' cheyašə' cheži'ilaže'e yoguə' beṉac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Bito gonḻe xbab de que zaquə'əle par c̱hoglaolen c̱he beṉə' de que zɉənape' doḻə'. Šə c̱hoglaolen c̱he beṉə' de que zɉənape' doḻə', ḻe'egatezə ca' Diozən' c̱hoglaogüe'en c̱hele de que naple doḻə'. Na' bito bi yosbague'ele beṉə' de que zɉənape' doḻə' par nic̱h Diozən' bito bi yosbague'ene' le'e de que naple doḻə'. Ḻe'e so ḻe'e yezi'ixen c̱he beṉə' par nic̱h Diozən' yezi'ixene' c̱hele. ");
INSERT INTO zavNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ḻe'e so ḻe'e gwnežɉo beṉə' šə bi de'en chəsə'əyažɉene'. Can' chso'on baḻə beṉə' ḻechguaḻe naḻe'e choso'ochix̱e' bi de'en chso'ote'e, chosə'əc̱hiše'e lao medid c̱hega'aque'en na' choso'osi'iṉse'en na' chso'one' xte ca chezoya'an, ca'aczən' cheyaḻə' gonḻe gwnežɉwle bi de'en chəsə'əyažɉe beṉə' par nic̱h ḻeczə ca' gon Diozən' len le'e. ");
INSERT INTO zavNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nach Jeso'osən' be'elene' beṉə' ca' ža'anə' yeto jempl. Na' bsaquə'əlebene' beṉə' fariseo ca' na' beṉə' ca' choso'osed choso'olo'i ḻein' ca beṉə' lc̱hoḻ c̱hedə' bito gwse'eɉni'ine' de'en naquə de'e ḻi na' de'e na'anə' bito goquə yoso'osed yoso'olo'ine'en beṉə' yoblə. Na' gwne': ―¿Eguaquə to beṉə' lc̱hoḻ cue'e nez yeto beṉə' lc̱hoḻən'? Bito gaque'. Ṉezecho de que txen žɉəsə'əbix̱e' to ḻo'o yech. ");
INSERT INTO zavNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Šə to beṉə' chsede' len to maestr, bito ṉacho guaquə əgwsedene' maestrən'. Na' ḻa'aṉə'əczə šə ben' chsed ta' yic̱hɉe' yoguə'əḻoḻ de'en əgwlo'i maestrən' ḻe', bito gaque' beṉə' si'inch ca maestrən', sino cachozəczə gaque'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Chle'ile güe' dao' de'en žia cožə' beṉə' lɉuežɉle na' cabi chele'ile güe' xen de'en žia cožə'əlen'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Che' beṉə' lɉuežɉle: “Be' latɉə gona' rmech güe' daon' de'en žia cožo'o”, na' bito chonḻe rmech güe' xen de'en žia cožə'əlen'. Beṉə' gox̱oayag le'e, zgua'atec ḻe'e gon rmech güe' xenṉə' de'en žia cožə'əlen' na' techlə əṉezele bi rmechən' chyažɉele par gonḻe rmech güe' daon' de'en žia cožə' beṉə' lɉuežɉlen'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Bito ṉacho de que to yag frot güen chbian frot de'e cui naquə güen, na' nic əṉacho de que yag frot de'en cui naquə güen chbian frot güen. ");
INSERT INTO zavNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Segon can' naquə frot de'en chbia to to yaguən' ṉezecho bi cḻas yaguən'. Yag yešə' bito chbian yix̱güion', nic yag bisga' chbian obas. ");
INSERT INTO zavNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","To beṉə' la'aždao' xi'ilažə' chone' de'e güen, c̱hedə' la' can' nan ḻo'o yic̱hɉla'ažda'ogüe' nan' chone'. Na' ben' chon de'e mal chone' ca' c̱hedə' chzenague' c̱he la'ažda'omale'enə'. Na' yoguə'əte dižə' de'en chchoɉ cho'achon' la' ḻo'o yic̱hɉla'ažda'ocho na'anə' za'an. ");
INSERT INTO zavNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Bixc̱hen' che'ele nada' “X̱ana'”, na' cui chonḻe can' nona' mendadən'? ");
INSERT INTO zavNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ṉa'a ṉia' le'e can' gwxaquə'əlebe yoguə' non' nao nada' na' chzenague' xtiža'anə' na' chone' can' nona' mendadən'. ");
INSERT INTO zavNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Gwxaquə'əlebene' ca to beṉə' ben yo'o. Na' gwc̱he'eṉe' zitɉw gwleque' lan yo'onə' de'en naquə de'e gual. Na' catə' bchoɉchgua yaonə', gwyec̱hɉən liže'enə' na' bito bebix̱ən cuiayi'in, c̱hedə' gwzo c̱hec̱hchguan. ");
INSERT INTO zavNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Na' yoguə' non' cui chzenague' c̱he xtiža'anə' gwxaquə'əlebene' ca yeto beṉə' ben yo'o. Con bene'en lao yo na'azə sin cui bi lanei gwleque'. Na' catə' bchoɉchgua yaonə' gwyec̱hɉən liže'enə', na' bebix̱ən gwžiayi'iteczən. ");
INSERT INTO zavNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Na' catə' beyož be' Jeso'osən' dižə'ən len beṉə' ca', beyeɉe' Capernaunṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Na' zo to capitan beṉə' bito naque' beṉə' Izrael, na' zo to xmose' chacšenchgüeine' na' yelezə gate'. Na' capitanṉə' chacchgüeine' c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Na' catə' bene capitanṉə' dižə' c̱he Jeso'osən', bseḻe'e baḻə beṉə' golə beṉə' blao c̱he beṉə' Izrael ca' par ɉse'etə'əyoine' Jeso'osən' šeɉe' liže'enə' par yeyone' xmosen'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nach catə' besə'əžine' gan' zo Jeso'osən' gwsa'atə'əyoine' ḻe' gaquəlene' capitanṉə', na' gwse'e Jeso'osən': ―Naque' to beṉə' zaque'e par gaquəleno'one', ");
INSERT INTO zavNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","c̱hedə' chaquene' c̱he chio'o beṉə' Izrael. Na' ḻe' bene' yo'odao' c̱heto' nga len xmeche'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nach gwyeɉ Jeso'osən' len ḻega'aque'. Pero ze'e yesə'əžine' liže'enə' catə' bseḻə' capitanṉə' baḻə beṉə' migw c̱he'enə' lao Jeso'osən', na' gwse'ene': ―Capitanṉə' ne' de que bito gonzi'ilažo'o yido' liže'enə', c̱hedə' la' ṉezene' de que bito zaque'e par šo'o liže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","De'e na'anə' bito beyaxɉene' deṉabene' le' gaquəleno'one'. Con chene'ene' gonšgo' mendadən' na' yeyaque xmose'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Capitanṉə' ne' de que zoe' xni'a rein', pero ḻeczə nitə' soḻdad c̱he' ca' xni'enə'. Na' catə' che'e toe': “Gwyeɉ”, na' cheɉe', na' catə' che'e yetoe': “Da”, na' chide'. Na' catə' che'e xmosen': “De'e nga gono'”, na' chone'en. Na' ṉezene' de que con əṉao' yeyaque xmose'enə' na' yeyaquene'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Na' Jeso'osən' catə' benene' dižə' de'en əgwse' beṉə' migw c̱he capitanṉə' ḻe', bebanene' na' beyec̱hɉe' gože' beṉə' ca' zɉəsə'ənao ḻe': ―Echnia' le'e, bitoṉə' želda' beṉə' gonḻilažə' nada' ca chonḻilažə' capitanṉə' nada'. Ni to beṉə' Izrael cui chonḻilažə' nada' ca benga. ");
INSERT INTO zavNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nach ɉəya'ac beṉə' ca' bseḻə' capitanṉə', na' catə' besyə'əžine' liže'enə' babeyaque xmose'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Na' gwyeɉ Jeso'osən' to syoda de'en nzi' Nain, nžague' disipl c̱he' ca' na' zan beṉə' yoblə. ");
INSERT INTO zavNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Bazɉa'aque' gaḻə'əzə par yesə'əžine' cho'a puert c̱he syodan', na' ḻei chəsə'əchoɉ x̱oṉɉ beṉə' cho'a puertən' zɉənḻene' to beṉə' guat. Na' ben' gotən' naque' beṉə' tlišə', na' xne'en naque' beṉə' gozebə. Na' beṉə' zan beṉə' lao' syodan' zɉənžague' xna' beṉə' guatən'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Na' catə' ble'i X̱anchon' no'olən', beyaše'ene' ḻe', nach gože'ene': ―Bito cuežo'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nach zde' na' ɉtane' yagant gan' xoa beṉə' guatən', na' beṉə' ca' zɉənḻen ḻe'enə' gosə'əbeze'. Nach gože' beṉə' guatən': ―Beṉə' güego', beyas. ");
INSERT INTO zavNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nach beṉə' guatən' beyase' gwchi'e na' gwzolao cheṉe'. Na' Jeso'osən' beyone' ḻe' lao na' xne'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Na' yoguə' beṉə' ca' besə'əžebe' nach gwso'elaogüe'e Diozən' chəsə'əne': ―Babla' to profet əblao gan' nga zocho ṉa'a. Na' Diozən' bagocwlene' chio'o naccho ṉasyon c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Na' ca naquə de'en ben Jeso'osən' gosə' gwlalɉə dižə' c̱he'enə' doxen Jodean' na' yež ca' de'en zɉənyec̱hɉ zɉəmbi'i gaḻə'əzə. ");
INSERT INTO zavNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nach disipl c̱he Juanṉə' ɉəsye'eye'elene' ḻe' dižə' yoguə' ca naquə de'e ca' chon Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Nach gox Juanṉə' c̱hopə disipl c̱he' ca' nach gože' ḻega'aque': ―Ḻe'e žɉa'ac gan' zo Jeso'osən' na' ye'elene': “¿Elen' ben' naquən əseḻə' Diozən' o šə soto' lez yidə beṉə' yoblən'?” ");
INSERT INTO zavNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nach disipl ca' catə' besə'əžine' gan' zo Jeso'osən' gwse'ene': ―Juan ben' chc̱hoa beṉə' nis bseḻe'e neto' laogo' nga par əṉabeto' le' šə len' ben' naquən əseḻə' Diozən' o šə soto' lez yidə beṉə' yoblən'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Lao or na'atezə žlac ṉe'e nitə' disipl c̱he Juanṉə', Jeso'osən' beyone' beṉə' zan beṉə' ca' chsa'acšene na' beṉə' chse'i yižgüe' gual. Ḻeczə bebeje' de'e x̱io' ca' de'en zɉəyo'o zɉəyaz yic̱hɉla'aždao' beṉə', na' bene' par nic̱h besyə'əle'i beṉə' lc̱hoḻ. ");
INSERT INTO zavNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nach Jeso'osən' boži'e xtižə' beṉə' ca' bseḻə' Juanṉə' laogüe'enə' gože' ḻega'aque': ―Ḻe'e žɉəya'ac na' ḻe'e žɉəyeyež Juanṉə' doxen de'e ca' bable'ile na' de'e ca' babenele. Bable'ile chona' par nic̱h baḻə beṉə' lc̱hoḻ chesyə'əle'ine', na' baḻə beṉə' coj chesyə'əde', na' yebaḻə beṉə' cuež chesyə'əyenene', na' ḻeczə baḻə beṉə' gwse'i yižgüe' de'en ne' ḻepr babesyə'əyaquene'. Bable'ile bosbana' baḻə beṉə' guat na' babenele cho'a dižə' güen dižə' cobə c̱hia'anə' len beṉə' yašə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mbalaz zo beṉə' cheɉḻe'e de que Diozən' bseḻe'e nada'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Na' catə' besyə'əsa'ac disipl c̱he Juanṉə' nach Jeso'osən' be'elene' beṉə' ca' zɉəndobən' xtižə' Juanṉə', gože' ḻega'aque': ―¿Nacxa naquə ben' ɉəle'itgüeiczele latɉə dašən'? ¿Ešayec̱hə šayen chaque'? Bito. ");
INSERT INTO zavNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Nacxan' goque' catə' ɉəle'ilene'? ¿Enyaze' lachə' šao'? ¿əšə bito? la' beṉə' ca' zɉənyaz lachə' šao' nite'e yo'o güenchgua ca no liž rei, na' bito bi chesə'əyažɉene' par yesə'əchoɉe' ližga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Noxan' ɉəle'ilen' ža? ¿Eto profet ben' cho'e xtižə' Diozən'? De'e ḻi naque' to profet. Pero əchnia' le'e caguə con to profetən'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","C̱he bengan' nyoɉən ḻe'e Xtižə' Diozən' nan: Nada' Dioz əseḻa'a to beṉə' cuialaogüe' güe'e xtižo'onə', par nic̱h ṉitə' beṉə' probnid par əso'elaogüe'e le' catə'ən yido'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Echnia' le'e, notono beṉac̱h ṉe'e so beṉə' naquəch beṉə' blaoch ca Juanṉə'. Na' notə'ətezəchlə beṉə' güe'e latɉə ṉabia' Diozən' ḻe', ḻa'aṉə'əczə bito naque' beṉə' blao gwžin ža catə' šeɉni'ichene' c̱hia' clezə ca Juanṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Na' baḻə beṉə' goc̱hixɉw ca' na' len yeziquə'əchlə beṉə' ca' bc̱hoa Juanṉə' nis, gwsa'acbe'ine' de que de'e ḻi zɉənaque' beṉə' mal lao Diozən' catə' gwse'enene' dižə' de'en be' Juanṉə' len ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero na' beṉə' fariseo ca' na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' gwso'onczə yic̱hɉlaoga'aque' cui besyə'ədiṉɉene' xtoḻə'əga'aque'enə' can' gone'e Diozən' na' bito bc̱hoa Juanṉə' ḻega'aque' nis. ");
INSERT INTO zavNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nach Jeso'osən' gože' ḻega'aque': ―¿Nac əgwsaquə'əlebetgüeida' le'e mbanḻe ṉa'a? na' ¿nac nacle? ");
INSERT INTO zavNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Egwsaquə'əlebeda' le'e ca bidao' c̱hedə' cuiczə bi de žleb c̱hele. Ca naquə bidao' ca' catə' nitə'əbo' do gan' chac ya'a chse' lɉuežɉga'acbo': “Bento' ḻegr, bito gwyo'olažə'əle, na' babento' bgüine bgüež, peor.” ");
INSERT INTO zavNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan ben' chc̱hoa beṉə' nis bide' laole nga. Bito güe'eɉ gwdaošaogüe'e can' chse'eɉ chsa'o beṉə' yoblə, na' nic güe'eɉe' bino. Nach gwnale c̱he': “Yo'o yaz de'e x̱i'onə' yic̱hɉla'aždaogüe'enə'.” ");
INSERT INTO zavNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Na' nada' ža, Diozən' bseḻe'e nada' golɉa' beṉac̱h, na' chle'ile che'eɉ chaogua' can' che'eɉ chaole, na' nale c̱hia' de que naca' beṉə' lia na' beṉə' güe'e zo. Na' ḻeczə nale de que naca' migw c̱he beṉə' goc̱hixɉw ca' na' migw c̱he yeziquə'əchlə beṉə' ca' chso'on de'e mal. ");
INSERT INTO zavNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero na' Diozən' chone' par nic̱h beṉə' ca' choso'ozenag c̱he' chso'one' ca nacbia' de que ḻe' naque' ḻe'ezelaogüe beṉə' sin'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","To beṉə' fariseo bene' combid Jeso'osən' šeɉe' liže'enə' par əsa'ogüe'. Na' bžin Jeso'osən' liž be'enə' na' gwchi'e cho'a mesən'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na' to no'olə beṉə' güen de'e mal beṉə' lao' syodan' gwṉezene' de que Jeso'osən' əžine' liž be'enə'. Na' Jeso'osən' len beṉə' ca' yeḻa' banite'e cho'a mesən' par əsa'ogüe' catə' bgüiguə' no'olən' cuit Jeso'osən' nox̱e'e to lmet de yeɉ de'e yožə to set de'e zaque'e de'e chḻa' zix̱. ");
INSERT INTO zavNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Na' no'olən' ɉəbigue'e gaḻə'əzə xni'a Jeso'osən', na' gwcheže'. Nis əxchež c̱he'enə' bžonən ṉi'a Jeso'osən' na' bgüisən. Na' bxie' ṉi'enə' len yišə' yic̱hɉe'enə', na' bnope'en, na' gwdebe'en set zix̱ən'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Na' beṉə' fariseon' ben' ben Jeso'osən' combid, catə' ble'ine' can' chon no'olən', na' goquene': ―Žalə' be'enga naque' profet, guacbe'ine' de que no'olə nga naque' beṉə' güen de'e mal. ");
INSERT INTO zavNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nach Jeso'osən' gože'ene': ―Simon, de to de'e che'enda' əṉia' le'. Nach Simonṉə' gože' Jeso'osən': ―Gwnan Maestr. ");
INSERT INTO zavNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jeso'osən' gože'ene': ―Gwzo to beṉə', na' gwnitə' c̱hopə beṉə' gwsa'aḻe'e xmeche'. Toe' goḻe'e gueyə' gueyoa mech de'en ne' denario, na' ben' yeto goḻe'e šiyon denario. ");
INSERT INTO zavNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Na' c̱hopte beṉə' ca' ni toe' cui de c̱hega'aque' par yesyə'əyixɉue' xyan', na' ben' gwleɉ mechən' bṉitlaogüe' de'en chsa'aḻe'e c̱he'enə'. Gwnašc nada', ¿noe' entr beṉə' ca' c̱hopə gwsa'aquechene' c̱he'? ");
INSERT INTO zavNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nach Simonṉə' gože'ene': ―Šəquə ben' əbṉitlaogüe' xya c̱hein' de'e xench. Jeso'osən' gože'ene': ―De'e ḻi can' bagwna'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nach gwyec̱hɉe' bgüie' no'olən' na' gože' Simonṉə': ―¿Echle'ido' no'olə nga? Nada' bagwyo'a ližo' nga, na' bito beṉo' nis c̱hib ṉi'a, pero no'olə nga bagwdibe' ṉi'anə' len nis əxchež c̱he'enə', na' bxi'en len yišə' yic̱hɉe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Bito bnopo'o nada', pero na' no'olə nga dezd bla'atia' nga chnope'e ṉi'anə'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Bito gwdebo' set yic̱hɉa'anə', pero no'olə nga bagwdebe' set zix̱ən' ṉi'anə'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Na' əchnia' le', xtoḻe'enə' gwsa'aquən de'e zan, pero babezi'ixena' c̱he'. De'e na'anə' chacchgüeine' c̱hia'. Ben' bito əžinḻažə' xtoḻe'enə' ca xtoḻə' no'olə nga, catə' yezi'ixena' c̱he' bito gactequene' c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nach gože' no'olən': ―Babezi'ixena' xtoḻo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nach beṉə' ca' chsa'o len Jeso'osən' txen lao mesən' gwzolao chse' lɉuežɉe': ―¿Noxa benga chaclizene' de que ḻe'enə' chezi'ixene' doḻə'? ");
INSERT INTO zavNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nach gož Jeso'osən': ―De'en chonḻilažo'o nada' babezi'ixena' c̱hio'. Beyeɉ to šao' to güen. ");
INSERT INTO zavNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Na' techlə gwyeɉ Jeso'osən' to to syoda na' to to yež de'en zɉənyec̱hɉ zɉəmbi'i Galilean', na' ɉtix̱ɉui'e dižə' güen dižə' cobə de que Diozən' ṉabi'e con notə'ətezə beṉə' soe' latɉə. Na' zɉa'aclen beṉə' šižiṉ ca' ḻe', beṉə' ca' zɉənzi' apostol. ");
INSERT INTO zavNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nach x̱oṉɉ no'olə ḻeczə zɉa'aclene' Jeso'osən', beṉə' ca' babeyone'. Baḻe' babebeɉe' de'e x̱io' de'en zɉəyo'o zɉəyaz yic̱hɉla'aždaoga'aque'enə', na' yebaḻe' babeyone' ḻega'aque' catə' gwsa'acšenene'. Na' entr no'ol ca' len ben' le Maria beṉə' Magdala, bebeɉ Jeso'osən' gažə de'e x̱io' ca' zɉəyo'o zɉəyaz yic̱hɉla'aždaogüe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nach ḻeczə len ben' le Xguan, xo'olə Chosa. Na' Chosan' yo'o lao ne'e chape' liž Erodən' na' yežlyo c̱he' ca'. Na' ḻeczə len ben' le San gwyeɉlene' Jeso'osən', na' yezan beṉə' yeziquə'əchlə. Na' no'ol ca' boso'oc̱hine' bitə'ətezə de'en gotə' c̱hega'aque' par bosə'ənežɉue' de'en byažɉe Jeso'osən' len disipl c̱he' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Na' beṉə' zan besə'ədope' gan' zo Jeso'osən' beṉə' za'ac to to syoda ca'. Na' be'e to jempl bzeɉni'ine' ḻega'aque' can' gwxaquə'əlebe xtižə' Diozən'. Gwne': ");
INSERT INTO zavNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―To beṉə' gwze'e zde' güen trigw. Na' lao chose' trigon' baḻən ɉəsə'əchazən cho'a nez, na' boso'oleɉ boso'ošošɉ beṉə' ḻen, na' bia žia x̱ile'e bia chaš ḻe'e yoban' gwsa'ob ḻen. ");
INSERT INTO zavNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Na' baḻən ɉəsə'əchazən ga naquə lao yeɉ, na' catə' bla'aquənṉə' gosə'əbižən c̱hedə' caguə bi gopə' denə'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Na' yebaḻən besə'əgo'oṉən lao yo ga nc̱hix̱ə xsa yešə' na' bla'aquən txen na' boso'oḻolə' yag yešə' ca' ḻega'aquən. ");
INSERT INTO zavNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Na' yebaḻən besə'əgo'oṉən lao yo šao' na' bla'aquən na' gosə'əbian to gueyoa güeɉə. Na' beyož be'e dižə' quinga gwṉe' zižɉo gwne': ―Le'e žia nagle de'e chene, ḻegwzenag. ");
INSERT INTO zavNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nach disipl c̱he' ca' gosə'əṉabene' ḻe' bi zeɉe jemplən' de'en be'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Na' gož Jeso'osən' ḻega'aque': ―Diozən' chone' par nic̱h le'e əṉezele de'en cui no gwṉeze antslə de que ṉabi'e con notə'ətezə beṉə' soe' latɉə. Pero beṉə' yeziquə'əchlə cho'elenga'aca'ane' jempl c̱hedə' bito chse'eɉḻe'e c̱hia'. Chona' ca' par nic̱h yesə'əle'ine' de'en chona' na' bito sa'acbe'ine' bi zeɉen, na' par nic̱h əse'enene' xtiža'anə' na' cui se'eɉni'ine'en. ");
INSERT INTO zavNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Na' ca naquə jempl nga zeɉen quinga: Ca de'en byažən' naquən xtižə' Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","De'en ɉəsə'əchaz cho'a nezən' zeɉen ca beṉə' ca' chse'ene xtižə' Diozən' pero na' ḻe'e chžinte gwxiye'enə' chebeɉən xtižə' Diozən' ḻo'o yic̱hɉla'aždaoga'aque'enə' par nic̱h cui so'onḻilaže'ene' na' cui yesyə'əchoɉe' xni'a de'e malən'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Na' de'e ca' besə'əgo'oṉ gan' naquə lao yeɉ gwxaquə'əleben ca beṉə' ca' chəsyə'əbei choso'ozenag xtižə' Diozən'. Pero zɉənaque' ca to de'e cui bi ḻoi chon, šložga chse'eɉḻe'e c̱he xtižə' Diozən'. Na' catə' chac bi de'e mal c̱hega'aque' ḻe'e chəsə'əbeɉyic̱hɉte'en cuich choso'ozenague' c̱hei. ");
INSERT INTO zavNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Na' de'e ca' besə'əgo'oṉən lao yo ga nc̱hix̱ə xsa yešə' zeɉen ca beṉə' ca' bazɉənenene' xtižə' Diozən'. Pero lao zɉəmbanga'aque' chesyə'əlaḻ chesyə'əžeɉene', na' chse'enene' yesə'əni'e, na' chəsə'əde' ḻegr. Na' de'e quinga chso'one'enə' choso'oḻolə'ən xtižə' Diozən' de'en bayo'o yic̱hɉla'aždaoga'aque'enə', na' de'e na'anə' cui chso'onḻilaže'ene' can' cheyaḻə'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na' de'e ca' besə'əgo'oṉən lao yo ša'onə' zeɉen ca beṉə' la'aždao' güen ca' catə'ən chse'enene' xtižə' Diozən' chəsə'əzi'en chso'onen c̱hega'aque'. Na' chso'onḻilaže'ene' na' chesə'əgo'o chesə'əc̱heɉlaže'e len bitə'ətezə de'en chac c̱hega'aque' par chso'one' can' chene'e Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Na' Jeso'osən' bsaquə'əlebene' de'en bsed əblo'ine'enə' ca to yi', gwne': ―Notono no guaḻə' to yi' na' gwdose'en to žomə na' nic no gwcuašə'ən xan xcamei. Syempr chde'e yi'inə' ḻe'e ze'e par nic̱h əgwse'eni'in len yoguə' beṉə' so'o lo'o cuartən'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Guaquə can' na dicho de'en na: “Yoguə'əḻoḻ de'en ngašə' ṉa'a, gwžin ža la'alaon, na' yoguə'əḻoḻ de'en cui no gwse'eɉni'i antslə, leczə gwžin ža se'eɉni'i beṉə' ḻen.” ");
INSERT INTO zavNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","De'e na'anə' ḻe'e co'o yic̱hɉle de'en chnia' le'e, c̱hedə' la' šə chzenagle xtiža'anə' əgwzeɉni'ichda' le'e. Pero na' šə bito chzenagle c̱hei, de'e daon' baṉezele ganḻažə'əlen. ");
INSERT INTO zavNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Na' xna' Jeso'osən' len beṉə' biše'e ca' besə'əžine' gan' zo Jeso'osən' na' gwsa'aclaže'e yesə'ədie' pero tant beṉə' zan ža' caguə goquə yesə'əžine' gan' zoe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Na' gwnitə' beṉə' gwse'e Jeso'osən': ―Xna'on len beṉə' bišo'o ca' zɉəzeche' na'ate, na' chse'enene' əso'elene' le' dižə'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nach Jeso'osən' gože' ḻega'aque': ―Beṉə' ca' choso'ozenag xtižə' Diozən' na' chso'one' can' nan, lenczəga'aque'enə' zɉənaque' xna'a na' biša'a. ");
INSERT INTO zavNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Na' gozac to ža Jeso'osən' gwyo'e to ḻo'o barcw len disipl c̱he' ca', na' gože' ḻega'aque': ―Eḻaguə'əcho yešḻa'alə nisda'onə'. Nach boso'ose'e barcon'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Lao zda barcon' gwtas Jeso'osən'. Na' gwzolao gwyec̱hɉ to be' gual lao nisda'onə' na' barcon' gwzolao gwyožən nisən' na' besə'əxožene' yesə'əbiayi'e. ");
INSERT INTO zavNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nach bosyo'osbane' Jeso'osən' gwse'ene': ―¡Maestr! ¡Maestr! ¡Bac̱h chbiayi'icho! Nach catə' gwyase' ṉe'e chas chatə' nisda'onə' na' gwdiḻe'en len be'enə', na' ḻe'e gosə'əbe'ežiten. ");
INSERT INTO zavNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Na' gože' ḻega'aque': ―Cheyaḻə' šeɉḻe'echle c̱hia'. Nach ḻega'aque' besə'əžebe' na' besyə'əbanene' na' gwse' lɉuežɉe': ―Bitolɉa naquə benga con to beṉac̱hzə, la' ¿nacxa gon to beṉac̱h par yebecžie' be' gualən' len nisda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Na' besə'əžine' laž beṉə' Gadara ca', to yež de'e chi' delant Galilean' əḻaguə'əcho nisda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Na' catə' bechoɉ Jeso'osən' ḻo'o barcon', to beṉə' lao' syodan' ɉəšague' le', beṉə' bagwža yo'o yaz de'e x̱io' ca' yic̱hɉla'aždaogüe'en. Na' chde' con cui bi bi xe' chazəche', na' bitoch zoe' yo'o, con bazoe' do capsant. ");
INSERT INTO zavNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Na' beṉə' gwlaž c̱he' ca' boso'oc̱heɉe' ṉi'a ne'e ca gden na' gwsa'ape'ene', pero zan las de'e x̱io' ca' gwso'onən ca bzoxɉ btine' gdenṉə' na' ḻeczə gwso'onən ca gwyeɉe' gan' cui no beṉə' zɉənḻa'. Na' be'enə' catə' ble'ine' Jeso'osən' na' bzo xibe' laogüe'enə' na' de'e x̱io' ca' boso'ogosya'an ḻe', zižɉo gosə'ənan: ―Partlə le', partlə neto', Jeso'os. Naco' Xi'iṉ Dioz ben' naquə ḻe'ezelaogüe beṉə' blao. Chatə'əyoito' le' cui əgwc̱hi' əgwsaco'o neto'. De'e x̱io' ca' gosə'ənan ca' c̱hedə' Jeso'osən' bene' mendad yesyə'əchoɉən ḻo'o yic̱hɉla'aždao' be'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nach Jeso'osən' gožga'aquen': ―¿Bi lele? Na' gosə'ənan: ―Legion leto'. Gosə'ənan ca' c̱hedə' zanən gwso'on yic̱hɉla'aždao' be'en'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Na' de'e x̱io' ca' gwsa'atə'əyoin Jeso'osən' cui gone' ca žɉəsyə'ədebən ḻo'o yech gabiḻən'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na' to ya'a de'e zo gaḻə'əzə chaš beṉə' choso'oye' coš zan. Nach de'e x̱io' ca' gwsa'atə'əyoin ḻe' par güe'e latɉə žɉesyə'əžo'on yic̱hɉla'aždao' coš ca'. Na' Jeso'osən' be'e latɉə. ");
INSERT INTO zavNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nach besyə'əchoɉ de'e x̱io' ca' yic̱hɉla'aždao' be'enə' na' ɉəsyə'əžo'on yic̱hɉla'aždao' coš ca'. Na' besyə'ədinses coš ca' ḻe'e ya'anə' na' ɉesyə'əxopəb ḻo'o nisda'onə', na' gwsa'atəb gwse'eɉəb nisən'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Na' beṉə' ca' choso'oye coš ca' besə'əle'ine' de'en bagoquən' na' de'en besə'əžebchgüe' besa'acdoe' nach ɉesyə'ədix̱ɉue'ine' beṉə' lao' syodan', na' beṉə' nitə' do yoba can' bagoquən'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Na' beṉə' ca' catə' gwse'enene' xtižə' beṉə' goye coš ca' ɉa'aque' ɉəsə'əgüie' de'en bagoquən'. Na' catə' besə'əžine' gan' zo Jeso'osən', besə'əle'ine' be'enə' gwyo'o gwyaz de'e x̱io' ca' yic̱hɉla'aždaogüe'enə' bachi'e gaḻə'əzə cuit Jeso'osən', nyaz xalane'e, na' babezošao' yic̱hɉla'aždaogüe'enə'. Na' besə'əžebe' de'en goquən'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Na' beṉə' ca' besə'əle'i de'en goquən' gwse'e beṉə' ca' yeḻa' can' beyaque ben' gwyo'o de'e x̱io' ca' yic̱hɉla'aždaogüe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nach yoguə'əḻoḻ beṉə' ca' ža' gan' mbane Gadaran' ɉse'etə'əyoine' Jeso'osən' yeze'e lažga'aque'enə' c̱hedə' besə'əžebchgüe'. Nach beyo'o Jeso'osən' ḻo'o barcon' par beze'e. ");
INSERT INTO zavNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Na' ben' bechoɉ de'e x̱io' ca' yic̱hɉla'aždaogüe'enə' gotə'əyoine' Jeso'osən' šeɉlene' ḻe', pero Jeso'osən' bito be'e latɉə, gože'ene': ");
INSERT INTO zavNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Beyeɉ ližo' na' ɉəyedix̱ɉue'e catec de'e mban' baben Diozən' len le'. Na' beze'e, nach ɉəyede' doxen lao syodan' ɉəyezenene' catec de'e mban' baben Jeso'osən' len le'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Na' catə' bežin Jeso'osən' Capernaunṉə' beṉə' zan banitə' chəsə'əbeze'ene' na' besyə'əbeichgüeine' de'e bežine'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Na' bžin to beṉə' le Jairo, ben' naquə beṉə' gwnabia' c̱he yo'odao' c̱he beṉə' Izrael ca'. Na' bzo xibe' lao Jeso'osən' gotə'əyoine' ḻe' šeɉlene' ḻe' liže'enə' ");
INSERT INTO zavNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","c̱hedə' bazon gat bi'i no'ol c̱he'enə'. Nacbo' bi'i tlišə'əzə na' šižiṉ izgueibo'. Na' lao zda Jeso'osən' len ḻe', beṉə' zan gosə'əbiadi'ene' xte boso'oc̱hi'ižoɉene'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na' len to no'olə bagoc šižiṉ iz chzoe' bgua'a na' babenditɉei zgade xmechen' len beṉə' güen rmech ca'. Na' notono goquə gon ḻe' rmech. ");
INSERT INTO zavNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Na' bgüiguə' no'olən' cožə' Jeso'osən' na' gwdane' lox xadoṉ c̱he'enə', na' ḻe'e gwlezte bgua'a de'en chzo'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Na' gož Jeso'osən' beṉə' ca' zɉa'aclen ḻe': ―¿Non' bagwdan nada'? Na' yogue'e bito gosə'əc̱hebe' de que gosə'əgane' ḻe'. Nach Bedən' len beṉə' ca' zɉa'aclen Jeso'osən' gwse'ene': ―Maestr, beṉə' zan ža' nga, na' chesə'əc̱hi'ižoɉe' le'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nach Jeso'osən' gože' ḻega'aque': ―To beṉə' bagwdane' nada'. Na' chacbe'ida' de que beyaquene' len yeḻə' guac c̱hia'anə'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nach no'olən' catə' gocbe'ine' de que cabi bgašə' de'en bene'enə', bgüigue'e lao Jeso'osən' do chaž chžebe', na' bzo xibe' laogüe'enə' be'e dižə' lao yoguə' beṉə' ca' ža'anə' bixc̱hen' gwdane'ene' na' can' goquə ḻe'e beyacteine'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nach gož Jeso'osən' no'olən': ―Xi'iṉdaogua'a, babeyacdo' c̱hedə' chonḻilažo'o nada'. Beyeɉ to šao' to güen. ");
INSERT INTO zavNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ṉe'e cho'ete Jeso'osən' dižə'ən ca' catə' bžin to beṉə' gwza' liž Jairon' ɉeže'ene': ―Bagot bi'i no'ol dao' c̱hio'onə'. Bitoch gondo' maestrən' zed. ");
INSERT INTO zavNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero na' catə' bene Jeso'osən' dižə'ənə' gože' Jairon': ―Bito žebo'. Con benḻilažə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Na' catə' besə'əžine' liž be'enə' Jeso'osən' bito be'e latɉə so'o beṉə' ca' zɉa'aclen ḻe' sino Bedən' len Juanṉə' len Jacobən' na' len x̱axna' bi'i guat na'azə. ");
INSERT INTO zavNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Na' bac̱h chacchgua scaṉdl c̱hedə' yoguə' beṉə' ca' ža'anə' chəsə'əbežchgüe', pero gož Jeso'osən' ḻega'aque': ―Bito cuežle. Bito nacbo' bi'i guat, con chtasbo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Na' gosə'əzi'ic̱hi'iže'ene' c̱hedə' zɉəṉezene' de que bagotbo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pero Jeso'osən' bex̱e'e na' bi'i no'olə guat da'onə' na' boḻgüiže'ebo' che'ebo': ―No'ol dao' beyas. ");
INSERT INTO zavNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nach bebambo' na' ḻe'e beyastebo'. Na' ben Jeso'osən' mendadən' əso'ebo' de'e gaobo'. ");
INSERT INTO zavNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Na' besyə'əbanchgüei x̱axna'abo'on, pero Jeso'osən' bene' mendad cui əso'e dižə' can' goquən'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jeso'osən' betobe' disipl c̱he' ca' šižiṉ na' bnežɉue' ḻega'aque' yeḻə' guac par nic̱h əsa'aque' yesyə'əbeɉe' de'e x̱io' zɉəyo'o zɉəyaz yic̱hɉla'aždao' beṉə', na' ḻeczə par nic̱h əsa'aque' yesyə'əyone' beṉə' chsa'acšene. ");
INSERT INTO zavNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Na' ḻeczə bene' mendad žɉəsə'ədix̱ɉui'e de que Diozən' ṉabi'e con notə'ətezə beṉə' soe' latɉə. Na' bene' mendad yesyə'əyone' no beṉə' güe'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Na' gože' ḻega'aque': ―Bito bi gox̱ə'əle tnezən'. Bito yeyilɉle garot gox̱ə'əle, nic gua'ale bsod, ni yet, ni mech, na' bito gua'ale c̱hopə xadoṉ. ");
INSERT INTO zavNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Na' gatə'ətezə əžinḻe na' no ližei šo'ole, na'atezə sole na' na'atezə əsa'acle par šeɉəchle. ");
INSERT INTO zavNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Na' gatə'ətezə yež əžinḻe ga cui yesə'əgüialaogüe' le'e, catə' yesa'acle yežən' əgwsi'iṉs ṉi'alen' par yežib bište de'en gwžianṉə'. Gonḻe ca' par nic̱h əgwlo'iga'aquelene' de que de'e malən' chso'one' cui choso'ozenague' xtižə' Diozən' de'en cho'ele. ");
INSERT INTO zavNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nach disipl ca' ɉa'aque' to to yež, ɉəsə'ədix̱ɉui'e dižə' güen dižə' cobən' na' besyə'əyone' no beṉə' güe'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Na' goberṉador Erodən' goquene' tolə catə' benene' yoguə'əḻoḻ de'en chon Jeso'osən' len disipl c̱he' ca'. Gocžeɉlaže'e c̱hedə' baḻə beṉə' gwse'ene' de que babeban de'e Juanṉə' ladɉo beṉə' guat ca' na' chone' de'e quinga. ");
INSERT INTO zavNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Na' yebaḻe' gwse'ene' de que profet Ḻiazən' babela' yežlyo nga de'e yoblə na' chone' de'e quinga. Yebaḻe' gosə'əne' de que to profet beṉə' gwzo cana'ate babebane' ladɉo beṉə' guat ca' na' chone' de'e quinga. ");
INSERT INTO zavNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Na' Erodən' gwne': ―Bena' mendad gosə'əc̱hogue' yen de'e Juanṉə', pero ¿noxa benga babenda' dižə' c̱hei? Na' gwdilɉlaže'e naclə gone' par le'ine' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Na' catə' besyə'əžin disipl ca' gan' zo Jeso'osən' gwse'ene' can' ɉse'ene'enə'. Na' gwc̱he'e ḻega'aque' partlə na' ɉa'aque' to latɉə gan' mbane syoda de'en nzi' Betsaida. ");
INSERT INTO zavNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Catə' gwsa'acbe'i beṉə' ca' nitə' gan' gwzo Jeso'osən' de que bagwze'e len disipl c̱he' ca' nach ɉəsə'ənaogüe' ḻega'aque'. Jeso'osən' bebeine' bgüialaogüe' ḻega'aque' na' bsed blo'ine' de que Diozən' ṉabi'e con notə'ətezə beṉə' soe' latɉə. Na' beyone' beṉə' ca' chsa'acšene. ");
INSERT INTO zavNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Catə' gwzolao chxoa bgüižən' nach disipl ca' šižiṉ gwse'e Jeso'osən': ―Bseḻə' beṉə' quinga yež ca' de'en nyec̱hɉ mbi'i nga par yesə'əyilɉe' gan' yesə'ətase' na' par nic̱h yesə'əželene' de'e se'eɉ əsa'ogüe' c̱hedə' latɉə gan' zocho nga naquən to ga cui no nḻa'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero na' gož Jeso'osən' ḻega'aque': ―Ḻe'e gwnežɉo de'e sa'ogüe'. Na' gwse'ene': ―Gueyə'əga yetxtil na' c̱hopga beḻ ya'a de c̱hecho. Lete šə si'ichchon par gaquen əsa'o yoguə' beṉə' quinga. ");
INSERT INTO zavNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Gosə'əne' ca' c̱hedə' la' ža' ca gueyə' mil beṉə' byo. Nach Jeso'osən' gože' disipl c̱he' ca': ―Le'e gon mendad yesə'əbe' šiyon güeɉə beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nach disipl ca' gwso'one' mendad yesə'əbe' yoguə' beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Na' Jeso'osən' gwxi'e gueyə' yetxtilən' na' c̱hopə beḻ ya'anə', na' bgüie' yobalə be'e yeḻə' chox̱cwlen c̱he Diozən', na' bzoxɉe'en na' bnežɉue'en disipl c̱he' ca' par gwso'e c̱he c̱he beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Na' yogue'e gwsa'ogüe'en xte ca gwse'elɉene'. Nach pedas ca' besyə'əga'aṉən' bosyo'otobe'en, na' gwsa'aquən šižiṉ žomə. ");
INSERT INTO zavNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Na' gozac yeto nitə' disipl c̱he' ca' len ḻe' na' Jeso'osən' chone' orasyon toze'. Nach gože' ḻega'aque': ―¿Bin' chəsə'əna beṉə' zan ca', non' naca' nada'? ");
INSERT INTO zavNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Na' gwse'e ḻe': ―Baḻe' chəsə'əne' naco' de'e Juan ben' bc̱hoa beṉə' nis, na' yebaḻe' chəsə'əne' de que naco' profet Ḻiazən' ben' gwzo cana', na' yebaḻe' chəsə'əne' de que naco' yeto profet beṉə' gwzo cana'ate na' ḻe'enə' babeban ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nach gože' ḻega'aque': ―¿C̱hexa le'e? ¿bi nale? ¿non' naca'? Nach gož Bedən' ḻe': ―Len' naco' Crist ben' gwleɉ Diozən' par gaquəleno' ṉasyon c̱hechon'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nach Jeso'osən' bene' mendad len ḻega'aque' de que ni toe' cui əso'e dižə' de que ḻen' naque' Cristən' ben' gwleɉ Diozən' par gaquəlene' ṉasyon c̱hega'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Na' gože' ḻega'aque': ―Nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. Na' de'e zan de'e chonən byen c̱hi' saca'a. Na' ca naquə beṉə' golə blao c̱he ṉasyon Izrael c̱hechon' na' beṉə' blao c̱he bx̱oz c̱hecho ca' na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən', cabi se'eɉḻe'e c̱hia', na' so'ote' nada', pero na' yeyoṉ ža yosban Diozən' nada' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nach gože' yoguə' disipl c̱he ca': ―Notə'ətezle šə chene'ele gonḻilažə'əle nada' na' gwzenagle c̱hia', cheyaḻə' əchoɉyic̱hɉle de'en chene'ele gon cuinḻe par nic̱h gonḻe con can' chene'e Diozən', na' bito bi gaquele c̱he de'en c̱hi' saquə'əle, ḻa'aṉə'əczə šə so'ot beṉə' le'e to ḻe'e yag coroz, con gonḻilažə'əle nada' na' gwzenagle c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Notə'ətezle chaquele gonḻe par nic̱h cui c̱hi' saquə'əle o par nic̱h cui no so'ot le'e, cuiayi'ile. Na' notə'ətezle chsanḻažə' cuinḻe c̱hi' saquə'əle o so'ot beṉə' le'e por ni c̱hia' bade yeḻə' mban zeɉḻicaṉe c̱hele. ");
INSERT INTO zavNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bito bi de'e güen gaquə c̱he to beṉə' ḻa'aṉə'əczə ṉabi'e doxen yežlyon' šə cuiayi'e cui gatə' yeḻə' mban c̱he' zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Notə'ətezle šə cheto'ile c̱hia' na' c̱he xtiža'anə', ḻeczə ca' nada' yeto'ida' c̱hele, nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. Yeto'ida' c̱hele catə'ən yida' de'e yoblə nsa'a yeḻə' chey che'eni' c̱hia'anə' na' yeḻə' chey che'eni' c̱he X̱a' Diozən', na' yeḻə' chey che'eni' c̱he angl c̱he Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Echnia' de que baḻle cabiṉə' gatle catə' le'ile can' gon Diozən' əgwlo'e yeḻə' gwnabia' c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Na' goc to xman gwna Jeso'osən' ca', gwyeɉe' to lao ya'a ɉene' orasyon, na' gwc̱he'e Bedən' len Juanṉə' na' Jacobən'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Na' lao bene' orasyonṉə' goc cho'alaogüe'enə' ca de'e chey che'eni', na' xalane'enə' beyaquən šyiš xilə' xte gwṉatitən. ");
INSERT INTO zavNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Na' lao or na' de'e Moisezən' len profet Ḻiazən' ben' gwzo cana' besyə'əžine' gan' zo Jeso'osən' na' Jeso'osən' be'elene' ḻega'aque' dižə'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Gwso'e dižə' ca naquən' bazon gate' Jerosalenṉə'. Na' yeḻə' chey che'eni' c̱he Diozən' gwyec̱hɉən ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Na' Bedən' len beṉə' ca' yec̱hopə ḻechguaḻe gwsa'ac šə tasga'aque'. Pero catə' bechoɉ bišgal c̱hega'aque'enə' besə'əle'ine' Jeso'osən' len yeḻə' chey che'eni' c̱he'enə', zeche' cho'elene' de'e Moisezən' len profet Ḻiazən' dižə'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Na' žlac besyə'əṉitlao de'e Moisezən' len profet Ḻiazən', Bedən' gože' Jeso'osən': ―Maestr, güenchgua zocho nga ṉa'a. ¿Eguaquə gonto' šoṉə ranš, ton par le', na' yeton par Moisezən', na' yeton par Ḻiazən'? Gwne' ca' c̱hedə' bito bene' xbab c̱he de'en gwne'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Na' lao gwne' ca' gwyec̱hɉ beɉon' ḻega'aque' na' besə'əžebe' laogüe de'en goc ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Na' gwse'enene' gož Diozən' ḻega'aque': ―Bengan' xi'iṉa', ben' chacchgüeida' c̱hei. C̱he ḻe'enə' ḻe'e gwzenag. ");
INSERT INTO zavNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Na' catə' beyož gož Diozən' ḻega'aque' ca', besə'əle'ine' yetozə Jeso'osən'. Na' ca tyemp na' bitobi dižə' gwso'elene' yeziquə'əchlə beṉə' ca naquə de'en bagwse'en besə'əle'ine'enə'. Con gwnitə'əteze' žizə c̱he de'e ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Na' beteyo catə' bac̱h besyə'əyetɉe' ya'anə', ɉəsə'əšag beṉə' zan ḻega'aque' gan' nite'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Na' entr beṉə' zan ca' toe' gwṉe' zižɉo na' gože' Jeso'osən': ―Maestr, chatə'əyoida' le' gaquəlenšgo' xi'iṉa' nga, c̱hedə' nacbo' xi'iṉa' tlišə'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Chṉiz de'e x̱i'onə' ḻebo', na' ḻe'e chgosya'aten ḻebo', na' chonen par chazbo' šon xte chla' bžin' cho'abo', na' chonən ḻebo' zi', na' caṉe chechoɉən' ḻebo'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Bagotə'əyoida' disipl c̱hio' ca' par nic̱h yesyə'əbeɉe' de'e x̱i'onə' cho'o chaz yic̱hɉla'ažda'obo'onə', pero bito gwsa'aque' yesyə'əbeɉe'en. ");
INSERT INTO zavNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Na' Jeso'osən' gože' beṉə' ca' ža'anə': ―¿Bixc̱hexan' cui cheɉḻe'ele c̱hia'? Clellən' chonḻe na' nalɉele. Bachac sša zoa' napa' yeḻə' chxenḻažə' len le'e. ¿Batxan' šeɉḻe'ele c̱hia'? Nach gože' x̱a bida'onə': ―Doa' xi'iṉo' nga. ");
INSERT INTO zavNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na' lao zɉso'ebo' lao Jeso'osən' bṉiz de'e x̱i'onə' ḻebo', na' benən par nic̱h ḻechguaḻe fuert gwyazbo' šonṉə', na' bchix̱ btoḻən ḻebo' lao yon'. Na' Jeso'osən' gwdiḻe' de'e x̱i'onə' par nic̱h bechoɉən ḻo'o yic̱hɉla'ažda'obo'onə' na' beyaquebo'. Gwde na' beyone'ebo' lao na' x̱abo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Na' yogue'e besyə'əbanene' besə'əle'ine' yeḻə' guac c̱he Diozən'. Na' besyə'əbanene' c̱he yoguə' de'en chon Jeso'osən'. Na' lao nite'e ca', Jeso'osən' gože' disipl c̱he' ca'azə: ");
INSERT INTO zavNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Ḻegon par nic̱h dižə' nga šo'on yic̱hɉla'ažda'olen', c̱hedə' la' nada' gaca' lao na' beṉə', nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero na' disipl ca' bito gwse'eɉni'ine' dižə' de'en be' Jeso'osən' len ḻega'aque', c̱hedə' bito gože' ḻega'aque' clar bi zeɉen, na' besə'əžebe' par yesə'əṉabene' ḻe' bi zeɉen de'e gože' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Na' gwsa'acyožə disipl c̱he' ca' entr ḻega'aque' noe' naquə beṉə' blaoch. ");
INSERT INTO zavNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jeso'osən' gocbe'ine' xbab de'en gwso'one'enə' na' goxe' to bidao' na' bso'ebo' cuite'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Na' gože' ḻega'aque': ―Šə chonḻe güen len bidao' nga o len notə'ətezəchlə bidao' laogüe de'en chaquele c̱hia', chonczle güen len nada'anə'. Na' catə' chonḻe güen len nada', ḻeczə chonczle güen len Diozən' ben' bseḻə' nada'. Na' notə'ətezle catə' chonḻe xbab c̱he cuinḻe de que cuitec bi zaquə'əle, banaquəczle beṉə' blao. ");
INSERT INTO zavNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nach Juanṉə' gože'ene': ―Maestr, babežagto' to beṉə' cho'e la'onə' par chebeɉe' de'e x̱io' de'en yo'o yaz yic̱hɉla'aždao' beṉə', na' bžonto' gone' ca' c̱hedə' bito chone' txen len chio'o. ");
INSERT INTO zavNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nach Jeso'osən' gože'ene': ―Bito gwžonḻe gone' ca' c̱hedə' šə to beṉə' cui chone' contr chio'o, txenczən' chone' len chio'o. ");
INSERT INTO zavNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Na' laogüe bazon baozə par yezi' yeca'a Diozən' ḻe', gwc̱hoglaže'e šeɉe' Jerosalenṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Na' bseḻe'e to c̱hopə beṉə' gosə'əbialao laogüe'enə'. Na' ɉa'aque' to yež gan' mbane Samarian' par nic̱h žɉəsə'əsi'ini'e gan' so Jeso'osən' len disipl c̱he' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero beṉə' Samaria ca' bito besə'əgüialaogüe' ḻega'aque', c̱hedə' Jeso'osən' len disipl c̱he' ca' chɉa'aque' Jerosalenṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Na' disipl c̱he' ca' c̱hopə, Juanṉə' len Jacobən', catə' besə'əle'ine' can' gwso'on beṉə' Samaria ca' nach gosə'əṉabene' Jeso'osən' gwse'ene': ―Maestr, ¿əche'endo' gonto' can' ben profet Ḻiazən' ben' gwzo cana', əṉabeto' Diozən' əseḻe'e yi' par əgwzeyən beṉə' quinga? ");
INSERT INTO zavNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pero Jeso'osən' gwyec̱hɉe' na' gwdiḻe' ḻega'aque' gože': ―Le'e bito ṉezele non' chnabia' yic̱hɉla'ažda'olen'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","La' nada' bito bida' par əgwžiayi'a beṉac̱hən', sino bida' par nic̱h gona' ca cui žɉəya'aque' lao yi' gabiḻən', nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. Nach ɉa'aque' yež yoblə. ");
INSERT INTO zavNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Lao zɉa'aque'enə' to beṉə' gože' ḻe': ―Sa'alena' le' gatə'ətezə šeɉo'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nach gož Jeso'osən' ḻe': ―Zɉəde liž becoyo'o ca' na' ḻeczə ca' zɉəde liž bia ca' zo x̱ile'e bia chaš yoba, pero bito bi xlatɉa' de gan' gona' dezcanz, nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Na' Jeso'osən' gože' yeto beṉə': ―Denao nada'. Pero be'enə' gože' ḻe': ―X̱ana' be' latɉə zgua'atec yega'aṉlena' x̱a'anə' xte catə' əžin ža gate' par nic̱h əgwcuaša'ane'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Na' gož Jeso'osən' ḻe': ―Beṉə' ca' zɉənaquə len yic̱hɉla'ažda'oga'aquen' ca beṉə' guat guaquə yesə'əcuaše'e beṉə' guat ca'. Pero le' ɉətix̱ɉue'e de que Diozən' ṉabi'e con notə'ətezə beṉə' soe' latɉə. ");
INSERT INTO zavNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nach ḻeczə yetoe' gože' Jeso'osən': ―Sa'alena' le' X̱ana', pero zgua'atec be'ešga latɉə žɉəyezeida' famiḻy c̱hia' dižə'. ");
INSERT INTO zavNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jeso'osən' gože' ḻe': ―Beṉə' bagwzolao naogüe' nada' šə bito naogüe' do yic̱hɉ do laže'e, na' šə yo'o yic̱hɉe' c̱he de'e ca' bocua'aṉe', bito zaque'e par gone' xšin Diozən'. Na' gwxaquə'əlebene' ca to beṉə' chgüia traslə žlac chgua'aṉe' go'oṉ. ");
INSERT INTO zavNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Gwde de'e quinga, X̱anchon' gwleɉe' gyonši beṉə'. Na' bene' mendad yesə'əbialaogüe' əžɉa'ac c̱hopə güeɉe' to to syoda na' to to yež gan' ze'e šeɉ ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Na' antslə ze'e žɉa'aque' gože' ḻega'aque': ―De'en chona'anə' gwxaquə'əleben ca to cwseš xen de'en chotoba'. Na' chyažɉda' beṉə' zan sa'aclene' nada', pero to c̱hopgale nitə'. De'e na'anə' ḻeṉabe X̱ancho Diozən' əseḻə'əche' beṉə' zanch par əsa'aclene' chio'o c̱hix̱ɉue'echo xtiže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Na' ḻe'e gon xbab de que nadan' chseḻa'a le'e žɉətix̱ɉue'ile xtiža'an len beṉə' ca' gwxaquə'əlebe ca bež, na' le'e gwxaquə'əlebele ca xilə' dao' ladɉoga'aque'enə'. Can' chso'on bež ca' chso'otteb xilə' dao', ḻeczə can' se'ene beṉə' so'ote' le'e. ");
INSERT INTO zavNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bito gua'ale mech, ni xala'anḻe, ni xelle, na' bito šeile gan' əgguaple beṉə' diox beṉə' yežagle tnez. ");
INSERT INTO zavNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Na' notə'ətezə ližei šo'ole, zgua'atec əṉale: “Chṉablažə'əšga so cuezle binḻo len xbab de'en yo'o ḻo'o yic̱hɉla'ažda'olen', le'e nitə'əle nga.” ");
INSERT INTO zavNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Šə na' zo to beṉə' chene'ene' so cueze' binḻo len xbab de'en yo'o ḻo'o yic̱hɉla'aždaogüe'enə', na' gaquə can' bagwṉablažə'əle par so cueze' binḻo. Pero šə bito no zo no chon ca so cueze' binḻo len xbab de'en yo'o ḻo'o yic̱hɉla'aždaogüe'en, bito gaquə ca de'en bagwṉablažə'əlen'. ");
INSERT INTO zavNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Na' ḻe'e yo'o na'atezə yega'aṉle. Bito yeyilɉle ga yoblə sole. Ḻe'e ye'eɉ ḻe'e gao bitə'ətezə de'en so'oṉe' ye'eɉ gaole. Ca to beṉə' güen žin cheyaḻə' si'e laxɉue', ḻe'egatezə ca' le'e zaquə'əle par so'oṉe' de'e ye'eɉ de'e gaole. ");
INSERT INTO zavNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Na' catə' əžinḻe to yež ga əso'elaogüe'e le'e, ye'eɉ gaotezle de'en so'oṉe' le'e. ");
INSERT INTO zavNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ḻe'e yeyon beṉə' güe' nitə' yež gan' əžinḻen', na' ḻe'e ye'ega'aque': “Babžin ža chene'e Diozən' güe'ele latɉə ṉabi'e le'e.” ");
INSERT INTO zavNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero na' catə' əžinḻe to yež ga cui yesə'əgüialaogüe' le'e, ḻežɉa'ac lao lqueyən' na' ḻe'e ye'ega'aque': ");
INSERT INTO zavNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Bište c̱he lažle nga de'en žia ṉi'ato' quinga yosi'iṉsto'on par nic̱h əgwlo'ito' le'e de que de'e malən' chonḻe bito chzenagle xtižə' Diozən' de'en cho'eto'onə'. Pero na' chyix̱ɉue'ito' le'e de que Diozən' chene'ene' güe'ele latɉə ṉabi'e le'e.” ");
INSERT INTO zavNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na' gož Jeso'osən' beṉə' gyonši ca': ―Diozən' bene' par nic̱h byiṉɉ yi' na' sofr lao' syoda Sodoman' por ni c̱he de'en cui boso'ozenag beṉə' ca' c̱he'. Na' de'e ḻi əchnia' le'e, žan' gaquə juisyən' beṉə' ca' cui yoso'ogüialao le'e yesə'əzaquə'əzi'iche' clezə ca beṉə' ca' gwnitə' Sodoman'. ");
INSERT INTO zavNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Nach gozna Jeso'osən': ―¡Probchguazə le'e beṉə' Corazin! ¡Probchguazə le'e beṉə' Betsaida! Beṉə' ca' nitə' Tiro na' Sidon ḻe'e besyə'ədiṉɉteine' xtoḻə'əga'aque'enə' žalə' blo'iga'acda'ane' yeḻə' guac c̱hia'anə' ca de'en bablo'ida' le'e. Žalə' goquə ca' sa'azlɉe' lachə' zešə' na' zosə'əža'alɉa cuinga'aque' de par nic̱h sa'acbe'i beṉə' de que babesyə'ədiṉɉene' xtoḻə'əga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Saquə'əzi'ichle clezə ca beṉə' ca' nitə' Tiro na' Sidon catə' əžin ža gaquə juisyən'. ");
INSERT INTO zavNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Le'e nitə'əle Capernaunṉə' chonḻe xbabən' de que Diozən' goṉchgüe' le'e yeḻə' bala'aṉ. Pero bito goṉe' le'e yeḻə' bala'aṉ, sino goṉe' le'e castigw zeɉḻicaṉe de'en cui cheɉḻe'ele c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nach Jeso'osən' goze'e beṉə' gyonši ca': ―Beṉə' gwzenag xtižə'əlen' ḻeczə gwzenague' xtiža'anə', na' beṉə' gonczə yic̱hɉlaogüe cui gwzenague' xtižə'əlen', ḻeczə bito gwzenague' c̱hia' nada'. Na' beṉə' gonczə yic̱hɉlaogüe cui gwzenague' xtiža'anə', ḻeczə bito gwzenague' xtižə' Diozən' ben' bseḻə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Beṉə' gyonši ca' catə' beyož ɉəsə'ədix̱ɉui'e xtižə' Jeso'osən' besyə'əžine' gan' zoe', na' besyə'əbeichgüeine'. Nach gwse'e Jeso'osən': ―X̱anto', de'e zan miḻagr babento' cho'eto' la'onə' par chebeɉto' de'e x̱io' ca' de'en zɉəyo'o zɉəyaz yic̱hɉla'aždao' beṉə' na' choso'ozenaguən c̱heto'. ");
INSERT INTO zavNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Na' gože' ḻega'aque': ―Ble'ida' can' gwnit yeḻə' gwnabia' c̱he Satanasən' to žalṉez. ");
INSERT INTO zavNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Babeṉa' le'e yeḻə' guac par nic̱h əgwleɉ əgwšošɉle no beḻ əznia' na' no bex̱goni', na' ḻeczə əgwleɉ əgwšošɉle gwxiye'enə'. Na' bito bi de de'e soi gonen le'e zi'. ");
INSERT INTO zavNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero bito yebeitequele de que de'e x̱io' ca' choso'ozenaguən c̱hele, sino ḻe'e yebeichgüei de que Diozən' babzoɉe' lalen' ḻe'e ḻibrən' gan' zɉənyoɉ la yoguə'əḻoḻ xi'iṉe' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lao or na'atezə ben Spirit c̱he Diozən' ca bebeichgüei Jeso'osən'. Na' bene' orasyon lao Diozən', gwne': ―X̱a' len' chnabi'o beṉə' ca' ža' yoban' na' yežlyon'. Na' choṉa' yeḻə' chox̱cwlen c̱hio' de que babzeɉni'ido' baḻə beṉə' can' che'endo' so'e latɉə ṉabi'o yic̱hɉla'ažda'oga'aque'enə'. Babzeɉni'ido'on beṉə' ca' gwsa'acbe'i chəsə'əyažɉene' no əgwsed əgwlo'i ḻega'aque' na' bito bzeɉni'ido'on beṉə' ca' chso'on xbab de que zɉənaque' beṉə' sin' na' beṉə' zɉənyeɉni'i. Beno' ca' ža X̱a, c̱hedə' can' gwyazlažo'o. ");
INSERT INTO zavNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nach gože' beṉə' ca' ža'anə': ―X̱a'anə' babene' lao na'a chona' par nic̱h chombia' beṉə' ḻe'. Ḻe' nombi'ayaṉe'e nada' na' nada' nombi'ayaṉa'a ḻe'. Na' beṉə' ca' bagwleɉa' par zɉənombi'e X̱a'anə', chona' par nic̱h zɉənombi'ene'. Na' notono no nochlə zɉənombia' X̱a'anə' na' ni nada'. ");
INSERT INTO zavNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Na' gwyec̱hɉ Jeso'osən' bgüie' disipl c̱he' ca' na' gože' ḻega'acze': ―Mbalaz zole ca de'en chle'ile nada' na' chle'iteile de'e ca' chona'. ");
INSERT INTO zavNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Echnia' le'e, beṉə' zan profet na' rei gwse'enene' yesə'əle'ine' nada', pero bitoch goḻə' yesə'əle'ine' nada'. Na' gwse'enene' yesə'əṉezene' de'en ṉezele, pero bitoch goḻə' yesə'əṉezene'en. ");
INSERT INTO zavNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Na' gwzecha to beṉə' chsed chlo'i ḻei de'en bzoɉ de'e Moisezən'. Gone'ene' gone' Jeso'osən' prueb bin' əṉe' na' gože'ene': ―Maestr, ¿bi cheyaḻə' gona' par nic̱h gatə' yeḻə' mban zeɉḻicaṉe c̱hia'? ");
INSERT INTO zavNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Na' gož Jeso'osən' ḻe': ―¿Bin' nyoɉən ḻe'e ḻein'? ¿Nac nan? ");
INSERT INTO zavNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Na' ben' cheɉni'ichgüei c̱he ḻein' boži'e xtižə' Jeso'osən' gože'ene': ―Ḻei c̱hechon' nan: “Cheyaḻə' gaquecho c̱he X̱ancho Diozən' do yic̱hɉ do lažə'əcho, do fuers balor c̱hecho, na' gaquecho c̱he lɉuežɉcho catg chaquecho c̱he cuincho.” ");
INSERT INTO zavNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nach gož Jeso'osən' ḻe': ―De'e ḻiczə can' bagwnao'. Can' cheyaḻə' gono' par əbano' zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Na' be'enə' gone'ene' əgwlo'e de que zdacze' ḻicha can' nanṉə' na' gože' Jeso'osən': ―¿Non' naquə lɉuežɉa' ben' cheyaḻə' gaquəda' c̱hei? ");
INSERT INTO zavNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Na' Jeso'osən' gože'ene': ―To beṉə' beze'e Jerosalenṉə' par yežine' Jerico na' ɉəsyə'əxen beṉə' bguan ḻe'. Na' gosə'əyiṉe' xala'ane'enə' na' gwso'ot gosə'əyine' ḻe' nach besa'aque' bosyo'ocua'aṉe'ene' caczə to beṉə' guat. ");
INSERT INTO zavNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Na' goquən' to bx̱oz gwdie' tnezən' na' catə' ble'ine' ben' de'enə', nach gwdie' yešḻa'alə nezən'. ");
INSERT INTO zavNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ḻeczə can' ben to beṉə' golɉə lao dia c̱he de'e Lebin'. (Beṉə' ca' yo'o lao na'aga'aque' so'one' mendad ḻo'o yo'odao' əblaonə'.) Zde' tnezən' na' catə' bžine' gan' ble'ine' de be'enə' na' gwdie' yešḻa'alə nezən'. ");
INSERT INTO zavNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero to beṉə' Samaria lao ngüe'e nezən' nḻague' xporren' bžine' gan' de be'enə' na' ca ble'ine' ḻe' beyašə'əlaže'ene'. ");
INSERT INTO zavNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Na' bgüigue'e gan' de'enə', na' bšone' set na' bino lao güe'enə', na' bc̱heɉe'en lachə'. Nach božie'ene' cožə' xporre'enə'. Na' bec̱he'ene' gan' zo to meson gan' bgüia bye'ene'. ");
INSERT INTO zavNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Na' beteyo gwleɉe' c̱hopə mech de'en nzi' denario bnežɉue'en x̱an mesonṉə' na' gože'ene': “Bgüia bye benga na' šə bichlə de'en gono' gast na' c̱hixɉua'an catə' zeza'a.” ");
INSERT INTO zavNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Beyož be' Jeso'osən' dižə' can' goc c̱he ben' ɉəsyə'əxen beṉə' bguan ca', nach gože' ben' chsed chlo'i ḻein': ―¿Bi chacdo'? ¿noe' beṉə' ca' goquene' de que beṉə' probən' naquə lɉuežɉe' ben' cheyaḻə' gaquene' c̱hei? ");
INSERT INTO zavNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nach ben' chsed chlo'i ḻein' gože' Jeso'osən': ―Ben' beyašə' beži'ilažə' ben' ɉəsyə'əxen beṉə' bguan ca'. Nach gož Jeso'osən' ḻe': ―Ḻeczə can' cheyaḻə' gono' dezd ṉa'a, yeyašə' yeži'ilažo'o yoguə'əḻoḻ beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Na' lao zɉa'aque' besyə'əžine' to yež, na' to no'olə le Mart bene' ḻe' combid na' Jeso'osən' gwyeɉe' liže'en. ");
INSERT INTO zavNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Na' zo to bile' le' Maria. Na' Marian' gwchi'e cuit Jeso'osən' par bzenague' xtiže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero na' Martən' belaḻchgüeine' bsi'ini'e de'en sa'ogüe'. Na' gwyeɉe' lao Jeso'osən' na' gože'ene': ―X̱ana', ¿əcabi bi chacdo' de que bila'anə' bocua'aṉlene' nada' mendadən' toza'? Benšga mendad gaquəlene' nada'. ");
INSERT INTO zavNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","X̱anchon' gože' ḻe': ―Mart, chi'ichgua yic̱hɉo' c̱he xmendado'onə' na' chacžeɉlažo'o laogüe de'en nyanchguan. ");
INSERT INTO zavNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Maria nga bagwleɉe' de'en naquəch de'e güen, chi'ichgua yic̱hɉe' chzenague' c̱hia'. Na' bito gwžoncho gone' ca'. Ḻezən de'en žialao gonḻe. ");
INSERT INTO zavNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Na' gwzo Jeso'osən' to latɉə bene' orasyon. Catə' beyož bene' orasyonṉə' to disipl c̱he' ca' gože'ene': ―X̱anto', bsed blo'išguei neto' naquən' cheyaḻə' gonto' orasyonṉə', can' bsed əblo'i de'e Juanṉə' disipl c̱he' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Na' Jeso'osən' gože' ḻega'aque': ―Catə' gonḻe orasyonṉə' quingan' ṉale: X̱ato' beṉə' zo yoba, chṉabto' yoguə'əḻoḻ beṉə' əso'elaogüe'e le'. Chṉabto' gono' par nic̱h beṉə' zan əso'e latɉə ṉabi'o ḻega'aque'. Gaquəšga can' che'endo'onə' lao yežlyo nga can' chac yoban'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Benšga ṉa'a de'e gaoto' tža tža. ");
INSERT INTO zavNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Na' bezi'ixenšga c̱heto' c̱hedə' ḻeczə neto' chezi'ixento' c̱he sa'alɉuežɉ beṉac̱hto'onə' bitə'ətezə de'e chso'onene' neto'. Na' bito go'o latɉə gaquə de'e ṉabia' neto' len xbab c̱heto'onə' par gonto' de'e malən', mas bcuasə' bcue'eɉ neto' len de'e malən'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nach gož Jeso'osən' ḻega'aque': ―Ḻegon xbab nac gaquə šə šeɉle liž beṉə' migw c̱hele do chel na' ye'elene': “Migw c̱hia', beṉšga nada' šoṉə yetxtil. ");
INSERT INTO zavNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Babla' to migw c̱hia' beṉə' za' zitə', na' bito bi de c̱hia' par əgwnežɉua'ane' gaogüe'.” ");
INSERT INTO zavNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Na' migw c̱helen' yo'e ḻo'o yo'ote šə yoži'e xtižə'əlen', əṉe': “Bito gondo' nada' zed, la' banyeyɉw puertən' na' badeto' chtasto' len xi'iṉto'. Bito c̱hasa' par goṉa' de'en chyažɉdo'.” ");
INSERT INTO zavNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Echnia' le'e, ḻa'aṉə'əczə naque' migw c̱hele bito yene'ene' c̱hase' par goṉe' le'e yetxtilən', pero šə sole yepəyoe ṉabelen ḻe' na' gwyasšaze' na' goṉe' bitə'ətezə de'en chyažɉele. ");
INSERT INTO zavNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Na' chnia' le'e, bitə'ətezə de'en chene'echo gaquə, de de'e goncho par nic̱h gaquən. Šə to de'e chene'echo so'oṉ beṉə' chio'o, chṉabchon. Šə to de'e chene'echo əželecho, chyilɉchon. Šə puert de'en chene'echo əsalɉo beṉə', chṉecho cho'a puertən' par nic̱h chsalɉue'. Na' ca'aczən' cheyaḻə' ye'echo Diozən' catə'ən de de'en chene'echo gaquə. ");
INSERT INTO zavNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Na' notə'ətezcho šə bi de'en chṉabechone' goṉe', la' de'e goṉcze'enə'. Na' notə'ətezcho šə bi de'en chṉabechone' əgwzeɉni'ine' chio'o, gwzeɉni'iczene'en. Na' notə'ətezcho šə chṉabechone' gaquə to de'en chene'echo gaquə can' chon beṉə' chṉe' cho'a puertən', la' de'e gaquəczən'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Na' le'e nacle x̱a bidao', šə xi'iṉlen' əṉabebo' le'e yetxtil ¿əgwnežɉwlebo' to yeɉ? Na' šə əṉabebo' le'e to beḻ ya'a ¿əgwnežɉwlebo' to beḻ bia nxobə ḻe'i? ");
INSERT INTO zavNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Na' šə əṉabebo' le'e to žit gaobo' ¿əgwnežɉwlebo' to bex̱goni'? Cle bito gonḻe ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Le'e nacle beṉə' mal pero ṉezele chnežɉwle xi'iṉlen' de'e güen. Naquəchxe güen gon X̱acho Diozən' ben' zo yoban' goṉe' Spirit c̱he'enə' son ḻo'o yic̱hɉla'aždao' notə'ətezcho əṉabechone' ḻen. ");
INSERT INTO zavNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Na' Jeso'osən' bebeɉe' de'e x̱io' yo'o yaz yic̱hɉla'aždao' to beṉə' mod. Na' catə' bechoɉ de'e x̱i'onə' yic̱hɉla'aždao' be'enə', goc beṉe', na' beṉə' ca' ža'anə' besyə'əbanchgüeine'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero baḻe' gosə'əne': ―Chebeɉe' de'e x̱io' ca' len yeḻə' guac c̱he Beelsebo de'en chnabia' de'e x̱io' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Na' yebaḻe' gwse'enene' so'one' ḻe' prueb naclən' gone', gosə'əṉabene' ḻe' gone' to de'e yesə'əle'ine' ḻe'e yoban' de'e zaquə' yesyə'əbanene'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero Jeso'osən' gocbe'ine' xbab de'en gwso'one', na' gože' ḻega'aque': ―Šə beṉə' ža' to ṉasyon əsa'aque' c̱hoplə na' yesyə'ədiḻe' entr ḻega'aque', əgwžiayi' ṉasyon c̱hega'aque' na'anə'. Na' šə to famiḻy beṉə' əsa'aque' c̱hoplə na' yesyə'ədiḻe' entr ḻega'acze', ḻeczə yenit famiḻy c̱hega'aque' na'anə'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Na' ḻeczə šə Satanasən' len de'e x̱io' c̱hei ca' əsa'aquən c̱hoplə na' yesyə'ədiḻən, cuiayi' yeḻə' chnabia' c̱hega'aquenṉə'. Le'e nale de que chebeɉa' de'e x̱io' ca' zɉəyo'o zɉəyaz yic̱hɉla'aždao' beṉə' len yeḻə' guac c̱he Beelsebon'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Žalə' naquən can' nale de que chebeɉa' de'e x̱io' ca' zɉəyo'o zɉəyaz yic̱hɉla'aždao' beṉə' len yeḻə' guac c̱he Beelsebon', ḻeczə zeɉen de que beṉə' lɉuežɉle ca' chəsyə'əbeɉe' de'e x̱io' ca' zɉəyo'o zɉəyaz yic̱hɉla'aždao' beṉə' len yeḻə' guac c̱hein' žalə' ca'. Beṉə' lɉuežɉle ca' se'e le'e de que clelən' nale c̱hia' can' chebeɉa'anṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Na' de'en chebeɉa' de'e x̱io' ca' len yeḻə' guac c̱he Diozən', chlo'in de que babžin ža catə' Diozən' ṉabi'e notə'ətezle güe'ele latɉə. ");
INSERT INTO zavNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Gwxiye'enə' gwxaquə'əleben ca to beṉə' gual, na' nada' naquəcha' beṉə' gualəch. Na' ṉezele de que catə' to beṉə' gual chape' ližen' len spad, yoguə' de'en de c̱he' naquən segor. ");
INSERT INTO zavNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero catə' əžin to beṉə' gualəch ca ḻe' na' tiḻəlene'ene', na' ben' naquə gualəch ḻen' gon gan. Na' que'e spad c̱he be'enə' de'en zoe' lez gaquəlenən ḻe'. Na' əca'atie' bichlə de'e de c̱he' na' c̱hise'en len migw c̱he' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Šə cui chonḻe txen len nada' chonḻe contr nada'. Na' šə cui chonḻe ca se'eɉḻe' beṉə' c̱hia', zeɉe dižə' de que chonḻe par nic̱h cui yoso'ozenague' c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Na' šə to de'e x̱io' de'en yo'o yaz yic̱hɉla'aždao' beṉə' yechoɉən nach lažə'ən nil na'aḻə yeyilɉən ga son mbalaz. Na' šə bitobi latɉə želen, nach əṉan: “De'e yobləczə žɉəyežo'a yic̱hɉla'aždao' ben' gan' gwyo'o gwyaza' antslə.” ");
INSERT INTO zavNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Na' yeyeɉən de'e yoblə gan' zo ben'. Catə' le'in de que bacheyone' xbab güen nach bazoche' binḻoch, na' yeyo'on de'e yoblə. ");
INSERT INTO zavNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nach žɉəyetobən yegažə de'e x̱io' ca' de'en zɉənaquə maləch ca ḻen na' txenṉə' so'on ḻo'o yic̱hɉla'aždao' be'enə'. Na' šə bagwso'onən ca' bachaquəch mal c̱he be'enə' clezə can' goc c̱he' antslə. ");
INSERT INTO zavNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Lao be' Jeso'osən' dižə' quinga, gwzo to no'olə gwchoḻ beṉə' ca' zɉəža' gan' bsed əblo'ine'enə'. Na' no'olən' gwṉe' zižɉo gože'ene': ―Mbalaz zo no'olən' gwxan le' na' bguaže'e le'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pero na' Jeso'osən' gože'ene': ―Naquəchxe mbalaz nitə' beṉə' ca' choso'ozenag xtižə' Diozən' na' chso'one' can' ne'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","30","Na' beṉə' zan beyec̱hɉ bebi'i cuit Jeso'osən' na' gwne': ―Le'e mbanḻe ṉa'a naquəchguale beṉə' yic̱hɉla'aždao' mal. Chṉable gona' to miḻagr par nic̱h əṉezele šə ḻe Dioz nan' bseḻe'e nada'. Pero bito gona' can' chṉablenə'. De'e gon Diozən' len nada' par nic̱h əṉezele de que ḻe'enə' bseḻe'e nada' gwxaquə'əleben ca de'en bene' len de'e profet Jonasən' par nic̱h gosə'əṉeze beṉə' Ninibe ca' de que Dioz nan' bseḻe'ene'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Catə' əžin ža gon Diozən' castigw c̱he yoguə' beṉə' chso'on de'e malən', de'e no'olən' gwnabia' beṉə' ca' gwnitə' galən' chḻa' bgüižən' cuiten ḻichalə yebane' len yeziquə'əchlə beṉə' guat ca' na' lao Diozən' gwcuiše' le'e mbanḻe ṉa'a. Ca naquə ḻe' ža, gwze'e Seba gan' naquə zitə'əchgua na' bide' nga par bzenague' dižə' sin' de'en be' de'e Rei Salomonṉə' len ḻe'. Na' nada' zoa' nga naquəcha' beṉə' blaoch cle ca de'e Salomonṉə', na' bito chzenagle c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Na' catə' əžin ža gon Diozən' castigw c̱he yoguə' beṉə' chso'on de'e malən', ḻeczə ža na' yesyə'əban beṉə' Ninibe ca'. Na' yesə'əcuiše' le'e nitə'əle lao dia nga c̱hedə' besyə'ədiṉɉene' xtoḻə'əga'aque'enə' catə' de'e Jonasən' gwdix̱ɉue'ine' ḻega'aque' can' gwna Diozən'. Ḻegonšc xbab de que nada' zoa' nga naquəcha' beṉə' blaoch cle ca de'e Jonasən', na' bito chzenagle c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nach Jeso'osən' bsaquə'əlebene' xtiže'enə' na' len de'en chone'enə' ca to yi'. Gozne': ―Notono no ggualə' to yi' na' gwdose'en žomə, na' nic əgwcuaše'en ga yoblə ga cui no le'i ḻen. Syempr chde'en ḻe'e ze'e par nic̱h əgwse'eni'in len yoguə' beṉə' so'o ḻo'o cuartən'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Žia ɉelaochon' par nic̱h chle'icho. Con šə bito bi chaquen, chle'iczecho binḻo. Pero šə nc̱hoḻ ɉelaochon', bito chle'icho. Ca'aczən' naquən len yic̱hɉla'ažda'ochon'. Šə naccho beṉə' la'aždao' güen, yo'o be'eni' c̱he Diozən' yic̱hɉla'ažda'ochon', pero šə naccho beṉə' la'aždao' mal, nc̱hoḻ yic̱hɉla'ažda'ochon'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","De'e na'anə' ḻegon par nic̱h gacle beṉə' la'aždao' güen, na' šo'o be'enin' yic̱hɉla'ažda'olen'. Bito gacle beṉə' la'aždao' mal na' beṉə' yic̱hɉla'aždao' žc̱hoḻ. ");
INSERT INTO zavNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Šə nye'eni' yic̱hɉla'ažda'olen' na' cui bi de'e mal yo'on, gwse'eni'iczən xṉezlen' can' chse'eni' to lampara gan' naquə žc̱hoḻ. ");
INSERT INTO zavNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Catə' beyož be' Jeso'osən' dižə' quinga, to beṉə' fariseo bene'ene' combid šeɉe' liže'en par əsa'ogüe'. Na' gwyo'o Jeso'osən' liž beṉə' fariseon' na' gwchi'e cho'a mesən'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Na' beṉə' fariseon' bebanene' catə' ble'ine' bito bona' Jeso'osən' antslə ze'e gaogüe' can' chosyo'ona' ḻega'aque' chsa'aquene' yebei Diozən' ḻega'aque' de'en chso'one' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","X̱anchon' gože' ḻe': ―Le'e beṉə' fariseo gwxaquə'əlebele ca tas plat de'en chc̱hin beṉə' na' cui cha'a chyibe' ḻo'inə' binḻo. Chonḻe par nic̱h chsa'aque beṉə' de que nacle beṉə' güen, pero chebeile chca'ale bi de'e de c̱he beṉə' na' nacle beṉə' mal juisy. ");
INSERT INTO zavNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Cui bi bi xbab de'e zaque'e yo'o ḻo'o yic̱hɉla'ažda'olen'. Chi' yic̱hɉle nac gonḻe par gacle xi'ilažə' len cuerp c̱hele. Ḻe'egatezə ca' cheyaḻə' cue' yic̱hɉle nac gonḻe par gacle xi'ilažə' len yic̱hɉla'ažda'olen', c̱hedə' Diozən' ben' ben cuerp c̱hechon' ḻeczə ḻe'enə' bene' yic̱hɉla'ažda'ochon'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ḻe'e gwnežɉo beṉə' bi de'en deile, beṉə' chəsə'əyažɉene'en. Šə gonḻe ca' nacbia' de que nacle beṉə' la'aždao' xi'ilažə'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Probchguazə le'e beṉə' fariseo! Ḻa'aṉə'əczə chnežɉwle Diozən' to part lao ši part c̱he yix̱güeɉ, c̱he yeɉ Sant Maria, nach c̱he rcaod c̱hele, bito bi zeɉen, c̱hedə' bito chonḻe de'en naquə güen na' bito chaquele c̱he Diozən'. De'en naquə de'e žialao gonḻe, gonḻe de'en naquə güen na' gaquele c̱he Diozən'. Pero bito cueɉyic̱hɉle əgwnežɉwle de'e ca' de'en chnežɉwle Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Probchguazə le'e beṉə' fariseo! Chzelažə'əle cue'ele ḻo'o yo'odao' ca' txen len beṉə' golə beṉə' blao ca' na' catə' cheɉle do gan' chac ya'a chene'ele əso'elao' beṉə' le'e. ");
INSERT INTO zavNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Probchguazə le'e chsed chlo'ile ḻei de'en bzoɉ de'e Moisezən' na' len le'e beṉə' fariseo! Chene'ele so'on beṉə' xbab c̱hele de que nacle beṉə' güen, pero len yic̱hɉla'ažda'olen' nacle beṉə' mal. Na' ḻeczə beṉə' ca' zedəsə'ənao le'e əsa'aque' can' nacle sin cui sa'acbe'ine'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","To beṉə' chsed chlo'i ḻein' boži'e xtižə' Jeso'osən' na' gože'ene': ―Maestr, laogüe de'en nao' de'e quinga ḻeczə chšašo' c̱heto'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Na' gož Jeso'osən' ḻe': ―Ḻeczə ca' le'e chsed chlo'ile ḻein' ¡probchguazlen'! Chzanchle can' na ḻein', chonḻen ca to yoa' de'e cuiczə no do'i na' chene'ele soa' beṉə' yoblə ḻen, na' le'e bito chene'ele gua'alen. ");
INSERT INTO zavNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","¡Probchguazə le'e chonḻe monoment lao ba c̱he de'e profet ca' gwso'e xtižə' Diozən'! Chacle tozə len de'e x̱axta'ocho ca' de'en gwso'ote' ḻega'aque', na' le'e chonḻe par nic̱h nacbi'axeɉə de que gwso'ote' de'e profet ca' laogüe de'en chonḻe monoment lao ba c̱he beṉə' ca' gwso'ote'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","De'e na'anə' lao yeḻə' sin' c̱he Diozən' gwne' de que əseḻe'e len le'e profet c̱he' ca' na' apostol c̱he' ca', beṉə' so'e xtiže'en. Na' gwne' de que le'e gotle baḻe' na' gwc̱hi' gwsaquə'əle yebaḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Na' de'e ḻi bachonḻe can' gwne'. De'e na'anə' si'ile castigw c̱he yeḻə' got c̱he yoguə' profet ca' gwso'ote' dezd catə'ən gwxe yežlyon' xte ža ṉeža, le'e mbanḻe ṉa'a. ");
INSERT INTO zavNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Zan beṉə' gwso'ot beṉə' yoblə ḻega'aque'. Na' le'e si'ile castigw c̱he yeḻə' got c̱he yoguə' beṉə' ca' gwzolaozən len de'e Abeḻən' ben' bet de'e biše'e Cainṉə' ḻe' na' zelaon len de'e Zequerian'. Zequeria na'anə' gwso'ote' entr yo'odao' əblaonə' na' entr mes de yeɉ gan' chso'ote' bia yix̱ə' par chso'elaogüe'e Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Probchguazə le'e chsed chlo'ile ḻein'! Ca naquə de'en chzeɉni'ile beṉə' ḻei c̱he Diozən', bito chzeɉni'iga'aquelene'en ḻicha can' naquən, na' nic chzenagle c̱hei. Na' beṉə' chse'ene'e yoso'ozenag c̱hei, nic cho'ele latɉə yoso'ozenague'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Na' catə' beyož be' Jeso'osən' dižə' quinga, nach beṉə' fariseo ca' na' beṉə' ca' choso'osed choso'olo'i ḻein' gwsa'acyožəchgüe' ḻe' na' gwse'enene' yesə'əbeɉe' ḻe' dižə'. ");
INSERT INTO zavNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Na' gosə'əbe'enaogüe' əchoɉ dižə' cho'enə' de'en yosə'əde'ine' par əsa'ogüe' xya contr ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Na' goquən' zan mil beṉə' babesə'əžag gan' zo Jeso'osən' xte bosə'əleɉ bosə'əšošɉ ṉi'a lɉuežɉga'aque'. Na' Jeso'osən' gwzolaoteque' be'e dižə' len disipl c̱he' ca' gože' ḻega'aque': ―Ḻe'e gapə cuidad nic̱h cui əx̱oayagle beṉə' par əsa'aquene' nacle beṉə' güen can' chso'on beṉə' fariseo ca'. Yeḻə' gox̱oayag c̱hega'aque'enə' gwxaquə'əleben ca xna' cuazin' de'en chlažə'ən par chaquən yetxtil. ");
INSERT INTO zavNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bito gonḻe can' chso'one'enə' c̱hedə' gaquə can' na dicho de'en na: “Yoguə'əḻoḻ de'en ngašə' ṉa'a gwžin ža la'alaon, na' yoguə'əḻoḻ de'en cui no gwse'eɉni'i antslə, ḻeczə gwžin ža se'eɉni'i beṉə' ḻen.” ");
INSERT INTO zavNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","De'e na'anə' bitə'ətezə de'e əṉale bgašə'əzə, beṉə' zan əse'enene'en, na' de'en əṉale žižizə ḻo'o cuart c̱helen', ḻeczə beṉə' zan yesə'əṉeze ḻen. ");
INSERT INTO zavNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Migw c̱hia', əchnia' le'e, bito žeble beṉə' ca' əso'ot le'e, c̱hedə' catə' bagotle bitoch bi gaquə so'onene' le'e. ");
INSERT INTO zavNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Choṉa' le'e consejw, cheyaḻə' žeble Diozən' c̱hedə' catə' bac̱h beque'e yeḻə' mban c̱helen' ḻeczə nape' yeḻə' guaquən' par yeseḻe'e le'e gabiḻən'. De'e yoblə əchnia' le'e, cheyaḻə' žeble Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ṉezecho de que byiṉ dao' ca' bitobi zɉəzaquə'ətequəb, pero na' Diozən' ni tob cui chanḻaže'e. ");
INSERT INTO zavNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na' ca naquə chio'o ža, de'e tant chaque Diozən' c̱hecho xte ṉezene' baḻə yišə' yic̱hɉ to tocho žia ḻa'aṉə'əczə bitotec bi zɉəzaquə' yišə' yic̱hɉchon'. De'e na'anə' bito žeble c̱hedə' zaquə'əch le'e cle ca bia zan byiṉ dao'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Na' əchnia' le'e, notə'ətezle šə cho'ele dižə' len beṉac̱hən' de que cheɉḻe'ele c̱hia', ḻeczə ca' nada' gua'a dižə' len angl c̱he Diozən' de que nacle xi'iṉa', nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Na' notə'ətezle šə cho'ele dižə' len beṉac̱hən' de que bito cheɉḻe'ele c̱hia', ḻeczə ca' nada' gua'a dižə' lao angl c̱he Diozən' de que bito nacle xi'iṉa'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Na' notə'ətezle šə güe'ele dižə' contr nada' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h, Diozən' yezi'ixene' c̱hele šə yediṉɉele can' nale. Pero notə'ətezle šə güe'ele dižə' contr Spirit c̱he Diozən', cuat yezi'ixen Diozən' c̱hele. ");
INSERT INTO zavNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Na' šə yesə'əc̱he'e le'e lao beṉə' gwnabia' c̱he yo'oda'onə' o lao beṉə' jostis ca' o šə lao yeziquə'əchlə beṉə' ca' zɉənapə poder, bito cuec yic̱hɉle nac yoži'ile xtižə'əga'aquen', o šə naclə əṉale. ");
INSERT INTO zavNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Lao or na'atezə Spirit c̱he Diozən' əgwlo'in le'e bin' cheyaḻə' əṉale. ");
INSERT INTO zavNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Entr beṉə' zan juisy ca' toe' gože' Jeso'osən': ―Maestr, gonšgo' mendad par nic̱h goṉ beṉə' biša'anə' nada' bien c̱he de'e x̱axna'ato' de'en cheyaḻə' si'a. ");
INSERT INTO zavNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pero Jeso'osən' gože' ḻe': ―Bito naca' nada' juez c̱hele na' bito naca' beṉə' güe'e laze c̱he de'e deile. ");
INSERT INTO zavNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nach gože' ḻega'aque': ―Ḻe'e gapə cuidad par nic̱h bito selažə'əle bi gatə' c̱hele yežlyon', c̱hedə' bito əbancho laogüe šə deczə zan de'e de c̱hecho. ");
INSERT INTO zavNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Na' be'elene' ḻega'aque' to jempl, gwne': ―To beṉə' gwni'a ḻechguaḻe goc cwseš c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Na' bene' xbab ḻo'o yic̱hɉla'aždaogüe'en gwne': “¿Nacxa gona'? c̱hedə' bitoch bi latɉə de par cwseš c̱hia'anə'.” ");
INSERT INTO zavNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nach gozne': “Quinga gona', yoc̱hiṉɉa' yo'o gan' nga ža' cwseš c̱hia' quinga na' gona' yo'o xench. Na' gwža'ašaogua'a cwsešən' na' bichlə de'e de c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Na' laogüe bade de'e chyažɉda' par zan iz, bitoch gona' žin. Ye'eɉ gaoteza' con bi che'enda' na' gona' ḻegr.” ");
INSERT INTO zavNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero Diozən' gože' be'enə': “Beṉə' tont le'. Ṉeže' bžin or gato', na' ¿nola lao ne'i gaquə yoguə' de'en de c̱hio'onə'?” ");
INSERT INTO zavNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Can' gac c̱he notə'ətezə beṉə' šə con chbec yic̱hɉe' tlaozə de'en deine' žlac mbane' na' bito chone' ca yebei Diozən' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Na' gož Jeso'osən' disipl c̱he' ca': ―Echnia' le'e, bito cuec yic̱hɉle tlaozə de'en ye'eɉ de'en gaole lao mbanḻe. Na' ḻeczə ca' bito cuec yic̱hɉle tlaozə de'en gacwlen'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Zaquə'əch yeḻə' mban c̱helen' ca yeḻə' guaon'. Ḻe'egatezə ca' cuerp c̱helen' zaquə'əchən ca xala'anḻen'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ḻegontoš xbab, ca naquə bec̱hɉ ca' bito chsa'azəb bito chəsyə'əlapəb, nic zo da'a xoa' c̱hega'aquəb, nic zo gan' ncua' no guangoš c̱hega'aquəb ga ža' de'e sa'ob. Pero na' Diozən' chguaocze' ḻega'aquəb. Naquəchxen' zaquə'əle ca bia ca' žia x̱ile'e. ");
INSERT INTO zavNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Na' ni tole bito gaquə yostoṉ cuinḻe gašɉ metr šə con cue'e yic̱hɉle ətoṉle. ");
INSERT INTO zavNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ṉezele bito gaquə yostoṉ cuinḻe na' nic naquən de'e zaque'e. De'e na'anə' bito gontecle xbab c̱he biquə'əchlə de'e chyažɉele. ");
INSERT INTO zavNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ḻegontoš xbab ca naquə yeɉ ca' de'en zɉəze yix̱ə' chesə'əcha'oczən. Bito bi žin chso'onən, nic chsa'alɉən do. Na' əchnia' le'e de'e Rei Salomonṉə' goque' lachə' xoche juisy, pero bito bžinḻaže'e xalane'enə' ca yeḻə' xoche c̱he yeɉ ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Diozən' none' xoche yix̱ə' de'en ze yoba len to termzən' zen nach choso'ozeye'en, naquəchxe gon Diozən' len le'e ggüe'eczə yic̱hɉe' goṉe' yoguə'əte de'en chyažɉele, le'e cui cheɉḻe'etecle de que goṉe' de'en chyažɉele. ");
INSERT INTO zavNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Le'e ža, bito güe'elažə'əle par gatə' de'e ye'eɉ de'e gaole. Bito gaquəžeɉlažə'əle c̱he ḻen. ");
INSERT INTO zavNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Beṉə' ca' cui chso'elao' Diozən' porzə c̱hei de'e can' chso'elažə'əzeche', c̱he de'en əse'eɉ de'en əsa'ogüe' na' c̱he xala'anga'aque'. Pero X̱acho Diozən' ṉezczene' biquə' de'e ca' chyažɉele. ");
INSERT INTO zavNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","De'en güe'elažə'əle, güe'ele latɉə par nic̱h Diozən' ṉabi'e le'e. Na' yoguə' de'e ca' de'en chyažɉelen' goṉczə Diozən' ḻen, de'en ye'eɉ de'en gaole na' xala'anḻe. ");
INSERT INTO zavNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Bito žeble ḻa'aṉə'əczə naquə to c̱hopzle. Diozən' chebeine' chnabi'e le'e na' chaclene' le'e. ");
INSERT INTO zavNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ḻe'e yeyotə' de'en deile par nic̱h gatə' de'e əgwnežɉwle beṉə' ca' chesə'əyažɉe. Šə gonḻe ca' caguə cuiayi' de'en deilen', c̱hedə' la' Diozən' goṉe' le'e de'e zaquə'əche na' de'e cui te c̱hei catə' yežinḻe yoban' gan' zo'enə'. Na' bito gac šo'o beṉə' bguan par əque'en, na' nique gaquə šo'o bia dao' əgwžiayi' ḻen. ");
INSERT INTO zavNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Gan' de de'en chaquele c̱hei, nan' zo yic̱hɉla'ažda'olen'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Nach Jeso'osən' bsed blo'ine' ḻega'aque' naquən' gaquə catə'ən yide' de'e yoblə. Na' gwne': ―Ḻe'e so probnid par catə'ən yida' yeto, ḻe'e so can' nitə' beṉə' chsa'ape' liž x̱anga'aque' žlac zde' yeḻə' gošagna', zɉənyaze' xala'anga'aque' na' chaḻə' yi'. Nach catə' yežine' na' əṉe' cho'a puertən' ḻe'e yosə'əsalɉwtie' par yeyo'e. ");
INSERT INTO zavNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mbalaz gaquə c̱he mos ca' beṉə' ca' nitə' probnid chəsə'əbezə x̱anga'aque'en catə'ən yežine'. Šə nite'e chəsə'əbeze' ḻe' catə'ən yežine', nachən' əgwsi'ini'e de'en əsa'ogüe' na' cuine' gwnežɉue' ḻega'aque' de'en əse'eɉ əsa'ogüe'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mbalaz gaquə c̱hega'aque' šə chəsə'əbeze' batə'əquən' yežine' ḻa'aṉə'əczə šə yežine' do chel o šə do šbaḻ. ");
INSERT INTO zavNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ḻegon xbab c̱he de'e nga. Žalə' ṉeze x̱an yo'onə' do bi or əžin beṉə' bguanṉə' liže'enə', la' gwṉaze' par nic̱h bito güe'e latɉə šo' be'enə' liže'enə' par cuane' šinḻaze'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Le'e ža, cheyaḻə' sole probnid, c̱hedə' catə'ən cui chonḻe xbab yida', ca na'an yida' de'e yoblə, nada' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Bedən' gože'ene': ―X̱anto' ¿əcho'o jempl nga par netə'əzəto'onə' o šə par yoguə' beṉac̱hən'? ");
INSERT INTO zavNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nach gož Jeso'osən' Bedən': ―Naquən par notə'ətezə beṉə' šə chone' can' chon mos əblao beṉə' naquə beṉə' sin' na' beṉə' chon complir can' cheyaḻə' gone'. Ben' nac ca' co' x̱ane'enə' lao ne'e liže'enə' par nic̱h əggüia əgwye' mos ca' yeḻa' na' par nic̱h ggone' de'e əsa'o to toe' catə' chžin or əsa'ogüe'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Šə to beṉə' mosən' chontezə chone' con can' non x̱anen' mendad, mbalaz soe' catə' yežin x̱ane'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","De'e ḻi əchnia' le'e x̱ane'en cue'e lao na' xmose'enə' yoguə'əḻoḻ de'en deine'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero na' šə mosən' gone' xbabən' na' əṉe': “Bagwžei x̱anan'”, na' šə solaocle' c̱hine' mos ca' yeḻa' na' ye'eɉ gaox̱atteze' na' sožene', ");
INSERT INTO zavNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","nach x̱ane'enə' yežine' to ža senyale' ḻe' to or cui nacbe'ine'. Na' por ni c̱he de'en cui chon mosən' can' cheyaḻə' gone', x̱ane'enə' c̱hinchgüe' ḻe' yid sotən' xte ca gate'. Can' chac len notə'ətezə mos ben' cui chon cuaseḻoḻ can' cheyaḻə' gone'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Na' ca naquə mos beṉə' naquə beṉə' godenag, ḻa'aṉə'əczə baṉezene' can' chene'e x̱ane'enə' gone', pero bito chone' ca'. De'e na'anə' bito zoe' probnid catə' yežin x̱ane'enə', na' x̱ane'enə' c̱hinchgüe'ene' yid sotən'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Na' beṉə' cui ṉezene' bin' non x̱anen' mendad na' chone' de'e ḻeczə zaquə' c̱hine'ene', pero caguə c̱hintequene'. Notə'ətezə beṉə' yo'o lao ne'e gone' de'e zan de'e zaque'e, cheyaḻə' gone' yoguə'ən. Na' ben' yo'o lao ne'e gone' de'e zan de'e zaque'e, chonchən byen gone' mazəchlə can' cheyaḻə' gon ben' cuitec yo'o lao ne'e de'e zan de'e gone'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nach gwna Jeso'osən': ―Ca naquə beṉac̱hən' yesə'ədiḻe' na' yesə'əšaše' por ni c̱he de'en zedeyena' yežlyo nga, na' de'en so'one' ca' gwxaquə'əleben ca yi'. ¡Žalə' bagoclə de'en zedeyena'anə'! ");
INSERT INTO zavNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Bida' par c̱hi' saca'a na' gata'. Ḻechguaḻe yo'o yic̱hɉa' c̱hei xte catə'ən əžin ža gaquən. ");
INSERT INTO zavNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Echonḻe xbabən' de que beṉə' ža' yežlyon' yesə'əzo yesə'əbeze' binḻo len lɉuežɉga'aque' laogüe de'en bida'? Echnia' le'e, bito yesə'əzo yesə'əbezəga'aque' binḻo len lɉuežɉga'aque' laogüe de'en bida', sino que yesə'ədiḻe' na' yoso'ošaše'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Dezd ṉa'a, šə nitə' gueyə' beṉə' famiḻy to yo'o, yesə'ədiḻe' entr ḻega'aque', c̱hope' contr šoṉe' na' šoṉe' contr c̱hope'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yediḻə beṉə' byon' contr xi'iṉe', na' xi'iṉe'en contr ḻe'. Na' no'olən' yediḻe' contr xi'iṉe' no'olə, na' xi'iṉe' no'olən' contr ḻe'enə'. Na' yediḻə no'olən' contr xo'oliže' na' xo'oliže'en contr ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nach ḻeczə gož Jeso'osən' beṉə' ca' nitə'ənə': ―Catə' chle'ile chi' beɉw gan' chen bgüižən' na' nale: “Guaquə yeɉw”, na' can' chac. ");
INSERT INTO zavNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na' catə' chec̱hɉ to be' de'e za'ate zaquə' galən' chḻa' bgüižən' cuiten ḻicha, na' nale: “Guaquə zeyə'”, na' chac zeyə'. ");
INSERT INTO zavNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Beṉə' gox̱oayag le'e! Catə' chle'ile nac chac ḻe'e yoban' na' lao yežlyon' ṉezele šə guaquə yeɉw o šə guaquə zeyə'. ¿Bixc̱hen' cui chacbe'ile bi zeɉe de'e ca' chona'? ");
INSERT INTO zavNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Bixc̱hen' cui chonḻe xbab par nic̱h əṉezele naquən' cheyaḻə' gonḻe? ");
INSERT INTO zavNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Catə' to beṉə' gonḻe xya c̱he' na' əc̱he'e le'e lao jostis, na' lao ngo'ole nezən' ḻegonḻene' regl binḻo par nic̱h na' cui c̱he'e le'e lao jostisən'. Šə bito gonḻe ca' ža, catə' əžinḻe lao jostisən' gone' le'e lao na' poḻsian' par yosə'əže'e le'e ližya. ");
INSERT INTO zavNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Echnia' le'e, bito yebeɉe' le'e xte catə' c̱hixɉwle doxen de'en chaḻə'əlen'. ");
INSERT INTO zavNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na' lao or na'atezə entr beṉə' ca' ža' na' gwnitə' baḻə beṉə' gwso'elene' Jeso'osən' dižə' can' goquə c̱he x̱oṉɉ beṉə' Galilea. Gwse'ene' de que žlac gwso'ot beṉə' Galilea ca' bia yix̱ə' par chso'elaogüe'e Diozən', soḻdad c̱he Pilatən' ɉse'ete' ḻega'aque' c̱hedə' can' ben Pilatən' mendad. ");
INSERT INTO zavNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nach boži'i Jeso'osən' xtižə'əga'aque'enə' gože' ḻega'aque': ―¿Echonḻe xbabən' de que beṉə' ca' gwsa'at gwso'onche' de'e maləch cle ca beṉə' Galilea ca' yeḻa' laogüe de'en goc c̱hega'aque' ca'? ");
INSERT INTO zavNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Echnia' le'e caguə ca'anə'. Šə bito yediṉɉele xtoḻə'əle ca' gwžin ža cuiayi'ile can' gosə'əbiayi' beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ṉezele c̱he beṉə' ši'iṉšoṉ ca', lao zɉənite'e Siloen' bxopə to campnary na' gwdenən ḻega'aque' na' gwsa'ate'. ¿Eḻeczə chonḻe xbabən' goc ca' laogüe de'e zɉənaquəche' beṉə' maləch lao yoguə' beṉə' ca' ža' Jerosalenṉə'? ");
INSERT INTO zavNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Echnia' le'e caguə ca'anə'. Šə le'e cui yediṉɉele xtoḻə'əle ca' gwžin ža cuiayi'ile can' gosə'əbiayi' beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Na' be'elene' ḻega'aque' jempl nga bzeɉni'ine' ḻega'aque' de que cheyaḻə' yesyə'ədiṉɉene' xtoḻə'əga'aque'enə'. Na' gože' ḻega'aque': ―To beṉə' zo to yag yix̱güio c̱he' gan' ža' yag obas c̱he' ca'. Na' gwyeɉe' lao yaguən' ɉəgüie' šə zetgua yix̱güion' gaogüe', pero bitobi bželene'. ");
INSERT INTO zavNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Na' gože' ben' chapə güert c̱he'enə': “Bachac šoṉ iz chedəgüia' yag nga šə chbian yix̱güio, pero bito bi chbian. Gwc̱hoguən. Lašɉ con zon nḻanən na' nique bi frot chbiazən.” ");
INSERT INTO zavNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Na' gož ben' ḻe': “X̱ana', lɉoyenṉə' zezošgan yetgüizən'. Na' əc̱he'ena' xanein' cueca'an yo beb. ");
INSERT INTO zavNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Na' šə cuian frotən' yetgüiz, bitec de'e güen. Pero šə cuiczə bi cuian nach əc̱hogchon.” ");
INSERT INTO zavNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Na' to ža dezcanz bsed blo'i Jeso'osən' beṉə' ca' ža' to ḻo'o yo'odao'. ");
INSERT INTO zavNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na' zo to no'olə beṉə' bagoc ši'iṉšoṉ iz yo'o yaz de'e x̱io'on yic̱hɉla'ažda'ogüe'enə'. Na' ben de'e x̱i'onə' par nic̱h bdobə cuerp c̱he'enə', na' caguə goquəch seche' ḻicha. ");
INSERT INTO zavNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Na' catə' ble'i Jeso'osən' ḻe', goxe'ene', nach gože'ene': ―No'olə ṉa'a yeyacdo' c̱he yižgüe' chio'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Na' bx̱oa ne'enə' lao cuerp c̱he no'olən', na' ḻe'e bezechate' ḻicha na' be'elaogüe'e Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero na' beṉə' gwnabia' c̱he yo'oda'onə' bloque' c̱hedə' Jeso'osən' beyone' beṉə' güe'enə' ža dezcanzən', na' gože' beṉə' ca' nitə' ḻo'o yo'oda'onə': ―De x̱op ža par gonḻe žin. Ḻe'e da lao ža ca' par nic̱h yeyaquele c̱he yižgüe' c̱helen', pero bito la'acle ža dezcanzən' par yeyaquele. ");
INSERT INTO zavNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nach X̱anchon' gože'ene': ―¡Le'e beṉə' gox̱oayag! ¿Ecaguə lao ža dezcanzən' bia'aczə chsežle go'oṉ c̱hele o borr c̱hele gan' zɉəda'ab na' chgua'aga'acleb güe'eɉ nis? ");
INSERT INTO zavNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","No'olə nga naque' xi'iṉ dia c̱he de'e Abraanṉə' na' ca naquə ben gwxiye'enə' par nic̱h babdobə cuerp c̱he'enə' ši'iṉšoṉ iz, naquəczən ḻicha babeyona'ane' ža dezcanzən'. ");
INSERT INTO zavNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Lao gwne' ca' beṉə' ca' chəsə'əgue'i ḻe' gwsa'aquene' zto', na' yoguə'əḻoḻ beṉə' zan ca' yeḻa' nitə' na' besyə'əbeichgüeine' len yoguə' de'en ben Jeso'osən', la' ḻechguaḻe güen zɉənaquə de'en bene'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nach gwna Jeso'osən': ―Na' əgwlo'ida' le'e par nic̱h əṉezele nac gwxaquə'əlebe yeḻə' gwnabia' c̱he Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Gwxaquə'əleben ca to xsa moztas. To beṉə' goze'en, na' catə' bla'an gwcha'on goquən yag cha'odao'. Na' bia ca' zɉəzo x̱ile'e gwso'on ližda'oga'aquəb lao xoze'e ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nach de'e yoblə gozne': ―¿Nac əgwsaquə'əlebecho yeḻə' gwnabia' c̱he Diozən'? ");
INSERT INTO zavNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Egwsaquə'əlebechon ca xna' cuazin' de'en gwlec no'olən' len to rob yezɉ par nic̱h becha'o doxenən. ");
INSERT INTO zavNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Na' gwda Jeso'osən' bsed blo'ine' beṉə' ža' syoda ca' na' yež ca' gan' bedie' par bežine' Jerosalenṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Na' to beṉə' gože' Jeso'osən': ―X̱anto', ¿əcon to c̱hopzə beṉə'ən cui žɉəya'ac lao yi' gabiḻən'? Nach Jeso'osən' gože' ḻega'aque': ");
INSERT INTO zavNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Echnia' le'e, beṉə' zan se'ene'ene' ṉite'e binḻo len Diozən'. Pero gwžin ža catə' cuich gaquə so'one' par ṉite'e binḻo len ḻe'. De'en naquə žialao gonḻe, c̱hilɉlažə'əle naclə gonḻe par nic̱h sole binḻo len Diozən', ");
INSERT INTO zavNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","nic̱h cui gone' len le'e can' ben to x̱an yo'o catə' bžin or par əgwseyɉue' na' gwzože'e bseyɉue'. Na' gwdechlə besə'əžin beṉə' boso'osiže' ḻe'e puert c̱he'enə' na' bito bsalɉue' par so'e. Na' gwse'ene': “Bsalɉwšga par šo'oto'.” Na' gože' ḻega'aque': “Bito nombi'a le'e, nic ṉezda' gan' za'acle.” ");
INSERT INTO zavNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Can' gaquə len baḻle. Nach solaole ye'elene': “Güe'eɉ gwdaoto' len le' na' bsed blo'ido' neto' lao lquey lažto'.” ");
INSERT INTO zavNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero na' de'e yoblə əye'e le'e: “Bitoczə ṉezda' gan' besa'acle. Ḻe'e žɉəya'ac yoguə' le'e beṉə' güen de'e mal.” Can' ye'e le'e. ");
INSERT INTO zavNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Na' le'ile Abraanṉə' na' Isaaquən' na' Jacobən' na' yoguə' profet beṉə' ca' gwso'e xtižə' Diozən' nite'e yoba gan' zo Diozən' chnabi'e, na' le'e bito gac šo'olenə'. Na' cana' cuežyašə'əle na' gaoyeɉə leylen' catə' gacbe'ile bito gaquə šo'ole. ");
INSERT INTO zavNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Beṉə' za'ac doxenḻə yežlyon' yesə'əžine' yoba gan' zo Diozən' chnabi'e na' yesə'əbi'e cho'a mes c̱he'enə' sa'ogüe'. ");
INSERT INTO zavNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Na' ža, nitə' beṉə' bito zɉənaque' beṉə' blao ṉa'a, pero gwžin ža catə' əsa'aque' beṉə' blao. Na' nitə' beṉə' zɉənaque' beṉə' blao ṉa'a, pero ḻeczə gwžin ža catə' ḻega'aque' bitoch əsa'aque' beṉə' blao. ");
INSERT INTO zavNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Lao or na'atezə baḻə beṉə' fariseo ca' besə'əžine' gan' zo Jeso'osən' na' gwse'ene': ―Cheyaḻə' yexoṉɉo' nga gan' chnabia' Erodən' c̱hedə' chene'ene' gote' le'. ");
INSERT INTO zavNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jeso'osən' gože' ḻega'aque': ―Erodən' gwxaquə'əlebene' ca to becoyo'o por yeḻə' gox̱oayag c̱he'enə'. Ḻežɉa'ac na' ye'elene' de que yeto c̱hopə žazə soa' par yebeɉəcha' de'e x̱io' ca' zɉəyo'o zɉəyaz yic̱hɉla'aždao' beṉə' na' par nic̱h yeyoncha' beṉə' chsa'acšene, na' caguə sšachən' yeyož gona' de'en cheyaḻə' gona'. ");
INSERT INTO zavNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero ca naquə de'en chona' nga ṉa'a, goncha'an gwx̱e güižɉ c̱hedə' Jerosalen na' gan' chso'ote' profet ca' chso'e xtižə' Diozən', caguə ngan'. ");
INSERT INTO zavNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Le'e beṉə' Jerosalenṉə' chotle profet, na' beṉə' ca' chseḻə' Diozən' len le'e chšižə'əga'aclene' yeɉ. Zan las go'onda' yetoba' le'e ca to ɉeid cheyežəb xi'iṉəb, pero bito be'ele latɉə. ");
INSERT INTO zavNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Na' bagwleɉəyic̱hɉa' le'e. Na' əchnia' le'e bitoch le'ile nada' xte catə'əch əžin ža əṉale: “Cho'ela'oto' beṉə' za' nga beṉə' babseḻə' X̱ancho Diozən'.” ");
INSERT INTO zavNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Na' to ža dezcanz Jeso'osən' gwyeɉe' liž to beṉə' blao entr beṉə' fariseo ca' par gwsa'ogüe', na' beṉə' fariseo ca' nitə'ənə' besyə'əyatchgüeine' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Na' laogüe'enə' zecha to beṉə' chacšene, zo ḻe'enə' yi. ");
INSERT INTO zavNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Na' gož Jeso'osən' beṉə' fariseo ca' na' len beṉə' ca' choso'osed choso'olo'i ḻein' de'en bzoɉ de'e Moisezən': ―Segon can' na ḻein' ¿əde lsens yeyoncho to beṉə' güe' ža dezcanzən' o šə bito de lsens? ");
INSERT INTO zavNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero notono boži'i xtiže'enə'. Nach Jeso'osən' bex̱e'e na' be'enə' na' beyone'ene', na' gože'ene': ―Baguaquə yeyeɉo'. ");
INSERT INTO zavNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Na' gož Jeso'osən' beṉə' ca' ža' liž beṉə' fariseon': ―Le'e šə zo to borr o to go'oṉ c̱hele, na' əxopəb to ḻo'o pos, ¿əcabi yebeɉleb lgüegwzə ḻa'aṉə'əczə naquən ža dezcanz? ");
INSERT INTO zavNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Na' notono goc yoži'i xtižə' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Na' ble'i Jeso'osən' can' chso'on beṉə' ca' zɉənaque' combid liž beṉə' fariseon', gosə'əbeɉe' siyən' gwse'enene' yesə'əbi'e gan' zɉəchi' beṉə' blao ca'. Na' Jeso'osən' gože' ḻega'aque': ");
INSERT INTO zavNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Catə' to beṉə' gone' le'e combid gan' chac to yeḻə' gošagna', bito cue'ele gan' cheyaḻə' cue' beṉə' blao ca'. La' šə cue'ele na' de repent yidə beṉə' naquəch beṉə' blao. ");
INSERT INTO zavNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Na' yidə x̱an yo'onə' ye'e le'e: “Ḻesoža' nic̱h cue' benga.” Nach do chaquele zto' cue'ele ga yoblə len beṉə' ca' cui bi bi zɉəzaquə'. ");
INSERT INTO zavNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Pero na' catə' nacle combid, cue'ele len beṉə' ca' cui bi bi zɉəzaquə', na' catə' yidə x̱an yo'onə' na' ye'e le'e: “Beṉə' migw c̱hia', da cui'o len beṉə' blao ca'”, nach si'ichle yeḻə' bala'aṉ lao beṉə' ca' zɉəchi' len le'e cho'a mesən'. ");
INSERT INTO zavNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Notə'ətezcho cho'elao' cuincho, Diozən' gone' par nic̱h gacbe'icho de que bitobi zaquə'əcho. Na' notə'ətezcho choncho xbab de que bitotec bi zaquə'əcho, Diozən' goṉe' chio'o yeḻə' bala'aṉ. ");
INSERT INTO zavNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nach ḻeczə gož Jeso'osən' ben' ben ḻe' combid: ―Catə' gono' to lṉi na' gono' beṉə' combid əsa'ogüe' len le', bito gono' combid porzə beṉə' migw c̱hio' o beṉə' zɉənaquə beṉə' gwni'a. Ḻega'aque' ḻeczə gosyə'əyone' le' combid ližga'aque', na' yosyo'ogüe'e gwzon laogüe de'en benga'aco'one' combidən' bla'aque' ližo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Catə' gono' to lṉi, gono' combid beṉə' yašə' ca' na' beṉə' nchog no ṉi'a na'aga'aque', beṉə' coj, na' beṉə' lc̱hoḻ. ");
INSERT INTO zavNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Šə gono' ḻega'aque' combid, Diozən' gone' par nic̱h so' mbalaz, c̱hedə' beṉə' ca' bito gaquə yesyə'əyone' le' combid. So' mbalaz catə' Diozən' yosbane' le' ladɉo beṉə' guat ca' txen len yeziquə'əchlə beṉə' ca' ɉa'ac ḻicha lao gosə'əbane'. ");
INSERT INTO zavNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Na' to beṉə' chi' cho'a mesən' txen len Jeso'osən' benene' xtiže'enə' na' gože'ene': ―Mbalaz socho gaocho lao lṉi de'en gaquə catə' bachnabia' ben' əseḻə' Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nach Jeso'osən' gwne': ―To beṉə' bene' to lṉi xen na' bene' combid əžɉa'ac beṉə' zan liže'enə' par əsa'ogüe'. ");
INSERT INTO zavNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Na' catə' bžin or əsa'ogüe', x̱an yo'onə' bseḻe'e xmose'enə' par žɉətobe' beṉə' ca' bene' combid əsa'ogüe'. Na' catə' ɉəye' to toga'aque' gože' ḻega'aque': “Ḻešo'o, la' babsi'ini'e de'en gaocho.” ");
INSERT INTO zavNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Na' to toga'aque' gwse'e be'enə' bixc̱hen' cui zɉəzoe' latɉə žɉa'aque' gan' chone' lṉin'. Toe' gwne': “Ze'e gwxi'a to yežlyo. Cheyaḻə' žɉəgüia'an. Na' ye'ešgo' x̱ano'on de que bito gac yida'.” ");
INSERT INTO zavNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Yetoe' gwne': “Ze'e gwxi'a gueyə' cue' go'oṉ na' ṉa'a əžɉenga'aca'ab prueb. Ye'ešgo' x̱ano'on si'ixene' c̱hia' bito gaquə yida'.” ");
INSERT INTO zavNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Na' yetoe' gože'ene': “Ze'e bšagna'a. De'e na'anə' bito gaquə yida'.” ");
INSERT INTO zavNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Na' mosən' beyeɉe' na' gože' x̱ane'enə' can' gwse' beṉə' ca' ḻe'. Nach x̱an yo'onə' ben' chon lṉin' bže'e, nach gože' xmose'enə': “Gwyeɉ ɉtado' yoguə' lqueyən' na' yoguə' nez lao' syodan', na' əgwtobo' beṉə' yašə' ca' na' beṉə' ca' nchog no ṉi'a na'aga'aque', na' beṉə' coj ca' na' beṉə' lc̱hoḻ ca' par la'aque' əsa'ogüe'.” ");
INSERT INTO zavNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Gwde bene' ca' nach gože' ḻe': “X̱ana', baɉətoba' beṉə' ca' gwna'onə' na' ṉedechczə latɉə par beṉə' yoblə.” ");
INSERT INTO zavNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nach x̱ane'enə' gože' ḻe': “Gwyeɉ fuer syodan' na' gono' byen da'ac beṉə' ca' nitə' do tnezən' na' žɉəx̱i'o beṉə' ca' zɉəža' yix̱ə', gono' byen da'aque' liža' nga əsa'ogüe' par nic̱h šane' xte ca cuich bi latɉə šo'. ");
INSERT INTO zavNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Na' ca naquə beṉə' ca' bena' combid nechte, bito gua'a latɉə əsa'o ḻega'aque' de'en babsi'ini'anə'.” ");
INSERT INTO zavNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Na' beṉə' zan juisy ɉəsə'ənaogüe' Jeso'osən'. Na' gwyec̱hɉe' gože' ḻega'aque': ");
INSERT INTO zavNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Notə'ətezle šə gaquəchele c̱he x̱ale, xna'ale, xo'olle, xi'iṉle, bišə'əle, zanḻe na' cuinḻe mazəchlə can' chaquele c̱hia', bito gaquə ṉaole nada' par gacle disipl c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Na' notə'ətezle šə laogüe de'en chaquele yoso'oc̱hi' yoso'osaquə' beṉə' le'e o so'ote' le'e to ḻe'e yag coroz de'e nan' bito chonḻilažə'əle nada', ḻeczə bito gaquə ṉaole nada' par gacle disipl c̱hia' šə ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Šə to le'e chene'ele gonḻe to campnary, zgua'atec cue'ele nach gonḻe xbab na' gwzaquə'əle ca do ɉa'aquə'ətə' chyažɉele par gonḻen na' šə de mech c̱helenə' par yeyož campnaryən'. ");
INSERT INTO zavNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Šə cui əgwchix̱ə əgwtoḻə' xbab c̱helen' ɉa'aquə'ətə' de'en chyažɉele, catə' bagwlecle laneinə' na' gacbe'ile de que bitoch bi mech de par yeyožən. Na' yoguə' beṉə' yesə'əle'i lanein' so'one' le'e borl. ");
INSERT INTO zavNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Na' yesə'əne': “Benga gwzolao bene' to campnary pero bito goquə yesyože' de'en gwzolaogüe'.” ");
INSERT INTO zavNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Na' šə to rei chone' xbab tiḻe' len yeto rei ḻeczə zgua'atec gongax̱ɉe' xbab šə len si mil soḻdad c̱he' ca' guaquə gone' gan len rein' yeto ben' yidə len gaḻɉə mil soḻdad. ");
INSERT INTO zavNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Na' šə chacbe'ine' cui gone' gan, lao ṉezo rein' yeto zitə'ələ, əseḻe'e beṉə' žɉəsə'ədie' xtiže'en lao rein' yeto yesə'əṉabe' yesyə'ənite'e binḻo. ");
INSERT INTO zavNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Can' naquən len le'e, notə'ətezle šə cui cueɉyic̱hɉle famiḻy c̱hele, bia yix̱ə' c̱hele na' yoguə'əḻoḻ cuantəchlə bi de'e de c̱hele, bito gaquə ṉaole nada' par gacle disipl c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Zedə'ən naquən güenchgua, pero na' šə bitoch naquən zxi', ¿nacxa goncho par nic̱h yeyaquən zxi'? ");
INSERT INTO zavNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Bitobi zaquə'ən, nic gaquəlenən yežlyon', nic gaquə gwc̱hinchon par beb, ḻete c̱ho'oṉchon. Can' gwxaquə'əlebele šə bitoch chzenagle c̱hia' do yic̱hɉ do lažə'əle. Le'e žia nagle de'e chene, ḻegwzenag. ");
INSERT INTO zavNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Na' beṉə' goc̱hixɉw ca' na' yeziquə'əchlə beṉə' ca' chso'on de'e mal, yogue'e gosə'əbigue'e gan' zo Jeso'osən' par gwse'enene' xtiže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Na' beṉə' fariseo ca' na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' chəsə'əṉelaogüe'e, chəsə'əne': ―Benga chgüialaogüe' beṉə' ca' chso'on de'e malən' na' chaolene' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nach Jeso'osən' be'e to jempl, gože' ḻega'aque': ");
INSERT INTO zavNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Šə nitə' to gueyoa xilə' c̱hele na' gaquəžeɉe tob, ¿əcabi yocua'aṉle bia ca' taplalɉ tgualɉ gan' ža'ab latɉə dašən' na' žɉəyedilɉle bian' goquəžeɉenə' xte ca yeželeleb? ");
INSERT INTO zavNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Na' catə' yeželobən' yebeichgüeile na' yex̱oaleb ya'a yenḻe yeyo'aleb. ");
INSERT INTO zavNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Na' catə' yežinḻe ližle əgwtoble beṉə' migw c̱hele na' beṉə' gwliž c̱hele na' ye'ele ḻega'aque': “Ḻeyebei len nada', c̱hedə' babežel xilə' c̱hia' bian' goquəžeɉe.” ");
INSERT INTO zavNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Echnia' le'e, gobeiche Diozən' na' angl c̱he' ca' catə' to beṉə' chon de'e mal yediṉɉene' xtoḻe'enə' clezə can' chəsyə'əbeine' len taplalɉ tgualɉ beṉə' zɉənaquə beṉə' güen lao Diozən' beṉə' bito de xtoḻə'əga'aque' par yesyə'ədiṉɉene'en. ");
INSERT INTO zavNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Na' no no'olən' šə de ši mech pḻat c̱he' na' šə ṉit ton, ¿əcabi əgguale'e to yi' na' gwḻoe' ḻo'o yo'o c̱he'enə' na' yeyilɉyože'en xte ca yeželene'en? ");
INSERT INTO zavNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na' catə' yeželene'en na' əgwtobe' no'olə migw c̱he' ca' na' beṉə' gwliž c̱he' ca', na' ye'e ḻega'aque': “Ḻeyebei len nada' c̱hedə' babeželda' mech c̱hian' de'en gwnitən'.” ");
INSERT INTO zavNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Echnia' le'e, ḻeczə chesyə'əba chesyə'əzaquə'əlažə' angl c̱he Diozən' catə' to beṉə' chon de'e mal chediṉɉene' xtoḻe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Na' ḻeczə gože' ḻega'aque': ―Gwzo to beṉə' na' gwnitə' c̱hopə xi'iṉe' beṉə' byo. ");
INSERT INTO zavNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Na' bžin ža beṉə' xcuidən' gože' x̱en': “X̱a, beṉ nada' de'en cheyaḻə' si'a de'en deido'.” Nach x̱e'en bnežɉue'ene' de'en cheyaḻə' si'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Gwde yeto c̱hopə ža na' beṉə' xcuidən' btobe' yoguə'əḻoḻ cuantzə bi de'en de c̱he' na' gwze'e gwyeɉe' ṉasyon zitə'. Na' porzə de'e cui zaque'e ɉene'. Na' lao zdalene' de'e malən' benditɉeine' xmeche'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Na' catə' beya xmeche'enə', goc to bgüin juisy lao doxen ṉasyonṉə', na' bitoch bi bi gotə' par si'e de'e ye'eɉ gaogüe' na' bichlə de'e byažɉene'. ");
INSERT INTO zavNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","De'e na'anə' gwyeɉe' gan' zo to beṉə' ṉasyonṉə' na' gwṉabe' žin. Na' be'enə' bseḻe'ene' yix̱ə' gan' ža' bia zan xcoše' par nic̱h ɉəye'eb. ");
INSERT INTO zavNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Na' tant gwdone' xte goclaže'e gaogüe' de'en chsa'o coš ca', pero ni ḻen cui boso'onežɉue'ene' gaogüe'. ");
INSERT INTO zavNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Na' beyone' to xbab šao' na' gwne': “Nitə' mos zan c̱he x̱a'anə', na' dechgua de'e chsa'ogüe', na' nada' gatəda' yeḻə' chdon. ");
INSERT INTO zavNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yeza'a nga na' yeya'a gan' zo x̱a'anə', na' yapa'ane': X̱a, babena' de'e mal lao Diozən' na' laogo' le'. ");
INSERT INTO zavNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na' bitoch zaca'a gono' nada' cuent ca xi'iṉo', con šə go'o latɉə gaca' xmoso'.” ");
INSERT INTO zavNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nach beze'e beyeɉe' gan' zo x̱e'enə'. Na' zitə'ələ ze'e yežine' catə' ble'i x̱e'en ḻe', na' gwsa'adoe' ɉəšague'ene', na' gwdeḻe'ene' gwdaogüe'ene' bxid c̱hedə' beyašə' beži'ilaže'ene'. ");
INSERT INTO zavNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nach gož xi'iṉe'enə' ḻe': “X̱a, babena' de'e mal lao Diozən' na' laogo' le', na' bitoch zaca'a gono' nada' cuent ca xi'iṉo'.” ");
INSERT INTO zavNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Na' x̱e'enə' gože' xmose'en: “Ɉəleɉ tgot lachə' šao' na' guaco'obo'on. Na' ɉəx̱i' to niy na' gwdio'on xbembo'on, na' ɉəx̱i' šcue' yel na' gwdio'on ṉi'abo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Na' ɉəx̱i' go'oṉ da'onə' bian' chaṉə' na' betəb par gaochob, na' goncho lṉi. ");
INSERT INTO zavNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","La' xi'iṉa' nga babena'abo' cuent ca to bi'i guat, pero ṉa'a zobo' mbambo'. Gwleɉyic̱hɉbo' chio'o, pero ṉa'a babeḻa'abo'.” Na' gwzolao chso'one' lṉin'. ");
INSERT INTO zavNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Na' xi'iṉe' nechən' zde' yoba catə'ən bežin xi'iṉe'en yeto. Na' catə' zeza' ben' gwyeɉ yoban' bazon yežine' liž x̱e'enə' catə' benene' choso'ocueže' na' choso'oye'e. ");
INSERT INTO zavNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Na' goxe' to mosən' na' gwṉabene' ḻe' bixc̱hen' chso'one' lṉin'. ");
INSERT INTO zavNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Na' mosən' gože'ene': “Bi'i bišo'onə' babeḻa'abo' na' x̱a'onə' babete' go'oṉ dao' bian' chaṉə' c̱hedə' beḻa'abo' to šao' to güen.” ");
INSERT INTO zavNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nach xi'iṉe' nechən' bže'e, na' bito gone'ene' yeyo'e liž x̱e'enə'. Nach bchoɉ x̱e'enə' gotə'əyoine' ḻe' yeyo'e. ");
INSERT INTO zavNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero xi'iṉe' nechən' gože' x̱e'enə': “Zan iz bachac zoa' nga chonteza' žin con can' chono' mendad. Na' bitoṉə' gaca' beṉə' godenag. Na' ni tozə šib dao' cuiṉə' goṉo' nada' par gota'ab gona' lṉin' len beṉə' migw c̱hia' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Na' ṉa'a bela' xi'iṉo' nga bi'in benditɉei yoguə'əḻoḻ de'en bnežɉo'obo' gwza'alembo' no'olə sargat, na' beto' par ḻebo' to go'oṉ dao' bian' chaṉə'əch.” ");
INSERT INTO zavNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Na' x̱e'enə' gože'ene': “Xi'iṉdaogua'a, le' zotezo' len nada', na' yoguə'əḻoḻ de'e deida' naquən c̱hio'. ");
INSERT INTO zavNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero cheyaḻə' goncho lṉi nga ṉa'a tant chebeicho babela' bi'i bišo'onə', c̱hedə' babena'abo' cuent ca to bi'i guat, pero ṉa'a zobo' mbambo'. Gwleɉyic̱hɉbo' chio'o pero ṉa'a babeḻa'abo'.” ");
INSERT INTO zavNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Na' ḻeczə gož Jeso'osən' disipl c̱he' ca': ―Gwzo to beṉə' gwni'a na' gwzo to mos əblao c̱he' beṉə' gwyo'o lao ne'e bia yix̱ə' c̱he' ca' na' biquə'əchlə de'en de c̱he'. Na' beṉə' gwni'anə' benene' rson de que xmosen' babenditɉeine' de'en de c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nach x̱ane'en goxe' ḻe' na' gože'ene': “Babenda' to dižə' can' chono'. Cheyaḻə' gono' cuent c̱he yoguə'əḻoḻ de'en babc̱hino' c̱hia' c̱hedə' bitoch gaquə gono' xšina'anə' ṉa'a.” ");
INSERT INTO zavNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nach mosən' bene' xbabən': “¿Bixa gona'? X̱ana'an bacholague' nada' cuich gaquə gona' xšine'enə', na' nic chac gona' žin gual na' gaquəda' zto' šə ṉaba' carida. ");
INSERT INTO zavNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ṉezda' bi gona' par nic̱h ṉitə' beṉə' yesə'əgüialaogüe' nada' catə' cuich chona' žin c̱he x̱ana'an.” ");
INSERT INTO zavNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Na' goxe' yoguə' beṉə' ca' chsa'aḻə' xmech x̱ane'enə' tgüeɉə tgüeɉe'. Na' gože' beṉə' nechən': “¿Ɉa'aquə' chaḻo'o c̱he x̱ana'anə'?” ");
INSERT INTO zavNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Na' be'enə' gože'ene': “Chaḻa'a c̱he tapa mil ḻitr set.” Nach gož mosən' be'enə': “Gwche'edo', na' bzoɉ lao cuentən' de que chaḻo'o c̱he c̱hopa mil ḻitrzə setən'.” ");
INSERT INTO zavNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Gwde na' gože' beṉə' əgwchopen': “¿Ɉa'aquən' chaḻo'o c̱he x̱ana'anə'?” Nach be'enə' gože'ene': “C̱he to mil rob trigw.” Nach mosən' gože' be'enə': “Gwche'edo', na' bzoɉ lao cuent c̱hio'onə' de que chaḻo'o c̱he x̱on' gueyoa robzə trigon'.” ");
INSERT INTO zavNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Na' x̱an mos gox̱oayaguən' gocbe'ine' ḻechguaḻe bib naquə be'enə' de'en bene' xbab naclən' gone' par nic̱h soe' binḻo len lɉuežɉe' ca' beṉə' ca' chsa'aḻə' c̱he x̱ane'en. Nada' chnia' le'e de que beṉə' ca' zɉəchi' yic̱hɉga'aque' porzə de'en chac lao yežlyon' chso'onchgüe' xbab naclən' so'one' len de'en zɉədeine'. Pero zan beṉə' ca' bazɉəyo'o be'eni' c̱he Diozən' ḻo'o yic̱hɉla'ažda'oga'aque'enə' bito chso'one' xbab naclən' yesə'əc̱hine' de'en zɉədeine'. ");
INSERT INTO zavNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ṉa'a əchnia' le'e, de'en deile yežlyo nga de'e te c̱hein', pero ḻegwc̱hin ḻen par nic̱h ṉitə' migw c̱hele, na' catə' babeya bi de'en deile yežlyo nga, ṉitə' beṉə' yozene'e le'e catə' yežinḻe yoban' gan' sole zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Šə to beṉə' chone' can' cheyaḻə' gone' len de'e cuitec zaquə' ḻeczə gone' can' cheyaḻə' len de'e zaquə'əchgüei, na' beṉə' cui chone' can' cheyaḻə' gone' len de'e cuitec zaquə', ḻeczə bito gone' can' cheyaḻə' len de'e zaquə'əchgüei. ");
INSERT INTO zavNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Šə le'e cui chonḻe can' cheyaḻə' gonḻe len de'en deile yežlyo nga de'e te c̱hei, bito goṉ Diozən' le'e de'e zaquə'əche de'en cui te c̱hei. ");
INSERT INTO zavNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","De'en deile yežlyo nga c̱he Dioz na'anə', caguə c̱helen'. Na' šə bito chonḻe can' cheyaḻə' gonḻe len de'en naquə c̱he'enə', bito goṉe' le'e de'e zaquə'əche de'e cui te c̱hei. ");
INSERT INTO zavNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Notono no gaquə so liž c̱hopə x̱an žin par gaque' xmosga'aque' tši'izə, c̱hedə' la' šə gone' ca', gue'ine' to x̱an žinṉə' na' gaquene' c̱he yetoe', o gone' žin c̱he toe' do yic̱hɉ do laže'e na' bito bi respet gape' c̱he x̱ane'en yeto par gone' xšine'enə'. Ḻeczə ca' le'e bito gaquə gonḻe xšin Diozən' do yic̱hɉ do lažə'əle na' gonte xšinḻe par gacle beṉə' gwni'a. ");
INSERT INTO zavNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Na' ḻeczə gwnitə' beṉə' fariseo ca' gwse'enene' xtižə' Jeso'osən' na' gwso'onene' borl, c̱hedə' gwso'elažə'əche' əsa'aque' beṉə' gwni'a. ");
INSERT INTO zavNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Na' gož Jeso'osən' ḻega'aque': ―Le'e ža, chonḻe par nic̱h beṉac̱hən' chesə'əne' c̱hele de que zdaczle ḻicha, pero Diozən' ṉez nḻe'ine' yic̱hɉla'ažda'olen'. Zɉəde de'en chsa'aque beṉac̱hən' zɉənaquən de'e žialao xen pero baḻən zɉənaquən de'e chgue'i Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Na' gozna Jeso'osən': ―Antslə con ḻei de'en bzoɉ de'e Moisezən' na' len de'en boso'ozoɉ profet ca' bzeɉni'in chio'o c̱he Diozən'. Pero ṉa'a de'e Juanṉə' babedətix̱ɉui'e dižə' güen dižə' cobən' de que Diozən' ṉabi'e con notə'ətezə beṉə' soe' latɉə, na' ḻeczə ca' neto' chyix̱ɉue'eto'on. Na' beṉə' zan chesə'əzo chesə'əbi'e naclə so'one' par nic̱h ṉabia' Diozən' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ca naquə bitə'ətezə pont dao' c̱he ḻei c̱he Diozən' bito te c̱hei pero ca naquə yežlyon' len de'e ca' zɉəžia ḻe'e yoban' yesə'əde c̱hega'aquei. ");
INSERT INTO zavNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Notə'ətezə beṉə' chela'a no'ol c̱he'enə' par yeque'e no'olə yoblə, tozəczə ca malən' naquən len de'en chon beṉə' chgo'o xtoe'. Na' yoguə' no beṉə' yošagne'e len to no'olə beṉə' bela'a ben' c̱hei ḻe', ḻeczə tozəczə ca malən' naquən len de'en chon beṉə' chgo'o xtoe'. ");
INSERT INTO zavNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nach gozna Jeso'osən': ―Gwzo to beṉə' gwni'a, na' ḻechguaḻe xoche goquə xala'ane'enə', na' ḻechguaḻe gwdaošaogüe'e yoguə' ža. ");
INSERT INTO zavNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na' to beṉə' yašə' le' Lac̱h yoguə' ža bzo beṉə' ḻe' cho'a puert zaguan c̱he beṉə' gwni'anə' par gwṉabe' carida. Na' Lac̱hən' ḻechguaḻe gwžia yežə' doxen cuerp c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Na' tant gwdone' gone'ene' gaogüe' pedas dao' yeḻə' guao c̱he beṉə' gwni'anə' de'en besə'əxopə lao yon'. Na' beco' ca' ɉa'aquəb ɉəsə'əḻe'eb yežə'ən gwžia cuerp c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Na' catə' got beṉə' probən', nach angl ca' besyə'əzi' besyə'əque'e ḻe' yoban' gan' zoe' len de'e x̱axta'ocho Abraanṉə'. Na' ḻeczə got beṉə' gwni'anə' na' bosə'əcuaše'ene'. ");
INSERT INTO zavNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Na' beyeɉe' gan' ža' beṉə' ca' bagwsa'at. Na' lao chžaglaogüe' na' gwḻis laogüe'enə' na' ble'ine' zitə'ələ nitə' Abraanṉə' lene' Lac̱hən' yoban'. ");
INSERT INTO zavNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Na' gwṉe' zižɉo gwne': “X̱a Abraam, beyašə'əlažə'əšguei nada', na' bseḻə' Lac̱hən' par yosbise' loža'an len latə' nis de'en yexopə xbene'enə' c̱hedə' la' ḻechguaḻe chžaglaogua' ḻo'o yi' nga.” ");
INSERT INTO zavNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero na' Abraanṉə' gože' ḻe': “Xi'iṉa' bosa'alažə' catə' lao bguano' yežlyon' porzə de'e šao' de'e güen gotə' c̱hio', na' Lac̱h nga porzə de'e mal goc c̱he'. Na' bazoe' mbalaz nga ṉa'a, na' le' chžaglaogo'. ");
INSERT INTO zavNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Bito gaquə gone' can' che'endo' c̱hedə' la' Diozən' bac̱h bzie' to bdiṉɉ xen ga cui no zaquə' te entr neto' na' le'e par nic̱h ca' bito gaquə yidəto' gan' zolen', na' nic gaquə da'ac le'e nga.” ");
INSERT INTO zavNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Nach beṉə' gwni'anə' gože' Abraanṉə': “Beṉə' gol dao', chatə'əyoida' le', bseḻə'əšga Lac̱hən' liž x̱a'anə'. ");
INSERT INTO zavNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nitə' gueyə' beṉə' biša'a, na' che'enda' c̱hix̱ɉue'ine' ḻega'aque' naquən' so'one' par nic̱h Diozən' bito əseḻe'e ḻega'aque' latɉə nga gan' yesə'əžaglaogüe'.” ");
INSERT INTO zavNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraanṉə' gože' ḻe': “Deczə ḻibr de'en bzoɉ de'e Moisezən' na' ḻibr de'en boso'ozoɉ de'e profet ca' beṉə' ca' gwso'e xtižə' Diozən'. Cheyaḻə' yoso'ozenague' c̱he de'e ca' zɉənyoɉən'.” ");
INSERT INTO zavNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Na' gože' Abraanṉə': “Bito beṉə' gol dao'. Žalə' to beṉə' yebane' ladɉo beṉə' guat ca' güe'elene' ḻega'aque' dižə', la' gosyə'ədiṉɉene' xtoḻə'əga'aque'enə'.” ");
INSERT INTO zavNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nach gož Abraanṉə' ḻe': “Šə bito choso'ozenague' c̱he de'en bzoɉ de'e Moisezən' na' de'e profet ca', ḻa'aṉə'əczə šə yeban to beṉə' ladɉo beṉə' guat ca', bito se'eɉḻe'e c̱he Diozən'.” ");
INSERT INTO zavNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nach gož Jeso'osən' disipl c̱he' ca': ―Syempr de de'en gonən ca yesə'əxopə beṉə' so'one' de'e malən'. Pero probchguazə beṉə' chone' ca yesə'əxope' so'one' de'e malən'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nca'alə xṉeze žalə' yoso'oc̱heɉe' yene'enə' to yeɉ yišə' na' žɉəsə'əzaḻe'ene' ḻo'o nisda'onə' cle ca soe' gone' ca əxopə beṉə' gone' de'e malən' ḻa'aṉə' tozə beṉə' cuitec bi zaquə' len beṉac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ḻe'e gon xbab c̱hele, šə to beṉə' bišə'əcho beṉə' bachonḻilažə' Diozən' gone' mal contr tole, ben' bene' contr cheyaḻə' gatə'əyoine' ḻe' yediṉɉene' xtoḻe'enə', na' šə yediṉɉene' xtoḻe'enə' cheyaḻə' yezi'ixene' c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ḻa'aṉə'əczə gaž las lao tža gone' de'e mal contr beṉə' biše'enə', šə gaž laste əṉe': “Babeyeɉda' c̱he de'en bena', bezi'ixen c̱hia'”, na' cheyaḻə' yezi'ixene' c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nach gwse' apostol ca' X̱anchon': ―Gaquəlenšgo' neto' par nic̱h gonḻilažə'əchto' Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nach gož X̱anchon' ḻega'aque': ―Xsa yag moztasən' naquən de'e dao' rizə'. Na' ḻa'aṉə'əczə de'en chonḻilažə'əle Diozən' gwxaquə'əleben ca to xsa moztasən' laogüe de'en cuiṉə' gonḻilažə'əchgualene', guac ye'ele yag yix̱güio nga: “Boša' xišna'o nga na' žɉəyezo' ḻo'o nisda'onə'”, na' guaquəczə can' ṉalenə'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ca naquə costombr c̱helen' šə mos c̱helen' chgua'aṉe' go'oṉ o chapə chye' xilə', catə' chele'e goyebən' bito che'elene': “Beyo'o ngalə gwche'edo' gaogo' xše'.” ");
INSERT INTO zavNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Cle che'elene': “Bsi'ini'a de'en ye'eɉ gaogua' na' gwdio' de'en gaogua'anə'. Te yedaogua'anə' nach gaogo'.” ");
INSERT INTO zavNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Na' bito cho'elene' yeḻə' chox̱cwlen catə' babene' de'en gožlene' gone'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Na' ḻeczə ca' le'e nacle disipl c̱hia', catə' babenḻe yoguə'əḻoḻ de'en nona' mendad gonḻe cheyaḻə' əṉale: “Bito bi zaquə'əto' par goṉo' yeḻə' chox̱cwlen c̱heto', c̱hedə' de'en babento'onə' la' de'e cheyaḻə'əczə gonto'onə'.” ");
INSERT INTO zavNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Lao zda' Jeso'osən' Jerosalenṉə' len disipl c̱he' ca' na' gwdie' gan' zɉəndiḻ distrit c̱he Samaria len Galilean'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Na' besə'əžine' to cho'a yež dao' na' besə'əchoɉ ši beṉə' zɉesə'əšague' Jeso'osən', beṉə' ca' chse'i yižgüe' de'en nzi' ḻepr, na' gosə'əzeche' zitə'ələ. ");
INSERT INTO zavNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Na' gosə'əṉe' zižɉo gwse'ene': ―Maestr Jeso'os, beyašə'əlažə'əšguei neto'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Na' Jeso'osən' catə' ble'ine' ḻega'aque' gože' ḻega'aque': ―Ḻežɉəya'ac lao bx̱oz ca' nic̱h yesə'əgüie' le'e. Na' goquən' lao zezyə'əngüe'e nezən' besyə'əyaquene'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nach toe' catə' gocbe'ine' de que bac̱h beyaquene' na' bebi'e na' gwṉe' zižɉo be'elaogüe'e Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Na' bzo xibe' lao Jeso'osən' na' be'ene' yeḻə' chox̱cwlen. Be'enə' ben ca' naque' to beṉə' Samaria. ");
INSERT INTO zavNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nach gwna Jeso'osən': ―Ši beṉə' can' beyona'. ¿Gaṉxa beṉə' ca' yegan'? ");
INSERT INTO zavNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tozə beṉə' zitə' nga bebi'e par cho'elaogüe'e Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nach gož Jeso'osən' be'enə': ―Bezoža' na' beyeɉ to šao' to güen. Babeyacdo' c̱hedə' c̱honḻilažo'o nada'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Na' goquən' beṉə' fariseo ca' gosə'əṉabene' ḻe' batxan' yidə ben' əseḻə' Diozən' par ṉabi'e ṉasyon Izraelən'. Nach boži' Jeso'osən' xtižə'əga'aque'enə' gwne': ―Ca naquən' ṉabi'enə' bito naquən to de'e le'icho. ");
INSERT INTO zavNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Notono no cheyaḻə' əṉe': “Bgüiašc nga chnabi'e”, o “Na' chnabi'e”, c̱hedə' bazoe' ṉa'a entr le'e chnabi'e. ");
INSERT INTO zavNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nach gože' disipl c̱he' ca': ―Gwžin ža catə'ən ṉale: “Žalə'əga ṉa'a bac̱h zocho yoban' gan' chnabia' ben' bseḻə' Diozən'.” Pero bito gaquə can' chṉablažə'əlenə'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nitə' beṉə' əse'e le'e: “Bgüiašc nga chnabi'e”, o “Bgüiašc na' chnabi'e”, pero le'e bito ṉaole beṉə' ca' əse'e le'e ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Can' chac catə' chep yesən' chse'eni'in doxenḻə ḻe'e yoban' to de repentzə, ḻeczə can' gaquə catə'ən əžin ža yida' de'e yoblə, nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h yida' to de'e repentzə na' yoguə'əḻoḻ beṉə' yesə'əle'ine' nada'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Zgua'atec de de'e zan de'e cheyaḻə' c̱hi' saca'a, na' ṉezda' de que beṉə' ca' ža' ṉa'a bito se'eɉḻe'e c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ḻeczə can' goquə ca tyemp c̱he Noenə', ḻeczə can' gaquə catə'ən bazon əžin ža yida' de'e yoblə, nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Beṉə' gwnitə' ca tyemp c̱he Noen' gwža'azeche' gwse'eɉ gwsa'ogüe' na' gwso'elaozechga'aque' bosə'əšagne'e na' boso'ošague' na' no xi'iṉga'aque' xte catə'ən bžin ža gwyo'o Noen' ḻo'o barcon', na' goc to yeɉw sio' juisy nach gosə'əbiayi' yoguə' beṉə' ca' cui gwso'o ḻo'o barcon'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ḻeczə can' goquə ca tyemp c̱he Lotən'. Beṉə' Sodoma ca' gwža'azeche' gwse'eɉ gwsa'ogüe', gwso'ote'e no bia yix̱ə' c̱hega'aque' na' bichlə de'e de c̱hega'aque', na' gosə'əzi'e bi de'en besə'əyažɉene' na' gwsa'az gwsa'aṉe' na' gwso'on ližga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero na' žan' beza' Lotən' Sodoman', Diozən' bene' par nic̱h ḻechguaḻe byiṉɉ yi' na' sofr yobanə' na' gosə'əbiayi' yogue'e. ");
INSERT INTO zavNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Can' gaquə catə'ən yida' de'e yoblə, nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h, na' yoguə'əḻoḻ beṉə' yesə'əle'ine' nada'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Na' žan' yida' šə na'aclə zo to beṉə' chone' dezcanz lao sotea c̱he' liže'enə' na' šinḻaze'enə' ža'an ḻo'o yo'onə', cui yeyetɉe' par yetobe' šinḻaze'enə', con cueɉyic̱hɉe'en. Na' ḻeczə ca' ben' zo do yoba bito gaquene' yeyeɉ liže'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ḻe'e žɉsa'alažə' can' goc c̱he no'ol c̱he Lotən'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Notə'ətezə beṉə' chaquene' gone' par nic̱h cui c̱hi' saque'e o par nic̱h cui no got ḻe', be'enan' cuiayi'. Na' notə'ətezə beṉə' chsanḻažə' cuine' c̱hi' saque'e o so'ot beṉə' ḻe' por ni c̱hia', bade yeḻə' mban c̱he'enə' zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Echnia' le'e, quinga gaquə že'enə' catə'ən yida' de'e yoblə: C̱hopə beṉə' zɉədie' chəsə'ətase', toe' yezi' yeca'a Diozən' na' toe' yega'aṉ. ");
INSERT INTO zavNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Na' c̱hopə no'olə ṉitə' txen chso'ote', toe' yezi' yeca'a Diozən', na' toe' yega'aṉ. ");
INSERT INTO zavNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Na' c̱hopə beṉə' ṉitə' do yoba, toe' yezi' yeca'a Diozən' na' ḻeczə yega'aṉ toe'. ");
INSERT INTO zavNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Catə' gwse'enene' dižə' quinga, gwse'ene': ―¿Gan' gaquə de'e quinga X̱anto'? Nach Jeso'osən' gože' ḻega'aque': ―Ngale'en chonen c̱he ben' ne': “Gan' de bia guat nan' chesə'əžag šod ca'.” ");
INSERT INTO zavNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Na' be'elene' ḻega'aque' to jempl par nic̱h bsed blo'ine' ḻega'aque' de que cheyaḻə' so'ontezə so'one' orasyon sin cui žɉəx̱aquə'əlažə'əga'aque'. Na' gože' ḻega'aque': ");
INSERT INTO zavNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","―Gwche' to syoda gan' gwzo to juez. Na' juezən' bito gwdape' Diozən' respet na' nic gwche' yic̱hɉe' šə chsa'azlažə' beṉac̱hən' can' chone'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na' lao syodan' gwzo to no'olə gozebə na' goxɉzə cheɉe' lao juezən' na' che'e ḻe': “Bosla nada' lao na' beṉə' contr c̱hia'anə'.” ");
INSERT INTO zavNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Bagoc sša bito bzenague' c̱he', pero gwdelə bene' xbabən' na' gwne': “Bito chapa' Diozən' respet na' nic chi' yic̱hɉa' šə chsa'azlažə' beṉac̱hən' can' chona'. ");
INSERT INTO zavNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Pero yosla' no'olə nga lao na' beṉə' contr c̱he' la' ḻechguaḻe zed chone'ene' nada'. Šə bito gona' yeḻə' jostis c̱he'enə' bitoch soida' tant zed chedeyenene' nada'.” ");
INSERT INTO zavNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nach gož X̱anchon' ḻega'aque': ―Ḻe'e gon xbab c̱he de'en gwna juezən' ben' cui zda ḻicha. ");
INSERT INTO zavNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Naquəchxe gon Diozən' gwzenague' c̱he beṉə' ca' bagwleɉe' par zɉənaque' xi'iṉe', beṉə' ca' chso'olgüiž ḻe' do ža do yel. Goslacze' ḻega'aque' lao na' beṉə' contr c̱hega'aque' ca' ḻa'aṉə'əczə šə əsa'aquene' de que bachžeine'. ");
INSERT INTO zavNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Echnia' le'e, to žalṉezdao' Diozən' yosle' ḻega'aque' lao na' beṉə' contr c̱hega'aque' ca'. Pero catə' nada' yida' yežlyo nga yetlas, nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h, cuili ṉe'e ṉitə' beṉə' ṉe'e chso'onḻilaže'e nada' par yosla' ḻega'aque' lao na' beṉə' contr c̱hega'aque' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Na' gwnitə' baḻə' beṉə' zɉənapəchgua confyanz cuinga'aque' de que zɉənaque' beṉə' güen lao Diozən' ca de'en chso'one'enə'. Beṉə' ca' zɉənone'en de que beṉə' yeziquə'əchlə bito bi zɉəzaque'e. Na' Jeso'osən' be'e jempl nga par beṉə' ca' zɉənapəchgua confyanz cuinga'aque', gwne': ");
INSERT INTO zavNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―C̱hopə beṉə' ɉa'aque' ḻo'o yo'odao' əblaonə' ɉse'ene' orasyon, toe' beṉə' fariseo na' ben' yeto beṉə' goc̱hixɉw. ");
INSERT INTO zavNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Beṉə' fariseon' gwzeche' na' bene' orasyonṉə' cho'elao' cuine' na' gwne' quinga: “Dioz, choṉa' yeḻə' chox̱cwlen c̱hio' c̱hedə' bito chona' can' chso'on yeziquə'əchlə beṉə'. Bito chca'a bi de'e de c̱he beṉə' yoblə, na' bito chona' bichlə de'e mal. Bito naca' beṉə' ggo'o xtoi, nic chbeɉyic̱hɉa' no'ol c̱hia' par solena' beṉə' yoblə, na' nic naca' beṉə' mal can' naquə beṉə' goc̱hixɉw nga. ");
INSERT INTO zavNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","C̱hopə ža lao to xman chzoa' cui chaogua'. Na' yoguə'əḻoḻ gan de'en chona', chona'an ši cue'elə na' chnežɉua' tcue'en par yo'oda'onə'.” ");
INSERT INTO zavNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Na' beṉə' goc̱hixɉon' gwzechateze' zitə'ələ, na' xte nic cheyaxɉene' əḻis laogüe'enə' əggüie' yoban', na' chbažə' lc̱ho'enə' gwne': “Dioz, beyašə'əlažə'əšguei nada' beṉə' güen de'e mal.” ");
INSERT INTO zavNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ca'azə de'e gwna beṉə' goc̱hixɉon'. Na' əchnia' le'e, Diozən' bezi'ixene' c̱he beṉə' goc̱hixɉon', na' beyeɉe' liže' sin cui bi xtoḻe'e gotə'. Caguə ca' beṉə' fariseon'. Na' notə'ətezcho cho'elao' cuincho, Diozən' gone' par nic̱h gacbe'icho de que bitobi zaquə'əcho. Na' notə'ətezcho choncho xbab de que bitotec bi zaquə'əcho, Diozən' goṉe' chio'o yeḻə' bala'aṉ. ");
INSERT INTO zavNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Na' ɉa'ac beṉə' ɉso'e bidao' lao Jeso'osən' par nic̱h əx̱oa ne'enə' yic̱hɉga'acbo' na' gone' orasyon c̱hega'acbo'. Na' catə' besə'əle'i disipl ca' can' chso'one'enə', gosə'ədiḻe' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero na' Jeso'osən' goxga'aque'ebo' na' gože' disipl c̱he' ca': ―Ḻe'e güe' latɉə la'ac bidao' ca' laogua' nga, na' cui əgwžonḻe. Na' əchnia' le'e, beṉə' ca' chəsə'əzex̱ɉw yic̱hɉga'aque' lao Diozən' can' chəsə'əzex̱ɉw yic̱hɉ bidao' ca' lao x̱axna'aga'acbo', ḻega'acze'enə' chso'e latɉə chnabia' Diozən' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Bidao' ca' bito chso'on cuinga'acbo' xen, na' de'e ḻi chnia' le'e, notə'ətezle šə cui yeyacle ca bidao' par güe'ele latɉə ṉabia' Diozən' le'e, bito gaquə yežinḻe yoban' gan' zo Diozən' chnabi'e. ");
INSERT INTO zavNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","To beṉə' gwnabia' gože' Jeso'osən': ―Maestr, le' naco' beṉə' güen, gwna nada' bi de'en cheyaḻə' gona' par nic̱h gatə' yeḻə' mban zeɉḻicaṉe c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Na' par nic̱h gon be'enə' xbab c̱he de'en ne', Jeso'osən' gože'ene': ―¿Bixc̱hen' nao' de que naca' beṉə' güen? Dioz nan' naque' ḻe'ezelaogüe beṉə' güen. ");
INSERT INTO zavNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Le' ṉezdo' bin' na ḻein': “Cui co'o xtole, na' cui cueɉyic̱hɉle be'en c̱hele o no'ol c̱hele par solenḻe beṉə' yoblə; cui gotle beṉə'; cui cuanḻe; bito gacle testigw faḻs contr sa'alɉuežɉle; gwnežɉwle yeḻə' bala'aṉ x̱axna'ale.” ");
INSERT INTO zavNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nach gož be'en ḻe': ―Yoguə'əḻoḻ de'e quinga chona'an dezd xcuida'a. ");
INSERT INTO zavNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nach catə' bene Jeso'osən' xtiže'en na' gože'ene': ―Tozə de'en ṉe'e chac faḻt gono'. Ɉəyeyetə' yoguə'əḻoḻ bi de'e de c̱hio', na' mech de'en le'ido' c̱he de'e ca' bnežɉon beṉə' yašə', nach da denao nada'. Na' catə' yežino' yoban' gan' zo Diozən', de'e zaquə'əche gatə' c̱hio'. ");
INSERT INTO zavNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pero na' be'enə' catə' beyož benene' dižə' de'en gož Jeso'osən' ḻe', gwzechachoe' trist, c̱hedə' la' goque' to beṉə' gwni'achgua. ");
INSERT INTO zavNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Na' bgüia Jeso'osən' beṉə' gwni'anə', na' gwne': ―Zdebəchgua naquən par to beṉə' gwni'a güe'e latɉə par nic̱h ṉabia' Diozən' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Zdebəchlə naquən par to beṉə' gwni'a güe'e latɉə ṉabia' Diozən' ḻe' cle ca par to camey teb to ḻo'o nag yešə'. ");
INSERT INTO zavNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Na' beṉə' ca' boso'ozenague' xtiže'enə' gwse'ene': ―¿Noxan' yechoɉ xni'a de'e malən' ža? ");
INSERT INTO zavNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Na' Jeso'osən' gože' ḻega'aque': ―De'en cui gaquə gon beṉac̱hən', bito ṉacho cui gaquə gon Diozən' ḻen. ");
INSERT INTO zavNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nach Bedən' gože' ḻe': ―Neto' bagwleɉyic̱hɉto' famiḻy c̱heto' ca' na' len de'en deito' par chonḻilažə'əto' le' na' chzenagto' c̱hio'. ");
INSERT INTO zavNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Na' gož Jeso'osən' ḻega'aque': ―De'e ḻi chnia', šə nole bagwleɉyic̱hɉle ližle, xo'olle, bišə'əle, x̱axna'ale o xi'iṉle c̱hedə' cho'ele latɉə chnabia' Diozən' le'e, ");
INSERT INTO zavNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Diozən' goṉe' le'e de'e zaquə'əche lao yežlyo nga ṉa'a clezə ca de'e ca' na' beṉə' ca' bagwleɉyic̱hɉle. Na' catə' yežinḻe yoban' gone' par nic̱h əbanḻe zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Na' gwleɉ Jeso'osən' apostol ca' šižiṉ ca'alə, na' gože' ḻega'aque': ―Ṉa'a šeɉcho Jerosalenṉə' gan' gaquə yoguə'əḻoḻ de'en baboso'ozoɉ de'e profet ca' c̱hia', nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Gaca' lao na' beṉə' ca' cui zɉənaquə beṉə' Izrael, na' so'one' nada' borl na' yesə'əzi'ic̱hiže'e nada', nach yoso'oža' x̱ene'e cho'alaogua'anə'. ");
INSERT INTO zavNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Yesə'əyine' nada' yid sot nach so'ote' nada', pero yeyoṉ ža yebana' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero disipl c̱he' ca' bito gwse'eɉni'ine' de'en gože' ḻega'aque'. Zɉənc̱hoḻ yic̱hɉla'ažda'oga'aque'enə', de'e na'anə' bito gwse'eɉni'ine'en. ");
INSERT INTO zavNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nach lao bazon əžin Jeso'osən' Jericon', to beṉə' lc̱hoḻ chi'e cho'a nezən' chṉabe' carida. ");
INSERT INTO zavNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Na' benene' chesə'əde beṉə' zan, na' gwṉabe' bin' chac. ");
INSERT INTO zavNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nach gwse'ene': ―Jeso'os beṉə' Nasaretən' chdie' laogo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Na' gwṉe' zižɉo gwne': ―Jeso'os, len' naco' xi'iṉ dia c̱he de'e Rei Dabin', ¡beyašə'əlažə'əšguei nada'! ");
INSERT INTO zavNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nach beṉə' ca' zɉəžialao lao Jeso'osən' gosə'ədiḻe' beṉə' lc̱hoḻən' gwse'ene' de que cheyaḻə' soe' žizə, pero nachle gwṉe' zižɉochlə gwne': ―Len' naco' xi'iṉ dia c̱he de'e Rei Dabin', ¡beyašə'əlažə'əšguei nada'! ");
INSERT INTO zavNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jeso'osən' gwleze' nach bene' mendad əžɉso'e beṉə' lc̱hoḻən' laogüe'enə' na' catə' bgüiguə' beṉə' lc̱hoḻən' lao Jeso'osən' nach gože'ene': ");
INSERT INTO zavNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Bi che'endo' gona' len le'? Nach beṉə' lc̱hoḻən' gože'ene': ―X̱ana' benšga par nic̱h yele'ida'. ");
INSERT INTO zavNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jeso'osən' gože'ene': ―Bele'i. De'en chonḻilažo'o nada' bac̱h goc can' che'endo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Na' ḻe'e bele'iteine' na' gwnaogüe' Jeso'osən' be'elaogüe'e Diozən', na' ḻeczə ca' yoguə' beṉə' ca' besə'əle'ine' can' goquən' gwso'elaogüe'e Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nach Jeso'osən' gwyo'e Jericon' na' gwdeze' yešḻa'a syodan'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Na' zo to beṉə' le' Saqueo. Naque' beṉə' gwnabia' c̱he beṉə' goc̱hixɉw ca', na' naque' beṉə' gwni'a. ");
INSERT INTO zavNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Gwdilɉlaže'e naclə le'ine' Jeso'osən' pero bito goquə, c̱hedə' nitə' beṉə' zan len Jeso'osən' na' Saqueon' goque' to beṉə' bc̱hecw dao'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","De'e na'anə' gwsa'adoe' gwdie' lao beṉə' ca' par ɉəšepe' to lao yag yix̱güio nic̱h goc ble'ine' Jeso'osən', c̱hedə' bazon te Jeso'osən' na'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Pero na' catə' bžin Jeso'osən' xan yaguən', bgüie' lao yaguən' na' gože'ene': ―Saqueo, beyetɉdodo', c̱hedə' cheyaḻə' yega'aṉa' ližo'on ṉeže'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nach Saqueon' beyetɉdoe' chebeine' nach bec̱he'ene' liže'enə' na' be'elaogüe'ene'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pero na' beṉə' ca' zɉənžag len Jeso'osən' catə' besə'əle'ine' can' goquən', yogue'e gosə'əṉelaogüe'e gosə'əne': ―Bazde' liž to beṉə' güen de'e mal par so'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Na' Saqueon' gwzeche' nach gože' X̱anchon': ―X̱ana', gašɉə de'en deida' gwnežɉua'an beṉə' yašə', na' de'en bagwcua'a c̱he beṉə' ca' bx̱oayaga' nic̱h gosə'əyixjue' mazəchlə ca de'en cheyaḻə' yesə'əyixɉue', yonežɉua' ḻega'aque' tap tantən'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Na' Jeso'osən' gože'ene': ―Ṉeža babebeɉ Diozən' le' lao de'e malən' len famiḻy c̱hio', na' de'e ḻi banacle xi'iṉ dia c̱he de'e Abraanṉə' laogüe de'en bachonḻilažə'əle Diozən' can' ben de'e x̱axta'ocho Abraanṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ca naca' nada', bseḻə' Diozən' nada' golɉa' beṉac̱h par zedəlo'ida' beṉə' ca' bachəsə'əbiayi' de que nži'ilaža'a ḻega'aque' na' par nic̱h con noe' so'onḻilažə' nada' yebeɉəga'aca'ane' xni'a de'e malən'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Na' žlac ṉezɉənžag beṉə' chse'enene' dižə' de'en choe' Jeso'osən', be'elene' ḻega'aque' to jempl c̱hedə' banite'e gaḻə'əzə Jerosalenṉə' na' gwsa'aquene' de que ḻe'e solaote ṉabi'e ṉasyon Izraelən'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nach gwne': ―Lao to famiḻy blao bchoɉ to beṉə' gwyeɉe' to ṉasyon zitə' ɉene' de'en cheyaḻə' gone' par nic̱h solao ṉabi'e ṉasyon c̱he'enə' catə' yežine'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Na' antslə zese'e gwleɉe' ši mos c̱he'enə' na' bnežɉue' to toe' c̱hopə gueyoa pes güeɉə. Nach gože' ḻega'aque': “Mech nga gonele ṉegosy lao cui zoa'.” ");
INSERT INTO zavNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero beṉə' gwlaž c̱he' ca' besə'əgue'ine' ḻe'. Nach catə' beyož gwze'e boso'oseḻe'e beṉə' lao x̱ane'enə' ben' naquə rein' ɉse'eže'ene': “Bito chene'eto' ṉabia' benga neto'.” ");
INSERT INTO zavNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nach catə' bežin be'enə' laže'en de'e yoblə gwzolao gwnabi'e, nach bene' mendad əžɉa'ac xmose' ca' ši laogüe'enə', beṉə' ca' bocua'aṉlene' mechən'. Gone'ene' əṉezene' ɉa'aquə'ətə' gwso'one' gan len mechən' de'en bocua'aṉlene' to toga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Beṉə' nechən' bžine' laogüe'enə' na' gože'ene': “X̱ana', xmecho' de'en bocua'aṉleno' nada' benən gan ši tant ca de'en bocua'aṉo'.” ");
INSERT INTO zavNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nach x̱ane'en gože'ene': “Babeno' de'e güen. Naco' mos güen na' syempr chono' complir can' cheyaḻə' gono'. Beno' can' cheyaḻə' gono' len de'e da'on bocua'aṉlena' le', na' de'e nan' gona' par nic̱h ṉabi'o ši syoda.” ");
INSERT INTO zavNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Na' beṉə' əgwchopen' bžine' lao x̱ane'enə' na' gože'ene': “X̱ana', xmecho' de'en bocua'aṉleno' nda' benən gan gueyə' tant ca de'en bocua'aṉo'.” ");
INSERT INTO zavNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nach gože' ḻe': “Le' ṉabi'o gueyə' syoda.” ");
INSERT INTO zavNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nach bžin yetoe' lao x̱ane'enə' na' gože'ene': “X̱ana', nga de xmecho' de'en bocua'aṉleno' nada'. Bablažə'əc̱hec̱ha'an bey nga. ");
INSERT INTO zavNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Bžeba' le' la' naco' to beṉə' znia. Chono' gan de'en cui beno' žin c̱hei, na' chzi'o cwseš c̱he de'en chsa'az beṉə' yoblə.” ");
INSERT INTO zavNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nach gož x̱anen' ḻe': “De'en bagwnao' ca' chlo'in de que napo' doḻə'. Naco' mos mal. Chacdo' de que naca' to beṉə' znia, de que chona' gan de'en cui bena' žin c̱hei, na' chzi'a cwseš c̱he de'en chsa'az beṉə' yoblə. ");
INSERT INTO zavNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Na' šə chacdo' chona' ca', ¿bixc̱hen' cui gwleɉo' xmecha'an beṉə' yoblə par nic̱h yezi'an len yic̱hɉei ṉa'a babeḻa'a?” ");
INSERT INTO zavNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nach gože' beṉə' ca' zɉəzecha cuite'enə': “Yeca'ale xmecha'an de'en bocua'aṉlena'ane' na' gwnežɉwlen ben' banox̱ə' c̱hopa mil.” ");
INSERT INTO zavNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nach gwse'ene': “X̱anto', banox̱ə'əcze' ši tant ca de'en bocua'aṉleno'one'.” ");
INSERT INTO zavNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nach gož beṉə' gwnabia'an ḻega'aque': “Echnia' le'e, ben' chon güen len de'en chnežɉua'ane', gwnežɉochcza' c̱he'. Pero na' be'enə' cui chgon žin de'en chnežɉua'ane', yeca'a de'e da'on nox̱e'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na' ca naquə beṉə' ca' chəsə'əgue'i nada', beṉə' ca' bito chse'ene ṉabi'aga'aca'ane', ḻe'e žɉəx̱i'iga'aque' na' gotga'aclene' laogua' nga.” ");
INSERT INTO zavNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Na' catə' beyož be' Jeso'osən' jempl nga, gwze'e zde' Jerosalenṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Na' catə' bgüigue'e yež Betfage na' Betania, gan' zo ya'a de'en nzi' ya'a Olibos, na' gwleɉe' c̱hopə disipl c̱he' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Na' gože' ḻega'aque': ―Ḻe'e žɉa'ac yežən' chi' na', na' catə' šo'ole lao' yežən' le'ile to borr dao' da'ab yag, bia cui noṉə' cuia. Na' əsežleb na' əc̱he'eleb ngalə. ");
INSERT INTO zavNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Šə non' ye'e le'e: “¿Bixc̱hen' chsežleb?” na' ye'elene': “X̱anto' nan' chyažɉene'eb.” ");
INSERT INTO zavNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nach beṉə' ca' bseḻə' Jeso'osən' gwsa'aque' na' besə'əle'ine'eb da'ab gan' gož Jeso'osən' ḻega'aque' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nach lao chosə'əseže'eb, x̱amb ca' gwse'e ḻega'aque': ―¿Bixc̱hen' chsežle borr da'onə'? ");
INSERT INTO zavNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nach disipl ca' gwse'e ḻega'aque': ―C̱hedə' X̱anto'on chyažɉene'eb. ");
INSERT INTO zavNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nach gosə'əc̱he'eb lao Jeso'osən' na' besə'əx̱oa xadoṉ c̱hega'aquen' cožə'əbən', nach boso'ožie' Jeso'osən' cožə'əbən'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Na' lao zde' Jerosalenṉə' žie' cožə' borrən', lao nez gan' zde'enə' boso'ošilɉw xala'an beṉac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Na' gosə'əbigue'e gaḻə'əzə Jerosalenṉə' na' besə'əžine' gan' yesyə'əyetɉe' ya'a Olibosən'. Nach yoguə'əḻoḻ disipl zan c̱he' ca' zɉa'aclene' ḻe' gwzolao ḻechguaḻe besyə'əbeine' na' gwzolao gwso'elaogüe'e Diozən' zižɉo gwso'e dižə' c̱he yoguə'əḻoḻ de'en babesə'əle'ine' de'e zaquə' yebanecho. ");
INSERT INTO zavNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nach gosə'əne': ―Sošga Rei c̱hechon' mbalaz ben' baza' nga bseḻə' X̱ancho Diozən' ḻe'. Ḻedoye'ela'och Diozən' txen len beṉə' ca' nitə' gan' zoe'enə' c̱hedə' babene' par nic̱h beṉac̱hən' gaquə ṉite'e binḻo len ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Na' entr beṉə' zan ca' gwnitə' baḻə beṉə' fariseo. Nach to c̱hope' gwse'e Jeso'osən': ―Maestr, ben mendad ṉitə' disipl c̱hio' ca' žizə. ");
INSERT INTO zavNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nach boži'i Jeso'osən' xtižə'əga'aque'enə' gwne': ―Echnia' le'e, žalə' beṉə' quinga nite'e žizə, yeɉ quinga so'osya'an əso'ela'on nada'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Na' lao bežine' gaḻə'əzə Jerosalenṉə' bgüie' syodan' na' bene' xbab c̱he beṉə' lao syodan' na' gwchežyaše'e. ");
INSERT INTO zavNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Na' gwne': ―¡Žalə' bacheɉni'ile ṉa'a nac gonḻe par sole binḻo len Diozən'! Pero ṉa'a ṉengašə'ən len le'e. ");
INSERT INTO zavNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Gwžin ža gwžin or catə' beṉə' contr c̱hele so'one' to yež de yeɉ de'en šec̱hɉ syodan' par nic̱h notono gac yechoɉ syodan'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Na' əso'ote' le'e na' xi'iṉle ca', na' yosyo'oc̱hiṉɉe' syodan' na' yesye'eyosḻase' yeɉ ca'. Can' gaquə c̱hedə' bito cheɉḻe'ele de que Diozən' babseḻə' nada' laolen' par gaquəlena' le'e. ");
INSERT INTO zavNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Na' Jeso'osən' bžine' yo'odao' əblaonə' na' gwzolaogüe' bebeɉe' yoguə'əḻoḻ beṉə' ca' chso'on ya'a chyo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Na' gože' ḻega'aque': ―Nyoɉczən' ḻe'e Xtižə' Diozən': “Liža'an naquən to latɉə gan' so'on beṉə' orasyon”, pero na' le'e babenḻen ca to latɉə gan' ža' beṉə' bguan. ");
INSERT INTO zavNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Na' bsed blo'ine' beṉə' ca' ža' yo'odao' əblaonə' yoguə' ža. Na' bx̱oz əblao ca' na' beṉə' ca' choso'osed choso'olo'ine' ḻei de'en bzoɉ de'e Moisezən' na' nochlə beṉə' blao c̱he beṉə' Izrael ca' besyə'əyilɉlaže'e naclə so'one' par əso'ote' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero bito besə'əželene' naclə so'one' len ḻe', c̱hedə' yoguə' beṉə' yeziquə'əchlə besyə'əbeichgüeine' xtiže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","To ža lao bsed blo'i Jeso'osən' beṉə' ca' ḻo'o yo'odao' əblaonə' na' chyix̱ɉui'e dižə' güen dižə' cobə c̱he Diozən', besə'əžin bx̱oz əblao ca' na' nochlə beṉə' golə beṉə' blao c̱he beṉə' Izrael ca' na' beṉə' ca' choso'osed choso'olo'i ḻein'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Na' gwse'ene': ―Gwnašc neto', ¿nac goquən' gwxi'o yeḻə' gwnabi'an na' non' beṉ le' yeḻə' gwnabia'anə' par gono' de'e ca' chono'? ");
INSERT INTO zavNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Na' boži'e xtižə'əga'aquen' gwne': ―Ḻeczə de to de'e ṉabda' le'e, ḻenašc nada', ");
INSERT INTO zavNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿non' bseḻə' de'e Juanṉə' bide' bc̱hoe' beṉə' nis? ¿EDioz nan' bseḻe'ene' o šə beṉə' yoblən'? ");
INSERT INTO zavNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Na' boso'oxi'e gosə'əne': ―¿Bi ṉacho? La' šə ṉacho de que Diozən' bseḻe'e de'e Juanṉə' par bc̱hoe' beṉə' nis, nach əṉe' chio'o: “¿Bixc̱hen' bito gwyeɉḻe'ele c̱he'?” ");
INSERT INTO zavNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na' šə ṉacho de que bide' to gwlazze', nach yoguə' beṉə' quinga yosə'əšiže'e chio'o yeɉ c̱hedə' chse'eɉni'ine' de que de'e Juanṉə' goque' to profet beṉə' bseḻə' Diozən' par be'e xtiže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nach gwse'e Jeso'osən' de que bito zɉəṉezene' non' bseḻə' de'e Juanṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nach Jeso'osən' gože' ḻega'aque': ―Ḻeczə ca' nada' bito əṉia' non' beṉ nada' yeḻə' gwnabia' par gona' de'en chona'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Na' be'e jempl nga bzeɉni'ine' beṉə' ca' choso'ozenag c̱he' de que notə'ətezə beṉə' šə chonczə yic̱hɉlaogüe' cui cheɉḻe'e c̱he' cuiayi'e. Na' gwne': ―To beṉə' goze' zan yag obasən' na' bocua'aṉe'en lao na' beṉə' ca' yoso'ogüia yoso'oye'en, na' gwze'e gwyeɉe' ga yoblə na' ɉəyega'aṉe' sša. ");
INSERT INTO zavNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Catə' bžin ža par yesyə'ətobe' cwsešən', bseḻe'e to mos c̱he'enə' lao beṉə' ca' chsa'ape' yag obasən' par nic̱h yosyo'onežɉue'ene' to tlacw c̱he cwsešən' de'en cheyaḻə' si' x̱ane'en. Na' beṉə' ca' chsa'apə yag obasən' gosə'əyine' mosən' na' bosyo'ose'ene' sin cui bi bi bosyo'onežɉue'ene'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nach x̱anga'aque'en bseḻe'e yeto mosən', na' ḻeczə gosə'əyine'ene' na' gwso'one'ene' borl, na' bosyo'ose'ene' sin cui bi bi bosyo'onežɉue'ene'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nach bseḻə' x̱anga'aquen' mos əgwyoṉe, na' ḻeczə gwso'otlate'ene' xte gwso'onene' güe' na' besyə'əbeɉe'ene' fuerlə. ");
INSERT INTO zavNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nach x̱an yag obasən' gwne': “¿Nacxa gona'? Egwseḻa'a xi'iṉa' bi'in chacchgüeida' c̱hei, la' šəquə gwsa'apəlɉe'ebo' respet.” ");
INSERT INTO zavNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero beṉə' ca' chsa'apə yag obasən' catə' besə'əle'ine' xi'iṉe'enə' gosə'əne' entr ḻega'acze': “Bengan' xi'iṉ x̱an yag obasən' na' ḻen' si' bienṉə'. Ḻeda gotchone' par nic̱h si'icho bien c̱he x̱e'enə'.” ");
INSERT INTO zavNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nach besyə'əbeɉe'ene' fuerlə güertən' na' gwso'ote'ene'. Na' ¿nacxa bentgua x̱an yaguən' len ḻega'aque'enə' ža? ");
INSERT INTO zavNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ɉəyeṉitlaogüe' ḻega'aque', na' begüe'e yaguən' lao na' beṉə' yoblə. Na' beṉə' ca' ža'anə' catə' gwse'enene' dižə' quinga de'en be' Jeso'osən' gosə'əne': ―¡Catec de'e mal juisy de'e ca' goquən'! ");
INSERT INTO zavNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Na' Jeso'osən' bgüiachgüe' ḻega'aque' na' gože' ḻega'aque': ―¿Bixa zeɉen ža, de'en nga nyoɉən' ḻe'e Xtižə' Diozən' c̱hia' de'en gwxaquə'əlebəda' ca yeɉ squin?, nan: Yeɉ de'en cui gwso'olažə' mues güen yo'o ca', ḻen banaquən yeɉ squin. ");
INSERT INTO zavNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Na' yoguə' no cui šeɉḻe' c̱hia' gwxaquə'əlebene' ca beṉə' əxopə lao yeɉ na' cue'ežošɉe'. Na' yoguə' no cuiṉə' šeɉḻe' c̱hia' catə' babžin žan' gaquə juisyən', gwxaquə'əlebene' ca beṉə' əxopə yeɉ laogüe'enə' na' əgwšošɉən ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Na' lao or na'atezə beṉə' ca' choso'osed choso'olo'i ḻein' na' beṉə' gwnabia' c̱he bx̱oz ca' gwse'enene' yesə'əzene'ene' c̱hedə' gwse'eɉni'ine' de que Jeso'osən' be'e jemplən' por ni c̱he de'en cui chse'eɉḻe'e c̱he'. Pero bito bi gwso'one' c̱hedə' besə'əžebe' bi so'on beṉə' ca' ža'anə' beṉə' bachse'eɉḻe'e c̱he Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Na' dezd or na'atezə gwzolao gosə'əbe'enaogüe' Jeso'osən' par əchoɉ to dižə' cho'enə' de'en yesə'əc̱hine' par əsa'ogüe' xya c̱he' lao beṉə' gwnabia' c̱he gobierṉən'. De'e na'anə' bosə'əseḻe'e beṉə' chso'on txen len ḻega'aque' lao Jeso'osən' gwsa'aquene' yesə'əx̱oayague'ene' nic̱h gone' xbab de que do lažə'əga'aque' chse'enene' yesə'əṉezene' bi de'en naquən güen so'one'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nach gwse'e ḻe': ―Maestr, ṉezeto' de que cho'o dižə' ḻi, na' naquən ḻicha de'en chsed chlo'ido' beṉə' ca', na' tozə can' chono' len notə'ətezə beṉə'. Na' ṉezeto' de que dižə' ḻin' cho'o chsed chlo'ido' beṉə' can' chene'e Diozən' goncho. ");
INSERT INTO zavNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Na' chene'eto' ṉezeto' ¿əcheyaḻə' c̱hixɉwto' impuest c̱he gobierṉən', o šə cui? ");
INSERT INTO zavNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero gocbe'i Jeso'osən' caguə do lažə'əga'aque'enə' chse'ene' ca', con chse'enene' yoso'ox̱oayague' ḻe', na' gože' ḻega'aque': ");
INSERT INTO zavNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―Ḻe'e gwlo'i nada' to xmechlen'. ¿No diboj c̱hein' da' laogüen' na' no lein' nyoɉ laogüen'? Nach gwse'ene': ―C̱he Rei Sesar na'anə'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nach gože' ḻega'aque': ―Ḻe'e əgwnežɉo Sesarən' de'en naquə c̱he' ža, na' ḻe'e əgwnežɉo Diozən' de'en cheyaḻə' əgwnežɉwlene'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Na' bito gwsa'ac so'one' xtiže'enə' clellə lao beṉə' ca' ža'anə', na' besyə'əbanene' can' boži'e xtižə'əga'aque'enə', na' bitoch bi gosə'əne'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Na' ḻeczə besə'əžin baḻə' beṉə' sadoseo ca' beṉə' ca' cui chse'eɉḻe'e de que yesyə'əban beṉə' guatən', nach gosə'əṉabene' ḻe' ");
INSERT INTO zavNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","gwse'ene': ―Maestr, de'e Moisezən' bzoɉe' can' cheyaḻə' goncho. Na' gwne': “Šə to beṉə' byo beṉə' nšagna' gate' na' yega'aṉ no'ol c̱he'enə' sin cui no xi'iṉe' gwzo, beṉə' bišə' ben' bagotən' cheyaḻə' yeque'e no'olənə' par nic̱h ṉitə' xi'iṉ dia c̱he ben' bagotən'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Na' goquən' gwnitə' gažə bišə'əga'aque', na' toe' bšagne'e na' catə' gote' notono xi'iṉe' gwzo. ");
INSERT INTO zavNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Na' beṉə' biše'e əgwchope beque'e no'olən', na' ḻeczə gote' na' notono xi'iṉe' gwzo. ");
INSERT INTO zavNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Na' beṉə' biše'e əgwyoṉe ḻeczə beque'e no'olən', na' ḻeczə ca' goquə len ḻe', nach beṉə' bisə'əga'aque' ca' yetap besyə'əque'e no'olən' na' gwsa'ate' na' notono xi'iṉga'aque' gwnitə'əczə. ");
INSERT INTO zavNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Gwdelə ḻeczə got no'olən'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na' catə' yesyə'əban beṉə' guat ca', ¿noe' entr ḻega'aque' gaquə be'en c̱he'? la' yogue'e boso'ošagna'alene' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Na' Jeso'osən' boži'e xtižə'əga'aque'enə' na' gože' ḻega'aque': ―Beṉə' ca' nitə' lao yežlyo nga chosə'əšagne'e na' ḻeczə choso'ošague' na' no xi'iṉga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero na' beṉə' ca' na Diozən' c̱hega'aque' de que zɉəzaque'e par yesyə'əbane' ladɉo beṉə' guat ca' na' par žɉəsyə'əzoe' len ḻe' zeɉḻicaṉe, catə'ən yesyə'əžine' gan' zo Diozən' bito nacbia' šə zɉənaque' beṉə' zɉənšagna' o šə cui, na' caguə no yesyə'əšagna'ach na'anə'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bitoch sa'ate'. Lebze əsa'aque' len angl ca'. Na' zɉənaque' xi'iṉ Dioz c̱hedə' babosban Diozən' ḻega'aque' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Na' ḻeczə de'e Moisezən' bzoɉe' can' goquə ble'ine' to yi' beḻ de'e chdoḻɉən to ḻo'o xis yešə' sin cui bzeyən ḻen. Na' gwne' c̱he X̱ancho Diozən' de que naque' Dioz c̱he de'e x̱axta'ocho Abraanṉə', na' Dioz c̱he de'e x̱axta'ocho Isaaquən' na' Dioz c̱he de'e x̱axta'ocho Jacobən'. De'e na'anə' ṉezecho de que beṉə' guat ca' yesyə'əbane'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Na' ṉezecho beṉə' ca' nite'e len Diozən' c̱hedə' Diozən' bito naque' Dioz c̱he beṉə' guat, sino naque' Dioz c̱he beṉə' zɉəmban. Na' yoguə' beṉə' bagwso'onḻilažə' Diozən' ṉe'e zɉəmbane' par chso'elaogüe'ene'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Na' baḻə beṉə' choso'osed choso'olo'ine' ḻei de'en bzoɉ de'e Moisezən' gwse'e Jeso'osən': ―Maestr, binḻo boži'o xtižə'əga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Na' bitoch besyə'əyaxɉene' ¡bi yesə'əṉabene' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jeso'osən' gože' ḻega'aque': ―¿Bixc̱hen' chəsə'əna beṉə' c̱he Cristən' de que naque' xi'iṉ dia c̱he de'e Rei Dabin'? ");
INSERT INTO zavNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Cuin de'e Dabin' bzoɉe' ḻe'e ḻibr gan' žia Salmos, gwne': X̱ancho Diozən' gože' X̱ana'anə': “Gwche'edo' cuita' nga ṉabi'acho txen. ");
INSERT INTO zavNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Na' gona' par nic̱h ṉitə' de'e ca' chso'on contr le' na' beṉə' contr c̱hio' ca' xni'onə'.” ");
INSERT INTO zavNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Na' de'en gwna de'e Dabin' de que Cristən' naque' X̱ane', ¿əcabi zeɉen de que Cristən' naque' mazəchlə ca xi'iṉ dia c̱he'enə' ža? ");
INSERT INTO zavNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Na' gože' disipl c̱he' ca' len yoguə' beṉə' yeziquə'əchlə boso'ozenag c̱he', gože' ḻega'aque': ");
INSERT INTO zavNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Ḻe'e gon xbab nic̱h cui gonḻe can' chso'on beṉə' ca' choso'osed choso'olo'ine' ḻei de'en bzoɉ de'e Moisezən'. Ḻega'aque' chesyə'əbeine' chəsə'əlaže'e zɉənyaze' lachə' toṉə, na' chesyə'əbeine' catə' beṉə' chəsə'əguape' ḻega'aque' diox na' chəsə'ənope'e na'aga'aque'enə' do lao lquey. Ḻega'aque' chse'enene' yesə'əbi'e gan' chəsə'əbe' beṉə' blao catə' chɉa'aque' yo'odao' na' catə' chac lṉi. ");
INSERT INTO zavNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Na' choso'ox̱oayague' no'olə gozebə ca' par nic̱h no'ol ca' chəsə'ənežɉue' ḻega'aque' ližga'aque' len bichlə de'en de c̱hega'aque'. Na' catə' chso'one' orasyon, chso'echgüe' dižə' parzə nic̱h choso'ox̱oayague' beṉə'. Mazəchlə castigw c̱hega'aque' əgwnežɉo Diozən' clezə ca c̱he beṉə' yeziquə'əchlə c̱hedə' chso'one' de'e mal ca' zɉənac ca' len zɉəṉezene' can' na ḻein'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jeso'osən' bgüie' gan' boso'onežɉo beṉə' ca' mechən' par yo'odao' əblaonə', na' ble'ine' beṉə' gwni'a ca' gosə'əgüe'e xmechga'aque' ḻo'inə'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Na' ḻeczə ble'ine' to no'olə gozebə no'olə yašə' gwlo'e c̱hopə sentab dao' c̱he'enə' ḻo'i gan' gosə'əgüe'e mechən' par yo'oda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nach Jeso'osən' gwne': ―De'e ḻi əchnia' le'e, no'olə gozebən' naque' beṉə' yašə', pero bagwlo'e de'e zaquə'əch lao Diozən' ca yoguə' beṉə' ca' yeḻa'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ḻega'aque' gosə'əgo'o xmechga'aque' de'e checho'onən lao yeḻə' gwni'a c̱hega'aque'enə', pero no'olə nga lao yeḻə' yašə' yeḻə' zi' c̱he'enə' bagwlo'e yoguə' ca ga de'e de c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Na' ca naquə baḻə disipl ca' gwso'e dižə' catec xoche naquə yo'odao' əblaonə' ca naquə gwso'one'en de yeɉ xoche de'e zaque'e na' yo'on bi de'en boso'onežɉo beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Nach gože' ḻega'aque': ―Ca naquə yo'odao' əblaonə' de'en chle'ile nga, gwžin ža yosyo'oc̱hiṉɉ beṉə' doxenən' na' notoch no le'i ḻen. ");
INSERT INTO zavNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Na' gosə'əṉabene' Jeso'osən' gwse'ene': ―Maestr ¿do batə'əquə gaquə de'e nga nao' nga? na' ¿nac gaquə gacbe'ito' catə' bazon baozə gaquə can' na'onə'? ");
INSERT INTO zavNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Na' gože' ḻega'aque': ―Ḻe'e gon xbab nic̱h notono əx̱oayag le'e par nic̱h šeɉle nez yoblə. Beṉə' zan beṉə' gox̱oayag la'aque' yesə'əne': “Nadan' Cristən' na' bazon gaquə juisyən'.” Pero le'e bito əgwzenagle xtižə'əga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na' catə' yene'ele dižə' de que chac gwdiḻə o de que guaquə gwdiḻə, bito žeble, c̱hedə' zgua'atec de'e quinga cheyaḻə' gaquə. Pero na' bitoṉə' žin žan' par šo'o fin c̱he yežlyon'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nach gože' ḻega'aque': ―Ze'e šo'o fin c̱he yežlyon' yediḻə yež contr yež na' ṉasyon contr ṉasyon. ");
INSERT INTO zavNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Na' ḻeczə zan yež de'e zɉəchi' doxenḻə yežlyon' x̱o'ochgua, na' gaquə bgüin, na' cue'e yižgüe'. Na' yesə'əžebchgua beṉac̱hən' catə' yesə'əle'ine' de'en gaquə ḻe'e yoban'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pero ze'e gaquə yoguə' de'e quinga catə' yesə'əzene' le'e, na' yoso'oc̱hi' yoso'osaque'e le'e, na' so'one' le'e lao na' bx̱oz ca' na' yesə'əyix̱ɉwga'aque' le'e ližya. Na' yesə'əc̱he'ex̱ax̱ɉe' le'e do lao rei na' lao goberṉador par sa'ogüe' xya c̱hele c̱hedə' chonḻilažə'əle nada'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Na' lao chac de'e quinga, ḻe'e güe'ech xtiža'anə'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pero na' bito gonḻe xbab nac yoži'ile xtižə'əga'aque'en catə' əžinḻe lao beṉə' gwnabia' ca' gan' sa'ogüe' xya c̱hele. ");
INSERT INTO zavNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nada' goṉa' le'e xbab na' yeḻə' sin' par nic̱h gaquə yoži'ile xtižə'əga'aque'enə' sin cui bi yesə'əne' na' bito gaquə so'one' par se'eɉḻe' beṉə' yoblə de que babenḻe de'e mal. ");
INSERT INTO zavNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Na' tant yesə'əgue'i beṉə' le'e xte x̱axna'ale ca' na' beṉə' bišə'əle na' bišə'əlɉuežɉle na' beṉə' migw c̱hele ca' so'one' le'e lao na' beṉə' contr c̱hele ca' na' əso'ote' baḻle. ");
INSERT INTO zavNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Na' casi yoguə' beṉac̱hən' yesə'əgue'ine' le'e c̱hedə' chonḻilažə'əle nada'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Na' ḻe'e gon xbab de que chapə chye Diozən' le'e. Na' bito güe'e latɉə cuiayi'ile. ");
INSERT INTO zavNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Na' goṉe' yeḻə' mban zeɉḻicaṉe c̱helen' šə sole co'o gwc̱heɉlažə'əle len yoguə'əḻoḻ de'en so'onene' le'e. ");
INSERT INTO zavNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Na' catə' le'ile soḻdad zan zɉənyec̱hɉ zɉəmbi'e Jerosalenṉə', na' əṉezele de que bazon cuiayi'in. ");
INSERT INTO zavNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ṉa'a ža, le'e nitə'əle distrit c̱he Jodean' cheyaḻə' yexoṉɉle catə'ən bachac ca' na' žɉa'acle do ya'ada'ote. Na' le'e nitə'əle lao' syodan' yesa'acdole, na' le'e nitə'əle fuerlə syodan' bito gonḻe xbab yeyo'ole. ");
INSERT INTO zavNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Cana' gwnežɉo Diozən' castigw c̱he beṉə' ca' ža' syodan' por ni c̱he xtoḻə'əga'aque'enə' par nic̱h gaquə can' nyoɉən ḻe'e Xtižə' Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Na' ca tyempən' ḻechguaḻe zdebə gaquə len no'ol ca' zɉənoa' bdao' na' no'ol ca' chəsə'əguažə' bidao'. Ḻechguaḻe c̱hi' saquə' beṉə' ca' ža' doxenḻə Jodean', c̱hedə' Diozən' əža'achgüe' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Soḻdad ca' so'ote' baḻəga'aque' len spad, na' yebaḻe' yesə'əc̱he'ex̱ax̱ɉ soḻdad ca' ṉasyon ca' de'en zɉəchi' doxenḻə yežlyon'. Na' beṉə' ca' cui zɉənaquə beṉə' Izrael yosyo'oc̱hiṉɉe' yo'o ca' de'en ža' Jerosalenṉə' na' yoso'oleɉ yosə'əšošɉe'en. Pero na' babžia Diozən' bia' əžin ža catə' beṉə' ca' cui zɉənaquə beṉə' Izrael bitoch yesə'əṉabi'e ṉasyon Izraelən'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ca naquə bgüiž, bio' na' belɉw ca', gaquə de'e yebanecho len ḻega'aquən. Na' beṉə' ža' yežlyon' sa'aquene' tolə na' sa'acžeɉlaže'e tant sšag gon nisda'onə' de'en gwḻis be'enə' ḻen. ");
INSERT INTO zavNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Na' beṉə' ža' yežlyo nga sa'ate' šlat tant yesə'əžebe' de'en gaquə, c̱hedə' Diozən' əgwsi'iṉse' yoguə' de'e ca' chle'icho ḻe'e yoban'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Na' cana'ach beṉə' ža' yežlyon' yesə'əle'ine' nada' yida' de'e yoblə to ḻo'o beɉw, nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. Yida' len yeḻə' guac xen c̱hia'anə' par nic̱h gwlo'a de que naca' ḻe'ezelaogüe beṉə' blao. ");
INSERT INTO zavNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na' catə' solao gaquə de'e quinga, ḻe'e gondiplažə' na' ḻe'e yebei, c̱hedə' bazon əžin ža catə' yida' de'e yoblə par yosla' le'e lao yoguə' de'e mal. ");
INSERT INTO zavNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Na' Jeso'osən' be'elene' ḻega'aque' to jempl na' gože' ḻega'aque': ―Ḻe'e ggüiašc can' chon yag yix̱güion' o bitə'ətezə yag yoblə. ");
INSERT INTO zavNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Catə' chle'ile bachebia xḻague'e nach ṉezele de que bac̱h zon yela' yeɉon'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Na' ḻeczə ca' catə' le'ile gaquə de'e quinga bagwnia' ze'e gaquən', cana'ach əṉezele de que bazon əgwloe' Diozən' yeḻə' gwnabia' c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","De'e ḻi əchnia' le'e, bitoṉə' gat le'e nitə'əle tyemp nga catə' solao gaquə yoguə'əḻoḻ de'e ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ca naquə de'e ca' chle'icho ḻe'e yoban' na' yežlyon' yesə'əde c̱hei, pero ca naquə xtiža'anə' caguə de'e te cui gaquə can' nanṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Na' ḻe'e gon xbab par nic̱h cui gacle beṉə' lia na' beṉə' güe'e zo na' par nic̱h cui sole yelaḻ yežeɉele. Nc̱hoḻ yic̱hɉla'aždao' beṉə' ca' zɉənaque' beṉə' lia na' beṉə' güe'e zo na' beṉə' ca' chesyə'əlaḻ chesyə'əžeɉe. Bito ṉite'e probnid catə'ən seḻə' Diozən' castigw c̱hega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Na' ḻeczə yoguə' beṉə' yeziquə'əchlə ža' yežlyon' beṉə' cuiṉə' so'onḻilažə' nada' bito ṉite'e probnid. ");
INSERT INTO zavNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pero le'e ža, ḻeso probnid dote tyemp, ḻe'e gon orasyon par nic̱h catə' gaquə de'e quinga Diozən' gaquəlene' le'e par nic̱h cui bi gaquele na' par nic̱h yedəsole len nada', nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Na' yoguə' ža gwzo Jeso'osən' bsed blo'ine' beṉə' ža' ḻo'o yo'odao' əblaonə'. Nach yoguə' že' beyeɉe' lao ya'a de'en nzi' ya'a Olibos. ");
INSERT INTO zavNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Na' yoguə' zil tempran besə'əžin beṉə' zan par boso'ozenague' c̱he' lao bsed blo'ine' ḻega'aque' ḻo'o yo'odao' əblaonə'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na' goquən' bazon baozə lṉi pascon' de'en chaḻə' Jerosalenṉə' catə'ən chsa'ogüe' yetxtil de'en cui bi xne'i nc̱hix̱ə. ");
INSERT INTO zavNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Na' bx̱oz əblao ca' na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' besyə'əyilɉe' naclə so'one' par ədoḻə' Jeso'osən' sin cui no gacbe'i na' əso'ote'ene'. Gwso'one' ca' c̱hedə' besə'əžebe' šə bi so'one beṉə' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nach gwyo'o gwyaz Satanasən' yic̱hɉla'aždao' Jod Iscariotən' ben' naquə cuent len apostol ca' šižiṉ. ");
INSERT INTO zavNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Gwyeɉe' lao bx̱oz əblao ca' na' lao beṉə' ca' zɉənaquə gwnabia' c̱he x̱a'ag yo'odaon' na' bosə'əxi'e naclə so'one' par gone' Jeso'osən' lao na'aga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Na' ḻechguaḻe besyə'əbeine', na' gwso'one' lyebe yosə'ənežɉue'ene' mech. ");
INSERT INTO zavNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Na' Jodən' gwxenḻaže'e len ḻega'aque' na' gwzolao gwche'enaogüe' batə'əquən' so latɉə gone' Jeso'osən' lao na'aga'aquen' catə' cui ža' beṉə' zan len ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na' bžin žan' catə'ən chsa'ogüe' yetxtil de'en cui bi xne'i nc̱hix̱ən. Na' ža na'anə' naquən žan' catə' chso'ote' xilə' dao' par chɉəsyə'əzalaže'e can' bosla Diozən' de'e x̱axta'oga'aque'enə' lao na' beṉə' Egipto ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nach Jeso'osən' gwleɉe' Bedən' len Juanṉə' na' gože' ḻega'aque': ―Ḻe'e žɉa'ac na' ḻe'e žɉe'esi'ini'a de'en gaocho lao lṉi pascon'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nach gwse'ene': ―¿Gan' che'endo' žɉe'eni'aton'? ");
INSERT INTO zavNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nach gože' ḻega'aque': ―Catə' bagwyo'ole syodan' na' yežagle to beṉə' byo ben' noa' che'e nis ya'a yene'. Ḻe'e žɉənaotelene' na' šo'ole len ḻe' ḻo'o yo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Na' ye'ele x̱an yo'onə': “Maestrən' ne' goṉšgo' to cuart gan' güe'eni'ato' de'en gaolento'one' xše' lṉi pascon' neto' disipl c̱he'.” ");
INSERT INTO zavNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nach əgwlo'ine' le'e to cuart xen de'en zo žcuia la'aḻə, na' ḻo'o cuartən' zo to mes na' bichlə de'e chyažɉecho. Ḻo'o cuart na'anə' əgwsi'ini'ale de'en gaocho lao lṉi pascon'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nach gwsa'aque', na' yoguə'əḻoḻ cayaṉə'ənə' gože' ḻega'aque'enə' goquə. Nach bosə'əsi'ini'e de'en gwsa'ogüe' lṉi pascon'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Na' catə' bžin or, gwchi'e cho'a mesən' len disipl c̱he' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nach gože' ḻega'aque': ―Ḻechguaḻe gwzelaža'a gaogua' yeḻə' guao c̱he lṉi pascon' nga len le'e antslə ze'e c̱hi' saca'a par gata'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Chnia' le'e, zelao ṉa'a gaogua'an. Xte catə'əch babloe' Diozən' yeḻə' gwnabia' c̱he'enə', cana'ach gaogua'an de'e yoblə. ");
INSERT INTO zavNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Na' gwxi'e basən', be'e yeḻə' chox̱cwlen c̱he Diozən' nach gwne': ―Ḻe'e si'in na' ḻe'e ye'eɉ yoguə'əle latə' güeɉə de'en yožə ḻo'o bas nga. ");
INSERT INTO zavNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Chnia' le'e zelao ṉa'a che'eɉa' bino c̱he oban' nga. Xte catə'əch babloe' Diozən' yeḻə' gwnabia' c̱he'enə', cana'ach ye'eɉa'an de'e yoblə. ");
INSERT INTO zavNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nach gwxi'e yetxtilən' na' be'e yeḻə' chox̱cwlen c̱he Diozən' na' bzoxɉe'en na' bnežɉue'en ḻega'aque'. Na' gože' ḻega'aque': ―De'e ngan' cuerp c̱hia' de'en chsanḻaža'a por ni c̱he le'e. Quinga gonḻe par žɉəyezalažə'əle bi zeɉen par le'e ca de'en so'ote' nada'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Na' ḻeczə bex̱e'e basən' catə' babeyož gwsa'ogüe' xšen' na' gože' ḻega'aque': ―De'en yožə ḻo'o bas nga zeɉen de'e cobə de'en non Diozən' lyebe gone' par gaquəlene' le'e. Na' solao gone' can' none' lyeben' c̱hedə' so'ote' nada' na' lalɉə xc̱hena'anə' por ni c̱hele. ");
INSERT INTO zavNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Na' de'e ḻi ben' gone' nada' lao na' beṉə' ca' so'ot nada' chaolene' nada' txen nga. ");
INSERT INTO zavNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Banaquəczən c̱hia' gata', nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h, pero ¡probchguazə be'enə' gon nada' lao na' beṉə' ca'! ");
INSERT INTO zavNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nach disipl ca' gosə'əzolaogüe' gosə'əṉabene' lɉuežɉga'aque' noe' entr ḻega'aquen' gon de'e malən' nac ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Na' ḻeczə gosə'əzolaogüe' gwsa'acyože' entr ḻega'acze' noen' naquəch beṉə' blao. ");
INSERT INTO zavNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Na' Jeso'osən' gože' ḻega'aque': ―Nitə' rei c̱he to to ṉasyon ca' na' chəsə'ənabi'e beṉə' nitə' xni'aga'aque'. Na' beṉə' gwnabia' ca' chse'enene' əsoe' beṉə' dižə' c̱hega'aque' de que zɉənaque' beṉə' güenchgua. ");
INSERT INTO zavNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero caguə can'. Šə no le'e nacle beṉə' blaoch, bito cheyaḻə' yene'ele əso'elao' beṉə' le'e. Na' šə no le'e nacle beṉə' chgüia chye beṉə' chso'elao' Diozən', cheyaḻə' sole par gaquəlen lɉuežɉle. ");
INSERT INTO zavNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ḻe'e gon xbab non' naquəch beṉə' blao, ¿əbe'enə' chi' cho'a mesən', o šə xmose' ben' chon mendadən'? Clarczən' naquən de que ben' chi' cho'a mesən' naquəche' blao. Ca naquə nada' zoa' par gaquəlena' le'e ḻa'aṉə'əczə naca' X̱anḻe. ");
INSERT INTO zavNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Le'e bito chbeɉyic̱hɉle nada' lao yoguə'əḻoḻ de'en chyi' chzaca'a. ");
INSERT INTO zavNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Na' ca naquə X̱a'anə' bano'e c̱hia' par nic̱h ṉabi'a, ḻeczə nada' bano'a c̱hele par nic̱h ṉabi'ale. ");
INSERT INTO zavNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Na' gona' par nic̱h ye'eɉ gaole txen len nada' catə' yežinḻe gan' ṉabia'a. Na' ḻeczə gona' par nic̱h le'e əggüia əgwyele famiḻy ca' šižiṉ, beṉə' ca' zɉənaquə xi'iṉ dia c̱he de'e Izraelən'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nach Jeso'osən' gože' Simon Bedən': ―Ben xbab c̱hio', bagwṉab Satanasən' gaco' lao ne'in par nic̱h gonən le' prueb šə güeɉyic̱hɉo' cuich gonḻilažo'o nada'. Na' de'en gonən len le' gwxaquə'əleben ca de'en chon to beṉə' catə' chdie' trigon' rner par chega'aṉ de'e güen. ");
INSERT INTO zavNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero na' nada' babena' orasyon par le' par nic̱h ca' bito cueɉyic̱hɉo' can' chonḻilažo'o nada'. Na' catə' babediṉɉdo' xtoḻo'onə', btiplažə' beṉə' bišo'o quinga. ");
INSERT INTO zavNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nach Bedən' gože'ene': ―X̱ana', bagwc̱hoglaža'a sa'alena' le' caguə ližya na'azə sino xte gatlencza' le'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Na' Jeso'osən' gože'ene': ―Bed, əchnia' le' bito cuež ḻecon' ṉeže' antslə ze'e gaquə šoṉ las cui chc̱hebo' de que nombi'o nada'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Na' gože' disipl c̱he' ca': ―¿Ede de'e byažɉele catə' bseḻa'a le'e ɉətix̱ɉue'ile xtiža'anə'? Bseḻa'a le'e sin cui bi'ale mech na' nic bsod, na' nic bi'ale xelle. Nach gwse'ene': ―Bitobi byažɉəto'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Na' gože' ḻega'aque': ―Pero ṉa'a ža šə naple mech cheyaḻə' gua'alen, na' ḻeczə ca' gua'ale bsod. Na' šə bito bi spad c̱helenə' de, ḻe'e gotə' xadoṉ c̱helen' par si'ilen. ");
INSERT INTO zavNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Echnia' le'e gonḻe ca' c̱hedə' gaquə c̱hia' can' nyoɉczən ḻe'e Xtižə' Diozən', nan: “So'onene' ḻe' can' chso'one' len beṉə' chon de'e mal.” Na' bacheyož chac yoguə'əḻoḻ de'en nyoɉən c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Na' gwse'ene': ―X̱anto', bgüiašc nga no'ato' c̱hopə spad. Nach gože' ḻega'aque': ―Guaquəczən. ");
INSERT INTO zavNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nach bechoɉe' yo'onə' na' ca naquə costombr c̱he' beyeɉe' ya'a de'en nzi' Olibos nach disipl c̱he' ca' ɉəsə'ənaogüe'ene'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Na' catə' besyə'əžine' latɉən' gože' ḻega'aque': ―Ḻe'e gon orasyonṉə' nic̱h cui co'o gwxiye'enə' le'e nez mal. ");
INSERT INTO zavNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Na' gwle'e ḻega'aque' zitə' ca gan' zelao əžin to yeɉ de'e gwzaḻə' to beṉə', na' bzo xibe' na' bene' orasyonṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Gwne': ―X̱a, benšga par nic̱h cui c̱hi' saca'a šə can' chazlažo'o, pero bito che'enda' de'e nia' nada' gaquə, sino gaquə can' əṉao le'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Na' to angl beṉə' za' yoban' blo'elaogüe' ḻe' na' be'e ḻe' fuers balor. ");
INSERT INTO zavNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Na' žlac ḻechguaḻe chžaglaogüe' len yic̱hɉla'aždaogüe'enə' gwzolao chžaglaoche' chone' orasyonṉə' xte beyacḻoḻɉe' na' nis yes c̱he'enə' beyaquən ca tlabə güeɉə chen de'en naquə c̱heḻsoṉ besə'əyiṉɉten lao yon'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Na' bezeche' na' catə' bežine' gan' nitə' disipl c̱he ca' ɉəyedi'e ḻega'aque' chəsə'ətase' tant nite'e trist. ");
INSERT INTO zavNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Na' gože' ḻega'aque': ―¿Bixc̱hen' chtasle? Ḻe'e c̱has, ḻe'e gon orasyon nic̱h cui co'o gwxiye'en le'e nez mal. ");
INSERT INTO zavNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Na' ca ṉecho'ete Jeso'osən' dižə'ənə' catə' bžin ben' le Jod, ben' naquə cuent lao disipl ca' šižiṉ, na' nc̱he'e beṉə' zan. Na' bgüigue'e gan' zo Jeso'osən' na' gwdaogüe'ene' bx̱idən', pero caguə do laže'en bene' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nach gož Jeso'osən' ḻe': ―Jod, ¿əlen to bx̱id gono' nada' lao na' beṉə' quinga, nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Na' catə' besə'əle'i disipl c̱he Jeso'osən' can' gaquə c̱he'enə' gwse'ene': ―X̱anto', ¿əgwyinto' beṉə' quinga spad c̱heto'onə'? ");
INSERT INTO zavNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na' toe' gwdinen' mos c̱he beṉə' gwnabia' c̱he bx̱oz ca', na' gwc̱hogtechgüe' nague' ḻichan'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero Jeso'osən' gože'ene': ―Lɉoye'enə'. Nach gwdane' nag mosən' na' beyone' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jeso'osən' gože' bx̱oz əblao ca' na' beṉə' gwnabia' c̱he x̱a'ag yo'odaonə', na' beṉə' golə beṉə' blao ca', beṉə' ca' zɉa'ac zɉəsə'əxene'ene', gože' ḻega'aque': ―¿Eca to beṉə' bguanṉə' chsaquə'əlebele nda' za'acle len spad len yag zedex̱enḻe nada'? ");
INSERT INTO zavNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yoguə' ža gwchi'a len le'e ḻo'o yo'odao' əblaonə' na' bito gwxenḻe nada'. Pero ṉa'a babžin or par gonele nada' con can' chene'ele, na' babžin or gaquə can' chene'e gwxiye'enə' de'en chnabia' beṉə' ca' chsa'aš ḻo'o de'e žc̱hoḻən'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nach gosə'əzene' Jeso'osən' na' gosə'əc̱he'ene' liž ben' naquəch bx̱oz əblao c̱he ṉasyon Izraelən'. Nach Bedən' zɉənaogüe' Jeso'osən' zitə' zitə'ələ. ");
INSERT INTO zavNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Na' boso'oxene' yi' chyo'o c̱he bx̱oz əblaonə' na' gosə'əbi'e cho'a yi'inə', na' gwche' Bedən' len ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Na' to no'olə criad ble'ine' ḻe' chi'e cho'a yi'inə', na' bgüie' ḻe' na' gwne': ―Ḻeczə len benga naque' txen len Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero Bedən' bito gwc̱hebe' šə nombi'e Jeso'osən', na' gwne': ―No'olə, bito nombi'ane'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Na' chacczə šlož yeto beṉə' ble'ine' Bedən' na' gože'ene': ―Lenczon' naco' txen beṉə' ca'. Nach Bedən' gože'ene': ―Beṉə', bito lena' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Gwde to or yetoe' gwne': ―De'e ḻiczə naquə benga txen len Jeso'osən', c̱hedə' naque' beṉə' Galilea. ");
INSERT INTO zavNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Na' Bedən' gože'ene': ―Beṉə', bito ṉezda' bi dižə'ən cho'o. Na' lao ṉecho'ete Bedən' dižə'ən ca' ḻe'e gwchežte to ḻecw. ");
INSERT INTO zavNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Na' X̱anchon' gwyec̱hɉe' bgüie' Bedən', na' ɉəsa'alažə' Bedən' dižə' de'en gož X̱anchon' ḻe' catə'ən gwne': “Bito cuež ḻecon' ṉeže' antslə ze'e gaquə šoṉ las cui c̱hebo' de que nombi'o nada'.” ");
INSERT INTO zavNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Na' Bedən' bechoɉe' gan' ža' beṉə' ca' na' gwchežyašə'əchgüe'. Na' de'e juisy de'e goquene'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Na' x̱a'ag yo'odao' ca' beṉə' ca' gwso'ox̱ə' Jeso'osən' gwso'onene' borl na' gwso'ot gosə'əyine' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Na' boso'oc̱heɉe' to lachə' lao Jeso'osən' na' gosə'əyine' ḻe'. Na' gwse'ene': ―Gwṉeya'ašc ¿non' chyin le'? ");
INSERT INTO zavNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na' gwyanch dižə' de'en gosə'əṉe' contr ḻe' gosə'əzi'ic̱hiže'ene'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Na' catə' gwye'eni'inə' beṉə' golə beṉə' blao c̱he ṉasyon Izraelən' na' bx̱oz əblao ca' na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' besyə'əžague' na' gwso'one' mendad par gwyeɉ Jeso'osən' laoga'aque'enə' gan' chəsə'ənabi'enə'. Nach gwse'ene': ―Gwnašc neto' šə len' naco' ben' gwleɉ Diozən' par gaquəleno' ṉasyon c̱hechon'. Nach gože' ḻega'aque': ");
INSERT INTO zavNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Žalə' ṉia' de que naca' Cristən' ben' gwleɉ Diozən' par gaquəlena' ṉasyon c̱hechon' bito šeɉḻe'ele c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Na' žalə' bi ṉabda' le'e nic yoži'ile xtiža'anə'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nadan' naca' ben' bseḻə' Diozən' golɉa' beṉac̱h, na' dezd ṉa'a cui'a cuit Diozən' par nic̱h ṉabi'a txen len ḻe', Dioz ben' chnabia' doxenḻə. ");
INSERT INTO zavNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nach yogue'e gwse'ene': ―¿Elen' naco' Xi'iṉ Diozən'? Na' gože' ḻega'aque': ―Ḻe can' nale nan' naca'. ");
INSERT INTO zavNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nach gosə'əne': ―¿Nochxa testigw chyažɉecho? Chio'on babenecho ṉa'a chžia chnite'e Diozən' de'en ne' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Na' yoguə'əḻol beṉə' zan ca' gosə'əzeche' nach gosə'əc̱he'ene' lao Pilatən'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Na' gwzolao bosə'əcuiše' Jeso'osən' gosə'əne': ―Bagwc̱hoglaoto' c̱he benga de que cheyaḻə' gate' ca de'en chta chṉe' ṉasyon Izraelən'. Na' ḻeczə chžone' c̱hixɉwto' impuest de'en chṉab Rei Sesarən'. Nach ḻeczə ne' de que ḻe' naque' Cristən' ben' gwleɉ Diozən' par gaquəlene' ṉasyon c̱heto'onə' na' naque' to rei. ");
INSERT INTO zavNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nach Pilatən' gože'ene': ―¿Elen' naco' rei c̱he beṉə' Izrael ca'? Nach Jeso'osən' gože'ene': ―Ḻe can' nao' nan' naca'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nach Pilatən' gože' bx̱oz ca' na' beṉə' zan ca' nžag laogüe'enə': ―Bitobi chla'alaon šə bi doḻə' napə benga. ");
INSERT INTO zavNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero na' gosə'əṉeche' gosə'əne': ―Chta chṉe' yoguə'əḻoḻ beṉə' ža' Jodea nga len de'en chsed chlo'ine'. Gwzolao bsed blo'ine' Galilean' pero lenczə nga bachsed chlo'ine' ṉa'a. ");
INSERT INTO zavNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Catə' bene Pilatən' can' gosə'əne', gwṉabe' šə Jeso'osən' naque' beṉə' Galilea. ");
INSERT INTO zavNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Na' catə' gocbe'ine' de que Jeso'osən' ze'e Galilean' gan' chnabia' goberṉador Erodən', na' bseḻe'ene' lao Erodən', la' ca or na' zo Erodən' Jerosalenṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Catə' Erodən' ble'ine' ḻe' bebeine' c̱hedə' bagoc sša chene'ene' le'ine'ene'. Babenene' xtižə' Jeso'osən' na' gwzoe' lez le'ine' to de'e zaquə' yebanene'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nach de'e zan gwṉabene' Jeso'osən', pero ni to dižə' c̱he'enə' cui boži'i Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bx̱oz əblao ca' na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' gosə'əzeche' gaḻə'əzə na' bosə'əcuiše'ene' len zan dižə'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Na' Erodən' len soḻdad c̱he' ca' gwzolao gosə'əzi'ic̱hiže'ene' na' gwso'onene' borl. Nach catə' beyož bosə'əguacue'ene' to lachə' xoche juisy, bosə'əseḻe'ene' lao Pilatən'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na' dezd ža na' gwsa'ac Erodən' len Pilatən' migw, c̱hedə' antslə besə'əgue'i lɉuežɉga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nach Pilatən' betobe' bx̱oz əblao ca' na' beṉə' gwnabia' ca' nach len beṉə' ža' gan' chso'one' yeḻə' jostisən'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Na' gože' ḻega'aque': ―Le'e bedəgua'ale benga laogua' nga, na' gwnale c̱he' de que chta chṉe' beṉə' Izraelən'. Nada' bac̱h gwṉabyožəda'ane' laole nga, na' ca xyan' de'en chaole c̱he', ni to de'e xiṉɉ cui chželda' šə bin' none'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Na' ḻeczə ca' Erodən' bitobi xtoḻe'e bželene', na' bosseḻe'ene' laoto' nga. Na' naquən clar bitobi ben benga de'e cheyaḻə' gate'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Na' ṉa'a con gona' mendad yesə'əyine'ene' na' əgwsana'ane'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Gwne' ca' c̱hedə' gotə' to costombr c̱hega'aque' de que əgwsane' to beṉə' pres lao yoguə' lṉi pascon'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Na' yoguə' beṉə' ca' ža' na' gwso'osye'e, tozə ca gosə'əne': ―¡Echoɉtega benga gate', na' əgwsano' Barrabasən'! ");
INSERT INTO zavNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Na' ca naquə Barrabasən' gosə'əyix̱ɉue'ene' ližya c̱hedə' ḻe' bx̱ie' gwdiḻə lao syodan' na' goque' to beṉə' güet beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Na' Pilatən' de'e yoblə gwṉabene' ḻega'aque' šə əgwsane' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero gwso'osye'e gosə'əne': ―¡Bde'e ḻe'e yag corozən'! ¡Bde'e ḻe'e yag corozən'! ");
INSERT INTO zavNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Na' de'e əgwyoṉ lase gož Pilatən' ḻega'aque': ―¿Bi de'e mal bene'enə'? Ni to de'e xiṉɉ cui cheželda' šə bin' none'. Na' con gona' mendad yesə'əyine'ene' nach əgwsana'ane'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero con gwso'osye'e yelatə' zižɉoch gosə'əṉabe' par əgwde'ene' ḻe'e yag corozən'. Na' Pilatən' gwzolaogüe' bzenague' c̱hega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Na' gwc̱hoglaogüe'en de que gaquə can' gosə'əṉabene' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Na' bsane' Barrabasən' ben' zɉənyix̱ɉue' ližyan' ben' gosə'əṉabe' əgwsane' ḻa'aṉə'əczə Barrabasən' goque' ben' bx̱e gwdiḻən' na' beṉə' güet beṉə'. Na' Pilatən' bene' Jeso'osən' lao na'aga'aque'enə' par so'one' len ḻe' can' chse'enene'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Na' lao zɉənc̱he'ene' fuerlə syodan' besyə'əžague' to beṉə' Sirene le' Simon, ze'e zeze'e fuerlə syodan'. Ḻa fuers bosə'əde'e yag coroz c̱he Jeso'osən' cože'enə' na' gwnaogüe' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Na' beṉə' zan zɉəsə'ənao ḻe' na' zɉəlen zan no'olə. Na' no'ol ca' gwzolao gwso'osye'e gosə'əbeže' c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pero na' Jeso'osən' gwyec̱hɉe' na' gože' ḻega'aque': ―No'olə lao' syoda Jerosalen, bito cuežle c̱hia', yeɉni'a ḻecuež c̱hele na' c̱he xi'iṉle. ");
INSERT INTO zavNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Na' de'e ḻi gwžin ža catə' yesə'əne': “Mbalaz nitə' no'olə güiž no'olə cui no gwxan na' cui no bi'i c̱he' zo par əgguaže'e.” ");
INSERT INTO zavNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ca na' yesə'əṉablaže'e yesə'əbix̱ə ya'a ca' par c̱henən ḻega'aque', yesə'əṉablaže'e əca'a bdiṉɉ gotən ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Šə so'ot beṉə' nada' len cui bi xtoḻa'a de, ¡naquəchxe so'one' len le'e nacle beṉə' güen de'e malən'! ");
INSERT INTO zavNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Na' ḻeczə gosə'əc̱he'e c̱hopə beṉə' güen de'e malən' par boso'ode'e ḻega'aque' ḻe'e yag corozən' can' gwso'one' len Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Na' catə' besə'əžine' latɉə ganə' nzi' “Yic̱hɉ Beṉə' Guat”, boso'ode'e Jeso'osən' ḻe'e yag corozən', na' ḻeczə boso'ode'e beṉə' mal ca' c̱hopə ḻe'e yag corozən' len ḻe'. Toe' gwda' cuit Jeso'osən' ḻicha na' yetoe' cuite' yeglə. ");
INSERT INTO zavNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Na' Jeso'osən' gwne': ―X̱a, bezi'ixen c̱he yoguə' beṉə' quinga chəsə'əgue'i nada', la' caguə zɉəṉezene' bin' chso'one'enə'. Na' gwso'one' xala'ane'enə' rif par bosyo'oḻe'en. ");
INSERT INTO zavNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Na' beṉə' zan gosə'əzeche' na' besyə'əyate'ene'. Na' beṉə' gwnabia' c̱hega'aque' ca' gwso'onene' borl, chəsə'əne': ―Yeziquə'əchlə beṉə' bosle'. Šə de'e ḻi naque' Cristən' ben' gwleɉ Diozən' par gaquəlene' ṉasyon c̱hechon', ¿bixc̱hen' cui chosla cuine'? ");
INSERT INTO zavNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nach soḻdad ca' ḻeczə gwso'onene' borl gosə'əbigue'e gaḻə'əzə gan' zo yag corozən' na' boso'onežɉue'ene' binagr. ");
INSERT INTO zavNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nach gwse'ene': ―Šə len' naco' Rei c̱he beṉə' Izraelən', bosla cuino'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na' yic̱hɉ yag coroz c̱he'enə' gwzo to de'en nyoɉən ca de'en bcuiš ḻe', na' nan: “Bengan' Rei c̱he beṉə' Izrael ca'.” Na' byoɉən dižə' griego, dižə' latin na' dižə' ebreo. ");
INSERT INTO zavNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","To beṉə' mal ben' da' ḻe'e yag corozən' cuit Jeso'osən' ḻeczə gwzi'ic̱hiže'ene', gože'ene': ―Šə len' naco' ben' gwleɉ Diozən' par gaquəleno' ṉasyon c̱hechon', bosla cuino' na' ḻeczə bosla neto'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero na' ben' yeto gwdiḻe' ḻe' gože'ene': ―¿Ebito chžebo' Diozən'? len badacho ḻe'e yag corozən' par gatcho. ");
INSERT INTO zavNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Na' de'en gatcho naquən ḻicha, c̱hedə' ṉa'a chzi'icho castigw c̱he xtoḻə'əchon' laogüe naccho beṉə' güen de'e malən'. Pero benga bitobi doḻə' nape'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nach gože' Jeso'osən': ―Jeso'os, žɉəsa'alažə'əšgo' nada' catə' əžin ža ṉabi'o. ");
INSERT INTO zavNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Na' gož Jeso'osən' ḻe': ―De'e ḻi əchnia' le', ṉeža soczo' len nada' gan' zo Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Na' catə' bžin do gobiž goc žc̱hoḻ doxen lao yežlyon' xte do cheda šoṉə. ");
INSERT INTO zavNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Bito bse'eni' bgüižən'. Na' ca naquə lachə'ən de'en ze ḻo'o yo'odao' əblaonə' gwchezə gwchoḻen xte goquən c̱hoplə. ");
INSERT INTO zavNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nach Jeso'osən' bisye'e gwne': ―X̱a, chon cuina' lao na'o. Bezi' spirit c̱hi'anə'. Na' beyož gwne' ca' gote'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Na' catə' ble'i capitan c̱he soḻdad ca' de'e quinga, be'elaogüe'e Diozən' na' gwne': ―De'e ḻiczə benga naque' beṉə' zda ḻicha. ");
INSERT INTO zavNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Na' beṉə' zan besə'əžag par besə'əle'ine' can' chac. Na' yoguə'əḻoḻe' catə' babesə'əle'ine'en ɉəya'aque' gosə'əbažə' lc̱ho'oga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Na' yoguə' beṉə' ca' gwso'ombia' Jeso'osən' na' zɉəlen no'olə ca' ɉəsə'ənao ḻe' catə'ən beze'e Galilean' gosə'əzeche' zitə'ələ besə'əle'ine' de'e ca' goquən'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Na' zo to beṉə' lao' syoda Arimatea gan' mbane Jodean' na' le' Jwse. Naque' txen len beṉə' ca' chesə'ənabia' lao beṉə' Izrael ca'. Jwsen' naque' to beṉə' güen, beṉə' zda ḻicha. ");
INSERT INTO zavNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Gwzoe' lez əžin ža seḻə' Diozən' beṉə' ṉabi'e ṉasyon Izraelən'. Bito bene' txen len beṉə' ca' catə'ən gosə'əc̱hoglaogüe'en so'ote' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Be'ena' gwyeɉe' lao Pilatən' na' gwṉabe' cuerp c̱he Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Na' beletɉe'ene' ḻe'e yag corozən' na' blaže'ene' to lachə' na' gwlo'ene' to ḻo'o bloɉ ba. Na' naquən to ba cobə ga cuiczə no no ṉe'e šo'o. ");
INSERT INTO zavNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Na' goc de'e quinga žan' catə'ən chso'eni'e c̱he lṉi pascon', na' babžin or par so'omba'aṉe' ža dezcanzən'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Na' no'ol ca' za'ac len Jeso'osən' Galilean' ɉəsə'ənaogüe' Jwsen' par besə'əle'ine' ba c̱he Jeso'osən' na' can' gwxoa cuerp c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nach besa'aque' na' ɉəsyə'əyenšaogüe'e to de'en chḻa' zix̱ de'en none' len mirra na' aloes. Na' ža dezcanzən' gwso'one' dezcanz segon can' na ḻein'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Na' baḻ dmigw no'olə ca' ɉa'aque' cho'a bloɉ ban' de'e yoblə na' gwso'ox̱e'e de'e ca' bagwso'onšaogüe'e de'e chḻa' zix̱. ");
INSERT INTO zavNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Na' catə' besə'əžine'enə' besə'əle'ine' bitoch bi yeɉən' da' cho'a ban'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Na' gwso'e ḻo'o bloɉən' na' bito besyə'əželene' cuerp c̱he X̱ancho Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Lao chsa'aquene' tolə c̱he de'e quinga, besə'əle'ine' c̱hopə beṉə' zɉəzecha cuitga'aque'enə' na' zɉənyaze' lachə' de'e chactitchgua. ");
INSERT INTO zavNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","6","Na' no'ol ca' besə'əžebe' na' besə'əc̱hequə' yic̱hɉga'aque'enə' besə'əgüie' lao yolə. Nach gwse' beṉə' ca' no'ol ca': ―¿Bixc̱hen' cheyilɉle Jeso'osən' nga gan' bgaše'e? Notoch no nḻa' nga. Babebane' ladɉo beṉə' guat ca' na' mbancze'. Ḻežɉsa'alažə' can' gwne' catə' ṉezole Galilean'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Gwne' de que ḻe' naque' ben' bseḻə' Diozən' golɉe' beṉac̱h na' cheyaḻə' gaque' lao na' beṉə' mal ca' na' so'ote' ḻe' yoso'ode'ene' ḻe'e yag corozən', na' yeyoṉ ža yebane' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Na' no'ol ca' ɉəsye'ezalaže'e de que gwne' ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Na' besyə'əsa'aque' cho'a ban' na' ɉəsyə'ədix̱ɉue'ine' apostol ca' šneɉ na' len yeziquə'əchlə beṉə' ca' nitə' txen len ḻega'aque' yoguə' de'e ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Na' beṉə' ca' ɉəsyə'ədix̱ɉue'ine' apostol ca' zɉənaque' beṉə' quinga: Maria beṉə' Magdala, na' Xguan, na' Maria xna' Jacob, na' len yebaḻə no'olə. ");
INSERT INTO zavNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Na' apostol ca' bito gwse'eɉḻe'e c̱he no'ol ca', gwsa'aquene' con chesə'ənaze'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero na' Bedən' ḻe'e gwzechadote' na' gwsa'adoe' bžine' cho'a ban' na' bcheque'e na' ble'ine' lachə' ca' zɉəchi'in lao yon', na' beze'e bebanchgüeine' c̱he de'e ca' ble'ine'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Na' ḻeczə ža dmigw na'anə' c̱hopə disiplən' ɉa'aque' yež de'e nzi' Emaus, do šneɉ kilometros zitə' par Jerosalenṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Na' boso'ošile' entr ḻega'aque' c̱he yoguə' de'e ca' bagoquən'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Na' ṉechso'one' xbab na' ṉechso'ete' dižə' c̱he de'e ca' catə' Jeso'osən' bgüigue'e len ḻega'aque' na' gwza'alene' ḻega'aque' txen. ");
INSERT INTO zavNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero bito gwsa'acbe'ine' noxan' zdalen ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nach gože' ḻega'aque': ―¿Bi dižə'ən cho'ele entr le'e lao ngo'ole nezən'? ¿Bixc̱hen' za'acchguale trist? ");
INSERT INTO zavNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Na' toe' ben' le' Cleofas boži'e xtiže'en gože'ene': ―¿Nacxa chactguan' bagwza'o Jerosalenṉə' na' cuiṉə' gacbe'ido' de'e ca' ze'e goc lao syodan'? ¿Ede'en naco' beṉə' zitə' ža? ");
INSERT INTO zavNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Na' gože' ḻega'aque': ―¿Bi goquən' nale ca'? Nach gwse'ene': ―De'en goc c̱he Jeso'os beṉə' Nasaret. Goque' profet, na' Diozən' len beṉac̱hən' besyə'əbeine' ḻe' can' blo'e yeḻə' guac c̱he'enə' na' can' be'e dižə'ənə'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pero na' bx̱oz əblao c̱heto' ca' len beṉə' gwnabia' c̱heto' ca' gwso'one'ene' lao na' beṉə' ca' na' gosə'əc̱hoglaogüe'en c̱he' de que cheyaḻə' gate', na' boso'ode'ene' ḻe'e yag corozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Bachac šoṉə ža ṉa'a goc de'e quinga. Na' len neto' gwzoto' lez de que Dioz nan' bseḻe'ene' par yebeɉe' ṉasyon c̱heto'onə' xni'a beṉə' zitə'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Na' no'ol ca' zɉənaquə txen len neto' baḻe' gwso'e dižə' de'en chebaneto'. Ɉa'aque' cho'a ban' be'i, ");
INSERT INTO zavNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","na' bito besyə'əželene' cuerp c̱he'enə'. Catə' besyə'əla'aque' gosə'əne' de que besə'əle'idaogüe'ene' angl ca' beṉə' gwse'e ḻega'aque' de que babebane' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Na' ḻeczə to c̱hopə beṉə' byo beṉə' ca' zɉənaquə txen len neto' ɉa'aque' cho'a ban' na' besə'əle'ine' cayaṉə'ən gosə'əna no'ol ca' naquə, pero bito besə'əle'ine' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Na' gož Jeso'osən' ḻega'aque': ―¡Prob le'e! Cui cheɉni'ile na' cui cheɉḻe'ele yoguə' de'en boso'ozoɉ profet ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Benən byen Crist ben' gwleɉ Diozən' par gaquəlene' beṉac̱hən' gwxaquə'əzi'e yoguə' de'e quinga bagoc, pero na' de'e yoblə yezi'e yeḻə' chnabia' c̱he'enə' len yeḻə' bala'aṉ c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Na' be'e dižə' len ḻega'aque' gwzolaoteque' len de'en bzoɉ de'e Moisezən' na' len de'en boso'ozoɉ profet ca' yeḻa', nach bsed blo'ine' ḻega'aque' yoguə' de'en nyoɉ c̱he'enə' ḻe'e Xtižə' Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Na' besə'əžine' gaḻə'əzə yežən' gan' zɉa'aque'. Na' Jeso'osən' bene' ca šeɉəche' delant. ");
INSERT INTO zavNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero beṉə' ca' gwso'one' byen yega'aṉe' len ḻega'aque', gwse'ene': ―Yega'aṉczo' len neto' c̱hedə' bachex̱ɉw že'enə' na' bagwde or par šeɉəcho'. Na' gwyo'e par yega'aṉlene' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Na' lao zɉəchi'e cho'a mesən' txen, Jeso'osən' gwxi'e yetxtilən' na' be'e yeḻə' chox̱cwlen c̱he Diozən', na' bzoxɉe'en na' bnežɉue'en ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Cana'ach besyə'əyacbe'ine' de que ḻe'enə', na' lao ṉe'e nite'e ca' benitlaogüe'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nach gwse'e lɉuežɉga'aque': ―Ḻechguaḻe bebei la'ažda'ochon' catə' be'elene' chio'o dižə' tnezən' na' cuaseḻoḻ bsed blo'ine' chio'o can' nyoɉən c̱he' ḻe'e Xtižə' Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Na' lao or na'atezə ḻe'e besyə'əsa'acte' ɉəya'aque' Jerosalenṉə', na' besyə'əžine' gan' zɉəndopə zɉənžag apostol ca' šneɉ len beṉə' ca' yeḻa'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Na' beṉə' šneɉ ca' gwse'e beṉə' ca' ze'e besyə'əžin: ―De'e ḻiczə babeban X̱anchon'. Bablo'elaogüe' Simonṉə'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nach beṉə' ca' c̱hopə gwse'e ḻega'aque' de'en goquə lao zɉəngüe'e nezən', na' gwse'e ḻega'aque' de que besyə'əyacbe'ine' de que ḻe'enə' lao bzoxɉe' yetxtilən' par sa'ogüe'en. ");
INSERT INTO zavNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Na' ca ṉe'e chso'ete' dižə' catə'əczla gwzecha Jeso'osən' gwchoḻga'aque'enə' nach gože' ḻega'aque': ―Ḻeso binḻo len xbab de'en yo'o ḻo'o yic̱hɉla'ažda'olen'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pero na' ḻechguaḻe besə'əžebe' na' besyə'əbanene' c̱hedə' gwsa'aquene' de que chesə'əle'ida'ogüe'ene' de'e beṉə' guat na'anə'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nach Jeso'osən' gože' ḻega'aque': ―¿Bixc̱hen' chaquele tolə? na' ¿bixc̱hen' chonḻe xbabən' ca' ḻo'o yic̱hɉla'ažda'olen'? ");
INSERT INTO zavNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ḻe'e ggüiašc ṉi'a na'a quinga par nic̱h əṉezele de que nada'anə'. Ḻe'e can nada' par nic̱h əṉezele. Žalə' naca' beṉə' guat bito naquə žit belə' c̱hia' ca de'e nga chle'ile nga. ");
INSERT INTO zavNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nach lao gwne' ca', blo'ine' ḻega'aque' ṉi'a ne'e ca'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Na' ca naquə bitoṉə' se'eɉḻe'e tant chesyə'əbanene' na' tant chesyə'əbeine', Jeso'osən' gože' ḻega'aque': ―¿Ede latə' de'e gaogua'? ");
INSERT INTO zavNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nach bosə'ənežɉue'ene' latə' beḻ ya'a gaogüe', nach bosə'ənežɉue'ene' to pedas c̱hixə' bia ser de'en yožə ši'imb. ");
INSERT INTO zavNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Gwxi'en na' gwdaogüe'en laoga'aquen'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nach gože' ḻega'aque': ―Bagwni'a le'e catə'ən ṉezolena' le'e de que cheyaḻə' gaquə yoguə'əḻoḻ de'e ca' zɉənyoɉ c̱hia' ḻe'e ḻei de'en bzoɉ de'e Moisezən', na' ḻe'e ḻibr de'en boso'ozoɉ de'e profet ca', na' ḻeczə ca' ḻe'e ḻibr gan' žia Salmos ca'. Na' de'e ca' zɉənyoɉ c̱hia' bac̱h goquən ṉa'a. ");
INSERT INTO zavNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nach ben Jeso'osən' par nic̱h gwse'eɉni'ine' de'e ca' zɉənyoɉən c̱he' ḻe'e Xtižə' Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Na' gože' ḻega'aque': ―Benən byen goc can' nyoɉən de que nada' gata' na' yebana' ladɉo beṉə' guat ca' yeyoṉ ža, nadan' naca' ben' gwleɉ Diozən' par gaquəlena' beṉac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Na' le'e cheyaḻə' güe'ele xtiža'anə' len beṉə' ža' yoguə' ṉasyon, na' solaotecle güe'elen Jerosalenṉə'. Güe'ele xtiža'anə' de que cheyaḻə' yesyə'ədiṉɉe beṉac̱hən' xtoḻə'əga'aque'enə' par nic̱h Diozən' yezi'ixene' c̱hega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Na' le'e nacle testigw na' güe'ele dižə' c̱he de'e quinga bable'ile de'en bagoc c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Na' ḻeczə əseḻa'a Spirit c̱he X̱a' Diozən' yedəson len le'e can' bene' lyebe. Na' ḻe'e yega'aṉ lao' syoda nga xte catə' X̱a' Diozən' goṉe' le'e yeḻə' guac de'en za' yoban'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Na' Jeso'osən' gwc̱he'e ḻega'aque' ɉa'aque' gan' nzi' Betania, na' gwḻis ne'e ca' gwṉabene' Diozən' gone' par nic̱h ṉite'e mbalaz. ");
INSERT INTO zavNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Na' goquən' beyož gwṉabe'en, Diozən' bezi' beque'ene' yobanə'. ");
INSERT INTO zavNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Na' disipl ca' besyə'əga'aṉe' gwso'elaogüe'e Jeso'osən' yešlož dao' na' ɉəya'aque' Jerosalenṉə' chesyə'əbeine' xte juisy. ");
INSERT INTO zavNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nach gwnitə'ətezə gwnite'e ḻo'o yo'odao' əblaonə' chso'elaogüe'e Diozən'. De'e na'azən' chzoɉa' ṉa'a.");
INSERT INTO zavNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Catə' gwxe yežlyonə' bazoczə ben' naquə Dižə'ənə'. Zoe' len Diozən' na' ben' naquə Dižə'ənə' ḻeczə naque' Dioz. ");
INSERT INTO zavNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Dezd nechte zoe' len Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Na' Diozən' bene' par nic̱h ben' naquə Dižə'ən bene' yoguə'əḻoḻ beṉac̱h, angl, bia chsa'aš, na' yeziquə'əchlə de'e zɉəde. Bitobi bi de de'e gwxe de'e gwzil de'e cui ben ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ḻe' nse'e yeḻə' mban zeɉḻicaṉe. Na' beṉə' ca' zɉənape' yeḻə' mban zeɉḻicaṉe, yo'o be'eni' ḻo'o yic̱hɉla'ažda'oga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Na' ben' naquə Dižə'ənə' nse'e be'eni' par yic̱hɉla'aždao' beṉac̱hən'. Na' ḻa'aṉə'əczə chacchgua de'e malən' yežlyo nga gan' ble'enə', de'e malən' bito chgapə'ən be'eni' c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Diozən' bseḻe'e to beṉə' le' Juan. ");
INSERT INTO zavNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Bide' bedəye'e dižə' c̱he ben' nsa' be'eni'inə' par nic̱h yoguə'əḻoḻ beṉac̱hən' guaquə so'onḻilaže'e ben' nsa' be'eni'inə' catə' se'enene' xtižə' Juanṉə'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Caguə Juan na'anə' nse'e be'eni'inə', sino bide' bedəye'e dižə' c̱he ben' nsa' be'eni' par beṉac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Babžin ža bla' be'eni' c̱he Diozən' yežlyo nga par šo'on ḻo'o yic̱hɉla'aždao' beṉac̱hən', na' chse'eni'in len notə'əteze'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ben' naquə Dižə'ənə' gwzoe' yežlyon'. Na' ḻa'aṉə'əczə ḻen' bene' yežlyon', beṉə' ca' ža' yežlyon' bito gwsa'acbe'ine' non' naque'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Golɉe' entr neto' naquəto' beṉə' ṉasyon c̱he'enə', na' casi yoguə' neto' naquəto' beṉə' ṉasyon c̱he' bito gwyeɉḻe'eto' c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Con beṉə' chse'eɉḻe'e c̱he', beṉə' chso'onḻilaže'ene', chone' par nic̱h zɉənaque' xi'iṉ Dioz. ");
INSERT INTO zavNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Zɉənaque' xi'iṉe' caguə por ni c̱he gwsa'alɉe' zɉənaque' beṉə' belə' chen, na' caguə por ni c̱he de'en gwzelažə' beṉə' byon' na' no'olə, na' caguə por ni c̱he gone'e beṉə' byon' so xi'iṉe'. Dioz nan' bene' xi'iṉe' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Na' ben' naquə Dižə'ənə' golɉe' goque' beṉac̱h na' gwzoe' len neto'. Ble'ito'one' na' gocbe'ito' de que naque' ḻe'ezelaogüe beṉə' zaque'e la' ḻen' naque' Xi'iṉ tlišə' X̱acho Diozən'. Ḻechguaḻe nži'ilaže'e beṉac̱hən' na' chzeɉni'ine' beṉac̱hən' yoguə'əḻoḻ dižə' ḻi c̱he Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juanṉə' bzeɉni'ine' c̱he' gwne': ―C̱he be'ena'anə' babi'a dižə' gwnia' de que ben' ze'e əchoɉ zaquə'əche' ca nada', c̱hedə' bazoczə ḻe'enə' antslə ze'e soa' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Na' Xi'iṉ Diozən' laogüe de'en ḻechguaḻe nži'ilaže'e chio'o, zotezə zoe' chaclenchgüe' yoguə' chio'o chonḻilažə'əchone'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","De'e Moisezən' bzeɉni'ine' de'e x̱axtao' neto' beṉə' Izrael ḻei c̱he Diozən', na' Jesocristən' bedəlo'e de que nži'ilažə' Diozən' chio'o beṉac̱h na' chzeɉni'ine' chio'o yoguə'əḻoḻ dižə' ḻi c̱he Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ni to cui noṉə' le'i Diozən'. Xi'iṉe' tlišə'ənə' ben' chaquene' c̱hei babzeɉni'iczene' beṉac̱hən' can' naquə yic̱hɉla'aždao' Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Beṉə' blao c̱he ṉasyon Izrael c̱heto'on ža' Jerosalenṉə' boso'oseḻe'e baḻə bx̱oz lao ben' le Juan len yebaḻə beṉə' gwsa'alɉə lao dia c̱he de'e Lebi beṉə' zɉəyo'o lao na'aga'aque' so'one' mendad ḻo'o yo'odao' əblao c̱he neto' beṉə' Izrael. Boso'oseḻe'e beṉə' ca' lao Juanṉə' par nic̱h gosə'əṉezene' non' naque'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Na' gože' ḻega'aque' clar: ―Caguə nadan' Cristən' ben' naquən əseḻə' Diozən' par gaquəlene' ṉasyon c̱he chio'o beṉə' Izraelən'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Na' gwse'ene': ―¿Noxa le' ža? ¿əšə len' Ḻiazən' ben' be' xtižə' Diozən' cana'? Na' gože' ḻega'aque': ―Caguə nada'anə'. Nach gosə'əze'ene': ―¿Ešə len' ben' naquən yidə par güe'elene' neto' xtižə' Diozən'? Na' boži'en gwne': ―Bitoczə. ");
INSERT INTO zavNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nach gwse'ene': ―¿Noxaczə le'? nic̱h žɉəyeyežto' beṉə' ca' boso'oseḻə' neto'. ¿Bi natgo' c̱he cuino'? ");
INSERT INTO zavNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nach gože' ḻega'aque': ―Nada' naca' ben' chṉe zižɉo latɉə dašən', əṉia': “Ḻe'eyoša' yic̱hɉla'ažda'olen' par nic̱h əgwzenagle c̱he X̱anchon' catə'ən yide'enə'”, can' gwna de'e profet Isaiazən' ben' be' xtižə' Diozən' cana'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Na' beṉə' ca' ɉa'ac lao Juanṉə' boso'oseḻə' beṉə' fariseo ca' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Na' gwse'ene': ―¿Bixc̱hen' chc̱ho' beṉə' nis šə cui naco' Cristən', na' šə cui naco' Ḻiazən' na' šə ni ben' naquən yidə par güe'elene' neto' xtižə' Diozən'? ");
INSERT INTO zavNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Na' Juanṉə' boži'e xtižə'əga'aque'enə' gože': ―Nada' chc̱hoa' beṉə' nis, pero na' entr le'e zo to beṉə' cui nombi'ale. ");
INSERT INTO zavNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Be'enə' ze'e əchoɉe' na' zaquə'əche' ca nada' na' bito zaca'a par gaca' xmose'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yoguə' de'e quinga goquən yež de'en nzi' Betabara. Na' yežən' chi'in yešḻa'alə yao Jordanṉə' gan' chc̱hoa Juanṉə' beṉə' nis. ");
INSERT INTO zavNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Beteyo ble'i Juanṉə' za' Jeso'osən' gan' zoe'enə' na' gože' neto' ža'ato'onə': ―Ḻe'e güiašc nga za' ben' bseḻə' Diozən' ben' gwxaquə'əlebe ca xilə' dao' bia ca' chotcho par chnitlao xtoḻə'əchon'. Ḻe'enə' yeque'e xtoḻə' beṉac̱hən' con beṉə' so'onḻilažə' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","C̱he bengan' bi'a dižə' catə'ən gwnia' de que ben' ze'e əchoɉ zaquə'əche' ca nada', c̱hedə' bazoczə ḻe'enə' antslə ze'e soa' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Bito gocbe'ida' nada' cate non' naque'. Pero ṉa'a za'a chc̱ho'a beṉə' nis par nic̱h yeziquə'əchlə beṉə' Izrael sa'acbe'ine' non' naque'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Na' Juanṉə' be'eche' dižə' c̱he Jeso'osən' gwne': ―Spirit c̱he Diozən' de'en zo yoban' len Diozən' ble'ida' betɉən ca to ngolbexə na' bžinən gwzon len Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Bito gocbe'ida' nada' non' naque' žalə' que Diozən' ben' bseḻə' nada' par chc̱hoa' beṉə' nis gwne' nada': “Le'ido' yetɉ Spirit c̱hia'anə' gan' zo ben' gon ca so Spirit c̱hia'anə' ḻo'o yic̱hɉla'ažda'olen' na' ṉabi'an le'e. Na' catə' əžin Spirit c̱hia'anə' gan' zo be'enə', son len ḻe'.” ");
INSERT INTO zavNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nada' bable'ida' goc can' gwne'enə' na' cho'a dižə' de que bengan' Xi'iṉ Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ža beteyo zecha Juanṉə' len c̱hopə neto' disipl c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Na' ble'ine' gwde Jeso'osən', na' gože' neto': ―Ḻe'e ggüiašc na' zda ben' bseḻə' Diozən' ben' gwxaquə'əlebe ca xilə' dao' bia ca' chotcho par chnitlao xtoḻə'əchon'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Na' c̱hopte neto' gože' ca' ɉenaoto' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Na' beyec̱hɉ Jeso'osən' na' ble'ine' banaoto'one'. Na' gože' neto': ―¿Bixc̱hen' naole nada'? Na' gožto'one': ―Maestr, ¿ga zo'? ");
INSERT INTO zavNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nach gože' neto': ―Ḻe'e šo'o na' le'ile. Na' gwyeɉlento'one' na' ble'ito' gan' zoe'enə', na' bega'aṉlento'one' do yeto c̱hop or, c̱hedə' ca orən' banaquə ca do cheda tap. ");
INSERT INTO zavNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nada' lena' Ndres beṉə' bišə' Simon Bedən' beneto' dižə' de'en be' Juanṉə' na' gwnaoto' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Na' Ndresən' antslə ze'e gone' bichlə ɉəyeni'e Simon biše'enə' na' gože'ene': ―Babežaglaoto' Mesiasən'―, zeɉe dižə' Cristən' ben' gwleɉ Diozən' par gaquəlene' ṉasyon Izrael c̱heton'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nach Ndresən' gwc̱he'e Simon biše'enə' gan' zo Jeso'osən'. Na' lao chgüia Jeso'osən' ḻe' gože'ene': ―Len' Simon xi'iṉ Jonas. Pero yesə'əsi' beṉə' le' Sefas―, zeɉe dižə' Bed. ");
INSERT INTO zavNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Beteyo Jeso'osən' gwc̱hoglaogüe'en yeyeɉe' Galilean', na' bežague' Lipən' na' gože'ene': ―Yo'o len nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Lipən' naque' beṉə' Betsaida, laž Ndresən' na' laž Bedən'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nach Lipən' bežague' Natanaelən' na' gože'ene': ―Babežaglaoto' ben' bzoɉ Moisezən' xtiže'e ḻe'e ḻibr ca' gan' ḻeczə bzoɉe' ḻein', na' c̱he ḻecze'en boso'ozoɉ beṉə' ca' gwso'e xtižə' Diozən' cana'. Ḻen' Jeso'osən' beṉə' Nasaret, xi'iṉ Jwsen'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Na' gož Natanaelən' ḻe': ―¿Bat benecho Nasaret na' əchoɉ beṉə' güen? Na' gož Lipən' ḻe': ―Yo'o nic̱h əṉezdo'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Na' catə' Jeso'osən' ble'ine' bachžin Natanaelən' baozə, gwne' c̱he': ―Na' za' to beṉə' Izrael gwlaž c̱hecho ben' naquə beṉə' güen, na' ni latə'əzə cui naque' beṉə' gox̱oayag. ");
INSERT INTO zavNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Na' gož Natanaelən' ḻe': ―¿Nac chac nombi'o nada'? Na' Jeso'osən' gože'ene': ―Antslə ze'e əṉe' Lipən' le', catə'ən zecha'o xan yag yix̱güionə', ble'ida' le'. ");
INSERT INTO zavNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nach Natanaelən' gože'ene': ―Maestr, len' naco' Xi'iṉ Dioz. Len' naco' Rei ben' chbezəto' yedəṉabia' neto' beṉə' Izrael. ");
INSERT INTO zavNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Na' Jeso'osən' gože'ene': ―¿Epor ni c̱he de'en gwnia' de que ble'ida' le' xan yag yix̱güion' cheɉḻi'o de que Diozən' gwleɉe' nada' par gaquəlena' ṉasyon c̱hechon' ža? De'e zaquə'əche ca de'e nga ze'e za'ac. ");
INSERT INTO zavNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nach Jeso'osən' goze'e neto': ―De'e ḻi əchnia' le'e, le'ixeɉele yoban' gan' zo Diozən' na' angl c̱he' ca' əse'ep se'etɉe' yežlyo nga gan' zoa', la' Dioz nan' bseḻe'e nada' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Gwde šoṉə ža nach gotə' to yeḻə' gošagna' yež de'enə' nzi' Cana distrit c̱he Galilea, na' gwyeɉ xna' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Na' ḻeczə gwsa'axe' Jeso'osən' len neto' disipl c̱he' nic̱h gwyeɉto' gan' chac yeḻə' gošagna'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Na' caguə goque binon' par əse'eɉ yoguə' beṉə' ca' ža'anə'. Nach xna' Jeso'osən' gože'ene': ―Bito bi bino dech c̱hega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Na' gož Jeso'osən' ḻe': ―Nagüe, ¿bixc̱hen' chi'o nada' ca'? Ze'e əžin or gaquəlena' beṉə' quinga. ");
INSERT INTO zavNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Na' xne'enə' gože' beṉə' ca' chso'on mendadən': ―Ḻe'e gon bitə'ətezə de'e əṉe'. ");
INSERT INTO zavNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na' nitə' x̱op yeɉ ga chož nis. Yeɉ ca' zɉənac ca' choso'oc̱hin beṉə' Izrael gwlaž c̱heto' ca' par chsa'a chəsə'əyib cuinga'aque' segon can' na ḻei c̱heto'onə'. Na' to to yeɉ ca' chožən do x̱on' che'e o do ši che'e nisən'. ");
INSERT INTO zavNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Na' gož Jeso'osən' beṉə' güen mendad ca': ―Ḻe'e yosša' yeɉ ca' nisən'. Na' gosə'əgue'en xte ca gosə'əža'an. ");
INSERT INTO zavNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nach goze'e ḻega'aque': ―Ḻe'e gašə' latə'ən ṉa'a, na' ḻe'e žɉənežɉon' be'en chgüe'eɉ chguaon'. Nach gwsa'aše'en ɉəsə'ənežɉue'en be'en chgüe'eɉ chguaon'. ");
INSERT INTO zavNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Na' bnix̱ be'en nisən' banaquən bino, pero bito gwṉezene' ga gwza'anṉə', con beṉə' ca' gwsa'ašə' ḻen na' zɉəṉeze. Nach goxe' ben' chšagna'anə' ");
INSERT INTO zavNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","na' gože'ene': ―Yoguə' beṉə' chdie' zgua'atec bino šao', na' catə' beṉə' ca' ža'anə' bazɉəne'eɉe' zilən', nach cho'e ḻega'aque' de'e corrient. Pero na' le' bzago'o bino šao' nga xte ṉa'ach. ");
INSERT INTO zavNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","De'e nga ben Jeso'osən' Cana distrit c̱he Galilean' goquən miḻagr nech de'en bene' par blo'e de que nse'e yeḻə' guac c̱he Diozən'. Na' neto' disipl c̱he' benḻilažə'əto'one'. ");
INSERT INTO zavNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Gwde na' gwyeɉto' Capernaum len ḻe' na' len xne'enə' na' beṉə' biše'e ca'. Na' ɉəsoto' na' to c̱hopə šoṉə ža. ");
INSERT INTO zavNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Na' bazon gaḻə' lṉi pascw c̱he neto' beṉə' Izrael catə'ən gwyeɉto' len Jeso'osən' Jerosalenṉə'. ");
INSERT INTO zavNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Catə' bžinto' chyo'o yo'odao' əblao c̱he neto' beṉə' Izrael na' ža' beṉə' chəsyə'əyotə' go'oṉ na' xilə' na' ngolbexə, na' len beṉə' ca' zɉəchi' choso'oše'e mech. ");
INSERT INTO zavNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nach Jeso'osən' bene' to sot de do na' bebeɉe' yoguə'əḻoḻ beṉə' ca' ža' chyo'o c̱he yo'odao' əblaonə' len xilə' ca', len go'oṉ ca'. Na' beslase' xmech beṉə' goša' mech ca', na' gwlo'oṉi'ane'e mes c̱hega'aque' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Na' gože' beṉə' ca' chso'otə' ngolbexən': ―Ḻe'e yebeɉ yoguə'əḻoḻ bia quinga nga. Cui gonḻe ya'a nga liž X̱a'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nach ɉəyeza'alažə' neto' disipl c̱he' can' nyoɉ Xtižə' Diozən' gan' nan: “De'e tant chi' yic̱hɉa' c̱he ližo'onə' xte cheyožlaža'a.” ");
INSERT INTO zavNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Na' beṉə' ca' zɉənaquə beṉə' blao c̱he ṉasyon Izrael c̱heto'on ža'anə' gwse'ene': ―¿Bi yeḻə' guac əgwlo'ido' neto'onə' par nic̱h əṉezeto' šə napo' yeḻə' gwnabia' par bebeɉo' beṉə' ca'? ");
INSERT INTO zavNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Na' Jeso'osən' gože' ḻega'aque': ―Ḻe'e yoc̱hiṉɉ yo'odao' nga na' šoṉə žazə yeyona'an. ");
INSERT INTO zavNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nach beṉə' blao ca' gwse'ene': ―X̱opeyon iz gwso'one' yo'odao' nga, ¿əna' le' yeyono'on šoṉə žazə? ");
INSERT INTO zavNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero Jeso'osən' gwne' ca' c̱he cuerp c̱he'enə', chsa'aquə'əlebene'en ca yo'oda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nach catə' bžin ža bebane' ladɉo beṉə' guat ca', neto' disipl c̱he' ɉəyeza'alažə'əto' can' gwne'enə'. Na' gwyeɉḻe'eto' can' na Xtižə' Diozən' de'en nyoɉən de que Jeso'osən' yebane' ladɉo beṉə' guat ca', na' ḻeczə gwyeɉḻe'eto' de'en gože' neto'. ");
INSERT INTO zavNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Žlac gwzo Jeso'osən' Jerosalenṉə' lao lṉi pascon', beṉə' zan gwso'onḻilaže'ene' catə' besə'əle'ine' miḻagr ca' de'en bene'. ");
INSERT INTO zavNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero na' Jeso'osən' bito ben cuine' lao na' beṉə' ca' c̱hedə' baṉeze nḻe'ine' yic̱hɉla'aždao' beṉac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Na' bito byažɉene' no əgwzeɉni'i ḻe' can' naquə yic̱hɉla'aždao' beṉac̱hən' c̱hedə' ḻe' ṉezene' bin' yo'o ḻo'o yic̱hɉla'aždao' to toe'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Na' zo to beṉə' fariseo ben' le' Nicodemo. Na' naque' beṉə' blao c̱he ṉasyon Izrael c̱heton'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nicodemon' gwyeɉe' lao Jeso'osən' še'elə na' gože'ene': ―Maestr, ṉezeto' de que Diozən' bseḻe'e le' par chzeɉni'ido' neto', c̱hedə' la' notono no chac gon ca naquə miḻagr ca' chono' šə cui zo Diozən' len ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Na' gož Jeso'osən' ḻe': ―De'e ḻi əchnia' le' šə non' cui galɉə yeto bito gaquə soe' ca ṉabia' Diozən' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nach gož Nicodemon' ḻe': ―¿Nacxa gon to beṉə' galɉe' šə banaque' beṉə' golə? ¿Eguaquəch yeyo'e ḻo'o ḻe'e xne'e na' galɉe' yeto? ");
INSERT INTO zavNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nach gož Jeso'osən' ḻe': ―De'e ḻi əchnia' le', šə non' cui galɉə len nis na' len Spirit c̱he Diozən', bito gaquə soe' ca ṉabia' Diozən' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Beṉə' zɉənaque' belə' chen chəsə'əzan chəsə'əbeque' xi'iṉga'aque' ḻeczə bi'i belə' chen. Beṉə' ca' chon Spirit c̱he Diozən' par nic̱h chsa'alɉe', Spiritən' chnežɉon ḻega'aque' yeḻə' mban zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Bito yebando' can' gwnia' le' de que chonən byen galɉə yoguə'əle yeto. ");
INSERT INTO zavNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ca naquə be'enə' de'en chec̱hɉ, gatə'ətezə chene'en chec̱hɉən, na' chendo' choḻən, na' nic ṉezdo' gaxa za'anṉə' na' nic ṉezdo' gaxa šeɉənṉə'. Can' naquən c̱he yoguə'əḻoḻ beṉə' chon Spirit c̱he Diozən' par nic̱h chsa'alɉe'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nach Nicodemon' gože'ene': ―¿Nacxa chactguan' par chac can' na'onə'? ");
INSERT INTO zavNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Na' Jeso'osən' gože'ene': ―Le' naco' beṉə' blao entr beṉə' ca' choso'osed choso'olo'i beṉə' Izrael gwlaž c̱hecho ca' xtižə' Diozən', ¿əna' cui cheɉni'ido' de'e ngan'? ");
INSERT INTO zavNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","De'e ḻi əchnia' le', de'e ṉezeto'onə' chyix̱ɉue'eto' na' de'e bable'ito'onə' cho'eto' dižə' c̱hei, na' cui chzenagle. ");
INSERT INTO zavNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","De'en chac yežlyo ngan' bagwnia' le'e na' cui cheɉḻe'ele. ¿Nacxa gaquən' šeɉḻe'ele šə nia' le'e de'en chac yoban'? ");
INSERT INTO zavNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ni to beṉə' cui zo yežlyo nga beṉə' babeyep yoban' par ṉezene' can' chac yoban'. Pero ca naca' nada' ža, gwzoa' yoban' len Diozən' na' bseḻe'e nada' yežlyo nga par golɉa' beṉac̱h, na' zotezə zoa' len Diozən' ben' zo yoban'. De'e na'anə' ṉezda' can' chac yoban'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Na' can' gwḻis de'e Moisezən' beḻ de bronsən' to ḻe'e yag latɉə dašən', can' cheyaḻə' yesə'əḻise' nada' to ḻe'e yag, nadan' bseḻə' Diozən' golɉa' b'eṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Na' gaquə c̱hia' ca' par nic̱h notə'ətezə beṉə' gonḻilažə' nada' bito cuiayi'e, sino gatə' yeḻə' mban zeɉḻicaṉ c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ḻechguaḻe chaque Diozən' c̱he chio'o beṉac̱h na' beṉ Xi'iṉe' tlišə'ənə' par nic̱h na' notə'ətezcho chonḻilažə'əchone' bito cuiayi'icho mas de yeḻə' mban zeɉḻicaṉe c̱hecho. ");
INSERT INTO zavNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Diozən' bseḻe'e Xi'iṉen' yežlyo nga caguə par nic̱h əc̱hoglaogüe'en c̱he chio'o beṉac̱h de que napcho doḻə', sino par nic̱h gone' ca cui yeyeɉcho lao yi' gabiḻən'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Chio'o chonḻilažə'əcho Xi'iṉ Diozən' bac̱h nchoglaon c̱hecho de que bito bi doḻə' napcho, pero beṉə' cui chso'onḻilažə' ḻe' nchoglaon c̱hega'aque' de que zɉənape' doḻə' c̱hedə' bito chso'onḻilaže'e Xi'iṉ tlišə' Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Can' chac, beṉə' ca' cui chso'onḻilažə' ḻe' banchoglaon c̱hega'aque' de que zɉənape' doḻə', por ni c̱he de'en babidə Xi'iṉ Diozən' yežlyon' nse'e be'eni' par yic̱hɉla'aždao' beṉac̱hən', na' chəsyə'əbeichene' de'e žc̱hoḻən' cle ca be'eni' c̱he'enə' c̱hedə' chso'one' de'e malən'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Beṉə' ca' chso'on de'e malən' chəsə'əgue'ine' be'eni' c̱he'enə', na' bito chse'enene' əgwse'eni'in ḻo'o yic̱hɉla'ažda'oga'aque'enə', c̱hedə' bito chse'enene' la'alaon de que de'e malən' chso'one'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Caguə ca' chio'o chzenagcho c̱he dižə' ḻi c̱he Diozən' par choncho can' cheyaḻə' goncho. Chio'o cho'echo latɉə chse'eni'in ḻo'o yic̱hɉla'ažda'ochon' c̱hedə' chene'echo goncho ca sa'acbe'i beṉə' de que Diozən' chaclene' chio'o len bi de'en chonchon'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Gwde na' neto' disipl gwyeɉto' len Jeso'osən' yež dao' ca' zɉəchi' gan' mbane Jodean'. Na' žlac bega'aṉto'onə' Jeso'osən' bene' par nic̱h neto' bc̱hoato' beṉə' nis. ");
INSERT INTO zavNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Na' Juanṉə' ḻeczə chc̱hoe' beṉə' nis yež de'en nzi' Enon de'en chi' gaḻə'əzə yež Salim, gan' dechgua nis. Na' ɉa'ac beṉə' na' gosə'əchoe' nisən'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Cana' bitoṉə' gatə' Juanṉə' ližyan'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Na' gotə' to bžaš entr disipl c̱he Juanṉə' na' entr yeto c̱hopə beṉə' Izrael gwlaž c̱heto' ca' c̱he de'en chəsə'əc̱hoe' beṉə' nis. ");
INSERT INTO zavNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Na' disipl c̱he Juanṉə' ɉa'aque' laogüe'enə' na' gwse'ene': ―Maestr, ben' gwzo len le' yešḻa'alə yao Jordanṉə', ben' cho'o xtiže'e, ḻe' bachc̱hoe' beṉə' nisən' na' yoguə'əzə beṉə' chɉa'ac ga'an zoe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nach Juanṉə' gože' ḻega'aque': ―Notono no əye'elao' šə cui gon Diozən' par nic̱h so'elao' beṉə' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Le'e ṉezele can' bagwnia' de que bito naca' nada' Cristən' ben' bseḻə' Diozən' par gaquəlene' ṉasyon c̱hechon'. Nada' naca' ben' bseḻə' Diozən' par cho'a xtižə' Cristən' nic̱h ṉitə' beṉə' probnid par yoso'ozenague' c̱he' catə'ən yide'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Catə' chəsə'əšagna' beṉə', beṉə' byo ben' chšagna' ḻe'enə' chzi'e no'olən'. Na' beṉə' migw c̱he ben' chšagna'anə', zeche' cuite'enə' chebeichgüeine' chenene' chšil ben' chšagna'anə'. Ca'aczən' chac len nada' ža, ḻechguaḻe chebeida' de'en chso'elao' beṉə' Cristən'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","La' ḻe'enə' cheyaḻə' šeɉəchlə gaque' beṉə' blao; pero ca naquə nada', šeɉəchlə te c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ca naquə ben' za' gan' zo Diozən', ḻe' naque' blaoch ca notə'ətezəchlə beṉə'. Na' ca naquə notə'ətezəchlə beṉə' ža' yežlyo nga, be'en c̱he yežlyo nga zɉənaque' na' xtižə' yežlyo ngan' chso'e. Pero na' ben' za' gan' zo Diozən', ḻe' naque' beṉə' blaoch ca notə'ətezəchlə beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ḻe' cho'e dižə' c̱he de'en bable'ine' gan' zo Diozən' na' c̱he de'en babenene' na', na' notono no chzenag xtiže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Na' šə non' choso'ozenag xtižə' ben' za' gan' zo Diozən' choso'olo'e de que zɉəṉezene' Diozən' cho'e dižə' ḻi. ");
INSERT INTO zavNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Na' Xi'iṉ Diozən' ben' bseḻe'enə' cho'e xtižə' Diozən' c̱hedə' Diozən' chone' par nic̱h zotezə zo Spirit c̱he'enə' len ḻe' dote tyemp. ");
INSERT INTO zavNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Diozən' chaquene' c̱he Xi'iṉe'enə' na' babene' ca cheɉni'ine' yoguə'əḻoḻ par nic̱h ḻe' əgwzeɉni'ine' beṉac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Na' chio'o chonḻilažə'əcho Xi'iṉ Diozən' de yeḻə' mban zeɉḻicaṉe c̱hecho. Na' beṉə' ca' chso'onczə yic̱hɉlaoga'aque' cui chso'onḻilaže'ene', bito gatə' yeḻə' mban zeɉḻicaṉe c̱hega'aque' sino yesə'əzi'e castigw zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Na' beṉə' fariseo ca' gwsa'acbe'ine' de que beṉə' zanch ɉəsə'ənaogüe' Jeso'osən' cle ca Juanṉə' na' de que beṉə' zanch chc̱hoe' nis cle ca Juanṉə'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero caguə cuin Jeso'osən' bc̱hoe' ḻega'aque' nis sino neto' disipl c̱he' bc̱ho'ato' beṉə' nis. ");
INSERT INTO zavNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Na' ca naquən' gwṉeze Jeso'osən' can' bagwsa'acbe'i beṉə' fariseo ca' de que beṉə' zan zɉəsə'ənao ḻe' nach beza'ato' distrit c̱he Jodean' na' beyeɉto' distrit c̱he Galilean'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Par bežinto' Galilean' bedeto' distrit c̱he Samaria na'alə. ");
INSERT INTO zavNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ca' goquən' bežinto' to yež de'e nzi' Sicar distrit c̱he Samarian'. Naquə yežən' gaḻə'əzə len yežlyon' de'en bnežɉw de'e Jacobən' de'e xi'iṉe' Jwsen'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","Na' žia to pos na' de'e nzi' “Pos c̱he de'e Jacobən'”. Jeso'osən' bac̱h chɉx̱aque'ene' ngüe'e nezən' na' gwchi'e cho'a posən'. Bac̱h naquə ca do gobiž. Na' neto' gwyeɉto' lao' yežən' par si'ito' de'e gaoto'. Na' bžin to no'olə Samarian' par güe'e nis, na' Jeso'osən' gože'ene': ―Doa' latə' nis ye'eɉa'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Na' no'olə Samarian' gože'ene': ―¿Nactecxan' le' naco' beṉə' Izrael chṉabdo' nada' nis ye'eɉo'? len no'olə Samaria nada'―. (Ca naquə beṉə' Izrael gwlaž c̱heto' ca' bito chəsə'əṉe' beṉə' Samaria ca'.) ");
INSERT INTO zavNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Na' Jeso'osən' gože'ene': ―Žalə' ṉezdo' de'en chene'e Diozən' goṉe' le' na' žalə' chacbe'ido' non' naca' nada' chapa'a le': “Doa' latə' nis ye'eɉa'”, le' əṉabdo'on nada' na' nada' goṉa' le' nis de'e choṉ yeḻə' mban zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Na' no'olən' gože'ene': ―Señor, caguə nox̱o'o bi gašə'ədo'onṉə' na' pos nga naquən zitɉw. ¿Gaxa si'o nis de'en choṉ yeḻə' mban zeɉḻicaṉe de'en nao' ca'? ");
INSERT INTO zavNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Echacdo' de que zaquə'əcho' le' ca de'e x̱axta'ocho Jacobən' ben' bocua'aṉ len neto' pos nga ga güe'eɉe' na' xi'iṉe' ca' na' bia yix̱ə' c̱he' ca'? ");
INSERT INTO zavNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Na' gož Jeso'osən' ḻe': ―Notə'ətezə beṉə' ye'eɉ nis nga bia'aczə əbiləchene'en de'e yoblə. ");
INSERT INTO zavNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero na' notə'ətezə beṉə' ye'eɉ nisən' de'en əgwnežɉua' nada' cuatəch əbilene'en la' gatə' yeḻə' mban zeɉḻicaṉe c̱he'enə'. Na' nis de'en əgwnežɉua'ane' gaquən ḻo'o yic̱hɉla'aždaogüe'en ca to nis de'e chxitə' chžia chaldin na' de'e cuat yebižən. ");
INSERT INTO zavNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Na' no'olən' gože'ene': ―Señor, beṉ nada' nisən' nao' ca' par nic̱h cuich əbilda' na' cuich yida' dex̱ia'an nga. ");
INSERT INTO zavNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jeso'osən' gože'ene': ―Beyeɉ ɉəyeṉe be'en c̱hio'onə' na' ḻe'e da nga. ");
INSERT INTO zavNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nach gož no'olən' ḻe': ―Notono be'en c̱hia' zo. Na' gož Jeso'osən' ḻe': ―Ḻeiczədo' can' nao' de que notono be'en c̱hio' zo, ");
INSERT INTO zavNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","la' gueyə' be'en c̱hio' bagwnitə' beṉə' nšagna'aleno', na' ca naquə ben' zoleno' ṉa'a caguə nšagna'aleno'one'enə'. De'e ḻi can' bagwnao'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Na' gož no'olən' ḻe': ―Señor, bachacbe'ida' de que le' chyix̱ɉue'ido' bi de'en na Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","De'e x̱axta'o neto' beṉə' Samaria gwso'elaogüe'e Diozən' ya'an zo na', na' le'e nale de que Jerosalen na'anə' cheyaḻə' güe'ela'ocho Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Na' gož Jeso'osən' ḻe': ―No'olə, gwyeɉḻe' c̱hia' de que gwžin ža catə' bitoch gonən byen žɉe'ela'ole X̱acho Diozən' ya'an zo na' na' ni Jerosalenṉə'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Le'e nacle beṉə' Samaria bito nombia'ale ben' cheɉṉi'alažə'əle. Neto' beṉə' Izrael nombi'ato' Diozən' ben' cheɉṉi'alažə'əto'. Na' entr neto' beṉə' Izrael əchoɉ ben' chac yebeɉ beṉac̱hən' xni'a de'e malən'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Gwžin ža na' ṉa'a baza'an beṉə' ca' chse'eɉṉi'alaže'e X̱acho Diozən' can' chazlaže'enə' əso'elaogüe'ene' do yic̱hɉ do lažə'əga'aque' na' segon de'en naquə de'e ḻi, c̱hedə' X̱acho Diozən' chyilɉe' beṉə' əso'elao' ḻe' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Diozən' bito naque' beṉə' belə' chen. Na' beṉə' ca' chse'eɉṉi'alaže'e ḻe' cheyaḻə' so'elaogüe'ene' do yic̱hɉ do lažə'əga'aque' na' segon de'en naquə de'e ḻi. ");
INSERT INTO zavNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Na' gož no'olən' ḻe': ―Ṉezda' de que yidə ben' gwleɉ Diozən' par gaquəlene' chio'o, ben' nzi' Mesias o Crist. Catə' yide' na' c̱hix̱ɉue'ine' chio'o yoguə'əḻoḻ de'e quinga. ");
INSERT INTO zavNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Nach Jeso'osən' gože'ene': ―Nada'an naca' ben' nao' ca' na' cho'elena' le' dižə'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Na' ḻei cho'elene' no'olən' dižə' catə' bežin neto' disipl c̱he'. Na' bebaneto' de'en cho'elene' to no'olə dižə' pero ni toto' cui gwṉabeto'one' bi dižə'ən cho'elene' no'olən' o bixc̱hen' chšillene'ene'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nach no'olən' bcua'aṉ che'e c̱he'enə' na' beyeɉe' yežən' ɉəyeže' beṉə' gwlaž c̱he' ca': ");
INSERT INTO zavNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Ḻeda ḻegüia to beṉə' bagwne' nada' yoguə'əte de'en babena'. ¿Šə bengalizən' Cristən'? ");
INSERT INTO zavNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Na' besə'əžaše' yežən' ɉa'aque' gan' zo Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Žlac zɉəyeda no'olən' gotə'əyoito' Jeso'osən' che'eto'one': ―Maestr, gwdao. ");
INSERT INTO zavNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Na' Jeso'osən' gože' neto': ―Bito ṉezele de to yeḻə' guao c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nach gwnato' entr neto': ―¿Šə nolizə babedegua' de'e gwdaogüe'enə'? ");
INSERT INTO zavNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Na' gož Jeso'osən' neto': ―Par nada' naquən ca to yeḻə' guao chona' can' chene'e ben' əbseḻə' nada' nic̱h gaquə yoguə' de'en chene'ene' gaquə. ");
INSERT INTO zavNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Le'e nale: “Ṉe'e dech yetap bio' par yedobə cwsešən'.” Na' nada' əchnia' le'e, de yeto cwseš de'e cheyaḻə' yedobə, beṉə' ca' yoso'ozenag c̱he Diozən' šə güe'elenchga'acchone' xtiže'enə'. Ḻegon xbab de que bagoḻə gatə'əyoiga'aquechone' yoso'ozenague' c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ben' chon par nic̱h beṉə' choso'ozenague' c̱he Diozən' chaclene' beṉə' par nic̱h chəsə'əzi'e yeḻə' mban zeɉḻicaṉe. Na' Diozən' chone' ca zoe' mbalaz por ni c̱he de'en chaclene' ḻega'aque'. Can' chac, ben' chyix̱ɉui'e xtižə' Diozən' de'e neche na' ben' chon par nic̱h beṉə' choso'ozenague' c̱hei txenṉə' chəsyə'əbeine'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","De'e ḻi can' na dižə'ən de'en de: “Beṉə' yoblən' chaz na' beṉə' yoblən' chelap.” ");
INSERT INTO zavNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nada' bac̱h chseḻa'a le'e ca beṉə' yesyə'əlape' gan' cui gwso'one' žin. Beṉə' yoblə bagosə'əyix̱ɉui'e xtižə' Diozən' na' le'e gonḻe par nic̱h beṉə' ca' gwse'enene' xtiže'enə' yoso'ozenague' c̱hei. ");
INSERT INTO zavNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Na' zan beṉə' ža' lao' yež Sicarən' gan' mbane Samarian' gwso'onḻilaže'e Jeso'osən' por ni c̱he de'en gwna no'olən': “Bagwne' nada' yoguə'əte de'e babena'.” ");
INSERT INTO zavNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Na' catə' besə'əžin beṉə' Sicarən' gan' zoe'enə' gwsa'atə'əyoine' Jeso'osən' yega'aṉe' len ḻega'aque', na' bega'aṉe' c̱hopə ža. ");
INSERT INTO zavNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Na' beṉə' zanch gwso'onḻilaže'ene' por ni c̱he dižə' de'en be' cuin Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Na' gwse'e no'olən': ―Ṉa'a chonḻilažə'əto'one' caguə por ni c̱he de'en gwnao' na'azən' sino por ni c̱he de'en babeneto' cho'e dižə' cuinczəto'. Baṉezeto' de que de'e ḻiczə bengan' Cristən' ben' gwleɉ Diozən' par yebeɉe' beṉac̱hən' xni'a de'e malən' con beṉə' se'eɉḻe'e c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Na' catə' goc c̱hopə ža zoto'onə', beza'ato' beyeɉto' Galilean'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Na' cuin Jeso'osən' bagwnacze' de que beṉə' gwlaž c̱he notə'ətezə profet beṉə' cho'e xtižə' Diozən' bito chso'ene' yeḻə' bala'aṉ na' nic chse'eɉḻe'e c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pero na' catə' bežinto' Galilean', beṉə' Galilea ca' besyə'əbeine' na' boso'ozenague' c̱he Jeso'osən' c̱hedə' ḻeczə ḻega'aque' ɉa'aque' Jerosalenṉə' par lṉi pascon' na' besə'əle'ine' yoguə' de'e güen de'en bene' bedote lao lṉinə'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Na' gozeɉto' len Jeso'osən' yetši'i yež Canan' distrit c̱he Galilean' gan' bene' par nic̱h beyac nisən' bino. Na' yež Capernaunṉə' zo to beṉə' blao beṉə' chon žin c̱he rein' na' chacšenchgüei xi'iṉe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","X̱a bi'inə' catə' benene' rson bežinto' Galilean' zeza'ato' Jodean', bide' lao Jeso'osən' na' gotə'əyoine' ḻe' šeɉe' žɉəyeyene' xi'iṉe'enə', c̱hedə' bazon gatbo'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Na' Jeso'osən' gože'ene': ―Šə cui le'ile miḻagr na' bichlə de'e zaquə' yebanele, bito šeɉḻe'ele c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nach ben' chon žin c̱he rein' gože' ḻe': ―Señor, yo'ošga antslə cuiṉə' gat bi'i c̱hia'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Na' Jeso'osən' gože'ene': ―Beyeɉ. Bito gat bi'i c̱hio'onə'. Nach gwyeɉḻe' be'enə' de'en gož Jeso'osən' ḻe' na' beze'e. ");
INSERT INTO zavNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Na' lao bazengüe'e nezən' ɉəsə'əšag xmose' ca' ḻe' na' gwse'ene': ―Bacheyaque bi'i c̱hio'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nach gwṉabene' ḻega'aque' bi or gwzolao beša'alažə'əbo'. Na' ḻega'aque' gwse'ene': ―Ṉeɉe cheda to gobiž bechoɉbo' de'e ḻan'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nach x̱abo'onə' gocbe'ine' or na'anə' gož Jeso'osən' ḻe' de que bito gat bi'i c̱he'enə'. Nach benḻilaže'e Jeso'osən', ḻe' na' famiḻy c̱he'enə' na' yoguə' beṉə' ža' liže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","De'e nga goc c̱hop las ben Jeso'osən' miḻagr catə' ze'e beze'e Jodean' na' bežine' Galilean'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Gwdenə' goḻə' to lṉi c̱he neto' beṉə' Izrael Jerosalenṉə' na' gwyeɉ Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerosalen na' žia to tanc de'en nzi' Betesda dižə' ebreo. Žian gaḻə'əzə cho'a puert c̱he syodan' de'en nzi' “C̱he xilə' ca'”. Na' nyec̱hɉ mbi'i cuit cue'eɉ tanquən' gueyə' ca cha'ašil dao'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Na' beṉə' zan beṉə' güe' zɉəde' ḻo'o cha'ašil da'onə', no beṉə' lc̱hoḻ, beṉə' coj, na' no beṉə' zɉənat to part güeɉə cuerp c̱hega'aque'enə'. Zɉədie' chəsə'əbeze' batə'əquən' ta nisən'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","To angl betɉe' tgüeɉə bte' nisən', na' con beṉə' chyobe chetɉ ḻo'o nisən' catə'ən cheyož chta anglən' ḻen, ḻe'enə' cheyaque c̱he bitə'ətezə yižgüe' de'e che'ine'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na' entr beṉə' ca' len to beṉə' byo bagoc ši'inšoṉəchoa iz chacšenene'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Na' Jeso'osən' ble'ine' be'enə' na' gocbe'ine' de que bagwža de' ca'. Na' gože'ene': ―¿Eche'endo' yeyacdo'? ");
INSERT INTO zavNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Na' beṉə' güe'enə' gože'ene': ―Señor, caguə no beṉə' zo cue'e nada' ḻo'o tanquən' catə'ən chda nisən'. Na' žlacte əzya'a nada' par šo'a, beṉə' yoblə chyobene' chetɉe' ḻo'o nisən'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nach gož Jeso'osən' ḻe': ―Gwyas na' botobə xta'onə' na' gwda. ");
INSERT INTO zavNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Na' ḻe'e beyactei be'enə' na' botobe' xte'enə' na' gwzolao chde'. Goc de'enə' ža dezcanz. ");
INSERT INTO zavNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nach beṉə' blao c̱he neto' beṉə' Izrael gwse'e ben' beyaquen': ―Ža dezcanz ṉa'a. Bito de lsens yeyoa' xta'onə. ");
INSERT INTO zavNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nach gože' ḻega'aque': ―Ben' beyone nada' gože' nada': “Botobə xta'onə', beyoa'an na' gwda.” ");
INSERT INTO zavNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Na' gwse'ene': ―¿Noxan' gož le': “Botobə xta'onə' na' gwda”? ");
INSERT INTO zavNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Na' ben' beyaquene' bito ṉezene' non', c̱hedə' Jeso'osən' babebi'iže'e gan' ža' beṉə' zan ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Gwdechlə bedil Jeso'osən' ḻe' ḻo'o yo'odao' əblaonə' na' gože'ene': ―Bac̱h beyacdo' ṉa'a. Bitoch bi de'e mal gono' par nic̱h cui gac c̱hio' to de'e maləch. ");
INSERT INTO zavNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nach beza' be'enə' na' gwdix̱ɉue'ine' beṉə' blao c̱he ṉasyon Izrael c̱heto'on de que Jeso'os na'anə' beyone ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Na' de'e na'anə' beṉə' blao ca' boso'olagzeɉə boso'olagzide' Jeso'osən' chəsə'əyilɉlaže'e naclən' so'one' par so'ote'ene' de'en bene' miḻagr ca' ža dezcanzən'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Na' Jeso'osən' gože' ḻega'aque': ―X̱a'anə' chelaḻene' yoguə' ža, na' ḻeczə ca' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nach beṉə' blao c̱he ṉasyon c̱heto'on mazəchlə gosə'əyilɉlaže'e naclən' so'one' par so'ote'ene' por ni c̱he de'en gwne' de que Diozən' naquə X̱e', caguə tlaozə de'en cui bemba'aṉe' ža dezcanz na'anə'. Na' de'en gwne' de que Diozən' naque' X̱e' zeɉen de que tozəczə can' zaque'e len Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Na' gož Jeso'osən' ḻega'aque': ―De'e ḻi chnia' le'e, bito gaquə bi gona' to gwlazza', nadan' naca' Xi'iṉ Diozən'. De'en chle'ida' chon X̱a'anə', ḻenṉə' chona'. Yoguə'əḻoḻ de'en chon X̱a'anə', ḻeczə ḻenṉə' chona'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","X̱a'anə' chaquene' c̱hia', na' chlo'ine' nada' yoguə' de'en chon cuine'. Na' əgwlo'ine' nada' de'e zaquə'əch ca de'e quinga de'e gona' par nic̱h yebanele. ");
INSERT INTO zavNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","X̱a' Diozən' chbeɉe' beṉə' na' chone' ca chatə' yeḻə' mban zeɉḻicaṉe c̱hega'aque' par nic̱h cui əsa'aque' ca beṉə' guat len yic̱hɉla'ažda'oga'aque'enə'. Na' ca'aczən' chona' nada' naca' Xi'iṉe', chbeɉa' beṉə' par chnežɉua' yeḻə' mban zeɉḻicaṉe c̱hega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Bito chc̱hoglao X̱a' Diozən' c̱he ni to beṉə' šə nape' doḻə', sino babeṉe' nada' yeḻə' chnabia'anə' par əc̱hoglaogua'an c̱he beṉac̱hən' šə non' napə doḻə'ənə', nadan' naca' Xi'iṉe'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","X̱a' Diozən' chene'ene' de que yoguə'əḻoḻ beṉə' so'oṉe' nada' yeḻə' bala'aṉ can' chso'e ḻe' yeḻə' bala'aṉ. Ben' cui choṉ nada' naca' Xi'iṉ Dioz yeḻə' bala'aṉ, lente X̱a' Dioz na'anə' cui cho'e yeḻə' bala'aṉ, c̱hedə' ḻen' bseḻe'e nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","De'e ḻi chnia' le'e, ben' chzenag xtiža'anə' na' chonḻilaže'e Diozən' ben' əbseḻə' nada' de yeḻə' mban zeɉḻicaṉe c̱he'. Na' cuat si'e castigon', c̱hedə' bitoch naque' len yic̱hɉla'aždaogüe'en ca beṉə' guat, sino bade yeḻə' mban zeɉḻicaṉe c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","De'e ḻi chnia' le'e gwžin ža catə'ən beṉə' ca' zɉənaque' len yic̱hɉla'ažda'oga'aque'enə' ca beṉə' guat əse'enene' xtiža'a nada' Xi'iṉ Dioz, na' beṉə' ca' yoso'ozenag c̱hia' yesə'əbane' zeɉḻicaṉe. Na' bac̱h chzolao chac ca' ṉa'a. ");
INSERT INTO zavNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","X̱a' Diozən' nse'e yeḻə' mban zeɉḻicaṉe na' chac gwnežɉue'en beṉac̱hən', na' ca'aczə babene' par nic̱h nada' nsa'a yeḻə' mban zeɉḻicaṉen' na' chac chnežɉua'an c̱he beṉac̱hən', nadan' naca' Xi'iṉe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na' ḻeczə beṉe' nada' yeḻə' chnabia'anə' par nic̱h əc̱hoglaogua'an non' napə doḻə' c̱hedə' bseḻe'e nada' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Bito yebanele de'e nga. Gwžin ža catə' yoguə'əḻoḻ beṉə' guat ca' ža' ḻo'o ban' əse'enene' əṉia' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Na' beṉə' ca' gwso'on de'e güen žlac gosə'əbane' yesyə'əchoɉe' par yesə'əbanche' zeɉḻicaṉe. Na' beṉə' ca' gwso'on de'e mal žlac gosə'əbane' yesyə'əchoɉe' par əsa'aque' castigw. ");
INSERT INTO zavNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Bito bi gaquə gona' de'e bia'azəlaža'a. Chzenaga' bin' na X̱a'anə' par nic̱h ṉezda' naquən' chc̱hoglaogua'an c̱he beṉac̱hən' šə non' napə doḻə'. Na' chc̱hoglaogua'an c̱he to toe' can' cheyaḻə'əczə gaquə c̱hedə' bito chona'an de'e bia'azəlaža'a. Chona'an con can' chene'e X̱a'anə' ben' əbseḻə' nada'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Žalə' toza' nada' cho'a dižə' non' naca', bito naquən de'e šeɉḻe'ele c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero zo X̱a'anə' cho'e dižə' non' naca', na' ṉezda' de que dižə' de'en cho'e c̱hia'anə' naquən de'e ḻi. ");
INSERT INTO zavNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Bac̱h bseḻə'əle beṉə' lao Juanṉə' par ɉəsə'əṉabene' ḻe' c̱hia'. Na' Juanṉə' be'e dižə' ḻi non' naca'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero ca naca' nada' bito chyažɉda' əṉezda' dižə' de'e güe' ni to beṉac̱hən' c̱hia'. Parzə nic̱h le'e šeɉḻe'ele c̱hia' na' gona' ca cui yeyeɉle lao yi' gabiḻən', de'e na'anə' che'enda' yosa'alažə'əle de'en gwna Juanṉə' c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juanṉə' goque' ca to lampara de'e chse'eni'ichgua, na' gone'ele bebeile šlož can' bsed əblo'ine'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","De to de'e cho'en xtiža'a de'e zaquə'əche ca dižə' c̱hia' de'en choe' Juanṉə'. Nada' chona' yoguə'əḻoḻ de'en chon X̱a'anə' lao na'a gona', na' de'en chona' cho'en dižə' de que ḻe'enə' bseḻe'e nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Na' ḻeczə X̱a'anə' ben' bseḻə' nada' cuine' babe'e xtiža'a. Na' bitoṉə' gwzenagle xtiže'enə' nic ṉe'e le'ile can' naque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Bitoṉə' gone c̱hele xtiže'enə' c̱hedə' bito chonḻilažə'əle nada' naca' ben' əbseḻe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Chsedyaṉə'əle Xtižə' Diozən' de'en nyoɉən, chaquele naple yeḻə' mban zeɉḻicaṉe laogüe de'en chsedlen. Na' de'e ca' zɉənyoɉən chso'en xtiža'a. ");
INSERT INTO zavNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pero cui chene'ele gonḻilažə'əle nada' par gaple yeḻə' mban zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Par nada' bito bi nonən šə beṉac̱hən' so'oṉe' nada' yeḻə' bala'aṉ o šə cui. ");
INSERT INTO zavNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nada' nombi'a le'e na' ṉezda' cabi chaquele c̱he Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","X̱a'anə' bseḻe'e nada' na' beṉe' nada' yeḻə' chnabia' par chona' con can' ne'enə' na' cabi cheɉḻe'ele c̱hia'. Na' šə beṉə' yoblə yide' to gwlazze', gwyeɉḻe'ele c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Bito gaquə šeɉḻe'ele c̱hia' c̱hedə' la' chi' yic̱hɉle chonḻe ca so'oṉ lɉuežɉle ca' le'e yeḻə' bala'aṉ na' cui cheyilɉle naclən' gonḻe par nic̱h Diozən' goṉe' le'e yeḻə' bala'aṉ. Tozə ḻe'enə' cho'e yeḻə' bala'aṉ de'en naquə de'e zaque'e. ");
INSERT INTO zavNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Bito gonḻe xbab de que nada' gua'a le'e part lao X̱a'anə'. De'e Moisezən', ben' zole lez gaquəlen le'e lao Diozən', ḻe'enə' güe'e le'e part lao X̱a'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Žalə' gwyeɉḻe'ele c̱he de'e Moisezən' na' šeɉḻe'etele len c̱hia' nada', c̱hedə' c̱hia' nadan' bzoɉe'. ");
INSERT INTO zavNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Na' ca naquən' cui cheɉḻe'e de'en bzoɉe'enə', ¿nacxa gonczle šeɉḻe'ele de'en bagwnia' le'e? ");
INSERT INTO zavNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Gozde de'e ca' gwyeɉto' len Jeso'osən' yešḻa'alə Nisdao' Galilean'. Na' nisda'onə' ḻeczə nzi'in Nisdao' Tiberias. ");
INSERT INTO zavNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Na' beṉə' zan bedəsə'ənao ḻe' c̱hedə' besə'əle'ine' miḻagr ca' de'en chone' cheyone' beṉə' güe' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Na' gwloeto' to lao ya'a len Jeso'osən' na' na' gwche'eto' len ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na' bazon baozə gaḻə' lṉi c̱he neto' beṉə' Izrael de'en nzi' lṉi pascw. ");
INSERT INTO zavNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Na' catə' bgüia Jeso'osən' na' ble'ine' de que baza'ac beṉə' zan gan' zoe'enə', na' gože' Lipən': ―¿Gaxa si'icho de'e əsa'o yoguə' beṉə' quinga? ");
INSERT INTO zavNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jeso'osən' gwne' ca' parzə nic̱h ye' Lipən' nac chaquene' cheyaḻə' gonto', la' baṉezczene' naquən' gone'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Na' gož Lipən' ḻe': ―Tmil pes cabi gaquen si'icho de'e əsa'ogüe' latə' güeɉən. ");
INSERT INTO zavNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Na' zo to disipl c̱he Jeso'osən', ben' le Ndres, bišə' Simon Bedən'. Na' Ndresən' gože' Jeso'osən': ");
INSERT INTO zavNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Nga zo to bi'i byo na' de gueyə' yetxtil de sebad c̱hebo' na' yec̱hopə beḻ ya'a. Pero bi de gon de'e quinga la' beṉə' zanṉə'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nach Jeso'osən' gože' neto': ―Ḻe'e gon mendad yesə'əbe' beṉə' ca'. Chi'ichgua yixye daquə' latɉən', nach gosə'əbe' beṉə' ca' laogüeinə'. Naquə ca do gueyə' mil beṉə' byo cui cuent no'olə na' cui cuent bidao'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nach gwxi' Jeso'osən' yetxtil ca'. Na' beyož be'e yeḻə' chox̱cwlen c̱he Diozən' beṉe' c̱he c̱he neto' disipl par be'eto' c̱he beṉə' ca' bazɉəchi'. Na' ḻeczə ca'atezəczə bene' len beḻ ya'a ca'. Be'eto' ḻega'aque' con catə'ətə' de'e gwse'enene'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Na' catə' beyož gwse'elɉene' nach gože' neto': ―Ḻe'e yetobə pedas ca' de'en bega'aṉ par nic̱h cui bi cuiayi'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nach botobəto' pedas ca' de'en besyə'əga'aṉ beyož gwsa'o beṉə' ca', na' goquən šižiṉ žomə lao gueyə' yetxtil de sebadən'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Na' beṉə' ca' catə' besə'əle'ine' miḻagr de'en ben Jeso'osən' nach gosə'əne': ―De'e ḻiczə bengan' profetən' ben' bagwlezcho seḻə' Diozən' yežlyo nga par gaquəlene' chio'o. ");
INSERT INTO zavNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Na' catə' gocbe'i Jeso'osən' de que gwse'enene' yesə'əc̱he'ex̱ax̱ɉene' par so'onene' rei c̱hega'aque'enə', nach bebi'iže'e gozeɉe' ya'ada'onə' toze'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Na' catə' bex̱ɉw že'enə' neto' disipl c̱he Jeso'osən' beyetɉto' cho'a nisda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Na' beyo'oto' to ḻo'o barcw par zɉəyedato' Capernaunṉə'. Bagoḻ, na' Jeso'osən' bitoṉə' yele'e gan' zɉəyedato'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Na' chas chatə' nisda'onə' la' to be' fuert chec̱hɉ. ");
INSERT INTO zavNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ca do c̱hopə legw babeza'ato' lao nisda'onə' catə' ble'ito' zeza' Jeso'osən' lao nisən' galən' zda barcon'. Na' bžebto'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nach gože' neto': ―Nada'anə'. Bito žeble. ");
INSERT INTO zavNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nach neto' chebeito' bego'oto'one' ḻo'o barcon'. Nach ḻe'e bežinteto' cho'a nisda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Na' beteyo beṉə' ca' besyə'əga'aṉ yešḻa'alə nisda'onə' bito besyə'əželene' Jeso'osən'. Gwsa'acbe'ine' caguə bi barcw gotə'əch sino yetoga de'en beyo'oto', na' gosə'əṉezene' bito beyo'o Jeso'osən' ḻo'o barcon' gan' beyo'o neto'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nach besə'əžin to c̱hopə barcw ca' de'en za'ac syoda de'en nzi' Tiberias, besə'əžinən gaḻə'əzə gan' əgwsa'ogüe' catə'ən gwde be' X̱ancho Jeso'osən' yeḻə' chox̱cwlen c̱he Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Na' catə' besə'əle'i beṉə' ca' caguə no Jeso'osən' nḻa'anə', na' ni neto' disipl c̱he', nach besyə'əyo'e ḻo'o barcw dao' ca' na' ɉa'aque' Capernaunṉə' chesyə'əyilɉe'ene'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Na' catə' besyə'əželene' Jeso'osən' yešḻa'alə nisda'onə' na' gwse'ene': ―Maestr, ¿batə'əquə' bela'o ngan'? ");
INSERT INTO zavNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Na' Jeso'osən' gože' ḻega'aque': ―De'e ḻi chnia' le'e, cheyilɉle nada' caguə por ni c̱he bagwyeɉni'ile bi zeɉen miḻagr ca' bable'ile bena', sino por ni c̱he de'en gwdaole na' belɉele. ");
INSERT INTO zavNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Bito cue'e yic̱hɉle gonḻe par nic̱h gatə' de'e ye'eɉ gaole de'en chde c̱hei, sino ḻecue'e yic̱hɉ ḻe'e gon par nic̱h gaquə ye'eɉ gaole de'en goṉ le'e yeḻə' mban zeɉḻicaṉe. Diozən' bseḻe'e nada' golɉa' beṉac̱h na' nada' goṉa' de'en ye'eɉ gaole par nic̱h əbanḻe zeɉḻicaṉe. Na' Diozən' babene' par nic̱h ṉezele bseḻe'e nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Na' gwse'ene': ―¿Bi cheyaḻə' gonto' par nic̱h yebei Diozən' neto'? ");
INSERT INTO zavNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Na' gož Jeso'osən' ḻega'aque': ―De'e nga gonḻe par nic̱h yebei Diozən' le'e, gonḻilažə'əle nada' ben' əbseḻe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nach gwse'ene': ―¿Bi miḻagr gono' par nic̱h gonḻilažə'əto' le'? ¿Bi gono' le'ito' ža? ");
INSERT INTO zavNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","De'e x̱axta'ocho ca' gwsa'ogüe' mana latɉə dašən', can' nyoɉ Xtižə' Diozən' nan: “Yeḻə' guao de'e za' yoban' be'e ḻega'aque' gwsa'ogüe'.” ");
INSERT INTO zavNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Nach Jeso'osən' gože' ḻega'aque': ―De'e ḻi əchnia' le'e, caguə de'e Moisezən' bnežɉue' ḻega'aque' yeḻə' guao de'en za' yoban', sino X̱a' Dioz na'anə'. Na' X̱a'anə' babseḻe'e par le'e to yeḻə' guao de'e zaquə'əche na' de'e ḻi za'an yoban'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Na' yeḻə' guao de'en babseḻə' X̱a' Diozən', za'an yoban' na' betɉən yežlyon' na' chnežɉon yeḻə' mban zeɉḻicaṉe c̱he notə'ətezə beṉə' chao ḻen. ");
INSERT INTO zavNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nach gwse'ene': ―Señor, beṉšga neto' yeḻə' guaon' nao' ca' yedote. ");
INSERT INTO zavNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Na' Jeso'osən' gože' ḻega'aque': ―Nada' naca' yeḻə' guao de'en chnežɉon beṉə' yeḻə' mban zeɉḻicaṉe. Notə'ətezə beṉə' chse'eɉḻe' c̱hia' yesyə'əbei la'ažda'oga'aque'enə' zeɉḻicaṉe, na' de'en chso'onḻilaže'e nada', ṉite'e mbalaz zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Na' bagwniacza' le'e, ḻa'aṉə'əczə bable'ile nada' naca' yeḻə' guaonə', bitoczə chonḻilažə'əle nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yoguə' beṉə' ca' chbeɉ Diozən' par əsa'aque' nada' txen, chžin ža catə' chso'onḻilaže'e nada'. Na' notə'ətezə beṉə' ca' chso'onḻilažə' nada', chebeida' chsa'aque' nada' txen. ");
INSERT INTO zavNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nada' za'a yoban' na' betɉa' yežlyon' caguə par nic̱h gona' de'e bia'azəlaža'anə', sino par nic̱h gona' can' chene'e X̱a'anə' ben' əbseḻə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na' de'e ngan' de'en chene'e X̱a'anə' ben' əbseḻə' nada', de que yoguə'əḻoḻ beṉə' bagwleɉe' par əsa'aque' nada' txen, ni toe' cui gua'a latɉə cuiayi'e sino que yosbanga'aca'ane' ladɉo beṉə' guat ca' šə bagwsa'ate' catə' əžin ža šo'o fin c̱he yežlyon'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","X̱a'anə' chene'ene' de que yoguə'əḻoḻ beṉə' se'eɉni'ine' non' naca' nada' na' so'onḻilaže'e nada', par nic̱h əgwnežɉue' ḻega'aque' yeḻə' mban zeɉḻicaṉe, na' nada' yosbanga'aca'ane' ladɉo beṉə' guat ca' šə bagwsa'ate' catə'ən əžin ža šo'o fin c̱he yežlyon'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Na' beṉə' blao c̱he ṉasyon Izrael c̱heton' besə'əže'eše'e c̱he Jeso'osən' de'en gwne': “Nada' naca' yeḻə' guao de'en za' yoban'.” ");
INSERT INTO zavNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Na' gosə'əne': ―¿Ecaguə bengan' Jeso'os xi'iṉ Jwse ben' nombia'acho na' ḻeczə ca' xne'enə'? ¿Bixc̱hexa nga nalize' de que ze'e yoban' betɉe' yežlyon'? ");
INSERT INTO zavNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nach Jeso'osən' gože' ḻega'aque': ―Bito že'ešə'əle c̱hia' entr le'e. ");
INSERT INTO zavNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ni to cono no gonḻilažə' nada' šə X̱a'anə' ben' əbseḻə' nada' cui gone' ca se'eɉḻe'e c̱hia'. Na' beṉə' ca' chse'eɉḻe'e c̱hia' yosbanga'aca'ane' ladɉo beṉə' guat ca' šə bagwsa'ate' catə' əžin ža šo'o fin c̱he yežlyon'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Gan' nyoɉ de'e ca' boso'ozoɉ de'e profet ca' beṉə' ca' gwso'e xtižə' Diozən' cana' nan: “Na' yoguə'əḻoḻe' əgwsed əgwlo'i Diozən'.” Nachən' yoguə'əḻoḻ non' ṉeze can' na X̱a'anə' na' choso'ozenag c̱he', yoguə' beṉə' can' chso'onḻilaže'e nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Bito ṉacho zo nochlə beṉə' bable'ine' X̱a'anə' sino toza' nada', la' nadan' za'a gan' zo X̱a' Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","De'e ḻi chnia' le'e, beṉə' ca' chso'onḻilažə' nada' de yeḻə' mban zeɉḻicaṉe c̱hega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nada' naca' yeḻə' guao de'en chnežɉon beṉə' yeḻə' mban zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","X̱axta'ocho ca' gwsa'ogüe' manan' latɉə dašən', pero bia'aczə gwsa'ate'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nadan' cho'a dižə' de que naca' yeḻə' guao de'en za' yoban' de'en chnežɉon yeḻə' mban zeɉḻicaṉe c̱he beṉə' ca' chsa'ogüe'en par nic̱h ca' cuich zɉənaque' len yic̱hɉla'ažda'oga'aque'enə' ca beṉə' guat. ");
INSERT INTO zavNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nadan' naca' yeḻə' guao de'en za' yoban'. Nsa'a yeḻə' mban zeɉḻicaṉenə' na' chac chnežɉua'an beṉac̱hən'. De'e na'anə' beṉə' ca' sa'o yeḻə' guao nga yesə'əbane' zeɉḻicaṉe. Na' yeḻə' guao de'e əgwnežɉua' əsa'ogüe' naquən cuerp c̱hia'anə', na' əgwnežɉua'an par nic̱h notə'ətezə beṉac̱h guaquə yesə'əzi'e yeḻə' mban zeɉḻicaṉenə'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nach gwche' bžaš entr beṉə' blao c̱he ṉasyon Izrael c̱heton' gosə'əne': ―¿Nacxa gone'en goṉ cuerp c̱he'enə' gaocho? ");
INSERT INTO zavNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Na' Jeso'osən' gože' ḻega'aque': ―De'e ḻi chnia' le'e, Diozən' bseḻe'e nada' golɉa' beṉac̱h, na' šə cuiṉə' gaole cuerp c̱hia'anə' na' šə cuiṉə' ye'eɉle xc̱hena'anə', bito de yeḻə' mban c̱hele zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Beṉə' ca' chsa'o cuerp c̱hia'anə' na' chse'eɉe' xc̱hena'anə' de yeḻə' mban zeɉḻicaṉe c̱hega'aque', na' šə bagwsa'ate' catə' əžin ža šo'o fin c̱he yežlyon', yosbanga'aca'ane' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Na' cuerp c̱hia'anə' naquən yeḻə' guao de'e ḻe'ezelaogüe de'e zaque'e, na' xc̱hena'anə' de'en chse'eɉe'enə' naquən ḻe'ezelaogüe de'e zaque'e. ");
INSERT INTO zavNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Na' beṉə' ca' chsa'o cuerp c̱hia'anə' na' chse'eɉe' xc̱hena'anə' nitə'ətezə nite'e len nada' na' nada' zotezə zoa' len ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","X̱a'anə' ben' zo zeɉḻicaṉe ḻe'enə' bseḻe'e nada', na' zoa' c̱hedə' ḻe' chone' ca zoa', na' ca'atezəczən' ben' gao cuerp c̱hia'anə' soe' c̱hedə' gona' ca soe'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Cuerp c̱hia'anə' naquən yeḻə' guao de'en za' yoban'. Na' yeḻə' guao nga bito naquən ca manan' de'en gwsa'o x̱axta'ocho ca' na' bia'aczə gwsa'ate'. Beṉə' ca' chsa'ogüe' yeḻə' guao nga nia' ca' ṉite'e zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","De'e quinga əbsed əblo'i Jeso'osən' ḻo'o yo'odao' Capernaunṉə'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Na' beṉə' zan beṉə' ca' zɉəsə'ənao Jeso'osən' catə' gwse'enene' can' gože' ḻega'aque' nach gosə'əne': ―Zi'ichgua naquə dižə' quinga. ¿Noxaczə šeɉḻe'e c̱he'? ");
INSERT INTO zavNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Na' gocbe'i Jeso'osən' de que chəsə'əže'eše'e por ni c̱he de'en gože' ḻega'aque', na' gozne': ―¿Epor ni c̱he de'en gwnia' can' chene'ele yebiguə'əle gosxanḻə? ");
INSERT INTO zavNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Naquəchxa gonḻen' šə le'ile nada' yeyepa' gan' gwzoa' antslə? nadan' bseḻə' Diozən' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Caguə por ni c̱he de'en golɉle beṉac̱h de yeḻə' mban zeɉḻicaṉe c̱hele sino šə yo'o Spirit c̱he Diozən' ḻo'o yic̱hɉla'ažda'olen' de yeḻə' mban zeɉḻicaṉe c̱hele. Dižə' de'en babi'a len le'e zaquə'ən par yic̱hɉla'ažda'olen' na' əbanḻe zeɉḻicaṉe šə šeɉḻe'ele c̱hei. ");
INSERT INTO zavNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ṉe'e nitə' baḻle cui chonḻilažə'əle nada'. Jeso'osən' gwne' ca' c̱hedə' dezd gwzolao zɉəsə'ənao beṉə' ḻe' ṉezene' noquə' beṉə' ca' cui gwso'onḻilaže'ene' na' non' əgwde ḻe' lao na' beṉə' ca' chəsə'əgue'i ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Na' gože' ḻega'aque': ―Chac can' gwnia'anə' de que notono no chac gonḻilažə' nada' šə X̱a'anə' ben' əbseḻə' nada' cui chone' par nic̱h gonḻilaže'e nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nach besyə'əbi'ižə' beṉə' zan beṉə' bagosə'ədalene' Jeso'osən', bitoch gosə'ənaogüe'ene'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Na' Jeso'osən' gože' šižiṉte neto': ―¿Elen le'e chene'ele žɉəya'acle? ");
INSERT INTO zavNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Na' gož Simon Bedən' ḻe': ―X̱anto', notono nochlə de no zaquə' əgwzenagto' c̱hei. Ṉezeto' de que le' choṉo' yeḻə' mban zeɉḻicaṉe c̱he notə'ətezə neto' chzenagto' xtižo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Neto' bacheɉḻe'eto' na' baṉezeto' de que len' naco' Cristən' ben' bagwleɉ Diozən' par gaquəlene' ṉasyon c̱hechon'. Naco' Xi'iṉ Dioz ben' zo zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Na' Jeso'osən' gože' neto': ―Nada' gwleɉa' le'e šižiṉle na' ṉezda' de que tole chzenagle c̱he gwxiye'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Gwne' ca' c̱he Jod Iscariotən' xi'iṉ Simonṉə' la' Jod nan' əgwdi'ene' lao na' beṉə' ca' chəsə'əgue'i ḻe', len nacte' txen neto' šižiṉto'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Catə' bagwde de'e ca' Jeso'osən' gwdacze' chsed chlo'ine' beṉə' ca' ža' distrit c̱he Galilean'. Bito gone'ene' yeyeɉe' Jodean' par soe' na' c̱hedə' beṉə' blao c̱he ṉasyon Izrael c̱heton' chəsə'əyilɉlaže'e naclən' so'one' par so'ote'ene'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Na' bazon gaḻə'əzə lṉi c̱he neto' beṉə' Izrael de'en nzi' “lṉi c̱he yo'o de ḻaguə'”. ");
INSERT INTO zavNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Na' beṉə' bišə' Jeso'osən' gwse'ene': ―Bito yega'aṉo' nga, sino gwyeɉ Jodean' par nic̱h disipl c̱hio' ca' ša' na' yesə'əle'ine' de'e ca' chono'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ni to beṉə' cui chone' bgašə'əzə to de'e chone' šə chene'ene' gombia' beṉə' ḻe'. Šə de'e ḻi chono' miḻagr, ben par nic̱h yesə'əṉeze yoguə'əḻoḻ beṉə' can' chono'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Beṉə' biše'e ca' gosə'əṉe' ca' c̱hedə' ni ḻega'aque' cui gwso'onḻilaže'e ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nach gož Jeso'osən' ḻega'aque': ―Bitoṉə' žin ža par gwlo'a non' naca', pero ca naquə le'e ža, guaquə žɉa'acle lṉin' batə'ətezən'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Beṉə' ca' cui zɉənombia' Diozən' bito chəsə'əgue'ine' le'e, pero chəsə'əgue'ine' nada', c̱hedə' chzeɉni'iga'acda'ane' de que chso'one' de'e malən'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ḻe'e žɉa'ac lṉinə'. Nada' bito sa'a ṉa'a c̱hedə' bitoṉə' žin ža c̱hia'anə' par sa'a lṉin'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Na' beyož gože' ḻega'aque' ca' bega'aṉe' Galilean' yeto c̱hopə ža. ");
INSERT INTO zavNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nach gwde gwsa'ac beṉə' biše'e ca' əzɉa'aque' lṉinə' ḻeczə gwza' ḻe' zde' lṉinə', pero caguə zaquə'əlao sino bgašə'əzə. ");
INSERT INTO zavNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Na' beṉə' blao c̱he ṉasyon Izrael c̱heto'onə' besyə'əyilɉe' ḻe' lao lṉinə' na' gosə'əne': ―¿Ganxa be'ena'anə'? ");
INSERT INTO zavNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Na' beṉə' ca' zɉənžag lao lṉinə' zane' gwso'e dižə' c̱he Jeso'osən' len lɉuežɉga'aque'. Na' caguə tozə can' gosə'əne' c̱he'. Baḻe' gosə'əne': ―Naque' beṉə' güenṉə'. Na' yebaḻe' gosə'əne': ―Abi, chonḻeizene' beṉə'ənə'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero ni toe' cui gwso'e dižə' c̱he' zaquə'əlao c̱hedə' besə'əžebe' beṉə' blao c̱he ṉasyon c̱heto'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na' do gašɉə zda lṉinə' catə' gwyo'o Jeso'osən' ḻo'o yo'odao' əblao c̱he neto' beṉə' Izrael na' gwzolao chsed chlo'ine'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Na' chəsyə'əbane beṉə' blao ca', chəsə'əne': ―¿Bixa cheɉni'i bengan' len caguə babsede' can' nsed chio'onə'? ");
INSERT INTO zavNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nach Jeso'osən' gože' ḻega'aque': ―De'en chlo'ida'anə' caguə de'e chalɉəlaža'anə', sino ben' əbseḻə' nada' blo'ine'en nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Notə'ətezə beṉə' chene'ene' gone' can' chene'e Diozən', ḻe' əṉezene' šə de'en chlo'ida'anə' naquən c̱he Diozən' o šə naquən de'e bia'azəlaža'a. ");
INSERT INTO zavNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Beṉə' ca' chso'e dižə' de'e bia'azəlažə'əga'aque' chəsyə'əyilɉe' no so'e ḻega'aque' yeḻə' bala'aṉ. Caguə ca' nada' c̱hedə' cheyilɉa' naclə gona' par nic̱h Diozən' ben' bseḻə' nada' si'e yeḻə' bala'aṉ. De'e na'anə' guaquə gaple confyans de que nada' cho'a dižə' ḻi, na' bito chx̱oayaga' beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Le'e cho'ela'ole de'e Moisezən' ben' bzoɉ ḻei c̱he Diozən', len ni tole cui chonḻe can' nanṉə'. ¿Bixc̱hen' chyilɉlažə'əle naclən' gonḻe par gotle nada'? ");
INSERT INTO zavNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Na' beṉə' ca' zɉənžaguən' gwse'ene': ―Chac tonto'. ¿No chyilɉlažə' naclə gone' par gote' le'? ");
INSERT INTO zavNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jeso'osən' gože' ḻega'aque': ―Tozə miḻagr de'en babena' ža dezcanzən' na' de'e na'anə' yoguə'əle chebanele. ");
INSERT INTO zavNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","De'e Moisezən' bzoɉe' de que cheyaḻə' socho señy de'en ne' sirconsision. Pero caguə gwzolaon len ḻe' sino len de'e x̱axta'ocho ca' beṉə' ca' gwnitə' antslə ca ḻe'. Na' le'e chzole bi'i byo dao' ca' señy de'en ne' sirconsision ža dezcanzən'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ṉa'a ža, šə chaquele chonən byen gwzole no bidao' señy de'en ne' sirconsision ža dezcanzən' par gonḻe complir can' na ḻei de'en bzoɉ de'e Moisezən', ¿bixc̱hen' chža'ale nada' de'en beyona' to beṉə' ža dezcanzən' len yoguə'əḻoḻ de'en chac c̱he'? ");
INSERT INTO zavNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Bito con gonḻe xbab de que to de'e chle'ile chon beṉə' naquən de'e mal, sino ḻe'e co'o rson nic̱h əṉezele šə de'e ḻi chone' de'e mal o šə chone' de'e güen. ");
INSERT INTO zavNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nach to c̱hopə beṉə' Jerosalen ca' gosə'əne': ―¿Ecaguə bengan' chəsyə'əyilɉe' par nic̱h so'ote'ene'? ");
INSERT INTO zavNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ḻe'e ggüiašc can' cho'e dižə' nga zaquə'əlao na' bitobi chse'ene'. De repentlɉa beṉə' gwnabia' ca' bac̱h chso'one' xbab de que naquəcze' Cristən' ben' gwleɉ Diozən' par gaquəlene' ṉasyon c̱hechon'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero na' ṉezecho ga beṉə' be'enga, mas catə' yidə Cristən' ni to cono əṉeze ga be'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ṉe'e chsed chlo'i Jeso'osən' ḻo'o yo'odao' əblao c̱he neto' beṉə' Izrael catə'ən gosə'əne' ca'. Nach gwṉe' zižɉo gože' ḻega'aque': ―Nada' nombi'ale na' ṉezele ga beṉə' nada'. Na' caguə con za'a de'e bia'azəlaža'anə'. De'e ḻi zo ben' əbseḻə' nada' ḻa'aṉə'əczə le'e bito nombi'alene'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nada' nombia'ane' c̱hedə' gan' zoe' nan' gwza'a na' ḻen' bseḻe'e nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nach chəsə'əyilɉlaže'e naclən' so'one' par yesə'əzene' Jeso'osən', pero notono no gwzen ḻe' c̱hedə' bitoṉə' əžin ža par gaque' lao na'aga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Na' beṉə' zan gwso'onḻilaže'e Jeso'osən' na' gosə'əne': ―Catə'ən yidə Cristən' bitolɉa gone' miḻagr zanch can' chon benga. ");
INSERT INTO zavNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Na' beṉə' fariseo ca' gwse'enene' beṉə' zan chso'e dižə' c̱he Jeso'osən'. Nach boso'oxi'e len bx̱oz əblao c̱he ṉasyon Izrael c̱heton' boso'oseḻe'e x̱a'ag yo'odao' c̱heto' ca' par žɉəsə'əxene' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Na' Jeso'osən' chsed chlo'ichene' gwne': ―Gwzocha' yeto tyemp dao' len le'e nach yeya'a gan' zo ben' əbseḻə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yeyilɉle nada' na' cabi yeželele nada', la' gan' soa' nada', le'e bito gaquə yidle. ");
INSERT INTO zavNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nach beṉə' blao c̱he ṉasyon Izrael c̱heton' gosə'əne' entr ḻega'aque': ―¿Ga yeyeɉ bengan' cui yeželechone'? ¿Ešə šeɉlene' beṉə' gwlaž c̱hecho ca' zɉənaselas entr beṉə' griego ca' na' žɉəsedene' beṉə' griego ca'? ");
INSERT INTO zavNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Bi zeɉe dižə' de'e nga gwna benga? Gwne': “Yeyilɉle nada' na' cui yeželele nada'.” Na' ḻeczə gwne': “Ga'an soa' nada', le'e bito gaquə yidle.” ");
INSERT INTO zavNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Na' ža ḻe'ezelaogüe na' ža xen c̱he lṉinə' gwzecha Jeso'osən' gan' chsed chlo'ine' na' gwne' zižɉo: ―Notə'ətezle šə de'e tant chene'ele gatə' yeḻə' mban zeɉḻicaṉe c̱hele xte banacle ca to beṉə' chbillaže'e, ḻegonḻilažə' nada' na' goṉa' yeḻə' mban zeɉḻicaṉe c̱hele. ");
INSERT INTO zavNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Le'e chonḻilažə'əle nada', so de'en ṉabia' yic̱hɉla'ažda'olen' can' na Xtižə' Diozən' de'en nyoɉən, gonən par nic̱h gaquəlenḻe yeziquə'əchlə beṉə' par yesə'əzi'e yeḻə' mban zeɉḻicaṉe. De'e na'anə' saquə'əlebele ca yao ca' de'en chso'onən par nic̱h yežlyon' de tcho'alaoga'aquən chosc̱ha'on bitə'ətezə. ");
INSERT INTO zavNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jeso'osən' gwne' ca' c̱hedə' gwṉezene' Spirit c̱he Diozən' yedəson ḻo'o yic̱hɉla'aždao' chio'o chonḻilažə'əcho ḻe' par nic̱h gaquəlencho beṉə' yesə'əzi'e yeḻə' mban zeɉḻicaṉe. Na' ca naquə Spiritən' bitoṉə' yedəson ḻo'o yic̱hɉla'aždao' beṉə' ca orən', c̱hedə' beṉə' ca' chəsə'əgue'i Jeso'osən' bitoṉə' so'ote'ene', na' bitoṉə' güe' Diozən' ḻe' yeḻə' bala'aṉ xen. ");
INSERT INTO zavNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Beṉə' ca' ža'anə' gwse'enene' chsed chlo'i Jeso'osən' na' baḻe' gosə'əne': ―De'e ḻiczə bengan' profetən' ben' naquən yidə. ");
INSERT INTO zavNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Na' yebaḻe' gosə'əne': ―Bengan' Cristən' ben' gwleɉ Diozən' par gaquəlene' ṉasyon c̱hechon'. Pero baḻe' gosə'əne': ―¿Ena' ṉacho de que Galilea na' əchoɉ Cristən'? ");
INSERT INTO zavNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Ecaguə na Xtižə' Diozən' de'en nyoɉən de que Cristən' galɉe' lao dia c̱he de'e Rei Dabin' na' de que galɉe' yež Belen laž de'e rein'? ");
INSERT INTO zavNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Na' gotə' bžaš entr beṉə' ca' ža'anə' na' gwsa'aque' c̱hoplə por ni c̱he Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Baḻe' gwsa'aquene' cheyaḻə' yesə'əzene'ene', pero bito gwso'one' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Na' x̱a'ag yo'odao' c̱he neto' beṉə' Izrael besyə'əžine' lao beṉə' ca' boso'oseḻə' ḻega'aque'. Na' bx̱oz əblao c̱he ṉasyon c̱heton' na' beṉə' fariseo ca' gwse'e ḻega'aque': ―¿Bixc̱hen' cui əgwc̱he'elene'? ");
INSERT INTO zavNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Na' x̱a'ag yo'odao' ca' gwse'e ḻega'aque': ―Xte ža ṉeža ni tozə beṉə' cuiṉə' ṉe' güen ca güenṉə' chṉe bengan'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nach beṉə' fariseo ca' gwse'e ḻega'aque': ―¿Elente le'e bagwxoayagle? ");
INSERT INTO zavNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ni tozə neto' naquəto' beṉə' blao na' naquəto' beṉə' fariseo cuiṉə' šeɉḻe'eto' c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pero beṉə' zan quinga ža' nga bito zɉənombi'e ḻei de'en bzoɉ de'e Moisezən', na' bazɉəmbi'ayi'e. ");
INSERT INTO zavNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Na' Nicodemon', ben' gwyeɉ lao Jeso'osən' še'elə, lene' beṉə' blao ca'. Na' Nicodemon' gože' ḻega'aque': ");
INSERT INTO zavNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Ḻei c̱hechon' bito cho'en latɉə c̱hoglaochon c̱he to beṉə' de que malən' bene' sin cui güe'e dižə' nac goquə na' sin cui əžaš əche'enə bixa bene'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nach gwse' beṉə' ca' ḻe': ―¿Ena' ṉacho leno' len' naco' beṉə' Galilea? Bsed na' əṉezdo' de que ni to profet cuiṉə' əchoɉ Galilean'. ");
INSERT INTO zavNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Na' besa'aque' ɉəya'aque' ližga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Nach Jeso'osən' gwyeɉe' ya'a de'en ne' Ya'a Olibos. ");
INSERT INTO zavNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Na' beteyo catə' gwye'eni' gwyeɉe' de'e yoblə yo'odao' əblao c̱he neto' beṉə' Izrael. Na' yoguə' beṉə' ca' ža' na' gosə'əbigue'e laogüe'enə' na' Jeso'osən' gwchi'e na' gwzolaogüe' chsed chlo'ine' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nach beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' na' len beṉə' fariseo ca' bedəsə'əgüe'e to no'olə beṉə' besyə'ədoḻe'ene' len xtoe'. Na' boso'ozeche'ene' gwchoḻ beṉə' ca' lao Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Na' gwse'e Jeso'osən': ―Maestr, no'ol nga babedoḻə'əto'one' mer delene' to xtoe'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na' ḻei de'en bzoɉ de'e Moisezən' chonən mendad gotcho no'ol ca' chso'on ca' əgwšižə'əga'acchone' yeɉ. ¿Bixa ənao' le'? ¿bi cheyaḻə' gonechone'? ");
INSERT INTO zavNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Gwse'e Jeso'osən' ca' c̱hedə' gwse'enene' yesə'əbeɉe'ene' dižə' de'e yesə'əc̱hine' contr le'. Nach Jeso'osən' con bcheque'e na' bzoɉe' lao yon' len xbene'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Na' gwnitə'əc̱hec̱he' chəsə'əṉabene' ḻe' nacxa əṉe'enə'. Nach gwche'eša'ogüe'e na' gože' ḻega'aque': ―Guaquə con to le'e beṉə' cui de xtoḻe'e solaole əgwšižə'əle no'olə nga yeɉən'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nach bcheque'e de'e yoblə bzoɉe' lao yon'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Na' beṉə' blao ca' beṉə' ca' chəsə'əcuiš no'olən' catə' gwse'enene' de'en gož Jeso'osən' ḻega'aque', gosə'əṉezene' ḻo'o yic̱hɉla'ažda'oga'aque'enə' de que yogue'e de xtoḻə'əga'aque'. Nach gwzolao besyə'əchoɉ tgüeɉə tgüeɉe', gwzolaotec besyə'əchoɉ beṉə' ca' zɉəngoləch nach beṉə' ca' yeḻa' xte bega'aṉ yetozə Jeso'osən' len no'olən' ladɉo beṉə' ca' choso'ozenag c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Na' catə' bebe'ešao' Jeso'osən' caguə no beṉə' ca' ble'ichene' laogüe'enə' sino yetozə no'olən'. Na' gože'ene': ―No'olə, ¿gaṉ beṉə' ca' choso'ocuiš ḻe'? ¿Eni toe' cui beṉ le' castigw? ");
INSERT INTO zavNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nach no'olən' gože'ene': ―Ni toe' Señor. Nach Jeso'osən' gože'ene': ―Ni nada' bito goṉa' le' castigw. Beyeɉ na' cuich gono' de'e malən'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Na' Jeso'osən' gozoe' dižə'ən yetši'i len beṉə' ca' ža'anə', gože' ḻega'aque': ―Nada' nsa'a be'eni' par yic̱hɉla'aždao' beṉac̱hən'. Beṉə' ca' chso'onḻilaže'e nada' na' choso'ozenague' c̱hia' bitoch chso'ontezə chso'one' de'e malən'. Yo'o be'eni'in ḻo'o yic̱hɉla'ažda'oga'aque'enə' c̱hedə' zɉənape' yeḻə' mban zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nach beṉə' fariseo ca' gwse'ene': ―Le'etezə cho'o dižə' c̱he cuino', na' bito naquən de'e se'eɉḻe' beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Na' gož Jeso'osən' ḻega'aque': ―Ḻa'aṉə'əczə cho'a dižə' c̱he cuina', xtiža'anə' naquən de'e ḻi. Nada' ṉezda' gan' gwza'a na' gan' yeya'a, pero le'e bito ṉezele gan' gwza'a na' gan' yeya'a. ");
INSERT INTO zavNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Le'e con to chosbaguə'əle nada' de que napa' doḻə' por ni c̱he bi de'en chle'ile chona'. Nada' bito za'a par c̱hoglaogua'an c̱he beṉə' de que zɉənape' doḻə'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pero na' šə catə' c̱hoglaogua'an c̱he notə'ətezə beṉə' de que zɉənape' doḻə', zaquə'əczə can' əṉia'anə' c̱hedə' bito c̱hoglaogua'an c̱he beṉə' to gwlazza' sino con can' na X̱a'anə' ben' bseḻə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ḻei c̱hechon' de'en bzoɉ de'e Moisezən' nyoɉən nan de que dižə' de'en əso'e c̱hopə testigw cheyaḻə' šeɉḻe'echo de que naquən de'e ḻi šə tozə can' yesə'əne'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nada' cho'a dižə' c̱he cuina' na' X̱a'anə' ḻeczə cho'e dižə' c̱hia', na' ḻe'enə' bseḻe'e nada'. Neto' naquəto' testigw ca' c̱hopə. ");
INSERT INTO zavNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Na' gwse'ene': ―¿Gaxa zo x̱a'onə'? Na' gwna Jeso'osən': ―Ni nada' ni X̱a'anə' cui nombi'ale. Žalə' nombi'ale nada' ḻeczə nombi'ale X̱a'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Dižə' ca' be' Jeso'osən' bsed blo'ine' gan' chəsə'əgüe'e mech ḻo'o yo'odao' əblao c̱he neto' beṉə' Izrael. Na' ni to cono gwxen ḻe' c̱hedə' cuiṉə' žin ža par gaque' lao na' beṉə' ca' chəsə'əgue'i ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Na' gož Jeso'osən' ḻega'aque' yetši'i: ―Nada' yeya'a, na' le'e yeyilɉle nada', pero gan' yeya'anə' le'e cabi gaquə da'acle, c̱hedə' le'e gatle catə' cuiṉə' yediṉɉele xtoḻə'əle ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Na' beṉə' blao c̱he ṉasyon Izrael c̱heto'on gosə'əne': ―¿Eyeyot cuine'enə' ža, de'en ne' gan' yeyeɉe' bito gaquə šeɉcho? ");
INSERT INTO zavNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Na' gože' ḻega'aque': ―Le'e chzenagle c̱he gwxiye'enə', na' nada' chzenaga' c̱he Diozən'. Le'e chonḻe can' chso'on yeziquə'əchlə beṉə' cui zɉənombia' Diozən', na' nada' bito chona' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","De'e na'anə' gwnia' le'e de que gatle catə' cuiṉə' yediṉɉele xtoḻə'əlen'. Šə cui cheɉḻe'ele de que nada' naca' doxen can' gwnia'anə', gatle sin cui yediṉɉele xtoḻə'əle ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Na' gwse'ene': ―¿No naco' le'enə'? Na' gož Jeso'osən' ḻega'aque': ―Nada' naca' ben' bagwnia' le'e bedote. ");
INSERT INTO zavNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ṉe'e dech de'e zan de'e əṉia' c̱hele gwzeɉni'ida' ca naquə xtoḻə'əle ca'. X̱a'anə' bseḻe'e nada' par cho'a dižə' len beṉac̱hən' de'en babenda' gwne'. Na' X̱a' na'anə' cho'e dižə' ḻi. ");
INSERT INTO zavNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jeso'osən' be'e dižə' c̱he X̱e' Diozən', na' ḻega'aque' bito gwse'eɉni'ine' šə c̱he Dioz nan' cho'e dižə'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Na' Jeso'osən' gože' ḻega'aque': ―Diozən' bseḻe'e nada' golɉa' beṉac̱h, na' te gotle nada' ḻe'e yag corozən' cana' əṉezele de que naca' ben' gwnia'anə'. Na' ḻeczə əṉezele de que cabi bi chona' de'e bia'azəlaža'a, sino con bin' babzeɉni'i X̱a'anə' nada', ḻenṉə' chnia'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","X̱a'anə' babseḻe'e nada' na' zocze' len nada'. Bito chbeɉyic̱hɉe' nada' c̱hedə' do tyempte chona' de'en chazlaže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Na' žlac choe' Jeso'osən' dižə' quinga beṉə' zan gwso'onḻilaže'e ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Na' Jeso'osən' gože' baḻə beṉə' gwlaž c̱heto' ca' bachse'eɉḻe'e c̱he': ―Šə sotezə sole gonḻe de'e chnia' le'e gwlo'en de que de'e ḻiczə banacle disipl c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Na' šə sotezə sole gonḻe de'en chnia' le'e, nach əṉezele bi zeɉe dižə' ḻi c̱hia'anə', na' šə baṉezele bi zeɉen, bitoch gacle ca esclabos. ");
INSERT INTO zavNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Na' gwse'ene': ―Dia c̱he de'e Abraanṉə' naquəto' na' xte ža ṉeža bitoṉə' gacto' ca esclabos. ¿Bixac̱hen' nao' le' de que bitoch gaquəto' ca esclabos? ");
INSERT INTO zavNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Na' gož Jeso'osən' ḻega'aque': ―De'e ḻi chnia' le'e, yoguə' beṉə' chso'on de'e malən' nite'e xni'a de'e malən' ca esclabos. ");
INSERT INTO zavNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Beṉə' naquə esclabo caguə do tyempte gaque' cuent len famiḻyən' gan' naque' esclabo, pero beṉə' golɉe' lao famiḻyən', do tyempte gaque' cuent len famiḻyən'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Na' šə nada' Xi'iṉ Diozən' gona' ca əchoɉle xni'a de'e malən' par nic̱h cuich gacle ca esclabos, de'e ḻiczə əchoɉlen'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ṉezda' de que nacle xi'iṉ dia c̱he de'e Abraanṉə' pero bia'aczə cheyilɉlažə'əle naclən' gonḻe par nic̱h gotle nada', na' chonḻe ca' c̱hedə' bito chone c̱hele xtiža'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nada' cho'a dižə' c̱he de'en bablo'i X̱a'anə' nada', na' le'e chonḻe can' na x̱alen'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Na' gwse' beṉə' ca' Jeso'osən': ―Neto' naquəto' xi'iṉ dia c̱he de'e Abraanṉə'. Na' gož Jeso'osən' ḻega'aque': ―Žalə' nacle doalɉe xi'iṉ dia c̱he de'e Abraanṉə gonḻe can' ben de'e Abraanṉə' žalə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Na' ḻa'aṉə'əczə babzeɉni'ida' le'e dižə' ḻi de'en babsed blo'i Diozən' nada', le'e chene'ele gotle nada'. De'e Abraanṉə' cabi bene' can' chonḻen'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Tozəczə can' chonḻe len x̱alenə'. Nach gwse'e ḻe': ―Tozə Diozən' naque' X̱ato' na' bito chzenagto' c̱he nochlə beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Na' Jeso'osən' gože' ḻega'aque': ―Žalə' Diozən' naquə x̱ale guaquele c̱hia', c̱hedə' nada' gwza'a gan' zo Diozən'. Caguə za'a de'e bia'azəlaža'anə'. Ḻen' əbseḻe'e nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Bixc̱hen' cui cheɉni'ile de'en chnia' le'e? Bito cheɉni'ile c̱hedə' la' bito chene'ele gwzenagle xtiža'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Gwxiye' nan' naquə x̱ale. Nachən' chebeile chonḻe can' chene'enṉə'. Ḻen naquən güet beṉə' dezd catə'ən gwxe yežlyon', na' cui chdalenən dižə' ḻi c̱he Diozən' c̱hedə' cui yo'o dižə' ḻin' ḻo'o yic̱hɉla'ažda'ogüe'enṉə'. Catə' chnen de'e güenḻažə' chnen con can' naquə cuinei c̱hedə' naquən güenḻažə' na' yoguə' dižə' güenḻažə' za'an c̱hei. ");
INSERT INTO zavNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Na' cabi cheɉḻe'ele c̱hia' nada', c̱hedə' nada' əchnia' le'e dižə' ḻi. ");
INSERT INTO zavNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ni tole cui gaquə əgwlo'ele de que babena' bi de'e malən'. Nada' cho'a dižə' ḻi, ¿bixc̱hen' cui cheɉḻe'ele c̱hia'? ");
INSERT INTO zavNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Beṉə' ca' zɉənaquə xi'iṉ Dioz choso'ozenague' c̱he xtiže'enə'. Na' ca naquə le'e cui nacle xi'iṉe', de'e na'anə' bito chzenagle c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Na' beṉə' blao c̱he ṉasyon Izrael c̱heton' gwse'ene': ―Ḻeiczeto' can' nato' de que le' naco' beṉə' Samaria na' de que chac tonto'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Na' gož Jeso'osən' ḻega'aque': ―Bito chac tonta'. Nada' əchnežɉua' yeḻə' bala'aṉ c̱he X̱a'anə' na' le'e chnitle yeḻə' bala'aṉ c̱hia'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nada' caguə chyilɉa' no goṉ nada' yeḻə' bala'aṉnə'. X̱a'anə' choṉe' nada' yeḻə' bala'aṉ, na' ḻen' əgwlo'e non' napə doḻə' na' non' cui napə doḻə'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","De'e ḻi chnia' le'e, notə'ətezə beṉə' choso'ozenag xtiža'anə', cuat ṉabia' yeḻə' gotən' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nach beṉə' blao c̱he ṉasyon Izrael c̱heton' gwse'ene': ―Ṉa'a babeyož gwṉezeto' de que chac tonto'onə'. De'e x̱axta'ocho Abraanṉə' gote' na' ḻeczə de'e profet ca' beṉə' ca' gwso'e xtižə' Diozən' cana'. Na' le' nao' de que beṉə' ca' choso'ozenag c̱hio' cuat ṉabia' yeḻə' gotən' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Ezaquə'əcho' le' ca de'e x̱axta'ocho Abraanṉə'? Ḻen' gote' na' ḻeczə ca' de'e profet ca'. ¿Noxan' chacdo' naco'? ");
INSERT INTO zavNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Na' gwna Jeso'osən': ―Žalə' nada' choe' cuina' yeḻə' bala'aṉ, cabi zaquə' yeḻə' bala'aṉnə'. Pero X̱a'anə' choṉe' nada' yeḻə' bala'aṉ, ben' nale naquə Dioz c̱helen'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Le'e bito nombia'alene', pero nada' nombi'ane'. Žalə' nia' cui nombia'ane' gaca' beṉə' güenḻažə' ca le'e. Nada' nombia'ane' ža, na' chzenaga' xtiže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","De'e x̱axta'ocho Abraanṉə' bebeine' gwyeɉḻe'e de que le'ine' tyemp ni zoa' yežlyo ni. Na' bable'ine'en ṉa'a na' zoe' mbalaz. ");
INSERT INTO zavNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Na' gwse' beṉə' blao c̱he ṉasyon Izrael c̱heton' ḻe': ―Ni šiyon iz cuiṉə' žino'. ¿Ena' ṉezle'ido' de'e Abraanṉə'? ");
INSERT INTO zavNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Na' gož Jeso'osən' ḻega'aque': ―De'e ḻi əchnia' le'e, ca ze'e galɉlə de'e Abraanṉə' bazocza' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nach gosə'əzi'e yeɉ par yoso'ošiže'ene'en. Na' Jeso'osən' bocuaše'e na' beze'e yo'odao' əblaonə'. Bito gwsa'acbe'ine' catə' bedie' gwchoḻga'aque'enə' zɉəyede'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Na' txen chdato' len Jeso'osən' catə' ble'ito' to beṉə' byo beṉə' golɉe' nc̱hoḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Na' gožto'one': ―Maestr, ¿no napə doḻə' de'en golɉə bengan' nc̱hoḻe'? ¿əḻe' o šə x̱axne'enə'? ");
INSERT INTO zavNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Na' Jeso'osən' gože' neto': ―Benga golɉe' nc̱hoḻe' caguə por ni c̱he xtoḻe'enə', na' caguə por ni c̱he xtoḻə' x̱axne'enə', sino par nic̱h la'alaon can' gon Diozən' len ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Cheyaḻə' goncho xšin Diozən' ben' bseḻə' nada' žlac ṉede latɉə. Gwžin catə' cuich gatə' latɉə gonchon. ");
INSERT INTO zavNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Žlac ṉezoa' yežlyo nga chgua'a be'eni' ḻo'o yic̱hɉla'aždao' beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Beyož gwne' ca' gwcho'oṉ x̱ene'en lao yon' na' bene' beṉɉw len xen' c̱he'enə'. Na' gwdebe' beṉɉon' ɉelao beṉə' lc̱hoḻən'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Na' gože'ene': ―Gwyeɉ ɉəyedib ɉelaogo'onə' cho'a tanc de'en nzi' Siloe―. Na' Siloe zeɉen dižə' Nseḻə'. Na' gwyeɉe' na' beyib ɉelaogüe' ca'. Na' beze'e ɉəyede' bachle'ine'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Na' beṉə' gwliž c̱he' ca' na' beṉə' ca' besə'əle'i ḻe' yoguə' las catə' ṉe'e nc̱hoḻe' gosə'əne': ―¿Ecaguə bengan' bable'icho bedote chi'e chṉabe' caridan'? ");
INSERT INTO zavNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Baḻe' gosə'əne': ―Bengan'. Na' baḻe' gosə'əne': ―Cabi naquə ḻe' sino ca naquə bengan' naque'. Na' ḻe' gwne': ―Nada'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Na' gwse'ene': ―¿Nacxa goquən' gwzolao chle'ido'? ");
INSERT INTO zavNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Na' gože' ḻega'aque': ―To beṉə' le Jeso'os bene' beṉɉw na' gwdebe'en ɉelaogua'anə' na' gože' nada': “Gwyeɉ cho'a tanc de'en nzi' Siloen' na' ɉəyedibən.” Na' gwya'a na' beyiba'an, na' gwzolao chle'ida'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nach gwse' beṉə' ca' ḻe': ―¿Ganxa be'enə'? Na' gože' ḻega'aque': ―Bito ṉezda'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Na' gosə'əc̱he'e ben' goquə beṉə' lc̱hoḻən' gan' nitə' beṉə' fariseo ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Na' naquə ža dezcanz catə'ən ben Jeso'osən' beṉɉon' de'en gwdebe' ɉelao be'enə' par ble'ine'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Na' beṉə' fariseo ca' ḻeczə gosə'əṉabene' ḻe' nac goquən' bachle'ine'. Na' ḻe' gože' ḻega'aque': ―Ben' beyone nada' gwdebe' beṉɉon' ɉelaogua'anə' na' beyiban' na' gwzolao chle'ida'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nach to c̱hopə beṉə' fariseo ca' gosə'əne': ―Ṉezecho bito zo Diozən' len benga c̱hedə' bito chomba'aṉe' ža dezcanzən'. Na' baḻe' gosə'əne': ―¿Nac gon to beṉə' güen de'e mal gone' miḻagr quinga? Na' gwsa'aque' c̱hoplə entr ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nach de'e yoblə gwse'e be'en golɉə nc̱hoḻən': ―¿Bi nao' le' c̱he ben' ben par nic̱h chle'ido'? Na' ḻe' gwne': ―Naque' to profet beṉə' bseḻə' Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Na' beṉə' blao c̱he ṉasyon Izrael c̱heton' bito gwse'eɉḻe'e c̱he ben' šə ḻen' golɉe' nc̱hoḻe' na' ṉa'a bachle'ine' xte que gwsa'axe' x̱axne'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Na' gosə'əṉabene' ḻega'aque' gwse'ene': ―¿Ebengan' xi'iṉlen' ben' nale golɉe' nc̱hoḻe'? ¿Nacxa goquən' chle'ine' ṉa'a? ");
INSERT INTO zavNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Na' gwse' x̱axne'e ca' ḻega'aque': ―Ṉezeto' de que bengan' xi'iṉto'onə', na' de que golɉe' nc̱hoḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mas nac chaquən' bachle'ine' bito ṉezeto', nic ṉezeto' noxa ben par nic̱h bachle'ine'. Ḻe' bazeɉəczene'. Ḻeṉabe ḻe', güe'ecze' dižə' naquən' goc c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","X̱axne'e ca' gosə'əne' ca' de'en besə'əžebe' beṉə' blao c̱he ṉasyon Izrael c̱heto'onə', c̱hedə' ḻega'aque' bac̱h zɉənone'en de que notə'ətezə beṉə' güe'e dižə' de que Jeso'osən' naque' Cristən' ben' gwleɉ Diozən' par gaquəlene' ṉasyon c̱heton', cabi əso'e latɉə šo'oche' ḻo'o yo'oda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","De'e na'anə' gosə'əna x̱axne'e ca': “Bazeɉəczene'. Ḻeṉabe ḻe'.” ");
INSERT INTO zavNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nach de'e yoblə gwsa'axe' ben' golɉə nc̱hoḻ gwse'ene': ―Be'elao' Diozən' na' gwzo'one' testigw de que clelən' babe'eleno' neto' dižə' bac̱he. Ṉeto' ṉezeto' de que Jeso'osən' naque' to beṉə' güen de'e mal. ");
INSERT INTO zavNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Na' gwne': ―Šə naque' beṉə' güen de'e mal, bito ṉezda'. De'en ṉezda', nada' goca' beṉə' lc̱hoḻ na' ṉa'a chle'ida'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Na' de'e yoblə gwse'ene': ―¿Bi benene' le'enə'? ¿Nac benen' par nic̱h bachle'ido'? ");
INSERT INTO zavNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Na' gože' ḻega'aque': ―Bagwnia' le'e na' cui chzenagle. ¿Bixc̱hen' chene'ele yenele de'e yoblə? ¿Elen le'e chene'ele gacle disipl c̱he'enə'? ");
INSERT INTO zavNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Na' gwsa'ade'ene' dižə' gwse'ene': ―Le' naco' disipl c̱he', pero neto' naquəto' disipl c̱he de'e Moisezən'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ṉezeto' de que Diozən' be'elene' de'e Moisezən' dižə' cho'a, pero benga bito ṉezeto' gan' ze'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Na' ben' golɉə nc̱hoḻən' gože' ḻega'aque': ―Nactequən' le'e cui ṉezele ga ze'enə', len babene' par nic̱h chle'ida'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Na' ṉezecho de que Diozən' cabi chzenague' c̱he beṉə' ca' chso'on de'e mal. Con beṉə' chso'ene' yeḻə' bala'aṉ na' chso'one' can' chene'ene'enə', ḻega'acze' chzenag Diozən' c̱hei. ");
INSERT INTO zavNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Dezd gwxe yežlyon' ni to conoṉə' yene de que bagwzo beṉə' chone' par nic̱h chle'i beṉə' golɉə nc̱hoḻ. ");
INSERT INTO zavNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Žalə' cui zo Diozən' len ḻe' caguə bi miḻagr gaquə gone'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Na' beṉə' blao ca' gwse'ene': ―Pendejw, len' golɉo' nc̱hoḻo' yeḻə' beṉə' mal c̱hio'onə', ¿əna le' əgwseddo' neto'onə'? Na' besyə'əbeɉe'ene' fuer. ");
INSERT INTO zavNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Gocbe'i Jeso'osən' de que babesyə'əbeɉe' be'enə' fuer, na' ɉəšague'ene' gože'ene': ―¿Echonḻilažo'o le' Xi'iṉ Diozən'? ");
INSERT INTO zavNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Na' gož ben' ḻe': ―¿Noxa'an ža? señor, par nic̱h gonḻilaža'ane'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Na' gož Jeso'osən' ḻe': ―Nada'anə' ben' bable'ido' antslə na' nada'anə' cho'elena' le' dižə'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nach be'enə' bzo xibe' be'elaogüe'e Jeso'osən', gwne': ―X̱ana', chonḻilaža'a le'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Na' gwnach Jeso'osən': ―Nada' za'a yežlyo nga par nic̱h la'alaon c̱he beṉac̱hən' non' zɉənapə doḻə' na' non' cui zɉənapə doḻə'. Za'a chgua'a be'eni' par beṉə' ca' chsa'acbe'ine' zɉənc̱hoḻ yic̱hɉla'ažda'oga'aque'enə', na' za'a par yeca'a be'eni' c̱he beṉə' ca' chsa'aquene' cui zɉənc̱hoḻ yic̱hɉla'ažda'oga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Na' baḻə beṉə' fariseo ca' nitə' gaḻə'əzə gwse'enene' de'e nga. Na' gwse'e Jeso'osən': ―¿Echacdo' len neto' nc̱hoḻ yic̱hɉla'ažda'oto'onə'? ");
INSERT INTO zavNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Na' gož Jeso'osən' ḻega'aque': ―Žalə' cui cheɉni'ile bito bi xtoḻə'əle de. Pero por ni c̱he de'en nale de que cheɉni'ile, de'e na'anə' deczə xtoḻə'əlen'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","De'e ḻi chnia' le'e, be'en cui cho'o cho'a puert xle'eɉ xilə' ca' na' ga yoblə chepe' par cho'e, beṉə' bguan be'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Be'en cho'o cho'a puertən', ḻe'enə' goye xilə'ənə'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Na' be'en chapə puert c̱he xle'eɉ xilə' ca' chsalɉue' par nic̱h cho'o beṉə' goyebən'. Na' xilə' ca' choso'ozenaguəb xtiže'enə' c̱hedə' zɉənombia'ab ḻe', na' chaxe'eb cho'e laga'aquəb catə' chbeɉe'eb. ");
INSERT INTO zavNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Na' catə' bagwleɉe' yoguə' bia c̱he' ca' ḻo'o xle'eɉga'aquəbən', chbialaogüe' laoga'aquəbən' na' chɉəsə'ənaob ḻe' c̱hedə' zɉənombi'ab ši'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Na' bito žɉəsə'ənaob beṉə' yoblə, sino yesə'əxoṉɉəb ḻe' c̱hedə' cui zɉənombi'ab ši'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jeso'osən' be'e jempl nga par bzeɉni'ine' beṉə' ca' ža'anə', pero bito gwse'eɉni'ine' bi zeɉen de'en gože' ḻega'aque' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nach gozṉe Jeso'osən' gože' ḻega'aque': ―De'e ḻi əchnia' le'e, nada' gwxaquə'əlebəda' ca cho'a puert c̱he xle'eɉ xilə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yoguə' beṉə' gox̱oayag ca' babla'ac antslə ca nada' chəsə'əne' de que Diozən' bseḻe'e ḻega'aque' pero gwxaquə'əlebəga'aquene' ca beṉə' bguan. Na' ca xilə' ca' cui choso'ozenaguəb xtižə' beṉə' cui zɉənombi'ab, ca'aczən' beṉə' ca' chso'onḻilažə' nada' cui choso'ozenague' c̱he beṉə' gox̱oayag ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nada' gwxaquə'əlebəda' ca cho'a puert c̱he xle'eɉ xilə' ca'. Xilə' ca' chəsyə'əyo'ob ḻo'o xle'eɉga'aquəb na' chəsə'əchoɉəb par chəsə'əyilɉəb de'e chsa'ob. Na' ca xle'eɉ xilə' ca' chcue'eɉən ḻega'aquəb par nic̱h cui bi gac c̱hega'aquəb, ca'aczən' chcue'eɉa' beṉə' ca' chso'onḻilažə' nada' par nic̱h cui bi gac c̱hega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Beṉə' gox̱oayag ca' gwxaquə'əlebəga'aquene' ca beṉə' bguan beṉə' ca' chda'ac ḻechguaḻe con to de'e yesə'əbane', na' so'ote', na' yesə'ənitlaogüe'. Nada' za'a par nic̱h chnežɉua' yeḻə' mban zeɉḻicaṉe c̱he beṉə' ca' chso'onḻilažə' nada' na' par nic̱h nite'e mbalaz juisy. ");
INSERT INTO zavNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nada' chgüia chya' beṉə' ca' chso'onḻilažə' nada' can' chon to beṉə' goye xilə' beṉə' chgüia chye' xilə' c̱he' ca' binḻo. Na' de'en chgüia chyega'aca'ane' chsanḻažə' cuina' so'ot beṉə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Baḻə beṉə' ca' choso'oye' xilə' chesə'əzi'e laxɉwga'aque', la' xilə' ca' bito zɉənaquəb bia c̱hega'aque'. De'e na'anə' chəsə'əbeɉyic̱hɉe'eb na' choso'oxoṉɉe' catə' chəsə'əle'ine' za' no becoyo'o, c̱hedə' bito zɉənaque' x̱an xilə' ca'. Chso'e latɉə chṉiz becoyo'onə' xilə' ca' na' choslasəb ḻega'aquəb. ");
INSERT INTO zavNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Chesə'əxoṉɉe' c̱hedə' bito zɉənži'ine' xilə' ca' de'en cui zɉənaquəb bia c̱hega'aque', con zɉənaque' goyeb. ");
INSERT INTO zavNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nada' chgüia chya' beṉə' ca' chso'onḻilažə' nada' ca to beṉə' goye xilə' beṉə' chgüia chye' xilə' c̱he' ca' binḻo. Na' nombi'a beṉə' ca' chso'onḻilažə' nada', na' ḻega'aque' zɉənombi'e nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Nombi'aga'aca'ane' ca X̱a'anə' nombi'e nada' na' nada' nombi'a X̱a'anə'. Na' de'en chgüia chyega'aca'ane' chsanḻažə' cuina' so'ot beṉə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Na' nitə' beṉə' ga yoblə beṉə' cui zɉənaquə beṉə' Izrael beṉə' so'onḻilažə' nada' na' yoso'ozenague' c̱hia'. Ḻeczə ḻega'aque' cheyaḻə' əgwtoba' par nic̱h yoguə'əḻoḻ no so'onḻilažə' nada' əsa'aque' tozə len lɉuežɉga'aque' na' toza' nada' ggüia gwya' yoguə'əḻoḻga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Chsanḻažə' cuina' so'ot beṉə' nada' pero techlə yebana'. Na' chaquəche X̱a'an c̱hia' de'en chazlaža'a chona' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ni to cono yeque'e yeḻə' mban c̱hia'anə' sino chsanḻažə' cuina' so'ot beṉə' nada'. Napa' yeḻə' gwnabia'anə' par gwsanḻažə' cuina' so'ote' nada', na' napa' yeḻə' gwnabia' par yeyas yebana' ladɉo beṉə' guat ca'. Na' X̱a'anə' babene' mendad gona' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Na' de'e yoblə gwsa'ac beṉə' blao c̱he ṉasyon Izrael c̱heton' c̱hoplə por ni c̱he dižə' ca' de'en gwse'enene' be'e. ");
INSERT INTO zavNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Zan beṉə' ca' gosə'əne': ―Chac tonte'enə', bito chacbe'ine' bi dižə'ən cho'e. ¿Bixc̱hen' chzenagle c̱he'? ");
INSERT INTO zavNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Na' baḻe' gosə'əne': ―Dižə' quinga caguə naquən ca c̱he beṉə' chac tontən'. ¿Eguaquə gon to beṉə' chac tont par le'i beṉə' lc̱hoḻ? ");
INSERT INTO zavNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Na' Jerosalenṉə' chac lṉi c̱he yo'odao' əblao c̱he neto' beṉə' Izrael de'en ne' “Dedicasion”. Na' naquə tyemp zag. ");
INSERT INTO zavNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Na' Jeso'osən' chde' cha'ašil c̱he yo'odao' əblaonə' part de'en chəsə'əne' “Cha'ašil c̱he Salomon”. ");
INSERT INTO zavNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Na' gwse'ec̱hɉ beṉə' blao c̱he ṉasyon Izrael c̱heton' Jeso'osən' na' gwse'ene': ―¿Bixc̱hen' ṉe'e chono' par chacžeɉlažə'ətecto' šə len' Cristən' ben' gwleɉ Diozən' par gaquəlene' ṉasyon c̱heton'? Šə le'enə' Cristən', gwna neto' clar. ");
INSERT INTO zavNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Na' gož Jeso'osən' ḻega'aque': ―Bagwnia' le'e na' cui cheɉḻe'ele. Miḻagr ca' de'en babena' len yeḻə' guac c̱he X̱a'anə' chəsə'əlo'en de que ḻe'enə' bseḻe'e nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Na' le'e bito cheɉḻe'ele c̱hia' c̱hedə' cui nacle txen len beṉə' ca' chso'onḻilažə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nombi'a beṉə' ca' chso'onḻilaže'e nada' na' ḻega'aque' choso'ozenague' c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Na' nada' chnežɉoga'aca'ane' yeḻə' mban zeɉḻicaṉe, na' cuat yesə'əbiayi'e. Ni to cui no no əca'ax̱ax̱ɉ ḻega'aque' lao na'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","X̱a'anə' bagwleɉe' ḻega'aque' par nic̱h chgüia chyega'aca'ane'. Na' ni to cui no no gaquə əca'ax̱ax̱ɉ ḻega'aque' lao na' X̱a'anə' c̱hedə' nape' ḻe'ezelaogüe' yeḻə' chnabia' xen. ");
INSERT INTO zavNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nada' na' X̱a'anə' tozə can' naquə yic̱hɉla'ažda'oto'onə', tozə can' naquə yeḻə' guac c̱heto'onə' na' tozə can' chonto'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nach beṉə' blao c̱he ṉasyon Izrael c̱heton' gosə'əzi'e yeɉ par yoso'ošiže'ene'en. ");
INSERT INTO zavNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Na' gož Jeso'osən' ḻega'aque': ―De'e zan de'e güen bable'ile bena' len yeḻə' guac c̱he X̱a'anə'. ¿Non' de'e ca' babena' chonən par əgwšižə'əle nada' yeɉən'? ");
INSERT INTO zavNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Na' beṉə' blao ca' gwse'e ḻe': ―Caguə por ni c̱he bi de'e güen de'en babeno'on əgwšižə'əto' le' yeɉən', sino por ni c̱he chžia chnito'o Diozən'. Con beṉac̱hzə le' na' nao' de que naco' Dioz. ");
INSERT INTO zavNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Na' gož Jeso'osən' ḻega'aque': ―Le'e chsedle Xtižə' Diozən' de'en nyoɉ gan' nan: “Nada' gwnia' de que le'e nacle ca Dioz.” ");
INSERT INTO zavNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Na' Xtižə' Diozən' de'en nyoɉən caguə de'e te c̱heinə'. Na' ḻenṉə' nan de que Diozən' gwne' c̱he beṉə' ca' əbnežɉue' xtiže'enə' de que gwsa'aque' ca Dioz. ");
INSERT INTO zavNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ca naquə Diozən' gwne' zɉənaque' ca cuine', ¿bixc̱hen' nale de que chžia chnita'a Diozən' de'en gwnia' naca' Xi'iṉe'? Ḻe'enə' gwleɉe' nada' par gaquəlena' beṉac̱hən' na' bseḻe'e nada' yežlyo nga. ");
INSERT INTO zavNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Žalə' de'e ca' chona'anə' bito zɉənaquən de'en chon X̱a'anə', bito šeɉḻe'ele c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero na' de'en zɉənaquən de'en chone'enə', cheyaḻə' šeɉḻe'ele de que naca' Xi'iṉe' ḻa'aṉə'əczə cui cheɉḻe'ele xtiža'anə'. Šə šeɉḻe'ele c̱he de'e ca' chona'anə' na' əṉezele de que X̱a'anə' zoe' len nada' na' nada' zoa' len ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Na' de'e yoblə bosə'əsye' naclən' gaquə ədoḻe'e, pero bito besyə'əželene' naclən' so'one'. ");
INSERT INTO zavNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Na' gwsa'ato' len Jeso'osən' ɉəsoto' yešḻa'alə yao Jordanṉə' gan' gwzo de'e Juanṉə' antslə catə'ən bc̱hoe' beṉə' nis. ");
INSERT INTO zavNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Na' zan beṉə' bda'aque' gan' zoto' par boso'ozenague' xtižə' Jeso'osən' na' gosə'əne' c̱he': ―Ḻa'aṉə'əczə de'e Juanṉə' ni to miḻagr cui bene', yoguə'əḻoḻ de'en gwne' c̱he benga naquən de'e ḻi. ");
INSERT INTO zavNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Na' beṉə' zan beṉə' nitə' na' gwso'onḻilaže'e Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Na' goquən chacšene to beṉə' Betania beṉə' le Lac̱h. Betania nan' naquən laž Maria na' Marta, na' ḻega'aque'enə' zɉənaque' beṉə' zan Lac̱hən'. Maria nga ben' bcuase' set zix̱ ṉi'a X̱ancho Jeso'osən' na' bxie' ṉi'enə' len yišə' yic̱hɉe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Na' beṉə' zan Lac̱hən' boso'oseḻe'e rson gan' zo Jeso'osən' gwse'ene': ―X̱anto', be'en chacdo' c̱hei chacšenene'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Na' catə' gwṉeze Jeso'osən' na' gwne': ―Yižgüe' c̱he'enə' bito naquən de'e gattecze', sino par əye' Diozən' yeḻə' bala'aṉən' chacšenene' na' par nic̱h nada' si'a yeḻə' bala'aṉ, nada' naca' Xi'iṉ Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Gwde gwṉeze Jeso'osən' de que chacšene Lac̱hən', ṉebega'aṉe' yec̱hopə ža gan' zoe'enə' ḻa'aṉə'əczə chaquene' c̱he Martən', c̱he beṉə' bile'enə' na' c̱he Lac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nach gože' neto': ―Ḻəšo'o Jodean' de'e yoblə. ");
INSERT INTO zavNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nach gožto'one': ―Maestr, bi ža na'azən' gwsa'aclažə' beṉə' blao c̱he ṉasyon c̱hechon' yoso'ošiže'e le' yeɉ. ¿Ena' de'e yoblə šeɉo' na'anə'? ");
INSERT INTO zavNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Na' gwna Jeso'osən': ―¿Ecaguə šižiṉ orən' naquə težan'? Beṉə' chda teža bito chc̱hegüe'e c̱hedə' la' nye'eni'inə'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mas beṉə' chda še'elə chc̱hegüe'e c̱hedə' cuich nye'eni'. Ca'aczə naquən len nada', bito bi bi gaquə c̱hia' žlac cuiṉə' əžin ža par so'ote' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Gwde gwne' ca' gozne' neto': ―Beṉə' migw c̱hecho Lac̱hən' bagwtase', na' ša'a žɉəyesbana'ane'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Na' gožto'one': ―X̱anto', šə bachtase'enə' goyacczene'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jeso'osən' gwne' ca' c̱hedə' gwṉezene' bagot Lac̱hən', na' neto' bento' xbab de que gwne' ca' c̱he bišgalən'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nach Jeso'osən' gwne' neto' clar: ―Bagot Lac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Na' chebeida' cui gwzoa' lao chacšenene', par nic̱h ṉa'a gona' ca šeɉḻe'echle c̱hia'. Ḻe'e šo'o gan' de'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nach beṉə' lɉuežɉto' Tomasən' gože' neto': ―Ḻe'e šo'o par nic̱h len chio'o so'ote' šə bachso'ote' Jeso'osən'. Tomas na'anə' ben' boso'osi'e Didimo c̱hedə' naque' beṉə' cuaš. ");
INSERT INTO zavNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nach gwyeɉto' len Jeso'osən' Betanian', na' catə' bžinto'onə' gwse' beṉə' ca' ḻe' de que bagoc tap ža boso'ocuaše'e Lac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Na' Betanian' chi'in gaḻə'əzə Jerosalenṉə' ca do gašɉə ḻegw. ");
INSERT INTO zavNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Na' beṉə' zan beṉə' Izrael gwlaž c̱heto' ca' ža' Jerosalenṉə' besə'əžine' gan' zo Martən' na' Marian' par chso'e ḻega'aque' yeḻə' chxenḻažə' de'en got beṉə' zanga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nach Martən' catə' gwṉezene' bazon əžinto' na' bchoɉe' bedəšague' neto', na' Marian' bito bchoɉe' ližga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Nach Martən' gože' Jeso'osən': ―X̱ana', žalə' gwzo' catə'ən gocšene beṉə' zana'anə' bito gote' žalə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero ḻa'aṉə' bagote', ṉezda' de que Diozən' gone' bitə'ətezə de'en əṉabdo'one'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Nach gož Jeso'osən' ḻe': ―Goban beṉə' zano'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Nach Martən' gože'ene': ―Ṉezda' de que gobane' catə'ən yesyə'əban beṉə' guat ca' žan' šo'o fin c̱he yežlyon'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Na' gož Jeso'osən' ḻe': ―Nada' chac chosbana' beṉə' guat ca' na' nada' nsa'a yeḻə' mban zeɉḻicaṉe par beṉə' ca' chso'onḻilažə' nada'. De'e na'anə' beṉə' ca' chso'onḻilažə' nada' ḻa'aṉə'əczə sa'ate', de yeḻə' mban zeɉḻicaṉe c̱hega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na' notə'ətezə beṉə' chso'onḻilaže'e nada' zɉənape' yeḻə' mban zeɉḻicaṉe na' cuat ṉabia' yeḻə' gotən' ḻega'aque'. ¿Echeɉḻi'o de'e nga? ");
INSERT INTO zavNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Na' gože'ene': ―X̱ana', cheɉḻi'a de que naco' Xi'iṉ Dioz. Cheɉḻi'a de que naco' Cristən' ben' babseḻə' Diozən' yežlyo nga par gaquəlene' neto'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Beyož gwna Martən' ca' nach beyeɉe' na' ɉəyeyeže' Maria bile'enə' žižizə: ―Baza' Maestrən' na' chṉe' le'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Na' Marian' catə' benene' can' gož Martən' ḻe' ḻe'e gwzoža'ate' bide' gan' zoto' len Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Na' caguə babžinto' lao yežən' ca orən', ṉenaguə'əto' gan' bedəšag Martən' neto'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Na' beṉə' Jerosalen ca' nitə' len Marian' liže'enə', beṉə' ca' chso'e ḻega'aque' yeḻə' chxenḻažə', catə' besə'əle'ine' gwza' Marian' nach gosə'ənaogüe'ene' chsa'aquene' cho'a ba na'an zde' zɉəc̱heže'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Na' Marian' catə' ble'e gan' zoto'onə' ble'ine' Jeso'osən', na' bzo xibe' laogüe'enə' na' gože'ene': ―X̱ana', žalə' le' gwzo' nga catə'ən chacšene beṉə' zana'anə', bito gote' žalə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Na' catə' ble'i Jeso'osən' chbež Marian' na' ḻeczə chəsə'əbež beṉə' Jerosalen ca' nžague'enə', de'e juisy de'e goquene' na' bžaglaogüe' ḻo'o yic̱hɉla'ažda'ogüe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Na' gože' ḻega'aque': ―¿Ga əbcuašə'əlene'? Na' ḻega'aque' gwse'ene': ―X̱anto', yo'o na' le'ido'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Na' gwchež Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Na' gosə'əna beṉə' Jerosalen ca': ―Ḻe'e ggüiašc catequən' chaquene' c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Na' baḻə beṉə' ca' gosə'əne': ―Ḻe' ngan' bene' par nic̱h ble'i beṉə' lc̱hoḻ ca'. ¿Ecui gaquən' žalə' bene' par nic̱h cui gat Lac̱hən'? ");
INSERT INTO zavNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Na' de'e yoblə de'e juisy de'e goque Jeso'osən' ḻo'o la'aždaogüe'enə'. Nach yoguə'əto' gwyeɉto' cho'a ban' len Jeso'osən'. Na' ban' naquən to bloɉ na' da' to yeɉ cho'inə'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Nach gož Jeso'osən': ―Ḻeca'a yeɉən'. Na' Mart zan de'e beṉə' guatən' gože'ene': ―X̱ana', bachḻa' ben' zban, la' bac̱h goc tap ža ṉa'a gote'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Na' gož Jeso'osən' ḻe': ―Bagwnia' le' šə chonḻilažo'o nada' nach šeɉni'ido' bi zeɉe ca de'en gwlo'e Diozən' yeḻə' guac xen c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nach beṉə' ca' gosə'əque'e yeɉən'. Na' Jeso'osən' gwḻis laogüe'en yobalə gwne': ―X̱a', chox̱cwleno' babzenago' c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nada' ṉezda' de que syempr chzenago' c̱hia'. Pero ənia' ca' par nic̱h beṉə' ca' ža' nga se'eɉḻe'e de que len' əbseḻo'o nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Na' beyož gwne' ca' lao orasyonṉə', beḻgüiže' de'e beṉə' guatən' gwṉe' zižɉo gože'ene': ―Lac̱h bechoɉ. ");
INSERT INTO zavNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nach ḻe'e bechoɉte Lac̱hən', zɉəncheləyoy ṉi'a ne'e ca' cint de lachə' na' to bey nazɉə laogüe'enə'. Na' gož Jeso'osən' ḻega'aque': ―Ḻe'e yozaše' lachə'ənə' na' ḻe'e gwsane' yeyeɉe'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Na' zan beṉə' Jerosalen ca' beṉə' ca' zɉa'ac len Marian' besə'əle'ine' miḻagr de'en ben Jeso'osən' na' gwso'onḻilaže'e ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero baḻe' ɉa'aque' lao beṉə' fariseo ca' ɉse'eže' ḻega'aque' can' bene' bosbane' Lac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nach bx̱oz əblao c̱he ṉasyon Izrael c̱heton' na' beṉə' fariseo ca' besə'ətobe' yoguə'əḻoḻ beṉə' ca' chəsə'ənabia' ṉasyon c̱heton'. Nach boso'oxi'e gosə'əne': ―¿Naclə gonchon'? la' miḻagr zanṉə' chon benga. ");
INSERT INTO zavNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","La' šə gaquecho lɉoye'enə', yoguə' beṉə' so'onḻilaže'e ḻe', nach da'ac beṉə' ṉasyon Roma na' yoso'ožiaye'e yo'odao' əblao c̱hecho nga na' len ṉasyon c̱hechon'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Entr beṉə' golə beṉə' blao ca' toe' le Caifas na' naquəche' bx̱oz əblao ca izən'. Na' gože' ḻega'aque': ―Le'e caguə bi ṉezelen'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nic chonḻe xbab de que napən chio'o cuentən' tozə ben' gotcho lgua'a cuiayi' yoguə'əcho len ṉasyon c̱hecho nga. ");
INSERT INTO zavNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifasən' naquəche' bx̱oz əblao ca izən' na' caguə con gwne' ca' to gwlazze'enə'. Dioz nan' bene' par gwdix̱ɉui'e de que so'ote' Jeso'osən' por ṉasyon Izrael c̱heto'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Na' caguə so'ote'ene' par ṉasyon c̱heto' na'azənə'. Ḻeczə so'ote'ene' par nic̱h yoguə' beṉə' ca' bagwleɉ Diozən' par əque'e ca xi'iṉe' gatə'ətezə ṉasyon, yesyə'əyaque' tozə so'elaogüe'ene'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Na' ža na' gwzolao boso'oxi'e naclən' so'one' par so'ote'ene'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Na' de'e nan' bitoch gwda Jeso'osən' zaquə'əlao entr beṉə' gwlaž c̱heto' ca'. Na' gwza'ato' gwyeɉto' to yež de'en nzi' Efrain, chi'in gaḻə'əzə latɉə dašən'. Na' gwzoto' na' len ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Na' lṉi pascw c̱he neto' beṉə' Izrael bazon baozə. Na' beṉə' zan beṉə' za'ac to to yež ɉa'aque' Jerosalenṉə' antslə ze'e gaḻə' lṉi pascon' par gwso'on cuinga'aque' xi'ilažə' can' na ḻei c̱heto'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Na' besyə'əyilɉe' Jeso'osən', na' ca nite'e chyo'o yo'odao' əblao c̱heton' gwse'e lɉuežɉe': ―¿Bi xbab chontguale? ¿əgüide' lṉi nga? ");
INSERT INTO zavNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Gosə'əne' ca' c̱hedə' bx̱oz əblao c̱he ṉasyon Izrael c̱heton' na' beṉə' fariseo ca' bagwso'one' mendad de que notə'ətezə beṉə' əṉezene' gan' zo Jeso'osən' gwzenene' ḻega'aque' par nic̱h yesə'əzene'ene'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Na' x̱op ža antslə lṉi pascon', gwyeɉlento' Jeso'osən' Betanian' gan' zo Lac̱hən' ben' bosbane' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Na' baḻə beṉə' Betania ca' boso'osi'ini'e to xše' par Jeso'osən', na' Martən' bdie' de'en güe'eɉ gwdaoto' len ḻe'. Na' Lac̱hən' chi'e cho'a mesən' txen len Jeso'osən' na' len neto' na' beṉə' ca' yeḻa'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Na' Marian' de tya set zix̱ c̱he' de'e zaquə'əchgüei na' gwlo'en ṉi'a Jeso'osən'. Na' bxie' ṉi'enə' len yišə' yic̱hɉe'enə'. Na' doxen yo'onə' gwḻa'achgua ze set zix̱ən' gwlo'e ṉi'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Na' zo Jod Iscariotən', ben' naquə neto' txen. Ḻe'enə' banaquən əgwdie' Jeso'osən' lao na' beṉə' ca' chəsə'əgue'i ḻe'. Jodən' naque' xi'iṉ to beṉə' le Simon. Na' Jodən' gwne': ");
INSERT INTO zavNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Bixc̱hen' cui bete'e set zix̱ nga? Zaquə'ən do tmil gueyə' gueyoa. Na' mechən' de'en le'ine' c̱hei əgwnežɉue'en beṉə' yašə' žalə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Jodən' bene' xbabən' ca' caguə por ni c̱he beyaše'ene' beṉə' yašə' ca' sino por ni c̱he naque' beṉə' bguan. Ḻen' bex̱e'e mech de'en bc̱hin yoguə'əto' na' gwleɉlane' mechən'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nach Jeso'osən' gože'ene': ―Lɉoye'enə'. Babene' de'en non gonene' nada' žan' əgaša'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ca naquə beṉə' yašə' ca', syempr nitə'əcze' len le'e, pero nada' caguə syempr soa' len le'e. ");
INSERT INTO zavNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Na' beṉə' zan beṉə' Izrael gwlaž c̱heton' gwsa'acbe'ine' de que Jeso'osən' zoe' na'. Na' ɉa'aque', pero caguə por ni c̱he Jeso'os na'azən', sino par besə'əle'ine' Lac̱hən', ben' bosban Jeso'osən' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Na' bx̱oz əblao c̱he ṉasyon c̱heton' ḻeczə boso'oxi'e so'ote' len Lac̱hən', ");
INSERT INTO zavNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","c̱hedə' beṉə' zan beṉə' Izrael gwlaž c̱heton' ɉa'aque' na' gwso'onḻilaže'e Jeso'osən' por ni c̱he ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Na' beteyo gwza'ato' Betanian' len Jeso'osən' na' gwyeɉto' Jerosalenṉə'. Na' ca orən' beṉə' zan chəsə'əžag Jerosalenṉə' beṉə' zɉa'ac lṉi pascon'. Na' gosə'əṉezene' de que Jeso'osən' yežine' Jerosalenṉə'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Na' de'e na'anə' besə'əchoɉe' bedəsə'əleze' neto', zɉənox̱e'e no zin, na' chəsə'əgüe'e be' lban c̱he' chəsə'əne': ―Le' naco' Rei c̱he ṉasyon Izrael c̱hechon', goclenšga neto'. Sošgo' mbalaz le' baza'o nga, babseḻə' X̱ancho Diozən' le'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Na' bžel to borr dao' bia gwžia Jeso'osən' lao zde'. Goc can' nyoɉczən nan: ");
INSERT INTO zavNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Le'e ža'ale Jerosalenṉə' bito žeble. Ḻe'e ggüiašc baza' Rei c̱helen' žie' to borr dao'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Na' neto' disipl c̱he' bito gwyeɉni'ito' categazə de que goc c̱he' con can' boso'ozoɉ de'e profet ca' beṉə' ca' gwso'e xtižə' Diozən' cana'. Gwde gwso'ot beṉə' Jeso'osən' na' Diozən' be'ene' yeḻə' bala'aṉ xen, na' canan' ɉəyeza'alažə'əto' dižə' ca' zɉənyoɉ c̱he' na' gocbe'ito' gwso'one'ene' ḻe' can' nyoɉənṉə'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Beṉə' ca' gwnitə' len Jeso'osən' catə'ən boḻgüiže' Lac̱hən' na' bosbane'ene' par bechoɉe' ḻo'o ban' gwso'e dižə' len beṉə' ca' ža' syodan' can' bene'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","De'e na'anə' bedəsə'əleze'ene' c̱hedə' gosə'əṉezene' ca miḻagr de'en bene'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Na' gosə'əna beṉə' fariseo ca' entr ḻega'aque': ―Bachle'ile cuiczə bi de gonchon'. Yoguə' beṉac̱hən' zɉəsə'ənao ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Na' zɉəlen baḻə' beṉə' griego, beṉə' ɉa'ac lṉinə' par gwso'elaogüe'e Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Beṉə' quinga besə'əžine' gan' zo Lip beṉə' Betsaida distrit c̱he Galilean'. Na' gwsa'atə'əyoine' Lipən' gwse'ene': ―Gwzi'ixenšga, chene'eto' güe'elento' Jeso'osən' dižə'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nach gwyeɉ Lipən' ɉəye' Ndresən'. Nach Ndresən' len Lipən' ɉəsə'əye' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nach Jeso'osən' gože' ḻega'aque': ―Ṉa'a bachžin ža so'ot beṉə' nada' par nic̱h Diozən' goṉe' nada' yeḻə' bala'aṉ xen. Ḻen' bseḻe'e nada' golɉa' beṉac̱h. ");
INSERT INTO zavNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","De'e ḻi əchnia' le'e, šə to trigon' cui yexiṉɉən catə' əxopən lao yon', chega'aṉczə tozən, pero šə yexiṉɉən na' yela'an, de'e zan trigon' yeyaquən. ");
INSERT INTO zavNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Notə'ətezə beṉə' chaquene' gone' par nic̱h cui c̱hi' saque'e o par nic̱h cui no so'ot ḻe', be'enan' cuiayi'. Na' notə'ətezə beṉə' chsanḻažə' cuine' c̱hi' saque'e o so'ot beṉə' ḻe' por ni c̱hia', bade yeḻə' mban zeɉḻicaṉe c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Na' notə'ətezə beṉə' chene'ene' gone' xšina'anə', c̱heyaḻə' gonḻilaže'e nada' na' gwzenague' c̱hia'. Na' ga'an soa' na' so ben' gon xšina'anə'. Na' beṉə' ca' so'on xšina'anə', X̱a'anə' güe'e ḻega'aque' yeḻə' bala'aṉ. ");
INSERT INTO zavNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Bachžaglaogua' ḻo'o yic̱hɉla'aždaogua'anə'. ¿Echaquele ṉabda' X̱a'anə' yosle' nada' lao de'e ca' ze'e gaquə c̱hia' ṉa'a? Abi. Babida' par nic̱h gaquəczə c̱hia' ca'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nach bene' orasyonṉə' gwne': ―X̱a', ben par nic̱h le' si'icho' yeḻə' bala'aṉ. Nach Diozən' ben' zo yoban' gwṉe' gože'ene': ―Babena' ca gwxi'a yeḻə' bala'aṉ, na' ze'e goncha' ca si'icha'anṉə'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Beṉə' zan zɉənžague' neto' ca orən' na' catə' gwse'enene' de'en gwna Diozən', baḻe' gosə'əne' de que gwṉinṉə'. Na' yebaḻe' gosə'əne': ―To anglən' əgwṉe ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Na' Jeso'osən' gože' neto': ―Diozən' gwṉe' nada' zižɉo caguə par nic̱h nada' əṉezda' de que chzenague' c̱hia'anə', sino par nic̱h əṉeze le'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Bachžin ža catə' Diozən' əgwnežɉue' castigw zeɉḻicaṉe c̱he beṉə' ca' cui zɉənombia' ḻe'. Na' bachžin ža catə' gwxiye'enə' de'en chnabia' beṉə' ca' cui zɉənombia' Diozən' nit yeḻə' gwnabia' c̱heinə'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Na' catə' gwso'ote' nada' ḻe'e yag corozən', gona' par nic̱h yoguə'əḻoḻ beṉə' bagwleɉ Diozən' par əsa'aque' xi'iṉe' so'onḻilaže'e nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Na' de'e ngan' gwne' chzeɉni'ine' neto' de que so'ot beṉə' ḻe' yoso'ode'ene' to ḻe'e yag coroz. ");
INSERT INTO zavNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nach baḻə beṉə' zan ca' ža'anə' gwse'ene': ―Neto' babeneto' choso'osed choso'olo'i beṉə' can' na Xtižə' Diozən' de'en nyoɉən, na' ṉezeto' nan de que Cristən' ben' gwleɉ Diozən' par gaquəlene' ṉasyon c̱hechon' soe' zeɉḻicaṉe. Na' le' nao' de que Diozən' bseḻe'e le' golɉo' beṉac̱h. ¿Bixc̱hen' nao' le' de que so'ot beṉə' le' to ḻe'e yag coroz? ¿Ebseḻə' Diozən' le' golɉo' beṉac̱h? ");
INSERT INTO zavNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nach Jeso'osən' gože' ḻega'aque': ―Nada' za'a par əchgua'a be'eni' ḻo'o yic̱hɉla'aždao' beṉac̱hən'. Na' yeto term da'ogan' soa' par əgwsed əgwlo'ida' le'e. Ḻe'e šeɉḻe' xtiža'anə' žlac ṉe'e de latɉə par nic̱h cui cuiayi'ile zeɉḻicaṉe. Beṉə' ca' cui chse'eɉḻe'e xtiža'anə' bito chsa'acbe'ine' de que yesə'əbiayi'e. Zɉənaque' ca to beṉə' chda gan' naquə žc̱hoḻ na' bito chacbe'ine' gan' chde'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ḻe'e gonḻilažə' nada' ṉa'a žlac ṉe'e de latɉə par nic̱h šo'o be'eni' c̱hian' ḻo'o yic̱hɉla'ažda'olen' na' par nic̱h əgwnežɉwle be'eni' c̱he yeziquə'əchlə beṉə'. Gwde gwna Jeso'osən' ca' beze'e bocuaše'ene' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ḻa'aṉə'əczə besə'əle'i beṉə' Izrael gwlaž c̱heton' ben Jeso'osən' zan miḻagr, casi yogue'e bito gwso'onḻilaže'ene'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Na' de'en goc ca' goc complir can' bzoɉ de'e profet Isaiazən' ben' be' xtižə' Diozən' cana', nan: X̱anto', casi notono no choso'ozenag dižə' de'en chyix̱ɉue'eto'onə'. Na' casi notono chsa'acbe'i de que babesə'əle'ine' blo'o yeḻə' guac c̱hio'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Bito goquə se'eɉḻe'e, c̱hedə' chac c̱hega'aque' can' na yeto de'en bzoɉ de'e profet Isaiazən', nan: ");
INSERT INTO zavNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Diozən' babene' par nic̱h nažɉo yic̱hɉla'aždao' beṉə' quinga na' par nic̱h zɉənaque' beṉə' godenag. Babene' par nic̱h chəsə'əle'ine' pero cabi chsa'acbe'ine' bi zeɉen de'en chəsə'əle'ine'enə', na' chse'enene' pero bito chse'eɉni'ine' bi zeɉen de'en chse'enene'enə'. Gosyə'ədiṉɉlɉei xtoḻə'əga'aque'enə na' gwso'elɉe' latɉə yocobə Diozən' yic̱hɉla'ažda'oga'aque'enə' žalə' chse'eɉni'ine'en na' žalə' chsa'acbe'ine' bi zeɉen. ");
INSERT INTO zavNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","De'e quinga gwna de'e profet Isaiazən' c̱hedə' ble'ine' yeḻə' chey che'eni' c̱he Jeso'osən' na' be'e dižə' c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ḻa'aṉə'əczə beṉə' zanch lao ṉasyon Izrael c̱heton' bito gwse'eɉḻe'e c̱he Jeso'osən', bia'aczə zane' gwso'onḻilaže'ene', na' len no beṉə' gwnabia' c̱heto' ca'. Pero na' bito gwso'e dižə' de que chso'onḻilaže'ene' c̱hedə' besə'əžebe' cabich əso'e beṉə' fariseo ca' latɉə par so'e ḻo'o yo'oda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Gwse'enchene' so'e beṉac̱hən' ḻega'aque' yeḻə' bala'aṉ cle ca so'one' ca güe' Diozən' ḻega'aque' yeḻə' bala'aṉ. ");
INSERT INTO zavNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Na' Jeso'osən' gwṉe' zižɉo gože' ḻega'aque': ―Beṉə' ca' chso'onḻilažə' nada' caguə nadə'əzan' chso'onḻilaže'e sino lenczə X̱a'anə' ben' əbseḻə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ben' chle'i nada' ḻeczə chle'ine' X̱a'anə' ben' bseḻə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nada' za'a yežlyo nga par nic̱h chgua'a be'eni' ḻo'o yic̱hɉla'aždao' beṉə' ca' chso'onḻilažə' nada'. Chgua'a be'eni' ḻo'o yic̱hɉla'ažda'oga'aque'enə' par nic̱h cuich so'ontezə so'one' de'e malən'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Na' notə'ətezə beṉə' chse'ene xtiža'anə' na' bito choso'ozenague' c̱hei caguə nada' c̱hoglaogua'an c̱hega'aque' de que zɉənape' doḻə, c̱hedə' bito za'a yežlyo nga par nic̱h c̱hoglaogua'an c̱he beṉac̱hən' de que zɉənape' doḻə' sino par nic̱h gona' ca cui žɉəya'aque' lao yi' gabiḻən' šə so'onḻilaže'e nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Xtiža'anə' de'en babi'a len ḻega'aque' c̱hoglaon c̱hega'aque' de que zɉənape' doḻə' c̱hedə' bito chse'eɉḻe'e c̱hia' na' nic choso'ozenague' c̱he xtiža'anə'. C̱hoglaon c̱hega'aque' de que zɉənape' doḻə' catə' əžin ža šo'o fin c̱he yežlyon'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Dižə' de'en babi'anə' bito bi'an de'e bia'azəlaža'a. X̱a'anə' bseḻe'e nada' na' ḻe'enə' none' mendad bin' cheyaḻə' nia' na' bin' əgwsed əgwlo'ida' beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na' notə'ətezə beṉə' yoso'ozenag c̱he xtižə' X̱a'anə' de'en none' mendad cho'elena' beṉac̱hən', əgwnežɉue' yeḻə' mban zeɉḻicaṉe c̱hega'aque'. De'e na'anə' cho'elena' le'e dižə' con can' bagwna X̱a'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Na' ca naquə Jeso'osən', bedote chaquene' c̱he neto' chonḻilažə'əto' ḻe' yežlyo nga. Na' ṉezene' de que bachžin ža yeze'e yežlyo nga par yeyeɉe' gan' zo X̱e'enə'. De'e na'anə' catə' ze'e za'alə lṉi pascon' blo'ichene' neto' can' ḻechguaḻe chaquene' c̱heto'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Na' bac̱h gwlo'o gwxiye'enə' xbabən' ḻo'o yic̱hɉla'aždao' Jod Iscariot xi'iṉ Simonṉə' par əgwdie' Jeso'osən' lao na' beṉə' contr c̱he' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Na' ṉeze Jeso'osən' de que X̱e'enə' babene' par nic̱h nape' ḻe'ezelaogüe yeḻə' chnabia' xen, na' ṉezene' de que gan' zo Dioz nan' gwze'e na' gan' zo Dioz nan' yeyeɉe'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Na' lao chaoto' xše'enə' Jeso'osən' gwzože'e na' gwcua'a xadoṉ c̱he'enə' na' gwxi'e to lachə' na' bc̱heɉe'en lsine'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nach gwxi'e nisən' gwde'en to ḻo'o ša' na' gwzolaogüe' gwdibe' ṉi'ato'onə' ca to mos. Na' bosbiže' ṉi'ato'onə' len lachən' de'e ncheɉ lsine'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Na' catə' bžine' gan' chi' Simon Bedən', Bedən' gože' ḻe': ―X̱ana' ¿əle' c̱hibo' ṉi'anə'? ");
INSERT INTO zavNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Na' gož Jeso'osən' ḻe': ―De'e nga chona' cabi cheɉni'ido'on ṉa'a, pero gwyeɉni'ido'on telə. ");
INSERT INTO zavNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Na' gož Bedən' ḻe': ―Le' cuat c̱hibo' ṉi'anə'. Na' Jeso'osən' gože'ene': ―Šə cui ga'a c̱hiba' le' caguə leno' nada'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Na' Bedən' gože'ene': ―X̱ana' caguə ṉi'a na'azən', sino doxencza'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Nach gož Jeso'osən' ḻe': ―Beṉə' nošə' nazɉə, ṉi'e na'azə chyažɉe c̱hibe', la' banaquəczə doxen cuerp c̱he'enə' xi'ilažə'. Ca naquə le'e ža, naquəczle xi'ilažə' ḻa'aṉə'əczə caguə yoguə'əle. ");
INSERT INTO zavNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jeso'osən' ṉezene' non' əgwde ḻe' lao na' beṉə' contr c̱he' ca', na' de'e na'anə' gwne': “Caguə yoguə'əle nacle xi'ilažə'”, na' zeɉen caguə yoguə'əto' naquəto' beṉə' la'aždao' xi'ilažə'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Na' catə' beyož gwdibe' ṉi'ato'onə', na' beyaz xadoṉ c̱he'enə' na' bebi'e de'e yoblə cho'a mesən'. Na' gože' neto': ―¿Echeɉni'ile bi zeɉen de'en babena' len le'e? ");
INSERT INTO zavNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","De'e nga zeɉen. Le'e nsi'ile nada' Maestr na' X̱anḻe, na' güenczən' nale c̱hedə' can' naca'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na' nada' naca' X̱anḻen' na' nactia' Maestr c̱helen' bagwdiba' ṉi'alen' ca to mos, de'e na'anə le'e ḻeczə cheyaḻə' gaquəlen lɉuežɉle ca to mos. ");
INSERT INTO zavNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Bagwdiba' ṉi'alen' parzə nic̱h gwlo'ida' le'e de que cheyaḻə' gonḻe can' babena'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","De'e ḻi əchnia' le'e notə'ətezə mos bito naque' blaoch ca x̱ane'enə', ni ben' cheɉ mendadən' cui naque' blaoch ca ben' chseḻə' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Šə cheɉni'ile de'e quinga na' gonḻe can' nia'anə', nachən' sole mbalaz. ");
INSERT INTO zavNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Caguə nia' ca' c̱he yoguə'əlen'. Nada' ṉezda' nac naquə yic̱hɉda'aždao' le'e bagwleɉa' par nacle disipl c̱hia'. Pero na' gwleɉa' le'e par nic̱h gaquə complir can' na Xtižə' Diozən' de'en nyoɉən nan: “Be'en gwdaolena' txen bableɉ bšošɉe' nada'.” ");
INSERT INTO zavNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nada' əchnia' le'e de'e nga ṉa'a antslə cuiṉə' gaquən, par nic̱h catə' gaquən šeɉḻe'ele de que nada' naca' ben' bagwnia' le'e. ");
INSERT INTO zavNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","De'e ḻi əchnia' le'e ben' cho'elao' notə'ətezə beṉə' əchseḻa'a, nada'anə' cho'elaogüe'e. Na' ben' cho'elao' nada', ben' əbseḻə' nada' na'anə' cho'elaogüe'e. ");
INSERT INTO zavNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Beyož gwna Jeso'osən' de'e ca' bachžaglaogüe' ḻo'o yic̱hɉla'aždaogüe'enə', na' gwne' clar: ―De'e ḻi əchnia' le'e de que to le'e əgwdele nada' lao na' beṉe' ca' chəsə'əgue'i nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nach neto' bgüia lao lɉuežɉto' chaqueto' noto' c̱hein' ne' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nach nada' chi'a cuite'enə' c̱hedə' chacchgüeine' c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Na' Bedən' bene' señy len nada' par nic̱h gwṉabda' Jeso'osən' no c̱hein' gwne' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nach bgüiga'a bao goža' Jeso'osən': ―X̱ana', ¿non'? ");
INSERT INTO zavNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nach gož Jeso'osən' nada': ―Be'en əgwnežɉua' to pedas yetən' catə' bablo'oɉa'an xoɉən', ḻe'enə'. Nach blo'oɉe' yetən' xoɉən' na' bnežɉue'en Jod Iscariot xi'iṉ Simonṉə'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Na' beyož bnežɉue' Jodən' yetən' ḻe'e gwyo'o gwyazte Satanasən' de'en chnabia' de x̱io' ca' ḻo'o yic̱hɉla'aždao' Jodən'. Nach Jeso'osən' gože'ene': ―De'en gono'onə' benən lgüegwzə. ");
INSERT INTO zavNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Na' ni to neto' ža'ato'onə' cui gwyeɉni'ito' bixc̱hen' gože' ḻe' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Jodən' nox̱e'e bols mechən' na' de'e na'anə' baḻəto' bento' xbab de que Jeso'osən' gože' ḻe' šeɉe' žɉəx̱i'e de'e chyažɉeto' lao lṉin' o de que cheyaḻə' əgwnežɉue' latə' mechən' beṉə' yašə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Na' catə' beyož gwdao Jodən' pedas yetən' de'en bnežɉw Jeso'osən' ḻe', ḻe'e bchoɉte'. Na' ca orən' bagoḻ. ");
INSERT INTO zavNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Na' gwde bchoɉ Jodən' Jeso'osən' gwne': ―Diozən' bseḻe'e nada' golɉa' beṉac̱h, na' ṉa'a so'ot beṉə' nada' na' goṉe' nada' yeḻə' bala'aṉ xen. Na' ḻeczə Diozən' si'e yeḻə' bala'aṉ xen ca de'en gaquə c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na' ca naquə Diozən' si'e yeḻə' bala'aṉ ca de'en gaquə c̱hia', ḻeczə ḻe'enə' goṉe' nada' yeḻə' bala'aṉ, na' ḻe'e solaote goṉe' nada' yeḻə' bala'aṉnə' ṉa'a. ");
INSERT INTO zavNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Xi'iṉdaogua'a, yešlož da'ogan' soa' len le'e. Na' yeyilɉle nada', na' can' goža' beṉə' blao c̱he ṉasyon Izrael c̱hechon', ḻeczə can' əchnia' le'e ṉa'a de que gan' yeya'a bito gaquə sa'alenḻe nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nach to de'e cobə chona' mendad gonḻe, de que gaque c̱he lɉuežɉle tole yetole can' chacda' c̱hele, ḻeczə can' ḻe'e gaque c̱he lɉuežɉle tole yetole. ");
INSERT INTO zavNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Na' yesə'əṉeze yoguə'əḻoḻ beṉə' de que nacle disipl c̱hia' šə gaquele c̱he lɉuežɉle tole yetole. ");
INSERT INTO zavNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Na' gož Bedən' ḻe': ―X̱ana', ¿gan' yeyeɉo'? Na' gož Jeso'osən' ḻe': ―Gan' yeya'a bito gaquə denaogo' nada' ṉa'a, pero telə denaogo'. ");
INSERT INTO zavNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Na' gož Bedən' ḻe': ―X̱ana' ¿bixc̱hen' cui gaquə denaogua' le' ṉa'a? Gwsanḻažə' cuina' so'ot beṉə' nada' laogüe de'en chacda' c̱hio' šə chonclən byen. ");
INSERT INTO zavNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Na' gož Jeso'osən' ḻe': ―¿Echacdo' gwsanḻažə' cuino' so'ot beṉə' le' laogüe de'en chacdo' c̱hia'? De'e ḻi əchnia' le' de que bito cuež ḻecon' antslə ze'e gaquə šoṉ las cui chc̱hebo' de que nombi'o nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Bito gaquəžeɉlažə'əle c̱hia' nada'. Ḻegonḻilažə' Diozən', na' ḻeczə ḻegonḻilažə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Gan' zo X̱a' Diozən' naquən ca to yo'o xen gan' ža' de'e zan cuart. Gwnia' le' žalə' cui bi cuart de par le'e. Na' yeya'a žɉəyeyenšaogua'a cuart par to tole. ");
INSERT INTO zavNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na' catə'ən babeyož ɉəyeyenšaogua'a cuart c̱helen', yida' yetši'i na' yec̱hi'a le'e socho txen par nic̱h gan' soa' na' so le'e. ");
INSERT INTO zavNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Banombi'ale gan' yeya'a na' baṉezele naquən' gonḻe par yeda'acle na'. ");
INSERT INTO zavNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Na' gož Tomasən' ḻe': ―X̱anto', bito ṉezeto' gan' yeyeɉo'. ¿Na' nacxa gaquən' əṉezeto' nac gonto' par yela'ato' na'? ");
INSERT INTO zavNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jeso'osən' gože'ene': ―De'en cheyaḻə' gonḻe gonḻilažə'əle nada' par nic̱h yežinḻe gan' zo X̱a'anə'. Nada' ṉezda' na' chzeɉni'ida' yoguə'əḻoḻ de'en naquə de'e ḻi c̱he Diozən'. Na' nada' nsa'a yeḻə' mban zeɉḻicaṉe par beṉə' ca' chso'onḻilažə' nada'. Ni to cono yežin gan' zo X̱a'anə' šə cui gonḻilaže'e nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Žalə' nombi'ayaṉə'əle nada', lente X̱a'anə' nombi'ale žalə' ca'. Na' dezd ṉa'a banombi'alene' na' bable'ilene'. ");
INSERT INTO zavNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Na' gož Lipən' ḻe': ―Ben par nic̱h le'ito' X̱a'onə'. Ḻezən de'en chene'eto'. ");
INSERT INTO zavNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jeso'osən' gože'ene': ―Ḻip, sša xen bagwzoa' len le'e, ¿əna' cuiṉə' gombi'o nada'anə'? Notə'ətezə beṉə' bable'i nada' lenczə X̱a'anə' bable'ine'. ¿Bixc̱hen' nao' gona' par nic̱h le'ile X̱a'anə? ");
INSERT INTO zavNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ecui cheɉḻi'o de que nada' zoa' len X̱a'anə' na' X̱a'anə' zoe' len nada'? Dižə' quinga cho'a nada', caguə cho'an de'e bia'azəlaža'anə'. X̱a' na'anə' zoe' len nada' na' ḻen' chone' par nic̱h cho'a dižə' quinga na' chona' yoguə'əḻoḻ de'en chona'. ");
INSERT INTO zavNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ḻe'e šeɉḻe' c̱hia' ca de'en əṉia' de que zoa' len X̱a'anə' na' ḻe' zoe' len nada'. Na' šə cui cheɉḻe'ele xtiža'anə', ḻe'e šeɉḻe' c̱hia' por ni c̱he de'en bable'ile chona'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","De'e ḻi əchnia' le'e ben' chonḻilažə' nada', ca de'e ca' chona' ḻeczə gone'en. Na' de'e zaquə'əch ca de'e ca' gone' c̱hedə' nada' yeya'a gan' zo X̱a'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na' yoguə' de'e əṉabele X̱a'anə' gona' laogüe de'en chonḻilažə'əle nada', gona'an par nic̱h X̱a'anə' si'e yeḻə' bala'aṉ ca de'en gona' naca' Xi'iṉe'. ");
INSERT INTO zavNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Bitə'ətezə de'e əṉable gona' por ni c̱he de'en chonḻilažə'əle nada', nada' gona'an. ");
INSERT INTO zavNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Šə chaquele c̱hia' cheyaḻə' gonḻe can' nona' mendad gonḻe. ");
INSERT INTO zavNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Na' ṉabda' X̱a'anə' par əseḻe'e Spirit c̱he'enə' len le'e par gaquəlenən le'e can' babena' nada'. Na' son len le'e zeɉḻicaṉe. Spirit c̱he Diozən' əgwzeɉni'in le'e de'en naquə de'e ḻi. ");
INSERT INTO zavNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Beṉə' ca' cui zɉənombia' Diozən' bito chso'elaogüe'e Spiritən' c̱hedə' bito chesə'əle'ine'en na' nic zɉənombi'en. Pero le'e nombi'alen c̱hedə' zon len le'e ṉa'a na' gwžin ža catə' son ḻo'o la'ažda'olen'. ");
INSERT INTO zavNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Bito gwcua'aṉa'a le'e ca gozebə. Güida' yeto nga gan' zole. ");
INSERT INTO zavNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Na' yešlož da'ozə na' beṉə' ca' cui zɉənombia' Diozən' cabich yesə'əle'ine' nada', pero le'e gwle'ile nada'. Na' laogüe de'en zoa' nsa'a yeḻə' mban zeɉḻicaṉe c̱he beṉə' chso'onḻilažə' nada', de'e na'anə' le'e sole zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Na' catə' əžin ža la' Spirit c̱he Diozən' son ḻo'o la'ažda'olen' canan' əṉezele de que nada' zoa' len X̱a'anə', na' le'e zole len nada', na' nada' zoa' len le'e. ");
INSERT INTO zavNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ben' ṉeze can' nona' mendad na' chone' can' əni'anə', bena'an chaque c̱hia'. Na' ben' chaque c̱hia' ḻeczə chaque X̱a'anə' c̱he', na' gwzochcza' gaquəda' c̱he' na' gona' par nic̱h əṉezene' de que zotezə zoa' len ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Na' Jodən' pero caguə Jod Iscariotən' gože' ḻe': ―X̱anto' ¿bixc̱hen' gono' par nic̱h neto' le'icheto' le' na' cui gono' par nic̱h beṉə' yoblə yesə'əle'ichene' le'? ");
INSERT INTO zavNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Na' Jeso'osən' gože'ene': ―Le'e chaquele c̱hia' chzenagle xtiža'anə'. Na' X̱a'anə' ḻeczə chaquene' c̱hele na' neto' desoto' len le'e. ");
INSERT INTO zavNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Beṉə' ca' cui chsa'aque c̱hia' bito choso'ozenague' xtiža'anə'. Dižə' de'en chenele ənia' le'e, caguə cho'an de'e bia'azəlaža'anə', sino cho'a dižə' de'en chene'e X̱a'anə' ben' əbseḻə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","De'e quinga bagwnia' le'e žlac ṉe'e zoa' len le'e. ");
INSERT INTO zavNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Na' X̱a'anə' əseḻe'e Spirit c̱he'enə' son ḻo'o la'aždao' le'e chonḻilažə'əle nada' nic̱h gaquəlenən le'e. Na' Spiritən' əgwzeɉni'in le'e yoguə'əḻoḻ de'en cheyaḻə' əṉezele na' gonən ca žɉəyeza'alažə'əle yoguə'əḻoḻ de'en bagwnia' le'e. ");
INSERT INTO zavNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Chona' par nic̱h so cuezle binḻo len xbab de'en yo'o ḻo'o yic̱hɉla'ažda'olen' ca binḻo zo chbeza' len xbab de'en yo'o ḻo'o yic̱hɉla'aždaogua'anə'. Nada' chona' ca zo chbezəchle binḻo len xbab de'en yo'o ḻo'o yic̱hɉla'ažda'olen' cle ca chso'on beṉac̱hən' par so cuezle binḻo len xbab de'en yo'o ḻo'o yic̱hɉla'ažda'olen'. Bito gaquəžeɉlažə'əle, nic žeble. ");
INSERT INTO zavNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Babenele can' bagwnia' de que yeya'a gan' zo X̱a'anə', na' de que yida' de'e yoblə gan' zolen'. Žalə' chaquele c̱hia' can' cheyaḻə'ənə', gobeile de'en yeya'a, c̱hedə' X̱a'anə' zaquə'əche' ca nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ṉa'a ža bagwnia' le'e de'e ca' antslə cuiṉə' sa'aquən par nic̱h catə' sa'aquən šeɉḻe'ele de que naca' ben' bagwnia' le'e. ");
INSERT INTO zavNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Bitoch gua'a dižə' zan len le'e c̱hedə' baza' gwxiye' de'en chnabia' beṉə' ca' cui chso'onḻilažə' nada' na' tiḻəlenən nada'. Pero bito soin nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Chona' con can' non X̱a'anə' mendad par nic̱h əṉeze beṉac̱hən' de que chacda' c̱he X̱a'anə'. Ṉa'a ža ḻešo'o šeɉəchcho. ");
INSERT INTO zavNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Nada' gwxaquə'əlebəda' ca to yag oba de'en naquə ḻe'ezelaogüe yag zaque'e. X̱a'anə' gwxaquə'əlebene' ca ben' chonši'i yaguən'. ");
INSERT INTO zavNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Na' le'e chonḻilažə'əle nada' gwxaquə'əlebele ca xozə' yaguən'. To to xoze'e ca' cui bi frot chbian, chc̱hogue'en. Na' to to xoze'e ca' de'e chəsə'əbia frot, chpe'en par nic̱h chbiachən frot zanch. ");
INSERT INTO zavNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Can' banaquə yic̱hɉla'ažda'olen' c̱hedə' chzenagle xtiža'anə' de'en babi'a len le'e. ");
INSERT INTO zavNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ḻesotezə ḻeso len nada' par nic̱h nada' gaquə sotezə soa' len le'e. Ca c̱he xozə' yag frotən', bito bi frot cuian to gwlazzen šə cui zon nca'an ḻe'e yaguən', can' naquən len le'e, bito gaquə gonḻe de'en chazlažə' Diozən' šə cui sotezə sole len nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","De'e yoblə əhia' de que nada' gwxaquə'əlebəda' ca yag oban' na' le'e ca xoze'enə'. Notə'ətezle šə zotezə zole len nada' na' nada' zotezə zoa' len le'e, gonchguale de'en chazlažə' Diozən'. Pero cuiczə gac gonḻe de'en chazlaže'enə' to gwlazle. ");
INSERT INTO zavNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Beṉə' cui zotezə zo len nada' əhoɉe' ca'aḻə, ca c̱he xozə' yag oban' de'e ca' chc̱hog ben' chonši'i yaguən' na' chəsə'əbižən. Nach chtobe'en chade'en yi' par chse'eyən. ");
INSERT INTO zavNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Šə le'e zotezə zole len nada' na' šə yo'o yic̱hɉle xtiža'anə' do tyempte, bitə'ətezə de'e chene'ele əṉable len orasyonṉə' de'e si'iczlenə'. ");
INSERT INTO zavNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yeḻə' bala'aṉ chzi' X̱a'anə' catə'ən chonchguale can' chazlaže'enə', na' bac̱h chlo'ele de que chonḻilažə'əle nada' na' chzenagle c̱hia' can' cheyaḻə' gonḻe šə bachonchguale de'en chazlaže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ca X̱a'anə' chaquene' c̱hia', ḻeczə ca' nada' bachacda' c̱hele. Ḻe'e so ḻegon ca gacbe'ile de que chacda' c̱hele. ");
INSERT INTO zavNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Šə chonḻe can' nona' mendadən', nachən' gacbe'ile de que chacda' c̱hele, ca nada' chona' can' non X̱a'anə' mendadən' na' chacbe'ida' de que chaquene' c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Bagwnia' le'e ca' par nic̱h sole mbalaz ca mbalazən' zoa' nada'. Che'enda' sole mbalaz juisy. ");
INSERT INTO zavNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","De'e nga chona' mendad gonḻe, gaquele c̱he lɉuežɉle tole yetole can' chacda' c̱hele. ");
INSERT INTO zavNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Notono nḻa' beṉə' chaquechene' c̱he lɉuežɉe' mazəchlə can' chaque ben' chsanḻažə' cuine' so'ot beṉə' ḻe' par gaquəlene' beṉə' migw c̱he' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Le'e nacle migw c̱hia' šə chonḻe can' nona' mendadən'. ");
INSERT INTO zavNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Bitoch ənia' le'e mos c̱hia' c̱hedə' beṉə' zɉənaquə mos bito zɉəṉezene' bi chon x̱anga'aque'enə'. Bania' le' migw c̱hia', c̱hedə' yoguə'əḻoḻ de'e ca' babenda' gwna X̱a'anə' babzeɉni'ida'an le'e. ");
INSERT INTO zavNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Caguə le'e gwleɉle nada' par naca' X̱anḻe. Nada' bagwleɉa' le'e par chonḻilažə'əle nada'. Na' chseḻa'a le'e par nic̱h šeɉəchle gonchguale can' chazlažə' X̱a'anə' na' caguə de'e te c̱he de'e ca' gonḻen'. Na' šə gonḻe can' chazlaže'enə', yoguə'əḻoḻ de'en əṉabele X̱a'anə' laogüe de'en chonḻilažə'əle nada', goṉe'en. ");
INSERT INTO zavNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","De'e nga de'en chona' mendad gonḻe, de que gaquele c̱he lɉuežɉle tole yetole. ");
INSERT INTO zavNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Bito yebanele de'en chəsə'əgue'i beṉə' ca' cui zɉənombia' Diozən' le'e. Ḻegon xbab de que zgua'atec nadan' besə'əgue'ine' antslə ca le'e. ");
INSERT INTO zavNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Žalə' nacle txen len beṉə' ca' cui zɉənombia' Diozən', gwsa'aquene' c̱hele can' chsa'aquene' c̱he beṉə' ca' zɉənaque' txen. Nada' bagwleɉa' le'e par naole nada', na' bitoch nacle txen len beṉə' ca' cui zɉənombia' Diozən', na' de'e na'anə' chəsə'əgue'ine' le'e. ");
INSERT INTO zavNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ḻe'e žɉsa'alažə' de'en bagwnia' le'e: “Notə'ətezə mos bito naque' blaoch ca x̱ane'enə'.” Can' baboso'olagzeɉə boso'olagzide' nada', ḻeczə can' yoso'olagzeɉə yoso'olagzide' le'e. Žalə' boso'ozenague' xtiža'anə', ḻeczə gosə'əzenague' xtižə'əlen'. ");
INSERT INTO zavNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Na' yoguə' de'e ca' so'one' len le'e c̱hedə' le'e chonḻilažə'əle nada' na' ḻega'aque' bito zɉənombi'e X̱a'anə' ben' bseḻə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Žalə' nada' cui bida', na' žalə' cui bia'a dižə' len ḻega'aque', bito zɉənape' doḻə' ca naquən' chəsə'əgue'ine' nada'. Na' ṉa'a cuiczə bi de bi yoso'ode'ine' par yesə'əne' cui bi doḻə' zɉənape'. ");
INSERT INTO zavNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ben' chgue'i nada', lenczə X̱a' nan' chgue'ine'. ");
INSERT INTO zavNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Žalə' cui bena' entr ḻega'aque' miḻagr de'e cuiṉə' gon ni to beṉə' yoblə, bito zɉənape' doḻə' ca naquən' chəsə'əgue'ine' nada'. Pero ṉa'a babesə'əle'ine' de'e ca' chona' na' bia'aczə chəsə'əgue'ine' nada' na' len X̱a'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pero na' chac ca' par nic̱h chac complir can' na Xtižə' Diozən' gan' nyoɉən nan: “Besə'əgue'ine' nada' sin cui bi bi de'e mal bena'.” ");
INSERT INTO zavNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Bagwnia' le'e de que seḻa'a Spirit c̱he X̱a' Diozən' par gaquəlenən le'e na' par əgwzeɉni'in le'e de'en naquə de'e ḻi. Spiritən' sa'an gan' zo X̱a'anə' la' seḻa'an par güe'en xtiža'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Na' ḻeczə ca' le'e güe'ele xtiža'anə', c̱hedə' bagwzole len nada' dezd catə'ən gwzolao chyix̱ɉui'a xtižə' X̱a' Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Bagwnia' le'e de'e ca' par nic̱h cui yebiguə'əle gosxanḻə. ");
INSERT INTO zavNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Yesyə'əbeɉe' le'e ḻo'o yo'odao' c̱hega'aque' ca'. Na' bazon əžin ža catə' notə'ətezə beṉə' se'enene' so'ote' le'e so'one' xbab yebei Diozən' ḻega'aque' de'en so'one' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","So'one' ca' len le'e c̱hedə' cui zɉənombi'e X̱a'anə' na' ni nada' cui zɉənombi'e. ");
INSERT INTO zavNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Na' bagwnia' le'e ca' par nic̱h catə' əžin ža gac ca' žɉəsa'alažə'əle de que bagwnia' le'e can' gaquən. Catə'ən gwleɉa' le'e par nacle disipl c̱hia' bito gwnia' le'e yoguə' de'e ca' gac c̱hele, c̱hedə' gwṉezda' socha' len le'e. ");
INSERT INTO zavNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Na' ḻa'aṉə'əczə yeya'a ṉa'a gan' zo X̱a'anə' ben' əbseḻə' nada', ni tole cui chṉabele nada' bi zeɉen de'en yeya'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Na' de'en bagwnia' le'e de'e ca' bachacchgüeile ḻo'o la'ažda'olen'. ");
INSERT INTO zavNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero de'e ḻi əchnia' le'e napən le'e cuent yeya'a, la' šə cui yeya'a Spirit c̱he Diozən' de'en gaquəlen le'e bito yedəson ḻo'o la'ažda'olen'. Na' de'en yeya'anə' əseḻa'an len le'e. ");
INSERT INTO zavNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Na' catə'əch yidə'ən əgwzeɉni'in beṉac̱hən' de que zɉənape' doḻə', əgwzeɉni'in ḻega'aque' de que naca' ḻe'ezelaogüe beṉə' güen, na' əgwzeɉni'in ḻega'aque' de que gatə' castigw zeɉḻicaṉe c̱he notə'ətezə beṉə' cui choso'ozenag c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Egwzeɉni'in ḻega'aque' de que zɉənape' doḻə' de'en cui chso'onḻilaže'e nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Egwzeɉni'in ḻega'aque' de que naca' ḻe'ezelaogüe beṉə' güen c̱hedə' yeya'a gan' zo X̱a'anə' na' bitoch le'ile nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Na' əgwzeɉni'in ḻega'aque' de que gatə' castigw zeɉḻicaṉe c̱he notə'ətezə beṉə' cui choso'ozenag c̱hia', c̱hedə' gwxiye' de'en chnabia' beṉə' ca' cui zɉənombia' Diozən' banchoglaon c̱hei de que si'in castigw zeɉḻicaṉe. ");
INSERT INTO zavNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ṉedech de'e zan de'e əṉia' le'e, pero zdebə naquən ṉa'a par šeɉni'ilen. ");
INSERT INTO zavNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pero catə' yedəso Spirit c̱he Diozən' ḻo'o la'ažda'olen' par əgwzeɉni'in le'e de'en naquə de'e ḻi, əgwsed əgwlo'in le'e yoguə'əḻoḻ de'en cheyaḻə' əṉezele c̱hia' nada'. Bito güe'en dižə' de'e bia'azəlaže'i sino güe'en bitə'ətezə dižə' de'en chzene X̱a'anə' ḻen na' c̱hix̱ɉue'in le'e biquə' de'e ze'e za'ac. ");
INSERT INTO zavNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Goṉən nada' yeḻə' bala'aṉ, c̱hedə' əgwzeɉni'in le'e c̱hia' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","X̱a'anə' babene' ca ṉezda' yoguə'əḻoḻ de'en ṉezene' na' de'e na'anə' gwnia' de que Spirit c̱he'enə' əgwzeɉni'in le'e de'e ca' ṉezda'. ");
INSERT INTO zavNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yeto tyemp dao' le'e bitoch le'ile nada'. Na' techlə yeto tyemp dao' yoblə na' yezle'ile nada' nach yeya'a gan' zo X̱a'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Na' baḻə neto' disipl c̱he' gož lɉuežɉto': ―¿Bi zeɉen de'e nga che'e chio'o de que yeto tyemp da'ozə na' bitoch le'ichone' na' de que techlə yeto tyemp dao' yoblə na' yezle'ichone'? ¿Na' bi zeɉen de'en ne' yeyeɉe' gan' zo X̱e'enə'? ");
INSERT INTO zavNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Bi zeɉen de'en ne' yeto tyemp da'ozə ža? Cuili bixc̱hen' ne' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Na' gocbe'i Jeso'osən' de que chene'eto' ṉabeto'one' bi zeɉenṉə', na' gože' neto': ―¿Ede'e ngan' de'en chṉabe lɉuežɉle? ¿Echene'ele əṉezele bi zeɉen ca de'en gwnia' le'e de que yeto tyemp da'ozə na' bitoch le'ile nada', na' techlə yeto tyemp dao' yoblə na' yezle'ile nada'? ");
INSERT INTO zavNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","De'e ḻi chnia' le'e de que bazon cuežle na' yegüine'ele na' beṉə' ca' cui zɉənombia' Diozən' yesyə'əbeine'. Yeyašə'əlažə'əle pero con to tyemp da'ozən' na' techlə yebeile. ");
INSERT INTO zavNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Šə catə' chzan to no'olə, chžaglaogüe' lao chaque' bes c̱he yeḻə' sanṉə'. Pero na' catə' bagolɉə bda'onə' bitoch chone' xbab c̱he de'en bžaglaogüe'enə' de'e tant chebeine' de que bagolɉə yeto beṉac̱h yežlyo nga. ");
INSERT INTO zavNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ḻeczə can' len le'e, ṉa'a sole trist, pero catə' yežagcho de'e yoblə cana' yebeile ḻo'o la'ažda'olen'. Na' ni to cono yeca'a yeḻə' chebei c̱helen'. ");
INSERT INTO zavNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Na' catə' babžin ža soa' gan' zo X̱a'anə' de'e yoblə bito yažɉele bi əṉable gona' par le'e. De'e ḻi əchnia' le'e bitə'ətezə de'e əṉabele X̱a'anə' laogüe de'en chonḻilažə'əle nada', goṉe'en par le'e. ");
INSERT INTO zavNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Xte ṉa'a cuiczə bi ṉe'e ṉabele X̱a'anə' ye'elene' de que chṉablen por ni c̱he de'en chonḻilažə'əle nada'. Na' ṉa'a ḻeṉabe X̱a'anə' bi de'en əṉabelene' ye'elene' ca', na' gone' can' əṉabelene' par nic̱h sole mbalaz juisy. ");
INSERT INTO zavNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","De'e zan de'e ca' bagwnia' le'e babzeɉni'ida'an len jempl. Ežin žan' catə' bitoch əgwzeɟni'ida' le'e len jempl sino clar c̱hix̱ɉue'ida' le'e c̱he X̱a'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Na' catə' babžin ža soa' gan' zo X̱a'anə' de'e yoblə, cana'ach əṉabele X̱a'anə' bi de'en əṉabelene' ye'elene' de que chṉablen por ni c̱he de'en chonḻilažə'əle nada'. Na' bito ənia' le'e de que nada' ṉaba' lao X̱a'anə' par nic̱h gaquəlene' le'e. ");
INSERT INTO zavNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Cuinczə X̱a'anə' chaquene' c̱hele por ni c̱he de'en bachaquele c̱hia' na' de'en bacheɉḻe'ele de que gwza'a gan' zoe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Gan' zo X̱a'anə' gwza'a babida' yežlyo nga. Na' ṉa'a yeza'a yežlyo nga na' yeya'a gan' zo X̱a'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Na' neto' disipl c̱he' gožto'one': ―Ṉa'a cho'o dižə'ən clar. Bito cho'o dižə' len jempl de'e cui cheɉni'ito'. ");
INSERT INTO zavNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Na' chacbe'ito' de que ṉez nḻe'ido' xbab c̱he beṉac̱hən'. Bito chyažɉdo' no əṉa le' bin' chse'ene'ene' yesə'əṉezene'. De'e na'anə' cheɉḻe'eto' de que gwza'o gan' zo Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Na' gwna Jeso'osən' neto': ―¿Eṉa'a cheɉḻe'ele ža? ");
INSERT INTO zavNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Gwžin or na' ṉa'a baza'an catə' gasə'əlasle. To tole ca'ale xṉez c̱he c̱hele na' əgwcua'aṉle toza'. Pero caguə zoa' toza'anə' c̱hedə' X̱a'anə' zoe' len nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Bagwnia' le'e ca' par nic̱h so cuezle binḻo len xbab de'e yo'o ḻo'o yic̱hɉla'ažda'olen' laogüe de'en chonḻilažə'əle nada'. Yežlyo nga c̱hi' saquə'əle, pero bito žeble, nada' babena' par nic̱h gwxiye'enə' cuich ṉabia'an le'e. ");
INSERT INTO zavNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Gwde gwna Jeso'osən' ca', bgüie' yobalə na' gwne': ―X̱a', babžin or par gaquə c̱hia' can' babžio' bia' gaquə. Beṉ nada' yeḻə bala'aṉ par nic̱h ḻeczə ca' nada' goṉa' le' yeḻə' bala'aṉ, nadan' naca' Xi'iṉo'. ");
INSERT INTO zavNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Babeṉo' nada' yeḻə' chnabia' lao yoguə' beṉac̱h par nic̱h chnežɉua' yeḻə' mban zeɉḻicaṉe c̱he yoguə'əḻoḻ noquə' beṉə' ca' bagwleɉo' par chso'onḻilaže'e nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na' beṉə' ca' zɉənapə yeḻə' mban zeɉḻicaṉen' zɉənombi'e le' ca tozon' zaco'o par güe'ela'oto', na' ḻeczə zɉənombi'e nada' Jesocrist ben' əbseḻo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Babeṉa' le' yeḻə' bala'aṉ yežlyo nga ca de'en babeyož bena' yoguə'əḻoḻ de'en gwlo'o lao na'a gona'. ");
INSERT INTO zavNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ṉa'a ža X̱a', ben par nic̱h yezi'a yeḻə' bala'aṉ c̱hia'anə' catə' yela'a gan' zo'onə' ca yeḻə' bala'aṉ de'en gwdapa' catə'ən gwzoa' len le' antslə ze'e x̱e yežlyo nga. ");
INSERT INTO zavNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Bagwleɉo' baḻə beṉac̱h par chso'onḻilaže'e nada' na' bablo'iga'acda'ane' naquən' naquə yic̱hɉla'aždaogo'onə' na' naquən' chono'. Zɉənaque' xi'iṉo', na' beno' par nic̱h chso'onḻilaže'e nada' na' chso'one' can' nono' mendadən'. ");
INSERT INTO zavNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Na' bazɉəṉezene' de que yoguə'əḻoḻ de'en chona' na' yoguə' dižə' de'en cho'a za'an c̱he cuino'. ");
INSERT INTO zavNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Babe'elena' ḻega'aque' dižə' de'en beno' mendad güe'elenga'aca'ane', na' bazɉənonen c̱hega'aque'. Na' bachsa'acbe'ine' de que de'e ḻiczə gwza'a gan' zo'onə', na' chse'eɉḻe'e de que len' əbseḻo'o nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Chṉabda' le' gaquəleno' ḻega'aque'. Caguə chṉabda' le' gaquəleno' yoguə' beṉac̱hən', sino gaquəleno' beṉə' ca' zɉənaquə xi'iṉo', beṉə' ca' gwleɉo' par chso'onḻilaže'e nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Na' yoguə' beṉə' ca' chso'onḻilažə' nada' zɉənaque' xi'iṉo'. Na' ca'aczən' naquən, notə'ətezə beṉə' zɉənaquə xi'iṉo' ḻeczə zɉənaque' xi'iṉa'. Echzi'a yeḻə' bala'aṉ de'en chso'onḻilaže'e nada' na' de'en chso'one' bichlə de'en chso'one'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na' ṉa'a caguə socha' yežlyo ngan', pero beṉə' quinga ṉitə'əcze' yežlyo nga. Nada' bazeza'a gan' zo'onə'. X̱a', naco' ḻe'ezelaogüe beṉə' la'aždao' xi'ilažə'. Na' ca naquə beṉə' ca' gwleɉo' par chso'onḻilaže'e nada', bcuasə' bcue'eɉga'aque' len de'e malən' por yeḻə' chnabia' c̱hio'onə'. Bcuasə' bcue'eɉga'aque' len de'e malən' par nic̱h əsa'aque' tozə len lɉuežɉga'aque'enə' ca chio'o naccho tozə. ");
INSERT INTO zavNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Bedote žlac zoa' len ḻega'aque' babcuasə' bcue'eɉga'aca'ane' len de'e malən' por yeḻə' chnabia' c̱hio'onə'. De'e na'anə' ni toga'aque' cui gwžiayi' sino tozə ben' banaquəczən cuiayi'e par nic̱h gaquə complir can' na Xtižo'onə' de'en nyoɉən. ");
INSERT INTO zavNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Na' ṉa'a bazeza'a gan' zo'onə', na' cho'a dižə' quinga lao orasyonṉə' žlac ṉe'e zoa' yežlyo nga par nic̱h ḻega'aque' ṉitə'əchgüe' mbalaz ca mbalazən' zoa' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nada' babe'elenga'aca'ane' xtižo'onə'. Pero na' beṉə' ca' cui zɉənombia' le' chəsə'əgue'ine' beṉə' ca' chso'onḻilažə' nada' por ni c̱he de'en cuich zɉənaque' txen len ḻega'aque', ca nada' cui naca' txen len beṉə' ca' cui zɉənombia' le'. ");
INSERT INTO zavNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Na' ca naquə beṉə' ca' chso'onḻilažə' nada', caguə chṉabda' le' yeca'aga'aco'one' lao yežlyo ngan', sino chṉabda' le' par əgwcuasə' əgwcue'eɉga'aco'one' len de'en chon gwxiye'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bito zɉənaque' txen len beṉə' ca' cui zɉənombia' le' ca nada' cui naca' txen len beṉə' ca' cui zɉənombia' le'. ");
INSERT INTO zavNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ben par nic̱h beṉə' ca' chso'onḻilažə' nada' so'on cuinga'aque' lažə' na'onə' laogüe de'en bazɉənombi'e dižə' ḻi c̱hio'onə'. Yoguə'əḻoḻte de'en babzeɉni'ido' ḻega'aque' naquən de'e ḻi. ");
INSERT INTO zavNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Len' bseḻo'o nada' yežlyo nga par chzeɉni'ida' beṉac̱hən' dižə' ḻi c̱hio'onə', na' ḻeczə ca' nada' bachseḻa'a ḻega'aque' par yoso'ozeɉni'ine' beṉac̱hən' dižə' ḻi c̱hio'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Zoa' chon cuina' lažə' na'onə' c̱hedə' chacda' c̱he beṉə' ca' chso'onḻilažə' nada'. Na' chona' ca' par nic̱h ḻega'aque' so'on cuinga'aque' lažə' na'onə' laogüe de'en bazɉənombi'e dižə' ḻi c̱hio'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Na' ca naquə chṉaba' gaquəleno' beṉə' ca', bito chṉaba' gaquəleno' ḻega'acze' sino ḻeczə gaquəleno' beṉə' ca' so'onḻilažə' nada' catə' əse'enene' dižə' de'en əsoe' beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","X̱a', ben par nic̱h yoguə'əḻoḻe' əsa'aque' tozə len lɉuežɉga'aque' ca le' naco' tozə len nada' na' nada' naca' tozə len le'. Ben ca əsa'aque' tozə laogüe de'en zɉəngode'e txen len chio'o, par nic̱h beṉə' ca' cui zɉənombia' le' se'eɉḻe'e de que len' əbseḻo'o nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Babeno' par nic̱h chsa'acbe'i beṉə' de que noṉo' nada' yeḻə' bala'aṉ, ca'aczən' chona' nada' par nic̱h chsa'acbe'ine' de que chnežɉua' ḻega'aque' yeḻə' bala'aṉ. Na' chona' ca' par nic̱h əsa'aque' tozə len lɉuežɉga'aque' ca chio'o naccho tozə. ");
INSERT INTO zavNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ḻega'aque' zɉəngode'e txen len nada' na' nada' ngoda'a txen len le' nic̱h yoguə'əcho gaccho tozə na' ca' beṉə' ca' cui zɉənombia' le' yesə'əṉezene' de que len' əbseḻo'o nada' na' de que chacdo' c̱he beṉə' ca' zɉəngodə' txen len nada' can' chacdo' c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","X̱a', bachacdo' c̱hia' antslə ze'e x̱e yežlyo nga. De'e na'anə' beṉo' nada' yeḻə' chey che'eni'inə'. Na' che'enda' de que beṉə' ca' bagwleɉo' par chso'onḻilaže'e nada' ṉite'e len nada' gan' so'anə' par nic̱h yesə'əle'ine' yeḻə' chey che'eni' c̱hia'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","X̱a', le' naco' ḻe'ezelaogüe beṉə' güen, na' ca naquə beṉə' ca' cui chso'onḻilažə' nada' bito zɉənombi'e le', pero nada' nombi'a le' na' beṉə' ca' bagwleɉo' par chso'onḻilaže'e nada' bazɉəṉezene' de que len' əbseḻo'o nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Na' babena' par nic̱h zɉəṉezene' can' naquə yic̱hɉla'aždaogo'onə' na' can' chono', na' ṉe'e gonchcza' ca yesə'əṉezene'. Chzeɉni'iga'acda'ane' can' naquə yic̱hɉla'aždaogo'onə' na' can' chono' par nic̱h əsa'acbe'ine' de que chacdo' c̱hega'aque' can' chacdo' c̱hia' nada' na' par nic̱h sotezə soa' len ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Na' ca beyož gwna Jeso'osən' de'e ca', neto' disipl c̱he' gwza'ato' len ḻe' gwyeɉto' šḻa'a yao Sedron gan' gotə' to güert, na' gwyo'oto' len ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Na' Jodən' ben' banaquən gone' Jeso'osən' lao na' beṉə' ca' chəsə'əgue'i ḻe' nombi'e güertən', c̱hedə' zan las bagwyeɉto' len Jeso'osən' ḻo'o güertən'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Na' bx̱oz əblao ca' na' beṉə' fariseo ca' boso'oseḻe'e x̱oṉɉ soḻdad na' len x̱a'ag yo'odao' ca' zɉa'aclene' Jodən' par ɉəsə'əxene' Jeso'osən' ḻo'o güertən'. Zɉa'aque' gan' zo Jeso'osən' zɉənox̱e'e lintern, yi' yech na' spad. ");
INSERT INTO zavNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jeso'osən' baṉezene' yoguə'əḻoḻ de'en gaquə c̱he', nach bchoɉe' ɉəšague' ḻega'aque' nach gože': ―¿Non' cheyilɉle? ");
INSERT INTO zavNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Na' gwse'ene': ―Jeso'os beṉə' Nasaret. Na' gož Jeso'osən' ḻega'aque': ―Nada'anə'. Na' len Jodən' ḻega'aque', ben' banaquən gone' Jeso'osən' lao na'aga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Na' catə' gože' ḻega'aque': “Nada'anə'”, ḻe'e besyə'əbiguə'əte' gosxanḻə na' gosə'əbix̱e' gwsa'ate'e lao yon'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Na' de'e yoblə gože' ḻega'aque': ―¿Non' cheyilɉle? Na' ḻega'aque' gosə'əze'ene': ―Cheyilɉto' Jeso'os beṉə' Nasaret. ");
INSERT INTO zavNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Na' gwna Jeso'osən': ―Bagwnia' le'e de que nada'anə'. Na' šə nadan' cheyilɉle, ḻe'e güe' latɉə žɉəya'ac beṉə' quinga. ");
INSERT INTO zavNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Gože' ca' par nic̱h goc complir can' gwne' de que ni to beṉə' ca' bagwleɉ Diozən' par chso'onḻilaže'ene' cui yesə'əbiayi'e. ");
INSERT INTO zavNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Na' Simon Bedən' no'e to spad na' golɉe'en gwc̱hogue' nag ḻicha xmos beṉə' gwnabia' c̱he bx̱oz ca'. Na' mosən' le' Malco. ");
INSERT INTO zavNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Na' Jeso'osən' gože' Bedən': ―Bego'o spad c̱hio'onə' ḻo'o liže. ¿Echaquele gonḻe par nic̱h cui c̱hi' saca'a can' babsi' X̱a'anə' xṉeze c̱hi' saca'a? ");
INSERT INTO zavNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nach soḻdad ca' len capitan c̱hega'aque'enə' na' zɉəlen x̱a'ag yo'odao' c̱he ṉasyon Izrael c̱heton' gosə'əzene' Jeso'osən' na' boso'oc̱heɉe'ene'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Na' gosə'əc̱he'ene' zgua'atec lao Anas xta'obin' c̱he Caifasən'. Caifasən' naquəche' bx̱oz əblao c̱he ṉasyon c̱heton' ca izən'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Na' Caifas na'anə' babnežɉue' beṉə' blao c̱he ṉasyon Izrael c̱heton' consejon' de que napən ḻega'aque' cuent tozə ben' so'ote' lgua'a yesə'əbiayi' yogue'e len ṉasyon c̱heto'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Bedən' na' nada' ɉənaoto' Jeso'osən'. Na' nombia' bx̱oz əblaonə' nada'. De'e na'anə' goc gwyo'a len Jeso'osən' chyo'o c̱he bx̱oz əblaonə'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Na' Bedən' bega'aṉe' cho'a puertən' fuerlə. Na' bechoɉa' na' be'elena' no'olən' chapə cho'a puertən' dižə', nach gwlo'o no'olən' Bedən' c̱hedə' nombia' bx̱oz əblaonə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nach no'olən' chapə cho'a puertən' gože' Bedən': ―¿Ecaguə leno' len' naco' disipl c̱he be'enə'? Na' gwne': ―Bito lena' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Na' mos ca' na' x̱a'ag yo'odao' ca' bagosə'əbeque' yi' ya'alɉ c̱hedə' chac zag. Na' zɉəzeche' cho'a yi'inə' par chəsyə'əže'ine'. Na' len Bedən' zeche' len ḻega'aque' cho'a yi'inə' par cheže'ine'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na' bx̱oz əblaonə' gwṉabene' Jeso'osən' c̱he neto' disipl c̱he' na' c̱he de'en chsed chlo'ine'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Nach Jeso'osən' gože'ene': ―Nada' zaquə'əlao babi'a dižə' len beṉac̱hən'. Syempr babsed blo'ida' ḻo'o yo'odao' c̱hecho ca' na' ḻeczə ca' ḻo'o yo'odao' əblaonə' gan' chəsə'əžag yoguə' beṉə' Izrael gwlaž c̱hechon'. Bito bi bi dižə' ṉe'e gua'a bgašə'əzə. ");
INSERT INTO zavNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Bixc̱hen' chṉabdo' nada'? Gwṉabe beṉə' ca' bagwse'ene de'en babsed bablo'ida'. Ḻega'aque' zɉəṉezene' bi dižə'ən babe'elenga'aca'ane'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Gwde gwna Jeso'osən' ca', to x̱a'ag yo'odao' beṉə' zechan' gwdape'e x̱ague'enə', nach gože'ene': ―¿Eca' choži'o xtižə' ben' naquə bx̱oz əblaonə'? ");
INSERT INTO zavNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Nach gož Jeso'osən' ḻe': ―Šə bi de'e mal bagwnia', be' dižə' c̱he bi de'e malən'. Na' šə gwnia' de'e güen, ¿bixc̱hen' chgapo'o nada'? ");
INSERT INTO zavNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nach Anasən' bdie' Jeso'osən' ncheɉe' lao Caifasən' ben' naquəch bx̱oz əblaonə'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Na' Bedən' ṉe'e zeche' cho'a yi'inə' par cheže'ine' na' beṉə' ca' zɉəzecha na' gosə'əze'ene': ―¿Ecaguə ḻeczə lenon' naco' disipl c̱he be'enə'? Na' bito gwc̱hebe', na' gwne': ―Bito lena' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","To xmos beṉə' gwnabia' c̱he bx̱oz ca' naque' famiḻy c̱he ben' əgwc̱hog Bedən' nague', na' gože' Bedən': ―¿Ecaguə zle'ida' le' len Jeso'osən' ḻo'o güertən'? ");
INSERT INTO zavNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Na' Bedən' de'e yoblə bito gwc̱hebe', na' ḻe'e gwchežte to ḻecw. ");
INSERT INTO zavNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Na' do che'eni'iḻas bx̱oz əblao ca' gosə'əbeɉe' Jeso'osən' gan' zo Caifasən' na' gosə'əc̱he'ene' gan' chon Pilatən' yeḻə' jostisən'. Na' ḻega'aque' bito gwso'e len Jeso'osən' gan' chon Pilatən' yeḻə' jostisən' c̱hedə' segon costombr c̱hega'aque' bito gaquə əsa'ogüe' de'e ca' gwso'one' par xše' lṉi pascon' šə so'e ḻo'o yo'o c̱he beṉə' ca' cui chəsə'ənao costombr c̱hega'aque' ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","De'e na'anə' Pilatən' bchoɉe' gan' nitə' beṉə' blao c̱he ṉasyon Izrael c̱heton' na' gože' ḻega'aque': ―¿Bi ben bengan'? ¿Ede bi de'e chaole xya? ");
INSERT INTO zavNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Na' gwse'ene': ―Žalə' benga cui naque' beṉə' mal bito əgwdeto'one' lao na'onə'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Na' gož Pilatən' ḻega'aque': ―Ḻe'e yec̱he'e na' ḻe'e gon yeḻə' jostis c̱he'enə' segon ḻei c̱helen'. Na' beṉə' blao c̱he ṉasyon Izrael c̱heton' gwse'ene': ―Bito bi lsens c̱heto' de par no gotto'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ca goquən' goc complir can' gwna Jeso'osən' bzeɉni'ine' naquən' gaquə so'ote'ene'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nach Pilatən' beyo'e gan' chone' yeḻə' jostisən', na' goxe' Jeso'osən' nach gože'ene': ―¿Elen' naco' Rei c̱he beṉə' Izrael ca'? ");
INSERT INTO zavNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jeso'osən' gože'ene': ―¿Econ de'e babidzən yic̱hɉo'onə' nao' ca', o šə beṉə' yoblə gosə'əne' le' ca'anə'? ");
INSERT INTO zavNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatən' gože'ene': ―¿Echacdo' naca' nada' beṉə' Izraelən'? Beṉə' gwlaž c̱hio' ca' na' bx̱oz əblao c̱hele can' boso'odie' le' lao na'a nga. ¿Bi de'e xiṉɉən' beno'? ");
INSERT INTO zavNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nach Jeso'osən' goze'ene': ―Nža'alə can' chnabia' nada' na' nža'alən' chəsə'ənabia' notə'ətezəchlə beṉə' gwnabia'. Yeḻə' gwnabia' c̱hi'anə' bito za'an c̱he beṉə' ža' yežlyo nga. Žalə' za'an c̱he beṉə' ža' yežlyo nga beṉə' ca' chəsə'ənabi'anə' yesə'ədiḻe' par nic̱h cui gaca' lao na' beṉə' Izrael gwlaž c̱hia' quinga. Pero yeḻə' chnabia' c̱hia'anə' bito za'an c̱he yežlyo nga. ");
INSERT INTO zavNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Nach gož Pilatən' ḻe': ―¿Ena' rein' naco'? Na' gwna Jeso'osən': ―De'e ḻin' bagwnao' de que nada' naca' rei. Babida' yežlyo nga golɉa' par nic̱h ṉabi'a na' par nic̱h əgwzeɉni'ida' beṉac̱hən' dižə' ḻi c̱he Diozən'. Beṉə' ca' bachoso'ozenag c̱he dižə' ḻi c̱he Diozən' ḻeczə choso'ozenague' c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Nach gož Pilatən' le': ―Cuili bin' naquə dižə' ḻin'. Na' beyož gwna Pilatən' ca' bchoɉe' yetši'i gan' nitə' beṉə' blao c̱he ṉasyon Izrael c̱heton' na' gože' ḻega'aque': ―Bito bi chla'alaon šə bi doḻə'ənə' napə benga. ");
INSERT INTO zavNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Na' ca naquə de costombr c̱hele de que to beṉə' presən' gwsana' lao lṉi pascon', ¿əchene'ele gwsana' benga naquə Rei c̱he le'e beṉə' Izrael? ");
INSERT INTO zavNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nach gwso'osye'e gosə'əne': ―Bito gwsano' be'ena'. Barrabas na' əgwsano'. Len Barrabasən' naque' to beṉə' bguan. ");
INSERT INTO zavNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nach ben Pilatən' mendad gosə'əyine' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Na' soḻdad ca' gwso'one' to coron de xis yešə' na' boso'ožine'en yic̱hɉe'enə'. Na' boso'oguacue'ene' to cḻas lachə' morad ca de'en chəsə'əc̱hin rei ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Na' gwo'onene' borl gosə'əne': ―Biba Rei c̱he beṉə' Izrael. Na' gosə'əgape'e x̱ague'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Nach Pilatən' bchoɉe' chyo'onə' de'e yoblə na' gože' beṉə' Izrael ca' ža'anə': ―Ṉa'a cueɉa'ane' par nic̱h əṉezele ca xyan' de'en chaole c̱he', ni to de'e xiṉɉ cui cheželda' šə bin' none'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Na' bchoɉ Jeso'osən' chyo'onə', zo coron de yešə'ənə' yic̱hɉe'enə', na' nyaze' lachə' moradən'. Na' gož Pilatən' ḻega'aque': ―Ḻe'e ggüia, nga zecha be'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Na' bx̱oz əblao ca' na' x̱a'ag yo'odao' ca', catə' besə'əle'ine' ḻe' gwso'osye'e gosə'əne': ―¡Bde'e ḻe'e yag corozən'! ¡Bde'e ḻe'e yag corozən'! Pilatən' gože' ḻega'aque': ―Ḻe'e ḻec̱he'e na' ḻegwde'e ḻe'e yag corozən' c̱hedə' ca xyan' chaole c̱he', ni to de'e xiṉɉ cui cheželda' šə bin' none'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Na' gwse' beṉə' blao c̱he ṉasyon Izrael c̱heton' ḻe': ―Segon ḻei c̱heto' de'en de cheyaḻə' gotchone' c̱hedə' ne' naque' xi'iṉ Dioz ḻa'aṉə'əczə naque' con to beṉac̱hzə. ");
INSERT INTO zavNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Bachžeb Pilatən' ca de'en bachaquən', na' catə' benene' gosə'əne' ca' c̱he Jeso'osən' nachlə bžebəche'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nach beyo'o Pilatən' len Jeso'osən' de'e yoblə gan' chone' yeḻə' jostisən'. Na' gože' Jeso'osən': ―¿Ga beṉə' le'? Pero Jeso'osən' bito boži'e xtiže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nach Pilatən' gože'ene': ―¿Ecui choži'o xtiža'anə'? ¿Ecui ṉezdo'onə' nada' napa' yeḻə' chnabia' par gwsana' le' na' napa' yeḻə' chnabia' par əgwda' le' ḻe'e yag corozən'? ");
INSERT INTO zavNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jeso'osən' gože'ene': ―Bito bi yeḻə' gwnabia' napo' len nada' žalə' Diozən' cui noṉe'en le'. Na' ben' əbde nada' lao na'onə' doḻə' xench nape' cle ca le'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nach gwdilɉlažə' Pilatən' naclə gone' əgwsane'ene'. Pero beṉə' blao c̱he ṉasyon Izrael c̱heton' gwso'osye'e gosə'əne': ―Šə əgwsano' benga, contr Rei Sesar nan' gono' šə ca'. Notə'ətezə beṉə' ne' de que naque' rei, contr Rei Sesarən' chone'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","14","Nach Pilatən' beyož benene' de'en əgwse' beṉə' ca' ḻe', gwleɉe' Jeso'osən' chyo'onə'. Na' ḻeczə bchoɉ ḻe' chyo'onə' gan' nao yeɉ, gan' nzi'in dižə' ebreo Gabata. Na' gwchi'e gan' chbi'e catə' chone' yeḻə' jostisən'. Nach gože' beṉə' blao c̱he ṉasyon Izrael c̱heton': ―Nga zo Rei c̱helen'. Na' do gobiž catə'ən gože' ḻega'aque' ca', na' beṉə' Izrael gwlaž c̱heto' ca' choso'osi'ini'e par lṉi pascon' žanə'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nach ḻega'aque' gwso'osye'e gosə'əne': ―¡Gwcue'e! ¡Bde'e ḻe'e yag corozən'! Na' gož Pilatən' ḻega'aque': ―¿Erei c̱hele nga gona' mendad yoso'ode'ene' ḻe'e yag corozən'? Nach bx̱oz əblao ca' gwse'ene': ―Caguə rei c̱heto' benga. Tozə Sesarən' naque' rei c̱heto'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ca' goquən' bdie' Jeso'osən' lao na'aga'aque'enə' par te'e ḻe'e yag corozən'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nach gosə'əc̱he'e Jeso'osən' fuerlə syodan' gan' boso'oda' soḻdad ca' ḻe' ḻe'e yag corozən'. Latɉən' nzi'in Golgota dižə' ebreo, zeɉen dižə' latɉə c̱he yic̱hɉ beṉə' guat. Na' gwze'e zde' noa' coroz c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Na' Golgota na' boso'ode'ene' ḻe'e yag corozən'. Na' len yec̱hopə beṉə' yoblə boso'ode'e ḻe'e yec̱hopə yag coroz tgüeɉe' cuite'enə', Jeso'osən' gwyo'e gwchoḻ. ");
INSERT INTO zavNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Na' Pilatən' bene' mendad byoɉ to c̱hopə ḻetr de'e gwda' yic̱hɉ yag coroz c̱he Jeso'osən', boso'ozoɉe'en nan: “Jeso'os beṉə' Nasaret, Rei c̱he beṉə' Izrael.” ");
INSERT INTO zavNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Boso'ozoɉe'en dižə' ebreo, dižə' griego na' dižə' latin. Na' zan beṉə' Izrael gwlaž c̱heton' boso'olabe' de'enə' byoɉən', c̱hedə' gan' gwda' Jeso'osən' ḻe'e yag corozən' naquən gaḻə'əzə syodan'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","De'e na'anə' beṉə' ca' zɉənaquə bx̱oz əblao c̱he ṉasyon Izrael c̱heton' gwse'e Pilatən': ―Bša'an par nic̱h cui ṉan de que naque' rei c̱he neto' beṉə' Izrael, sino ṉan de que ḻen' gwne' naque' rei c̱heto'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Na' Pilatən' gwne': ―De'en bena' mendad boso'ozoɉe', banyoɉənṉə'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nach soḻdad ca', beyož boso'ode'e Jeo'osən' ḻe'e yag corozən' gosə'əzi'e xalane'e ca' na' gwso'one'en taplə, to part güeɉən gosə'əzi'e. Na' ḻeczə ca' gosə'əzi'e xe'enə' de'en naquə ca xadoṉ cha'o. Pero lachə'ənə' naquən de to golizə. Bito bi dia nyazən. ");
INSERT INTO zavNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Na' gwse'e lɉuežɉe': ―Bito əgwzoxɉchon' sino gonchon rif. Yešc no yechelən. Na' gwso'one' ca' par nic̱h goc can' nyoɉ Xtižə' Diozən' gan' nan: “Yosyo'ole'e xalana'anə' entr ḻega'aque' na' so'one'en rif.” Na' ca'anə' gwso'on soḻdad ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Na' cuit coroz c̱he Jeso'osən' zecha xne'enə' len beṉə' bile'enə' na' len Maria no'ol c̱he Cleofas na' Maria beṉə' Magdala. ");
INSERT INTO zavNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Na' catə' Jeso'osən' ble'ine' zecha xne'enə' gaḻə'əzə na' nada' zecha' cuite'enə', nach gože'ene': ―Naogüe, benga gaque' ca xi'iṉo'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nach gože' nada': ―Bži'ilažə' xna'a nga ca xna'onə'. Na' lao žanə' nada' gwcua'ane' bena'ane' ca famiḻy c̱hia'acza'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jeso'osən' ṉezene' de que bac̱h goc yoguə'əḻoḻ de'en cheyaḻə' gaquən. Na' par nic̱h gaquə can' na Xtižə' Diozən' de'enə' nyoɉən gwne': ―Chbilda' nis. ");
INSERT INTO zavNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na' de latə' bino corrient de'e yožə to ḻo'o xguaguə dao'. Na' to beṉə' bosgaže'e to sponj len bino corrientən' na' bosšine'en cho'a Jeso'osən' bso'en to lao xis de'en ne' isopo. ");
INSERT INTO zavNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Na' beyož gwxop Jeso'osən' bino corrientən' gwne': ―Bac̱h goc yoguə'əḻoḻ de'en cheyaḻə' gaquən'. Na' bc̱hequə' yic̱hɉe'enə' gote'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nach beṉə' blao c̱he ṉasyon Izrael c̱heton' gosə'əṉabene' Pilatən' gone' mendad yesə'əyišɉw soḻdad ca' ṉi'a beṉə' ca' zɉəda' ḻe'e yag corozən' nic̱h yob sa'ate' par nic̱h ca' yesyə'əque'e ḻega'aque'. Bito gwse'enene' yesyə'əga'aṉ cuerp ca' ḻe'e yag corozən' xte yeteyo, c̱hedə' yeteyon' naquən ža dezcanz na' ža lṉi xen. ");
INSERT INTO zavNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nach Pilatən' bene' mendad ɉa'ac soḻdad ca' na' gosə'əyišɉue' c̱hopə la'a ṉi'a ben' boso'ode'e to šḻa'a cuit Jeso'osən'. Na' ḻeczə ca' gwso'one' len ben' gwda' ḻe'e yag corozən' cuite'en yešḻa'a. ");
INSERT INTO zavNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Na' catə' besə'əžine' gan' da' Jeso'osən', besə'əle'ine' bagote', na' bito gosə'əyišɉue' ṉi'e ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero to soḻdadən' gode'e lanzən' cuit ḻe'e Jeso'osən', na' ḻe'e bchoɉten chen len nis. ");
INSERT INTO zavNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nada' ble'ida' can' goquən' na' ṉezda' de que dižə' de'en cho'a naquən de'e ḻi. Na' cho'a dižə'ənə' par nic̱h lenczə le'e šeɉḻe'ele. ");
INSERT INTO zavNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Goc ca' par nic̱h goc complir can' na Xtižə' Diozən' de'en nyoɉən gan' nan: “Ni to žit yo'e cui yesə'əyišɉue'.” ");
INSERT INTO zavNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Na' len yeto gan' nan: “Yoso'ogüie' ben' əgwsa'ade'e lanzən'.” ");
INSERT INTO zavNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Na' gwde na' Jwse beṉə' Arimatea gwṉabene' Pilatən' gwnežɉue' lsens yeque'e cuerp c̱he Jeso'osən'. Na' Pilatən' be'e lsens. Nach gwyeɉ Jwsen' na' beque'e cuerpən'. Jwsen' naque' disipl c̱he Jeso'osən' pero bgašə'əzə por ni c̱he bžebe' beṉə' blao c̱he ṉasyon Izrael c̱heton'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Na' ḻeczə gwyeɉlen Nicodemon' ḻe' ben' bagwyeɉ antslə gan' zo Jeso'osən' to še'elə. Na' Nicodemon' no'e to de'e chḻa' zix̱ de'e none' len mirra na' aloes, ca do tapa robən'. ");
INSERT INTO zavNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Na' boso'oc̱hele' cuerp c̱he Jeso'osən' sint de lachə' na' len de'en chḻa' zix̱ən', ca costombr c̱he neto' beṉə' Izrael catə'ən chcuašə'əto' beṉə' guat. ");
INSERT INTO zavNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na' gaḻə'əzə gan' gwso'ote' Jeso'osən' ḻe'e yag corozən' gotə' to güert. Na' ḻo'o güertən' bazo to bloɉ ba de'e cobə de'e bagwc̱he'eṉ Jwsen' ḻe'e yeɉ ga cuiczə no beṉə' guat ṉe'e šo'o. ");
INSERT INTO zavNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Na' boso'ocuaše'e Jeso'osən' ḻo'o bloɉ banə' laogüe de'e zon gaḻə'əzə c̱hedə' chsa'acbyenene' por ni c̱he de'e naquə yeteyo ža dezcanz na' ža xen c̱he lṉi pascon'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Na' bal dmigw Maria beṉə' Magdalan' gwyeɉe' cho'a bloɉ ban'. Na' ble'ine' yeɉən' da' cho'inə' babga'an. ");
INSERT INTO zavNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nach beza'adoe' beyede' ga'an zoto' len Simon Bedən', nach gwne' neto': ―Babesyə'əbeɉe' X̱anchon' ḻo'o ban', na' bito ṉezecho galə besyə'əyo'ene'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Nach gwza'ato' len Bedən' gwyeɉto' cho'a bloɉ ban'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","C̱hopteto' gwsa'adoto' pero nada' gwsa'adocha' ca Bedən' na' zgua'atec nada' bžina'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Na' bcheca'a bgüia' ḻo'o ban' na' ble'ida' lachə' ca' gan' zɉəchi'in, pero bito gwyo'a. ");
INSERT INTO zavNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ḻe'e bla'ate Simon Bedən' na' ḻe' gwyo'e ḻo'o ban' na' ḻeczə ble'ine' lachə' ca' gan' zɉəchi'in. ");
INSERT INTO zavNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Na' bey de'en bosyo'oguazɉe' laogüe'enə' bito lenən lachə' ca' yeḻa', ndobən chi'in ca'aḻə. ");
INSERT INTO zavNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Na' ḻa'aṉə'əczə nadə'əteca' byob bžina', gwdechlə gwyo'a ḻo'o ban', na' catə' ble'ida' de'e ca' gwyeɉḻi'a de que beban Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","La' ca orən' bito ṉe'e šeɉni'ito' Xtižə' Diozən' de'enə' nyoɉən nan de que yeban Jeso'osən' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Na' beza'ato' beyeɉ ližto'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Na' Marian' bega'aṉe' chbeže' cho'a bloɉ ban'. Na' lao chbeže'enə' bcheque'e bgüie' ḻo'inə'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Na' ble'ine' c̱hopə angl zɉənyaze' lachə' šyiš zɉəchi'e ḻo'o ban', toe' chi' zda yic̱hɉlei na' yetoe' chi' zda xni'alei gan' gotə' cuerp c̱he Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nach gwse'e no'olən': ―¿Bixc̱hen' chbežo' no'olə? Na' ḻe' boži'en gože' ḻega'aque': ―C̱hedə' babesyə'əyo'e X̱ana'anə', na' cabi ṉezda' galə ɉəsyə'əsane'ene'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ca beyož gwna Marian' ca', gwyec̱hɉe' bgüie' traslə na' ble'ine' Jeso'osən' zeche' cože'enə', pero bito beyombia' Marian' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Nach gož Jeso'osən' ḻe': ―No'olə ¿bixc̱hen' chbežo'? ¿Non' cheyilɉo'? Na' Marian' bene' xbab de que ben' chapə güert na'anə', na' gože'ene': ―Šə le' babeyo'one'enə', gwna nada' galə ɉəyesano'one'enə' na' nada' yeyo'ane'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jeso'osən' gože' ḻe': ―Maria. Na' Marian' gwyec̱hɉe' de'e yoblə na' gože'ene': ―Raboni―, naquən dižə' ebreo na' zeɉen Maestr. ");
INSERT INTO zavNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jeso'osən' gože' ḻe': ―Bito gox̱o'o nada', la' bito ṉe'e yeyepa' ga'an zo X̱a'anə'. Beyeɉ lao disipl c̱hia' ca' yeḻa' beṉə' ca' zɉənaquə ca biša'a na' zana' na' gožga'aque' de que yeyepa' ga'an zo X̱a'anə', ben' ḻeczə naque' X̱ale. Naque' Dioz ben' cho'elaogua'a na' ḻeczə naque' Dioz ben' cho'ela'ole. ");
INSERT INTO zavNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nach beza' Maria beṉə' Magdalan' bedəyedix̱ɉue'ine' neto' disipl de que bable'ine' X̱anchon'. Na' be'elene' neto' dižə' de'en gož Jeso'osən' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na' ca bex̱ɉw že' ža dmigon' neto' disipl c̱he' nžagto' txen. Na' zɉənyeyɉw puert ca' por ni c̱he de'en bžebto' beṉə' blao c̱he ṉasyon Izrael c̱heton'. Catə'əczla gocbe'ito' bazecha Jeso'osən' gwchoḻto'onə'. Nach gože' neto': ―Ḻeso binḻo len xbab de'en yo'o ḻo'o yic̱hɉla'ažda'olen'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ca beyož gwne' ca' blo'ine' neto' ḻo'o taque'e ca' na' cuit ḻe'enə'. Na' bebeito' ble'ito' X̱anchon'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nach goze'e neto' yetši'i: ―Ḻeso binḻo len xbab de'en yo'o ḻo'o yic̱hɉla'ažda'olen'. Can' bseḻə' X̱a'anə' nada' yežlyo nga par chona' xšine'enə', ca'aczən' əchseḻa'a le'e par gonḻe xšina'anə'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Beyož gwne' ca' blobe' neto' nach gože' neto': ―Ḻe'e si' Spirit c̱he Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Beṉə' ca' yesyə'ədiṉɉe xtoḻə'əga'aque'enə' naple yeḻə' chnabia' par ye'ega'aclene' de que bagwnitlaon. Pero beṉə' ca' cui yesyə'ədiṉɉe xtoḻə'əga'aque'enə' naple yeḻə' chnabia' par ye'ega'aclene' de que bito ṉitlaon. ");
INSERT INTO zavNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Na' Tomas ben' boso'osi'e Didimo laogüe de'en naque' beṉə' cuaš, lene' neto' šižiṉto', pero bito zoe' len neto' catə'ən bedəyelo'elao Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Na' neto' gožto'one': ―Bable'ito' X̱anchon'. Nach Tomasən' gože' neto': ―Xte que le'ida' taque'e ca' na' əgwzebə xbena'anə' gan' gwdebə clab ca', na' əgwzebə na'anə' cuit ḻe'enə', nach šeɉḻi'a. ");
INSERT INTO zavNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Gozde to xman zezzoto' ḻo'o yo'onə' de'e yoblə, na' zo Tomasən' len neto'. Na' ḻeczə zɉənyeyɉw puert ca', catə'əczla bezla' Jeso'osən' na' gozzeche' gwchoḻto'onə', na' gwne': ―Ḻeso binḻo len xbab de'en yo'o ḻo'o yic̱hɉla'ažda'olen'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nach gože' Tomasən': ―Bgüia ḻo'o taca'a quinga na' bzeb xbeno'onə'. Na' bzeb na'onə' cuit ḻi'a nga par nic̱h šeɉḻi'o. Na' cui gaco' to beṉə' cui cheɉḻe'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nach Tomasən' gože'ene': ―X̱ana', na' Dioz c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Nach gož Jeso'osən' ḻe': ―Xte que ble'ido' nada' nach gwyeɉḻi'o. Mbalazəch len beṉə' cui yesə'əle'i nada' na' se'eɉḻe'e. ");
INSERT INTO zavNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Na' de'e zan miḻagr de'e ben Jeso'osən' gan' zoto'onə' pero bito bzoɉga'aca'an nga. ");
INSERT INTO zavNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero zɉənyoɉ de'e quinga par nic̱h sotezə sole šeɉḻe'ele de que Jeso'os na'an Xi'iṉ Diozən' ben' gwleɉ Diozən' par gaquəlene' beṉac̱hən', na' par nic̱h gatə' yeḻə' mban zeɉḻicaṉe c̱hele laogüe de'en chonḻilažə'əlene'. ");
INSERT INTO zavNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Gwde goc de'e ca', Jeso'osən' bozloe' laogüe' neto' disipl c̱he' yetši'i cho'a nisdao' Galilea de'en ḻeczə nzi' Tiberias. Quinga blo'elaogüe' neto': ");
INSERT INTO zavNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Txen zoto'onə' Simon Bedən', len Tomasən', na' Natanaelən' na' nada' na' beṉə' biša'a na' yec̱hopə disiplən'. Natanaelən' naque' beṉə' Cana, to yež de'e chi' gan' mbane Galilean'. Na' Tomasən' de'en naque' beṉə' cuaš nachən' boso'osi'ene' Didimo. ");
INSERT INTO zavNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Bedən' gože' neto': ―Ša'ayetošca' gwxen beḻ. Na' gožto'one': ―Ḻeczə gwza' neto'. Nach gwza'ato' gwyeɉto' cho'a nisda'onə' na' gwyo'oto' to ḻo'o barcw. Pero že'enə' cuiczə no no bdole'eto'. ");
INSERT INTO zavNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Na' che'eni'ilas bla' Jeso'osən' cho'a nisda'onə' pero na' neto' bito beyombi'ato' šə ḻe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jeso'osən' gwṉe' zižɉo gože' neto': ―Xi'iṉda'ogua'a ¿gaṉ beḻ ya'a gaocho? Na' boži'ito' xtiže'enə' gožto'one': ―Notono de. ");
INSERT INTO zavNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nach gože' neto': ―Ḻe'e gwzaḻə' yix̱ɉw beḻ c̱helen' cuit barcon' ḻichalə na' əželeleb. Nach bzaḻə'əto' yix̱jw beḻ c̱heto'onə' na' xte caguə gwzoito' yecueto'on ḻo'o barcon' tant beḻ zan gwža' ḻo'inə'. ");
INSERT INTO zavNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nach nada' goža' Bedən': ―X̱ancho na'anə'. Nach Simon Bedən' cate goža'ane': “X̱ancho na'anə'”, ḻe'e beyacwte' xalane'enə', la' de'e cho'o ḻo'olzən' nacue' par nic̱h chone' žinṉə', na' ḻe'e bexitə'əte' lao nisən' par nic̱h byob bežine' gan' zo Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Na' neto' zeyo'oto' ḻo'o barcw da'onə' ze'e zenxobəto' yix̱ɉw beḻən' gan' ža' beḻ ya'a ca'. Caguə nactequəch zitə' cho'a nisda'onə', ca do yeto gueyoa metrzən'. ");
INSERT INTO zavNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Na' catə' bežinto' cho'a nisda'onə' beyetɉto' ḻo'o barcon' na' ble'ito' chi' yi' ya'alɉən' na' xoa to beḻ ya'a laogüen', na' len yet. ");
INSERT INTO zavNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jeso'osən' gože' neto': ―Ḻe'e yeyox̱ə' la' beḻ ya'a ca' ze'e gwxenḻe niḻə. ");
INSERT INTO zavNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Na' Simon Bedən' gwyeɉe' gan' chi' barcon' na' ɉəyeseže' yix̱ɉw beḻən' gan' ncheɉən. Nach bexobəto'on yo bižlə. Na' ža'an to gueyoa ši'iṉeyon beḻ xen. Na' bito gwchezə yix̱ɉon' ḻa'aṉə'əczə bia zanṉə' gwža' ḻo'inə'. ");
INSERT INTO zavNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jeso'osən' gože' neto': ―Ḻe'e da gaole xsil. Na' ni toto' cui beyaxɉeto' ye'eto'one': “¿No le'?” la' gocbe'ito' de que X̱ancho na'aczənə'. ");
INSERT INTO zavNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jeso'osən' bgüigue'e gwxi'e yetən' na' beṉe' c̱he c̱heto'. Na' ḻeczə ca' bene' len beḻən'. ");
INSERT INTO zavNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","De'e nga beyoṉ las blo'elao Jeso'osən' neto' disipl c̱he' lao bebane' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Na' ca bedaoto'onə' Jeso'osən' gože' Simon Bedən': ―Simon xi'iṉ Jonas ¿əchaquəchdo' c̱hia' can' chsa'aque beṉə' quinga c̱hia'? Na' boži'en gože': ―X̱ana' le' ṉezdo' de que chacda' c̱hio'. Jeso'osən' gože' ḻe': ―Bsed blo'i beṉə' ca' ze'e gwzolao chso'onḻilažə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Na' de'e əgwchop lase goze'ene': ―Simon xi'iṉ Jonas ¿əchacdo' c̱hia'? Na' Bedən' gože'ene': ―X̱ana' le' ṉezdo' de que chacda' c̱hio'. Jeso'osən' gože' ḻe': ―Bgüia bye beṉə' ca' chso'onḻilažə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","De'e əgwyoṉ lase gože'ene': ―Simon xi'iṉ Jonas, ¿əchacdo' c̱hia'? Na' Bedən' gocchgüeine' de'e gože'ene' de'e gwyoṉ lase: “¿Echacdo' c̱hia'?” Na' gože' ḻe': ―X̱ana' le' ṉeze nḻe'ido' yoguə'əḻoḻ. Le' ṉezdo' de que chacda' c̱hio'. Jeso'osən' gože' ḻe': ―Bsed blo'i beṉə' ca' chso'onḻilažə' nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","De'e ḻi əchnia' le' catə' goco' beṉə' güego' cuino' boc̱heɉ doxpeyo'onə' na' gwyeɉo' con ga nazən c̱hio'. Pero catə' gaco' beṉə' golə, əgwḻi na'onə' na' beṉə' yoblə yoc̱heɉe' doxpeyo'onə' na' yesə'əc̱he'e le' ga cui che'endo'. ");
INSERT INTO zavNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Na' de'en gože'ene' ca' zeɉe dižə' de que Bedən' gone' ca si' Diozən' yeḻə' bala'aṉ ca de'en gaquə Bedən' lao na' beṉə' mal ca' par so'ote'ene'. Gwde gwna Jeso'osən' can' gaquə c̱he Bedən' nach gože' Bedən': ―Da len nada'. ");
INSERT INTO zavNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Na' beyec̱hɉ Bedən' ble'ine' nada' naogua' ḻega'aque' na' bene' xbab can' chaque Jeso'osən' c̱hia', la' nada'an gwchi'a cuit Jeso'osən' žen' gwdaoto' xše'enə' txen catə'ən goža'ane': “X̱ana', ¿noxaczxən' əgwde le' lao na' beṉə' ca'?” ");
INSERT INTO zavNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nach Bedən' gože' Jeso'osən': ―X̱ana' ¿nac gaquə c̱he benga? ");
INSERT INTO zavNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jeso'osən' gože' ḻe': ―Šə che'enda' ṉe'e zoczə benga xte catə'ən yida' yetlas ¿bixa zedən' chaco'? Con gwzotezə gwzo benḻilažə' nada' na' bzenag c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","De'e na'anə' gwditɉ dižə'ənə' entr beṉə' ca' chso'onḻilažə' Cristən' de que nada' bito gata'. Pero Jeso'osən' caguə gože' Bedən' cui gata'anə' sino gože'ene': “Šə nada' che'enda' ṉe'e zocze' xte catə'ən yida' yetlas ¿bixa zedən' chaco'?” ");
INSERT INTO zavNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nada'an naca' disiplən' ben' goquene' c̱hei na' ṉezda' can' goquə yoguə' de'e quinga babzoɉa'. Na' ḻeczə le'e ṉezczele de que dižə' ḻin' cho'a. ");
INSERT INTO zavNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Zanch de'e de de'e ben Jeso'osən' de'e cui zɉənyoɉ. Žalə' zɉənyoɉ yoguə'ən na' tgüeɉə tgüeɉən ḻibr zan juisy zɉəde žalə' ca'. De'e na'azən' chzoɉa'.");
INSERT INTO zavNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Teofilo dao', ca' naquə ḻibr de'en bzoɉa' de'e nech, bzoɉa' c̱he yoguə'əḻoḻ de'e güen de'e ben Jeso'osən' na' de'en bsed blo'ine' dezd catə'ən gwzolaogüe' bsed blo'ine' xte catə'ən beyepe' yoban'. Žlac bsed blo'ine'enə' gwleɉe' apostol c̱he' ca' na' len yeḻə' chnabia' c̱he Spirit c̱he Diozən' bene' mendad naquən' so'one'. ");
INSERT INTO zavNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nach gwde gwso'ot beṉə' Jeso'osən', ɉəyeloe' laogüe' apostol c̱he' ca'. Na' de'e zan de'e bene' par nic̱h gosə'əṉezene' de que mbancze'enə', na' gwdalene' ḻega'aque' c̱hoa ža na' bzeɉni'ine' ḻega'aque' can' chene'e Diozən' ṉabi'e beṉə' so'e latɉə. ");
INSERT INTO zavNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Na' žlac ṉe'e zo Jeso'osən' len apostol c̱he' ca' bene' mendad cui yesyə'əžaše' syoda Jerosalenṉə' lgüegwzə. Gože' ḻega'aque' yesyə'əga'aṉe' yesə'əbeze' xte catə'ən bac̱h goc can' ben X̱e' Diozən' lyebe gaquə, ca de'en bzeɉni'ine' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jeso'osən' goze'e ḻega'aque': ―De'e zaque'enə' ca naquə Juanṉə' bc̱hoe' beṉə' nis, pero entr yeto c̱hopə ža, nada' gona' par nic̱h gaquə to de'e zaquə'əche, gona' par nic̱h yedəso Spirit c̱he Diozən' ḻo'o yic̱hɉla'ažda'olen' ṉabi'an le'e. ");
INSERT INTO zavNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Na' catə' bazɉəndopə zɉənžague' len Jeso'osən' gwse'ene': ―X̱anto' ¿əbabžin ža gono' ca yechoɉ ṉasyon Izrael c̱hechon' xni'a beṉə' zitə' ca'? ");
INSERT INTO zavNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jeso'osən' gože' ḻega'aque': ―Bito naquən par nic̱h le'e əṉezele bi ža bi orən' gon X̱acho Diozən' de'e ca' babži'e bia' gone'. ");
INSERT INTO zavNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero na' catə' yedəso Spirit c̱he'enə' len le'e, gaquəlenən le'e len yeḻə' guac c̱he'enə' par nic̱h güe'ele xtiža'anə' syoda Jerosalen nga, na' doxen ga mbane Jodean', na' Samarian' na' doxenḻə lao yežlyon'. ");
INSERT INTO zavNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Beyož gwna Jeso'osən' ca', lao chəsə'əgüia disipl c̱he' ca' ḻe' beyepe' yoban' to ḻo'o beɉw na' bitoch besə'əle'ine' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Na' ṉe'e chəsə'əgüiachgua disipl c̱he' ca' ḻe'e yoban' gan' besə'əle'ine' beyepe', catə'əczla gwsa'acbe'ine' bazɉəzecha c̱hopə angl len ḻega'aque' beṉə' zɉənyaz lachə' šyiš. ");
INSERT INTO zavNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Na' beṉə' ca' c̱hopə gwse'e ḻega'aque': ―Beṉə' Galilea, ¿bixc̱hen' chgüiale ḻe'e yoban'? Catezəczən' ble'ile beyep Jeso'os nga yoban' catə'ən bechoɉe' ladɉwlen', ca'atezəczən' le'ile yide' de'e yoblə. ");
INSERT INTO zavNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nach besa'aque' ya'a de'en nzi' ya'a Olibos ɉəya'aque' Jerosalenṉə', na' naquə gaḻə'əzə Jerosalenṉə' to catə'ətə'ən de lsens sa'aque' ža dezcanzən' segon costombr c̱he beṉə' Izrael ca'. ");
INSERT INTO zavNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Na' catə' besə'əžine' Jerosalenṉə' apostol ca' šneɉ na' beṉə' ca' zɉənžague' besyə'əgüie' gan' nite'enə' ḻo'o cuartən' zo žcuia la'aḻə. Apostol ca' šneɉ beṉə' quinga: Bedən', Jacobən', Juanṉə', Ndresən', na' Lipən', Tomasən', Bartolomen', Mtion' na' Jacob xi'iṉ Alfeo, na' Simon ben' chon txen len partid de'en nzi' Cananista, na' Jodasən' beṉə' bišə' Jacobən'. ");
INSERT INTO zavNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yoguə' ža gwnitə'ətezə gwnitə' apostol ca' šneɉ gwso'one' orasyon txen len beṉə' ca' zɉənaquə bišə' Jeso'osən' na' len Maria xna' Jeso'osən' na' len yeziquə'əchlə no'ol ca' zɉənžague'. ");
INSERT INTO zavNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Na' ca tyemp na' Bedən' gwzeche' ladɉo to gueyoa gaḻɉə beṉə' lɉuežɉ chio'o chonḻilažə'əcho Jesocristən' par be'elene' ḻega'aque' dižə'ən, na' gože' ḻega'aque': ");
INSERT INTO zavNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Beṉə' bišə', Spirit c̱he Diozən' benən par nic̱h de'e Rei Dabin' bzoɉe' na' be'e dižə' c̱he Jodən' ben' gwc̱he'e beṉə' ca' gosə'əzen Jeso'osən' gan' ɉesə'əšague'ene'. Na' benən byen goc complir can' nyoɉ Xtižə' Diozən' c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jodən' goque' txen len neto' apostol, na' bene' txen len neto' yoguə'əḻoḻ de'en gwyo'o lao na'ato' bento'. ");
INSERT INTO zavNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Na' Jodən' gwxi'e to pedas yežlyo len laxɉue' de'en gwxi'e par de'e malən' bene' bdie' Jeso'osən' lao na' beṉə' ca'. Pero na' bexope' gan' golə'ədite'enə' na' gošɉ ḻe'enə' na' doxen xɉlo'enə' bchoɉ. ");
INSERT INTO zavNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yoguə'əḻoḻ beṉə' ža' Jerosalenṉə' gosə'əṉezene' can' goc c̱he'enə' na' de'e na'anə' bosə'əsi'e yežlyon' Aseldama na' xtižə'əga'aque'enə' zeɉe dižə' yežlyo chen. ");
INSERT INTO zavNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Na' de'en gwso'one' ca' goc can' nyoɉ to Salmo nan: Liže'enə' gaquən to yo'o daš, notono no so' na'. Na' ḻeczə nyoɉən nan: Na' te beṉə' yoblə gwḻane' xḻatɉe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Na' nitə' beṉə' entr chio'o nga beṉə' bagwso'on txen len chio'o bedote lao gwdalen X̱ancho Jeso'osən' chio'o. ");
INSERT INTO zavNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Bagwso'one' txen dezd catə' de'e Juanṉə' bc̱hoe' ḻe' nis xte catə'ən beyepe' yoban', na' cheyaḻə' cueɉcho toe' gone' txen len neto' apostol güe'eto' dižə' can' beban X̱ancho Jeso'osən' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Na' gosə'əbeɉe' c̱hopə beṉə', toe' Jwse ben' le Barsabas, na' ḻeczə le' Josto, na' ben' yeto Matias. ");
INSERT INTO zavNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Nach gwso'one' orasyon gwse'e Diozən': ―X̱anto' le' nombi'o yic̱hɉla'aždao' yoguə'əḻoḻ beṉə'. Entr beṉə' ca' c̱hopə blo'išguei neto' noe' bagwleɉo' par tie' gwḻane' xḻatɉə Jodən' par gaque' apostol na' gone' xšino'onə' txen len neto', ca naquə Jodən' gwleɉyic̱hɉe' de'en ngo'o lao ne'enə' gone' na' bazɉəyede' gabiḻ gan' naquən yeyeɉe' yeḻə' güen de'e mal c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nach gwso'one' rif par gosə'əṉezene' non' bagwleɉ Diozən' na' Matiasən' bchoɉe' na' gwso'onene' cuent len apostol ca' šneɉ. ");
INSERT INTO zavNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Na' bžin ža lṉi de'en ne' Pentecostes, na' apostol ca' na' yoguə'əḻoḻ beṉə' ca' bagwso'onḻilažə' Jesocristən' zɉəndopə zɉənžague' txen tozə latɉə. ");
INSERT INTO zavNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Na' to de repentzə goc to sšag ḻe'e yoban' ca sšag c̱he to be' bdon' gual na' nenxeɉə ḻo'o yo'o gan' zɉəchi'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Na' besə'əle'ine' to de'en naquə ca yi' beḻ na' bžinte latə' güeɉə de'enə' chaḻə'əṉiṉ gan' zɉəchi' to toe'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ca' goquə bedənabia' Spirit c̱he Diozən' yic̱hɉla'aždao' to toe', na' Spiritən' benən par nic̱h gosə'əzolaogüe' gwso'e gwde gwdelə dižə' de'e gwse'eɉni'i beṉə' zitə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na' ca tyempən' beṉə' zan beṉə' Izrael ca' ža' Jerosalenṉə' beṉə' chso'elao' Diozən', za'aque' zan yež yoblə lao yežlyon'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Na' catə' gwse'enene' sšaguən' de'en goquə ḻo'o yo'o gan' ža' apostol ca', zan beṉə' Izrael ca' besə'əžague', na' ḻechguaḻe besyə'əbanene' c̱hedə' to toe' gwse'enene' chso'e beṉə' ca' chso'onḻilažə' Jesocristən' dižə' de'e chəsə'əṉe to toe'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bito gwse'eɉni'ine' bin' chac na' besyə'əbanene', gosə'əne': ―¿Ecaguə beṉə' Galilea beṉə' quinga chso'e dižə'ənə'? ");
INSERT INTO zavNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Nactecxa chaquən' to tocho chenecho chso'e dižə' can' chso'e beṉə' gwlaž c̱hecho ca' dižə'? ");
INSERT INTO zavNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Baḻcho naccho beṉə' Partia na' baḻcho beṉə' Media, na' baḻcho beṉə' Elam, na' baḻcho beṉə' Mesopotamia. Na' yebaḻcho beṉə' Jodea, na' yebaḻcho beṉə' Capadosia, yebaḻcho beṉə' Ponto, yebaḻcho beṉə' Asia, ");
INSERT INTO zavNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","yebaḻcho beṉə' Frigia na' beṉə' Panfilia, na' yebaḻcho beṉə' Egipto, na' yebaḻcho za'acho yež Africa ca' de'en zɉəchi' delant Sirene. Na' entr chio'o za'acho Roman' baḻcho golɉcho naccho beṉə' Izrael na' yebaḻcho ben cuincho beṉə' Izrael. ");
INSERT INTO zavNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Na' baḻcho naccho beṉə' Creta na' beṉə' Arabia. Na' gatə'ətezə beṉə' naccho, yoguə'əcho chenecho chso'e beṉə' Galilea quinga xtižə'əchon' de'en chaccho, chso'e dižə' c̱he de'e zan de'e baben Diozən' de'e zaquə' yebanecho. ");
INSERT INTO zavNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Na' yoguə' beṉə' ca' besə'ədobə choso'ozenague' besyə'əbanene' na' gwsa'acžeɉlaže'e c̱he de'en chaquən', na' zane' gosə'əne': ―¿Bi zeɉen de'e nga chaquən? ");
INSERT INTO zavNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Na' yebaḻe' gwso'one' borl gosə'əne': ―Beṉə' quinga chesə'əzožene'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Na' Bedən' gwzeche' lao beṉə' ca' txen len apostol ca' yešneɉ na' be'e dižə'ən zižɉo gože' beṉə' ca' zɉənžaguən': ―Le'e beṉə' Jodea na' notə'ətezəchle zole Jerosalenṉə', che'enda' gwzenagle c̱hia' na' gonḻe xbab c̱he de'en ze'e ṉia' le'e. ");
INSERT INTO zavNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Beṉə' lɉuežɉa' quinga bito chəsə'əzožene' can' chaquele, la' ṉe'e naquə tempran. ");
INSERT INTO zavNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Bachac can' bzoɉ de'e profet Joelən' ben' be' xtižə' Diozən' cana', bzoɉe' de'en gwna Diozən', nan: ");
INSERT INTO zavNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Catə' bazon əžin tyemp par šo'o fin c̱he yežlyon' nada' Dioz gona' par nic̱h Spirit c̱hia'anə' yedəson len beṉə' ža' doxen lao yežlyon'. Na' gona' par nic̱h xi'iṉle ca' so'e xtiža'anə' na' beṉə' byo xcuidə' ca' yesə'əle'idaogüe'ene' bi de'en gona' par yesə'əle'idaogüe'ene', na' güe'elena' beṉə' byo golə ca' dižə' lao bišgal c̱hega'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Na' yoguə' beṉə' ca' chso'on xšina'anə' ḻa'aṉə' beṉə' byo o ḻa'aṉə' no'olə, yedəso Spirit c̱hia'anə' len ḻega'aque' par nic̱h so'e xtiža'anə'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Gona' par nic̱h gaquə de'en cui noṉə' le'i ḻe'e yoban' na' lao yežlyon'. Gwlo'a yeḻə' guac c̱hia'anə' len chen, len yi' na' len žen de'en naquə ca beɉw. ");
INSERT INTO zavNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Cuich əgwse'eni' bgüižən', nach bio'onə' yeyaquən xṉa ca color c̱he chen antslə ze'e əžin ža yida' de'e yoblə par c̱hoglaogua'an c̱he yoguə'əḻoḻ beṉə' šə non' napə doḻə', nadan' naca' X̱anḻe. Gaquən to ža žialao xen, na' gwlo'a yeḻə' guac xen c̱hia'anə'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Na' gaquə de que notə'ətezə beṉə' yesə'əṉab goclen laogua', nada' naca' X̱anḻe gona' par nic̱h cui žɉəya'aque' lao yi' gabiḻ. Can' gwna Diozən' na' bzoɉ de'e profet Joelən' ḻen, ben' be' xtižə' Diozən' cana'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Na' le'e beṉə' Izrael gwlaž c̱hia', ḻegwzenag c̱hia'. Ca naquə Jeso'osən' ben' naquə beṉə' Nasaretən', Diozən' blo'ine' le'e de que naque' beṉə' zaque'e. Diozən' bene' par nic̱h Jeso'osən' bene' miḻagr na' bichlə de'e zaquə' yebanecho par ble'ile, can' ṉezczelenə'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Lao yeḻə' ṉeze c̱he Diozən' bin' ze'e gaquə c̱he Jeso'osən', bsi'e xṉeze par nic̱h Jodən' benene' lao na'alen' na' benḻe par nic̱h beṉə' mal ca' gwso'ote'ene' boso'ode'ene' ḻe'e yag corozən'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero na' Diozən' boḻis bosbane'ene' ladɉo beṉə' guat ca', c̱hedə' bito gwzoi yeḻə' gotən' ṉabia'an ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Quinga bzoɉ de'e Rei Dabin' xtižə' Jeso'osən' gan' nyoɉ Xtižə' Diozən' nan: Ṉezda' de que X̱ana' Diozən' zoe' len nada' do tyempte na' chaclene' nada' par nic̱h cui bi chžeba'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","De'e na'anə' zoa' mbalaz na' cho'a dižə' can' chebeida' na' ṉezda' yoḻis yosbane' nada' ladɉo beṉə' guat ca' catə' bagota'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Dioz c̱hia' ṉezda' bito yocua'aṉo' nada' gan' ža' beṉə' guat ca', ni que go'o latɉə gožə' cuerp c̱hia'anə', nadan' naca' Xi'iṉon' na' naquə la'aždaogua'anə' xi'ilažə'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Bablo'ido' nada' naquən' gona' par nic̱h əbana' zeɉḻicaṉe na' ḻechguaḻe mbalaz soa' yedote de'en zoleno' nada'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Beṉə' Izrael, ṉezecho de que de'e x̱axta'ocho Rei Dabin' gote' na' boso'ocuaše'ene'. Na' nombi'acho yo'o de'en zo gan' boso'ocuaše'ene'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Na' de'e Rei Dabin' ža be'e dižə' can' bzeɉni'i Diozən' ḻe' cana'. Gwne' naquən segor can' ben Diozən' lyebe de que to beṉə' galɉə lao dia c̱he'enə' ṉabi'e Izraelən' can' gwnabia' ḻe'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Diozən' bene' par nic̱h de'e Rei Dabin' gwṉezene' can' gaquə na' de'e na'anə' be'e dižə' c̱he Cristən' ben' babseḻə' Diozən' par chaclene' ṉasyon c̱hechon'. Gwne' de que Cristən' yebane' na' bito yega'aṉe' gan' ža' beṉə' guat ca' na' nic gožə' cuerp c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ṉa'a ža, Diozən' boḻis bosbane' Jeso'osən' ladɉo beṉə' guat ca' na' neto' naquəto' testigw de que beyas bebane'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Na' Diozən' len yeḻə' guac c̱he'ene' bene' par nic̱h beyep Jeso'osən' gan' zoe'enə' na' chnabi'e txen len ḻe'. Na' Diozən' bnežɉue'ene' Spirit c̱he'enə' can' bene' lyebe. Na' Jeso'os na'anə' babene' miḻagr nga de'en babenele na' de'en bable'ile, babene' par nic̱h zedəso Spiritən' len neto'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Caguə de'e Rei Dabi na' ben' beyep yoban', sino de'e Dabin' bzoɉe' c̱he Jeso'osən' gwne': X̱ancho Diozən' gože' X̱ana'anə': “Gwche'edo' cuita' nga ṉabi'acho txen, ");
INSERT INTO zavNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","na' gona' par nic̱h ṉitə' de'e ca' chso'on contr le' na' beṉə' contr c̱hio' ca' xni'onə'.” ");
INSERT INTO zavNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Na' yoguə' chio'o beṉə' Izrael cheyaḻə' ṉezecho de'en ngan' c̱he Jeso'osən' ben' betle bda'alene' ḻe'e yag corozən'. Diozən' gwleɉe'ene' par nic̱h naque' X̱anchon' na' naque' Cristən', zeɉe dižə' ben' bseḻe'e par chaclene' ṉasyon c̱hechon'. Can' gwna Bedən' gože' beṉə' Izrael ca' zɉənžaguən'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Na' catə' beṉə' ca' zɉənžaguən' gwse'enene' xtiže'enə' de'e juisy de'e gwsa'aquene' ḻo'o la'ažda'oga'aque'enə', nach gwse'e Bedən' na' apostol ca' yeḻa': ―Beṉə' gwlaž, ¿bin' cheyaḻə' gonto' ža? ");
INSERT INTO zavNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nach Bedən' gože' ḻega'aque': ―Cheyaḻə' yediṉɉele xtoḻə'əle ca' par nic̱h Diozən' yezi'ixene' c̱hele na' c̱hoale nis par yesə'əṉeze beṉə' de que bachonḻilažə'əle Jesocristən'. Nach Diozən' goṉe' le'e Spirit c̱he'enə' son ḻo'o yic̱hɉla'ažda'olen'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Diozən' goṉe' notə'ətezle Spirit c̱he'enə' can' none' lyebe, le'e na' xi'iṉle ca' na' notə'ətezə beṉə' zitə', la' chnežɉue'en yoguə' beṉə' chbeɉe' par chsa'aque' xi'iṉe'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Nach Bedən' be'elene' ḻega'aque' dižə' zan, na' gwṉeyoine' ḻega'aque' gože': ―Ḻeyechoɉ lao de'e malən' de'en chso'onchgua beṉə' ca' cui zɉənombia' Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ca' goquən' beṉə' ca' gwse'eɉḻe' c̱he dižə' de'en be' Bedən' gosə'əchoe' nis. Na' lao žanə' šoṉa mil beṉə' ca' gwso'onḻilaže'e Jeso'osən' na' gwsa'aque' txen len yeziquə'əchlə beṉə' bachso'onḻilažə'əcze' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Yogue'e gwnitə'ətezə gwnite'e gosə'ənaogüe' de'en boso'osed boso'olo'i apostol ca' ḻega'aque' na' gwsa'aque' tozə len yeziquə'əchlə beṉə' gwso'onḻilažə' Jeso'osən' na' gwse'eɉ gwsa'ogüe' txen na' gwnitə'ətezə gwnite'e gwso'one' orasyonṉə' txen. ");
INSERT INTO zavNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Na' yoguə'əzə beṉə' besyə'əbanene' can' gwso'on apostol ca' miḻagr zan len yeḻə' guac c̱he Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Na' beṉə' ca' bachso'onḻilažə' Jesocristən' gwsa'aque' tozə na' gwso'one' tozə yoguə'əḻoḻ de'en zɉədeine'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Na' gwso'ote'e byen c̱hega'aque'enə' na' bichlə de'e ca' zɉədeine' na' mech de'en besə'əle'ine' c̱hein' gosə'əyise'en entr yoguə'əḻoḻga'aque' segon de'en besə'əyažɉe to toe'. ");
INSERT INTO zavNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Na' tža tža besə'ədopə besə'əžague' yo'odao' əblaonə' na' ḻeczə gwse'eɉ gwsa'ogüe' txen liž to toga'aque' na' gwnite'e mbalaz na' besyə'əbeine' gwso'one' txen. ");
INSERT INTO zavNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Gwnitə'ətezə gwnite'e gwso'elaogüe'e Diozən'. Na' gwsa'azlažə' beṉə' yeziquə'əchlə can' gwso'one'enə'. Na' tža tža X̱ancho Diozən' bene' par nic̱h gwyanch beṉə' ca' gwso'onḻilažə' Jesocristən'. ");
INSERT INTO zavNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Na' to ža Bedən' na' Juanṉə' ɉa'aque' yo'odao' əblaonə' do cheda šoṉə, or catə' chso'on beṉə' Izrael ca' orasyon segon costombr c̱hega'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Na' gwzo to beṉə' nxiṉɉ ṉi'enə' dezd golɉtie' na' yoguə' ža gosə'əbec beṉə' ḻe' cho'a puert c̱he yo'oda'onə' puert de'en nzi' “De'e Xoche”, par gwṉabe' carida lao beṉə' ca' chɉa'ac yo'oda'onə'. ");
INSERT INTO zavNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nach catə' besə'əžin Bedən' na' Juanṉə' yo'oda'onə' na' be'enə' nxiṉɉ ṉi'enə' boḻgüiže' ḻega'aque' yoso'onežɉue'ene' mech. ");
INSERT INTO zavNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nach Bedən' na' Juanṉə' gosə'əbeze' na' bosə'əgüiachgüe'ene' na' Bedən' gože'ene': ―Bgüia neto'. ");
INSERT INTO zavNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Na' be'enə' bene' xbab yoso'onežɉue'ene' mechən'. ");
INSERT INTO zavNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero Bedən' gože'ene': ―Bito bi mech c̱hia' de goṉa' le', pero de to de'e gona' gaquəlena' le'. Por yeḻə' guac c̱he Jesocristən' ben' naquə beṉə' Nasaretən' chona' mendad gwzoža' na' gwda. ");
INSERT INTO zavNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nach Bedən' bex̱e'e na' ḻicha be'en bsože'ene', na' ḻe'e gocte gwzeche' na' ṉi'e ca' ḻe'e besyə'əyacten gual na' ḻeczə ca' bec̱hɉ ṉi'e ca'. ");
INSERT INTO zavNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Na' catə' gocbe'ine' babesyə'əyac ṉi'e ca' gual bxite'e yeḻə' chebei c̱he'enə'. Na' gwyo'e cha'ašil c̱he yo'oda'onə' len ḻega'aque' chxite'e na' cho'elaogüe'e Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Na' beṉə' ca' ža' cha'ašilən' besə'əle'ine' can' chde' chxite'e na' cho'elaogüe'e Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Na' gwsa'acbe'ine' de que naque' ben' chbe' chṉab carida yoguə' ža cho'a puert c̱he yo'oda'onə' puert de'en nzi' “De'e Xoche”, na' ḻechguaḻe besyə'əbanene' de que babeyaque ṉi'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Na' to cha'ašil c̱he yo'oda'onə' nzi'in “C̱he de'e Salomonṉə'”. Cha'ašil na' gwyeɉ ben' beyaque ṉi'enə' len Bedən' na' Juanṉə'. Bito bsane' ḻega'aque', con bex̱e'e na'aga'aque'enə', na' yoguə' beṉə' ca' ža' yo'oda'onə' besə'əžagsese' par ɉəsə'əgüie'ene' c̱hedə' besyə'əbanchgüeine' de'en babeyaque be'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Na' catə' Bedən' ble'ine' de que bazɉənžag beṉə' zan gan' nite'enə' nach be'elene' ḻega'aque' dižə' gože' ḻega'aque': ―Le'e beṉə' gwlaž c̱hia' beṉə' Izrael, chebanele can' babeyaque be'enga. De repent chaquele de que por yeḻə' guac c̱heton' bento' par nic̱h beyaque be'enga o šə chaquele beyaquene' por ni c̱he de'en chonchguato' can' chazlažə' Diozən', pero caguə ca'anə'. ");
INSERT INTO zavNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","De'e x̱axta'ocho Abraanṉə', Isaaquən' na' Jacobən' gwso'elaogüe'e tozə Diozən' ben' cho'ela'ocho, na' Dioz na'anə' bnežɉue' yeḻə' bala'aṉ xen c̱he Xi'iṉe' Jeso'osən'. Pero le'e bdele Jeso'osən' lao na' jostis ca' par gwso'ote'ene' na' bžonḻe catə' Pilatən' gone'ene' əgwsane'ene'. ");
INSERT INTO zavNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Can' benḻe len Jeso'osən' ḻa'aṉə'əczə naque' beṉə' la'aždao' xi'ilažə' juisy na' naque' ḻe'ezelaogüe beṉə' güen. Nach gwṉable bosan Pilatən' to beṉə' güet beṉə' de ližyan' lgua'a Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Na' ca naquə Jeso'osən' ben' əbx̱e yeḻə' mban zeɉḻicaṉen', ḻe'enə' betle pero na' Diozən' boḻis bosbane'ene' ladɉo beṉə' guat ca'. Neto' ble'ito'one' na' cho'eto' dižə' de que bebane' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Na' chle'ile benga cui goquə sa' na' nombi'alene', na' cheyaḻə' əṉezele de que Diozən' beyone' ṉi'enə' c̱hedə' chonḻilažə'əto' Jeso'osən'. De'e yoblə nia' de que de'en chonḻilažə'əto' Jeso'osən' de'e na'anə' Diozən' bene' par nic̱h beyacšao' ṉi'a benga can' chle'ilen'. ");
INSERT INTO zavNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Beṉə' bišə' dao', ṉezda' de que le'e na' beṉə' golə blao c̱hele ca' betle Jeso'osən' laogüe de'en cui gwyeɉni'ile de que Dioz nan' bseḻe'ene'. ");
INSERT INTO zavNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Naque' Cristən' ben' gwleɉ Diozən' par gaquəlene' ṉasyon c̱hechon'. Can' goquə goc complir de'e ca' ben Diozən' mendad boso'ozoɉ de'e profet ca' c̱he Cristən' antslə ze'e seḻe'ene'. Gwso'e dižə' de que yoso'oc̱hi' yoso'osaquə' beṉə' ḻe' na' so'ote'ene'. ");
INSERT INTO zavNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ṉa'a ža ḻeyoša' xbab c̱helen' na' ḻe'e yediṉɉe xtoḻə'əle ca' par nic̱h X̱ancho Diozən' gwnitlaogüe'en na' par nic̱h gone' ca sole mbalaz. ");
INSERT INTO zavNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nach X̱ancho Diozən' seḻe'e Jeso'osən' yežlyo nga yetlas ben' gwleɉe' gwlalte par naque' Cristən'. ");
INSERT INTO zavNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pero chonən byen yega'aṉ Jesocristən' yoban' xte catə' əžin ža gon Diozən' par nic̱h yežlyon' yeyaquən de'e cobə. La' Diozən' bene' par nic̱h de'e profet ca' beṉə' ca' gwleɉe' par gwsa'aque' lažə' ne'enə' na' gwso'e xtiže'enə' cana'ate boso'ozoɉe' de que yeyaquən de'e cobə. ");
INSERT INTO zavNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","De'e Moisezən' be'elene' de'e x̱axta'ocho ca' dižə' gože' ḻega'aque': “X̱ancho Diozən' seḻe'e yeto beṉə' lao dia c̱helen' par güe'elene' le'e xtiže'enə' can' bseḻe'e nada'. C̱he be'enan' gwzenagle bitə'ətezə əṉe'. ");
INSERT INTO zavNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Na' Diozən' gone' par nic̱h yesə'əbiayi' yoguə' beṉə' ca' cui yoso'ozenag c̱he be'enə' əseḻe'e.” Can' gož de'e Moisezən' de'e x̱axta'ocho ca'. ");
INSERT INTO zavNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ḻe'egatezə ca' yoguə'əḻoḻ de'e profet ca' beṉə' ca' gwso'e xtižə' Diozən' cana' gwzolaozən' len de'e Samuelən' na' beṉə' ca' gwsa'ac gwdechlə gwso'e dižə' c̱he tyemp nga zocho ṉa'a na' c̱he de'e ca' bachac ṉa'a. ");
INSERT INTO zavNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","De'e profet ca' zɉənaque' x̱axta'ocho na' lyebe de'en ben Diozən' len de'e Abraanṉə' de que gone' güen len xi'iṉ dia c̱he'enə' naquən par chio'o. Gože' de'e Abraanṉə': “Por xi'iṉ dia c̱hio' beṉə' ṉitə' to to ṉasyon ṉite'e mbalaz.” ");
INSERT INTO zavNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Can' chac, Diozən' gwleɉe' Xi'iṉen' bseḻe'ene' por ni c̱hecho na' gone' par nic̱h to tole sole mbalaz šə yediṉɉele xtoḻə'əle ca'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ṉe'e chso'elente Bedən' na' Juanṉə' beṉə' ca' dižə' catə' besə'əžin baḻə bx̱oz c̱he beṉə' Izrael ca', na' beṉə' gwnabia' c̱he yo'odao' əblao c̱hega'aque'enə' na' beṉə' sadoseo ca' beṉə' ca' cui chse'eɉḻe'e de que yesyə'əban beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Beṉə' sadoseo ca' chəsə'əže'e de'en choso'osed choso'olo'i Bedən' na' Juanṉə' beṉə' ca' zɉənžaguən', choso'ozeɉni'ine' ḻega'aque' de que gwžin ža catə' yesyə'əban beṉə' guat ca' c̱hedə' beban Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Na' beṉə' blao ca' gosə'əzene' Bedən' len Juanṉə' na' gosə'əyix̱ɉue' ḻega'aque' ližyan' sin cui gwsa'ogüe' xya c̱hega'aque' can' cheyaḻə', c̱hedə' bachex̱ɉw že'enə' na' bito goḻə'əch so'one' yeḻə' jostis c̱hega'aque'enə' že'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Na' ca naquə beṉə' ca' gwse'ene choe' Bedən' na' Juanṉə' xtižə' Diozən' zane' gwso'onḻilaže'e Cristən', na' txen len beṉə' ca' bagwso'onḻilaže'ene' antslə gwnitə' gueyə' mil beṉə' byo cui cuent no'olə. ");
INSERT INTO zavNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","Na' beteyo beṉə' gwnabia' c̱he beṉə' Izrael ca', beṉə' golə blao ca' na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən' besə'ədopə besə'əžague' Jerosalenṉə' len Anasən' ben' naquəch bx̱oz əblao na' len Caifasən' na' Juanṉə' na' Ljandr na' nochlə beṉə' ca' zɉənaque' bišə' lɉuežɉ ben' naquəch bx̱oz əblaon'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nach gwso'one' mendad ɉəsə'əxi'e Bedən' na' Juanṉə' na' gosə'əṉabene' ḻega'aque': ―¿Non' ben lsens c̱hele par beyonḻe be'enə' nxiṉɉən'? o ¿non' ben mendad par beyonḻene'? ");
INSERT INTO zavNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Na' ca naquə Spirit c̱he Diozən' gwnabia'an yic̱hɉla'aždao' Bedən' nach benən par nic̱h gože' beṉə' ca': ―Le'e beṉə' gwnabia' na' beṉə' golə beṉə' blao c̱he Izraelən', chṉable nac goquən' beyonto' be'enə' nxiṉɉ ṉi'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Yoguə'əle cheyaḻə' gwzenagle na' ənia' le'e, de que le'e betle Jesocristən' be'enə' naquə beṉə' Nasaret, bda'alene' to ḻe'e yag coroz, pero Diozən' boḻis bosbane'ene' ladɉo beṉə' guat ca', na' Jesocrist nan' bene' yeḻə' guac beyaque benga. ");
INSERT INTO zavNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesocristən' naque' ḻe'ezelaogüe beṉə' zaque'e, pero bito bzenagle c̱he'. De'e na'anə' gwxaquə'əlebene' ca to yeɉ de'en naquə ḻe'ezelaogüe de'e güen na' le'e gwxaquə'əlebele ca beṉə' güen yo'o beṉə' ɉəsə'əc̱ho'on yeɉən' de'e naquəch yeɉ güen, pero yeɉən' banaquən yeɉ squin ṉa'a. ");
INSERT INTO zavNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tozə Jesocristən' guaquə yebeɉe' beṉə' xni'a de'e malən', na' notono nochlə zo doxen lao yežlyon' beṉə' gaquə yebeɉ chio'o xni'a de'e malən' sino tozə Jesocristən'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Besyə'əbane beṉə' gwnabia' ca' can' boži'i Bedən' na' Juanṉə' xtižə'əga'aque'enə' sin cui besə'əžebe', len nacbia' zɉənaque' beṉə' yix̱ə' na' bito zɉənsedteque'. Nach gwsa'acbe'ine' de que beṉə' ca' bito chesə'əžebe' c̱hedə' bagosə'ədalene' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Na' de'en zecha ben' beyaque ṉi'enə' txen len Bedən' na' Juanṉə' bito besyə'əžele beṉə' gwnabia' ca' bi xya sa'ogüe' c̱hega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nach besyə'əbeɉe' apostol ca' fuerlə žlac boso'oxi'e entr lɉuežɉga'aque' naclə so'one'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Na' beṉə' gwnabia' ca' gwse'e lɉuežɉga'aque': ―¿Bi goncho len beṉə' quinga? Yoguə' beṉə' ža' Jerosalen nga zɉəṉezene' de que gwso'one' to miḻagr xen na' bito gaquə ye'echo beṉə' de que bito gwso'one' miḻagrən'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ḻetechozə goncho par nic̱h cui gasə' lalɉə dižə' de'en chso'enə'. De'e na'anə' cheyaḻə' ye'echo ḻega'aque' gatə' castigw gual c̱hega'aque' šə so'eche' xtižə' Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nach gwsa'axe' Bedən' na' Juanṉə' de'e yoblə na' gwse'e ḻega'aque' cuich so'e dižə' c̱he Jeso'osən' na' cuich no yoso'osed yoso'olo'ine' c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nach Bedən' na' Juanṉə' bosyo'oži'en gwse'e ḻega'aque': ―Ḻegon xbab c̱he de'e nga, ¿əchaquele chene'e Diozən' gwzenagto' c̱hele o šə chene'ene' gwzenagto' c̱he'enə' ža? ");
INSERT INTO zavNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Bito gaquə cuezəto' cuich güe'eto' dižə' c̱he de'e ca' bable'ito' na' babeneto' c̱he Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Na' de'e zan de'e gwse' beṉə' gwnabia' ca' ḻega'aque' par yoso'ošebe' ḻega'aque'. Pero na' bito besə'əželene' naclə so'one' ḻega'aque' castigw c̱hedə' beṉə' zan chso'e yeḻə' chox̱cwlen c̱he Diozən' de'en beyaque be'enə'. Mazəchlə c̱hoa izene' na' dezd golɉtie' cui goquə se'e. Na' beṉə' gwnabia' ca' cui gwse'enene' yoso'oše'e beṉə' zan ca', de'e na'anə' bosyo'osane' Bedən' na' Juanṉə'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Na' Bedən' len Juanṉə' catə' bosyo'osan beṉə' gwnabia' ca' ḻega'aque' ɉəya'aque' gan' nitə' yeziquə'əchlə beṉə' ca' chso'onḻilažə' Cristən' na' gwso'elene' ḻega'aque' dižə' yoguə'əḻoḻ can' əgwse' bx̱oz əblao ca' na' beṉə' golə blao ca' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Na' beṉə' ca' catə' gwse'enene' dižə'ən tozə can' gwso'one' xbab len ḻega'aque' na' gwso'one' orasyonṉə' lao X̱acho Diozən' gosə'əne': ―X̱anto' Dioz, len' beno' yoban' na' yežlyon' na' nisda'onə'. Len' beno' beṉac̱h, bia ca' chsa'aš na' biquə'əchlə de'e zɉəde, na' len' chnabi'o doxenḻə. ");
INSERT INTO zavNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Na' Spirit c̱hio'onə' benən par nic̱h de'e Rei Dabin' bzenague' c̱hio' na' bzoɉe' dižə' quinga de'en nan: Beṉə' ca' cui zɉənaquə beṉə' Izrael chsa'ase' contr le' X̱anto' Dioz, pero bitoczə gaquə can' chso'one' xbabən'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Beṉə' gwnabia' c̱he ṉasyon ca' na' c̱he yež ca' txenṉə' zɉənaque' chso'one' contr le' X̱anto' Dioz, na' contr Xi'iṉo' Cristən' ben' bseḻo'o par gaquəlene' ṉasyon Izrael c̱heto' nga. ");
INSERT INTO zavNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Na' lao' syoda ngan' besə'ədobə Rei Erodən' na' Ponsio Pilatən' na' beṉə' cui zɉənaque' beṉə' Izrael, na' len beṉə' Izrael ca'. Na' yogue'e gwso'one' txen par gwso'ote' Xi'iṉo' Jeso'osən' ben' naquə beṉə' la'aždao' xi'ilažə' juisy, ben' gwleɉo' par gaquəlene' ṉasyon c̱heto' nga. ");
INSERT INTO zavNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Gwso'one' can' bsi'o xṉeze gaquə na' can' gwdix̱ɉui'o cana'ate. ");
INSERT INTO zavNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Na' ṉa'a ža X̱anto', bgüia can' chso'on beṉə' gwnabia' ca' chse'enene' yoso'ošebe' neto' beṉə' güen žin c̱hio', na' goclen neto' par nic̱h cui žebto' güe'eto' xtižo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Na' catə' güe'eto' xtižo'onə' blo'ešga yeḻə' guac c̱he Xi'iṉo' Jeso'osən' beṉə' la'aždao' xi'ilažə' juisyən' ca de'en gaquə no miḻagr, na' yesyə'əyaque no beṉə' chsa'acšene na' gaquə bichlə de'e yesyə'əbane beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Na' catə' beyož gwso'one' orasyonṉə' ca' Diozən' bene' par nic̱h gwxo' gan' zɉəndopə zɉənžague'enə' na' Spirit c̱he'enə' bedəṉabia'achən yic̱hɉla'ažda'oga'aque'enə' na' goclenən ḻega'aque' par gwso'e xtiže'enə' sin cui besə'əžebe'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Na' yoguə' beṉə' ca' gwso'onḻilažə' Cristən' tozə can' goquə yic̱hɉla'ažda'oga'aque'enə'. Na' yoguə' bi de'en zɉəde c̱hega'aque'enə' gwso'one'en tozə na' notono gwna: “C̱hia' de'e nga”, o “C̱hia' de'e na'”, la' naquən c̱he yoguə'əga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Na' apostol ca' gwnitə'ətezə gwnite'e boso'ozeɉni'ine' beṉə' de que Jeso'osən' bebane' ladɉo beṉə' guat ca'. Na' Diozən' goclenchgüe' ḻega'aque' len bi de'en gwso'one' na' bene' par nic̱h beṉə' yeziquə'əchlə gwsa'apəchgüe' ḻega'aque' respet. ");
INSERT INTO zavNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Can' goquə bito bi bi goquə faḻt bi de'en besə'əyažɉe beṉə' ca' gwso'onḻilažə' Cristən', c̱hedə' beṉə' ca' gotə' yežlyo c̱hega'aque' o ližga'aque' tgüeɉə gwso'otəga'aque'en. ");
INSERT INTO zavNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Na' mech de'en besə'əle'ine' c̱he to ton boso'onežɉue'en apostol ca' na' apostol ca' gosə'əyise'en len beṉə' ca' yeḻa' con noe' byažɉene'en. ");
INSERT INTO zavNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Can' ben to beṉə' C̱hipre beṉə' le Jwse. Naque' beṉə' golɉə lao dia c̱he de'e Lebin' na' apostol ca' bosə'əsi'ene' Bernabe, zeɉen dižə' ben' chtipe' lažə'əcho. ");
INSERT INTO zavNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Jwse na'anə' bete'e to yežlyo c̱he'enə' na' mech de'en ble'ine' c̱heinə' bnežɉue'en apostol ca'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Na' zo to beṉə' le Ananias na' no'ol c̱he'enə' Safira, na' Ananiasən' bete'e to yežlyo c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Pero na' boso'oxi'e entr ḻega'acze' yoso'ox̱oayague' apostol ca' yoo'onežɉue' to partzə mech de'en besə'əle'ine' c̱heinə' na' se'e ḻega'aque' de que doxenənṉə'. Nach gwyeɉ Ananiasən' na' bnežɉue' mechən'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nach Bedən' gože'ene': ―Ananias, ¿bixc̱hen' bzenago' c̱he gwxiye'enə' par chacdo' əx̱oayago' Spirit c̱he Diozən', nao' neto' de que choṉo' doxen mechən' de'en ble'ido' c̱he yežlyon' len bagwlo'oša'ole to partən' par cuinḻen'? ");
INSERT INTO zavNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","C̱hio' yežlyon' catə' cuiṉə' goto'on, na' c̱hio' mechən' de'en ble'ido' catə' beto'on na' zaco'o par beno' bi che'endo' len ḻen. De'e malən' benḻe ca de'en goquele əx̱oayagle len de'en beṉle neto'. Caguə contr neto'onə' babenḻe de'en benḻažə'əle sino contr Dioz na'anə'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nach Ananiasən' catə' benene' xtižə' Bedən' to bgüix̱ze' na' gote'. Na' yoguə' beṉə' ca' gwse'enene' dižə' can' goquən' ḻechguaḻe besə'əžebe'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Na' besə'əžin beṉə' xcuidə' ca' gan' bgüix̱ə de'e Ananiasən' na' bosyə'əc̱hele' cuerp c̱he'enə' to lachə' na' besyə'əyo'ene' gan' boso'ocuaše'ene'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Na' gwde do šoṉ or gote' bžin no'ol c̱he'enə' na' gwyo'e yo'onə' sin cui ṉezene' šə bin' bagoc c̱he de'e be'en c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Na' Bedən' gože'ene': ―Ca naquə yežlyon' de'en betə'əlen' ¿əḻeine' to ca'atə'ətən' ble'ile c̱hein' ža? Na' Safiran' gože'ene': ―To ca'atə'ətən'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Nach Bedən' gože' no'olən': ―¿Bixc̱hen' goco' tozə len be'en c̱hio'onə' chaquele gonḻe Diozən' prueb šə ḻeine' can' ne' bito əx̱oayagcho? Cho'a puert nga zɉəzecha beṉə' ca' baboso'ocuašə' be'en c̱hio'onə' na' ṉa'a so'e le'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Na' ḻe'e bgüix̱te Safiran' lao Bedən' na' gote'. Na' catə' gwso'o beṉə' xcuidə' ca' ḻo'o yo'onə' besə'əle'ine' bagote' nach gwso'ene' ɉəsə'əcuaše'ene' cuit de'e be'en c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Na' yoguə' beṉə' ca' chso'onḻilažə' Cristən' besə'əžebe' can' goquən' na' ḻeczə besə'əžeb yeziquə'əchlə beṉə' gwse'ene dižə' can' goquən'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na' apostol ca' gwso'one' de'e zan miḻagr entr beṉə' ca' ža' Jerosalenṉə'. Na' beṉə' ca' chso'onḻilažə' X̱ancho Jesocristən' chəsə'ədopə chəsə'əžague' txen cha'ašil c̱he yo'odao' əblaonə' gan' nzi' “C̱he Salomonṉə'”. ");
INSERT INTO zavNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Na' yeziquə'əchlə beṉə' ca' ža' Jerosalenṉə' ḻechguaḻe gwsa'apəga'aque'ene' respet, ḻa'aṉə'əczə besə'əžebe' par yesə'əžague' txen len ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pero na' zane' gwso'onḻilaže'e X̱anchon' na' besə'əžague' txen, zan beṉə' byo na' no'olə. ");
INSERT INTO zavNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Na' catə' no beṉə' gwsa'acšene gosə'əyix̱ɉue' ḻega'aque' tnezən' do lao cam o do lao yagla' gosə'əbeze' catə' te Bedən' na' gwse'enene' ṉite'e gan' yesə'əchele' bx̱en c̱he Bedən' par nic̱h yesyə'əyaquene' šə bi yižgüen' chse'ine'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Na' beṉə' ca' ža' yež ca' zɉəchi' gaḻə'əzə Jerosalenṉə' ɉa'aque' Jerosalenṉə' zɉənc̱he'e beṉə' ca' cha'acšene na' beṉə' ca' zɉəyo'o zɉəyaz de'e x̱io' ca'. Na' por yeḻə' guac c̱he Diozən' apostol ca' gwso'one' par nic̱h besyə'əyaque beṉə' ca' gwsa'acšene na' besyə'əbeɉe' de'e x̱io' ca' zɉəyo'o yic̱hɉla'aždao' beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nach ben' naquəch bx̱oz əblao na' yeziquə'əchlə beṉə' sadoseo ca' beṉə' ca' cui chse'eɉḻe'e de que yesyə'əban beṉə' guat ca', besə'əgue'ine' apostol ca'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Na' gosə'əzene' ḻega'aque' na' gosə'əyix̱ɉue' ḻega'aque' ližyan'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Na' to angl beṉə' za' gan' zo X̱ancho Diozən' bžine' ližyan' še'elə na' bsalɉue' puert ca' na' bebeɉe' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Na' gože' ḻega'aque' žɉa'aquəche' yo'odao' əblaonə' na' so'eche' dižə' len beṉə' ca' chəsə'əžaguən' naquən' so'one' par yesə'əzi'e yeḻə' mban zeɉḻicaṉen'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nach de'en gwse'enene' can' gož anglən' ḻega'aque', ɉa'aque' yo'odao' əblaonə' catə' gwye'eni'inə' na' boso'osed boso'olo'ine' beṉə' ca' zɉənžaguən'. Na' ben' naquəch bx̱oz əblao txen len beṉə' golə blao ca' chəsə'ənabia' ṉasyon Izraelən' besə'ədobe' par gwso'one' jontən' nach gwso'one' mendad žɉəsə'əxi'e apostol ca' gan' zɉədie' ližyan'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero catə' besə'əžin x̱a'ag yo'odao' ca' ližyan' caguə no apostol ca' nḻa'. Na' ɉəya'aque' lao beṉə' gwnabia' ca' ɉəsyə'ədix̱ɉui'e. ");
INSERT INTO zavNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Chse'e beṉə' ca': ―Nyeyɉw c̱hec̱h ližyan' na' soḻdad ca' nite'e cho'a puertən' chsa'ape'en pero catə' bsalɉwto' puertən' caguə no apostol ca' ža' ḻo'o ližyan'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Na' ben' naquəch bx̱oz əblao na' beṉə' gwnabia' c̱he soḻdad ca' chsa'apə yo'oda'onə', na' bx̱oz golə blao ca' catə' gwse'enene' rsonṉə' besyə'əbanene' na' gwsa'acžeɉlaze'e bi zeɉe ca de'en bagoquən'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Na' lao chsa'acžeɉlaže'enə' bžin to beṉə' gože' ḻega'aque' de que apostol ca' beṉə' ca' gosə'əyix̱ɉue' ližyan' že'e cha'ašil c̱he yo'odao' əblaonə' choso'osed choso'olo'ine'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nach beṉə' gwnabia' c̱he soḻdad gop ca' gwyeɉe' len x̱a'ag yo'odao' ca' ɉəsyə'əxi'e apostol ca' dižə' šao'. Bito gwso'one' znia len ḻega'aque' c̱hedə' besə'əžebe' beṉə' ca' choso'ozenag xtižə' apostol ca' šə yoso'ošiže'e ḻega'aque' yeɉ. ");
INSERT INTO zavNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Na' catə' besə'əžin apostol ca' lao beṉə' gwnabia' ca' beṉə' ca' chso'on jontən' nach ben' naquəch bx̱oz əblao gože' ḻega'aque': ");
INSERT INTO zavNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Bac̱h bento' mendad cui güe'ele dižə' c̱he Jeso'osən' na' cuich əgwsed əgwlo'ile beṉə' c̱he ḻe'enə', na' mazəchlə babe'elenḻe yoguə' beṉə' Jerosalen ca' xtiže'enə'. Na' bachosbaguə'əle neto' c̱he de'en gwso'ote'ene'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nach Bedən' na' apostol ca' yeḻa' gwse'e ḻe': ―Naquəchən de'e žialao xench gwzenagto' c̱he Diozən' cle ca c̱he beṉac̱hən'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Le'e betle Jeso'osən' bda'alene' to ḻe'e yag coroz pero Dioz ben' cho'ela'ocho na' ben' be'elao' de'e x̱axta'ocho ca' boḻis bosbane'ene' ladɉo beṉə' guat ca'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Na' ṉa'a Diozən' babnežɉue'ene' yeḻə' bala'aṉ xen na' yeḻə' gwnabia' xen par nic̱h chnabi'e na' chebeɉe' beṉə' xni'a de'e malən'. Na' ḻe'enə' chene'ene' gaquəlene' yoguə' chio'o beṉə' Izrael par nic̱h yediṉɉecho xtoḻə'əchon' na' yezi'ixene' c̱hecho. ");
INSERT INTO zavNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Neto' ṉezeto' can' ben Diozən' len Jeso'osən' na' cho'eto' dižə' c̱hei, na' ḻeczə Spirit c̱he Diozən' ṉezczen na' cho'en dižə' c̱hei na' Diozən' babseḻe'e Spirit c̱he'enə' zon ḻo'o yic̱hɉla'aždao' beṉə' ca' choso'ozenag c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Na' ḻechguaḻe besə'əža'a beṉə' gwnabia' ca' catə' gwse'enene' can' gož Bedən' ḻega'aque' na' gwse'enene' so'ote' apostol ca'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero na' lao jontən' zo to beṉə' fariseo beṉə' le Gamaliel. Chsed chlo'ine' beṉə' ḻei de'en bzoɉ de'e Moisezən' na' gwsa'apəchgua beṉə' ḻe' respet. Na' Gamalielən' gwzeche' lao jontən' na' bene' mendad yesə'əchoɉ apostol ca' fuerlə žlac güe'elene' beṉə' ca' ža'anə' dižə'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nach gože' beṉə' ca' ža'anə': ―Beṉə' gwlaž, cheyaḻə' gongaxɉcho xbab nac goncho len beṉə' quinga par nic̱h goncho de'en naquə de'e sin'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ḻe'e yosa'alažə' can' goquə catə' bchoɉ ben' le Teudas gwne' de que naque' beṉə' zaque'e. Na' do tap gueyoa beṉə' boso'ozenag c̱he' na' gwsa'aquene' txen. Pero na' bžin ža gwso'ot beṉə' ḻe' na' besyə'əyasəlas beṉə' ca' gwsa'aque' ḻe' txen, caguə bi goquəch so'one'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nach gwdechlə to beṉə' Galilea ben' le Jodas bchoɉe' ca tyempən' boso'oguaḻe'e yiš baḻə beṉə' ža' to to yež, na' beṉə' zan gwsa'aquene' txen na' ḻeczə bžin ža gwso'ote'ene' na' beṉə' ca' gwsa'aque' ḻe' txen ḻeczə besyə'əyasəlase'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Na' de'e na'anə' choṉa' le'e consejw nga, lɉoye' beṉə' quinga, bito bi gonecho ḻega'aque'. La' šə de'en choso'osed choso'olo'ine'enə' naquən c̱he ḻega'acze' gwžin ža catə' yenitən. ");
INSERT INTO zavNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Na' šə de'en choso'osed choso'olo'ine'enə' naquən c̱he Diozən', bito bi gaquə goncho par cui gasəḻasən. Cheyaḻə' gapcho cuidad par nic̱h cui tiḻəlencho Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Na' gwsa'azlažə' beṉə' gwnabia' ca' can' gož Gamalielən' ḻega'aque'. Nach gwsa'axe' apostol ca' na' gosə'əyine' ḻega'aque' na' gwso'one' mendad cuich no yoso'osed yoso'olo'ine' c̱he Jeso'osən' batə'ətezəchlə. Nach boso'osane' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Na' ca naquə apostol ca' catə' besyə'əchoɉe' gan' gotə' jontən' chesyə'əbeine' de que Diozən' bsi'e xṉeze boso'oc̱hi' boso'osaquə' beṉə' ḻega'aque' por ni c̱he de'en choso'osed choso'olo'ine' c̱he Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Na' yoguə' ža boso'osed boso'olo'iche apostol ca' c̱he Jesocristən' do liž beṉə' na' do catə' chɉa'aque' yo'odao' əblaonə'. ");
INSERT INTO zavNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Na' ca tyempən' zda chanch beṉə' ca' chso'onḻilažə' Jesocristən' na' beṉə' ca' chso'e dižə' griego gwzolao chəsə'əže'eše'e c̱hedə' no'olə gozeb ca' entr ḻega'aque' bito chəsə'əzi'e lebe len no'olə gozeb ca' entr beṉə' ca' chso'e dižə' ebreo catə' chəsə'əyise' de'en chse'eɉ chsa'o to toga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nach apostol ca' šižiṉ bosyo'otobe' yeziquə'əchlə beṉə' ca' chso'onḻilažə' Jesocristən' na' gwse'e ḻega'aque': ―Bito naquən güen par neto' cuezəto' cuich əgwsed əgwlo'ito' beṉə' xtižə' Diozən' par nic̱h c̱histo' de'en əse'eɉ əsa'o beṉə'. ");
INSERT INTO zavNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","De'e na'anə' beṉə' bišə', ḻecueɉ gažə beṉə' entr le'e, beṉə' chnabia' Spirit c̱he Diozən' yic̱hɉla'ažda'oga'aque'enə', beṉə' zɉənaquə beṉə' sin' na' beṉə' chso'on de'e güenṉə', na' ḻe'e gon lao na'aga'aque' yesə'əyise' de'en əse'eɉ əsa'o beṉə' ca'. ");
INSERT INTO zavNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Na' neto' sotezə soto' gonto' orasyonṉə' na' əgwsed əgwlo'ito' beṉə' xtižə' Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Na' gwsa'azlažə' yoguə' beṉə' ca' gwso'one' can' gwse' apostol ca' ḻega'aque', na' gosə'əbeɉe' to beṉə' le Esteban, beṉə' chonḻilažə'əchgua Diozən' na' chnabi'achgua Spirit c̱he Diozən' yic̱hɉla'aždaogüe'enə'. Na' ḻeczə gosə'əbeɉe' Lip na' Procoro na' Nicanor na' Timon, na' Parmenas na' Nicolas beṉə' Antioquia, beṉə' ben cuine' beṉə' Izrael. ");
INSERT INTO zavNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Na' boso'ozoe' ḻega'aque' lao apostol ca' par nic̱h apostol ca' gwso'one' orasyon c̱hega'aque' na' boso'ox̱oa na'aga'aque'enə' yic̱hɉ beṉə' ca' par gwso'o lao na'aga'aque'enə' žinṉə' de'en so'one'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Na' beṉə' zanch gwse'enene' xtižə' X̱ancho Jesocristən', na' zan beṉə' Jerosalenṉə' gwso'onḻilaže'ene' na' ḻeczə zan bx̱oz ca' boso'ozenague' na' gwse'eɉḻe'e xtiže'enə' de'en boso'osed boso'olo'ine'. ");
INSERT INTO zavNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Na' ca naquə Estebanṉə' gwzochgua yeḻə' guac c̱he Diozən' len ḻe' na' Diozən' goclenchgüe' ḻe'. De'e na'anə' bene' miḻagr na' bichlə de'e zaquə' yesyə'əbane beṉə' lao beṉə' ca' ža' Jerosalenṉə'. ");
INSERT INTO zavNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Na' zo to yo'oda'onə' de'en chəsə'əne' “Yo'odao' c̱he Beṉə' ca' Gwsa'ac Esclabos”. Beṉə' ca' chəsə'ədopə chəsə'əžag na' za'aque' Sirene na' Alejandria, na' Silisia na' Asia, na' baḻə beṉə' ca' gwzolao gwsa'acyože' Estebanṉə'. ");
INSERT INTO zavNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero na' bito besyə'əželene' nac yosyo'oži'e xtižə' Estebanṉə' c̱hedə' Spirit c̱he Diozən' bnežɉon ḻe' yeḻə' sin' na' bzeɉni'in ḻe' bin' gwne'. ");
INSERT INTO zavNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nach gosə'əgo'oyeḻe'e to c̱hopə beṉə' par boso'ox̱oayague' gosə'əne' de que Estebanṉə' babžia bnite'e de'e Moisezən' ben' bzoɉ ḻei c̱he beṉə' Izrael ca' na' ḻeczə gosə'əne' de que babžia bnite'e Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Na' beṉə' ca' gwsa'acyožə Estebanṉə' boso'ota boso'oṉe' beṉə' lao syodan' na' beṉə' golə blao c̱he beṉə' Izrael ca' na' beṉə' ca' choso'osed choso'olo'i ḻei de'en bzoɉ de'e Moisezən'. Na' ɉa'acdoe' gan' zo Estebanṉə' na' gwso'ox̱e'ene' na' gosə'əc̱he'ene' gan' ža' beṉə' ca' chəsə'ənabia' Izraelən'. ");
INSERT INTO zavNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nach besyə'əyilɉe' beṉə' soe' dižə' güenḻažə' beṉə' gosə'əne' c̱he': ―Benga cuiczə žizə zoe' chžia chnite'e yo'odao' əblao nga na' ḻei de'en bzoɉ de'e Moisezən'. ");
INSERT INTO zavNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Babeneto' ne' de que Jeso'os beṉə' Nasaretən' yoc̱hiṉɉe' yo'odao' əblaonə' na' yoše'e costombr c̱hecho ca' de'en ben de'e Moisezən' mendad ṉaocho. ");
INSERT INTO zavNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Na' beṉə' gwnabia' ca' na' notə'ətezəchlə beṉə' ca' zɉəchi' gan' chso'one' yeḻə' jostisən' besə'əgüie' cho'alao Estebanṉə' na' besə'əle'ine' chactitən ca cho'alao angl. ");
INSERT INTO zavNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nach ben' naquəch bx̱oz əblaonə' gože' Estebanṉə': ―¿Enaquən ca nga chəsə'əna beṉə' quinga? ");
INSERT INTO zavNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nach Estebanṉə' gože' ḻega'aque': ―Le'e beṉə' golə na' le'e beṉə' xcuidə', ḻegwzenag c̱hia' len to c̱hopə de'e əṉia' le'e. Diozən' ben' naquə ḻe'ezelaogüe beṉə' zaque'e bloe' laogüe' de'e x̱axta'ocho Abraanṉə' catə'ən gwzoe' Mesopotamian' antslə ze'e žɉəsoe' Aranṉə'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Na' Diozən' gože'ene': “Bchoɉ lažo'onə' na' ladɉo beṉə' famiḻy c̱hio' na' gwyeɉ ɉəso' latɉə gan' gwlo'ida' le'.” ");
INSERT INTO zavNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nach de'e Abraanṉə' bchoɉe' gan' ža' beṉə' Caldea ca' na' ɉəsoe' Aranṉə'. Na' bžin ža got de'e x̱e'enə' na' gwdechlə Diozən' gwc̱he'e de'e Abraanṉə' nga gan' zocho. ");
INSERT INTO zavNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Diozən' bito bnežɉue' de'e Abraanṉə' yežlyonə' gaquən c̱he', ni to pedas da'ozən', sino bene' lyebe de que gaquən c̱he beṉə' ca' ze'e za'ac lao dia c̱he'enə' catə' bagote', ḻa'aṉə'əczə cui no xi'iṉe' ṉe'e so catə'ən gož Diozən' ḻe' ca'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nach Diozən' ḻeczə gože'ene' de que xi'iṉ dia c̱he'enə' žɉəsə'ənite'e laž beṉə' zitə' tap gueyoa iz gan' əsa'aque' esclabos na' yesə'əžaglaochgüe'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nach Diozən' gože'ene': “Nada' gwnežɉua' castigw c̱he ṉasyonṉə' gan' so'one' xi'iṉ dia c̱hio' ca' esclabos na' gona' ca yesyə'əchoɉ xi'iṉ dia c̱hio'onə' na' da'aque' əso'elaogüe'e nada' nga.” ");
INSERT INTO zavNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nach Diozən' bene' lyebe len de'e Abraanṉə' de que gone' güen len xi'iṉ dia c̱he'enə'. Na' bene' mendad so Abraanṉə' to señy de'en ne' sirconsision, ḻe' na' len beṉə' byo ca' za'ac lao dia c̱he'enə' par gacbia' de que chse'eɉḻe'e c̱he lyebe de'en bene'enə'. De'e na'anə' catə' golɉə xi'iṉe' Isaaquən' bzo'ebo' señyən' to xmanzebo', na' ḻeczə can' ben de'e Isaaquən' catə' golɉə xi'iṉe' Jacobən'. Na' ca'aczə ben de'e Jacobən' len de'e xi'iṉe' ca' šižiṉnə' beṉə' ca' gwsa'ac šižiṉ dia c̱he chio'o beṉə' Izrael. ");
INSERT INTO zavNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Na' xi'iṉ de'e Jacobən' be'en le Jwse, beṉə' biše'e ca' gwsa'acxi'ine' ḻe' na' gwso'ote'ene' gosə'əzi' beṉə' Egipto ca' ḻe'. Pero Diozən' gwzoe' len Jwsen'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Na' goclene'ene' na' bebeɉe'ene' lao yoguə'əḻoḻ de'en bžaglaogüe'enə'. Na' Diozən' bene' par nic̱h de'e Rei Faraonṉə' ben' chnabia' Egipton' bebeine' ḻe' na' gwleɉe' ḻe' par goque' goberṉador c̱he Egipton' na' Faraonṉə' bzo'ene' bgüia bye' ližen'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Na' gwche' to bgüin doxen Egipton' na' ḻeczə can' goquə Canaanṉə' na' de'e x̱axta'ocho ca' bito besə'əželene' de'e əsa'ogüe' na' besə'əžaglaochgüe'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pero na' bžin ža bene de'e Jacobən' rsonṉə' de trigw Egipton' na' bseḻe'e de'e x̱axta'ocho ca' tši'i ɉəsə'əxi'en. ");
INSERT INTO zavNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Na' bec̱hop ši'i ɉa'aque' catə' ben Jwsen' ca besyə'əyombia' beṉə' biše'e ca' ḻe', na' gwṉeze Faraonṉə' ca zɉənaquə famiḻy c̱he Jwsen'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Na' Jwsen' bene' mendad žɉəsyə'əxi'e x̱aga'aque' Jacobən' na' yoguə'əḻoḻ bišə' lɉuežɉe' ca', naquə ca do gyonšino'e. ");
INSERT INTO zavNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Can' goquə gwyeɉ Jacobən' Egipton' na' Egipto na' gote', na' ḻeczə na' gwsa'at xi'iṉe' ca' beṉə' ca' zɉənaquə x̱axta'ocho. ");
INSERT INTO zavNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Na' gwdechlə besyə'əyo'e cuerp c̱hega'aque'enə' na' ɉəsyə'əcuaše'ene' to ḻo'o bloɉ ba gan' nzi' Siquem, to yežlyo de'en gwxi' Abraanṉə' de'en gwso'otə' xi'iṉ Amor beṉə' Siquem. ");
INSERT INTO zavNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Na' catə' bazon əžin tyemp əgwnežɉo Diozən' ḻega'aque' yežlyon' can' bene' lyebe len de'e Abraanṉə', bazda chan beṉə' Izrael ca' ža' laž beṉə' Egipto ca'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Na' ca' chac beža' rei c̱he Egipton' na' rei cobən' bito gwṉezene' can' goquəlen Jwsen' ṉasyon Egipton'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Na' rei nga gwdilɉlaže'e bin' əbde'ine' par bene' mal len de'e x̱axta'ocho beṉə' Izrael ca', na' bene' mendad žɉəsə'əcho'on xi'iṉga'aque'enə' par nic̱h yenit dianə'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Na' ca tyempən' golɉə de'e Moisezən' na' bebei Diozən' ḻe' na' x̱axne'enə' bosyo'osc̱ha'ogüe' ḻe' šoṉə bio'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Pero na' bžin ža benən byen ɉəsə'əcho'one'ebo', na' xi'iṉ rein' to no'olə beželene'ebo' na' beyo'ebo' liže'enə' bosc̱ha'ogüe'ebo' ca xi'iṉe'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ca' goquən' bsed de'e Moisezən' tcho'a tšao' yeḻə' sin' c̱he beṉə' Egipto ca', na' bene' de'e zaque'e na' be'e dižə' de'e zaque'e. ");
INSERT INTO zavNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Na' c̱hoa ize de'e Moisezən' catə' gwnan žɉəlaṉe'e beṉə' Izrael gwlaž c̱he' ca'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Na' ɉəle'ine' to beṉə' Egipton' chc̱hi' chsaque'e to beṉə' Izraelən', na' goclene' beṉə' Izraelən' na' bete' beṉə' Egipton'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","De'e Moisezən' bene' xbab se'eɉni'i beṉə' Izrael gwlaž c̱he' ca' de que Diozən' gaquəlene'ene' par yosle' ḻega'aque' lao na' beṉə' Egipto ca', pero na' bito gwse'eɉni'i beṉə' Izrael ca'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Na' beteyo gosə'ədiḻə c̱hopə beṉə' Izrael ca' entr ḻega'acze'. Na' bžin de'e Moisezən' goquene' gone' par nic̱h yenite'e binḻo, na' gože' ḻega'aque': “¿Bixc̱hen' chdiḻəlen lɉuežɉle ca' entr beṉə' gwlažzle?” ");
INSERT INTO zavNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nach ben' napə doḻə'ənə' bžigue'e de'e Moisezən' ca'aḻə gože'ene': “¿No gwna le' gaco' beṉə' gwnabia' par gono' yeḻə' jostis c̱heto'onə'? ");
INSERT INTO zavNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Elezə che'endo' goto' nada' can' beto' beṉə' Egipton' ṉeɉen'?” ");
INSERT INTO zavNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","30","Na' catə' bene de'e Moisezən' can' gož be'enə' ḻe', nach bxoṉɉe' ɉəsoe' c̱hoa iz gan' nzi' Madian ḻa'aṉə'əczə naque' beṉə' zitə' len beṉə' ca'. Na' bšagne'e na' na' gwnitə' c̱hopə xi'iṉe'. Na' goc c̱hoa iz zoe'enə' catə' bloe' lao to angl ḻe' latɉə dašən' gaḻə'əzə ya'a Sinai. Yo'o anglən' to ḻo'o yi' beḻ chdolɉən to ḻo'o xis yešə'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Na' catə' ble'i de'e Moisezən' can' chaquən' bebanene', nach bgüigue'e yelatə' par ble'iša'ogüe'ene' na' benene' choḻgüiž X̱ancho Diozən' ḻe' che'ene': ");
INSERT INTO zavNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Nada' naca' Dioz na' de'e x̱axta'ogo'o Abraanṉə', Isaaquən' na' Jacobən' gwso'elaogüe'e nada'.” De'e Moisezən' bžebe', caguə cheyaxɉene' əggüie'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Na' gož X̱anchon' ḻe': “Gwlec̱hɉ xelo'onə' par gapo' nada' respet la' latɉə gan' zecha'onə' naquən c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nada' ble'ida' yeḻə' yašə' yeḻə' zi'inə' chde ṉasyon c̱hia' Izraelən' Egipton' na' babenda' can' chso'onyašə'əga'aque'. De'e na'anə' gaquəlenga'aca'ane'. Da nic̱h əseḻa'a le' Egipton'.” ");
INSERT INTO zavNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Diozən' gože'ene' ca' ḻa'aṉə'əczə antslə beṉə' Izrael ca' cui gosə'əzi'e c̱he' na' gwse'ene': “¿No gwna le' gaco' beṉə' gwnabia' par gono' yeḻə' jostis c̱heto'?” Diozən' bseḻe'e de'e Moisezən' par gwnabi'e de'e x̱axta'ocho ca' na' par nic̱h bebeɉe' ḻega'aque' lao na' beṉə' Egipto ca', na' angl c̱he Diozən' ben' gwyo'o ḻo'o yi' beḻən' gwzoe' goclene'ene'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Na' de'e Moisezən' bebeɉe' ḻega'aque' Egipton' bene' zan miḻagr na' bichlə de'e zaquə' yebanecho Egipton', na' nisdao' Exṉan' na' latɉə dašən' lao c̱hoa iz. ");
INSERT INTO zavNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Na' de'e Moisez na'anə' gože' de'e x̱axta'ocho ca': “X̱ancho Diozən' seḻe'e yeto beṉə' lao dia c̱hele par güe'elene' le'e xtiže'enə' can' bseḻe'e nada'. C̱he be'enan' əgwzenagle.” ");
INSERT INTO zavNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","De'e Moisezən' gwzoe' len de'e x̱axta'ocho ca' latɉə dašən'. Na' anglən' be'elene' ḻe' dižə' lao ya'a Sinain' gože' ḻe' dižə' de'e zaquə' əgwzenagcho c̱hei na' de'e cui te c̱hei. Na' de'e Moisezən' bzeɉni'ine'en de'e x̱axta'ocho ca' zɉəndopə zɉənžag gaḻə'əzə ya'anə'. na' Moisezən' bzoɉe' dižə'ənə' par chio'o. ");
INSERT INTO zavNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Pero na' de'e x̱axta'ocho ca' bito boso'ozenague' c̱he de'e Moisezən', boso'ozo'ene' ca'aḻə. Gwse'enene' žɉəya'aque' Egipton'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Na' lao zda de'e Moisezən' lao ya'a Sinain', gwse'e beṉə' biše'e Ronṉə': “Ben lgua'a lsaquə' de'en šeɉṉi'alažə'əcho, de'e yesə'əbialao lao chio'o tnezən'. La' ca naquə Moisezən' ben' bebeɉ chio'o Egipton' cuili bin' bagoc c̱he'.” ");
INSERT INTO zavNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nach gwso'one' to me'e go'oṉ dao' de or na' gwso'ote' no bia yix̱ə' par gwso'elaogüe'eb na' gwnite'e chesyə'əbeine' len de'en gwso'one' len ṉi'a na'aga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","De'e na'anə' Diozən' gwleɉyic̱hɉe' ṉasyon Izraelən' na' be'e latɉə gwse'eɉṉi'alaže'e bgüižən', bio'onə' na' belɉw ca'. Na' nyoɉ de'en gwna Diozən' can' gwso'one' nan: Le'e beṉə' Izrael, caguə nadan' be'ela'ole catə'ən betle bia yix̱ə' latɉə dažən' lao c̱hoa iz. ");
INSERT INTO zavNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Benḻe no lgua'a lsaquə'ən gwyeɉṉi'alažə'əle, na' bi'ale yo'o de lachə'ən gan' gwyeɉṉi'alažə'əle lgua'a lsaquə' de'en ne' Moloc, na' bi'ale belɉon' gwyeɉṉi'alažə'əle de'en nzi' Renfan. Na' de'en bagwleɉyic̱hɉle nada' de'e na'anə' cueɉa' le'e gan' zolen' na' seḻa'a le'e zitə' gan' nzi' Babilonia. ");
INSERT INTO zavNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Na' žlac chaše' latɉə dašən' de'e x̱axta'ocho ca' gwso'one' to yo'o de lachə' gan' ža' yeɉ ta'a ca' gan' nyoɉ ḻei c̱hega'aque'enə'. Na' gwso'one'en con can' gož Diozən' de'e Moisezən' na' con can' blo'ine' ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","De'e x̱axta'ocho ca' boso'osa'ate' yo'o de'e lachə' c̱hega'aque'enə' na' yeɉ ta'a ca' gan' nyoɉ ḻei c̱hechonə' con ga ɉa'aque', gwzolaozən tyemp c̱he de'e Moisezən' na' gwzelaon tyemp c̱he de'e Rei Dabin'. Na' gwde got de'e Moisezən' de'e Josuen' gwc̱he'e ḻega'aque' yežlyon' de'en ben Diozən' lyebe gwnežɉue' ḻega'aque', na' Diozən' bene' beṉə' ca' ža' yež ca' lao na'aga'aque' catə' gosə'ədiḻəlene' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Na' Diozən' bebeine' de'e Rei Dabin', na' de'e Dabin' gone'ene' gone' to yo'odao' par Diozən', Dioz ben' ḻeczə gwyeɉṉi'alažə' de'e Jacobən' cana'ate. ");
INSERT INTO zavNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero na' Diozən' bito be'e latɉə gon de'e Dabin' yo'oda'onə', sino de'e xi'iṉe' Salomonṉə' bene'en. ");
INSERT INTO zavNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Na' bito əṉacho de que Diozən' ben' chnabia' doxenḻə zoe' do ḻo'o yo'o de'e chon beṉac̱hən', sino chac can' gwna Diozən' de'en bzoɉ to profet beṉə' be' xtiže'enə' cana' nan: ");
INSERT INTO zavNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Nada' zoa' yoban' chnabia' na' guaquə gona' par nic̱h gaquə con bin' che'enda' lao yežlyon'. ¿Ena' chaquele gonḻe to liža'anə' ža? Nada' bito chyažɉda' yo'o gan' gona' dezcanz. ");
INSERT INTO zavNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nada' bena' yoguə'əte de'e zɉəde. ");
INSERT INTO zavNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","De'en cui chzenagle, de'en cui cheɉḻe'ele ḻo'o la'ažda'olen' naquəchguale beṉə' žod can' gwsa'ac de'e x̱axta'ocho ca'. Cuiczə chzenagle c̱he Spirit c̱he Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","De'e x̱axta'ocho ca' ḻeczə boso'oc̱hi' boso'osaque'e de'e profet ca' beṉə' ca' gwso'e xtižə' Diozən' cana' na' gwso'ote' ḻega'aque' catə'ən gwso'e dižə' can' seḻə' Diozən' Xi'iṉe'enə' ben' naquə ḻe'ezelaogüe beṉə' güen. Na' catə' bide'enə' le'e əbdelene' lao na' beṉə' ca' gwso'ote'ene'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ḻa'aṉə'əczə nombi'ale ḻein de'en bnežɉw angl ca' de'e Moisezən' cana', bitoczə chzenagle c̱hei. ");
INSERT INTO zavNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Na' catə' Estebanṉə' gože' ḻega'aque' ca' ḻechguaḻe besə'əloque' xte gwsa'oxoɉə leyga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero na' Estebanṉə' chnabi'achgua Spirit c̱he Diozən' ḻe', bcos laogüe'en chgüiachgüe' yobalən' na' ble'ine' yeḻə' chey che'eni' c̱he Diozən' na' ble'ine' zecha Jeso'osən' cuit Diozən' chnabi'e txen len ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nach Estebanṉə' gwne': ―Ḻe'e ggüiašc nḻa'axeɉə yoban' na' nḻa' zecha Jeso'osən' ben' golɉə beṉac̱h cuit Diozən' chnabi'e txen len ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nach beṉə' ca' zɉənžaguən' chso'osya'adie' na' boso'oseyɉw nagga'aque'enə' nach tši'izə ɉa'acdoe' gan' ze' Estebanṉə'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nach gosə'əbeɉe' Estebanṉə' fuerlə syodan' na' boso'ošiže'ene' yeɉ. Na' beṉə' ca' boso'ošižə ḻe' yeɉən' boso'onežɉo xaga'aquen' de'en zɉənchele'enə' to beṉə' güego' beṉə' le Saul par nic̱h gwdape'en. ");
INSERT INTO zavNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Na' žlac choso'ošiže'e Estebanṉə' yeɉən', Estebanṉə' bene' orasyonṉə' gwne': ―X̱ana' Jeso'os, bezi' nada' yoban'. ");
INSERT INTO zavNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nach bzo xibe' lao yon' na' gwṉe' zižɉo gwne': ―X̱ana' bito gwnežɉo' castigw c̱he beṉə' quinga de'en bagwso'onene' nada'. Na' beyož gwne' ca', gote'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Na' beṉə' ca' chso'onḻilažə' Jesocristən' Jerosalenṉə' ɉəsə'əcuaše'e de'e Esteban', na' gosə'əbežchgüe' c̱he'. Na' ca naquə Saulən' ža, gwyazlaže'e de'en gwso'ote' de'e Estebanṉə'. Na' gwde gwso'ote' de'e Estebanṉə' beṉə' blao ca' gosə'əzolaogüe' boso'olagzeɉə boso'olagzide' beṉə' ca' chəsə'ədopə chəsə'əžag chso'elaogüe'e Jesocristən' Jerosalenṉə', na' zan beṉə' ca' chso'elao' Jesocristən' besə'əxoṉɉe' ɉa'aque' do Jodean', do Samarian', pero bito len apostol ca'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Na' Saulən' gwzolaogüe' cheɉe' liž to to beṉə' ca' chso'elao' Jesocristən' chɉəxobe' no beṉə' byo na' no no'olə par chc̱he'e ḻega'aque' ližyan'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pero na' beṉə' ca' chso'elao' Jesocristən' lao besə'əxoṉɉe' ɉa'aque' doxenḻə ɉəsə'ədix̱ɉui'e xtižə' Jesocristən'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Na' to beṉə' le Lip beṉə' ḻeczə chonḻilažə' Jesocristən' bžine' to syoda ga mbane Samarian' na' be'e dižə' c̱he Jesocristən'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Na' bene' miḻagr na' catə' besə'əle'ine' miḻagrən' de'en bene' len ḻega'aque' beṉə' zan besə'ədobə boso'ozenague' c̱he'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Bebeɉe' de'e x̱io' ca' zɉəyo'o zɉəyaz ḻo'o yic̱hɉla'aždao' beṉə' zan, na' catə' besyə'əchoɉən' chso'osya'adi'an. Na' zan beṉə' nat to part güeɉə cuerp c̱hega'aque'enə' beyone' na' beyone' no beṉə' coj. ");
INSERT INTO zavNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Na' ḻechguaḻe besyə'əbei beṉə' ca' ža' syodan'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na' lao' syodan' zo to beṉə' goža' beṉə' le Simon. De'e zan de'e bene' antslə de'e besyə'əbane beṉə' Samaria ca', bx̱oayague' ḻega'aque' gože' de que naque' beṉə' zaque'e. ");
INSERT INTO zavNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Na' žlac bene' de'e ca' yoguə' beṉə' lao' syodan' boso'ozenague' c̱he' tcho'a tšao', beṉə' gol ca' na' xte no bi'i xcuidə' na' gosə'əne' c̱he': ―Ḻele bengan' nse'e yeḻə' guac c̱he Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Zan iz boso'ozenagteze' c̱he' c̱hedə' bentontene' yic̱hɉla'ažda'oga'aque'enə' len yeḻə' goža' c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero catə' Lipən' gwdix̱ɉui'e dižə' cobə c̱he Jesocristən' len ḻega'aque' na' bzeɉni'ine' ḻega'aque' can' ṉabia' Diozən' notə'ətezə beṉə' soe' latɉə, na' gwse'eɉḻe'e c̱he', na' gosə'əchoe' nis, beṉə' byo na' no'olə. ");
INSERT INTO zavNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Na' lenczə Simonṉə' gwyeɉḻe'e c̱he', na' gwchoe' nis na' goque' tozə len Lipən' gwdalene' ḻe', na' bebanene' ca naquə miḻagr ca' de'en chon Lipən' na' yeziquə'əchlə de'e zaquə' yebanczecho. ");
INSERT INTO zavNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nach apostol ca' nitə' Jerosalenṉə' gwse'enene' de que beṉə' Samaria ca' bachoso'ozenague' xtižə' Diozən', nach boso'oseḻe'e Bedən' len Juanṉə' Samarian'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Na' catə' besə'əžine'enə' gwso'one' orasyonṉə' par nic̱h so Spirit c̱he Diozən' ḻo'o yic̱hɉla'aždao' beṉə' Samaria ca', c̱hedə' ca orən' bitoṉə' son ḻo'o la'ažda'oga'aque'enə' ḻa'aṉə'əczə bagosə'əcho'e nisən' gosə'əne' so'onḻilaže'e Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nach boso'ox̱oa na' apostol ca' yic̱hɉga'aque'enə' par gwzo Spiritən' ḻo'o yic̱hɉla'ažda'oga'aque'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Na' ble'i Simonṉə' can' chso'on apostol ca' choso'ox̱oa ne'en yic̱hɉ beṉə' par chzo Spiritən' len ḻega'aque', na' bšabene' ḻega'aque' mech. ");
INSERT INTO zavNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Gože' ḻega'aque': ―Ḻegon par nic̱h nada' gaquə x̱oa na'anə' yic̱hɉ beṉə' na' so Spiritən' len ḻega'aque' can' chonḻe. ");
INSERT INTO zavNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nach Bedən' gože'ene': ―Cuiayi'ileno' xmecho'onə' de'en chonḻizo' xbabən' de que guac si'o yeḻə' chnabia' c̱he Diozən' len mech. ");
INSERT INTO zavNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Bito zaco'o par gono' ca naquə de'e nga chonto' c̱hedə' yic̱hɉla'ažda'ogo'onə' naquən mal lao Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","De'en cheyaḻə' gono', bediṉɉe ca naquə de'e malən' chono' na' gwnab goclen lao Diozən' par nic̱h yezi'ixene' c̱hio' ca naquə xbabən' yo'o ḻo'o yic̱hɉla'ažda'ogo'onə'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nacbia' chnabia' de'e malən' le' de'en yo'o ḻo'o yic̱hɉla'ažda'ogo'onə' na' ngo'on le' nez malən' gan' cuiayi'o. ");
INSERT INTO zavNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nach Simonṉə' boži'en gože' ḻe': ―Ḻeṉab goclen lao X̱anchon' par nada' nic̱h ni to de'e nga bac̱h gwnao' cui gaquəšga c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Na' lao zɉəya'ac Bedən' len Juanṉə' Jerosalenṉə' gwso'eche' xtižə' Diozən' len beṉə' ža' yež zan gan' mbane Samarian' na' gwso'e dižə' can' bagoclen Diozən' ḻega'aque'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nach X̱ancho Diozən' bseḻe'e to angl par gože' Lipən': ―Gwyeɉ gan' xoa nez de'en chetɉ Jerosalenṉə' na' chden latɉə dašən' par yež de'en nzi' Gasa. ");
INSERT INTO zavNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Nach Lipən' gwlo'e nezən' na' lao zde'enə' ble'ine' to beṉə' Etiopia zeyo'e to ḻo'o carret zeze'e gwyeɉe' Jerosalenṉə' ɉe'elaogüe'e Diozən'. Ḻe' naque' to beṉə' eunoco na' naque' tesorer c̱he no'olə gwnabia' c̱he beṉə' Etiopia ca' no'olən' le' Candase, na' yo'ote lao na' tesorerən' yoguə'əḻoḻte byen c̱he no'olə gwnabia'anə'. Na' lao zeyo'e ḻo'o carretən' chlabe' ḻibr de'en bzoɉ de'e profet Isaiazən' ben' be' xtižə' Diozən' cana'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nach Spirit c̱he Diozən' gožən Lipən': ―Ɉəyexen carretən' na' gwyeɉlene' txen. ");
INSERT INTO zavNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nach gwyeɉdoch Lipən' par ɉəyexene' carretən' na' benene' chlab ben' ḻibr de'en bzoɉ de'e profet Isaiazən'. Nach gože'ene': ―¿Echeɉni'ido' de'en chlabo'onə'? ");
INSERT INTO zavNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Na' tesorerən' boži'en gože' Lipən': ―¿Nacxa gaquə šeɉni'ida'anə'? la' caguə no nḻa' no əgwzeɉni'ine'en nada'anə'. Nach gotə'əyoine' Lipən' par nic̱h gwloe Lipən' gwche'elene'ene'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na' part de'en chlabe'enə' nyoɉən' nan: Ca to xilə' bia nxobə beṉə' par gote'eb, na' ca to xilə' dao' bia cui chosya'a catə' chšibe'eb, can' gone', bito bi əṉe' catə'ən yesə'əzi'ic̱hiže'ene'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Na' yesə'əque'e yeḻə' bala'aṉ c̱he'enə'. Na' bito so'one' yeḻə' jostis c̱he' can' cheyaḻə' gaquən. Na' tant beṉə' mal ša' ca tyempən', so'ote'ene' ḻa'aṉə'əczə bito bi de'e mal none'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nach tesorerən' gože' Lipən': ―Benšga goclen gwna nada' no c̱hein' na profetən' ca', ¿əc̱he cuine'en ne' ca' o šə c̱he beṉə' yoblə? ");
INSERT INTO zavNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Nach Lipən' gwzolaogüe' bzeɉni'ine' bi zeɉen part gan' chlab tesorerən' na' ḻeczə gož Lipən' le' c̱he dižə' güen dižə' cobə c̱he Jeso'osən'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Na' ca' chac besə'əžine' ga žia nis, nach tesorerən' gože' Lipən': ―Nga žia nis. ¿Ecabi gaquə c̱hoa' nisən' ṉa'a? ");
INSERT INTO zavNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Nach Lipən' gože'ene': ―Šə cheɉḻi'o c̱he Jesocristən' do yic̱hɉ do lažo'o, guaquə c̱ho' nisən'. Nach gwne': ―Cheɉḻi'a de que Jesocristən' naque' Xi'iṉ Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nach bene' mendad bcuezə ben' chsa' carretən' ḻen, nach betɉ Lipən' len tesorerən' ɉəsə'əžo'e ḻo'o nisən' par nic̱h Lipən' bc̱ho'ene' nis. ");
INSERT INTO zavNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Na' catə' besyə'əchoɉe' ḻo'o nisən', Spirit c̱he Diozən' ḻe'e bec̱he'ete Lipən' ga yoblə, na' bitoch ble'i tesorerən' ḻe'. Na' mbalaz beza' tesorerən' beyo'e ḻo'o carretən'. ");
INSERT INTO zavNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Nach Lipən' bžine' yež de'en nzi' Asoto na' gwzolaogüe' gwdix̱ɉui'e dižə' güen dižə' cobə c̱he Jesocristən' to to yež de'e zɉəchi' gaḻə'əzə xte bžinte' Sesarean'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Na' Saulən' con chdacze' cho'e dižə' can' chene'ene' gote' beṉə' ca' chso'onḻilažə' X̱ancho Jesocristən' na' chdacze' cheyilɉlaže'e naclə gone' gote' ḻega'aque'. Na' de'e na'anə' gwyeɉe' lao beṉə' gwnabia' c̱he bx̱oz c̱he ṉasyon Izraelən'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Na' Saulən' gwṉabene' beṉə' gwnabia'anə' to yiš de'e gox̱e'e yoso'olab beṉə' ža' to to yo'odao' ca' nitə' Damascon' na' güe'en dižə' əṉan de que nape' yeḻə' gwnabia' par sene' beṉə' ca' bachso'onḻilažə' Jesocristən' na' gwc̱heɉe' ḻega'aque' par əc̱he'e ḻega'aque' Jerosalenṉə', ḻa'aṉə' beṉə' byo o no'olə. ");
INSERT INTO zavNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Na' bnežɉue'ene' yišən' nach gwlo'e nezən' na' bazon əžine' Damascon' catə' to de repentzə to be'eni' de'e za' yoban' gwyec̱hɉən ḻe'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Na' bgüix̱e' lao yon'. Na' lao de'enə' benene' che' to beṉə' ḻe': ―Saul, ¿bixc̱hen' nḻagzeɉə nḻagzido' nada'? ");
INSERT INTO zavNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nach Saulən' boži'en gože': ―¿No le' Señor? Nach be'enə' gože'ene': ―Nada' Jeso'osən' nḻagzeɉə nḻagzido'. Na' de'en chono' contr nada', chone zi' cuino' can' chac c̱he to go'oṉ bia'an chlibə lao ya la de'en zo lao garrošən'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Na' do chaž do chžebze' gože': ―X̱ana' Jeso'os, ¿bin' che'endo' gona'? Nach X̱anchon' gože'ene': ―Beyas na' gwyeɉ syoda Damascon' na' to beṉə' əṉe' le' de'en cheyaḻə' gono'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Na' beṉə' ca' žag Saulən' benit bec̱hoḻ goc ḻo'o yic̱hɉla'aždaoga'aque'enə' de'e tant besə'əžebe' de'en goquən' na' de'en gwse'enene' xnen' na' cui no besə'əle'ine'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nach beyas Saulən', pero catə' bex̱a ɉelaogüe'enə' con cuich ble'ine'. Na' beṉə' ca' nžague'enə' gwso'ox̱e'e ne'enə' gosə'əc̱he'ene' Damascon'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Na' šoṉə ža gwzoe' sin cui ble'ine' na' bito güe'eɉ gwdaogüe'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Na' zo to beṉə' chonḻilažə' X̱ancho Jesocristən' Damascon' beṉə' le Ananias, na' Ananiasən' ble'idaogüe'ene' X̱anchon'. Na' X̱anchon' gože'ene': ―Ananias. Na' boži'en gože': ―Nga zoa' X̱ana'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Nach X̱anchon' gože'ene': ―Gwzoža' na' gwyeɉ liž Jodas de'en zo lao lqueyən' de'en nzi' “De'e Ḻicha”, na' ṉabo' to beṉə' le Saul beṉə' Tarso. Bachone' orasyon. ");
INSERT INTO zavNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Na' babena' par ble'idaogüe'ene' le' gwyo'o yo'o gan' zoe'enə' na' bx̱oa na'onə' ɉela'ogüe'enə' par nic̱h yele'ine'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nach Ananiasən' boži'en gože': ―X̱ana', babenda' beṉə' zan chso'e xtižə' benga ca naquə de'e mal juisyən' babene' Jerosalenṉə' len beṉə' ca' bagwleɉo' par zɉənaque' lažə' na'onə'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Na' chəsə'əne' ze'e nga nox̱e'e yiš c̱he bx̱oz əblao ca' par sene' yoguə'əḻoḻ neto' chonto' orasyon choḻgüižto' le'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nach X̱ancho Jesocristən' gože' Ananiasən': ―Gwyeɉ, la' bagwleɉa' Saulən' par nic̱h šeɉe' entr beṉə' Izrael ca' na' beṉə' ca' cui zɉənaquə beṉə' Izrael na' do lao rei par əgwzeɉni'ine' ḻega'aque' c̱hia' nada'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Na' gwlo'ida'ane' ca naquə de'e yašə' de'e zi' de'e gaquə c̱he' de'en əgwzenague' c̱hia'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nach Ananiasən' gwyeɉe' gan' zo Saulən' na' gwyo'e ḻo'o yo'onə' na' bx̱oa ne'enə' ɉelao Saulən' gože'ene': ―Saul dao', X̱ancho Jeso'osən' ben' əbloe' laogüe' le' tnez gan' za'onə' babseḻe'e nada' par zedəlaṉa'a le' par nic̱h yele'ido' na' yedəṉabia' Spirit c̱he Diozən' le'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nach ḻe'e besyə'əyiṉɉte de'e ca' ža' ɉelaogüe' ca' zɉənaquən ca no yid bdi'eɉ na' ḻe'e bele'iteine'. Nach ḻe'e gwzoža'ate' par gwyeɉe' gan' gwchoe' nisən'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Na' gwdechlə beyaogüe' na' beyaclaže'e. Na' bega'aṉe' Damascon' yeto c̱hopə ža len beṉə' ca' chso'onḻilažə' X̱anchon'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Na' lgüegwzə gwzolao gwyeɉe' to to yo'odao' par be'e dižə' c̱he Jeso'osən' de que naque' Xi'iṉ Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Na' yoguə' beṉə' ca' chse'enene' dižə' de'en be'enə' chesyə'əbanene' na' chse' lɉuežɉga'aque': ―¿Ecaguə bengan' chda choṉit choḻane' beṉə' ca' chso'on orasyonṉə' lao Jeso'osən' Jerosalenṉə'? na' ¿əcaguə par na'aczən' bide' nga ṉa'a, par əgwc̱heɉe' beṉə' ca' na' žɉue'e ḻega'aque' lao bx̱oz əblao ca'? ");
INSERT INTO zavNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero na' Saulən' tža tža goquəch be'e dižə' len yeḻə' chnabia' c̱he Diozən' na' Diozən' goclene'ene' par be'e dižə' c̱he Jeso'osən' clar de que naque' ben' bseḻə' Diozən' par chaclene' beṉac̱hən', na' beṉə' Izrael ca' ža' Damascon' bito besə'əželene' bin' yesə'əne' c̱hedə' gwsa'acbe'ine' de que de'en che'e ḻega'aque' naquən de'e ḻi. ");
INSERT INTO zavNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Na' catə' bagoc sša cho'elen Saulən' beṉə' Damasco ca' xtižə' Jesocristən' nach boso'oxia beṉə' Izrael ca' so'ote' Saulən'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Na' gosə'ənite'e chsa'ape' to to cho'a puert c̱he ze'enə' de'en nyec̱hɉ syodan' par yesə'əzene' Saulən' so'ote'ene' batə'ətezə yechoɉe' pero na' Saulən' gocbe'ine' ca naquən' bazɉəchi'inaogüe'ene'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Nach beṉə' ca' chso'onḻilažə' Jesocristən' besyə'əletɉe'ene' ḻe'e ze'enə' še'elə besyə'əgüe'ene' to ḻo'o žomə cuent goc bechoɉe' lao' syodan'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Na' catə' bežin Saulən' Jerosalenṉə' gone'ene' lene' beṉə' ca' chso'onḻilažə' Jesocristən' na', pero yoguə'əḻoḻe' besə'əžebe' ḻe', bito gwse'eɉḻe'e šə de'e ḻi bachonḻilaže'e Jesocristən'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Nach Bernaben' gwc̱he'e Saulən' ɉa'aque' gan' ža' apostol ca' na' be'elene' ḻega'aque' dižə' can' goquə c̱he Saulən' lao ngüe'e nezən' zde' Damascon' gože' ḻega'aque' de que X̱ancho Jeso'osən' be'elene' Saulən' dižə'. Na' ḻeczə gož Bernaben' ḻega'aque' de que Saulən' babe'e xtižə' Jeso'osən' Damascon' sin cui chžebe'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nach apostol ca' gwse'eɉḻe'e can' goc c̱he Saulən', nach gwzolao gwdalen Saulən' beṉə' ca' chso'onḻilažə' Jesocristən' Jerosalenṉə'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Na' sin cui bi chaž chžebe' gwzolaogüe' chzeɉni'ine' beṉə' Izrael ca' dižə' c̱he X̱ancho Jeso'osən'. Na' be'e dižə' len beṉə' ca' chsa'ac por dižə' griego, bzeɉni'ine' ḻega'aque' xtižə' Diozən' clar, pero na' ḻega'aque' gwse'enczene' so'ote'ene'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Na' gwsa'acbe'i beṉə' ca' chso'onḻilažə' Jesocristən' Jerosalenṉə' de que beṉə' ca' bazɉəchi'inaogüe' so'ote'ene', nach gosə'əc̱he'ene' ɉa'aque' syoda Sesarean' na' bosyo'oseḻe'ene' par syoda Tarson'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Na' ca naquə beṉə' ca' chəsə'ədopə chəsə'əžague' chso'elaogüe'e Jesocristən' doxenḻə Jodean', Galilean' na' Samarian' gosə'ənite'e binḻo, notoch no no boso'oc̱hi' boso'osaquə' ḻega'aque', na' gwyeɉəch gwso'onḻilažə'əche' X̱ancho Jeso'osən' na' boso'ozenague' c̱he' con bin' bzeɉni'ine' ḻega'aque'. Na' Spirit c̱he Diozən' btipəchən lažə'əga'aque' na' benən par gwyanga'aque'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ca naquə Bedən' cheɉe' to to yež gan' ža' beṉə' ca' bagwleɉ Diozən' par zɉənaque' lažə' ne'enə' par chɉəlaṉe'e ḻega'aque', na' to ža gwyeɉe' ɉəlaṉe'e beṉə' ca' ža' Lida. ");
INSERT INTO zavNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Na' yež Lidan' ɉti'e to beṉə' le' Eneas, beṉə' bachac x̱on' iz die' camən' c̱hedə' nat to part cuerp c̱he'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Nach gož Bedən' ḻe': ―Eneas, Jesocristən' cheyone' le'. Gwyas na' btob xcamo'onə'. Nach ḻe'e gwyaste be'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Na' yoguə'əḻoḻ beṉə' ža' Lidan' na' beṉə' ža' yež de'en nzi' Saron besə'əle'ine' be'enə' babeyaquene', na' gosə'əbeɉyic̱hɉe' costombr c̱hega'aque' de'en zɉənaogüe' par gwso'onḻilaže'e X̱ancho Jesocristən'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na' ca tyemp na' to syoda de'en nzi' Jope zo to no'olə le Tabita na' ḻeczə le' Dorcas. Na' chonḻilaže'e Jesocristən' na' zotezə zoe' chone' de'e güen, chaclene' no beṉə' yašə' beṉə' chyažɉ chc̱hine. ");
INSERT INTO zavNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pero na' gocšene Dorcasən' na' gottechgüe' na' besyə'əguazɉe'ene' na' beyož na' gosə'əx̱o'ene' ḻo'o yo'o de'en naquə c̱hop cuia. ");
INSERT INTO zavNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Na' gaḻə'əzə chega'aṉ yež Lidan' len Jopen' na' beṉə' ca' chso'elao' Jesocristən' Jopen' gosə'əṉezene' de que Bedən' zoe' Lidan'. Nach boso'oseḻe'e c̱hopə beṉə' ɉse'etə'əyoine' Bedən' gwse'ene': ―Benšga goclen yo'o len neto' ṉa'atec ṉa'a. ");
INSERT INTO zavNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nach Bedən' ḻe'e gwza'ate' gwyeɉe' len beṉə' ca', na' catə' besə'əžine' Jopen' gosə'əc̱he'ene' ḻo'o yo'o gan' xoa beṉə' guatən' na' ḻe'e gosə'əbiguə'əte yoguə' no'olə gozeb ca' laogüe'enə' chəsə'əbeže' choso'olo'ine' ḻe' lachə' de'en ben de'e Dorcasən' lao bguane', no bestid na' no camis. ");
INSERT INTO zavNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Nach Bedən' gwleɉe' yoguə'əḻoḻ beṉə' ca' chyo'olə na' bzo xibe' bene' orasyon. Na' beyec̱hɉe' chgüie' cuerp c̱he no'olən' na' gože'ene': ―Tabita, gwyas. Nach ḻe'e bex̱a'ate ɉelao de'e Dorcasən' chgüie' Bedən' na' ḻe'e bebe'ete'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Nach Bedən' bex̱e'e ne'enə' bosože'ene' nach goxe' no'olə gozeb ca' na' yeziquə'əchlə beṉə' ca' zɉənaque' lažə' na' Diozən' na' blo'ine' ḻega'aque' de que babeban Dorcasən'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Na' yoguə'əḻoḻ beṉə' Jopen' gwse'enene' rson can' goquən', na' beṉə' zanch gwso'onḻilaže'e X̱ancho Jesocristən'. ");
INSERT INTO zavNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Na' Bedən' bega'aṉe' Jopen' zan ža, gwzoe' liž to beṉə' le Simon, beṉə' gocol yid. ");
INSERT INTO zavNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Na' Sesarea na' zo to beṉə' le Cornelio, naque' capitan c̱he to gueyoa soḻdad, na' zɉənzi'e “Beṉə' Italia”. ");
INSERT INTO zavNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ḻa'aṉə'əczə Cornelion' cui naque' beṉə' Izrael, txen len famiḻy c̱he' ca' chso'elaogüe'e Diozən' na' Cornelion' zotezə zoe' chape' Diozən' respet na' chaclenteze' beṉə' yašə' beṉə' chyažɉ chc̱hine, na' chontezə chone' orasyon lao Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Na' goc c̱he' to ža do cheda šoṉə ble'idaogüe'ene' to angl c̱he Diozən' gwyo'e gan' zo'enə' na' anglən' gože'ene': ―Cornelio. ");
INSERT INTO zavNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nach Cornelion' chgüiachgüe' lao anglən' na' do chžebe' gože'ene': ―¿Bixan' ža X̱ana'? Nach gož anglən' ḻe': ―Diozən' ṉezene' can' zotezə zo' chono' orasyon na' chnežɉo' de'en chəsə'əyažɉe beṉə' yašə', na' Diozən' chene'ene' gaquəlene' le'. ");
INSERT INTO zavNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","De'e nga gono' ṉa'a, bseḻə' beṉə' žɉəsə'əxi'e to beṉə' zo Jopen' beṉə' le Simon na' ḻeczə le Bed. ");
INSERT INTO zavNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Zoe' liž to beṉə' gocol yid na' be'enə' ḻeczə lie' Simon, na' liž ben' zon cho'a nisda'onə'. Na' Simon Bedən' əṉe' le' bin' cheyaḻə' gono'. ");
INSERT INTO zavNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Catə' beza' anglən' Cornelion' goxe' c̱hopə mos c̱he' ca' na' to soḻdad beṉə' chaclen ḻe', na' soḻdadən' ḻeczə cho'elaogüe'e Diozən'. ");
INSERT INTO zavNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Na' Cornelion' bzeɉni'ine' ḻega'aque' yoguə'əḻoḻte can' goquən' nach bseḻe'e ḻega'aque' Jopen'. Na' gosə'əgüe'e nezən' əzɉa'aque'. ");
INSERT INTO zavNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Na' beteyon' gaḻə'əzə bazɉa'aque' par yesə'əžine' lao' syoda Jopen' catə' Bedən' gwlo'e yic̱hɉo'o c̱he yo'o gan' zo'enə' ca do gobiž par ɉene' orasyon'. ");
INSERT INTO zavNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","11","Na' lao chone' orasyonṉə' gwdonchgüe' xte gone'ene' gaogüe' lgüegwzə. Na' žlac chac de'en gaogüe'enə' ble'idaogüe'ene' ḻe'e yoban' chetɉ ca to lachə' xen na' ncheɉ dap squinten na' chetɉən par lao yon'. ");
INSERT INTO zavNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Na' ḻo'inə' zɉəža' yoguə' cḻaste bia yix̱ə' ža' yežlyon', bia žia tap ṉi'a ne'i na' bia zɉənxobə ḻe'i lao yon', na' len bia žia x̱ile'e bia chaš ḻe'e yoban'. ");
INSERT INTO zavNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nach benene' gož Diozən' ḻe': ―Gwyas Bed na' bet bia ca' gwdao. ");
INSERT INTO zavNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Nach Bedən' gože'ene': ―Bito gaoga'aca'ab X̱ana'. Ni šlinzə cuiṉə' gaogua' bia zban ca' zɉənac ca' na' bia cui de lsens len ḻei c̱heto'onə' gaoto'. ");
INSERT INTO zavNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nach Diozən' gože' ḻe' de'e əgwchope: ―Bian' bac̱h gwnia' gaogo' bito əṉao' de que bia əzbanga'aquən'. ");
INSERT INTO zavNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","De'e gwyoṉ lase gož Diozən' ḻe' ca' nach begüe lachə'ən ḻe'e yoban'. ");
INSERT INTO zavNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Žlac chacžeɉlažə' Bedən' bi zeɉen ca naquə de'en ble'idaogüe'ene'enə' besə'əžin beṉə' ca' əbseḻə' Cornelion' cho'a puert c̱he Simon gocol yidən' bagosə'əṉabe' gan' zo liže'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nach zižɉo gosə'əṉabe' šə ḻe na' zo to beṉə' ḻeczə le' Simon Bed. ");
INSERT INTO zavNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pero Bedən' ṉechone' xbab c̱he de'en ble'idaogüe'ene' catə'əczlə gož Spirit c̱he Diozən' ḻe': ―Šoṉə beṉə' chəsyə'əyilɉe' le'. ");
INSERT INTO zavNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Gwzoža' na' beyetɉ gwyeɉlenga'aque' na' bito gaquəžeɉlažo'o ḻa'aṉə'əczə cui zɉənaque' beṉə' Izrael la' nada' əbseḻə'əga'aca'ane'enə'. ");
INSERT INTO zavNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nach Bedən' beyetɉe' ɉəšague' beṉə' ca' əbseḻə' Cornelion' nach gože' ḻega'aque': ―Nga zoa', nadan' Simon Bedən'. ¿Bin' cheyilɉle nada'? ");
INSERT INTO zavNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nach gwse' beṉə' ca' ḻe': ―To capitan beṉə' 