﻿USE sofia;
DROP TABLE IF EXISTS sofia.zatNTps_vpl;
CREATE TABLE zatNTps_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zatNTps_vpl WRITE;
INSERT INTO zatNTps_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Ba neza zrente̱ naca na chee̱ bénnea' quebe dxezi'e̱ da dxuluzéajni'i benne' we̱n da cale̱la ca' le̱', ne quebe dxune̱' tuze benne' dul-la ca', ne quebe dxune̱' tu zren benne' ca' dxelún le̱' chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Zue̱' xel-la' dxebé lawe' da dxuzúe̱' dizra' da nadxixruj bea Xránadxu, ne ca naca da nadxixruj bea na, te zra ne chizrela dxelaba lazre̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Benne' nigá naque̱' ca tu xaga zua na dxu'a xe̱gu nisa, da dxunna na da zixre chee̱ na lu beu' cheé̱queze na, ne xrlegue na quebe dxase na. Ca naca da dxun benne' nigá, dxe̱pe ban na. ");
INSERT INTO zatNTps_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Quegá caní zaj naca benne' we̱n da cale̱la ca'. Zaj naque̱' ca tu xizre laga' da dxua be' bdunu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Quebe xelexegá'ana chawe' benne' we̱n da cale̱la ca' gate guchi'a Dios chee̱', ne quebe xelú'u benne' dul-la ca' naga zaj nazraga benne' xrlátaje ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Dxezaca ba lazre' Dios ca da dxelún benne' xrlátaje ca'. Da dxelún benne' we̱n da cale̱la ca' che̱ na le̱' naga xelebía xi'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","¿Bizr chee̱ na' dxeledábaga benne' xe̱zr la xu ca' neda'? ¿Bizr chee̱ na' dxululaba lázrequeze bénneache da guzúa na neda' chalá'ala? ");
INSERT INTO zatNTps_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Dxeledábagaqueze benne' wenná bea ca', ne dxelún tuze dizra' benne' ca' dxelenná bea ca xelune̱' chee̱ Xránadxu Dios, ne chee̱ Bénnea' gucá'a Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Dxelenné̱': “Guselá cuínadxu lu xel-la' dxenná bea chee̱', ne guzúadxu chalá'ala da zaj nadxixruj bé'ene̱' dxi'u.” ");
INSERT INTO zatNTps_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Naga dxe' Xránadxu xabáa dxuzrizre̱'. Quebe dxezí' le̱ne̱' chee̱ da dxelegú'u lazré̱' xelune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Lu xel-la' dxezrá'a chee̱' dxedil-le̱' le̱', ne lu xel-la' snia chee̱' dxuchebe̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Dxenné̱': “Lu xi'a lá'azxa chia', xi'a Sión ba nuzúa' benne' gaque̱' Wenná Bea waláz chia' neda'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Dxenná Wenná Bea na': “Guzenda' le'e da guzre Xránadxu neda'.” Guzre̱' neda': “Lue' nacu' Zri'ina'. Ná'aqueze naca' Xrau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Gunabe neda', na' gunna' Lue' xúgute̱ cue' xe̱zr la xu ca', na' gaca chiu' dute̱ ca naca xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Guzízxenu' bénneache xe̱zr la xu ca' nen vara xia, ne ca tu dxe'e xu guzuzru' le̱'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Na'a, le'e, wenná bea, le xene da nigá dxuzéajni'ida' le'e. Le guse̱de da nigá dxusízreda' le'e, benne' dxelenná bea lu xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Le gun zrin chee̱ Xránadxu Dios, dute̱ xel-la' dxezrebe chee̱le. Nen xel-la' dxezrize chee̱le, le be lau Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Le gapa ba lá'ana Zrí'ine̱' chee̱ quebe zre̱'e̱, checa' cuía xile la neza chee̱le, lawe' da la zra'ate̱ Le̱'. Da ba neza zrente̱ naca na chee̱ xúgute̱ benne' dxuluxrén lazre̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Xrana' Dios, ba naxánle̱'e̱ benne' dxeledábague̱' neda'. Benne' zante̱ dxeledíl-lale̱ne̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Benne' zante̱ dxelenné̱' chia': “Quebe guselá Dios le̱'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Lue', Xrana' Dios, dxucú'uju' neda'. Nacu' Benne' dxebéle̱na', ne Benne' dxuzé̱ chawe̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Gudxezre xa'a, bláwizra' Xrana' Dios, na' Le̱' beche̱be̱' chia' naga zue̱' lu xi'a lá'azxa chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Guta', ne gusia', na' bebana' lawe' da nuxru Xrana' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Quebe zreba' gaxúa gaxúa bénneache, benne' zaj naxéchaje̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Guzé̱, Xrana' Dios. Bselá neda', Dios chia'. Be̱n we̱' xraga benne' ca' dxeledíl-lale̱ne̱' neda', ne guzuzruj lazxa benne' xriwe̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Xel-la' weselá za' lu na'u, Xrana' Dios. Be̱n da chawe' chee̱ bénneache chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Beche̱be chia' gate dxuláwizra' Lue', Dios. Nacu' Benne' dxuchi'e̱ ca da dxuna'. Gate guzúa' lu da ste̱be, Lue' btipu' lazra'. Bexache lazre' neda', ne bene ca da dxuchálajle̱na' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Le'e, bénneache, ¿ájate̱scha' gucá'ana dítjale neda'? ¿Ájate̱scha' zri'ile da quebe zaca, ne chéajle̱le da we̱n lazre'? ");
INSERT INTO zatNTps_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Le xexúnbea ba gucá'a Xránadxu nu benne' dxape̱' Le̱' ba lá'ana. Xrana' Dios xenne̱' gate dxuláwizra' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Le zrebe lau Dios, ne quebe gunle dul-la. Le gulaba lazre' chee̱' naga dxásale, ne le sua zrize. ");
INSERT INTO zatNTps_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Le gute lau Le̱' béadu ca' lu da naca du lazre', ne le guxrén lázre' Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Benne' zante̱ dxelenné̱': “¿Nuzra gun gá'anatu' chawe'?” Dute̱ xel-la' zri'i lazre' chiu' bxue netu', Xran. ");
INSERT INTO zatNTps_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Lue' bzu' xel-la' dxebé lu xichaj lázrdawa', da naca na zrendxa ca da zaj napa benne' zaj nápale̱'e̱ zrua', ne xrise uva wal-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Dute̱ xel-la' dxebeza zri lazre' gata', ne gasia', lawe' da dxunu' Lue', Xran, zua' zri'a chawe'. ");
INSERT INTO zatNTps_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Bze̱ naga dizra' chia', Xran. Bde lazre' ca dxebezre lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Bene ca guchálajlena' Lue', Wenná Bea chia', ne Dios chia', q lawe' da guláwizraja' Lue', Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Xran, che zílala xennu' chi'a. Che zílala xídaqueza' lau Lue', ne wabeza lazra' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Nacu' Dios quebe dxezaca ba lazru' da cale̱la. Benne' we̱n da cale̱la quebe súaqueze̱' naga zu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Quebe dxu'u lataj xelezrín benne' we̱n da cale̱la lau'. Dxecuídenu' xúgute̱ benne' dxelune̱' da zrinnaj. ");
INSERT INTO zatNTps_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Guzría xí'quezu' benne' ca' dxelezí xe̱'e̱. Guzú' chalá'ala benne' we̱te benne', ne benne' guzrí xe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Neda' waca chu'a lizru' lawe' da nazrí'ile̱'e̱nu' neda'. Güe lá'ana' Lue' lu xudau' lá'azxa chiu' dute̱ xel-la' dxezrebe. ");
INSERT INTO zatNTps_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Bsi neda' chee̱ guna' da xrlátaje chiu', Xran, lawe' da zrále̱'e̱ benne' dxeledábague̱' neda'. Gulú'u neda' neza chawe' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Benne' caní quebe dxelenné̱' da li. Lu xichaj lázrdawe̱' xu'u da cale̱la. Xe̱dxu lbe̱'e̱ zaj naca na ca tu ba chee̱ benne' gate da naxalaj na. Zaj nupé̱'e̱ dizra' chawe' chee̱' da zaj naca na da we̱n lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Bde benne' ca' lu da ba xa', Xrana' Dios. Be̱n cheajlecházie̱' cáte̱ze zaj naca xrtízraqueze̱'. Lawe' da naxánle̱'e̱ da cale̱la da dxelune̱' ne lawe' da guledábague̱' Lue', bebéaje̱' chalá'ala. ");
INSERT INTO zatNTps_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Welebéle̱'e̱ benne' ca' dxuluxrén lazre̱' Lue'. Welebézre xá'aqueze̱' dute̱ xel-la' dxelebé lawe' da dxucú'uju' le̱'. Lau Lue' welebéle̱'e̱ benne' ca' zaj nazrí'ine̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Gúnquezu' da chawe' chee̱ benne' xrlátaje, Xran. Gucu'uju' bénnea' lawe' da dxezaca ba lázrele̱nu' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Lue', Xran, quebe til-lu' neda' lu xel-la' snia chiu', ne quebe gudéu' neda' ba xa' lu xel-la' dxezrá'a chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Bexache lazre' neda', Xran, lawe' da quebe chawe' zua'. Bexún neda', Xran, lawe' da dxedéa' xel-la' zi'. ");
INSERT INTO zatNTps_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Sté̱bele̱'e̱ zua xichaj lázrdawa'. Xran, ¿bátala gácale̱nu' neda'? ");
INSERT INTO zatNTps_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Gudá, Xran, bselá bénne'du xu'a. Bselá neda' dute̱ xel-la' zri'i lazre' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Naga zaj zra' benne' gate ca', quebe nu dxeajsá lazre' Lue'. Lu lataj ba xa' ¿núzraqueze güe lá'ana Lue'? ");
INSERT INTO zatNTps_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Ba dxexedú lazra' lawe' da dxebezre lazra'. Tu zre' tu zre' dxebísane ga dxásia' nisa da dxebezra'. Dxusebisa' xrcugua' nisa da dxebezra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Ba dxane xiaj lawa' xel-la' dxebezre. Ba bebízrqueze nisa xuzru xiaj lawa' lawe' da zrále̱'e̱ benne' dxulusaca zi'e̱ neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Le cuasa naga zua', xúgute̱le dxunle da zrinnaj lawe' da ba ben Dios dxebézrele̱'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Xrana' Dios ba benne̱' da dxata' xueda' Le̱'. Ba guzí' Xrana' Dios da dxuchálajle̱na' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Dxelexedué'e, ne zaj zua lu da sté̱bele̱'e̱ xúgute̱ benne' dxeledábague̱' neda'. Chadite̱ xelexebigue̱' naga zua', ne xelexedué'ene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Xrana' Dios, dxuxrén lazra' Lue'. Gúcale̱ neda' ne bselá neda' lu na' benne' ca' dxulusaca zi'e̱ neda', ");
INSERT INTO zatNTps_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","chee̱ quebe xele̱l-le̱' neda' ca dxun be̱zre xixre', na' xuluzúzruje̱' neda' naga quebe nu chilá' nu guselá neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","Xrana' Dios, che be̱na' neda' caní: Che bi da zrinnaj be̱n ni'a na'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","Che bi da cale̱la be̱na' chee̱ benne' zue̱' chawe' nen neda'. (Bselá' bénnea' dxedábague̱' neda' lácala quebe bi nuna' chee̱'.) ");
INSERT INTO zatNTps_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","Che caní be̱na', be̱ lataj benne' dxedábague̱' neda' gau zi' ne xezrúnene̱' neda'. Be̱ lataj bénnea' guchuchu guléaje̱' neda' lu xu, ne xusunitie̱' xel-la' ba lá'ana chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Xran, dute̱ xel-la' dxezrá'a chiu', guzé̱. Bexechaj benne' ca' dxulusaca zi'e̱ neda' lu xel-la' dxelezrá'a chee̱'. Gusel-la da gácale̱ na neda' gate guchi'u da dxaca chia' ca da gunná be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Xúgute̱ benne' zaj zre̱'e̱ xe̱zr la xu xelezrague̱' lau'. Gunná be'e benne' ca' dute̱ xel-la' szren chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Lue', Xran, guchi'u chee̱ benne' xúgute̱ xe̱zre. Bchi'a ca da nuna' lu da naca xrlátaje, ne lu da naca du lazre' chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Be̱n cheajsé̱ naze da zrinnaj da dxelún benne' we̱n da cale̱la ca', san bzua chawe' benne' xrlátaje, lawe' da nacu' xrlátaje, Dios, ne dxenná'u da xu'u xichaj lázrdau bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Diósqueze dxucu'uje̱' neda'. Dxuselé̱' benne' zaj naque̱' du lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Xlátaje̱ dxuchi'a Dios chee̱ da dxelún bénneache. Tu dxezrá'azqueze Dios da dxelún benne' we̱n da zrinnaj ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Che quebe xelexíaje lazre̱' Dios gulé̱' xia chee̱'. Ba nuzúa cuásate̱' xaga nalá xéche'ze chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Ba naxrúa cuásate̱' xia chee̱' ca' chee̱ wedil-la. Ba nuzúa cuásate̱' xaga nalá xéche'ze da dxelala. ");
INSERT INTO zatNTps_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Benne' we̱n da zrinnaj dxugú'u lazre̱' ca da cale̱la gune̱'. Xu'u lázrdawe̱' da zrinnaj da gune̱', na' dxebéajé̱' da we̱n lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Ba gude̱ne̱' tu xe̱dxu situj naga cheajlechaze bénneache, na' lé̱zqueze̱' xeajcházie̱' lu xe̱dxu na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Da zrinnaj da be̱ne̱' dxebague na lé̱queze̱', na' da bsaque̱' bénneache xezrizre na xíchaje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Güe lá'anaqueza' Xrana' Dios ca da xrlátaje da dxune̱', ne gúl-laqueza' chee̱ La Xrana' Dios, Bénnea' naque̱' szrente̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Lue' Dios, Xránantu', zrente̱ naca Lau' du gabí'i xe̱zr la xu. Zrendxa naca xel-la' szren chiu' ca xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Bidu ca', ne bidu dxe'ene ca' dxelúl-labe' ca naca na. Zúaquezu' lataj chawe' naga quebe xelezrín benne' ca' dxeledábague̱' lue'. Dxuzúa zriu' benne' dxeledábague̱' lue', ne benne' dxelecuídene̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Gate dxenná'a xabáa da nunu' Lue', ne beu', ne belaj ca', da ca' nuzú' cha chee̱ na, ");
INSERT INTO zatNTps_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","na' dxuche̱ba': “¿Ájazra naca bénneache, dxulaba lazru' chee̱ le̱'? ¿Ájazra naca bénneache, dxe'u gunne xue le̱'?” ");
INSERT INTO zatNTps_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Be̱nu' le̱' látezdxa szren ca nacu' Lué'queze, ne bzu' chee̱' xel-la' szren, ne xel-la' ba lá'ana. ");
INSERT INTO zatNTps_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Be̱nu' dxenná bé'ene̱' xúgute̱ da ca' nunu'. Xúgute̱ na bdeu' lu ne̱'e̱, ");
INSERT INTO zatNTps_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","zrila' ca', ne be̱zre ca', ne xúgute̱ be̱ xixre' ca', ");
INSERT INTO zatNTps_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","be̱ zaj zua xrila, ne bela ca', ne xúgute̱ da zaj zua na lu nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Xránantu', Dios, szrente̱ naca Lau' du gabí'i xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Xran, dute̱ lázrdawa' güe lá'ana' Lue'. Guzenda' bénneache ca zaj naca da zrente̱ da be̱nu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Wabéquezda', ne gúl-laqueza' ca naca chiu'. Gul-la' chee̱ lau' Lue', nacu' Dios zrente̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Buluzrunnuj benne' dxeledábague̱' neda'. Xeajlechazie̱', ne belexenitie̱' lau Lue' ");
INSERT INTO zatNTps_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","lawe' da nucá'ana chawu' da xrlátaje da dxuna'. Dxe'u lataj blau chiu', ne lu da xrlátaje dxuchi'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Gudil-lu' benne' xe̱zr la xu ca', ne bzria xi'u benne' we̱n da cale̱la ca'. Bsulu' la benne' ca' chadía chacanna. ");
INSERT INTO zatNTps_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Ba gulebía xi' benne' dxeledábague̱' neda'. Chadía chacanna zaj nazrinnaj lataj chee̱ benne' ca', ne xe̱zre chee̱' ca', da ca' bchínnuju' Lue'. Netú benne' cheajsá lazre̱' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Xránadxu Dios súatequeze̱' chadía chacanna. Ba nucueze̱' lataj blau chee̱' naga guchi'e̱ chee̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Lu da xrlátaje guchi'e̱ chee̱ bénneache dute̱ xe̱zr la xu, ne chee̱ benne' xúgute̱ xe̱zre ca' lu da naca li lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Xránadxu Dios gaque̱' ca tu lataj ga xelezrá chawe' benne' xache', naga xelezré̱'e̱ chawe̱' gate zrin zra chee̱ da zi' da xa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Benne' ca' zaj núnbe'e̱ Lue', Xran, xuluxrén lazre̱' Lue', lawe' da quebe bsan lazru' benne' ca' belexílaje̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Le gul-la chee̱ Xránadxu, Bénnea' zue̱' xe̱zre Sión. Le guzén benne' xe̱zre ca' ca zaj naca da ca' nune̱', ");
INSERT INTO zatNTps_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","lawe' da dxeajsá lazre̱' chee̱ benne' ca', ne dxexebéaj lazre̱' chee̱ benne' we̱te benne'. Quebe gul-la lazre̱' ca da dxululáwizra benne' ba xache' ca' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Bexache lazre' neda', Xran. Gunná' da dxezaca' lu ni'a na' benne' ca' dxelecuídene̱' neda'. Dxeca'u neda' lu na' xel-la' gute, ");
INSERT INTO zatNTps_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","chee̱ guzenda' bénneache da dxue lá'ana' Lue', naga dxu'untu' xe̱zre Sión, ne chee̱ beda' lawe' da bseláu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Xeajlechaze benne' xe̱zr la xu ca' lu xe̱dxu da gule̱ne̱'. Xeajlechu'e̱ lu xralaj da bulucueze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Xránadxu Dios blé'ene̱' ca da zaj naque̱' ne̱ chee̱ da zi' da xa' da gudichaj be'e̱ chee̱ benne' ca' dxelune̱' da cale̱la. Xeajchaze benne' we̱n da cale̱la na' lu da nun ni'a ná'queze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Benne' we̱n da cale̱la ca' xeledéqueze̱' lu lataj ba xa'. Xúgute̱ benne' ca' dxelal-la lazre̱' Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Quegá chadía chacanna gal-la lazre' Dios benne' xache' ca', ne quegá tu chi'ize xenite da dxelebeza lazre̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Guxasa, Xrana' Dios. Quebe gu'u lataj xelexegá'ana szrénqueze bénneache. Xelelá' lau' benne' xe̱zr la xu ca' chee̱ guchi'u chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Xran, be̱n xelezrebe benne' ca' Lue'. Be̱n xelexúnbea benne' xe̱zr la xu ca' zaj naque̱' bénneacheze. ");
INSERT INTO zatNTps_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","¿Bizr chee̱ na' zu' zitu', Xran? ¿Bizr chee̱ na' dxucache cuinu' gate dxeledé xel-la' zi' bénneache chiu'? ");
INSERT INTO zatNTps_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Benne' we̱n da cale̱la dxenáu zi' xuzre̱' benne' xache' lu xel-la' dxucá'ana szren cuine̱', na' xeajchaze benne' xache' na' lu da ba nucuéza bénnea'. ");
INSERT INTO zatNTps_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Dxucá'ana szren cuine̱' ca naca da dxezá lazre̱'. Nupé̱'e̱ dizra' da dxenné̱' chee̱ benne' dxucude', na' dxucá'ana dítaje̱' Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Benne' we̱n da cale̱la na' lu xel-la' dxucá'ana szren cuine̱' quebe dxape' Dios ba lá'ana, ne quebe dxéquene̱' che zua Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Tu dxúnzqueze̱' da cale̱la, ne quebe dxéquene̱' guchi'u Lue' ca da dxune̱'. Dxuzúe̱' chalá'ala xúgute̱ benne' dxeledábague̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Lu xichaj lázrdawe̱' dxenné̱': “Quebe bi seque' guzaga na neda'. Cabata' bi gaca chia' da cale̱la.” ");
INSERT INTO zatNTps_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Tu dxenné̱zqueze̱' dizra' schanni', ne da we̱n lazre', ne ca naca da cale̱la da gune̱'. Dxeledxúaj dxu'e̱ dizra' cale̱la, ne dizra' xálaze. ");
INSERT INTO zatNTps_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Dxu'a xe̱zre ca' dxucache cuine̱' chee̱ que̱le̱' bénneache. Bagácheze dxutie̱' benne' dxeledeze̱' na'. Bagácheze dxenné̱'e̱ chee̱ bi gune̱' chee̱ benne' xache' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Bagácheze dxebeze̱' ca dxun be̱zre xixre'. Dxebeze̱' ga séquene̱' que̱l-le̱' benne' xache' ca'. Dxe̱l-le̱' benne' xache' lu xralaj chee̱', ne dxexu'e̱ le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Dxine̱' xu bénnea' gude̱l-le̱'. Dxusaca zie̱' benne' zan nen ne̱'e̱ wal-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Lu xichaj lázrdawe̱' dxenné̱': “Nal-la lazre' Dios benne' caní. Nucache lawe̱', ne quebe lé'ene̱' da dxuna'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Guxasa, Xrana' Dios, ne bze̱ na'u. Quebe gal-la lazru'u benne' xache' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","¿Ájazra che̱n' benne' ca' dxelune̱' da cale̱la dxuluzúe̱' Dios chalá'ala? Lu xichaj lázrdawe̱' dxelenné̱': “Quebe xebéaj lazre' Dios.” ");
INSERT INTO zatNTps_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Dios, Lue' blé'equeznu' da nigá, lawe' da dxenná'u benne' we̱n da cale̱la, ne da ca' dxune̱' quebe naca na xrlátaje, na' xebéaj lázrequezu' bénnea'. Dxuluzúa cuina benne' xache' ca' lu na'u. Lue' dxácale̱quezu' bi we̱zé̱bedu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Dxugú' xel-la' wal-la chee̱ benne' we̱n da cale̱la. Guleaj láwela da cale̱la da nune̱', da na' be̱ne̱' lu da bagache'. ");
INSERT INTO zatNTps_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Chadía chacanna naca Xránadxu Wenná Bea chee̱dxu. Lu xe̱zr la xu chee̱' ba gulebía xi' benne' dxelecuídene̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Bnézruju' ca da bululáwizra benne' dxexruj lázre'du ca' Lue', Xran. Lue' dxupa'u lázxdau bénne'du ca' chee̱ xuluzé̱ nague̱' xrtizru', ");
INSERT INTO zatNTps_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","chee̱ guchi'u chee̱ bi we̱zé̱bedu ca', ne chee̱ benne' dxeledée̱' xel-la' zi', chee̱ québedxa bi da cale̱la xelún benne' ca' dxelune̱' da cale̱la chee̱ bénne'du caní. ");
INSERT INTO zatNTps_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Dxuxrén lazra' Xrana' Dios. Ájazra che̱n' dxi'u bénne'du xu'a: “Bzrunnuj, guxíaj lu xí'ala ca tu bxinne?” ");
INSERT INTO zatNTps_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Le na' xque, dxulucuéza benne' ca' dxelune̱' da cale̱la xaga nalá xéche'ze. Ba zaj naxrúe̱' xaga nalá xéche'ze chee̱' lu du chee̱ na, chee̱ xelútie̱' bagácheze benne' xrlátaje ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Chete ca' xelexinnaj da dxulusé̱ chuchu da xrlátaje, ¿ájazra xelún benne' xrlátaje ca'? ");
INSERT INTO zatNTps_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Xránadxu Dios zúaqueze̱' lataj lá'azxa chee̱'. Xabáaqueze zua lataj blau naga dxe' Dios. Dxelenná' xanne xiaj lawe̱'. Dxelé'ene̱' ca da dxelún bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Xránadxu Dios dxudée̱' chawe' benne' xrlátaje ca' lu da ste̱be. Dxecuídene̱' benne' ca' dxelune̱' da cale̱la, ne benne' dxelune̱' da zrinnaj. ");
INSERT INTO zatNTps_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Gudée̱' benne' ca' dxelune̱' da cale̱la lu da zi' da xa', da zaj naca na xi', ne da dxuzézrele̱'e da dxala na ca xedxe, ne tu be' lále̱'e̱, da ca' sel-le̱' lawe' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Caní gune̱' lawe' da naca xrlátaje Xránadxu Dios, ne nazrí'ine̱' da naca na xrlátaje. Benne' li lazre' ca' xelelé'ene̱' lawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Xrana' Dios, bselá bénneache chiu' lawe' da québedxa dxape̱' benne' xezica Lue' ba lá'ana. Quebe nu chilá' benne' li lazre' ládujla bénneache ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Xúgute̱ bénneache ca' dxelezí xe̱'e̱ le sa' ljwezre̱'. Lu da we̱n lazre' ba zaj nupé̱'e̱ dizra' chee̱ xelezí xe̱'e̱ le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Xránadxu Dios guzría xi'e̱ xúgute̱ benne' quebe dxuluchálaje̱' du lazre', ne benne' ca' dxuluchálaje̱' da dxucá'ana szren cuine̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Benne' ca' gulenné̱': “Ne̱ chee̱ dizra' chee̱ntu' zrué'entu' da chawe'. Ca dxezá lázrentu' guchálajntu', ¿nuzra nna be'e netu', xca'?” ");
INSERT INTO zatNTps_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Dxenná Xránadxu Dios: “Na'a xídaqueza' lawe' da dxulusaca zi'e̱ benne' xache' ca', na' dxelebezre lazre' benne' baxache' ca'. Guselá' benne' ca' dxelánene̱' da guna'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Xrtizra' Xránadxu Dios zaj naca na du lazre'. Zaj naca na ca xiaj plata da ba gudé na lu xi', da ba gudé na lu xi' gazre lasa. ");
INSERT INTO zatNTps_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Xran, guxúequezu' Lue' bénneache chiu' ca'. Chadía chacanna gucu'uju' le̱' lu na' benne' zaj zre̱'e̱ lu zra na'a zra. ");
INSERT INTO zatNTps_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Gátete̱ze na' dxaca da cale̱la gate dxulucá'ana szren bénneache da naca sban. ");
INSERT INTO zatNTps_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","¿Ájate̱queze gal-la lazru' neda', Xran? ¿Gal-la lázrtequezu' neda'? ¿Ájatequeze quebe le'enu' da dxaca chia'? ");
INSERT INTO zatNTps_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","¿Ájatequeze gun na ba xen guchaga lawa' da dxezaca'? ¿Ájatequeze gaca wi'ine lazra' te zra, ne chizrela? ¿Ájatequeze nna be'e benne' dxedábague̱' Lue' neda'? ");
INSERT INTO zatNTps_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Gunná' da dxaca chia', Xran, ne beche̱be chia'. Btipa lazra' chee̱ quebe gatia', ");
INSERT INTO zatNTps_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","ne chee̱ quebe nna benne' dxedábague̱' neda': “Ba be̱tia' ni'a ne̱'e̱.” Benne' ca' dxeledábague̱' neda' xelebene̱' che cheajcházia' lu da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Neda' dxuxrén lazra' Lue' xexache lazru' neda'. Dute̱ lázrdawa' dxebeda' lawe' da dxuseláu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Gúl-laqueza' chee̱ Xrana' Dios lawe' da ba nune̱' chia' da xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Benne' lázxdau zide' dxezá' lazre̱', dxenné̱': “Quebe zua Dios.” Benne' caní zaj nazrinnaj xichaj lázrdawe̱'. Dxelune̱' da sban ca'. Quebe nu chilá' benne' dxune̱' da xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Xránadxu Dios zue̱' xabáa dxenné̱'e̱ bénneache chee̱ lé'ene̱' che zua nu benne' dxéajni'ine̱', bénnea' dxape̱' ba lá'ana Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Xúgute̱' zaj xu'e̱ neza xuca'. Xúgute̱' zaj nazrinnaj xichaj lázrdawe̱'. Quebe nu chilá' benne' dxune̱' da xrlátaje, netúgue̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","¿Quebe dxeléajni'i benne' ca' dxelune̱' da sban? Dxulusunítie̱' bénneache chia' ca dxuzuzruj tu benne' xeta da dxawe̱', ne quebe dxeléquebe'ene̱' zua Xrane̱' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Dute̱ xel-la' dxelezrebe dxelezrize benne' ca' lawe' da dxácale̱ Dios benne' xrlátaje ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Belún le̱' chee̱ da gulenná benne' xache' ca', san benne' caní xelebeza lazre̱' Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Xídatega Bénnea' guselé̱' benne' Israel ca'. Gate gun Xránadxu xelexezrín benne' chee̱' ca', benne' ca' zaj nada'u zítu'la, na' welebé zri'ine zre sua Jacob, ne welebéle̱'e̱quezne̱' benne' Israel ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Xran, ¿núzraqueze benne' sue̱' naga zu' Lue'? ¿Núzraqueze benne' sue̱' naga naca lá'azxa chiu'? ");
INSERT INTO zatNTps_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Waca bénnea' naque̱' du lazre', ne dxune̱' da xrlátaje, bénnea' zua da líqueze lu xichaj lázrdawe̱', ");
INSERT INTO zatNTps_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","bénnea' quebe dxenné̱' chee̱ le sa' ljwezre̱', ne quebe bi da cale̱la dxune̱' chee̱ le sa' ljwezre̱', ne quebe dxu'e̱ lataj nu benne' si tizre̱' le sa' ljwezre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Waca bénnea' quebe dxape̱' ba lá'ana nu benne' dxune̱' da sban. Dxape̱' ba lá'ana benne' ca' dxelape̱' ba lá'ana Xránadxu Dios, bénnea' quebe dxuché̱'e̱ dizra' da ba gunné̱' lácala bi da' gunítie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Waca bénnea' dxusane̱' dumí chee̱' ne quebe dxenabe̱' xíchaje̱n, ne quebe dxezí' lu ne̱'e̱ dumí chee̱ nnie̱' chee̱ nu benne' quebe bi zria nabague̱'. Nu benne' dxune̱' caní cabata' cheajchazie̱' lu da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Bxue neda', Dios, lawe' da dxuxrén lazra' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Lu xichaj lázrdawa' gucha' Xrana' Dios: “Lue' nacu' Xrana'. Quebe bi xetú da xrlátaje de̱ chia' da quebe naca na chiu'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Tuze benne' ca' zaj naque̱' chee̱ Dios lu xe̱zr la xu, ne benne' ca' zaj naque̱' du lazre' dxezaca ba lázrele̱na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Waxánqueze da dxelezaca benne' ca' dxelape̱' ba lá'ana tu dios quebe bi zaca. Quebe guna' le̱' tu zren gate dxuluzríe̱' zren lau dios na', ne quebe guchíneda' la dios na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Xránadxu Dios dxugawe̱' neda', ne naque̱' da ba neza chia'. Lue', Dios, nuxru' ca da naca chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Ca da nuzú' chia' zaj naca na da dxezi'a ba neza, ne xrtante̱ zaj naca da nunnu' chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Tu gucá'ana szrénzqueza' Xránadxu Dios, Bénnea' dxusé̱dene̱' neda'. Chizrela gate ne dxasia' dxuzéajni'ine̱' neda' lu xichaj lázrdawa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Xránadxu Dios nuxrén lazra' gusi'e̱ neda'. Lawe' da zue̱' cuita', quebe bi seque' guchebe na neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Chee̱ le̱ na' gubé lázrdawa', ne gubéle̱'e̱quezda', na' zra gacha' lu xe̱dxu ba cueza lazra' ");
INSERT INTO zatNTps_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","lawe' da quebe gucá'anu' bénne'du xu'a lu lataj ba xa', ne quebe gu'u lataj guzru nu benne' nácaqueze̱' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Gulé'enu' neda' da guna' chee̱ gata' chia' xel-la' nabán. Naga zu' Lue' wabéle̱'e̱quezda', na' cuitu' Lue' súatequeze da ba neza chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Bze̱ naga chi'a, Xran. Ben xanne' da dxuláwizra' Lue'. Guzí' da dxenaba' Lue', naca' du lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Be̱nna lataj xelá'a lau' chee̱ guchi'u chia', lawe' da dxelé'enu' xúgute̱ cáte̱ze zaj naca na. ");
INSERT INTO zatNTps_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Lue' dxenná' xánniu' xichaj lázrdawa' ne dxelé'enu' neda' chizrela. Gunná' xánniu' da dxuna', na' quebe bi da cale̱la blé'enu'. Ba nuna' quebe bi dizra' cale̱la nnia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Dxuzúa' dizra' ca naca da dxennáu', na' quebe dxuna' ca da dxelún benne' we̱n da zrinnaj ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Bxue neda' lu neza chawe' chiu', chee̱ quebe cheajcházia' lu da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Dxuláwizra' Lue', Dios, lawe' da dxennu' chi'a. Bze̱ naga chi'a, na' bene da dxennía'. ");
INSERT INTO zatNTps_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Ble'e ca dxexache lázrele̱'u bénneache. Bselá benne' ca' dxuluxrén lazre̱' Lue' lu na' benne' dxeledábague̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Bxue neda' ca dxun benne' dxuxúe̱' xiaj lawe̱'. Gude̱zre neda' ca dxun bedxuj dxé̱zreba' zrí'ineba' zran xrílaba' ");
INSERT INTO zatNTps_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","chee̱ quebe bi xelún chia' benne' ca' dxelune̱' da cale̱la, benne' dxeledábague̱' neda', ne dxelaca lazre̱' xelútie̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Quebe dxelexache lazre̱' le sa' ljwezre̱', na' dute̱ xel-la' dxulucá'ana szren cuine̱' dxuluchálaje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Gátete̱ze dxedá' dxeléchaje̱' neda'. Dxelaca lazre̱' xeline̱' neda' xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Zaj naque̱' ca tu be̱zre xíxre'dau' dxaca lázreba' bi gáguba'. Zaj naque̱' ca tu be̱zre xixre', ba nucache cuínaba' chee̱ qué̱l-laba' béadu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Gudá, Xran, gudábaga' benne' ca' dxelune̱' da cale̱la, na' bchiche̱' lu xu. Bselá neda' lu na' benne' ca' dxelune̱' da cale̱la, guchínenu' xia chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Bselá neda' lu na' benne' ca' nen ni'a ná'quezu', Xran. Bselá neda' lu na' bénneache, benne' ca' zaj dxe'e̱ gunne xue chee̱ xe̱zr la xu nigaze, benne' ca' dxeláguqueze̱' da zácale̱'e̱ chiu'. Da nigáqueze dxulugawe̱' zrí'ine̱' ca', ne dxexegá'anaqueze da dxelágu zri'ine zre sue̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Le'eda' neda' lau Lue' lawe' da naca' xrlátaje. Xezaca ba lazra' gaca' ca nácaquezu' Lue' gate xebana'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Nazrí'ida' Lue', Xran. Lue' dxuzé̱ chuchu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Lue', Xran, nacu' ca tu xiaj naga ze̱ chúchua', ne ca tu xu'u zren naga xu'u chawa', na' nacu' weselá chia'. Dios chia', Lue' dxuzé̱ chuchu' neda', na' guxrén lazra' Lue'. Dxucu'uju' neda', ne dxuseláu' neda', ne dxucache chawu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Wanné̱queza' Xránadxu Dios, Bénnea' naca chee̱' güe lá'anadxu Le̱'. Le̱' guselé̱' neda' lu na' benne' ca' dxeledábague̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Guzúa' lu da ste̱be chee̱ xel-la' gute, na' guca da cale̱la ca tu xe̱gu nisa da bchebe na neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Guzúa' lu da ste̱be chu'a lataj ba xa' lawe' da zua' lu da ste̱be chee̱ xel-la' gute. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Lu da zi' da xa' bláwizra' Xrana' Dios, ne gunné̱queza' Dios chia'. Le̱' benne̱' chi'a naga zue̱' lataj lá'azxa chee̱', ne bze̱ nague̱' da bchálaja' lawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Nadxa guzrú' lu xe̱zr la xu nigá. Gulezrize lane xi'a ca'. Gulezrízele̱'e̱ na lawe' da bzra'a Le'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Bdxuaj zren chee̱ xi' lu zrine̱', ne bdxuaj xi' lu dxu'e̱ da bzezxe na da de̱ lawe̱', na' xi' na' gudel-la na bau ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Bzéxruje̱' da zria zran xabáa, na' bétaje̱', na' guzúa da chul-la zran ni'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Gudée̱' lu be' zrie̱' tu da nazí le na querubín. Chadí gudée̱' lu be' bdunu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Gúcue̱' da chul-la, da bcache na Le̱', da na' naca na beuj bza da xuzru na nisa. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Lu da dxácatite legala chee̱' da xu'u lu beuj bza, na' beledxúaj bau dxelala, ne xiaj bezxe'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Zran xabáa gunné̱ guziu' chee̱ chi'i Xránadxu, na' ben chi'i Dios szrente̱ ládujla bau dxelala ca', ne xiaj bezxe' na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Bsane̱' xaga nalá xéche'ze chee̱' ca', na' be̱se dínnaje̱' benne' ca' dxeledábague̱' neda'. Bsane̱' xesa guziu' ca', ne bzria xi'e̱ benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Nadxa belelá' da zaj de̱ lu situj chee̱ nísadau', ne ble'e lau lane xe̱zr la xu da zua na zran nísadau', gate na' gudil-lu' benne' ca' dxeledábague̱' neda', Xran, ne lu xel-la' dxezrá'a chiu' bzagu' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Bétaje̱' lu da sibe, ne bequé̱'e̱ neda'. Bebéaje̱' neda' lu da naca ca tu nisa zila. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Bselé̱' neda' lu na' benne' wal-la dxeledábague̱' neda', ne lu na' benne' ca' dxelecuídene̱' neda', benne' zaj nácadxe̱' wál-la ca neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Buluzague̱' neda' gate na' zua' lu da sté̱bele̱'e̱, san Xrana' Dios gúcale̱ne̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Bebéaje̱' neda' naga xu'a, ne bzue̱' neda' tu lataj zren. Bselé̱' neda' lawe' da bezaca ba lazre̱' chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Xránadxu Dios bexunne̱' chia' cáte̱ze naca da xrlátaje da nuna'. Cáte̱ze naca da xrlátaje da nuna' bexunne̱' chia' ");
INSERT INTO zatNTps_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","lawe' da dxuna' ca da dxuse̱de Xrana' neda', ne quebe guleaj xíchaja' Dios chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Dxuna' ca naca da dxenná bé'ene̱' neda', ne quebe bsana' da ca' nadxíxruj be'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Guca' li lazre' lau Le̱', ne bxue cuina' chee̱ quebe guna' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Chee̱ le̱ na' bexunna Xránadxu Dios chia' cáte̱ze naca da xrlátaje da be̱na', cáte̱ze naca da xrlátaje da nuna' lau Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Dxexache lazru' chee̱ benne' dxexache lazre̱' le sa' ljwezre̱', ne nacu' li lazre' nen benne' naque̱' li lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Dxunu' da naca chawe' chee̱ benne' naque̱' chawe', na' gacu' snia nen benne' we̱n da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Guseláu' benne' zaj zue̱' lu da zi' da xa', san guzéxruju' benne' dxulucá'ana szren cuine̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Lué'queze guzalju' xi' chia'. Xrana' Dios, guzani'u chia' naga zua' lu da chul-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Nen xel-la' waca chiu' guzría xi'a benne' zante̱ dxeledíl-lale̱ne̱' neda'. Che Lue', Dios, súale̱nu' neda' waca guchínnaja' ze'e da zaj naxechaj xe̱zre ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Li lazre' zaj naca da dxun Dios, na' du lazre' naca xrtizre̱'. Dxucu'uje̱' xúgute̱ benne' ca' dxelebeza lazre̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Tuze Xránadxu naque̱' Dios. Tuze Dios chee̱dxu naque̱' Benne' dxucu'uje̱' dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Dios naque̱' Bénnea' dxune̱' neda' benne' wal-la, ne Benne' dxune̱' li lazre' da dxuna' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Dxune̱' ni'a ca zaj naca ni'a bzrina' xixre' ne dxuzúa chúchue̱' neda' lu xi'a Sión chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Dxusé̱dene̱' neda' chee̱ gaca cha'a lu wedil-la, ne̱ chee̱ gaca guchíneda' xaga nalá xéche'ze da naca na xia gache'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Lu xel-la' weselá chiu' bcu'uju' neda', ne nen na'u xabe̱la gúcale̱nu' neda'. Xel-la' zri'i lazre' chiu' ba nucá'ana szren na neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Be̱n chawu' neza naga tea', chee̱ quebe cuila' lu neza na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Blaga' benne' dxeledábague̱' neda', na' xeajzrena' le̱', na' quebe bebi'a cadxa bé̱tetea' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Be̱na' benne' ca' we̱', na' quebe guca xelexase̱'. Xeajlecházie̱' zran ni'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Btipu' lazra' chee̱ cha'a lu wedil-la. Bzéxruju' benne' dxeledábague̱' neda' zran ni'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Be̱nu' buluzrunnuj benne' dxeledábague̱' neda' lawa', chee̱ bzria xi'a benne' ca' dxelecuídene̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Gulenné̱' nu benne' gácale̱ne̱' le̱' san quebe nu chilá'. Gulenné̱' Xránadxu Dios, san quebe benne̱' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Bzúzruja' benne' ca' ca bxrte xu da dxua be'. Bléaja' le̱' ca dxuléaja' guna' la neza ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Bseláu' neda' lu na' benne' ca' dxeledábague̱', na' be̱nu' neda' benne' xíchaje̱ xe̱zr la xu ca', na' benne' ca' quebe núnbe'a dxelune̱' zrin chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Gate belenne̱' chia', na' buluzúe̱' xrtizra'. Benne' zaj zra' xe̱zr la xu ca' belune̱' ca gunná be'eda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Benne' zitu' ca' gulate ni'a ne̱'e̱, na' beledxúaje̱' dxelezrízie̱' lu xe̱zre zrentau' chee̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Gaca ba lá'azxa Xránadxu Dios. Gaca ba Bénnea' dxucu'uje̱' neda'. Xegá'ana szrénqueze Dios, Bénnea' dxuselé̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Naca Dios Bénnea' dxebéaj lazre̱' benne' dxeledábague̱' neda', ne dxuzúe̱' benne' ca' zran ni'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Naque̱' Bénnea' dxuselé̱' neda' lu na' benne' ca' dxeledábague̱' neda'. Dxune̱' dxenná be'eda' benne' ca' guledábague̱' neda'. Bselé̱' neda' lu na' benne' xichaj zra'a ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Chee̱ le̱ na' xeche̱ba' chiu', Xran, lau benne' xe̱zr la xu ca', na' gúl-laqueza' chee̱ Lau' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Dxun Dios dxenná bea bénnea' waláz chee̱', ne dxexache lazre̱' bénnea' guqué̱'e̱, bénnea' naque̱' David, ne zri'ine zre sue̱' chadía chacanna. ");
INSERT INTO zatNTps_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Dxulé'e lau zran xabáa ca naca xel-la' szren chee̱ Dios. Dxuchálajqueze na ca zaj naca da nune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Tu zra tu zra dxuzén na zra xula da nigá, na' tu zre' tu zre' dxe̱ na zre' xula da ná'queze. ");
INSERT INTO zatNTps_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Quebe dxuluchine na xrtizra' bénneache, ne quebe nu dxen chi'i na, ");
INSERT INTO zatNTps_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","san dxezriluj da dxelenná na du gabí'i xe̱zr la xu, ne dxelezrín xrtizra' na dapa saca chee̱ xe̱zr la xu. Dios be̱ne̱' xabáa ca tu xu'u naga zua gubizra. ");
INSERT INTO zatNTps_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Che zílala dxalaj na ca tu benne' wechaga na'. Dxebé na ca tu benne' dxezá chégüe̱' lu witja. ");
INSERT INTO zatNTps_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Dxedxuaj na chalá'a naga dxalaj na, na' dxezrín na chalá'a naga dxebía na. Dxuchá'a na xúgute̱ da zaj de̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Du lazre' naca da nadxixruj bea Xránadxu, ne dxuzé̱ chacha na bénne'du xú'udxu. Li lazre' naca da dxexeche̱be Xránadxu, ne dxunezruj na xel-la' sina chee̱ benne' ca' quebe zaj nape̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Da líqueze zaj naca da nadxixruj bea Xránadxu, na' dxelebéle̱'e̱ benne' ca' dxelune̱' ca zaj naca na. Du lazre' zaj naca da dxuzéajni'i Xránadxu dxi'u, da dxuluzúa na dxi'u lu xel-la' naxaní'. ");
INSERT INTO zatNTps_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Cháwedau' naca zrébedxu Xránadxu, da gun na súadxu chadía chacanna. Da líqueze zaj naca da dxuchi'a Xránadxu chee̱dxu, ne zaj naca na chawe'. ");
INSERT INTO zatNTps_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Zaj naca na da dxezá lázredxadxu ca oro, ne ca oro zrente̱ da zácale̱'e̱ na. Zaj naca na zíxredxa ca bzrína'dau', da nácale̱'e̱ na zixre. ");
INSERT INTO zatNTps_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Dxulusizre na neda', we̱n zrin chiu'. Lawe' da dxuna' ca zaj naca na, da zrente̱ dxezi'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Netú benne' quebe gaca lé'ene̱' da cale̱la da dxune̱'. Bselá neda', Xran, lu da cale̱la da quebe dxéquebe'eda' dxuna'. ");
INSERT INTO zatNTps_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Bucache chawe' neda', we̱n zrin chiu', chee̱ quebe bi dul-la guna' du lazra'. Quebe gu'u lataj nna be'e dul-la neda'. Nadxa gaca' du lazra', ne quebe baga' zria chee̱ dul-la na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Gaca da dxuchálaja', ne da dxulaba lazra' da dxezaca ba lazru' Lue', Xran Nacu' Benne' dxuxúe̱' neda', ne Benne' dxexá'ue̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Dxenaba' Xránadxu xenne̱' chi'u lu zra zu' lu da ste̱be, ne gucu'uj La Dios chee̱ Jacob lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Dxenaba' Le̱' naga zue̱' lataj lá'azxa chee̱' sel-le̱' da gácale̱ na lue', ne chee̱ xi'a Sión xide̱' guxre̱' lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Dxenaba' Le̱' cheajsá lazre̱' ca naca xúgute̱ guna' bzu' chee̱', ne si' lu ne̱'e̱ béadu ca' dxuzezxu' lawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Dxenaba' Le̱' gunne̱' lue' ca naca da dxezá lazru', ne gune̱' xúgute̱ da dxéquenu' xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Béle̱'e̱ntu' gate guselé̱' lue', na' chísantu' tu da gulé'e lawe na La Dios chee̱dxu. Dxenaba' Xránadxu gunne̱' lue' xúgute̱ da dxenabu' lau Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Na'a nezda' dxuselá Xránadxu bénnea' ba gucá'aqueze̱'. Naga zue̱' xabáa lá'azxa chee̱' xenne̱' chi'i bénnea'. Xel-la' waca zrente̱ chee̱' guselé̱' bénnea'. ");
INSERT INTO zatNTps_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Bal-la benne' dxuluxrén lazre̱' carro ca' chee̱ wedil-la, na' xezícadxe̱' dxuluxrén lázre̱' bzrina' ca'. Dxi'u dxuxrén lázredxu La Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Benne' ca' gulate ni'a ne̱'e̱, ne xeajlechazie̱'. Dxi'u bexásadxu, na' ze̱dxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Bselá netu', Xran, nacu' Wenná Bea chee̱ntu'. Ben chi'intu' gate dxuláwizrantu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Benne' dxenná bea dxebéle̱'e̱ne̱' nen xel-la' waca chiu', Xran, na' ca naca xel-la' weselá chiu' dxebéle̱'e̱ne̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Bnézruju' le̱' da guzá lazre̱', ne quebe bzagu' da gunabe̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Guzí' lu na'u le̱', ne be̱nu' dxaca chawe' chee̱'. Nuzriu' xíchaje̱' tu da naca na oro. ");
INSERT INTO zatNTps_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Gunabe̱' Lue' gunnu' le̱' xel-la' nabán, na' bnézruju' na le̱' chee̱ súaqueze̱' zane' iza. ");
INSERT INTO zatNTps_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Zrente̱ naca xabáa chee̱' lawe' da bseláu' le̱'. Be̱nnu' le̱' xel-la' ba lá'ana, ne xel-la' szren. ");
INSERT INTO zatNTps_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Lawe' da nunu' gaca chawe' chee̱' chadía chacanna dxunu' dxebéle̱'e̱ne̱' lau Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Lawe' da dxuxrén lazre' wenná bea na' Xránadxu, xexache lazre' Dios szrente̱ le̱', na' quebe sue̱' lu da ste̱be. ");
INSERT INTO zatNTps_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Xulétaju' xúgute̱ benne' dxeledábague̱' lue'. Xel-la' waca chiu' xulétaju' benne' ca' dxelecuídene̱' lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Lu zra na' zra'u le̱' gaca chee̱ benne' ca' ca guzú' le̱' lu xi' ga dxulúzrie̱' bla'dau'. Xránadxu guzúzruje̱' benne' ca' lu xel-la' dxezrá'a chee̱', na' xi' na' guzezxe na le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Xúgute̱ da belune̱' lu xe̱zr la xu nigá guzria xi'u, ne xegú' zri'ine zre sue̱' ládujla bénneache, ");
INSERT INTO zatNTps_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","lawe' da gulaca lazre̱' xelune̱' da cale̱la chiu' Lue'. Gulilaj lazre̱' ca da xelune̱', san quebe bi xelezéquene̱', ");
INSERT INTO zatNTps_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","lawe' da gulagu' benne' ca'. Nucuezu' xaga nalá xéche'ze chiu' chee̱ le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Begá'ana szrénqueze Lue', Xran, lu xel-la' wal-la chiu'. Tu gúl-lazquezdxu, ne tu güe lá'anazquezdxu Lue' ca naca xel-la' waca chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Dios chia', Dios chia', ¿bizr chee̱ na' nusán lazru' neda'? ¿Bizr chee̱ na' quebe dxennu' da dxenaba' Lue' chee̱ guseláu' neda'? ");
INSERT INTO zatNTps_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Dios chia', dxuláwizra' Lue' te zra, ne quebe dxexeche̱bu' chia'. Dxuláwizra' Lue' chizrela, ne quebe dxezí'i lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Lá'azxa nacu' Lue'. Nacu' Benne' dxebeze̱' naga dxelúe lá'ana benne' Israel Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Xra xrtáuntu' gulebeza lazre̱' Lue'. Gulebeza lazre̱', na' bseláu' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Bululáwizre̱' Lue', na' belelé̱'. Buluxrén lazre̱' Lue', na' quebe belexedué'ene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Neda' naca' ca tu be̱la' gúna'dau', ne quegá bénneache. Dxelecuide bénneache neda', ne dxuluzúe̱' neda' chalá'ala. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Xúgute̱ benne' dxelelé'e neda' dxelún le̱' chia'. Lu da dxelún le̱' chia' dxelexrá dxu'e̱, ne dxulutá xíchaje̱', dxelenné̱': ");
INSERT INTO zatNTps_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","“Bzua cuine̱' lu na' Xránadxu chee̱ guselé̱' le̱'. Guselé̱' le̱' che dxezaca ba lázrele̱ne̱' le̱'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Lue' nacu' Bénnea' be̱xru' neda' gate gúlaja'. Be̱nu' bxren lazra' Lue' gate na' ne dxázretea'. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Guxu'a lu na'u gate quebe ne gálajtea'. Gate ne xu'a lu le̱'e̱ xrna'a, báchequeze nacu' Dios chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Quebe xebigu' naga zua' lawe' da zua gágute̱ da gusaca zi na neda', ne quebe nu chilá' benne' gácale̱ne̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Zaj naxechaj benne' dxeledábague̱' neda' ca be̱zre ca'. Zaj naxechaj benne' neda' zaj naque̱' ca be̱zre wal-la ca' chee̱ Basán. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Gulaca lazre̱' xuluzría xi'e̱ neda' ca tu be̱zre xixre' dxedunba', ne dxebezre xa'aba'. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Bebizre lazra' ca nisa da nalalaj na lu xu, na' ca naca zrita xu'a bulusán ljwezre na. Lázrdawa' guca na ca xina' da bxuna na lu le̱'a ca nisa. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Bexaca xel-la' wal-la chia' ca tu xé'ena xu la'a, na' luzra' bedá' na chichja'. Nuzú' neda' lu xu xrte chee̱ xel-la' gute. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Zaj naxéchaje̱' neda' ca becu' ca'. Zaj naxechaj benne' we̱n da zrinnaj ca' neda'. Gulídue̱' ni'a na'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Waca gulaba' ca naca zrita xu'a, na' benne' ca' dxelenné̱'e̱ neda', ne dxelenná' xánnie̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Belexelé̱'e̱ zra lana' late' weaj, na' lawe' zra lana' gulebeje̱' da gaca bea na. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Quebe xebigu' naga zua', Xran. Nacu' xel-la' wal-la chia'. Gudázega gácale̱nu' neda', Xran. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Bselá bénne'du xu'a lu na' benne' gu'e̱ neda' xia. Bénnea' guzría xi'e̱ neda' gune̱' ca dxun becu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Bselá neda' lu dxu'a be̱zre xixre'. Bselá neda' lu luzu be̱zre wal-la ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Guzenda' bi bícha'dau' ca' lau' Lue'. Güe lá'anaqueza' Lue' ladaj benne' zaj nazrague̱' lau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Le'e, dxezrébele Xránadxu, le güe lá'ana Le̱'. Le gucá'ana szrene̱', le'e, zri'ine zre sua Jacob. Le zrebe Le̱', le'e, zri'ine zre sua Israel. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Quebe bzua Dios chalá'ala, ne quebe gucuídene̱' da zi' da xa' da guledé benne' xache' ca', ne quebe bcache lawe̱' lau benne' ca' san gate bululáwizre̱' Le̱', benne̱' chi'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Güe lá'anaqueza' Lue' laduj benne' zan zaj nazrague̱' lau'. Ca da guche̱be lazra' gúnqueza' lau benne' ca' dxelezrebe̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Xelagu benne' dxexruj lazre', ne welélajquezne̱'. Benne' ca' dxelebigue̱' lau Xránadxu xelúe lá'anaqueze̱' Le̱'. Tu gácazqueze da ba neza chee̱ benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Cheajlesá lazre' benne' dute̱ xe̱zr la xu Xránadxu, na' xelexebí'e̱ lau Le̱'. Xúgute̱ cue' benne' chee̱ xúgute̱ cue' xe̱zr la xu xelúe lá'anaqueze̱' Le̱', ");
INSERT INTO zatNTps_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","lawe' da xu'u lu na' Xránadxu xel-la' dxenná bea, na' nna bé'ene̱' xúgute̱ benne' xe̱zr la xu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Xeláguqueze xúgute̱ benne' zren ca' chee̱ xe̱zr la xu nigá, ne xelúe lá'anaqueze̱' Dios. Xuluzú zribe lau Le̱' xúgute̱ benne' ca' xelate, benne' ca' quebe xelezéquene̱' xelegú'u chawe̱' bénne'du zaj xu'e̱ chee̱ quebe xelatie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Zri'ine zre sua benne' ca' xelunbe' zrin chee̱ Xránadxu. Xuluzenne̱' zrí'ine̱' ca' ca naca chee̱ Xránadxu cadxa cheajse̱te̱ chee̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Xelezrine̱', ne xuluzenne̱' bénneache ca naca da xrlátaje da dxun Dios. Xuluzenne̱' benne' quebe ne xelálaje̱' be̱n Dios da caní. ");
INSERT INTO zatNTps_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Xránadxu Dios dxuxúe̱' neda' ca tu benne' dxuxúe̱' zrila' chee̱'. Quebe bi dxexázrjeda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Ca dxelezrúa zríla'du ca' ba guláguba' xixre' xá'adau', caní dxune̱' chia' chee̱ xezí' lazra'. Gune̱' chia' ca dxaca chee̱ zrila' ca' dxeché̱'e̱-ba' dxu'a xe̱gu nisa da de̱ zrize. ");
INSERT INTO zatNTps_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Dxuxuzúa chúchue̱' neda' lu xichaj lázrdawa'. Dxusi'e̱ neda' lu da xrlátaje chee̱ gaca li da guche̱be lazre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Láqueze tea' naga sua' lu da ste̱be chee̱ xel-la' gute, quebe bi da cale̱la guchebe na neda', lawe' da zúale̱nu' Lue' neda', Xran, na' dxelácale̱ zrise', ne blazru chiu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Dxucuezu' da xi'aj gawa' lácala benne' dxeledábague̱' neda' zaj naxechaj neda'. Dxugú'u da za xichja' da dxapa na neda' ba lá'ana, ne dxusezráteu' zriga' chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Da xrlátaje, ne xel-la' dxexache lazre' chiu' da lítegaze xelezúale̱ na neda' xúgute̱ zra naca bana', na' lizru', Dios, gaca na lizra' chadía chacanna. ");
INSERT INTO zatNTps_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Chee̱ Dios naca xe̱zr la xu nigá ne xúgute̱ da zaj de̱ lawe na. Naca chee̱' xe̱zr la xu, ne xúgute̱ bénneache zaj zre̱'e̱ ga na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Bzue̱' na lawe' nísadau', ne bzale̱' lane na sítujla zran nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","¿Nu seque' cuen xi'a chee̱ Xránadxu? ¿Nu seque' chu'u xudau' lá'azxa chee̱'? ");
INSERT INTO zatNTps_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Waca benne' ca' zaj naque̱' du lazre' ca naca da dxelune̱', ne ca naca da dxulaba lazre̱'. Benne' ca' quebe ne xelechisa ne̱'e̱ lau bedáu' xiaj xaga ca', ne quebe bi ne xeleche̱be lazre̱' da naca we̱n lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Xránadxu gune̱' da chawe' chee̱ benne' caní. Dios guchi'e̱ chee̱ benne' caní, ne guselé̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Caní zaj naca bénneache dxelebigue̱' lau Le̱', benne' ca' dxelexu'e̱ naga zua Dios chee̱ Jacob. ");
INSERT INTO zatNTps_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Le salaj dxa xu'u chee̱ xudau'. Le salaj dxa xu'u chawe' ca', na' chu'u Wenná Bea szrente̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","¿Nuzra na' Wenná Bea szrente̱ nigá? Naque̱' Xránadxu, Benne' wal-la, Bénnea' nape̱' dute̱ xel-la' waca. Naque̱' Xránadxu, Bénnea' dxedxúaje̱' chawe' lu wedil-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Le salaj dxa xu'u chee̱ xudau'. Le salaj dxa xu'u chawe' ca', na' chu'u Wenná Bea szrente̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","¿Nuzra na' Wenná Bea szrente̱ nigá? Naque̱' Xránadxu, Benne' dxenná bé'ene̱' xúgute̱ da zaj zua. Le̱' naque̱' Wenná Bea szrente̱ na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Xran, dxennía' Lue' dute̱ lázrdawa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Dxuxrén lazra' Lue', Dios chia'. Quebe gu'u lataj xedué'eda'. Quebe gu'u lataj benne' dxeledábague̱' neda' xuluzétaje̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Da líqueze, benne' ca' dxelebeza lazre̱' Lue' quebe xeleque zréajene̱'. Xeledué'e benne' ca' dxeledábague̱' xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Xran, ble'e neda' da dxaca lazru' guna'. Ble'e neda' da dxezaca ba lazru' guna'. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Bse̱de neda' guna' ca naca da li chiu' lawe' da nacu' Dios dxuseláu' neda'. Tu dxebeza lázrezqueza' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Bsa lazre', Xran, gacu' zri'i lazre', ne xexache lazru' chia' cáte̱ze da dxúntequezu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Quebe chajsá lazru' dul-la da be̱na' gate ne naca' benne' cuide', ne ca gudábaga' xrtizru'. Nen dute̱ xel-la' dxexache lazre' chiu', bsa lazre' neda', ne nen dute̱ xel-la' zri'i lazre' chiu', Xran. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Xrlátaje, ne li lazre' naca Xránadxu Dios. Chee̱ le̱ na' gusé̱dene̱' benne' dul-la ca' da dxal-la' xelune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Gulé'ene̱' benne' dxexruj lazre' ca' da xrlátaje da xelune̱', ne gusé̱dene̱' benne' zren lazre' ca' da xelune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Lu xel-la' dxexache lazre', ne lu da li dxeché̱ Xránadxu benne' ca' dxelune̱' ca naca xel-la' wezría chee̱', ne ca da dxuse̱de Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Lawe' da dxunu' ca da ba gunníu', Xran, gunite lau' ca naca dul-la nuna', da naca na zren. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","¿Nu benne' dxezrebe̱' Xránadxu Dios? Le̱' gusé̱dene̱' benne' nigá da dxal-la' gune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Gaca chee̱' tu da ba neza zrente̱, na' zri'ine zre sue̱' gaca chee̱be' xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Xránadxu Dios naque̱' tuze nen benne' ca' dxelezrebe̱' Le̱', na' gune̱' xelúnbe'e̱ xel-la' wezría chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Tu dxennázqueza' Xránadxu Dios lawe' da guselé̱' neda' lu na' benne' ca' dxelaca lazre̱' xele̱l-le̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Gunná' neda', ne bexache lazre' neda' lawe' da zua' tuza', ne dxezaca zi'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Naxánle̱'e̱ da ste̱be da zaj zua lázrdawa'. Bselá neda' lu da ste̱be zua'. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Gunná' ca dxezaca zi'a, ne ca dxunle̱'a zrin, na' bnite lau xúgute̱ dul-la da nabaga'. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Gunná' benne' ca' dxeledábague̱' neda' ca naxánle̱'e̱ne̱', ne ca dxelecuídele̱'e̱ne̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Bxue bénne'du xu'a, ne bselá neda'. Quebe gu'u lataj xedué'eda' lawe' da dxuxrén lazra' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Zaj nuxru da xrlátaje, ne xel-la' li lazre' neda' lawe' da dxebeza lazra' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Dios, bselá benne' Israel ca' lu xúgute̱ da dxelezaca zi'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Bchi'a chia', Xran, lawe' da nuna' da xrlátaje. Bxren lazra' Lue', Xrana' Dios, ne quebe be̱n chupa lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Gunná' xanne' lázrdawa', Xran, ne bxue ca da nuna'. Gunná' xanne' da xu'u lu xichaj lázrdawa' ");
INSERT INTO zatNTps_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","lawe' da dxeque be'eda' dxexache lazru' neda', ne dxuna' ca naca da li chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Quebe ne guna' tu zren benne' ca' dxelune̱' da xrlátaje cúzreze, ne quebe ne guna' tuze benne' ca' dxululé'e cuine̱' xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Dxecuídeda' da dxelún benne' ca' dxelune̱' da cale̱la naga dxelezrague̱', ne quebe ne chu'a tu zren benne' ca' dxuluzúe̱' Dios chalá'ala. ");
INSERT INTO zatNTps_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Dxelé'enu' quebe bi zria nabaga', na' waca biga' lu cugu chiu', Xran, ");
INSERT INTO zatNTps_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","chee̱ cuezre xa'a, xapa' Lue': “Xcalenu'”, ne chee̱ guzenda' bénneache ca naca da zren ca' da nunu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Xran, nazrí'ida' lizru' naga zu', ne lataj lá'azxa naga zua da xabáa chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Quebe guzría xi'u neda' tu zren nen benne' dul-la ca', ne quebe gutiu' neda' tu zren nen benne' ca' dxelútie̱' benneáche, ");
INSERT INTO zatNTps_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","benne' ca' dxelune̱' da cale̱la, ne tu dxulunézrujzqueze̱' dumí chee̱ xelelé̱' lu da zaj nune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Neda' tu gúnzqueza' da naca li lazre'. Bselá neda', ne bexache lazre' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Tu núnzqueza' da xrlátaje, na' güe lá'anaqueza' Xránadxu Dios lau benne' ca' zaj nazrague̱' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Xránadxu Dios naque̱' xel-la' naxaní' chia', ne Benne' dxuselé̱' neda'. ¿Nu benne' gaca guchebe̱' neda'? Xránadxu Dios naque̱' Benne' dxucu'uje̱' neda'. ¿Nu benne' gaca guzúe̱' neda' lu da sté̱bele̱'e̱? ");
INSERT INTO zatNTps_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Gate guléchaj benne' ca' dxelune̱' da cale̱la chia', nen benne' ca' dxulusaca zi'e̱ neda', ne benne' ca' dxeledábague̱' neda' chee̱ xuluzría xi'e̱ neda', na' gulechégüe̱', ne xeajlecházie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Láqueze xeléchaj tu cue' benne' dxjaque̱' wedil-la neda', benne' ca' dxeledábague̱' neda', quebe zrébequeza'. Láqueze xuluzúe̱' neda' lu wedil-la, neda' guxrén lázrequeza' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Tu da gunábeda' Xránadxu Dios. Da nigáze sa lazra', da naca na chee̱ sua' lizre Xránadxu xúgute̱ zra gaca bana', chee̱ gulaba lazra' ca naca da xrtante̱ chee̱ Xránadxu, ne chee̱ guchálajle̱na' Le̱' lu xudau' lá'azxa chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Le̱' gucache chawe̱' neda' lu lataj lá'azxa chee̱' lu zra dxaca da cale̱la. Gucache chawe̱' neda' lu lataj cheé̱queze̱' naga zúaqueze̱'. Guzúe̱' neda' tu naga se̱ cháweda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Nadxa gune̱' guzétaja' benne' dxeledábague̱' neda', ne zaj naxéchaje̱' neda', na' nen dute̱ xel-la' dxebé gutia' béadu ca' guzúa'-ba' lu cugu chee̱'. Gúl-laqueza', ne tu güe lá'anazqueza' Xránadxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Xran, ben chi'a gate ne dxuláwizra' Lue'. Bexache lazre' neda', ne beche̱be chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Lu xichaj lázrdawa' benda' chi'u, gunníu': “Bexilaj chia'.” Xexílaja' chiu', Xran. ");
INSERT INTO zatNTps_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Quebe gucache lau' chia' neda'. Lu xel-la' dxezrá'a chiu' quebe xebigu' naga zua' neda', we̱n zrin chiu'. Nacu' Benne' dxácale̱ne̱' neda'. Quebe gusanu' neda', ne quebe cueaj xichju' neda', Dios, weselá chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Lácala xulusán xra xrna'a neda', tu xecá'azqueze Xránadxu Dios neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Bse̱de neda' da dxaca lazru' guna', Xran, ne ble'e neda' da li lazre' da dxal-la' guna', lawe' da zaj naxán benne' dxeledábague̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Quebe gu'u lataj benne' dxeledábague̱' neda' xelune̱' chia' da dxelaca lazre̱' lawe' da zaj naxechaj benne' we̱n lazre' neda' nen benne' dxelaca lazre̱' xulusaca zi'e̱ neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Xránadxu Dios guche̱be lazre̱' le'eda' da xrlátaje chee̱' naga gaca bana'. La quebe guxéajle̱'a da nigá, na' gute ni'a na'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Le cueza xelá' Xránadxu. Le gutipa lázrele, na' Le̱' guzé̱ chúchue̱' le'e. Awe', le cueza xelá' Xránadxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Xran, dxuláwizra' Lue'. Nacu' Benne' dxucú'uju' neda'. Bze̱ naga chi'a lawe' da che quebe xennu' neda' gaca' ca tu benne' dxu'e̱ lataj ba xa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Ben chi'a dxuláwizra' Lue', ne dxechisa na'a lau' naga zu' lataj lá'azxa chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Quebe guzría xi'u neda' tu zren nen benne' we̱n da cale̱la ca', ne cá'anqueze nen benne' ca' dxelune̱' da zrinnaj, benne' ca' dxelenné̱' dizra' cháwedau' lau le sa' ljwezre̱', san xu'u lázrdawe̱' da cale̱la gune̱' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Bde benne' ca' lu da ba xa' cáte̱ze naca chee̱ da belune̱', cáte̱ze naca da cale̱la da zaj nune̱'. Bunezruj chee̱ benne' ca' cáte̱ze da belune̱', da na' dxal-la' xelezí'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Lawe' da quebe gulape̱' ba lá'ana da be̱n Xránadxu, ne quegá da be̱ne̱' lu ni'a ná'queze̱', guxrínnaje̱' benne' ca', ne gudée̱' le̱' lu da ba xa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","¡Gaca ba Xránadxu Dios, Bénnea' benne̱' chi'a gate bláwizra' Le̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Xránadxu naque̱' Bénnea' dxuzé̱ chúchue̱' neda', ne dxucu'uje̱' neda'. Bxren lazra' Le̱', na' gúcale̱ne̱' neda', na' chee̱ le̱ na' gubéle̱'e̱da', na' gul-laqueza', ne güe lá'anaqueza' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Xránadxu naque̱' Bénnea' dxuzé̱ chúchue̱' benne' chee̱' ca', ne naque̱' Benne' dxucu'uje̱', ne dxuselé̱' bénnea' guqué̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Bselá benne' chiu' ca', ne be̱n gaca chawe' chee̱ da naca chee̱'. Bxue benne' ca', ne be̱xru le̱' chadía chacanna. ");
INSERT INTO zatNTps_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Le güe lá'ana Xránadxu, le'e, zrale xabáa. Le güe lá'ana xel-la' szren chee̱', ne xel-la' waca chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","¡Da xabáa naca La Xránadxu! ¡Le güe lá'ana na! Le guzú zríbele lau Xránadxu lá'azxa gate xelé̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Chi'i Xránadxu dxen na lawe' nísadau'. Dxen chi'i Dios xabáa ca guziu' da dxenné̱ na. Dxedá chi'e̱ lawe' nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Dxen chi'i Xránadxu ca naca xel-la' wal-la chee̱ na. Dxen chi'i Xránadxu dute̱ xel-la' szren chee̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Chi'i Xránadxu dxichaj na xaga cedro ca'. Dxichaj na xaga cedro ca' zaj ze̱ na xi'a Líbano. ");
INSERT INTO zatNTps_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Dxuxrite na xi'a Líbano ca' ca dxelexrite bé̱zredu ca', na' dxuxrite xi'a Hermón ca tu bé̱zredau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Chi'i Xránadxu dxun na chaze xesa. ");
INSERT INTO zatNTps_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Chi'i Xránadxu dxuxrize na le̱'e̱ xixre' lawe' lataj. Dxuxrize na le̱'e̱ xixre' chee̱ xe̱zr la xu Cades. ");
INSERT INTO zatNTps_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Chi'i Xránadxu dxuxrize na xaga wal-la ca'. Dxuchibe na xrlegue xaga ca', na' lu xudau' chee̱' dxelenná xúgute̱ bénneache: “¡Gaca ba Dios!” ");
INSERT INTO zatNTps_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Dxenná be'e Xránadxu nísadau' ca'. Chadía chacanna dxenná be'e̱ ca Wenná Bea. ");
INSERT INTO zatNTps_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Xránadxu Dios dxuzé̱ chache̱' benne' chee̱' ca'. Dxuzúe̱' le̱' lu da ba neza chee̱ xel-la' dxebeza zri lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Gucá'ana szrena' Lue', Xran, lawe' da bechisu' neda', ne quebe bnézruju' lataj benne' ca' dxeledábague̱' neda' xelún le̱' chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Xrana' Dios, bláwizra' Lue', na' bexunu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Xran, bseláu' neda' lu lataj ba xa'. Bexunu' neda' chee̱ quebe chu'a xe̱dxu ba. ");
INSERT INTO zatNTps_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Le gul-la chee̱ Xránadxu, le'e nácale benne' cheé̱queze̱'. Le xe̱ Le̱': “Xcalenu'”, ne dxajsá lázrele naque̱' lá'azxa, ");
INSERT INTO zatNTps_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","lawe' da tu chí'idauze dxezré̱'e̱ san chadía chacanna zua xel-la' zri'i lazre' chee̱'. Wabézredxu tu zreze, san che zílala wabéle̱'e̱dxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Gate guzúa chawa' gunnía': Quebe nu seque' gutá neda', ");
INSERT INTO zatNTps_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","lawe' da bze̱ chuchu' neda', Xran, ca tu xi'a zren, ne blé'enu' neda' cháwedau'. Gate bcache lau', na' guzúa' ste̱be. ");
INSERT INTO zatNTps_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Xran, guláwizra' Lue', ne gata' xueda' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","¿Bizra da ba neza gaca na chiu' che gatia', ne chu'a xe̱dxu ba? ¿Güe lá'ana' Lue' gate ba naca' xu xrte? ¿Waca nu guzenda' da li chiu'? ");
INSERT INTO zatNTps_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Bze̱ naga neda', Xran, ne bexache lazre' neda'. Xran, gúcale̱ neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Be̱nu' bexaca xel-la' dxebezre chia' xel-la' wexá'a. Bcuasu' xel-la' dxewí'ine lazre' chia', ne bzu' chia' xel-la' dxebé. ");
INSERT INTO zatNTps_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Chee̱ le̱ na' tu gúl-lazqueza' chiu', lawe' da nacu' da ba neza chia', ne quebe sua zríqueza'. Xrana' Dios, tu güe lá'anazqueza' Lue' chadía chacanna. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Dxuxrén lazra' Lue', Xrana' Dios. Quebe gu'u lataj xedué'eda'. Lu da xrlátaje chiu' bselá neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Bze̱ naga chi'a, ne bselá neda'. Bze̱ chuchu neda', ne bucú'uj neda' chee̱ la'. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Nacu' Benne' dxuzé̱ chuchu' neda', ne dxucú'uju' neda'. lawe' da nacu' li lazre' gulé'enu' neda' neza, ne gusi'u neda' neza na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Bebéaj neda' lu xralaj da ba zaj nucueze̱', chee̱ xele̱l-le̱' neda'. Lue' nacu' Benne' dxuxúe̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Lu na'u dxuzúa' bénne'du xu'a, Xran. Lue' bexá'awenu' neda', Dios li lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Dxecuídeda' benne' ca' dxelebeza lazre̱' dios ca' quebe bi zaj zaca. Neda' dxebeza lazra' Xrana' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Béle̱'e̱da', ne sua' lu da ba neza lawe' da dxexache lazru' neda'. Caní dxunu' lawe' da dxelé'equeznu' ca da dxezaca zi'a. Nézenu' ca dxedéa' lu da ba xa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Quebe bdeu' neda' lu na' benne' ca' dxeledábague̱' neda'. Bze̱ chuchu' neda' tu lataj chawe'. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Bexache lazre' neda', Xrana' Dios, lawe' da zua' lu da ba xa'. Ba bebizre nisa xuzru xiaj lawa' lawe' da dxewí'ine lazra' dute̱ bénne'du xu'a, ne dute̱ be̱la' dxen chia' ");
INSERT INTO zatNTps_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","lawe' da dxedé xel-la' nabán chia' lu da ba xa', ne dxedéa' iza chia' ca' dxebezre lazra'. Dxedú lazra' lawe' da nabaga' zria, na' dxelelá zrita xu'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Xúgute̱ benne' ca' dxeledábague̱' neda' dxelecuídene̱' neda', na' benne' walízr chia' dxuluzúe̱' neda' chelá'ala, na' benne' zaj núnbe'e̱ neda' dxelecuase̱' neda'. Benne' ca' dxelelé'ene̱' neda' la neza dxuluzrúnnuje̱' naga zua'. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Benne' caní ba gulal-la lazre̱' neda' ca dxelal-la lazre̱' tu benne' gate. Naca' neda' ca tu xé'ena xu da nalá'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Dxenda' dizra' schanni' da dxelenná benne' zante̱ chia', na' gátete̱ze zua da dxuchebe na neda'. Dxácate̱ na' dxelune̱' tuze dizra' bi xelune̱' chia', ne zaj nune̱' xelútie̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Neda' dxuxrén lazra' Lue', Xran. Dxennía' nacu' Lue' Dios chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Lu na'u Lue' zaj xu'u zra chia' ca'. Bselá neda' lu na' benne' ca' dxeledábague̱' neda', ne lu na' benne' ca' zaj nau zi' xuzre̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Lu xel-la' szren chiu' bxue neda', we̱n zrin chiu'. Lu xel-la' dxexache lazre' chiu' bselá neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Quebe gu'u lataj xedué'eda', Xran, lawe' da dxuláwizra' Lue'. Be̱n xelexedué'e benne' ca' dxelebéaj xíchaje̱' Lue'. Be̱n xelezúa zrie̱' lu lataj ba xa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Be̱n quebe gaca xelenné̱ benne' ca' dxelezí xe̱'e̱, benne' ca' dxelenné̱' da cale̱la chee̱ benne' xrlátaje ca', da dxelenné̱' lu xel-la' dxulucá'ana szren cuina, ne lu xel-la' dxulucá'ana ditaj benne' caní. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Da zrente̱ naca xel-la' zri'i lazre' chiu' da napu' chee̱ bi gunu' chee̱ benne' ca' dxelape̱' Lue' ba lá'ana, da na' dxunu' lau xúgute̱ bénneache ne̱ chee̱ benne' ca' dxelebeza lazre̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Lu da bagácheze naga zu' Lue' dxucachu' benne' ca' chee̱ quebe bi xelún bénneache chee̱'. Dxuzú' benne' ca' tu lu xu'u nagache chee̱ quebe bi gun chee̱' xel-la' wetil-la dizra' chee̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","¡Gaca ba Xránadxu Dios! Lu xel-la' dxexache lazre' chee̱' be̱ne̱' da zrente̱ chee̱ gúcale̱ne̱' neda' tu lu xe̱zre naga guca wedil-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Gate na' guzúa da dxuchebe neda' gunnía': Zua' naga québedxa le'e Xrana' neda'. Lue' bennu' chi'a da guta' xueda' Lue' gate na' bláwizra' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","¡Le zri'i Xránadxu, xúgute̱le le'e nácale benne' chee̱ Lé̱queze̱'! Xránadxu dxuxúe̱' benne' ca' quebe dxulusane̱' Le̱', na' dxuxunézrujle̱'e̱ chee̱ benne' ca' dxulucá'ana szrene̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Le gutipa lázrele, xúgute̱le le'e dxebeza lázrele Xránadxu Dios, na' Le̱' guzé̱ chúchue̱' le'e. ");
INSERT INTO zatNTps_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","¡Ba neza zrente̱ naca na chee̱ bénnea' Dios ba bnite lawe̱' dul-la da gubágue̱', ne ba gudúe̱' zria da guzúa chee̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","¡Ba neza zrente̱ naca na chee̱ bénnea' Dios quebe dxusebague̱' le̱' zria, bénnea' quebe dxezí xe̱'e̱! ");
INSERT INTO zatNTps_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Gate quebe guxrúale̱pa' dul-la gubaga', bedú lazra' lawe' da gudxezra' bedú zra. ");
INSERT INTO zatNTps_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Te zra ne chizrela bdeu' neda' xel-la' zi', Xran. Bedú lazra' ca dxebizre beaj nisa beu' la. ");
INSERT INTO zatNTps_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Nadxa guxrúale̱pa' dul-la gubaga', ne quebe bcacha' zria da guzúa chia'. Bechugu lazra' guxrúale̱pa' na lau Lue', Xran, na' Lue' bnite lau' chee̱ dul-la gubaga'. ");
INSERT INTO zatNTps_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Xúgute̱ bénneache chiu' dxal-la' xuluchálajle̱ne̱' Lue' gate de̱ lataj xelexezrelne̱' Lue', na' gate zrin da zi' da xa' da xelezaque̱', da gaca na ca tu xe̱gu nisa zren da dxedxuaj na, na' quebe bi gune na benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Lue' nacu' ca tu lataj naga gaca gucache cuina', na' gucache chawu' neda' chee̱ quebe bi da saca'. Tu gul-lazqueza' zizraj ca bseláu' neda' lawe' da dxuxú' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Dxenná Xránadxu: “Gulé'eda' lue' neza naga dxal-la' tau'. Gusé̱deda' lue', ne guzéajni'ida' lue' ca dxal-la' gunu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Quebe gacu' ca tu bzrina' u tu bea, be̱ quebe bi dxeléajni'iba', bea ca' dxun na ba xen nna be'enu'-ba', na' cu'u xia dxú'aba', chee̱ gunu' xelunba' ca dxaca lazru'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Benne' we̱n da cale̱la ca' dxun na ba xen xeledée̱' lu da zi' da xa'. Benne' ca' dxuluxrén lazre̱' Xránadxu, tu dxuxúezqueze̱' le̱' nen dute̱ xel-la' zri'i lazre' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Le'e, benne' xrlátaje, le be, ne le sua lu da ba neza, ne̱ chee̱ da be̱n Xránadxu, gúcale̱ne̱' le'e. Nen dute̱ xel-la' dxebé le gul-la, le'e, nácale li lazre' lau Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Le be le'e, benne' xrlátaje, lau Xránadxu Dios. Xrtante̱ naca lau Dios da dxelúe lá'ana benne' xrlátaje ca' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Le gucá'ana szren Dios nen da zríadi'i na du da dxínnele. Le gúl-laqueze chee̱' nen da dxúl-lale̱nle, ne nen tu da nua na chi du. ");
INSERT INTO zatNTps_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Le gul-la chee̱ Le̱' tu da cube. Le gul-la cháwedau', quínnele dute̱ xel-la' dxebé. ");
INSERT INTO zatNTps_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Li lazre' naca xrtizra' Xránadxu Dios, na' nune̱' dute̱ lu xel-la' li lazre' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Le̱' nazrí'ine̱' da naca xrlátaje, ne da naca du lazre'. Zaj núnbea bénneache xel-la' dxexache lazre' chee̱ Xránadxu du gabí'i xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Ne̱ chee̱ xrtizra' Xránadxu Dios, be̱ne̱' xabáa, na' xúgute̱ belaj da zaj nalá' zran xabáa be̱ne̱' nen be' dxedxuaj dxu'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Le̱' dxuxutube̱' nísadau', ne dxexune̱' na ca tu xi'a nisa. Dxegá'a chawe̱' nisa lu da situj ca' naga nucueze̱' chee̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Le zrebe Xránadxu Dios, xúgute̱le zrale xe̱zr la xu nigá. Le zrebe lau Le̱', xúgute̱le le'e zrale lu xe̱zr la xu ");
INSERT INTO zatNTps_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","lawe' da gunne̱ze̱', na' guca xe̱zr la xu. Gunná be'ene̱' na, na' zúaqueze na. ");
INSERT INTO zatNTps_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Xránadxu Dios dxune̱' dxexaca dácheze dizra' zaj nun bénneache xe̱zr la xu ca', ne dxune̱' dxelaca níteze da ca' zaj nune̱' xelune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Dizra' ba nun Xránadxu Dios tu súazqueze na chadía chacanna. Da dxegú'u be'e̱ lu lázrdawe̱' tu wadíazqueze na lau xúgute̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Ba neza zrente̱ naca na chee̱ benne' xe̱zr la xu ca' Xránadxu naque̱' Dios chee̱ le̱', benne' xe̱zr la xu ca' gucá'a Dios chee̱ xelaque̱' benne' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Naga zue̱' xabáa chee̱' dxenná' Xránadxu Dios, na' dxelé'ene̱' xúgute̱ cuen bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Naga zue̱' lataj lá'azxa chee̱' dxenné̱'e̱, na' dxelé'ene̱' ca zaj zra' bénneache lu xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Le̱' be̱ne̱' xichaj lázxdau xúgute̱ benne' ca', na' dxenné̱'e̱ xúgute̱ da dxelune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Quebe la benne' wenná bea ne̱ chee̱ benne' dxjaque̱' wedil-la zante̱ chee̱', ne quebe la benne' wal-la ne̱ chee̱ xel-la' wal-la da nape̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Quebe nu benne' le̱' ne̱ chee̱ bzrina', ne quebe nu la ne̱ chee̱ xel-la' wal-la zren chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Le na' xque, dxuxúe Xránadxu Dios benne' ca' dxelezrebe̱' Le̱'. Dxuxúe̱' benne' ca' dxelebeza lazre̱' Le̱' xexache lazre̱' le̱' ");
INSERT INTO zatNTps_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","chee̱ guselé̱' le̱' lu xel-la' gute, ne chee̱ gugawe̱' le̱' gate dxaca gubina'. ");
INSERT INTO zatNTps_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Dxebeza lázredxu Xránadxu Dios. Le̱' naque̱' Bénnea' dxácale̱ne̱' dxi'u, ne dxucu'uje̱' dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Chee̱ le̱ na' du lázredxu béle̱'e̱quezdxu lau Le̱', lawe' da tu dxuxrén lázrezquezdxu La lá'azxa chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Bexache lazre' netu', Xránantu', lawe' da dxebeza lázrentu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Tu güe lá'anazqueza' Xránadxu Dios te zra chizrela. Tu gúl-lazqueza' da güe lá'ana na Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Xezaca ba lázrele̱na' Xránadxu Dios. Xelén benne' dxexruj lazre' da caní, na' welebéle̱'e̱ne̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Le gucá'ana szren Xránadxu Dios tu zren nen neda', na' tu zren gucá'ana szrendxu La lá'azxa chie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Bláwizra' Xránadxu Dios, na' Le̱' benne̱' chia', ne bselé̱' neda' lu xúgute̱ da buluchebe na neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Benne' ca' gulebeza lazre̱' Le̱' belelé'ene̱' da xabáa chee̱', ne quebe belexedué'ene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Neda', benne' xache', bláwizra', na' ben Xránadxu Dios chia', ne bselé̱' neda' lu xúgute̱ da dxezaca zi'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Gubáz chee̱ Xránadxu zue̱' cuita benne' ca' dxelezrebe̱' Le̱', na' dxucu'uje̱' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Le guxúe xque, na' lé'ele naca xrlátaje Xránadxu Dios. Ba neza zrente̱ naca na chee̱ bénnea' dxuxrén lazre̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Le zrebe Xránadxu Dios, le'e, nácale benne' chee̱ Lé̱queze̱', lawe' da quee bi dxelexazrje benne' ca' dxelezrebe̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Be̱zre xíxre'du ca' dxelexázrjeba', ne dxeledunba'. Benne' ca' dxelebeza lazre̱' Xránadxu Dios quebe bi da chawe' xelexázrjene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Le da, bidau', ne le xen chia'. Gusé̱deda' le'e chee̱ zrébele Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","¿Nu benne' ládujla le'e dxaca lazre̱' xegá'ane̱' lu xel-la' nabán, bénnea' dxaca lazre̱' sue̱' zane' iza chee̱ lé'ene̱' da chawe'? ");
INSERT INTO zatNTps_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Bxue xanne' ca dxuchálaju' chee̱ quebe nneu' da cale̱la, ne chee̱ quebe guchálaju' da we̱n lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Bsan da cale̱la da dxunu', na' be̱n da xrlátaje. Be̱n ba xuzre gapu' xel-la' dxebeza zri lazre', ne be̱n ca naca chee̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Dxuxúe Xránadxu Dios benne' ca' zaj naque̱' xrlátaje, ne dxuzé̱ nague̱' da dxululáwizre̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Dxezrá'a Xránadxu Dios benne' ca' dxelune̱' da cale̱la, chee̱ quebe sua nu benne' chajsá lazre̱' benne' we̱n da cale̱la ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Benne' xrlátaje ca' dxululáwizre̱' Xránadxu Dios, na' Le̱' dxenne̱' chee̱', ne dxuselé̱' benne' ca' lu xúgute̱ da dxelezaca zi'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Gágute̱ zua Xránadxu Dios naga zaj zra' benne' ca' dxelexewi'ine lazre̱', ne dxuselé̱' benne' ca' dxelexewi'ine lazre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Da zante̱ da dxezaca zi' benne' xrlátaje. Dxuselá Xránadxu Dios bénnea' lu xúgute̱ da ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Le̱' dxuxúequeze̱' xúgute̱ zrita xu'e̱, na' netú zrita chee̱' quebe gachaj na. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Dul-la da dxun benne' we̱n da cale̱la gute na le̱', na' xelebía xi' benne' ca' dxelecuídene̱' benne' xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Xránadxu Dios dxexá'awe̱' bénne'du xu'u benne' we̱n zrin chee̱' ca', na' xúgute̱ benne' ca' dxuluxrén lazre̱' Le̱' québequeze xelebía xi'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Xran, bsizre benne' ca' dxelenné̱' chia'. Gudíl-lale̱ benne' ca' dxeledíl-lale̱ne̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Gudá gucu'uju' neda' lu wedil-la, ne gúcale̱ neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Gude̱l-la xia chee̱ wedil-la chee̱ guzagu' benne' ca' dxululague̱' neda'. Guzre neda' nacu' Benne' dxuselé̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Be̱n xelexedué'e, ne xeleque zréaje benne' ca' dxelaca lazre̱' xelútie̱' neda'. Be̱n xuluzrunnuj, ne xelexedué'e benne' ca' dxelaca lazre̱' xelune̱' chia' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Be̱n xelaque̱' ca tu xizre be̱be da dxua be', ne gusel-la gubáz chee̱ xabáa chiu' chee̱ gulague̱' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Be̱n chul-la neza naga xeledée̱', na' gaca na naga xelebile̱', ne gusel-la gubáz chee̱ xabáa chiu' chee̱ gulague̱' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Bulucache̱' tu xralaj chee̱ que̱la na neda', ne quegá bi nuna' chee̱'. Gule̱ne̱' tu xe̱dxu naga cheajcházia' neda', ne quegá bi de̱ da dxagu na zria chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Gusel-la da guzría xi na benne' ca', ne quebe xeleque be'ene̱'. Be̱n que̱la xralaj chee̱' na' lé̱queze̱', ne cheajlecházie̱' naga xelebía xi'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Nadxa béle̱'e̱quezda' ca naca da nun Xránadxu Dios. Sua' lu da ba neza lawe' da bselé̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Xúgute̱ zrita xu'a xelenná na: Xran, ¿núzraqueze naca ca nacu' Lue'? Dxuseláu' benne' xache' lu na' benne' wál-ladxa ca le̱', ne benne' dxexazrje lu na' benne' dxebane̱' da du de̱ chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Belasa benne' dxelexeche̱be̱' da we̱n lazre'. Gulawe̱' zria neda' chee̱ tu da quebe dxaca be'eda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Belexebi'e̱ neda' da cale̱la chee̱ tu da xrlátaje da be̱na', chee̱ xuluzúe̱' neda' lu da ba xa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Neda', gate quebe chawe' gulezúe̱', bewi'ine lazra'. Be̱na' gubasa da bsaca zi na neda', ne du lazra' bláwizra' Dios chee̱ xexune̱' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Bewi'ine lazra' chee̱ benne' ca' ca dxuna' chee̱ le sa' ljwezra', u chee̱ bi bíchequeza'. Guzúa' lu da baxache' ca dxun benne' chee̱ xrne̱'e̱ gate dxatie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Gulebé benne' ca' gate zua' lu da ba xa', ne belezrague̱'. Belezraga benne' dxeledábague̱' neda', benne' we̱n da cale̱la, na' chadite̱ gule̱l-le̱' neda'. Tu belúezqueze̱' neda', ne quebe gulezúa zrie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Bulusaca zi'e̱ neda', ne belún le̱' chia', ne gulagu lazxe̱' lu xel-la' dxelezrá'a chee̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Xran, ¿ájate̱ scha' gu'u latja da dxelune̱'? Bselá neda' lu na' benne' caní dxuluzría xi'e̱ neda', benne' zaj naque̱' ca be̱zre xixre' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Xapa' Lue': Xcalenu', láwela benne' zan ca' zaj nadupe̱' chiu' Lue'. Tu güe lá'anazqueza' Lue' ládujla benne' zan ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Quebe gu'u lataj xelebé benne' ca' dxeledábague̱' neda', ne quebe bi nuna' chee̱'. Quebe gu'u lataj xelún la benne' ca' chia', benne' dxelecuídene̱' neda', ne quebe bi de̱ da dxagu na zria chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Benne' caní quebe dxelaca lazre̱' xelezúe̱' lu xel-la' dxebeza zri lazre', na' lu xel-la' dxelezí xe̱ chee̱' dxelenné̱' chee̱ benne' ca' dxelebeza zri lazre̱' lu xe̱zr la xu nigá. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Belún le̱' chia'. Gulenné̱': “¡E! ¡E! ¡Ba blé'entu' da nune̱'!” ");
INSERT INTO zatNTps_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","¡Xran, ba blé'equeznu' da dxelune̱'! ¡Quebe sua zriu'! ¡Xran, quebe gusanu' neda'! ");
INSERT INTO zatNTps_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","¡Guxasa, guzúa guchi'u chia'! ¡Gudá, Xrana' Dios, chee̱ gácale̱nu' neda'! ");
INSERT INTO zatNTps_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","¡Bchi'a chia' lu da xrlátaje chiu', Xrana' Dios! ¡Quebe gu'u benne' ca' lataj xuluzrizre̱' chia'! ");
INSERT INTO zatNTps_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","¡Quebe gu'u lataj xelenné̱': “Ba guca da dxezá lázredxu!” ¡Quebe xelenné̱': “Ba bendxu chie̱'!” ");
INSERT INTO zatNTps_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Be̱n xelexedué'e, ne xeleque zréaje xúgute̱ benne' ca' dxelebene̱' gate bi dxaca chia'. Bsi'e̱ xel-la' stu', ne be̱n xelaca xala benne' ca' dxeledábague̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Be̱n xelúl-la, ne xelebé benne' ca' zaj de̱'e̱ neda', chee̱ xelennáqueze̱': “Tu xegá'ana szrénzqueze Xránadxu, Bénnea' dxezá lazre̱' sua lu xel-la' dxebeza zri lazre' benne' we̱n zrin chee̱'!” ");
INSERT INTO zatNTps_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Tu guchálajzqueza' chee̱ da xrlátaje chiu', ne chee̱ da dxue lá'anaqueze na Lue' te zra chizrela. ");
INSERT INTO zatNTps_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Da zrinnaj da dxun benne' dxuzúa chalá'ala Dios dxuchálajle̱ na le̱' lu xichaj lázrdawe̱'. Quebe dxezá lázrequeze̱' gape̱' Dios ba lá'ana. ");
INSERT INTO zatNTps_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Chee̱ le̱ na' dxulé'e cuine̱' ca tu benne' zrente̱. Dxéquene̱' quebe dxelé'e Dios da zrinnaj da dxune̱', ne quebe dxecuide Dios le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Da tu dxuchálajzqueze̱' naca na da zrinnaj, ne da we̱n lazre'. Québedxa dxéajni'ine̱', ne québedxa dxune̱' da xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Dxulaba lazre̱' ca naca da cale̱la gune̱' gate de̱' naga dxate'. Xu'e̱ neza da quebe naca neza chawe'. Quebe dxecuídene̱' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Xrana' Dios, zrente̱ naca xel-la' dxexache lazre' chiu' da dxezrinte̱ na xabáa, na' dxezrinte̱ lu beuj xel-la' li lazre' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Da xrlátaje chiu' naca na ca tu xi'a zren chiu', na' ca dxuchi'u naca na ca tu nísadau' sítujte̱. Xrana' Dios, tu dxuxúezquezu' bénneache, ne be̱ xixre' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Xrdante̱ naca xel-la' dxexache lazre' chiu', Dios. Chee̱ le̱ na' dxuluxrén lazre' bénneache Lue' ca dxelún bedxuj dxé'enedu ca' dxelexezraba' zran xrila bedxuj. ");
INSERT INTO zatNTps_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Welélajquezne̱' chee̱ da de̱le̱'e̱ lizru', na' Lue' gunézruju' xelé'aje̱' da naca ca tu xe̱gu da naca na da dxezaca ba lazru' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Naga zu' Lue' zua beaj naga dxalaj nisa da dxunna na xel-la' nabán. Lu xel-la' naxaní' chiu' walé'entu' da naca lení'. ");
INSERT INTO zatNTps_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Bexache lazre' benne' ca' zaj núnbe'e̱ Lue', ne bzua chee̱ benne' li lazre' ca' da xrlátaje chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Quebe gu'u lataj tábaga benne' dxucá'ana szren cuina neda', ne quebe gutá benne' dxun da cale̱la neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Xeajlechaze benne' ca' dxelune̱' da zrinnaj. Lue' be̱nu' xeajlechaze benne' ca', na' quebe gaca xelexase̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Quebe su' ste̱be ne̱ chee̱ da dxelún benne' ca' dxelune̱' da cale̱la, ne quebe se̱ lazru' da zaj nápale̱'e̱ benne' dxelune̱' da zrinnaj, ");
INSERT INTO zatNTps_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","lawe' da xeledé chee̱ benne' ca' ca dxaca chee̱ xíxre'du ca', na' gaca chee̱ benne' ca' ca dxaca chee̱ xixre' da nadxugu, dxebizre na. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Bxren lazre' Xránadxu Dios, ne be̱n da xrlátaje, na' súaquezu' lu xe̱zr la xu, ne sí'quezu' ba neza da li. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Bezaca ba lazre' nen Xránadxu, na' Le̱' gúnnaqueze̱' chiu' da dxezá lazru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Bzua cuinu' lu na' Xránadxu, ne bxren lazre' Le̱', na' Le̱' gune̱' ca da dxenabu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Gulé'ene̱' da xrlátaje chiu' ca tu xel-la' naxaní', ne da li lazre' chiu' ca lawe' zra. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Guzúa zrize lau Xránadxu, ne guleza lazre Le̱'. Quebe su' ste̱be ne̱ chee̱ benne' dxezi'e̱ ba neza, bénnea' dxúnqueze̱' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Bsan xel-la' xichaj zra'a, ne quebe cuídenu'. Quebe sa lazru' bi xusacu' benne' ca' dxelune̱' da cale̱la, ");
INSERT INTO zatNTps_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","lawe' da guzría xi' Dios benne' ca' dxelune̱' da cale̱la. Benne' ca' dxelebeza lazre̱' Xránadxu, gaca chee̱' xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Chadite te chee̱ benne' ca' dxelune̱' da cale̱la. Le'enu' lizre lataj benne' ca', san québedxa zaj zre̱'e̱ na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Benne' dxexruj lazre' ca' gaca chee̱' xe̱zr la xu, na' xelexezaca ba lazre̱' lu xel-la' dxebeza zri lazre' zrente̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Benne' dxelún da cale̱la dxelilaj lazre̱' bi xelune̱' chee̱ benne' xrlátaje, ne lu xel-la' dxelezrá'a chee̱' xelagu lazxa benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Xránadxu Dios guzrízrequeze̱' chee̱ benne' ca' dxelune̱' da cale̱la lawe' da nézene̱' ba za zra cheajsé̱ chee̱ benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Benne' dxelune̱' da zrinnaj dxelebéaje̱' xia chee̱', ne dxuluzé̱' xaga nalá xéche'ze chee̱', chee̱ xuluzría xi'e̱ benne' xache' ca', ne benne' dxelexazrje̱', chee̱ xelútie̱' benne' ca' dxelune̱' da li lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Xia nalá chee̱ benne' ca' chaze na lu lazrdáuqueze̱', na' gáchajqueze xaga nalá xéche'ze chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Cháwedxa naca da du da de̱ chee̱ benne' xrlátaje ca da gunní'a da zaj napa zánete̱ benne' dul-la ca', ");
INSERT INTO zatNTps_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","lawe' da welátequeze ni'a na' benne' dxelúne̱' da zrinnaj. Xránadxu ná'queze dxuxúe̱' benne' xrlátaje ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Nunbea Xránadxu ca zaj naca zra xelezúa benne' du lazre' ca', na' da zaj napa benne' ca' xelezúa na chadía chacanna. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Quebe xelexedué'ene̱' gate quebe dxaca chawe' chee̱ bénneache, na' lu zra chee̱ gubina' gata' da xelawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Xelebía xi' benne' dxelúne̱' da zrinnaj, na' benne' ca' dxeledábaga' Xránadxu, ca dxaca chee̱ xiaj xixre' ca'. Xeledé chee̱', ne xelexenitie̱' ca zren chee̱ xi'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Benne' ca' dxelún da cale̱la tu da dxelenabe̱' tu chí'idauze, ne quebe dxuluxunézruje̱' na, na' benne' xrlátaje dxexache lazre̱' le̱', ne dxunézruje̱' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Benne' ca' dxelé'e Xránadxu le̱' chawe', gaca chee̱ benne' ca' xe̱zr la xu, na' benne' ca' quebe dxelé'ene̱' chawe', xelebía xí'queze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Da dxelún benne' xrlátaje ca' zaj naca na da ble'e Xránadxu le̱', na' dxelé'ene̱' cháwedau' ca da dxelune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Gate dxeleajchaze benne' xrlátaje ca' quebe cheajlechaze̱' tu chi'ize lawe' da nuxru Xránadxu na' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Benne' cuide' guca', ne na'a ba gúxrua', ne cabata' ble'eda' tu benne' xrlátaje gusán Dios le̱', na' quebe xeledá zri'ine zre sue̱' xelebéaje̱' guna'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Benne' xrlátaje nigá tu dxexache lázrezqueze̱', ne dxunézruje̱' bi dxexazrje nu benne', na' zri'ine zre sue̱' zaj naque̱' da ba neza chee̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Québedxa gunu' da cale̱la, san be̱n da xrlátaje, na' gaca bánquezu' chadía chacanna, ");
INSERT INTO zatNTps_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","lawe' da nazrí'i Xránadxu da naca li lazre', ne quebe dxusane̱' benne' zaj de̱'e̱ Le̱'. Chadía chacanna tu guxúezqueze̱' benne' ca', san guzría xi'e̱ xrtia ljwezre benne' ca' dxelune̱' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Benne' xrlátaje ca' gaca chee̱' xe̱zr la xu nigá, na' xelezrá'queze̱' chadía chacanna lu xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Benne' xrlátaje dxuchálajqueze̱' da naca sina, na' ca dxuchi'e̱ naca na xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Da nadxixruj bea Dios tu xú'uzqueze na xichaj lázrdawe̱'. Chee̱ le̱ na' quebe cheajchaze bénnea'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Benne' we̱n da zrinnaj dxenné̱'e̱ benne' xrlátaje, ne dxune̱' ba xuzre gutie̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Quebe gusán Xránadxu le̱' lu na' benne' we̱n da cale̱la na', ne quebe guzría xi'e̱ le̱' gate dxuchi'e̱ chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Guleza lazre' Xránadxu, ne be̱n ca da ba gunné̱', na' Le̱' chísaqueze̱' Lue' chee̱ gaca chiu' xe̱zr la xu nigá. Gate xelebía xi' benne' dul-la ca', na' lé'enu' na. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Ble'eda' tu benne' we̱n da zrinnaj, nagá'ane̱' szrente̱, na' guxánle̱'e̱ da de̱ chee̱' ca dxegula tu xaga zrente̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Na' gudé chee̱', na' québedxa zue̱' na'a. Bexílaja' le̱', san quebe nu bezrelda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Blaba lazre' ca naca chee̱ benne' li lazre', ne gunná' benne' xrlátaje lawe' da naga cheajsé̱ gaca tu da ba neza chee̱ benne' dxebeze̱' zri lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Benne' dxelune̱' da cale̱la xelebía xí'queze̱'. Quebe nu cha' xrtia ljwezre benne' dxelune̱' da zrinnaj. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Xránadxu Dios guseláquezé̱' benne' xrlátaje ca', na' Le̱' gutipe̱' lazre' benne' ca' lu zra chee̱ da ste̱be. ");
INSERT INTO zatNTps_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Xránadxu Dios gácale̱ne̱' le̱', ne guselé̱' le̱'. Guselé̱' le̱' lu na' benne' ca' dxelune̱' da cale̱la, na' gune̱' gaca chawe' chee̱' lawe' da buluxrén lazre̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Xrana' Dios, quebe til-lu' neda' lu xel-la' dxezrá'a chiu'. Quebe gudéu' neda' da ba xa' lu xel-la' snia chiu', ");
INSERT INTO zatNTps_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","lawe' da belúe xaga nalá xéche'ze chiu' neda', na' be̱ na'u neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Quebe bi chawe' zua be̱la' dxen chia' lawe' da dxezra'u neda', ne quebe zaj zua zrita xu'a cháwedau' lawe' da nuna' dul-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Ca naca da zrinnaj da nuna' ba zria cháqueze na xíchaja'. Zaj naca na chia' ca tu xua' zí'ile̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","We̱' da zaj zria be̱l-la' dxen chia' ba dxelelá na, ne ba dxeluzru na, da na' dxaca chia' lawe' da be̱na' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Nucache lawa', ne dxexedué'ele̱'e̱da', ne dxebezre xacha' te zra chizrela, ");
INSERT INTO zatNTps_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","lawe' da ca naca be̱l-la' dxen chia' dxelá na, ne quebe bi chawe' zua be̱la' dxen chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Nate ni'a na'a, ne dxéqueda' ba naxúzrujne zrita xu'a. Dxebezre lazra' lawe' da zua ste̱be lázrdawa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Xran, ca naca da dxezá lazra' zaj zua na nen Lue', na' da dxebezre lazra' dxelé'equeznu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Dxate̱ lázrdawa', ne ba bedú lazra', ne québedxa dxelé'eda' cháwedau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Dxelexebiga ljwezra', ne le sa' ljwezra' ca' zítu'la ne̱ chee̱ xízrawe̱' chia', na' benne' walízr chia' ba belexecuase̱' zítu'la. ");
INSERT INTO zatNTps_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Benne' ca' dxelaca lazre̱' xelútie̱' neda' dxuluzale̱' xralaj, na' benne' ca' dxelúe lazre̱' bi gaca chia' dxelenné̱' chia' wabía xi'a, ne tu zaj zúaze̱' bi xulusaque̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Neda' quebe dxenda' ca dxaca chee̱ tu benne' cuezru, ne naca' ca tu benne' quebe dxaca nne̱', benne' quebe dxexrá dxu'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Naca' ca tu benne' quebe dxenne̱', bénnea' quebe dxexeche̱be̱', ");
INSERT INTO zatNTps_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","lawe' da dxebeza lazra' Lue', Xrana' Dios. Lue' xeche̱bu' waláz chia', Xrana' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Gunnia': Quebe gu'u lataj xelebene̱' ne̱ chee̱ da dxaca chia'. Gate dxeajchazia', quebe gu'u le̱' lataj xulucá'ana szren cuine̱' lawe' da zua' lu da baxache'. ");
INSERT INTO zatNTps_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Ba zua' cheajcházia', ne tu dxelázqueze dute̱ be̱l-la' dxen chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Chee̱ le̱ na' xrúale̱pequeza' da cale̱la da be̱na', ne xewine lazra' ca naca dul-la da nabaga'. ");
INSERT INTO zatNTps_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Benne' ca' dxeledábague̱' neda' zaj zúaqueze̱' chawe', ne zaj naque̱' benne' wal-la. Zaj naxánle̱'e̱ benne' ca' dxelecuídene̱' neda', ne quebe bi de̱ da dxagu na zria chia' lau le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Benne' ca' dxelune̱' da cale̱la chee̱ benne' ca' dxelune̱' da xrlátaje zaj naque̱' benne' dxeledábague̱' neda' lawe' da tu dxúnzqueza' da xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Quebe gusanu' neda', Xrana' Dios. Dios chia', quebe su' zitu' naga zua'. ");
INSERT INTO zatNTps_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Be̱n ba xuzre gácale̱nu' neda', Xran. Nacu' Benne' dxuselé̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Neda' gunnía': Guxúe xanne' cuina' chee̱ quebe guna' dul-la lu da guchálaja'. Tu guxúe xánnezqueza' ca da guchálaja' dxácate̱ na' zua benne' we̱n da cale̱la naga zua'. ");
INSERT INTO zatNTps_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Guzúa' zrize ca tu benne' quebe dxaca nnie̱', ne québequeze bchálaja' da xrlátaje, na' bzáladxa xel-la' dxudía chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Guca lázrdawa' ca tu da dxala, na' lu da dxulaba lazra' guca na ca tu xi'. Na' gunaba' lau Xránadxu, gunnía': ");
INSERT INTO zatNTps_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","Xran, ble'e neda' da gaca chia', ne ájate̱ zra gaca bana'. Bzéajni'i neda' chadite̱ nazruzre gatia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Nunu' chia' sua' bábaze zra, na' iza chia' québequeze bi naca na lau Lue'. ¡Da líqueze quebe bi zaj naca zra chee̱ xúgute̱ bénneache! ");
INSERT INTO zatNTps_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","¡Da líqueze zaj naca bénneache ca tu zrúl-laze! ¡Da líqueze dácheze naca zaj dxe' bénneache gunne xue chee̱ xel-la' nabán chee̱'! ¡Dxulucúdie̱' xel-la' gunní'a, ne quebe zaj nézene̱' nu chee̱ gaca na! ");
INSERT INTO zatNTps_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Na'a, Xran, ¿bízraqueze cueza lazra'? Tuzu' Lue' dxal-la' cueza lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Bselá neda' lu xúgute̱ da zrinnaj da be̱na'. Quebe gu'u lataj benne' xala ca' xelún le̱' chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Guzúa' zrize, ne quebe bi bchálaja' lawe' da Lué'queze be̱nu' guca caní chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Becá'a xízrawe̱' da bzu' lu be̱la' dxen chia'. Bache gatia' lu da dxusacu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Dxudéu' ba xa' tu benne' ba nun dul-la chee̱ dxuzéajni'inu' le̱', ne ca dxun béadu dxuteba' ladxe' dxuzría xi'u da nazrí'idxe bénnea'. ¡Da líqueze quebe bi zaj naca zra chee̱ xúgute̱ bénneache! ");
INSERT INTO zatNTps_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Bene da dxenaba' lau Lue', Xran, ne bze̱ naga ca da dxuláwizra' Lue'. Quebe su' zrize gate zua' dxebezra' lau' lawe' da naca' lau Lue' ca tu benne' dxedaze̱', ne quebe de̱ lizre̱', ne naca' ca tu benne' quebe de̱ xe̱zr la xu chee̱' ca gulaca xra xrtawa' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Bsan neda' chee̱ gata' lataj xezí' le dipa' nédxula ca xexá'a xenitia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Nen dute̱ xel-la' zren lazre' chia' guleza lazra' Xrana' Dios, na' bze̱ nague̱' chia', ne benne̱' da gunábeda' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Bebéaje̱' neda' ca tu lu xe̱dxu situj, ne lu da naca ca guna' guzra'. Bzue̱' ni'a ca tu lu xiaj xre, ne begu'e̱ neda' neza li. ");
INSERT INTO zatNTps_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Be̱ne̱' dxul-la' tu da cube da naca na da dxue lá'ana' Xránadxu. Benne' zante̱ xelelé'ene̱' da nigá dxune̱', na' xelezrebe̱' Le̱', ne xuluxrén lazre̱' Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Ba neza zrente̱ naca na chee̱ bénnea' dxuxrén lazre̱' Xránadxu Dios, ne quebe dxune̱' ca dxelún benne' ca' dxulucá'ana szrene̱' bedáu' xiaj xaga ca', ne quegá ca dxelún benne' ca' dxelún lazre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Da zante̱ be̱nu', Xrana' Dios, da dxebánentu', ne ca zaj naca da dxezá lazru' gunu' chee̱ntu' quebe gaca gulábantu' lau Lue'. Chela nu guzenda' ca zaj naca na, ne che guchálaja' chee̱ na, quebe baben tu na. ");
INSERT INTO zatNTps_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Quebe dxezaca ba lazru' béadu ca' gutia' lau', u da gunna' Lue', ne quebe gunabu' béadu ca' guzézxea' lau', u dxen chee̱ béadu ca' da guzúa' lau' ne̱ chee̱ dula nabaga', san gusálaju' naga' chee̱ xenda' chi'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Nadxa gunnía': Guná' xque, za'a neda'. Lu xiche lá'azxa naxúaj na ca naca chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Dxezaca ba lazra' guna' ca da dxaca lazru' Lue', Dios chia', na' da nadxixruj be'u zua na lu xichaj lázrdawa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Ca naca da xrlátaje chiu' ba bzenda' bénneache naga zaj nazraga chiu' bénneache zante̱. Gunná' xque, quebe guzúa zria', ca nézqueznu' Lue', Xrana' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Quebe bcácheza' ca da xrlátaje chiu' lu lázrdawa'. Ba bchálajqueza' ca naca xel-la' li lazre' chiu', ne ca dxuseláu' bénneache. Quebe guzúa' zri ca naca xel-la' dxexache lazre' chiu', ne ca naca da li chiu' ládujla benne' zante̱ zaj nazrague̱' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Xran, quebe chenu' xexache lazru' neda'. Xel-la' dxexache lazre' chiu', ne da li chiu' tu dxelácale̱zqueze na neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Lawe' da ba guléchajle̱'e̱ da cale̱la ca' neda', da cale̱la ca' da ba nuna' zaj zria na neda', na' quebe gaca nna'a naga zu'. Zaj naxándxa na ca zaj naca xicha xíchaja', na' dxedú lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Dxenaba' lau', Xran, guseláu' neda'. Xran, be̱n ba xuzre gácale̱nu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Be̱n xelexedué'e, ne xeleque zréaje xúgute̱ benne' ca' dxelaca lazre̱' xelútie̱' neda'. Be̱n xeajxaca bzé̱bela, ne xelexedué'e benne' ca' dxelezá lazre̱' xelune̱' chia' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Be̱n xeleque zréaje̱' lawe' da belún zréaje̱' neda' benne' ca' gulé̱'e̱ neda': “E, e.” ");
INSERT INTO zatNTps_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Be̱n xelebé, ne xelezúe lu da ba neza xúgute̱ benne' ca' dxelebeze̱' Lue', ne be̱n xelennáqueze benne' ca' zaj nazrí'ine̱' Lue', weselá chee̱'. Xelenné̱': “Xegá'ana szrénqueze Xránadxu.” ");
INSERT INTO zatNTps_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Láqueze sua' neda' lu da ba xa', ne lu da baxache', guxúequeze Xrana' Dios ájala gune̱' chia'. Nacu' Benne' dxácale̱ne̱' neda', ne Benne' weselá chia'. Dios chia', quebe chenu' gácale̱nu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Ba neza zrente̱ naca na chee̱ bénnea' dxe'e̱ gunne xue chee̱ benne' xache'. Lu zra gate zue̱' lu da ste̱be, guselá Xránadxu bénnea'. ");
INSERT INTO zatNTps_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Xránadxu guxúequeze̱' le̱', ne gunézruje̱' le̱' xel-la' nabán. Gaca na tu da ba neza zrente̱ chee̱ bénnea' lu xe̱zr la xu nigá, na' quebe gudé Xránadxu le̱' lu na' benne' ca' dxeledábague̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Xránadxu Dios gúxruqueze̱' le̱' gate zúe̱' lu xel-la' dxudía. Gun chawe̱' dute̱ da naque̱' gate na' quebe chawe' zue̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Gunnía': Xrana' Dios, bexache lazre' neda'. Bexún bénne'du xu'a lawe' da be̱na' dul-la gate gudábaga' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Benne' ca' dxeledábague̱' neda' dxelenné̱' chia' da cale̱la. Dxelenne̱': “¿Bátala gate benne' nigá, ne xenite le̱'?” ");
INSERT INTO zatNTps_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Che xedajlenné̱'e̱ neda', dxelún lazre̱'. Dxelebéaje̱' neda' dizra' chee̱ bi da cale̱la gaca xelenné̱' chia', na' gate dxelexedxúaje̱', na' dxelexrúe̱' dizra' na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Gate dxelezraga benne' dxelecuídene̱' neda', na' tu dxelenné̱zqueze̱' chia'. Tu dxuluchálajle̱zqueze̱' ljwezre̱' chia' neda' da naca da cale̱la, dxelenné̱': ");
INSERT INTO zatNTps_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","“Ba guxú'e̱ tu xízrawe̱' da gute na le̱', ne québedxa xexásaqueze̱' ga na' de̱'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Cá'anqueze bénnea' guleza zri lazre' nen neda', bénnea' bxren lazra', na' gudágule̱queze̱' neda', benne' nigá dxedábagazegue̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Lue', Xrana' Dios, bexache lazre' neda', ne be̱n xexasa' neda', na' xunézruja' benne' ca' ca da dxal-la' xelezí'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Caníqueze nezda' ba be̱na' da dxezaca ba lazru' Lue', chee̱ quebe bi xelebéle̱ benne' ca' dxeledábague̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Ca naca chia' neda', ba bé̱xruquezu' neda' lawe' da naca' du lazre', ne ba bzu' neda' lau Lue' chadía chacanna. ");
INSERT INTO zatNTps_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","¡Gaca ba Xránadxu, Dios chee̱ benne' Israel ca' gaxuane iza, ne chadía chacanna! ¡Ca'an naca na, ne ca'an gaca na! ");
INSERT INTO zatNTps_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Ca dxun bzrina' xixre' dxebezre xa'aba' lawe' da dxebíleba' nisa, ca' dxuláwizra bénne'du xu'a da naca chiu', Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Dxebile bénne'du xu'a da naca chiu', Dios ban. ¿Bata gaca xida' chee̱ guzúa cuina' lau Dios? ");
INSERT INTO zatNTps_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Nisa xuzru xiaj lawa' guca na ca xeta dxawa' te zra chizrela, dxácate̱ na' gulé̱'e̱ neda' xúgute̱ zra: “¿Ga na' Dios chiu'?” ");
INSERT INTO zatNTps_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Dxajsá lazra' chee̱ da caní, ne dxebezre lazra'. Dxajsá lazra' ca guxá'ale̱na' benne' zan ca', ne nuzúa' lawe' le̱' lizre Dios. Tu dxúl-lazquezdxu lu xel-la' dxebé, ne dxue lá'anaquezdxu Dios lu laní. ");
INSERT INTO zatNTps_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","¿Bizr chee̱ na' dxate ni'a na'u, bénne'du xu'a? ¿Bizr chee̱ na' zu' ste̱be lu xichaj lázrdawa'? Guleza lazre' Dios lawe' da güe lá'anaqueza' Le̱' da xula. Naque̱' Benne' dxuselé̱' neda', ne Dios chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Dios chia', ba nate ni'a na' bénne'du xu'a lu xichaj lázrdawa'. Chee̱ le̱ na' dxajsá lazra' chiu' nigá zua' lu xe̱zr la xu xechalá'a xe̱gu Jordán, ne lu xe̱zr la xu chee̱ benne' Hermón naga zua xi'a Mizar. ");
INSERT INTO zatNTps_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Ca schaga da dxun nísadau', ne da dxun tu bdua nisa zren chiu', Dios, ca' dxeque bénne'du xu'a lawe' da dxusaca zi' na'u neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Te zra xexache lazre' Xránadxu neda', na' chizrela tu gúl-lazqueza' da güe lá'ana' Le̱', ne tu guchálajle̱zqueza' Dios, Bénnea' dxunne̱' xel-la' nabán chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Xapa' Dios: Lué'queze dxucu'uju' neda'. ¿Bizr chee̱ na' nal-la lazru' neda'? ¿Bizr chee̱ na' dxewí'ine lazra' lawe' da dxusaca zi' benne' dxedábague̱' neda'? ");
INSERT INTO zatNTps_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Ca tu benne' dxelé̱'e̱ zrita xu'a, ca' dxelún benne' ca' chia', dxelún le̱' chia'. Tu zra tu zra dxelenné̱' chia': “¿Ga na' Dios chiu'?” ");
INSERT INTO zatNTps_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","¿Bizr chee̱ na' dxate ni'a na'u, bénne'du xu'a? ¿Bizr chee̱ na' zu' ste̱be lu xichaj lázrdawa'? Guleza lazre' Dios lawe' da güe lá'anaqueza' Le̱' da xula. Naque̱' Benne' dxuselé̱' neda', ne Dios chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Bchi'a chia', Dios, ne ble'e lau naca' xrlátaje. Bselá neda' lu na' benne' ca' dxuluzúe̱' Lue' chalá'ala, ne lu na' benne' ca' dxelezí xe̱'e̱, ne dxelune̱' da zrinnaj. ");
INSERT INTO zatNTps_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Nacu' Lue' Dios chia', ne dxuzé̱ chuchu' neda'. ¿Bizr chee̱ na' nusán lazru' neda'? ¿Bizr chee̱ na' dxewí'ine lazra' lawe' da dxusaca zi' neda' benne' ca' dxeledábague̱' neda'? ");
INSERT INTO zatNTps_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Gusel-la chia' xel-la' naxaní' chiu', ne da li chiu'. Da caní xulusí na neda' neza. Xeleché̱ na neda' lu xi'a lá'azxa chiu', ne naga zúaquezu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Chu'a naga zua lucugu chee̱ Dios. Chu'a lau Dios, Bénnea' dxune̱' dxebeda', na' zua' lu da ba neza. Güe lá'ana' Lue' nen da zríadi'i na du, Dios chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","¿Bizr chee̱ na' dxate ni'a na'u, bénne'du xu'a? ¿Bizr chee̱ na' zu' ste̱be lu xichaj lázrdawa'? Guleza lazre' Dios lawe' da güe lá'anaqueza' Le̱' da xula. Naque̱' Benne' dxuselé̱' neda', ne Dios chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Dios, bache bénentu' lawe' da buluzén Xra xrtáuntu' netu' ca naca da be̱nu' lu zra chee̱', da naca na iza ba guledé na. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Bzria xi'u bénneache xe̱zr la xu xezícadxa ca' lau xra xrtauntu' ca', na' bzu' le̱' xlataj benne' ca'. Bsaca zi'u benne' xe̱zr la xu ca', san bzua chachu' bénneache chiu' lu xe̱zr la xu nigá. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Xra xrtáuntu' ca' quebe gulezi'e̱ xe̱zr la xu nigá nen xia nalá cheé̱queze̱', Ne quebe buluselá cuine̱' nen xel-la' wal-la da zaj nape̱'. Lue' bseláuquezu' le̱' nen xel-la' waca chiu', ne nen xel-la' wal-la chiu', ne nen xel-la' naxaní' chiu', lawe' da bezaca ba lazru' nen le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Dios, nacu' wenná bea chia'. Bselá zri'ine zre sua Jacob. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Nen xel-la' waca chiu' xebéajntu' benne' ca' dxeledábague̱' netu'. Lu Lau' Lue' guchuchuj guléajntu' benne' ca' dxeledábague̱' netu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Quebe guxrén lazra' xaga nalá xéche'ze chia', ne quebe guselá xia chia' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Lue' bcu'uju' netu' lau benne' ca' dxeledábague̱' netu', ne be̱nu' belexedué'e benne' ca' belecuídene̱' netu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Ne̱ chee̱ Dios tu súazquezentu' lu da ba neza, na' chadía chacanna güe lá'anantu' Lau' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Nusán lazru' netu', ne nunu' dxexedué'entu', ne quebe dxéajle̱nu' benne' chee̱ntu' ca' dxjaque̱' wedil-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Be̱nu' buzrúnnujntu' lau benne' ca' dxeledábague̱' netu', na' benne' ca' dxelecuídene̱' netu' gulegüe̱' ca naca da nápantu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Bdeu' netu' ca zrila' ca' lu na' benne' xelútie̱' netu', ne ba be̱se dínnaju' netu' ládujla benne' xe̱zr la xu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Bdéu' netu', benne' chiu' ca' cá'aze, ne quebe bi guzi'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Dxunu' dxelún la benne' walízre chee̱ntu'. Benne' zaj naxéchaje̱' netu' dxelún le̱', ne dxuluzrizre̱' chee̱ntu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Nuzú' netu' ca tu da dxelenná benne' xe̱zr la xu ca' naca na da baxáchele̱'e̱. Xúgute̱ benne' dxelelé'ene̱' netu' dxulutá xíchaje̱', ne dxelexebánene̱' ca da baxache' nácantu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Tu zra tu zra tu dxexedué'ezquezda', ne tu zúazqueza' lu da sté̱bele̱'e̱ ");
INSERT INTO zatNTps_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","lawe' da dxelenné̱' schanni' chia', ne dxuluzúe̱' neda' chalá'ala, ne dxulutíl-lale̱ neda' benne' ca' dxeledábague̱' neda', nen benne' ca' dxelexebeaj lazre̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Xúgute̱ da caní dxaca chee̱ntu', ne quebe ne gal-la lazrentu' Lue', ne quebe ne guzúantu' chalá'ala xel-la' wezría chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Quebe ne gusán lázrentu' Lue', ne quebe ne xecuásantu' lu da gunná be'enu' netu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","¿Bizr chee̱ na' nuzú' netu' chalá'ala tu lataj chee̱ be̱ snia ca', ne nuzú' netu' naga xelaze gátentu'? ");
INSERT INTO zatNTps_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","La gul-la lázrentu' La Dios chee̱dxu, ne bca'ana szrentu' tu dios da quebe bi zaca, ");
INSERT INTO zatNTps_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","¿quebe dxal-la' zra'a Dios netu' ne̱ chee̱ da nigá? Le̱' nézquezne̱' da zaj zua lu xichaj lázxdau bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Lawe' da nácantu' chiu', tu zra tu zra ba zaj zúatequeze̱' xelútie̱' netu'. Zaj nune̱' netu' ca zrila' ca' ba zua xelútie̱'-ba'. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","¡Bebán, Xran! ¿Bizr chee̱ na' dxasiu'? ¡Bebán! ¡Quebe su' zitu' tu chi'ize! ");
INSERT INTO zatNTps_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","¿Bizr chee̱ na' nucache cuinu', ne quebe dxeque be'enu' ca dxezaca zí'intu', ne ca dxuluchine benne' ca' netu'? ");
INSERT INTO zatNTps_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Ba nate ni'a na' bénne'du xú'untu', ne dxeajcházete̱ntu' lu xu, na' ba dé̱te̱ntu' sudxú'ala lu xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","¡Guxasa, gúcale̱ netu', ne dute̱ xel-la' dxexache lazre' chiu', bselá netu'! ");
INSERT INTO zatNTps_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Xu'u lázrdawa' tu dizra' xrtante̱, na' gúl-laqueza' tu da naca chee̱ Wenná Bea. Gúl-laqueza' tu da bzuaj tu benne' dxuchálajle̱'e̱ cháwedau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Nacu' xrtánle̱'e̱dxa ca xúgute̱ bénneache. Dxezíle̱'e̱ntu' ba neza chee̱ dizra' dxuchálaju', lawe' da nucá'anaqueze Dios Lue' cháwedau' tu chí'izqueze. ");
INSERT INTO zatNTps_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Bda' xia chiu' dxu'a le̱'u, Lue', benne' wal-la, lu dute̱ xel-la' szren chiu', ne xel-la' dxenná bea chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Lu xel-la' szren chiu' chepe bánquezu'. Bchine dizra' li, ne xel-la' dxexruj lazre', ne da xrlátaje, na' guzéajni'i Cuinu' da zri'a ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Zaj nalále̱'e̱ xaga nalá xéche'ze chiu' ca', da xelute na benne' xe̱zr la xu ca' lau Lue', ne cheajlechaze na lu lázrdau benne' ca' dxeledábague̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Lataj blau naga dxe'u, Dios, naca na da chadía chacanna, ne súatequeze na. ¡Xrlátaje naca ca dxenná be'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Nazri'inu' da naca xrlátaje, ne dxecuídenu' da cale̱la. Chee̱ le̱ na' ba nuzúa Dios chiu' Lue' xlátaju', naga dxebéle̱'e̱dxenu' ca le sa' ljwezru' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Dxelá zixre zra lanu' nen xala da naca na nizre xaga, ne xiaj, da ca' dxelelá na zixre. Lu xu'u lizru' da zácale̱'e̱ na dxuluzúe̱' Lue' lu da ba neza. ");
INSERT INTO zatNTps_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Bi nu'ula chee̱ wenná bea ca' zaj zúabe' ládujla nu'ula chiu' ca' zaj naque̱' blaudxa. Chalá'a xabe̱la chiu' dxe' nu'ula gácabe' zru'ulu' nácube' oro da za na xe̱zre Ofir. ");
INSERT INTO zatNTps_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Bene, nú'uladau', ne gunná' xque, ne bze̱ naga da nnia': Bzala lazru' lazriu' ne lizre xrau', ");
INSERT INTO zatNTps_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","na' benne' wenná bea sa lazre̱' xel-la' xrtan chiu'. Bzexruj lazru' lau le̱' lawe' da naca le̱' xranu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Xelelá' nu'ula xe̱zre Tiro lau lue', zaj nu'e̱ da xelunne̱' chiu', na' xelenaba benne' gunní'a ca' gunu' tu culuén chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Xrtanle̱'e̱ naca bi nu'ula chee̱ wenná bea lu xu'u naga zue̱'. Zra lánabe' nazí' lechítaje̱ na oro. ");
INSERT INTO zatNTps_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Xeleché̱'e̱-be' lau wenná bea, nácube' zra lánabe' da núale̱'e̱ lechítaje̱ na. Nu'ula wégu'du ca' chjácabe' cuzru le̱be'. Nu'ula caní, nu'ula ljwézrebe' xuluzúabe' lawe' lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Lu dute̱ xel-la' dxebé, ne lu da ba neza xeleché̱'e̱-be', na' xelú'ube' lu xu'u lizru', wenná bea. ");
INSERT INTO zatNTps_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Waláz chee̱ xra xrna'u xelexezúa zri'inu', bi ca' gunu' xelenná beabe' du gabí'i xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Guna' cheajlesá lazre' xúgute̱ bénneache lau' lue'. Chee̱ le̱ na' xelúe lá'ana bénneache lue' chadía chacanna, ne gaxuane iza. ");
INSERT INTO zatNTps_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Dios naque̱' Benne' dxuxúe̱' dxi'u, ne dxune̱' dxi'u benne' wal-la. Zúate̱queze̱' gácale̱ne̱' dxi'u gate dxededxu xel-la' zi'. ");
INSERT INTO zatNTps_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Chee̱ le̱ na', quebe zrébedxu lácala xru' xe̱zr la xu nigá na' cheajlechaze xi'a ca' lu nísadau', ");
INSERT INTO zatNTps_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","ne lácala xeajxruza zren chee̱ nísadau' xuluninne na, ne dxelúnle̱'e̱ na schaga, na' welezrízequeze xi'a ca' ne̱ chee̱ da dxezrú'. ");
INSERT INTO zatNTps_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","De̱ tu xe̱gu da dxunna na xel-la' dxebé lu xe̱zre chee̱ Dios, ne lu xu'u lá'azxa chee̱ Dios, Benne' nape̱' dute̱ xel-la' szren. ");
INSERT INTO zatNTps_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Dios zue̱' xe̱zre na', ne cabata' cuía xi na. Dxaní'sise̱' xide̱' gácale̱ne̱' bénneache zaj zre̱'e̱ xe̱zre na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Dxelezrébele̱'e̱ benne' xe̱zr la xu ca', na' dxelezrize benne' chee̱ wenná bea ca'. Dxenné̱ Dios ca dxenné̱ guziu', na' dxexuna xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Dios, Bénnea' nape̱' dute̱ xel-la' waca, zúale̱ne̱' dxi'u. Dios na' chee̱ Jacob dxucache chawe̱' dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Le da lé'ele da ca' nun Xránadxu. Le nna' ca naca da dxebánedxu da nune̱' lu xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Dxebeque zrie̱' wedil-la da dxelaca du gabí'i xe̱zr la xu. Dxuzúzruje̱' da dxuzala na xaga nalá xéche'ze ca', ne dxíchuje̱' xaga tuche' ca' chee̱ wedil-la, na' dxuzezxe̱' da ca' zaj nache̱' benne' wedil-la ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Dxenná Dios: “Le sua zrize, ne le xúnbea naca' Dios. Naca' szrendxa ca zaj naca xúgute̱ cue' xe̱zr la xu. Naca' szrendxa ca dute̱ xe̱zr la xu.” ");
INSERT INTO zatNTps_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Dios, Bénnea' nape̱' dute̱ xel-la' waca, zúale̱ne̱' dxi'u. Dios na' chee̱ Jacob dxucache chawe̱' dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","¡Le capa na'le, le'e, xúgute̱ bénneache! ¡Le güe lá'ana Dios nen dute̱ xel-la' dxebé! ");
INSERT INTO zatNTps_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Dxal-la' zrébedxu Xránadxu, nape̱' dute̱ xel-la' szren. Naque̱' Wenná Bea zren dxenná bé'ene̱' dute̱ xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Bzue̱' benne' xe̱zr ca' zran ní'adxu. Bzue̱' dxi'u chee̱ nna be'edxu zánete̱ cue' xe̱zr la xu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Bequé̱'e̱ tu xe̱zr la xu da gaca na chee̱dxu, Da naca tu xe̱zr la xu xrtante̱ chee̱ zri'ine zre sua Jacob, benne' ca' nazrí'ine̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Dxegüén Dios naga dxe'e̱ dxenná be'e̱. Dxelebezre luzu da dxulucuezre̱' gate dxegüén Xránadxu ga na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","¡Le gul-la da gaca ba Dios! ¡Le gul-la! ¡Le gul-la da gaca ba Wenná Bea chee̱dxu! ¡Le gul-la! ");
INSERT INTO zatNTps_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","¡Dios naque̱' Wenná Bea dute̱ lu xe̱zr la xu nigá! ¡Le gul-la chee̱' nen dute̱ xel-la' dxéajni'i chee̱le! ");
INSERT INTO zatNTps_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Dxe' Dios naga dxenná be'e̱, lu lataj na' naca na lá'azxa. Dxenná bé'ene̱' xúgute̱ cue' xe̱zr la xu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Dxelezraga benne' dxelenná bé'ene̱' xúgute̱ cue' xe̱zr la xu tu zren nen bénneache chee̱ Dios chee̱ Abraham. ");
INSERT INTO zatNTps_vpl VALUES ("PS47_10","020_47_10","PSA","47","10","10","Benne' ca' dxelenná be'e̱ du gabí'i xe̱zr la xu buludée̱' xel-la' dxenná bea chee̱' lu na' Dios. Le̱' dxenná bé'ene̱' xúgute̱ benne' wenná bea ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","¡Zrente̱ naca Xránadxu! ¡Naca chee̱' güe lá'anale̱'e̱dxu Le̱' ga naca lu xe̱zre chee̱ Dios chee̱dxu, da dxe' na lu xi'a lá'azxa chee̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Sión, da naca na xi'a chee̱ Dios, naca na sibe, ne xrtante̱. Naca na xe̱zre chee̱ Wenná Bea zrente̱, da dxunna na xel-la' dxebé dute̱ xe̱zr la xu nigá. ");
INSERT INTO zatNTps_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Dios ba blé'ene̱' dxucache chawe̱' dxi'u, lu xu'u zaca ca' chee̱ xe̱zre chee̱' na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Belezraga benne' wenná bea ca', na' belelé̱'e̱ chee̱ xeledíl-lale̱ne̱' xe̱zre nigá, ");
INSERT INTO zatNTps_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","na' gate belelé'ene̱' na, na' belexebánene̱'. Belezrébe̱', na' buluzrúnnuje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Gulezré̱'e̱ lu da ste̱be, ne gulezúe̱' xel-la' dxudía ca dxaca chee̱ tu nu'ula ba zua sane̱' bidau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Gulaque̱' ca da ca' dxeledá lawe' nísadau' dxexrite na gate dxácale̱'e be' bdunu' lu nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Bendxu ca da be̱n Dios, na' na'a ba ble'edxu na, ga naca lu xe̱zre chee̱ Xránadxu, nape̱' dute̱ xel-la' waca, da naca na xe̱zre chee̱ Xránadxu Dios. Le̱' guzúa chawe̱' xe̱zre nigá chadía chacanna. ");
INSERT INTO zatNTps_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Ga naca lu xudau' chiu' Lue', Dios dxajsá lázredxu ca naca xel-la' zri'i lazre' zren chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Gátete̱ze na' dxelúe lá'ana bénneache Lue', na' ca naca xel-la' szren chiu' dxezrín na du gabí'i xe̱zr la xu. Ca naca da xrlátaje dxenná be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Xelebéle̱'e̱ bénneache zaj zre̱'e̱ Sión. Xelebéle̱'e̱ bénneache zaj zre̱'e̱ xe̱zre ca' chee̱ Judá ne̱ chee̱ da dxuchi'u chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Le'e, bénneache chee̱ Dios, le chechaj dxu'a xe̱zre na', ne le gulaba ca zaj naca xu'u sibe ca', da dxuluzé̱ chacha na xe̱zre na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Le nna' xque ca naca ze'e zren naxechaj na xe̱zre na'. Le nna' xanne' ca zaj naca xu'u wal-la chee̱ na, chee̱ guzenle bi chee̱le ca naca xe̱zre na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Dios nigá nácaqueze̱' Dios chee̱dxu chadía chacanna. Le̱' tu gulé'ezquezne̱' dxi'u neza. ");
INSERT INTO zatNTps_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Le xen da nigá, le'e, benne' xúgute̱ cue' xe̱zr la xu. Le guzé̱ nágale, le'e, benne' dute̱ xe̱zr la xu, ");
INSERT INTO zatNTps_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","le'e, benne' blau, ne le'e, benne' xezícadxa, le'e, benne' gunní'a, ne le'e, benne' xache'. ");
INSERT INTO zatNTps_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Guchálajqueza' xel-la' sina, ne guzéajni'ida' le'e da xu'u lázrdawa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Guzé̱ naga' tu dizra' sina. Gúl-laqueza' chee̱ tu da nagache, ne quinnia' da zríadi'i na du che̱n. ");
INSERT INTO zatNTps_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","¿Bizr chee̱ na' dxun na ba xen zreba' lu zra chee̱ da ste̱be, gate naxechaj da cale̱la neda' da dxelún benne' dxeledábague̱' neda'? ");
INSERT INTO zatNTps_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Benne' ca' dxuluxrén lazre̱' da zaj de̱ chee̱', ne dxulucá'ana szren cuine̱' lawe' da zaj nápale̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Quebe xelezéquene̱' xelexá'awe̱' le sa' ljwezre̱', ne quebe gaca xulunézruje̱' Dios da guselá na le̱' ");
INSERT INTO zatNTps_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","9","chee̱ tu xelaca bánzqueze̱', ne chee̱ cabata' xeluzru be̱l-la' dxen chee̱' lawe' da zrente̱ naca da dxexa'u na xel-la' nabán chee̱ bénneache, ne cabata' seque' nu benne' quízruje̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Xelelé'ene̱' dxelátequeze benne' sina ca', ne xelúzrue̱' cáte̱ze dxaca chee̱ benne' xala ca', ne chee̱ benne' lázrdau zide' ca', na' dxulucá'ane̱' xel-la' gunní'a chee̱' lu na' benne' xula ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Dxeléquene̱' wazráqueze zri'ine zre sue̱' chadía chacanna, na' xelexegá'ana lizre̱' chee̱ xelaca na chee̱ xúgute̱ cuen xrtia ljwezre̱', na' dxelu'e̱ la xe̱zr la xu chee̱' ca' ca zaj nazí láqueze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Quebe xelexegá'anatequeze bénneache lu da ba lá'ana. Zaj naque̱' ca be̱ xixre' ca', be̱ dxeláteba'. ");
INSERT INTO zatNTps_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Ca da dxelune̱' naca na da xálaze, na' dxelexezaca ba lazre' xrtia ljwezre̱' ca' nen da dxelennaze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Zaj naque̱' ca tu cue' zrila' zjácaba' lataj ba xa', naga guxúe xel-la' gute le̱ba'. Benne' xrlátaje ca' xelenná bé'ene̱' benne' gunní'a ca' gate za' chaní', na' xelebía xi' da ca' guta' chee̱', na' lataj ba xa' gaca na naga tu xelezúazqueze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Dios xexá'awe̱' xel-la' nabán chia' lu lataj ba xa' lawe' da xeché̱'e̱ neda' naga zúaqueze̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Quebe su' ste̱be gate nu benne' dxezrué'ene̱' xel-la' gunní'a, ne gate dxune̱' lizre̱' da zácale̱'e̱dxa, ");
INSERT INTO zatNTps_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","lawe' da gate gatie̱' quebe bi xexu'e̱, ne quebe chéajle̱ xel-la' gunní'a chee̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Lácala dxácate̱ naca bane̱' dxe̱ cuine̱' zue̱' lu da ba neza zrente̱, na' dxelúe lá'ana bénneache le̱' gate dxe̱pe bane̱', ");
INSERT INTO zatNTps_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","san chu'e̱ naga zaj zra xra xrtawe̱' ca', ne cabátadxa lé'ene̱' xel-la' naxaní'. ");
INSERT INTO zatNTps_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Bénnea' dxelapa bénneache le̱' ba lá'ana san quebe bi dxéajni'ine̱' naque̱' ca be̱ xixre' ca', be̱ dxeláteba'. ");
INSERT INTO zatNTps_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Ba gunné̱ Xránadxu Dios, ne ba nutube̱' bénneache chee̱ dute̱ xe̱zr la xu, benne' zaj zre̱'e̱ naga dxalaj gubizra, ne benne' zaj zre̱'e̱ naga dxebía na. ");
INSERT INTO zatNTps_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Lu xi'a Sión, da naca na xrtánle̱'e̱ ba bzaní' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Xelá' Dios chee̱dxu, ne quebe sua zrie̱'. Gálajqueze xi' lau Le̱', ne gácale̱'e̱ be' bdunu' da chechaj na Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Xutúbequeze̱' benne' zaj zre̱'e̱ xabáa na'ala, ne benne' zaj zre̱'e̱ xe̱zr la xu, chee̱ guchi'e̱ chee̱ bénneache chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Dxenné̱': “Le xutube benne' chia' ca', benne' ca' belune̱' tu xel-la' wezría nen neda' da buluzúa chúchue̱' nen dxen chee̱ béadu ca'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Da zua xabáala gulé'e lau na naque̱' xrlátaje, lawe' da naca Dios Benne' guchi'e̱ chee̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Dxenné̱': “Le xen, bénneache chia', na' guchálaja'. Le guzé̱ nágale, benne' Israel, na' nnia' da gagu na zria chee̱le. Neda', Dios, naca' Dios chee̱le. ");
INSERT INTO zatNTps_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Quebe til-la' le'e ca naca béadu ca' bé̱tele lawa', ne ca naca béadu ca' bzézxele, da zaj zúaqueze na lawa' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Quebe ca'a lu na'ale me̱du ca', ne chivo biu ca', be̱ nápaquezle ");
INSERT INTO zatNTps_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","lawe' da zaj naca chia' xúgute̱ be̱ xixre' ca', ne zane gaxúa be̱ xixre' zaj zraba' lu xí'adu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Xu'u lu na'a xúgute̱ be̱ zua xrila, ne naca chia' xúgute̱ be̱ zaj naca banba'. ");
INSERT INTO zatNTps_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Chela neda' dxeduna', quebe xapa' le'e ca' lawe' da naca chia' xe̱zr la xu, ne xúgute̱ da de̱ lawe na. ");
INSERT INTO zatNTps_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","¿Dxun na ba xen gawa' be̱la' be̱zre ca'? ¿Xí'aja' dxen chee̱ chivo biu ca'? ");
INSERT INTO zatNTps_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Le guzúa lau Dios da güe lá'anale Le̱' ne le gunezruj ca da guche̱be lázrele lau Dios szrente̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Bláwizra neda' lu zra zu' lu da zi' da xa', na' guselá' lue', na' lue' gapu' neda' ba lá'ana.” ");
INSERT INTO zatNTps_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Dios guzre̱' benne' we̱n da cale̱la: “¿Bi dxéquenu' lue', dxuchálaju' ca nadxixruj bi'a, ne dxenníu' ca naca chee̱ xel-la' wezría chia'? ");
INSERT INTO zatNTps_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Lue' dxecuídenu' neda' che dxusízreda' lue', ne dxuzú' chalá'ala dizra' chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Gate dxelé'enu' gubán, na' dxunu' le̱' tu zren, ne nacu' tu zren benne' ca' dxeledále̱ne̱' nu'ula quebe zaj naca zru'ule̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Dxuchálajquezu' da cale̱la, ne tu dxúnzquezu' da we̱n lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Tu dxenné̱zquezu' da cale̱la chee̱ bi bíchequezu', Ne dxagu' zria chee̱ bi chee̱ xrná'aquezu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Da caní be̱nu', na' neda' guzúa' zrize. Gúquenu' naca' tu benne' ca nacu' lue'. Na'a wadíl-laqueza' lue', ne gulé'eda' lue' ca ba be̱nu'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Le chéajni'i da nigá na'a, le'e dxal-la lázrele Dios. Ga gaze guzuzruj Dios le'e, ne québedxa sua nu guselá le'e. ");
INSERT INTO zatNTps_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Bénnea' guzúe̱' lawa' da güe lá'ane̱' neda' gape̱' neda' ba lá'ana, na' bénnea' dxuxuchá cuine̱' chee̱ gune̱' da xrlátaje, gulé'eda' le̱' ca guselá' le̱', naca' Dios chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Gúcale̱ neda', Dios, lu dute̱ xel-la' dxexache lazre' chiu'. Dute̱ xel-la' dxexache lazre' chiu' bsula zria da nabaga'. ");
INSERT INTO zatNTps_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Gudibe neda' ca naca da cale̱la da nuna', ne bca'ana chawe' neda' chee̱ dul-la da be̱na', ");
INSERT INTO zatNTps_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","lawe' da dxexúnbe'a ca be̱na' gudábaga' Lue', ne ca naca dul-la chia' tu dxáguze na zria neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Lau' Lue' be̱na' dul-la. Awe', lau' Lué'queze, ne ba be̱na' da cale̱la lau' Lue'. Caní dxaca na chia' chee̱ gaca bea nacu' xrlátaje lu da dxenníu', ne nacu' du lazre' ca da dxuchi'u chee̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Gunná' xque, báchequeze nabaga' dul-la gate gúlajtea', ne lu dul-la zúaqueza' gate guzrán xrna'a neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Lue' dxezá lazru' sua da li lu xichaj lázrdawa', ne lu xichaj lázrdawa' ba bzéajni'inu' neda' da naca sina. ");
INSERT INTO zatNTps_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Bca'ana chawe' neda' nen da na' dxuchínenu', na' xegá'ana' xrlátaje. Gudibe neda', na' gaca' chíchedxa ca tu bezxe'. ");
INSERT INTO zatNTps_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Be̱n xenda' xel-la' dxebé, ne da ba neza, na' xelexezí' le dipa zrita xu'a, da ba gudíchaju'. ");
INSERT INTO zatNTps_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Quebe gusá lazru' ca naca dul-la da be̱na', na' bsula xúgute̱ da cale̱la da nuna'. ");
INSERT INTO zatNTps_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Dios, bzua neda' tu lázrdawa' xrlátaje, ne bzua tu be' li lazre' lu xichaj lázrdawa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Quebe gucuasu' neda' lau' Lue', ne quebe xeca'u lu xichaj lázrdawa' be' lá'azxa chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Bexunna neda' xel-la' dxebé chee̱ xel-la' weselá chiu', ne bzua chuchu be' chawe' da xu'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Nadxa gusé̱deda' benne' ca' dxelune̱' da zrinnaj ca dxaca lazru' xelune̱', na' benne' dul-la ca' xelexexaque̱' chiu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Bselá neda' lu zria da nabaga', be̱tia' benne'. Lue' Dios, nacu' Dios dxuseláu' neda', na' gúl-laqueza' chee̱ da xrlátaje nacu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Xran, gusalaj dxu'a, na' guzenda' bénneache da dxue lá'ana' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Quebe dxaca lazru' béadu ca' gutia'-ba' lau', ne quebe dxaca lazru' béadu ca' guzézxea' lau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Da guzúadxu lau Dios da dxaca lazre̱' naca na tu lázxdau dxexruj lazre'. Tu lázxdau dxexruj lazre', ne da dxexíaje lazre' quebe guzú' chalá'ala, Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Dute̱ xel-la' zri'i lazre' chiu', be̱n gaca chawe' chee̱ xe̱zre Sión. Bsegula ze'e da nazechaj na xe̱zre Jerusalén. ");
INSERT INTO zatNTps_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Nadxa xezaca ba lazru' nen béadu ca' gútentu' lau' dute̱ da naca xrlátaje chee̱ntu', ne béadu ca', ne da du ca' guzézxentu' lau'. Nadxa xelútie̱' béadu ca' lu cugu chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","¿Bizr chee̱ na' dxucá'ana szren cuinu' chee̱ da cale̱la da nunu', lue', benne' wal-la? Tu zúazqueze xel-la' dxexache lazre' chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Tu dxuchálajzquezu' chee̱ da cale̱la da gunu' chee̱ le sa' ljwezru'. Da dxenníu' naca na ca tu xia da nalále̱'e̱, dxezí xe̱'u ljwezru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Nazrí'idxenu' da cale̱la quézcala da xrlátaje, ne dxedánnedxenu' da we̱n lazre' quézcala da li. ");
INSERT INTO zatNTps_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Nazri'inu' xúgute̱ dizra' da dxulucá'ana ditaj na bénneache, lue', benne' dxezí xe̱'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Chee̱ le̱ na' guzría xi' Dios lue' tu chí'izqueze. Waxe̱le̱' lue', ne xequé̱'e̱ lue' naga zúaquezu', ne gucuase̱' lue' naga zaj zra' benne' ban ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Xelelé'e benne' xrlátaje ca' da nigá, na' xelezrébequeze̱'. Xuluzrízrqueze̱' chiu' lue', xelenné̱': ");
INSERT INTO zatNTps_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Le na' xque, benne' nigá quebe bxren lazre̱' Dios chee̱ gucu'uje̱' le̱'. Bxren lázrequeze̱' ca naca xel-la' gunní'a zrente̱ chee̱', ne guzúaqueze̱' lu da cale̱la da dxune̱'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Neda' naca' ca tu xaga olivo xa'a lu xu'u lizre Dios. Tu dxuxrén lázrezqueza' xel-la' dxexache lazre' chee̱ Dios chadía chacanna. ");
INSERT INTO zatNTps_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Güe lá'anaqueza' Lue' chadía chacanna lawe' da be̱nu' da caní, ne cueza lazra' lau Lue' lawe' da naca na xrlátaje lau xúgute̱ benne' chiu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Benne' xala ca' dxelenná lu lázrdawe̱': Quebe zua Dios. Xúgute̱' zaj naque̱' sban, ne zaj nune̱' da cale̱la. Quebe nu chilá' benne' dxune̱' da xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Dios zue̱' xabáa dxenné̱'e̱ bénneache chee̱ lé'ene̱' che zua tu benne' sina, bénnea' dxape̱' Dios ba lá'ana. ");
INSERT INTO zatNTps_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Xúgute̱ benne' zaj nabéaj xíchaje̱' Dios. Xúgute̱' zaj naque̱' sban. Quebe nu chilá' benne' dxune̱' da xrlátaje, netú gue̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Dxenná Dios: “¿Quebe dxeléajni'i benne' caní dxelune̱' da cale̱la? Dxele̱'aj dxelawe̱' da dxelebane̱' chee̱ bénneache chia', ne quebe dxelexílaje̱' neda'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Za zrin zra xelexruse̱' ca da quebe ne xelezaque̱', lawe' da gusedinnaj Dios zrita ca' chee̱ benne' guledábague̱' bénneache chee̱'. Dios na' nuzúe̱' chalá'ala benne' ca', na' bénneache chee̱' xuluzría xi'e̱ benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Dxenaba' Dios gune̱' dxuaj Sión da gácale̱ na benne' Israel ca'. Gate ba nun Dios xelezrín bénneache chee̱' lu xe̱zr la xu cheé̱queze̱', xelebé zri'ine zre sua Jacob, ne xelezúa lu da ba neza benne' Israel ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Bselá neda', Dios, nen xel-la' waca chiu'. Gúcale̱ neda', Dios, nen xel-la' wal-la chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Bene da dxenaba' lau', Dios, ne beche̱be chia'. Bze̱ naga da guchálajle̱na' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Za'aca benne' snia ca' xeledíl-lale̱ne̱' neda'. Benne' xichaj zra'a ca' dxelaca lazre̱' xelútie̱' neda', benne' ca' quebe dxelape̱' ba lá'ana Lue', Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Dios naque̱' Benne' dxácale̱ne̱' neda'. Xránadxu Dios zúale̱ne̱' benne' ca' dxuluxúe̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Ca naca da cale̱la dxelún benne' dxeledábague̱' neda', xuzrí'i Dios na chee̱ benne' ca'. Guzría xi'e̱ benne' ca' lawe' da naque̱' li lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Du lazra' cu'a da gudéa' lau Lue', Xran. Güe lá'anaqueza' Lau' lawe' da nácale̱'e̱ na xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Bseláu' neda' lu xúgute̱ da ste̱be guzúa'. Ble'eda' gulebía xi' benne' ca' dxeledábague̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Bze̱ naga, Xran, ca da dxuchálajle̱na' Lue', ne quebe guzú' chalá'ala ca da dxenaba' lau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Guzúa ban lazre', ne beche̱be chia'. Dxuláwizra' Lue' lu da dxuchálaja', ne zua' ste̱be, ");
INSERT INTO zatNTps_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","lawe' da benne' dxeledábague̱' neda' dxelenné̱' chia', ne lawe' da dxelún la benne' we̱n da cale̱la neda'. Bulusebague̱' neda' da zrinnaj, ne dute̱ xel-la' dxelezrá'a zaj nau zi' xuzre̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Dxe' gunne xue lázrdawa' lu be̱la' dxen chia', ne dxuchebe xel-la' gute neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Zua' lu xel-la' dxezrebe, ne dxezríztequeza', na' zúale̱ neda' da dxuchebe na neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Na' gunnía': ¿Nuzra gunna neda' xrila' ca xrila tu bsia chee̱ cha'a lu be'la naga xezí' lazra'? ");
INSERT INTO zatNTps_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Da líqueze guzrúnnuja' zítu'la, na' súaqueza' le̱'e̱ xixre' lawe' lataj. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Guna' ba xuzre la' lu be' bdunu', ne lu be' wal-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Bzria xi' benne' ca' dxelune̱' da cale̱la, Xran. Bzaga naze da dxelune̱', lawe' da ble'eda' da zrinnaj, ne da cale̱la da dxelune̱' lu xe̱zre. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Te zra chizrela dxeledé̱' lawe' ze'e da naxechaj na xe̱zre, ne dxelune̱' da zrinnaj, ne da cale̱la lu xe̱zre nigá. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Nazrate̱ xe̱zre nigá da cale̱la da dxelune̱', ne tu dxelúnzqueze̱' da we̱n lazre', ne xel-la' dxezí xe̱ lu neza chee̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","La guca tu benne' bénnea' dxedábague̱' neda', bénnea' be̱n le̱' chia', na' bchaga lawa' da na'. La guca tu benne' dxecuídene̱' neda' bénnea' gudábague' neda', na' bcache cuina' lau le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Lue', bénnea', gucu' ca tu le sa' ljwezra'. Bsi'u neda', ne gucu' tuze neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Tu zren bchálajdxu du lázredxu, ne lu xel-la' zri'i lazre' gudadxu lu xu'u lizre Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Dios, be̱n que̱la xel-la' gute benne' ca' dxelune̱' da cale̱la chadite̱. Be̱n xelexú'e̱ lu lataj ba xa' zaj naca bane̱', lawe' da nazrate̱ xu'u lizre̱' da cale̱la da dxelune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Ca naca chia' neda', bláwizra' Dios, na' Xrana' Dios bselé̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Che zílala, ne wagubizra, ne ca dxebía gubizra guchálajle̱queza' Dios, ne guláwizra' Le̱', na' Le̱' xenne̱' chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Xexá'awe̱' bénne'du xu'a lu wedil-la da dxaca chia' neda', ne gune̱' cueza' zri lazra', lácala zaj zra' zánete̱ benne' dxeledábague̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Wene Dios, na' guzría xí'queze̱' benne' ca'. Naque̱' Bénnea' zúatequeze̱' dxenná be'e̱ nédxute̱. Caní gune̱' chee̱ benne' ca' lawe' da quebe dxuluché̱'e̱ ca dxelune̱', ne quebe dxelezrebe̱' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Guchisa na' benne' we̱n da zrinnaj chee̱ gu'e̱ benne' ca' dxelebeza zri lazre̱' nen le̱'. Gudíchaje̱' xrba chee̱ xel-la' wezría da be̱ne̱' nen benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Dizra' bchálaje̱' zaj naca na dizra' zren lazre', san xu'u lázrdawe̱' xel-la' dxezrá'a. Dxune̱' xrtante̱ dizra' dxuchálaje̱', san zaj naca na ca xia da zaj nalále̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Bda xua chiu' cuzru Xránadxu, na' Le̱' gutipe̱' lazru'. Québequeze gu'e̱ lataj cheajchaze benne' chawe' tu chi'ize. ");
INSERT INTO zatNTps_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Lue', Dios, gunu' xelexú'u benne' ca' dxelune̱' da cale̱la lataj ba xa', benne' dxelute benne', ne benne' dxelezí xe̱'e̱, gate quebe ne xelezrine̱' gachaj catite dxal-la' xelaca bane̱', san neda' guxrén lazra' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Bexache lazre' neda', Dios, chee̱ quebe xuluzría xi' bénneache neda'. Tu zra tu zra dxulusaca zi' bénneache neda', benne' ca' dxeledíl-lale̱ne̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Te zra chizrela benne' ca' dxeledábague̱' neda' dxulucá'ana dítaje̱' neda', lawe' da zaj zra' benne' zante̱, benne' dxeledíl-lale̱ne̱' neda' lu xel-la' dxulucá'ana szren cuine̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Lu zra dxezreba', dxuxrén lazra' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","¡Dxuxrén lazra' Dios, na' güe lá'ana' xrtizre̱'! ¡Dxuxrén lazra' Dios, na' québedxa zreba'! ¿Bízraqueze gaca gun bénneache chia' neda'? ");
INSERT INTO zatNTps_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Xúgute̱ zra dxuluchuque̱' xrtizra'. Ca naca da dxelegú'u be'e̱ zaj naca na chee̱ xelune̱' chia' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Dxelezrague̱', ne dxulucache cuine̱'. Dxelenná' xánnie̱' ca da dxuna'. Dxelilaj lazre̱' ca xelune̱' xelútie̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Dios, bxue ca da dxelune̱', na' dute̱ xel-la' dxezrá'a chiu' bzria xi' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Nézqueznu' Lue' ca dxuzrúnnuja' lau benne' ca'. Bsa lazre' nisa da ba gudxezra'. ¿Quebe zaj naxúaj na lu xiche chiu'? ");
INSERT INTO zatNTps_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Gate dxuláwizra' Dios, lu zra ná'queze xuluxuzrunnuj benne' ca' dxeledábague̱' neda'. Nézquezda' zúale̱ Dios neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","¡Dxuxrén lazra' Dios, na' güe lá'ana' xrtizre̱'! ¡Dxuxrén lazra' Xránadxu, na' güe lá'ana' xrtizre̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","¡Dxuxrén lazra' Dios, na' québedxa zreba'! ¿Bízraqueze gaca gun bénneache chia' neda'? ");
INSERT INTO zatNTps_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Nabaga' ca da nache̱be lazra' chiu', Dios. Gúl-laqueza' da güe lá'ana' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Ba bseláu' bénne'du xu'a lu xel-la' gute, ne bebéaju' ni'a naga zaj zua cheajlechaze na, chee̱ gaca chu'a lau Dios lu xel-la' naxaní' da dxunne̱' chee̱ benne' ca' zaj naca bane̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Bexache lazre' neda', Dios. Bexache lazre' neda', lawe' da dxuxrén lazra' Lue' dute̱ lázrdawa'. Que̱zru' neda' ca dxun bedxuj dxé̱zreba' zrí'ineba' zran xrílaba', cadxa te chee̱ da ste̱be caní. ");
INSERT INTO zatNTps_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Guláwizra' Dios, Benne' zrente̱. Guláwizra' Dios chee̱ gácale̱ne̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Naga zúate̱' xabáa chee̱' sel-le̱' nu guselá neda' lu na' bénnea' dxáca lazre̱' guzría xi'e̱ neda'. Gusel-la Dios xel-la' dxexache lazre', ne da li chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Zua' lu da ste̱be ca tu benne' zue̱' ládujla be̱zre xixre' ca'. Xu'a ládujla bénneache zaj naque̱' ca be̱zre xixre' ca' dxeláguba' bénneache. Dizra' da dxelenné̱' chia' zaj naca na ca tu xia natuche', ne xaga nalá xéche'ze ca', na' xrtizre̱' zaj naca na ca tu xia da nalále̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Xega'ana szrénquezu' lu xabáa, Dios. Xel-la' szren chiu' sua na lawe' dute̱ xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Ba zaj nabeche̱' xralaj chee̱ xele̱l-le̱' neda'. Ba dxedú lazra' lu da dxaca chia'. Ba zaj naxe̱ne̱' tu xe̱dxu chee̱ cheajcházia' lu'ule na. Lu'ule da na' ba xeajlecházqueze le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Ba zúate̱queze lázrdawa', Dios. Ba zúate̱queze lázrdawa' chee̱ gúl-laqueza' da güe lá'ana' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Bebán lazre', bénne'du xu'a, ne le xebán lázrele, le'e dxínnele da dxúl-lale̱nle, ne da zríadi'i na du. Che zílala chásaqueza'. ");
INSERT INTO zatNTps_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Güe lá'anaqueza' Lue' ládujla bénneache chiu', Xran. Gúl-laqueza' chiu' lau benne' xúgute̱ cue' xe̱zr la xu, ");
INSERT INTO zatNTps_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","lawe' da naca xel-la' dxexache lazre' chiu' zrendxa ca xabáa, na' da li chiu' naca na zrendxa ca beuj bza ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Xegá'ana szrénquezu' lu xabáa, Dios. Xel-la' szren chiu' sua na lawe' dute̱ xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Le'e dxenná beale ¿da li dxuchálajle da naca xrlátaje? ¿Dxuchí'ale ca naca da li chee̱ bénneache chia'? ");
INSERT INTO zatNTps_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","¡Cabíze̱'! ¡Lu lázrdaule dxugú'u beale da zrinnaj! ¡Sté̱bele̱'e̱ dxuzúale bénneache lu xe̱zr la xu chia'! ");
INSERT INTO zatNTps_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Zaj nazrinnaj lázxdau benne' ca' zaj nabéaj xíchaje̱' neda' gate gulálajte̱'. Belexase dínnaje̱' dxelún lazre̱' gate gulezante̱ xrne̱'e̱ le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Dizra' da dxelenné̱' zaj naca na da dxelute bénneache ca da zria zran lazxa be̱la'. Zaj naca na ca be̱la' snia, be̱ nácaba' be̱ cuezru. ");
INSERT INTO zatNTps_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","Quebe dxenba' chi'i benne' dxunné̱' le̱ba' lácala dxenné̱le̱'e̱ xrtandau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Dios, gudichaj lazxa benne' ca'. Gudichaj, Xran, lazxa benne' ca' zaj naque̱' ca be̱zre xixre' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Be̱n xelexenítie̱' ca nisa da dxelalaj na lu xu. Gate dxulusane̱' xaga nalá xéche'ze chee̱', be̱n xeledé na chalá'ala. ");
INSERT INTO zatNTps_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Be̱n xeledé chee̱' ca dxaca chee̱ be̱ zaga dxelexexúnaba'. Be̱n québedxa xelelé'ene̱' gubizra ca tu bidau' dxálajbe' ba nátebe'. ");
INSERT INTO zatNTps_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Nédxula gate quebe ne la xesu' lu xi' xecá'a Dios benne' ca' tu lu be' bdunu', benne' zaj naca bane̱', ne benne' ca' zaj zua xelatie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Wabé benne' xrlátaje gate lé'ene̱' xebéaj lazre' Dios benne' ca' dxelune̱' da cale̱la. Guchuchu guléaje̱' dxen chee̱ benne' zaj nabéaj xíchaje̱' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Nadxa nne̱ bénnea': “Da líqueze de̱ lazruj chee̱ benne' xrlátaje. Da líqueze zua Dios, Bénnea' dxuchi'e̱ chee̱ bénneache zaj zre̱'e̱ lu xe̱zr la xu.” ");
INSERT INTO zatNTps_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Bselá neda' lu na' benne' ca' dxeledábague̱' neda', Dios chia'. Bselá neda' lu na' benne' ca' dxelune̱' chia' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Bselá neda' lu na' benne' ca' dxelune̱' da zrinnaj. Bselá neda' lu na' benne' ca' dxelutie̱' benne', ");
INSERT INTO zatNTps_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","lawe' da dxelilaj lazre̱' xelútie̱' neda'. Zaj nazraga benne' wal-la ca' chee̱ xeledíl-lale̱ne̱' neda', quegá lawe' da bi zria nabaga', ne quegá ne̱ chee̱ dul-la nuna' neda', Xran. ");
INSERT INTO zatNTps_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Lácala quebe bi be̱na' chee̱ benne' ca', zá'aca chégüe̱', ne dxulucueze̱' bi xelune̱' chia'. Bebán chee̱ xidu' naga zua', na' le'enu' da dxelune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Lue', Xran, Dios chee̱ benne' zan dxjaque̱' wedil-la, ne Dios chee̱ benne' Israel ca', bebán chee̱ gudéu' ba xa' benne' xúgute̱ cue' xe̱zr la xu. Quebe xexache lazru' xúgute̱ benne' ca' dxeledábague̱' Lue', ne dxelune̱' da zrinnaj. ");
INSERT INTO zatNTps_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Xelelé̱'e̱ gate cuía gubizra, ne xelebezre xe̱'e̱ ca dxelún becu', na' xeléchaje̱' xe̱zre. ");
INSERT INTO zatNTps_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Gunná' xque, da dxuluchálaje̱' naca na ca da dxelexexe̱be̱'. Dizra' dxelenné̱' zaj naca na ca xia zaj nalá na, lawe' da dxelenné̱': “¿Nuzra xene?” ");
INSERT INTO zatNTps_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Lue', Xran, guzrizru' chee̱ benne' ca'. Gun lau' chee̱ benne' xúgute̱ cue' xe̱zr la xu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Zaj naca wal-la benne' ca' dxeledábague̱' neda'. Cueza lazra' Lue' lawe' da dxucu'uju' neda', Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Dios, Bénnea' dxexache lazre̱' neda', cuía lawe̱' lawa' neda'. Dios gune̱' le'eda' gaca chee̱ benne' ca' dxeledábague̱' neda' ca da dxezá lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Quebe gutiu' benne' ca', chee̱ quebe xelal-la lazre' bénneache chia' ca da gunu'. Be̱se dinnaj benne' ca' nen xel-la' waca chiu'. Lue', Xran, Benne' dxucu'uj netu', ben cheajlecházie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Be̱n xeledule̱' lu xel-la' dxulucá'ana szren cuine̱', ne̱ chee̱ dul-la dxelune̱' lu da dxuluchálaje̱', ne ne̱ chee̱ dizra' schanni', ne da we̱n lazre' da dxelenné̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Bzria xi'e̱ lu xel-la' dxezrá'a chiu'. Bzria xi'e̱ chee̱ québedxa xelezúe̱'. Dios, be̱n xeleque be'ene̱' dxenná be'enu' zri'ine zre sua Jacob. Dxenná be'u du ca naca xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Dxelelé̱'e̱ gate dxebía gubizra, ne dxelebezre xe̱'e̱ ca dxelún becu', ne dxeléchaje̱' xe̱zre. ");
INSERT INTO zatNTps_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Dxeledé̱' ca benne' dxeledaze̱', dxelílaje̱' da xelawe̱', na' che quebe dxeléljane̱', na' du xe̱la dxelawe̱' zria tue̱' xetúe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Neda' gúl-laqueza' chee̱ xel-la' waca chiu', na' che zílala güe lá'ana' xel-la' dxexache lazre' chiu', lawe' da gúcale̱nu' Lué'queze neda', ne bcu'uju' neda' gate guzúa' lu da sté̱bele̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Lue' dxutipu' lazra', na' gúl-laqueza' chiu', lawe' da nacu' Lue', Dios, Bénnea' dxucu'uje̱' neda', ne Dios, dxexache lazru' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Dios, Lue' ba bzu' netu' chalá'ala, ne be̱nu' xeajcházentu'. Bzrá'ale̱'e̱nu' netu'. Na'a bedá gácale̱nu' netu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Be̱nu' guzrú' xe̱zr la xu, ne be̱nu' bxalaj na. Bexún na naga bxalaj na lawe' da dxebía xi na. ");
INSERT INTO zatNTps_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Be̱nu' blé'entu' netu', benne' chiu', da naca sté̱bele̱'e̱. Be̱nu' guca chee̱ntu' ca güé'entu' tu da be̱n na xeajcházentu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Bnézruju' tu da dxulé'e lau chee̱ benne' dxelezrebe̱' Lue', Da xeluxre̱' chee̱ gulé'e lau da naca li. ");
INSERT INTO zatNTps_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Chee̱ xelelá benne' ca' nazrí'iqueznu' Lue', bsel-la le̱' dute̱ xel-la' waca chiu', ne bene chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Dios gunné̱' lu lataj lá'azxa chee̱': “Wabéquezda' neda'. Gunna' late weaj chee̱le xe̱zr la xu chee̱ benne' Siquem, ne gudxixra' chee̱le xe̱zr la xu de̱ cuita xe̱gu Sucot. ");
INSERT INTO zatNTps_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Chia' naca xe̱zr la xu Galaad, ne chia' naca xe̱zr la xu chee̱ zri'ine zre sua Manasés. Xe̱zr la xu chee̱ zri'ine zre sua Efraín naca na ca tu da napa chi'i na xíchaja'. Xe̱zr la xu chee̱ zri'ine zre sua Judá naca na naga dxenná be'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Xe̱zr la xu chee̱ benne' Moab naca na ca tu zriga' da xuzru nisa guná'a, na' xe̱zr la xu chee̱ benne' Edom guchichan' nen zrela'. Si'a ba neza xe̱zr la xu chee̱ benne' Filistea.” ");
INSERT INTO zatNTps_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","¿Nuzra che̱' neda' chee̱ guzétaja' xe̱zre da naxechaj na ze'e sibe? ¿Nuzra che̱' neda' chee̱ guzétaja' benne' Edom ca'? ");
INSERT INTO zatNTps_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","¿Quegá Lue' na' che̱'u neda', Dios, nacu' Bénnea' bzue' netu' chalá'ala, ne quebe guxeájle̱nu' benne' chee̱ntu' ca', benne' dxjaque' wedil-la? ");
INSERT INTO zatNTps_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Gúcale̱ netu' chee̱ séquentu' tíl-lale̱ntu' benne' ca' dxeledíl-lale̱ne̱' netu', lawe' da naca dácheze xelácale̱ bénneache netu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Tu zren nen Dios gundxu tu da zrente̱, na' Le̱' gulague̱' benne' ca' dxeledíl-lale̱ne̱' dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Bene, Dios, da dxuláwizra' Lue'. Bze̱ naga da dxuchálajle̱na' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Zitu' naga zua lazria' dxuláwizra' Lue', lawe' da dxedú lazra'. Guché̱' neda' naga zua Bénnea' naque̱' ca tu xi'a xiaj, Bénnea' nácadxe̱' szren ca neda', ");
INSERT INTO zatNTps_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Nacu' Lue' Benne' nuxrue̱' neda', ne nacu' ca tu ze'e xiaj da dxucu'uj na neda' lau benne' ca' dxeledábague̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Tu súazqueza' lu xu'u lá'azxa chiu'. Sua chawa'a cuitu' Lue' ca zaj zua chawe' bedxuj dxé'enedu ca' zran xrila bedxuj. ");
INSERT INTO zatNTps_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Lawe' da bennu' Lue', Dios, ca da guche̱be lazra' chiu', be̱nu' napa' ca da dxelapa benne' ca' dxelezrebe̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Gunu' gaca bana' neda', wenná bea, zánete̱ zra. Iza chia' xelaca na ca da zaj naca chee̱ chupa cuen bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Tu súazqueza' lau', Dios. Bcueza xel-la' dxexache lazre' chiu', ne da li chee̱ xulucá'ana chawe' na neda', wenná bea. ");
INSERT INTO zatNTps_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Caníqueze gúl-laqueza' chee̱ lau' tu chí'izqueze, ne gúnqueza' tu zra tu zra ca da guche̱be lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Tuze nen Dios dxebeza zri lazre' bénne'du xu'a. Lé̱queze̱' dxuselé̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Tuze Le̱' dxucu'uje̱' neda', ne dxuselé̱' neda'. Naque̱' Bénnea' dxuxre̱' neda', na' quebe negue lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","¿Ajate̱zcha' gucuézale da gunle chee̱ tu benne', na' dxunle ba xen xúgute̱le guzría xile le̱', ca dxun tu benne' dxuchínnaje̱' tu ze'e da ba de̱ chalá'ala, u tu le'aj da ba guzru'? ");
INSERT INTO zatNTps_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Dxunle tuze dizra' ájazra xebéajle neda' lu xel-la' szren chia'. Nazrí'ile da we̱n lazre'. Nen dxú'ale dxenne̱le da xrlátaje, san xu'u lázrdaule da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Lue', bénne'du xu'a, guleza lazre' tuze Dios, lawe' da naca Le̱' Bénnea' dxebeza lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Tuze Le̱' dxucu'uje̱' neda', ne dxuselé̱' neda'. Naque̱' Bénnea' dxuxre̱' neda', na' quebe negue lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Naca Dios Bénnea' dxuselé̱' neda', ne naque̱' da ba neza chia'. Naca Dios Bénnea' dxucu'uje̱' neda', ne Benne' dxuxre̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Le cueza lazre' Le̱' tu chí'izqueze, le'e, bénneache. Le xe̱'e̱ ca da dxezá lázrele. Naca Dios Bénnea' dxuxre̱' dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Da líqueze, da dácheze zaj naca bénneache, ne ca tu da we̱n lazre' benne' zren ca'. Quebe bi dxelé̱'e̱ tu lu zrgú'unsa. Zaj nácadxe̱' zraze ca tu be' da dxecá'a lázredxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Quebe guxrén lázrele da sile gate dxexúbele, ne quebe gucá'ana szren cuínale chee̱ da ca' dxebanle. Che dxegula xel-la' gunní'a chee̱le, quebe xezaca ba lázrele chee̱ da na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Tu lásaze gunná Dios: na' chupa lasa benda' da nigá: Chee̱ Dios naca xel-la' waca. ");
INSERT INTO zatNTps_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","Chiu' Lue', Xran, naca xel-la' dxexache lazre' lawe' da dxunézruju' lazruj chee̱ tu tu bénneache cáte̱ze da zaj nune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","2","Dios, Lue' nacu' Dios chia'. Dxebile bénne'du xu'a da naca chiu', na' be̱la' dxen chia' dxezá lazre' na da naca chiu'. Naca chia' ca zúaqueza' tu xe̱zr la xu bizre naga quebe bi nisa de̱. Dxaní'siseze xida' lau Lue' chee̱ le'eda' xel-la' waca chiu', ne xel-la' szren chiu', cáte̱ze ba ble'eda' da naca chiu' lu lataj lá'azxa chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Cháwedxa naca xel-la' dxexache lazre' chiu' ca xel-la' nabánqueze. Chee̱ le̱ na' güe lá'anaqueza' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Caníqueze nnia' chiu' da xrlátaje dxácate̱ naca bana'. Chee̱ gucá'ana szrena' Lau' chísaqueza' na'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Xélaje bénne'du xu'a da naca na ca be̱se zrita, ne be̱la' da dxánnele̱'e̱, na' dute̱ xel-la' dxebé güe lá'anaqueza' Lue' ");
INSERT INTO zatNTps_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","gate dxajsá lazra' chiu', ne dea' ga dxata', ne gate dxulaba lazra' ca naca chiu' gate dxennaza' chizrela. ");
INSERT INTO zatNTps_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Lawe' da dxácale̱nu' neda', béle̱'e̱da' cuitu' ca dxelún bedxuj dxé'enedu ca' zran xrila bedzuj. ");
INSERT INTO zatNTps_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Naca bénne'du xu'a Lue' tuze. Nen na'u wal-la nuxru' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Benne' ca' gulezá lazre̱' xuluzría xi'e̱ neda' cheajlecházie̱' lataj ba xa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Xelebía xi'e̱ lu xia nalá. Xelaque̱' da xelagu becu' xixre' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Neda', wenná bea, beda' lu da naca chee̱ Dios. Xegá'ana ba lá'ana nútete̱ze benne' dxuluchínene̱' la', lawe' da xelezxuj dxu'a benne' ca' dxelenné̱' da we̱n lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Dios, bze̱ naga chi'a lawe' da zua' ste̱be dxuláwizra' Lue'. Bxue xel-la' nabán chia' lawe' da dxezreba' bi xelún benne' ca' dxeledábague̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Bcache chawe' neda' chee̱ quebe xelún benne' we̱n da cale̱la chia' ca da dxelezá lazre̱', ne chee̱ quebe xelún benne' dxelún da zrinnaj chia' ca da zaj nune̱' xelune̱' chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Dizra' dxuluchálaje̱' zaj naca na ca xia zaj nalále̱'e̱ na, ne dxelenné̱' schanni' ca dxun tu benne' dxusane̱' xaga nalá xéche'ze chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Caní dxelenné̱' bagácheze chee̱ xelune̱' cheajlechaze benne' zaj naque̱' li lazre'. Chadite̱ dxelune̱' na, ne quebe bi dxelezrebe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Dxelune̱' ba xuzre xelune̱' da zrinnaj da zaj nune̱' xelune̱', na' dxuluzúe̱' xralaj ca' chee̱ xele̱le̱' bénneache, dxelenné̱': “¿Nuzra le'e da dxundxu?” ");
INSERT INTO zatNTps_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Dxelílaje̱' ca zaj naca da zrinnaj xelune̱', ne dxelenná' xánnie̱' ca zaj naca na. Ca da zaj xu'u xichaj lázrdawe̱' zaj naca na sté̱bele̱'e̱ ca zaj naca lázrdauqueze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Dios gune̱' benne' ca' we̱' nen tu xaga nalá xéche'ze chee̱'. Chadite̱ xelu'e̱ xízrawe̱' zren ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Dizra' buluchalaj benne' ca' xelún na cheajlecházie̱', na' xelezrebe xúgute̱ bénneache gate xelelé'ene̱' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Nadxa xelezrebe xúgute̱ bénneache, ne xuluzenne̱' ca da nun Dios, na' xuluxúnbe'e̱ ca zaj naca da be̱ne̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Béqueze benne' xrlátaje lau Xránadxu, ne guxrén lazre̱' Le̱', na' xelezúa lu da ba neza xúgute̱ benne' zaj naque̱' li lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Naca chiu' Lue', Dios, güe lá'anantu' Lue' lu xe̱zre Sión, na' guntu' da guche̱be lázrentu' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Lue' dxénqueznu' da dxuchálajle̱ntu' Lue', na' xelelá' lau Lue' xúgute̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Nabágale̱'a da zrinnaj da be̱na', san Lue' dxunite lau' ca da gudábagantu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Ba neza zrente̱ naca na chee̱ bénnea' dxeca'u Lue', ne dxenníu' le̱' gaque̱' chiu', chee̱ súaqueze̱' lataj lá'azxa chiu'. Xélajquezentu' da xrlátaje da de̱ lizru', da ca' da zaj de̱ xudau' lá'azxa chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Lu da xrlátaje chiu' gunu' da zaj naca zrente̱ gate gunu' ca da dxenábantu' Lue', Dios, Benne' dxuselé̱' netu'. Xúgute̱ bénneache zaj zra' dute̱ xe̱zr la xu dxelebeza lazre̱' Lue', ne cá'anqueze dxelebeza lazre' benne' dxeledée̱' zítu'la lawe' nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Lué'queze dxuzúa chuchu' xi'a zren ca' nen xel-la' waca chiu'. Nácaquezu' Benne' wal-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Dxebeche zriu' nísadau' gate dxelucu na, ne schaga da dxelún xeajxruza chee̱ na. Dxebeche zriu' benne' xe̱zr la xu gate dxeledábague̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Chee̱ le̱ na' benne' zaj zre̱'e̱ dute̱ xe̱zr la xu xelezrebe̱' ca naca da zrente̱ da dxunu'. Dxuzú' lu da ba neza bénneache zaj zra' du gabí'i xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Dxenna'u xe̱zr la xu, ne dxesel-lu' nisa xiuj. Dxunu' dxúnnale̱'e̱ na lina chee̱ na. Nuzúaquezu' lu xe̱zr la xu xe̱gu ca' da zaj de̱le̱'e̱ na nisa. Dxucuezu' zrua' za da xelagu bénneache, ca ba núnquezu' gaca na. ");
INSERT INTO zatNTps_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Dxesel-lu' nisa xiuj naga ba zaj nune̱' na'. Dxunu' dxexaca na xu xa'a. Dxuculu na nen nisa xiuj na'. Dxunu' dxelegula chawe' da du ca' ba zaj naxaza na. ");
INSERT INTO zatNTps_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Dxunu' dxelexezí' bénneache ba neza tu iza tu iza ne̱ chee̱ da dxunézruju', na' ca zaj naca beuj bza chiu' dxelunna na xiuj da dxun na dxelegula chawe' da zaj naza bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Dxelunna na xiuj naga dxeledá be̱ xíxre'du ca' da dxeláguba', na' dxelebé bénneache dxelelé'ene̱' ca bane zaj zua xí'adu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Lache' ca' zaj zra' zrila' ca', na' dxu'a xé̱gudu ca' zaj naxaza zrua' xtila, na' dxelebezre xa'a bénneache chiu' dute̱ xel-la' dxelebé, ne dxelúl-laqueze̱' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Le gucá'ana szren Dios dute̱ xel-la' dxebé, le'e zrale dute̱ xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Le gul-la ca naca xel-la' szren chee̱ le̱'. Le gucá'ana szrene̱' gate dxue lá'anale Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Le xe̱ Dios: “Dxebánele̱'e̱quezentu' ca zaj naca da nunu'.” Ne̱ chee̱ xel-la' szren chee̱ xel-la' waca chiu' xuluzúa xrtizru' benne' ca' dxeledábague̱' lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Xúgute̱ bénneache zaj zra' dute̱ xe̱zr la xu xelúe lá'anaqueze̱' Lue', ne xelúl-laqueze̱' chiu'. Tu xelúl-lazqueze̱' chee̱ Láquezu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Le da, lé'ele ca zaj naca da nun Dios. Da zrébedxu zaj naca da be̱ne̱' chee̱ benne' ca' belune̱' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Be̱ne̱' bexaca nísadau' xu bizre. Guledé bénneache chee̱' ní'aze̱' naga nedxu de̱ tu xe̱gu situj. Dxu'a nísadau' na' gubéle̱'e̱dxu lau Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Dute̱ xel-la' waca chee̱' nna be'e̱ chadía chacanna. Dxuxúequeze̱' ca da dxelún bénneache dute̱ xe̱zr la xu. Benne' dxeledábague̱' Le̱' quebe xelezrué'equezne̱' xel-la' szren. ");
INSERT INTO zatNTps_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Le'e, bénneache, le gucá'ana szren Dios chee̱dxu, ne le guzén bénneache ca da dxue lá'anale Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Lé̱queze̱' bxue̱' dxi'u chee̱ naca bandxu, ne quebe be̱'e̱ lataj cheajcházedxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Lué'queze bxu' netu' ca da be̱ntu', Dios. Bdeu' netu' xel-la' zi' ca dxelún bénneache dxuludée̱' xia plata lu xi' chee̱ xegá'ana chawe na. ");
INSERT INTO zatNTps_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Be̱nu' xeajchú'untu' tu lu xralaj. Bda'u cúzruntu' tu xua zí'ile̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Be̱nu' guledé xíchajntu' benne' zaj zrie̱' bzrina' chee̱' ca'. Gudentu' tu lu xi', ne tu lu nisa situj, na' bebéaju' netu', ne bzu' netu' tu lataj naga zúantu' lu da ba neza. ");
INSERT INTO zatNTps_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Chú'uqueza' lu xu'u lizru' chee̱ guzézxea' béadu ca', ne gunna' chiu' ca da guche̱be lazra' guna', ");
INSERT INTO zatNTps_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","da na' guche̱be lazra' ca da gunnía' gate guzúa' lu da sté̱bele̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Guzézxea' béadu ca', be̱ dxelanne lau' Lue', ne guna' cuen zren chee̱ zríla'du ca' lau', ne gutia' be̱zre ca', ne chivo biu ca' lau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Le da, xénele, xúgute̱le dxezrébele Dios, na' guzenda' le'e ca da be̱ne̱' gúcale̱ne̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Du lazra' bláwizra' Le̱', ne bca'ana szrénqueza' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","La guzé̱ lazra' tu da cale̱la, quebe ben Xránadxu chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Da líqueze bene Dios chi'a. Bze̱ nague̱' ca da gunábeda' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","¡Gaca báqueze Dios! ¡Quebe bzue̱' chalá'ala da bchálajle̱na' Le̱', san bexache lazre̱' neda'! ");
INSERT INTO zatNTps_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Dios, bexache lazre' netu', ne be̱n da chawe' chee̱ntu'. Dute̱ xel-la' zri'i lazre' chiu' guzúale̱ netu', ");
INSERT INTO zatNTps_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","chee̱ xelúnbea bénneache du gabí'i xe̱zr la xu ca naca da dxaca lazru', ne chee̱ xeleneze bénneache dute̱ xe̱zr la xu ca dxuseláu' bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Xúgute̱ bénneache dxelúe lá'ane̱' Lue', Dios. Dxelúe lá'ana xúgute̱ bénneache Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Le be, ne le sua lu da ba neza, le'e, bénneache dute̱ xe̱zr la xu, lawe' da guchi'a Dios chee̱le ca naca da xrlátaje, ne guxúequeze̱' xúgute̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Xúgute̱ bénneache dxelúe lá'ane̱' Lue', Dios. Dxelúe lá'ana xúgute̱ bénneache Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Xe̱zr la xu nigá ba zria na lina chee̱ na, lawe' da be̱n Dios chee̱dxu da chawe' chee̱dxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Dios ba be̱ne̱' chawe' chee̱dxu, na' gátete̱ze dxal-la' xelapa bénneache Le̱' ba lá'ana. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Guzé̱, Dios, ne be̱se dinnaj benne' ca' dxeledábague̱' Lue', ne be̱n xuluzrunnuj benne' ca' dxelecuídene̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Ca dxun tu be', dxulaga na zren chee̱ xi', ca' gulagu' benne' ca'. Ca dxuna xina' lu xi', ca' xelexenite benne' ca' lau Dios, benne' ca' dxelune̱' da zrinnaj. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Xelebé benne' xrlátaje ca', ne xelezúe̱' lu da ba neza lau Dios, ne xelexrítequeze̱' lu xel-la' dxelebé chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","¡Le gul-la chee̱ Dios! ¡Le gul-la da du ca' chee̱ Láqueze̱'! ¡Le gucá'ana szren Bénnea' dxe'e̱ xabáa, nazí le̱' Jah! ¡Le be lau Le̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Ca xra bi dxé'enedu ca', ne ca benne' dxuxúe nu'ula ca' zaj zue̱' tuze, naca Dios lu lataj lá'azxa naga zúaqueze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Dxun Dios xelezúa xrtia ljwezre bénneache quebe nu xrtia ljwezre̱' zaj zra'. Dxebéaje̱' benne' zaj xu'e̱ lu na' benne' zitu' ca' chee̱ xelezúe̱' lu da ba neza. Benne' ca' dxeledábaga Dios zaj zue̱' tu lu xe̱zr la xu bizre. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Dios, gate bdxúaju' lau bénneache chiu', ne gudáu' lu xe̱zr la xu bizre na', ");
INSERT INTO zatNTps_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","na' guzrú' xe̱zr la xu na'. Cá'anqueze gúcale̱'e̱ xiuj lau Dios. Xi'a Sinaí guzrize na lau Dios, Dios chee̱ benne' Israel ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Gusel-lu' tu nisa xiuj zílale̱'e̱, Dios. Gate belexedú lazre' bénneache chiu', Lue' btipu' lazre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Bénneache zaj naca chiu' zaj zúaqueze̱' lu xe̱zr la xu chiu'. Dute̱ da chawe' chiu', Dios, dxuxú' benne' xache' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Xránadxu Dios gusel-le̱' tu dizra' chawe', na' gulezrá' benne' zante̱, benne' buluzenne̱' bénneache ca naca dizra' chawe' na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","¡Buluzrúnnuje̱'! ¡Buluzrunnuj wenná bea ca' nen ca naca benne' chee̱' dxjaque̱' wedil-la, na' benne' ca' zaj nagá'ana lu xu'u lizre̱' belexequé̱'e̱ da bulucá'ana benne' ca' buluzrúnnuje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Lácala bcache cuínale naga dxuxúele zrila' ca', gacu zra lánale da naca na ca xrila bgúgudu ca' da zaj nazí lechítaje̱ na plata, na' dube' chee̱ xrílaba' ca' zaj nazí lechítaje̱ na oro. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Gate be̱se dinnaj Dios zrente̱ wenná bea ca' lataj na', na' bexruj bezxe' da bgacu na xi'a Salmón. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Tu xi'a zrente̱ naca xi'a Basán. Tu xi'a zri'a naca xi'a Basán na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","¿Bizr chee̱ na' dxenna'le, le'e, xi'a zri'a ca', xi'a na' naga dxaca lazre' Dios súaqueze̱'? Da líqueze súaqueze Xránadxu lu xi'a na' chadía chacanna. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Da zaj naché̱' benne' ca' lu wedil-la da napa Dios zánete̱ cue' gaxúa zaj naca na. Xránadxu Dios zezé̱'e̱ xi'a Sinaí chee̱ sue̱' lataj lá'azxa chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Begüénu' xabáa, zeche̱'u benne' ca' bebéaju' lu na' xel-la' gute, na' guzi'u da chawe' ca' da belunna bénneache, ne cá'anqueze guzúa da be̱nnu' chee̱ benne' ca' guledábague̱' Lue', chee̱ súaquezu' ládujla bénneache, Dios, leu' Jah. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","¡Gaca ba Xránadxu! ¡Tu zra tu zra dxusezrate̱' dxi'u da chawe' chee̱'! ¡Naque̱' Dios, dxuselé̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Dios, Bénnea' naque̱' Dios chee̱dxu guselé̱' dxi'u. Lé̱queze Xránadxu Dios guselé̱' dxi'u lu na' xel-la' gute. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Da líqueze Dios gune̱' we̱' xichaj benne' ca' dxeledábague̱' Le̱'. Gune̱' we̱' xichaj benne' quebe dxulusane̱' ca zaj naca dul-la da dxelune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Gunná Xránadxu: “Guna' xezrinle lázrele, xeza'ale lu xi'a Basán. Guna' xeza'ale lu da situj chee̱ nísadau', xezrinle lázrele, ");
INSERT INTO zatNTps_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","lawe' da guna' guchuchu guléajle dxen chee̱ benne' ca' dxeledábague̱' le'e, na' xelelé̱'e̱ becu' chee̱le dxen chee̱ benne' ca'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Belelé'e bénneache ca guledá bénneache chiu' belúe lá'ane̱' Lue', Dios. Dute̱ xel-la' dxelebé gulu'e̱ lataj lá'azxa chiu', Dios, Wenná Bea chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Benne' ca' dxelul-la zeajzrie̱' láwe'la, na' benne' zaj nu'e̱ da dxulucuezre̱' zja'aque̱' bzé̱bela. Ládujla zjaca nu'ula cuíde'du ca' zaj núxrube' da du ca' dxulusézxebe'. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Le güe lá'ana Dios naga zaj nazraga bénneache chee̱'. Le güe lá'ana Xránadxu, le'e nácale zri'ine zre sua Israel. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Zaj zra' zri'ine zre sua Benjamín na', guque̱' benne' cuídedxa, na' dxelenná be'e̱. Zaj nazraga benne' xíchaje̱ chee̱ zri'ine zre sua Judá na', ne benne' xíchaje̱ chee̱ zri'ine zre sua Zabulón, ne benne' xíchaje̱ chee̱ zri'ine zre sua Neftalí. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Dios, ble'e lau xel-la' wal-la chiu'. Bzua chacha, Dios, da na' be̱nu' chee̱ntu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Ne̱ chee̱ xel-la' szren chee̱ xudau' chiu' da zua na xe̱zre Jerusalén, xelegú'u benne' wenná bea ca' da xelunne̱' lau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Gudil-la benne' dxjaque̱' wedil-la chee̱ dute̱ xe̱zr la xu zaj nazrague̱' chee̱ xeledíl-lale̱ne̱' Lue', benne' ca' zaj naque̱' ca be̱zre zan ca' nen biadu chee̱ba' ca', cadxa xuluzúa xúgute̱' dizra' chiu', na' xelunne̱' ca naca xia plata da zaj nape̱'. Be̱se dinnaj benne' dute̱ xe̱zr la xu dxelexezaca ba lazre̱' xelezúe̱' lu wedil-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Xelelá' benne' xíchaje̱ chee̱ xe̱zr la xu Egipto. Benne' xe̱zr la xu Etiopía xelune̱' ba xen xulucá'ana szrene̱' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","¡Le gul-la chee̱ Dios, le'e zrale du gabí'i xe̱zr la xu! ¡Le gul-la chee̱ Xránadxu! ");
INSERT INTO zatNTps_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","¡Le gul-la chee̱ Bénnea' dxe'e̱ xabáa na'ala, da zua na nédxute̱! ¡Le nna' xque, wanné̱', ne zízrajle̱'e̱ nne̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","¡Le nne̱ nápale̱'e̱ Dios xel-la' waca! ¡Lu xel-la' szren chee̱' dxuxúequeze̱' benne' Israel ca', na' zran xabáa nalá' xel-la' waca chee̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Benne' zrébentu' nacu' Lue', Dios, naga zu' lataj lá'azxa chiu'. Dios chee̱ benne' Israel ca', Lé̱queze̱' dxutipe̱' lazre' bénneache chee̱'. ¡Gaca ba Dios! ");
INSERT INTO zatNTps_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Bselá neda', Dios. Naca' ca tu benne' dxepe̱' lu nisa. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Naca' ca tu benne' xu'e̱ lu guzra' situj, ne quebe dxaca se̱'e̱. Naca' ca tu benne' xu'e̱ lu nisa sítujle̱'e̱, na' nisa na' ba dxacu na xíchaje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Ba dxajxréqueda' lawe' da ba gunné̱le̱'a, ne ba da lba'a. Ba dxelátete̱ lawa' dxenná'a gácale̱ Dios neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Ba naxándxa benne' dxelecuídene̱' neda' ca naxán xicha xíchaja', ne quebe bi de̱ bi nuna'. Zaj naca benne' wál-lale̱'e̱ benne' dxeledábague̱' neda', benne' ca' dxuluzría xi'e̱ neda', ne quebe bi de̱ bizr chee̱ na'. ¿Dxal-la' quízruja' da quebe gulana'? ");
INSERT INTO zatNTps_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Dios, nézqueznu' Lue' naca da xálaze da nuna', ne dxelé'equeznu' dul-la da be̱na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Quebe gu'u lataj xelexedué'e ne̱ chia' neda' benne' ca' dxuluxrén lazre̱' Lue', Xrana' Dios szrente̱. Quebe gu'u lataj xeleque zréaje ne̱ chia' neda' benne' ca' dxelebeza lazre̱' Lue', Dios chee̱ benne' Israel ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Lawe' da nazrí'ida' Lue' bulucháchale̱ne̱' neda', na' lu xel-la' stu' zúaqueza'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Ca tu benne' zitu' naca' lau bi bícha'dau' ca', ne quebe zaj núnbea bi chee̱ xrna'a neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Lawe' da dxé'le̱'a gunne xue chee̱ lizru' dxal-la na lu lázrdawa'. Gate dxelenné̱' benne' ca' schanni' chiu' Lue', Dios, naca ca dxelenné̱' schanni' chia' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Gudxezra', ne be̱na' gubasa, na' bde cuina' xel-la' zi', na' chee̱ le̱ na' bulucháchale̱ne̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Cá'anqueze bgacu cuina' zra lana' tuzruj. Buluzúe̱' neda' ca tu da dxulé'e na da baxache' zrente̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Gulenné̱ chia' benne' ca' zaj xu'e̱ xu'u lawe', na' benne' ca' dxelezuzre̱' belún le̱' chia' lu da belul-le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Neda' bláwizra' Lue', Xrana' Dios, lu zra dxezaca ba lazru' Lue'. Dios, lu xel-la' dxexache lazre' zren chiu', ne lawe' da líqueze nacu' weselá chee̱ntu', bene chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Bebéaj neda' lu da ste̱be zua', naca' ca tu benne' xu'e̱ lu guzra' situj, ne quebe gu'u lataj cházedxa'. Bselá neda' lu na' benne' ca' dxelecuídene̱' neda'. Naca' ca tu benne' xu'e̱ lu nisa situj. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Quebe gu'u lataj gatia' ca tu benne' xegache̱' lu nisa situj, ne quebe gaca' ca tu benne' chu'e̱ lu da situj, ne quebe gaca' ca tu benne' cheajchazie̱' tu lu xe̱dxu situj. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Beche̱be chia', Xrana' Dios, lawe' da chawe' naca xel-la' dxexache lazre' chiu'. Gudá, gúcale̱ neda', lawe' da zrente̱ naca xel-la' dxexache lazre' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Gunná' xque ca da dxaca chia' neda', we̱n zrin chiu'. lawe' da zua' lu da sté̱bele̱'e̱, be̱n ba xuzre xennu' chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Gudá naga zua', ne bselá neda'. Bselá neda' lawe' da zaj naxánle̱'e̱ benne' ca' dxeledábague̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Lue' nézqueznu' ca dxulucháchale̱ne̱' neda', ne ca zua' lu da sté̱bele̱'e̱, ne ca dxulucá'ana dítaje̱' neda'. Dxelé'equeznu' xúgute̱ benne' ca' dxelecuídene̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Lawe' da dxelún le̱' chia' dxedú lazra', ne zua' lu da ste̱be. Guleza' nu benne' xexache lazre̱' neda', san quebe nu chilá'. Guleza' nu benne' xelexúe zrene̱' neda', san quebe nu chilá'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Bulugawe̱' neda' da sla', na' gate gubíleda', buluxí'aje̱' neda' da zichaj. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Ca naca laní chee̱ benne' ca' be̱n gaca na ca tu xralaj naga cheajlecházie̱', ne be̱n xexaca da ba neza chee̱' tu da gun na cheajlecházie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Be̱n xelechul-la xiaj lawe̱' chee̱ québedxa xelelé'ene̱', ne be̱n tu xelexrízrezqueze benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Dute̱ xel-la' dxezrá'a chiu' ble'e benne' ca', ne dute̱ xel-la' xichaj zra'a chiu' be̱' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Be̱n quebe nu chilá' lu xu'u lizre benne' ca', ne quebe nu sua lu xe̱zr la xu chee̱', ");
INSERT INTO zatNTps_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","lawe' da guláu zi' xuzre̱' bénnea' be̱nu' Lue' we̱', ne dxuluzrizre̱' ca naca xel-la' zi' dxedé bénnea' be̱'u Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Ble'e dul-la da zaj nabaga benne' ca', ne quebe gu'u le̱' lataj xelaque̱' tuze benne' xrlátaje chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Busula la benne' ca' lu xiche chee̱ benne' ca' zaj nape̱' xel-la' nabán, ne quebe guzúaju' le̱' naga zaj naxúaj la benne' xrlátaje ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Neda' zua' lu da ba xa', ne lu da sté̱bele̱'e̱. Bselá neda', Dios, ne bechisa neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Gúl-laqueza' da güe lá'ana' La Dios chia'. Gucá'ana szrena' Le̱' nen da dxue lá'ana' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Da nigá xezaca ba lázredxa Dios ca tu be̱zre, be̱ gutia' lawe̱', u ca tu me̱', béadu zaj zua lúzuba', ne xrúguba'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Xelelé'equeze benne' baxache' ca' da nigá, na' xelebene̱'. Le biga lau Dios, na' gaca bánquezle, ");
INSERT INTO zatNTps_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","lawe' da dxene Xránadxu benne' ca' dxelexázrjene̱', ne quebe dxuzúe̱' chalá'ala benne' chee̱' ca', benne' zaj xu'e̱ lizre xia. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Le güe lá'ana Le̱', le'e zrale xabáa, ne le'e, zrale lu xe̱zr la xu, ne le'e zrale lawe' nísadau', ne cá'anqueze xúgute̱ da zaj naca ban xúgute̱ lataj caní. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Dios guselé̱' benne' zaj zre̱'e̱ xe̱zre Sión, ne xexune̱' xe̱zre ca' zaj zra na lu xe̱zr la xu chee̱ benne' Judá ca', na' tu xelezúazqueze̱' na', ne gata' chee̱' xe̱zr la xu na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Zri'ine zre sua benne' we̱n zrin chiu' ca', gaca chee̱' xe̱zr la xu na', na' benne' ca' zaj nazrí'ine̱' Lau' Lue' xelezúe̱' na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Bselá neda', Dios. Gúcale̱che neda', Xran. ");
INSERT INTO zatNTps_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Be̱n xelexedué'e, ne xelezúa lu da ste̱be benne' ca' dxelaca lazre̱' xelútie̱' neda'. Be̱n xelexebigue̱', ne xelexala benne' ca' dxelebene̱' lawe' da zua' lu da ste̱be. ");
INSERT INTO zatNTps_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Be̱n xelexegá'ana xala benne' ca' dxelún le̱' chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Benne' ca' zá'aque̱' lau Lue' xelebene̱', ne xelezúe̱' lu da ba neza. Benne' ca' dxelé̱'e̱ Lue': “Xcalenu'” lawe' da bseláu' le̱', tu dxelennázqueze̱': “¡Zrente̱ naca Dios!” ");
INSERT INTO zatNTps_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Zua' lu da ste̱be, ne nate ni'a na'a. Gudázega gácale̱nu' neda', Dios. Nacu' Weselá chia', ne Xrana'. Quebe chenu', Xran. ");
INSERT INTO zatNTps_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Za'a lau' Lue', Xran, chee̱ guxru' neda'. Be̱n québedxa xedué'eda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Gúcale̱ neda', ne bselá neda' nen dute̱ da naca xrlátaje chiu'. Bze̱ naga chi'a, ne bselá neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Nacu' ca tu xiaj xre naga sua' chawe', na' waca xida' naga zu' te zra chizrela. Gunná be'enu' nu guselá neda', lawe' da nacu' Lue' ca tu xiaj xre naga dxaca dipa lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Dios chia', bselá neda' lu na' benne' ca' zaj nabéaj xíchaje̱' Lue', ne lu na' benne' ca' dxelune̱' da cale̱la ne zaj naque̱' xichaj zra'a, ");
INSERT INTO zatNTps_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","lawe' da dxebeza lazra' Lue', Xrana' Dios. Nacu' Bénnea' dxuxúe̱' neda' gate nácatea' bídau'te̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Lue' núxruquezu' neda' gate gúlajtea'. Lue' be̱nu' bdxuaja' lu le̱'e̱ xrna'a. ¡Tu güe lá'anazqueza' Lue'! ");
INSERT INTO zatNTps_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Belexebane benne' zante̱ ca naca chia', ne ca naca chiu', dxuxúe xánniu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Be̱n tu gul-lazqueza' da güe lá'ana' Lue', ne gucá'ana szrena' Lue' du zra. ");
INSERT INTO zatNTps_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Quebe guzú' neda' chalá'ala gate ba guxrúa'. Gate ba bedú lazra', quebe gusanu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Benne' dxeledábague̱' neda' dxelenné̱' chia', na' benne' ca' dxelezá lazre̱' xelútie̱' neda' belune̱' tuze dizra', ");
INSERT INTO zatNTps_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","dxelenné̱': “Ba bsan Dios le̱'. Chéajdxu cheajté̱ladxu le̱' lawe' da québedxa nu zua nu guselá le̱'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","¡Dios, quebe su' zitu' naga zua'! ¡Dios chia', gudázega gácale̱nu' neda'! ");
INSERT INTO zatNTps_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","¡Be̱n xelexedué'ene̱'! “Be̱n xelexenite benne' ca' dxeledábague̱' neda'.” “Be̱n xelezúa xel-la' stu', ne xeleque zréaje benne' ca' dxelezá lazre̱' xelune̱' chia' da cale̱la.” ");
INSERT INTO zatNTps_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Neda' tu cueza lázrezqueza' Lue', ne tu güe lá'anazqueza' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Guzenda' bénneache nacu' xrlátaje, ne tu guzénzquezda' le̱' ca da be̱nu' bseláu' neda', láqueze quebe nezda' bal-la lasa bseláu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Tu guchálajzqueza' chee̱ da zrente̱ da be̱nu' Lue', Xrana' Dios, ne gusá'a lazre' bénneache chee̱ da xrlátaje cheé̱quezu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Dios, Lue' bsé̱denu' neda' gate nácatea' bidau'te̱. Dxulé'eda' bénneache ca naca da zrente̱ da be̱nu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Dios, quebe gusán lazru' neda' gate bache guxrúa', ne ba bgucha'. Be̱' neda' lataj guzenda' zri'ine zre sua' ca naca xel-la' waca chiu', ne guzenda' bi za xelalaj ca naca xel-la' wal-la chiu', ");
INSERT INTO zatNTps_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","ne ca naca da xrlátaje chiu', da naca na da zrente̱, Dios. Lue' ba be̱nu' da zaj nácale̱'e̱ na zrente̱. Dios, ¿Núzraqueze ca Lue'? ");
INSERT INTO zatNTps_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Lue' be̱nu' gudéa' lu da ste̱be zante̱, ne lu da cale̱la ca', na' gunu' xexaca bana', na' da xula xechisu' neda' lu xe̱dxu ba. ");
INSERT INTO zatNTps_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","¡Gucá'ana szrendxu' neda', ne xue zrénquezu' neda'! ");
INSERT INTO zatNTps_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","¡Cá'anqueze güe lá'anaqueza' Lue', quínnia' da gul-lale̱na'! ¡Dios chia', gúl-laqueza' chee̱ da li chiu', quínnia' da du' zríadi'i na du! ¡Nacu' Benne' Lá'azxa chee̱ benne' Israel ca'! ");
INSERT INTO zatNTps_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","¡Sua' lu da ba neza gate gúl-laqueza' chiu' Lue', ne béqueze bénne'du xu'a, bénne'du' bexa'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","¡Tu guchálajzqueza' chee̱ da xrlátaje chiu' te zra chizrela, lawe' da be̱nu' belexedué'e, ne guleque zréaje benne' ca' belune̱' ba xuzre xelune̱' chia' da cale̱la! ");
INSERT INTO zatNTps_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","¡Dios, be̱n guchi'a wenná bea da dxaca chee̱ntu' ca dxuchí'aquezu' Lue', ne be̱n xelaca xrlátaje zri'ine wenná bea na'! ");
INSERT INTO zatNTps_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Nadxa le̱' guchi'a chee̱ bénneache chiu' ca naca da naca xrlátaje, ne ca naca da li guchi'e̱ chee̱ benne' chiu' ca' zaj zue̱' lu da ba xa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Lu xi'a ca' xelebeza zri lazre' bénneache chiu', ne lu xí'adu ca' xelezúe̱' lu da naca chawe'. ");
INSERT INTO zatNTps_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Guchi'e̱ chee̱ benne' ca' zaj zue̱' lu da ba xa' lu xe̱zre chee̱ntu', ne guselé̱' bidu ca' chee̱ benne' ca' dxelexázrjene̱', ne guzría xi'e̱ benne' ca' dxulusaca zi'e̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Xelezrebe̱' Lue' dxácate̱ ne zua gubizra, ne beu' lawe' tu cuen tu cuen bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Gaca wenná bea na' ca nisa xiuj da dxaca naga ba nadín, ne ca xrle̱'e̱la da dxaca dxe̱la lu xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Lu zra chee̱ wenná bea na' gaca da xrlátaje, ne xelebeza zri lazre' bénneache dxácate̱ ne zua beu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Nna be'e̱ dute̱ xe̱zr la xu, ne dxu'a xe̱gu Eufrates, ga zrinte̱ dxu'a nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Lau le̱' xuluzú zribe benne' ca' zaj zre̱'e̱ xe̱zr la xu, na' guzéxruje̱' lazre' benne' guledábague̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Benne' wenná bea chee̱ xe̱zr la xu Tarsis, ne wenná bea ca' chee̱ tu tu cue' xe̱zr la xu zitu' ca' xelelé̱'e̱ zaj nu'e̱ da xulunézruje̱' chee̱', na' benne' wenná bea chee̱ xe̱zr la xu Sabá, ne wenná bea chee̱ Seba xulunézruje̱' chee̱' da gunní'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Xúgute̱ benne' wenná bea ca' xuluzú zribe̱' lau le̱', na' benne' xúgute̱ cue' xe̱zr la xu xelune̱' zrin chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Le̱' guselé̱' benne' ca' dxelexázrjene̱', benne' dxululáwizre̱' le̱', ne guselé̱' benne' ca' zaj zue̱' lu da ba xa', ne quebe sua nu benne' gácale̱ne̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Xexache lazre̱' benne' xache' ca', ne benne' ca' dxelexázrjene̱', na' guselé̱' benne' xache' ca' chee̱ xelaca bane̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Xexá'awe̱' benne' xache' ca' lu na' benne' we̱n lazre' ca', ne benne' snia ca'. Gune̱' ba xuzre guselé̱' benne' ca' lu na' benne' ca' dxelutie̱' benne'. ");
INSERT INTO zatNTps_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Gaca ban wenná bea nigá, na' xulunézruje̱' chee̱' oro chee̱ xe̱zr la xu Sabá, na' tu xelenábazqueze bénneache Dios gácale̱ne̱' le̱', ne te zra chizrela xelenabe̱' Dios gune̱' gaca chawe' chee̱ wenná bea na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Tu zrígadauze zrua' xtila xelaze̱' lu xe̱zr la xu, ne lu xí'adu ca', da cuíale̱'e̱ na ca da dxebía lu xi'a Líbano, na' benne' zaj zre̱'e̱ lu xe̱zre ca' xelane̱' ca xixre' ze̱ lu xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Tu súazqueze la benne' wenná bea na'. Tu xuluchálajzqueze̱' chee̱ la le̱' dxácate̱ ne zua gubizra. Ne̱ chee̱ le̱' gaca da ba neza chee̱ bénneache xúgute̱ cue' xe̱zr la xu, na' xelenné̱' chee̱' naca chee̱' da ba neza zrente̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Xrlátaje naca Xránadxu Dios, Dios chee̱ benne' Israel ca', na' tuze Le̱' dxune̱' da dxexebánedxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Xrlátaje naca La Le̱' da naca na da xabáa chadía chacanna, na' dute̱ xe̱zr la xu nigá xelelé'ene̱' da xabáa chee̱'. ¡Ca'an naca na, ne ca'an gaca na! ");
INSERT INTO zatNTps_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Nigá dxexuzre xrtizra' David, da dxuchálajle̱ne̱' Dios. David nigá naque̱' zri'ine Isaí. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Da líqueze ba be̱n Dios da chawe' chee̱ benne' Israel ca', benne' ca' zaj naque̱' du lazre' lau Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Neda' ba guzúa cheajcházia' lu dul-la. Ba guzúa guna' tu da zrinnaj, ");
INSERT INTO zatNTps_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","lawe' da guca' zre'e lazre' ne̱ chee̱ benne' gunní'a ca', gate ble'eda' ca dxelepe ban benne' ca' zaj nabéaj xíchaje̱' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Benne' caní quebe zaj zue̱' ste̱be chee̱ xel-la' gute, lawe' da zaj zúale̱'e̱ chawe'. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Quebe dxeledée̱' lu da ba xa' ca da dxeledé xúgute̱ benne' ca', ne quebe dxelezaca zi'e̱ ca da dxaca chee̱ xezícadxa bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Chee̱ le̱ na' dxulucá'ana szren cuine̱'. Tu dxelexúbezquezne̱' dxelune̱' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Dxelánnie̱' lawe' da dxelagu cháwele̱'e̱. Dxelezíle̱'e̱ ca naca da dxelezá lazre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Dxelún le̱' chee̱ Dios, ne dxelenné̱' cale̱la ca da zrinnaj da xelune̱'. Dute̱ xel-la' dxulucá'ana szren cuina dxuluchálaje̱' da zrente̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Dxelenné̱' chee̱ da ca' zaj zua xabáa, ne dxuluchálaje̱' ca benne' zaj nape̱' dute̱ xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Chee̱ le̱ na' xúgute̱ bénneache dxelune̱' le̱' tu zren, ne dxelezi'e̱ ca da dxelenná benne' gunni'a ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Dxelenná benne' ca' dxelune̱' da cale̱la: “¿Ájazra gaca neze Dios? ¿Dxelé'equeze Bénnea' zue̱' na'ala?” ");
INSERT INTO zatNTps_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Benne' caní zaj naque̱' benne' zaj nabéaj xíchaje̱' Dios, na' dxelepe bane̱' lu xe̱zr la xu, ne dxelaque̱' gunní'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Da líqueze, dácheze naca guca' du lazre', ne quebe bi da cale̱la nuna'. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Gudéa' lu da ba xa' tu zra tu zra, ne gudéa' xel-la' zi' xúgute̱ zra. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","La nnia' neda': Guchálaja' ca dxuluchalaj benne' ca', na' si xe̱'a bénneachedu ca' chiu', Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Gate blaba lazra' chee̱ chéajni'ida' da nigá, guca na sté̱bele̱'e̱ chia' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Gate guxu'a lu lataj lá'azxa chee̱ Dios, na' guque be'eda' da gaca chee̱ benne' ca' gate cheajsé̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Da líqueze nunu' chee̱ benne' ca' cheajlecházie̱', ne gunu' xelebía xí'queze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Chadite̱ gulebía xí'queze̱'. Belexenite̱' lu xel-la' gulezrébele̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Zaj naque̱' ca tu da ble'edxu lu xe̱la da dxexenite na gate dxexebandxu. Ca'an gaca, Xran, gate chasu', guzú' chalá'ala ca da gulaca benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Gate guca' zre'e lazre' chee̱ benne' ca', guzúa lázrdawa' lu da ste̱be. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","Lawe' da guca' xichaj zide', na' quebe guxéajni'ida' guca' ca tu be̱ xixre' lau Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Tu guzúazqueza' nen Lue', na' guca'u na'a xabe̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Bsi'u neda' chee̱ guna' da dxulé'enu' neda', na' te nigá xezí' lu na'u neda' lu xabáa chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Quebe nu xetú zua chia' xabáa san tuzu' Lue', ne quebe nu xetú dxezá lazra' lu xe̱zr la xu, san tuzu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Dxelexedú lazre' be̱la' dxen chia', ne lázrdawa'. Dios naque̱' Benne' dxutipe̱' lazra', ne naque̱' da ba neza chia' chadía chacanna. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Benne' ca' dxelexecuase̱' naga zu' xelexenítie̱'. Guzría xi'u xúgute̱ benne' ca' xelexebeaj xíchaje̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Ca naca chia' neda', dxaca chawe' chia' lawe' da gubiga' lau Dios. Tu dxebeza lázrezqueza' Xránadxu Dios, chee̱ guchálajqueza' ca naca da zrente̱ da nune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Dios, ¿tu chí'izqueze nuzú' netu' chalá'ala? ¿Dxezra'u netu', nácantu' ca zrila' chiu' ca'? ");
INSERT INTO zatNTps_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Bsá lazre' bénneache chiu', benne' ca' guzi'u nédxudaute̱. Benne' ca' bexa'u chee̱ gunu' xelaque̱' benne' cheé̱quezu', benne' ca' zaj zre̱'e̱ lu xi'a Sión nigá, naga zúaquezu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Gudá xedajnná'u ca nabía xi' xe̱zre nigá, ne ca naca da cale̱la da belún benne' ca' dxeledábague̱' netu', lu lataj lá'azxa chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Dxelebezre xa'a benne' ca' dxeledábague̱' Lue' laduj naga zaj nazraga bénneache chiu'. Zaj nuzúe̱' nigá da dxululé'e na xu'untu' lu na' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Buluzría xi'e̱ xe̱zre nigá, ca dxun tu benne' dxine̱' ca naca xaga zaj ze̱ tu xi'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Na'a nen xa waga chee̱' ca', ne nen xaga chee̱' ca', ba buluzría xi'e̱ ca naca lechítaje̱ chee̱ xudau' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Ba buluzézxie̱' lataj lá'azxa chiu'. Bulucá'ana dítaje̱' xu'u lizru'. Buluchínnaje̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Lu lázrdawe̱' gulenné̱': “Guzría xí'tegadxu na tu chi'ize.” Ba buluzézxie̱' xúgute̱ xu'u naga bezrágantu' chiu' lu xe̱zr la xu chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Québedxa dxelé'entu' da la'axza ca' da dxululé'e na da guchísantu' lu xe̱zr la xu chee̱ntu'. Québedxa nu chilá' benne' guchálaje̱' waláz chiu', ne quebe nu zua ládujla netu', benne' nézene̱' bátaqueze lantu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","Dios, ¿Báta cueza na xulucháchale̱ benne' ca' netu', benne' ca' dxulusaca zi'e̱ netu'? ¿Chadía chacanna welenné̱ benne' dxeledábague̱' lue' schanni' chee̱ Lau'? ");
INSERT INTO zatNTps_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","¿Bizr chee̱ na' quebe dxebéaj lazru' benne' ca'? ¿Bizr chee̱ na' quebe dxuzría xi'u benne' ca' dxelune̱' da cale̱la? ");
INSERT INTO zatNTps_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Lue', Dios, nacu' Wenná Bea chia' nédxudaute̱. Lué'queze dxuseláu' bénneache dute̱ xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Xel-la' waca chiu' be̱nu' nísadau' chupa la'a. Gula'u xichaj be̱ schanni' ca' lu nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Bzúzruju' xichaj be̱ schanni' le̱ba' leviatán, Na' be̱nu' gulagu be̱ xixre' le̱ba', bea ca' zaj zraba' lu xu bizre. ");
INSERT INTO zatNTps_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Be̱nu' gulaj nisa beaj, ne nisa xe̱gu ca'. Bsebizru' xe̱gu zri'a ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Chiu' Lue' naca te zra, ne cá'anqueze chiu' naca dxe̱la. Lue' bzu' beu', ne gubizra naga dxeledé na. ");
INSERT INTO zatNTps_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Lue' bzu' tu chi'ize ca naca da zaj de̱ xe̱zr la xu nigá. Lue' be̱nu' beu' la ca', ne beu' zaga ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Bsa lazre' da nigá: Benne' ca' dxeledábague̱' lue' ba zaj nun le̱' chiu' Lue', Xran. Benne' xala ca' ba gulenné̱' schanni' chee̱ Lau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Quebe gusanu' lu na' benne' zaj naque̱' ca be̱ snia ca' benne' ca' nazrí'iquezu', ne quebe gal-la lazru' tu chi'ize bénneache chiu' zaj zue̱' lu da ba xa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Gunná' ca naca xel-la' wezría da be̱nu', lawe' da gátete̱ze naca chul-la lu xe̱zr la xu, na' zaj zra' benne' ca' dxelune̱' da zrinnaj. ");
INSERT INTO zatNTps_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Quebe gu'u lataj xelegá'ana lu xel-la' stu' benne' ca' zaj zue̱' lu da baxache'. Benne' dxelezaca zi'e̱, ne benne' dxelexázrjene̱' xelúe lá'ane̱' Lau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","¡Guzé̱, Dios! ¡Be̱n ca ba gunnáu'! ¡Bsa lazre' ca dxelún benne' xala ca', dxelún le̱' chiu' te zra te zra! ");
INSERT INTO zatNTps_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Quebe gal-la lazru' ca da gulenná benne' ca' dxeledábague̱' lue'. Da schaga dxelún benne' ca' dxeledábague̱' Lue' tu dxénzqueze na. ");
INSERT INTO zatNTps_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","“Xcalenu'”, dxe̱ntu' Lue', Dios: “Xcalenu'.” Dxuzentu' bénneache zúale̱nu' netu', ne ba nunu' da ca' dxexebánequezentu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Dxenná Dios: “Ba nuzúa' zra guchi'a chee̱ bénneache. Guchi'a ca naca da xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Lácala xru' dute̱ xe̱zr la xu, ne xelezrize xúgute̱ da zaj naca ban na, neda' gúxruqueza' ca naca lane xe̱zr la xu na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Dxapa' benne' xala ca': Quebe gáwele. Dxapa' benne' ca' dxelune̱' da cale̱la: Quebe gucá'ana szren cuínale. ");
INSERT INTO zatNTps_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Quebe guxrén lázrele xel-la' wal-la chee̱le. Quebe gácale benne' lázxdau zide'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Quebe za xel-la' szren naga dxalaj gubizra, ne naga dxebía na, ne quebe za na le̱'e̱ xixre' lawe' lataj. ");
INSERT INTO zatNTps_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Dios naque̱' Bénnea' guchi'e̱ chee̱ bénneache. Dxucá'ane̱' cá'aze tu benne', ne dxucá'ane̱' szren xetú benne'. ");
INSERT INTO zatNTps_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Dios nuxre̱' tu zriga', da nazrate̱ na xrise uva wal-la, da zeaje na xel-la' dxezrá'a chee̱'. Dxulálaje̱' na chee̱ xele̱'aj benne' ca' dxelune̱' da cale̱la. Xelé̱'aje̱' na xebizrte̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Neda' guzénquezda' bénneache, ne gul-la' da güe lá'ana' Dios chee̱ Jacob. ");
INSERT INTO zatNTps_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Le̱' guchínnajqueze̱' xel-la' waca chee̱ benne' we̱n da cale̱la ca'. Gusezrendxe̱' xel-la' waca chee̱ benne' xrlátaje ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Zaj núnbea benne' Judá ca' Dios, na' ládujla benne' Israel zrente̱ nácaqueze La Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Lu xe̱zre Salem zua lataj lá'azxa chee̱'. Lu xe̱zre Sión zua naga zúaqueze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Lataj na' gudíchaje̱' xaga nalá xéche'ze ca', ne xia da dxucu'uj na benne' lu wedil-la, ne ca naca da dxuluchínene̱' lu wedil-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Benne' xabáa nacu' Lue', ne Benne' wál-ladxa ca xi'a zri'a ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Xeajlechaze benne' wal-la ca', ne guláse dínnaje̱'. Netú benne' wal-la ca' quebe belexechisa ne̱'e̱ chee̱ xelune̱' wedil-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Dios chee̱ benne' Israel ca', gate gudil-lu' benne' ca', guláse dinnaj bzrina' ca', ne benne' gulebíe̱'-ba'. ");
INSERT INTO zatNTps_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Nacu' Lue' Benne' zrébedxu. ¿Nu benne' gaca se̱' lau Lue' gate dxezra'u? ");
INSERT INTO zatNTps_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Xabáate̱ gunná'u, na' guchi'u chee̱ bénneache. Dxelezrebe bénneache lu xe̱zr la xu, na' dxelebeze̱' ");
INSERT INTO zatNTps_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","zra seu' Lue', Dios, chee̱ guchi'u chee̱ bénneache, ne chee̱ guseláu' xúgute̱ benne' dxexruj lazre' zaj zre̱'e̱ lu xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Da líqueze xel-la' dxelezrá'a chee̱ bénneache gaca na tu da gucá'ana szren na Lue'. Guzúa zriu' xel-la' dxelezrá'a chee̱ bénneache zaj nagá'ane̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Le che̱be lázrele da gunle chee̱ Dios, na' le gun da na' chee̱ Xránadxu, Dios chee̱le. Xúgute̱ benne' zaj zre̱'e̱ du gabi'ila xelelé̱'e̱, na' xulunézruje̱' da zaj nu'e̱ chee̱ Dios, Bénnea' dxezrébedxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Guzague̱' da xu'u lu xichaj lázxdau benne' blau ca'. Le̱' dxuchebe̱' benne' wenná bea ca' zaj zre̱'e̱ lu xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Nen chi'a bláwizra' Dios. Bláwizra' Dios, na' Le̱' buzé̱ nague̱' chi'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Guxu'a lau Xránadxu lu zra guzúa' lu da ba xa'. Chizrela guchisa na'a lau Le̱', ne quebe guzúa zria'. Quebe be̱'a lataj nu benne' xue zrene̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Bsa lazra' chee̱ Dios, ne guzúa' ste̱be. Gudawa' zria lawe̱', ne bedú lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Begúe̱' bchigala chia'. Guzúa' sté̱bele̱'e̱, ne quebe guca guchálaja'. ");
INSERT INTO zatNTps_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Blaba lazra' ca naca zra nédxute̱. Ca naca iza zan ca' da ba guledé chee̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Bsa lazra' ca naca da bil-la' chizrélala, ne blaba lázrequeza' ca zaj naca na, na' gunaba be' xu'a: ");
INSERT INTO zatNTps_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","¿Guzúa Xránadxu dxi'u chalá'ala tu chi'ize ne québedxa gácale̱ne̱' dxi'u? ");
INSERT INTO zatNTps_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","¿Cabátadxa xexache lazre̱' dxi'u? ¿Cabátadxa gune̱' ca da guche̱be lazre̱'? ");
INSERT INTO zatNTps_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","¿Gul-la lázrequeze Dios xexache lazre̱' dxi'u? ¿Dxezré̱'e̱ dxi'u, na' québedxa xexache lazre̱' dxi'u? ");
INSERT INTO zatNTps_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Nadxa gunnía': Caní dxuna' lawe' da quebe chawe' zua'. Chee̱ le̱ na' cheajsá lazra' chee̱ xúgute̱ da zrente̱ da be̱n Dios zrente̱ lu iza ba guledé chee̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Cheajsá lazra' chee̱ da zrente̱ ca' da be̱n Jah. Awe', cheajsá lazra' chee̱ da be̱nu' nédxudaute̱ da ca' dxexebánentu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Gulaba lazra' ca naca xúgute̱ da ba be̱nu', ne guchálaja' ca zaj naca da nunu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Dios, lá'azxa naca da dxusé̱denu' netu' ca guntu'. ¿Zua xetú Dios naque̱' benne' zren ca naca Dios chee̱ntu'? ");
INSERT INTO zatNTps_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Lue' nacu' Dios, dxunu' da ca' dxexebánentu'. Blé'enu' xúgute̱ bénneache lu xe̱zr la xu ca zrente̱ naca xel-la' waca chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Nen xel-la' waca chiu' bexa'u bénneache chiu', zri'ine zre sua Jacob, ne zri'ine zre sua José. ");
INSERT INTO zatNTps_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Xe̱gu nisa ca' belelé'en Lue', Dios. Belelé'e xe̱gu nisa ca' Lue', na' belezrébele̱'e̱ na. Cá'anqueze gulezúa ste̱be nísadau' situj ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Nisa xiuj zila bdxuaj na lu beuj bza ca', ne gulenné̱le̱'e̱ guziu', ne gulé̱pele̱'e̱ xesa. ");
INSERT INTO zatNTps_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Lu be' bdunu' ben guziu' chiu' da gunné̱le̱'e̱ na. Bulusaní' xesa guziu' ca naca xe̱zr la xu. Guzúa ste̱be, ne guzrize xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Lawe' nísadau' guza'u, ne lawe' nisa zila ca' gudéquezu', ne quebe naca bea naga bléaju'. ");
INSERT INTO zatNTps_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Guche̱'u bénneache chiu' ca zrila' ca' lu na' Moisés, ne lu na' Aarón. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Le xen, le'e, bénneache chia', ca da dxusé̱deda'. Le xen xanne' ca da dxuchálaja'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Guchíneda' dizra' ca da dxuluchalaj benne' sina ca', na' guzéajni'ida' le'e da ca' gulezúa na bagácheze gate nate, ");
INSERT INTO zatNTps_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","da ca' bendxu, ne bé̱nbeadxu na, da ca' belixru be'e xra xrtáudxu ca' dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Quebe gucáchedxu na lau zrí'inedxu ca'. Guzénquezdxu zrí'inedxu ca' ca naca xel-la' szren chee̱ Xránadxu, ne ca naca xel-la' waca chee̱', ne ca zaj naca da zren ca' da be̱ne̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Bzue̱' tu da nadxixruj bea na da xelún benne' Israel ca', ne da bdxixruj be'ene̱' ca' da xelún zri'ine zre sua Jacob. Gunná bé'ene̱' xra xrtáudxu ca' xuluzenne̱' bi chee̱' ca' ca naca da gunná bé'ene̱', ");
INSERT INTO zatNTps_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","chee̱ xelúnbea zrí'ine̱' bidu ca' za xelálajbe' ca naca na, na' bi caní xuluzenbe' zrí'inebe' da na', ");
INSERT INTO zatNTps_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","chee̱ xuluxrén lázrebe' Dios, ne quebe xelal-la lázrebe' da ca' be̱n Dios, ne chee̱ xuluzúabe' dizra' da ca' gunná be'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Quebe xelácabe' ca gulaca xra xrtáube' ca'. Benne' ca' quebe buluzúe̱' dizra' chee̱', ne guledábague̱' Le̱', ne quebe buluzúa chúchue̱' ca buluxrén lazre̱' Dios, ne quebe gulaque̱' li lazre' lu da naca chee̱ Dios lu be' zaj nácaqueze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Benne' zrí'ine zre sua Efraín, benne' zaj nu'e̱ da dxuluchínene̱' lu wedil-la buluzrúnnuje̱' naga dxaca wedil-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Quebe belune̱' ca naca xel-la' wezría da be̱n Dios, ne quebe buluzúe̱' dizra' da gunná bé'ene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Gulal-la lazre̱' da ca' be̱n Dios, ne xel-la' waca ca' blé'ene̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Lau xra xrtawe̱' ca' be̱ne̱' xel-la' waca ca' lu xe̱zr la xu Egipto, ne lu xe̱zr la xu Zoán. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Gusalje̱' neza lu nísadau' naga guledé benne' ca'. Be̱ne̱' nísadau' na' ca xi'a ca' chalá'a weaj. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Te zra blé'ene̱' benne' ca' neza nen tu beuj bza da xjácale̱ne̱', ne chizrela nen beuj bza da naca na ca tu xi'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Gulé̱'e̱ xiaj ca' naga naca xu bizre, na' bxí'aje̱' benne' ca' nisa da gulaj na le̱'e̱ xiaj ca' ca tu xe̱gu nisa. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Be̱ne̱' gulaj tu xe̱gu nisa le̱'e̱ xiaj na', na' bzriluj na ca tu xe̱gu zren. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Lácala be̱ne̱' caní belúndxaqueze̱' dul-la lau Dios le̱'e̱ xixre' lawe' lataj, ne guledábague̱' Dios nape̱' dute̱ xel-la' szren. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Gulegú'u lazre̱' xulu'zúa zrie̱' Dios. Gulenabe̱' xelawe̱' ca da dxelezá lazre' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Gulenné̱' chee̱ Dios, gulenné̱': ¿Wazeque Dios na' gunne̱' da gágudxu le̱'e̱ xixre' nigá? ");
INSERT INTO zatNTps_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Da líqueze gulé̱'e̱ xiaj na', na' gulaj nisa na', na' bzriluj na ca tu xe̱gu zren. ¿Wazéquequezne̱' gunne̱' dxi'u xeta, ne gunne̱' be̱la' da gágudxu? ");
INSERT INTO zatNTps_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Chee̱ le̱ na' bzra'a Xránadxu gate benne̱' da na', ne gusel-le̱' xi' da bzezxe na bal-la bénneache chee̱', na' bsedxí'ule̱'e̱ xel-la' dxezrá'a chee̱' nen benne' Israel ca', ");
INSERT INTO zatNTps_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","lawe' da quebe guléajle̱'e̱ chee̱ Dios, ne quebe buluxrén lazre̱' Le̱' guselé̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Gunná bé'ene̱' beuj zran xabáa, ne gusálaje̱' dxa xu'u chee̱ xabáa, ");
INSERT INTO zatNTps_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","na' be̱ne̱' bxinnaj xeta maná ca dxinnaj xiuj chee̱ gulagu benne' chee̱' na. Bnézruje̱' le̱' da naca ca zrua' chee̱ xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Gulawe̱' da dxelagu gubáz chee̱ xabáa ca'. Gusél-lale̱'e̱ da gulawe̱', na' gulélajte̱quezene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Be̱ne̱' guca be' da za' chalá'ala naga dxalaj gubizra, ne xel-la' waca chee̱' be̱ne̱' guca be' za' chalá'ala naga dxedé gubizra beu' zaga, ");
INSERT INTO zatNTps_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","na' gusel-le̱' chee̱ benne' ca' be̱la' ca ze̱ bxrte xu, béadu zaj zua xrila naxanba' ca xuzre' da dxe' dxu'a tu xe̱gu zren. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Be̱ne̱' guléxrujba' chale'aj chee̱ benne' ca'. Guléxrujba' dúte̱queze naga zaj zua xu'u xide chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Gulawe̱'-ba', ne gulélajquezene̱'. Dios bnézruje̱' chie̱' ca naca da gulaca lazre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Gate quebe ne xelélajene̱', ne ne dxelawe̱'-ba', ");
INSERT INTO zatNTps_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","bzra'a Dios benne' ca', na' be̱tie̱' benne' zaj nácadxe̱' benne' wal-la, ne benne' Israel ca' zaj nácadxe̱' benne' waca. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Láqueze be̱ne̱' caní, na' belúndxaqueze̱' dul-la, ne láqueze belelé'ene̱' xel-la' waca ca' da be̱ne̱', quebe buluxrén lazre̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Chee̱ le̱ na' guchugue̱' zra chee̱ benne' ca' ca tu be' dxecá'adxu, ne ca zaj naca iza da gulezúe̱', bdee̱' le̱' lu da zi' da xa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Gate be̱tie̱' bal-la benne' ca', na' xezícadxe̱' belexaque̱' chee̱ Dios. Belexebí'i lazre̱', ne du lazre̱' buluchálajle̱ne̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Xeajlesá lazre̱' naca Dios Benne' dxuxúe̱' le̱', ne Dios na' nape̱' dute̱ xel-la' szren naque̱' Bénnea' bxá'awene̱' le̱', ");
INSERT INTO zatNTps_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","san quebe guca li lazre' da gulenné̱' lawe' da belún lazre̱' lau Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Quebe gulaque̱' li lazre' nen Le̱', ne quebe belune̱' du lazre' ca naca xel-la' wezría chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Dios bexache lazre̱' chee̱ benne' ca', ne bnite lawe̱' dul-la belune̱', ne quebe bzria xi'e̱ le̱'. Zane' lásate̱ bzue̱' chalá'ala xel-la' dxezrá'a chee̱', ne quebe bzre̱'e̱ le̱' dute̱ ca da dxéquene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Xeajsá lazre' Dios zaj naque̱' be̱la' dxen. Zaj naque̱' ca tu be' da dxedé na, ne quebe xezrín na. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Zane' lasa guledábague̱' Le̱' le̱'e̱ xixre' lawe' lataj na', ne zane' lasa buluzúe̱' Le̱' baxache'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Zane' lasa buluzúe̱' Dios chalá'ala, ne buluché̱'e̱ Dios lá'azxa chee̱ benne' Israel ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Gulal-la lazre̱' ca naca xel-la' waca zren chee̱', ne ca be̱ne̱' lu zra na' bxá'awene̱' le̱' lu da zi' da xa', ");
INSERT INTO zatNTps_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","gate be̱ne̱' xel-la' waca ca' lu xe̱zr la xu Egipto, ne blé'ene̱' da ca' da dxebánedxu lu xe̱zr la xu Zoán. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Bexune̱' xe̱gu chee̱' ca' dxen, na' québedxa guca da xele'aj benne' Egipto ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Gusel-le̱' be̱'a ládujla benne' ca', be̱ buludeba' le̱' xel-la' zi'. Gusel-le̱' bluzru ca' buluzría xiba' xe̱zr la xu chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Gusel-le̱' biche zu ca' guláguba' lina chee̱', ne buluzría xiba' da zaj zua lu xe̱zr la xu chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Gusel-le̱' xiaj bezxe' zri'a da bzria xi na lba uva chee̱' ca', ne gusel-le̱' da zaga da bsebizre na xaga higo chee̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Gusel-le̱' xiaj bezxe' zri'a da be̱te na be̱ xixre' chee̱' ca', ne gusel-le̱' xesa da be̱te na zrila' chee̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Bdee̱' benne̱' Egipto ca' lu xel-la' zi' zren, lawe' da bzrá'ale̱'e̱ benne' ca', na' guca da ca' ca zánete̱ gubáz ca' chee̱ xel-la' gute. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Quebe bzague̱' xel-la' dxezrá'a chee̱', ne quebe bnite lawe̱' chee̱' chee̱ quebe xelátie̱', san be̱tie̱' le̱' nen tu xízrawe̱' wal-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Be̱tie̱' bi biu nedxu chee̱ benne' ca', bi biu nedxu ca' chee̱ benne' Egipto ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Nadxa beche̱'e̱ benne' chee̱' ca' ca tu benne' dxeche̱'e̱ zrila' ca', ne bsi'e̱ le̱' le̱'e̱ xixre' lawe' lataj. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Bsi'e̱ le̱' zri'a chawe', ne quebe bi belezrebe̱', san gulate benne' guledábague̱' Le̱' lu nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Beche̱'e̱ le̱' lu xe̱zr la xu lá'azxa chee̱', naga zua xi'a nigá da guca cheé̱queze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Bebéaje̱' benne' zaj zre̱'e̱ lu xe̱zr la xu na' lau benne' chie̱' ca', na' gulé̱'e̱ xe̱zr la xu chee̱' cha chee̱ benne' Israel ca', ne bzre̱'e̱ le̱' lizre benne' ca' bebéaje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Da xula buluzúe̱' Dios chalá'ala, ne buluché̱'e̱ Dios, nape̱' dute̱ xel-la' szren. Quebe buluzúe̱' dizra' da ca' gunná be'ene̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Da xula guledábague̱' Dios ca belún xra xrtawe̱' ca'. Gulaque̱' ca tu bdxeque' xala chee̱ xaga nalá xéche'ze. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Buluché̱'e̱ Le̱' ne̱ chee̱ lataj ca' naga bulucá'ana szrene̱' bedáu' xiaj xaga ca', ne ne̱ chee̱ bedáu' xiaj xaga chee̱' ca' bzrá'ale̱'e̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Bzra'a Dios gate blé'ene̱' na, na' gucuídele̱'e̱ne̱' benne' chee̱' ca', benne' Israel. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Guleaj xíchaje̱' xu'u xide lá'azxa chee̱' zua na xe̱zre Silo, xu'u xide na' guzuáqueze̱' ládujla benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Be̱'e̱ lataj belecá'a benne' ca' dxeledábague̱' dxi'u xi'ina lá'azxa chee̱', da na' dxulé'e na xel-la' waca, ne xel-la' szren chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Bzre̱'e̱ benne' chee̱' ca', na' bdee̱' le̱' lu na' benne' ca' belútie̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Benne' wal-la ca' gulátie̱' lu wedil-la. Quebe nu zra' benne' wegu', benne' xelezúale̱ne̱' nu'ula wegu' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Cá'anqueze gulate bxruze ca' lu wedil-la, na' nu'ula chee̱ bxruze ca' quebe gulebezre xache̱' chee̱ bxruze ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Nadxa guca Xránadxu ca tu benne' dxexebane̱' lu bchigala. Guque̱' ca tu benne' wal-la dxebezre xe̱'e̱ gate ba né'aje̱' xrise uva wal-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Na' blague̱' benne' guledábague̱' Le̱', ne bca'ane̱' le̱' cá'aze chadía chacanna. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Bzue̱' chalá'ala zri'ine zre sua José, ne quebe bequé̱'e̱ zri'ine zre sua Efraín, ");
INSERT INTO zatNTps_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","san bequé̱'e̱ zri'ine zre sua Judá, ne xi'a Sión, da na' nazrí'ile̱'e̱ne̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Lu xi'a na' be̱ne̱' xudau' lá'azxa chee̱', da guca na ca naca da zua na xabáa. Bzua chúchue̱' na chadía chacanna, ca nácaqueze xe̱zr la xu nigá. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Bequé̱'e̱ David, benne' we̱n zrin chee̱'. Bebéaje̱' le̱' naga zaj zra' zrila' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Beche̱'e̱ le̱' naga zue̱' dxuxúe̱' zrila' ca' zaj nache̱'e̱ba' be̱dau', chee̱ gaque̱' wenná bea, benne' guxúe̱' bénneache chee̱', zri'ine zre sua Jacob, benne' zaj naque̱' benne' Israel ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Dute̱ xel-la' du lazre' chee̱' bxue̱' benne' ca'. Bxue̱' le̱' dute̱ xel-la' waca zren chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Dios, ba gulú'u benne' xe̱zr la xu zitu' ca' lu xe̱zr la xu chee̱ bénneache chiu'. Bulucá'ana dítaje̱' xudau' lá'azxa chiu'. Buluzría xi'e̱ xe̱zre Jerusalén. ");
INSERT INTO zatNTps_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Bulucá'ane̱' be̱la' dxen chee̱ we̱n zrin chiu' ca' naga gulagu be̱ zua xrila le̱'. Be̱ xixre' ca' guláguba' be̱la' dxen chee̱ benne' ca' zaj naque̱' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Ca nisa bululálaje̱' dxen chee̱ benne' ca' xúgute̱ lu neza chee̱ xe̱zre Jerusalén, ne quebe nu chilá' benne' gucache̱' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Benne' xe̱zr la xu walizre' chee̱ntu' ca' dxulucháchale̱ne̱' netu'. Benne' zaj zre̱'e̱ xe̱zre walízr ca' dxulucá'ana dítaje̱' netu', ne dxelún le̱' chee̱ntu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","¿Bata cuézaqueze gaca caní chee̱ntu', Xran? ¿Tu chí'izqueze dxezra'u netu'? ¿Tu chí'izqueze gaca xel-la' dxezrá'a chiu' ca tu xi'? ");
INSERT INTO zatNTps_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Bzra'a benne' xe̱zr la xu ca' quebe zaj núnbe'e̱ Lue', na' benne' xe̱zr la xu ca' quebe dxululáwizre̱' Lue', ");
INSERT INTO zatNTps_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","lawe' da ba buluzría xi'e̱ zri'ine zre sua Jacob, ne bulucá'ana dítaje̱' xu'u lizre benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Quebe gusebagu' netu' ca naca da zrinnaj da belún xra xrtauntu' ca'. Gudázega xexache lazru' netu', lawe' da dxezraga láule̱'e̱ntu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Gúcale̱ netu', Dios, nacu' Bénnea' dxuselé̱' netu', chee̱ gaca ba Lau'. Bselá netu', ne bnite lau dul-la nuntu' chee̱ xegá'ana szren Lau', ");
INSERT INTO zatNTps_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","lawe' da xelenná bénneache: “¿Ga na Dios chee̱ benne' ca'?” Bebéaj lazre' benne' ca' belútie̱' we̱n zrin chiu' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Caní be̱n chee̱ xelelé'e xúgute̱ benne' chiu' ca' zaj xu'e̱ lu na' benne' ca' dxeledábague̱' netu'. Dute̱ xel-la' waca zren chiu' bselá benne' ca' ba zaj nachugue̱' chee̱' xelatie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Bunezruj chee̱ benne' xe̱zr la xu walizre' chee̱ntu' ca' xegazre cue' ca da cale̱la da belune̱', bulucá'ana dítaje̱' Lue', Xran. ");
INSERT INTO zatNTps_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Netu', bénneache chiu', nácantu' ca zrila' chiu' ca', güe lá'anaquezentu' Lue' chadía chacanna. Tu cuen tu cuen zri'ine zre suantu' gúl-laquezentu' da güe lá'anantu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Bene chee̱ntu', Lue' dxuxú' benne' Israel ca', Lue' na', dxuxú' zri'ine zre sua José ca zríla'du ca', ne dxe'u lataj blau chiu' da zua na láwela querubín ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Ble'e xel-la' szren chiu' lau zri'ine zre sua Efraín, ne Benjamín, ne Manasés. Ble'e xel-la' waca chiu', ne gudá guseláu' netu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Beché̱' netu', Dios. Bexache lazre' netu', na' lantu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Xránantu' Dios, napu' dute̱ xel-la' waca, ¿bata chajse̱queze zra'u netu', ne quebe xennu' ca da nábantu' Lue'? ");
INSERT INTO zatNTps_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Bzúale̱'u netu' lu xel-la' dxewí'ine lazre', ne bzílale̱'u nisa dxebézrentu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Be̱'u lataj xe̱zr la xu walizre ca' bulucá'ana dítaje̱' netu', na' benne' ca' dxeledábague̱' netu' belún le̱' chee̱ntu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Beché̱' netu', Dios, napu' dute̱ xel-la' waca. Bexache lazre' netu', na' lantu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Bebéaju' tu zrigu' lba uva lu xe̱zr la xu Egipto da naca na bénneache chiu'. Blagu' benne' xe̱zr la xu gulezré̱'e̱ nigá, na' guzu' nigá zrigu' lba uva na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Gú'unu' lba uva na' chee̱ gula na. Bdéle̱'e̱ lue zrigu' lba uva na', na' gucu na xe̱zr la xu na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Gulú'u na zrul-la xúgute̱ xi'a ca', na' zruze na ca' gulegú'u na zrul-la xaga cedro zren ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Gulechiluj zruze na, belezrinte̱ na dxu'a nísadau', ne belezrinte̱ na dxu'a xe̱gu Eufrates. ");
INSERT INTO zatNTps_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","¿Bizr chee̱ na' gucá'u le'aj da naxechaj na le̱ na? Na'a xúgute̱ benne' dxeledé na' dxelebane̱' da zixre chee̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Dxuluchuchu dxululéaj cuche xixre' ca' lba uva na', na' be̱ xixre' ca' dxeláguba' na. ");
INSERT INTO zatNTps_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Bedá chee̱ntu', Dios, napu' dute̱ xel-la' waca. Gunná' netu' ga na' zu' xabáa, ne gudá xedajnná'u lba uva chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Gudá, guseláu' lba uva nigá, da gúzaquezu'. Bechuj chee̱ lba uva na', ba bzua chuchu' gaca na chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Benne' ca' dxeledábague̱' netu' ba gulechúgue̱' lba na', ne ba guládue̱' na xi'. Gunná' benne' ca' lu xel-la' dxezrá'a chiu', ne bzria xi' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Bzua chuchu, ne bxue benne' ca' ba guca'u, benne' xe̱zr la xu na' ba nuzúa chuchu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Cabátadxa cueaj xíchajntu' Lue' xecha lasa. Bcache chawe' netu', naca bantu', na' güe lá'anantu' Lau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Xránantu' Dios, napu' dute̱ xel-la' waca, beché̱' netu'. Bexache lazre' netu', na' lantu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Lu dute̱ xel-la' dxebé le gul-la chee̱ Dios, Bénnea' dxutipe̱' lázredxu. Lu da ba neza chee̱le le cuezre xa'a lau Dios chee̱ zri'ine zre sua Jacob. ");
INSERT INTO zatNTps_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Le gul-la, ne le capa xídedau'. Le quinne xrtan da con zríadi'i na du, ne da dxúl-lale̱nle. ");
INSERT INTO zatNTps_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Le gucuezre luzu da dxulucuezre̱' gate naca beu' dxe'ene, da naca na zra nuzúadxu gundxu laní lá'azxa. ");
INSERT INTO zatNTps_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Naca na tu da dxun na ba xen xelún benne' Israel ca', da bdxixruj bea Dios xelún zri'ine zre sua Jacob. ");
INSERT INTO zatNTps_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Bzue̱' na ca tu da gulé'e lau na zri'ine zre sua José gate beledxúaje̱' lu xe̱zr la xu Egipto, naga benda' tu xrtizra' bénneache da quebe guxéajni'ida'. ");
INSERT INTO zatNTps_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Gunná Dios: “Begúa' xua' da buludé̱'e̱' benne' chia' ca'. Bsezrá'a benne' chia' ca' da zi'i.” ");
INSERT INTO zatNTps_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Lu da ba xa' da guzúale, bláwizrale neda', na' bselá' le'e. Beche̱ba' chee̱le naga nagacha' lu beuj bza gate na' gunné̱le̱'e̱ guziu', na' bxua' ájala gunle naga zaj de̱ beaj nisa zaj nazí le Meriba. ");
INSERT INTO zatNTps_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Le xene, bénneache chia', na' gusízreda' le'e. Le'e, benne' Israel, che dxaca lázrele sile da dxennía', ");
INSERT INTO zatNTps_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","quebe gápale tu dios chee̱ benne' xula, ne quebe guzú zríbele lau tu dios chee̱ benne' zitu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Neda', Xránale, naca' Dios chee̱le. Bebéaja' le'e lu xe̱zr la xu Egipto. Le salaj dxú'ale, na' gunna' da gágule. ");
INSERT INTO zatNTps_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Bénneache chia' quebe belúe lazre̱' da gunnía'. Benne' Israel ca' quebe gulaca lazre̱' xelezí' lu ne̱'e̱ neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Chee̱ le̱ na' bsana' benne' ca' lawe' da gulaque̱' lázxdau zide'. Belune̱' ca da guléquene̱' xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Che la gulebé' gunne xue bénneache chia' chee̱ da gunnía', ne che la belún benne' Israel ca da ble'eda' le̱', ");
INSERT INTO zatNTps_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","na' chadite̱ bzria xi'a benne' guledábague̱' le̱', ne gudíl-lale̱na' benne' guledíl-lale̱ne̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Che la belún benne' Israel caní, na' benne' ca' dxelecuídene̱' Xránadxu buluzúe̱' xrtizre̱', (san chadía chacanna zaj nabague̱' zria), ");
INSERT INTO zatNTps_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","na' Dios gune̱' xelawe̱' zrua' xtila cháwedau', ne gune̱' xelélajquezne̱' nen bzrína'dau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Zua Dios naga zaj nazraga benne' dxuluchi'e̱ chee̱ bénneache chee̱'. Dios dxuchi'e̱ chee̱ benne' ca' dxuluchi'e̱ chee̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Dxenná Dios: “¿Bátadxa guchí'ale chee̱ bénneache chia' da quebe naca xrlátaje, ne gápale ba lá'ana benne' ca' zaj nabéaj xíchaje̱' Dios?” ");
INSERT INTO zatNTps_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Le gácale̱ benne' xache' ca', ne bidau' we̱ze̱be ca'. Le gun da xrlátaje chee̱ benne' baxache' ca' ne chee̱ benne' ca' dxelexázrjene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Le guselá benne' ca' dxeledée̱' lu da ba xa', ne benne' ca' quebe bi zaj nape̱'. Le guselá benne' ca' lu na' benne' ca' zaj nabéaj xíchaje̱' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Quebe bi zaj nézene̱', ne quebe dxeléajni'ine̱', na' dxeledé̱' lu da chul-la. Dxuluzrizre̱' ca naca da zaj de̱ lu xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Neda' gunnía': Le'e nácaquezle ca dios ca', ne nácale xúgute̱le ca zrí'inequeze Dios szrente̱, ");
INSERT INTO zatNTps_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Wátele ca dxelate xezícadxa bénneache, na' cheajcházele ca cheajchaze nútete̱ze benne' dxenná be'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","¡Guxasa, Dios! ¡Bchi'a chee̱ bénneache zaj zra' lu xe̱zr la xu, lawe' da naca dute̱ xe̱zr la xu chiu' Lue'! ");
INSERT INTO zatNTps_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","¡Dios, quebe sua zriu'! Quebe su' zrize, Dios, ne quebe gusezxuj dxu'u, ");
INSERT INTO zatNTps_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","lawe' da dxelebezre xa'a benne' ca' dxeledábague̱' Lue', ne dxulucá'ana szren cuina benne' ca' dxelecuídene̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Bagácheze ba zaj nune̱' tuze dizra' bi xelune̱' chee̱ bénneache chiu', ne ba zaj nune̱' bi xelune̱' chee̱ benne' ca' dxuxúequezu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Gulenné̱': “Le chu'u, guzría xidxu benne' ca' chee̱ québedxa xelaque̱' tu cue' xe̱zr la xu, ne québedxa nu sua benne' cheajsá lazre̱' la Israel.” ");
INSERT INTO zatNTps_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Ba belune̱' tuze dizra'. Zaj nune̱' tuze dizra' xeledábague̱' Lue' ");
INSERT INTO zatNTps_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","benne' Edom ca', ne benne' Ismael ca', ne benne' Moab ca', ne benne' zri'ine zre sua ca' Agar, ");
INSERT INTO zatNTps_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","ne benne' Gebal ca', ne benne' Amón ca', ne benne' Amalec ca', ne benne' Filistea ca', ne benne' zaj zre̱'e̱ xe̱zre Tiro. ");
INSERT INTO zatNTps_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Cá'anqueze benne' Asiria ca' zaj nune̱' le̱' tuze. Xúgute̱ benne' caní dxelune̱' zrin chee̱ zri'ine zre sua Lot. ");
INSERT INTO zatNTps_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Be̱n chee̱ benne' caní ca be̱nu' chee̱ benne' Madián ca', ne ca be̱nu' chee̱ Sísara, ne ca be̱nu' chee̱ Jabín dxu'a xe̱gu Cisón, ");
INSERT INTO zatNTps_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","benne' ca' gulátie̱' lu xe̱zr la xu Endor, na' belexaque̱' ca xrche̱'e̱ be̱zre da gun na be̱be lu xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Be̱n gaca chee̱ benne' blau ca' chee̱ benne' caní ca guca chee̱ Oreb, ne chee̱ Zeeb, ne be̱n gaca chee̱ benne' dxelenná bé'ene̱' benne' caní ca guca chee̱ Zeba, ne chee̱ Zalmuna, ");
INSERT INTO zatNTps_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","lawe' da gulenná benne' caní: “Gaca chee̱dxu xe̱zr la xu naga zaj zra' bénneache chee̱ Dios.” ");
INSERT INTO zatNTps_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Dios chia', be̱n xelaque̱' ca xizre be̱be da dxua be' gate dxedube na. Be̱n xelaque̱' ca xrlácue xia xéladu ca' da dxua be' bdunu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Ca dxun tu xi' da dxuzezxe na tu xi'a zren, ne ca dxun xi' da dxuzezxe na tu din zren, ");
INSERT INTO zatNTps_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","ca'an gudáu zi' xuzre benne' caní tu lu be' bdunu', ne bchebe le̱' nen tu be' bdunu' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","Be̱n xelexedué'ele̱'e̱ne̱', ne be̱n xelape̱' Lue' ba lá'ana, Xran. ");
INSERT INTO zatNTps_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Be̱n xeleque zréajene̱' ne xelezúa sté̱bele̱'e̱ tu chí'izqueze. Be̱n xelexegá'ana dítaje̱', ne xelexenítie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Be̱n xelexúnbe'e̱ nacu' Lue' Xránantu' Dios. Tuzu' Lue' nacu' Dios zrente̱ lawe' dute̱ xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Nazrí'ile̱'e̱da' xudau' chiu' Lue', Dios, napu' dute̱ xel-la' waca. ");
INSERT INTO zatNTps_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Dxaca lázrele̱'e̱da' sua' ga na', ne dxezá lazra' sua' lu xudau' chiu', Xran. Dute̱ da naca', ne dute̱ lázrdawa' dxul-la' chiu' Lue', Dios ban. ");
INSERT INTO zatNTps_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Ba belún chje̱gu ca' xrú'uneba', na' buchuj ca' zaj de̱ lataj naga dxuluzríaba' biadu chee̱ba' ca' naga zua lu cugu chiu' Lue', Dios, napu' dute̱ xel-la' waca. Nacu' Lue' Wenná Bea chia', ne Dios chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Ba neza zrente̱ naca na chee̱ benne' ca' zaj zre̱'e̱ xudau' chiu'. Chadía chacanna xelúe lá'anaqueze̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Ba neza zrente̱ naca na chee̱ benne' ca', Lue' dxuzúa chuchu' le̱', benne' ca' dxelezá lazre̱' chjaque̱' xi'a lá'azxa chiu', xi'a Sión. ");
INSERT INTO zatNTps_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Gate dxeledée̱' lache' bizre nazí le na Lache' Nisa Dxebézredxu, dxexaca na lataj naga dxalaj nisa, na' gusezrá nisa xiuj ca zaj naca beaj ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Dxelácadxe̱' benne' wal-la dxácate̱ ne zaj xu'e̱ neza lawe' da xelelé'ene̱' Dios lu xi'a lá'azxa chee̱', xi'a Sión. ");
INSERT INTO zatNTps_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Bene, Xran, ca naca da dxenaba' Lue', Dios, napu' dute̱ xel-la' waca. Bene, Dios, nacu' Dios chee̱ Jacob. ");
INSERT INTO zatNTps_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Be̱n da xrlátaje chee̱ benne' wenná bea chee̱ntu', Dios, benne' wenná bea na' guca'u Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Cháwedxa naca sua' tu zraze lu xudau' chiu' quézcala sua' chi gaxúa iza naga xula. Dxaca lazredxa' sua' dxa xu'a xudau' chee̱ Dios chia' ca tu benne' nada'u, quézcala súaqueza' tu lizra' zaca naga quebe zua Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Xránadxu Dios naque̱' Benne' dxuxúe̱' dxi'u, ne Benne' Wenná Bea xabáa chee̱dxu. Dxune̱' dxi'u da chawe' dute̱ xel-la' zri'i lazre' chee̱', ne dxune̱' dxelapa bénneache dxi'u ba lá'ana. Quebe xezúene̱' zi' gune̱' da chawe' chee̱ benne' ca' zaj naque̱' du lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","¡Dios, napu' dute̱ xel-la' waca! ¡Ba neza zrente̱ naca na chee̱ benne' ca' dxuluxrén lazre̱' Lue'! ");
INSERT INTO zatNTps_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Be̱nu' da xrlátaje chee̱ bénneache chiu', Xrana' Dios. Be̱nu' belexelá zri'ine zre sua Jacob, benne' ca' gulu'e̱ lu na' benne' zitu' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Bnite lau' da zrinnaj da belún bénneache chiu'. Bdeu' chalá'ala ca zaj naca dul-la chee̱ benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Bzua zriu' xel-la dxezrá'a chiu', ne bsanu' xel-la' xichaj zra'a chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Be̱n xezúantu' lu da ba neza chee̱ xel-la' weselá chiu', Dios, ne québedxa zra'u netu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","¿Tu chí'izqueze zra'u netu'? ¿Wazrá'aquezu' tu cuen tu cuen zri'ine zre suantu'? ");
INSERT INTO zatNTps_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","¿Québedxa gunu' xexaca bantu', chee̱ súantu' lu da ba neza lau Lue'? ");
INSERT INTO zatNTps_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","¡Xran, bexache lazre' netu', ne bselá netu'! ");
INSERT INTO zatNTps_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Guzé̱ naga' da nne̱ Xrana' Dios. Nne̱' da guzúa na bénneache chee̱' lu xel-la' dxebeza zri lazre', chee̱ québedxa xelún benne' lá'azxa chee̱' da xálaze. ");
INSERT INTO zatNTps_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Da líqueze Le̱' zúate̱queze̱' guselé̱' benne' ca' dxelezrebe̱' Le̱', chee̱ sua da xabáa chee̱' lu xe̱zr la xu chee̱dxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Zaj nazraga xel-la dxexache lazre', ne da li chee̱ Dios. Zaj naca tuze da xrlátaje, ne xel-la' dxebeza zri lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Da li chee̱' gusezrá na xe̱zr la xu nigá, na' sel-le̱' da xrlátaje chee̱' da za xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Xránadxu gúnnaqueze̱' dxi'u da cháwedau', na' gúnnale̱'e̱ xe̱zr la xu chee̱dxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Nu benne' naque̱' xrlátaje waca xezrine̱' lau Dios, na' gune̱' gundxu ca da ba blé'ene̱' gundxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Bze̱ naga, Xran, ne bene chia', lawe' da zua' lu da ba xa', ne dxexázrjeda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Bxue neda' lawe' da naca' chiu'. Bselá neda', Dios chia', naca' we̱n zrin chiu', ne dxuxrén lazra' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Bexache lazre' neda', Xrana' Dios, lawe' da dxuláwizra' Lue' te zra chizrela. ");
INSERT INTO zatNTps_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Be̱n béle̱'e̱da' neda', we̱n zrin chiu', lawe' da dxuzúa cuina' lau Lue', Xran, ");
INSERT INTO zatNTps_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","na' Lue', Xran, nacu' xrlátaje, ne dxunite lau' chee̱ntu'. Zúate̱quezu' xexache lazru' benne' ca' dxululáwizre̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Xrana' Dios, bene da dxuchálajle̱na' Lue', ne bze̱ naga ca da dxenaba' lau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Lu zra sua' lu da sté̱bele̱'e̱ wanné̱queza' Lue', lawe' da dxexeché̱bequezu' Lue' chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Xran, quebe nu chilá' Dios ca Lue', ne quebe nu dxun ca da dxunu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Xelelá' bénneache dute̱ xe̱zr la xu da be̱nu' Lue', na' xelúe lá'anaqueze̱' Lue', Xran, ne xulucá'ana szrene̱' Lau' Lue', ");
INSERT INTO zatNTps_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","lawe' da nacu' Lue' szren, ne dxunu' da dxexebánentu'. Tuzu' Lue' nacu' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Bse̱de neda' da dxaca lazru' guna', Xrana' Dios, na' guna' ca naca da li chiu'. Gunná be'e lázrdawa' chee̱ zreba' La cuinu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Dute̱ lázrdawa' güe lá'anaqueza' Lue', Xrana' Dios, ne gucá'ana szrénqueza' Lau' chadía chacanna, ");
INSERT INTO zatNTps_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","lawe' da zúate̱quezu' xexache lazru' neda', ne bseláu' bénne'du xu'a lu lataj ba xa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Dios, belasa benne' dxulucá'ana szren cuine̱', ne dxeledábague̱' neda', na' benne' xichaj zra'a ca' belune̱' tuze dizra' xelútie̱' neda', ne quebe dxelezrebe benne' ca' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Lue', Xrana', nacu' Dios dxexache lazru' netu', ne nacu' zren lazre', ne quebe dxezrá'azeu', san zúate̱quezu' xexache lazru' netu', ne nacu' li lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Gunná' ca naca chia', ne bexache lazre' neda'. Be̱nna chia' neda', we̱n zrin chiu', xel-la' waca chiu', na' bxue neda', zri'ine nu'ula we̱n zrin chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Ble'e neda' tu da gaca bea na gaca chawe' chia', ne be̱n xelelé'e benne' ca' dxelecuídene̱' neda' da na', ne be̱n xelexedué'ene̱', lawe' da nacu' Lue', Xrana' Dios, Bénnea' gúcale̱ne̱' neda', ne bexúe zrene̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Lane xe̱zre Sión zria na lu xi'a lá'azxa. ");
INSERT INTO zatNTps_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Nazrí'idxa Xránadxu Dios lataj naga dxuluchi'a benne' zaj zre̱'e̱ xe̱zre Sión, ca nazrí'ine̱' xúgute̱ xu'u lizre zri'ine zre sua Jacob. ");
INSERT INTO zatNTps_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Da xrtante̱ ca' dxelenná bénneache ca naca xe̱zre chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Cheajsá lazra' lu xe̱zr la xu Egipto, ne lu xe̱zr la xu Babilonia ga na' zaj zra' bénneache zaj núnbe'e̱ neda'. Le nna' xque, lu xe̱zr la xu Filistea, ne lu xe̱zre Tiro, ne lu xe̱zr la xu Etiopía gulalaj benne' caní zaj naque̱' chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Ca naca chee̱ xe̱zre Sión nnia': Benne' nigá, ne bénnea' gulálaje̱' ga na', na' neda', Dios zrente̱, guzúa chúchua' xe̱zre na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Gate gulaba Xránadxu Dios benne' ca' zaj naque̱' chee̱', nne̱': “Benne' nigá gúlaje̱' lu xe̱zre na'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Benne' ca' dxelul-le̱', ne benne' ca' dxeline̱' xide xelenné̱': Ca naca da ba neza zúantu' lu xe̱zre na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Xran, nacu' Dios dxuseláu' neda'. Te zra, ne chizrela dxuláwizra' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Bene da dxuchálajle̱na' Lue', ne bze̱ naga da dxuláwizra' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Dxedú lazra' lu da cale̱la ca' da dxaca na chia', ne ba zua' gatia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Dxeleque bénneache neda' ca tu benne' gate, lawe' da dxátele̱'e̱ ni'a na'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Nagá'ana' cá'aze ládujla benne' gate. Naca' ca benne' gulátie̱' lu wedil-la, ne zaj de̱' xe̱dxu ba ca', benne' ca' québedxa dxajsá lazru', Dios, ne québedxa zaj xu'e̱ lu na'u Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Dxaca chia' cáte̱ze ba nuzú' neda' tu xe̱dxu zren naga naca chul-la, ne nácale̱'e̱ situj. ");
INSERT INTO zatNTps_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Dxéqueda' dxezrá'le̱'u neda'. Da dxaca chia' naca na ca dxazia' zran xeajxruza zri'a chee̱ nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Be̱nu' belexebiga bi ljwezra' ca' naga zua'. Be̱nu' neda' ca tu da dxusegute na benne' ca'. Naca' ca tu benne' xu'e̱ lizre xia ne quebe gaca xedxúaje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Dxelechul-la xiaj lawa' ne̱ chee̱ da dxezí dxezaca'. Xúgute̱ zra dxuláwizra' Lue', Xrana' Dios. Dxechisa na'a lau Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","¿Dxúnquezu' xel-la' waca chee̱ xabáa dxácale̱nu' benne' gate ca'? ¿Dxelexasa benne' gate ca' dxelúe lá'ane̱' Lue'? ");
INSERT INTO zatNTps_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","¿Dxuluchalaj benne' zaj nagache̱' lu xe̱dxu ba chee̱ xel-la zri'i lazre' chiu', na' dxuluchalaj chee̱ da li lazre' chiu' benne' zaj xu'e̱ lataj chul-la chee̱ benne' gate ca'? ");
INSERT INTO zatNTps_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","¿Welexúnbea benne' zaj xu'e̱ lataj chul-la na' ca naca da zrente̱ da dxunu', na' welexúnbea benne' zaj xu'e̱ naga quebe nu dxajsá lazre' le̱' ca nacu' xrlátaje? ");
INSERT INTO zatNTps_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Neda' dxuláwizra' Lue', Xrana' Dios. Xúgute̱ zila dxezrín lau' da dxenaba' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","¿Bizr chee̱ na' dxebéaj xíchaju' neda', Xran? ¿Bizr chee̱ na' quebe dxenná'u neda' chee̱ gácale̱nu' neda'? ");
INSERT INTO zatNTps_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Dxezí dxezaca', ne ba zua' gatia'. Nácatea' bi cuíde'te̱ dxedéa' xel-la' zi' da dxudeu' neda', na' dxedú lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Dxéqueda' dxezrá'le̱'u neda'. Da dxuchebu' neda' ba bsedú na lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Zaj naxechaj da caní neda' du zra. Dxulusaca zi na neda' gátete̱ze na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Be̱nu' belexebiga bi ljwezra' ca' naga zua', na' tuze da naca chul-la dxedále̱ na neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Tu gúl-lazqueza' chee̱ xel-la' zri'i lazre' chiu', Xran. Guzenda' tu cuen tu cuen zri'ine zre súantu' nacu' li lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Nezda' tu súazqueze xel-la zri'i lazre' chiu', ne chadía chacanna zua xel-la li lazre' chiu', cáte̱ze zúaqueze xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Lue' gunnáu': “Be̱na' xel-la wezría nen bénnea' ba gucá'a. Guche̱be lazra' chee̱ David, we̱n zrin chia', ");
INSERT INTO zatNTps_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","gunnia': Guna' tu cházqueze zri'ine zre su'. Guna' xelenná be'e̱ tu chí'izqueze lu waláz chiu'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Benne' zaj zra' xabáa dxelúe lá'ane̱' Lue', ne̱ chee̱ da zrente̱ ca' da dxunu', Xran, ne ne̱ chee̱ xel-la' li lazre' chiu', naga zaj nazrague̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Quebe nu zua xabáa, benne' naque̱' ca Lue', Xran. Quebe nu zua benne' szrente̱, benne' naque̱' ca Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Benne' zaj zra' xabáa dxelape̱' Dios ba lá'ana, na' xúgute̱ benne' ca' zaj nazraga chee̱' dxelezrebe̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Xran, nacu' Dios chee̱ benne' zante̱, benne' zaj zra' xabáa. Quebe nu zua, benne' naque̱' ca Lue', Xran. Nacu' Benne' wál-late̱, ne tu nácazquezu' li lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Xu'u lu na'u xeajxruza zren chee̱ nísadau'. Gate dxelasa xeajxruza ca' Lue' dxebeque zriu' na. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Bchúchuju' benne' Egipto ca', na' belexegá'ane̱' ca tu da gate. Be̱se dínnaju' benne' ca' dxeledábague̱' lue' nen na'u wál-late̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Chiu' Lue' naca xabáa, ne chiu' Lué'queze naca xe̱zr la xu. Be̱nu' xe̱zr la xu nigá, ne da ca' zaj nnita lawe na. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Be̱nu' da de̱ chalá'a naga za' be' zaga, ne da de̱ chalá'a naga dxedé gubizra beu' zaga ca'. Xel-la dxelebé dxelul-la chiu' xi'a Tabor, ne xi'a Hermón. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Benne' wál-late̱ nacu' Lue'. Da zrente̱ naca xel-la waca chiu', ne nagá'ana szren na. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Lu da xrlátaje, ne lu da li lazre' dxenná be'u. Lu xel-la zri'i lazre', ne lu da li lazre' zaj zua ca da dxunu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Ba neza zrente̱ naca na chee̱ benne' ca' dxelul-le̱' da dxue lá'ana na Lue', ne zaj zue̱' lu xel-la naxaní' chiu', Xran. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Ne̱ chiu' Lue' dxelebéle̱'e̱ne̱' du zra, ne dxulucá'ana szrene̱' Lue' ca naca da xrlátaje chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Lué'queze nacu' xel-la wal-la chee̱ benne' ca', ne xel-la xrtan chee̱'. Dxúnnadxu' netu' xel-la' waca lawe' da ca' dxéquenu' xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Xránadxu Dios dxucu'uje̱' dxi'u, na' Dios lá'azxa chee̱ benne' Israel ca' naque̱' Wenná Bea chee̱dxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Nédxudaute̱ bchálaju' lu da blé'enu' benne' we̱n zrin chiu' ca', benne' zaj naque̱' li lazre', gunnáu': Ba gucá'a tu benne' wal-la ládujla bénneache chia', ne ba bzua' le̱' gaque̱' wenná bea, ne dxácale̱na' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Ba gucá'a David, we̱n zrin chia'. Bzúaqueza' le̱' gaque̱' wenná bea. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Neda' tu gácale̱zqueza' le̱'. Xel-la waca chia' gutípaqueza' lazre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Benne' ca' guledábague̱' Le̱' quebe xelezéquene̱' bi xelune̱' chee̱', na' benne' ca' dxelune̱' da cale̱la quebe xelezéquene̱' xuluchúchuje̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Guchúchujqueza' benne' dxeledábague̱' Le̱', ne gucuasa' benne' ca' lau le̱'. Guna' we̱' benne' ca' dxelecuídene̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Tu zrí'izqueza' le̱', ne gaca' li lazre' nen le̱', na' ne̱ chia' neda' gápadxe̱' xel-la' wal-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Guna' nna be'e̱ dute̱ dxu'a nísadau' zren, ne dute̱ dxu'a xe̱gu Eufrates. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Le̱' xe̱'e̱ neda': “Lue' nacu' Xra'. Nacu' Dios chia', dxucu'uju' neda', ne dxuseláu' neda'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Neda' guzúa' le̱' ca zri'ina' blau, na' nna bé'ene̱' xúgute̱ benne' wenná bea zaj zre̱'e̱ lu xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Tu chí'izqueze nuzúa' chee̱' xel-la' zri'i lazre' chia', na' ca naca xel-la' wezría chia' gaca líqueze na nen le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Guna' tu cházqueze zri'ine zre sue̱', na' xelenná be'e̱ lu waláz chee̱' dxácate̱ ne zua xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Che xulusán zri'ine zre sua David da nadxixruj be'a, ne che quebe xelune̱' ca da nuchi'a chee̱', ");
INSERT INTO zatNTps_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","ne che xelecuase̱' lu da dxenná be'a, ne che quebe xelune̱' ca da dxapa' le̱', ");
INSERT INTO zatNTps_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","na' gu'a le̱' zrise lawe' da dxeledábague̱' neda', ne quina' le̱' xide lawe' da dxelune̱' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Quebe gusana' ca nazrí'ida' David, ne quebe gusana' gaca' li lazre' nen le̱', ");
INSERT INTO zatNTps_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","ne quebe gal-la lazra' xel-la' wezría da nuna', ne quebe guchá'a ca da ba gunnía'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Tu lásaze bzetaj cuina' guche̱be lazra', na' cabata' gun lazra' chee̱ David, ");
INSERT INTO zatNTps_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","gunnia': Tu cházqueze zri'ine zre sue̱', na' xelenná be'e̱ lu waláz chee̱' lawa' neda' dxácate̱ ne zua gubizra. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Xel-la' dxenná bea chee̱' tu sua chúchuzqueze na ca zua beu' zran xabáa. Tu sua chúchuzqueze na dxácate̱ ne zua xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Lue', Dios, guleaj xíchaju', ne bzu' chalá'ala bénnea' guca'u, ne dxezrá'le̱'u le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Nuzú' chalá'ala xel-la' wezría bé̱nle̱nu' David, we̱n zrin chiu', ne nucá'ana dítaju' xel-la' dxenná bea chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Nuxrínnaju' ze'e da naxechaj na xe̱zre zréntau' chee̱', ne nuzría xi'u ca naca lataj wal-la chee̱' chee̱ wedil-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Xúgute̱ bénneache, benne' dxeledaze ga na' dxelebane̱' chee̱ da zaj de̱ chee̱', na' benne' xe̱zre walízr chee̱' dxelún le̱' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Ba be̱nu' bedxúaj chawe' benne' guledábague̱' Le̱', na' dxelebéle̱'e̱ne̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Be̱n dítaju' da ca' dxuchínene̱' lu wedil-la, ne quebe gúcale̱nu' le̱' lu wedil-la na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Ba gudú' ca naca da xrtante̱ chee̱', ne nucá'ana dítaju' xel-la' dxenná bea chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Be̱nu' naque̱' ca tu benne' gula gate ne zue̱' iza cuide' chee̱', ne bsi'u le̱' xel-la' stu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","Xrana' Dios, ¿bátaqueze quebe xennu' chee̱ntu'? ¿Tu chí'izqueze dxezrá'aquezu' netu'? ");
INSERT INTO zatNTps_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Bsa lazre' látega sua' lu xe̱zr la xu. Látega nunu' xel-la' nabán chee̱ xúgute̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Quebe zua nu benne' gaca bane̱' tu chí'izqueze. Xúgute̱' xelatie̱'. Quebe zua nu benne' le̱' lu na' xel-la' gute. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Xran, ¿ba bsanu' David, ne québedxa nazrí'inu' le̱', ca bzetaj cuinu' guche̱be lazru' zrí'iquezenu' le̱'? ");
INSERT INTO zatNTps_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Gunná' xque, Xran, ca dxelún le̱' chia' neda', we̱n zrin chiu', ne ca dxuchaga lawa' da dxelún lala benne' xúgute̱ xe̱zr la xu chia' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Benne' ca' dxeledábague̱' lue' dxulucá'ana dítaje̱' bénnea' guca'u Lue', Xran. Dxulucá'ana dítaje̱' le̱' gátete̱ze zéaje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Ba neza zrente̱ gaca Xránadxu Dios chadía chacanna. Ca' naca na, ne ca' gaca na. ");
INSERT INTO zatNTps_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Xránantu' Dios, ba cua ba cua, Lue' nacu' ca tu xu'u naga zra cháwentu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Nédxudaute̱ ca za gunu' xi'a zri'a ca', ne ca za sua xe̱zr la xu, ne bénneache, na' nédxudaute̱, ne lu da za za' nácaquezu' Lue' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Dxu'u bénneache xelexaque̱' da gulaque̱', dxelexaque̱' xu xrte. ");
INSERT INTO zatNTps_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Chiu' Lue' chi gaxúa iza zaj naca na ca neaje, da ba gudé na, ne ca tu chí'idau'ze chizrela. ");
INSERT INTO zatNTps_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Dxegú' bénneache ca dxun guba'u, da dxua na xúgute̱ xizre laga ca'. Zaj naque̱' ca tu bchigala da dxexenite na gate dxexebandxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","Zaj naque̱' ca tu xixre' da dxegula na che zílala. Dxegula na, ne dxelá'te̱ na xiaj, na' xelate' zua gubizra dxelechugue̱' na, na' dxebizre na. ");
INSERT INTO zatNTps_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Dxebía xi'ntu' lawe' da dxezra'u netu'. Sté̱bele̱'e̱ zúantu' lawe' da dxezrá'le̱'u netu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Dxenna'u ca da cale̱la da nuntu'. Dxulé'enu' láwela zria da nabágantu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Dxuzáchiu' iza chee̱ntu' lawe' da dxezra'u netu'. Dxelexedú iza chee̱ntu' ca tu be' da dxecá'antu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Ca zaj naca zra naca bantu', zaj naca na ga xun chi iza, na' che nácantu' benne' wal-la, waca bantu' du tápalalaj iza, san ca zaj naca iza ca', dxedentu' xel-la' zi', ne dxéquentu' ze̱de. Chadí dxeledé iza ca', na' xenítentu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","¿Nuzra núnbea xanne' ca naca xel-la' dxezrá'a chiu'? ¿Nuzra núnbea ca naca xel-la' xichaj zra'a chiu'? ");
INSERT INTO zatNTps_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Ble'e netu' ca láteze zaj naca zra chee̱ntu' chee̱ gácantu' benne' dxeléajni'ine̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Xran, bexaca netu' tuze. ¿Bátadxa chenu'? Bexache lazre' netu', we̱n zrin chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Tu tu zila bzua xichaj lázrdauntu' xel-la' zri'i lazre' chiu', na' dute̱ xel-la' dxebé tu gul-lazquezentu' chiu' xúgute̱ zra naca bantu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Be̱nna netu' zane' iza chee̱ bentu' ca zaj naca iza bsaca zi'u netu', ne ca zaj naca iza guzúantu' lu da ste̱be. ");
INSERT INTO zatNTps_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Be̱ lataj netu', we̱n zrin chiu', le'entu' da zrente̱ da dxunu', ne xelelé'e zri'ine zre suantu' da xabáa chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Xránantu' Dios, be̱n gaca chee̱ntu' da chawe' chiu'. Be̱n chepe ban ca naca zrin dxuntu'. Awe', Xran, be̱n chepe ban ca naca zrin dxuntu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Bénnea' dxuxrén lazre̱' Xránadxu Dios chee̱ guxúe̱' le̱', ne dxuzúe̱' Dios, Bénnea' nape̱' dute̱ xel-la' waca, chee̱ gácale̱ne̱' le̱', ");
INSERT INTO zatNTps_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","waca xe̱'e̱ Dios: Nacu' Bénnea' dxebeza lazra', ne Bénnea' dxucache chawe̱' neda'. Nacu' Dios chia', na' dxuxrén lazra' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Dios gucache chawe̱' lue' lu xúgute̱ da ste̱be da quebe zaj nalá', ne lu xúgute̱ xízrawe̱' da dxelute na bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Gucache chawe̱' lue' ca dxun tu bedxuj dxé̱zreba' biadu chee̱ba' zran xrílaba', na' chu'u chawu' lu na' Le̱'. Xel-la' li lazre' chee̱' gácale̱ na lue', ne gucache chawe na lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Quebe bi guchebe lue' chizrela, ne quebe bi da ste̱be te zra, ");
INSERT INTO zatNTps_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","ne quebe bi xízrawe̱' chee̱ da chul-la, ne quebe bi da cale̱la ca' da dxelute na bénneache te zra. ");
INSERT INTO zatNTps_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Welate chi gaxúa bénneache cuitu' lue', ne gaxúa gaxúa bénneache gáguze naga zu', san quebe bi sacu' lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Wanna'u, na' walé'enu' ca ba xa' xeledé benne' ca' dxelune̱' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Nuzú' Xránadxu Dios ca Benne' dxebeza lazru', ne Dios, Bénnea' nape̱' dute̱ xel-la' waca, chee̱ gucache chawe̱' lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Chee̱ le̱ na' quebe bi da cale̱la gaca na chiu', ne quebe bi xízrawe̱' chu'u na lizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Dios gusebague̱' gubáz chee̱ xabáa chee̱' ca' chee̱ xelácale̱ne̱' lue', na' xuluxúe̱' lue' gátete̱ze chéaju'. ");
INSERT INTO zatNTps_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Xeluxre̱' lue' lu ne̱'e̱ chee̱ quebe ga'a xiaj ni'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Guléajquezu' be̱zre xixre' ca', ne be̱la' ca', be̱zre xixre' schanní' ca', ne be̱ snia ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Dxenná Dios: “Guselá' xúgute̱ benne' ca' zaj nazrí'ine̱' neda', ne gucache chawa' benne' ca' dxelexeche̱be̱' naca' Xrane̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Gate xelenné̱' neda', na' xeche̱ba' chee̱'. Gate zaj xu'e̱ lu da ste̱be, súale̱queza' le̱'. Guselá' le̱', ne guna' le̱' ba lá'ana. ");
INSERT INTO zatNTps_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Guna' xelaca bane̱' zánete̱ iza, ne guselá' le̱'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Chawe' naca dxue lá'anantu' Lue', Xrana' Dios, ne gúl-lantu' da dxucá'ana szren na Lue', Dios szrente̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Chawe' naca dxuzénentu' bénneache tu zra tu zra ca dxexache lazru' netu', na' dxe̱la dxulé'entu' nacu' li lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","Dxúl-lantu' da caní, dxínnentu' da dxúl-lale̱ntu' da ze̱ chi du chee̱ na, ne dxínnentu' da con zríadi'i na du da dxenné̱le̱'e̱ xrtandau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Xrana' Dios, ne̱ chee̱ da dxunu' Lue', dxunu' dxebéle̱'e̱da'. Ca zaj naca da nun na'u zua' lu da ba neza. ");
INSERT INTO zatNTps_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Da zrente̱ zaj naca da nunu', Xrana' Dios. Da zrénle̱'e̱ zaj naca da dxugú'u lazru' gunu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Québequeze neze benne' lázxdau zide', ne quebe dxéajni'i benne' xala ca naca da nigá. ");
INSERT INTO zatNTps_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Gate dxelegula benne' dxelebéaj xíchaje̱' Dios ca dxegula xixre', ne dxe̱pe ban da dxelún benne' we̱n da zrinnaj, naca na chee̱ xelebía xi'e̱ tu chí'izqueze. ");
INSERT INTO zatNTps_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Lue', Xrana' Dios, tu nácazquezu' Dios szrente̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Dxunna bea na ca gaca chee̱ benne' dxedábague̱' Lue', Xrana' Dios. Dxunna bea na xelebía xi' benne' ca' dxeledábague̱' Lue'. Xelase dinnaj xúgute̱ benne' ca' dxelune̱' da zrinnaj. ");
INSERT INTO zatNTps_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Lue' dxunu' dxezrendxa xel-la' wal-la chia' ca naca xel-la' wal-la chee̱ be̱zre. Dxugú'u da za xíchaja' da dxutipa na lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Dxal-la' le'eda' xelezrá' zran ni'a benne' dxeledábague̱' neda', na' xenda' xelebezre xache' benne' ca' guledíl-lale̱ne̱' neda', benne' ca' dxelune̱' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Welexán benne' xrlátaje ca' ca dxun xaga zina'. Xelegule̱' ca dxun xaga cedro lu xi'a Líbano. ");
INSERT INTO zatNTps_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Zaj naque̱' ca tu xaga ze̱ na lu xudau' chee̱ Xránadxu Dios, da dxegúlale̱'e̱ na lu chale'aj chee̱ xu'u lizre Dios chee̱dxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Zaj naque̱' ca xaga ca' dxelebía da zixre chee̱ na gate ba zaj nagula na, ne zaj naca na xaga xa'a wal-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Benne' caní xuluzenne̱' bénneache naca li lazre' Xrana' Dios, Bénnea' dxuzé̱ chúchue̱' neda', ne quebe bi zúale̱ Le̱' da quebe naca xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Xránadxu Dios naque̱' Wenná Bea, ne nacue̱' zra lane̱' da zácale̱'e. Nácue̱' zra lane̱', ne da nagú'u le̱'e̱ naca na xel-la' waca zren. Nuzúa chúchue̱' xe̱zr la xu nigá, na' quebe nu seque' gutá na. ");
INSERT INTO zatNTps_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Lataj naga dxe'u dxenná be'u, Xran, zua chuchu na nédxudaute̱, na' Lue' zúaquezu' chadía chacanna. ");
INSERT INTO zatNTps_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Dxelebezre xa'a xe̱gu ca', Xran. Dxelebezre xa'a na, ne dxelenné̱ na zizraj. ");
INSERT INTO zatNTps_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Xránadxu, Bénnea' zue̱' xabáa nápadxe̱' xel-la' waca ca da zaj napa xe̱gu ca' dxelebezre xa'a na, ne ca da zaj napa xeajxruza chee̱ nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Chúchule̱'e̱ zaj naca da nadxixru be'u, Xran. Lá'azxa nácaqueze xudau' chiu' chadía chacánnaqueze. ");
INSERT INTO zatNTps_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Xrana' Dios, dxebéaj lazru' bénneache. Lue', Bénnea' dxebéaj lazre̱' bénneache, ble'e cuinu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Dxuchi'u Lue' chee̱ da dxelún xúgute̱ bénneache. Guxasa, bexizruj da dxal-la' xelezí' benne' dxulucá'ana szren cuine̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Xrana' Dios, ¿Bátadxaqueze xelún benne' we̱n da cale̱la caní? ¿Bátadxaqueze xelebé benne' ca' dxelebéaj xíchaje̱' Dios? ");
INSERT INTO zatNTps_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","¿Bátadxaqueze xulucá'ana szren cuine̱', ne xelenné̱' dizra' zi'? ¿Bátadxaqueze xulucá'ana szren cuina benne' ca' dxelebéaj xíchaje̱' Dios? ");
INSERT INTO zatNTps_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Benne' caní dxuluxrínnaje̱' bénneache chiu' Lue', Xran, ne dxulusaca zi'e̱ bénneache guca'u Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Dxelútie̱' nu'ula tuze ca', ne benne' zitu' ca', ne dxelune̱' xelátebe' bidau' we̱ze̱be ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Dxelenné̱': “Quebe bi dxelé'e Dios, Xrana benne' ca'. Dios chee̱ benne' Israel ca' quebe dxue lazre̱' chee̱ da na'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Le chéajni'i, le'e, benne' lázxdau zide'. Le'e, benne' xala, ¿bátadxaqueze quebe chéajni'ile? ");
INSERT INTO zatNTps_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Dios be̱ne̱' nágadxu. ¿Québequeze dxénne̱' da dxennale? Dios be̱ne̱' xiaj laudxu. ¿Québequeze dxelé'ene̱' da dxunle? ");
INSERT INTO zatNTps_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Diósqueze dxuzúe̱' lu da ba xa' benne' xe̱zr la xu ca'. ¿Québequeze til-le̱' le'e? Diósqueze dxune̱' dxeléajni'i bénneache. ¿Québequeze gueque be'ene̱' da xu'u xichaj lázrdaule? ");
INSERT INTO zatNTps_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Xránadxu Dios nézquezne̱' da xu'u xichaj lázxdau xúgute̱ bénneache. Nézene̱' zaj naca na da dácheze. ");
INSERT INTO zatNTps_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Ba neza zrente̱ naca na chee̱ bénnea' dxuzéajni'inu', Xran, ne dxusé̱denu' le̱' ca naca da nadxixruj be'u, ");
INSERT INTO zatNTps_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","chee̱ cueza zri lazre' gate za zra dxaca da cale̱la, ca zrin zra xelexú'u xe̱dxu ba benne' dxelune̱' da zrinnaj. ");
INSERT INTO zatNTps_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Québequeze cueaj xichaj Xránadxu Dios bénneache chee̱', ne quebe gusán lazre̱' benne' ca' ba gucá'a Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Naca xrlátaje ca xuluchí'e̱ chee̱ bénneache, na' xelúnqueze da xrlátaje xúgute̱ benne' zaj naque̱' li lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","¿Núzraqueze gácale̱ neda' tíl-lale̱dxu benne' we̱n da cale̱la ca'? ¿Núzraqueze súale̱ neda' tíl-lale̱dxu benne' dxelune̱' da zrinnaj? ");
INSERT INTO zatNTps_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Chela ca gúcale̱ Xránadxu neda', báchelja xu'a xe̱dxu ba. ");
INSERT INTO zatNTps_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Gate gunnía': Xran, ba zua cheajcházia', na' Lue', dute̱ xel-la' zri'i lazre' chiu' gúcale̱nu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Gate dxe'a gunne xue, ne zua' lu da ste̱be, Lué'queze dxexúe zrenu' neda', na' dxebéle̱'e̱da'. ");
INSERT INTO zatNTps_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Québequeze nacu' tuze benne' ca' dxuluchi'e̱ chee̱ bénneache da quebe naca xrlátaje, benne' ca' dxulucá'ane̱' ca xrlátaje da quebe naca na xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Benne' caní dxelune̱' tuze dizra' da xelune̱' chee̱ benne' xrlátaje, na' dxelechugue̱' chee̱ gate bénnea' quebe bi zria nabague̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Xránadxu Dios naque̱' ca tu xu'u naga zua chawa'. Dios chia' naque̱' ca tu xiaj xre da dxuzé̱ chacha na neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Le̱' xexízruje̱' benne' ca' dxelune̱' da cale̱la cáte̱ze naca da zrinnaj da belune̱'. Guzría xi'e̱ benne' ca' lu da cale̱la da dxelune̱'. Xránadxu Dios guzría xi'e̱ benne' ca' dxelune̱' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Le da, güe lá'anadxu Xránadxu Dios dute̱ xel-la' dxebé. Dute̱ xel-la' dxebé gúl-ladxu chee̱ Bénnea' nuzúa chúchue̱' dxi'u naga ladxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Cheajdxu lau Le̱', ne xe̱dxu Le̱': Xcalenu'. Dute̱ xel-la' dxebé gúl-ladxu da güe lá'anadxu Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Naca Xránadxu tu Dios szrente̱, ne naque̱' Wenná Bea szrente̱ lawe' dios ca' chee̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Dxenná bé'ene̱' du gabí'i xe̱zr la xu, naga naca situj, ne naga naca sibe chee̱ xi'a ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Dxenná bé'ene̱' nísadau' da núnqueze Le̱', ne cá'anqueze xe̱zr la xu da be̱ne̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Le da, gucá'ana szrendxu Le̱', gátadxu sudxú'ala. Guzú zríbedxu lau Xránadxu, Bénnea' nune̱' dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Le̱' naque̱' Dios chee̱dxu. Nácadxu benne' ca' dxuxúequeze̱', ne nácadxu ca zríla'du ca' cheé̱queze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Che dxenle chi'e̱ na'a zra, quebe gun zide' lázrdaule ca belún xra xrtáule ca' naga nazí le na Meriba, ne ca belune̱' lu zra na' le̱'e̱ xixre' lawe' lataj naga nazí le na Masah, ");
INSERT INTO zatNTps_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","naga buluchá'a xra xrtáule neda', ne belune̱' neda' da ste̱be lácala belelé'ene̱' xúgute̱ da be̱na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Lawe' chua iza beditaj lazra' chee̱ benne' ca', na' gunnía': Zaj naque̱' benne' dxelebéaj xíchaje̱' neda', ne quebe dxelune̱' ca da dxulé'eda' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Chee̱ le̱ na', dute̱ xel-la' dxezrá'a chia' bzetaj cuina' gunnía': Quebe xelexú'uqueze̱' naga xelexezí' lazre̱' nen neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Le gul-la chee̱ Xránadxu tu da cube. Le gul-la chee̱ Xránadxu, le'e zrale du gabí'i xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Le gul-la chee̱ Xránadxu, ne le güe lá'ana La lá'azxa chie̱'. Tu zra tu zra le guzén ca naca xel-la' weselá da dxunne̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Le guzén benne' xe̱zr la xu ca' ca naca xel-la' szren chee̱', Ne benne' xúgute̱ xe̱zre ca zaj naca xel-la' waca zren nune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Szrente̱ naca Xránadxu, ne naca chee̱' güe lá'anale̱'e̱dxu Le̱'. Naca chee̱' gápadxe̱' xel-la' ba lá'ana ca dios ca' chee̱ bénneache, ");
INSERT INTO zatNTps_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","lawe' da zaj naca xúgute̱ dios ca' bedáu' xiaj xaga ca'. Xránadxu Dios be̱ne̱' xabáa na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Zúale̱ Le̱' da xabáa, ne xel-la' szren. Nazrate̱ xudau' chee̱' xel-la' waca, ne da xrtante̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Le güe lá'ana Xránadxu, le'e zrale du gabí'i xe̱zr la xu. Le güe lá'ana xel-la' szren chee̱', ne xel-la' waca chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Le gapa ba lá'ana Xránadxu ca da naca chee̱' si'e̱. Le gua da gunézrujle, ne le da chale'aj chee̱ xudau' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Le gucá'ana szren Xránadxu lu xel-la' xrtante̱ chee̱ da naca lá'azxa chee̱'. Le zrebe lau Le̱', le'e zrale du gabí'i xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Le xe̱ bénneache xe̱zr la xu: Naca Xránadxu Wenná Bea. Nuzúa chúchue̱' xe̱zr la xu nigá, na' quebe nu seque' gutá na. Guchi'e̱ chee̱ bénneache ca naca da xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Le be, le'e, xabáa, ne xe̱zr la xu. Le cuezre xa'a, le'e, nísadau', ne bea ca' zrale na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Le be, le'e, le̱'e̱ xixre', ne bea ca' zrale na'. Xaga ca' zaj dxe' xi'a ca' welunna schaga lu xel-la' dxebé ");
INSERT INTO zatNTps_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","lau Xránadxu gate xide̱'. Xide̱' guchi'e̱ chee̱ bénneache zaj zre̱'e̱ xe̱zr la xu. Nna bé'ene̱' bénneache du gabí'i xe̱zr la xu. Nna be'e Le̱' ca naca da xrlátaje, ne ca naca da li. ");
INSERT INTO zatNTps_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Naca Xránadxu Benne' Wenná Bea. Le be, le'e zrale xe̱zr la xu. Le be, le'e zrale dxu'a nísadu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Zaj naxechaj beuj, ne da chul-la Le̱'. Ca naca da li, ne da xrlátaje dxenná be'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Cuía lau xi' lau Le̱', ne guzezxe na benne' guledábague̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Ca naca xesa ca' chee̱' bulusení na xe̱zr la xu. Dxelé'e xe̱zr la xu na, ne dxezrize na. ");
INSERT INTO zatNTps_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Dxelexuna xi'a ca' ca da zixre chee̱ bézudau' lau Xránadxu, lau Xrana bénneache zaj zre̱'e̱ du gabí'i xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Dxulé'e xabáa ca naca da xrlátaje chee̱', na' dxelelé'e bénneache dute̱ xe̱zr la xu ca naca xel-la' szren chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Dxal-la' xelexedué'e xúgute̱ benne' ca' dxulucá'ana szrene̱' bedáu' xiaj xaga ca', benne' ca' dxulucá'ana szren cuine̱' ca zaj naca bedáu' xiaj xaga ca'. Xúgute̱ dios chee̱ bénneache ca' dxal-la' xuluzú zribe na lau Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Belén benne' zaj zre̱'e̱ Sión, na' gulebene̱'. Gulebé benne' zaj zre̱'e̱ Judá, ne̱ chee̱ da guchi'u Lue', Xran. ");
INSERT INTO zatNTps_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Szrente̱ nacu' Lue', Xran, lawe' dute̱ xe̱zr la xu. Szrendxa nacu' Lue' ca xúgute̱ dios chee̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Le'e, núlale nazrí'ile Xránadxu, le cuide da cale̱la. Le̱' dxuxúe̱' bénne'du zaj xu'e̱ bénneache chee̱'. Dxuselé̱' le̱' lu na' benne' dxelebéaj xíchaje̱' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Zuale̱ da dxusení na benne' xrlátaje ca', na' xel-la' dxebé zúale̱ na benne' li lazre' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Le be, le'e, benne' xrlátaje, lau Xránadxu. Le gusá lázrele ca da nun Dios lá'azxa, ne le güe lá'ana Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Le gul-la chee̱ Xránadxu tu da cube lawe' da nune̱' da ca' da dxebánedxu. Ne̱ chee̱ xel-la' wal-la chee̱', ne xel-la' waca lá'azxa chee̱' ba bdinne̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Ba nuzén Xránadxu ca dxune̱' dxuselé̱' bénneache. Ba bzenne̱' bénneache xe̱zr la xu ca' ca naca da xrlátaje chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Ba nune̱' ca da guche̱be lazre̱' chee̱ benne' Israel ca' ca naca xel-la' li lazre' chee̱', ne xel-la' nazrí'i zren chee̱'. Bénneache du gabí'i xe̱zr la xu ba belelé'ene̱' ca naca da be̱n Dios chee̱dxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Le gul-la lu xel-la' dxebé lau Xránadxu, le'e zrale du gabí'i xe̱zr la xu. Le güe lá'ana Le̱' nen da gúl-lale, ne lu xel-la' dxebé chee̱le le cuezre xa'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Le gul-la da güe lá'anale Xránadxu. Le gul-la nen da con zríadi'i na du ca' da quínnele. ");
INSERT INTO zatNTps_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Le gucuezre luzu da ca' dxulucuezre̱', ne da dxutíl-lale ca', ne le cuezre xa'a lu xel-la' dxebé lau Xránadxu, Wenná Bea chee̱dxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Le gun schaga nísadau', ne bea ca' zrale na'. Le gul-la, le'e, xe̱zr la xu, ne le'e zrale na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Le capa na'le, le'e xe̱gu ca'. Le gul-la lu xel-la' dxebé, le'e, xi'a ca', lau Xránadxu ");
INSERT INTO zatNTps_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","lawe' da xide̱' xedajnná bé'ene̱' xe̱zr la xu nigá. Nna bé'ene̱' benne' zaj zre̱'e̱ du gabí'i xe̱zr la xu lu da xrlátaje, ne bénneache dute̱ xe̱zr la xu lu da naca li lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Naca Xránadxu Dios Benne' Wenná Bea, na' dxelezrize xúgute̱ bénneache lau Le̱'. Dxe'e̱ lataj blau chee̱' da zua na láwela querubín ca', na' dxezrú' lu xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Szrente̱ naca Xránadxu lu xi'a Sión. Naque̱' szren lawe' xúgute̱ cue' xe̱zr la xu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Le güe lá'ana La Xránadxu da naca na szren, ne da dxal-la' zrébedxu. ¡Lá'azxa naca Le̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Lue', Wenná Bea szrente̱, nazrí'inu' da naca xrlátaje. Nuzúa chachu' da naca li lazre'. Ba nunu' da naca xrlátaje, ne da naca li lazre' ládujla zri'ine zre sua Jacob. ");
INSERT INTO zatNTps_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Le gucá'ana szren Xránadxu Dios. Le guzú zríbele lau Le̱' naga dxe'e̱. ¡Lá'azxa naca Le̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Moisés, ne Aarón gulaque̱' bxruze chee̱' ca'. Samuel guque̱' tu benne' bchálajle̱ne̱' Le̱'. Gulenné̱' Xránadxu Dios, na' Le̱' beche̱be̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Tu lu beuj bza bchálajle̱ne̱' benne' ca'. Buluzúe̱' dizra' da gunná bé'ene̱', ne da ca' bdxixruj be'ene̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Xránantu' Dios, beche̱bu' lau benne' ca'. Blé'enu' le̱' nacu' Dios, dxunite lau' chee̱ bénneache, lácala dxudéu' le̱' xel-la' zi' ne̱ chee̱ dul-la da zaj nabague̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Le gucá'ana szren Xránadxu Dios. Le guzú zríbele lau Le̱' lu xi'a lá'azxa chee̱', lawe' da lá'azxa naca Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","¡Le gul-la lau Xránadxu Dios, le'e zrale du gabí'i xe̱zr la xu! ");
INSERT INTO zatNTps_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","¡Le gucá'ana szren Le̱' dute̱ xel-la' dxebé! ¡Le da lau Le̱', dxúl-lale dute̱ xel-la' dxebé! ");
INSERT INTO zatNTps_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Cabata' gal-la lázrele naca Xránadxu Diósqueze. Le̱' be̱ne̱' dxi'u, na' nácadxu chee̱ Le̱'. Nácadxu xe̱zre chee̱', ne zríla'du chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Le chu'u lataj naga zua xudau' chee̱', xe̱le Le̱': Xcalenu', ne chale'aj chee̱ na, güe lá'anale Le̱'. Le xe̱ Le̱': Xcalenu', ne le güe lá'ana Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Chawe' naca Xránadxu, na' chadía chacanna zua xel-la' zri'i lazre' chee̱'. Xel-la' li lazre' chee̱' tu súazqueze na chadía chacanna. ");
INSERT INTO zatNTps_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Tu gúl-lazqueza' ca naca xel-la' zri'i lazre', ne xel-la' li lazre' chiu'. Tu gúl-lazqueza' chiu' Lue', Xrana' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Dxaca lazra' guna' da naca li lazre'. ¿Bátala xidu' gácale̱nu' neda'? Guna' da naca du lazre', ne cá'anqueze guna' caní lu xu'u lizra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Québequeze cu'u lazra' guna' tu da zrinnaj. Dxecuídeda' da dxelún benne' ca' dxelebéaj xíchaje̱' Dios. Québequeze gu'a lataj xelebigue̱' naga zua' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Gucuasa' lu xichaj lázrdawa' da cale̱la, ne quebe cu'u lazra' chee̱ da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Guzúa' chalá'ala benne' dxelenné̱' bagácheze chee̱ benne' xula. Quebe gu'a lataj súale̱ neda' tu benne' dxucá'ana szren cuine̱', u naque̱' benne' wenná be'e. ");
INSERT INTO zatNTps_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Le'eda' chawe' benne' ca' zaj naque̱' li lazre' lau Dios, chee̱ xelezré̱'e̱ lawa' neda'. Tuze benne' ca' zaj naque̱' du lazre' xelune̱' zrin chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Quebe gu'a lataj benne' wecache lan chu'e̱ lizra'. Quebe gu'a lataj tu benne' we̱n lazre' xegá'ane̱' naga zua'. ");
INSERT INTO zatNTps_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Tu zra tu zra guzría xi'a benne' ca' dxelune̱' da cale̱la, benne' ca' zaj zre̱'e̱ lu xe̱zr la xu chia'. Gucuasa' xúgute̱ benne' ca' dxelune̱' da zrinnaj lu xe̱zre chee̱ Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Xrana' Dios, bene da dxenaba' lau', ne bze̱ naga da dxuláwizra' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Quebe gucache lau' lawa' neda', lawe' da lu da ste̱be zua'. Bze̱ naga neda', ne beché̱beche chia' gate dxuláwizra' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Naca xel-la' nabán chia' ca zren chee̱ xi' da dxexenítete̱. Xu'u da la lu zrita chia' ca tu xi' da dxálale̱'e̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Dxedú lazra', ne naca lázrdawa' ca tu xixre' da dxecuade, na' québedxa dxenná na gudagu xeta. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Lawe' da dxebezre wé̱'le̱'a ba nazrítale̱'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Naca' ca tu situgún dxedaba' tu lu xe̱zr la xu bizre, ne ca tu bzriu zríaba' lawe' tu xu'u ze la'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Dxíchaja' bchigala, ne naca' ca tu bxinne zríaba' túzeba' xrgu'u sibe. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Tu zra tu zra tu dxulucháchale̱zqueze benne' dxeledábague̱' neda'. Benne' ca' dxelecuídene̱' neda' dxuluchínene̱' la' neda' gate nu benne' dxelegú'e̱ de'. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","Lu waláz chee̱ xeta dxawa' de, na' nisa dxebezra' dxechixre na da dxé'aja'. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","Caní dxaca chia' lawe' da dxezra'u neda', ne dxecuídenu' neda'. Guca'u neda', na' gudxú'unu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Naca xel-la' nabán chia' ca tu zrul-la da dxedeze, na' naca' ca tu xixre' da ba nabizre. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Lue', Xrana' Dios, tu chí'izqueze zu', na' cheajlesá lazre' xúgute̱ cuen bénneache Lau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Chasu', ne xexache lazru' benne' zaj zre̱'e̱ xe̱zre Sión, lawe' da ba bzrin zra xexache lazru' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Netu', we̱n zrin chiu', nazrí'intu' xiaj ca' chee̱ xe̱zre na'. Dxéquentu' zi' lawe' da ba nabía xi na. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Nadxa benne' xe̱zr la xu ca' xelezrebe̱' lau Lue', Xran. Xelezrebe xúgute̱ benne' wenná bea chee̱ xe̱zr la xu nigá da xabáa chiu', ");
INSERT INTO zatNTps_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","gate ba bechisu' xe̱zre Sión, Xran, ne xelelé'equezne̱' ca naca da xabáa chee̱ na, ");
INSERT INTO zatNTps_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","gate na' guzé̱ nagu' da dxelenaba benne' ca' guleaj xíchaju', ne québedxa guzú' chalá'ala da dxelata' xuene̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Xuaj da nigá chee̱ xululaba benne' ca' za zá'aca, na' benne' ca' za xelalaj xelúe lá'ane̱' Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Naga zua Xránadxu xabáa gunné̱'e̱. Naga zue̱' xabáa blé'ene̱' lu xe̱zr la xu nigá. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","Dxelé'ene̱' benne̱' dxelebezre xache', benne' zaj xu'e̱ lizre xia, na' gusane̱' benne' ca' ba zaj nachugue̱' chee̱' xelatie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","Xuluzenne̱' benne' zaj zre̱'e̱ xe̱zre Sión ca szren naca La Xránadxu Dios, chee̱ xelúe lá'ane̱' Le̱' lu xe̱zre Jerusalén, ");
INSERT INTO zatNTps_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","gate xelezraga bénneache chee̱ xúgute̱ xe̱zre, ne xúgute̱ cue' xe̱zr la xu chee̱ xulucá'ana szrene̱' Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Xránadxu Dios be̱ne̱' gute ni'a na'a gate ne naca' cuide'. Xeláteze ca be̱tie̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Nadxa gunnía': Dios chia', quebe gutiu' neda', gate quebe ne gué̱xrua'. Lue' tu chí'izqueze zu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Nédxudaute̱ Lue' bzu' xe̱zr la xu nigá, na' nen na'u be̱nu' xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Xelebía xi' da ca', san tu zúazquezu' Lue'. Welexru xúgute̱ da ca' ca tu ladxe'. Ca dxuchadxu zra lánadxu tuzruj, ca' gucha'u da ca', na' xucúbeu' na. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","Túzqueze ca nacu' Lue', ne québequeze te chiu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Zrí'inentu' netu', we̱n zrin chiu', xelezrabe' chawe', na' guzé̱ chúchuquezu' zri'ine zre súantu' lau Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Be̱ lá'ana Xránadxu Dios, lue', bénne'du xu'a. Be̱ lá'ana Le̱' lá'azxa, dute̱ da naca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Be̱ lá'ana Xránadxu, lue', bénne'du xu'a, ne quebe gal-la lazru' ca da chawe' da nune̱' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Dxunite lawe̱' chee̱ xúgute̱ dul-la nabaga'a. Dxexune̱' neda' ca naca xúgute̱ xízrawe̱' da xu'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Dxuxúe̱' neda' chee̱ quebe gatia'. Lu xel-la' zri'i lazre' chee̱', ne xel-la' dxexache lazre' chee̱' dxune̱' chawe' chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Dxuzánle̱'e̱ da chawe' da dxaca chia' chee̱ xegá'ana' benne' cuide', ne benne' wal-la ca dxaca chee̱ tu bsia. ");
INSERT INTO zatNTps_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Xránadxu Dios dxuchi'e̱ chee̱ da dxaca chee̱ benne' dxeledée̱' da ba xa', ne dxucá'ana chawe̱' da dxaca chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Blé'ene̱' Moisés da ca' gulú'u lazre̱' gune̱', ne be̱'e̱ lataj benne' Israel ca' belelé'ene̱' da ca' be̱ne̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Naca Xránadxu Benne' dxexache lazre', ne Benne' zri'i lazre'. Quebe dxezrá'azie̱', san zrente̱ naca xel-la' zri'i lazre' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Quebe nníaqueze̱', ne quebe zrá'aqueze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Quebe dxudée̱' dxi'u lu da ba xa' ca naca zria da nabágadxu, ne quebe ne guzría xi'e̱ dxi'u ne̱ chee̱ dul-la da nabágadxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Ca sibe naca xabáa lawe' xe̱zr la xu, caníqueze naca xel-la' zri'i lazre' zren chee̱' nen benne' ca' dxelape̱' Le̱' ba lá'ana. ");
INSERT INTO zatNTps_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Ca zitu' naca naga dxalaj gubizra, ne naga dxebía na, caníqueze dxucuase̱' zitu' dul-la da nabágadxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Ca zri'i lazre' naca xra bidu ca' nen zrí'inequeze̱', caníqueze naca zri'i lazre' Xránadxu nen benne' ca' dxelape̱' Le̱' ba lá'ana. ");
INSERT INTO zatNTps_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Le̱' nézene̱' ca nácadxu lu be̱la' dxen chee̱dxu. Dxajsá lazre̱' nácadxu xu xrte. ");
INSERT INTO zatNTps_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Ca naca xel-la' nabán chee̱dxu, nácadxu ca tu xixre'. Dxegúladxu ca tu xiaj xixre', ");
INSERT INTO zatNTps_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","na' dxedé be' dxua na le̱ na, na' dxexenite na, na' québedxa nu dxelé'equeze le̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Ca naca chee̱ benne' ca' dxelape̱' ba lá'ana Xránadxu, zúale̱ xel-la' zri'i lazre' chee̱' benne' ca' chadía chacanna, na' xel-la' xrlátaje chee̱' zúale̱queze na xúgute̱ zri'ine zre sua benne' ca', ");
INSERT INTO zatNTps_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","benne' ca' dxelúnqueze̱' ca naca xel-la' wezría nune̱', ne benne' ca' dxelune̱' ca zaj naca da nadxixruj be'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Nuzúa Xránadxu lataj chee̱' xabáa naga dxe'e̱ dxenná be'e̱. Nácaqueze̱' Wenná Bea lawe' xúgute̱ da zaj zua. ");
INSERT INTO zatNTps_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Le güe lá'ana Xránadxu, le'e, gubáz chee̱ xabáa ca', Nácale benne' wal-la, ne benne' chúchule̱'e̱, na' dxunle ca dxenná Le̱', ne dxuzé̱ nágale ca dxe̱'e̱ le'e. ");
INSERT INTO zatNTps_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Le güe lá'ana Xránadxu, le'e, dxenná beale xabáa. Nácale we̱n zrin chee̱', ne dxunle ca dxaca lazre' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Le güe lá'ana Xránadxu, xúgute̱le le'e ba nun Dios le'e, zrale xúgute̱ lataj naga dxenná bea Le̱'. ¡Be̱ lá'ana Xránadxu, lue', bénne'du xu'a! ");
INSERT INTO zatNTps_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Be̱ lá'ana Xránadxu Dios, lue', bénne'du xu'a. ¡Xrana' Dios, szrente̱ nacu' Lue'! Nacu' zra lanu' da xabáa, ne da xrtante̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Dxugacu cuinu' xel-la' naxaní' ca zra lanu'. Dxechilju' xabáa ca tu xu'u ladxe' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Nunu' lizru' lawe' nisa da ze̱ ná'ala. Dxuchínenu' beuj ca' ca tu da dxudé xua naga dxe'u Lue', da dxedá na lu be'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Dxuchínenu' be' ca' ca gubáz chiu' ca', ne xesa ca' ca we̱n zrin chiu' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Bzua chuchu' xe̱zr la xu nigá lu lane na, na' quebe nu gaca gutá le̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Bgacu' xe̱zr la xu nigá nen nísadau' ca dxun tu benne' dxacue̱' zra lane̱', na' nisa na' bgacu na xi'a ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Gate gudil-lu' nisa na', na' bzrunnuj na. Bebiga na gate ben na chi'u zizraj. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Nisa na' bgacu na xi'a ca' xajxedxé na dxu'a xe̱gu ca', lataj ca' ba nunu' chee̱ nisa na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Bzu' naga ze lau cheajsé̱ na, naga québedxa gaca te na, chee̱ québedxa gacu na xe̱zr la xu bizre na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Dxunu' beaj ca' dxelalaj na dxu'a xé̱gudu ca', ne xe̱gu ca' dxeledé na ládujla xi'a ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Lu xe̱gu ca' dxelé'aj be̱ xixre' ca' nisa, na' dxegúa na xel-la' dxelebile chee̱ burro xixre' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Lu xaga zaj nnita dxu'a xe̱gu ca' zaj zra' béadu ca' zaj zua xrila. Dxelúl-laba' ládujla zruze na ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Zran xabáa dxesel-lu' xiuj da dxaca na lu xi'a ca', na' dxezrate̱ xe̱zr la xu na' ca naca da xrlátaje da dxunu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Dxusegulu' xixre' da dxelagu be̱zre ca', ne xíxre'du ca' da dxelagu bénneache, ne da ca' dxuluchine bénneache dxelune̱' xel-la' wagu, ");
INSERT INTO zatNTps_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","ne uva ca' da dxelune̱' xrise uva wal-la da dxuzúa na bénneache ca' xel-la' dxelebé, ne olivo ca' da dxelune̱' da za da dxelegú'e̱ xíchaje̱', ne zrua' da dxelune̱' xeta chee̱ xelaca bane̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Xaga cedro ca' da zaj zua na xi'a Líbano dxelezíle̱'e̱ na nisa xiuj. Zaj naca na xaga chee̱ Xránadxu Dios, da ca' guza Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Lu xaga ca' dxuluzría bxínnedu ca' xrú'uneba', na' lu zruze na ca' zaj zua lizre bxuze' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Zaj zua chivo xi'a ca' lu xi'a zri'a ca', na' lu bluaj ca' chee̱ xi'a ca' zaj zua bzrizru' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Be̱nu' beu' da dxulé'e na tu beu' tu beu' chee̱ iza, na' gubizra núnbea na gate dxal-la' cuía na. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Be̱nu' dxe̱la, na' gate bache nachul-la, na' dxeledxúaj be̱ dxe̱la ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Dxelebezre xa'a be̱zre xixre' ca', zaj nauba' be̱ xeláguba'. Dxelílajba' da nun Dios xeláguba'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Gate dxalaj gubizra, na' dxelexezrinba' lu bluaj chee̱ba', naga dxeláseba' te zra. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Nadxa dxeledxúaj bénneache dxelune̱' zrin, na' dxelúnqueze̱' zrin ca dxebía gubizra. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","Xran, da zante̱ zaj naca da be̱nu'. Dute̱ xel-la' sina chiu' be̱nu' da ca'. Nazrate̱ xe̱zr la xu nigá da ca' be̱nu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Na' zua nísadau', da zri'a, ne da laga, naga zaj xu'u zánete̱ bea ca', béadu ca', ne be̱ zri'a ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Lu nísadau' na' zaj zra' da dxeledá lawe' nísadau' ca'. Zua be̱ zri'a na' be̱nu' Lue', nazí' laba' leviatán. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Xúgute̱ bea ca' dxuluxrén lázreba' Lue', chee̱ gunézruju' da xeláguba' ca zrin chee̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Dxunézruju' le̱ba', na' dxelecá'aba' na. Dxunézruju' da dxeláguba', na' dxeléljeba'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Gate quebe dxenná'u-ba', na' dxelezrébeba'. Gate dxucuasu' be' dxelecá'aba', na' dxeláteba', ne dxelexácaba' xu xrte. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Gate dxesel-lu' be' chiu', na' xelexaca banba'. Dxunézruju' xel-la' nabán cube chee̱ da ca' zaj zua xe̱zr la xu nigá. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","¡Chadía chacanna gaca ba Xránadxu Dios! Dxezaca ba lazre' Xránadxu chee̱ da ca' ba núnqueze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Dxenné̱'e̱ xe̱zr la xu nigá, na' dxezrú' na. Dxuté̱' xi'a ca', na' dxeledxúaj na zren. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Gúl-laqueza' chee̱ Xránadxu dxácate̱ na' naca bana'. Xúgute̱ zra zúaqueza' neda' gul-la' da güe lá'ana' Dios chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Chawe' naca chia' da ca' dxulaba lazra' ca naca chee̱', na' dxebéle̱'e̱da' ne̱ chee̱ Xrana' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Welebía xi' benne' dul-la ca' zaj zre̱'e̱ lu xe̱zr la xu nigá, Na' québedxa cha benne' ca' dxelebéaj xíchaje̱' Dios. ¡Be̱ lá'ana Xránadxu Dios, lue', bénne'du xu'a! ¡Le güe lá'ana Xránadxu! ");
INSERT INTO zatNTps_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","¡Le güe lá'ana Xránadxu Dios! ¡Le gucá'ana szren La Le̱'! ¡Le guzén bénneache dute̱ xe̱zr la xu ca naca da nune̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","¡Le gul-la chee̱'! ¡Le gul-la da güe lá'anale Le̱'! ¡Le guchalaj chee̱ da zrente̱ ca' da nune̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","¡Le be lu da naca chee̱'! Xúgute̱ benne' ca' dxelapa ba lá'ana Xránadxu dxal-la' xelebéle̱'e̱ne̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Le naba Xránadxu gácale̱ne̱' le'e. Tu zra tu zra le guxrén lazre' Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","6","Le'e, zri'ine zre sua Abraham, we̱n zrin chee̱ Xránadxu. Le'e, zri'ine zre sua Jacob, bénnea' guqué̱'e̱, Le gusá lazre' xel-la' waca ca', ne da zrente̱ ca' da be̱ne̱', ne ca naca da bchi'e̱ chee̱le. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Le̱' naque̱' Xránadxu, ne Dios chee̱dxu. Le̱' dxenná bé'ene̱' bénneache zaj zre̱'e̱ dute̱ xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Lácala te chee̱ chi gaxúa cuen bénneache, québequeze gal-la lazre̱' da guche̱be lazre̱' lu xel-la' wezría chee̱', ");
INSERT INTO zatNTps_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","xel-la' wezría na' bé̱nle̱ne̱' Abraham, da na' bzetaj cuine̱' guche̱be lazre̱' chee̱ Isaac, ");
INSERT INTO zatNTps_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","na' bzua chúchue̱' na ca tu da nadxixruj bea na, da gun Jacob, da gaca na tu xel-la' wezría da zeajlí canna nen benne' Israel ca', ");
INSERT INTO zatNTps_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","da be̱ne̱' gate na' gunné̱': “Chiu' lue' gunna' xe̱zr la xu chee̱ benne' Canaán ca', da gaca na tu da xudele lu na' zri'ine zre súale.” ");
INSERT INTO zatNTps_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Gate na' bábaze zaj naque̱' gulezré̱'e̱ lu xe̱zr la xu nigá ca benne' zitu' ca', ");
INSERT INTO zatNTps_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","ne guledée̱' tu xe̱zr la xu xetú xe̱zr la xu, ne tu xe̱zre xetú xe̱zre. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Quebe be̱' Dios lataj nu benne' bi gune̱' chee̱ bénneache chee̱', na' ne̱ chee̱ benne' ca' gudil-le̱' benne' wenná bea ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","Guzre̱' le̱': “Quebe bi gunle chee̱ benne' ca' gucá'a, ne quebe gunle da cale̱la chee̱ benne' ca' dxuluchalaje̱' waláz chia'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Be̱ne̱' guta' tu gubina' lu xe̱zr la xu na', na' gudúe̱' ca naca xeta xelawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Gusel-le̱' tu benne' cuía lawe̱' lau benne' chie̱' ca', bénnea' naque̱' José, bi na' belutie̱'-be' chee̱ gácabe' we̱n zrin chee̱ benne' zitu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Buluzré̱'e̱ ní'abe' lu xe̱dxu chee̱ cuaga da be̱xru na ní'abe', gate na' gulu'e̱-be' lizre xia lu xe̱zr la xu Egipto, ");
INSERT INTO zatNTps_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","ca bzrin zra guca li ca da gunná José dxal-la' gaca. Caní guca, ble'e xrtizra' Xránadxu cúnnabe' da li. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Nadxa benne' wenná bea chee̱ Egipto gusel-le̱' nu gusán José na'. Bénnea' dxenná bé'ene̱' zánete̱ cue' xe̱zr la xu bsane̱'-be'. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Bzue̱'-be' gácabe' xrana benne' zaj zre̱'e̱ lizre̱', ne chee̱ nna be'ebe' ca naca da xu'u lu ne̱'e̱, ");
INSERT INTO zatNTps_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","chee̱ tíl-labe' benne' szren ca' chee̱ wenná bea cáte̱ze dxaca lázrebe', ne chee̱ guzéajni'ibe' benne' gula chee̱ xe̱zr la xu Egipto chee̱ xelaque̱' benne' sina. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Gudé na' gulu'e̱ benne' Israel ca' lu xe̱zr la xu Egipto, na' guzúa Jacob lu xe̱zr la xu chee̱ zri'ine zre sua Cam. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Gulánle̱'e̱ bénneache chee̱ Xránadxu lu xe̱zr la xu na', na' be̱ne̱' gulaque̱' wál-ladxa ca benne' guledábague̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Bcha Dios lázxdau benne' Egipto ca' chee̱ xelecuídene̱' bénneache chee̱', chee̱ xelegú'u lazre̱' xelune̱' da cale̱la chee̱ we̱n zrin chee̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Nadxa gusel-le̱' Moisés, we̱n zrin chee̱', lau bénneache chee̱' ca', ne Aarón, bénnea' guqué̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Benne' caní be̱'e̱ Dios lataj belune̱' xel-la' waca ca' chee̱ xabáa, ne xel-la' waca zrente̱ ca' lu xe̱zr la xu chee̱ zri'ine zre sua Cam. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Gusel-la Dios tu da chul-la da bgacu na dute̱ xe̱zr la xu na', san benne' Egipto ca' quebe buluzúe̱' dizra' da gunná be'ene̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Nadxa be̱ne̱' bexaca nisa xe̱gu chee̱ benne' ca' dxen, ne be̱tie̱' xúgute̱ bela zaj zraba' xe̱gu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Busezrate̱' xe̱zr la xu chee̱' bluzru ca' ga bzrinte̱ gulezraba' xu'u lizre benne' wenná bea chee̱ benne' Egipto ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Gunnaze Dios, na' belelá' zánete̱ be'a chee̱ be̱zre, ne be'a lase ca' dute̱ lu xe̱zr la xu chee̱ benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Waláz chee̱ nisa xiuj gusel-le̱' xiaj bezxe' lu xe̱zr la xu chee̱ benne' ca', ne xi' da bzezxe na ca naca xe̱zr la xu chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Bzria xi'e̱ ca zaj naca lba uva chee̱', ne ca zaj naca xaga higo chee̱', na' bzúzxuje̱' ca zaj naca xaga zaj ze̱ lu xe̱zr la xu chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Gunnaze̱', na' belelá' biche zu ca', da quebe nu seque' gulaba le̱ba', ");
INSERT INTO zatNTps_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","na' guláguba' dute̱ xixre' xa'a lu xe̱zr la xu chee̱', ne guláguba' dute̱ lina da dxunna xe̱zr la xu na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Nadxa be̱tie̱' xúgute̱ bi biu nedxu chee̱ benne' Egipto ca', bi zaj nácabe̱' bi blau chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Bebéaje̱' bénneache chee̱' na' zaj nu'e̱ dumí plata, ne dumí oro, na' quebe nu chilá' benne' ládujla le̱', benne' quebe chawe' zue̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Gulebé benne' Egipto ca' gate beledxúaj benne' ca' ga na', lawe' da belezrébele̱'e̱ le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Bzalaj Dios tu beuj da gulú'u na benne' ca' zrul-la, ne tu xi' da bsaní na chee̱' chizrela. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Gulenabe̱' Dios, na' gusel-le̱' chee̱' btau ca', ne be̱ne̱' gulélajene̱' xeta da bdxuaj na xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Gule̱'e̱ tu xiaj xre, na' gulaj nisa da gudé na lu xe̱zr la xu bizre na' ca tu xe̱gu nisa. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Caní be̱n Dios lawe' da bsa lazre̱' xrtizre̱' lá'azxa da guche̱be lazre̱' gune̱' chee̱ Abraham, we̱n zrin chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Bebéaje̱' bénneache chee̱' lu xe̱zr la xu Egipto, dxelebene̱'. Lu da ba neza gulezrá' benne' ca' guqué̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Bnézruje̱' benne' ca' xe̱zr la xu chee̱ benne' xezica ca', na' da belún benne' xe̱zr la xu ca' bexaca na chee̱ benne' chee̱' ca', ");
INSERT INTO zatNTps_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","chee̱ xulupá'ane̱' ca naca xrba chee̱' ca', ne xelune̱' ca naca da gunná bé'ene̱' ca'. ¡Gaca ba lá'azxa Xránadxu Dios! ");
INSERT INTO zatNTps_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","¡Gaca ba lá'azxa Xránadxu Dios! ¡Le xe̱ Xránadxu Dios: “Xcalenu'!” Caní dxal-la' gunle lawe' da naque̱' xrlátaje, ne lawe' da tu chí'izqueze dxexache lazre̱' dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","¿Núzraqueze seque' gulé'ene̱' ca naca xel-la' waca zrente̱ ca' da nune̱' Xránadxu? ¿Núzraqueze seque' güe lá'ane̱' Le̱' ca dxal-la' gundxu? ");
INSERT INTO zatNTps_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Ba neza zrente̱ naca na chee̱ benne' ca' dxelune̱' da xrlátaje, benne' ca' tu dxelúnzqueze̱' da naca xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Bsa lazre' chia', Xrana' Dios, gate dxunu' da chawe' chee̱ bénneache chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","Gudá bselá neda' chee̱ gaca le'eda' da chawe' gunu' chee̱ benne' ca' ba guca'u Lue', ne chee̱ beda' gate xelezrá' bénneache chiu' lu da ba neza, ne chee̱ béle̱na' bénneache chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Ba be̱ntu' dul-la cáqueze belún xra xrtáuntu' ca'. Be̱ntu' da cale̱la, ne be̱ntu' da zrinnaj. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Gate gulezrá' xra xrtáuntu' lu xe̱zr la xu Egipto, quebe bululaba lazre̱' ca naca xel-la' waca ca' chee̱ xabáa da be̱nu'. Quebe xeajlesá lazre̱' ca bexache lázrele̱'u le̱'. Guledábague̱' Lue' dxu'a nísadau' da nazí le na Xrna. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Le̱' bselé̱' benne' ca' chee̱ gaca ba lá'ana La Le̱', ne chee̱ gulé'e lau ca naca xel-la' waca chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Gudil-le̱' nísadau' Xrna na', na' bebizre na, na' guledé bénneache chee̱' laduj nísadau' na' lu xu bizre. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Bselé̱' benne' ca' lu na' benne' guledábague̱' Le̱', ne bebéaje̱' le̱' lu na' benne' ca' bulusaca zi'e̱ le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Nadxa nísadau' na' bgacu na benne' ca' guledábague̱' le̱'. Netú benne' ca' quebe nu begá'ana. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Nadxa benne' chee̱' ca' guléajle̱'e̱ dizra' chee̱', ne belul-le̱' da belúe lá'ane̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Chadí gulal-la lazre̱' ca da be̱ne̱'. Quebe gulebeze̱' ca la' dizra' chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Gulezá lazre̱' tu da cale̱la le̱'e̱ xixre' lawe' lataj na', na' buluché̱'e̱ Dios le̱'e̱ xixre' na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Gudé na' bnezruj Dios ca da gulenabe̱', san gusel-le̱' ládujla le̱' tu da gute na bal-la benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Gulaque̱' xa lazre' chee̱ Moisés naga zaj zre̱'e̱, ne chee̱ Aarón, Bénnea' gucá'a Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Nadxa bzra xe̱zr la xu na', ne gude̱be na Datán, ne bgacu na benne' ca' zaj de̱'e̱ Abiram. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Nadxa guxalaj xi' naga zaj nazraga benne' ca', na' bzezxe na benne' ca' dxelune̱' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Belune̱' tu bedáu' be̱zre da naca na oro lu xi'a Horeb, na' buluzú zribe̱' lau bedáu' oro na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Caní bulucá'ane̱' Dios, Benne' xabáa, chee̱ xulucá'ana szrene̱' tu bedáu' be̱zre, da naca na ca tu be̱zre dxáguba' xixre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Gulal-la lazre̱' Dios, Bénnea' bselé̱' le̱', Bénnea' be̱ne̱' xel-la' waca zrente̱ ca' lu xe̱zr la xu Egipto, ");
INSERT INTO zatNTps_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","ne be̱ne̱' xel-la' waca ca' chee̱ xabáa lu xe̱zr la xu chee̱ zri'ine zre sua Cam, ne da ca' buluchebe na dxi'u dxu'a Nísadau' Xrna. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Nadxa guca lazre' Dios guzría xi'e̱ bénneache chee̱', san Moisés, bénnea' gucá'a Dios, bzua cuine̱' lau Dios chee̱ guzúa zrie̱' xel-la' dxezrá'a chee̱ Dios, na' be̱ne̱' quebe guzría xi' Dios benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Buluzúe̱' chalá'ala xe̱zr la xu xrtante̱ da gunezruj Dios le̱', ne quebe guléajle̱'e̱ dizra' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Tu gulenné̱zqueze̱' chee̱ Dios lu xu'u xide chee̱' ca', ne quebe buluzé̱ nague̱' da gunná Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Chee̱ le̱ na' bzetaj cuine̱' gunné̱' ca da gune̱' chee̱ benne' ca'. Gunné̱' gune̱' xelate benne' ca' le̱'e̱ xixre' lawe' lataj na', ");
INSERT INTO zatNTps_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","ne gusi'e̱ bénneache chee̱' lu xel-la' stu' lau benne' xe̱zr la xu ca', ne guse dínnaje̱' le̱' ládujla benne' xe̱zr la xu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Nadxa belune̱' tuze benne' ca' dxulucá'ana szrene̱' bedáu' xia nazí le na Baal-peor, ne gulawe̱' béadu ca' belútie̱' lau dios gate ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Buluche̱'e̱ Dios ne̱ chee̱ da belune̱', na' guxalaj tu xízrawe̱' zren da be̱te na benne' zan benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Nadxa guxasa Finees, ne be̱tie̱' bénnea' be̱ne̱' dul-la, na' guleza xízrawe̱' zren na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Da na' be̱n Finees guzí' Dios ca tu da dxucá'ana xrlátaje na bénnea', da gulé'e lawe na lau xúgute̱ cuen bénneache ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Cá'anqueze buluché̱'e̱ Dios dxu'a beaj nisa nazí le na Meriba, na' guca da cale̱la chee̱ Moisés ne̱ chee̱ benne' ca', ");
INSERT INTO zatNTps_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","lawe' da ne̱ chee̱ da belune̱' guca Moisés xichaj zra'a, na' bexúbete̱ Moisés da gunné̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Gate gulu'e̱ lu xe̱zr la xu nigá quebe buluzría xi'e̱ bénneache zaj nite̱' ga na'. Caní guca, quebe belune̱' ca da guzre Dios le̱' xelune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","Gulaque̱' tuze benne' xe̱zr la xu ca', ne bulusé̱die̱' benne' Israel ca' xelune̱' ca dxelún benne' ca', ");
INSERT INTO zatNTps_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","na' bulucá'ana szrene̱' bedáu' xia xaga ca' chee̱ benne' ca', da na' be̱n na bxrinnaj Dios bénneache chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Belútie̱' zrí'ine̱' bi biu, ne bi nu'ula chee̱' lau bedáu' chee̱ da xriwe̱' ca', ");
INSERT INTO zatNTps_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","ne bululálaje̱' dxen chee̱ bi dxé'enedu ca', bi quebe zaj nunbe' dul-la, da naca na dxen chee̱ zrí'ine̱' bi biu, ne bi nu'ula, bi ca' belútie̱' lau bedáu' xia xaga ca' chee̱ bénneache Canaán, na' guca sban xe̱zr la xu na' ne̱ chee̱ dxen chee̱ bidu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Da ca' belune̱' be̱n na le̱' sban, na' gulebéaj xíchaje̱' Dios lu da belune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Chee̱ le̱ na' bzrá'ale̱'e̱ Dios bénneache chee̱', na' gucuídene̱' benne' ca' zaj naca chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Nadxa bdee̱' benne' ca' lu na' benne' xe̱zr la xu ca', na' benne' ca' dxelecuide bénneache chee̱ Dios gulenná bé'ene̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Benne' ca' guledábague̱' le̱' bulusaca zi'e̱ bénneache chee̱ Dios, ne buluxrínnaje̱' le̱' lu xel-la' dxenná bea chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Zánete̱ lasa Dios bselé̱' bénneache chee̱' ca', san guledábague̱' ca da bsízrene̱' le̱', na' gulape̱' xel-la' stu' lawe' da belune̱' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Lácala caní belune̱', gate gulezré̱'e̱ lu da ste̱be, Dios gunné̱'e̱ ca da dxelezaque̱', ne benne̱' ca da bululáwizre̱' Le̱', ");
INSERT INTO zatNTps_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","na' xeajsá lazre̱' xel-la' wezría da bé̱nle̱ne̱' benne' ca', na' bexíaje lazre̱' chee̱ xel-la' dxezrá'a chee̱' lawe' da nácale̱'e̱ benne' dxexache lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","Cá'anqueze be̱ne̱' belexache lazre' benne' ca' benne' ca' guleché̱'e̱ le̱' ca benne' zaj nada'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","¡Bselá netu', Xránantu', nacu' Dios chee̱ntu'! ¡Becá'a netu' ládujla benne' xe̱zr la xu ca', chee̱ güe lá'anantu' Lau' lá'azxa, ne chee̱ béle̱'e̱ntu' lu da dxúl-lantu' chiu'! ");
INSERT INTO zatNTps_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Cháwedau' naca Xránadxu, Bénnea' naque̱' Dios chee̱ benne' Israel ca' nédxudaute̱, ne chadía chacanna. Xúgute̱ bénneache dxal-la' xelenné̱': ¡Ca'an gaca na! ¡Gaca ba lá'azxa Xránadxu Dios! ");
INSERT INTO zatNTps_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","¡Le güe lá'ana Xránadxu, Benne' xrlátaje! ¡Chadía chacanna naque̱' Benne' zri'i lazre'! ");
INSERT INTO zatNTps_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Da nigá dxal-la' xelenná benne' ca' ba naxá'awe Xránadxu le̱', benne' ca' bselé̱' lu na' benne' guledábague̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","Beche̱'e̱ le̱' naga gulezrá' benne' xe̱zr la xu zitu' ca', da zaj zua naga dxalaj gubizra, ne naga dxebía na, ne naga za' be' zaga, ne naga dxedé gubizra beu' zaga ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Bal-la benne' ca' guledé̱' le̱'e̱ xixre' naga quebe bi neza zua, ne quebe belezrelne̱' xe̱zre naga xelezúe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Guledune̱', ne gulebílene̱', ne québedxa bi gulebeza lazre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Nadxa lu da dxelezaque̱' gulenné̱' Xránadxu, na' bselé̱' benne' ca' lu da dxelezaque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Na' buzre̱'e̱ le̱' tu neza li, chee̱ chjaque̱' tu xe̱zre naga xelezúe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Dxal-la' xelúe lá'ane̱' Xránadxu lawe' da bexache lazre' Xránadxu le̱', ne lawe' da be̱ne̱' chee̱' da ca' da dxebánedxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Dxuxí'aje̱' benne' ca' dxelebile lazre', ne dxugawe̱' benne' ca' dxeledún nen da chawe' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Bal-la benne' caní gulezúe̱' lu da chul-la, ne lu da ste̱be chee̱ xel-la' gute. Gulaque̱' ca benne' zaj xu'e̱ lizre xia, ne zaj nadxéaj du xia, ne dxeledée̱' ba xa', ");
INSERT INTO zatNTps_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","lawe' da guledábague̱' xrtizra' Xránadxu, ne buluzúe̱' chalá'ala da bzéajni'i Dios zrente̱ le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Belexedú lazre̱' lu zrin zí'ite̱ da dxelune̱'. Xeleajcházie̱' zran xua da zaj nu'e̱, ne quebe nu chilá' gácale̱ne̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Nadxa lu da dxelezaque̱' gulenné̱' Xránadxu, na' bselé̱' benne' ca' lu da dxelezaque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Nadxa bebéaje̱' benne' ca' lu da chul-la ne lu da ste̱be chee̱ xel-la' gute, ne bzúzruje̱' du xia ca' da zaj nadxéaje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Dxal-la' xelúe lá'ane̱' Xránadxu lawe' da bexache lazre̱' le̱', ne lawe' da be̱ne̱' chee̱' da ca' da dxebánedxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Bchínnaje̱' dxa xu'u ca' zaj naca na xia gache, ne bzúzruje̱' xia ca' da zaj naxechaj na benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Bal-la benne' ca' gulaque̱' benne' xala, ne guledée̱' xel-la' zi' ne̱ chee̱ dul-la da zaj nabague', ne ne̱ chee̱ da zrinnaj ca' da belune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Belexegútene̱' da dxelé'aj dxelawe̱', na' xáteze ca gulátie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Nadxa lu da dxelezaque̱' gulenné̱' Xránadxu, na' bselé̱' benne' ca' lu da dxelezaque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Gusel-le̱' dizra' chee̱' chee̱ benne' ca', na' bexune̱' le̱', ne bselé̱' le̱' lu xel-la' gute. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Dxal-la' xelúe lá'ane̱' Xránadxu lawe' da bexache lazre̱' le̱', ne lawe' da be̱ne̱' chee̱' da ca' da dxebánedxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Dxal-la' xelé̱'e̱ Le̱': Xcalenu'. Dxal-la' xelú'e̱ da xulunézruje̱' Le̱', na' lu xel-la' dxelebé chee̱' dxal-la' xelúl-le̱', ne xuluzenne̱' bénneache ca zaj naca da nune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Bal-la benne' ca' guledée̱' lu nísadau' lu da zren ca' da dxedá lawe' nísadau'. Belezi'e̱ dumí zren lu zrin dxelune̱' lu nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Belelé'ene̱' ca naca da ca' dxun Xránadxu, da ca' dxune̱' lu nísadau' da zaj naca na da dxebánedxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Gunné̱ze̱', na' guzú lau dxaca be' bdunu', na' gulasa xeajxruza zren lu nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Belegüén da dxedá lawe' nísadau' ca' ca lu xi'a zri'a da naca na nísadau', na' belexexetaj na lu da situj lawe' nísadau' na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Gulechégüe̱', ne xeajleté̱' ni xeajleté̱' na' ca benne' dxelezuzre, na' guca dácheze ca da zaj nusé̱die̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Nadxa lu da dxelezaque̱' gulenné̱' Xránadxu, na' bselé̱' benne' ca' lu da dxelezaque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Bzua zrie̱' be' bdunu' na' da dxaca na, ne gulezúa zri xeajxruza chee̱ nísadau' na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Gulebéle̱'e̱ne̱' lawe' da zaj zua zri xeajxruza ca', na' guché̱'e̱ Dios le̱' cháwedau' naga zjaque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Dxal-la' xelúe lá'ane̱' Xránadxu lawe' da bexache lazre̱' le̱', ne lawe' da be̱ne̱' chee̱' da ca' da dxebánedxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Dxal-la' xuluzenne̱' ca naca xel-la' szren chee̱' naga zaj nazraga bénneache chee̱', ne xelúe lá'ane̱' Le̱' naga zaj nazraga benne' gula ca', benne' dxelenná be'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Be̱n Xránadxu gulebizre xe̱gu nisa ca', ne busú'aje̱' beaj nisa ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","Xu xa'a bexune̱' na xu bizre, ne̱ chee̱ da cale̱la da belún benne' ca' zaj zre̱'e̱ na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Naga naca xu bizre bexune̱' na xu nisa, na' xu xiaj bexune̱' na naga dxalaj nisa. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Bzre̱'e̱ ga na' benne' ca' benne' dxeledún, na' belune̱' tu xe̱zre naga xelezúe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Gulaze̱' xe̱zr la xu na', na' belexaze̱' lba uva ca', na' belexezí'le̱'e̱ lina chee̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Be̱ne̱' da chawe' chee̱ benne' ca', na' gulánle̱'e̱ bidu chee̱' ca', ne quebe be̱'e̱ lataj xelelase ca zaj naca be̱ xixre' chee̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Gate buludé benne' dxelenná bea benne' ca' lu xel-la' zi', ne bulusaca zi'e̱ le̱', ne gulenná bé'edxene̱' le̱', ne belune̱' le̱' da cale̱la, ne buludée̱' le̱' lu da ba xa', ");
INSERT INTO zatNTps_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","bca'ana ditaj Dios benne' xíchaje̱ ca', ne be̱ne̱' guledée̱' le̱'e̱ xixre' lawe' lataj naga quebe bi neza de̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Bselé̱' benne' xache' ca' lu da zi' da xa' da dxeledée̱', ne bzánle̱'e̱ zri'ine benne' ca' ca dxelán zrila' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Gate dxelelé'e benne' xrlátaje ca' da caní, na' dxelebéle̱'e̱ne̱', na' benne' ca' dxelune̱' da cale̱la quebe bi gaca xelenné̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Benne' ca' zaj naque̱' sina dxal-la' xulaba lazre̱' ca zaj naca da caní, ne dxal-la' xelexúnbe'e̱ ca naca xel-la' zri'i lazre' chee̱ Xránadxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","Ba zúate̱queze lázrdawa', Dios, chee̱ gúl-laqueza' da güe lá'ana' Lue'. Da nigá dxugú'u na neda' lu da ba neza. ");
INSERT INTO zatNTps_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Bebán lazre', bénne'du xu'a, na' le xebán lázrele, le'e dxínnele da dxúl-lale̱nle, ne da con zríadi'i na du. Che zílala cheajsá'queza'. ");
INSERT INTO zatNTps_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Güe lá'anaqueza' Lue' ládujla bénneache chiu', Xran. Gúl-laqueza' chiu' lau benne' dute̱ xe̱zr la xu, ");
INSERT INTO zatNTps_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","lawe' da naca xel-la' dxexache lazre' chiu' zrendxa ca xabáa, na' da li chiu' naca na zrendxa ca beuj bza ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Xegá'ana szrénquezu' xabáa, Dios. Xel-la' szren chiu' sua na lawe' dute̱ xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Chee̱ xelelá benne' ca' nazrí'iqueznu' Lue', bselá le̱' dute̱ xel-la' waca chiu', ne bene chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Lu lataj lá'azxa chee̱' gunná Dios: “Wabéquezda' neda'. Gunna' late weaj chee̱le xe̱zr la xu chee̱ benne' Siquem ca', ne gudixra' chee̱le xe̱zr la xu de̱ cuite xe̱gu Sucot. ");
INSERT INTO zatNTps_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Chia' naca xe̱zr la xu Galaad, ne chia' naca xe̱zr la xu chee̱ zri'ine zre sua Manasés. Xe̱zr la xu chee̱ zri'ine zre sua Efraín naca na ca tu da napa chi'i na xíchaja'. Xe̱zr la xu chee̱ zri'ine zre sua Judá naca na naga dxenná be'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Xe̱zr la xu chee̱ benne' Moab naca na ca tu zriga' da xuzru nisa guná'a, na' lu xe̱zr la xu chee̱ benne' Edom chu'una' zrela' gula. Si'a ba neza xe̱zr la xu chee̱ benne' Filistea.” ");
INSERT INTO zatNTps_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","¿Nuzra che̱' neda' chee̱ chu'a xe̱zre da naxechaj ze'e sibe? ¿Nuzra che̱' neda' chee̱ guzétaja' benne' Edom ca'? ");
INSERT INTO zatNTps_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","¿Quegá Lue' na' che̱'u neda', Dios. Nacu' Bénnea' bzua netu' chalá'ala, ne quebe guxéajle̱nu' benne' chee̱ntu' ca', benne' dxjaque̱' wedil-la, Dios? ");
INSERT INTO zatNTps_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Gúcale̱ netu' chee̱ séquentu' tíl-lale̱ntu' benne' ca' dxeledíl-lale̱ne̱' netu', lawe' da naca dácheze xelácale̱ bénneache netu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Tu zren nen Dios gundxu tu da zrente̱, na' Le̱' gulague̱' benne' ca' dxeledil-lale̱ne̱' dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","¡Dios, dxue lá'ana' Lue'! Quebe xegá'anu' zrize ");
INSERT INTO zatNTps_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","lawe' da dxelenná benne' ca' dxelune̱' da cale̱la, ne benne' we̱n lazre' ca' chia' neda'. Dxelenné̱' chia' da naca da we̱n lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Lu xel-la' dxelecuide chee̱' zaj naxéchaje̱' neda', ne dxelenné̱' chia'. Dxeledíl-lale̱ne̱' neda', ne quebe bi nuna' chee̱ benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Lácala bzri'ida' benne' ca', na'a dxeledábague̱' neda', san neda' dxenaba' gaca da chawe' chee̱ benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Lácala be̱na' neda' da chawe' chee̱ benne' ca', dxelune̱' chia' da cale̱la, ne lácala bzri'ida' le̱', dxelecuídene̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Bzua tu benne' we̱n da zrinnaj chee̱ guchi'e̱ chee̱ benne' we̱n da cale̱la ca', ne be̱n sua tu benne' nnie̱' chee̱ benne' ca', benne' guzúe̱' ca naca da cale̱la belún benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Gate na' zri'a chee̱', be̱n gaca bea na zaj nabague̱' zria. Ble'e da xelenabe̱' lau' ca tu dul-la da dxelune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Bzache zra xelaca ban benne' ca', ne be̱n xelú'u xezica' benne' waláz chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Bca'ana zrí'ine̱' ca' bidau' we̱ze̱be, ne xelaca zru'ule̱' nu'ula tuze ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Be̱n xelaca zrí'ine̱' bi dxeledaze chee̱ xelenábabe' guna', ne be̱n xelezrélebe' xeta xelágube' zitu' naga zaj zua lízrebe' da zaj naxinnaj. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Be̱n xelú'u da ca' zaj nape̱' lu na' bénne' ca' bulusane̱' le̱' dumí. Be̱n xelexúa benne' zitu' ca' da ca' zaj nune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Be̱n quebe nu zrel-la benne' xexache lazre̱' le̱', ne quebe nu benne' zrel-la xexache lazre̱' bidau' we̱ze̱be chee̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Be̱n xelebía xi' zri'ine zre sua benne' ca', ne québedxa nu cha' zri'ine zre sue̱', si' le̱' ca zaj nazi'i la benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Bsa lazre' ca da cale̱la da belún xra xrtawe̱', Xran, ne quebe xusulu' dul-la da gulún xrne̱'e̱ ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Tu chí'izqueze bsa lazre' ca da cale̱la da zaj nune̱'. Québedxa cheajsá lazru' benne' ca' ");
INSERT INTO zatNTps_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","lawe' da quebe xeleajsá lazre̱' xelexache lazre̱' le sa' ljwezre̱' ca', san bulusaca zi'e̱ benne' baxache' ca', benne' dxelexázrjene̱', ne benne' dxexruj lazre' ca', na' belútie̱' bénne'du ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Beledánene̱' da dxugú'u na de', na' da caníze guca na chee̱'. Quebe gulaca lazre̱' xelenabe̱' gaca chawe' chee̱ bénneache, na' da chawe' bebiga na naga zaj zue̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","De' da gulegú'e̱ bénneache guca na ca tu da gulacu cuine̱', na' guxú'u na le̱'e̱ ca nisa gulé'aje̱', ne guxú'u na zrita chee̱' ca da za. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Tu chí'izqueze be̱n gaca na chee̱' ca xicha da dxelácue̱', ne gaca na ca tu xpádxue̱' dxuluchela le̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Gaca da nigá da quizruj Xránadxu Dios benne' ca' dxelenné̱' cale̱la chia', ne da quízruje̱' benne' ca' dxelune̱' da cale̱la, ne dxelenné̱' cale̱la chee̱ bénne'du xu'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Xrana' Dios, be̱n culuén chia' chee̱ xegá'ana' xrlátaje lau'. Bselá neda' lawe' da dxexache lázrele̱'u bénneache, ");
INSERT INTO zatNTps_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","ne lawe' da dxezaca zi'a, ne dxexázrjeda', ne dxeque zi' lázrdawa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Dxedé chia' ca dxedé chee̱ tu zrul-la gate dxebía gubizra. Dxaca chia' ca dxaca chee̱ biche xuaj gate dxua be' le̱ba'. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Dxelate zriba' lawe' da dxuna' gubasa, ne nazrítale̱'a lawe' da quebe bi dxawa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Naca' ca tu da dxulucá'ana dítaje̱'. Dxelenné̱'e̱ neda', ne dxelún le̱' chia', dxulutá xíchaje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Gúcale̱ neda', Xrana' Dios. Bselá neda' lawe' da dxexache lazru' bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Be̱n xeleque be'ene̱' Lué'queze dxácale̱nu' neda'. Lué'queze, Xrana' Dios, ba nunu' da nigá. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Dxelegu'e̱ neda' de', san be̱n Lue' gaca chawe' chia'. Guxasa, be̱n xelexedué'e benne' ca' dxeledábague̱' neda', san be̱n beda' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Be̱n xelezrá' lu xel-la' stu' benne' ca' dxelenné̱' da cale̱la chia'. Be̱n xeleque zréajene̱' tu chí'izqueze. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Du lazra' gúl-laqueza' da güe lá'anale̱'a Xránadxu Dios. Ládujla benne' zan ca' güe lá'ana' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Le̱' zue̱' cuita xabe̱la chee̱ benne' xache' ca' chee̱ guselé̱' bénne'du zaj xu'e̱ lu na' benne' ca' dxuluchi'e̱ chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Xránadxu Dios guzre̱' Xrana': “Gudxé'e chalá'a xabe̱la chia' cadxa zrin zra guna' ga benne' ca' dxeledábague̱' lue' xuluzúa zribe̱' lau'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Naga zu' Sión, gun Xránadxu zriluj xel-la' dxenná bea chiu'. Dxenné̱': “Gunná be'e benne' ca' dxeledábague̱' lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Lu zra gate tíl-lale̱nu' benne' ca' dxeledábague̱' lue', du lázrequeze benne' chiu' ca' chjaque̱' wedil-la. Ca dxun xrle̱'e̱la chee̱ bálala, dxacu na xi'a lá'azxa, caníqueze xelaca benne' cuide' chiu' ca', xelelé̱'e̱ naga zu' xelácale̱ne' lue'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Guche̱be lazre' Xránadxu, ne quebe gunítie̱' xrtizre̱', gunné̱': “Chadía chacanna nacu' bxruze ca guca bxruze Melquisedec.” ");
INSERT INTO zatNTps_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Zua Xránadxu chalá'a xabe̱la chiu'. Gate zre̱'e̱, na' guzría xi'e̱ benne' wenná bea ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Guchi'e̱ chee̱ benne' dute̱ xe̱zr la xu, na' gutie̱' zánete̱ benne' xe̱zr la xu ca'. Guzría xi'e̱ benne' dxelenná be'e̱ dute̱ xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Xi'aj benne' wenná bea nigá nisa xé̱gudu zua na dxu'a neza, na' xexape̱' xel-la' wal-la chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Dute̱ lázrdawa' güe lá'ana' Xránadxu Dios tu zren nen benne' xrlátaje ca', benne' zaj nazrague̱' lau Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Da zrente̱ zaj naca da ca' nun Xránadxu Dios, na' xúgute̱ benne' ca' dxelezaca ba lázrele̱ne̱' da nune̱', ne dxelaca lazre̱' xelelé'ene̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Da xabáa, ne da xrtante̱ zaj naca da dxune̱' Le̱', ne tu chí'izqueze zua da xrlátaje chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Dxune̱' dxeajsá lázredxu ca naca xel-la' waca zrente̱ da dxune̱'. Xránadxu Dios naque̱' zren lazre', ne dxexache lazre̱' bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Dxugawe̱' benne' ca' dxelezrebe̱' Le̱'. Tu chí'izqueze dxeajsá lazre̱' xel-la' wezría da nune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Blé'ene̱' bénneache chee̱' ca' ca naca xel-la' waca chee̱ da ca' be̱ne̱'. Dxunézruje̱' benne' chee̱' ca' da zaj napa benne' xezica xe̱zr la xu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Li lazre', ne xrlátaje zaj naca da ca' dxune̱'. Li lazre' zaj naca xúgute̱ da bdxixruj be̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Tu chí'izqueze, ne chadía chacanna zaj zua da ca' bdxíxruje̱'. Lu da li, ne lu da li lazre' nune̱' ca zaj naca na. ");
INSERT INTO zatNTps_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Gusel-le̱' tu benne' weselá chee̱ guselé̱' bénneache chee̱'. Tu chí'izqueze nadxixruj be'e̱ xel-la' wezría chee̱'. Lá'azxa, ne tu da zrébedxu naca La Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Chee̱ su laudxu gácadxu sina, dxun na ba xen zrébedxu Xránadxu Dios. Dxeléajni'i xanne' xúgute̱ benne' ca' dxelune̱' ca zaj naca da nadxíxruje̱'. Tu chí'izqueze dxal-la' güe lá'anadxu Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Ba neza zrente̱ naca na chee̱ bénnea' dxezrebe̱' Xránadxu Dios, ne ca zaj naca da bdxixruj be̱'e̱ dxezaca ba lázrele̱'e̱ne̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Zri'ine zre sua bénnea' xelape̱' xel-la' dxenná bea lu xe̱zr la xu, na' gaca chawe' chee̱ benne' xrlátaje ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Da zan da de̱, ne xel-la' gunní'a zaj zra na xu'u lizre̱', ne tu chí'izqueze zua da xrlátaje da dxun bénnea'. ");
INSERT INTO zatNTps_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Dxusaní' tu xi' lu da chul-la naga zaj zra' benne' li lazre' ca', benne' ca' zaj naque̱' zren lazre', ne xrlátaje, ne dxelexache lazre̱' bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Tu benne' xrlátaje dxexache lazre̱' bénneache, ne dxusane̱' le̱' dumí. Lu da xrlátaje dxenná bé'ene̱' da zaj xu'u lu ne̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Chee̱ le̱ na' quebe bi gutá na le̱' lu lataj naga zue̱', na' tu chí'izqueze xeajlesá lazre̱' bénneache ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Quebe zrebe̱' gate xenne̱' dxaca da cale̱la chee̱ da xu'u lu ne̱'e̱. Ze̱ chacha lázrdawe̱' lawe' da dxuxrén lazre̱' Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Zua chawe' lázrdawe̱', ne quebe bi dxezrebe̱', ca zrindxa zra lé'ene̱' gaca chee̱ benne' ca' guledábague̱' le̱' ca da dxezá lazre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Dxisie̱' da de̱ chee̱', ne dxunézruje̱' da gácale̱ benne' xache' ca', ne tu chí'izqueze zua da xrlátaje da dxune̱'. Lu da xabáa xegá'ana szren xel-la' dxenná bea chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Walé'e benne' we̱n da cale̱la da nigá, na' gueque zréajene̱'. Gágu xa'ate̱ lazxe̱', ne cue'e̱ gunne xue. Xelenite da ca' dxelezá lazre' benne' ca' dxelune̱' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","¡Le'e, we̱n zrin chee̱ Xránadxu Dios, le güe lá'ana Le̱'! ¡Le güe lá'ana La Xránadxu Dios! ");
INSERT INTO zatNTps_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","¡Gaca ba lá'azxa La Xránadxu Dios, na'a zra, ne chadía chacanna! ");
INSERT INTO zatNTps_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","¡Naga dxalaj gubizra ca zrinte̱ naga dxebía na gaca ba lá'azxa La Xránadxu Dios! ");
INSERT INTO zatNTps_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","¡Szrente̱ nagá'ana Xránadxu Dios lawe' dute̱ xe̱zr la xu, na' láwela xabáa dxe' da xabáa chee̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","¿Núzraqueze naca ca naca Xránadxu Dios, Bénnea' dxe'e̱ xabáa na'la? ");
INSERT INTO zatNTps_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","Dios dxun cuine̱' dxexruj lazre' chee̱ lé'ene̱' da de̱ zran xabáa, ne lu xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Dios dxechise̱' benne' xache' lu xu xrte, ne dxebéaje̱' benne' baxache' lu da dxezaca zi'e̱, ");
INSERT INTO zatNTps_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","na' dxune̱' dxelebé' benne' caní ládujla benne' dxelenná be'e̱, ládujla benne' ca' dxelenná bé'ene̱' bénneache chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Dxune̱' zua nu'ula zue̱' tuze ládujla zrí'inequeze̱' ca', na' dxebé nu'ula nigá lawe' da naque̱' xrna bi cheé̱queze̱'. ¡Gaca ba lá'azxa Xránadxu Dios! ");
INSERT INTO zatNTps_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Gate beledxúaj benne' Israel ca' lu xe̱zr la xu Egipto, beledxúaj zri'ine zre sua Jacob lu xe̱zr la xu chee̱ benne' zitu' ca', ");
INSERT INTO zatNTps_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","na' gulaca zri'ine zre sua Judá ca tu xu'u lizre Dios, gulaca benne' Israel ca' naga dxenná be̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Ble'e Nísadau' Xrna da nigá, na' bzrunnuj na, na' gugá xe̱gu Jordán. ");
INSERT INTO zatNTps_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Gulexrite xi'a zri'a ca' ca dxelexrite chivo ca', na' gulexrite xí'adu ca' ca dxelexrite chíbudu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","¿Bizra guca chiu', nísadau', lawe' da be̱n na bzrúnnuju'? ¿Bizra guca chiu', xe̱gu Jordán, lawe' da be̱n na gugú'? ");
INSERT INTO zatNTps_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Le'e, xi'a zri'a ca', ¿Bizr chee̱ na' guxrítele ca dxelexrite chivo ca'? Le'e, xi'adu ca', ¿Bizr chee̱ na' guxrítele ca dxelexrite chíbudu ca'? ");
INSERT INTO zatNTps_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Dxezrize xe̱zr la xu lau Xránadxu Dios, lau Dios chee̱ Jacob. ");
INSERT INTO zatNTps_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Dios nigá be̱ne̱' bexaca xiaj xre' tu beaj nisa, na' bexaca xiaj tu ga dxalaj nisa. ");
INSERT INTO zatNTps_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Quegá netu', Xran. Quegá cuintu', san Lué'queze dxal-la' xucá'ana szrentu' ne̱ chee̱ xel-la' zri'i lazre' chiu', ne xel-la' li lazre' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","¿Bizr chee̱ na' dxun na ba xen xuluche̱be bénneache netu': “Gazra zua Dios chee̱le?” ");
INSERT INTO zatNTps_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Dios chee̱dxu zue̱' xabáa. Dxune̱' ca da dxaca lázrequeze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Dios ca' chee̱ benne' ca' zaj naca na bedáu' plata, ne bedáu' oro, da nun ni'a na' bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Zaj zua dxu'a na, san quebe dxelenné̱ na. Zaj zua xiaj lau na, san quebe dxelelé'e na. ");
INSERT INTO zatNTps_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Zaj zua naga na, san quebe dxelén na. Zaj zua zrina na, san quebe dxelelé'e na. ");
INSERT INTO zatNTps_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Zaj zua na' na, san quebe bi dxelecá'a na. Zaj zua ni'a na, san quebe dxeledá na. Quebe dxedxuaj chi'i na lba na. ");
INSERT INTO zatNTps_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Ca zaj naca na, zaj naca benne' ca' zaj nune̱' na, ne benne' ca' dxuluxrén lazre̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Le guxrén lazre' Xránadxu, le'e, benne' Israel ca'. Le̱' dxácale̱ne̱' le'e, ne dxuxúe̱' le'e. ");
INSERT INTO zatNTps_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Le guxrén lazre' Xránadxu, le'e, bxruze chee̱ Dios, nácale zri'ine zre sua Aarón. Le̱' dxácale̱ne̱' le'e, ne dxuxúe̱' le'e. ");
INSERT INTO zatNTps_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Le guxrén lazre' Xránadxu, le'e dxucá'ana szrenle Le̱'. Le̱' dxácale̱ne̱' le'e, ne dxuxúe̱' le'e. ");
INSERT INTO zatNTps_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Xránadxu dxajsá lazre̱' dxi'u, na' gune̱' dxi'u da chawe'. Gune̱' da chawe' chee̱ benne' Israel ca'. Gune̱' da chawe' chee̱ bxruze chee̱', zri'ine zre sua Aarón. ");
INSERT INTO zatNTps_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Gune̱' da chawe' chee̱ xúgute̱ benne' dxelape̱' Le̱' ba lá'ana, benne' blau ca', ne benne' quebe zaj naque̱' blau. ");
INSERT INTO zatNTps_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Gun Xránadxu chan zri'inu' ca', ne chan zri'ine bi biu chiu' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Gun Xránadxu da chawe' chiu'. Naque̱' Bénnea' be̱n xabáa, ne xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Chee̱ tuze Xránadxu naca xabáa, san bnézruje̱' bénneache xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Benne' zaj nate quebe gaca xelúe lá'ane̱' Xránadxu, ne quebe gaca benne' ca' zaj zue̱' lu xe̱dxu ba. ");
INSERT INTO zatNTps_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Dxi'u, benne' ban, güe lá'anadxu Xránadxu, na'a zra, ne chadía chacanna. ¡Le güe lá'ana Xránadxu! ");
INSERT INTO zatNTps_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","¡Nazrí'ida' Xránadxu Dios lawe' da benne̱' chi'a, ne da gunaba' lawe̱', ");
INSERT INTO zatNTps_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","ne lawe' da bze̱ nague̱' chia'! Chee̱ le̱ na' guláwizra' Le̱' dxácate̱ naca bana'. ");
INSERT INTO zatNTps_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Guzúa' lu da ste̱be chee̱ xel-la' gute, ne bzreba' ba zua' chu'a lataj ba xa'. Guzúa' lu da ste̱be, ne guzaca zi'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Nadxa bláwizra' Xránadxu Dios, gunnía': Xrana' Dios, bselá bénne'du xu'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Cháwe'le̱'e̱ naca Xránadxu Dios, ne xrlátaje naque̱'. Awe', dxexache lazre' Dios chee̱dxu dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Dxuxúe Xránadxu benne' dxexruj lazre' ca'. Gate na' guzúa' lu da ste̱be bselé̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Be̱n dipa lazre', bénne'du xu'a, lawe' da nun Xránadxu da chawe' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Lue', Xran, bseláu' bénne'du xu'a lu na' xel-la' gute, chee̱ québedxa cuezre we̱'a, ne chee̱ quebe cheajcházia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Ta' lau Xránadxu Dios naga zaj zra' benne' ca' zaj naca bane̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Guxéajle̱'a chee̱', na' chee̱ le̱ na' bchálaja', lácala guzaca zí'le̱'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Lu xel-la' dxezrebe chia', gunnía': Zaj naca xúgute̱ bénneache benne' we̱n lazre' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","¿Bizra quízrujqueza' Xránadxu Dios chee̱ xúgute̱ da chawe' da be̱ne̱' chia'? ");
INSERT INTO zatNTps_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Si'a lu ne̱'e̱ xel-la' weselá, ne guláwizra' Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Na'a guna' da ca' guche̱be lazra' lau Xránadxu. Guna' na lau xúgute̱ bénneache chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Xránadxu Dios dxe'e̱ gunne xue chee̱ bénneache chee̱' gate dxelátie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","Xrana' Dios, da li naca' we̱n zrin chiu'. Naca' we̱n zrin chiu', ne zri'ine nu'ula we̱n zrin chiu'. Lue' bzúzruju' da zaj nadxéaj na neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Da güe lá'ana' Lue' gaca na ca tu béadau' gutia' lau', ne gucá'ana szrena' Lau', Xrana' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Lau Xránadxu Dios guna' da ca' guche̱be lazra' chee̱', da guna' lau xúgute̱ bénneache chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","Guna' na chale'aj xu'u lizre Xránadxu Dios, da dxe' na lu'ule xe̱zre Jerusalén. ¡Gaca ba lá'azxa Xránadxu Dios! ");
INSERT INTO zatNTps_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","¡Le güe lá'ana Xránadxu Dios, le'e, benne' dute̱ xe̱zr la xu! ¡Le güe lá'ana Le̱', le'e, xúgute̱ bénneache, ");
INSERT INTO zatNTps_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","lawe' da zrente̱ naca xel-la' zri'i lazre' chee̱' ca nazrí'ine̱' dxi'u, ne chadía chacanna naca xel-la' li lazre' chee̱'! ¡Le güe lá'ana Xránadxu! ");
INSERT INTO zatNTps_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","¡Le güe lá'ana Xránadxu Dios lawe' da naque̱' xrlátaje, ne lawe' da chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Dxal-la' xelenná benne' Israel ca': ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Dxal-la' xelenná zri'ine zre sua Aarón: ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Dxal-la' xelenná benne' ca' dxelezrebe̱' Xránadxu Dios: ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Gate na' guzúa' lu da ste̱be bláwizra' Xránadxu Dios, na' beche̱be Xránadxu, ne bselé̱' neda' lu da na' be̱xru na neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Zuale̱ Xránadxu neda', na' québequeze zreba' bi xelún bénneache chia' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Zúale̱ Xránadxu neda' ládujla benne' ca' dxelácale̱ne̱' neda'. Chee̱ le̱ na' le'eda' cheajlechaze benne' ca' dxelecuídene̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Cháwe'dxa naca guxrén lázredxu Xránadxu Dios quézcala guxrén lázredxu bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Cháwe'dxa naca guxrén lázredxu Xránadxu Dios quézcala guxrén lázredxu benne' dxelenná be'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Gulechaj benne' xúgute̱ cue' xe̱zr la xu neda', na' lu La Xránadxu Dios guzría xi'a benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Guléchaje̱' neda', ne buluchídie̱' neda', na' lu La Xránadxu Dios guzría xi'a benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Guléchaje̱' neda' ca dxelún be̱scutuche', na' guca xel-la' dxelezrá'a chee̱' ca tu xi' da dxuzezxe na xixre' xeche' bizre, na' lu La Xránadxu Dios guzría xi'a benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Buluzrigue̱' neda' chee̱ cheajcházia' na' gúcale̱ Xránadxu Dios neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Naca Xránadxu Dios ca tu xu'u naga zua chawa', na' tu gúl-lazqueza' chee̱' lawe' da Lé̱queze̱' dxuselé̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Xel-la' dxelebé dxelul-la benne' xrlátaje ca' lawe' da dxuselá Xránadxu le̱'. Dute̱ xel-la' waca chee̱' dxun Xránadxu Dios da zrente̱ ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Szrente̱ nagá'ana xel-la' waca zren chee̱ Xránadxu Dios. Da zrente̱ ca' dxun xel-la' waca zren chee̱ Xránadxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Québequeze gatia', san gaca bana', na' guzenda' bénneache ca zaj naca da nun Xránadxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Bde Xránadxu neda' lu da ba xa', san quebe bdee̱' neda' lu na' xel-la' gute. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Gusalaj dxa xu'u chee̱ chu'a naga guchi'u chia', Xran, na' chu'a na', ne güe lá'ana' Lue', Xrana' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Dxa xu'u nigá naca na chee̱ Xránadxu Dios. Dxa xu'u nigá dxelú'u benne' xrlátaje ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Güe lá'ana' Lue', Xran, lawe' da bennu' chia', ne bseláu' neda' lu da guca chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Xiaj na' da buluzúa benne' we̱n xu'u ca' chalá'ala, le̱ na' naca na xiaj blau. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Da nigá be̱n Xránadxu, na' naca na tu da dxexebánedxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Zra nigá naca na zra da be̱n Xránadxu. Béle̱'e̱dxu, ne súadxu lu da ba neza lu zra nigá. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Xrana' Dios, dxata' xueda' Lue' guseláu' netu' na'a. Dxata' xueda' Lue', Xrana', gunu' chepe ban na'a da dxuntu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Ba neza zrente̱ naca na chee̱ bénnea' ze̱'e̱ waláz chee̱ Xránadxu Dios. Lu xu'u lizre Xránadxu Dios nigá dxenábantu' gaca chawe' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Xránadxu naque̱' Dios, ne ba be̱nne̱' dxi'u tu da dxusaní na. Le guchéaj béadu ca' gútele lawe̱' lu luzu cugu chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Nacu' Lue' Dios chia', na' güe lá'ana' Lue'. Dios chia', gucá'ana szrena' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","¡Le güe lá'ana Xránadxu Dios lawe' da naque̱' xrlátaje, ne lawe' da chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Ba neza zrente̱ naca na chee̱ benne' ca' tu dxelúnzqueze̱' da naca du lazre', benne' ca' tu dxelúnzqueze̱' ca dxenná da bdxixruj bea Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Ba neza zrente̱ naca na chee̱ benne' ca' tu dxelúnzqueze̱' ca dxuse̱de dizra' chee̱' dxi'u, na' dute̱ xichaj lázrdawe̱' dxuluzúe̱' dizra' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Benne' caní québequeze dxelune̱' da zrinnaj, benne' ca' tu dxelúnzqueze̱' ca dxenná Dios dxal-la' xelune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Lue', Xran, bsízrenu' netu' chee̱ gun xánnentu' ca zaj naca da bdxixruj be'u Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Dxaca lázrele̱'a tu gúnzqueza' ca zaj naca xrba chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Nadxa québequeze xedué'eda', na' cue'a gunne xue guna' xúgute̱ da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Dute̱ xel-la' li lazre' chia' güe lá'ana' Lue' gate ba nusé̱dia' da ca' nuchi'u chee̱ntu', da zaj naca na xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Tu gúnzqueza' ca da dxenná be'u. Québequeze cueaj xíchaju' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","¿Ájala gun benne' cuide' gunbe' da naca na xrlátaje? Dxal-la' tu gúnzquezebe' ca dxenná xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Dute̱ xichaj lázrdawa' dxuna' ba xuzre guna' da dxennáu' Lue'. Quebe gu'u lataj guzúa' chalá'ala ca da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Lu xichaj lázrdawa' tu dxúnzqueza' ca da dxennáu' Lue' chee̱ quebe guna' dul-la tábaga' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Ba lá'azxa nacu' Lue', Xrana' Dios. Bsé̱de neda' da ca' dxenná be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Nen dxú'aqueza' ba bzenda' bénneache ca zaj naca da ca' nuchi'u chee̱ntu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Dxebéle̱'e̱dxeda' tu dxúnzqueza' ca dxuse̱de dizra' chiu' netu', quez ca dxelebé benne' ca' dé̱le̱'e̱ xel-la' gunní'a chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Gulaba lazra' ca zaj naca da bdxixruj be'u Lue', ne nna' xánnia' ca dxennáu' dxal-la' guntu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Béle̱'e̱da' guna' ca da dxenná be'u, ne quebe gal-la lazra' ca zaj naca xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Be̱n gaca chawe' chia' neda', we̱n zrin chiu', na' gaca bana', ne tu gúnzqueza' ca naca xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Gusalaj xiaj lawa' chee̱ nna'a da zrente̱ ca' da zaj zua na lu da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Naca' ca tu benne' dxedaze̱' lu xe̱zr la xu nigá. Be̱n chéajni'ida' da dxenná da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Dxedú lazra' lawe' da tu chí'izqueze dxezá lazra' guna' da ca' nuchi'u chee̱ntu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Gudil-lu' benne' ca' dxulucá'ana szren cuine̱', benne' we̱n da cale̱la ca', benne' ca' dxuluzúe̱' chalá'ala da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Quebe gu'u lataj nu benne' nne̱' schanni' chia', na' quegá gucá'ana dítaje̱' neda' lawe' da tu dxúnzqueza' ca dxusé̱denu' netu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Cá'anqueze benne' dxelenná bea ca' gulenné̱' chia'. Neda', we̱n zrin chiu', blaba lazra' ca zaj naca xrba chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Dxezaca ba lázrele̱na' da dxuse̱de dizra' chiu' netu'. Dxuluzéajni'i na neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Zua bénne'du xu'a lu da ste̱be chee̱ xel-la' gute. Be̱n dipa xichaj lázrdawa' nen xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Ble'eda' Lue' ca zaj naca da dxuna', na' bezi'u neda'. Bse̱de neda' ca zaj naca xrba chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Be̱n chéajni'ida' ca gaca guna' ca bdxixruj be'u chee̱ gulaba lazra' ca zaj naca da zrente̱ ca' da be̱nu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Dxedú lazra' lawe' da dxewí'ine lázrele̱'a. Be̱xru chacha neda' ne̱ chee̱ xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Quebe gu'u lataj guna' da naca na we̱n lazre'. Lu xel-la' dxexache lazre' chiu' bse̱de neda' da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Bechugu lazra' guna' da naca li lazre', na' dxe'a gunne xue guna' da ca' nuchi'u chee̱ntu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Tu dxúnzqueza' ca dxuse̱de dizra' chiu' netu'. Xran, quebe guzú' neda' lu xel-la' stu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Tu gúnzqueza' ca bdxixruj be'u, gate guzéajni'idxenu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Xran, bse̱de neda' chee̱ guna' ca naca xrba chiu', na' tu gúnzqueza' ca naca na ca zrindxa zra cheajsé̱ chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Bzéajni'i neda', na' tu gúnzqueza' da bdxixruj be'u, na' dute̱ lázrdawa' guna' ca naca na. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Ble'e neda' chee̱ guna' da bdxixruj be'u, lawe' da dxaca lázrequeza' guna' ca dxenná na. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Be̱n sa lazra' guna' ca dxuse̱de dizra' chiu' netu', chee̱ quebe gaca' benne' wecude. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Quebe gu'u lataj gucá'ana szrena' bedáu' xia xaga ca'. Be̱n dipa xichaj lázrdawa' chee̱ guna' ca dxenná xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Be̱n ca dxenná xrtizru' da guche̱be lazru' chia' neda', we̱n zrin chiu', chee̱ zreba' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Bde chalá'ala dizra' schanni' da dxelenné̱' chia', da na' dxezreba', lawe' da xrlátaje zaj naca xrba chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Dxezá lazra' guna' da bdxixruj be'u. Be̱n dipa xichaj lázrdawa' nen da xrlátaje chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Gudá xexache lazru' neda', Xrana' Dios. Gudá guseláu' neda', ca ba guche̱be lazru' gunu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Beche̱ba' lau bénnea' dxusi'e̱ neda' xel-la' stu', gunnía': Dxuxrén lazra' xrtizra' Xrana' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Be̱n tu séquezda' guchálaja' dizra' li lazre' chiu', lawe' da dxebeza lazra' da ca' dxuchi'u chee̱ntu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Tu gúnzqueza' ca dxenná da bdxixruj be'u. Guna' na tu chí'izqueze, ne chadía chacanna. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Láqueza' neda' lawe' da dxe'a gunne xue guna' ca bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Guchálajqueza' ca dxuse̱de dizra' chiu' netu' lau benne' wenná bea ca', na' québequeze xedué'eda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","Wabéle̱'e̱quezda' guna' ca bdxixruj be'u, da ca' nazrí'ile̱'e̱da'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Dxeche̱be lazra' guna' ca bdxixruj be'u, da nazrí'ida', na' gulaba lazra' ca naca xrba chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Bsa lazre' da guche̱be lazru' chia' neda', we̱n zrin chiu', da na' be̱nu' dxebeza lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Gate na' guzaca zi'a, guzúa tu da bexúe zren na neda' lawe' da be̱n dipa xrtizru' xichaj lázrdawa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Benne' dxulucá'ana szren cuine̱' belún lale̱' chia' neda', san québequeze gusana' da dxenná da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Xeajsá lazra' da bchi'u chee̱ntu' nédxudaute̱, Xran, na' bexaca zrena'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Nen dute̱ xel-la' dxezrá'a guzúa' lu da ste̱be ne̱ chee̱ benne' ca' dxelune̱' da zrinnaj, benne' ca' dxuluzúe̱' chalá'ala da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Xrba chiu' ca' gulaca na chia' ca tu da dxul-la' gate na' zua' tu xe̱zr la xu zitu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Chizrela xeajsá lazra' lau' Lue', Xrana' Dios, na' tu bénzqueza' ca dxenná da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Lu da ba neza caní guzúa' lawe' da tu bé̱nzqueza' ca zaj naca da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Da dxezá lazra' nácaquezu' Lue', Xrana' Dios. Ba gunnía' tu gúnzqueza' ca naca xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Dute̱ lázrdawa' dxenaba' Lue' xidu' gácale̱nu' neda'. Bexache lazre' neda' ca ba gunnáu' gunu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Gunná' xannia' ca zaj naca da dxuna', na' xecha lasa dxuna' ca dxuse̱de dizra' chiu' netu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Be̱na' ba xuzre, ne quebe guzreda' chee̱ tu gúnzqueza' ca bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Xralaj chee̱ benne' ca' dxelune̱' da cale̱la zaj nuchele̱ na neda', san quebe ne gal-la lazra' ca dxenná da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Dxe̱la dxasa' chee̱ güe lá'ana' Lue' lawe' da xrlátaje zaj naca da ca' dxuchi'u chee̱ntu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Naca' tuze nen xúgute̱ benne' ca' dxelezrebe̱' Lue', benne' ca' tu dxelúnzqueze̱' da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Xrana' Dios, dxezrín dute̱ xe̱zr la xu xel-la' dxexache lazre' chiu'. Bse̱de neda' chee̱ guna' ca dxenná xrba chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Ba be̱nu' guca chawe' chia' neda', we̱n zrin chiu'. Xran, be̱nu' na cáte̱ze dxenná xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Bse̱de neda' chee̱ gueque be'eda' da naca xrlátaje, ne chee̱ chéajni'ida' lawe' da dxéajle̱'a da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Nédxula ca bzéxruju' neda' gudéa' chalá'ala, na' na'a tu dxúnzqueza' ca dxenná xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Nacu' xrlátaje, ne dxunu' gaca chawe' chee̱ntu'. Bse̱de neda' guna' ca naca xrba chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Benne' dxulucá'ana szren cuine̱' gulenné̱' chia' da we̱n lazre' san dute̱ lázrdawa' tu gúnzqueza' ca bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Quebe xu'u xel-la' dxéajni'i lázrdau benne' ca'. Neda' dxezaca ba lázrele̱na' da dxenná da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Chawe' naca bzéxruju' neda' chee̱ gusé̱dia' guna' ca naca xrba chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Cháwedxa naca da bdxixruj be'u chia' neda' quez ca gaxúa gaxúane dumí oro, ne plata. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Nen ná'quezu' be̱nu' neda' cáte̱ze naca'. Bzéajni'i neda' chee̱ gusé̱dia' guna' ca bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Benne' dxelezrebe̱' Lue' xelelé'ene̱' neda'. Xelebene̱' lawe' da dxebeza lazra' gaca ca dxenná xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","Xran, ba nézquezda' xrlátaje naca da dxuchi'u chee̱ntu', na' lu dute̱ xel-la' li lazre' chiu' bsaca zi'u neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Lu dute̱ xel-la' dxexache lazre' chiu' bexúe zren neda' cáte̱ze dxenná da guche̱be lazru' chia' neda', we̱n zrin chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Bexache lazre' neda' chee̱ gaca bana' lawe' da dxezaca ba lázrele̱na' da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Be̱n xelexedué'e benne' ca' dxulucá'ana szren cuina lawe' da gulenné̱' schanni' chia', ne quebe bi bena' chee̱'. Neda' gulaba lazra' ca da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Be̱n xelexelá' benne' ca' dxelezrebe̱' Lue', chee̱ xelenne̱' chia', na' xulusé̱die̱' da dxuse̱de dizra' chiu' netu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Be̱n gaca' du lazre' ca naca xrba chiu' chee̱ québequeze xedué'eda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Zua bénne'du xu'a lu da ste̱be lawe' da dxebeza' xidu' guseláu' neda', na' dxebeza lazra' gaca ca dxenná xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Dxezé̱ bxrinne xiaj lawa' lawe' da dxezá lazra' xrtizru', dxennia': ¿Bátaqueze xexúe zrenu' neda'? ");
INSERT INTO zatNTps_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Dxebizra' ca tu buzude xide ze̱ na lu zren, san quebe dxal-la lazra' guna' ca dxenná xrba chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","¿Bal-la zra gaca bana' neda', we̱n zrin chiu'? ¿Bátaqueze gudéu' lu da ba xa' benne' ca' dxeláu zi' xuzre̱' neda'? ");
INSERT INTO zatNTps_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Benne' dxulucá'ana szren cuine̱' gule̱ne̱' tu xe̱dxu naga cheajcházia'. Québequeze dxelune̱' ca dxenná da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Da líqueze zaj naca xúgute̱ da bdxixruj be'u. Gúcale̱ neda' lawe' da dxeláu zi' xuzre̱' neda', ne quebe bi nuna' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Xeláteze la belutie̱' neda', san quebe ne gusana' guna' ca bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Lu xel-la' dxexache lazre' chiu' be̱n dipa xichaj lázrdawa', chee̱ tu gúnzqueza' ca dxuse̱de dizra' chiu' netu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Xrana' Dios, tu chí'izqueze zua xrtizru' xabáa na'la. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Xel-la' li lazre' chiu' sua na chee̱ xúgute̱ bénneache. Lue' bzua chúchuquezu' xe̱zr la xu, na' zúaqueze na. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Ne̱ chee̱ da gunnáquezu' zaj nnita xúgute̱ da de̱, na' xúgute̱ da ca' dxelún na zrin chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","La quebe bezaca ba lázrele̱na' da bdxixruj be'u bache benítia' lu da guzaca zi'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Cabátaqueze gal-la lazra' da bdxixruj be'u lawe' da ne̱ chee̱ da ca' ba btipu' lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Chiu' Lue' naca' neda'. Bselá neda', lawe' da dxuna' ba xuzre guna' ca bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Benne' dxelebéaj xichaj Dios gulenné̱'e̱ neda' chee̱ xuluzría xi'e̱ neda', san neda' dxulaba lazra' ca dxuse̱de dizra' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Dxelé'equezda' dxeajsé̱ chee̱ xúgute̱ da de̱ lu xe̱zr la xu, san da bdxixruj be'u Lue' québequeze cheajsé̱ chee̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Dios, nazrí'ile̱'e̱da' da bdxixruj be'u. Du zra dxulaba lazra' ca naca na. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Ne̱ chee̱ da bdxixruj be'u nunu' nácadxa' sina ca benne' ca' dxeledábague̱' neda' lawe' da tu zúale̱zqueze da bdxixruj be'u neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Dxéajni'idxeda' ca benne' ca' dxulusé̱dene̱' neda' lawe' da dxulaba lazra' ca dxuse̱de dizra' chiu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Ba guxéajni'idxeda' ca benne' gula ca' lawe' da tu dxúnzqueza' ca dxenná da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Be̱na' ba xuzre quebe bi da cale̱la guna' chee̱ tu gúnzqueza' ca dxenná xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Quebe bsana' dxuna' da ca' nuchi'u chee̱ntu' lawe' da Lué'queze bsé̱denu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Xrtizru' naca na ca tu da zíxrele̱'e̱ lu dxu'a. Nácadxa na zixre ca bzrína'dau' lu dxu'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Ne̱ chee̱ da bdxixruj be'u naca' benne' sina. Chee̱ le̱ na' dxecuídeda' xúgute̱ da we̱n lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Ca tu xi' naca xrtizru' naga dxedá', da dxusení na neza xu'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Bzétaja' Dios, ne guche̱be lazra' tu gúnzqueza' ca nuchi'u chee̱ntu' da naca na xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Dxezaca zí'le̱'a. Xrana' Dios, btipa lazra' cáte̱ze guche̱be lazru' gunu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Xrana' Dios, dxata' xueda' Lue' si'u da dxue lá'ana' Lue', ne gusé̱denu' neda' guna' ca nuchi'u chee̱ntu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Tu zúazqueza' lu da ste̱be chee̱ xel-la' gute, san québequeze ne gal-la lazra' guna' ca bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Benne' dxelebéaj xichaj Dios buluzale̱' xralaj da que̱la na neda' san neda' quebe bsana' dxuna' ca bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Ba gucá'a da dxuse̱de xrtizru' neda' chee̱ gaca na da gápaqueza' chadía chacanna lawe' da zaj naca xrtizru' da dxezaca ba lázrele̱'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Zúate̱queze lázrdawa' guna' ca zaj naca xrba chiu' tu chí'izqueze, ca zrindxa zra cheajsé̱ chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Dxecuídeda' benne' ca' dxelune̱' láweze da xrlátaje, san nazrí'ida' da dxenná da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Nacu' Lue' ca tu xu'u naga zua chawa', ne ca tu da dxucu'uj na neda', lawe' da dxebeza lazra' gaca na ca dxenná xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Le gucuasa naga zua', le'e, benne' we̱n da cale̱la, lawe' da tu gúnzqueza' ca bdxixruj bea Dios chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Bze̱ chacha neda' cáte̱ze dxenná xrtizru', na' gaca bana', ne quebe xedué'eda' chee̱ da na' dxebeza lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Bze̱ chacha neda', na' la', ne tu xezaca ba lázrezqueza' ca naca xrba chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Bchuchu bléaju' xúgute̱ benne' ca' bulusane̱' ca naca xrba chiu' lawe' da we̱n lazre' naca xel-la' sina chee̱ benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Ca be̱be bzria xi'u xúgute̱ benne' ca' dxelebéaj xíchaje̱' Lue' lu xe̱zr la xu nigá. Chee̱ le̱ na' nazrí'ida' da dxuse̱de dizra' chiu' netu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Dxezrize be̱la' dxen chia' lawe' da dxezreba' Lue', ne dxezreba' da dxuchi'u chee̱ntu' da naca na xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Ba be̱na' ca da nuchi'u chee̱ntu', ne ca naca da xrlátaje. Quebe gudéu' neda' lu na' benne' ca' dxuluchínene̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Guche̱be lazre' chia' gunu' gaca chawe' chia'. Quebe gu'u lataj benne' ca' dxulucá'ana szren cuine̱' xuluchínene̱' neda' xadía. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Guzé̱ bxrinne xiaj lawa' lawe' da dxebeza' xidu' guseláu' neda', ne guchi'u chee̱ntu' ca dxenná xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Dute̱ xel-la' dxexache lazre' chiu' be̱n gaca chawe' chia' neda', we̱n zrin chiu', ne bse̱de neda' guna' ca naca xrba chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Naca' we̱n zrin chiu'. Bzéajni'i neda' chee̱ gúnbe'a da dxuse̱de dizra' chiu' netu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Xrana' Dios, ba bzrin zra bi gunu', lawe' da ba buluzúe̱' chalá'ala da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Chee̱ le̱ na' neda' nazrí'idxeda' da bdxixruj be'u Lue' quézcala oro, ne quézcala galega oro. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Chee̱ le̱ na' dxéqueda' zaj nácadxa li lazre' da bdxixruj be'u ca xúgute̱ da de̱, na' dxecuídeda' xúgute̱ da zaj naca na da we̱n lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Dxebánentu' ca dxuse̱de dizra' chiu' netu'. Chee̱ le̱ na' du lazra' tu dxúnzqueza' ca dxenná na. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Gate nu dxuzájla'a ca naca xrtizru', dxusaní na. Dxun na dxeléajni'i benne' dxexruj lazre' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Guxá dxu'a, ne gucá'a lazra' lawe' da dxezá lazra' gúnbe'a da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Gunná' neda', ne bexache lazre' neda', ca tu dxúnzquezu' chee̱ benne' ca' zaj nazrí'ine̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Be̱n tu gúnzqueza' ca dxenná xrtizru', ne quebe gu'u lataj da zrinnaj nna be'e na neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Bselá neda' lu na' benne' xichaj zra'a ca', na' tu gúnzqueza' ca dxenná da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Be̱n gaca chawe' chia' neda', we̱n zrin chiu', ne bse̱de neda' guna' ca zaj naca xrba chiu' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Nisa gudxezra' guca na ca tu xe̱gu nisa lawe' da quebe dxelún bénneache ca bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Xrana' Dios, xrlátaje nacu' Lue', ne li lazre' naca ca dxuchi'u chee̱ntu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Da dxuse̱de dizra' chiu' netu', da na' bzu' lu na'ntu', naca na da li, ne da li lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Dxedú lazra' lawe' da dxé'le̱'a gunne xue lawe' da gulal-la lazre' benne' ca' dxeledábague̱' neda' ca zaj naca xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Du lázrele̱'e̱ naca xrtizru', na' nazrí'ida' neda' na, naca' we̱n zrin chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Dxexruj lazre' naca', na' dxuluzúe̱' neda' chalá'ala, na' quebe ne gal-la lazra' da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Tu chí'izqueze zua da dxuchi'u chee̱ntu', na' da li naca da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Da dxezaca zi'a, ne da ste̱be zua' zaj nuchuchuj na neda', san dxezaca ba lázrele̱na' da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Tu chí'izqueze naca li lazre' da dxuse̱de dizra' chiu'. Bzéajni'i neda', na' gaca bana'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","Dute̱ lázrdawa' dxuláwizra' Lue', Xrana' Dios. Be̱n gaca chawe' chia', na' tu gúnzqueza' ca dxenná xrba chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Dxuláwizra' Lue'. Bselá neda', na' tu gúnzqueza' ca dxuse̱de dizra' chiu' netu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Bálala dxasa', na' dxuláwizra' Lue'. Dxebeza lazra' gaca ca dxenná xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Dxenná'aza' bedú xe̱la, chee̱ gulaba lazra' da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Dute̱ xel-la' dxexache lazre' chiu' bene chi'a. Xrana' Dios, da bchi'u chee̱ntu' btipa lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Benne' dxeláu zi' xuzre̱' neda' ba zaj zre̱'e̱ xelune̱' chia' da cale̱la. Zaj nusane̱' da dxenná da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Xrana' Dios, zu' Lue' gagu naga zua', ne da li zaj naca xúgute̱ da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Gate nate ba núnbe'a da dxuse̱de dizra' chiu' netu', da na' nuzú' chee̱ntu' tu chí'izqueze. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Gunná' xque ca dxezaca zi'a, ne bselá neda' lawe' da quebe ne gal-la lazra' da dxenná da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Beche̱be waláz chia', ne bexa'u neda'. Btipa lazra' nen xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Sté̱bele̱'e̱ naca xelelá benne' ca' dxelebéaj xíchaje̱' Lue', Dios, lawe' da quebe dxelebé'e̱ gunne xue xelune̱' ca naca xrba chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Xrana' Dios, dxexache lázrele̱'u bénneache chiu'. Btipa lazra' cáte̱ze dxenná xrtizru' gunu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Zánete̱ zaj naca benne' ca' zaj nau zi' xuzre̱' neda', ne benne' ca' dxeledábague̱' neda', san quebe ne gusana' dxuna' ca dxuse̱de dizra' chiu' netu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Ble'eda' benne' ca' dxelún lazre̱', na' dxegúteda' benne' ca' lawe' da quebe dxelune̱' ca dxenná xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Gunná'xque, Xran, ca nazrí'ida' da bdxixruj be'u. Dute̱ xel-la' dxexache lazre' chiu', btipa lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Da líqueze zaj naca xúgute̱ xrtizru', ne tu chí'izqueze zaj naca da dxuchi'u chee̱ntu' lu da xrlátaje chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Benne' ca' dxelenná be'e̱ dxeláu zi' xuzre̱' neda' na' quebe bi nuna' chee̱'. Dute̱ lázrdawa' dxezreba' ca zaj naca xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Dxebéle̱'e̱da' lu da dxenná xrtizru' ca dxebé bénnea' dxezrél-lene̱' tu xel-la' gunní'a zrente̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Dxecuídeda', ne dxegúteda' da we̱n lazre'. Nazrí'ida' da dxenná da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Gazre lasa tu zra dxue lá'ana' Lue' lawe' da xrlátaje naca ca dxuchi'u chee̱ntu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Dxelebeza zri lázrele̱'e̱ benne' ca' zaj nazrí'ine̱' da bdxixruj be'u, na' quebe bi de̱ da gun na cheajlecházie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","Xrana' Dios, dxebeza' Lue' xidu' guseláu' neda', ne tu dxúnzqueza' ca naca da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Dute̱ lázrdawa' tu dxúnzqueza' da dxuse̱de dizra' chiu' netu', ne nazrí'ile̱'e̱da' ca naca na. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Tu dxúnzqueza' ca naca da bdxixruj be'u, ne ca dxuse̱de dizra' chiu' netu' lawe' da dxelé'equeznu' xúgute̱ da dxuna'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","Xrana' Dios, bene da dxuláwizra' Lue'. Bzéajni'i neda' ca dxenná xrtizru' gunu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Bene da dxenaba' lau Lue'. Bselá neda' ca dxenná xrtizru' gunu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Tu güe lá'anazqueza' Lue', Xran, gate ba nusé̱denu' neda' guna' ca naca xrba chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Tu guchálajzqueza' ca naca xrtizru' lawe' da xrlátaje naca ca dxenná be'enu' netu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Guzúate̱queze gácale̱nu' neda' lawe' da dxuna' ba xuzre guna' ca bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","Dxezá lazra' guseláu' neda', Xrana' Dios. Dxezaca ba lázrele̱na' da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Be̱n gaca bana', na' güe lá'ana' Lue', na' da dxuchi'u chia' xelácale̱ na neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Gudéa' chalá'ala ca dxedá tu zrila' naníteba'. Bexilaj neda', we̱n zrin chiu', lawe' da quebe ne gal-la lazra' da bdxixruj be'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Gate guzúa' lu da ste̱be bláwizra' Xránadxu Dios, na' Le̱' gúcale̱ne̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","Bselá neda', Xrana' Dios, lu na' benne' we̱n lazre' ca', ne lu na' benne' dxelezí xe̱'e̱ ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","¿Bizra gunna Dios le'e, benne' dxelezí xe̱'e̱? ¿Bizra da ba neza gaca na chee̱le gate gudée̱' le'e lu da zi' da xa'? ");
INSERT INTO zatNTps_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Gudée̱' le'e lu na' benne' ca' xuludé̱'e̱ le'e xaga nalá xéche'ze, ne xuluzríe̱' le'e xi' galaj. ");
INSERT INTO zatNTps_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Edxugúa neda'. Dxaca chia' ca zúaqueza' ládujla benne' Mesec, ne ca zua' tu lu xu'u xide chee̱ benne' Cedar. ");
INSERT INTO zatNTps_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Da zrente̱ ba guzúa' ládujla benne' caní dxuluzúe̱' chalá'ala xel-la' dxebeza zri lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Neda' dxezá lazra' gata' xel-la' dxebeza zri lazre'. Gate dxuchálaja' chee̱n, dxeledíl-lale̱ benne' ca' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Chisa xíchaja' nna'a da dxelún bénneache lu xi'a ca'. ¿Gazra za' da gácale̱ na neda'? ");
INSERT INTO zatNTps_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Da gácale̱ na neda' za' lu na' Xránadxu Dios, Bénnea' be̱ne̱' xabáa, ne xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Quebe gu'e̱ lataj cheajcháziu'. Quebe gase Bénnea' dxuxúequeze̱' lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Gunná' xque, quebe te bchigala chee̱ Bénnea'. Québequeze gase Bénnea' dxuxúequeze̱' benne' Israel ca. ");
INSERT INTO zatNTps_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Xránadxu Dios dxucú'uje̱' lue'. Xránadxu Dios zue̱' cuitu' xabe̱la dxegu'e̱ lue' zrul-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Quebe guzezxe gubizra lue' te zra, ne quebe bi gune beu' lue' chizrela. ");
INSERT INTO zatNTps_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Xranu' Dios guxúequeze̱' lue' chee̱ quebe bi da cale̱la gaca na chiu'. Guxúequeze̱' bénne'du xu'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Xránadxu Dios guxúequeze̱' lue' gate dxedxúaju', ne gate dxexú'u, na'a zra, ne chadía chacanna. ");
INSERT INTO zatNTps_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Gubéle̱na' benne' ca' gulé̱'e̱ neda': “Chéajdxu xu'u lizre Xránadxu Dios.” ");
INSERT INTO zatNTps_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Na'a zúadxu nigá, ze̱ntu' dxa xu'u ze'e da naxechaj lue', xe̱zre Jerusalén. ");
INSERT INTO zatNTps_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Jerusalén naca na tu xe̱zre da belexune̱', na' naca na xrtante̱, ne dxé'le̱'e̱ na cháwedau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Lu xe̱zre na' zjaca xúgute̱ cuen bénneache zaj de̱'e̱ Xránadxu Dios. Dxelune̱' ca dxenná dizra' da guzre Dios benne' Israel ca', chee̱ xelúe lá'ane̱' La Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Lu xe̱zre na' zaj dxe' benne' ca' dxuluchi'e̱ chee̱ benne' Israel ca', naga zaj dxe' benne' xrtia David, benne' ca' dxelenná be'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Le naba lau Dios gata' xel-la' dxebeza zri lazre' lu xe̱zre Jerusalén, chee̱ xelepe ban da dxelún benne' ca' zaj nazrí'ine̱' xe̱zre na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Dxenábantu' Dios sua xel-la' dxebeza zri lazre' lu'ule ze'e da naxechaj na lue', Jerusalén, ne chee̱ xelezrá' chawe' benne' zaj xu'e̱ xu'u zren chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Nazrí'ida' le sa' ljwezra', ne bi ljwezra' ca', na' dxennía': Gata' xel-la' dxebeza zri lazre' chiu', xe̱zre Jerusalén. ");
INSERT INTO zatNTps_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Lawe' da nazrí'ida' xu'u lizre Xránadxu Dios dxuna' ba xuzre gaca chawe' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","Chisa xíchaja' nna'a naga zu', Xran, naga zu' Lue', zu' xabáa na'la. ");
INSERT INTO zatNTps_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Ca dxun tu bi we̱n zrin dxenná'abe' bi nna xránabe', ne ca dxun nu'ula we̱n zrin dxenná'abe' bi nna nu'ula xránabe', caní dxenná'adxu bi nna Xránadxu Dios ca zrindxa zra xexache lazre̱' chee̱dxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Bexache lazre' chee̱ntu', Xránantu' Dios. Bexache lazre' chee̱ntu', lawe' da dxedú lázrentu' lawe' da dxulucá'ana ditaj bénneache netu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Dxedú lázrentu' lawe' da dxelún lala benne' gunní'a ca' chee̱ntu', ne dxulucá'ana ditaj netu', benne' ca' dxulucá'ana szren cuine̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Chela ca gúcale̱ Xránadxu Dios dxi'u. Caní dxal-la' xelenná benne' Israel ca' na'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","Chela ca gúcale̱ Xránadxu Dios dxi'u gate guledíl-lale̱ benne' ca' dxi'u, ");
INSERT INTO zatNTps_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","na' buluzría xi'te̱' dxi'u lu dute̱ xel-la' dxelezrá'a zrente̱ chee̱', ");
INSERT INTO zatNTps_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","ne guca chee̱dxu ca dxaca chee̱ benne' dxugacu nísadau' le̱', da na' gute na le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","Chela guca caní chee̱dxu, na' bé̱tete̱ da na' dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Dxal-la' xe̱dxu Xránadxu Dios; Xcalenu', lawe' da quebe be̱'e̱ lataj benne' ca' xuluzría xi'e̱ dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Beladxu ca dxelá tu bxinne lu xixruj chee̱ benne' wezén bxinne. Bzria xi' Xránadxu xel-la' dxenná bea chee̱ benne' ca', na' beladxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Naca Xránadxu Dios Bénnea' dxácale̱ne̱' dxi'u, Bénnea' bé̱nqueze̱' xabáa, ne xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Benne' ca' dxuluxrén lazre' Xránadxu Dios zaj naque̱' ca xi'a Sión, da quebe nu seque' gutá, san tu chí'izqueze zua chacha na. ");
INSERT INTO zatNTps_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Ca zaj zua xi'a ca' da zaj naxechaj na Jerusalén, zua Xránadxu Dios, dxuxúequeze̱' bénneache chee̱' na'a zra, ne chadía chacanna. ");
INSERT INTO zatNTps_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Quegá tu chí'izqueze xelenná bea benne' ca' dxelune̱' da cale̱la lu xe̱zr la xu chee̱ benne' xrlátaje ca', chee̱ quebe xelaca benne' xrlátaje ca' tuze nen benne' we̱n da zrinnaj ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Xrana' Dios, be̱n gaca chawe' chee̱ benne' xrlátaje ca', ne chee̱ benne' ca' zaj naque̱' li lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Benne' ca' dxelebéaj xichaj Dios chee̱ xelune̱' da cale̱la, xucuasa Xránadxu Dios benne' ca' tu zren nen benne' ca' dxelune̱' da zrinnaj. Dxenaba' gata' xel-la' dxebeza zri lazre' chee̱ benne' Israel ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Gate Xránadxu Dios bselé̱' dxi'u lu na' benne' zitu' ca', ne begu'e̱ dxi'u lu xe̱zre Sión, gúquedxu dxenne̱dxu xe̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Nadxa bzrízredxu, ne be̱ lá'anadxu Xránadxu Dios. Nadxa gulenná benne' xe̱zr la xu ca': “Da zrente̱ ca' be̱n Dios, Xrana benne' ca', chee̱'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Da zrente̱ ca' be̱n Xránadxu Dios chee̱dxu dxi'u, na' zúadxu lu da ba neza zrente̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Bselá Xránadxu dxi'u lu na' benne' zitu' ca', na' bezrindxu lu xe̱zr la xu chee̱dxu ca dxezrín nisa guba'u lu xe̱gu bizre ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Benne' ca' dxelebezre̱' tie̱' dxelaze̱', nen xel-la' dxelebé xelexezi'e̱ lina. ");
INSERT INTO zatNTps_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Dxebezre tie̱' zéaje̱' nu'e̱ binne cháwe'du ca', na' dute̱ xel-la' dxebé dxezrine̱' zeajnu'e̱ lina chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Chela ca zúale̱ Xránadxu Dios benne' ca' dxelune̱' tu xu'u dácheze naca xelune̱' zrin na'. Chela ca dxuxúe Xránadxu Dios tu xe̱zre, dácheze naca dxuluxúe benne' ca' le̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Dácheze naca dxásaze̱le che zílala, ne dxunle zrin cáte̱ze dxalaj gubizra ca dxebíadxa na, ne dute̱ xel-la' dxudía dxezile da gágule, lawe' da dxunna Dios da xelagu benne' ca' nazrí'ine̱' dxácate̱ na' dxelásie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Le nna' xque, zaj naca zrí'inedxu bi ca' be̱nna Xránadxu dxi'u. Zaj naca be̱' tu da gunní'a zrente̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Zrí'inedxu dxelálajbe' chee̱dxu gate ne nácadxu cuide' zaj nácabe' ca xaga nalá xéche'ze ca' da nuxru benne' zeje̱' wedil-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Ba neza zrente̱ naca na chee̱ bénnea' nuxrue̱' zánete̱ xaga nalá xéche'ze caní. Québequeze xedué'ene̱' gate zri'a chee̱' tu zren nen benne' ca' dxeledíl-lale̱ne̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Ba neza zrente̱ naca na chee̱ benne' ca' dxelezrebe̱' Xránadxu Dios, benne' ca' tu dxelúnzqueze̱' ca nadxixruj be'e Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Gate dxagu' da dxezi'u chee̱ zrin da nunu' gaca chiu' tu da ba neza, ne gaca chawe' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Gaca zru'ulu' ca tu lba uva da dxebía da zixre cuita xu'u lizru', na' zri'inu' ca' xelácabe' ca xaga olivo ca' zaj ze̱ dxu'a ga dxagu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Caní gun Xránadxu gaca chawe' chee̱ bénnea' dxezrebe̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Dxenaba' gun Xránadxu, zue̱' xi'a Sión, gaca chawe' chiu', chee̱ le'enu' gaca chawe' chee̱ xe̱zre Jerusalén xúgute̱ zra naca banu', ");
INSERT INTO zatNTps_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","ne chee̱ le'enu' zri'ine zre su'. Dxenaba' gata' xel-la' dxebeza zri lazre' chee̱ benne' Israel ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Zúadxu lu da sté̱bele̱'e̱ gate nácate̱dxu cuide', waca xelenná benne' Israel ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","Zúadxu lu da sté̱bele̱'e̱ gate nácate̱dxu cuide' san quebe buluzria xi'e̱ dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Belune̱' we̱' cúzrudxu gate beline̱' dxi'u xide, na' gulaca cúzrudxu ca xe̱zr la xu naga dxedé xia chee̱ be̱zre. ");
INSERT INTO zatNTps_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Xlátaje̱ naca Xránadxu Dios. Bselé̱' dxi'u lu na' benne' ca' buluchínene̱' dxi'u xadíaze. ");
INSERT INTO zatNTps_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Be̱n cheajlechaze, ne xelebígaqueze xúgute̱ benne' ca' dxelecuídene̱' benne' Sión ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Be̱n xelaque̱' ca xíxre'du ca' dxelebía na xrgu'u da dxelebizre na gate ne zaj nadxé'ene na, ");
INSERT INTO zatNTps_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","da na' quebe nu benne' dxexequé̱'e̱ na, ne quebe seque' nu benne' gune̱' na tu cheaj weaj. ");
INSERT INTO zatNTps_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","Quebe xelenná benne' dxeledée̱' naga zaj zria na: Dxenábantu' gun Xránantu' Dios gaca chawe' chee̱le. Lu La Xránantu' Dios dxenábantu' gaca chawe' chee̱le. ");
INSERT INTO zatNTps_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Ga ni zua' lu da sté̱bele̱'e̱ dxuláwizra' Lue', Xrana' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","¡Xran, bene chi'a! ¡Bze̱ naga da dxenaba' lau'! ");
INSERT INTO zatNTps_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Xrana' Dios, chela nna' xánniu' ca naca dul-la nabágantu' ¿núzraqueze xegá'ana xrlátaje lau Lue'? ");
INSERT INTO zatNTps_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Lué'quezu' dxunite lau' chee̱ntu' chee̱ gápantu' Lue' ba lá'ana. ");
INSERT INTO zatNTps_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Dute̱ lázrdawa' dxebeza lazra' Xránadxu Dios, ne dxuxrén lazra' xrtizre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Dxebeza lazredxa' Xránadxu Dios cáqueze dxelún benne' ca' dxuluxúe̱' xe̱zre ca', dxelebeze̱' chaní', ne cáqueze dxelún benne' ca' dxelicha bchigala, dxelebeze̱' chaní'. ");
INSERT INTO zatNTps_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Benne' Israel ca' dxal-la' xelebeza lazre̱' Xránadxu Dios lawe' da dxexache lazre' Xránadxu bénneache chee̱', ne dxexá'awe̱' benne' ca' lu na' benne' guledábague̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Dios xexá'awe̱' benne' Israel ca' lu na' xúgute̱ dul-la da zaj nabague̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Xrana' Dios, ba bsana' xel-la' dxucá'ana szren cuina', ne ba bcuasa' xel-la' dxeque xrlátaje cuina'. Quebe dxulapa napa' lu da zaj naca szren, da ca' quebe naca chia' gulapa' na'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Quebe bi gunnía', ne guzúa' zrize ca tu bi dxe'ene za bexuzrte̱ gúzrebe'. Naca bénne'du xu'a ca tu bi dxe'ene za bexuzrte̱ gúzrebe'. ");
INSERT INTO zatNTps_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","Le cueza lazre' Xránadxu Dios, le'e, benne' Israel na'a zra, ne chadía chacanna. ");
INSERT INTO zatNTps_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Bsa lazre', Xrana' Dios, ca guca chee̱ David, ne ca guzaca zi'e̱, ");
INSERT INTO zatNTps_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","ne ca da guche̱be lazre̱' gune̱' chiu', da guche̱be lazre̱' lau', Dios wal-la chee̱ Jacob. ");
INSERT INTO zatNTps_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","Guné̱': “Québequeze chu'a xu'u lizra', ne québequeze gáta'a ga dxasia' ");
INSERT INTO zatNTps_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","ne québequeze guchúdia' xiaj lawa' ne québequeze gasia' ");
INSERT INTO zatNTps_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","ca zrindxa zra ba be̱na' tu xu'u lizre Xrana' Dios naga súaqueze Dios wal-la chee̱ Jacob.” ");
INSERT INTO zatNTps_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Bénedxu zua xí'ina lá'azxa naga xu'u xel-la' wezría lu xe̱zr la xu Efrata, na' bezréledxu na lu xe̱zr la xu chee̱ bénnea' le̱' Jaar. ");
INSERT INTO zatNTps_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","Gunnantu': Chéajntu' naga zua Dios chee̱ntu'. Guzú zríbentu' zran ni'a Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","Guxasa, Xránantu' Dios, nen xí'ina naga xu'u xel-la' wezría chiu', ne gudá lu xi'a naga súaquezu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Be̱n xelún bxruze chiu' ca' da naca xrlátaje, ne xelebezre xa'a xúgute̱ bénneache chiu', lu dute̱ xel-la' dxelebé chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Lawe' da nazrí'inu' David, we̱n zrin chiu', quebe guzú' chalá'ala wenná bea na' ba guca'u Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Da líqueze bzetaj cuina Xránadxu Dios, guche̱be lazre̱' chee̱ David quebe gucuase̱' ca da gunné̱'. Gunné̱': “Guna' xelenná bea zri'ine zre su' naga dxenná béaquezu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","Che zri'inu' ca' tu xelúnzqueze̱' ca naca xel-la' wezría chia', ne ca naca xrtizra' da gusé̱deda' le̱', zri'inu' ca' tu xelenná béazqueze̱' naga dxenná be'u lue'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Lawe' da gucá'a Xránadxu Dios xe̱zre Sión, guca lazre̱' sua xu'u lízrequeze̱' ga na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","Gunné̱': “Tu gácazqueze lataj nigá naga súaqueza' neda'. Tu súazqueza' nigá lawe' da caní dxezaca ba lazra' guna'. ");
INSERT INTO zatNTps_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Guna' gáta'le̱'e̱ lina chee̱ benne' ca', ne guna' xelelaj benne' xache' ca' xeta. ");
INSERT INTO zatNTps_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Guna' xelún bxruze chia' ca' da naca chawe', na' xelebezre xa'a xúgute̱ bénneache chia' lu dute̱ xel-la' dxelebé chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Lataj na' guna' xexaca xel-la' dxenná bea chee̱ David. Guna' xelezúa na' zri'ine zre sua wenná bea na' ba gucá'a neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Guna' xeleque zréaje benne' guledábague̱' Le̱', na' guna' chepe ban xel-la' dxenná bea chee̱ David na'.” ");
INSERT INTO zatNTps_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Le nna' xque, xrtante̱ naca, ne cháwe'le̱'e̱ naca gate zaj nazraga bénneache chee̱ Dios, zaj naque̱' tuze. ");
INSERT INTO zatNTps_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Naca na ca tu da za da dxuluzúa xíchaje̱', da dxedínnete̱ na dxu'a lawe̱', ca na' dxedínnete̱ na lu luzru Aarón, ne dxedínnete̱ na ga zria zre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Dxedínnete̱ na ca xrle̱'e̱la da dxexruj lu xi'a Hermón, ne dxexruj na lu xi'a Sión lawe' da gun Xránadxu Dios gaca chawe' chee̱ bénneache zaj zre̱'e̱ na', ne gunne̱' benne' ca' xel-la' nabán da zeajlí canna. ");
INSERT INTO zatNTps_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Le na' xque, le güe lá'ana Xránadxu Dios, le'e, nácale we̱n zrin chee̱ Xránadxu, zrale xu'u lizre Xránadxu chizrela. ");
INSERT INTO zatNTps_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Le chisa na'le lau lataj lá'azxa, ne le güe lá'ana Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Dxenaba' lau Xránadxu zue̱' Sión gune̱' gaca chawe' chiu', naque̱' Bénnea' be̱ne̱' xabáa, ne xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","¡Le güe lá'ana La Xránadxu Dios! ¡Le güe lá'ana Le̱', le'e, we̱n zrin chee̱ Xránadxu, ");
INSERT INTO zatNTps_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","le'e zrale xu'u lizre Xránadxu Dios, lu chale'aj chee̱ xu'u naga zúaqueze Dios! ");
INSERT INTO zatNTps_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","¡Le güe lá'ana Xránadxu lawe' da naque̱' xrlátaje! ¡Le gul-la da güe lá'anale La Le̱', lawe' da naque̱' zri'i lazre'! ");
INSERT INTO zatNTps_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Xránadxu Dios ba guqué̱'e̱ zri'ine zre sua Jacob. Guqué̱'e̱ zri'ine zre sua Israel chee̱ xelaque̱' bénneache chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Nézquezdxu szrente̱ naca Xránadxu Dios. Xránadxu naque̱' szrendxa ca xúgute̱ dios chee̱ benne' zitu' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Xúgute̱ da dxaca lazre' Xránadxu gune̱', dxune̱' na zran xabáa, ne lu xe̱zr la xu, ne lu nísadau', ne lu da situj chee̱ nísadau' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Dxune̱' zá'aca beuj dapa saca chee̱ xe̱zr la xu. Dxune̱' dxelepe xesa guziu' gate dxaca xiuj. Dxune̱' dxaca be' gátete̱ze. ");
INSERT INTO zatNTps_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Be̱ne̱' gulate bi biu nedxu chee̱ benne' Egipto ca'. Gulate bi biu nedxu chee̱ bénneache, ne béadu ca' chee̱ be̱ xixre' chee̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","Be̱ne̱' xel-la' waca ca' da za xabáa, ne da zrente̱ ca' da be̱ne̱' lu xe̱zr la xu chee̱ benne' Egipto ca', da ca' be̱n Dios da guca chee̱ Faraón, ne chee̱ xúgute̱ we̱n zrin chee̱ Faraón na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Bzria xi'e̱ bénneache zánete̱ cue' xe̱zr la xu ca', ne be̱tie̱' benne' wenná bea ca', benne' zaj nápale̱'e̱ xel-la' dxelenná bea. ");
INSERT INTO zatNTps_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Be̱tie̱' Sehón, wenná bea chee̱ benne' amorreo ca', ne Og, wenná bea chee̱ benne' Basán ca', ne xúgute̱ benne' wenná bea chee̱ benne' Canaán ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","Bequé̱'e̱ xe̱zr la xu nigá lu na' benne' wenná bea ca', na' bnézruje̱' na lu na' bénneache chee̱', benne' Israel ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Xrana' Dios, chadía chacanna zua lau' Lue'. Tu cheajlesá lázrezqueze bénneache Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","Xránadxu Dios guchi'e̱ chee̱ bénneache chee̱', ne xexache lazre̱' chee̱dxu dxi'u, we̱n zrin chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Bedau' xia xaga ca' chee̱ benne' xe̱zr la xu ca' zaj naca na oro, ne plata. Zaj naca na da belún bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Zaj zua dxu'a na san quebe dxelenné̱ na. Zaj zua lau na san quebe dxelelé'e na. ");
INSERT INTO zatNTps_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","Zaj zua naga na san quebe dxelén na, ne quebe dxelecá'a na be'. ");
INSERT INTO zatNTps_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Benne' ca' dxelune̱' na zaj nácaqueze̱' ca lé̱queze na, ne caní zaj naca xúgute̱ benne' dxuluxrén lazre̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","Le'e, benne' xrtía Israel, le güe lá'ana Xránadxu Dios. Le'e, benne' xrtia Aarón, le güe lá'ana Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","Le'e, benne' xrtia Leví, le güe lá'ana Xránadxu Dios. Le'e, núlale dxezrébele Xránadxu Dios, le güe lá'ana Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Le'e, zrale xe̱zre Sión, le güe lá'ana Xránadxu Dios, Bénnea' zúaqueze̱' xe̱zre Jerusalén. ¡Gaca ba lá'azxa Xránadxu Dios! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","¡Le güe lá'ana Xránadxu Dios, Benne' xrlátaje! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","¡Le güe lá'ana Dios, naque̱' szrénte̱dxa ca zaj naca dios chee̱ xe̱zr la xu ca'! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","¡Le güe lá'ana Xránadxu, naque̱' szrénte̱dxa ca zaj naca xrana xe̱zr la xu ca'! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","¡Le güe lá'ana Dios na', dxune̱' xel-la' waca zri'a ca'! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","¡Le güe lá'ana Dios na', be̱ne̱' xabáa dute̱ xel-la' sina chee̱'! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","¡Le güe lá'ana Dios na', bzue̱' xe̱zr la xu lawe' nísadau'! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","¡Le güe lá'ana Dios na', be̱ne̱' gubizra ne beu'! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","¡Be̱ne̱' gubizra chee̱ gusení na te zra! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","¡Be̱ne̱' beu' ne belaj ca' chee̱ xulusení na chizrela! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","¡Le güe lá'ana Dios na', be̱tie̱' bi biu nedxu chee̱ benne' Egipto ca'! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","¡Le güe lá'ana Dios na', bebéaje̱' benne' Israel ca' lu xe̱zr la xu Egipto na'! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","¡Beche̱'e̱ le̱' dute̱ xel-la' waca zren chee̱'! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","¡Le güe lá'ana Dios na', be̱ne̱' chupa la'a nísadau' da nazí le̱ na Xrna! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","¡Bdee̱' benne' Israel ca' laduj nísadau' na'! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","¡Bgacue̱' nísadau' na' Faraón, benne' wenná bea chee̱ Egipto, ne benne' zeje̱' wedil-la chee̱' ca'! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","¡Le güe lá'ana Dios na', beche̱'e̱ benne' chee̱' ca' le̱'e̱ xixre' lawe' lataj! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","¡Le güe lá'ana Dios na', be̱tie̱' wenná bea blau ca'! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","¡Be̱tie̱' wenná bea wal-la ca'! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","¡Be̱tie̱' Sehón, wenná bea chee̱ benne' amorreo ca'! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","¡Be̱tie̱' Og, wenná bea chee̱ xe̱zr la xu Basán! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","¡Bnézruje̱' xe̱zr la xu chee̱ benne' ca' chee̱ gaca na chee̱ benne' chee̱' ca'! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","¡Be̱nne̱' na chee̱ benne' Israel ca', benne' we̱n zrin chee̱' ca'! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","¡Naque̱' Dios na', quebe gul-la lazre̱' dxi'u gate buluzetja benne' ca' dxi'u! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","¡Le̱' bselé̱' dxi'u lu na' benne' ca' guledíl-lale̱ne̱' dxi'u! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","¡Naque̱' Dios na', dxugawe̱' xúgute̱ da zaj naca ban! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","¡Le güe lá'ana Dios chee̱ xabáa! ¡Chadía chacanna dxexache lazre̱' dxi'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Dxu'a xe̱gu chee̱ xe̱zr la xu Babilonia gudxé'edxu, ne gudxézredxu gate xeajsá lázredxu chee̱ xe̱zre Sión. ");
INSERT INTO zatNTps_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Lu zruze xaga labada' dxu'a xe̱gu na' buqué̱ladxu da cun zríadi'i na du chee̱dxu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","Benne' ca' guleché̱'e̱ dxi'u ca benne' zaj nada'u gulenábene̱' dxi'u gúl-ladxu. Benne' ca' buluzría xi' xe̱zre chee̱dxu gulé̱'e̱ dxi'u súadxu lu xel-la' dxebé, gulenné̱': Le gul-la chee̱ntu' da ca' bíl-lale lu xe̱zre Sión. ");
INSERT INTO zatNTps_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","¿Ájazra gúl-ladxu da güe lá'anadxu Xránadxu Dios naga zúantu' lu xe̱zr la xu chee̱ benne' zitu' ca'? ");
INSERT INTO zatNTps_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","Chela gal-la lazra' lue', xe̱zre Jerusalén, gun Dios gunite na'a xabe̱la xel-la' waca chee̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","Be̱n xedá' luzra' chíchajla' che quebe cheajsá lazra' chiu', ne che quebe gucá'ana szrena' lue', Jerusalén, nacu' da dxezaca ba lázrele̱da'. ");
INSERT INTO zatNTps_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","Xrana' Dios, bsa lazre' da cale̱la da belún benne' Edom lu zra na' guzría xi' xe̱zre Jerusalén, gate na' gulenné̱': “Le guchinnaj na. Le guchinnaj na, ca zrinte̱ lu lane chee̱ na.” ");
INSERT INTO zatNTps_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Le'e, benne' Babilonia, cuía xile. Ba neza zrente̱ gaca na chee̱ bénnea' gune̱' chee̱le ca da be̱nle le'e chee̱ntu' netu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Ba neza zrente̱ gaca na chee̱ bénnea' que̱'e̱ bidu chee̱le ca', ne quine̱'-be' lu xiaj xre na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Xrana' Dios, dute̱ lázrdawa' güe lá'ana' Lue'. Tu dxúl-lazqueza' da dxue lá'ana' Lue' lau dios ca' chee̱ benne' zitu' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Dxuzú zriba' lau xudau' lá'azxa chiu', ne dxue lá'ana' Lau' lawe' da nacu' li lazre', ne dxexache lazru' bénneache chiu', ne lawe' da blé'enu' nacu' Benne' szrente̱, na' szrente̱ naca xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Gate bláwizra' Lue', na' gúcale̱nu' neda'. Nen dute̱ xel-la' waca chiu' btipu' lazra'. ");
INSERT INTO zatNTps_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Xúgute̱ benne' wenná bea du gabí'i xe̱zr la xu xelúe lá'ane̱' Lue', Xrana' Dios. Caní xelune̱' lawe' da ba belenne̱' ca naca xrtizru'. ");
INSERT INTO zatNTps_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Xelúl-le̱' chee̱ da ba nune̱' Xránadxu Dios, lawe' da zrente̱ naca xel-la' ba chee̱ Xránadxu. ");
INSERT INTO zatNTps_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Szrente̱ naca Xránadxu Dios, ne dxácale̱ne̱' benne' baxache' ca', na' quebe dxu'e̱ lataj benne' dxucá'ana szren cuine̱' zrine̱' lau Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Lácala zua' lu da ba xa', Lue' dxutipu' lazra'. Dxedábagu' benne' ca' dxeledábague̱' neda', ne dute̱ xel-la' waca chiu' dxuseláu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Gun Xránadxu Dios da guche̱be lazre̱' chia'. Xrana' Dios, tu dxexache lázrezquezu' bénneache chiu'. Quebe gusanu' dxunu' zrin da guzú lau' dxunu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Xrana' Dios, ba gunná' xánniu' neda' ne núnbea xánniu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Nézqueznu' gate dxe'a, ne gate dxasa'. Zítu'la nézqueznu' da zaj xu'u xichaj lázrdawa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Ba gunná' xánniu' ca dxuna', ne ca dxexezí' lazra'. Nézqueznu' xúgute̱ da dxuna'. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Gate quebe ne guchálaja' ba nézqueznu' Lue', Xran, xúgute̱ da nnia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Gátete̱zla cuita' neda' zúaquezu' Lue', Xran, ne nuzé̱ na'u neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Ca szrente̱ naca da nézenu' Lue' naca na da dxebáneda'. Nácale̱'e̱ na sina da quebe gaca chéajni'ida'. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","¿Gala cha'a zitu' naga quebe zúaqueze Be' chiu'? ¿Gala guzrúnnuja' naga quebe zúaquezu' Lue'? ");
INSERT INTO zatNTps_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Che cuena' sibe zran xabáa, na' zúaquezu' Lue', ne che xétaja' lu da situj chee̱ xe̱zr la xu, na' zu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","La séqueda' tea' lu be', ne cha'a zitu' naga dxalaj gubizra, u tea' xechalá'a nísadau' naga dxebía gubizra, ");
INSERT INTO zatNTps_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","cá'anqueze na' súale̱nu' neda', ne guxru na'u xabe̱la neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Chela gaca guna' gacu da chul-la neda', u guna' xexaca lení' da naxechaj neda', chee̱ xaca na da chul-la, ");
INSERT INTO zatNTps_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","da chul-la na' quebe gaca gucache na neda' lau Lue', na' chizrela xaca na ca te zra lau'. Túzqueze ca zaj naca da chul-la, ne xel-la' naxaní' lau Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Lue' be̱nu' da zaj xu'u lu be̱la' dxen chia'. Lue' bzalju' neda' lu le̱'e̱ xrna'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Güe lá'anaqueza' Lue' lawe' da szrente̱ zaj naca da dxunu', ne dxebáneda' ca zaj naca na. Dute̱ lázrdawa' nézquezda' caní naca na. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Blé'equeznu' neda' gate gulá' gubinna zrita xu'a, gate na' belezraga na lu le̱'e̱ xrna'a, gate na' bgula' lu da bagácheze na'. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Ble'enu' be̱la' dxen chia' gate gulá' gubinna na. Xúgute̱ da caní ba naxúaj na lu xiche chiu', na' ca gudé na' gulá' gubinna na, na' xúgute̱ na gulaca na cáte̱ze zaj naxúaj na. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","Dios, szrente̱ zaj naca da dxuwía lazru' gunu'. Da zante̱ ca zaj naca na. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Chela gaca lazra' gulaba' ca zaj naca na, zaj naca na ca xuzre' dxe' dxu'a tu xe̱gu zren. Gate dxexebana', ne zúale̱queza' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Dios, da líqueze gutiu' benne' ca' dxelune̱' da cale̱la. Chee̱ le̱ na', le gucuasa naga zua', le'e, we̱te benne'. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Chiu' Lue', Dios, dxelenné̱' dizra' schanni'. Benne' ca' dxeledábague̱' lue' dxuluzétaje̱' Lau' lu da xálaze. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","Xrana' Dios, dxecuídeda' benne' ca' dxuluzúe̱' Lue' chalá'ala, ne dxezrá'li'a benne' ca' dxeledábague̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Dute̱ lázrdawa' dxecuídeda' benne' ca'. Dxéqueda' benne' ca' ca benne' ca' dxeledábague̱' nédaqueza'. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Gunná' xanne' neda', Dios, ne gunná' da xu'u na lázrdawa'. Bxue neda' chee̱ nézenu' da xu'u lu xichaj lázrdawa'. ");
INSERT INTO zatNTps_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Gunná' che zúale̱ tu da cale̱la neda', na' bsi neda' lu neza chawe' chiu' da zeajlí canna. ");
INSERT INTO zatNTps_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","Xrana' Dios, bselá neda' lu na' benne' ca' dxelune̱' da cale̱la. Bxue neda' chee̱ quebe bi xelún benne' xichaj zra'a ca' chia' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","Benne' caní dxuluwía lazre̱' da cale̱la ca' da xelune̱'. Tu zra tu zra dxulutíl-lale̱ne̱' bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Da dxelenné̱' naca na ca lazxa be̱la' da zaj nalále̱'e̱. Xrtizra' benne' ca' zaj naca na ca nisa snia chee̱ be̱la'. ");
INSERT INTO zatNTps_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","Xrana' Dios, bxue neda' chee̱ quebe bi xelún benne' ca' dxelune̱' da cale̱la chia' neda'. Bselá neda' lu na' benne' xichaj zra'a ca', benne' ca' dxelune̱' ba xuzre cheajcházia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Benne' ca' dxulucá'ana szren cuine̱' zaj nabeque̱' tu da que̱l-la na neda'. Ba zaj nuzale̱' xralaj dxu'a neza. Ba zaj nabeque̱' da ca' xele̱l-la na neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","Gucha' Xrana' Dios: Lue' nacu' Dios chia'. Xrana' Dios, bene chi'a dxuláwizra' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","Xrana' Dios, nacu' weselá chia'. Lue' bcu'uju' xíchaja' lu zra guca wedil-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","Xran, quebe gu'u lataj gaca ca da dxelezá lazre' benne' ca' dxelune̱' da cale̱la. Quebe gu'u lataj chepe ban da dxuluwía lazre̱' xelune̱', chee̱ quebe xulucá'ana szren cuine̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Zaj naxechaj benne' ca' dxelune̱' da cale̱la neda'. Be̱n gaca chee̱ benne' ca' ca de' da dxelaca lazre̱' gaca chee̱ benne' xula. ");
INSERT INTO zatNTps_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Be̱n xexruj xi' lawe' benne' ca'. Bzra benne' ca' lu xi'. Bzra benne' ca' lu da sítujle̱'e̱ naga cabátadxa xelexedxúaje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Quebe gu'u lataj xegá'ana lu xe̱zr la xu bénnea' dxenné̱' da cale̱la. Be̱n gaca da cale̱la chee̱ benne' xichaj zra'a, da guzría xi na le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Nezda' xeche̱be Xránadxu Dios waláz chee̱ benne' baxache', ne guzé̱ chache̱' da zaj xu'u lu na' benne' xache' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Da líqueze benne' xrlátaje ca' xelúe lá'ane̱' Lau' Lue', na' benne' li lazre' ca' xelezúe̱' naga zu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","Xrana' Dios, dxuláwizra' Lue'. Gudázega gácale̱nu' neda'. Bene chi'a gate nnia' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Be̱n la' da dxenaba' lau Lue' ca zren xala. Ble'e na'a da dxechisa' lau' ca tu béadau' dxútia'-ba' lau'. ");
INSERT INTO zatNTps_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Xrana' Dios, bxue dxu'a nigá, ne bxue xide dxu'a chee̱ quebe nnia' tu da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Quebe gu'u lataj gaca lazra' guna' tu da cale̱la, ne chee̱ quebe guna' tu da cale̱la tu zren nen benne' ca' dxelune̱' da zrinnaj, ne chee̱ quebe gágule̱na' benne' ca' dxelune̱' da cale̱la lu laní chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Che gudé benne' xrlátaje neda' lu da ba xa', gaca na chia' tu da chawe', na' che til-le̱' neda', gaca na chia' ca tu da dxelále̱'e̱ zixre da dxegu'e̱ xíchaja'. Tu nábazqueza' Dios guzague̱' da cale̱la da dxelún benne' ca' dxelune̱' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","Gate xeledxú'une̱' benne' xíchaje̱ ca' chee̱ benne' we̱n da cale̱la ca' zran xi'a xiaj ca', na' xeleque be'e bénneache naca li ca da gunnía'. ");
INSERT INTO zatNTps_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Xelase dinnaj zrita chee̱ benne' ca' dxu'a xe̱dxu ba chee̱' ca'. Xelaca na ca bchecu xu, da dxelase dinnaj na naga dxa'ana be̱zre. ");
INSERT INTO zatNTps_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Chee̱ le̱ na' dxenná'a naga zu' Lue', Xrana' Dios. Dxuxrén lazra' Lue', quebe gusán lazru' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Bxue neda' chee̱ quebe xele̱l-la xralaj ca' chee̱ benne' ca' dxelune̱' da cale̱la neda', ne chee̱ quebe cheajcházia' lu da zaj nabeque' benne' we̱n da cale̱la ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Be̱n cheajlechaze benne' ca' dxelune̱' da cale̱la lu xralaj da zaj nabéchequeze̱' dxácate̱ na' tea' neda' ga na' zri'a chawe'. ");
INSERT INTO zatNTps_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Zizraj dxuláwizra' Xránadxu Dios. Du lazra' dxenaba' Xránadxu xexache lazre̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","Lau Le̱' dxawa' zría ca da dxaca chia'. Lau Le̱' dxulé'eda' ca da ste̱be zua' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Gate zua lázrdawa' lu da ste̱be, Lue', Xran, nézenu' da dxaca chia'. La neza naga dxedá' gulebeque̱' xralaj da que̱l-la na neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Dxenná'a cuita' xabe̱la, san quebe nu chilá' gácale̱ neda'. Quebe nu chilá', benne' guxúequeze̱' neda'. Quebe nu chilá', benne' dxe' gunna xue̱' chia' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Dxuláwizra' Lue', Xrana' Dios, dxennia': Dxebeza lazra' tuzu' Lue'. Tuzu' Lue' dxezá lazra' lu xe̱zr la xu nigá. ");
INSERT INTO zatNTps_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Bene da dxuláwizra' Lue', lawe' da dxezaca zí'le̱'a. Bselá neda' lu na' benne' ca' dxeláu zi' xuzre̱' neda', lawe' da zaj naque̱' wál-ladxa ca neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Bebéaj neda' lu da dxaca chia', chee̱ gaca güe lá'ana' Lue'. Benne' xrlátaje ca' xeléchaje̱' neda' lawe' da gunu' gaca chawe' chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Xrana' Dios, bene da dxuchálaja' lau Lue'. Bze̱ naga da dxenaba' lau'. Gudá gácale̱nu' neda' lawe' da nacu' li lazre', ne xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Quebe guchi'u chia' neda', we̱n zrin chiu', ca naca da nabaga', lawe' da lau' Lue' quebe nu chilá' benne' naque̱' du lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Gúcale̱ neda' lawe' da dxeláu zi' xuzre' neda'. Xeláteze bache xelútie̱' neda'. Ba belune̱' naca' ca tu benne' dxedé' lu da chul-la ca naca chee̱ benne' gate ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Zua lázrdawa' lu da sté̱bele̱'e̱, ne dxewí'ine lázrele̱'a. ");
INSERT INTO zatNTps_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Dxeajsá lazra' ca guca nédxudaute̱. Dxulaba lazra' ca naca xúgute̱ da be̱nu'. Dxeajsá lazra' ca naca da zrente̱ ca' da be̱nu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Dxechisa na'a lau Lue'. Naca' ca tu xe̱zr la xu bizre, dxebíleda' Lué'queze. ");
INSERT INTO zatNTps_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Gudázega gácale̱nu' neda', Xran, lawe' da dxedú lazra'. Quebe chenu' gácale̱nu' neda', chee̱ quebe gaca' ca tu benne' ba xu'e̱ xe̱dxu ba. ");
INSERT INTO zatNTps_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Che zílala be̱n cheajsá lazra' dxexache lazru' bénneache chiu' ca' lawe' da dxuxrén lázrequeza' Lue'. Bzéajni'i neda' ca dxal-la' guna' lawe' da dxezá lazra' guna' da dxaca lazru' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Xrana' Dios, bselá neda' lu na' benne' ca' dxeledábague̱' neda' lawe' da dxuzúa cuina' lu na'u chee̱ guxúequezu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Bse̱de neda' chee̱ guna' da dxaca lazru' Lue', lawe' da nacu' Lue' Dios chia'. Gusel-la Be' xrlátaje chiu' chee̱ che̱'e̱ neda' la neza chawe' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Chee̱ gaca bea na nacu' xrlátaje, Xran, gutipu' lazra'. Lawe' da nacu' xrlátaje, guseláu' neda' lu da dxaca chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Lawe' da nacu' li lazre', guzría xi'u benne' ca' dxeledábague̱' neda', ne guzría xi'u xúgute̱ benne' ca' dxelaca lazre̱' xuluzría xi'e̱ neda', lawe' da naca' neda' we̱n zrin chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","¡Gaca ba lá'azxa Xránadxu Dios, Bénnea' dxuzé̱ chache̱' neda'! Naque̱' Bénnea' dxuzázraje̱' na'a chee̱ cha'a lu wedil-la, ne dxuzázraje̱' zrube na'a chee̱ séqueda' tíl-lale̱na' benne' ca' dxelune̱' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Naque̱' Benne' dxexache lazre̱' neda', ne naque̱' ca tu xu'u naga ze̱ chawa'. Dxuzúa chache̱' neda', ne dxuselé̱' neda'. Dxucu'uje̱' neda', na' dxuxrén lazra' Le̱'. Dxune̱' dxuluzúa bénneache chia' dizra' chia'. ");
INSERT INTO zatNTps_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","Xrana' Dios, ¿ájazra naca nu benne', dxeajsá lazru' le̱'? ¿Ájazra naca nu benne' dxe'u gunne xue chee̱'? ");
INSERT INTO zatNTps_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Naca benne' ca tu da níteze. Zaj naca zra chee̱' ca tu zrul-la da dxedeze. ");
INSERT INTO zatNTps_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","Xrana' Dios, gusalaj zran xabáa, ne betaj gácale̱nu' neda'. Bta xi'a ca', na' dxuaj zren chee̱ xi'. ");
INSERT INTO zatNTps_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Bzalaj xesa guziu', ne blaga benne' ca' dxelune̱' da cale̱la. Bzalaj xaga nalá xéche'ze chiu', ne bzria xi' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Naga zu' na'la, bze̱ na'u, ne bselá neda' lu da sté̱bele̱'e̱ zua'. Bselá neda' lu na' benne' zitu' ca', ");
INSERT INTO zatNTps_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","benne' ca' tu dxelenné̱zqueze̱' da we̱n lazre', ne dxuluzétaje̱' Dios gate dxelezí xe̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","Dios, gúl-laqueza' chiu' da cube, quínnia' da dxúl-lale̱na'. Nen tu da dxínnia' da nua chi du chee̱ na gúl-laqueza' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","Nacu' Lue' Bénnea' dxune̱' dxeledxúaj chawe' benne' wenná bea ca'. Dxuseláu' David, we̱n zrin chiu', lu xia nalá chee̱ benne' we̱n da cale̱la ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Bexa'u neda', ne bselá neda' lu na' benne' zitu' ca', benne' ca' tu dxelenné̱zqueze̱' da we̱n lazre', na' dxuluzétaje̱' Dios gate dxelezí xe̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Be̱n xelegula bi biu chee̱ntu' ca tu xaga da dxegula chawe', ne zaj nácabe' bi cuide'. Be̱n xelaca bi nu'ula chee̱ntu' ca bdu'a xiaj xrtante̱ ca' da zaj nnita tu lu xu'u zren. ");
INSERT INTO zatNTps_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Be̱n chate̱ lízrentu' xúgute̱ cuen lina chee̱ntu'. Be̱n xelánle̱'e̱ be̱ xixre' chee̱ntu', chee̱ xelácaba' gaxúa gaxúane be̱ xíxre'du ca' lu xe̱zr la xu chee̱ntu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","Be̱n xelaca be̱zre chee̱ntu' be̱ wal-la chee̱ xelunba' zrin. Be̱n quebe xelezanba' gate quebe ne zrin cha beu' chee̱ba' ca'. Be̱n quebe nu cha' cuezre xache' la neza chee̱ntu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Ba neza zrente̱ naca na chee̱ bénneache ca' dxaca caní chee̱'. Ba neza zrente̱ naca na chee̱ bénneache ca' naca Xránadxu Dios chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","¡Gucá'ana szrena' Lue', Dios chia', ne Wenná Bea chia'! ¡Tu güe lá'anazqueza' Lau' Lue' chadía chacanna! ");
INSERT INTO zatNTps_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","¡Tu zra tu zra güe lá'ana' Lue'! ¡Tu güe lá'anazqueza' Lau' Lue' chadía chacanna! ");
INSERT INTO zatNTps_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","¡Szrente̱ naca Xránadxu Dios, ne naca chee̱' tu güe lá'anazquezdxu Le̱'! ¡Québequeze séquedxu gúnbeadxu ca szrente̱ naque̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Xúgute̱ cuen bénneache chiu' xelúe lá'ane̱' da be̱nu' Lue', ne xuluzenne̱' benne' xe̱zr la xu ca' ca naca da zrente̱ da be̱nu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Gulaba lazra' ca naca da xrtante̱ chee̱ da xabáa chee̱ xel-la' szren chiu', ne ca naca da zrente̱ da nunu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Xúgute̱ bénneache xuluchálaje̱' ca naca xel-la' waca chee̱ da zrente̱ da nunu', na' neda' guzenda' le̱' ca naca xel-la' szren chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Xuluzenne̱' le sa' ljwezre̱' ca naca xel-la' zri'i lazre' zren chiu', ne tu xelúl-lazqueze̱' chee̱ da xrlátaje da nacu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Xránadxu Dios naque̱' zri'i lazre', ne dxexache lazre̱' bénneache chee̱'. Dxezrene̱', ne quebe dxezrá'aze̱', na' dxexache lázrele̱'e̱ dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Dxun Xránadxu Dios da chawe' chee̱ xúgute̱ bénneache, ne dxexache lazre̱' xúgute̱ da zaj naca ban da nune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Xúgute̱ da ca' nunu' xelúe lá'ana na Lue', Xran, na' bénneache chiu' xulucá'ana szrene̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Dxelenné̱' ca szrente̱ naca xel-la' dxenná bea chiu'. Dxuluchálaje̱' ca naca xel-la' waca zrente̱ chiu', ");
INSERT INTO zatNTps_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","chee̱ xuluzenne̱' xúgute̱ bénneache ca naca da zrente̱ ca' da nunu', ne ca naca da xabáa chee̱ xel-la' szren chee̱ xel-la' dxenná bea chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Xel-la' dxenná bea chiu' tu súazqueze na, ne nna be'enu' xúgute̱ cuen bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Nuxru Xránadxu Dios xúgute̱ benne' ca' dxeajlecházie̱', ne dxechise̱' xúgute̱ benne' ca' zaj nada'u lu zrin wal-la. ");
INSERT INTO zatNTps_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Xúgute̱ bénneache dxelenné̱'e̱ Lue' chee̱ gácale̱nu' le̱', na' Lue' gunézruju' da xelawe̱' ca zrin zra chee̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Dxuzé̱ na'u, ne dxunézruju' ca naca da chawe' da dxelexázrje xúgute̱ da zaj naca ban. ");
INSERT INTO zatNTps_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Xlátaje̱ naca Xránadxu Dios lu xúgute̱ da dxune̱', ne dxexache lazre̱' xúgute̱ da zaj naca ban da nun Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Xránadxu Dios zúate̱queze̱' gácale̱ne̱' xúgute̱ benne' ca' dxululáwizre̱' Le̱', xúgute̱ benne' ca' du lazre̱' dxululáwizre̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Gune̱' ca dxelezá lazre' benne' ca' dxelezrebe̱' Le̱'. Cá'anqueze xenne̱' chee̱' gate xululáwizre̱' Le̱', ne guselé̱' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Xránadxu Dios dxuxúequeze̱' xúgute̱ benne' ca' zaj nazrí'ine̱' Le̱', san guzría xi'e̱ xúgute̱ benne' ca' dxelebéaj xíchaje̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Du lazra' güe lá'ana' Xránadxu Dios. Xúgute̱ benne' dxal-la' tu xelúe lá'anazqueze̱' Le̱' lá'azxa chadía chacanna. ");
INSERT INTO zatNTps_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","¡Gaca ba lá'azxa Xránadxu Dios! ¡Du lazra' güe lá'ana' Xránadxu Dios! ");
INSERT INTO zatNTps_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","¡Dxácate̱ naca bana' güe lá'ana' Xránadxu Dios! ¡Tu gúl-lazqueza' da güe lá'ana' Xránadxu Dios dxácate̱ naca bana'! ");
INSERT INTO zatNTps_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Quebe guxrén lázrele benne' dxelenná bea, ne quegá bénneache lawe' da quebe xelezéquene̱' xuluselé̱' le'e. ");
INSERT INTO zatNTps_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Dxeledxúaj be' zaj xu'e̱, na' xelexexaque̱' xu xrte. Lu zra ná'queze xelenite da dxuluwía lazre̱' xelune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Ba neza zrente̱ naca na chee̱ bénnea', dxácale̱ Dios chee̱ Jacob le̱', bénnea' dxebeza lazre̱' Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Dios na' be̱ne̱' xabáa, ne xe̱zr la xu, ne nísadau', ne xúgute̱ da zaj zra' lataj ca'. Naque̱' Bénnea' tu dxúnzqueze̱' da li lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Dxuchi'e̱ chee̱ benne' baxache' ca', ne dxugawe̱' benne' ca' dxeledune̱'. Xránadxu Dios dxuselé̱' benne' ca' zaj nada'u lu na' benne̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","Xránadxu Dios dxexune̱' xiaj lau benne' la chul-la ca'. Xránadxu Dios dxechise̱' benne' ca' dxeajlecházie̱'. Xránadxu Dios nazrí'ine̱' benne' xrlátaje ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Xránadxu Dios dxuxúe̱' benne' zitu' ca'. Nuxre̱' bidau' we̱ze̱be ca', ne nu'ula tuze ca', na' dxuchínnaje̱' da dxelún benne' ca' dxelune̱' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Tu nna béazqueze Xránadxu Dios. Le'e, benne' xe̱zre Sión, nna be'e Dios chee̱le ne xúgute̱ cuen zri'ine zre súale. ¡Gaca ba lá'azxa Xránadxu Dios! ");
INSERT INTO zatNTps_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","¡Le güe lá'ana Xránadxu Dios lawe' da naca chawe' gúl-ladxu da güe lá'anadxu Dios chee̱dxu, lawe' da xrtante̱ naca güe lá'anadxu Le̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Xránadxu Dios xexune̱' xe̱zre Jerusalén. Xequé̱'e̱ benne' Israel ca' zaj zue̱' xe̱zr la xu zitu' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Dxexune̱' benne' ca' dxelexewí'ine lázrele̱'e̱, ne dxudé̱'e̱ ladxe' naga zaj naca we̱' chee̱ benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","¡Nézquezne̱' ca zaj naxán belaj ca'! ¡Tu tu belaj ca' dxu'e̱ la na! ");
INSERT INTO zatNTps_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","¡Szrente̱ naca Xránadxu Dios, ne nape̱' dute̱ xel-la' waca! ¡Quebe bi de̱ da quebe dxéajni'ine̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Xránadxu Dios dxácale̱ne̱' benne' dxexruj lazre' ca', na' dxuzéxruje̱' benne' ca' dxelune̱' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","¡Le gul-la da güe lá'anale Xránadxu Dios! ¡Le gul-la, ne le quinne da cun zríadi'i na du lau Dios chee̱dxu! ");
INSERT INTO zatNTps_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","¡Le̱' dxudé̱'e̱ beuj ca' zran xabáa! ¡Le̱' dxesel-le̱' nisa xiuj lu xe̱zr la xu! ¡Le̱' dxune̱' dxelezría xíxre'du ca' lu xi'a ca'! ");
INSERT INTO zatNTps_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","¡Le̱' dxunézruje̱' da dxelagu be̱ xixre' ca'! ¡Dxunézruje̱' da dxelagu béchajdu ca', be̱ dxelebezre xa'aba'! ");
INSERT INTO zatNTps_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Da dxezaca ba lázrele̱ne̱' quebe naca na xel-la' wal-la chee̱ bzrina' ca', ne quegá xel-la' wal-la chee̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","Dxezaca ba lázrele̱ne̱' benne' ca' dxelezrebe̱' Le̱', ne benne' ca' dxelebeza lazre̱' Le̱' chee̱ xexache lazre̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","¡Le güe lá'ana Xránadxu Dios, le'e zrale xe̱zre Jerusalén! ¡Le güe lá'ana Dios chee̱le, le'e zrale xe̱zre Sión! ");
INSERT INTO zatNTps_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","¡Le̱' dxuzúa chúchue̱' dxa xu'u chee̱ xe̱zre chee̱le! ¡Dxune̱' dxaca chawe' chee̱ benne' ca' zaj zre̱'e̱ xe̱zre chee̱le! ");
INSERT INTO zatNTps_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","¡Dxebeque̱' xel-la' dxebeza zri lazre' lu xe̱zr la xu chee̱le! ¡Gúnnale̱'e̱ chee̱le zrua' chawe'! ");
INSERT INTO zatNTps_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","¡Dxusel-le̱' xrtizre̱' chee̱ benne' ca' zaj zre̱'e̱ dute̱ xe̱zr la xu, na' chadí dxaca ca da dxenné̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","¡Dxugacue̱' xe̱zr la xu bezxe' da naca na ca zrila'! ¡Dxuzéxruje̱' xrle̱'e̱la dxe̱la ca de! ");
INSERT INTO zatNTps_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","¡Dxune̱' dxelexruj xiaj bezxe' ca weaj xíajdu ca'! ¿Nu benne' gaca guchaga lawe̱' da zaga chee̱ na? ");
INSERT INTO zatNTps_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","¡Dxenná be'e̱, na' dxexuna na! ¡Dxune̱' dxaca be', na' dxexaca bezxe' na' nisa guba'u! ");
INSERT INTO zatNTps_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","¡Bzéajni'ine̱' Jacob ca naca xrtizre̱', ne bdee̱' xrba chee̱', ne da ca' gunná be'e̱ lu na' benne' Israel ca'! ");
INSERT INTO zatNTps_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Quebe ne gune̱' caní chee̱ xe̱zr la xu xezícadxa ca', na' benne' xe̱zr la xu ca' quebe dxelexúnbe'e̱ xrba chee̱'. ¡Gaca ba lá'azxa Xránadxu Dios! ");
INSERT INTO zatNTps_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","¡Le güe lá'ana Xránadxu Dios! ¡Le güe lá'ana Xránadxu, le'e, zrale xabáa! ¡Le güe lá'ana Le̱', le'e, zrale dxala! ");
INSERT INTO zatNTps_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","¡Le güe lá'ana Le̱', le'e, gubáz chee̱ xabáa chee̱' ca'! ¡Le güe lá'ana Le̱', le'e, benne' zante̱ chee̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","¡Le güe lá'ana Le̱', le'e, gubizra, ne beu'! ¡Le güe lá'ana Le̱', le'e, belaj dxusenile! ");
INSERT INTO zatNTps_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","¡Le güe lá'ana Le̱', le'e, xabáa ca', ne le'e, nisa zrale láwela xabáa! ");
INSERT INTO zatNTps_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","¡Le güe lá'ana La Xránadxu, lawe' da gunná bé'ene̱', na' guzúale! ");
INSERT INTO zatNTps_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","¡Be̱ne̱' súale tu chi'ize, ne chadía chacanna! ¡Bzue̱' chee̱le tu da bdxixruj be'e̱ da quebe te chee̱ na! ");
INSERT INTO zatNTps_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","¡Le güe lá'ana Xránadxu lu xe̱zr la xu, le'e, bea zri'a zrale lu nísadau', ne xúgute̱ nisa situj, ");
INSERT INTO zatNTps_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","ne le'e, xesa guziu', ne xiaj xiuj, ne bezxe', ne beuj ca', ne le'e, be' bdunu' ca', dxunle ca gunná be'e̱! ");
INSERT INTO zatNTps_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","¡Le güe lá'ana Le̱', le'e, xí'adu ca', ne xi'a zri'a ca', ne le'e, xaga zixre ca', ne xaga cedro ca', ");
INSERT INTO zatNTps_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","ne le'e, be̱ xixre' ca', ne bea ca' dxuluxúe bénneache, ne le'e, be̱ snia ca', ne be̱ zaj zua xrila! ");
INSERT INTO zatNTps_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","¡Le güe lá'ana Le̱', le'e, benne' wenná bea ca', ne xúgute̱ bénneache, ne le'e, benne' dxelenná be'e̱, ne benne' dxuluchi'e̱, ");
INSERT INTO zatNTps_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","ne le'e, benne' wegu' ca', ne nú'uladu ca', ne le'e, benne' gula ca', ne bidu ca'! ");
INSERT INTO zatNTps_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","¡Le güe lá'ana La Xránadxu! ¡Szrénte̱dxa naca La Le̱' ca xúgute̱ la bénneache! ¡Da xabáa chee̱' dxulé'e lau na lu xe̱zr la xu, ne xabáa! ");
INSERT INTO zatNTps_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","¡Le̱' nune̱' xe̱zr chee̱' xe̱zre wal-la! ¡Le güe lá'ana Le̱', le'e, bénneache chee̱', nácale zri'ine zre sua Israel! ¡Nácale benne' nazrí'i Le̱'! ¡Le güe lá'ana Xránadxu! ");
INSERT INTO zatNTps_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","¡Le güe lá'ana Xránadxu Dios! ¡Le gul-la chee̱ Xránadxu tu da cube! ¡Le güe lá'ana Le̱' naga zaj nazraga bénneache chee̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","¡Le be, le'e, benne' Israel, lau Bénnea' be̱ne̱' le'e! ¡Le sua xel-la' dxebé, le'e, zrale Sion, lau Bénnea' naque̱' Wenná Bea chee̱le! ");
INSERT INTO zatNTps_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","¡Le güe lá'ana La Xránadxu, ne guxa'ale! ¡Le guchunchu xide ca', ne le quinne da cun zríadi'i na du ca', dxue lá'anale Le̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","¡Xránadxu Dios dxezaca ba lázrele̱ne̱' bénneache chee̱'! ¡Dxape̱' ba lá'ana benne' dxexruj lazre' ca', ne dxuselé̱' le̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Dxal-la' xelebéqueze bénneache chee̱' lu da xabáa chee̱', ne xelúl-le̱' dute̱ xel-la' dxelebé du xe̱la. ");
INSERT INTO zatNTps_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Dxal-la' xelebezre xe̱'e̱, xelúe lá'ane̱' Dios, zaj nu'e̱ xia da zaj nalá dxupa la'ate̱, ");
INSERT INTO zatNTps_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","chee̱ xelexebéaj lazre̱' benne' xe̱zr la xu ca', ne xuludée̱' xel-la' zi' benne' xe̱zre ca', ");
INSERT INTO zatNTps_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","ne xuluchéaje̱' benne' wenná bea chee̱' ca' du xia, ne benne' dxelenná be'e̱ nen du xia, ");
INSERT INTO zatNTps_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","ne xuluzría xi'e̱ benne' ca' ca ba nun Dios gaca chee̱'. Da nigá gaca na da xabáa chee̱ bénneache chee̱ Dios. ¡Le güe lá'ana Xránadxu! ");
INSERT INTO zatNTps_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","¡Le güe lá'ana Xránadxu Dios! ¡Le güe lá'ana Xránadxu lu xudau' chee̱'! ¡Le güe lá'ana xel-la' waca chee̱' lu xabáa chee̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","¡Le güe lá'ana Le̱' ca zaj naca da zren da nune̱'! ¡Le güe lá'ana Le̱' ca naca xel-la' szren chee̱'! ");
INSERT INTO zatNTps_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","¡Le güe lá'ana Le̱', gucuézrele luzu ca' da dxulucuezre̱'! ¡Le güe lá'ana Le̱', quínnele da cun zríadi'i na du, ne da ca' dxínnele! ");
INSERT INTO zatNTps_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","¡Le güe lá'ana Le̱', guchúnchule xide, ne guxa'ale! ¡Le güe lá'ana Le̱', quínnele da cun zríadi'i na du, ne gucuézrele bchiuj! ");
INSERT INTO zatNTps_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","¡Le güe lá'ana Le̱', gutíl-lale xíadu ca'! ¡Le güe lá'ana Le̱', gutíl-lale xia zren ca'! ");
INSERT INTO zatNTps_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","¡Le güe lá'ana Xránadxu, xúgute̱le naca banle! ¡Le güe lá'ana Xránadxu Dios!");
INSERT INTO zatNTps_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Da caní zaj naca na la chee̱ benne' zaj naque̱' xra wdé chee̱ Jesucristo. Jesús nigá nababe̱' zri'ine zre sua David, ne zri'ine zre sua Abraham. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham nigá guque̱' xra Isaac. Isaac nigá guque̱' xra Jacob. Jacob nigá guque̱' xra Judá, ne benne' biche̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá nigá guque̱' xra Fares, ne Zara, na' Tamar guque̱' xrna Fares, ne Zara caní. Fares nigá guque̱' xra Esrom. Esrom nigá guque̱' xra Aram. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram nigá guque̱' xra Aminadab. Aminadab nigá guque̱' xra Naasón. Naasón nigá guque̱' xra Salmón. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón nigá guque̱' xra Booz, na' Rahab guque̱' xrna Booz nigá. Booz nigá guque̱' xra Obed, na' Rut guque̱' xrna Obed nigá. Obed nigá guque̱' xra Isaí. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí nigá guque̱' xra David, benne' wenná bea. Wenná bea David nigá, ne nu'ula na' nédxute̱ guque̱' zru'ula Urías gulaque̱' xra xrna Salomón. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón nigá guque̱' xra Roboam. Roboam nigá guque̱' xra Abías. Abías nigá guque̱' xra Asa. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa nigá guque̱' xra Josafat. Josafat nigá guque̱' xra Joram. Joram nigá guque̱' xra Uzías. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías nigá guque̱' xra Jotam. Jotam nigá guque̱' xra Acaz. Acaz nigá guque̱' xra Ezequías. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías nigá guque̱' xra Manasés. Manasés nigá guque̱' xra Amón Amón nigá guque̱' xra Josías. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías nigá guque̱' xra Jeconías ne benne' biche̱' ca' ca lu zra ca' gate benne' Babilonia guleché̱'e̱ benne' Israel ca' lu xe̱zr la xu Babilonia. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jeconías nigá guque̱' xra Salatiel. Salatiel nigá guque̱' xra Zorobabel. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel nigá guque̱' xra Abiud. Abiud nigá guque̱' xra Eliaquim. Eliaquim nigá guque̱' xra Azor. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor nigá guque̱' xra Sadoc. Sadoc nigá guque̱' xra Aquim. Aquim nigá guque̱' xra Eliud. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud nigá guque̱' xra Eleazar. Eleazar nigá guque̱' xra Matán. Matán nigá guque̱' xra xetú benne' le̱' Jacob. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob nigá guque̱' xra José, benne' chee̱ María, xrna Jesús, Bénnea' naque̱' Cristo. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Caní naca, gulaca chidá' cue' bénneache gate guzú lau zua Abraham, ca bzrinte̱ zra zua David, na' gulaca xechidá' cue' bénneache ca' gate guzú lau zua David, ca bzrinte̱ zra gate na' benne' Babilonia ca' guleché̱'e̱ benne' Israel ca' lu xe̱zr la xu chee̱', na' gulaca xechidá' cue' bénneache ca' gate guzú lau zra na', ca bzrinte̱ zra gulaj Cristo. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Caní guca gate na' gulaj Jesucristo. María, xrna Jesús ba naché̱bebe' gácabe' zru'ula José. Nédxula ca za xelenite̱', nu'ula nigá ba zue̱' zi'i ne̱ chee̱ xel-la' waca chee̱ Be' Lá'azxa chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José, benne' chee̱ María nigá, naque̱' benne' xrlátaje. Quebe guca lazre̱' gulé'ene̱' ca ba naca chee̱ María lau benne' xe̱zre ca'. Guca lazre̱' gusane̱' le̱' bagácheze. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Dxácate̱ dxudé lazre̱' da nigá, ble'e lau tu gubáz chee̱ xabáa, gubáz chee̱ Xránadxu, ga zua José na' lu bchigala, na' guzre̱' le̱': ―José, zri'ine zre sua David, quebe zrebu' si' lu na'u María chee̱ gácabe' zru'ulu', lawe' da bidu biu na' sanbe' zabe' ne̱ chee̱ Be' Lá'azxa chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Zrú'ulu' gúxrube' tu bidu biu chee̱be', na' lue' gu'u labe' Jesús. Caní gu'u labe' lawe' da guselabe' bénneache lu dul-la da zaj nabague̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Xúgute̱ da caní gulaca ca' chee̱ guca ca da gunná Xránadxu lu dxu'a benne' ca' buluchálaje̱' waláz chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Caní gunné̱': Tu nú'uladau' gúadaube' sanbe' tu bidu biu chee̱be', na' xelu'e̱ labe' Emanuel. Emanuel zéaje̱ na: Dios zúale̱ne̱' dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ca bebán José, na' be̱ne̱' cáte̱ze gunná gubáz chee̱ Xránadxu, na' guzí' lu ne̱'e̱ María chee̱ gácabe' zru'ule̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Quebe gulaque̱' tuze ca gusandxa María bidu biu nedxu chee̱be', na' buluzúe̱' labe' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bidau' Jesús gúlajbe' lu xe̱zre Belén da nababa xe̱zr la xu Judea gate dxenná bea benne' le̱' Herodes ga na'. Nadxa belezrín benne' ca' lu xe̱zre Jerusalén, benne' zá'aque̱' chalá'a naga dxalaj gubizra, zaj naque̱' benne' sina gula. ");
INSERT INTO zatNTps_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Na' gulenabe̱': ―¿Ga zua bidu na' ba gúlajbe' chee̱ gácabe' benne' nna bé'ene̱' benne' judío ca'? Gate zuantu' chalá'a naga dxalaj gubizra blé'entu' belaj chee̱be', na' bla'ntu' nigá chee̱ gúe lá'ana gúe szrentu'-be'. ");
INSERT INTO zatNTps_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ca guneze Herodes, benne' wenná bea, da nigá, na' guzúe̱' ste̱be, ne cá'anqueze guca chee̱ xúgute̱ benne' zaj zre̱'e̱ Jerusalén. ");
INSERT INTO zatNTps_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nadxa Herodes, wenná bea na', btupe̱' xúgute̱ benne' xíchaje̱ chee̱ bxruze ca', ne benne' dxuluxuzájle̱'e̱ da nadxixruj bea Dios, na' gunábene̱' benne' ca': ―¿Gazra na' galaj Cristo? ");
INSERT INTO zatNTps_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Benne' caní gulé̱'e̱ le̱': ―Lu xe̱zre Belén da nababa xe̱zr la xu Judea, lawe' da bzuaj caní tu benne' bchálaje̱' waláz chee̱ Dios, gate na' gunné̱': ");
INSERT INTO zatNTps_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Lue', Belén chee̱ xe̱zre ca' zaj nababa na Judá, nacu' lue' xe̱zre da quebe naca na da bzé̱bedxa ládujla benne' ca' dxelenná be'ene̱' xe̱zr la xu Judá nigá, lawe' da ládujla bénneache chiu' dxuaj tu benne' nna be'e̱, na' guxúequeze̱' bénneache chia', benne' Israel. ");
INSERT INTO zatNTps_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nadxa Herodes, wenná bea na', bláwizre̱' bagácheze benne' sina gula ca', na' gunábene̱' le̱' bátala ble'e lau belaj na' belelé'ene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nadxa gusel-le̱' benne' ca' chjaque̱' xe̱zre Belén, ne guzre̱' le̱': ―Le chjaca na', ne le naba xanne' chee̱ bidu na', na' ca cheajxrácale-be', na' le guzén neda' chee̱ cha'a neda' gúe lá'ana gúe szrena'-be'. ");
INSERT INTO zatNTps_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ca bexuzre belén benne' sina gula ca da gunná Herodes, wenná bea, nadxa besiá'que̱', na' belaj da belelé'ene̱' gate zaj zre̱'e̱ chalá'a naga dxalaj gubizra zeaj na lau le̱', na' bzrinte̱ na, ne guzúa na naga zua bidu na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Gate benne' sina gula ca' belelé'ene̱' belaj na', nadxa gulebéle̱'e̱ne̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ca gulu'e̱ lu xu'u, belelé'ene̱' bidu na', ne xrnabe' María. Nadxa buluzú zribe̱' dxelúe lá'ana dxelúe szrene̱' bidu na'. Nadxa gulesálaje̱' xua chee̱' ca', ne bulunézruje̱'-be' oro, ne xalaj zixre, ne mirra da naca na zichaj. ");
INSERT INTO zatNTps_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ca gudé na', Dios guzre̱' benne' ca' lu bchigala québedxa xelexedée̱' naga zua Herodes. Chee̱ le̱ na belexequé̱'e̱ neza xula, belexezrine̱' lazrie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ca gudé besí'aca benne' sina gula ca', nadxa tu gubáz chee̱ xabáa, gubáz chee̱ Xránadxu ble'e lawe̱' José lu bchigala, na' guzre̱' le̱': ―Guxasa. Becá'a bidu na', ne xrnabe', na' le chjaca lu xe̱zr la xu Egipto, na' xegá'anu' ga na' ca zrindxa zra xapa' lue' xetú. Caní dxal-la' gunu' lawe' da wexilaj Herodes bidu nigá chee̱ gutie̱'-be'. ");
INSERT INTO zatNTps_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nadxa José guxase̱', na' chizrélala beche̱'e̱ bidu na', ne xrnabe', na' bexu'e̱-be' lu xe̱zr la xu Egipto. ");
INSERT INTO zatNTps_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Gulezré̱'e̱ na' ca bzrindxa zra gute Herodes. Caní guca ca naca da gunná Xránadxu lu dxu'a benne' bchálaje̱' waláz chee̱', gunné̱': “Xuláwizra' bi biu chia' chee̱ xedxúajbe' lu xe̱zr la xu Egipto.” ");
INSERT INTO zatNTps_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Gate gúquebe'e Herodes gulezí xe̱ benne' sina ca' le̱', na' bzrá'ale̱'e̱, ne gunná bé'ene̱' benne' ca' xelútie̱' xúgute̱ bi biu dxé'enedau', ca zrinte̱ bidu ca' ba zaj zua chup iza, bidu ca' zaj zrabe' xe̱zre Belén, ne bidu ca' zaj zrabe' lu xé̱zredu ca' zaj naxechaj na xe̱zre Belén na'. Caní be̱n Herodes cáte̱ze buluzén benne' sina gula ca' le̱' ca naca zra na' belelé'ene̱' belaj na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ca'an guca ca da bzuaj Jeremías, bénnea' bchálaje̱' waláz chee̱ Dios ba guca zan' iza, gunné̱': ");
INSERT INTO zatNTps_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Guca tu schaga lu xe̱zre Ramá. Guca webezre, ne gulebezre xache̱'. Raquel na' dxebézrele̱'e̱ chee̱ bi chee̱' ca'. Québequeze dxaca lazre̱' xexaca zrene̱' lawe' da ba gulate bi chee̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ca gudé gute Herodes, na' tu gubáz chee̱ xabáa, gubáz chee̱ Xránadxu ble'e lawe̱' José lu bchigala naga zue̱' Egipto, na' guzre̱' le̱': ");
INSERT INTO zatNTps_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Guxásache. Beche̱'e̱ bidu chiu' nigá, ne xrnabe'. Bexíaj lu xe̱zr la xu Israel, lawe' da ba gulate benne' ca' gulaca lazre̱' xelútie̱' bidu nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nadxa guxasa José, na' beche̱'e̱ bidu na', ne xrnabe', na' belexezrine̱' lu xe̱zr la xu Israel. ");
INSERT INTO zatNTps_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ca guneze José dxenná bea Arquelao naga nababa Judea waláz chee̱ xre̱', Herodes na', na' bzrebe José xexíaje̱' ga na'. Nadxa bexíaje̱' naga nababa Galilea ca da ba guzre gubáz chee̱ xabáa le̱' lu bchigala. ");
INSERT INTO zatNTps_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ca bezrine̱' na', na' bexíaje̱' cheajxezúe̱' lu xe̱zre Nazaret. Caní guca ca da gulenná benne' ca' buluchálaje̱' waláz chee̱ Dios, gulenné̱' Jesús nigá si le̱' benne' Nazaret. ");
INSERT INTO zatNTps_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ca lu zra ca' bla' Juan, bénnea' bchue̱' bénneache nisa, dxegu'e̱ lban le̱'e̱ xixre' lawe' lataj naga nababa Judea. ");
INSERT INTO zatNTps_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Dxenné̱': ―Le xebí'i lazre' lawe' da ba zua gáguze zra nna bea Dios lu xe̱zr la xu nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan nigá naque̱' bénnea' bchalaj Isaías chee̱'. Isaías bchálaje̱' waláz chee̱ Dios gate bzuaje̱' caní: Dxene chi'i benne' dxebezre xe̱'e̱ le̱'e̱ xixre' lawe' lataj, dxenné̱': Le gucá'ana chawe' neza naga te Xránadxu. Le xulí neza lase ca' lau Le̱' naga tée̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Zra lana Juan nigá nune na xicha zra camello, ne bazxu dxu'a le̱'e̱ chee̱' naca na xide, na' dxawe̱' biche xuaj, ne bzrína'dau' chee̱ bézudau'. ");
INSERT INTO zatNTps_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Belezrín benne' belenne̱' ca da dxuchalaj Juan, benne' zá'aque̱' xe̱zre Jerusalén, ne benne' chee̱ xúgute̱ xe̱zre ca' zaj nababa Judea, ne benne' zá'aque̱' xé̱zredu ca' zaj nnita gáguze xe̱gu Jordán. ");
INSERT INTO zatNTps_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ca gulexrúale̱pe̱' dul-la chee̱', Juan nigá bchue̱' benne' ca' nisa lu xe̱gu Jordán. ");
INSERT INTO zatNTps_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Gate ble'e Juan benne' zan benne' xudau' fariseo, ne benne' xudau' saduceo zá'aque̱' chee̱ xelexedxúe̱' nisa, na' guzre̱' benne' ca': ―Le'e, be̱ snia. ¿Zua nu guzre le'e guzrúnnajle da ba xa' da za'? ");
INSERT INTO zatNTps_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Le gun da xrlátaje da xelunna bea na ba bebí'i lázrele. ");
INSERT INTO zatNTps_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Quebe guéquele lale, dxennale le'eze: “Nalatu' lawe' da nácantu' xrtia Abraham.” Neda' dxapa' le'e: Dios waca xexune̱' xiaj caní zri'ine xrtia Abraham. ");
INSERT INTO zatNTps_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Le'e nácale ca xaga ca'. Xia waga bache nalá na chee̱ chugu na xaga ca', na' xúgute̱ xaga ca' quebe dxelebía na da zixre chawe' welechugue na, na' xelezxe na lu xi'. ");
INSERT INTO zatNTps_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Da li neda' dxuchúa' le'e nisa, da dxunna bea na ba bebí'i lázrele, san Bénnea' ze̱'e̱ ca te chia' neda', Le̱' gune̱' ca da zéaje̱ xel-la' dxedxúa nisa, guzúe̱' le'e Dios Be' Lá'azxa, ne xi' chee̱'. Benne' nigá nácadxe̱' blau ca neda', na' quebe zaca' cuéajza' zrele̱' xu'u ni'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Cá'anqueze nácale ca zrua' xtila. Benne' nigá ba nu'e̱ da dxun be', cuéaje̱' xrte zrua' xtila na', na' xebéaje̱' chalá'ala xizre chee̱ na, na' xuzrá chawe̱' zrua' xtila na' lu da'a chee̱ na, san guzezxe̱' xizre na' lu xi' da quebe xexula na. ");
INSERT INTO zatNTps_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nadxa Jesús bezé̱'e̱ naga nababa Galilea, na' bezrine̱' dxu'a xe̱gu Jordán naga zua Juan chee̱ guchúe̱' Le̱' nisa. ");
INSERT INTO zatNTps_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nédxute̱ Juan quebe guca lazre̱', na' dxe̱'e̱ Jesús: ―Lue' dxal-la' guchú'u neda' nisa. Quebe zaca' neda' guchúa' Lue' nisa. ");
INSERT INTO zatNTps_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesús guzre̱' le̱': ―Be̱' lataj gaca caní na'a. Dxun na ba xen gundxu xúgute̱ da xrlátaje lau Dios. Nadxa Juan be̱ne̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Gate bexuzre gudxúa Jesús nisa, na' la bxálajte̱ xabáa, na' ble'e Juan Be' Lá'azxa chee̱ Dios dxétaje̱' ca tu gugu chíchidau', zeajsúaba' lawe Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nadxa ben tu chi'i lu be', gunné̱': ―Benne' nigá naque̱' Zrí'inequeza' nazrí'ite̱ lazra'. Dxezaca ba lázrele̱na' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nadxa Be' Lá'azxa chee̱ Dios la guché̱'te̱' Jesús le̱'e̱ xixre' lawe' lataj naga gúe lazre' da xriwe̱' gun zréaje na Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Quebe bi gudagu Jesús chua zra chua xe̱la, na' ca gudé na' gudune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nadxa da xriwe̱' bzrin na naga zua Jesús chee̱ gun zréaje na Le̱', na' dxe̱ na Le̱': ―Che Lue' nacu' Zri'ine Dios, gunná be'e xiaj caní xelexaca na xeta xtila. ");
INSERT INTO zatNTps_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús beche̱be̱': ―Lu xiche chee̱ Dios dxenné̱': “Quebe gaca ban nu benne' gawe̱' xétaze, san nen xúgute̱ dizra' chee̱ Dios gaca bane̱'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nadxa da xriwe̱' guché̱ na Jesús lu xe̱zre lá'azxa Jerusalén, na' bzua na Le̱' xíchajte̱ xudau', ");
INSERT INTO zatNTps_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","na' guzre na Le̱': ―Che Lue' nacu' Zri'ine Dios, guxrite' nigá, lawe' da dxenná lu xiche chee̱ Dios: Dios nna bé'ene̱' gubáz chee̱ xabáa chee̱' ca' chee̱ xelácale̱ne̱' Lue'. Welexechise̱' Lue' nen ne̱'e̱ chee̱ quebe gunu' zi' ni'u lu xiaj ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Na' gunná Jesús: ―Cá'anqueze dxenná lu xiche chee̱ Dios, dxe̱'e̱ bénneache: “Quebe guchínenu' Xranu' Dios cáte̱ze dxaca lazru'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nadxa da xriwe̱' guché̱ na Le̱' tu lu xi'a sibe, na' ble'e na Le̱' ca naca xúgute̱ cue' xe̱zr la xu zaj nnita lu xe̱zr la xu, ne ca naca xel-la' guni'a chee̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Na' gunná da xriwe̱', dxe̱ na Le̱': ―Xúgute̱ da caní gunna' chiu' che guzú zribu' gucá'ana szrenu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nadxa Jesús guzre̱' na: ―Bexíaj, da xriwe̱', lawe' da dxenná Dios lu xiche chee̱', dxe̱'e̱ bénneache: “Bca'ana szren Xranu' Dios, ne be lá'ana tuze Le̱'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nadxa da xriwe̱' becuasa na lau Jesús, na' belezrín gubáz chee̱ xabáa chee̱ Dios, ne bulunézruje̱' da dxechine Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Gate ben Jesús xu'u Juan lizre xia, na' bezé̱'e̱ zexíaje̱' naga nababa Galilea. ");
INSERT INTO zatNTps_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Quebe bga'ana Jesús xe̱zre Nazaret. Xeajsúe̱' lu xe̱zre Capernaum da zua na dxu'a nísadau' naga zaj zra' xrtia Zabulón, ne xrtia Neftalí. ");
INSERT INTO zatNTps_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Caní guca ca da bzuaj Isaías, benne' bchálaje̱' waláz chee̱ Dios, gunné̱': ");
INSERT INTO zatNTps_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Lu xe̱zr la xu chee̱ Zabulón, ne chee̱ Neftalí, naga zrua neza da zeaj na dxu'a nísadau', chalá'a naga dxalaj gubizra xechalá'a xe̱gu Jordán. Naga nababa Galilea, naga zaj zra' benne' quebe zaj naque̱' judío. ");
INSERT INTO zatNTps_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bénneache zaj zra' lu da chul-la belelé'ene̱' tu da dxusaníle̱'e̱ na, na' benne' zaj zra' naga xu'u zrul-la chee̱ xel-la' gute ba bsaní' tu xi' naga zaj zre̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ca lu zra na' guzú lau Jesús dxegu'e̱ lban, dxenné̱': ―Le xebí'i lázrele, lawe' da ba zua gáguze zra nna bea Dios lu xe̱zr la xu nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Gate na' zeaj Jesús dxu'a nísadau' ga nababa Galilea, na' blé'ene̱' chupa benne'. Tue̱' le̱' Simón, ne zua xetú le̱' Pedro, na' xetúe̱' le̱' Andrés, biche Simón na'. Benne' caní zaj naque̱' benne' wezén bela, na' dxuluzale̱' xixruj bela chee̱' lu nisa. ");
INSERT INTO zatNTps_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nadxa Jesús dxe̱'e̱ benne' caní: ―Le gun neda' tuze, na' guna' le'e benne' gutúpale chia' bénneache ca dxunle dxezenle bela. ");
INSERT INTO zatNTps_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","La bulucá'anate̱' xixruj chee̱' ca', na' zjácale̱ne̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Xelátedauze gusá'aque̱', na' ble'e Jesús xechupa benne'. Tue̱' le̱' Jacobo, ne xetúe̱' le̱' Juan, biche Jacobo nigá. Zaj naque̱' zri'ine Zebedeo, ne zaj xu'e̱ tu lu da dxedá lawe' nísadau' nen xre̱', dxelexún chawe̱' xixruj chee̱'. Jesús bláwizre̱' le̱', ");
INSERT INTO zatNTps_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","na' la bulucá'anate̱' da dxedá lawe' nísadau' na', ne xre̱', na' zjácale̱ne̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Zeaj Jesús xúgute̱ xe̱zre zaj nababa Galilea, na' tu tu xe̱zre ca' dxuzéajni'ine̱' bénneache lu xu'u ca' naga dxulucá'ana szren benne' judío ca' Dios. Na' dxegu'e̱ lban ca nna bea Dios, ne dxexune̱' xúgute̱ benne' ca' ca zaj naca xízrawe̱' cha chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ca'an guca, xúgute̱ benne' chee̱ xe̱zr la xu Siria belenne̱' ca da dxun Jesús, na' belezrine̱' lau Jesús, zaj naché̱'e̱ benne' we̱' ca', benne' zaj xu'e̱ xízrawe̱', ne benne' zaj zue̱' lu xel-la' dxudía, ne benne' zaj xu'e̱ be' xriwe̱', ne benne' zaj xu'e̱ chuna', ne benne' zaj naxrú'unie̱' bine, na' bexún Jesús xúgute̱ benne' caní. ");
INSERT INTO zatNTps_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Zjácale̱ benne' zan Le̱', benne' zaj nababe̱' xe̱zre ca' zaj nababa Galilea, ne benne' zá'aque̱' xe̱zre Decápolis ca', ne benne' Jerusalén, ne benne' zaj nababe̱' xe̱zre ca' zaj nababa Judea, ne benne' zá'aque̱' xechalá'ala xe̱gu Jordán naga dxalaj gubizra. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Gate ble'e Jesús xúgute̱ benne' zan ca' zá'aque̱' naga zue̱', nadxa guluéne̱' tu lu xi'a, ne gudxé'e̱ na'. Nadxa benne' ca' dxuse̱de Jesús beledube̱' cuite̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nadxa guzú lau Jesús dxusé̱dene̱' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Gunná Jesús: ―Da ba neza zrente̱ naca na chee̱ benne' ca' dxelexúnbe'e̱ ca naca xel-la' dxexazrje chee̱' lau Dios. Benne' caní zaj naca chee̱' xelexú'e̱ naga dxenná bea Dios xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Da ba neza zrente̱ naca na chee̱ benne' ca' dxelelé'ele̱' zaj zue̱' lu da baxache' lawe' da zaj nabague̱' dul-la. Dios dxexúe zrene̱' benne' caní. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Da ba neza zrente̱ naca na chee̱ benne' zaj naque̱' zren lazre'. Benne' caní xelezí'e̱ chee̱' xe̱zr la xu da nache̱be lazre' Dios gunézruje̱' benne' caní. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Da ba neza zrente̱ naca na chee̱ benne' du lazre' dxelaca lazre̱' xelune̱' da naca xrlátaje lau Dios. Dios gácale̱ne̱' benne' caní. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Da ba neza zrente̱ naca na chee̱ benne' dxelexexache lazre̱' benne' xula. Dios wexache lazre̱' benne' caní. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Da ba neza zrente̱ naca na chee̱ benne' ca' zaj xu'u xichaj lázrdawe̱' da xrlátaje. Benne' caní welelé'ene̱' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Da ba neza zrente̱ naca na chee̱ benne' dxelebeza zri lazre̱' nen bénneache. Dios guzúe̱' le̱' ca bi cheé̱queze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Da ba neza zrente̱ naca na chee̱ benne' dxeledée̱' xel-la' zi' lu na' benne' ca' dxelune̱' chee̱' da cale̱la cate' dxelune̱' da xrlátaje. Benne' caní zaj naca chee̱' xelexú'e̱ naga dxenná bea Dios xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Da ba neza zrente̱ naca na chee̱le le'e che benne' dxelenné̱' schanni' chee̱le, ne dxelune̱' chee̱le da cale̱la, ne dxelenné̱' chee̱le xúgute̱ dizra' we̱n lazre' lawe' da nácale chia' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Le be, ne le xezaca ba lázrele lawe' da wazile tu da zrente̱ da gunna Dios le'e xabáa. Caní gaca na lawe' da cá'anqueze caní guláu zi' xuzre̱' benne' ca' buluchálaje̱' waláz chee̱ Dios, benne' ca' gulezré̱'e̱ nédxudxa ca le'e. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Na' gunná Jesús: ―Le'e nácale ca zede' chee̱ bénneache lu xe̱zrla xu nigá. Che zede' nigá xenite xel-la' sna'a chee̱ na, ¿ájazra gácale̱le bénneache ca'? Québedxa gaca guchínedxu zede' caní. ¡Chú'unadxu na, na' xululéaj bénneache le̱ na! ");
INSERT INTO zatNTps_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Le'e nácale ca tu xi' chee̱ bénneache zaj zre̱'e̱ xe̱zr la xu. Tu xe̱zre da zua na tu lu xi'a, quebe gáchequeze na. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Gate guzálajdxu tu xi', quebe gudúsedxu na. Guzúadxu na sibe naga gusení na chee̱ xelelé'e xúgute̱ benne' zaj zre̱'e̱ lu xu'u. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Cá'anqueze le gun le'e. Le güe lataj gusení xi' da nácale lau bénneache ca' chee̱ xelelé'ene̱' ca da xrlátaje da dxunle. Nadxa xelúe lá'ane̱' Xrale Dios zue̱' xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Gunná Jesús: ―Quebe dxal-la' guéquele le'e za'a neda' chee̱ cua' ca naca da bdxixruj be'e Moisés, ne ca naca dizra' da buluchalaj benne' ca' buluchálaje̱' waláz chee̱ Dios. Quebe za'a chee̱ cua' na. Za'a chee̱ gulé'eda' cáte̱ze zéaje̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Da li dxapa' le'e. Dxácate̱ zaj zua xabáa, ne xe̱zr la xu nigá, quebe dúaqueze tu dizra', ne tu da da' lu da nadxixruj bea na nigá ca zrindxa zra gaca xúgute̱ ca da dxal-la' gaca na. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Chee̱ le̱ na', che tu benne' guzúe̱' chalá'ala bítete̱zla da nigá da bdxixruj bea Dios, láqueze naca na tu da dauze, ne che guzéajni'ine̱' bénneache chee̱ xelúnqueze̱' ca', benne' nigá xegá'ane̱' cá'aze naga dxenná bea Dios xabáa. Bénnea' guzúe̱' dizra' da nadxixruj bea nigá, ne gulé'ene̱' bénneache chee̱ xelúnqueze̱' ca', benne' nigá wegá'anaqueze̱' ba lá'ana naga dxenná bea Dios xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Dxapa' le'e, che quebe gunle da nácadxa xrlátaje ca da dxelún benne' ca' dxuluxuzájle̱'e̱ da nadxixruj bea Dios, ne ca da dxelún benne' xudau' fariseo ca', cabata' xexú'ule le'e naga dxenná bea Dios xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Na' gunná Jesús: ―Le'e ba bénele ca gulenná xrtíale gula ca': “Quebe gútele benne',” na' “Nútete̱ze benne' gutie̱' benne' waxíaje̱' chee̱ cuía xi'e̱.” ");
INSERT INTO zatNTps_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Neda' dxapa' le'e, nútete̱ze benne' dxezré̱'e̱ le sa' ljwezre̱' waxíaje̱' chee̱ cuía xi'e̱. Na' bénnea' dxenné̱' schanni' chee̱ le sa' ljwezre̱' waxíaje̱' lau benne' chee̱ xu'u lawe' blau, na' xuludée̱' le̱' chee̱ cuía xi'e̱. Bénnea' dxenné̱' chee̱ le sa' ljwezre̱' tu dizra' sban, benne' nigá nácaqueze chee̱' chéaje̱' lu lataj ba xa'. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Che gu'u lu xudau' tu da gunézruju' lau Dios, ne na' cheajsá lazru' chee̱ tu da nunu' chee̱ le sa' ljwezru', ");
INSERT INTO zatNTps_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","bca'ana da na' gunézruju' na', teca xexíaju' xegá'anu' chawe' nen le sa' ljwezru'. Nadxa waca xexíaju' lu xudau' chee̱ bi gunézruju' lau Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Che zua nu benne' dxebagu' chee̱', na' che̱'e̱ lue' lau benne' guchi'e̱ chiu', bexaca chawe' nen le̱' la neza na', chee̱ quebe gudée̱' lue' lau bénnea' dxuchi'e̱ da dxaca. Che quebe gunu' caní, nadxa benne' dxuchi'e̱ da dxaca na' gudée̱' lue' lu na' benne' dxusézxuje̱' bénne' ca' lizre xia, na' xelegú'e̱ lue' lizre xia na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Da li dxapa' lue'. Quebe xedxúaju' na' che quebe quízruju' xúgute̱ da dxebagu' chee̱ benne' na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Na' gunná Jesús: ―Le'e bache bénquezle ca gulenné̱' nédxute̱: “Quebe gunu' dul-la da dxichaj na xrba chee̱ xel-la' nuchaga na'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Neda' dxapa' le'e, nútete̱ze benne' ne̱'e̱ tu nu'ula, ne sa lazre̱' le̱', báchequeze be̱ne̱' dul-la nen nu'ula na' lu xichaj lázrdawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Che xiaj lau' da zua xabe̱la dxuzúa na lue' lu dul-la, guleaj na, ne gudxú'una na zítu'la. Nácadxa chawe' nite late' da naca na chee̱ be̱l-la' dxen chiu' quézcala chu'u lataj ba xa' dute̱ be̱l-la' dxen chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Che na'u da zua xabe̱la chiu' dxuzúa na lue' lu dul-la, guchugu na, ne gudxú'una na zitu'. Nácadxa chawe' nite late' da naca na chee̱ be̱l-la' dxen chiu', quézcala chu'u lataj ba xa' dute̱ be̱l-la' dxen chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Na' gunná Jesús: ―Cá'anqueze gulenné̱' nédxute̱: “Nútete̱ze benne' dxexelé̱'e̱ nen zru'ule̱', dxal-la' gunézruje̱' nu'ula na' tu xiche da dxulé'e na belexelé̱'e̱.” ");
INSERT INTO zatNTps_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Neda' dxapa' le'e, che tu benne' dxexelé̱'e̱ nen zru'ule̱', na' nu'ula nigá quebe guzúale̱ne̱' benne' xula, benne' chee̱ nu'ula nigá dxuzúe̱' le̱' lu dul-la chee̱ da dxichaj na xrba chee̱ xel-la' nuchaga na' che tu benne' biu xula guchaga ne̱'e̱ nen nu'ula na' bsan benne' chee̱' le̱'. Cá'anqueze le̱' dxune̱' dul-la nen nu'ula na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Na' gunná Jesús: ―Cá'anqueze ba bénele ca gulenná benne' gula ca', gulenné̱': “Quebe gucá'anu' cá'aze ca da nache̱be lazru' nen dizra' bca'ana liu' lau Xránadxu Dios.” ");
INSERT INTO zatNTps_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Neda' dxapa' le'e: Quebe dxal-la' guzétjale xabáa chee̱ guca'ana lile dizra' chee̱le, lawe' da naca na naga dxe' Dios, ");
INSERT INTO zatNTps_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ne quebe guzétjale xe̱zr la xu nigá lawe' da naca na naga nuzúa Dios ni'e̱, ne quebe guzétjale Jerusalén lawe' da naca na xe̱zre chee̱ Benne' Blau naque̱' Wenná Bea. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Quebe guzétjale xíchajle chee̱ guca'ana lile dizra' chee̱le lawe' da quebe séquele gunle da chiche, ne da gasaj netú xicha xíchajle. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Le nnaze: “Awe',” u le nnaze: “Cabí,” lawe' da gate tu benne' dxudadxe̱' chee̱' chee̱ da nigá, naca na chee̱ da xriwe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Na' gunná Jesús: ―Le'e ba bénele ca da gulenné̱' nédxute̱: “Che tu benne' cuéaje̱' xiaj lau', cá'anqueze gunu' chee̱', ne che cuéaje̱' lazxu', cá'anqueze gunu' chee̱'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Neda' dxapa' le'e, quebe tíl-lale̱le nu benne', san che tu benne' gu'e̱ chalá'a xragu', be̱' lataj gu'e̱ xechalá'a xragu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Che tu benne' gaca xúzre'le̱ne̱' lue', ne dxaca lazre̱' cue̱' zrau', be̱' lataj xúate̱' xicha chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Che dxulusebágue̱' lue' gu'u xua chee̱' tu cuéndau', bia na chupa cuenla. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Che nútete̱ze benne' bi dxenabe̱' chiu', bnézruje̱' na, ne quebe guzagu' ca gunézruju' chee̱ nu benne' bi dxenabe̱' chite̱. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Na' gunná Jesús: ―Cá'anqueze ba bénele ca da gulenné̱' nédxute̱: “Bzri'i le sa' ljwezru', ne gucuide benne' dxedábague̱' lue'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Neda' dxapa' le'e, le zri'i benne' ca' dxeledábague̱' le'e. Le naba gaca chawe' chee̱ benne' dxelenné̱' chee̱le. Le gun da chawe' chee̱ benne' dxelecuídene̱' le'e. Le naba lau Dios gaca chawe' chee̱ benne' dxelenné̱' schanni' chee̱le ne dxelune̱' chee̱le da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Che gunle caní gácale bi cheé̱queze Xrale zue̱' xabáa, lawe' da dxun Le̱' dxusaní' gubizra naga zaj zra' benne' we̱n da cale̱la ne naga zaj zra' benne' xrlátaje ca', ne dxusel-la' nisa xiuj lu xe̱zr la xu chee̱ benne' chawe' ca', ne lu xe̱zr la xu chee̱ benne' ca' dxelune̱' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Che nazrí'ile tuze benne' zaj nazrí'ine̱' le'e, ¿ájazra na' dxezá lázrele quizruj Dios le'e? Cá'anqueze dxelún benne' wechizruj ca', zaj nazrí'ine̱' le sa' ljwezre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Che le'e dxugápale diuzre tuze le sa' ljwézrele, ¿bizra da xrlátaje dxunle? Cá'anqueze dxelún benne' quebe zaj núnbe'e̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Le gaca benne' xrlátaje cáte̱ze naca Xrale zue̱' xabáa, naque̱' xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Caní gunná Jesús: ―Le guxúe xanne' cuínale chee̱ quebe gunle da naca chee̱ xel-la' benne' xudau' chee̱le lau bénneache chee̱ xelelé'ene̱' na. Che ca'an dxunle, na' Xrale Dios zue̱' xabáa québequeze bi gunne̱' le'e. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Chee̱ le̱ na', gate lue' dxácale̱nu' benne' dxelexázrjene̱', quebe guzennu' xúgute̱ bénneache ca da dxunu', ca dxelún benne' ca' dxelune̱' xrlátaje cúzreze la neza, ne lu xu'u naga dxulucá'ana szren benne' judío ca' Dios. Dxelune̱' da caní chee̱ xelenné̱ bénneache xrlátaje chee̱'. Da li dxapa' le'e, ba dé̱queze lazruj chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Gate lue' gunézruju' late' chee̱ benne' dxelexázrjene̱', be̱n na luéze chee̱ quebe neze le sa' ljwezru'. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Be̱n da caní bagácheze, na' Xrau' Dios, Bénnea' dxelé'ene̱' ca da dxunu' bagácheze, Le̱' gunne̱' lazruj chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Na' gunná Jesús: ―Gate le'e gunle xel-la' dxuláwizra Dios, quebe gunle ca dxelún benne' ca' dxelune̱' xrlátaje cúzreze. Dxeledánene̱' dxelune̱' xel-la' dxuláwizra Dios zaj ze̱ze̱' lu xu'u naga dxulucá'ana szren benne' judío ca' Dios, ne la neza, chee̱ xelelé'e bénneache da dxelune̱'. Da li dxapa' le'e, ba dé̱queze lazruj chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Gate lue' dxuláwizru' Dios, guxú'u lu xu'u chiu'. Bsezxuj dxa xu'u chiu', na' bláwizra Dios guchálajle̱nu' Xrau' Dios zúale̱ne̱' lue' naga zu' tuzu'. Nadxa Xrau' Dios, Bénnea' dxelé'ene̱' ca da dxunu' bagácheze, Le̱' xuzri'e̱ chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Gate dxuláwizru' Dios dxuchálajle̱nu' Le̱', quebe tuz ca da nneu' zánete̱ lasa ca dxelún benne' ca' quebe zaj núnbe'e̱ Dios. Dxeléquene̱' wen Dios chee̱' lawe' da dxelenné̱le̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Quebe gunle ca dxelún benne' ca', lawe' da Xrale Dios ba nézquezne̱' ca da dxechínnele le'e nédxula ca za nábale na. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Chee̱ le̱ na', le guláwizra Dios nnale caní: Xrantu' Dios, zu' xabáa, gaca lá'azxaqueze Lau'. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Gudá nna be'u lu xe̱zr la xu nigá. Gaca lu xe̱zr la xu nigá ca dxaca lazru' Lue', cáte̱ze dxaca xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Be̱nna netu' da gáguntu' na'a. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bnite lau chee̱ntu' ca naca da cale̱la da be̱ntu', ca netu' ba bnite launtu' chee̱ benne' belune̱' chee̱ntu' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Quebe gu'u lataj nu gun zréaje netu', 2 san bselá netu' lu na' da xriwe̱'. Naca chiu' gápaquezu' xel-la' dxenná bea, ne xel-la' waca, ne da xabáa chadía chacanna. ¡Ca'an gaca na! ");
INSERT INTO zatNTps_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Che le'e gunite laule chee̱ benne' belune̱' chee̱le da cale̱la, na' Xrale Dios zue̱' xabáa gunite lawe̱' chee̱le le'e. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Che le'e quebe gunite laule chee̱ benne' ca', na' Xrale Dios quebe gunite láuqueze̱' chee̱le le'e ca naca dul-la da nabágale. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Na' gunná Jesús: ―Gate le'e dxunle gubasa, quebe guzúale baxache' laule ca dxelún benne' dxelune̱' xrlátaje cúzreze. Benne' caní dxelune̱' ca' chee̱ xelelé'e bénneache le̱' dxelune̱' gubasa. Da li dxapa' le'e, ba dé̱queze lazruj chee̱ benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Lue', gate dxunu' gubasa, bza xíchaju' chawe', ne gudibe lau', ");
INSERT INTO zatNTps_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","chee̱ quebe xeléquebe'e bénneache dxunu' gubasa. Tuze Xrau' Dios na', Bénnea' zúale̱ne̱' lue' naga zu' tuzu', Le̱' dxennátequeze̱', na' gunne̱' da naca na chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Na' gunná Jesús: ―Quebe gutúpale da gunní'a lu xe̱zr la xu nigá, naga guteba' na, ne da ca' dxelebía xi na, na' xelú'u gubán ne xelebane̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Le'e, le gun da xrlátaje, da gaca na ca guzrá cháwele da gunní'a xabáa, naga quebe guteba' na, ne da ca' quebe bi xeleque na, na' québequeze xelú'u gubán chee̱ xelequé̱'e̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Naga nuzrale da gunní'a chee̱le, na' zúaqueze lázrdaule. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Na' gunná Jesús: ―Xiaj laule zaj naca na ca tu xi' chee̱ be̱l-la' dxen chee̱le. Che xiaj laule zaj naca na chawe', dute̱ ca naca be̱l-la' dxen chee̱le naxaní'. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Che xiaj laule quebe zaj naca na chawe', dute̱ ca naca be̱l-la' dxen chee̱le nachul-la na. Cá'anqueze che xi' da xu'ule xexaca na tu da chul-la, chúl-lale̱'e̱dxa súaquezle. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Na' gunná Jesús: ―Netú benne' quebe séquene̱' guzúa cuine̱' lu na' chupa xrane̱', lawe' da wazré̱'e̱ tu xrane̱' ne wazrí'ine̱' xetúe̱', u wéquene̱' ba lá'ana tu xrane̱' na' xetúe̱' guzúe̱' chalá'ala. Quebe séquele guzúa cuinle lu na' Dios, ne lu na' da gunní'a. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Na' gunná Jesús: ―Chee̱ le̱ na' dxapa' le'e, quebe cue'le gunne xue ga sa' da gágule da xí'ajle chee̱ gaca banle, ne ga sa' zra lánale da gácule. Zácadxa xel-la' nabán chee̱le ca da dxágule, ne zácadxa be̱l-la' dxen chee̱le ca zra lánale. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Le nna'xque bxínnedu ca' dxeledaba' lu be'. Quebe dxelázaba'. Quebe dxelelápaba'. Quebe ga dxuluxuzrá cháweba' na. Xrale Dios zue̱' xabáa dxunézruje̱' da dxeláguba'. Zácadxale le'e ca bxínnedu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Nuzra benne' ládujla le'e gaca gusetunna cuine̱' xate' lawe' da dxe'e̱ gunne xue? ");
INSERT INTO zatNTps_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Bizr chee̱ na' dxe'le le'e gunne xue chee̱ zra lánale? Le nna'xque ca dxelegula xiaj ca' zaj ze̱ le̱'e̱ xixre'. Quebe dxelún na zrin, ne quebe dxelache na du. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Dxapa' le'e, Salomón benne' wenná bea na' quebe gucue̱' ca da xrtan chee̱ xiaj caní, na' le̱' gúta'le̱'e̱ chee̱' da gunní'a. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Che Dios dxudxe̱ne̱' xrtánle̱'e̱ xiaj caní da ca' zaj zua na na'a le̱'e̱ xixre', na' wxre xelezxe na lu xi', quegá gundxe̱' da chawe' chee̱le le'e, benne' québete̱ ca dxeajlí lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Chee̱ le̱ na', quebe cué'tecale gunne xue, nnale: “¿Ga sa' da gágudxu? ¿Ga sa' da xí'ajdxu? ¿Ga sa' da gácudxu?” ");
INSERT INTO zatNTps_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Chee̱ da caní zaj dxe' gunne xue benne' quebe zaj núnbe'e̱ Dios, san le'e, zua tu Xrale xabáa ba nézquezne̱' ca naca xúgute̱ da dxechínnele. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Zria laudxa cuele gunne xue chee̱ nna bea Dios lu xichaj lázrdaule, ne chee̱ gunle da xrlátaje da xezaca ba lazre' Dios, na' sile xúgute̱ da ca' dxechínnele. ");
INSERT INTO zatNTps_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Quebe cuele gunne xue na'a da naca na chee̱ wxre, lawe' da wxre ca'an gáta'queze da cuele gunne xue. Tu zra tu zra dé̱queze da guchaga laudxu. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Na' gunná Jesús: ―Quebe guchí'ale da dxelún le sa' ljwézrele chee̱ quebe guchi'a Dios caní chee̱le le'e. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Le̱' guchi'e̱ chee̱le le'e cáte̱ze dxunle le'e chee̱ le sa' ljwézrele, ne cáte̱ze dxunle le'e chee̱ le sa' ljwézrele, ca'an gun Dios nen le'e. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Bizr chee̱ na' dxená'u bé̱bedau' da xu'u xiaj lau le sa' ljwezru', ne quebe dxená'u da zrente̱ da xu'u na xiaj láuquezu' lue'? ");
INSERT INTO zatNTps_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Ájazra gunu' xu'u le sa' ljwezru': “Be̱nna lataj xebéaja' bé̱bedau' da xu'u xiaj lau'”, che da zrendxa xu'u xiaj láuquezu' lue'? ");
INSERT INTO zatNTps_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Lue', benne' dxun xrlátaje cúzreze. Bebéaj nedxu da zrente̱ da xu'u xiaj láuquezu', na' gaca le'enu' cháwedau' xebéaju' bé̱bedau' da xu'u xiaj lau le sa' ljwezru'. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Quebe gunézrujle da naca lá'azxa chee̱ benne' dxelune̱' ca dxelún becu' snia, checa xelexéchaje̱', ne xuluzúzrue̱' le'e. Quebe guzúale da zaca chee̱le lau benne' dxelune̱' ca dxelún cuche, dxuluchuchuj dxululéajba' da dxugágule-ba'. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Na' gunná Jesús: ―Le naba, na' Dios gunne̱' na chee̱le. Le xilaj na, na' xezrélele na. Le nne̱ dxu'a dxa xu'u, na' sáluje̱' chee̱le. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Le gun caní lawe' da benne' bi dxenabe̱', dxezi'e̱ na. Benne' bi dxexílaje̱', dxeajxraque̱' na, na' benne' dxenné̱' dxu'a dxa xu'u, zua nu benne' sáluje̱' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Netule le'e quebe gunézrujle zrí'inele tu xiaj che le̱be' dxenábabe' le'e tu xeta. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Quebe gunézrujle zrí'inele tu be̱la' snia che le̱be' dxenábabe' le'e tu bela. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Che le'e, benne' we̱n da cale̱la, nézele gunézrujle zrí'inele da naca na chawe', da cháwedxa gunna Xrale Dios zua xabáa, gunne̱' da chawe' chee̱ benne' bi dxenábene̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Le gun chee̱ le sa' ljwézrele ca dxaca lázrele le'e xelún le̱be' chee̱le. Da nigá naca da nadxixruj bea na Moisés, ne da dxenná na lu xiche naga naxúaj da gulenná benne' ca' buluchálaje̱' waláz chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Na' gunná Jesús: ―Le chu'u lu dxa xu'u lechide'. Dxa xu'u laga, ne neza xu zaj naca naga zjaca benne' xelebía xi'e̱, na' benne' zante̱ zjaque̱' na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Dxa xu'u lechide', ne neza lase zaj naca naga zjaca benne' xelezí'e̱ xel-la' nabán da zeajlí canna, na' bábaze benne' dxelexezrelne̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Na' gunná Jesús: ―Le guxúe cuínale chee̱ benne' we̱n lazre' ca', benne' dxelenné̱' zaj naque̱' benne' dxuluchálaje̱' waláz chee̱ Dios. Benne' caní zá'aque̱' naga zrale le'e, zaj nun cuine̱' ca tu benne' dxexruj lazre' ca naca tu zríla'dau', san lu xichaj lázrdawe̱' zaj naque̱' snia ca tu becu' xi'a. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Le'e xúnbeale le̱' ne̱ chee̱ da dxelune̱'. Da zixre da dxebía lba uva quebe xuchíbedxu na lu xaga xeche', na' da zixre da dxebía xaga higo quebe xuchíbedxu na lu xeche' ga'. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ca'an naca, xúgute̱ xaga chawe' dxelebía na da zixre chawe', na' xaga da quebe naca na chawe', quebe dxebía na da zixre chawe'. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Xaga chawe' ca' quebe dxelebía na da zrinnaj, na' xaga zrinnaj na' quebe dxebía na da chawe'. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Xúgute̱ xaga zrinnaj welechugue na, na' xelezxe na lu xi'. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ca'an naca, le'e xúnbeale benne' ca' ne̱ chee̱ da ca' dxelune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Na' gunná Jesús: ―Quebe xelu'e̱ naga dxenná bea Dios xabáa xugute̱ benne' ca' dxelé̱'e̱ neda': “Xrana', Xrana'.” Welú'u tuze benne' ca' dxelune̱' ca da dxaca lazre' Dios zue̱' xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ca zrin zra na', benne' zante̱ xelé̱'e̱ neda': “Xránantu', Xránantu', netu' bchálajntu' ne̱ chee̱ Lau' Lue', ne bchínentu' Lau' bebéajntu' be' xriwe̱' ca', ne nen Lau' Lue' bé̱nle̱'e̱ntu' xel-la' waca ca' chee̱ xabáa.” ");
INSERT INTO zatNTps_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nadxa neda' xápaqueza' benne' ca': “Quebe núnbe'a le'e. Le cuasa cuita' neda', le'e, ba be̱nle da cale̱la.” ");
INSERT INTO zatNTps_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Na' gunná Jesús: ―Bénnea' dxenne̱' chia', ne dxune̱' ca da dxennía', naque̱' ca tu benne' naxéajni'iqueze', benne' be̱ne̱' tu lizre̱' lu xiaj xre. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Guca xiuj, na' bdxuaj guba'u, ne guxasa be' bdunu' chee̱ xuluzría xi na xu'u na', san quebe guzré'e na lawe' da xu'u lane na lu xiaj xre. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Bénnea' quebe dxuzé̱ nague̱' chia', ne quebe dxune̱' ca da dxennía', naque̱' ca tu benne' xala, benne' be̱ne̱' tu lizre̱' lu xu dxeze. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Guca xiuj, na' bdxuaj guba'u ne guxasa be' bdunu' chee̱ xuluzría xi na xu'u na', na' chadite guzré'e na, ne guzría xite̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ca bexuzre bchalaj Jesús, na' belexebanne benne' ca' ca naca da bsé̱dene̱', ");
INSERT INTO zatNTps_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","lawe' da dxusé̱dene̱' benne' ca' ca tu benne' nape̱' xel-la' dxenná bea, ne quegá ca dxelún benne' ca' dxuluxuzájle̱'e̱ da nadxixruj bea Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Gate bexetaj Jesús lu xi'a na', benne' zante̱ zjácale̱ne̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Na' bzrin tu benne' we̱' dxuzru lu xpe̱le̱', ne bzu zribe̱' lau Jesús. Dxe̱'e̱ Le̱': ―Xran, che dxaca lazru', waca xexunu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nadxa Jesús guxrúa ne̱'e̱ bénnea'. Dxe̱'e̱ le̱': ―Dxaca lazra'. Na'a dxexuna' lue'. Ca gunné̱' caní, benne' we̱' na' bexácate̱' ca naca xízrawe̱' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Na' Jesús guzre̱' le̱': ―Gunná' xque. Quebe nu xu'u ca'. Bexíajze na'a xeajxelé'e cuinu' lau bxruze, ne xeajnezruj guna' ca da dxenná bea lu da bdxixruj be'e Moisés, chee̱ xelelé'e benne' ca' ba bexacu' na'a. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ca bexú'u Jesús lu xe̱zre Capernaum, na' bzrin lawe' tu benne' Roma, benne' dxenná be'ene̱' benne' ca' dxjaque̱' wedil-la, na' guta' xuene̱' Le̱', ");
INSERT INTO zatNTps_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","dxe̱'e̱ Le̱': ―Xran, bi we̱n zrin chia' de̱be' lizra'. Naxrú'unebe' bine, ne dxezácale̱'e̱be'. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús dxe̱'e̱ le̱': ―Wazá'a xexuna'-be'. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Benne' dxenná be'e̱ na' gunné̱': ―Xran, quebe naca chia' chu'u lizra'. Cun gunne̱ze, na' xexaca bi we̱n zrin chia'. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Caní waca gunu' lawe' da zua benne' dxenná bé'ene̱' neda', ne cá'anqueze neda' dxenná be'eda' benne' ca' dxjaque̱' wedil-la. Gate dxapa' tube': “Guxíaj”, na' dxéajbe'. Na' gate dxapa' bi xula: “Gudá”, na' dxídabe'. Na' gate dxuchíneda' bi we̱n zrin chia' chee̱ bi da gunbe', na' dxunbe' na. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Gate bene Jesús da nigá, bebánene̱', na' guzre̱' benne' ca' zjácale̱ne̱' Le̱': ―Da li dxapa' le'e, ládujla benne' Israel quebe nu ne xezrelda', benne' dxéajle̱'e̱ chia' ca dxun benne' nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Neda' dxapa' le'e, zá'aca benne' zante̱ chalá'a naga dxalaj gubizra, ne xechalá'ala naga dxebía gubizra, na' xelebé'e̱ tu zren xelawe̱' nen Abraham, ne Isaac, ne Jacob naga dxenná bea Dios xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Benne' ca' gucá'a zga'ale Dios chee̱ xelu'e̱ naga dxenná bea Le̱', guzale̱' benne' ca' lataj chul-la naga xelebezre̱', ne xeláguxa'ate̱ lazxe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nadxa Jesús guzre̱' benne' dxenná be'e̱ na': ―Bexíaj lizru'. Waca ca da ba guxéajle̱'u. Ca lu zra ná'queze bexácate̱ bi we̱n zrin chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Guxíaj Jesús lizre Pedro, na' blé'ene̱' xrna zru'ule̱' de̱' lu da'a, xu'e̱ da la. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Xeajté̱' ne̱'e̱, na' bedxúaj da la da xu'e̱. Nadxa nu'ula na' guxase̱', ne guzú lawe̱' dxusení'e̱ da xelagu benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ca guzría gubizra, na' belezrín benne' zante̱ lau Jesús, zaj naché̱'e̱ benne' zaj xu'e̱ be' xriwe̱' ca'. Nen dízra'ze da gunná Jesús, bebéaje̱' be' xriwe̱' ca', ne bexune̱' xúgute̱ benne' we̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Da nigá guca na ca da gunná Isaías, benne' bchálaje̱' waláz chee̱ Dios, gunné̱': “Le̱' bequé̱'e̱ xízrawe̱' ca' da nápadxu, ne gubague̱' ca da dxezácadxu.” ");
INSERT INTO zatNTps_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Gate na' ble'e Jesús benne' zante̱ zaj naxéchaje̱' Le̱', na' guzre̱' benne' ca' dxusé̱dene̱' gulelague̱' xechalá'a nísadau' tu lu da dxedá lawe' nisa. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Na' bzrin lau Jesús tu benne' dxuxuzájle̱'e̱ da bdxixruj be'e Dios, na' dxe̱'e̱ Le̱': ―Benne' Wesede, dxaca lazra' sále̱na' Lue' gátete̱ze chéaju'. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Na' Jesús guzre̱' le̱': ―Beza' zaj zua bluaj chee̱ba', na' bxinne zaj zria xrú'uneba', san neda', Benne' Gulje̱' Bénneache, ne naga xrua xíchaja' quebe ga zua. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Bzrin xetú benne' naque̱' benne' ba bsé̱dequeze Jesús, na' guzre̱' Le̱': ―Xran, be̱nna neda' lataj xexá'a nedxu chee̱ cheajxecacha' xra'. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nadxa Jesús guzre̱' le̱': ―Gudále̱n neda'. Be̱' lataj benne' gate ca' xulucache ljwezre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nadxa guxú'u Jesús lu da dxedá lawe' nísadau', na' benne' ca' dxusé̱dene̱' belune̱' Le̱' tu zren. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na' guzú lau dxaca tu be' bdunu' lawe' nísadau', na' xeajxruza chee̱ nísadau' guxú'u na lu da dxedá lawe' nísadau' na', dxácate̱ dxase Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nadxa benne' ca' dxusé̱dene̱' bulusebane̱' Le̱', na' dxelé̱'e̱ Le̱': ―Xránantu'. Bselá netu'. Ba dxázentu' lu nisa. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús guzre̱' le̱': ―¿Bizr chee̱ na' dxezrébele̱'e̱le? Nácale benne' látega dxeleajlí lázre' Dios. Nadxa guxasa Jesús. Gudil-le̱' be' bdunu', ne nísadau', na' la belebé zrite̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Benne' ca' belexebánene̱', gulenné̱': ―¿Núzraqueze benne' nigá? Dxuluzúa be', ne nísadau' dizra' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Gate bezrín Jesús xechalá'a nísadau' na' lu xe̱zr la xu chee̱ benne' Gadara, na' chupa benne' biu belexedxúaje̱' lu bluaj chee̱ benne' gate, na' belezrine̱' lau Jesús. Dxúpate̱ benne' ca' zaj xu'e̱ be' xriwe̱', ne zaj naque̱' benne' sníale̱'e̱, na' netú benne' quebe dxexázrene̱' xedée̱' la neza na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Na' gulezú lawe' dxelebézrexe̱'e̱. Dxelenné̱': ―¿Bizr chee̱ na' za'u naga zúantu', Jesús, Zri'ine Dios? ¿Za'u nigá chee̱ gusaca zi'u netu', ne quebe ne zrin zra? ");
INSERT INTO zatNTps_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tu chi na' zra tu cue' cuche dxeláguba'. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Be' xriwe̱' ca' gulata' xue na Jesús, gulenná na: ―Che Lue' xebéaju' netu' nigá, be̱nna lataj cheajchú'untu' lu cuche ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nadxa Jesús guzre̱' na: ―Le chjaca xca'. Nadxa be' xriwe̱' ca' belexedxúaj na lu benne' ca', na' belexú'u na lu cuche ca'. Nadxa xúgute̱ cuche ca' belelázruba' tu dxu'a xi'a zren, na' xeajlecházeba' lu nísadau' naga gulázeba' nisa, na' guláteba'. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Benne' ca' buluxúe̱'-ba' belezrebe̱', na' besá'aca chégüe̱', ne belexezrine̱' lu xe̱zre. Buluchálaje̱' ca guca xúgute̱ da caní, ne ca guca chee̱ benne' ca', belexedxúaj be' xriwe̱' zaj xu'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nadxa xúgute̱ benne' zaj zre̱'e̱ lu xe̱zre na' beledxúaje̱', ne belezrine̱' naga zua Jesús. Na' ca belelé'ene̱' Le̱', gulata' xuene̱' Le̱' xezé̱'e̱ lu xe̱zr la xu chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nadxa Jesús guxú'e̱ tu lu da dxedá lawe' nísadau', na' gulague̱' xechalá'a nísadau', na' bezrine̱' lázrequeze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Na' bedajlegu'e̱ tu benne' biu lau Le̱', zaj zua zri ni'a ne̱'e̱, zaj naxrúe̱' benne' na' tu lu ta'a blaga'. Gate ble'e Jesús ca dxeléajle̱'e̱ chee̱', na' gunné̱', dxe̱'e̱ benne' we̱': ―Be̱n dipa lazru', zrí'ina'dau'. Dul-la chiu' dxunite lawa'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nadxa bal-la benne' dxuluxuzájle̱'e̱ da nadxixruj bea Dios gulenné̱' lu xichaj lázrdawe̱': “Benne' nigá dxucá'ana dítaje̱' Dios nen xrtizre̱'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Lawe' da neze Jesús ca gulenné̱' lu xichaj lázrdawe̱', na' dxe̱'e̱ benne' ca', gunné̱': ―¿Bizr chee̱ na' dxennale caní lu xichaj lázrdaule? ");
INSERT INTO zatNTps_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Bízrala da quebe nácadxa ste̱be guna'? ¿Nnia': “Dul-la chiu' ba bnite lawa'”, u che nnia': “Bexasa, guzá?” ");
INSERT INTO zatNTps_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Chee̱ le̱ na' gulé'eda' le'e neda', Benne' Gulje̱' Bénneache, napa' xel-la' dxenná bea lu xe̱zr la xu nigá gunite lawa' dul-la. Nadxa dxe̱'e̱ benne' zaj zua zri ni'a ne̱'e̱, gunné̱': ―Bexasa. Becá'a ta'a chiu'. Bexíaj lizru'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Bénnea' zaj zua zri ni'a ne̱'e̱ bexase̱', na' zexíajte̱' lizre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Gate belelé'e bénneache da nigá, na' belezrebe̱', ne belúe lá'ane̱' Dios lawe' ba bnézruje̱' xel-la' waca caní chee̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ca bezá Jesús na', na' blé'ene̱' tu benne' biu le̱' Mateo, dxe'e̱ lataj naga dxuchízruje̱' waláz chee̱ xe̱zre Roma, na' dxe̱'e̱ le̱', gunné̱': 6 ―Be̱n neda' tuze. Nadxa Mateo nigá guxase̱' zéajle̱ne̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Gate na' dxe' Jesús dxawe̱' xeta lizre Mateo nigá, benne' zante̱ wechizruj, ne benne' dul-la belezrine̱', ne gulebé'queze̱' dxelawe̱' cuita Jesús, ne benne' ca' dxusé̱dene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Benne' xudau' fariseo ca', gate belelé'ene̱' da nigá, dxelé̱'e̱ benne' ca' dxuse̱de Jesús, gulenné̱': ―¿Bizr chee̱ na' Benne' dxusédene̱' le'e dxágule̱ne̱' benne' wechizruj ca', ne benne' we̱n da zrinnaj ca'? ");
INSERT INTO zatNTps_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús benne̱' da nigá, na' dxe̱'e̱ benne' ca', gunné̱': ―Quebe dxelechine benne' chawe' nu benne' dxexune̱' bénneache. Benne' we̱' dxelechínene̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Le chjaca, le cheajse̱de ca da dxenná da naxúaj na lu xiche chee̱ Dios, dxenné̱': “Neda' dxaca lazra' xexache lázrele le sa' ljwézrele, quegá gútele be̱ xíxre'du ca' lu cugu chia'.” Bla' neda', quegá chee̱ guláwizra' benne' xrlátaje. Dxuláwizra' benne' dul-la chee̱ xelexebí'i lazre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nadxa belezrín lau Jesús benne' ca' dxeledále̱ne̱' Juan, bénnea' dxuchúe̱' bénneache nisa, na' gulenábene̱' Le̱': ―¿Bizr chee̱ na' quebe dxelún gubasa benne' dxusé̱denu' Lue', ca dxuntu' netu', ne ca dxelún benne' xudau' fariseo ca'? Tu dxúnzquezentu' gubasa. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Na' Jesús dxe̱'e̱ benne' ca', gunné̱': ―¿Ájala chee̱ na' xelezúa ba xácheze benne' zaj zue̱' laní chee̱ wechaga na' dxácate̱ zua benne' wechaga na' nen le̱'? Wazrín zra gate dua benne' wechaga na'. Nadxa xelúnqueze̱' gubasa. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Quegá nu dxudá tu ladxe' cube le̱'e̱ tu zra lánadxu gula, lawe' da gate cheajxedxé' da cube na', ne xrube xu na da gula na', na' dxézadxa da gula na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Cá'anqueze quebe nu benne' que̱'e̱ xrise uva wal-la cube lu bzude xide gula lawe' da che ca'an gune̱', gate cue' chi'i xrise uva wal-la, na' dxeza bzude xide na', na' xelebía xi' xrise uva wal-la na', ne bzude xide na'. Chee̱ le̱ na' dxal-la' ca'adxu xrise uva wal-la cube lu bzude xide cube. Che ca'an gundxu, xelegá'ana chawe' dxúpate̱ na. Bchalaj Jesús da caní ca naca chee̱ benne' ca' dxelezí' lu ne̱'e̱ xrtizre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Dxácate̱ na' dxuchalaj Jesús da nigá, na' bzrin tu benne' xíchaje̱ chee̱ benne' judío ca', na' bzu zribe̱' lau Jesús, dxenné̱': ―Bi nu'ula chia' za gútete̱be'. Che Lue' xidu' ne guzé̱ na'u le̱be', wexaca banbe'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Na' guxasa Jesús, guxíajle̱ne̱' le̱' nen benne' ca' dxusé̱dene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nadxa bzrin tu nu'ula we̱' cúzrula Jesús, ba naca chazrinnu iza dxé'ene̱' tu we̱' dxaque dxen, na' xeajté̱'e̱ zra lana Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Dxenné̱' lu xichaj lázrdawe̱': “Che cheajtaza' zra lane̱', na' xexaca'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús guxéchaje̱', guné̱'e̱ nu'ula', na' dxe̱'e̱ le̱': ―Be̱n dipa lazru', zrí'ina'dau'. Bache bexacu' lawe' da dxéajle̱'u chia'. La bexácate̱ nu'ula na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Gate na' bzrin Jesús lizre benne' xíchaje̱ chee̱ benne' judío ca', na' blé'ene̱' zaj zra' benne' wil-la xulucache̱' bi nu'ula na', ne benne' zaj zre̱'e̱ dxelune̱' zralaj. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Gunná Jesús, dxe̱'e̱ benne' ca': ―Le xedxúaj nigá. Quegá nate bi nú'uladau' nigá. Dxásezebe'. Na' buluzrizre̱' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Gudé bebéaje̱' benne' ca', na' guxú'u Jesús, ne bé̱xrue̱' na' bi nu'ula na', na' guxásabe'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Du ca naca xe̱zre ca' bzriluj dizra' chee̱ da be̱n Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ca bedxúaj Jesús na', na' chupa benne' xjaque̱' cuzru Le̱', dxelenné̱' zizraj: ―Bexache lazre' netu', Lue', Zri'ine David. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ca guxú'u Jesús lu xu'u naga zúaqueze̱', na' benne' la chul-la caní gulebigue̱' lau Le̱', na' Jesús guzre̱' benne' ca': ―¿Dxéajle̱le wazéqueda' xexuna' le'e? Na' gulé̱'e̱ Le̱': ―Awe', Xran. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nadxa Jesús gudane̱' xiaj lau benne' ca', dxenné̱': ―Gaca chee̱le ca dxéajle̱le. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Belexaca xiaj lawe̱'. Nadxa Jesús gunné̱ xuene̱' benne' ca', gunné̱': ―Le guxúe xanne' chee̱ quebe nu neze da nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Gate beledxúaje̱', na' buluchálaje̱' du ca naca xe̱zre ca' ca da be̱n Jesús chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ca bezá' Jesús nen benne' ca', na' belezrín bal-la benne' zaj naché̱'e̱ tu benne' biu quebe dxaca nnie̱', benne' xu'e̱ be' xriwe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Cáte̱ze bebéaj Jesús be' xriwe̱' nigá, na' benne' quebe dxaca nnie̱' bezú lawe̱' dxuchálaje̱'. Na' benne' ca' belexebánele̱'e̱, dxelenné̱': ―Cabata' ne lé'edxu gaca caní ládujla benne' Israel ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Benne' xudau' fariseo ca' gulenné̱': ―Benne' nigá dxebéaje̱' be' xriwe̱', dxuchínene̱' xel-la' waca chee̱ da xriwe̱', da na' dxenná be'e na be' xriwe̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Gudé Jesús tu tu xe̱zre zren, ne tu tu xé̱zredau', dxusé̱dene̱' benne' ca' lu xu'u ca' naga dxulucá'ana szrene̱' Dios tu tu lataj ca'. Gulu'e̱ lban chee̱ dizra' chawe' ca nna bea Dios, ne bexunte̱' bénneache zaj nape̱' tu tu cue' xízrawe̱' ca da dxelezaque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Gate ble'e Jesús bénneache ca', na' bexache lazre̱' le̱' lawe' da zaj zre̱'e̱ xácheze̱', ne dxelecuán lazre̱'. Zaj naque̱' ca zrila' ca' quebe zua benne' guxúe̱'-ba'. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nadxa guzre̱' benne' ca' dxusé̱dene̱': ―Da li, da zrente̱ de̱ da lápadxu, na' bábaze benne' we̱n zrin zaj zre̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Chee̱ le̱ na' le naba lau Xrana lina nigá, sel-le̱' benne' we̱n zrin xelelape̱' lina chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nadxa Jesús bláwizre̱' chazrinnu benne' ca' dxusé̱dene̱', na' bnézruje̱' le̱' xel-la' dxenná bea chee̱ xelexebéaje̱' be' xriwe̱' ca', ne chee̱ xelexexune̱' bénneache zaj xu'e̱ tu tu cue' xízrawe̱' ca da dxelezaque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Caní zaj le̱ chazrinnu benne' gubáz ca' chee̱ Jesús: Benne' nedxu le̱' Simón, ne lé̱queze̱' Pedro. Xetúe̱' naque̱' benne' biche Pedro, le̱' Andrés. Xechupe̱' zaj le̱' Jacobo, ne Juan, benne' zaj naque̱' zri'ine Zebedeo. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Xezícala benne' ca' zaj le̱' Felipe, ne Bartolomé, ne Tomás. Xetue̱' le̱' Mateo, benne' wechizruj chee̱ xe̱zre. Xetue̱' le̱' Jacobo, zri'ine Alfeo. Xetue̱' le̱' Lebeo, benne' lé̱queze̱' Tadeo. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Xetúe̱' le̱' Simón, benne' dxe'e̱ gunne xue chee̱ xe̱zr la xu Israel. Xetúe̱' le̱' Judas Iscariote, bénnea' gudée̱' Jesús lu na' benne' dxeledábague̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nadxa gusel-la Jesús benne' chazrinnu caní. Guzre̱' le̱': ―Quebe cheajle naga zaj zra' benne' quebe zaj naque̱' judío, ne quebe chu'ule xe̱zre ca' zaj nababa Samaria. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Le chjaca naga zaj zra' benne' Israel zaj naque̱' ca zrila' zaj naníteba'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Le chjaca cu'ule lban, xe̱le bénneache ba bzrin gáguze zra nna bea Dios lu xe̱zr la xu nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Le xexún benne' zaj xu'e̱ we̱' guzru', ne benne' bila xízrawe̱' dxelé'ene̱'. Le gusebán benne' gate. Le xebéaj be' xriwe̱' da zaj xu'u bénneache. Cá'aze guzile xel-la' dxenná bea nigá, na' cá'aze le guchine na, quebe bi sile. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Quebe gúale dumí oro, ne dumí plata, ne dumí lase. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Quebe gúale xixruj xeta da gágule la neza. Quebe gúale xetú cue' zra lánale, ne zrélale, ne xaga da gúxrule. Benne' we̱n zrin wazrúequeze̱' da gawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Gate na' zrinle le'e tu xe̱zre zren u tu xé̱zredau', le quilaj na' tu benne' du lazre', na' le xegá'ana lizre̱' ca zrindxa zra xeza'ale na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Gate na' chu'ule lu xu'u na', le xe̱ bénnea' naca lizre̱' na': “Xela dxebeza zri lazre' suale̱ na le'e.” ");
INSERT INTO zatNTps_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Che benne' ca' zaj naca chee̱' xelezí'e̱ xel-la' ba lá'ana caní, le gucá'ana cá'aze na. Che quebe zaj naca chee̱' xelezí'e̱ da nigá, na' quebe gata' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Che quebe lataj dxelune̱' le'e, ne quebe dxelenne̱' chee̱le, le xedxúaj lu xu'u na' u lu xe̱zre na', na' le xebibe bxrtedu na' zria ní'ale. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Da li dxapa' le'e, ca zrin zra guchi'a Dios, Dios gundxe̱' da ba xa' chee̱ benne' xe̱zre na' quez ca da gune̱' chee̱ benne' Sodoma, ne benne' Gomorra, xe̱zre ca' guzría xi'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Na' gunná Jesús: ―Le na' xque nigá. Neda' dxesel-la' le'e, gácale ca zrila' zaj zraba' ládujla becu' xi'a ca'. Chee̱ le̱ na', le gaca sina ca zaj naca be̱la', san le gaca dxexruj lazre' ca zaj naca bgúgudu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Le guxúe cuínale. Zaj zra' benne' xuludée̱' le'e lu na' benne' xu'u lawe', ne xuluzálaje̱' le'e lu xu'u naga dxulucá'ana szrene̱' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Cá'anqueze weleché̱'e̱ le'e lau benne' xu'u lawe' ca', ne lau benne' dxelenná bea lawe' da nácale chia' neda'. Ca'an gaca guchálajle ca naca chia' neda' lau benne' ca', ne lau benne' quebe zaj naque̱' judío. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Gate na' xuludée̱' le'e lu na' benne' dxuchi'a da dxaca, quebe gunne xue cue'le ca da nnale u ájala guchálajle, lawe' da gate zrin zra guchálajle, Dios gunne̱' ca da guchálajle. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Quegá le'eze guchálajle, lawe' da Be' Lá'azxa chee̱ Dios guchálaje̱' lu dxú'ale. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Xuludé bénneache benne' bíchequeze̱' lu na' benne' xelútie̱' le̱'. Cá'anqueze xra xrna xuludée̱' zrí'ine̱', na' zrí'ine̱' ca' xeledábagabe' xra xrnáquezebe' chee̱ xelátie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Xúgute̱ bénneache xelezré̱'e̱ le'e lawe' da nácale chia' neda', san bénnea' guxru chache̱' dizra' chee̱ Dios ca zrin zra cheajsé̱ chee̱', la bénnea'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Gate xelebé nawe̱' le'e tu xe̱zre, le xuzrunnuj xetú xe̱zre. Da li neda', Benne' Gulje̱' Bénneache, dxapa' le'e, xida' nédxula ca quebe ne tache tale xúgute̱ xe̱zre chee̱ benne' Israel. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Netú benne' quebe naque̱' szrendxa ca benne' dxusé̱dene̱' le̱'. Cá'anqueze netú benne' we̱n zrin quebe naque̱' szrendxa ca xrane̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tu benne' dxuse̱de dxal-la' gun zi' lazre̱' gaque̱' ca naca benne' dxusé̱dene̱' le̱', na' benne' we̱n zrin dxal-la' gun zi' lazre̱' gaque̱' ca naca xrane̱'. Che benne' naque̱' xrane xu'u dxelé̱'e̱ le̱' Beelzebú, da xriwe̱', chezradxa xelenné̱' chee̱ bi chee̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Na' gunná Jesús: ―Chee̱ le̱ na', quebe zrébele bénneache. Xúgute̱ da bagácheze gaca béaqueze na, na' xúgute̱ da dxelaca ga nagache gulé'e láuqueze na. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Da nigá dxapa' le'e lu da chul-la, le guchalaj na te zra. Da dxapa' le'e bagácheze, le nne̱ zizraj chee̱ xelén xúgute̱ benne'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Quebe zrébele benne' xelútie̱' be̱l-la' dxen chee̱le. Quebe xelezéquene̱' xelútie̱' bénne'du xu'ule. Le zrebe Dios. Le̱' dxezéquene̱' guzría xi'e̱ be̱l-la' dxen chee̱le, ne bénne'du xu'ule lu lataj ba xa'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Dxelúti'e̱ chupa bxínnedu ca' nen tu dumídau'. Netuba' quebe gáteba' chee̱ quebe ne güe lataj Xrale. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Cá'anqueze xicha xíchajle, xúgute̱ na zaj nababa na. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Chee̱ le̱ na', quebe zrébele. Zácadxale le'e quézcala be̱ zan bxínnedu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Na' gunná Jesús: ―Xúgute̱ benne' ca' dxelexeche̱be̱' zaj naque̱' chia' neda' lau bénneache, cá'anqueze neda' weché̱bequeza' zaj naque̱' chia' neda' lau Xra' zue̱' xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Benne' ca' quebe dxelexeche̱be̱' zaj naque̱' chia' lau bénneache, néda'queza' québequeze xeche̱ba' zaj naque̱' chia' lau Xra' zue̱' xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Na' gunná Jesús: ―Quebe guéquele bla'a neda' chee̱ guzúa' xel-la' dxebeza zri lazre' ládujla bénneache. Bla'a neda', quegá chee̱ guzúa' xel-la' dxebeza zri lazre', san chee̱ guzúa' wedil-la. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Bla'a neda' chee̱ guna' tábaga' tu benne' xre̱', ne chee̱ guna' tábaga' tu bi nu'ula xrnabe', ne chee̱ guna' tábaga' tu zru'a lizre̱' tau zrí'ine̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ca'an gaca, tu tu benne' tíl-lale̱ xrtía ljwezre̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Che tu benne' nazrí'idxene̱' xra xrne̱'e̱ quezca neda', quebe naca chee̱' gaque̱' chia', na' che nazrí'idxene̱' bi chee̱' ca' quezca neda', quebe naca chee̱' gaque̱' chia'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Che tu benne' quebe gun cuine̱' ca tu benne' zéajte̱'e̱ le̱'e̱ xaga béguaj, ne gune̱' neda' tuze, quebe naca chee̱' gaque̱' chia'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Benne' dxaca lazre̱' gapa chi'e̱ xel-la' nabán chee̱' gunitie̱' na. Bénnea' zúatequeze gudée̱' xel-la' nabán chee̱' ne̱ chia' neda', guselé̱' xel-la' nabán chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Na' gunná Jesús: ―Che tu benne' gape̱' le'e ba lá'ana, néda'queze gape̱' ba lá'ana, na' bénnea' dxape̱' neda' ba lá'ana, dxápaqueze̱' ba lá'ana Dios, Bénnea' gusel-le̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Che tu benne' gape̱' ba lá'ana tu benne' dxuchalaje̱' waláz chee̱ Dios lawe' da ze̱'e̱ waláz chee̱ Dios, benne' nigá wazí'queze̱' tuze ca da si' bénnea' dxuchálaje̱' waláz chee̱ Dios. Na' che tu benne' gape̱' ba lá'ana tu benne' xrlátaje lawe' da naque̱' benne' xrlátaje, benne' nigá wazí'queze̱' tuze ca da si' benne' xrlátaje na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nútete̱ze benne' gunézruje̱' tu zriga' nisa zaga da xi'aj tu bidu caní lawe' da naque̱' chia' neda', da líqueze wazi'e̱ da gunezruj Dios le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Gate bexuzre Jesús bchálajle̱ne̱' bénneache, na' bchálajle̱ne̱' chazrinnu benne' ca' dxusé̱dene̱'. Bezé̱'e̱ na' chee̱ cheajsédene̱', ne cheajchálaje̱' lban xúgute̱ xe̱zre ca' lu xe̱zr la xu na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan, bénnea' bchue̱' bénneache nisa, xu'e̱ lizre xia, na' benne̱' ca naca da dxun Cristo. Nadxa gusel-le̱' chupa benne' ca' dxeledále̱ne̱' le̱' lau Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Benne' chupe̱' caní buluche̱be̱' Jesús: ―¿Nacu' Lue' Cristo, Bénnea' dxal-la' xide̱', u che dxal-la' cuézantu' xelá' xetú benne'? ");
INSERT INTO zatNTps_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Na' beche̱be Jesús: ―Le chjaca cheajé̱zrele Juan da caní dxelé'ele, ne da dxenle. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Le xe̱'e̱ ca dxaca, dxelexelé'e benne' gulaque̱' la chul-la. Dxelexedá benne' gulezúa zri ni'a ne̱'e̱. Belexexaca benne' gulezaque̱' we̱' guzru', ne belexexaca ban benne' ca' gulatie̱'. Benne' xache' ca' dxelenne̱' dizra' chawe' chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ba neza zrente̱ naca na chee̱ bénnea' quebe xucuán lazre̱' sále̱ne̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ca besí'aca benne' chupa ca', na' guzú lau Jesús dxuchálajle̱ne̱' benne' zaj zre̱'e̱ na' ca naca chee̱ Juan. Dxenné̱': ―¿Bizra xeajnna'le le'e le̱'e̱ xixre' na'? ¿Xeajnna'le tu xia da dxuxrize be'? ");
INSERT INTO zatNTps_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Che cabí, ¿bizra xeajnna'le na'? ¿Xeajnna'le tu benne' nacue̱' zra lane̱' da zaca? Nézquezle benne' ca' zaj nácue̱' ladxe' zaca, lizre benne' dxelenná be'e̱ zaj zra' benne' caní. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Bízraqueze xeajnna'le? ¿Xeajnna'le tu benne' dxuchálaje̱' waláz chee̱ Dios? Awe'. Ca'an guca. Bénnea' ble'ele na' nácadxe̱' blau ca tu benne' dxuchálaje̱' waláz chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Lu xiche chee̱ Dios naxúaj na ca naca chee̱ Juan na'. Dxenná na: Neda' dxesel-la' benne' gubáz chia' nédxula ca Lue', chee̱ gucueze̱' neza naga teu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Da li dxapa' le'e, ládujla xúgute̱ bénneache quebe nu chilá' benne' nácadxe̱' blau ca naca Juan, bénnea' bchue̱' bénneache nisa. Naga dxenná bea Dios, bénnea' nácadxe̱' benne' dxexruj lazre' nácadxe̱' blau ca naca Juan na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Ca lu zra bla' Juan, bénnea' bchue̱' bénneache nisa, bzrinte̱ na'a zra, zaj zra' benne' dxelune̱' zi' lazre' xelu'e̱ naga dxenná bea Dios xabáa, na' benne' dxelune̱' zi' lazre' dxelezrué'ene̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ca da bzuaj Moisés lu xiche chee̱ da nadxixruj bea na, ne ca gulenná xúgute̱ benne' buluchálaje̱' waláz chee̱ Dios, dxuchalaj na ca naca chee̱ xel-la' dxenná bea chee̱ Dios, bzrinte̱ ca bla' Juan na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Che le'e dxaca lázrele chéajle̱le da nigá, Juan na' naque̱' Elías, bénnea' bchálaje̱' waláz chee̱ Dios gate nate, na' dxal-la' xelé̱'e̱ chee̱ guchálaje̱' waláz chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Che zua nágale, le xen da nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Ájazra zaj naca benne' zaj zre̱'e̱ na'a zra? Zaj naque̱' ca bidu ca' dxelebé'ebe' dxelítajbe' lawe' xi'a, ne dxelenne̱be' zizraj, dxelé̱ ljwézrebe' ca': ");
INSERT INTO zatNTps_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Bcuézrentu' bchiuj san quebe bxá'ale le'e. Bil-la xáchentu' san quebe gudxézrele.” ");
INSERT INTO zatNTps_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Caní zaj naque̱' lawe' da bla' Juan, quebe dxawe̱', ne quebe dxí'aje̱' da zaca, na' le'e dxennale xu'e̱ be' xriwe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nadxa bla' neda', Benne' Gulje̱' Bénneache, dxawa', ne dxí'aja', na' dxennale naca' neda' benne' wagu xrata, ne benne' dxi'aj, ne ljwezre benne' dul-la, ne benne' wechizruj chee̱ Roma. Naca bea nu benne' nape̱' xel-la' sina chee̱ Dios ne̱ chee̱ da dxun bénnea'. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nadxa guzú lau Jesús dxedil-le̱' bénneache chee̱ xe̱zre ca' naga be̱ne̱' xel-la' waca ca' chee̱ xabáa, lawe' da quebe belexebí'i lazre' benne' zaj zre̱'e̱ na'. Na' gunné̱': ");
INSERT INTO zatNTps_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Baxache' nácale le'e zrale xe̱zre Corazín. Baxache' nácale le'e zrale xe̱zre Betsaida. Caní nácale lawe' da checa' la ba guca lu xe̱zre Tiro, ne lu xe̱zre Sidón ca naca xel-la' waca ca' chee̱ xabáa ca da gulaca ládujla le'e, da zrente̱ ba zeaj gulácue̱' zra lane̱' tuzruj, ne gulegú'e̱ de xíchaje̱' da zaj naca bea na belexebí'i lazre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Neda' dxapa' le'e, lu zra guchi'a Dios, gundxe̱' da ba xa' chee̱le quez ca da ba xa' gune̱' chee̱ benne' Tiro, ne benne' Sidón. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Le'e zrale xe̱zre Capernaum, ¿dxéquele Dios wechise̱' le'e xabáa? Dios gudée̱' le'e lataj ba xa'. Caní gaca na lawe' da checa' la ba guca lu xe̱zre Sodoma ca naca xel-la' waca ca' chee̱ xabáa ca da gulaca ládujla le'e, nagá'anate̱queze xe̱zre na' lu zra na'a zra. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Neda' dxapa' le'e, lu zra guchi'a Dios, gundxe̱' da ba xa' chee̱le quez ca gune̱' da ba xa' chee̱ benne' Sodoma ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ca lu zra na' gunná Jesús: ―Dxue lá'ana' Lue', Xrae, nacu' Xrana xabáa, ne Xrana xe̱zr la xu nigá. Dxue lá'ana' Lue' lawe' da bcácheu' da caní lau benne' sina ca', ne lau benne' dxeléajni'ine̱', san blé'enu' na bidu caní. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ca'an naca, Xrae, lawe' da naca na ca dxaca lazru' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Xra' ba bdee̱' lu na'a xúgute̱ da caní. Quegá nu benne' núnbe'e̱ neda', Zri'ine Dios, san Xra' Dios núnbe'e̱ neda'. Quegá nu benne' núnbe'e̱ Xra', san neda', Zri'ine Dios, núnbe'a Le̱', ne zaj núnbea benne' ca' Le̱', benne' ca' dxaca lazra' gulé'eda' le̱' ca naca Xra'. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Le da naga zua', xúgute̱le le'e dxeajxréquele lu zrin dxunle chee̱ xudau', ne ca naca xua da núale, na' neda' guna' xezí' lázrele. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Le gunna lataj xrua' le'e ca nu benne' xrue̱' be̱zre xugu' chee̱ba', ne le guse̱de chia' lawe' da naca' dxexruj lazre', ne dxe'ene lazre', na' wazrué'ele xezí' lázrele lu bénne'du xu'ule. ");
INSERT INTO zatNTps_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Da na' naca na ca xugu' chee̱ be̱zre da xrua' le'e québete̱ ca naca na ste̱be chee̱ gúale na, na' xua da xrua' le'e naca na zraze. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ca lu zra na' xu'u Jesús neza zéaje̱' ládujla naga de̱ xel-la' zrua' xtila, ne naca zra dxulupá'ana benne' judío. Dxeledún benne' ca' dxuse̱de Jesús, na' gulezú lawe̱' dxelálaje̱' dau naga zria zrua' xtila, ne dxelawe̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Gate belelé'e benne' xudau' fariseo ca' da caní, na' gulé̱'e̱ Jesús: ―Guná' xque ca dxelún benne' ca' dxusé̱denu', dxelune̱' zrin da quebe naca chee̱' xelune̱' lu zra dxupá'anadxu. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús guzre̱' benne' ca': ―¿Quebe ne gulábale le'e ca be̱n David gate na' le̱', ne benne' ljwezre̱' ca' guledune̱'? ");
INSERT INTO zatNTps_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Guxú'e̱ lu xu'u chee̱ Dios, ne gulawe̱' xeta xtila lá'azxa, da quebe zaj naca chee̱' xelawe̱', le̱', ne benne' ljwezre̱' ca', san tuze bxruze ca' zaj naca chee̱' xelawe̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Quebe ne gulábale da naxúaj na lu da bdxixruj be'e Moisés ca dxelún bxruze ca' lu xudau', dxelune̱' zrin chee̱ xudau' lu zra dxupá'anadxu, ne quebe zaj nabague̱' zria? ");
INSERT INTO zatNTps_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Neda' dxapa' le'e, de̱ tu da naca blaudxa ca xudau' nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","¿Quebe ne chéajni'ile ca zéaje̱ da naxúaj na lu xiche chee̱ Dios? Dxenná na: Neda' dxaca lazra' xexache lázrele le sa' ljwézrele, ne quegá gútele be̱ xíxre'du ca' lu cugu chia'. La ba guxéajni'ile da nigá, quebe ne guzría xile bénneache quebe zaj nabague̱' dul-la. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Chee̱ le̱ na', neda', Benne' Gulje̱' Bénneache, napa' xel-la' dxenná bea dxuna' zrin chia' lu zra dxupá'anadxu. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nadxa Jesús bezé̱'e̱ na', na' guxú'e̱ tu lu xu'u naga dxelúe lá'ane̱' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Zua tu benne' zua zri ne̱'e̱ ga na'. Benne' judío ca' gulaca lazre̱' xelezrelne̱' ájala xelune̱' chee̱ gaca xelagu zrie̱' chee̱ Jesús. Chee̱ le̱ na' gulenábene̱' Le̱': ―¿Dxunna Dios lataj xexundxu benne' we̱' lu zra dxupá'anadxu? ");
INSERT INTO zatNTps_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús guzre̱' benne' ca': ―Nútete̱ze benne' zue̱' ládujla le'e, che zua tu zrila' chee̱', ne che bíxreba' tu xe̱dxu situj lu zra dxupá'anadxu, ¿quebe chéaje̱' cheajxeléaje̱'-ba' xca'? ");
INSERT INTO zatNTps_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Da zrendxa zaca tu benne' quez ca tu zrila'. Ca'an naca dxunna Dios lataj gundxu tu da xrlátaje lu zra dxupá'anadxu. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nadxa Jesús guzre̱' benne' we̱' na': ―Bli na'u. Ca blí ne̱'e̱, na' bexaca na ca ne̱'e̱ xetú. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nadxa beledxúaj benne' xudau' fariseo ca', ne gulezú lawe̱' dxelílaje̱' ájala xelune̱' xelútie̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Gate gúquebe'e Jesús da nigá, na' bezé̱'e̱ na', na' benne' zante̱ zjácale̱ne̱' Le̱'. Bexún Jesús xúgute̱ benne' we̱' zaj zre̱'e̱ ládujla benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jesús gunné̱ xúene̱' benne' ca' quebe nu xululé'ene̱' nu naca Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Caní guca ca da gunná Isaías, benne' bchálaje̱' waláz chee̱ Dios, gunné̱': ");
INSERT INTO zatNTps_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Benne' nigá naque̱' we̱n zrin chia', benne' ba gucá'a. Benne' nigá nazrí'ida', ne dxezaca ba lázrele̱na' Le̱'. Guzúaqueza' xichaj lázrdawe̱' Be' Lá'azxa chia'. Guzenne̱' bénneache xúgute̱ xe̱zr la xu ca dxuchi'a da dxaca. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Quebe tíl-lale̱queze̱' bénneache, ne quebe cuézrexe̱'e̱. Netú benne' quebe xenne̱' chi'e̱ la neza. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Quebe quichje̱' tu xia da ba nachaj, ne quebe xusul-le̱' xi' da ba dxaca wexul-la na, ca zrindxa zra xuzúe̱' xel-la' dxenná bea chawe' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Bénneache xúgute̱ xe̱zr la xu xuluxrén lázrequeze̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nadxa guleché̱'e̱ lau Jesús tu benne' la chul-la, benne' quebe dxaca nnie̱', lawe' da xu'e̱ be' xriwe̱'. Jesús bexune̱' benne' nigá, na' belé'ene̱', ne benníe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Xúgute̱ benne' ca' belexebánene̱', gulenné̱': ―¿Naca benne' nigá Zri'ine David zra? ");
INSERT INTO zatNTps_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Gate belén benne' xudau' fariseo da nigá, na' gulenné̱': ―Benne' nigá dxebéaje̱' be' xriwe̱', dxuchínene̱' xel-la' dxenná bea chee̱ Beelzebú, xrane be' xriwe̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Dxeque be'e Jesús ca da dxelenné̱', dxelé̱'e̱ ljwezre̱', na' guzre̱' le̱': ―Lu xu'u lawe' chee̱ gátete̱ze xe̱zre, che xelaca chupa la'a benne' xu'u lawe' ca', ne bal-le̱' xeledíl-lale̱ne̱' xezícadxe̱', na' wexul-la wenite xel-la' dxenná bea chee̱ benne' ca'. Cá'anqueze che tu xe̱zre benne', u tu cue' xrtía ljwezre xelaque̱' chupa la'a, ne xeledíl-lale̱ne̱' le sa' ljwezre̱', wenítequeze xe̱zre na', u xrtía ljwezre ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Cá'anqueze, che Satanás, da xriwe̱', dxebéaje na ljwezre da xriwe̱', le̱ze na dxexún na chupa la'a cuina na. ¿Ájazra gácaqueze nna bea na? ");
INSERT INTO zatNTps_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Le'e dxennale chia' dxebéaja' be' xriwe̱' ca', dxuchíneda' xel-la' dxenná bea chee̱ Beelzebú da xriwe̱'. Che naca na ca', ¿Nuzra dxúnnaqueze xel-la' dxenná bea chee̱ benne' ca' zaj naca le'e tuze chee̱ xelebéaje̱' be' xriwe̱' ca'? Chee̱ le̱ na' lé̱queze̱' dxululé'ete̱ne̱' nanéguele le'e. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Che neda' dxebéaja' be' xriwe̱' ca' dxuchíneda' xel-la' waca chee̱ Be' Lá'azxa chee̱ Dios, da nigá dxunna bea na ba bla' xel-la' dxenná bea chee̱ Dios ládujla le'e. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Ájazra gun tu benne' chu'e̱ lizre tu benne' wal-la chee̱ que̱'e̱ da de̱ chee̱' che nédxula quebe guchéaje̱' ni'a na' bénnea'? Che gune̱' caní, na' wazéquene̱' que̱'e̱ da de̱ chee̱ bénnea'. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Nu benne' quebe dxácale̱ne̱' neda', dxedábague̱' neda', na' benne' quebe dxexezígale̱ne̱' neda', dxexúsie̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Chee̱ le̱ na' dxapa' le'e, gunite lau Dios chee̱ bénneache xúgute̱ dul-la zaj nabague̱', ne xúgute̱ da cale̱la da dxelenné̱', san che xelenné̱' schanni' chee̱ Be' Lá'azxa, cabata' gunite lau Dios chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nútete̱ze benne', che bi nnie̱' schanní' chia' neda', Benne' Gulje̱' Bénneache, Dios gunite lawe̱' chee̱', san che tu benne' nnie̱' schanni' chee̱ Be' Lá'azxa, québequeze gunite lau Dios chee̱' lu xe̱zr la xu nigá ne cá'anqueze lu xe̱zr la xu da za za'. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Na' gunná Jesús: ―Che naca chawe' tu xaga, dxebía na da zixre chawe', na' che naca tu xaga bize, dxebía na da zixre bize. Ca'an naca, tu xaga naca bea na ne̱ chee̱ da zixre da dxebía na. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Le'e, be̱ snia ca'. ¿Ájazra gunle le'e nne̱le da xrlátaje che le'e nácaquezle benne' we̱n da cale̱la xca'? Ca da dxedxuaj dxú'adxu naca na ca da zua na lu xichaj lázrdaudxu. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Benne' xrlátaje dxenné̱' da naca xrlátaje lawe' da zua da xrlátaje lu xichaj lázrdawe̱', na' benne' we̱n da cale̱la dxenné̱' da cale̱la lawe' da zua da cale̱la lu xichaj lázrdawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Neda' dxapa' le'e, lu zra guchi'a Dios, xúgute̱ bénneache xuludée̱' ca da gulenné̱', tu tu dizra' xala da gulenné̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ca naca dizra' da ba gunníu', Dios guchi'e̱ chiu', na' Le̱' nnáqueze̱' che xedxúaju' xrlátaje, u che webagu' zria. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nadxa bal-la benne' xudau' fariseo, ne benne' dxuluxuzájle̱'e̱ da nadxixruj bea Dios gulé̱'e̱ Jesús: ―Benne' Wese̱de, dxaca lázrentu' le'entu' chiu' gunu' tu xel-la' waca da za xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Na' guzre Jesús benne' ca': ―Bénneache we̱n da cale̱la, benne' zaj naque̱' chupa lazre', dxelenábene̱' neda' guna' tu xel-la' waca da za xabáa. Quebe xelelé'equezne̱' tu xel-la' waca, san tuze ca da dxunna bea na ca da guca chee̱ Jonás, benne' bchálaje̱' waláz chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ca guca chee̱ Jonás, guxú'e̱ lu le̱'e̱ bela zren chunna zra chunna xe̱la, cá'anqueze gaca chia' neda', Benne' Gulje̱' Bénneache, waxú'uqueza' lu xe̱dxu ba chunna zra chunna xe̱la. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Benne' gulezré̱'e̱ xe̱zre Nínive welexásaqueze̱' lu zra guchi'a Dios gate guchi'e̱ chee̱ bénneache zaj zre̱'e̱ na'a, na' benne' Nínive ca' xululé'ene̱' zaj nabaga zria benne' caní lawe' da belexebí'i lazre' benne' Nínive gate na' bchalaj Jonás dizra' chee̱ Dios lau benne' ca', na' blaudxa ca Jonás na' naca Benne' zue̱' nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Cá'anqueze nu'ula na' gunná be'e̱ chalá'a naga dxedá gubizra beu' zaga ca' wexásaqueze̱' lu zra guchi'a Dios gate guchi'e̱ chee̱ bénneache zaj zre̱'e̱ na'a, na' nu'ula na' gulé'ene̱' zaj nabaga zria benne' caní lawe' da bezé̱'e̱ naga naca zítu'te̱ chee̱ xe̱zr la xu nigá chee̱ xenne̱' dizra' sina da bchalaj Salomón, na' blaudxa ca Salomón na' naca Benne' zue̱' nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Na' gunná Jesús: ―Gate tu be' xriwe̱' dxedxuaj na tu benne', na' dxedá na lataj naga nabizre, dxexilaj na naga xezí' lazre' na, na' che quebe xezrele na, na' dxenná na lu xichaj lázrdau na: ");
INSERT INTO zatNTps_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Webi'a xexá'a lizra' naga bedxúaja'.” Ca xezrín na, le'e na benne' na', naque̱' ca tu xu'u da naxíajlbe̱ lu'ule na, ne nalúa na, ne nagá'ana chawe na. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nadxa cheaj na cheajxezrí na xegazre be' xriwe̱' da zaj naca na xríwe̱dxa ca le̱ na, na' xúgute̱ na dxelú'u na lu bénnea', na' naca chee̱ benne' na' da calé̱ladxa ca guca chee̱' nedxu. Cá'anqueze gaca chee̱ bénneache we̱n da cale̱la caní. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús ne zue̱' dxuchálajle̱ne̱' benne' caní gate belezrín xrne̱'e̱ ne benne' biche̱' ca' ga na'. Gulezré̱'e̱ chalé'ajla, ne dxelaca lazre̱' xuluchálajle̱ne̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nadxa tu benne' guzre̱' Jesús: ―Xrna'u, ne bi bichu' ca' zaj zre̱'e̱ chalé'ajla. Dxelaca lazre̱' xuluchálajle̱ne̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesús guzre̱' benne' nigá: ―¿Núnbeale nuzra na' xrna'a, ne bi bícha'dau' ca'? ");
INSERT INTO zatNTps_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nadxa ble'e Jesús benne' ca' dxusé̱dene̱', dxenné̱': ―Benne' caní zaj naque̱' xrna'a, ne bi bícha'dau' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Caní naca na lawe' da nútete̱ze benne' dxune̱' ca da dxaca lazre' Xra' zue̱' xabáa, benne' nigá naque̱' benne' bicha', ne benne' zana', ne xrna'a. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Lu zra na' bdxuaj Jesús xu'u, na' xeajdxé'e̱ dxu'a nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Na' lawe' da belezraga benne' zante̱ naga zua Jesús, guxú'e̱ tu lu da dxedá lawe' nísadau', ne gudxé'e̱ na'. Xúgute̱ benne' ca' belexegá'ane̱' dxu'a nísadau' na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nadxa bse̱de Jesús benne' ca' da zante̱ da bchálaje̱', dxenné̱': ―Tu benne' dxaza guzé̱'e̱ zíaje̱' guza. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Dxácate̱ dxaze̱', bal-la bínnedu ca' xeajlechaze na dxu'a neza. Na' belelá' bxínnedu ca', guláguba' bínnedu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Bal-la bínnedu ca' xeajlechaze na lu xiaj naga quebe dxé'teca xu. Bínnedu caní chadí gulezría na lawe' da quebe dxé'teca xu. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Gate bla' gubizra, na' gulecuade na. Lawe' da quebe dxé'teca xu, na' gulebizre na. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Bal-la bínnedu ca' xeajlechaze na naga bezríale̱'e̱ lba xeche', na' lba xeche' ca' belegula na, ne blule na da du ca' naze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Bal-la bínnedu ca' xeajlechaze na lu xu be̱be, na' belúnnale̱'e̱ na. Bal-la xágadu ca' belunna na tu gaxúa tu tu na, na' xebal-la na belunna na ga xun tu tu na, na' xebal-la na belunna na chi dxua tu tu na. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Che zua nágale, le xene. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nadxa benne' ca' dxuse̱de Jesús gulebigue̱' naga zue̱' Le̱', ne buluche̱be̱' Le̱': ―¿Bizr chee̱ na' dxuchálajle̱nu' benne' ca' da dxululé'e na? ");
INSERT INTO zatNTps_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Beche̱be Jesús, dxenné̱': ―Dios dxunne̱' lataj nézele le'e da nagache ca dxenná bea Le̱' xabáa, san benne' caní quebe dxu'e̱ lataj. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Benne' nape̱' late', Dios gunézrujdxe̱' le̱', na' gápale̱'e̱, san benne' quebe bi nape̱', Dios wequé̱'e̱ ca da du nape̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Chee̱ le̱ na' dxuchálajle̱na' benne' caní da dxululé'e na, lawe' da cate' dxelenné̱'e̱ quebe dxelelé'ene̱'. Cate' dxelenne̱' quebe dxeléajni'ine̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ca naca da dxaca chee̱ benne' caní dxaca na ca gunná Isaías, bénnea' bchálaje̱' waláz chee̱ Dios, gunné̱': Da li wenle. Cate' dxenle quebe dxéajni'ile. Da li wanná'le. Cate' dxenna'le quebe dxelé'ele. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Caní naca na lawe' da zaj naca lázrdau zide' benne' caní. Quebe dxelaca lazre̱' xelenne̱'. Dxulugácue̱' xiaj lawe̱' chee̱ quebe xelelé'ene̱'. Quebe dxelenne̱', na' quebe dxeléajni'ine̱'. Quebe dxelexílaje̱' neda' chee̱ xexuna' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Ba neza zrente̱ naca na chee̱le le'e lawe' da dxelé'ele nen xiaj laule, ne dxenle nen nágale. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Da li dxapa' le'e, benne' zante̱, benne' ca' buluchálaje̱' waláz chee̱ Dios, ne benne' xrlátaje ca' gulaca lazre̱' xelelé'ene̱' da caní dxelé'ele le'e. Quebe belelé'ene̱' na. Gulaca lazre̱' xelenne̱' da caní dxénnele le'e. Quebe belenne̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Na' gunná Jesús: ―Le xenne ca zéaje̱ da naca chee̱ benne' dxaza nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Benne' dxelenne̱' ca naca chee̱ Bénnea' dxenná be'e̱ xabáa, ne quebe dxeléajni'ine̱' zaj naque̱' ca bínnedu ca' xeajlechaze na dxu'a neza. Za da xriwe̱' ne dxugúa na ca naca dizra' da ba gulezí'e̱ lu xichaj lázrdawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ca naca chee̱ bínnedu ca' xeajlechaze na lu xiaj, da caní dxululé'e na ca naca chee̱ benne' ca' dxelezi'e̱ dizra' na' du lazre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ca na' guca chee̱ bínnedu ca', quebe guca xuludé lue na, ne quebe guzí bea na, ca'an dxaca chee̱ benne' caní, gate na' bi da dxelezaque̱', u che nu zeajnáu zi' xuzre̱' le̱' lawe' da zaj nazi'e̱ dizra' nigá, na' dxelexebigue̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Bínnedu ca' xeajlechaze na ládujla xeche' dxululé'e na ca naca chee̱ benne' dxelenne̱' dizra' nigá, san dxelebé'le̱'e̱ gunne xue da naca chee̱ xe̱zr la xu nigá, na' ca naca xel-la' gunní'a dxezí xe̱ na benne' ca'. Xúgute̱ da caní dxuluzaga na dizra' nigá, na' quebe dxun na da dxal-la' gun dizra' nigá lu xichaj lázrdawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ca naca chee̱ bínnedu ca' da xeajlechaze na lu xu be̱be, da caní dxululé'e na ca naca chee̱ benne' ca' dxelenne̱' dizra' nigá, ne dxeléajni'ine̱' na, na' zaj naque̱' ca bínnedu ca' belúnnale̱'e̱ na. Bal-la benne' zaj naque̱' ca bínnedu ca' belunna na tu gaxúa tu tu na, na' xebal-le̱' zaj naque̱' ca bínnedu ca' belunna na ga xun tu tu na, na' xebal-le̱' zaj naque̱' ca bínnedu ca' belunna na chi dxua tu tu na. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nadxa bchalaj Jesús xetú da dxulé'e na, dxenné̱': ―Ca dxaca ga ni dxenná bea Dios naca na ca da guca gate tu benne' guze̱' binne cháwe'dau' lu xe̱zr la xu chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Gate dxelase xúgute̱', na' bzrin tu benne' dxezré̱'e̱ le̱', ne xeajaze̱' binne xixre' zrinnaj láwela zrua' xtila, na' bezé̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Gate na' bgula xel-la' zrua' xtila, ne bla' dau chee̱ na, cá'anqueze bla' xixre' zrinnaj ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nadxa benne' we̱n zrin ca' xeajlegue̱zre̱' xrane na, dxelé̱'e̱ le̱': “Xran, guzu' binne cháwe'dau' lu xe̱zr la xu chiu'. ¿Gazra guzá xixre' zrinnaj caní?” ");
INSERT INTO zatNTps_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Gunná xránabe': “Tu benne' dxezré̱'e̱ neda' be̱ne̱' da nigá.” Nadxa benne' we̱n zrin ca' buluche̱be̱' le̱': “¿Dxaca lazru' chéajntu' cheajlé̱pentu' xixre' zrinnaj ca'?” ");
INSERT INTO zatNTps_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Le̱' guzre̱' we̱n zrin ca': “Quebe gaca na. Gate na' lázrule xixre' zrinnaj ca', walázrute̱le xel-la' zrua' xtila. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Xelegúladxa na cháwe'la tu zren ca xecá'adxadxu zrua' xtila. Nadxa nna be'eda' benne' we̱n zrin ca' xelequé̱'e̱ nedxu xixre' zrinnaj ca', na' xuluchéaje̱' xelune̱' tu xrúnujdu weaj chee̱ guzézxedxu na. Nadxa xelelape̱' zrua' xtila na', ne xezrá chawe' na lizra'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nadxa bchalaj Jesús xetú da dxulé'e na, dxenné̱': ―Da dxaca chee̱ benne' dxelezí' lu ne̱'e̱ nna be'e Dios le̱' naca na ca da guca gate tu benne' guze̱' binne mostaza lu xe̱zr la xu chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Da li binne mostaza nigá naca na da bízrujdxa lawe' xúgute̱ binne ca'. Gate ba nagula na naca na tu xaga zrendxa lawe' xúgute̱ xixre' cuan. Dxaca na ca tu xaga zren naga dxelezeque' cheajlezría bxínnedu ca' xrú'uneba' lu zruze na. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nadxa bchalaj Jesús xetú da dxulé'e na, dxenné̱': ―Da dxaca chee̱ benne' dxelezí' lu ne̱'e̱ nna be'e Dios le̱' naca na ca da guca gate tu nu'ula bchixre cua zichaj chee̱ xeta xtila lawe' chunna xaga cua zrua' xtila, na' dute̱ na guxasa na bliche. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Xúgute̱ da caní bchálajle̱ Jesús benne' ca', dxuchálaje̱' da dxululé'e na, na' quebe bchálajle̱ne̱' benne' ca' che quebe bchálaje̱' da dxululé'e na. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Caní guca ca da gunná benne' bchálaje̱' waláz chee̱ Dios, gunné̱': Guchálaja' ca naca da dxulé'e na da guchálaja'. Gulé'eda' ca naca da nagache gate guzrete̱ xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nadxa Jesús bze̱' benne' ca' dizra', na' guxú'e̱ lu xu'u. Benne' ca' dxuse̱de Jesús gulebigue̱' lau Le̱', na' gulé̱'e̱ Le̱': ―Bzéajni'i netu' da dxulé'e na ca naca chee̱ xixre' zrinnaj da dxenná'queze na ca dxenná' xel-la' zrua' xtila. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nadxa Jesús guzre̱' benne' ca': ―Bénnea' dxaze̱' binne cháwe'dau' nigá naque̱' Benne' Gulje̱' Bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Naga dxaze̱' binne nigá naca na lu xichaj lázrdau bénneache. Binne cháwe'du ca' zaj naca benne' ca' dxenná be'e Dios, na' xixre' zrinnaj ca' zaj naca na benne' ca' zaj naque̱' chee̱ da xriwe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Bénnea' dxezré̱'e̱ xrane xe̱zr la xu na', ne xeajaze̱' xixre' zrinnaj naque̱' da xriwe̱' ná'queze. Zra xelelape̱' naca na zra bze̱be chee̱ xe̱zr la xu nigá, na' benne' ca' xelelape̱' zrua' xtila na' zaj naque̱' gubáz chee̱ xabáa chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ca belexequé̱'e̱ xixre' zrinnaj ca', ne buluzré̱'e̱ na lu xi' chee̱ xelezxe na, ca'an gácaqueze lu zra bze̱be na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Neda', Benne' Gulje̱' Bénneache, sel-la' gubáz chee̱ xabáa chia' ca' chee̱ xulucuase̱' naga nna be'a xúgute̱ benne' ca' dxuluxrínnajte̱' benne' xula, ne benne' ca' dxelune̱' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nadxa gubáz chee̱ xabáa ca' xuluzré̱'e̱ benne' ca' dxelune̱' da cale̱la lu xi' gabila naga xelebezre̱', ne xeláguxa'ate̱ lazxe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nadxa benne' ca' dxelune̱' da xrlátaje ca da dxenná be'e Dios xelácaqueze̱' ca gubizra naga dxenná bea Dios, Xra benne' ca'. Che le'e zua nágale, le xene. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Na' gunná Jesús: ―Naga dxenná bea Dios naca na ca tu xel-la' gunní'a da nagache na tu lu xe̱zr la xu. Tu benne' bezrélene̱' xel-la' gunní'a nigá, na' bucache̱' na. Ne zúale̱'e̱ xel-la' dxebé zexíaje̱' xeajxé̱tie̱' xúgute̱ da nape̱', na' bezi'e̱ xe̱zr la xu na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Na' gunná Jesús: ―Naga dxenná bea Dios naca na ca tu da dxexilaj tu benne' we̱te, dxexílaje̱' bga ca' da zaj zaca na. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Gate dxezrélene̱' tu da zácale̱'e̱, na' zexíaje̱' zeajxé̱tie̱' xúgute̱ da nape̱', na' si'e̱ bga na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Na' gunná Jesús: ―Ca naca chee̱ benne' ca' xelexú'e̱ naga dxenná bea Dios, naca na ca tu xixruj bela, da dxuluzale̱' lu nísadau', na' dxelezene̱' zane' cue' bela. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Gate dxezrá xixruj na', na' benne' ca' dxelezene̱' bela dxelexequé̱'e̱ na dxu'a nísadau', na' dxelebé'e̱ dxelexebée̱' bela ca'. Bela chawe' ca' dxuluxuzré̱'e̱-ba' lu xcuite, na' bela xala ca' dxeledxú'une̱'-ba'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ca'an gaca lu zra bze̱be na'. Xeledxúaj gubáz chee̱ xabáa ca', xelexebéaje̱' benne' ca' dxelune̱' da cale̱la ládujla benne' xrlátaje ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Xuluzré̱'e̱ benne' ca' dxelune̱' da cale̱la lu xi' gabila, naga xelebezre̱', ne xeláguxa'ate̱ lazxe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nadxa bche̱be Jesús benne' ca', dxenné̱': ―¿Dxéajni'ile le'e xúgute̱ da caní? Benne' ca' gulenné̱': ―Awe', Xran. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nadxa guzre̱' benne' ca': ―Gate tu benne' dxusé̱dene̱' da nadxixruj bea Dios, ne nazé̱dene̱' ca dxenná bea Dios, naque̱' ca tu benne' xrane xu'u nézene̱' cuéaje̱' da zaj naca na da cube, ne da zaj naca na da gula ládujla da nuzrá chawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Gate bexuzre bchalaj Jesús da dxulé'e na caní, na' bezé̱'e̱ na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Bezrine̱' naga naca lazrie̱'. Na' guzú lawe̱' dxusé̱dene̱' benne' ca' zaj zre̱'e̱ lu xudau' chee̱ xe̱zre na', na' belexebanne benne' ca', gulenné̱': ―¿Gazra bse̱de benne' nigá xel-la' sina nigá? ¿Ájazra dxune̱' xel-la' waca caní? ");
INSERT INTO zatNTps_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Benne' nigá naque̱' zri'ine gubizre xaga, na' naca xrne̱'e̱ María. Naque̱' bi biche Jacobo, ne José, ne Simón, ne Judas. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Bi zane̱' zaj zue̱' nigá nen dxi'u. ¿Ájazra na' dxaca dxune̱' da caní? ");
INSERT INTO zatNTps_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Chee̱ le̱ na' buluzúe̱' Jesús chalá'ala. Jesús guzre̱' benne' ca': ―Xúgute̱ benne' xula dxelape̱' ba lá'ana tu benne' dxuchálaje̱' waláz chee̱ Dios. Benne' lazrie̱', ne xrtia ljwezre̱' quebe dxelúne̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jesús quebe bé̱nteque̱' na' xel-la' waca ca' lawe' da quebe guléajle̱'e̱ chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Lu zra na' Herodes, benne' dxenná be'e̱ xe̱zre ca' zaj nababa na Galilea, benne̱' ca naca da dxun Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Na' guzre̱' bi we̱n zrin chee̱' ca': ―Benne' nigá naque̱' Juan, bénnea' bchue̱' bénneache nisa. Ba bebane̱' ládujla benne' gate. Chee̱ le̱ na' nape̱' xel-la' waca zren nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Caní gunné̱' lawe' da gude̱la Herodes nigá Juan na', ne bchéaje̱' le̱' du xia, ne gulu'e̱ le̱' lizre xia. Be̱ne̱' caní ne̱ chee̱ Herodías, zru'ula Felipe, biche Herodes na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Caní be̱ne̱' lawe' da guzre Juan le̱': ―Quebe naca chiu' súale̱nu' nu'ula nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes guca lazre̱' gutie̱' le̱', san dxezrebe̱' da xelún bénneache ca' lawe' da dxeléquene̱' naca Juan benne' dxuchálaje̱' waláz chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Gate bzrin zra dxezría iza Herodes, na' belune̱' laní chee̱', na' bxa'a bi nu'ula chee̱ Herodías na', na' bezaca ba lazre' Herodes na' da dxunbe'. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Chee̱ le̱ na' Herodes guche̱be lazre̱' lau benne' ca' gunézruje̱' ca da naba bi nú'uladu na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Lawe' da ba guzre xrnabe' le̱be', na' gunabe': ―Be̱nna nigá xichaj Juan, bénnea' bchue̱' bénneache nisa. Gulú'u na tu lu xé'ena. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nadxa guzúa ste̱be Herodes, bénnea' dxenná be'e̱, san lawe' da ba guche̱be lazre̱', na' benne' zaj zre̱'e̱ dxágule̱ne̱' le̱' belenne̱' ca', chee̱ le̱ na' guzre̱' tu benne' we̱n zrin chee̱' gunézruje̱' na le̱be'. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Gunná bé'ene̱' nu benne' guchugue̱' xichaj Juan naga xu'e̱ lizre xia. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nadxa xeajlexrí'e̱ xíchaje̱' tu lu xé'ena, ne bulunézruje̱' na bi nú'uladu na', na' le̱be' bnézrujbe' na xrnabe'. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nadxa belezrín benne' ca' bse̱de Juan, na' belexú'e̱ le̱', ne xeajlecache̱' le̱'. Nadxa xjaque̱' xeajlegue̱zre̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Gate ben Jesús da na', na' bezé̱'e̱ na', bexu'e̱ tu lu da dxedá lawe' nísadau', na' bzrine̱' tu naga quebe nu zra' benne'. Gate belén bénneache, na' gusiá'que̱' ni'e̱, na' belezrine̱' naga zua Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Gate bedxúaj Jesús lu da dxedá lawe' nísadau', na' blé'ene̱' benne' zante̱, ne bexache lazre̱' le̱', na' bexune̱' benne' ca' quebe chawe' zaj zue̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Gate ba za xrinne, benne' ca' dxuse̱de Jesús gulebigue̱' lau Le̱', dxelenné̱': ―Lataj nigá quebe bi de̱, ne ba dxedé zra. Bze̱ benne' caní dizra' chee̱ chjaque̱' xé̱zredu ca', ne xelezí'e̱ da xelawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús guzre̱' le̱': ―Quebe dxun na ba xen chjaque̱'. Le gunezruj le'e da xelawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Benne' ca' gulé̱'e̱ Le̱': ―Gázxuze xeta xtila de̱ chee̱dxu nigá, ne chúpaze bela. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús guzre̱' benne' ca': ―Le gunna na nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nadxa gunná bé'ene̱' gulebé' benne' zan ca' lawe' zrie̱. Guqué̱'e̱ xeta xtila, ne bela ca', na' gunné̱'e̱ xabaala, ne guzre̱' Dios: “Xcalenu'.” Nadxa bzúzruje̱' xeta xtila, ne bnézruje̱' na benne' ca' dxusé̱dene̱', na' benne' ca' gulísie̱' na láwela benne' zan ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Xúgute̱' gulawe̱', ne gulélajene̱'. Ca gudé na' bulusuzré̱'e̱ chazrinnu ga' da bízrujdu ca' zaj nagá'ana. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Benne' gulawe̱' na zaj naque̱' chi xun gaxúa benne' biu, ne quebe nu blaba nu'ula, ne bidu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nadxa gunná be'e Jesús benne' ca' dxusé̱dene̱' xelu'e̱ lu da dxedá lawe' nísadau' chee̱ xelague̱' nísadau' nédxudxa ca Le̱' chee̱ xelexezrine̱' xéchala'a nísadau' na', dxácate̱ Le̱' dxuzé̱ benne' zan ca' dizra'. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ca gudé bze̱' dizra' benne' zan ca', na' guluéne̱' tu lu xi'a xeajchálajle̱ne̱' Dios naga zue̱' tuze̱'. Gate guxrinne zua Jesús tuze̱' na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Dxácate̱ na' ba zeaj da na' dxedá lawe' nísadau' gachaj láwe'te̱ nísadau' na'. Nadxa guxasa xeajxruza chee̱ nísadau' na', da dxutá na da dxedá lawe' nísadau' na', lawe' da dxácale̱'e̱ be', ne quebe dxue na lataj sa na. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Gate gudé dxe̱la gubiga Jesús naga zaj zre̱'e̱, zéaje̱' lawe' nisa. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Gate belelé'e benne' ca' dxedá Jesús lawe' nisa, na' belezrebe̱', na' lu xel-la' dxelezrebe gulebézrexe̱'e̱, gulenné̱': ―Da dxedá dxe̱la na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jesús guzre̱' benne' ca': ―Le gun dipa lázrele. Neda' nigá. Quebe zrébele. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Na' gunná Pedro, dxe̱'e̱ Jesús: ―Xran, che Lue' na', gunná be'e xida' lawe' nisa naga zu' na'te. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesús guzre̱' le̱': ―Gudá xca'. Nadxa Pedro bdxúaje̱' lu da dxedá lawe' nísadau', ne guzú lawe̱' dxezé̱'e̱ lawe' nisa chee̱ zrine̱' naga zua Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Gate dxeque be'ene̱' ca dxun be' na', na' bzrebe̱', ne guzú lau dxazie̱' lu nísadau' na'. Ca'an guca gudxezre xe̱'e̱, gunné̱': ―Xran, becá'a neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nadxa becá'a Jesús ne̱'e̱, ne guzre̱' le̱': ―Látega dxeajlí lazru' neda'. ¿Bizr chee̱ na' be̱n chupa lazru'? ");
INSERT INTO zatNTps_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Gate belexegüene̱' lu da dxedá lawe' nísadau', na' bebé' zri be' na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nadxa benne' ca' zaj zre̱'e̱ lu da dxedá lawe' nísadau' na' buluzú zribe̱' lau Jesús, dxelé̱'e̱ Le̱': ―Da li nacu' Zri'ine Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Guledée̱' xecha la'a nísadau', na' belezrine̱' lu xe̱zr la xu chee̱ benne' Genesaret ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Gate benne' ca' zaj zre̱'e̱ xe̱zre na' belexexúnbe'e̱ Jesús, na' buludée̱' dizra' xezícala xé̱zredu ca', na' guleché̱'e̱ xúgute̱ benne' we̱' naga zua Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Gulata' xuene̱' Jesús gu'e̱ lataj xulutá benne' ca' zra lane̱' naze. Xúgute̱ benne' buluté̱' zra lane̱' belexexaque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nadxa benne' fariseo ca', ne benne' dxuluxuzájle̱'e̱ da bdxixruj be'e Moisés, benne' ca' beledxuaje̱' lu xe̱zre Jerusalén, gulebigue̱' lau Jesús, na' buluche̱be̱' Le̱', dxelenné̱': ");
INSERT INTO zatNTps_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Bizr chee̱ na' benne' ca' dxusé̱denu' quebe dxuluzúe̱' dizra' ca naca da gulún xra xrtaudxu? Quebe dxelíbequeze ne̱'e̱ ca naca da zéajle̱ntu' gate dxelawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús bche̱be̱' benne' ca', gunné̱': ―¿Bizr chee̱ na' le'e quebe dxuzuale dizra' da dxenná be'e Dios? Dxunle ca naca da zéajle̱le. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dios gunné̱': “Gudapa ba lá'ana xra xrna'u.” Cá'anqueze gunné̱': “Benne' nne̱' schanni' chee̱ xra xrne̱'e̱, le gute bénnea'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Le'e dxennale waca xe̱ tu benne' xra xrne̱'e̱: “Quebe séqueda' bi gunna' le'e lawe' da ba guche̱be lazra' gunézruja' Dios xúgute̱ da de̱ chia'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Dxennale che tu benne' dxune̱' caní québedxa dxun na ba xen gácale̱ne̱' xra xrne̱'e̱. Caní dxunle le'e, dxuzuale chala'ala da bdxixruj be'e Dios, chee̱ gunle ca naca da zéajle̱le. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Le'e, láweze dxunle da xrlátaje. Da li naca da gunná Isaías, bénnea' bchálaje̱' waláz chee̱ Dios, ca naca chee̱le le'e, gunné̱': ");
INSERT INTO zatNTps_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Benne' caní dxelape̱' neda' ba lá'ana nen dxú'aze̱'. Quebe dxelape̱' neda' ba lá'ana dute̱ lázrdawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Dácheze naca dxelúe lá'ane̱' neda'. Da gulenná be'ene̱' bénneache naca na da ca' dxulusé̱dene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nadxa Jesús gunné̱' benne' ca', dxenné̱': ―Le xene, ne le chéajni'i. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Da dxu'u na dxu'a bénneache quegá le̱ na guxrinnaj na bénneache. Da dxedxuaj na dxu'a bénneache naca na da dxuxrinnaj na bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nadxa benne' ca' dxuse̱de Jesús gulebigue̱' lau Le̱'. Dxelé̱'e̱ Le̱': ―¿Nézenu' gulaca tula benne' xudau' fariseo ca' gate belenne̱' da gunnáu'? ");
INSERT INTO zatNTps_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesús guzre̱' benne' ca': ―Bítete̱ze xágadau' da quebe guza Xra' zue̱' xabáa, welé̱peda'. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Le gusán benne' ca'. La chul-la zaj naque̱', ne dxulusi'e̱ neza le sa' ljwezre̱' la chul-la ca'. Che tu la chul-la che̱'e̱ le sa' ljwezre̱' la chul-la, dxúpate̱' xelebixre̱' tu lu xe̱dxu. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nadxa Pedro guzre̱' Jesús: ―Bzéajni'i netu' ca naca chee̱ da dxulé'e nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Gunná Jesús: ―¿Cá'anqueze le'e quebe dxéajni'ile? ");
INSERT INTO zatNTps_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Quebe nézele xúgute̱ da dxu'u na dxú'adxu zeaj na le̱'e̱dxu, na' te na' xedxuaj na? ");
INSERT INTO zatNTps_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Da dxedxuaj na dxú'adxu naca na da za' lu xichaj lázrdaudxu. Da nigá naca na da dxuxrinnaj na bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Lu xichaj lázrdau bénneache dxeledxuaj da dxezá lazre̱' da cale̱la, ca naca xel-la' we̱te benne', ne ca naca xel-la' zuale̱ zru'ula benne' xula, ne ca naca da sban da dxelún bénneache, ne ca naca xel-la' gubán, ne xel-la' we̱n lazre', ne xel-la' wetupa dizra' bizruj. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Da caní dxuluxrinnaj na bénneache. Che tu benne' quebe dxexibe ne̱'e̱ ca da zéajle̱le gate dxawe̱' xeta, da nigá quebe dxuxrinnaj na le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nadxa bedxuaj Jesús na', zexíaje̱' chala'a naga zaj nababa xe̱zre Tiro, ne xe̱zre Sidón. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tu nu'ula Canaán zue̱' na' ze̱'e̱ dxebezre xe̱'e̱ cúzrela Jesús, dxenné̱': ―Xran, Zri'ine David, bexache lazre' neda'. Xu'ube' be' xriwe̱' zri'ina' nu'ula, ne cátitega dxezácabe'. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Quebe bi beche̱be Jesús. Nadxa belezrín benne' ca' dxusé̱dene̱', ne gulata' xuene̱' Le̱', gulé̱'e̱ Le̱': ―Bsel-la nu'ula nigá lawe' da ze̱'e̱ dxebezre xe̱'e̱ cúzrudxu. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nadxa gunná Jesús: ―Dios gusel-le̱' neda' gácale̱za' benne' Israel ca' zaj naque̱' ca zríla'du ca' zaj naníteba'. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Gubiga nu'ula na' naga zua Jesús, ne bzu zribe̱' lau Le̱', ne dxe̱'e̱ Le̱': ―Xran, gúcale̱ neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús guzre̱' le̱': ―Quebe naca xrlátaje cá'adxu da dxelagu zrí'inedxu, chee̱ gunézrujdxu na bécudu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nadxa nu'ula na' guzre̱' Jesús: ―Awe', Xran, san bécudu ca' dxeláguquezeba' da bízrujdu ca' dxelexruj zran naga dxelagu xránaba'. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nadxa Jesús guzre̱' le̱': ―Nú'uladu, da zrente̱ naca xel-la' dxeajlí lazre' chiu'. Gaca ca dxaca lazru'. Lu zra ná'queze bexaca zrí'ine̱' nú'uladu na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús guzé̱'e̱ na', gudée̱' dxu'a nísadau' chee̱ Galilea. Guluéne̱' tu lu xi'a, ne gudxé'e̱ na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Benne' zan belezrine̱' naga zua Jesús, zaj naché̱'e̱ benne' zrinnaj ca', ne benne' la chul-la ca', ne benne' quebe dxaca xelenné̱', ne benne' zan zaj nadxugu ni'a na', ne zánedxa benne' we̱'. Buluzré̱'e̱ benne' ca' lau Jesús, na' Le̱' bexune̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ca'an guca belexebane benne' ca' gate belelé'ene̱' dxelenné̱' benne' ca' quebe guca xelenné̱' nédxula, ne belexexaca benne' ca' gulaque̱' benne' ni'a na' dxugu, ne dxeledá benne' ca' gulaque̱' benne' zrinnaj, ne dxelelé'e benne' ca' gulaque̱' benne' la chul-la. Gulezú lawe̱' dxelúe lá'ane̱' Dios chee̱ benne' Israel ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nadxa Jesús gunné̱' benne' ca' dxusé̱dene̱'. Dxe̱'e̱ le̱': ―Dxexache lazra' chee̱ benne' caní lawe' da ba zeaj chunna zra zrále̱ne̱' neda' nigá, ne quebe bi de̱ da xelawe̱'. Quebe dxaca lazra' xesel-la' le̱' chee̱ cheajxaque̱' lizre̱' quebe ne xelawe̱' chee̱ quebe xelate ni'a ne̱'e̱ la neza. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nadxa benne' ca' dxuse̱de Jesús gulé̱'e̱ Le̱': ―¿Ájazra guntu' zrélentu' da xelagu cátite̱ benne' zan caní? Lataj nigá quebe nu chilá' benne' zua lizre̱' nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús bche̱be̱' benne' ca', dxenné̱': ―¿Bal-la xeta xtila nápale? Benne' ca' belexeche̱be̱': ―Gazre na, ne xetú chupa béladau'. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nadxa Jesús gunná bé'ene̱' benne' zan ca' xelebé'e̱ lu xu. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Guqué̱'e̱ da gazre xeta xtila, ne béladu ca', na' guzre̱' Dios: “Xcalenu'.” Nadxa bzúzruje̱' na, ne bnézruje̱' na benne' ca' dxusé̱dene̱', na' benne' ca' gulísie̱' na chee̱ benne' zan ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Xúgute̱' gulawe̱', ne belélajte̱ne̱'. Gudé na' bulusuzrate̱' gazre ga' da bízrujdu ca' zaj nagá'ana. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Benne' gulagu zaj naque̱' tapa cue' chi gaxúa benne' biu, ne quebe nu blaba nu'ula, ne bidu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Gudé na' Jesús bze̱' benne' zan ca' dizra', na' bexu'e̱ lu da dxedá lawe' nísadau' zexíaje̱' naga nababa xe̱zre Magdala. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Benne' xudau' fariseo ca', ne benne' xudau' saduceo ca' xjaque̱' naga zua Jesús chee̱ xuluxunéguene̱' Le̱'. Chee̱ le̱ na' gulenabe̱' Jesús gune̱' tu xel-la' waca zrente̱ da za xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesús beche̱be̱' benne' ca': ―Xelate' zua gubizra dxennale le'e: “Gun chawe' wxre lawe' da da' beuj xrna zran xabáa.” ");
INSERT INTO zatNTps_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Che zílala dxennale: “Quebe chawe' gun na'a zra lawe' da dá'le̱'e̱ beuj xrna zran xabáa.” Le'e dxulé'e cuínale da quebe nácale. Dxácaqueze dxennale ca naca da gun zran xabáa. Quebe dxaca xuzájla'ale ca sa'yeaj da dxaca na'a zra. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Benne' we̱n da cale̱la caní, benne' zaj nabéaj xíchaje̱' Dios, dxelenabe̱' guna' tu xel-la' waca zrente̱. Quebe xelelé'ene̱' xetú xel-la' waca. Welelé'ene̱' tuze da gaca na ca da guca chee̱ Jonás. Nadxa bulucá'ana Jesús benne' ca', zjá'aque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Gate benne' ca' dxuse̱de Jesús guladée̱' xechalá'a nísadau', na' gulal-la lazre̱' xelu'e̱ chizre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesús guzre̱' le̱': ―Le nna'xque. Le guxúe cuínale ca naca chee̱ cua zichaj chee̱ xeta xtila chee̱ benne' fariseo ca', ne chee̱ benne' saduceo ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Benne' ca' dxuse̱de Jesús gulezú lawe̱' dxelé̱ ljwezre̱': ―Caní dxenné̱' lawe' da quebe núadxu xeta xtila. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús dxeque be'ene̱', na' guzre̱' le̱': ―¿Bizr chee̱ na' dxennale naca na lawe' da quebe núale xeta xtila? Láteze dxéajle̱le chia'. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Quebe ne chéajni'ile, ne quebe dxeajsá lázrele chee̱ da gazxu' xeta xtila da bgawa' gazxu' cue' chi gaxúa benne' biu, ne bal-la ga' becá'ale? ");
INSERT INTO zatNTps_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Quebe dxeajsá lázrele chee̱ da gazre xeta xtila da bgawa' tapa cue' chi gaxúa benne' biu ca', ne bal-la ga' becá'ale? ");
INSERT INTO zatNTps_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ájazra na' quebe dxeque be'ele quegá bchálaja' chee̱ xeta xtila gate gunnía' le guxúe cuínale ca naca chee̱ cua zichaj chee̱ xeta xtila chee̱ benne' fariseo ca', ne chee̱ benne' saduceo ca'? ");
INSERT INTO zatNTps_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nadxa guleque bé'ene̱' quegá guzre Jesús le̱' xuluxúe cuine̱' chee̱ da naca cua zichaj chee̱ xeta xtila, san ca naca da dxuluse̱de benne' fariseo ca', ne benne' saduceo ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Gate bzrin Jesús naga nababa xe̱zre Cesarea da be̱n Filipo, na' bche̱be̱' benne' ca' dxusé̱dene̱': ―¿Nuzra na' dxelenná bénneache naca' neda', Benne' Gulje̱' Bénneache? ");
INSERT INTO zatNTps_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Na' benne' ca' gulenné̱': ―Bal-la benne' dxelenné̱' nacu' Juan, bénnea' bchue̱' bénneache nisa. Xebal-le̱' dxelenné̱' nacu' Elías, na' xebal-le̱' dxelennáqueze̱' nacu' Jeremías, u xetú benne' bchálaje̱' waláz chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nadxa guzre Jesús benne' ca': ―¿Gazra le'e? ¿Nuzra na' dxennale naca'? ");
INSERT INTO zatNTps_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Gunná Simón Pedro: ―Lue' nacu' Cristo, Zri'ine Dios ban. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Beche̱be Jesús: ―Ba neza zren naca na chiu' Simón, zri'ine Jonás. Netú benne' quebe ne gulé'ene̱' lue' da nigá, san Xra' zua xabáa, Le̱' blé'ene̱' lue'. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Neda' dxapa' lue', nacu' Pedro, da zéaje̱ na tu xiaj, na' lawe' xiaj xre nigá guzúa' benne' xeleajlí lazre̱' neda', na' xel-la' dxenná bea chee̱ da xriwe̱' quebe seque na gucu'uj na benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Neda' gunna' lue' da naca na zren xia chee̱ xel-la' dxenná bea chee̱ xabáa, na' da guchéaju' lue' lu xe̱zr la xu nigá gaca na da ba nadxéajqueze na xabáa, na' da xese̱zru' lue' lu xe̱zr la xu nigá gaca na da ba naxé̱zrequeze na xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nadxa Jesús gunná bé'ene̱' benne' ca' dxusé̱dene̱' chee̱ quebe nu xelé̱'e̱ naca Le̱' Cristo. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Lu zra ná'queze guzú lau Jesús dxuzéajni'ine̱' benne' ca' dxusé̱dene̱' dxal-la' xexíaje̱' xe̱zre Jerusalén, na' benne' gula ca', ne benne' xíchaje̱ ca' chee̱ bxruze ca', ne benne' dxuluxuzájle̱'e̱ da nadxixruj bea Dios wulusaca zi'e̱ Le̱'. Na' guzre̱' benne' ca' dxusé̱dene̱' welute benne' Jerusalén ca' Le̱'. Nadxa gate gaca chunna zra xebane̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nadxa Pedro guléaje̱' Jesús chalá'ala, ne guzú lawe̱' dxedil-le̱' Le̱', dxenné̱': ―Dios quebe gu'e̱ lataj, Xran. Cabata' gaca chiu' da caní. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesús bexéchaje̱', na' guzre̱' Pedro: ―Gucuasa cuita' neda', lue', da xriwe̱', lawe' da nacu' tu da dxusunegue na neda'. Quebe dxulaba lazru' ca dxun Dios. Ca dxun bénneache dxulaba lazru'. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nadxa Jesús guzre̱' benne' ca' dxusé̱dene̱': ―Che nu benne' dxaca lazre̱' gaque̱' neda' tuze, dxal-la' guzúe̱' chalá'ala da naca chee̱', ne guzúa cuine̱' chee̱ gatie̱', na' nadxa gaca xídale̱ne̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Bénnea' dxaca lazre̱' gapa chi'e̱ xel-la' nabán chee̱' gunitie̱' na. Bénnea' gunitie̱' xel-la' nabán chee̱' lawe' da dxune̱' zrin chia', benne' nigá zrué'ene̱' xel-la' nabán du lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Bízraqueze ba neza naca na chee̱ tu benne' che gata' chee̱' xúgute̱ xel-la' gunní'a da de̱ lu xe̱zr la xu nigá, na' cuía xi'e̱ lau Dios? Quebe bi gaca quizruj tu benne' chee̱ la bénne'du xu'e lau Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Neda', Benne' Gulje̱' Bénneache wida' xecha lasa nen xel-la' szren chee̱ Xra', ne nen gubáz chee̱ xabáa ca'. Nadxa xuzría chee̱ tu tu benne' ca naca da zaj nun tu tue̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Da li dxapa' le'e, bal-la benne' zaj zre̱'e̱ nigá quebe xelatie̱' cadxa xelelé'ene̱' neda', Benne' Gulje̱' Bénneache, xida' xedajnná be'a. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ca gudé guca xrupa zra, na' Jesús guché̱'e̱ Pedro, ne Jacobo, ne Juan, bi biche Jacobo, na' bi cá'aze xjácale̱ne̱' Le̱' tu lau xi'a sibe. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Na' Dios bche̱'e̱ ca dxenná' lau Jesús láwela benne' ca'. Lawe̱' guca tite na ca gubizra, na' zra lane̱' guca na da chiche ca xel-la' naxaní'. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Na' benne' caní belelé'ene̱' Moisés, ne Elías, benne' gulezrá' gate nate, dxuluchálajle̱ne̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nadxa Pedro guzre̱' Jesús: ―Xran, cháwe'le̱'e̱ zúadxu nigá. Che dxaca lazru', guntu' chunna xu'u lágadau', tu chiu', ne tu chee̱ Moisés, ne tu chee̱ Elías. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Dxácate̱ dxenné̱ Pedro, bla' tu beuj da dxaca tite na, da gucu na benne' ca', na' lu beuj na' belenne̱' chi'i Dios, dxenné̱': ―Benne' nigá naque̱' Zri'ina' nazrí'ite̱ lazra', ne chee̱ Le̱' dxezaca ba lazra'. Chee̱ Le̱' le xene. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Gate belenne̱' da nigá, na' gulate̱' sudxú'ala lu xu. Dxelezrébele̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nadxa Jesús gubigue̱' naga zaj zre̱'e̱, na' bte̱' benne' ca', ne guzre̱' le̱': ―Le chasa. Quebe zrébele. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Gate na' belenné̱'e̱, québedxa nu belelé'ene̱'. Tuze Jesús zue̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nadxa gate dxelexexétaje̱' lu xi'a na', Jesús gunná bé'ene̱' benne' ca', dxenné̱': ―Quebe nu guchálajle̱le ca da ble'ele ca zrindxa zra neda', Benne' Gulje̱' Bénneache, xebana' ládujla benne' gate. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nadxa benne' ca' dxuse̱de Jesús buluche̱be̱' Le̱': ―¿Bizr chee̱ na' dxelenná benne' ca' dxuluxuzájle̱'e̱ da nadxixruj bea Dios dxun na ba xen xelá' Elías nédxudxa ca xelá' Cristo? ");
INSERT INTO zatNTps_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús guzre̱' benne' ca': ―Da li xelá' Elías nédxudxa, ne gucá'ana chawe̱' ca naca da dxal-la' gaca. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Neda' dxapa' le'e, ba bla' Elías, na' benne' ca' quebe belexúnbe'e̱ le̱'. Bulusaque̱' le̱' cáte̱ze da gulaca lazre̱'. Cá'anqueze xulusaque̱' neda', Benne' Gulje̱' Bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nadxa benne' ca' dxuse̱de Jesús guléque be'ene̱' dxuchalaj Jesús ca naca chee̱ Juan, bénnea' bchue̱' bénneache nisa. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Gate belezrine̱' naga zaj zra' benne' zante̱, na' tu benne' gubigue̱' naga zua Jesús, ne bzu zribe̱' lau Le̱', dxenné̱': ");
INSERT INTO zatNTps_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Xran, bexache lazre' zri'ina', dxe'ebe' chuna', ne da zrente̱ da dxezácabe'. Zánete̱ lasa ba xeajcházebe' lu xi', ne lu nisa. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ba bedajgu'a-be' lau benne' caní dxusé̱denu', na' quebe guca xelexune̱'-be'. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús beche̱be̱': ―Le'e, benne' we̱n chupa lazre', ne benne' lázrdau zide'. ¿Bátate̱ zúale̱na' le'e? ¿Bátate̱ naca' zren lazre' nen le'e? Le cheajxrí' bi cuide' na' nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nadxa Jesús gudil-le̱' be' xriwe̱' na', na' bebéaje̱' na lu be̱l-la' dxen chee̱ bi cuide' na', na' zra ná'queze bexácate̱be'. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Gudé na' benne' ca' dxuse̱de Jesús gulenné̱' Le̱' chalá'ala, na' buluche̱be̱' Le̱': ―¿Bizr chee̱ na' quebe guca netu' xebéajntu' be' xriwe̱' na'? ");
INSERT INTO zatNTps_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús guzre̱' benne' ca': ―Lawe' da naca láteze ca dxéajle̱le chia'. Da li dxapa' le'e, che la nápale xel-la' dxeajlí lazre', lácala naca na láteze ca naca tu bínnedau' chee̱ mostaza, waca xe̱le xi'a nigá: “Gucuasa nigá chéaju' xetú lataj”, na' xi'a na' wacuasa na. Quebe bi de̱ da quebe gaca gunle che nápale xel-la' dxeajlí lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ca naca be' xriwe̱' caní, dxun na ba xen guchálajle̱le Dios, ne gunle gubasa chee̱ séquele xebéajle be' xriwe̱' caní. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Dxácate̱ na' dxeledé̱' naga nababa Galilea, Jesús guzre̱' benne' ca': ―Neda', Benne' Gulje̱' Bénneache wadéa' lu na' bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Xelútie̱' neda', na' gate gaca chunna zra, xebana'. Gate belenne̱' dizra' nigá, na' bewi'ine lázrele̱'e̱ne̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Gate Jesús ne benne' ca' dxusé̱dene̱' belezrine̱' lu xe̱zre Capernaum, na' benne' dxuluchízruje̱' chee̱ xudau' belezrine̱' lau Pedro, na' buluche̱be̱' le̱': ―¿Quebe dxizruj benne' dxusé̱dene̱' le'e chee̱ xudau'? ");
INSERT INTO zatNTps_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro beche̱be̱': ―Awe'. Dxízruje̱' na. Nadxa, gate na' guxú'u Pedro lu xu'u, guzre Jesús le̱': ―¿Aja dxéquenu', Simón? ¿Nuzra na' dxuluchizruj lazruj chee̱ xe̱zr la xu benne' ca' dxelenná bea lu xe̱zr la xu nigá? ¿Dxuluchízruje̱' benne' walázr chee̱', u benne' zitu' ca'? ");
INSERT INTO zatNTps_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Beche̱be Pedro: ―Benne' zitu' dxuluchízruje̱'. Jesús guzre̱' le̱': ―Na' benne' walázr chee̱' quebe xelízruje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Na'a, chee̱ quebe nu guchá'adxu, guxíaj lu nísadau' na', ne guchize da na' dxeláleu' bela lu nisa na', na' bebéaj bela nedxu que̱lu'-ba'. Dxú'aba' na' xezrelnu' tu dumí da quízruju' chiu' lue', ne chia' neda'. Bia na, ne xeajtizruj na lau benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tu lasa gulebiga benne' ca' dxuse̱de Jesús naga zue̱', na' buluche̱be̱' Le̱': ―¿Nuzra benne' nácadxe̱' blau naga dxenná bea Dios? ");
INSERT INTO zatNTps_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nadxa Jesús gunné̱' tu bidau', na' bze̱'-be' lau benne' ca' dxusé̱dene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Dxenné̱': ―Da li dxapa' le'e, che quebe xexácale ca bidu nigá, québequeze chu'ule naga dxenná bea Dios xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ca'an naca, benne' nácadxe̱' blau naga dxenná bea Dios xabáa, naca benne' gaque̱' dxexruj lazre', ne xexaque̱' ca bidu nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Benne' gape̱' ba lá'ana tu bidau' caní lu La' neda', néda'queza' gape̱' ba lá'ana. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Na' gunná Jesús: ―Nútete̱ze benne' gune̱' gun tu bidu caní dul-la, bi dxeajlí lázrebe' neda', cháwela guchéajladxu lbe̱'e̱ tu xiaj zi'i da dxutu, na' cheajchú'unadxu le̱' situj lu nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Edxugúa bénneache lawe' da dé̱le̱'e̱ da dxun na xelún bénneache dul-la. Tu gátazqueze da caní, na' edxugúa bénneache dxelune̱' xelún bénneache dul-la. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Chee̱ le̱ na', che na'u u ni'u dxun na gunu' dul-la, guchugu na, ne gudxú'una na zitu'. Cháwedxa xexú'u lu xel-la' nabán li lazre' nadxugu ni'u u na'u, quézcala xelegú'e̱ lue' lataj ba xa', zua dxúpate̱ na'u, ne dxúpate̱ ni'u. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Che xiaj lau' dxun na gunu' dul-la, guleaj na, ne gudxú'una na zitu'. Wenla chu'u lu xel-la' nabán li lazre' nen tuze xiaj lau', quézcala xelegú'e̱ lue' lu xi' gabila, zua dxúpate̱ xiaj lau'. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Na' gunná Jesús: ―Gutu guzú' chalá'ala netú bidu caní. Neda' dxapa' le'e, zaj zra' gubáz chee̱ xabáa chee̱ bidu caní lau Xra' xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Neda', Benne' Gulje̱' Bénneache, bla'a bedajselá' benne' zaj nanitie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Ájazra dxéquele le'e? Che tu benne' nape̱' tu gaxúa zrila', na' nite tuba', ¿quebe gucá'ane̱' be̱ tápalalaj che̱nnu na' le̱'e̱ xixre', na' cheajdilje̱' zrila' na' naníteba'? ");
INSERT INTO zatNTps_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Gate ba bezrelne̱'-ba', wabéle̱'e̱dxene̱' chee̱ be̱ tu na' quézcala chee̱ be̱ tápalalaj che̱nnu ca' quebe guleníteba'. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Cá'anqueze Xrale le'e, zue̱' xabáa, quebe dxaca lazre̱' nite netú bidu caní. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Na' gunná Jesús: ―Che bi bichu' dxunbe' chiu' da cale̱la, bchálajle̱ tuze le̱be', chee̱ xúnbeabe' da cale̱la da be̱nbe'. Che xenbe' da dxu'u-be', na' ba bexacu' tuze bi bichu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Che quebe xenbe' da dxu'u-be', guché̱' tu chupa benne' chee̱ gaca chupa u chunna benne' xelexeche̱be̱' ca naca da dxu'u-be'. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Che quebe xenbe' chee̱ benne' ca', guzre ca naca benne' dxelezraga lu xudau'. Che quebe xenbe' chee̱ benne' ca', le guzúa-be' ca tu benne' quebe dxéajle̱'e̱ chee̱ Dios, u ca tu benne' dxuchízruje̱' waláz chee̱ benne' zitu' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Da li dxapa' le'e, da guchéajle lu xe̱zr la xu nigá, naca na da ba nadxéajqueze na xabáa, ne da xesé̱zrele lu xe̱zr la xu nigá naca na da ba nazé̱zrequeze na xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Cá'anqueze dxapa' le'e, che chúpale le'e gácale tuze ca da nábale Dios, na' Xra' zua xabáa gunne̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Naga zaj zra' chúpabe', u chúnnabe' zaj nazrágabe' lu La' neda', na' zúaqueza' neda' laduj le̱be'. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nadxa Pedro bche̱be̱' Jesús: ―Xran, che bi bícha'dau' gunbe' chia' da cale̱la, ¿bal-la lasa dxun na ba xen gunite lawa' chee̱be'? ¿Gazre lasa? ");
INSERT INTO zatNTps_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Beche̱be Jesús: ―Dxapa' lue', quegá gazre lasa, san ga xun chi da gazre lasa. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Na' gunná Jesús: ―Da gaca naga dxenná bea Dios xabáa naca na ca da guca gate tu benne' dxenná bea guca lazre̱' gucá'ana chawe̱' da dxelal-la benne' we̱n zrin chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Gate guzú lawe̱' dxucá'ana chawe̱' na, na' guleché̱'e̱ lau le̱' tu benne' dxebague̱' chee̱' zane' cue' chi gaxúa dumí. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Lawe' da quebe de̱ chee̱ benne' we̱n zrin na' da quízruje̱' xrane̱', na' gunná be'e xrane̱' ta'u benne' we̱n zrin na', ne zru'ule̱', ne zrí'ine̱' ca', ne ca nácaqueze da nape̱', chee̱ gazruj da na' dxebague̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nadxa bzu zribe benne' we̱n zrin na' lau xrane̱', na' guta' xuene̱' le̱', dxenné̱': “Xran, be̱n zren lazre' neda', na' quízrujqueza' ca naca na.” ");
INSERT INTO zatNTps_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Na' xrane̱' bexache lazre̱' le̱', ne bnite lawe̱' da na' dxebague̱' chee̱', ne bsane̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Gate benne' we̱n zrin na' bedxúaje̱', na' bezrague̱' xetú benne' we̱n zrin ljwezre̱', benne' dxebague̱' chee̱' látedau'. Na' gude̱le̱' lba bénnea', ne guzú lawe̱' dxusézxuje̱' chi'i bénnea', dxe̱'e̱ le̱': “Gudizruj neda' da dxal-lu' chia'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nadxa benne' we̱n zrin ljwezre̱' na' bzu zribe̱' lau le̱', ne guta' xuene̱' le̱', dxenné̱': “Be̱n zren lazre' neda', na' quízrujqueza' ca naca na.” ");
INSERT INTO zatNTps_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Bénnea' quebe guca lazre̱', na' guxíaje̱' xeajlu'e̱ we̱n zrin ljwezre̱' na' lizre xia dxácate̱ quízruje̱' da na' dxebague̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Gate benne' we̱n zrin ca' xezícala guleque bé'ene̱' da nigá, na' belewí'ine lázrele̱'e̱ne̱', na' xjaque̱' xeajlegue̱zre̱' xrane̱' xúgute̱ da ba guca. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nadxa xrane̱' na' gunná bé'ene̱' xeajlenné̱' benne' we̱n zrin na', na' guzre̱' le̱': “Bi we̱n zrin cale̱la. Neda' bnite lawa' chiu' ca naca da na' dxebagu' chia' lawe' da guta' xúenu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Cá'anqueze lue' dxal-la' xexache lazru' le sa' ljwezru' na' ca be̱na' neda' bexache lazra' lue'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Xrane̱' na' bzrá'ale̱'e̱ bénnea', na' bdee̱' le̱' xel-la' zi' dxácate̱ na' quízruje̱' ca naca da na' dxal-le̱' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nadxa gunná Jesús: ―Cá'anqueze gun Xra' zua xabáa chee̱le le'e che quebe gunite laule dute̱ lázrdaule chee̱ le sa' ljwézrele. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ca gudé bchalaj Jesús da caní, na' bezé̱'e̱ xe̱zre ca' zaj nababa Galilea, na' bezrine̱' chalá'ala naga nababa Judea, da zua chalá'ala xe̱gu Jordán naga dxalaj gubizra. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Benne' zan zjácale̱ne̱' Le̱', na' bexune̱' benne' zante̱, benne' we̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nadxa bal-la benne' xudau' fariseo gulebigue̱' naga zua Jesús chee̱ xelebéaje̱' Le̱' dizra' chee̱ gaca xelagu zrie̱' Jesús, na' buluche̱be̱' Le̱': ―¿Waca nu benne' gusane̱' zru'ule̱' ne̱ chee̱ bítete̱ze da gune̱'? ");
INSERT INTO zatNTps_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Beche̱be Jesús: ―¿Quebe ne gulábale le'e lu xiche lá'azxa da na' dxenná na: “Bennea' be̱ne̱' benne' ca' nédxudaute̱ be̱ne̱' le̱' benne' biu, ne nu'ula”? ");
INSERT INTO zatNTps_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Cá'anqueze gunné̱': “Chee̱ le̱ na' benne' biu gusane̱' xra xrne̱'e̱ chee̱ gaque̱' tuze nen zru'ule̱', na' dxupe̱' xelaque̱' ca tuze benne'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Caní naca na, québedxa zaj naque̱' chupe̱', san tuze benne' zaj naque̱'. Chee̱ le̱ na' quebe dxal-la' xelá'a bénneache da na' ba nuchaga Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nadxa buluche̱be̱' Jesús: ―¿Bizr chee̱ na' gunná be'e Moisés nu benne' gunézruje̱' zru'ule̱' tu xiche da dxulé'e na belexelé̱'e̱, na' gusane̱' le̱'? ");
INSERT INTO zatNTps_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús guzre̱' benne' ca': ―Caní be̱ne̱' lawe' da gulaca lazrdau zizraj xra xrtaule. Moisés be̱nne̱' lataj gusanle zrú'ulale, san nédxudaute̱ quebe guca na ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Neda' dxapa' le'e, che tu benne' gusane̱' zru'ule̱', ne quebe dxedále̱ne̱' benne' biu xula, na' che xezúale̱ne̱' nu'ula xula, benne' nigá gune̱' dul-la súale̱ne̱' nu'ula quebe naque̱' zru'ule̱', na' che nu benne' biu xequé̱'e̱ tu nu'ula nusán benne' chee̱', cá'anqueze gun dul-la bénnea' súale̱ne̱' nu'ula quebe naque̱' zru'ule̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nadxa benne' ca' dxuse̱de Jesús gulé̱'e̱ Le̱': ―Che ca' dxaca chee̱ benne' zúale̱ne̱' nu'ula, quebe dxal-la' súale̱ntu' nu'ula. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús guzre̱' benne' ca': ―Quegá xúgute̱ benne' gaca xelezí'e̱ dizra' nigá, san tuze benne' ca' ba nun Dios chee̱' xelezí'e̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Zaj zra' benne' quebe dxelezúale̱ne̱' nu'ula lawe' da quebe zaj naca xánnie̱' benne' biu. Na' zaj zra' benne' québedxa zaj naca xánnie̱' benne' biu lawe' da zaj nun bénneache naca caní. Na' zaj zra' benne' dxelexegá'ane̱' cá'aze, quebe nu dxelezúale̱ne̱' chee̱ gaca xelune̱' zrin chee̱ Dios, Bénnea' dxenná be'e̱ xabáa. Benne' gaca si'e̱ dizra' nigá dxal-la' si'e̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nadxa belezrín benne' lau Jesús zaj naché̱'e̱ bal-la bidau' chee̱ guzé̱ ne̱'e̱ bidu ca', ne nabe̱' Dios gaca chawe' chee̱be', san benne' ca' dxuse̱de Jesús gulezú lawe̱' dxeledil-le̱' benne' ca' zaj naché̱'e̱ bidu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesús guzre̱' le̱': ―Le güe bidu ca' lataj xelela'be' naga zua'. Quebe guzrúnnale-be', lawe' da benne' zaj naque̱' ca bidu caní xelu'e̱ naga dxenná bea Dios xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nadxa bze̱ Jesús ne̱'e̱ lawe' bidu ca', na' gudé na' bezé̱'e̱ lataj na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tu benne' cuide' guxíaje̱' naga zua Jesús, na' bche̱be̱' Le̱': ―Benne' Wese̱de chawe'. ¿Bi da xrlátaje dxal-la' guna' chee̱ gapa' xel-la' nabán zeajlí canna? ");
INSERT INTO zatNTps_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús guzre̱' le̱': ―¿Bizr chee̱ na' dxu'u neda', benne' wese̱de chawe'? Quebe nu chilá' benne' naque̱' chawe', san tuze Dios. Che dxaca lazru' zrué'enu' xel-la' nabán li lazre', bzua dizra' ca bdxixruj be'e Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Benne' cuide' na' gunné̱': ―¿Bila na'? Jesús guzre̱' le̱': ―Quebe gutiu' benne'. Quebe súale̱nu' zru'ula benne' xula. Quebe cuanu'. Quebe nneu' da we̱n lazre' chee̱ benne'. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Gudapa ba lá'ana xra xrna'u. Bzri'i le sa' ljwezru' ca nazrí'i cuinu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Benne' cuide' na' gunné̱': ―Xúgute̱ da caní dxuna' nácatea' bídau'te̱. ¿Bízradxa quebe ne guna'? ");
INSERT INTO zatNTps_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Na' guzre Jesús le̱': ―Che dxaca lazru' gacu' benne' li lazre', bexíaj, xeaje̱te ca naca da napu', ne bnezruj na benne' xache' ca'. Nadxa gapu' xel-la' gunní'a xabáa. Na' gudátega nen neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Gate benne' cuide' na' benne̱' da nigá, bezé̱'e̱ dxexíaje lazre̱' lawe' da nápale̱'e̱ xel-la' gunní'a. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nadxa gunná Jesús, dxe̱'e̱ benne' ca' dxusé̱dene̱': ―Da li dxapa' le'e, sté̱bele̱'e̱ naca chu'u tu benne' gunní'a naga dxenná bea Dios xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Da xula dxapa' le'e, chadidxa gaca te tu bea', be̱ dxebía bénneache lu negue' tu xeche' zriche, quézcala chu'u tu benne' gunní'a naga dxenná bea Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Gate belenne̱' benne' ca' dxuse̱de Jesús da nigá, na' belexebánele̱'e̱ne̱', na' buluche̱be ljwezre̱': ―¿Nuzra la xca'? ");
INSERT INTO zatNTps_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús guné̱'e̱ benne' ca', ne guzre̱' le̱': ―Da nigá quebe gaca xelún bénneache, san Dios waca gune̱' ca naca. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nadxa gunná Pedro: ―Xran, netu' ba bcá'anantu' ca naca da nápantu', ne zéajle̱ntu' Lue'. ¿Bizra gápantu' xca'? ");
INSERT INTO zatNTps_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Beche̱be Jesús: ―Da li dxapa' le'e, ca lu zra na' gate na' xúgute̱ xelexaca na cube, gate neda', Benne' Gulje̱' Bénneache, cue'a lataj chawe' chia' naga nna be'a, le'e na' ba gudále̱le neda' cué'quezle lu chazrinnu lataj naga nna beale, chee̱ guchí'ale chee̱ chazrinnu cue' benne' Israel, benne' judío ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Xúgute̱ benne' ca' ba bulucá'ane̱' lizre̱', u benne' biche̱', u nu'ula zane̱', u xre̱', u xrne̱'e̱, u zru'ule̱', u zrí'ine̱', u xe̱zr la xu chee̱', chee̱ xelune̱' zrin chia', xelezí'queze̱' tu gaxúala na, ne xelezí'queze̱' xel-la' nabán zeajlí canna. ");
INSERT INTO zatNTps_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Benne' zante̱ zaj naca blau na'a xelaque̱' benne' bze̱be, na' benne' zante̱ zaj naca benne' bze̱be na'a xelaque̱' benne' blau. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Na' gunná Jesús: ―Da gaca naga dxenná bea Dios xabáa naca na ca da guca gate tu xrane zánete̱ cue' xe̱zr la xu guzé̱'e̱ lizre̱' che zílala, zéaje̱' zeajtílaje̱' benne' we̱n zrin ca' chee̱ cheajlechibe̱' uva chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bca'ana cháwele̱ne̱' benne' we̱n zrin ca' quízruje̱' tu dumí lazruj chee̱ tu zra, na' gusel-le̱' benne' ca' zeajlegue̱ne̱' zrin lu xe̱zr la xu chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ca gudé na' guzé̱'e̱ lizre̱' ca dxedá na, na' blé'ene̱' benne' zaj zre̱'e̱ lawe' xi'a zaj nalátajze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Na' guzre̱' benne' ca': “Cá'anqueze le'e, le chjaca we̱n zrin lu xe̱zr la xu chia', na' gunna' le'e da naca chawe'.” Na' benne' ca' xjaque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Xrane na' guzé̱'e̱ da xula wa gubizra, ne cá'anqueze dxexedá' chunna, ne tuze ca be̱ne̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Xetú du dxedá' gazxu' guxíaje̱' lawe' xi'a, na' blé'ene̱' zaj zra' na' benne' zaj nalátajzqueze̱', ne guzre̱' le̱': “¿Bizr chee̱ na' zrale le'e nigá bedú zra quebe bi zrin dxunle?” ");
INSERT INTO zatNTps_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","’Gulenné̱': “Quebe nu ne xe̱ netu' guntu' zrin chee̱'.” ’Na' guzre̱' benne' ca': “Cá'anqueze le'e, le cheajé̱n zrin lu lina chia', na' gunna' le'e da naca chawe'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Gate gul-la' chizrela, xrane na' guzre̱' benne' xu'u lu ne̱'e̱ zrin na': “Gunné̱ benne' we̱n zrin ca', ne gudízruje̱', su lau' quízruju' benne' ca' belelá' bzé̱bedxa, na' bzé̱bete̱ quízruju' benne' ca' belelá' nédxute̱.” ");
INSERT INTO zatNTps_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nadxa belezrín benne' ca' belú'e̱ lu zrin na' gate dxexedadxa gazxu', na' tu tu benne' ca' belezi'e̱ lazruj chee̱' du naxá' lazruj tu zra we̱n zrin. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Gudé na' gate belezrín benne' ca' gulu'e̱ nédxute̱ lu zrin na', guléquene̱' xelezí'e̱ da zrendxa, san cá'anqueze gulezí' tu tu benne' ca' lazruj tu zra we̱n zrin weaj. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","’Gate gulezí'e̱ na, na' gulezú lawe̱' dxelawe̱' zria lau xrane zrin na', ");
INSERT INTO zatNTps_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","dxelenné̱': “Benne' caní belelá' bzé̱bedxa, tu chí'idau'ze ga belune̱' zrin, na' gudízrujquezu' benne' caní ca gudízruju' netu', na' netu' bedú zra be̱ntu' zrin, ne ca naca da la chee̱ zra nigá bchaga launtu'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","’Beche̱be̱ xrane na', dxe̱'e̱ tu benne' ca': “Ljwézra'dau', quebe bi dxuna' chiu' da quebe naca na chawe'. ¿Quebe bca'ana cháwele̱na' lue' quízruja' lue' lazruj tu zra we̱n zrin? ");
INSERT INTO zatNTps_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Guzí' lazruj chiu', ne bexíaj. Neda' dxaca lazra' gunézruja' chee̱ benne' ca' belú'e̱ bzé̱bedxa ca da gudízrujqueza' lue'. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Quebe gaca guna' ca da dxaca lazra' nen dumí chia'? ¿Dxacu' xa lazre' lawe' da naca' neda' benne' xrlátaje?” ");
INSERT INTO zatNTps_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Na' gunná Jesús: ―Ca'an naca, benne' ca' zaj naca benne' bze̱be xelaque̱' benne' blau, na' benne' blau ca' xelaque̱' benne' bze̱be lawe' da ba gunnía' benne' zan, san bábaze benne' ca' xelaque̱' blau. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Gate xu'u Jesús neza, zexíaje̱' Jerusalén, guléaje̱' chee̱ze benne' chazrinnu ca' dxusé̱dene̱', ne guzre̱' le̱': ");
INSERT INTO zatNTps_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Dxelé'ele le'e ba zexíajdxu Jerusalén naga neda', Benne' Gulje̱' Bénneache, xuludé benne' ca' neda' lau benne' xíchaje̱ ca' chee̱ bxruze ca', ne lau benne' ca' dxuluxuzájle̱'e̱ da bdxixruj be'e Dios, na' xelechugue̱' chia' gatia'. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Xuludée̱' neda' lu na' benne' zitu' ca' chee̱ xelún le̱' chia', na' xelu'e̱ neda', ne xuludé̱'e̱ neda' xaga béguaj, san zra guxunne zra xebana'. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nadxa gubiga xrna Jacobo, ne Juan lau Jesús, bi ca' zaj naca be̱' zri'ine Zebedeo, naché̱'e̱ bi ca', na' bzu zribe̱' lau Jesús, dxenabe̱' culuén. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús bche̱be̱' nu'ula na': ―¿Bi na' dxenabu'? Nu'ula na' guzre̱' Jesús: ―Gate zrin zra nna be'u, na' gudxixruj be'e cue' tu zri'ina' caní chalá'a xabe̱la chiu', ne xetube' xéglala. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesús beche̱be̱', guzre̱' bi ca': ―Quebe nézele le'e bi na' dxenábale. ¿Waca xí'ajle le'e ca da xí'aja' neda', da na' naca na ca xel-la' zi' da tea' neda', ne waca si'le da naca na ca xel-la' dxedxúa nisa ca da si'a neda' gate chu'a lu xel-la' gute? Na' gulenabe': ―Wácantu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nadxa Jesús guzre̱' bi ca': ―Da li xí'ajle ca da xí'aja' neda', ne si'le da naca ca xel-la' dxedxúa nisa na' da si'a neda', san da cue'le chalá'a xabe̱la chia', ne chalá'a xéglala chia' quebe naca na chia' gunna' na le'e. Xra' gunézruje̱' na chee̱ bi ca' ca da ba nucueze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Gate xechí benne' ca' dxuse̱de Jesús belenne̱' ca', na' belezré̱'e̱ dxupa bi chee̱ nu'ula na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesús gunné̱' benne' ca', ne guzre̱' le̱': ―Ba nézele le'e ca dxelún benne' xíchaje̱ chee̱ xe̱zr la xu ca', dxelenná bé'ene̱' benne' ca', na' benne' nácadxe̱' blau ládujla benne' ca' dxelenná be'e̱, dxuchínene̱' xel-la' dxenná bea chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Le'e quebe dxal-la' gunle ca'. Benne' dxaca lazre̱' gaque̱' blau ládujla le'e dxal-la' gune̱' zrin chee̱ xezícadxale le'e, ");
INSERT INTO zatNTps_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","na' bénnea' dxaca lazre̱' gaque̱' xíchaje̱ chee̱le, dxal-la' gaque̱' we̱n zrin chee̱ xúgute̱le le'e. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Dxal-la' gune̱' ca be̱na' neda', Benne' Gulje̱' Bénneache, quebe bida' chee̱ nu gun zrin chia' neda', san bla'a chee̱ guna' zrin chee̱ bénneache, ne chee̱ guzúa' xel-la' nabán chia' ca da quízruja' chee̱ guselá' benne' zante̱. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Gate dxelexedxúaje̱' xe̱zre Jericó, na' benne' zante̱ zjácale̱ne̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Naga dxeledée̱' zaj dxe' chupa benne' la chul-la dxu'a neza, na' gate belenne̱' dxedé Jesús na' gulebezre xe̱'e̱, dxelenné̱': ―Xran, Zri'ine David, bexache lazre' netu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Benne' zan ca' guledil-le̱' dxúpate̱' na' chee̱ xelezúe̱' zrize, san le̱' gulebezre xe̱'e̱ zízrajdxa, dxelenné̱': ―Xran, Zri'ine David, bexache lazre' netu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nadxa Jesús guleze̱', na' gunné̱' benne' la chul-la ca', na' bche̱be̱' le̱': ―¿Bi dxaca lázrele guna' chee̱le? ");
INSERT INTO zatNTps_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Belexeche̱be benne' ca': ―Xran, dxaca lázrentu' xelé'entu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús bexache lazre̱' benne' ca', ne bte̱' xiaj lawe̱'. Na' belexelé'ete̱ benne' la chul-la ca', na' xjácale̱ne̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Gate belezrín Jesús, ne benne' ca' dxusé̱dene̱' gagu naga zua xe̱zre Jerusalén, ne ba belezrine̱' xe̱zre Betfagé, da zua na gagu naga zua xi'a naga zaj da' xaga olivo, na' Jesús gusel-le̱' chupa benne' ca' dxusé̱dene̱' chee̱ tu da xelune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Dxe̱'e̱ le̱': ―Le chjaca xé̱zredu na' da zua le nna' nigá. Na' lé'ele tu burro bzrise' da'ba' xaga, na' tu búrrodau' zúale̱ba' le̱ba'. Le se̱zre-ba', ne le che̱'e̱ dxúpate̱ba' nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Che nu benne' bi xe̱'e̱ le'e, le xe̱'e̱: “Xránadxu nachinne̱' le̱ba', na' la xesél-la'te̱queze̱'-ba'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Da nigá guca na chee̱ guxá ca da gunná benne' bchálaje̱' waláz chee̱ Dios, gunné̱': ");
INSERT INTO zatNTps_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Le xe̱ benne' zaj zra' xe̱zre Sión: “Le nna', Benne' nna bé'ene̱' le'e ze̱'e̱ naga zúale. Dute̱ xel-la' dxexruj lazre' zrie̱' tu burro bzrise'. Zrie̱' tu búrrodau', zri'ine tu be̱ dxua xua.” ");
INSERT INTO zatNTps_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nadxa dxupa benne' ca' dxuse̱de Jesús besiá'que̱', ne belune̱' ca da ba gunná be'e Jesús le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Xeajlexrí'e̱ burro bzrise', ne zrí'ineba', na' belezrúe̱' zra lane̱' cúzruba', na' guzría Jesús le̱ba'. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Benne' zan ca' gulechílaje̱' zra lane̱' la neza na', na' xebal-le̱' buluchibe̱' zina' da buluzale̱' la neza. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Benne' zjaque̱' láwela, ne benne' zá'aque̱' bze̱be gulezú lawe̱' dxelebezre xe̱'e̱, dxelenné̱': ―¡Gaca ba lá'azxa Zri'ine wenná bea David! ¡Ba neza zrente̱ naca na chee̱ bénnea' ze̱'e̱ waláz chee̱ Xránadxu Dios! ¡Gaca ba lá'azxa Dios! ");
INSERT INTO zatNTps_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Gate guxú'u Jesús xe̱zre Jerusalén, ca naca bénneache zaj zre̱'e̱ na' beledxé'ena zrague̱', na' buluche̱be ljwezre̱': ―¿Nuzra benne' nigá? ");
INSERT INTO zatNTps_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Bal-la benne' ca' gulenné̱': ―Benne' nigá naque̱' Jesús, benne' dxuchálaje̱' waláz chee̱ Dios, ze̱'e̱ xe̱zre Nazaret da nababa Galilea. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ca gudé na' guxú'u Jesús dxale'aj xudau' chee̱ Dios, na' bebéaje̱' xúgute̱ benne' we̱te, ne benne' dxelá'awe̱' na'. Bdxixre̱' blag ca' chee̱ benne' ca' dxuluché̱'e̱ dumí, ne bdxixre̱' da ca' zaj dxe' benne' ca' dxelútie̱' bgúgudu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nadxa guzre̱' benne' ca': ―Lu xiche lá'azxa naxúaj da dxenná Dios: “Lizra' nigá naca na xu'u naga xelenaba bénneache lawa' neda'”, san le'e ba nunle na ca tu lizre gubán. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Lu dxale'aj xudau' na' gulebiga lau Jesús bal-la benne' la chul-la, ne benne' zrinnaj ca', na' Le̱' bexune̱' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Belezrá' benne' xíchaje̱ ca' chee̱ bxruze ca', ne benne' ca' dxuluxuzájle̱'e̱ da nadxixruj bea Dios, gate na' belenne̱' ca dxelebezre xa'a bidu ca' lu xudau', dxelennabe': “¡Gaca ba lá'azxa zri'ine wenná bea David!” ");
INSERT INTO zatNTps_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Gulé̱'e̱ Jesús: ―¿Dxennu' ca dxelenná benne' caní? Beche̱be Jesús: ―Dxenda' na. ¿Quebe ne gulábale le'e lu xiche lá'azxa naga naxúaj na chee̱ da dxaca nigá? Dxenná na caní: Ba be̱nu' xelúl-la bidu ca', ne bidu dxe'ene ca'. Da dxelúe lá'anabe' Dios naca na da li. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nadxa bca'ana Jesús benne' ca'. Bezé̱'e̱ xe̱zre na', na' bezrine̱' xe̱zre Betania, naga bejgá'ane̱' xe̱la na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Che zílala ca zexíaj Jesús xe̱zre na', na' gudune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Zítu'la blé'ene̱' tu xaga higo dxu'a neza, na' gate bzrine̱' naga zua na, quebe bi da zixre chee̱ na blé'ene̱'. Lágaze zria na. Nadxa Jesús guzre̱' xaga higo na': ―Cabata' cuíaquezu' da zixre. Gubízrete̱ xaga higo na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ca belelé'e benne' ca' dxuse̱de Jesús da nigá, na' belexebánene̱', ne buluche̱be̱' Jesús: ―¿Ájazra na' chadite̱ gubizre xaga higo nigá? ");
INSERT INTO zatNTps_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Beche̱be Jesús: ―Da li dxapa' le'e, che nápale xel-la' dxeajlí lazre', ne quebe gun chupa lázrele, quegaze da nigá gaca gunle ca da be̱na' neda' chee̱ xaga higo nigá, san waca xe̱le xi'a nigá: Gucuasa nigá, xeajsúa lu nísadau', na' gaca na. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Che dxeajlí lázrele, na' xezi'le bítete̱ze da nábale Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nadxa guxú'u Jesús lu chila xudau', na' dxácate̱ na' dxusé̱dene̱' benne' zaj zre̱'e̱ na', gulebiga naga zua Jesús benne' xíchaje̱ ca' chee̱ bxruze ca', ne benne' gula chee̱ judío ca', na' buluche̱be̱' Le̱': ―¿Bi xel-la' dxenná bea napu' dxunu' da caní? ¿Núzraqueze be̱nna lue' xel-la' dxenná bea nigá? ");
INSERT INTO zatNTps_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Beche̱be Jesús: ―Cá'anqueze neda' guche̱ba' le'e tu. Che xeché̱bele da nigá, na' neda' xapa' le'e bi xel-la' dxenná bea napa' dxuna' da caní. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Nu benne' gusel-le̱' Juan dxuchúe̱' bénneache nisa? ¿Dios, che bénneacheze? Gulezú lawe̱' dxuluchálajle̱ ljwezre̱', dxelenné̱': ―Che nnadxu Dios gusel-le̱' le̱', na' xe̱'e̱ dxi'u: “¿Bizr chee̱ na' quebe guxéajle̱le chee̱'?” ");
INSERT INTO zatNTps_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Che nnadxu bénneache gusel-le̱' le̱', dxal-la' zrébedxu bi xelún benne' zan ca' chee̱dxu dxi'u, lawe' da dxeleque xúgute̱ bénneache bchalaj Juan na' waláz chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Chee̱ le̱ na' gulé̱'e̱ Jesús: ―Quebe nézentu'. Nadxa Jesús guzre̱' benne' ca': ―Cá'anqueze neda' quebe xapa' le'e bi xel-la' dxenná bea napa' dxuna' da caní. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Na' guzre Jesús benne' ca': ―¿Aja dxéquele le'e chee̱ da nigá? Tu benne' zaj zra' chupa zrí'ine̱' bi biu, na' guzre̱' tube': “Zri'ina', guxíaj xeajé̱n zrin lu lina chee̱ uva chia'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Zrí'ine̱' na' beché̱bebe': “Quebe dxaca lazra'.” Ca gudé na' bexíaje lázrebe', na' guxíajbe' xeajé̱nquezbe' zrin. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Cá'anqueze xrabe' na' guxíaje̱' xeajné̱'e̱ xetube', ne guzre̱'-be', na' bi nigá beché̱bebe': “Waca, xrae. Na'a cha'a.” Quebe guxíajbe'. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Núlabe' bi chupa caní be̱nbe' ca da guca lazre' xrabe'? Gulenná benne' ca': ―Bi nedxu. Na' gunná Jesús, dxe̱'e̱ benne' ca': ―Da li dxapa' le'e, benne' wechizruj ca', ne nu'ula dxeledále̱ benne' biu zante̱ xelexú'e̱ naga dxenná bea Dios nédxudxa ca le'e ");
INSERT INTO zatNTps_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","lawe' da bla' Juan, bedajlé'ene̱' le'e da naca xrlátaje, na' le'e quebe guxéajle̱le chee̱'. Benne' wechizruj ca', ne nu'ula ca' dxeledále̱ benne' biu zante̱ guléajle̱'e̱ chee̱'. Le'e, gate ble'ele da nigá, quebe bexíaje lázrele chee̱ chéajle̱le chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nadxa gunná Jesús: ―Le xene ca naca da nadxixruj bea nigá. Tu benne' xrane tu xe̱zr la xu guze̱' lba uva ca', ne be̱ne̱' le'aj chee̱ na. Be̱ne̱' tu xe̱dxu naga xelesíe̱' uva ca', ne guchise̱' tu xu'u sibe chee̱ gaca nu guxúe ca naca na. Na' bca'ane̱' na lu na' benne' we̱n zrin ca', ne guzé̱'e̱ zéaje̱' zitu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Gate bzrin zra xuluchibe̱' uva ca', na' gusel-le̱' tu chupa bi we̱n zrin chee̱' zeajlexezri'be' da dxal-la' xezí' xrane na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Benne' we̱n zrin ca' gulequé̱'e̱ bi we̱n zrin chee̱' ca'. Belúele̱'e̱ tube', ne belutie̱' xetube', na' xetube' buluzríe̱'-be' xiaj. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nadxa xrane na' gusél-ladxe̱' bi we̱n zrin chee̱' bi zandxa ca nedxu. Benne' we̱n zrin ca' tuz ca bulusaque̱' bi ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Naga xeajché'tequeze na gusel-le̱' zrí'inequeze̱' lawe' da dxéquene̱': Welape̱' ba lá'ana zri'ina'. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Gate belelé'ene̱' zrí'ine̱', na' benne' we̱n zrin ca' gulé̱ ljwezre̱': “Bi nigá xezí' lu na'be' ca naca da caní. Du gute-be' chee̱ xegá'ana chee̱dxu da caní.” ");
INSERT INTO zatNTps_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Chee̱ le̱ na' gule̱le̱'-be', ne belexebéaje̱'-be' lu xe̱zr la xu na', na' belutie̱'-be'. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nadxa Jesús bche̱be̱' benne' ca': ―Gate xida xrane xe̱zr la xu na', ¿ájazra gune̱' chee̱ benne' we̱n zrin ca'? ");
INSERT INTO zatNTps_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Gulé̱'e̱ Le̱': ―Gutie̱' benne' ca' dxelune̱' da cale̱la ne quebe xexache lazre̱' le̱'. Nadxa gucá'anale̱ne̱' xe̱zr la xu na' benne' we̱n zrin xula, benne' xuluxunézruje̱' da dxal-la' xezí' le̱' gate zrin zra chee̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nadxa Jesús guzre̱' benne' ca': ―¿Quebe ne gulábale le'e xiche lá'azxa? Caní dxenná na: Xiaj na' da buluzúa benne' we̱n xu'u ca' chalá'ala, le̱ na' naca na xiaj blau na'a. Da nigá naca na da be̱n Xránadxu, ne naca na tu da dxexebánedxu. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Chee̱ le̱ na' dxapa' le'e, Dios wequé̱'e̱ da naca chee̱le le'e naga dxenná be'e̱, na' gunézruje̱' na benne' xelune̱' da naca chee̱ xel-la' dxenná bea chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Che tu benne' cheajchazie̱' lawe' xiaj nigá waxúzruje̱', na' che xexruj na lawe' tu benne', na' guzuzruj na le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Gate benne' xíchaje̱ ca' chee̱ bxruze ca', ne benne' xudau' fariseo ca' belenne̱' da bchalaj Jesús, guleque bé'ene̱' chee̱ lé̱queze̱' bchalaj Jesús da caní. ");
INSERT INTO zatNTps_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Gate gulaca lazre̱' xele̱le̱' Le̱', belezrebe̱' benne' xe̱zre ca' lawe' da dxeléajle̱ benne' ca' naca Jesús benne' dxuchálaje̱' waláz chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Guzú lau Jesús dxuchálajle̱ne̱' benne' ca' xecha lasa tu da dxulé'e na, dxe̱'e̱ le̱': ");
INSERT INTO zatNTps_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Ca da gaca xabáa naga dxenná bea Dios naca na ca da guca gate tu benne' wenná bea be̱ne̱' tu laní wechaga na' chee̱ bi biu chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Gusel-le̱' benne' we̱n zrin chee̱' ca' cheajletupe̱' benne' ca'an gunné̱' lizre̱', san benne' ca' quebe gulaca lazre̱' xédajgaque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nadxa gusél-ladxe̱' benne' we̱n zrin chee̱' ca', benne' xula. Dxe̱'e̱ le̱': “Le xe̱ benne' ca' gunnía', ba nucueza' xel-la' wagu. Ba gunná be'eda' xelútie̱' be̱zre ca', ne be̱ dxelanne, na' ca naca na bache de̱. Dxal-la' xelelé̱'e̱ nigá naga zra' wechaga na'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Benne' ca' gunné̱' quebe gulaca lazre̱' xédajgaque̱'. Tu benne' ca' guxíaje̱' lu xe̱zr la xu chee̱', ne xetú benne' guxíaje̱' we̱te. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Xebal-la benne' ca' gule̱le̱' bi we̱n zrin ca' chee̱ wenná bea na', na' bulucháchale̱ne̱'-be', ne belútete̱'-be'. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nadxa wenná bea na' bzrá'ale̱'e̱, na' gusel-le̱' benne' chee̱' ca', benne' zjaca wedil-la xeajlegué̱tie̱' benne' we̱te benne' ca', ne xeajlezézxe'te̱' lazre' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nadxa guzre̱' bi we̱n zrin chee̱' ca': “Bal-la bi de̱ ba de̱ chee̱ wechaga na', na' benne' ca' gunnía' quebe zaj naca chee̱' xelelé̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Le chjaca neza zri'a ca', ne le nne̱ xúgute̱ benne' lé'ele, chee̱ xelelé̱'e̱ laní chee̱ wechaga na'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Benne' we̱n zrin ca' xjaque̱' la neza ca', na' xeajletupe̱' xúgute̱ bénneache, benne' belelé'ene̱' zaj naque̱' benne' cale̱la, ne benne' xrlátaje. Ca'an guca guzrate̱ xu'u na' bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nadxa wenná bea na' guxú'e̱ xeajné̱'e̱ benne' ca' gunné̱', na' blé'ene̱' tu benne' dxe'e̱ na', quebe nazi'e̱ zra lane̱' chee̱ laní chee̱ wechaga na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Guzre̱' le̱': “Lue', benne', ¿ájazra guca guxú'u nigá, ne quebe nazi'u zra lanu' chee̱ laní wechaga na'?” Bénnea' gudxé'e̱ zrize. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nadxa wenná bea na' guzre̱' bi zaj zúabe' ga na', “Le guchéaj ni'a ne̱'e̱, ne le guzale̱' chalé'ajla naga naca chul-la, naga cuezre̱', ne xáguxa'ate̱ lazxe̱'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Benne' zante̱ gunnía', na' bábaze̱' zaj naca chee̱' xelu'e̱ nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nadxa benne' fariseo ca' besiá'que̱', ne belune̱' tuze dizra' xelebéaje̱' Jesús dizra' chee̱ xelezéquene̱' xelawe̱' zría chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nadxa gulesel-le̱' bal-la benne' ca' zaj naque̱' fariseo ca' tuze, ne bal-la benne' ca' zaj de̱'e̱ Herodes, chee̱ zeajlegue̱zre̱' Jesús: ―Benne' wese̱de, nézentu' dxenníu' da li, ne dxusé̱denu' da li da zaj naca chee̱ Dios, ne quebe dxezrebu' bi xelenná bénneache, ne quebe dxenná'u ca da zaj napa bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gunná xque. ¿Aja dxéquenu' lue'? ¿Dxun na ba xen quízrujdxu da dxuluchizruj benne' ca' nasel-la César, benne' zitu', che cabí? ");
INSERT INTO zatNTps_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesús ba nézene̱' ca da dxelaca lazre̱' xelune̱' chee̱', na' guzre̱' benne' ca': ―Le'e, láweze dxunle da xrlátaje. ¿Bizr chee̱ na' dxuzúale da guzría xi na neda'? ");
INSERT INTO zatNTps_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Le gulé'e neda' dumí na' da dxízrujle chee̱ wechizruj. Nadxa bulunézruje̱' Le̱' tu dumí chee̱ xe̱zre Roma. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Gate blé'ene̱' na, na' Jesús bche̱be̱' benne' ca': ―¿Nuzra lau ni, ne le̱' da naxúaj na nigá? ");
INSERT INTO zatNTps_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Belexeche̱be̱': ―Chee̱ César na'. Na' guzre Jesús benne' ca': ―Le gunezruj chee̱ César da naca chee̱ César, ne le gunezruj chee̱ Dios da naca chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Gate belenne̱' da nigá, na' belexebánene̱', ne besiá'que̱' naga zua Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Zra ná'queze belezrín bal-la benne' saduceo ca' naga zua Jesús. Benne' saduceo ca' dxelenné̱' quebe xelexebán benne' gate. Gulé̱'e̱ Jesús: ");
INSERT INTO zatNTps_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Benne' wese̱de, Moisés gunné̱' che tu benne' nuchaga ne̱'e̱ gatie̱', ne quebe nu bidu chee̱' chilá', na' bi biche̱' dxal-la' guchaga na'abe' nen nu'ula gute benne' biu chee̱' na' chee̱ sua tu bi chee̱ benne' ba gutie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Naga zúantu' gulezrá' gazre benne' gulácabe' zri'ine tuze benne'. Bi nedxu bchaga na'abe', na' gútebe'. Bi gudxupe' bchaga na'abe' nen nu'ula na' gute benne' biu chee̱' lawe' da quebe nu zri'ine bi nedxu na' gúlajbe'. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Cá'anqueze gúcaqueze na chee̱ bi gudxupe', na' gudé na' chee̱ bi guxunne', na' cá'anqueze guca chee̱ xúgute̱ bi gazre ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ca gudé na', na' gute nu'ula na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Gate xelexebán benne' gate, ¿nula bi gazre caní gácabe' benne' chee̱ nu'ula na' lawe' da tu tu bi gazre ca' bchaga na'abe' nen nu'ula na'? ");
INSERT INTO zatNTps_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús beche̱be̱': ―Le'e dxeque zréajele lawe' da quebe núnbeale da naxúaj na lu xiche lá'azxa, ne ca naca xel-la' waca chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Gate zrin zra xelexebán benne' gate, québedxa xuluchaga na' bénneache, ne québedxa xelútie̱' bi nu'ula chee̱ xuluchaga na'abe'. Xelaque̱' ca zaj naca gubáz chee̱ xabáa chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ca naca na che dxal-la' xelexebán benne' gate, ¿quebe ne gulábale le'e ca gunná Dios? Gunné̱': ");
INSERT INTO zatNTps_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Neda' naca' Dios chee̱ Abraham, ne Dios chee̱ Isaac, ne Dios chee̱ Jacob.” Dios quebe naque̱' Dios chee̱ benne' gate, san naque̱' Dios chee̱ benne' ban, benne' ca' ba gulatie̱' lu xe̱zr la xu nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Gate belenne̱' da nigá, na' belexebane benne' ca' ca naca da dxuse̱de Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Gate benne' fariseo ca' guleque bé'ene̱' ba bzua zri Jesús benne' saduceo ca', na' belezrague̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tu benne' ca', benne' naque̱' benne' dxuxuzájle̱'e̱ da nadxixruj bea na, guca lazre̱' guxúe̱' ájala nne̱ Jesús. Bche̱be̱' Le̱': ");
INSERT INTO zatNTps_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Benne' wese̱de, ¿bizrla da gunná be'e Dios naca blau? ");
INSERT INTO zatNTps_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Beché̱be Jesús: ―Dxal-la' zri'inu' Xranu' Dios dute̱ xichaj lázrda'u, ne dute̱ bénne'du xu'u, ne dute̱ xel-la' dxéajni'i chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Da nigá naca da nadxixruj bea da blaudxa, ne da dxundxa na ba xen. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Da nadxixruj bea da gudxupe' nácaqueze na ca', da dxenná na: Bzri'i le sa' ljwezru' ca nazrí'i cuinu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Che tu benne' dxune̱' ca zaj naca chupa da nadxixruj bea caní, dxune̱' ca naca xúgute̱ da nadxixruj bea da bzuaj Moisés, ne ca naca xúgute̱ da buluse̱de benne' ca' buluchálaje̱' waláz chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Dxácate̱ ne zaj nazraga benne' fariseo ca' na', ");
INSERT INTO zatNTps_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesús bche̱be̱' le̱': ―¿Ájala dxéquele le'e chee̱ Cristo? ¿Nuzra zri'ine naque̱'? Benne' ca' gulé̱'e̱ Le̱': ―Zri'ine David na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nadxa guzre Jesús benne' ca': ―¿Ájazra na' David gate bchálaje̱' chee̱ Cristo dxe̱'e̱ Le̱': Xran? Gate gunná David da nigá bchálaje̱' da ble'e Be' Lá'azxa le̱'. Caní naca da na' gunná David: ");
INSERT INTO zatNTps_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Xrana' Dios guzre̱' Xrana': “Gudxé'e chalá'a xabe̱la chia' cadxa guzúa' zran ni'u benne' ca' quebe chawe' dxelelé'ene̱' Lue'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Ájazra naca na naca Cristo zri'ine David, che David ná'queze dxe̱'e̱ Le̱': “Xrana'”? ");
INSERT INTO zatNTps_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Quebe nu benne' guca xeché̱bequeze̱' chee̱', na' ze lau zra na' netú québedxa nu bexazre bi guché̱bedxa Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nadxa Jesús guzre̱' benne' ca' zaj zre̱'e̱ na', ne benne' ca' dxusé̱dene̱', ");
INSERT INTO zatNTps_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","dxenné̱': ―Benne' ca' dxuluxuzájle̱'e̱ da nadxixruj bea Moisés, ne benne' xudau' fariseo ca' zaj nape̱' xel-la' dxenná bea xuluxuzájle̱'e̱ da nadxixruj bea Moisés. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Chee̱ le̱ na' le guzúa dizra' chee̱ benne' caní, ne le gun xúgute̱ da xelenné̱'. Quebe gunle ca da dxelún benne' ca', lawe' da dxelenné̱' da ca' dxal-la' gunle, na' quebe dxelúnqueze̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Dxelune̱' xua zí'ile̱'e̱ da quebe dxelezeque xelezúe bénneache, ne dxelenná bé'ene̱' bénneache chee̱ xelu'e̱ na. Benne' ca' ne quebe dxuluzúe̱' na netú zrube ne̱'e̱ chee̱ da dxuluzúe benne' xubla. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Xúgute̱ da dxelún benne' ca' naca na chee̱ xelelé'e bénneache. Dxeledánnene̱' dxelu'e̱ luzxgue̱', ne ne̱'e̱ ladxe' laga naga naxúaj dizra' chee̱ Dios, ne dxelácue̱' zra lane̱' da zeajzé̱ luzre na tunna. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Dxelaca lazre̱' xelebé'e̱ naga ze̱ láweze naga dxelawe̱', ne naga naca blau lu xu'u ca' naga dxeledube̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Dxelaca lazre̱' xelapa bénneache le̱' ba lá'ana la neza ca', ne xelé̱'e̱ le̱': “Benne' wese̱de.” ");
INSERT INTO zatNTps_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Na'a le'e, quebe güele lataj nu xe̱ le'e, “Benne' wesede”, lawe' da xúgute̱le nácale bi bíchele tule xetule, ne tuze Benne' dxusédene̱' le'e, neda', Cristo. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Quebe nu xe̱le le'e: Xrae, lu xe̱zr la xu nigá, lawe' da zua tuze Xrale, Dios na' zue̱' xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Quebe güele lataj nu xe̱ le'e: Xran, lawe' da zua tuze Xránale, neda', Cristo. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Bénnea' dxune̱' zrin chee̱ xezícadxale le'e nácadxe̱' blau ládujla le'e. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Bénnea' dxucá'ana szren cuine̱' wexéxrujla bénnea', na' bénnea' dxaque̱' dxexruj lazre' wegá'ane̱' szren. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Edxugua le'e, benne' dxusé̱dele da nadxixruj bea na, ne le'e, benne' fariseo ca'. Láweze dxunle da xrlátaje. Dxusézxujle neza chee̱ xabáa chee̱ quebe nu chu'u na. Lé'equeze quebe dxú'ule, ne quebe dxuele lataj benne' dxelaca lazre̱' xelu'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Edxugua le'e, benne' dxusé̱dele da nadxixruj bea na, ne le'e, benne' fariseo ca'. Láweze dxunle da xrlátaje. Dxegúale lizre nu'ula ca' ba gulate benne' biu chee̱', na' chee̱ xulé'ele xrlátaje cuínale, dxuwízrale Dios xcha lu xudau'. chee̱ le̱ na' da zrente̱ da guzría xi na le'e. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Edxugua le'e, benne' dxusé̱dele da nadxixruj bea na, ne le'e, benne' fariseo ca'. Láweze dxunle da xrlátaje. Le'e dxedale du ca naca xe̱zr la xu nigá ne ca naca nísadau' chee̱ si' tu benne' ca naca da zéajle̱le chee̱ Dios, na' gate bache dxunle na, na' dxugápadxale bénnea' dul-la ca da nabágale le'e chee̱ cuía xi'e̱ lu lataj ba xa'. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Edxugua le'e. La chul-la nácale, ne dxaca lázrele cu'ule benne' neza. Dxennale che tu benne' dxuzétaje̱' xudau', quebe dxun na le̱' ba xen, na' che dxuzétaje̱' oro chee̱ xudau', da na' dxun na le̱' ba xen. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nácale benne' xala, ne la chul-la. ¿Nula da naca na blaudxa, oro, che xudau' na' da dxucá'ana na lá'azxa oro na'? ");
INSERT INTO zatNTps_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Cá'anqueze dxennale le'e che nu dxuzetaj cugu lá'azxa, quebe dxun na le̱' ba xen, san che dxuzétaje̱' guna' da zria na lawe' cugu lá'azxa, da na' dxun na le̱' ba xen. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nácale benne' xala ne la chul-la. ¿Nula da naca na blaudxa, guna' na', u cugu lá'azxa na' da dxucá'ana na lá'azxa guna' na'? ");
INSERT INTO zatNTps_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Che nu benne' dxuzétaje̱' cugu lá'azxa, quegaze cugu lá'azxa dxuzétaje̱', san cá'anqueze dxuzétaje̱' ca naca da zria lawe na. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Bénnea' dxuzétaje̱' xudau', quegaze xudau' na' dxuzétaje̱'. Cá'anqueze dxuzétaje̱' Dios zue̱' lataj na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Cá'anqueze benne' dxuzétaje̱' xabáa, dxuzétaje̱' lataj naga zria Dios, ne Diósqueze, Bénnea' zrie̱' lataj na' dxuzétaje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Edxugua le'e, benne' dxusé̱dele da nadxixruj bea na, ne le'e, benne' fariseo ca'. Láweze dxunle da xrlátaje. Dxunézrujle chee̱ xudau' tu cue' chee̱ da chi cue' chee̱ xixruj weaj, ne chee̱ bínnedu ca' chee̱ anís, ne chee̱ cumín. Quebe dxunle da zaj naca na blaudxa da zaj zua na lu da nadxixruj bea na, ca naca chee̱ gácale xrlátaje, ne chee̱ xexache lázrele le sa' ljwézrele, ne chee̱ chéajle̱le chee̱ Dios. Da caní zaj naca na da dxun na ba xen gunle, ne quebe gusanle da ca' ba dxunle. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","La chul-la nácale, ne dxaca lázrele cu'ule benne' neza. Dxecá'ale da naca ca tu bé'adau', be̱ zrua lawe' da dxí'ajle, na' quebe dxeque be'ele dxí'ajle da naca ca tu camello, be̱ dxelaga benneache. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Edxugua le'e, benne' dxusé̱dele da nadxixruj bea na, ne le'e, benne' fariseo ca'. Láweze dxunle da xrlátaje. Nácale ca zaj naca zriga', ne xé'ena da dxíbele cúzreze na. Lu'ule na quebe dxíbele. Caní nácale lawe' da lu lázrdaule nácale ca gubán, ne benne' dxucude. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Benne' fariseo la chul-la. Nedxu le quibe lu'ule zriga', ne xé'ena, na' cá'anqueze xegá'ana chawe' cúzrela. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Edxugua le'e, benne' dxusé̱dele da nadxixruj bea na, ne le'e, benne' fariseo ca'. Láweze dxunle da xrlátaje. Nácale ca tu ba chiche da nalá na xrtante̱ cúzrela, na' lu'ule na nazrate̱ na zrita chee̱ benne' gate', ne xúgute̱ da sgute. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ca'an nácale le'e. Cúzrela nala'le ca benne' xlátaje̱, na' lu lázrdaule nazrate̱ na da we̱n lazre', ne da cale̱la da dxunle. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Edxugua le'e, benne' dxusé̱dele da nadxixruj bea na, ne le'e, benne' fariseo ca'. Láweze dxunle da xrlátaje. Dxucá'anale cháwedau' ba ca' naga zaj nagache benne' ca' buluchálaje̱' waláz chee̱ Dios, ne dxuele lechítaje̱ lu'a chee̱ benne' xrlátaje ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Dxennale: “Chela netu' ba zúantu' gate na' gulezrá' xra xrtauntu' ca', quebe gúcale̱ntu' benne' ca' belutie̱' benne' ca' buluchálaje̱' waláz chee̱ Dios.” ");
INSERT INTO zatNTps_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Gate dxennale ca', le'e dxexúnbeaquezle nácale zri'ine zre sua benne' ca' belutie̱' benne' ca' buluchálaje̱' waláz chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Dxusexúzrele dxunle ca da gulezú lau belún xra xrtáule ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Be̱ snia nácale, ne xrtia be̱ snia. ¿Ájazra gunle chee̱ gáchele lu da zi' da xa' chee̱ lataj ba xa'? ");
INSERT INTO zatNTps_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Chee̱ le̱ na' neda' sel-la' chee̱le benne' ca' xuluchálaje̱' waláz chee̱ Dios, ne benne' sina ca', ne benne' ca' xulusé̱dene̱' le'e. Lé'equeze gútele, ne gudá'le xaga béguaj bal-la benne' ca', na' xebal-le̱' gunle le̱' zi' lu xudau' ca', na' gau zi' xúzrele le̱' tu xe̱zre xetú xe̱zre. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ca'an gaca, le'e bágale zria chee̱ xel-la' gute chee̱ xúgute̱ benne' xrlátaje ca' belute xra xrtáule ca', gate guzú lau na nu be̱te Abel, benne' xrlátaje, ne naga bzrinte̱ bé̱tele Zacarías ládujla naga zua lataj lá'azxa chee̱ xudau' ne lataj naga dxuluzezxe̱' be̱ xíxre'du ca', be̱ dxelegú'e̱ lu cugu chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Da li dxapa' le'e, bénneache zaj zre̱'e̱ na'a xelebague̱' zria chee̱ xúgute̱ da caní. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Nadxa gunná Jesús: ―Jerusalén, Jerusalén, le'e na' dxútele benne' ca' dxuluchálaje̱' waláz chee̱ Dios, ne dxuzríale xiaj benne' gubáz ca' dxesel-la Dios naga zúale. Zane' lásate̱ guca lazra' gutupa' zrí'inele chia' ca dxun bedxuj, dxutúpaba' be dxé'enedau' zran xrílaba', san quebe guca lázrele. ");
INSERT INTO zatNTps_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Le nna'xque na'a, lízrele xelexegá'ana na dácheze, ");
INSERT INTO zatNTps_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","lawe' da dxapa' le'e, québedxa lé'ele neda' cadxa zrin zra nnale: La'azxa naca bénnea' ze̱'e̱ waláz chee̱ Xránadxu. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nadxa bedxúaj Jesús xudau', na' dxácate̱ dxexedxúaje̱' na', gulebiga benne' ca' dxusé̱dene̱' lau Jesús, ne gulezú lawe̱' dxuluchálajle̱ne̱' Le̱' ca naca chee̱ xudau' na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Beche̱be Jesús: ―¿Dxelé'ele xúgute̱ da caní? Da li dxapa' le'e, netú xiaj caní quebe xegá'ana zeajzría cuzru ljwezre na. Ca naca na cuía xi na. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nadxa xjaque̱' lu xi'a naga zaj ze̱ xaga olivo, na' gate dxe' Jesús na', benne' ca' dxusé̱dene̱' belezrine̱' lau Le̱', ne bagácheze buluche̱be̱' Le̱': ―Gunná netu'. ¿Bata gaca da na'? ¿Bi gunna bea na gate zrin zra xela'u, ne gate cheajsé̱ chee̱ xe̱zr la xu nigá? ");
INSERT INTO zatNTps_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nadxa Jesús guzre̱' benne' ca': ―Le guxúe cuínale chee̱ quebe nu si xe̱ le'e. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Benne' zan xelelé̱'e̱. Xelún lazre̱' xelenné̱' zaj naque̱' Cristo, na' xelezí xe̱'e̱ benne' zan. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Wenle le'e dxaca wedil-la, ne waca wedil-la gátete̱ze na'. Quebe zrébele, lawe' da dxal-la' xelaca da caní. Da caní quebe zaj naca na chee̱ zra bze̱be. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tu cue' xe̱zr la xu tíl-lale̱ na xetú cue' xe̱zr la xu, ne tu xe̱zre tíl-lale̱ na xetú xe̱zre. Wata' gubina', ne welata' xízrawe̱' ca', ne wazrú' gátete̱ze na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Xúgute̱ da caní zaj naca na naga dxezú lau ca da xelezaca bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Nadxa xuludée̱' le'e naga si sácale, na' bál-lale welútequeze̱'. Ca naca bénneache xelecuídene̱' le'e lawe' da dxunle da naca chia'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Lu zra na' benne' zan québedxa xeléajle̱'e̱ chia', na' xelecuídene̱' le sa' ljwezre̱', ne xuludée̱' le sa' ljwezre̱' lu na' benne' guledábague̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Welelá' benne' zan benne' we̱n lazre'. Xelenné̱' dxuluchálaje̱' waláz chee̱ Dios, na' xelezí xe̱'e̱ benne' zante̱. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Lawe' da gáta'le̱'e̱ da cale̱la, benne' zan québedxa xelezrí'ine̱' le sa' ljwezre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Bénnea' zua chache̱' ca zrinte̱ zra bze̱be, la bénnea'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ca naca dizra' chawe' nigá ca nna bea Dios, zralaj na du gabí'i xe̱zr la xu chee̱ xelén ca naca benne' chee̱ xúgute̱ cue' xe̱zr la xu, na' te na' cheajsé̱ chee̱ xe̱zr la xu nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Benne' gulabe̱' da nigá dxal-la' chéajni'ine̱'. Daniel, benne' bchálaje̱' waláz chee̱ Dios, bzuaje̱' ca naca chee̱ tu da dxezrá'a Dios, da dxuxrinnaj na. Gate lé'ele da nigá zua na lataj lá'azxa chee̱ xudau', ");
INSERT INTO zatNTps_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","nadxa benne' zaj zre̱'e̱ xe̱zre ca' zaj nababa Judea dxal-la' xuluzrúnnuje̱', ne chjaque̱' lu xi'a zren. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Che tu benne' ze̱' chju'u chee̱', quebe dxal-la' xexétaje̱' bi cheajxeléaje̱' lu xu'u. Dxal-la' guzrúnnujte̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Benne' zue̱' le̱'e̱ xixre' quebe dxal-la' xezrine̱' lizre̱' cheajxezri'e̱ xicha chee̱' da gácue̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Edxugúa nu'ula ca' zaj zre̱'e̱ lu zra na' zaj zue̱' zi'i, ne nu'ula ca' zaj nu'e̱ bidau', ne dxelázrebe'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Le naba Dios quebe gun na ba xen guzrúnnujle beu' zaga, ne quegá lu zra dxupá'anale, ");
INSERT INTO zatNTps_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","lawe' da che ca' gaca na, na' da zrénte̱dxa da xelezí saca bénneache ca da quebe ne xelezaque̱' ca guzú laute̱ zua xe̱zr la xu nigá, ne québedxa bi xelezaque̱' caní ca te chee̱ da nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Che Dios quebe guzáchie̱' zra ca', na' netú quebe nu la. Guzáchie̱' na chee̱ gácale̱ne̱' benne' ca' bache nabéaje̱' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Chee̱ le̱ na', quebe chéajle̱le che nu xe̱ le'e: “Le nna'xque, nigá zua Cristo”, u che nu xe̱ le'e: “Le nna' xque, na'la zue̱'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Caní dxapa' le'e lawe' da xelelá' benne' zan, benne' guzrí xe̱'e̱, na' xelenné̱' zaj naque̱' Cristo, u zaj naque̱' benne' dxuluchálaje̱' waláz chee̱ Dios, na' da zrente̱ xululé'ene̱', ne xelune̱' xel-la' waca zren ca' chee̱ xelezí xe̱'e̱ benne' ca' ba nabéaj Dios. Caní xelune̱' che xelezéquene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ba bchálajle̱na' le'e caníqueze na'a quebe ne gaca na. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Chee̱ le̱ na', che nu xe̱ le'e: “Le nna'xque, na' zue̱' le̱'e̱ xixre'”, quebe chéajle na', u che nu xe̱ le'e: “Le nna'xque, lu xu'u nigá zue̱'”, quebe chéajle̱le. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ca dxun tu xesa guziu', dxe̱pe na naga dxalaj gubizra, na' dxelé'edxu na naga dxebía gubizra, ca'an gaca gate xida' neda', Benne' Gulje̱' Bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Gátete̱ze de̱ tu da nate, na' dxelexezraga laba ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Na' gunná Jesús: ―Gate bache guca zra na' gate xelezaca zi' bénneache, nadxa gubizra chul-la na naga zua na, na' beu' quebe gusení na, na' belaj xelexruj na, na' xelezrízequeze ca naca da zaj naca na szren da dxeledá' lu be'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nadxa lé'ele zran xabáa da gulé'e na ba zua xelá'a neda', Benne' Gulje̱' Bénneache, na' ca naca bénneache zaj zre̱'e̱ xe̱zr la xu xelebézrequeze̱'. Nadxa xelelé'ene̱' neda', Benne' Gulje̱' Bénneache, zezá'a lu beuj zran xabáa, zúale̱ neda' dute̱ xel-la' dxenná bea, ne da xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nadxa sél-laqueza' gubáz chee̱ xabáa chia' ca', na' xulucuézre̱' zizraj lúzuba' chee̱ xuluxutupe̱' benne' ca' ba nabéaja' chia' dapa saca chee̱ xe̱zr la xu nigá, ne du ca naca xe̱zr la xu nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Le guse̱de ca naca da dxulé'e xaga higo. Gate dxelexedxé'ene zruze na, ne dxezría na laga' dxe'ene, ba nézele ba za xaca beu' la. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Cá'anqueze gate lé'ele dxelaca xúgute̱ da caní, dxal-la' nézele gágute̱ ba zua cheajsé̱ chee̱ xe̱zr la xu, ne ba zua gaca na. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Da li dxapa' le'e, xúgute̱ da caní xelaca na nédxula gate quebe ne xelate bénneache zaj zre̱'e̱ lu zra na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Xabáa ne xe̱zr la xu weledé chee̱ na. Dizra' chia' quebe te chee̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Gate za zra na', ne bila zra na', quebe nu neze, quegá gubáz chee̱ xabáa zaj zre̱'e̱ xabáa, ne neda', Zri'ine Dios. Tuze Xradxu Dios nézene̱' gate zrin zra na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Ca guca lu zra ca' gate zua Noé, cá'anqueze gaca na gate xelá'a neda', Benne' Gulje̱' Bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ca lu zra ca' gate quebe ne gun Dios nisa xiuj da guzría xi na bénneache, gulezrá' bénneache ca' dxelé'aj dxelawe̱', ne dxuluchaga ne̱'e̱, ne dxulunézruje̱' zrí'ine̱' ca' chee̱ xuluchaga na'be', cadxa bzrin zra guxú'u Noé lu da zren na' dxedá lawe' nísadau' da nazí le na arca. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Quebe guleque bé'ene̱' ca da dxal-la' gaca na, cadxa bzrin zra guca xiuj na', ne be̱te na ca naca benne' ca'. Cá'anqueze gaca gate xelá'a neda', Benne' Gulje̱' Bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ca lu zra ca' xelezrá' chupa benne' biu le̱'e̱ xixre'. Tue̱' xeché̱'e̱, na' xetúe̱' xegá'ane̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Xelezrá' chupa nu'ula dxelútue̱'. Tue̱' xeché̱'e̱, na' xetúe̱' xegá'ane̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Le sua le'e ban lazre' lawe' da quebe nézele bi zra xelá'a neda', Xránale. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Da nigá dxal-la' nézele: Che tu xrane xu'u nézene̱' bi zra chizrela zrin gubán, waxíchaje̱' bchigala, ne quebe gu'e̱ lataj xusalaj benne' gubán lizre̱' chee̱ cuane̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Chee̱ le̱ na', le sua le'e ban lazre' lawe' da xelá'a neda', Benne' Gulje̱' Bénneache, gate québela dxéquele ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Na' gunná Jesús: ―¿Nuzra na' benne' we̱n zrin li lazre' ne dxéajni'ine̱', bénnea' xrane̱' dxucá'anale̱ne̱' le̱' benne' zaj zre̱'e lizre̱' chee̱ gunézruje̱' da xelawe̱' gate zrin zra chee̱ na? ");
INSERT INTO zatNTps_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ba neza naca na chee̱ benne' we̱n zrin na', gate xezrín xrane̱', lé'ene̱' le̱' dxune̱' ca naca da nabague̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Da li dxapa' le'e, xrane̱' gucá'anale̱ne̱' le̱' ca naca da nape̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Che benne' we̱n zrin na' gaque̱' benne' we̱n da cale̱la, ne guéquene̱' quebe xelá' ze̱ xrane̱', ");
INSERT INTO zatNTps_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ne che su lawe̱' gusaca zi'e̱ xezícala benne' we̱n zrin ca', ne xi'aj gágule̱ne̱' benne' dxelezuzre̱', ");
INSERT INTO zatNTps_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","nadxa xrane̱' xezrine̱' zra gate québela dxebeze̱'. Gaca na zra quebe nézene̱', ");
INSERT INTO zatNTps_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","na' gusaca zí'le̱'e̱ le̱'. Chugue̱' chee̱' gaque̱' tuze benne' ca' dxelune̱' láweze da xrlátaje. Cuezre̱', ne xáguxa'ate̱ lazxe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Gunná Jesús: ―Ca gaca chee̱ benne' xelu'e̱ naga dxenná bea Dios xabáa naca na ca da guca chee̱ chi nu'ula cuide' caní. Gulequé̱'e̱ xi' chee̱' ca', chee̱ chjaque̱' laní chee̱ wechaga na', dxelebeze̱' bátala xelá' benne' wechaga na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Gazxu' nu'ula caní gulaque̱' gat lazre', na' xegazxu' nu'ula caní zaj naque̱' ban lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nu'ula ca' quebe zaj naque̱' ban lazre' belú'e̱ xi' chee̱' ca', san quebe belú'e̱ da za zxezxe na da xelegué̱'e̱ lu xi' chee̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nu'ula ban lazre' ca' belú'e̱ xi' chee̱' ca', ne da za zxezxe na da xelegué̱'e̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Lawe' da guzré benne' wechaga na', na' gulaca wase ca zaj naque̱', na' xúgute̱' gulasie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Dxe̱la ben tu chi'i benne' dxebezre xe̱'e̱, dxenné̱': “Ba za' wechaga na'. Le dxuaj si' lu na'le le̱'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Xúgute̱ nu'ula cuide' caní gulase̱', na' gulezú lawe̱' bulugale̱' xi' chee̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nadxa gazxu' nu'ula ca' quebe zaj naque̱' ban lazre' gulé̱'e̱ gazxu' nu'ula ban lazre' ca': “Le gunna late' da za zxezxe na chee̱ntu', lawe' da ba dxelexula xi' chee̱ntu'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nu'ula ban lazre' ca' belexeche̱be̱': “Quebe gaca, lawe' da che gúnnantu' late' chee̱le, quebe gaca na da dxechínnentu' netu', ne da dxechínnele le'e. Le chjácala naga dxutie̱' na, ne le cheajxrí chee̱le.” ");
INSERT INTO zatNTps_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Dxácate̱ zjaca nu'ula ca' quebe zaj naque̱' ban lazre', na' bezrín wechaga na'. Nu'ula ban lazre' ca' gulu'e̱ nen le̱' lu laní chee̱ wechaga na', na' bsezxuj dxa xu'u na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Gudé na' belexezrín xegazxu' nu'ula ca', na' gulenné̱': “Xran, Xran, gusalaj chú'untu'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Le̱' beche̱be̱': “Cabata'. Da líqueze quebe núnbe'a le'e.” ");
INSERT INTO zatNTps_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nadxa Jesús guzre̱' benne' ca': ―Le sua le'e ban lazre', lawe' da quebe nézele bi zra, u bi xel-la' xelá'a neda', Benne' Gulje̱' Bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Na' gunná Jesús: ―Ca gaca chee̱ benne' xelu'e̱ naga dxenná bea Dios xabáa, naca na ca da guca gate tu benne' zue̱' chee̱ se̱'e̱ chéaje̱' zitu', na' gunné̱' bi we̱n zrin chee̱' ca', ne bcá'anale̱ne̱' bi we̱n zrin ca' dumí chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Tu bi ca' bnézruje̱' gazxu' cue' dumí, na' xetube' bnézruje̱' chupa cue' dumí, na' xetube' bnézruje̱' tu cue' dumí. Bnézruje̱' chee̱ tu tube' ca da xelezéquebe' xuluchínebe' na. Nadxa guzé̱'e̱ zéaje̱' zitu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Bi we̱n zrin na' guzi'be' gazxu' cue' dumí bchínebe' dumí na', na' bezi'be' xegazxu' cue' dumí. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Cá'anqueze bi we̱n zrin na' guzi'be' chupa cue' dumí, bezi'be' xechupa cue' dumí. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bi we̱n zrin na' guzí'be' tu cue' dumí na' guxíajbe', ne bcáchebe' dumí chee̱ xránabe' tu lu xe̱dxu da be̱nbe' lu xu. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Zane' iza ba guca gate bezrín xrane bi we̱n zrin ca', na' guzú lawe̱' dxezi'e̱ da bdee̱' lu na' bi we̱n zrin ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nedxu bzrin bi we̱n zrin na' guzí'be' gazxu' cue' dumí, na' bnézrujbe' xránabe' xegazxu' cue' dumí, na' gúzrebe' le̱': “Xran, be̱nnu' neda' gazxu' cue' dumí. Nigá de̱ xegazxu' cue' da bezi'a nen dumí chiu'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Na' xránabe' guzre̱' le̱be': “Da chawe' be̱nu'. Nacu' tu bi we̱n zrin xrlátaje, ne li lazre'. Gucu' li lazre' lu late' da be̱nna' lue', na' gúnnaqueza' lue' da zréndxaqueze. Guxú'u naga zua' neda', ne gubéle̱'e̱.” ");
INSERT INTO zatNTps_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Gudé na' bzrin bi we̱n zrin na' guzi'be' chupa cue' dumí, na' gunabe': “Xran, be̱nnu' neda' chupa cue' dumí. Nigá de̱ xechupa cue' da bezi'a nen dumí chiu'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Na' xránabe' guzre̱' le̱be': “Da chawe' be̱nu'. Nacu' tu bi we̱n zrin xrlátaje, ne li lazre'. Gucu' li lazre' lu late' da be̱nna' lue', na' gúnnaqueza' lue' da zréndxaqueze. Guxú'u naga zua' neda', ne gubéle̱'e̱.” ");
INSERT INTO zatNTps_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Gate bzrin bi we̱n zrin na' guzi'be' tu cue' dumí, na' gúzrebe' xránabe': “Xran, nezda' nacu' benne' dxenné̱ xue, ne dxezi'u da quebe guzu', ne dxexeca'u da quebe be̱siu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Chee̱ le̱ na' bzreba', na' guxá'a xeajcáchia' dumí chiu' lu xu. Nigá de̱ da naca chiu'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Na' xránabe' guzre̱' le̱be': “Nacu' bi we̱n zrin cale̱la, ne zrawe̱de. Ba nézqueznu' dxezi'a da quebe guza', ne dxexecá'a da quebe be̱sia'. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Chee̱ le̱ na' la xju'u dumí chia' na' lu na' benne' dxelízruje̱' chee̱ dumí da dxuluchínene̱', na' gate za' neda', na' xezi'a da naca chia' nen da belezí'e̱.” ");
INSERT INTO zatNTps_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nadxa guzre̱' benne' ca' zaj zre̱'e̱ na': “Le xecá'a dumí na' da núxrube', ne le gunezruj na bénnea' nape̱' chi cue' dumí. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Benne' nape̱' wazidxe̱' da zrendxa, na' benne' quebe nape̱', ca late' da du na' nape̱' wecá'a na. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ca naca bi we̱n zrin nigá, bi wedegún, le xebéaj-be' chalé'ajla naga naca chul-la, naga cuézrebe', ne xáguxa'ate̱ lázxabe'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Na' gunná Jesús: ―Gate xelá'a neda', Benne' Gulje̱' Bénneache, ne Benne' Wenná Bea, nen ca naca gubáz chee̱ xabáa chia', na' cué'queza' lataj naga nna be'a, da naca na da xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Na' bénneache chee̱ xúgute̱ cue' xe̱zr la xu xelexezrague̱' lawa' neda', na' xebéaja' cha chee̱' ca dxun benne' dxuxúe̱' zrila'. xebéaje̱' chíbudu ca' ládujla zrila' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Guzrá'a benne' ca' zaj naca zrila' chia' chalá'a xabe̱la chia', na' benne' ca' zaj naca ca chíbudu ca' guzrá'a le̱' chalá'a xéglala chia'. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nadxa xapa' benne' ca' zaj zra' chalá'a xabe̱la chia': “Le da le'e, nácale xrlátaje lau Xra'. Le chu'u naga dxenná bea Xra', lataj na' bcueze̱' chee̱le gate na' be̱ne̱' xe̱zr la xu nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Caní dxaca lawe' da guduna', na' bgágule neda'. Gubíleda', na' bé̱nnale da gu'a. Gudá' ca tu benne' xu'e̱ neza, na' gulu'ule neda' lízrele. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Bxázrjeda' zra lana' gácua', na' bgácule neda'. Quebe chawe' guzúa', na' bedajnábale neda'. Guxu'a lizre xia, na' bedajnábale neda'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nadxa benne' xrlátaje caní xelenné̱': “Xran, ¿bata blé'entu' Lue' dxedunu', na' bgáguntu' Lue'? ¿Bata blé'entu' Lue' dxebílenu', na' bé̱nnantu' da gu'u? ");
INSERT INTO zatNTps_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Bata blé'entu' Lue' ca tu benne' xu'e̱ neza, na' gulú'untu' Lue' lízrentu'? ¿Bata blé'entu' Lue' dxexázrjenu' zra lanu', na' bgácuntu' Lue'? ");
INSERT INTO zatNTps_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Bata bénentu' quebe chawe' zu', u xu'u lizre xia, na' bedajnábantu' Lue'?” ");
INSERT INTO zatNTps_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Neda' xeche̱ba': Da li dxapa' le'e, ca da be̱nle chee̱ bénnedu caní, benne' zaj naca dxexruj lazre', chee̱ néda'queza' be̱nle ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Nadxa neda', Benne' Wenná Bea, xapa' benne' ca' zaj zra' chalá'a xéglala chia': Le cuasa cuita' neda', le'e, nácale we̱n da cale̱la lau Xra'. Le chjaca lu xi' chee̱ lataj ba xa' da nabeza na chee̱ da xriwe̱', ne chee̱ gubáz chee̱ na ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Caní dxaca lawe' da guduna', na' le'e quebe bé̱nnale da gawa'. Gubíleda', na' quebe bé̱nnale da xí'aja'. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Gudá' ca tu benne' xu'e̱ neza, na' quebe gulu'ule neda' lízrele. Bxázrjeda' zra lana' gacua', na' quebe bgácule neda'. Quebe chawe' guzúa' ne guxu'a lizre xia, na' quebe bedajnábale neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nadxa benne' ca' xelé̱queze̱' neda': “Xran, ¿bata blé'entu' Lue' dxedunu', u dxebílenu', u xu'u neza, u dxexázrjenu' zra lanu', u quebe chawe' zu', u xu'u lizre xia, na' quebe gúcale̱ntu' Lue'?” ");
INSERT INTO zatNTps_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Neda', benne' wenná bea, xeche̱ba': Da li dxapa' le'e, lawe' da quebe bi be̱nle chee̱ bénnedu caní, benne' zaj naca dxexruj lazre', quebe bi be̱nle chee̱ néda'queza'. ");
INSERT INTO zatNTps_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Benne' caní chjácaqueze̱' lataj ba xa', na' benne' xrlátaje ca' chjaque̱' lu xel-la' nabán da zeajlí canna. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Gate bexuzre bchalaj Jesús caní, na' guzre̱' benne' ca' dxusé̱dene̱': ");
INSERT INTO zatNTps_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Ca ba nézquezle, xechupa zraze na'a súadxu Laní Pascua, da naca na zra dxuluxucube benne' judío ca guca gate Dios bebéaje̱' bénneache chee̱' lu xe̱zr la xu Egipto, na' neda', Benne' Gulje̱' Bénneache, xuludée̱' neda' lu na' benne' xuludé̱'e̱ neda' xaga béguaj. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ca lu zra na' benne' xíchaje̱ ca' chee̱ bxruze ca', ne benne' dxuluxuzájle̱'e̱ da bdxixruj Moisés, ne benne' gula sina ca' chee̱ judío ca', belezrague̱' chale'aj chee̱ xu'u zaca chee̱ Caifás, bxruze blau. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Na' belílaje̱' ájala xele̱le̱' Jesús lu da we̱n lazre' chee̱ xelútie̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Gulenné̱': ―Quebe gundxu na lu zra laní nigá, chee̱ quebe xeledábaga benne' ca' dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Zua Jesús xe̱zre Betania lizre Simón, bénnea' güé'ene̱' we̱' guzru'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Bzrin tu nu'ula naga zua Jesús, nu'e̱ tu zruágadau' da naca na xiaj alabastro, ne nazrate̱ na da dxelá zixre da zácale̱'e̱ na. Gate na' dxe' Jesús ga dxelawé̱', na' nu'ula nigá gulu'e̱ na xichaj Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Gate belelé'e benne' ca' dxuse̱de Jesús da nigá, na' belezré̱'e̱, ne gulezú lawe̱' dxelenné̱': ―¿Bizr chee̱ na' guzría xi' da nigá? ");
INSERT INTO zatNTps_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Da nigá waca la gudá'u na sí'adxu da zrente̱, chee̱ gácale̱dxu benne' xache' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús benne̱' da nigá, na' guzre̱' benne' ca': ―¿Bizr chee̱ na' dxunle nu'ula nigá ze̱de? Da nigá be̱ne̱' naca na tu da xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Benne' xache' ca' tu zrázqueze̱' ládujla le'e, na' neda' quegá tu súale̱za' le'e. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ca naca da be̱n nu'ula nigá, gulu'e̱ da zixre na' be̱l-la' dxen chia', naca na da xucá'ana chawe na neda' chee̱ zra gachia' lu xe̱dxu ba. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Da li dxapa' le'e, gátete̱ze xuluchálaje̱' dizra' chawe' chia' nigá du gabí'i xe̱zr la xu, na' zrálajqueze ca da be̱n nu'ula nigá, chee̱ cheajlesá lazre' bénneache le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nadxa tu benne' chazrinnu ca' dxuse̱de Jesús, bénnea' le̱' Judas Iscariote, guxíaje̱' xeajchálajle̱ne̱' benne' xíchaje̱ ca' chee̱ bxruze ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Guzre̱' le̱': ―¿Ájate̱ gúnnale neda' che ca' gudéa' Jesús lu na'le? Nadxa benne' ca' gulízruje̱' le̱' chi dxua dumí plata. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ca lu zra na' guzú lau Judas dxexílaje̱' ájala gune̱' gudée̱' Jesús lu na' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Zra nedxu chee̱ laní na' gate na' dxelawe̱' xeta xtila da quebe nachixre cua zichaj chee̱ na, benne' ca' dxuse̱de Jesús belezrine̱' lau Le̱', na' buluche̱be̱' Le̱': ―¿Gazra dxaca lazru' gucuézentu' da gágudxu chee̱ laní pascua chee̱ benne' judío? ");
INSERT INTO zatNTps_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesús guzre̱' le̱': ―Le chjaca lu xe̱zre na', naga zua lizre tu benne', na' le xe̱'e̱: “Bennea' dxusé̱dene̱' dxi'u dxenné̱': Zra chia' gatia' ba zua gágute̱, na' lizru' lue' gawa' chee̱ Laní Pascua tu zren nen benne' ca' dxusé̱deda'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Benne' ca' dxuse̱de Jesús belune̱' ca da gunná bé'ene̱' le̱', na' bulucueze̱' da xelawe̱' chee̱ Laní Pascua. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Gate gula chizrela, na' gudxé' Jesús ga gawe̱' tu zren nen benne' ca' dxusé̱dene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Dxácate̱ na' dxelawe̱', guzre Jesús benne' ca': ―Da li dxapa' le'e, tule le'e naca bénnea' gudée̱' neda' lu na' benne' ca' dxelune̱' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nadxa benne' ca' belexewí'inele̱'e̱, na' gulezú lawe̱' tu tue̱' dxuluche̱be̱' Jesús: ―Xran, ¿quebe naca neda'? ");
INSERT INTO zatNTps_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Na' beche̱be Jesús: ―Bénnea' dxudé ne̱'e̱ lu xé'ena tu zren nen neda', benne' na' gudée̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Neda', Benne' Gulje̱' Bénneache, waxá'a naga dxal-la' gatia' ca naxúaj na lu xiche chee̱ Dios, san edxugúa bénnea' gudée̱' neda'. Cháwedxa naca la quebe gulaj bénnea'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nadxa gunná Judas, bénnea' gudée̱' Jesús, dxenné̱': ―Benne' dxuse̱de, ¿quebe naca neda'? Na' beche̱be Jesús, gunné̱': ―Awe', lue' na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Dxácate̱ dxelawe̱', Jesús guqué̱'e̱ xeta xtila, na' guzre̱' Dios: “Xcalenu'.” Gudé na' bzúzruje̱' na, na' bnézruje̱' na benne' ca' dxusé̱dene̱', dxenné̱': ―Le gagu. Da nigá naca na be̱l-la' dxen chia'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Gudé na' guqué̱'e̱ tu zriga', na' guzre̱' Dios: “Xcalenu'”, na' bnézruje̱' na benne' ca', dxenné̱': ―Le xi'aj xúgute̱le da xuzru lu zriga' nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Da nigá naca na dxen chia' da guzúa chacha na xel-la' wezría cube da dxun Dios. Dxen nigá lalaj na ne̱ chee̱ benne' zante̱ chee̱ gunite lau Dios dul-la zaj nabaga benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Dxapa' le'e, québedxa xí'aja' ca naca xrise uva nigá ca zrindxa zra xí'aja' da cube tu zren nen le'e naga dxenná bea Xra'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ca gudé belul-le̱' chee̱ Dios, na' gusiá'que̱' zjaque̱' lu Xi'a Xaga Olivo Ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nadxa Jesús guzre̱' benne' ca': ―Xúgute̱le le'e gusán lázrele neda' na'a zre', lawe' da naxúaj na lu xiche chee̱ Dios, dxenné̱': “Gutia' benne' dxuxúe̱' zrila', na' zrila' ca' xelase dínnajba'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Gate te xebana' neda', cha'a neda' ga nababa Galilea nédxudxa ca le'e. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nadxa beche̱be Pedro: ―Lácala xúgute̱ benne' caní xulusán lazre̱' Lue', quebe guna' neda' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nadxa Jesús guzre̱' le̱': ―Da li dxapa' lue', lu zre' na'a zre' nédxudxa gate cuezre xjeaj, lue' wannáu' chunna lasa quebe núnbe'u neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro guzre̱' Jesús: ―Lácala gatia' neda' tu zren nen Lue', québequeze nnia' quebe núnbe'a Lue'. Cá'anqueze gulenná xúgute̱ benne' ca' dxuse̱de Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nadxa bzrin Jesús nen benne' ca' dxusé̱dene̱' tu lataj nazí le na Getsemaní, na' guzre̱' le̱': ―Le cue'e nigá dxácate̱ cha'a neda', guchálajle̱na' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesús guché̱'e̱ Pedro, ne dxúpate̱ zri'ine Zebedeo, na' guzú lawe̱' bewí'inele̱'e̱ne̱' ne guzúale̱'e̱ ste̱be. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nadxa guzre̱' benne' ca': ―Dxewí'ine lázrele̱'a dxunte̱ na gute na neda'. Le xegá'ana le'e nigá, ne le sua ban lazre' tu zren nen neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nadxa Jesús guzé̱'e̱ zéaje̱' xelate' caníladxa, na' gute̱' sudxú'ala lu xu, ne bchálajle̱ne̱' Dios, dxenné̱': ―Xrae, chela gaca, bde na chalá'ala quebe gaca chia' ca naca xel-la' gute caní da naca na ca tu da sla' da xí'aja'. Quebe gaca na ca dxaca lazra' neda'. Gaca na ca dxaca lazru' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nadxa bezrín Jesús naga zaj zra' benne' ca' dxusé̱dene̱', na' blé'ene̱' benne' ca' dxelásie̱', na' guzre̱' Pedro: ―¿Quebe gúcale le'e quíchale bchigala nen neda' tu chí'idau'ze? ");
INSERT INTO zatNTps_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Le nnaze, ne le guchálajle̱ Dios chee̱ quebe gun zréaje da xriwe̱' le'e. Da li bénne'du xu'ule dxaca lázre'le̱'e na, san lu be̱la' dxen chee̱le dxate ni'a na'le. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Da gudxupe' lasa guxíaj Jesús bchálajle̱ne̱' Dios caní: ―Xrae, che quebe gaca te chalá'ala ca naca da dxal-la' saca', gaca na ca dxaca lazru' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ca gudé na' bezrine̱', ne belé'ene̱' benne' ca' dxusé̱dene̱', dxelásie̱' lawe' da ba dxelezrude' lawe̱' dxelaca wásele̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Bca'ane̱' benne' ca', guzé̱'e̱ zéaje̱' bchálajle̱ne̱' Dios da guxunne' lasa, na' gunnáqueze̱' ca da ba gunné̱' ca'an bache. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nadxa bezrine̱' naga zaj zra' benne' ca' dxusé̱dene̱', na' guzre̱' le̱': ―Le gase na'a, ne le xezí' lazre'. Ba bzrin zra gate neda', Benne' Gulje̱' Bénneache, tea' lu na' benne' dul-la ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Le chasa, ne le chu'u. Ba za bénnea' dxudée̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ne dxuchálajte̱ Jesús na' gate bzrin Judas. Naque̱' tu benne' chazrinnu ca', na' zá'acale̱ benne' zante̱ le̱', benne' zaj nu'e̱ xia ca' ne xaga ca'. Benne' caní zaj naque̱' benne' gulesel-la benne' xíchaje̱ ca' chee̱ bxruze ca', ne benne' gula sina ca' chee̱ judío ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas, bénnea' dxudée̱' Jesús, ba blé'ene̱' benne' ca' ca tu da gune̱' da gulé'e na nu na' naca Jesús. Gunné̱': ―Bénnea' gunupa' neda', Le̱' na'. Le che̱'e̱ ca tu benne' we̱n da zrinnaj. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nadxa bzrin Judas lau Jesús, dxenné̱': ―Diuzre, Benne' dxuse̱de. Na' bnupe̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Beche̱be Jesús: ―Ljwezra', ¿bi chee̱ za'u? Nadxa gulebiga benne' ca', gule̱le̱' Jesús, na' beleché̱'e̱ Le̱' ca tu benne' we̱n da zrinnaj. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tu benne' ca' dxuse̱de Jesús guléaje̱' xia chee̱', ne guchugue̱' chalá'a naga bi we̱n zrin chee̱ bxruze blau. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nadxa Jesús guzre̱' le̱': ―Begú'u xia chiu' lu zre na, lawe' da xúgute̱ benne' dxelute benne' nen xia nalá, cá'anqueze gate le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Quebe nézenu' wazéqueda' neda' naba' Xra', na' Le̱' sél-late̱' na'a naga zua' da zandxa ca chazrinnu cue' gubáz chee̱ xabáa, zaj naque̱' zánete̱ tu tu cue'? ");
INSERT INTO zatNTps_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Na'a che ca'an guna', ¿ájazra gaca gaca na ca da naxúaj na lu xiche chee̱ Dios, da dxenná na caní dxal-la' gaca na? ");
INSERT INTO zatNTps_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nadxa guzre Jesús benne' ca': ―Le'e bdxuajle nen xia nalá ca', ne nen xaga ca' chee̱ qué̱lale neda', dxunle neda' ca tu benne' gubán. Xúgute̱ zra gudxe'a neda' lu xudau' dxusé̱deda' le'e, ne quebe gudé̱lale neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Xúgute̱ da caní dxaca na chee̱ gaca na ca da gulenná benne' ca' buluchálaje̱' waláz chee̱ Dios, da na' naxúaj na lu xiche chee̱ Dios. Nadxa xúgute̱ benne' ca' dxuse̱de Jesús bulucá'ane̱' Le̱' tuze̱', buluxuzrúnnuje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Benne' ca' gule̱le̱' Jesús guleché̱'e̱ Le̱' lau Caifás, bxruze blau, ga na' zaj nazraga benne' ca' dxuluxuzájle̱'e̱ da bdixruj be'e Moisés, nen benne' gula sina ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro zéaje nawe̱' Jesús zítu'la, na' bzrine̱' chale'aj chee̱ lizre bxruze blau, na' guxú'e̱, ne gudxé'e̱ tu zren nen bi xa'aga chee̱ lé'ene̱' ájala xexuzre da dxaca na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Benne' xíchaje̱ ca' chee̱ bxruze ca', ne benne' gula sina ca', ne xúgute̱ benne' ca' chee̱ xu'u lawe' blau chee̱ judío ca' belílaje̱' ájala xuluzría xi'e̱ Jesús, lácala naca na da we̱n lazre', chee̱ xelezéquene̱' xuludée̱' Le̱' gatie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Quebe bi belezrelne̱', lácala belezrín benne' zan benne' gulenné̱' da we̱n lazre' chee̱ Jesús. Naga xeajse̱te̱ na belezrín chupa benne' we̱n lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Dxelenné̱': ―Benne' nigá gunné̱': “Wazéqueda' neda' guchínnaja' xudau' chee̱ Dios, na' xexuna' na lawe' chunna zraze.” ");
INSERT INTO zatNTps_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nadxa guxasa bxruze blau, na' guzre̱' Jesús: ―¿Quebe bi dxexeche̱bu'? ¿Bizra da dxelenné̱' chiu' lue'? ");
INSERT INTO zatNTps_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús guzúe̱' zrize. Nadxa bxruze blau na' guzre̱' Le̱': ―Lu La Dios ban dxenná be'eda' lue' nneu' da li. Gunná che nacu' lue' Cristo, Zri'ine Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús guzre̱' le̱': ―Nácaqueza' ca dxennáu' lue'. Cá'anqueze dxapa' le'e, walé'ele neda', Benne' Gulje̱' Bénneache, cue'a chalá'a xabe̱la chee̱ Dios nen xel-la' szren chee̱', na' xelá'a lu beuj bza chee̱ xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nadxa bxruze blau gucheze̱' zra lane̱' chee̱ blé'ene̱' quebe nabague̱' zria, na' gunné̱': ―Benne' nigá dxenné̱' schanni' chee̱ Dios. ¿Nachínnedxadxu benne' xeche̱be̱'? Ba bénquezle le'e ca dizra' schanni' dxenné̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Bi dxennale le'e? Benne' ca' gulenné̱': ―Nabague̱' zria, ne dxal-la' gatie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nadxa buluzré̱'e̱ zrene̱' lau Jesús, ne belú'e̱ Le̱', na' xebal-le̱' belegape̱' dxu'a lawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Na' gulé̱'e̱ Le̱': ―¿Nácaquezu' Lue' Cristo? Gunné̱ xa'a nu be̱ Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Dxácate̱ na' dxe' Pedro chalé'ajla, na' tu nu'ula we̱n zrin bzrine̱' lau Pedro ne guzre̱' le̱': ―Cá'anqueze lue' nacu' Jesús, benne' Galilea na', tuze. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedro be̱n chúchue̱' xrtizre̱' láwela xúgute̱ benne' ca', gunné̱': ―Quebe nezda' nu chee̱ na' dxenníu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nadxa Pedro zexíaje̱' chee̱ xedxúaje̱' chale'aj na', na' ble'e xetú nu'ula ca' le̱', ne guzre̱' benne' ca' zaj zre̱'e̱ na': ―Cá'anqueze benne' nigá dxedále̱ne̱' Jesús, benne' Nazaret na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Xecha lasa be̱n chúchue̱' Pedro xrtizre̱', na' bzétaje̱' Dios, gunné̱': ―Quebe núnbe'a benne' na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Xetú chí'idau' guca belezrín benne' zaj zre̱'e̱ na' lau Pedro, na' gulé̱'e̱ le̱': ―Da li, tuze nácaquezu' nen bénnea' lawe' da xel-la' dxenné̱ chiu' dxunna bea na lue'. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nadxa guzú lau Pedro dxuzría xi' cuínazqueze̱', ne dxuzétaje̱' Dios, dxenné̱': ―Quebe núnbeaqueza' benne' na'. Dxácate̱ na' gudxezre xjeaj. ");
INSERT INTO zatNTps_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nadxa xeajsá lazre' Pedro ca da guzre Jesús le̱': Nédxudxa ca cuezre xjeaj, lue' wannáu' chunna lasa quebe núnbe'u neda'. Bedxúaj Pedro na', na' gudxézrele̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Gate guxaní', xúgute̱ benne' xíchaje̱ ca' chee̱ bxruze ca', ne benne' gula sina ca' chee̱ benne' judío ca' belune̱' tuze dizra' ájala xelune̱' chee̱ xelútie̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nadxa beleché̱'e̱ Le̱' nadxéaje̱', ne xeajlegu'e̱ Le̱' lau Poncio Pilato, benne' dxenná be'e waláz chee̱ xezr la xu Roma. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nadxa Judas, bénnea' bdee̱' Jesús, gate guque bé'ene̱' ba buluzría xi'e̱ Jesús, bexíajele̱'e̱ne̱', na' bunézruje̱' da chi dxua dumí plata lau benne' xíchaje̱ ca' chee̱ bxruze ca', ne benne' gula sina ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Dxe̱'e̱ le̱': ―Neda' be̱na' dul-la lawe' da bdea' tu benne' naque̱' du lazre' chee̱ gatie̱'. Belexeche̱be benne' xíchaje̱ ca': ―¿Bizra naca chee̱ntu' da nigá? Chiu' lue' naca da na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nadxa Judas buzale̱' dumí na' lu xudau', ne bezé̱'e̱, na' xeajxelú'u du lbe̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Benne' xíchaje̱ ca' chee̱ bxruze ca' buluxutupe̱' dumí na', dxelenné̱': ―Quebe gaca cú'udxu dumí nigá naga xu'u dumí chee̱ xudau', lawe' da naca na lazruj chee̱ benne' dxute benne'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nadxa belune̱' tuze dizra' xelá'awe̱' tu xe̱zr la xu nen dumí na' da nazí le na xe̱zr la xu chee̱ we̱n xesu' zruaga, chee̱ gaca na tu lataj naga xelegache benne' zitu'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Chee̱ le̱ na' nazí le xe̱zr la xu na' Xe̱zr La Xu Chee̱ Dxen ca lu zra na'a zra. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Caní guca na chee̱ gaca ca da gunná Jeremías, benne' bchálaje̱' waláz chee̱ Dios, gunné̱': “Gulequé̱'e̱ chi dxua dumí plata da naca na da zaca Le̱' da buluzúa benne' Israel. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Nen dumí na' belá'awe̱' xe̱zr la xu chee̱ benne' we̱n xesu' zruaga, cáte̱ze gunná be'e Xrana' neda'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Guleché̱'e̱ Jesús lau bénnea' dxenná be'e̱ waláz chee̱ xe̱zr la xu Roma, na' le̱' bche̱be̱' Jesús: ―¿Nacu' Lue' Wenná Bea chee̱ judío ca'? Jesús gunné̱': ―Ca' naca na, ca dxennáu' lue'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Gate benne' xíchaje̱ ca' chee̱ bxruze ca', ne benne' gula sina ca' gulawe̱' zria chee̱ Jesús, na' Le̱' quebe bi beche̱be̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nadxa gunná Pilato, dxe̱'e̱ Jesús: ―¿Quebe dxennu' ca da dxelenná benne' caní chiu'? ");
INSERT INTO zatNTps_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesús quebe bi beche̱be̱'. Ca'an guca bebanne bénnea', ne quebe bezrela lazre̱' ájala nne̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Gate dxu'u laní na', bénnea' dxenná be'e̱ na' xu'u lawe̱' dxusane̱' tu benne' we̱n da zrinnaj, nútete̱ze benne' dxelaca lazre' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ca lu zra na' xu'u tu benne' lizre xia, benne' wé̱nle̱'e̱ da zrinnaj, nazí le̱' Barrabás. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ca zaj nazraga benne' ca' na', Pilato bche̱be̱' le̱': ―¿Nuzra dxaca lázrele gusana' neda'? ¿Gusana' Barrabás, che Jesús, bénnea' le̱' Cristo? ");
INSERT INTO zatNTps_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Caní gunné̱' lawe' da ba nézene̱' buludée̱' Jesús lawe̱' le̱' lawe' da dxelaque̱' xa lazre' chee̱ Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Dxácate̱ na' dxe' Pilato naga dxuchi'e̱ chee̱ bénneache, na' zru'ule̱' gusel-le̱' tu benne' xeaje̱zre̱' Pilato: “Quebe guchixre chiu' da naca chee̱ benne' xrlátaje na', lawe' da guneda' xe̱la ba dxe̱le, da bzúale̱'e̱ na neda' ste̱be ne̱ chee̱ Le̱'.” ");
INSERT INTO zatNTps_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Benne' xíchaje̱ ca' chee̱ bxruze ca', ne benne' gula sina ca' belegú'u xele̱' benne' ca' chee̱ xelenabe̱' la Barrabás, ne gate Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Bénnea' dxenná be'e̱ bchálajle̱ne̱' benne' ca' xecha lasa. Buche̱be̱' le̱': ―¿Nula benne' chupa caní dxaca lázrele le'e gusana'? Benne' zan ca' gulenné̱': ―Barrabás. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato bche̱be̱' benne' ca': ―¿Bizra guna' chee̱ Jesús, benne' le̱' Cristo? Xúgute̱' belexeche̱be̱': ―Bde̱'e̱ xaga béguaj. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nadxa gunná Pilato, dxe̱'e̱ benne' ca': ―¿Bizra da cale̱la nune̱'? Benne' ca' gulezú lawe̱' dxelebezre xe̱'e̱, gulenné̱': ―Bde̱'e̱ xaga béguaj. Bde̱'e̱ xaga béguaj. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Gate Pilato guque bé'ene̱' quebe bi séquene̱', na' benne' zan ca' dxeledábague̱' le̱', na' gunná bé'ene̱' bla' nisa, na' gudibe ne̱'e̱ láwela benne' ca', dxenné̱': ―Quebe bi dul-la nabaga' chee̱ xel-la' gute chee̱ benne' xrlátaje nigá. Naca na chee̱le le'e. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Xúgute̱ benne' ca' belexeche̱be̱': ―Netu', ne zrí'inentu' nabágantu' ca naca chee̱ xel-la' gute chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nadxa Pilato bsane̱' Barrabás, ne gunná bé'ene̱' beleché̱'e̱ Jesús chee̱ xelu'e̱ Le̱', na' bdee̱' Le̱' chee̱ te̱'e̱ xaga béguaj. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nadxa benne' dxjaque̱' wedil-la chee̱ bénnea' dxenná be'e̱ guleché̱'e̱ Jesús, ne gulegú'e̱ Le̱' lu xu'u lawe'. Belexezraga ca naca benne' dxjaque̱' wedil-la naga ze̱ Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Belequé̱'e̱ zra lane̱', ne bulugácue̱' Le̱' tu ladxe' bzawe. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Buluzúe̱' xíchaje̱' tu da naca na zruze xaga xeche', ne buluguxre̱' Le̱' tu xaga ne̱'e̱ xabe̱la. Nadxa buluzú zribe̱' lau Jesús, ne belún le̱' chee̱', dxelenné̱': ―Gaca xabáa chiu', Wenná Bea chee̱ judío ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Cá'anqueze buluzré̱'e̱ Le̱' zrene̱', na' gulequé̱'e̱ xaga da nuxru Jesús, ne guline̱' na xíchaje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ca gudé belún le̱' chee̱ Jesús, na' belexegüe̱' ladxe' bzawe, na' buluxugácue̱' Le̱' zra lánaqueze̱'. Nadxa beleché̱'e̱ Le̱' chee̱ te̱'e̱ xaga béguaj. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ca gusiá'que̱' na', belexezrague̱' tu benne' xe̱zre Cirene, le̱' Simón, na' gulenná bé'ene̱' le̱' bi'e̱ xaga béguaj chee̱ Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ca'an guca belezrine̱' tu lataj nazí le na Gólgota, da dxennadxu, Lataj Chee̱ Zrita Xichaj Benne' Gate. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Na' bulunézruje̱' da xi'aj Jesús xrise uva wal-la da nachixre na da sla', san gate bxue Jesús ca naca na, quebe gu'e̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ca bexuzre benne' dxjaca wedil-la buludé̱'e̱ Le̱' xaga béguaj, na' gulebéaje̱' da gaca bea na chee̱ xelexelé̱'e̱ ca naca zra lana Jesús. Ca'an guca guxá ca da gunná benne' bchálaje̱' waláz chee̱ Dios, gunné̱': “Belexelé̱'e̱ zra lana' le̱ze̱'. Gulebéaje̱' da gaca bea na.” ");
INSERT INTO zatNTps_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nadxa gulebé'e̱ dxuluzuzre̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Buluzríe̱' xichaj Jesús na' tu xiche da naxúaj na da nabague̱', da dxenná na: Jesús, wenná bea chee̱ judío ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Cá'anqueze buludé̱'e̱ chupa benne' gubán tu zren nen Jesús le̱'e̱ xaga béguaj ca', tue̱' chalá'a xabe̱la, ne xetúe̱' chalá'a xéglala ga da' xaga béguaj chee̱ Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Benne' dxeledée̱' na' dxelún le̱' chee̱ Jesús. Dxulutá xíchaje̱', ");
INSERT INTO zatNTps_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ne dxelenné̱': ―¿Dxuchínnaju' xudau', na' lawe' chunna zraze xexunu' na? Bselá cuinu'. Che nacu' Zri'ine Dios, bexetaj le̱'e̱ xaga béguaj na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Cá'anqueze belún la chee̱' benne' xíchaje̱ ca' chee̱ bxruze ca', ne benne' dxuluxuzájle̱'e̱ da bdxixruj be'e Moisés, ne benne' xudau' fariseo ca', ne benne' gula sina ca'. Dxelé̱ ljwezre̱': ");
INSERT INTO zatNTps_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Bselé̱' benne' xula, san quebe dxezéquene̱' guselá cuine̱'. Che naque̱' Wenná Bea Chee̱ Xe̱zre Israel, dxal-la' xexétaje̱' le̱'e̱ xaga béguaj, na' chéajle̱dxu chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Le̱' bxren lazre̱' Dios. Na'a guselá Dios Le̱' che da li dxaca lazre̱', lawe' da gunná Le̱' naque̱' Zri'ine Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Cá'anqueze gubán ca' zaj da' xaga béguaj ca' nen Jesús gulenné̱' schanni' chee̱ Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nadxa ca naca xe̱zr la xu na' guchul-la na. Guzú lau na wagubizra ca bzrinte̱ na ca dxedá chunna. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","La ná'queze Jesús gudxezre xe̱'e̱, dxenné̱': ―Elí, Elí, ¿lama sabactani? (Da nigá zéaje̱ na: Dios chia', Dios chia', ¿bizr chee̱ na' nusán lazru' neda'?) ");
INSERT INTO zatNTps_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bal-la benne' zaj zre̱'e̱ na' belenne̱' ca da gunná Jesús, na' gulenné̱': ―Benne' nigá dxenné̱' Elías, benne' bchálaje̱' waláz chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Dxácate̱ na' guzá' chegu tu benne' ca', xeajxrí'e̱ tu da dxezrupe nisa, na' ca bsebise̱' na nen nupe zichaj, na' bzue̱' na lawe' tu xaga, ne bzrigue̱' na dxu'a Jesús chee̱ xrupe̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Benne' xezica ca' gulenné̱': ―Le guxúe xca'. Quebe gunu' ca'. Nná'xquedxu che wida Elías guselé̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Xecha lasa gudxezre xa'a Jesús, na' gutie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Lu zra ná'queze ladxe' da ze̱ lu xudau' bdxuaj na chúpala, guzú lau na xíchaje̱, bedxúajte̱ na dxe'ela. Guzrú' xe̱zr la xu, na' xiaj xre ca' gulúzruqueze na. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Gulexalaj ba, na' belexebán benne' gate ca', benne' guléajle̱'e̱ da naca chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ca gudé bebán Jesús, na' benne' caní belexedxúaje̱' lu xe̱dxu ba, ne belexexú'e̱ lu xe̱zre lá'azxa Jerusalén, naga benne' zan belelé'ene̱' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nadxa benne' dxenná be'e̱ lu wedil-la, ne benne' dxjaque̱' wedil-la, benne' ca' dxuluzuzre̱' Jesús, gate belelé'ene̱' guzrú', ne xezícadxa da ca'an gulaca, na' belezrébele̱'e̱, dxelenné̱': ―Da lítegaze benne' nigá guque̱' Zri'ine Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nu'ula zan zaj zre̱'e̱ na' dxelenné̱'e̱ zítu'la, nu'ula ca' xjácale̱ne̱' Jesús gate bezé̱'e̱ ga nababa Galilea, ne gulácale̱queze̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ládujla nu'ula ca' xu'u María Magdalena, ne María xrna Jacobo ne José, ne xrna zri'ine Zebedeo ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ca guzú lau dxaca waxrinne, na' bla' tu benne' gunní'a le̱' José, benne' xe̱zre Arimatea, benne' dxéajle̱queze̱' chee̱ Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Benne' nigá guxíaje̱' xeajchálajle̱ne̱' Pilato, na' benabe̱' be̱l-la' dxen chee̱ Jesús. Pilato gunná bé'ene̱' xulunézruje̱' le̱' be̱l-la' dxen na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nadxa José bequé̱'e̱ be̱l-la' dxen na', na' bchele̱' na tu ladxe' da naxadxe. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nadxa gulu'e̱ Le̱' lu ba da naca na cheé̱queze José na', da be̱ne̱' tu lu xiaj. Gulexrúe̱' tu xiaj blaga zren dxu'a ba chee̱ Jesús, na' bezé̱'e̱ ga na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Gulezrá' María Magdalena, ne xetú María, zaj dxe'e̱ le nna' dxu'a ba na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Zeaj zra xula, da naca na zra ca gudé zra bulucueze̱', na' benne' xíchaje̱ ca' chee̱ bxruze ca', ne benne' xudau' fariseo ca' belezrine̱' lau Pilato. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Dxelé̱'e̱ le̱': ―Xran, dxeajsá lázrentu' ca naca da gunná benne' we̱n lazre' na' gate na' zue̱'. Gunné̱' gate gaca chunna zra, na' xebane̱' ládujla benne' gate. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chee̱ le̱ na', bdixruj be'ene̱' benne' ca' xulubia xuluxue̱' ba chee̱' na' cadxa gaca chunna zra, chee̱ quebe xelelá' benne' ca' bsé̱dene̱' xedajlexebéaje̱' be̱l-la' dxen na' chizrela, na' te na' xuluzenne̱' bénneache ba bebane̱' ládujla benne' gate. Che ca'an gaca, na' dizra' we̱n lazre' bze̱be nigá gun na da zrinnaj zrendxa ca da nedxu. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato guzre̱' benne' ca': ―Na' zaj zra' benne' dxjaque̱' wedil-la xuluzuzre̱' na. Le chjaca le'e, ne le guxúe xanne' ba na' ca se̱ lau séquele. ");
INSERT INTO zatNTps_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nadxa xjaque̱', xeajlexúe̱' ba na'. Buluchiche̱' tu da gunna bea na che xalaj ba na', na' bulucá'ane̱' benne' dxjaca wedil-la ga na'. ");
INSERT INTO zatNTps_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ca gudé chee̱ zra dxulupá'ana judío ca', ca za dxaní' zra nedxu, na' María Magdalena, ne xetú María na' xjaque̱' xeajlenné̱'e̱ ba chee̱ Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Chadite guzrú'le̱'e̱ na lawe' da betaj tu gubáz chee̱ xabáa chee̱ Xránadxu, na' bzrine̱' dxu'a ba na', ne bequé̱'e̱ xíajta'a zren na' da zrua na dxu'a ba na', na' gudxé'e̱ lawe na. ");
INSERT INTO zatNTps_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Gubáz na' dxácatite legale̱', ne naca chiche zra lane̱' ca bezxe'. ");
INSERT INTO zatNTps_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Gate belelé'e benne' dxjaque̱' wedil-la gubáz chee̱ xabáa na', na' belezrízene̱' xel-la' dxelezrebe, ne belexegá'ane̱' ca benne' gate ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nadxa gunná gubáz chee̱ xabáa na', dxe̱'e̱ nu'ula ca': ―Quebe zrébele. Nezda' dxexílajle Jesús, bénnea' gudé̱'e̱ xaga béguaj. ");
INSERT INTO zatNTps_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Quebe zue̱' nigá lawe' da ba bebane̱', cáte̱ze na' gunné̱'. Le da nna'le lu ba naga gulegú'e̱ Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Le cheajxáquezega, le cheaje̱zre benne' ca' bsé̱dene̱' ba bebane̱' ládujla benne' gate, na' chéaje̱' ga nababa Galilea nédxudxa ca le'e. Na' lé'ele Le̱'. Da nigá naca na da nabaga'a xapa' le'e. ");
INSERT INTO zatNTps_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nadxa nu'ula ca' besiá'que̱' dxu'a ba na', zeajxaca chégüe̱'. Dxelezrebe̱', ne dxelebene̱'. Zjaque̱' zeajlegue̱zre̱' benne' ca' bse̱de Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Dxácate̱ na' Jesús bchague̱' nu'ula ca', ne bgape̱' le̱' diuzre. Belezrine̱' lau Jesús, dxelúe lá'ane̱' Le̱', ne bulunide̱' ni'a Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Le̱' guzre̱' nu'ula ca': ―Quebe zrébele. Le chjaca, le cheajé̱zre bi bícha'dau' ca' dxal-la' chjaque̱' naga nababa Galilea. Na' xelexelé'ene̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Dxácate̱ zjaca nu'ula ca', na' benne' ca' dxjaca wedil-la gulu'e̱ xe̱zre, ne buluchálajle̱ne̱' benne' xíchaje̱ ca' chee̱ bxruze ca' ca da guca. ");
INSERT INTO zatNTps_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Benne' xíchaje̱ ca' buluchálajle̱ne̱' benne' gula sina ca' chee̱ xelune̱' tuze dizra'. Nadxa bulunézruje̱' benne' dxjaque̱' wedil-la dumí zrente̱. ");
INSERT INTO zatNTps_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Dxelenné̱': ―Le nna le'e belelá' benne' ca' bse̱de Jesús na' chizrela, dxácate̱ dxásele le'e, na' belexexú'e̱ be̱l-la' dxen chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Che benne' dxenná be̱'e̱ na' xenne̱' da nigá, netu' guchálajle̱ntu' le̱', ne gucá'ana cháwentu' chee̱ quebe bi gaca chee̱le le'e. ");
INSERT INTO zatNTps_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nadxa benne' dxjaque̱' wedil-la gulezí' lu ne̱'e̱ dumí na', na' besiá'que̱' belune̱' ca bache zaj nézene̱'. Da nigá naca na ca dxelenná judío ca' zéajte̱ lu zra na'a zra. ");
INSERT INTO zatNTps_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nadxa xjaca benne' chinéaj ca' bse̱de Jesús, na' belezrine̱' lu xi'a naga ba guzre Jesús le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Gate belelé'ene̱' Jesús, na' bulucá'ana szrene̱' Le̱'. Bal-le̱' gulaca chupa lazre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nadxa Jesús gubigue̱' naga zaj zra' benne' ca', na' guzre̱' le̱': ―Neda' ba nazí' lu na'a ca naca xel-la' dxenná bea xabáa, ne lu xe̱zr la xu nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Chee̱ le̱ na' le chjaca, le cheajchálajle̱ benne' zaj zre̱'e̱ du ca naca xe̱zr la xu nigá, ne le cheajsé̱dene̱' ca naca da bsé̱deda' le'e. Le guchúe̱' le̱' nisa lu La Xra', ne lu La Zrí'ine̱', ne lu La Be' Lá'azxa. ");
INSERT INTO zatNTps_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Le gusé̱de-ne̱' xelaque̱' wezúa dizra' ca naca da ba gunná be'eda' le'e, na' neda' tu súale̱zqueza' le'e xúgute̱ zra cadxa cheajsé̱ chee̱ xe̱zr la xu nigá. ¡Ca'an gaca na!");
INSERT INTO zatNTps_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Caní guzú lau dizra' chawe' ca naca chee̱ Jesucristo, Zri'ine Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Bzrin lazre' da bzuaj Isaías, benne' bchálaje̱' waláz chee̱ Dios, ca da gunná Dios: ¡Le nna'xque nigá! Neda' dxesel-la' benne' gubáz chia', benne' cuía lawe̱' lau Lue'. Bénnea' gupé̱'e̱ neza naga teu' chee̱ ilúnbe'e bénneache Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Welénqueze chi'i benne' dxebezre xe̱'e̱ le̱'e̱ xixre' lawe' lataj. Dxenné̱': “Le gupá'a neza naga te Xránadxu lu xichaj lázrdaule. Le xebéaj li neza lase chee̱' ca'.” ");
INSERT INTO zatNTps_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Caní guca lawe' da bla' Juan le̱'e̱ xixre' lawe' lataj, na' bchálaje̱' dizra' chee̱ Dios, ne gunné̱' dxal-la' xeledxúa bénneache nisa, na' bchue̱' le̱' nisa, benne' ca' belexebí'i lazre̱' chee̱ gunite lau Dios dul-la da zaj nabague'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ca'an guca, guledxúaj bénneache zan lu xe̱zre Jerusalén, ne xúgute̱ xe̱zre ca' zaj nababa Judea, na' xjaque̱' naga zua Juan, na' Juan nigá bchue̱' benne' ca' nisa lu xe̱gu Jordán, benne' ca' gulexrúale̱pe̱' dul-la da zaj nabague'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Caní guca zra lana Juan. Gucue̱' zra lane̱' ladxe' xicha zra camello, bia dxelebía bénneache, ne tu xpádxue̱' xide bchela le̱'e̱. Dxawe̱' biche xuaj, ne dxé'aje̱' bzrína'dau' chee̱ bézudau'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ca dxuchálaje̱' dizra' chee̱ Dios, dxenné̱': ―Gate te chia' neda', na' xida xetú benne', bénnea' nápadxe̱' xel-la dxenná bea ca neda'. Quebe naca chia' xáchua' chee̱ lechja' zrele̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Da lítega, neda' bchua' le'e nisa. Le̱' gune̱' da zéaje̱ xel-la dxedxúa nisa nigá, guzúe̱' Be' Lá'azxa lu xichaj lázrdaule. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ca da guca lu zra ca', guzá' Jesús lu xe̱zre Nazaret chee̱ ga nababa Galilea, na' bzrine̱' lau Juan. Juan nigá bchue̱' Jesús nisa lu xe̱gu Jordán. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Gate bdxuaj Jesús lu nisa, la blé'ete̱ne̱' naxalaj xabáa, ne blé'ene̱' betaj Be' Lá'azxa. Dxulé'e lawe̱' ca tu bgúgudu chiche, na' bzrine̱' ca li xichaj Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ben tu chi'i da za xabáa, da dxenná na: ―Lue' nacu' Zri'ina'. Nazrí'ida' Lue', ne dxezaca ba lázrele̱da' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nadxa Be' Lá'azxa guché̱'e̱ Jesús le̱'e̱ xixre' lawe' lataj. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Guzúa Jesús le̱'e̱ xixre' lawe' lataj chua zra chua xe̱la. Na' bzrin Satanás da xriwe̱', ne guca lazre' na gun na baga Jesús dul-la. Guzúa Jesús naga zaj zra' be̱ xixre' be̱ snia, na' gubáz chee̱ xabáa chee̱ Dios gulácale̱ne̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ca gudé guxú'u Juan lizre xia, na' bzrin Jesús lu xe̱zre ca' zaj nababa Galilea, ne dxuchálajle̱ne̱' bénneache dizra' chawe' ca dxenná bea Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Gunná Jesús: ―Ba bzrin zra. Ba zua báguze gate nna bea Dios xe̱zr la xu nigá. Chee̱ le̱ na', le xebí'i lazre', ne le cheajlí lazre' dizra' chawe' nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Gate gudá Jesús dxu'a nísadau' chee̱ Galilea, na' blé'ene̱' Simón, ne Andrés, biche Simón na'. Benne' caní dxuluzale̱' xixruj bela chee̱' lu nísadau' lawe' da zaj naque̱' wezén bela. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Na' gunná Jesús: ―Le gun neda' tuze, na' guzúa' le'e gácale we̱n zrin chia'. Cheajxrile bénneache ca dxunle dxezenle bela. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","La bulucá'anate̱' xixruj chee̱' ca', na' zjácale̱ne̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nadxa gudé Jesús xelate' ca na'la, na' blé'ene̱' Jacobo, ne Juan, benne' ca' zaj naque̱' zri'ine Zebedeo. Zaj zre̱'e̱ lu da dxedá lawe' nísadau', dxelexexune̱' xixruj bela chee̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ca gunné̱ Jesús Jacobo, ne Juan, na' la bulucá'anate̱' xre̱' Zebedeo ne we̱n zrin chie̱' ca' zaj zre̱'e̱ lu da dxedá lawe' nísadau', na' zjácale̱ne̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Gate gul-la na gulu'e̱ lu xe̱zre Capernaum, na' gate bzrin zra dxulupá'ana benne' judío ca', guxú'u Jesús lu xu'u naga dxelúe lá'ana judío ca' Dios, ne bsé̱dene̱' benne' ca' zaj zre̱'e̱ na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Belexebánene̱' ca naca da dxuse̱de Jesús le̱' lawe' da dxuchálaje̱' nen dute̱ xel-la dxenná bea, ne quegá ca dxuluchalaj benne' ca' dxuluxuzájle̱'e̱ da nadxixruj bea Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nadxa bla' tu benne' xu'e̱ be' xriwe̱' lu xu'u na', na' gudxezre xa'a na lu dxu'a bénnea'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Gunná na: ―¿Bizra nápantu' chiu', Jesús, benne' Nazaret? ¿Za'u guzría xi'u netu'? Ba nézquezda' nu nacu'. Benne' Lá'azxa chee̱ Dios nacu'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús gudil-le̱' na, gunné̱': ―Zrize guzúa. Bedxúaj lu be̱l-la' dxen chee̱ benne' nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nadxa be' xriwe̱' na' bxrízele̱'e̱ na bénnea', ne gudxezre xá'ale̱'e̱ na, na' bedxúaj na. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Belexebánele̱'e̱ xúgute̱ benne' zaj zre̱'e̱ na', dxelé̱ ljwezre̱': ―¿Bizra dizra' cube da nigá? Dute̱ xel-la dxenná bea chee̱' dxenná be'ene̱' be' xriwe̱' ca', na' dxuluzúa na dizra' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","La bzrílujte̱ dizra' chee̱ xel-la waca chee̱ Jesús du ca naca xe̱zre ca' zaj nababa Galilea. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ca belexedxúaje̱' lu xu'u na' chee̱ judío ca', na' belezrine̱' lizre Simón, ne Andrés. Jacobo ne Juan dxelune̱' Jesús tu zren. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Lu xu'u na' de̱ xrna' zru'ula Simón, xu'e̱ da la. La buluchálajle̱te̱' Jesús ca dxaca chee̱ nu'ula nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Le̱' la bé̱xrute̱' ne̱'e̱, bechise̱' le̱'. La bedxúajte̱ da la da xu'e̱, na' bseni'e̱ da gulawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ca gula guzré zra na', ca guzría gubizra, na' guleché̱'e̱ xúgute̱ benne' we̱' lau Jesús, ne benne' ca' zaj xu'e̱ be' xriwe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ca naca benne' xe̱zre gulebigue̱' dxa xu'u naga zua Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús bexune̱' zánete̱ benne' we̱' ca zaj naca xízrawe̱' da xu'u tu tue̱', ne bebéaje̱' zane' be' xriwe̱' zaj xu'u bénneache ca'. Quebe be̱'e̱ lataj be' xriwe̱' ca' xelenné̱ na lawe' da zaj núnbea na Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ca bebán Jesús bál-lala, ne nachúl-late̱, bedxúaje̱' guzé̱'e̱ zéaje̱' tu lataj naga nadache' bénneache, na' bchálajle̱ne̱' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón Pedro, ne benne' ca' zaj zrále̱ne̱' le̱' belexexílaje̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ca xeajlexraque̱' Jesús, na' gulé̱'e̱ Le̱': ―Xúgute̱ bénneache dxelexexílaje̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Na' gunná Jesús: ―Chéajdxu xe̱xre walizre ca' chee̱ guchálajle̱na' benne' ca' xrtizra Dios. Chee̱ le̱ na' belja'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Lu xu'u ca' naga dxelúe lá'ana judío ca' Dios, da ca' zaj zua tu tu xe̱zre ca' chee̱ ga nababa Galilea, bchalaj Jesús dizra' chee̱ Dios, ne bebéaje̱' xízrawe̱' xriwe̱' ca' da zaj xu'u benne' we̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nadxa bzrin lau Jesús tu benne' dxé'ene̱' xízrawe̱' guzru', na' bzu zribe̱', ne guta' xuene̱' Le̱', dxenné̱': ―Che Lue' dxaca lazru', waca xexunu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús bexache lazre̱' le̱', na' bli ne̱'e̱, gudane̱' le̱'. Dxenné̱': ―Dxaca lazra'. Na'a dxexacu'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ca gunné̱' caní, la becuásate̱ xízrawe̱' na', na' begá'ane̱' chawe'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Nadxa Jesús bsízrene̱' le̱', na' besel-le̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Caní gunné̱': ―Quebe nu xu'u ca da guca chiu'. Guxíaj lau bxruze xeajlé'e cuinu', ne bnezruj ca naca da gunná be'e Moisés xelún benne' ca' xelexexaque̱'. Caní gunu' chee̱ xelelé'ene̱' ba bexacu' na'a. ");
INSERT INTO zatNTps_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nadxa benne' nigá, ca bezé̱'e̱, guzú lawe̱' dxuchálajle̱ne̱' tu tu benne' ca guca chee̱' bexaque̱'. Ca'an guca, québedxa guca chu'u Jesús zaca bal-la lau lu xe̱zre. Begá'ane̱' le̱'e̱ xixre' lawe' lataj. Bénneache chee̱ xúgute̱ xe̱zre ca' belezrine̱' lau Jesús naga zue̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ca gudé chupa chunna zra, na' guxú'u Jesús xecha lasa lu xe̱zre Capernaum. Belénne bénneache zua Jesús tu lu xu'u. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","La belezrágate̱ benne' zante̱ naga zua Jesús. Ca'an guca, québedxa guque lu xu'u, ne dxa xu'u. Bchalaj Jesús xrtizra Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Na' belezrín tapa benne' lu xu'u naga zua Jesús, zaj nu'e̱ tu benne' quebe gaca se̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Lawe' da quebe gulezéquene̱' xelezrine̱' lau Jesús, lawe' da zaj zra' bénneache zante̱ ga na', na' gulesáluje̱' chju'u chee̱ xu'u naga zua Jesús. Na' bululétaje̱' da'a da zrua benne' na' quebe gaca se̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Lawe' da dxeque be'e Jesús ca dxeleajlí lazre' benne' ca' Le̱', na' gunné̱', dxe̱'e̱ bénnea' quebe gaca se̱'e̱: ―Zrí'ina'dau', ba nanite lau dul-la da nabagu'. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Zaj dxe'e bal-la benne' ga na', benne' dxuluxuzájle̱'e̱ da nadxixruj bea Dios, na' gulenné̱ lanze̱': ");
INSERT INTO zatNTps_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","―¿Bizr chee̱ na' dxuchalaj caní benne' nigá? Dxucá'ana dítaje̱' Xránadxu Dios. ¿Núzraqueze gaca gunite lau dul-la da zaj nabaga bénneache? Tuze Dios na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Dxeque be'e Jesús lu lázrdawe̱' ca dxelenné̱ lane̱' chee̱', na' gunné̱': ―¿Bizr chee̱ na' dxéquele caní? ");
INSERT INTO zatNTps_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Bizra dizra' quebe naca na sté̱bela xapa' benne' nigá quebe gaca se̱'e̱? ¿Naca na ste̱be xapa' le̱', ba nanite lau dul-la nabagu'? Cabí. ¿U che ste̱be xapa' le̱', bexasa, becá'a da denu', ne bexíaj? ");
INSERT INTO zatNTps_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Na'a, chee̱ nézele le'e neda', Benne' Gulje̱' Bénneache, napa' xel-la dxenná bea lu xe̱zr la xu gunite lawa' dul-la da zaj nabaga bénneache. Na' gunná Jesús, dxe̱'e̱ bénnea'. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Lue' dxapa', bexasa, becá'a da'a chiu', ne bexíaj lizru'. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ca'an guca, la bexásate̱', na' bequé̱'e̱ da'a chee̱', ne bedxúaje̱' lau xúgute̱ bénneache. Ca'an guca, xúgute̱ benne' ca' belexebánene̱', na' belúe lá'ane̱' Xránadxu Dios. Dxelenné̱': ―Cabata' ne lé'edxu gaca na ca guca da nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ca gudé na' bedxúaj Jesús zéaje̱' dxu'a nísadau', na' xúgute̱ bénneache lu xe̱zre ca' belezrine̱' lau Le̱'. Nadxa bsé̱dene̱' benne' ca' xrtizra Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ca gudé Jesús na', ble'ene' Leví, zri'ine Alfeo, dxe'e̱ lataj chee̱ wechizruj. Na' gunná Jesús, dxe̱'e̱ le̱': ―Be̱n neda' tuze. La guxásate̱ Leví, guxíajle̱ne̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ca' guca, gate gudxé' Jesús dxawe̱' lizre Leví, na' zánete̱ benne' wechizruj, ne benne' dul-la ca' gulebé'e̱ dxelágule̱ne̱' tu zren nen Jesús, ne benne' ca' dxusé̱dene̱'. Caní naca lawe' da zjácale̱ benne' zante̱ Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nadxa benne' ca' dxuluxuzájle̱'e̱ da nadxixruj bea Dios, ne benne' fariseo ca', gate belelé'ene̱' ca da dxun Jesús, dxágule̱ne̱' benne' wechizruj ca', ne benne' dul-la ca', na' gulenné̱', dxelé̱'e̱ benne' ca' dxuse̱de Jesús: ―¿Bizra da nigá? Dxagu dxé'ajle̱ne̱' benne' wechizruj ca', ne benne' dul-la ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ca ben Jesús da nigá, gunné̱': ―Benne' chawe' ca' quebe dxelechínene̱' benne' dxexún bénneache. Benne' we̱' ca' dxelechínene̱' bénnea'. Quegá bla'a dxennéa' benne' xrlátaje ca'. Benne' dul-la ca' dxennéa'. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ca guca lu zra na', belún gubasa benne' ca' dxuse̱de Juan, ne benne' ca' dxuluse̱de benne' fariseo ca'. Na' belezrín benne' ca', bedajlegue̱zre̱' Jesús: ―¿Bizr chee̱ na' dxelún gubasa benne' ca' dxuse̱de Juan, ne benne' ca' dxuluse̱de benne' fariseo ca', na' benne' ca' dxusé̱denu' Lue' quebe dxelune̱' gubasa? ¿Bizr chee̱ na'? ");
INSERT INTO zatNTps_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Na' Jesús guzre̱' benne' ca': ―¿Waca xelún gubasa benne' zaj zre̱'e̱ laní chee̱ wechaga na' dxácate̱ na' zua benne' wechaga na' nen le̱'? Dxácate̱ na' zua wechaga na' nen le̱' quebe gaca xelune̱' gubasa. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Wazrín tu zra gate dua benne' wechaga na'. Lu zra na' xelune̱' gubasa. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Quegá nu benne' xudé̱'e̱ tu ladxe' cube le̱'e̱ zradxu gula. Che ca'an gune̱', ladxe' cube da xudé̱'e̱ wazrube xu na da gula, na' wachézadxa na. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Cá'anqueze, quegá nu benne' que̱'e̱ xrise uva wal-la cube lu bzude xide gula. Che ca'an gune̱', na' xrise uva wal-la cube na' wacheza na bzude xide gula, na' walalaj xrise uva wal-la, ne cuía xi bzude xide na'. Xrise uva wal-la cube lu bzude xide cube dxal-la' chuzruj na. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Gate gudé Jesús naga ze̱ zrua' xtila zra dxulupá'ana benne' judío ca', ná'ate̱ na' benne' ca' dxuse̱de Jesús, ca zaj xu'e̱ neza, gulezú lawe̱' dxelíchaje̱' dau naga zria zrua' xtila. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nadxa benne' fariseo ca' gulé̱'e̱ Jesús: ―Gunná'xque. ¿Bizr chee̱ na' dxelune̱' zrin da quebe dxal-la' xelune̱' zra dxupá'anadxu? ");
INSERT INTO zatNTps_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús guzre̱' benne' ca': ―¿Cabata' ne gulábale ca da be̱n David gate gudune̱', ne bxázrjene̱' da gagu le̱', ne da gugawe̱' benne' ca' zaj zrále̱ne̱' le̱'? ");
INSERT INTO zatNTps_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Guxú'e̱ lu xu'u chee̱ Dios gate naca Abiatar bxruze blau, na' David gudawe̱' xeta xtila da dxelu'e̱ lau Dios, da quebe dxal-la' gagu benne' xula, san tuze bxruze ca' zaj naca chee̱' xelawe̱' na. Na' bnézrujte̱ David da gulagu benne' ca' zrále̱ne̱' le̱' chee̱ xeta xtila na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Cá'anqueze gunná Jesús, dxe̱'e̱ benne' ca': ―Dios gudíxruje̱' zra dxupá'anadxu chee̱ gaca ba neza chee̱ bénneache, quegá be̱ne̱' bénneache chee̱ xelune̱' zrin chee̱ zra dxupá'anadxu. ");
INSERT INTO zatNTps_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Chee̱ le̱ na', neda', Benne' Gulje̱' Bénneache, naca' xrane zra dxupá'anadxu. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Gate guxú'u Jesús da xula lu xu'u naga dxelúe lá'ana judío ca' Dios, ze̱ tu benne' biu nazrinnaj ne̱'e̱ ga na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Judío ca' buluzuzre̱' Jesús che xexune̱' benne' we̱' nigá lu zra dxulupá'ane̱', chee̱ xelezéquene̱' xelagu zria Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nadxa gunná Jesús, dxe̱'e̱ benne' biu na' nazrinnaj ne̱'e̱: ―Guxasa. Guzé̱ laduj benne' caní. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nadxa gunaba Jesús lau judío ca', dxe̱'e̱ le̱': ―¿Naca chee̱ zra dxupá'anadxu gundxu da xrlátaje, u che gundxu da cale̱la? ¿Waca gupá'adxu xel-la nabán chee̱ nu benne', u che guzría xidxu xel-la nabán chee̱'? Na' gulezúa zrize judío ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nadxa Jesús gunná zi'e̱ benne' ca'. Bewí'inene̱' ca naca xel-la lázrdau zide' chee̱'. Nadxa guzre̱' benne' nazrinnaj ne̱'e̱: ―Guchiluj na'u. Guchiluj ne̱'e̱, na' bexaca na. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ca'an guca, belexedxúaj benne' fariseo ca', na' belune̱' xel-la wezría nen benne' ca' zaj de̱'e̱ Herodes ájala xelútie̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nadxa gucuasa Jesús laduj benne' ca', na' guxíaje̱' dxu'a nísadau' nen benne' ca' dxusé̱dene̱'. Zjácale̱ benne' zan ca' Jesús, benne' chee̱ xe̱zre ca' zaj nababa Galilea. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Gate belén bénneache ca naca da zren ca' da dxun Jesús, belezrín benne' zan lau Le̱', benne' chee̱ xe̱zre ca' zaj nababa Judea, ne benne' xe̱zre Jerusalén, ne benne' chee̱ xe̱zre ca' zaj nababa Idumea, ne benne' gusá'aque̱' xechalá'a xe̱gu Jordán, ne benne' gusá'aque̱' xe̱zre ca' zaj naxechaj na xe̱zre Tiro, ne xe̱zre Sidón. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Chee̱ le̱ na' gunná be'e Jesús benne' ca' dxusé̱dene̱' xulucueze̱' tu da dxedá lawe' nísadau' checa xuluchide' bénneache zan Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Caní guca lawe' da bexún Jesús benne' zante̱, na' benne' we̱' ca' gulebigue̱' lau le̱' chee̱ cheajleté̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Gate be' xriwe̱' ca' zaj xu'u bénneache belelé'e na Jesús, na' buluzú zribe na lau Le̱', ne gulebezre xa'a na. Dxelenná na: ―Lue' nacu' Zri'ine Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesús gudil-le̱' be' xriwe̱' ca' chee̱ quebe xululé'e na da naca Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ca gudé na' guluén Jesús tu lu xi'a, na' gunné̱' benne' ca' guca lazre̱'. Na' gulebigue̱' lau Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Bchague̱' chazrinnu benne' xelune̱' Le̱' tuze, benne' sel-le̱' cheajlechálaje̱' xrtizra Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Bzue̱' lu na' benne' caní xel-la dxenná bea chee̱ xelexexune̱' benne' we̱' ca', ne chee̱ xelexebéaje̱' be' xriwe̱' ca' lu be̱l-la' dxen chee̱ bénneache ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Benne' chazrinnu caní zaj le̱': Simón, bénnea' bzua Jesús xetú le̱' Pedro, ");
INSERT INTO zatNTps_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ne Jacobo ne Juan, biche Jacobo, benne' ca' zaj naque̱' zri'ine Zebedeo. (Benne' chupa caní bzua Jesús le̱' Boanerges, da zéaje̱ na benne' wal-la ca guziu'.) ");
INSERT INTO zatNTps_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Bchague̱' Andrés ne Felipe, ne Bartolomé, ne Mateo, ne Tomás, ne Jacobo zri'ine Alfeo, ne Tadeo, ne Simón, benne' dxue lázrele̱'e̱ chee̱ lazrie̱', ");
INSERT INTO zatNTps_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ne Judas Iscariote, bénnea' xudée̱' Jesús lu na' benne' ca' dxeledábague̱' Le̱'. Ca gudé na' bzrin Jesús tu lu xu'u nen benne' ca' dxusé̱dene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Xecha lasa gulebiga bénneache zan naga zua Jesús, na' québedxa dxaca lataj xelawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Gate belene benne' xrtia Jesús ca da dxun Le̱', na' belezrine̱' chee̱ xelexeché̱'e̱ le̱'. Dxelenné̱': ―Quebe zua xrlátaje xichaj lázrdawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Cá'anqueze benne' ca' dxuluxuzájle̱'e̱ da nadxixruj bea Dios, benne' gusá'aque̱' Jerusalén, dxelenné': ―Benne' nigá zrague̱' Beelzebú, xrane be' xriwe̱' ca', na' ne̱ chee̱ xrane be' xriwe̱' ca' dxebéaje̱' be' xriwe̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nadxa gunné̱ Jesús benne' ca', na' bchálajle̱ne̱' le̱' tu da dxulé'e na. Dxenné̱': ―¿Wazeque Satanás da xriwe̱' xebéaj cuine na? ");
INSERT INTO zatNTps_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Che benne' dxelenná bea xelexaque̱' chupa la'a, quebe díaqueze xel-la dxenná bea chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Cá'anqueze che benne' zaj zre̱'e̱ tu lu xu'u xelaque̱' chupa la'a, quebe xeledíaqueze benne' zaj zre̱'e̱ lu xu'u na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Cá'anqueze, che Satanás tábaga cuínaqueze na, ne xexaca na chupa la'a, quebe díaqueze na. Wadéqueze chee̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Quebe nu seque chu'u lizre benne' wal-la chee̱ cuane̱' da de̱ chee̱' che quebe guchéaje̱' le̱' nédxula. Nadxa seque̱' cuane̱' da de̱ lizre benne' wal-la na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Da li dxennía', dxapa' le'e: Xúgute̱ dul-la da dxelún bénneache, ne dizra' schanni' da dxelenné̱', ájate̱ze zaj naca na, gunite láuqueze Dios chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Na'a, ca naca nútete̱ze benne' nne̱' schanni' chee̱ Be' Lá'azxa, cabata' gunite lau Dios chee̱ bénnea'. Webía xí'queze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Caní gunná Jesús lawe' da dxelenné̱': ―Zraga Jesús da xriwe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ca gudé na' bzrin xrna Jesús nen bi biche̱' ca'. Gulebeze̱' chalé'ajla, na' gulesel-le̱' tu benne' nne̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Benne' ca' zaj zre̱'e̱ cuita Jesús gulé̱'e̱ le̱': ―Xrna'u ne bi bichu' ca' zaj ze̱' chalé'ajla, dxelenné̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Gunná Jesús, dxe̱'e̱ benne' ca': ―¿Nézele nuzra na' xrna'a, ne bi bicha' ca'? ");
INSERT INTO zatNTps_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nadxa gunná' Jesús benne' ca' zaj zre̱'e̱ cuita Le̱', na' gunné̱': ―Benne' caní zaj zrále̱ne̱' neda' nigá zaj naque̱' ca xrnáqueza', ne bi bicha' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Caní naca na lawe' da xúgute̱ benne' dxelune̱' ca da dxaca lazre' Dios, benne' caní zaj naque̱' bi bicha' ca', ne bi zana' ca', ne xrna'a. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Xetú lasa guzú lau Jesús dxusé̱dene̱' benne' ca' dxu'a nísadau', na' belezraga bénneache zante̱ naga zue̱'. Naxánle̱'e̱ benne', na' be̱n na ba xen guxú'u Jesús tu lu da dxedá lawe' nísadau' da dxe na', na' gudxé'e̱ lu'ule da dxedá lawe' nísadau', na' bénneache zan ca' gulezré̱'e̱ dxu'a nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nadxa bchalaj Jesús da dxululé'e na, na' bsé̱dene̱' benne' ca' da zante̱. Ca dxusé̱dene̱' benne' ca', na' bchálaje̱' caní: ");
INSERT INTO zatNTps_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Le xene da nigá. Tu benne' dxaza dxa'ana zéaje̱' guza. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ca zéaje̱' dxaze̱', na' xeajlechaze bal-la bínnedu ca' dxu'a neza. Na' belezrín bxinne, ne guláguba' bínnedu caní. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Xezícadxa bínnedu ca' xeajlechaze na lu xiaj naga quebe dé̱teca xu. Bínnedu caní belezría na lawe' da quebe dé̱teca xu. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ca bdxuaj gubizra, na' bzezxe na le̱ na, na' lawe' da quebe zaj nun lue na lu da situj, gulebizre na. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Xezícadxa bínnedu ca' xeajlechaze na naga dxelezría xixre' xeche'. Xixre' xeche' caní gulegúladxa na ca le̱ na, na' bululule na le̱ na, na' quebe gulebía na da gágudxu. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Xezícadxa bínnedu ca' xeajlechaze na lu xu be̱be. Belezría na cháwedau', na' belegula na, ne gulezríale̱'e̱ na da gágudxu. Bal-la na gulebía na chi dxua tu tu na. Xebal-la na gulebía na ga xun tu tu na. Xebal-la na gulebía na tu gaxúa tu tu na. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Gunnadxa Jesús, dxe̱'e̱ benne' ca': ―Che nu benne' zua nague̱', dxal-la' xenne̱' da nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ca gudé na', ca gucuasa Jesús cuita benne' zan ca', na' gulenaba benne' ca' zrále̱ne̱' benne' ca' dxuse̱de Jesús bi zéaje̱ ca naca da dxulé'e nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Na' gunná Jesús, dxe̱'e̱ benne' ca': ―Dios dxunne̱' le'e lataj nézele ca naca chee̱ da nagache chee̱ da dxenná bea Le̱'. Na'a, ca naca chee̱ benne' ca' zaj zre̱'e̱ cúzrela, dxuchálajle̱na' le̱' dízra'ze da dxulé'e na. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Caní dxuna' lawe' da dxelenné̱'e̱, na' quebe dxelaca lazre̱' xelelé'ene̱'. Dxelenne̱', na' quebe dxelaca lazre̱' xeléajni'ine̱', chee̱ quebe xelexebí'i lazre̱', na' chu'u xel-la wenite lau chee̱ dul-la da za nabague̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Na' gunnadxa Jesús: ―¿Quebe dxéajni'ile ca naca da dxulé'e nigá? ¿Ájalaqueze chéajni'ile xezícadxa dizra' ca' da dxululé'e na? ");
INSERT INTO zatNTps_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Benne' dxaza dxá'ane̱' naque̱' benne' dxuchálaje̱' xrtizra Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bal-la bénneache zaj naque̱' ca bínnedu ca' xeajlechaze na dxu'a neza. Dxelenne̱' xrtizra Dios, na' ca dxedé na', dxezrín Satanás, na' dxucuasa na dizra' nigá da zua na xichaj lázrdau benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Benne' xula ca' zaj naque̱' ca bínnedu ca' xeajlechaze na lu xiaj. Ca dxelenne̱' xrtizra Dios, na' dxelebéle̱'e̱ne̱' dxelezi'e̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tu chí'idauze dxelune̱' caní. Gate dxeledée̱' xel-la zi', ne zua da dxedábaga le̱' ne̱ chee̱ xrtizra Dios, na' dxelexecuase̱' lawe' da quebe guxaze xrtizra Dios lú'ulete̱ xichaj lázrdawe̱' ca guca chee̱ bínnedu ca' quebe belún lue na lu xu situj. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Benne' xula ca' zaj naque̱' ca bínnedu ca' xeajlechaze na ládujla xixre' xeche' ca'. Dxelenne̱' xrtizra Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Lawe' da dxelebe'dxe̱' gunne xue da naca chee̱ xe̱zr la xu nigá dxezí xe̱ xel-la gunní'a le̱', na' dxelezá lazre̱' da zante̱ da dxelelé'ene̱'. Xúgute̱ da caní dxelú'u na xichaj lázrdau benne' caní, na' xuluxunite na dizra' da guxú'u xichaj lázrdawe̱', na' quebe gaca gun na ca da dxal-la' gun dizra' nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Zaj zra' benne' dxelenne̱' xrtizra Dios, ne dxelezí' lu ne̱'e̱ na. Bal-le̱' zaj naque̱' ca bínnedu ca' gulebía na chi dxua tu tu na. Benne' xula zaj naque̱' ca bínnedu ca' gulebía na ga xun tu tu na. Benne' xula zaj naque̱' ca bínnedu ca' gulebía na tu gaxúa tu tu na. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Cá'anqueze gunná Jesús, dxe̱'e̱ benne' ca': ―¿Gúadxu xi', ne guzúadxu na zran xi'ina u che zran ga dxásedxu? Quebe gundxu ca', san guzúadxu na sibe chee̱ gusení na. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Xúgute̱ da nagache gulé'e lawe na, na' xúgute̱ da xu'u xichaj lázrdaudxu wénqueze na. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Che nu benne' zua nague̱', dxal-la' xenne̱' da nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Cá'anqueze gunná Jesús: ―¡Le xene xanne' ca da dxénele! Ca da dxudxíxrele, nen le̱ na' gudxíxrequeze Dios chee̱le, na' gúnnadxe̱' le'e dxénele. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Caní gaca na, benne' nape̱' da naca chee̱ xrtizre̱'e, gunézrujdxe̱' chee̱', na' benne' quebe bi nape̱', ca da dauze da nape̱' xecá'ate̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Na' gunnáqueze Jesús: ―Da dxenná bea Dios naca na ca da dxaca gate tu benne' dxaze̱' bínnedu ca' lu xu. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Dxásie̱' chizrela, dxase̱' te zra, na' bínnedu caní dxelezría na, ne dxelegula na, ne quegá nézene̱' ájala. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Dxaca na caní lawe' da nácaqueze ca da dxun xe̱zr la xu. Nedxu dxebía na xrlegue na, nadxa za dau, na' bzé̱bete̱ dxebía na bínnedu ca' lu dau. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Gate ba gulegula xíxredu caní, na' dxechugue̱' na lawe' da ba bzrin zra xequé̱'e̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Cá'anqueze gunná Jesús: ―¿Ájala gutil-la lé̱bedxu da dxenná bea Dios, u che bila dizra' da dxulé'e na cá'adxu da gutil-la lé̱bedxu le̱ na? ");
INSERT INTO zatNTps_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Naca na ca tu binne mostaza da dxázadxu lu xu. Bínnedu nigá nácadxa cuide' ca da zaj nnita lu xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Gate ba gúzadxu na dxegula na, na' dxaca na da zrendxa ca xixre' ca' da zaj naca na ba dagu, na' dxebía zruze na zren, na' dxácate̱ dxelebía bxínnedu ca' zran zrula chee̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Caní bse̱de Jesús benne' ca' xrtizra Dios, na' bchálaje̱' zánete̱ da dxululé'e na caní, cadite̱ guléajni'ine̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Quebe bchálaje̱' da xula. Tuze dizra' da dxulé'e na bchálajle̱ne̱' benne' ca'. Bzájla'adxe̱' ca naca na benne' ca' dxusé̱dene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lu zra ná'queze, ca gul-la chizrela, na' gunná Jesús, dxe̱'e̱ benne' ca' dxusé̱dene̱': ―Chéajdxu xecha la'a nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Besá'aque̱' naga zaj zra' benne' zan ca', na' guleché̱'e̱ Jesús lu da dxedá lawe' nísadau' naga ba dxé'queze̱', na' gulennita xezícadxa da ca' dxeledá lawe' nísadau' ca' naga zaj zra' benne', na' xjácale̱ne̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nadxa guzú lau dxaca tu be' bdunu' lu nísadau' na', na' dxu'ute̱ nisa lu da dxedá lawe' nísadau'. Caní guca guzú lau dxezrá nisa lu da dxedá lawe' nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús de̱' dxasie̱' lu xcúgüe̱' naga nácadxa sibe lu da dxedá lawe' nísadau'. Na' bulusebane̱' Jesús, dxelé̱'e̱ Le̱': ―Benne' wese̱de, ¿quebe dxe'u gunne xue wátedxu nate ca na'a? ");
INSERT INTO zatNTps_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nadxa guxasa Jesús, na' bchálajle̱ne̱' be' bdunu', ne nísadau'. Dxenné̱': ―¡Gudxé zri'! ¡Zrize guzúa! Gudxé zri' be' bdunu', na' nísadau' guzúa zri na. ");
INSERT INTO zatNTps_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nadxa gunná Jesús, dxe̱'e̱ benne' ca' dxusé̱dene̱': ―¿Bizr chee̱ na' dxezrébele̱'e̱le le'e? ¿Quebe dxeajlí lázrele Dios? ");
INSERT INTO zatNTps_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Belezrébele̱'e̱dxe̱', ne dxelé̱ ljwezre̱': ―¿Núzraqueze benne' nigá? Dxuluzúa dizra' be' bdunu', ne nísadau' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Bezrín Jesús, tu zren nen benne' ca' dxusé̱dene̱' xecha la'a nísadau' lu xe̱zr la xu chee̱ benne' Gadara ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ca bedxúaj Jesús lu da dxedá lawe' nísadau', na' bzrin tu benne' xu'e̱ be' xriwe̱' naga zua Jesús. Bedxúaje̱' lu bluaj naga zaj nagache benne' gate ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Benne' biu nigá zúaqueze̱' lu bluaj na'. Quebe nu dxezúe guchéaj le̱be' chalásaze, lácala nu guchéaj le̱be' nen du xia. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Zane' lasa buluchéaje̱' le̱be' nen du xia na'abe', ne ní'abe'. Bzúzrujbe' du xia ca', na' quegá nu guzeque nna bé'ene̱' le̱be'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dxedáquezebe' te zra chizrela lu xi'a ca', ne lu bluaj ca' naga zaj nagache benne' gate. Dxebezre xa'abe', ne dxeajcházebe' lu xiaj ca', dxun we̱' cuínabe'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Gate ble'ebe' zítu'la ba za Jesús, na' guzá chégube', xeajzú zríbebe' lau Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Gunné̱ zizraj be' xriwe̱' xu'ube', dxe̱ na Jesús: ―¿Bizra dxaca chiu' nen neda', Jesús, Zri'ine Dios szrente̱? Lu La Xránadxu Dios, dxata' xueda' Lue', quebe gudéu' neda' xel-la zi'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Caní gunná na lawe' da gunná Jesús, dxe̱'e̱ na: ―Lue', da xriwe̱', bedxúaj lu be̱l-la' dxen chee̱ benne' nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nadxa gunaba Jesús, dxe̱'e̱ na: ―¿Bi leu'? Na' beche̱be na: ―Da Zan lea', lawe' da naxantu'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Guta' xue na Jesús chee̱ quebe xesel-le̱' na, ne quebe gucuase̱' na zitu' lu xe̱zr la xu na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Zaj zra' gagu lu xi'a na' tu cue' cuche zaj zraba' dxeláguba'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Gulata' xue be' xriwe̱' ca' Jesús, gulenná na: ―Besel-la netu' lu cuche ca'. Be̱nna lataj chú'untu' le̱ba'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nadxa Jesús be̱'e̱ na lataj. Na' be' xriwe̱' ca' beledxúaj na lu bénnea', na' gulú'u na cuche ca'. Zaj nácaba' ca galaj gaxúa cuche ca', na' buludxixre cuínaba' tu chejéa. Xeajlecháste̱ba' lu nísadau', ne gulátete̱ba' lu nisa na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Benne' ca' dxuluxúe̱' cuche ca' buluxuzrúnnuje̱', na' xeajlezenne̱' benne' zaj zre̱'e̱ lu xe̱zre, ne benne' zaj zre̱'e̱ le̱'e̱ xixre'. Na' belezrín benne' ca' naga zua Jesús, benne' ca' belenne̱' ca da ba guca. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Gate belezrín benne' ca' naga zua Jesús, na' belelé'ene̱' bénnea' guxú'ube' be' xriwe̱' ca', dxe'ebe' ga zua Jesús, nácube' tu ladze', ne ba bezúa xrlátaje lu xichaj lázrdaube', na' gulezrebe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Benne' ca' belelé'e ca naca da guca chee̱ benne' guxú'ube' be' xriwe̱' ca', ne ca guca chee̱ cuche ca' buluchálaje̱' chee̱ da ba guca. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nadxa benne' xe̱zre ca' gulata' xuene̱' Jesús xedxúaje̱' lu xe̱zr la xu chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ca bexú'u Jesús lu da dxedá lawe' nísadau', na' bénnea' guxú'ube' be' xriwe̱' ca' guta' xuebe' Jesús gu'e̱ lataj chéajle̱be' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Quebe be̱' Jesús le̱be' lataj, san dxe̱'e̱ le̱be', gunné̱': ―Bexiaj lizru', ne xeajchálajle̱ xrtiu' ca' ca naca da zren ca' da be̱n Xranu' nen lue', ne ca bexache lazre̱' lue'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nadxa bezá'abe' zexíajbe', ne guzú laube' dxuchálajbe' lu xe̱zre ca' zaj nababa Decápolis ca naca da zren da be̱n Jesús nen le̱be'. Belexebánele̱'e̱ xúgute̱ benne' zaj zre̱'e̱ xe̱zre ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Begüén Jesús lu da dxedá lawe' nísadau', na' bezrine̱' xecha la'a nísadau'. Belezrín benne' zan naga ze̱', na' Le̱' begá'ane̱' dxu'a nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ca'an guca bzrin tu benne' xíchaje̱ chee̱ xu'u naga dxelúe lá'ana judío ca' Dios, benne' le̱' Jairo. Gate blé'ene̱' Jesús, na' bzu zribe̱' zran ni'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Guta' xuene̱' Jesús, dxe̱'e̱ Le̱': ―¡Bi nu'ula chia' ba dxátebe'! ¡Gudá, bze̱ na'u le̱be' chee̱ xexácabe', ne xaca banbe'! ");
INSERT INTO zatNTps_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nadxa guxíajle̱ Jesús bénnea', na' bénneache zan xjácale̱ne̱' Le̱', ne dxuluchítee̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ládujla bénneache ca' za tu nu'ula quebe chawe' zue̱', ba zeaj chazrinnu iza nape̱' we̱' dxen. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Da zren da bulusaca benne' dxelexún bénneache ca' nu'ula nigá, na' bache be̱n dítaje̱' xúgute̱ da nape̱'. Quegá bi gúcale̱ na le̱', san bzáladxa we̱' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Gate ben nú'ula' dxuluchalaj bénneache ca naca chee̱ Jesús, na' bzrine̱' cúzrula Jesús ládujla bénneache, na' xeajté̱' zra lana Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Caní be̱ne̱' lawe' da gunné̱' lu xichaj lázrdawe̱': Cun cheajtaza' zra lana Jesús, na' xexácatea'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","La gulézate̱ xel-la we̱' chie̱', ne la guque bé'ete̱ne̱' ba bexaca be̱l-la' dxen chee̱' chee̱ xízrawe̱' na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Gúquebe'e Jesús be̱n zrin xel-la waca chee̱'. Chee̱ le̱ na' bexéchaje̱', dxenné̱'e̱ bénneache ca', na' gunábene̱' le̱': ―¿Nuzra bedajtá zra lana'? ");
INSERT INTO zatNTps_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nadxa benne' ca' dxuse̱de Jesús gulé̱'e̱ Le̱': ―Dxelé'equeznu' bénneache zan dxuluchíe̱' Lue'. ¿Bizr chee̱ na' dxenabu': “Nuzra bedajtá neda'?” ");
INSERT INTO zatNTps_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesús guzúe̱' dxenné̱'e̱ cuite̱' chee̱ lé'ene̱' nua' bedajtá Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nadxa guxíaj nu'ula nigá, dxezrízie̱' dxezrebe̱' lawe' da nézene̱' ca da ba guca chee̱', na' bzu zribe̱' lau Jesús, na' gunné̱' ca naca da li. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nadxa gunná Jesús, dxe̱'e̱ nu'ula': ―Bi nú'uladau', ba bexacu' lawe' da guxeajlí lazru' neda'. Bexíaj, cútudxa zrebu'. Ba bexácate̱quezu' chee̱ xízrawe̱' da guzxacu'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ne dxuchálajte̱ Jesús gate belezrín benne' gusá'aca lizre benne' xíchaje̱ chee̱ xu'u naga dxelúe lá'ana judío ca' Dios, na' gulé̱'e̱ xra nú'uladau' na': ―Bi nú'uladau' chiu' ba gútebe'. ¿Bizr chee̱ na' dxunu' zé̱dedxa benne' dxuse̱de nigá? ");
INSERT INTO zatNTps_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Gate Jesús benne̱' ca da gulenná benne' caní, dxe̱'e̱ benne' xíchaje̱ chee̱ xu'u na', gunné̱': ―Quebe zrebu'. Guxeajlí lazre' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Quebe be̱'e̱ lataj chjácale̱ bénneache zan ca' Le̱'. Tuze be̱'e̱ lataj gusá'acale̱ Pedro, ne Jacobo, ne Juan, biche Jacobo nigá, nen Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ca belezrine̱' lizre benne' xíchaje̱ na', na' ble'e Jesús bénneache dxelún schaga. Dxelebezre benne', ne dxelebezre xa'ate̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nadxa guxú'u Jesús lu xu'u, na' dxe̱'e̱ benne' ca', gunné̱': ―¿Bizr chee̱ na' dxunle schaga? ¿Bizr chee̱ na' dxebézrele? Quegá nate bidau' nu'ula. Dxásezebe'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Belún lala benne' ca' chee̱'. Nadxa Jesús bebéaje̱' xúgute̱ benne' ca', na' guché̱'e̱ xrabe', ne xrna bidau' nigá, ne benne' ca' zjácale̱ne̱' Le̱', na' guxú'e̱ naga de̱ nú'uladu na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Bé̱xrue̱' na'be', ne guzre̱' le̱be': ―Bi nú'uladau', lue' dxapa': ¡Guxasa! ");
INSERT INTO zatNTps_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","La bexásate̱ nú'uladu na', na' guzáte̱be' lawe' da ba zéajbe' chazrinnu iza. Na' benne' ca' zaj zre̱'e̱ lu xu'u na' belezrébele̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesús gunná bé'ene̱' benne' ca' chee̱ quebe nu xelé̱'e̱ ca da be̱ne̱'. Nadxa guzré̱' benne' ca' xulugawe̱' nú'uladu na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús bezé̱'e̱ naga zue̱', ne bezrine̱' lazrie̱', na' benne' ca' dxusé̱dene̱' xjácale̱ne̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ca gula zra dxulupá'ana judío ca', na' bezú lau Jesús dxusé̱dene̱' benne' ca' zaj zre̱'e̱ lu xu'u naga dxelúe lá'ana judío ca' Dios. Bénneache zan belenne̱' chee̱', ne belexebánene̱', dxelenné̱': ―¿Gazra bse̱de benne' nigá ca nácate̱? ¿Bizra xel-la sina da nunezruj Le̱', ne xel-la waca zren caní da dxune̱'? ");
INSERT INTO zatNTps_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Quegá benne' nigá gubizre xaga, zri'ine María, na' benne' biche̱' ca' zaj naque̱' Jacobo, ne José, ne Judas, ne Simón, na' nu'ula zane̱' ca' cá'anqueze zaj zrále̱ne̱' dxi'u? Chee̱ le̱ na' quebe guléajle̱'e̱ chee̱ Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Na' gunná Jesús, dxe̱'e̱ benne' ca': ―Xúgute̱ benne' dxelape̱' ba lá'ana tu benne' dxuchálaje̱' waláz chee̱ Dios, san benne' walázr chee̱' ca', ne benne' xrtie̱' ca', ne benne' zaj zre̱'e̱ xu'u lizre̱' quebe dxelape̱' le̱' ba lá'ana. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Chee̱ le̱ na' quebe be̱n Jesús lazrie̱' na' netú xel-la waca zren. Tuze bexune̱' bál-laze benne' we̱' gate na' guxrúa ne̱'e̱ xichaj benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Bebane Jesús lawe' da quebe guléajle̱'e̱ chee̱'. Ca gudé na' bedé Jesús xecha lasa xé̱zredu ca' zaj nnita gáguze, na' bsé̱dene̱' benne' zaj zre̱'e̱ ga na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Gunné̱' benne' chazrinnu dxusé̱dene̱', ne guzú lawe̱' dxesel-le̱' le̱' chupa weaje̱', ne bnézruje̱' le̱' xel-la waca xulucuase̱' be' xriwe̱' ca' lu be̱l-la' dxen chee̱ bénneache ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Gunná bé'ene̱' le̱' quebe bi xelu'e̱ chee̱ la neza, con tuze xaga da xuluchiche̱'. Quebe xelu'e̱ xixruj xeta, ne xeta, ne dumí. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Waca xululéaje̱' zrele̱', ne xelácue̱' tu cueze zra lane̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Gunnadxa Jesús, dxe̱'e̱ benne' ca': ―Gate na' chu'ule le'e tu lu xu'u chee̱ benne', waca xegá'anate̱le lizre bénnea' ca zrindxa zra xezá'ale lu xe̱zre na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Che zrinle tu lu xe̱zre naga quebe xuluxé lawe̱' le'e, ne quebe xelénene̱' chee̱le, waca xezá'ale, na' cuíbete̱le bxrte xu da dxedá' ní'ale. Da nigá gaca na tu da dxulé'e na zaj nabaga benne' xe̱zre na' zria, benne' dxeledábaga' le'e. Da li dxennéa', lu zra guchi'a Dios chee̱ bénneache, waxache' gácadxa da ba xa' da xeledé benne' xe̱zre Sodoma, ne benne' xe̱zre Gomorra quézcala da xeledé benne' xe̱zre ca' naga quebe buluzé̱ nague̱' chee̱le. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nadxa gusá'aca benne' ca' dxuse̱de Jesús, na' buluchálajle̱ne̱' bénneache chee̱ xelexebí'i lazre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Cá'anqueze belexebéaje̱' zánete̱ be' xriwe̱' ca' lu be̱l-la' dxen chee̱ bénneache ca', na' gulegüe̱'e̱ da za zane' benne' we̱', na' belexexaque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Na' ben wenná bea Herodes ca naca da zren ca' da dxun Jesús lawe' da guzé̱ dizra' chee̱'. Bal-la benne' dxelenné̱': ―Juan, benne' bchue̱' bénneache nisa, bache bebane̱' ládujla benne' gate, na' chee̱ le̱ na' nape̱' xel-la waca zren nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Benne' xula dxelenné̱': ―Elías, bénnea' bchálaje̱' waláz chee̱ Dios benne' nigá. Benne' xula dxelenné̱': ―Nácalje̱' bénnea' dxal-la' xelá' guchálaje̱' waláz chee̱ Dios, che nácalje̱' benne' gulasa, benne' bchálaje̱' waláz chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ca ben Herodes da caní, na' gunné̱': ―Benne' nigá naque̱' Juan, bénnea' gunná be'eda' neda' gulechugue̱' xíchaje̱'. Benne' nigá ba bebane̱' ládujla benne' gate. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Caní gunná Herodes lawe' da gunná be'e le̱' buluzúe̱' Juan na' lizre xia, ne buluchéaje̱' le̱' du xia, da na' be̱ne̱' lawe' da dxezrá'a Herodías le̱'. Herodías nigá guque̱' zru'ula Felipe, benne' biche Herodes. Herodes nigá bequé̱'e̱ nu'ula' chee̱ guque̱' zru'ule̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Gunná Juan, dxe̱'e̱ Herodes: ―Quebe dxal-la' súale̱nu' zru'ula bi bichu'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Chee̱ le̱ na' Herodías guzré̱'e̱ Juan, ne guca lazre̱' gútete̱' le̱'. Quebe guca chee̱' ");
INSERT INTO zatNTps_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","lawe' da neze Herodes naca Juan nigá tu benne' xrlátaje, ne benne' naque̱' tuze nen Dios, na' bezrebe̱' le̱'. Chee̱ le̱ na' quebe be̱'e̱ lataj Herodías na' gútete̱' Juan nigá, na' lácala quebe guxéajni'ine̱' ca naca xúgute̱ da bchalaj Juan, Herodes nigá bze̱ nague̱' chee̱' du lazre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodías na' bzrélene̱' ájala gune̱' ca da dxaca lazre̱' gate na' guxú'u laní ca gula la Herodes. Gulé'aj gulagu benne' xíchaje̱ ca', ne benne' dxelenná be'e̱ lu wedil-la, ne benne' zaj naque̱' blau lu xe̱zre ca' zaj nababa Galilea. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nadxa guxú'u bi nu'ula chee̱ Herodías na' lu xu'u naga dxelé'aj dxelawe̱', ne bxá'abe' lau benne' ca'. Bezaca ba lazre' Herodes ca bxá'abe', ne tuze ca belún benne' ca' zaj zra' dxelawe̱' tu zren nen le̱'. Gunná wenná bea Herodes, dxe̱'e̱ nu'ula cuide' nigá: ―Gunaba neda' ca da dxedánenu', na' gunna' na chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Guche̱be lazre' Herodes, ne bzétaje̱' Dios gunézruje̱' bítete̱ze da nábabe', lácala nábabe' gáchajte̱ naga dxenná be'e̱ le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nadxa nu'ula cuide' nigá bdxúajbe', xeajchálajle̱be' xrnabe', gunabe': ―¿Bizra naba'? Gunná xrnabe': ―Gunaba xichaj Juan, bénnea' bchue̱' bénneache nisa. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","La guxu'ute̱ nu'ula cuide' nigá naga zua wenná bea, na' gunabe', dxe̱'e̱be' le̱': ―Dxaca lazra' gunnu' neda' na'a tu lu xé'ena xichaj Juan, bénnea' bchue̱' bénneache nisa. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nadxa wenná bea nigá bewí'inele̱'e̱, ne lawe' da ba bzétaje̱' Dios, na' belénete̱ benne' ca' da gunné̱', quebe guca lazre̱' guzrune̱' ca da gunaba bi nu'ula nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chee̱ le̱ na' gusel-la wenná bea tu benne' dxeje̱' wedil-la, ne gunná bé'ene̱' le̱' cheajxrí'e̱ xichaj Juan na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Guxíaj benne' nigá lu xu'u lizre xia, na' bdxixre̱' xichaj Juan na', ne bexu'e̱ na tu lu xé'ena. Bnézrujte̱' na bi nu'ula na', na' le̱be' bnézrujbe' na xrnabe'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Gate gulénneze benne' ca' da nigá, benne' ca' bse̱de Juan, na' xeajlexexrí'e̱ be̱l-la' dxen chee̱', na' xeajlecáchete̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ca gudé na' belexezrín benne' gubáz ca' chee̱ Jesús naga zua Le̱', ne buluzenne̱' Le̱' xúgute̱ ca da belune̱', ne ca da bulusé̱dene̱' benne' ca' naga xjaque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nadxa gunná Jesús, dxe̱'e̱ benne' ca': ―Le chu'u. Chéajdxu xezí' lázredxu chadite' naga xu'u lataj. Gunné̱' caní lawe' da dxesá'aca benne' dxesá'aca, ne dxelexezrín benne' dxelexezrín, na' quebe dxelu'e̱ lataj xelawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nadxa Jesús ne benne' gubáz chee̱' ca' belexexú'e̱ le̱ze̱' tu lu da dxedá lawe' nísadau', na' belezrine̱' tu lataj naga quebe nu chilá' benne'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Benne' zan ca' belelé'ene̱' ca zjaque̱', ne belexexúnbe'e̱ Jesús, na' gusá'aca chégüe̱' xjá'aque̱' na'. Benne' xúgute̱ xe̱zre ca' belezrine̱' lataj na' nédxudxa ca Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Gate bedxúaj Jesús lu da dxedá lawe' nísadau', na' blé'ene̱' benne' zante̱, ne bexache lazre̱' le̱' lawe' da zaj zre̱'e̱ ca zrila' ca' quebe zua benne' dxuxúe̱' le̱ba'. Na' guzú lawe̱' dxusé̱dene̱' benne' ca' da zante̱. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ca gula guzré', belezrín benne' ca' dxuse̱de Jesús lau Le̱', na' gulé̱'e̱ Le̱': ―Ba dxaca waxrinne, na' quegá nu lizre benne' zua lataj nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Besel-la benne' caní chee̱ cheajxaque̱' xe̱zre ca' zaj nnita gálaze chee̱ xelezí'e̱ xeta xelawe̱' lawe' da quebe bi de̱ nigá da xelawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Na' gunná Jesús, dxe̱'e̱ le̱': ―Le gunezruj le'e da xelawe̱'. Na' gulenné̱', dxelé̱'e̱ Jesús: ―¿Waca chéajntu' cheajgá'untu' xeta xtila, quízrujntu' lazruj chee̱ chupa gaxúa zra chee̱ gugágudxu benne' zan caní? ");
INSERT INTO zatNTps_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Na' gunná Jesús, dxe̱'e̱ le̱': ―¿Bal-la xeta xtila nápale? Le cheajnná'. Ca gulenézene̱', na' gulenné̱', dxelé̱'e̱ Jesús: ―Gazxu' xeta xtila, ne chupa béladau'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nadxa gunná be'e Jesús gulebé'e xúgute̱ bénneache ca' tu cue' weaj lu xrguíe xa'a. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Na' gulebé'e̱ tu cue' weaj, du tu gaxúe̱', du chi xune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nadxa Jesús bé̱xrue̱' gazxu' xeta xtila ca', ne da chupa béladau'. Na' guchisa lawe̱' xabaala, gunabe̱' lau Dios gun la'azxe̱' na, na' bzúzruje̱' xeta xtila ca', ne bnézruje̱' na benne' ca' dxusé̱dene̱' chee̱ gulísie̱' na chee̱ benne' ca'. Cá'anqueze gudísie̱' da chupa béladau' chee̱ xúgute̱ benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Na' gulagu xúgute̱' ne gulélajte̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nadxa buluxutube̱' ca da begá'ana chee̱ xeta xtila, ne chee̱ béladu ca', na' guca chazrinnu xcuite xca'a. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Benne' ca' gulawe̱' xeta xtila ca' zaj naque̱' chi xun gaxúa benne' biu. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","La gunná bé'ete̱ Jesús benne' ca' dxusé̱dene̱' gulu'e̱ lu da dxedá lawe' nísadau' chee̱ gulelague̱' nísadau' na' nédxudxa ca Le̱', chee̱ xelexezrine̱' lu xe̱zre Betsaida dxácate̱ Le̱' dxuzé̱' dizra' bénne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ca gudé bze̱' dizra' benne' ca', na' guzé̱'e̱ zéaje̱' lu xi'a zeajchálajle̱ne̱' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Gate gula guxrínnequeze, ba zeaj da dxedá lawe' nísadau' na' gachaj lawe' nísadau', na' begá'ana Jesús tuze̱' lu xu dxu'a nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Gate blé'ene̱' ca dxelezraga lawe̱' dxulusé̱'e̱ da dxedá lawe' nísadau' lawe' da za be' na', dxuzrí'i na da dxedá lawe' nísadau' na', na' gula balá' gubiga Jesús naga zaj zre̱'e̱, dxezé̱'e̱ lawe' nísadau' na', ne guca lazre̱' tée̱' lau da dxedá lawe' nísadau' na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Gate belelé'ene̱' Le̱' ze̱'e̱ lawe' nísadau' na', guléquene̱' da dxedá dxe̱la, na' gulebezre xe̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Belelé'e xúgute̱' ca dxezé̱'e̱ lawe' nísadau', na' belezrébele̱'e̱. Na' gunná Jesús, dxe̱'e̱ benne' ca' dxusé̱dene̱': ―Ga zrébele. Neda' nigá. Le gun chuchu lázrele. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nadxa guluén Jesús lu da dxedá lawe' nísadau' naga zaj zre̱'e̱, na' guleza be' na'. Na' guleque zréajene̱', ne belexebánele̱'e̱ne̱', ");
INSERT INTO zatNTps_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","lawe' da quebe ne xeléajni'ine̱' ca naca xel-la waca zren da be̱ne̱' chee̱ xeta xtila ca', lawe' da ne dxun zide' xichaj lázrdawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Gate na' gulelague̱' nísadau', belezrine̱' lu xe̱zr la xu chee̱ benne' xe̱zre Genesaret, na' buluchéaje̱' xaga da dxedá lawe' nísadau' dxu'a nísadau' na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ca beledxúaje̱' lu da dxedá lawe' nísadau', la belexexúnbeate̱ bénneache ca' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","La gusá'aca chégute̱' zjaque̱' lu xe̱zre ca' xeajlexrí'e̱ benne' we̱' ca' tu tu lu ta'a, na' zeajlegüé̱'e̱ le̱' naga zaj nézene̱' xedé Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Gátete̱ze xé̱zredu ca', ne xe̱zre ca', ne le̱'e̱ xixre' naga dxedé Jesús, na' buluzúe̱' benne' we̱' ca' du la neza, ne gulata' xuene̱' Jesús gunézruje̱' lataj cheajletaze̱' zra lane̱', na' xúgute̱ benne' ca' xeajleté̱' zra lane̱' belexexácate̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Benne' fariseo ca' nen bal-la benne' dxuluxuzájle̱'e̱ da bdxixruj be'e Moisés, benne' gusá'aque̱' Jerusalén, belezríne̱' lau Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Benne' caní belelé'ene̱' ca dxelún bal-la benne' dxuse̱de Jesús, dxelawe̱' xeta ne quebe zaj naxibe ne̱'e̱ ca dxelenná bea benne' xudau' ca'. Chee̱ le̱ na' gulenná benne' Jerusalén ca': ―Zaj naca sban na' benne' ca' dxuse̱de Jesús. Nadxa gulezí tizre̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Caní gulenná benne' ca' lawe' da zjácale̱ benne' xudau' fariseo ca', ne xúgute̱ benne' judío ca' ca naca da belún xra xtau benne' ca', quebe dxelawe̱' xeta che quebe zaj naxibe ne̱'e̱ zane' lasa. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Gate zjaque̱' lawe' xi'a wa'u, ca dxelexezrine̱' quebe dxelawe̱' xeta che quebe xelibe ne̱'e̱ ca zaj nadxixruj bea benne' xudau' ca'. Cá'anqueze de̱dxa da zante̱ da zjácale̱ne̱', ca xexadxe zriga' da dxelé'aje̱', ne zruaga, ne zriga xé'ena, ne da naga dxelásie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nadxa benne' fariseo ca', ne benne' ca' dxuluxuzájle̱'e̱ da bdxixruj be'e Moisés gulenábene̱' Jesús: ―¿Bizr chee̱ na' quebe zjácale̱ benne' ca' dxusé̱denu' ca naca da gulún benne' gula? Dxelawe̱' xeta, zaj naca sban ne̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Na' beche̱be Jesús: ―Láweze dxunle da xrlátaje. Lu lázrdaule xu'ule da cale̱la. Cháwedau' bchálajqueze Isaías ca nácale le'e gate na' bzuaje̱' caní: Bénneache caní dxelúe lá'ane̱' neda' nen dxú'aze̱'. Xichaj lázrdawe̱' ca' zaj nacuasa na neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Níteze naca xel-la ba lá'ana da dxelu'e̱ neda', lawe' da dxulusé̱dene̱' da zaj nadxixruj bea bénneacheze. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Caní naca xca', le'e dxuzúale chalá'ala ca da nadxixruj bea Dios, na' zéajle̱le ca naca da gulún bénneache ca dxíbele zruaga, ne zriga' chee̱le, ne zánete̱ da caní da dxunle. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Na' gunnadxe̱', dxe̱'e̱ benne' ca': ―Chala'ala dxuzúale ca da nadxixruj bea Dios chee̱ zéajle̱le ca naca da tu dxúnzquezle. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Caní gunná Moisés na': “Gudapa ba lá'ana xra xrna'u.” Cá'anqueze gunné̱': “Che tu benne' nne̱' schanni' chee̱ xre', che xrne'e̱, con gátequeze bénnea'.” ");
INSERT INTO zatNTps_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Le'e dxennale, “Che tu benne' xe̱'e̱ xra xrne̱'e̱: Corbán,” da zéaje̱ na, quebe gaca gácale̱na' le'e lawe' da bache bnézruja' chee̱ Dios ca naca da de̱ chia'. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Che ca'an dxenné̱', nadxa le'e québedxa dxu'ule le̱' lataj gácale̱ne̱' xra xrne̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Gate dxunle caní dxuzúale chalá'ala xrtizra Dios, chee̱ gunle ca da zéajle̱le. Na' zéajquezle dxunle zánete̱ da zaj naca na caní. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Xecha lasa gunné̱ Jesús bénneache ca', na' gunné̱', dxe̱'e̱ le̱': ―Le guzé̱ nágale xúgute̱le, ne le chéajni'i. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Netú da dxe'aj dxagu benne' quebe seque gucá'ana na le̱' sban. Da dxedxuaj na lu xichaj lázrdau bénneache, le̱ na' dxucá'ana na le̱' sban. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Le'e zua nágale, le xene. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Gate gucuasa Jesús naga zaj zra' benne' ca', na' guxú'e̱ lu xu'u. Nadxa benne' ca' dxusé̱dene̱' gulenábene̱' Le̱' ca naca chee̱ da dxulé'e nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nadxa gunná Jesús, dxe̱'e̱ le̱': ―¿Cá'anqueze le'e quebe dxéajni'ile? ¿Quebe dxéajni'ile xúgute̱ da dxe'aj dxagu bénneache quebe seque gucá'ana na le̱' sban ");
INSERT INTO zatNTps_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","lawe' da quebe dxu'u na lu xichaj lázrdawe̱'. Dxu'u na lu le̱'e̱, na' dxedxuaj na? Cate' gunná Jesús caní blé'ene̱' zaj naca chawe' xúgute̱ da dxe'aj dxágudxu. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Na' gunnadxe̱': ―Ca naca da dxedxuaj na lu xichaj lázrdau bénneache, le̱ na' dxucá'ana na le̱' sban ");
INSERT INTO zatNTps_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","lawe' da lu xichaj lázrdau bénnea' dxeledxúaj ca da cale̱la da dxuwía lazre̱', ne dul-la da dxucá'ana ditaj xel-la wechaga na', ne dul-la chee̱ da sban, ne we̱te benne', ");
INSERT INTO zatNTps_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ne xel-la gubán, ne da dxezá lazre' gapa da naca chee̱ benne' xula, ne da cale̱la ca', ne xel-la wezrí xe̱', ne da dxezá lazre' da sban, ne xel-la zre̱'e lazre', ne xel-la wechalaj dizra' bizruj, ne xel-la dxun szren cuina, ne xel-la dxuchalaj bigaze. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Xúgute̱ da cale̱la caní dxeledxúaj na lu xichaj lázrdau bénneache, ne dxuluxrinnaj na le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Na' bezá'a Jesús naga zue̱', guxíaje̱' lu xe̱zre ca' zaj nababa xe̱zre Tiro, ne xe̱zre Sidón. Guxú'u Jesús tu lu xu'u, ne quegá guca lazre̱' nu xene. Quebe guca gache̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","La gunézete̱ tu nu'ula zua Jesús na'. Nu'ula nigá zua tu zrí'ine̱' nu'ula, xu'ube' be' xriwe̱'. Bla' nu'ula' naga zua Jesús, ne bzu zribe̱' lawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nu'ula nigá quebe naque̱' nu'ula judío. Naque̱' nu'ula chee̱ tu xe̱zre nababa xe̱zr la xu Sirofenicia. Bzrine̱' lau Jesús, na' gunabe̱' Le̱' xebéaje̱' be' xriwe̱' da xu'u zrí'ine̱' nu'ula. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Gunná Jesús, dxe̱'e̱ nu'ula': ―Be̱' lataj xelagu nedxu zri'ine benne' lu xu'u, lawe' da quebe naca chawe' cúadxu xeta xtila chee̱ bidu ca', ne gunézrujdxu na chee̱ bécudu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Na' gunná nu'ula': ―Awe', Xran, san bécudu ca' zaj zra' zran ga dxelágube' dxeláguquezba' xeta bizruj da dxuluzexruj bidu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nadxa gunná Jesús: ―Ne̱ chee̱ dizra' da ba gunnéu', bexíaj na'a. Bache bedxúaj be' xriwe̱' lu be̱l-la' dxen chee̱ zri'inu' nu'ula. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Gate bezrín nu'ula' lizre̱', na' blé'ene̱' zrí'ine̱' nu'ula de̱be' lu da naga dxásebe', na' be' xriwe̱' ba bedxúaj na lu be̱l-la' dxen chee̱be'. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nadxa bedxúaj Jesús, bezé̱'e̱ naga nababa xe̱zre Tiro, na' gudétie̱' naga nababa xe̱zre Sidón, ne xe̱zre ca' zaj nababa Decápolis, na' bezrine̱' dxu'a nísadau' chee̱ xe̱zr la xu Galilea. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nadxa bedajleguá' benne' ca' tu benne' nacuézrue̱', ne quebe dxaca nnie̱', na' gulenábe̱' Jesús xrua ne̱'e̱ benne' nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Guché̱ Jesús benne' nigá chalá'ala naga zaj zra' benne' ca', na' bdie̱' zrube ne̱'e̱ lu naga bénnea', na' bzre̱'e̱ zrene̱', ne bte̱' lawe' luzre bénnea'. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nadxa la gunná'te̱' xabáa, ne gucá'a lazre̱', gunné̱': ―Efata. Dizxa' nigá zéaje̱ na: Bxalaj. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ca gunné̱' caní, na' bxalaj naga benne' cuezru nigá, ne bexaca luzre̱'. Nadxa guca bchálaje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Na' gunná Jesús, dxe̱'e̱ benne' ca' quebe nu xelé̱'e̱ ca da be̱ne̱'. Lácala gunná be'ene̱' le̱' caní, buluchílujdxe̱' dizra' ca da be̱ne̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Benne' ca' zaj zra' na' belexebánele̱'e̱ne̱', dxelenné̱': ―Xúgute̱ dxune̱' cháwedau'. Dxexune̱' benne' cuezru ca', na' dxelénte̱ne̱', ne dxexune̱' benne' ca' quebe dxaca nnie̱', na' dxelenné̱tie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ca lu zra ca' zaj nazraga benne' zan, na' quebe bi de̱ da xelawe̱'. Ca'an guca gunné̱ Jesús benne' ca' dxusé̱dene̱', na' guzre̱' le̱': ");
INSERT INTO zatNTps_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Neda' dxexache lazra' benne' caní lawe' da bache guca chunna zra zaj zre̱'e̱ nigá nen neda', ne quebe bi de̱ da xelawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Che ca' xesel-la' le̱' lizre̱' quebe xelawe̱', na' xelate ni'a ne̱'e̱ la neza lawe' da zá'aca bal-le̱' zitu'. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Na' belexeche̱be benne' ca' dxuse̱de Jesús, dxelé̱'e̱ Le̱': ―¿Ájazra gundxu gunézrujdxu da xelawe̱' nigá, ga quebe nu chilá' benne'? ");
INSERT INTO zatNTps_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús bche̱be̱' le̱': ―¿Bal-la xeta xtila nápale le'e? Benne' ca' gulenné̱': ―Gazre na. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nadxa gunná be'e Jesús xelebé' xúgute̱ bénneache ca' lu xu. Nadxa guqué̱'e̱ xeta xtila, ne guzre̱' Dios: ―Xcalenu'. Nadxa bzúzruje̱' na, ne bnézruje̱' na benne' ca' dxusé̱dene̱', na' benne' caní gulísie̱' na láwela xúgute̱ bénneache ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Zaj nápaqueze̱' tu chupa béladau'. Na' Jesús gunabe̱' Dios gune̱' na chawe'. Nadxa gunná bé'ene̱' gulise benne' ca' le̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Gulagu xúgute̱ bénneache ca', ne belezúale̱'e̱ chawe'. Ca gudé na' bulusuzré̱'e̱ gazre xcuite xca'a nen xeta bizruj da belegá'ana. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Benne' ca' gulawe̱' zaj naque̱' ca chua gaxúa benne' biu. Nadxa Jesús bze̱' benne' ca' dizra'. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nadxa guxú'e̱ lu da dxedá lawe' nísadau' nen benne' ca' dxusé̱dene̱'. Xjaque̱' lu xe̱zr la xu chee̱ benne' xe̱zre Dalmanuta. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nadxa belezrín benne' xudau' fariseo ca' ga na', ne gulezú lawe̱' dxulutil-le̱' dizra' nen Jesús. Gulenabe̱' Jesús gune̱' tu xel-la waca da za xabáa, chee̱ xelenézene̱' bi xel-la waca nape̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nadxa Jesús gucá'a dxgua lazre̱', gunné̱': ―¿Bizr chee̱ na' dxelenaba benne' caní guna' tu xel-la' waca da za xabáa? Da li dxapa' le'e, québequeze bi xel-la waca guna' lau le'e. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nadxa Jesús bca'ane̱' benne' ca', na' bexu'e̱ lu da dxedá lawe' nísadau', dxexíaje̱' xechelá'a chee̱ nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Gulal-la lazre' benne' ca' dxuse̱de Jesús xelu'e̱ da xelawe̱', na' zaj nu'e̱ tuze xeta xtila lu da dxedá lawe' nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nadxa Jesús gunná bé'ene̱', dxe̱'e̱ benne' ca': ―¡Le nna'xque nigá! Le guxúe cuínale da naca cua zichaj chee̱ xeta xtila chee̱ benne' xudau' fariseo ca', ne ca naca cua zichaj chee̱ xeta xtila chee̱ Herodes. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nadxa benne' ca' dxuse̱de Jesús gulé̱ ljwezre̱': ―Le̱' dxenné̱' caní lawe' da quebe de̱ xeta xtila gágudxu. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Dxeque be'e Jesús da dxelenné̱', na' guzre̱' le̱': ―¿Bizr chee̱ na' dxennale quebe de̱ xeta xtila gágudxu? ¿Quebe ne chéajni'ile ne quebe dxeque be'ele? ¿Nácale̱'e̱ zide' lázrdaule? ");
INSERT INTO zatNTps_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Quebe dxelé'ele nen xiaj laule, ne quebe dxenle nen nágale? ¿Quebe dxeajsá lázrele? ");
INSERT INTO zatNTps_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Gate na' bgawa' chi xun gaxúa benne' biu nen gazxu' xeta xtila, ¿bal-la xcuite xca'a xeta bizruj da becá'ale? Benne' ca' gulenné̱': ―Chazrinnu na. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Na' gunná Jesús: ―Na' gate na' bgawa' chua gaxúa benne' biu nen gazre xeta xtila, ¿bal-la xcuite xca'a da zaj zrate̱ becá'ale? Le̱' gulenné̱': ―Gazre na. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nadxa Jesús guzre̱' benne' ca': ―¿Ne la gázqueze quebe dxéajni'ile? ");
INSERT INTO zatNTps_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ca gudé na' Jesús, ne benne' ca' dxusé̱dene̱' belexezrine̱' lu xe̱zre Betsaida, na' benne' Betsaida guleché̱'e̱ tu benne' la chul-la lau Jesús, na' gulata' xuene̱' Le̱' guté̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús gudele̱' na' benne' la chul-la, ne bebéaje̱' le̱' dxu'a xe̱zre. Na' btupe̱' zrene̱' lu xiaj lawe̱', ne guxrúa ne̱'e̱ le̱'. Na' bche̱be̱' le̱' chete dxelé'ene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Benne' la chul-la gunné̱'e̱, na' gunné̱': ―Dxelé'eda' benne' ca', zaj naque̱' ca weaj xaga, na' dxesí'aque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nadxa Jesús guxrúa ne̱'e̱ xiaj lawe̱' da xula, na' benne' na' gunná' dxgüe̱'. Na' bexaque̱', ne xúgute̱ bache dxelé'ene̱' cháwedau'. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nadxa Jesús besel-le̱' le̱' lizre̱', dxe̱'e̱ le̱': ―Quebe chu'u lu xe̱zre nigá, ne quebe nu xu'u caní. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ca gudé na' Jesús, ne benne' ca' dxusé̱dene̱' xjaque̱' lu xé̱zredu ca' zaj nababa xe̱zre Cesarea naga dxenná bea Filipo. Dxácate̱ zaj xu'e̱ neza bche̱be Jesús benne' ca': ―¿Nuzra na' dxelenná benne' naca' neda'? ");
INSERT INTO zatNTps_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Belexeche̱be̱': ―Bal-la benne' dxelenné̱' nacu' Juan, bénnea' bchue̱' bénneache nisa. Benne' xula dxelenné̱' nacu' Elías, bénnea' bchálaje̱' waláz chee̱ Dios. Benne' xula dxelenné̱' nacu' tu benne' xula bchálaje̱' waláz chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nadxa Jesús bche̱be̱' le̱': ―¿Gazra le'e? ¿Nuzra dxennale le'e naca' neda'? Pedro gunné̱': ―Lue' nacu' Cristo, benne' nasel-la Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nadxa gunná be'e Jesús benne' ca'. Gunné̱': ―Quebe nu xe̱le ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nadxa guzú lau Jesús dxulé'ene̱' benne' ca' ca dxal-la' sáca'le̱'e̱ Le̱', Benne' Gulje̱' Bénneache, ne ca xelún benne' gula chee̱ judío ca', ne benne' xíchaje̱ ca' chee̱ bxruze ca', ne benne' dxuluxuzájle̱'e̱ da nadxixruj bea Dios, xuluzúe̱' Le̱' chalá'ala. Nadxa guzre̱' le̱' welútie̱' Le̱', san xebane̱' zra guxunne zra. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Da nigá guzre̱' le̱' caníqueze. Nadxa Pedro guché̱'e̱ Jesús chalá'ala, ne guzú lawe̱' dxedil-le̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesús bexéchaje̱', ne gunné̱'e̱ benne' ca' dxusé̱dene̱', na' gudil-le̱' Pedro, dxe̱'e̱ le̱': ―Gucuasa cuita' nigá, lue', da xriwe̱'. Quebe dxéquenu' da nigá ca dxun Dios. Ca dxun bénneache dxunu'. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nadxa Jesús gunné̱' benne' ca' dxusé̱dene̱', ne xúgute̱ bénneache ca', na' guzre̱' le̱': ―Che núlale dxaca lázrele gunle neda' tuze, dxal-la' guzúale chalá'ala xúgute̱ da dxezá lázrele le'e, ne gácale ca tu benne' zéaje̱' chee̱ te̱'e̱ xaga béguaj, na' gunle neda' tu zren. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Che tu benne' dxaca lazre̱' guselé̱' xel-la nabán chee̱', benne' nigá gunitie̱' xel-la nabán chee̱'. Bénnea' gunitie̱' xel-la nabán chee̱' ne̱ chia' neda', ne ne̱ chee̱ dizra' chawe' chia', benne' nigá guselé̱' xel-la nabán chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Che tu benne' gape̱' xúgute̱ da naca chee̱ xe̱zr la xu nigá, na' gunitie̱' bénne'du xu'e̱, ¿bízraqueze da ba neza gaca na chee̱ bénnea'? ");
INSERT INTO zatNTps_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Quebe bi gaca gunezruj tu benne' chee̱ guselé̱' bénne'du xu'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Che tu benne' gapa stu'e̱ chia' neda', ne chee̱ dizra' chawe' chia' lau bénne' caní, benne' dxulucá'ana Dios, ne dxelún dul-la, la gaze neda', Benne' Gulje̱' Bénneache, gapa stú'queza' chee̱ bénnea' gate xida' nen xel-la szren chee̱ Xra', ne nen gubáz chee̱ xabáa lá'azxa ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Cá'anqueze guzre Jesús benne' ca': ―Da li dxapa' le'e, zaj zra' nigá benne' quebe xelatie̱' nédxula ca xelelé'ene̱' xida xel-la dxenná bea chee̱ Dios nen xel-la waca chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ca gudé xrupa zra, guché̱ Jesús Pedro, ne Jacobo, ne Juan, na' guxíajle̱ne̱' benne' canize tu lu xi'a sibe. Na' bcha ca gunná' Jesús lau benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Zra lana Jesús bexaca na chiche ca bezxe' da dxágute̱ na laudxu. Quegá nu chilá' benne' lu xe̱zr la xu gaca quibe̱' zra lane̱' chee̱ xegá'ana na chiche ca guca zra lana Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Na' benne' ca' dxuse̱de Jesús belelé'ene̱' Elías, ne Moisés, benne' gulate nédxudaute̱, dxuluchálajle̱ne̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro guzre̱' Jesús: ―Benne' wese̱de, cháwele̱'e̱ naca zradxu nigá. Guntu' chunna xu'u lágadau', tu chiu', ne tu chee̱ Moisés, ne tu chee̱ Elías. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Caní gunná Pedro lawe' da dxelezrebe benne' ca' dxuse̱de Jesús, na' Pedro quebe nézene̱' ca da dxenné̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nadxa betaj tu beuj naga zaj zre̱'e̱, da bcache na le̱', na' lu beuj na' belenne̱' tu chi'i benne', gunné̱': ―Benne' nigá naque̱' Zri'ina' nazrí'ite̱ lazra'. Le xen da dxenné̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Gate gulenné̱'e̱, québedxa nu nalá' nen le̱', san tuze Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Dxácate̱ dxelexétaje̱' lu xi'a na', gunná be'e Jesús benne' ca' quebe nu xuluchálajle̱ne̱' ca naca da belelé'ene̱' gate te na' xebán Benne' Gulje̱' Bénneache ládujla benne' gate. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Chee̱ le̱ na' gulezúe̱' zrize ca naca da ba guca. Buluche̱be ljwezre̱': ―¿Bizra zéaje̱ da na', xebane̱' ládujla benne' gate? ");
INSERT INTO zatNTps_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nadxa buluche̱be̱' Jesús: ―¿Bizr chee̱ na' dxelenná benne' ca' dxuluxuzájle̱'e̱ da nadxixruj bea Dios dxal-la' xelá' Elías nédxula ca Cristo? ");
INSERT INTO zatNTps_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Beche̱be Jesús, na' guzre̱' le̱': ―Da li xelá' Elías nedxu, ne gucá'ana chawe̱' xúgute̱. ¿Bizra dxenná da naxúaj na lu xiche chee̱ Dios ca gaca chia' neda', Benne' Gulje̱' Bénneache? Dxenná na da zan da saca', na' xuluzúa bénneache neda' chalá'ala. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Neda' dxapa' le'e, ba bla' Elías, na' belune̱' chee̱' ca naca xúgute̱ da gulaca lazre̱' ca da dxenná na lu xiche chee̱ Dios ca da dxal-la' gaca chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ca gudé na' belexezrine̱' naga zaj zra' xezícadxa benne' ca' dxuse̱de Jesús, na' belelé'ene̱' benne' zan zaj naxéchaje̱' le̱', ne zaj zráqueze na' benne' dxuluxuzájle̱'e̱ da nadxixruj bea Dios, na' dxulutíl-lale̱ne̱' le̱' dizra'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Gate belelé'ene̱' Jesús, na' xúgute̱' belexebánene̱', na' gusí'aca chégüe̱' naga zua Jesús, ne bulugape̱' Le̱' diuzre. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ca'an guca, Jesús bche̱be̱' benne' ca': ―¿Bizra na' dxedíl-lale̱le benne' ca'? ");
INSERT INTO zatNTps_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nadxa tu benne' ze̱' ga na' beche̱be̱': ―Benne' wese̱de, nache̱'a zri'ina' nigá chee̱ xexunu'-be' lawe' da xu'ube' be' xriwe̱' da ba nun na le̱be' bi quebe dxaca nne̱be'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Gátete̱ze na' dxu'ube' da xriwe̱', na' dxe̱l-la na le̱be', ne dxin na le̱be' lu xu. Dxezría bzrina' xú'abe', ne dxagu lázxabe'. Chee̱ le̱ na' ba dxéxrujle̱'e̱be'. Ba gunaba' benne' ca' dxusé̱denu' xelexebéaje̱' be' xriwe̱' na', san quebe gulezéquene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Beche̱be Jesús: ―Le'e, benne' quebe dxéajle̱le chia'. ¿Ájate̱ dxal-la' súale̱na' le'e? ¿Ájate̱ dxal-la' gaca' benne' zren lazre' nen le'e? Le cheajxrí' bi cuide' na' nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Na' xeajlexrí'e̱-be'. Gate be' xriwe̱' na' ble'e na Jesús, na' be̱n na gudel-la chuna' bi cuide' na', ne gudinna le̱be' xu, na' dxebixre dxetúl-labe' lu xu, ne guzría bzrina' dxú'abe'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nadxa bche̱be Jesús xrabe': ―¿Bátate̱ dxezácabe' caní? Gunná xrabe': ―Gate nácate̱be' bidau'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Zane' lasa be' xriwe̱' na' dxugú'u na le̱be' lu xi', ne lu nisa chee̱ gute na le̱be'. Che wazéquenu' bi gunu' chee̱be', bexache lazre' netu', ne gúcale̱ netu'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Na' guzre Jesús le̱': ―Che wazéquenu' lue' chéajle̱'u chia', xúgute̱ wazeque chee̱ benne' dxéajle̱'e̱ chia'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nadxa xra bi cuide' nigá gunné̱' zizraj: ―Dxéajle̱'a chiu'. Gúcale̱ neda' chee̱ chéajle̱dxa'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Gate ble'e Jesús dxelezraga benne' zan, na' gudil-le̱' be' xriwe̱' na', dxenné̱': ―Lue', be' xriwe̱', dxunu' benne' quebe dxaca nnie̱', ne cuezru, neda' dxenná be'eda' lue' xedxúaju'. ¡Bsan bi cuide' nigá! ¡Québedxa xexú'u lu be̱l-la' dxen chee̱be'! ");
INSERT INTO zatNTps_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Na' be' xriwe̱' na' gudxezre xa'a na, ne be̱n na gudel-la chuna' bi cuide' na', na' bedxúaj na. Na' begá'anabe' ca tu benne' gate. Ca'an guca, gulenná benne' zan ca': ―Ba gútebe'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nadxa gucá'a Jesús na'be', bechise̱'-be'. Na' benne' cuide' na' beze̱be'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nadxa guxú'u Jesús tu lu xu'u, na' benne' ca' dxusé̱dene̱' buluche̱be̱' Le̱' naga zue̱' tuze̱': ―¿Bizr chee̱ na' quebe guzéquentu' netu' xebéajntu' be' xriwe̱' na'? ");
INSERT INTO zatNTps_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nadxa Jesús guzre̱' benne' ca': ―Ca naca be' xriwe̱' caní séquele xebéajle na che nábale lau Dios, ne gunle gubasa. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Gate besí'aque̱' naga zaj zre̱'e̱, na' belexedée̱' naga nababa Galilea. Jesús quebe guca lazre̱' nu neze ga zue̱', ");
INSERT INTO zatNTps_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","lawe' da dxuzéajni'ine̱' benne' ca' dxusé̱dene̱', na' guzre̱' le̱': ―Zua tu benne' gudée̱' neda', Benne' Gulje̱' Bénneache, lu na' benne' ca' dxeledábague̱' neda', na' xelútie̱' neda', san gate gaca chunna zra natia', na' xebana'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Benne' ca' quebe guléajni'ine̱' ca da dxe̱'e̱ le̱', ne belezrebe̱' xuluche̱be̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nadxa belezrine̱' lu xe̱zre Capernaum, na' gate zaj zre̱'e̱ lu xu'u na', bche̱be Jesús benne' ca' dxusé̱dene̱': ―¿Bizra dizra' dxutíl-lale̱le ljwézrele za'le la neza? ");
INSERT INTO zatNTps_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Gulezré̱'e̱ zrize lawe' da bulutil-le̱' dizra' la neza na' che nule̱' nácadxe̱' benne' blau. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nadxa Jesús gudxé'e̱, na' gunné̱' benne' chazrinnu, benne' ca' dxusé̱dene̱', na' guzre̱' le̱': ―Che núlale dxaca lázrele gácale benne' blau, dxal-la' gácale ca benne' bze̱be, ne gunle zrin chee̱ xúgute̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nadxa guqué̱'e̱ tu bidau', na' bzue̱' le̱be' gachaj lawe' benne' ca'. Na' bnide̱'-be', ne guzre̱' benne' ca': ");
INSERT INTO zatNTps_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Benne' na' gape̱' ba lá'ana tu bidau' ca bidu nigá lawe' da nazrí'ine̱' neda', bénnea' gape̱' ba lá'ana neda', na' bénnea' gape̱' ba lá'ana neda', quegá tuza' neda' gape̱' ba lá'ana, cá'anqueze gape̱' ba lá'ana Xra' nasel-le̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nadxa Juan guzre̱' Jesús: ―Benne' Wese̱de, blé'entu' tu benne' dxebéaje̱' be' xriwe̱' da xu'u bénneache, dxuchínene̱' Lau' Lue', san bénnea' quebe dxune̱' dxi'u tu zren. Chee̱ le̱ na' gúzrentu' le̱' québedxa gune̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús guzre̱' benne' ca' dxusé̱dene̱': ―Quebe bi xe̱le le̱'. Che nu benne' gune̱' tu xel-la waca, guchínene̱' La' neda', benne' nigá quebe gaca nne̱' schanni' chia'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Caní naca na lawe' da benne' quebe dxedábague̱' dxi'u, dxácale̱ne̱' dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nútete̱ze benne' gunne̱' le'e tu zriga' nisa ne̱ chee̱ La' neda' lawe' da nácale chia' neda', Cristo, da líqueze dxennía', wazí'queze̱' da dxal-la' si'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Gunnadxa Jesús: ―Nútete̱ze benne' gulé'ene̱' tu bidau' chee̱ gunbe' dul-la, bidu na' dxéajle̱be' chia', cháwedxa guchéajdxu tu xiaj zi'i lba bénnea', ne cheajchú'unadxu le̱' lu da situj chee̱ nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Che na'u dxun na gunu' dul-la, wendxa guchugu na'u na'. Cháwedxa xexú'u xabáa naga gaca banu' nen tuze na'u quézcala xexíaju' lataj ba xa' nen dxúpate̱ na'u, naga quebe xexula xi' da xezacu'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Lataj ba xa' na' quebe xelate bzuga', be̱ dxeláguba' benne' ca' dxelune̱' da cale̱la, na' xi' na' cabata' xexúl-laqueze na. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na' che ni'u dxun na gunu' dul-la, guchugu ni'u na'. Cháwedxa xexú'u xabáa naga gaca banu' nen tu ni'u, quézcala xexíaju' lataj ba xa' nen dxúpate̱ ni'u, naga quebe xexula xi'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Lataj ba xa' na' quebe xelate bzuga', be̱ dxeláguba' benne' ca' dxelune̱' da cale̱la, na' xi' na' cabata' xexúl-laqueze na. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Che xiaj lau' dxun na gunu' dul-la, guleaj xiaj lau' na'. Cháwedxa xexú'u naga dxenná bea Dios nen tuze xiaj lau', quézcala xexíaju' lataj ba xa' nen dxúpate̱ xiaj lau'. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Lataj ba xa' na' quebe xelate bzuga', be̱ dxeláguba' benne' ca' dxelune̱' da cale̱la, na' xi' na' cabata' xexúl-laqueze na. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Ca dxundxu gate dxugú'udxu zede' be̱la' da guzáladxu lu xi' chee̱ xegá'ana chawe' na, ca'an gaca chee̱ xúgute̱ benne'. Cá'anqueze dxugú'udxu zede' da dxuzézxedxu lau Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Zede' na' naca na da chawe', san che xenite xel-la sna'a chee̱ na, ¿ájala gundxu chee̱ guchínedxu zede' na'? Le gaca le'e ca zede' chawe' na', ne le sua lu xel-la zri lázre' tule nen xetule. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nadxa bedxúaj Jesús xe̱zre Capernaum, na' guxíaje̱' naga nababa Judea xechalá'a xe̱gu Jordán naga dxalaj gubizra. Na' belezraga bénneache zan naga zua Jesús, na' xecha lasa na' bsé̱dene̱' le̱' cáqueze dxune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nadxa bal-la benne' xudau' fariseo ca' belezrine̱' lau Jesús, na' buluche̱be̱' Le̱' chee̱ da gun nne̱ Le̱' tu da quebe dxal-la' nne̱'. Buluche̱be̱' Le̱': ―¿Waca tu benne' xelé̱'e̱ nen zru'ule̱'? ");
INSERT INTO zatNTps_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nadxa beche̱be Jesús: ―¿Bizra gunná be'e Moisés le'e? ");
INSERT INTO zatNTps_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Na' belexeche̱be benne' ca': ―Be̱nna Moisés lataj gunézrujdxu zrú'uladxu tu xiche da dxenná na dxelá'adxu, na' gusandxu le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nadxa Jesús guzre̱' le̱': ―Caní gunná be'e Moisés lawe' da zaj naca zizraj lázrdaule le'e. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Gate nédxudau' gate be̱n Dios xúgute̱ da dxelé'edxu, na' be̱ne̱' bénneache benne' biu, ne nu'ula, na' gunné̱': ");
INSERT INTO zatNTps_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Chee̱ le̱ na' benne' biu na' gusane̱' xruze xrne̱'e̱ chee̱ gaque̱' tuze nen zru'ule̱', ");
INSERT INTO zatNTps_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na' dxupe̱' xelaque̱' ca tuze benne'.” Ca' naca na, québedxa zaj naca chupe̱', san tuze benne' zaj naque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Chee̱ le̱ na' netú benne' quebe dxal-la' xelé̱'e̱ da nuchaga Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Gate zaj zra' lu xu'u benne' ca' dxuse̱de Jesús buluche̱be̱' Le̱' xetú lasa ca naca chee̱ da nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Na' Jesús guzre̱' benne' ca': ―Che tu benne' xelé̱'e̱ nen zru'ule̱', ne xezúale̱ne̱' nu'ula xula, dxíchuje̱' xrba chee̱ wechaga na' lawe' da dxusebague̱' zru'ule̱' nedxu na' dul-la. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Cá'anqueze che tu nu'ula gusane̱' benne' chee̱', ne xezúale̱ne̱' benne' xula, la gázqueze dxíchuje̱' xrba chee̱ wechaga na' da dxusebague̱' benne' chee̱' dul-la. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nadxa bénneache ca' guleché̱'e̱ bidu chee̱' ca' lau Jesús chee̱ xrua ne̱'e̱ le̱be', na' benne' ca' dxuse̱de Jesús gulezú lawe̱' dxeledil-le̱' benne' ca' zaj naché̱'e̱ bidu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Gate ble'e Jesús da dxelune̱', na' bzre̱'e̱, ne guzre̱' le̱': ―Le güe bidu ca' lataj xelelá'abe' naga zua'. Quebe guzágale-be' lawe' da benne' zaj naque̱' ca bidu caní xelu'e̱ naga dxenná bea Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Da li dxapa' le'e, che tu benne' quebe gape̱' ba lá'ana da dxenná bea Dios ca dxelún bidu caní, cabata' chu'u bénnea' naga dxenná bea Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nadxa gucá'a Jesús bidu ca', ne bnide̱'-be'. Guxrúa ne̱'e̱ le̱be', na' gunabe̱' Dios gun chawe̱'e̱-be'. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Gate bexú'u Jesús neza, na' guzá chegu tu benne' biu, na' bzu zribe̱' lau Jesús, ne bche̱be̱' Le̱': ―Benne' xrlátaje, bi dxal-la' guna' chee̱ gapa' xel-la nabán zeajlí canna? ");
INSERT INTO zatNTps_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús guzre̱' le̱': ―¿Bizr chee̱ na' dxu'u neda' xrlátaje? Québedxa nu chilá' naca xrlátaje. Tuze Dios naque̱' xrlátaje. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Núnbeaquezu' ca da bdxixruj bea Dios gate na' gunné̱': Quebe quichju' xrba chee̱ wechaga na'. Quebe gutiu' benne'. Quebe cuanu' chee̱ benne'. Quebe nneu' chee̱ nu benne' da quebe naca na. Quebe gagu lanu'. Gudapa ba lá'ana xra xrna'u. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nadxa bénnea' beche̱be̱': ―Benne' wese̱de, xúgute̱ da caní dxuna' nácatea' bidau'. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Na' Jesús gunné̱'e̱ le̱' xrtandau', ne guzre̱' le̱': ―Tu da dxexázrjenu'. Guxíaj xeaje̱te xúgute̱ da napu', na' bnezruj benne' xache' ca' dumí chee̱ na. Nadxa gapu' da gunní'a xabáa. Na' gudá, gacu' ca tu benne' zéaje̱' chee̱ te̱'e̱ xaga béguaj, ne be̱n neda' tuze. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Gate bene̱' da nigá, na' benne' cuide' na' bewi'ine lázrele̱'e̱, na' bexíaje̱' dxewí'ine̱' lawe' da nácale̱'e̱ benne' gunní'a. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nadxa Jesús gunné̱'e̱ ni naze, na' guzre̱' benne' ca' dxusé̱dene̱': ―Sté̱bete̱ naca chu'u benne' gunní'a naga dxenná bea Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Belexebánele̱'e̱ benne' ca' dxuse̱de Jesús ca naca dizra' gunná Jesús, na' Le̱' guzre̱' le̱' xetú lasa: ―Zrí'ina'dau', sté̱bete̱ naca xelú'u naga dxenná bea Dios benne' dxuluxrén lazre̱' xel-la gunní'a. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Chadidxa te tu bea zren lu negue xeche' quézcala chu'u tu benne' gunní'a naga dxenná bea Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Gate belén benne' ca' dizra' nigá, na' belexebánele̱'e̱ne̱', na' buluche̱be ljwezre̱': ―¿Núzraqueze la xca'? ");
INSERT INTO zatNTps_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús gunné̱'e̱ benne' ca', ne guzre̱' le̱': ―Quebe seque' nu bénne' gune̱' da nigá, san Dios wazéquene̱'. Quebe bi de̱ da quebe gaca gun Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nadxa Pedro guzre̱' Jesús: ―Xránantu', netu' ba bcá'anantu' xúgute̱ da nápantu', ne zéajle̱ntu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Na' beche̱be Jesús: ―Da li dxapa' le'e, nútete̱ze benne' gusane̱' lizre̱', u benne' biche̱', u nu'ula zane̱', u xre̱', u xrne̱'e̱, u zru'ule̱', u zrí'ine̱', u xe̱zr la xu chee̱' ne̱ chia' neda', u ne̱ chee̱ dizra' chawe' chia', ");
INSERT INTO zatNTps_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","benne' nigá si'e̱ na'a lu xe̱zr la xu nigá tu gaxúa cue' ca' da si'e̱, xu'u ca', ne benne' biche̱' ca', ne nu'ula zane̱' ca', ne xrne̱'e̱ ca', ne xe̱zr la xu chee̱' ca', na' weláu zi' xúzrequeze bénneache le̱'. Lu xe̱zr la xu da za za' wazí'queze̱' xel-la nabán zeajlí canna. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Zánete̱ benne' zaj naca na'a benne' blau xelaque̱' ca benne' bze̱be, na' zánete̱ benne' zaj naca na'a ca benne' bze̱be xelaque̱' benne' blau. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Gate zaj xu'e̱ neza dxelegüene̱' zjaque̱' Jerusalén, na' Jesús zria lawe̱' lau benne' ca' dxusé̱dene̱'. Dxelezrebe benne' ca', ne lu xel-la dxelezrebe zjácale̱ne̱' Le̱'. Na' da xula gucá'a Jesús benne' chazrinnu ca' dxusé̱dene̱', na' guzú lawe̱' dxe̱'e̱ le̱' ca naca da dxal-la' gaca chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Na' guzre̱' le̱': ―¡Le na' xque nigá! Dxegüendxu zéajdxu Jerusalén naga tu benne' gudée̱' neda', Benne' Gulje̱' Bénneache, lu na' benne' xíchaje̱ ca' chee̱ bxruze ca', ne lu na' benne' dxuluxuzájle̱'e̱ da nadxixruj bea Dios, na' xelechugue̱' chia' chee̱ gatia', na' wuludee̱' neda' lu na' benne' zitu' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nadxa xelún le̱' chia' neda', ne xelu'e̱ neda', ne xuluzré̱'e̱ neda' zrene̱', na' xelutie̱' neda'. Gate gaca chunna zra xebana' ládujla benne' gate. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nadxa Jacobo ne Juan, zri'ine Zebedeo, belezrine̱' lau Jesús, na' gulé̱'e̱ Le̱': ―Benne' Wese̱de, dxaca lázrentu' gunu' chee̱ntu' da nábantu' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nadxa bche̱be Jesús le̱': ―¿Bi dxaca lázrele guna'? ");
INSERT INTO zatNTps_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Na' belexeche̱be̱' Le̱': ―Be̱nna netu' lataj cué'entu', tuntu' chalá'a xabe̱la chiu', ne xetuntu' chalá'a xéglala chiu' naga nna be'u xabáa chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Na' guzre Jesús le̱': ―Le'e quebe nézele da dxenábale. ¿Waca xí'ajle le'e da na' xi'aj neda', da zéaje̱ na ca naca da sácadxu? ¿Waca chuale nisa ca chua' neda' nisa lu xel-la gute? ");
INSERT INTO zatNTps_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Le̱' belexeche̱be̱': ―Wácantu'. Na' Jesús guzre̱' le̱': ―Da li wé'ajle ca naca da na' xi'aj neda', ne chuale nisa ca chua' neda' nisa. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Chee̱ cué'ele chalá'a xabe̱la chia' u chalá'a xéglala chia', quegá neda' gunna' na. Gaca chee̱ benne' ca' ba nucueza Dios chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Gate xechí benne' ca' dxuse̱de Jesús belenne̱' na, na' belezré̱'e̱ nen Jacobo ne Juan. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesús gunné̱' benne' ca', na' guzre̱' le̱': ―Ba nézquezle ca dxelún benne' dxelenná be'e benne' xe̱zr la xu ca'. Dxelún cuine̱' xrane benne' xe̱zr la xu ca'. Benne' blau ládujla le̱' dxezi'e̱ ba neza xel-la dxenná bea chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Quebe gaca caní ládujla le'e. Che nu benne' dxaca lazre̱' gaque̱' benne' blau ládujla le'e, benne' nigá dxal-la' gune̱' zrin chee̱ ljwezre̱', ");
INSERT INTO zatNTps_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","na' che nu benne' ládujla le'e dxaca lazre̱' gaque̱' benne' xíchaje̱, benne' nigá dxal-la' gaque̱' ca tu benne' nada'u chee̱ gune̱' zrin chee̱ xúgute̱ ljwezre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Caní gaca na lawe' da cá'anqueze neda', Benne' Gulje̱' Bénneache, bla'a, quegá chee̱ xelún bénneache zrin chia' neda'. Bla'a chee̱ guna' zrin chee̱ bénneache, ne chee̱ guzúa' xel-la nabán chia' chee̱ guselá' benne' zan. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nadxa belezrine̱' xe̱zre Jericó. Gate na' bedxúaj Jesús xe̱zre nigá nen benne' ca' dxusé̱dene̱', ne nen benne' zante̱, na' zua tu benne' la chul-la le̱' Bartimeo, zri'ine Timeo, dxe'e̱ dxu'a neza dxenabe̱' guna'. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Na' ca bénne̱' dxedé Jesús, benne' Nazaret, ga na', na' benne' la chul-la nigá guzú lawe̱' dxenné̱' zizraj: ―¡Jesús, Zri'ine David, bexache lazre' neda'! ");
INSERT INTO zatNTps_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Benne' zan ca' guledil-le̱' le̱' chee̱ sue̱' zrize, na' le̱' zízrajdxa gunné̱': ―¡Zri'ine David, bexache lazre' neda'! ");
INSERT INTO zatNTps_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nadxa gugá Jesús, na' gunné̱': ―Le nne̱ le̱'. Na' gulenné̱' benne' la chul-la na', gulé̱'e̱ le̱': ―Bdipa lazru'. Guxasa lawe' da dxenné̱' lue'. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nadxa bzale̱' lazxe' naxrúa cuzre̱' chalá'ala, na' guxritie̱' chee̱ zrine̱' lau Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nadxa Jesús gunábene̱' le̱': ―¿Bizra dxaca lazru' guna' chiu'? Na' gunná benne' la chul-la: ―Benne' Wese̱de, dxaca lazra' xexunu' xiaj lawa'. ");
INSERT INTO zatNTps_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Na' Jesús guzre̱' le̱': ―Waca xexíaju'. Bache bexacu' lawe' da guxéajle̱'u chia'. La ble'ete̱ benne' la chul-la na', na' guxíajle̱ne̱' Jesús la neza. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Gate belezrine̱' gáguze naga dxe' xe̱zre Jerusalén, ne zaj xu'e̱ la neza naga zaj dxe' xe̱zre Betfagé, ne xe̱zre Betania zran xi'a chee̱ xaga olivo ca', na' Jesús gusel-le̱' chupa benne' ca' dxusé̱dene̱', ");
INSERT INTO zatNTps_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","na' guzre̱' le̱': ―Le chjaca lu xé̱zredau' da dxe' tu chi na', na' gate zrinle na', cheajxrácale tu burro da'ba' xaga, bea na' netú benne' quebe ne cuie̱' le̱ba'. Le se̱zre-ba', ne le che̱'-ba' nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Che nu benne' nabe̱' le'e bizr chee̱ na' dxesé̱zrele-ba', xé̱gale le̱': “Xránadxu dxechine̱'-ba'”, na' la xesél-la'te̱' le̱ba'. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nadxa xjaque̱', ne xeajlexraque̱' burro na' da'ba' xaga dxu'a dxa xu'u cuita neza, na' gulesé̱zre̱'-ba'. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nadxa bal-la benne' zaj zre̱'e̱ na' gulé̱'e̱ le̱': ―¿Bizra' dxunle? ¿Bizr chee̱ na' dxesé̱zrele búrrua'? ");
INSERT INTO zatNTps_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nadxa le̱' gulé̱'e̱ benne' ca' ca ba gunnáqueze Jesús, na' belúe̱' le̱' lataj. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","La belexeché̱'e̱te̱' búrrua' lau Jesús, na' buluzríe̱' zra lane̱' cúzruba', na' guzría Jesús le̱ba'. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Benne' zante̱ gulechíluje̱' xicha chee̱', ne xladxe̱' la neza, na' benne' xula gulechugue̱' zina' da gulíxrue̱' la neza. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Na' benne' ca' zaj zrie̱' lawe', ne benne' ca' zjaque̱' bze̱be, gulezú lawe̱' dxelenné̱' zizraj: ―¡Gaca ba! ¡Lá'azxa naca benne' ze̱'e̱, nasel-la Xránadxu Dios Le̱'! ");
INSERT INTO zatNTps_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Lá'azxa naca xel-la dxenná bea da za', xel-la dxenná bea chee̱ xradxu David! ¡Gaca ba Dios! ");
INSERT INTO zatNTps_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ca'an guca gate na' guxú'u Jesús xe̱zre Jerusalén, na' guxú'e̱ lu xudau'. Ca gudé gunné̱'e̱ xúgute̱ da zaj nnita du cuite̱', na' bezé̱'e̱ zexíaje̱' xe̱zre Betania nen benne' chazrinnu ca' dxusé̱dene̱', lawe' da ba zeaj dxezré'. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Gute xu zra xula gate na' gusá'aque̱' xe̱zre Betania, gudún Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Na' blé'ene̱' zítu'la dxe' tu xaga higo zria na laga', na' xeajnné̱'e̱ che zria da zixre lu xaga na', san quebe bi zria na. Lágaze zria na lawe' da quebe ne zrin zra cuía na da zixre. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nadxa Jesús guzre̱' xaga higo na': ―Cabátadxa nu gagu da zixre chiu'. Benne' ca' dxuse̱de Jesús belénqueze̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ca gudé na' belexezrine̱' xe̱zre Jerusalén. Ca guxú'u Jesús lu xudau', guzú lawe̱' dxulague̱' lu xudau' benne' zaj zre̱'e̱ we̱te, ne benne' zaj zre̱'e̱ wewa'u na'. Na' bdxixre̱' blaga chee̱ benne' weche̱'e̱ dumí chee̱ benne' zitu', ne bdxixre̱' naga dxelebé' benne' we̱te bgúgudu ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Quebe be̱'e̱ lataj nu benne' xudée̱' xua ca' lu xudau'. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nadxa bsé̱dene̱' bénneache ca', dxenné̱': ―Lu xiche lá'azxa dxenná Dios: “Lizra' gaca na tu xu'u naga xuluchálajle̱ Dios benne' zá'aque̱' xúgute̱ xe̱zre.” Le'e ba nunle lizra' ca tu lizre benne' gubán ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na' benne' xíchaje̱ ca' chee̱ bxruze ca', ne benne' dxuluxuzájle̱'e̱ ca da nadxixruj bea Dios belenne̱', na' gulezú lawe̱' dxelexíluje̱' ájala gaca xelútete̱' Jesús lawe' da dxelezrebe̱' Le̱'. Ca'an guca lawe' da dxelexebane xúgute̱ bénneache ca naca da dxuse̱de Jesús le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ca gula chizrela, Jesús bezé̱'e̱ lu xe̱zre. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ca gula zra xula che zílala, na' Jesús, ne benne' ca' dxusé̱dene̱' belexedée̱' na', na' belelé'ene̱' xaga higo na', ba nabizre na dute̱ lue na. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nadxa xeajsá lazre Pedro, na' guzre̱' Jesús: ―Benne' wese̱de, gunná'xque xaga higo nigá da gulú'u na de'. Bache gubizre na. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús gunné̱': ―Le cheajlí lazre Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Da li dxapa' le'e, che nútete̱zele nnale, xe̱le xi'a nigá: “Cuasa lue' nigá, xeajchú'u lu nísadau'”, ne che quebe dxun chupa lázrele, na' chéajle̱le waca da ba gunnale, na' gácaqueze na. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Chee̱ le̱ na' dxapa' le'e, xúgute̱ da nábale Dios gate dxuchálajle̱le Le̱', che chéajle̱le ba guzile na, ca'an gácaqueze. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Gate na' dxuchálajle̱le Dios, che dxezrá'ale nu benne', le gunite lau chee̱ bénnea' chee̱ cá'anqueze Xrale zue̱' xabáa gunite lawe̱' dul-la da nabágale. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Che quebe gunite laule chee̱ bénnea', Xrale zue̱' xabáa quebe gunite lawe̱' dul-la da nabágale. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nadxa belexezrine̱' xe̱zre Jerusalén, na' ca dxedá Jesús le̱'aj xudau', na' gulebiga lau Le̱' benne' xíchaje̱ ca' chee̱ bxruze ca', ne benne' dxuluxuzájle̱'e̱ da nadxixruj bea Dios, ne benne' gula ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Na' benne' caní gulenábene̱' Jesús: ―¿Bizra xel-la dxenná bea napu' dxunu' da caní? ¿Nuzra be̱nna lue' xel-la dxenná bea nigá? ");
INSERT INTO zatNTps_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Na' beche̱be Jesús: ―Cá'anqueze neda' de̱ tu da nábeda' le'e. Che xeché̱bele chia', nadxa xapa' le'e ca naca xel-la dxenná bea da napa' dxuna' da caní. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Nuzra gusel-la Juan bchue̱' bénneache nisa? ¿Dios che bénneache? Le xeche̱be na'a. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nadxa gulezú lau benne' ca' dxuluchálaje̱' le̱ze̱', dxelé̱ ljwezre̱': ―Che xe̱dxu Le̱', Dios gusel-le̱' le̱', na' nnáqueze̱': “¿Bizr chee̱ na' quebe guxéajle̱le chee̱'?” ");
INSERT INTO zatNTps_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Che nnadxu bénneache gulesel-le̱' le̱', dxal-la' zrébedxu da xelún benne' xe̱zre ca'. Caní gulenné̱' lawe' da xúgute̱ benne' xe̱zre nigá dxeléajle̱'e̱ guca Juan benne' bchálaje̱' waláz chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ca'an guca, gulenná benne' ca', dxelé̱'e̱ Jesús: ―Quebe nézentu'. Nadxa gunná Jesús, dxe̱'e̱ le̱': ―Cá'anqueze neda' quebe nnia' ca naca xel-la dxenná bea da napa' dxuna' da caní. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nadxa guzú lau Jesús dxuchálajle̱ne̱' benne' ca' tu da dxulé'e na. Dxe̱'e̱ le̱': ―Zua tu benne' bde̱'e̱ lba uva ca' lu xe̱zr la xu chee̱', na' be̱ne̱' le̱'aj chee̱ na. Be̱ne̱' tu xiaj lutju naga guchuchuje̱' uva ca', ne be̱ne̱' tu bdupa' naga cue' benne' guxúe̱' da caní. ’Nadxa bdee̱' xe̱zr la xu chee̱' na' lu na' benne' we̱n zrin ca' chee̱ xelune̱' la'a lina chee̱ na, na' guzé̱'e̱ zéaje̱' xe̱zre zitu'. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ca gula zra chee̱ lina, na' gusel-le̱' tu bi we̱n zrin chee̱' cheajxezri'ibe' lu na' benne' we̱n zrin ca' ca naca lina da dxal-la' xezí' benne' xranbe'. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Na' benne' we̱n zrin ca' gule̱l-le̱'-be', ne buluzalje̱'-be', na' belexesel-le̱'-be' dáchezebe'. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nadxa xránabe' gusel-le̱' bi we̱n zrin xula, na' bi nigá belú'e̱-be' xiaj, ne gulelé̱'e̱ xíchajbe', ne bulucháchale̱ne̱'-be'. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Na' xránabe' na' gusel-le̱' xetube', na' bi nigá belútete̱ benne' ca' le̱be'. Ca gudé na' xránabe' gusel-le̱' bi zandxa bi xula, na' cá'anqueze belú'e̱ bál-labe', ne belútete̱' xebál-labe'. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Xránabe' zua tu zrí'ine̱' bi biu, bi nazrí'ile̱'e̱ne̱', na' naga bzé̱bete̱ gusel-le̱' zrí'ine̱' nigá, dxenné̱' lu xichaj lázrdawe̱': Dxal-la' xelape̱' ba lá'ana zri'ina'. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Benne' we̱n zrin ca' gulenné̱', dxelé̱ ljwezre̱': “Bi nigá gueque chee̱be' xe̱zr la xu nigá. Gútete̱dxu-be' na'a, na' dxi'u xegá'anale̱dxu da nigá.” ");
INSERT INTO zatNTps_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ca'an guca, gule̱l-le̱'-be', ne belútete̱'-be', na' gulebéaje̱' be̱l-la' dxen chee̱be' lu xe̱zr la xu na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nadxa Jesús gunábene̱' benne' xudau' ca': ―¿Ájazra gun xrane xe̱zr la xu nigá? Walé̱'e̱, na' gútete̱' benne' we̱n zrin ca', na' gudée̱' xe̱zr la xu chee̱' lu na' benne' xula ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ba blábale da naxúaj na lu xiche chee̱ Dios. Dxenná na: Xiaj na' da quebe buluchine benne' we̱n xu'u, xiaj na' naca na'a xiaj blau chee̱ xu'u. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Da nigá be̱n Xránadxu, na' dxexebánedxu chee̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nadxa gulaca lazre̱' xele̱l-le̱' Jesús lawe' da zaj nézene̱' bchálaje̱' da dxulé'e nigá chee̱ gulé'ene̱' ca zaj naca le̱'. Quebe bi gulune̱' lawe' da gulezrebe̱' bi xelún benne' xe̱zre ca'. Chee̱ le̱ na' bulusane̱' Jesús, besí'aque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ca gudé na' gulesel-le̱' lau Jesús bal-la benne' xudau' fariseo, ne benne' zaj de̱'e̱ Herodes chee̱ gulebéaje̱' Le̱' dizra' chee̱ xelezéquene̱' xelawe̱' Le̱' zria. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Benne' caní belelé̱'e̱ lau Jesús, na' gulé̱'e̱ Le̱': ―Benne' wese̱de, ba nézentu' ca dxennáu' da li, ne quebe dxezí'u ca da dxelennaze bénneache, lawe' da quebe dxenná'u Lue' ca zaj naca cúzreze bénneache. Da li naca ca dxusé̱denu' bénneache da naca chee̱ Dios. ¿Dxunna da nadxixruj bea Dios lataj quízrujdxu da dxuchizruj benne' dxenná bea Roma dxi'u, che cabí? ¿Dxal-la' quízrujdxu, che quebe quízrujdxu? ");
INSERT INTO zatNTps_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús dxéquebe'ene̱' quegá du lazre̱' dxelenábene̱' Le̱' da nigá, na' guzre̱' le̱': ―¿Bizr chee̱ na' dxebéajle neda' dizra'? Le dajguá nigá tu dumí da dxízrujle chee̱ le'eda' na. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Na' bedajlegüé̱'e̱ na, na' ca ble'e Jesús le̱ na, na' gunábene̱' le̱': ―¿Nu lau da' dumí nigá, ne nu la naxúaj na nigá? Na' gulé̱'e̱ Le̱': ―Chee̱ benne' dxenná bea Roma. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nadxa Jesús guzre̱' benne' ca': ―Le gunezruj chee̱ benne' dxenná bea Roma da naca chee̱', na' le gunezruj chee̱ Dios da naca chee̱ Dios. Na' belexebánene̱' ca naca da bchalaj Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nadxa belezrín lau Jesús bal-la benne' xudau' saduceo. Benne' caní dxelenné̱' quebe xelexebán benne' gate. Ca'an guca, gulenábene̱' Jesús caní: ");
INSERT INTO zatNTps_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Benne' wese̱de, Moisés bzuaje̱' chee̱dxu da nadxixruj bea nigá: “Che tu benne' biu gatie̱', ne xegá'ana zru'ule̱', na' quebe nu zua bi chee̱ bénnea', na' benne' biche̱' dxal-la' xequé̱'e̱ nu'ula na' gute benne' chee̱' chee̱ sua zri'ine bénnea' gutie̱'.” ");
INSERT INTO zatNTps_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Gulezrá' gazre benne' biche̱'. Benne' nedxu bchaga na'abe', na' gútebe' quebe nu zrí'inebe' zua. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Na' benne' gudxupe' bequé̱'e̱ nu'ula na', na' cá'anqueze gutie̱' quebe nu zrí'ine̱' zúaqueze. Cá'anqueze guca chee̱ benne' guxunne'. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ca'an guca, benne' gazre caní gulezúale̱ne̱' nu'ula na', na' netue̱' quebe nu zrí'ine̱' guzúa. Naga xeajse̱te̱ na gútete̱ nu'ula'. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na'a xca', gate na' xelexebán benne' gate, ¿nula benne' biu caní gaque̱' benne' chee̱ nu'ula na', lawe' da gulezúale̱ benne' gazre ca' le̱'? ");
INSERT INTO zatNTps_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nadxa Jesús guzre̱' benne' ca': ―Nanítele le'e lawe' da quebe núnbeale da naxúaj na lu xiche chee̱ Dios, ne quebe nézele ca naca xel-la waca chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Gate na' xelexebán benne' gate, québedxa xuluchaga ne̱'e̱, ne québedxa xuluchaga na' bi nu'ula ca'. Xelaque̱' ca zaj naca gubáz chee̱ xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na'a, ca naca chee̱ benne' gate che xelexebane̱', ¿quebe ne gulábale ca da naxúaj na lu xiche chee̱ Moisés ca gunná Dios gate na' bchálajle̱ne̱' Moisés tu lu xágadau' da dxala xi'? Gunná Dios caní: “Neda' naca' Dios chee̱ Abraham, ne chee̱ Isaac, ne chee̱ Jacob.” ");
INSERT INTO zatNTps_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dios naque̱' Dios, quegá chee̱ benne' gate ca'. Naque̱' Dios chee̱ benne' ban ca'. Ca'an naca, álega nanítele le'e. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Na' zé̱queze tu benne' dxuxuzájle̱'e̱ da nadxixruj bea Dios, na' benne̱' da dxuchalaj Jesús, ne nézene̱' bzri'e̱ dizra' chawe', na' gunábene̱' Le̱': ―¿Bizra da nadxixruj be'e Dios naca na da blaudxa? ");
INSERT INTO zatNTps_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Na' Jesús guzre̱' le̱': ―Da bdxixruj be'e̱ da naca na da blaudxa ca xúgute̱ dxenná na caní: Le xene benne' Israel. Xránadxu Dios tuze naque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bzri'i Xranu' Dios du lazru', ne nen dute̱ bénne'du xu'u, ne nen dute̱ xichaj lázrda'u, ne nen dute̱ xel-la wal-la da napu'. Da nigá naca da nadxixruj bea da blaudxa, ");
INSERT INTO zatNTps_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","na' da nadxixruj bea gudxupe' nácaqueze na ca le̱ na, da dxenná na caní: Bzri'i benne' xula ca nazrí'i cuinu'. Quebe zua xetú da nadxixruj bea da naca blaudxa ca da chupa caní. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nadxa gunná bénnea' dxuxuzájle̱'e̱ da nadxixruj bea Dios, dxe̱'e̱ Jesús: ―Ca'an xanne naca ca beche̱bu', Benne' dxuse̱de. Da li naca ca dxennáu'. Zua tuze Dios, ne quebe nu zua xetú ca Le̱', ");
INSERT INTO zatNTps_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","na' che zri'idxu Dios du lázredxu, ne nen dute̱ xichaj lázrdaudxu, ne nen dute̱ bénne'du xú'udxu, ne nen dute̱ xel-la wal-la da nápadxu, ne che zri'idxu benne' xula ca nazrí'i cuínadxu, da caní zaj zácadxa na ca xúgute̱ be̱ xixre' ca' dxútedxu-ba' lau Dios, ne ca xúgute̱ da dxuzézxedxu lu cugu chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nadxa Jesús, ca benne̱' bchálaje̱' chawe', na' guzre̱' le̱': ―Xeláteze ne de̱ na chee̱ nna bea Dios xichaj lázrda'u. Na' québedxa nu bexazre nábene̱' Le̱' dizra' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús dxusé̱dene̱' benne' ca' lu xudau', na' gunné̱': ―¿Bizr chee̱ na' dxelenná benne' dxuluxuzájle̱'e̱ da nadxixruj bea Dios naca Cristo zri'ine David? ");
INSERT INTO zatNTps_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David ná'queze ca bzéajni'i Be' Lá'azxa le̱', gunné̱': Xránadxu Dios guzre̱' Xrana': “Gudxé'e chalá'a xabe̱la chia', ca zrin zra ba nuzúa' benne' dxeledábague̱' lue', chee̱ na be'enu' le̱'.” ");
INSERT INTO zatNTps_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Che David ná'queze dxenné̱': “Xrana'”, ¿ájala chee̱ na' naque̱' zrí'ine̱'? Benne' zan ca' du lazre̱' buluzé̱ nague̱' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ca dxuse̱de Jesús benne' ca', na' gunné̱': ―Le gapa chi'i cuínale chee̱ benne' ca'an dxuluxuzájle̱'e̱ da nadxixruj bea Dios. Benne' caní dxeledánene̱' dxelácue̱' zra lane̱' tunna, ne dxeledánene̱' xulugapa bénneache le̱' diuzre nen dizra' ba lá'ana lau bénneache ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Benne' caní dxeledánene̱' dxelebé'e̱ lataj blau lu xu'u naga dxelezraga benne' dxelúe lá'ane̱' Dios, ne dxeledánene̱' dxelebé'e̱ lataj blau naga dxelawe̱' xrche'. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Benne' caní dxelegüe̱' lizre xrlataj nu'ula ca' ba gulate benne' chee̱', na' chee̱ xululé'e cuine̱' ca benne' xrlátaje, dxelune̱' xel-la dxuluwizraj Dios tunna. Le̱' zaj nabágadxe̱' zria. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tu lasa gate na' dxe' Jesús lu xudau' cuita naga dxelegú'e̱ dumí, na' dxenné̱'e̱ ca dxelún benne' ca' dxelegú'e̱ dumí, ne ca dxelún benne' gunní'a ca', dxelegú'e̱ dumí zren. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ca'an guca, bzrin tu nu'ula xache' ba gute benne' chie̱', na' gulu'e̱ chupa dumí lásedau' da quebe zaj zácate̱ can. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nadxa gunné̱ Jesús benne' ca'an dxusé̱dene̱', na' guzre̱' le̱': ―Da li dxapa' le'e, nu'ula xache' nigá bnézrujdxe̱' ca xúgute̱ benne' ca'an gulegú'e̱ dumí. ");
INSERT INTO zatNTps_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Xúgute̱ benne' ca' gulegú'e̱ da québedxa dxelechínne̱'. Nu'ula xache' nigá gulu'e̱ ca naca da nape̱', da nunte̱ gawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Gate bedxúaj Jesús lu xudau', na' tu benne' dxusé̱dene̱' guzre̱' Le̱': ―Benne' Wese̱de, gunná'xque ca zren naca xudau', ne xiaj xrtante̱ caní. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Beche̱be Jesús: ―¿Dxelé'enu' na'a ca zren naca xudau' nigá? Québedxa xegá'ana tu xiaj cuzru ljwezre nigá. Ca naca xudau' nigá wabía xí'queze na. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nadxa xjaque̱' lu xi'a chee̱ xaga olivo ca', da zua na chalá'a ca li dxa xu'u xudau'. Gate dxe' Jesús ga na', na' Pedro, ne Jacobo, ne Juan, ne Andrés gulé̱'e̱ Jesús le̱ze̱': ");
INSERT INTO zatNTps_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Dxaca lázrentu' gulé'enu' netu' bata gaca caní. ¿Bizra da ca' xelunna bea na gaca xúgute̱ da caní? ");
INSERT INTO zatNTps_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Na' beche̱be Jesús: ―Le gapa chi'i cuínale chee̱ quebe nu si xe̱ le'e, ");
INSERT INTO zatNTps_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","lawe' da xelelá' benne' zante̱ xelún lu'a neda', welenné̱' zaj naque̱' Cristo, na' welezí xe̱'e̱ benne' zante̱. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Le'e, gate xénele gaca wedil-la, ne ba dxaca wedil-la, quebe zrébele. Cá'queze dxal-la' gaca na, san quegá ne zrin zra cheajsé̱ chee̱ na, ");
INSERT INTO zatNTps_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","lawe' da xeledíl-lale̱ benne' tu xe̱zr la xu benne' xetú xe̱zr la xu, na' tu xe̱zre benne' tíl-lale̱ na xetú xe̱zre. Wazrú' zánete̱ xe̱zre, ne wata' gubina', ne wadxé'e na zraga bénneache. Da caní zaj naca na naga su lauze ca naca da xelezaca zi' bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Le guxúe cuínale lawe' da xuludée̱' le'e lu na' benne' xu'u lawe', na' xuluzalje̱' le'e lu xu'u naga dxulucá'ana szrene̱' Dios. Xuludée̱' le'e lau benne' xu'u lawe' ca', ne lau benne' dxelenná be'e̱ lawe' da nácale chia' neda'. Gate ca'an gaca, na' guchálajle chia' neda' lau benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nédxudxa ca zrin zra cheajsé̱ chee̱ na, dizra' chawe' chia' gaca lban chee̱ na lau bénneache zaj zre̱'e xúgute̱ xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Gate xeleché̱'e̱ le'e chee̱ xuludée̱' le'e lu na' benne' xu'u lawe' ca', quebe cue'le gunne xue bi nnale, ne quebe quilaj lázrele ájala guchálajle. Nne̱le ca da gunna Dios le'e zra na' lawe' da quegá le'eze nne̱le, san Be' Lá'azxa, Le̱' nne̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ca xelún bénneache lu zra na', xuludée̱' bi biche̱' ca' lu na' benne' xelútie̱' le̱be'. Cá'anqueze xelún xruze xrna' ca', xuludée̱' zrí'inequeze̱'. Na' zrí'ine̱' ca' weledábagabe' xruze xrnabe', ne xelunbe' xelátie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Xúgute̱ bénneache xelezré̱'e̱ le'e lawe' da nácale chia' neda'. Bénnea' ze̱ tipe̱' ca zrindxa zra cheajsé̱ chee̱ na, la bénnea'. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Daniel, bénnea' bchálaje̱' waláz chee̱ Dios bzuaje̱' ca naca chee̱ da sban da guzría xi na. Gate lé'ele le'e zria da nigá lataj lá'azxa naga quebe dxal-la' cuía na, nadxa benne' zaj zre̱'e̱ xe̱zre ca' zaj nababa xe̱zr la xu Judea dxal-la' xuluzrúnnuje̱', ne chjaque̱' lu xi'a zren. (Benne' dxulabe̱' da nigá dxal-la' cheajní'ine̱' da naca chee̱ na.) ");
INSERT INTO zatNTps_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nu benne' zria chju'u lizre̱' lu zra na' quebe dxal-la' xexétaje̱' chee̱ bi xebéaje̱' lu xu'u. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Benne' ze̱ le̱'e̱ xixre' quebe dxal-la' xezrine̱' lizre̱' chee̱ xequé̱'e̱ zra lane̱'. Dxal-la' xuluzrúnnujte̱ benne' caní. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Baxache' xelaca nu'ula zaj zue̱' zi'i, ne nu'ula ca' zaj nuxre̱' bidu dxe'ene lu zra na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Le naba lau Dios chee̱ quebe gaca beu' zaga gate na' dxal-la' guzrúnnujle, ");
INSERT INTO zatNTps_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","lawe' da xelezaca zidxa bénneache lu zra ca'an ca da quebe ne xelezácate̱', gulala be̱n Xránadxu Dios xe̱zr la xu nigá, ne québedxa xelezácadxe̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Che Xránadxu Dios quebe guzáchie̱' zra ca', québedxa nu láqueze̱', san ba bzachie̱' zra ca'an lawe' da nazrí'ine̱' bi chee̱' ca', bi ca' ba gucá'a Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Lu zra na', che nu benne' dxe̱'e̱ le'e: “Le na' xque, nigá zua Cristo”, u che nne̱': “Le na' xque, na' ze̱'”, quebe chéajle̱le chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Welelá' benne' xelezí xe̱'e̱, benne' xelune̱' lu'a Cristo, ne xelune̱' lu'a xel-la waca chee̱ xabáa chee̱ xelezí xe̱'e̱ bi ca' ba gucá'a Dios che xelezéquene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Le sua le'e ban lazre'. Neda' ba gucha' le'e xúgute̱ nédxute̱ ca gaca na. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Nadxa gunná Jesús: ―Lu zra ca', gate te zra chee̱ xel-la zi' caní, na' chul-la gubizra, ne québedxa gusení' beu'. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Belaj ca' xelexruj na zran xabáa, na' ca da zaj nalá' zaj ze̱ tipa zran xabáa welezrízete̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ca nadxa xelelé'ene̱' neda', Benne' Gulje̱' Bénneache, za'a lu beuj bza, napa' xel-la waca zren, ne da xabáa chia'. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Na' la sél-latea' gubáz chee̱ xabáa chia' ca' chee̱ xuluchague̱' benne' ca' gunnía', benne' zaj zre̱'e̱ dapa saca chee̱ xe̱zr la xu nigá, benne' zitu' zá'aca nila, zá'aca na'la. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Le guse̱de ca naca da dxulé'e na ca naca chee̱ xaga higo. Gate na' dxelexedxé'ene zruze na, ne zá'aca xrlegue na, na' ba nézele za beu' la. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Cá'anqueze, gate na' lé'ele ba dxelaca da caní, nézele ba zua gáguze zra cheajsé̱ na, ne gácate̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Da li dxapa' le'e, xúgute̱ da caní gaca na nédxudxa ca xelate bénneache zaj zre̱'e̱ lu zra na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Xabáa ne xe̱zr la xu nigá wadé chee̱ na. Xrtizra' nigá quebe te na ca'anze, san waca li na. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Ca naca chee̱ zra na', ne chee̱ beu' na' quegá nu neze bata gaca na. Quebe zaj neze gubáz chee̱ xabáa, ne Zrí'inequeze Dios quebe nézene̱'. Tuze Xradxu Dios nézene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Chee̱ le̱ na', le sua le'e ban lazre'. Le guxúe, ne le guchálajle̱ Dios lawe' da quebe nézele bátala zrin zra na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Gaca na ca guca chee̱ tu benne' biu, benne' guzé̱'e̱ zéaje̱' zitu'. Gate na' za dxúaje̱' xu'u, na' dxudée̱' da nape̱' lu na' bi we̱n zrin chee̱' ca', ne dxunézruje̱' tu tube' zrin da xelunbe', ne dxusebague̱' benne' ze̱' dxa xu'u guxúe xánnie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chee̱ le̱ na', le sua le'e ban lazre' lawe' da quebe nézele le'e bátala xelá' xrane xu'u, che dxe xrínneze, che dxe̱la, che ca cuezre xjeaj, che che zílala, ");
INSERT INTO zatNTps_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ga gaze xelé̱'e̱ chadí dute̱, na' cheajxraque̱' le'e dxásele. ");
INSERT INTO zatNTps_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ca da dxennía', dxapa' le'e, dxapa' xúgute̱ benne': ¡Le sua ban lazre'! ");
INSERT INTO zatNTps_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Xechupa zra za zrin chee̱ xelune̱' laní chee̱ xulusá lazre̱' ca naca da be̱n Dios gate na' bebéaje̱' benne' Israel ca' lu xe̱zr la xu Egipto, laní na' dxelawe̱' xeta xtila da quebe nachixre cua zichaj chee̱ na. Na' benne' xíchaje̱ ca' chee̱ bxruze ca', ne benne' dxuluxuzájle̱'e̱ da nadxixruj bea Dios belilaj lazre̱' ájala xelune̱' chee̱ xele̱l-le̱' Jesús bagácheze chee̱ xelútie̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Na' gulenné̱': ―Quegá gundxu na lu laní, chee̱ quebe dxe'ena zraga bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Zua Jesús lu xe̱zre Betania, lu lizre tu benne' le̱' Simón, benne' guzríe̱' we̱' guzru'. Dxácate̱ zaj dxe'e̱ dxelawe̱' na', na' bzrin tu nu'ula nu'e̱ tu da dau' da naca na xiaj xrtan da nazí le na alabastro, ne nazrate̱ na da za da dxelá zixre chee̱ xiaj nardo, da zácale̱'e̱ na. Na' gulé̱'e̱ da dau' na', ne blálaje̱' da za na' xichaj Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bal-la benne' ca', benne' zaj zre̱'e̱ na', belezré̱'e̱, na' gulenné̱', dxelé̱ ljwezre̱': ―¿Bizr chee̱ na' be̱n ditaj nu'ula nigá da za na'? ");
INSERT INTO zatNTps_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Waca ta'u da na' chee̱ sídxadxu ca lázrujdxu chee̱ tu iza, chee̱ gácale̱dxu benne' xache' ca'. Na' guledil-le̱' nu'ula'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Na' Jesús guzre̱' le̱': ―Quebe xe̱le nu'ula nigá ca'. ¿Bizr chee̱ na' dxunle le̱' ze̱de? Ca naca da be̱n nu'ula nigá chia' neda' naca na da cháwele̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Benne' xache' ca' tu zrázqueze̱' ládujla le'e. Waca gunle benne' ca' chawe' gate dxaca lázrele, san neda' quegá tu súale̱za' le'e. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nu'ula nigá be̱ne̱' ca da guzéquene̱', gulu'e̱ da za be̱l-la' dxen chia' nédxula chee̱ zra gate gachia' lu xe̱dxu ba. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Da li dxapa' le'e, gátete̱ze na' gaca lban chee̱ dizra' chawe' chia' lu xúgute̱ xe̱zre zaj nnita xe̱zr la xu nigá, cá'anqueze zrálajqueze ca naca da be̱n nu'ula nigá, chee̱ xulusá lazre̱' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nadxa Judas Iscariote, tu benne' chazrinnu ca' dxuse̱de Jesús, guxíaje̱' xeajchálajle̱ne̱' benne' xíchaje̱ ca' chee̱ bxruze ca' chee̱ xelexegá'ane̱' dizra' ájala gune̱' gudée̱' Jesús lu na' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ca belén benne' ca' ca gunná Judas, gulebéle̱'e̱ne̱', na' guleche̱be lazre̱' xulunézruje̱' le̱' dumí. Nadxa Judas guzú lawe̱' dxexílaje̱' ájala gudée̱' Jesús lu na' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Zra nedxu chee̱ laní gate dxelawe̱' xeta xtila da quebe nachixre cua zichaj chee̱ na, ne dxelutie̱' zríla'dau' chee̱ Laní Pascua, gate na' dxulusá lazre̱' ca guca gate bebéaj Dios benne' Israel ca' lu xe̱zr la xu Egipto, na' benne' ca' dxuse̱de Jesús buluche̱be̱' Le̱': ―¿Gazra dxaca lazru' chéajntu' cheajcuézentu' da gágudxu Laní Pascua? ");
INSERT INTO zatNTps_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nadxa Jesús gusel-le̱' chupa benne' ca' dxusé̱dene̱'. Dxe̱'e̱ le̱': ―Le chjaca lu xe̱zre Jerusalén, na' cheajxrácale tu benne' biu ze nu'e̱ tu dxe'e nisa. Le chjácale̱ne̱', ");
INSERT INTO zatNTps_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","na' naga xexu'e̱, xe̱le benne' xrane xu'u na': “Benne' Wese̱de chee̱dxu dxenné̱': ¿Gazra zua xu'u naga guna' Laní Pascua, chee̱ gawa' tu zren nen benne' ca' dxusé̱deda'?” ");
INSERT INTO zatNTps_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nadxa gulé'ene̱' le'e tu xu'u zren da naca na gudxupe' cuía sibe da bache nabeza na. Na' gucuézale da gágudxu. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nadxa benne' ca' dxusé̱dene̱' belexedxúaje̱' gusá'aque̱', na' belezrine̱' xe̱zre Jerusalén. Na' guca xúgute̱ ca da ba guzre Jesús le̱', na' bulucueze̱' da xelawe̱' lu Laní Pascua. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ca gula chizrela, na' bzrin Jesús nen benne' chazrinnu ca' dxusé̱dene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Na' ca zaj dxe'e̱ dxelawe̱', na' gunná Jesús, dxe̱'e̱ le̱': ―Da li dxapa' le'e, tu benne' ládujla le'e, benne' dxawe̱' tu zren nen neda', gudée̱' neda' lu na' benne' ca' dxeledábague̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nadxa benne' ca' gulezúa xácheze̱', ne gulezú lawe̱' dxuluche̱be̱' Jesús tu tue̱': ―¿Neda' xca'? Na' xetúe̱' cá'anqueze guzre̱' Le̱': ―¿Neda' xca'? ");
INSERT INTO zatNTps_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nadxa beche̱be Jesús, dxe̱'e̱ le̱': ―Tu benne' ládujla le'e chazrínnule, benne' dxawe̱' tu zren nen neda' lu xé'ena nigá. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Da li gatia' neda', Benne' Gulje̱' Bénneache, ca da naxúaj na chia' lu xiche chee̱ Dios. Baxache' naca chee̱ benne' na' gudée̱' neda' lu na' benne' ca' dxeledábague̱' neda'. Cháwedxa gaca chee̱ bénnea' la ca gúlaje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Dxácate̱ zaj zre̱'e̱ dxelawe̱', na' gucá'a Jesús xeta xtila, ne guzre̱' Dios: “Xcalenu'.” Ca gudé bzúzruje̱' na, na' bnézruje̱' na chee̱ benne' ca', ne guzre̱' le̱': ―Le gagu na. Da nigá dxulé'e na ca gaca chee̱ be̱l-la' dxen chia'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nadxa guqué̱'e̱ tu da dxé'ajdxu, ne ca gudé guzre̱' Dios: “Xcalenu'”, na' bnézruje̱' na benne' ca', na' xúgute̱' gulé'aje̱' late' weaj da na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nadxa Jesús guzre̱' le̱': ―Da nigá zéaje̱ na dxen chia' da dxucá'ana chawe na xel-la wezría cube. Dxen chia' nigá lalaj na ne̱ chee̱ benne' zan. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Da li dxapa' le'e, québedxa xí'aja' xrise uva caní ca zrindxa zra gate na' xí'aja' da cube naga dxenná bea Dios xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ca gudé belul-le̱' da gaca ba Dios, na' belegüene̱' lu Xi'a Xaga Olivo Ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nadxa gunná Jesús, dxe̱'e̱ le̱': ―Xúgute̱le le'e gusán lázrele neda' na'a xe̱la lawe' da naxúaj na lu xiche chee̱ Dios, dxenné̱': “Gutia' benne' dxuxúe̱' zrila' ca', na' zrila' ca' welase dínnajba'.” ");
INSERT INTO zatNTps_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Gate te xebana' lu xe̱dxu ba, wexá'a neda' nédxula ca le'e naga nababa Galilea. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nadxa Pedro guzre̱' Jesús: ―Láqueze xúgute̱ benne' caní xulusán lazre̱' Lue', neda' québequeze guna' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús guzre̱' le̱': ―Da li dxapa' lue', lu xe̱la nigaze, nédxula ca za cuezre xjeaj chupa lasa, nnau' chunna lasa quebe núnbe'u neda'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Na' dxennáqueze Pedro na', gunné̱': ―Láqueze gatia' tu zren nen Lue', québequeze nnia' quebe núnbe'a Lue'. Cá'anqueze gulenná xúgute̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nadxa belezrine̱' tu lataj naga nazí le na Getsemaní, na' gunná Jesús, dxe̱'e̱ benne' ca' dxusé̱dene̱': ―Le cueza nigá dxácate̱ cha'a cheajchálajle̱na' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nadxa Jesús guché̱'e̱ Pedro, ne Jacobo, ne Juan, na' guzú lau dxezúa xáche'le̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Na' dxe̱'e̱ benne' ca', dxenné̱': ―Ba dxunte̱ na watia' lawe' da zua xáche'le̱'a. Le xegá'ana le'e nigá, ne le sua ban lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nadxa Jesús guzé̱'e̱ zéaje̱' xelate' ca na'la, na' guzúe̱' sudxú'ala, gunabe̱' Dios che gaca, quebe tée̱' xel-la zi' ca da dxal-la' saque̱' lu zra na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ca dxuchálajle̱ne̱' Dios na', gunné̱': ―Xrae, xúgute̱ wazéquenu' Lue'. Bselá neda' chee̱ quebe saca zi'a lu da caní. Quebe gaca ca dxaca lázreza' neda', san ca dxaca lazru' Lue' gaca na. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nadxa bezrine̱' naga zaj zra' benne' ca'an dxusé̱dene̱', ne xeajxraque̱' le̱' dxelásie̱'. Na' Jesús guzre' Pedro: ―Simón, ¿dxásequezu' nigá? ¿Quebe guzéquenu' gusebán lazru' tu chí'idau'ze? ");
INSERT INTO zatNTps_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Le sua ban lazre', ne le guchálajle̱ Dios chee̱ quebe gun zréaje da xriwe̱' le'e. Da li, lu xichaj lázrdaule dxaca lázrele gunle da xrlátaje, san lu be̱la' dxen chee̱le dxate ni'a na'le. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nadxa Jesús guxíaje̱' da xula zeajchálajle̱ne̱' Dios, na' tuze ca dxenné̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nadxa ca bezrine̱', xecha lasa xeajxraque̱' benne' ca'an dxusé̱dene̱', dxelásie̱' lawe' da xu'u bchigala xiaj lawe̱'. Benne' caní quebe belexezrela lazre̱' bi xelé̱'e̱ Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Na' ca bezrín Jesús da guxunne' lasa, na' guzre̱' benne' ca': ―¡Le gase na'a, ne le xezí' lázre'! ¡Bache na! ¡Ba bzrin zra tea' neda', Benne' Gulje̱' Bénneache, lu na' benne' dul-la ca'! ");
INSERT INTO zatNTps_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Le chasa! ¡Le chu'u na'a! ¡Ba za benne' gudée̱' neda' lu na' benne' ca' dxeledábague̱' neda'! ");
INSERT INTO zatNTps_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Dxácate̱ dxuchalaj Jesús caní, na' bzrin Judas, tu benne' nabábale̱ne̱' benne' chazrinnu ca' dxuse̱de Jesús, na' zjácale̱ benne' zan le̱', zaj nu'e̱ xia nalá, ne xaga ca'. Zaj naque̱' benne' gulesel-la benne' xíchaje̱ ca' chee̱ bxruze ca', ne benne' ca' dxuluxuzájle̱'e̱ da nadxixruj bea Dios, ne benne' gula sina ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas, benne' dxudée̱' Jesús lu na' benne' ca' dxeledábague̱' Le̱', ba blé'ene̱' benne' ca' tu da gune̱' da gaca bea na nule̱' naca Jesús, gunné̱': ―Bénnea' gunupa', benne' na' qué̱l-lale. Le xeché̱'e̱, ne le guxúe xanne' chee̱ quebe xelé̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Na' ca bzrine̱' na', gubigue̱' lau Jesús, ne dxe̱'e̱ Le̱': ―Benne' Wese̱de. Na' bnupe̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nadxa benne' ca' gule̱l-le̱' Jesús, ne belexeché̱'e̱ Le̱' ba nadxéaje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tu benne' dxune̱' Jesús tu zren guléaje̱' xia nalá chee̱', na' guchugue̱' naga tu bi we̱n zrin chee̱ bxruze blau. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nadxa Jesús guzre̱' benne' ca': ―¿Bdxuajle le'e zale nen xia nalá, ne xaga ca' chee̱ qué̱l-lale neda', dxugúnele neda' ca tu benne' gubán? ");
INSERT INTO zatNTps_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Xúgute̱ zra guzúa' neda' ládujla le'e dxusé̱deda' le'e lu xudau', na' cabata' gudé̱l-lale neda'. Da nigá dxaca na chee̱ gaca li ca da naxúaj na lu xiche chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nadxa xúgute̱ benne' ca' dxuse̱de Jesús bulusán lazre̱' Le̱'. Buluzrúnnuje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tu bi cuide', bi zéajle̱be' Jesús, ne nácube' tu ladxe' laga, gule̱l-la benne' ca' le̱be'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Na' bsanbe' ladxe' laga da nácube', na' bzrúnnujbe' gala xídezebe'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nadxa beleché̱'e̱ Jesús lau bxruze blau, na' belezraga xúgute̱ benne' xíchaje̱ ca' chee̱ bxruze ca' ga na', ne benne' gula sina ca', ne benne' ca' dxuluxuzájle̱'e̱ da nadxixruj bea Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro nawe̱' Jesús zítu'la, na' bzrine̱' chale'aj chee̱ lizre bxruze blau, naga begá'ane̱' tu zren nen zruza ni'a na' benne' xu'u lawe' ca', dxuluxuché̱'e̱ dxu'a xi'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na' bxruze blau, ne xúgute̱ benne' chee̱ xu'u lawe' blau chee̱ judío ca' gulíl-laje̱' tu da gagu na zria Jesús chee̱ xelezéquene̱' xuluzría xi'e̱ Le̱' chee̱ gatie̱', na' quebe bi belezrélene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Benne' zante̱ belún lazre̱' chee̱ Jesús. Quebe bedxúaj dizra' chee̱' tuze ca dxelenné̱' tue̱' ne xetúe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bal-le̱' belase̱', na' gulagu zría Jesús da we̱n lazre', dxelenné̱': ");
INSERT INTO zatNTps_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Netu' ba bénnentu' chee̱', gunné̱': “Neda' guchínnaja' xudau' nigá da belún bénneache, na' ca gaca chunna zra xechisa' xetú xudau' da quebe xelún bénneache.” ");
INSERT INTO zatNTps_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Cá'anqueze quebe butil-le ca da dxelenné̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nadxa bxruze blau guxase̱' ládujla xúgute̱ benne' ca', na' bche̱be̱' Jesús: ―¿Québequeze bi dizra' dxuxuzri'u Lue'? ¿Bizra da nigá dxelenné̱' chiu' Lue'? ");
INSERT INTO zatNTps_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús guzúe̱' zrize, ne gútuqueze bi dizra' buzri'e̱. Na' bxruze blau bche̱be̱' Le̱' xecha lasa, dxenné̱': ―¿Nacu' Lue' Cristo, Zri'ine Dios Lá'azxa? ");
INSERT INTO zatNTps_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Na' gunná Jesús, dxe̱'e̱ le̱': ―Awe', ca' naca'. Walé'ele neda', Benne' Gulje̱' Bénneache, dxe'a chalá'a xabe̱la chee̱ Dios, nape̱' dute̱ xel-la waca. Walé'ele neda' zezá'a lu beuj bza. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nadxa bxruze blau gucheze̱' zra lane̱', na' gunné̱': ―¿Núzradxa nachínedxu benne' xelagu zria Le̱'? ");
INSERT INTO zatNTps_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Le'e bache bénquezle ca dxenné̱' schanni' chee̱ Dios. ¿Bi dxennale le'e xca'? Xúgute̱ benne' ca' gulenné̱': ―Nabía xi'e̱ dxal-la gatie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nadxa bal-la benne' ca' gulezú lawe̱' dxuluzré̱'e̱ Le̱' zrene̱', na' bulucache̱' lau Jesús, ne buluzálaje̱' Le̱'. Dxelenné̱': ―Gunné̱ xa'a nuzra dxue Lue'. Na' benne' zruza ni'a na' benne' xu'u lawe' belú'e̱ lau Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro guzúe̱' lu chale'aj zrila, na' bzrin tu nu'ula we̱n zrin chee̱ bxruze blau, ");
INSERT INTO zatNTps_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","na' ca ble'ebe' Pedro dxe'e̱ dxu'a xi' dxuxuché'e̱, na' gunná'abe' le̱', ne gúzrebe' le̱': ―Lue' dxedále̱quezu' Jesús, benne' Nazaret na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Na' beche̱be Pedro, dxenné̱': ―Quebe núnbe'a bénnea', ne quebe nezda' nu chee̱ na' dxuchálaju'. Na' bedxúaj Pedro chale'aj naga dxelu'e̱. Nadxa gudxezre xjeaj. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nadxa nu'ula we̱n zrin chee̱ bxruze blau na' gunná'abe' Pedro xecha lasa, na' gunabe', dxe̱'e̱be' benne' ca' zaj zre̱'e̱ na': ―Benne' nigá naque̱' tuze benne' ca'an. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro xecha lasa bzue̱' Jesús chalá'ala. Xetú chí'idau' benne' ca' zaj zre̱'e̱ na' gulé̱'e̱ Pedro xecha lasa: ―Da líqueze lue' nacu' tuze benne' ca'an lawe' da nacu' benne' chee̱ xe̱zre ca' zaj nababa Galilea. Ca dxuchálaju' naca bea na da na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nadxa Pedro guzú lawe̱' dxuzría xi' cuine̱', ne be̱n chúchue̱' xrtizre̱', gunné̱': ―Quebe núnbe'a bénnea' dxennale le'e ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ca'an guca, gudxezre xjeaj da gudxupe' lasa. Nadxa Pedro xeajsá lazre̱' ca da guzre Jesús le̱', gunné̱': “Nédxudxa ca za cuezre xjeaj chupa lasa, lue' nnau' chunna lasa quebe núnbe'u neda'.” Na' ca xeajsá lazre̱' da nigá, gudxézrele̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ca guxaní' che zila, na' benne' xíchaje̱ ca' chee̱ bxruze ca' belexedupe̱' nen benne' gula sina ca', ne benne' ca' dxuluxuzájle̱'e̱ da nadxixruj bea Dios, ne xúgute̱ benne' chee̱ xu'u lawe' blau chee̱ judío ca'. Guleché̱'e̱ Jesús nadxéaje̱', na' buludée̱' Le̱' lu na' Pilato. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato gunábene̱' Jesús: ―¿Nacu' Lue' wenná bea chee̱ judío ca'? Na' beche̱be Jesús: ―Ca' naca na, ca ba gunnáu' lue'. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na' benne' xíchaje̱ ca' chee̱ bxruze ca' gulawe̱' zria Jesús da zante̱. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nadxa Pilato gunábene̱' Jesús xecha lasa: ―¿Quebe bi dizra' dxuzri'u? Gunná'xque ca da zánete̱ da dxelawe̱' zria Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesús quebe bi dizra' ca buzri'e̱. Ca' guca, bebánele̱'e̱ Pilato. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilato zua tu da dxúnqueze̱' tu iza tu iza gate dxaca Laní Pascua. Dxusane̱' tu benne' xu'e̱ lizre xia, nútete̱ze benne' xelenaba bénneache ca' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Lu xu'u lizre xia na' xu'u tu benne' le̱' Barrabás, benne' nune̱' tu zren benne' ca' belutie̱' benne' ca', gate na' gudíl-lale̱ne̱' benne' Roma ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Na' belezrín lau Pilato benne' xe̱zre ca', ne gulezú lawe̱' dxelenabe̱' lau Pilato gune̱' ca dxúnqueze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Na' beche̱be Pilato: ―¿Dxaca lázrele le'e gusana' bénnea' naque̱' wenná bea chee̱ judío ca'? ");
INSERT INTO zatNTps_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Caní gunná Pilato lawe' da dxeque be'ene̱' buludée̱' benne' xíchaje̱ ca' chee̱ bxruze ca' Jesús lu ne̱'e̱ lawe' da dxelaque̱' zre'e lazre' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Na' benne' xíchaje̱ ca' chee̱ bxruze ca' beleché̱'e̱ benne' xe̱zre ca', ne gulegú'u xel-le̱' le̱' chee̱ xelexenabe̱' lau Pilato gusane̱' Barrabás. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nadxa Pilato gunábene̱' benne' ca': ―¿Bi dxaca lázrele le'e guna' chee̱ bénnea' naque̱' wenná bea chee̱ judío ca'? ");
INSERT INTO zatNTps_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nadxa belexeche̱be̱', gulenné̱' zizraj: ―Bde̱'e̱ xaga béguaj. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Na' Pilato bche̱be̱' benne' ca': ―¿Bizra da cale̱la nun benne? Xecha lasa gulenné̱' zizraj: ―Bde̱'e̱ xaga béguaj. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nadxa Pilato bsane̱' Barrabás lawe' da dxaca lazre̱' xegá'ane̱' chawe' nen benne' xe̱zre ca'. Na' ca gudé na' bsebague̱' benne' ca' xeline̱' Jesús tu xide, na' bdee̱' Le̱' lu na' benne' ca' chee̱ xuludé̱'e̱ Le̱' xaga béguaj. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nadxa benne' dxjaque̱' wedil-la guleché̱'e̱ Jesús lu chale'aj xu'u lawe', na' bulutupe̱' xúgute̱ ljwezre' benne' dxjaque̱' wedil-la lataj na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Na' bulugácue̱' Jesús tu ladxe' bzawe, ne buluzríe̱' xíchaje̱' tu da zaj nune̱' nen zruze xaga xeche'. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nadxa gulezú lawe̱' dxelenné̱' zizraj: ―¡Gaca ba wenná bea chee̱ judío ca'! ");
INSERT INTO zatNTps_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Na' belú'e̱ xichaj Jesús nen tu xia xtila, ne buluzré̱'e̱ Le̱' zrene̱'. Na' buluzú zribe̱' lawe̱', dxelape̱' Le̱' ba lá'ana. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ca gudé bulucá'ana dítaje̱' Le̱' caní, na' belexegu'e̱ ladxe' bzawe, na' buluxugácue̱' Le̱' zra lá'anaqueze̱'. Nadxa belexebéaje̱' Le̱' chee̱ chjaque̱' naga xuludé̱'e̱ Le̱' xaga béguaj. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tu benne' chee̱ xe̱zre Cirene le̱' Simón, xra Alejandro, ne Rufo, zezé̱'e̱ le̱'e̱ xixre', na' ca bedée̱' na', na' bulusebague̱' le̱' gu'e̱ xaga béguaj chee̱ Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Guleché̱'e̱ Jesús tu lataj nazí le na Gólgota, da zéaje̱ na “Lataj Chee̱ Zrita Xichaj Benne' Gate.” ");
INSERT INTO zatNTps_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nadxa bulunézruje̱' Jesús xrise uva wal-la da nachixre da sla' chee̱ mirra. Jesús quebe gu'e̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nadxa buludé̱'e̱ Le̱' xaga béguaj, na' benne' dxjaque̱' wedil-la gulebéaje̱' da gulé'e na nule̱' xelexale̱' zra lana Jesús, na' bila xelexúa tu tue̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Guca che zílala gate na' buludé̱'e̱ Jesús xaga béguaj. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Buludé̱'e̱ da naxúaj xichaj xaga béguaj chee̱ Jesús da dxulé'e na da nabague̱', da naxúaj na caní: “Wenná Bea Chee̱ Judío Ca'.” ");
INSERT INTO zatNTps_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Cuita Jesús buludé̱'e̱ le̱'e xaga béguaj ca' chupa benne' gubán, tue̱' chalá'a xabe̱la chee̱', ne xetúe̱' chalá'a xéglala chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ca'an guca, guca li ca da naxúaj na lu xiche chee̱ Dios naga dxenné̱' caní: “Buluzue̱' Le̱' tu zren nen benne' we̱n da zrinnaj ca'.” ");
INSERT INTO zatNTps_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na' benne' dxeledée̱' na' gulenné̱' schanni' chee̱ Jesús, ne buluté̱' xíchaje̱', dxelenné̱': ―Awe'. Guchínnaju' Lue' xudau' chee̱ntu', na' gate gaca chunna zra, na' xechisu' na. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Bselá cuinu' na'a, ne bexetaj le̱'e xaga béguaj na'. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Cá'anqueze belún benne' xíchaje̱ ca' chee̱ bxruze ca', ne benne' dxuluxuzájle̱'e̱ da nadxixruj bea Dios. Belún le̱' chee̱ Jesús, dxelé̱' ljwezre̱': ―Benne' xula bselá benne, san Le̱' québequeze dxezéquene̱' guselá cuine̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Lue', Cristo, wenná bea chee̱ benne' Israel, bexetaj le̱'e̱ xaga béguaj na' chee̱ le'entu', na' chéajle̱ntu' chiu'. Cá'anqueze belún benne' ca' zaj de̱'e̱ le̱'e xaga béguaj ca' tu zren nen Jesús, gulenné̱' schanni' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ca bzrin wagubizra, na' guchul-la dute̱ lu xe̱zr la xu nigá tu chi'i wal-la gula. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ca gudé na', na' gunná Jesús zizraj: ―Eloi, Eloi, ¿lama sabactani? Da nigá zéaje̱ na: “Dios chia', Dios chia', ¿bizr chee̱ na' nusanu' neda'?” ");
INSERT INTO zatNTps_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bal-la benne' ca' zaj zre̱'e̱ na' belenne̱' na, na' gulenné̱': ―Le xene. Dxenné̱' Elías, bénnea' bchálaje̱' waláz chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nadxa tu benne' guzá chégüe̱', na' xeajlá'awaje̱' lu xrise uva zichaj tu da dxezrupe na nisa, na' bzue̱' na lawe' tu xia xtila da bcuene̱' dxu'a Jesús chee̱ xi'aje̱', na' gunná benne' nigá: ―Cuézadxu. Guxúexquedxu che wida Elías chee̱ xulétaje̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nadxa Jesús gudxezre xe̱'e̱, na' gútete̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ca ná'queze gudxeza ladxe' da ze̱ lu xudau', guca na chúpala. Gucá'a na dxa'la, bedxúajte̱ na zri'la. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na' benne' dxenná be'e̱ lu wedil-la, benne' ze̱' lau Jesús, gate na' blé'ene̱' ca gudxezre xe̱'e̱, ne ca guca gútete̱', na' gunné̱': ―Da líqueze benne' nigá guque̱' Zri'ine Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Cá'anqueze zaj ze̱ na' bal-la nu'ula dxelenné̱'e̱ zítu'la. Ládujla nu'ula caní zaj ze̱ María Magdalena, ne Salomé, ne María, xrna Jacobo cuide' ne José. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nu'ula caní gusá'acale̱ne̱' Jesús, ne gulácale̱ne̱' Le̱' gate na' gudé̱' naga nababa Galilea. Cá'anqueze zaj ze̱ na' zánedxa nu'ula xula, nu'ula ca' belezrine̱' Jerusalén tu zren nen Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ca za chizrela bzrin José, benne' Arimatea ga na'. Benne' nigá naque̱' benne' blau ládujla benne' ca' chee̱ xu'u lawe' blau chee̱ judío ca'. Cá'anqueze le̱' dxebeze̱' zra la' Dios chee̱ nna be'e̱. Lawe' da naca zra dxulucueze̱', zra nedxu chee̱ zra dxulupá'ane̱', du lazre̱' guxú'e̱ lau Pilato, na' gunabe̱' si'e̱ lataj xexu'e̱ Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bebánele̱'e̱ Pilato ca bénnene̱' ba gute Jesús, na' gunné̱' benne' dxenná be'e̱ lu wedil-la na' chee̱ gunabe̱' che ba guca ca'. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Gate bénnea' dxenná be'e̱ lu wedil-la gunné̱' ca'an guca, nadxa Pilato bnézruje̱' José lataj bexu'e̱ Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nadxa José guzi'e̱ tu ladxe' xtila laga, na' bulétaje̱' Jesús, ne bulazre̱' Le̱' ladxe' xtila na'. Na' gúxrue̱' Jesús tu lu ba da ba gude̱ne̱' le̱'e̱ xiaj xre, na' bsézxuje̱' ba na' nen tu xiaj zren. ");
INSERT INTO zatNTps_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena, ne María, xrna José belelé'equezne̱' naga bulucache̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ca gudé zra dxulupá'ane̱', na' María Magdalena, ne Salomé, ne María, xrna Jacobo, gulezí'e̱ da dxelá zixre chee̱ cheajlelu'e̱ Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Na' bál-la'la zra nedxu chee̱ da gazre zra belezrine̱' dxu'a ba gate na' za dxalaj gubizra. ");
INSERT INTO zatNTps_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Na' gulenné̱', dxelé̱' ljwezre̱': ―¿Nuzra cua xiaj da naxezxuj ba? ");
INSERT INTO zatNTps_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ca gulenné̱'e̱, na' belelé'ene̱' xiaj zren na' da bulusézxuje̱' ba, ba nadúa na. ");
INSERT INTO zatNTps_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ca gulu'e̱ lu ba, na' belelé'ene̱' tu benne' dxe'e̱ chalá'a xabe̱la, nácue̱' zra lane̱' tunna da chiche, na' belezrebe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Na' gunná benne' nigá, dxe̱'e̱ nu'ula ca': ―Quebe zrébele. Le'e dxexílajle Jesús, benne' Nazaret, bénnea' gudé̱'e̱ le̱'e̱ xaga béguaj. Bache bebán bénnea'. Québedxa xu'e̱ nigá. Le nna' lataj naga gulexrúe̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Le chjaca na'a, le cheaje̱zre benne' ca' bsé̱dene̱', ne Pedro cuía lau Jesús chéaje̱' naga nababa Galilea ca le'e. Na' xelé'equezle Le̱' ca ba gunnáqueze̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nadxa nu'ula ca' buluzrúnnuje̱', besí'aque̱' dxu'a ba lawe' da belezrébele̱'e̱. Quebe nu gulé̱queze̱' ca da guca na lawe' da dxelezrébele̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ca gudé bebán Jesús ládujla benne' gate ca guxaní' zra nedxu chee̱ da gazre zra, na' ble'e lawe̱' zate ca' María Magdalena, nu'ula na' bebéaj Jesús gazre be' xriwe̱' guxú'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nu'ula nigá guxíaje̱' xeaje̱zre̱' benne' ca' gulaque̱' Jesús tuze, zaj zre̱'e̱ baxácheze, ne dxelebezre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Gate na' gulenne̱' nabán Jesús, na' ba ble'e nu'ula nigá Le̱', quebe guléajle̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ca gudé na' ble'e lau Jesús nazrala chupa benne' ca' bsé̱dene̱' zaj xu'e̱ neza le̱'e̱ xixre'. ");
INSERT INTO zatNTps_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Benne' caní belexebi'e̱, na' xeajlegue̱zre̱' benne' xezícala. Cá'anqueze benne' caní quebe guléajle̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ca gudédxa, na' ble'e lau Jesús chinéaj benne' ca' bsé̱dene̱' ca zaj dxe'e̱ dxelawe̱', na' gudil-le̱' le̱' lawe' da quebe guléajle̱'e̱ ba bebane̱', ne lawe' da zaj naque̱' lázrdau zide' lawe' da quebe guléajle̱'e̱ chee̱ benne' ca' belexelé'ene̱' Le̱' ca gudé bebane̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Na' gunné̱', dxe̱'e̱ benne' ca': ―Le chjaca du ca naca xe̱zr la xu. Le cu'u lban chee̱ dizra' chawe' chia' chee̱ xelénqueze xúgute̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Benne' chéajle̱'e̱, ne chue̱' nisa, la bénnea', na' benne' quebe chéajle̱'e̱, wabía xi' bénnea'. ");
INSERT INTO zatNTps_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Da dxelunna bea caní xululé'e benne' ca' xeléajle̱'e̱ chia', xuluchínene̱' La neda' chee̱ xelexebéaje̱' be' xriwe̱'. Xuluchálaje̱' dizra' nazrala. ");
INSERT INTO zatNTps_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Welúxrue̱' be̱la' ca', ne che xelé'aje̱' da gute benne', quebe bi xeléquene̱'. Cá'anqueze wuluxrúa ne̱'e̱ benne' quebe chawe' zaj zue̱', na' xelexexaque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ca gudé bchálaj Xránadxu Jesús nen benne' ca', na' Dios bechise̱' Le̱' xabáa, na' gudxé'e̱ chalá'a xabe̱la chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nadxa benne' ca' guledxúaje̱', xeajlelu'e̱ lban chee̱ dizra' chawe' nigá du ca naca xe̱zr la xu nigá. Lé̱queze Xránadxu gúcale̱ne̱' le̱', na' bdxixruj be'e̱ dizra' chee̱' ne̱ chee̱ xel-la waca ca' da za xabáa da belune̱'. ¡Ca'an gaca na!");
INSERT INTO zatNTps_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Benne' zan ba belune̱' ca da gulezéquene̱' buluzúaje̱' cáte̱ze naca da guca ládujla dxi'u, ");
INSERT INTO zatNTps_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","cáte̱ze na' gulé̱ benne' ca', benne' belelé'ene̱' nédxudaute̱ ca naca da guca na, na' buluchálaje̱' dizra' chawe' na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Cá'anqueze neda' ba bchi'a xánnia' xúgute̱ da ca' gulaca na nédxudaute̱, na' dxéqueda' chawe' guzúaja' da nigá chiu' cáte̱ze guca, bi nazrí'ite̱ lazra', lue', Teófilo. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Dxuna' caní chee̱ nézenu' naca na da li ca da ba bululé'ene̱' lue'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Gate na' naca Herodes wenná bea chee̱ xe̱zre ca' zaj nababa Judea, na' zua tu bxruze le̱' Zacarías, benne' nababe̱' cue' bxruze ca' gunná be'e Abías ca ni'te. Zru'ula Zacarías na' le̱' Elisabet, na' nácaqueze Zacarías na' zre sua benne' ca' gulebábale̱ bxruze Aarón. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías ne zru'ule̱' Elisabet gulaque̱' xrlátaje lau Dios, ne dxelune̱' ca zaj naca da bdxixruj bea Xránadxu, ne ca da naxúaj na lu da gunné̱'. Ca'an guca, quebe nu guzeque gagu zria le̱' lau Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Quebe nu zrí'ine̱' chilá', lawe' da naca Elisabet na' nu'ula wizre, na' dxúpate̱' zaj bezúale̱'e̱ gula. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tu zra, gate belexala bxruze ca' naga nababa Zacarías xelune̱' zrin lu xel-la bxruze chee̱' lau Dios, ");
INSERT INTO zatNTps_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","cáte̱ze naca da dxelún bxruze ca', na' bexala Zacarías chu'e̱ lu lataj lá'azxa chee̱ Xránadxu lu xudau' chee̱ guzezxe̱' xala. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Dxácate̱ na' dxezxe xala na', ca naca benne' ca' zaj zra' chalé'ajla dxuluchálajle̱ne̱' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nadxa ble'e lau tu gubáz chee̱ xabáa chee̱ Xránadxu, ze̱' chalá'a xabe̱la chee̱ cugu naga zría xala dxezxe na. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ca ble'e Zacarías gubáz chee̱ xabáa na', guzúe̱' ste̱be, ne bzrébele̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Gubáz chee̱ xabáa na' guzre̱' le̱': ―Zacarías, quebe zrebu', lawe' da ba ben Dios dizra' da dxuchálajle̱nu' Le̱', na' nu'ula chiu', Elisabet, walaj tu zri'ine̱', bi na' guzú' labe' Juan. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wabéle̱'e̱nu', ne gaca chiu' tu da ba neza zrente̱, na' benne' zan xelebene̱' lawe' da ba gulaj bidu na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ca'an gaca lawe' da gaca zri'inu' szrente̱ lau Dios. Quebe xí'ajbe' xrise uva wal-la, u da dxusuzre na bénneache, na' gate gálajte̱be' tu súale̱zqueze Be' Lá'azxa nen le̱be'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ne̱ chee̱ le̱be' benne' zan xelexaque̱' bi chee̱ Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Juan nigá quia laube' lau Xránadxu, na' Be' na', ne xel-la waca da gulezúale̱ na Elías, bénnea' bchálaje̱' waláz chee̱ Dios gate nate, xelezúale̱ na le̱be', chee̱ guzúabe' tuze benne' ca' zaj naque̱' xra xrna nen zrí'ine̱', ne chee̱ gulé'ebe' benne' dxeledábague̱' Dios chee̱ xelune̱' ca dxenná xrtizra' Dios. Ca'an gaca, gucá'ana cháwebe' bénneache chee̱ xelezí' lu ne̱'e̱ Xránadxu. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías na' bche̱be̱' gubáz chee̱ xabáa: ―¿Ájazra gaca nezda' gaca caní? Neda' ba nagúlale̱'a, ne cá'anqueze naca nu'ula chia'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Na' beche̱be gubáz chee̱ xabáa na': ―Neda' naca' Gabriel, ne naca' we̱n zrin chee̱ Dios. Le̱' gusel-le̱' neda' chee̱ guchálajle̱na' lue', ne guzenda' lue' dizra' chawe' nigá. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Na'a, lawe' da quebe guxéajle̱'u da gucha' lue', xegá'anu' quebe gaca nníu' cadxa galaj zri'inu'. Caní gaca na ca zrinte̱ zra chee̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Dxácate̱ na' zaj zra' benne' ca' chalé'ajla, dxelebeze̱' Zacarías, ne dxelexebánene̱' lawe' da dxezréle̱'e̱ne̱', quebe dxedxúaje̱' lu lataj lá'azxa. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Gate bedxúaj Zacarías, québedxa dxaca nnie̱'. Nadxa guleque bé'ene̱' ba ble'e Zacarías tu da ble'e Dios le̱' lu lataj lá'azxa na'. Na' le̱' bta ná'ase̱', lawe' da quebe dxaca nnie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ca xeajsé̱ chee̱ zra ca' dxal-la' gun Zacarías zrin chee̱ xudau', na' bezé̱'e̱ zexíaje̱' lizre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ca gudé na' zru'ule̱' Elisabet ba zue̱' zi'i, na' quebe bdxúaje̱' lataj bchina' chie̱' ca gazxu' beu', na' dxenné̱' lu lázrdawe̱': ");
INSERT INTO zatNTps_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Xrana' Dios ba be̱ne̱' chia' da nigá chee̱ québedxa xuluzúa bénneache neda' chalá'ala.” ");
INSERT INTO zatNTps_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ca gudé xrupa beu' gate na' bchálajle̱ gubáz chee̱ xabáa na' Zacarías, na' Dios gusel-le̱' le̱' tu xe̱zre nababa Galilea nazí le na Nazaret, ");
INSERT INTO zatNTps_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","chee̱ cheajchálajle̱ne̱' tu nu'ula cuíde'dau' le̱be' María. Le̱be' ba zua guchaga na'be' benne' biu na' le̱' José, benne' naque̱' zri'ine zre sua wenná bea David. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gubáz chee̱ xabáa na' guxú'e̱ naga zua María na', na' guzre̱'-be': ―Padiuzre. Dios dxune̱' lue' tu culuén. Xránadxu zúale̱ne̱' lue'. Dios ba be̱ne̱' tu da cháwedxa chiu' quézcala chee̱ xúgute̱ nu'ula ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Gate María na' ble'ebe' gubáz chee̱ xabáa na', bebánebe' ca naca dizra' na', na' gunabe' lu lázrdaube': ¿Bizr chee̱ na' dxugape̱' neda' diuzre caní? ");
INSERT INTO zatNTps_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nadxa gunná gubáz chee̱ xabáa na': ―María, quebe zrebu' lawe' da ba bzrué'enu' tu culuén da dxun Dios chiu' lue'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Na'a, zua da gunna Dios chiu', na' galaj tu bidu biu chiu', na' guzú' labe' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Le̱be' gácabe' szren, na' xelennáqueze̱' naque̱' Zri'ine Dios szrente̱, na' Xránadxu Dios gune̱' Le̱' wenná bea ca guca xra xrtawe̱' David, ");
INSERT INTO zatNTps_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","chee̱ nna bé'etecaze̱' xe̱zr la xu Israel, na' xel-la dxenná bea chee̱' quebe cheajsé̱queze chee̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nadxa María bché̱bebe' gubáz chee̱ xabáa: ―¿Ájazra gaca da nigá, lawe' da quebe nu benne' biu zúale̱na'? ");
INSERT INTO zatNTps_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Gubáz chee̱ xabáa na' gunné̱': ―Be' Lá'azxa chee̱ Dios sue̱' xichaj lázrda'u, na' xel-la waca chee̱ Dios szrente̱ sua na nen lue'. Chee̱ le̱ na' bidu na' gálajbe' gácaquezebe' chee̱ Dios, na' sí'queze labe' Zri'ine Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Cá'anqueze bila ljwezru' Elisabet wálajqueze bidu chee̱' lácala ba naque̱' benne' gula. Ca'an naca, nu'ula na' gulenné̱' naque̱' wizre, ba zeaj xrupa beu' bnezruj Dios chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Quebe bi de̱ da quebe gaca gun Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nadxa gunná María: ―Neda' nácaqueza' we̱n zrin chee̱ Xránadxu. Gun Dios chia' ca da ba gunnáu'. Na' gubáz chee̱ xabáa na' bezé̱'e̱ naga zua María na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ca lu zra na' María guzá'abe' zéajbe' tu xé̱zredau' da zua na laduj xi'a ca' chee̱ ga nababa Judea. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Na' guxú'ube' lizre Zacarías, ne bgápabe' diuzre Elisabet. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Gate ben Elisabet dizra' da gunné̱ María, na' bidu na' xú'ube' le̱'e Elisabet guxrítebe', na' guzúale̱ Be' Lá'azxa le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Nadxa gunné̱' tu chi'e̱ zizraj: ―Dios ba be̱ne̱' tu da cháwedxa chiu' quézcala chee̱ xúgute̱ nu'ula ca', lawe' da ba zua da be̱nna Dios chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Núzraqueze naca' neda', za xrna Xrana' ga zua' neda'? ");
INSERT INTO zatNTps_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Cáte̱ze benda' dizra' da gunnéu', na' guxrite bidu chia' lu le̱'a lu xel-la dxebé chee̱be'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ba neza naca na chiu' guxéajle̱'u lawe' da gaca li ca da gunná Xránadxu. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nadxa gunná María: Bénne'du xu'a dxue lá'ana na Xrana'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Lázrdawa' dxebé na ca dxun Dios, weselá chia'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Lawe' da gudxé' Dios gunne xue chia', nácaqueza' we̱n zrin chee̱'. Na'a su lau na, xúgute̱ benne' xelenné̱' nazi'a tu culuen zren chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Dios Szrente̱ ba be̱ne̱' tu da zrente̱ chia' neda'. Chee̱ le̱ na' lá'azxa naca La Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Le̱' xexache lázrqueze̱' xúgute̱ benne' ca' dxelezrebe̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Da zrente̱ ba be̱n Le̱'. Bzue̱' zrila benne' ca' dxulucá'ana szren cuine̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Bebéaje̱' benne' blau ca' lu lataj chee̱', ne bechise̱' benne' dxexruj lazre' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Bnézrujle̱'e̱ da gulagu benne' dxeledún, na' benne' gunní'a ca' bca'ane̱' le̱' cá'aze. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Gúcale̱ne̱' benne' Israel, benne' we̱n zrin chee̱' ca' lawe' da bezrí lázrqueze̱' le̱', ");
INSERT INTO zatNTps_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ca da guche̱be lazre̱' chee̱ xra xrtáudxu ca', chee̱ Abraham, ne chee̱ benne' xrtie̱' ca' chadía chacanna. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María begá'anale̱be' Elisabet ca chunna beu', na' ca gudé na' bezrinbe' lízrebe'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ca gudé na' guxá' beu' chee̱ Elisabet na' chee̱ galaj bidu chee̱', na' guzane̱' tu bi biu chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Benne' walízr chee̱' ca', ne xrtia ljwezre̱' belezrine̱' dxelebene̱' nen le̱', gate belenne̱' Dios bezrí lázrele̱'e̱ le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Gate guca xrunu' zra, belezrine̱' chee̱ xelechúgue̱' lu xpé̱labe' da gulé'e na naca be̱' bi chee̱ Dios, na' gulaca lazre̱' xuluzúe̱' labe' Zacarías ca le̱ xrabe'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Na' gunná xrnabe': ―Quebe gaca. Dxal-la' si' labe' Juan. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Na' gulé̱'e̱ le̱': ―¿Bizr chee̱ na'? Quebe nu chilá' xrtia ljwézrele le̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Na' buluche̱be̱' xra bidu na', bulutá ne̱'e̱ chee̱ xelenézene̱' ájazra guzúe̱' labe'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Na' xrabe' na' gunabe̱' tu blágadau', na' bzuaje̱' le̱'e̱ na: Juan si' labe'. Na' xúgute̱ benne' ca' belexebánene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ca' guca Zacarías benné̱', na' guzú lawe̱' dxue lá'ane̱' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ca belelé'ene̱' da nigá, xúgute̱ benne' walízr chee̱' belexebánene̱', na' ca naca xe̱zre zaj nnita laduj xi'a ca ga nababa Judea, buluchálaje̱' ca da guca. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Xúgute̱ benne' belenne̱' na, gulezú lawe̱' dxelenné̱' lu lázrdawe̱', ne buluche̱be ljwezre̱' tue̱' xetúe̱': ―¿Ájazraqueze gun bi nigá? Naca bea na Xránadxu zúale̱ne̱'-be'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Na' Be' Lá'azxa guzúale̱ne̱' Zacarías, xra bidu nigá, na' bchálaje̱' waláz chee̱ Dios, gunné̱': ");
INSERT INTO zatNTps_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","¡Gaca ba Xránadxu, Dios chee̱ xe̱zre Israel! Ba ble̱'e̱ naga zúadxu, bénneache chee̱', na' bselé̱' dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ba gusel-le̱' tu benne' wál-lale̱'e̱, weselá chee̱dxu. Bénnea' gulaj ládujla xrtia David, benne' we̱n zrin chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ca'an guche̱be lazre' Dios lu dxu'a benne' ca' buluchálaje̱' waláz chee̱' nédxudaute̱. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Guche̱be lazre̱' guselé̱' dxi'u lu na' benne' dxelezré̱'e̱ dxi'u, ne lu na' benne' dxelecuídene̱' dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Xezrí lazre̱' xra xrtáudxu ca', ne quebe gal-la lazre̱' xel-la wezría lá'azxa chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Da nigá naca na da guche̱be lazre' Dios da bzua chache̱' nen xra xrtáudxu Abraham, da naca tu da gunne̱' chee̱dxu dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Guche̱be lazre̱' guselé̱' dxi'u lu na' benne' dxelezré̱'e̱ dxi'u chee̱ gaca gundxu zrin chee̱', ne quebe zrébedxu, ");
INSERT INTO zatNTps_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ne gácadxu xrlátaje lau Le̱', ne gácadxu bi cheé̱queze̱' xúgute̱ zra naca bandxu. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Lue', zrí'ina'dau', sí'queze lau' bi guchálajqueze waláz chee̱ Dios szrente̱, lawe' da quia lau' lau Xránadxu, salju' neza chee̱ Xránadxu, ");
INSERT INTO zatNTps_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Guzénenu' bénneache chee̱', Le̱' gunite lawe̱' dul-la chee̱', ne guselé̱' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ca'an gaca lawe' da dxexezrí lazre' Dios dxi'u. Dxune̱' na'a dxalaj tu xi' chee̱ xabáa da dxusení' chee̱dxu, ");
INSERT INTO zatNTps_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","na' gusení na naga zaj zra' benne' zaj zre̱'e̱ lu na' xel-la gute, chee̱ cu'u na dxi'u lu neza xrtante̱ lau Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Bidu na' bgúlabe', ne bgula bénne'du xu'ube' chawe' lu da naca chee̱ Dios. Guzúaquezbe' le̱'e̱ xixre' lawe' lataj cadxa bzrin zra ble'e laube' xe̱zre Israel. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ca lu zra na' gate dxenná bea Augusto, benne' xe̱zre Roma, benne' dxenná be'e̱ xúgute̱ cue' xe̱zr la xu, le̱' gunná bé'ene̱' xelú'u lu xiche xúgute̱ benne' zaj zre̱'e̱ xe̱zr la xu. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Da nigá naca da nédxudau' gulú'u bénneache lu xiche. Guca caní gate naca Cirenio benne' zaj xu'u lu ne̱'e̱ xe̱zre ca' zaj nababa Siria. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Xúgute̱ bénneache dxun na ba xen chjaque̱' lu xe̱zre naga zaj nababe̱' chee̱ xelu'e̱ lu xiche. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Chee̱ le̱ na' José guzé̱'e̱ lu xe̱zre Nazaret, da nababa Galilea, chee̱ bzrine̱' lu xe̱zre Belén, da nababa Judea, naga gulaj wenná bea David. Bzrin José na' lawe' da naque̱' xrtia David na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","José guxíaje̱' Belén chee̱ chu'e̱ lu xiche tu zren nen María. María nigá ba naché̱bebe' guchaga ná'ale̱be' José, na' ba bnezruj Dios chee̱be'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Dxácate̱ na' zaj zre̱'e̱ lu xe̱zre Belén, na' bzrin zra san María bidu chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Lu xe̱zre na' gulaj bidu nedxu chee̱', na' bchele̱'-be' ládxe'du ca', na' gúxrue̱'-be' xu'u naga dxelún chi'e̱ da dxelagu bea ca', lawe' da quebe ga bzrela tu lataj lu xu'u naga che̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Gagu cuita xe̱zre Belén zaj zra' benne' ca' dxuluxúe̱' zrila' ca', dxelexegá'ane̱' le̱'e̱ xixre' chizrela, dxuluxúe̱' zrila' chee̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Naga zaj zre̱'e̱ ble'e lau tu gubáz chee̱ xabáa chee̱ Xránadxu. Na' xel-la naxaní' chee̱ Xránadxu Dios bsaní na naga zaj zre̱'e̱. Ca'an guca, belezrébele̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Na' gubáz chee̱ xabáa na' guzre̱' le̱': ―Quebe zrébele, lawe' da dxuzenla' le'e tu dizra' chawe'. Ne̱ chee̱ dizra' nigá xelebéle̱'e̱ xúgute̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Na'a, lu xe̱zre chee̱ David, ba gulaj tu bidau' gácabe' weselá chee̱le. Bi nigá naque̱' Cristo, Xránadxu. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Da nigá gaca na tu da gunna bea na chee̱le. Cheajxrácale bidu dxe'ene nigá, dxélabe' ládxe'du ca', ne de̱be' tu xu'u naga dxelún chi'e̱ da xelagu bea ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Chadí lau, cuita gubáz chee̱ xabáa na' bululé'e lau zandxa gubáz chee̱ xabáa, dxelúe lá'ane̱' Dios, dxelenné̱': ");
INSERT INTO zatNTps_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Gaca ba Dios na'ala, na' lu xe̱zr la xu nigá sua xel-la dxebeza zri lazre' chee̱ bénneache, benne' dxelune̱' ca da dxaca lazre' Dios! ");
INSERT INTO zatNTps_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Gate besí'aca gubáz chee̱ xabáa ca', zeajxaque̱' xabáa, nadxa benne' ca' dxuluxúe̱' zrila' gulezú lawe̱' dxelé̱' ljwezre̱' tue̱' xetúe̱': ―Chéajxquedxu lu xe̱zre Belén cheajnnadxu da ba guca, ca da ba gunná Xránadxu Dios, guzre̱' dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ca'an guca, besí'aca zé̱zxuje̱', na' xeajlexraque̱' María ne José, ne bidu dxe'ene na', de̱be' xu'u naga dxelún chi'e̱ da xelagu bea ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Gate belelé'ene̱' bidu na', na' buluchálajle̱ne̱' benne' ca' ca da gunná gubáz chee̱ xabáa ca da naca chee̱ bidu na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Na' xúgute̱ benne' ca' belenne̱' da nigá belexebánele̱'e̱ne̱' ca da gulenná benne' caní. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María bcache̱' da nigá lu xichaj lázrdawe̱', na' blaba lazre̱' ca naca da nigá. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ca'an guca besí'aca benne' ca' dxuluxúe zrila', dxulucá'ana szrene̱' Dios, ne dxelúe lá'ane̱' Le̱' ca naca xúgute̱ da belenne̱', ne da belelé'ene̱', lawe' da guca xúgute̱ ca da guzre gubáz chee̱ xabáa na' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ca guca xrunu' zra, na' gulechugue̱' tu lu xpe̱la bidu na' ca da nadxixruj bea na chee̱ Dios, na' belú'e̱ La bidu na' Jesús, cáte̱ze naca da gunná gubáz chee̱ xabáa na', guzre̱' María nédxudxa ca za gu'e̱ bidu na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ca bzrin zra chee̱ xelune̱' ca bdxixruj bea Moisés chee̱ xelexexaque̱' chawe' lau Dios, na' belú'e̱ bidu na' lu xe̱zre Jerusalén chee̱ xuluzúe̱'-be' lu na' Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Belune̱' caní lawe' da ba naxúaj lu da nadxixruj bea Xránadxu Dios da dxenná na caní: Xúgute̱ bi biu, bi nedxu gálajbe' dxal-la' guzúale-be' chee̱ Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Na' xjaque̱' xeajlegu'e̱ dxen chee̱ be̱ xíxre'du ca' lau Dios ca da dxenná da nadxixruj bea na chee̱ Xránadxu Dios, da dxenná na: Chupa bgugu, che chupa bxínnedau'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ca lu zra na' zua tu benne' biu gula lu xe̱zre Jerusalén, le̱' Simeón. Naque̱' tu benne' chawe', na' dxue lá'anaqueze̱' Dios, ne dxebeze̱' benne' sel-la Dios chee̱ guselé̱' bénneache Israel. Zúale̱ Be' Lá'azxa chee̱ Dios Simeón na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Be' Lá'azxa ba guzre̱' Simeón na' quebe gatie̱' cadxa lé'ene̱' Cristo, benne' na' sel-la Xránadxu Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Simeón nigá guxíaje̱' lu xudau' lawe' da bsi' Be' Lá'azxa chee̱ Dios le̱'. Na' gate xra xrna bidu Jesús zaj nu'e̱-be' lu xudau' chee̱ xelune̱' chee̱be' ca da bdxixruj be'e Moisés, ");
INSERT INTO zatNTps_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","na' Simeón na' guqué̱'e̱ bidu na'. Bnide̱'-be', ne be̱ lá'ane̱' Dios, gunné̱': ");
INSERT INTO zatNTps_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Xrana', na'a waca gunnu' lataj gatia' lu xel-la dxebeza zri lazre' lawe' da ba be̱nu' ca da guche̱be lazru' chia', naca' we̱n zrin chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nen xiaj láuqueza' ba ble'eda' Benne' Weselá, ");
INSERT INTO zatNTps_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Bénnea' ba bzu' chee̱ gácalene̱' xúgute̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Le̱' naque̱' tu xi' da gusení na chee̱ benne' quebe zaj nababe̱' Israel. Ne̱ chee̱ Le̱' gaca tu da ba neza chee̱ bénneache chiu', benne' Israel. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José ne xrna Jesús belexebánele̱'e̱ne̱' ca da gunná Simeón chee̱ bidu Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Nadxa Simeón gunabe̱' lau Dios gune̱' chee̱' da chawe', na' guzre̱' María, xrna Jesús: ―¡Gunná'xque nigá! Bidu nigá, Dios nuzúe̱' le̱be' chee̱ gunbe' chee̱ benne' Israel ca', cheajlecházie̱' benne' zante̱ lu na' da xriwe̱', na' benne' zante̱ xelexexase̱' lau Dios. Le̱be' gácabe' tu da dxunna bea chee̱ Dios, na' benne' zante̱ xuluzúe̱' le̱be' chalá'ala. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ne̱ chee̱ le̱be' gulé'e lau ca da dxeajlesá lazre' tu tue̱'. Na' chiu' lue' da nigá gaca na ca tu xia nalá, da cheajsúa lu lázrda'u. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Cá'anqueze zua na' tu nu'ula dxenné̱' waláz chee̱ Dios, le̱' Ana. Nu'ula nigá naque̱' zri'ine Fanuel, ne xrtia Aser. Ba naque̱' nu'ula gúlale̱'e̱. Bchaga ne̱'e̱ gate na' naque̱' nu'ula cuíde'te̱, na' guzúale̱ne̱' benne' chee̱' gazre iza. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Na' begá'ane̱' tuze̱', ne ba xu'e̱ tapa lalaj tapa iza. Quebe becuase̱' xudau', na' dxune̱' zrin chee̱ Xránadxu Dios te zra chizrela. Dxune̱' gubasa, ne dxuchálajle̱ne̱' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ana na' bzrínqueze̱' na', na' ca gudé guzre̱' Dios: “Xcalenu'”, na' guzú lawe̱' dxuchálaje̱' chee̱ bidu Jesús nen xúgute̱ benne' ca' dxelebeze̱' benne' na' sel-la Dios chee̱ guselé̱' benne' Jerusalén ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ca belune̱' xúgute̱ ca da dxenná da nadxixruj bea Xránadxu, nadxa besiá'que̱' xjaque̱' naga nababa Galilea, na' belexezrine̱' xe̱zre Nazaret da naca lazrie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na' bidu Jesús bgúlabe', ne gúcadxabe' chuchu, ne gúcadxabe' bi naxéajni'i, na' Dios bca'ane̱' le̱be' chawe'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Xra xrna' Jesús, tu tu iza dxjá'aque̱' xe̱zre Jerusalén gate dxu'u laní chee̱ xulusá lazre' benne' judío ca da be̱n Dios, bebéaje̱' xra xrtawe̱' ca' lu xe̱zr la xu Egipto. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ca guque Jesús chazrinnu iza, na' xjá'aque̱' xúgute̱' Jerusalén, ca dxelúnqueze̱' ca dxaca laní. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ca gudé laní, na' besiá'que̱', na' bidu Jesús begá'anabe' Jerusalén, ne quebe guleque be'e xrnabe', ne José. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Dxeléquene̱' Jesús zezabe' ládujla benne' zan ca', na' besiá'que̱' tu zra nez. Gate belexilje̱'-be' ládujla benne' xrtie̱' ca', ne benne' ca' zaj núnbe'e̱, ");
INSERT INTO zatNTps_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","quebe belexezrélne̱'-be'. Ca'an guca belexebi'e̱ zeajxá'aque̱' Jerusalén chee̱ cheajlexedílje̱'-be' na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ca gudé guca chunna zra, nadxa belexezrélne̱'-be' lu xudau', dxe'ebe' ládujla benne' ca' dxuluxuzájle̱'e̱ da nadxixruj bea Dios, na' dxenbe' ca dxelenné̱', ne dxuché̱bebe' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Xúgute̱ benne' ca' dxelenne̱' dxelexebánene̱' chee̱be' ca naca xel-la sina chee̱be', ne ca naca da dxuchálajle̱be' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Gate belelé'e xra xrnabe' le̱be', na' belexebánene̱'. Na' gunná xrnabe', dxe̱'e̱-be': ―Zri'ina', ¿bizr chee̱ na' be̱nu' caní nen netu'? Cadite ste̱be ba guzúantu' chiu' dxexílajntu' lue', xrau' ne neda'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nadxa Jesús dxe̱'e̱be' le̱': ―¿Bizr chee̱ na' dxexílajle neda'? ¿Quebe nézele le'e dxal-la' guna' neda' da naca chee̱ Xra'? ");
INSERT INTO zatNTps_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Xra xrnabe' quebe guléajni'ine̱' ca da gúzrebe' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nadxa bezále̱be' le̱' zeajxá'aque̱' Nazaret, na' gúcaquezebe' bi wezúa dizra' chee̱ xra xrnabe'. Na' xrnabe' bcache chawe̱' xúgute̱ da nigá lu lázrdawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús zéajbe' dxegúlabe' lu be̱l-la' dxen chee̱be', ne lu xichaj lázrdaube', na' dxedxúajquezebe' chawe' lau Dios, ne lau bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Iza chinu' ca dxenná bea Tiberio, benne' dxenná be'e ca naca xe̱zr la xu, na' Poncio Pilato dxenná be'e̱ naga nababa Judea, na' Herodes dxenná be'e̱ naga nababa Galilea, na' Felipe, benne' biche Herodes, dxenná be'e̱ naga nababa Iturea, ne Traconite, na' Lisanias dxenná be'e̱ naga nababa Abilinia. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Na' Anás, ne Caifás zaj naque̱' bxruze blau. Ca lu zra na' Dios bchálajle̱ne̱' Juan, zri'ine Zacarías, naga zua Juan le̱'e̱ xixre' lawe' lataj. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juan na' gudée̱' ca naca xé̱zredu ca' zaj nnitan' chalá'a weaj xe̱gu Jordán, na' dxe̱'e̱ benne' ca' dxal-la' xelexebí'i lazre̱', ne xeledxúe̱' nisa chee̱ gunite lau Dios chee̱ xtul-le'. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Caní guca ca na' gunná Isaías, benne' bchálaje̱' waláz chee̱ Dios, gunné̱': Nen tu chi'i bénnea' dxenné̱' zizraj le̱'e̱ xixre' lawe' lataj. Dxenné̱': Le gucueza neza naga te Xránadxu. Le xulí chawe' neza lase chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ca naca zrítudu ca' le xuzrá na. Ca naca xi'a ca', ne xí'adu ca' xelexaca na tu li. Neza xúca'du ca' xelexelí na. Neza da quebe nalí xelexaca na tu li. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ca naca bénneache xelelé'ene̱' Benne' Weselá sel-la Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Gate benne' ca' belezrine̱' lau Juan chee̱ xeledxúe̱' nisa, na' le̱' dxe̱'e̱ benne' ca': ―Xrtia be̱la snia. ¿Ble'e nu benne' le'e chee̱ cuásale ca naca xel-la dxezrá'a chee̱ Dios da ba za? ");
INSERT INTO zatNTps_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Le gun da gulé'e na ba bebí'i lázrele, ne quebe nnale lu lázrdaule: Nácantu' xrtia ljwezre Abraham. Neda' dxapa' le'e, Dios wazéquene̱' xexune̱' xiaj caní xrtia Abraham. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Xa waga ba de̱ cuásate̱ na chee̱ chugue̱' xaga ca', na' xúgute̱ xaga da quebe dxelebía na da zixre chawe' welechugue na, na' xuluzré̱'e̱ na lu xi'. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nadxa benne' ca' buluche̱be̱' le̱': ―¿Bi dxal-la' guntu'? ");
INSERT INTO zatNTps_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan beche̱be̱': ―Benne' de̱ chupa zre̱' dxal-la' gunézruje̱' tu na benne' quebe de̱ chee̱', na' benne' de̱ da dxawe̱' dxal-la' gunézruje̱' da gagu bénnea' quebe bi de̱ chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Cá'anqueze belelá' benne' wechizruj ca' chee̱ xeledxúe̱' nisa, na' buluche̱be̱' Juan: ―Benne' wese̱de, ¿bi da dxal-la' guntu' netu'? ");
INSERT INTO zatNTps_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan guzre̱' le̱': ―Quebe guchízrujle da zrendxa ca da nadxixruj bea na. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Cá'anqueze bal-la benne' dxjaque̱' wedil-la buluche̱be̱' le̱': ―¿Gazra netu'? ¿Bi da dxal-la' guntu'? Juan beche̱be̱': ―Quebe guchébele benne', ne quebe gágule le̱' zria lu da we̱n lazre' chee̱ cuale dumí chee̱', na' le be nen cadite názrujle. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Benne' zaj zre̱'e̱ na' zaj zue̱' ste̱be, na' dxuluche̱be̱' lu lázrdawe̱' che Juan na' naque̱' Cristo, benne' nasel-la Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juan na' gunné̱': ―Neda', da li dxuchúa' le'e nisa nen nisa. Wida tu benne' gune̱' da dxulé'e xel-la dxedxúa nisa nigá, guzúe̱' le'e Be' Lá'azxa, ne xi' chee̱'. Benne' nigá nápadxe̱' xel-la dxenná bea ca neda', na' quebe naca chia' cuéaja' xel-la chee̱' da xu'u ni'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ba nuxre̱' da dxun be' chee̱', na' guchi'e̱ naga dxine̱' zrua' xtila. Na' xutupe̱' zrua' xtila, guzrá' chawe̱' na lizre̱'. Guzezxe̱' xizre chee̱ na lu xi' da cabata' xul-la na. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ca naca dizra' nigá, ne xezícadxa dizra' zan bchálajle̱ne̱' benne' ca' ca naca dizra' chawe' chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Juan gudil-le̱' Herodes, benne' dxenná be'e̱, lawe' da zúale̱ne̱' Herodías, zru'ula Felipe, benne' biche Herodes na', ne lawe' da ba be̱ne̱' da zante̱ da cale̱la. Nadxa Herodes ");
INSERT INTO zatNTps_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","bé̱ndxaqueze̱' da cale̱la, gulu'e̱ Juan lizre xia. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Gate ne dxuchúa Juan na' bénneache nisa, cá'anqueze Jesús gudxúe̱' nisa, na' gate dxuchálajle̱ne̱' Dios, na' bxalaj xabáa, ");
INSERT INTO zatNTps_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na' betaj Be' Lá'azxa lawe' Jesús. Ble'e lawe̱' ca tu bgugu chiche, na' ben tu chi'e̱ xabáa, dxenné̱': ―Lue' nacu' zri'ina' nazrí'ite̱ lazra'. Dxezaca ba lázrele̱na' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús nape̱' ca chi dxua iza gate guzú lawe̱' dxune̱' zrin chee̱'. Dxeleque benne' naque̱' zri'ine José. Naca Jesús zre sua Elí, xra María. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí na' guque̱' zri'ine Matat, Matat na' guque̱' zri'ine Leví, Leví na' guque̱' zri'ine Melqui, Melqui na' guque̱' zri'ine Jana, Jana na' guque̱' zri'ine xetú José. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José nigá guque̱' zri'ine Matatías, Matatías na' guque̱' zri'ine Amós, Amós na' guque̱' zri'ine Nahum, Nahum na' guque̱' zri'ine Esli, Esli na' guque̱' zri'ine Nagai. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai na' guque̱' zri'ine Maat, Maat na' guque̱' zri'ine xetú Matatías, Matatías nigá guque̱' zri'ine Semei, Semei na' guque̱' zri'ine xetú José, José nigá guque̱' zri'ine Judá. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá na' guque̱' zri'ine Joana, Joana na' guque̱' zri'ine Resa, Resa na' guque̱' zri'ine Zorobabel, Zorobabel na' guque̱' zri'ine Salatiel, Salatiel na' guque̱' zri'ine Neri. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri na' guque̱' zri'ine xetú Melqui, Melqui nigá guque̱' zri'ine Adi, Adi na' guque̱' zri'ine Cosam, Cosam na' guque̱' zri'ine Elmodam, Elmodam na' guque̱' zri'ine Er, ");
INSERT INTO zatNTps_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er na' guque̱' zri'ine Josué, Josué na' guque̱' zri'ine Eliezer, Eliezer na' guque̱' zri'ine Jorim, Jorim na' guque̱' zri'ine xetú Matat, ");
INSERT INTO zatNTps_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat nigá guque̱' zri'ine xetú Leví, Leví nigá guque̱' zri'ine Simeón, Simeón na' guque̱' zri'ine xetú Judá, Judá nigá guque̱' zri'ine xetú José, José nigá guque̱' zri'ine Jonán, Jonán na' guque̱' zri'ine Eliaquim, ");
INSERT INTO zatNTps_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim na' guque̱' zri'ine Melea, Melea na' guque̱' zri'ine Mainán, Mainán na' guque̱' zri'ine Matata, Matata na' guque̱' zri'ine Natán. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán na' guque̱' zri'ine David, David na' guque̱' zri'ine Isaí, Isaí na' guque̱' zri'ine Obed, Obed na' guque̱' zri'ine Booz, Booz na' guque̱' zri'ine Salmón, Salmón na' guque̱' zri'ine Naasón. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón na' guque̱' zri'ine Aminadab, Aminadab na' guque̱' zri'ine Aram, Aram na' guque̱' zri'ine Esrom, Esrom na' guque̱' zri'ine Fares, Fares na' guque̱' zri'ine xetú Judá, ");
INSERT INTO zatNTps_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá nigá guque̱' zri'ine Jacob, Jacob na' guque̱' zri'ine Isaac, Isaac na' guque̱' zri'ine Abraham, Abraham na' guque̱' zri'ine Taré, Taré na' guque̱' zri'ine Nacor. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor na' guque̱' zri'ine Serug, Serug na' guque̱' zri'ine Ragau, Ragau na' guque̱' zri'ine Peleg, Peleg na' guque̱' zri'ine Heber, Heber na' guque̱' zri'ine Sala, ");
INSERT INTO zatNTps_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala na' guque̱' zri'ine Cainán, Cainán na' guque̱' zri'ine Arfaxad, Arfaxad na' guque̱' zri'ine Sem, Sem na' guque̱' zri'ine Noé, Noé na' guque̱' zri'ine Lamec, ");
INSERT INTO zatNTps_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec na' guque̱' zri'ine Matusalén, Matusalén na' guque̱' zri'ine Enoc, Enoc na' guque̱' zri'ine Jared, Jared na' guque̱' zri'ine Mahalaleel, Mahalaleel na' guque̱' zri'ine xetú Cainán. ");
INSERT INTO zatNTps_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán na' guque̱' zri'ine Enós, Enós na' guque̱' zri'ine Set, Set na' guque̱' zri'ine Adán, Adán na' guque̱' ca zrí'inequeze Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús, zúale̱ Be' Lá'azxa Le̱', bezé̱'e̱ xe̱gu Jordán, na' guché̱ Be' Lá'azxa Le̱' le̱'e̱ xixre' lawe' lataj. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Na' guzúe̱' chua zra, na' Satanás da xriwe̱' gudilaj lazre' na ájala si xe̱ na Le̱'. Quebe bi gudagu Jesús da chua zra ca', na' ca gudé na' gudune̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nadxa gunná da xriwe̱', guzre na Le̱': ―Che da li nacu' Lue' Zri'ine Dios, be̱n xelexaca xiaj caní xeta xtila. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Na' beche̱be Jesús: ―Naxúajqueze na lu xiche chee̱ Dios, dxenné̱': Quegá nen xeta xtílaze gaca ban bénneache, san cá'anqueze nen xrtizra' Dios gaca ban bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nadxa da xriwe̱' guché̱ na Jesús tu xi'a sibe, na' chadite̱ ble'e na Le̱' xúgute̱ cue' xe̱zr la xu da zaj nnita lu xe̱zr la xu nigá, ");
INSERT INTO zatNTps_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","na' guzre na Le̱': ―Neda' gunna' Lue' ca naca xel-la dxenná bea nigá, ne xel-la szren chee̱ xúgute̱ xe̱zr la xu caní, lawe' da zaj xu'u da caní lu na'a neda', na' gunézruja' na nu dxaca lazra' gunézruja' na. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Gunna' na chiu' che lue' guzú zribu' lawa', ne gucá'ana szrenu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesús beche̱be̱': ―Gucuasa lue', Satanás, lawe' da dxenná xiche chee̱ Dios, dxe̱'e̱ bénneache: “Bca'ana szren Xranu' Dios, ne be̱n zrin chee̱ tuze Le̱'.” ");
INSERT INTO zatNTps_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nadxa da xriwe̱' na' guché̱ na Jesús lu xe̱zre Jerusalén, na' bcuén na Le̱' xichaj ze'e xudau', na' guzre na Le̱': ―Che da li na' nacu' Zri'ine Dios, guxrite' nigá cheajxe̱zu' lu xu, ");
INSERT INTO zatNTps_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","lawe' da lu xiche chee̱ Dios dxenné̱': Dios gusebague̱' gubáz chee̱ xabáa chee̱' ca' xuluxue̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Xelechísaqueze̱' Lue' nen ne̱'e̱, chee̱ quebe gaca we̱' ni'u lawe' xiaj ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús beche̱be̱': ―Cá'anqueze naxúaj na lu xiche chee̱ Dios, dxe̱'e̱ bénneache: “Quebe guchínenu' ca dxaca lazru' Xranu' Dios.” ");
INSERT INTO zatNTps_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Gate da xriwe̱' québedxa bezrela lazre' na ájala gun zréaje na Jesús, na' becuasa na tu chi'i. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Na' Jesús bezrine̱' Galilea, ba nápale̱'e̱ xel-la waca chee̱ Be' Lá'azxa, na' ca naca xé̱zredu ca' zaj nababa na' buluchálaj bénneache ca naca xel-la waca chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesús bsé̱dene̱' benne' ca' tu tu lu xudau' ca', na' xúgute̱' belúe lá'ane̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nadxa Jesús bezrine̱' Nazaret, xe̱zre naga bgule̱'. Lu zra dxulupá'ana benne' judío ca' guxú'e̱ lu xu'u ga na' dxelezraga benne' judío ca', ca xu'u lawe̱' dxune̱', chee̱ gulabe̱' da naxúaj na lu xiche chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Buludée̱' Lu ne̱'e̱ xiche naga naxúaj dizra' bzuaj Isaías, benne' bchálaje̱' waláz chee̱ Dios, na' gate gusálaje̱' na, na' blabe̱' naga naxúaj da dxenná: ");
INSERT INTO zatNTps_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Be' Lá'azxa chee̱ Xránadxu zúale̱ne̱' neda', lawe' da guqué̱'e̱ neda' chee̱ guchálajle̱na' benne' baxache' ca' dizra' chawe' chee̱'. Gusel-le̱' neda' chee̱ xexuna' benne' ca' quebe chawe' zaj zue̱', ne chee̱ guzenda' benne' ba zaj nadxéaje̱' lu da zrinnaj, waca xelelé̱', ne chee̱ xexuna' lau benne' la chul-la ca', ne chee̱ guselá' benne' dxelezaca zi'e̱, ");
INSERT INTO zatNTps_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ne chee̱ guzenda' bénneache ba bzrin zra Xránadxu Dios gucá'ane̱' le̱' chawe'. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nadxa Jesús butube̱' xiche na', na' bdee̱' na lu na' benne' dxuxúe̱' xu'u na', na' bebé'e̱. Xúgute̱ benne' zaj zre̱'e̱ lu xu'u na' dxelenné̱'e̱ Le̱', ");
INSERT INTO zatNTps_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","na' Jesús guzú lawe̱' dxe̱'e̱ benne' ca': ―Na'a zra guca ca da naxúaj na laule le'e. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Xúgute̱' gulenné̱' chawe' chee̱ Jesús, ne belexebánene̱' ca naca dizra' chawe' da dxuchalaje̱'. Na' buluche̱be ljwezre̱': ―¿Quegá benne' nigá zri'ine José? ");
INSERT INTO zatNTps_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús guzre̱' le̱': ―Da líqueze le'e we̱le neda' dizra' nigá: Lue', benne' dxexúnu' benne' we̱' ca', bexún cuinu', ne xe̱le neda': Ca da bénentu' be̱nu' lu xe̱zre Capernaum, cá'anqueze be̱n na lázriu' nigá na'a. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nadxa gunná Jesús: ―Da li dxapa' le'e, tu benne' dxuchálaje̱' waláz chee̱ Dios, quebe nu dxue le̱' ba lá'ana lazrie̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Dxapa' le'e, gulezrá' nu'ula zan ba gulate benne' chee̱' lu xe̱zr la xu Israel ca lu zra guzúa Elías, benne' bchálaje̱' waláz chee̱ Dios, gate na' quebe guca xiuj chun iza xugachaj, ne gúcale̱'e̱ gubina' ca naca xe̱zr la xu na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Dios quebe gusel-le̱' Elías lau netú nu'ula, nate benne' chee̱', zue̱' xe̱zr la xu Israel. Gusel-le̱' le̱' lau tu nu'ula, nate benne' chee̱', zue̱' lu xe̱zre Sarepta, da zua na gagu naga dxe' xe̱zre Sidón. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Cá'anqueze gulezrá' benne' zan benne' dxeledxé'ene̱' we̱' guzru' lu xe̱zr la xu Israel ca lu zra guzúa Eliseo, benne' bchálaje̱' waláz chee̱ Dios, na' netúe̱' quebe bexaque̱'. Tuze Naamán, benne' xe̱zr la xu Siria bexaque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Gate belén benne' ca' zaj zre̱'e̱ xu'u na' da nigá, na' belezrá'ale̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Na' gulase̱', ne belexebéaje̱' Jesús xe̱zre na', na' beleché̱'e̱ Le̱' dxu'a chjéaj naga zria xe̱zre na', chee̱ xuludxixre̱' Le̱' na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Na' Jesús bedée̱' ládujla benne' ca', na' bezé̱'e̱ zexíaje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nadxa Jesús bexíaje̱' Capernaum, tu xe̱zre nababa Galilea, na' guzú lawe̱' dxusé̱dene̱' benne' ca' lu zra lá'azxa chee̱ judío ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Belexebánene̱' ca naca da dxusé̱dene̱', lawe' da dxuchálaje̱' ca tu benne' nape̱' xel-la dxenná bea. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Lu xu'u na' zua tu benne' xu'e̱ be' xriwe̱', na' dxebezre xe̱'e̱, ");
INSERT INTO zatNTps_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","dxenné̱': ―Bsan netu'. ¿Bizr chee̱ na' dxunu' netu' ze̱de, Jesús, benne' Nazaret? ¿Za'u guzría xi'u netu'? Neda' núnbe'a Lue', ne nezda' nacu' benne' lá'azxa chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús gudil-le̱' be' xriwe̱' na', dxenné̱': ―Zrize guzúa. Bsan benne' biu nigá. Nadxa be' xriwe̱' na' gudín na bénnea' xu lau xúgute̱ benne' ca', na' bedxúaj na lu xichaj lázrdau bénnea', ne quebe bi be̱n na chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Xúgute̱' belexebánene̱', na' gulé̱' ljwezre̱': ―¿Bizra dizra' da caní? Benne' nigá dxenná bé'ene̱' be' xriwe̱' ca' nen dute̱ xel-la dxenná bea chee̱', ne nen xel-la waca, na' be' xriwe̱' ca' dxeledxúaj na. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Na' buluchálaje̱' ca naca chee̱ Jesús xúgute̱ lu xe̱zre ca' zaj nababa na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nadxa bedxúaj Jesús lu xu'u na', na' guxú'e̱ lizre Simón. Xrna zru'ula Simón na' quebe chawe' zue̱', xú'ule̱'e̱ da la, na' gulata' xuene̱' Jesús xexune̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús gubigue̱'e̱ cuite̱', na' gudil-le̱' da la na', na' bedxúaj na. Ca ná'queze bexásate̱', na' guzú lawe̱' dxuseni'e̱ da xelawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ca dxebía gubizra, benne' ca' zaj nnita' benne' quebe chawe' zaj zue̱' lizre̱' belú'e̱ le̱' lau Jesús, na' Le̱' bze̱ ne̱'e̱ tu tu benne' ca', ne bexune̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Cá'anqueze zánete̱ be' xriwe̱' belexedxúaj na lu xichaj lázrdau benne' ca'. Dxelenná na: ―Lue' nacu' Zri'ine Dios. Jesús gudil-le̱' be' xriwe̱' ca'. Quebe be̱'e̱ na lataj xelenné̱ na, lawe' da zaj neze na naca Le̱' Cristo. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ca dxaní'sise̱', bdxuaj Jesús xe̱zre na', guxíaje̱' naga xeajsúe̱' tuze̱'. Na' benne' ca' belexexílaje̱' Le̱', na' belezrine̱' xuluzague̱' Le̱' chee̱ quebe xeze̱'e̱. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesús gunné̱': ―Dxun na ba xen guzenda' bénneache xezícadxa xe̱zrdu ca' ca dxenná bea Dios, lawe' da chee̱ guna' caní gusel-le̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ca'an guca gudá Jesús ca naca xe̱zre ca' zaj nababa Galilea, na' bchálaje̱' lu xu'u naga dxelezraga judío ca' lu xe̱zre ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Gate zua Jesús dxu'a nísadau' chee̱ Genesaret, na' belezrín benne' zan, ne buluchídete̱' Le̱', lawe' da dxelaca lazre̱' xelenne̱' xrtizra' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús blé'ene̱' chupa da dxedá lawe' nísadau' lu nísadau' na', zaj zra' gáguze lu xu bizre, lawe' da ba belexedxúaj benne' wezén bela ca' lu'ule da dxedá lawe' nísadau', na' zaj zre̱'e̱ dxelexibe̱' xixruj chee̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nadxa guxú'u Jesús tu lu da dxedá lawe' nísadau', da naca na chee̱ Simón, na' guzre̱' Simón guzrigue̱' na xelate' lu nísadau' na'. Jesús gudxé'e̱ lu da dxedá lawe' nísadau' na', na' guzú lawe̱' dxusé̱dene̱' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ca bexuzre bchálaje̱', na' guzre̱' Simón: ―Bsa da dxedá lawe' nísadau' chiu' naga nácadxa situj nísadau', na' le guzal-la xixruj chee̱le na' chee̱ senle bela. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón beche̱be̱': ―Benne' Wese̱de, bedú xe̱la be̱ntu' zrin, ne quebe bi bela ne sentu'. Lu dizra' chiu', na'a guzal-la' xixruj nigá. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ca belune̱' ca gunná Jesús, na' bela zante̱ gulezene̱', na' gúcate̱ wadxeza xixruj na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nadxa bulutá ne̱'e̱ gulenné̱' benne' ljwezre̱' zaj zre̱'e̱ xetú lu da dxedá lawe' nísadau' chee̱ xelácale̱ne̱' le̱'. Benne' ca' belezrine̱', na' bulusezrate̱' dxúpate̱ da dxedá lawe' nísadau' ca', na' gulácate̱ na zi'i, ne dxácate̱ welaze na lu nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Gate ble'e Simón Pedro da nigá, na' bzu zribe̱' lau Jesús, gunné̱': ―Gucuasa cuita' neda', Xran, lawe' da naca' neda' benne' dul-la. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Caní gunná Simón lawe' da dxezrébele̱'e̱ ne̱ chee̱ da guca na, ne cá'anqueze dxelezrebe benne' ljwezre̱' ca', gate belelé'ene̱' bela zan ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Cá'anqueze belezrebe Jacobo ne Juan, zri'ine Zebedeo, benne' zaj naque̱' ljwezre Simón na'. Jesús guzre̱' Simón: ―Quebe zrebu'. Ná'ate̱la su lau' senu' bénneache lu da naca chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nadxa, ca belexebéaje̱' da dxedá lawe' nísadau' na' dxú'ela nísadau', na' bulucá'ane̱' ca naca da ca', na' zjácale̱ne̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Gate Jesús zue̱' tu xe̱zre, na' bzrin tu benne' dxé'ene̱' we̱' guzru', na' ca blé'ene̱' Jesús, bzu zribe̱', ne gudíxrujte̱ lawe̱' lu xu, na' bca'ana szrene̱' Le̱', gunné̱': ―Xran, che dxaca lazru', waca xexunu' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nadxa Jesús bte̱'-be' nen ne̱'e̱, gunné̱': ―Dxaca lazra'. Bache bexacu'. Ca gunné̱' ca', we̱' guzru' na' bedxúajte̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesús bsebague̱' bénnea' quebe nu xe̱'e̱ da nigá. Nadxa gunné̱': ―Guxíaj na'a, xeajlé'e cuinu' lau bxruze, ne gulú'u dumí chee̱ xexádxeu' lau Dios ca da gunná be'e Moisés chee̱ xeleneze benne' ba bexacu' ca naca xízrawe̱' chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ca naca xel-la waca chee̱ Jesús bzrílujdxa na, na' benne' zante̱ belezrague̱' lau Jesús chee̱ xelenne̱' da dxuchálaje̱', ne chee̱ xexune̱' le̱' ca naca xízrawe̱' chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nadxa Jesús bezé̱'e̱ na', na' bzrine̱' naga quebe nu chilá' benne', na' bchálajle̱ne̱' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tu zra zua Jesús dxusé̱dene̱', na' bal-la benne' xudau' fariseo ca', ne benne' dxuluxuzájle̱'e̱ da nadxixruj be'e Moisés, zaj dxe'e̱ na', benne' zá'aque̱' ca naca xé̱zredu ca' zaj nababa Galilea, ne xe̱zre ca' zaj nababa Judea, ne chee̱ xe̱zre Jerusalén, na' zúale̱ xel-la waca chee̱ Xránadxu Dios Jesús, na' bexune̱' benne' ca' quebe chawe' zaj zue̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nadxa belezrín tapa benne' zaj nu'e̱ tu benne' zua zri ni'a ne̱'e̱, dee̱' tu lu blaga', na' gulaca lazre̱' xelegú'e̱ le̱' lu xu'u chee̱ xelíxrue̱' le̱' lau Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Quebe guca xelezrine̱' lau Jesús lawe' da zrále̱'e̱ benne' zan ga na'. Nadxa gulegüéne̱' chju'ula, ne gulesaluje̱' chju'u, na' bululétaje̱' benne' na' de̱' lu blaga' ládujla benne' zan ca' lau Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Gate ble'e Jesús ca dxeléajle̱ benne' ca' chee̱', na' guzre̱' benne' quebe chawe' zue̱': ―Bénne'dau', ba bnite lawa' dul-la chiu'. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nadxa benne' ca' dxuluxuzájle̱'e̱ da nadxixruj bea na, ne benne' xudau' fariseo ca' gulezú lawe̱' dxelenné̱' lu xichaj lázrdawe̱': ¿Nuzra benne' nigá, dxenné̱' schanni' chee̱ Dios? Quebe nu benne' séquene̱' gunite lawe̱' dul-la chee̱ bénneache. Tuze Dios gaque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús dxéquebe'ene̱' da dxelenné̱' lu xichaj lázrdawe̱', na' guzre̱' benne' ca': ―¿Bizr chee̱ na' dxéquele le'e caní? ");
INSERT INTO zatNTps_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Bízrala na quebe naca na ste̱be guna', che xapa' benne' nigá: Ba bnite lawa' dul-la chiu', u che xapa' le̱': Guxasa bexíaj? ");
INSERT INTO zatNTps_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Gulé'eda' le'e neda', Benne' Gulje̱' Bénneache, napa' xel-la dxenná bea lu xe̱zr la xu nigá chee̱ gunite lawa' dul-la chee̱ bénneache. Nadxa guzre̱' benne' na' naxrú'une ni'a ne̱'e̱: ―Lue' dxapa', bexasa, bexúa blaga' chiu', ne bexíaj. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ca gunné̱' ca', bexásate̱ benne' na' lau xúgute̱ benne' ca', na' bequé̱'e̱ blaga' chee̱', ne bezé̱'e̱ zexíaje̱' lizre̱' zeajxé̱ lá'ane̱' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Xúgute̱ benne' ca' belexebánene̱', na' belúe lá'ane̱' Dios, ne nen xel-la dxelezrebe gulenné̱': ―Na'a ble'edxu da dxebánequezdxu. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ca gudé na' bezá'a Jesús, na' blé'ene̱' tu benne' dxuchizruje̱' waláz chee̱ xe̱zre Roma, le̱' Leví. Dxe'e̱ naga dxuchízruje̱', na' guzre̱' le̱': ―Be̱n neda' tuze. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Na' guxasa Leví, bca'ane̱' ca naca chee̱' ca', na' guxíajle̱ne̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ca gudé na', Leví gulu'e̱ tu xrche' zrente̱ lizre̱' chee̱ bca'ana szrene̱' Jesús, na' zrále̱'e̱queze na' xezícadxa wechizruj ca', ne xezícadxa benne' zaj dxe'e̱ dxágule̱ne̱' benne' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Na' benne' xudau' fariseo ca', ne benne' ca' dxuluxuzájle̱'e̱ da nadxixruj bea na gulezú lawe̱' dxelezí tizre̱' benne' ca' dxuse̱de Jesús, dxelé̱'e̱ le̱': ―¿Bizr chee̱ na' dxe'aj dxágule̱le benne' wechizruj caní, ne benne' dul-la ca'? ");
INSERT INTO zatNTps_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús beche̱be̱': ―Quebe zaj nachine benne' zaj zua chawe' nu benne' dxexúne̱' le̱'. Benne' quebe chawe' zaj zue̱' dxelechínene̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Neda' quegá za'a dxennéa' benne' xrlátaje. Za'a dxennéa' benne' dul-la, chee̱ xelexebí'i lazre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nadxa buluche̱be̱' Jesús: ―¿Bizr chee̱ na' dxelúnle̱'e̱ gubasa, ne dxuluchálajle̱ Dios benne' ca' zjácale̱ne̱' Juan, ne benne' ca' zjácale̱ne̱' benne' xudau' fariseo ca', san benne' ca' dxusé̱denu' tu dxelé'aj dxeláguzqueze̱'? ");
INSERT INTO zatNTps_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús beche̱be̱': ―¿Wazéquele xe̱le benne' zaj zra' laní chee̱ wechaga na' xelune̱' gubasa dxácate̱ na' zua benne' wechaga na' nen benne' ca'? ");
INSERT INTO zatNTps_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wazrín zra gate wechaga na' na' xecuase̱' nen benne' ca'. Ca lu zra na' xelune̱' gubasa. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nadxa bchálajle̱ne̱' le̱' ca naca da dxulé'e nigá: ―Quegá nu benne' cheze̱' tu zre̱' cube chee̱ xudé̱'e̱ na tu zre̱' gula. Che ca' gune̱', na' guzría xi'e̱ ca naca zre̱' cube na', na' ládxe'du cube na' quebe gulé'e na cháwedau' nen ladxe' gula na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Cá'anqueze quebe gaca cá'adxu xrise uva cube lu bzude xide gula, lawe' da che ca' gundxu, xrise uva cube na' gutín na bzude xide gula, na' gaca ditje xrise uva na', ne bzude xide na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Chee̱ le̱ na' dxal-la' cá'adxu xrise uva cube lu bzude xide cube, na' dxúpate̱ na' xegá'ana chawe' na. ");
INSERT INTO zatNTps_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Che tu benne' xí'aje̱' xrise uva wal-la gula, québedxa nna na chee̱' xí'aje̱' xrise uva cube, lawe' da dxenné̱': “Nétajdxa da gula na'.” ");
INSERT INTO zatNTps_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tu lu zra lá'azxa chee̱ judío ca', gudé Jesús naga naxaza zrua' xtila, na' benne' ca' dxusé̱dene̱' zjaque̱' dxelálaje̱' dau zrua' xtila, na' dxelezrube na nen ne̱'e̱, ne dxelawe̱' zrua' xtila na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nadxa benne' xudau' fariseo ca' buluche̱be̱' le̱': ―¿Bizr chee̱ na' dxunle le'e tu zrin da quebe naca na gunle zra lá'azxa chee̱dxu? ");
INSERT INTO zatNTps_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús beche̱be̱': ―¿Quebe ne gulábale le'e ca be̱n David ne benne' ljwezre̱' ca' gate guledune̱'? ");
INSERT INTO zatNTps_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Guxú'u David na' tu lu xudau' chee̱ Dios, ne guqué̱'e̱ xeta xtila da gulú'u bxruze lau Dios, na' gudawe̱' na, ne bnézrujte̱' chee̱ benne' ca' zjácale̱ne̱' le̱', ne quebe naca chee̱' xelawe̱' xeta xtila na'. Tuze bxruze ca' naca chee̱' xelawe̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Cá'anqueze guzre Jesús benne' ca': ―Neda', Benne' Gulje̱' Bénneache, nápaqueza' xel-la dxenná bea ca naca chee̱ zra lá'azxa. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Xetú lu zra lá'azxa chee̱ judío ca', guxú'u Jesús tu lu xu'u, na' guzú lawe̱' dxusé̱dene̱' benne' zaj nazrague̱' na'. Zua na' tu benne' nazrinnaj ne̱'e̱ xabe̱la. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Benne' ca' dxuluxuzájle̱'e̱ da nadxixruj bea na, ne benne' xudau' fariseo ca' dxuluzuzre̱' Jesús chee̱ xelelé'ene̱' che xexún Jesús bénnea' lu zra lá'azxa chee̱', chee̱ xelezéquene̱' xelawe' zria Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesús ba nézene̱' ca da dxelegú'u lazre̱', na' guzre̱' bénnea' nazrinnaj ne̱'e̱: ―Guxasa, ne guzé̱ laduj nigá. Benne' na' guxase̱', na' guzé̱' na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nadxa gunná Jesús, guzre̱' benne' ca': ―Na'a guche̱ba' le'e tu: ¿Bízrala na' waca gundxu zra lá'azxa chee̱le, da xrlátaje che da cale̱la? ¿Gucache cháwedxu xel-la nabán chee̱ tu benne', che guzría xidxu na? ");
INSERT INTO zatNTps_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nadxa Jesús guné̱'e̱ benne' ca' zaj naxechaj Le̱', na' guzre̱' benne' we̱' na': ―Bli na'u nigá. Benne' na' be̱ne̱' ca', na' bexácate̱ ne̱'e̱ na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Na' benne' ca' zaj zre̱'e̱ na' belezrá'ale̱'e̱, na' gulezú lawe̱' dxuluche̱be ljwezre̱' bi xelezéquene̱' xelune̱' chee̱ Jesús chee̱ xuluzría xi'e̱ Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ca lu zra na' Jesús guxíaje̱' tu lu xi'a xeajchálajle̱ne̱' Dios, na' guzúe̱' bedú xe̱la dxuchálajle̱ne̱' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ca guxaní' gunné̱' benne' ca' dxusé̱dene̱', ne guqué̱'e̱ chazrinnu benne' ca', na' bzre̱'e̱ benne' ca' xelaque̱' gubáz chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Benne' caní zaj naque̱': Simón, (bénnea' bzue̱' le̱' Pedro), Andrés, (benne' biche Simón na'), Jacobo, Juan, Felipe, Bartolomé, ");
INSERT INTO zatNTps_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Jacobo, (zri'ine Alfeo), Simón, (bénnea' dxedábague̱' benne' Roma ca') ");
INSERT INTO zatNTps_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, (benne' biche Jacobo), ne Judas Iscariote, (bénnea' gudée̱' Jesús lu na' benne' ca' dxeledábague̱' Le̱'.) ");
INSERT INTO zatNTps_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús bdinne̱' lu xi'a na' nen benne' ca' dxusé̱dene̱', na' bzrine̱' tu lache' nen benne' ca'. Benne' zan zaj zre̱'e̱ na' zaj nababe̱' xe̱zre ca' zaj nababa Judea, ne Jerusalén, nen benne' zaj nababe̱' Tiro, ne Sidón. Benne' caní belelé̱'e̱ chee̱ xelenne̱' da dxuchalaj Jesús, ne chee̱ xexún Jesús le̱' ca naca xízrawe̱' dxeledxé'ene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Cá'anqueze benne' ca' zaj xu'e̱ be' xriwe̱' belexaque̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Xúgute̱ benne' ca' gulaca lazre̱' xuluté̱' Jesús lawe' da dxexún Le̱' xúgute̱' nen xel-la waca chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nadxa Jesús gunné̱'e̱ benne' ca' dxusé̱dene̱', na' guzre̱' le̱': ―Ba neza zrente̱ naca na chee̱le le'e, dxéquebe'ele nácale benne' xache', lawe' da waxú'ule le'e naga dxenná bea Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Ba neza zrente̱ naca na chee̱le le'e, dxedunle da dxunna Dios, lawe' da wélajquezle. ’Ba neza zrente̱ naca na chee̱le le'e, dxebézrele ne̱ chee̱ dula, lawe' da guzrízrequezle. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Ba neza zrente̱ naca na chee̱le le'e, gate xelecuide bénneache le'e, ne gate xelexebéaje̱' le'e chalé'ajla, ne gate xelenné̱' schanni' chee̱le, ne gate xulucá'ana ditje̱' lale ca tu da sban lawe' da nácale bi chia' neda', Benne' Gulje̱' Bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Le béle̱'e̱, ne le sua lu da ba neza lu zra na' lawe' da zrué'ele tu da zren lu xabáa chee̱ Dios. Cá'anqueze benne' xra xrtau benne' caní bulusaca zi'e̱ benne' ca' buluchálajé̱' waláz chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Baxache' nácale le'e, benne' gunní'a, lawe' da ba nápale xel-la dxebé da naca chee̱ xe̱zr la xu nigá. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Baxache' nácale le'e, nélajle na'a, lawe' da wadunle le'e. ’Baxache' nácale le'e dxuzrízrele na'a, lawe' da cuezre xáchele. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Baxache' nácale le'e gate xúgute̱ bénneache dxelenné̱' da chawe' chee̱le, lawe' da ca' belún xra xrtáule, gulenné̱' da chawe' chee̱ benne' we̱n lazre' ca', benne' gulenné̱': “Netu' dxuchálajntu' waláz chee̱ Dios.” ");
INSERT INTO zatNTps_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Na' gunná Jesús: ―Dxapa' le'e dxénele chia', le zri'i benne' ca' dxelecuídene̱' le'e, ne le gun chawe' chee̱ benne' ca' dxelezré̱'e̱ le'e. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Le nne̱ chawe' chee̱ benne' ca' dxelenné̱' cale̱la chee̱le, ne le naba lau Dios gaca chawe' chee̱ benne' ca' dxelenné̱' schanni' chee̱le. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Che nu benne' cape̱' xrágale, le guze̱te̱ xecha la'a, ne che nu benne' que̱'e̱ xicha chee̱le, le güe lataj ca'ate̱' zrale. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Le gunezruj nútete̱ze benne' bi nabe̱' le'e, ne che nu benne' que̱'e̱ da naca chee̱le, quebe xenábale na. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Le gun chee̱ bénneache cáte̱ze na' dxaca lázrele xelune̱' chee̱le. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Che le'e nazri'ile tuze benne' ca' zaj nazrí'ine̱' le'e, ¿bízraqueze da chawe' dxunle? Cá'anqueze dxelún benne' ca' dxelune̱' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Che dxunle chawe' chee̱ tuze benne' ca' dxelune̱' le'e chawe', ¿bízraqueze da chawe' dxunle? Cá'anqueze dxelún benne' we̱n da zrinnaj ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Che bi dxusanle chee̱ tuze benne' ba nézele wexunne̱' na, ¿bízraqueze da chawe' dxunle? Cá'anqueze benne' we̱n da cale̱la ca' dxulusane̱' da naca chee̱' chee̱ benne' ca' dxelune̱' da cale̱la, lawe' da zaj nézene̱' wulunézrujte̱ benne' ca' le̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Dxal-la' zri'ile le'e benne' ca' dxelezré̱'e̱ le'e, ne gunle da chawe' chee̱', ne gusanle chee̱ benne' ca' da xelenabe̱' le'e, lácala quebe xelexexunne̱' na. Che gunle ca', da zrendxa da si' lu na'le, ne gácale bi ca' chee̱ Dios szrente̱, lawe' da naca Le̱' zri'i lazre' nen benne' ca' quebe dxelexezaca ba lazre̱', ne benne' we̱n da cale̱la ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Le xezrí lazre' bénneache ca dxun Dios, dxezrí lazre̱' le'e. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Na' gunná Jesús: ―Quebe guzúale chalá'ala le sa' ljwézrele, na' Dios quebe guzúe̱' le'e chalá'ala. Quebe bi nne̱le chee̱ le sa' ljwézrele, na' Dios quebe guchi'e̱ chee̱le le'e. Le gunite lau chee̱ le sa' ljwézrele, na' Dios gunite lawe̱' chee̱le le'e. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Le gunezruj chee̱ bénneache, na' Dios gunne̱' chee̱le le'e. Dios cu'e̱ lu xcuite chee̱le tu xi'ina da nálate̱, ne da naxí'tequeze, ne guníbete̱' na, ne sua dí'atequeze na. Dios gudxíxrequeze̱' chee̱le ca da dxudxíxrele chee̱ bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nadxa Jesús bchálaje̱' da dxulé'e nigá, gunné̱': ―¿Waca tu benne' la chul-la cu'e̱ neza xetú la chul-la? Che ca' gune̱', dxúpate̱' xelebixre̱' tu lu xe̱dxu. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Netú benne' dxuse̱de gácadxe̱' szren ca naca bénnea' dxusé̱dene̱' le̱', na' gate xuzre gusé̱die̱', gaque̱' ca naca bénnea' bsé̱dene̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Bizr chee̱ na' dxenná'u bé̱bedu na' xu'u na xiaj lau le sa' ljwezru', ne quebe dxéquebe'enu' ca naca da zren da xu'u na xiaj lau' lue'? ");
INSERT INTO zatNTps_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Che quebe dxéquebe'enu' ca naca da zren na' da xu'u na xiaj lau' lue', ¿ájazra dxunu' dxexázrenu' dxu'u le sa' ljwezru': “Be̱nna lataj xebéaja' bé̱bedu na' xu'u na xiaj lau'?” Lue', benne' dxun láweze xrlátaje, bebéaj zá'teca lue' ca naca da zren da xu'u na xiaj lau', na' nadxa le'enu' cháwedau' xebéaju' bé̱bedu na' xu'u na xiaj lau le sa' ljwezru'. Nadxa gunná Jesús: ");
INSERT INTO zatNTps_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","―Tu xaga xrlátaje quebe cuía na da zixre cale̱la, na' xaga da quebe naca chawe' quebe gaca cuía na da zixre chawe'. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tu tu xaga naca bea na ne̱ chee̱ da zixre da dxebía na. Quebe gaca guchíbedxu da zixre chee̱ xaga higo tu lu xaga xeche', ne quebe guchíbedxu da zixre chee̱ lba uva lu xeche' bisigá. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Benne' xrlátaje, da xrlátaje dxenné̱ bénnea' lawe' da naxaza da xrlátaje lu xichaj lázrdawe̱', na' benne' we̱n da cale̱la, da cale̱la dxenné̱ bénnea' lawe' da xu'u da cale̱la lu xichaj lázrdawe̱'. Dxu'e̱ na' dxenné̱ na ca naca da xu'u lu xichaj lázrdawe̱'. Gunná Jesús: ");
INSERT INTO zatNTps_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","―¿Bizr chee̱ na' dxe̱le neda': “Xran, Xran”, ne quebe dxunle ca da dxapa' le'e? ");
INSERT INTO zatNTps_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Xapa' le'e aja naca bénnea' ze̱'e̱ nen neda', ne dxenne̱' xrtizra'a, ne dxune̱' ca da dxapa' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Naque̱' ca tu benne' be̱ne̱' tu xu'u. Da zren gude̱ne̱', na' bzrie̱' lane na lawe' xiaj xre. Gate bdxuaj xe̱gu, na' xeajchú'ule̱'e̱ na le̱'e̱ xu'u na', quebe bi guzeque' gune na xu'u na' lawe' da zria lane na lawe' xiaj xre. ");
INSERT INTO zatNTps_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Na' bénnea' dxenne̱' xrtizra'a, ne quebe dxune̱' ca da dxapa' le̱', naque̱' ca tu benne' be̱ne̱' xu'u chee̱' lawe' xu dxeze, ne quebe guzale̱' lane na, na' gate bdxuaj xe̱gu na', ne xeajchú'ule̱'e̱ na le̱'e̱ xu'u na', na' guché̱ na le̱ na, na' tu chí'izqueze bzria xi na le̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Gate bexuzre bchálajle̱ Jesús benne' ca', na' bezé̱'e̱ zexíaje̱' Capernaum. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Zua tu benne' Roma na', benne' dxenná be'e̱ lu wedil-la, na' zua tu bi we̱n zrin chee̱' nazrí'ile̱'e̱ne̱'-be', na' bi na' quebe chawe' zúabe', ne dxaca wátebe'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Gate ben benne' Roma na' ca da dxun Jesús, na' gusél-le̱' bal-la benne' gula sina chee̱ judío ca', chee̱ xeajlegue̱zre̱' Jesús xide̱' xexune̱' bi we̱n zrin chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Benne' gula ca' belezrine̱' lau Jesús, na' gulezú lawe̱' dxelata' xuene̱' Le̱', dxelenné̱': ―Benne' Roma nigá naca chee̱' gácale̱nu' le̱', ");
INSERT INTO zatNTps_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","lawe' da dxape̱' ba lá'ana xe̱zre chee̱dxu, na' lé̱queze̱' be̱ne̱' tu xu'u chee̱dxu ga dxezrágadxu. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nadxa Jesús guxíajle̱ne̱' benne' gula ca'. Gate belezrine̱' gagu naga zua lizre benne' Roma na', le̱' gusél-le̱' bal-la benne' ljwezre̱' xeajlegue̱zre̱' Jesús: ―Xran, quebe senu' gunne xue, lawe' da quebe naca chia' chu'u lizra'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Chee̱ le̱ na' ne quebe bexazrda' néda'queza' xedajdilja' Lue'. Cun gunnaze, na' xexaca bi we̱n zrin chia'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Néda'queza' zua benne' dxenná bé'ene̱' neda', na' neda' dxenná be'eda' benne' dxjaca wedil-la. Che xapa' tu bénnea': Guxíaj, na' waxíajbe', ne che xapa' xetube': Gudá, na' wídabe', ne che nna be'eda' bi we̱n zrin chia' da gunbe', na' gunbe' na. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Gate ben Jesús da nigá, na' bebánene̱', na' gunné̱'e̱ benne' ca' zjácale̱ Le̱', gunné̱': ―Da li, quebe ne cheajxraca' tu benne' xe̱zre Israel dxeajlí lazre̱' neda' ca dxun benne' nigá. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Gate belexezrín benne' ljwezre benne' Roma na' lizre̱', na' belelé'ene̱' ba bexaca bi we̱n zrin na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ca gudé na' Jesús guzé̱'e̱ zéaje̱' tu xe̱zre da nazí le na Naín, na' xjácale̱ Le̱' benne' ca' dxusé̱dene̱', ne benne' zante̱. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Gate bzrine̱' gáguze naga zua xe̱zre na', blé'ene̱' benne' zaj nu'e̱ tu bi gate zeajlecache̱'-be', na' naca be̱' bi tulicha' chee̱ xrnabe', nu'ula na' ba gute benne' chie̱'. Benne' zan, benne' lazrie̱' zjácale̱ne̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Gate Xránadxu blé'ene̱' nu'ula na', na' bexache lazre̱' le̱', ne guzre̱' le̱': ―Québedxa cuezru'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nadxa gubiga Jesús dxu'a xi'ina xu'ube', na' bte̱' na. Na' benne' ca' zeajlexexu'e̱-be' gulague̱'. Na' Jesús guzre̱' bi gate na': ―Bidau', dxapa' lue', guxasa. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Na' bi na' ba nate bexásabe' gudxe'be', na' bezú laube' dxuchálajbe'. Na' Jesús bunézruje̱'-be' lu na' xrnabe'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Gate belelé'e benne' ca' da nigá, na' belezrebe̱', ne gulezú lawe̱' dxelúe lá'ane̱' Dios, dxelenné̱': ―Tu benne' zrente̱, benne' dxenné̱' waláz chee̱ Dios, ba ble̱'e̱ ládujla dxi'u. Cá'anqueze dxelenné̱': ―Dios ba ble̱'e̱ dxácale̱ne̱' xe̱zr chee̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ca naca naga nababa Judea, ne xe̱zre walízr chee̱ na belén bénneache ca naca xel-la waca chee̱ Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Naga xu'u Juan lizre xia, bénene̱' ca naca chee̱ da nigá lawe' da benne' ca' zjácale̱ne̱' Juan buluzenne̱' le̱' da dxaca na. Juan gunné̱' chupa benne' ca', ");
INSERT INTO zatNTps_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","na' gusel-le̱' le̱' lau Jesús chee̱ cheajleche̱be̱' Le̱' che da li naque̱' Cristo, bénnea' dxal-la' xide̱', u che dxal-la' xelebeze̱' benne' xula. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nadxa benne' ca' gusel-la Juan belezrine̱' lau Jesús, na' gulé̱'e̱ Le̱': ―Juan, bénnea' bchue̱' bénneache nisa nasel-le̱' netu' zedajché̱bentu' Lue' che Lue' na' nacu' Cristo, bénnea' dxal-la' xide̱', u che dxal-la' cuézantu' benne' xula. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ca lu zra na' Jesús bexune̱' benne' zante̱ benne' we̱', ne benne' dxé'ene̱' xízrawe̱' da dxedá du zren, ne benne' ca' zaj xu'e̱ be' xriwe̱', na' bexune̱' benne' la chul-la ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nadxa Jesús guzre̱' benne' ca' nasel-la Juan: ―Le cheajxaca, ne le xe̱ Juan ca naca da ba ble'ele, ne da bénele. Benne' la chul-la ca' dxelexelé'ene̱', na' benne' zrinnaj ca' dxelexedé̱', na' benne' dxeledxé'ene̱' we̱' guzru' ba belexaque̱', na' benne' xache' ca' dxelenne̱' dizra' chawe' chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ba neza zren naca na chee̱ benne' quebe gusán lazre̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Gate besí'aca benne' ca' gusel-la Juan, na' Jesús guzú lawe̱' dxuchálajle̱ne̱' benne' zaj zre̱'e̱ na' ca naca chee̱ Juan na', dxenné̱': ―¿Bizra guxiajle le'e xeajnna'le le̱'e̱ xixre' lawe' lataj? ¿Tu xia xtila da dxutá be'? ");
INSERT INTO zatNTps_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Che cabí, ¿bizra xeajnna'le? ¿Tu benne' nacu zra lane̱' da zácale̱'e̱? Ba nézquezle le'e benne' ca' dxelacu zra lane̱' da zácale̱'e̱, ne dxelé'aj dxelawe̱' da zácale̱'e̱ zaj zre̱'e̱ lizre benne' blau ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Che cabí, ¿bizra xeajnna'le? ¿Tu benne' dxuchálaje̱' waláz chee̱ Dios? Awe', ble'ele tu benne' nácadxe̱' szren ca tu benne' dxuchálajé̱' waláz chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan nigá naque̱' bénnea' naxúaj na chee̱' lu xiche chee̱ Dios, dxenné̱': Dxesel-la' gubáz chia' lau Lue', chee̱ gucá'ana chawe̱' neza naga teu'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Dxapa' le'e, ládujla xúgute̱ benne' quebe nu chilá' benne' dxuchálaje̱' waláz chee̱ Dios nácadxe̱' szren ca Juan nigá. Na'a benne' nácadxe̱' dxexruj lazre' naga dxenná bea Dios nácadxe̱' blau ca Juan nigá. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Na' gunná Jesús: ―Gate na' benne' dxexruj lazre' ca', ne benne' wechizruj ca' belenne̱' da dxuchalaj Juan, guleque bé'ene̱' Dios naque̱' xrlátaje, na' beledxúe̱' nisa lu na' Juan. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Benne' xudau' fariseo ca', ne benne' ca' dxuluxuzájle̱'e̱ da nadxixruj bea na buluzúe̱' chalá'ala ca naca da dxaca lazre' Dios gune̱' chee̱', na' quebe beledxúe̱' nisa lu na' Juan. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Na' gunná Xránadxu: ―¿Ájazra gutil-la lé̱beda' benne' zaj zre̱'e̱ na'a zra? ¿ájazra zaj naque̱'? ");
INSERT INTO zatNTps_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Zaj naque̱' ca bidu ca' dxelebe'be' dxelítajbe' lawe' xi'a, ne dxelebezre xa'abe', dxele̱be' bidu ljwézrebe': “Bcuézrentu' bchiuj da bénele, san quebe bxá'ale. Bil-la xáchentu', san quebe gudxézrele.” ");
INSERT INTO zatNTps_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Caní zaj naca benne' ca' lawe' da bla' Juan, bénnea' bchue̱' bénneache nisa, ne quebe gudawe̱' xeta, ne quebe gu'e̱ xrise uva wal-la, na' gulenné̱' xu'e̱ be' xriwe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nadxa bla'a neda', Benne' Gulje̱' Bénneache, dxe'aj dxawa', na' dxelenné̱' naca' wagu xrata, ne benne' dxé'ajle̱'e̱, ne dxelenné̱' naca' ljwezre benne' dul-la ca', ne benne' wechizruj ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Xel-la sina chee̱ Dios naca bea na ne̱ chee̱ da dxelún benne' ca' zaj nape̱' xel-la sina chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tu benne' xudau' fariseo gunné̱' Jesús cheajtawe̱' xeta lizre̱', na' Jesús guxíaje̱' lizre bénnea', na' gudxé'e̱ dxawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nadxa tu nu'ula dul-la chee̱ xe̱zre na', gate benne̱' bzrin Jesús dxawe̱' xeta lizre benne' fariseo na', na' bzrin nu'ula na' ga na', nu'e̱ tu da' naca na xiaj zaca, da nazráte̱ na da dxelá zixre. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Gate bzrin nu'ula na' naga zua Jesús, na' gudxé'e̱ zran ni'e̱ dxebezre̱', ne guzú lawe̱' dxibe̱' ni'a Jesús nen nisa dxebezre̱', ne bsebizre̱' ni'e̱ nen xicha xíchaje̱', ne bnupe̱' ni'a Jesús, na' gulu'e̱ na da dxelá zixre na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Na' benne' xudau' fariseo, bénnea' gunné̱' Jesús lizre̱', gate blé'ene̱' da nigá, gunné̱' lu lázrdawe̱': “Chela benne' nigá da li naque̱' benne' dxuchálaje̱' waláz chee̱ Dios, guéquebe'equeze̱' aja naca chee̱ nu'ula nigá dxuté̱' ni'e̱, lawe' da naque̱' nu'ula dul-la.” ");
INSERT INTO zatNTps_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nadxa Jesús guzre̱' benne' fariseo na': ―Simón, de̱ tu da guchálajle̱na' lue'. Na' beche̱be benne' fariseo na': ―Gunná, Benne' Wese̱de. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús gunné̱': ―Chupa benne' dxelal-le̱' dumí chee̱ tu benne' tu dxusánte̱zqueze̱' benne' dumí. Tue̱' dxal-le̱' chee̱' lazruj chee̱ chupiza, na' xetúe̱' dxebague̱' lazruj chee̱ chupa beu'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Lawe' da quebe dxelezéquene̱' xelexexízruje̱' chee̱ bénnea', na' le̱' bnite lawe̱' chee̱ dxúpate̱ benne' ca' ca naca da dxelebague̱' chee̱'. Na'a gunná, ¿nula benne' caní zrí'idxene̱' bénnea'? ");
INSERT INTO zatNTps_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón beche̱be̱': ―Dxéqueda' bénnea' bnite lawe̱' chee̱' da zrendxa. Na' Jesús guzre̱' le̱': ―Da li dxennáu'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nadxa Jesús gunné̱'e̱ nu'ula na', na' guzre̱' Simón: ―¿Dxelé'enu' nu'ula nigá? Neda' guxu'a lizru', ne quebe nu gunná be'enu' quibe ni'a, san nu'ula nigá gudibe̱' ni'a nen nisa dxebezre̱', ne bsebizre̱' na nen xicha xíchaje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Quebe bnupu' neda', san nu'ula nigá, gate guxú'utea', quebe dxusane̱' dxunúpequeze̱' ni'a. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Quebe gulú'u da za xíchaja', san nu'ula nigá gulu'e̱ ni'a da dxelále̱'e̱ zixre. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Chee̱ le̱ na' dxapa' lue', lawe' da nazrí'ile̱'e̱ne̱' neda', da nigá naca bea na ba bnite lawa' chee̱' ca naca dul-la zan chee̱', san bénnea' naca bábaze dul-la chee̱' da bnite lawa', láteze zrí'ine̱' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nadxa Jesús guzre̱' nu'ula': ―Dul-la chiu' ba bnite lawa'. ");
INSERT INTO zatNTps_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Na' benne' ca' zaj zre̱'e nen Le̱', ne zaj dxe'e̱ na' gulezú lawe̱' dxelenné̱' lu lázrdawe̱': “¿Nuzra benne' nigá, dxunite láuqueze̱' dul-la?” ");
INSERT INTO zatNTps_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesús guzre̱' nu'ula na': ―Ba naláu' lawe' da guxéajle̱'u chia'. Bexíaj dute̱ xel-la dxebeza zri lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ca gudé da nigá, gudá Jesús zane' xe̱zre, ne xé̱zredu ca', dxusé̱dene̱', ne dxuchálaje̱' ca dxenná bea Dios. Benne' chazrinnu gubáz ca' zjácale̱ne̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Cá'anqueze zjácale̱ Le̱' bal-la nu'ula ca', benne' ca' bexune̱' le̱' ca naca xízrawe̱' chee̱', ne bebéaje̱' be' xriwe̱' ca' da zaj xu'e̱. Ládujla nu'ula ca' ziaj María Magdalena, nu'ula na' belexedxúaj gazre be' xriwe̱' lu xichaj lázrdawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ládujla le̱' zíajqueze Juana, zru'ula Chuza, benne' na' xu'u lu ne̱'e̱ da napa Herodes. Cá'anqueze ládujla le̱' ziaj Susana, na' zjaca nu'ula zandxa na', nu'ula ca' dxelácale̱ne̱' Jesús nen da zaj nape̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Benne' zan beledxúaje̱' lu xe̱zre ca' chee̱ xelelé'ene̱' Jesús, na' gate belezraga benne' zan naga zue̱', na' bchálaje̱' tu da dxulé'e na, dxe̱'e̱ le̱': ");
INSERT INTO zatNTps_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Tu benne' dxaze̱' guzé̱'e̱ zjaze̱' zrua' xtila. Ca zéaje̱' dxaze̱' na, bal-la bínnedu ca' xeajlechaze na dxu'a neza, na' benne' ca' bululéaje̱' na, na' belezrín bxínnedau' guláguba' na. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Xebal-la bínnedu ca' xeajlechaze na lu xiaj ca', na' gate bínnedu caní belezría na, chadite̱ gulebizre na, lawe' da quebe gudxé' gupa'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Xebal-la bínnedu ca' xeajlechaze na naga zaj dxe' lue xeche', na' bululule xeche' ca' le̱ na. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Xebal-la bínnedu ca' xeajlechaze na lu xu be̱be, na' gate belegula na, na' gulezríale̱'e̱ na. Bal-la na gulezría na tu gaxúa weaj. Gate bexuzre bchalaj Jesús da nigá, na' gunné̱' zizraj: ―¡Che le'e zua nágale, le xene! ");
INSERT INTO zatNTps_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nadxa benne' ca' dxuse̱de Jesús gulenábene̱' Le̱' bizra zéaje̱ da dxulé'e nigá. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús guzre̱' le̱': ―Dios dxuzéajni'ine̱' le'e ca naca da nagache chee̱ xel-la dxenná bea chee̱', san benne' xula, dxuchálajle̱na' le̱' da dxulé'e na caní, chee̱ gate dxelelé'ene̱' xelaque̱' ca benne' quebe dxelelé'ene̱', ne gate dxelenne̱' quebe dxeléajni'ine̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Na' gunná Jesús: ―Da nigá naca ca zéaje̱ da dxulé'e na': Bínnedu ca' zéaje̱ na xrtizra' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Bínnedu ca' xeajlechaze na dxu'a neza zéaje̱ na benne' ca' dxelenne̱' xrtizra' Dios, san za' da xriwe̱', na' dxegúa na dizra' na' lu xichaj lázrdau benne' ca', chee̱ quebe xeléajle̱'e̱, ne quebe xelelé̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bínnedu ca' xeajlechaze na lu xiaj ca' zéaje̱ na benne' ca' dxelenne̱' dizra' na', ne dxelezi'e̱ na dute̱ xel-la dxelebé, san quebe dxaze na lu xichaj lázrdawe̱'. Dxeléajle̱'e̱ tu chí'idau'ze, na' gate dxeledée̱' lu da zi' da xa', na' dxulusán lazre̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Bínnedu ca' xeajlechaze na naga zaj dxe' lue xeche' zéaje̱ na benne' ca' dxelenne̱' dizra' na', na' dxeajxaque̱', na' lawe' da dxeleze̱ne̱' gunne xue da zante̱, ne dxelezé̱ lazre̱' xel-la gunní'a, ne da xele'aj xelawe̱' da zácale̱'e̱, na' xúgute̱ da caní dxulusunite na dizra' na', na' quebe dxun na zrin lu xichaj lázrdawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na' bínnedu ca' xeajlechaze na lu xu be̱be zéaje̱ na benne' ca' zua chawe', ne du lazre' lázrdawe̱', na' gate dxelenne̱' dizra' na', dxuluzúa chache̱' na, na' dxun zrin dizra' na' lu xichaj lázrdawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Gunná Jesús: ―Netú benne' che gugale̱' da dxegú'u lení', quebe gudúsie̱' na tu xi'ina, u zranle ga dxasie̱', san guzúe̱' na sibe, chee̱ cu'u lení' na chee̱ benne' zaj zre̱'e̱ lu xu'u na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Quebe bi de̱ da nagache' da quebe gulé'e lau na, ne quebe bi xu'u lu xichaj lázrdau bénneache da quebe gaca bea na, ne lá'te̱queze na. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Chee̱ le̱ na', le xene xanne'. Tu benne' nazi'e̱ xrtizra' Dios, wazidxe̱', san benne' quebe dxezi'e̱ na, wegá'a ca da du dxéquene̱' nape̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nadxa xrna Jesús, ne benne' biche̱' ca' belezrine̱' naga zue̱', san quebe gulezéquene̱' xelezrine̱' lau Le', lawe' da zrále̱'e benne' zan ga na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tu benne' na' bzenne̱' Jesús, gunné̱': ―Xrna'u, ne bi bichu' ca' zaj zre̱'e̱ chale'aj nigá, dxelaca lazre̱' xuluchálajle̱ne̱' Lue'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesús guzre̱' le̱': ―Benne' ca' dxelenne̱' xrtizra' Dios, ne dxelune̱' ca dxenná na, benne' caní zaj naque̱' ca xrna'a, ne benne' bícha'dau' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tu zra guxú'u Jesús tu lu da dxedá lawe' nísadau' nen benne' ca' dxusé̱dene̱', na' guzre̱' le̱': ―Cheajdxu xecha la'a nísadau'. Na' gusiá'que̱', ");
INSERT INTO zatNTps_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ne dxácate̱ zjaque̱' lu nísadau' na', guse Jesús. Na' guzú lau dxácale̱'e̱ be' bdunu' lu nísadau', na' guzú lau dxu'u nisa lu da dxedá lawe' nísadau' na', ne ba dxácate̱ waxaze na lu nísadau'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nadxa bulusebane̱' Jesús, dxelé̱'e̱ Le̱': ―¡Benne' Wese̱de! ¡Benne' Wese̱de! ¡Ba dxázedxu lu nisa nigá! Nadxa guxasa Jesús, na' gudil-le̱' be' bdunu' na', ne nisa na', na' ca naca da ca' belezúa zri na. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nadxa Jesús guzre̱' benne' ca' dxusé̱dene̱': ―¿Quebe ne chéajle̱le chee̱ Dios? Benne' ca' belezrebe̱', ne belexebánene̱', na' buluche̱be ljwezre̱': ―¿Núzraqueze benne' nigá, dxenná bé'ene̱' be', ne nisa, na' dxuluzúa na dizra' chee̱'? ");
INSERT INTO zatNTps_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nadxa belezrine̱' xecha la'a nisa lu xe̱zr la xu chee̱ xe̱zre Gadara, chalá'a ca'ala chee̱ Galilea. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Gate bedxúaj Jesús lu da dxedá lawe' nísadau' na', na' bzrin tu benne' xe̱zre na' lau Le̱'. Zánete̱ iza ba guca xu'u be' xriwe̱' ca' benne' nigá. Quebe gúcue̱' zra lane̱', ne quebe guzúe̱' netú lu xu'u, san xeajchu'e̱ tu lu ba ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Gate blé'ene̱' Jesús, na' xeajzú zribe̱' lau Le̱', na' gudxezre xe̱'e̱, dxenné̱': ―¿Bizr chee̱ na' za'u naga zua', Jesús, Zri'ine Dios szrente̱? Dxata' xueda' Lue' quebe gusaca zi'u neda'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Gunná na caní lawe' da ba gunná be'e Jesús be' xriwe̱' ca' xelexedxúaj na lu xichaj lázrdau benne' nigá. Zane' lasa be' xriwe̱' ca' ba gule̱la na benne' nigá. Benne' xe̱zre na' gule̱le̱' benne' nigá, ne buluchéaje̱' le̱' ni'a ne̱'e̱ nen du xia, san le̱' bzúzxuje̱' du xia na', na' be' xriwe̱' ca' guleché̱ na le̱' le̱'e̱ xixre' lawe' lataj. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús bche̱be̱' be' xriwe̱' ca': ―¿Bi le̱le? Na' beche̱be le̱ na: ―Neda' lea': Da Zan. Ca' gunná na lawe' da xu'u be' xriwe̱' zante̱ benne' na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Be' xriwe̱' ca' gulenaba na Jesús quebe sel-le̱' na lataj chul-la. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Lu xi'a naga zua Jesús, na' zrále̱'e̱ cuche zan dxeláguba', na' be' xriwe̱' ca' gulata' xue na Jesús gu'e̱ lataj da ca' cheajxezrá na lu cuche ca', na' bnezruj Jesús na lataj. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nadxa be' xriwe̱' ca' belexedxúaj na lu xichaj lázrdau benne' na', na' gulú'u na lu cuche ca', na' xúgute̱ cuche ca' buluzrúnnujba', ne gulebíxreba' dxu'a chjéa, na' xeajlecházeba' lu nísadau', naga gulé̱peba', guláteba'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Benne' ca' dxuluxúe̱' cuche ca', gate belelé'ene̱' ca da guca, na' buluzrúnnuje̱' lu xel-la dxelezrebe, na' gulé̱'e̱ benne' zaj zre̱'e̱ le̱'e̱ xixre', ne benne' zaj zre̱'e̱ lawe' xe̱zre ca da guca. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nadxa benne' ca' beledxúaje̱' xeajlenné̱'e̱ ca da guca. Gate belezrine̱' naga zua Jesús, na' belelé'ene̱' bénnea' belexedxúaj be' xriwe̱' ca' lu xichaj lázrdawe̱', dxe'e̱ zran ni'a Jesús, ba nácue̱' ladxe', ne ba bezúa chawe' xichaj lázrdawe̱', na' benne' ca' belezrebe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Na' benne' belelé'e ca da guca buluchálajle̱ne̱' benne' xula ca' ca guca gate bexaca bénnea' guxú'e̱ be' xriwe̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gate belenne̱' caní, ca naca benne' zaj zre̱'e̱ lu xe̱zr la xu chee̱ xe̱zre Gadara gulezú lawe̱' dxelata' xúene̱' Jesús xezé̱'e̱ lazrie', lawe' da dxelezrébele̱'e̱. Ca'an guca, guxú'u Jesús lu da dxedá lawe' nísadau', chee̱ xezé̱'e̱ xéaje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Bénnea' belexedxúaj be' xriwe̱' ca' lu xichaj lázrdawe̱' gunabe̱' lau Jesús gunézruje̱' lataj chéajle̱ne̱' Le̱', san Jesús busebague̱' le̱' xegá'ane̱' lázrie̱', na' guzre̱' le̱': ");
INSERT INTO zatNTps_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Bexiaj lizru', na' bchalaj chee̱ xúgute̱ ca da ba be̱n Dios chiu'. Na' benne' na' bezé̱'e̱ zexíaje̱', na' bchálajle̱ne̱' benne' xe̱zre ca' ca da be̱n Jesús chee̱ le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Gate bezrín Jesús xecha la'a dxu'a nísadau', benne' ca' zaj zre̱'e̱ na' gulezí' lu ne̱'e̱ Le̱' nen dute̱ xel-la dxelebé, lawe' da xúgute̱' dxelebeze̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nadxa bzrin tu benne' le̱' Jairo, benne' blau chee̱ xu'u naga dxelezraga judío ca', na' bzu zribe̱' lau Jesús, ne guta' xúene̱' Le̱' chéaje̱' lizre̱', ");
INSERT INTO zatNTps_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","lawe' da zua tuze bi nu'ula chee̱'. Xu'ube' chazrinnu iza, na' ba dxaca wátebe'. Gate guzá' Jesús zéaje̱', benne' zante̱ zjácale̱ne̱' Le̱', ne buluchídete̱ ljwezre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ládujla benne' ca' zeaj tu nu'ula quebe chawe' zue̱', na' chazrinnu iza ba zeaj dxé'ene̱' we̱' dxen da dxaca chee̱ nu'ula ca'. Ba gudízruje̱' benne' dxelexún bénneache ca' xúgute̱ ca da gudape̱', na' quebe bi gulezéquene̱' xelune̱' chee̱ xexaca nu'ula na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nu'ula na' gubigue̱' cúzrula Jesús, na' xeajté̱' zran ni'a zre̱', na' la ná'queze bexágate̱ dxen da dxaca nu'ula na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nadxa Jesús bche̱be̱': ―¿Nuzra bta neda'? Xúgute̱' gulenné̱': “Quebe nu ne gutá Lue'”, na' Pedro, ne benne' ljwezre̱' ca' gulenné̱': ―Benne' Wese̱de, benne' caní dxuluchídee̱' Lue', ne dxuluzrigue̱' Lue', na' dxuché̱bequezu', dxennáu': “¿Nuzra bta neda'?” ");
INSERT INTO zatNTps_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesús gunné̱': ―Tu benne' bte̱' neda' lawe' da gúquebe'eda' ben zrin xel-la waca chia' da bexún na tu benne'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Gate gúquebe'e nu'ula na' ba neze Jesús da guca, nadxa gudée̱' dxezrízete̱', na' bzu zribe̱' lau Jesús, ne guxrúale̱pe̱' lau xúgute̱ benne' ca' bizr chee̱ na' bte̱' Jesús, ne ca guca bexácate̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nadxa gunná Jesús, guzre̱' nu'ula na': ―Zrí'ina'dau', ba bexacu' lawe' da guxéajle̱'u chia'. Bexíaj na'a, dute̱ xel-la dxebeza zri lazre'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ne dxuchálajte̱ Jesús, bzrin tu benne' naga ze̱ Jesús, benne' guzé̱'e̱ lizre Jairo, benne' blau chee̱ xu'u ga na' dxelezraga judío ca', na' guzre̱' Jairo: ―Ba gute bi nu'ula chiu'. Québedxa guzúa xuzru' Benne' Wese̱de nigá. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Gate ben Jesús ca gunné̱', na' guzre̱' Jairo: ―Quebe zrebu'. Con guxeajle̱. Bi nu'ula chiu' na' xexácabe'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Gate bzrin Jesús xu'u na', netú quebe be̱' lataj chú'ule̱ Le̱', san tuze Pedro, ne Jacobo, ne Juan, ne xra xrna bi nu'ula na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Xúgute̱ benne' zaj zre̱'e̱ na' dxelebezre̱', ne dxelebezre xache̱' chee̱ bi nu'ula na'. Jesús gunné̱': ―Quebe cuézrele. Bi nú'uladu nigá quebe nátebe'. Dxásezebe' na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Na' benne' ca' buluzrizre̱' chee̱', lawe' da zaj nézquezne̱' ba gútebe'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nadxa Jesús guqué̱'e̱ na' bi na', na' gunné̱' zizraj: ―¡Bi nu'ula, bexasa! ");
INSERT INTO zatNTps_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Na' bebanbe', ne bexásate̱be'. Na' Jesús busebague̱' le̱' xulunézruje̱' da gágube'. ");
INSERT INTO zatNTps_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Xra xrnabe' belexebánele̱'e̱ne̱'. Jesús busebague̱' le̱' quebe nu xelé̱'e̱ ca da guca. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús bchague̱' benne' chazrinnu ca' dxusé̱dene̱', na' bnézruje̱' le̱' xel-la waca, ne xel-la dxenná bea chee̱ xelexebéaje̱' xúgute̱ cue' be' xriwe̱' ca' da zaj xu'u bénneache, ne chee̱ xelexexune̱' benne' ca' zaj xu'e̱ xízrawe̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Na' gusel-le̱' le̱' chee̱ xuluzenne̱' bénneache ca dxenná bea Dios, ne chee̱ xelexexune̱' benne' zaj xu'e̱ xízrawe̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Na' guzre̱' le̱': ―Quebe bi gúale chee̱ la neza. Quebe gúale xaga da guchíchele, na' xixruj chee̱le, ne da gágule, ne dumí. Le gua' tu cue'ze zra lánale. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Gátete̱ze xu'u naga chú'ule, le xegá'ana na' cadxa zrin zra xeza'ale lu xe̱zre na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Naga quebe xelezí'e̱ dizra' guchálajle̱le le̱', le xedxúaj xe̱zre na', ne le cuibe bxrte xu da da' ní'ale, da gulé'e na zaj nabague̱' zria lau Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nadxa beledxúaje̱', na' ca naca xé̱zredu ca' xeajlechálaje̱' dizra' chawe' chee̱ Dios, ne belexexune̱' benne' zaj xu'e̱ xízrawe̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodes, benne' dxenná be'ene̱' xe̱zr la xu na', benne̱' ca naca xúgute̱ da dxun Jesús, na' guzúe̱' ste̱be lawe' da dxelenná bal-la benne' ba bebán Juan ládujla benne' gate. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Xebal-le̱' dxelenné̱' Elías, bénnea' bchálaje̱' waláz chee̱ Dios ba bele̱'e̱, na' xebal-le̱' dxelenné̱' ba bebán tu benne' ca' buluchálaje̱' waláz chee̱ Dios ca ni'te̱. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes gunné̱': ―Néda'queza' gunná be'eda' nu gudxugu xichaj Juan. ¿Nuzra benne' nigá xca' da zante̱ dxenda' dxune̱'? Nadxa Herodes be̱ne̱' ba xuzre lé'ene̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Gate belexezrín benne' gubáz ca' chee̱ Jesús lau Le̱', na' gulé̱'e̱ Le̱' ca da ba belune̱'. Na' Jesús beche̱'e̱ benne' ca', na' besiá'que̱' zeajxaque̱' tu lataj da nagá'ana zitu' naga zaj dxe' xe̱zre ca', naga zua lu xe̱zr la xu chee̱ xe̱zre Betsaida. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Gate benne' xe̱zre na' belenne̱' zua Jesús na', na' gusiá'que̱' zjaque̱' naga zua Le̱'. Na' Jesús guzí' lu ne̱'e̱ benne' ca', ne bchálajle̱ne̱' le̱' ca dxenná bea Dios, ne bexune̱' benne' zaj xu'e̱ xízrawe̱' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Gate guzú lau zeaj dxezré', na' gulebiga benne' chazrinnu gubáz ca' chee̱ Jesús lau Le̱', na' gulé̱'e̱ Le̱': ―Bze̱ benne' caní dizra' chee̱ chjaque̱' naga xelasie̱', ne xelílaje̱' da xelawe̱' xé̱zredu ca' zaj nnita gagu, lawe' da ga zúadxu nigá quebe bi de̱. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús guzre̱' le̱': ―Le gunezruj le'e da xelawe̱'. Nadxa benne' ca' bele̱'e̱ Jesús: ―Quebe de̱dxa chee̱ntu' ca gázxuga xeta xtíladau', ne chúpaga bela, u ¿wacheajxríquezentu' da xelagu catite benne' zan caní? ");
INSERT INTO zatNTps_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Zaj zra ca chi xun gaxúa benne' biu ca' ga na'. Nadxa Jesús guzre̱' benne' ca' dxusé̱dene̱': ―Le xe̱ benne' ca' xelebé'e̱ chi xun weaje̱' tu cue' tu cue'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ca'an belune̱', na' gulebe'e̱ xúgute̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nadxa Jesús guqué̱'e̱ da gazxu' xeta xtila ca', ne chupa bela ca'. Na' guchisa lawe̱' xabaala, ne guzre̱' Dios “Xcalenu'”, na' ca bexuzre bzúzruje̱' na, na' bnézruje̱' na benne' ca' dxusé̱dene̱' chee̱ xelisie̱' na chee̱ benne' zan ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Xúgute̱' gulawe̱', ne belélaje̱'. Ca gudé na' bulusuzré̱'e̱ chazrinnu ga' da bízrujdu ca' belexegá'ana na. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tu zra gate zua Jesús dxuchálajle̱ne̱' Dios naga quebe zaj zra benne' zan ca', na' zrale̱ benne' ca' dxusé̱dene̱' Le̱', na' Le̱' bche̱be̱' benne' ca': ―¿Nuzra dxelenná benne' naca' neda'? ");
INSERT INTO zatNTps_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Le̱' belexeche̱be̱': ―Bal-le̱' dxelenné̱' nacu' Juan, bénnea' bchue̱' bénneache nisa, na' xebal-le̱' dxelenné̱' nacu' Elías, bénnea' bchálaje̱' waláz chee̱ Dios, na' xebal-le̱' dxelenné̱' nacu' tu benne' ca' buluchálaje̱' waláz chee̱ Dios ca ni'ite̱, na' bebane̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nadxa Jesús bche̱be̱': ―Na' le'e, ¿nuzra dxennale naca'? Na' gunná Pedro: ―Nacu' Cristo chee̱ Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesús bsebague̱' benne' ca' quebe nu xelé̱'e̱ ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Na' guzre̱' le̱': ―Neda', Benne' Gulje̱' Bénneache, dxal-la' téle̱'a xel-la zi', na' benne' gula sina ca', ne benne' xíchaje̱ ca' chee̱ bxruze, ne benne' ca' dxuluxuzájle̱'e̱ da nadxixruj bea na xuluzúe̱' neda' chalá'ala. Xelútie̱' neda', san gate gaca chunna zra, na' xebana'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ca gudé na' guzre̱' ca naca benne' zaj zre̱'e̱ na': ―Che nu benne' dxaca lazre̱' gaque̱' neda' tuze, dxal-la' guzúe̱' chalá'ala xúgute̱ da naca chee̱', na' gune̱' neda' tuze xúgute̱ zra, lácala gate benne' na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Benne' dxaca lazre̱' gapa chi'e̱ xel-la nabán chee̱', gunítie̱' na, san benne' gunítie̱' xel-la nabán chee̱' lawe' da naque̱' chia', wazrué'ene̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Bizra da ba neza gaca na chee̱ tu benne' che gape̱' ca naca da de̱ lu xe̱zr la xu nigá, san cuía xi' lé̱queze̱'? ");
INSERT INTO zatNTps_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Che nu benne' xedué'ene̱' chia' neda', ne chee̱ dizra' chia', cá'anqueze neda', Benne' Gulje̱' Bénneache, wedué'eda' chee̱ bénnea' gate za'a neda' chee̱ nna be'a nen xel-la szren chee̱ Xra', ne chee̱ gubáz lá'azxa chee̱ xabáa ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Da li dxapa' le'e, bál-lale zrale nigá quebe gátele nédxudxa ca lé'ele zra nna bea Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ca guzre xi' gudé gunná Jesús da nigá, na' guluéne̱' tu lu xi'a chee̱ guchálajle̱ne̱' Dios, na' xjácale̱ Pedro, ne Jacobo, ne Juan Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Dxácate̱ dxuchálajle̱ne̱' Dios, na' bcha lu'a lesaca Jesús, na' zra lane̱' bexaca na da chiche, ne guca tite na. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nadxa bululé'e lau chupa benne' dxuluchálajle̱ne̱' Jesús. Zaj naque̱' Moisés ne Elías. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Naga ze̱le̱ Jesús benne' ca' gúcatite' legala, na' dxuluchálajle̱ne̱' Jesús ca gaca gate gatie̱' Le̱' xe̱zre Jerusalén. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Gulácale̱'e̱ welase Pedro ne benne' ljwezre̱' ca', san bulusebán lazre̱', na' belelé'ene̱' ca naca xel-la szren chee̱ Jesús, ne chupa benne' ca' zaj zé̱le̱ne̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Gate benne' ca' belexesiá'que̱' naga ze̱ Jesús, na' Pedro gunné̱': ―Benne' Wese̱de, néquega zúadxu nigá. Be̱nna netu' lataj guntu' chunna xu'u lága'dau', tu chiu', ne tu chee̱ Moisés, ne tu chee̱ Elías. Pedro quebe dxéquebe'ene̱' ca da dxenné̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Dxácate̱ dxenná Pedro caní, na' bla' tu beuj da gucu na naga zaj zre̱'e̱, na' belezrebe Pedro, ne benne' ljwezre̱' ca' gate gulezré̱'e̱ lu beuj na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Na' belenne̱' chi'i nu dxuchalaj lu beuj na', gunná: ―Bi nigá naque̱' Zri'ina', nazrí'ite̱ lazra'. Le xen da dxuchálajbe'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ca gudé belenne̱' chi'i na', na' belelé'ene̱' Jesús ba ze̱' tuze̱'. Na' benne' caní gulezúe̱' zrize, na' quebe nu gulé̱'e̱ ca da belelé'ene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Gute xu, gate belexexétaje̱' lu xi'a na', na' benne' zan zjaque̱' zeajlexrígale̱' Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nadxa tu benne' ca' gunné̱' zizraj, guzre̱' Jesús: ―Benne' Wese̱de, dxata' xueda' Lue' dajxú' bi biu chia' lawe' da tu lícha'te̱ bi chia' naca, ");
INSERT INTO zatNTps_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","na' tu be' xriwe̱' dxaze na le̱be', ne dxucuezre xa'a na le̱be', ne dxudxixre dxutula na le̱be', na' dxebía bzrina' dxú'abe'. Dxusaca zi na le̱be', ne quebe dxaca lazre' na gusán na le̱be'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ba guta' xueda' benne' ca' dxusé̱denu' chee̱ xelexebéaje̱' na, san quebe gulezéquene̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús beche̱be̱': ―Le'e, benne' we̱n chupa lazre', ne we̱n da cale̱la. ¿Ájate̱ dxal-la' súale̱na' le'e? ¿Ájate̱ dxal-la' guchaga lawa' nen le'e? Xeajxrí' zri'inu' na' nigá. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Gate bi cuide' na' ba zéajbe' gagu, na' be' xriwe̱' na' gudín na le̱be' xu, ne bdxixre btula na le̱be'. Na' Jesús gudil-le̱' be' xriwe̱' na', ne bexune̱' bi cuide' na', na' bdee̱'-be' lu na' xrabe'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Xúgute̱ benne' ca' belexebánene̱' ca naca xel-la szren chee̱ Dios. Dxácate̱ na' xúgute̱ benne' ca' dxelexebánene̱' ca da dxun Jesús, Le̱' guzre̱' benne' ca' dxusé̱dene̱': ");
INSERT INTO zatNTps_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Le xen xanne' da nigá, ne quebe gal-la lázrele na. Neda', Benne' Gulje̱' Bénneache, wuludée̱' neda' lu na' bénneache. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Benne' ca' dxusé̱dene̱' quebe guléajni'ine̱' ca da dxenná Jesús lawe' da quebe ne gunézruj Dios lataj xeléajni'ine̱', na' belezrebe̱' xelenabe̱' Jesús guzéajni'ine̱' le̱' ca da na' gunné̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nadxa benne' ca' dxuse̱de Jesús gulezú lawe̱' dxuluche̱be ljwezre̱' núzraqueze naca blau ládujla le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús gúquebe'ene̱' ca da dxelenné̱'. Nadxa guqué̱'e̱ tu bi biúdau', ne bze̱'-be' cuite̱', ");
INSERT INTO zatNTps_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","na' guzre̱' benne' ca': ―Benne' gape̱' ba lá'ana tu bidu caní lawe' da nazrí'ine̱' neda', néda'queza' dxape̱' ba lá'ana, na' benne' dxape̱' ba lá'ana neda', dxápaqueze̱' ba lá'ana Dios, Bénnea' nasel-le̱' neda'. Cá'anqueze bénnea' nácadxe̱' benne' dxexruj lazre' ládujla le'e, benne' nigá naque̱' benne' blau. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nadxa Juan guzre̱' Jesús: ―Benne' Wese̱de, blé'entu' tu benne' dxuchínene̱' Lau', dxebéaje̱' be' xriwe̱' ca' lu xichaj lázrdau benne' ca', na' gúzrentu' le̱' quebe gune̱' ca' lawe' da quebe naque' dxi'u tuze. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús guzre̱' le̱': ―Quebe guzágale ca da dxune̱' lawe' da benne' quebe dxedábague̱' dxi'u zue̱' gácale̱ne̱' dxi'u. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Gate ba za zrin zra dxal-la' xexíaj Jesús xabáa, be̱n zi' lazre̱' chéaje̱' Jerusalén. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Na' gusél-le̱' gubáz chee̱' ca' xelebía lawe̱', na' benne' ca' xjaque̱' tu xé̱zredau' nababa Samaria chee̱ cheajlecuéze̱' naga sua Jesús. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Benne' Samaria ca' quebe gulaca lazre̱' xegá'ana Jesús na', lawe' da guleque bé'ene̱' zéaje̱' Jerusalén. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Gate Jacobo ne Juan, benne' ca' dxuse̱de Jesús, belelé'ene̱' da nigá, na' gulé̱'e̱ Jesús: ―Xran, ¿dxaca lazru' nna béantu' xetaj xi' da za xabáa chee̱ guzría xi na benne' caní, ca be̱n Elías, bénnea' bchálaje̱' waláz chee̱ Dios? ");
INSERT INTO zatNTps_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nadxa Jesús guné̱'e̱ le̱', ne gudil-le̱' le̱', dxenné̱': ―Le'e quebe nézele nu be' zúale̱ le'e. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Caní naca lawe' da bla' neda', Benne' Gulje̱' Bénneache, quegá chee̱ guzría xi'a xel-la nabán chee̱ bénneache, san chee̱ gucache chawa' le̱ na. Nadxa xjaque̱' xetú xé̱zredau'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ca zjaque̱' lu neza na', tu benne' biu guzre̱' Jesús: ―Xran, dxaca lazra' sále̱na' Lue' gátete̱ze chéaju'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús beche̱be̱': ―Beza ca' zaj zua bluaj chee̱ba', na' bxínnedu ca' zaj zria xrú'uneba', san neda', Benne' Gulje̱' Bénneache, quebe bi de̱ ga xrua xíchaja'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Na' Jesús guzre̱' xetú benne': ―Be̱n neda' tuze. Benne' nigá gunné̱': ―Xran, be̱nna neda' lataj cheajcáchea' xra'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Na' Jesús beche̱be̱': ―Be̱ lataj benne' ca' zaj naque̱' ca benne' gate xulucache' ljwezre̱', na' lue', guxíaj, xeajchalaj ca dxenná bea Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nadxa tu benne' xula guzre̱' Jesús: ―Xran, dxaca lazra' guna' Lue' tuze, san steca, be̱nna neda' lataj xexá'a cheajzéa' dizra' benne' zaj zra' lizra'. ");
INSERT INTO zatNTps_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús guzre̱' benne' na': ―Benne' dxugá'ane̱' be̱zre, na' nne̱'e̱ cúzrule̱', quebe gaca chee̱ bénnea' gune̱' zrin chee̱ da dxenná bea Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ca gudé na', Xránadxu guqué̱'e̱ xegaxún chi benne' ca', na' gusél-le̱' chupa weaje̱' xelebía lawe̱' lau Le̱' xúgute̱ xe̱zre, ne xé̱zredu ca' naga dxal-la' chéaje̱' Le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Guzre̱' benne' ca': ―Da li dxennéa', lina da zren naca na, na' benne' we̱n zrin bábaze zaj naque̱'. Chee̱ le̱ na' le naba lau Xrane zrin na' sel-le̱' benne' we̱n zrin ca' xelexequé̱'e̱ lina na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","¡Le chjaca! Le nna'xque, neda' dxesel-la' le'e, gácale ca zríla'du ca' ládujla becu' xi'a ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Quebe gúale xixruj, ne dumí, ne zrélale, ne quebe gagale la neza nu guchálajle̱le. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Gate chu'ule tu lu xu'u, na' gugápale diuzre, nnale: “Xel-la dxebeza zri lazre' gaca chee̱ benne' zaj zre̱'e̱ lu xu'u nigá.” ");
INSERT INTO zatNTps_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Che zaj zra' na' benne' dxelebeza zri lazre̱', na' da gunábale gaca chee̱ benne' ca', san che quebe nu chilá' naca caní, le naba quebe gaca da ba gunábale. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Le xegá'ana lu xu'u ná'queze, na' le xi'aj le gagu ca da xelunne̱' lawe' da benne' we̱n zrin quebe te le tune̱'. Quebe cheajsúale tu xu'u xetú xu'u. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Gate zrinle tu xe̱zre naga xelezí' lu ne̱'e̱ le'e, le gagu ca da xelunne̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Le xexún benne' zaj xu'e̱ xízrawe̱' zaj zre̱'e̱ na', na' le xe̱'e̱: “Xel-la dxenná bea chee̱ Dios ba zua nen le'e.” ");
INSERT INTO zatNTps_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Che zrinle tu xe̱zre naga quebe xelezí' lu ne̱'e̱ le'e, le xedxúaj la neza chee̱ xe̱zre na', na' nnale: ");
INSERT INTO zatNTps_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ca naca bxrtedu' da' ní'antu' dxexebíbentu' na chee̱ gaca tu da gulé'e na le'e nabágale zria lau Dios. Dxal-la' nézele ba bla' ládujla le'e xel-la dxenná bea chee̱ Dios.” ");
INSERT INTO zatNTps_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Dxapa' le'e, ca lu zra guchi'a Dios, da xelezaca benne' zaj zre̱'e̱ lu xe̱zre nigá gácadxa na xel-la zi' ca da xelezaca benne' xe̱zre Sodoma, xe̱zre na' bzria xi' Dios. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Na' gunná Jesús: ―¡Edxugúa le'e, benne' xe̱zre Corazín! ¡Edxugúa le'e, benne' xe̱zre Betsaida! Chela lu xe̱zre Tiro, ne lu xe̱zre Sidón belelé'ene̱' ca naca xel-la waca chee̱ xabáa da ba gulaca ládujla le'e, gate na'te ba belexebí'i lazre̱', belácue̱' zra lane̱' tuzruj, ne buluzríe̱' de xíchaje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Lu zra guchi'a Dios da dxaca, na' sácadxale le'e xel-la zi' ca da xelezaca benne' Tiro, ne Sidón. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na' le'e, benne' xe̱zre Capernaum, ¿dxéquele waxásale zrínte̱le xabáa? ¡Lataj chúl-lala xétajle! ");
INSERT INTO zatNTps_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nadxa guzre̱' benne' ca' dxusé̱dene̱': ―Benne' xenne̱' chee̱le le'e, chia' neda' xenne̱', na' benne' guzúe̱' le'e chalá'ala, neda' na' gusaque̱' ca', na' benne' guzúe̱' neda' chalá'ala, Dios, Bénnea' gusel-le̱' neda', guzúe̱' chalá'ala. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Benne' gaxún chi ca' belexezrine̱' lu xel-la dxelebé, dxelenné̱': ―Xran, be' xriwe̱' ca' dxuluzúaqueze na dizra' chee̱ntu' gate dxuchínentu' Lau'. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús guzre̱' benne' ca': ―Ca' naca, na' neda' ble'eda' da xriwe̱' be̱xruj na zran xabáa ca tu xesa da dxeajsúa na lu xu. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Neda' ba be̱nna' le'e xel-la dxenná bea chee̱ guléajle be̱ snia ca', ne bé̱xrujni, ne chee̱ guchúchujle dute̱ xel-la dxenná bea chee̱ da xriwe̱', na' quebe bi seque gune na le'e. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Quebe bele lawe' da dxelún be' xriwe̱' ca dxennale le'e, san le be lawe' da ba naxúaj lale xabáa na'la. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lu zra ná'queze gubéle̱'e̱ Jesús, zúale̱ Be' Lá'azxa Le̱', na' gunné̱': ―Dxue lá'ana' Lue', Xrae, Xrane xabáa ne xe̱zr la xu, lawe' da ba blé'enu' bénne'du caní da bcácheu' chee̱ benne' sina ca', ne benne' dxeléajni'ine̱'. ¡Ca' naca, Xrae, lawe' da ca'an guca lazru' Lue'! ");
INSERT INTO zatNTps_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Xra' ba be̱nne̱' neda' xúgute̱. Quegá nu neze nu na' naca Zrí'ine̱', san tuze Xrá'queza', ne quegá nu neze nu na' naca Xra', san tuze Zrí'inequeze̱', ne nu benne' ca' dxaca lazre' Zrí'ine̱' guzéajni'ine̱' le̱' Nu na' naca Xre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nadxa guné̱'e̱ benne' ca' dxusé̱dene̱', na' guzre̱' benne' cá'anze: ―Ba neza naca na chee̱ benne' ca' dxelelé'ene̱' ca da dxelé'ele le'e, ");
INSERT INTO zatNTps_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","lawe' da dxapa' le'e, zánete̱ benne' ca', benne' buluchálaje̱' waláz chee̱ Dios, ne benne' wenná bea ca' gulaca lazre̱' xelelé'ene̱' ca da dxelé'ele le'e, san quebe belelé'ene̱' na. Gulaca lazre̱' xelenne̱' ca da dxenle le'e, san quebe belenne̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nadxa tu benne' dxuxuzájle̱'e̱ da nadxixruj bea Dios bdxúaje̱', ne guxíaje̱' xeajchálajle̱ne̱' Jesús chee̱ gaca guzúa zrie̱' Le̱', na' bche̱be̱' Le̱': ―Benne' Wese̱de, ¿bizra dxal-la' guna' chee̱ gata' chia' xel-la nabán da zeajlí canna? ");
INSERT INTO zatNTps_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús beche̱be̱': ―¿Bizra da naxúaj na lu da nadxixruj bea Dios? ¿Aja dxéquenu' da dxulabu'? ");
INSERT INTO zatNTps_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Bénnea' dxuxuzájle̱'e̱ da nadxixruj bea Dios beche̱be̱': ―Bzri'i Xranu' Dios dute̱ lázrda'u, ne nen dute̱ bénne'du xu'u, ne nen dute̱ xel-la dxun zi' lazre' chiu', ne nen dute̱ xel-la dxulaba lazre' chiu', na' bzri'i le sa' ljwezru' ca nazrí'i cuinu'. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nadxa gunná Jesús, guzre̱' le̱': ―Cháwe'le̱'e̱ beche̱bu'. Che dxunu' caní, na' gapu' xel-la nabán na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Bénnea' dxuxuzájle̱'e̱ da nadxixruj bea Dios guca lazre̱' gucá'ana chawe' cuine̱', na' guzre̱' Jesús: ―¿Nuzra na' le sa' lwezra'? ");
INSERT INTO zatNTps_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Beche̱be Jesús: ―Tu benne' guzé̱'e̱ Jerusalén, bétaje̱' zíaje̱' Jericó. Lu neza na' xu'e̱, na' gule̱la gubán le̱', ne gulebane̱' ca naca da nape̱', ne zra lane̱'. Na' buluzálaje̱' le̱', ne besiá'que̱' zaj nucá'ane̱' le̱' ca benne' gate. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nadxa gudé tu bxruze neza na', na' gate blé'ene̱' le̱', gudée̱' chalá'ala. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Cá'anqueze gudé na' tu benne' xrtia Leví, benne' dxune̱' zrin chee̱ xudau', na' gate blé'ene̱' bénnea', gudée̱' chalá'ala. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nadxa tu benne' Samaria gudée̱' neza na', na' gate blé'ene̱' le̱' bexache lazre̱' le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Gubigue̱' cuita benne' na', ne btupe̱' tu da za lu we̱' chee̱', ne xrise uva wal-la, na' bchele̱' na ladxe'. Nadxa bcuene̱' le̱' cuzru bea chee̱', na' beche̱'e̱ le̱' tu lu xu'u naga xegá'ane̱', ne bxue̱' le̱' na'. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Zra xula, ca bezá' benne' Samaria na', na' guléaje̱' chupa dumí da bnézruje̱' xrane xu'u na', ne guzre̱' le̱': “Bxue benne' nigá, na' che ba gucá'adxa xelate' dumí chiu', neda' xexunna' na gate xelá'a.” ");
INSERT INTO zatNTps_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nadxa Jesús guzre̱' benne' dxuxuzájle̱'e̱ da nadxixruj bea Dios: ―¿Nula benne' chunna caní guque̱' le sa' ljwezre bénnea' gule̱la gubán ca'? ");
INSERT INTO zatNTps_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Na' gunná bénnea' dxuxuzájle̱'e̱ da nadxixruj bea Dios: ―Bénnea' bexache lazre̱' le̱'. Nadxa Jesús guzre̱' le̱': ―Bexíaj lue', na' gúnquezu' ca'. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús bexu'e̱ neza, na' bezrine̱' tu xé̱zredau', na' lu xe̱zre na' zua tu nu'ula le̱' Marta, na' gulu'e̱ Jesús lizre̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta na', zua tu bi bile̱' le̱' María, na' María na' gudxé'e̱ zran ni'a Jesús chee̱ xenne̱' da dxuchálaje̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta dé̱le̱'e̱ da dxune̱', na' bzrine̱' lau Jesús, ne guzre̱' Le̱': ―Xran, ¿quebe dxexache lazru' neda' lawe' da dxucá'ana bi bila' neda' chee̱ guna' tuza' zrin chee̱ntu'? Guzre-be' gácale̱be' neda'. ");
INSERT INTO zatNTps_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesús beche̱be̱': ―Marta, Marta, dxezé̱le̱'e̱nu' gunne xue, ne zu' ste̱be ca naca chee̱ da ca' dxunu', ");
INSERT INTO zatNTps_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","san de̱ tuze da dxun na ba xen nu gun. María ba bezrelne̱' da cháwedxa, na' netú benne' quebe seque' cue̱' na. ");
INSERT INTO zatNTps_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tu zra Jesús bchálajle̱ne̱' Dios tu lataj, na' gate bexuzre bchálajle̱ne̱' Dios, na' tu benne' ca' dxusé̱dene̱' guzre̱' Le̱': ―Xran, bse̱de netu' guchálajle̱ntu' Dios, ca be̱n Juan, bsé̱dene̱' benne' ca' zaj de̱'e̱ le̱'. ");
INSERT INTO zatNTps_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús gunné̱': ―Gate guchálajle̱le Dios, na' nnale: Xrantu' Dios, zu' xabáa, gaca lá'azxa Lau' Lue'. Gudá nna be'u. Gaca ca dxaca lazru' lu xe̱zr la xu, ca da dxaca xabáa. ");
INSERT INTO zatNTps_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Be̱nna chee̱ntu' da gáguntu' na'a zra. ");
INSERT INTO zatNTps_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Bnite lau dul-la chee̱ntu' ca dxunite launtu' chee̱ benne' ca' dxelune̱' chee̱ntu' da cale̱la. Quebe gu'u lataj da xriwe̱' cu'u na netu' neza chee̱ na, na' bselá netu' lu na' da cale̱la. ");
INSERT INTO zatNTps_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nadxa Jesús guzre̱' benne' ca': ―Che tu benne' ládujla le'e zua tu ljwezre̱', na' che zrine̱' lizre benne' ljwezre̱' na' dxe̱la, ne xe̱'e̱ le̱': “Bi ljwezra', guleaj neda