﻿USE sofia;
DROP TABLE IF EXISTS sofia.zasNT_vpl;
CREATE TABLE zasNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zasNT_vpl WRITE;
INSERT INTO zasNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Guie zëëd laj ree bén na̱j xdiaagulal Jesucrist, bén zëëd ree loj xdiaa rey Davi në loj xdiaa Abraham. ");
INSERT INTO zasNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham brii laj xdad Isaac, abiꞌ Isaac gojc xdad Jacob, guiáad Jacob gojc xdad Judá con ree bijchaman. ");
INSERT INTO zasNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Dxel Judá cwaꞌman Tamar, abiꞌ guyu xiꞌn reeman brii laj reeman Fares con Zara. Fares gojc xdad Esrom, Esrom gojc xdad Aram. ");
INSERT INTO zasNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram gojc xdad Aminadab, Aminadab gojc xdad Naasón, Naasón gojc xdad Salmón. ");
INSERT INTO zasNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón gojc xdad Booz, guiáad xniaa Booz brii laj Rahab. Booz cwaꞌman Rut, abiꞌ xiꞌn reeman brii laj Obed. Obed gojc xdad Isaí, ");
INSERT INTO zasNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí gojc xdad rey Davi. Dxel rey Davi con bén goc lacheel Urías guyu xiꞌn reeman brii lajman Salomón. ");
INSERT INTO zasNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Dxel Salomón gojc xdad Roboam, Roboam gojc xdad Abías, Abías gojc xdad Asa. ");
INSERT INTO zasNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa gojc xdad Josafat, Josafat gojc xdad Joram, Joram gojc xdad Uzías. ");
INSERT INTO zasNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías gojc xdad Jotam, Jotam gojc xdad Acaz, Acaz gojc xdad Ezequías. ");
INSERT INTO zasNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías gojc xdad Mainán, Mainán gojc xdad Amón, Amón gojc xdad Josías. ");
INSERT INTO zasNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Dxel Josías gojc xdad Jeconías con ree bijchaman, tiamp ni guzu ree bén Israel Babilonia ziꞌc bén yuꞌ ladxguiib. ");
INSERT INTO zasNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Chi ma barii reeman Babilonia lod guzu reeman ziꞌc bén yuꞌ ladxguiib, gojl Salatiel, xdadaman gojc Jeconías. Dxel Salatiel gojc xdad Zorobabel. ");
INSERT INTO zasNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel gojc xdad Abiud, Abiud gojc xdad Eliaquim. Eliaquim gojc xdad Azor, ");
INSERT INTO zasNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor gojc xdad Sadoc, Sadoc gojc xdad Aquim. Aquim gojc xdad Eliud, ");
INSERT INTO zasNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud gojc xdad Eleazar. Eleazar gojc xdad Matán, Matán gojc xdad Jacob. ");
INSERT INTO zasNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob gojc xdad Xiëb lacheel Li. Dxel Li gojc xniaa Jesús, bén la gajc Cristo. ");
INSERT INTO zasNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Zian gojc, diizd xtiamp Abraham xt xtiamp rey Davi, guyu chidaj generacion, dxel chidaj generacion guyu diizd xtiamp rey Davi xt tiamp ni guzu ree bén Israel Babilonia ziꞌc bén yuꞌ ladxguiib, abiꞌ zachidaj generacion guyu diizd tiamp ni barii ree bén Israel Babilonia xt chi bidxin dxej gojl Jesucrist loj guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ze gojc gojl Jesucrist: Li, xniaaman, ma na̱j tiaꞌ Xiëb laaman. Per chi gad reeman tiaꞌ lasaꞌ, guyu xiꞌn Li por xSprijt Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Abiꞌ Xiëb guial najman benzaꞌc, ad guyëntaman nusaꞌnxtuman Li. Beenman xgab niroꞌnladxaman laaman ralanzi. ");
INSERT INTO zasNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Per laꞌtgaj cayüjnman xgab zian, balüüloj tijb xianjl Dios lojman loj bacaal, rëb anjl guin lojman: ―Xiëb, xdiaa Davi, ad bal rdxebil tiaꞌl Li, din xindo nüüm por xSprijt Dios zëëdix. ");
INSERT INTO zasNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tijb xindoniguiaaw gac xiꞌn Li, yaguꞌl lajx “Jesús”, din por laax gra ree xbejnx gac perdon xtol. ");
INSERT INTO zasNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Gra ree ni guie gojc persi guzojb xtiidx Dios ziꞌc gunee bén badëë xtiidxaman loj ree bejn, chi rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Tijb biinxdüb chuꞌ xiꞌn, abiꞌ chi galix grii lajx Emanuel, rën guiëban: Dios zaꞌnë dunuj ree. ");
INSERT INTO zasNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Chi baban Xiëb, dxel beenman ziꞌc gunabee xianjl Dios laaman, cwaꞌman Li, ");
INSERT INTO zasNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","per ad bagaalt Xiëb laaman xt chi bidxin dxej gojl xiꞌnman. Dxel baguꞌ Xiëb laj xindobëz guin JESÚS. ");
INSERT INTO zasNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús gojlaman Belén tijb guiedx naaz Judea, tiamp gunabee rey Herodes. Dxel bidxin ree bén rajc, Jerusalén, laa reeman na̱j magos, za reeman niz oriente. ");
INSERT INTO zasNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Abiꞌ gunabdiidx reeman, rëb reeman: ―¿Con xrey ree bén Israel, bén ma gojl? Din dunujn diizd duladxan baguiaan xbajlaman xanyabaa, zeel zioꞌpan din yazuxiban lojman. ");
INSERT INTO zasNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Chi biguien rey Herodes zian, dád guyunawëëgaman, nëgajc gra ree bén Jerusalén guyunawëëg. ");
INSERT INTO zasNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Zeel gurejdx Herodes gra ree bixhioz rniabee ree bixhioz, në ree mextr rajc ley, persi gunabdiidxaman loj reeman banguin na̱j gal Cristo. ");
INSERT INTO zasNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Dxel rëb reeman: ―Belén na̱j galaman, tijb guiedx naaz Judea, din ze bacaa bén badëë xtiidx Dios loj ree bejn: ");
INSERT INTO zasNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Lüj Belén, tijb guiedx naaz Judea, majsi guiedx dobëz najl loj gra ree guiedxroꞌ naaz Judea. Per lasajquil din luguiedx Belén guin grii tijb bén nabee guiniaj tëëman da bén Israel reen. ");
INSERT INTO zasNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Dxel ralanzi gurejdx rey Herodes bén rajc guin ree, persi gunabdiidxaman goc balüüloj bajl xanyabaa guin loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Abiꞌ guxhaalaman laa reeman Belén, rëbaman loj reeman: ―Gol wej, gol bignabdiidxchaaw graczi xcwent xindobëz guin. Abiꞌ chi yadxejlidi laax, laa gol bagojn gajc naj, din në naj chigzuxib lojx. ");
INSERT INTO zasNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Chi gulox rëb Herodes loj reeman zian, dxel zë reeman. Abiꞌ bajl xanyabaa baguiaa reeman diizd ladx reeman, nedan loj reeman, xt lod yuꞌ xindobëz guin guzudxen. ");
INSERT INTO zasNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Chi baguiaa reeman bajl guin, dád babaa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Abiꞌ chi guyu reeman lënü guin, baguiaa reeman xindo guin con xniaax Li. Abiꞌ bazuxib reeman gojp reeman laax respejt. Dxel guxhal roꞌ xcaj reeman, abiꞌ bazaladx reeman or, në yaal, nëtëë mirra par xindo guin. ");
INSERT INTO zasNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chi ma guidxin dxej yaza reeman, dxel bagojn Dios laa reeman loj bacaal chitëë yayejc reeman niz lod zaꞌ Herodes, zianan zeel bayejc reeman niz lood ren. ");
INSERT INTO zasNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Chi ma zia ree bén rajc guin ladx reeman, dxel balüüloj tijb xianjl Dios loj Xiëb loj bacaal, rëbaman: ―Bixche, cwaꞌ xindo guin con xniaax, gol chej niz Egipto. Ni gol guzuj xt chi ganin lëjt, din zaguiil Herodes laax din gugüjtaman laax. ");
INSERT INTO zasNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Dxel bixche Xiëb, cwaꞌman xindobëz guin con xniaax, abiꞌ guxhin guin brii reeman zë reeman niz Egipto. ");
INSERT INTO zasNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ni guzu reeman xt güjt rey Herodes. Zian guzojb xtiidx Dios ni gunee bén badëë xtiidxaman loj ree bejn, chi rëbaman: “Babedx da xiꞌnan Egipto.” ");
INSERT INTO zasNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Chi gogbee Herodes guial basquiee ree bén rajc guin laaman, dád bidxeꞌchaman. Dxel gunabeeman guiët gra ree xindoniguiaaw diizd ree xindo qui gojlri ree xt ree xindo ma yuꞌ ree guiaꞌ tioꞌp ijz, xindo yuꞌ ree Belén në gra ree guiedx rigaꞌ niz ni, guial yuꞌguijcaman ni rëb ree bén rajc guin guial ma gojc tioꞌp ijz ni baguiaa reeman bajl guin. ");
INSERT INTO zasNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Zian gojc cumplid ni bacaa Jeremías, bén badëë xtiidx Dios loj ree bejn, chi rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Biguien chaꞌ tijb bejn guiedx Ramá, yuꞌ guialroon në guialrbixdiaj, Raquelan cayoon por ree xiꞌnman, abiꞌ ad rileꞌt chu gusquiejn laaman guial güjt ree xiꞌnman. ");
INSERT INTO zasNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Per chi güt Herodes, dxel balüüloj tijb xianjl Dios loj Xiëb loj bacaal lod zojb reeman, Egipto, abiꞌ rëbaman lojman: ");
INSERT INTO zasNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Bixche, cwaꞌ xindobëz guin con xniaax. Gol baguiaj niz Israel, din ma güjt ree bén guyën nugüjt laax. ");
INSERT INTO zasNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Dxel bixche Xiëb cwaꞌman xindobëz guin con xniaax, bayejc reeman niz Israel. ");
INSERT INTO zasNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Per chi gogbee Xiëb guial Arquelao, xiꞌn Herodes, na̱j bén canabee niz Judea, bidxebaman naguiaj reeman niz ni. Dxel bagojn Dios laaman loj bacaal din che reeman niz Galilea, dxel zë reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Chi bidxin reeman ni, gurej reeman guiedx Nazaret. Zian gojc persi guzojb diidx ni gunee ree bén badëë xtiidx Dios loj ree bejn, guial grii laj Jesús bén Nazaret. ");
INSERT INTO zasNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Lën ree dxej ni bidxin Waj, bén baroobnijs bejn ree, loj yujbidx niz Judea catieꞌchaman xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Rëbaman: ―Gol bayüjn xgab por xtolidi din ma zidyob xguialrniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Xcwent Waj guinan bacaa Isaías, bén badëë xtiidx Dios loj ree bejn, chi rëbaman: Rguien chaꞌ tijb bén rbidxaꞌ niz loj yujbidx, rëbaman: “Gol beenchaaw xnejz dux Dad ree Dios, gol guxhal tijb nejz nali.” ");
INSERT INTO zasNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Con guidxlad camell gojcnë xab Waj, abiꞌ lënman bixii tijb guid. Gudaw tëëman biꞌtsu con dxijn yuꞌ dajn. ");
INSERT INTO zasNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Dxel bén Jerusalén ree në los demazri ree bén Judea nëtëë gra ree bén zojb gadëd roꞌ guiiw Jordán, brii reeman bicaagdiajg reeman ni rniee Waj. ");
INSERT INTO zasNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Dxel guxhoobdol reeman, abiꞌ baroobnijs Waj laa reeman loj guiiw Jordán guin. ");
INSERT INTO zasNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Per chi baguiaa Waj zien ree bénfarisew në ree bénsaducew bidxin din tiobnijs reeman, rëbaman loj reeman: ―¡Xiꞌn xindxab! ¿Chu bagojn lëjt din laadi loj castiroꞌ ni zëëd? ");
INSERT INTO zasNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Gol gubajn zagdxe din guiguien guial waliquidi ma bayüjndi xgab por xtolidi, ");
INSERT INTO zasNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","abiꞌ ad bal rlies xvalorgajquidi, rëbidi: “Dunujn zioꞌp loj xdiaa Abraham”, din naj rni lëjt xt guiaj guie ree zileꞌ yayüjn Dios xdiaa Abraham. ");
INSERT INTO zasNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Abiꞌ ree bén ad zinalt xnejz Dios ziꞌc rayal, ma zidyob dxej ni güünnë Dios laa reeman ziꞌc rüjnnë bejn tijb yag chi ad rtiatan, rutüügaman laan din cheꞌcan. ");
INSERT INTO zasNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Naj rni lojdi, curobnijsan lëjt con nijs ziꞌc tijb sen guial ma bayüjndi xgab por xtolidi. Per bén zidnal naj, laaman guroobnijs lëjt con xSprijt Dios con në bajl, din laaman mazri rajp guialrniabee guial lon, abiꞌ niꞌqui xgurëchaman ad rayalt gaxhiecan. ");
INSERT INTO zasNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Abiꞌ ziꞌc raya trigo zian güünnëman bejn. Din bén zinal ree xnejz Dios chinëman laa reeman lod rniabeeman, guiáad ree bén ad zinalt xnejz Dios guixhiaalaman laa reeman loj bajl ni ad yuꞌt dxej yayüꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Lën ree dxej zii guza Jesús niz Galilea wejman roꞌ guiiw Jordán lod zaꞌ Waj, din guroobnijs Waj guin laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Per ad nuyëntaman nuroobnijsaman Jesús, rëbaman lojman: ―Lüj rayal guroobnijs naj, ad najt rayal gurobnijs lüj. ");
INSERT INTO zasNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Dxel rëb Jesús lojman: ―Yo guna gac zian, din mazri zagdxe yaguieen gra ziꞌc rniabee Dios. Dxel cwëjb Waj baroobnijsaman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Chi gulox gurobnijsaman, naabzi bariiman loj nijs guin, dxejczi bixal xanyabaa, abiꞌ baguiaaman zidguiajt xSprijt Dios ziꞌc tijb palom xt guijcaman. ");
INSERT INTO zasNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Dxel biguien chaꞌ tijb bejn xanyabaa, rëbaman: ―Bén guie na̱j da Xiꞌnan, bén rën daꞌtan bén rabaanëꞌ tëën. ");
INSERT INTO zasNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Dxel binë xSprijt Dios Jesús niz loj yujbidx, din güün xindxab laaman prueb. ");
INSERT INTO zasNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ni guzuman tiuu dxej tiuu guiaal sin guialraw, dxel gulaanman. ");
INSERT INTO zasNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Abiꞌ bidxin xindxab beenx laaman prueb, rëbix: ―Bal wali najl xiꞌn Dios, gunabee yayajc guiaj guie ree guiadxtil. ");
INSERT INTO zasNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Per badxiꞌ Jesúsan rëbaman: ―Loj xtiidx Dios rëb: “Ad ganaxtizi guiadxtil guiban bejn, nëgajc gra diidx rniee Dios.” ");
INSERT INTO zasNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Dxel binë xindxab guin laaman Jerusalén, abiꞌ gulëꞌpix laaman guijc yadooroꞌ zojb luguiedxzii, ");
INSERT INTO zasNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","abiꞌ rëbix lojman: ―Bal wali najl xiꞌn Dios, gudidyaꞌ diizd guie, din loj xtiidx Dios rëb: Dios guixhiaal ree xianjlaman din guinia reeman lüj. Guiniaaz reeman lüj con yaa reeman chitëë ladx niꞌczi tijb guiaj guiaꞌl. ");
INSERT INTO zasNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Badxiꞌ Jesúsan, rëbaman: ―Rëb gajc loj xtiidx Dios: “Ad güünl prueb xDadil Dios.” ");
INSERT INTO zasNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Dxel binë xindxab guin laaman tijb guijc guiaꞌ ya daꞌt, lod balüüx laaman gra ree guiedx rigaꞌ loj guidxliuj në ree guialnazaꞌc yuꞌ loj reen. ");
INSERT INTO zasNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Abiꞌ rebix lojman: ―Naj gune gra ree ni guie lojl, bal guzuxibil lon guiniajchiꞌ tëël naj. ");
INSERT INTO zasNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Badxiꞌ Jesúsan, rëbaman: ―Biquied, xindxab, din loj gajc xtiidx Dios rëb: “Gunajchiꞌ xDadil Dios, tijbzi lojman been sirv.” ");
INSERT INTO zasNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Dxel biquied xindxab guin lojman, abiꞌ biꞌt tioꞌp choon ree xianjl Dios persi been reeman laaman sirv. ");
INSERT INTO zasNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Chi gogbee Jesús guial yuꞌ Waj ladxguiib, bayejcaman Galilea. ");
INSERT INTO zasNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Per ad gurejtraman guiedx Nazaret, wejman bisobaman guiedx Capernaum, tijb guiedx rigaꞌ gajxh roꞌ nijs Galilea niz lod goc ree xdajn Zabulón në Neftalí. ");
INSERT INTO zasNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Zian gojc persi gojc cumplid ni bacaa Isaías, bén badëë xtiidx Dios loj ree bejn, chi rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Bén Zabulón con ree bén Neftalí, në ree bén zojb gajxh roꞌ nijsdoo, nëtëë ree bén zojb xijch guiiw Jordán con gra ree bén zojb niz Galilea, lod zojb ree bén ad najt bén Israel, ");
INSERT INTO zasNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","gra reeman gubajn loj xcay. Yan ma brii tijb biani par laa reeman, abiꞌ biani guin guxhal xquiarguiejn ree bén ad nabant xnejz loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Diizd dxejzii guzuloj gutieꞌch Jesús xtiidx Dios, rëbaman: ―Gol bayüjn xgab por xtolidi din ma zëëd gajxh xguialrniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Laꞌtgaj caza Jesús gajxh roꞌ nijsdoo Galilea, baguiaaman Simón bén la gajc Bëd con bijchaman Andrejs. Cuzaal reeman guijxh loj nijs din guiniaaz reeman bëjl. Guial laan na̱j xchiin reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Dxel rëb Jesús loj reeman: ―Gol tanal naj, din gulün lëjt xhienaag güündi din gutoꞌpidi bejn par Dios luar guiniaazidi bëjl. ");
INSERT INTO zasNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Loj hor guin gajc basaꞌn xguijxh reeman abiꞌ zinal reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Guzaman zatibdaꞌn dxel baguiaaman zatioꞌp ree bejn, Jacob con bijchaman Waj, xiꞌngaan ree Zebedeo. Yuꞌ reeman loj tijb barcw con xdad reeman cayüjnchaaw xguijxh reeman. Dxel gurejdx Jesús laa reeman, ");
INSERT INTO zasNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","abiꞌ basaꞌn reeman barcw guin con xdad reeman, dxel laa zinal gajc reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Wej Jesús guidibczi niz Galilea, abiꞌ tijbgaj ree guiedx wejman lën ree yadoo persi balüüman bejn ree. Balüüman laa reeman xtiidx Dios, rëbaman loj reeman xhienaag na̱j xguialrniabee Dios, abiꞌ bayüjnman bén rdoob ree në gra ree bén rajc xhietëëz guialguijdxan. ");
INSERT INTO zasNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Guidibczi niz Siria bireꞌch xtiidx Jesús, abiꞌ bidnë reeman bén cusagdiaj ree gadxagayaa ni mal në graloj ree guialguijdx, bén yuꞌ ree xindxab luxdoo, në ree bén rëjtyaꞌ, nëtëë ree bén ad rileꞌt suli, abiꞌ bayüjn Jesús laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Dád zien ree bejn binal laaman, bén Galilea ree, bén zëëd ree Decápolis, bén Jerusalén ree, bén zëëd ree niz Judea në ree bén zëëd stiblad roꞌ guiiw Jordán. ");
INSERT INTO zasNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Chi baguiaa Jesús bén guixiuj ree, wëꞌpaman tijb guijc guiaꞌ abiꞌ gurejman, dxel gubig ree xbejnman lojman. ");
INSERT INTO zasNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Abiꞌ guzuloj culüüman laa reeman, rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Xiquilbaa ree bén ragbee guial ryaadx gagnë Dios laa reeman, din por zian yayal reeman lod rniabeeman. ");
INSERT INTO zasNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Xiquilbaa ree bén yuꞌnaya, din Dios yaguꞌ luxdoo reeman zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Xiquilbaa ree bén na̱j bén chaawladx, din laa reeman tiaꞌ guidxliuj ni rëb Dios gudëëdaman loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Xiquilbaa ree bén rzajc ziꞌc chi rliaan bejn o chi reꞌcaman nijs zian rën daꞌt reeman güün reeman ziꞌc rniabee Dios, din Dios gagnë laa reeman din güün reeman ziꞌc ruladxaman. ");
INSERT INTO zasNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Xiquilbaa ree bén raya lasaꞌ, din zian yaya Dios laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Xiquilbaa ree bén naya loj Dios, din laa reeman guguiaa laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Xiquilbaa ree bén rüjn naguiejn cwedxenë lasaꞌ, din laa reeman grii laj xiꞌn Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Xiquilbaa ree bén cadëd loj guialzi por graloj ni rujnnë bejn laa reeman guial cayüjn reeman ziꞌc rniabee Dios, din laa reeman yayal lod rniabeeman. ");
INSERT INTO zasNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Xiquilbaadi, chi rüjnnë reeman lëjt xhiernarajc në chi rnieeguijdx reeman lëjt nëtëë chi rudxiib reeman guijquidi graczi, guial najdi da bejnan. ");
INSERT INTO zasNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Gol badxeꞌ luxdoodi nix, gol babaa tëë din naroob na̱j ni gunee Dios lojdi xanyabaa. Abiꞌ lëjt ragbee guial ziangajc basagzi reeman bén badëë ree xtiidx Dios loj ree bejn gocli chi gadidi guiꞌt loj guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Lëjt na̱j ziꞌc zëd loj guidxliuj guie. Per bal id naxijran, ¿xhieza naag yayajcan naxij zatijb? Achetri dxiin güünan, gaz guireꞌchan abiꞌ chëꞌp ree bejn guijcan. ");
INSERT INTO zasNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Lëjt na̱j ziꞌc tijb biani loj guidxliuj guie, naj tëëdi ziꞌc tijb guiedx ni rigaꞌ tijb guijc guiaꞌ abiꞌ ad zajct guiguieꞌchan. ");
INSERT INTO zasNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ad ritiaguij tëët tijb guij par guidaꞌcwan lën tijb yagalm, rtiaguijn persi rzojban ya din gusnin loj gra ree bén yuꞌ lënü. ");
INSERT INTO zasNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ziangajc lëjt, gol gojc ziꞌc biani loj ree bejn, din chi guguiaa reeman ni zagdxe cayüjndi guzaꞌt reeman xDadidi Dios zagdxe bén yuꞌ xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Ad naladxidi zialan par günan ley tiblad, ley ni badëë Dios loj Moisejs o ni balüü ree bén badëë xtiidx Dios loj ree bejn, zialan par günanan cumplid. ");
INSERT INTO zasNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Din naj rni lojdi, laꞌtgaj yuꞌ xanyabaa në guidxliuj, ad ziquiedt tijb punt o tijb lejtr loj ley xt chi gac gra ni na̱j gac. ");
INSERT INTO zasNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Zianan zeel bén ad ruzoobt tijb mandamient ni zëëd loj ley guin majsi nidobëz na̱j mandamient guin, bal rulüü tëëman bejn ree güün reeman zian, laaman lasajc taꞌnzi lod rniabee Dios. Per bén ruzoob gra ree mandamient ni zëëd loj ley guin, rulüü tëëman bejn ree guzoob reeman laan, laaman na̱j mazri bén lasajc lod rniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Zeel naj rni lojdi, bal id zabajndi mazri zagdxe guial loj ree mextr rajc ley në ree bénfarisew, ad zayaltidi lod rniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Lëjt ragbee guial rëb Dios loj ree xbéngulalidi: “Ad gugüjtil bejn, din bén gugüjt bejn yayalaman casti.” ");
INSERT INTO zasNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Per naj rni lojdi, chutëëz bén rdxeꞌchnë lasaꞌ, yayalaman casti, në bén rniee diidxguijdx lasaꞌ xt loj guxtis zajc cheman, guiáad bén rëb loj lasaꞌ achet sirv lüj, laaman yayal loj bajl yuꞌ gabijl. ");
INSERT INTO zasNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Zeel bal zinël gon lën yadoo abiꞌ yagaj rusaaladxil guial yuꞌ bén rdxeꞌchil, ");
INSERT INTO zasNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","basaꞌnsii xgonl yagaj, yalojxgaj babenë bén rdxeꞌchil zagdxe, dxel ma zileꞌ yayejquil din gusaꞌn xgonl. ");
INSERT INTO zasNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Bal chu bén rudëed lüj loj guxtis, bayaꞌnnëman diidx zagdxe laꞌtgaj yuꞌ tiamp, chitëë yayüman lüj loj guxtis, abiꞌ guxtis guin nabee chuꞌl ladxguiib. ");
INSERT INTO zasNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Naj rni lüj, ad zariitil ladxguiib guin xtczi quixil gra ni na guxtis guin. ");
INSERT INTO zasNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Lëjt ragbee guial loj ley rëb: “Ad sunël lacheel ben ren.” ");
INSERT INTO zasNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Per naj rni lëjt, chutëëz bén rüjn xgabmal chi ruguiaaman tijb béngunaa, con laan ma beenman dol lën luxdooman por béngunaa guin. ");
INSERT INTO zasNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Bal laagajc guiaaloj ladbeel rüjn din güünl dol, mazri zagdxe na̱j gulëën bazaalan zijt. Din mazri zagdxe na̱j nit tiblad guiaalojl luar che guidibil gabijl. ");
INSERT INTO zasNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Abiꞌ bal laagajc yaa ladbeel rüjn din güünl dol, gutüꞌn bazaalan zijt. Din mazri zagdxe na̱j nit tiblad yaal luar che guidibil gabijl. ");
INSERT INTO zasNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Ma bacaagdiajg tëëdi: “Chutëëz bén ralaꞌ lacheel, rayal gudëëdaman guiꞌch lojman guial ma balaꞌ lasaꞌ reeman.” ");
INSERT INTO zasNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Per naj rni lëjt: Xinguiaaw ralaꞌ xbéngunaa, abiꞌ ad zaꞌnët béngunaa guin xin ren, laagajc laax cayüjn din sunë xbéngunaax xin ren. Abiꞌ xin tiaꞌ béngunaa guin dolan cayüjnx. ");
INSERT INTO zasNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Rëb tëë Dios loj ree xbéngulalidi: “Ad guzaꞌt xliaꞌdi Dios, rayal güündi cumplid ni rëbidi gudëëdidi lojman.” ");
INSERT INTO zasNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Per naj rni lojdi: Ad rayaltczi guzaꞌtidi Dios, niꞌqui xanyabaa par chililadx reeman lëjt din ni zojb Dios, ");
INSERT INTO zasNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","niꞌqui guidxliuj din loj guidxliuj na̱j lod ruzuj guiaꞌman, niꞌqui Jerusalén din laan na̱j ladx rey mazri rniabee. ");
INSERT INTO zasNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ad guzaꞌt tëë guijquidi par chililadx reeman lëjt, din niꞌqui tijb guidxguijquidi ad zajct güündi ni yaꞌs o ni naquich ya. ");
INSERT INTO zasNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Zagdxeli con gol güjdx “an” o “aꞌn”, din los demazri ree ni guinieedi loj xindxab zan. ");
INSERT INTO zasNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Lëjt ragbee guial loj ley rëb: “Bén cwëë guiaalojl, gulëë gajc guiaalojman. Guiáad bén cwëë layil, gulëë gajc layaman.” ");
INSERT INTO zasNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Per naj rni lëjt: Ad yadxiꞌdi ni mal por ni mal, bal chu chëëz xhajg ladbeedi, gol badëë stibladan chëëzaman. ");
INSERT INTO zasNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Bal chu bén tilë lüj din cwëëxuuman xmanguil, badëë në xchamarril tiaꞌman. ");
INSERT INTO zasNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Abiꞌ bal rüjn reeman lüj naguiejn güül tijb yuu din sanëlan tib kilometro, guzanën tioꞌp kilometro. ");
INSERT INTO zasNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Chutëëz bén rniab xhienin lojl, badëëdan, bal chu tëë rguiꞌn xhienin lojl ad bal cwexuul gudëëdilan. ");
INSERT INTO zasNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ragbee tëëdi rëb ree bejn: “Guyën bén rën lüj, bidxeꞌch tëë bén rdxeꞌch lüj.” ");
INSERT INTO zasNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Per naj rni lojdi: Gol guyën bén rdxeꞌch lëjt, gol gurejdx tëë Dios por ree bén rzunal lëjt, din güün reeman lëjt ni mal. ");
INSERT INTO zasNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Din zian gaquidi xiꞌn xDadidi Dios bén yuꞌ xanyabaa, din laaman ruslejn xgubijdxaman par ree benzaꞌc në par ree benmal, ruscal tëëman guia par ree bén naban ziꞌc rayal në par ree bén ad nabant ziꞌc rayal. ");
INSERT INTO zasNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Din bal rëndi ganaxzi bén rën lëjt, ¿xhieza tiaꞌdi loj Dios zian? Din xt béndol ree rüjn zian. ");
INSERT INTO zasNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Abiꞌ bal ganaxzi bén rëndi rugajpdiozidi, ¿xhieza ni zagdxe cayüjndi? Din xt bén ad nünbeet ree Dios rüjn zian. ");
INSERT INTO zasNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Zeel gol gojc benzaꞌc, ziꞌc na̱j xDadidi Dios bén yuꞌ xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Ad güündi ni zagdxe niz loj ree bejn naabzi par yadxaloj reeman lëjt. Din bal güündi zian, xDadidi Dios bén yuꞌ xanyabaa achet guneeman lojdi. ");
INSERT INTO zasNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Zeel chi güünl yudar bén ryaadx xhienin, ad guitieꞌchil diidx par gagbee bejn xhie cayüjnl ziꞌc rüjn ree bén rusquiee, lën ree yadoo në ree lunejz, din guilies bejn xvalor reeman na̱j reeman benzaꞌc. Per diidxliczi rnin lojdi, laazan na̱j ni rayal reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Zeel chi güünl yudar bén ryaadx xhienin, niꞌczi loj xmiwdaꞌtil ad gül diidx ni cayüjnl. ");
INSERT INTO zasNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mazri zagdxe lüjzi gagbee ni cayüjnl, abiꞌ xDadil Dios laaman cuguiaa ni cayüjn lüjzi, laaman gunee ni rayalil. ");
INSERT INTO zasNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Chi cwedx guiniabidi Dios, ad güündi ziꞌc rüjn ree bén rusquiee, bén ruladx ree rzuli par cwedx guiniab reeman Dios lën ree yadoo në ree xquin nejz, din yadxaloj bejn laa reeman. Din naj rni lojdi, laazan na̱j ni rayal reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Per lüj chi cwedx guiniabil Dios, bayu lënü lidxil, basiaaw roꞌ port, dxel gurejdx gunab Dios bén zaꞌnë lüj. Abiꞌ laaman cuguiaa ni cayüjn lüjzi, laaman gunee ni rayalil. ");
INSERT INTO zasNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Chi rbejdx rniabidi Dios, ad radxiꞌdi diidx guin guiëꞌtzi guiëꞌt naabzi par gacxhiej xtiidxidi, ziꞌc rüjn ree bén ad nünbeet Dios. Din laa reeman naladx guial zien ni rniee reeman mazri guidxgaꞌ Dios laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ad güündi ziꞌc rüjn reeman, din xDadidi Dios ma ragbeeman xhie ryaadxidi chi gadidi guiniab laan. ");
INSERT INTO zasNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Zeel chi cwedx guiniabidi Dios, gol güjdx: Dad, lüj yuꞌ xanyabaa, rayal yayaꞌp daꞌtan lajl respejt. ");
INSERT INTO zasNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Gac ziꞌc rniabeel. Gac ziꞌc rënl loj guidxliuj ziꞌc rajc xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Banee ni yadaawan guixie guixie. ");
INSERT INTO zasNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Been dunujn perdon gra ree ni mal ma baguieenan ziꞌc raguieenan perdon bén rüjn ree dunujn ni mal. ");
INSERT INTO zasNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ad guslaal dunujn yaguieenan dol, babëë dunujn loj gra ni mal. ");
INSERT INTO zasNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Din bal güündi perdon bén rüjn lëjt ni mal, ziangajc xDadidi Dios bén yuꞌ xanyabaa züjn gajcaman perdon xtolidi. ");
INSERT INTO zasNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Per bal id züjndi perdon bén rüjn ree lëjt ni mal, ziangajc xDadidi Dios ad züjntaman lëjt perdon. ");
INSERT INTO zasNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Chi rbaꞌndi ad güün lojdi naya, ziꞌc rüjn ree bén rusquiee din guguiaa bejn guial nabaꞌn reeman. Naj rni lojdi, guial laazan na̱j ni rayal reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Per lüj, chi rbaꞌnl, gudiib lojl gudüjn tëë guijquil ");
INSERT INTO zasNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","chitëë gagbee ree bejn guial nabaꞌnl. Tijbzi xDadil Dios bén zaꞌnë lüj na̱j bén gagbee laan, abiꞌ laaman gunee lüj ni rayal tiaꞌl. ");
INSERT INTO zasNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Ad gutoꞌpidi guialnazaꞌc loj guidxliuj guie lod zajc tiabe reen o xhin reen o chuꞌ xingubaan cwan laa reen. ");
INSERT INTO zasNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Zagdxeli gol been naguiejn gol been gan guialnazaꞌc yuꞌ xanyabaa lod ad zacabet reen, lod ad zaxint reen, lod ad zu tëët xingubaan cwan laa reen. ");
INSERT INTO zasNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Lod gapil guialnazaꞌc guin yagaj su luxdool. ");
INSERT INTO zasNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Guiaaloj bejn na̱j ziꞌc tijb biani par xcuerpaman. Zeel bal cayüjnl ni zagdxe, guidib xcuerpil rajp biani. ");
INSERT INTO zasNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Per bal cayüjnl ni mal, guidib xcuerpil na̱j ziꞌc lod nacay, ziꞌc na̱j lod nacaybuu. ");
INSERT INTO zasNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Ad zileꞌt chu güün sirv loj tioꞌp patron, din zadxeꞌchaman tijbaman abiꞌ guiënman stijbaman, o gacaman benzaꞌc con tijbaman abiꞌ ad zëntaman stijbaman. Zeel ad zileꞌt güündi sirv loj Dios në loj milia. ");
INSERT INTO zasNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Naj rni lëjt: Ad chuꞌdi xgab por ni gawidi në por ni guiëꞌdi din guibandi, niꞌqui por lajd ni gacwidi. Guialnaban mazri lasajc guial loj guialraw, abiꞌ xcuerp bejn mazri lasajc guial loj xabaman. ");
INSERT INTO zasNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Gol baguiaa ree be rzuj xanyabaa, ad rxübint reeb, ad ratoꞌp tëët reeb guialnazaꞌc, ad na̱j tëët lod cuꞌchaaw reeb guialnazaꞌc guin. Per xDadidi Dios bén yuꞌ xanyabaa rudëëd ni raw reeb. Abiꞌ mazri lasajquidi guial loj reeb. ");
INSERT INTO zasNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Abiꞌ tëë, ¿wen guial ru daꞌtidi xgab ma güün lëjt mazri ziool ya? ");
INSERT INTO zasNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Chexquiza zeel dád rudi xgab por xabidi? Gol baguiaa xhienaag rniꞌs ree guiaa dajn. Achet dxiin rüjn reen ad rguib tëët reen, ");
INSERT INTO zasNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","per niꞌqui rey Salomón ad guzujchaawt ziꞌc zaꞌchaaw ree guiaa majsi mast guzujchaawaman. ");
INSERT INTO zasNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Abiꞌ bal guiꞌxh dajn ruzujchaaw Dios yan, majsi guixiezi cheꞌcan. Diidxgui lëjt bén ad rliladxzaꞌct ree laaman, nid zuneeman ni gacwidi ya. ");
INSERT INTO zasNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Zeel ad rudi xgab xhie gawidi, o xhie guiëꞌdi, o xhie gacwidi. ");
INSERT INTO zasNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Din bén ad nünbeet ree Dios rüjn zian, laa reeman ru xgab por gra ree ni guin. Per lëjt yuꞌ xDadidi xanyabaa, abiꞌ laaman ragbeechaaw xhienin ryaadxidi. ");
INSERT INTO zasNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Per yalojxgaj gol baguiil güündi ziꞌc rniabee Dios, gol been tëë ziꞌc rënman, dxel laaman gunee gra ree ni ryaadxidi. ");
INSERT INTO zasNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ad chuꞌdi xgab por ni gac guixie, gol basaꞌnan par guixie, zagdxeli gol guyu xgab tib dxejgaj. ");
INSERT INTO zasNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Ad gulaꞌchidi bejn chitëë saquidi zian. ");
INSERT INTO zasNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Din bal rulaꞌchidi bejn ziangajc saquidi, ziꞌc rüjnnëdi bejn ziangajc güünnë reeman lëjt. ");
INSERT INTO zasNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ad gulaꞌchidi bén ren por falt dobëz ni rajpaman, zagdxeli gol guyu xgab por falt naroob ni rajpidi. ");
INSERT INTO zasNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Abiꞌ bal mazri falt naroob rajpidi, ¿xoza guiëbidi loj stijb bejn: “Ad laat na̱j ni rüjnl”? ");
INSERT INTO zasNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Bén rusquiee! Yalojxgaj gol been ziꞌc rayal, chi ma rüjndi zian dxel ma zileꞌ guiëbidi loj stijb bejn: “Ad laat na̱j ni rüjnl.” ");
INSERT INTO zasNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Ad güündi naguiejn güüncwent ree bén ad rënt güüncwent xtiidx Dios, chitëë xhie güünnë reeman lëjt. Din bal güündi zian, laan na̱j ziꞌc chi ruzaal bejn tijb ni nagleꞌ loj bëꞌcw, o chi ruzaal bejn tijb ni lasajc loj cüch abiꞌ chëꞌpzib guijcan. ");
INSERT INTO zasNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Naj rni lëjt: Gol gunab loj Dios, abiꞌ laaman gunee ni rniabidi. Gol baguiilaman, zadxejlidi laaman. Gol gurejdx gunabaman, züjncwentaman lëjt. ");
INSERT INTO zasNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Din bén rniab, zacaꞌman. Abiꞌ bén rguiil, zadxejlaman, guiáad bén rbejdx rniab laaman, züjncwentaman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Lëjt najdi dad, ¿wen zudëëdi tijb guiaj loj xiꞌndi ya chi guiniabix guiadxtil?, ");
INSERT INTO zasNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿o zudëëdi tijb bëël ya chi guiniabix bëjl? ");
INSERT INTO zasNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nacli lëjt najdi béndol rajc rudëëdi ni rën xiꞌndi. ¡Diidxgui xDadidi bén yuꞌ xanyabaa, nid zudëëdaman ni zagdxe loj ree bén rniab laan ya! ");
INSERT INTO zasNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Gol beennë ree bejn ziꞌc rëndi güünnë reeman lëjt. Din zian rniabee xley Dios në ni bacaa ree bén badëë xtiidxaman loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Gol been naguiejn din chuꞌdi niz roꞌ port nadëë. Din port gulajg në nejz gulajg, laa reen na̱j ni zinë bejn loj nejz mal, abiꞌ zien bejn zë loj nejz guin. ");
INSERT INTO zasNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Per port nadëë guin në nejz nadëë guin laa reen na̱j ni rnë bejn lod yuꞌ guialnaban tiblayaa, abiꞌ taꞌnzi ree bejn zë loj nejz guin. ");
INSERT INTO zasNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Gol gojp cudad con ree bén rusquiee rëb rudëëd reeman xtiidx Dios. Din rulüü dád bén chaawladx reen, per rüjnzi reeman par gusquiee reeman bejn. ");
INSERT INTO zasNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Per zayünbeedi laa reeman por ni rüjn reeman, din ad rtiat uv loj yaquiëjch ad rtia tëët higo loj guiꞌxh guiëjch. ");
INSERT INTO zasNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Zeel gra yag zagdxe rtia ni zagdxe lojn. Guiáad gra yag guijdx rtia ni guijdx lojn. ");
INSERT INTO zasNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ad rtiat ni guijdx loj yag zagdxe, ad rtia tëët ni zagdxe loj yag guijdx. ");
INSERT INTO zasNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Gra yag ad rtiat ni zagdxe, rirugan dxel reꞌcan. ");
INSERT INTO zasNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ziangajc lëjt zayünbeedi laa reeman por ni rüjn reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Ad grat ree bén na lon: “Dad, Dad,” chuꞌ lod rniabee Dios, ganaxzi ree bén rüjn ziꞌc rën da Dadan, bén yuꞌ xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Dxejzii, zien ree bén na lon: “Dad, Dad, por lüj batieꞌchan xtiidxil, abiꞌ guial bazaꞌtan lajl balëën xindxab ree luxdoo ree bejn, baguieen tëën zien ree milagr guial bazaꞌtan lajl.” ");
INSERT INTO zasNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Dxel guiën loj reeman: “Ad benbeetczan lëjt, gol gubiꞌca lon béndol.” ");
INSERT INTO zasNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Chutëëz bén rucaagdiajg da diidxan abiꞌ rüjnman ni rën, laaman na̱j ziꞌc tijb bén nasin gules xcimiant lidx loj guiaj. ");
INSERT INTO zasNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Abiꞌ gol guia, dxel biguiajt nijs roꞌ gubiꞌ tëë bidoxh, gulaj reen lad yu guin, per ad gulenxantan guial na̱j xcimiantan loj guiaj. ");
INSERT INTO zasNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Per bén riguiejn da diidxan abiꞌ ad rüjntaman ni rën, laaman na̱j ziꞌc tijb bén ad nasint bazoob lidx loj üx. ");
INSERT INTO zasNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Abiꞌ chi gol guia biguiajt nijs naroob, gubiꞌ tëë bidoxh. Abiꞌ gulaj reen lad yu guin zianz gulenxanan, niꞌqui tibdaꞌnan ad bayaꞌnt. ");
INSERT INTO zasNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Chi gulox guneenë Jesús bén guin ree, graczi reeman badxa daꞌt loj ziꞌc balüüman laa reeman, ");
INSERT INTO zasNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","guial rulüüman laa reeman ziꞌc bén rajp guialrniabee, ad ziꞌc rulüüt ree mextr rajc ley. ");
INSERT INTO zasNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Chi baza Jesús ruguiaꞌ guin, dád zien bejn nal laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Dxel gubig tijb bejn lojman rajcaman guialguijdx la lepra, abiꞌ bazuxibaman lojman, rëbaman: ―Dad, bal tiëbil, zileꞌ yayüjnl naj. ");
INSERT INTO zasNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Dxel basli yaa Jesús baquiꞌman laaman, rëbaman: ―Rënan. Bayajc. Chi rëb Jesús zian, loj hor ziigajc biquied guialguijdx guin abiꞌ bayaman. ");
INSERT INTO zasNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Dxel rëb Jesús lojman: ―Bacaagdiajg ni ganin lüj. Achu loj guiëbil guial ma bayajquil. Lojzi bixhioz wej din guguiaaman lüj, binë gon ni rayal chinël ziꞌc gunabee Moisejs, din gagbee gra ree bejn guial ma bayajquil. ");
INSERT INTO zasNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Chi guyu Jesús luguiedx Capernaum, tijb suldad Rom rniabee ree suldad bibig lojman, guzajcaman laaman liaadx, ");
INSERT INTO zasNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","rëbaman: ―Dad, laa da mojsan nagaꞌ lidxan ragxuux. Ad rileꞌt chixchex, dád cusagzi guialguijdx guin laax. ");
INSERT INTO zasNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Dxel rëb Jesús lojman: ―Gan din yayünan laax. ");
INSERT INTO zasNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Badxiꞌ bén rniabee ree suldad guinan, rëbaman: ―Dad, ad rayaltan chuꞌl lidxan, per gunee diizd guie din yayajc da mojsan. ");
INSERT INTO zasNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Din ziꞌc naj yuꞌ ree bén rniabee naj, ziangajc naj yuꞌ ree da suldadan xin rniabeen. Chi rën loj tijb reex: “Wej”, rejx, chi rën loj stijbix: “Guda,” riꞌtix. Abiꞌ chi rë loj da mojsan: “Been ni guin”, rüjnxan. ");
INSERT INTO zasNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Chi biguiejn Jesús zian, dád badxalojman abiꞌ rëbaman loj ree bén zinal laaman: ―Naj rni lojdi, niꞌqui Israel ad wadxaaglojtan tijb bén rliladx Dios ziꞌc rliladx bén guin Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Naj rni lëjt, dád zien ree bén gralad yayal gawnë Abraham, në Isaac, në Jacob lod rniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Guiáad ree bén rayal niu lod rniabee Dios, laa reeman yayal lod nacay daꞌt lod goon reeman lod gaw tëë lay reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Dxel rëb Jesús loj suldad rniabee guin: ―Baguiaj lidxil, gac tëë ziꞌc ma bililadxil. Abiꞌ loj hor guin gajc bayajc xmojs bén guin. ");
INSERT INTO zasNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Chi we Jesús lidx Bëd, baguiaaman xnasuegr Bëd nagaꞌman yuꞌman xliaa. ");
INSERT INTO zasNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Dxel gunaazaman yaaman, abiꞌ bariiman xliaa guin, dxel bixcheman guzuloj cuyaanman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Chi ma caxhin, binë ree bejn zien ree bén yuꞌ xindxab luxdoo loj Jesús. Abiꞌ con tijb diidx ni guneeman babëëman xindxab guin luxdoo reeman, bayüjn tëëman gra ree bénragxuu. ");
INSERT INTO zasNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Zian gojc persi gojc cumplid ni rëb Isaías, bén badëë xtiidx Dios loj ree bejn, chi rëbaman: “Laaman zignë dux guialguijdx ree, laa tëëman zignë dux guialzi ree.” ");
INSERT INTO zasNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Chi baguiaa Jesús bénguixiuj nayaw laaman, gunabeeman tëdaman stiblad roꞌ nijs na̱j yagaj. ");
INSERT INTO zasNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Dxel gubig tijb mextr rajc ley loj Jesús, rëbaman: ―Mextr, rënan guidnaalan lüj bantëëz guin chel. ");
INSERT INTO zasNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Abiꞌ rëb Jesús lojman: ―Bëz ree yuꞌ xbiliaa reeb, abiꞌ ree biguijn yuꞌ xguixbitiaꞌs reeb. Per Bén guxhaal Dios niꞌqui lod quixh guijcaman ad yuꞌt. ");
INSERT INTO zasNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Dxel rëb stijb ree bén zinal laaman: ―Dad, baslaa naj gabenëꞌ da dadan xt chi guiëtaman. ");
INSERT INTO zasNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Per rëb Jesús lojman: ―Tanal naj, basaꞌnman con ree bén ad rënt guidnal naj, laa reeman guquieꞌch laaman chi guiëtaman. ");
INSERT INTO zasNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Guyu Jesús loj barcw con ree xbejnman, ");
INSERT INTO zasNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","abiꞌ laꞌtgaj zë reeman loj nijs guin dxejlczi gubiꞌ tijb bidoxh, ma cazëëbczi barcw guin xan nijs. Per Jesús nagaꞌyëjsaman. ");
INSERT INTO zasNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Dxel bicwëën ree xbejnman laaman, rëb reeman: ―¡Dad, gunaj dunujn! ¡Ma cayzëëban xan nijs! ");
INSERT INTO zasNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Badxiꞌman laan rëbaman: ―¿Chexc zeel dád rdxebidi? ¿Chexc zeel ad rliladxzaꞌctidi naj? Dxel bixcheman abiꞌ gunabeeman bacwëëz bi guin në nijs guin. Loj hor ziigajc babedxe reen. ");
INSERT INTO zasNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Abiꞌ ree xbejnman badxa daꞌt loj reeman, zianz gunabdiidx loj lasaꞌ reeman, rëb reeman: ―¿Chu bén guin, zeel xt bi në nijs ruzoob xtiidxaman? ");
INSERT INTO zasNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Chi bidxin Jesús stiblad roꞌ nijs guin, loj xguidxliuj ree bén Gadara, dxel tioꞌp ree xinguiaaw yuꞌ xindxab luxdoo brii reex la̱d ree baa abiꞌ wej reex loj Jesús. Dád nadoxh reex, zeel ad rileꞌt chu tëd lunejz guin. ");
INSERT INTO zasNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Chi baguiaa reex Jesús, gurixdiaj reex rëb reex: ―¿Xhie rënl con dunujn, Jesús, Xiꞌn Dios? ¿Zëëdil guie ya din gusagzil dunujn chi gadli dxej guidxin? ");
INSERT INTO zasNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Per gajxh yagaj zaꞌ zien ree cüch, cayaw reeb, ");
INSERT INTO zasNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","abiꞌ guzajc ree xindxab guin liaadx loj Jesús, rëb reex: ―Bal yabëël dunujn, banee mod yadxuꞌn lën ree cüch guin. ");
INSERT INTO zasNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Dxel rëb Jesús: ―Gol wej. Dxel barii ree xindxab guin luxdoo ree bén guin bayu reex lën ree cüch guin. Abiꞌ gra reeb guzuloj cuxüün zianz bitidiaꞌ reeb roꞌ tijb balaꞌ xt loj nijs, lod guꞌ reeb nijs abiꞌ güjt reeb. ");
INSERT INTO zasNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Abiꞌ ree bén cayajp cüch guin ree, baxüün reeman. Dxel chi badxin reeman luguiedx guin, be reeman diidx gra ni goc në gra ni guzac ree bén yuꞌ ree xindxab guin luxdoo. ");
INSERT INTO zasNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Dxel gra ree bén guiedx guin brii wej lod zaꞌ Jesús, abiꞌ chi baguiaa reeman laaman, guzajc reeman laaman liaadx, din yazaman ladx reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Dxel bayu Jesús loj tijb barcw, badëdaman stiblad roꞌ nijs guin abiꞌ badxin ladxaman. ");
INSERT INTO zasNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Yagaj binë ree bejn tijb xin nëjt xcuerp, nagaꞌx loj da. Chi baguiaa Jesús guial rliladx reeman laaman, rëbaman loj xin ragxuu guin: ―Baguꞌ luxdool zagdxe, xiꞌn. Ma benan perdon xtolil. ");
INSERT INTO zasNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Dxel tioꞌp choon ree mextr rajc ley been reeman xgab: “Diosan rüjnx tiblad guial rnieex zian.” ");
INSERT INTO zasNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Per guial gogbee gajc Jesús xhie xgaban cayüjn reeman, dxel rëbaman loj reeman: ―¿Chexc zeel rüjndi xgabmal? ");
INSERT INTO zasNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Conin mazri nawëëg gac? ¿Guial guiën ya: “Ma benan perdon xtolil” o guiën: “Bixche, guza”? ");
INSERT INTO zasNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Per yan, gulün lëjt guial naj, Bén guxhaal Dios raꞌpan guialrniabee loj guidxliuj guie par günan perdon dol ree. Dxel rëb Jesús loj xin ragxuu guin: ―Bixche. Bacaꞌ ni goꞌtil loj. Baguiaj lidxil. ");
INSERT INTO zasNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Laa bixchegajquix zia lidxix. ");
INSERT INTO zasNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Chi baguiaa ree bén guin zian, bidxeb reeman, abiꞌ bazaꞌt reeman Dios zagdxe por guialrniabee ni badëëman loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Chi baza Jesús yagaj ziaman, baguiaaman tijb xin la Matew. Zojbix lod ruquijxix impuest, abiꞌ rëbaman lojx: ―Tanal naj. Dxel bisu Matew zinalix laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tijb dxej chi cayaw Jesús lidx Matew con zien ree bén ruquijx impuest në ree bén zëëb xtiidx ad nabant xnejz, gra reeman zojbnë Jesús xan mex con ree xbejnman. ");
INSERT INTO zasNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Chi baguiaa ree bénfarisew zian, gunabdiidx reeman loj ree xbejn Jesús rëb reeman: ―¿Chexc zeel cayawnë xmextridi bén ruquijx ree impuest në ree béndol? ");
INSERT INTO zasNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Chi biguiejn Jesús ni rëb reeman, dxel rëbaman: ―Bénnadaan ree ad ryaadxt reeman doctor, bénragxuu ree laa reeman ryaadx doctor. ");
INSERT INTO zasNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gol chej, gol basiid xhie rën guiëb loj xtiidx Dios lod rëb: “Ni mazri rënan na̱j guial yaya lasaꞌdi luar guidnëdi gon lon.” Yan, naj ad zialtan par ree benzaꞌc, zialan par ree béndol, din yayüjn reeman xgab por xtol reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Dxel ree xbejn Waj, bén baroobnijs bejn ree, bibig reeman loj Jesús, zianz gunabdiidx reeman lojman, rëb reeman: ―¿Chexc zeel dunujn con ree bénfarisew dád zienvolt rabaꞌnan, guiáad ree xbejnl ad rbaꞌnt reeman? ");
INSERT INTO zasNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Badxiꞌ Jesúsan rëbaman: ―Lod yuꞌ guialruxhliaa, ¿wen runaya ree biooz ya chi zaꞌnë xin cuxhliaa guin laa reeman? Per guidxin dxej chiquiedix, dxel guibaꞌn reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Achut rataꞌ lajd cüb loj lajd yojx din zaxüꞌn lajd cüb guin, abiꞌ mazri quixyaꞌn lajd yojx guin. ");
INSERT INTO zasNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ad rguꞌ tëët reeman vin cüb lën anfr yojx din zaxyaꞌ anfr yojx guin, abiꞌ ziꞌc anfr guin ziꞌc vin guin zaxin reen. Zeel na̱j guial chuꞌ vin cüb lën anfr cüb, din niꞌqui tijb reen ad zaxint. ");
INSERT INTO zasNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Laꞌtgaj canee Jesús zian, bidxin tijb bén rniabee lën xyadoo ree bén Israel, abiꞌ bazuxibaman loj Jesús, rëbaman: ―Yangajczi güjt da xiꞌndxaꞌpan, per bal guiꞌtil guixhioob yaal guijquim zabanm. ");
INSERT INTO zasNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Dxel zinë Jesús laaman con ree xbejn Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Abiꞌ tijb béngunaa ragxuu ma gojc chiptioꞌp ijz ad rbëzt ryajbaman rejn, gubigaman niz xijch Jesús abiꞌ bagaalaman guiaꞌ xabaman, ");
INSERT INTO zasNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","guial gunaladxaman: “Bal gugaalaman majsi xabzaman, zayajcaman.” ");
INSERT INTO zasNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Per badxiꞌ loj Jesús, abiꞌ baguiaadxijchaman béngunaa guin, dxel rëbaman lojman: ―Zagdxe baguꞌ luxdool, xiꞌn. Ma bayajquil guial bililadxil naj. Abiꞌ loj hor ziigajc bayajc bén guin. ");
INSERT INTO zasNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chi bidxin Jesús lidx bén rniabee guin, baguiaaman ma rigaꞌ ree xinrucwejdx din chiquieꞌch reex xiꞌnman, abiꞌ ree bejn roon rbixdiaj reeman guijquim. ");
INSERT INTO zasNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Dxel rëb Jesús loj reeman: ―Gol barii guie, din ad güjtt bindo guin, nagaꞌyëjszim. Abiꞌ baxijdxnë reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Chi ma barii reeman, zianz guyuman. Gunaazaman yaa bindo guin dxel bixchem. ");
INSERT INTO zasNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Abiꞌ guidib niz yagaj bireꞌch diidx ni goc. ");
INSERT INTO zasNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Chi baza Jesús yagaj, binal tioꞌp bénlutiaꞌp laaman, rbixdiaj reeman, rëb reeman: ―¡Jesús, xdiaa Davi, baya dunujn! ");
INSERT INTO zasNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Chi badxin Jesús lod zojbaman, dxel bibig ree bén guin lojman, abiꞌ gunabdiidxaman loj reeman, rëbaman: ―¿Rliladxidi ya guial zileꞌ yayünan lëjt? Badxiꞌ reeman laan rëb reeman: ―Raliduladxan, Dad. ");
INSERT INTO zasNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dxel bagaal Jesús guiaaloj reeman, rëbaman: ―Gac ziꞌc rliladxidi. ");
INSERT INTO zasNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Abiꞌ bayajc guiaaloj reeman, dxel rëb Jesús loj reeman: ―Ad bal chu loj guiëbidi guial bayajc guiaalojdi. ");
INSERT INTO zasNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Per naabzi baza reeman yagaj, guzuloj catieꞌch reeman diidx guidib niz yagaj ni been Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Chi baza ree bén bayüjn Jesús guiaaloj, dxel bidxinnë ree bejn tijb bengop, yuꞌ xindxab luxdooman. ");
INSERT INTO zasNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Abiꞌ guloxzi babëë Jesús xindxab guin luxdoo bengop guin, laa guzuloj gajc caneeman. Abiꞌ dád badxaloj ree bejn, rëb reeman: ―Ad goct waguiaa ree lasaꞌ milagr guie niz Israel. ");
INSERT INTO zasNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Per ree bénfarisew rëb reeman: ―Bén guin rabëë xindxab luxdoo ree bejn por xguialrniabee gajc xindxab rniabee ree xindxab. ");
INSERT INTO zasNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Wej Jesús gra ree ciuda në ree guiedx ni rigaꞌ niz yagaj, abiꞌ beegaj lod rejman ruman lën ree yadoo persi rulüüman bejn ree xtiidx Dios, rëbaman loj reeman xhienaag rniabee Dios, rayüjn tëëman graloj guialrdoob në graloj guialguijdx ni rajc ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Chi baguiaa Jesús benzien guin ree, bayaman laa reeman, guial dád naya rigaꞌ reeman, rigaꞌ reeman ziꞌc xiil ad ryaꞌpt. ");
INSERT INTO zasNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Dxel rëbaman loj ree xbejnman: ―Walican zien bejn rën gucaagdiajg xtiidx Dios, per ad zient bén gulüü laa reeman yuꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Zeel gol gunab loj Dios din guixhiaalaman mazri ree bén gulüü laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Gurejdx Jesús chiptioꞌp ree xbejnman, abiꞌ badëëman guialrniabee loj reeman din yabëë reeman xindxab luxdoo ree bejn din yayüjn tëë reeman bejn ree graloj guialrdoob në graloj guialguijdx. ");
INSERT INTO zasNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Bén guie ree na̱j guidxiptioꞌp ree xi apóstoles Jesús: Simón bén gulëëlajman Bëd, con bijchaman Andrejs, në Jacob con Waj, bén na̱j ree xiꞌn Zebedeo. ");
INSERT INTO zasNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Në Felip, Tol, Tumajs con Matew bén baquijx impuest, nëtëë Jacob xiꞌn Alfeo con Lebeo bén la gajc Tadeo ");
INSERT INTO zasNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","në Simón bén biꞌch loj ree bén Cananistas con Judas Iscariote bén yayü Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Chi guxhaal Jesús guidxiptioꞌp ree xbejnman, rëbaman loj reeman: ―Ad chedi niz lod zojb ree bén ad najt bén Israel, niꞌqui ree guiedx rigaꞌ niz Samaria, ");
INSERT INTO zasNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","gol chejli niz lod zojb ree bén Israel bén ad zinalt ree xnejz Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Gol güjdx loj reeman guial ma zëëd gajxh xguialrniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Gol bayüjn bénragxuu ree, gol basban bén ma güjt ree, gol bayüjn bén rajc ree guialguijdx la lepra, gol babëë tëë xindxab luxdoo ree bejn. Ziꞌcgajc cwaꞌ lagajdi guialrniabee, ziangajc yayüjndi bejn lagajzi. ");
INSERT INTO zasNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Ad chinëdi or, niꞌqui plajt, niꞌqui cobr, ");
INSERT INTO zasNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","niꞌqui guijxh. Ad bal chinë stib nejz xabidi, niꞌqui stib nejz xgurëchidi, niꞌqui yagrliadxidi, din bén rüjn dxiin rayal gudëëd ree bejn ni gawaman. ");
INSERT INTO zasNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Chi guidxindi tijb guiedx o tijb ciuda, gol guleꞌc ruson chu bén na̱j benzaꞌc yayaꞌndi lidx, yagaj gol bayaꞌn xt chi yazadi luguiedx guin. ");
INSERT INTO zasNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Abiꞌ chi chuꞌdi lënü guin, gol güjdx loj ree bén zojb yagaj: “Yabeꞌcdxe Dios luxdoodi.” ");
INSERT INTO zasNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Bal rayal reeman guialnazaꞌc guin, zayaꞌnan con laa reeman guiáad bal id rayal reeman laan zayejcan con lëjt. ");
INSERT INTO zasNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Guiáad bal yuꞌ guiedx o yu ya lod ad racaꞌt reeman lëjt o bal id rën reeman gucaagdiajg reeman ni guiëbidi, gol baza yagaj, gol gudxijp guxyuj guiaꞌdi ziꞌc tijb sen guial ad bazoobt reeman xtiidxidi. ");
INSERT INTO zasNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Naj rni lëjt guial dxej ni yadëëd ree bejn cwent loj Dios, mazri casti naroob yayal reeman guial loj ree bén Sodoma në Gomorra. ");
INSERT INTO zasNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Rëb tëë Jesús loj ree xbejnman: ―Gol bacaagdiajg ni rnin, naj rxhial lëjt ziꞌc ree xiil loj ree cuyojt. Zeel gol gojc nasin ziꞌc bëël, gol gojc tëë nadoo ziꞌc palom. ");
INSERT INTO zasNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Gol gojp cudad din zayü ree bejn lëjt loj ree guxtis, zaguijn reeman lëjt lën ree yadoo. ");
INSERT INTO zasNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Abiꞌ xt chinë reeman lëjt loj ree gobernador në loj ree rey guial rliladxidi naj, zian güdi da diidxan loj reeman në loj ree bén ad zinalt xnejz Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Per chi chinë reeman lëjt loj guxtis, ad chuꞌdi xgab xhie guinieedi xhie tëë naag guinieedan, din chi guidxin hor guinieedi, Dios yazaladx lëjt diidx ni guinieedi. ");
INSERT INTO zasNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Din ad lëjttan guiniee, xSprijt xDadidi Diosan guiniee por lëjt. ");
INSERT INTO zasNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Zadxin dxej yayü ree bejn laagajc bijch reeman par guiët reeman. Guiáad ree dad yayü laagajc xiꞌn reeman, abiꞌ ree bejn zadxeꞌch xdad reeman në xniaa reeman abiꞌ yayü reeman laa reeman par guiët reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Gra bénguidxliuj guidxeꞌch lëjt guial najdi da bejnan, per bén sudxiꞌch loj guial rliladxaman naj xt dxej chigra guibanman, laaman yayal xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Chi sunal reeman lëjt tijb luguiedx par güün reeman lëjt xhienin, gol chej stijb guiedx, din naj rni lojdi, ad warat xguiedx Israel chedi chi guiꞌt Bén guxhaal Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Tijb bejn ad mast lasajc loj xmextraman, niꞌqui tijb mojs ad mast lasajquix loj xpatronx. ");
INSERT INTO zasNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Bén cusiid rayal xhienladxaman chi ma rajcaman ziꞌc rajc xmextraman guiáad tijb mojs rayal xhienladxix chi ma najx ziꞌc xpatronx. Nacli naj rniabeen lojdi, gulëëlaj ree bejn naj Beelzebú, diidxgui lëjt najdi da bejnan. ");
INSERT INTO zasNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Ad guidxebidi bejn ree, din achet ni ralan yuꞌ ni ad zaguient, niꞌqui tijb ni naguieꞌch ad yuꞌt ni ad zagbeet bejn. ");
INSERT INTO zasNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ni canin lëjt naguieꞌch, gol güjdxan loj ree bejn, guiáad ni canin lëjt ralan, gol güjdxan loj gra ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ad rdxebidi bén rën ree gugüjt lëjt. Din zileꞌ gugüjt reeman xcuerpidi, per xsprijtidi ad zileꞌt gugüjt reeman laan. Gol bidxebli Dios din laaman zileꞌ gunijt xcuerpidi abiꞌ guixhiaalaman xsprijtidi gabijl. ");
INSERT INTO zasNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Lëjt ragbee guial biguijndoo ree ad lasajct reeb wayëjx, per niꞌqui tijb reeb ad zëjtt sin xpermis xDadidi Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Guiáad lëjt xt guidxguijquidi graczan nayab loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Zeel ad rdxebidi din mazri lasajquidi guial loj zien daꞌt ree biguijndoo. ");
INSERT INTO zasNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Bén guiëb niz loj ree bejn guial da bejnanan, ziangajc naj guië loj da Dadan Dios bén yuꞌ xanyabaa guial da bejnanan. ");
INSERT INTO zasNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Per bén guiëb niz loj ree bejn guial ad da bejntanan, ziangajc guië loj da Dadan Dios bén yuꞌ xanyabaa guial ad da bejntanan. ");
INSERT INTO zasNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Rëb tëë Jesús: ―Ad zialtan par yabecdxen luxdoo bejn, zialan din guial chililadx reeman naj chuꞌ wadijl. ");
INSERT INTO zasNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Din guial chililadx bejn naj, zadxeꞌch xinguiaaw xdadix, guiáad biingunaa zadxeꞌch xniaam, abiꞌ biinwalidx zadxeꞌch xnasuegrim. ");
INSERT INTO zasNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Abiꞌ laagajc bén zojb ree lënülidxidi guidxeꞌch lëjt. ");
INSERT INTO zasNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Bén rën xdad o xniaa mazczi guial lon, ad zajct gacaman da bejnan. Ziangajc bén rën xiꞌngaan o xiꞌndxaꞌp mazczi guial lon, ad zajct gacaman da bejnan. ");
INSERT INTO zasNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Bén rën guidnal naj, abiꞌ ad rëntaman sagdiajman por naj, ad zileꞌt gacaman da bejnan. ");
INSERT INTO zasNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Bén rniajchiꞌ guialnaban rajpaman loj guidxliuj guie, zadxin dxej gunijtaman laan, per bén guiët por naj, zajpaman guialnaban tiblayaa con Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Bén ridxgaꞌ lëjt, najn ridxgaꞌman, guiáad bén ridxgaꞌ naj, bén guxhaal najn ridxgaꞌman. ");
INSERT INTO zasNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Bén ridxgaꞌ tijb bén rudëë xtiidx Dios loj ree bejn, guial zëëdaman por Dios, zacaꞌman lasaꞌ ni rayal tiaꞌ bén guin loj Dios. Ziangajc bén ridxgaꞌ tijb bén naban ziꞌc rën Dios, zacaꞌman lasaꞌ ni rayal tiaꞌ bén guin loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Abiꞌ chutëëz bén gudëëd majsi tib xijgzi nijs naalyuj loj bejn guial najman da bejnan, naj rni lojdi guial yuꞌ ni gudëëd Dios tiaꞌ reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Chi gulox rëb Jesús loj guidxiptioꞌp ree xbejnman con ree nin chiguieen reeman, dxel bazaman yagaj ziglüüman bejn ree xtiidx Dios loj ree guiedx rigaꞌ niz yagaj. ");
INSERT INTO zasNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Abiꞌ Waj, laꞌtgaj yuꞌman ladxguiib, cwaꞌman ruson gra ree ni cayüjn Jesús. Dxel guxhaal tioꞌp choon ree xbejnman, ");
INSERT INTO zasNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","bignabdiidx reeman lojman, rëb reeman: ―¿Lüj na̱j Cristo ya bén na̱j guiꞌt, o yalëjzan ben ren ya? ");
INSERT INTO zasNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Dxel rëb Jesús loj reeman: ―Gol chej gol güjdx loj Waj ni cuguiaadi në ni cucaagdiajguidi. ");
INSERT INTO zasNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Gol güjdx lojman guial ma ruguiaa ree bénlutiaꞌp, ma rajc rza ree bencoj, ma bayajc tëë ree bén rajc guialguijdx la lepra, ma riguiejn ree bén nacwaꞌt guiáad ree bengüt ma baban reeman, abiꞌ ree bénprob ma caguiejn reeman xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Xiquilbaa ree bén ad zucwëëzt chililadx naj. ");
INSERT INTO zasNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Chi baza ree bén guxhaal Waj, dxel guzuloj Jesús caneeman loj ree bejn xcwent Waj, rëbaman: ―¿Chu naladxidi na̱j bén biquiaadi loj yujbidx? ¿Naladxidi ya najman ziꞌc tijb biqui ni runiib bi? ");
INSERT INTO zasNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿O xhienaag na̱j bén biquiaadi? ¿Najman tijb bén najcw lajd zagdxe ya? Lëjt ragbee guial bén rajcw ree lajd zagdxe lën palas zojb reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Chuza biquiaadi? ¿Tijb bén rudëë xtiidx Dios loj ree bejn ya? Per naj rni lojdi guial biquiaadi tijb bén mazri zojbloj guial loj bén rudëëd xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Wajn din laaman naj ben ruzaꞌt loj xtiidx Dios lod rëb: Naj rxhial tijb bén ned lojl, ben güünchaaw xnejzil. ");
INSERT INTO zasNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Naj rni lëjt, loj graczi ree bénguidxliuj, ad wayut bén mazri zojbloj guial loj Waj. Per majsi zian, bén ad zojblojt loj xguialrniabee Dios, laaman mazri zojbloj guial loj Waj. ");
INSERT INTO zasNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Diizd chi biꞌt Waj xt yan, zien bejn rüjn daꞌt naguiejn chuꞌ lod rniabee Dios. Abiꞌ ree bén rüjn daꞌt naguiejn laa reeman chuꞌ lod rniabeeman. ");
INSERT INTO zasNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Diizd ley badëë Dios loj Moisejs con loj ree bén badëë xtiidx Dios loj ree bejn, xt Waj, laa reeman gunee xcwent xguialrniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Abiꞌ bal chililadxidi ni ganin lëjt, naj rni guial Wajn na̱j Elías bén badëë xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Bén rën ree gucaagdiajg, gol bacaagdiajg. ");
INSERT INTO zasNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Xhienaag ganin lëjt na̱j ree bén rigaꞌ loj guidxliuj guie yan? Laa reeman na̱j ziꞌc ree xindoo rguijt niz galay luguiedx, abiꞌ rbixdiaj reex rëb loj lasaꞌ reex: ");
INSERT INTO zasNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Bacwejdxan bidxa, per ad bayaꞌtidi, badoolan ni naya ree per ad biintidi.” ");
INSERT INTO zasNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Din biꞌt Waj bén baroobnijs bejn ree, ad rawtaman ad rëꞌ tëëtaman vin, abiꞌ rëbidi xindxab yuꞌ luxdooman. ");
INSERT INTO zasNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Yan, biꞌt Bén guxhaal Dios, rawaman rëꞌ tëëman vin abiꞌ rëbidi nalaman ruladx tëëman guiëꞌman, ruchajg tëëman béndol ree con ree bén ruquijx impuest. Per ree bén ma caꞌ xguialrniabee Dios, por laa reeman rguien guial gra ni rüjn Dios na̱j zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Dxel guzuloj Jesús cadilëman bén zojb ree guiedx lod beenman mazri zien ree milagr. Din bén guin ree ad bayüjnt reeman xgab por xtol reeman, abiꞌ rëbaman loj reeman: ");
INSERT INTO zasNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Probza lëjt bén Corazín! ¡Probza lëjt bén Betsaida! Din bal luguiedx Tiro në luguiedx Sidón niajc ree milagr ni goc ladxidi, diizd gocli nayüjn reeman xgab por xtol reeman, niajcw reeman lajd yaꞌs nuroob tëë cobdëj guijc reeman ziꞌc tijb sen guial ma bayüjn reeman xgab por xtol reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Per rnin lëjt guial dxej yadëëd ree bejn cwent loj Dios, mazri casti naroob yayalidi guial loj ree bén Tiro në ree bén Sidón. ");
INSERT INTO zasNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Guiáad lëjt bén Capernaum, ad naladxidi yayalidi xanyabaa, lëjt yayal gabijl. Din bal luguiedx Sodoma niajc ree milagr goc ladxidi, xt yan sta yuꞌ guiedx guin. ");
INSERT INTO zasNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Per rnin lojdi guial dxej yadëëd ree bejn cwent loj Dios, mazri casti naroob yayalidi guial loj ree bén Sodoma. ");
INSERT INTO zasNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Lën ree dxejzii rëb Jesús: ―Dad, ruzatan lüj zagdxe, din ni baquieꞌchil loj ree bén rajc në loj ree bén rigniaꞌ, laan ma balüül loj ree bén ad rajct. ");
INSERT INTO zasNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Zian gojc Dad, din zian guyënl. ");
INSERT INTO zasNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Da Dadan banee gra lon. Abiꞌ achut nünbee Jesucrist xiꞌn Dios, tijbzi Dios, achu tëët nünbee Dios, tijbzi Jesucrist xiꞌnman, con ree bén rënman güünbee Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Gradi, bén ma badxag rüjn xhienin din yayaꞌndi zagdxe loj Dios, ma badxag tëëdi nüü xtolidi. Gol guda lon, naj gune guialraziiladx lojdi. ");
INSERT INTO zasNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Gol bazoob da diidxan, gol basiid tëë gaquidi benzaꞌc në bén chaawladx ziꞌc naj, din yabedxe luxdoodi loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Din ad nawëëgt guial guzoobidi da diidxan, ad nawëëg tëët guial güündi ziꞌc rënan. ");
INSERT INTO zasNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tijb dxej raziiladx ree bejn, chi cadëd Jesús con ree xbejnman loj tijb guiniaa lod yuꞌ trigo, dxel calaan ree xbejnman abiꞌ guzuloj caguiꞌch reeman trigo persi cayaw reeman laan. ");
INSERT INTO zasNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Abiꞌ chi baguiaa ree bénfarisew ni cayüjn reeman, rëb reeman loj Jesús: ―Baguiaa ree xbejnl nial cayüjn reeman ni ad rayalt güün reeman dxej raziiladx ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Dxel rëb Jesús loj reeman: ―¿Gadidi gool loj xtiidx Dios ya ni been Davi chi gulaanman con ree xcompniaraman? ");
INSERT INTO zasNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Guyu Davi lën xyadoo Dios abiꞌ cwaꞌman guiadxtil ma nagleꞌ ree gudawaman con ree xcompniaraman, ni ad rayalt niajw reeman, bixhiosi ree rayal gaw laa reen. ");
INSERT INTO zasNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿O gadidi gool loj xley Moisejs ya guial achet dol rüjn ree bixhioz chi rüjn reeman dxiin lën yadoo majsi ad raziiladxt reeman dxej raziiladx ree bejn? ");
INSERT INTO zasNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Abiꞌ naj rni lëjt guial naj, bén zaꞌnë lëjt mazri lasajcan guial loj yadoo. ");
INSERT INTO zasNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bal rigniaꞌdi xhie rën guiëb loj xtiidx Dios lod rëb: “Ni rënan na̱j guial yaya lasaꞌdi, ad guial guneetidi gon lon.” Bal rigniaꞌdi diidx guin ree ad zudxiibtidi guijc ree bén ad rajpt dol. ");
INSERT INTO zasNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Abiꞌ Bén guxhaal Dios rajpaman guialrniabee dxej raziiladx ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Chi gudëd gojc zian, dxel baza Jesús abiꞌ guyuman lën tijb yadoo na̱j niz yagaj. ");
INSERT INTO zasNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Lën yadoo guin zaꞌ tijb bén nëjt tiblad yaa. Abiꞌ guial ree bénfarisew raguiil reeman mod xhie gudxiib reeman guijc Jesús, dxel gunabdiidx reeman lojman, rëb reeman: ―¿Zileꞌ yayüjn bejn tijb bénragxuu dxej raziiladx bejn ya? ");
INSERT INTO zasNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Badxiꞌ Jesúsan rëbaman: ―Bal tijb lëjt rajp tijb xiil, abiꞌ yabib lën balaꞌ dxej raziiladx bejn. ¿Nid zabëëdi laab dxej guin ya? ");
INSERT INTO zasNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Wen id mazri lasajc tijb bejn guial loj tijb xiil ya? Zeel achet güünan zajc güün bejn ni na̱j zagdxe dxej raziiladx bejn. ");
INSERT INTO zasNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Dxel rëb Jesús loj bénragxuu yaa guin: ―Basli yaal. Abiꞌ basli yaa bén guin, loj hor ziigajc bayajc yaaman ziꞌc na̱j stibladan. ");
INSERT INTO zasNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Per chi barii ree bénfarisew guin lën yadoo guin, guzuloj cayü reeman diidx xhienaag güün reeman din gugüjt reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Chi gogbee Jesús zian, laa zia gajcaman, abiꞌ zien ree bejn binal laaman. Dxel bayüjnman gra ree bénragxuu, ");
INSERT INTO zasNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","abiꞌ gunabeeman laa reeman chitëë guitieꞌch reeman diidx chu bayüjn laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Zian guzojb xtiidx Isaías, bén badëë xtiidx Dios loj ree bejn, chi rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Gol baguiaa, bén guie na̱j bén gulen din güünman naj sirv, laaman na̱j bén rën daꞌtan, rabaanëꞌ tëën laaman. Gudë da Sprijtan lojman abiꞌ guiëbaman loj ree bénguidxliuj xhienaag na̱j da guialrniabeen. ");
INSERT INTO zasNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Achut tilnëman, ad zabixdiaj tëëtaman achut tëët guien chaꞌman niz lunejz. ");
INSERT INTO zasNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ad zudëëdtaman casti bén ad zaꞌdxiꞌcht ree loj da nejzan, në ree bén ad ridxgaꞌzaꞌct naj, xt chi ma beenman gan gac guialguxtis. ");
INSERT INTO zasNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Abiꞌ xt ree bén ad najt bén Israel cwëz reeman yabëëman laa reeman loj dol. ");
INSERT INTO zasNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Binë ree bejn tijb xinguiaaw lod zaꞌ Jesús, yuꞌ xindxab luxdoox, natiaꞌp lojx naj tëëx gop. Dxel bayüjn Jesús laax abiꞌ guzuloj rnieex ruguiaa tëëx. ");
INSERT INTO zasNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Graczi ree bejn dád badxaloj reeman, abiꞌ rëb reeman: ―¿Id bén guinan zëëd loj xdiaa Davi ya? ");
INSERT INTO zasNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Chi biguiejn ree bénfarisew zian, dxel rëb reeman: ―Bén guin rabëë xindxab luxdoo ree bejn por xguialrniabee Beelzebú xin rniabee ree xindxab. ");
INSERT INTO zasNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Per Jesús gogbee gajcaman xgab cayüjn reeman, abiꞌ rëbaman: ―Gra nacion o ciuda bal id nadxag rigaꞌ bejn, rliaꞌ lasaꞌ reeman, ziangajc tijb famil bal id nadxag rigaꞌ reeman, rliaꞌ lasaꞌ reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ziangajc bal xindxab su contr laagajquix, nayob nitix. ");
INSERT INTO zasNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Lëjt na guial naj rabë xindxab luxdoo ree bejn por xguialrniabee Beelzebú, per bal zianan, ¿chuza rudëë guialrniabee loj xbejndi din yabëë reeman xindxab? Zeel laagajc reeman rulüü guial ad laat rnieedi. ");
INSERT INTO zasNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Per naj, bal por xSprijt Dios rabën xindxab luxdoo ree bejn, rën guiëban guial ma zaꞌnë xguialrniabee Dios lëjt. ");
INSERT INTO zasNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Din ¿xhieza naag chuꞌ tijb bejn lidx tijb bén gojl par cwanman ni rajpaman, bal id zaxhiixgajman laaman? Zian güünman din chileꞌ cwanman ni rajpaman. ");
INSERT INTO zasNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Bén ad zaꞌt con naj, zaꞌman contr naj. Guiáad bén ad rutoꞌpt bejn par naj, rtieꞌchaman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Zeel rnin lëjt: Züjn Dios perdon xhietëëz dolan, në ree diidxguijdx ni rnieetzi ree bejn, per ad züjntaman perdon bén rnieeguijdx ree xSprijt Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Chutëëz bén guinieeguijdx Bén guxhaal Dios, zajcaman perdon, per bén guinieeguijdx xSprijt Dios ad zajctaman perdon yan, niꞌqui chi yaguialan. ");
INSERT INTO zasNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Lëjt ragbee, bal tijb bejn ruzuj tijb yag zagdxe, rtia ni zagdxe lojn, per bal guzujman tijb yag guijdx, rtia ni guijdx lojn. Din tijb gaj yag nünbee bejnan por ni rtia lojn. ");
INSERT INTO zasNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Xiꞌn xindxab! ¿Xoza guinieedi diidx zagdxe ree awa benmal lëjt? Din ni yuꞌ luxdoo bejn laan rnieeman. ");
INSERT INTO zasNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Benzaꞌc rnieeman diidxzaꞌc, din laan yuꞌ luxdooman. Guiáad benmal rnieeman diidxmal din laan yuꞌ luxdooman. ");
INSERT INTO zasNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Per naj rni lëjt guial dxej ni güün xguialguxtis Dios, gra ree bejn yadëëd cwent lojman por gra ree diidxguijdx ni rniee reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Din por xtiidx gajc bejn guiguien bal rayalaman xcasti Dios o ad rayaltaman laan ya. ");
INSERT INTO zasNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yuꞌ ree bénfarisew con ree mextr ni rajc ley, rëb loj Jesús: ―Mextr, rayënan yaguiaan güünl tijb milagr. ");
INSERT INTO zasNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Badxiꞌ Jesúsan rëbaman: ―Lëjt benmal, bén ad rüjnt ni rën Dios abiꞌ rëndi günan tijb milagr. Per achetri guguiaadi, tijbzi ziꞌc guzac Jonás bén badëë xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Din ziꞌc guyu Jonás lën bëjl naroob choon dxej choon guiaal, ziangajc Bén guxhaal Dios, choon dxej choon guiaal chuꞌman lën baa. ");
INSERT INTO zasNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Abiꞌ chi yadëëd ree bejn cwent loj Dios, bén guban ree Nínive zaban reeman abiꞌ guiëb reeman guial ree bén rigaꞌ yan, yayal reeman xcasti Dios. Din bén Nínive ree bayejc reeman loj Dios chi bacaagdiajg reeman xtiidx Dios ni gunee Jonás. Abiꞌ yan, bén zaꞌnë lëjt mazri lasajcaman guial loj Jonás. ");
INSERT INTO zasNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ziangajc bén goc reina niz sur, zabanman chi yadëëd ree bejn cwent loj Dios, dxel guiëbaman guial ree bén rigaꞌ yan, yayal reeman xcasti Dios. Din laaman dád zijt guzaman persi bicaagdiajgaman xguialrajc rey Salomón. Abiꞌ yan, bén zaꞌnë lëjt mazri lasajcan guial loj Salomón. ");
INSERT INTO zasNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Chi rarii tijb xindxab luxdoo tijb bejn, abiꞌ rzax niz loj yujbidx rguiilix lod yaziiladxix. Abiꞌ chi ad rdxejlt lod yaziiladxix, dxel rüjnx xgab naladxix: ");
INSERT INTO zasNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Zagdxeli yayeꞌcan lod guzaan.” Abiꞌ chi rayejquix ruguiaax luxdoo bén guin najn ziꞌc tijb lënü lod achut zojb, lod bilioob lod najcchaaw tëë. ");
INSERT INTO zasNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Dxel ricaꞌx za gajdx xindxab na̱j ree mazri xinmal guial lojx. Abiꞌ ru gra reex luxdoo bén guin. Dxel mazri benmal gacaman guial loj ni gocaman yaloj. Ziangajc sac ree benmal rigaꞌ loj guidxliuj yan. ");
INSERT INTO zasNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sta canee Jesús loj ree bejn, bidxin xniaaman con ree bijchaman, zaꞌ reeman luleꞌ, rën reeman guinieenë reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Abiꞌ yuꞌ tijb bén rëb lojman: ―Laa xniaal con ree bijchil zaꞌ luleꞌ guin, rën reeman guinieenë reeman lüj. ");
INSERT INTO zasNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Per Jesús badxiꞌman xtiidx bén guin rëbaman: ―¿Chu na̱j da nan chu tëë ree nin na̱j da bichan? ");
INSERT INTO zasNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Dxel con yaaman balüü ree xbejnman rëbaman: ―Bén guie ree na̱j da nan në ree da bichan. ");
INSERT INTO zasNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Din chutëëz bén rüjn ziꞌc rën da Dadan bén yuꞌ xanyabaa, laaman na̱j da bichan, da zanan, në da nan. ");
INSERT INTO zasNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Dxejzii brii Jesús yu lod zojbaman, bisobaman roꞌ nijs Galilea. ");
INSERT INTO zasNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Abiꞌ guial dád zien ree bejn bidoꞌp yagaj, beenan naguiejn wëꞌp Jesús loj tijb barcw dxel gurejman lojn, guiáad ree bén guin zaꞌ reeman roꞌ nijs guin. ");
INSERT INTO zasNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Zien ree ni guzuloj culüüman laa reeman, per con ganax ziꞌc cwent ree, rëbaman loj reeman: ―Tijb bejn, briiman bigtieꞌchaman bin loj xguiniaaman. ");
INSERT INTO zasNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Chi catieꞌchaman bin guin, taꞌnan biajb loj nejz, abiꞌ biꞌt ree biguijn gudaw reeb laan. ");
INSERT INTO zasNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Staꞌnan biajb loj ree guiaj lod ad rigaꞌt zien yuj, cari gulejnan guial ad zient yuj rigaꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Per chi brii gubijdx, bazeꞌcan laan, abiꞌ guial ad yuꞌt liujn gubidxan. ");
INSERT INTO zasNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Dxel staꞌnan biajb loj ree yaquiëjch, chi guniꞌs ree yaquiëjch guin banidloj reen laan. ");
INSERT INTO zasNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Per staꞌnan biajb loj yuj zaꞌc, abiꞌ dád gojcan. Yuꞌn cwa tibgayuu bin loj, yuꞌn cwa gayojn yuꞌ tëën cwa gajlbichii. ");
INSERT INTO zasNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Bén rën gucaagdiajg, gol bacaagdiajg. ");
INSERT INTO zasNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Dxel gubig ree xbejn Jesús lojman rëb reeman: ―¿Chexquiza zeel rulüül bejn ree con ganax ziꞌc cwent ree? ");
INSERT INTO zasNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Badxiꞌ Jesús laan rëbaman: ―Lëjt, Dios ma basaꞌn lëjt din chigniaꞌdi xhienaag na̱j xguialrniabeeman, per bén guin ree ad basaꞌnt Dios laa reeman chigniaꞌ reeman laan. ");
INSERT INTO zasNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Din Bén ma rigniaꞌ, gusnuu chigniaꞌman mazri, abiꞌ zigniaꞌ daꞌtaman. Per bén ad rigniaꞌzaꞌct ad rüjn tëëtaman naguiejn chigniaꞌman mazri, xt taꞌn ni rigniaꞌman zayanladxaman. ");
INSERT INTO zasNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Zeel rnienëꞌn laa reeman con ganaxzi ziꞌc cwent ree. Din majsi rani loj reeman per rüjn reeman ziꞌc bén ad ruguiaat, abiꞌ majsi riguiejn reeman per rüjn reeman ziꞌc bén ad riguiejnt, bén ad rigniaꞌ tëët. ");
INSERT INTO zasNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Zian rzojb xtiidx Isaías, bén badëë xtiidx Dios loj ree bejn, chi rëbaman: Majsi riguiejn reeman, per achetczi chigniaꞌ reeman. Abiꞌ majsi rani loj reeman, per ad ruguiaat reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Din ma been luxdoo reeman gojl, nayaaw guidiajg reeman, nayaaw tëë guiaaloj reeman. Chitëë guguiaa reeman, guiguiejn reeman, chigniaꞌ tëë reeman. Din ad rënt reeman guiꞌt reeman lon din günan laa reeman perdon. ");
INSERT INTO zasNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Per xiquilbaadi cuguiaadi caguiejn tëëdi. ");
INSERT INTO zasNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Din naj rni lojdi guial dád zien ree bén badëë xtiidx Dios loj ree bejn, në ree bén guban ziꞌc rayal, guyën reeman nuguiaa reeman ni cuguiaadi per ad baguiaat reeman laan. Guyën reeman niguiejn reeman ni caguiejndi per ad biguiejnt reeman laan. ");
INSERT INTO zasNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Yan gol bacaagdiajg xhie rën guiëb ni rnin lojdi xcwent bén bigtieꞌch bin. ");
INSERT INTO zasNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bén riguiejn xtiidx Dios abiꞌ ad rigniaꞌtaman laan, laaman na̱j ziꞌc bin biajb loj nejz, guial laa riꞌt gajc xindxab rquiedix ni bacaagdiajgaman. ");
INSERT INTO zasNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Guiáad bin biajb loj ree guiaj na̱j ziꞌc bén riguiejn xtiidx Dios, abiꞌ dád nix ru luxdooman riguiejnman laan, ");
INSERT INTO zasNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","per guial najman ziꞌc cwaan ni ad yuꞌt xliuj, ad rzudxiꞌchtaman. Chi rzagdiajman o rdxeꞌch ree bejn laaman por xtiidx Dios, laa rusaꞌn gajcaman ni rliladxaman. ");
INSERT INTO zasNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Abiꞌ bin biajb loj ree yaquiëjch na̱j ziꞌc bén riguiejn xtiidx Dios, per guial mazri ruman xgab por ni yuꞌ loj guidxliuj guie, rusquiee guialnazaꞌc rigaꞌ loj guidxliuj guie laaman, abiꞌ zianzi rucwëëz rucaagdiajgaman xtiidx Dios achet sirv been ni bacaagdiajgaman. ");
INSERT INTO zasNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Per bin biajb loj yuj zaꞌc na̱j ziꞌc bén riguiejn xtiidx Dios abiꞌ rigniaꞌman laan rüjn tëëman ziꞌc rën Dios, ziꞌc ni cwa tibgayuu bin loj o ziꞌc ni cwa gayojn o ni cwa gajlbichii. ");
INSERT INTO zasNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Be Jesús stijb ni na̱j ziꞌc cwent loj reeman, rëbaman: ―Xguialrniabee Dios na̱j ziꞌc tijb bén badxeꞌ ganax bin zagdxe loj xguiniaa. ");
INSERT INTO zasNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Per laꞌtgaj nagaꞌyëjs gra reeman, bidxin bén rdxeꞌch laaman guxübinman guiꞌxhguijdx ree loj trigo guin dxel ziaman. ");
INSERT INTO zasNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Abiꞌ chi gulen trigo guin brii tëë dojn lojn në ree guiꞌxh guin ma yuꞌ lojn. ");
INSERT INTO zasNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Dxel bicojn ree xmojs bén naj xguiniaa laan laaman, rëb reeman: “Dad ¿nid ganax bin zagdxe badxeꞌ loj xguiniaal ya? yan, ¿banza guza guiꞌxh yuꞌ lojn?” ");
INSERT INTO zasNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Badxiꞌman laan rëbaman: “Wed tijb bén rdxeꞌch naj bidgadxeꞌ laan.” Dxel gunabdiix ree mojs guin lojman rëb reeman: “¿Xhie nal zudojxhan guiꞌxh guin ree ya?” ");
INSERT INTO zasNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Dxel rëbaman loj reeman: “Yajqui, chitëë guial gaxhidi guiꞌxh guin gaxhidi në trigo guin. ");
INSERT INTO zasNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Zagdxeli gol basaꞌnan din niꞌsnën trigo guin xt chi ma gojcan. Abiꞌ chi guidxin dxej yadoꞌp trigo guin guiën loj ree bén gutoꞌp laan din yalojxgaj guiꞌxh guin yatoꞌp reeman din guixhii reeman lënan zianz cheꞌcan. Dxelri yatoꞌp reeman trigo guin din cuꞌchaaw reeman laa reen lod ruchaaw reen.” ");
INSERT INTO zasNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Be Jesús stijb ni na̱j ziꞌc cwent loj reeman, rëbaman: ―Xguialrniabee Dios na̱j ziꞌc xhaj moxtajs, ni rudxeꞌ tijb bejn loj xguiniaaman. ");
INSERT INTO zasNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Abiꞌ bin guin na̱j mazri ni wit loj gra ree bin, per chi rniꞌsan laan rajc mazri ni naroob loj gra ree cwaan. Abiꞌ guial naroob daꞌt rajcan, xt rüjn xguixbitiaꞌs ree biguijn xidxan. ");
INSERT INTO zasNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Be tëë Jesús stijb ni na̱j ziꞌc cwent loj reeman, rëbaman: ―Xguialrniabee Dios na̱j ziꞌc levadur ni rugoꞌch tijb béngunaa choon midid harin, abiꞌ laan rusaaguij gra cob guin. ");
INSERT INTO zasNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Gra ree ni balüü Jesús bejn ree, balüüman laa reeman con ganax ree ni na̱j ziꞌc cwent, achet balüüman laa reeman con ni ad najt ree ziꞌc cwent. ");
INSERT INTO zasNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Zian gojc persi guzojb xtiidx bén badëë xtiidx Dios loj ree bejn, chi rëbaman: Con ganaxzi ni na̱j ree ziꞌc cwent gulün bejn ree, guiën loj reeman ni gad reeman gagbee diizd chi gocchaaw guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Chi ma bazaadiidxnë Jesús benzien guin ree, dxel bayuman lënü con ree xbejnman, abiꞌ gunabdiidx reeman lojman, rëb reeman: ―Basigniaꞌ dunujn xcwent guiꞌxhguijdx ni gulen loj guiniaa guin. ");
INSERT INTO zasNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Badxiꞌ Jesúsan rëbaman: ―Bén rudxeꞌ bin zagdxe guin na̱j Bén guxhaal Dios, ");
INSERT INTO zasNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","abiꞌ guiniaa guin na̱j guidxliuj. Guiáad bin zagdxe guin na̱j ree bén na̱j par loj xguialrniabee Dios. Abiꞌ ree guiꞌxh guin na̱j bén na̱j ree par xindxab. ");
INSERT INTO zasNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Guiáad bén rdxeꞌch, bén guxübin trigo guin na̱j xindxab. Abiꞌ guial radoꞌp guialnazaꞌc guin rën guiëb chi nit guidxliuj, guiáad ree bén yatoꞌp guialnazaꞌc guin na̱j ree xianjl Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Zian ziꞌc radoꞌp ree guiꞌxhguijdx guin par cheꞌc reen, zian gac chi nit guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Bén guxhaal Dios guixhiaal ree xianjlaman din yabëë reeman bén rayal ree yarii loj xguialrniabeeman, bén ruzaalguiiw bejn ree din güün reeman dol në gra ree bén cayüjn dol. ");
INSERT INTO zasNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Abiꞌ guzaal reeman laa reeman loj bajl lod goon reeman xt gaw lay reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Dxel bén naban ree ziꞌc rën Dios, guidiin reeman bachaꞌ loj xguialrniabee xDad reeman Dios, ziꞌc rdiin gubijdx bachaꞌ. Bén rën gucaagdiajg, gol bacaagdiajg. ");
INSERT INTO zasNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Xguialrniabee Dios na̱j ziꞌc tijb ni lasajc daꞌt, ni naguieꞌch loj tijb guidxliuj. Abiꞌ rdxejl tijb bejn laan zianz ruquieꞌchaman laan stijb, lod gulëëman laan. Abiꞌ dád rabaaman rutoꞌ gra ni rajpaman persi rsiiman guidxliuj guin. ");
INSERT INTO zasNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Rni tëën lëjt: Xguialrniabee Dios na̱j ziꞌc tijb bén rguiil perl zagdxe din siiman laan. ");
INSERT INTO zasNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Chi rdxejlaman tijb perl lasajc, rutoꞌ gra ni rajpaman abiꞌ rsiiman laan. ");
INSERT INTO zasNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Abiꞌ tëë xguialrniabee Dios na̱j ziꞌc tijb guijxh ni ruzaal reeman loj nijs abiꞌ rniaazan graloj bëjl. ");
INSERT INTO zasNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Dxel chi ma gudxa guijxh guin rabëë reeman laan roꞌ nijs guin, abiꞌ rbej reeman rabe reeman loj bëjl guin, dxel raguꞌ reeman be zagdxe lën dxüm guiáad be ad najt zagdxe rusëëb reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Zian gac dxej nit guidxliuj, guiꞌt ree xianjl Dios yabe reeman benmal loj ree benzaꞌc. ");
INSERT INTO zasNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Abiꞌ guzaal reeman benmal guin ree loj bajl lod goon reeman abiꞌ xt gaw lay reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Dxel gunabdiidx Jesús loj ree xbejnman, rëbaman: ―¿Rigniaꞌdi gra ni canin lëjt ya? Badxiꞌ reeman laan rëb reeman: ―Rayigniaꞌnan, Dad. ");
INSERT INTO zasNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Dxel rëb Jesús loj reeman: ―Gra ree mextr ni rajc ley, abiꞌ cusiid reeman xhienaag na̱j xguialrniabee Dios, laa reeman na̱j ziꞌc tijb bén rbe nicüb në ni yojx loj gra ni rajpaman. ");
INSERT INTO zasNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Chi gulox gunee Jesús loj reeman zian, zianz bazaman. ");
INSERT INTO zasNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Dxel badxin ladxaman, ni guzuloj culüüman bejn ree lën xyadoo reeman. Abiꞌ dád badxaloj ree bén guin, rëb reeman: ―¿Ban guin basiidaman gra ree ni rajcaman? ¿Chexquiza zeel rajc rüjnman milagr ree? ");
INSERT INTO zasNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Nid laaman na̱j xiꞌn carpinter ya, abiꞌ xniaaman na̱j Li, guiáad ree bijchaman na̱j Jacob, Xiëb, Simón, në Judas? ");
INSERT INTO zasNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Nid luguiedx guie zojb ree bizanman ya? ¿Banza guin basiidaman gra ree ni rajcaman? ");
INSERT INTO zasNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Abiꞌ ad bidxgaꞌt reeman Jesús. Per rëbaman loj reeman: ―Bantëëz guin rajp ree bejn respejt tijb bén rudëë xtiidx Dios loj ree bejn, per ladxaman achut rajp laaman respejt niꞌqui lidxaman. ");
INSERT INTO zasNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Abiꞌ ad zient milagr beenman yagaj guial ad bililadxt reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tiampzii Herodes bén canabee niz Galilea, biguiejnman ni cayüjn Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Abiꞌ rëbaman loj ree xbejnman: ―Waj bén baroobnijs bejn ree, laaman baban zatijb, zeel rajpaman guialrniabee rüjnman milagr ree. ");
INSERT INTO zasNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Rëb Herodes zian guial laaman gunabee biniaaz Waj, abiꞌ bixiiman con caden dxel badxeꞌ reeman laaman ladxguiib. Been Herodes guin zian por Herodías lacheel bijchaman bén la Felip, ");
INSERT INTO zasNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","guial rëb Waj guin loj Herodes: ―Ad laat guial zojbnël laagajc lacheel bijchil. ");
INSERT INTO zasNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Guyën Herodes nugüjtaman Waj, per bidxebaman xhie nüjn ree bejn laaman guial graczi reeman rëb Waj na̱j tijb bén rudëëd xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Per chi bazaꞌ Herodes ijz, brii xiꞌn Herodías bayaꞌm loj ree xbioozaman. Abiꞌ dád bayuladx Herodes ziꞌc bayaꞌm, ");
INSERT INTO zasNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","dxel rëb Herodes gudëëdaman xhietëëz ni guiniabim. ");
INSERT INTO zasNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Abiꞌ xniaam rëb lojm xhie guiniabim, dxel rëbim loj Herodes: ―Banee guijc Waj bén ruroobnijs bejn ree, baneen loj tijb pliajt. ");
INSERT INTO zasNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Dád guyunaya rey Herodes, per guial mal bayaꞌn reeman diidx niz loj gra ree xbioozaman, gunabeeman xsuldadaman gudëëd reeman ni gunabim. ");
INSERT INTO zasNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Dxel gunabeeman guitüꞌ reeman guijc Waj lën ladxguiib guin, ");
INSERT INTO zasNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","abiꞌ bidxinnë reeman laan loj tijb pliajt badëëd reeman laan lojm, dxel bayümin loj xniaam. ");
INSERT INTO zasNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Zianz bidxin ree xbejn Waj bacaꞌ reeman xcuerpaman persi biquieꞌch reeman laaman. Dxel bicojn reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Chi gogbee Jesús zian, guyuman loj tijb barcw zëman niz lod achutczi zojb din su laazaman. Chi gogbee ree bejn, dxel brii ladx reeman zë guiaꞌzi reeman lod guidxinman. ");
INSERT INTO zasNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Chi barii Jesús loj barcw guin baguiaaman bén guixiuj ree rigaꞌ yagaj, bayaman laa reeman abiꞌ bayüjnman bénragxuu zinë reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Chi ma gudxe, gubig ree xbejnman lojman rëb reeman: ―Ma gudxe yan, abiꞌ achut bejn zojb niz guie. Güjdx loj ree bén guin ma gojl yaguiaj reeman, din che reeman guiedx lod sii ni gaw reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Per badxiꞌ Jesúsan rëbaman: ―Ad rüjnt naguiejn yaguiaj reeman, lëjt gol badëë ni gaw reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Badxiꞌ reeman laan rëb reeman: ―Per gaayzi guiadxtil nacaꞌn con zatioꞌp bëjl. ");
INSERT INTO zasNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Dxel rëb Jesús loj reeman: ―Gol tanë reen guie. ");
INSERT INTO zasNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Dxel gunabeeman gurej gra ree bén guin loj guixyaꞌ. Abiꞌ cwaꞌman guigaay guiadxtil guin con grop bëjl guin. Dxel gules lojman xanyabaa badëëman quixtëë loj Dios, abiꞌ gulaꞌman guiadxtil guin badëëman laan loj ree xbejnman persi gudiꞌs reeman laan loj gra ree bén guin. ");
INSERT INTO zasNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Gra reeman gudaw xt bigdxinladx reeman, abiꞌ staczi bacha reeman za chiptioꞌp dxüm ni bayaꞌn. ");
INSERT INTO zasNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bén gudaw guin ree na̱j reeman cost gaay mil xinguiaaw garenqui ree béngunaa con ree xindoo. ");
INSERT INTO zasNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Dxel gunabee Jesús xbejnman guyu reeman loj barcw din ned reeman tëd gaj reeman stiblad roꞌ nijs guin, laꞌtgaj cuzaadiidx nëman benzien guin ree. ");
INSERT INTO zasNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Chi ma gulox bazaadiidx nëman laa reeman, dxel zë xtijbaman guijc tijb guiaꞌ din cwedx guiniabaman Dios. Chi gure guiaal xtijbzaman zaꞌ guijc guiaꞌ guin. ");
INSERT INTO zasNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Guiáad barcw guin zijt ma zën loj nijs, dád rliaroꞌ xtüjp nijs guin laan guial rliaj bi niz loj barcw guin. ");
INSERT INTO zasNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Chi ma cayreguiaal, zibig Jesús loj ree xbejnman rzaman loj nijs guin. ");
INSERT INTO zasNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Dxel baguiaa ree xbejnman laaman rzaman loj nijs guin, dád bidxeb reeman abiꞌ gurixdiaj reeman rëb reeman: ―¡Tijb anman! ");
INSERT INTO zasNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Per guneenë Jesús laa reeman rëbaman: ―¡Gol baguꞌ luxdoodi! ¡Najn, ad rdxebidi! ");
INSERT INTO zasNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Badxiꞌ Bëdan rëbaman: ―Dad, bal lüjn, gunabee gazan loj nijs guin guialan lojl. ");
INSERT INTO zasNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Abiꞌ rëb Jesús lojman: ―Guda. Dxel baguiajt Bëd loj barcw guin, rzaman loj nijs guin zëman loj Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Per chi baguiaaman bidoxhan cabiꞌ dxel bidxebaman, abiꞌ guial guzuloj cazëëbaman xan nijs guin guridxaꞌman rëbaman: ―¡Gognë naj, Dad! ");
INSERT INTO zasNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Loj hor ziigajc basli yaa Jesús gunaazaman yaa Bëd, rëbaman lojman: ―¿Chexc zeel ad rliladxzaꞌctil, chexc zeel yuꞌ nawëëguil? ");
INSERT INTO zasNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Abiꞌ chi bayëꞌp reeman loj barcw guin, laa bacwëëz gajc bi guin. ");
INSERT INTO zasNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Guiáad ree bén yuꞌ loj barcw guin bazuxib reeman loj Jesús, rëb reeman: ―Diidxliczi lüjn na̱j xiꞌn Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Chi gudëd reeman loj nijs guin dxel bidxin reeman xyuj ree bén Genesaret. ");
INSERT INTO zasNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Abiꞌ ree bén niz ni bayünbee reeman Jesús, abiꞌ guidibczi niz yagaj gutieꞌch reeman diidx guial zaꞌman ni. Dxel binë ree bejn bénragxuu ree lojman, ");
INSERT INTO zasNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","guzajc reeman liaadx lojman din tiëbaman gugaal reeman majsi guiaꞌzi xabaman. Abiꞌ gra ree bén bagaal xabaman bayajc. ");
INSERT INTO zasNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Bénfarisew ree con ree mextr rajc ley, bén za ree Jerusalén, gubig reeman loj Jesús abiꞌ gunabdiidx reeman lojman, rëb reeman ");
INSERT INTO zasNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Chexc zeel ad zinalt ree xbejnl costumbr ni basaꞌn dux béngulal ree? ¿Chexc zeel ad zinalt reeman costumbr ziꞌc rayal gunaa reeman chi gad reeman gaw? ");
INSERT INTO zasNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Dxel rëb Jesús loj reeman: ―Laadx lëjt, ¿chexc zeel rüjndi xtiidx Dios tiblad persi zinal xcostumbridi? ");
INSERT INTO zasNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Din Dios rëb: “Gojp respejt xDadil con xniaal”, abiꞌ “Bén rniee diidxguijdx loj xdadaman o xniaaman ya, rayal guiëtaman.” ");
INSERT INTO zasNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Per lëjt rëb zileꞌ guiëb bejn loj xdadaman o xniaaman: “Ad zileꞌt günan lüj yudar, din gra ni raꞌpan na̱j par Dios.” ");
INSERT INTO zasNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Rëbidi guial bén guiniee zian, ad zileꞌt güün yudar xdadaman con xniaaman, abiꞌ zian rbëëladxidi xtiidx Dios persi zinal xcostumbridi. ");
INSERT INTO zasNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Bén rusquiee! ¡Rüjnzidi guial nabandi xnejz! Waliqui ni gunee Isaías, bén badëë xtiidx Dios loj ree bejn, chi rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Bén guie ree rëbzi reeman rniajchiꞌ reeman naj, per ad rënt reeman naj con guidib luxdoo reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Xliaꞌczi rniajchiꞌ reeman naj, abiꞌ rulüü reeman bejn ree ganaxzi ni rbëëguijc ree bénguidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Dxel gurejdx Jesús ben zien rigaꞌ ree yagaj, abiꞌ rëbaman loj reeman: ―Gol bacaagdiajg, gol bigniaꞌ tëë ni ganin lojdi. ");
INSERT INTO zasNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ad ni rawt bejn rüjn laaman béndol, ni ririi roꞌman laan rüjn laaman béndol. ");
INSERT INTO zasNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Dxel gubig ree xbejn Jesús lojman, rëb reeman: ―¿Gogbeel ya bidxeꞌch ree bénfarisew chi biguiejn reeman ni guneel? ");
INSERT INTO zasNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Badxiꞌ Jesús laan rëbaman: ―Gra ni ad zëëdt por da Dadan Dios bén yuꞌ xanyabaa, yuꞌ dxej nitan. ");
INSERT INTO zasNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Zeel gol basaꞌn reeman din laa reeman na̱j ziꞌc tijb bénlutiaꞌp rulüü stijb bénlutiaꞌp ban niz cheman. Abiꞌ bal tijb bénlutiaꞌp gulüü stijb bénlutiaꞌp guin, zayajb grop reeman roꞌ balaꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Dxel rëb Bëd loj Jesús: ―¿Basigniaꞌ dunujn xhie rën guiëb ni guneel? ");
INSERT INTO zasNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Badxiꞌ Jesúsan rëbaman: ―¿Wen, niꞌqui lëjt ad rigniaꞌtan ya? ");
INSERT INTO zasNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Id rigniaꞌdi ya guial gra ni raw bejn rej lënman abiꞌ rariin? ");
INSERT INTO zasNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Per diidx ririi roꞌ bejn, luxdooman zan, abiꞌ laan rüjn laaman béndol. ");
INSERT INTO zasNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Din luxdoo bejn za graloj ree xgabmal, guialrugüjt bejn, guial rüjn nidxuudx, guialrzunë lacheel ben ren, guialrban, guialrusquiee në guialrniee diidxguijdx loj lasaꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gra ree ni guie na̱j ni rüjn bejn béndol. Per guial ad zunaat bejn ziꞌc na̱j costumbr ni rayal güün bejn chi gadaman gaw, ad laatan na̱j ni rüjn laaman béndol. ");
INSERT INTO zasNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Chi baza Jesús yagaj zëman niz Tiro në niz Sidón. ");
INSERT INTO zasNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Abiꞌ yagaj zojb tijb béngunaa za niz Canaán, briiman, rbixdiajman rëbaman loj Jesús: ―¡Dad, xdiaa Davi, baya naj! Da xiꞌndxaꞌpan yuꞌ bendxab luxdoom, dád rusagziman laam. ");
INSERT INTO zasNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Abiꞌ Jesús ad badxiꞌtaman xtiidx béngunaa guin. Dxel gubig ree xbejnman lojman, rëb reeman: ―Bidxgaꞌ béngunaa guin, din yaguiajman, din rbixdiajman nalaman dunuj ree. ");
INSERT INTO zasNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Dxel rëb Jesús: ―Dios guxhaal naj din günan yudar ganaxzi ree bén Israel zë loj nejz mal. ");
INSERT INTO zasNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Per béngunaa guin bigzuxibaman loj Jesús, rëbaman: ―¡Dad, gognë naj! ");
INSERT INTO zasNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Badxiꞌ Jesúsan, rëbaman: ―Ad zagdxet na̱j chiquied bejn guiadxtil loj xiꞌnman din gudëëdaman laan loj ree bëꞌcw. ");
INSERT INTO zasNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Badxiꞌ béngunaa guinan, rëbaman: ―Waliquil, Dad, per në ree bëꞌcw rutoꞌp guiadxtil laay ni ryajb xan xmex bén na̱j xbëꞌcw laa reeb. ");
INSERT INTO zasNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Dxel rëb Jesús lojman: ―¡Na, waliquil rliladxil con guidib luxdool! Gac ziꞌc rënl. Loj hor guin gajc bayajc xiꞌn bén guin. ");
INSERT INTO zasNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Baza Jesús yagaj, bidxinman roꞌ nijs Galilea, dxel wëꞌpaman guijc tijb guiaꞌ abiꞌ gurejman yagaj. ");
INSERT INTO zasNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Dád zien bejn bidoꞌp lod zaꞌman. Binë reeman bencoj ree, në ree bénlutiaꞌp, në ree bén ad rüjnt xuꞌc dxiin, con ree bengop në zien ree bénragxuu ren ree, badxig reeman laa reeman loj Jesús, abiꞌ bayüjnman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Dád badxa loj ree bejn chi baguiaa reeman ma rniee ree bengop, ma bayajc xuꞌc ree bén ad rüjnt dxiin xuꞌc, guiáad ree bencoj ma rza reeman abiꞌ ree bénlutiaꞌp ruguiaa reeman. Zianz guzuloj cuzaꞌt reeman zagdxe xDios ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Abiꞌ gurejdx Jesús bén na̱j ree xbejnman, rëbaman loj reeman: ―Rayan bén guin ree, din ma gojc choon dxej zaꞌ reeman con naj, abiꞌ achet ni gaw reeman. Ad rëntan yaguꞌnejzan laa reeman sin guialraw ad nial yadaj reeman niz lunejz. ");
INSERT INTO zasNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Dxel rëb ree xbejnman lojman: ―Per ¿ban guin yucaꞌn ni gaw ree benzien guin, ziꞌc na̱j guie lod achutczi bejn zojb? ");
INSERT INTO zasNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Gunabdiidx Jesús loj reeman, rëbaman: ―¿Bël guiadxtil caꞌdi? Badxiꞌ reeman laan rëb reeman: ―Gajdx guiadxtil con zatioꞌp choon bëjl. ");
INSERT INTO zasNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Dxel gunabee Jesús gurej gra ree bén guin luyuj. ");
INSERT INTO zasNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Abiꞌ cwaꞌman guigajdx ree guiadxtil guin con ree bëjl guin, badëëman quixtëë loj Dios. Dxel gulaꞌman laa reen, badëëman laa reen loj ree xbejnman persi gudiꞌs reeman laa reen loj gra ree bén guin. ");
INSERT INTO zasNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Gra reeman gudaw xt bigdxinladx reeman. Abiꞌ staczi bacha reeman gajdx dxüm ni bayaꞌn. ");
INSERT INTO zasNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bén gudaw ree na̱j reeman tajp mil xinguiaaw, garenqui ree béngunaa con ree xindoo. ");
INSERT INTO zasNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Dxel bazaadiidxnë Jesús laa reeman, abiꞌ guyuman loj barcw ziaman niz Magadán. ");
INSERT INTO zasNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Bénfarisew ree con ree bénsaducew bidxin reeman lod zaꞌ Jesús, abiꞌ par güün reeman laaman prueb gunab reeman lojman din güünman tijb milagr din guiguien guial Dios guxhaal laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Per badxiꞌ Jesús laan rëbaman: ―Wadxe ree chi ruguiaadi naxnia xanyabaa, rëbidi: “Zagdxe gac guixie din naxnia xanyabaa.” ");
INSERT INTO zasNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Guiáad rsil chi naxnia xanyabaa yuꞌ tëë za̱j, rëbidi: “Ad laat gac yandxej.” ¡Bén rusquiee!, bal ragbeedi xhie rën guiëb sen yuꞌ xanyabaa, ¿chexc ad rigniaꞌtidi xhie rën guiëb gra ni cuguiaadi yan? ");
INSERT INTO zasNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Bén mal, ad rliladxtidi abiꞌ rniabidi günan tijb milagr, per achet guguiaadi, tijbzi ziꞌc guzac Jonás. Dxel basaꞌn Jesús laa reeman, ziataman. ");
INSERT INTO zasNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Dxel gudëdnë ree xbejnman stiblad roꞌ nijs guin, per bayanladx ree xbejnman ninë reeman guiadxtil. ");
INSERT INTO zasNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Abiꞌ rëb Jesús loj reeman: ―Gol gojp cudad con xlevadur ree bénfarisew në ree bénsaducew. ");
INSERT INTO zasNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Dxel guzuloj rëb loj lasaꞌ reeman: ―Naman duloj ree zian guial ad nacaꞌt ree guiadxtil. ");
INSERT INTO zasNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Gogbee Jesús ni canee reeman abiꞌ rëbaman loj reeman: ―¿Chexc zeel rëbidi guial ad caꞌtidi guiadxtil? Taꞌnnijt rliladxidi naj. ");
INSERT INTO zasNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Staczi ad rigniaꞌtidi ya? ¿Nid rusaaladxidi ya chi gudiꞌsan gaay guiadxtil loj gaay mil bejn, abiꞌ zabël dxüm ni bayaꞌn batoꞌpidi? ");
INSERT INTO zasNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Nid zaladx tëëdi ya chi gudiꞌsan gajdx guiadxtil loj tajp mil bejn, abiꞌ zabël dxüman batoꞌpidi? ");
INSERT INTO zasNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Chexc zeel ad rigniaꞌtidi guial ad guiadxtiltan cuzatan lojdi, chi rnin lojdi gapidi cudad con xlevadur ree bénfarisew në ree bénsadusew? ");
INSERT INTO zasNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Dxel bigniaꞌ ree xbejnman guial ad xlevadurt guiadxtilan cuzaꞌtaman loj reeman, rëbaman zian din gap reeman cudad con ni rulüü ree bénfarisew në ree bénsaducew. ");
INSERT INTO zasNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Chi bidxin Jesús niz Cesarea de Filipo, gunabdiidxaman loj ree xbejnman, rëbaman: ―¿Chu rëb ree bejn, na̱j Bén guxhaal Dios? ");
INSERT INTO zasNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Badxiꞌ reeman laan, rëb reeman: ―Yuꞌ reeman rëb guial Wajn, bén baroobnijs bejn ree. Yuꞌza reeman rëb guial Elíasan, bén badëë xtiidx Dios loj ree bejn, yuꞌ tëë reeman rëb guial Jeremíasan, bén badëëd xtiidx Dios loj ree bejn o stijb ben ren ya, bén badëëd xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Dxel rëbaman loj reeman: ―Laadx lëjt, ¿xhie nadi, chu naj? ");
INSERT INTO zasNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Badxiꞌ Simón Bëdan, rëbaman: ―Lüjn na̱j Cristo. Lüjn na̱j Xiꞌn Dios naban. ");
INSERT INTO zasNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Dxel rëb Jesús lojman: ―Xiquilbaal, Simón, xiꞌn Jonás, din ad bénguidxliujt guna lojl ni guinieel, da Dadan bén yuꞌ xanyabaa laaman na̱j bén guna lojl. ");
INSERT INTO zasNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Abiꞌ naj rni lojl, Bëd, (rën guiëban “guiaj”) lüj na̱j ziꞌc tijb guiaj ni gacnë lidxan, din por lüj grii ree bén gac da bejnan abiꞌ niꞌqui guialgüjt ad zunijtt laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Naj gune lüj guialrniabee ni za xanyabaa, abiꞌ gra ni tiëbil gac loj guidxliuj guie ma na̱j gacan xanyabaa, guiáad ni ad zatiëjbtil gac loj guidxliuj guie ad najt gacan xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Dxel gunabee Jesús loj gra ree xbejnman guial achu loj guiëb reeman guial laaman na̱j Cristo. ");
INSERT INTO zasNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Diizd nadxel guzuloj Jesús bagojn ree xbejnman guial na̱j cheman Jerusalén, abiꞌ ree guxtis Israel con ree bixhioz rniabee ree bixhioz në ree mextr rajc ley, laa reeman na̱j bén gusagzi laaman, gugüjt reeman laaman, per ni yayon dxej yabanman. ");
INSERT INTO zasNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Dxel gulëëcaan Bëd laaman, rëbaman lojman: ―¡Dios ad zabëëladxt lüj, Dad! ¡Laaman ad zatiëjbt saquil zian! ");
INSERT INTO zasNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Per badxiꞌ loj Jesús, rëbaman: ―¡Basaꞌn naj, xindxab!, ad rüjn nawëëguil lon. Din ad por Diost zëëd ree xgab ni rüjnl, xixgab bénguidxliujn rüjnl. ");
INSERT INTO zasNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Dxel rëb Jesús loj ree xbejnman: ―Bal yuꞌ bén rën gac da bejnan ad zajct güünman ziꞌc na̱j xixgabaman, siibnejzaman guialzi ni tëdzaman abiꞌ guidnalaman naj. ");
INSERT INTO zasNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Din bén mazri rën xguialnaban ni rajpaman loj guidxliuj guie zadxin dxej gunijtaman laan. Per bén guiët por naj, zajpaman guialnaban tiblayaa con Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Xhieczi gan gap bejn gra ni yuꞌ loj guidxliuj, abiꞌ nitaman loj Dios. Din ad zileꞌt sii bejn xguialnabanman xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Abiꞌ Bén guxhaal Dios, guiꞌtaman con xguialrniabee xDadaman Dios në ree xianjl Dios din gudëëman ni rayal tijbgaj bejn, bal gonin been bejn. ");
INSERT INTO zasNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Diidxliczi rnin lojdi guial yuꞌ ree bén rigaꞌ guie ad zëjtt reeman chi gad reeman guguiaa Bén guxhaal Dios, guiꞌtaman con xguialrniabeeman din nabeeman. ");
INSERT INTO zasNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chi gudëd xhoꞌp dxej, binë Jesús Bëd, në Jacob con Waj bijch Jacob, binëman laa reeman guijc tijb guiaꞌ ya. ");
INSERT INTO zasNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ni bidxaa Jesús niz loj reeman. Dád balaa bachaꞌ lojman ziꞌc rulaa gubijdx bachaꞌ, guiáad xabaman bayajcan naquich, balaa tëën bachaꞌ ziꞌc guij. ");
INSERT INTO zasNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Abiꞌ loj hor guin baguiaa reeman Moisejs con Elías cayünë reeman Jesús diidx. ");
INSERT INTO zasNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Dxel rëb Bëd loj Jesús: ―Dad, ¡zagdxe na̱j nadxuꞌ ree guie! Bal rënl, günan choon ranch, tijban par lüj, tijban par Moisejs, stijban par Elías. ");
INSERT INTO zasNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Laꞌtgaj canee Bëd zian, biguiajt tijb za̱j xt guijc reeman ridiinan bachaꞌ, loj za̱j guin brii chaꞌ bejn rëbaman: ―Bén guie na̱j da Xiꞌnan, bén rën daꞌtan, bén rabaanëꞌ tëën, gol bacaagdiajg xtiidxaman. ");
INSERT INTO zasNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Chi biguiejn ree xbejn Jesús diidx guin ree, bazuxib reeman basajb loj reeman xt luyuj, dád bidxeb reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Dxel gubig Jesús lod zaꞌ reeman, baquiꞌman laa reeman, rëbaman: ―Gol guzuli, ad ridxebidi. ");
INSERT INTO zasNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Abiꞌ chi gules loj reeman achutri baguiaa reeman, tijbzi Jesús zaꞌ yagaj. ");
INSERT INTO zasNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Laꞌtgaj cayguiajt reeman ruguiaꞌ guin, rëb Jesús loj reeman: ―Achuczi loj guiëbidi ni baguiaadi, xt chi yaban Bén guxhaal Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Dxel gunabdiidx ree xbejnman lojman, rëb reeman: ―¿Chexquiza zeel rëb ree mextr rajc ley guial yaloj Elías guiꞌt? ");
INSERT INTO zasNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Badxiꞌ Jesúsan, rëbaman: ―Walican guial yaloj Elías guiꞌt, laaman guzuxnejz gra. ");
INSERT INTO zasNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Per naj rni lëjt guial mal biꞌt Elías, abiꞌ ad bayagbeet ree bejn laaman, beennë reeman laaman ni guyëntzi reeman. Abiꞌ ziangajc gusagzi reeman Bén guxhaal Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Dxel gogbee ree xbejnman guial Wajn bén baroobnijs bejn ree cuzaꞌtaman. ");
INSERT INTO zasNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Chi badxin Jesús con guiyon ree xbejnman, lod cabëz ree ben zien laaman bibig tijb xinguiaaw lojman, bazuxibix lojman rëbix: ");
INSERT INTO zasNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Dad, baya da xiꞌnan, din dád rzagdiajx rëjtyaꞌx. Bëlczi volt riyajbix lojguij o lojnijs ya. ");
INSERT INTO zasNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Bidnëꞌn laax loj ree xbejnl, per ad rajct rayüjn reeman laax. ");
INSERT INTO zasNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Badxiꞌ Jesúsan, rëbaman: ―¡Benguijdx, bén ad rliladxt! ¿Xt goc gazunëꞌn lëjt? ¿Xt goc gadaanan lëjt? Gol tanë xinzii guie. ");
INSERT INTO zasNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Dxel gudilë Jesús xindxab guin, babëëman laax luxdoo xin guin. Loj hor guin gajc bayajquix. ");
INSERT INTO zasNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Abiꞌ gunabdiidx ree xbejn Jesús lojman lood ren, rëb reeman: ―¿Chexc zeel ad gojct nalëën xindxab guin luxdoo xin guin? ");
INSERT INTO zasNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Dxel rëb Jesús loj reeman: ―Guial taꞌnzi rliladxidi. Naj rni lojdi bal na̱j xguialrliladxidi majsi ziꞌctzi na̱j xhaj moxhtajs, zileꞌ guiëbidi loj guiaꞌ guin: “Bisüd guie, bisob lood ren”, zucaagdiajgan xtiidxidi. Achetczi gac nawëëg par lëjt. ");
INSERT INTO zasNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Per par yarii lasaꞌ ree xindxab guie ryaadx chu cwedx guiniab Dios guibaꞌn tëë. ");
INSERT INTO zasNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Laꞌtgaj zaꞌ Jesús niz Galilea con ree xbejnman, rëbaman loj reeman guial yayü reeman Bén guxhaal Dios loj ree bejn, ");
INSERT INTO zasNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","abiꞌ gugüjt reeman laaman, per ni yayon dxej yabanman. Chi biguiejn ree xbejnman zian, dád guyu naya reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Chi badxin Jesús con ree xbejnman guiedx Capernaum, bén ruquijx ree impuest par yadoo wej reeman loj Bëd bignabdiidx reeman, rëb reeman: ―¿Rguijx xmextril impuest par yadoo ya? ");
INSERT INTO zasNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Badxiꞌ Bëdan, rëbaman: ―Riguijxcaman laan. Dxel chi bayu Bëd lënü lod zaꞌ Jesús, yalojli Jesús gunabdiidx lojman, rëbaman: ―¿Xhie naladxil, Simón? ¿Chu rguijx impuest loj ree rey yuꞌ loj guidxliuj guie? ¿Xiꞌn reeman ya o benzit ree? ");
INSERT INTO zasNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Badxiꞌ Bëd laan rëbaman: ―Benzit ree. Dxel rëb Jesús: ―Abiꞌ ree bén ladx reeman ad rguijxt reeman laan. ");
INSERT INTO zasNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Per chitëë guidxeꞌch reeman, wej roꞌ nijs, bazaal xiansuelil, dxel bëjl yaloj ni guiniaazil babëëb. Roꞌ bëjl guin guidxelil tijb cintabl, con laan bitijx dux impuest. ");
INSERT INTO zasNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Lën ree dxejzii bidxin ree xbejn Jesús lod zaꞌman, abiꞌ gunabdiidx reeman lojman, rëb reeman: ―¿Chu mazri zojbloj lod rniabee Dios? ");
INSERT INTO zasNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Dxel gurejdx Jesús tijb xindoo, bazujman laax galay reeman, ");
INSERT INTO zasNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","abiꞌ rëbaman: ―Diidxliczi rnin lojdi bal id zayüjndi xgab por xtolidi, bal id zajc tëëdi ziꞌc tijb xindoo, ad zutidi lod rniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Bén güün naya loj Dios, gac tëëman ziꞌc xindo guie, laaman gac bén mazri zojbloj lod rniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Abiꞌ bén yacaꞌ tijb xindoo, por naj, najn racaꞌman. ");
INSERT INTO zasNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Bal chu gusajb tijb bén qui rliladxri naj loj dol, zagdxeli guixhii reeman tijb guiajroꞌ yëjnman guzaal reeman laaman xt xan nijs. ");
INSERT INTO zasNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Probza bénguidxliuj guial yuꞌ daꞌt ni rusajb laaman loj dol! Zianczi yuꞌ ni mal guin loj guidxliuj, per ¡probza bén gusajb bejn ree loj dol! ");
INSERT INTO zasNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Zeel, bal laagajc yaal o guiaꞌl rusajb lüj loj dol, zagdxeli gutüꞌn bazaalan zijt, din zagdxeli chuꞌl xanyabaa con tibladzi yaal o con tibladzi guiaꞌl, luar chuꞌl con groplad yaal o groplad guiaꞌl loj bajl ni ad yuꞌt dxej yayüꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Abiꞌ bal laagajc guiaalojl rusajb lüj loj dol, gulëën bazaalan zijt, zagdxeli chuꞌl con tibladzi guiaalojl xanyabaa, luar chuꞌl con gropladan loj bajl yuꞌ gabijl. ");
INSERT INTO zasNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Ad guiniajgaadi loj ree bén qui rliladxri naj. Din diidxliczi rnin lëjt guial xanyabaa yuꞌ ree anjl rniaj laa reeman zianczi zaꞌ reeman loj da Dadan Dios bén yuꞌ xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Guiáad Bén guxhaal Dios zëëdaman par ree bén ad zinalt xnejz Dios din laa reeman loj dol. ");
INSERT INTO zasNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Xhie naladxidi? Bal tijb bejn rajp tibgayuu xiil, abiꞌ rizëëb tijbib, ¿nid zusaꞌnman zatajpgajlchiinbitapib dajn ya din chigdiilaman be bizëëb guin? ");
INSERT INTO zasNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Abiꞌ bal yadxejlaman laab, diidxliczi rnin mazri yabaanëman laab guial loj tajpgajlchiinbitap be ad bizëëb guint. ");
INSERT INTO zasNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ziangajc dux Dad ree Dios bén yuꞌ xanyabaa ad rëntaman nit niꞌczi tijb ree bén qui rliladxri laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Bal xhie tijb ni mal güün lasaꞌl lüj, guneenëman lüjzi din gagbeeman xhie falt badxeꞌman. Bal guidxgaꞌman xtiidxil, ma beenl gan yaneenël laaman zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bal id ridxgaꞌman lüj, binë zatijb o zatioꞌp bejn, din chigneenëdi laaman din con xtiidx tioꞌp o choon bejn guiguien guial ma bigneenël laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Dxel bal niꞌqui xtiidx reeman ad ridxgaꞌtaman, bagojn ree bén zinal xnejz Dios, abiꞌ bal niꞌqui xtiidx reeman ad ridxgaꞌtaman, dxel ma guguiaadi laaman ziꞌc tijb bén ad rliladxt Dios o ziꞌc tijb bén ruquijx impuest par Rom. ");
INSERT INTO zasNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Diidxliczi rnin, gra ni ad zatiëjbtidi gac loj guidxliuj guie ad rajctan xanyabaa, guiáad ni tiëbidi gac loj guidxliuj guie mal rajcan xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Rni tëën lëjt: Bal yayaꞌn tioꞌpidi diidx loj guidxliuj guie, par guiniabidi xhienin loj da Dadan bén yuꞌ xanyabaa, laaman gunee laan. ");
INSERT INTO zasNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Din lod radoꞌp tioꞌp o choon bejn por naj, laa naj zaꞌ galay reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Dxel gubig Bëd gunabdiidxaman loj Jesús, rëbaman: ―Dad, ¿bël volt rayal günan perdon lasaꞌn, bal güünman naj xhienin? ¿Xt gajdx volt ya? ");
INSERT INTO zasNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Badxiꞌ Jesúsan rëbaman: ―Ad gajdx voltizi rayal güün lasaꞌl perdon, rayal güünl perdon gajdx volt gayojnchii. ");
INSERT INTO zasNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Xguialrniabee Dios na̱j ziꞌc tijb rey ni been xgab guial ma gojl yaguijx ree xmojsaman lojman. ");
INSERT INTO zasNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Chi guzulojman caybëëman cwent guin, bidxin tijb xmojsaman lojman bén ral zroꞌ daꞌt. ");
INSERT INTO zasNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Abiꞌ guial achet rajp bén guin din yaguijxaman ni ralaman, gunabee rey guin toꞌman loj ree bejn në lacheelaman con ree xiꞌnman nëtëë gra ni rajpaman din chileꞌ yaguijxaman diꞌn guin. ");
INSERT INTO zasNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Dxel bazuxibaman loj rey guin, beenman naya rëbaman: “Dad, gojp naj pacens zaguixcan graczi ni ralan lojl.” ");
INSERT INTO zasNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Zianz baya rey guin laaman, beenman laaman perdon gra ni ralaman, abiꞌ baslaaman laaman ziaman. ");
INSERT INTO zasNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Per chi barii mojs guin yagaj, badxajgaman tijb bén rüjnnëman dxiin, ralaman taꞌnzi milia lojman. Dxel gunaazaman laaman guzuloj caguiajman yëjnman, rëbaman: “¡Baguijx ni ralil lon!” ");
INSERT INTO zasNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Dxel bazuxib bén guin lojman beenman naya rëbaman: “Gojp naj pacens zaguixcan graczi ni ralan lojl.” ");
INSERT INTO zasNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Per ad guyënt bén guin, badxeꞌman laaman ladxguiib xt lodzi yaguijxaman diꞌn guin. ");
INSERT INTO zasNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Chi baguiaa ree los demazri ree xmojs rey guin, dád gognaa luxdoo reeman, abiꞌ wej reeman biguiedx reeman lojman gra ni goc. ");
INSERT INTO zasNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Dxel gurejdx rey guin mojs guin, zianz rëbaman lojman: “¡Mojs guijdx! Benan perdon gra ni ralil lon guial beenl naya. ");
INSERT INTO zasNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Nid nëgajc lüj rayal naya xcompniaril ya, ziꞌcgajc bayan lüj?” ");
INSERT INTO zasNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Abiꞌ guial tant balen rey guin, gunabeeman badxeꞌ reeman laaman ladxguiib xt lodzi baguijx gra ni ralaman. ");
INSERT INTO zasNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Basnuu Jesús rëbaman: ―Ziangajc güünnë da Dadan lëjt, bén yuꞌ xanyabaa, bal id züjn perdon lasaꞌdi con guidib luxdoodi ni rüjnnë reeman lëjt. ");
INSERT INTO zasNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Chi gulox gunee Jesús zian, bazaman niz Galilea, zëman niz Judea, niz stiblad roꞌ guiiw Jordán. ");
INSERT INTO zasNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Zien ree bejn binal laaman, yagaj bayüjnman bénragxuu ree. ");
INSERT INTO zasNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Abiꞌ tioꞌp choon ree bénfarisew bibig loj Jesús, dxel par güün reeman laaman prueb, gunabdiidx reeman lojman rëb reeman: ―¿Zileꞌ yalaꞌ bejn lacheelaman por xhiedxitzinin ya? ");
INSERT INTO zasNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Badxiꞌ Jesúsan rëbaman: ―¿Nid wayoolidi loj xtiidx Dios ya, guial diizd guiaꞌxchej Dios “been xinguiaaw në béngunaa”? ");
INSERT INTO zasNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Rëb tëëman: “Zeel xinguiaaw gusaꞌn xdad xniaax din guibannë lacheelix, dxel grop reex ma gac ziꞌc tijbzi bejn.” ");
INSERT INTO zasNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Zianan zeel ad najtri reex tioꞌp, ma na̱j reex tijbzi. Zeel bénguidxliuj ad rayalt yalaꞌman lasaꞌ ni ma bachajg Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Dxel rëb ree bénfarisew guin loj Jesús: ―¿Chexquiza zeel rëb Moisejs guial zileꞌ yalaꞌ lacheel bejn, con gudëëdaman guiꞌch guial ma balaꞌ lasaꞌ reeman? ");
INSERT INTO zasNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Badxiꞌ Jesúsan, rëbaman: ―Cwëjb Moisejs gojc zian guial ad rëntidi guzoobidi diidx, per ad ziant gojc diizd guiaꞌxchej. ");
INSERT INTO zasNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Naj rni lojdi. Xin yalaꞌ lacheel, bal id zaꞌnë lacheelix xin ren, abiꞌ tiaꞌx ben ren dolan cayüjnx. Ziangajc xin tiaꞌ bén qui balaꞌri lasaꞌ guin dolan cayüjnx. ");
INSERT INTO zasNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Dxel rëb ree xbejn Jesús lojman: ―Bal zian na̱j xcwent guial ru lacheel, zagdxeli ad zut lacheel bejn ");
INSERT INTO zasNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Badxiꞌ Jesúsan rëbaman: ―Ad grat bejn zileꞌ chigniaꞌ ni canin, bén caꞌzi ree quiarguiejn par chigniaꞌ reeman laan. ");
INSERT INTO zasNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yuꞌ bejn diizd rajlaman ad zëëdtaman loj guidxliuj par guxhliaaman, yuꞌza reeman, bejn rüjn laa reeman zian. Abiꞌ yuꞌ reeman rüjn xgab guial zagdxeli guitieꞌch reeman xtiidx Dios luar guxhliaa reeman. Bén rën chigniaꞌ, gol bigniaꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Binë ree bejn xindoo ree lod zaꞌ Jesús, din guixhioob yaaman guijc reex cwedx guiniab tëëman Dios por laa reex, per ree xbejnman guzuloj cadilë reeman bén zinë ree laa reex. ");
INSERT INTO zasNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Dxel rëb Jesús loj reeman: ―Gol baslaa guiꞌt reex lon, ad bal rudxoondi, din lod rniabee Dios na̱j par ree bén naj ziꞌc laa reex. ");
INSERT INTO zasNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Abiꞌ guxhoob yaa Jesús guijc ree xindo guin, dxel ziaman. ");
INSERT INTO zasNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Bidxin tijb xin guin loj Jesús, abiꞌ gunabdiidxix lojman, rëbix: ―Mextr, ¿xhie ni zagdxe günan din gaꞌpan guialnaban tiblayaa con Dios? ");
INSERT INTO zasNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Dxel rëb Jesús lojx: ―¿Chexc zeel rniabdiidxil lon conin na̱j ni zagdxe? Achut na̱j benzaꞌc, tijbzi Dios. Per bal rënl gapil guialnaban tiblayaa con Dios, been ziꞌc rëb ree mandamient. ");
INSERT INTO zasNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Dxel gunabdiidxix loj Jesús rëbix: ―¿Con ree mandamientan? Badxiꞌ Jesúsan, rëbaman: ―Ad gugüjtil bejn, ad sunël lacheel ben ren, ad cwanl, ad cwëël xtiidx bejn, ");
INSERT INTO zasNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","gojp respejt xdad xniaal, guyën tëë ree lasaꞌl ziꞌc rën lüj gajc. ");
INSERT INTO zasNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Dxel rëbix: ―Gra ree ni guin cayünan diizd najn xindoo, ¿xhieri ryaadx günan yan? ");
INSERT INTO zasNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Badxiꞌ Jesúsan, rëbaman: ―Bal rënl gaquil benzaꞌc loj Dios, bigtoꞌ gra ni rajpil dxel gudëël milia guin loj ree bénprob. Zian gapil guialnazaꞌc xanyabaa. Zianz guidnalil naj. ");
INSERT INTO zasNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Chi biguiejn xin guin zian, dád guyu nayax ziax, guial dád xinrijcwan. ");
INSERT INTO zasNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Dxel rëb Jesús loj ree xbejnman: ―Diidxliczi rnin lojdi: Dád nawëëg chuꞌ benrijcw lod rniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Naj rni lëjt. Adli nawëëgt tëd tijb camell xan gagux, guial chuꞌ tijb benrijcw lod rniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Chi biguiejn ree xbejn Jesús zian, dád badxaloj reeman, abiꞌ rëb reeman: ―¿Chuza zajc gac perdon loj Dios? ");
INSERT INTO zasNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Dxel baguiaa Jesús loj reeman, rëbaman: ―Nawëëg gac zian par bénguidxliuj, per par Dios achet ni nawëëg yuꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Abiꞌ rëb Bëd lojman: ―Ma basaꞌnan graczi ni rayaꞌpan, persi zudnaalan lüj. Abiꞌ ¿xhieza yayalan? ");
INSERT INTO zasNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Badxiꞌ Jesúsan, rëbaman: ―Diidxliczi rnin lojdi chi guidxin dxej yacüb gra, guidxin tëë dxej cwe Bén guxhaal Dios luar lod nabeeman, në lëjt, guial zidnalidi naj, cwedi loj chiptioꞌp ree luar lod nabeedi, din güün xguialguxtisidi loj guidxiptioꞌp ree xdiaa Israel. ");
INSERT INTO zasNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Abiꞌ gra ree bén basaꞌn lidx, bijch, bizan, xdad, xniaa, xiꞌn, o guidxliuj ree por naj, zacaꞌ reeman tibgayuu volt mazri guial loj ni basaꞌn reeman, zajp tëë reeman guialnaban tiblayaa con Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Per zien ree bén na̱j bén yaloj, gac reeman bén bigra, abiꞌ zienza ree bén na̱j bén bigra, gac reeman bén yaloj. ");
INSERT INTO zasNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Rëb tëë Jesús: ―Xguialrniabee Dios na̱j ziꞌc tijb bén rajp tijb guiniaaroꞌ, rsildoo briiman zitiilaman mojs güün dxiin loj xguiniaaman. ");
INSERT INTO zasNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bayaꞌnnëman laa reeman diidx plac quixaman tijb gaj reeman tibdxej, dxel guxhaalaman laa reeman loj xguiniaaman. ");
INSERT INTO zasNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Dxel briiman stijb cost raca gaa rsil, abiꞌ baguiaaman ben ren ree zaꞌ reeman galay luguiedx, achet xchiin reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Zianz rëbaman loj reeman: “Gol biguieen dxiin loj da guiniaan, naj gaguix lëjt ziꞌc rayal.” Dxel zë reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Cost garol dxej briiman stijb, abiꞌ brii gajman cost raca choon wadxe ziangajc rëbaman loj ree bén rigaꞌ yagaj, bén achet xchiin. ");
INSERT INTO zasNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Cost raca gaay wadxe wejman galay luguiedx guin stijb, abiꞌ bidxaaglojman ben ren ree, bén achet ree xchiin, gunabdiidxaman loj reeman, rëbaman: “¿Chexc zeel zaꞌdi guin gudëdchej ad cayüjntidi dxiin?” ");
INSERT INTO zasNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Badxiꞌ reeman laan rëb reeman: “Achut wanee dxiin yaguieenan.” Dxel rëbaman loj reeman: “Në lëjt gol biguieen dxiin loj da guiniaan naj gaguix lëjt ziꞌc rayal.” ");
INSERT INTO zasNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Chi ma gurej guiaal, rëb bén naj xguiniaan loj bén naaz dxiin guin: “Gurejdx ree mojs guin din quixil laa reeman, per yalojxgaj gudijx ree bén bigra guyu, zianz quixil bén guyu ree yaloj.” ");
INSERT INTO zasNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Chi bidxin ree bén guyu loj dxiin guin raca gaay wadxe, gojx tijbgaj reeman xieen tibdxej. ");
INSERT INTO zasNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Dxel chi bidxin ree bén guyu loj dxiin diizd rsil, gunaladx reeman niajx reeman mazri, per nëgajc reeman gojx xieen tibdxej. ");
INSERT INTO zasNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Abiꞌ chi cayajx reeman, guzuloj cadxeꞌch reeman bén na̱j xguiniaa laan, ");
INSERT INTO zasNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","rëb reeman lojman: “Bén bigra guyu ree, been reeman dxiin tib horzi abiꞌ ziꞌcgajc caguijxil dunujn gudijxil laa reeman, abiꞌ dunujn badaanan baguieenan dxiin dëchej loj guialnalaa.” ");
INSERT INTO zasNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Per rëb bén guin loj tijb reeman: “Achet ni mal cayünan lüj. ¿Nid bayaꞌn diidx ya plac gunen tiaꞌl tibdxej? ");
INSERT INTO zasNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Cwaꞌ ni bayalil baguiaj. Din naj rënan gaguixan bén bigratë guyu ziꞌc gudixan lüj, ");
INSERT INTO zasNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","zajc günnëꞌ da milian ni rëntzan. ¿O nadëdlojl ya guial najn benzaꞌc?” ");
INSERT INTO zasNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Zianan zeel bén na̱j ree bén bigra gac reeman bén yaloj, guiáad ree bén yaloj gac reeman bén bigra. ");
INSERT INTO zasNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Chi zë Jesús Jerusalén, gurejdx guidxiptioꞌp ree xbejnman tiblad, rëbaman loj reeman: ");
INSERT INTO zasNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Ganin lëjt, ziyoꞌ ree Jerusalén, lod yayü reeman Bén guxhaal Dios, loj ree bixhioz rniabee ree bixhioz në loj ree mextr rajc ley, abiꞌ laa reeman nabee guiëtaman, ");
INSERT INTO zasNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","yayü reeman laaman loj ree benzit, din guzeꞌ reeman laaman quin tëë reeman laaman, abiꞌ gucaa reeman laaman loj crüjz, per yayon dxej yabanman. ");
INSERT INTO zasNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Gubig lacheel Zebedeo loj Jesús con grop ree xiꞌnman, bazuxibaman lojman din guiniabaman ni rënman. ");
INSERT INTO zasNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Gunabdiidx Jesús lojman, rëbaman: ―¿Xhie rënl? Badxiꞌ bén guinan, rëbaman: ―Rënan nabeel cwe tijb da xiꞌnan xladbeel, stijbim xladruvejsil, chi ma canabeel. ");
INSERT INTO zasNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Dxel rëb Jesús: ―Ad ragbeetidi ni rniabidi. ¿Wen zajc tëdidi guialzi ziꞌc na̱j ni gadëëdan ya? Badxiꞌ reeman laan, rëb reeman: ―Zayajcan. ");
INSERT INTO zasNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Abiꞌ rëbaman: ―Diidxliczi rnin zajc tëdidi guialzi ziꞌc na̱j ni gadëëdan, per guial cwedi da ladbeen o da ladruvejsan ya ad najt rayal ganabee, din ma najn par ree bén bacaabee da Dadan. ");
INSERT INTO zasNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Chi biguiejn zachii ree xbejn Jesús zian dád balen reeman grop bijch reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Per gurejdx Jesús laa reeman, rëbaman: ―Lëjt ragbee, bén rniabee ree loj guidxliuj, rniabee reeman bejn ree ziꞌctzi rën reeman, guiáad ree bén zojbloj rüjnnë reeman bejn ree ziꞌctzi rën reeman por guialrniabee ni rajp reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Per con lëjt ad rayalt gac zian. Bal chu rën gac bén rniabee lojdi, rayal güünman sirv lojdi. ");
INSERT INTO zasNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ziangajc bén rën gac bén zojbloj lojdi, rayal güünman sirv lojdi ziꞌc bén nadoꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ziꞌc Bén guxhaal Dios ad biꞌttaman par güün reeman sirv lojman, biꞌtaman par güünman sirv gudëë tëë xguialnabanman din laa zien bejn loj dol. ");
INSERT INTO zasNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Chi bazaman luguiedx Jericó con ree xbejnman, dád zien ree bejn binal laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Dxel tioꞌp ree bénlutiaꞌp zojb cwëꞌ nejz chi biguiejn reeman cadëd Jesús niz yagaj, gurixdiaj reeman rëb reeman: ―¡Dad, xdiaa Davi, baya dunujn! ");
INSERT INTO zasNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Abiꞌ rdilë ree ben guin laa reeman din yacwëëz roꞌ reeman, per mazri ribixdiaj reeman rëb reeman: ―¡Dad, xdiaa Davi, baya dunujn! ");
INSERT INTO zasNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Dxel guzudxe Jesús, gurejdxaman laa reeman, gunabdiidxaman loj reeman, rëbaman: ―¿Xhie rëndi günan por lëjt? ");
INSERT INTO zasNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Badxiꞌ reeman laan, rëb reeman: ―Dad, rayënan yaxal du lojn. ");
INSERT INTO zasNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Dxel baya Jesús laa reeman, abiꞌ baquiꞌman loj reeman. Loj hor zii baxal loj reeman, dxel binal reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Chi ma cadxin Jesús con ree xbejnman Jerusalén, niz guiedx la Betfagé, gajxh ruguiaꞌ Olivos, guxhaal Jesús tioꞌp ree xbejnman, ");
INSERT INTO zasNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","rëbaman loj reeman: ―Golchej guiedx rigaꞌ lad ni, ni guidxaaglojdi tijb bur, caduunë xiꞌnb. Gol guxhiec reeb gol tanë reeb guie. ");
INSERT INTO zasNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Abiꞌ bal chu xhie na lojdi, gol güjdx guial Dad Jesús cayaadx laa reeb, gandoo yaxhaalaman laa reeb. ");
INSERT INTO zasNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Zian gojc persi gojc cumplid ni gunee bén badëë xtiidx Dios loj ree bejn, chi rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Gol güjdx loj ree bén Sión: “Gol baguiaa laa xreydi zëëd lojdi, ad zëëdtaman nabë, dxiibaman tijb bur, tijb burdoo xiꞌn tijb be rüü.” ");
INSERT INTO zasNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Dxel wej ree xbejn Jesús abiꞌ been reeman ziꞌc rëbaman loj reeman, ");
INSERT INTO zasNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","binë reeman bur guin con xiꞌnb, abiꞌ badxiib xab reeman xijch reeb zianz gudxib Jesús burdo guin. ");
INSERT INTO zasNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Abiꞌ guial zien ree bejn, yuꞌ reeman rguijxh xab lunejz, zien tëë reeman ritüꞌ xidx ree yag persi rguijxh reeman laa reen lod cadëdaman. ");
INSERT INTO zasNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Abiꞌ ziꞌc ree bén ned ziꞌc ree bén zidnal laaman, rbixdiaj reeman, rëb reeman: ―¡Benzaꞌc bendxoon na̱j xdiaa rey Davi! ¡Nüjnleꞌ Dios bén guxhaalaman! ¡Benzaꞌc bendxoon na̱j Dios bén yuꞌ xanyabaa! ");
INSERT INTO zasNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Chi guyu Jesús luguiedx Jerusalén, gra ree bén luguiedx guin badxaloj, abiꞌ riniabdiidx loj lasaꞌ reeman, rëb reeman: ―¿Chu bén guin? ");
INSERT INTO zasNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Dxel rëb ree benzien guin: ―Laaman na̱j Jesús, bén rudëë xtiidx Dios loj ree bejn, bén Nazaret guiedx rigaꞌ niz Galilea. ");
INSERT INTO zasNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Chi bidxin Jesús roꞌ yadooroꞌ Jerusalén, guzuloj caybëëman bén cutoꞌ ree në ree bén cazii. Barexguiataman xmex ree bén cuchaa milia në xmex ree bén cutoꞌ palom. ");
INSERT INTO zasNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Dxel rëb Jesús loj reeman: ―Loj xtiidx Dios rëb: “Lidxan grii laj yu lod rbejdx rniab bejn Dios.” Per lëjt nüjndan ziꞌc lidx ree xingubaan. ");
INSERT INTO zasNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Dxel bénlutiaꞌp ree con ree bencoj bibig reeman loj Jesús lën yadoo guin abiꞌ bayüjnman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Per chi baguiaa ree bixhioz rniabee ree bixhioz con ree mextr rajc ley milagr cayüjn Jesús, biguiejn tëë reeman rëb ree xindoo lën yadoo guin: “Benzaꞌc bendxoon na̱j xdiaa rey Davi”, dxel dád bidxeꞌch reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Abiꞌ rëb reeman loj Jesús: ―¿Rguiejnl ni canee ree xindo guin ya? Badxiꞌ Jesúsan, rëbaman: ―Rguiejncan. Per ¿gadidi gool loj xtiidx Dios ya? Lod rëb: Lüj badëëd ni gool ree xindoo në ree xindobëz sta rëꞌ dud, din guilies reex xvaloril. ");
INSERT INTO zasNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Dxel basaꞌn Jesús laa reeman, zëman Betania ni bayaꞌnman guxhin guin. ");
INSERT INTO zasNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Chi bareguiaal rsil laꞌtgaj zë Jesús Jerusalén stijb, guzuloj gulaanman. ");
INSERT INTO zasNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Abiꞌ baguiaaman zojb tijb yag higo cwëꞌ nejz, dxel gubigaman cwëꞌn, per ganaxzi balag ca lojn. Zianz rëbaman loj yag higo guin: ―¡Ad yuꞌtri dxej tial higo! Loj hor guin gajc gubidx yag guin. ");
INSERT INTO zasNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Chi baguiaa ree xbejnman zian, dád badxaloj reeman abiꞌ gunabdiidx reeman loj Jesús, rëb reeman: ―¿Xhienaag gojc zeel laa gubidx gajc yag higo guin? ");
INSERT INTO zasNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Badxiꞌ Jesúsan, rëbaman: ―Naj rni lojdi, bal rliladxidi Dios abiꞌ ad zunawëëgtidi, ad ni bentzan con yag higo guin zajc güündi, zajc guiëbidi loj guiaꞌ guie: “Biquied guie, bisob loj nijsdoo”, abiꞌ zajc gajc zian. ");
INSERT INTO zasNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Gra ni guiniabidi loj Dios, bal rliladxidi laaman, zuneeman laan. ");
INSERT INTO zasNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Chi guyu Jesús lën yadooroꞌ Jerusalén, laꞌtgaj culüüman bejn ree. Bixhioz rniabee ree bixhioz con ree guxtis Israel, gubig reeman loj Jesús, abiꞌ gunabdiidx reeman, rëb reeman: ―¿Chu na güünl ni guin ree? ¿Chu banee guialrniabee lojl? ");
INSERT INTO zasNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Badxiꞌ Jesúsan, rëbaman: ―Ziangajc naj yuꞌ tijb ni ganabdiidxan lojdi, bal yadxiꞌdan dxel ganin lëjt chu banee guialrniabee günan ni guin ree. ");
INSERT INTO zasNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Chu guxhaal Waj chigroobnijsaman bejn ree, Dios ya o bénguidxliuj? Dxel guzuloj cayü reeman diidx, rëb reeman: ―Bal yaguieꞌch ree, “Dios guxhaal laaman”, zanaman: “¿Chexza zeel ad bililadxtidi laaman?” ");
INSERT INTO zasNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Abiꞌza bal yaguieꞌch ree: “bénguidxliuj guxhaal laaman”, radxeb ree yalen ree bejn din gra reeman rliladx guial Waj na̱j bén badëëd xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Dxel rëb reeman loj Jesús: ―Ad rayagbeetan. Badxiꞌ Jesúsan, rëbaman: ―Niꞌqui naj ad zanitan lojdi chu banee guialrniabee günan ni guin ree. ");
INSERT INTO zasNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Basnuu Jesús rëbaman loj ree bixhioz rniabee ree bixhioz në loj ree guxtis Israel. ―¿Xhie nadi ni ganin lëjt? Tijb bejn guyu tioꞌp xiꞌnman, dxel rëbaman loj tijbix: “Xiꞌn, wej yandxej biguieen dxiin loj guiniaa yuꞌ uv.” ");
INSERT INTO zasNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Badxiꞌxan, rëbix: “Ad zatan.” Per dxelri bayüjnx xgab zianz wejx. ");
INSERT INTO zasNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Abiꞌ rëbaman loj stijb xiꞌnman din chex, badxiꞌxan, rëbix: “Yo dad, gazacan.” Per ad wejtix. ");
INSERT INTO zasNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yan, ¿chu loj grop reex been ni rën xdad reex? Badxiꞌ reeman laan, rëb reeman: ―Xin rëbaman loj yaloj guin. Dxel rëb Jesús loj reeman: ―Diidxliczi rnin, bén ruquijx ree impuest con ree béngunaa naban nadxuudx, yalojl laa reeman chuꞌ lod rniabee Dios guial lojdi. ");
INSERT INTO zasNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Din biꞌt Waj, bén baroobnijs bejn ree par gulüüman lëjt xhienaag guibandi, per ad bililadxtidi xtiidxaman. Guiáad ree bén ruquijx impuest con ree béngunaa naban nadxuudx, bililadx reeman xtiidxaman. Per lëjt majsi baguiaadi gra ree ni guin, ad bayüjntidi xgab por xtolidi din nililadxidi laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Rëb tëë Jesús loj reeman: ―Yan, gol bacaagdiajg ganin lëjt stijb ni na̱j ziꞌc cwent. Guyu tijb bejn guxübinman uv ree loj xguiniaaman, dxel beenman gurajl gadëd roꞌn, beenchaaw tëëman tijb luar lod grii xnijs uv guin, abiꞌ bazoobaman tijb yu ya daꞌt din guiyaꞌp guidib guiniaa guin. ’Zianz badëëdaman laan garol loj ree bén güün dxiin lojn, zëtaman zijt. ");
INSERT INTO zasNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Chi bidxin dxej yaruꞌ ree uv guin, guxhaalaman tioꞌp choon ree xmojsaman chigxii reeman ni rayalaman. ");
INSERT INTO zasNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Per ree bén rüjn dxiin loj guiniaa guin gunaaz reeman mojs guin ree. Tijbaman gudijn reeman, stijbaman bagüjt reeman, stijbaman bacaaguiaj reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Dxel bén na̱j xguiniaan guxhaalaman mazri ree mojs guial loj ree bén we yaloj, per ziangajc beennë ree bén guin laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Ni bigra, guxhaal xiꞌnman guial gunaladxaman: “Zajpqui reeman da xiꞌnan respejt.” ");
INSERT INTO zasNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Per chi baguiaa ree bén guin xiꞌnman, rëb loj lasaꞌ reeman: “Xin guinan na̱j xin tiaꞌ guidxliuj guin, yagüjt reex din gacan du xieen ree.” ");
INSERT INTO zasNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Abiꞌ gunaaz reeman laax, babëë reeman laax loj guiniaa guin dxel bagüjt reeman laax. ");
INSERT INTO zasNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Dxel gunabdiidx Jesús loj ree bén caneenëman, rëbaman: ―Chi yadxin bén na̱j xguidxliuj laan, ¿xhie naladxidi güünnëman bén guin ree? ");
INSERT INTO zasNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Abiꞌ rëb reeman loj Jesús: ―Ad zayataman gugüjtaman bén guin ree, dxel gudëëman guidxliuj guin garol loj ree ben ren, bén yayü ni rayalaman chi guidxin dxej yaruꞌ ree uv guin. ");
INSERT INTO zasNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Dxel rëb Jesús loj reeman: ―¿Id wayolczidi loj xtiidx Dios ya? Lod rëb: Guiaj ni gulëëgoꞌn ree bén rüjn yu. Laan goc ni mazri been sirv gojcnë yu guin. Laan na̱j ni been Dios, abiꞌ dád radxa du loj ree. ");
INSERT INTO zasNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Zeel rnin lojdi, zariicadi loj xguialrniabee Dios abiꞌ ben ren ree yayu xluaridi, bén wali ree güün ziꞌc rënman. ");
INSERT INTO zasNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Abiꞌ chutëëz bén yab guijc guiaj guin, zarooxaman, guiáad bal yab guiaj guin guijcaman zanidlojman. ");
INSERT INTO zasNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Chi biguiejn ree bixhioz rniabee ree bixhioz con ree bénfarisew guin ni cayü Jesús ziꞌc cwent, dxel gogbee reeman guial laa reeman cuzaꞌtaman. ");
INSERT INTO zasNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Abiꞌ guyën reeman niniaaz reeman laaman, per bidxeb reeman bejn ree guial rliladx reeman laaman na̱j bén rudëëd xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Basnuu Jesús beman ziꞌc cwent loj reeman rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Xguialrniabee Dios na̱j ziꞌc tijb rey bén been lanijroꞌ chi baxhliaa xiꞌnman. ");
INSERT INTO zasNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Abiꞌ guxhaalaman mojs ree bignee reeman biooz ree, per biooz guin ree ad guyënt reeman niej reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Dxel guxhaalaman mojs ren ree, rëbaman loj reeman: “Gol güjdx loj ree biooz guin ma na̱j guialraw, ma gunabeen güjt ree da goꞌnan në ree beren, beroꞌ ree. Ma najcchaaw graczi, gol güjdx loj reeman din guiꞌt reeman loj guialruxhliaa guin.” ");
INSERT INTO zasNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Per biooz guin ree ad bidxgaꞌt reeman xtiidx rey guin, yuꞌ reeman zë loj xguiniaa, yuꞌ reeman zë xmandad, ");
INSERT INTO zasNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","yuꞌ tëë reeman gunaaz mojs guin ree gudijn reeman laa reeman abiꞌ bagüjt reeman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Chi gogbee rey guin zian, dád bidxeꞌchaman. Guxhaalaman bén na̱j ree xsuldadaman persi bagüjt reeman bén guin ree bazeꞌc tëë reeman lidx reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Dxel rëbaman loj ree xmojsaman: “Graczi ma najcchaaw par loj guialruxhliaa guin, per ree bén gunen ad najt guial niꞌt reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yan, gol wej lod radxaag lasaꞌ ree nejz, gol güjdx loj ree bén guidxaalojtzidi din guiꞌt reeman loj guialruxhliaa guin.” ");
INSERT INTO zasNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Abiꞌ brii ree mojs guin wej reeman lunejz guin ree, batoꞌp reeman gra ree bén bidxaalojtzi reeman, ziꞌc ree benmal ziꞌc ree benzaꞌc, zian gudxa ree biooz lidx rey guin. ");
INSERT INTO zasNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Per chi guyu rey guin din guguiaaman biooz guin ree, baguiaaman tijb bén ad najcwt xab ni rayal gacwaman loj guialruxhliaa guin. ");
INSERT INTO zasNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Abiꞌ rëb rey guin lojman: “Laadx lüj, ¿xhienaag beenl guyul guie abiꞌ ad najcwt xabil ni rayal gacwil loj guialruxhliaa?” Dxel achet badxejl niëjb bén guin. ");
INSERT INTO zasNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Zianz rëb rey guin loj ree bén caguiꞌs guialraw: “Gol guxhii guiaꞌx në yaax, gol bazaal tëëx xchu lod nacay daꞌt lod goonx gaw tëë layix.” ");
INSERT INTO zasNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Din zien ree bejn rdxejl, per ad grataman chuꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Dxel baza ree bénfarisew yagaj, abiꞌ bayaꞌn reeman diidx xhie guiniabdiidx reeman loj Jesús din guidoon xhie guiëbaman, zian chileꞌ gutediaꞌ reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Abiꞌ guxhaal ree xbejn reeman con ree xbejn Herodes, rëb reeman lojman: ―Mextr, dunujn rayagbee guial lüj rniee diidxli, abiꞌ walil rulüül guial xhienaag rën Dios guiban bejn, ad ridxgaꞌ tëëtil chu na̱j bejn. Din lojl tiblojzi na̱j bejn. ");
INSERT INTO zasNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Guna du lojn: ¿Zagdxen ya yadijxan impuest loj César o ad zagdxetan ya? ");
INSERT INTO zasNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Per gogbee gajc Jesús xgabmal ni cayüjn reeman, abiꞌ rëbaman loj reeman: ―Bén rusquiee, ¿chexc zeel raguiilidi mod xhienaag gutidiaꞌdi naj? ");
INSERT INTO zasNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Gol balüü tijb cintabl lon ni rguijxnëdi impuest. Dxel badëëd reeman tijban lojman, ");
INSERT INTO zasNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","abiꞌ gunabdiidx Jesús loj reeman, rëbaman: ―¿Chu loj ca lojn chu tëë laj ca lojn? ");
INSERT INTO zasNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Badxiꞌ reeman laan, rëb reeman: ―Laj César në lojman. Dxel rëbaman: ―Gol badëëd loj César ni na̱j xieen César, guiáad loj Dios gol badëëd ni na̱j xieen Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Chi biguiejn reeman zian, dád badxaloj reeman, dxel basaꞌn reeman laaman, zianz zia reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Dxejzii gajc tioꞌp choon ree bénsadusew wej reeman bignaj reeman Jesús, bénsadusew guin ree ad rliladxt reeman guial yaban ree bengüt, zeel rëb reeman loj Jesús: ");
INSERT INTO zasNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Mextr, Moisejs rëb guial bal guiët tijb xinguiaaw abiꞌ achut xiꞌn reex guyu con lacheelix, bijch xingüt guin guxhliaanë béngunaa bizëjb guin din chuꞌ xiꞌn reex luar bijchix. ");
INSERT INTO zasNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Du lojn guyu tijb famil lod gojc reex gajdx bijch. Baxhliaa xin yaloj guin, per güjtix abiꞌ guial ad guyut xiꞌnx, dxel bijch barojpix baxhliaanë béngunaa guin. ");
INSERT INTO zasNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Per ziangajc guzajc xin barojp guin abiꞌ ziangajc guzajc xin bayon guin, xt bagajdx reex guzajc zian. ");
INSERT INTO zasNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Chi bara reex güjt dxel güjt béngunaa guin. ");
INSERT INTO zasNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Yan, chi yaban ree bengüt, loj guigajdx reex, ¿chu gac xbéngunaa laaman guial gra reex baxhliaanë laaman? ");
INSERT INTO zasNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Badxiꞌ Jesúsan, rëbaman: ―¡Ragdxadi guial ad nünbeetidi xtiidx Dios ad nünbee tëëtidi xhienaag na̱j xguialrniabeeman! ");
INSERT INTO zasNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Din chi yaban ree bengüt, ad zuxhliaatri reeman ad zudëëd tëëtri xiꞌn reeman guxhliaa, ma gac reeman ziꞌc ree anjl yuꞌ xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Abiꞌ xcwent ni yaban ree bengüt, ¿gadidi gool ya lod ca guial Dios gajc rëb: ");
INSERT INTO zasNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Naj na̱j xDios Abraham, xDios Isaac në xDios Jacob”? Abiꞌ Dios ad najtaman xDios ree bengüt, najman xDios ree bén naban. ");
INSERT INTO zasNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Chi biguiejn ree bejn zian, dád badxaloj reeman ziꞌc rulüüman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Chi gogbee ree bénfarisew guial achet badxejl niëjb ree bénsadusew loj Jesús, dxel bayaꞌn reeman diidx badxaag lasaꞌ reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Abiꞌ tijb ree bénfarisew guin, bén na̱j mextr rajc ley, gunabdiidxaman loj Jesús din guidoon xhie guiëbaman, rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Mextr, ¿con mandamientan mazri zojbloj loj gra ree mandamient ni zëëd loj ley? ");
INSERT INTO zasNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Badxiꞌ Jesúsan rëbaman: ―“Guyën xDadil Dios guidiblagaa guidib guijc guidib ladxil.” ");
INSERT INTO zasNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Laan na̱j mandamient mazri zojbloj. ");
INSERT INTO zasNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ziangajc na̱j mandamient rarojp ni rëb: “Guyën ree bejn ziꞌc rën lüj gajc.” ");
INSERT INTO zasNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Con grop ree mandamient guie, ma cayüjn bejn cumplid gra ley bacaa Moisejs në ree ni bacaa ree bén badëë xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Laꞌtgaj nadxag lasaꞌ ree bénfarisew guin, gunabdiidx Jesús loj reeman, rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―¿Xhie xgab rüjndi por Cristo? ¿Chu loj xdiaa zaman? Badxiꞌ reeman laan rëb reeman: ―Loj xdiaa Davi. ");
INSERT INTO zasNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Dxel rëb Jesús loj reeman: ―Per, ¿chexquiza zeel por xSprijt Dios rëb Davi lojman, Dad? Din Davi rëb: ");
INSERT INTO zasNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Dios rëb loj bén rniabee naj: “Gurej da ladbeen, xt gabecan xin rdxeꞌch ree lüj guiaꞌl.” ");
INSERT INTO zasNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Yan, bal xiꞌn Davi na̱j Cristo, ¿chexquiza zeel rëb Davi lojman Dad? ");
INSERT INTO zasNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Achutczi gojc nadxiꞌ xtiidx Jesús, niꞌczi tijb diidx. Abiꞌ diizd dxejzii achutczi bayax niniabdiidx xhienin lojman. ");
INSERT INTO zasNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Rëb Jesús loj ree bejn në loj ree xbejnman: ");
INSERT INTO zasNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Mextr rajc ree ley con ree bénfarisew rulüü reeman xhie rën guiëb ni ca loj xley Moisejs. ");
INSERT INTO zasNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Zeel gol bazoob xtiidx reeman, gol been tëë gra ni na reeman lojdi, per ad güündi ziꞌc rüjn reeman, din laa reeman ni ren na reeman abiꞌ ni ren rüjn reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Rniabee reeman güün bejn ni nawëëg daꞌt, per rniabeezi reeman güün bejn zian, guiáad laa reeman niꞌqui taꞌn ad rüjnt reeman bejn yudar din güün reeman ziꞌc rën reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Gra ni rüjn reeman, rüjn reeman laan din yadxaloj bejn laa reeman. Ruladx reeman guixhii lucwaj reeman në xuꞌc reeman tijb cint ni ca xtiidx Dios loj, ruladx tëë reeman gacw reeman lajd zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ruladx reeman cwe reeman lod rayal rbej ree bén zojbloj, loj tijb guialraw, abiꞌ ziangajc rüjn reeman lën ree yadoo. ");
INSERT INTO zasNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ruladx tëë reeman gugajpdioz bejn laa reeman zagdxe niz lunejz guiëb tëë reeman loj reeman mextr. ");
INSERT INTO zasNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Per lëjt ad sëëbladxidi guiniee bejn lëjt mextr, din tijbzi na̱j gradi, tijbzi mextr rajpidi abiꞌ laaman na̱j Cristo. ");
INSERT INTO zasNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Niꞌqui tijb loj bénguidxliuj, bén ad najt xdadidi, ad guiëbidi dad, din tijbzi xdadidi yuꞌ, laaman yuꞌ xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ad güün tëëdi naguiejn yayagbee ree bejn lëjt ziꞌc bén rniabee, din tijbzi bén rniabee yuꞌ, laaman na̱j Cristo. ");
INSERT INTO zasNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Bén mazri zojbloj lojdi, laaman rayal güün sirv lojdi. ");
INSERT INTO zasNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Din bén rlies xvalor gajc achet lasajcaman. Guiáad bén rüjn naya, zajs xvaloraman. ");
INSERT INTO zasNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Probza lëjt mextr rajc ley në lëjt bénfarisew, bén rusquiee!, ad rtiëjbtidi gagbee ree bejn xhienaag din gac reeman xbejn Dios, niꞌquiza lëjt ad rüjntidi naguiejn gaquidi xbejn Dios, abiꞌ rudxoondi gac xbejn Dios bén rën ree gac xbejnman. ");
INSERT INTO zasNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Probza lëjt mextr rajc ley në lëjt bénfarisew, bén rusquiee!, din racaꞌdi lidx ree béngunaa bizëjb, abiꞌ din guiëb bejn guial benzaꞌc lëjt dád xchej rbejdx rniabidi Dios. Zeel mazri castiroꞌ yayalidi. ");
INSERT INTO zasNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Probza lëjt mextr rajc ley në lëjt bénfarisew, bén rusquiee!, zizadi guidibdoo rguiilidi bén gac ree xbejndi, abiꞌ chi ma beendi gan tijbaman al mazri xiꞌn xindxab rüjndi laaman guial lojdi. ");
INSERT INTO zasNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Probza lëjt, bénlutiaꞌp!, rëbidi: “Achet güünan bal id züjn bejn ni guneeman, majsi ma bazaꞌtaman yadooroꞌ Jerusalén, per bal guzaꞌtaman ni or yuꞌ ree lën yadoo guin, dxel ma rüjn naguiejn güünman ni guneeman.” ");
INSERT INTO zasNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Natontidi, wed natiaꞌp lojdi! ¿Conin mazri lasajc: Or guin ya o yadoo beenleꞌ or guin? ");
INSERT INTO zasNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Rëb tëëdi: “Achet güünan bal id züjn bejn ni guneeman majsi ma bazaꞌtaman xialtar yadoo guin, per bal guzaꞌtaman gon dxiib loj altar guin, rüjn naguiejn güünman ni guneeman.” ");
INSERT INTO zasNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Bénlutiaꞌp! ¿Conin mazri lasajc par lëjt: Gon guin ya o altar beenleꞌ gon guin? ");
INSERT INTO zasNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Bén ruzaꞌt altar guin ad altar guintzan ruzaꞌtaman, nëgajc gra ni dxiib lojn ruzaꞌtaman. ");
INSERT INTO zasNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Guiáad bén ruzaꞌt yadoo guin, ad yadoo guintzan ruzaꞌtaman, Diosan ruzaꞌtaman din lidxaman na̱j yadoo guin. ");
INSERT INTO zasNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Abiꞌ bén ruzaꞌt xanyabaa, Diosan ruzaꞌtaman në lod zojbaman. ");
INSERT INTO zasNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Probza lëjt mextr rajc ley në lëjt bénfarisew, bén rusquiee!, rbëëcadi bidxtil, anís nëtëë comin ni rayal gudëëdi loj Dios, abiꞌ ad ruzoobtidi xley Moisejs ni mazri zojbloj, ad rüjntidi ziꞌc rayal, ad rayat lasaꞌdi, ad zaꞌdxiꞌch tëëtidi loj xnejz Dios. Laa reen rayal güündi, per ad cwëëladxidi gudëëdi ni rayal loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Bénlutiaꞌp, rajpidi cudad chitëë guiëbidi tijb bizëdlajs, abiꞌ rguiëjbidi tijb camell! ");
INSERT INTO zasNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Probza lëjt mextr rajc ley në lëjt bénfarisew, bén rusquiee!, rusiadi xijch ree vajs në xijch ree pliajt na̱j nadxuudx, guiáad luxdoodi guidxa ni dxuudx, në guialgubaan nëtëë guialrdxeꞌch lasaꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Bénfarisew lutiaꞌp: Yalojxgaj gol basia, zian guiguien waliquidi nayadi loj Dios! ");
INSERT INTO zasNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Probza lëjt mextr rajc ley në lëjt bénfarisew, bén rusquiee!, najdi ziꞌc baa nayëꞌ culor naquich, guijcan rguien nix daꞌt, per lënan guidxa ree xdxijt bengüt në graloj ree ni dxuudx. ");
INSERT INTO zasNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Zian najdi, niz loj ree bejn, rulüüdi benzaꞌc, per luxdoodi guidxa guialrusquiee në guialnaladx. ");
INSERT INTO zasNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Probza lëjt mextr rajc ley në lëjt bénfarisew, bén rusquiee!, rüjndi xbaa ree bén badëë xtiidx Dios loj ree bejn, abiꞌ rüjnchaawidi xbaa ree bén goc benzaꞌc, ");
INSERT INTO zasNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","dxel rëbidi: “Bal nabajnan xtiamp ree dux béngulalan, ad nët dunujn nagüjt bén badëë ree xtiidx Dios loj ree bejn.” ");
INSERT INTO zasNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Abiꞌ con ni guin ree, rayünbeegajquidi guial loj xdiaa bén bagüjt ree bén badëë xtiidx Dios loj ree bejn zëëdidi. ");
INSERT INTO zasNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Gol balooxza ni guzuloj been xbéngulalidi! ");
INSERT INTO zasNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Béndol, xiꞌn xindxab! ¿Xhienaag laadi loj castiroꞌ ni yuꞌ gabijl? ");
INSERT INTO zasNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Zeel gaxhalan lojdi bén gudëë ree xtiidx Dios, bén rajc ree në ree mextr. Per yuꞌ reeman gugüjtidi, yuꞌ reeman gucaadi loj crüjz, yuꞌ tëë reeman quindi lën ree xyadoodi abiꞌ sunalidi laa reeman guiedx por guiedx din güündi laa reeman xhienin. ");
INSERT INTO zasNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Zianan zeel guijquidi yab xtol gra ree bén bagüjt bén goc ree benzaꞌc diizd Abel bén guban xnejz loj Dios xt Zacarías xiꞌn Berequías, bén bagüjt reeman luleꞌ yadooroꞌ Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Diidxliczi rnin lëjt, xcasti gra ree ni guin yab guijc ree bén rigaꞌ loj guidxliuj yan. ");
INSERT INTO zasNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Rëb tëë Jesús: ―¡Bén Jerusalén, bén Jerusalén, rugüjtidi bén rudëë ree xtiidx Dios loj ree bejn abiꞌ rucaaguiajdi bén rxhiaal Dios lojdi! ¡Bëlczi volt guyënan nuchagan lasaꞌdi, ziꞌc rüjn tijb gui̱d ruchajg lasaꞌ ree xiꞌnb lën xhiilib, per ad gutiëjbtidi! ");
INSERT INTO zasNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Zianan zeel yayaꞌn ladxidi ziꞌc tijb guiedx lod achut zojb. ");
INSERT INTO zasNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Abiꞌ rnin lëjt diizd yan ad zuguiaatridi naj, xt chi guidxin dxej guiëbidi: “¡Nüjnleꞌ Dios bén guxhaalaman!” ");
INSERT INTO zasNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Chi barii Jesús lën yadooroꞌ Jerusalén, ziaman, bibig ree xbejnman lojman balüü reeman gra ree xyu yadoo guin lojman. ");
INSERT INTO zasNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Abiꞌ rëb Jesús loj reeman: ―Diidxliczi rnin, gra ni cuguiaadi yuꞌ dxej niꞌqui tijb guiaj guin ad zayaꞌnt guijc stijban, gran yazeꞌn. ");
INSERT INTO zasNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Laꞌtgaj zojb Jesús guijc guiaꞌ la Olivos, gubig ree xbejnman lojman, rëb reeman: ―Rayënan nal goc gac zian. ¿Xhie ree sen gac chi ma zidyob guiꞌtil stijb, në chi ma zidyob nit guidxliuj? ");
INSERT INTO zasNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Dxel rëb Jesús loj reeman: ―Gol gojp cudad achu gusquiee lëjt. ");
INSERT INTO zasNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Din zien ree bejn guiꞌt guiëb reeman guial por naj zëëd reeman, guiëb tëë reeman: “Naj na̱j Cristo”, abiꞌ zien bejn gusquiee reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Per lëjt chi guiguiejndi cayajc wadijl o zëëb diidx guial gac wadijl, ad guidxebidi din zian na̱j gac. Per ad wadxint dxej nit guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Din til nacion con stijb nacion, në bén rajp guialrniabee con stijb bén rajp guialrniabee. Abiꞌ guiꞌt xudoxh në gubijn niz ni niz guie. ");
INSERT INTO zasNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Gra ree nine ree gac chi ma suloj guialzi guin. ");
INSERT INTO zasNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Dxel yayü ree bejn lëjt loj ree bén gusagzi lëjt, gugüjt reeman lëjt, abiꞌ gra ree bénguidxliuj guidxeꞌch lëjt guial najdi da bejnan. ");
INSERT INTO zasNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Chi gac zian zien ree bejn gusaꞌn guialrliladx reeman naj, guidxeꞌch lasaꞌ reeman abiꞌ yayü lasaꞌ reeman loj ree bén ralen laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Guiꞌt tëë zien ree bén gusquiee, guiëb reeman guial rudëëd reeman xtiidx Dios, abiꞌ zien bejn gusquiee reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Abiꞌ guial dád zien ni mal gac, zien daꞌt bén ad zëntri ree lasaꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Per bén sudxiꞌch loj guialrliladxaman naj, xt dxej chigra guibanman, laaman yayal xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Abiꞌ xtiidx Dios ni canin lëjt yan guireꞌchan guidibczi guidxliuj din gagbee gra bejnan, dxelri nit guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Zianan zeel chi guguiaadi zojb tijb ni dxuudx, ni ad rüjnt sirv lën yadooroꞌ Jerusalén, ziꞌc gunee Daniel bén badëë xtiidx Dios loj ree bejn (bén gool guiꞌch guie ree, gol bigniaꞌ), ");
INSERT INTO zasNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","guial bén zojb ree Judea rayal guxüün reeman che reeman dajn. ");
INSERT INTO zasNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Guiáad ree bén yëꞌp guijc yulidx dxejzii, ad yayu lënülidx reeman par tiaꞌ xhie xieen reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Abiꞌ ree bén zaꞌ dajn, ad yayejc reeman chigxii xab reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Probza ree béngunaa nüü xiꞌn o bén caꞌ ree xindobëz lën ree dxejzii! ");
INSERT INTO zasNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Gol gurejdx gunab Dios chitëë gac zian tiamp nayaag o dxej raziiladx ree bejn ya. ");
INSERT INTO zasNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Din nadxel dád guialziroꞌ chuꞌ, ziꞌc ad wayajctczi diizd guiaꞌxchej chi gad guidxliuj gacchaaw ad yuꞌ tëët dxej gac zian. ");
INSERT INTO zasNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Abiꞌ bal id Dios gucwëëz guialzi chuꞌ lën ree dxej guin, niꞌqui tijb bejn ad zalaat, per gucwëëzaman laa reen por ree bén guleman. ");
INSERT INTO zasNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Lën ree dxejzii bal chu na lojdi: “Gol baguiaa, laa Cristo zaꞌ guie”, o “Gol baguiaa laaman zaꞌ ni”, ad bal chililadxidi. ");
INSERT INTO zasNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Din ziꞌt zien ree bén gusquiee na guial laa reeman na̱j bén guxhaal Dios o na reeman guial laa reeman na̱j bén rudëëd xtiidx Dios. Abiꞌ züjn reeman milagr ree në graloj ni yadxaloj bejn din gusquiee reeman laa reeman, abiꞌ bal zileꞌn xt në ree bén gulej Dios gusquiee reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ma rni xgajn lojdi ni gac. ");
INSERT INTO zasNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Zeel bal chu na lojdi: “Gol baguiaa laa Cristo zaꞌ niz loj yujbidx”, ad bal chedi o na reeman lojdi: “Laa Cristo yuꞌ lënü ni”, ad bal chililadxidi. ");
INSERT INTO zasNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Din ziꞌc chi rëꞌp nijs, abiꞌ rulaan bachaꞌ niz lod rliejn gubijdx xt lod rëëzan, ziangajc gac dxej guiꞌt Bén guxhaal Dios stijb. ");
INSERT INTO zasNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Bén rliladx ree naj guiꞌt reeman lon, ziꞌc chi radoꞌp ree golbich lod nagaꞌ tijb begüt. ");
INSERT INTO zasNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Chi ma gudëd ree dxej ni gac ree guialzi guin, guicajy loj gubijdx, ad zusnit bëëw, guiyajb ree bajl xanyabaa abiꞌ gra ree ni yuꞌ xanyabaa guiniib. ");
INSERT INTO zasNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Dxel guiguien tijb sen xanyabaa guial ma guiꞌt Bén guxhaal Dios. Abiꞌ gra ree bénguidxliuj goon daꞌt chi guguiaa reeman Bén guxhaal Dios, rdiinman bachaꞌ zëëdaman loj za̱j con xguialrniabeeman. ");
INSERT INTO zasNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Dxel guixhiaal ree xianjlaman, abiꞌ rejs daꞌt gucwejdx reeman trompejt, din yadxajg lasaꞌ ree bén guleman, bén zaꞌ ree gralad guidiblagaa guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Yan, gol baguiaa xhienaag rajc con tijb yag higo. Chi ma naquieꞌn xidxan, chi ma caydxib ree xbalagan, lëjt ragbee guial ma zëëd tiamp nalaa. ");
INSERT INTO zasNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ziangajc chi guguiaadi ma cayajc ree ni guin, gagbeedi guial ma zidyob gac ziꞌc rnin lëjt. ");
INSERT INTO zasNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Diidxliczi rnin lëjt guial gra ree ni guin gac chi gad ree bén naban yan guiët. ");
INSERT INTO zasNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Guidxliuj në xanyabaa zanijt reen, per da diidxan ad zanijttan. ");
INSERT INTO zasNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Per achut ragbee xhie dxejn në xhie horan gac zian, niꞌqui ree anjl yuꞌ xanyabaa, niꞌqui Xiꞌn Dios ad ragbeet. Tijbzi da Dadan Dios ragbee. ");
INSERT INTO zasNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Ziꞌc goc gulal chi guban Noé, zian gac chi yaguiaad Bén guxhaal Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Din chi gad Dios guixhiaal guiadoxh loj guidxliuj, bejn ree, raw reeman, rëꞌ reeman, ruxhliaa reeman, rudëë tëë xiꞌn reeman ruxhliaa, xt chi bidxin dxej guyu Noé lën barcwroꞌ ni beenman. ");
INSERT INTO zasNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Abiꞌ ad bidxgatczi reeman, dxejlczi gol guiadoxh abiꞌ zinë nijs laa reeman, ziangajc gac chi yaguiaad Bén guxhaal Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Dxej guin, lod zaꞌ tioꞌp ree xinguiaaw dajn, tijbix yaza, stijbix yayaꞌn. ");
INSERT INTO zasNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Guiáad lod cayojt tioꞌp ree béngunaa, tijbaman yaza, stijbaman yayaꞌn. ");
INSERT INTO zasNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Zeel gol guzujsin din ad ragbeetidi xhie dxej yaguiaad xDadidi. ");
INSERT INTO zasNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Gol been xgab, bal tijb bejn ragbee xhie guxhin xhie tëë horan chuꞌ xingubaan lidxaman cwanx, zabejnaaman abiꞌ ad zatiëjbtaman chuꞌ xingubaan guin lidxaman. ");
INSERT INTO zasNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Zianan zeel gol guzujsin, din ad ragbeetidi dxejlczi yaguiaad Bén guxhaal Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Chu lëjt na̱j ziꞌc tijb mojs rusaꞌn xpatronx lidxaman din gulenx gra ree mojs, gudëë tëëx ni gaw reeman chi gal hor? ");
INSERT INTO zasNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Xiquilbaa mojs cayüjn dxiin ziꞌc rayal chi yadxin xpatronx. ");
INSERT INTO zasNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Din diidxliczi rnin lëjt, patron guin zusaꞌn gra xieenman loj mojs guin. ");
INSERT INTO zasNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Per bal na̱j mojs guin mojs dxuudx, naladxix: “Zaglaari da patronan.” ");
INSERT INTO zasNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Zianz suloj gusagzix los demazri ree mojs guin, suloj gawix, guiëꞌnë tëëx xinguꞌ ree. ");
INSERT INTO zasNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Abiꞌ yadxin xpatronx tijb dxej ni ad ragbeetix ad rbëz tëëtix laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Dxel dád castiroꞌ gudëëd patron guin laax, guixhiaal tëëman laax lod rayal ree bén rusquiee, lod goonx gaw tëë layix. ");
INSERT INTO zasNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Basnuu Jesús rëbaman: ―Loj xguialrniabee Dios gac ziꞌc guzac ree chii biinxdüb we loj tijb guialruxhliaa cwaꞌ tijbgaj xguij reem bilëz reem xin cuxhliaa guin. ");
INSERT INTO zasNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Gaay reem been xgab xhie güün reem, per za gaay reem ad beent xgab. ");
INSERT INTO zasNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Biin ad beent ree xgab guin binë xguij reem per ad binët reem mazri sejt ni cheꞌcnë ree guij guin. ");
INSERT INTO zasNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Guiáad ree biin been xgab guin xhie güün reem, binë reem za tib lumejtgaj sejt con xguij reem. ");
INSERT INTO zasNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Abiꞌ guial goglaa badxin xinruxhliaa guin, biꞌt bacaal loj gra reem, abiꞌ goodyëjs reem. ");
INSERT INTO zasNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Cost garol guiaal, biguien chaꞌ tijb bejn rëbaman: “¡Laa xinruxhliaa guin ma ziaad, gol tagchaaglojx!” ");
INSERT INTO zasNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Dxel bixche gra ree biinxdüb guin, abiꞌ beenchaaw xguij reem. ");
INSERT INTO zasNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Abiꞌ gaay ree biin ad beent xgab guin xhie güün reem, rëb reem loj za gaay biin been xgab guin: “Gol baneesii tibdaꞌn xsejtidi, din dux guijn ma cayüꞌ reen.” ");
INSERT INTO zasNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Per badxiꞌ reemin rëb reem: “Yajqui, din dool ad zadaantan par lëjt niꞌqui par dunujn. Zagdxeli gol wëj lod rdoꞌn din siidan par lëjt gajc.” ");
INSERT INTO zasNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Abiꞌ laꞌtgaj zë reem zisii reem sejt, bidxin xinruxhliaa guin, abiꞌ za gaay ree biin been xgab guin guyunë reem laax loj guialruxhliaa guin dxel bidaꞌcw roꞌ port. ");
INSERT INTO zasNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Dxel chi badxin za gaay biin bisii ree sejt guin, rëb reem: “¡Dad, dad, guxhal din yadxuꞌn!” ");
INSERT INTO zasNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Per badxiꞌxan rëbix: “Diidxliczi rnin, ad nünbeetan lëjt.” ");
INSERT INTO zasNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Dxel basnuu Jesús rëbaman: ―Zeel gol guzusin din ad ragbeetidi goc yaguiaad Bén guxhaal Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Dxel rëb tëë Jesús: ―Xguialrniabee Dios na̱j ziꞌc tijb bén ma grii cheman zijt, abiꞌ gurejdx ree xmojsaman, basaꞌn xmiliaman loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Loj tijbaman badëëman gaay mil cintabl, loj zatijbaman badëëman zatioꞌp milan, guiáad loj zatijbaman badëëman za timilan. Loj tijbgaj reeman badëëdaman ni naladxaman zajc güünnë reeman dxiin, dxel briitaman zëman zijt. ");
INSERT INTO zasNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Abiꞌ mojs cwaꞌ gaay mil cintabl guin beennëman laan dxiin abiꞌ beenman gan za ziant gajcan. ");
INSERT INTO zasNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ziangajc been mojs cwaꞌ tioꞌp milan, beenman gan za tioꞌp mil gajcan. ");
INSERT INTO zasNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Per mojs cwaꞌ timil cintabl guin bitëënman luyuj persi baquieꞌchaman cintabl guin ni badëëd xpatronman. ");
INSERT INTO zasNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Gojc xchej daꞌt dxel badxin patron guin abiꞌ babëëman cwent con la reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yaloj bidxin mojs cwaꞌ gaay mil cintabl guin abiꞌ bayüman zagaay milan, rëbaman: “Dad, lüj banee gaay milan lon, yan, laa za gaay milan guie ni benan gan.” ");
INSERT INTO zasNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Dxel rëb patron guin lojman: “Zagdxen, mojszaꞌc, zagdxe beenl, guial zagdxe beenl con tibdaꞌn ni banen, yan, gunen mazri guial loj ni banen. Guyu, babaa con naj.” ");
INSERT INTO zasNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Zianz bidxin mojs cwaꞌ zatioꞌp mil cintabl guin rëbaman: “Dad, lüj banee tioꞌp milan lon, yan, laa zatioꞌp milan guie ni benan gan.” ");
INSERT INTO zasNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Dxel rëb patron guin lojman: “Zagdxen, mojszaꞌc, zagdxe beenl, guial zagdxe beenl con tibdaꞌn ni banen, yan, gunen mazri guial loj ni banen. Guyu, babaa con naj.” ");
INSERT INTO zasNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Per chi bidxin mojs cwaꞌ timil cintabl guin, rëb loj xpatronman: “Dad, naj ragbee guial ad rayatil bejn, rabëël guialnazaꞌc lod ad rguꞌtil bin, ratoꞌp tëël guialnazaꞌc lod ad rtieꞌchtil bin. ");
INSERT INTO zasNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Zeel bidxeban abiꞌ biquiechan xmilial lën liuj, yan, laa xmilial guie.” ");
INSERT INTO zasNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Badxiꞌ patron guinan, rëbaman: “Mojs mal, mojs ploj, bal ragbeel rabën guialnazaꞌc lod ad rguꞌtan bin, ratop tëën guialnazaꞌc lod ad rtiechtan bin. ");
INSERT INTO zasNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Adil niluꞌ da milian lën bancw, din chi naguialan nacaꞌnan con xiꞌnan ni beenan gan.” ");
INSERT INTO zasNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Dxel rëb patron guin loj ree bén zaꞌ yagaj: “Gol biquied timil cintabl guin lojx, gol badëëdan loj xin rajp chii milan. ");
INSERT INTO zasNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Din bén rajp zacaꞌman mazri, abiꞌ gapaman zroꞌ daꞌt, per bén rajp taꞌnzi, xt ni rajpaman chiquied lojman. ");
INSERT INTO zasNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Abiꞌ mojs ad rünjt sirv guin gol bazaalix xchuni lod nacay, lod goonx, lod gaw tëë layix.” ");
INSERT INTO zasNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Chi guiꞌt Bén guxhaal Dios, guiꞌtaman con xguialrniabeeman, në con gra ree xianjlaman din cweman lod nabeeman. ");
INSERT INTO zasNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dxel gra ree bénguidxliuj yadoꞌp lojman, abiꞌ cweman laa reeman ziꞌc rüjn tijb bén rajp xiil chi rabëëcaman xiil ree loj ree dxib. ");
INSERT INTO zasNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Abiꞌ guzujman bén na̱j ree xbejnman xladbeeman, guiáad ree bén ad najt xbejnman guzujman xladruvejsaman. ");
INSERT INTO zasNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Dxel guiëb rey guin loj ree bén zaꞌ xladbeeman: “Gol guda bén ma nüjnleꞌ da Dadan. Gol guyu loj guialrniabee najcchaaw par lëjt, diizd chi goꞌtchaaw guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Din chi gulaanan, baneedi ni gudawan, chi weꞌcan nijs, baneedi ni guꞌn, chi bizaan ziꞌc tijb benzit, baneedi lod bayaꞌnan. ");
INSERT INTO zasNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Chi byaadx da xaban, lëjt banee ni goꞌtan, chi gogxuun, bidgatixlojdi naj, abiꞌ chi guyuꞌn ladxguiib, bidganajdi naj.” ");
INSERT INTO zasNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Dxel guiëb ree bén zaꞌ ladbee guin: “Dad, ¿goc baguiaan lüj rliaanl, abiꞌ baneen ni gudawil?, ¿o goc baguiaan lüj weꞌquil nijs, abiꞌ baneen nijs guꞌl? ");
INSERT INTO zasNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Goc baguiaan lüj zizal ziꞌc tijb benzit, abiꞌ baneen lod bayaꞌnl, o goc biyaadx xabil, abiꞌ baneen ni gotil? ");
INSERT INTO zasNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Abiꞌ goc baguiaan lüj ragxuul, o guyul ladxguiib, abiꞌ budganajn lüj?” ");
INSERT INTO zasNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Dxel guiëb rey guin loj reeman: “Diidxliczi rnin lojdi, gra yudar beendi da bejn reen majsi ad najt reeman bén lasajc, najn beendi yudar.” ");
INSERT INTO zasNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Dxel guiëbaman loj ree bén zaꞌ xladruvejsaman: “Gol biquied lon, benmal gol chej loj bajl ni ad yuꞌt dxej yayüꞌ ni ma na̱j par xindxab në ree xbejnx. ");
INSERT INTO zasNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Din chi gulaanan, ad baneetidi ni niawan, chi weꞌcan nijs, ad baneetidi ni niëꞌn. ");
INSERT INTO zasNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Chi bizaan ziꞌc benzit, ad baneetidi lod nayaꞌnan, chi biyaadx da xaban, ad baneetidi ni niaꞌcwan. Abiꞌ chi gogxuun në chi guyuꞌn ladxguiib, ad bidganajtidi naj.” ");
INSERT INTO zasNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Dxel guiëb reeman lojman: “Dad, ¿goc baguiaan lüj rliaanl o reꞌquil nijs, o zizal ziꞌc tijb benzit, o goc baguiaan lüj ryaadx xabil, o ragxuul, o yuꞌl ladxguiib, abiꞌ ad bayidxgaꞌtan lüj?” ");
INSERT INTO zasNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Abiꞌ yadxiꞌman laan guiëbaman: “Diidxliczi rnin lëjt, gra ni ad beentidi din nüjndi yudar da bejn reen majsi ad najt reeman bén lasajc, najn ad beentidi yudar.” ");
INSERT INTO zasNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Laa reeman yayal loj casti tiblayaa, guiáad ree bén been ziꞌc rayal, laa reeman rayal guialnaban tiblayaa con Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Chi gulox gunee Jesús diidx guin ree, dxel rëb loj ree xbejnman: ");
INSERT INTO zasNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Lëjt ragbee guial ryaadx zatioꞌp dxejzi guial guidxin lanij pascw, abiꞌ Bén guxhaal Dios yayü ree bejn laaman din tiaman loj crüjz. ");
INSERT INTO zasNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Lën ree dxejzii badxaag lasaꞌ ree bixhioz rniabee ree bixhioz, con xguxtis ree bén Israel, lidx Caifás quijb bixhioz zojbloj. ");
INSERT INTO zasNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ni bayaꞌn reeman diidx xhienaag gusquiee reeman Jesús din guiniaaz reeman laaman, abiꞌ gugüjt reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Per rëb reeman: ―Ad zaguieent ree zian loj lanij guin chitëë gac naquieꞌ luguiedx guin. ");
INSERT INTO zasNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Chi zaꞌ Jesús luguiedx Betania lidx Simón, bén rniee reeman Leproso, ");
INSERT INTO zasNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","bidxin tijb béngunaa caꞌman tijb lumejt guidxan perfum ni lasajc wayëjx. Abiꞌ laꞌtgaj zojb Jesús xan mex, baroobaman perfum guin guijc Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Chi baguiaa ree xbejn Jesús ni been béngunaa guin, dád bidxeꞌch reeman, abiꞌ rëb reeman: ―¿Chexc zeel bixieꞌ perfum guin? ");
INSERT INTO zasNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Zileꞌ nidoꞌn zroꞌ daꞌt din nüjnan yudar bénprob ree. ");
INSERT INTO zasNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Chi biguiejn Jesús ni canee reeman, rëbaman loj reeman: ―¿Chexc zeel rdxeꞌchidi béngunaa guin? Zagdxe na̱j ni beenman naj. ");
INSERT INTO zasNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Din bénprob guin ree zianczi zaꞌnë reeman lëjt, saꞌn naj ad ziantczi gazunëꞌn lëjt. ");
INSERT INTO zasNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Abiꞌ ni baroobaman perfum guin guican, rën guiëban guial ma beenchaaw xgajman naj par chi guiguieꞌchan. ");
INSERT INTO zasNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Diidxliczi rnin, bantëëz guin guireꞌch xtiidxzaꞌc Dios loj guidxliuj, zü ree bejn gra ni been béngunaa guin por naj, din gusaaladx reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Loj guidxiptioꞌp ree xbejn Jesús, bén la Judas Iscariote, bigneenëman bixhioz rniabee ree bixhioz, ");
INSERT INTO zasNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","rëbaman loj reeman: ―¿Plac guneedi din yanen Jesús lojdi? Abiꞌ badëëd reeman gajlbichii milia plajt lojman. ");
INSERT INTO zasNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Diizd dxejzii guzulojman raguiilaman mod xhienaag yayüman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Dxej ni guzuloj lanij ni raw ree bejn guiadxtil ni ad yuꞌt levadur, gubig ree xbejn Jesús lojman, rëb reeman: ―¿Ban guin rënl yaguieenchaawan ni yadaaw ree guxhin lanij pascw? ");
INSERT INTO zasNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Badxiꞌ Jesúsan rëbaman: ―Gol chej Jerusalén lidx bén guin, gol biguiedx lojman: “Na Mextr: Ma bidxin xihoraman abiꞌ rënman tëdaman pascw lidxil con ree xbejnman.” ");
INSERT INTO zasNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Dxel been ree xbejnman ziꞌc rëbaman, been tëë reeman ni gaw reeman guxhin lanij pascw. ");
INSERT INTO zasNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Chi gure guiaal, zojb Jesús xan mex con guidxiptioꞌp ree xbejnman. ");
INSERT INTO zasNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Abiꞌ laꞌtgaj cayaw reeman, rëbaman loj reeman: ―Diidxliczi rnin, tijb gajc lëjt yayü naj. ");
INSERT INTO zasNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Abiꞌ dád guyunaya reeman, zianz guzuloj rniabdiidx tijbgaj reeman loj Jesús, rëb reeman: ―¿Najn ya, Dad? ");
INSERT INTO zasNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Badxiꞌ Jesúsan, rëbaman: ―Bén cayaw loj pliajt ni cayaw gajcan, laaman yayü naj. ");
INSERT INTO zasNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Walican, Bén guxhaal Dios na̱j guial sacaman ziꞌc rëb loj xtiidx Dios. Per ¡probza bén yayü laaman!, zagdxeli na̱j par laaman ad niutaman loj guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Dxel Judas bén yayü Jesús, gunabdiidxaman rëbaman: ―Mextr, ¿wen najn ya? Badxiꞌ Jesúsan, rëbaman: ―Lüjn. ");
INSERT INTO zasNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Laꞌtgaj cayaw reeman, cwaꞌ Jesús guiadxtil, badëëdaman quixtëë loj Dios. Dxel gulaꞌman guiadxtil guin gudiꞌsaman laan loj ree xbejnman, rëbgajman: ―Gol gudaw guiadxtil guie, laan na̱j da cuerpan. ");
INSERT INTO zasNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Dxel cwaꞌman tib cojp vin, chi gulox badëëdaman quixtëë loj Dios, badëëdaman cojp guin loj reeman, rëbgajman: ―Gol guꞌ gradi loj cojp guie. ");
INSERT INTO zasNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Din laan na̱j da rejnan ni gaxhieꞌn chi guiëtan por zien ree bénguidxliuj. Din por da guialgüjtan guixal tijb nejz cüb xhienaag gap ree bejn perdon loj Dios por xtol reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Abiꞌ diidxliczi rnin lëjt ad yuꞌtri dxej guiëꞌn vin rajcchaawnë uv, xt chi guidxin dxej guiëꞌnëꞌn lëjt vin cüb lod rniabee da Dadan. ");
INSERT INTO zasNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Chi gulox biil reeman tijb cant par Dios, dxel zë reeman guijc guiaꞌ Olivos. ");
INSERT INTO zasNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Abiꞌ rëb Jesús loj reeman: ―Gradi zabëëladx naj yan guxhin, ziꞌc ca loj xtiidx Dios lod rëb: “Gugüjtan bén rajp ree xiil, dxel guireꞌch ree xiil guin.” ");
INSERT INTO zasNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Per chi yabanan, yaloj naj ganeed ga gajn Galilea dxelri guiꞌtidi. ");
INSERT INTO zasNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Dxel rëb Bëd lojman: ―Majsi gra reeman cwëëladx lüj per naj ad yuꞌt dxej gabëladxan lüj. ");
INSERT INTO zasNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Per rëb Jesús lojman: ―Diidxliczi rnin lojl, yan guxhin gajc chi gad gui̱d cwidxaꞌ, mal rëbil choon volt guial ad nünbeetil naj. ");
INSERT INTO zasNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Abiꞌ rëb Bëd lojman: ―Majsi guiëtnëꞌn lüj, per ad yuꞌt dxej guiën guial ad nünbeetan lüj. Abiꞌ gra ree xbejn Jesús ziangajc rëb reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Chi bidxin Jesús con ree xbejnman tijb luar la Getsemaní, rëbaman loj reeman: ―Gol gurejsii guie, laꞌtgaj gan ni din gabedx ganaaban Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Dxel zinëman Bëd con grop ree xiꞌn Zebedeo, zianz guzuloj cayunayaman abiꞌ ad nixtri yuꞌ luxdooman. ");
INSERT INTO zasNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Zianz rëbaman loj reeman: ―Dád yuꞌnaya luxdoon, rulüü ma gugüjt guialyuꞌnaya guin naj. Gol bayaꞌn guie ad gaayëjsidi. ");
INSERT INTO zasNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Dxel zë Jesús mazri delant abiꞌ gurerulojman gurejdx gunabaman Dios, rëbaman: ―Dad, bal zileꞌ yabëël naj loj guialzi ni gadëëdan, per ad gac ziꞌc rënan, gac ziꞌc rënl. ");
INSERT INTO zasNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Dxel baguiajman lod zaꞌ ree xbejnman, abiꞌ baguiaaman nagaꞌyëjs reeman, zianz rëbaman loj Bëd: ―¿Wen niꞌqui tib hor ad bileꞌt natieꞌch xbacaalidi ya, din sunëdi naj? ");
INSERT INTO zasNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Gol batieꞌch xbacaalidi gol gurejdx gunab tëë Dios, chitëë güün xindxab lëjt gan, din rënquidi güündi ziꞌc rayal, per xcuerpidi ad rtiëjbtan. ");
INSERT INTO zasNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ni barojp volt wejman gurejdx gunabaman Dios, rëbaman: ―Dad, bal id zileꞌ tëd guialzi ni na̱j gadëëdan, bal rüjn naguiejn gadëëdanan gacri ziꞌc rënl. ");
INSERT INTO zasNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Chi badxinman lod zaꞌ ree xbejnman stijb, laa reeman naayëjs guial dád guidxa bacaal loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Dxel basaꞌnman laa reeman stijb, zëman, bayon volt cabejdx canabaman Dios con diidx guin gajc ree. ");
INSERT INTO zasNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Chi badxinman lod zaꞌ ree xbejnman, rëbaman loj reeman: ―¿Sta nagaꞌyëjsidi ya, cayziiladx tëëdi? Guiáad Bén guxhaal Dios ma bidxin hor yayü reeman laaman loj ree béndol. ");
INSERT INTO zasNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Gol bixche, yoꞌ ree, gol baguiaa laa bén yayü naj ma zëëd gajxh. ");
INSERT INTO zasNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sta caneenë Jesús bén na̱j ree xbejnman, chi bidxin Judas bén naj gajc tijb xbejn Jesús. Bidxinnëman zien ree bejn, caꞌ reeman espad në yag. Guxhaal ree bixhioz rniabee ree bixhioz con ree xguxtis ree bén Israel laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Abiꞌ Judas bén bayü laaman mal rëbxgajman loj ree bén guin: “Bén gawan xid xhajg, laaman raguiilidi, gol gunaazaman.” ");
INSERT INTO zasNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Chi bidxin Judas bibigaman loj Jesús, dxel rëbaman: ―¡Xchan, Mextr! Laa gudaw gajcaman xid xhajgaman. ");
INSERT INTO zasNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Abiꞌ rëb Jesús lojman: ―Judas, been ni zidguieenl. Dxel gubig ree bén guin, gunaaz reeman Jesús persi zinë reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Per tijb ree bén zaꞌnë Jesús yagaj, gulëë xiespadaman dxel gutüꞌman guidiajg xmojs quijb bixhioz zojbloj. ");
INSERT INTO zasNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Dxel rëb Jesús lojman: ―Baguꞌchaaw xiespadil xluaran. Din bén rdil con espad, con espad rëjtaman. ");
INSERT INTO zasNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Wen, id ragbeel ya guial zajc gabedx ganaab da Dadan, abiꞌ laa guixhiaal gajcaman por mil ree xianjlaman din gagnë reeman naj? ");
INSERT INTO zasNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Per ¿xoza gac cumplid ziꞌc ca loj xtiidx Dios ni rëb guial rüjn naguiejn gac ree ni cayajc? ");
INSERT INTO zasNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Loj hor guin gajc rëb Jesús loj ree benzien guin: ―¿Chexc zeel zëëdidi con espad në con yag din guiniaazidi naj ziꞌc tijb xingubaan? Guixie guixie guzunëꞌn lëjt lën yadooroꞌ Jerusalén balün lëjt xtiidx Dios, abiꞌ ad gunaaztidi naj. ");
INSERT INTO zasNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Per gra ree ni guie cayajc din gac cumplid ni bacaa ree bén badëë xtiidx Dios loj ree bejn. Loj hor guin gajc baxüün ree xbejn Jesús, guroꞌnladx reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bén gunaaz ree Jesús binë reeman laaman lidx Caifás, quijb bixhioz zojbloj, yagaj badxaag lasaꞌ ree mextr rajc ley con ree xguxtis ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Abiꞌ Bëd zijt zijt nalaman Jesús, xt luleꞌ lidx bixhioz guin. Dxel guyuman abiꞌ gurejnëman bén rajp ree lidx bixhioz guin, din guguiaaman xhie güünnë ree bén guin Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Guiáad ree bixhioz rniabee ree bixhioz con gra ree guxtis guin raguiil reeman xhie gusquiee reeman din gutediaꞌ reeman Jesús din nabee reeman guiëtaman. ");
INSERT INTO zasNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Per ad radxejlt xhienaag gutediaꞌ reeman laaman majsi zien ree bén basquiee. Dxel bibig zatioꞌp reeman, ");
INSERT INTO zasNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","rëb reeman: ―Bén guie rëb: “Zileꞌ yaseꞌnan xyadoo Dios abiꞌ loj choon dxejzi yayünanan.” ");
INSERT INTO zasNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Dxel guzuli quijb bixhioz zojbloj guin, rëbaman loj Jesús: ―¿Nid zadxiꞌlan ya? ¿Waliqui ni canee ree bén guin contr lüj ya? ");
INSERT INTO zasNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Per achet rëb Jesús. Dxel rëb bixhioz guin lojman: ―Por Dios bén naban, rniabeen lüj guna diidxli. Guna bal lüjn na̱j Cristo, Xiꞌn Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Badxiꞌ Jesúsan rëbaman: ―Waliquil. Rni tëën lëjt, zuguiaadi Bén guxhaal Dios zojbaman xladbee Dios bén rajp guialrniabee abiꞌ zuguiaa tëëdi guiꞌtaman loj za̱j xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Chi biguiejn bixhioz guin zian, gudixyaꞌ xabaman, rëbaman: ―Diosan caneeguijdx bén guin. ¿Xhie mazri rüjn naguiejn yadiil ree testiw? Lëjt gajc ma biguiejn guial rnieeguijdxaman Dios. ");
INSERT INTO zasNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yan, ¿xhie nadi? Badxiꞌ ree bén guinan rëb reeman: ―Rayal guiëtix. ");
INSERT INTO zasNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Dxel bacojp xhiejn reeman lojman, gudijn reeman laaman, yuꞌ tëë reeman wëëz roꞌman, ");
INSERT INTO zasNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","rëb reeman lojman: ―Bal lüjn na̱j Cristo, guneeyaꞌ chu gudin lüj. ");
INSERT INTO zasNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Laꞌtgaj zojb Bëd luleꞌ lidx bixhioz guin, gubig tijb biin rüjn dxiin yagaj, rëbim lojman: ―Në lüj nal Jesús, bén Galilea. ");
INSERT INTO zasNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Per Bëd gurexuuman, rëbaman niz loj gra reeman: ―Ad ragbeetan xhienin rnieel. ");
INSERT INTO zasNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Chi zëman niz roꞌ port baguiaa stijb biin rüjn dxiin yagaj laaman, abiꞌ rëbim loj ree bén rigaꞌ yagaj: ―Në bén guin nal Jesús bén Nazaret. ");
INSERT INTO zasNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Per Bëd gurexuuman stijb, xt bazaꞌtaman Dios, rëbaman: ―Ad nünbeetan bén guin. ");
INSERT INTO zasNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Dxel ad gojct xchej, gubig ree bén rigaꞌ yagaj loj Bëd, rëb reeman lojman: ―Laa rguien gajc në lüj na̱j xbejn reeman, din ziꞌcgajc rniee reeman rnieel. ");
INSERT INTO zasNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Per Bëd bazaꞌtaman Dios, rëbaman loj reeman: ―Dios gudëëd naj casti bal rusquieen, per ad nünbeetan bén guin. Hor guin gajc guridxaꞌ tijb gui̱d. ");
INSERT INTO zasNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Abiꞌ basaaladxaman guial rëb Jesús lojman: “Chi gad gui̱d cwidxaꞌ, mal rëbil choon volt ad nünbeetil naj.” Dxel barii Bëd yagaj abiꞌ dád naya biinman. ");
INSERT INTO zasNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Chi bani luyuj, gra ree bixhioz rniabee ree bixhioz con ree guxtis Israel bayaꞌn reeman diidx xhienaag güün reeman din guiët Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Dxel guxhii reeman laaman abiꞌ binë reeman laaman loj gobernador Pilato. ");
INSERT INTO zasNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Dxel Judas, bén bayü Jesús, chi baguiaaman guial ma na̱j guiët Jesús, guyunayaman, abiꞌ bayüman gajlbichii milia plajt guin loj ree bixhioz rniabee con loj ree guxtis Israel, ");
INSERT INTO zasNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","rëbaman loj reeman: ―Ma benan dol guial banen tijb bén achet dol rajp. Badxiꞌ reeman laan rëb reeman: ―Xhieczi yaguieenan, ¡lüj gunaj! ");
INSERT INTO zasNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Abiꞌ bazaal Judas milia guin lën yadooroꞌ Jerusalén zianz bariiman wejman bigxhii yëjnman. ");
INSERT INTO zasNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Dxel batoꞌp ree bixhioz rniabee guin milia guin, abiꞌ rëb reeman: ―Ad rayalt yadxeꞌ ree milia guin lën lod ru gon, din con laan bioꞌ bén guiët. ");
INSERT INTO zasNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dxel be reeman diidx, abiꞌ con milia guin guzii reeman xguidxliuj bén rüjn trast bajn ree, din gacan lod guiguieꞌch ree benzit. ");
INSERT INTO zasNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Zeel xt yan la guidxliuj guin Yuj Rejn. ");
INSERT INTO zasNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Zian gojc cumplid ni gunee Jeremías, bén badëë xtiidx Dios loj ree bejn, chi rëbaman: “Cwaꞌ reeman gajlbichii milia plajt, prejs ni rëb ree bén Israel lasajcaman, ");
INSERT INTO zasNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","abiꞌ con milia guin guzii reeman xguidxliuj bén rüjn trast bajn ree, ziꞌc gunabee Dios naj.” ");
INSERT INTO zasNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Dxel badxig reeman Jesús loj gobernador Pilato, abiꞌ gunabdiidxaman loj Jesús, rëbaman: ―¿Lüjn na̱j xrey ree bén Israel ya? Badxiꞌ Jesúsan, rëbaman: ―Najcan. ");
INSERT INTO zasNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Abiꞌ chi cutediaꞌ ree bixhioz rniabee ree bixhioz con ree guxtis Israel laaman, achetczi radxiꞌman. ");
INSERT INTO zasNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Dxel rëb Pilato lojman: ―¿Nid riguiejnl gra ni canee reeman contr lüj ya? ");
INSERT INTO zasNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Per Jesús niꞌqui tijb diidx ad badxiꞌtaman, zeel dád badxa loj gobernador guin. ");
INSERT INTO zasNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lën ree dxej lanij, ruslaa gobernador Pilato tijb bén yuꞌ ladxguiib bén guiëb ree bénguiedx guin laa, ziꞌc na̱j xcostumbr reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Lën ree dxejzii yuꞌ Barrabás ladxguiib, tijb bén nünbee ree bejn niz ni niz guie. ");
INSERT INTO zasNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Abiꞌ chi badxaag lasaꞌ gra ree bejn, gunabdiidx Pilato loj reeman, rëbaman: ―¿Chu rëndi guslaan? ¿Barrabás ya, o Jesús, bén rëb ree bejn na̱j Cristo? ");
INSERT INTO zasNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Rëbaman zian guial gogbeeman ganaxzi guialnadëdlojn zeel bayü reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Laꞌtgaj zojb Pilato lod rüjnman guialguxtis, bidxin xruson lacheelaman, rëbaman lojman: “Adxhie güünnël bén guin achet dol rajpaman, din dád nadxuudx guneꞌxchalan laaman nuche.” ");
INSERT INTO zasNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Per bixhioz rniabee ree bixhioz con ree guxtis Israel, badxeꞌ reeman diidx gra ree bejn persi gunab reeman guslaaman Barrabás, guiáad Jesús guiëtaman. ");
INSERT INTO zasNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gunabdiidx Pilato loj reeman stijb, rëbaman: ―¿Chu loj grop reeman rëndi guslaan? Badxiꞌ reeman laan rëb reeman: ―Barrabás. ");
INSERT INTO zasNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Abiꞌ rëb Pilato loj reeman: ―¿Xhieza günnëꞌn Jesús, bén rëb ree bejn na̱j Cristo? Badxiꞌ gra reeman laan rëb reeman: ―¡Bacaaman loj crüjz! ");
INSERT INTO zasNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Abiꞌ rëb Pilato loj reeman: ―¿Xhieza ni mal beenman? Per laa reeman mazri rejs rbixdiaj reeman, rëb reeman: ―¡Bacaaman loj crüjz! ");
INSERT INTO zasNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Chi baguiaa Pilato guial achet rileꞌ güünman, al mazri naquieꞌ cayüjn ree bén guin, dxel cwaꞌman nijs abiꞌ banaaman delant loj gra reeman, rëbaman: ―Achet dol raꞌpan guial guiët bén guie, xcwentidan. ");
INSERT INTO zasNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Badxiꞌ gra ree bén guinan rëb reeman: ―¡Du guijcan, në guijc du xiꞌnan cwiban guial guiëtaman! ");
INSERT INTO zasNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Dxel baslaa Pilato Barrabás, zianz gunabeeman gudijn reeman Jesús abiꞌ bayüman laaman din gucaa reeman laaman loj crüjz. ");
INSERT INTO zasNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Zianz xsuldad ree gobernador guin binë reeman Jesús lën palas lod badoꞌp gra ree suldad, gadëd lod zaꞌman. ");
INSERT INTO zasNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Dxel gulëë reeman xabaman bascajcw reeman laaman tijb lajd xnia. ");
INSERT INTO zasNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Abiꞌ beenchaaw reeman tijb coron guiëjch badxeꞌ reeman laan guijcaman, zianz bagaꞌs reeman tijb yag ladxaaman ladbee. Dxel bazuxib reeman lojman, ruzeꞌ reeman laaman, rëb reeman: ―¡Guibanri xrey ree bén Israel! ");
INSERT INTO zasNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Abiꞌ rucojp xhiejn reeman lojman, laagajc tëë yag ni caꞌman rugaz reeman guijcaman. ");
INSERT INTO zasNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Chi gulox bazeꞌ reeman laaman, dxel babëë reeman lajd xnia guin ladaman, bascajcw reeman xabaman, zianz zinë reeman laaman din gucaa reeman laaman loj crüjz. ");
INSERT INTO zasNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Chi zinë reeman Jesús, badxaagloj reeman tijb bén Cirene, laman Simón, abiꞌ been reeman laaman naguiejn byaaman xcrüjz Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Chi bidxin reeman tijb luar la Gólgota (rën guiëban Xluar Calaver), ");
INSERT INTO zasNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ni badëëd reeman vin, noꞌchan nijs nala daꞌt guiëꞌ Jesús. Per chi beenman laan prueb, ad cwëjbtaman niëꞌman laan. ");
INSERT INTO zasNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Chi gulox bacaa reeman laaman loj crüjz, dxel gudxijt reeman suert guijc xabaman din yalaꞌ reeman laan. ");
INSERT INTO zasNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Dxel gurej reeman yagaj din gap reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Abiꞌ guijc crüjz guin bacaa reeman lejtr ni rëb, chexc zeel cwaman loj crüjz. Rëb lëjtr guin: “BEN GUIE NA̱J JESÚS XREY REE BEN ISRAEL.” ");
INSERT INTO zasNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Në tioꞌp xin gubaan bacaa reeman loj crüjz, tijbix xladbee Jesús stijbix xladruvejsaman. ");
INSERT INTO zasNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Abiꞌ ree bén rdëd, rnieeguijdx reeman Jesús, runij guijc reeman, ");
INSERT INTO zasNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","rëbgaj reeman: ―Lüj rëb, nuseꞌnl yadooroꞌ abiꞌ loj choon dxejzi nayüjnlan, baslaa lüj gajc. Bal walil najl Xiꞌn Dios baguiajt loj crüjz guin. ");
INSERT INTO zasNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ziangajc ree bixhioz rniabee ree bixhioz në ree mextr rajc ley con ree guxtis Israel, ruzeꞌ reeman Jesús, rëb reeman: ");
INSERT INTO zasNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Baslaax ben ren ree, abiꞌ ad rajct ruslaa laagajquix. Bal wali najx xrey ree bén Israel, yaguiajtix loj crüjz guin, din yaliladx reex. ");
INSERT INTO zasNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Rililadxix Dios. ¡Yan, guslaaza Dios laax, bal wali rënman laax, din rëbix: “Xiꞌn Dios najx”! ");
INSERT INTO zasNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Abiꞌ nëgajc ree xingubaan ca cwëꞌman ruzeꞌ laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Dxel diizd garol dxej bicajy loj guidib guidxliuj, xt raca choon wadxe. ");
INSERT INTO zasNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Loj horzii gurixdiajman rejs daꞌt, rëbaman: ―Elí, Elí, ¿lama sabactani? ―rën guiëban: Dios, Dios, ¿chexc zeel gulëëladxil naj? ");
INSERT INTO zasNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Yuꞌ ree bén zaꞌ yagaj, chi biguiejn reeman, rëb reeman: ―Laaman cabejdx Elías, bén badëë xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Laa baxüün gajc tijbaman bicajdxaman tijb xiil loj vinagr, abiꞌ bacaaman laan loj tijb yag zianz badxigaman laan roꞌ Jesús din guiëꞌman laan. ");
INSERT INTO zasNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Per rëb los demazri reeman: ―Basaꞌnx, din yaguiaa ree don zidgaslaa Elías laax ya. ");
INSERT INTO zasNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Zianz gurixdiaj Jesús rejs daꞌt stijb, dxel güjtaman. ");
INSERT INTO zasNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Loj hor zii goxyaꞌ lajd nal lën yadooroꞌ Jerusalén gojcan tioꞌp lalaꞌ, diizd guijc guin xt guiaꞌ guin goxyaꞌ. Abiꞌ guxu, gulaꞌ tëë ree guiajroꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Guiáad ree baa bixal reen, abiꞌ zien ree bejn bén na̱j xbejn Dios, bén ma güjt ree baban. ");
INSERT INTO zasNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Dxel chi baban Jesús, barii lën xbaa reeman, abiꞌ guyu reeman Jerusalén, lod baguiaa zien ree bejn laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Dxel suldad rniabee ree suldad në gra ree suldad zaꞌnëman yagaj canaj reeman Jesús, chi baguiaa reeman caxu në gra ni cayajc, dád bidxeb reeman abiꞌ rëb reeman: ―Walican Xiꞌn Dios bén guin. ");
INSERT INTO zasNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Zien ree béngunaa guzanal Jesús diizd Galilea, bén been tëë ree laaman yudar, zaꞌ reeman zijt ruguiaa reeman ni cayajc. ");
INSERT INTO zasNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Loj reeman noꞌch María Magdalena, në Li xniaa Santiaaw con Xiëb nëtëë xniaa ree xiꞌngaan Zebedeo. ");
INSERT INTO zasNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Chi gure guiaal, bidxin tijb benrijcw laman Xiëb, bén Arimatea, në laaman binal Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Wejman loj Pilato, bignabaman xcuerp Jesús. Dxel gunabee Pilato bayü reeman cuerp guin lojman. ");
INSERT INTO zasNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Abiꞌ cwaꞌman cuerp guin batüübaman tijb lajd naya. ");
INSERT INTO zasNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Dxel biquieꞌchaman laaman lën tijb baa cüb ni gudëënman par laagajcaman lën tijb guiaj. Zianz basiaawaman roꞌ baa guin con tijb guiajroꞌ, ziataman. ");
INSERT INTO zasNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Abiꞌ zojb María Magdalena con stijb bén la gajc Li, roꞌ baa guin. ");
INSERT INTO zasNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Chi bareguiaal, dxej raziiladx ree bejn, wej ree bixhioz rniabee ree bixhioz në ree bénfarisew, bigneenë reeman Pilato, ");
INSERT INTO zasNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","rëb reeman lojman: ―Dad, rasaaduladxan, chi ziz naban bén rusquiee ni, rëbaman guial chi gac choon dxej yabanman. ");
INSERT INTO zasNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Zeel gunabee guiyaawdxiꞌch roꞌ baa guin xt chi gac choon dxej, chitëë guiꞌt ree xbejnman guxhin cwan reeman xcuerpaman. Abiꞌ guiëb reeman loj ree bejn guial ma babanman. Abiꞌ mazri gusquiee reeman bejn guial loj ni yaloj. ");
INSERT INTO zasNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Dxel rëb Pilato loj reeman: ―Laa ree suldad zaꞌ yagaj. Gol chinë reeman, gol basiaawdxiꞌch roꞌ baa guin ziꞌc rëndi. ");
INSERT INTO zasNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Abiꞌ zë reeman, dxel basiaawdxiꞌch reeman roꞌ baa guin. Zianz basaꞌn reeman suldad guin ree cayajp reeman laan. ");
INSERT INTO zasNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Chi gudëd dxej raziiladx ree bejn, bareguiaal chidumingw, María Magdalena con stijb bén la gajc Li biquiaa reeman roꞌ baa guin. ");
INSERT INTO zasNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Dxel biꞌt tijb xudoxh, guial biguiajt tijb xianjl Dios diizd xanyabaa, dxel bibig anjl guin roꞌ baa guin biquiedaman guiaj nayaaw roꞌn, zianz gurejman guijcan. ");
INSERT INTO zasNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Dád rliajman bachaꞌ ziꞌc chi rëꞌp nijs, guiáad xabaman naquichbëjn. ");
INSERT INTO zasNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Chi baguiaa ree suldad guin anjl guin, binij reeman guial dád bidxeb reeman xt badaj reeman abiꞌ biyajb reeman luyuj. ");
INSERT INTO zasNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Dxel rëb anjl guin loj ree béngunaa guin: ―Ad rdxebidi, ragbeen cayguiilidi Jesús bén cwa loj crüjz. ");
INSERT INTO zasNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Per achutri laaman guie, ma babanman ziꞌc naman. Gol guida nial din guguiaadi lod gudixh reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yan, gol baxüün gol bicojn ree xbejnman guial ma babanman, ma nedaman lojdi zëgajman Galilea, ni guguiaadi laaman. Ni nezan na̱j ni rugojnan lëjt. ");
INSERT INTO zasNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Dxel cari daꞌt baza reeman roꞌ baa guin rdxeb reeman rabaa tëë reeman, ruxüün reeman zia reeman zicojn reeman xbejn Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Laꞌtgaj zia reeman, balüüloj Jesús loj reeman, bagajpdiozaman laa reeman. Abiꞌ bibig reeman lojman, bazuxib reeman, gudiidx reeman guiaꞌman, ");
INSERT INTO zasNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","abiꞌ rëbaman loj reeman: ―Ad rdxebidi. Gol chej, gol biguiedx loj ree da bejnan din che reeman Galilea, ni guguiaa reeman naj. ");
INSERT INTO zasNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Laꞌtgaj zia ree béngunaa guin, në tioꞌp choon ree suldad cayajp roꞌ baa guin zë luguiedx guin zicojn reeman bixhioz rniabee ree bixhioz gra ni goc. ");
INSERT INTO zasNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Dxel wej ree bixhioz rniabee guin bigneenë reeman guxtis Israel ree persi bayaꞌn reeman diidx xhie güün reeman. Abiꞌ dad zroꞌ milia badëëd reeman loj ree suldad guin, ");
INSERT INTO zasNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","rëb reeman: ―Con gol güjdx loj ree bejn: “Guxhin laꞌtgaj nadoodyëjsan, biꞌt ree xbejn Jesús abiꞌ gulan reeman xcuerpaman.” ");
INSERT INTO zasNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Abiꞌ bal gagbee gobernador, dunujn yaneenëꞌ laaman chitëë xhie güünnëman lëjt. ");
INSERT INTO zasNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Dxel cwaꞌ ree suldad guin milia guin abiꞌ been reeman ziꞌc rëb reeman. Laan na̱j diidx ni nareꞌch loj ree bén Israel xt yan. ");
INSERT INTO zasNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Guidxiptib ree xi apóstoles Jesús, wej reeman Galilea, guijc tijb guiaꞌ lod rëb Jesús che reeman. ");
INSERT INTO zasNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Abiꞌ chi baguiaa reeman Jesús, bazuxib reeman lojman, majsi yuꞌ reeman ad bililadxzaꞌct. ");
INSERT INTO zasNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Dxel bibig Jesús loj reeman, rëbaman: ―Dios ma banee gra guialrniabee din ganabeen xanyabaa në loj guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Zeel, gol chej guidib guidxliuj, gol biglüü ree bejn din gac reeman da bejnan. Gol baroobnijs reeman por dux Dad ree, por Xiꞌnman në por xSprijtaman, ");
INSERT INTO zasNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","gol balüü tëë reeman din guzoob reeman diidx gra ni ma rnin lëjt. Abiꞌ naj gazunëꞌ lëjt gradxejczi xt chi nit guidxliuj. Amén.");
INSERT INTO zasNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ze guzuloj xtiidxzaꞌc Jesucrist, Xiꞌn Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Guyu tijb bén badëë xtiidx Dios loj ree bejn brii lajman Isaías, bacaaman xtiidx Dios, rëbaman: Naj rxhial tijb bén ned lojl, bén güünchaaw xnejzil. ");
INSERT INTO zasNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Rguien chaꞌ tijb bén rbidxaꞌ loj yujbidx, rëbaman: “Gol beenchaaw xnejz dux Dad ree, gol guxhal tijb nejz nali.” ");
INSERT INTO zasNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Zian biꞌt Waj bén baroobnijs bejn ree, guzujman niz loj yujbidx, abiꞌ rëbaman loj ree bejn guial rayal yayüjn xgab por xtol reeman, yayejc reeman con Dios din gac reeman perdon tiobnijs tëë reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Gra ree bén zojb niz Judea, në ree bén Jerusalén brii reeman zicaagdiajg reeman ni rniee Waj, abiꞌ rxhioobdol reeman. Zianz ruroobnijs Waj laa reeman loj guiiw Jordán. ");
INSERT INTO zasNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Guidxlad camell gojcnë xabaman, abiꞌ lënman bixii tijb cinch guid. Gudawaman biꞌtsu con dxijn dajn. ");
INSERT INTO zasNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Chi guneenëman bejn ree, rëbaman: ―Xichan zëëd tijb bén mazri zojbloj guial lon, niꞌqui xgurëchaman ad zajct gaxhiecan guial mazri zojblojman guial lon. ");
INSERT INTO zasNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Naj curobnijs lëjt con nijs, per laaman guroobnijs lëjt con xSprijt Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Lën ree dxejzii guza Jesús luguiedx Nazaret ni rigaꞌ niz Galilea, abiꞌ baroobnijs Waj laaman loj guiiw Jordán. ");
INSERT INTO zasNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Chi bariiman loj nijs guin, laa baguiaa gajcaman bixal xanyabaa, zidguiajt xSprijt Dios ziꞌc tijb palom xt guijcaman. ");
INSERT INTO zasNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Dxel biguien chaꞌ bejn xanyabaa, rëbaman: ―Lüj na̱j da Xiꞌnan, rënan lüj rabaanëꞌ tëën lüj. ");
INSERT INTO zasNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Dxel binë xSprijt Dios Jesús loj yujbidx. ");
INSERT INTO zasNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ni guzuman tiuu dxej tiuu guiaal, loj ree bedoxh. Abiꞌ been xindxab laaman prueb chitëë nuzoobaman xtiidx Dios, guiáad ree xianjl Dios gunaj laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Chi mal guyu Waj ladxguiib, wej Jesús niz Galilea bigneeman xtiidxzaꞌc Dios, ");
INSERT INTO zasNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","rëbaman: ―Ma bidxin dxej zëëd xguialrniabee Dios gajxh, zeel gol bayüjn xgab por xtolidi, gol bililadx tëë xtiidxzaꞌcaman. ");
INSERT INTO zasNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Laꞌtgaj caza Jesús roꞌnijsdoo Galilea, baguiaaman Simón në bijchaman Andrejs, cuzaal xguijxh reeman lojnijs din guiniaaz reeman bëjl. ");
INSERT INTO zasNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Abiꞌ rëb Jesús loj reeman: ―Gol tanal naj din gulün lëjt xhienaag gutoꞌpidi bejn par Dios, luar rniaazidi bëjl. ");
INSERT INTO zasNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Loj hor guin gajc basaꞌn guijxh rniaaznë reeman bëjl persi zinal reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Guzaman zatibdaꞌn, dxel baguiaaman Jacob con Waj bén na̱j ree xiꞌn Zebedeo, yuꞌ reeman loj barcw rayüjnchaaw xguijxh reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Dxel gurejdx Jesús laa reeman, abiꞌ basaꞌn reeman Zebedeo loj barcw guin, bén na̱j xdad reeman con ree xmojsaman, guiáad laa reeman zinal reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Chi bidxin Jesús luguiedx Capernaum. Abiꞌ dxej raziiladx ree bejn guyuman lën xyadoo ree bén Israel culüüman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Dád radxa loj reeman ziꞌc rnieenëman laa reeman guial rulüüman laa reeman ziꞌc tijb bén rniabee, ad rulüütaman ziꞌc rulüü ree mextr rajc ley. ");
INSERT INTO zasNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Lën yadoo guin yuꞌ tijb xin yuꞌ xindxab luxdoo, dxejczi guridxaꞌx rëbix: ");
INSERT INTO zasNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿Xhie rënl con dunujn, Jesús bén Nazaret? ¿Zëëdil ya zidganijtil dunujn? Nünbeen lüj, ragbeen guial naya nalil najl xiꞌn Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Dxel gudilë Jesús xindxab guin, rëbaman: ―¡Bacwëëz roꞌl, barii luxdoo xin guin! ");
INSERT INTO zasNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Abiꞌ been xindxab guin xin guin ziꞌc bén rëjtyaꞌ, zianz gurixdiajx rejs, bariix luxdoo xin guin. ");
INSERT INTO zasNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Graczi ree bén rigaꞌ dád badxaloj reeman, riniabdiidx loj lasaꞌ reeman rëb reeman: ―¿Xhie ree nicüban rulüü bén guin? ¡Con guialrniabee ni rajpaman xt ree xindxab ruzoob xtiidxaman! ");
INSERT INTO zasNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tibrajtzi bireꞌch xtiidx Jesús guidib niz Galilea. ");
INSERT INTO zasNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Bariiz reeman lën yadoo guin, binë Jesús Jacob con Waj lidx Simón con Andrejs. ");
INSERT INTO zasNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Abiꞌ nagaꞌ xnasuegr Simón, yuꞌman xliaadoxh. Dxel bagojn reeman Jesús guial ragxuuman. ");
INSERT INTO zasNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Abiꞌ gubigaman cwëꞌman gunaazaman yaaman, gulesaman laaman. Loj hor guin gajc bariiman xliaa guin dxel guzuloj cudëëdaman ni gaw reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Chi ma gurej guiaal, binë reeman bénragxuu ree lod zaꞌ Jesús, në ree bén yuꞌ xindxab luxdoo. ");
INSERT INTO zasNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Graczi ree bén luguiedx guin bidoꞌp ruyu lod zaꞌ Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Bayüjn Jesús zien ree bén rajc ree gadxagayaa guialguijdx, babëë tëëman zien ree xindxab luxdoo ree bejn. Per ad rudëëtaman mod guiniee ree xindxab guin guial nünbee reex laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Bixche Jesús rsildoo, chi ziiz nacay, briiman luguiedx guin wejman tijb luar lod achutczi bejn zojb, persi gurejdx gunabaman Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Abiꞌ Simón con ree xcompniaraman bigdiil reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Chi badxejl reeman laaman, rëb reeman lojman: ―Gra ree bejn cayguiil lüj. ");
INSERT INTO zasNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Per rëbaman loj reeman: ―Yoꞌ ree guiedx ni rigaꞌ ree gajxh din gulün xtiidxzaꞌc Dios, din par zian zialan. ");
INSERT INTO zasNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Abiꞌ balüü Jesús xtiidx Dios lën ree xyadoo ree bén Israel guidib niz Galilea babëë tëëman xindxab luxdoo ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tijb bén rajc guialguijdx la lepra, gubigaman lod zaꞌ Jesús, bazuxibaman lojman rëbaman ―Bal guiënl, zajc yayüjnl naj. ");
INSERT INTO zasNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Baya Jesús laaman, baquiꞌman laaman, rëbgajman: ―Rënan, bayajc. ");
INSERT INTO zasNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Chi gunee Jesús zian, hor guin gajc bayajc bén guin abiꞌ baya xcuerpaman. ");
INSERT INTO zasNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Dxel baguꞌnejz Jesús laaman, rëbaman lojman: ");
INSERT INTO zasNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Bacaagdiajg ni ganin lüj. Achu loj guiëbil guial ma bayajquil. Lojzi bixhioz wej din guguiaaman lüj, binë gon ni rayal chinël loj Dios ziꞌc gunabee Moisejs, din gagbee gra ree bejn guial ma bayajquil. ");
INSERT INTO zasNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Per bén guin chi ziaman guzuloj catieꞌchaman diidx loj gra bejn xhienaag bayajcaman. Zeel ad bileꞌt contzi niu Jesús luguiedx ree, ganax dajn ree rayaꞌnman lod achut bejn zojb. Per gra lad rza ree bejn rej reeman lod zaꞌman. ");
INSERT INTO zasNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Chi goc tioꞌp choon dxej, badxin Jesús luguiedx Capernaum, abiꞌ chi gogbee ree bejn, guial zaꞌman yagaj, ");
INSERT INTO zasNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","tibrajtzi bidoꞌp zien daꞌt reeman lod zaꞌman, xt niꞌquid rdaant roꞌ port chuꞌ reeman, guiáad laaman culüüman laa reeman xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Dxel bidxin tajp ree bejn yagaj lejn reeman tijb xin nëjt xcuerp. ");
INSERT INTO zasNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Per ad gojct niunë reeman laax lod zaꞌ Jesús guial bén guixiuj guidxa. Abiꞌ guxhal reeman guijc yu lod zaꞌman persi gulet reeman xinragxuu guin guidib ni nagaꞌx loj xt lod zaꞌ Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Chi baguiaa Jesús guial rliladx reeman laaman, rëbaman loj xinragxuu guin: ―Xiꞌn, ma benan xtolil perdon. ");
INSERT INTO zasNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Per yagaj zojb tioꞌp choon ree mextr rajc ley, been reeman xgab naladx reeman: ");
INSERT INTO zasNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Chexc zeel rniee xin guin zian? ¿Chexc zeel rüjnx mazri xin zojbloj guial loj Dios? Achutczi rajc rüjn perdon dol tijbzi Dios.” ");
INSERT INTO zasNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Per gogbee gajc Jesús xgab cayüjn reeman, dxel rëbaman: ―¿Chexc zeel rüjndi xgab zian? ");
INSERT INTO zasNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Conin ad nawëëgt gac, guial guiën loj bénragxuu guin ya: “Ma benan xtolil perdon”, o guiën ya: “Bixche, gules ni goꞌtil loj, baguiaj”? ");
INSERT INTO zasNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Per yan gulün lëjt guial Bén guxhaal Dios rajpaman guialrniabee loj guidxliuj guie din güünman dol ree perdon. Dxel rëbaman loj xinragxuu guin: ");
INSERT INTO zasNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Lüj rnin, bixche, bacaꞌ ni goꞌtil loj baguiaj lidxil. ");
INSERT INTO zasNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Loj hor guin gajc bayajc xin guin, bixchex bacaꞌ ni goꞌtix loj, bariix lënü guin guidib loj gra ree bén rigaꞌ yagaj. Abiꞌ gra reeman badxaloj, ruzaꞌt reeman Dios zagdxe, rëb reeman: ―Niꞌqui tijb ad waguiaat ree ziꞌc na̱j ni cayguiaa ree yan. ");
INSERT INTO zasNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Dxel wej Jesús roꞌnijsdoo Galilea zatijb. Dád zien ree bejn rdxin lod zaꞌman persi rulüüman laa reeman xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Chi cadëdaman, baguiaaman Leví xiꞌngaan Alfeo, zojbaman lod ruquijxaman impuest. Dxel rëb Jesús lojman: ―Tanal naj. Laa bisu gajc Leví binalaman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Dxel chi cayaw Jesús lidx Leví con zien ree bén ruquijx impuest në ree bén ad nabant ziꞌc rën Dios, gra reeman zojbnë Jesús xan mex con ree xbejnman, guial zinal zien ree bejn laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Chi baguiaa ree bénfarisew con ree mextr rajc ley guial cayawnë Jesús bén guin ree, rëb reeman loj ree xbejnman: ―¿Chexc zeel rawnë xmextridi bén ruquijx ree impuest në ree béndol? ");
INSERT INTO zasNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Chi biguiejn Jesús ni rëb reeman, zeel rëbaman: ―Bénnadaan ree ad riaadxt reeman doctor, bénragxuu ree, laa reeman riaadx doctor. Ad zialtan par ree benzaꞌc, zialan par ree béndol din yayüjn reeman xgab por xtol reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Lën ree dxej zii gubaꞌn ree xbejn Waj bén ruroobnijs bejn ree, në ree bénfarisew. Abiꞌ yuꞌ ree bén gunabdiidx loj Jesús, rëb reeman: ―¿Chexc zeel ad rbaꞌnt ree xbejnl ziꞌc rbaꞌn ree xbejn Waj con ree bénfarisew? ");
INSERT INTO zasNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Badxiꞌ Jesús laan rëbaman: ―Wen, ¿zajc guibaꞌn ree biooz zaꞌ loj guialruxhliaa ya laꞌtgaj zaꞌnë xin cuxhliaa guin laa reeman? Laꞌtgaj zaꞌnëx laa reeman ad zajct guibaꞌn reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Per guidxin dxej chiquiedix loj reeman, abiꞌ chi guidxin dxej guin dxel guibaꞌn reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Achut bén rataꞌ lajd cüb loj lajd yojx, din zaxüꞌn lajd cüb guin abiꞌ mazri quixyaꞌn lajd yojx guin. ");
INSERT INTO zasNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ad rguꞌ tëët bejn vin cüb lën anfr yojx, din zaguixyaꞌ vin cüb guin anfr guin, abiꞌ ziꞌc anfr guin ziꞌc vin guin zaxin reen. Zeel vin cüb rayal chuꞌn lën anfr cüb. ");
INSERT INTO zasNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tijb dxej raziiladx ree bén Israel, cadëd Jesús con ree xbejnman loj guiniaa lod yuꞌ trigo, abiꞌ ree xbejnman guzuloj caguiꞌch reeman trigo guin chi cadëd reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Dxel rëb ree bénfarisew loj Jesús: ―¿Chexc zeel rüjn ree xbejnl ni ad rayalt gac dxej raziiladx ree bejn? ");
INSERT INTO zasNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Per rëb Jesús loj reeman: ―¿Gadidi gool loj xtiidx Dios ya ni been Davi chi gulaanman con ree xcompniaraman? ");
INSERT INTO zasNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tiamp ni goc Abiatar bixhioz rniabee gra ree bixhioz, guyu Davi lën xyadooroꞌ Dios, gudawnë ree xcompniaraman guiadxtil ma nagleꞌ abiꞌ bixhiosi ree rayal gaw laa reen. ");
INSERT INTO zasNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Rëb tëë Jesús: ―Dios badxeꞌ dxej raziiladx bejn, per ad badxeꞌtaman dxej guin par sagdiaj bejn. ");
INSERT INTO zasNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Abiꞌ naj, guial najn Bén guxhaal Dios, raꞌpan guialrniabee dxej raziiladx ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tijb dxej guyu Jesús lën tijb yadoo. Lën yadoo guin zaꞌ tijb xin naxüꞌn tiblad yaa. ");
INSERT INTO zasNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Abiꞌ ree bén yuꞌ lën yadoo guin rulaꞌch reeman Jesús din guidoon zayüjnman laax dxej raziiladx reeman ya, din gac gutediaꞌ reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Dxel rëb Jesús loj xin naxüꞌn yaa guin: ―Bisu, guzuj galay guin. ");
INSERT INTO zasNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Abiꞌ rëbaman loj ree bén guin: ―¿Xhie rayal güün bejn dxej raziiladx reeman? ¿Ni zagdxe ya o ni mal? ¿Guslaaman xguialnaban bejn ya o gugüjtaman laaman? Per ad badxiꞌt reeman xtiidxaman. ");
INSERT INTO zasNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Dxel rdxeꞌch Jesús ruguiaaman loj gra reeman, dád guyunaya luxdooman guial ad guyënt reeman naya lasaꞌ reeman. Zianz rëbaman loj xin guin: ―Basli yaal. Abiꞌ basli yaax, loj hor guin gajc bayajcan. ");
INSERT INTO zasNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Chi baza ree bénfarisew guin, zianz bayaꞌn reeman diidx con ree xbejn Herodes din gugüjt reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Per Jesús zë gajcaman roꞌnijsdoo Galilea con ree xbejnman. Zien daꞌt ree bén Galilea con ree bén Judea binal laaman, ");
INSERT INTO zasNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","në ree bén Jerusalén con ree bén Idumea, në ree bén zojb zatiblad roꞌ guiiwroꞌ Jordán, në ree bén Tiro con ree bén zojb niz Sidón. Dád zien ree bejn wej lod zaꞌ Jesús guial gogbee reeman ni rüjnman. ");
INSERT INTO zasNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Zeel rëbaman loj ree xbejnman din guzujsin reeman tijb barcw par laaman chitëë gutëë ree bén guin laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Guial ma bayüjnman zien ree bejn, zeel rbig gra ree bénragxuu lojman din guquiꞌ reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Guiáad ree bén yuꞌ xindxab luxdoo chi ruguiaa reeman Jesús, ruzuxib reeman lojman, rbidxaꞌ reeman rëb reeman: ―¡Lüj na̱j Xiꞌn Dios! ");
INSERT INTO zasNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Per gunabeeman xindxab guin ree chitëë guiëb reex chu laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Dxel wëꞌp Jesús tijb ruguiaꞌ, abiꞌ gurejdxaman gra ree bén guleman. Zianz wej reeman, ");
INSERT INTO zasNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","loj gra reeman gulejman chiptioꞌp reeman din su reeman con laaman zianczi guixhiaal tëëman laa reeman chigtieꞌch reeman xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Abiꞌ badëëman guialrniabee din yayüjn reeman bénragxuu ree yabëë tëë reeman xindxab luxdoo ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Bén guie ree na̱j guidxiptioꞌp ree bén gule Jesús: Simón bén gulëëlajman Bëd, ");
INSERT INTO zasNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacob con Waj, bén na̱j ree xiꞌn Zebedeo, gunee Jesús laa reeman Boanerges (rën guiëban, xiꞌn guziaaw); ");
INSERT INTO zasNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","në Andrejs, Felip, Tol, Matew, Tumajs con Jacob xiꞌn Alfeo, në Tadeo, nëtëë Simón bén biꞌch loj ree bén Cananistas, ");
INSERT INTO zasNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","con Judas Iscariote bén bayü Jesús. Chi gulox bacaabeeman laa reeman dxel badxinnëman laa reeman lod zojbaman. ");
INSERT INTO zasNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Dád zien ree bejn bidoꞌp yagaj stijb, xt niꞌquid bileꞌt niajw Jesús con ree xbejnman. ");
INSERT INTO zasNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Chi gogbee ree xfamil Jesús, dxel bidxin reeman din yacaꞌ reeman laaman guial rëb reeman guijcaman rajc. ");
INSERT INTO zasNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Abiꞌ ree mextr rajc ley bén zëëd ree Jerusalén rëb reeman: ―Bén guin rabëë xindxab luxdoo ree bejn por xguialrniabee Beelzebú, xin rniabee ree xindxab. ");
INSERT INTO zasNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Dxel gurejdx Jesús laa reeman, rëbaman: ―¿Xhienaag yabëë satanás lasaꞌ xindxab gajquix? ");
INSERT INTO zasNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Bal tijb nacion, ad nadxagt rigaꞌ ree gobiarn, zadijl reeman abiꞌ ad zanuut xguialrniabee reeman, ");
INSERT INTO zasNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ziangajc tijb famil, bal rdilnë lasaꞌ reeman, nayob laꞌ lasaꞌ reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Yan, ziangajc bal satanás su contr lasaꞌ xindxabgajquix, zalaꞌ lasaꞌ reex abiꞌ wed yagaj lox xguialrniabee reex. ");
INSERT INTO zasNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Abiꞌ achut zajc chuꞌ lidx tijb béngojl daꞌt din cwanman gra xieenman bal id zaxhii xgajman laaman. Zian zileꞌ cwanman ni rajpaman. ");
INSERT INTO zasNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Naj rni lojdi guial yuꞌ perdon par gra dol ni rüjn bejn, yuꞌ tëë perdon par gra diidxguijdx ni rniee bejn chutëëz. ");
INSERT INTO zasNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Per bén guinieeguijdx xSprijt Dios, ad yuꞌt dxej gacaman perdon, ma banijtaman loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Rëb Jesús zian guial rëb reeman yuꞌ xsprijt xindxab luxdooman. ");
INSERT INTO zasNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Hor guin bidxin xniaa Jesús con ree bijchaman yu lod zaꞌman, per ad bileꞌt niu reeman zeel guxhaal reeman bén chignee laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Dxel ree bén zojbnë laaman yagaj bagojn reeman laaman, rëb reeman: ―Laa xniaal con ree bijchil zaꞌ luleꞌ guin cayguiil reeman lüj. ");
INSERT INTO zasNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Badxiꞌ Jesús xtiidx reeman rëbaman: ―¿Chunin na̱j da nan con ree da bichan? ");
INSERT INTO zasNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Dxel baguiaaman bén zojb ree gadëd lod zojbaman, rëbaman: ―Bén guie ree na̱j da nan con ree da bichan, ");
INSERT INTO zasNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","din graczi ree bén rüjn ni rën Dios, laa reeman na̱j da bichan, da zanan në da nan. ");
INSERT INTO zasNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Zatijb dxej culüü Jesús xtiidx Dios roꞌnijsdoo Galilea. Abiꞌ guial dád benzien bidoꞌp lod zaꞌman zeel wëꞌpaman loj tijb barcw yuꞌ lojnijs guin, abiꞌ gurejman lojn guiáad ree bén guin rigaꞌ reeman roꞌ nijs guin. ");
INSERT INTO zasNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Zien ree ni balüüman laa reeman, rüman laan loj reeman ziꞌc cwent, loj ree ni culüüman laa reeman rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Gol bacaagdiajg ni ganin lojdi: Tijb bejn briiman bigtieꞌchaman bin loj xguiniaaman. ");
INSERT INTO zasNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Chi catieꞌchaman laan, taꞌnan biajb lunejz abiꞌ bidxin ree biguijn gudaw reeb laan. ");
INSERT INTO zasNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Zataꞌnan biajb loj ree guiaj lod ad rigaꞌt zien yuj, abiꞌ cari gulejnan guial ad zient yuj rigaꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Per chi gunan gubijdx, bigoolan abiꞌ guial ad zroꞌt liujn yuꞌ, gubidxan. ");
INSERT INTO zasNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Zataꞌnan biajb loj ree yaquiëjch. Abiꞌ chi guniꞌsan, banidloj yaquiëjch guin laan, abiꞌ ad cwat ladan. ");
INSERT INTO zasNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Per zataꞌnan biajb loj yuj zaꞌc, abiꞌ dád gojcan, yuꞌ ni cwa gajlbichii, yuꞌ ni cwa gayojn yuꞌ tëë ni cwa tibgayuu. ");
INSERT INTO zasNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Rëb tëë Jesús loj reeman: ―Bén rën gucaagdiajg, gol bacaagdiajg. ");
INSERT INTO zasNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Chi ma bayaꞌnnë Jesús zataꞌnz ree bejn con guidxiptioꞌp ree xbejnman, dxel gunabdiidx reeman xhie rën guiëb cwent guin. ");
INSERT INTO zasNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Badxiꞌman laan rëbaman: ―Dios ma basaꞌn lëjt din chigniaꞌdi xhienaag na̱j xguialrniabeeman ni goc naguieꞌch par lëjt, saꞌn ree bén ad rliladxt xguialrniabeeman, con ganaxzi ree cwent na̱j guial gulün laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Din majsi rani loj reeman, per ad zuguiaat reeman, majsi riguiejn reeman, per ad zigniaꞌt reeman chitëë yayejc reeman loj Dios abiꞌ güünman perdon xtol reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Abiꞌ rëb Jesús loj reeman: ―¿Nid rigniaꞌdi ya xhie rën guiëb cwent guin? ¿Xhieza naag chigniaꞌdi gra ni ganin lojdi? ");
INSERT INTO zasNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bén gutieꞌch bin guin, laaman na̱j ziꞌc bén rtieꞌch xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bin biajb lunejz, na̱j ziꞌc ree bén riguiejn xtiidx Dios, per rdxin gajc xindxab rquiedix laan luxdoo reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yuꞌ ree bén na̱j ziꞌc bin biajb loj ree guiaj. Riguiejn reeman xtiidx Dios abiꞌ dád nix ru luxdoo reeman riguiejn reeman laan. ");
INSERT INTO zasNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Per guial na̱j reeman ziꞌc tijb cwaan ni ad yuꞌt zroꞌ liuj, chi rzagdiaj reeman o chi rzunal ree bejn laa reeman din güün reeman laa reeman ni mal por xtiidx Dios, laa rusaꞌn gajc reeman ni rliladx reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yuꞌ tëë ree bén na̱j ziꞌc bin ni biajb loj yaquiëjch. Riguiejn reeman xtiidx Dios, ");
INSERT INTO zasNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","per ru reeman xgab por ree ni rigaꞌ loj guidxliuj guie. Rusquiee guialnazaꞌc laa reeman rën reeman gap reeman graloj. Abiꞌ guial yuꞌ xgab guin guijc reeman, zianz rucwëëz rucaagdiajg reeman xtiidx Dios, abiꞌ achet sirv rüjn ni rucaagdiajg reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Per yuꞌ ree bén na̱j ziꞌc bin biajb loj yuj zagdxe, ridxgaꞌ reeman laan con guidib luxdoo reeman. Rüjn reeman ziꞌc rën Dios, laa reeman na̱j ziꞌc ni cwa gajlbichii o ni cwa gayojn o ni cwa tibgayuu. ");
INSERT INTO zasNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Abiꞌ rëb Jesús loj reeman: ―Achut bén ruzeꞌc tijb guij par gutaꞌcwaman laan con tijb caj, o gudxeꞌman laan xan loon, ruzujman laan ya din gusnin guidib. ");
INSERT INTO zasNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Din achet ni naguieꞌch yuꞌ ni ad zaguient ad yuꞌ tëët ni ralan ni ad zagbeet bejn. ");
INSERT INTO zasNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Bén rën gucaagdiajg, gol bacaagdiajg. ");
INSERT INTO zasNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Rëb tëë Jesús: ―Gol been xgab por ree diidx ni caguiejndi. Bal ridxgaꞌdi xtiidx Dios, mazri gustëdguienman lëjt. ");
INSERT INTO zasNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Din bén ma rigniaꞌ xtiidx Dios, chigniaꞌman mazri. Per bén ad rigniaꞌt, xt taꞌn ni rigniaꞌman ad zigniaꞌtraman. ");
INSERT INTO zasNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Rëb tëë Jesús loj reeman: ―Xguialrniabee Dios na̱j ziꞌc rzajc bén rxübin loj xguiniaaman. ");
INSERT INTO zasNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Din majsi nagaꞌyëjsaman o nagaꞌnaaman, majsi radxe o guiaal ya, rliejn bin guin abiꞌ rniꞌsan, niꞌquid ragbeetaman xhienaag rajcan. ");
INSERT INTO zasNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Din yuj guin gajc rusniꞌs laan, yaloj rliejnan najn tijb guiꞌxhdoo, dxel ririin dojn, zianz rtia ladan. ");
INSERT INTO zasNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Chi ma gojc reen dxel raruꞌ reen guial ma bidxin tiamp yadoꞌp reen. ");
INSERT INTO zasNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Rëb tëë Jesús: ―¿Xhienaag ganin na̱j xguialrniabee Dios, o xhienaag gün diidx lojdi din chigniaꞌdi xhienaag na̱j xguialrniabeeman? ");
INSERT INTO zasNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Rnin lojdi guial xguialrniabee Dios na̱j ziꞌc na̱j xhaj moxtajs. Chi rxübin reeman laan. Laan na̱j ni mazri ni dobëz loj gra ree bin yuꞌ loj guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Per chi ma guxübin reeman laan, rniꞌsan rajcan mazri naroob loj gra ree cwaan, xt rajc rüjn xguixbitiaꞌs ree biguijn xidxan. ");
INSERT INTO zasNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Balüü Jesús laa reeman xtiidx Dios con ganaxczi cwent ziꞌc na̱j ree ni ma beman, xt lodzi bigniaꞌ reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ad rulüütaman laa reeman zezi, bal id zulüüman con cwent. Per chi ma zaꞌman con ree xbejnman dxel rusigniaꞌman laa reeman zagdxe xhie rën guiëb ree ni rëbaman. ");
INSERT INTO zasNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Dxej zii, chi gure guiaal, rëb Jesús loj ree xbejnman: ―Yoꞌ ree zatiblad roꞌ nijs guin. ");
INSERT INTO zasNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Dxel basaꞌn reeman bén rigaꞌ ree yagaj, wëꞌp reeman loj barcw ni yuꞌ Jesús zinë reeman laaman con ree barcw ren. ");
INSERT INTO zasNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Dxel brii bidoxh loj nijs guin, xt guzuloj cadxa nijs loj barcw guin. ");
INSERT INTO zasNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Per Jesús nagaꞌyëjsaman loj barcw guin tijb luar na̱j xijchan, nucuugaman tijb almoad. Dxel bacwëën reeman laaman rëb reeman: ―¡Mextr! ¿Nid yuꞌl xgab ya? ¡Ma cayzëëb ree xan nijs! ");
INSERT INTO zasNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Abiꞌ bixche Jesús, bacwëëzaman bidoxh guin rëb tëëman loj nijs guin: ―¡Bacwëëz, bayajcdxe! Dxel bayajcdxe bi guin con nijs guin. ");
INSERT INTO zasNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Zianz rëb Jesús loj reeman: ―¿Chexc zeel rdxebidi? ¿Gadzidi chililadx naj ya? ");
INSERT INTO zasNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Per laa reeman dád bidxeb reeman abiꞌ rniabdiidx loj lasaꞌ reeman: ―¿Chu bén guin zeel xt bi con nijs ruzoob xtiidxaman? ");
INSERT INTO zasNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Chi badxin Jesús con ree xbejnman zatiblad roꞌ nijsdoo guin, xdajn ree bén Gadara, ");
INSERT INTO zasNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","baguiajtzi Jesús loj barcw guin, tijb xin yuꞌ xindxab luxdoo bigchaaglojx Jesús. Bariix roꞌ ree baa, ");
INSERT INTO zasNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","guial nabanx ni. Achutczi rajc rixhii laax niꞌqui con caden. ");
INSERT INTO zasNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Zien volt ma guxhii reeman yaax në guiaꞌx con caden, per rüjngajquix gan rurooxix laan. Achut rüjn laax gan. ");
INSERT INTO zasNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dxejz guiaal rizax niz dajn con la̱d ree baa, rbixdiajx rguiilguijdx laagajquix con guiaj. ");
INSERT INTO zasNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Zijtri baguiaax Jesús, baxüünx bigchaaglojx laaman abiꞌ bazuxibix lojman. ");
INSERT INTO zasNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Zianz guneex rejs rëbix: ―¿Xhie rënl con naj Jesús, Xiꞌn Dios yuꞌ xanyabaa? Rniaaban lojl ad gusagzil naj. ");
INSERT INTO zasNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Rëbix zian, guial cayëb Jesús lojx: ―¡Xindxab, barii luxdoo xin guin! ");
INSERT INTO zasNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Dxel gunabdiidx Jesús lojx rëbaman: ―¿Chu lal? Badxiꞌxan rëbix: ―Legión lan din zien nayajcan. ");
INSERT INTO zasNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Abiꞌ rëbix lojman chitëë guixhiaalaman xindxab guin ree lood ren. ");
INSERT INTO zasNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Abiꞌ gajxh yagaj rigaꞌ zien ree cüch cayaw reeb. ");
INSERT INTO zasNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Zianz rëb ree xindxab guin loj Jesús: ―Guxhaal dunujn lod zaꞌ ree cüch guin din yadxuꞌn lën reeb. ");
INSERT INTO zasNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Dxel cwëjb Jesús barii ree xindxab guin luxdoo xin guin persi bayu reex lën ree cüch guin. Cost tioꞌp mil na̱j reeb. Dxel guzuloj cuxüün reeb, zianz bitidyaꞌ reeb roꞌ balaꞌ xt lojnijs, lod guꞌ reeb nijs zianz güjt reeb. ");
INSERT INTO zasNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Guiáad ree bén cayajp laa reeb, baxüün reeman bicojn reeman luguiedx në ree dajn abiꞌ zien ree bejn wej biquiaa ni goc. ");
INSERT INTO zasNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Chi bidxin reeman lod zaꞌ Jesús, baguiaa reeman xin barii xindxab guin ree luxdoo, zojbix najcw xabix, ma badëdguienx. Abiꞌ bidxeb reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Guiáad ree bén baguiaa gra ni goc con xin guin, në con ree cüch guin, be reeman diidx loj ree bén bidxin. ");
INSERT INTO zasNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Dxel guzuloj rëb reeman loj Jesús din yazaman niz ladx reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Chi bayu Jesús loj barcw guin, naguiejn rüjn xin barii xindxab guin ree luxdoo din chinalix laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Per ad cwëjbt Jesús, rëbaman: ―Baguiaj lidxil, bignaj xfamilil, biguie diidx loj reeman gra ni ma been Dios por lüj, xhie tëë naag bayaman lüj. ");
INSERT INTO zasNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Dxel ziax, guzuloj rëbix loj ree bén zojb niz Decápolis gra ni been Dios por laax, abiꞌ graczi reeman badxaloj. ");
INSERT INTO zasNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Chi badxin Jesús loj barcw stiblad roꞌ nijs guin, dád zien ree bejn bidoꞌp, persi roꞌzi nijs guin bayaꞌnman. ");
INSERT INTO zasNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Dxel bidxin tijb bén rniabee lën tijb xyadoo ree bén Israel, laman Jairo. Chi baguiaaman Jesús, bazuxibaman lojman, ");
INSERT INTO zasNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","abiꞌ guzajcaman laaman liaadx, rëbaman: ―Ma cayëjt da xiꞌnan. Yoꞌsii din gudxiib yaal guijquim din yayajquim din guibanm. ");
INSERT INTO zasNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Zinët Jesús bén guin, dád zien bejn zinal laaman xt rixaꞌt reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Loj graczi reeman noꞌch tijb béngunaa, ma gojc chiptioꞌp ijz ragxuuman ryajbaman rejn. ");
INSERT INTO zasNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dád ma guzagdiajman, ma banijt graczi ni rajpaman guial wejman loj ree doctor, per ad bayajctaman, aal mazri zroꞌ rajcaman. ");
INSERT INTO zasNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Chi biguiejnman gra ni rüjn Jesús, gudëdaman la̱d ree bén guin, gubigaman niz xijchaman dxel bagaalaman xabaman. ");
INSERT INTO zasNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Guial gunaladxaman: “Gugalzan xabaman, ma bayajc gajcan.” ");
INSERT INTO zasNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Loj hor zii gajc gulëjz biajbaman rejn, abiꞌ gogbeeman ma bayajcaman. ");
INSERT INTO zasNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Laa gogbee gajc Jesús guial yuꞌ chu ma bayajc por xguialrniabeeman, abiꞌ badxiꞌ lojman loj ree bén guin dxel gunabdiidxaman, rëbaman: ―¿Chu baquiꞌ da xaban? ");
INSERT INTO zasNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Abiꞌ rëb ree xbejnman lojman: ―Awa ruguiaal xt rixaꞌt reeman lüj guiáad lüj rniabdiidxil chu baquiꞌ xabil. ");
INSERT INTO zasNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Per Jesús ruguiaaman gra lad din guguiaaman chu baquiꞌ laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Abiꞌ guidib rnij béngunaa guin guial rdxebaman, guial gogbeeman ma bayajcaman, bigzuxibaman loj Jesús, beman diidxli ni beenman. ");
INSERT INTO zasNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Dxel rëb Jesús lojman: ―Xiꞌn, guial bililadxil naj zeel ma bayajquil. Baguiaj zagdxe. Ma bayajquil guialguijdx ni goquil. ");
INSERT INTO zasNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Sta canee Jesús zian, chi bidxin ree bén guza lidx Jairo, rëb reeman loj Jairo: ―Ma güjt xiꞌnl. Ad ruslenril mextr guin mazri. ");
INSERT INTO zasNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Per chi biguiejn Jesús ni rëb reeman, rëbaman loj Jairo: ―Ad rdxebil, bililadxzi naj. ");
INSERT INTO zasNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ad cwëjbt Jesús ninal gra ree bén rigaꞌ laaman, Bëdzi, con Jacob, con Waj bijch Jacob. ");
INSERT INTO zasNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Chi bidxin reeman lidxaman, baguiaa Jesús cayajc naquieꞌ guial roon rbixdiaj reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Dxel guyuman lënü abiꞌ rëbaman loj reeman: ―¿Chexc zeel roon rbixdiajdi? Ad güjttim, nagaꞌyëjsim. ");
INSERT INTO zasNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Per bazeꞌ reeman laaman. Dxel gunabeeman barii gra reeman, zianz binëman xdadim con xniaam con ree bén zinëman, lod nagaꞌ bindo guin. ");
INSERT INTO zasNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Dxel gunaazaman yaam rëbaman: ―Talita, cumi ―Rën guiëban: Lüj rnin, bindoo, bixche. ");
INSERT INTO zasNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Loj hor ziigajc bixchem guzuloj cazam. Yuꞌm chiptioꞌp ijz. Abiꞌ dád badxa loj ree bén rigaꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Per gunabee Jesús laa reeman chitëë chu loj guiëb reeman ni goc, gunabee tëëman gudëëd reeman ni gawim. ");
INSERT INTO zasNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Baza Jesús yagaj, badxin ladxaman con ree xbejnman. ");
INSERT INTO zasNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Chi bidxin dxej raziiladx ree bejn, guzuloj culüüman bejn ree lën yadoo. Abiꞌ gra ree bén cucaagdiajg dád badxa loj reeman ni rnieeman, abiꞌ rëb reeman: ―¿Ban basiid bén guin gra ni rnieeman? ¿Ban gulëëman guialrigniaꞌ guin abiꞌ chu badëë guialrniabee zeel rüjnman milagr guin ree? ");
INSERT INTO zasNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Nid laaman na̱j bén carpinter ya, xiꞌn Li abiꞌ ree bijchaman na̱j Jacob, Xiëb, Judas, në Simón? Guiáad ree bizanman zojb luguiedx guie. Abiꞌ ad bidxgaꞌt reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Per rëbaman loj reeman: ―Guidibczi rajp reeman respejt tijb bén rudëë xtiidx Dios loj ree bejn. Per ladxaman achut rajp laaman respejt, niꞌqui lidxaman, niꞌqui ree xfamilaman ad rajpt laaman respejt. ");
INSERT INTO zasNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ad bileꞌt nüjn Jesús zien ree milagr yagaj. Bëlzi ree bénragxuu bayüjnman, badxiib yaaman guijc reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Dád badxalojman guial ad bililadxt reeman laaman. Dxel zëman guiedx na̱j ree gajxh, ziglüüman bejn ree. ");
INSERT INTO zasNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Dxel gurejdx Jesús guidxiptioꞌp ree xbejnman, abiꞌ guxhaalaman tioꞌp gaj reeman. Badëëman guialrniabee loj reeman din yabëë reeman xindxab ree luxdoo ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Dxel gunabeeman din achetczi chinë reeman par runejz, niꞌqui guijxh, niꞌqui guialraw, niꞌqui milia, tijbzi yagrliadx reeman, ");
INSERT INTO zasNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","con xgurëch reeman, con tijbzi lajd najcw reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Dxel rëbaman loj reeman: ―Yu lod guidxindi, tijbzi yagaj yayaꞌndi xt guidxin dxej yazadi luguiedx guin. ");
INSERT INTO zasNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Bal yuꞌ guiedx lod ad rënt reeman lëjt o ad rënt reeman gucaagdiajg reeman ni rnieedi, gol barii yagaj, gol gudxijp guxyuj guiaꞌdi ziꞌc sen guial ad rënt reeman guzoob reeman diidx. Din naj rni lojdi, guial dxej ni yadëëd ree bejn cwent loj Dios mazri casti naroob yayal reeman guial loj ree bén Sodoma në Gomorra. ");
INSERT INTO zasNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Zianz brii reeman ziguiedx reeman loj ree bejn guial rayal yayüjn reeman xgab por xtol reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Abiꞌ rabëë reeman zien ree xindxab luxdoo ree bejn, zien tëë ree bénragxuu gudëëb reeman sejt, abiꞌ bayüjn reeman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Chi biguiejn rey Herodes ni rüjn Jesús guial ruzaꞌt ree bejn laaman guidibczi, rëb reeman: ―Waj, bén baroobnijs bejn ree ma baban, zeel rajpaman guialrniabee rüjnman milagr ree. ");
INSERT INTO zasNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Per yuꞌ reeman rëb: ―Elíasan, bén rudëë xtiidx Dios loj ree bejn. Yuꞌza reeman rëb: ―Tijb bén rudëë xtiidx Dios loj ree bejnan lasaꞌ ree bén gocli. ");
INSERT INTO zasNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Chi biguiejn Herodes rëb reeman zian, rëbaman: ―Wajn, xin gunabeen biruꞌ yëjn, laaxan ma baban yan. ");
INSERT INTO zasNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Rëb Herodes guin zian din laagajcaman gunabee gunaaz reeman Waj, abiꞌ badxeꞌman laaman ladxguiib por Herodías. Herodías na̱j xbéngunaa Felip bijch Herodes. Per Herodes cwaꞌman Herodías. ");
INSERT INTO zasNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Abiꞌ guial rëb Waj loj Herodes: ―Ad laat tiaꞌ xbéngunaa bijchil. ");
INSERT INTO zasNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Zeel bidxeꞌch Herodías Waj, guyënman nugüjtaman laaman. Per ad rileꞌtan, ");
INSERT INTO zasNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","din rdxeb Herodes guial ragbeeman rüjn Waj ni rën Dios, rüjn tëëman ziꞌc rayal, zeel ad cwëjbtaman xhie nüjnnë Herodías Waj. Majsi ad ragbeet Herodes xhie güünman por ni rëb Waj lojman, per ruladxaman gucaagdiajgaman ni rnieeman. ");
INSERT INTO zasNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Per bidxin dxej been Herodías ni rënman. Chi bazaꞌ Herodes ijz, abiꞌ beenman lanij, badxeꞌman tijb guialraw par bén rniabee ree në par ree bén rniabee ree suldad nëtëë ree bén zojbloj niz Galilea. ");
INSERT INTO zasNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Dxel guyu xiꞌn Herodías lod cayajc lanij guin zianz bayaꞌm. Abiꞌ Herodes con ree xbioozaman dád bayuladx reeman ziꞌc bayaꞌm. Zeel rëb rey guin lojm: ―Gunab ni rëntzil, naj gune laan. ");
INSERT INTO zasNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Xt badëë xtiidxaman gudëëman ni guiniabtzim, majsi garol ni rajpaman. ");
INSERT INTO zasNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dxel bariim bignabdiidx loj xniaam, rëbim: ―¿Xhie ganaaban? Badxiꞌman laan rëbaman: ―Gunab guijc Waj bén ruroobnijs bejn ree. ");
INSERT INTO zasNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Laa bayugajquim lod zaꞌ rey Herodes, rëbim lojman: ―Yan gajc rënan guneel guijc Waj, bén ruroobnijs bejn ree, guneelan loj tijb pliajt. ");
INSERT INTO zasNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Dád guyu naya Herodes, per mal badëëd xtiidxaman guidib loj ree bén rigaꞌ, zeel ad bileꞌt nibexuuman nudëëman ni gunabim. ");
INSERT INTO zasNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Dxel gunabee Herodes tijb suldad din chicaꞌx guijc Waj. ");
INSERT INTO zasNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Zianz wej suldad guin lën ladxguiib guin, gutüꞌx guijc Waj badxeꞌxan loj pliajt binëxan lojm. Dxel bayü loj xniaamin. ");
INSERT INTO zasNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Chi gogbee ree xbejn Waj guial ma güjtaman, bacaꞌ reeman xcuerpaman persi biquieꞌch reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Chi bayejc ree xi apóstoles Jesús, be reeman diidx lojman gra ni been reeman në ni balüü reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Dxel rëb Jesús loj reeman: ―Gol guda, yoꞌ dunujz ree niz lod achut bejn zojb din yaziiladx ree taꞌn. Rëbaman zian guial dád zien ree bén zia zien tëë ree bén zëëd, xt niꞌqui guial gaw reeman ad rileꞌtan. ");
INSERT INTO zasNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Dxel Jesús con ree bén na̱j ree apóstoles zë reeman loj barcw tijb luar lod achut zojb. ");
INSERT INTO zasNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Per dád zien ree bejn baguiaa guial zë reeman, abiꞌ bayünbee reeman laa reeman zeel zien ree bejn brii luguiedx guin ree ruxüün reeman, abiꞌ yalojl laa reeman bidxin lod zë Jesús con ree xbejnman. ");
INSERT INTO zasNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Chi baguiajt Jesús loj barcw guin, baguiaaman bén guixiuj rigaꞌ yagaj, abiꞌ bayaman laa reeman guial zaꞌ reeman ziꞌc xiil achut rajp. Dxel guzuloj balüüman laa reeman, zien ree ni balüüman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Chi ma gudxe, gubig ree xbejnman, rëb reeman lojman: ―Ma gudxe yan, abiꞌ achut bejn zojb niz guie. ");
INSERT INTO zasNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Güjdx loj ree bén guin din che reeman ranch ree në ree guiedx ni rigaꞌ gajxh chisii xhienin gaw reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Per rëb Jesús loj reeman: ―Lëjt gol badëëd ni gaw reeman. Dxel rëb reeman lojman: ―Per zroꞌ daꞌt milia ryaadx din yoꞌ ni gaw ree bén guin, ziꞌct ni rüjn bejn gan loj tioꞌp gayuu dxej. ");
INSERT INTO zasNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Abiꞌ rëb Jesús loj reeman: ―¿Bël guiadxtil caꞌdi? Gol baguiaa don. Chi baguiaa reeman, dxel rëb reeman: ―Gaay guiadxtil con zatioꞌp bëjl. ");
INSERT INTO zasNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Dxel gunabeeman din cwe tibcwaa gaj reeman loj guixyaꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Zianz gurej reeman zian, yuꞌ lod gure tibgayuu reeman, yuꞌ lod gure tüꞌpchii reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Abiꞌ cwaꞌ Jesús guigaay guiadxtil guin con grop bëjl guin. Dxel gules lojman xanyabaa, badëëman quixtëë loj Dios, gulaꞌman guiadxtil guin badëëman loj ree xbejnman persi gudiꞌs reeman laan loj ree bén rigaꞌ, gudiꞌs tëëman grop bëjl guin loj gra reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Graczi reeman gudaw xt bigdxinladx reeman, ");
INSERT INTO zasNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","abiꞌ staczi bacha reeman chiptioꞌp dxüm guiadxtil laay con bëjl ni bayaꞌn. ");
INSERT INTO zasNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Loj ree bén gudaw noꞌch cost gaay mil xinguiaaw. ");
INSERT INTO zasNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Dxel gunabee Jesús guyu ree xbejnman loj barcw din tëdgaj reeman stiblad roꞌ nijs par guidxin reeman Betsaida, laꞌtgaj cuzaadiidxnëman benzien guin ree. ");
INSERT INTO zasNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Chi gulox bazaadiidxnëman laa reeman, wejman guijc tijb guiaꞌ, persi gurejdx gunabaman Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Chi ma cabej guiaal, ma yuꞌ barcw guin galay nijs guiáad Jesús bayaꞌn xtijbzaman guijc guiaꞌ guin. ");
INSERT INTO zasNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Dxel baguiaaman dád cazagdiaj ree xbejnman cusa reeman barcw guin guial rliaj bi niz loj barcw guin. Abiꞌ chi ma cayreguiaal zibig Jesús loj reeman cazaman loj nijs guin, beenman ziꞌc bén tëdnejz. ");
INSERT INTO zasNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Chi baguiaa reeman cazaman loj nijs guin gunaladx reeman sprijt malan, abiꞌ gurixdiaj reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Dád cadxeb reeman por ni cuguiaa reeman. Per guneenë Jesús laa reeman rëbaman: ―¡Gol baguꞌ luxdoodi, ad bal rdxebidi, najn! ");
INSERT INTO zasNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Dxel guyuman loj barcw guin, zianz gulëjz bi guin. Guiáad laa reeman dád badxa loj reeman, ");
INSERT INTO zasNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","din nayaaw xquiarguiejn reeman, abiꞌ ad bigniaꞌt reeman milagr ni beenman con guiadxtil guin ree. ");
INSERT INTO zasNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Chi ma gudëd reeman lojnijs guin bidxin reeman xdajn ree bén Genesaret, yagaj guxhii reeman barcw guin roꞌ nijs. ");
INSERT INTO zasNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Naabzi baguiajt reeman loj barcw guin, laa bayünbee gajc ree bejn Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Abiꞌ gutieꞌch reeman diidx guidib niz yagaj. Dxel guzuloj zinë ree bejn bénragxuu ree lod riguiejntzi reeman zaꞌ Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bantëëz zëman, majsi guiedx naroob o guiedx dobëz o ranch ree, rguijxh reeman bénragxuu guin ree niz lod tëdaman. Dxel rzajc reeman laaman liaadx din tiëbaman gugaal reeman majsi guiaꞌz xabaman. Abiꞌ graczi ree bén bagaal xabaman bayajc. ");
INSERT INTO zasNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tijb dxej, tioꞌp choon ree bénfarisew con ree mextr rajc ley, bén guza ree Jerusalén, bibig reeman loj Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Abiꞌ chi baguiaa reeman guial yuꞌ ree xbejn Jesús cayaw, ad banaat reeman ziꞌc na̱j costumbr. Dxel caneeguijdx reeman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Din bénfarisew në gra ree bén Israel zinaldxiꞌch reeman xcostumbr xbéngulal reeman guial ad zajct gaw reeman bal id reeman gunaa ziꞌc na̱j costumbr guin. ");
INSERT INTO zasNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Në chi raza reeman luguiaꞌ, ad rawt reeman bal id zunaa reeman ziꞌc na̱j costumbr guin. Dád zien ni zinal reeman güün reeman ziꞌc xhienaag quiib reeman re, con vajs, con ree trast guiib, në xloon reeman riguiib reeman.) ");
INSERT INTO zasNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Zeel bénfarisew ree con ree mextr guin, gunabdiidx reeman loj Jesús, rëb reeman: ―¿Chexc zeel ad runaat ree xbejnl ziꞌc na̱j xcostumbr dux béngulal ree? ¿Chexc zeel raw reeman zianzi? ");
INSERT INTO zasNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Dxel rëb Jesús loj reeman: ―¡Bén rusquiee!, waliqui ni gunee Isaías por lëjt, bén badëë xtiidx Dios loj ree bejn, chi bacaaman: Bén guie ree, rëbzi reeman guial rën daꞌt reeman naj, per ad rënt reeman naj con guidib luxdoo reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Xliaꞌczi rën daꞌt reeman naj, abiꞌ rulüü reeman bejn ree ganaxzi ni rbëëguijc ree bénguidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yan, rusaꞌndi xtiidx Dios tiblad persi zinalidi xcostumbr ree bénguidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Rëb tëë Jesús loj reeman: ―Par chitëë nit xcostumbridi zeel rusaꞌndi xtiidx Dios tiblad. ");
INSERT INTO zasNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Rëb Moisejs: “Gojp respejt xdadil con xniaal”, abiꞌ “Bén guzaal diidxmal guijc xdad o xniaa, rayal guiëtaman.” ");
INSERT INTO zasNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Per lëjt rëbidi guial zileꞌ guiëb bejn loj xDadaman o xniaaman: “Ad zajct günan lüj yudar, din gra ni raꞌpan na̱j Corbán” (Corbán rën guiëb gran na̱j par Dios). ");
INSERT INTO zasNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Rëbidi, bén guiëb zian, ad zileꞌtri güün xdad xniaaman yudar. ");
INSERT INTO zasNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Abiꞌ rbëëladxidi xtiidx Dios persi zinal xcostumbridi ni rulüü lasaꞌdi, në zien ree ni ren rüjndi lasaꞌ ree ni guin. ");
INSERT INTO zasNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Dxel gurejdx Jesús bén zien guin ree, rëbaman: ―Gol bacaagdiajg gradi gol bigniaꞌ tëë ni ganin: ");
INSERT INTO zasNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ad ni rawt bejn rüjn persi rüjnman dol. Ni ririi roꞌman në ni rüjnman, laan rüjn persi rüjnman dol. ");
INSERT INTO zasNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","¡Bén rën gucaagdiajg, gol bacaagdiajg! ");
INSERT INTO zasNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Chi baza Jesús lod zaꞌ ree bén guin bayuman lënü, dxel gunabdiidx ree xbejnman xhie rën guiëb ni rëbaman. ");
INSERT INTO zasNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Dxel rëbaman loj reeman: ―¿Në lëjt ad rigniaꞌt ni canin ya? ¿Nid ragbeedi ya guial ad ni rawt bejn rüjn persi rüjnman dol, ");
INSERT INTO zasNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","din ni raw bejn ad rejtan luxdooman, rejn lënman, abiꞌ rariin? Zian basigniaꞌman guial ad rüjnt bejn dol por ni rawzaman. ");
INSERT INTO zasNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Rëbaman: ―Ni ririi roꞌ bejn në ni rüjnman, laan rüjn persi rüjnman dol. ");
INSERT INTO zasNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Din guijc bejn zëëd graloj xgab mal, guial rüjn ni dxuudx, guialgubaan, guialrugüjt lasaꞌ, ");
INSERT INTO zasNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","guial rzunë béngunaa ren o xinguiaaw ren, guialrzëëbladx xieen ben ren, guial rüjn ni mal, guialrusquiee, guialrajp vijs, guialnadëdloj, guialrbëë xtiidx bejn, guialrüjn benroꞌ, në guial rüjn ni ad rayalt. ");
INSERT INTO zasNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Graczi ree ni guin zëëd guijc bejn, abiꞌ laan rüjn persi rüjnman dol. ");
INSERT INTO zasNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Chi baza Jesús niz yagaj, zëman niz Tiro në Sidón. Dxel guyuman tijb lënü guial ad guyëntaman niagbee ree bejn, per ad gojct nuquieꞌch lojman. ");
INSERT INTO zasNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Din gogbee gajc xniaa tijb bindoo yuꞌ xindxab luxdoo. Abiꞌ wej xniaam lod zaꞌ Jesús zianz bazuxibaman lojman. ");
INSERT INTO zasNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ad najtaman bén Israel, najman bén Sirofenicia. Dxel guzajcaman liaadx loj Jesús din yabëëman xindxab guin luxdoo bindoo guin. ");
INSERT INTO zasNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Per rëb Jesús lojman: ―Badëëdxgaj mod gaw yaloj ree xindoo, din ad rayalt chiquied bejn guiadxtil loj xiꞌnman din gudëëman laan gaw ree bëꞌcw. ");
INSERT INTO zasNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Badxiꞌ bén guinan rëbaman: ―Waliquil, Dad, per në ree bëꞌcw raw xguiadxtil laay reem ni ryajb xan mex. ");
INSERT INTO zasNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Dxel rëb Jesús: ―Laaqui guneel. Ma zajc yaguiajl, ma barii xindxab guin luxdoo xiꞌnl. ");
INSERT INTO zasNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Chi badxin lidx bén guin, baguiaaman laa bindo guin nagaꞌ loj loon, ma barii xindxab guin luxdoom. ");
INSERT INTO zasNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Baza Jesús niz Tiro, gudëdaman niz Sidón, në loj ree guiedx rigaꞌ Decápolis abiꞌ bidxinman roꞌnijsdoo Galilea. ");
INSERT INTO zasNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ni bidxinnë reeman tijb xinguiaaw nacwaꞌtix ad rajc tëët rnieex zagdxe. Abiꞌ rëb reeman loj Jesús din gudxiib yaaman guijquix. ");
INSERT INTO zasNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Zianz binë Jesús laax tiblad, badxeꞌ xbacwënman lën guidiajguix, abiꞌ con xhiejnman bagaalaman lüdxix. ");
INSERT INTO zasNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Dxel gules lojman xanyabaa, banajladxaman, rëbaman: ―¡Efata! ―rën guiëban: ¡Baxal! ");
INSERT INTO zasNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Loj hor zii gajc baxal ree guidiajg xin guin, baban lüdxix dxel guzuloj caneex zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Dxel gunabee Jesús laa reeman chitëë chu loj guiëb reeman ni goc. Per guial rëbaman zian, mazri rü reeman laan loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Dád badxa loj reeman rëb reeman: ―Xi zagdxe na̱j gra ree ni rüjnman, xt rüjnman persi riguiejn ree bén nacwaꞌt, abiꞌ ree bengop rniee reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tijb dxej bidoꞌp zien ree bejn abiꞌ achet ni gaw reeman. Dxel gurejdx ree xbejn Jesús rëbaman loj reeman: ");
INSERT INTO zasNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Rayan bén guin ree din ma gojc choon dxej nadxuꞌnëꞌ reeman guie, abiꞌ ad caꞌt ni gaw reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Abiꞌ bal yaxhalan laa reeman lidx reeman sin guialraw, dool yadaj reeman lunejz, din yuꞌ reeman zëëd zijt. ");
INSERT INTO zasNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Dxel rëb ree xbejnman: ―Per, ¿ban guin yucaꞌn ni gaw ree bén guin, achutczi bejn zojb niz guie? ");
INSERT INTO zasNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Dxel gunabdiidxaman loj reeman rëbaman: ―¿Bël guiadxtil caꞌdi? Abiꞌ rëb reeman: ―Gajdxan. ");
INSERT INTO zasNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Dxel gunabeeman gurej ree bén guin luyuj. Zianz cwaꞌman guigajdx guiadxtil guin, badëëman quixtëë loj Dios, abiꞌ gulaꞌman laa reen badëëd loj ree xbejnman persi gudiꞌs reeman laa reen loj gra ree bén guin. ");
INSERT INTO zasNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nëgajc tioꞌp choon ree bëjldoo caꞌ reeman, abiꞌ badëëman quixtëë loj Dios dxel gunabeeman gudiꞌs reeman në laa reeb loj ree bén guin. ");
INSERT INTO zasNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Graczi reeman gudaw xt bigdxinladx reeman, abiꞌ staczi bacha reeman gajdx dxüm guiadxtil laay në bëjl ni bayaꞌn. ");
INSERT INTO zasNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bén gudaw ree na̱j reeman cost tajp mil. Chi gulox gudaw reeman, dxel bazaadiidxnë Jesús laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Zianz guyuman loj barcw con ree xbejnman zë reeman niz Dalmanuta. ");
INSERT INTO zasNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Dxel bidxin ree bénfarisew, guzuloj cadildiidxnë reeman Jesús, abiꞌ par güün reeman laaman prueb, gunab reeman güünman tijb milagr ziꞌc tijb sen guial por Dios zëëdaman. ");
INSERT INTO zasNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Dxel banajladx Jesús, rëbaman: ―¿Chexc zeel rëndi günan tijb milagr? Diidxli ganin, achetczi milagr günan guguiaadi. ");
INSERT INTO zasNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Dxel basaꞌnman laa reeman, bayuman loj barcw zatijb, zignë ree xbejnman stiblad roꞌ nijs guin. ");
INSERT INTO zasNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Bayanladx ree xbejn Jesús ninë reeman guialraw, tijbzi guiadxtil caꞌ reeman loj barcw guin. ");
INSERT INTO zasNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Abiꞌ chi rëbaman loj reeman: ―Gol gojp cudad con xlevadur ree bénfarisew në xlevadur Herodes. ");
INSERT INTO zasNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Dxel guzuloj rëb loj lasaꞌ reeman: ―Naman duloj ree zian guial ad nacaꞌt ree guiadxtil. ");
INSERT INTO zasNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Abiꞌ gogbee Jesús ni canee reeman, zianz rëbaman: ―¿Chexc zeel rëbidi guial ad caꞌtidi guiadxtil? ¿Staczi ad rigniaꞌtidi ya? ¿Sta nayaaw xquiarguiejndi ya? ");
INSERT INTO zasNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yuꞌ guiaalojdi per rulüü ad ruguiaatidi, yuꞌ guidiajguidi per rulüü ad riguiejntidi. ¿Nid rusaaladxidi ya? ");
INSERT INTO zasNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Chi gudiꞌsan gaay guiadxtil loj gaay mil bejn, ¿bël dxüm ni laay batoꞌpidi? Badxiꞌ reeman laan rëb reeman: ―Chiptioꞌpan. ");
INSERT INTO zasNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Dxel rëbaman: ―Laadx chi gudiꞌsan gajdx guiadxtil loj tajp mil bejn, ¿bël dxüm guidxa bacaꞌdi? Badxiꞌ reeman laan rëb reeman: ―Gajdxan. ");
INSERT INTO zasNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Dxel rëbaman: ―¿Staczi ad waygniaꞌtidi ya? ");
INSERT INTO zasNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Chi bidxin Jesús guiedx Betsaida con ree xbejnman. Binë ree bejn tijb bén ad ranit loj, rëb reeman loj Jesús din gugaalaman guiaalojman. ");
INSERT INTO zasNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Dxel gunaaz Jesús yaaman gulëëman laaman luguiedx guin, abiꞌ gudëëb xhiejnman guiaalojman, baquiꞌman guiaalojman. Zianz gunabdiidxaman rëbaman: ―¿Rajc ruguiaal taꞌn ya? ");
INSERT INTO zasNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Dxel guzuloj cuguiaaman, abiꞌ rëbaman: ―Ruguian bejn ree, per rulüü na̱j reeman ziꞌc yag ni caza. ");
INSERT INTO zasNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Dxel bagaal Jesús guiaalojman stijb, abiꞌ rëbaman lojman din guguiaadxijchaman, dxel guzuloj cuguiaaman zagdxe, naynidxuj ma ruguiaaman gra. ");
INSERT INTO zasNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Abiꞌ baxhaal Jesús laaman lidxaman, rëbaman: ―Ad yayul luguiedx guin achu tëë loj guiëbil xhienaag bayajc lojl. ");
INSERT INTO zasNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Bazanë ree xbejn Jesús niz Galilea, wej reeman guiedx rigaꞌ ree Cesarea de Filipo. Chi zë reeman lunejz gunabdiidx Jesús loj ree xbejnman, rëbaman: ―¿Chu rëb ree bejn najn? ");
INSERT INTO zasNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Badxiꞌ reeman laan rëb reeman: ―Yuꞌ reeman rëb lüj na̱j Waj bén baroobnijs bejn ree, yuꞌza reeman rëb lüj na̱j Elías, yuꞌ tëë reeman rëb lüj na̱j tijb ree bén badëëd xtiidx Dios loj ree bejn gocli. ");
INSERT INTO zasNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Dxel gunabdiidxaman rëbaman: ―Laadx lëjt, ¿xhie nadi chu najn? Badxiꞌ Bëdan rëbaman: ―Lüj na̱j Cristo. ");
INSERT INTO zasNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Per rëb Jesús loj reeman achu loj guiëb reeman zian. ");
INSERT INTO zasNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Guzuloj Jesús rëb loj ree xbejnman: ―Rayal sagdiaj daꞌt Bén guxhaal Dios. Ad zënt ree guxtis Israel laaman, niꞌqui ree bixhioz rniabee ree bixhioz, niꞌqui ree mextr rajc ley. Gugüjt reeman laaman, per ni yayon dxej yabanman. ");
INSERT INTO zasNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Zagdxe basigniaꞌman laa reeman. Dxel gulëëcaan Bëd laaman, rëbaman lojman chitëë rëbraman zian. ");
INSERT INTO zasNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Per badxiꞌ lojman baguiaa ree xbejnman, dxel gudilëman Bëd rëbaman: ―¡Bisüd lon, Satanás!, din ad por Diost zëëd ree xgab ni rüjnl, rüjnl ziꞌc na̱j xixgab bénguidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Dxel gurejdx ree xbejn Jesús con ree bén rigaꞌ yagaj, abiꞌ rëbaman loj reeman: ―Bal chu rën gac da bejnan, ad rayalt güünman ziꞌc na̱j xixgabaman. Siibnejzaman guialzi ni tëdzaman abiꞌ guidnalaman naj. ");
INSERT INTO zasNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Din bén mazri rën guialnaban ni rajpaman loj guidxliuj guie, zadxin dxej gusëëbaman laan, per bén guiët por naj në por da diidxan, zajpaman guialnaban tiblayaa con Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Xhie gan güün bejn gapaman gra ni yuꞌ loj guidxliuj bal canijtaman loj Dios? ");
INSERT INTO zasNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Din ad zileꞌt sii bejn xguialnabanman xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Din bén yatunë naj në da diidxan niz loj ree béndol bén ad zinalt ree xnejz Dios, bén rigaꞌ ree yan, ziangajc naj, najn Bén guxhaal Dios, yatunëꞌn laaman chi guialan con xguialrniabee da Dadan con ree xianjlaman. ");
INSERT INTO zasNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Rëb tëë Jesús loj reeman: ―Diidxliczi ganin, yuꞌ ree bén zaꞌ guie, ad zëjtt xt guguiaa reeman guiꞌt xguialrniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Chi goc xhoꞌp dxej, wej Jesús tijb ruguiaꞌya, binëman Bëd, Jacob con Waj. Yagaj bidxaa Jesús niz loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Balaa xabaman bachaꞌ, gojcan naquichbëj, achutczi rguiib lajd zian loj guidxliuj guie. ");
INSERT INTO zasNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Dxel baguiaa reeman Elías në Moisejs cayünë reeman Jesús diidx. ");
INSERT INTO zasNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Abiꞌ rëb Bëd lojman: ―Mextr, ¡zagdxen nadxuꞌn guie! Yaguieenan choon ranch, tijban par lüj, tijban par Moisejs, zatijban par Elías. ");
INSERT INTO zasNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Per ad ragbeet Bëd xhienin caneeman guial dád bidxeb reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Loj hor guin biguiajt tijb za̱j beenan bala guijc reeman, abiꞌ loj za̱j guin biguien chaꞌ bejn rëbaman: ―Bén guie na̱j da Xiꞌnan, bén rën daꞌtan, gol bazoob xtiidxaman. ");
INSERT INTO zasNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Abiꞌ chi baguiaa reeman gadëd lod zaꞌ reeman achutri zaꞌnë Jesús, tijbzi laaman zaꞌ yagaj. ");
INSERT INTO zasNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Laꞌtgaj cayguiajt reeman ruguiaꞌ guin, rëb Jesús loj reeman chitëë chu loj guiëb reeman ni baguiaa reeman, xt yaban Bén guxhaal Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Abiꞌ laaz reeman ragbee ni baguiaa reeman, rniabdiidx tëë loj lasaꞌ reeman xhie rën guiëb guial yabanman loj ree bengüt. ");
INSERT INTO zasNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Dxel gunabdiidx reeman loj Jesús, rëb reeman: ―¿Chexc zeel rëb ree mextr rajc ley guial yaloj Elías guiꞌt? ");
INSERT INTO zasNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Badxiꞌman laan rëbaman: ―Walican yaloj Elías guiꞌt, laaman guzuxnejz gra. Per, ¿chexc zeel ca loj xtiidx Dios guial Bén guxhaal Dios sagdiaj daꞌtaman ad zën tëët reeman laaman? ");
INSERT INTO zasNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Naj rni lojdi guial mal biꞌt Elías, abiꞌ beennë reeman laaman ni guyëntzi reeman ziꞌc ca loj xtiidx Dios ni rayal sacaman. ");
INSERT INTO zasNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Chi badxin Jesús lod zaꞌ staꞌn ree xbejnman, baguiaaman dád zien bejn rigaꞌ, në ree mextr rajc ley zaꞌ yagaj cadildiidx reeman con ree xbejnman. ");
INSERT INTO zasNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Chi baguiaa reeman zëëd Jesús, dád badxa loj reeman abiꞌ baxüün reeman bicajpdioz reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Dxel gunabdiidxaman loj reeman rëbaman: ―¿Chexc zeel cadildiidxidi? ");
INSERT INTO zasNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Abiꞌ rëb tijb bén zaꞌ yagaj: ―Mextr, zidnëꞌ da xiꞌnan lojl guial yuꞌ xindxab luxdoox abiꞌ nusaꞌnx laax gop. ");
INSERT INTO zasNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Bantëëz guin zaꞌx, chi ru xindxab guin luxdoox rureeyujx laax, abiꞌ rbëëx bichijn roꞌx, raw tëë ree layix, dxel ratiaguix. Ma gunaaban loj ree xbejnl din nabëë reeman xindxab guin, per ad gojct reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Zeel rëb Jesús: ―¡Bén ad rliladxt! ¿Xt goc gazunëꞌn lëjt gadaan tëën lëjt? Gol tanë xinzii guie. ");
INSERT INTO zasNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dxel binë reeman laax lojman. Per chi baguiaa xindxab guin laaman, laa bagüjtyaꞌgajquix xin guin, bareeyujx laax abiꞌ rbixtüjpix ririi tëë bichijn roꞌx. ");
INSERT INTO zasNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Dxel gunabdiidx Jesús loj xdadix rëbaman: ―¿Goc guzuloj rajquix zian? Badxiꞌman laan rëbaman: ―Diizd xindobëzix. ");
INSERT INTO zasNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Dád zien volt ruzaalix laax loj guij në loj nijs din guiëtix. Zeel bal zajc güünl xhienin por dunujn, gognë dunujn, baya dunujn. ");
INSERT INTO zasNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Dxel rëb Jesús lojman: ―¿Chexc zeel nal, “bal zajcan”? Graczan zajc bal chu rliladx naj. ");
INSERT INTO zasNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Dxel gurixdiaj xdadix rëbaman: ―¡Rliladxan lüj, gognë naj din chililadxan mazri! ");
INSERT INTO zasNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Chi baguiaa Jesús cadoꞌp zien bejn dxel gudilëman xindxab yuꞌ luxdoo xin guin, rëbaman: ―Xindxab gop nacwaꞌt tëë, rniabeen lüj din yariil luxdoo xin guin. Ad bal yayejcril luxdoox zatijb. ");
INSERT INTO zasNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Dxel gurixdiaj xindxab guin, abiꞌ bagüjtyaꞌx laax zatijb abiꞌ bariix luxdoox, basaꞌnx laax ziꞌc xingüt zeel rëb ree bejn guial ma güjtix. ");
INSERT INTO zasNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Per gunaaz Jesús yaax gulesaman laax, dxel guzulix. ");
INSERT INTO zasNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Dxel bayu Jesús lënü con ree xbejnman, abiꞌ gunabdiidx reeman lojman, rëb reeman: ―¿Chexc zeel ad gojct nalëën xindxab guin luxdoo xin guin? ");
INSERT INTO zasNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Badxiꞌ Jesúsan rëbaman: ―Par yarii lasaꞌ ree xindxab guin, rayal cwedx guiniabidi Dios guibaꞌn tëëdi. ");
INSERT INTO zasNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Chi baza reeman yagaj, gudëd reeman niz Galilea, per ad guyënt Jesús chu niagbee guial cadëdaman niz yagaj, ");
INSERT INTO zasNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","guial culüü ree xbejnman, rëbaman: ―Yayü reeman Bén guxhaal Dios loj ree bén gugüjt laaman, per ni gac choon dxej yabanman. ");
INSERT INTO zasNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Per laa reeman ad bigniaꞌt reeman ni rëbaman, abiꞌ bidxeb reeman niniabdiidx reeman lojman. ");
INSERT INTO zasNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Dxel badxin Jesús Capernaum con ree xbejnman, abiꞌ badxin reeman yu lod zojb reeman. Dxel gunabdiidxaman loj reeman rëbaman: ―¿Xhie diidxan rüdi lunejz chi zioꞌp ree? ");
INSERT INTO zasNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Per achet rëb reeman guial cadildiidx reeman lunejz chu reeman mazri zojbloj. ");
INSERT INTO zasNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Dxel gurej Jesús, gurejdxaman guidxiptioꞌp reeman, rëbaman: ―Bal chu bén rën gac mazri bén zojbloj lojdi, rayal güün laagajcaman ziꞌc tijb bén ad zojblojt güün tëëman sirv loj gradi. ");
INSERT INTO zasNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Dxel cwaꞌman tijb xindoo, bazujman laax galay reeman, zianz gudiidxaman laax, rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Bén ridxgaꞌ tijb xindoo por naj, najn ridxgaꞌman, guiáad bén ridxgaꞌ naj, bén guxhaal najn ridxgaꞌman. ");
INSERT INTO zasNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Rëb Waj loj Jesús: ―Mextr, baguiaan tijb bejn rabëëman xindxab luxdoo ree bejn por xguialrniabeel. Per badxoonan guial ad najtaman dux bejn ree. ");
INSERT INTO zasNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Badxiꞌ Jesúsan rëbaman: ―Ad rudxoondi, din bén rüjn milagr por da guialrniabeen, ad zileꞌt guinieeguijdxaman naj. ");
INSERT INTO zasNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Bén ad zaꞌt contr dunuj ree, zaꞌman con dunuj ree. ");
INSERT INTO zasNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Chutëëz bén gunee majsi tibxijgzi nijs lojdi guial najdi xbejn Cristo, diidxli rnin guial ziangajc yuꞌ ni gudëëd Dios lojman. ");
INSERT INTO zasNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Chutëëz bén guzaalguiiw tijb bén qui rliladxri naj din güünman dol, par laaman zagdxeli na̱j guixhii reeman tijb guiaj mulin yëjnman guzaal reeman laaman loj nijsdoo. ");
INSERT INTO zasNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Bal laagajc yaal rusajb lüj loj dol, zagdxeli gutüꞌn. Mazri zagdxe chuꞌ con tibladzi yaal xanyabaa, guial che con grop yaal gabijl loj bajl ni ad yuꞌt dxej yayüꞌ, ");
INSERT INTO zasNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","lod ad rëjtt ree bizog lod ad rayüꞌ tëët bajl. ");
INSERT INTO zasNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Abiꞌ bal laagajc guiaꞌl rusajb lüj loj dol, zagdxeli gutüꞌn. Mazri zagdxe chuꞌ con tibladzi guiaꞌl xanyabaa guial che con groplad guiaꞌl gabijl lod yuꞌ bajl ni ad yuꞌt dxej yayüꞌ, ");
INSERT INTO zasNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","lod ad rëjtt ree bizog lod ad rayüꞌ tëët bajl. ");
INSERT INTO zasNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Bal laagajc guiaalojl rusajb lüj loj dol, zagdxeli gulëën. Mazri zagdxe chuꞌ con tibladzi guiaalojl xanyabaa guial che con groplad guiaalojl gabijl lod yuꞌ bajl ni ad yuꞌt dxej yayüꞌ, ");
INSERT INTO zasNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","lod ad rëjtt ree bizog lod ad rayüꞌ tëët bajl. ");
INSERT INTO zasNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Ziꞌc ru zëd guijc guialraw, ziangajc ree bén rliladx naj sagdiaj reeman din gac reeman naya. ");
INSERT INTO zasNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","’Ni zagdxe na̱j zëd, per bal id zajcran naxij, ¿xhieza naag yayajcan naxij zatijb? Gol been ziꞌc rayal chitëë saquidi ziꞌc zëd ni ad rüjnt sirv, gol gubajnnë tëë lasaꞌdi zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Chi baza Jesús Capernaum, dxel wejman niz Judea në stiblad roꞌ guiiw Jordán. Abiꞌ lod zaꞌman bidoꞌp ree bejn zatijb, dxel guzuloj culüüman laa reeman ziꞌc goc xcostumbraman. ");
INSERT INTO zasNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Yuꞌ ree bénfarisew gubig lod zaꞌman. Abiꞌ par güün reeman laaman prueb, gunabdiidx reeman lojman rëb reeman: ―¿Zajc yalaꞌ xinguiaaw lacheelix ya? ");
INSERT INTO zasNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Badxiꞌman laan rëbaman: ―¿Xhie gunabee Moisejs güündi? ");
INSERT INTO zasNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Abiꞌ rëb reeman: ―Cwëjb Moisejs yalaꞌ xinguiaaw lacheelix, per gudëëdix guiꞌch tiaꞌman guial ma balaꞌ reex. ");
INSERT INTO zasNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Dxel rëb Jesús: ―Rëb Moisejs gac zian guial nadidi. ");
INSERT INTO zasNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Per guiaꞌxchej chi guleꞌcchaaw Dios guidxliuj, “beenman xinguiaaw con béngunaa”. ");
INSERT INTO zasNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Zeel xinguiaaw gusaꞌn xdad xniaax din guibannë lacheelix, ");
INSERT INTO zasNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","dxel grop reex ma gac ziꞌc tijbzi bejn.” Zianan zeel ad najtri reex tioꞌp, ma na̱j reex tijbzi. ");
INSERT INTO zasNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Zeel, bénguidxliuj ad rayalt yalaꞌman lasaꞌ ni ma bachajg Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Chi bayu reeman lënü, gunabdiidx ree xbejnman lojman zatijb, xcwent ni guneeman. ");
INSERT INTO zasNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Abiꞌ rëbaman loj reeman: ―Xin ralaꞌ lacheel, abiꞌ rtiaꞌx ben ren dolan cayüjnx, ");
INSERT INTO zasNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ziangajc bal tijb béngunaa yalaꞌ lacheelaman abiꞌ tiaꞌ xin ren laaman, dolan cayüjnman. ");
INSERT INTO zasNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Binë ree bejn xindoo ree lod zaꞌ Jesús din gudxiib yaaman guijc reex. Per ree xbejnman guzuloj cadilë reeman bén binë ree laa reex. ");
INSERT INTO zasNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Chi baguiaa Jesús zian, balenman zeel rëbaman: ―Gol badëëd mod guiꞌt reex lon, ad bal rudxoondi. Din lod rniabee Dios na̱j par ree bén na̱j ziꞌc laa reex. ");
INSERT INTO zasNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Diidxliczi rnin, bén ad rliladxt xguialrniabee Dios ziꞌc tijb xindoo, ad zileꞌt chuꞌman lod rniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Dxel gudiidx Jesús laa reex, badxiib yaaman guijc reex, beenleꞌman laa reex. ");
INSERT INTO zasNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Chi ma gusnuu xnejz Jesús, ruxüün tijb xinguiaaw bidxinx abiꞌ bazuxibix lojman, dxel gunabdiidxix rëbix: ―Mextr zaꞌc, ¿xhie rayal günan din gaꞌpan guialnaban tiblayaa con Dios? ");
INSERT INTO zasNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Badxiꞌ Jesús laan rëbaman: ―¿Chexc zeel nal lon benzaꞌc? Achut na̱j benzaꞌc, tijbzi Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Lüj rajc ree mandamient, “Ad gugüjtil bejn, ad sunël béngunaa ren, ad cwanl, ad cwëël xtiidx bejn ad gusquiee tëël, gojp respejt xdad xniaal.” ");
INSERT INTO zasNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Dxel rëbix loj Jesús: ―Mextr, gra ree ni guin cayünan diizd xindoon. ");
INSERT INTO zasNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Baguiaa Jesús lojx, bayaman laax, rëbaman: ―Per yuꞌ zatijb ni riaadx güünl: bigtoꞌ gra ni rajpil, badëëd milia guin loj ree bénprob, zian gapil guialnazaꞌc xanyabaa dxel guidnalil naj majsi xhietëëz saquil. ");
INSERT INTO zasNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Chi biguiejn xin guin zian, ad nixt guyu luxdoox abiꞌ dád yuꞌnayax ziax guial dád xinrijcwan. ");
INSERT INTO zasNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Dxel baguiaa Jesús loj gra reeman, abiꞌ rëbaman loj ree xbejnman: ―¡Dád nawëëg na̱j chuꞌ benrijcw loj xguialrniabee Dios! ");
INSERT INTO zasNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Dád badxa loj ree xbejnman ni rëbaman. Per rëbaman loj reeman zatijb: ―Xiꞌn, ¡bén yuꞌguijc mazri ni rajpaman, dád nawëëg na̱j chuꞌman loj xguialrniabee Dios! ");
INSERT INTO zasNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Adli nawëëgt tëd tijb camell xan gagux guial chuꞌ tijb benrijcw loj xguialrniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Chi biguien reeman diidx guin ree, mazri badxa loj reeman, dxel rniabddiidx loj lasaꞌ reeman, rëb reeman: ―¿Chu zajc laa loj xcasti Dios? ");
INSERT INTO zasNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Baguiaa Jesús loj reeman, abiꞌ rëbaman: ―Par bejn nawëëgan, per par Dios ad nawëëgtan din par Dios graczan zileꞌ gac. ");
INSERT INTO zasNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Dxel guzuloj rëb Bëd loj Jesús: ―Dunujn basaꞌnan graczi ni rayaꞌpan persi zudnaalan lüj. ");
INSERT INTO zasNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Badxiꞌ Jesúsan rëbaman: ―Diidxliczi ganin lëjt, chutëëz bén rusaꞌn lidx, o bijch, o bizan, o xdad xniaa, o lacheel o xiꞌn, o guidxliuj ree por naj në por xtiidxzaꞌc Dios, ");
INSERT INTO zasNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","loj guidxliuj guie tiaꞌman tibgayuu volt mazri guial loj ni basaꞌnman, bal najn lidxaman, bijchaman, bizanman, xniaaman, xiꞌnman, në xguidxliujman, majsi guidib wazagdiaj, abiꞌ guidxin dxej gapaman guialnaban tiblayaa con Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Per dád zien ree bén na̱j bén yaloj yan, gac reeman bén bigra, guiáad ree bén na̱j bén bigra yan, gac reeman bén yaloj. ");
INSERT INTO zasNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Chi zë reeman Jerusalén, ned Jesús loj ree xbejnman, abiꞌ dád radxaloj reeman guial zëman Jerusalén, guiáad ree bén nal laaman rdxeb reeman. Dxel gurejdx guidxiptioꞌp ree xbejnman lood ren, zianz guzuloj rëbaman ni sacaman: ");
INSERT INTO zasNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","―Rëbaman loj reeman: Lëjt ragbee guial ziyoꞌ ree Jerusalén, abiꞌ naj najn Bén guxhaal Dios, yayü reeman naj loj ree bixhioz rniabee ree bixhioz, në loj ree mextr rajc ley. Abiꞌ nabee reeman guiëtan, yayü tëë reeman naj loj ree bén ad najt bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Guzeꞌ reeman naj, gucojp xhiejn reeman lon, quin reeman gugüjt tëë reeman naj, per yayon dxej yabanan. ");
INSERT INTO zasNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Dxel Jacob con Waj xiꞌn Zebedeo, gubig reeman loj Jesús rëb reeman: ―Mextr, rayënan güünl tijb favor ni yanaaban lojl. ");
INSERT INTO zasNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Abiꞌ gunabdiidxaman rëbaman: ―¿Xhie rëndi günan? ");
INSERT INTO zasNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Badxiꞌ reeman laan rëb reeman: ―Rayënan guial chi ma canabeel, yadxuꞌn cwëꞌl, tijb dunujn yadxuꞌ xladbeel, zatijb dunujn yadxuꞌ xladruvejsil. ");
INSERT INTO zasNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Badxiꞌman laan rëbaman: ―Niꞌquid ragbeetidi xhie ni guin rniabidi. ¿Wen zajc sagdiajdi ziꞌc gazaagdiajn ya? ¿Zajc guiëtidi ziꞌc guiëtan ya? ");
INSERT INTO zasNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Badxiꞌ reeman laan rëb reeman: ―Zayajcan. Dxel rëb Jesús: ―Waliquidi sagdiajdi ziꞌc naj guiët tëëdi ziꞌc naj, ");
INSERT INTO zasNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","per guial cwedi da ladbeen o da ladruvejsan, ad najt rayal gune laan, din ma najn par ree bén rayal laan. ");
INSERT INTO zasNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Chi biguien zachii xbejn Jesús ni rëb reeman, dád balen reeman Jacob con Waj, ");
INSERT INTO zasNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","per gurejdx Jesús laa reeman rëbaman: ―Lëjt ragbee guial ree bén rniabee loj guidxliuj guie, rniabee reeman bejn ree ziꞌctzi rën reeman, guiáad ree bén zojbloj rüjnnë reeman bejn ree ziꞌctzi rën reeman por guialrniabee ni rajp reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Per con lëjt ad rayalt gac zian. Din bal chu rën gac bén rniabee lojdi, rayal güünman sirv lojdi, ");
INSERT INTO zasNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","guiáad bén rën gac bén zojbloj, rayal güünman sirv loj gradi ziꞌc bén nadoꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Din niꞌqui naj najn Bén guxhaal Dios, ad zialtan loj guidxliuj par güün ree bejn sirv lon, zialan din günan laa reeman sirv, abiꞌ con da guialnabanan gaguixan por xtol zien ree bénguidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bidxin reeman guiedx Jericó, abiꞌ chi ma cayrii Jesús luguiedx guin, con ree xbejnman në ree benzien. Tijb xin ad ranit loj lax Bartimeo, xiꞌn bén la Timeo, zojbix cwëꞌ nejz rniabix carda. ");
INSERT INTO zasNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Chi biguiejnx cadëd Jesús bén Nazaret niz yagaj, guzuloj cabidxaꞌx rëbix: ―¡Jesús, xdiaa Davi, baya naj! ");
INSERT INTO zasNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Dád zien ree bejn ridilë laax din yacwëëz roꞌx. Per mazri rejs rbidxaꞌx rëbix: ―¡Xdiaa Davi, baya naj! ");
INSERT INTO zasNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Dxel guzudxe Jesús rëbaman: ―Gol gurejdxix. Dxel gurejdx reeman laax, rëb reeman: ―Baguꞌ luxdool, bisu, lüj caneeman. ");
INSERT INTO zasNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Dxel laa badxeꞌbi gajc xin guin lajd najcwix luya, xt gutiajsix guzulix bibiguix loj Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Gunabdiidx Jesús lojx rëbaman: ―¿Xhie rënl günan por lüj? Badxiꞌxan rëbix: ―Mextr, rënan yani lon. ");
INSERT INTO zasNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Dxel rëb Jesús: ―Ma zajc yaguiajl, ma bayajquil guial bililadxil naj. Loj hor zii gajc bani lojx dxel zinalix Jesús niz yagaj. ");
INSERT INTO zasNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Chi ma zë reeman gajxh Jerusalén, niz lod rigaꞌ guiedx Betfagé con Betania, gajxh guiaꞌ la Olivos, dxel guxhaal Jesús tioꞌp ree xbejnman, ");
INSERT INTO zasNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","rëbaman: ―Gol chej guiedxdo rigaꞌ delant guin. Chi guidxindi guidxaaglojdi tijb burquieꞌn, caduub achut wabib laab. Gol guxhiequib gol tanëb. ");
INSERT INTO zasNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Abiꞌ bal chu guiniabdiidx lojdi: “Chexc zeel caxhiequidi laab”, gol güjdx: “Dad Jesús cayaadx laab, doo yaxhaal gajcaman laab.” ");
INSERT INTO zasNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Dxel wej reeman, bidxaagloj gajc reeman burdo guin, caduub runejz roꞌ tijb port, abiꞌ guxhiec reeman laab. ");
INSERT INTO zasNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Bén baguiaa ree zian gunabdiidx reeman loj reeman, rëb reeman: ―¿Xhie rüjndi? ¿Chexc zeel caxhiequidi burdo guin? ");
INSERT INTO zasNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Badxiꞌ reeman laan ziꞌc rëb Jesús, abiꞌ cwëjb ree bén guin zinë reeman laab. ");
INSERT INTO zasNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bidxinnë reeman laab lojman, badxiib xab reeman xijchib, persi gudxibaman laab. ");
INSERT INTO zasNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Zien ree bejn riguijxh xab niz lod rdëdaman, yuꞌ tëë reeman rutüüg zijn persi rguijxh reeman laan niz lod rdëdaman. ");
INSERT INTO zasNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Abiꞌ ziꞌc ree bén ned, në ree bén nal rbixdiaj reeman, rëb reeman: ―¡Gagnëman dunuj ree yan! ¡Nagleꞌ bén zëëd por Dios! ");
INSERT INTO zasNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Nagleꞌ bén zëëd nabee ziꞌc dux béngulal ree rey Davi! ¡Quixtëë dux Dad ree Dios Bén yuꞌ xanyabaa! ");
INSERT INTO zasNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Zian guyu Jesús Jerusalén abiꞌ guyuman lën yadooroꞌ Jerusalén. Chi gulox baguiaaman graczi, dxel zinë guidxiptioꞌp ree xbejnman Betania guial ma gudxe. ");
INSERT INTO zasNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Chi bareguiaal, barii reeman Betania. Dxel guzuloj calaan Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Zijtri baguiaaman tijb yag higo ca ree balag lojn. Abiꞌ wejman biquiaaman bal ca higo lojn. Per achet bidxaaglojman, balagzi ree ca lojn din ad xtiamptanan. ");
INSERT INTO zasNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Dxel rëbaman loj yag higo guin: ―¡Ad yuꞌtri dxej gaw bejn ninejxh tia lojl! Abiꞌ biguiejn ree xbejnman ni rëbaman. ");
INSERT INTO zasNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Chi bidxin reeman Jerusalén. Dxel guyu Jesús roꞌ yadooroꞌ Jerusalén guin, abiꞌ guzuloj caybëëman bén cutoꞌ ree në ree bén cazii. Barexguiataman xmex ree bén ruchaa milia con xyagxhil ree bén rutoꞌ ree palom, ");
INSERT INTO zasNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ad rtiëjbtaman xhie chuꞌnë ree bejn roꞌ yadoo guin. ");
INSERT INTO zasNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Abiꞌ guzuloj culüüman laa reeman, rëbaman: ―Loj xtiidx Dios rëb: “Lidxan grii laj yu lod rbejdx rniab bejn Dios.” Per lëjt nüjndan ziꞌc lidx ree xingubaan. ");
INSERT INTO zasNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bixhioz rniabee ree bixhioz con ree mextr rajc ley, chi biguiejn reeman ni rëb Jesús, guzuloj raguiil reeman mod xhienaag gugüjt reeman Jesús, guial rdxeb reeman laaman din gra bejn radxaloj ni rulüüman. ");
INSERT INTO zasNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Chi ma caxhin, bazanë ree xbejn Jesús Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Chi bareguiaal rsildoo, badëd reeman niz lod zojb yag higo guin, abiꞌ baguiaa reeman ma gubidx diizd liujn. ");
INSERT INTO zasNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Dxel basaaladx Bëd ni rëb Jesús, abiꞌ rëbaman lojman: ―Mextr, ¡baguiaa yag higo ni bazaalil diidx guijc ma gubidxan! ");
INSERT INTO zasNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Badxiꞌ Jesúsan rëbaman: ―Gol bililadx Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Din diidxliczi ganin, bal chu guiëb loj guiaꞌ guin: “Bisüd guie biajb loj nijsdoo”, bal id yuꞌ nawëëg luxdooman, bal rliladxaman, gac ni guneeman. Zian gacan. ");
INSERT INTO zasNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Zeel rnin lojdi, gra ni rniabidi loj Dios, gol bililadx guial ma cwaꞌdi laan, abiꞌ zacaꞌdan. ");
INSERT INTO zasNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Guiáad chi ribejdx rniabidi Dios, bal yuꞌ bén rdxeꞌchidi, gol beenman perdon din ziangajc xDadidi bén yuꞌ xanyabaa güünman perdon xtolidi. ");
INSERT INTO zasNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Din bal id züjndi perdon, ziangajc xDadidi Bén yuꞌ xanyabaa ad züjntaman perdon xtolidi. ");
INSERT INTO zasNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Chi badxin reeman Jerusalén. Chi caza Jesús niz lën yadooroꞌ Jerusalén guin, dxel gubig bixhioz rniabee ree bixhioz con ree mextr rajc ley con ree xguxtis ree bén Israel, ");
INSERT INTO zasNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","gunabdiidx reeman loj Jesús, rëb reeman: ―¿Xhie guialrniabee rajpil zeel rüjnl ni guin ree? ¿Chu banee guialrniabee lojl güünl zian? ");
INSERT INTO zasNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Badxiꞌ Jesúsan rëbaman: ―Ziangajc naj yuꞌ ni ganabdiidxan lojdi, bal yadxiꞌdan dxel ganin chu banee guialrniabee günan ni guin ree. ");
INSERT INTO zasNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Chu guxhaal Waj bidgaroobnijsaman bejn ree? ¿Dios ya o bénguidxliuj? Gol badxiꞌn. ");
INSERT INTO zasNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Dxel guzuloj rëb loj lasaꞌ reeman: ―Bal yaguieꞌch ree, Dios guxhaal laaman, zanaman: “¿Chexquiza zeel ad bililadxtidi laaman?” ");
INSERT INTO zasNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ad zajc tëët yaguieꞌch ree, bénguidxliuj guxhaal laaman. Rëb reeman zian guial rdxeb reeman bejn ree, din graczi reeman rliladx guial gojc Waj tijb bén badëë xtiidx Dios loj ree bejn, bén wali gunee xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Abiꞌ badxiꞌ reeman laan rëb reeman: ―Ad rayagbeetan. Zeel rëb Jesús loj reeman: ―Niꞌqui naj ad zanitan lojdi chu banee guialrniabee günan ni guin ree. ");
INSERT INTO zasNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Dxel guzuloj caneenë Jesús laa reeman con ganax ree cwent, rëbaman: ―Tijb bejn guxübinman uv loj xguiniaaman, dxel beenman gurajl gadëd roꞌn, beenchaaw tëëman tijb luar lod grii xnijs uv guin, abiꞌ beenman tijb yu ya daꞌt lod guiyaꞌp guiniaa guin. ’Zianz badëëman laan garol loj ree bén güün laan dxiin, briitaman zëman zijt. ");
INSERT INTO zasNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Chi bidxin dxej yalaꞌ reeman uv guin, guxhaal tijb xmojsaman din chigxiiman ni rayalaman. ");
INSERT INTO zasNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Per ree bén rüjn dxiin loj guiniaa guin gunaaz reeman laaman, gudijn reeman laaman abiꞌ badxiꞌ reeman laaman zezi. ");
INSERT INTO zasNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Dxel guxhaal bén na̱j xguidxliuj laan zatijb xmojsaman, per ziangajc, bacaaguiaj reeman laaman, gulaꞌ reeman guijcaman abiꞌ guneeguijdx reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Guxhaalaman ben ren, per bagüjt reeman laaman. Zien ree ben guxhaalaman, yuꞌ reeman gudijn reeman yuꞌ tëë reeman bagüjt reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Dxel bén na̱j xguidxliuj laan stijbzi xiꞌngaanman ryaadx guixhiaalaman, xin rën daꞌtaman. Dxel guxhaalaman laax guial gunaladxaman: “Zajp reeman da xiꞌnan respejt.” ");
INSERT INTO zasNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Per ree bén guin, rëb loj lasaꞌ reeman: “Xin guin na̱j xin yayaꞌnnë guidxliuj guin, yagüjt reex din gacan du xieen ree.” ");
INSERT INTO zasNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Dxel gunaaz reeman laax, bagüjt reeman laax abiꞌ babëë reeman laax loj guidxliuj guin. ");
INSERT INTO zasNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Dxel gunabdiidx Jesús loj ree bén caneenëman, rëbaman: ―Yan, ¿xhie naladxidi güün bén na̱j xguidxliuj laan? Ziꞌtaman din gugüjtaman bén guin ree, dxel gudëëman guidxliuj guin loj ree ben ren. ");
INSERT INTO zasNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Nid wayoolidi loj xtiidx Dios ya?, lod rëb: Guiaj ni gulëëgoꞌn ree bén rüjn yu, laan goc ni mazri been sirv gojcnë yu guin. ");
INSERT INTO zasNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Zian been dux Dad ree Dios, zeel radxaduloj ree. ");
INSERT INTO zasNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Chi biguiejn ree bén rniabee guin ni gunee Jesús, guyën reeman niniaaz reeman laaman guial gogbee reeman laa reeman cuzaꞌtaman, per guial rdxeb reeman bejn ree, basaꞌn reeman laaman, ziat reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Guxhaal reeman tioꞌp choon ree bénfarisew në tioꞌp choon ree xbejn Herodes lod zaꞌ Jesús, din yaguiil reeman mod guiniee Jesús diidx ni gudxiib reeman guijc din gac cweꞌc reeman xguialquiaman. ");
INSERT INTO zasNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Abiꞌ rëb reeman: ―Mextr, dunujn rayagbee guial lüj rniee diidxli ad ridxgaꞌ tëëtil chu na̱j bejn. Din par lüj tiblojzi na̱j bejn, abiꞌ walil rulüül guial xhienaag rën Dios guiban bejn. Zeel ranabdiidxan lojl: ¿Zagdxen ya radijxan impuest loj César o ad zagdxetan? ¿Zadijxanan ya o ad zadijxtanan? ");
INSERT INTO zasNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Per gogbee gajc Jesús guial wed rüjnz reeman, zeel rëbaman: ―¿Chexc zeel rüjndi naj prueb? Gol tanë cintabl din guguianan. ");
INSERT INTO zasNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Dxel badëëd reeman cintabl guin lojman, abiꞌ rëbaman: ―¿Chu loj ca lojn, chu tëë laj ca lojn? Badxiꞌ reeman laan rëb reeman: ―Loj César ca lojn në lajman. ");
INSERT INTO zasNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Dxel rëb Jesús loj reeman: ―Gol badëëcliza loj César ni na̱j xieen César, guiáad loj Dios gol badëëd ni na̱j xieen Dios. Dád badxa loj reeman ni rëbaman. ");
INSERT INTO zasNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tioꞌp choon ree bénsaducew bignaj Jesús, laa reeman ad rliladxt guial yaban ree bengüt. Zeel gunabdiidx reeman loj Jesús rëb reeman: ");
INSERT INTO zasNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Mextr, loj xley Moisejs rëb guial bal guiët tijb xinguiaaw abiꞌ achut xiꞌnx guyu con lacheelix, bijch xin güt guin guxhliaanë béngunaa bizëjb guin din chuꞌ xiꞌn reex ziꞌc gulüü xiꞌn xingüt guinan. ");
INSERT INTO zasNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Guyu tijb famil lod goc reex gajdx bijch. Baxhliaa xin yaloj guin, per güjtix abiꞌ ad guyut xiꞌn reex con lacheelix. ");
INSERT INTO zasNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Dxel bijch barojpix baxhliaanë béngunaa guin, per güjt gajquix, ad guyu gajct xiꞌn reex. Abiꞌ ziangajc guzajc xin bayon guin, ");
INSERT INTO zasNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","abiꞌ zianz baxhliaanëman guigajdx reex, zianz bara reex güjt achut xiꞌn reex guyu con laaman. Ni bigra tëë në béngunaa guin güjt. ");
INSERT INTO zasNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Yan, chi yaban ree bengüt, loj guigajdx reex, ¿chu loj gra reex gac xbéngunaa laaman guial gra reex baxhliaanë laaman? ");
INSERT INTO zasNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Badxiꞌ Jesúsan rëbaman: ―Ad laat na̱j xgab rüjndi guial ad nünbeetidi xtiidx Dios ad ragbee tëëtidi xhienaag na̱j xguialrniabeeman. ");
INSERT INTO zasNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Din chi yaban ree bengüt, ad zuxhliaatri reeman, ad zudëë tëëtri xiꞌn reeman guxhliaa, ma gac reeman ziꞌc ree anjl yuꞌ xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Abiꞌ xcwent ni yaban ree bengüt, ¿nid wayoolidi loj xlibr Moisejs ya, lod rëb guial baguiaaman yag ni cayëꞌc? Yagaj biguien chaꞌ Dios, rëbaman lojman: “Naj na̱j xDios Abraham, xDios Isaac në xDios Jacob.” ");
INSERT INTO zasNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Din Dios ad najtaman xDios ree bengüt, najman xDios ree bén naban. Zeel ad laat na̱j xgab rüjndi. ");
INSERT INTO zasNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Chi biguiejn tijb mextr rajc ley badxiꞌ Jesús xtiidx reeman zagdxe guial bacaagdiajgaman diidx ni cayü reeman, gubigaman lojman, abiꞌ gunabdiidxaman rëbaman: ―¿Con mandamientan mazri zojbloj loj gra ree mandamient? ");
INSERT INTO zasNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Badxiꞌman laan rëbaman: ―Mandamient mazri zojbloj rëban: “Gol bacaagdiajg, bén Israel, dux Dad ree Dios, tijbzi laaman na̱j Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Guyën xDadil Dios guidiblagaa guidib guijc guidib ladxil.” Laan na̱j mandamient mazri zojbloj. ");
INSERT INTO zasNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mandamient rarojp, rëban: “Guyën ree ben ren ziꞌc rën lüj gajc.” Achet mandamient mazri zojbloj guial loj grop ree mandamient guie. ");
INSERT INTO zasNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Dxel rëb mextr guin loj Jesús: ―Zagdxequi guneel, Mextr. Waliquil tijbzi Dios yuꞌ, achutri ben ren yuꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Abiꞌ guidib guijc guidib ladx bejn guiënman laaman guidiblagaa, guiën tëëman ben ren ree ziꞌc rën laagajcaman. Laan na̱j ni mazri zojbloj guial loj gra gon ni rudëëd bejn loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Chi biguien Jesús badxiꞌ mextr guinan zagdxe, rëbaman: ―Ad zijtt zaꞌl par chuꞌl loj xguialrniabee Dios. Dxel achutri bayax xhie niniabdiidx lojman. ");
INSERT INTO zasNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Chi culüü Jesús bejn ree lën yadooroꞌ Jerusalén, gunabdiidxaman loj reeman rëbaman: ―¿Chexc zeel rëb ree mextr rajc ley guial za Cristo loj xdiaa rey Davi? ");
INSERT INTO zasNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Awa Davi guin gajc gunee por xSprijt Dios, rëbaman: Dios rëb loj da Dadan: “Gurej da ladbeen, xt gabecan xin rdxeꞌch ree lüj guiaꞌl.” ");
INSERT INTO zasNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Yan bal xiꞌn Davi na̱j Cristo, ¿chexquiza zeel rëb Davi guin lojman Dad? Graczi ree bén rigaꞌ lën yadoo guin dád nix yuꞌ luxdoo reeman rucaagdiajg reeman xtiidxaman. ");
INSERT INTO zasNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Chi culüü Jesús bejn ree, rëbaman loj reeman: ―Gol gojp cudad con ree mextr rajc ley, din ruladx reeman sa reeman gacw reeman lajd zagdxe, ruladx tëë reeman gugajpdioz ree bejn laa reeman con respejt niz lunejz. ");
INSERT INTO zasNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Abiꞌ lën ree yadoo ruladx reeman cwe reeman lod rbej ree bén zojbloj, ziangajc rüjn reeman lod ritaw reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Racaꞌ tëë reeman lidx ree béngunaa bizëjb, abiꞌ din guiëb ree bejn guial benzaꞌc na̱j reeman, dád xchej rbejdx rniab reeman Dios. Per laa reeman mazri casti naroob yayal reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tijb dxej zojb Jesús lën yadooroꞌ Jerusalén niz lod zaꞌ alcancia ni ru gon, abiꞌ ruguiaaman rguꞌ ree bejn milia lën alcancia guin, në zien ree benrijcw rguꞌ zroꞌ milia. ");
INSERT INTO zasNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Dxel bidxin tijb béngunaa bizëjb prob, badxeꞌman tioꞌp zintabldoo ni lasajc taꞌnzi. ");
INSERT INTO zasNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Abiꞌ gurejdx Jesús bén na̱j ree xbejnman, rëbaman: ―Diidxli rnin lojdi guial bén bizëjb prob guin mazri lasajc gon badxeꞌman guial loj gon badxeꞌ gra ree bén guin. ");
INSERT INTO zasNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Din graczi reeman rudxeꞌ ni rüjn laa reeman sobr, per laaman majsi najman bénprob, badxeꞌman graczi ni rajpaman par guibannëman. ");
INSERT INTO zasNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Chi barii Jesús lën yadooroꞌ Jerusalén, rëb tijb ree xbejnman lojman: ―Mextr, ¡baguiaa xi nix na̱j ree guiaj guin nix tëë na̱j ree yu guin! ");
INSERT INTO zasNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Badxiꞌ Jesúsan rëbaman: ―Ziꞌc ruguiaal yu naroob guin ree, zadxin dxej, niꞌczi tijb guiaj guin ad zayaꞌnt guijc stijban, gran yazeꞌn. ");
INSERT INTO zasNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Chi zojb Jesús ruguiaꞌ la Olivos, ni na̱j niz lod nudxiꞌ loj yadooroꞌ Jerusalén. Dxel gubig Bëd lojman con Jacob, Waj con Andrejs, laaz reeman zaꞌnë laaman yagaj, abiꞌ gunabdiidx reeman lojman, rëb reeman: ");
INSERT INTO zasNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Guna, ¿goc gac zian? ¿Xhie sen gac chi ma zidyob gac zian? ");
INSERT INTO zasNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Badxiꞌ Jesús laan rëbaman: ―Gol gojp cudad chitëë chu gusquiee lëjt. ");
INSERT INTO zasNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Din zien ree bén guiꞌt guiëb reeman guial por naj zëëd reeman, guiëb tëë reeman: “Naj na̱j Cristo”, abiꞌ gusquiee reeman zien bejn. ");
INSERT INTO zasNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Per lëjt chi guiguiejndi cayajc wadijl o zëëb diidx gac wadijl, ad guidxebidi; din najczi gac zian, per ad por laatan ma bidxin dxej nit guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Din til nacion con stijb nacion, til tëë bén rajp guialrniabee con stijb bén rajp guialrniabee, guiꞌt tëë ree xudoxh në gubijn niz ni niz guie. Zian gac chi ma suloj ree guialzi ni na̱j gac. ");
INSERT INTO zasNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Gol gojp cudad, din zadxin dxej yayü ree bejn lëjt loj ree guxtis, abiꞌ quin reeman lëjt lën ree yadoo. Chinë reeman lëjt loj ree gobernador në loj ree rey guial najdi da bejnan, zian gac din chileꞌ güdi da diidxan loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Per yalojxgaj rüjn naguiejn guireꞌch xtiidxzaꞌc Dios loj gra ree nacion, dxelri nit guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Chi chinë reeman lëjt loj ree guxtis, ad bal chuꞌdi xgab, ad bal güün tëëdi xgab xhie guiëbidi loj reeman. Gol gunee diidx gunee Dios lëjt loj hor guin. Din ad lëjttan guiniee, xSprijt Diosan guiniee. ");
INSERT INTO zasNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Abiꞌ guidxin dxej yayü bejn laagajc bijchaman din guiëtix, ziangajc ree bén na̱j dad yayü laagajc xiꞌn reeman, abiꞌ ree bejn yayü xdad xniaa reeman par guiët reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Gra bénguidxliuj guidxeꞌch lëjt guial najdi da bejnan, per bén sudxiꞌch loj ni rliladxaman naj xt dxej chigra guibanman, laaman yayal xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Chi guguiaadi zojb tijb ni dxuudx lën yadooroꞌ Jerusalén, ziꞌc bacaa Daniel, bén badëë xtiidx Dios loj ree bejn diizd gulal (bén gool ree guiꞌch guie, gol bigniaꞌn), guial bén zojb ree niz Judea chigxüün reeman niz dajn. ");
INSERT INTO zasNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Guiáad bén yëꞌp guijc yu lidx dxejzii, ad yayu lënü lidxaman tiaꞌ xhie xieenman. ");
INSERT INTO zasNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Guiáad bén zaꞌ dajn, ad yayejc lidxaman chigxii xabaman. ");
INSERT INTO zasNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Probza ree béngunaa nüü xiꞌn o bén caꞌ ree xindobëz lën ree dxej zii! ");
INSERT INTO zasNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Gol gurejdx gunab Dios chitëë yayal gac zian tiamp nayaag, ");
INSERT INTO zasNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","din dád guialziroꞌ chuꞌ dxejzii ree, ziꞌc ad wayajctczi diizd chi beenchaaw Dios guidxliuj, ad yuꞌ tëëtri dxej gac zian. ");
INSERT INTO zasNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Bal id zasdop Dios dxej zii ree, niꞌczi tijb bejn ad zalaat, per gusdopaman laa reen, por ree bén rënman, bén gulejman par laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Bal chu na lojdi: “Gol baguiaa, laa Cristo zaꞌ guie”, o “laaman zaꞌ ni”, ad bal chililadxidi. ");
INSERT INTO zasNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Din guiꞌt zien ree bejn, na reeman guial laa reeman na̱j Cristo o na reeman laa reeman na̱j bén rudëë xtiidx Dios loj ree bejn, abiꞌ güün reeman milagr ree në ree graloj ni yadxaloj ree bejn, din gusquiee reeman laa reeman, abiꞌ bal zileꞌn xt zajc në ree bén gulej Dios gusquiee reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Zeel gol gojp cudad, ma bagojnxgajn lëjt gra ni gac. ");
INSERT INTO zasNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Per lën ree dxej ni ma gudëd gra ree guialzi guin, zacajy loj gubijdx abiꞌ ad zusnitri bëëw, ");
INSERT INTO zasNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","zayajb ree bajl yuꞌ xanyabaa guiáad gra ree ni yuꞌ xanyabaa guiniib reen. ");
INSERT INTO zasNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Dxel guguiaa ree bejn Bén guxhaal Dios rdiinman bachaꞌ zëëdaman loj za̱j con xguialrniabee naroobaman. ");
INSERT INTO zasNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Abiꞌ guixhiaal ree xianjlaman guidiblagaa guidxliuj din guchajg reeman lasaꞌ ree bén ma na̱j par Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Gol badxeꞌguijc ni ganin lëjt: Chi ma naquieꞌn xidx yag higo abiꞌ ma caydxib ree xbalagan, lëjt ragbee guial ma zidyob tiamp nalaa. ");
INSERT INTO zasNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ziangajc chi guguiaadi ma cayajc ree ni guin, gol gogbee guial ma zidyob dxej gac ziꞌc ma rnin. ");
INSERT INTO zasNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Diidxli rnin lëjt guial gra ree ni guin gac chi gad ree bén naban lën ree dxej guie guiët. ");
INSERT INTO zasNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Guidxliuj në xanyabaa zanijt reen, per da diidxan ad zadëdt gacan cumplid. ");
INSERT INTO zasNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Per achut ragbee xhie dxejn xhie tëë horan gac ree ni guin, niꞌqui ree anjl yuꞌ xanyabaa, niꞌqui Xiꞌn Dios ad ragbeet, tijbzi dux Dad ree Dios ragbee. ");
INSERT INTO zasNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Zeel gol gojp cudad, gol guzujsin tëë, gol gurejdx gunab Dios din ad ragbeetidi goc gac zian. ");
INSERT INTO zasNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ni guin ree na̱j ziꞌc chi ririi tijb bejn rejman zijt. Abiꞌ chi gadaman grii rudëëman dxiin loj tijbgaj ree xmojsaman, rniabee tëëman susin bén rajp roꞌ port. ");
INSERT INTO zasNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yan ziangajc lëjt gol guzujsin, din ad ragbeetidi goc o xhie horan guialan bal chi ma ribej guiaal ya, o garol guiaal, o chi ma rbidxaꞌ gui̱d, o rsildoo. ");
INSERT INTO zasNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Zeel gol guzusin din bal dxejczi guialan ad guidxaaglojn lëjt ad cayüjntidi ziꞌc rayal. ");
INSERT INTO zasNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Abiꞌ ni canin lojdi, loj gradi caninan: Gol guzujsin. ");
INSERT INTO zasNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Zatioꞌp dxej riaadx gal lanij pascw, lanij raw ree bejn guiadxtil ni ad yuꞌt levadur. Abiꞌ ree bixhioz rniabee ree bixhioz con ree mext rajc ley, raguiil reeman mod xhienaag gusquiee reeman Jesús, din guiniaaz reeman laaman gugüjt reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Per rëb reeman: ―Ad zaguieent ree zian loj ree dxej lanij guin, chitëë gac naquieꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Dxel chi zaꞌ Jesús luguiedx Betania lidx Simón, bén gunee reeman leproso, abiꞌ chi zojbaman xan mex cayawaman, bidxin tijb béngunaa caꞌman lumejt yuꞌn perfum ni lasajc wayëjx guial gojcchaawnën ganax nardo, zianz guxhalaman roꞌ lumejt guin persi baroobaman perfum guin guijc Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Abiꞌ yuꞌ ree bén zaꞌ yagaj bidxeꞌch, rëb loj lasaꞌ reeman: ―¿Chexc zeel guxhieꞌman perfum guin? ");
INSERT INTO zasNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Awa zajc nidoꞌn choon gayuu denario din nüjnan yudar bénprob ree. Abiꞌ caneeguijdx reeman béngunaa guin. ");
INSERT INTO zasNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Per rëb Jesús loj reeman: ―Gol basaꞌnman. ¿Chexc zeel ruslendi laaman? Zagdxe na̱j ni beenman con naj. ");
INSERT INTO zasNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Zianczi sunëdi bénprob ree, abiꞌ zajc güündi laa reeman yudar chi guiëndi, saꞌn naj ad ziantczi sunëdi naj. ");
INSERT INTO zasNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Béngunaa guie beenman ni golguzujman, ma beenchaawxgajman da cuerpan par chi guidxin dxej guiguieꞌchan. ");
INSERT INTO zasNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Diidxliczi rnin lëjt, guial guidib loj guidxliuj bantëëz guin guiniee reeman xtiidxzaꞌc Dios, zü ree bejn diidx ni been béngunaa guin con naj din gusaaladx reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote, tijb ree xbejn Jesús, wejman bigneenëman bixhioz rniabee ree bixhioz din yayüman Jesús loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Chi biguiejn ree bixhioz guin zian, dád babaa reeman. Abiꞌ rëb reeman gudëëd reeman milia lojman. Dxel guzuloj raguiilaman mod xhienaag yayüman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Dxej ni guzuloj lanij raw ree bén Israel guiadxtil ni ad yuꞌt levadur, chi rugüjt reeman tijb xiildoo par lanij pascw, gunabdiidx ree xbejn Jesús lojman, rëb reeman: ―¿Ban guin rënl yuguieenan ni yadaaw ree guxhin pascw? ");
INSERT INTO zasNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dxel guxhaal Jesús tioꞌp ree xbejnman, rëbaman: ―Gol chej Jerusalén. Ni guguiaadi tijb xinguiaaw caꞌ re yuꞌ nijs. Gol chinalix. ");
INSERT INTO zasNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Abiꞌ lod yayux, gol güjdx loj bén na̱j lidxan: “Na mextr: ¿Ban lënü gawnë ree xbejnman yan guxhin pascw?” ");
INSERT INTO zasNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Dxel gulüüman lëjt tijb lënü naroob ni rarojp cwaa, ma najcchaaw lënü guin. Yagaj gol been ni yadaaw ree xche. ");
INSERT INTO zasNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Dxel brii ree xbejnman wej reeman luguiedx guin, abiꞌ bidxaagloj gajc reeman ziꞌcgajczi rëbaman, zianz been reeman ni gaw reeman guxhin pascw. ");
INSERT INTO zasNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Chi gure guiaal, bidxin Jesús con guidxiptioꞌp ree xbejnman. ");
INSERT INTO zasNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Dxel chi zojb reeman xan mex cayaw reeman, rëb Jesús loj reeman: ―Diidxliczi rnin lojdi guial tijb lëjt, bén cayawnë naj, laaman yayü naj. ");
INSERT INTO zasNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Dád guyunaya reeman, abiꞌ guzuloj canabdiidx tijb gaj reeman, rëb reeman lojman: ―¿Najn ya? Abiꞌ rëb stijbaman: ―¿Wa najn ya? ");
INSERT INTO zasNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Badxiꞌman laan rëbaman: ―Loj guidxiptioꞌpidi, tijb lëjtan, bén cugajdx xguiadxtil loj gajc pliajt lod cugajdx da guiadxtilan, laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Walican guial Bén guxhaal Dios na̱j sacaman ziꞌc ca loj xtiidx Dios. Per, ¡prob bén yayü laaman! Zagdxeli na̱j par laaman ad niutaman loj guidxliuj ");
INSERT INTO zasNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Laꞌtgaj cayaw reeman, cwaꞌ Jesús guiadxtil abiꞌ badëëman quixtëë loj Dios, dxel gulaꞌman laan badëëman loj reeman, rëbaman: ―Gol gudaw guiadxtil guie, laan na̱j da cuerpan. ");
INSERT INTO zasNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Dxel cwaꞌman tijb cojp yuꞌ vin, chi gulox badëëman quixtëë loj Dios, badëëman cojp guin loj reeman, abiꞌ gra reeman guꞌ vin yuꞌ lojn. ");
INSERT INTO zasNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Zianz rëbaman loj reeman: ―Vin guie na̱j da rejnan ni gaxhieꞌn chi guiëtan por zien ree bénguidxliuj, din guixal tijb nejz cüb xhienaag gap ree bejn perdon loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Naj rni lëjt, ad yuꞌtri dxej guiëꞌn vin rajcchaawnë uv, xt dxej ni guiëꞌn vin cüb lod rniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Chi gulox biil reeman tijb cant par Dios. Dxel zë reeman ruguiaꞌ Olivos. ");
INSERT INTO zasNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Dxel rëb Jesús loj reeman: ―Graczidi tioꞌnladx naj yan guxhin, ziꞌc ca loj xtiidx Dios lod rëb: “Gugüjtan bén rajp ree xiil, abiꞌ guireꞌch reeb.” ");
INSERT INTO zasNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Per chi yabanan, yaloj naj ganeed lojdi gan Galilea. ");
INSERT INTO zasNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Dxel rëb Bëd lojman: ―Majsi gra reeman tioꞌnladx lüj, per naj ad zaroꞌnladxtan lüj. ");
INSERT INTO zasNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Badxiꞌ Jesúsan rëbaman: ―Naj rni lüj Bëd, yan guxhin gajc chi gad gui̱d cwidxaꞌ tioꞌp volt, choon volt mal rëbil guial ad nünbeetil naj. ");
INSERT INTO zasNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Per naguiejn rüjn Bëd rëbaman: ―Majsi guiëtnëꞌn lüj, per ad zëtan guial ad nünbeetan lüj. Abiꞌ graczi reeman rëb zian. ");
INSERT INTO zasNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Chi bidxin reeman tijb luar la Getsemaní, dxel rëb Jesús loj ree xbejnman: ―Gol gurejsii guie, laꞌtgaj gabedx ganaaban Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Abiꞌ binëman Bëd, Jacob con Waj, dxel guzuloj guyunayaman abiꞌ ad nixtri yuꞌ luxdooman. ");
INSERT INTO zasNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Zianz rëbaman loj reeman: ―Yuꞌ naya daꞌt luxdon, rulüü ma gugüjtan naj. Gol bayaꞌn guie ad gaayëjsidi. ");
INSERT INTO zasNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Abiꞌ guzaman zataꞌn, zianz gurerulojman, gunabaman loj Dios, bal zileꞌ tëd ni na̱j sagdiajman. ");
INSERT INTO zasNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Chi cabejdx canabaman Dios, rëbaman: ―Dad, graczi zajc güünl. Babëë naj loj ni gazaagdiajn. Per ad gac ziꞌc rënan, rayal gac ziꞌc rënl. ");
INSERT INTO zasNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Dxel ziaman lod bayaꞌn ree xbejnman, chi badxinman cwëꞌ reeman laa reeman nagaꞌyëjs, zianz rëbaman loj Bëd: ―Simón, ¿nagaꞌyëjsil ya? ¿Niꞌqui tib hor ad gojct nibejnaal ya? ");
INSERT INTO zasNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Gol gurenaa, gol gurejdx gunab Dios chitëë güün xindxab lëjt gan. Din rëndi güündi ziꞌc rayal, per xcuerpidi ad rtiëjbtan. ");
INSERT INTO zasNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Dxel zëman zatijb persi gurejdx gunabaman Dios con diidx guin gajc ree. ");
INSERT INTO zasNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Chi badxinman lod rigaꞌ reeman, laagajc reeman nagaꞌyëjs zatijb, guial yuꞌ daꞌt bacaal loj reeman, abiꞌ niꞌquid radxejlt xhie guiëb reeman lojman. ");
INSERT INTO zasNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ni bayon volt badxinman, rëbaman: ―¿Sta nagaꞌyëjsidi ya? ¿Sta cayziiladxidi ya? Gol batieꞌch xbacaalidi din naj, najn Bén guxhaal Dios ma bidxin hor yayü reeman naj loj ree béndol. ");
INSERT INTO zasNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Gol bixche, yoꞌ ree, laa bén yayü naj ma zëëd gajxh. ");
INSERT INTO zasNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sta caneenë Jesús laa reeman chi bidxin Judas, bén goc tijb ree xbejnman. Bidxinnëman zien ree bejn caꞌ reeman espad con yag, guxhaal ree bixhioz rniabee ree bixhioz laa reeman con ree mextr rajc ley con ree guxtis Israel. ");
INSERT INTO zasNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Abiꞌ Judas bén bayü laaman ma bagojnxgajman bén guin ree rëbaman: ―Bén gawan xid, laaman na̱j bén raguiilidi, gol gunaazaman gol chinëman, gol gojpaman ad guslaadi laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Chi bidxin Judas dxel gubigaman loj Jesús, rëbaman: ―Mextr, Mextr. Dxel gudawaman laaman xid. ");
INSERT INTO zasNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Zianz gunaaz ree bén guin laaman din chinë reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Per tijb bén zaꞌ yagaj gulëë xiespadaman, gutüꞌman guidiajg xmojs bixhioz rniabee gra ree bixhioz. ");
INSERT INTO zasNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Dxel rëb Jesús loj ree bén guin: ―¿Chexc zeel zëëdidi con espad con yag din chinëdi naj ziꞌc tijb xingubaan? ");
INSERT INTO zasNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Zianczi guzunëꞌn lëjt lën yadooroꞌ Jerusalén rulün lëjt xtiidx Dios, abiꞌ ad gunaaztidi naj. Per gra ree ni guie cayajc din gac cumplid ni ca loj xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Dxel graczi ree xbejn Jesús baxüün, guroꞌnladx reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Per guyu tijb xinguiag binalix Jesús, nadüübix tijbzi lajd. Abiꞌ chi gunaaz ree bén guin laax, ");
INSERT INTO zasNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","baslaagajquix lajd guin, zigxüünt ziladix. ");
INSERT INTO zasNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Dxel binë reeman Jesús loj bixhioz rniabee gra ree bixhioz, abiꞌ badxaag lasaꞌ ree bixhioz rniabee ree bixhioz con ree guxtis Israel con ree mextr rajc ley. ");
INSERT INTO zasNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Abiꞌ zijt zijt binal Bëd Jesús xt ruleꞌ lidx bixhioz guin, dxel gurejman rudëj con ree bén rajp rulidx bixhioz guin, ");
INSERT INTO zasNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Abiꞌ ree bixhioz rniabee ree bixhioz con gra ree guxtis, baguiil reeman mod xhienaag gutediaꞌ reeman Jesús din chileꞌ gugüjt reeman laaman, per ad badxejlt xhienaag nutediaꞌ reeman laaman, ");
INSERT INTO zasNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","majsi zien reeman rudxiib diidx rusquiee guijcaman, per garent garen rëb tijb gaj reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Dxel guzuli tioꞌp choon reeman gunee reeman diidx rusquiee ree contr laaman, rëb reeman: ");
INSERT INTO zasNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Dunujn baguiejn rëbix: “Naj guseꞌn yadooroꞌ Jerusalén ni been ree bejn, abiꞌ choon dxejzi yayünanan sin xyudar ree bejn.” ");
INSERT INTO zasNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Per niꞌqui zian ad guneet reeman tibloj, garent garen gunee reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Dxel bixhioz rniabee gra ree bixhioz guzuliman galay ree bén rigaꞌ yagaj, abiꞌ gunabdiidxaman loj Jesús, rëbaman: ―¿Nid xhie diidx yadxiꞌl ya? ¿Wali ni canee reeman contr lüj ya? ");
INSERT INTO zasNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Per achetczi rëb Jesús, ad badxiꞌtaman diidx, dxel gunabdiidx bixhioz rniabee guin lojman zatijb, rëbaman: ―¿Lüj na̱j Cristo ya, Xiꞌn Dios Bén nagleꞌ? ");
INSERT INTO zasNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Badxiꞌ Jesúsan rëbaman: ―Walican, najcan. Abiꞌ lëjt zuguiaadi naj najn Bén guxhaal Dios zooban xladbee Dios Bén caꞌ gra guialrniabee guguiaa tëëdi naj guialan loj za̱j xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Chi biguiejn bixhioz guin zian, gudixyaꞌ xabaman, dxel rëbaman: ―Ad rüjntri naguiejn yadiil ree testiw. ");
INSERT INTO zasNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Lëjt ma biguiejn caneeguijdxix Dios. Yan, ¿xhie nadi? Abiꞌ graczi reeman rëb, guiëtaman. ");
INSERT INTO zasNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Yuꞌ reeman rucojp xhiejn lojman, rutaꞌcw tëë reeman lojman, dxel riguin reeman laaman, rëb reeman: ―¡Guneeyaꞌ chu gudin lüj! Guiáad ree bén rajp yagaj wëëz reeman lojman. ");
INSERT INTO zasNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Chi zaꞌ Bëd ruleꞌ guin, dxel bidxin tijb béngunaa rüjn dxiin lidx bixhioz rniabee guin. ");
INSERT INTO zasNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Chi baguiaaman zojb Bëd rudëj guin cuchaꞌman, baguiaaman lojman, dxel rëbaman: ―Në lüj zaꞌnë Jesús bén Nazaret. ");
INSERT INTO zasNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Per gurexuu Bëd rëbaman: ―Ad nünbeetan laaman, ad ragbeetan xhienin rnieel. Chi bariiman roꞌ port guin, dxel guridxaꞌ gui̱d. ");
INSERT INTO zasNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Dxel baguiaa béngunaa guin Bëd zatijb, zianz guzuloj rëbaman loj ree bén rigaꞌ yagaj: ―Në bén guin na̱j xbejn Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Per gurexuu Bëd zatijb. Gojc xchejdoo rëb ree bén rigaꞌ yagaj loj Bëd: ―Walican në lüj na̱j xbejnx din xin Galilea lüj, abiꞌ ziꞌcgajc rniee reeman rnieel. ");
INSERT INTO zasNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Per guzudxiꞌch Bëd con ni rëbaman, zianz rëbaman: ―Gudëëd Dios naj casti bal rusquieen, ad nünbeetan bén nadi. ");
INSERT INTO zasNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Loj hor zii gajc barojp volt guridxaꞌ gui̱d. Dxel basaaladx Bëd guial rëb Jesús lojman: “Chi gad gui̱d cwidxaꞌ tioꞌp volt, mal gojc choon volt rëbil ad nünbeetil naj.” Chi basaaladxaman zian, dxel guzuloj cayoonman. ");
INSERT INTO zasNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Chi bareguiaal rsildoo, badxajg lasaꞌ ree bixhioz rniabee ree bixhioz con ree guxtis Israel në ree mextr rajc ley con gra ree guxtis, abiꞌ bayaꞌn reeman diidx xhienaag güün reeman. Dxel guxhii reeman Jesús binë reeman laaman loj Pilato. ");
INSERT INTO zasNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Abiꞌ gunabdiidx Pilato loj Jesús rëbaman: ―¿Lüjn na̱j xrey ree bén Israel ya? Badxiꞌ Jesús laan rëbaman: ―Najcan. ");
INSERT INTO zasNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Abiꞌ ree bixhioz rniabee ree bixhioz zien ni rudxiib reeman guijcaman, ");
INSERT INTO zasNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","zeel gunabdiidx Pilato lojman zatijb, rëbaman: ―¿Nid xhie diidx yadxiꞌl ya? Baguiaa dád zien ni rudxiib reeman guijquil. ");
INSERT INTO zasNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Per achetczi badxiꞌ Jesús, zeel dád badxa loj Pilato ");
INSERT INTO zasNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Loj ree dxej lanij pascw, ruslaa Pilato tijb bén yuꞌ ladxguiib, bén rëb ree bén guiedx guin guslaaman. ");
INSERT INTO zasNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Lën ree dxej zii yuꞌ bén la Barrabás ladxguiib con ree ben ren, bén bagüjt ree bejn loj tijb wadijl ni been reeman contr gobiarn. ");
INSERT INTO zasNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Dxel chi bidoꞌp ree bejn, rëb reeman loj Pilato din güünman ziꞌc na̱j costumbr, ");
INSERT INTO zasNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Abiꞌ rëb Pilato loj reeman: ―¿Rëndi ya guslaan xreydi? ");
INSERT INTO zasNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Rëbaman zian guial ragbeeman bayü ree bixhioz guin laaman por guial rdëdlojzi reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Per ree bixhioz rniabee guin badxeꞌ reeman bejn ree diidx din guiëb reeman loj Pilato guslaaman Barrabás. ");
INSERT INTO zasNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Abiꞌ gunabdiidx Pilato loj reeman rëbaman: ―¿Xhie rëndi günnëꞌn bén nadi na̱j xreydi? ");
INSERT INTO zasNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Dxel gurixdiaj reeman rëb reeman: ―¡Bacaax loj crüjz! ");
INSERT INTO zasNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Zianz rëb Pilato loj reeman: ―Per ¿xhieza ni mal beenx? Guiáad laa reeman mazri rbixdiaj reeman, rëb reeman: ―¡Bacaax loj crüjz! ");
INSERT INTO zasNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Abiꞌ guial rën Pilato yayaꞌnman zagdxe loj reeman, zeel baslaaman Barrabás, gunabeeman a Jesús, dxel bayüman laaman loj reeman din tiaman loj crüjz. ");
INSERT INTO zasNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Abiꞌ binë ree xin suldad guin Jesús xluleꞌ palas, yagaj badxaag lasaꞌ gra reex. ");
INSERT INTO zasNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Abiꞌ bascajcw reex laaman tijb lajd murad, dxel been reex tijb coron guiëjch badxeꞌ reex guijcaman. ");
INSERT INTO zasNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Dxel guzuloj rbixdiaj reex rëb reex: ―¡Guibanri xrey ree bén Israel! ");
INSERT INTO zasNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Zianz rugaz reex var guijcaman, rulaa xhiejn reex lojman, abiꞌ ruzuxib reex lojman. ");
INSERT INTO zasNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Chi gulox bazeꞌ reex laaman, babëë reex lajd murad guin ladaman, bascajcw reex xabczaman, dxel zinë reex laaman din gucaa reex laaman loj crüjz. ");
INSERT INTO zasNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Chi zinë reex Jesús, badxaagloj reeman tijb bén Cirene, laman Simón, xdad Lejandr con Rufo, ziaadaman bazaman dajn. Abiꞌ been ree suldad guin naguiejn biaaman xcrüjz Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Abiꞌ binë reex Jesús luar la Gólgota, rën guiëban Calaver. ");
INSERT INTO zasNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Yagaj badëëd reex vin noꞌch ni la mirra lojman din guiëꞌman laan, per ad guꞌtaman laan. ");
INSERT INTO zasNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Chi ma bacaa reex laaman loj crüjz, dxel gudxijt reex suert guijc xabaman din guidoon xhie yayal tijbgaj reex ");
INSERT INTO zasNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Raca gaa rsil bacaa reex laaman loj crüjz. ");
INSERT INTO zasNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Guijc crüjz guin bacaa reex lejtr ni rëb chexc zeel bacaa reex laaman loj crüjz, rëban: “Xrey ree bén Israel.” ");
INSERT INTO zasNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Chi bacaa reex laaman loj crüjz, në zatioꞌp ree xin gubaan bacaa reex loj crüjz, tijbix cwa xladbeeman, zatijbix cwa xladruvejsaman. ");
INSERT INTO zasNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Zian gojc cumplid ni ca loj xtiidx Dios, lod rëb: “Nayabaman loj ree benmal.” ");
INSERT INTO zasNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Abiꞌ ree bén ridëd yagaj ruzeꞌ reeman laaman runij guijc reeman, rëb reeman: ―Conza ni rnieel guial rëbil, yaseꞌnl yadooroꞌ Jerusalén abiꞌ loj choon dxejzi ma bayüjnlan zatijb, ");
INSERT INTO zasNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","yan baslaa lüj gajc baguiajt tëë loj crüjz zii. ");
INSERT INTO zasNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ziangajc ruzeꞌ ree bixhioz rniabee laaman con ree mextr rajc ley, rëb reeman: ―Gognëx ben ren ree, guiáad laax ad rajct ruslaa laagajquix. ");
INSERT INTO zasNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yaguiajtix loj crüjz guin, bal laax na̱j Cristo, xrey ree bén Israel, din yaguiaa ree, dxel yaliduladx ree. Xt në ree xingubaan canëman loj crüjz guneeguijdx laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Chi gol garol dxej, bicajy guidib guidxliuj xt raca choon wadxe. ");
INSERT INTO zasNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Dxel raca choon guin gurixdiaj Jesús rejs, rëbaman: ―Eloi, Eloi, ¿lama sabactani? ―rën guiëban: Diosan, Diosan, ¿chexc zeel gulëëladxil naj? ");
INSERT INTO zasNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Yuꞌ ree bén zaꞌ yagaj biguiejn, abiꞌ rëb reeman: ―Gol bacaagdiajg niad. Laax cabejdx Elías bén badëë xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Dxel ruxüün tijbaman, bicajdxaman tijb xiil loj vinagr, bacaaman laan loj tijb yag, abiꞌ bacaaman laan roꞌ Jesús din guiëꞌman laan, rëbaman: ―Gol basaꞌnx, yaguiaa ree don ziꞌt Elías yalet laax loj crüjz guin ya. ");
INSERT INTO zasNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Per Jesús dád rejs gurixdiajman, dxel güjtaman. ");
INSERT INTO zasNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Loj hor zii goxyaꞌ lajd nal lën yadooroꞌ Jerusalén, gojcan tioꞌp lalaꞌ, diizd guijc guin xt guiaꞌ guin goxyaꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Dxel suldad rniabee ree suldad guial zaꞌx niz loj Jesús. Chi baguiaax xhienaag güjtaman, rëbix: ―Walican, Xiꞌn Dios bén guin. ");
INSERT INTO zasNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Në tioꞌp choon ree béngunaa zaꞌ zijt ruguiaa ni cayajc. Loj ree béngunaa guin noꞌch María Magdalena, në Salomé në Li xniaa Xiëb con Jacob bén na̱j benguiag loj Xiëb. ");
INSERT INTO zasNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Béngunaa guin ree binal Jesús, been tëë reeman laaman yudar chi guzuman Galilea, në zien ree béngunaa ren binal laaman diizd Galilea xt Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Chi bidxin dxej rüjn ree bén Israel gra, chi guixiezi na̱j dxej raziiladx reeman, ma cabej guiaal, ");
INSERT INTO zasNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","bidxin Xiëb bén za guiedx Arimatea. Gojcaman tijb xguxtis ree bén Israel, abiꞌ gojp ree bejn laaman respejt, në laaman rbëz xguialrniabee Dios, abiꞌ guyuman valor wejman loj Pilato, persi banabaman xcuerp Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Dád badxa loj Pilato guial ma güjt Jesús, dxel gurejdxaman xin suldad rniabee ree suldad persi gunabdiidxaman bal walin. ");
INSERT INTO zasNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Abiꞌ rëb suldad guin guial walican ma güjtaman, dxel cwëjb Pilato bacaꞌ Xiëb cuerp guin. ");
INSERT INTO zasNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Guzii Xiëb tijb lajd, abiꞌ chi baletaman xcuerp Jesús loj crüjz guin dxel batüübaman laaman lajd guin, biquieꞌchaman laaman lën tijb baa ni bidëën lën tijb guiaj, dxel basiaawaman roꞌ baa guin con tijb guiajroꞌ. ");
INSERT INTO zasNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena con Li xniaa Xiëb, baguiaa reeman lod baquieꞌch reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Chi gudëd dxej raziiladx ree bejn, María Magdalena, në Salomé, në Li xniaa Jacob, bisii reeman perfum din chitëëb reeman laan xcuerp Jesús. ");
INSERT INTO zasNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bareguiaal chidumingw, rsildoo brii reeman wej reeman roꞌ xbaa Jesús, naabzi rliejn gubijdx. ");
INSERT INTO zasNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Chi zë reeman lunejz, rëb loj lasaꞌ reeman: ―¿Chuza chisüd guiaj nayaaw roꞌ baa guin? ");
INSERT INTO zasNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Per chi bidxin reeman baguiaa reeman ma biniib guiaj zaꞌ roꞌ baa guin ad zaꞌtri loj xluaran. ");
INSERT INTO zasNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Chi guyu reeman lën baa guin, baguiaa reeman tijb xinguiag zojbix ladbee, najcwix lajd naquich yool, abiꞌ bidxeb reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Per rëbix loj reeman: ―Ad rdxebidi, raguiilidi Jesús bén Nazaret bén cwa loj crüjz. Per ma babanman, achutri laaman guie, gol baguiaa lod gudixh reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yan, gol chej gol chiguiedx loj Bëd në loj los demazri ree xbejnman guial yaloj Jesús ned cheman Galilea dxel chedi, ni guguiaadi laaman ziꞌc ma naman lojdi. ");
INSERT INTO zasNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Dxel cari daꞌt barii ree béngunaa guin lën baa guin, dád canij reeman cadxeb reeman, abiꞌ achut loj rëb reeman guial rdxeb reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Chi ma baban Jesús, chidumingw rsildoo, yaloj loj María Magdalena balüülojman, bén babëëman gajdx xindxab luxdoo. ");
INSERT INTO zasNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","María Magdalena guin bicojn ree xbejn Jesús, bén yuꞌnaya ree roon tëë reeman por laaman. ");
INSERT INTO zasNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Chi biguiejn reeman guial naban Jesús baguiaa tëë María Magdalena laaman, ad bililadxt reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Chi gudëd gojc zian, garen balüüloj Jesús loj tioꞌp ree xbejnman lunejz chi zë reeman niz dajn. ");
INSERT INTO zasNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Dxel bén guin ree bicojn lasaꞌ reeman, per niꞌqui laa reeman ad bililadxt reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ni bigratë balüüloj Jesús loj za chiptib ree xbejnman, chi zojb reeman xan mex cayaw reeman, gudilëman laa reeman guial nad reeman, ad rliladxt reeman bén baguiaa ree laaman guial ma babanman. ");
INSERT INTO zasNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Dxel rëbaman loj reeman: ―Gol chej guidib guidxliuj, gol chigtieꞌch xtiidxzaꞌc Dios loj gra ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Bén chililadx tiobnijs tëë zajcaman perdon loj Dios. Per bén ad zaliladxt xtiidxzaꞌc Dios, laaman yayal casti. ");
INSERT INTO zasNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Sen guie ree gap ree bén chililadx naj: Por da guialrniabeen zabëë reeman xindxab luxdoo ree bejn, zanee tëë reeman diidx ren ree, ");
INSERT INTO zasNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","zanaaz reeman bëël ree, abiꞌ majsi guiëꞌ reeman ni yuꞌ venen guijc achet gac reeman, chi gudxiib yaa reeman guijc ree bénragxuu, zayajc reeman. ");
INSERT INTO zasNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Chi gulox guneenë Dad Jesús laa reeman, dxel bayëꞌpaman xanyabaa, gurejman xladbee Dios. ");
INSERT INTO zasNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Guiáad laa reeman brii reeman zigtieꞌch reeman xtiidxzaꞌc Dios guidibczi. Abiꞌ Dad Jesús gognë laa reeman, been reeman milagr ree, persi gogbee ree bejn guial xtiidxqui Dios na̱j ni rniee reeman. Amén.");
INSERT INTO zasNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Zien ree bén ma been naguiejn gucaa ni goc con dunuj ree, ");
INSERT INTO zasNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ziꞌcgajczi balüü ree bejn dunuj ree, bén baguiaa ree diizd guiaꞌxchej ni been Jesús në ni guzacaman, gutieꞌch tëë reeman xtiidxaman. ");
INSERT INTO zasNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Naj baguilxnejzchaaw diizd guiaꞌxchejn, dad Teófilo, zeel naladxan zagdxen gucanan xnejz par lüj, ");
INSERT INTO zasNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","din chigniaꞌl zagdxe diidxli balüü reeman lüj. ");
INSERT INTO zasNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tiamp gunabee rey Herodes guidib niz Judea, guyu tijb bixhioz brii laj Zacarías, bachajgaman tib cwaa ree bixhioz brii laj xbejn Abías. Xbéngunaa Zacarías brii laj Elisabet, zaman loj xdiaa bixhioz brii laj Aarón. ");
INSERT INTO zasNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Grop reeman gubajn xnejz loj Dios bazoob tëë reeman diidx graczi ni rniabee Dios, abiꞌ achut rileꞌ guiëb guial rajp reeman dol. ");
INSERT INTO zasNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Per achut xiꞌn reeman guyu guial ad gojct niu xiꞌn Elisabet, grop reeman ma na̱j bengol. ");
INSERT INTO zasNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tijb dxej ni bayal ree bixhioz noꞌch Zacarías loj, been reeman sirv loj Dios, ");
INSERT INTO zasNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ziꞌc na̱j xcostumbr ree bixhioz guin, gudxijt reeman suert din guidoon chu yayal gudxeꞌ goxyaal lën yadooroꞌ Jerusalén, abiꞌ bayal Zacarías cuꞌman goxyaal guin. ");
INSERT INTO zasNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Laꞌtgaj caguꞌman goxyaal guin, gra ree bejn rigaꞌ luleꞌ cabejdx canab reeman Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Dxel balüüloj tijb xianjl Dios loj Zacarías, zaꞌliman xladbee altar lod cayu goxyaal guin. ");
INSERT INTO zasNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Chi baguiaa Zacarías anjl guin, ad badxejlt xhie nüjnman, dád bidxebaman. ");
INSERT INTO zasNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Per rëb anjl guin: ―Zacarías, ad rdxebil ma bacaagdiajg Dios ni gunabil. Chuꞌ xiꞌn xbéngunaal Elisabet, gaquix xinguiaaw abiꞌ yaguꞌl lajx Waj. ");
INSERT INTO zasNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Yabaa daꞌtil, në zien ree bejn yabaa chi galix, ");
INSERT INTO zasNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","guial gaquix xin lasajc loj Dios. Ad zëꞌtix vin niꞌqui ni gusüdx laax. Abiꞌ diizd chi gadix gal mal zaꞌnë xSprijt Dios laax. ");
INSERT INTO zasNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Por laax zien ree bén Israel yayejc loj xDad reeman Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Laax ned lojman, chuꞌ xSprijt Dios luxdoox gap tëëx guialrniabee ziꞌc Elías, bén badëë xtiidx Dios loj ree bejn, yabeꞌcdxex bén na̱j ree dad con xiꞌn reeman, gulüü tëëx bén ad ruzoobt ree diidx din guzuxnejzix bejn ree guidxgaꞌ reeman laaman chi guiꞌtaman. ");
INSERT INTO zasNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Dxel rëb Zacarías loj anjl guin: ―¿Xhienaag gagbeen guial gac cumplid ni nal? Din naj con da béngunaan ma nayajcan bengol. ");
INSERT INTO zasNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Badxiꞌ anjl guinan rëbaman: ―Naj na̱j Gabriel, rünan sirv loj Dios, laaman guxhaal naj zidnëꞌn diidxzaꞌc guie lojl. ");
INSERT INTO zasNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Per yan guial ad bililadxtil da diidxan, yayaꞌnl gop ad zajct guinieel xt guidxin dxej gal xindo guin. ");
INSERT INTO zasNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Guiáad ree ben rigaꞌ luleꞌ guin cabëz reeman Zacarías yuꞌ nawëëg reeman guial cayaglaaman lën yadoo guin. ");
INSERT INTO zasNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Chi bariiman ad rajctri rnieeman, gaz sen rüjnman guial ma bayaꞌnman gop. Dxel gogbee reeman guial yuꞌ xhie baguiaaman lën yadoo guin. ");
INSERT INTO zasNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zianz bazaꞌ ree dxej ni been Zacarías sirv lën yadoo guin, dxel zia lidxaman. ");
INSERT INTO zasNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chi gudëd ree dxej guin, guyu xiꞌn xbéngunaaman Elisabet. Gaay bëëw tib guyuzaman lënü, rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ze na̱j ni beennë Dios naj lën ree dxej guie chitëë guzeꞌri ree bejn naj.” ");
INSERT INTO zasNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ni goc xhoꞌp bëëw, guxhaal Dios anjl la Gabriel luguiedx Nazaret ni rigaꞌ niz Galilea, ");
INSERT INTO zasNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","din chignajman tijb biinxdüb lam Li. Ma na̱j tiaꞌ tijb xin la Xiëb laam, xin zëëd loj xdiaa rey Davi. ");
INSERT INTO zasNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Guyu anjl guin lod yuꞌ Li abiꞌ rëbaman: ―¡Xchan Li, Dios ma gulej lüj! Dios zaꞌnë lüj, ma beenleꞌ tëëman lüj loj gra ree béngunaa. ");
INSERT INTO zasNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Chi baguiaa Li anjl guin dád badxa lojm guial rëbaman zian, abiꞌ gunabdiidxim xhie rën guiëb ree diidx guin. ");
INSERT INTO zasNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Dxel rëb anjl guin: ―Li, ad rdxebil din lüj gule Dios beenleꞌ tëëman lüj. ");
INSERT INTO zasNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Chuꞌ xiꞌnl, abiꞌ chi galaman yaguꞌl lajman JESÚS. ");
INSERT INTO zasNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Laaman gac bén zojbloj, guiniee ree bejn laaman Xiꞌn Dios bén yuꞌ xanyabaa. Güün dux Dad ree Dios laaman rey ziꞌc goc xdiaagulalaman Davi, ");
INSERT INTO zasNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","din nabeeman bén Israel ree xt goctëëz, abiꞌ xguialrniabeeman ad yuꞌt dxej loxan. ");
INSERT INTO zasNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Dxel rëb Li loj anjl guin: ―¿Xhienaag chuꞌ da xiꞌnan awa achut bénguiaaw nabannëꞌn? ");
INSERT INTO zasNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Badxiꞌ anjl guinan rëbaman: ―Por xSprijt Dios chuꞌ xiꞌnl, abiꞌ xguialrniabee Dios bén yuꞌ xanyabaa gusiaawan guijquil con xbalan. Zeel xiꞌnl bén gal, gacaman naya nali abiꞌ guiniee ree bejn laaman Xiꞌn Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ziangajc lasaꞌl Elisabet ma yuꞌ xiꞌnman, majsi ma najman bengol, bén rëb ree bejn ad zajct chuꞌ xiꞌn, per yan ma gojc xhoꞌp bëëw yuꞌ xiꞌnman. ");
INSERT INTO zasNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Din Dios graczi zajc güünman. ");
INSERT INTO zasNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Dxel rëb Li loj anjl guin: ―Dios na̱j bén rniabee naj, gacza ziꞌc rënman. Ziat anjl guin. ");
INSERT INTO zasNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Lën ree dxej guin wej Li cari daꞌt tijb guiedx ni rigaꞌ la̱d ree guiaꞌ niz Judea, ");
INSERT INTO zasNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","dxel guyum lënü lidx Zacarías, bagajpdiozim Elisabet. ");
INSERT INTO zasNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Chi biguiejn Elisabet chaꞌm cugajpdiozim laaman, laa baniib gajc xindobëz yuꞌ lënman, dxel guyu xSprijt Dios luxdooman guidiblagaa. ");
INSERT INTO zasNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Abiꞌ gunee Elisabet rejs, rëbaman: ―¡Dios ma beenleꞌ lüj loj gra ree béngunaa, beenleꞌ tëëman bejndobëz yuꞌ lënl! ");
INSERT INTO zasNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Chuza najn zeel zidganaj xniaa da Diosan naj, bén rniabee? ");
INSERT INTO zasNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Din biguiejnzan chaꞌl bagajpdiozil naj, laa baniib gajc da bindoon lënan guial babaam. ");
INSERT INTO zasNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Xiquilbaal guial bililadxil, din gac ziꞌc bagojn Dios lüj. ");
INSERT INTO zasNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Dxel rëb Li: Ruzatan Dios zagdxe, ");
INSERT INTO zasNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","rabaanëꞌ tëën laaman, guial ragnëman naj. ");
INSERT INTO zasNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Guial baguiaaman naj, majsi biin rüjnzi sirv lojman naj. Abiꞌ diizd yan xt goctëëz guzaꞌt ree bejn naj, guiëb reeman xiquilbaam. ");
INSERT INTO zasNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Din Dios, bén rniabee, dád zroꞌ na̱j ni ma beennëman naj. Naya naliman. ");
INSERT INTO zasNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ad rbëzt rayaman graczi ree bén ruzoob xtiidxaman. ");
INSERT INTO zasNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Zroꞌ na̱j ni ma beenman con xguialrniabeeman. Baseꞌnman xixgab ree bén rüjn benroꞌ, ");
INSERT INTO zasNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","biquiedaman guialrniabee loj ree bén rniabee, guiáad loj ree bén ad zojblojt badëëman guialrniabee loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Badëëman guialnazaꞌc loj ree bén biaadx guialraw, guiáad ree benrijcw basaꞌnman laa reeman zezi. ");
INSERT INTO zasNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Gognëman bén Israel ree, xbejnman, abiꞌ ad bayanladxtaman nayaman laa reeman, ");
INSERT INTO zasNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ziꞌc rëbaman loj dux béngulal ree, Abraham në loj ree xdiaaman. ");
INSERT INTO zasNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Abiꞌ bayaꞌnnë Li Elisabet cost choon bëëw, dxel baguiaj lidxim. ");
INSERT INTO zasNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Chi bidxin dxej gojl xiꞌn Elisabet najx xinguiaaw. ");
INSERT INTO zasNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Abiꞌ gogbee ree lasaꞌman në ree bén zojb gajxh guial baya Dios laaman, dád babaa reeman bignaj reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Chi ma gojc xindobëz guin toxman, dxel binë reeman laax guyux sen ni ru ree bén Israel. Abiꞌ guyën reeman naguꞌ reeman lajdoox Zacarías ziꞌc la xdadix, ");
INSERT INTO zasNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","per gunee xniaax, rëbaman: ―Ad zayutan zian. Rayal gaquim Waj. ");
INSERT INTO zasNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Dxel rëb reeman lojman: ―¿Chexquiza zeel gaquix Waj? Achut ree lasaꞌl la zian. ");
INSERT INTO zasNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Abiꞌ con sen gunabdiidx reeman loj xdad xindobëz guin chu rënman grii lajx. ");
INSERT INTO zasNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zianz gunabaman tibliaꞌ tabl abiꞌ bacaaman lojn: “Waj grii lajx.” Dád badxaloj gra ree bén guin. ");
INSERT INTO zasNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Loj hor ziigajc gojc banee Zacarías, abiꞌ guzuloj cuzaꞌtaman Dios zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Gra ree bén zojbnëman gajxh dád badxa loj reeman, xt gra ree guiedx rigaꞌ la̱d ree guiaꞌ niz Judea gogbee reeman graczi ni goc. ");
INSERT INTO zasNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Guiáad graczi ree bén gogbee zian, rniabdiidx loj lasaꞌ reeman, rëb reeman: ―¿Chu gac xindo guin yaꞌn chi niꞌsix? Rëb reeman zian guial laa rguien gajc ma beenleꞌ Dios laax. ");
INSERT INTO zasNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías, bén na̱j xdad xindo guin guyu xSprijt Dios luxdooman guidiblagaa, zianz guzuloj caneeman, rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Benzaꞌc bendxoon na̱j Dios, dux Dad ree nayajc ree bén Israel, guial biꞌtaman bidganajman dunuj ree nayajc ree xbejnman, bidgalëë tëëman dunuj ree loj ni cayzaꞌc ree. ");
INSERT INTO zasNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Guxhaalaman tijb bén rajp guialrniabee din yabëëman dunuj ree loj ni cayzaꞌc ree, zëëdaman loj xdiaa rey Davi, bén na̱j xbejn Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ziꞌc been Dios promejs diizd gocli, zian gunee ree bén badëë xtiidxaman loj ree bejn, bén guban ree ziꞌc rënman: ");
INSERT INTO zasNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","guial yabëëman dunuj ree loj ree bén ralen dunuj ree, në loj gra ree bén yuꞌxyajn dunuj ree, ");
INSERT INTO zasNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","yaya tëëman dux béngulal ree, abiꞌ ad zayanladxtaman promejs ni beenman. ");
INSERT INTO zasNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ni ne na̱j promejs ni beenman loj dux béngulal ree Abraham: ");
INSERT INTO zasNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","guial yabëëman dunuj ree loj ree bén ralen dunuj ree, din chileꞌ yaguieen ree sirv lojman sin guialrdxeb, ");
INSERT INTO zasNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","yabajn ree yaguieen tëë ree ziꞌc rënman, guidib tiamp ni yabajn ree. ");
INSERT INTO zasNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Guiáad lüj xiꞌn, guiniee ree bejn lüj bén rudëë xtiidx Dios loj ree bejn, Dios yuꞌ xanyabaa. Din nedil chiguieenchaawil xnejz bén na̱j Dad, ");
INSERT INTO zasNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","gulüü tëël xbejnman din gagbee reeman xhienaag gac xtol reeman perdon, laa tëë reeman loj casti. ");
INSERT INTO zasNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Guial raya daꞌt dux Dad ree dunuj ree, zeel guxhaal xiꞌnman, bén na̱j ziꞌc xbachaꞌ gubijdx din gusniman du loj ree, ");
INSERT INTO zasNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","guixhial tëëman xquiarguiejn ree bén zë loj nejzmal, bén ad nabant ree xnejz ziꞌc rën Dios, gulüü tëëman dunuj ree yadxoo ree loj xnejzaman din yabajn ree zagdxe sin wadijl. ");
INSERT INTO zasNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Guiáad xindo guin guniꞌsix guyu tëë xquiarguiejnx mazri por Dios. Guzujx loj yujbidx, xt bidxin dxej guneex xtiidx Dios loj ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Lën ree dxejzii gunabee rey César Augusto guiyab gra ree bejn guidib lod rniabeeman. ");
INSERT INTO zasNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Laan na̱j ni yaloj biyab ree bejn chi goc Cirenio gobernador Siria. ");
INSERT INTO zasNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Graczi ree bejn na̱j yaguiaj ladx ladx din guiyab reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Zianan zeel brii Xiëb luguiedx Nazaret ni rigaꞌ niz Galilea, wejman Belén, ni rigaꞌ niz Judea, lod gol rey Davi din loj xdiaa rey Davi zëëd Xiëb. ");
INSERT INTO zasNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Wejman binëman Li, lacheelaman din guiyab reeman. Ma yuꞌ xiꞌn Li. ");
INSERT INTO zasNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Abiꞌ laꞌtgaj zaꞌ reeman Belén, bidxin dxej gojl bejndobëz guin. ");
INSERT INTO zasNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Yagaj gol xiꞌn yaloj Li, dxel batüübaman bejndobëz guin lajd, gudijxhaman laaman lod ru ni raw ree be, guial ad bidxejlt lënü nayaꞌn reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Gajxh Belén guin zaꞌ ree bén rajp xiil, abiꞌ dajn guin gajc rdëd reeman guiaal rajp reeman laa reeb. ");
INSERT INTO zasNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Dxejczi balüüloj tijb xianjl Dios loj reeman, naynidxuj basni xbiani Dios lod rigaꞌ reeman abiꞌ dád bidxeb reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Per rëb anjl guin loj reeman: ―Ad rdxebidi din zidnëꞌn diidxzaꞌc lojdi, por laan yabaa gra ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yan, ladx rey Davi ma gojl bén yabëë lëjt loj ni cazajquidi, laaman na̱j Cristo, laaman na̱j Dad. ");
INSERT INTO zasNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Abiꞌ din yayünbeedi laaman; nadüübaman lajd, nagaꞌman lod ru ni raw ree be. ");
INSERT INTO zasNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Dxejczi balüüloj zien daꞌt ree anjl cwëꞌ anjl yaloj guin, ruzaꞌt reeman Dios zagdxe, rëb reeman: ");
INSERT INTO zasNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Benzaꞌc bendxoon na̱j Dios bén yuꞌ xanyabaa, abiꞌ loj guidxliuj yabeꞌcdxeman luxdoo bén rüjn ree ziꞌc rënman! ");
INSERT INTO zasNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Chi ma zia ree anjl guin xanyabaa, dxel rëb loj lasaꞌ ree bén rajp ree xiil guin: ―Yoꞌ ree Belén yuquiaa ree ni goc ni, ziꞌc ma bagojn dux Dad ree Dios dunuj ree. ");
INSERT INTO zasNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Dxel cari daꞌt zë reeman, abiꞌ bidxaagloj reeman Li në Xiëb, nëtëë bejndobëz guin nagaꞌman lod ru ni raw ree be. ");
INSERT INTO zasNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Chi baguiaa reeman laaman, be reeman diidx ni rëb anjl guin loj reeman xcwent bejndobëz guin, ");
INSERT INTO zasNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","abiꞌ graczi ree bén biguiejn dád badxa loj reeman ni rëb ree bén rajp ree xiil guin. ");
INSERT INTO zasNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Per Li, rguꞌchaaw luxdooman gra ni rucaagdiajgaman, rüjn tëëman laan xgab. ");
INSERT INTO zasNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Dxel zia ree bén rajp ree xiil guin, rabaa reeman rudëë tëë reeman quixtëë loj Dios por gra ni baguiaa reeman biguiejn tëë reeman, guial gojc ziꞌc rëb anjl guin loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Chi ma gojc toxman gojl bejndobëz guin, badxeꞌ reeman laaman sen ni ru ree bén Israel, baguꞌ tëë reeman lajman Jesús ziꞌc rëb anjl guin loj Li chi gad Jesús gacxhiej lënman. ");
INSERT INTO zasNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Chi bayaaloj ree dxej ni been Li ziꞌc rüjn ree béngunaa rajl xiꞌn, dxel binë reeman bejndobëz guin loj Dios lën yadooroꞌ Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Been reeman zian din loj ley guin ca: “Gra ree xindoniguiaaw rajl yaloj ma na̱j reex par Dios.” ");
INSERT INTO zasNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Abiꞌ binë reeman gon par Dios ziꞌc rniabee ley: rayal chinë reeman tioꞌp gugdoo o tioꞌp palomdoo. ");
INSERT INTO zasNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tiamp zii zojb bén la Simeón Jerusalén. Najman benzaꞌc rën tëëman Dios, rbëzaman bén gagnë bén Israel ree zaꞌnë tëë xSprijt Dios laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Abiꞌ por Sprijt guin gogbeeman guial ad zëjttaman xt guguiaaman Cristo, bén guixhiaalaman. ");
INSERT INTO zasNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Dxel por xSprijt Dios wejman lën yadooroꞌ Jerusalén. Laꞌtgaj yuꞌman lën yadoo guin, Xiëb con Li bidxinnë reeman Jesús din güün reeman ziꞌc rniabee ley, ");
INSERT INTO zasNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","zianz gudiidx Simeón bejndobëz guin bazaꞌtaman Dios zagdxe, rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Dad, yanri ma babedxe luxdon. Ma zajc guslaal naj guiëtan najn xmojsil, ma gojc ziꞌc nal. ");
INSERT INTO zasNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Din con quijb guiaalon ma baguian bén gagnë dunujn. ");
INSERT INTO zasNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Guial ma bazujl laaman loj gra ree bénguidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Laaman na̱j biani par ree bén ad najt bén Israel, na̱j tëëman bachaꞌ par ree xbén Israelil. ");
INSERT INTO zasNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Guiáad Xiëb con xniaa Jesús dád badxa loj reeman ni biguiejn reeman rëb Simeón xcwent bejndobëz guin. ");
INSERT INTO zasNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Dxel beenleꞌman laa reeman, zianz rëbaman loj Li xniaa Jesús: ―Li, Dios bacaabee bejndobëz guie din por laaman zien daꞌt ree bén Israel laa loj dol, per zien reeman yayaꞌn loj xtol. Zidgalüüman bejn ree conin na̱j ni ruladx Dios, per zien reeman ad zënt laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Abiꞌ zian gagbeeman xhienaag na̱j xixgab tijbgaj bejn, guiáad lüj ziꞌc tijb espad chëëz luxdool chi gac ree ni guin. ");
INSERT INTO zasNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Yagaj gajc zaꞌ tijb béngunaa yoꞌxh laman Ana, rudëëman xtiidx Dios loj ree bejn, xdadaman brii laj Fanuel, xdiaagulalaman gojc Aser. Benguiagan chi cwaꞌ xinguiaaw laaman, abiꞌ gajdx ijsi gubajnnë lacheelaman. ");
INSERT INTO zasNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ma gojc tajpgajlbitap ijz bayaꞌnman bizëjb. Zianczi yuꞌman lën yadooroꞌ, rbaꞌnman rbejdx rniab tëëman Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Loj hor ziigajc bibigaman lod zaꞌnë Xiëb Li con Jesús, guzuloj cudëëdaman quixtëë loj Dios cuzaꞌt tëëman bejndobëz guin loj gra ree bén cabëz guixhiaal Dios bén gagnë bén Jerusalén ree. ");
INSERT INTO zasNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Chi ma been reeman graczi ni rniabee xley Dios, dxel zia ladx reeman Nazaret ni rigaꞌ niz Galilea. ");
INSERT INTO zasNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Caniꞌs bejndobëz guin, cayuman gojl, cayajcaman nasin, cayüjnleꞌ tëë Dios laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Gazob ijz rej ree xdad Jesús Jerusalén lanij pascw. ");
INSERT INTO zasNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Chi bazaꞌ Jesús chiptioꞌp ijz, binë ree xdadaman laaman lanij zii ziꞌc na̱j xcostumbr reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Chi ma gudëd lanij guin, baza ree xdad Jesús ma zia ladx reeman. Ad gogbeet reeman bayaꞌn Jesús Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Gunaladx reeman ma noꞌchaman loj ree bén zia. Zian guza reeman tibdxej. Per chi baguiil reeman laaman loj lasaꞌ reeman në loj ree bén nünbee reeman, ");
INSERT INTO zasNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","achut laaman naguiee. Dxel bayejc reeman zia reeman Jerusalén zatijb zigdiil reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Xt ni gocri choon dxej badxejl reeman laaman lën yadooroꞌ Jerusalén, zojbaman galay ree mextr rajc ley, cucaagdiajgaman canabdiidx tëëman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Gra ree bén caguiejn ni rnieeman caydxaloj reeman guial rajcaman në ree diidx radxiꞌman. ");
INSERT INTO zasNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Chi baguiaa ree xdadaman laaman, dád badxaloj reeman, dxel rëb xniaaman: ―Xiꞌn, ¿chexc zeel basajquil dunujn zian? Xdadil con naj dád nadxuꞌn xgab caydiilan lüj. ");
INSERT INTO zasNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Badxiꞌ Jesús laan rëbaman: ―¿Chexc zeel raguiilidi naj? ¿Nid ragbeedi ya rayal günan xchiin da Dadan? ");
INSERT INTO zasNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Per ad bigniaꞌt reeman xhie rën guiëb ni rëbaman. ");
INSERT INTO zasNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Dxel bayejcnëman laa reeman zia reeman Nazaret, graczi xtiidx ree xdadaman ruzoobaman, guiáad xniaaman graczan rguꞌchaaw luxdooman. ");
INSERT INTO zasNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ziꞌcri caniꞌs Jesús cayu tëë mazri xquiarguiejnman. Rabaanë Dios laaman rabaanë tëë ree bejn laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Chi goc chiin ijz rniabee rey Tiberio, abiꞌ Poncio Pilato najman gobernador Judea, Herodes najman gobernador Galilea, bijchaman Felip najman gobernador Iturea në Traconite, guiáad Lisanias najman gobernador Abilinia. ");
INSERT INTO zasNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás në Caifás na̱j reeman bixhioz rniabee gra ree bixhioz. Lën ree dxej zii gunee Dios Waj, xiꞌn Zacarías lod na̱j yujbidx. ");
INSERT INTO zasNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Dxel gudëd Waj graczi ree guiedx rigaꞌ roꞌ guiiw Jordán, rëbaman loj ree bejn din yayüjn reeman xgab por xtol reeman tiobnijs tëë reeman, din güün Dios xtol reeman perdon. ");
INSERT INTO zasNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Zian gojc cumplid ni bacaa Isaías bén badëë xtiidx Dios loj ree bejn, lod rëbaman: Rguien chaꞌ tijb bén rbidxaꞌ loj yujbidx, rëbaman: “Gol beenchaaw xnejz dux Dad ree Dios, gol guxhal tijb nejz nali. ");
INSERT INTO zasNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Gra ree laꞌch yadxa reen guiáad ree guiaꞌ con ree lom yayajc reen tibloj, në ree nejz volt yayaali yadxa tëë ree lunejz ni ad najt tibloj. ");
INSERT INTO zasNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Gra ree bénguidxliuj guguiaa bén guixhiaal Dios gagnë dunuj ree.” ");
INSERT INTO zasNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Chi brii zien ree bejn din guroobnijs Waj laa reeman, rëbaman loj reeman: ―¡Xiꞌn xindxab lëjt! ¿Chu bagojn lëjt guial laadi loj castiroꞌ ni zëëd? ");
INSERT INTO zasNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Gol gubajn zagdxe din guiguien guial waliqui ma bayüjndi xgab por xtolidi, ad guiëb tëë loj lasaꞌdi: “Dunujn zioꞌp loj xdiaa Abraham”, din naj rni lëjt xt guiaj guie ree zajc yayüjn Dios xdiaa Abraham. ");
INSERT INTO zasNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Abiꞌ ree bén ad zinalt xnejz Dios ziꞌc rayal, ma zidyob dxej ni güünnë Dios laa reeman ziꞌc rüjnnë bejn tijb yag chi ad rtiatan, rütüügaman laan din cheꞌcan. ");
INSERT INTO zasNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dxel gunabdiidx reeman, rëb reeman: ―¿Xhie rayal yaguieenan? ");
INSERT INTO zasNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Badxiꞌ Wajn rëbaman: ―Bén yuꞌ tioꞌp xab, rayal gudëëman tijban loj bén achet rajp. Guiáad bén yuꞌ ni raw, rayal gudëëman taꞌnan loj bén ryaadxan. ");
INSERT INTO zasNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Në tioꞌp choon ree bén ruquijx impuest bidxin din tiobnijs reeman. Abiꞌ gunabdiidx reeman loj Waj, rëb reeman: ―Mextr, laadx dunujn, ¿xhie rayal yaguieenan? ");
INSERT INTO zasNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Badxiꞌ Wajn, rëbaman: ―Ad guquijxidi mazri guial loj ni rayal guquijxidi. ");
INSERT INTO zasNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Yuꞌ tëë ree suldad gunabdiidx lojman rëb reex: ―Laadxza dunujn, ¿xhie rayal yaguieenan? Badxiꞌman laan rëbaman: ―Ad cwëëxuudi xhie xieen bejn, guial guchejbidi laa reeman o gudxiibidi guijc reeman ni ad beent reeman, gol guziibnejz tëë ni rajxidi. ");
INSERT INTO zasNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Guiáad ree bejn gagbeenejzdoo reeman bal Wajn na̱j Cristo, ");
INSERT INTO zasNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","per rëbaman loj gra reeman: ―Naj curobnijs lëjt con nijs. Per zëëd tijb bén guroobnijs lëjt con xSprijt Dios në bajl. Laaman rajp mazri guialrniabee guial lon, niꞌqui xgurëchaman ad zajct gaxhiecan. ");
INSERT INTO zasNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Abiꞌ ziꞌc raya trigo zian güünnëman bejn. Din bén zinal ree xnejz Dios yayal reeman lod rniabeeman, guiáad ree bén ad zinalt xnejz Dios guixhiaalaman laa reeman loj bajl ni ad yuꞌt dxej yayüꞌ. ");
INSERT INTO zasNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Zian guneenë Waj laa reeman, në ree con diidx ren guneenëman laa reeman rulüüman laa reeman xtiidxzaꞌc Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Gudilë tëëman rey Herodes guial cwaꞌman Herodías xbéngunaa bijchaman Felip, në por graczi ni mal ni ma beenman. ");
INSERT INTO zasNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Per luar nidxgaꞌ Herodes xtiidx Waj aal beenman zatijb ni mal: badxeꞌman Waj ladxguiib. ");
INSERT INTO zasNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Chi curoobnijs Waj bejn ree nëgajc Jesús gurobnijs. Abiꞌ laꞌtgaj cabejdx canabaman Dios, bixal xanyabaa ");
INSERT INTO zasNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","zianz biguiajt xSprijt Dios ziꞌc tijb palom xt guijcaman. Dxel biguien chaꞌ tijb bejn xanyabaa, rëbaman: ―Lüj na̱j da xiꞌnan, rënan lüj rabaanëꞌ tëën lüj. ");
INSERT INTO zasNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Cost gajlbichii ijz yuꞌ Jesús chi guzuloj beenman xchiin Dios. Naladx ree bejn xiꞌn Xiëb najman, Xiëb guin gojc xiꞌn Elí. ");
INSERT INTO zasNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí gojc xiꞌn Matat, Matat gojc xiꞌn Leví, Leví gojc xiꞌn Melqui, Melqui gojc xiꞌn Jana, Jana gojc xiꞌn Xiëb, ");
INSERT INTO zasNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Xiëb gojc xiꞌn Matatías, Matatías gojc xiꞌn Amós, Amós gojc xiꞌn Nahum, Nahum gojc xiꞌn Esli, Esli gojc xiꞌn Nagai, ");
INSERT INTO zasNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai gojc xiꞌn Maat, Maat gojc xiꞌn Matatías, Matatías gojc xiꞌn Semei, Semei gojc xiꞌn Xiëb, Xiëb gojc xiꞌn Judá, ");
INSERT INTO zasNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá gojc xiꞌn Joana, Joana gojc xiꞌn Resa, Resa gojc xiꞌn Zorobabel, Zorobabel gojc xiꞌn Salatiel, Salatiel gojc xiꞌn Neri, ");
INSERT INTO zasNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri gojc xiꞌn Melqui, Melqui gojc xiꞌn Adi, Adi gojc xiꞌn Cosam, Cosam gojc xiꞌn Elmodam, Elmodam gojc xiꞌn Er, ");
INSERT INTO zasNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er gojc xiꞌn Josué, Josué gojc xiꞌn Eliezer, Eliezer gojc xiꞌn Jorim, Jorim gojc xiꞌn Matat, ");
INSERT INTO zasNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat gojc xiꞌn Leví, Leví gojc xiꞌn Simeón, Simeón gojc xiꞌn Judá, Judá gojc xiꞌn Xiëb, Xiëb gojc xiꞌn Jonán, Jonán gojc xiꞌn Eliaquim, ");
INSERT INTO zasNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim gojc xiꞌn Melea, Melea gojc xiꞌn Mainán, Mainán gojc xiꞌn Matata, Matata gojc xiꞌn Natán, ");
INSERT INTO zasNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán gojc xiꞌn Davi, Davi gojc xiꞌn Isaí, Isaí gojc xiꞌn Obed, Obed gojc xiꞌn Booz, Booz gojc xiꞌn Salmón, Salmón gojc xiꞌn Naasón, ");
INSERT INTO zasNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón gojc xiꞌn Aminadab, Aminadab gojc xiꞌn Aram, Aram gojc xiꞌn Esrom, Esrom gojc xiꞌn Fares, Fares gojc xiꞌn Judá, ");
INSERT INTO zasNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá gojc xiꞌn Jacob, Jacob gojc xiꞌn Isaac, Isaac gojc xiꞌn Abraham, Abraham gojc xiꞌn Taré, Taré gojc xiꞌn Nacor, ");
INSERT INTO zasNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor gojc xiꞌn Serug, Serug gojc xiꞌn Ragau, Ragau gojc xiꞌn Peleg, Peleg gojc xiꞌn Heber, Heber gojc xiꞌn Sala, ");
INSERT INTO zasNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala gojc xiꞌn Cainán, Cainán gojc xiꞌn Arfaxad, Arfaxad gojc xiꞌn Sem, Sem gojc xiꞌn Noé, Noé gojc xiꞌn Lamec, ");
INSERT INTO zasNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec gojc xiꞌn Matusalén, Matusalén gojc xiꞌn Enoc, Enoc gojc xiꞌn Jared, Jared gojc xiꞌn Mahalaleel, Mahalaleel gojc xiꞌn Cainán, ");
INSERT INTO zasNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán gojc xiꞌn Enós, Enós gojc xiꞌn Set, Set gojc xiꞌn Adán, guiáad Adán gojc xiꞌn Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yuꞌ xSprijt Dios luxdoo Jesús guidiblagaa. Chi bazaman guiiwroꞌ Jordán dxel binë xSprijt Dios laaman lod na̱j yujbidx. ");
INSERT INTO zasNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ni guzuman tiuu dxej tiuu guiaal, abiꞌ been xindxab laaman prueb. Achetczi gudawaman dxej zii ree, zianz gulaanman. ");
INSERT INTO zasNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Dxel rëb xindxab guin lojman: ―Bal wali najl Xiꞌn Dios, gunabee yayajc guiaj guie guiadxtil. ");
INSERT INTO zasNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Badxiꞌ Jesús laan rëbaman: ―Loj xtiidx Dios rëb: “Ad ganaxtizi guiadxtil guiban bejn, nëgajc gra diidx rniee Dios.” ");
INSERT INTO zasNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Dxel binë xindxab guin laaman tijb guijc guiaꞌ ya daꞌt, lod balüüx laaman gra ree nacion rigaꞌ loj guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Abiꞌ rëb xindxab guin lojman: ―Gunen graczi guialrniabee në guialnazaꞌc ni yuꞌ loj ree nacion guie. Din naj caꞌ laa reen, zajc gudëdan laa reen loj chutëëz bén rënan. ");
INSERT INTO zasNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Bal guzuxibil lon abiꞌ guiën daꞌtil naj, graczan gac xieenl. ");
INSERT INTO zasNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Badxiꞌ Jesús laan, rëbaman: ―Loj xtiidx Dios rëb: “Tijbzi loj xDadil Dios guzuxibil guiën tëël laaman, abiꞌ tijbzi laaman been sirv.” ");
INSERT INTO zasNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Dxel binë xindxab guin laaman Jerusalén, abiꞌ gulëꞌpix laaman guijc yadooroꞌ zojb luguiedx guin. Zianz rëbix lojman: ―Bal wali najl Xiꞌn Dios, gudidyaꞌ diizd guie xt luyuj, ");
INSERT INTO zasNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","din loj xtiidx Dios rëb: Dios guixhiaal ree xianjlaman din guinia reeman lüj. ");
INSERT INTO zasNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Yales reeman lüj con yaa reeman, chitëë quiilguijdx guiaj guiaꞌl. ");
INSERT INTO zasNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Badxiꞌ Jesús laan rëbaman: ―Rëb tëë loj xtiidx Dios: “Ad güünl prueb xDadil Dios.” ");
INSERT INTO zasNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Chi ad badxejltri xhienaag güün xindxab guin Jesús prueb, dxel biquiedix tibladëd. ");
INSERT INTO zasNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Badxin Jesús niz Galilea, yuꞌ xSprijt Dios luxdooman guidiblagaa, abiꞌ guidibczi niz yagaj bireꞌch xtiidxaman. ");
INSERT INTO zasNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Rulüüman bejn ree lën ree yadoo guidib niz yagaj, abiꞌ graczi reeman ruzaꞌt laaman zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Badxin Jesús Nazaret luguiedx lod guniꞌsaman. Abiꞌ dxej raziiladx ree bejn guyuman lën yadoo ziꞌc na̱j xcostumbraman. Dxel guzuliman persi biilaman xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Badëëd reeman guiꞌch ni bacaa Isaías bén badëë xtiidx Dios loj ree bejn. Chi bachijlaman loj guiꞌch guin, badxejlaman lod rëb: ");
INSERT INTO zasNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","XSprijt dux Dad ree Dios zaꞌnë naj, din laaman ma beenleꞌ naj din ganen xtiidxzaꞌcaman loj ree bénprob. Guxhaalaman naj din gugojnan bejn ree xhienaag laa reeman loj ni rzajc reeman, yaxhal tëën loj ree bénlutiaꞌp. Gün tëën yudar bén rusagzi reeman, ");
INSERT INTO zasNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","din gugojnan guial ma bidxin dxej zaꞌcdxoon ni güünleꞌ Dios bejn ree. ");
INSERT INTO zasNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Dxel batüüb Jesús guiꞌch guin bayüman laan loj bén rüjn yudar lën yadoo guin, zianz gurejman. Graczi ree bén rigaꞌ yagaj ruguiaadxijch laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Dxel guzuloj caneenëman laa reeman, rëbaman: ―Yan dxej gajc ma gojc cumplid ziꞌc ca loj xtiidx Dios ni ma biguiejndi. ");
INSERT INTO zasNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Graczi reeman cuzaꞌt laaman zagdxe caydxa tëë loj reeman diidxzaꞌcdxoon ni caneeman. Dxel canabdiidx loj lasaꞌ reeman rëb reeman: ―¿Nid laaman na̱j xiꞌn Xiëb ya? ");
INSERT INTO zasNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Dxel rëb Jesús loj reeman: ―Ma ragbeen guial nadi tijb diidx ni rëb: “Doctor, bayüjn lüj gajc”, na tëëdi: “Ni ma baguiejnan beenl Capernaum nëgajc guie beenan najn ladxil.” ");
INSERT INTO zasNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Rëb tëë Jesús: ―Diidxliczi rnin, niꞌczi tijb bén rudëë xtiidx Dios loj ree bejn, ad rënt reeman laaman ladx gajcaman. ");
INSERT INTO zasNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Gol basaaladx dád zien ree béngunaa bizëjb zojb Israel lën ree dxej guban Elías bén badëë xtiidx Dios loj ree bejn, chi ad golt guia choon ijz garol, abiꞌ guyu gubijn guidibczi. ");
INSERT INTO zasNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Per ad guxhaalt Dios Elías guin loj tijb ree bén bizëjb zojb Israel, guxhaalaman laaman loj tijb bén bizëjb zojb guiedx la Sarepta, gajxh Sidón. ");
INSERT INTO zasNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Në lën ree dxej guban Eliseo bén badëë xtiidx Dios loj ree bejn, dád zien ree bejn rajc guialguijdx la lepra, per niꞌczi tijb reeman ad bayüjntaman, tijbzi bén Siria bayüjnman laman Naamán. ");
INSERT INTO zasNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Chi biguiejn gra ree bén yuꞌ lën yadoo guin ni rëb Jesús, dád balen reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bisu reeman babëë reeman Jesús luguiedx guin, dxel binë reeman laaman roꞌ tijb balaꞌ ya guial na̱j guiedx guin guijc tijb guiaꞌ, din gutediaꞌ reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Per gudëd Jesús galay reeman, ziataman. ");
INSERT INTO zasNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Wej Jesús guiedx Capernaum ni rigaꞌ niz Galilea, yagaj rulüüman bejn ree dxej ni raziiladx reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Abiꞌ dád badxaloj reeman ni rulüüman guial rnieenëman laa reeman con guialrniabee. ");
INSERT INTO zasNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Lën yadoo guin yuꞌ tijb xin yuꞌ xindxab luxdoo, abiꞌ guridxaꞌ xindxab guin rëbix: ");
INSERT INTO zasNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Basaꞌn dunujn, ¿xhie rënl con dunujn, Jesús bén Nazaret? ¿Zëëdil ya zidganijtil dunujn? Nünbeen lüj, naya nalil najl xiꞌn Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Dxel gudilë Jesús xindxab guin, rëbaman lojx: ―¡Bacwëëz roꞌl, barii luxdoo xin guin! Zianz badxeꞌbi xindxab guin xin guin luyuj guidib niz loj reeman, bariitix luxdoox achetczi goquix. ");
INSERT INTO zasNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Graczi reeman badxaloj, rëb loj lasaꞌ reeman: ―¿Xhie ree diidx guin rnieeman? ¡Con guialrniabee ni rajpaman, rniabeeman rarii ree xindxab luxdoo ree bejn! ");
INSERT INTO zasNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Abiꞌ guidibczi niz yagaj bireꞌch xtiidxaman. ");
INSERT INTO zasNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Dxel barii Jesús lën yadoo guin, abiꞌ wejman lidx Simón. Ragxuu xnasuegr Simón guin yuꞌman xliaadoxh zeel guzajc reeman Jesús liaadx din yayüjnman laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Zianz basajb loj Jesús lod nagaꞌman gunabeeman yarii xliaa guin, abiꞌ bariin. Loj hor ziigajc bixcheman guzuloj cudëëman ni gaw reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Chi ma wëëz gubijdx, graczi ree bén rajp bénragxuu bén rajc ree gadxagayaa guialguijdx binë reeman laa reeman loj Jesús, persi badxiib yaaman guijc tijb gaj reeman, bayüjnman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Në zien ree bénragxuu guin rarii xindxab luxdoo, rbidxaꞌ reex rëb reex: ―¡Lüj na̱j Xiꞌn Dios! Per gudilëman xindxab guin ree, ad cwëjbtaman niniee reex, guial ragbee reex laaman na̱j Cristo. ");
INSERT INTO zasNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Chi bareguiaal, barii Jesús luguiedx guin zëman lod achut bejn zojb. Per raguiil ree bénguiedx guin laaman, bidxin reeman lod zaꞌman abiꞌ rëb reeman lojman din yayaꞌnnëman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Per rëbaman loj reeman: ―Në ree luguiedx ren rayal chinëꞌn xtiidxzaꞌc Dios guial xhienaag na̱j xguialrniabeeman, din par zian guxhaalaman naj. ");
INSERT INTO zasNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Zian basnuu guneeman xtiidx Dios lën ree yadoo niz Galilea. ");
INSERT INTO zasNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tijb dxej chi zaꞌ Jesús roꞌ nijs Genesaret, bidxin ree benzien. Xt rxaꞌt reeman laaman guial rën reeman gucaagdiajg reeman xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Dxel baguiaa Jesús tioꞌp barcw roꞌ nijs guin; ni basaꞌn ree bén rniaaz bëjl laꞌtgaj caguiib xguijxh reeman ni rniaaznë reeman bëjl. ");
INSERT INTO zasNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Zianz wëꞌpaman loj tijb barcw ni na̱j xbarcw Simón, abiꞌ rëbaman lojman din gudxigaman laan niz galay nijs guin. Dxel gurejman, guzuloj culüüman bejn ree. ");
INSERT INTO zasNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Chi gulox guneenëman laa reeman, dxel rëbaman loj Simón: ―Binë barcw guin lod mazri naxhit, gol bazaal xguijxhidi din guiniaazidi bëjl. ");
INSERT INTO zasNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Badxiꞌ Simón laan rëbaman: ―Mextr, gudëd guiaalczi baguieenan dxiin, achutczi bëjl wanaazan. Per bal lüj na, yazaalan guijxh guin ree. ");
INSERT INTO zasNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Chi bazaal reeman guijxh guin ree loj nijs guin, bëjl zien daꞌt gunaaz reeman xt guzuloj cayaxyaꞌ ree guijxh guin. ");
INSERT INTO zasNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Abiꞌ been reeman sen loj ree xcompniar reeman bén yuꞌ ree loj stijb barcw guin, din chiguieen reeman laa reeman yudar. Dxel wej reeman, abiꞌ bacha reeman bëjl guin ree loj grop barcw guin xt ma nizëëb reen xan nijs. ");
INSERT INTO zasNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Chi baguiaa Simón Bëd ni goc, bazuxibaman loj Jesús rëbaman: ―Biquied lod zaꞌn, Dad, din béndol naj. ");
INSERT INTO zasNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Guial Simón con ree bén zaꞌnëman badxa loj reeman guial dád zien bëjl gunaaz reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ziangajc badxaloj ree Jacob con Waj, bén na̱j ree xiꞌn Zebedeo, na̱j tëë reeman xcompniar Simón. Per rëb Jesús loj Simón: ―Ad rdxebil, din diizd yan gutoꞌpil bejn ree par Dios luar guiniaazil bëjl. ");
INSERT INTO zasNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Dxel babëë reeman barcw guin ree loj nijs guin, basaꞌn reeman laa reen, zinalt reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Chi zaꞌ Jesús tijb luguiedx, bidxin tijb bén rajc guialguijdx la lepra, guidibczaman ma yuꞌ guialguijdx guin. Chi baguiaaman Jesús laa bazuxib gajcaman, basajb lojman luyuj, rëbaman: ―Dad, bal rënl, zajc yayüjnl naj. ");
INSERT INTO zasNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Zianz basli yaa Jesús baquiꞌman laaman, rëbaman: ―Rënan. Bayajc. Loj hor ziigajc bayajc bén guin. ");
INSERT INTO zasNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Dxel rëb Jesús lojman: ―Achuczi loj guiëbil guial ma bayajquil. Lojzi bixhioz wej din guguiaaman lüj. Binë gon ni rayal chinël ziꞌc gunabee Moisejs din gagbee gra bejn guial ma bayajquil. ");
INSERT INTO zasNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Per guixie guixie mazri bireꞌch xtiidx Jesús por gra ree ni zagdxe rüjnman. Abiꞌ dád benzien rdoꞌp din gucaagdiajg reeman ni rnieeman yayüjn tëëman laa reeman guialguijdx ni rajc reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Guiáad laaman rejman niz lod achut bejn zojb, persi rbejdx rniabaman Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tijb dxej culüü Jesús bejn ree, abiꞌ zojb tioꞌp choon ree bénfarisew në ree mextr rajc ley, zëëd reeman guiedxdo ni rigaꞌ ree niz Galilea në niz Judea, në Jerusalén. Zaꞌnë xguialrniabee Dios laaman persi rayüjnman bénragxuu ree. ");
INSERT INTO zasNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Dxel bidxin tioꞌp choon ree bejn, bidxinnë reeman tijb xin nëjt xcuerp, nagaꞌx loj da. Abiꞌ guyën reeman niunë reeman laax lënü guin din niguijxh reeman laax lod zaꞌ Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Per ad badxejlt ban niz niunë reeman laax guial bén guixiuj rigaꞌ yagaj. Dxel wëꞌp reeman guijc yu guin, abiꞌ biquied reeman tex dxiib guijcan, zianz gulet reeman xinragxuu guin guidib nagaꞌx loj da guin, gudijxh reeman laax galay ree bén guin lod zaꞌ Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Chi baguiaa Jesús guial rliladx reeman laaman; rëbaman loj xinragxuu guin: ―Xiꞌn, ma benan xtolil perdon. ");
INSERT INTO zasNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Per ree mextr rajc ley con ree bénfarisew guzuloj cayüjn reeman xgab: “¿Chu xin guin zeel rüjnx mazri xin zojbloj guial loj Dios? Achutczi rajc rüjn perdon dol, tijbzi Dios.” ");
INSERT INTO zasNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Per gogbee gajc Jesús xgab cayüjn reeman, dxel rëbaman: ―¿Chexc zeel rüjndi xgab zian? ");
INSERT INTO zasNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Conin ad nawëëgt gac, guial guiën ya: “Ma na̱j xtolil perdon”, o guiën: “Bixche guza tëë”? ");
INSERT INTO zasNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Per yan, gulün lëjt guial Bén guxhaal Dios rajpaman guialrniabee loj guidxliuj guie din güünman perdon dol ree. Dxel rëb Jesús loj xinragxuu guin: ―¡Bixche, bacaꞌ ni goꞌtil loj! Baguiaj lidxil. ");
INSERT INTO zasNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Loj hor guin gajc bixchex guidibloj gra ree bén rigaꞌ yagaj balesix ni goꞌtix loj, zianz zia lidxix ruzaꞌtix Dios zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Graczi reeman badxaloj ruzaꞌt tëë reeman Dios zagdxe abiꞌ dád bidxeb reeman, rëb reeman: ―¡Niꞌqui tijb ad waguiaat ree ziꞌct na̱j ni cayguiaa ree yan! ");
INSERT INTO zasNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Chi gudëd gojc zian, baguiaa Jesús tijb bén ruquijx impuest, laman Leví, zojbaman lod ruquijxaman. Abiꞌ rëbaman lojman: ―Tanal naj. ");
INSERT INTO zasNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Dxel bisu Leví, guroꞌnladxaman gran zinaltaman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Abiꞌ been Leví lanijroꞌ lidxaman par Jesús, në zien ree bén ruquijx impuest zojb nëtëë ree ben ren zojbnë reeman xan mex. ");
INSERT INTO zasNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Per ree bénfarisew ree në ree mextr rajc ley, bén nuchajg gajc ree bénfarisew guin, guzuloj caneeguijdx reeman xbejn ree Jesús, rëb reeman: ―¿Chexc zeel rëꞌ rawnëdi bén ruquijx ree impuest në ree béndol? ");
INSERT INTO zasNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Badxiꞌ Jesús laan rëbaman: ―Bénnadaan ree ad riaadxt reeman doctor, bénragxuu ree laa reeman riaadx Doctor. ");
INSERT INTO zasNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ad zialtan par ree benzaꞌc, zialan par ree béndol din yayüjn reeman xgab por xtol reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bénfarisew ree në ree mextr rajc ley, rëb reeman loj Jesús: ―Xbejn Waj, në ree xbejn ree bénfarisew dád zien volt rbaꞌn reeman rbejdx rniab tëë reeman Dios, guiáad ree xbejnl ganax rëꞌ raw reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Badxiꞌ Jesús laan rëbaman: ―¿Wen zajc güündi naguiejn ya guibaꞌn ree biooz zaꞌ loj guialruxhliaa, laꞌtgaj zaꞌnë xin cuxhliaa guin laa reeman? ");
INSERT INTO zasNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Per guidxin dxej chiquiedix, dxel guibaꞌn reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Rëb tëëman loj reeman: ―Achut bén rutüüg taꞌn lajd cüb din yataꞌman laan loj lajd yojx. Bal güünman zian, zaguixyaꞌ lajd cüb guin lajdyojx guin, nëtëë yan ad zuguiaatan zagdxe loj lajdyojx guin. ");
INSERT INTO zasNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ad rguꞌ tëët bejn vin cüb lën anfr yojx, din bal güünman zian, zaguixyaꞌ vin cüb guin anfr guin, abiꞌ ziꞌc anfr guin ziꞌc vin guin zaxin reen. ");
INSERT INTO zasNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Zeel vin cüb rayal chuꞌn lën anfr cüb din niꞌqui tijb reen ad zaxint. ");
INSERT INTO zasNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Abiꞌ tijb bén ma guꞌ vin yuꞌ gocli ad rëꞌtaman vin cüb, din rëbaman: “Vin yuꞌ gocli mazri ni zagdxen.” ");
INSERT INTO zasNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tijb dxej raziiladx ree bén Israel, laꞌtgaj cadëd Jesús con ree xbejnman loj tijb guiniaa lod yuꞌ trigo. Guzuloj caguiꞌch reeman trigo guin, dxel cuxhoꞌp reeman laan cayaw reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Abiꞌ yuꞌ ree bénfarisew rëb loj reeman: ―¿Chexc zeel rüjndi ni ad rayalt güündi dxej raziiladx ree bejn? ");
INSERT INTO zasNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Badxiꞌ Jesús laan, rëbaman: ―¿Gadidi gool loj xtiidx Dios ya ni been Davi chi gulaanman con ree xcompniaraman? ");
INSERT INTO zasNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Guyuman lën xyadoo Dios, cwaꞌman guiadxtil ma nagleꞌ ree gudawaman con ree xcompniaraman, ni ad rayalt niajw reeman bixhiosi ree rayal gaw laa reen. ");
INSERT INTO zasNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Rëb tëë Jesús loj reeman: ―Bén guxhaal Dios rajpaman guialrniabee dxej raziiladx ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Zatijb dxej raziiladx reeman, guyu Jesús lën tijb yadoo abiꞌ guzuloj culüüman bejn ree. Yagaj zaꞌ tijb xin naxüꞌn yaa ladbee. ");
INSERT INTO zasNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Abiꞌ ree mextr rajc ley në ree bénfarisew rzunal reeman din guidoon zayüjn Jesús laax dxej raziiladx reeman ya, din gac gutediaꞌ reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Per laaman ragbee gajcaman xhie xgab cayüjn reeman, zeel rëbaman loj xin naxüꞌn yaa guin: ―Bisu, guzuli galay guin. Dxel guzulix, guzujx galay guin. ");
INSERT INTO zasNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Dxel rëb Jesús loj reeman: ―Ganabdiidxan lëjt: ¿Xhie rayal güün bejn dxej raziiladx reeman, ni zagdxe ya o ni mal? ¿Guslaaman xguialnaban bejn ya o gugüjtaman laaman? ");
INSERT INTO zasNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Dxel baguiaa Jesús gra ree bén rigaꞌ yagaj, abiꞌ rëbaman loj xin guin: ―Basli yaal. Dxel beenx ziꞌc rëbaman, abiꞌ bayajc yaax. ");
INSERT INTO zasNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Per laa reeman dád bidxeꞌch reeman, guzuloj rëb loj lasaꞌ reeman xhienaag güünnë reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Lën ree dxej zii wej Jesús tijb ruguiaꞌ persi gurejdx gunabaman Dios, abiꞌ gudëd guiaalczi gurejdx gunabaman Dios yagaj. ");
INSERT INTO zasNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Chi bareguiaal, gurejdxaman bén nal ree laaman, dxel gulejman chiptioꞌp reeman loj reeman, abiꞌ guneeman laa reeman apóstoles. ");
INSERT INTO zasNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","La reeman: Simón, bén gulëëlajman Bëd, Andrejs bijch Simón, Jacob, Waj, Felip, Tol, ");
INSERT INTO zasNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matew, Tumajs, Jacob xiꞌn Alfeo, Simón, bén biꞌch loj ree bén cananistas, ");
INSERT INTO zasNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas xiꞌn Jacob, në Judas Iscariote bén bayü Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Baguiajt Jesús ruguiaꞌ guin con guidxiptioꞌp ree xbejnman, badxin reeman lod na̱j tijb laꞌch. Yagaj badoꞌp zien ree xbejnman në ree ben ren, bén zëëd ree niz Judea në Jerusalén në ree bén zëëd Tiro con Sidón, guiedx rigaꞌ ree gajxh roꞌ nijsdoo. Bidxin reeman din gucaagdiajg reeman xtiidx Jesús din yayüjn tëëman laa reeman guialguijdx ni rajc reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Në ree bén yuꞌ xindxab luxdoo bayajc. ");
INSERT INTO zasNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Zeel graczi ree bejn rën guquiꞌ laaman, guial rayüjnman laa reeman con xguialrniabeeman. ");
INSERT INTO zasNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Dxel baguiaa Jesús loj ree xbejnman, abiꞌ rëbaman: ―Xiquilbaadi bénprob, din lëjt rayal loj xguialrniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Xiquilbaadi bén rliaan ree yan, din Dios gunee ni gawidi xt chigdxinladxidi. ’Xiquilbaadi bén roon ree yan, din zadxin dxej guxijdxidi. ");
INSERT INTO zasNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Xiquilbaadi chi rdxeꞌch bejn lëjt, chi rabëëca reeman lëjt, rnieeguijdx tëë reeman lëjt, naladx reeman najdi bendxuudx guial rliladxidi Bén guxhaal Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Gol babaa gol badxeꞌ tëë luxdoodi zagdxe chi güünnë reeman lëjt zian, din zroꞌ ni tiaꞌdi yuꞌ xanyabaa, din ziangajc beennë xbéngulal reeman bén badëë ree xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Per probza lëjt benrijcw, din ma guyuxgaj luxdoodi nix. ");
INSERT INTO zasNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Probza lëjt bén raw xt rigdxinladx yan, din zadxin dxej guiliaandi. ’Probza lëjt bén ruxijdx yan, din zadxin dxej goondi guial chuꞌnayadi. ");
INSERT INTO zasNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Probza lëjt, bén ruladx ree guilies bejn xvalor, din zian beennë ree xbéngulal reeman bén goc ree bén rusquiee, rëb reeman rudëë reeman xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Per ganin lëjt bén rucaagdiajg ree da diidxan: Gol guyën bén ralen lëjt, gol gojc benzaꞌc con ree bén yuꞌxyajn lëjt, ");
INSERT INTO zasNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","gol bazaal diidxzaꞌc guijc ree bén ruzaal diidxmal guijquidi, gol gurejdx gunab Dios por ree bén rnieeguijdx lëjt. ");
INSERT INTO zasNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bal chu chëëz tiblad xhajguil, badëëd zatibladan, bal chu cwëëxuu xchamarril, ad cwexuul chinëman në xmanguil. ");
INSERT INTO zasNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Chutëëz bén rniab xhienin lojl, badëëdan. Bal chu rquied xhie xieenl, ad bal yanabilan. ");
INSERT INTO zasNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Gol beennë ree bejn ziꞌc rëndi güünnë reeman lëjt. ");
INSERT INTO zasNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Bal rëndi ganaxzi bén rën lëjt, ¿xhieza ni zagdxen cayüjndi? Din xt béndol ree rüjn zian, rën reeman bén rën laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Abiꞌ bal rüjndi wen ganaxzi bén rüjn lëjt wen, ¿xhieza ni zagdxen cayüjndi? Din xt béndol ree rüjn zian. ");
INSERT INTO zasNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ziangajc bal rudëëdidi ni rguiꞌn ganaxzi bén naladxidi zajc yaguijx lojdi, ¿xhieza ni zagdxen cayüjndi? Din xt në ree béndol rudëëd rguiꞌn ree bén naladx reeman zajc yaguijx loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Per lëjt gol guyën bén ralen lëjt, gol been reeman wen. Gol badëëd quiꞌn reeman, ad cwëzidi xhie tiaꞌdi guijcan. Zian tiaꞌdi zroꞌ guialnazaꞌc ni gunee Dios bén yuꞌ xanyabaa, gac tëëdi xiꞌnman, din laaman na̱j benzaꞌc con ree bén ad rudëët quixtëë lojman në con ree benmal. ");
INSERT INTO zasNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Gol baya bejn ziꞌc raya dux Dad ree Dios bejn. ");
INSERT INTO zasNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Ad gulaꞌchidi, ad gudxiib tëëdi ni mal guijc ree bejn chitëë saquidi zian, gol been perdon din gaquidi perdon. ");
INSERT INTO zasNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gol badëëd ni riaadx ree bejn, Dios mazri zroꞌ na̱j ni guneeman ziꞌc tijb bols guidxadi. Din ziꞌc rudëëdidi loj ree bejn, ziant gajc na̱j ni gunee Dios lojdi. ");
INSERT INTO zasNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Rëb Jesús loj reeman zatijb diidx: ―¿Wen zajc chinë bénlutiaꞌp zatijb bénlutiaꞌp ya? ¿Nid zayajb grop reeman roꞌ balaꞌ ya? ");
INSERT INTO zasNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tijb bén cusiid, ad mazt rajcaman guial loj xmextraman. Guiáad chi ma gulox basiidaman rajcaman ziꞌctgajc rajc xmextraman. ");
INSERT INTO zasNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Ad gulaꞌchil ben ren por faltdobëz ni rajpaman, zagdxeli guyu xgab por falt naroob ni rajpil. ");
INSERT INTO zasNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Abiꞌ bal mazri falt naroob rajpil, ¿xoza guiëbil loj zatijb bejn: “Ad laat na̱j ni rüjnl”? ¡Bén rusquiee! yalojxgaj been ziꞌc rayal, chi ma beenl zian dxel ma zileꞌ guiëbil loj zatijb bejn: “Ad laat na̱j ni rüjnl”. ");
INSERT INTO zasNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Ad yuꞌt yag zagdxe rtia ni guijdx loj, ad yuꞌ tëët yag guijdx rtia ni zagdxe loj. ");
INSERT INTO zasNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Din tijbgaj yag rayünbee bejn xhie yagan por ni rtia lojn. Ad raruꞌt higo loj yaquiëjch, ad raruꞌ tëët uv loj guiꞌxh. ");
INSERT INTO zasNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Benzaꞌc rnieeman diidxzaꞌc din laan yuꞌ luxdooman, guiáad benmal rnieeman diidxmal din laan yuꞌ luxdooman. Din ni yuꞌ luxdoo bejn laan rnieeman. ");
INSERT INTO zasNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Chexc zeel rnieedi naj, “Dad, Dad”, abiꞌ adza rüjntidi ni rnin? ");
INSERT INTO zasNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ganin lojdi chu na̱j ziꞌc bén riꞌt lon, riguiejnman ni rën, abiꞌ rüjnman laan: ");
INSERT INTO zasNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","laaman na̱j ziꞌc tijb bén been yu, yaloj xgaj gudëënman naxhit xt chi bila loj guiaj, dxel gulesaman xcimiantan guijc guiaj guin. Abiꞌ chi biꞌt nijsroꞌ majsi gulajn lad yu guin, per niꞌquid baniibtan laan guial na̱j cimiant guin guijc guiaj. ");
INSERT INTO zasNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Per bén riguiejn da diidxan abiꞌ ad rüjntaman laan, najman ziꞌc tijb bén been yu ni ad yuꞌt xcimiant. Abiꞌ chi biꞌt nijsroꞌ gulajn lad yu guin, balenxanan laan, tiblayaazi baseꞌnan laan. ");
INSERT INTO zasNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Chi gulox guneenë Jesús bejn ree, dxel zëman Capernaum. ");
INSERT INTO zasNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Yagaj zojb tijb suldad Rom xin rniabee ree suldad. Yuꞌ tijb xmojsix xin rën daꞌtix, ragxuu mojs guin ma rulüüczi guiëtix. ");
INSERT INTO zasNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Chi biguiejn suldad rniabee guin ruzaꞌt ree bejn Jesús, guxhaalix tioꞌp choon ree bén rniabee Israel lojman din chisajc reeman liaadx yayüjnman xmojsix. ");
INSERT INTO zasNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Abiꞌ bidxin reeman loj Jesús guzajc reeman liaadx, rëb reeman: ―Gagnësiil suldad rniabee guin, ");
INSERT INTO zasNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","din rënx bén duladx ree, në yan por laax gojc dux yadoo ree. ");
INSERT INTO zasNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Dxel binë Jesús laa reeman. Per chi ma cadxin reeman gajxh lidxix, guxhaal tioꞌp choon ree xmiwix loj Jesús biguiedx reex lojman: ―Dad, ad chuꞌl xgab, din ad rayaltan chuꞌl lënü lidxan, ");
INSERT INTO zasNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","zeel ad bayaxtan nial quijb naj nidgadilan lüj. Per con gunee diizd lod zaꞌl din yayajc da mojsan. ");
INSERT INTO zasNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Din ziꞌc naj yuꞌ ree bén rniabee naj, ziangajc naj yuꞌ ree da suldadan xin rniabeen. Chi rën loj tijb reex: “Wej”, rejx. Chi rën loj zatijbix: “Guda”, riꞌtix. Abiꞌ chi rën loj da mojsan: Been ni guin, rüjngajquixan. ");
INSERT INTO zasNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Chi biguiejn Jesús zian, dád badxa lojman ni rëb suldad guin, abiꞌ badxiꞌ lojman loj gra ree bén zinal laaman, rëbaman: ―Diidxliczi rnin, niꞌqui Israel ad wadxaaglojtan tijb bén rliladx daꞌt Dios ziꞌc rliladx xin guin Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Chi badxin ree xin guxhaal suldad rniabee guin lidxix, baguiaa reex ma bayajc mojs guin. ");
INSERT INTO zasNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chi gudëd gojc zian, wej Jesús tijb luguiedx la Naín binë ree xbejnman, në zien ree ben ren. ");
INSERT INTO zasNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Chi bidxinman gajxh roꞌ guiedx guin, baguiaaman ziquieꞌch reeman tijb xingüt, tijbzi laax na̱j xiꞌn xniaax, najman bén bizëjb. Zien daꞌt ree bénluguiedx guin zinal laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Chi baguiaa Dad Jesús laaman, bayaman laaman, dxel rëbaman lojman: ―Ad roonl. ");
INSERT INTO zasNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Abiꞌ bibig Jesús baquiꞌman xcaj xingüt guin, dxel guzudxe ree bén zinë laax. Zianz rëbaman lojx: ―Xiꞌn, naj rni lojl: ¡Bixche! ");
INSERT INTO zasNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Dxel gureli xin guin, guzuloj caneex, zianz bayü Jesús laax loj xniaax. ");
INSERT INTO zasNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Chi baguiaa reeman zian, graczi reeman bidxeb guzuloj cuzaꞌt reeman Dios zagdxe, rëb reeman: ―Du loj ree ma gules Dios tijb bén zojbloj, bén rudëë xtiidx Dios loj ree bejn. Rëb tëë reeman: ―Ma biꞌt Dios din gagnë ree xbejnman. ");
INSERT INTO zasNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Abiꞌ guidib niz Judea në ree guiedx rigaꞌ niz yagaj gogbee ree bejn ni been Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Gogbee Waj gra ree ni cayüjn Jesús, guial bagojn ree xbejnman laaman. Abiꞌ guneeman tioꞌp reeman, ");
INSERT INTO zasNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","dxel guxhaalaman laa reeman loj Jesús din chignabdiidx reeman bal laacaman na̱j Cristo bén na̱j diidx guiꞌt, bén cabëz reeman, o cwëz reeman ben ren ya. ");
INSERT INTO zasNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Abiꞌ bibig reeman, guneenë reeman laaman, rëb reeman lojman: ―Waj bén ruroobnijs bejn ree guxhaal dunujn lojl zudganabdiidxan bal lüjcan na̱j Cristo bén na̱j diidx guiꞌt, bén caylëjzan o yalëjzan ben ren ya. ");
INSERT INTO zasNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Hor ziigajc bayüjn Jesús zien daꞌt ree bénragxuu, në ree bén rdoob, nëtëë ree bén yuꞌ xindxab luxdoo, baxhal tëëman loj ree bénlutiaꞌp. ");
INSERT INTO zasNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Dxel badxiꞌ Jesús xtiidx ree bén guxhaal Waj, rëbaman: ―Gol chej, gol chiguiedx loj Waj ni cuguiaadi në ni caguiejndi. Gol güjdx lojman guial ma ruguiaa ree bénlutiaꞌp, ma rajc rza ree bencoj, ma rayajc tëë ree bén goc guialguijdx la lepra, ma riguiejn ree bén nacwaꞌt, guiáad ree bengüt ma baban reeman, abiꞌ ree bénprob ma caguiejn reeman xtiidxzaꞌc Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡Xiquilbaa ree bén ad zucwëëzt chililadx naj! ");
INSERT INTO zasNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Chi baza ree bén guxhaal Waj, guzuloj Jesús caneeman xcwent Waj loj ree bejn, rëbaman: ―¿Chu naladxidi na̱j bén biquiaadi loj yujbidx? ¿Naladxidi ya najman ziꞌc tijb biqui runiib bi? ");
INSERT INTO zasNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿O chu biquiaadi? ¿Tijb bén najcw lajd zagdxe ya? Lëjt ragbee guial bén rajcw ree lajd zagdxe, në ree bén naban zagdxe, lën palas zojb reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Chu biquiaadi? ¿Tijb bén rudëë xtiidx Dios loj ree bejn ya? Per diidxliczi rnin lojdi, biquiaadi tijb bén mazri zojbloj guial loj tijb bén rudëë xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Wajn na̱j bén ruzaꞌt xtiidx Dios, lod rëb: Naj rxhial tijb bén ned lojl, bén güünchaaw xnejzil. ");
INSERT INTO zasNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Rnin lëjt, loj graczi ree bénguidxliuj ad wayut bén rudëë xtiidx Dios loj ree bejn, bén mazri zojbloj guial loj Waj. Per majsi zian, bén ad zojblojt loj xguialrniabee Dios, laaman mazri zojbloj guial loj Waj. ");
INSERT INTO zasNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Gra ree bejn, në ree bén ruquijx impuest bén baroobnijs Waj, chi biguiejn reeman ni rëb Jesús bigniaꞌ reeman guial rüjn Dios ziꞌc rayal. ");
INSERT INTO zasNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Per ree bénfarisew con ree mextr rajc ley ad cwëjbt reeman nuroobnijs Waj laa reeman, zian ad guyënt reeman ni rën Dios par laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Rëb tëë Jesús: ―¿Xhienaag ganin lëjt na̱j ree bén rigaꞌ loj guidxliuj guie yan? ¿Chu na̱j ziꞌc laa reeman? ");
INSERT INTO zasNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Laa reeman na̱j ziꞌc ree xindoo rguijt niz galay luguiedx, abiꞌ rbixdiaj reex rëb loj lasaꞌ reex: “Bacwejdxan par nuyaꞌdi, per ad bayaꞌtidi, badoolan ni naya ree, per ad biintidi.” ");
INSERT INTO zasNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Din biꞌt Waj bén baroobnijs bejn ree, ad rawtaman ad rëꞌ tëëtaman vin, abiꞌ rëbidi xindxab yuꞌ luxdooman. ");
INSERT INTO zasNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yan biꞌt Bén guxhaal Dios, rawaman rëꞌ tëëman vin, abiꞌ rëbidi guial dád nalaman ruladxaman guiëꞌman, ruchajg tëëman béndol ree con ree bén ruquijx impuest. ");
INSERT INTO zasNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Per xguialrigniaꞌ Dios, rguienan por ree xbejnman. ");
INSERT INTO zasNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tijb bénfarisew rëb loj Jesús din chitaw Jesús guin lidxaman. Abiꞌ bidxinman lidxaman gurejman xan mex. ");
INSERT INTO zasNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Dxel tijb béngunaa dxuudx zojb gajc luguiedx guin. Chi gogbeeman cayaw Jesús lidx bénfarisew guin, bidxinnëman tijb lumejt yuꞌ perfum. ");
INSERT INTO zasNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Dxel roonman gurejman lod nuzuj guiaꞌ Jesús, guzuloj caxhieꞌ nijs carii lojman guiaꞌ Jesús. Abiꞌ cucwiidxnë guidxguijcaman laan, cayawaman xid guiaꞌman curoob tëëman laan perfum guin. ");
INSERT INTO zasNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Chi baguiaa bénfarisew guin zian, beenman xgab: “Balgui zian wali bén guin najman bén rudëë xtiidx Dios loj ree bejn, zagbeeman chunin cuquiꞌ laaman xhie tëë naag naban béngunaa guin, najman bendxuudx.” ");
INSERT INTO zasNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Dxel rëb Jesús loj bénfarisew guin: ―Simón, yuꞌ tijb ni ganin lüj. Badxiꞌ bénfarisew guinan rëbaman: ―Gunan, mextr. ");
INSERT INTO zasNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Abiꞌ rëb Jesús lojman: ―Tijb bén rudëëd milia rguiꞌn ree bejn, ral tioꞌp ree bejn lojman. Tijbaman nuzëëb gaaygayuu denario, zatijbaman nuzëëb tüꞌpchiin. ");
INSERT INTO zasNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Grop reeman ad beent gan naguijx lojman, per bén badëëd milia guin rëbaman loj reeman guial ad zaguijxt reeman ni nuzëëb reeman. Yan guna, ¿chu loj grop reeman mazt guiën laaman? ");
INSERT INTO zasNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Badxiꞌ Simón laan, rëbaman: ―Par naj, bén bazëëb mazri zroꞌ guin. Dxel rëb Jesús: ―Waliquil. ");
INSERT INTO zasNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Zianz baguiaa Jesús loj béngunaa guin, abiꞌ rëbaman loj Simón: ―¿Ruguiaal béngunaa guie ya? Chi guyuꞌn lidxil ad baneetil nijs niëd guiaꞌn. Guiáad laaman gudiibaman guiaꞌn con nijs brii lojman, abiꞌ bacwiidxaman laan con guidxguijcaman. ");
INSERT INTO zasNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ad gudawtil naj xid, guiáad laaman diizd chi guyuꞌn ad rbëzt rawaman xid guiaꞌn. ");
INSERT INTO zasNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Achet sejt badxeꞌl guican, per laaman ma badxeꞌman perfum guiaꞌn. ");
INSERT INTO zasNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Zeel rnin lüj, gra ree xtolaman ma gojc perdon guial rën daꞌtaman naj. Per bén yuꞌ taꞌnz xtol abiꞌ rajcaman perdon, taꞌnz rënman naj. ");
INSERT INTO zasNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Dxel rëb Jesús loj béngunaa guin: ―Ma na̱j gra xtolil perdon. ");
INSERT INTO zasNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Guiáad ree bén zojbnëman yagaj guzuloj canabdiidx loj lasaꞌ reeman, rëb reeman: ―¿Chu bén guin zeel xt në ree dol rüjnman perdon? ");
INSERT INTO zasNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Per rëb Jesús loj béngunaa guin: ―Ma najl perdon guial rliladxil naj, baguiaj zagdxe ad ruril xgab. ");
INSERT INTO zasNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Chi gudëd gojc zian, wej Jesús gra ree guiedx naroob në ree guiedx dobëz bicojnman biglüü tëëman xhienaag na̱j xguialrniabee Dios. Në guidxiptioꞌp ree apóstoles binëman, ");
INSERT INTO zasNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","nëtëë tioꞌp choon ree béngunaa, bén babëëman xindxab luxdoo, në ree bén bayüjnman guialguijdx ni rajc reeman. Loj reeman noꞌch María Magdalena, bén babëë Jesús gajdx xindxab luxdoo. ");
INSERT INTO zasNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Në Xuan, lacheel Cuza, Cuza guin goc bén nulen xchiin Herodes. Në Susan nëtëë zien ree béngunaa ren, been reeman yudar Jesús con ni rajp reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Zien ree bejn brii loj ree guiedx ziquiaa reeman Jesús. Chi bidoꞌp ree benzien, beman tijb cwent loj reeman rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Tijb bejn zëman zigtieꞌchaman bin. Chi catieꞌchaman laan, taꞌnan biajb lunejz abiꞌ balëë ree bejn guijcan gudaw tëë ree biguijn laan. ");
INSERT INTO zasNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Zataꞌnan biajb loj ree guiaj, chi gulejn reen gubidx reen guial ad yuꞌ xcojpt loj ree guiaj guin. ");
INSERT INTO zasNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Zataꞌnan biajb loj ree yaquiëjch. Abiꞌ chi guniꞌs reen tijbzi, banidloj yaquiëjch guin laa reen. ");
INSERT INTO zasNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Zataꞌnan biajb loj yujzaꞌc abiꞌ dád gojcan, cwa xt tibgayuu bin loj tijbgajn. Chi gulox gunee Jesús zian, dxel guneeman rejs rëbaman: ―Bén rën gucaagdiajg, gol bacaagdiajg. ");
INSERT INTO zasNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Dxel gunabdiidx ree xbejn Jesús lojman, rëb reeman: ―¿Xhie rën guiëb cwent guin? ");
INSERT INTO zasNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Badxiꞌ Jesús laan rëbaman: ―Lëjt, Dios ma basaꞌn lëjt din chigniaꞌdi xhienaag na̱j xguialrniabeeman. Per loj gra reeman rünan ziꞌc cwent din majsi rani loj reeman, per ad zuguiaat reeman, majsi riguiejn reeman, per ad zigniaꞌt reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Ni ne rën guiëb xcwent bén rtieꞌch bin: Bin guin na̱j ziꞌc xtiidx Dios, ");
INSERT INTO zasNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","guiáad bin biajb runejz na̱j ziꞌc ree bén riguiejn xtiidx Dios; per rdxin gajc xindxab rquiedix laan luxdoo reeman chitëë chililadx reeman laan abiꞌ gac reeman perdon. ");
INSERT INTO zasNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Guiáad bin biajb loj ree guiaj, na̱j ziꞌc ree bén riguiejn xtiidx Dios, abiꞌ dád nix ru luxdoo reeman riguiejn reeman laan, per guial na̱j reeman ziꞌc cwaan ni ad yuꞌt liuj, rliladx reeman laan tibladëd abiꞌ chi rzagdiaj reeman laa rusaꞌn gajc reeman ni rliladx reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Guiáadza bin biajb loj ree yaquiëjch, na̱j ziꞌc ree bén riguiejn xtiidx Dios; per ru reeman xgab por gra ree guialnazaꞌc rigaꞌ loj guidxliuj guie rüjn tëë reeman ni rëntzi reeman, abiꞌ zianz rucwëëz rucaagdiajg reeman xtiidx Dios ad rüjn tëët reeman ni rënman. ");
INSERT INTO zasNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Guiáad bin biajb loj yujzaꞌc, laan na̱j ziꞌc ree bén rucaagdiajg xtiidx Dios, rucaagdiajg reeman laan con guidib luxdoo reeman zaꞌdxiꞌch tëë reeman loj xnejzaman, zianczi rüjn reeman ni rënman. ");
INSERT INTO zasNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Achut bén ruzeꞌc tijb guij dxel rutaꞌcwaman laan, ad rudxeꞌ tëëtaman laan xan lon, ruzujman laan ya din gusnin loj ree bén chuꞌ lënü. ");
INSERT INTO zasNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Achet ni naguieꞌch yuꞌ ni ad zaguient ad yuꞌ tëët ni ralan ni ad zagbeet bejn, zadxin dxej gagbee bejn laan. ");
INSERT INTO zasNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Zeel gol bacaagdiajg zagdxe, bén ma rigniaꞌ gusnuu chigniaꞌman mazri, per bén ad rigniaꞌt, xt taꞌn ni naladxaman rigniaꞌman ad zigniaꞌtraman. ");
INSERT INTO zasNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Xniaa Jesús con ree bijchaman bidxin reeman lod zaꞌman, per ad gojct nibig reeman lojman guial dád zien bejn rigaꞌ. ");
INSERT INTO zasNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Abiꞌ yuꞌ bén bagojn Jesús rëbaman: ―Laa xniaal con ree bijchil zaꞌ luleꞌ guin rën reeman guinieenë reeman lüj. ");
INSERT INTO zasNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Badxiꞌ Jesús laan rëbaman: ―Bén rucaagdiajg ree xtiidx Dios rüjn tëë reeman ziꞌc rënman, laa reeman na̱j da nan laa tëë reeman na̱j da bichan. ");
INSERT INTO zasNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tijb dxej guyu Jesús loj barcw con ree xbejnman, abiꞌ rëbaman loj reeman: ―Yoꞌ ree zatiblad roꞌ nijs guin. Zianz zë reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Laꞌtgaj cadëd reeman loj nijs guin, goodyëjs Jesús. Dxel guzuloj cabiꞌ bidoxh loj nijs guin, abiꞌ cadxa nijs loj barcw guin, ma cazëëbczi barcw guin xan nijs. ");
INSERT INTO zasNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Dxel bacwëën reeman Jesús, rëb reeman: ―¡Mextr! ¡Mextr! ¡Ma cayzëëb ree xan nijs! Abiꞌ bixche Jesús gunabeeman bacwëëz bidoxh guin në xtüjp nijs guin, zianz gulëjz reen dxel bayajcdxe. ");
INSERT INTO zasNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Abiꞌ rëbaman loj reeman: ―¿Conza xguialrliladxidi? Per laa reeman dád bidxeb reeman badxa tëë loj reeman, abiꞌ canabdiidx loj lasaꞌ reeman rëb reeman: ―¿Chu bén guin zeel rniabeeman bi në nijs, abiꞌ ruzoob reen xtiidxaman? ");
INSERT INTO zasNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Dxel badxin Jesús con ree xbejnman xdajn ree bén Gadara, ni rigaꞌ zatiblad roꞌ nijs Galilea. ");
INSERT INTO zasNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Chi barii Jesús loj barcw guin, bibig tijb xin luguiedx guin lojman. Ma gojc xchej daꞌt yuꞌ xindxab luxdoox. Ad rajcwt xabix, ad nabantix lënü, ganaxzi roꞌ ree baa nabanx. ");
INSERT INTO zasNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Chi baguiaax Jesús bazuxibix lojman, guneex rejs rëbix: ―¿Xhie rënl con naj, Jesús, Xiꞌn Dios yuꞌ xanyabaa? Rniaaban lojl ad gusagzil naj. ");
INSERT INTO zasNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Rëbix zian guial ma canabee Jesús din yarii xindxab guin luxdoox. Ma gojc xchej naaz xindxab guin laax. Abiꞌ ma guxhii ree bejn yaax në guiaꞌx con caden chitëë ban chex, per rutüguiaꞌgajquix caden guin abiꞌ rulaagdxa xindxab guin laax niz lod achut bejn zojb. ");
INSERT INTO zasNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Gunabdiidx Jesús lojx rëbaman: ―¿Chu lal? Badxiꞌxan rëbix: ―Legión lan. Rëbix zian guial zien daꞌt ree xindxab yuꞌ luxdoox. ");
INSERT INTO zasNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Rëb ree xindxab guin loj Jesús chitëë guixhiaalaman laa reex gabijl. ");
INSERT INTO zasNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Dajn guin rigaꞌ zien ree cüch cayaw reeb. Zeel rëb ree xindxab guin lojman din gudëëman mod chuꞌ reex lën ree cüch guin, dxel cwëjbaman. ");
INSERT INTO zasNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Zianz barii reex luxdoox bayu reex lën ree cüch guin, abiꞌ guzuloj cuxüün reeb zianz bitidiaꞌ reeb roꞌ balaꞌ xt loj nijs, lod guꞌ reeb nijs abiꞌ güjt reeb. ");
INSERT INTO zasNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Chi baguiaa ree bén cayajp ree cüch guin ni goc, baxüün reeman bicojn reeman bejn ree luguiedx në ree dajn. ");
INSERT INTO zasNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Dxel wej reeman biquiaa reeman ni goc. Chi bidxin reeman lod zaꞌ Jesús, baguiaa reeman xin barii xindxab guin ree luxdoo, zojbix guiaꞌman ma najcw xabix, ma badëdguienx abiꞌ bidxeb reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Guiáad ree bén baguiaa ni goc, be reeman diidx loj reeman xhienaag bayajquix. ");
INSERT INTO zasNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Graczi ree bén zojb Gadara gunab loj Jesús din yazaman yagaj guial dád rdxeb reeman. Dxel bayëꞌpaman loj tijb barcw, ziataman. ");
INSERT INTO zasNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Guiáad xin barii xindxab guin ree luxdoo rëbix lojman din chinalix laaman, per ad cwëjbtaman, rëbaman lojx: ");
INSERT INTO zasNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Baguiaj lidxil, biguiedx graczi ni been Dios por lüj. Dxel ziax luguiedx guin abiꞌ bex diidx loj gra ree bejn ni been Jesús por laax. ");
INSERT INTO zasNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Chi badxin Jesús zatiblad roꞌ nijs guin, dád rabaa gra ree bén zaꞌ yagaj guial badxinman din mal cabëz reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Dxel bidxin bén la Jairo, laaman rniabee lën tijb xyadoo ree bén Israel. Bazuxibaman loj Jesús, rëbaman lojman din cheman lidxaman, ");
INSERT INTO zasNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","guial yuꞌ tijb xiꞌnman biin chiptioꞌp ijz, ma guiëtczim. Chi zë Jesús dád zien ree bejn zinal laaman xt rixaꞌt reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Abiꞌ tijb béngunaa noꞌch loj reeman, ma gojc chiptioꞌp ijz ragxuuman ryajbaman rejn. Ma banijtaman graczi ni rajpaman guial wejman loj ree doctor, per niꞌqui tijbaman ad gojct nayüjn laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Bibigaman niz xijch Jesús abiꞌ bagaalaman guiaꞌ xabaman. Loj hor ziigajc bayajcaman. ");
INSERT INTO zasNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Dxel gunabdiidx Jesús rëbaman: ―¿Chu baquiꞌ naj? Abiꞌ graczi reeman rëb guial ad laat reeman baquiꞌ laaman. Zianz rëb Bëd loj Jesús: ―Mextr, graczi ree bejn xt rixaꞌt reeman lüj cucadxaa tëë reeman lüj, abiꞌ rniabdiidxil chu baquiꞌ lüj. ");
INSERT INTO zasNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Per rëb Jesús zatijb: ―Yuꞌ chu baquiꞌ naj din gogbeen yuꞌ tijb bén ma bayajc con da guialrniabeen. ");
INSERT INTO zasNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Chi gogbee béngunaa guin guial ma gogbee gajc Jesús ni beenman, guidib rnijman bigzuxibaman loj Jesús. Dxel rëbaman lojman guidibloj ree bén guin chexc zeel baquiꞌman xabaman abiꞌ loj hor guin gajc bayajcaman. ");
INSERT INTO zasNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Dxel rëb Jesús lojman: ―Xiꞌn, ma bayajquil guial bililadxil naj, baguiaj zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Sta caneenë Jesús béngunaa guin, chi bidxin tijb bén guza lidx Jairo, bén rniabee lën xyadoo ree bén Israel, rëbaman loj Jairo: ―Mal güjt xiꞌnl, ad ruslenril Mextr guin. ");
INSERT INTO zasNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Per chi biguiejn Jesús zian, rëbaman loj Jairo: ―Ad rdxebil, bililadxzi, zayajcqui xiꞌnl. ");
INSERT INTO zasNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Chi bidxin reeman lidxaman, ad cwëjbt Jesús niu ree ben ren, Bëdzi con Waj, con Jacob, con ree xdad xniaa bindo guin. ");
INSERT INTO zasNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Graczi ree bén rigaꞌ yagaj cayoon, yuꞌnaya tëë reeman por laam. Per rëb Jesús loj reeman: ―Ad roondi, ad güjttim, nagaꞌyëjszim. ");
INSERT INTO zasNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Graczi reeman bazeꞌ laaman guial ma ragbee reeman güjtim. ");
INSERT INTO zasNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Dxel gunaaz Jesús yaam, guneeman rejs, rëbaman: ―Bindoo, bixche. ");
INSERT INTO zasNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Loj hor ziigajc babanm, bixchem. Dxel gunabee Jesús badëëd reeman ni gudawim. ");
INSERT INTO zasNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Dád badxa loj ree xdadim, per rëb Jesús loj reeman achu loj guiëb reeman ni goc. ");
INSERT INTO zasNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Gurejdx Jesús guidxiptioꞌp ree xbejnman, abiꞌ badëëman guialrniabee loj reeman din yabëë reeman graloj xindxab luxdoo ree bejn yayüjn tëë reeman bénragxuu ree. ");
INSERT INTO zasNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Guxhaalaman laa reeman chiglüü reeman xhienaag na̱j xguialrniabee Dios, yayüjn tëë reeman bénragxuu ree. ");
INSERT INTO zasNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Rëbaman: ―Ad chinëdi xhienin par runejz: niꞌqui yagrliadxidi, niꞌqui guijxh, niꞌqui guialraw, niꞌqui milia, niꞌqui stibnejz xabidi. ");
INSERT INTO zasNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Chutëëz lidx guidxindi, tib gol bayaꞌnzi xt chi yazadi luguiedx guin. ");
INSERT INTO zasNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bal yuꞌ guiedx lod ad rënt reeman lëjt, gol baza yagaj, gol gudxijp guxyuj guiaꞌdi ziꞌc tijb sen guial ad rënt reeman guzoob reeman xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Dxel brii reeman zë reeman tijbgaj guiedx zigtieꞌch reeman xtiidxzaꞌc Dios, rayüjn tëë reeman bénragxuu ree. ");
INSERT INTO zasNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Chi gogbee rey Herodes graczi ni cayüjn Jesús. Guyunawëëgaman guial yuꞌ ree bejn rëb, Waj bén baroobnijs bejn ree ma baban, ");
INSERT INTO zasNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","yuꞌ tëë reeman rëb Elíasan bén badëë xtiidx Dios loj ree bejn ma balüüloj, yuꞌza reeman rëb, tijb ree bén badëë xtiidx Dios loj ree bejn gocli ma baban. ");
INSERT INTO zasNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Per rëb Herodes: ―Naj gajc gunabee biruꞌ yëjn Waj. ¿Chuza bénan riguiejnan ruzaꞌt ree bejn xcwent ni cayüjnman? Zianan zeel rüjn Herodes naguiejn guguiaaman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Chi badxin ree xi apóstoles Jesús, be reeman graczi ni biguieen reeman. Dxel binëman laa reeman lod achutczi bejn zojb, gajxh guiedx Betsaida. ");
INSERT INTO zasNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Per chi gogbee ree bejn, dxel zinal reeman laaman lod zëman. Abiꞌ balüüman laa reeman xcwent xguialrniabee Dios bayüjn tëëman bénragxuu ree. ");
INSERT INTO zasNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Chi ma cadxe, bibig guidxiptioꞌp ree apóstoles lojman rëb reeman: ―Güjdx loj gra ree bén guin din yaguiaj reeman chitiil lod yayaꞌn reeman luguiedx doo ree në ree ranch, chitiil tëë ni gaw reeman din lod nadxuꞌ ree achetczi yuꞌ. ");
INSERT INTO zasNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Dxel rëbaman loj reeman: ―Lëjt gajc gol badëëd ni gaw reeman. Abiꞌ rëb reeman: ―Per gaayzi guiadxtil nacaꞌn con zatioꞌp bëjl, bajtëë bal yoꞌn yusiin ni gaw gra reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Abiꞌ cost gaay mil ree xinguiaaw rigaꞌ yagaj. Per rëb Jesús loj ree xbejnman: ―Gol güjdx loj reeman din cwe tüꞌpchii gaj reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Abiꞌ bagojn reeman laa reeman persi gurej gra reeman zian. ");
INSERT INTO zasNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Dxel cwaꞌman guigaay guiadxtil guin con zatioꞌp bëjl guin. Gules lojman xanyabaa, badëëman quixtëë loj Dios, zianz gulaꞌman laa reen badëëman loj ree xbejnman din quiꞌs reeman laan loj ree bén guin. ");
INSERT INTO zasNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Graczi reeman gudaw xt bigdxinladx reeman. Abiꞌ batoꞌp reeman chiptioꞌp dxüm nilaay bayaꞌn. ");
INSERT INTO zasNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tijb dxej cabejdx canab Jesús Dios, zaꞌnë ganaxzi ree xbejnman. Gunabdiidxaman loj reeman, rëbaman: ―¿Chu rëb ree bejn najn? ");
INSERT INTO zasNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Badxiꞌ reeman laan rëb reeman: ―Yuꞌ reeman rëb lüj na̱j Waj bén baroobnijs bejn ree, yuꞌza reeman rëb lüj na̱j Elías bén badëë xtiidx Dios loj ree bejn, yuꞌ tëë reeman rëb lüj na̱j tijb ree bén badëë xtiidx Dios loj ree bejn gocli, bén ma baban. ");
INSERT INTO zasNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Dxel gunabdiidx Jesús zatijb, rëbaman: ―Laadx lëjt, ¿xhie nadi chu najn? Badxiꞌ Bëdan rëbaman: ―Lüj na̱j Cristo. Lüj na̱j Xiꞌn Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Rëb Jesús loj reeman achuczi loj guiëb reeman zian, ");
INSERT INTO zasNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","rëb tëëman: ―Rayal sagdiaj Bén guxhaal Dios: ad zënt ree guxtis Israel laaman, niꞌqui ree bixhioz rniabee ree bixhioz, niꞌqui ree mextr rajc ley. Gugüjt reeman laaman, per ni yayon dxej yabanman. ");
INSERT INTO zasNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Dxel rëbaman loj gra reeman: ―Bal chu rën gac da bejnan ad rayalt güünman ziꞌc na̱j xixgabaman, siibnejzaman guialzi ni tëdzaman guixie guixie abiꞌ guidnalaman naj. ");
INSERT INTO zasNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Din bén mazri rën guialnaban ni rajpaman loj guidxliuj guie, zadxin dxej gusëëbaman laan, per bén guiët por naj, zajpaman guialnaban tiblayaa con Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Xhie gan güün bejn gapaman gra ni yuꞌ loj guidxliuj abiꞌ nitaman loj Dios? ");
INSERT INTO zasNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Bal chu ratu guzaꞌt naj në da diidxan, ziangajc naj najn Bén guxhaal Dios, yatunëꞌn laaman chi guialan con da guialrniabeen loj xbiani da Dadan nëtëë loj xbiani ree xianjlaman. ");
INSERT INTO zasNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Per diidxliczi rnin lojdi, yuꞌ ree bén zaꞌ guie ad zëjtt xt guguiaa reeman xguialrniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Chi gudëd cost xhujn dxej ni gunee Jesús diidx guin ree, wejman persi gurejdx gunabaman Dios tijb guijc guiaꞌ, binëman Bëd con Waj con Jacob. ");
INSERT INTO zasNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Laꞌtgaj cabejdx canabaman Dios, bidxaa lojman guiáad xabaman gojcan naquichbëj bidiin tëën bachaꞌ. ");
INSERT INTO zasNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Dxejczi gulentie tioꞌp ree bejn, caneenë reeman laaman. Tijbaman na̱j Moisejs zatijbaman na̱j Elías. ");
INSERT INTO zasNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yuꞌ reeman galay biani cayü reeman diidx guial guiët Jesús Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Majsi yuꞌ bacaal loj Bëd në loj ree xcompniaraman, batieꞌch xbacaal reeman persi baguiaa reeman xbiani Jesús con zatioꞌp ree bén zaꞌnëman. ");
INSERT INTO zasNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Chi ma baza ree bén caneenë Jesús, rëb Bëd lojman: ―Mextr, ¡zagdxen nadxuꞌ ree guie! Zajc yaguieenan choon ranch, tijban par lüj, tijban par Moisejs zatijban par Elías. Per ad ragbeet Bëd xhienin caneeman. ");
INSERT INTO zasNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Laꞌtgaj caneeman zian, biguiajt tijb za̱j xt guijc reeman, chi ma yuꞌ reeman lën za̱j guin dád bidxeb reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Dxel loj za̱j guin biguien chaꞌ bejn, rëbaman: ―Bén guie na̱j da Xiꞌnan bén rën daꞌtan. Gol bacaagdiajg xtiidxaman. ");
INSERT INTO zasNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Chi gulox biguien chaꞌman loj za̱j guin, baguiaa reeman xtijbzi Jesús zaꞌman. Abiꞌ ad gutieꞌcht reeman diidx. Lën ree dxej zii achutczi loj rëb reeman ni baguiaa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Bareguiaal, chi baguiajt reeman guijc guiaꞌ guin, dád benzien brii bigchaagloj Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Abiꞌ tijb bén noꞌch loj reeman guridxaꞌ, rëbaman lojman: ―¡Mextr!, been wen baguiaa da xiꞌnan din tijbzi laax raꞌpan. ");
INSERT INTO zasNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Tijb xindxab ru luxdoox abiꞌ rucwixdiajx laax, rugüjtyaꞌx laax rbëë tëëx bichijn roꞌx. Dád rusagdiajx laax ad rëntix guslaax laax. ");
INSERT INTO zasNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ma gunaaban loj ree xbejnl din nabëë reeman xindxab guin, per ad gojct reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Badxiꞌ Jesús laan rëbaman: ―¡Benguijdx, bén ad rliladxt! ¿Xt goc gazunëꞌn lëjt gadaan tëën lëjt? Tanë xiꞌnl guie. ");
INSERT INTO zasNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Chi cabig xin guin basajb xindxab guin laax luyuj, bagüjtyaꞌx laax zatijb. Per gunabee Jesús barii xindxab guin, bayüjnman laax dxel bayüman laax loj xdadix. ");
INSERT INTO zasNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Graczi reeman badxaloj guialrniabee ni rajp Dios. Laꞌtgaj caydxa loj reeman ni cayüjn Jesús, rëbaman loj ree xbejnman: ");
INSERT INTO zasNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Gol bacaagdiajgchaaw ni ganin lëjt: yayü reeman Bén guxhaal Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Per laa reeman ad bigniaꞌt reeman ni rnieeman guial ad badëëtaman mod nigniaꞌ reeman, abiꞌ bidxeb reeman niniabdiidx reeman lojman xhie rën guiëb ni rëbaman. ");
INSERT INTO zasNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Dxel guzuloj ree xbejnman rëb loj lasaꞌ reeman chu loj gra reeman mazri zojbloj. ");
INSERT INTO zasNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Per gogbee Jesús xgab ni cayüjn reeman abiꞌ cwaꞌman tijb xindoo, bazujman laax cwëꞌman, ");
INSERT INTO zasNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","dxel rëbaman loj reeman: ―Bén ridxgaꞌ tijb xindoo por naj, najn ridxgaꞌman, guiáad bén ridxgaꞌ naj, bén guxhaal najn ridxgaꞌman. Din bén rüjn sirv lojdi, laaman mazri zojbloj lojdi. ");
INSERT INTO zasNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Rëb Waj loj Jesús: ―Mextr, baguiaan tijb bejn rabëëman xindxab luxdoo ree bejn por xguialrniabeel. Per badxoonan guial ad najtaman dux bejn ree. ");
INSERT INTO zasNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Per rëb Jesús lojman: ―Ad rudxoondi, din bén ad zaꞌt contr dunuj ree, zaꞌman con dunuj ree. ");
INSERT INTO zasNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Chi ma cadxin dxej yayëꞌp Jesús xanyabaa, dxel beenman xgab guial rüjn naguiejn cheman Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Guxhaalaman bén guned ree, wej reeman tijb guiedxdo nulen Samaria bitiil reeman lod yayaꞌn reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Per ad cwëjbt ree bén Samaria guin nudëëd reeman lod nayaꞌnman guial gogbee reeman cheman Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Chi baguiaa Waj con Jacob zian, rëb reeman lojman: ―Dad, ¿rënl ya yanabeen guiat bajl xanyabaa din gunijtan bén guin ree ziꞌc been Elías bén badëë xtiidx Dios loj ree bejn? ");
INSERT INTO zasNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Dxel badxiꞌ loj Jesús loj reeman, abiꞌ gudilëman laa reeman rëbaman: ―¿Nid ragbeedi ya guial loj xindxab zëëd ni rnieedi? ");
INSERT INTO zasNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Naj, Bén guxhaal Dios, ad zialtan din gunijtan xguialnaban bejn loj Dios, zialan din yabën laa reeman loj dol. Dxel zë reeman zatijb guiedx. ");
INSERT INTO zasNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Chi zë reeman lunejz, tijb bejn rëb loj Jesús: ―Dad, rënan guidnaalan lüj bantëëz guin chel. ");
INSERT INTO zasNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Badxiꞌ Jesús laan rëbaman: ―Cuyojt ree yuꞌ xguiajbiliaa reeb guiáad ree biguijn yuꞌ xguixbitiaꞌs reeb. Per Bén guxhaal Dios niꞌqui lod quixh guijcaman ad yuꞌt. ");
INSERT INTO zasNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Rëb Jesús loj ben ren: ―Tanal naj. Per badxiꞌman laan rëbaman: ―Dad, banee mod gabenëꞌ da Dadan xt chi guiëtaman. ");
INSERT INTO zasNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Abiꞌ rëb Jesús lojman: ―Basaꞌn xdadil con ree bén ad rënt guidnal naj, laa reeman guquieꞌch laaman. Saꞌn lüj bigtieꞌch diidx xhienaag na̱j xguialrniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Dxel rëb zatijb bén guin: ―Dad, rënan guidnaalan lüj, per yalojxgaj banee mod chigzadiidxnëꞌ ree da familan. ");
INSERT INTO zasNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Per rëb Jesús: ―Bén guiniaaz guiaꞌ garad abiꞌ gudxiꞌ lojman niz xijchaman, ad zileꞌt guiliaꞌman yuj zagdxe. Ziangajc bén rën guidnal naj, bal id zusaꞌnman graczi tiblad ad zileꞌt chuꞌman loj xguialrniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chi gudëd gojc ree ni guin, gulej Dad Jesús gayojnchii bejn, abiꞌ guxhaalaman tioꞌp gaj reeman luguiedx ree në ree ranch din ned reeman che gaj reeman lod na̱j cheman. ");
INSERT INTO zasNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Rëbaman loj reeman: ―Diidxliczi, zien bejn rën gucaagdiajg xtiidx Dios, per ad zient bén gulüü laa reeman yuꞌ. Zeel gol gurejdx gunab Dios din guixhiaalaman mazri zien bén gulüü laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Gol chej, naj rxhial lëjt ziꞌc rej ree xiil galay ree cuyojt. ");
INSERT INTO zasNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ad chinëdi guijxh, niꞌqui milia, niꞌqui zatib nejz xgurëchidi, ad sudxedi guinieenëdi bejn ree runejz. ");
INSERT INTO zasNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Bantëëz lënü chuꞌdi, yalojxgaj gol güjdx: “Dios yabeꞌcdxe luxdoodi.” ");
INSERT INTO zasNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Abiꞌ bal lënüzii yuꞌ ree bén rayal guialnazaꞌc guin, zayaꞌnan yagaj. Guiáad bal id rayal reeman laan zayejcan con lëjt. ");
INSERT INTO zasNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yagaj gol bayaꞌn, gol gudaw, gol guꞌ ni gunee reeman. Din bén rüjn dxiin rayal gaxaman. Yagajzi gol bayaꞌn ad bal yayaꞌndi lood ren. ");
INSERT INTO zasNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Chi guidxindi tijb guiedx lod yacaꞌ reeman lëjt, gol gudaw ni gunee reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Gol bayüjn ree bénragxuu yuꞌ ree luguiedx guin, gol güjdx tëë loj reeman: “Ma zëëd xguialrniabee Dios gajxh par lëjt.” ");
INSERT INTO zasNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Per bal guidxindi tijb guiedx lod ad rënt reeman yacaꞌ reeman lëjt, gol brii lunejz, gol güjdx loj reeman: ");
INSERT INTO zasNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Xt xgoxyuj ladxidi ni cwa du guiaꞌn, radxijpan ziꞌc tijb sen guial ad bidxgaꞌtidi dux tiidxan. Per gol gogbee, guial ma zëëd xguialrniabee Dios gajxh par lëjt.” ");
INSERT INTO zasNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Naj rni lëjt guial dxej yadëëd ree bejn cwent loj Dios, mazri casti naroob yayal reeman guial loj ree bén gure guiedx Sodoma. ");
INSERT INTO zasNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Rëb tëë Jesús: ―¡Probza lëjt bén Corazín! ¡Probza lëjt bén Betsaida! Din bal guiedx Tiro në guiedx Sidón niajc gra ree milagr ni goc ladxidi, diizd gocli nayüjn reeman xgab por xtol reeman, niajcw reeman lajd yaꞌs nuroob tëë cobdëj guijc reeman ziꞌc tijb sen guial ma bayüjn reeman xgab por xtol reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Per rnin lojdi guial dxej yadëëd ree bejn cwent loj Dios, mazri casti naroob yayalidi guial loj ree bén Tiro në ree bén Sidón. ");
INSERT INTO zasNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Guiáad lëjt, bén Capernaum, ad naladxidi yayalidi xanyabaa, lëjt yayal gabijl. ");
INSERT INTO zasNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Dxel rëb Jesús loj ree xbejnman: ―Bén ridxgaꞌ lëjt, najn ridxgaꞌman, per bén ad ridxgaꞌt lëjt, najn ad ridxgaꞌtaman. Guiáad bén ad ridxgaꞌt naj, bén guxhaal najn ad ridxgaꞌtaman. ");
INSERT INTO zasNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Chi badxin ree bén gayojnchii guxhaal Jesús, dád rabaa reeman rëb reeman lojman: ―Dad, xt ree xindxab ruzoob dux tiidxan chi razaꞌtan lajl. ");
INSERT INTO zasNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Abiꞌ rëb Jesús loj reeman: ―Waliquidi, naj baguia, ziꞌczi rëꞌp nijs basëëb xguialrniabee xindxab. ");
INSERT INTO zasNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Naj banee lëjt guialrniabee din gulëëdi guijc ree bëël në guijc ree nixüb, në par güündi gan loj xguialrniabee xindxab sin guial güünx lëjt xhienin. ");
INSERT INTO zasNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Per ad rabaadi guial ruzoob ree xindxab guin xtiidxidi, gol babaa guial ca lajdi loj libr yuꞌ xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Loj hor ziigajc babaa daꞌt Jesús por xSprijt Dios, abiꞌ rëbaman: ―Ruzatan lüj zagdxe, Dad, lüj rniabee xanyabaa në loj guidxliuj, din ni baquieꞌchil loj ree bén rajc në loj ree bén rigniaꞌ, laan ma balüül loj ree bén ad rajczaꞌct. Zian gojcan Dad, din zian guyënl. ");
INSERT INTO zasNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Da Dadan banee gra lon. Abiꞌ achut nünbee Jesucrist Xiꞌn Dios, tijbzi Dios, achu tëët nünbee Dios, tijbzi Jesucrist xiꞌnman con ree bén rënman güünbee Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Dxel baguiaaman loj ree xbejnman, abiꞌ rëbaman lojzi reeman: ―Xiquilbaa ree bén guguiaa ni cuguiaadi. ");
INSERT INTO zasNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Din naj rni lojdi, zien ree bén badëë xtiidx Dios loj ree bejn në ree rey guyën nuguiaa ni cuguiaadi, per ad baguiaat reeman laan. Guyën reeman nucaagdiajg reeman ni cucaagdiajguidi, per ad bacaagdiajgt reeman laan. ");
INSERT INTO zasNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tijb mextr rajc ley guzuliman guneenëman Jesús. Abiꞌ din güünman laaman prueb, gunabdiidxaman lojman rëbaman: ―Mextr, ¿xhie rayal günan din gaꞌpan guialnaban tiblayaa con Dios? ");
INSERT INTO zasNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Badxiꞌ Jesús laan rëbaman: ―¿Xhie ca loj ley badëë Dios loj Moisejs? ¿Xhienaag rigniaꞌlan? ");
INSERT INTO zasNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Abiꞌ rëb mextr guin: ―“Guyën xDadil Dios guidib guijc guidib ladxil guyën tëë ben ren ziꞌc rën lüj gajc.” ");
INSERT INTO zasNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Badxiꞌ Jesús laan, rëbaman: ―Zagdxequi badxiꞌlan. Bal güünl zian zajpil guialnaban tiblayaa con Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Per guyën mextr guin nayaꞌnman zagdxe, gunabdiidxaman loj Jesús, rëbaman: ―¿Chu bénan guiënan ziꞌc rën naj gajc? ");
INSERT INTO zasNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Dxel be Jesús tijb cwent lojman, rëbaman: ―Tijb bén Israel briiman Jerusalén zëman guiedx Jericó. Abiꞌ gunaaz ree xingubaan laaman, gudijn reex laaman gulan tëë reex gra ni caꞌman xt në xabaman, basaꞌn reex laaman ma güjtczaman. ");
INSERT INTO zasNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Dxel gudëd tijb bixhioz niz yagaj, per chi baguiaaman bén guin, zijt bicaaman volt, zëtaman. ");
INSERT INTO zasNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Në tijb bén Levita bén rüjn yudar bixhioz ree, gudëd niz yagaj, chi baguiaaman bén guin, zijt bicaaman volt, zëtaman. ");
INSERT INTO zasNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Per tijb bén Samaria gudëd niz yagaj, chi baguiaaman bén guin, bayaman laaman, ");
INSERT INTO zasNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","dxel gubigaman lod nagaꞌman, badxeꞌman sejt con vin lod nadxeelguijdxaman dxel guxhiiman laan con lajd. Zianz badxiibaman laaman xburaman binëman laaman lënü lod rayaꞌn ree bejn. Yagaj gunajman laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Chi bareguiaal, chi ma yaguiaj bén Samaria guin, gulëëman milia xieen tioꞌp dxej dxiin badëëman laan loj bén na̱j lidxan, rëbaman lojman: “Gunaj bén guie, bal gunijtil mazri, naj yaguix laan chi yayeꞌcan.” ");
INSERT INTO zasNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Dxel rëb Jesús loj mextr guin: ―Yan, loj guiyon ree bén guin, ¿chu bénan guyën bén gudin ree xingubaan guin? ");
INSERT INTO zasNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Badxiꞌ mextr guinan rëbaman: ―Bén baya laaman. Dxel rëb Jesús lojman: ―Baguiaj, been ziangajc con ben ren. ");
INSERT INTO zasNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Basnuu Jesús zëman abiꞌ bidxinman tijb guiedxdoo, yagaj wejman lidx tijb biin la Mart. ");
INSERT INTO zasNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Yuꞌ tijb xbëlim lam Li. Gurej Li guin guiaꞌ Jesús cucaagdiajguim ni caneeman. ");
INSERT INTO zasNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Per Mart guin mazri ruquiejnnë gra xmandadim, abiꞌ bibiguim loj Jesús rëbim: ―Dad, ¿nid rul xgab ya guial rusaꞌn da bëlan naj con gra mandad guin? Güjdx lojm din güünm naj yudar. ");
INSERT INTO zasNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Badxiꞌ Jesús laan rëbaman: ―Mart, Mart, dád rul xgab guial yuꞌ daꞌt xmandadil. ");
INSERT INTO zasNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Per tijbzi ni mazri zojbloj yuꞌ. Li gulejm ni mazri zojbloj, abiꞌ achut zajc chiquiedan lojm. ");
INSERT INTO zasNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tijb dxej cabejdx canab Jesús Dios. Abiꞌ chi gulox gurejdx gunabaman Dios, rëb tijb xbejnman lojman: ―Dad, balüü dunujn yarejdx yanaaban Dios, ziꞌc balüü ree xbejn Waj bén baroobnijs bejn ree. ");
INSERT INTO zasNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Abiꞌ rëb Jesús loj reeman: ―Chi cwedx guiniabidi Dios, gol güjdx: Dad, lüj yuꞌ xanyabaa, rayal yayaꞌp daꞌtan lajl respejt. Gac ziꞌc rniabeel. Gac ziꞌc rënl loj guidxliuj, ziꞌc rajc xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Bazaladx ni yadaawan guixie guixie. ");
INSERT INTO zasNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Been dunujn perdon gra ree ni mal ma baguieenan, ziꞌc raguieenan perdon bén rüjn ree dunujn ni mal. Ad tiëbil güün xindxab dunujn gan yaguieenan dol, babëë dunujn loj gra ni mal. ");
INSERT INTO zasNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Abiꞌ rëb Jesús loj reeman: ―Yaguieꞌch ree, tijb lëjt yuꞌ xmiw abiꞌ garol guiaal chedi lidxix, guiëbidi: “Miw, baneesii choon guiadxtil gaguiꞌnan, ");
INSERT INTO zasNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","din biꞌt tijb da miwan abiꞌ achet raꞌpan gudëdan lojx.” ");
INSERT INTO zasNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Dxel nax diizd lënü guin: “Ad ruslenl naj. Ma nayaaw roꞌ da portan. Ma nagaꞌyëꞌsnëꞌ ree da xiꞌnan. Ad zileꞌt chixchejn gunen laa reen.” ");
INSERT INTO zasNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Per rnin lëjt, majsi bal id zixchex din guneex ni ryaadxidi guial rajc xmiwidi laax. Per züjnx naguiejn chixchex din guneex ni ryaadxidi chitëë guslenridi laax. ");
INSERT INTO zasNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Zeel rnin lëjt: Gol gunab loj Dios, laaman gunee ni rniabidi. Gol baguiilaman, zadxejlidi laaman. Gol gurejdx gunabaman, zidxgaꞌman lëjt. ");
INSERT INTO zasNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Din bén rniab, zacaꞌman. Abiꞌ bén rguiil, zadxejlaman guiáad bén rbejdx rniab laaman zidxgaꞌman laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Lëjt najdi dad, wen zudëëdi tijb guiaj loj xiꞌndi ya chi guiniabix guiadxtil?, ¿o zudëëdi tijb bëël ya chi guiniabix bëjl? ");
INSERT INTO zasNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿O zudëëdi nixüb ya chi guiniabix dxijt? ");
INSERT INTO zasNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nacli lëjt najdi béndol rajc rudëëdi ni zagdxe loj xiꞌndi. ¡Diidxgui xDadidi bén yuꞌ xanyabaa, nid zudëë xSprijtaman loj ree bén rniab laaman ya! ");
INSERT INTO zasNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Caybëë Jesús tijb xindxab basaꞌn tijb bejn gop. Abiꞌ chi barii xindxab guin guzuloj canee bén guin. Dxel dád badxaloj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Per yuꞌ reeman rëb: ―Bén guin rabëë xindxab luxdoo ree bejn por xguialrniabee Beelzebú, xin rniabee ree xindxab. ");
INSERT INTO zasNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yuꞌza reeman par güün reeman laaman prueb, rëb reeman lojman din güünman milagr zëëd xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Per Jesús ragbee gajcaman xgab cayüjn reeman, abiꞌ rëbaman: ―Gra nacion bal id nadxag rigaꞌ bejn por wadijl, rliaꞌ lasaꞌ reeman, ziangajc tijb famil bal id nadxag rigaꞌ reeman por wadijl, rliaꞌ lasaꞌ reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ziangajc bal Satanás xin rniabee ree xindxab su contr lasaꞌ xindxab gajquix, nayob nit xguialrniabeex. Canin zian guial rëbidi por xguialrniabee Beelzebú rabën xindxab luxdoo ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Per bal rabën xindxab luxdoo ree bejn por xguialrniabee Beelzebú, ¿chuza rudëëd guialrniabee loj ree xbejndi din yabëë reeman xindxab? Zeel laagajc reeman rulüü guial ad laat rnieedi. ");
INSERT INTO zasNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Per por xguialrniabee Dios rabën xindxab luxdoo ree bejn, laan rën guiëb guial ma zaꞌnë xguialrniabee Dios lëjt. ");
INSERT INTO zasNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Bal tijb béngojl daꞌt caꞌ xguiibaman, rajp lidxaman. Ad zajct cwan bejn ni rajpaman. ");
INSERT INTO zasNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Per bal guidxin bén mazri gojl guial lojman güünman laaman gan abiꞌ chisüdaman guiib ni caꞌman tiaꞌ tëëman gra ni rajpaman. ");
INSERT INTO zasNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Bén ad zaꞌt con naj, zaꞌman contr naj, guiáad bén ad rutoꞌpt bejn par naj rtieꞌchaman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Chi rarii tijb xindxab luxdoo tijb bejn, abiꞌ rza xindxab guin niz loj yujbidx rguiilix lod yaziiladxix. Chi ad rdxejlt lod yaziiladxix, dxel rüjnx xgab naladxix: “Zagdxeli yayeꞌcan lod bariin.” ");
INSERT INTO zasNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Abiꞌ chi rayejquix ruguiaax luxdoo bén guin, najn ziꞌc tijb lënü lod bilioob lod najcchaaw tëë. ");
INSERT INTO zasNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Dxel ricaꞌx zagajdx ree xindxab na̱j mazri xinmal guial lojx. Abiꞌ ru gra reex luxdoo bén guin. Dxel piorli rayaꞌnman guial ziꞌc gocaman yaloj. ");
INSERT INTO zasNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Laꞌtgaj canee Jesús diidx guin ree, gurixdiaj tijb béngunaa noꞌch loj ree benzien guin, rëbaman: ―¡Xiquilbaa béngunaa bazuj lüj loj guidxliuj, bén baslaa tëë lüj! ");
INSERT INTO zasNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Per badxiꞌ Jesús laan rëbaman: ―¡Mazri xiquilbaa ree bén rucaagdiajg xtiidx Dios ruzoob tëë reeman xtiidxaman! ");
INSERT INTO zasNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ziꞌcri cadoꞌp ree bejn lod zaꞌ Jesús, abiꞌ guzuloj rëbaman loj reeman: ―Bén rigaꞌ ree loj guidxliuj yan, na̱j reeman benmal. Abiꞌ rniab reeman tijb milagr, per achet guguiaa reeman, tijbzi ziꞌc guzac Jonás bén badëë xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ziꞌc goc Jonás tijb sen par ree bén gure guiedx Nínive, ziangajc Bén guxhaal Dios najman tijb sen par ree bén naban yan. ");
INSERT INTO zasNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Abiꞌ bén goc reina guiedx Sabá, zabanman chi yadëëd ree bejn cwent loj Dios dxel guiëbaman guial ree bén rigaꞌ yan, yayal reeman xcasti Dios. Din laaman dád zijt guzaman bicaagdiajgaman xguialrajc rey Salomón. Abiꞌ yan, naj zaꞌnëꞌn lëjt, mazri lasajcan guial loj rey Salomón. ");
INSERT INTO zasNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ziangajc ree bén guban guiedx Nínive, zaban reeman chi yadëëd ree bejn cwent loj Dios abiꞌ guiëb reeman guial ree bén rigaꞌ yan, yayal reeman xcasti Dios. Din bén Nínive ree bayejc reeman loj Dios chi bacaagdiajg reeman xtiidxaman ni gunee Jonás. Abiꞌ yan, naj zaꞌnëꞌn lëjt mazri lasajcan guial loj Jonás. ");
INSERT INTO zasNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Achut rucaaguij tijb guij par sun lod naguieꞌch, achu tëët rutaꞌcw laan lën tijb yagalm. Rayal sun lod guiguienan din gusnin loj bén chuꞌ lënü. ");
INSERT INTO zasNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Guiaaloj bejn na̱j ziꞌc tijb biani par xcuerpaman. Bal por ni ruguiaal rüjnl ni zagdxe, guidib xcuerpil na̱j biani. Per bal por ni ruguiaal rüjnl ni mal, guidib xcuerpil na̱j ziꞌc lod nacay. ");
INSERT INTO zasNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gojp cudad chitëë chinë guiaalojl lüj loj nejz mal luar loj nejz zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Abiꞌ bal niꞌqui tibdaꞌn xcuerpil ad rüjnt ni mal, guidibczan gac nayni ziꞌc chi rusni guij con xbachaꞌn. ");
INSERT INTO zasNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Chi gulox guneenë Jesús laa reeman, tijb bénfarisew rëb loj Jesús din chitaw Jesús lidxaman. Chi guyuman, zianz gurejman xan mex. ");
INSERT INTO zasNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Abiꞌ bénfarisew guin badxalojman chi baguiaaman ad banaat Jesús chi ma gawaman ziꞌc na̱j xcostumbr reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Per rëbaman loj reeman: ―Najdi ziꞌc tijb vajs con pliajt ni naya xijch, rguiendi benzaꞌc, per luxdoodi yuꞌ daꞌt guialgubaan në ni mal. ");
INSERT INTO zasNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Bennad! ¿Nid bén been gajc xcuerpidi been luxdoodi ya? ");
INSERT INTO zasNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Zeel gol been yudar bén achet rajp din guiguien guial najquidi benzaꞌc. ");
INSERT INTO zasNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Probza lëjt bénfarisew! Rbëëcadi ni na̱j par Dios, rüjndi chii lalaꞌ ni rajpidi ziꞌc bidxtil në rud në graloj ni rxübindi abiꞌ rudëëdi tijban loj Dios. Per ad rüjntidi ziꞌc rayal ad rën tëëtidi Dios. Gol bidxgaꞌ Dios ad gucwëëz tëë gudëëdi ni rudëëdi lojman. ");
INSERT INTO zasNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Probza lëjt, bénfarisew! guial ruladxidi cwedi lod rbej ree bén zojbloj lën ree yadoo, ruladx tëëdi gugajpdioz ree bejn lëjt zagdxe niz lunejz. ");
INSERT INTO zasNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Probza lëjt, mextr rajc ley në lëjt bénfarisew, bén rusquiee!, din najdi ziꞌc baa ni ad rguient, abiꞌ ad ragbeet ree bejn rëꞌp reeman guijcan. ");
INSERT INTO zasNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Dxel gunee tijb mextr rajc ley, rëbaman loj Jesús: ―Mextr, në dunujn caneeguijdxil guial rëbil zian. ");
INSERT INTO zasNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Badxiꞌ Jesús laan rëbaman: ―¡Ziangajc lëjt mextr rajc ley, probza lëjt!, guial rniabeedi bejn ree güün reeman ni nawëëgdaꞌt abiꞌ rniabeezidi güün bejn zian guiáad lëjt niꞌqui taꞌn ad rüjntidi laa reeman yudar din güün reeman ziꞌc rëndi. ");
INSERT INTO zasNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Probza lëjt!, guial rüjnchaawidi xbaa ree bén badëë xtiidx Dios loj ree bejn, bén bagüjt gajc ree xbéngulalidi. ");
INSERT INTO zasNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Zian ragbee ree bejn guial ruladxidi ni been ree xbéngulalidi. Laa reeman bagüjt ree bén badëë ree xtiidx Dios loj ree bejn, guiáad lëjt rayüjnchaawidi xbaa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Zeel Dios guial ragbeeman gra ni gac, rëbaman: “Gaxhalan bén rudëë ree xtiidx Dios loj ree bejn, në ree apóstoles, yuꞌ reeman gugüjtidi yuꞌ tëë reeman sunalidi din güündi laa reeman xhienin.” ");
INSERT INTO zasNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Abiꞌ bén naban ree yan, laa reeman yadëëd cwent loj Dios por rejn ni guxhieꞌ ree bén badëë xtiidx Dios loj ree bejn, bén güt ree diizd chi goꞌtchaaw guidxliuj, ");
INSERT INTO zasNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","diizd xrejn Abel xt xrejn Zacarías bén bagüjt reeman roꞌ yadooroꞌ Jerusalén. Zeel rnin lëjt guial ree bén naban yan, laa reeman quix por gra reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Probza lëjt, mextr rajc ley!, guial ad rtiëjbtidi chuꞌ ree bejn loj xnejz Dios, niꞌquiza lëjt ad rüjnt naguiejn chuꞌdi loj xnejz Dios abiꞌ rudxoondi chuꞌ ree bejn loj xnejzaman. ");
INSERT INTO zasNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Chi gunee Jesús zian, dád bidxeꞌch ree bénfarisew guin në ree mextr rajc ley. Abiꞌ guzuloj zien ree ni rniabdiidx reeman lojman, ");
INSERT INTO zasNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","din guidoon xhie guiëbaman din chileꞌ gutediaꞌ reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Laꞌtgaj canee Jesús zian, guzuloj cadoꞌp por mil bejn, abiꞌ guial zien daꞌt reeman xt rxaꞌt lasaꞌ reeman. Dxel guzuloj Jesús rëbaman yaloj loj ree xbejnman: ―Gol gojp cudad con xlevadur ree bénfarisew, rën guiëban gapidi cudad con ni rusquiee reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Din achet ni naguieꞌch yuꞌ ni ad zaguient, ad yuꞌ tëët ni ralan ni ad zagbeet bejn. ");
INSERT INTO zasNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Zeel gra diidx ni ma guneedi lod nacay, zaguiejn ree bejn laan lod nayni. Guiáad ree diidx ni ma guneedi ralan lënü, yuꞌ chi cwidxaꞌ reeman guiniee reeman diidx guin ree diizd guijc ree yu. ");
INSERT INTO zasNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Rnin lëjt, ad ridxebidi bén rën ree gugüjt lëjt din zileꞌ gugüjt reeman xcuerpidi, saꞌn xsprijtidi ad zileꞌt gugaal reeman laan. ");
INSERT INTO zasNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ganin lëjt chu rayal guidxebidi: gol bidxeb Dios bén rajp guialrniabee guial chi ma biquiedaman xguialnabandi zajc guzaalaman lëjt gabijl. Zeel gol bidxebaman. ");
INSERT INTO zasNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Lëjt ragbee guial biguijndoo ree ad lasajct reeb wayëjx, per Dios ad rayanladxtaman niꞌqui tijb reeb. ");
INSERT INTO zasNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Guiáad lëjt xt guidxguijquidi, graczan nayab loj Dios. Zeel ad rdxebidi din mazri lasajquidi guial loj zien daꞌt ree biguijndoo. ");
INSERT INTO zasNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Rnin lëjt, chutëëz bén guiëb loj ree bejn guial najman da bejnan, ziangajc naj najn Bén guxhaal Dios guiën loj ree xianjl Dios guial da bejnan najman. ");
INSERT INTO zasNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Per bén guiëb loj ree bejn guial ad najtaman da bejnan, ziangajc guiën loj ree xianjl Dios guial ad najtaman da bejnan. ");
INSERT INTO zasNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Chutëëz bén guinieeguijdx Bén guxhaal Dios zajcaman perdon, saꞌn bén guinieeguijdx xSprijt Dios, ad zajctaman perdon. ");
INSERT INTO zasNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Chi chinë reeman lëjt lën ree yadoo o loj ree juejs në loj ree guxtis, ad aal chuꞌdi xgab xhienaag yadxiꞌdi xtiidx reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Din chi guidxin hor ni guinieedi, xSprijt Dios gunee diidx guinieedi. ");
INSERT INTO zasNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tijb bén noꞌch loj ree benzien guin rëb loj Jesús: ―Mextr, güjdx loj da bichan din guneex ni rayalan. ");
INSERT INTO zasNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Per rëb Jesús lojx: ―¿Chu bazuj naj günan guialguxtis o gaguiꞌsan ni tiaꞌdi? ");
INSERT INTO zasNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Rëb tëëman loj reeman: ―Gol gojp cudad; ad sëëbladxidi gapidi ni rajp ree ben ren, din ad ni rajpt bejn runee guialnaban. ");
INSERT INTO zasNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Dxel beman tijb cwent loj reeman, rëbaman: ―Guyu tijb xinrijcw, dád gojc xguiniaax. ");
INSERT INTO zasNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Dxel beenx xgab naladxix: “¿Xhienaag günan? Ad raꞌptan lod gaguꞌchaawan guialnazaꞌc guin ree.” ");
INSERT INTO zasNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Abiꞌ gunaladxix: “Ma ragbeen xhienaag günan. Guseꞌnan yu lod rguꞌchaawan da guialnazaꞌcan din günan mazri yu naroob ree lod gaguꞌchaawan laa reen, në graczi ni raꞌpan. ");
INSERT INTO zasNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Dxel guiën, dád zien guialnazaꞌc raꞌpan par zien ijz, yaziiladxan, gawan, guiëꞌn yabaa tëën.” ");
INSERT INTO zasNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Per rëb Dios lojx: “Xin tont, yanguxhin gajc guiëtil, laadx ni naguꞌchaawil, ¿chu yayaꞌnnë laan?” ");
INSERT INTO zasNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Zian rzajc bén rguꞌchaaw ni zaꞌc par laagajcaman, per loj Dios achet rajpaman. ");
INSERT INTO zasNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Dxel rëb Jesús loj ree xbejnman: ―Naj rni lëjt: Ad chuꞌdi xgab por ni gawidi par guibandi niꞌqui por lajd ni gacwidi. ");
INSERT INTO zasNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Guialnaban mazri lasajcan guial loj guialraw, guiáad xcuerp bejn mazri lasajcan guial loj xabaman. ");
INSERT INTO zasNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","¡Gol baguiaa balo ree! Ad rxübint reeb ad ratoꞌp tëët reeb guialnazaꞌc, ad rajp tëët reeb lod yaguꞌchaaw reeb guialnazaꞌc guin, per Dios rudëëd ni raw reeb. ¡Abiꞌ mazri lasajquidi guial loj reeb! ");
INSERT INTO zasNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Wen guial ru daꞌtidi xgab ma güün lëjt gajc mazri ziool ya? ");
INSERT INTO zasNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Abiꞌ bal niꞌqui zian ad zileꞌt güündi, ¿xhieczi gan rudi xgab por ni ren ree? ");
INSERT INTO zasNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’¡Gol baguiaa xhienaag riniꞌs ree guiaa dajn! Ad rüjnt reen dxiin ad rguib tëët reen. Per niꞌqui rey Salomón ad guzujchaawt ziꞌc zaꞌchaaw ree guiaa guin, majsi mast guzujchaawaman. ");
INSERT INTO zasNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Abiꞌ bal guiꞌxh dajn ruzujchaaw Dios yan, majsi guixiezi cheꞌcan. ¡Diidxgui lëjt, bén ad rliladxzaꞌct ree laaman nid zuneeman ni gacwidi ya! ");
INSERT INTO zasNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Zeel ad rudi xgab xhie gawidi o xhie guiëꞌdi, ad bal tib yuꞌzidi laan xgab. ");
INSERT INTO zasNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Din bén ad nünbeet ree Dios rüjn zian. Laa reeman ru xgab por gra ree ni guin. Per lëjt yuꞌ xDadidi, laaman ragbeechaaw xhienin riaadxidi. ");
INSERT INTO zasNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Per yalojxgaj gol baguiil güündi ziꞌc rniabee Dios, laaman gunee gra ni ryaadxidi. ");
INSERT INTO zasNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Lëjt najdi da bejnan, ad rdxebidi. Taꞌnzi najdi, per xDadidi Dios ma beenman xgab nabeenëdi laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gol batoꞌ ni rajpidi din gudëëdan loj ree bénprob. Gol been naguiejn güündi gan guialnazaꞌc ni ad rarat ni yuꞌ xanyabaa, lod ad zut xingubaan cwan laa reen lod ad zacabe tëët reen. ");
INSERT INTO zasNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Din lod rajpidi guialnazaꞌc guin, yagaj zaꞌ xquiarguiejndi. ");
INSERT INTO zasNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Gol guzujsin ziꞌc bén ma najcw xab caꞌ tëë xguijman par griiman. ");
INSERT INTO zasNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Gol been ziꞌc ree mojs cabëz yadxin xpatron reex, bén zë loj guialruxhliaa, din diob guixhial reex roꞌ port yayuman chi gucaaman. ");
INSERT INTO zasNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","¡Xiquilbaa ree mojs nagaꞌnaa cabëz xpatron reex! Naj rni lëjt, laagajc patron guin cweꞌc laa reex xan mex, dxel chicchaa xabaman din gudëëman ni gaw reex. ");
INSERT INTO zasNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Xiquilbaa reex bal guidxaagloj xpatron reex laa reex nagaꞌnaa reex, majsi yadxinman garol guiaal o chi ma cayreguiaal ya. ");
INSERT INTO zasNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Gol been xgab, bal tijb bejn ragbeeman xhie hor chuꞌ xingubaan lidxaman cwanx, ad zatiëjbtaman chuꞌx lidxaman. ");
INSERT INTO zasNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Zianan zeel gol guzujsin din ad ragbeetidi dxejczi guiꞌt Bén guxhaal Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Dxel gunabdiidx Bëd loj Jesús, rëbaman: ―Dad, ¿par dunujzan bel cwent guin ya o par gra ree bejn? ");
INSERT INTO zasNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Badxiꞌ Jesús laan, rëbaman: ―¿Chu lëjt na̱j ziꞌc tijb mojs zaꞌc, nazobdiidx, rusaꞌn xpatronx laax lidxaman persi rulenx gra ree mojs rudëë tëëx ni raw reex chi rajl hor? ");
INSERT INTO zasNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Xiquilbaa mojs cayüjn dxiin zagdxe chi yadxin xpatronx. ");
INSERT INTO zasNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Din diidxliczi rnin lëjt, zusaꞌn gra xieen patron guin loj mojs guin. ");
INSERT INTO zasNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Per bal naladx mojs guin: “Zaglaari yaguiaad da patronan”, zianz sulojx gusagzix gra ree bén rüjn dxiin yagaj, ziꞌc béngunaa ziꞌc xinguiaaw, dxel suloj gawix, guiëꞌx südx tëëx, ");
INSERT INTO zasNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","abiꞌ yadxin xpatronx tijb dxej ni ad rbëztix në tijb hor ni ad ragbeetix. Dxel dád casti naroob gudëëd patron guin laax, guixhiaalaman laax lod rayal ree bén ad ruzoobt diidx. ");
INSERT INTO zasNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Din tijb mojs ragbee ni rën xpatronx güünx, abiꞌ ad zaꞌtix porvinid ad ruzoob tëëtix diidx, dád casti naroob tëdix. ");
INSERT INTO zasNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Per mojs ad ragbeet ni rën xpatronx güünx abiꞌ güünx ni rayal casti, taꞌnz tëdix casti. Din bén badëëd Dios quiarguiejn, mazri zien ni rayal güünman por quiarguiejn ni badëëd Dios lojman. Ziangajc bén badëëd Dios guialrniabee, mazri zien ni rayal güünman por guialrniabee ni badëëd Dios lojman. ");
INSERT INTO zasNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Zialan loj guidxliuj ziꞌc tijb bén zidgacaaguij xhienin, abiꞌ ¡ma rën nejzdoon tiaguijn! ");
INSERT INTO zasNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Gazaagdiajn guiët tëën, abiꞌ ¡dád yuꞌnayan diizd yan xt chi gacan cumplid! ");
INSERT INTO zasNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ad naladxidi zialan loj guidxliuj par yabecdxen luxdoo bejn, zialan din guial guililadx reeman naj chuꞌ wadijl. ");
INSERT INTO zasNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Din diizd yan, lod na̱j reeman gaay loj tijb famil, til choonman contr tioꞌpaman, tioꞌpaman contr choonaman. ");
INSERT INTO zasNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Dad su contr xiꞌnman guiáad xiꞌnman su contr laaman; na su contr xiꞌndxaꞌpaman guiáad laam su contr laaman; abiꞌ nasuegr su contr xwalidxaman guiáad laam su contr laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Rëb tëë Jesús loj ree benzien guin: ―Chi ruguiaadi ririi za̱j niz lod rëëz gubijdx, rëbidi: zal guia, abiꞌ rajc gajc zian. ");
INSERT INTO zasNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Abiꞌ chi ririi bi niz sur, rëbidi: gac nalaa, abiꞌ rajc gajc zian. ");
INSERT INTO zasNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Bén rusquiee! Ragbeedi xhie rën guiëb sen rguien xanyabaa në loj guidxliuj, ¿chexquiza zeel ad ragbeetidi xhie rën guiëb ni cayajc loj guidxliuj yan? ");
INSERT INTO zasNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Chexc ad rüjnt lëjt gajc xgab conin na̱j ni zagdxe? ");
INSERT INTO zasNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Bal chu bén rudëëd lüj loj guxtis, been naguiejn bayaꞌnnëman diidx zagdxe laꞌtgaj yuꞌ tiamp, chitëë yayüman lüj loj guxtis, abiꞌ guxtis guin yayü lüj loj ree bén cuꞌ lüj ladxguiib. ");
INSERT INTO zasNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Naj rni lüj, ad zariitil ladxguiib guin xtczi quixil gra ni na guxtis guin. ");
INSERT INTO zasNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Lën gajc ree dxejzii wej tioꞌp choon ree bejn biguie reeman diidx loj Jesús guial bagüjt Pilato tioꞌp choon ree bén Galilea, abiꞌ bagoꞌchaman xrejn reeman con xrejn ree be bagüjt reeman par gudëëd reeman loj Dios ziꞌc gon. ");
INSERT INTO zasNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Dxel rëb Jesús: ―Ad bal naladxidi guzajc ree bén Galilea guin zian guial na̱j reeman mazri béndol guial loj gra ree bén Galilea. ");
INSERT INTO zasNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Din naj rni lëjt guial ad ziantan. Abiꞌ bal id zayüjndi xgab por xtolidi ziangajc saquidi. ");
INSERT INTO zasNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ad bal naladxidi bén chiinbichoon güt ree chi guxaꞌt torre ni la Siloé laa reeman, na̱j reeman mazri béndol guial loj gra ree bén zojb Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Naj rni lëjt guial ad ziantan. Abiꞌ bal id zayüjndi xgab por xtolidi ziangajc saquidi. ");
INSERT INTO zasNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Dxel be Jesús tijb cwent loj reeman, rëbaman: ―Tijb bejn gojpaman yag higo lod naguꞌman uv, abiꞌ biquiaaman bal ca higo lojn, per achetczi bidxaaglojman. ");
INSERT INTO zasNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Dxel rëbaman loj bén rajp guidxliuj guin: “Baguiaa, ma gojc choon ijz rialan rguilan higo loj yag guin, abiꞌ achetczi rdxaaglojn. Batüügan din nawëëgzi rüjnan loj guidxliuj guie.” ");
INSERT INTO zasNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Per rëb bén rajp guidxliuj guin: “Dad, basaꞌnsiin zatib ijz, yabeclaan yuj xanan gaguꞌ tëënan abon. ");
INSERT INTO zasNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Rupent zian tian, per bal id zacan dxel tügan.” ");
INSERT INTO zasNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tijb dxej raziiladx ree bejn, culüü Jesús bejn ree lën tijb yadoo, ");
INSERT INTO zasNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","yagaj zaꞌ tijb béngunaa ma gojc chiinbichoon ijz ragxuuman, tijb xindxab basaꞌn laaman con tijb bëw xijchaman, ad rileꞌtczi yaliman. ");
INSERT INTO zasNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Chi baguiaa Jesús laaman, gurejdxaman laaman, rëbaman: ―Na, ma bayajquil guialguijdx ni goquil. ");
INSERT INTO zasNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Dxel badxiib yaaman guijcaman; abiꞌ loj hor guin gajc baliman, zianz guzuloj cuzaꞌtaman Dios zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Per bén rniabee lën yadoo guin dád bidxeꞌchaman guial bayüjn Jesús bén guin dxej raziiladx ree bejn, dxel rëbaman loj ree bejn: ―Xhoꞌp dxej yuꞌ guial güün bejn dxiin, loj ree dxej guin gol guida din yayajquidi, per ad dxej raziiladxt bejn. ");
INSERT INTO zasNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Badxiꞌ Dad Jesús laan rëbaman: ―Bén rusquiee, ¿nid rxhiec xgoꞌndi o xburidi dxej raziiladx ree bejn ya par chiquiëꞌdi laa reeb nijs? ");
INSERT INTO zasNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Béngunaa guie zëëdaman loj xdiaa Abraham, ma gojc chiinbichoon ijz naxhii xindxab laaman con guialguijdx guie. ¿Wen id zajc yayajcaman dxej raziiladx ree bejn ya? ");
INSERT INTO zasNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Chi rëb Jesús zian, gra ree bén rdxeꞌch laaman bayaꞌn xtu; per graczi ree bejn rabaa guial ruguiaa reeman gra ree ni zagdxe ni rüjnman. ");
INSERT INTO zasNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Rëb tëë Jesús: ―¿Xhienaag ganin na̱j xguialrniabee Dios o xhie gulün lojdi din chigniaꞌdi xhienaag na̱j xguialrniabeeman? ");
INSERT INTO zasNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Laan na̱j ziꞌc xhaj moxtajs ni rxübin bejn loj xguiniaaman, rniꞌsan xt rajcan yag naroob. Abiꞌ guial naroob daꞌt rajcan xt rüjn xguixbitiaꞌs ree biguijn xidxan. ");
INSERT INTO zasNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Rëb Jesús zatijb: ―¿Xhienaag ganin na̱j xguialrniabee Dios? ");
INSERT INTO zasNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Laan na̱j ziꞌc levadur ni rugoꞌch tijb béngunaa choon midid harin persi rusaaguijn gra cob guin. ");
INSERT INTO zasNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Chi zë Jesús Jerusalén, rulüüman bejn ree luguiedx naroob ree në ree luguiedx dobëz niz lod rdëdaman. ");
INSERT INTO zasNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Abiꞌ tijb bejn gunabdiidx lojman rëbaman: ―Dad, ¿taꞌnz ree bén gac perdon ya? Badxiꞌ Jesús laan rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Gol been naguiejn din chuꞌdi niz roꞌ port nadëë, din naj rni lëjt, zien ree bén rën chuꞌ, per ad zileꞌt chuꞌ reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Din chi chisu bén na̱j lidxan gusiaawaman roꞌ port guin, lëjt guial yayaꞌndi xchu, gucaadi roꞌ port guin guiëbidi: “Dad, guxhal.” Per yadxiꞌman xtiidxidi naman: “Ad ragbeetan ban zadi.” ");
INSERT INTO zasNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dxel suloj guiëbidi: “Tijbzi badaaw ree, tijbzi badüꞌ ree, niz la̱d dux nejzan balüül dunujn.” ");
INSERT INTO zasNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Per naman lojdi: “Ma rnin, ad ragbeetan ban guzadi. Gol biquied lon béndol.” ");
INSERT INTO zasNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ni goondi gaw tëë layidi chi guguiaadi Abraham, Isaac, Jacob, në gra ree bén badëë xtiidx Dios loj ree bejn, zaꞌ reeman lod rniabee Dios, guiáad lëjt yariicadi. ");
INSERT INTO zasNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Din guiꞌt ree bén sa gra lad guidiblagaa guidxliuj din cwe reeman gaw reeman lod rniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Abiꞌ zien ree bén bigra yan, laa reeman gac bén yaloj nadxel. Guiáad ree bén na̱j bén yaloj yan, laa reeman gac bén bigra. ");
INSERT INTO zasNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Hor guin gajc bidxin tioꞌp choon ree bénfarisew, abiꞌ rëb reeman loj Jesús: ―Baguiaj, baza niz guie, din rën rey Herodes gugüjtaman lüj. ");
INSERT INTO zasNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Badxiꞌ Jesús laan rëbaman: ―Gol chej gol chiguiedx loj bén rusquiee zii: “Yan, në guixie yabën xindxab yayün tëën bénragxuu ree, abiꞌ widx gulooxan.” ");
INSERT INTO zasNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Per naj rayal gusnuu da nejzan yan në guixie në widx, din ad najt guial guiët tijb bén rudëë xtiidx Dios loj ree bejn luguiedx ren bal id najn Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Bén Jerusalén, bén Jerusalén, rugüjtidi bén rudëë ree xtiidx Dios loj ree bejn rucaaguiaj tëëdi gra ree bén rxhiaal Dios lojdi! ¡Bëlczi volt guyënan nuchagan lasaꞌdi ziꞌc rüjn tijb guid ruchajg lasaꞌ ree xiꞌnb lën xhiilib, per ad cwëjbtidi! ");
INSERT INTO zasNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Zianan zeel yayaꞌn ladxidi ziꞌc tijb guiedx lod achut zojb. Abiꞌ rnin lëjt, diizd yan ad zuguiaatridi naj xt chi guidxin dxej guiëbidi: “¡Nüjnleꞌ Dios bén zëëd por laaman!” ");
INSERT INTO zasNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tijb dxej raziiladx ree bejn wej Jesús bitawaman lidx tijb bénfarisew rniabee. Yuꞌ ree bénfarisew guin culaꞌch laaman xhie güünman, ");
INSERT INTO zasNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","guial zaꞌ tijb xinragxuu lojman rzaaguijx. ");
INSERT INTO zasNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Dxel gunabdiidx Jesús loj ree mextr rajc ley në loj ree bénfarisew guin, rëbaman: ―¿Zajc yayüjn bejn bénragxuu dxej raziiladx ree bejn ya o ad zajctan? ");
INSERT INTO zasNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Per laa reeman achetczi rëb reeman. Dxel gunaaz Jesús xinragxuu guin bayüjnman laax, abiꞌ rëbaman lojx din yaguiajx. ");
INSERT INTO zasNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Dxel rëbaman loj ree bénfarisew guin: ―¿Bal tijb xburidi o tijb xgoꞌndi yab lën tijb bizë, nid zabëëdi laab ya, majsi na̱j dxej raziiladx bejn? ");
INSERT INTO zasNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Abiꞌ achet gojc nadxiꞌ reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Chi baguiaa Jesús rbe ree biooz luar lod rbej ree bén mazri zojbloj, rëbaman loj reeman: ");
INSERT INTO zasNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Bal chu guiniee lüj chel loj tijb guialruxhliaa, ad cwel luar rbej ree bén mazri zojbloj. Din zajc guidxin zatijb biooz mazri zojbloj guial lojl, ");
INSERT INTO zasNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","abiꞌ guiꞌt bén gunee gropidi naman lojl: “Badëëd lod zojbil cwe bén guie.” Dxel rayal chel guidib ratul chisobil loj yagxhil bigra. ");
INSERT INTO zasNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Zeel chi guiniee reeman lüj, zagdxeli bisob loj yagxhil bigra, din chi guiꞌt bén gunee lüj naman lojl: “Miw, badëd loj tijb luar mazri zojbloj.” Zian, gra ree bén zojbnël xan mex guzaꞌt lüj zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Din bén rlies xvalor gajc, yayaꞌnxtuman. Guiáad bén rüjn naya zajs xvaloraman. ");
INSERT INTO zasNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Dxel rëb Jesús loj bén gunee laaman: ―Bal goc cuꞌl guialraw, ad guiniee xmiwil, niꞌqui lasaꞌl, niꞌqui bijchil, niꞌqui benrijcw zojbnël gajxh. Din laa reeman yuꞌ dxej guiniee reeman lüj, abiꞌ zian yanee reeman ni gudaw reeman lidxil. ");
INSERT INTO zasNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Zagdxeli na̱j, chi güünl tijb lanij, gunee bénprob ree, në ree bén ad nadaant yaa, në ree bencoj con ree bénlutiaꞌp. ");
INSERT INTO zasNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Xiquilbaal bal güünl zian, din laa reeman ad zajct yanee ni badëëdil. Per chi guidxin dxej yaban ree bén bazoob xtiidx Dios, Dios yaguijx laan lojl. ");
INSERT INTO zasNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Chi biguiejn tijb bén zojbnë Jesús xan mex ni rëbaman, rëbaman loj Jesús: ―¡Xiquilbaa ree bén yayal gaw lod rniabee Dios! ");
INSERT INTO zasNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Dxel rëb Jesús lojman: ―Tijb bejn badxeꞌ guialraw par xche, abiꞌ guneeman zien daꞌt ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Chi ma gojl hor gaw reeman xche, guxhaal xmojsaman din chex chiguiedxix loj ree biooz guin: “Gol guda din graczi ma najcchaaw.” ");
INSERT INTO zasNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Per graczi reeman guzuloj caynab perdon. Bén yaloj guin, rëbaman: “Yan gajczi guzin tijb guidxliuj, rayal chiquianan; been wen güjdx lojman din güünman naj perdon.” ");
INSERT INTO zasNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Zatijbaman rëb: “Guzin gaay nejz goꞌn, yan chiguienan laa reeb prueb guidoondon rajc rüjn reeb dxiin ya; been wen güjdx lojman din güünman naj perdon.” ");
INSERT INTO zasNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Zatijbaman rëb: “Yan gajczi baxhlian zeel ad zileꞌt guialan.” ");
INSERT INTO zasNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Chi badxin mojs guin bagojn xpatronx gra ni rëb ree bén guin, dád balenman, dxel rëbaman lojx: “Baquiejn wej niz galay ni, në niz la̱d ree nejz, tanë gra ree bénprob në ree bén ad nadaant yaa, në ree bencoj con ree bénlutiaꞌp.” ");
INSERT INTO zasNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Chi ma been mojs guin zian, dxel rëbix lojman: “Dad, ma benan ni nal, per sta yuꞌ gajc luar lidxil.” ");
INSERT INTO zasNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Dxel rëbaman lojx: “Wej niz loj carreter në niz loj ree nejz laꞌs, been naguiejn ben ren ree din guiꞌt reeman din cha lënü lidxan. ");
INSERT INTO zasNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Din naj rni lojdi, niꞌczi tijb ree bén gunen yaloj ad zajwt guialraw benchaawan par xche.” ");
INSERT INTO zasNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Dád zien ree bejn zinal Jesús; abiꞌ badxiꞌ lojman loj reeman rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Bal chudi rën guidnal naj, rayal guiëndi naj mazri guial loj xdadidi, guial loj xniaadi, guial loj lacheelidi, në guial loj xiꞌndi, o bijchidi o bizandi, rayal tëë guiëndi naj mazri guial loj xguialnabandi, din bal id züjndi zian ad zajct gaquidi da bejnan. ");
INSERT INTO zasNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Bén ad rënt sagdiaj guidnal tëëman naj, ad zajct gacaman da bejnan. ");
INSERT INTO zasNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","’Bal chu rën güün tijb yu naroob, ¿nid yalojxgaj cweman ya din cwëëman cwent zadaan xmiliaman ya din gulooxaman laan? ");
INSERT INTO zasNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Din bal sulojman xcimiantan abiꞌ ad zulooxtaman laan, graczi ree bén guguiaa laan guzeꞌ laaman, ");
INSERT INTO zasNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","guiëb reeman: “Guzuloj cayüjn bén guin yu abiꞌ ad gojct nulooxaman laan.” ");
INSERT INTO zasNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","’O bal tijb rey güün wadijl contr zatijb rey, ¿nid yalojxgaj cweman ya güünman xgab züjn chii mil xsuldadaman gan loj stijb rey zidnë gajl mil suldad ya? ");
INSERT INTO zasNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Per bal naladxaman ad züjntaman gan loj rey guin, laꞌtgaj sta zaꞌ rey guin zijt, guixhiaalaman bén chinë ree xrusonman din yayaꞌn reeman diidx ad zut wadijl. ");
INSERT INTO zasNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yan, ziangajc rnin lojdi, chutëëz lëjt bal id zusaꞌn gra ni rajpidi din guidnalidi naj, ad zajct gaquidi da bejnan. ");
INSERT INTO zasNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Dxel rëb Jesús: ―Ni zagdxe na̱j zëd. Per bal id zajcran naxij, ¿xhieza naag yayajcan naxij zatijb? ");
INSERT INTO zasNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ad rüjntan sirv par luyuj niꞌqui par loj abon, rzëëbzan. ¡Bén rën ree gucaagdiajg, gol bacaagdiajg! ");
INSERT INTO zasNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Gra ree bén ruquijx impuest në gra ree béndol, bibig reeman lod zaꞌ Jesús din gucaagdiajg reeman ni rnieeman. ");
INSERT INTO zasNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Guiáad ree bénfarisew con ree mextr rajc ley rnieeguijdx reeman laaman, rëb reeman: ―Ruchajg bén guin béndol ree rawnë tëëman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Dxel rëb Jesús loj reeman: ");
INSERT INTO zasNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Bal tijb bejn rajp tibgayuu xiil abiꞌ rnijt tijbib, ¿nid rusaꞌnman zatajpgajlchiinbitapib dajn ya abiꞌ rigdiilaman xiil gunit guin xt lodzi radxejlaman laab? ");
INSERT INTO zasNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Abiꞌ chi radxejlaman laab rabaaman, rudxiibaman laab dxidyëjnman. ");
INSERT INTO zasNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Dxel chi radxin lidxaman, rutoꞌp ree xmiwaman në ree bén zojbnëman gajxh abiꞌ rëbaman loj reeman: “Gol babaa ziꞌc rabaan, din ma badxejlan da xiilan be gunit.” ");
INSERT INTO zasNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yan, rnin lëjt, ziangajc rabaanë Dios tijb bén rayüjn xgab por xtol guial loj tajpgajlchiinbitap benzaꞌc ad ryaadxt yayüjn xgab por xtol. ");
INSERT INTO zasNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’O bal tijb béngunaa rajpaman chii milia plajt abiꞌ rusëëbaman tijban, ¿nid ruzeꞌcaman guij ya ruloob tëëman lënü abiꞌ raguiilaman laan zagdxe daꞌt xt lodzi radxejlan? ");
INSERT INTO zasNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Abiꞌ chi radxejlaman laan, rutoꞌp ree xmiwaman në ree bén zojbnëman gajxh, abiꞌ rëbaman loj reeman: “Gol babaa ziꞌc rabaan din ma badxejlan milia basëban.” ");
INSERT INTO zasNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yan, naj rni lojdi, ziangajc rabaa ree xianjl Dios por tijb béndol rayüjn xgab por xtol. ");
INSERT INTO zasNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Rëb tëë Jesús loj reeman: ―Tijb bejn yuꞌ tioꞌp xiꞌnman. ");
INSERT INTO zasNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Abiꞌ xin na̱j mazri xinguiag, rëb loj xdadix: “Dad, banee ni rayal gacaꞌn.” Dxel badëëman ni rayal tijbgaj reex. ");
INSERT INTO zasNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ad gojct xchej ni cwaꞌ reex ni rayal reex, xin na̱j xinguiag guin batoꞌgajquix graczi ni badëëd xdadix lojx, abiꞌ con milia guin wejx zijt bignijt xliaꞌx graczi xmiliax guial beenx ni rëntzix. ");
INSERT INTO zasNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Per chi ma banijtix gran, dxel guyu gubijn niz lod zaꞌx abiꞌ guzuloj biaadx ni gawix. ");
INSERT INTO zasNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Dxel wejx bignabix dxiin loj tijb bén zojb yagaj, abiꞌ guxhaalaman laax chigajpix cüch ree dajn. ");
INSERT INTO zasNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Guial tant rliaanx xt guyënx niajwix ni raw ree cüch guin, per achut rudëë laan. ");
INSERT INTO zasNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Dxel beenx xgab naladxix: “¡Zien ree xin rüjn dxiin lidx da Dadan xt sobr rüjn ni raw reex, guiáad naj guie ma guiëtan bëjz! ");
INSERT INTO zasNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yan, yazaan yayaꞌ lidx da dadan din guiën lojman: Dad, ma benan dol loj Dios në lojl. ");
INSERT INTO zasNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ad rayaltri guinieel naj xiꞌn; been naj cwent ziꞌc tijb ree xmojsil.” ");
INSERT INTO zasNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Dxel bayunejzix zia lidx xdadix. ’Per zijtri ziaadix chi baguiaa xdadix laax dxel bayaman laax, zianz ruxüünman bigchaaglojman laax, abiꞌ gudiidxaman laax gudaw tëëman laax xid. ");
INSERT INTO zasNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Dxel rëbix lojman: “Dad, ma benan dol loj Dios në lojl, ad rayaltri guinieel naj xiꞌn.” ");
INSERT INTO zasNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Per rëb xdadix loj ree xmojsaman: “Gol baquiejn gol tanë lajd zagdxe, gol bascajcwixan, gol badxeꞌ tijb guiibnil yaax gol baslëë tëëx gurëch, ");
INSERT INTO zasNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","gol chicaꞌ goꞌn mazri nadaan, gol bagüjtib din yadaaw ree yaguieen ree lanij. ");
INSERT INTO zasNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Din par naj ma güjt da xiꞌnan abiꞌ yan ma babanx, gunijtix abiꞌ ma badxejlix.” Dxel guzuloj cayüjn reeman lanij. ");
INSERT INTO zasNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Laꞌtgaj xiꞌnman xingol guin cayüjnx dxiin dajn. Chi badxinx gajxh lidx xdadix, biguiejnx cucwejdx reeman cuyaꞌ tëë reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Dxel gurejdxix tijb xmojs xdadix, gunabdiidxix xhienin cayajc lidxix. ");
INSERT INTO zasNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Badxiꞌ mojs guinan rëbix: “Guial baguiaad bijchil zeel gunabee xdadil güjt tijb goꞌn mazri nadaan guial nadaanx baguiaadix.” ");
INSERT INTO zasNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Per dád bidxeꞌch xingol guin, abiꞌ ad guyëntix nayux. Zeel wej xdadix biguiedxaman lojx din yayux. ");
INSERT INTO zasNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Dxel rëb loj xdadix: “Lüj ragbee ma gojc xchej cayünan xchiinl, zianczi ruzoban xtiidxil; per niꞌczi tijb ad waneetil tijb dxibdobëz din günnëꞌ ree da miwan lanij. ");
INSERT INTO zasNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Guiáad yan baguiaad xiꞌnl, xin ma bignijt xliaꞌ xmilial con ree béngunaa dxuudx, abiꞌ gunabeel güjt goꞌn mazri nadaan par laax.” ");
INSERT INTO zasNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","’Dxel badxiꞌ xdadix laan rëbaman: “Xiꞌn, zianczi zaꞌl con naj, graczi ni raꞌpan na̱j xieenl. ");
INSERT INTO zasNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Per yan rayal yaguieen ree lanij yabaa tëë ree, din bijchil xin ma güjt par naj, ma babanx, gunijtix abiꞌ ma badxejlix.” ");
INSERT INTO zasNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Rëb tëë Jesús loj ree xbejnman: ―Guyu tijb benrijcw, nuzujman tijb mojs guinia graczi ni rajpaman. Abiꞌ biguiedx ree ben ren lojman guial cunijt xliaꞌ mojs guin ni na̱j xieenman. ");
INSERT INTO zasNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Dxel gurejdxaman laax rëbaman lojx: “¿Xhie rën guiëb ni riguiejnan cayüjnl? Banee cwent lon xcwent xchiinl, din achetri dxiin gunen lojl.” ");
INSERT INTO zasNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Dxel guzuloj beenx xgab gunaladxix: “¿Xhienaag günan yan ma gusaꞌn da patronan naj sin dxiin? Ad yuꞌtan gojl günan dxiin dajn, ratu tëën ganaaban carda. ");
INSERT INTO zasNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ma ragbeen xhienaag günan din guiën ree bejn naj chi ad züntran dxiin.” ");
INSERT INTO zasNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Dxel gurejdxix tijb gaj ree bén ral loj xpatronx, rëbix loj bén bidxin yaloj: “¿Plac ralil loj da patronan?” ");
INSERT INTO zasNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Abiꞌ rëbaman: “Ralan tibgayuu barril sejt lojman.” Dxel rëbix: “Cwaꞌ guiꞌch guie lod ca ni ralil lojman, been zatijban bacaa lojn ralil tüꞌpchiizan.” ");
INSERT INTO zasNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Dxel gunabdiidxix loj zatijbaman rëbix: “Laadx lüj, ¿plac ralil?” Abiꞌ rëbaman: “Tib gayuu ingujch trigo.” Zianz rëbix: “Cwaꞌ guiꞌch guie lod ca ni ralil lojman, been zatijban bacaa lojn ralil tajpgajlzan.” ");
INSERT INTO zasNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Dád badxaloj patron guin guial nasin mojs mal guin por ni beenx. Din mazri nasin ree bén ad zinalt xnejz Dios con lasaꞌ reeman guial loj ree bén zinal xnejz Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Rnin lojdi, gol beennë dxiin ni rajpidi loj guidxliuj guie par gagnëdi bejn din chuꞌ xmiwidi, din chi yaran ma yuꞌ bén yacaꞌ lëjt lod gapidi guialnaban tiblayaa. ");
INSERT INTO zasNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Bal chu rüjn ziꞌc rayal con taꞌn ni rudëëd bejn lojman, züjnman ziꞌc rayal con zroꞌn. Ziangajc bén ad rüjnt ziꞌc rayal con taꞌn ni rudëëd bejn lojman, ad züjn gajctaman ziꞌc rayal con zroꞌn. ");
INSERT INTO zasNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yan, ziangajc bal id züjndi ziꞌc rayal con ni zaꞌc yuꞌ loj guidxliuj guie, ¿chu gap lëjt confianz con guialnazaꞌc yuꞌ xanyabaa? ");
INSERT INTO zasNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Bal id züjndi ziꞌc rayal con ni ad najt xieendi, ¿chu gunee lëjt ni rayalidi? ");
INSERT INTO zasNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Niꞌqui tijb mojs ad zajct güünx sirv loj tioꞌp patron; din zadxeꞌchix tijbaman abiꞌ zënx zatijbaman; o zajquix xinzaꞌc con tijbaman abiꞌ züjnx tiblad zatijbaman. Zeel ad zajct güündi sirv loj Dios, në loj milia. ");
INSERT INTO zasNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Abiꞌ ree bénfarisew guial mazri rën reeman milia, chi biguiejn reeman ni rëb Jesús guzuloj cuzeꞌ reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Dxel rëb Jesús loj reeman: ―Rüjndi benzaꞌc niz loj ree bejn, per Dios nünbee luxdoodi; abiꞌ majsi loj bejn lasajc daꞌtidi, per loj Dios achet lasajquidi. ");
INSERT INTO zasNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Xley Moisejs në ni bacaa ree bén badëë xtiidx Dios loj ree bejn, nagaꞌloj been reen dxiin xt chi biꞌt Waj bén baroobnijs bejn ree. Abiꞌ diizd nadxel guzuloj rireꞌch xtiidxzaꞌc Dios xhienaag na̱j xguialrniabeeman, abiꞌ zien ree bejn rüjn naguiejn chuꞌ loj xguialrniabeeman. ");
INSERT INTO zasNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Adli nawëëgt nit xanyabaa në guidxliuj, guial yayaꞌn tijb diidx zëëd loj ley guin guial ad zajctan cumplid. ");
INSERT INTO zasNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Bal tijb xinguiaaw ralaꞌ lacheelix abiꞌ rtiaꞌx ben ren, dolan cayüjnx. Ziangajc xin rtiaꞌ tijb béngunaa balaꞌ lacheel, dolan cayüjnx. ");
INSERT INTO zasNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Basnuu Jesús, rëbaman: ―Guyu tijb xinrijcw, guzujchaawix con ganaxczi lajd zagdxe, abiꞌ guixie guixieczi rüjnx lanijroꞌ. ");
INSERT INTO zasNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Guyu tëë tijb xinprob brii lajx Lazr, rbejx roꞌ xport xinrijcw guin abiꞌ guidiblagaax ca guiadx. ");
INSERT INTO zasNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Rën nejzdoo Lazr guin gawix ni riajb xan xmex xinrijcw guin. Abiꞌ xt ree bëꞌcw rbig rlieꞌ reeb loj ree guiadx ni cax. ");
INSERT INTO zasNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","’Chi bidxin dxej güjt Lazr dxel bignë ree xianjl Dios laax lod na̱j nix daꞌt, lod zaꞌ Abraham. Në xin rijcw guin güjt, abiꞌ biguieꞌchix. ");
INSERT INTO zasNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Chi ma cazagdiaj xin rijcw guin gabijl, gules lojx abiꞌ zijtri baguiaax zaꞌ Lazr cwëꞌ Abraham. ");
INSERT INTO zasNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Dxel gurixdiajx rëbix: “Dad Abraham, baya naj, guxhaal Lazr din gugajdx lupunt xbacwënx din guiꞌtix yasiaalyujx lüdxan, din dád cazaagdiajn loj bajl guie.” ");
INSERT INTO zasNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Per badxiꞌ Abraham xtiidxix rëbaman: “Xiꞌn, basaaladx guial dád nix guyu luxdool chi gubanl loj guidxliuj, guiáad Lazr dád naya gubajnx. Yan, rayalix lod yabaax guiáad lüj rayalil lod sagdiajl. ");
INSERT INTO zasNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nëtëë yan bén zaꞌ ree guie ad zajct tëd reeman yagaj, niꞌqui ree bén zaꞌ yagaj ad zajct tëd reeman guie, din zaꞌ balaꞌroꞌ du galay ree.” ");
INSERT INTO zasNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","’Dxel rëb xinrijcw guin lojman: “Rniaaban lojl dad, been wen guxhaal Lazr lidx da dadan, ");
INSERT INTO zasNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","lod zojb gaay ree da bichan din chicojnx laa reex chitëë në laa reex guiꞌt luar guie, lod yuꞌ zroꞌ casti.” ");
INSERT INTO zasNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Per rëb Abraham lojx: “Ma rajp reex guiꞌch ni bacaa Moisejs con ree bén badëë xtiidx Dios loj ree bejn, laan rayal guidxgaꞌ reex.” ");
INSERT INTO zasNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Abiꞌ rëb xinrijcw guin: “Walil, dad Abraham, per ad zaliladxt reex, saꞌn bal yaban tijb bén ma güjt chigneenëman laa reex, zayüjn reex xgab por xtol reex.” ");
INSERT INTO zasNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Per rëb Abraham lojx: “Bal id ridxgaꞌ reex xtiidx Moisejs në xtiidx ree bén badëë xtiidx Dios loj ree bejn, ad zaliladxt reex majsi yaban tijb bén ma güjt.” ");
INSERT INTO zasNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Rëb Jesús loj ree xbejnman: ―Zianczi yuꞌ ree ni ruzaalguiiw bejn din güünman dol, per ¡probza na̱j bén ruzaalguiiw zatijb bejn guial güünman dol! ");
INSERT INTO zasNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Par laaman zagdxeli na̱j guixhii reeman tijb guiaj mulin yëjnman din guzaal reeman laaman loj nijsdoo, luar guzaalguiiwaman tijb bén qui rliladxri naj din güünman dol. ");
INSERT INTO zasNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Gol gojp cudad! ’Bal xhie tijb ni mal güün tijb lasaꞌl, guneenëman. Abiꞌ bal bayüjnman xgab por ni beenman, beenman perdon. ");
INSERT INTO zasNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Majsi gajdx volt loj tibdxej güünman xhienin contr lüj, abiꞌ bal guiꞌtaman lojl gajdx volt naman: “Been naj perdon ad züntran zian”, rayal güünl laaman perdon. ");
INSERT INTO zasNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Dxel rëb ree xi apóstoles Jesús lojman: ―Banee dunujn mazri guialrliladx. ");
INSERT INTO zasNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Abiꞌ rëb Jesús loj reeman: ―Bal na̱j xguialrliladxidi majsi ziꞌczi na̱j xhaj moxtajs, zileꞌ guiëbidi loj yagroꞌ guin: “Biaꞌxh guie, bisob loj nijsdoo”, zuzooban xtiidxidi. ");
INSERT INTO zasNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Bal tijb lëjt rajp tijb mojs, abiꞌ chi yaguiaad mojs guin biglaꞌx yuj o bigajpix beguiꞌxh ree ya, ¿wen zëjbidi lojx ya: “Guyu, gurej din gawil”? ");
INSERT INTO zasNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ad zëjbtidi zian, guiëblidi: “Bachaa xabil, been ni gawan, gudaꞌn. Chi lox gawan guiëꞌ tëën dxel ma zajc gawil guiëꞌ tëël.” ");
INSERT INTO zasNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Abiꞌ wed niꞌqui quixtëë ad zudëëtidi lojx din cayüjnzix ni rayal güünx. ");
INSERT INTO zasNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ziangajc lëjt chi loox güündi gra ni gunabee Dios dxel guiëbidi: “Nayajcan mojs ni ad rüjnt sirv, din baguieenzan ni rayal yaguieenan.” ");
INSERT INTO zasNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Chi ma cadxin Jesús Jerusalén, gudëdaman guiedx rigaꞌ ree niz Samaria në niz Galilea. ");
INSERT INTO zasNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Abiꞌ chi cayuman tijb luguiedx dobëz, bigchaagloj chii ree bén rajc guialguijdx la lepra laaman. Per zijt guzuj reeman, ");
INSERT INTO zasNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","rbixdiaj reeman, rëb reeman: ―¡Jesús, Mextr, baya dunujn! ");
INSERT INTO zasNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Chi baguiaa Jesús laa reeman, rëbaman loj reeman: ―Gol chej loj ree bixhioz din guguiaa reeman lëjt. Abiꞌ laꞌtgaj zë reeman, baya xcuerp reeman guialguijdx ni rajc reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Dxel tijbaman chi gogbeeman ma bayajcaman, bayejcaman, rbixdiajman rudëëman quixtëë loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Abiꞌ bazuxibaman loj Jesús, basajb lojman xt luyuj persi badëëman quixtëë lojman. Abiꞌ najman bén Samaria. ");
INSERT INTO zasNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Dxel rëb Jesús: ―¿Nid chii na̱j ree bén bayajc ya? ¿Con zagaa reeman? ");
INSERT INTO zasNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Tijbzi benzit guie bayejc ya rudëëman quixtëë loj Dios? ");
INSERT INTO zasNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Dxel rëbaman loj bén guin: ―Bisu. Baguiaj, ma bayajquil guial bililadxil naj. ");
INSERT INTO zasNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Gunabdiidx ree bénfarisew loj Jesús goc guiꞌt xguialrniabee Dios, abiꞌ rëbaman: ―Xguialrniabee Dios ad najtan ni guguiaa bejn. ");
INSERT INTO zasNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Abiꞌ achut guiëb: “Laan zaꞌ guie”, o “Laan zaꞌ ni” ya, din xguialrniabee Dios mal zaꞌn galaydi. ");
INSERT INTO zasNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Dxel rëbaman loj ree xbejnman: ―Zadxin dxej guiëndi guguiaadi Bén guxhaal Dios majsi tibdxejzi, per ad zuguiaatidi laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Abiꞌ yuꞌ reeman na lëjt: “Laaman zaꞌ guie”, o “Laaman zaꞌ ni” ya, ad bal chinalidi laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Din ziꞌc chi rëꞌp nijs rulaan bachaꞌ guidib xanyabaa, zian gac chi guiꞌt Bén guxhaal Dios loj guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Per yalojxgaj sagdiajman abiꞌ ad zënt ree bén rigaꞌ yan laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ziꞌc goc gulal chi guban Noé, zian gac chi guiꞌt Bén guxhaal Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Din nadxel gudaw ree bejn, guꞌ reeman, baxhliaa reeman badëë tëë xiꞌn reeman baxhliaa xt chi bidxin dxej guyu Noé lën barcwroꞌ ni beenman, abiꞌ guzuloj guiadoxh ni bagüjt gra reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ziangajc gojc chi guban bén brii laj Lot, gudaw ree bejn, guꞌ reeman, batoꞌ reeman, guzii reeman, guxübin reeman been tëë reeman yu ree. ");
INSERT INTO zasNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Per chi brii Lot luguiedx Sodoma, guzuloj biyajb guij xanyabaa në azufre, abiꞌ güjt gra reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ziangajc gac dxej ni guiꞌt Bén guxhaal Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Dxej ni gac zian, bén yëꞌp guijc yu ad zaguiajttaman chiglëë ni naguꞌman lënü. Abiꞌ bén zaꞌ dajn, ad zayejct lidxaman. ");
INSERT INTO zasNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Gol basaaladx ni guzac lacheel bén brii laj Lot. ");
INSERT INTO zasNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Bén mazri rën guialnaban rajpaman loj guidxliuj guie, zadxin dxej gunijtaman laan, per bén guiët por naj, zajpaman guialnaban tiblayaa con Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Naj rni lëjt, guxhinzii lod nagaꞌ tioꞌp bejn tijbzi loj loon, tijbaman sa zatijbaman yayaꞌn. ");
INSERT INTO zasNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Guiáad lod cayojt tioꞌp ree béngunaa, tijbaman sa zatijbaman yayaꞌn. ");
INSERT INTO zasNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Abiꞌ lod zaꞌ tioꞌp ree xinguiaaw dajn, tijbix sa zatijbix yayaꞌn. ");
INSERT INTO zasNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Chi biguiejn ree xbejnman zian, rëb reeman: ―¿Ban guin, Dad? Badxiꞌman laan rëbaman: ―Laa guiguien gajc ban guinan, ziꞌc chi radoꞌp ree golbich laa rguien gajc nagaꞌ tijb begüt. ");
INSERT INTO zasNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Be Jesús tijb cwent loj ree xbejnman, persi balüüman laa reeman guial zianczi rayal cwedx guiniab reeman Dios ad zadxagtczi reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Abiꞌ rëbaman loj reeman: ―Guyu tijb guiedx lod guyu tijb juejs, ad rdxebtaman Dios ad ridxgaꞌ tëëtaman bejn ree. ");
INSERT INTO zasNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Luguiedx ziigajc zojb tijb béngunaa bizëjb, rniabaman loj juejs guin din güünman guialguxtis gagnëman laaman loj bén rdxeꞌch laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Xchej ad bidxgaꞌt juejs guin béngunaa bizëjb guin, per zianz laagajcaman been xgab naladxaman: “Majsi ad rdxebtan Dios ad ridxgaꞌ tëëtan bejn ree, ");
INSERT INTO zasNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","per béngunaa guie ad rucwëëzt ruslenman naj. Zagdxeli na̱j günan laaman yudar chitëë riꞌtraman naga gad da pacensan chigra.” ");
INSERT INTO zasNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Dxel rëb Jesús loj reeman: ―Zian gunee juejs mal guin. ");
INSERT INTO zasNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Diidxgui Dios, ¿nid zagnëman bén guleman ya bén rbejdx rniab ree laaman dxej guiaal? ¿Wen zaglaa gagnëman laa reeman ya? ");
INSERT INTO zasNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Naj rni lëjt guial ad zaglaat gagnëman laa reeman. Per chi guiꞌt Bén guxhaal Dios, ¿chuj ni zadxaaglojraman bén rliladx Dios loj guidxliuj ya? ");
INSERT INTO zasNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Be Jesús zatijb cwent par ree bén naladx tijbzi laa reeman na̱j benzaꞌc guial loj ree ben ren, rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Tioꞌp ree xinguiaaw wej lën yadooroꞌ Jerusalén persi gurejdx gunab reex Dios, tijbix na̱j xinfarisew, zatijbix na̱j xin ruquijx impuest. ");
INSERT INTO zasNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Xin farisew guin, zaꞌlix cabejdx canabix Dios, rëbix: “Quixtëë runen lojl, Dad, guial ad najtan ziꞌc ree ben ren, na̱j reeman béngubaan, benmal, bén zaꞌnë béngunaa ren, niꞌqui ziꞌc na̱j bén ruquijx impuest guin. ");
INSERT INTO zasNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Rbaꞌnan tioꞌp volt lën xuman, abiꞌ gra ni rünan gan rünanan chii lalaꞌ persi runen tijban lojl.” ");
INSERT INTO zasNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Per xin ruquijx impuest guin, zijt zaꞌx abiꞌ niꞌquid rayaxtix guilies lojx, rgaꞌp luxdoox rëbgajx: “¡Dios, baya naj najn tijb xindol!” ");
INSERT INTO zasNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Naj rni lëjt guial xin ruquijx impuest guin ma been Dios laax perdon chi bayejc lidxix, per xin farisew guin ad beentaman laax perdon. Din bén rlies xvalor gajc achet lasajcaman loj Dios, guiáad bén rüjn naya laaman mazri lasajc loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Binë ree bejn xindoo ree lod zaꞌ Jesús din gudxiib yaaman guijc reex, per chi baguiaa ree xbejnman guzuloj cadilë reeman bén zinë ree laa reex. ");
INSERT INTO zasNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Per gurejdx Jesús laa reeman, rëbaman loj reeman: ―Gol badëë mod guiꞌt reex lon, ad bal rudxoondi, din lod rniabee Dios na̱j par ree bén na̱j ziꞌc laa reex. ");
INSERT INTO zasNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Din naj rni lëjt, bén ad rliladxt xguialrniabee Dios ziꞌc tijb xindoo, ad zileꞌt chuꞌman loj xguialrniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tijb xin rniabee, gunabdiidx loj Jesús rëbix: ―Mextrzaꞌc, ¿xhie rayal günan din gaꞌpan guialnaban tiblayaa con Dios? ");
INSERT INTO zasNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Badxiꞌ Jesús laan, rëbaman: ―¿Chexc zeel nal lon benzaꞌc? Achut na̱j benzaꞌc, tijbzi Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Lüj rajc ree mandamient: “Ad sunël béngunaa ren, ad gugüjtil bejn, ad cwanl, ad cwëël xtiidx bejn, gojp respejt xdad xniaal.” ");
INSERT INTO zasNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Dxel rëbix loj Jesús: ―Gra ree ni guin cayünan diizd xindoon. ");
INSERT INTO zasNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Chi biguiejn Jesús zian, rëbaman: ―Yuꞌ zatijb ni ryaadx güünl: bigtoꞌ gra ni rajpil dxel gudëël milia guin loj ree bénprob. Zian gapil guialnazaꞌc xanyabaa, dxel guiꞌtil guidnalil naj. ");
INSERT INTO zasNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Chi biguiejn xin guin zian, dád guyunayax guial dád xinrijcwan. ");
INSERT INTO zasNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Chi baguiaa Jesús guial dád yuꞌnayax, rëbaman: ―¡Dád nawëëg na̱j chuꞌ benrijcw loj xguialrniabee Dios! ");
INSERT INTO zasNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Adli nawëëgt tëd tijb camell xan gagux, guial chuꞌ tijb bén rijcw loj xguialrniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Abiꞌ ree bén biguiejn ni rëb Jesús, rëb reeman: ―¿Chu za zajc laa loj xcasti Dios? ");
INSERT INTO zasNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Dxel rëbaman loj reeman: ―Yuꞌ ni ad zajct güün bénguidxliuj, per Dios graczan zajc güünman. ");
INSERT INTO zasNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Dxel rëb Bëd lojman: ―Dad, ma basaꞌnan graczi ni rayaꞌpan persi zudnaalan lüj. ");
INSERT INTO zasNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Zianz rëb Jesús: ―Diidxliczi rnin lojdi, chutëëz bén rusaꞌn lidx, lacheel, bijch, o xdad, o xniaa, o xiꞌn guial rüjnman ziꞌc rniabee Dios, ");
INSERT INTO zasNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mazri zien ni tiaꞌman loj guidxliuj guie. Abiꞌ zajpaman guialnaban tiblayaa con Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Gurejdx Jesús guidxiptioꞌp ree xbejnman tiblad, abiꞌ rëbaman loj reeman: ―Yan, ziyoꞌ ree Jerusalén lod gac ziꞌc bacaa ree bén badëë xtiidx Dios loj ree bejn xcwent Bén guxhaal Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Yayü reeman laaman loj ree benzit, guzeꞌ reeman laaman, guiniee reeman laaman ni rëntzi reeman, abiꞌ gucojp xhiejn reeman lojman. ");
INSERT INTO zasNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Quin reeman laaman dxel gugüjt reeman laaman, per ni yayon dxej yabanman. ");
INSERT INTO zasNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Per laa reeman ad bigniaꞌtczi reeman ni rëbaman, ad ragbee tëët reeman chexc zeel rëbaman zian din ad bileꞌt nigniaꞌ reeman xhie rën guiëb ni guneeman. ");
INSERT INTO zasNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Chi ma cadxin Jesús gajxh guiedx Jericó, tijb bénlutiaꞌp, zojbaman cwëꞌ nejz rniabaman carda. ");
INSERT INTO zasNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Chi gogbeeman cadëd zien ree bejn, gunabdiidxaman xhie cayajc. ");
INSERT INTO zasNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Abiꞌ rëb reeman lojman guial Jesús bén Nazaret cadëd niz yagaj. ");
INSERT INTO zasNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Dxel gurixdiajman rëbaman: ―¡Jesús, xdiaa Davi, baya naj! ");
INSERT INTO zasNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bén ned ree rdilë reeman laaman din gucwëëz roꞌman, per mazri rbixdiajman, rëbaman: ―¡Xdiaa Davi, baya naj! ");
INSERT INTO zasNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Dxel guzudxe Jesús abiꞌ gunabeeman bicaꞌ reeman laaman. Chi bidxinman gajxh lojman, gunabdiidxaman lojman, rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Xhie rënl günan por lüj? Badxiꞌman laan rëbaman: ―Dad, rënan yani lon. ");
INSERT INTO zasNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Dxel rëb Jesús lojman: ―¡Ma zileꞌ guguiaal! Ma bayajquil guial bililadxil naj. ");
INSERT INTO zasNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Hor guin gajc bani loj bén guin, abiꞌ binalaman Jesús rudëëman quixtëë loj Dios. Në gra ree bén baguiaa ni goc rudëë quixtëë loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Guyu Jesús luguiedx Jericó abiꞌ guzuloj cadëdaman luguiedx guin. ");
INSERT INTO zasNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Yagaj zojb tijb benrijcw laman Zaqueo. Laaman rniabee ree bén ruquijx impuest. ");
INSERT INTO zasNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Rën Zaqueo guin güünbeeman Jesús, per ad rileꞌt guguiaaman laaman guial dád zien ree bejn abiꞌ laaman najman bendop. ");
INSERT INTO zasNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Zeel ruxüünman gunedaman, abiꞌ din chileꞌ guguiaaman Jesús, wëꞌpaman loj tijb yagroꞌ zojb gajxh lod tëd Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Chi gudëd Jesús yagaj, gules lojman abiꞌ rëbaman lojman: ―Zaqueo, cari baguiajt, din yandxej na̱j yayaꞌnan lidxil. ");
INSERT INTO zasNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Dxel cari daꞌt baguiajt Zaqueo, abiꞌ dád rabaaman zignëman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Chi baguiaa ree bejn zian, gra reeman guzuloj caneeguijdx Jesús rëb reeman zigyaꞌnman lidx tijb béndol. ");
INSERT INTO zasNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Dxel guzuli Zaqueo, abiꞌ rëbaman loj Jesús: ―Dad, gaguiꞌs garol ni raꞌpan loj ree bénprob. Abiꞌ bal yuꞌ bén baquijxan mazri guial loj ni na̱j quixaman, yayünan tajp volt mazri guial loj ni gulaanan. ");
INSERT INTO zasNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Dxel rëb Jesús lojman: ―Yandxej ma been Dios perdon gra ree bén zojb lidx Zaqueo guial rliladxaman Dios ziꞌcgajc Abraham. ");
INSERT INTO zasNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Din Bén guxhaal Dios zëëdaman zidgadiilaman bén ad zët ree loj xnejz Dios din laa reeman loj xcasti Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bén cucaagdiajg ree ni canee Jesús, beman tijb cwent loj reeman guial ma zë reeman gajxh Jerusalén abiꞌ laa reeman naladx reeman guial hor guin guidxin xguialrniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Dxel rëbaman loj reeman: ―Guyu tijb bejn, zëëdaman loj tijb famil zojbloj. Zëman zijt lod tiaꞌman guialrniabee din gacaman rey dxel yayejcaman nabee ladxaman. ");
INSERT INTO zasNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Chi gadaman grii gurejdxaman chii xmojsaman abiꞌ loj tijbgaj reex badëëman zroꞌ milia, zianz rëbaman loj reex: “Gol beennë milia guin dxiin xt chi guidxin dxej yaguialan.” ");
INSERT INTO zasNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Per ree bén ladxaman guial rdxeꞌch reeman laaman, guxhaal reeman tibcwaa ree bén zinal laaman persi biguiedx reeman guial ad rënt reeman gac bén guin xrey reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Per laaman bazuj reeman gacaman rey, abiꞌ bayejc ladxaman. Chi badxinman dxel gunabeeman bignee reeman mojs badëëman milia guin din gagbeeman plac ma been tijbgaj reex gan. ");
INSERT INTO zasNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mojs bidxin yaloj rëbix: “Dad, milia ni baneel ma beenan gan chii volt mazri.” ");
INSERT INTO zasNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Dxel rëb rey guin lojx: “Zagdxen mojszaꞌc, ma beenl ziꞌc rayal. Abiꞌ guial beenl ziꞌc rayal con taꞌnzi ni banen, yan guzun lüj nabeel chii guiedx.” ");
INSERT INTO zasNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Chi bidxin mojs barojp guin, rëbix: “Dad, milia ni baneel lon ma beenan gan gaay volt mazri.” ");
INSERT INTO zasNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ziangajc rëb rey guin loj mojs guin: “Lüj nabee gaay guiedx.” ");
INSERT INTO zasNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Dxel bidxin zatijb mojs guin abiꞌ rëbix: “Dad, laa xmilial guie, badxeꞌchaawanan lën tijb baydoo, ");
INSERT INTO zasNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","din bidxeban lüj guial ad rayatil bejn. Racaꞌl ni ad najt xieenl abiꞌ ratoꞌpil guialnazaꞌc lod ad guxübintil.” ");
INSERT INTO zasNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Dxel rëb rey guin: “Mojs guijdx por xtiidxgajquil rayalil casti. Bal ragbeel guial ad rayatan bejn, abiꞌ racaꞌn ni ad najt da xieenan ratop tëën guialnazaꞌc lod ad guxübintan. ");
INSERT INTO zasNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Chexc ad badëëtil da milian niguiꞌn bejn din chi naguialan nacaꞌnan con guidib xiꞌnan?” ");
INSERT INTO zasNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Dxel rëb rey guin loj ree bén zaꞌ yagaj: “Gol bacaꞌ milia zii lojx, gol badëëdan loj xin caꞌ mazran.” ");
INSERT INTO zasNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Abiꞌ rëb reeman loj rey guin: “Dad, per ma caꞌx zroꞌn.” ");
INSERT INTO zasNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Badxiꞌman laan rëbaman: “Bén rajp zroꞌ, zacaꞌman mazri, per bén rajp taꞌnzi, xt taꞌn ni rajpaman chiquied lojman. ");
INSERT INTO zasNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Abiꞌ ree bén rdxeꞌch naj bén ad guyënt ree niajcan rey, gol tanë reeman guie, gol bagüjt reeman lon.” ");
INSERT INTO zasNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Chi gulox rëb Jesús zian, dxel basnuu zëman Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Chi bidxinman gajxh guiedx Betfagé con Betania, në gajxh guiaꞌ la Olivos, dxel guxhaal tioꞌp ree xbejnman, ");
INSERT INTO zasNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","rëbaman loj reeman: ―Gol chej guiedxdo rigaꞌ guin, chi guidxindi guidxaaglojdi tijb burquieꞌn, caduub, achut wabib laab. Gol guxhiequib gol tanëb. ");
INSERT INTO zasNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Abiꞌ bal chu guiniabdiidx lojdi chexc zeel rxhiequidi laab, gol güjdx Dad Jesús cayaadx laab. ");
INSERT INTO zasNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Wej ree bén guxhaalaman bidxaagloj gajc reeman ziꞌcgajczi rëb Jesús loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Abiꞌ chi caxhiec reeman bur guin, gunabdiidx ree bén na̱j xbur laab, rëb reeman: ―¿Chexc zeel caxhiequidi bur guin? ");
INSERT INTO zasNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Badxiꞌ reeman laan, rëb reeman: ―Din Dad Jesús cayaadx laab. ");
INSERT INTO zasNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Dxel binë reeman bur guin lod zaꞌ Jesús, zianz badxiib xab reeman xijchib abiꞌ been reeman laaman yudar persi gudxibaman laab. ");
INSERT INTO zasNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Abiꞌ ree bejn rguijxh xab reeman lunejz lod zë Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Chi ma zë reeman gajxh laguiajt ni na̱j guiaꞌ la Olivos, gra ree bén zinal Jesús guzuloj rbixdiaj reeman guial dád rabaa reeman abiꞌ ruzaꞌt reeman Dios zagdxe por gra ree milagr ni ma baguiaa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Rëb reeman: ―¡Nüjnleꞌ Dios bén zëëd por laaman! ¡Yuꞌ guialrabaa xanyabaa! ¡Benzaꞌc bendxoon na̱j Dios bén yuꞌ xanyabaa! ");
INSERT INTO zasNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Dxel ree bénfarisew noꞌch loj ree bén zinal laaman, rëb reeman lojman: ―Mextr, gudilë ree bén guin chitëë rniee reeman zian. ");
INSERT INTO zasNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Per badxiꞌman laan rëbaman: ―Naj rni lëjt, bal yacwëëz roꞌ reeman, guiaj ree cwixdiaj zian. ");
INSERT INTO zasNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Chi bidxinman gajxh Jerusalén, dxel baguiaaman guiedx guin, zianz biinman por laan. ");
INSERT INTO zasNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Rëbaman: ―¡Bén Jerusalén, xi nix majsi yandxejzi yayagbeedi chu yabeꞌcdxe luxdoodi! Per yan naguieꞌch najn par lëjt, ad zileꞌt chigniaꞌdi laan. ");
INSERT INTO zasNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Din guidxin dxej ni güün ree bén rdxeꞌch lëjt tijb zeꞌ gadëd ladxidi, abiꞌ gra lad gusiaaw reeman lëjt, ");
INSERT INTO zasNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","gugüjt reeman lëjt. Dxel gunijt reeman ladxidi, niꞌqui tijb guiaj ad zayaꞌnt guijc stijb guiaj, din ad bidxgaꞌtidi hor ni bidganaj Dios lëjt. ");
INSERT INTO zasNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Chi bidxin Jesús roꞌ yadooroꞌ Jerusalén, guzuloj caybëëman bén cutoꞌ ree në ree bén cazii, ");
INSERT INTO zasNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","rëbaman loj reeman: ―Loj xtiidx Dios rëb: “Lidxan na̱j yu lod rbejdx rniab bejn Dios.” Per lëjt nüjndan ziꞌc lidx ree xingubaan. ");
INSERT INTO zasNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Guixie guixie rulüü Jesús bejn ree lën yadooroꞌ Jerusalén, per ree bixhioz rniabee ree bixhioz con ree mextr rajc ley, në ree guxtis luguiedx guin raguiil reeman mod din gugüjt reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Per ad radxejlt xhienaag güün reeman, din graczi ree bejn rucaagdiajg chaaw ni rulüüman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lën ree dxej ni zaꞌ Jesús lën yadooroꞌ Jerusalén, culüüman bejn ree xtiidx Dios, bidxin ree bixhioz rniabee ree bixhioz, con ree mextr rajc ley, në ree guxtis Israel, ");
INSERT INTO zasNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","abiꞌ rëb reeman lojman: ―Guna, ¿chu na güünl ni guin ree? ¿Chu banee guialrniabee lojl? ");
INSERT INTO zasNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Badxiꞌ Jesús laan, rëbaman: ―Ziangajc naj yuꞌ tijb ni ganabdiidxan lojdi. Gol badxiꞌn: ");
INSERT INTO zasNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿chu guxhaal Waj bidgaroobnijsaman bejn ree, Dios ya o bénguidxliuj? ");
INSERT INTO zasNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dxel guzuloj rëb loj lasaꞌ reeman: ―Bal yaguieꞌch ree Dios guxhaal laaman, zanaman. “¿Chexquiza zeel ad bililadxtidi laaman?” ");
INSERT INTO zasNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Abiꞌza bal yaguieꞌch ree bénguidxliuj guxhaal laaman, zugüjt ree bejn dunuj ree con guiaj din gra reeman rliladx guial Waj gojc bén badëë xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Abiꞌ badxiꞌ reeman laan rëb reeman guial ad ragbeet reeman chu guxhaal Waj bidgaroobnijsaman bejn ree. ");
INSERT INTO zasNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Dxel rëb Jesús loj reeman: ―Niꞌqui naj ad zanitan lojdi chu banee guialrniabee günan ni guin ree. ");
INSERT INTO zasNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Dxel guzuloj cayü Jesús tijb cwent loj ree bejn, rëbaman: ―Guyu tijb bejn guxübinman uv ree loj xguiniaaman, dxel badëëman laan garol loj ree bén güün dxiin lojn, zëtaman zijt. ");
INSERT INTO zasNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Chi bidxin dxej yalaꞌ reeman uv guin, guxhaalaman tijb xmojsaman chigxiix ni rayalaman, per ree bén rüjn dxiin loj guiniaa guin gudijn reeman mojs guin abiꞌ badxiꞌ reeman laax zezi. ");
INSERT INTO zasNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Dxel guxhaalaman mojs ren, per nëgajc mojs guin gunee reeman ni rëntzi reeman, gudijn reeman laax abiꞌ badxiꞌ reeman laax zezi. ");
INSERT INTO zasNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Zianz guxhaalaman zatijbix, per gudiilguijdx reeman laax abiꞌ babëë reeman laax loj guiniaa guin. ");
INSERT INTO zasNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Dxel rëb bén na̱j xguidxliuj laan: “¿Xhienaag günan yan? Gaxhal da xiꞌnan xin rën daꞌtan, wed zajp reeman laax respejt.” ");
INSERT INTO zasNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Per chi baguiaa ree bén guin laax, rëb loj lasaꞌ reeman: “Xin guinan na̱j xin yayaꞌnnë guidxliuj guin. Yagüjt reex din gacan du xieen ree.” ");
INSERT INTO zasNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Dxel babëë reeman laax loj guidxliuj guin, bagüjt reeman laax. Zianz gunabdiidx Jesús loj ree bén caneenëman, rëbaman: ―Yan, ¿xhie naladxidi güünnë bén na̱j xguidxliuj laan bén guin ree? ");
INSERT INTO zasNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Naj rni lojdi guial ziꞌtaman din gugüjtaman bén guin ree dxel gudëëman guidxliuj guin loj ree ben ren. Chi biguiejn reeman zian dxel rëb reeman: ―¡Gagnë Dios ad zajct zian! ");
INSERT INTO zasNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Per Jesús baguiaaman loj reeman, abiꞌ rëbaman: ―Bal id zajc zian ¿xhieza rën guiëb ni ca loj xtiidx Dios? Lod rëb: Guiaj ni gulëëgoꞌn ree bén rüjn yu, laan na̱j ni mazri been sirv gojcnë yu guin. ");
INSERT INTO zasNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Chutëëz bén yab guijc guiaj guin, gacaman ziꞌc tijb ni riroox, guiáad bal yab guiaj guin guijcaman, gacaman ziꞌc tijb ni ryüüdëj. ");
INSERT INTO zasNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bixhioz rniabee ree bixhioz con ree mextr rajc ley, hor guin gajc guyën reeman niniaaz reeman Jesús guial gogbee reeman cuzaꞌtaman laa reeman, per bidxeb reeman bejn ree. ");
INSERT INTO zasNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Abiꞌ guxhaal reeman bén ziglaꞌch ree laaman din güünzi reeman guial gulüü na̱j reeman benzaꞌc, din yaguiil reeman mod guiniee Jesús diidx ni gudxiib reeman guijc, din chileꞌ yayü reeman laaman loj gobernador Rom. ");
INSERT INTO zasNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Dxel gunabdiidx reeman lojman, rëb reeman: ―Mextr, dunujn rayagbee guial rnieel rulüü tëël ziꞌc rayal, din par lüj tiblojzi na̱j bejn, abiꞌ walil rulüül guial xhienaag rën Dios guiban bejn. ");
INSERT INTO zasNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Zagdxen ya radijxan impuest loj rey César, o ad zagdxetan? ");
INSERT INTO zasNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Per gogbee gajc Jesús xgab mal ni cayüjn reeman abiꞌ rëbaman loj reeman: ");
INSERT INTO zasNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―Gol balüü tijb cintabl lon. ¿Chu loj ca lojn chu tëë laj ca lojn? Badxiꞌ reeman laan, rëb reeman: ―Loj rey César ca lojn në lajman. ");
INSERT INTO zasNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Dxel rëbaman loj reeman: ―Gol badëëcliza loj rey César ni na̱j xieen César, guiáad loj Dios gol badëë ni na̱j xieen Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Abiꞌ gra ni guneeman niz loj ree bejn, achetri badxejl nudxiib reeman guijc din niniaaz reeman laaman. Badxali loj reeman ni guneeman abiꞌ achetri rëb reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tioꞌp choon ree bénsaducew bignaj Jesús, bénsadusew guin ree ad rliladxt reeman guial yaban ree bengüt, zeel rëb reeman loj Jesús: ");
INSERT INTO zasNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Mextr, loj xley Moisejs rëb guial bal guiët tijb xinguiaaw abiꞌ achut xiꞌnx guyu con lacheelix, bijch xingüt guin guxhliaanë béngunaa bizëjb guin din chuꞌ xiꞌn reex ziꞌc gulüü xiꞌn xin güt guinan. ");
INSERT INTO zasNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Guyu tijb famil lod goc reex gajdx bijch. Baxhliaa xin yaloj guin, per güjtix abiꞌ ad guyut xiꞌn reex con lacheelix. ");
INSERT INTO zasNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Dxel bijch barojpix baxhliaanë béngunaa guin, per güjtgajquix ad guyu gajct xiꞌn reex. ");
INSERT INTO zasNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Zianz baxhliaanë xin bayon guin béngunaa bizëjb guin, zianz baxhliaanëman guigajdx reex abiꞌ gra reex güjt achut xiꞌn reex guyu con laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ni bigratë në béngunaa guin güjt. ");
INSERT INTO zasNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Yan, chi yaban ree bengüt, ¿chu loj guigajdx reex gac xbéngunaa laaman guial gra reex baxhliaanë laaman? ");
INSERT INTO zasNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Dxel rëb Jesús loj reeman: ―Loj guidxliuj guie ruxhliaa ree bejn abiꞌ rudëëd xiꞌn reeman ruxhliaa. ");
INSERT INTO zasNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Per ree bén yaban zatijb, bén rayal ree gap guialnaban tiblayaa con Dios, ad zuxhliaatri reeman ad zudëë tëëtri xiꞌn reeman guxhliaa, ");
INSERT INTO zasNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","din ad zëjttri reeman, gac reeman ziꞌc ree xianjl Dios. Gac tëë reeman xiꞌn Dios guial ma baban reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Abiꞌ xcwent ni yaban ree bengüt, xt Moisejs rëb zian tiblajt loj xtiidx Dios lod rëbaman guial baguiaaman yag ni cayeꞌc. Yagaj rëb Dios lojman guial Dios na̱j xDios Abraham, xDios Isaac, në xDios Jacob. ");
INSERT INTO zasNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Din Dios ad najtaman xDios ree bengüt, najman xDios ree bén naban, din par laaman gra ree bejn naban. ");
INSERT INTO zasNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Dxel yuꞌ ree mextr rajc ley, rëb lojman: ―Mextr, zagdxequi guneel. ");
INSERT INTO zasNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Abiꞌ achetri bayax reeman niniabdiidx reeman lojman. ");
INSERT INTO zasNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Rëb Jesús loj ree bejn: ―¿Chexc zeel rëb ree bejn guial zëëd Cristo loj xdiaa rey Davi? ");
INSERT INTO zasNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Awa Davi guin gajc gunee loj libr Salmos, rëbaman: Dios rëb loj dux Dad ree: “Gurej da ladbeen, ");
INSERT INTO zasNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","xt gabecan xin rdxeꞌch ree lüj guiaꞌl.” ");
INSERT INTO zasNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Yan, bal xiꞌn Davi na̱j Cristo. ¿Chexquiza zeel rëb Davi guin lojman Dad? ");
INSERT INTO zasNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Laꞌtgaj cucaagdiajg gra ree bejn ni rëb Jesús, rëb loj ree xbejnman: ");
INSERT INTO zasNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Gol gojp cudad con ree mextr rajc ley. Din ruladx reeman sa reeman gacw reeman lajd zagdxe ruladx tëë reeman gugajpdioz ree bejn laa reeman con respejt niz lunejz, abiꞌ lën ree yadoo ruladx reeman cwe reeman lod rbej ree bén zojbloj, ziangajc rüjn reeman lod ritaw reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Racaꞌ tëë reeman lidx ree béngunaa bizëjb, abiꞌ din guiëb ree bejn guial benzaꞌc na̱j reeman, dád xchej rbejdx rniab reeman Dios. Per laa reeman mazri casti naroob yayal reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Chi culüü Jesús bejn ree lën yadooroꞌ Jerusalén, dxel gules lojman baguiaaman caguꞌ ree benrijcw gon lën alcancia. ");
INSERT INTO zasNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Baguiaa tëëman tijb béngunaa bizëjb prob, caguꞌman tioꞌp cintabldoo lën alcancia guin. ");
INSERT INTO zasNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Dxel rëb Jesús loj ree xbejnman: ―Diidxli rnin lojdi guial bén bizëjb prob guin mazri lasajc gon badxeꞌman guial loj gon badxeꞌ gra ree bén guin. ");
INSERT INTO zasNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Din graczi reeman rudxeꞌ ni rüjn laa reeman sobr, per laaman majsi najman bénprob, badxeꞌman graczi ni rajpaman par guibannëman. ");
INSERT INTO zasNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tioꞌp choon ree xbejn Jesús cayü reeman diidx xcwent ree guiaj zagdxe najcchaawnë yadooroꞌ Jerusalén, në ree ni lasajc ni rudëëd ree bejn par suchaaw yadoo guin. Dxel rëb Jesús loj reeman: ");
INSERT INTO zasNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Gra ni cuguiaadi yan, zadxin dxej niꞌqui tijb guiaj ad zayaꞌnt guijc stijban, gran yazeꞌn. ");
INSERT INTO zasNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Dxel gunabdiidx reeman lojman rëb reeman: ―Mextr, ¿goc gac zian? ¿Xhie ree sen gac chi ma zidyob gac zian? ");
INSERT INTO zasNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Zianz rëb Jesús loj reeman: ―Gol gojp cudad achu gusquiee lëjt. Din zien ree bén guiꞌt guiëb reeman guial por naj zëëd reeman guiëb tëë reeman: “Naj na̱j Cristo”; o “Ma zidyob dxej guiꞌtaman.” Per ad chililadxidi laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Abiꞌ chi guiguiejndi cayajc wadijl o chas ree bejn contr xguxtis reeman, ad guidxebidi din yaloj gac zian. Per ad por laatan ma bidxin dxej nit guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Rëb tëë Jesús loj reeman: ―Til nacion con stijb nacion, til tëë bén rajp guialrniabee con stijb bén rajp guialrniabee, ");
INSERT INTO zasNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","guiꞌt tëë xudoxh, në gubijn, në guialguijdxdoxh niz ni niz guie abiꞌ xanyabaa guiguien ree ni nadxeb. ");
INSERT INTO zasNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Per chi gad gra ree ni guin gac, guiniaaz ree bejn lëjt din gusagzi reeman lëjt, chinë reeman lëjt lën ree yadoo din gudëëd reeman lëjt casti, cuꞌ reeman lëjt ladxguiib chinë tëë reeman lëjt loj ree rey në loj ree gobernador guial najdi da bejnan. ");
INSERT INTO zasNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Zian gac din chileꞌ güdi da diidxan loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ad aal chuꞌdi xgab xhie guiëbidi loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Din naj gune diidx ni guinieedi gune tëën quiarguiejn. Abiꞌ niꞌqui tijb bén rdxeꞌch lëjt ad züjnt gan loj xtiidxidi ad zanee tëët reeman contr lëjt. ");
INSERT INTO zasNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Per lëjt xt xdadidi o xniaadi, o bijchidi o xfamilidi o xmiwidi yayü reeman lëjt, abiꞌ yuꞌdi gugüjt reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Gra bénguidxliuj guidxeꞌch lëjt guial najdi da bejnan. ");
INSERT INTO zasNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Per niꞌqui tijb guidxguijquidi ad zanijtt por zian. ");
INSERT INTO zasNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Abiꞌ bal sudxiꞌchidi loj xnejz Dios, zajpidi guialnaban tiblayaa con Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Chi guguiaadi nayaw ree suldad Jerusalén, ma qui nit guiedx guin. ");
INSERT INTO zasNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Dxejzii ree, bén zaꞌ ree niz Judea, gol bigxüün niz dajn ree, abiꞌ ree bén zaꞌ guiedx Jerusalén gol brii luguiedx guin, guiáad ree bén zaꞌ dajn ad bal yayudi luguiedx guin. ");
INSERT INTO zasNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Din dxej guin ree gudëëd Dios bejn ree casti din gac cumplid ziꞌc ca loj xtiidxaman. ");
INSERT INTO zasNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Probza ree béngunaa nüü xiꞌn o béngunaa caꞌ ree xindobëz lën ree dxejzii! Din dád sagdiaj ree bejn abiꞌ dád casti naroob yayal ree bénluguiedx guin. ");
INSERT INTO zasNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Yuꞌ ree bén guiët loj wadijl yuꞌ tëë reeman guiniaaz reeman chinë naguiejn reeman laa reeman nacion rent nacion ren ree. Abiꞌ ree benzit zanabee reeman Jerusalén xt yayaaloj dxej ni tiëb Dios nabee reeman yagaj. ");
INSERT INTO zasNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Dxel gac sen loj gubijdx, con loj bëëw, con loj ree bajl xanyabaa. Abiꞌ loj guidxliuj gagdxa ree bejn guidxeb tëë reeman guial gac naquieꞌ loj nijsdoo gac tëë naquieꞌ por xtüjp nijs. ");
INSERT INTO zasNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Abiꞌ ree bejn xt yadaj reeman guial guidxeb reeman chi güün reeman xgab ni gac loj guidxliuj, guiáad ree ni rguien xanyabaa guiniib reen. ");
INSERT INTO zasNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Abiꞌ guguiaa reeman Bén guxhaal Dios, rdiinman bachaꞌ zëëdaman loj za̱j con xguialrniabeeman. ");
INSERT INTO zasNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Chi suloj gac ree ni guin, gol baguꞌ luxdoodi zagdxe gol gules tëë lojdi din ma zidyob dxej ni laadi loj casti. ");
INSERT INTO zasNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Rëb tëë Jesús loj reeman: ―Gol baguiaa yag higo o xhietëëz zatijb yagan. ");
INSERT INTO zasNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Chi ma caydxib ree xbalagan, lëjt ragbee guial ma zëëd tiamp nalaa. ");
INSERT INTO zasNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ziangajc chi guguiaadi ma cayajc ree ni guin, zagbeedi guial ma zëëd xguialrniabee Dios gajxh. ");
INSERT INTO zasNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Diidxli rnin lojdi guial gra ree ni guin gac chi gad gra ree bén naban yan guiët. ");
INSERT INTO zasNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Guidxliuj në xanyabaa zanijt reen, per da diidxan ad zadëdt gacan cumplid. ");
INSERT INTO zasNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Gol gojp cudad ad güün graloj ni rigaꞌ loj guidxliuj guie lëjt gan, ziꞌc guial rzüdx, në guial ru xgab por ni ryaadxidi par guibandi din chi guialan zatijb, ad gac dxej guin par lëjt ");
INSERT INTO zasNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ziꞌc tijb tramp. Din zian gac dxej guin par gra ree bénguidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Gol guzujsin, guixie guixie gol gurejdx gunab Dios din gac laadi loj gra ree ni gac loj guidxliuj din chileꞌ tëë sudi loj Bén guxhaal Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Radxe rulüü Jesús bejn ree lën yadooroꞌ Jerusalén guiáad guxhin rayaꞌnman ruguiaꞌ la Olivos. ");
INSERT INTO zasNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Abiꞌ rsildoo rej gra ree bejn lën yadoo guin ricaagdiajg reeman ni rnieeman. ");
INSERT INTO zasNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Chi ma zidyob lanij pascw, chi raw reeman guiadxtil ni ad yuꞌt levadur. ");
INSERT INTO zasNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bixhioz rniabee ree bixhioz con ree mextr rajc ley, raguiil reeman mod xhienaag gugüjt reeman Jesús guial rdxeb reeman bejn ree. ");
INSERT INTO zasNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Dxel guyu xindxab luxdoo tijb ree xi apóstoles Jesús, bén la Judas Iscariote. ");
INSERT INTO zasNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas guin bigneenë bixhioz rniabee ree bixhioz con ree bén rniabee bén rajp ree yadooroꞌ Jerusalén, abiꞌ benëman laa reeman diidx xhienaag yayüman Jesús loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Dád babaa reeman abiꞌ rëb reeman guial gudëëd reeman milia lojman. ");
INSERT INTO zasNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Zianz cwëjbaman, dxel guzuloj raguiilaman mod xhienaag yayüman Jesús, guial ad zagbeet ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Chi bidxin lanij pascw, tijbgaj yu raw ree bejn guiadxtil ni ad yuꞌt levadur rugüjt tëë reeman tijb xiil, ");
INSERT INTO zasNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","dxel guxhaal Jesús Bëd con Waj, rëbaman loj reeman: ―Gol biguieen ni yadaaw ree guxhin pascw. ");
INSERT INTO zasNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Abiꞌ gunabdiidx reeman lojman rëb reeman: ―¿Ban guin rënl yuguieenan laan? ");
INSERT INTO zasNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Zianz rëb Jesús loj reeman: ―Chi chuꞌdi luguiedx guin, guguiaadi tijb xinguiaaw caꞌx tijb re yuꞌ nijs. Gol chinalix xt lod yayux, ");
INSERT INTO zasNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","gol güjdx loj bén na̱j lidxan: “Na mextr: ¿Con lënü gawnë ree xbejnman guxhin pascw?” ");
INSERT INTO zasNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Dxel gulüüman lëjt tijb lënü ni rarojp pijs, ma najcchaaw lënü guin. Yagaj gol been ni yadaaw ree xche. ");
INSERT INTO zasNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Zianz wej reeman abiꞌ bidxaagloj reeman gra ziꞌcgajczi rëb Jesús loj reeman. Dxel been reeman guialraw guin ni gaw reeman guxhin pascw. ");
INSERT INTO zasNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Chi bidxin hor, Jesús con ree bén na̱j apóstoles gurej reeman xan mex. ");
INSERT INTO zasNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Dxel rëbaman loj reeman: ―¡Diizd gocli rënan gawnëꞌn lëjt pascw guie, chi gad dxej guidxin gazaagdiajn abiꞌ guiëtan! ");
INSERT INTO zasNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Din naj rni lëjt guial ad yuꞌtri dxej gawnëꞌn lëjt, xt chi ma canabee Dios guidiblagaa. ");
INSERT INTO zasNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Dxel cwaꞌman tijb cojp yuꞌ vin, chi gulox badëëman quixtëë loj Dios, rëbaman loj reeman: ―Gol cwaꞌ vin guie, gol gudiꞌsan loj gradi. ");
INSERT INTO zasNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Din diidxli rnin lëjt, ad yuꞌtri dxej guiëꞌn vin xt chi ma canabee Dios guidiblagaa. ");
INSERT INTO zasNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Dxel cwaꞌman guiadxtil badëëman quixtëë loj Dios, zianz gulaꞌman laan, gudiꞌsaman laan loj reeman, rëbgajman: ―Guiadxtil guie na̱j da cuerpan ni ma bayün din guiëtan por lëjt. Chi güündi zian, gol been zian guial rusaaladxidi naj. ");
INSERT INTO zasNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Abiꞌ ziangajc beenman con cojp ni yuꞌ vin guin, chi gulox gudawaman xche, rëbaman: ―Vin guie na̱j da rejnan ni gaxhieꞌn chi guiëtan din guixal tijb nejz cüb xhienaag gap ree bejn perdon loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Per yan bén yayü naj, laa yaaman xoob loj mex lod xoob gajc yan. ");
INSERT INTO zasNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Per Bén guxhaal Dios, na̱j sagdiajman abiꞌ guiëtaman. Per ¡probza bén yayü laaman! ");
INSERT INTO zasNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Dxel guzuloj rniabdiidx loj lasaꞌ reeman chu reeman yayü laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Dxel guzuloj reeman cadildiidx reeman chu loj gra reeman na̱j mazri bén zojbloj. ");
INSERT INTO zasNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Per rëb Jesús loj reeman: ―Bén na̱j ree rey loj guidxliuj guie rniabee reeman bén ladx reeman ziꞌctzi rën reeman, abiꞌ ree bén rniabee, rëb reeman guial rüjn reeman ni zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Per lëjt ad rayalt güündi zian, bén mazri zojbloj lojdi rayal güün laagajcaman ziꞌc tijb bén ad zojblojt. Guiáad bén rniabee lojdi rayal güün laagajcaman ziꞌc tijb mojs. ");
INSERT INTO zasNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Chu na̱j mazri bén zojbloj loj guidxliuj guie? ¿Bén rbej xan mex par gaw ya o bén rbeꞌc guialraw? ¿Nid bén rbej xan mex guin na̱j mazri bén zojbloj ya? Guiáad naj zaꞌn lojdi ziꞌc tijb bén rbeꞌc guialraw. ");
INSERT INTO zasNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Lëjtczi zaꞌnë naj loj ree dxej cazaagdiajn. ");
INSERT INTO zasNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Zeel gunen guialrniabee lojdi ziꞌc banee da Dadanan lon, ");
INSERT INTO zasNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","abiꞌ gawidi loj da mexan lod ganabeen cwe tëëdi loj ree yagxhil lod güündi guialguxtis loj gra ree bén za loj guidxiptioꞌp xdiaa Israel. ");
INSERT INTO zasNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Rëb tëë Jesús: ―Simón, Simón, ma gunab xindxab lëjt din güünx lëjt prueb ziꞌc rbijb bejn trigo. ");
INSERT INTO zasNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Per naj ma guredx gunaaban Dios por lüj chitëë cwëz chililadxil naj. Guiáad lüj chi yazudxiꞌchil loj ni rliladxil naj zatijb, gognë ree lasaꞌl din sudxiꞌch reeman loj ni rliladx reeman naj. ");
INSERT INTO zasNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Dxel rëb Bëd lojman: ―Dad, ad zaroꞌnladxtan lüj majsi gayuꞌnëꞌn lüj ladxguiib o xt guiëtnëꞌn lüj. ");
INSERT INTO zasNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Abiꞌ rëb Jesús: ―Naj rni lüj Bëd, yan guxhin gajc chi gad gui̱d cwidxaꞌ, choon volt mal rëbil ad nünbeetil naj. ");
INSERT INTO zasNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Dxel gunabdiidx Jesús loj ree xbejnman rëbaman: ―Chi guxhalan lëjt sin bols, sin milia, në sin gurëch, ¿yuꞌ ni biaadxidi ya? Badxiꞌ reeman laan rëb reeman: ―Achet. ");
INSERT INTO zasNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Dxel rëbaman loj reeman: ―Saꞌn yan bén rajp milia në bols, gol cwaꞌn. Guiáad bén ad rajpt espad, gol batoꞌ xabidi din siidi tijban. ");
INSERT INTO zasNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Din naj rni guial rüjn naguiejn gac ziꞌc rëb loj xtiidx Dios por naj, lod rëb: “Abiꞌ nayabaman loj ree benmal.” Gra ni ca loj xtiidx Dios por naj, na̱j gacan cumplid. ");
INSERT INTO zasNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Dxel rëb reeman lojman: ―Dad, guie nacaꞌn tioꞌp espad. Badxiꞌman laan rëbaman: ―Zajquican. ");
INSERT INTO zasNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Dxel brii Jesús ziꞌc na̱j xcostumbraman zëman ruguiaꞌ Olivos, abiꞌ binal ree xbejnman laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Chi bidxin reeman yagaj, rëbaman loj reeman: ―Gol gurejdx gunab Dios, chitëë güün xindxab lëjt gan. ");
INSERT INTO zasNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Abiꞌ wejman zijt ziꞌct lod rucaa bejn tijb guiaj, zianz bazuxibaman gurejdx gunabaman Dios, ");
INSERT INTO zasNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","rëbaman: ―Dad, bal tiëbil, babëë naj loj ni gazaagdiajn per ad gac ziꞌc rënan, rayal gac ziꞌc rënl. ");
INSERT INTO zasNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Dxel balüüloj tijb anjl guza xanyabaa lojman persi badëëman laaman gojl. ");
INSERT INTO zasNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Abiꞌ chi cazagdiaj daꞌtaman, mazri con gan cabejdx canabaman Dios ryajb tëë ree xnijs ragneeyaman luyuj ziꞌc rejn. ");
INSERT INTO zasNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Chi bisuman lod cabejdx canabaman Dios, bignaj ree xbejnman abiꞌ chi badxinman cwëꞌ reeman laa reeman nagaꞌyëjs, guial yuꞌnaya reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Zianz rëbaman loj reeman: ―¿Chexc zeel nagaꞌyëjsidi? Gol bixche, gol gurejdx gunab Dios chitëë güün xindxab lëjt gan. ");
INSERT INTO zasNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sta caneenë Jesús bén na̱j ree xbejnman chi bidxin ree benzien. Në bén brii laj Judas, bén goc tijb ree xbejn Jesús, nedaman loj ree bén guin abiꞌ bibigaman loj Jesús gudawaman laaman xid. ");
INSERT INTO zasNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Dxel rëb Jesús lojman: ―Judas, ¿wen con tijb xid rayül Bén guxhaal Dios ya? ");
INSERT INTO zasNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Chi baguiaa ree bén zaꞌnë Jesús ni cayajc, rëb reeman lojman: ―Dad, ¿zalëë dux espadan ya? ");
INSERT INTO zasNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Abiꞌ tijb xbejnman gudiilguijdxaman xmojs bixhioz rniabee gra ree bixhioz, gutüꞌman guidiajg ladbeeman. ");
INSERT INTO zasNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Per rëb Jesús loj reeman: ―Guzujr ree bénan. Ma gojczi. Dxel baquiꞌ Jesús guidiajg mojs guin abiꞌ bayüjnman laan. ");
INSERT INTO zasNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Zianz rëb Jesús loj ree bixhioz rniabee ree bixhioz, con ree bén rniabee ree bén rajp yadooroꞌ Jerusalén con xguxtis ree bén Israel, bén bidxin ree par chinë laaman: ―¿Chexc zeel zëëdidi con espad con yag din chinëdi naj ziꞌc tijb xingubaan? ");
INSERT INTO zasNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Guixie guixie guzunëꞌn lëjt lën yadooroꞌ Jerusalén abiꞌ ad gunaaztidi naj. Per yan ma bidxin xihoridi, hor ni nabee xindxab. ");
INSERT INTO zasNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dxel gunaaz reeman Jesús zinë reeman laaman lidx bixhioz rniabee gra ree bixhioz, binal Bëd laaman zijt zijt. ");
INSERT INTO zasNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yagaj guleꞌc ree bén guin guij galay luleꞌ, abiꞌ gurej reeman rudëj guin. Në Bëd gurejnë laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Per tijb béngunaa rüjn dxiin yagaj, chi baguiaaman Bëd zojbaman rudëj guin, baguiaaman lojman, abiꞌ rëbaman: ―Në bén guin zaꞌnë Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Per gurexuu Bëd, abiꞌ rëbaman loj bén guin: ―Ad nünbeetan laax. ");
INSERT INTO zasNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ad gojct xchej chi baguiaa zatijb bejn laaman, rëbaman lojman: ―Në lüj na̱j xbejn Jesús. Badxiꞌ Bëdan rëbaman: ―Yajqui dad, ad xbejntix naj. ");
INSERT INTO zasNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Gudëd cost tib hor, dxel rëb zatijb bejn: ―Nëczi bén guie zaꞌnë laaman din nëman na̱j bén Galilea. ");
INSERT INTO zasNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Zianz rëb Bëd: ―Ad ragbeetan xhienin rnieel. Hor ni canee gajc Bëd zian guridxaꞌ tijb gui̱d. ");
INSERT INTO zasNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Dxel badxiꞌ loj Jesús baguiaaman loj Bëd, abiꞌ basaaladx Bëd guial rëb Jesús lojman: “Yan guxhin gajc chi gad gui̱d cwidxaꞌ, choon volt mal rëbil ad nünbeetil naj.” ");
INSERT INTO zasNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Dxel barii Bëd yagaj, abiꞌ dád naya biinman. ");
INSERT INTO zasNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bén cayajp ree Jesús, bazeꞌ reeman laaman gudijn tëë reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Guxhii reeman lojman abiꞌ gudijn reeman laaman, dxel rëb reeman lojman: ―¡Guneeyaꞌ chu gudin lüj! ");
INSERT INTO zasNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Abiꞌ zien ree diidxguijdx rëb reeman lojman. ");
INSERT INTO zasNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Chi bareguiaal, badxajg lasaꞌ ree guxtis Israel, në ree bixhioz rniabee ree bixhioz con ree mextr rajc ley, abiꞌ binë reeman Jesús lod radxaag lasaꞌ gra ree xguxtis reeman, dxel rëb reeman lojman: ");
INSERT INTO zasNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Guna du lojn, ¿lüj na̱j Cristo ya? Badxiꞌman laan rëbaman: ―Bal ganinan ad zaliladxtidi. ");
INSERT INTO zasNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Abiꞌ bal xhie ganabdiidxan lojdi, ad zadxiꞌtidan. ");
INSERT INTO zasNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Per diizd yan, Bén guxhaal Dios cweman xladbee Dios, bén caꞌ gra guialrniabee. ");
INSERT INTO zasNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Dxel rëb gra reeman lojman: ―¿Lüjn na̱j Xiꞌn Dios ya? Badxiꞌman laan, rëbaman: ―Waliquidi najcan. ");
INSERT INTO zasNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Zianz rëb reeman: ―¿Xhie mazri rüjn naguiejn yadiil ree testiw? Dunuj gajc ree ma baguiejn ni nax con quijb xtiidxix. ");
INSERT INTO zasNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Dxel wajs gra reeman binë reeman Jesús loj Pilato. ");
INSERT INTO zasNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Yagaj guzuloj cutediaꞌ reeman Jesús lojman, rëb reeman: ―Badxaaglojn xin guie cusquieex bén du ladx ree, rëbix guial ad rayalt yadijx ree impuest loj rey César, rëb tëëx guial laax na̱j Cristo, na̱j tëëx rey. ");
INSERT INTO zasNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Dxel gunabdiidx Pilato lojman rëbaman: ―¿Lüjn na̱j xrey ree bén Israel ya? Badxiꞌ Jesús laan, rëbaman: ―Waliquil, najcan. ");
INSERT INTO zasNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Dxel rëb Pilato loj ree bixhioz rniabee ree bixhioz në loj gra ree bén rigaꞌ yagaj: ―Achet xfalt xin guie radxejlan. ");
INSERT INTO zasNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Per laa reeman naguiejnczi rüjn reeman, rëb reeman: ―Cusquieex bejn ree guidib niz Judea con ree ni rulüüx laa reeman. Guzulojx niz Galilea abiꞌ yan cayüjnx zian niz guie. ");
INSERT INTO zasNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Chi biguiejn Pilato bazaꞌt reeman Galilea, gunabdiidxaman loj reeman bal niz Galilea na̱j ladx Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Abiꞌ chi rëb reeman guial najman bén Galilea, guxhaalaman laaman loj Herodes bén rniabee Galilea, guial lën ree dxej guin në Herodes zaꞌ Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Chi baguiaa Herodes Jesús dád babaaman guial diizd gocli rënman guguiaaman laaman guial bacaagdiajgaman ruzaꞌt ree bejn laaman, abiꞌ rbëzaman guguiaaman güünman tijb milagr. ");
INSERT INTO zasNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Zien ree ni gunabdiidxaman lojman, per Jesús achetczi badxiꞌman. ");
INSERT INTO zasNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Në ree bixhioz rniabee ree bixhioz zaꞌ yagaj con ree mextr rajc ley, ad rucwëëzt rutediaꞌ reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Dxel Herodes con ree xsuldadaman xhiernarajc beennë reeman laaman, bazeꞌ reeman laaman, bascajcw reeman laaman lajd zagdxe lasaꞌ ni rajcw ree rey. Zianz baxhaal Herodes guin laaman loj Pilato zatijb. ");
INSERT INTO zasNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Abiꞌ dxejzii bazuloj baneenë Herodes Pilato zagdxe, din gocli rdxeꞌch lasaꞌ reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Dxel bachajg Pilato lasaꞌ ree bixhioz rniabee ree bixhioz con ree guxtis, con ree bén luguiedx guin, ");
INSERT INTO zasNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","abiꞌ rëbaman loj reeman: ―Bidnëdi xin guie nadi cusquieex bejn ree. Per niz lojdi ma gunabdiidxan lojx abiꞌ achet xfaltix radxejlan ziꞌc nadi. ");
INSERT INTO zasNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Niꞌqui Herodes ad badxejlt xfaltix, zeel baxhaalaman laax lon zatijb. Ma baguiaalojdi achet ni mal beenx din guiëtix. ");
INSERT INTO zasNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yan, gudëdan laax casti dxel guslaan laax. ");
INSERT INTO zasNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Lën ree dxej lanij guin ruslaa Pilato tijb bén yuꞌ ladxguiib ziꞌc goc xcostumbr reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Per graczi reeman guzuloj rbixdiaj, rëb reeman: ―¡Bagüjt xin guin! ¡Baslaa Barrabás! ");
INSERT INTO zasNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Badxeꞌ reeman Barrabás guin ladxguiib guial beenman tijb wadijl Jerusalén, guial guzujman contr ree suldad rom, në guial bagüjtaman bejn. ");
INSERT INTO zasNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Guneenë Pilato laa reeman zatijb guial guyënman nuslaaman Jesús, ");
INSERT INTO zasNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","per laa reeman gurixdiaj reeman mazri rejs, rëb reeman: ―¡Bacaax loj crüjz! ¡Bacaax loj crüjz! ");
INSERT INTO zasNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ni bayon volt rëb Pilato loj reeman: ―¿Xhieza ni mal been xin guin? Achet xfaltix radxejlan din guiëtix. Gudëdan laax casti dxel guslaan laax. ");
INSERT INTO zasNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Per laa reeman mazri rbixdiaj reeman, rëb reeman loj Pilato din gucaaman laaman loj crüjz. Abiꞌ guial tant rbixdiaj reeman con ree bixhioz rniabee ree bixhioz, been reeman gan gojc ziꞌc rën reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Dxel cwëjb Pilato beenman ziꞌc rën reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Abiꞌ baslaaman Barrabás bén guyu ladxguiib por wadijl në guial bagüjtaman bejn, guiáad Jesús bayüman laaman loj reeman persi beennë reeman laaman ziꞌctzi rën reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Chi zinë reeman Jesús din gucaa reeman laaman loj crüjz, gunaaz reeman tijb bén za Cirene laaman Simón. Ziaadaman bazaman dajn, gunabee reeman laaman güüman xcrüjz Jesús din chinalaman laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Zien daꞌt bejn zinal laaman, abiꞌ zien ree béngunaa roon rbixdiaj guial raya reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Per baguiaa Jesús loj reeman abiꞌ rëbaman: ―Béngunaa Jerusalén ad roondi por naj, gol biin por lëjt gajc në por xiꞌndi. ");
INSERT INTO zasNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Din zadxin dxej guiëbidi: “Xiquilbaa ree béngunaa ad rajct ru xiꞌn, në ree béngunaa ad gojlt xiꞌn con ree béngunaa ad caꞌt bindobëz.” ");
INSERT INTO zasNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Dxel suloj guiëb ree bejn loj ree guiaꞌ: “Gol guxaꞌt du guijcan”, guiáad loj ree lom guiëb reeman: “Gol baquieꞌch dunujn.” ");
INSERT INTO zasNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yan, nacli naj rüjnnë reeman zian, diidxgui lëjt, wed xhieczinin güünnë reeman lëjt. ");
INSERT INTO zasNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Abiꞌ në tioꞌp ree xingubaan zinë reeman din tia reex loj crüjz con Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Chi bidxin reeman lod la Calaver, bacaa reeman Jesús loj crüjz, con grop ree xingubaan guin: tijbix cwa ladbee zatijbix cwa ladruvejs. ");
INSERT INTO zasNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Abiꞌ chi cucaa reeman Jesús loj crüjz, rëbaman: ―Dad, been reeman perdon, din ad ragbeet reeman xhienin rüjn reeman. Dxel gudxijt ree suldad suert guijc xabaman din yalaꞌ reex laan. ");
INSERT INTO zasNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Zien ree bejn rigaꞌ yagaj cuguiaa reeman, abiꞌ xt ree guxtis ruzeꞌ laaman, rëb reeman: ―Baslaax ben ren ree, yan guslaa laagajquix bal walix laax na̱j Cristo. ");
INSERT INTO zasNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Në ree xin suldad ruzeꞌ laaman, rbig reex rudëëd reex vinagr guiëꞌman, ");
INSERT INTO zasNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","rëb reex lojman: ―Bal lüj na̱j xrey ree bén Israel, baslaa lüj gajc. ");
INSERT INTO zasNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Abiꞌ guijc crüjz guin bacaa reex lëjtr con diidx grieg, diidx latin, në diidx hebreo, rëban: “Bén guie na̱j xrey ree bén Israel.” ");
INSERT INTO zasNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tijb xingubaan ni ca loj crüjz guin guneex diidxguijdx loj Jesús, rëbix: ―Bal lüj na̱j Cristo, baslaa lüj gajc, baslaa tëë dunujn. ");
INSERT INTO zasNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Per zatijbix gudilë xcompniarix, rëbix lojx: ―¿Staczi ad rdxebtil Dios ya majsi lasaꞌgajc casti guin cadëdil? ");
INSERT INTO zasNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Dunuj rayalczi cayzaagdiaj din zian caydijx ni baguieen. Per bén guie achetczi ni mal wayüjnman. ");
INSERT INTO zasNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Dxel rëbix loj Jesús: ―Basaaladx naj chi ma canabeel. ");
INSERT INTO zasNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Abiꞌ rëb Jesús lojx: ―Diidxli rnin lojl guial yandxej gajc sunël naj lod na̱j nix, lod gan. ");
INSERT INTO zasNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Chi gol garol dxej, bicajy guidibczi guidxliuj xt raca choon wadxe. ");
INSERT INTO zasNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Bicajy logbijdx guiáad lajd nal lën yadooroꞌ Jerusalén goxyaꞌn, gojcan tioꞌp lalaꞌ. ");
INSERT INTO zasNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Dxel gurixdiaj Jesús, rëbaman: ―Dad, lojl rusaꞌn da sprijtan. Chi gulox guneeman zian, dxel güjtaman. ");
INSERT INTO zasNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Chi baguiaa suldad rniabee ree suldad ni goc, bazaꞌtix Dios zagdxe, rëbix: ―Walican achet xtol bén guin yuꞌ. ");
INSERT INTO zasNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Chi baguiaa gra ree bén zaꞌ yagaj ni goc, dád guyunaya reeman zia reeman rigaꞌpgaj luxdoo reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Per gra ree bén nünbee Jesús, con ree béngunaa nal laaman diizd Galilea, zijt guzuj reeman baguiaa reeman gra ree ni goc. ");
INSERT INTO zasNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Guyu tijb bejn, brii lajman Xiëb, gojcaman benzaꞌc, beenman ziꞌc rayal. Gojc ladxaman guiedx Arimatea tijb guiedx naaz Judea. Gojc tëëman tijb xguxtis ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nëman rbëz nabee Dios, abiꞌ ad nëtaman bachajg xixgab ree bén bagüjt Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Wejman loj Pilato bignabaman xcuerp Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Chi gulox baletaman xcuerp Jesús loj crüjz guin, cwaꞌman laaman batüübaman tijb lajd, dxel biquieꞌchaman laaman lën tijb baa ni bidëën lën guiaj lod achutczi waguieꞌch. ");
INSERT INTO zasNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Dxej guin rüjn reeman porvinid gra par dxej raziiladx ree bejn. Zamer suloj dxej guin chi biquieꞌch reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Abiꞌ ree béngunaa zidnë Jesús diizd Galilea, në reeman binal abiꞌ baguiaa reeman xbaa Jesús baguiaa tëë reeman xhienaag gudijxh reeman xcuerpaman. ");
INSERT INTO zasNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Chi bayejc reeman, zianz beenchaaw reeman perfum në zaj ni rliaa nejxh ni guidëëbaman. Dxel baziiladx reeman dxej raziiladx ree bejn ziꞌc rniabee ley. ");
INSERT INTO zasNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Chi dumingw rsildoo, wej ree béngunaa guin roꞌ xbaa Jesús binë reeman perfum ni beenchaaw reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Chi bidxin reeman yagaj, baguiaa reeman guiaj ni bidaꞌcw roꞌ baa guin ad nagaꞌtri xluaran. ");
INSERT INTO zasNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Abiꞌ guyu reeman, per ad bidxaaglojtri reeman xcuerp Dad Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Laꞌtzi cadxeb reeman niꞌquid radxejlt xhie güün reeman, dxejczi baguiaa reeman tioꞌp ree bejn zaꞌli reeman gajxh lod zaꞌ reeman, najcw reeman lajd bachaꞌ. ");
INSERT INTO zasNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Abiꞌ guial tant bidxeb reeman, basajb loj reeman xt luyuj, dxel rëb ree bén guin loj reeman; ―¿Chexc zeel raguiilidi tijb bén naban loj ree bengüt? ");
INSERT INTO zasNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Achutri laaman guie din ma babanman. Gol basaaladx ni naman lojdi chi guzuman niz Galilea. ");
INSERT INTO zasNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Naman lojdi guial yayü reeman Bén guxhaal Dios loj ree béndol din gucaa reeman laaman loj crüjz, abiꞌ ni yayon dxej yabanman. ");
INSERT INTO zasNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Dxel basaaladx reeman diidx ni rëb Jesús loj reeman, ");
INSERT INTO zasNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","abiꞌ chi baza reeman roꞌ baa guin, bicojn reeman guidxiptib ree xi apóstoles Jesús në los demazri ree xcompniar reeman gra ni baguiaa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","María Magdalena, con Xuan, con Li xniaa Jacob con ree béngunaa ren, laa reeman bignë ruson guin loj ree xi apóstoles Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Per laa reeman ad bililadxt reeman ni rëb ree béngunaa guin, gunaladx reeman wed rëbzi reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Per Bëd baxüünman biquiaaman lën baa guin, abiꞌ chi baguiaaman lën baa guin, lajd ni bidüübzi Jesús baguiaaman, zianz ziaman dád radxalojman por ni goc. ");
INSERT INTO zasNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Dxej guin gajc, tioꞌp ree xbejn Jesús zë tijb guiedx la Emaús, rayaꞌnan ziꞌct chiptib kilometro par Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Chi zë reeman lunejz cayü reeman diidx xcwent gra ree ni goc. ");
INSERT INTO zasNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Laꞌtgaj cayü reeman diidx, gubig Jesús cwëꞌ reeman abiꞌ guzuloj cazanëman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Per majsi cuguiaa reeman laaman, yuꞌ ni badxoon nayünbee reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Dxel gunabdiidx Jesús loj reeman, rëbaman: ―¿Xhie diidxan rüdi laꞌtgaj cazadi? ¿Chexc zeel yuꞌnayadi? ");
INSERT INTO zasNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Badxiꞌ tijb bén la Cleofas laan, rëbaman: ―Gra ree bejn ragbee ni goc Jerusalén lën ree dxej guie. ¿Wen tijbzi lüj na̱j bén guzu Jerusalén ad gogbeetil ni goc ya? ");
INSERT INTO zasNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Dxel rëbaman loj reeman: ―¿Xhie goc? Abiꞌ rëb reeman: ―Ni beennë reeman Jesús bén Nazaret, laaman goc tijb bén badëë xtiidx Dios loj ree bejn, bén gop guialrniabee ziꞌc ni beenman në ree diidx ni guneeman niz loj Dios në niz loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Në guial bayü ree bixhioz rniabee ree bixhioz laaman në ree dux guxtis ree din guiëtaman, abiꞌ bacaa reeman laaman loj crüjz. ");
INSERT INTO zasNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Par dunujn laaman na̱j bén yabëë ree bén Israel loj ree bén rom, per yan gojc choon dxej ni goc ree ni guin. ");
INSERT INTO zasNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Majsi tioꞌp choon ree béngunaa noꞌch du lojn bachejb reeman dunujn, guial rsildoo wej reeman roꞌ baa guin, ");
INSERT INTO zasNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","abiꞌ guial ad baguiaat reeman xcuerpaman, bayejc reeman rü reeman diidx guial balüüloj ree anjl loj reeman, rëb ree anjl guin loj reeman guial naban Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Laa biquiaa gajc ree tioꞌp choon ree dux compniaran roꞌ baa guin abiꞌ baguiaa reeman ziꞌcgajczi rëb ree béngunaa guin, per ad baguiaat reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Dxel rëb Jesús loj reeman: ―¡Xi nawëëg na̱j chigniaꞌdi abiꞌ xi raglaa par chililadxidi gra ni gunee ree bén badëë xtiidx Dios loj ree bejn! ");
INSERT INTO zasNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Wen id na̱j ya guial sagdiaj Cristo, dxelri yayëꞌpaman xanyabaa? ");
INSERT INTO zasNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Dxel guzuloj cusigniaꞌman laa reeman ni rën guiëb ni ca loj xtiidx Dios xcwentaman. Guzulojman con ree xlibr Moisejs abiꞌ basnuuman con gra ree libr ni bacaa ree bén badëë xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Chi bidxin reeman guiedx lod zë reeman, been Jesús ziꞌc bén che mazri zijt. ");
INSERT INTO zasNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Per laa reeman been reeman naguiejn din yayaꞌnnëman laa reeman, rëb reeman lojman: ―Bayaꞌn con dunujn, din ma gudxe yan abiꞌ ma cabej guiaal. Dxel guyu Jesús persi bayaꞌnnëman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Abiꞌ chi zojbnëman laa reeman xan mex, cwaꞌman guiadxtil abiꞌ chi gulox badëëman quixtëë loj Dios, gulaꞌman laan persi badëëman laan loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hor guin gajc guzajc reeman ziꞌc bén baxal guiaaloj, abiꞌ bayünbee reeman laaman. Per laa gunidloj gajcaman, ");
INSERT INTO zasNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","zianz rëb loj lasaꞌ reeman: ―¡Zeꞌcliza dád nix yuꞌ du luxdoo chi zudnëꞌman lunejz, chi cusigniaꞌman dunuj ni rëb loj xtiidx Dios! ");
INSERT INTO zasNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Abiꞌ niꞌquid gulëjzt reeman, laa bayunejz gajc reeman zia reeman Jerusalén lod rigaꞌ guidxiptib ree xi apóstoles Jesús con ree xcompniar reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Rëb reeman loj grop ree bén guin: ―Walican ma baban Dad Jesús, ma balüülojman loj Simón. ");
INSERT INTO zasNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Zianz be reeman diidx ni guzac reeman chi zë reeman lunejz xhie tëë naag bayünbee reeman Jesús chi gulaꞌman guiadxtil. ");
INSERT INTO zasNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sta cayü reeman diidx xcwent ree ni guin, chi balüüloj Jesús galay reeman, rëbaman: ―Yabeꞌcdxe Dios luxdoodi. ");
INSERT INTO zasNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Dád badxaloj reeman abiꞌ bidxeb reeman guial gunaladx reeman anman cuguiaa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Per rëb Jesús loj reeman: ―¿Chexc zeel rdxebidi? ¿Chexc zeel yuꞌnawëëg luxdoodi? ");
INSERT INTO zasNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Gol baguiaa yan në guiaꞌn. Naj gajcan, gol baquiꞌ naj gol baguiaa tëë naj, din tijb anm ad yuꞌtaman dxijt ad ca tëëtaman bëël ziꞌc ruguiaadi naj. ");
INSERT INTO zasNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Chi rëbaman zian, balüü yaaman në guiaꞌman. ");
INSERT INTO zasNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Per laa reeman staczi ad rliladxt reeman guial tant rabaa reeman radxa tëë loj reeman, abiꞌ rëbaman loj reeman: ―¿Rajpidi taꞌn guialraw ya? ");
INSERT INTO zasNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Dxel badëë reeman tibliaꞌ bëjl biguieꞌ, ");
INSERT INTO zasNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","abiꞌ cwaꞌman laab gudawaman niz loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Zianz rëbaman loj reeman: ―Ni ma guzaꞌcan na̱j ni rnin lojdi chi sta zaꞌn con lëjt: Guial na̱j gac gra ree ni ca loj xlibr Moisejs ni gazaꞌcan, në xlibr ree bén badëë xtiidx Dios loj ree bejn, në loj libr salmos. ");
INSERT INTO zasNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dxel guxhalaman xquiarguiejn reeman persi bigniaꞌ reeman ni ca loj xtiidx Dios, ");
INSERT INTO zasNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","abiꞌ rëbaman loj reeman: ―Loj xtiidx Dios rëb guial Cristo, na̱j guial guiëtaman, abiꞌ ni yayon dxej yabanman. ");
INSERT INTO zasNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Abiꞌ diizd Jerusalén suloj guireꞌch xtiidxaman xt guidib loj guidxliuj guial yuꞌ perdon par gra ree bén yayüjn xgab por xtol guililadx tëë reeman naj. ");
INSERT INTO zasNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Lëjt na̱j testiw xcwent gra ree ni guin. ");
INSERT INTO zasNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Naj gaxhal par lëjt ni ma na da Dadan. Per gol guzujsii luguiedx Jerusalén xt tiaꞌdi guialrniabee ni guiꞌt diizd xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Dxel briinë Jesús laa reeman luguiedx Jerusalén binëman laa reeman gajxh Betania, zianz gules yaaman beenleꞌman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Abiꞌ laꞌtgaj cayüjnleꞌman laa reeman, wajsaman ziaman xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Chi gulox bazuxib reeman badëë reeman quixtëë lojman, dxel zia reeman Jerusalén, dád rabaa reeman. ");
INSERT INTO zasNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Abiꞌ guixie guixie yuꞌ reeman lën yadooroꞌ Jerusalén ruzaꞌt reeman Dios zagdxe rudëëd tëë reeman quixtëë lojman.");
INSERT INTO zasNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Diizd guiaꞌxchej chi gad guidxliuj gacchaaw, mal yuꞌ bén na̱j xtiidx Dios. Laaman zaꞌnë Dios abiꞌ laagajcaman na̱j Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Laaman mal zaꞌnë Dios diizd guiaꞌxchej. ");
INSERT INTO zasNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Laaman been graczi ni yuꞌ. Achetczi ni yuꞌ niajc bal id laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Laaman rajp guialnaban, guiáad guialnaban guin na̱j bajl par gra bénguidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Bajl guin rusni bén nacay xquiarguiejn, abiꞌ ad rajct rutëë guialnacay guin loj bajl guin. ");
INSERT INTO zasNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Guyu tijb bén brii laj Waj, Dios guxhaal laaman, ");
INSERT INTO zasNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","bidgaguieman diidx xcwent bén na̱j xbajl Dios, din gac chililadx gra ree bejn laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Per ad Wajt goc bajl guin, biꞌtzaman bidgaguieman diidx xcwent bajl guin. ");
INSERT INTO zasNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Din bén na̱j quijb bajl guin, laaman rusni xquiarguiejn gra bénguidxliuj, abiꞌ ma biꞌtaman loj guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Laaman guzu loj guidxliuj, abiꞌ majsi laaman been guidxliuj, per ree bénguidxliuj ad bayagbeet reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Biꞌtaman loj ree bén Israel, abiꞌ majsi gojcaman bén Israel, per ad bidxgaꞌt reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Per, gra ree bén bidxgaꞌ laaman bililadx tëë reeman laaman, beenman laa reeman xiꞌn Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Abiꞌ na̱j reeman xiꞌn Dios, ad ziꞌc rut xiꞌn bejn loj guidxliuj por xixgab bejn o guial rën bejn chuꞌ xiꞌnman, por guial rliladx reeman ma na̱j reeman xiꞌn Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jesús, bén na̱j xtiidx Dios, laaman goc bejn abiꞌ gubajnman loj guidxliuj con dunuj ree, abiꞌ dád guyënman bejn ree gunee tëëman ganax diidxli. Dunujn baguiaa xguialrniabeeman, guialrniabee ni caꞌman guial tijbzi laaman na̱j Xiꞌn Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Chi be Waj xtiidxaman loj ree bejn, guneeman rejs, rëbaman: ―Jesús guie na̱j bén ruzatan, chi rnin guial bén zëëd xichan mazri lasajcaman guial lon, din diizd gocli mal yuꞌman guial lon. ");
INSERT INTO zasNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Dád rënman dunuj ree, gra dxejczi racaꞌ dugra ree xguialnazaꞌcaman. ");
INSERT INTO zasNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Por Moisejs banee Dios xleyaman duloj ree, per por Jesucrist bayagbee ree xhienaag rën Dios dunuj ree xhie tëë naag na̱j xtiidxliman. ");
INSERT INTO zasNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ad yuꞌt dxej waguiaa bejn Dios. Bén na̱j tijbzi xiꞌnman. Bén nabannë laaman balüü duloj ree xhienaag na̱j Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Diizd Jerusalén guxhaal ree xguxtis ree bén Israel bixhioz ree con ree bén na̱j ree levitas persi bignabdiidx reeman loj Waj chu najman. ");
INSERT INTO zasNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Dxel be Waj diidxli loj reeman, rëbaman: ―Ad najtan na̱j Cristo. ");
INSERT INTO zasNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Abiꞌ gunabdiidx reeman lojman stijb rëb reeman: ―¿Chuza najl? ¿Lüjn na̱j Elías ya, bén badëë xtiidx Dios loj ree bejn? Badxiꞌ Wajn rëbaman: ―Ad najtan. Dxel gunabdiidx reeman stijb rëb reeman: ―O, ¿lüjn na̱j bén na̱j diidx guiꞌt ya, bén gudëë xtiidx Dios loj ree bejn? Badxiꞌman laan rëbaman: ―Ad najtan. ");
INSERT INTO zasNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Abiꞌ rëb reeman: ―¿Chuza najl? Din rayal yugnëꞌn ruson loj ree bén guxhaal dunujn. Guna chu najl. ");
INSERT INTO zasNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Dxel rëb Waj loj reeman: ―Naj na̱j tijb bén rbidxaꞌ loj yujbidx: “Gol guxhal tijb nejz nali par bén caꞌ guialrniabee” ―ziꞌc rëb Isaías bén badëë xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Abiꞌ ree bén guxhaal ree bénfarisew din guinieenë reeman Waj, ");
INSERT INTO zasNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","gunabdiidx reeman lojman, rëb reeman: ―Bal id lüjn na̱j Cristo, niꞌqui Elías, niꞌqui bén na̱j diidx guiꞌt, bén gudëë xtiidx Dios loj ree bejn, ¿chexquiza zeel ruroobnijsil bejn? ");
INSERT INTO zasNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Badxiꞌ Waj laan rëbaman: ―Naj rurobnijs con nijs, per lojdi noꞌch tijb bén ad wayünbeetidi. ");
INSERT INTO zasNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Laaman na̱j bén zëëd xichan, niꞌqui xgurëchaman ad rayalt gaxhiecan guial najman bén mazri lasajc guial lon. ");
INSERT INTO zasNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Gra niguie gojc lod la Betábara, ni na̱j stiblad roꞌ guiiw Jordán, lod baroobnijs Waj bejn ree. ");
INSERT INTO zasNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Chi bareguiaal, baguiaa Waj zibig Jesús lod zaꞌman, dxel rëbaman: ―Gol baguiaa, bén guin na̱j bén bacaabee Dios din guiëtaman ziꞌc xiildoo por xtol ree bénguidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Laaman bazatan lojdi chi rnin: “Xichan zidnal bén mazri lasajc guial lon, din laaman mal yuꞌ diizd gocli guial lon.” ");
INSERT INTO zasNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Niꞌqui naj ad gogbeetan guial laaman na̱j bén guiꞌt, per naj zialan din gurobnijsan bejn ree con nijs din chileꞌ güünbee ree bén Israel laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Rëb tëë Waj loj reeman: ―Naj baguia biguiajt xSprijt Dios diizd xanyabaa ziꞌc tijb palom xt guijcaman. ");
INSERT INTO zasNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Majsi ad nünbeetan laaman, per bén guxhaal naj barobnijsan con nijs, laaman na lon: “Chi guguiaal guiat xSprijt Dios xt guijc tijb bejn, laaman na̱j bén runee xSprijt Dios.” ");
INSERT INTO zasNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Naj ma baguia laaman, abiꞌ ragbeechaawan guial laaman na̱j Xiꞌn Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Chi bareguiaal, zaꞌ Waj yagaj stijb, zaꞌnë tioꞌp ree xbejnman. ");
INSERT INTO zasNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Abiꞌ chi baguiaaman cadëd Jesús, dxel rëbaman loj reeman: ―Gol baguiaa, bén guinan na̱j ziꞌc xi xiildoo Dios din guiëtaman por xtol bénguidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chi biguiejn reeman rëb Waj zian, dxel binal reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Chi badxiꞌ lojman, baguiaaman zinal reeman laaman, abiꞌ rëbaman loj reeman: ―¿Xhie rguiilidi? Badxiꞌ reeman laan rëb reeman: ―Mextr, ¿ban zojbil? ");
INSERT INTO zasNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Dxel rëb Jesús loj reeman: ―Gol guda din guguiaadi. Dxel wej reeman biquiaa reeman lod zojbaman, abiꞌ bayaꞌnnë reeman laaman dxej guin, guial ma gojl cost raca tajp wadxe. ");
INSERT INTO zasNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tijb ree xbejn Waj bén binal Jesús, bén bacaagdiajg ni rëb Waj, laaman brii laj Andrejs, bijch Simón Bëd. ");
INSERT INTO zasNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrejs guin, yalojxgaj bijchaman Simón bigdiilaman, abiꞌ rëbaman lojman: ―Ma badxaaglojn bén na̱j Mesías ―rën guiëban Cristo. ");
INSERT INTO zasNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Dxel binë Andrejs Simón lod zaꞌ Jesús, chi baguiaa Jesús laaman, rëbaman: ―Lüj na̱j Simón, xiꞌn Jonás, per yan grii lajl Cefas ―rën guiëban Bëd. ");
INSERT INTO zasNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Chi bareguiaal been Jesús xgab cheman niz Galilea, abiꞌ badxaagaman Felip, zianz rëbaman: ―Tanal naj. ");
INSERT INTO zasNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ladx Felip guin na̱j guiedx Betsaida, ni gajc na̱j ladx Andrejs con Bëd. ");
INSERT INTO zasNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Dxel bigdiil Felip Natanael, abiꞌ rëbaman lojman: ―Ma badxaaglojn bén ruzaꞌt Moisejs loj xlibr xleyaman, bén ruzaꞌt ree bén badëë xtiidx Dios loj ree bejn loj ni bacaa reeman. Laaman na̱j Jesús, xiꞌn Xiëb, bén Nazaret. ");
INSERT INTO zasNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Dxel rëb Natanael lojman: ―¿Wen yuꞌ benzaꞌc Nazaret ya? Badxiꞌ Felipan rëbaman: ―Yoꞌ din guguiaal. ");
INSERT INTO zasNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Chi baguiaa Jesús zëëd Natanael, rëbaman: ―Guie zëëd tijb bén na̱j quijb bén Israel, abiꞌ ad rusquieetaman. ");
INSERT INTO zasNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Dxel gunabdiidx Natanael lojman, rëbaman: ―¿Xoza nünbeel naj? Badxiꞌ Jesúsan rëbaman: ―Chi gad Felip cwedx lüj, chi zaꞌl xan yag higo, dxel baguian lüj. ");
INSERT INTO zasNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Zianz rëb Natanael lojman: ―Mextr, lüj na̱j Xiꞌn Dios, lüj na̱j rey Israel. ");
INSERT INTO zasNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Badxiꞌ Jesús laan rëbaman: ―¿Rliladxil naj ya guialzi rnin baguian lüj xan yag higo? Per mazri na̱j ree ni guguiaal guial loj ni ma baguiaal. ");
INSERT INTO zasNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Rëb tëëman: ―Naj ragbeechaaw, zuguiaadi zojbyal xanyabaa, abiꞌ zuguiaadi xianjl ree Dios yayëꞌp reeman xanyabaa yaguiajt tëë reeman xt guijc Bén guxhaal Dios loj guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ni goc choon dxej guyu tijb guialruxhliaa luguiedx Caná, ni rigaꞌ niz Galilea. Dxel në xniaa Jesús zaꞌ yagaj, ");
INSERT INTO zasNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","abiꞌ në Jesús con ree xbejnman gunee reeman persi wej reeman loj lanij guin. ");
INSERT INTO zasNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Chi babidx vin, dxel rëb xniaa Jesús lojman: ―Achetri vin rajp reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Badxiꞌ Jesúsan rëbaman: ―Na, ¿chexquiza zeel nal lon zian? Ad wadxint da horan günan ni rayal günan. ");
INSERT INTO zasNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Per xniaaman rëb gajcaman loj ree bén cayüjn mandad yagaj: ―Gol been gra ni naman. ");
INSERT INTO zasNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yagaj zaꞌ xhoꞌp ree guiajs guiaj, ni ru nijs ni rüjnnë ree bén Israel dxiin chi rusia laa reeman ziꞌc na̱j xcostumbr reeman. Abiꞌ lën tijbgaj reen ru cost tibgayuu lijtr. ");
INSERT INTO zasNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Abiꞌ rëb Jesús loj ree bén rüjn mandad guin: ―Gol bacha ree guiajs guie nijs. Dxel bachadi reeman laa reen, ");
INSERT INTO zasNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","abiꞌ rëbaman loj reeman: ―Yan gol gulëë taꞌnan, gol bigdëën loj bén canabee loj lanij guie. Dxel bigdëë reeman laan lojman, ");
INSERT INTO zasNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","abiꞌ bén canabee loj lanij guin beenman prueb nijs bayajc vin guin, sin guial niagbeeman ban guzan, bén cayüjnz ree mandad guin ragbee, din laa reeman bicaꞌ nijs guin. Dxel gurejdxaman xin cuxhliaa guin, ");
INSERT INTO zasNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","rëbaman lojx: ―Graczi bejn rguiꞌs yaloj vin zagdxe, abiꞌ chi ma guꞌ reeman zilan, dxel rguiꞌsaman vin corrient. Per lüj badxeꞌchaawil vin zagdxe guin persi caguiꞌsilan yan. ");
INSERT INTO zasNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ni guin na̱j milagr yaloj been Jesús, beenman milagr guin Caná, guiedx rigaꞌ niz Galilea. Zian balüü guialrniabee ni rajpaman abiꞌ bililadx ree xbejnman laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chi gulox gojc zian dxel zë reeman guiedx Capernaum, con xniaaman, con ree bijchaman con në ree xbejnman. Ni guzu reeman tioꞌp choon dxej. ");
INSERT INTO zasNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Chi ma zidyob pascw xlanij ree bén Israel, wej Jesús Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Abiꞌ roꞌ yadooroꞌ bidxaaglojman bén cutoꞌ ree goꞌn, con ree xiil con ree palom, në ree bén zojb xan mex ruchaa reeman xmilia ree bén ziaad lood ren. ");
INSERT INTO zasNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Chi baguiaa Jesús zian, dxel beenchaawaman tijb duu persi babëëman gra reeman, con gra ree xgoꞌn reeman në ree xiil. Gutieꞌchaman xmilia ree bén ruchaa milia guin barexguiat tëëman xmex reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Dxel rëbaman loj ree bén cutoꞌ palom: ―¡Gol babëë reeb guie! ¡Ad rüjnnëdi lidx da Dadan ziꞌc luguiaꞌ! ");
INSERT INTO zasNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Dxel basaaladx ree xbejnman ni ca loj xtiidx Dios lod rëb: “Dád ralenan ruguian ni rüjn reeman lidxil.” ");
INSERT INTO zasNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Zianz rëb ree bén Israel lojman: ―¿Xhie milagr gulüül du lojn din yayagbeen guial rajpil guialrniabee güünl zian? ");
INSERT INTO zasNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Badxiꞌ Jesús laan rëbaman: ―Gol baseꞌn yadoo guie, naj yayün laan loj choon dxejzi. ");
INSERT INTO zasNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Dxel rëb ree bén Israel guin lojman: ―Tiuubixhoꞌp ijz goglaa reeman been reeman yadoo guie, ¿guiáad lüj ya yayüjnlan choon dxejzi? ");
INSERT INTO zasNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Per Jesús xcuerp gajcaman ruzaꞌtaman chi ruzaꞌtaman yadoo guin. ");
INSERT INTO zasNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Zeel chi babanman loj ree bengüt, basaaladx ree xbejnman ni rëbaman, abiꞌ bililadx reeman xtiidxaman bililadx tëë reeman ni ca loj xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Chi guzu Jesús Jerusalén pascw, zien ree bejn bililadx laaman, chi baguiaa reeman milagr ree ni beenman. ");
INSERT INTO zasNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Per laaman ad rëbtaman loj reeman chu najman, din laaman nünbeechaaw xhienaag na̱j xixgab reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ad biaadxtaman chu niëjb lojman xhienaag na̱j bejn, din laaman ragbeechaaw xhienaag na̱j xixgab tijbgaj bejn. ");
INSERT INTO zasNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Guyu tijb bénfarisew brii lajman Nicodemo, gojcaman tijb guxtis loj ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Abiꞌ wejman bignajman Jesús tijb guxhin, dxel rëbaman lojman: ―Mextr, rayagbeen guial Dios guxhaal lüj din gulüül dunujn, din achutczi zajc güün lasaꞌ ree milagr ni rüjnl bal id zaꞌnë Dios laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Dxel rëb Jesús: ―Diidxliczi rnin lüj, bén ad zajlt stijb, ad zajct guguiaaman xguialrniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Abiꞌ rëb Nicodemo lojman: ―Per, ¿xhienaag gal bejn stijb chi ma najman bengol? ¿Wen zajc yayu lën xniaaman ya abiꞌ galaman stijb? ");
INSERT INTO zasNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Badxiꞌ Jesús laan rëbaman: ―Diidxliczi rnin, bén ad rirobnijst ad nabannë tëëtaman xSprijt Dios ad zileꞌt yayuman loj xguialrniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Bén naban ziꞌc na̱j xixgabaman, lojzi guidxliuj guie rajpaman guialnaban, per bén nabannë xSprijt Dios, por Sprijt guin rajpaman stijb guialnaban. ");
INSERT INTO zasNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ad bal radxa lojl guial rnin: “Rüjn naguiejn gal bejn stijb.” ");
INSERT INTO zasNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Din ziꞌc rbiꞌ bi gralad abiꞌ majsi riguiejnl chi rbiꞌn, per niꞌquid ragbeetil ban zëëdan o ban zën. Ziangajc na̱j xSprijt Dios con gra ree bén nabannë laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Dxel rëb Nicodemo lojman: ―¿Xhienaag rajc zian? ");
INSERT INTO zasNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Badxiꞌ Jesúsan rëbaman: ―¿Lüj, na̱j mextr loj ree bén Israel, ad rigniaꞌtil gra ree ni guin ya? ");
INSERT INTO zasNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Diidxliczi rnin lojl, raneen ni rayagbeen ni baguiaa tëën, per lëjt ad rliladxtidi ni ranan. ");
INSERT INTO zasNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Bal id rliladxidi chi rnin xcwent ree ni loj guidxliuj guie, ¿xhienaag chililadxidi bal ganin xcwent ree ni xanyabaa? ");
INSERT INTO zasNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Achut wayej xanyabaa, tijbzi bén biguiat diizd xanyabaa, Bén guxhaal Dios loj guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Abiꞌ ziꞌc bacaa Moisejs bëël guiib loj yag niz loj yujbidx, ziangajc Bén guxhaal Dios loj guidxliuj, gucaa reeman laaman loj crüjz, ");
INSERT INTO zasNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","din gra bén chililadx laaman ad zanijtt reeman loj Dios, gap reeman guialnaban tiblayaa con laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Guial tant rën Dios bénguidxliuj, majsi tijbzi xiꞌnman, per guxhaalaman laaman loj guidxliuj, din graczi bén chililadx laaman ad zanijtt reeman loj Dios, gap reeman guialnaban tiblayaa con laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Din Dios ad guxhaalt xiꞌnman loj guidxliuj din gudëëdaman bejn casti, guxhaalaman laaman din gap ree bejn perdon loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Bén rliladx Xiꞌn Dios ad rayaltaman xcasti Dios. Per bén ad rliladxt, laaman ma rayal casti guial ad rliladxtaman Xiꞌn Dios, bén na̱j tijbzi xiꞌnman. ");
INSERT INTO zasNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Bén ad rliladxt ree rayal reeman casti, din yan ni biꞌt bén na̱j xbajl Dios, mazri bayuladx reeman nejz mal, guial rüjn reeman ganax ni mal. ");
INSERT INTO zasNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Graczi ree bén rüjn ni mal ad ruladxtczi reeman bajl guin, ad rbigt reeman lojn, chitëë guiguien ni mal cayüjn reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Per ree bén naban ziꞌc rayal loj Dios, laa reeman rbig loj xbajlaman din guiguien guial graczi ni cayüjn reeman na̱j ni rën Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chi gudëd gojc zian, Jesús con ree xbejnman wej reeman niz Judea, lod guzunëman laa reeman tioꞌp choon dxej, ni baroobnijs reeman bejn ree. ");
INSERT INTO zasNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nëgajc Waj curoobnijs bejn ree luguiedx la Enón, ni rigaꞌ gajxh guiedx Salim, guial yuꞌ zil nijs ni. Abiꞌ rej ree bejn persi rirobnijs reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Laan goc chi gad Waj chuꞌ ladxguiib. ");
INSERT INTO zasNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Per bëlzi ree xbejn Waj, con za tioꞌp choon gajc ree bén Israel guzuloj cadildiidx reeman por xcostumbr reeman guial xhienaag gac reeman naya. ");
INSERT INTO zasNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Dxel biguiedx reeman loj Waj: ―Mextr, bén guzunël stiblad roꞌ guiiw Jordán, bén bel xtiidx du lojn, në laaman curoobnijs bejn ree abiꞌ gra reeman zinal laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Badxiꞌ Waj laan rëbaman: ―Achut zajc gap guialrniabee bal id Dios gudëë laan. ");
INSERT INTO zasNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Lëjt ragbee guial biguiejndi rën guial ad najtan na̱j Cristo, naj guneed lojman zidgagojnan por laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Dunuj ree rayagbee guial loj guialruxhliaa, xin zaꞌnë biingunaa guin, laaxan cuxhliaa, guiáad xmiwix xin zaꞌ con laax rabaanë daꞌtix laax chi riguiejnx rnieex. Ziangajc naj dád rabaanëꞌn laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Abiꞌ laaman gusnuu gacaman mazri bén zojbloj, guiáad naj gusnuu gacan bén ad lasajct guial lojman. ");
INSERT INTO zasNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Din bén zëëd diizd xanyabaa, laaman na̱j bén rniabee loj gra. Per bénguidxliuj, bénguidxliujzi najman abiꞌ ganax ni yuꞌ loj guidxliuj ruzaꞌtaman. Per Bén zëëd diizd xanyabaa laaman rniabee gra, ");
INSERT INTO zasNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","abiꞌ rüman ni ma baguiaaman ni ma biguiejn tëëman, per achut rliladx ni rnieeman. ");
INSERT INTO zasNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Bal yuꞌ bén rliladx xtiidxaman, zian rguien guial ni diidxli na̱j xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Abiꞌ bén zëëd por Dios, laaman rü xtiidx Dios guial guidiblagaa badëëd Dios xSprijtaman lojman. ");
INSERT INTO zasNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dios rën Xiꞌnman abiꞌ basaꞌnman gra lojman. ");
INSERT INTO zasNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Abiꞌ chutëëz bén rliladx Xiꞌnman, laaman rajp guialnaban tiblayaa loj Dios. Per bén ad rtiëjbt chililadx, ad rajptaman guialnaban guin, laaman rayal xcasti Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Gogbee ree bénfarisew guial mazri zien bejn ma zinal Dad Jesús mazri zien tëë bejn ruroobnijsaman guial loj Waj, ");
INSERT INTO zasNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","majsi diidxliczi ad Jesústan ruroobnijs bejn ree, bén na̱j ree xbejnman ruroobnijs. ");
INSERT INTO zasNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Chi gogbeeman zian dxel briiman niz Judea zëman niz Galilea stijb. ");
INSERT INTO zasNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Per chi zëman niz Galilea been naguiejn gudëdaman niz Samaria. ");
INSERT INTO zasNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Abiꞌ bidxinman tijb guiedx la Sicar, ni nulen Samaria, gajxh lod nagaꞌ yuj ni badëë Jacob loj xiꞌnman Xiëb. ");
INSERT INTO zasNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yagaj na̱j tijb bizëduu rniee reeman laan xbizë Jacob. Abiꞌ guial ma badxag Jesús cazaman, dxel gurejman roꞌ bizë guin. Ma zidyob garol dxej. ");
INSERT INTO zasNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Guiáad ree xbejnman zë reeman luguiedx guin zisii ni gaw reeman. Hor guin bidxin tijb béngunaa Samaria roꞌ bizë guin din tiaꞌman nijs, dxel rëb Jesús lojman: ―Bazaladx taꞌn xnijsil guiëꞌn. ");
INSERT INTO zasNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Per guial ad rnieenët lasaꞌ ree bén Israel zagdxe con ree bén Samaria, badxiꞌ béngunaa guinan rëbaman: ―¿Chexquiza zeel rniabil nijs lon najl bén Israel awa bén Samaria naj? (Din bén Israel ree ad rnieenët reeman bén Samaria ree zagdxe.) ");
INSERT INTO zasNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Badxiꞌ Jesús laan rëbaman: ―Bal zian ragbeel ni rën Dios guneeman lüj, chutëë bénan canab nijs lojl, zanabil nijs lon abiꞌ naj zunen nijs runee guialnaban. ");
INSERT INTO zasNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Dxel rëb béngunaa guin loj Jesús: ―Dad, niꞌquid caꞌtil ni cwëënël nijs, abiꞌ bizë guin dád naxhitan. ¿Ban chicaꞌl nijs runee guialnaban? ");
INSERT INTO zasNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Dux béngulalan Jacob basaꞌnnë dunujn bizë guie, lod guꞌman nijs con ree xiꞌnman con ree xbeguiꞌxhaman. ¿Wen mazri najl guial lojman ya? ");
INSERT INTO zasNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Badxiꞌ Jesús laan rëbaman: ―Graczi ree bén rëꞌ nijs guie reꞌc reeman nijs stijb. ");
INSERT INTO zasNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Per bén guiëꞌ nijs gudëdan, ad yuꞌtri dxej cheꞌcaman nijs. Din nijs gudëdan gacan luxdooman ziꞌc lod ad rbëzt rajch nijs, abiꞌ nijs guin gudëë guialnaban tiblayaa. ");
INSERT INTO zasNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Dxel rëb béngunaa guin lojman: ―Dad, banee nijs guin lon, chitëë cheꞌcran nijs ad zial tëëtran guidcaꞌn nijs guie. ");
INSERT INTO zasNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Rëb Jesús lojman: ―Bignee lacheelil, dxel yaguiaadil guie. ");
INSERT INTO zasNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Badxiꞌ béngunaa guinan rëbaman: ―Achut da bénguiaawan yuꞌ. Dxel rëb Jesús: ―Waliquil achut lacheelil yuꞌ, ");
INSERT INTO zasNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","din ma gojc gaay xinguiaaw rtiaꞌ lüj, abiꞌ yan xin zojbnël ad lacheeltilan. Zeel waliqui ni nal. ");
INSERT INTO zasNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Chi biguiejnman ni rëb Jesús, dxel rëbaman: ―Dad, ma ragbeen guial lüj na̱j bén rudëë xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Dux béngulalan gunajchiꞌ reeman Dios ruguiaꞌ guie, per lëjt najdi bén Israel rëbidi guial Jerusalén na̱j lod guiniajchiꞌ bejn laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Badxiꞌ Jesúsan rëbaman: ―Na, zagdxe rnin guial guidxin dxej guiniajchiꞌdi dux Dad ree Dios, ad ziꞌttridi ruguiaꞌ guie ad zej tëëtridi Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Lëjt niꞌquid ragbeetidi chunin rniajchiꞌdi, per dunujn rayagbeen chunin ranajchiꞌn, din loj ree bén Israel grii bén güün bejn ree perdon. ");
INSERT INTO zasNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Abiꞌ ma bidxin dxej ni gra ree bén diidxli rniajchiꞌ Dios, guiniajchiꞌ reeman laaman ziꞌc rayal por xSprijtaman. Din zian rën dux Dad ree Dios güün ree bén rniajchiꞌ laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios na̱j Sprijt, abiꞌ bén rniajchiꞌ ree laaman rayal guiniajchiꞌ reeman laaman con guidib luxdoo reeman por xSprijtaman. ");
INSERT INTO zasNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Dxel rëb béngunaa guin lojman: ―Naj ragbee guiꞌt bén na̱j Mesías, bén la gajc, Cristo. Abiꞌ chi guiꞌtaman, laaman gusigniaꞌ dunuj ree gran. ");
INSERT INTO zasNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Abiꞌ rëb Jesús: ―Najn na̱j bén zii, laaman caneenë lüj. ");
INSERT INTO zasNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Loj hor guin badxin ree xbejn Jesús, abiꞌ dád badxaloj reeman guial cayünëman tijb béngunaa diidx. Per niꞌqui tijb reeman ad gunabdiidxt lojman xhie rënman o xhie diidxan cayü reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Guiáad béngunaa guin basaꞌn xreman roꞌ bizë guin, dxel ziaman luguiedx guin, abiꞌ rëbaman loj ree bejn: ");
INSERT INTO zasNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Gol taquiaa tijb bén ma na graczi ni ma benan. ¿Nid laaman na̱j Cristo ya? ");
INSERT INTO zasNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Dxel brii reeman luguiedx guin zë reeman lod zaꞌ Jesús. ");
INSERT INTO zasNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Per laꞌtgaj zia béngunaa guin luguiedx guin, rëb ree xbejn Jesús lojman: ―Mextr, gudaw. ");
INSERT INTO zasNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Per rëbaman loj reeman: ―Laa da guialrawan yuꞌ, ni ad nünbeetidi. ");
INSERT INTO zasNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Dxel guzuloj canabdiidx loj lasaꞌ reeman rëb reeman: ―¿Ni yuꞌ chu bidnë ni gudawaman yaꞌn? ");
INSERT INTO zasNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Dxel rëb Jesús loj reeman: ―Da guialrawan na̱j günan ziꞌc rën Dios, bén guxhaal naj abiꞌ guloox günan ni naman. ");
INSERT INTO zasNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Lëjt rëb: “Ryaadx zatajp bëëw din gac ni yuꞌ loj guiniaa.” Per naj rni lëjt: Gol gules lojdi, gol baguiaa loj ree guiniaa, ma na̱j reen din yadoꞌp reen. ");
INSERT INTO zasNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Abiꞌ bén ratoꞌp loj guiniaa guin, rtiaꞌman ni rayalaman por dxiin ni rüjnman. Guiáad ni ratoꞌpaman na̱j par lod yuꞌ guialnaban tiblayaa. Dxel ziꞌc bén rxübin ziꞌc bén ratoꞌp, rabaa reeman tiblojzi. ");
INSERT INTO zasNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Waliqui ni rëb ree bejn: “Ben ren rxübin, ben ren ratoꞌp guialnazaꞌc.” ");
INSERT INTO zasNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Naj guxhal lëjt din chigtoꞌpidi guialnazaꞌc lod ad beentidi dxiin. Ben ren ree been dxiin, guiáad lëjt gaz bigtoꞌpidi guialnazaꞌc lod ad beentidi dxiin. ");
INSERT INTO zasNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Zien ree bén Samaria bililadx Jesús guial be béngunaa guin diidx loj reeman rëbaman: “Ma gunaman graczi ni benan.” ");
INSERT INTO zasNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Zeel chi bidxin reeman lod zaꞌ Jesús, guzajc reeman laaman liaadx din yayaꞌnnëman laa reeman. Dxel bayaꞌnnëman laa reeman tioꞌp dxej. ");
INSERT INTO zasNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Abiꞌ mazri zien reeman bililadx laaman chi biguiejn reeman ni rnieeman, ");
INSERT INTO zasNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","dxel rëb reeman loj béngunaa guin: ―Bajy yan ad por ni natzil raliduladxan laaman, nëgajc dunujn ma baguiejn ni rnieeman, abiꞌ rayagbeen walican laaman na̱j Cristo, bén yabëë bénguidxliuj loj dol. ");
INSERT INTO zasNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Chi goc tioꞌp dxej guin, baza Jesús niz Samaria abiꞌ zëman niz Galilea, ");
INSERT INTO zasNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","majsi laagajcaman rëb guial niꞌqui tijb bén rudëë xtiidx Dios loj ree bejn ad rajpt reeman laaman respejt ladx gajcaman. ");
INSERT INTO zasNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Per chi badxinman niz Galilea, bén niz ni ree bacaꞌ reeman laaman zagdxe. Din në laa reeman wej lanij pascw Jerusalén, abiꞌ baguiaa reeman gra ni beenman ni. ");
INSERT INTO zasNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Chi zaꞌman niz ni wejman Caná stijb, lod bayüjnman nijs vin. Abiꞌ luguiedx Capernaum guyu tijb xbejn rey ragxuu xiꞌnman. ");
INSERT INTO zasNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Chi gogbee bén guin baza Jesús niz Judea badxinman niz Galilea, wejman lod zaꞌ Jesús bisajcaman laaman liaadx din cheman yayüjnman xiꞌnman guial zamer guiëtix. ");
INSERT INTO zasNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Abiꞌ rëb Jesús lojman: ―Lëjt, bal id zuguiaadi xhie ree sen o milagr ree, ad zaliladxtidi. ");
INSERT INTO zasNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Per rëb bén guin: ―Dad, yoꞌ yan gajc, naga gad da xiꞌnan guiët. ");
INSERT INTO zasNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Dxel rëb Jesús lojman: ―Baguiaj lidxil, ma bayajc xiꞌnl. Bililadx bén guin ni rëb Jesús, abiꞌ zia lidxaman. ");
INSERT INTO zasNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Laꞌtgaj ziaman, bigchaagloj ree xmojsaman laaman, abiꞌ rëb reeman: ―Ma bayajc xiꞌnl. ");
INSERT INTO zasNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Dxel gunabdiidxaman loj reeman, rëbaman: ―¿Xhie hor guzuloj banaa da xiꞌnan? Abiꞌ rëb reeman lojman: ―Nieey cost raca tijb wadxe bariix xliaa. ");
INSERT INTO zasNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Dxel basaaladx bén guin guial hor ziin rëb Jesús lojman: “Ma bayajc xiꞌnl.” Abiꞌ laaman në gra bén zojb lidxaman bililadx reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ni ne na̱j milagr barojp ni been Jesús niz Galilea chi bazaman niz Judea. ");
INSERT INTO zasNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Chi gudëd gojc zian, guyu tijb xlanij ree bén Israel, abiꞌ wej Jesús Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalén guin, gajxh roꞌ port la xport ree Xiil, na̱j tijb tanc roꞌ, diidx hebreo lan Betesda, yuꞌ gaay xcurduran. ");
INSERT INTO zasNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Yagaj rigaꞌ zien ree bénragxuu, ziꞌc ree bénlutiaꞌp, në ree bencoj con ree bén ad rajctczi rza, cabëz reeman guiniib nijs yuꞌ lën tanc guin. ");
INSERT INTO zasNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Din gocli goc rguiajt tijb xianjl Dios runiibaman nijs guin, abiꞌ bén ru lojnijs guin yaloj chi caniiban, rayajcaman xhietëëz guialguijdxan rajcaman. ");
INSERT INTO zasNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Dxel loj ree bén guin noꞌch tijb bejn, ma gojc ziꞌctiubichoon ijz ragxuuman. ");
INSERT INTO zasNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Chi baguiaa Jesús laaman nagaꞌman yagaj, abiꞌ gogbeeman guial gocli ragxuuman dxel gunabdiidxaman lojman rëbaman: ―¿Rënl ya yayajquil? ");
INSERT INTO zasNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Badxiꞌ bénragxuu guinan rëbaman: ―Dad, achut raꞌpan gudxeꞌ naj loj nijs guin chi riniiban. Beegaj chi rënan gayuꞌn, yalojl ben ren ru. ");
INSERT INTO zasNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Dxel rëb Jesús lojman: ―Bixche, bacaꞌ ni naal loj, baguiaj. ");
INSERT INTO zasNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Loj hor guin gajc bayajc bén guin, bacaꞌ ni naaman loj abiꞌ guzuloj cazaman. Per guial dxej zii na̱j dxej raziiladx ree bén Israel, ");
INSERT INTO zasNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","zianz bén Israel zinal ree ley rëb reeman loj bén bayajc guin: ―Yandxej na̱j dxej raziiladx bejn, ad zajct yacaꞌ ni goꞌtil loj. ");
INSERT INTO zasNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Badxiꞌ bén guinan rëbaman: ―Bén bayüjn naj naman: “Bacaꞌ ni naal loj, baguiaj.” ");
INSERT INTO zasNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Dxel gunabdiidx reeman lojman rëb reeman: ―¿Chu na lojl: “Bacaꞌ ni naal loj, baguiaj”? ");
INSERT INTO zasNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Per bén guin ad ragbeetaman chunin bayüjn laaman guial biꞌch Jesús loj ree benzien rigaꞌ yagaj. ");
INSERT INTO zasNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Chi badxaag Jesús laaman lën yadooroꞌ Jerusalén, abiꞌ rëbaman lojman: ―Baguiaa ma bayajquil, ad güünril dol chitëë gaquil mazri guial loj ni goquil. ");
INSERT INTO zasNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Dxel zia bén guin abiꞌ biguiedxaman loj ree bén Israel guial Jesús na̱j bén bayüjn laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Zeel guzunal reeman Jesús din gugüjt reeman laaman, guial rüjnman milagr guin ree dxej raziiladx bejn. ");
INSERT INTO zasNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Per rëb Jesús loj reeman: ―Da Dadan Dios ad rbëzt rüjnman ni rayal güünman, zeel nëgajc naj rün ziꞌc rüjnman. ");
INSERT INTO zasNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Zianan zeel mazri rejs guzuj reeman din gugüjt reeman laaman, ad guialzi rüjntaman ni ad najt gac dxej raziiladx bejn, në guial rüjn laagajcaman ziꞌc Dios chi rnieeman guial quijb xDadaman na̱j Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Rëb Jesús loj reeman: ―Diidxliczi rnin, achet zajc güün Xiꞌn Dios por xixgabzaman, rüjnman ni ruguiaaman rüjn xDadaman. Din graczi ni rüjnman rüjn gajc xiꞌnman. ");
INSERT INTO zasNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Din Dios rën xiꞌnman abiꞌ rulüüman laaman gra ree ni rüjnman. Abiꞌ mazri na̱j ni gulüü loj xiꞌnman ni yadxa daꞌt lojdi. ");
INSERT INTO zasNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Din ziꞌc rasban Dios bengüt ree rudëë tëëman guialnaban loj reeman, ziangajc rudëë xiꞌnman guialnaban loj ree bén nüjnman xgab. ");
INSERT INTO zasNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Abiꞌ ad Diost rüjn guialguxtis, bazuj xiꞌnman din güünman guialguxtis, ");
INSERT INTO zasNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","din gap gra ree bejn xiꞌnman respejt ziꞌcgajc rajp reeman laaman respejt. Bén ad rajpt Xiꞌn Dios respejt, ad rajp gajctaman respejt xDadaman Dios, bén guxhaal laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Diidxliczi rnin: Bén ruzoob da diidxan rliladx tëëman Dios, bén guxhaal naj, laaman ma rajp guialnaban tiblayaa lojman. Abiꞌ ad rayaltraman casti din ad najtraman ziꞌc bengüt par Dios, rajpaman guialnaban lojman. ");
INSERT INTO zasNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Diidxliczi rnin ma bidxin hor, abiꞌ yandxej gajcan, bén na̱j ree ziꞌc bengüt loj Dios gucaagdiajg reeman chaꞌ xiꞌnman. Abiꞌ ree bén guzoob xtiidxaman zajp reeman guialnaban tiblayaa con Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Din ziꞌc rajp Dios guialnaban, lasaꞌgajc guialnaban guin ma badëë loj xiꞌnman, ");
INSERT INTO zasNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","abiꞌ badëëman guialrniabee lojman din güünman guialguxtis, din laaman na̱j Bén guxhaal Dios loj guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ad bal radxa lojdi ni rnin, din zadxin dxej guien gra ree bengüt chaꞌ Xiꞌn Dios, ");
INSERT INTO zasNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","abiꞌ yarii reeman lën baa. Dxel bén been ree ni ruladx Dios, yaban reeman, din gap reeman guialnaban tiblayaa con laaman. Guiáad ree bén been ni mal, yaban reeman din yayal reeman casti ni rayal reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Achet zajc günan por da xgabzan, rünan guialguxtis ziꞌc rniabee da Dadan. Abiꞌ rünan guialguxtis ziꞌc rayal, din ad rüntanan ziꞌc na̱j da xgaban, rünanan ziꞌc rën da Dadan bén guxhaal naj. ");
INSERT INTO zasNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Bal gü da diidx gajcan, achet lasajcan. ");
INSERT INTO zasNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Per yuꞌ ben ren rü da diidxan, abiꞌ ragbeechaawan guial diidxlin. ");
INSERT INTO zasNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Lëjt guxhaal bén bignabdiidx ree loj Waj, abiꞌ laaman ganax ni diidxli gunaman. ");
INSERT INTO zasNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Majsi ad ryaadxt yadxiꞌn ni gunee ree bejn por naj, per canin lojdi ni guna Waj din chililadxidi gap tëëdi perdon. ");
INSERT INTO zasNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Waj goc ziꞌcgajczi tijb bajl ni reꞌc abiꞌ rusnin, guiáad lëjt dád babaadi bidxgaꞌdi tijb tiamp ni balüüman lëjt. ");
INSERT INTO zasNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Per naj mazri na̱j ni gulün lëjt guial loj ni balüü Waj lëjt por naj. Din ni na da Dadan Dios günan, laanan cayünan yan din guiguien guial diidxli laaman guxhaal naj. ");
INSERT INTO zasNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Në da Dadan bén guxhaal naj, laagajcaman be da diidxan, majsi ad waguiejntidi chaꞌman ad waguiaa tëëtidi laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ad yuꞌguijc tëëtidi xtiidxaman zeel ad rliladxtidi bén guxhaalaman. ");
INSERT INTO zasNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Lëjt con cudad daꞌt roolidi loj xtiidx Dios, guial ragbeedi con laan gapidi guialnaban tiblayaa con Dios. Abiꞌ majsi loj xtiidx gajcaman ruzaꞌt naj, ");
INSERT INTO zasNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","per ad rëntidi chililadxidi naj din gapidi guialnaban guin. ");
INSERT INTO zasNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Naj ad raguiltan guilies ree bejn da valoran. ");
INSERT INTO zasNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Abiꞌ ragbeechaawan guial ad walit rëndi Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Naj zial por da Dadan abiꞌ ad ridxgaꞌtidi naj. Per bal stijb bejn guiꞌt por laagajcaman, laaman guidxgaꞌdi. ");
INSERT INTO zasNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Xoza chililadxidi naj? Awa mazri naguiejn rüjndi guilies ree bejn xvaloridi luar yayaꞌndi zagdxe loj bén na̱j tijbzi Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ad bal naladxidi naj gabec xguialquiadi loj Dios, din bén cweꞌc xguialquiadi na̱j Moisejs, bén rbëzidi güün lëjt yudar. ");
INSERT INTO zasNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Bal bililadxidi ni rëb Moisejs, në naj zaliladxidi, din Moisejs bacaa loj xtiidx Dios lod ruzaꞌt naj. ");
INSERT INTO zasNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Per bal id rliladxidi ni bacaaman, ¿xoza chililadxidi ni rnin lëjt? ");
INSERT INTO zasNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Chi gudëd gojc zian, dxel zë Jesús stiblad roꞌnijsdoo rigaꞌ niz Galilea, nijsdoo la gajc Tiberias. ");
INSERT INTO zasNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Bénguixiuj binal laaman, guial ruguiaa reeman milagr ree ni rüjnman rayüjnman bénragxuu ree. ");
INSERT INTO zasNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Dxel wëꞌpaman tijb ruguiaꞌ abiꞌ gurenë ree xbejnman. ");
INSERT INTO zasNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Dxejzii ree ma zidyob pascw, xlanij ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Chi gules loj Jesús, abiꞌ baguiaaman zëëd ree bénguixiuj lod zaꞌman, dxel rëbaman loj Felip: ―¿Ban yusii ree ni gaw gra ree bén guin? ");
INSERT INTO zasNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Per rëbzaman zian din guidoon xhie guiëb Felip, din Jesús mal ragbeeman xhie güünman. ");
INSERT INTO zasNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Dxel badxiꞌ Felipan rëbaman: ―Niꞌqui ni rüjn bejn gan loj xhujn bëëw ad zadaant yoꞌ guiadxtil din gaw tijbgaj reeman majsi tibliaꞌdogajzan. ");
INSERT INTO zasNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Dxel gunee stijb xbejn Jesús, bén la Andrejs bijch Simón Bëd, rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Laa tijb xindo caꞌ gaay guiadxtil con zatioꞌp bëjl zaꞌ guie. Per, ¿tëꞌczi taan ni guin par gra bén guin? ");
INSERT INTO zasNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Dxel rëb Jesús: ―Gol güjdx loj gra reeman din cwe reeman. Abiꞌ guial yuꞌ daꞌt guixyaꞌ yagaj, dxel gurej reeman. Na̱j reeman cost gaay mil xinguiaaw. ");
INSERT INTO zasNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Dxel cwaꞌ Jesús guiadxtil guin ree. Chi gulox badëëman quixtëë loj Dios, badëëman laa reen loj ree xbejnman persi gudiꞌs reeman laa reen loj gra ree bén zojb yagaj. Ziangajc beenman con ree bëjl guin, badëëman laa reen ziꞌctzi guyën reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Chi ma bixienladx reeman, dxel rëbaman loj ree xbejnman: ―Gol batoꞌp gra ree ni laay bayaꞌn, chitëë xhie guizëëb. ");
INSERT INTO zasNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Zianz batoꞌp reeman laa reen, abiꞌ bacha reeman chiptioꞌp dxüm nilaay bayaꞌn ree loj gaay guiadxtil guin. ");
INSERT INTO zasNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Chi baguiaa ree bejn milagr naroob ni been Jesús, rëb reeman: ―Walican bén guin na̱j bén rudëë xtiidx Dios loj ree bejn, bén na̱j guiꞌt loj guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Per gogbee Jesús guial rën reeman chinë naguiejn reeman laaman din güün reeman laaman rey, dxel bazaman yagaj, wëꞌpaman mazri ladya guijc guiaꞌ guin, lod su xtijbaman. ");
INSERT INTO zasNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Chi ma cabej guiaal, biguiajt ree xbejn Jesús roꞌnijsdoo, ");
INSERT INTO zasNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","guyu reeman loj tijb barcw, abiꞌ cadëd reeman loj nijs guin din guidxin reeman Capernaum. Ma bicajy, guiáad Jesús gadaman yadxin. ");
INSERT INTO zasNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Dxel guzuloj cabiꞌ bidoxh abiꞌ wajs xtüjp nijs guin. ");
INSERT INTO zasNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Chi ma gojc ziꞌc gaay o xhoꞌp kilometro zë reeman, baguiaa reeman caza Jesús lojnijs guin cabigaman lod zë barcw guin, dád bidxeb reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Per rëbaman loj reeman: ―¡Najn, ad rdxebidi! ");
INSERT INTO zasNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Dxel guyën reeman niuman loj barcw guin, per hor guin gajc bidxin reeman lod zë reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Chi bareguiaal, bén rigaꞌ ree stiblad roꞌ nijs guin, ragbee reeman guial tijbzi barcw guzu yagaj, abiꞌ gogbee reeman, lojn zë ree xbejn Jesús per ad nët laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Loj hor zii bidxin ree barcw ren za guiedx Tiberias, gajxh lod gudaw reeman guiadxtil chi gulox badëëd Jesús quixtëë loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Chi baguiaa reeman achutri Jesús zaꞌ yagaj niꞌqui ree xbejnman, dxel wëꞌp reeman loj ree barcw guin, zë reeman Capernaum zigdiil reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Chi bidxin reeman Capernaum, badxejl reeman Jesús, abiꞌ gunabdiidx reeman lojman, rëb reeman: ―Mextr, ¿goc biꞌtil guie? ");
INSERT INTO zasNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Badxiꞌ Jesúsan rëbaman: ―Ragbeechaawan, raguiilidi naj guial gudawidi xt bigdxinladxidi, ad guial baguiaatidi milagr ree ni rünan. ");
INSERT INTO zasNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ad chuꞌdi xgab guialraw rara, gol guyu xgab guialraw runee guialnaban tiblayaa con Dios. Din laan na̱j ni runee Bén guxhaal Dios loj guidxliuj guial ma bacaabee Dios laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Dxel gunabdiidx reeman lojman rëb reeman: ―¿Xhie rayal yaguieenan din chileꞌ yaguieenan ni rën Dios? ");
INSERT INTO zasNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Badxiꞌ Jesús laan rëbaman: ―Ni rën Dios güündi na̱j guial chililadxidi bén guxhaalaman loj guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Dxel rëb reeman lojman: ―¿Xhie gulüül dunujn din yaliduladxan lüj? ¿Xhietëë ree milagr rüjnl? ");
INSERT INTO zasNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Dux béngulal ree gudaw reeman mana chi guzu reeman niz loj yujbidx, ziꞌc rëb loj xtiidx Dios: “Badëëman guiadxtil biajb xanyabaa loj reeman gudaw reeman.” ");
INSERT INTO zasNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Badxiꞌ Jesús laan rëbaman: ―Naj rni lojdi: Ad Moisejst badëëd guiadxtil guin, da Dadan na̱j bén runee quijb guiadxtil za xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Guiadxtil runee Dios, laan biꞌt diizd xanyabaa abiꞌ runeen guialnaban loj bénguidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Abiꞌ rëb reeman lojman: ―Dad, banee guiadxtil guin du lojn zianczi. ");
INSERT INTO zasNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Rëb Jesús loj reeman: ―Naj na̱j guiadxtil runee guialnaban guin. Bén guiꞌt lon, ad yuꞌt dxej guiliaanman, ziangajc bén chililadx naj, ad yuꞌt dxej cheꞌcaman nijs. ");
INSERT INTO zasNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Per ziꞌc rnin lojdi, majsi ma baguiaadi naj, ad rliladxtidi naj. ");
INSERT INTO zasNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Gra ree bén ma banee da Dadan lon, guiꞌt reeman lon, abiꞌ bén guiꞌt lon, ad zasiejctan laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Din naj zial diizd xanyabaa, zidgaguienan ziꞌc rën da Dadan bén guxhaal naj, ad par güntan ziꞌc rënan. ");
INSERT INTO zasNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Da Dadan bén guxhaal naj, ni rënman na̱j guial gra ree bén baneeman lon niꞌqui tijb reeman ad zunijttan, rënman yasbanan laa reeman chi nit guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Din rënman guial gra ree bén yayagbee Xiꞌnman chililadx tëë reeman laaman, gap reeman guialnaban tiblayaa con laaman, guiáad naj yasban laa reeman chi nit guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Dxel guzuloj ree bén Israel caneeguijdx reeman Jesús, guial rëbaman: “Naj na̱j guiadxtil ni biguiajt diizd xanyabaa.” ");
INSERT INTO zasNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Abiꞌ rëb reeman: ―¿Nid laaxan na̱j Jesús ya, xiꞌn Xiëb? Dunuj ree naguieenbee xdadix con xniaax. Yan, ¿chexc zeel nax xanyabaa biguiajtix? ");
INSERT INTO zasNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Dxel rëb Jesús: ―Gol bacwëëz rnieeguijdxidi naj loj lasaꞌdi. ");
INSERT INTO zasNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Dios na̱j bén guxhaal naj. Achut zileꞌ guiꞌt lon bal id zëëdaman por da Dadan, abiꞌ naj yasban laaman chi nit guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Loj ree libr ni bacaa ree bén badëë xtiidx Dios loj ree bejn, rëb: “Dios gulüü gra ree bejn.” Zeel gra ree bén rucaagdiajg xtiidxaman, rusiid tëë reeman ni rulüüman laa reeman, laa reeman zëëd lon. ");
INSERT INTO zasNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Achutczi waguiaa da Dadan Dios, tijbzi bén guxhaalaman loj guidxliuj ma baguiaa laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Diidxliczi rnin, bén rliladx naj rajpaman guialnaban tiblayaa con Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Naj na̱j guiadxtil ni runee guialnaban. ");
INSERT INTO zasNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Xbéngulalidi gudaw mana loj yujbidx, per niꞌczi zian güjt gajc reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Per naj canin lojdi xcwent guiadxtil za xanyabaa, bén gaw laan gapaman guialnaban tiblayaa con Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Naj na̱j guiadxtil naban ni biyajb diizd xanyabaa. Bén gaw guiadxtil guie zajpaman guialnaban tiblayaa con Dios. Guiadxtil ni rudëdan, laan na̱j quijb da cuerpan, gudëdanan din gap ree bénguidxliuj guialnaban. ");
INSERT INTO zasNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Dxel guzuloj ree bén Israel guin cadildiidx reeman, rëb reeman: ―¿Xhienaag gunee xin guin xcuerpix yadaaw ree? ");
INSERT INTO zasNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Abiꞌ rëb Jesús loj reeman: ―Naj rni lëjt, bal id zajwidi xcuerp Bén guxhaal Dios, bal id zëꞌ tëëdi xrejnman, ad zajptidi guialnaban. ");
INSERT INTO zasNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Per bén gaw da cuerpan guiëꞌ tëëman da rejnan, zajpaman guialnaban tiblayaa con Dios, abiꞌ naj yasban laaman chi nit guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Din da cuerpan na̱j quijb guialraw, guiáad da rejnan na̱j quijb ni guiëꞌ bejn. ");
INSERT INTO zasNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Abiꞌ bén raw da cuerpan rëꞌ tëëman da rejnan, laaman nabannë naj, guiáad naj nabannëꞌ laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Da Dadan bén guxhaal naj, rajpaman guialnaban, abiꞌ naj nabanan por laaman. Ziangajc bén gaw da cuerpan, zajpaman guialnaban tiblayaa con Dios por naj. ");
INSERT INTO zasNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Naj cani xcwent guiadxtil ni biguiajt xanyabaa. Abiꞌ guiadxtil guie ad najtan ziꞌc na̱j mana ni gudaw xbéngulalidi, din laa reeman majsi gudaw reeman mana guin, per güjt gajc reeman. Guiáad bén gaw guiadxtil guie zajpaman guialnaban tiblayaa con Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Zian balüü Jesús bejn ree lën yadoo Capernaum. ");
INSERT INTO zasNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Chi gulox bacaagdiajg reeman ni balüü Jesús laa reeman, zien ree bén zinal laaman rëb: ―Nawëëg daꞌt na̱j yayigniaꞌ ree ni naman. ¿Chu zajc guidxgaꞌ laaman? ");
INSERT INTO zasNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Chi gogbee Jesús ni canee reeman, gunabdiidxaman loj reeman, rëbaman: ―¿Rüjnnaa ni rnin lëjt ya? ");
INSERT INTO zasNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Xhieza güündi bal guguiaadi Bén guxhaal Dios yayëꞌpaman lod guzuman gocli? ");
INSERT INTO zasNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tijbzi por xSprijt Dios rajp bejn guialnaban tiblayaa, bejn ad zileꞌt güün laazaman xhienin. Abiꞌ naj por xSprijt Dios zëëd ree diidx ni gunen lojdi, por ree diidx guin rajp bejn guialnaban. ");
INSERT INTO zasNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Per lëjt yuꞌdi ad waliladxt. Rëb Jesús zian guial ragbeechaawaman diizd yaloj chu ree ad rliladxt laaman chu tëë yayü laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Rëb tëëman loj reeman: ―Zeel ma rnin lojdi guial achut zileꞌ guiꞌt lon bal id zëëdaman por da Dadan Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Diizd nadxel, zien ree bén zinal Jesús guroꞌnladx laaman, abiꞌ ad guzanëtri reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Dxel rëb Jesús loj guidxiptioꞌp ree xbejnman: ―¿Në lëjt rën yaguiaj ya? ");
INSERT INTO zasNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Per badxiꞌ Simón Bëd laan, rëbaman: ―Dad, ¿chu loj yoꞌn? Awa xtiidxil zidnë guialnaban tiblayaa con Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Dunujn ma baliduladx rayagbee tëën guial lüj na̱j Cristo, Xiꞌn Dios naban. ");
INSERT INTO zasNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Dxel rëb Jesús loj reeman: ―¿Nid naj gule guidxiptioꞌpidi ya? Abiꞌ yan tijb gajqui lëjt na̱j ziꞌc xindxab. ");
INSERT INTO zasNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Rëb Jesús zian por Judas Iscariote, xiꞌn Simón, din Judas guin na̱j bén bayü laaman, majsi tijb gajc xbejnman najman. ");
INSERT INTO zasNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Chi gudëd gojc zian, wej Jesús loj ree guiedx rigaꞌ niz Galilea. Ad guyëntaman niejman niz Judea, guial cayguiil ree bén Judea guin laaman din gugüjt reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Per guial ma zidyob lanij ni rüjn ree bén Israel, chi rbej reeman lën ranch, ");
INSERT INTO zasNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","rëb ree bijch Jesús lojman: ―Brii, wej niz Judea, din në ree xbejnl bén rigaꞌ ree niz ni guguiaa milagr rüjnl. ");
INSERT INTO zasNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Din chi chu rën gagbee bejn ni rüjnman, ad rayalt güünman laan ralan. Yan ziꞌc rüjnl milagr ree, beenan loj gra ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Gunee ree bijch Jesús zian, guial niꞌqui laa reeman ad rliladxt laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Dxel rëb Jesús loj reeman: ―Ad wadxint da horan, per par lëjt xhietëëz horan na̱j zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ad zajct guidxeꞌch bénguidxliuj lëjt, saꞌn naj rdxeꞌch reeman naj guial rën loj reeman ad laat na̱j ni rüjn reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gol wej lanij guin, saꞌn naj ad zazaagajtan, din ad wadxint hor ni gazaan. ");
INSERT INTO zasNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Chi gulox rëbaman loj reeman zian, bayaꞌnman Galilea. ");
INSERT INTO zasNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Chi ma zë ree bijch Jesús, dxel nëman zë lanij guin, per ralanzi zëman chitëë chu gagbee. ");
INSERT INTO zasNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Per yuꞌ ree bén Israel raguiil laaman loj lanij guin, rëb reeman: ―¿Con bén guin yaꞌn? ");
INSERT INTO zasNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Loj gra ree benzien we lanij guin, zienloj ni rniee reeman Jesús. Yuꞌ reeman rëb: “Benzaꞌcan”, yuꞌza reeman rëb: “Ad benzaꞌctan, rusquieeman bejn ree.” ");
INSERT INTO zasNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Per achutczi ruzaꞌt laaman loj gra bejn, guial rdxeb reeman guxtis Israel ree. ");
INSERT INTO zasNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Chi gurol xuman ni cayajc lanij guin, guyu Jesús lën yadooroꞌ Jerusalén, abiꞌ guzuloj culüüman bejn ree. ");
INSERT INTO zasNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Guiáad ree bén Israel badxaloj reeman, rëb reeman: ―¿Chexc yaꞌn contzi gra ragbeex, awa niꞌquid basiidtix? ");
INSERT INTO zasNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","17","Dxel rëb Jesús loj reeman: ―Ad guictan carii ni culün lëjt, zëëdan por Dios, bén guxhaal naj. Bal chu rën güün ziꞌc rënman, zigniaꞌman bal ni carii guicanan culün lëjt o zëëdan por Dios ya. ");
INSERT INTO zasNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Bén rulüü ganaxzi ni rbëëguijcaman, rüjnman laan din guilies ree bejn xvaloraman. Per bén rüjn mazri din guilies bejn xvalor Dios, bén guxhaal laaman, laaman rniee ni diidxli, ad rusquieetaman bejn. ");
INSERT INTO zasNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Yan, majsi basaꞌnnë Moisejs lëjt ley, per niꞌqui tijbidi ad rüjnt ziꞌc rëb ley guin. ¿Chexquiza zeel rëndi gugüjtidi naj? ");
INSERT INTO zasNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Badxiꞌ ree bén guinan, rëb reeman: ―Xindxab yuꞌ luxdool. ¿Chuczi rën gugüjt lüj? ");
INSERT INTO zasNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Abiꞌ rëb Jesús loj reeman: ―Por tijbzi milagr ni benan radxalojdi. ");
INSERT INTO zasNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Abiꞌ lëjt gunabee Moisejs lëjt guial gra ree xinguiaaw chuꞌ sen, (majsi ad por Moisejst ru bejn sen guin, mal rüjn ree dux bengol gulal ree zian), abiꞌ lëjt rguꞌdi bejn ree sen, majsi dxej raziiladx bejn. ");
INSERT INTO zasNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yan, bal chitëë gusaglojdi ley ni basaꞌnnë Moisejs lëjt, rguꞌdi sen bejn ree majsi dxej raziiladx bejn. ¿Chexquiza zeel ralendi guial bayünan tijb bénragxuu dxej raziiladx bejn? ");
INSERT INTO zasNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ad rüjndi xgabmal por ni ruguiaazidi rüjn bejn, yaloj xgaj gol gogbee zagdxe xhie cayüjnman. ");
INSERT INTO zasNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yuꞌ ree bén Jerusalén guzuloj rniabdiidx loj lasaꞌ reeman, rëb reeman: ―¿Nid bén guinan cayguiil reeman ya din gugüjt reeman laaman? ");
INSERT INTO zasNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Abiꞌ yan laaman canee niz loj ree bejn, abiꞌ niꞌqui chut xhie rëb lojman. ¿Ni ma bililadx ree guxtis yaꞌn guial laaman na̱j Cristo? ");
INSERT INTO zasNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Per dunuj ree rayagbeechaaw ban zaman, guiáad chi guiꞌt Cristo, achut gagbee ban saman. ");
INSERT INTO zasNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Chi biguiejn Jesús zian, laꞌtgaj culüüman bejn ree lën yadooroꞌ Jerusalén, dxel guneeman rejs rëbaman: ―¡Lëjt rëb nünbeedi naj abiꞌ ragbeedi ban guzaan! Per ad zialtan por naj gajc, zialan por quijb bén rniabee bén ad nünbeetidi. ");
INSERT INTO zasNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Per naj nünbee laaman guial zialan diizd lod zaꞌman, laa tëëman guxhaal naj. ");
INSERT INTO zasNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Chi biguiejn reeman zian, guyën reeman niniaaz reeman laaman, per achut gunaaz laaman, guial gad hor gal guiniaazaman. ");
INSERT INTO zasNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Loj ree bénguixiuj zaꞌ yagaj zien reeman bililadx laaman, abiꞌ rëb reeman: ―Chi guiꞌt Cristo, ¿wen mazri zien ree milagr güünman guial loj bén guin ya? ");
INSERT INTO zasNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Biguiejn ree bénfarisew ni rniee ree bejn Jesús. Abiꞌ laa reeman con ree bixhioz rniabee, guxhaal reeman bén rajp ree roꞌ yadooroꞌ Jerusalén din guiniaaz reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Dxel rëb Jesús: ―Ad xchejtri gazunëꞌn lëjt, dxel yayaꞌn lod zaꞌ bén guxhaal naj. ");
INSERT INTO zasNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yaguiilidi naj, per ad zadxejltidi naj, din ad zileꞌt guiꞌtidi lod gazun. ");
INSERT INTO zasNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Abiꞌ ree bén Israel guin guzuloj rniabdiidx loj lasaꞌ reeman, rëb reeman: ―¿Banczi zajc che bén guin din ad zadxejltaman? ¿Ni zejman lod zojb ree bén Israel loj ree benzit ya, chiglüüman laa reeman në ree bén ad najt bén Israel? ");
INSERT INTO zasNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Xhie rën guiëb guial naman: “Yaguiilidi naj per ad zadxejltan, din ad zileꞌt guiꞌtidi lod gazun”? ");
INSERT INTO zasNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Dxej rliox lanij guin na̱j mazri dxej zojbloj, dxejzii guzuli Jesús guneeman rejs, rëbaman: ―Bal chu lëjt reꞌc nijs, gol guda lon din guiëꞌdan. ");
INSERT INTO zasNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Din bén rliladx naj ziꞌc ca loj xtiidx Dios, lën luxdooman gach nijs runee guialnaban. ");
INSERT INTO zasNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Chi gunee Jesús zian, rën guiëb xtiidxaman guial gra ree bén chililadx laaman zabajnnë reeman xSprijt Dios. Din nadxel ad wayiꞌtt xSprijt Dios guial ad waguiajt Jesús lod canabeeman. ");
INSERT INTO zasNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yuꞌ ree bén noꞌch loj ree benzien guin, chi bacaagdiajg reeman ni gunee Jesús, rëb reeman: ―Walican, bén guin na̱j guiꞌt guidgadëë xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Yuꞌza reeman rëb: ―Bén guin na̱j bén bacaabee Dios. Per yuꞌ reeman rëb: ―Ad laataman na̱j Cristo, din ad niz Galileat na̱j griiman. ");
INSERT INTO zasNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Loj xtiidx Dios ca guial loj xdiaa rey Davi grii Cristo, abiꞌ Belén galaman ladx gajc rey Davi. ");
INSERT INTO zasNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Zian gojc dxel gulaꞌ lasaꞌ reeman por Jesús. ");
INSERT INTO zasNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Zien reeman guyën niniaaz laaman, per achut bayax niniaaz laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Chi bayejc ree bén rajp roꞌ yadoo guin lod zaꞌ ree bénfarisew guin con ree bixhioz rniabee guin. Rëb reeman loj reeman: ―¿Chexc zeel ad bidnëtidi laax? ");
INSERT INTO zasNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Dxel rëb ree bén rajp roꞌ yadoo guin: ―¡Ad goct wayu bén guiniee ziꞌc rnieex! ");
INSERT INTO zasNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Abiꞌ rëb ree bénfarisew guin: ―¿Në lëjt ma cwëjb basquieex lëjt ya? ");
INSERT INTO zasNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Wen yuꞌ ree dux guxtis ree, o bénfarisew ree ma bililadx laax ya? ");
INSERT INTO zasNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","¿Nid ragbeedi ya guial zien ree bén guin banijt loj Dios guial ad nünbeet reeman ley? ");
INSERT INTO zasNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Per bénfarisew la Nicodemo bén bignaj Jesús tijb guxhin, rëbaman loj reeman: ");
INSERT INTO zasNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Loj dux ley ree ca guial ad zileꞌt yaguieꞌch ree xhie casti rayal tijb bejn, chi gad dunuj ree yacaagdiajg xtiidxaman, din chileꞌ yayagbee ree xhie beenman. ");
INSERT INTO zasNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Badxiꞌ reeman laan rëb reeman: ―¿Wen në lüj zaꞌnë ree bén Galilea ya? Basiid zagdxe loj xtiidx Dios din gagbeel ad goct warii bén rudëë xtiidx Dios loj ree bejn niz Galilea. ");
INSERT INTO zasNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Dxel bareꞌch reeman zia lidx lidx reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Per Jesús zëman ruguiaꞌ Olivos. ");
INSERT INTO zasNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Chi bareguiaal, rsil badxinman lën yadooroꞌ Jerusalén stijb. Zien ree bejn bidoꞌp lod zaꞌman, dxel gurejman guzuloj culüüman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Abiꞌ mextr rulüü ree ley con ree bénfarisew bidxinnë tijb béngunaa banaaznë tijb xinguiaaw, dxel bazuj reeman laaman galay ree bén guin, ");
INSERT INTO zasNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","zianz rëb reeman loj Jesús: ―Mextr, banaaz béngunaa guie loj mer hor ni yuꞌnëman xinguiaaw ren. ");
INSERT INTO zasNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Abiꞌ loj ley basaꞌnnë Moisejs dunuj ree ca guial lasaꞌ béngunaa guie rayal guiëtaman con guiaj. ¿Laadx lüj xhie nal? ");
INSERT INTO zasNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Gunabdiidx reeman zian din guidoon xhie guiëbaman din gac gutediaꞌ reeman laaman. Per con basajb lojman abiꞌ guzulojman cucaaman luyuj con xbacwënman. ");
INSERT INTO zasNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Per guial laa reeman canabdiidxzi canabdiidx reeman lojman, abiꞌ babejliman, rëbaman loj reeman: ―Chutëëz bén ad wayüjnt dol, yaloj laaman gucaaguiaj béngunaa guie. ");
INSERT INTO zasNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Dxel basajb lojman stijb, basnuu bacaaman luyuj guin. ");
INSERT INTO zasNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Chi biguiejn reeman ni guneeman, guzuloj cayza tijbgaj reeman, diizd mazri bengol xt bara reeman baza. Tijbzi béngunaa guin bayaꞌn con Jesús loj ree bén rigaꞌ yagaj. ");
INSERT INTO zasNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Dxel babejliman, rëbaman loj béngunaa guin: ―¿Con ree bén bidnë lüj? ¿Niꞌqui tijb reeman achut xhie been lüj ya? ");
INSERT INTO zasNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Dxel rëb béngunaa guin: ―Dad, niꞌqui tijbaman. Abiꞌ rëb Jesús: ―Niꞌqui naj achet günan lüj. Baguiaj yan, ad güünril dol. ");
INSERT INTO zasNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Dxel gunee Jesús stijb, rëbaman loj ree bén rigaꞌ yagaj: ―Naj na̱j bajl rusni bénguidxliuj. Abiꞌ bén guzoob da diidxan, zani xquiarguiejnman xhienaag gapaman guialnaban tiblayaa con Dios, ad yuꞌ tëët dxej guicajy xquiarguiejnman. ");
INSERT INTO zasNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Abiꞌ ree bénfarisew rëb reeman lojman: ―Lüj gajc ruzaꞌt lüj, abiꞌ achet lasajc xtiidxil. ");
INSERT INTO zasNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Dxel rëb Jesús loj reeman: ―Lasajc da diidxan, majsi naj gajc cane por naj, din naj ragbee ban zialan ban tëë gan, saꞌn lëjt ad ragbeetidi ban zialan ban tëë gan. ");
INSERT INTO zasNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Lëjt rnieedi bejn ziꞌctizi na̱j xixgabidi, saꞌn naj achut ruzatan. ");
INSERT INTO zasNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Abiꞌ bal guzatan bejn, ganen diidxli, din ad zanetan ziꞌc na̱j da xgaban, në da Dadan bén guxhaal naj ragbee guial diidxli na̱j ni ganen. ");
INSERT INTO zasNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Abiꞌ loj xleydi ca guial chi yuꞌ tioꞌp bén rniee tiblojzi, diidxliqui na̱j ni rniee reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yan, naj gajc na̱j tijb bén rniee por naj, abiꞌ da Dadan bén guxhaal naj, na̱j stijb bén rniee por naj. ");
INSERT INTO zasNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Gunabdiidx reeman lojman rëb reeman: ―¿Con xdadil? Badxiꞌman laan rëbaman: ―Lëjt ad nünbeetidi naj, ad nünbee tëëtidi da Dadan, din bal nüjnbeedi naj, ziangajc nüjnbeedi da Dadan. ");
INSERT INTO zasNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Zian gunee Jesús laꞌtgaj rulüüman bejn ree lën yadooroꞌ Jerusalén, niz lod zaꞌ ree ni rguꞌ reeman gon. Per achut gunaaz laaman, din ad wadxint hor guiniaazaman. ");
INSERT INTO zasNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Gunee Jesús stijb, rëbaman: ―Chi ma gan, zaguiilidi naj, per zëjtnë xtolidi, din lod gan ad zileꞌt guiꞌtidi. ");
INSERT INTO zasNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Dxel rëb ree bén Israel guin: ―¿Wen ni laagajcaman gugüjt laaman ya, zeel naman guial ad zajct yoꞌ ree lod cheman? ");
INSERT INTO zasNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Abiꞌ rëb Jesús loj reeman: ―Lëjt na̱j bén ladguiajt guie, saꞌn naj ladya ni zialan. Lëjt na̱j bénguidxliuj, saꞌn naj ad bénguidxliujt na̱j. ");
INSERT INTO zasNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Zeel rnin, zëjtnë xtolidi. Din bal id zaliladxidi guial naj na̱j bén najn, zëjtnë xtolidi. ");
INSERT INTO zasNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Dxel gunabdiidx reeman lojman, rëb reeman: ―¿Chuza lüj? Badxiꞌman laan rëbaman: ―Ma rnin lojdi diizd yaloj. ");
INSERT INTO zasNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Zien ni raꞌpan gulün lëjt ni ganenëꞌ tëën lëjt. Per naj, ni canen loj bénguidxliuj na̱j ni rucagdiagan rniee bén guxhaal naj, abiꞌ ni rnieeman na̱j diidxli. ");
INSERT INTO zasNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Per laa reeman ad gogbeet guial Diosan ruzaꞌtaman. ");
INSERT INTO zasNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Zeel rëbaman loj reeman: ―Chi ma beendi ziꞌctizi rëndi con Bén guxhaal Dios, dxel gagbeedi najcan, gagbee tëëdi guial achetczi rünan por da xgabzan, naj rnie ni ma balüü da Dadan naj. ");
INSERT INTO zasNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Din laaman guxhaal naj, laaman zaꞌ con naj, abiꞌ ad yuꞌt dxej cwëëladxaman naj, guial zianczi rünan ni rayuladxaman. ");
INSERT INTO zasNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Chi rëb Jesús zian, zien ree bejn bililadx laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Rëb Jesús loj ree bén Israel bililadx laaman: ―Bal gusnuu guzoobidi da diidxan, waliqui najdi da bejnan, ");
INSERT INTO zasNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","abiꞌ züjnbeedi conin na̱j diidxli, abiꞌ por diidxli guin zalaadi. ");
INSERT INTO zasNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Badxiꞌ reeman laan rëb reeman: ―Dunujn zioꞌp loj xdiaa Abraham, abiꞌ ad yuꞌt dxej wayajcan ziꞌc bén nadoꞌ. ¿Chexquiza zeel nal du lojn, guial por diidxli zalaan? ");
INSERT INTO zasNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Dxel rëbaman loj reeman: ―Diidxli rnin lojdi, guial graczi bén rüjn ganaxzi dol, laa reeman na̱j ziꞌc bén nadoꞌ loj dol. ");
INSERT INTO zasNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Abiꞌ tijb bén nadoꞌ loj bejn, ad zileꞌt guiëbaman xfamilaman na̱j xpatronman, saꞌn xiꞌn patron guin zileꞌ guiëbix xfamilixan. ");
INSERT INTO zasNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Zeel bal Xiꞌnman guslaa lëjt, ad najtridi ziꞌc bén nadoꞌ. ");
INSERT INTO zasNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ma qui ragbeen guial loj xdiaa Abraham zëëdidi, per lëjt rën gugüjt naj guial ad rayuladxtidi da diidxan. ");
INSERT INTO zasNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Naj rni ni ma balüü da Dadan naj, saꞌn lëjt rüjndi ziꞌc na xDadidi güündi. ");
INSERT INTO zasNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Badxiꞌ reeman rëb reeman: ―Dux Dadan na̱j Abraham. Dxel rëb Jesús loj reeman: ―Bal niajquidi xiꞌn Abraham, züjndi ziꞌc beenman. ");
INSERT INTO zasNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Per yan, majsi ma rnin lëjt diidxli ziꞌc balüü Dios naj, lëjt rëndi gugüjtidi naj. ¡Abiꞌ Abraham ad yuꞌt dxej nüjnman zian! ");
INSERT INTO zasNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Saꞌn lëjt rüjndi ziꞌcgajc rüjn xDadidi. Abiꞌ rëb reeman loj Jesús: ―Dunujn achut mazri xiꞌn nayajcan. Tijbzi Dios na̱j dux Dadan. ");
INSERT INTO zasNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Dxel rëb Jesús loj reeman: ―Bal walidi Dios na̱j xDadidi, guiëndi naj, din por laaman zialan loj guidxliuj. Ad zialtan por naj gajc, zialan por Dios bén guxhaal naj. ");
INSERT INTO zasNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Abiꞌ ad rigniaꞌtidi ni rnin, guial ad rëntidi gucaagdiajguidi da diidxan. ");
INSERT INTO zasNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","XDadidi na̱j xindxab, abiꞌ rüjndi ziꞌc rënx güündi, din diizd yaloj ruladx xindxab guin gugüjtix bejn. Ad yuꞌt dxej chinalix ni na̱j diidxli, din ad rnieetix diidxli. Chi rnieex diidx rusquiee, achet naladxix, din laax na̱j xin rusquiee na̱j tëëx xdad guialrusquiee. ");
INSERT INTO zasNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Per guial naj rni lëjt ganax diidxli, ad rliladxtidi naj. ");
INSERT INTO zasNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Chu lëjt zajc na guial yuꞌ xhie dol ma benan? Abiꞌ bal diidxli na̱j ni canen, ¿chexquiza zeel ad rliladxtidi naj? ");
INSERT INTO zasNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Bén na̱j xbejn Dios rucaagdiajgaman xtiidxaman, per lëjt ad xbejntaman najdi, zeel ad rucaagdiajgtidi xtiidxaman. ");
INSERT INTO zasNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Dxel rëb ree bén Israel guin loj Jesús: ―Waliqui ni ranan guial xindxab yuꞌ luxdool na̱j tëël bén Samaria. ");
INSERT INTO zasNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Badxiꞌman laan rëbaman: ―Achut xindxab yuꞌ luxdon, naj cuzob xtiidx da Dadan, per lëjt ganax diidxguijdx rnieedi naj. ");
INSERT INTO zasNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Naj ad raguiltan guilies ree bejn da valoran, majsi yuꞌ bén rën güün bejn zian, abiꞌ laaman rüjn xguialguxtis. ");
INSERT INTO zasNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Diidxli rnin lëjt, bén guzoob da diidxan, ad yuꞌt dxej guiëtaman. ");
INSERT INTO zasNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Dxel rëb ree bén Israel guin lojman: ―Yanri ma rayagbeechaawan guial xindxabqui yuꞌ luxdool. Abraham në gra ree bén badëë xtiidx Dios loj ree bejn, güjt reeman, guiáad lüj nal: “Bén guzoob da diidxan, ad yuꞌt dxej guiëtaman.” ");
INSERT INTO zasNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Wen mazri lasajquil ya guial loj dux béngulal ree Abraham? Güjtaman, güjt tëë ree bén badëë xtiidx Dios loj ree bejn. ¿Laadx lüj chu naladxil najl? ");
INSERT INTO zasNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Abiꞌ rëb Jesús loj reeman: ―Bal naj gajc gales da valoran, achet lasajc ni ganen por naj. Per bén rlies da valoran na̱j da Dadan, bén nagajquidi na̱j xDiosidi. ");
INSERT INTO zasNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Lëjt ad nünbeetidi laaman, saꞌn naj nünbeen laaman. Abiꞌ bal ganin ad nünbeetan laaman, nëgajc naj ma na̱j bén rusquiee ziꞌcgajc lëjt. Per nünbeen laaman abiꞌ ruzoban xtiidxaman. ");
INSERT INTO zasNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Xbéngulalidi Abraham, babaaman guial guguiaaman dxej ni guialan. Abiꞌ chi baguiaaman dxej guin, mazri babaaman. ");
INSERT INTO zasNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Dxel rëb ree bén Israel guin lojman: ―Niꞌqui gadil chuꞌ tüꞌpchii ijz, ¿guiáad lüj ya nal baguiaal Abraham? ");
INSERT INTO zasNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Abiꞌ gunee Jesús rëbaman: ―Diidxli rnin lojdi, mal nabanan chi gad Abraham chuꞌ. ");
INSERT INTO zasNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Dxel gules reeman guiaj din nucaa reeman laan Jesús. Per laa guzëëb gajcaman galay ree bejn, abiꞌ gudëdaman galay reeman bariiman lën yadoo guin, laa zia gajcaman. ");
INSERT INTO zasNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Chi cadëd Jesús tiblajt, baguiaaman tijb xin ad ranit loj diizd chi golix. ");
INSERT INTO zasNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Dxel gunabdiidx ree xbejnman lojman, rëb reeman: ―Mextr, ¿chexc zeel ad ranit loj bén guin diizd chi golaman? ¿Por xtol ree xDadaman ya, o por xtol gajcaman? ");
INSERT INTO zasNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Badxiꞌ Jesúsan, rëbaman: ―Najman zian ad por xtoltaman ad por xtol tëët ree xDadaman. Gojlaman zian din chi yayajcaman, guguiaa ree bejn xguialrniabee naroob Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yan, laꞌtgaj yuꞌ tiamp, rüjn naguiejn yaguieen ree ni na bén guxhaal naj, din ma yayaaloj tiamp ni achetri zajc gac. ");
INSERT INTO zasNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Abiꞌ laꞌtgaj zaꞌn loj guidxliuj guie, naj na̱j bajl rusni bénguidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Chi gulox guneeman zian, guxhieꞌ xhiejnman luyuj, abiꞌ beennëman laan bajn, persi gudëëbaman laan guiaaloj xin guin. ");
INSERT INTO zasNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Abiꞌ rëbaman lojx: ―Bitiib lojl roꞌ tanc Siloé ―Siloé rën guiëb ni guxhaalaman. Dxel bitiib lojx, abiꞌ chi bayejquix, ma rani lojx. ");
INSERT INTO zasNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Dxel bén zojb ree gajxh lod zojbix con ree bén ragbee guial laax rniab carda, rëb reeman: ―¿Nid xin guinan rbej rniab carda ya? ");
INSERT INTO zasNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Yuꞌ reeman rëb: ―Laaquixan. Yuꞌza reeman rëb: ―Ad laatixan, rguienzix zian. Per laax rëb: ―Najcan. ");
INSERT INTO zasNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Dxel gunabdiidx reeman lojx, rëb reeman: ―¿Xhieza naag gojc bani lojl? ");
INSERT INTO zasNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Badxiꞌxan, rëbix: ―Bén la Jesús been bajn, gudëëbaman guiaalon abiꞌ naman: “Wej bitiib lojl roꞌ tanc Siloé.” Dxel wan, chi gulox gudiib lon, max bani lon. ");
INSERT INTO zasNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Abiꞌ rëb reeman lojx: ―¿Conzaman yan? Zeel rëbix: ―Ad ragbeetan. ");
INSERT INTO zasNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Loj hor zii binë reeman xin bayajc guiaaloj guin loj ree bénfarisew, ");
INSERT INTO zasNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","din dxej been Jesús bajn persi bayüjnman guiaaloj xin guin, dxej guin raziiladx ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Dxel gunabdiidx ree bénfarisew guin lojx xhienaag guzuloj rani lojx. Abiꞌ rëbix loj reeman: ―Jesús gudëëb bajn guiaalon, dxel bitiib lon, yan ma ranin. ");
INSERT INTO zasNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Yuꞌ ree bénfarisew guin rëb: ―Bén bayüjn guiaalojl ad xbejnt Diosan, din ad rajptaman respejt dxej raziiladx bejn. Per yuꞌza reeman rëb: ―¿Xhienaag güünman milagr guie ree, bal najman béndol? Garent garen rëb reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Abiꞌ gunabdiidx reeman loj xin bayajc guin zatijb, rëb reeman: ―¿Laadx lüj xhie nal chu na̱j bén bayüjn guiaalojl? Badxiꞌxan rëbix: ―Naj rni guial laaman na̱j bén rudëë xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Per bén Israel guin ree ad rliladxt reeman, din ad banit lojx abiꞌ yan ma ranin, dxel gurejdx reeman xdadix con xniaax, ");
INSERT INTO zasNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","abiꞌ gunabdiidx reeman loj reeman, rëb reeman: ―¿Xin guien na̱j xiꞌndi ya, xin rëbidi ad ranit loj diizd gojlix? Yan, ¿xhienaag gojc zeel ma ruguiaax? ");
INSERT INTO zasNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Badxiꞌ reeman laan rëb reeman: ―Dunujn rayagbee guial du xiꞌnanan, rayagbee tëën guial diizd chi golix ad ranit lojx. ");
INSERT INTO zasNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Per ad rayagbeetan xhienaag gojc zeel rani lojx, ad rayagbee tëëtan chu bayüjn guiaalojx. Gol gunabdiidx lojx, ma najx xingol, ma zajc na laagajquix lojdi xhienaag gojc. ");
INSERT INTO zasNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Rëb ree xdadix zian guial rdxeb reeman xguxtis ree bén Israel, din ma bayaꞌn reeman diidx, chutëëz bén guiëb guial Jesús na̱j Cristo, ad zatiëjbtri reeman chuꞌman lën yadoo. ");
INSERT INTO zasNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Zianan zeel rëb reeman: “Gol gunabdiidx lojx, ma najx xingol.” ");
INSERT INTO zasNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Dxel gurejdx reeman laax zatijb, abiꞌ rëb reeman: ―Laa Dios ruguiaa, guna diidxli, din dunujn rayagbee guial béndol na̱j bén bayüjn lüj. ");
INSERT INTO zasNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Badxiꞌxan rëbix: ―Ad ragbeetan bal béndolan o ad béndoltan ya. Tijbzi ni ragbeen na̱j guial ad banit lon, abiꞌ yan ma ruguian. ");
INSERT INTO zasNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Dxel gunabdiidx reeman lojx stijb, rëb reeman: ―¿Xhienaag beennëman lüj? ¿Xhienaag beenman persi rani lojl? ");
INSERT INTO zasNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Badxiꞌxan rëbix: ―Ma rnin lojdi, abiꞌ lëjt ad rliladxtidi naj. ¿Chexc zeel rëndi ganin zatijb xhienaag beenman? ¿Wen në lëjt rën gac xbejnman ya? ");
INSERT INTO zasNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Dxel gudilë reeman laax rëb reeman: ―Lüj bal najl xbejnman, saꞌn dunujn xbejn Moisejs nayajcan. ");
INSERT INTO zasNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Din dunujn rayagbee Dios gunee Moisejs, per bén guin niꞌquid rayagbeetan ban zaman. ");
INSERT INTO zasNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Badxiꞌxan rëbix: ―¡Xhiechalnin zeel ad ragbeetidi ban zaman! Guiáad naj por laaman ma rani lon. ");
INSERT INTO zasNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Dunuj ree rayagbeechaaw guial ad ridxgaꞌt Dios xtiidx ree béndol, ridxgaꞌman xtiidx ree bén ruzoob xtiidxaman rüjn tëë reeman ziꞌc rënman. ");
INSERT INTO zasNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ad goct wacaagdiajg ree guial chuꞌ bén yayüjn loj bén ad ranit loj diizd gojlaman. ");
INSERT INTO zasNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Yan, bal id por Dios zëëd bén guin, achetczi nileꞌ nüjnman. ");
INSERT INTO zasNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Dxel rëb reeman lojx: ―Lüj gojl con dol, ¿wed lüj gulüü dunujn? Abiꞌ babëë reeman laax yagaj. ");
INSERT INTO zasNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Gogbee Jesús ni guzac xin bayüjnman, dxel chi badxaagaman laax, rëbaman lojx: ―¿Rliladxil bén guxhaal Dios loj guidxliuj ya? ");
INSERT INTO zasNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Badxiꞌxan rëbix: ―Dad, guna chunin, din chililadxan laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Dxel rëbaman lojx: ―Ma baguiaal laaman, laaman na̱j bén caneenël. ");
INSERT INTO zasNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Abiꞌ bazuxib xin guin lojman, rëbix: ―Rliladxan lüj, Dad. ");
INSERT INTO zasNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Zianz rëb Jesús: ―Bialan loj guidxliuj guie din günan guialguxtis, din por naj yani loj ree bén ad ranit loj, guiáad ree bén rani loj, ad zanit loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Yuꞌ ree bénfarisew zaꞌnë laaman. Chi biguiejn reeman rëbaman zian, rëb reeman: ―¿Wen në dunujn ad ranit duloj ya? ");
INSERT INTO zasNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Dxel rëb Jesús loj reeman: ―Bal id rani lojdi, achet dol rajpidi. Per guial nadi rani lojdi, rajpidi dol por ree xtolidi. ");
INSERT INTO zasNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Rëb tëë Jesús: ―Diidxliczi rnin lojdi, bén ad rut niz roꞌ xgurajl ree xiil, bén ru niz lood ren, laaman na̱j béngubaan. ");
INSERT INTO zasNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Per bén ru niz roꞌ xgurajl reeb, laaman na̱j bén rniaj laa reeb. ");
INSERT INTO zasNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Abiꞌ rxhial bén rajp roꞌ xgurajl reeb persi ru bén rniaj laa reeb, abiꞌ chi rbejdxaman tijbgaj reeb, rayünbee reeb chaꞌman. Zianz rbëëman laa reeb lën gurajl guin. ");
INSERT INTO zasNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Abiꞌ chi ma brii gra reeb, dxel rniedaman loj reeb, guiáad laa reeb rnal laaman, guial nünbee reeb chaꞌman. ");
INSERT INTO zasNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Per ad rnalt reeb tijb bén ad nünbeet reeb, ruxüünl reeb lojman, guial ad nünbeet reeb chaꞌman. ");
INSERT INTO zasNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Chi gulox gunee Jesús zian, ad bigniaꞌt ree bén rigaꞌ yagaj xhie rën guiëb ni guneeman. ");
INSERT INTO zasNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Rëb Jesús loj reeman zatijb: ―Diidxliczi rnin, naj na̱j ziꞌc roꞌ xgurajl ree xiil, lod ru reeb. ");
INSERT INTO zasNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Gra ree bén biꞌt chi gad naj guial na̱j reeman ziꞌc béngubaan, rban reeman rusagzi tëë reeman. Per ree bén na̱j da bejnan ad bidxgaꞌt reeman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Naj na̱j roꞌ port, abiꞌ bén ru roꞌ port guie zajpaman perdon, dxel ma zileꞌ chuꞌman yarii tëëman ziꞌcgajczi tijb xiil abiꞌ zian rdxejl ni rawib. ");
INSERT INTO zasNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Béngubaan riꞌtzaman din cwanman, gugüjtaman gunijt tëëman, saꞌn naj zialan din gapidi guialnaban, gap tëëdi zroꞌ daꞌtan. ");
INSERT INTO zasNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Naj na̱j ziꞌc tijb bén rniaj xiil ree zagdxe. Abiꞌ bén rniaj xiil ree zagdxe xt xguialnabanman rudëëman por laa reeb. ");
INSERT INTO zasNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Per bén rniaj laa reeb por milia, chi ruguiaaman zëëd cuyojt, laa ruxüün gajcaman, rbëëladxaman xiil guin ree guial ad najt reeb xi xiilaman në guial ad najtaman bén rniaj ree xiil, dxel rniaaz cuyojt guin laa reeb abiꞌ rtieꞌchib laa reeb. ");
INSERT INTO zasNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Laaman rbëëladx laa reeb, din por miliazi rniajman laa reeb abiꞌ achet naladxaman por laa reeb. ");
INSERT INTO zasNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’Naj na̱j ziꞌc bén rniaj xiil ree zagdxe. Abiꞌ ziꞌc nünbee da Dadan naj, zian nünbeen laaman, ziangajc nünbee ree da xiilan, guiáad laa reeb nünbee naj. Abiꞌ xt da guialnabanan gudëdan por laa reeb. ");
INSERT INTO zasNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Raꞌp tëën stibcwaa ree xiil ad yuꞌt lën gurajl guie. Në laa reeb ryaadx chigxin, laa reeb guzoob da diidxan, yadxaag grop cwaa reeb gac reeb tijbzi, abiꞌ tijbzi bejn gap laa reeb. ");
INSERT INTO zasNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Da Dadan Dios rënman naj guial naj gajc rudë naj guiëtan par yabanan stijb. ");
INSERT INTO zasNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Achut zajc gugüjt naj bal id naj gatiëëb. Naj raꞌp guialrniabee par gatiëëban guiëtan në par yabanan stijb, din laan na̱j guialrniabee ni banee da Dadan lon. ");
INSERT INTO zasNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Chi biguiejn ree bén Israel guin ni rëbaman, gojc reeman tioꞌp lalaꞌ stijb. ");
INSERT INTO zasNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Zien reeman rëb: ―¿Chexc zeel ridxgaꞌdi laaman? Awa xindxab yuꞌ luxdooman rajc tëë guijcaman. ");
INSERT INTO zasNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Per yuꞌ reeman rëb: ―Niꞌqui tijb bén yuꞌ xindxab luxdoo ad rnieet zian. ¿Wen zajc yaxhal xindxab guiaaloj ree bén ad ranit loj ya? ");
INSERT INTO zasNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tiamp nayaag, chi cayüjn ree bén Israel lanij ni rüjn reeman gazobijz par yadooroꞌ Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Wej Jesús lën yadoo guin. Chi cazaman niz roꞌ curdur ni rniee reeman xcurdur Salomón. ");
INSERT INTO zasNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Dxel biyaw ree bén Israel laaman, rëb reeman lojman: ―¿Xt goc nagaꞌloj cuꞌnawëëguil dunujn? Guna du lojn bal lüj na̱j Cristo. ");
INSERT INTO zasNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Badxiꞌ Jesúsan rëbaman: ―Ma rnin lojdi, per lëjt ad rliladxtidi naj. Abiꞌ ree ni rünan con xguialrniabee da Dadan Dios, laa reen rulüü chu najn. ");
INSERT INTO zasNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Per ad rliladxtidi, guial ad najtidi da bejnan. ");
INSERT INTO zasNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Bén na̱j ree da bejnan, nünbee reeman chaꞌn, guiáad naj nünbeen laa reeman, abiꞌ laa reeman rzanal naj. ");
INSERT INTO zasNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Naj rudë guialnaban tiblayaa loj reeman, ad yuꞌt dxej nit reeman. Abiꞌ achut zajc chiquied laa reeman lon. ");
INSERT INTO zasNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Din da Dadan, bén banee laa reeman lon, rajpaman mazri guialrniabee guial loj gra. Achut zajc chiquied laa reeman lojman. ");
INSERT INTO zasNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Da Dadan con naj, nayajcan tijbzi. ");
INSERT INTO zasNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Dxel cwaꞌ ree bén Israel guin guiaj din gucaaguiaj reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Per rëbaman loj reeman: ―Por xguialrniabee da Dadan, zien ni zagdxe ma benan niz lojdi. ¿Con pornin gucaaguiajdi naj? ");
INSERT INTO zasNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Badxiꞌ reeman laan rëb reeman: ―Ad por ree ni zagdxe ni beentilan yacaaguiajn lüj, yacaaguiajn lüj guial ad rajptil Dios respejt, din bénguidxliujzi lüj, abiꞌ rüjn lüj gajc ziꞌc Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Dxel rëb Jesús: ―Loj xleydi rëb: “Naj rni guial lëjt na̱j dios.” ");
INSERT INTO zasNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Dunuj ree rayagbee guial ad ni rusquieet na̱j ni ca loj xtiidx Dios. Abiꞌ laaman gulëëlaj dios bén basaꞌnnë ree xtiidxaman, bén gojp ree guialrniabee loj ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Yan, bal da Dadan Dios gulëëca naj persi guxhaalaman naj loj guidxliuj, ¿chexquiza zeel nadi ad raꞌptan laaman respejt guial rnin, xiꞌnman naj? ");
INSERT INTO zasNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Bal id cayünan ziꞌc na da Dadan, ad chililadxidi naj. ");
INSERT INTO zasNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Per bal cayünan ziꞌc naman, majsi ad zaliladxtidi naj, per gol bililadx guial por laaman zëëd ni rünan din gagbeedi guial da Dadan zaꞌnë naj, guiáad naj zaꞌnëꞌn laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Dxel guyën reeman niniaaz reeman Jesús, per gulaaman loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Abiꞌ zëman zatiblad roꞌ guiiw Jordán, lod baroobnijs Waj bejn ree yaloj, yagaj bayaꞌnman. ");
INSERT INTO zasNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Abiꞌ zien ree bén bidxin yagaj rëb: ―Walin, majsi achet milagr been Waj, per gra ni guneeman xcwent bén guie na̱j diidxli. ");
INSERT INTO zasNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Dád zien reeman bililadx Jesús yagaj. ");
INSERT INTO zasNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Guyu tijb bénragxuu, brii lajman Lazr. Laaman con re bizanman Li con Mart, na̱j ladx reeman Betania. ");
INSERT INTO zasNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Abiꞌ Li bizan Lazr, laam baroob perfum guiaꞌ Jesús abiꞌ bacwiidximin con guidxguijquim. ");
INSERT INTO zasNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Dxel grop bël reem guxhaal ruson loj Jesús, rëb reem: ―Dad, ragxuu xmiwil Lazr. ");
INSERT INTO zasNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Chi biguiejn Jesús zian, rëbaman: ―Guialguijdx guin ad zëëdtan par gugüjtan, zëëdan din gac guguiaa bejn xguialrniabee Dios në par guguiaa reeman xguialrniabee Xiꞌn Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Majsi rën daꞌt Jesús Mart con Li në Lazr, ");
INSERT INTO zasNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","per chi cwaꞌman ruson ragxuu Lazr, sta goglaaman zatioꞌp dxej lod zaꞌman. ");
INSERT INTO zasNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Dxel rëbaman loj ree xbejnman: ―Yoꞌ ree niz Judea zatijb. ");
INSERT INTO zasNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Abiꞌ rëb reeman lojman: ―Mextr, ad wayajct xchej guyën ree bén zojb niz ni nucaaguiaj reeman lüj. ¿Abiꞌ chel ni zatijb ya? ");
INSERT INTO zasNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Dxel rëb Jesús: ―Lëjt ragbee guial chiptioꞌp hor yuꞌ tibdxej. Abiꞌ bén rza radxe, achet rirejl guiaꞌman, din yuꞌ bajl rusni loj guidxliuj guie. ");
INSERT INTO zasNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Per bén rza guxhin, yuꞌ ni rirejl guiaꞌman, din achet bajl guin rajpaman. ");
INSERT INTO zasNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Rëb tëë Jesús loj reeman: ―Ma nagaꞌyëjs dux miw ree Lazr, per chicwëënan laax. ");
INSERT INTO zasNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Dxel rëb ree xbejnman: ―Dad, bal naayëjsix, rën guiëban yayajquix. ");
INSERT INTO zasNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Per ni rëb Jesús rën guiëban guial ma güjt Lazr, guiáad ree xbejnman gunaladx reeman rëbaman nagaꞌyëjsizix. ");
INSERT INTO zasNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Dxel bagojn Jesús laa reeman, rëbaman: ―Ma güjt Lazr. ");
INSERT INTO zasNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Rabaan por lëjt guial ad guzutan ni din chililadxidi naj. Yan, yoꞌ ree yugnaj reex. ");
INSERT INTO zasNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Dxel Tumajs, bén rniee reeman cwajch, rëbaman loj los demazri xbejn Jesús: ―Yoꞌ ree yunëꞌ reeman, din lod guiëtaman, yayëjtnëꞌ reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Chi bidxin Jesús Betania, ma gojc tajp dxej biguieꞌch Lazr. ");
INSERT INTO zasNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania guin rayaꞌnan gajxh Jerusalén, ziꞌct choon kilometro. ");
INSERT INTO zasNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Abiꞌ zien ree bén Israel bignaj Mart con Li din yaguꞌ reeman luxdoo reem guial güjt bizan reem. ");
INSERT INTO zasNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Chi gogbee Mart ma zëëd Jesús gajxh, briim bigchaaglojm laaman, guiáad Li bayaꞌnm lënü. ");
INSERT INTO zasNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Dxel rëb Mart loj Jesús: ―Dad, bal nizujl guie, ad ziant niëjt da zanan. ");
INSERT INTO zasNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Per naj ragbee guial niꞌqui yan zunee Dios ni guiniabil lojman. ");
INSERT INTO zasNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Dxel rëb Jesús: ―Naj rni yaban bizanl. ");
INSERT INTO zasNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Badxiꞌmin rëbim: ―Ma qui ragbeen, yabanm dxej yaban gra ree bengüt. Chi guidxin dxej güün xguialguxtis Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Abiꞌ rëb Jesús: ―Naj na̱j bén rusban ree bengüt rudë tëën guialnaban loj ree bejn. Bén chililadx naj, majsi guiëtaman, per zajpaman guialnaban loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Guiáad gra bén naban rliladx tëë naj, zajpaman guialnaban loj Dios. ¿Rliladxil ni canin lüj ya? ");
INSERT INTO zasNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Dxel rëbim lojman: ―Rliladxanan Dad. Rliladxan lüj na̱j Cristo, Xiꞌn Dios, bén na̱j guiꞌt loj guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Chi gulox rëb Mart zian, dxel bignee xbëlim Li, rëbim ralan: ―Ma biꞌt Jesús, abiꞌ caneeman lüj. ");
INSERT INTO zasNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Biguiejnzi Li zian, laa bisugajquim bigchaaglojm Jesús. ");
INSERT INTO zasNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Abiꞌ Jesús gadzaman chuꞌ luguiedx guin, sta zaꞌman lod bigchaagloj Mart laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Guiáad ree bén Israel zojbnë Li raguꞌ reeman luxdoom, chi baguiaa reeman cari daꞌt bisum zëm, binal reeman laam. Gunaladx reeman roꞌ xbaa Lazr ziguiaanm. ");
INSERT INTO zasNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Chi bidxinm lod zaꞌ Jesús, bazuxibim lojman rëbim: ―Dad, bal nizujl guie, ad ziant niëjt da zanan. ");
INSERT INTO zasNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Chi baguiaaman roon Li con ree bén Israel nal laam, dád gognaa luxdooman guyu naya tëëman. ");
INSERT INTO zasNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Dxel gunabdiidxaman rëbaman: ―¿Ban biquieꞌchidi laax? Abiꞌ rëb reeman: ―Dad, guda nial din guguiaal. ");
INSERT INTO zasNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Dxel biinman. ");
INSERT INTO zasNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Abiꞌ rëb ree bén Israel guin: ―Gol baguiaa nial dád guyënman laax. ");
INSERT INTO zasNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Per yuꞌ reeman rëb: ―Bén guinan baxhal guiaaloj tijb bén ad ranit loj. Yan, ¿niche niajc nüjnman yaꞌn chitëë niëjt Lazr? ");
INSERT INTO zasNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Dád guyu naya luxdoo Jesús stijb, chi gubigaman roꞌ xbaa Lazr. Najn tijb guiajbiliaa, nadaꞌcw tijb guiaj roꞌn. ");
INSERT INTO zasNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Dxel rëbaman: ―Gol biquied guiaj guin. Per Mart, bizan xingüt guin, rëbim: ―Dad, ma rliaam nadxuudx, din ma gojc tajp dxej ni gütim. ");
INSERT INTO zasNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Badxiꞌ Jesúsan rëbaman: ―¿Nid rnin ya, bal rliladxil, guguiaal xguialrniabee Dios? ");
INSERT INTO zasNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Dxel bisüd reeman guiaj guin. Zianz gules loj Jesús xanyabaa rëbaman: ―Dad, quixtëë lüj guial ma bacaagdiajguil ni rnin. ");
INSERT INTO zasNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Naj ragbeechaaw guial zianczi rucaagdiajguil ni rnin. Per rnin zian por ree bén rigaꞌ guie, din chililadx reeman guial lüj guxhaal naj. ");
INSERT INTO zasNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Chi gulox rëbaman zian, dxel guridxaꞌman rëbaman: ―¡Lazr, barii yagaj! ");
INSERT INTO zasNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Dxel barii Lazr lën baa guin nalüüb vend yaax con guiaꞌx, guiáad lojx nayaaw lajd. Dxel rëb Jesús loj reeman: ―Gol baxhiequix, gol baslaax yaguiajx. ");
INSERT INTO zasNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Dád zien ree bén binal Li bililadx Jesús, guial baguiaa reeman milagr beenman. ");
INSERT INTO zasNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Per yuꞌ reeman bicojn bénfarisew ree ni been Jesús. ");
INSERT INTO zasNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Dxel bénfarisew ree në ree bixhioz rniabee, bachajg lasaꞌ reeman con los demazri ree guxtis, rëb reeman: ―¿Xhienaag yaguieen ree yaꞌn, din dád zien milagr cayüjn xin guin? ");
INSERT INTO zasNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Bal yadëëd ree mod, graczi bejn guililadx laax, dxel guxtis Rom ree guidganijt reeman dux yadoo ree në dux nacion ree. ");
INSERT INTO zasNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Per loj reeman yuꞌ bén la Caifás, bixhioz zojbloj rniabee loj ijzsii, rëbaman loj reeman: ―¿Nid ragbeedi ya, ");
INSERT INTO zasNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","nid rigniaꞌ tëëdi ya, zagdxe na̱j guiët tijbzi bejn por gra bén Israel, luar nit dux nacion ree? ");
INSERT INTO zasNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Per Caifás guin ad ni naladxtzaman rëbaman. Guial najman bixhioz zojbloj rniabee loj ijzsii, zeel badëëd Dios ni guneeman, guial guiët Jesús por gra ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Abiꞌ ad por laatzi reeman, par gac reeman tijbzi con gra ree xbejn Dios, bén rigaꞌ ree guidib guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Zeel diizd dxejzii bayaꞌn reeman diidx gugüjt reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Zianan zeel ad contzi rulüülojtraman loj ree bén Israel, bazaman yagaj ziaman guiedx la Efraín, najn gajxh yujbidx, yagaj guzunë ree xbejnman. ");
INSERT INTO zasNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Dxejzii ree ma zidyob pascw, lanij rüjn ree bén Israel, dád zien ree bén guiedx ree zë Jerusalén din güün reeman ziꞌc na̱j xcostumbr reeman par gac reeman naya loj Dios chi gad pascw gal. ");
INSERT INTO zasNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Dxel raguiil reeman Jesús, abiꞌ rniabdiidx loj lasaꞌ reeman lën yadooroꞌ Jerusalén, rëb reeman: ―¿Xhie nadi? ¿Ziꞌtaman lanij ya o ad ziꞌttaman? ");
INSERT INTO zasNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Bénfarisew ree con ree bixhioz rniabee, gunabee reeman bal chutëëz bén ragbee ban zaꞌ Jesús, gugojnman din chileꞌ guiniaaz reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Za xhoꞌp dxej riaadx gal pascw, chi we Jesús Betania, lod zojb Lazr, xin basbanman. ");
INSERT INTO zasNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ni been reeman tijb guialraw par xche ni gudawnë reeman Jesús. Mart guleꞌc guialraw guin, guiáad Lazr na̱j tijb bén gurenë laa reeman xan mex. ");
INSERT INTO zasNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Dxel cwaꞌ Li cost garol lijtr perfum ni lasajc wayëjx, najcchaawnën ganax nardo, baroobimin guiaꞌ Jesús abiꞌ bacwiidxnë guidxguijquimin. Guidibczi lënü guin baree nejxh. ");
INSERT INTO zasNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Dxel Judas Iscariote, xin na̱j tijb ree xbejn Jesús, xin bayü laaman, rëbix: ");
INSERT INTO zasNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Chexc ad gudoꞌt perfum guin? Zagdxeli nidoꞌn ziꞌct rüjn tijb bejn gan tib ijz, din nüjnan yudar bénprob ree. ");
INSERT INTO zasNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ad guial yuꞌtix xgab bénprob guin ree zeel rëbix zian, rëbix zian guial najx xin gubaan. Abiꞌ guial laax naaz bols yuꞌ milia, rbanx ni rudëë reeman rguꞌchaawix. ");
INSERT INTO zasNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Dxel rëb Jesús lojx: ―Guzujr biinan. Ma badxeꞌxgajm naj perfum guin par chi guidxin dxej guiguieꞌchan. ");
INSERT INTO zasNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Din bénprob guin ree zianczi zaꞌnë reeman lëjt, per naj ad ziantczi gazunëꞌn lëjt. ");
INSERT INTO zasNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Bén guixiuj bén Israel gogbee zaꞌ Jesús Betania, abiꞌ wej reeman yagaj, ad par guguiaatzi reeman Jesús, në par guguiaa reeman Lazr, xin basbanman. ");
INSERT INTO zasNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Zeel bayaꞌn ree bixhioz rniabee diidx guial në Lazr gugüjt reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Din por laax dád zien ree bejn cayrii loj reeman, abiꞌ caliladx reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Chi bareguiaal, zien daꞌt ree bén zë lanij pascw Jerusalén gogbee guidxin Jesús yagaj, ");
INSERT INTO zasNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","dxel cwaꞌ reeman zijn, brii reeman bigchaagloj reeman laaman, rbidxaꞌ reeman rëb reeman: ―¡Benzaꞌc bendxoon na̱j Dios! ¡Nüjnleꞌman Bén guxhaalaman! ¡Nüjnleꞌman bén na̱j rey Israel! ");
INSERT INTO zasNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Bidxaagloj Jesús tijb burdoo, abiꞌ gudxibaman laab, persi gojc ziꞌc ca loj xtiidx Dios lod rëb: ");
INSERT INTO zasNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Bén Sión, ad rdxebidi. Gol baguiaa, laa xreydi zëëd, dxiibaman tijb burdoo. ");
INSERT INTO zasNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yaloj ad bigniaꞌt ree xbejn Jesús ni cayajc. Per chi ma bayëꞌpaman xanyabaa, dxel bigniaꞌ reeman guial zian ca loj xtiidx Dios xcwentaman, zeel gojc zian. ");
INSERT INTO zasNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bén guzu ree con Jesús chi guredxaman Lazr din yariix lën baa, basban tëëman laax loj ree bengüt, rusnuu rü reeman diidx loj ree bejn ni baguiaa reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Zeel zien ree bejn brii bigchaagloj laaman, guial gogbee reeman milagr beenman. ");
INSERT INTO zasNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Dxel rëb loj lasaꞌ ree bénfarisew: ―Gol baguiaa nial graczi bejn zinal laax, achetri zajc yaguieen ree. ");
INSERT INTO zasNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Loj gra ree bén we lanij bignajchiꞌ reeman Dios Jerusalén, noꞌch bëlzi ree bén grieg, ");
INSERT INTO zasNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","gubig reeman loj Felip, bén za guiedx Betsaida, ni rigaꞌ niz Galilea, guzajc reeman liaadx rëb reeman: ―Dad, rayënan yaneenëꞌn Jesús. ");
INSERT INTO zasNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Abiꞌ wej Felip biguiedxaman loj Andrejs, dxel wej grop reeman bicojn reeman Jesús. ");
INSERT INTO zasNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Badxiꞌ Jesúsan rëbaman: ―Ma bidxin hor par Bén guxhaal Dios, guiëtaman abiꞌ yabanman. ");
INSERT INTO zasNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Diidxliczi rnin, ziꞌc tijb xob bal idan chuꞌ luyuj najz najn tijbzi, per bal chuꞌn luyuj zajcxhiejn. ");
INSERT INTO zasNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Bén ru mazri xgab naabzi por guialnaban yuꞌ loj guidxliuj guie, yuꞌ dxej gunijtaman laan, per bén ru mazri xgab güünman ziꞌc rën Dios, xhietëëz sacaman, zajpaman guialnaban tiblayaa con laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Bal chu rën güün ni rënan guidnalaman naj, lod gazun, nëgajcaman su. Bén güün ni rënan, guiën da Dadan laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Rëb tëë Jesús: ―Dád yuꞌn xgab. ¿Xhie guiën? ¿Zën ya: “Dad, babëë naj loj ni gazaagdiajn”? Per ad zëtan zian, din par zian zialan. ");
INSERT INTO zasNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Dad, balüü xguialrniabeel. Dxel biguien chaꞌ bejn xanyabaa rëbaman: ―¡Ma balü da guialrniabeen, per gulünan stijb! ");
INSERT INTO zasNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Riguiejn ree bén rigaꞌ yagaj, zeel rëb reeman: ―Guziaawan guridxaꞌ. Per yuꞌ reeman rëb: ―Tijb anjlan gunee laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Dxel rëb Jesús: ―Ad por najtan biguien chaꞌ bejn, por lëjtan. ");
INSERT INTO zasNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ma bidxin dxej gac guialguxtis loj guidxliuj, yan yarii bén rniabee lojn. ");
INSERT INTO zasNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Per chi guilies reeman naj ya loj guidxliuj guie, dxel guiꞌt graloj bejn lon. ");
INSERT INTO zasNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Zian basigniaꞌman xhienaag guiëtaman. ");
INSERT INTO zasNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Badxiꞌ ree bén guinan rëb reeman: ―Dunujn rayagbee rëb loj ley, Cristo guiban tiblayaa. ¿Chexc zeel nal, rayal guilies reeman Bén zëëd xanyabaa? ¿Chunin na̱j Bén zëëd xanyabaa? ");
INSERT INTO zasNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Rëb Jesús loj reeman: ―Ad zien dxejtri sunë bajl guie lëjt. Gol guza laꞌtgaj zaꞌnëdi bajl guie, chitëë guiniaaz guiaal lëjt. Din bén rza loj xcay, ad ragbeetaman ban cheman. ");
INSERT INTO zasNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Gol bililadx bajl guie, laꞌtgaj zaꞌnëdan, din gaquidi xbejnan. Chi gulox gunee Jesús zian, dxel baquieꞌchlojman loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Majsi been Jesús zien daꞌt milagr baguiaa reeman, ad bililadxt reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Zian gojc cumplid ni bacaa Isaías bén badëë xtiidx Dios loj ree bejn, rëban: Dad, ¿chu ma bililadx ruson radëëdan? ¿Chu loj ma balüü Dios xguialrniabeeman? ");
INSERT INTO zasNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Zianan zeel ad gojct nililadx reeman, din në ze bacaa Isaías: ");
INSERT INTO zasNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dios basiaaw guiaaloj reeman, bascajy tëëman xquiarguiejn reeman, chitëë guguiaa reeman chigniaꞌ tëë reeman, chitëë yadxiꞌ loj reeman lon, abiꞌ ad zayüntan laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Rëb Isaías zian guial baguiaaman xbiani Jesús, zeel bazaꞌtaman laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Per niꞌczi zian, dád zien ree bén zojbloj bililadx Jesús. Per ad rëbt reeman loj ree bejn zian, guial rdxeb reeman yabëë ree bénfarisew laa reeman lod ricaagdiajg reeman xtiidx Dios, ");
INSERT INTO zasNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","din mazri rën reeman guiën ree bejn laa reeman, guial guiën Dios laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Gunee Jesús rejs rëbaman: ―Bén rliladx naj, ad najtzan rliladxaman, në da Dadan bén guxhaal naj. ");
INSERT INTO zasNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Bén ruguiaa naj, në bén guxhaal naj ruguiaaman. ");
INSERT INTO zasNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Naj na̱j bajl, bialan loj guidxliuj guie, chitëë yayaꞌn ree bén rliladx naj loj xcay. ");
INSERT INTO zasNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Bal chu guien da diidxan abiꞌ ad zuzoobtaman laan, ad najt gudëd laaman casti, din ad bialtan din gudëdan casti, bialan din yabën laa reeman loj dol. ");
INSERT INTO zasNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Bén ad rënt naj ad rucaagdiajg tëëtaman da diidxan, mal yuꞌ ni gudëëd laaman casti: diidx ni rën, laan gudëëd laaman casti chi guidxin dxej. ");
INSERT INTO zasNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Din ad ni rbëguictan rnien. Da Dadan, Bén guxhaal naj rniabee ni ganen ni gulü tëën, ");
INSERT INTO zasNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","zeel ragbeen, ni rniabee da Dadan runee guialnaban tiblayaa. Zianan zeel ni rnin rulünan ziꞌc rniabeeman. ");
INSERT INTO zasNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Guixiezi gal lanij pascw. Ma ragbee Jesús guial ma bidxin hor gusaꞌnman guidxliuj guie din yaguiaj loj xDadaman. Zianczi guyën ree xbejnman, bén rigaꞌ ree loj guidxliuj, rënman laa reeman goctëëz. ");
INSERT INTO zasNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Chi gad reeman gaw xche, mal badxeꞌ xindxab ni mal luxdoo Judas, xiꞌn Simón Iscariote, ma rüjnx xgab yayüx Jesús loj ree bén gugüjt laaman. Ragbee Jesús guial badëëd xDadaman gra guialrniabee lojman, laa tëëman guxhaal laaman, zeel yaguiajman lod zaꞌman. Laꞌtgaj cayaw reeman, bisuman xan mex, gulëëman tijb lajd najcwaman luya, dxel cwaꞌman tijb tuay guxhii xizaman. ");
INSERT INTO zasNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Abiꞌ badxeꞌman nijs loj tijb xijg, guzulojman caguiibaman guiaꞌ ree xbejnman, cucwiidx tëëman laan con tuay naxii xizaman. ");
INSERT INTO zasNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Chi bayal quiibaman guiaꞌ Simón, bén rniee reeman Bëd, rëbaman loj Jesús: ―Dad, ¿lüj quiib guiaꞌn ya? ");
INSERT INTO zasNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Badxiꞌman laan rëbaman: ―Ad rigniaꞌtil ni cayünan yan, per qui chigniaꞌrilan. ");
INSERT INTO zasNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Zeel rëb Bëd lojman: ―Ad zatiëëbtan quiibil guiaꞌn. Abiꞌ rëb Jesús: ―Bal id zaguiiban guiaꞌl, ad zileꞌtri gaquil da bejnan. ");
INSERT INTO zasNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Zeel rëb Bëd lojman: ―Dad, ad bal guiaꞌzan quiibil, gudiib në yan con guican. ");
INSERT INTO zasNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Badxiꞌman laan rëbaman: Bén goznejz guiaꞌzaman riaadx chëd, din guidibaman naya. Abiꞌ lëjt ma nayadi, majsi ad gratidi. ");
INSERT INTO zasNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ma ragbeeman chu yayü laaman, zeel rëbaman: “Ad gratidi naya.” ");
INSERT INTO zasNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Chi gulox gudiibaman guiaꞌ reeman, bayajcw xabaman, gurejman xan mex guin zatijb, dxel rëbaman: ―¿Bigniaꞌdi ni benan ya? ");
INSERT INTO zasNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Rnieedi naj Mextr në Dad, waliquidi najn. ");
INSERT INTO zasNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Bal najn Mextr në Dad, gudiiban guiaꞌdi, ziangajc quiib guiaꞌ lasaꞌdi. ");
INSERT INTO zasNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ma balün lëjt, din güündi ziꞌc benan. ");
INSERT INTO zasNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Diidxliczi ganin, achut mojs na̱j mazri guial loj bén rniabee laaman, achut bén riꞌt na̱j mazri guial loj bén rxhiaal laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Bal rigniaꞌdi nine güün tëëdan, yabaanë Dios lëjt. ");
INSERT INTO zasNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Ad gratidi ruzatan ragbeen chu reenin gulen. Per rayal gac cumplid ni ca loj xtiidx Dios, rëban: “Bén rawnëꞌn tijbzi, bayejcaman contr naj.” ");
INSERT INTO zasNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ma rugojnan lëjt din gagbeedi chi gac zian, din chililadxidi chu najn. ");
INSERT INTO zasNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Diidxliczi ganin, bén rucaagdiajg ni rëb bén rxhialan, najn rucaagdiajgaman, guiáad bén rucaagdiajg da diidxan, xtiidx bén guxhaal najn rucaagdiajgaman. ");
INSERT INTO zasNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Chi gulox gunee Jesús zian, dád guyunayaman, dxel rëbaman loj reeman zagdxe: ―Diidxliczi ganin, tijb lëjt yayü naj loj ree bén gugüjt naj. ");
INSERT INTO zasNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Dxel guzuloj ree xbejnman ruguiaa loj lasaꞌ reeman, niꞌquid ragbeet reeman chunin ruzaꞌtaman. ");
INSERT INTO zasNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tijb bén guyën daꞌtaman zojb cwëꞌman, hor zii chi cayaw reeman xche, ");
INSERT INTO zasNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","dxel been Bëd sen lojman din guiniabdiidxaman chunin ruzaꞌt Jesús. ");
INSERT INTO zasNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Zeel mazri gubigaman cwëꞌ Jesús gunabdiidxaman, rëbaman: ―Dad, ¿chunin? ");
INSERT INTO zasNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Badxiꞌ Jesúsan rëbaman: ―Gugajdxan taꞌn guiadxtil, din loj xin gudëdanan, laaxan yayü naj. Dxel bagajdxaman taꞌn guiadxtil badëëman laan loj Judas, xiꞌn Simón Iscariote. ");
INSERT INTO zasNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Chi gudawixan, laa guyu gajc xindxab luxdoox. Zeel rëb Jesús lojx: ―Ni güünl, cari beenan. ");
INSERT INTO zasNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Per achutczi ree bén zojb xan mex guin bigniaꞌ chexc zeel rëbaman zian. ");
INSERT INTO zasNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Guial caꞌ Judas bols ni yuꞌ milia, zeel naladx garol reeman rëb Jesús lojx din chisiix ni gaw reeman lanij guin o gudëëdix taꞌnan loj ree bén rzagdiaj ya. ");
INSERT INTO zasNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Chi ma gudawix guiadxtil guin, dxel briix, ma guxhin. ");
INSERT INTO zasNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Chi ma brii Judas, rëb Jesús loj ree xbejnman: ―Yan guien xguialrniabee Bén guxhaal Dios din gagbee ree bejn xhienaag na̱j guialrniabee gudëë Dios lojman. ");
INSERT INTO zasNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Din bal gulüü Bén guxhaal Dios xguialrniabee Dios, ziangajc gulüü Dios xguialrniabeeman, zeel ma gudëëdaman laan. ");
INSERT INTO zasNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Xiꞌn, ad zien dxejtri gazunëꞌn lëjt, yaguiilidi naj, per ziꞌcgajc rën loj ree bejn, ziangajc ganin lojdi yan: Ad zajct chedi lod gan. ");
INSERT INTO zasNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ganin tijb nicüb ganabeen: Gol guyën lasaꞌdi ziꞌc rënan lëjt. ");
INSERT INTO zasNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Bal guiën lasaꞌdi, zian gagbee gra bejn guial najdi da bejnan. ");
INSERT INTO zasNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Gunabdiidx Bëd loj Jesús rëbaman: ―Dad, ¿ban chel? Zeel rëb Jesús: ―Ad zajct guidnalil naj lod gan yan, per zadxin dxej guidnalil naj. ");
INSERT INTO zasNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Zeel rëb Bëd: ―Dad, ¿chexc zeel ad zajct guidnaalan lüj yan? Xt zajc guiëtan por lüj. ");
INSERT INTO zasNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Badxiꞌ Jesúsan rëbaman: ―¿Walil ya rënl guiëtil por naj? Diidxliczi ganin, chi gad gui̱d cwidxaꞌ, mal rëbil choon volt, ad nünbeetil naj. ");
INSERT INTO zasNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Rëb tëë Jesús: ―Ad rudi xgab. Gol bililadx Dios, gol bililadx tëë naj. ");
INSERT INTO zasNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lidx da Dadan dád zien luar lod guiban bejn yuꞌ. Bal iche yuꞌ, ad ziant ganin lojdi, chiguienchaawan xluaridi. ");
INSERT INTO zasNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Chi ma benchaawan luar guin, dxel yaguialan guidgaxin lëjt din sudi lod gazun. ");
INSERT INTO zasNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ma nünbeedi nejz zë lod gan. ");
INSERT INTO zasNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Zeel rëb Tumajs lojman: ―Dad, ad rayagbeetan ban chel, ¿xhienaag yaguieenbeen nejz guin? ");
INSERT INTO zasNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Badxiꞌman laan rëbaman: ―Naj na̱j nejz, najn diidxli, naj tëën guialnaban. Tijbzi naj zajc chinëꞌ bejn ree loj da Dadan. ");
INSERT INTO zasNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Bal nünbeedi naj, në da Dadan güünbeedi. Per ma nünbeedi laaman diizd yan, din ma baguiaadi laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Dxel rëb Felip: ―Dad, banee mod majsi yaguiaazan bén na̱j xDadil. ");
INSERT INTO zasNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Badxiꞌman laan rëbaman: ―Felip, ma gojc xchej zaꞌnëꞌn lëjt. ¿Nid wayünbeel naj ya? Din bén ruguiaa naj, da Dadanan ruguiaaman. ¿Chexc zeel nal gunen mod guguiaal da Dadan? ");
INSERT INTO zasNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Nid rliladxil ya, naj zaꞌnëꞌ da Dadan, guiáad laaman zaꞌnë naj? Ni rnin lojdi, ad rbëguictanan. Da Dadan, bén nabannëꞌn, laaman rüjn dxiin guin. ");
INSERT INTO zasNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Gol bililadx naj zaꞌnëꞌ da Dadan, guiáad laaman zaꞌnë naj. Balgui majsi ni rünzan gol bililadx. ");
INSERT INTO zasNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Diidxliczi ganin: Bén rliladx naj, nëgajcaman güün ni rünan, güünman ni mazri naroob, din naj yayaꞌ lod zaꞌ da Dadan. ");
INSERT INTO zasNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Graczi ni guiniabidi lojman por naj, günanan din gulün xguialrniabeeman. ");
INSERT INTO zasNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Günan xhietëëz ni guiniabidi. ");
INSERT INTO zasNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Bal rëndi naj, gucaagdiajguidi ni balün. ");
INSERT INTO zasNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Din guië loj da Dadan guixhiaalaman Sprijt sunë lëjt, ");
INSERT INTO zasNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Sprijt gulüü diidxli, din zianczi sunëman lëjt. Bén ad rliladxt ree Dios ad zajct tiaꞌ reeman Sprijt guin, din ad ruguiaat reeman ad nünbee tëët reeman laaman. Per lëjt nünbee laaman, din sunëman lëjt yayaꞌn tëëman luxdoodi tiblayaa. ");
INSERT INTO zasNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ad zusaꞌntan xtijbidi, yaguialan stijb guidganan lëjt. ");
INSERT INTO zasNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Staꞌnz riaadx ad zuguiaatri ree bénguidxliuj naj, per lëjt guguiaadi naj, guibandi din nabanan. ");
INSERT INTO zasNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Dxej zii ree, gagbeedi zaꞌnëꞌ da Dadan, lëjt zaꞌnë naj, guiáad naj zaꞌnëꞌn lëjt zianczi. ");
INSERT INTO zasNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Bén rucaagdiajg ni rniabeen rüjn tëëman laan, walicaman rënman naj. Guiën da Dadan bén rën naj, në naj guiën laaman din güünbeeman naj. ");
INSERT INTO zasNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Gunabdiidx Judas (ad bén bayüt Jesús) rëbaman: ―Dad, ¿chexc zeel dunujzan yayagbee chu lüj, guiáad ree bénguidxliuj ad zagbeet reeman? ");
INSERT INTO zasNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Badxiꞌ Jesúsan rëbaman: ―Bén guiën naj guzoobaman da diidxan, guiën da Dadan laaman, guiáad naj guidnëꞌ da Dadan din yabajnnëꞌn laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Bén ad zënt naj ad zuzoobtaman da diidxan, din diidx cucaagdiajguidi yan ad da diidxtanan, xtiidx da Dadanan bén guxhaal naj. ");
INSERT INTO zasNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Canin lojdi gra nine, laꞌtgaj zaꞌnëꞌn lëjt. ");
INSERT INTO zasNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Per xSprijt Dios, bén sunë lëjt zianczi, bén guixhiaal da Dadan por naj, graczi gulüüman lëjt din gusaaladxidi ni canin. ");
INSERT INTO zasNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Chi yayaꞌn, yabecdxen luxdoodi, gunen guialnazaꞌc lojdi, ad ziꞌc runeet ree bénguidxliujn, ad bal ru nayadi ad rdxeb tëëdi. ");
INSERT INTO zasNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ma rnin lojdi, yayaꞌn, dxel yaguialan zatijb. Bal walidi rëndi naj, chuꞌ luxdoodi zagdxe, guial gagbeedi yayaꞌ loj da Dadan, din mazri zojblojman guial lon. ");
INSERT INTO zasNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ma rugojnan lëjt, din chi gac zian, chililadxidi. ");
INSERT INTO zasNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Ad zroꞌtri ganenëꞌn lëjt, din ma zëëd xin rniabee guidxliuj, majsi ad nët naj rniabeex. ");
INSERT INTO zasNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Per zian gac din gagbee ree bénguidxliuj, rënan da Dadan, zeel rünan ni rniabeeman. Gol bisu, yoꞌ ree yan. ");
INSERT INTO zasNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Basnuu rëb Jesús: ―Naj na̱j ziꞌc yag rtia ni nejxh zagdxe, guiáad da Dadan na̱j ziꞌc bén rxübin laan. ");
INSERT INTO zasNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Da bejn reen na̱j ziꞌc ree xidx yag guin. Bal id rtia reen gutüüg da Dadan laa reen. Per bal rtia reen, gusiaman laa reen din tia reen mazri. ");
INSERT INTO zasNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Lëjt ma nayadi, guial basia diidx rnin lëjt. ");
INSERT INTO zasNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Gol gubajnnë naj ziꞌc nabannëꞌn lëjt. Ad zajct tia xidx yag, bal id najnën yag guin tijbzi. Ziangajc lëjt ad zajct güündi ni rën Dios bal id zaꞌnëdi naj. ");
INSERT INTO zasNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Naj na̱j ziꞌc yag rtia ni nejxh, guiáad lëjt na̱j ziꞌc xidxan. Bén sunë naj zianczi nuchajgaman naj, guiáad naj nuchagan laaman, zeel rüjnman ni rën Dios. Din bal ichu naj, achet zajc güündi. ");
INSERT INTO zasNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Bén ad zazujnët naj guizëëbaman ziꞌc yagbidx rutoꞌp reeman, din cheꞌcan. Rëb tëë Jesús: ");
INSERT INTO zasNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","―Bal zaꞌnëdi naj tijbzi ruzoob tëëdi da diidxan, gol gunab ni rëntzidi, din tiaꞌdan. ");
INSERT INTO zasNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Bal güündi ni rën da Dadan, gaquidi quijb da bejnan, din guzaꞌt ree bejn laaman zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Rënan lëjt ziꞌc rën da Dadan naj, gol basaaladx rënan lëjt. ");
INSERT INTO zasNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Bal guzoobidi da diidxan, gusaaladxidi rënan lëjt, ziꞌcgajc ruzoban xtiidx da Dadan, ragbeen rënman naj. ");
INSERT INTO zasNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Rnin lojdi zian din chuꞌ luxdoodi zagdxe ziꞌc yuꞌ luxdon zagdxe, zagdxe daꞌt chuꞌ luxdoodi. ");
INSERT INTO zasNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Gol guyën lasaꞌdi ziꞌc rënan lëjt, laan rniabeen güündi. ");
INSERT INTO zasNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Achut rën xmiw mazri guial loj bén rëjt por laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Lëjt na̱j da miwan bal güündi ni rënan. ");
INSERT INTO zasNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ad zanetran lëjt mojs, din mojs ad ragbeetaman xhie rüjn bén rniabee laaman. Ganen lëjt miw, din balün lëjt graczi ni na da Dadan lon. ");
INSERT INTO zasNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ad lëjtt gule naj, naj gule lëjt. Zeel rnin lojdi, chedi chiglüüdi bejn ree ni rën da Dadan, din gusnuu güün reeman ni rënman, din guneeman graczi ni guiniabidi por naj. ");
INSERT INTO zasNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Rniabeen: Guiën lasaꞌdi. ");
INSERT INTO zasNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Rëb tëë Jesús: ―Bal ralen ree bénguidxliuj lëjt, gol basaaladx, yaloj naj balen reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Bal niajquidi bénguidxliuj, niën reeman lëjt ziꞌc rën lasaꞌ reeman. Per naj gule lëjt loj reeman, zeel ralen reeman guial ad najtidi bénguidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Gol basaaladx ni rnin: “Achut mojs na̱j mazri guial loj bén rniabee laaman.” Bal basagzi reeman naj, ziangajc gusagzi reeman lëjt, bal bazoob reeman da diidxan, ziangajc guzoob reeman xtiidxidi. ");
INSERT INTO zasNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Graczi nine güünnë reeman lëjt por naj, din ad nünbeet reeman bén guxhaal naj. ");
INSERT INTO zasNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Achet xtol reeman niu, bal idan nial ninienëꞌn laa reeman, per yan yuꞌ xtol reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Bén ralen naj, nëgajc da Dadan ralenman. ");
INSERT INTO zasNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Achet xtol reeman niu, bal idan nün ree ni benan loj reeman ni achutczi wayüjn, per ma baguiaa reeman laa reen, majsi zian ralen gajc reeman naj në da Dadan. ");
INSERT INTO zasNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Per rajc zian din gac cumplid ni ca loj xley reeman, rëban: “Achet rünan ralen reeman naj.” ");
INSERT INTO zasNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Per chi guiꞌt Sprijt gaxhalan din sunëman lëjt gulüü tëëman diidxli, Sprijt zëëd loj da Dadan, laaman gü da diidxan. ");
INSERT INTO zasNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nëgajc lëjt gü laan, din diizd yaloj zaꞌnëdi naj. ");
INSERT INTO zasNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Rnin zian, din ad zabëjzt chililadxidi naj. ");
INSERT INTO zasNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Yabëë reeman lëjt lod ricaagdiajg reeman xtiidx Dios, zadxin dxej, chutëëz bén gugüjt lëjt naladx reeman Dios cayüjn reeman wen. ");
INSERT INTO zasNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Güün reeman zian din ad nünbeet reeman naj niꞌqui da Dadan. ");
INSERT INTO zasNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Per ma rnin lëjt, din chi guidxin dxej guin gusaaladxidi guial ma bagojnan lëjt. ’Ad rnitan lojdi zian diizd yaloj, din naj guzunëꞌ lëjt. ");
INSERT INTO zasNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Per yan yayaꞌn loj bén guxhaal naj. Achutczidi rniabdiidx ban gan, ");
INSERT INTO zasNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","aal yuꞌnayadi guial canin zian. ");
INSERT INTO zasNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Per diidxliczi rnin: zagdxe najn yayaꞌn. Din bal idan yayaꞌ, ad ziꞌtt xSprijt Dios sunë lëjt, per bal yayaꞌn, naj gaxhal laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Chi guiꞌtaman, laaman gulüü ree bénguidxliuj ni na̱j dol, ni na̱j ni zagdxe, në xguialguxtis Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Gagbee reeman yuꞌ xtol reeman, guial ad rliladxt reeman naj. ");
INSERT INTO zasNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ni zagdxe guin na̱j guial yayaꞌ loj da Dadan din ad zuguiaatridi naj. ");
INSERT INTO zasNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Guiáad Dios ma been xguialguxtisaman con xindxab rniabee guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Yuꞌri ni rënan ganin, per dád zien gacan par lëjt. ");
INSERT INTO zasNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Chi guiꞌt Sprijt gulüü lëjt diidxli, din ad züt xtiidx gajcaman, guinieeman graczi ni guienman, laaman gulüü lëjt ni gac. ");
INSERT INTO zasNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Guzaꞌtaman naj zagdxe, din naj gudëd ni gulüüman lëjt. ");
INSERT INTO zasNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Graczi ni rajp da Dadan na̱j par naj, zeel rnin, Sprijt guin tiaꞌ ni gudëdan din gulüüman laan lëjt. ");
INSERT INTO zasNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Ma guidxin dxej ad zuguiaatridi naj, per ad zajct xchej, guguiaadi naj stijb. ");
INSERT INTO zasNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Chi rëb Jesús zian, dxel guzuloj ree xbejnman canabdiidx loj lasaꞌ reeman, rëb reeman: ―¿Chexc zeel naman, ma guidxin dxej ad zaguiaatri reeman, per ad zajct xchej, yaguiaa reeman stijb, din yaguiaj loj xDadaman? ");
INSERT INTO zasNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Chexc zeel naman: “Ad zajct xchej”? Ad rayigniaꞌt ree ni caneeman. ");
INSERT INTO zasNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Gogbee Jesús guial rën reeman guiniabdiidx reeman, zeel rëbaman: ―Ma rnin lojdi, ma guidxin dxej ad zuguiaatridi naj, per ad zajct xchej, guguiaadi naj stijb. ¿Ni nen canabdiidxidi ya? ");
INSERT INTO zasNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Diidxli ganin, goondi chuꞌ tëë luxdoodi naya, guiáad ree bénguidxliuj yabaa reeman. Per majsi chuꞌ luxdoodi naya, guidxin dxej yabaadi. ");
INSERT INTO zasNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Chi gal xiꞌn béngunaa, rdëdaman tarbajw, din ma bidxin hor guin. Per chi ma gojl xiꞌnman, dxel rayanladxaman tarbajw guin, ru luxdooman zagdxe, guial ma gojl xiꞌnman. ");
INSERT INTO zasNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ziangajc lëjt cadëdidi tarbajw yan, per chi guguian lëjt zatijb, chuꞌ luxdoodi zagdxe, achutczi zajc yabëë laan luxdoodi. ");
INSERT INTO zasNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Dxel achetri guiniabdiidxidi lon. Diidxliczi ganin, graczi ni guiniabidi loj da Dadan por naj, guneeman. ");
INSERT INTO zasNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Guiáad yan achet wanabidi por naj, gol gunaban din tiaꞌdan, din chuꞌ luxdoodi zagdxe tiblayaa. ");
INSERT INTO zasNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Rëb tëë Jesús: ―Rnin nine ree ziꞌc cwent, per zadxin dxej ad zulütran zian, gusigniaꞌn lëjt zagdxe xcwent da Dadan. ");
INSERT INTO zasNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Dxej zii ree guiniabidi loj da Dadan por naj, ad rüjnt naguiejn ganaaban por lëjt lojman, ");
INSERT INTO zasNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","din rënman lëjt, rënman lëjt guial rëndi naj rliladx tëëdi guial laaman guxhaal naj. ");
INSERT INTO zasNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Briin lod zaꞌ da Dadan persi bialan loj guidxliuj guie, yan gusaꞌnan laan din yayaꞌn lojman. ");
INSERT INTO zasNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Dxel rëb ree xbejnman: ―Yanri ma cusigniaꞌl zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Rayagbeen rajquil graczi, ad rüjnt naguiejn chu guiniabdiidx lojl. Zianan zeel raliduladxan guxhaal Dios lüj. ");
INSERT INTO zasNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Badxiꞌ Jesús laan rëbaman: ―¿Ma rliladxidi yan ya? ");
INSERT INTO zasNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Gol gogbee, ma bidxin hor yareꞌchidi, tijb gajdi yaguiaj lidx, gusaꞌndi da xtijban. Per ad zaꞌt da xtijban, da Dadan zaꞌnë naj. ");
INSERT INTO zasNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Rnin gra nine din cwedi zagdxe guial nuchajguidi naj. Loj guidxliuj sagdiajdi, per ad guidxebidi, din ma benan gan loj guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Chi gulox rëb Jesús zian loj ree xbejnman, dxel baguiaaman xanyabaa rëbaman: ―Dad, ma bidxin hor, balüü da guialrniabeen din gulün xguialrniabeel. ");
INSERT INTO zasNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Baneel guialrniabee lon din ganabeen gra bejn gudëd tëën guialnaban tiblayaa loj gra bén baneel. ");
INSERT INTO zasNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Guiban reeman tiblayaa bal güünbee reeman lüj, tijbzi lüj na̱j quijb Dios, güünbee tëë reeman najn guxhaalil. ");
INSERT INTO zasNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Naj bazat lüj zagdxe loj guidxliuj; yan ma gulox benan ni nal. ");
INSERT INTO zasNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Yan, Dad, yaguialan lojl, din yaneel guialrniabee caꞌn gocli, diizd chi gad guidxliuj gacchaaw. ");
INSERT INTO zasNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Rëb tëë Jesús: ―Bén gulel loj guidxliuj baneel lon, ma balün laa reeman chu lüj. Gojc reeman xbejnl, per baneel laa reeman lon, ma bazoob reeman xtiidxil. ");
INSERT INTO zasNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Yan ma gogbee reeman guial gra ni benan gra tëë ni balün na̱j xieenl. ");
INSERT INTO zasNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Gunen xtiidxil ni baneel, zeel bacaagdiajg reeman laan, gogbee reeman, walican lojl guzaan, bililadx tëë reeman lüj guxhaal naj. ");
INSERT INTO zasNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Rbedx rniaaban lüj por laa reeman, guial na̱j reeman xbejnl banee tëël laa reeman lon, ad rbedx rniaabtan por ree bénguidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Gra ni caꞌn na̱j xieenl, guiáad gra ni caꞌl na̱j da xieenan, ma rguien da guialrniabeen por ree bén baneel. ");
INSERT INTO zasNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Ad zazutran loj guidxliuj, per laa reeman suri reeman guie, guiáad naj yazaan din yaguialan lod zaꞌl. Dad, lüj na̱j bén naya nali, gunaj reeman con gra guialrniabee caꞌl ni banee tëël lon, din gac reeman tijbzi ziꞌc nayajc. ");
INSERT INTO zasNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Chi guzunëꞌn laa reeman loj guidxliuj, gunan laa reeman con xguialrniabeel ni baneel. Achut reeman bizëëb, tijbzi xin ma na̱j diidx bizëëb, din gac cumplid ni ca loj xtiidxil. ");
INSERT INTO zasNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Yan yaguialan lod zaꞌl, per canen zian laꞌtgaj zaꞌn loj guidxliuj guie, din chuꞌ luxdoo reeman zagdxe, ziꞌc yuꞌ luxdon zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ma balün laa reeman xtiidxil, zeel ralen ree bénguidxliuj laa reeman guial ad najt reeman bénguidxliuj, ziꞌcgajc ad najtan bénguidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ad rniaabtan yabëël laa reeman loj guidxliuj, rënan guinial laa reeman, chitëë güün reeman ni mal. ");
INSERT INTO zasNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ad najt reeman bénguidxliuj, ziꞌcgajc naj. ");
INSERT INTO zasNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Basia reeman con xtiidxil, din laan na̱j ni diidxli. ");
INSERT INTO zasNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ziꞌc guxhaalil naj loj ree bénguidxliuj, ziangajc rixhial ree da bejnan loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Por laa reeman rudëd da guialnabanan din gac reeman xbejnl diidxliczi. ");
INSERT INTO zasNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Basnuu Jesús, rëbaman: ―Ad por laatzi reeman rbedx rniaaban lüj, në por ree bén chililadx chi gucaagdiajg reeman ni guiniee reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Rniaaban lojl din guchajg lasaꞌ reeman din yayajcnëꞌ reeman tijbzi, Dad, ziꞌc zaꞌnël naj ziangajc zaꞌnëꞌn lüj, ziangajc sunë lasaꞌ reeman. Din chililadx ree bejn lüj guxhaal naj. ");
INSERT INTO zasNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Badëdan guialrniabee baneel loj reeman, din gac reeman tijbzi ziꞌc nayajc, ");
INSERT INTO zasNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","naj zaꞌnëꞌ laa reeman, guiáad lüj zaꞌnël naj. Zeel gac reeman tijbzi din gagbee ree bejn, lüj guxhaal naj rën tëël laa reeman ziꞌc rënl naj. ");
INSERT INTO zasNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Dad, lüj banee laa reeman lon, zeel rënan su reeman lod gazun din guguiaa reeman biani baneel lon, din guyënl naj diizd chi gad guidxliuj gacchaaw. ");
INSERT INTO zasNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Dad, lüj rüjn guialguxtis zagdxe. Ad nünbeet ree bénguidxliuj lüj, saꞌn naj nünbeen lüj, në ree da bejnan ragbee lüj guxhaal naj. ");
INSERT INTO zasNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Balün laa reeman chu najl, gulüran laa reeman mazri, din gagbee reeman rënl laa reeman ziꞌc rënl naj, gazunëꞌ tëën laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Chi gulox gunee Jesús zian, dxel briinë ree xbejnman, zë reeman stiblad roꞌ guiiw la Cedrón, bidxin reeman lod yuꞌ ree yag. ");
INSERT INTO zasNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Në Judas, xin yayü laaman, nünbee yagaj, guial zien volt binëman laa reeman ni. ");
INSERT INTO zasNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Zeel bidxinnëx tibcwaa ree suldad në ree bén rajp roꞌ yadoo, guxhaal quijb ree bixhioz laa reeman në ree bénfarisew, caꞌ reeman bajl rusni ree, në ree espad con ree lans. ");
INSERT INTO zasNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Per ma ragbee Jesús gra ni gac, briiman gunabdiidxaman loj reeman, rëbaman: ―¿Chu raguiilidi? ");
INSERT INTO zasNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Badxiꞌ reeman laan rëb reeman: ―Jesús bén Nazaret. Abiꞌ rëbaman loj reeman: ―Najn. Judas xin bayü laaman bidxinnë laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Chi rëbaman loj reeman: “Najn”, dxel baguiadruxan reeman biajb reeman luyuj. ");
INSERT INTO zasNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Gunabdiidxaman zatijb rëbaman: ―¿Chu raguiilidi? Rëb reeman: ―Jesús bén Nazaret. ");
INSERT INTO zasNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Zeel rëbaman: ―Ma rnin, najn. Bal naj raguiilidi, gol baslaa ree bén guie yaguiaj reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Zian gojc cumplid ni rëb loj xDadaman: “Achut ree bén baneel lon bizëëb.” ");
INSERT INTO zasNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Dxel gulëë Bëd espad, gutüꞌman guidiajg ladbee xin la Malco, najx xmojs quijb bixhioz zojbloj. ");
INSERT INTO zasNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Dxel rëb Jesús loj Bëd: ―Baguꞌchaaw espad zii. Bal rën da Dadan gazaagdiajn zian, gazaꞌcanan. ");
INSERT INTO zasNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Suldad guin ree con xin rniabee laa reex con ree bén rajp roꞌ yadoo gunaaz reeman Jesús, guxhii reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Dxel binë reeman laaman yaloj lidx bén la Anás, din laaman na̱j xdadsuegr Caifás quijb bixhioz zojbloj loj ijz zii. ");
INSERT INTO zasNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Laagajcaman rëb loj gabilt, mazri zagdxe guiët tijbzi bejn por gra ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Tioꞌp ree xbejn Jesús binal laaman. Tijbaman la Simón, bén rniee reeman Bëd, stijbaman na̱j bén nünbee quijb bixhioz zojbloj, zeel guyunëman Jesús lënü guin, ");
INSERT INTO zasNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","guiáad Bëd bayaꞌnman luleꞌ. Zeel barii bén nünbee bén rniabee ree bixhioz, guneenëman biin rajp roꞌ port guin, persi guyu Bëd lënü. ");
INSERT INTO zasNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Gunabdiidxim lojman rëbim: ―¿Nid lüjn na̱j tijb xbejn bén guin ya? Badxiꞌman laan rëbaman: ―Ad najtan. ");
INSERT INTO zasNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Per guial dád nayaag, zeel bén na̱j ree mojs con ree bén rajp roꞌ yadoo nabeꞌc reeman guij ruchaꞌ reeman. Nëgajc Bëd cuchaꞌnë reeman rudëj guin. ");
INSERT INTO zasNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Guzuloj bén la Anás canabdiidxaman loj Jesús xcwent ree xbejnman në xcwent ni rulüüman. ");
INSERT INTO zasNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Zeel rëb Jesús: ―Gunen loj gra ree bejn. Zianczi balün lod rucaagdiajg ree xtiidx Dios në lën dux yadooroꞌ ree, lod radoꞌp dugra ree. Achet ni gunen ralan. ");
INSERT INTO zasNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Chexc zeel rniabdiidxil lon? Gunabdiidx loj ree bén bacaagdiajg ni rën, laa reeman na xhie gunen, laa reeman ragbee. ");
INSERT INTO zasNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Chi rëbaman zian, tijb bén rajp roꞌ yadoo guin wëëz roꞌman, rëbaman: ―¿Zian yadxiꞌl xtiidx bén rniabee guin ya? ");
INSERT INTO zasNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Badxiꞌ Jesús laan rëbaman: ―Bal xhie ni mal rën, guna xhienin. Per bal gunen zagdxe, ¿chexc zeel rguinl naj? ");
INSERT INTO zasNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Dxel guidib naxiiman guxhaal Anás laaman loj Caifás, bén na̱j quijb bixhioz zojbloj. ");
INSERT INTO zasNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Per Bëd sta zaꞌman cuchaꞌman rudëj guin. Abiꞌ gunabdiidx reeman lojman, rëb reeman: ―¿Nid në lüj na̱j tijb ree xbejn bén guin ya? Badxiꞌ Bëd laan rëbaman: ―Aꞌn, ad xbejntaman naj. ");
INSERT INTO zasNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Dxel tijb xmojs bixhioz zojbloj guin, bén na̱j lasaꞌ bén gutüꞌ Bëd guidiajg, rëbaman loj Bëd: ―¿Nid lüjn baguian ya zaꞌnël laaman guiaꞌ ree yag olivos? ");
INSERT INTO zasNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Rëb Bëd stijb guial ad nünbeetaman Jesús, loj hor zii gajc guridxaꞌ tijb gui̱d. ");
INSERT INTO zasNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Chi bani luyuj, bazanë reeman Jesús lidx Caifás, zinë reeman laaman lën xpalas gobernador Pilato. Per ree bén Israel guin ad guyut reeman lën palas guin, din par laa reeman bal niu reeman, ad nayatri reeman loj Dios, abiꞌ ad nileꞌt niajw reeman xche guialraw ni raw reeman pascw. ");
INSERT INTO zasNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Zeel brii Pilato persi guneenëman laa reeman, rëbaman: ―¿Xhie been xin guie zeel zidnëdi laax guie? ");
INSERT INTO zasNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Badxiꞌ reeman laan rëb reeman: ―Bal najman benzaꞌc, ad ziant nudnëꞌn laaman lojl. ");
INSERT INTO zasNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Dxel rëb Pilato: ―Gol bignëx, gol been guialguxtis ziꞌc na̱j xleydi. Abiꞌ rëb reeman: ―Per ad nacaꞌtan guialrniabee yanabeen guiët bejn. ");
INSERT INTO zasNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Zian gojc cumplid xtiidx Jesús chi bagojnman xhienaag guiëtaman. ");
INSERT INTO zasNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Bayu Pilato lën palas guin, dxel gurejdxaman Jesús, gunabdiidxaman lojman rëbaman: ―¿Lüj na̱j xrey ree bén Israel ya? ");
INSERT INTO zasNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Badxiꞌ Jesúsan rëbaman: ―¿Lüjczi rniabdiidx lon ya o yuꞌ ree ben ren na lojl zian? ");
INSERT INTO zasNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Badxiꞌ Pilato laan, rëbaman: ―¿Wen bén Israel naj ya? Bén ladx gajc reel con ree bixhioz rniabee bidnë lüj lon. ¿Xhie beenl? ");
INSERT INTO zasNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Badxiꞌ Jesúsan rëbaman: ―Guialrniabee ni raꞌpan ad lojt guidxliuj zan, din bal loj guidxliuj zan, niaꞌpan bén nidijl ree chitëë niniaaz ree ben Israel naj. Per yan ad lojt guidxliuj guie za da guialrniabeen. ");
INSERT INTO zasNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Dxel rëb Pilato lojman: ―¿Zë loj diidxan ya rey najl? Badxiꞌ Jesús laan rëbaman: ―Reyqui naj, ziꞌc nal. Par zian goolan par zian tëë zialan loj guidxliuj guie zidgaguien ni na̱j diidxli, graczi ree bén zinal ni diidxli rucaagdiajg reeman ni rnien. ");
INSERT INTO zasNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Dxel rëb Pilato: ―¿Xhiezanin na̱j diidxli? Chi gulox rëb Pilato zian, dxel briiman bigneenëman bén Israel ree stijb, rëbaman: ―Achet xguialquia xin guin radxejlan. ");
INSERT INTO zasNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Per lëjt, xcostumbridi na̱j guial loj lanij pascw laa tijb bén yuꞌ ladxguiib. Yan, ¿rëndi ya guslaan xreydi? ");
INSERT INTO zasNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Dxel gurixdiaj ree bén Israel guin, rëb reeman: ―¡Ad laataman guslaal! ¡Zagdxeli baslaa Barrabás! Abiꞌza Barrabás guin béngubaanan. ");
INSERT INTO zasNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Dxel gunabee Pilato gudijn ree suldad Jesús. ");
INSERT INTO zasNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Abiꞌ beenchaaw reeman coron guiëjch, badxeꞌ reeman laan guijcaman, bascajcw reeman laaman tijb lajd xniayaꞌs. ");
INSERT INTO zasNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Dxel gubig reeman lojman, rëbgaj reeman: ―¡Guibanri xrey ree bén Israel! Dxel rëëzgaj reeman lojman. ");
INSERT INTO zasNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Brii Pilato stijb, abiꞌ rëbaman loj ree bén Israel guin: ―Gol baguiaa, gabën laax din gagbeedi, achet xguialquiax radxejlan. ");
INSERT INTO zasNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Dxel brii Jesús, yuꞌ coron guiëjch guin guijcaman, najcw tëëman lajd xnia guin. Abiꞌ rëb Pilato: ―Laax guie. ");
INSERT INTO zasNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Dxel bixhioz rniabee ree në ree bén rajp roꞌ yadooroꞌ Jerusalén, chi baguiaa reeman laaman, guzuloj rbixdiaj reeman, rëb reeman: ―¡Bacaax loj crüjz! ¡Bacaax loj crüjz! Rëb Pilato loj reeman: ―Gol chinëx, lëjt gol bacaax loj crüjz, achet xtolix radxejlan. ");
INSERT INTO zasNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Badxiꞌ reeman laan rëb reeman: ―Laa tijb dux leyan yuꞌ, rëb lojn rayal guiëtix, guial nax najx Xiꞌn Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Chi biguienman ni rëb reeman, mazri bidxebaman. ");
INSERT INTO zasNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Bayuman lën palas guin zatijb, gunabdiidxaman loj Jesús rëbaman: ―¿Ban xin lüj? Per ad badxiꞌt Jesús laan. ");
INSERT INTO zasNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Zeel rëb Pilato: ―¿Nid zadxiꞌl ni rnin ya? ¿Nid ragbeel ya caꞌn guialrniabee din gucan lüj loj crüjz o guslaan lüj ya? ");
INSERT INTO zasNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Dxel rëb Jesús: ―Achetczi guialrniabee nitiaꞌl bal id Dios nunee laan. Zianan zeel mazri zien xtol bén bidnë naj guie yuꞌ guial lojl. ");
INSERT INTO zasNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Diizd hor zii gajc raguiil Pilato mod, xhienaag guslaaman Jesús, per rbidxaꞌ ree bén rigaꞌ yagaj, rëb reeman: ―¡Bal guslaal laax, ad najtil xmiw bén na̱j César! ¡Din chutëëz bén rajc rey rzuj contr César! ");
INSERT INTO zasNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Chi biguien Pilato rëb reeman zian, gunabeeman babëë reeman Jesús, dxel gurej lod rniabeeman, lod la Gabata con diidx hebreo, rën guiëban Lod yuꞌ ree guiaj. ");
INSERT INTO zasNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Chi guixiez gal lanij pascw, cost garol dxej rëb Pilato loj ree bén Israel: ―¡Laa xreydi guie! ");
INSERT INTO zasNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Per rbidxaꞌ reeman rëb reeman: ―¡Guiëtix! ¡Guiëtix! ¡Bacaax loj crüjz! Gunabdiidx Pilato loj reeman, rëbaman: ―¿Wen gucan xreydi loj crüjz ya? Badxiꞌ ree bixhioz rniabee laan, rëb reeman: ―Achut dux reyan yuꞌ, tijbzi César. ");
INSERT INTO zasNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Dxel bayü Pilato Jesús loj ree suldad din gucaa reex laaman loj crüjz, dxel zinë reex laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Briinë reex Jesús, nüüman crüjz, binë reex laaman lod la Calaver, diidx hebreo lan Gólgota. ");
INSERT INTO zasNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ni bacaa reex laaman loj crüjz con zatioꞌp ree bejn, tijb gaj reeman ca cwëꞌman. ");
INSERT INTO zasNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Gunabee Pilato cwa lejtr guijc crüjz guin, rëban: “Jesús bén Nazaret, xrey ree bén Israel.” ");
INSERT INTO zasNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Dád zien ree bén Israel biil lejtr guin, guial na̱j luar zii gajxh loj ciuda, guiáad lejtr guin can con diidx hebreo, diidx latin në diidx grieg. ");
INSERT INTO zasNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Rëb ree bixhioz rniabee ree bixhioz loj Pilato: ―Ad rucaal: “Xrey ree bén Israel”, bacaa: “Bén rëb na̱j xrey ree bén Israel.” ");
INSERT INTO zasNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Badxiꞌ Pilato laan rëbaman: ―Ni ma bacan yayaꞌnan zian. ");
INSERT INTO zasNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Chi gulox bacaa ree suldad guin Jesús loj crüjz, bacaꞌ reex xabaman, gudixyaꞌ reexan tajp laꞌ, dxel cwaꞌ reex tib laꞌ gajn. Në stijb xabaman cwaꞌ reex, ad nadiibtan, najcchaaw diizd yëjnan xt guiaꞌn, najn tijbzi lajd. ");
INSERT INTO zasNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Zeel rëb loj lasaꞌ reex: ―Ad zarooxt reen, yadxiꞌt ree suert din guidoon chu yayal laan. Zian gojc cumplid ni ca loj xtiidx Dios, rëban: “Balaꞌ reeman da xaban, gudxijt tëë reeman suert guijcan.” Zeel been ree xinsuldad guin zian. ");
INSERT INTO zasNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Gajxh cwëꞌ crüjz ca Jesús zaꞌ xniaaman con xbël xniaaman con Li xbéngunaa Cleofas con Li bén gunee reeman Magdalena. ");
INSERT INTO zasNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Chi baguiaa Jesús xniaaman, zaꞌ tijb ree xbejnman cwëꞌman, bén rën daꞌtaman, rëb loj xniaaman: ―Na, laa xiꞌnl yagaj. ");
INSERT INTO zasNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Dxel rëb loj xbejnman: ―Laa xniaal yagaj. Diizd dxej zii bignëman xniaa Jesús lidxaman. ");
INSERT INTO zasNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Chi gulox rëb Jesús zian, gogbeeman ma gojc gran cumplid. Per din gac cumplid ni ca loj xtiidx Dios, rëbaman: ―Reꞌcan nijs. ");
INSERT INTO zasNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Yagaj zaꞌ tijb re yuꞌn vin noꞌchan vinagr, zeel bagajdx reex tijb xiil loj vin guin, bacaa reexan loj tijb yag, dxel badxig reexan roꞌman. ");
INSERT INTO zasNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Chi ma guꞌman laan, dxel rëbaman: ―Ma gojc gran cumplid. Dxel basajb lojman luyuj, güjtaman. ");
INSERT INTO zasNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ma cayüjn ree bén Israel porvinid din guixiez gal lanij pascw. Zeel ad guyënt reeman nayaꞌn ree cuerp guin loj crüjz dxej raziiladx reeman, din dád rajp reeman dxej guin respejt. Zeel biguiedx reeman loj Pilato din nabeeman quiꞌch ree suldad guin xdxijt ree bén ca loj crüjz din guiët reeman yalet tëë reex laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Zeel wej reex. Yaloj gudiꞌch reex xdxijt bén ca cwëꞌ Jesús, dxel gudiꞌch reex xdxijt bén ca stiblad cwëꞌman. ");
INSERT INTO zasNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Chi gubig reex lod ca Jesús, baguiaa reex ma güjtaman, zeel ad gudiꞌcht reex xdxijtaman. ");
INSERT INTO zasNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Per tijb suldad guin guxhal ladaman con guiib caꞌx, dxel briin rejn con nijs. ");
INSERT INTO zasNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Bén rü diidx guie baguiaaman, zeel ragbeeman najn diidxli, rüman laan din në lëjt chililadx. ");
INSERT INTO zasNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Gra nine gojc din gac cumplid ni ca loj xtiidx Dios, rëban: “Ad rayalt gach xdxijt xiildoo.” ");
INSERT INTO zasNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Stiblajt rëb: “Guguiaa reeman bén guxhalnë reeman guiib lad.” ");
INSERT INTO zasNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Chi gulox gojc zian, wej Xiëb, bén zëëd guiedx la Arimatea, bignabaman diidxbee loj Pilato din yaletaman xcuerp Jesús din chiquieꞌchaman laaman. Në bén la Xiëb bililadx Jesús, per ralanzi, guial bidxebaman bejn ree. Badëëd Pilato diidxbee, zeel wej Xiëb bigxiiman xcuerp Jesús. ");
INSERT INTO zasNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Në Nicodemo wej, bén bigneenë Jesús tijb guxhin, bidxinnëman cost gajlbichii quil ni la mirra, noꞌchan aloe, rureen nejxh. ");
INSERT INTO zasNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Bagajdxnë reeman laan lajd batüüb reeman laaman, ziꞌc rüjn ree bén Israel chi ruquieꞌch reeman bengüt. ");
INSERT INTO zasNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Lod cwa Jesús loj crüjz nagaꞌ tijb guidxliuj lod yuꞌ ree yag. Yagaj na̱j tijb baa cüb lod achutczi waguieꞌch. ");
INSERT INTO zasNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yagaj gudixh reeman xcuerpaman, guial najn gajxh, guial ma suloj tëë dxej raziiladx reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Chidumingw chi sta nacayri, wej María Magdalena roꞌ xbaa Jesús, abiꞌ baguiaaman ma bisüd guiaj nayaaw roꞌ baa guin. ");
INSERT INTO zasNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Dxel ruxüünman wejman lod zaꞌ Simón Bëd con zatijb xbejn Jesús, bén rën daꞌtaman, abiꞌ rëbaman loj reeman: ―Ma zinë reeman xcuerp Dad Jesús, banczi bigsaꞌn reeman laaman, achutri laaman yuꞌ lën baa guin. ");
INSERT INTO zasNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Abiꞌ brii Bëd con bén guin, zë reeman roꞌ baa guin. ");
INSERT INTO zasNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Grop reeman ruxüün zë reeman. Per bén guin mazri ruxüünman guial loj Bëd, abiꞌ yaloj laaman bidxin roꞌ baa guin. ");
INSERT INTO zasNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Dxel gudixlojman baguiaaman vend bidüüb Jesús, per ad guyutaman. ");
INSERT INTO zasNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Dxelri bidxin Simón Bëd, abiꞌ guyuman lën baa guin. Nëgajcaman baguiaa vend guin ");
INSERT INTO zasNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Baguiaa tëëman lajd bidüüb guijc Jesús, nadüüban nagaꞌn lood ren, ad nagaꞌtan tijbzi con vend guin. ");
INSERT INTO zasNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Dxel guyu bén bidxin roꞌ baa guin yaloj, baguiaaman ni goc, zianz bililadxaman, ");
INSERT INTO zasNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","guial gocli ad bigniaꞌt reeman ni ca loj xtiidx Dios guial yaban Jesús loj ree bengüt. ");
INSERT INTO zasNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Dxel zia ree xbejn Jesús lidx reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Per Li bayaꞌnman roꞌ baa guin cayoonman. Laꞌtgaj cayoonman gudixlojman lën baa guin, ");
INSERT INTO zasNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","abiꞌ baguiaaman tioꞌp ree anjl, najcw reeman lajd naquich, zojb reeman lod goꞌt xcuerp Jesús, tijbaman lod goꞌt guijcaman, zatijbaman lod goꞌt guiaꞌman. ");
INSERT INTO zasNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Dxel gunabdiidx ree anjl guin lojman, rëb reeman: ―Na, ¿chexc zeel roonl? Badxiꞌman laan rëbaman: ―Guial zinë reeman xcuerp Dad Jesús, abiꞌ banczi guin bigsaꞌn reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Guloxzi rëbaman zian, badxiꞌ lojman baguiaaman zaꞌ Jesús yagaj, per ad bayünbeetaman laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Dxel gunabdiidx Jesús lojman, rëbaman: ―Na, ¿chexc zeel roonl? ¿Chu raguiilil? Gunaladx Li, bén rajp lod yuꞌ ree yagnejxh guinan, abiꞌ rëbaman: ―Dad, bal lüj binë xcuerpaman, guna ban bigsaꞌnl laaman din chigxin laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Zianz rëb Jesús lojman: ―¡Li! Dxel badxiꞌ loj Li, rëbaman lojman con diidx hebreo: ¡Rabuni! ―rën guiëban Mextr. ");
INSERT INTO zasNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Rëb Jesús lojman: ―Ad guquiꞌl naj, din gadan yayaꞌ loj da Dadan. Per baguiaj biguiedx loj ree da bejnan guial yayaꞌ loj da Dadan bén naj gajc xDadidi, loj da Diosan bén naj gajc xDiosidi. ");
INSERT INTO zasNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Dxel wej María Magdalena bicojnman xbejn ree Dad Jesús guial baguiaaman laaman, bagojn tëëman laa reeman gra ni rëbaman lojman. ");
INSERT INTO zasNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Chidumingw zii gajc chi ma caxhin, badoꞌp ree xbejn Jesús, nayaaw roꞌ port yuꞌ reeman guial rdxeb reeman guxtis Israel ree. Dxel balüüloj Jesús galay reeman, rëbaman loj reeman: ―Yabeꞌcdxe Dios luxdoodi. ");
INSERT INTO zasNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Chi ma gulox rëbaman zian, balüü yaaman loj reeman në cwëꞌlënman, abiꞌ laa reeman dád babaa reeman baguiaa reeman Dad Jesús. ");
INSERT INTO zasNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Dxel rëbaman loj reeman zatijb: ―Yabeꞌcdxe Dios luxdoodi. Ziꞌc guxhaalaman naj, ziangajc rxhialan lëjt. ");
INSERT INTO zasNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Dxel balüjbaman guijc reeman, rëbaman: ―Gol gubajnnë xSprijt Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Bén güündi perdon xtol, chiquied xtol reeman, guiáad bén ad züjntidi perdon xtol, yayaꞌnnë xtol reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tumajs, bén rniee reeman Cwajch, achut laaman zaꞌ chi balüüloj Jesús loj ree xbejnman. ");
INSERT INTO zasNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Chi rëb reeman loj Tumajs: ―Ma baguiaan Dad Jesús. Dxel rëbaman: ―Bal id zuguian yaaman lod wëëz clav, abiꞌ bal id zaguꞌ da bacwënan lod wëëz clav guin, bal id zaguꞌ tëë yan cwëꞌlënman lod bidxeelguijdx, ad zaliladxtan. ");
INSERT INTO zasNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Chi goc xhujn dxej, badxajg lasaꞌ ree xbejn Jesús zatijb, per dxel në Tumajs zaꞌnë laa reeman, nayaaw ruyu yuꞌ reeman. Per balüüloj Jesús galay reeman, rëbaman loj reeman: ―Yabeꞌcdxe Dios luxdoodi. ");
INSERT INTO zasNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Dxel rëbaman loj Tumajs: ―Badxeꞌ xbacwënl guie, baguiaa ree yan, banee yaal guie badxeꞌn cwëꞌ lënan. Ad runawëëgril, bililadx. ");
INSERT INTO zasNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Dxel rëb Tumajs lojman: ―¡Da Dadan, da Diosan! ");
INSERT INTO zasNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Abiꞌ rëb Jesús lojman: ―Rliladxil guial ma baguiaal naj. Xiquilbaa ree bén rliladx, majs ad waguiaat reeman naj. ");
INSERT INTO zasNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Zienri ree milagr been Jesús loj ree xbejnman, ni ad cwat ree loj guiꞌch guie. ");
INSERT INTO zasNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Saꞌn nine ree cwa reen din chililadxidi guial Jesús na̱j Cristo, Xiꞌn Dios, abiꞌ guial chililadxidi laaman guibandi tiblayaa con Dios. ");
INSERT INTO zasNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Chi gudëd gojc zian, balüüloj Jesús loj ree xbejnman zatijb, roꞌ nijs na̱j gajxh guiedx Tiberias. Ze balüülojman: ");
INSERT INTO zasNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Chi nadxag lasaꞌ ree Simón Bëd con Tumajs bén rniee reeman Cwajch, në Natanael bén za Caná guiedx rigaꞌ niz Galilea, con ree xiꞌn Zebedeo, nëtëë zatioꞌp xbejn Jesús, ");
INSERT INTO zasNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","dxel rëb Bëd loj reeman: ―Gan chignaazan bëjl. Badxiꞌ reeman laan rëb reeman: ―Në dunujn yadxoo. Abiꞌ wëꞌp reeman loj barcw zë reeman, per guxhin zii achutczi bëjl gunaaz reeman. ");
INSERT INTO zasNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Chi ma cayreguiaal, bidxin Jesús roꞌ nijs guin, per ad bayünbeet reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Dxel gunabdiidxaman loj reeman rëbaman: ―Xiꞌn, ¿nid chu bëjl wanaazidi ya? Badxiꞌ reeman laan rëb reeman: ―Achutczi. ");
INSERT INTO zasNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Abiꞌ rëb Jesús loj reeman: ―Gol bazaal xguijxhidi xladbee barcw guin din guiniaazidi bëjl. Zian been reeman, abiꞌ ad rajctri rabëë reeman guijxh guin, guial dád zien bëjl yuꞌ lojn. ");
INSERT INTO zasNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Dxel xbejn Jesús, bén rën daꞌtaman, rëbaman loj Bëd: ―¡Dad Jesúsan! Biguiejnzi Simón Bëd zian, laa got gajc xabaman ni gulëëman, abiꞌ gutiajsaman lojnijs guin. ");
INSERT INTO zasNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Guiáad zaxhoꞌp xbejn Jesús loj barcw guin badxin reeman roꞌ nijs guin, coobyuj reeman guijxh guin, guidxan bëjl, guial ziꞌctzi tibgayuu mejtr ryaadx yadxin reeman roꞌ nijs guin. ");
INSERT INTO zasNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Chi baguiajt reeman, baguiaa reeman laa guij ma rigaꞌ, dxiib tijb bëjl lojn, në guiadxtil rigaꞌ yagaj. ");
INSERT INTO zasNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Dxel rëb Jesús loj reeman: ―Gol tanë tioꞌp choon bëjl gunaaz nejzidi. ");
INSERT INTO zasNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Dxel wëꞌp Bëd loj barcw guin, guxoobyujman guijxh guin guidxan bëjl naroob ree, xt roꞌ nijs guin. Tibgayuu tüꞌpchiibichoon bëjl yuꞌ lojn. Abiꞌ majsi zienb, per ad goxyaꞌtan. ");
INSERT INTO zasNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Zianz rëb Jesús loj reeman: ―Gol guda din gawidi rsiil. Abiꞌ niꞌqui tijb reeman ad rayaxt guiniabdiidx chu bénan, guial ragbee reeman Dad Jesúsan. ");
INSERT INTO zasNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Dxel gubigaman cwaꞌman guiadxtil badëëman loj reeman, ziangajc beenman con bëjl guin. ");
INSERT INTO zasNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ni ne bayon volt balüüloj Jesús loj ree xbejnman chi babanman loj ree bengüt. ");
INSERT INTO zasNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Chi gulox gudaw Jesús con ree xbejnman, gunabdiidxaman loj Simón Bëd, rëbaman: ―Simón, xiꞌn Waj, ¿walil ya rënl naj mazri guial loj ree bén guie? Badxiꞌ Bëdan rëbaman: ―Dad, ragbeequil rënan lüj. Zeel rëb Jesús: ―Gunaj ree da xiildoon. ");
INSERT INTO zasNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Abiꞌ rëb Jesús zatijb: ―Simón, xiꞌn Waj, ¿walil ya rënl naj? Badxiꞌ Bëdan rëbaman: ―Dad, ragbeequil rënan lüj. Zeel rëb Jesús: ―Gunaj ree da xiilan. ");
INSERT INTO zasNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Bayon volt gunabdiidx Jesús rëbaman: ―Simón, xiꞌn Waj, ¿rënl naj ya? Dád guyunaya Bëd, guial ma gojc choon volt gunabdiidx Jesús bal rënman laaman. Zianz rëb Bëd: ―Dad, lüj ragbee graczi, ragbeel rënan lüj. Zeel rëb Jesús: ―Gunaj ree da xiilan. ");
INSERT INTO zasNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Diidxliczi ganin, chi goquil xinguiag, rajcw xabil persi rejl lod rënl. Per chi ma najl bengol, gusli xuꞌquil din guscajcw ben ren xabil din chinë reeman lüj lod ad rëntil chel. ");
INSERT INTO zasNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Rëb Jesús zian guial basigniaꞌman xhienaag guiët Bëd, din güünbee ree bejn Dios. Dxel rëb Jesús: ―Tanal naj. ");
INSERT INTO zasNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Chi badxiꞌ loj Bëd, baguiaaman laa bén rën daꞌt Jesús zinal laa reeman. Laaman gure cwëꞌ Jesús chi gudaw reeman xche, gunabdiidx tëëman loj Jesús rëbaman: “Dad, ¿chu yayü lüj?” ");
INSERT INTO zasNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Chi baguiaa Bëd laaman, gunabdiidxaman loj Jesús rëbaman: ―Dad, laadxza xin guin, ¿xhie saquix? ");
INSERT INTO zasNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Badxiꞌ Jesúsan rëbaman: ―Bal rënan guibanx xt yaguialan, ¿xhie güünl? Lüj tanal naj. ");
INSERT INTO zasNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Zianan zeel bireꞌch diidx loj ree xbejnman guial ad zëjtt bén guin. Per ad ziantan rëb Jesús, rëbaman: “Bal rënan guibanx xt yaguialan, ¿xhie güünl?” ");
INSERT INTO zasNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Bén guin gajcan rü diidx xcwent ree nine, laa tëëman bacaa laan, rayagbee tëë ree rüman diidxli. ");
INSERT INTO zasNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Dád zien ree ni been Jesús, bal nitia tijb gajn, wed ad zadaant loj guidxliuj niu ree libr ni niajc.");
INSERT INTO zasNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Rugajpdiozan lüj dad Teófilo: Loj da guiꞌch yalojn rnin graczi ni been Jesús ni balüü tëëman chi guzuloj xchiinman ");
INSERT INTO zasNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","xt chi ziaman xanyabaa. Chi gadaman yaguiaj, gunabeeman bén na̱j ree apóstoles, bén guleman, ni rayal güün reeman, ziꞌc rëb xSprijt Dios lojman. ");
INSERT INTO zasNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Chi mal guzagdiaj daꞌtaman loj xguialgüjtaman, babanman loj ree bengüt. Loj tiuu dxej balüülojman zien volt loj bén na̱j ree apóstoles, persi gogbee reeman nabancaman. Dxej zii ree guneenëman laa reeman xcwent xguialrniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Chi ziz zaꞌnëman laa reeman, guneenëman laa reeman ad yaza reeman Jerusalén, rëbaman: ―Gol gulëjz gac cumplid ni na da Dadan ziꞌc ma rnin lojdi. ");
INSERT INTO zasNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Walican baroobnijs Waj con nijs, per ma zidyob dxej guiꞌt xSprijt Dios guibannë lëjt, laan gac ziꞌc guialrirobnijs par lëjt. ");
INSERT INTO zasNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Lën ree dxej zii chi badxaag lasaꞌ reeman con Jesús, gunabdiidx reeman lojman rëb reeman: ―Dad, ¿yanan yayül guialrniabee loj ree bén Israel ya? ");
INSERT INTO zasNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Badxiꞌ Jesúsan rëbaman: ―Ad lëjtit rayal gagbee xhie dxejn o xhie horan gac zian. Tijbzi da Dadan ragbee laan din laaman caꞌ guialrniabee. ");
INSERT INTO zasNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Per chi ma nabannëdi xSprijt Dios, tiaꞌdi guialrniabee. Dxel griidi chiguiedi diidx loj ree bén Jerusalén chu najn, në gra ree guiedx rigaꞌ niz Judea në niz Samaria, xt ree guiedx ren ni rigaꞌ ree zijt daꞌt. ");
INSERT INTO zasNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Gulox guneeman, ruguiaa reeman laaman dxejlczi wajsaman ziaman xanyabaa, abiꞌ biguiajt tijb bëj bataꞌcwan laaman, dxel ad baguiaatri reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Laꞌtgaj ruguiaa reeman ziaman xanyabaa, gulentie tioꞌp ree bén najcw lajd naquich lod zaꞌ reeman, ");
INSERT INTO zasNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","abiꞌ rëb reeman loj ree apóstoles guin: ―Bén Galilea, ¿chexc zeel sta ruguiaadi xanyabaa? Jesús, bén baguiaadi zia xanyabaa, laagajcaman yaguiaad stijb, ziꞌcgajc baguiaadi ziaman. ");
INSERT INTO zasNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Chi baza ree xi apóstoles Jesús ruguiaꞌ la Olivos, guza reeman ziꞌct rza reeman dxej raziiladx reeman, persi badxin reeman Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Chi badxin reeman, wëꞌp reeman lënü ladya lod zojb reeman. Brii laj reeman Bëd, Waj, Jacob, Andrejs, Felip, Tumajs, Tol, Matew, Jacob xiꞌn Alfeo, Simón (bén guzunë ree bén cananistas), në Judas xiꞌn Jacob. ");
INSERT INTO zasNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Gra reeman rüjn tijbzi xgab, radxaag lasaꞌ reeman din cwedx guiniab reeman Dios, con ree bijch Jesús con Li xniaaman, con ree béngunaa ren. ");
INSERT INTO zasNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Lën ree dxej zii badoꞌp ree bén rliladx Jesús, na̱j reeman cost tibgayuu gajl bejn, dxel guzuli Bëd galay reeman, rëbaman loj reeman: ");
INSERT INTO zasNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Compniar raliduladx ree Jesucrist, ganin lojdi, gojc cumplid ni bacaa rey Davi loj xtiidx Dios por xSprijtaman xcwent Judas, xin balüü Jesús loj ree bén gunaaz laaman, ");
INSERT INTO zasNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","gojquix tijb dux compniaran, në laax been lasaꞌ dxiin raguieenan. ");
INSERT INTO zasNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Per con milia ni gudix reeman laax por ni mal beenx, bioꞌ guidxliuj lod gudidyaꞌx, bazuj guijquix, goxyaꞌx abiꞌ brii gra xziix. ");
INSERT INTO zasNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Chi gogbee gra ree bén Jerusalén ni goc, gunee reeman guidxliuj zii Acéldama, rën guiëban guidxliuj rejn. ");
INSERT INTO zasNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Din rëb loj libr la Salmos: Yayaꞌn dëjch lidxix, achutcziri cwe lënan. Rëb tëë lojn: Yayu ben ren guiaꞌx. ");
INSERT INTO zasNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Zeel loj gra ree bén zaꞌnë dunuj ree guidib tiamp ni guzunë Jesús dunuj ree, ");
INSERT INTO zasNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","diizd chi baroobnijs Waj laaman xt chi ziaman xanyabaa. Loj gra reeman rayal grii tijbaman din güünman dunuj ree yudar yaguieꞌch ree loj ree bejn guial walican babanman loj ree bengüt. ");
INSERT INTO zasNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Dxel gulej reeman tioꞌp reeman: tijb bén la Xiëb (rniee reeman laaman Barsabás, rniee tëë reeman laaman Justo), gulej tëë reeman bén la Matías. ");
INSERT INTO zasNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Dxel gurejdx gunab reeman Dios, rëb reeman: ―Dad, lüj nünbee luxdoo gra ree bejn. Balüü chu loj grop reeman gulejl ");
INSERT INTO zasNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","din gacaman apóstol luar Judas, din banijtix delant lojl por dol ni beenx abiꞌ ziax luar ni rayalix. ");
INSERT INTO zasNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Dxel baguiaa reeman chu yayal suert guin, abiꞌ bayal Matías laan. Loj hor zii gajc bayuman loj zachibtib ree apóstoles. ");
INSERT INTO zasNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Chi bidxin dxej gojl lanij la Pentecostés, gra ree bén rliladx Jesucrist badoꞌp tijbzi luar. ");
INSERT INTO zasNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Dxejlczi gojc naquieꞌ xanyabaa ziꞌc bidoxh xt bayu bi lënü lod rigaꞌ reeman, ");
INSERT INTO zasNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","abiꞌ gulentie ziꞌc bajl dobëz ree, biguiajt reen guijc tijb gaj reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Zianz guyu xSprijt Dios luxdoo graczi reeman, dxel guzuloj canee reeman diidx ren ree ziꞌc cusnee Sprijt guin laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Lën ree dxej zii zaꞌ zien ree bén Israel Jerusalén, baza reeman gra ladczi din cwedx guiniab reeman Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Chi biguiejn reeman cayajc naquieꞌ, badoꞌp reeman persi biquiaa reeman. Dxel chi biguiejn reeman rniee gra ree bén rliladx Jesús xtiidx tijb gaj reeman, ad badxejlt xgab nüjn reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Dád badxa loj reeman xt niꞌquid badxejlt xhie nüjn reeman, abiꞌ gunabdiidx loj lasaꞌ reeman rëb reeman: ―¿Nid bén Galilea gra ree bén canee guin ya? ");
INSERT INTO zasNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Chexc zeel raguiejn ree rniee reeman dux tiidx ree? ");
INSERT INTO zasNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Du loj ree noꞌch ree bén zëëd guiedx rigaꞌ ree niz Partia, Media, Elam, Mesopotamia, Judea, Capadocia, Ponto, Asia Menor, ");
INSERT INTO zasNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","bén zëëd tëë ree guiedx rigaꞌ ree niz Frigia, Panfilia, Egipto, në ree guiedx nulen Libia ni rigaꞌ ree gajxh Cirene, në ree bén zëëd Rom, yuꞌ reeman gojl Israel per naban reeman Rom, yuꞌ tëë reeman na̱j quijb ben Rom per rliladx reeman ni rliladx ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Në ree bén zëëd niz Creta nëtëë ree bén zëëd guiedx rigaꞌ ree niz Arabia noꞌch du loj ree. ¡Per dugraczi ree caycaagdiajg con dux tiidx ree nizaꞌcdxoon rüjn Dios! ");
INSERT INTO zasNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Graczi reeman badxa daꞌt loj xt niꞌquid badxejlt xgab nüjn reeman, abiꞌ guzuloj canabdiidx loj lasaꞌ reeman rëb reeman: ―¿Xhie rën guiëb gra ni guie? ");
INSERT INTO zasNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Per garol reeman bazeꞌ laa reeman, rëb reeman: ―Rëꞌ reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Dxel guzuli Bëd con zachibtib ree apóstoles guin, guneeman rejs rëbaman: ―Lëjt bén Judea në graczi ree bén zojb Jerusalén, gol bacaagdiajg gol bigniaꞌ tëë ni ganin. ");
INSERT INTO zasNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ad rëꞌt ree bén guin ziꞌc naladxidi, din qui gojlri raca gaa rsil. ");
INSERT INTO zasNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Guie cayajc cumplid ni gunee bén brii laj Joel, bén badëë xtiidx Dios loj ree bejn, chi rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Na Dios, guidxin dxej gaxhal da Sprijtan luxdoo gra ree bejn, abiꞌ xiꞌndi xinguiaaw con biingunaa gudëëd reex da diidxan, zien ree ni gulüüloj loj ree xinguiag, guiáad ree bengol zien ree ni guinieꞌxchaal reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Dxej zii ree gaxhal da Sprijtan luxdoo ree bén rüjn da dxiinan, xinguiaaw ree në ree béngunaa, abiꞌ gudëëd reeman da diidxan. ");
INSERT INTO zasNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Gulün sen ree xanyabaa ni yadxa lojdi, guiáad loj guidxliuj gulün sen ree ziꞌc rejn në bajl nëtëë goꞌxh. ");
INSERT INTO zasNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Guicajy loj gubijdx, guiáad bëëw yayajcan ziꞌc rejn. Chi ma gojc zian, dxel guidxin quijb dxej guin, dxej zaꞌcdxoon guiꞌt Dios bén rniabee, dxej guiguien guidib xbianiman. ");
INSERT INTO zasNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Abiꞌ graczi ree bén cwedx guiniab laaman güünman laa reeman perdon. ");
INSERT INTO zasNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Rëb tëë Bëd loj reeman: ―Yan, gol bacaagdiajg ni ganin lëjt bén Israel: Lëjt ragbee guial Jesús bén Nazaret najman bén guxhaal Dios, been tëëman milagr ree në ree ni radxa loj ree bejn ziꞌc sen din gagbeedi guial Dios guxhaal laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Diizd gocli mal nüjn Dios xgab guial zian güünnëdi Jesús, gunaazidi laaman bayüdi laaman loj ree benmal, din gugüjt reeman laaman loj crüjz. ");
INSERT INTO zasNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Per basban Dios laaman stijb, babëëman laaman loj guialgüjt, din ad gojct nutëë guialgüjt guin laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Chi gunee rey Davi xcwent Jesús, rëbaman: Zianczi baguian dux Dad ree Dios zaꞌnëman naj. Zaꞌman da ladbeen, achetczi zajc guchejb naj. ");
INSERT INTO zasNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Zeel yuꞌ luxdon nix, ruzat tëën Dios zagdxe. majsi guiëtan ad rdxebtan, ");
INSERT INTO zasNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","din ad zusaꞌntil naj lën baa, ad zatiëjbtil xhin xcuerp xiꞌnl bén naya nali. ");
INSERT INTO zasNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Balüül naj nejz runee guialnaban, chuꞌ tëë luxdon zagdxe guial guibannël naj. ");
INSERT INTO zasNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Basnuu gunee Bëd, rëbaman: ―Ganin loj gradi compniar, diidxliczi dux béngulal ree Davi güjtaman biguieꞌch tëëman, abiꞌ laa xbaaman sta raguiaa ree yan. ");
INSERT INTO zasNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Per gojcaman bén badëë xtiidx Dios loj ree bejn, abiꞌ gogbeeman been Dios promejs guial loj xdiaaman grii Cristo bén nabee. ");
INSERT INTO zasNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Rulüü ma cuguiaaman gra ni gac, rëbaman guial yaban Cristo loj ree bengüt, ad zayaꞌntaman lën baa ad zaxin tëët xcuerpaman. ");
INSERT INTO zasNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yan ma basban Dios Jesús, dugran nayajc testiw guial walican babanman. ");
INSERT INTO zasNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Zia tëëman xanyabaa zisobaman xladbee Dios, persi badëë xSprijt Dios lojman ziꞌc ma rëbaman, yan ma guxhaal Jesús Sprijt guin loj guidxliuj, por laaman cayajc ni cuguiaadi caguiejn tëëdi. ");
INSERT INTO zasNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ad Davitan zia xanyabaa, din laagajcaman rëb: Rëb dux Dad ree Dios loj bén rniabee naj: “Gurej da ladbeen, ");
INSERT INTO zasNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","xt gabecan xin rdxeꞌch ree lüj guiaꞌl.” ");
INSERT INTO zasNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Gradi bén Israel gol gogbee guial Jesús bén bacaadi loj crüjz, Dios bacaabee laaman din gacaman Dad, bén nabee dunuj ree. ");
INSERT INTO zasNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Chi biguiejn ree bén rigaꞌ yagaj ni rëb Bëd, dád guyu naya luxdoo reeman. Abiꞌ gunabdiidx reeman lojman në loj los demazri ree apóstoles guin, rëb reeman: ―Dad, gol guna, ¿xhie rayal yaguieenan? ");
INSERT INTO zasNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Dxel rëb Bëd loj reeman: ―Gol bayagbee xtolidi, gol badxiꞌ tëë lojdi loj Dios, gol gurobnijs por xguialrniabee Jesucrist din gac xtolidi perdon, zian chuꞌ xSprijtaman luxdoodi. ");
INSERT INTO zasNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Din promejs guin na̱j par lëjt në par ree xiꞌndi në par gra ree bén rigaꞌ zijt, par gra ree bén cwe Dios par laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Con ree diidx guie në mazri ree diidx ren guneenë Bëd laa reeman, rëbaman: ―¡Gol bariica loj ree bén rüjn ni mal! ");
INSERT INTO zasNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Zian gojc, graczi bén bazoob diidx ni rëbaman gurobnijs. Dxej zii gajc bachajg cost choon mil bejn bén rliladx ree Jesús. ");
INSERT INTO zasNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Graczi reeman binal ni balüü ree xi apóstoles Jesús laa reeman, gubajnnë lasaꞌ reeman zagdxe, gurejdx gunab reeman Dios abiꞌ radoꞌp reeman persi raw reeman guiadxtil tijbzi ziꞌc gunabee Jesucrist güün reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Graczi ree bejn radxa daꞌt loj milagr në los demazri ree ni been ree apóstoles guin. ");
INSERT INTO zasNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Graczi ree bén bililadx Jesucrist gubajnnë lasaꞌ zagdxe, rguiꞌs tëë ni rajp reeman loj lasaꞌ reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Rutoꞌ xguidxliuj reeman në gra ni rajp reeman, persi rguiꞌs reeman milia guin loj lasaꞌ reeman ziꞌctzi na̱j ni riaadx tijb gaj reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Guixie guixie radoꞌp reeman lën yadooroꞌ Jerusalén, dxel raguiaj reeman lidx xcompniar reeman rtaw reeman, dád nix yuꞌ luxdoo reeman rën tëë lasaꞌ reeman, ");
INSERT INTO zasNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ruzaꞌt reeman Dios zagdxe, guiáad gra bejn guyën laa reeman. Guixie guixie ragnë Dios din gacxhiej mazri bén rliladx Jesucrist, persi gojc xtol reeman perdon. ");
INSERT INTO zasNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tijb dxej zë ree Bëd con Waj lën yadooroꞌ Jerusalén raca choon wadxe, hor zii na̱j hor ni rbejdx rniab reeman Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Roꞌ xport yadoo guin zojb tijb bén ad rajct rza diizd gojlaman. Zianczi rbeꞌc reeman laaman roꞌ port guin, ni la Port Zaꞌcdxoon, din guiniabaman carda loj ree bén ru lën yadoo guin. ");
INSERT INTO zasNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Chi baguiaaman Bëd con Waj ma chuꞌ reeman lën yadoo guin, gunabaman carda loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Baguiaa reeman lojman, dxel rëb Bëd lojman: ―Baguiaa du lojn. ");
INSERT INTO zasNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Chi biguiejnman rëb Bëd zian, dxel baguiaaman loj reeman, naladxaman milia nudëëd reeman lojman. ");
INSERT INTO zasNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Per rëb Bëd: ―Ad raꞌptan plajt niꞌqui or par gunen lojl, per ni zajc günan por lüj günanan: Por xguialrniabee Jesucrist bén Nazaret, guzuli, guza. ");
INSERT INTO zasNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Dxel gunaazaman yaaman ladbee, bazuliman laaman. Loj hor zii gajc guyu ree guiaꞌman gojl, ");
INSERT INTO zasNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","abiꞌ gutiajsaman, guzuliman guzuloj cazaman. Dxel guyunëman laa reeman lën yadoo guin, cazaman, catiajsaman cuzaꞌt tëëman Dios zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Graczi ree bén cuguiaa laaman cazaman cuzaꞌt tëëman Dios zagdxe, ");
INSERT INTO zasNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","dád badxa loj reeman bidxeb tëë reeman guial gojc zian guial nünbee reeman bén guin, ragbee tëë reeman laaman rbej roꞌ xport yadoo guin ni la Port Zaꞌcdxoon, rniabaman carda. ");
INSERT INTO zasNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ad riroꞌnladxt bén bayajc guin Bëd con Waj. Dád badxa loj ree bejn, abiꞌ baxüün reeman wej reeman lod la xcurdur Salomón lod zaꞌ ree Bëd con Waj. ");
INSERT INTO zasNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Chi baguiaa Bëd zian, rëbaman loj reeman: ―Bén Israel, ¿chexc zeel radxa lojdi ni goc? Ad naladxidi por dunujn rza bén guie guial nacaꞌn guialrniabee o guial nayajcan naya delant loj Dios ya. ");
INSERT INTO zasNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","XDios dux béngulal ree Abraham, Isaac në Jacob, laaman badëë guialrniabee loj Jesús, bén bayüdi loj guxtis. Abiꞌ chi guyën Pilato nuslaaman laaman, ad cwëjbtidi. ");
INSERT INTO zasNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Luar niniabidi nuslaa Pilato bén naya nali, bén rüjn ziꞌc rayal, gunabidi baslaaman tijb xin bagüjt bejn. ");
INSERT INTO zasNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Zian bagüjtidi bén runee guialnaban. Per basban Dios laaman stijb, abiꞌ dunujn nayajc testiw guial babanman. ");
INSERT INTO zasNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Bén guie, bén ruguiaadi nünbee tëëdi, guyu gojl guiaꞌman por xguialrniabee Jesucrist, bayajcaman guial baliduladxan, ziꞌc ruguiaa graczidi. ");
INSERT INTO zasNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Ganin lëjt compniar, ragbeen guial lëjt con ree bén rniabee lëjt niꞌquid gogbeetidi xhienin beendi chi bagüjtidi Jesús. ");
INSERT INTO zasNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Per zian been Dios persi gojc cumplid ni rëbaman loj ree bén badëë xtiidxaman loj ree bejn diizd gocli guial sagdiaj Cristo. ");
INSERT INTO zasNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Zeel gol bayagbee xtolidi gol badxiꞌ tëë lojdi loj Dios din güünman xtolidi perdon. Dxel yayaalyuj luxdoodi, ");
INSERT INTO zasNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","guixhiaal tëëman Jesús stijb, bén na̱j Cristo diizd gocli par lëjt, ");
INSERT INTO zasNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","majsi yan rayalri suman xanyabaa, xt ma bazuxnejz Dios gra, ziꞌc rëbaman loj ree bén badëë xtiidxaman loj ree bejn diizd gocli, bén gubajn ree naya delant lojman. ");
INSERT INTO zasNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Abiꞌ rëb Moisejs loj ree dux béngulal ree: “Loj xdiaadi cwëë Dios tijb bén gudëë xtiidxaman loj ree bejn ziꞌc naj, gol bazoob xtiidxaman graczi ni naman lojdi, ");
INSERT INTO zasNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","din graczi ree bén ad zuzoobt xtiidxaman nit reeman, ad zajc tëëtri reeman cwent ziꞌc xbejn Dios.” ");
INSERT INTO zasNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Gra ree bén badëëd xtiidx Dios loj ree bejn, diizd Samuel con los demazri ree bén badëë xtiidx Dios diizd gulal, mal bagojn reeman ni cayajc ree lën ree dxej guie. ");
INSERT INTO zasNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Lëjt na̱j xdiaa reeman, lojdi gac cumplid ni cwëb Dios loj ree dux béngulal ree chi rëbaman loj Abraham: “Por xdiaal günleꞌn gra ree bénguidxliuj.” ");
INSERT INTO zasNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Abiꞌ chi basban Dios xiꞌnman Jesucrist, yaloj lojdi guxhaalaman laaman din güünleꞌman lëjt din yabëëcaman gradi loj ni mal rüjndi. ");
INSERT INTO zasNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Sta canee ree Bëd con Waj loj ree bejn, chi bidxin ree xbixhioz ree bén Israel në suldad rniabee suldad rniaj ree roꞌ yadooroꞌ Jerusalén, nëtëë ree bénsaducew. ");
INSERT INTO zasNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Dád ralen reeman guial culüü ree Bëd con Waj bejn ree, rëb reeman guial yaban ree bejn loj ree bengüt, din laan ma baguiaa reeman chi baban Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Zeel gunaaz reeman laa reeman, per guial ma gudxe, zeel badxeꞌ reeman laa reeman ladxguiib laꞌtgaj rareguiaal. ");
INSERT INTO zasNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Per dád zien ree bén bacaagdiajg ni rëb ree Bëd con Waj bililadx xtiidx Dios, gojc reeman cost gaay mil xinguiaaw xcwentqui ree béngunaa. ");
INSERT INTO zasNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Chi bareguiaal, guxtis Jerusalén në ree bengol në ree mextr rulüü ley, badoꞌp reeman loj ciuda guin. ");
INSERT INTO zasNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Në Anás bidxin yagaj, bén na̱j bixhioz mazri zojbloj rniabee graczi ree bixhioz, bidxin tëë bixhioz la Caifás në Waj në Lejandr, nëtëë gra ree bén na̱j lasaꞌ ree bixhioz rniabee guin. ");
INSERT INTO zasNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Gunabee reeman bicaꞌ reeman Bëd con Waj, abiꞌ bazuj reeman laa reeman galay lod rigaꞌ reeman, dxel gunabdiidx reeman loj reeman, rëb reeman: ―¿Chu banee diidxbee o chu por rüjndi ni guin? ");
INSERT INTO zasNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Per guial yuꞌ xSprijt Dios luxdoo Bëd dád gognëman laaman, zeel rëbaman: ―Gol bacaagdiajg ni ganin lëjt bengol në lëjt guxtis, ");
INSERT INTO zasNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","rniabdiidxidi dunujn xhienaag baguieenan béngogxuu guin yudar, xhie tëë naag gojc zeel bayajcaman. ");
INSERT INTO zasNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Yanan lojdi din gagbeedi gagbee tëë gra bén Israel xhienaag bayajc bén zaꞌ lojdi. Bayajcaman por xguialrniabee Jesucrist bén Nazaret, bén bacaadi loj crüjz abiꞌ basban Dios laaman stijb. ");
INSERT INTO zasNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Beennëdi laaman ziꞌc rüjn ree bén rüjn yu chi rbëëgoꞌn reeman tijb guiaj, dxel qui ragbeeri reeman guial guiaj guin na̱j ni mazri lasajc par gacnë yu guin. ");
INSERT INTO zasNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Achut ben ren rüjn dux tol ree perdon, tijbzi Jesús, din achut mazri guxhaal Dios loj guidxliuj din güünman dunuj ree perdon. ");
INSERT INTO zasNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Chi baguiaa ree guxtis guin ad rdxebt ree Bëd con Waj guial rniee reeman, abiꞌ gogbee reeman ad bén basiidt ree mazran achu tëët na̱j reeman, badxa loj reeman bayünbee tëë reeman laa reeman guial bén binal ree Jesúsan. ");
INSERT INTO zasNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Abiꞌ yagaj gajc zaꞌ bén bayajc guin, zeel ad bileꞌtri xhie niëjb reeman contr laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Dxel gunabee ree guxtis guin barii ree Bëd con Waj din yayaꞌn laaz reeman din gü reeman diidx. ");
INSERT INTO zasNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Rëb reeman: ―¿Xhienaag yaguieennëꞌ ree xin guin ree? Graczi ree bén Jerusalén ma ragbee milagr been reex. Abiꞌ ad zajct yarexuu ree. ");
INSERT INTO zasNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Per chitëë guireꞌch xtiidx Jesús, yachejb reex din diizd yan achutcziri loj guzaꞌt reex laax. ");
INSERT INTO zasNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Dxel gurejdx reeman laa reeman gunabee reeman chitëë churi loj guzaꞌt reeman Jesús, ad gulüü tëëri reeman xtiidxaman. ");
INSERT INTO zasNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Per badxiꞌ Bëd con Waj laan, rëb reeman: ―Lëjt gajc gol been xgab: ¿Zagdxe na̱j yazooban xtiidxidi luar yazooban xtiidx Dios ya? ");
INSERT INTO zasNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Per ad zajct yacwëëz yaguieꞌchan gra ni baguiaan baguiejn tëën. ");
INSERT INTO zasNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Dxel bachejb ree guxtis guin laa reeman stijb, dxelri baslaa reeman laa reeman zia reeman guial ad badxejlt xhienaag nudëëd reeman laa reeman casti, din graczi ree bejn ruzaꞌt Dios zagdxe por ni goc. ");
INSERT INTO zasNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Nadëd tiuu ijz yuꞌ bén bayajc guin. ");
INSERT INTO zasNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Chi baslaa ree guxtis guin Bëd con Waj, baguiaj reeman lod rigaꞌ xcompniar reeman bén rliladx ree Jesucrist, abiꞌ be reeman diidx ni rëb ree bixhioz rniabee ree bixhioz në ree bengol rniabee. ");
INSERT INTO zasNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Chi gulox bacaagdiajg reeman diidx ni be reeman, graczi reeman guzuloj cabejdx canab Dios, rëb reeman: ―Dad lüj rniabee gra, lüj na̱j bén been xanyabaa në guidxliuj nëtëë nijsdoo con gra ni yuꞌ loj reen. ");
INSERT INTO zasNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Por xSprijt tëël gunee rey Davi diidx guie ree, chi rëbaman: ¿Chexc zeel ridxeꞌchnë ree bénguidxliuj Dios? ¿Chexc zeel rüjn reeman xgab ni ad rüjnt wen? ");
INSERT INTO zasNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Badoꞌp ree rey në gra ree guxtis din su reeman contr dux Dad ree Dios në contr Cristo. ");
INSERT INTO zasNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Abiꞌ zian ma gojc, Herodes con Poncio Pilato con ree bén Israel nëtëë ree bén ad najt bén Israel, badxajg lasaꞌ reeman luguiedx guie persi guzuj reeman contr xiꞌnl Jesús, bén naya nali, bén bacaabeel. ");
INSERT INTO zasNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Zian gojc, been reeman ziꞌc ma beenl xgab diizd gocli. ");
INSERT INTO zasNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Abiꞌ yan Dad, baguiaa yan ruchejb reeman dunujn. Gognë dunujn nayajcan xbejnl din gac yatieꞌchan xtiidxil sin guialrdxeb, ");
INSERT INTO zasNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","në con xguialrniabeel yasiajcan bénragxuu ree, yaguieen tëën milagr ree por xguialrniabee xiꞌnl Jesús, bén naya nali. ");
INSERT INTO zasNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Chi gulox gurejdx gunab reeman Dios, guzuloj canij luar lod rigaꞌ reeman, dxel guyu xSprijt Dios luxdoo gra reeman, abiꞌ guzuloj catieꞌch reeman xtiidx Dios sin guialrdxeb. ");
INSERT INTO zasNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Graczi ree bén rliladx Jesucrist bidxajg gubajn reeman, rüjn reeman tijbzi xgab, niꞌqui tijb reeman ad rëbt guial xieenzi reeman na̱j ni rajp reeman, din najn par gra reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Gognë Dios apóstoles guin ree persi basnuu be reeman diidxli guial baban Dad Jesús loj ree bengüt. Dád beenleꞌ Dios laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Niꞌczi tijb reeman ad biaadxt xhienin, din graczi ree bén rajp guidxliuj o bén rajp yu ya rutoꞌ reeman laan, abiꞌ milia guin ");
INSERT INTO zasNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","rayü reeman loj ree apóstoles guin, persi laa reeman rguiꞌs laan loj gra reeman ziꞌctzi na̱j ni riaadx tijb gaj reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Loj reeman noꞌch tijb bén brii laj Xiëb, najman xdiaa bén brii laj Leví, zëëdaman yuj la Chipre ni rigaꞌ loj nijsdoo. Gunee ree apóstoles guin laaman Bernabé, rën guiëban Bén raguꞌ luxdoo ree bejn zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Gojpaman tijb guidxliuj, abiꞌ batoꞌman laan persi badëëman milia guin loj ree apóstoles guin din quiꞌs reeman laan. ");
INSERT INTO zasNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Per guyu stijb bén brii laj Ananías, xbéngunaaman brii laj Safira. Batoꞌ tijb xguidxliuj reeman, ");
INSERT INTO zasNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","per bayaꞌnnë xbéngunaaman diidx persi bayaꞌnnëman taꞌn milia guin. Staꞌnan badëëman loj ree apóstoles guin, rëbaman laan na̱j gran. ");
INSERT INTO zasNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Abiꞌ rëb Bëd lojman: ―Ananías, ¿chexc zeel cwëjbil gunabee xindxab lüj? ¿Chexc zeel guyënl nusquieel loj xSprijt Dios, din nayaꞌnnël taꞌn milia ni batoꞌ xguidxliujl? ");
INSERT INTO zasNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Wen nid xguidxliujl gojcan ya? Abiꞌ chi batoꞌlan, ¿nid xmilialan ya? ¿Chexc zeel balabladxil beenl zian? Loj Diosan nuyënl nusquieel, ad lojt bejnan. ");
INSERT INTO zasNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Chi biguiejn Ananías ni rëbaman, biajbaman abiꞌ güjtaman. Graczi ree bén gogbee ni guzacaman dád bidxeb reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Dxel bibig bëlzi ree xinguiag, batüüb reex laaman lajd persi biquieꞌch reex laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Chi gudëd cost choon hor, dxel bidxin xbéngunaa Ananías, ad ragbeetaman ni goc. ");
INSERT INTO zasNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Dxel gunabdiidx Bëd lojman rëbaman: ―Guna, ¿batoꞌ xguidxliujdi ziꞌc na lacheelil ya? Abiꞌ rëbaman: ―An, zianqui batoꞌnan. ");
INSERT INTO zasNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Dxel rëb Bëd lojman: ―¿Chexc zeel bayaꞌndi diidx persi nuyëndi nusquieedi xSprijt Dios? Laa ree xin biquieꞌch lacheelil ziaad ni, yan nëgajc lüj chiquieꞌch reex. ");
INSERT INTO zasNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Loj hor zii gajc biajb Safira lod zaꞌ Bëd, abiꞌ güjtaman. Chi bayu ree xin guin baguiaa reex ma güjtaman, dxel bales reex laaman biquieꞌch reex laaman cwëꞌ lacheelaman. ");
INSERT INTO zasNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Graczi ree bén rliladx Jesucrist në gra ree bén gogbee ni goc, dád bidxeb reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Zien ree milagr naroob been ree apóstoles guin loj ree bejn. Graczi ree bén rliladx Jesucrist radxajg lasaꞌ roꞌ curdur lod rniee reeman xcurdur Salomón. ");
INSERT INTO zasNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Zagdxe ruzaꞌt ree bén luguiedx guin laa reeman, per ad rayaxt reeman guchajg reeman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Abiꞌ guixie guixie cayajcxhiej ree bén rliladx Dad Jesús, ziꞌc xinguiaaw ziꞌc béngunaa. ");
INSERT INTO zasNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Xt rbëë reeman bénragxuu ree lunejz, rguijxh reeman laa reeman loj ree loon në loj ree da, din chi tëd Bëd, majsi xbalazaman tëd guijc reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Në ree bén zojb guiedx rigaꞌ ree gajxh Jerusalén, zien reeman bidxin Jerusalén, bidxinnë reeman bénragxuu ree në ree bén yuꞌ xindxab luxdoo, abiꞌ graczi reeman bayajc. ");
INSERT INTO zasNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Bixhioz mazri zojbloj rniabee graczi ree bixhioz në ree bénsaducew zaꞌnë laaman, guyu guialnadëdloj luxdoo reeman, ");
INSERT INTO zasNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","abiꞌ gunabee reeman biniaaz ree apóstoles guin persi badxeꞌ reeman laa reeman ladxguiib. ");
INSERT INTO zasNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Per guxhin zii tijb xi anjl Dios guxhal roꞌ ree xport ladxguiib guin, abiꞌ babëëman laa reeman, rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Gol chej lën yadooroꞌ, gol biguiedx loj ree bejn xhie naag gap reeman guialnaban tiblayaa con Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Chi biguiejn reeman ni rëb anjl guin, bareguiaal rsildoo wej reeman lën yadoo guin, guzuloj culüü reeman bejn ree xtiidx Dios. Guiáad bixhioz zojbloj guin con ree bén zaꞌnë laaman, batoꞌp reeman guxtis con gra ree bengol Israel. Abiꞌ gunabee reeman suldad ree din chicaꞌ reex apóstoles guin ree lën ladxguiib guin. ");
INSERT INTO zasNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Per chi bidxin reex roꞌ ladxguiib guin, achutri ree apóstoles guin ree yuꞌ. Dxel bicojn reex guxtis guin ree, ");
INSERT INTO zasNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","rëb reex: ―Chi badxinan, baguiaan nayaaw roꞌ ladxguiib guin zagdxe, laa ree suldad rajp roꞌ ladxguiib guin zaꞌ, per chi baxhalan, achutczi yuꞌ lënan. ");
INSERT INTO zasNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Dxel bixhioz zojbloj guin con suldad rniabee ree suldad rniaj roꞌ yadoo guin, con ree bixhioz rniabee ree bixhioz, chi biguiejn reeman zian, guzuloj rëb loj lasaꞌ reeman, ¿ban xt guin chigdiblagaa ree ni guie? ");
INSERT INTO zasNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Loj hor zii gajc bidxin tijb xin rëb loj reeman: ―Laa ree bén badxeꞌdi ladxguiib yuꞌ lën yadoo culüü reeman bejn ree. ");
INSERT INTO zasNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Dxel wej suldad rniabee guin con ree xsuldadix bicaꞌ reex apóstoles guin ree, per ad beennaat reex laa reeman guial rdxeb reex gucaaguiaj ree bejn laa reex. ");
INSERT INTO zasNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Chi badxinnë reex laa reeman, bayü reex laa reeman loj guxtis. Dxel rëb bixhioz zojbloj guin loj reeman: ");
INSERT INTO zasNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―¿Nid ranan ya guial ad zajctri gulüüdi bejn ree xtiidx Jesús? Abiꞌ yan graczi loj ree bén Jerusalén ma gutieꞌchidi xtiidxix, nëtëë yan rëndi gudxiibidi du guijcan guial dunujn bagüjt laax. ");
INSERT INTO zasNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Abiꞌ badxiꞌ Bëdan në gra ree apóstoles guin, rëb reeman: ―Rayal yazooban xtiidx Dios luar yazooban xtiidx ree bénguidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","XDios dux béngulal ree basban Jesús, bén bacaadi loj crüjz. ");
INSERT INTO zasNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Abiꞌ nüjn Dios laaman bén zojbloj, nabeꞌcaman laaman xladbeeman, laaman na̱j bén rniabee rabëë tëëman bejn ree loj xtol reeman, abiꞌ zian guxhalaman nejz par ree bén Israel din cwëëladx xtol reeman yadxiꞌ tëë loj reeman loj Dios din güünman laa reeman perdon. ");
INSERT INTO zasNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Dunujn në xSprijt Dios bén rudëëman loj ree bén ruzoob xtiidxaman, rayagbeen guial gra ree ni guin na̱j diidxli. ");
INSERT INTO zasNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Chi biguiejn ree guxtis guin ni rëb reeman, dád balen reeman abiꞌ guyën reeman nugüjt reeman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Per loj ree guxtis guin noꞌch tijb bénfarisew laman Gamaliel, najman mextr rulüü ley abiꞌ graczi ree bejn rajp laaman respejt. Guzuliman abiꞌ gunabeeman barii ree apóstoles guin xchu tibrajt. ");
INSERT INTO zasNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Dxel rëbaman loj ree guxtis guin: ―Bén Israel, gol been xgab xhienin güünnëdi bén guin ree. ");
INSERT INTO zasNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Gol basaaladx, guyu tijb xin brii laj Teudas, rëbix yuꞌ chu najx abiꞌ cost tajp gayuu ree bejn binal laax. Per chi bagüjt ree bejn laax, bireꞌch gra ree bén binal laax, yagaj gulox gra ni beenx. ");
INSERT INTO zasNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Abiꞌ tëë lën ree dxej gunabee gobiarn biab ree bejn, guyu tijb xin brii laj Judas, gojquix xin Galilea, ziangajc dád zien ree bejn binal laax. Per chi bagüjt ree bejn laax, gra ree bén binal laax bireꞌch. ");
INSERT INTO zasNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Zeel rnin lojdi, ad bal chuꞌridi con ree bén guin, gol baslaa reeman. Din bal bénguidxliuj rniabee ni rüjn reeman, zadxin dxej loxan. ");
INSERT INTO zasNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Per bal por Dios cayüjn reeman ni guin ree, ad zajct gutëëdi loj ni cayüjn reeman. Gol gojp cudad ad niad chi gagbeedi contr Diosan zaꞌdi. ");
INSERT INTO zasNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Beencwent ree guxtis guin xtiidx Gamaliel, dxel gurejdx reeman apóstoles guin ree, gudijn reeman laa reeman abiꞌ rëb reeman loj reeman ad guitieꞌchri reeman xtiidx Jesús, dxel baslaa reeman laa reeman zia reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Per laa reeman dád nix yuꞌ luxdoo reeman barii reeman lod zaꞌ ree guxtis guin guial baslaa Dios guzagdiaj reeman por Jesús. ");
INSERT INTO zasNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Abiꞌ ad rucwëëzt rulüü reeman rniee tëë reeman xtiidx Jesús, gra dxejczi rulüü reeman lën yadooroꞌ Jerusalén nëtëë lidx lidx ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Lën ree dxej zii chi canuu cayajcxhiej ree bén rliladx Jesús, guzuloj cabeꞌc ree bén rniee diidx grieg xguialquia ree bén rniee diidx hebreo, rëb reeman guial gra dxejczi chi riëꞌs ni raw ree béngunaa bizëjb, taꞌndoon rtiaꞌ ree bén rniee diidx grieg guial loj ree bén rniee diidx hebreo. ");
INSERT INTO zasNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Dxel guidxibtioꞌp ree apóstoles guin batoꞌp reeman graczi ree bén rliladx Jesucrist, abiꞌ rëb reeman: ―Ad zagdxet na̱j guial yacwëëz yalüün xtiidx Dios par yadiꞌsan ni gaw ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Zeel yanan lëjt compniar raliduladx ree Jesucrist, gol gudiil entr lojdi gajdx ree bén ragbeedi naban ziꞌc rayal, bén yuꞌ xSprijt Dios luxdoo, bén yuꞌ tëë ree xquiarguiejn, din yazuj reeman güün reeman dxiin guin. ");
INSERT INTO zasNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Guiáad dunujn yasnuu yarejdx yanaaban Dios, yalüü tëën xtiidxaman. ");
INSERT INTO zasNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Graczi reeman cwëjb ni rëb reeman, abiꞌ gulej reeman bén la Esteban, laaman rliladx Jesucrist guidib luxdooman, rniabee tëë xSprijt Dios luxdooman guidiblagaa. Gulej tëë reeman Felip, Prócoro, Nicanor, Timón, Parmenas në Nicolás bén zëëd Antioquía, nëman bililadx ni rliladx ree bén Israel chi gadaman chililadx Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Dxel binë reeman laa reeman loj ree apóstoles guin, persi gurejdx gunab reeman Dios por laa reeman badxiib tëë yaa reeman guijc reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Canuu careꞌch xtiidx Dios, abiꞌ Jerusalén cayajcxhiej ree bén rliladx Jesucrist, në zien ree bixhioz Israel bililadx laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Dád gognë Dios Esteban badëë tëëman guialrniabee persi rüjnman zien loj milagr delant loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Abiꞌ bëlzi ree bén yadoo ni la Libertados në ree bén Cirene con ree bén Alejandría con ree bén niz Cilicia nëtëë ree bén zëëd niz Asia, guzuloj cadildiidxnë reeman Esteban, ");
INSERT INTO zasNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","per ad gojct nadxiꞌ reeman xtiidxaman guial cayagnë xSprijt Dios laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Dxel gudijx reeman bëlzi ree bejn din guiëb reeman, bacaagdiajg reeman rniee Esteban contr Dios në contr Moisejs. ");
INSERT INTO zasNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Zian been reeman persi bidxeꞌch ree bén luguiedx guin, në ree bengol në ree mextr rulüü ley. Dxel gunaaz reeman Esteban, binë reeman laaman loj guxtis. ");
INSERT INTO zasNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Gudiil tëë reeman bén basquiee ree persi rëb reeman loj ree guxtis guin: ―Ad rucwëëzt rnieeguijdx xin guie xley Moisejs në xyadoo Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Dunujn ma bacaagdiajg rëbix guial Jesús xin Nazaret guseꞌnx dux yadooroꞌ ree, guchaa tëëx costumbr basaꞌn Moisejs du loj ree. ");
INSERT INTO zasNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Abiꞌ guxtis guin ree në gra ree bén rigaꞌ yagaj, chi baguiaa reeman loj Esteban, baguiaa reeman najn ziꞌc tijb loj anjl. ");
INSERT INTO zasNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Dxel bixhioz mazri zojbloj rniabee graczi ree bixhioz, gunabdiidxaman loj Esteban, rëbaman: ―¿Walin ya rëbil zian? ");
INSERT INTO zasNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Badxiꞌ Esteban laan, rëbaman: ―Dad guxtis, në lëjt compniar, gol bacaagdiajg ni ganin. Dios bén yuꞌ xanyabaa balüüloj loj dux béngulal ree Abraham, chi gureman niz Mesopotamia chi gadaman chisob guiedx Harán. ");
INSERT INTO zasNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Abiꞌ rëb Dios lojman: “Basaꞌn ladxil në gra ree lasaꞌl, wej loj yuj ni gulün lüj.” ");
INSERT INTO zasNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Dxel brii Abraham ladx ree bén Caldea bisobaman Harán. Chi güt xDadaman, dxel bidnë Dios Abraham loj guidxliuj guie lod nadxuꞌ ree yan. ");
INSERT INTO zasNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Per chi biꞌt Abraham guie, achetczi guidxliuj badëëd Dios lojman, niꞌczi tibdaꞌnan ad badëëtaman. Per beenman promejs loj Abraham guial gudëëman guidxliuj guie lojman, dxel chi guiëtaman tiaꞌ ree xdiaaman laan, majsi chi rëb Dios zian, ad wayut xiꞌn Abraham. ");
INSERT INTO zasNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Rëb tëë Dios lojman guial xdiaaman chisob ziꞌc ree benzit nacion ren, lod gugüjn daꞌt reeman laa reeman dxiin gusagzi tëë reeman laa reeman loj tajp gayuu ijz. ");
INSERT INTO zasNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Per rëb tëë Dios lojman: “Gudëdan gra ree bén gusagzi laa reeman casti, gac xchej yarii reeman yagaj abiꞌ guie güün reeman sirv lon ziꞌc rayal.” ");
INSERT INTO zasNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Chi guneenë Dios Abraham, bayaꞌn reeman diidx guial rayal chuꞌ gra ree xinguiaaw sen. Zeel chi gol Isaac xiꞌn Abraham, gojc xhujn dxej, dxel badxeꞌman laax sen. Ziangajc beennë Isaac xiꞌnman Jacob, ziangajc beennë Jacob guidxiptioꞌp ree xiꞌnman, bén goc ree dux béngulal ree. ");
INSERT INTO zasNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Bén goc ree dux béngulal ree gudëdloj reeman Xiëb bén na̱j bijch reeman, abiꞌ batoꞌ reeman laaman loj ree bén zë Egipto, per ad guroꞌnladxt Dios laaman, ");
INSERT INTO zasNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","gognëman laaman loj ni guzagdiajman badëë tëëman xquiarguiejnman, gognë tëëman laaman persi biajb rey guin laaman zagdxe, abiꞌ beenman laaman gobernador Egipto, bazuj tëëman laaman din nabeeman gra ni rajp rey guin. ");
INSERT INTO zasNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Chi guyu gubijn guidibczi Egipto në niz Canaán, dxel guzagdiaj daꞌt ree dux béngulal ree guial achet ni gaw reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Per chi gogbee Jacob guial yuꞌ trigo Egipto, guxhaal ree xiꞌnman bén na̱j dux béngulal ree, dxel wej reeman Egipto. ");
INSERT INTO zasNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Chi barojp volt wej reeman, rëb Xiëb guial laaman na̱j bijch reeman, dxel gogbee rey Egipto xhie diaa zëëdaman. ");
INSERT INTO zasNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Dxel rëb Xiëb loj ree bijchaman din chigxii reeman xDadaman në gra ree lasaꞌman din chisob reeman Egipto. Gojc reeman gayojnchiin bejn. ");
INSERT INTO zasNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Zianan zeel bisob Jacob Egipto, ni gütaman ni gajc güt ree xiꞌnman, dux béngulal ree. ");
INSERT INTO zasNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Gojc xchej dxel bignë reeman xdxijt ree dux béngulal ree guiedx Siquem, persi biguieꞌch reen lën baa guzii Abraham loj ree xiꞌn Hamor. ");
INSERT INTO zasNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Chi ma zidyob tiamp gac ni rëb Dios loj Abraham, zien ree bén Israel ma gojcxhiej Egipto. ");
INSERT INTO zasNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Abiꞌ guzuloj gunabee rey ren Egipto, bén ad beenbeet Xiëb. ");
INSERT INTO zasNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Rey zii basagzi bén du ladx ree, gunabeeman chigsëëb reeman xindo niguiaaw golnejz ree din guiët reex. ");
INSERT INTO zasNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Abiꞌ tiamp zii gojl Moisejs, tijb xindo bayuladx Dios. Gunaj ree xdadix laax choon bëëw. ");
INSERT INTO zasNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Chi bidxin dxej bigsaꞌn reeman laax lod bigsëëb reeman laax, xiꞌn gajc rey guin bacaꞌ laax, persi baslaaman laax ziꞌc xiꞌnman. ");
INSERT INTO zasNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Basiid Moisejs gra ni rajc ree bén Egipto, abiꞌ lasajc ni guneex ni been tëëx. ");
INSERT INTO zasNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Chi guyu Moisejs tiuu ijz, bidyajb guijcaman bignaj lasaꞌ bén Israelaman. ");
INSERT INTO zasNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Abiꞌ chi baguiaaman caguin tijb bén Egipto tijb bén Israel, balajman laaman, bagüjtaman bén Egipto guin. ");
INSERT INTO zasNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Naladx Moisejs niagbee ree bén Israel guial por laaman yabëë Dios laa reeman loj ree bén Egipto, per ad gogbeet reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Chi bareguiaal, bidxaagloj Moisejs tioꞌp ree bén Israel cagaꞌp reeman, abiꞌ guyënman nabeꞌcdxeman laa reeman, rëbaman: “¿Chexc zeel rdilidi? Awa bén Israel na̱j gropidi.” ");
INSERT INTO zasNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Abiꞌ bén caguin bén zatijb guin bacadxaaman Moisejs, rëbaman: “¿Chu bazuj lüj din nabeel dunujn, din na tëël ni rayal yaguieenan? ");
INSERT INTO zasNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Wen rënl ya gugüjtil naj ziꞌc bagüjtil bén Egipto ni nieey?” ");
INSERT INTO zasNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Chi biguiejn Moisejs ni rëb bén guin, baxüünman wejman niz Madián. Ni gureman ziꞌc benzit, abiꞌ cwaꞌman béngunaa, zianz guyu tioꞌp ree xiꞌngaanman. ");
INSERT INTO zasNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Chi gudëd tiuu ijz, dxel balüüloj tijb xi anjl Dios loj Moisejs loj xbajl tijb yag ni cayazbajl lod na̱j yujbidx, gajxh guiaꞌ la Sinaí. ");
INSERT INTO zasNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Dád badxa loj Moisejs guial baguiaaman bajl guin. Abiꞌ chi bibigaman din guguiaaman laan mazri zagdxe, biguiejnman chaꞌ Dios rëbaman lojman: ");
INSERT INTO zasNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Naj na̱j xDios xbéngulal reel, Abraham, Isaac në Jacob.” Dxel guzuloj canij Moisejs guial bidxebaman, ad bayaxtaman nuguiaaman bajl guin. ");
INSERT INTO zasNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Dxel rëb Dios lojman: “Gulëë xgurëchil, din nagleꞌ lod zaꞌl. ");
INSERT INTO zasNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Naj cuguia xhienaag cazagdiaj ree da bejnan Egipto, riguiejnan roon reeman zeel biguiaꞌtan din yabën laa reeman. Yan, guda din gaxhalan lüj Egipto.” ");
INSERT INTO zasNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Abiꞌ majsi ad guyënt ree bén Israel nuzoob reeman xtiidx Moisejs yaloj, rëb reeman lojman: “¿Chu bazuj lüj din nabeel dunujn na tëël ni yaguieenan?” Per por anjl balüüloj loj bajl guin, badëëd Dios guialrniabee lojman, abiꞌ guxhaalaman laaman din güünman laa reeman yudar yarii reeman Egipto, ziꞌc rëb anjl balüüloj lojman loj yag cayeꞌc. ");
INSERT INTO zasNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisejs guin na̱j bén babëë dux béngulal ree Egipto, been tëëman milagr ree niz Egipto, në niz roꞌ nijsdoo ni la Nijs Xnia, në loj yujbidx lod guzu reeman tiuu ijz. ");
INSERT INTO zasNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Laagajc tëëman rëb loj ree bén Israel: “Loj gajquidi cwe Dios tijb bén gudëëd xtiidxaman loj ree bejn ziꞌc guleman naj. Gol bazoob xtiidxaman.” ");
INSERT INTO zasNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Dxel chi guzunë Moisejs dux béngulal ree niz loj yujbidx, laaman na̱j bén guneenë xi anjl Dios ruguiaꞌ la Sinaí, persi badëëman xtiidx Dios loj reeman, abiꞌ diidx guin ree na̱j ni basaꞌn reeman duloj ree yan. ");
INSERT INTO zasNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Per dux béngulal ree ad bazoobt reeman xtiidx Moisejs. Ad guyënt reeman niniabeeman laa reeman, tib guyuguijczi reeman nayejc reeman Egipto. ");
INSERT INTO zasNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Dxel rëb reeman loj Aarón: “Been dios ree, din ned reeman du loj ree, din ad rayagbeet ree gonczi Moisejs bén babëë dunuj ree Egipto.” ");
INSERT INTO zasNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Dxel been reeman tijb goꞌndobëz din gaquib xdios reeman. Bagüjt reeman be ree persi badëëd reeman laa reeb ziꞌc gon loj ni been reeman, been reeman lanij guial babaanë reeman ni been gajc reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Dxel guroꞌnladx Dios laa reeman, baslaaman guyën reeman gubijdx con bëëw con bajl yuꞌ ree xanyabaa. Din zian ca loj xtiidx Dios ni bacaa ree bén badëëd xtiidxaman loj ree bejn, lod rëb: Bén Israel, loj tiuu ijz ni guzudi loj yujbidx, ¿wen bagüjtidi be ree ya din guneedi laa reeb lon ziꞌc gon? ");
INSERT INTO zasNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Per mazri guyëndi xdxandi Moloc biaa tëëdi lidxan, në xbajl dxan Refán, dxan been gajquidi din guzuxibidi loj reen. Zeel gaxhalan lëjt mazri zijt guial Babilonia. ");
INSERT INTO zasNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Abiꞌ chi guzu ree dux béngulal ree loj yujbidx, gojp reeman tijb yu been laa reeman sirv ziꞌc yadoo, lod guyuchaaw ree guiaj ni ca xley Dios. Been reeman yadoo guin ziꞌc gunabee Dios Moisejs, chi rëbaman lojman guial güünman laan ziꞌc ma baguiaaman. ");
INSERT INTO zasNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Chi güt Moisejs, bayaꞌnnë ree dux béngulal ree yadoo guin. Chi bayaꞌn Josué xluar Moisejs, dxel bidnë reeman yadoo guin chi gudil reeman guijc guidxliuj con ree bén ren, abiꞌ gognë Dios laa reeman persi been reeman gan bayaꞌnnë reeman guidxliuj guin ree. Zian guzunë reeman yadoo guin xt bidxin dxej guzuloj gunabee rey Davi. ");
INSERT INTO zasNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Guyën Dios rey Davi, abiꞌ laaman guyënman nüjnman tijb yadoo par Dios, bén na̱j dux Dios ree nayajc ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Per rey Salomón na̱j bén been laan, ");
INSERT INTO zasNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","majsi Dios bén yuꞌ xanyabaa ad rbejtaman lën yadoo ni rüjn ree bejn, ziꞌc rëb bén badëëd xtiidx Dios loj ree bejn diizd gocli, chi rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","Xanyabaa na̱j lod zooban par ganabeen, guiáad loj guidxliuj na̱j lod ruzu guiaꞌn. ¿Xhienaag gac yu güündi par naj? ¿O xhienaag na̱j lod yaziiladxan? ¿Id naj ben graczi ree ni guie ya?, rëb Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Per lëjt ―rëb Esteban ―dád nadidi, ad rëntidi guzoobidi xtiidx Dios, ad rën tëëtidi chigniaꞌdi, zianczi zaꞌdi contr xSprijt Dios, ziꞌcgajc been ree xbéngulalidi. ");
INSERT INTO zasNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Chu bén badëëd xtiidx Dios loj ree bejn ad beennaat ree xbéngulalidi? Xt bagüjt reeman bén badëëd ree xtiidx Dios bén rëb ree guial guiꞌt tijb bén naya nali. Abiꞌ yan ma biꞌtaman, bayüdi laaman loj ree bén rniabee, gunabee tëëdi güjtaman. ");
INSERT INTO zasNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Majsi cwaꞌdi xley Dios loj ree xi anjlaman, per ad rüjntidi ziꞌc rëb loj ley guin. ");
INSERT INTO zasNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Chi biguiejn reeman ni rëb Esteban, xt raw lay reeman tant balen reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Per guial yuꞌ xSprijt Dios luxdoo Esteban, chi gules lojman xanyabaa, dxel baguiaaman xbiani Dios baguiaa tëëman Jesús zaꞌman xladbee Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Dxel rëb Esteban: ―¡Gol baguiaa! Ruguian naxal xanyabaa, ruguia tëën Bén guxhaal Dios zaꞌman xladbee Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Per chi biguiejn reeman zian, bataꞌcw guidiajg reeman, dxel gurixdiaj reeman zignaaz reeman Esteban, ");
INSERT INTO zasNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","babëë reeman laaman loj ciuda guin, bicüjt reeman laaman con guiaj, guiáad xab reeman basaꞌnsii reeman loj xinguiag la Saulo persi canajxan. ");
INSERT INTO zasNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Laꞌtgaj cucaaguiaj reeman Esteban, rëbaman: ―Dad Jesús, bacaꞌ da sprijtan. ");
INSERT INTO zasNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Dxel bazuxibaman guridxaꞌman rejs, rëbaman: ―Dad Jesús, ad güüncwentil dol cayüjn ree bén guin yan. Naabczi gulox rëbaman zian, laa güt gajcaman. ");
INSERT INTO zasNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Bayaꞌn Saulo conform guial bagüjt reeman Esteban. Abiꞌ dxej zii gajc guzuloj rzunal reeman bén Jerusalén ree bén rliladx ree Jesucrist, dxel bireꞌch reeman guidib niz Judea në niz Samaria, bén najzi ree apóstoles bayaꞌn. ");
INSERT INTO zasNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Guyu bëlzi ree xinzaꞌc, laa reex biquieꞌch Esteban, abiꞌ dád biin reex guijcaman. ");
INSERT INTO zasNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Guiáad Saulo rzunalaman bén rliladx ree Jesucrist, ruman yu yu din cwëë naguiejnman laa reeman, ziꞌc xinguiaaw ziꞌc béngunaa, persi rguꞌman laa reeman ladxguiib. ");
INSERT INTO zasNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Per bén brii ree Jerusalén, lod zëtzi reeman rtieꞌch reeman xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ziꞌc been Felip, wejman guiedx Samaria, guzuloj caneeman xtiidx Jesucrist loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Dád zien ree bejn rdoꞌp, graczi reeman rucaagdiajg chaaw ni rëb Felip, ruguiaa tëë reeman milagr ree ni rüjnman. ");
INSERT INTO zasNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Zien ree bén nëjt tib lajt xcuerp bayüjn Felip, në ree bén ad rzat zagdxe, bayüjn tëëman bén yuꞌ ree xindxab luxdoo abiꞌ rbixdiaj reex rarii reex. ");
INSERT INTO zasNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Zianan zeel babaa daꞌt ree bén luguiedx zii. ");
INSERT INTO zasNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Per luguiedx zii guyu tijb bén brii laj Simón, diizd gocli rüjnman guialbidxaa persi rusquieeman bén Samaria ree, rüjnman bén lasajc. ");
INSERT INTO zasNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Graczi reeman rucaagdiajg chaaw ni rëbaman, diizd mazri ree xinguiag xt mazri ree bengol, abiꞌ rëb reeman: ―Naroob na̱j xguialrniabee Dios ni rajp bén guie. ");
INSERT INTO zasNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bidxgaꞌ reeman laaman guial ma gojc xchej cusquieeman laa reeman con guialbidxaa ni rüjnman. ");
INSERT INTO zasNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Per chi bililadx reeman ni rëb Felip xcwent xguialrniabee Dios në xcwent Jesucrist, ziꞌc ree xinguiaaw ziꞌc ree béngunaa gurobnijs reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Xt në Simón bililadx gurobnijs tëëman, abiꞌ ad riroꞌnladxtaman Felip radxa tëë lojman graloj ree milagr ruguiaaman rüjn Felip. ");
INSERT INTO zasNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Chi gogbee ree apóstoles rigaꞌ Jerusalén guial ma bililadx ree bén Samaria xtiidx Dios, dxel guxhaal reeman Bëd con Waj ni. ");
INSERT INTO zasNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Chi bidxin reeman, gurejdx gunab reeman Dios por ree bén Samaria bén ma rliladx ree xtiidx Dios din chuꞌ xSprijt Dios luxdoo reeman, ");
INSERT INTO zasNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","din niꞌqui tijb reeman ad wayut Sprijt guin luxdoo, gurobnijsi reeman por Dad Jesús. ");
INSERT INTO zasNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Dxel guxhoob yaa ree Bëd con Waj guijc reeman, abiꞌ guyu xSprijt Dios luxdoo reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Chi baguiaa Simón cayu xSprijt Dios luxdoo ree bén guin guial caxhoob yaa ree apóstoles guin guijc reeman, dxel guyënman nudëëman milia loj reeman, ");
INSERT INTO zasNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","rëbaman: ―Në lon gol banee guialrniabee guin din chi gaxhob yan chutëëz guijc bénan, në luxdooman chuꞌ xSprijt Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Dxel badxiꞌ Bëd xtiidxaman rëbaman: ―Nitil con guidib xmilial, din rüjnl xgab guial zajc siil guialrniabee razaladx Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ad rayalt ad zajc tëët güünl ziꞌc raguieenan, din niꞌquid zinaltil xnejz Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Bayüjn xgab por ni mal beenl, gurejdx gunab tëë Dios, rupent güünman lüj perdon por ree xixgabmalil, ");
INSERT INTO zasNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","din ragbeen ganax guialralen yuꞌ luxdool, abiꞌ dol guin na̱j ni rniabee lüj. ");
INSERT INTO zasNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Dxel badxiꞌ Simón xtiidxaman, rëbaman: ―Gol gurejdx gunab Dios por naj, chitëë gazaꞌcan niꞌqui tijb ni ma nadi. ");
INSERT INTO zasNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Chi gulox gunee ree apóstoles guin xtiidx Dios loj ree bén guin, dxel badxin reeman Jerusalén, abiꞌ graczi ree guiedx rigaꞌ niz Samaria lod gudëd reeman gutieꞌch reeman xtiidxzaꞌc Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Chi ma gudëd gojc zian, gunee tijb xi anjl Dios Felip rëbaman: ―Wej niz sur nejz ni zë Jerusalén xt lod la Gaza, niz lod na̱j ganax yujbidx. ");
INSERT INTO zasNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Dxel brii Felip zëman. Runejz guin banaazaman tijb bén Etiopía, najman bén zojbloj guial laaman rguꞌchaaw xmilia Candace, bén na̱j reina Etiopía. Wejman Jerusalén bignajchiꞌman Dios, ");
INSERT INTO zasNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","abiꞌ ma bayunejzaman zia ladxaman, zojb lën xcarrejt zagdxeman, roolaman loj guiꞌch ni bacaa Isaías, bén badëëd xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Dxel rëb xSprijt Dios loj Felip: ―Bibig gajxh cwëꞌ carrejt guin. ");
INSERT INTO zasNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Chi bibigaman, biguiejnman cayool bén guin loj guiꞌch bacaa Isaías. Dxel gunabdiidxaman lojman rëbaman: ―Dad, ¿rigniaꞌl ni cayoolil ya? ");
INSERT INTO zasNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Badxiꞌ bén guinan rëbaman: ―¿Xoza chigniaꞌnan? Awa achut gusigniaꞌ naj. Dxel rëbaman loj Felip din chëꞌpaman loj carrejt guin, cweman cwëꞌman. ");
INSERT INTO zasNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Loj xtiidx Dios lod cayool bén guin rëban: Ziꞌc rinë reeman tijb xiil, binë reeman laaman lod gugüjt reeman laaman. Abiꞌ achet rëbaman, ziꞌc tijb xiil ma zaꞌ loj ree bén gugaj guidxladib. ");
INSERT INTO zasNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Chi beennë reeman laaman ziꞌctzi rën reeman, achut been guialguxtis por laaman. Yan achut guzaꞌt xdiaaman, din ma bisüd reeman laaman loj guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Rëb bén guin loj Felip: ―Guna sii, ¿chu xcwent rniee bén bacaa diidx guie ree? ¿Xcwent gajcaman ya o xcwent ben renan? ");
INSERT INTO zasNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Dxel guzuloj Felip cusigniaꞌman laaman xtiidx Dios ni cayoolaman, zian beman xtiidxzaꞌc Jesucrist lojman. ");
INSERT INTO zasNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Abiꞌ chi gudëd reeman lod yuꞌ nijs, dxel rëb bén guin loj Felip: ―Guie yuꞌ nijs. ¿Nid zajc garobnijsan guie ya? ");
INSERT INTO zasNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Zeel rëb Felip lojman: ―Bal rliladxil guidib luxdool, zajcan. Badxiꞌ bén guinan rëbaman: ―Rliladxan guial Jesucrist na̱j Xiꞌn Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Dxel gunabeeman guzudxe xcarrejtaman. Abiꞌ baguiajt grop reeman, dxel guyu reeman lojnijs guin persi baroobnijs Felip laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Chi barii reeman lojnijs guin, loj hor zii gajc gunidloj Felip binë xSprijt Dios laaman, abiꞌ ad baguiaatri bén guin laaman, per dád rabaaman zinal xnejzaman. ");
INSERT INTO zasNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Chi gogbee Felip, ma zaꞌman xt guiedx Azoto, dxel zëman guiedx guiedx zigtieꞌchaman xtiidxzaꞌc Jesucrist xt bidxinman Cesarea. ");
INSERT INTO zasNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Guiáad Saulo ad rucwëëzt rdxeꞌchaman bén rliladx ree Jesucrist, rëbaman gugüjtaman laa reeman. Zeel wejman bigneenëman bixhioz mazri zojbloj rniabee graczi ree bixhioz, ");
INSERT INTO zasNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","din gac tijb guiꞌch din gac cheman lën ree yadoo Damasco chigdiilaman bén rliladx ree Jesucrist, ziꞌc ree xinguiaaw ziꞌc ree béngunaa, din chignëman laa reeman ladxguiib Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Per chi ma cadxinman gajxh guiedx Damasco, dxejlczi brii tijb guij xanyabaa balaan bachaꞌ lod zëman. ");
INSERT INTO zasNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Abiꞌ bireeyujman, chi nagaꞌman luyuj guin biguiejnman chaꞌ bén rëb: ―Saulo, Saulo, ¿chexc zeel rzunalil naj? ");
INSERT INTO zasNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Abiꞌ gunabdiidxaman rëbaman: ―¿Chu lüj, Dad? Badxiꞌman laan rëbaman: ―Naj na̱j Jesús bén rzunalil. Per ganin lüj, lüj gajc rguiil xguialnaal ziꞌc rüjn tijb goꞌn rudxeguiaꞌ loj yag ni rulaagnë reeman laab. ");
INSERT INTO zasNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Rnij Saulo guial tant bidxebaman, abiꞌ rëbaman: ―Dad, ¿xhie rënl günan? Dxel rëb Dad Jesucrist lojman: ―Bixche, wej guiedx Damasco, ni na reeman ni rayal güünl. ");
INSERT INTO zasNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Abiꞌ ree bén në Saulo dád bidxeb reeman guial biguiejn reeman chaꞌ bejn, per achutczi baguiaa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Chi bixcheman luyuj guin, baxhal lojman, ad rajctri ruguiaaman. Dxel gunaaz reeman yaaman bignë reeman laaman Damasco. ");
INSERT INTO zasNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ni guzuman choon dxej, ad rajct ruguiaaman, achetczi rawaman ache tëëtczi rëꞌman. ");
INSERT INTO zasNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasco gure tijb bén rliladx Dad Jesucrist, brii lajman Ananías. Balüüloj Jesucrist lojman, rëbaman: ―¡Ananías! Badxiꞌman laan rëbaman: ―Laa naj guie Dad. ");
INSERT INTO zasNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Dxel rëb Jesucrist lojman: ―Bisu, wej call ni la nali. Chi guidxinl lidx Judas, gunabdiidx por tijb xin zëëd Tarso, lax Saulo. Din laax cabejdx canab naj, ");
INSERT INTO zasNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","abiꞌ ziꞌc rulüü caneꞌxhchaalix, baguiaax guyu tijb bén la Ananías guxhoob yaaman guijquix persi baguiaax stijb. ");
INSERT INTO zasNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Chi biguien Ananías zian, dxel rëbaman: ―Dad, zien daꞌt ree bejn ruzaꞌt xin zii, në ree ni mal rüjnnëx bén rliladx ree lüj Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Yan zëëdix guie con xguialrniabee ree bixhioz rniabee ree bixhioz, din guiniaazix gra ree bén rliladx lüj. ");
INSERT INTO zasNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Dxel rëb Jesucrist lojman: ―Wej, din naj gule laax din chiguiex da diidxan loj ree bén ad najt bén Israel, në loj ree rey, con nëgajc loj ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Guiën lojx guial sagdiaj daꞌtix guial najx da bejnan. ");
INSERT INTO zasNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Dxel zë Ananías lënü lod zaꞌ Saulo. Chi guyuman, guxhoob yaaman guijcaman, rëbaman: ―Bijch Saulo, Dad Jesús bén balüüloj lojl runejz lod zëëdil, laaman guxhaal naj din yaguiaal, chuꞌ tëë xSprijt Dios luxdool. ");
INSERT INTO zasNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Loj hor gajc ziꞌc rulüü yuꞌ xhie biquied guiaalojman abiꞌ baguiaaman stijb. Dxel guzuliman gurobnijsaman, ");
INSERT INTO zasNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","gudaw tëëman persi bayuman gojl. Dxel guzujman Damasco tioꞌp choon dxej con ree bén rliladx Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Dxel guzuloj gunee Saulo xtiidx Dios lën ree yadoo, rëbaman guial Jesucrist na̱j Xiꞌn Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Graczi ree bén biguien ni rëbaman badxa loj reeman abiꞌ rëb reeman: ―¿Nid bén guien rzunal bén rliladx ree Jesucrist Jerusalén ya? ¿Nid laagajcaman zëëd guie ya, din guiniaazaman bén rliladx ree Jesucrist chignë tëëman laa reeman loj ree bixhioz rniabee ree bixhioz? ");
INSERT INTO zasNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Per Saulo guixie guixie mazri cariiman guialrdxeb rnieeman xtiidx Dios, rulüüman guial Jesús na̱j Cristo, din yabëëman bejn ree loj dol. Xt ragdxa ree bén Israel zojb ree Damasco chi rucaagdiajg reeman ni rëbaman. ");
INSERT INTO zasNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ad xchejt gojc, bayaꞌn ree bén Israel diidx din nugüjt reeman Saulo, ");
INSERT INTO zasNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","per laa gogbee gajcaman ni rën reeman güün reeman. Dxej guiaal rbëz reeman laaman roꞌ ree port ni rarii roꞌ ciuda guin din nugüjt reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Per ree bén rliladx Jesucrist, guxhin badxeꞌ reeman laaman lën dxüm naroob, abiꞌ gulet reeman laaman niz xijch zeꞌ nusiaaw ciuda guin, zian baxüünman Damasco. ");
INSERT INTO zasNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Chi badxin Saulo Jerusalén, guyënman nuchajgaman bén rliladx ree Jesucrist, per graczi reeman bidxeb laaman guial ad rliladxt reeman nëman ma rliladx Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Dxel binë Bernabé laaman loj ree apóstoles guin, bagojnman guial baguiaa Saulo dux Dad ree Jesucrist, guneenë tëëman laaman chi zëman Damasco, bagojn tëëman guial Damasco gunee Saulo xtiidx Jesucrist sin guialrdxeb. ");
INSERT INTO zasNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Zian bayaꞌn Saulo Jerusalén abiꞌ nayuman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ad rdxebtaman ruzaꞌtaman Dad Jesús, abiꞌ xt gudijldiidxnëman bén Israel rniee ree diidx grieg, per guyën reeman nugüjt reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Chi gogbee ree bén rliladx Jesucrist zian, binë reeman laaman guiedx Cesarea. Yagaj baxhaal reeman laaman guiedx Tarso. ");
INSERT INTO zasNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Dxel babedxe luxdoo ree bén rliladx Jesucrist, bén zojb ree niz Judea në niz Galilea nëtëë niz Samaria, chigagaj beenbee reeman mazri xhienaag na̱j xnejz Dios, bazoob tëë reeman xtiidxaman, abiꞌ cayagnë xSprijt Dios cayajcxhiej reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Chi biza Bëd bitixlojman bén rliladx ree Jesucrist, dxel wej gajcaman bitixlojman bén rliladx ree Jesucrist guiedx Lida. ");
INSERT INTO zasNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ni bidxaaglojman tijb xinguiaaw la Eneas. Ma gojc xhujn ijz nagaꞌx, ragxuux, ad rajct rzax. ");
INSERT INTO zasNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Abiꞌ rëb Bëd lojx: ―Eneas, ma bayüjn Jesucrist lüj. Bixche, bales ni goꞌtil loj. Loj hor zii gajc bixchex. ");
INSERT INTO zasNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Chi baguiaa gra ree bén zojb guiedx Lida në ree bén zojb niz Sarón guial ma bayajc Eneas, dxel në reeman bililadx Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Loj tiamp zii guyu tijb béngunaa rliladx Jesucrist luguiedx Jope, laman Tabita, diidx grieg laman Dorcas. Laaman been ni zaꞌc ree, been tëëman yudar bénprob ree. ");
INSERT INTO zasNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Lën ree dxej zii gogxuu Dorcas abiꞌ güjtaman. Chi gulox bagajz reeman laaman, dxel bitixh reeman laaman lënü ladya. ");
INSERT INTO zasNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Abiꞌ gajxh guiedx Jope rayaꞌn guiedx Lida lod zaꞌ Bëd. Chi gogbee ree bén rliladx Jesucrist guial zaꞌman ni, guxhaal reeman tioꞌp ree xinguiaaw bisajc reex Bëd liaadx, rëb reex: ―Been wen yoꞌ ree Jope yan gajczi. ");
INSERT INTO zasNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Laa zinë gajcaman laa reex. Chi bidxinman, binë reeman laaman lënü lod nagaꞌ xcuerp Dorcas. Ni rigaꞌ zien ree béngunaa bizëjb roon reeman, abiꞌ bibig reeman loj Bëd culüü reeman gra lajd ni been Dorcas chi sta nabanman. ");
INSERT INTO zasNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Dxel gunabee Bëd barii gra reeman, abiꞌ bazuxibaman gurejdx gunabaman Dios. Dxel baguiaaman bengüt guin, rëbaman: ―¡Tabita, bixche! Laa guxhal gajc lojman. Chi baguiaaman Bëd, gureliman, ");
INSERT INTO zasNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","dxel gunaaz Bëd yaaman persi guzuliman. Abiꞌ gurejdxaman bén rliladx ree Jesucrist con ree bén bizëjb guin, persi baguiaa reeman guial ma baban Dorcas. ");
INSERT INTO zasNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Guidibczi guiedx Jope gogbee reeman ni goc, abiꞌ zien daꞌt reeman bililadx Jesucrist por zian. ");
INSERT INTO zasNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Guiáad Bëd bayaꞌnman mazri dxej luguiedx guin, lidx Simón bén rüjnchaaw guid. ");
INSERT INTO zasNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Luguiedx Cesarea gurej tijb bén brii laj Cornel. Laaman goc suldad gunabee tibcwaa ree suldad brii laj Italiano. ");
INSERT INTO zasNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Gojcaman benzaꞌc, laaman në gra ree bén zojb lidxaman guyën reeman Dios, abiꞌ dád beenman yudar bén Israel ree, bén na̱j ree bénprob, në zianczi rbejdx rniabaman Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Tijb dxej cost raca choon wadxe, guzajcaman ziꞌc rulüü caneꞌxhchaalaman. Zagdxeczi baguiaaman guyu tijb xi anjl Dios lënü lod zaꞌman, abiꞌ rëb anjl guin lojman: ―¡Cornel! ");
INSERT INTO zasNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Baguiaaman loj anjl guin, abiꞌ dád bidxebaman, rëbaman: ―¿Xhienin, Dad? Abiꞌ rëb anjl guin: ―Ma biguiejn Dios xtiidxil ma baguiaa tëëman xhienaag rüjnl yudar bénprob ree. ");
INSERT INTO zasNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Guxhaal ree bén che luguiedx Jope din chicaꞌ reeman Simón, bén la gajc Bëd. ");
INSERT INTO zasNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Zojbaman lidx tijb bén la gajc Simón, bén rüjnchaaw guid, bén zojb gajxh roꞌ nijsdoo. Bëd guin na ni rayal güünl. ");
INSERT INTO zasNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Chi zia anjl gunee Cornel, gurejdxaman tioꞌp ree xmojsaman, zatijb suldad rajpaman confians rliladx tëëman Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Gulox beman diidx loj reeman ni guzacaman, dxel guxhaalaman laa reeman Jope. ");
INSERT INTO zasNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Chi bareguiaal, laꞌtgaj cadxin reeman gajxh Jope, cost garol dxej wëꞌp Bëd guijc yu lod zojbaman din cwedx guiniabaman Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Dád gulaanman, guyënman niajwaman, per laꞌtgaj cayüjn reeman ni gawaman guzajcaman ziꞌc rulüü caneꞌxhchaalaman. ");
INSERT INTO zasNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Baguiaaman bixal xanyabaa abiꞌ caguiajt ziꞌc tijb lajd naroob xt lod zaꞌman, naxii guidap xquinan. ");
INSERT INTO zasNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Loj lajd guin yuꞌ gra loj ree be yuꞌ tajp guiaꞌ, në ree bëël, nëtëë ree be rzuj. ");
INSERT INTO zasNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Dxel biguiejnman chaꞌ bén rëb: ―Bëd, bisu, bagüjt be gawil. ");
INSERT INTO zasNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Per badxiꞌ Bëd laan rëbaman: ―Yajqui, Dad. Ad wayawtczan nidxuudx ni ad rayalt gaw bejn. ");
INSERT INTO zasNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Abiꞌ rëb chaꞌ bén guin zatijb: ―Ni ma basia Dios ad rnieelan nidxuudx. ");
INSERT INTO zasNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Choon volt gojc zian, dxel bayëꞌp lajd guin xanyabaa stijb. ");
INSERT INTO zasNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Laꞌtgaj cayüjn Bëd xgab xhie rën guiëb ni baguiaaman, loj hor zii gajc bidxin ree bén guxhaal Cornel rulidx Simón, guial ma gunabdiidx reeman banguin na̱j lidxaman. ");
INSERT INTO zasNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Chi bidxin reeman, gunabdiidx reeman bal ni zojb Simón bén la gajc Bëd. ");
INSERT INTO zasNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Guiáad Bëd sta cayüjnman xgab ni baguiaaman, chi rëb xSprijt Dios lojman: ―Laa choon ree xinguiaaw raguiil lüj. ");
INSERT INTO zasNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Bisu, biguiajt binë reex, ad chuꞌ luxdool tioꞌp, din naj guxhal laa reex. ");
INSERT INTO zasNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Dxel baguiajt Bëd lod zaꞌ ree bén guxhaal Cornel, abiꞌ rëbaman loj reeman: ―Naj na̱j bén raguiilidi, ¿chexquiza zeel raguiilidi naj? ");
INSERT INTO zasNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Dxel badxiꞌ reeman laan rëb reeman: ―Guxhaal bén la Cornel dunujn, bén rniabee tibcwaa ree suldad, najman benzaꞌc, rdxebaman Dios, abiꞌ graczi ree bén Israel rën laaman. Tijb xi anjl Dios rëb lojman, guial rayal guixhiaalaman dunujn yudcaꞌn lüj din yoꞌ ree lidxaman, din gucaagdiajgaman ni rayal guiëbil. ");
INSERT INTO zasNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Dxel badxeꞌ Bëd laa reeman lënü, ni gudëd reeman guiaal. Chi bareguiaal, binëman laa reeman. Në bëlzi ree bén zojb Jope bén rliladx ree Jesucrist binë laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Chi bareguiaal bidxin reeman Cesarea lod zojb Cornel. Abiꞌ batoꞌp Cornel gra ree lasaꞌman në ree xmiwaman, din cwëz reeman guidxin reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Chi bidxin Bëd lidx Cornel, laa brii gajc Cornel bigchaaglojman laaman, dxel bazuxibaman loj Bëd persi gojpaman laaman respejt. ");
INSERT INTO zasNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Per bazuli Bëd laaman, rëbaman: ―Guzuli, din lasaꞌ bejn gajcan lüj. ");
INSERT INTO zasNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Laꞌtgaj cadxin reeman ruyu guin cayü reeman diidx. Abiꞌ chi guyu reeman, baguiaa Bëd zien daꞌt ree bejn rigaꞌ ni. ");
INSERT INTO zasNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Dxel rëb Bëd loj reeman: ―Ma qui ragbeedi xhienaag na̱j xley ree bén Israel, guial ad zajct goꞌch reeman loj ree bén ad najt bén Israel o chuꞌ reeman lidx reeman. Per ma balüü Dios naj guial achutczi rayal ganen bendxuudx, bén nabixhladx. ");
INSERT INTO zasNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Zeel chi bidcaꞌ reeman naj, laa bial gajcan achet guijc badxiban. Yan rënan gagbeen, ¿chexquiza zeel gurejdxidi naj? ");
INSERT INTO zasNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Badxiꞌ Cornelan rëbaman: ―Ma gojc tajp dxej cost hor guie gajc, chi zoob lidxan, raca choon wadxe, cabedx canaaban Dios, loj hor zii balüüloj tijb bejn lon najcwaman lajd nayni. ");
INSERT INTO zasNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Abiꞌ naman lon: “Cornel, ma biguiejn Dios xtiidxil, yuꞌguijc tëëman xhienaag rüjnl yudar bénprob ree. ");
INSERT INTO zasNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Zeel guxhaal ree xin che luguiedx la Jope din chicaꞌ reex Simón, bén la gajc Bëd. Zojbaman lidx tijb bén la gajc Simón, bén rüjnchaaw guid, bén zojb gajxh roꞌnijsdoo. Bëd guin na ni rayal güünl.” ");
INSERT INTO zasNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Zianan zeel laa guxhal gajcan xin bidgadiil ree lüj. Zagdxe beenl biꞌtil. Abiꞌ yan dugraczan nadxuꞌ delant loj Dios yuꞌ xanyabaa, din yacaagdiajgan gra ni gunabee Dios lüj nal du lojn. ");
INSERT INTO zasNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Dxel guzuloj canee Bëd, rëbaman: ―Ma ragbeen yan guial tiblojzi ruguiaa Dios bejn. ");
INSERT INTO zasNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Din Dios, chutëëz bénguidxliuj ridxgaꞌ laaman rüjn tëëman ziꞌc rayal, nëgajc Dios ridxgaꞌ laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dios ma gunee bén Israel ree, ma bagojnman guial por Jesucrist rabedxe luxdoo bejn, bén na̱j Dad par gra ree bénguidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Lëjt ragbee xhienaag bazaꞌt reeman Jesús diizd niz Galilea xt guidib niz Judea, chi gulox bagojn Waj bejn ree xcwent guialrirobnijs. ");
INSERT INTO zasNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ragbee tëëdi guial ma badëë Dios xSprijtaman con xguialrniabeeman loj Jesús bén Nazaret, abiꞌ bizaman biguieenman ni zagdxe, bayüjnman gra ree bén cazagdiaj por xindxab. Gojc beenman zian guial zaꞌnë Dios laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Abiꞌ dunujn baguiaa gra ni been Jesús guidib niz Judea, në niz Jerusalén. Dxelri bagüjt reeman laaman, bacaa reeman laaman loj crüjz. ");
INSERT INTO zasNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Per Dios basban laaman ni bayon dxej, abiꞌ cwëjb Dios bidgalüülojman du lojn. ");
INSERT INTO zasNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ad balüülojtaman loj gra ree bejn, tijbzi du lojn nayajcan bén gule Dios diizd yaloj din yaguiaan graczi ni beenman. Abiꞌ dunujn badaawnëꞌ laaman badüꞌnëꞌ tëën laaman chi babanman stijb. ");
INSERT INTO zasNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Dxelri guxhaal Jesús dunujn din yatieꞌchan xtiidxaman loj ree bejn, guial Dios ma gulej laaman din güünman guialguxtis chi guidxin dxej yadëëd gra ree bejn cwent loj Dios, ziꞌc ree bén naban ziꞌc ree bén ma güjt. ");
INSERT INTO zasNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nëtëë diizd gocli graczi ree bén badëëd xtiidx Dios loj ree bejn, gunee reeman xcwent Jesús, rëb reeman guial graczi ree bén chililadx laaman, gac xtol reeman perdon. ");
INSERT INTO zasNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Sta canee Bëd, chi guyu xSprijt Dios luxdoo gra ree bén cucaagdiajg ni cayëbaman. ");
INSERT INTO zasNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Dxel bén Israel rliladx ree Jesucrist, bén binë ree Bëd, dád badxa loj reeman guial në ree bén ad najt ree bén Israel guyu xSprijt Dios luxdoo, ");
INSERT INTO zasNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","guial riguiejn reeman ma rniee ree bén guin graloj ree diidx, abiꞌ ruzaꞌt reeman Dios zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Dxel rëb Bëd loj reeman: ―¿Chu zajc gudxoon tiobnijs ree bén guie, bal ma yuꞌ xSprijt Dios luxdoo reeman ziꞌcgajc dunuj ree? ");
INSERT INTO zasNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Abiꞌ gunabeeman tiobnijs reeman por Jesucrist. Dxelri guzajc reeman liaadx loj Bëd din sunëman laa reeman za tioꞌp choon dxej mazri. ");
INSERT INTO zasNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bén na̱j ree xi apóstoles Jesús con ree bén Judea, bén rliladx ree laaman, gogbee reeman guial në ree bén ad najt bén Israel bililadx xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Abiꞌ chi badxin Bëd Jerusalén, bén Israel ma rliladx ree Jesucrist, bén sta zinal ree ley, gudilë reeman Bëd. ");
INSERT INTO zasNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Rëb reeman lojman: ―¿Chexc zeel bichuꞌl lidx ree bén ad najt bén Israel abiꞌ gudawnël laa reeman? ");
INSERT INTO zasNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Dxel guzuloj cayü Bëd diidx diizd guiaꞌxchej xhienaag gojc zeel wejman lidx ree bén guin abiꞌ rëbaman loj reeman: ");
INSERT INTO zasNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Chi zaꞌn luguiedx Jope, laꞌtgaj cabedx canaaban Dios, guzaꞌcan ziꞌc rulüü caneꞌxhchalan. Baguian ziꞌc tijb lajd naroob naxii guidap xquinan caguiajtan diizd xanyabaa xt lod zaꞌn. ");
INSERT INTO zasNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Chi baguian zagdxe xhie yuꞌ loj lajd guin, baguian bedoxh ree në ree be yuꞌ tajp guiaꞌ në ree bëël con ree be rzuj. ");
INSERT INTO zasNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Dxel biguiejnan chaꞌ bejn, naman: “Bëd, guzuli, bagüjt be gawil.” ");
INSERT INTO zasNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Per badxiꞌnan rën: “Yajqui, Dad, din ad goctczi wayawan nidxuudx, ni ad rayalt gaw bejn.” ");
INSERT INTO zasNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Abiꞌ guneeman diizd xanyabaa stijb, naman: “Ni ma basia Dios, ad rnieelan nidxuudx.” ");
INSERT INTO zasNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Choon volt gojc zian, dxel bayëꞌp gra ni guin xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Loj hor zii gajc biꞌt choon ree xinguiaaw lod guren, zëëd reex diizd Cesarea, cayguiil reex naj. ");
INSERT INTO zasNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Abiꞌ na xSprijt Dios lon guial chinëꞌn laa reex, ad chuꞌ luxdon tioꞌp. Në guixoꞌp ree bén guie bén na̱j dux compniar ree binëꞌn. Abiꞌ dugraczan badxuꞌ lidx bén guin. ");
INSERT INTO zasNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Dxel beman diidx du lojn xhienaag balüüloj tijb xi anjl Dios lojman lidxaman, rëb anjl guin lojman: “Guxhaal ree bén che luguiedx Jope din chicaꞌ reeman Simón, bén la gajc Bëd, ");
INSERT INTO zasNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","laaman na xhienaag gac ree xtolil perdon, con gra ree bén zojb lidxil.” ");
INSERT INTO zasNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Chi guzuloj canenëꞌn laa reeman, guyu xSprijt Dios luxdoo reeman ziꞌcgajc guyuman du luxdoo ree yaloj. ");
INSERT INTO zasNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Dxel basaaladxan xtiidx Dad Jesucrist chi naman: “Walican baroobnijs Waj con nijs, per lëjt chuꞌ xSprijt Dios luxdoodi.” ");
INSERT INTO zasNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Abiꞌ yan bal ma guxhaal Dios xSprijtaman par laa reeman ziꞌcgajc guxhaalaman laaman du loj ree chi baliladx ree Dad Jesucrist, ¿chu najn din gudxonan ni rüjn Dios? ");
INSERT INTO zasNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Chi biguiejn ree bén guin ni rëb Bëd, dxel achetri rëb reeman lojman abiꞌ bazaꞌt reeman Dios zagdxe, rëb reeman: ―¡Ma rayagbee ree yan guial në ree bén ad najt bén Israel ma balüü Dios guial rayal yayüjn xgab por xtol reeman yadxiꞌ tëë loj reeman lojman din gap reeman guialnaban tiblayaa delant lojman! ");
INSERT INTO zasNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Chi mal bagüjt ree bejn Esteban, dxel guzuloj rzunal reeman bén rliladx ree Jesucrist persi bireꞌch gra ree bén rliladx guin niz Fenicia, niz Chipre në Antioquía. Abiꞌ gutieꞌch reeman xtiidxzaꞌc Jesucrist, per ganaxzi loj ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Per loj reeman noꞌch bëlzi ree bén Chipre në ree bén Cirene. Laa reeman we luguiedx Antioquía abiꞌ gutieꞌch reeman xtiidx Dad Jesucrist loj ree bén ad najt bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Gognë Dios laa reeman, dád zien ree bejn bililadx ni rëb reeman abiꞌ bililadx reeman Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Chi gogbee ree bén Jerusalén rliladx Jesucrist ni goc, guxhaal reeman Bernabé xt guiedx Antioquía. ");
INSERT INTO zasNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Chi bidxinman ni, dád babaaman chi baguiaaman xhienaag cayagnë Dios bén guin ree. Dxel guneenëman gra reeman din con guidib luxdoo reeman gusnuu chinal reeman xtiidx Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Benzaꞌc gojc Bernabé, dád gognë xSprijt Dios laaman abiꞌ bililadxaman Jesucrist con guidib luxdooman. Zeel dád zien ree bejn bililadx Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Dxelri wej Bernabé guiedx Tarso bigdiilaman Saulo. ");
INSERT INTO zasNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Chi badxejlaman laaman, dxel binëman laaman xt Antioquía. Ni guzunë reeman bén rliladx ree Jesucrist tibijz, dád zien ree bejn balüü reeman. Abiꞌ luguiedx Antioquía na̱j lod gulëëlaj reeman bén rliladx ree Jesucrist, cristian. ");
INSERT INTO zasNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Lën ree dxej zii bëlzi ree bén badëë xtiidx Dios loj ree bejn, guza Jerusalén wej reeman Antioquía. ");
INSERT INTO zasNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Tijb reeman la Agabo, laaman guzuli loj ree bejn abiꞌ por xSprijt Dios bagojnman guial chuꞌ gubijn guidibczi guidxliuj. Laan gojc loj tiamp gunabee rey Claudio. ");
INSERT INTO zasNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Abiꞌ ree bén rliladx Jesucrist luguiedx Antioquía, bayaꞌn reeman diidx din guidoꞌp reeman ziꞌctzi ni galguzuj gudëëd tijb gaj reeman, din gagnë lasaꞌ reeman, bén rliladx ree Jesucrist, bén zojb ree niz Judea. ");
INSERT INTO zasNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Abiꞌ zian been reeman. Dxel guxhaalnë reeman laan Saulo con Bernabé din gudëëd reeman laan loj ree bén rniabee ree bén rliladx Jesucrist niz Judea. ");
INSERT INTO zasNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Lën ree dxej zii guzuloj rey Herodes cusagziman bëlzi ree bén rliladx Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Abiꞌ gunabeeman bagüjt reeman Jacob bijch Waj, con espad. ");
INSERT INTO zasNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Chi baguiaaman bayuladx ree bén Israel ni beenman, dxel gunabeeman gunaaz reeman Bëd. Ni ne goc lën ree dxej lanij pascw chi raw reeman guiadxtil ad yuꞌt levadur. ");
INSERT INTO zasNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Chi gunaaz reeman Bëd, badxeꞌ reeman laaman ladxguiib abiꞌ gunabee rey Herodes tajp cwaa ree suldad din guinia reeman roꞌ ladxguiib guin, tib cwaa gaj reeman na̱j tajp suldad. Din beenman xgab nuzujman Bëd loj ree bén guiedx guin chi nidëd pascw. ");
INSERT INTO zasNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Zian guyu Bëd ladxguiib, gojp daꞌt reeman laaman. Per gra ree bén rliladx Jesucrist ad rucwëëzt rbejdx rniab reeman Dios por laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Guxhin zii gajc chi yareguiaal cwëë Herodes Bëd loj ree bén guiedx guin, nagaꞌyëjs Bëd galay tioꞌp ree suldad, naxiiman con tioꞌp ree caden, guiáad los demazri ree suldad guin cayajp roꞌ ladxguiib guin. ");
INSERT INTO zasNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Dxejczi bidxin tijb xi anjl Dios abiꞌ basni tijb guij lën ladxguiib guin, dxel baquiꞌ anjl guin cwëꞌlën Bëd persi bacwëënman laaman, rëbaman lojman: ―¡Cari bixche! Loj hor zii gajc biajb ree caden naxii yaa Bëd, ");
INSERT INTO zasNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","abiꞌ rëb anjl guin lojman: ―Guxhiidxiꞌch lënl balëë tëë xgurëchil. Chi ma been Bëd zian dxel rëb anjl guin: ―¡Gojt xcajpil, tanal naj! ");
INSERT INTO zasNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Laa barii gajc Bëd nalaman anjl guin, per ad ragbeetaman bal diidxli na̱j ni cayüjn anjl guin, gunaladxaman caneꞌxhchaalzaman. ");
INSERT INTO zasNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Abiꞌ gudëd reeman loj tibcwaa ree suldad guin, dxel gudëd reeman loj stibcwaa reeman. Chi bidxin reeman roꞌ portguiib ni rarii runejz guin, dxel xtijbzan bixal abiꞌ barii reeman. Abiꞌ chi bidxin reeman tijb xquin, yagaj basaꞌn anjl guin Bëd. ");
INSERT INTO zasNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Dxel gogbee Bëd guial ni diidxliqui na̱j ni cazajcaman, abiꞌ rëbaman: ―Yanri ma ragbeen guial guxhaal xi anjl Dios persi babëëman naj loj Herodes, con loj gra ni nüjnnë ree bén Israel naj. ");
INSERT INTO zasNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Chi bayagbee Bëd ni guzacaman, dxel baguiajman lidx Li, xniaa Waj, bén la gajc Marcw, lod rigaꞌ zien ree bejn cabejdx canab reeman Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Chi gulajw Bëd roꞌ port, dxel brii tijb biin la Rode ziquiaam chunin. ");
INSERT INTO zasNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Per chi bayünbeem chaꞌ Bëd, dád babaam, dxel luar nixhialim roꞌ port guin, baxüünm bicojnm guial zaꞌ Bëd roꞌ port guin. ");
INSERT INTO zasNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Abiꞌ rëb reeman lojm: ―¡Rajc guijquil! Per zaꞌdxiꞌchczim guial waliqui ni rëbim. Dxel rëb reeman lojm: ―Ad laataman, wed xi anjlaman. ");
INSERT INTO zasNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Per Bëd cabajwzi cabajwaman roꞌ port guin. Dxel chi guxhal reeman dád bidxeb reeman baguiaa reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Abiꞌ been Bëd sen loj reeman din yacwëëz roꞌ reeman, dxel beman diidx xhienaag babëë Dios laaman ladxguiib. Abiꞌ rëbaman loj reeman: ―Gol be ni guie loj Jacob në loj gra ree bén rliladx Jesucrist. Dxelri briiman yagaj zëman lood ren. ");
INSERT INTO zasNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Chi bareguiaal, ad radxejlt xhie güün ree suldad guin guial ad ragbeet reeman xhienaag barii Bëd ladxguiib guin. ");
INSERT INTO zasNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Dxel gunabee Herodes chigdiil reeman Bëd, per ad badxejlt reeman laaman. Abiꞌ chi gulox gunabdiidx Herodes loj ree suldad guin xhienaag gojc, gunabeeman gugüjt reeman laa reeman. Dxel brii Herodes Judea abiꞌ bisobaman luguiedx Cesarea. ");
INSERT INTO zasNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Balen Herodes bén Tiro në ree bén Sidón, per bayaꞌn ree bén guin diidx din chigneenë reeman laaman. Chi been reeman gan guneenë reeman bén brii laj Blasto zagdxe, tijb bén na̱j xbejn rey Herodes, dxel gunee Blasto por laa reeman loj rey guin din lox til reeman, din guidibczi lod rniabee rey guin zëëd ni raw reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Bazuj Herodes xhie dxej guinieenëman laa reeman abiꞌ dxej zii gojt xab zagdxeman, gurej loj xyagxhilaman lod rniabeeman, zianz guzuloj guneenëman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Dxel guzuloj gurixdiaj ree bén guin, rëb reeman: ―¡Ad bejntan canee, tijb diosan! ");
INSERT INTO zasNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Loj hor zii gajc badëë tijb xi anjl Dios tijb guialguijdx loj Herodes. Gudaw bizog laaman abiꞌ güjtaman guial bayuladxaman bazaꞌt ree bejn laaman zagdxe luar nuzaꞌt reeman Dios zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Per xtiidx Dios careꞌchzi careꞌchan gra ladczi abiꞌ gra ladczi cayajcxhiej ree bén rliladx laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Chi ma badëëd ree Bernabé con Saulo ni guxhaal ree bén Antioquía, dxel baza reeman Jerusalén, binë reeman Waj, bén la gajc Marcw. ");
INSERT INTO zasNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Loj ree bén rliladx Jesucrist, bén zojb ree Antioquía, noꞌch ree bén rudëëd xtiidx Dios loj ree bejn në ree bén rulüü xtiidxaman. La reeman Bernabé, Simón bén rniee reeman Benyaꞌs, Lucio bén Cirene, Saulo con Manaén bén guniꞌsnë Herodes tijbzi, bén gunabee Galilea. ");
INSERT INTO zasNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Tijb dxej chi nabaꞌn reeman, laꞌtgaj cabejdx canab reeman cuzaꞌt tëë reeman Dios zagdxe, rëb xSprijt Dios loj reeman: ―Gol bacaabee Bernabé në Saulo din güün reeman dxiin rënan güün reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Chi gulox gubaꞌn reeman gurejdx tëë reeman Dios, dxel guxhoob yaa reeman guijc Bernabé con Saulo din gagnë Dios laa reeman abiꞌ bazaadiidxnë reeman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","XSprijt Dios na̱j bén guxhaal Bernabé con Saulo, zë reeman Seleucia, ni guyu reeman loj barcw, zë reeman yuj la Chipre, ni rigaꞌ loj nijsdoo. ");
INSERT INTO zasNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Chi bidxin reeman niz Chipre, dxel luguiedx Salamina guzuloj gutieꞌch reeman xtiidx Dios lën ree xyadoo ree bén Israel. Në Waj binë reeman din güünman laa reeman yudar. ");
INSERT INTO zasNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Chi biza reeman guidib niz Chipre, dxel bidxin reeman Pafos. Ni bidxaagloj reeman tijb bén Israel laman Barjesús, rajcaman guialbidxaa, rusquieeman bejn ree, rëbaman guial laaman na̱j bén rudëëd xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Barjesús guin rnieenëman Sergio Paulo zagdxe, bén na̱j gobernador Chipre, rigniaꞌ daꞌtaman. Gurejdx gobernador guin Bernabé con Saulo guial rënman gucaagdiajgaman xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Per bénbidxaa guin (con diidx grieg laman Elimas) guyënman nudxoonman guial nililadx Sergio Paulo xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Abiꞌ Saulo, bén la gajc Pab, rniabee xSprijt Dios luxdooman guidiblagaa, baguiaadxijchaman loj bénbidxaa guin, ");
INSERT INTO zasNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","rëbaman: ―¡Xiꞌn xindxab lüj, ganax rusquieel, ganax niguijdx rüjnl, ad rëntczil ni zagdxe! ¿Xt goc gudëël mod chinal ree bejn xnejz nali Dios? ");
INSERT INTO zasNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Yan gudëëd Dios lüj casti: ad zanit lojl abiꞌ xchej ad zuguiaatil xbachaꞌ gubijdx. Loj hor zii gajc gurexcajy Elimas abiꞌ ad gojctri nuguiaaman, dxel raguiilaman chu guiniaaz yaaman guial ad rajctri ruguiaaman. ");
INSERT INTO zasNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Chi baguiaa gobernador guin zian, dxel bililadxaman abiꞌ dád badxa lojman ni balüü reeman xcwent Dad Jesús. ");
INSERT INTO zasNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Chi ma gudëd gojc zian, guyu Pab con ree xcompniaraman loj barcw luguiedx Pafos abiꞌ zë reeman luguiedx Perge ni rigaꞌ niz Panfilia. Ni basaꞌn Waj laa reeman bayejcaman Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Dxel barii reeman guiedx Perge, zë reeman luguiedx Antioquía ni rigaꞌ niz Pisidia. Abiꞌ dxej raziiladx ree bén Israel, guyu reeman lën xyadoo ree bén Israel zianz gurej reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Dxel chi gulox biil bén biil tib lajt loj libr bacaa Moisejs në loj libr bacaa ree bén badëë xtiidx Dios loj ree bejn, gunee ree bén rniabee lën yadoo guin, rëb reeman loj Pab con Bernabé: ―Bal xhie guiëbidi loj ree bén rigaꞌ guie din gudëëdi consejw loj reeman, zajc guiëbidan yan. ");
INSERT INTO zasNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Dxel guzuli Pab, beenman sen loj reeman din yacwëëz roꞌ reeman, dxel rëbaman: ―Bén Israel, në gra ree bén rdxeb Dios, gol bacaagdiajg: ");
INSERT INTO zasNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Dux Dios ree, nayajc ree bén Israel, gulejman dux béngulal ree abiꞌ laaman been persi gojcxhiej reeman, chi sta zojb reeman ziꞌc benzit niz Egipto. Dxel con xguialrniabeeman babëëman laa reeman Egipto. ");
INSERT INTO zasNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Abiꞌ baslejnguijcaman laa reeman loj tiuu ijz ni guzu reeman niz lod na̱j ganax yujbidx, ");
INSERT INTO zasNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","banijt tëëman gajdx ree nacion ni gure Canaán persi badëëman guidxliuj guin ree loj dux béngulal ree. ");
INSERT INTO zasNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Zian gojc loj tajp gayuu garol ijz, dxelri bacaabee Dios juejs ree persi gunabee reeman laa reeman. Abiꞌ Samuel bén badëëd xtiidx Dios loj ree bejn gojc xjuejs bigra reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Dxel gunab reeman din chuꞌ tijb rey nabee laa reeman, abiꞌ bazuj Dios rey Saúl xiꞌn Cis, bén zëëd loj xdiaa Benjamín persi gunabeeman laa reeman tiuu ijz. ");
INSERT INTO zasNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Chi bisüd Dios rey Saúl, dxel bazujman rey Davi. Abiꞌ rëbaman: “Ma baguian guial Davi xiꞌn Isaí, nabanx ziꞌc rënan, güün tëëx cumplid da diidxan guial güünx gra ziꞌc rënan.” ");
INSERT INTO zasNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Abiꞌ yan ziꞌc gajczi rëb Dios, loj gajc xdiaa rey Davi, brii Jesús bén guxhaalaman din yabëëman bén Israel ree loj dol. ");
INSERT INTO zasNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Chi gad Jesús guiꞌt, Waj bén baroobnijs bejn ree, bagojnman gra ree bén Israel guial rayal yayüjn reeman xgab por xtol reeman tiobnijs tëë reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Chi ma zidyob yadiblagaa xguialnaban Waj, dxel rëbaman: “Ad najtan bén naladxidi, qui guiꞌtraman, laaman mazri lasajc guial lon, niꞌquid rayalt gaxhiecan xgurëchaman.” ");
INSERT INTO zasNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Yan, dugra ree nayajc ree xdiaa Abraham në gra los demazri ree bén rdxeb Dios, par dunuj ree na̱j xtiidxaman ni rugojn reeman dunuj ree, xhienaag rabëë Jesucrist dunuj ree loj dol. ");
INSERT INTO zasNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Per ree bén Jerusalén con ree xguxtis reeman ad bayagbeet reeman Jesús. Ad gogbee tëët reeman xhie rën guiëb xtiidx Dios ni bacaa ree bén badëëd ree xtiidxaman loj ree bejn, ni rool reeman lën yadoo dxej raziiladx ree bejn, dxel laagajc reeman bagüjt Jesús, zian gojc cumplid ni ca loj xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Abiꞌ majsi achetczi xtol Jesús guyu, per niꞌczi zian rëb gajc reeman loj Pilato guial nabeeman guiëtaman. ");
INSERT INTO zasNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Chi gulox been reeman gra ziꞌc ca loj xtiidx Dios xcwent Jesús, balet reeman laaman loj crüjz abiꞌ baquieꞌch reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Per Dios basban laaman, ");
INSERT INTO zasNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","dxel loj zien dxej balüülojman loj ree bén binë laaman chi briiman niz Galilea zëman Jerusalén, abiꞌ yan laa reeman na̱j bén rniee por laaman loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Zeel caygojnan lëjt diidxzaꞌc guin ree, guial promejs been Dios loj ree dux béngulal ree, ");
INSERT INTO zasNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ma beenman laan cumplid con dunuj ree guial zioꞌp ree loj xdiaa reeman. Beenman cumplid xtiidxaman chi basbanman Jesús ziꞌc ca loj Salmo barojp, lod rëb: “Lüj na̱j da xiꞌnan abiꞌ diizd yan ma rajpil guialrniabee ziꞌcgajc naj.” ");
INSERT INTO zasNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Dios rëb guial yasbanman Jesús abiꞌ ad zaxint xcuerpaman ziꞌc gajczi ca loj xtiidx Dios lod rëb: “Naj günleꞌ lëjt ziꞌc benan promejs loj Davi.” ");
INSERT INTO zasNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Abiꞌ rëb tëë stib lajt loj xtiidxaman: “Ad zatiëjbtil xhin xcuerp xiꞌnl, bén naya nali.” ");
INSERT INTO zasNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Yan diidxliczi diidx guin ree ad rnieet reen xcwent Davi, din chi gulox gunabeeman bejn ree xtiampaman ziꞌc rëb Dios nabeeman, dxel güjtaman, biguieꞌchaman abiꞌ guxin xcuerpaman. ");
INSERT INTO zasNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Per xcuerp Jesús bén basban Dios, ad guxintan. ");
INSERT INTO zasNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Zeel caygojnan lëjt compniar din gagbeedi guial por laaman ma yuꞌ perdon par dux tol ree. ");
INSERT INTO zasNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Graczi bén rliladx Jesucrist ma gojc perdon gra xtol reeman ni ad gojct niajc perdon por ley badëë Dios loj Moisejs. ");
INSERT INTO zasNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Zeel gol gojp cudad chitëë saquidi ziꞌc bacaa ree bén badëë xtiidx Dios loj ree bejn, lod rëb: ");
INSERT INTO zasNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Gol bacaagdiajg, lëjt bén ruzeꞌ ree da diidxan, gol badxalojdi gol gunidloj tëë. Din loj ree dxej nabandi gün reen ni xt niꞌquid zaliladxtidi, majsi chu na laa reen lojdi. ");
INSERT INTO zasNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Chi barii Pab con Bernabé lën xyadoo ree bén Israel guin, gunab reeman favor loj Pab, din chi guidxin stijb dxej raziiladx ree bejn chiguieman mazri diidx loj reeman xcwent ni beman dxej zii. ");
INSERT INTO zasNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Chi barii ree bén guin lën yado guin, zien daꞌt reeman binal Pab con Bernabé, ziꞌc ree bén Israel ziꞌc ree bén ad najt bén Israel, bén rën ree Dios ziꞌcgajc ree bén Israel. Abiꞌ rëb Pab con Bernabé loj reeman din sudxiꞌch reeman loj nejz zagdxe guredx Dios laa reeman guial rënman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Chi bidxin dxej ni raziiladx ree bejn, gra bén luguiedx guin badoꞌp din gucaagdiajg reeman xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Per chi baguiaa ree bén Israel zien daꞌt ree bejn rigaꞌ yagaj, dxel guyu guialnadëdloj luxdoo reeman abiꞌ guzuloj caneeguijdx reeman canee tëë reeman diidxguijdx loj Pab. ");
INSERT INTO zasNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Dxel sin guialrdxeb badxiꞌ Paban con Bernabé loj reeman, rëb reeman: ―Yaloj lëjt rayal yagojnan xtiidxzaꞌc Dios, lëjt najdi bén Israel, per yan ad rëntidi gucaagdiajguidi laan, dxel lëjt gajc culüü guial ad zajct yayalidi guialnaban tiblayaa con Dios. Yan ma yugtieꞌchan diidxzaꞌc guin ree loj ree bén ad najt bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Din zian gunabee dux Dad ree Dios dunujn, chi rëbaman tib lajt loj xtiidxaman: Nuzun lüj ziꞌc guij par gra ree nacion, din chel guidibchicniaa loj guidxliuj chicojnl xhienaag gac ree bejn perdon. ");
INSERT INTO zasNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Chi biguiejn ree bén ad najt bén Israel zian, dxel babaa reeman, guzuloj rëb reeman guial zagdxe na̱j xtiidx Dios, abiꞌ graczi bén ma na̱j yayal guialnaban tiblayaa con Dios, bililadx reeman xtiidxaman. ");
INSERT INTO zasNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Zianan zeel bireꞌch xtiidxzaꞌc Dios guidib niz ni. ");
INSERT INTO zasNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Per ree bén Israel batiaalguiiw reeman béngunaa rej ree laydoo zianczi na̱j tëë reeman bén zojbloj luguiedx zii, në ree xinguiaaw na̱j gajc xin zojbloj, din sunal reeman Pab con Bernabé xt yabëë reeman laa reeman ni. ");
INSERT INTO zasNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Dxel Pab con Bernabé gudxijp guxyuj guiaꞌ reeman ziꞌc tijb sen guial ad bazoobt ree bén guin diidx, dxel zë reeman Iconio. ");
INSERT INTO zasNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Per ree bén bililadx Jesús niz ni, ma rniabee xSprijt Dios luxdoo reeman guidiblagaa abiꞌ dád rabaa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Luguiedx Iconio, Pab con Bernabé guyu reeman lën xyadoo ree bén Israel. Abiꞌ ziꞌc balüü reeman xtiidxzaꞌc Jesucrist, zien daꞌt reeman bililadx, ziꞌc ree bén Israel ziꞌc ree bén ad najt bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Per ree bén Israel ad bililadxt batiaalguiiw reeman bén ad najt ree bén Israel persi guzuloj been reeman xgab mal por ree bén rliladx Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Per niꞌczi zian, xchej daꞌt guzuj ree apóstoles guin ni, abiꞌ sin guialrdxeb gunee reeman xtiidx Dios guial rliladx reeman Jesucrist, laaman badëëd guialrniabee loj reeman persi been reeman zien daꞌt ree milagr në mazri ree ni ren, persi balüü Jesucrist guial diidxli na̱j ni rëb reeman xcwent Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Per ree bén luguiedx zii gojc reeman tioꞌp lalaꞌ, garol reeman guzunë ree bén Israel zagarol reeman guzunë apóstoles guin ree. ");
INSERT INTO zasNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Dxel ziꞌc ree bén Israel ziꞌc ree bén ad najt bén Israel, bayaꞌn reeman diidx con ree guxtis din tilë reeman Pab con Bernabé gucaaguiaj tëë reeman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Abiꞌ chi gogbee Pab con Bernabé zian, laa zia gajc reeman Listra con Derbe, guiedx rigaꞌ ree niz Licaonia, në gra ree guiedx rigaꞌ niz ni, ");
INSERT INTO zasNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","gunee reeman xtiidxzaꞌc Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Luguiedx Listra guyu tijb xinguiaaw ad rajct rza, ad guzatczix guial naxin guiaꞌx diizd chi golix abiꞌ zojbix ");
INSERT INTO zasNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","cucaagdiajguix ni rëb Pab. Chi baguiaa Pab laax, gogbeeman guial rliladxix par yayajquix. ");
INSERT INTO zasNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Abiꞌ guneeman rejs, rëbaman: ―¡Bisu, guzuli zagdxe! Loj hor zii gajc gutiajs xin guin, guzulix abiꞌ guzuloj cazax. ");
INSERT INTO zasNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Chi baguiaa ree bejn ni been Pab, guzuloj canee reeman rejs diidx Licaonia, rëb reeman: ―Dios na̱j ree ziꞌc bejn ma biguiajt lod nadxuꞌ ree. ");
INSERT INTO zasNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Abiꞌ rëb reeman guial Bernabé na̱j dios Júpiter, guiáad Pab na̱j dios Mercurio guial laaman na̱j bén rniee loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Abiꞌ roꞌ guiedx guin niz lod ru bejn na̱j xyadoo Júpiter, dxel bixhioz yuꞌ lën yadoo guin binëman goꞌn ree con ree guiaa, abiꞌ laaman con ree bén guin guyën reeman nugüjt reeman goꞌn guin ree din niën reeman apóstoles guin ree ziꞌc xdios reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Per chi gogbee Pab con Bernabé zian, gudixyaꞌ xab reeman, guzëëb reeman la̱d ree bén guin, rbixdiaj reeman rëb reeman: ");
INSERT INTO zasNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―Gol bacaagdiajg, ¿chexquiza zeel rüjndi zian, awa bejn gajc dunujn ziꞌcgajc lëjt? Awa par zianclan zioꞌpan din yanan lojdi din yasaꞌndi ni rüjndi, din achetczi lasajc reen. Mejorli gol binal xnejz Dios naban, bén been xanyabaa në guidxliuj nëtëë nijsdoo con gra ni yuꞌ loj reen. ");
INSERT INTO zasNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tiamp gulal Dios baslaa been ree bejn ni guyëntzi reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Per niꞌczi zian, zianczi balüüman chu najman por ree ni zagdxe ni rüjnman. Din laaman na̱j bén razaladx guia con guialnazaꞌc abiꞌ razaladxaman ni radaaw ree din chuꞌ du luxdoo ree zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Chi rëb Pab con Bernabé zian, con ree diidx guin penz been reeman gan badxoon reeman guial nugüjt ree bén guin goꞌn guin ree din niën reeman laa reeman ziꞌc xdios reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Per bëlzi ree bén Israel zojb Antioquía në Iconio, chi bidxin reeman luguiedx Listra been reeman gan batiaalguiiw reeman bén luguiedx guin ree. Dxel bacaaguiaj reeman Pab abiꞌ gunaladx reeman ma güjtaman abiꞌ guxoobyuj reeman laaman, babëë reeman laaman luguiedx guin. ");
INSERT INTO zasNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Per chi bidoꞌp ree bén rliladx Jesucrist gadëd lod nagaꞌman, dxel bixcheman, bayuman luguiedx guin stijb. Chi bareguiaal briinëman Bernabé zë reeman luguiedx Derbe. ");
INSERT INTO zasNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Chi gulox gutieꞌch reeman xtiidxzaꞌc Jesucrist luguiedx Derbe lod been reeman gan bililadx zien ree bejn laan, dxel bayejc reeman luguiedx Listra në Iconio nëtëë Antioquía. ");
INSERT INTO zasNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Luguiedx zii ree badxeꞌ reeman luxdoo ree bén rliladx Jesucrist. Rëb reeman loj reeman din sudxiꞌch reeman loj ni rliladx reeman laaman, din dád sagdiaj reeman din yayu reeman lod rniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Abiꞌ tëë loj tijb gaj ree guiedx guin bacaabee reeman bengol nabee ree loj ree bén rliladx Jesucrist. Zianz chi gulox gubaꞌn reeman gurejdx tëë reeman Dios, dxel basaꞌn reeman laa reeman con Dad Jesús bén ma bililadx reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Chi baza ree Pab con Bernabé niz Pisidia, bidxin reeman niz Panfilia. ");
INSERT INTO zasNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Abiꞌ gunee reeman xtiidx Dios luguiedx Perge, dxel zë reeman guiedx Atalia. ");
INSERT INTO zasNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ni guyu reeman loj barcw zë reeman Antioquía, luguiedx lod basaꞌn ree los demazri ree bén rliladx Jesucrist laa reeman con Dios din gagnëman Pab con Bernabé din guitieꞌch reeman xtiidxaman. Abiꞌ dxiin guin na̱j ni ma baloox reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Dxel chi bidxin reeman Antioquía, batoꞌp reeman bén rliladx ree Jesucrist, persi be reeman diidx loj reeman gra ni been Dios con laa reeman, xhie tëë naag guxhalaman nejz din chililadx ree bén ad najt bén Israel Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ni guzu Pab con Bernabé xchej, guzunë reeman bén Antioquía rliladx ree Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Lën ree dxej zii bidxin bëlzi ree bén Judea luguiedx Antioquía. Abiꞌ guzuloj rëb reeman loj ree bén rliladx Jesucrist, guial bal id zu reeman sen ziꞌc gunabee Moisejs, ad zajct güün Dios xtol reeman perdon. ");
INSERT INTO zasNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Dxel Pab con Bernabé dád zroꞌ gudijldiidx reeman con ree bén guin. Dxel bacaabee ree bén rliladx Jesús Pab në Bernabé, në ree ben ren din che reeman Jerusalén chigneenë reeman apóstoles guin ree, con ree bengol rniabee loj ree bén rliladx Jesucrist din guguiaa reeman xhienaag güün reeman xcwent sen guin. ");
INSERT INTO zasNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Abiꞌ badxeꞌnejz ree bén Antioquía rliladx ree Jesucrist laa reeman persi zë reeman. Chi zë reeman gudëd reeman niz Fenicia në niz Samaria abiꞌ bagojn reeman bén rliladx ree Jesucrist, bén zojb ree niz ni guial ma rliladx ree bén ad najt ree bén Israel xtiidx Dios. Abiꞌ graczi bén ma rliladx Jesucrist niz ni, dád babaa reeman chi biguiejn reeman zian. ");
INSERT INTO zasNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Chi bidxin Pab con Bernabé Jerusalén, dxel bacaꞌ ree bén rliladx Jesucrist laa reeman, con ree apóstoles, con ree bengol rniabee loj ree bén rliladx Jesucrist. Abiꞌ be ree Pab diidx con Bernabé gra ni been Dios con laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Per yuꞌ ree bénfarisew ma rliladx Jesucrist, guzuli reeman abiꞌ rëb reeman: ―Bén ad najt ree bén Israel abiꞌ ma rliladx reeman Jesucrist, rüjn naguiejn chuꞌ reeman sen ru ree bén Israel, gagbee tëë reeman guial rayal chinal reeman xley Moisejs. ");
INSERT INTO zasNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Dxel badoꞌp ree xi apóstoles Jesús con ree bengol rniabee loj ree bén rliladx Jesucrist din guidoon xhienaag güün reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Guial tant canee reeman por zian, dxel guzuli Bëd, rëbaman loj reeman: ―Gradi compniar raliduladx ree Jesucrist, lëjt ragbee guial diizd gocli gulej Dios naj lojdi din chignen xtiidxzaꞌc Jesucrist loj ree bén ad najt bén Israel din chililadx reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Abiꞌ Dios bén nünbee luxdoo graczi ree bejn, balüüman guial na̱j reeman xbejnman guial ma badëëd xSprijtaman loj reeman ziꞌcgajc baneeman du loj ree. ");
INSERT INTO zasNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ziꞌc ruguiaa Dios dunuj ree ziangajc ruguiaaman laa reeman, din ziꞌc basiaman du luxdoo ree ziangajc basiaman luxdoo reeman guial ma rliladx reeman Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Yan, ¿chexc zeel ad ridxgaꞌtidi ni ma been Dios abiꞌza rniabeedi chinal ree bén rliladx Jesucrist ley ni niꞌqui dunuj ree niꞌqui dux béngulal ree ad gojct naguieen ree ziꞌc rniabee ley guin? ");
INSERT INTO zasNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Dunuj ree rayagbee guial por ni zagdxe ni been Dad Jesucrist, been Dios dux tol ree perdon ziꞌcgajc laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Dxel bacwëëz roꞌ gra reeman abiꞌ bacaagdiajg reeman ni cayü ree Bernabé con Pab, xcwent gra ree xmilagr Dios ni been reeman loj ree bén ad najt bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Chi gulox gunee reeman, dxel nëgajc Jacob rëb: ―Gradi compniar raliduladx ree Jesucrist, gol bacaagdiajg: ");
INSERT INTO zasNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Bëd be diidx duloj ree xhienaag guzuloj gulej Dios bén ad najt ree bén Israel din gac reeman xbejnman. ");
INSERT INTO zasNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Gra ni ma gojc na̱j ziꞌc ni bacaa ree bén badëë xtiidx Dios loj ree bejn loj xtiidxaman lod rëb: ");
INSERT INTO zasNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Chi ma gojc zian, yayünxhiej ree da bejnan mazri ziꞌc goc chi naban Davi, gacxhiej reeman por ree bén sta naban, ziꞌc guban ree bejn xtiamp Davi abiꞌ por laa reeman yayajcxhiej ree da bejnan. ");
INSERT INTO zasNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Din yaguiil ree los demazri ree bejn guial guiën reeman naj, gra ree bén nacion ren, yaguiil guial guiën reeman naj, bén ma gule reen din gac reeman da bejnan, bén guiguiejn ree guzaꞌt ree bejn naj. ");
INSERT INTO zasNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Zian na Dios, bén cugojn bejn ree gra ree nine diizd tiamp gulal. ");
INSERT INTO zasNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Zeel naladxan ad rayalt chu güün naguiejn bén ad najt ree bén Israel par chinal reeman ley, laa reeman guial ma basaꞌn xcostumbr reeman par chinal reeman xnejz Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Yan con yaxhaal ree tijb guiꞌch loj reeman guial ad rayalt gaw reeman ni ragleꞌ loj ni na̱j xdios reeman, ad rayal tëët sunë reeman ben ren bén ad najt lacheel reeman, ad rayalt gaw reeman bëël rberejn niꞌqui rejn. ");
INSERT INTO zasNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Zian yaguieꞌch ree loj reeman, din diizd tiamp gulal tijb gaj guiedx yuꞌ bén rulüü laa reeman xhie rën guiëb xley Moisejs ni rool reeman lën ree yadoo dxej raziiladx ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Dxel apóstoles guin ree con ree bengol rniabee loj ree bén rliladx Jesucrist, con los demazri ree bén rliladx Jesucrist, rëb reeman gucaabee reeman bén guixhiaalnë reeman Pab con Bernabé din che reeman Antioquía. Abiꞌ bacaabee reeman Judas, bén la gajc Barsabás, në Silas, laa reeman rajp guialrniabee loj ree bén rliladx Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Abiꞌ guxhaalnë reeman laa reeman tijb guiꞌch ni rëb: “Dunujn nayajcan xi apóstoles Jesús, con ree bengol rniabee loj ree bén rliladx laaman, në los demazri ree bén rliladx laaman. Ragajpdiozan lëjt bén ad najt ree bén Israel, per nayajc ree compniar raliduladx ree Jesucrist, lëjt zojbidi Antioquía, në los demazri ree bén zojb ree niz Siria nëtëë niz Cilicia. ");
INSERT INTO zasNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ma bayagbeen guial yuꞌ ree bén duladxan brii sin dux tiidxbeen, abiꞌ caguꞌnawëëg reeman lëjt con xtiidx reeman persi ad radxejlt xhie güündi guial na reeman lojdi rayal chuꞌdi sen ni ru ree bén Israel güün tëëdi ziꞌc rniabee xley Moisejs, per ad dunujtan baxhaal laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Zeel badoꞌpan abiꞌ raguieꞌchan guial zagdxe na̱j yacaabee bëlzi dux compniaran din guidganaj reeman lëjt, guidnë tëë reeman tioꞌp dux compniaran, Bernabé con Pab, bén rayën daꞌtan. ");
INSERT INTO zasNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Zien ree ni guijdx cuchaagloj reeman guial cayüjn reeman sirv loj Dad Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Dxel cayxhaalnëꞌn laa reeman Judas con Silas, laa reeman na lojdi gra con quijb xtiidx reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Abiꞌ ziꞌc na̱j xgab bazaladx xSprijt Dios du lojn, dxel achetri naguiejn rüjn yanabeen lëjt ni güündi, ni rayalzi cuꞌguijquidi na̱j guial, ");
INSERT INTO zasNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ad gawidi xbëël ree be ni rbeꞌc ree bejn loj ni na̱j xdios reeman, ad gaw tëëdi bëël rberejn, niꞌqui rejn, ad sunëdi ben ren bén ad najt lacheelidi. Bal gapidi cudad ad züjntidi gra ree nine, zagdxequi güündi. Gagnë Dios lëjt.” ");
INSERT INTO zasNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Zian gojcan, guiꞌch guin na̱j ni guxhaalnë reeman guidap ree bén guin par luguiedx Antioquía. Ni batoꞌp reeman bén rliladx ree Jesucrist abiꞌ bayü reeman guiꞌch guin loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Chi biil reeman laan, dád nix guyu luxdoo reeman por ree diidx zagdxe ni zëëd lojn. ");
INSERT INTO zasNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Abiꞌ Judas con Silas guial nëgajc reeman rajp quiarguiejn par gudëëd reeman xtiidx Dios, dxel zien na̱j ni guneenë reeman bén rliladx ree Jesucrist, baguꞌ reeman luxdoo reeman con xtiidx reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Chi ma gudëd zien dxej zaꞌ ree Judas con Silas ni, bazaadiidxnë ree bén rliladx Jesucrist laa reeman din yaguiaj reeman lod zaꞌ ree bén guxhaal laa reeman, rëb reeman loj reeman: “Chignë Dios lëjt zagdxe.” ");
INSERT INTO zasNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Per Silas beenman xgab bayaꞌnman ni mazri. ");
INSERT INTO zasNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Abiꞌ Pab con Bernabé bayaꞌn reeman Antioquía mazri, laa reeman con ree ben ren basnuu balüü reeman gutieꞌch tëë reeman xtiidxzaꞌc Jesucrist loj ree bejn ni. ");
INSERT INTO zasNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Chi gudëd tioꞌp choon dxej, dxel rëb Pab loj Bernabé: ―Yoꞌ stijb yugnaj dux compniar ree bén rliladx ree Jesucrist, graczi ree luguiedx lod ma bugtieꞌch xtiidx Dios, din yuquiaa xhienaag zaꞌ reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabé guyën ninë reeman Waj, bén la gajc Marcw. ");
INSERT INTO zasNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Per Pab ad cwëjbt ninë reeman laaman, din chi we reeman niz Panfilia guroꞌnladxaman laa reeman, ad binëtraman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Abiꞌ niꞌqui tijbaman niꞌqui zatijbaman ad bayaꞌnt conform, zianz gulaꞌ lasaꞌ reeman. Dxel binë Bernabé Marcw, guyu reeman loj barcw zë reeman yuj la Chipre ni rigaꞌ loj nijsdoo, ");
INSERT INTO zasNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","dxel gulej Pab Silas din chinëman laaman abiꞌ rëb los demazri ree bén rliladx Jesucrist loj reeman guial chinë Dios laa reeman zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Zianz gudëd reeman niz Siria në niz Cilicia, raguꞌ reeman luxdoo ree bén rliladx Jesucrist niz ni. ");
INSERT INTO zasNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Chi bidxin Pab con Silas guiedx Derbe në guiedx Listra abiꞌ Listra bidxaagloj reeman tijb bén rliladx Jesucrist, laman Timoteo, xniaaman na̱j bén Israel, nëman rliladx Jesucrist guiáad xdadaman na̱j bén grieg. ");
INSERT INTO zasNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Graczi ree bén rliladx Jesucrist, bén zojb ree guiedx Listra në Iconio ruzaꞌt laaman zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Dxel rëb Pab chinëman Timoteo, per yaloj badxeꞌman laaman sen ni ru ree bén Israel, chitëë xhie guiëb ree bén Israel rigaꞌ niz ni, din gra reeman ragbee guial na̱j xDadaman bén grieg. ");
INSERT INTO zasNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Graczi ree guiedx ni gudëd reeman bagojn reeman bén rliladx ree Jesucrist ni rayal güün reeman ziꞌc ma rëb ree apóstoles, con ree bengol rniabee loj ree bén rliladx laaman Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Zianan zeel guzudxiꞌch ree bén niz ni loj guialrliladx reeman Jesucrist, abiꞌ guixie guixie gojcxhiej mazri ree bén rliladx laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Chi ma gojc zian ad baslaat xSprijt Jesús nignee reeman xtiidx Dios niz Asia. Dxel gudëdzinejz reeman niz Frigia në niz Galacia ");
INSERT INTO zasNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","abiꞌ bidxin reeman niz Misia. Ni been reeman xgab niej reeman niz Bitinia, per ad cwëjb gajct xSprijt Dios niej reeman niz ni. ");
INSERT INTO zasNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Dxelri gudëdzinejz reeman niz Misia, bidxin reeman guiedx Troas. ");
INSERT INTO zasNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Yagaj, guxhinzii guzajc Pab ziꞌc rulüü caneꞌxhchaalaman. Baguiaaman tijb xinguiaaw zëëd niz Macedonia, zaꞌlix rzajquix liaadx loj Pab, rëbix: ―Guda niz Macedonia, taguieen dunujn yudar. ");
INSERT INTO zasNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Guloxzi baguiaa Pab zian, laa baguieen gajcan porvinid din yoꞌn niz Macedonia guial bayagbeen Diosan na̱j bén cabejdx dunujn niz ni par yatieꞌchan xtiidxzaꞌc Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Badxuꞌn loj barcw luguiedx Troas abiꞌ bioꞌn naliduu Samotracia. Chi bareguiaal badxinan guiedx Neápolis. ");
INSERT INTO zasNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Yagaj badxoon bioꞌn Filipos, guiedx mazri zojbloj niz Macedonia, per Rom rniabee guiedx zii, ni badxuꞌn bëlzi ree dxej. ");
INSERT INTO zasNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Abiꞌ tijb dxej raziiladx ree bejn, bariin luguiedx guin bioꞌn tijb ruguiiwroꞌ, lod rayagbeen radoꞌp ree bén Israel par cwedx reeman Dios. Abiꞌ badxuꞌn baneen xtiidxzaꞌc Jesucrist loj ree béngunaa badoꞌp yagaj. ");
INSERT INTO zasNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Tijb ree béngunaa guin la Lidia, najman bén Tiatira, rutoꞌman lajd zagdxe ni culor murad. Diidxli rdxebaman Dios abiꞌ cucaagdiajgaman. Dios guxhal xquiarguiejnman din gucaagdiajgaman zagdxe gra ni rëb Pab. ");
INSERT INTO zasNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Abiꞌ gurobnijsaman con gra xfamilaman. Dxel gunabaman favor du lojn, naman: ―Bal walidi rliladxidi guial ma rliladxan Jesucrist, gol bayaꞌn lidxan. Dxel beenman naguiejn bayaꞌnan lidxaman. ");
INSERT INTO zasNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Dxel tib volt, chi zioꞌn lod rej ree bejn par cwedx guiniab reeman Dios, badxaaglojn tijb biingunaa, yuꞌ xindxab luxdoom, abiꞌ por xguialrniabee xindxab guin rnieeyaꞌm guiáad ree bén guzii laam dád zroꞌ milia rüjn reeman gan por dxiin guin. ");
INSERT INTO zasNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Dxel bidnalim Pab con dunujn, rbidxaꞌm rëbim: ―Bén guie ree rüjn xchiin Dios yuꞌ xanyabaa, laa reeman gugojn lëjt xhienaag gaquidi perdon. ");
INSERT INTO zasNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Zien dxej daꞌt beenm zian, xt chi balenyaꞌ Pab, dxel bayejcaman rëbaman loj xindxab yuꞌ luxdoom: ―Por xguialrniabee Jesucrist, rniabeen lüj din yariil luxdoo biin guie. Loj hor zii gajc barii xindxab guin luxdoom. ");
INSERT INTO zasNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Per chi gogbee ree bén guzii laam guial ad zajctri güünm gan milia par laa reeman, dxel gunaaz reeman Pab con Silas, binë reeman laa reeman roylay loj guxtis. ");
INSERT INTO zasNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Chi bayü reeman laa reeman loj ree guxtis guin, rëb reeman: ―Xin Israel guie ree rbëë reex wadijl du ladx ree, ");
INSERT INTO zasNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","abiꞌ rulüü reex costumbr ree ni ad zatiëëbt ree yaguieen ree ad zajc tëët yaguieen ree, din ben Rom dunuj ree. ");
INSERT INTO zasNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Dxel wajs gra ree bén guin contr laa reeman, abiꞌ gunabee ree guxtis guin gulëë xab Pab con Silas din quin reeman laa reeman con var. ");
INSERT INTO zasNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Chi gulox gudijn daꞌt reeman laa reeman, dxel biluꞌ reeman laa reeman ladxguiib abiꞌ gunabee reeman bén rajp roꞌ ladxguiib guin din gapdxiꞌchaman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Chi biguiejn bén rajp roꞌ ladxguiib guin zian, dxel biluꞌman laa reeman xt lën cuart bigra yuꞌ lën ladxguiib guin, guxhiiman guiaꞌ reeman loj tabl naal con caden. ");
INSERT INTO zasNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Per garol guiaal, laꞌtgaj cabejdx canab Pab con Silas Dios, cayool tëë reeman cant par laaman, dxel cucaagdiajg los demazri ree bén yuꞌ ladxguiib guin. ");
INSERT INTO zasNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Dxel tijbzi golp guzuloj xudoxh, niz ni niz guie rurlia xcimiant ladxguiib guin. Loj hor zii gajc bixal gra ree xportan abiꞌ baxiec ree caden naxii gra ree bén yuꞌ lënan. ");
INSERT INTO zasNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Chi baban bén rajp roꞌ ladxguiib guin abiꞌ baguiaaman zojbyal gra ree xportan, gulëë xi espadaman din nugüjt laagajcaman guial gunaladxaman gra ree bén yuꞌ ladxguiib guin ma baxüün. ");
INSERT INTO zasNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Dxel gurixdiaj Pab, rëbaman lojman: ―Ad güünnaa lüj gajc, laa dugran nadxuꞌ guie. ");
INSERT INTO zasNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Laa gunab gajc bén guin tijb guij, dxel ruxüünman guyuman, rnijman guial rdxebaman, bigzuxibaman loj Pab në loj Silas. ");
INSERT INTO zasNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Dxel babëëman laa reeman, gunabdiidxaman loj reeman, rëbaman: ―Dad, gol guna, ¿xhie rayal günan din güün Dios naj perdon? ");
INSERT INTO zasNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Badxiꞌ reeman laan, rëb reeman: ―Bililadx Dad Jesucrist, zian gaquil perdon con xfamilil. ");
INSERT INTO zasNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Abiꞌ be reeman xtiidx Dios lojman con loj gra ree bén zojb lidxaman. ");
INSERT INTO zasNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Zianz guxhin zii gajc gudiibaman lod nadxeelguijdx reeman, dxel gurobnijsaman con gra xfamilaman. ");
INSERT INTO zasNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Abiꞌ bignëman laa reeman lidxaman, dxel badëëman ni gudaw reeman. Guiáad laaman dád nix yuꞌ luxdooman con gra xfamilaman Guial ma rliladx reeman Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Chi bareguiaal, guxhaal ree guxtis guin suldad ree persi biguiedx reeman loj bén rajp roꞌ ladxguiib guin guial guslaaman Pab con Silas. ");
INSERT INTO zasNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Abiꞌ rëb bén rajp roꞌ ladxguiib guin loj Pab: ―Ma na ree guxtis guial guslaan lëjt. Yan ma zajc yaguiajdi ad chuꞌdi xgab. ");
INSERT INTO zasNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Per rëb Pab loj ree suldad guin: ―Nayajcan quijb ben Rom abiꞌ gudijn reeman dunujn delant loj ree bén guiedx, niꞌquid baneet reeman mod nadëëdan cwent loj reeman con badxeꞌ reeman dunujn ladxguiib. Abiꞌ yan, ¿guslaa reeman dunujn ralan ya? ¡Ad zajctan zian! Guiꞌt quijb laa reeman guidgalëë reeman dunujn. ");
INSERT INTO zasNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Abiꞌ bicojn ree suldad guin guxtis guin ree zian, dxel dád bidxeb reeman chi biguiejn reeman guial ben Rom na̱j Pab con Silas. ");
INSERT INTO zasNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Dxel wej reeman bignab reeman perdon loj Pab con Silas babëë tëë reeman laa reeman, rëb reeman loj reeman din yaza reeman luguiedx guin. ");
INSERT INTO zasNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Chi barii reeman ladxguiib, wej reeman lidx Lidia. Zianz chi gulox guneenë reeman los demazri ree bén rliladx ree Jesucrist din chuꞌ luxdoo reeman sudxiꞌch reeman loj ni rliladx reeman, dxel baza reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Chi zë Pab con Silas, gudëd reeman niz Anfípolis në niz Apolonia zianz bidxin reeman luguiedx Tesalónica lod yuꞌ tijb xyadoo ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Abiꞌ ziꞌc goc xcostumbr Pab, wejman lën yadoo guin, choon dxej raziiladx ree bejn. Wejman bigneenëman laa reeman xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Bagojnman balüü tëëman laa reeman loj xtiidx Dios lod rëb guial na̱j sagdiaj Cristo, abiꞌ chi ma güjtaman yabanman stijb. Rëbaman loj reeman: ―Jesús ruzat gajcan lojdi, laagajcaman na̱j Cristo din yabëëman dunuj ree loj dol. ");
INSERT INTO zasNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Yuꞌ ree bén Israel guin bililadx abiꞌ bachajg reeman Pab con Silas. Në zien ree bén grieg rën Dios bililadx, nëtëë zien ree béngunaa zojbloj bililadx Jesús. ");
INSERT INTO zasNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Per ree bén Israel ad bililadxt Jesucrist, gudëdloj reeman abiꞌ batoꞌp reeman benmal ziza ree lunejz persi gulëë reeman wadijl luguiedx guin, abiꞌ guyu reeman lidx Jasón, raguiil reeman Pab con Silas din cwëë reeman laa reeman guzuj reeman laa reeman loj ree bén guiedx guin. ");
INSERT INTO zasNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Per guial ad badxejlt reeman laa reeman yagaj, dxel guxoobyuj reeman Jasón në ree ben ren bén rliladx Jesucrist, binë reeman laa reeman loj guxtis, rbixdiaj reeman, rëb reeman: ―Tioꞌp ree xin cabëë wadijl guidib guidxliuj, ma biꞌt reex guie, ");
INSERT INTO zasNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","abiꞌ lidx Jasón zojb reex. Laa reex con gra ree bén nuchajg laa reex, ad cayüjnt reex ziꞌc rniabee xley rey César, din rëb reex guial yuꞌ zatijb rey la Jesús. ");
INSERT INTO zasNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Chi biguiejn ree guxtis guin zian con ree bejn, gra loj xgab been reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Per Jasón con los demazri ree bén guyu ladxguiib guin gudijx reeman loj ree guxtis guin, dxel baslaa reeman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Guxhinzii gajc, guxhaal ree bén rliladx Jesucrist Pab con Silas luguiedx Berea. Chi bidxin reeman ni, wej reeman lën xyadoo ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mazri benzaꞌc na̱j ree bén Israel guin guial loj ree bén Israel zojb Tesalónica. Con gan bacaagdiajg reeman ni rëb Pab. Abiꞌ guixie guixie rusiid reeman xtiidx Dios, din gagbee reeman waliqui ni rëb Pab ya. ");
INSERT INTO zasNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Zeel dád zien reeman bililadx Jesucrist, nëtëë zien bén grieg bililadx laaman ziꞌc ree xinguiaaw ziꞌc ree béngunaa zojbloj niz ni. ");
INSERT INTO zasNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Chi gogbee ree bén Israel zojb Tesalónica guial catieꞌch Pab xtiidx Dios luguiedx Berea, dxel wej reeman ni bigtiaalguiiw reeman bejn ree din guidxeꞌch reeman Pab. ");
INSERT INTO zasNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Per ree bén rliladx Jesucrist ad goglaat reeman, laa guxhaal gajc reeman Pab niz roꞌ nijsdoo. Guiáad Silas con Timoteo bayaꞌn reeman mazri Berea. ");
INSERT INTO zasNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Abiꞌ ree bén bigluꞌnejz Pab, xt Atenas binë reeman laaman. Chi baza reeman ni, bignë reeman xruson Pab din diob che Silas con Timoteo chinal reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Laꞌtgaj cabëz Pab guidxin Silas con Timoteo luguiedx Atenas, guyunayaman guial baguiaaman zien daꞌt ni rajp ree bejn niz ni ziꞌc dios. ");
INSERT INTO zasNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Zeel wejman lën xyadoo ree bén Israel bigneenëman laa reeman në los demazri ree bén rën Dios ziꞌc ree bén Israel, guixie guixie rnieenëman chutëëz bén rdxaaglojman niz galay guiedx guin. ");
INSERT INTO zasNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Guneenë tëëman garol ree bén zinal ni balüü bén brii laj epicureo, në za garol ree bén estoicos. Abiꞌ yuꞌ reeman rëb: ―¿Xhienin rniee xin guin zeel rniee daꞌtix? Yuꞌ tëë reeman rëb: ―Rulüü xtiidx dios ren ree bén ad naguieenbeet ree catieꞌchix. Rëb reeman zian guial caneenë Pab laa reeman xtiidxzaꞌc Jesucrist në xcwent guial babanman stijb. ");
INSERT INTO zasNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Dxel binë reeman Pab tijb luar la Areópago, lod radoꞌp reeman. Abiꞌ gunabdiidx reeman lojman, rëb reeman: ―¿Zajc nal ya xhie ree nicüb guin zidgalüül niz guie? ");
INSERT INTO zasNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Din rül diidx du lojn ni ad rayagbeetan, zeel rayënan yayagbeen xhie rën guiëban. ");
INSERT INTO zasNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Graczi ree bén Atenas, con los demazri ree benzit zojb ni, zianczi zaꞌ reeman zian. Ruladx reeman tëd reeman dxej, gucaagdiajg reeman o gü reeman ni na̱j ree nicüb. ");
INSERT INTO zasNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Dxel guzuli Pab galay reeman lod la Areópago, rëbaman: ―Bén Atenas, por graczi ni ma baguian, ma gogbeen guial dád zien ree xdiosidi. ");
INSERT INTO zasNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Abiꞌ chi zizaan ziquian luar lod rbejdxidi xdiosidi, badxejlan tijb luar lod ca ree diidx ni rëb: “Par Dios ad naguieenbeet ree.” Yan, Dios rbejdxidi sin guial ad nünbeetidi laaman, xtiidxaman na̱j ni zidguien lojdi. ");
INSERT INTO zasNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Dios guin been guidxliuj con graczi ni yuꞌ lojn, laaman rniabee xanyabaa në loj guidxliuj. Ad zaꞌtaman lën yadoo ni rüjn ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ad riaadx tëëtaman chu güün xhienin par laaman, din laaman na̱j bén razaladx bi nabajnnëꞌ ree, laaman razaladx guialnaban duloj ree në ree ni rayaadx ree. ");
INSERT INTO zasNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Por tijb bejn been Dios din chuꞌ zienloj bejn loj guidxliuj din cwe reeman guidib loj guidxliuj. Abiꞌ ma na̱j xhie tiamp guiban reeman ban tëë cwe reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Din yaguiil reeman Dios majsi ziꞌc chi rgan bejn chi raguiilaman xhienin, zian güün reeman din yadxejlaman. Majsi diidxliczi ad zijtt zaꞌman par gra bejn. ");
INSERT INTO zasNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Din por Dios nabajn ree, por laaman raniib ree radxoo tëë ree, por laaman nadxuꞌ ree loj guidxliuj. Ziꞌc rëb tëë ree xbénrigniaꞌdi, chi rëb reeman: “Dunuj ree nayajc xiꞌn Dios.” ");
INSERT INTO zasNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Zeel bal nayajc ree xiꞌn Dios, ad rayalt yaguieen ree xgab guial Dios najnë or, o plajt, o guiaj ya ziꞌc na̱j ni rüjn ree bejn ziꞌc na̱j xixgab reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Tiamp gulal cwëjb Dios been ree bejn ziꞌc naladx reeman guial achetczi ragbee reeman, per yan gra ladczi canabeeman gra ree bejn din yayüjn reeman xgab por xtol reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Din Dios ma gulej tijb dxej ni yadëëd ree bejn cwent lojman, dxej ni güün xguialguxtisaman. Ma gulej tëëman Jesucrist din güünman guialguxtis guin, abiꞌ din guiguien guial gulejman laaman par zian, basbanman laaman chi gütaman. ");
INSERT INTO zasNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Chi biguiejn reeman rëb Pab guial baban Jesucrist loj ree bengüt, yuꞌ reeman bazeꞌ laaman, yuꞌ tëë reeman rëb: ―¡Zatijb dxej yasnuu yacaagdiajgan ni canal! ");
INSERT INTO zasNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Dxel baza Pab lod zaꞌ reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Per yuꞌ reeman bachajg laaman, abiꞌ bililadx reeman xtiidx Dios. Loj reeman noꞌch tijb bén zojbloj lën Areópago laman Dionisio, në stijb béngunaa la Dámaris në ree ben ren. ");
INSERT INTO zasNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Dxel brii Pab Atenas zëman Corinto. ");
INSERT INTO zasNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Yagaj bidxaaglojman tijb bén Ponto laman Aquila, zëëdaman diaa Israel. Aquila con xbéngunaaman Priscila qui bazari reeman niz Italia guial gunabee rey Claudio yarii gra ree bén Israel Rom. Dxel wej Pab bitixlojman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Abiꞌ guial lasaꞌgajc dxiin ni rüjnman rüjn reeman, rüjnchaaw reeman guid ni rajc ree carp, dxel bayaꞌnnëman laa reeman persi been reeman dxiin guin. ");
INSERT INTO zasNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Abiꞌ beegaj dxej raziiladx ree bén Israel, rej Pab rigneeman xtiidx Dios lën xyadoo ree bén Israel, ziꞌc ree bén na̱j ree bén Israel ziꞌc ree bén ad najt bén Israel raguiilaman mod din chililadx reeman ni rëbaman. ");
INSERT INTO zasNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Chi baza ree Silas con Timoteo niz Macedonia, bidxin reeman Corinto, dxel achetri ni ren been Pab, ganaxzi xtiidx Dios guneeman loj ree bejn, balüü tëëman bén Israel ree guial Jesús na̱j Cristo bén cabëz reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Per guzuloj bidxeꞌch reeman Pab abiꞌ gunee reeman diidxguijdx contr laaman. Dxel gudxijp xabaman ziꞌc tijb sen guial ad ruzoobt reeman diidx, abiꞌ rëbaman loj reeman: ―Lëjt gajc rajp dol guial guizëëbidi delant loj Dios, ad najt raꞌp dol. Diizd yan chiguien xtiidx Dios loj ree bén ad najt bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Dxel bariiman lën yadoo guin wejman lidx bén la Justo, rën bén zii Dios, gajxh gajc yadoo guin na̱j lidxaman. ");
INSERT INTO zasNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Abiꞌ Crispo, tijb bén rniabee lën xyadoo ree bén Israel, bililadxaman Dad Jesucrist con gra xfamilaman. Në zien ree bén Corinto bililadx chi biguiejn reeman xtiidx Jesucrist abiꞌ gurobnijs reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Tijb guxhin balüüloj Dios loj Pab, rëbaman lojman: ―Ad rdxebil, basnuu gunee da diidxan, ad gucwëëzil, ");
INSERT INTO zasNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","naj zaꞌnëꞌ lüj, achutczi zajc güün lüj xhienin, din luguiedx guie zien daꞌt bejn na̱j par naj. ");
INSERT INTO zasNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Zianan zeel bayaꞌn Pab Corinto tibijz garol, balüüman bén guin ree xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Per chi goc Galión gobernador Acaya, bén Israel ree bachajg lasaꞌ reeman persi gunaaz reeman Pab binë reeman laaman loj gobernador guin, ");
INSERT INTO zasNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","rëb reeman loj gobernador guin: ―Xin guie ziza cayüjnx gan bejn ree guial guiën reeman Dios ziꞌc tijb mod ni ad najt loj ley. ");
INSERT INTO zasNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ma niniee Pab, chi gunee Galión rëbaman loj ree bén Israel guin: ―Bal niajcan tijb falt o tijb guialquia naroob beenman zeel zidnëdi laaman, züncwentan lëjt. ");
INSERT INTO zasNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Per najn por ree diidx në por laj ree bejn nëtëë por xleydi, zeel lëjt gajc gol gunaj xhienaag güündi, ad rëntan günan guialguxtis xcwent ree ni guin. ");
INSERT INTO zasNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Abiꞌ laa babëë gajcaman laa reeman roylay guin. ");
INSERT INTO zasNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Dxel yagaj gajc gunaaz gra reeman Sóstenes, bén rniabee lën xyadoo ree bén Israel abiꞌ gudijn reeman laaman, per niꞌquid beencwentt gobernador guin laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Zienri ree dxej bayaꞌn Pab Corinto. Dxel bazaadiidx nëman los demazri ree bén rliladx Jesucrist, abiꞌ bazanëman Priscila con Aquila, guyu reeman loj barcw zë reeman niz Siria. Per chi gad reeman grii Cencrea bagaj guijc Pab, por tijb promejs ni beenman. ");
INSERT INTO zasNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Chi bidxin reeman Éfeso, ni basaꞌn Pab Priscila con Aquila, abiꞌ wejman lën xyadoo ree bén Israel zojb ree ni, bigneenëman bén Israel radoꞌp ree lën yadoo guin. ");
INSERT INTO zasNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Abiꞌ guyën reeman niaglaa Pab ni mazri, per ad cwëjbtaman. ");
INSERT INTO zasNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Rëbaman loj reeman: ―Ma yayaꞌn, bal gagnë Dios naj, guidganan lëjt stijb. Dxel guyuman loj barcw bazaman Éfeso. ");
INSERT INTO zasNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Chi bidxinman Cesarea, dxel wejman Jerusalén bicajpdiozaman bén rliladx ree Jesucrist, dxelri zëman Antioquía. ");
INSERT INTO zasNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Chi ma gojc xchej zaꞌman Antioquía, dxel briiman zatijb. Wejman tijb gaj ree guiedx rigaꞌ niz Galacia në niz Frigia, raguꞌman luxdoo gra ree bén rliladx Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Tiamp zii bidxin tijb bén Israel luguiedx Éfeso, laman Apolos, gojlaman Alejandría. Dád radxejlaman diidx par guinieeman abiꞌ dád rajcaman xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Basiidaman xtiidx Dios, dxel con gan balüüman bejn ree, zagdxe tëë rüman xtiidx Jesús loj reeman, majsi ad ragbeetaman par xhieri mazri rirobnijs bejn, tijbzi xcwent xguial waroobnijs Waj ragbeeman. ");
INSERT INTO zasNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Abiꞌ Apolos, sin guialrdxeb guzuloj caneeman xtiidx Dios loj ree bén Israel lën xyadoo reeman, zianz chi biguiejn Priscila con Aquila ni rëbaman, dxel bignë reeman laaman lidx reeman. Ni balüü reeman laaman persi basnuu basiidaman mazri xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Chi been Apolos xgab cheman niz Acaya, gra ree bén rliladx Jesucrist bén zaꞌnë laaman, badxeꞌ reeman luxdooman din cheman, abiꞌ guxhaal reeman tijb guiꞌch loj ree bén rliladx Jesucrist bén zojb ree niz Acaya din yacaꞌ reeman laaman zagdxe chi guidxinman niz ni. Chi bidxinman niz Acaya dád beenman yudar bén ma rliladx ree Jesucrist guial gognë Dios laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Din delant loj gra ree bejn rëbaman guial ad laat zë ree bén Israel, abiꞌ achutczi gojc nadxiꞌ xtiidxaman guial graczi ni rëbaman na̱j diidxli, balüü tëëman loj xtiidx Dios gra luar lod rëb guial Jesús na̱j Cristo bén gulëjz reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Laꞌtgaj zaꞌ Apolos Corinto, wej Pab guiedx rigaꞌ ree niz ruguiaꞌ, abiꞌ bidxinman Éfeso, yagaj bidxaaglojman bëlzi ree bén rliladx Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Abiꞌ gunabdiidxaman loj reeman rëbaman: ―¿Guyu xSprijt Dios luxdoodi ya chi bililadxidi? Badxiꞌ reeman laan rëb reeman: ―Niꞌquid waguiejntan guial yuꞌ xSprijt Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Dxel rëb Pab loj reeman: ―¿Xhieza naag gurobnijsidi? Badxiꞌ reeman laan rëb reeman: ―Barobnijsan ziꞌc balüü Waj bejn ree. ");
INSERT INTO zasNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Dxel rëb Pab loj reeman: ―Walican baroobnijs Waj bejn, bén bayüjn ree xgab por xtol reeman. Per rëbaman guial rayal chililadx reeman bén zëëd xijchaman abiꞌ laaman na̱j Jesús, bén naj gajc Cristo. ");
INSERT INTO zasNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Chi biguiejn reeman zian, dxel gurobnijs reeman por Dad Jesús. ");
INSERT INTO zasNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Abiꞌ chi guxhoob yaa Pab guijc reeman, dxel guyu xSprijt Dios luxdoo reeman, zianz guzuloj canee reeman diidx ren ree. Dxel guzuloj cudëëd reeman xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Loj gra reeman na̱j cost chiptioꞌp xinguiaaw. ");
INSERT INTO zasNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Choon bëëw wej Pab lën xyadoo ree bén Israel zojb ni. Sin guialrdxeb guneenëman laa reeman xtiidx Dios, guneenëman laa reeman abiꞌ beenman naguiejn din güünman gan chililadx reeman xhienaag na̱j xguialrniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Per garol reeman gojc nad ad guyënt reeman nililadx reeman, al guzuloj gunee reeman diidxguijdx por xtiidx Jesucrist delant loj ree bejn. Dxel bariica Pab loj reeman con ree bén ma rliladx Jesucrist, binëman laa reeman lën tijb xzcuel bén la Tiranno. Ni balüüman laa reeman guixie guixie, ");
INSERT INTO zasNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","loj tioꞌp ijz beenman zian. Abiꞌ graczi ree bén zojb niz Asia, ziꞌc ree bén Israel ziꞌc ree bén ad najt bén Israel, bacaagdiajg reeman xtiidx Dad Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Abiꞌ por xguialrniabee Dios been Pab milagr naroob ree, ");
INSERT INTO zasNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","xt ree xbay Pab në ree lajd rtia lojman ziꞌc lantar rignë reeman loj ree bénragxuu, abiꞌ rayajc reeman guialguijdx ni rajc reeman, rarii tëë ree xindxab yuꞌ luxdoo reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Per guyu bëlzi ree bén Israel ziza rabëë reeman xindxab luxdoo ree bejn, abiꞌ guyën reeman nüjnnë reeman dxiin laj Dad Jesucrist dxel rëb reeman loj ree xindxab guin: ―¡Por Jesús bén ruzaꞌt Pab, rniabeen lëjt, gol barii! ");
INSERT INTO zasNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Zian na̱j ni been gajdx ree xiꞌngaan tijb bén Israel la Esceva, bén goc tijb bixhioz rniabee ree bixhioz. ");
INSERT INTO zasNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Per tib volt tijb ree xindxab guin badxiꞌ xtiidx reeman rëbaman: ―Nünbeen Jesús ragbee tëën chunin na̱j Pab, per lëjt niꞌquid nünbeetan lëjt. ");
INSERT INTO zasNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Abiꞌ bén yuꞌ xindxab guin luxdoo guzuloj caguinman laa reeman, con gojl ni yuꞌman beenman laa reeman gan. Dád gudijnman laa reeman abiꞌ baxüün reeman barii reeman lënü guin, ziladzi reeman nadxeelguijdx tëë reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Graczi ree bén zojb Éfeso, ziꞌc ree bén Israel ziꞌc ree bén ad najt bén Israel, gogbee reeman gojc zian, dxel dád bidxeb reeman abiꞌ bazaꞌt reeman Dad Jesús zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Në zien ree bén rliladx Jesucrist bidxin abiꞌ delant loj gra ree bejn baneeroꞌ reeman gra ni mal ma been reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Nëtëë zien ree bén been guialbidxaa bidxinnë xlibr reeman abiꞌ bazeꞌc reeman laa reen delant loj gra ree bejn. Chi babëë reeman cwent plac lasajc ree libr guin dxel cost tüꞌpchii mil milia plajt lasajc reen. ");
INSERT INTO zasNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Abiꞌ zian bireꞌch xtiidx Jesucrist biguien tëë xguialrniabeeman. ");
INSERT INTO zasNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Chi ma gudëd gojc zian, been Pab xgab cheman niz Macedonia në niz Acaya xt yadxinman Jerusalén. Rëb tëëman guial chi ma wejman Jerusalén dxelri cheman në Rom. ");
INSERT INTO zasNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Abiꞌ guxhaalaman tioꞌp bén rüjn laaman yudar, Timoteo con Erasto, persi wej reeman niz Macedonia laꞌtgaj bayaꞌnman mazri niz Asia. ");
INSERT INTO zasNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Lën ree dxej zii been ree bén Éfeso nadxeb por xtiidx Jesús. ");
INSERT INTO zasNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Din Demetrio, bén rüjn ree ni plajt, rüjnman figur plajt ni na̱j ree form xyadoo dios la Diana, ragbeeman guial dád rüjnman gan con ree bén rüjnnëman dxiin. ");
INSERT INTO zasNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Dxel batoꞌpaman laa reeman con ree ben ren bén rüjn gajc ree lasaꞌ dxiin guin, abiꞌ rëbaman loj reeman: ―Gol bacaagdiajg, lëjt ragbee guial loj dxiin guie raguieen ree gan milia roꞌ. ");
INSERT INTO zasNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Per yan lëjt ruguiaa riguiejn tëëdi, Pab ziza cayëbix guial dios ni rüjn ree bejn ad diost reen. Abiꞌ zian cayujnx gan caliladx zien ree bejn laax, ad tijbtizi luguiedx guie, në guidib niz Asia. ");
INSERT INTO zasNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Dxel nadxeb yasëëb dux chiin ree, abiꞌ ad tijbtizi dux chiin ree, në xyadoo dios Diana ad zayagbeetri ree bejn laan ziꞌc nünbee reeman laan yan abiꞌ achutri guidxgaꞌ xguialrniabee dios Diana, bén rën ree bejn guidib niz Asia në guidib loj guidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Chi biguiejn reeman zian, bidxeꞌch reeman abiꞌ gurixdiaj reeman rëb reeman: ―¡Bén zojbloj na̱j Diana, xdios ree bén Éfeso! ");
INSERT INTO zasNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Abiꞌ gurixdiaj ree bén guiedx guin wajs reeman, gunaaz reeman tioꞌp ree bén Macedonia, Gayo në Aristarco, bén rzanë ree Pab. Dxel guxoobyuj reeman laa reeman, binë reeman laa reeman lod rajc xgabilt ree bén guiedx. ");
INSERT INTO zasNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Guyën Pab niuman yagaj din ninieenëman bejn ree, per ad cwëjbt ree xcompniaraman, bén ma rliladx ree Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Nëtëë loj ree guxtis Asia guin noꞌch bëlzi ree xmiw Pab, laa reeman guxhaal ruson lojman guial mejorli ad chuꞌman ni. ");
INSERT INTO zasNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Zianz gurixdiaj ree bén guin rëb reeman ni rent ni ren, been reeman nadxeb abiꞌ zien reeman niꞌquid ragbeet par xhie badoꞌp reeman yagaj. ");
INSERT INTO zasNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Dxel galay ben zien guin babëë ree bén Israel tijb xcompniar reeman bén la Lejandr din guinieenëman bén guin ree. Dxel beenman sen loj ree bén guin din yacwëëz roꞌ reeman din guinieeman por ree bén Israel delant loj ree bén guiedx guin. ");
INSERT INTO zasNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Per chi gogbee reeman guial najman bén Israel, tiblazujzi gurixdiaj reeman cost tioꞌp hor, rëb reeman: ―¡Bén zojbloj na̱j Diana, xdios ree bén Éfeso! ");
INSERT INTO zasNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Dxel chi been squiarban luguiedx guin gan bacwëëz roꞌ reeman, dxel rëbaman: ―Bén Éfeso, gra bénguidxliuj ragbee guial luguiedx guie zianczi rniaj ree bejn xyadoo dios Diana abiꞌ rën tëë ree bejn dios Diana biajb xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Lëjt ragbee guial laan na̱j ni diidxli, zeel ad rayalt güündi zian, ad gontzi güündi xhienin sin xgab. ");
INSERT INTO zasNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Din bén bidnëdi achet ni mal been reeman yadoo guin, ad wanee tëët reeman diidxguijdx dux dios ree. ");
INSERT INTO zasNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Bal Demetrio con ree xcompniaraman bén rüjnnëman dxiin rajp reeman wadijl con ree ben ren, laa roylay na̱j, laa ree guxtis yuꞌ, ni che reeman chitawquia reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Per bal xhieri mazri rëndi, chi gac xgabilt bén guiedx dxel gacan reglad. ");
INSERT INTO zasNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Yan, por ni ma gojc, nadxeb na gobiarn guial dunuj ree cayluꞌ ree bejn diidx din güün reeman wadijl guin, ¿abiꞌ xhieza yaguieꞌch ree loj reeman bal guiniabdiidx reeman duloj ree xcwent ree ni cayajc? ");
INSERT INTO zasNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Chi gulox rëbaman zian, dxel bareꞌch reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Chi babedxe ree bén Éfeso, gurejdx Pab bén rliladx ree Jesucrist persi baguꞌman luxdoo reeman. Dxelri bazaadiidxnëman laa reeman abiꞌ zëman niz Macedonia. ");
INSERT INTO zasNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Bitixlojman bén rliladx ree Jesucrist guidib niz ni, dád baguꞌman luxdoo reeman con xtiidxaman, dxelri bidxinman Grecia ");
INSERT INTO zasNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","lod guzuman choon bëëw. Ma niuman loj barcw din niejman Siria, chi gogbeeman guial nuyën ree bén Israel nüjn reeman laaman xhienin. Dxel mejorli beenman xgab bayejcaman niz Macedonia. ");
INSERT INTO zasNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Binëman Sópater, bén Berea, xiꞌngaan Pirro, në Aristarco con Segundo, bén Tesalónica ree, nëtëë Gayo, bén Derbe, con Timoteo, në Tíquico con Trófimo, bén niz Asia ree. ");
INSERT INTO zasNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Gra reeman guned abiꞌ gulëjz reeman Pab con naj Lujc guiedx Troas. ");
INSERT INTO zasNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Guiáad dunujn chi gudëd lanij ni raw ree bén Israel guiadxtil ni ad yuꞌt levadur, dxel badxuꞌn loj barcw badxoon Filipos, abiꞌ ni goc gaay dxej badxinan guiedx Troas lod zaꞌ reeman. Ni badxuꞌn gajdx dxej. ");
INSERT INTO zasNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Chi bidxin chidumingw, badxajg du lasaꞌn din yadaawan guiadxtil tijbzi, abiꞌ guial mal been Pab xgab guial yareguiaal griiman, chi bidxin garol guiaal sta caneenëman bejn ree, ");
INSERT INTO zasNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","guiáad lënü ladya lod radoꞌpan dád zien ree guij reꞌc. ");
INSERT INTO zasNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Tijb xinguiag zojb roꞌ ventan lax Eutico. Guial xchej daꞌt guneenë Pab laa reeman, dxel xt garej gunaaz bacaal xin guin, abiꞌ gudidyaꞌx diizd yu bayon guin xt luyuj, ma güjtix chi bales reeman laax. ");
INSERT INTO zasNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Dxel biguiajt Pab lod nagaꞌx, bazuxibaman abiꞌ gudiidxaman laax, dxel rëbaman loj reeman: ―Ad rdxebidi, nabanquix. ");
INSERT INTO zasNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Dxel bayëꞌp Pab zatijb, gulaꞌman guiadxtil abiꞌ gudaw reeman, dxel basnuu guneenëman laa reeman xt bareguiaal. Chi bareguiaal bayunejzaman ziaman. ");
INSERT INTO zasNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Abiꞌ xin gudidyaꞌ roꞌ ventan guin, nabanx zignë reeman laax, dxel dád nix yuꞌ luxdoo reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Dxel dunujn badxuꞌn loj barcw baneedan bioꞌn par luguiedx Asón, lod bayaꞌnan diidx yacaꞌn Pab, din beenman xgab niej guiaꞌman ni. ");
INSERT INTO zasNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Chi badxajg du lasaꞌn con laaman luguiedx Asón, dxel badxuꞌnëꞌn laaman loj barcw bioꞌn lod la Mitilene. ");
INSERT INTO zasNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ni badxoon, chi bareguiaal badüüdan niz lod la Quío. Chi bareguiaal stijb badxinan lod la Samos. Dxel chi bareguiaal stijb badxinan Mileto, per chi gad yagaj guidxin badxuꞌdxen lod la Trogilio. ");
INSERT INTO zasNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Been Pab xgab ad zejtaman Éfeso, ad guyëntaman niaglaaman niz Asia guial nuyënman diob nadxinman Jerusalén, din xixgabaman na̱j guial bal zajc yadxinman lanij Pentecostés. ");
INSERT INTO zasNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Chi nadxuꞌn Mileto, gunabee Pab biꞌt ree bén rniabee loj ree bén rliladx Jesucrist, bén zojb ree Éfeso. ");
INSERT INTO zasNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Chi bidxin reeman dxel rëbaman loj reeman: ―Diizd dxej yaloj ni bialan niz Asia xt yan, lëjt ragbee xhienaag cayünan. ");
INSERT INTO zasNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Loj guidib tiamp ni zaꞌnëꞌn lëjt cayünan sirv Jesucrist con pasens, majsi xt ronan abiꞌ gra loj guialzi ma gudëëdan por ni rën ree bén Israel güünnë reeman naj. ");
INSERT INTO zasNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Per majsi zian ad bacwëëzt rnin lojdi ni na̱j ni zagdxe par lëjt, tant delant loj ree bejn në lidxidi balün lëjt. ");
INSERT INTO zasNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Abiꞌ ziꞌc ree bén Israel në ree bén ad najt bén Israel, ma rën loj reeman din yayüjn reeman xgab por xtol reeman yadxiꞌ tëë loj reeman loj Dios chililadx tëë reeman Dad Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Yan ma yayaꞌn Jerusalén lod caxhaal xSprijt Dios naj, ad ragbeetan xhie cabëz naj ni. ");
INSERT INTO zasNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Tijbzi ni ragbeen na̱j guial guidib lod ran rugojn xSprijt Dios naj guial ladxguiib në zroꞌ daꞌt guialzi na̱j ni cabëz naj. ");
INSERT INTO zasNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Per par naj achet güünan por zian, majsi guiëtan per con nix yuꞌ luxdon cayünan ni rayal günan xt lod gactizan, gün tëën mandad ni banee Dad Jesús naj guial gatiechan xtiidxzaꞌcaman xhienaag rën Dios dunuj ree. ");
INSERT INTO zasNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’Yan naj ragbee guial niꞌqui tijbidi bén ma ben diidx loj xhienaag na̱j xguialrniabee Dios, ad zuguiaatridi naj. ");
INSERT INTO zasNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Zeel ganin lojdi yan guial ad achetri dol raꞌpan bal id nabandi xnejz. ");
INSERT INTO zasNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Din ma bagojnan lëjt gra xhienaag na̱j xixgab Dios achetczi baquiechan. ");
INSERT INTO zasNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Yan, gol gojp lëjt gajc, gol gojp tëë ree bén rliladx Jesucrist, bén ma banee xSprijt Dios lojdi din guiniadi laa reeman ziꞌc tijb bén rajp xiil ree, din Jesucrist con xrejnman ma gudijxaman por xtol reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Naj ragbee guial chi yazaan guiꞌt ree ben ren ziꞌc gajczi rtieꞌch cuyojt xiil ree, zian na̱j xixgab reeman güünnë reeman bén rliladx ree Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Loj gajquidi grii ree bén gulüü ganax ni rusquiee, din güün reeman gan güüncwent ree bén rliladx Jesucrist xtiidx reeman luar güüncwent reeman xtiidx Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Zeel gol guzujsin, gol gojp cudad, gol basaaladx, loj choon ijz ad bacwëëzt gunenëꞌn lëjt xt ronan banen lëjt consejw. ");
INSERT INTO zasNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","’Yan, compniar raliduladx ree Jesucrist, gusaꞌnan lëjt con Dios con xtiidxzaꞌcaman. Laan rajp guialrniabee par gagnën lëjt, din gusnuu gagbeedi xhienaag rënman guibandi gunee tëëman lojdi ni ma rëbaman gudëëdaman loj ree bén ma na̱j xbejnman. ");
INSERT INTO zasNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Achut xmilia achu tëët xab rzëëbladxan. ");
INSERT INTO zasNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Lëjt ragbee zagdxe guial con quijb yan benan dxiin persi gudawnëꞌn bén guzu ree con naj. ");
INSERT INTO zasNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Abiꞌ balün lëjt guial zian rayal güün bejn dxiin din güünman yudar bén ryaadx ree xhienin. Gol basaaladx xtiidx Dad Jesús chi rëbaman: “Mazri nix yuꞌ luxdoo bén razaladx guial loj bén rtiaꞌ.” ");
INSERT INTO zasNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Chi gulox rëb Pab zian, dxel bazuxibaman gurejdx gunabaman Dios con gra reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Gra reeman biin, gudiidx reeman Pab abiꞌ gudaw reeman laaman xid. ");
INSERT INTO zasNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Dád guyunaya reeman por ni rëbaman loj reeman guial ad zuguiaatri reeman laaman. Dxel bigluꞌnejz reeman laaman xt lod zaꞌ barcw. ");
INSERT INTO zasNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ni basaꞌnan laa reeman, abiꞌ badxuꞌn loj barcw bioꞌn tibli niz Cos, yuj rigaꞌ loj nijsdoo. Chi bareguiaal badxinan niz Rodas nëgajcan rigaꞌ loj nijsdoo, abiꞌ ni badxoon bioꞌn guiedx Pátara. ");
INSERT INTO zasNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ni badxaaglojn tijb barcw ni ma che niz Fenicia zianz badxuꞌn lojn. ");
INSERT INTO zasNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Chi zioꞌn dxel dux lad ruvejsan baguiaan lod la Chipre, basnuu bioꞌn niz Siria. Abiꞌ guial na̱j lat barcw guin luguiedx Tiro dxel badxuꞌn luguiedx guin. ");
INSERT INTO zasNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ni badxaaglojn bén rliladx ree Jesucrist abiꞌ badxuꞌnëꞌn laa reeman gajdx dxej. Bén guin ree por xSprijt Dios rëb reeman loj Pab guial ad bal cheman Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Per chi bazaꞌ gajdx dxej guin, dxel badxoon luguiedx guin, dxel gra reeman con xbéngunaa reeman con xiꞌn reeman, bigluꞌnejz reeman dunujn xt roꞌ nijsdoo. Roꞌ nijs guin badxuꞌxiban barejdx banaaban Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Dxel bazaadiidxnëꞌn laa reeman abiꞌ badxëꞌpan loj barcw guiáad laa reeman zia lidx reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Chi badxoon luguiedx Tiro bioꞌn luguiedx Tolemaida, ni gulox dux viajn loj barcw, bioꞌ tëën bugneenëꞌn bén zojb ree ni, bén rliladx ree Jesucrist abiꞌ bayaꞌnan con laa reeman tib dxej. ");
INSERT INTO zasNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Chi bareguiaal, dunujn con Pab badxoon Tolemaida bioꞌn Cesarea lod bioꞌn lidx Felip, bén rtieꞌch xtiidx Jesucrist. Felip guin na̱j tijb ree bén gajdx cwabee din quiꞌs reeman ni rayal tiaꞌ ree bénprob abiꞌ bayaꞌnan lidxaman. ");
INSERT INTO zasNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Yuꞌ tajp xiꞌndxaꞌpaman biinxtijb ree abiꞌ laa reem rudëëd xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ma gojc zien dxej nadxuꞌn lidx Felip, chi biꞌt tijb bén la Agabo nëgajcaman rudëëd xtiidx Dios loj ree bejn, zëëdaman niz Judea. ");
INSERT INTO zasNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Chi biꞌtaman cwaꞌman xcinch Pab guxhii guiaꞌ gajcaman con yaaman, abiꞌ naman: ―XSprijt Dios na guial Jerusalén ze guixhii ree bén Israel bén na̱j xcinch ni guie, abiꞌ yayü reeman laaman loj ree bén ad najt bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Chi baguiejnan zian, dunujn con ree bén rliladx Jesucrist luguiedx guin baguieenan naguiejn loj Pab ad cheman Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Per badxiꞌman laan, naman: ―¿Chexc zeel roondi abiꞌ rguꞌ nayadi naj? Par naj achet güünan majsi guixiin o majsi guiëtan Jerusalén por Dad Jesús. ");
INSERT INTO zasNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Chi bayagbeen guial ad zaguieentan gan yadxoonan laaman chitëë cheman, achetri baguieꞌchan lojman, tijbzi ni raguieꞌchan lojman: ―Gac ziꞌc rniabee Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Chi gudëd ree dxej guin dxel baguieenan purvinid bioꞌn Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Bunëꞌn bëlzi ree bén Cesarea rliladx ree Jesucrist, laa reeman binë dunujn lod bayaꞌnan lidx tijb bén Chipre, ma gojc xchej rliladxaman Jesucrist, laman Mnasón. ");
INSERT INTO zasNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Abiꞌ ree bén Jerusalén rliladx Jesucrist dád nix guyu luxdoo reeman bacaꞌ reeman dunujn. ");
INSERT INTO zasNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Chi bareguiaal bunëꞌn Pab bugnajn Jacob, ni rigaꞌ gra ree bén rniabee loj ree bén rliladx Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Chi gulox bagajpdiozan laa reeman, dxel bagojn Pab laa reeman tijb gaj ni beenman por xguialrniabee Dios delant loj ree bén ad najt bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Chi biguiejn reeman zian, bazaꞌt reeman Dios zagdxe, zianz rëb reeman loj Pab: ―Lüj ragbee guial entr loj ree bén Israel zien daꞌt reeman ma bililadx Jesucrist, abiꞌ gra reeman rëb guial rüjn naguiejn güün bejn ziꞌc rniabee xley Moisejs. ");
INSERT INTO zasNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ma biguiejn tëë reeman guial lüj culüü bén Israel ree, bén ad zojbt ree loj nacion Israel guial ad züjncwentt reeman xley Moisejs, rëb tëël loj reeman guial ad rüjnt naguiejn chuꞌ xiꞌn reeman sen ru ree bén Israel ad zinal tëët reeman dux costumbr ree. ");
INSERT INTO zasNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Yan, ¿xhienaag gac? Laa reeman guchajgczi lasaꞌ reeman chi gagbee reeman guial ma biꞌtil. ");
INSERT INTO zasNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Zeel mejorli güünl ze: Yuꞌ tajp ree xin noꞌch du lojn xin rayal ree güün cumplid ni cwëb reex loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Binë reex, gol been ziꞌc rëb loj ley din gaquidi naya, gudijx tëë por laa reex din gac ya guijc reex. Zian gagbee gra bejn guial rüjnquil ziꞌc rniabee ley, guial ad wali tëët ni biguiejn reeman xcwentil. ");
INSERT INTO zasNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Abiꞌ por ree bén ad najt bén Israel, bén ma bililadx ree Jesucrist, ma baxhaalan tijb guiꞌch loj reeman ziꞌc baguieenan xgab guial ad rayalt chuꞌ reeman xgab por xley Moisejs. Per ad rayalt gaw reeman ni rbej loj ni na̱j ree xdios reeman, ad gaw tëë reeman rejn niꞌqui bëël rberejn, ad sunë tëë reeman ben ren bén ad najt lacheel reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Dxel binë Pab guidap ree bén guin, abiꞌ chi bareguiaal been reeman ziꞌc rniabee ley par gac reeman naya. Dxel guyu reeman lën yadooroꞌ Jerusalén din gugojn reeman goc yayaaloj dxej güün reeman ziꞌc rniabee ley, dxej rayal chinë tijb gaj reeman tijb be guiët ziꞌc tijb gon par Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Chi ma yayaaloj gajdx dxej ni na̱j güün reeman ziꞌc rniabee ley, yuꞌ ree bén Israel zëëd niz Asia, baguiaa reeman Pab lën yadooroꞌ Jerusalén abiꞌ gurixdiaj reeman wajs reeman, gunaaz reeman laaman, ");
INSERT INTO zasNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","rëb reeman: ―¡Bén Israel, gol been yudar! Xin guie na̱j xin ziza gra lad caneeguijdxix bén Israel ree në dux yadoo ree, rëb tëëx loj ree bejn guial ad güün reeman ziꞌc rniabee dux ley ree. Abiꞌ ad tijbtzi laan, në ma badxeꞌx bén ad najt ree bén Israel lën dux yadoo ree ni na̱j ni nada par dunuj ree ma beenx laan ziꞌc tijb luar ad rüjnt sirv. ");
INSERT INTO zasNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Rëb reeman zian guial baguiaa reeman Pab zizaman ni con tijb bén Éfeso bén la Trófimo, zeel gunaladx reeman binë Pab laaman lën yadooroꞌ Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Dxel been reeman nadxeb guidib luguiedx guin, ruxüün ree bejn bidxin reeman. Abiꞌ gunaaz reeman Pab, guxoobyuj reeman laaman babëë reeman laaman lën yadoo guin laa basiaaw gajc reeman port guin ree. ");
INSERT INTO zasNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Za mer nugüjt reeman laaman, chi bidxin ruson guin loj suldad rniabee ree suldad guial gra ree bén Jerusalén cayüjn nadxeb. ");
INSERT INTO zasNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Laa batoꞌp gajc suldad rniabee guin xsuldadix në za tioꞌp choon ree suldad rniabee, baxüün reex wej reex lod rigaꞌ ree bén guin. Chi baguiaa ree bén guin bidxin suldad rniabee guin con ree xsuldadix, dxel bacwëëz gudijn reeman Pab. ");
INSERT INTO zasNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Dxel gubig suldad rniabee guin, gunaazix Pab gunabeex guxhii reex laaman con tioꞌp caden. Abiꞌ gunabdiidxix chu laaman xhie tëë beenman. ");
INSERT INTO zasNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Per gurixdiaj reeman rëb reeman garent garen, guial rbixdiaj daꞌt reeman achet gojc niagbeex, dxel gunabeex bignë reex Pab lod yuꞌ ree suldad. ");
INSERT INTO zasNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Chi bidxin reex loj ree scliar lod yuꞌ ree suldad guin, gulejn reex Pab guial dád nadoxh rüjn ree bén zien nal laa reex, ");
INSERT INTO zasNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","abiꞌ gra reeman rbixdiaj, rëb reeman: ―¡Gol bagüjtix! ");
INSERT INTO zasNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Chi ma chuꞌnë reex Pab lod yuꞌ ree suldad guin, gunabdiidxaman loj suldad rniabee guin, rëbaman: ―¿Zajc ganenëꞌn lüj ya? Badxiꞌ suldad guinan rëbix: ―¿Rajc rnieel diidx grieg ya? ");
INSERT INTO zasNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Nid lüj na̱j xin Egipto guzu contr gobiarn ya, abiꞌ laa bigxüün gajquil niz loj yujbidx con tajp mil ree xbejnl, bén bagüjt ree bejn? ");
INSERT INTO zasNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Dxel rëb Pab lojx: ―Bén Israel naj. Goolan luguiedx Tarso tijb ree guiedx zojbloj ni rigaꞌ niz Cilicia. Baneesii mod ganenëꞌn bén guie ree. ");
INSERT INTO zasNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Dxel cwëjb suldad guin, abiꞌ guzuli Pab loj ree scliar guin beenman sen loj ree bén guin con yaaman din yacwëëz roꞌ reeman. Chi bacwëëz reeman, dxel guneenëman laa reeman diidx hebreo, rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","―Lëjt bengol në los demazridi, gol bacaagdiajg ni ganin por naj. ");
INSERT INTO zasNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Chi biguiejn reeman caneenëman laa reeman diidx hebreo, mazri bacwëëz reeman. Abiꞌ basnuuman rëbaman loj reeman: ");
INSERT INTO zasNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","―Bén Israel naj. Goolan luguiedx Tarso tijb guiedx rigaꞌ niz Cilicia, per Jerusalén guie guniꞌsan. Abiꞌ mextr Gamaliel balüü naj gra ziꞌc na̱j xley dux bén gulal ree. Guiáad naj guidib luxdon benan xgab güünan sirv Dios ziꞌcgajc lëjt yan. ");
INSERT INTO zasNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Dxel guzunaalan bén rliladx ree Jesucrist, xt bagüjtan laa reeman abiꞌ ziꞌc ree béngunaa ziꞌc ree xinguiaaw gunaazan badxeꞌn ladxguiib. ");
INSERT INTO zasNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Bixhioz mazri zojbloj rniabee graczi ree bixhioz në gra ree guxtis Israel ragbee guial najn ni wali. Din laa reeman banee tijb guiꞌch par gulün loj du lasaꞌ bén Israel ree, bén zojb ree luguiedx Damasco din chileꞌ yaguilan bén rliladx ree Jesucrist luguiedx guin, ganaaz tëën laa reeman guidnëꞌn laa reeman Jerusalén din tëd reeman casti. ");
INSERT INTO zasNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","’Per chi zaꞌn lunejz par Damasco, chi ma cadxinan ni cost garol dxej, dxejczi brii tijb guij xanyabaa balaan bachaꞌ guidibczi lod cazaan, ");
INSERT INTO zasNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","abiꞌ breeyujn. Dxel biguiejnan chaꞌ bén na: “Saulo, Saulo, ¿chexquiza zeel rzunalil naj?” ");
INSERT INTO zasNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Abiꞌ gunabdiidxan rën: “¿Chu lüj Dad?” badxiꞌman laan naman: “Naj na̱j Jesús, bén Nazaret, bén rzunalil.” ");
INSERT INTO zasNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bén zinëꞌ reen baguiaa reeman bachaꞌ guin abiꞌ bidxeb reeman, per ad bigniaꞌt reeman ni na chaꞌ bén gunee naj. ");
INSERT INTO zasNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Dxel gunabdiidxan rën: “¿Xhie rayal günan Dad?” Abiꞌ na Dad Jesucrist lon: “Bixche, basnuu xnejzil wej Damasco. Ni na reeman gra ni rayal güünl.” ");
INSERT INTO zasNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Abiꞌ guial bascajy bachaꞌ guin lon, dxel bén zinëꞌ reen gunaaz reeman yan, binë reeman naj luguiedx Damasco. ");
INSERT INTO zasNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","’Ni zojb tijb bén la Ananías, rüjnman cumplid gra ziꞌc rniabee xley Moisejs. Abiꞌ gra ree bén Israel zojb luguiedx Damasco nünbee laaman guial nabanman xnejz. ");
INSERT INTO zasNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ananías guin bidganaj naj, chi biꞌtaman naman lon: “Saulo, ma zajc yaguiaal stijb.” Loj hor guin gajc baguian stijb abiꞌ baguian laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Dxel naman lon: “XDios dux béngulal ree ma bacaabee lüj din gagbeel xhie rënman güünl, abiꞌ guguiaal Jesucrist guien tëël chaꞌman, bén rüjn ziꞌc rayal. ");
INSERT INTO zasNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Din chigneel xtiidxaman loj gra ree bénguidxliuj, gü tëël diidx loj reeman ni baguiaal ni biguiejn tëël. ");
INSERT INTO zasNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Yan, ad rbëzil mazri, guzuli gurobnijs tëë gurejdx gaj Dad Jesucrist din chisüdaman xtolil.” ");
INSERT INTO zasNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","’Chi baguialan Jerusalén, wan lën yadooroꞌ persi guredx gunaaban Dios, abiꞌ guzaꞌcan ziꞌc rulüü caneꞌxhchalan. ");
INSERT INTO zasNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Baguian Dad Jesús naman: “Baquiejn. Cari barii Jerusalén, din ad züjncwentt reeman ni guiëbil por naj.” ");
INSERT INTO zasNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Abiꞌ rën lojman: “Dad, laa reeman ragbee guial naj wa gra lën ree yadoo gunaazan bén rliladx ree lüj, badxeꞌn laa reeman ladxguiib gudin tëën laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Në chi bagüjt reeman Esteban, bén gunee xtiidxil, laagajc naj zaꞌ ni rën zagdxe na̱j guiëtaman abiꞌ xt gunan xab ree bén bagüjt laaman.” ");
INSERT INTO zasNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Per na Dad Jesús lon: “Wej, naj gaxhal lüj zijt loj ree bén ad najt bén Israel.” ");
INSERT INTO zasNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Xt guintzi nagaꞌloj bacaagdiajg reeman ni rëb Pab dxel guzuloj gurixdiaj reeman rëb reeman: ―¡Ad rayalt guiban xin guin! ¡Gol bagüjtix! ");
INSERT INTO zasNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Abiꞌ guial cabixdiajz cabixdiaj reeman, ruzaal xab reeman niz ladia ruzaal tëë reeman yuj niz ladia. ");
INSERT INTO zasNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Dxel gunabee suldad rniabee guin cuꞌ reeman Pab lod yuꞌ ree suldad abiꞌ gunabeex quiꞌn reex laaman din yaneeroꞌman chexc zeel rbixdiaj ree bén guin zian contr laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Per chi guxhii reex Pab din quin reex laaman, rëbaman loj tijb ree suldad rniabee zaꞌ ni: ―¿Zajc quindi tijb bén Rom ya, chi gadidi gagbee xhie beenman? ");
INSERT INTO zasNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Chi biguiejn suldad rniabee guin zian, dxel bicojnx suldad rniabee ree suldad guin, rëbix lojx: ―Gojp cudad ni güünnël xin guin, din xin Roman. ");
INSERT INTO zasNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Dxel wej suldad rniabee guin lod zaꞌ Pab, abiꞌ gunabdiidxix lojman rëbix: ―¿Walin ya xin Rom lüj? Badxiꞌ Paban rëbaman: ―Walican. ");
INSERT INTO zasNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Abiꞌ rëb suldad rniabee guin lojman: ―Naj zroꞌ milia gudixan par gacan xin Rom. Abiꞌ badxiꞌ Paban rëbaman: ―Per naj diizd goolan najn bén Rom. ");
INSERT INTO zasNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Chi biguiejn ree suldad niguin Pab, guial bén Rom najman, laa bisüd gajc reex. Xt në suldad rniabee guin bidxeb chi gogbeex guial ben Rom na̱j Pab guial gunabeex guxhii reex laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Chi bareguiaal, guyën suldad rniabee guin niagbeechaawix chexc zeel zaꞌ ree bén Israel contr Pab. Abiꞌ baxhiequix Pab, dxel gunabeex badoꞌp ree bixhioz rniabee ree bixhioz në ree guxtis. Abiꞌ babëëx Pab bazujx laaman loj gra reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Baguiaa Pab loj ree guxtis guin, abiꞌ rëbaman: ―Compniar Israel, loj guidib ni nabanan xt yan, achet naladxan delant loj Dios din naj ragbee xhienaag nabanan. ");
INSERT INTO zasNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Dxel Ananías, bixhioz mazri zojbloj rniabee graczi ree bixhioz, gunabeeman bén zaꞌ ree gajxh cwëꞌ Pab din caꞌp reeman roꞌman. ");
INSERT INTO zasNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Per badxiꞌ Paban rëbaman loj bixhioz guin: ―¡Ziangajc caꞌp Dios roꞌl, bén rusquiee! ¿Id zojbil yagaj ya par güünl guialguxtis ziꞌc rniabee ley? Abiꞌ ¿chexquiza zeel rüjnl ziꞌc ad rniabeet ley, rniabeel caꞌp reeman roꞌn? ");
INSERT INTO zasNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Abiꞌ ree bén zaꞌ yagaj rëb reeman lojman: ―¿Zian rusaglojl xbixhioz zojbloj Dios ya? ");
INSERT INTO zasNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Dxel rëb Pab: ―Gol been perdon, ad gogbeetan guial laaman na̱j bixhioz mazri zojbloj. Din loj xtiidx Dios rëb: “Ad gusaglojl bén rniabee ladxil.” ");
INSERT INTO zasNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Chi gogbee Pab guial garol reeman na̱j bénsaducew za garol reeman na̱j bénfarisew, dxel guneeman rejs rëbaman: ―Naj na̱j bénfarisew, xiꞌn bénfarisew naj. Abiꞌ guial rliladxan yaban ree bengüt zeel zaꞌ ree bejn contr naj. ");
INSERT INTO zasNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Chi rëbaman zian, guzuloj cadildiidx ree bénfarisew con ree bénsaducew abiꞌ gojc reeman tioꞌp lalaꞌ. ");
INSERT INTO zasNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Din bénsaducew ree ad rliladxt reeman guial yaban ree bengüt, ad rliladx tëët reeman guial yuꞌ ree anjl në ree sprijt, per ree bénfarisew rliladx reeman gra ree ni guin. ");
INSERT INTO zasNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Abiꞌ been reeman naquieꞌ yagaj. Dxel guzuli bëlzi ree bénfarisew na̱j mextr rulüü ley, rëb reeman: ―Achet ni mal wayüjn bén guie. Wed tijb sprijt o tijb anjl gunee laaman, gol gojp cudad ad niad contr Diosan nadxuꞌ ree. ");
INSERT INTO zasNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Chi baguiaa suldad rniabee guin mazri cadildiidx reeman, dxel bidxebix nuroox reeman Pab. Abiꞌ gunabeex biꞌt ree suldad din yabëë reex laaman galay ree bén guin, chinë tëë reex laaman lod yuꞌ ree suldad stijb. ");
INSERT INTO zasNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Chi gure guiaal stijb, balüüloj Jesucrist loj Pab, rëbaman lojman: ―Baguꞌ luxdool Pab, din ziꞌc guneel por naj luguiedx Jerusalén guie, ziangajc guinieel por naj luguiedx Rom. ");
INSERT INTO zasNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Chi bareguiaal, garol ree bén Israel bayaꞌn reeman diidx din gugüjt reeman Pab, rëb tëë reeman guial achet gaw reeman achet tëët guiëꞌ reeman xt gugüjt reeman laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Nadëd tiuu na̱j ree bén rëb zian. ");
INSERT INTO zasNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Abiꞌ wej reeman bigneenë reeman bixhioz ree bén rniabee ree bixhioz në ree xbengol ree bén Israel, rëb reeman loj reeman: ―Dunujn ma raguieꞌch guial achetczi yadaawan xt chi ma bagüjtan Pab. ");
INSERT INTO zasNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Yan lëjt con gra ree guxtis, gol gunab loj suldad rniabee guin din guidnëx laax lojdi guixie, con gol badxiib guijc guial rëndi gagbeechaawidi xhienaag na̱j xcwentix. Abiꞌ dunujn ma yadxuꞌsinan din yagüjtan laax chi gadix guiꞌt guie. ");
INSERT INTO zasNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Per xiꞌngaan bizan Pab biguiejnx guial cayëb reeman zian, dxel wejx lod yuꞌ ree suldad bicojnx Pab. ");
INSERT INTO zasNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Zianz gunee Pab tijb ree suldad rniabee guin, rëbaman lojx: ―Binësii xin guie loj suldad rniabee din gudëëx tijb ruson lojman. ");
INSERT INTO zasNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Binë xin suldad guin laax loj suldad rniabee guin, rëbix lojx: ―Pab, xin yuꞌ ladxguiib guredx naj abiꞌ gunabix guidnëꞌn xin guie lojl din guneex tijb ruson lojl. ");
INSERT INTO zasNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Abiꞌ suldad rniabee guin gunaazix yaa xin guin, binëx laax tiblad, gunabdiidxix lojx rëbix: ―¿Xhie rënl nal lon? ");
INSERT INTO zasNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Abiꞌ rëb xin guin lojx: ―Bén Israel ree ma bayaꞌn reeman diidx din guiniab reeman lojl guixie din chinël Pab loj ree guxtis, con gudxiib reeman guijc guial rën reeman gagbeechaaw reeman xhienaag na̱j xcwentaman. ");
INSERT INTO zasNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Per ad bal chililadxil laa reeman, din nadëd tiuu na̱j ree bén cwëz laaman guquieꞌchloj reeman lunejz, abiꞌ ma rëb reeman guial achet gaw reeman ache tëët guiëꞌ reeman xt gugüjt reeman laaman. Yan zaꞌsin reeman cabëz reeman ni guiëbil. ");
INSERT INTO zasNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Dxel rëb suldad guin loj xin guin: ―Baguiaj. Achu loj guiëbil ni ma nal lon. ");
INSERT INTO zasNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Dxel gunee suldad rniabee guin tioꞌp ree xsuldadix, abiꞌ gunabeex laa reex din güün reex porvinid tioꞌp gayuu suldad che guiaꞌ, në za gayojnchii ree suldad cwib way, zatioꞌp gayuu ree suldad tiaꞌ lans din che reex Cesarea raca gaa guxhin. ");
INSERT INTO zasNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Abiꞌ gunabee tëëx güün reex porvinid way cwib Pab, rëbix loj reex guial guinia reex Pab din guidxinman zagdxe loj gobernador Félix. ");
INSERT INTO zasNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Abiꞌ guxhaalnëx laa reex tijb guiꞌch ni rëb: ");
INSERT INTO zasNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Naj Claudio Lisias, rugajpdiozan lüj gobernador Félix, lüj guial najl bén zojbloj. ");
INSERT INTO zasNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Bén Israel ree gunaaz xin guie ma nugüjt reeman laax. Per chi gogbeen guial xin Roman, dxel wan con ree da suldadan buglëën laax loj reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Abiꞌ guial rënan gagbeen xhie rüjnx zeel rdxeꞌch reeman laax, dxel bazun laax loj ree guxtis Israel. ");
INSERT INTO zasNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Dxel gogbeen guial por xcwent xley reeman zeel rdxeꞌch reeman laax, per ad najtan ni rayal guiëtix niꞌqui guial chuꞌx ladxguiib. ");
INSERT INTO zasNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Në guial ma gogbeen guial xixgab ree bén Israel na̱j gugüjt reeman laax, zeel cayxhalan laax lojl. Abiꞌ ma rën loj ree bén rdxeꞌch laax guial con lüj güün reeman reglad ni rajp reeman contr laax. Laanan rugojnan lüj.” ");
INSERT INTO zasNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Been ree suldad guin ziꞌc gunabee suldad rniabee guin abiꞌ guxhin binë reex Pab luguiedx Antípatris. ");
INSERT INTO zasNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Chi bareguiaal suldad zë ree guiaꞌ bayejc reex lod yuꞌ ree suldad, guiáad ree suldad dxiib way zinë reex laaman luguiedx Cesarea. ");
INSERT INTO zasNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Chi bidxin reex Cesarea, badëëd reex guiꞌch guin loj gobernador guin, bayü tëë reex Pab lojman. ");
INSERT INTO zasNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Chi gulox biil gobernador guin guiꞌch guin, gunabdiidxaman loj Pab ban zaman. Dxel chi gogbeeman guial Cilicia zëëdaman, ");
INSERT INTO zasNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","dxel rëbaman lojman: ―Chi guiꞌt ree bén zaꞌ ree contr lüj, dxel gucagdiagan ni nal. Abiꞌ gunabeeman gap reex Pab lën xpalas Herodes. ");
INSERT INTO zasNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Chi goc gaay dxej, Ananías, bixhioz mazri zojbloj rniabee graczi ree bixhioz, bidxinman Cesarea con tioꞌp choon ree guxtis Israel në tijb licenciad laman Tértulo. Abiꞌ wej reeman loj gobernador guin din cweꞌc reeman xguialquia Pab. ");
INSERT INTO zasNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Chi bidxinnë reex Pab, guzuloj Tértulo caneeman contr laaman, rëbaman loj gobernador guin: ―Quixtëë lüj dad gobernador, por lüj nadxuꞌdxen, në por xguialrajquil zien ree ni rüjn sirv cayajc du ladxan. ");
INSERT INTO zasNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Gra ladczi zaꞌ ree bejn conform por gra ni cayüjnl dad gobernador Félix, lüj na̱j bén zojbloj, quixtëëczi lüj. ");
INSERT INTO zasNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Per chitëë günlaan lüj mazri, rniaaban lojl din gucaagdiajguil ni yanan lojl tibrajtooczi. ");
INSERT INTO zasNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Dunujn bayagbeen xin guie na̱j ziꞌc tijb guialguijdx loj ree bén Israel, guidibczi guidxliuj zizax rustijlix laa reeman abiꞌ laax rniabee loj tib cwaa ree bén rniee reeman nazaren. ");
INSERT INTO zasNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Abiꞌ guyën tëëx nüjnx dux yadooroꞌn ziꞌc tijb luar ad rüjnt sirv, zeel banaazan laax bayënan naguieenan guialguxtis ziꞌc na̱j dux leyan. ");
INSERT INTO zasNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Per laa biꞌt gajc suldad Lisias con ree xsuldadix, babëëxuu reex laax du lojn. ");
INSERT INTO zasNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Abiꞌ rëb suldad rniabee guin guial lojl guiꞌt ree bén rbeꞌc xguialquia Pab, yan lüj gajc zajc guiniabdiidx lojx din gagbeel zagdxe guial walican ni ranan xcwentix. ");
INSERT INTO zasNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Abiꞌ ree bén Israel zaꞌ ni rëb reeman guial waliqui gra ni guin. ");
INSERT INTO zasNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Dxel been gobernador guin sen loj Pab din guinieeman, abiꞌ rëb Pab: ―Guial ragbeen diizd gocli rniabeel nacion Israel, zeel ad yuꞌnawëëgtan yadxiꞌn ni rudxiib reeman guican. ");
INSERT INTO zasNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Abiꞌ lüj gajc zajc cweꞌquil ruson din gagbeel guial qui gojcri chiptioꞌp dxej badxinan Jerusalén din ganajchiꞌn Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Abiꞌ achut banaaznë reeman naj cadildiidxnëꞌn, niꞌqui guial gabën wadijl lën yadooroꞌ Jerusalén, niꞌqui lën yadoo ren ree ni yuꞌ ree ni, niꞌqui luguiedx guin. ");
INSERT INTO zasNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Bén guie ree ad zajct na reeman lojl guial ni diidxli na̱j ni rudxiib reeman guican. ");
INSERT INTO zasNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Per ni na̱j diidxli na̱j guial rliladxan Jesucrist, nejzcüb guin na̱j ni zinaalan, cayünan sirv loj xDios dux béngulalan, abiꞌ na ree bén guie guial ad xnejzt Diosan, per cayünan zian guial rliladxan gra ni zëëd loj ley në ni bacaa ree bén badëëd xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Abiꞌ ziꞌcgajc rliladx ree bén guie Dios, ziangajc rliladxan laaman guial yaban ree bengüt stijb, ziꞌc ree bén goc benzaꞌc në ree bén goc benmal. ");
INSERT INTO zasNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Zeel rünan naguiejn gabajnan zagdxe chitëë xhie ganaladxan delant loj Dios niꞌqui delant loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","’Ma gojc zien ijz nariin, xt yan bayeꞌc ladxan bidganëꞌn ni baxhaal ree bejn par ree bénprob, bidganëꞌ tëën gon ni rayal gudëdan loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Laan na̱j ni cayünan lën yadooroꞌ Jerusalén chi biꞌt ree bén Israel za niz Asia baguiaa reeman naj, per mal benan ziꞌc rniabee ley din gacan naya. Abiꞌ ad zient bejn rigaꞌ, ad cabë tëëtan wadijl. ");
INSERT INTO zasNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Yan, bén gunaaz ree naj, laa reeman na̱j bén rayal su guie din na reeman xhie rünan xhie pornin rdxeꞌch reeman naj. ");
INSERT INTO zasNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","O balguiza, bén zaꞌ ree guie na reeman xhie da dolan badxejl reeman chi guzun loj gra ree guxtis Israel. ");
INSERT INTO zasNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Tijbzi ni benan chi zaꞌn galay reeman gurixdiajn rën: “Guial rliladxan yaban ree bengüt, zeel zaꞌ ree bejn contr naj yan.” ");
INSERT INTO zasNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Chi biguiejn gobernador Félix zian, abiꞌ guial ragbeeman xhienaag na̱j xnejz cüb Jesucrist, dxel basaꞌnman guialquia guin par stijb dxej, rëbaman loj reeman: ―Chi guiꞌt suldad Lisias, dxel gagbeen zagdxe xhienaag na̱j xcwentidi. ");
INSERT INTO zasNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Dxel gunabee gobernador guin tijb ree suldad rniabee guin din gusnuu guinia reex Pab, per guslaa reex güünman ni rënman ad gudxoon tëë reex chignaj ree xmiwaman laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Chi goc tioꞌp choon dxej, bidxin gobernador Félix stijb con lacheelaman Drusila, laaman na̱j bén Israel. Dxel gunabee gobernador guin bidxin Pab, abiꞌ bacaagdiajg reeman ni rëbaman xcwent guialrliladx bejn Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Per chi guzuloj cayëbaman guial rayal guiban ree bejn xnejz, gucwëëz tëë xixgab mal reeman, guial guidxin tëë dxej yadëëd ree bejn cwent loj Dios, dxel dád bidxeb gobernador guin abiꞌ rëbaman loj Pab: ―Baguiaj. Ganetan lüj chi chuꞌn luar stijb. ");
INSERT INTO zasNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Per Félix në milian rbëzaman gudëëd Pab lojman din guslaaman laaman, zeel gurejdxaman laaman zien volt din guinieenëman laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Zian gudëd tioꞌp ijz abiꞌ barii Félix guial gobernador, dxel bayu Porcio Festo xluaraman. Abiꞌ guial guyën Félix nayaꞌnman zagdxe loj ree bén Israel, zeel basaꞌnman Pab ladxguiib. ");
INSERT INTO zasNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Chi goc choon dxej ni bidxin Festo Cesarea par chuꞌman guial gobernador, dxel wejman Jerusalén. ");
INSERT INTO zasNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Yagaj, bixhioz rniabee ree bixhioz con ree bén Israel mazri zojbloj, wej reeman lojman bileꞌc reeman xguialquia Pab, ");
INSERT INTO zasNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","abiꞌ gunab reeman lojman din guixhiaalaman Pab Jerusalén. Zian guyën reeman din xixgab reeman na̱j gugüjt reeman Pab runejz. ");
INSERT INTO zasNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Per badxiꞌ Festo xtiidx reeman rëbaman guial Cesarea nayaaw Pab guiáad laaman nayob yaguiajman ni, ");
INSERT INTO zasNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","abiꞌ rëbaman loj reeman: ―Bén rajp ree guialrniabee lojdi, laa reeman sa Cesarea, abiꞌ bal xhie ni mal been xin guin, ni na reeman xhienin beenx. ");
INSERT INTO zasNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Cost xhujn o chii dxej guzuj Festo Jerusalén, dxelri ziaman Cesarea. Chi bareguiaal, gurej loj xyagxhilaman lod rniabeeman, abiꞌ gunabeeman chicaꞌ reex Pab. ");
INSERT INTO zasNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Chi bidxinnë reex laaman, bén Israel guza ree Jerusalén, gubig reeman abiꞌ zien ree niguijdx badxiib reeman guijcaman, majsi niꞌqui tijb ni rëb reeman ad gojct nulüü reeman guial najn ni wali. ");
INSERT INTO zasNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Dxel badxiꞌ Pab xtiidx reeman, rëbaman: ―Naj, achet ni mal wayünan xley ree bén Israel, niꞌqui yadooroꞌ Jerusalén, niꞌqui rey César. ");
INSERT INTO zasNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Per Festo guyënman nayaꞌnman zagdxe loj ree bén Israel, dxel gunabdiidxaman loj Pab, rëbaman: ―¿Rënl ya chel Jerusalén? Ni yanajn bal rajpil dol o ad rajptil dol ya ni rudxiib reeman guijquil. ");
INSERT INTO zasNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Badxiꞌ Paban rëbaman: ―Loj ree guxtis Roman zaꞌn, lod rayal gac reglad xhienin benan. Lüj ragbee zagdxe guial achet ni mal wayünan bén Israel ree. ");
INSERT INTO zasNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Bal xhie tijb ni mal benan ni rayal guiëtan, ad zabexuutan guiëtan. Per bal id wali ni na reeman benan, achut rajp derejch yayü naj loj reeman. Zagdxeli na̱j gadëëdan loj rey César. ");
INSERT INTO zasNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Dxel chi gulox guneenë Festo bén na̱j ree xbejnman, bén rëb ree ni rayal gac, rëbaman loj Pab: ―Lüj na tëdil loj rey César, yan lojman tëdil. ");
INSERT INTO zasNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Chi gudëd tioꞌp choon dxej, rey Agripa con xbéngunaaman Berenice bidxin reeman Cesarea bitixloj reeman gobernador Festo. ");
INSERT INTO zasNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Abiꞌ guial zien dxej daꞌt guzuj reeman ni, dxel be Festo diidx loj rey Agripa xcwent Pab, rëbaman: ―Guie yuꞌ tijb xin basaꞌn Félix ladxguiib. ");
INSERT INTO zasNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Chi wan Jerusalén, bixhioz rniabee ree bixhioz con ree bén rniabee loj ree bén Israel guleꞌc reeman xguialquiax, gunab reeman ganabeen guiëtix. ");
INSERT INTO zasNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Per naj rën loj reeman guial guxtis Rom ree ad najt xcostumbr reeman nabee reeman guiët tijb bejn chi gadaman su loj ree bén cabeꞌc xguialquiaman din guiëbaman walin ya o ad walitan ni rudxiib reeman guijcaman. ");
INSERT INTO zasNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Zeel chi biꞌt ree bén Israel guin guie, achet guial niaglaan, bareguiaal gajc gure loj da yagxhilan, abiꞌ gunabeen bidnë reex xin guin. ");
INSERT INTO zasNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Per ree bén biꞌt guleꞌc xguialquiax, achet ni nadxeb na reeman ziꞌc gunaladxan ninia reeman por laax. ");
INSERT INTO zasNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Tijbzi xguialquiax ni guleꞌc reeman na̱j por xcostumbr reeman në por tijb bén la Jesús, bén ma güjt, per Pab rëb naban Jesús guin. ");
INSERT INTO zasNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Abiꞌ guial ad ragbeetan xhie günan por zian, dxel gunabdiidxan loj Pab bal rënx chex Jerusalén din gac reglad ni guin ree ni. ");
INSERT INTO zasNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Per laax gunab tëd loj rey César din gac reglad ni rëb reeman por laax, zeel gunabeen yaawsiix xt chileꞌ yaxhalan laax loj rey César. ");
INSERT INTO zasNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Dxel rëb rey Agripa loj Festo: ―Bal zian chileꞌn, nëgajc naj rën gucagdiag laax. Abiꞌ badxiꞌ Festo laan rëbaman: ―Guixie gucaagdiajguil laax. ");
INSERT INTO zasNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Chi bareguiaal, dád zagdxe caꞌ xab rey Agripa con Berenice bidxin reeman con ree bén rniabee suldad con los demazri ree bén zojbloj luguiedx guin, bidxin reeman guyu reeman lënü lod gucaagdiajg reeman ni guiëb Pab. Dxel gunabee Festo bicaꞌ reex Pab. ");
INSERT INTO zasNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Abiꞌ rëb Festo: ―Rey Agripa në los demazridi dad zaꞌnëdi dunujn guie. Bén ruguiaadi guie, gra bén Israel, ziꞌc Jerusalén ziꞌcgajc guie ma biꞌt reeman bidganaj reeman naj rniab reeman guiëtix. ");
INSERT INTO zasNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Naj, achet xfaltix radxejlan guial rayal guiëtix. Guiáad laax gunab tëd loj César Augusto lod gac reglad xcwentix, abiꞌ ma benan xgab yaxhalan laax. ");
INSERT INTO zasNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Per ad radxejltan ni gucan por laax loj guiꞌch ni gaxhalan loj rey César, bén rniabee naj. Zeel nuzun laax lojdi ziꞌc na̱j quijb lojl rey Agripa, din chi ma gulox gunabdiidxidi ni rayal guiniabdiidxidi lojx dxel ma yuꞌ ni gucan por laax. ");
INSERT INTO zasNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Din naj rulüü ad xnejzt na̱j yaxhalan tijb bén yuꞌ ladxguiib loj rey César abiꞌ ad zëtan xhie beenman. ");
INSERT INTO zasNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Dxel rëb rey Agripa loj Pab: ―Ma zajc guinieel por lüj. Abiꞌ gules yaa Pab guzuloj rëbaman: ");
INSERT INTO zasNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","―Dád nix yuꞌ luxdon guial bileꞌ zaꞌn lojl yan rey Agripa, par ganen lojl yadxiꞌ tëën gra ni rudxiib ree bén Israel guican. ");
INSERT INTO zasNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Din lüj ragbee zagdxe gra xcostumbr ree bén Israel, në conin rüjn persi rdildiidx reeman. Zeel rniaaban lojl gapil pasens gucaagdiajguil ni ganin. ");
INSERT INTO zasNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","’Gra ree bén Israel ragbee xhienaag gubajnan con laa reeman ziꞌc ladxan ziꞌc Jerusalén, diizd xindoon. ");
INSERT INTO zasNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ragbee tëë reeman abiꞌ zajc na reeman laan bal rën reeman, guial diizd xindoon najn bénfarisew, abiꞌ ree bénfarisew na̱j bén mazri zinal xley ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Abiꞌ yan zaꞌn guie, badëëd reeman naj loj ree guxtis guial rliladxan yasban Dios bengüt ree ziꞌc beenman promejs loj ree dux béngulal ree. ");
INSERT INTO zasNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Gra guidxiptioꞌp cwaꞌ ree bén Israel cabëz dxej güün Dios zian, zeel rën reeman laaman rüjn tëë reeman sirv lojman dxej guiaal. Abiꞌ yan guial rliladxan laan zeel rbeꞌc ree bén Israel da guialquian, rey Agripa. ");
INSERT INTO zasNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","¿O naladxidi ya nawëëg yasban Dios bengüt ree? ");
INSERT INTO zasNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","’Guiaꞌxchej benan xgab rayal günan xhienin bén rliladx ree Jesús, bén Nazaret, ");
INSERT INTO zasNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","abiꞌ zian benan Jerusalén. Con xtiidx ree bixhioz rniabee ree bixhioz, zien ree bén rliladx Jesucrist badxeꞌn ladxguiib. Abiꞌ chi rugüjt reeman laa reeman, në naj rë guiëtri reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Zien volt benan laa reeman xhienin din günan naguiejn gusaꞌn reeman guialrliladx reeman Jesucrist. Zian benan lën gra ree yadoo, abiꞌ guial tant rdxeꞌchan laa reeman dxel guzunaalan laa reeman xt luguiedx ren ree. ");
INSERT INTO zasNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","’Abiꞌ par zian zaꞌn Damasco, con quijb xtiidx ree bixhioz rniabee ree bixhioz. ");
INSERT INTO zasNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Per ganin lüj rey Agripa, lunejz baguian tijb xbachaꞌ xanyabaa ziꞌc garol dxej, per mazri naynin guial loj ni rusni gubijdx, abiꞌ basnin guidib lod zaꞌn con ree bén zinëꞌn. ");
INSERT INTO zasNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Abiꞌ dugraczan bareeyuj, dxel biguiejnan chaꞌ bén gunee naj con diidx hebreo, naman: “Saulo, Saulo, ¿chexc zeel rzunalil naj? Lüj gajc rguiil xguialnaal ziꞌc goꞌn rudxeguiaꞌ loj yag rulaagnë reeman laab.” ");
INSERT INTO zasNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Dxel rën: “¿Chu lüj Dad?” Badxiꞌman laan naman: “Naj na̱j Jesús bén rzunalil. ");
INSERT INTO zasNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Per bixche, guzuli, din balülon lojl par güünl naj sirv gü tëël diidx ni baguiaal yan në ni gulün lojl. ");
INSERT INTO zasNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Naj gaxhal lüj loj ree bén Israel në loj ree bén ad najt bén Israel, abiꞌ naj gagnëꞌ lüj chitëë xhie güün reeman lüj. ");
INSERT INTO zasNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Gaxhalan lüj loj reeman din guixhialil loj reeman gusaꞌn reeman nejz mal, chinal reeman nejz zagdxe. Ad tiëbri reeman nabee xindxab laa reeman, chinal tëë reeman xnejz Dios. Abiꞌ chililadx reeman naj din gac xtol reeman perdon yayal tëë reeman ni rayal gra ree xbejn Dios, bén ma naya ree delant lojman.” ");
INSERT INTO zasNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","’Zian gojc, rey Agripa, bazoban diidx benan ni na Jesucrist lon chi guneeman naj diizd xanyabaa. ");
INSERT INTO zasNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Yaloj luguiedx Damasco gutiechan xtiidxaman, dxelri Jerusalén në guidib niz Judea në loj ree bén ad najt bén Israel. Rën loj reeman din yayüjn reeman xgab por xtol reeman, yadxiꞌ loj reeman loj Dios güün tëë reeman ni rayal güün reeman din guiguien guial ma bidxaa mod naban reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Abiꞌ por zian, gunaaz ree bén Israel naj lën yadooroꞌ Jerusalén, guyën reeman nugüjt reeman naj. ");
INSERT INTO zasNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Per con xyudar Dios laa naj guie xt yan cusnuu cayün xtiidxaman loj gra ree bejn, ziꞌc ree bén zojbloj ziꞌc ree bén ad zojblojt. Abiꞌ gra ni rën loj reeman na̱j ganax ni bacaa ree bén badëë xtiidx Dios loj ree bejn në ni bacaa Moisejs xhienaag na̱j ni gac, ");
INSERT INTO zasNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","guial Cristo na̱j guial tëdaman guialzi, guiëtaman. Per chi ma güjtaman yaloj laaman na̱j bén yaban loj ree bengüt, abiꞌ gugojnman bén Israel ree në ree bén ad najt bén Israel xhienaag gap reeman perdon. ");
INSERT INTO zasNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Chi cayëb Pab zian, dxel gudidxaꞌ Festo rëbaman: ―¡Rajcguijquil Pab! guial tant rusiidil ma rajc guijquil. ");
INSERT INTO zasNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Per badxiꞌ Pab laan rëbaman: ―Ad guictan rajc, gobernador Festo. Ni canin najn xnejz në diidxli. ");
INSERT INTO zasNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Laa rey Agripa zaꞌ guie, laaman ragbee ni canin, zeel sin guialrdxeb canen delant lojman. Naj ragbeechaaw guial laaman ragbee gra ni canin, din ad canitan ni goc ralan lod achut zajc gagbee laan. ");
INSERT INTO zasNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","¿Rliladxil ni rëb ree bén badëëd xtiidx Dios loj ree bejn ya, rey Agripa? Naj ragbee guial rliladxil. ");
INSERT INTO zasNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Dxel badxiꞌ rey Agripa laan rëbaman: ―Staꞌnczi nüjnl naj gan nililadxan Jesús. ");
INSERT INTO zasNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Abiꞌ rëb Pab: ―Majsi staꞌnz o majsi ryaadxri, na Dios guial ad tijbtzi lüj, në gra ree bén cucaagdiajg ni canin yan, guidxin dxej chililadxidi Jesús ziꞌc naj, majsi ad nët ree caden guie. ");
INSERT INTO zasNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Dxel bisu rey Agripa con gobernador Festo con Berenice në gra ree bén zojbnë laa reeman ni. ");
INSERT INTO zasNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Chi bariica reeman tiblad guzuloj cayünë lasaꞌ reeman diidx, rëb reeman: ―Achet wayüjn xin guie ni rayal guiëtix, o chuꞌx ladxguiib. ");
INSERT INTO zasNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Dxel rëb rey Agripa loj Festo: ―Zileꞌ naslaa reex, balidix niniab tëdix loj rey César. ");
INSERT INTO zasNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Chi rëb reeman ma yaxhaal reeman dunujn Italia, dxel bayü reeman Pab con staꞌn ree bén yuꞌ ladxguiib loj tijb suldad rniabee la Julio, laax rniabee tib cwaa ree suldad la Augusto. ");
INSERT INTO zasNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Abiꞌ Cesarea badxuꞌn loj tijb xbarcw ree bén Adramitio, barcw ni ma grii chen guiedx rigaꞌ ree niz Asia. Në Aristarco bunëꞌn, bén Tesalónica, guiedx rigaꞌ niz Macedonia. ");
INSERT INTO zasNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Chi bareguiaal, badxinan Sidón, lod goc Julio xinzaꞌc daꞌt con Pab, cwëjbix bitixloj ree xmiw Pab luguiedx guin abiꞌ badëëd reeman ni ryaadxaman. ");
INSERT INTO zasNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Chi badxoon Sidón badiaawan Chipre yuj rigaꞌ loj nijsdoo, basaꞌnanan dux ladruvejsan chitëë yachaaglojn zroꞌ bi, din niz du lojn rliaj bi guin. ");
INSERT INTO zasNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Badüüdan loj nijsdoo gajxh Cilicia në Panfilia abiꞌ badxinan Mira, tijb guiedx nulen Licia. ");
INSERT INTO zasNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ni bidxaagloj suldad rniabee guin tijb barcw Alejandría ni che Italia, zianz nax yadxuꞌn lojn. ");
INSERT INTO zasNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Loj zien dxej bioꞌn chaawladx, con guidib tarbajw badxinan niz lod la Gnido. Abiꞌ guial sta rliaj bi niz du lojn, dxel zagdxeli badüüdan niz Salmón, badiaawan lod la Creta yuj rigaꞌ loj nijsdoo. ");
INSERT INTO zasNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Gadëd roꞌ yuj guin zioꞌn loj nijsdoo, per con guidib tarbajw, xt badxinan tijb luar la Buenos Puertos, gajxh niz lod na̱j guiedx la Lasea. ");
INSERT INTO zasNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Abiꞌ ziꞌct ma bayaglaan, ma na̱j nadxeb yasnuu yoꞌn loj nijsdoo, din ma zidyob tiamp nayaag. Zeel gunee Pab, ");
INSERT INTO zasNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","rëbaman loj reeman: ―Dad, ad zagdxet yoꞌ ree bal yasnuu yoꞌ ree, din nadxeb guizeꞌn barcw guin abiꞌ guireꞌch gra ni yuꞌ lojn loj nijs guin, xt në dunuj ree nadxeb yayëjt ree. ");
INSERT INTO zasNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Per suldad rniabee guin mazri beencwentix bén rusa barcw guin në bén na̱j xbarcw laan, guial loj ni rëb Pab. ");
INSERT INTO zasNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Abiꞌ guial ad zagdxe tëët na̱j yagaj par yadüüdan tiamp nayaag, dxel mazri zien reeman been xgab zagdxeli na̱j yariin yagaj, yaguieenan naguiejn yadxinan Fenice, tijb guiedx nulen Creta lod ad rbiꞌ tëët bi, ni yadüüdan tiamp nayaag. ");
INSERT INTO zasNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Dxel guzuloj cabiꞌ tijb bi chaawladx ni zëëd lad sur, abiꞌ gunaladx reeman ma bileꞌ ziꞌc na̱j xixgab reeman, zeel bariin bioꞌn loj nijsdoo gadëd roꞌ yuj Creta. ");
INSERT INTO zasNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Per ad wayajct xchej zioꞌn chi birii tijb bidoxh la Euroclidón loj nijs guin. ");
INSERT INTO zasNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Abiꞌ guzuloj bi guin culadxaan barcw guin. Në guial niz du lojn zëëd bi guin dxel ad gojctri nusnuu barcw guin niejn niz lod rayal niejn, abiꞌ baslaa reeman binë barcw guin dunujn niz lod cucadxaa bi guin laan. ");
INSERT INTO zasNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Dxel badüüdan xijch tijb yujdobëz la Clauda rigaꞌn loj nijs, lod ad rbiꞌtri bidoxh guin, abiꞌ canu naxii xan barcw guin con guidib tarbajw balëꞌpanan loj barcw guin. ");
INSERT INTO zasNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Dxel chi gulox balëꞌpan canu guin loj barcw guin, batiejl reeman duu lad barcw guin chitëë yazeꞌnan. Abiꞌ guial rdxeb reeman chëëztiej barcw guin lën üx la Sirte, dxel gulet reeman xlon ree barcw guin din cwentzi chinë barcw guin dunujn niz lod rucadxaa bi guin laan. ");
INSERT INTO zasNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Chi bareguiaal, ziangajc rbiꞌ bidoxh loj nijs guin, zianz guzuloj cuzaal reeman ni nüü barcw guin loj nijs guin. ");
INSERT INTO zasNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ni bayon dxej, cwaꞌ reeman gra ree ni rüjnnë barcw guin dxiin bazaal reeman loj nijs guin. ");
INSERT INTO zasNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Zien dxej ad biguient gubijdx niꞌqui ree bajl xanyabaa por bidoxh gubiꞌ loj nijs guin, dxel dunujn ad naguieentri du luxdoon yalaan loj nijs guin. ");
INSERT INTO zasNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Abiꞌ guial ma gojc zien dxej ni achetczi wadaawan, dxel guzuli Pab galay reeman, rëbaman: ―Dad, zagdxeli nucaagdiajguidi da diidxan ad nariit ree Creta, zian ad nadüüdt ree tarbajw guie achet tëët nasëëb ree. ");
INSERT INTO zasNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Per achet güünan, ad rdxebidi din niꞌqui tijbidi ad zëjtt, tijbzi barcw guin yazeꞌn. ");
INSERT INTO zasNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Din Dios rniabee naj, bén cayünan sirv guxhaal tijb xi anjlaman balüüloj lon yan guiaal. ");
INSERT INTO zasNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Abiꞌ na anjl guin lon: “Pab, ad rdxebil, din rayal sul loj rey César, abiꞌ por lüj niꞌqui tijb ree bén zëëd loj barcw guie ad zuslaat Dios guiët reeman.” ");
INSERT INTO zasNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Zeel yan dad, gol badxeꞌ luxdoodi zagdxe, din naj rliladxan Dios, ragbee tëën zagdxe guial gac ziꞌc na anjl guin lon. ");
INSERT INTO zasNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Per gag barcw guie niz roꞌ tijb yuj rigaꞌ loj nijsdoo. ");
INSERT INTO zasNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Chi goc chiin gubijdx ni zioꞌn loj nijs guin, guxhinzii badxinan niz loj nijsdoo la Adriatico, niz ni niz guie zë barcw guin loj nijs guin por bi guin. Abiꞌ ree bén nulen barcw guin, guxhinzii ziꞌct garol guiaal gogbee reeman guial zamer yadxinan loj yuj. ");
INSERT INTO zasNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Dxel bareꞌxh reeman plact naxhit nijs guin, najn ziꞌctiubitib mejtr naxhit. Mazri delant bareꞌxh reeman laan zatijb ma najn gajlbiadx mejtr naxhit. ");
INSERT INTO zasNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Abiꞌ bidxeb reeman laroꞌ barcw guin guiaj ree, dxel niz xijch barcw guin bazaal reeman tajp ganch guiib loj nijs guin din chileꞌ sudxe barcw guin, abiꞌ ma rën nejzdoo reeman yareguiaal. ");
INSERT INTO zasNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Bén nulen ree barcw guin, been reeman bén sta cuzaal ree ganch guiib guin loj nijs guin niz loj barcw guin, naabzi par calet reeman canu chuꞌ reeman par guxüün reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Per bagojn Pab suldad rniabee con ree xsuldadix, rëbaman loj reex: ―Bal id ree bén guin yayaꞌn loj barcw guie, ad zalaatridi. ");
INSERT INTO zasNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Dxel batüüg ree suldad guin ni naxii canu guin persi zinë nijs canu guin. ");
INSERT INTO zasNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Chi ma cayni luyuj, rëb Pab loj reeman din gaw reeman, rëbaman loj reeman: ―Ma gojc chiin gubijdx ni ad raayëjstidi achet tëët wayawidi. ");
INSERT INTO zasNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Naj rni lëjt, gol gudaw din guibandi, din gradi niꞌqui tijb guidxguijquidi ad zusëëbtidi. ");
INSERT INTO zasNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Chi rëb Pab zian, cwaꞌman tijb guiadxtil, abiꞌ badëëman quixtëë loj Dios niz loj gra reeman, dxel gulaꞌman guiadxtil guin guzuloj cayawaman. ");
INSERT INTO zasNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Dxel bayu luxdoo gra reeman, guzuloj nëgajc laa reeman cayaw. ");
INSERT INTO zasNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Tioꞌpgayuu gayojnchiibixhoꞌp nayajc dugran zioꞌpan loj barcw guin. ");
INSERT INTO zasNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Chi gulox gudaw reeman xt bixienladx reeman, dxel bazaal reeman trigo loj nijs guin persi bacha barcw guin. ");
INSERT INTO zasNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Chi bareguiaal, bén nulen ree barcw guin, ad bayünbeet reeman yuj badxin reeman. Per baguiaa reeman tibdaꞌn nijsdoo guin rigaꞌ üx gadëëd roꞌn, abiꞌ been reeman xgab badxig reeman barcw guin yagaj. ");
INSERT INTO zasNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Dxel batüüg reeman ni naxiinë ree ganch guiib guin ni rüjn yudar par sudxe barcw guin loj nijs, basaꞌn reeman ganch guin ree loj nijs guin, abiꞌ baxhiec reeman yag ni rüjn yudar par sa barcw guin din suloj san. Dxel gules reeman lon ni na̱j niz lucwaj barcw guin din guiniaazan bi, zianz guzuloj cayriica barcw guin niz roꞌ nijs guin. ");
INSERT INTO zasNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Per wëëztiejn loj üx zien lod bigagan. Niz guijcan wëëz lën üx abiꞌ niꞌquid rniibtan, guiáad niz xan guin guzuloj cayzeꞌnan con gojl rliaj nijs guin ladan. ");
INSERT INTO zasNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Dxel nuyën ree suldad guin nugüjt reex bén prejs guin ree, chitëë nixoobnijs reeman abiꞌ nuxüün reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Per suldad rniabee guin ad cwëjbtix niajc zian guial ad rëntix niëjt Pab, dxel gunabeex guial bén rajc rxoobnijs ree, yaloj laa reeman chuꞌ loj nijs guin güün reeman naguiejn yarii reeman roꞌ nijs guin. ");
INSERT INTO zasNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Dxelri ma guidnal gra reeman loj ree tabl o loj ree yag ni bazeꞌn barcw guin. Zian balaan, dugran badxin roꞌ nijs guin. ");
INSERT INTO zasNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Chi gulox barii dugran lon nijs guin, dxel bayagbeen yuj lod badxinan lan Malta rigaꞌn galay nijs. ");
INSERT INTO zasNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Bén na̱j ree bén ni, dád benzaꞌc gojc reeman con dunujn. Been reeman tijb bajl guial nayaag nëtëë guial cayal guia, abiꞌ na reeman du lojn din yubiigan cwëꞌ bajl guin. ");
INSERT INTO zasNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Dxel batoꞌp Pab taꞌn yagbidx, zianz chi cudxeꞌman laan loj bajl guin briyaal tijb bëël lën yag guin por xi xliaa bajl guin, abiꞌ gudawyaꞌb yaa Pab nalbëztib yaaman. ");
INSERT INTO zasNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Chi baguiaa ree bén Malta guin nalbëz bëël guin yaa Pab, dxel rëb loj lasaꞌ reeman: ―Xin guie bejn bagüjtix, zeel majsi gulaax loj nijsdoo, per guiëtczix por ni beenx. ");
INSERT INTO zasNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Per gudxijp yaa Pab abiꞌ biajb bëël guin loj bajl guin, guiáad laaman achet gocaman. ");
INSERT INTO zasNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Gra reeman cabëz saaguij yaaman, o dxejlczi yabaman guiëtaman. Per chi gojc xchej, chi baguiaa reeman achet gocaman, bachaa xixgab reeman abiꞌ guzuloj rëb reeman guial tijb dios najman. ");
INSERT INTO zasNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Gajxh lod badxuꞌn nagaꞌ ree xguidxliuj tijb bén zojbloj loj yuj rigaꞌ loj nijs guin, laman Publio. Naman du lojn yoꞌn lidxaman, ni badxuꞌn choon dxej, dád benzaꞌc tëë gojcaman con dunujn. ");
INSERT INTO zasNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Nadxel nagaꞌ xdadaman, ragxuuman, yuꞌman xliaa rajc tëëman yoobrejn. Abiꞌ guyu Pab lod nagaꞌman, zianz chi gulox gurejdx gunabaman Dios por laaman, dxel guxhoob yaaman guijcaman abiꞌ bayajcaman. ");
INSERT INTO zasNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Chi gogbee ree bénragxuu zojb ni ni goc, biꞌt reeman lod zaꞌ Pab persi bayüjnman laa reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Dxel dád zien ni bazaladx reeman du lojn por zian. Abiꞌ chi badxuꞌn loj barcw par yadxoon yagaj, banee reeman gra ni rayaadxan lunejz. ");
INSERT INTO zasNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Choon bëëw badxuꞌn loj yuj zii, dxelri badxuꞌn loj tijb barcw Alejandría, ni bitëd ni tiamp nayaag. Niz lucwaj barcw guin ca tioꞌp ree dxan bén la ree Cástor në Pólux. ");
INSERT INTO zasNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Dxel badxinan tijb guiedx la Siracusa, yagaj badxuꞌn choon dxej. ");
INSERT INTO zasNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Abiꞌ yagaj badxoon bioꞌn gadëd roꞌ nijsdoo xt badxinan guiedx la Regio. Chi bareguiaal, chi badxoon yagaj, brii tijb bi lad sur dxel ni barojp dxej badxinan luguiedx la Puteoli. ");
INSERT INTO zasNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Yagaj badxaagan tioꞌp choon ree bén na̱j ree bén ni në reeman rliladx Jesucrist, dxel na reeman du lojn yayaꞌnnëꞌn laa reeman abiꞌ bayaꞌnnëꞌn laa reeman toxman. Zian gojc, dxelri zioꞌn Rom. ");
INSERT INTO zasNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Guiáad ree dux compniaran bén rliladx ree Jesucrist, bén zojb ree Rom, ma ragbee reeman guial yadxinan yagaj. Dxel brii reeman bidgachaagloj reeman dunujn xt lod la Foro de Apio në luguiedx la Tres Tabernas. Chi baguiaa Pab laa reeman, babaaman abiꞌ badëëman quixtëë loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Chi badxinan Rom, dxel bayü suldad rniabee guin bén prejs guin ree loj tijb ree suldad rniabee ni. Per cwëjb reeman gurej Pab stijb yu ren lod gojp tijb suldad laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Chi goc choon dxej badxinan Rom, gurejdx Pab bén Israel zojbloj ree ni. Chi badxajg lasaꞌ reeman, dxel rëbaman loj reeman: ―Compniar Israel, achet wayünan contr ree bén Israel niꞌqui contr xcostumbr ree dux béngulal ree. Guiáad laa reeman gunaaz reeman naj Jerusalén, bayü reeman naj loj ree guxtis Rom. ");
INSERT INTO zasNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Abiꞌ ree bén Rom guin chi gulox badëdan cwent loj reeman, dxel nuyën reeman nuslaa reeman naj, guial gogbee reeman achet benan par guiëtan. ");
INSERT INTO zasNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Per ree bén Israel guin badxoon reeman abiꞌ zagdxeli gunaaban gadëëdan loj rey César, per ad guial raꞌptan xhienin contr ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Zeel guredxan lëjt, din guidganajdi naj din ganin lojdi guial por ni rliladxan guial yaban ree bengüt ziꞌcgajc rliladx gra ree du lasaꞌ bén Israel ree, zeel naxiin con ree caden guie. ");
INSERT INTO zasNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Dxel rëb reeman lojman: ―Dunujn niꞌqui tijb xtiidx ree bén Judea ad wacaꞌtan lod na reeman xcwentil, në niꞌqui tijb bén duladx ree bén raza ree Judea achet wana reeman du lojn contr lüj. ");
INSERT INTO zasNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Per rayënan yaguiejnan xhienaag na̱j xixgabil, din dunujn rayagbee guial gra ladczi rniee reeman contr religion cüb guin. ");
INSERT INTO zasNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Dxel bazuj reeman tijb dxej ni yadxajg lasaꞌ reeman. Chi bidxin dxej guin, dád zien bejn bidoꞌp lod zojb Pab. Abiꞌ diizd rsil xt wadxe guneenëman laa reeman xhienaag na̱j xguialrniabee Dios. Beenman naguiejn chililadx reeman Jesús, bazaꞌt tëëman lod rniee xcwent Jesús loj xlibr ley Moisejs në ni bacaa ree bén badëë xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Yuꞌ reeman bililadx ni rëb Pab, per yuꞌ reeman ad bililadxt. ");
INSERT INTO zasNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Abiꞌ guial ad rdxaagt gü reeman diidx, guzuloj bareꞌch reeman. Dxel rëb Pab loj reeman: ―Waliqui ni rëb Isaías bén badëëd xtiidx Dios loj ree dux béngulal ree guial rëb xSprijt Dios: ");
INSERT INTO zasNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Wej, güjdx loj ree bén guin: Majsi riguiejn reeman, per achetczi chigniaꞌ reeman, abiꞌ majsi ruguiaa reeman, per rulüü ad ruguiaat reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Din been luxdoo reeman gojl, abiꞌ rüjn reeman ziꞌc rulüü ad ruguiaat reeman, ad riguiejn tëët reeman, chitëë guguiaa reeman, abiꞌ guien reeman chigniaꞌ tëë reeman. Din ad rënt reeman guiꞌt reeman con naj, abiꞌ günan laa reeman perdon. ");
INSERT INTO zasNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Zeel gol gogbee guial diizd yan, loj ree bén ad najt bén Israel guireꞌch diidx xhienaag gap reeman xperdon Dios, abiꞌ laa reeman zaliladx reeman diidx guin ree. ");
INSERT INTO zasNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Chi gulox rëb Pab zian, dxel zia ree bén Israel guin, cadildiidxnë lasaꞌ reeman. ");
INSERT INTO zasNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Tioꞌp ijz gurej Pab ni, yu lod gudixaman. Ni rnieenëman gra ree bén rtixloj laaman. ");
INSERT INTO zasNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Sin guialrdxeb rëbaman loj reeman xhienaag na̱j xguialrniabee Dios, abiꞌ guneeman xtiidx Dad Jesucrist loj reeman sin guial chu nudxoon.");
INSERT INTO zasNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Naj Pab, cayünan sirv loj Jesucrist, Dios gule naj din gacan xi apóstol Jesucrist, din gatiechan xtiidxzaꞌcaman. ");
INSERT INTO zasNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Diizd gocli mal rëb Dios diidxzaꞌc guin ree, ni zëëd loj xtiidxaman ziꞌc bacaa ree bén badëë xtiidx Dios loj ree bejn, ");
INSERT INTO zasNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","diidx guin ree ruzaꞌt, dux Dad ree Jesucrist guial ziꞌc biꞌtaman loj guidxliuj ziꞌc bénguidxliuj, loj xdiaa rey Davi zaman. ");
INSERT INTO zasNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Per por xSprijt Dios laaman na̱j Xiꞌn Dios guial babanman loj ree bengüt, abiꞌ guidiblagaa rajpaman guialrniabee. ");
INSERT INTO zasNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Abiꞌ par yazaꞌt reeman, zeel bacaabeeman naj din gacan apóstol din guidiblagaa guidxliuj chuꞌ bén chililadx laaman, bén guzoob tëë xtiidxaman. ");
INSERT INTO zasNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Abiꞌ në lëjt ma nayab loj ree bén gule Dios din gaquidi xbejn Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Zeel caxhalan guiꞌch guie lojdi bén rën ree Dios, bén zojb ree Rom, lëjt ma gulej Dios din gaquidi xbejnman. Dux Dad ree Dios në Dad Jesucrist güünleꞌ lëjt yabeꞌcdxe tëë reeman luxdoodi. ");
INSERT INTO zasNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Yalojxgaj por Jesucrist rudën quixtëë loj Dios por gradi, guial guidibczi ruzaꞌt reeman lëjt xhienaag rliladxidi Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Abiꞌ ziꞌc cayünan sirv loj Dios, guidib guic guidib ladxan catiechan xtiidxzaꞌc Xiꞌnman Jesucrist, abiꞌ laaman ragbee guial ad rucwëëzt rbedx rniaaban laaman por lëjt. ");
INSERT INTO zasNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Ad rucwëëz tëët rbedx rniaaban Dios din guneeman mod guidganan lëjt, ziꞌc na̱j da xgaban diizd gocli. ");
INSERT INTO zasNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Din yuꞌczan gan guidganan lëjt din günan lëjt yudar con xtiidx Dios din sudxiꞌchidi lojn. ");
INSERT INTO zasNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Din güün tëëdi naj yudar zian yaguieen du lasaꞌ ree yudar loj guialrliladx ni rayaꞌp ree, din chileꞌ yaluꞌ du luxdoo du lasaꞌ ree. ");
INSERT INTO zasNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Compniar raliduladx ree Jesucrist, rënan gagbeedi guial zien volti daꞌt ma benan xgab guidganan lëjt, din gacxhiej ree bén chililadx xtiidx Dios, ziꞌc ma gojc zien ree luar ni ma wan, per xt yan ad wayajct gan guidganan lëjt. ");
INSERT INTO zasNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Par naj naladxan da cwentan na̱j guial gulün chutëëz benan xtiidx Dios, bal najman bén ciuda o najman bén guiedxdoo ya, bal rigniaꞌman o ad rigniaꞌtaman. ");
INSERT INTO zasNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Zeel rënnejzdoon guidganan lëjt din gatiechan xtiidx Dios Rom. ");
INSERT INTO zasNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ad ratunëꞌtan xtiidxzaꞌc Jesucrist. Din por diidxzaꞌc guin ree zëëd xguialrniabee Dios, din gra ree bén chililadx laan laa reeman loj dol, ziꞌc ree bén Israel ziꞌc ree bén ad najt bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Din por xtiidxzaꞌc Jesucrist ragbee ree bejn guial por guialrliladx reeman laaman ma na̱j reeman cwent sin dol: achet por stijb ni ren tijbzi por guialrliladx. Zian ca loj xtiidx Dios lod rëb: “Bén naban ziꞌc rën Dios, guidib tiamp ni nabanman rliladxaman laaman.” ");
INSERT INTO zasNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Dunuj ree rayagbee guial diizd xanyabaa zëëd xcastiroꞌ Dios par ree bén ad ridxgaꞌt laaman, bén ad rüjnt ree ziꞌc rayal, abiꞌ ziꞌc naban reeman ruquieꞌch reeman xtiidxli Dios. ");
INSERT INTO zasNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Din ragbeechaaw reeman guial yuꞌ Dios, abiꞌ laagajcaman balüü bejn ree guial yuꞌcaman. ");
INSERT INTO zasNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Majsi ad ruguiaat bejn Dios, per diizd chi goꞌtchaaw guidxliuj raguiaa ree ni beenman, abiꞌ por ni ma beenman rayagbee ree guial ad yuꞌt dxej lox xguialrniabeeman abiꞌ laa tëëman na̱j Dios. Zeel ad zajct xhie gudxiib bejn guijc guial achet ragbeeman xcwent Dios. ");
INSERT INTO zasNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Din majsi yuꞌ ree bejn ragbee guial yuꞌ Dios, per ad rajpt reeman laaman respejt ziꞌc rayal, ad rudëë tëët reeman quixtëë lojman, aal xgab ren ree rüjn reeman ni ad rüjnt sirv abiꞌ gaz ragdxa reeman. ");
INSERT INTO zasNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Rëb reeman guial rajc daꞌt reeman abiꞌ mazri na tont reeman. ");
INSERT INTO zasNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Din luar guiën reeman Dios ni ad yuꞌt dxej guiët, rën reeman ni nit ree yuꞌ dxej, rën reeman ni na̱j ree ziꞌc bejn, ni na̱j ree ziꞌc biguijn, ziꞌc ree be yuꞌ tajp guiaꞌ në ree bëël. ");
INSERT INTO zasNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Zeel ma gulëëladx Dios laa reeman loj xixgab mal reeman, abiꞌ rüjn reeman ni natu ree con ree ben ren. ");
INSERT INTO zasNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Luar chinal reeman xdiidxli Dios, zinal reeman ni rusquiee ree. Abiꞌ rën reeman rajp tëë reeman respejt ni been Dios, luar guiën reeman laaman guial beenman laa reen, abiꞌ laaman rayal gap ree bejn respejt zianczi. Amén. ");
INSERT INTO zasNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Zeel gulëëladx Dios laa reeman loj ree ni dxuudx rüjn reeman. Abiꞌ zien ree béngunaa ad nabantri ree xnejz, rën lasaꞌ béngunaa gajc reeman. ");
INSERT INTO zasNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ziangajc zien ree xinguiaaw ad nabantri xnejz, rën gajc lasaꞌ xinguiaaw reex, xinguiaaw con xinguiaaw rüjn reex ni dxuudx, ni natu. Abiꞌ laagajc reex rguiil xcasti reex. ");
INSERT INTO zasNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Abiꞌ guial ad ridxgaꞌt reeman Dios, zeel gulëëladx Dios laa reeman loj xixgab mal reeman, din güün reeman ganax ni ad rayalt güün reeman. ");
INSERT INTO zasNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ganax ni ad rayalt güün reeman rüjn reeman, zaꞌnë reeman xinguiaaw ren o béngunaa ren, zien ree ni mal rüjn reeman, rzëëbladx reeman gap reeman ni rajp ree ben ren. Dád nadëdloj reeman, rugüjt reeman bejn, rguiil reeman wadijl, rusquiee reeman bejn, ganaxczi ni mal yuꞌguijc reeman abiꞌ rbëë reeman xtiidxguijdx bejn. ");
INSERT INTO zasNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Rnieeguijdx tëë reeman bejn, ralen reeman Dios, ad rajpt reeman bejn respejt, rlies xvalor gajc reeman, rüjn reeman benroꞌ. Abiꞌ rbëëguijc reeman ni mal ree, ad ruzoob tëët xtiidx xdad xniaa reeman. ");
INSERT INTO zasNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Dád nad reeman, ad rüjnt cumplid xtiidx reeman, ad rënt lasaꞌ reeman, ad raya tëët lasaꞌ reeman. ");
INSERT INTO zasNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ragbeechaaw reeman rëb Dios guial chi guiët ree bejn, dxel gra ree bén rüjn gra ree ni guin yayal casti. Per majsi zian, rusnuu gajc rüjn reeman ni mal guin ree abiꞌ xt rabaa reeman chi rüjn ree ben ren zian. ");
INSERT INTO zasNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Zeel chutëëz lüj guial rëbil xhie casti rayal bejn, ad rajptil derejch guiëbil zian, din lüj gajc rayal casti guin guial cayüjnl ziꞌcgajc rüjn reeman. ");
INSERT INTO zasNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Per dunuj ree rayagbee guial Dios rüjn guialguxtis ziꞌc rayal, chi rudëëdaman casti bén rüjn ree ni mal guin. ");
INSERT INTO zasNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Abiꞌ lüj guial rëbil xhie casti rayal bejn abiꞌ nëgajquiza lüj rüjn ziꞌc rüjn reeman, ad naladxil laal loj xcasti Dios. ");
INSERT INTO zasNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ad rëntil guialnazaꞌc Dios con lüj, ad rëntil guial rdaanman lüj rajp tëëman lüj pacens, niꞌquid ragbeetil guial pacens guin rüjn lüj yudar din gapil tiamp par yayüjnl xgab por xtolil. ");
INSERT INTO zasNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Per guial dád nadil, ad rëntil yayejquil loj Dios, zeel lüj gajc cayüjnxhiej xtolil par dxej ni gudëëd Dios casti, dxej ni güünman guialguxtis ziꞌc rayal. ");
INSERT INTO zasNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Par gudëëman ni rayal tijbgaj bejn bal gonin beenman. ");
INSERT INTO zasNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Gudëëdaman guialnaban tiblayaa loj ree bén ad radxagt rüjn naguiejn guiban zagdxe guial rüjn reeman naguiejn yayal reeman guialnazaꞌc yuꞌ xanyabaa, rüjn tëë reeman naguiejn yayaꞌn reeman zagdxe loj Dios din gap reeman cuerp ni ad yuꞌt dxej nit. ");
INSERT INTO zasNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Per ree bén ad ruzoobt diidx, rdxeꞌch Dios laa reeman abiꞌ gudëëdaman laa reeman casti, din luar chinal reeman xtiidxliman, zinal reeman nejz mal. ");
INSERT INTO zasNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Gra ree bén zinal nejz mal, naya sac reeman sagdiaj reeman, yaloj ree bén Israel dxel bén ad najt ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Guiáad ree bén zë loj nejz zagdxe, guilies Dios xvalor reeman, yabaanëman laa reeman, yabeꞌcdxe tëëman luxdoo reeman, yaloj xgaj ree bén Israel dxelri bén ad najt ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Din Dios tiblojzi rüjnman guialguxtis con gra bejn. ");
INSERT INTO zasNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Gra ree bén cayüjn dol sin guial ad nünbeet reeman ley badëëd Dios loj Moisejs, tëd reeman casti sin ley guin. Guiáad ree bén cayüjn dol majsi ragbee reeman ley guin, laa reeman tëd casti ziꞌc rniabee ley guin. ");
INSERT INTO zasNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Din ad guial guientzi bejn ley guin ma nayaman loj Dios, bén rüjn ree ziꞌc rniabee ley guin laa reeman na̱j bén naya loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Per chi ad najt bejn bén Israel, abiꞌ cayüjnman ni zagdxe sin guial güünbeeman ley guin, dxel ma cayüjnman ziꞌc rniabee ley guin majsi ad nünbeetaman laan, guialzi nünbeeman conin na̱j ni zagdxe con tëë nin na̱j ni mal, abiꞌ guijc gajc reeman zëëd xley reeman. ");
INSERT INTO zasNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Din ziꞌc naban reeman, rguien guial guijc reeman zëëd conin rayal güün reeman con tëë nin ad rayalt güün reeman luar gap reeman ley guin. Abiꞌ laagajc reeman ragbee chi ma been reeman ni zagdxe o chi ma been reeman ni mal. ");
INSERT INTO zasNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Zian gac chi güün Dios guialguxtis por gra ree ni naguieꞌch ni rüjn bénguidxliuj. Abiꞌ ziꞌc culün bejn ree guidibczi, laaman güün guialguxtis por Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Yan, lüj guial najl bén Israel yuꞌguijquil guial rajquil ley badëë Dios loj Moisejs, abiꞌ rüjnl nabë guial najl xbejn Dios, ");
INSERT INTO zasNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","rëbil guial ragbeel xhienaag rën Dios guibanl, abiꞌ por xleyaman ragbeel conin na̱j zagdxe güünl. ");
INSERT INTO zasNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Abiꞌ naladxil zileꞌ guzuxnejzil bén ad nünbeet ree ley guin në ree bén ad nünbeet xnejz Dios, ");
INSERT INTO zasNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","naladxil zileꞌ gulüül bén ad rajct ree në ree bén rajc taꞌnzi, guial por ley guin ragbeel gra, ragbee tëël conin na̱j diidxli. ");
INSERT INTO zasNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Per ziꞌc nabanl, ¿chexc zeel ad rulüüt lüj gajc luar gulüül ben ren? Din lüj rëb guial ad laat cwan bejn, abiꞌ, ¿chexquiza zeel rbanl? ");
INSERT INTO zasNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Rëbil guial ad laat sunë bejn bén ad najt lacheelaman, abiꞌ lüj, ¿chexquiza zeel rüjnl zian? Rëb tëël guial rdxeꞌchil ni naladx bejn na̱j dios, abiꞌ, ¿chexquiza zeel rbanl lën yadoo lod yuꞌ ree Dios guin? ");
INSERT INTO zasNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Dád nabë rüjnl guial nünbeel ley, per rusaꞌnxtul Dios guial ad rüjntil ni rniabee ley guin. ");
INSERT INTO zasNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Zeꞌcli rëb loj xtiidx Dios: “Bén ad najt ree bén Israel rniee reeman Dios diidxguijdx por lëjt.” ");
INSERT INTO zasNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Diidxli rüjnqui sirv guial ru xcuerp bejn sen ni ru ree bén Israel, bal rüjnman ziꞌc rniabee xley Dios. Per bal id rüjnman ziꞌc rniabee ley guin, achet sirvan guial yuꞌman sen guin. ");
INSERT INTO zasNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Per bal tijb bén ad yuꞌt sen guin nabanman ziꞌcgajc tijb bén rajc xley Dios majsi ad nünbeetaman laan, dxel ma nayabaman ziꞌc tijb bén yuꞌ sen, majsi ad yuꞌtaman sen guin. ");
INSERT INTO zasNT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Bén rüjn ziꞌc na̱j xley Dios, majsi ad nünbeetaman ley ad yuꞌ tëëtaman sen, gusaꞌnxtuꞌman lüj guial nünbeel ley guin yuꞌ tëël sen guin, abiꞌ ad rüjntil ziꞌc rniabee ley guin. ");
INSERT INTO zasNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Din ad guial rajlt bejn loj nacion Israel, ad guial yuꞌ tëëtaman sen ni ru ree bén Israel ma najman bén Israel loj Dios, ");
INSERT INTO zasNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","bén wali na̱j bén Israel loj Dios, guidib luxdooman zinalaman xnejz Dios, ad por guial yuꞌtaman sen ru ree bén Israel, ad por xcostumbr tëët reeman, por guial naban reeman con xSprijt Dios. Abiꞌ bén naban zian, Dios rlies xvaloraman saꞌn ad bénguidxliujt. ");
INSERT INTO zasNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Zeel zanadi lon xhieczi gan na̱j bejn bén Israel o xhieczi gan chuꞌman sen ru ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Per naj gani lojdi guial gadxagayaa mod lasajc guial na̱j bejn bén Israel, din yalojxgaj loj ree bén Israel badëëd Dios xtiidxaman. ");
INSERT INTO zasNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Yan ad naladxidi por guial yuꞌ ree bén ad zinalt xnejz Dios, ad züjntraman cumplid ni rëbaman din xo güün Dios ni rëbaman güünman con ree bén zinal xnejzaman. ");
INSERT INTO zasNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Din laaman ad yuꞌt dxej guchaa xtiidxaman, majsi gra bénguidxliuj na̱j bén rusquiee, per Dios ad nëtaman rusquiee, ziꞌc rëb tiblajt loj xtiidxaman lod rëb: Gra bejn güünbee lüj guial rüjn cumplid xtiidxil, abiꞌ achet zajc gudxiib reeman guijquil. ");
INSERT INTO zasNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","(Per yuꞌ bejn rüjn xgab) guial bal por dol ni cayguieen ree rulüü guial benzaꞌc na̱j Dios, ¿chexquiza zeel najman benmal rudëëdaman bejn casti? ");
INSERT INTO zasNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Per naj rni lojdi guial ad najt Dios benmal, din bal najman benmal xoza güün xguialguxtisaman con bénguidxliuj. ");
INSERT INTO zasNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Din bal yaguieꞌch ree guial ad rucaagdiajgt xtiidx Dios, laan na̱j ni rüjn yudar xtiidxli Dios din gap bejn laaman mazri respejt, dxel ad zajctri guiëb Dios na̱j bejn béndol. ");
INSERT INTO zasNT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Abiꞌ mazri ma yaguieen ree ni mal din guiꞌt ni zagdxe, ziꞌc rëb ree bejn culün bejn ree, per Dios gudëëd casti bén rëb ree zian. ");
INSERT INTO zasNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Zeel ziꞌc ma rnin por ree bén Israel, në por ree bén ad najt bén Israel, abiꞌ ma ragbeedi guial ad zajct guiëbidi guial mazri benzaꞌc na̱j ree bén Israel guial loj ree bén ad najt bén Israel, din tiblojzi nayajc ree béndol. ");
INSERT INTO zasNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ziꞌc ca tiblajt loj xtiidx Dios lod rëb: Achutczi na̱j benzaꞌc, per niꞌqui tijb bejn. ");
INSERT INTO zasNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Achutczi rigniaꞌ. Achutczi raguiil Dios. ");
INSERT INTO zasNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Gra reeman ma basaꞌn xnejz Dios. Gra reeman ma zinal nejz mal. Achutczi cayüjn ni zagdxe, per niꞌczi tijb bejn. ");
INSERT INTO zasNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Ziꞌcgajczi tijb baa ni zojbyal, zian ganax ni dxuudx ririi roꞌ reeman. Ganax diidx rusquiee rniee reeman. Abiꞌ xtiidx reeman na̱j ziꞌc xvenen bëël. ");
INSERT INTO zasNT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Ganax diidx mal ririi roꞌ reeman, diidxguijdx ni rüjnnaa lasaꞌ reeman. ");
INSERT INTO zasNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Zaꞌsin reeman din gugüjt reeman bejn. ");
INSERT INTO zasNT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Bantëëz guin zë reeman, rüjn reeman ni dxuudx ree. Abiꞌ rusagzi reeman bejn ree. ");
INSERT INTO zasNT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Ad nünbee tëët reeman xhienaag na̱j guialrbajn bejn zagdxe. ");
INSERT INTO zasNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Ad yuꞌguijct reeman guial rayal guidxeb reeman Dios. ");
INSERT INTO zasNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Dunuj ree rayagbee guial gra ni zëëd loj xley Dios, na̱j par ree bén zinal ley guin, chitëë chu guiëb guial achut ragbee xhienin na̱j dol, laan na̱j par gagbee bejn guial najman béndol loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Din ad guial güünt bejn gra ni rniabee ley guin ma nayaman loj Dios, ley guin rulüü din gagbee bejn guial najman béndol. ");
INSERT INTO zasNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Per yan Dios ma balüü dunuj ree tijb nejz guial xhienaag yayajc ree naya lojman. Ad guial yaguieentzi ree ziꞌc rniabee ley guin, por ley guin në por ni bacaa ree bén badëë xtiidx Dios loj ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Rayagbee ree guial rüjn Dios bejn cwent ziꞌc bén ad yuꞌt xtol por guialrliladxaman Jesucrist, din par Dios tiblojzi na̱j bejn. ");
INSERT INTO zasNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Din gra bejn ma been dol, achutczi naya niz loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Per guial najman benzaꞌc, ma beenman perdon dux tol ree sin guial yadijx ree, ma nayajc ree perdon por Jesucrist, bén gudix por dux tol ree chi gütaman loj crüjz. ");
INSERT INTO zasNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Dios guxhaal Jesucrist, din por xrejnman chuꞌ perdon par bénguidxliuj. Abiꞌ perdon guin na̱j par ree bén rliladx Jesucrist. Zian rguien guial graczi rüjn Dios xnejz, abiꞌ bal guiaꞌxchej ad beent xguialguxtisaman por dol ni been ree bejn, laan na̱j por pacens ni rajpaman con bejn, ");
INSERT INTO zasNT_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","guial ma ragbeeman goc güün xguialguxtisaman. Zian rusnuu rulüüman guial graczi rüjnman xnejz, zeel rüjnman perdon xtol ree bén rliladx Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Yan, ¿xhienaag yaguieen ree nabë? Achet yaguieennëꞌ ree nabë, din ad guial yaguieent ree ley guin cumplid ma nayajc ree perdon, yayajc ree perdon por guial yaliduladx ree Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Zeel rayagbeechaaw ree guial Dios rüjn perdon xtol ree bejn guial rliladx reeman Jesucrist, ad guial rüjnt bejn naguiejn güünman gra ni rniabee ley guin. ");
INSERT INTO zasNT_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","¿Wen xDiosi ree bén Israel na̱j Dios ya, ad nët ree bén ad najt bén Israel na̱j xDios laaman ya? Naj rni lojdi guial Dios na̱j par gra bejn, ");
INSERT INTO zasNT_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","din tijbzi Dios yuꞌ, laaman rüjn perdon xtol ree bén rliladx Jesucrist, yuꞌman o ad yuꞌtaman sen ni rniabee ley chuꞌ ree bén Israel. ");
INSERT INTO zasNT_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Ad naladxidi cayguieen ree ley guin tiblad guial raliduladx ree Jesucrist, din ad ziantan, guial raliduladx ree laaman rguien guial nadxuꞌguijc ree ley guin. ");
INSERT INTO zasNT_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Yan, ¿xhie zajc yaguieꞌch ree xcwent dux béngulal ree Abraham? ");
INSERT INTO zasNT_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Bal niyab Abraham ziꞌc tijb bén gad güün dol por ree ni beenman, guyu mod nüjnman nabë loj ree bejn, per ad lojt Dios. ");
INSERT INTO zasNT_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Din rëb loj xtiidx Dios: “Guial bililadx Abraham Dios, zeel been Dios laaman cwent ziꞌc tijb bén ad beent dol.” ");
INSERT INTO zasNT_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Chi rüjn bejn dxiin, milia ni rajxaman ad ni razaladxt reeman, rtiaꞌman laan por dxiin ni rüjnman. ");
INSERT INTO zasNT_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Per guial gac bejn perdon loj Dios, ad zajct guiëb bejn guial rayalaman perdon guin por ni beenman, din achut naya loj Dios. Perdon guin zëëdan guial rliladx bejn Jesucrist, zeel rüjn Dios bejn cwent ziꞌc bén ad yuꞌt xtol. ");
INSERT INTO zasNT_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Ziꞌc gunee rey Davi guial xiquilbaa ree bén been Dios cwent sin dol sin guial güün reeman xhienin par yayal reeman perdon guin. ");
INSERT INTO zasNT_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Rëbaman: Xiquilbaa ree bén been Dios perdon xtol, bén ma badxiꞌcaman xtol. ");
INSERT INTO zasNT_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Xiquilbaa ree bén ma been Dios cwent sin dol. ");
INSERT INTO zasNT_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Ad guneet Davi diidx guie ree naabzi par bén yuꞌ ree sen ni ru ree bén Israel, guneeman diidx guin ree par gra ree bejn. Din ziꞌc ma raguieꞌch ree, Dios been Abraham cwent ziꞌc bén ad yuꞌt xtol guial bililadxaman laaman. ");
INSERT INTO zasNT_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Abiꞌ chi biyabaman ziꞌc bén ad yuꞌt xtol, niꞌqui gadaman chuꞌ sen ni ru ree bén Israel, chi gad Abraham chuꞌ sen guin mal nüjn Dios laaman cwent ziꞌc bén ad yuꞌt xtol. ");
INSERT INTO zasNT_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Chi biabaman ziꞌc bén ad yuꞌt xtol, dxel guyuman sen guin din sen guin na̱j guial ma nüjn Dios laaman cwent ziꞌc bén ad yuꞌt xtol guial bililadxaman laaman. Zeel na̱j Abraham dad par ree bén rliladx Dios, majsi ad yuꞌt reeman sen ni ru ree bén Israel, per por guialrliladx guin nüjn Dios laa reeman cwent ziꞌc bén ad yuꞌt xtol. ");
INSERT INTO zasNT_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Naj tëë Abraham dad par ree bén majsi yuꞌ sen guin per rliladx reeman ziꞌc bililadx Abraham Dios diizd chi gadaman chuꞌ sen guin. ");
INSERT INTO zasNT_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Chi been Dios promejs loj Abraham në loj ree xdiaaman, guial gudëëdaman guidib guidxliuj loj reeman ziꞌc tijb ni bayal reeman, ad beent Dios promejs guin loj Abraham guial beenman ziꞌc rniabee ley, beenman promejs guin guial bililadxaman laaman, zeel beenman laaman cwent ziꞌc tijb bén ad yuꞌt xtol. ");
INSERT INTO zasNT_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Yan bal ganaxzi ree bén zinal ley guin tiaꞌ ni gudëë Dios, achet cwent na̱j guialrliladx ree bejn laaman, ache tëët cwent na̱j promejs ni been Dios loj Abraham. ");
INSERT INTO zasNT_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Din ley guin najn par castizi, per lod ad yuꞌt ley, ad yuꞌt mod chu guiëb guial ad cayüjnt bejn ley guin cumplid. ");
INSERT INTO zasNT_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Zeel chi been Dios promejs loj Abraham guial gudëëdaman ni rëbaman par gra ree xdiaaman, beenman promejs guin lojman guial bililadx Abraham guin laaman, din guiguien guial najman benzaꞌc abiꞌ ad parzi ree bén zinalt ley guin na̱j promejs guin, nëgajc par ree bén rliladx Dios ziꞌc bililadx Abraham majsi ad rajpt reeman ley guin. Zeel na̱j Abraham dad par dugra ree. ");
INSERT INTO zasNT_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Ziꞌc ca loj xtiidx Dios lod rëbaman loj Abraham: “Lüj gac dad par zien ree bénguidxliuj.” Zian na̱j promejs ni been Dios loj Abraham, Dios bén rusban ree bengüt abiꞌ rnieeman xcwent ree ni gad chuꞌ loj guidxliuj guie ziꞌc rulüü ma yuꞌ reen. ");
INSERT INTO zasNT_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Majsi ragbeechaaw Abraham guial ad zajctaman famil, per chi rëb Dios lojman zian, bililadxaman ni rëb Dios, bililadxaman guial gac gra ni rëbaman lojman. Zianan zeel najman dad par gra ree bén rliladx Dios ziꞌcgajc laaman. Ziꞌc rëb Dios lojman, chi rëbaman: “Zian gaquil famil, dád famil naroob gaquil.” ");
INSERT INTO zasNT_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Cost tibgayuu ijz ma yuꞌ Abraham nadxel, ragbeeman guial ma na̱j reeman bengol në xbéngunaaman Sara guial chuꞌ xiꞌn reeman, per ad guyunawëëgtaman, bililadxaman ni rëb Dios lojman. ");
INSERT INTO zasNT_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ad yuꞌt dxej ad bililadxtaman ni rëb Dios. Diidxli bililadxaman laaman abiꞌ rudëëman quixtëë lojman, ");
INSERT INTO zasNT_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","din guidiblagaa bililadxaman guial rajp Dios guialrniabee güünman ziꞌc ma rëbaman. ");
INSERT INTO zasNT_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Zeel been Dios cwent Abraham ziꞌc tijb bén ad yuꞌt xtol. ");
INSERT INTO zasNT_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Abiꞌ lod rëb guial been Dios laaman cwent ziꞌc bén ad yuꞌt xtol guial bililadxaman laaman, ad tijbtzi Abraham ruzaꞌt yagaj, ");
INSERT INTO zasNT_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","nëgajc dunuj ree din ma raliduladx ree Dios. Abiꞌ në dunuj ree ma nüjnman cwent ziꞌc bén ad yuꞌt xtol, Dios bén basban Dad Jesucrist loj guialgüjt, ");
INSERT INTO zasNT_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Dad Jesucrist bén güt por dux tol ree, dxel babanman abiꞌ por laaman ma naya ree loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Ma nüjn Dios dunuj ree cwent ziꞌc bén ad yuꞌt xtol guial raliduladx ree laaman, zeel ma nadxuꞌ ree zagdxe con laaman por xguialgüjt Dad Jesucrist. ");
INSERT INTO zasNT_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Din guial raliduladx ree Jesucrist ma zajc yadxin ree loj Dios abiꞌ nadxuꞌguijc ree ni ma beenman por dunuj ree, zeel dád nix yuꞌ du luxdoo ree din ralëëz ree yayal ree xanyabaa lod zaꞌman. ");
INSERT INTO zasNT_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Abiꞌ ad ziantzi, në guial yuꞌ du luxdoo ree zagdxe por guialrzagdiaj ni radüüd ree, din rayagbee ree por guialrzagdiaj guin yasiid ree yayaꞌp ree pasens. ");
INSERT INTO zasNT_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Abiꞌ por pacens guin yasiid ree yadaan ree ni guiꞌtzi, abiꞌ guial yadaan ree ma zajc yadxin ree loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Ni ralëëz ree por Dios, ad zasaꞌnxtutan dunuj ree, din rayagbee ree guial rën daꞌtaman dunuj ree por xSprijtaman bén ma baneeman duloj ree. ");
INSERT INTO zasNT_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Gocli babajn ree ad bileꞌt naguieen ree xhienin din güün Dios dunuj ree perdon. Per chi bidxin dxej biꞌt Cristo güjtaman por dunuj ree nayajc ree béndol. ");
INSERT INTO zasNT_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Dunuj ree rayagbee guial nawëëg na̱j chuꞌ bén tiëb guiët por zatijb bejn. Niꞌczi por tijb bén naban xnejz, o wed yuꞌ bén tiëb guiët por tijb benzaꞌc daꞌt. ");
INSERT INTO zasNT_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Per Dios ma balüüman guial rënman dunuj ree, zeel güjt Jesucrist por dunuj ree majsi nayajc ree béndol. ");
INSERT INTO zasNT_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Per yan ma naya ree loj Dios por xguialgüjt Jesucrist, abiꞌ ad ziantzi, në ad zayaltri ree xcasti Dios chi guidxin dxej. ");
INSERT INTO zasNT_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Din chi ad bileꞌt nadxin ree loj Dios, laaman guxhal nejz guin por xguialgüjt Xiꞌnman Jesucrist, diidxgui yan ad züjntaman dunuj ree perdon ya, guial ma nabajnnëꞌ ree Jesucrist, bén guxhal nejz par loj Dios. ");
INSERT INTO zasNT_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Abiꞌ ad laatzan, në guial yuꞌ du luxdoo ree nix radëëd ree quixtëë loj Dios por Dad Jesucrist, din por laaman ma nadxuꞌ ree zagdxe con Dios. ");
INSERT INTO zasNT_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Por tijb xinguiaaw guzuloj guyu dol loj guidxliuj, abiꞌ por dol guin guzuloj guyu guialgüjt, gra ree bejn bayal guialgüjt guin guial been reeman dol. ");
INSERT INTO zasNT_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Diizd chi gad ley ni badëëd Dios loj Moisejs chuꞌ mal yuꞌ dol, per guial achet ley guyu nadxel, achut zajc guiëb guial cayüjn bejn dol. ");
INSERT INTO zasNT_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Per majsi zian, bidxinczi dxej ni güt reeman, diizd xtiamp Adán xt xtiamp Moisejs, majsi ad beent reeman lasaꞌ dol ni been Adán. Abiꞌ tiampzii Adán gojc tijb sen par tijb bén na̱j guiꞌt. ");
INSERT INTO zasNT_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Din garen na̱j dol ni been Adán guial loj perdon ni zëëd por Dios. Por xtol tijb bejn guzuloj guyu guialgüjt par gra bejn, per por tijb bejn zëëd xperdon Dios, abiꞌ laaman na̱j Jesucrist. Por Jesucrist rüjn Dios dunuj ree perdon, abiꞌ ni been Jesucrist na̱j ni mazri lasajc, në ni mazri zagdxe par zien ree bejn. ");
INSERT INTO zasNT_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Din garen na̱j dol ni been Adán guial loj perdon ni runee Dios. Por tijb dol biꞌt xcasti Dios, per por Jesucrist ma zileꞌ gac bejn perdon, majsi ma beenman zien dol. ");
INSERT INTO zasNT_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Por dol ni been Adán biꞌt guialgüjt par gra ree bejn. Per por ni been Jesucrist biꞌt perdon par gra ree bén rliladx guial por Cristo ma na̱j bejn naya guidiblagaa loj Dios, abiꞌ gap reeman guialnaban tiblayaa con laaman. ");
INSERT INTO zasNT_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Abiꞌ guial biꞌt guialgüjt ziꞌc tijb casti par gra ree bejn por dol ni been Adán, ziangajc por ni zagdxe ni been Jesucrist ma zajc gap ree bejn perdon në guialn