﻿USE sofia;
DROP TABLE IF EXISTS sofia.zarNT_vpl;
CREATE TABLE zarNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zarNT_vpl WRITE;
INSERT INTO zarNT_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Bicaʼ ba bönniʼ bitiʼ runëʼ ca naca le taʼgúʼu yöl-laʼ lëʼ nupa tuʼcáʼana Dios, en bitiʼ ridálenëʼ tsözxö́n nupa tun dul-laʼ, en bitiʼ runëʼ tsözxö́n le tun nupa taʼzíʼ quidzaʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Le raza ládxëʼë nácagaca xibá naguixjëʼ Xanruʼ, en ca nácagaca xibá naʼ rëla, en te dza rulaba ládxëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Bönniʼ ni náquiëʼ ca tu yaga dxeʼ ga naca raʼ nisa, le ribía sizxöni cateʼ ridxín dza que, en bitiʼ caʼ rizóa gubáʼayisö. Yúguʼtë le runëʼ taʼrúaj dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Bitiʼ raca caní quégaca nupa tuáʼ döʼ. Nácagaca ca bëbu zxe café ruáʼ le böʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Que lë ni naʼ bitiʼ uluʼrúajëʼ tsahuiʼ bönniʼ tuʼë döʼ cateʼ Dios uchiʼa usörö́ëʼ quégaquiëʼ, en bitiʼ ilaʼcuʼë bönniʼ dul-laʼ ga tuʼdubëʼ bönniʼ tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Rapa chiʼë Xanruʼ Dios nöza ga taʼdë́ʼ bönniʼ tsahuiʼ naʼ, pero uniti tsaz nu ridá gapa taʼdá nupa tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","¿Bizx que tuʼtsatsa bönachi yuguʼ yödzö en tuʼpáʼa nítisö le ilúngaca? ");
INSERT INTO zarNT_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Bönniʼ taʼnná bëʼë luyú taʼdáʼbaguëʼë Dios. Tun tuz xtídzaʼgaca nupa dë lu náʼagaca para ilaʼdáʼbagaʼ Xanruʼ, en Nu naʼ nabö́ cazëʼ para inná bëʼë, ");
INSERT INTO zarNT_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","taʼnná: “Uzxuzxaj uquínnajruʼ le taʼnná béʼenëʼ rëʼu, en chúʼunaruʼ yuguʼ le tuʼzenëʼ bach rëʼu.” ");
INSERT INTO zarNT_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Dios naʼ zoëʼ yehuaʼ yubá uzxídxisëʼ. Xanruʼ Dios utitaj cazëʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Níʼirö lu yöl-laʼ rilé queëʼ güíʼilenëʼ léguequi didzaʼ, en lu yöl-laʼ ridzáʼa queëʼ uzenëʼ bach léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Innë́ʼ: “Nuzóa cazaʼ bönniʼ nabö́ cazaʼ xilatjëʼ ga inná bëʼë. Inná bëʼë lu Guíʼa Sión, le naca guíʼa láʼayi quiaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Quíxjöiʼidaʼ libíʼiliʼ didzaʼ nuzóëʼ tsaz Dios. Xanruʼ Dios gudxi cazëʼ nedaʼ: “Liʼ nacuʼ Zxíʼinaʼ. Naʼa dza nuzóa cazaʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Gunábini nedaʼ, ateʼ gunaʼ ga ilequi quiuʼ yuguʼ yödzö. Guequi caʼ quiuʼ idútë yödzölió. ");
INSERT INTO zarNT_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Quitsjuʼ léguequi len tu xiyaga guíë. Uzxuzxjuʼ léguequi ca run nu riláʼa tu zxigaʼ yö́ʼöna.” ");
INSERT INTO zarNT_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Que lë ni naʼ, libíʼiliʼ naʼ rinná bë́ʼëliʼ, guliʼtséajniʼi. Guliʼsedi cuinliʼ, núlöliʼ ruchiʼa rusöröliʼ le raca luyú. ");
INSERT INTO zarNT_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Lu yöl-laʼ baʼa ladxiʼ queë́liʼ guliʼgún xichinëʼ Xanruʼ. Lu yöl-laʼ rizxizi queë́liʼ buliʼsíʼ xibë́ʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Guliʼgún bal Zxíʼinëʼ Dios para cabí ilétenëʼ, en para cabí udxi queë́liʼ laʼ nöza. Laʼ ilentë yöl-laʼ rilé queëʼ. ¡Bicaʼ ba yúguʼtë nupa tuʼzxöni ladxiʼ Lëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Xan, chinayángacadaʼ nupa taʼlé nedaʼ. Zián nupa taʼdáʼbagaʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Zián nupa taʼnnë́ quiaʼ, taʼnná: “Bitiʼ usölë́ʼ Dios lëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Pero Liʼ, Xan, run chíʼiticaʼsuʼ nedaʼ. Nacuʼ yöl-laʼ ba quiaʼ, en Nu rutipa nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Bëʼa zidzaj didzaʼ, bulidzaʼ-nëʼ Xanruʼ, ateʼ Lëʼ biyönnëʼ chiʼa ga naʼ zoëʼ lataj láʼayi queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Nedaʼ rataʼ, en rasiaʼ, ateʼ rubanaʼ, tuʼ nazö́nticaʼsëʼ Xanruʼ Dios nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Bitiʼ gádxidaʼ gayuáʼ gayuáʼ bönachi, nupa naʼ nagúʼugaca nedaʼ lë́ʼajlö. ");
INSERT INTO zarNT_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","¡Guyasa, Xan! ¡Busölá nedaʼ, Dios quiaʼ! Budxía huëʼ xágaʼgaca nupa tuʼdíʼi nedaʼ, en buquínnajdaʼ nupa nácagaca xihuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Xan, rusölá cazuʼ bönachi quiuʼ. Ben ga gaca dxiʼa quégaca bönachi quiuʼ. ¡Caʼ gaca! ");
INSERT INTO zarNT_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Bubíʼi didzaʼ cateʼ rulidzaʼ Liʼ, Dios. Nacuʼ Nu ruchiʼa rusörö́ le raca quiaʼ. Cateʼ guröʼa böniga, bida cazuʼ Liʼ ga zoaʼ, en gúcalenuʼ nedaʼ. Ruhuéchiʼ ladxiʼ nedaʼ, en ruzë́ naguʼ le rinábidaʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Rnnëʼ Dios: “Libíʼiliʼ, bönachi, ¿gácaʼxte ulidza dítajliʼ nedaʼ? ¿Gácaʼxte caz idxíʼiliʼ le cabí nazacaʼ, en güíʼi ládxiʼliʼ le cabí naca?” ");
INSERT INTO zarNT_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Guliʼtsöjné nabö́ cazëʼ Xanruʼ nu radxi Lëʼ, ateʼ riyönnëʼ nedaʼ cateʼ rulidzaʼ-nëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Guliʼgadxi Lëʼ, en bítiʼrö gunliʼ dul-laʼ. Guliʼsáʼ ladxiʼ ca naca lë ni cateʼ dëliʼ ga rátaʼliʼ, en guliʼsóa dxisö. ");
INSERT INTO zarNT_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Guliʼcúʼu lahuëʼ Xanruʼ le naca dxiʼa, en buliʼzxöni ladxiʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Zián nupa taʼnná: “¿Nuzxi caz gun ga gaca dxiʼa queë́ruʼ?” Lu yöl-laʼ dxiʼi ladxiʼ quiuʼ buyú netuʼ, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Runuʼ ga rudzéjadeʼerödaʼ ca tuʼdzeja nupa tuʼzíʼ xibé zxoaʼ za guizxi yu, en xisi lubá uva. ");
INSERT INTO zarNT_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Cateʼ rataʼ, laʼ rásitiaʼ lu yöl-laʼ riböza dxi ladxiʼ quiaʼ, tuʼ run cazuʼ Liʼ, Xan, ga ribözaʼ dxiʼa tsáhuiʼdoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Ruzë́ naguʼ didzaʼ ruáʼa, Xan. Buyú ca rinnëdaʼ ládxaʼa lu yöl-laʼ ruhuíʼini quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Dios quiaʼ, Nu rinná beʼe nedaʼ, ruzë́ naguʼ cateʼ rinábidaʼ Liʼ gácalenuʼ nedaʼ, naʼ güíʼilenaʼ Liʼ didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Yuguʼ zila yönnuʼ chiʼa. Zíladoʼ idxinaʼ loʼ, en cözaʼ didzaʼ ubiʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Nacuʼ Liʼ Dios bitiʼ raza ládxuʼu le cabí naca, en bitiʼ ruʼu lataj ibigaʼ ga zuʼ nu ruáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Bitiʼ ruʼu lataj nupa tun ba rahui ilaʼdxín loʼ, en bitiʼ riléʼenuʼ dxiʼa nupa nácagaca xihuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Rusunítiuʼ dërö nupa taʼzíʼ yeʼe luzë́ʼeguequi, en bitiʼ riléʼenuʼ dxiʼa nupa tuti bönachi, en taʼzíʼ yëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Gaca tsuʼa nedaʼ lu yuʼu lidxuʼ, tuʼ nadxíʼideʼenuʼ nedaʼ. Lu yöl-laʼ baʼa ladxiʼ quiaʼ tsuʼa ga naca yudoʼ láʼayi quiuʼ, en tseaj ládxaʼa Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Tuʼ nacuáʼ zián nupa taʼlé nedaʼ, buluíʼi nedaʼ le naca dxiʼa rë́ʼënuʼ gunaʼ, Xan. Busëdi nedaʼ para gaca gunaʼ ca rë́ʼënuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Bitiʼ gaca nu tseajlë́ʼ didzaʼ tuíʼi nupa naʼ taʼlé nedaʼ. Nácagaca xihuiʼ icja ládxiʼdoʼguequi. Naca ruáʼagaca ca tu yeru ba nayalaj, en lu yöl-laʼ rizíʼ yëʼ quéguequi tuíʼi yulaj didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Ben léguequi xiguiaʼ, Dios. Ben ga bitiʼ udxín xtídzaʼguequi. Gurúʼuna léguequi tuʼ túnticaʼsö dul-laʼ, en tuʼ taʼdáʼbagaʼ xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Uluʼdzeja nupa tuʼzxöni ladxiʼ Liʼ. Lu yöl-laʼ rudzeja quéguequi gúl-lagaca quiuʼ tuʼ rácalenuʼ léguequi. Tuʼzíʼ xibóʼ nupa nadxíʼigaca Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Run cazuʼ Liʼ ga raca dxiʼa quégaca nupa tun ca rnna xtídzuʼu, Xan. Lu yöl-laʼ dxiʼi ladxiʼ quiuʼ run chiʼu léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Bitiʼ uzenuʼ bach nedaʼ lu yöl-laʼ rilé quiuʼ, Xan. Bitiʼ gunuʼ nedaʼ xiguiaʼ lu yöl-laʼ ridzáʼa quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Buéchiʼ ladxiʼ nedaʼ, Xan, tuʼ rudú ládxaʼa. Bun nedaʼ, Xan, tuʼ riguíʼi rizácaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Röʼö böniga idútë le nacaʼ. ¿Gácaʼxte caz gaca caní, Xan? ");
INSERT INTO zarNT_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Gudá dusölóʼ nedaʼ, Xan. Tuʼ nadxíʼinuʼ nedaʼ, busölá nedaʼ lu yöl-laʼ guti. ");
INSERT INTO zarNT_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Lu lataj chul-la cuntu nu tsöjné Liʼ. Cuntu nu zoa niʼ nu gaca cuʼu Liʼ yöl-laʼ ba. ");
INSERT INTO zarNT_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Rudú ládxaʼa tuʼ rinnë́ticaʼsö ládxaʼa. Yuguʼ dzöʼ ribisa le rátiʼdaʼ len nisa ribödxi quiaʼ. Rusubisaʼ xcúguaʼ len nisa ribödxi quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Röʼö gui guiö́j lahuaʼ tuʼ ribö́dxiticaʼsaʼ. Bitiʼ gaca iléʼedaʼ tuʼ nö́zigaca nupa tuʼdíʼi nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Guliʼcuíta ga zoaʼ, libíʼiliʼ, ruáʼaliʼ döʼ, tuʼ riyönnëʼ Xanruʼ ribödxaʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Ruzë́ naguëʼ le rulidzaʼ, rátaʼyuaʼ lahuëʼ, en rubiʼë didzaʼ cateʼ bi rinábidaʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Uluʼtuíʼi nupa tuʼdíʼi nedaʼ, en ilaʼbö́ʼ böniga. Lu yöl-laʼ rutuíʼi quéguequi uluʼbigaʼ ga zoaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Ruzxöni ládxaʼa Liʼ, gácalenuʼ nedaʼ, Xanaʼ Dios. Busölá nedaʼ lu náʼagaca nupa taʼbía no nedaʼ, en gúcalen nedaʼ ");
INSERT INTO zarNT_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","para cabí soa nu cuéaj nedaʼ ca runbaʼ bëdxi guixiʼ, en para cabí usuniti nedaʼ ga cuntu nu zoa gácalen nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","Xanaʼ Dios, channö caní nunaʼ: Channö nabágaʼa xiguiaʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","o channö bubiʼa döʼ que nu gúcalen nedaʼ, o channö biʼa döʼ que nu bitiʼ bi ben quiaʼ lu bitiʼ riléʼe nedaʼ dxiʼa, ");
INSERT INTO zarNT_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","bëʼ lataj soa reguʼ nedaʼ nu naʼ bitiʼ riléʼe nedaʼ dxiʼa, en ucul-la nedaʼ. Bëʼ lataj nu naʼ quin nedaʼ lu yu, en ucáʼana nedaʼ cáʼasö. ");
INSERT INTO zarNT_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Lu yöl-laʼ rilé quiuʼ guyasa, Xan. Gudáʼbagaʼ nupa naʼ lu yöl-laʼ ridzáʼa quéguequi táʼbagaʼ nedaʼ. Guyasa, gúcalen nedaʼ tuʼ nacuʼ Nu ruchiʼa rusörö́ le raca quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Ben ga uluʼdubi quiuʼ yúguʼtë bönachi, en gunná beʼe léguequi ga niʼ zuʼ xitsáʼtërö. ");
INSERT INTO zarNT_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Ruchiʼa rusörö́uʼ quéguequi yúguʼtë bönachi, Xan. Bubéaj nedaʼ tsahuiʼ, Xan, tsca naca le tsahuiʼ nunaʼ, en tuʼ nacaʼ idú tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Ben ga udxi que le xihuiʼ tun nupa tuáʼ döʼ, pero buzóa tsutsu nupa tun le naca dxiʼa, tuʼ nacuʼ Liʼ idú tsahuiʼ, Dios, en ruchiʼa rusörö́uʼ le taʼzáʼ ládxiʼgaca bönachi, en le taʼguínnaj ícjaguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Naca cazëʼ Dios Nu run chiʼi nedaʼ. Rusölë́ʼ nupa nácagaca idú ladxiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Dios ruchiʼa rusörö́ëʼ queëruʼ ca naca le naca tsahuiʼ, en richúguticaʼsëʼ quégaca nupa tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Channö cabí uluʼbíʼi ladxiʼ bönachi, utuchëʼ guíë tuchiʼ queëʼ. Chinucözëʼ uxitiʼ yaga queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Chinupë́ʼë yuguʼ le rudíʼinëʼ lu gudil-la, en nudxíëʼ lu du uxitiʼ yuguʼ yaga túchiʼdoʼ zoa guíʼ láhuiguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Buyútsöcaʼ, riguínnaj icjëʼ bönniʼ ruʼë döʼ le xihuiʼ gunëʼ. Ruíʼi ládxëʼë le naca döʼ, en rizíʼ yëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Nachö́ʼönëʼ ga rëʼ tu yeru zxön ga nu ibixi, pero lë cazëʼ yöjbixëʼ lu yeru naʼ guchö́ʼönëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Budxín laʼ queë́zëʼ döʼ naʼ biʼë, en dxíëʼ huëʼ ca naca xiguiaʼ nabáguëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Guíaʼ-nëʼ Xanruʼ: “Xclenuʼ” tuʼ náquiëʼ tsahuiʼ, en gul-laʼ yöl-laʼ ba que Lëʼ Xanruʼ, Nu nayë́pisëtërö. ");
INSERT INTO zarNT_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","¡Xanaʼ Dios, bicaʼ ba Loʼ idútë yödzölió! ¡Xitsáʼtërö ca lúzxiba nayë́pisuʼ Liʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Túl-labiʼ bíʼidoʼ, encaʼ biʼi huë́ʼënidoʼ yöl-laʼ zxön quiuʼ sal-laʼ nacuáʼ nupa taʼdáʼbagaʼ Liʼ. Uzóa dxíuʼ nupa naʼ bitiʼ taʼléʼe Liʼ dxiʼa, encaʼ nupa taʼdáʼbagaʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Cateʼ ruyúaʼ lúzxiba quiuʼ, le nunuʼ len xibö́n naʼzuʼ, encaʼ beuʼ, en yuguʼ bölaj beníʼ nuzúʼ xilátjaguequi, ");
INSERT INTO zarNT_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","níʼirö rnníaʼ: ¿Bizxi caz bönniʼ, tuʼ röjné cazuʼ lëʼ? ¿Bizxi caz nu naca bönáchisö, tuʼ ruíʼi ládxuʼu Liʼ nu naʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Nunuʼ ga naquiëʼ bönniʼ iaʼlatiʼ cuidiʼ ca naca cazuʼ Liʼ. Nuzúʼ queëʼ yöl-laʼ ba quiuʼ, en yöl-laʼ run bal ca tu le néquini oro dxía icjëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Nunuʼ ga rinná béʼenëʼ yuguʼ le nun cazuʼ Liʼ. Yúguʼtë nuzúʼ xiniʼë lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Nuzúʼ xiniʼë yúguʼtëbaʼ böʼcuʼ zxilaʼ, en yúguʼtëbaʼ bëdxi, ");
INSERT INTO zarNT_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","en lës caní nunuʼ caʼ quégacabaʼ biguínnidoʼ, en quégacabaʼ böla dzö́ʼöbaʼ nísadoʼ, encaʼ quégacabaʼ yúguʼtëbaʼ böaʼ taʼdö́dibaʼ lu nísadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","¡Xanaʼ Dios, bicaʼ ba loʼ idútë yödzölió! ");
INSERT INTO zarNT_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","¡Idú ládxaʼa riguʼa Liʼ yöl-laʼ ba, Xan! ¡Usiyöndaʼ bönachi ca naca yúguʼtë yöl-laʼ huáca nunuʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","¡Udzéjadaʼ, en uziʼa xibóʼ! ¡Gul-laʼ yöl-laʼ ba que Loʼ, tuʼ nayë́pisëtëruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","¡Taʼzxunnaj nupa taʼdáʼbagaʼ nedaʼ! ¡Taʼdzö́ʼö, en tuʼniti loʼ Liʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","tuʼ nubéajuʼ tsahuiʼ le naca dxiʼa runaʼ! ¡Röʼu ga rinná bëʼu, en ruchiʼa rusörö́uʼ queë́tuʼ ca naca le naca tsahuiʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Bulidza ziʼu yuguʼ yödzö, en busunítiuʼ nupa tuáʼ döʼ. Tsaz busuluʼ lu guichi quiuʼ gapa gulaʼzúaj láguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Chigulaʼniti nupa gulaʼdáʼbagaʼ Liʼ. Tsaz naguínnajgaca gapa gulaʼcuáʼ. Busunítiuʼ yuguʼ yödzö gapa naʼ gulaʼcuáʼ, ateʼ cuntu nu zoa röjné yuguʼ yödzö naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Zóaticaʼsëʼ Xanruʼ Dios. Naguixjëʼ tsaz lataj ga röʼë rinná bëʼë en ruchiʼa rusörö́ëʼ quégaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Uchiʼa usörö́ëʼ quégaca bönachi yödzölió lu le naca tsahuiʼ. Uchiʼa usörö́ëʼ quégaca yuguʼ yödzö lu le nácatë. ");
INSERT INTO zarNT_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Gun chiʼë Xanruʼ Dios nupa nácagaca yechiʼ. Gácalenëʼ léguequi cateʼ nu gun léguequi ziʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Uluʼzxöni ladxiʼ Liʼ nupa núnbëʼgaca Loʼ. Caní gaca, Xan, tuʼ cabí nusán ládxuʼu nupa tuʼguilaj Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Guliʼgul-la yöl-laʼ ba queëʼ Xanruʼ, zoëʼ ga naʼ nazíʼi le Sión. Buliʼsiyö́n bönachi yuguʼ yödzö ca naca yuguʼ le nunëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Bitiʼ ral-la ládxëʼë nupa taʼguíʼi taʼzacaʼ cateʼ tuʼlidza Lëʼ, tuʼ röjné léguequi Nu naʼ ruzíʼ lëbi nu ruti bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Buéchiʼ ladxiʼ nedaʼ, Xan. Buyú ca tun nedaʼ ziʼ nupa tuʼdíʼi nedaʼ. Ruchisuʼ Liʼ nedaʼ cateʼ chirequi gátiaʼ ");
INSERT INTO zarNT_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","para gaca usiyöndaʼ bönachi yöl-laʼ ba quiuʼ Liʼ. Ga naca ga nu tsaza yödzö quiuʼ nazíʼi le Sión, udzéjadaʼ tuʼ nusölóʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Yöjbíxigaca bönachi yuguʼ yödzö lu yeru gulaʼchö́ʼöna ga tsöjbíxigaca luzë́ʼeguequi. Bilaʼröli niʼaguequi lu yöxaj buluʼcachiʼ para ilaʼzö́n léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Chinunëʼ Xanruʼ Dios ga núnbëʼgaca bönachi Lëʼ tuʼ buchiʼa busörö́ëʼ quéguequi. Lu lë naʼ nun nu ruáʼ döʼ zön laʼ cuinsi. ");
INSERT INTO zarNT_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Ilaʼyaza lataj chul-la nupa tuáʼ döʼ, yúguʼtë nupa naʼ nal-la ládxiʼgaca Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Calëga tsaz uluʼgáʼana cáʼasö nupa taʼyadzaj taʼyudxi, en bitiʼ initi tsaz yöl-laʼ run löza quégaca nupa nácagaca yechiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Guyasa, Xan. Bitiʼ guʼu lataj tsë́pisë nu naca bönáchisö. Buchiʼa busörö́ quégaca bönachi yuguʼ yödzö. ");
INSERT INTO zarNT_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Buxö́s léguequi, Xan. Ben ga uluʼúnbëʼ le nácgaca, tuʼ nácagacasö bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","¿Bizx que zuʼ ziʼtuʼ, Xan? ¿Bizx que rucachiʼ loʼ cateʼ bi raca quiaʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Lu yöl-laʼ run ba rahui quégaca nupa tuáʼ döʼ taʼbía no nupa nácagaca yechiʼ. Ben ga ilaʼzö́n du yalaj naʼ nucáchiʼgaca laʼ léguequisö. ");
INSERT INTO zarNT_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Run ba zxön cuinëʼ bönniʼ ruʼë döʼ ca naca le xihuiʼ rizë́ ládxëʼë. Bönniʼ ruhuídiʼnëʼ rulidza ditjëʼ luzë́ʼë, en ruzóëʼ Dios tsöláʼalö. ");
INSERT INTO zarNT_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Lu yöl-laʼ run ba zxön cuinëʼ bönniʼ huíaʼ döʼ bitiʼ ruíʼi ládxëʼë Dios. Rizáʼasö ládxëʼë, rnnëʼ: Bitiʼ caʼ zoa Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Ruziʼë xibé yúguʼtë le runëʼ. Bitiʼ caʼ réquibeʼenëʼ zoëʼ Dios Nu ruchiʼa rusörö́ quégaca bönachi. Ruzóëʼ tsöláʼalö nupa bitiʼ taʼléʼe lëʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Rëʼ laʼ cuinsëʼ: “Gatga ichíxidaʼ. Catu caz bi gaca quiaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Didzaʼ ruʼë nácagaca le rudxía döʼ, encaʼ le rizíʼ yëʼ, en le rudidzaʼ yudxi yuguʼ luzë́ʼë. Ruíʼiticaʼsëʼ didzaʼ le cabí nácatë, en le naca xihuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Rucachiʼ cuinëʼ yuguʼ lu yödzö. Bagáchiʼsö rútiëʼ nupa bitiʼ bi nabágaʼgaca. Ruyúlanëʼ nu bi gaca gun que. ");
INSERT INTO zarNT_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Ribözëʼ ga naʼ nucachiʼ cuinëʼ ca runbaʼ bëdxi guixiʼ. Ribözëʼ nu gaca sönëʼ. Rizönëʼ bönniʼ yechiʼ lu du yalaj queëʼ, en ráʼayöjëʼ lëʼ ga nagachiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Riguinëʼ luyú nu naʼ nazönëʼ. Zián nupa rucul-lëʼ len nëʼë nal-la. ");
INSERT INTO zarNT_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Rëʼ laʼ cuinsëʼ: “Nal-la ládxëʼë Dios. Nucachiʼ lahuëʼ, en bitiʼ caʼ riléʼenëʼ le runaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","¡Guyasa, Xan! ¡Gulís noʼo, Dios! ¡Bitiʼ gal-la ládxuʼu nupa taʼguíʼi taʼzacaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","¿Bizx que bönniʼ naʼ ruʼë döʼ nuzóëʼ Dios tsöláʼalö? Gudxëʼ laʼ cuinsëʼ: Bitiʼ uzíʼ lëʼ Dios nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Liʼ biléʼe quézinuʼ lë ni, Xan. Ruíʼi ládxuʼu nu riguíʼi rizácaʼ, en nu risëbi ladxiʼ, en zóaticaʼsuʼ gácalenuʼ léguequi. Nu naca bayechiʼ rigúʼu cuini lu noʼo, Xan, tuʼ zóaticaʼsuʼ gácalenuʼ nu riyadza riyudxi. ");
INSERT INTO zarNT_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Bugúa yöl-laʼ unná bëʼ quégaca nupa tuáʼ döʼ, en nácagaca xihuiʼ. Bubíʼi quéguequi ca naca xiguiaʼ nabágaʼgaca. ");
INSERT INTO zarNT_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Inná bë́ʼticaʼsëʼ Xanruʼ Dios. Nupa tuʼbéaj ícjaguequi Xanruʼ uluʼniti tsaz lu xiyú cazëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Ruzë́ naguʼ, Xan, le taʼnábini Liʼ nupa nácagaca doʼ ladxiʼ. Rutipuʼ ládxiʼguequi, en ruzë́ naguʼ chíʼiguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Ruchiʼa rusörö́uʼ quégaca nupa nácagaca uzëbi, en nupa zoa nu ribía no léguequi, para cabirö uluʼxösa bönachi yödzölió ni luzë́ʼeguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Ruzxöni ládxaʼa Xanruʼ gácalenëʼ nedaʼ. ¿Naruʼ guíëtsoʼ nedaʼ: “Buzxúnnaj lu guíʼa ca runbaʼ biguínnidoʼ”? ");
INSERT INTO zarNT_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Buyútsöcaʼ, zö́ngaca nupa tuáʼ döʼ yaga uxitiʼ. Nuzóagaca yágadoʼ lahui tuchiʼ lu du rusé, para ilútiëʼ bagáchiʼsö nupa nácagaca dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Channö ilaʼguínnaj yuguʼ le tuʼzóa tsutsu le naca dxiʼa, ¿bizxi caz gaca gun nu naca tsahuiʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","¡Zoa cazëʼ Xanruʼ yudoʼ láʼayi queëʼ! Yehuaʼ yubá zoa ga röʼë rinná bëʼë Xanruʼ Dios. Riléʼe guiö́j lahuëʼ para uyúëʼ le tun bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Rizíʼ bëʼë Xanruʼ nu naca tsahuiʼ. Bitiʼ riléʼenëʼ dxiʼa nu ruáʼ döʼ, en nu raza ladxiʼ taʼdáʼbagaʼ yúlahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Gunëʼ ga sácaʼgaca nupa tuáʼ döʼ le usuniti léguequi. Ubiʼë quéguequi guíʼ, en le ruquélaʼ guíʼ, en tu böʼ régui. ");
INSERT INTO zarNT_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Caní gunëʼ Xanruʼ tuʼ náquiëʼ tsahuiʼ, en nadxíʼinëʼ le naca tsahuiʼ. Nupa tun le nácatë ilaʼléʼe lahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Busölá nedaʼ, Xan, tuʼ cabirö zoa nitú nu naca dxiʼa, en bitiʼ gaca nu idzöli nitú nu run ca rnna xtídzaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Taʼzíʼ yeʼe yúguʼtë bönachi luzë́ʼeguequi. Lu yöl-laʼ rizíʼ yëʼ quéguequi tuíʼilen luzë́ʼeguequi didzaʼ yúlajdoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Xan, buzóa dxisö nupa naʼ tuíʼi didzaʼ yúlajdoʼ, en buzagaʼ ruíʼigaca nupa tun ba zxön cuínguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Taʼnná: “Güíʼiruʼ didzaʼ ca rizësö ládxiʼruʼ, ateʼ cuntu nu táʼbagaʼ rëʼu. ¿Nuzxi caz inná beʼe rëʼu ca naca didzaʼ ruíʼiruʼ?” ");
INSERT INTO zarNT_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Rnnëʼ Xanruʼ: “Naʼa guídaʼ tuʼ nacuáʼ nupa tun ziʼ nupa taʼyadzaj taʼyudxi, ateʼ rinnë́ ládxiʼgaca nupa ni tuʼ zoa nu ribía no léguequi. Ca taʼzësö ládxiʼgaca, laʼ guídateaʼ dusöláʼ léguequi.” ");
INSERT INTO zarNT_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Huáca uzxöni ládxiʼruʼ didzaʼ ruʼë Xanruʼ. Nácagaca ca guíë plata ba nequi, le nudxiʼa gadxi luzuí tu lu guíʼ lálëʼe. ");
INSERT INTO zarNT_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Liʼ caz, Xan, gun chiʼu léguequi, en usölóʼ léguequi lu náʼagaca nupa tuáʼ döʼ naʼa dza. ");
INSERT INTO zarNT_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Gátiʼtës nacuáʼ nupa tuáʼ döʼ, cateʼ tun zxön bönachi le ruáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","¿Gácaʼxte caz gal-la ládxuʼu nedaʼ, Xan? ¿Naruʼ tsaz gal-la ládxuʼu nedaʼ? ¿Gácaʼxte caz ucacheʼ cuinuʼ lahuaʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","¿Gácaʼxte caz gun bayudxi guáʼ ilenaʼ le réquidaʼ ziʼ? ¿Gácaʼxte caz huíʼinidaʼ rëla, en te dza? ¿Gácaʼxte caz ucúl-lágaca nedaʼ nupa taʼdáʼbagaʼ nedaʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Buyú nedaʼ, Xan, en bubíʼi didzaʼ. Butipa ládxaʼa para cabí gátiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Níʼirö bitiʼ gaca ilaʼnná nupa taʼdáʼbagaʼ nedaʼ, bitiʼ ilaʼnná: “Bucúl-laruʼ lëʼ.” Bitiʼ gaca uluʼdzeja tuʼ nö́tjadaʼ ládxaʼa nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Nedaʼ ruzxöni ládxaʼa yöl-laʼ dxiʼi ladxiʼ quiuʼ. Rudzéjadaʼ tuʼ rusölóʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Gul-laʼ queëʼ Xanruʼ, tuʼ benëʼ quiaʼ le naca dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Lu icja ládxiʼdaʼahuëʼ rnnëʼ bönniʼ tuʼ canö́z, rnnëʼ: Bitiʼ zoa caz Dios. Nachixi nanítigaquiëʼ bönniʼ caní, en tunëʼ le cabí riléʼenëʼ dxiʼa Dios. Cuntu nu zoa nu run le naca dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Ga zoëʼ Dios yehuaʼ yubá buyúëʼ luyú ni ga nacuáʼ bönachi para iléʼenëʼ channö zoa nu réajniʼi, nu naʼ riguilaj Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Yúguʼtëʼ nadö́digaquiëʼ tsöláʼalö. Nachixi nanítigaquiëʼ tu tuëʼ. Cuntu nu zoa nu run le naca dxiʼa, nitú bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","¿Naruʼ cabí taʼyéajniʼi nupa tuáʼ döʼ? Le tun nupa naʼ naca tsca tagu bönachi quiaʼ ca nu ragu yöta. Bitiʼ caʼ tuʼlidza nedaʼ, Xángaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Lu yöl-laʼ radxi ridzöbi quéguequi taʼzxizi tuʼ taʼléʼe Xanruʼ Dios, en zóalenëʼ bönachi tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Tuʼtitaj xtídzaʼgaca nupa nácagaca yechiʼ, pero nupa ni tuʼzxöni ladxiʼ gácalenëʼ Xanruʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Raca ládxaʼa irúaj Sión Nu usölá bönachi Israel. Cateʼ gunëʼ Xanruʼ ga uluʼdxín bönachi queëʼ nadzúngaca xilátjaguequi, uluʼdzeja zxíʼini xiʼsóëʼ Jacob, bönachi Israel, en uluʼzíʼ xibë́ʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","¿Nuzxi caz bönachi tsöjsóa xilatjuʼ, Xan? ¿Nuzxi caz tsöjsóa ga naca láʼayi quiuʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Nu naʼ naca idú ladxiʼ, en run le naca tsahuiʼ, en lu icja ládxiʼdaʼahui ruíʼi didzaʼ le nácatë. ");
INSERT INTO zarNT_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Nu naʼ bitiʼ rizíʼ quidzaʼ bönachi, en bitiʼ ruáʼ döʼ que luzë́ʼe, en bitiʼ ruzë́ naga nu rizíʼ quidzaʼ luzë́ʼe. ");
INSERT INTO zarNT_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Nu naʼ bitiʼ run bal nu ruáʼ döʼ, pero run bal nupa tun zxön Dios, en sal-laʼ bi uniti cateʼ chinún xtidzaʼ, bitiʼ caʼ rutsáʼ didzaʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Nu naʼ bitiʼ rizíʼ icja dumí cateʼ runödzaj dumí que tu chíʼidoʼsö, en bitiʼ rizíʼ dumí para siʼ yëʼ ca naca le nun nu bitiʼ nabagaʼ xiguiaʼ. Nu naʼ run yúguʼtë le caní bitiʼ caʼ idzáʼ xilataj. ");
INSERT INTO zarNT_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Ben chiʼi nedaʼ, Dios, tuʼ ruzxöni ládxaʼa Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Lu icja ládxiʼdaʼahuaʼ gudxaʼ-nëʼ Xanruʼ: “Liʼ nacuʼ Xanaʼ. Bítiʼrö bi zoa quiaʼ le naca dxiʼa, pero tuzuʼ Liʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Riyaza ládxiʼlenaʼ nupa nácagaca queëʼ Dios luyú ni, en nupa nácagaca idú ladxiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Ilaʼyán le ilaʼguíʼi ilaʼzacaʼ nupa taʼyéaj ladxiʼ yuguʼ dios izáʼa. Bitiʼ caʼ cuʼa láhuiguequi rön ca tun bönachi naʼ, en bitiʼ ulidzaʼ lágaca dios naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Náquiëʼ Xanruʼ Dios Nu nabánidaʼ, en Nu ruziʼa xibé. ");
INSERT INTO zarNT_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Liʼ, Xan, nuzúʼ xilatjaʼ. Lataj naʼ nuzúʼ quiaʼ naca le ruziʼa xibé, en lachi naca lataj naʼ nequi quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Gul-laʼ yöl-laʼ ba queëʼ Xanruʼ, Nu rigúʼu yöl-laʼ nedaʼ le naca tsahuiʼ, ga ridxintë ruzéajniʼinëʼ nedaʼ cateʼ niʼ rasiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Chinunaʼ ga zóaticaʼsëʼ Xanruʼ lahuaʼ. Tuʼ zoëʼ cuitaʼ bitiʼ bi utsáʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Que lë ni naʼ budzeja ládxaʼa, en buzíʼ xibé ládxiʼdaʼahuaʼ, ateʼ gun löza le nacaʼ cateʼ igáchaʼa yeru ba, ");
INSERT INTO zarNT_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","tuʼ cabí ucáʼanuʼ nedaʼ lataj chul-la, en bitiʼ guʼu lataj uniti nu nequi quez quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Nunuʼ ga núnbëʼa nöza ichë́ʼ nedaʼ ga soaʼ ibanaʼ. Ga zuʼ Liʼ gataʼ quiaʼ yöl-laʼ rudzeja idú, ateʼ cuituʼ Liʼ uzíʼticaʼsaʼ xibóʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Ruzë́ naguʼ nedaʼ, Xan. Lu le naca tsahuiʼ quiaʼ rulidzaʼ Liʼ. Bëʼ ladxiʼ le rinábidaʼ Liʼ tuʼ cabí caʼ rizíʼ yëʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Buchiʼa busörö́ quiaʼ tuʼ runuʼ Liʼ le naca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Núnbëʼu Liʼ le yuʼu ládxiʼdaʼahuaʼ. Ruyúʼ nedaʼ chiʼi dzö́ʼölö. Guzxíʼ bëʼu nedaʼ, ateʼ burúajaʼ tsahuiʼ. Bitiʼ caʼ ruáʼa didzaʼ le cabí naca idú dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Runaʼ ca rinná bëʼ xibá quiuʼ, en bitiʼ caʼ ruáʼa döʼ ca tun bal-la bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Ridáticaʼsaʼ laʼ nöza tsahuiʼ quiuʼ, en bitiʼ caʼ ridödaʼ tsöláʼalö. ");
INSERT INTO zarNT_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Rulidzaʼ Liʼ, Dios, tuʼ rubiʼu didzaʼ. Ruzë́ naguʼ yuguʼ didzaʼ ruáʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Buluíʼi lahui yöl-laʼ dxiʼi ladxiʼ quiuʼ. Rusölá cazuʼ nupa tuʼzxöni ladxiʼ Liʼ lu náʼagaca nupa taʼdáʼbagaʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Ben chiʼi nedaʼ ca run chiʼu laʼ guiöj lo cazuʼ. Bucachiʼ nedaʼ cuituʼ Liʼ ca runbaʼ böra, rucáchiʼgacabaʼ bö́radoʼ zxan xílabaʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","para cabí bi ilún quiaʼ nupa tuáʼ döʼ, nupa naʼ taʼlé nedaʼ, en nagúʼugaca nedaʼ lë́ʼajlö. ");
INSERT INTO zarNT_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Bitiʼ caʼ zóalen léguequi yöl-laʼ ruhuéchiʼ ladxiʼ, ateʼ tuíʼi didzaʼ lu yöl-laʼ run ba zxön cuínguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Gátiʼtës ga ridödaʼ taʼgúʼu nedaʼ lë́ʼajlö, en të́ʼëni ilaʼguín nedaʼ luyú. ");
INSERT INTO zarNT_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Nácagaquiëʼ ca yuguʼ bëdxi guíxiʼdoʼ. Të́ʼënëʼ uluʼsunítiëʼ nedaʼ. Nácagaquiëʼ ca yuguʼ bëdxi guixiʼ. Nucachiʼ cuíngaquiëʼ para ilaʼzönëʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Gudá, Xan, gudáʼbagaʼ nupa taʼlé nedaʼ, en bucul-la léguequi. Busölá nedaʼ lu náʼagaca nupa tuáʼ döʼ, ugunuʼ dxin guíë tuchiʼ quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Lu yöl-laʼ huáca zxön quiuʼ busölá nedaʼ, Xan, lu náʼagaca nupa tuʼzíʼ xibé naʼa dza, nupa naʼ nuhuö́laj nudzë́ʼegaca yöl-laʼ tsahuiʼ quiuʼ. Nayángacabiʼ zxíʼinigaquiëʼ, ateʼ tuʼcáʼanëʼ lu náʼagacabiʼ le dë sizxöni quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","pero nedaʼ iléʼedaʼ loʼ tuʼ nacaʼ tsahuiʼ, en tsaza ládxaʼa gacaʼ ca nacuʼ Liʼ cateʼ ubanaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","¡Nadxíʼideʼedaʼ Liʼ, Xan! ¡Liʼ rutipa cazuʼ ládxaʼa! ");
INSERT INTO zarNT_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Ruzóëʼ Xanruʼ nedaʼ tsutsu, en rapa chiʼë nedaʼ, en rusölë́ʼ nedaʼ. Náquiëʼ Dios quiaʼ, en Nu rutipa ládxaʼa, ateʼ ruzxöni ládxaʼa Lëʼ. Rácalenëʼ nedaʼ lu gudil-la: Rusölë́ʼ nedaʼ, en rizönëʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Rulidzaʼ-nëʼ Xanruʼ Nu ral-laʼ cúʼuruʼ yöl-laʼ ba, ateʼ usölë́ʼ nedaʼ lu náʼagaca nupa tuʼdíʼi nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Iaʼlátiʼsö laʼ gútiaʼ, ateʼ yöjbagaʼ nedaʼ le usuniti nedaʼ, le ben ga gúdxidaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Iaʼlátiʼsö laʼ yöjtsuʼa lataj chul-la que yöl-laʼ guti, tuʼ laʼ gútitiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Lu le guca quiaʼ bulidzaʼ-nëʼ Xanruʼ. Bulidzaʼ-nëʼ Dios quiaʼ para gácalenëʼ nedaʼ. Ga naʼ zoëʼ lataj láʼayi queëʼ biyönnëʼ chiʼa. Buzë́ naguëʼ le gunabi yúdxidaʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Níʼirö gudödi budóʼ zxuʼ, en guzxizi luyú. Guzxízidaʼ xilíbigaca yuguʼ guíʼa sibi. Guzxízigaca tuʼ gulénëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Birúaj dzön zxínëʼë, ateʼ birúaj guíʼ ruʼë le buzegui le dë idú gásibiʼilëʼ, ateʼ buguelaʼ guíʼ yuguʼ boʼ yalaj. ");
INSERT INTO zarNT_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Benëʼ ga bötaj lúzxiba, en bö́tajëʼ Lë cazëʼ, ateʼ guzóa zxan niʼë le naca chul-la. ");
INSERT INTO zarNT_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Gudödëʼ lu böʼös dxíëʼ tu le nayë́pisë nazíʼi le querubín. Carelö gudödëʼ tu lu böʼ budunuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Busubagaʼ cuinëʼ le naca chúl-lasö. Lë naʼ naca böaj gasaj le richë́ʼlëʼe nisa. ");
INSERT INTO zarNT_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Lu le rëpi yösa queëʼ lu böaj gasaj naʼ bilaʼrúaj boʼ yalaj, en guiö́j böguiʼ yöla sunna. ");
INSERT INTO zarNT_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Gunnë́ guziúʼ que chiʼë Xanruʼ lúzxiba xitsáʼ. Biyö́n chiʼë Dios nayë́pisëtërëʼ, lu dzön, en yuguʼ lu boʼ yalaj, en lu guiö́j böguiʼ yöla sunna. ");
INSERT INTO zarNT_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Gusö́l-lëʼë yuguʼ yaga lahui tuchiʼ queëʼ, en bësilásiëʼ nupa naʼ tuʼdíʼi nedaʼ. Gusö́l-lëʼë yuguʼ yösa queëʼ yuguʼ le buluʼcul-la léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Níʼirö biláʼ lahui le zoa zxan nísadoʼ, ateʼ biláʼ lahui xilibi yödzölió, cateʼ buzenuʼ bach nupa bitiʼ taʼléʼe Liʼ dxiʼa, Xan, en lu yöl-laʼ rilé quiuʼ bulidza ziʼu léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Bötjëʼ zacaʼ xitsáʼalö, en gudélëʼë nedaʼ. Bubéajëʼ nedaʼ lu nisa zili. ");
INSERT INTO zarNT_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Busölë́ʼ nedaʼ lu naʼ nu bitiʼ riléʼe nedaʼ dxiʼa, en nál-latërö, encaʼ lu náʼagaca nupa tuʼdíʼi nedaʼ, en nál-lágacatërö ca nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Cateʼ niʼ chizóa inítiaʼ gulaʼzóa réguʼë nedaʼ, pero Xanruʼ gúcalenëʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Bubéajëʼ nedaʼ, en buzóëʼ nedaʼ tu lu lataj zxön. Busölë́ʼ nedaʼ tuʼ guyaza ládxëʼë nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Bubiʼë Xanruʼ quiaʼ tsca le tsahuiʼ nacaʼ, en benëʼ quiaʼ le naca dxiʼa tuʼ cabí nabágaʼa xiguiaʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","tuʼ runaʼ ca naca le rusë́dinëʼ Xanruʼ nedaʼ, en bitiʼ caʼ ridáʼbagaʼa Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Runaʼ ca taʼnná xibá nunëʼ Xanruʼ, en bitiʼ ridáʼbagaʼa le rinná bëʼ naguixjëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Bitiʼ bi le naca döʼ nabágaʼa lahuëʼ Lëʼ, ateʼ ben chiʼa le inníaʼ para cabí guʼa döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Que lë ni naʼ bubiʼë Xanruʼ quiaʼ tsca le tsahuiʼ nacaʼ, en tuʼ cabí nabágaʼa xiguiaʼ lahuëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Ruhuéchiʼ ládxuʼu nupa tuʼhuechiʼ ladxiʼ luzë́ʼeguequi, en nacuʼ idú dxiʼa len nupa nácagaca idú dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Ruluíʼi cuinuʼ idú ladxiʼ len nupa nácagaca idú ladxiʼ, pero ridáʼbaguʼu nupa taʼdáʼbagaʼ xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Rusölóʼ nupa taʼguíʼi taʼzacaʼ, pero ruzötjuʼ nupa tun ba rahui. ");
INSERT INTO zarNT_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Ruquélaʼ cazuʼ guíʼ quiaʼ, Xanaʼ Dios, en rigúʼu quiaʼ beníʼ cateʼ ridáʼ ga chul-la. ");
INSERT INTO zarNT_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Lu yöl-laʼ huáca queëʼ Dios rucul-laʼ bönniʼ guizxi yu röjáquiëʼ gudil-la. Tuʼ zóalenëʼ Dios quiaʼ nedaʼ, rixítiʼa ribixaʼ lu zöʼö run chiʼi léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Idú dxiʼa nácagaca le runëʼ Dios. Nurúaj tsahuiʼ xtídzëʼë. Rapa chiʼë yúguʼtë nupa taʼnábini Lëʼ gácalenëʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","¡Tuzëʼ Xanruʼ náquiëʼ Dios! ¡Tuzëʼ Dios rapa chiʼë rëʼu! ");
INSERT INTO zarNT_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Dios ni ruzalëʼ nedaʼ, en runëʼ ga nacaʼ idú ládxaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Runëʼ ga nácagaca niʼa ca níʼagacabaʼ bidxinaʼ guixiʼ, en ruzóëʼ nedaʼ yuguʼ lu guíʼa zxön. ");
INSERT INTO zarNT_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Rusédinëʼ nedaʼ para gaca tsejaʼ gudil-la, en para gaca ugunaʼ dxin uxitiʼ yaga néquini guíë bronce. ");
INSERT INTO zarNT_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Lu yöl-laʼ rusölá quiuʼ run chiʼu nedaʼ. Len noʼo nál-la rizönuʼ nedaʼ, en lu yöl-laʼ dxiʼi ladxiʼ quiuʼ nunuʼ ga nayë́pisëtëraʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Ruchiʼu nöza ga ral-laʼ tödaʼ, en runuʼ ga bitiʼ cuilaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Guzóa réguʼa nupa tuʼdíʼi nedaʼ, en bucul-laʼ léguequi. Bitiʼ buécjaʼ ga bidxintë busunítiaʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Gudinaʼ léguequi luyú, ateʼ bitiʼ guca uluʼhuöása. Gulaʼdzö́ʼö zxan niʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Benuʼ nedaʼ nál-la para tsejaʼ gudil-la, en benuʼ ga bucul-laʼ nupa gulaʼdáʼbagaʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Benuʼ ga buluʼzxunnaj lahuaʼ nupa bitiʼ taʼléʼe nedaʼ dxiʼa, ateʼ busunítiaʼ nupa naʼ buluʼdíʼi nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Buluʼlidza nu gácalen léguequi, pero cuntu nu zoa usölá léguequi. Buluʼlidza caʼ Xanruʼ, pero bitiʼ bubiʼë didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Buzxuzxjaʼ léguequi ca bëchtö yu nachë́ʼ lu böʼös. Bulibaʼ léguequi ca rulibaʼ gunaʼ laʼ nöza. ");
INSERT INTO zarNT_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Busölóʼ nedaʼ lu náʼagaca nupa taʼdáʼbagaʼ, en nunuʼ ga rinná béʼedaʼ bönachi zián yödzö. Tun ca rnna xtídzaʼa bönachi bitiʼ núnbëʼa zíʼalö. ");
INSERT INTO zarNT_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Cateʼ taʼyöni nedaʼ, laʼ tun ca rnna xtídzaʼa. Tadxi nedaʼ bönachi zián yuguʼ yödzö izáʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Taʼcuidiʼ ladxiʼ, en lu yöl-laʼ rizxizi quéguequi taʼrúaj yuguʼ lu yödzö tsutsu quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","¡Zoëʼ nabanëʼ Xanruʼ! ¡Yöl-laʼ ba Nu naʼ run chiʼi nedaʼ! ¡Guliʼgún zxön Dios Nu rusölá nedaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Náquiëʼ Dios Nu rizíʼ la nupa tuʼdíʼi nedaʼ, en runëʼ ga tadxi bönachi guizxi yu nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Rusölë́ʼ nedaʼ lu náʼagaca nupa bitiʼ taʼléʼe nedaʼ dxiʼa. Le nácatë runëʼ ga rucul-laʼ nupa taʼdáʼbagaʼ nedaʼ, en rusölë́ʼ nedaʼ lu naʼ bönniʼ ridzáʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Que lë ni naʼ guíaʼ Liʼ: Xclenuʼ Xan, lógaca bönachi zián yödzö, en gul-laʼ yöl-laʼ ba que Loʼ Laʼayi. ");
INSERT INTO zarNT_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Rusölá cazëʼ Xanruʼ bönniʼ rinná bëʼë uláz queëʼ, en nadxíʼiticaʼsëʼ nu naʼ nabö́ cazëʼ, nu naʼ naca David, en yuguʼ zxíʼini xiʼsóëʼ ga idxinrö dza udxi. ");
INSERT INTO zarNT_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Yuguʼ le nacuáʼ lúzxiba tuʼluíʼi lo yöl-laʼ zxön queëʼ Dios, ateʼ yuguʼ le raca lu böʼös nácagaca bëʼ le nunëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Yuguʼ dza tuʼzéajniʼi, en yuguʼ dzöʼ tuʼluíʼi lo yöl-laʼ réajniʼi. ");
INSERT INTO zarNT_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Bitiʼ zoa didzaʼ tuíʼi, en bitiʼ riyö́n tu le taʼnná. Bitiʼ riyö́n chíʼiguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Le tuʼzéajniʼi ridxín ga naguélaʼtë luyú, en le tuʼsedi ridxín idútë yödzölió. Ga naʼ nacuáʼ nuzóëʼ Dios xilataj gubidza, ");
INSERT INTO zarNT_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","le naca ca tu bönniʼ utsaga nëʼë rirúajëʼ yuʼu, en naca caʼ ca tu bönniʼ nál-la rudzéjanëʼ cateʼ zéajëʼ carelö lu huitaj. ");
INSERT INTO zarNT_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Ga naguelaʼ lúzxiba rilén gubidza, en ridödi ga ridxintë ga ribía. Bitiʼ bi zoa le cabí rutsëʼe gubidza naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Tsahuiʼ naca ca rinná bëʼë Xanruʼ, en run ga huöáca ládxiʼruʼ. Idútë li naca didzaʼ nuzóëʼ Xanruʼ, le run ga réajniʼi nu naca nöxaj ladxiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Tsahuiʼ nácagaca xibá queëʼ Xanruʼ, le tun ga rudzeja ládxiʼruʼ. Nácagaca idú dxiʼa le gunná bëʼë Xanruʼ, en taʼgúʼu beníʼ icja ládxiʼdoʼoruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Dxíʼadoʼ naca gádxiruʼ-nëʼ Xanruʼ, para sóaticaʼsiruʼ. Idú li naca ca ruchiʼa rusörö́ëʼ Xanruʼ bönachi, en idú tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Nazácaʼgacatërö didzaʼ naʼ ca oro, encaʼ ca oro ba nequi. Nácagacatërö zxixi ca bidxinaʼ buz, en ca le zxixi queë́baʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Didzaʼ naʼ tuʼzéajniʼi nedaʼ, huen dxin queëʼ. Uzíʼtërö xibé nu run ca rnna xtídzëʼë naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","¿Nuzxi caz gaca inö́z channö richixi rinigui? Busölá nedaʼ lu dul-laʼ nunaʼ le cabí gúquibeʼedaʼ benaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Ben chiʼi nedaʼ para cabí udödi cuinaʼ lu dul-laʼ, para cabí inná beʼe nedaʼ lë naʼ naca dul-laʼ. Níʼirö ugáʼanaʼ tsahuiʼ, en bitiʼ ibágaʼa xiguiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Ben ga ilaca didzaʼ ruáʼa, en le rizáʼ ládxaʼa ca raza ládxuʼu Liʼ. Nacuʼ Xanaʼ ruzúʼ nedaʼ tsutsu, en ruhuöáʼauʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Rinábidaʼ-nëʼ Xanruʼ uzë́ naguëʼ liʼ cateʼ idxín dza quiʼi sacuʼu. Dios queëʼ Jacob gácalenëʼ liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Rinábidaʼ-nëʼ isö́l-lëʼë le gácalen liʼ le irúaj lataj láʼayi queëʼ. Lë naʼ irúaj Sión gun ga gacuʼ tsutsu. ");
INSERT INTO zarNT_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Rinábidaʼ-nëʼ tsöjnenëʼ yúguʼtë le gulúʼu queëʼ, en siʼ lu nëʼë le buzéguiʼu lahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Rinábidaʼ-nëʼ gunnëʼ quiuʼ tsca naca le rizë́ ládxuʼu, en gunëʼ ga gácatë yúguʼtë le rizáʼ ládxuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Udzéjatuʼ cateʼ usölë́ʼ liʼ, en uchísatuʼ le gaca bëʼ rulidztuʼ-nëʼ Dios queë́ruʼ. Rinábidaʼ-nëʼ Xanruʼ gunnëʼ quiuʼ yúguʼtë le rinábinuʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Naʼa nözdaʼ rusölë́ʼ Xanruʼ nu nabö́ cazëʼ. Riyönnëʼ nu naʼ nabö́ëʼ ga niʼ zoëʼ yehuaʼ yubá laʼayi queëʼ. Isö́l-lëʼë yöl-laʼ huáca idú queëʼ le usölá nu naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Nacuáʼ nupa tuʼzxöni ladxiʼ yuguʼ carreta que gudil-la, ateʼ nacuáʼ bönachi yúbölö tuʼzxöni ladxiʼ yuguʼ böaʼ, pero rëʼu ruzxöni ládxiʼruʼ Lëʼ Xanruʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Taʼcuídiʼnëʼ nupa naʼ, en taʼdzöʼë, pero rëʼu ni zuíruʼ, en zóaruʼ tsutsu. ");
INSERT INTO zarNT_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Busölá netuʼ, Xan, tuʼ nacuʼ Nu rinná beʼe netuʼ. Rinábituʼ Liʼ uzë́ naguʼ netuʼ cateʼ ulídzatuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Rudzéjanëʼ bönniʼ rinná bëʼë tuʼ zóalen lëʼ yöl-laʼ huáca quiuʼ Liʼ, Xan. Tuʼ busölóʼ lëʼ, yénniʼtërö rudzéjanëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Bunödzjuʼ queëʼ le rizë́ ládxëʼë. Bitiʼ gudáʼbaguʼu le gunábinëʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Tuʼ raza ládxuʼu lëʼ ruzúʼ queëʼ yuguʼ le naca dxiʼa. Nudxíuʼ icjëʼ tu le néquini oro idú. ");
INSERT INTO zarNT_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Gunábinëʼ Liʼ guʼu queëʼ yöl-laʼ naʼbán, ateʼ bëʼu le queëʼ. Nunuʼ ga sóaticaʼsëʼ ibanëʼ yuguʼ dza siʼ zaca. ");
INSERT INTO zarNT_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Zxöntë naca yöl-laʼ zxön queëʼ tuʼ nusölóʼ lëʼ. Nunuʼ lëʼ bal, en nunuʼ ga nayë́pisëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Zóaticaʼsö le naca dxiʼa nuzúʼ queëʼ. Runuʼ ga rudzéjadeʼenëʼ tuʼ zóalenuʼ lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Caní raca queëʼ bönniʼ naʼ rinná bëʼë tuʼ ruzxöni ládxëʼë Xanruʼ. Bitiʼ bi utsáʼ lëʼ tuʼ ruhuéchiʼ ládxëʼë Dios nayë́pisëtërëʼ lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Huadeliʼ noʼo ga nacuáʼ yúguʼtë nupa taʼdáʼbagaʼ Liʼ. Huadeliʼ noʼo ibëla ga nacuáʼ nupa tuʼdíʼi Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Cateʼ idxín dza usiúdxuʼ léguequi gaca quéguequi ca tu guíʼ ruzegui blaʼdoʼ. Usunítiuʼ léguequi, Xan, lu yöl-laʼ rilé quiuʼ, ateʼ tséguiguequi tu lu guíʼ zxön. ");
INSERT INTO zarNT_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Ucuítuʼ yuguʼ zxíʼini xiʼsóagaca nupa naʼ luyú ni, en ubéajuʼ yuguʼ zxíʼiniguequi ládjagaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Caní gunuʼ tuʼ gulë́ʼëniguequinëʼ iluʼë döʼ quiuʼ. Gulún xtídzaʼgaquiëʼ bi ilunëʼ, pero bitiʼ gaca ilunëʼ ca rnna xtídzaʼgaquiëʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","tuʼ gunuʼ Liʼ ga uluʼzxúnnajëʼ. Ichisuʼ uxitiʼ yaga quiuʼ, en gunuʼ léguequi huëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Len yöl-laʼ huáca quiuʼ, Xan, uxicjuʼ lu gudil-la. Gúl-latuʼ, en cúʼutuʼ yöl-laʼ ba que yöl-laʼ huáca quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Dios quiaʼ, Dios quiaʼ, ¿bizx que nusán noʼo nedaʼ? ¿Bizx que bitiʼ riyönnuʼ le rinnëdaʼ ládxaʼa, en bitiʼ rácalenuʼ nedaʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Dios quiaʼ, idú dza rulidzaʼ Liʼ, pero bitiʼ bi didzaʼ rubiʼu. Idú yëla rulidzaʼ, en bitiʼ caʼ rasiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Láʼayi nacuʼ Liʼ. Zuʼ ga riyö́n yöl-laʼ ba taʼgúʼu bönachi Israel Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Buluʼzxöni ládxëʼë xuz xtóʼotuʼ Liʼ. Buluʼzxöni ládxëʼë Liʼ, ateʼ busölóʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Buluʼlidzëʼ Liʼ, ateʼ gúcalenuʼ légaquiëʼ. Buluʼzxöni ládxëʼë Liʼ, en bitiʼ buluʼtuíʼinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Nacaʼ nedaʼ ca tubaʼ bëla gunaʼ, en calëga bönniʼ. Tuʼdíʼi bönachi nedaʼ, en tuʼcáʼana nedaʼ cáʼasö. ");
INSERT INTO zarNT_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Yúguʼtë nupa taʼléʼe nedaʼ tuʼtitaj nedaʼ. Taʼsalaj ruíʼiguequi lu yöl-laʼ rutitaj, en tuʼtá ícjaguequi, taʼnná: ");
INSERT INTO zarNT_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","“Lëʼ buzxöni ládxëʼë Xanruʼ para usölë́ʼ lëʼ. Xanruʼ usölë́ʼ lëʼ channö tsaza ládxëʼë lëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Nacuʼ Liʼ Nu guléaj nedaʼ lë́ʼënu xináʼa. Benuʼ ga ruzxöni ládxaʼa Liʼ cateʼ niʼ gúdxaʼa luchúʼunu xináʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Nagáʼanaʼ lu noʼo Liʼ ga gudélaʼtë guljaʼ. Ga gudélaʼtë buzóanu xináʼa nedaʼ nacuʼ Dios quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Bitiʼ suʼ ziʼtuʼ ga ni zoaʼ, tuʼ zoa gagu le gun nedaʼ ziʼ, ateʼ cúnturö nu zoa nu gácalen nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Gulaʼguʼë nedaʼ lë́ʼajlö ca tunbaʼ yuguʼ bëdxi. Ca yuguʼ bëdxi que yödzö Basán gulaʼbía diʼë nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Taʼsalaj ruáʼagaquiëʼ lahuaʼ nedaʼ ca runbaʼ bëdxi guixiʼ, ridunbaʼ, en ribö́dxiʼabaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Nuhuöácaʼ ca nisa nalalaj luyú, ateʼ nazángaca bëch dxita quiaʼ. Nuhuöáca ládxiʼdaʼahuaʼ ca bidxinaʼ buz la lu lëʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Nacuidiʼ yöl-laʼ huáca quiaʼ ca tu röʼö naláʼa, ateʼ daʼ lúdxaʼa chichjaʼ. Nuzúʼ nedaʼ lu bëchtö yu que yöl-laʼ guti. ");
INSERT INTO zarNT_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Taʼguʼë nedaʼ lë́ʼajlö ca tunbaʼ yuguʼ böʼcuʼ. Nagúʼugaquiëʼ nedaʼ lë́ʼajlö bönniʼ tuʼë döʼ. Nuzóagaquiëʼ yeru blaga naʼa, en niʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Naláʼgaca yúguʼtë dxita néquinidaʼ. Taʼnë́ʼë nedaʼ, en tuʼyú yénniëʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Taʼguísiëʼ zxaʼ que queë́gaquiëʼ, en tuʼyúëʼ le gaca bëʼ lahui lariʼ rixóa cúdzaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Bitiʼ gáʼanuʼ ziʼtuʼ, Xan. Gúcalentë nedaʼ, Liʼ, Nu naca yöl-laʼ huáca quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Busölá nedaʼ lu guíë tuchiʼ. Busölá yöl-laʼ naʼbán quiaʼ lu ruáʼagacabaʼ böʼcuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Busölá nedaʼ lu ruáʼagacabaʼ bëdxi guixiʼ, en lu lúzugacabaʼ bëdxi gúʼuna. Liʼ riyö́n quézinuʼ chiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Usiyöndaʼ yuguʼ böchiʼ luzáʼa ca naca Loʼ. Gatsaj láhuiʼlö ga naʼ tuʼdubi bönachi loʼ cuʼa Liʼ yöl-laʼ ba. ");
INSERT INTO zarNT_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","¡Guliʼcuʼë Xanruʼ yöl-laʼ ba, libíʼiliʼ naʼ rádxiliʼ-nëʼ! ¡Guliʼgun zxön Lëʼ, yúguʼtëliʼ zxíʼini xiʼsóëʼ Jacob! ¡Guliʼgadxi Lëʼ, yúguʼtëliʼ zxíʼini xiʼsóëʼ Israel! ");
INSERT INTO zarNT_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Caní ral-laʼ gunliʼ tuʼ cabí bucáʼanëʼ cáʼasö, en bitiʼ budíʼinëʼ nupa gulaʼguíʼi gulaʼzacaʼ, en bitiʼ bucachiʼ lahuëʼ para cabí iléʼenëʼ léguequi, pero cateʼ buluʼlidza Lëʼ, biyönnëʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Cuʼa Liʼ yöl-laʼ ba ga tuʼdubi bönachi guizxi yu loʼ. Lógaca nupa tadxi Liʼ usudxinaʼ le guzxíʼ lu naʼa gunaʼ quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Ilágugaca nupa nácagaca nöxaj ladxiʼ, en uluʼhuölaj uluʼdzëʼe. Nupa taʼguilaj Xanruʼ, en taʼgúʼu Lëʼ yöl-laʼ ba uluʼzíʼticaʼsö xibë́ʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Bönachi idútë yödzölió tsöjnégaca Xanruʼ, en uluʼhuöáca queëʼ. Bönachi yúguʼtë yödzö luyú ilaʼgúʼu Lëʼ yöl-laʼ ba. ");
INSERT INTO zarNT_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Caní gaca tuʼ dë lu nëʼë Xanruʼ inná bëʼë. Inná béʼenëʼ yúguʼtë bönachi luyú. ");
INSERT INTO zarNT_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Yúguʼtë nupa dë lu náʼagaca luyú ni ilágugaca, en ilaʼgúʼu Lëʼ yöl-laʼ ba. Yúguʼtë nupa ilaʼniti uluʼzechu zxíbigaca lahuëʼ Lëʼ, nupa naʼ bitiʼ caʼ gaca ilún chiʼi yöl-laʼ naʼbán quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Zxíʼini xiʼsóaliʼ ilún xichinëʼ. Ilaʼguixjöʼ lë ni ca naca queëʼ Xanruʼ para ilaʼyöni nupa tsöjsétëgaca luyú ni. ");
INSERT INTO zarNT_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Ilidëʼ, en uluʼluíʼinëʼ lahui náquiëʼ Xanruʼ tsahuiʼ. Uluʼsiyönnëʼ caʼ nupa ral-laʼ ilalaj ca naca yuguʼ le benëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Ruyú cazëʼ Xanruʼ Dios nedaʼ ca tu nu ruyú böʼcuʼ zxilaʼ. Bitiʼ bi riyádzjadaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Runëʼ ga ruzíʼ ládxaʼa ca túngacabaʼ böʼcuʼ zxilaʼ tuʼzíʼ ládxiʼbaʼ gapa dëdaʼ le ilágubaʼ. Ga naca raʼ nisa rizáʼ tsahuiʼ ládxiʼdoʼ richë́ʼë nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Runëʼ ga ruhuöáca ládxaʼa. Richë́ʼë nedaʼ ga naca nöza tsahuiʼ tuʼ nadxíʼinëʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Sal-laʼ ridáʼ ga zoa bönadxi gátiaʼ, bitiʼ bi gádxidaʼ tuʼ zóalen cazuʼ nedaʼ, Dios. Len xiyaga quiuʼ, en noʼo rutipuʼ ládxaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Ga nacuáʼ nupa taʼzóa reguʼ nedaʼ, niʼ rucúʼu quiaʼ le gahuaʼ. Rigúʼu icjaʼ le za riláʼ zxixi, en ruliruʼ le guíʼjadaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Le nácatë dusóalengaca nedaʼ le naca dxiʼa, en yöl-laʼ dxiʼi ladxiʼ queëʼ yúguʼtë dza soaʼ ibanaʼ, ateʼ lu yuʼu lidxëʼ Xanruʼ sóaticaʼsaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Nequi queëʼ Xanruʼ Dios luyú ni, en yúguʼtë le dë lahui. Nequi queëʼ yödzölió, en yúguʼtë nupa nacuáʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Naguixjëʼ le lahui nísadoʼ röʼö zxánilö, en nuzóëʼ xilibi luyú ga rëʼ zxan nísadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","¿Nuzxi caz bönniʼ dë lu nëʼë cuenëʼ guíʼa láʼayi queëʼ Xanruʼ? ¿Nuzxi caz gaca tsaza lu lataj láʼayi queëʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Huáca bönniʼ naʼ naca dxiʼa ca runëʼ, en ca rizáʼ ládxëʼë, bönniʼ naʼ bitiʼ runëʼ bal budóʼ guiö́j budóʼ yaga, en bitiʼ rizíʼ yëʼë cateʼ rizíʼ lu nëʼë bi gunëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Gunëʼ Xanruʼ ga gaca dxiʼa queëʼ bönniʼ naʼ. Caní gunnë́ʼ Dios, Nu rusölá lëʼ, en náquiëʼ tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Caní nácagaca nupa taʼdxín lahuëʼ Dios, nupa naʼ taʼbigaʼ lahuëʼ Dios quégaca zxíʼini xiʼsóëʼ Jacob. ");
INSERT INTO zarNT_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Guliʼsalaj ga nu riyaza yödzö laʼayi. Guliʼsalaj ga nu riyaza xilatjëʼ Dios le nuzóëʼ tsaz, ateʼ tsáziëʼ Bönniʼ unná bëʼ nayë́pisëtërëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","¿Nuzxi caz Bönniʼ unná bëʼ nayë́pisëtërëʼ naʼ? Náquiëʼ Xanruʼ nál-latërëʼ, en nápatërëʼ yöl-laʼ huáca, Lëʼ, Xanruʼ, Nu rideliʼ lu gudil-la. ");
INSERT INTO zarNT_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Guliʼsalaj ga nu riyaza yödzö laʼayi. Guliʼsalaj ga nu riyaza xilatjëʼ Dios le nuzóëʼ tsaz, ateʼ tsáziëʼ Bönniʼ unná bëʼ nayë́pisëtërëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","¿Nuzxi caz Bönniʼ unná bëʼ nayë́pisëtërëʼ naʼ? Náquiëʼ Xanruʼ Dios quéguequi niʼa nëʼë guizxi yu. Lëʼ náquiëʼ Bönniʼ unná bëʼ nayë́pisëtërëʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Idú ládxaʼa rulidzaʼ Liʼ, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Ruzxöni ládxaʼa Liʼ, Dios quiaʼ. Ben ga cabí utuíʼidaʼ, en cabí uluʼdzeja nupa bitiʼ taʼléʼe nedaʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Bitiʼ ilaʼbö́ʼ böniga nupa tun löza Liʼ, pero uluʼtuíʼi nupa taʼdáʼbagaʼ xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Buluíʼi nedaʼ le rë́ʼënuʼ gunaʼ, Xan, en buzéajniʼi nedaʼ le raza ládxuʼu Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Busedi nedaʼ para gunaʼ ca naca le naca idútë li quiuʼ. Tuʼ nacuʼ Dios, Nu rusölá nedaʼ gúnticaʼsaʼ löza Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Yöjné ca naca yöl-laʼ dxiʼi ladxiʼ quiuʼ, Xan, en yöl-laʼ ruhuéchiʼ ladxiʼ quiuʼ, yuguʼ le nacuáʼticaʼsö. ");
INSERT INTO zarNT_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Buniti lo nedaʼ ca naca dul-laʼ benaʼ, en le gudáʼbagaʼa Liʼ cateʼ niʼ zoaʼ iz cuidiʼ quiaʼ. Lu yöl-laʼ ruhuéchiʼ ladxiʼ quiuʼ, en yöl-laʼ dxiʼi ladxiʼ quiuʼ yöjné nedaʼ, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Náquiëʼ Xanruʼ dxiʼa tsahuiʼ, en li ladxiʼ. Que lë ni naʼ ruluíʼinëʼ nupa tun dul-laʼ le ral-laʼ ilún. ");
INSERT INTO zarNT_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Ca naca le naca tsahuiʼ richë́ʼë Dios nupa nácagaca nöxaj ladxiʼ, en ruluíʼinëʼ nupa nácagaca doʼ ladxiʼ le rë́ʼënëʼ ilún. ");
INSERT INTO zarNT_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Lu yöl-laʼ ruhuéchiʼ ladxiʼ queëʼ, en yöl-laʼ rusudxín didzaʼ queëʼ, richë́ʼë Xanruʼ nupa tun ca rinná bëʼ xibá naguixjëʼ, en ca naca didzaʼ rucáʼana tsahuiʼ nunëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Tuʼ nacuʼ dxiʼi ladxiʼ, Xan, buniti lo nedaʼ ca naca dul-laʼ nunaʼ, le naca dul-laʼ zxön. ");
INSERT INTO zarNT_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Nupa tun bal Xanruʼ uluíʼi quézinëʼ léguequi le naca dxiʼa le ral-laʼ ilún. ");
INSERT INTO zarNT_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Uluʼzíʼ xibé le naca dxiʼa gunnëʼ quéguequi, ateʼ guequi quégacabiʼ zxíʼini xiʼsóaguequi luyú ni. ");
INSERT INTO zarNT_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Xanruʼ zóalenticaʼsëʼ nupa tun ca rnna xtídzëʼë, en ruzéajniʼinëʼ léguequi ca naca didzaʼ rucáʼana tsahuiʼ nunëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Ruyúticaʼsaʼ guídëʼ Xanruʼ gácalenëʼ nedaʼ, tuʼ usölë́ʼ nedaʼ lu naʼ nu rë́ʼëni sön nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Buécja quiaʼ, Xan, en buéchiʼ ladxiʼ nedaʼ, tuʼ zoaʼ tuzaʼ, en nacuídiʼdaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Nayán le tuʼquíʼi tuʼsacaʼ nedaʼ. Busölá nedaʼ lu le ruúbi ruguíʼi ládxiʼdaʼahuaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Buyú ca riguíʼi rizácaʼa, en rudú ládxaʼa. Buniti lo nedaʼ ca naca yuguʼ dul-laʼ nabágaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Buyú ca nayán nupa tun nedaʼ ziʼ. Buyú ca tuʼdíʼi nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Ben chiʼi nedaʼ, en busölá nedaʼ. Bitiʼ guʼu lataj utuíʼidaʼ tuʼ ruzxöni ládxaʼa Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Ben ga ilún chiʼi nedaʼ le naca idú ladxiʼ, en le naca li ladxiʼ, tuʼ runaʼ löza Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Buáʼauʼ bönachi Israel, Dios lu yuguʼ le raca quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Guléaj nedaʼ tsahuiʼ, Xan, tuʼ runaʼ le naca dxiʼa, en idú ládxaʼa ruzxöni ládxaʼa Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Buyú lu icja ládxiʼdaʼahuaʼ, Xan, en guzxíʼ bëʼ nedaʼ. Buyú le rizáʼ ládxaʼa, en le ribequi icjaʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","tuʼ richë́ʼ yöl-laʼ dxiʼi ladxiʼ quiuʼ nedaʼ, ateʼ runaʼ ca naca le naca idútë li quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Bitiʼ runaʼ tsözxö́n nupa taʼzíʼ yëʼ, en bitiʼ ridálenaʼ nupa tuʼluíʼisö cuínguequi tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Bitiʼ raza ládxaʼa udúbilenaʼ nupa tuáʼ döʼ, en bitiʼ gunaʼ tuz didzaʼ len nupa nácagaca xihuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Richisa naʼa loʼ Liʼ, Dios, cabí dxía döʼ naʼa, en idú ládxaʼa ribígaʼa lo bucugu quiuʼ, Xan, ");
INSERT INTO zarNT_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","para gul-laʼ le guíaʼ Liʼ: “Xclenuʼ” en usiyöndaʼ bönachi ca nácagaca le zxön nunuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Nadxíʼidaʼ yuʼu lidxuʼ ga naʼ zuʼ, Xan, encaʼ lataj ga naʼ yuʼu beníʼ láʼayi quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Bitiʼ usunítiuʼ nedaʼ tsözxö́n len nupa tun dul-laʼ, en bitiʼ gútiuʼ nedaʼ len nupa tuti bönachi, ");
INSERT INTO zarNT_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","nupa naʼ taʼyaza ladxiʼ tuáʼ döʼ, en nacuáʼticaʼsö ilaʼguizxaj dumí para uluʼrúaj tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Gúnticaʼsaʼ nedaʼ le naca dxiʼa. Buzáʼ ladxiʼ quiaʼ, en buáʼuö nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Nuzóëʼ Dios nedaʼ ga zoaʼ tsutsu ladja bönachi guizxi yu nudúbigaca queëʼ para cuʼa-nëʼ yöl-laʼ ba Xanruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Náquiëʼ Xanruʼ Dios beníʼ quiaʼ, en Nu rusölá nedaʼ. ¿Nuzxi caz ral-laʼ gádxidaʼ? Rapa chiʼë Xanruʼ Dios caz yöl-laʼ naʼbán quiaʼ. ¿Nuzxi caz gaca gun ga gadxi idzö́bidaʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Cateʼ gulaʼdáʼbagaʼ nedaʼ nupa tuáʼ döʼ para iluti nedaʼ, nupa naʼ bitiʼ taʼléʼe nedaʼ dxiʼa, en tuʼdíʼi nedaʼ, yöjchéguʼgaca, en yöjbíxigaca. ");
INSERT INTO zarNT_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Sal-laʼ ilaʼdáʼbagaʼ nedaʼ bönachi guizxi yu, bitiʼ caʼ tsaza yöl-laʼ radxi ládxiʼdaʼahuaʼ. Sal-laʼ ilaʼdíl-lalen bönachi nedaʼ, nacaʼ nedaʼ tsutsu ladxiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Tu le rinabaʼ lahuëʼ Xanruʼ Dios, lë naʼ güíʼi ládxiʼsaʼ, le naca para sóaticaʼsaʼ lidxëʼ Xanruʼ yúguʼtë dza soaʼ ibanaʼ, para gaca uyúaʼ yöl-laʼ lachi queëʼ Xanruʼ Dios, en para saʼ ládxaʼa ca naca queëʼ lu yuʼu láʼayi queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Cateʼ idxín dza soa bönadxi quiaʼ, ucáchëʼë Lëʼ nedaʼ lu yuʼu lidxëʼ. Ga nagachiʼ lu yuʼu lidxëʼ ucáchëʼë nedaʼ. Uzóëʼ nedaʼ tsutsu ca tu lu guiö́jtoʼo. ");
INSERT INTO zarNT_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Gunëʼ ga ucul-laʼ nupa tuʼdíʼi nedaʼ, ateʼ lu yöl-laʼ rudzeja quiaʼ cö́dxiʼaticaʼsaʼ cateʼ bi unödzjaʼ queëʼ lu yuʼu lidxëʼ. ¡Gul-laʼ queëʼ! ¡Ön, gul-laʼ queëʼ Xanruʼ yöl-laʼ ba! ");
INSERT INTO zarNT_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Buzë́ naguʼ, Xan, cateʼ ulidzaʼ Liʼ. Buzáʼ ladxiʼ quiaʼ, en bubíʼi didzaʼ ca naca le inábidaʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Cateʼ Liʼ gudxuʼ nedaʼ: “Buguilaj nedaʼ”, idú ládxaʼa bubiʼa didzaʼ, gunníaʼ: Uguiljaʼ Liʼ, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Bitiʼ ucachiʼ loʼ lahuaʼ nedaʼ. Bitiʼ taʼbaguʼu nedaʼ lu yöl-laʼ rilé quiuʼ. Liʼ nacuʼ Nu rácalen nedaʼ. Bitiʼ ucáʼanuʼ nedaʼ, en bitiʼ usán noʼo nedaʼ. Nacuʼ Dios, Nu rusölá nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Huáca uluʼsán ládxëʼë xuz xináʼa nedaʼ, pero uzíʼ cazëʼ Xanruʼ Dios nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Busedi nedaʼ para gunaʼ ca rë́ʼënuʼ Liʼ, Xan. Buluíʼi nedaʼ para gunaʼ le naca tsahuiʼ, tuʼ nacuáʼ nupa taʼdáʼbagaʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Bitiʼ usanuʼ nedaʼ lu náʼagaca nupa bitiʼ taʼléʼe nedaʼ dxiʼa para cabí ilún quiaʼ le të́ʼëni. Taʼdáʼbagaʼ nedaʼ nupa taʼzíʼ yëʼ, en nupa të́ʼëni iluáʼ döʼ quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Guzxíʼ lu nëʼë Xanruʼ Dios gunëʼ ga iléʼedaʼ le naca dxiʼa, en le naca tsahuiʼ queëʼ ga nacuáʼ nupa nabángaca. Laʼtuʼ cabí réajlëʼa lë ni, chibö́aj ládxaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","¡Guliʼgún lözëʼ Xanruʼ! ¡Guliʼgaca tsutsu, en buliʼtipa ládxiʼliʼ! ¡Ön, guliʼgún lözëʼ Xanruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Rulidzaʼ Liʼ, Xan. Nacuʼ Guiö́j le ruzóa nedaʼ tsutsu. Ruzë́ naguʼ chiʼa, tuʼ channö usayjuʼ ruʼu, gacaʼ ca tu bönniʼ raziëʼ lataj chul-la. ");
INSERT INTO zarNT_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Ruzë́ naguʼ le rulidzaʼ Liʼ cateʼ rinábidaʼ Liʼ gácalenuʼ nedaʼ, cateʼ richisaʼ naʼa zacaʼ Lataj Láʼayi ga naʼ zuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Bitiʼ ichëʼu nedaʼ tsözxö́n len nupa tuáʼ döʼ, en tsözxö́n len nupa nácagaca xihuiʼ, nupa naʼ tuíʼi didzaʼ dxiʼa lahuiʼ lógaca dzaga yuʼu quéguequi, pero yuʼu ládxiʼdoʼguequi le cabí naca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Bubíʼi quéguequi tsca naca le tun, en tsca naca döʼ ruíʼigaca. Bubíʼi quéguequi tsca naca le tun në́ʼeguequi. Bubíʼi quéguequi tsca ral-laʼ gaca quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Caní gaca quéguequi tuʼ cabí tun bal le nunëʼ Xanruʼ, en bitiʼ tun bal le nun nëʼë. Uquínnajëʼ léguequi, en bitiʼ caʼ uchisëʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","¡Yöl-laʼ ba Xanruʼ, tuʼ riyönnëʼ cateʼ rinábidaʼ Lëʼ gácalenëʼ nedaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Xanruʼ caz náquiëʼ yöl-laʼ huáca quiaʼ, en le run chiʼi nedaʼ. Ruzxöni ládxaʼa Lëʼ, ateʼ rácalenëʼ nedaʼ. Que lë ni naʼ ruzíʼ xibë́ʼ ládxiʼdaʼahuaʼ, ateʼ gul-laʼ le guíaʼ Lëʼ: “Xclenuʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Naca cazëʼ Xanruʼ yöl-laʼ huáca quéguequi bönachi queëʼ, en náquiëʼ caʼ Nu run chiʼi Bönniʼ naʼ bubéajëʼ quez queëʼ para inná bëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Busölá bönachi quiuʼ, Dios, en ben ga gaca dxiʼa quéguequi nupa néquiguequi quiuʼ. Ben chiʼi léguequi ca run tu nu ruyú böʼcuʼ zxilaʼ, en guchë́ʼticaʼsö léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","¡Guliʼcuʼë yöl-laʼ ba Xanruʼ, libíʼiliʼ, nácaliʼ zxíʼinigaquiëʼ bönniʼ nayë́pisëgaquiëʼ! ¡Guliʼcuʼë yöl-laʼ ba Xanruʼ, en guliʼguíëʼ: “Napuʼ yöl-laʼ huáca idú”! ");
INSERT INTO zarNT_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","¡Guliʼcuʼë yöl-laʼ ba Xanruʼ le ral-laʼ gataʼ que Lëʼ tuʼ náquiëʼ láʼayi! ¡Guliʼgún bal Xanruʼ, tuʼ naca lachi le naca láʼayi queëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Riyö́n chiʼë Xanruʼ lu nísadoʼ. Riyö́n chiʼë Xanruʼ nayë́pisëʼ ca riyö́n guziúʼ rinnë́. Riyö́n chiʼë Xanruʼ lu nísadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Nál-latërö naca chiʼë Xanruʼ. Nayë́pisëtërö chiʼë Xanruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Chiʼë Xanruʼ riláʼa yuguʼ yaga zxön. Ön, chiʼë Xanruʼ riguitsaj yuguʼ yaga lu guíʼa Líbano. ");
INSERT INTO zarNT_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Runëʼ Xanruʼ ga taʼxitiʼ guíʼa ca tunbaʼ bë́dxidoʼ. Taʼxitiʼ guíʼa Líbano, en guíʼa Sirión ca tunbaʼ bëdx guíʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Chiʼë Xanruʼ run ga rëpi yösa. ");
INSERT INTO zarNT_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Ruxizi chiʼë Xanruʼ laʼ guixiʼ ga dë lataj. Ruxizi chiʼë Xanruʼ laʼ guixiʼ nazíʼi le Cades. ");
INSERT INTO zarNT_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Chiʼë Xanruʼ run ga taʼbéquibaʼ bidxinaʼ guixiʼ böaʼ huë́ʼënidoʼ quégacabaʼ, en run ga taʼguínnaj yúguʼtë lagaʼ dxíagaca yuguʼ yaga. Lu yudoʼ queëʼ tuíʼi didzaʼ yúguʼtë le nacuáʼ, taʼnná: “¡Yöl-laʼ ba Lëʼ!” ");
INSERT INTO zarNT_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Guröʼë gunná bëʼë Xanruʼ cateʼ gurö́ʼö nisa lu idútë yödzölió. Ön, röʼë rinná bë́ʼticaʼsëʼ Xanruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Rutipëʼ Xanruʼ ládxiʼdoʼgaca bönachi queëʼ. Gunëʼ Xanruʼ ga gaca dxiʼa quégaca bönachi queëʼ, en gunëʼ ga ilaʼböza dxiʼa tsáhuiʼdoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Gunaʼ Liʼ zxön, Xan, tuʼ buchisuʼ Liʼ nedaʼ, en bitiʼ bëʼu lataj bi ilún quiaʼ nupa bitiʼ taʼléʼe nedaʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Riguʼa Liʼ yöl-laʼ ba, Xanaʼ Dios, tuʼ bulidzaʼ Liʼ gácalenuʼ nedaʼ, ateʼ bunuʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Bubéajuʼ yöl-laʼ naʼbán quiaʼ lu yeru ba, Xan. Runuʼ ga zoaʼ nabanaʼ, para cabí tsuʼa lataj chul-la ga dzöʼö nupa nátigaca. ");
INSERT INTO zarNT_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","¡Guliʼgul-la yöl-laʼ ba queëʼ Xanruʼ, libíʼiliʼ néquiliʼ quez queëʼ! ¡Guliʼguíëʼ: “Xclenuʼ” ca naca Lëʼ le naca láʼayi! ");
INSERT INTO zarNT_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Tu chíʼisö rilenëʼ, pero ruzáʼ ládxiʼticaʼsëʼ queë́ruʼ. Channö cö́dxiruʼ tu yëla, lu yöl-laʼ rudzeja queë́ruʼ cö́dxiʼaruʼ itö́ yu. ");
INSERT INTO zarNT_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Cateʼ guca dxiʼa quiaʼ, níʼirö gunníaʼ: “Gatga bi utsáʼ nedaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Tuʼ buzáʼ ládxuʼu quiaʼ, Xan, buzúʼ nedaʼ ga zoaʼ tsutsu, en cateʼ bucachiʼ loʼ, guröʼa böniga. ");
INSERT INTO zarNT_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Bulidzaʼ Liʼ, Xan, en gútaʼyuaʼ loʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","¿Bizxi xibé uziʼtsoʼ channö gátiaʼ, en tsöjtsáziaʼ lataj chul-la ga dzöʼö nupa nátigaca? ¿Naruʼ huácatsö cuʼa Liʼ yöl-laʼ ba channö huöácaʼ bëchtö yu? ¿Naruʼ huácatsö uluʼa lo le naca idú quiuʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Ruzë́ naguʼ, Xan, en ruzáʼ ládxuʼu quiaʼ. Gúcalen nedaʼ, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Buíʼinidaʼ, ateʼ benuʼ ga buyáʼa lu yöl-laʼ rudzeja quiaʼ. Bugúʼ lariʼ cáʼasö gúcuaʼ, en bugacuʼ nedaʼ le ruziʼa xibé. ");
INSERT INTO zarNT_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Bil-la böʼ naca cazaʼ yöl-laʼ ba quiuʼ, en bitiʼ soa dxisö. Guíëticaʼsaʼ Liʼ: “Xclenuʼ”, Xanaʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Ruzxöni ládxaʼa Liʼ, Xan. Bitiʼ guʼu lataj utuíʼidaʼ. Tuʼ nacuʼ tsahuiʼ, busölá nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Ruzë́ naguʼ quiaʼ, en rusölóʼ nedaʼ. Gacuʼ ca tu guiö́jtoʼo ga soaʼ tsutsu, en ca tu ga soaʼ dxiʼa tsáhuiʼdoʼ lu gudil-la. ");
INSERT INTO zarNT_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Nacuʼ Liʼ guiö́jtoʼo ga zoaʼ tsutsu, en le run chiʼi nedaʼ. Para gaca yöl-laʼ ba que Loʼ guchë́ʼ nedaʼ, en buluíʼi nedaʼ le dxiʼa gunaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Ubéajuʼ nedaʼ lu du yalaj nucáchiʼgaquiëʼ bönniʼ tuʼë döʼ, tuʼ nacuʼ Liʼ yöl-laʼ nál-la quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Riguʼa lu noʼo böʼ naca cazaʼ. Böáʼauʼ nedaʼ, Xan, Dios idú. ");
INSERT INTO zarNT_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Bitiʼ riléʼedaʼ dxiʼa nupa tun zxön budóʼ guiö́j budóʼ yaga, pero nedaʼ ruzxöni ládxaʼa Liʼ, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Udzéjadaʼ, en uziʼa xibé yöl-laʼ dxiʼi ladxiʼ quiuʼ, tuʼ biléʼe quézinuʼ le gudíʼi guzxácaʼa. Nöz quézinuʼ yuguʼ le raca quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Bitiʼ bucáʼanuʼ nedaʼ lu naʼ nu bitiʼ riléʼe nedaʼ dxiʼa, pero nuzúʼ nedaʼ tu lataj ga zoaʼ tsutsu. ");
INSERT INTO zarNT_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Buzáʼ ladxiʼ quiaʼ, Xan, tuʼ zoa tu le raca quiaʼ. Lu yöl-laʼ ruhuíʼini quiaʼ ribödxaʼ, en rudú ládxaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Riyechiʼ dza quiaʼ tuʼ ruhuíʼinideʼedaʼ, en tuʼ rinnë́ ládxaʼa, en riyechiʼ iz quiaʼ. Rudú ládxaʼa tuʼ nözi döʼ nuʼa, ateʼ nadxita idútë le nacaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Tuʼ nözi le gulún nupa taʼdáʼbagaʼ nedaʼ nacaʼ tu le run gadxi yuguʼ dzaga yuʼu quiaʼ, ateʼ nupa núnbëʼgaca nedaʼ tadxi nedaʼ. Nupa taʼléʼe nedaʼ laʼ nöza taʼzxunnaj ga rizáʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Nál-la ládxiʼgaca nedaʼ ca nál-la ládxiʼgaca nupa chinátigaca. Nacaʼ ca tu röʼö nayuzxaj naguinnaj. ");
INSERT INTO zarNT_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Biyöndaʼ didzaʼ ziʼ taʼnnë́ bönachi zián quiaʼ bagáchiʼsö. Gátiʼtës zoa le run gadxi nedaʼ. Tun xtídzaʼgaca bi ilún quiaʼ. Taʼzáʼ ládxiʼgaca nacxi iluti nedaʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","pero nedaʼ ruzxöni ládxaʼa Liʼ, Xan. Rnníaʼ nacuʼ Dios quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Yúʼugaca lu noʼo yúguʼtë dza soaʼ ibanaʼ. Busölá nedaʼ lu náʼagaca nupa bitiʼ taʼléʼe nedaʼ dxiʼa, en lu náʼagaca nupa taʼzóa reguʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Lu yöl-laʼ ruzáʼ ladxiʼ quiuʼ buyú nedaʼ, huen dxin quiuʼ. Lu yöl-laʼ dxiʼi ladxiʼ quiuʼ busölá nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Bitiʼ guʼu lataj utuíʼidaʼ, Xan, tuʼ rulidzaʼ Liʼ. Ben ga uluʼtuíʼi nupa tuáʼ döʼ. Ben ga ilaʼcuáʼ dxisö lu yeru ba. ");
INSERT INTO zarNT_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Ben ga bitiʼ gaca bi inná nu rizíʼ yëʼ, nu naʼ rinnë́ ziʼ queëʼ bönniʼ tsahuiʼ, en run ba zxön cuini, en rulidza ditaj luzë́ʼe. ");
INSERT INTO zarNT_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","¡Bicaʼ zxön yöl-laʼ dxiʼi ladxiʼ quiuʼ, lë naʼ napuʼ para gácalenuʼ nupa tadxi Liʼ! Runuʼ caní quégaca nupa tuʼzxöni ladxiʼ Liʼ lógaca nupa tun ba zxön cuíniguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Rucáchuʼu légaquiëʼ ga naʼ zuʼ bagáchiʼsö, ga bitiʼ gaca idxín nu bönniʼ xihuiʼ. Run chiʼu légaquiëʼ bagáchiʼsö ga bitiʼ gaca idxín didzaʼ bizxaj. ");
INSERT INTO zarNT_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","¡Yöl-laʼ ba Xanruʼ Dios, tuʼ buluíʼinëʼ nedaʼ ca nadxíʼinëʼ nedaʼ cateʼ niʼ zoaʼ tu yödzö ga nagúʼugaquiëʼ lë́ʼajlö bönniʼ tuʼtíl-lalenëʼ nedaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Lu yöl-laʼ radxi ridzöbi quiaʼ gunníaʼ: “Ilútiëʼ nedaʼ loʼ Liʼ, Xan”, pero biyönnuʼ le gunábidaʼ Liʼ, cateʼ niʼ bulidzaʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","¡Guliʼdxíʼi-nëʼ Xanruʼ, libíʼiliʼ néquiliʼ queëʼ! Rapa chiʼë Xanruʼ nupa taʼyéajlëʼ Lëʼ, en rubiʼë ca saʼyéaj queëʼ bönniʼ run ba zxön cuinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","¡Guliʼgaca tsutsu, en buliʼtipa ládxiʼliʼ, yúguʼtëliʼ naʼ runliʼ löza Xanruʼ Dios! ");
INSERT INTO zarNT_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","¡Bicaʼ ba bönniʼ naʼ Dios buniti lahuëʼ lëʼ ca naca döʼ biʼë, en bugǘëʼ dul-laʼ queëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","¡Bicaʼ ba bönniʼ naʼ Dios rnnëʼ bitiʼ nabáguëʼë xiguiaʼ, en bitiʼ zóalen lëʼ yöl-laʼ rizíʼ yëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Cateʼ guzóaʼ dxisö ca naca dul-laʼ quiaʼ, budú ládxaʼa tuʼ gunnë́ticaʼsö ládxaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Rëla, en te dza buquíʼi busácuʼu nedaʼ, Dios. Budú ládxaʼa ca raca cateʼ röʼ bö́chila. ");
INSERT INTO zarNT_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Níʼirö guxóalëpaʼ dul-laʼ nabágaʼa loʼ Liʼ, en bitiʼ bucáchaʼa le xihuiʼ benaʼ. Gunníaʼ: “Ixóalëpaʼ döʼ biʼa lahuëʼ Xanaʼ”, ateʼ buniti loʼ nedaʼ ca naca xiguiaʼ gubágaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Que lë ni naʼ, nútiʼtës nu nunbëʼ Liʼ, Dios, ral-laʼ ulidza Liʼ cateʼ dë lataj güíʼilen Liʼ didzaʼ. Cateʼ röʼ nisa bach luyú ni, bitiʼ caʼ ideliʼ idxín ga zoa nu naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Liʼ nacuʼ ga gaca ucachiʼ cuinaʼ cateʼ zoa bönadxi quiaʼ. Liʼ caz gun chiʼu nedaʼ para cabí bi gaca quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Liʼ gunuʼ ga gúl-laticaʼsaʼ quiuʼ Liʼ tuʼ rusölóʼ nedaʼ. Rnnëʼ Dios: “Nedaʼ uzéajniʼidaʼ liʼ, en uluíʼidaʼ liʼ le ral-laʼ gunuʼ. Usédidaʼ liʼ, en uyúticaʼsaʼ liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Bitiʼ gacuʼ ca tu böaʼ o tu mula cabí taʼyéajniʼibaʼ. Ral-laʼ cuʼu guíë en du rúʼugacabaʼ para inná béʼenuʼ légacabaʼ.” Channö cabí gunuʼ caní, bitiʼ caʼ ilunbaʼ ca rë́ʼënuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Zián le tun ga tuʼhuíʼiniguequi nupa tuáʼ döʼ, pero bönniʼ ruzxöni ládxëʼë Xanruʼ iléʼenëʼ yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Buliʼdzéjalenëʼ Xanruʼ, en buliʼsíʼ xibë́ʼ, libíʼiliʼ nácaliʼ tsahuiʼ lahuëʼ Lëʼ. Lu yöl-laʼ rudzeja queë́liʼ guliʼcö́dxiʼa, libíʼiliʼ nácaliʼ idú dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Lu yöl-laʼ rudzeja queë́liʼ guliʼgul-la lahuëʼ Xanruʼ, libíʼiliʼ nácaliʼ tsahuiʼ lahuëʼ Lëʼ. Nupa nácagaca tsahuiʼ ral-laʼ ilaʼgúʼu Lëʼ yöl-laʼ ba. ");
INSERT INTO zarNT_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Guliʼguíëʼ Lëʼ: “Xclenuʼ”, quínniliʼ lëʼe bihuél-la. Guliʼgul-la yöl-laʼ ba queëʼ, quínniliʼ le zë chi du que. ");
INSERT INTO zarNT_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Guliʼgul-la queëʼ tu le rul-la cubi. Guliʼquinnaj dxíʼadoʼ, en lu yöl-laʼ rudzeja queë́liʼ guliʼcö́dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Xtídzëʼë Xanruʼ naca idú tsahuiʼ, ateʼ idú ládxëʼë runëʼ yúguʼtë bi runëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Nadxíʼinëʼ le naca dxiʼa, en le naca tsahuiʼ. Naláʼ lahui yöl-laʼ dxiʼi ladxiʼ queëʼ Xanruʼ idútë yödzölió. ");
INSERT INTO zarNT_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Len didzaʼ bë́ʼësëʼ Xanruʼ, benëʼ lúzxiba, en benëʼ yúguʼtë bölaj beníʼ len böʼ rirúaj ruʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Rutubëʼ nisa röʼö nísadoʼ para gaca ca tu guíʼa. Napa chiʼë nisa röʼö zili ga naʼ nupë́ʼë xilataj. ");
INSERT INTO zarNT_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Yúguʼtë bönachi ral-laʼ ilaʼdxíʼi Xanruʼ. Bönachi idútë yödzölió ral-laʼ ilaʼcuáʼ nöxaj lahuëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Bë́ʼësëʼ didzaʼ Xanruʼ, ateʼ laʼ gúcatë ca naʼ gunnë́ʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Gunná bëʼë, ateʼ guca tsutsu le nunëʼ. Runëʼ Xanruʼ ga tuʼhuöáca cáʼasö didzaʼ túngaca bönachi yuguʼ yödzö. Runëʼ ga bitiʼ ilaca le të́ʼëni ilúngaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Sóaticaʼsö tsutsu didzaʼ nunëʼ Xanruʼ. Le rizáʼ ládxëʼë uluʼgáʼanaticaʼsö quéguequi zxíʼini xiʼsóaruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Bicaʼ bágaca bönachi yödzö naʼ náquiëʼ Xanruʼ cazëʼ Dios quéguequi, bönachi naʼ nabö́ cazëʼ Dios para ilaca quez queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Zoa cazëʼ Xanruʼ yehuaʼ yubá, ruyúëʼ ga zóaruʼ. Riléʼenëʼ le tun yúguʼtë bönachi nacuáʼ idútë yödzölió. ");
INSERT INTO zarNT_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Ga naʼ zoa cazëʼ ruyúëʼ idú gásibiʼilö, en riléʼenëʼ yúguʼtë nupa nacuáʼ idútë yödzölió ni. ");
INSERT INTO zarNT_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Nun cazëʼ Lëʼ ládxiʼdoʼgaca yúguʼtëguequi. Réajniʼi quézinëʼ ca naca yúguʼtë le túngaca. ");
INSERT INTO zarNT_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Bitiʼ caʼ ulë́ʼ bönniʼ unná bëʼ nacuáʼ queëʼ bönniʼ guizxi yu röjáquiëʼ gudil-la. Bitiʼ ulë́ʼ bönniʼ zoëʼ gudil-la tuʼ nál-latërëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Bitiʼ nazacaʼ gunruʼ löza böaʼ para idéliʼruʼ lu gudil-la, tuʼ cabí gaca usölabaʼ nu bönniʼ tuʼ nál-latëröbaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Buliʼyú, ruyúticaʼsëʼ Xanruʼ nupa tadxi Lëʼ, nupa naʼ tun löza yöl-laʼ dxiʼi ladxiʼ queëʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","para usölë́ʼ léguequi lu yöl-laʼ guti, en para ugahuëʼ léguequi cateʼ tsuʼu gubín. ");
INSERT INTO zarNT_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Idú ládxiʼruʼ runruʼ löza Lëʼ Xanruʼ. Rácalen cazëʼ rëʼu, en rapa chiʼë rëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Rudzeja ládxiʼlenruʼ Lëʼ, en uzxöni ládxiʼruʼ Lëʼ, tuʼ náquiëʼ láʼayi. ");
INSERT INTO zarNT_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Lu yöl-laʼ dxiʼi ladxiʼ quiuʼ gúcalen netuʼ, Xan, tuʼ runtuʼ löza Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","¡Innë́ticaʼsaʼ queëʼ Xanruʼ náquiëʼ dxiʼa! ¡Cúʼuticaʼsaʼ Lëʼ yöl-laʼ ba! ");
INSERT INTO zarNT_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Böʼ naca cazaʼ gun zxön Xanruʼ. Nupa nácagaca nöxaj ladxiʼ ilaʼyöni lë ni, en uluʼdzeja. ");
INSERT INTO zarNT_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Guliʼgüíʼ zxönëʼ Xanruʼ tsözxö́n len nedaʼ, en tsözxö́n usiyönruʼ bönachi ca naca Lëʼ Laʼayi. ");
INSERT INTO zarNT_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Bulidzaʼ-nëʼ Xanruʼ, ateʼ bubiʼë didzaʼ quiaʼ, en busölë́ʼ nedaʼ lu yuguʼ le gúdxidaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Nupa nácagaca queëʼ bilaʼdxín lahuëʼ, en buluʼzíʼ xibë́ʼ. Bítiʼrö caz uluʼtuíʼi nupa naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Bulidzaʼ-nëʼ Xanruʼ, ateʼ biyönnëʼ quiaʼ nedaʼ, bönniʼ yechiʼ, en busölë́ʼ nedaʼ lu yúguʼtë le guca quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Gubáz láʼayi que yaʼabá queëʼ Xanruʼ tapa chiʼë nupa tadxi Lëʼ, en tuʼsölë́ʼ léguequi lu yúguʼtë le raca quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Guliʼsíʼ bëʼë, ateʼ inö́ziliʼ náquiëʼ Xanruʼ dxiʼa. ¡Bicaʼ ba bönniʼ ruzxöni ládxëʼë Lëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Guliʼgadxi Xanruʼ, libíʼiliʼ nácaliʼ quez queëʼ, tuʼ cabí bi ilaʼyadzaj nupa tadxi Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Taʼyadzaj taʼyúdxibaʼ bëdxi guixiʼ, en taʼdunbaʼ, pero nupa tuʼlidza Xanruʼ bitiʼ caʼ taʼyadzaj le naca dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Guliʼdá libíʼiliʼ, bíʼidoʼ, en buliʼzë́ nágaliʼ xtídzaʼa. Uzéajniʼidaʼ libíʼiliʼ para gádxiliʼ-nëʼ Xanruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","¿Nuzxi caz bönniʼ rë́ʼënëʼ soëʼ ibanëʼ, en rë́ʼënëʼ soëʼ iz zián para uziʼë xibé le naca dxiʼa? ");
INSERT INTO zarNT_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Ben chiʼi lúdxuʼu para cabí guʼu didzaʼ xihuiʼ, en para cabí siʼ yéʼenuʼ luzóʼo. ");
INSERT INTO zarNT_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Bucáʼana le cabí naca tsahuiʼ, en ben le naca dxiʼa. Bëʼ ladxiʼ cözuʼ dxiʼa tsáhuiʼdoʼ, en ben bayudxi gunuʼ yuguʼ lë ni. ");
INSERT INTO zarNT_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Ruyúticaʼsëʼ Xanruʼ nupa nácagaca tsahuiʼ, en riyö́n quézinëʼ cateʼ tuʼlidza Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Uzáguëʼë Xanruʼ xinö́zgaca nupa tuáʼ döʼ, en gunëʼ ga cuntu nu tsöjné léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Nupa nácagaca tsahuiʼ tuʼlidza Xanruʼ, ateʼ riyönnëʼ quéguequi, en rusölë́ʼ léguequi lu yuguʼ le raca quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Xanruʼ zóalen cazëʼ nupa tuʼhuíʼini ladxiʼ, en rusölë́ʼ nupa nácagaca nöxaj ladxiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Zián le riguíʼi rizáquëʼë bönniʼ tsahuiʼ, pero Xanruʼ rusölë́ʼ lëʼ lu yúguʼtë lë naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Xanruʼ rapa chiʼë yúguʼtë dxita yuʼë, ateʼ bitiʼ gatsaj nitú dxita queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Le xihuiʼ run nu ruáʼ döʼ gun ga gati nu naʼ, ateʼ ilaʼbagaʼ xiguiaʼ nupa bitiʼ taʼléʼe dxiʼa le naca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Xanruʼ caz ruhuöáʼuëʼ böʼ nácagaca caz huen dxin queëʼ, ateʼ bitiʼ irugu que nitú nupa naʼ tuʼzxöni ladxiʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Xanaʼ Dios, gudáʼbagaʼ nupa bitiʼ taʼléʼe nedaʼ dxiʼa. Butíl-lalen nupa taʼdíl-lalen nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Guzxö́n le gun chiʼi nedaʼ lu gudil-la, en gudá gácalenuʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Guzxö́n yaga tuchiʼ quiuʼ para uzaguʼu xinö́zguequi nupa taʼzóa reguʼ nedaʼ. Gudxi böʼ naca cazaʼ nacuʼ Liʼ Nu rusölá nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Ben ga uluʼtuíʼi, en uluʼgáʼana cáʼasö nupa të́ʼëni iluti nedaʼ. Ben ga uluʼhuécaj, en uluʼgáʼana cáʼasö nupa të́ʼëni iluíʼi döʼ quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Ben ga ilaca ca bëbu zxe café zeaj lu böʼös, en ben ga ulaguëʼ gubáz láʼayi que yaʼabá quiuʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Ben ga gaca chul-la nöza yúʼugaca, en ga cuílagaca, ateʼ soa réguʼë gubáz láʼayi quiuʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Buluʼcáchiʼ du yalaj le sön nedaʼ, en bitiʼ bi nunaʼ quéguequi. Gulaʼchö́ʼöna yeru ga tsöjbixaʼ, en bitiʼ bi nunaʼ quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Ben ga idxín quéguequi tsálidoʼos le usuniti léguequi, en ben ga du yalaj naʼ buluʼcáchiʼ sön laʼ cuínguequi quez. Ben ga ilaʼbixi lu yeru naʼ gulaʼchö́ʼöna. ");
INSERT INTO zarNT_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Udzeja ládxiʼlenaʼ-nëʼ Xanruʼ, en uziʼa xibé yöl-laʼ rusölá queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Ilaʼnná dxita néquinidaʼ: “Xan, ¿nuzxi caz naca ca nacuʼ Liʼ? Rusölóʼ nu riguíʼi rizácaʼ lu naʼ nu nál-latërö ca le. Rusölóʼ nu riguíʼi rizácaʼ, en riyadzaj riyudxi lu naʼ bönniʼ ribanëʼ le nequi que.” ");
INSERT INTO zarNT_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Taʼdáʼbaguëʼë bönniʼ xihuiʼ nedaʼ, en taʼnnë́ʼ quiaʼ. Taʼnabi yúdxinëʼ nedaʼ ca naca yuguʼ le cabí nözdaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Tuʼbiʼë quiaʼ le naca döʼ cateʼ runaʼ le naca dxiʼa, ateʼ ruhuíʼinideʼe ládxaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Pero nedaʼ gúcuaʼ lariʼ cáʼasö cateʼ guláquiëʼ huëʼ. Benaʼ gubasa, en busacaʼ ziʼ böʼ naca cazaʼ, en uláz quéguequi bulidzaʼ-nëʼ Dios zián luzuí. ");
INSERT INTO zarNT_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Buíʼinideʼedaʼ tsca guca luzáʼa o biʼi böchiʼ cazaʼ nu naʼ guca huëʼ. Gurödxi yechaʼa ca huíʼinideʼedaʼ channö gátinu xináʼ cazaʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","pero cateʼ guchixi guníguidaʼ nedaʼ, buluʼdzéjadeʼe, en buluʼdubi tsözxö́n. Yuguʼ bönniʼ naʼ buluʼcáʼanëʼ nedaʼ cáʼasö buluʼdubëʼ para ilunëʼ ga cöʼa baguíʼi. Yuguʼ bönniʼ naʼ bitiʼ núnbëʼa gulúnnaticaʼsëʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Buluʼsacaʼ ziʼë nedaʼ, en buluʼtitjëʼ quiaʼ. Lu yöl-laʼ rilé quégaquiëʼ nedaʼ gulagu zxea láyiʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Xan, ¿gácaʼxte caz uyú ináʼasuʼ le tunëʼ? Busölá nedaʼ lu döʼ tuʼë quiaʼ. Busölá nedaʼ lu náʼagaquiëʼ bönniʼ naʼ nácagaquiëʼ ca yuguʼ bëdxi guixiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Guíaʼ Liʼ: “Xclenuʼ” lógaca bönachi zián uluʼdúbigaca quiuʼ. Cuʼa Liʼ yöl-laʼ ba ga nudúbigaca ziantë bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Bitiʼ guʼu lataj uluʼdzeja nupa taʼdáʼbagaʼ nedaʼ, en taʼzíʼ yëʼ, en bitiʼ guʼu lataj uluʼtitaj quiaʼ, nupa naʼ tuʼdíʼi nedaʼ, en bitiʼ bi nunaʼ quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Catu caz tuíʼi didzaʼ le gun ga soa dxisö didzaʼ bizxaj. Lu yöl-laʼ rizíʼ yëʼ quéguequi taʼnnë́ quégaca nupa taʼbö́ʼ dxiʼa tsáhuiʼdoʼ yödzölió ni. ");
INSERT INTO zarNT_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Buluʼsalaj ruíʼiguequi, en gulaʼnnë́ quiaʼ, gulaʼnná: “¡Ön, biléʼe quézituʼ le nunëʼ!” ");
INSERT INTO zarNT_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","¡Biléʼe quézinuʼ Liʼ lë ni, Xan! ¡Bitiʼ suʼ dxisö! ¡Bitiʼ ucáʼanuʼ nedaʼ, Xan! ");
INSERT INTO zarNT_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","¡Guyasa, Xan! ¡Busubán ládxuʼu, Xan, para uchiʼa usörö́uʼ quiaʼ! ¡Gúcalen nedaʼ, Xanaʼ Dios! ");
INSERT INTO zarNT_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","¡Tuʼ nacuʼ tsahuiʼ, buchiʼa busörö́ quiaʼ, Xanaʼ Dios! ¡Bitiʼ guʼu léguequi lataj uluʼdzeja niʼa que le raca quiaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","¡Bitiʼ guʼu léguequi lataj ilaʼnná: “Ön, bidéliʼruʼ le guzë́ ládxiʼruʼ”! ¡Bitiʼ guʼu lataj ilaʼnná: “Chibucúl-laruʼ lëʼ”! ");
INSERT INTO zarNT_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","¡Ben ga uluʼtuíʼi, en uluʼgáʼana cáʼasö nupa tuʼdzeja cateʼ ruhuíʼinidaʼ! ¡Ben ga uluʼtuíʼi, en uluʼgáʼana cáʼasö nupa taʼdáʼbagaʼ nedaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","¡Ben ga ilaʼbö́dxiʼa lu yöl-laʼ rudzeja quéguequi, en uluʼzíʼ xibé nupa tuíʼi ládxiʼgaca urúajaʼ tsahuiʼ! ¡Bëʼ lataj ilaʼnnáticaʼsö: “Nayë́pisëtërëʼ Xanruʼ Dios, tuʼ raza ládxëʼë gunëʼ ga gaca dxiʼa quégaca huen dxin queëʼ”! ");
INSERT INTO zarNT_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Níʼirö gunaʼ ba nalí quiuʼ, inníaʼ: “¡Nacuʼ tsahuiʼ!” en cuʼa Liʼ yöl-laʼ ba idú dza. ");
INSERT INTO zarNT_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Le naca xihuiʼ ruíʼilen bönniʼ nucáʼanëʼ Dios lu icja ládxiʼdaʼahuëʼ. Bitiʼ caʼ rádxinëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Tuʼ run ba zxön cuinëʼ réquinëʼ bitiʼ nö́zinëʼ Dios nabáguëʼë lëʼ dul-laʼ, en bitiʼ ichúguiëʼ Dios queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Ruʼë didzaʼ xihuiʼ, en rizíʼ yëʼë. Bitiʼ réajniʼinëʼ, en bitiʼ runëʼ le naca dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Cateʼ niʼ dëʼ lu le rátiʼnëʼ rizáʼ ládxëʼë ca naca le xihuiʼ gunëʼ. Ruíʼi ládxëʼë gunëʼ le cabí naca dxiʼa, en bitiʼ rusanëʼ runëʼ le naca xihuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Zxö́ntërö ca yehuaʼ yubá naca yöl-laʼ dxiʼi ladxiʼ quiuʼ, Xan, ateʼ gúnticaʼsuʼ ca rnna xtídzuʼu, tsca zoa yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Naca tsutsu le tsahuiʼ nacuʼ ca nácagaca tsutsu yuguʼ guíʼa zxön quiuʼ. Ca ruchiʼa rusörö́uʼ naca ca naca nísadoʼ, tuʼ cabí gaca nu gúnbëʼe le. Run chiʼi cazuʼ bönachi, en yugu böaʼ guixiʼ, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Nazácaʼtërö yöl-laʼ dxiʼi ladxiʼ quiuʼ, Dios. Run chiʼu yúguʼtë bönachi ca runbaʼ yöjede, run chíʼibaʼ yuguʼ bö́radoʼ zxan xílabaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Tuʼhuölaj tuʼdzëʼe bönachi quiuʼ le nayándaʼ lu yuʼu lidxuʼ, ateʼ ruguiʼjuʼ léguequi le naca yöl-laʼ dxiʼi ladxiʼ quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Yúguʼtë le nacuáʼ nabánigaca Liʼ. Tuʼ naca cazuʼ beníʼ riléʼetuʼ beníʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Bidxíʼiticaʼsö nupa núnbëʼgaca Liʼ, en ben le naca dxiʼa quégaca nupa nácagaca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Bitiʼ guʼu lataj bi ilún quiaʼ nupa tun ba zxön cuínguequi, en bitiʼ guʼu nupa tuáʼ döʼ lataj uluʼlagaʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Nadzö́ʼögaca nupa tuáʼ döʼ. Dë́guequi luyú, en bitiʼ caʼ gaca uluʼhuöása. ");
INSERT INTO zarNT_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Bitiʼ ubi uguíʼi ládxiʼdoʼoliʼ tuʼ tuʼzíʼgaca xibé nupa tuáʼ döʼ. Bitiʼ uzxéʼeliʼ nupa bitiʼ tun le naca dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Huadö́ditë quéguequi ca raca que guixiʼ nacuadi, en udxi quéguequi ca raca quégaca guíxiʼdoʼ narúgugaca. ");
INSERT INTO zarNT_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Buliʼzxöni ládxëʼë Xanruʼ, en guliʼgún le naca dxiʼa. Buliʼgáʼana luyú queëʼ, en guliʼcö́z dxiʼa tsáhuiʼdoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Buliʼsíʼ xibë́ʼ Xanruʼ, ateʼ gunnëʼ queë́liʼ le rizë́ ládxiʼliʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Buliʼdödi cuinliʼ lu nëʼë Xanruʼ. Buliʼzxöni ládxëʼë Lëʼ, ateʼ gunëʼ le gácalen libíʼiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Gun cazëʼ Lëʼ ga urúajliʼ tsahuiʼ, en gácaliʼ ca beníʼ, en cateʼ uchiʼa usörö́ëʼ queë́liʼ, gaca queë́liʼ ca lahuiʼ dza. ");
INSERT INTO zarNT_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Guliʼsóa dxisö lahuëʼ Xanruʼ, en guliʼcöza le gunëʼ. Bitiʼ cuéqui ícjaliʼ tuʼ nözi bönniʼ ruziʼë xibé, bönniʼ naʼ ruʼë döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Bítiʼrö leliʼ, en buliʼsán yöl-laʼ ridzáʼa. Bitiʼ ubi uguíʼi ládxiʼdoʼoliʼ tuʼ gun lë ni ga guáʼaliʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Dios caz uzáguëʼë xinö́zguequi nupa tuáʼ döʼ, pero nupa tuʼzxöni ladxiʼ Xanruʼ, guequi quéguequi luyú. ");
INSERT INTO zarNT_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Iaʼlátiʼsö xidzé, en bítiʼrö soëʼ bönniʼ naʼ ruʼë döʼ. Uguíljaliʼ xilatjëʼ, pero bítiʼrö soëʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Nupa nácagaca nöxaj ladxiʼ, guequi quéguequi luyú, ateʼ uluʼzíʼ xibé yöl-laʼ tsahuiʼ que. ");
INSERT INTO zarNT_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Tun didzaʼ nupa tuáʼ döʼ bi ilúngaca quégaca nupa nácagaca tsahuiʼ, en lu yöl-laʼ rilé quéguequi tagu zxea láyiʼguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Ruzxidxi cazëʼ Xanruʼ quéguequi, tuʼ riléʼenëʼ dza udxi quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Nupa tuáʼ döʼ chigulaʼbéaj guíë tuchiʼ quéguequi, en nuáʼgaca uxitiʼ yaga quéguequi para uluʼxicja nupa taʼzacaʼ ziʼ, en taʼyadzaj taʼyudxi, en para iluti nupa tun le naca dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Guíë tuchiʼ quéguequi ilaʼchiza laʼ ládxiʼdoʼguequisö, ateʼ ilaʼguítsaj uxitiʼ yaga quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Dxíʼatërö le doʼ dësö queëʼ bönniʼ tsahuiʼ ca le zián dë queëʼ bönniʼ ruʼë döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Huayúzxjagaca náʼagaca nupa tuáʼ döʼ, pero Xanruʼ caz rácalenëʼ nupa nácagaca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Ruíʼi ladxiʼ cazëʼ Xanruʼ nupa bitiʼ bi xiguiaʼ nabágaʼgaca, ateʼ guéquiticaʼsö xiyúgaca quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Bitiʼ caʼ uluʼtuíʼi cateʼ idxín dza bitiʼ gaca dxiʼa, en cateʼ tsuʼu gubín, gátaʼdëra le ilágugaca. ");
INSERT INTO zarNT_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Uluʼniti tsaz nupa tuáʼ döʼ, ateʼ nupa bitiʼ taʼléʼe dxiʼa Xanruʼ ilaca ca yöl-laʼ lachi que guixiʼ. Laʼ tö́ditë quéguequi, en ilaca ca dzön le rinítitë. ");
INSERT INTO zarNT_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Taʼnábini nu bi gunna quéguequi tu chíʼisö, pero bitiʼ caʼ uluʼbíʼi lë naʼ. Nu naca tsahuiʼ ruzá ladxiʼ quéguequi, en runödzaj quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Gaca luyú quégaca nupa run láʼayëʼ Xanruʼ, pero ilaʼniti tsaz nupa rudxíëʼ Lëʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Le runëʼ bönniʼ dxiʼa naca le nuluíʼinëʼ Xanruʼ lëʼ, ateʼ raza ládxëʼë Lëʼ le runëʼ bönniʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Cateʼ röjtsöʼë, bitiʼ caʼ röjtsöʼë tsaz, tuʼ röjzönëʼ Xanruʼ caz bönniʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Gucaʼ raʼbandoʼ, pero naʼa nagulaʼ, en catu caz biléʼedaʼ nusán nëʼë Dios bönniʼ tsahuiʼ, en catu caz biléʼedaʼ riyadzaj le ilágubiʼ zxíʼinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Yuguʼ dza ruzáʼ ládxëʼë bönniʼ tsahuiʼ quéguequi luzë́ʼë en runödzjëʼ le taʼnábini lëʼ unödzjëʼ tu chíʼisö, Nácagacabiʼ zxíʼini xiʼsóëʼ tu le run ga raca dxiʼa queë́ruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Buliʼcáʼana le cabí nácatë, en guliʼgún le naca dxiʼa. Channö caní gunliʼ, sóaliʼ tsaz, ");
INSERT INTO zarNT_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","tuʼ nadxíʼinëʼ Xanruʼ nu run le naca tsahuiʼ, en catu caz usán nëʼë nupa néquiguequi quez queëʼ. Gun chíʼiticaʼsëʼ léguequi, pero usunítiëʼ zxíʼini xiʼsóagaca nupa tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Guequi luyú quégaca nupa nácagaca tsahuiʼ, ateʼ ilaʼcuáʼticaʼsö luyú naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Ruʼë bönniʼ tsahuiʼ didzaʼ le napa yöl-laʼ réajniʼi, ateʼ raca yöl-laʼ ruchiʼa rusörö́ niʼa que didzaʼ naʼ ruʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Yuʼu icja ládxiʼdaʼahuëʼ le gunná bëʼë Dios. Que lë ni naʼ catu caz ichixi iníguinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Ruyudaʼ nu ruáʼ döʼ le runëʼ bönniʼ tsahuiʼ, en riguilaj nacxi gaca guti lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Xanruʼ bitiʼ guʼë nu naʼ lataj bi gun queëʼ bönniʼ tsahuiʼ naʼ, en bitiʼ guʼë lataj irugu queëʼ cateʼ nu uchiʼa usörö́ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Buliʼzxöni ládxëʼë Xanruʼ, en guliʼgún ca rë́ʼënëʼ gunliʼ, ateʼ uchisëʼ libíʼiliʼ para guequi queë́liʼ luyú. Cateʼ udxi quégaca nupa tuáʼ döʼ, hualéʼe quéziliʼ le. ");
INSERT INTO zarNT_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Biléʼedaʼ-nëʼ bönniʼ huíaʼ döʼ. Gúquiëʼ ca tu yaga zxön, en buzíʼdeʼenëʼ xibé. ");
INSERT INTO zarNT_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Níʼirö gudödi queëʼ, en bítiʼrö zoëʼ. Yöjdiljaʼ lëʼ, pero bitiʼ caʼ guca udzö́lidaʼ lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Buliʼyú ca náquiëʼ bönniʼ tsahuiʼ. Cuntu nu gaca bi innë́ queëʼ, tuʼ ilaʼcuáʼabiʼ zxíʼini xiʼsóëʼ bönniʼ zxön ladxiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Uluʼniti tsaz nupa tuʼcáʼana le gunná bëʼë Dios. Usiúdxëʼ Xanruʼ yuguʼ zxíʼini xiʼsóagaca nupa tuáʼ döʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","pero rusölá cazëʼ nupa nácagaca tsahuiʼ. Rutipëʼ ládxiʼguequi cateʼ bi raca quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Rácalenëʼ léguequi, en rusölë́ʼ léguequi. Rubéajëʼ léguequi lu náʼagaca nupa tuáʼ döʼ, en rusölë́ʼ léguequi, tuʼ tuʼzxöni ládxiʼguequi Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Bitiʼ ilenuʼ nedaʼ, Xan, en bitiʼ uzenuʼ nedaʼ bach. Bitiʼ gunuʼ nedaʼ xiguiaʼ lu yöl-laʼ rilé quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Ben ziʼu nedaʼ, en budxíuʼ nedaʼ huëʼ. Nuzötjuʼ nedaʼ len noʼo. ");
INSERT INTO zarNT_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Yuʼa yödzöhuë́ʼ zxön tuʼ rilenuʼ nedaʼ. Dxía huëʼ idútë le nacaʼ tuʼ nözi dul-laʼ nabágaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Xiguiaʼ nabágaʼa naca ca tu nísadoʼ ga ruchicjaʼ nisa. Naca ca tu yuaʼ ziʼi nabágaʼa nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Tuʼ benaʼ yuguʼ le cabí naca dxiʼa, dxíaʼ huëʼ le riláʼ siguti, en rudzuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Narecjiʼ cúdzaʼa, en nagáʼanaʼ cáʼasö. Idú dza ruhuíʼinideʼedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Idútë le nacaʼ yúʼudaʼa xilá, ateʼ nazxí xipë́laʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Rudú ládxaʼa, en ricuídiʼdaʼ. Rinnëdaʼ ládxaʼa tuʼ ruúbi ruguíʼi ládxiʼdaʼahuaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Nöz quézinuʼ Liʼ, Xan, le rizë́ ládxaʼa, en riyönnuʼ le rinnë́ticaʼsö ládxaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Richunchu ládxiʼdaʼahuaʼ, en ricuidiʼ ládxaʼa, ga ridxintë richul-la guiö́j lahuaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Bítiʼrö taʼdzaga nedaʼ yuguʼ luzáʼa, en yuguʼ bö́chaʼa, tuʼ nözi xihuëʼa, ateʼ tuʼbigaʼ diʼa dza quiaʼ ga zoaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Nupa të́ʼëni iluti nedaʼ taʼbequi le ilaʼzö́n nedaʼ, ateʼ nupa të́ʼëni uluʼcul-la nedaʼ tun xtídzaʼguequi nacxi uluʼsuniti nedaʼ. Idú dza taʼbequi ícjaguequi bi ilún quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Nacaʼ ca tu bönniʼ nacö́dzuëʼ, en bítiʼrö riyöndaʼ. Nacaʼ ca tu bönniʼ narugu lúdxëʼë, en bitiʼ risaljëʼ ruʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Nacaʼ ca tu bönniʼ bítiʼrö riyönnëʼ, en que lë ni naʼ bitiʼ bi didzaʼ rubiʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Tuzuʼ Liʼ ruzxöni ládxaʼa, Xan. Ubíʼi cazuʼ didzaʼ, Xanaʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Bitiʼ guʼu lataj uluʼdzeja niʼa que le raca quiaʼ. Bitiʼ guʼu lataj ilún ba zxön cuínguequi tuʼ nagáʼanaʼ cáʼasö. ");
INSERT INTO zarNT_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Chizóaʼ tsöjbixaʼ, en zóalenticaʼsö xihuëʼa nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Que lë ni naʼ rixóalëpaʼ xiguiaʼ nabágaʼa, en risë́bidaʼ ládxaʼa tuʼ nözi dul-laʼ nabágaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Nacuáʼ dxiʼa, en nál-lagaca nupa téqui nedaʼ ziʼ. Nayándaʼ nupa tuʼdíʼi nedaʼ, en bitiʼ bi nunaʼ quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Taʼdáʼbagaʼ nedaʼ nupa tuʼbíʼi le cabí naca dxiʼa que nu run le naca dxiʼa. Caní tun tuʼ ruíʼi ládxaʼa gunaʼ le naca dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Bitiʼ usán noʼo nedaʼ, Xan. Bitiʼ ubiguʼ ga zoaʼ, Dios quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Gudáchi gácalenuʼ nedaʼ, Xan, tuʼ naca cazuʼ Liʼ Nu rusölá nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Gunníaʼ: Gun chiʼi cuinaʼ ca naca le runaʼ, en bitiʼ gunaʼ dul-laʼ ca naca didzaʼ ruáʼa. Bitiʼ bi didzaʼ guʼa cateʼ nacuáʼ nupa tuáʼ döʼ gal-laʼ ga zoaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Guzóaʼ dxisö, en bitiʼ bëʼa didzaʼ ga bidxintë bitiʼ gunníaʼ le naca dxiʼa, pero biyaliʼ xihuëʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Bubi buguíʼi ládxiʼdaʼahuaʼ, en cateʼ guzáʼ ládxaʼa que, guyegui gulá ládxiʼdaʼahuaʼ. Que lë ni naʼ gunábidaʼ-nëʼ Xanruʼ, gunníaʼ: ");
INSERT INTO zarNT_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","Xan, ¿gácaʼxte caz soaʼ ibanaʼ? Buluíʼi nedaʼ tsca iz soaʼ ibanaʼ. Ben ga inözdaʼ channö chizóa caz gátiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Nabábasö dza nuzúʼ quiaʼ soaʼ ibanaʼ. Yuguʼ iz soaʼ ibanaʼ bitiʼ bi zeaj naca loʼ Liʼ. Le nácatë bitiʼ bi nácagaca yúguʼtë bönachi nacuáʼ luyú ni. ");
INSERT INTO zarNT_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Nácagacasö ca tu zxul-la rigúʼu böaj. Nítisö tuʼúbi tuʼguíʼi ládxiʼdoʼguequi, en tun dxin. Tuʼtubi yöl-laʼ tsahuiʼ, pero bitiʼ nö́zguequi nuzxi guequi que. ");
INSERT INTO zarNT_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","¿Bizxi caz gaca gunaʼ löza, Xan? Ruzxöni ládxaʼa Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Busölá nedaʼ lu xiguiaʼ nabágaʼa, en bitiʼ guʼu lataj uluʼtitaj quiaʼ nupa nácagaca canö́z. ");
INSERT INTO zarNT_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Soaʼ dxisö, en bitiʼ bi didzaʼ guʼa, tuʼ ben cazuʼ Liʼ ga riguíʼi rizácaʼa lë ni. ");
INSERT INTO zarNT_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Bítiʼrö gunuʼ nedaʼ xiguiaʼ. Chizóa gátiaʼ tuʼ rusacaʼ ziʼu nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Runuʼ-nëʼ xiguiaʼ bönniʼ dul-laʼ, en ruzenuʼ lëʼ bach. Ca tuʼtöbaʼ bë́ladoʼ que le yúʼubaʼ, rusunítiuʼ le ruíʼi ládxëʼë bönniʼ naʼ. Bitiʼ bi naca cazëʼ bönniʼ dul-laʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Buzë́ naguʼ le rulidzaʼ Liʼ, Xan, en le rinábidaʼ Liʼ. Bitiʼ suʼ dxisö cateʼ ribödxaʼ loʼ Liʼ, en bitiʼ gacaʼ ca tu bönniʼ ziʼtuʼ loʼ Liʼ, en ca tu bönniʼ ridasëʼ ca guláquiëʼ xuz xtóʼotuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Benna nedaʼ lataj idipa ládxaʼa zíʼalö ca uzáʼa yödzölió ni, en bítiʼrö soaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Lu yöl-laʼ riböza zxön ladxiʼ quiaʼ gulözaʼ gácalenëʼ Xanruʼ nedaʼ. Níʼirö buzë́ naguëʼ quiaʼ, en biyönnëʼ le bulidzaʼ-nëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Bubéajëʼ nedaʼ ca tu lu yeru ga rëʼ, en lu gunaʼ zili. Buzóëʼ nedaʼ tu lu guiö́jtoʼo, en guléquiëʼ nedaʼ tsutsu. ");
INSERT INTO zarNT_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Busë́dinëʼ nedaʼ tu le cubi le rul-laʼ le naca yöl-laʼ ba queëʼ Dios queëruʼ. Zián nupa ilaʼléʼeni lë ni, en ilún Lëʼ zxön, ateʼ uluʼzxöni ladxiʼ-nëʼ Xanruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Bicaʼ ba bönniʼ ruzxöni ládxëʼë Xanruʼ. Bitiʼ runëʼ tsözxö́n nu run ba zxön cuini, nu naʼ run zxön yuguʼ dios núngaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Ziántërö naca le nunuʼ queë́tuʼ, Xanaʼ Dios, yuguʼ le tun ga rubánituʼ. Ziántërö le yuʼu icja ládxiʼdoʼo ca naca le gunuʼ queë́tuʼ. Bitiʼ caʼ gaca nu ulaba loʼ Liʼ tsca nácagaca. Channö guë́ʼëndaʼ nu usiyöndaʼ tsca nácagaca, nayántërö tsca le gaca ulabaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Bitiʼ rë́ʼënuʼ gútigacaʼ-baʼ böaʼ guixiʼ loʼ, en calëga bi cuʼa loʼ. Bitiʼ rinabuʼ uzéguiʼgacaʼ-baʼ böaʼ bëdxi loʼ, en calëga tu le gunaʼ loʼ para ugúa dul-laʼ, pero gusaljuʼ nagaʼ para yöndaʼ le guíoʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Que lë ni naʼ gunníaʼ: Ni zoa cazaʼ nedaʼ quiuʼ. Lu guichi láʼayi quiuʼ nazúaj caz ca naca quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Raza ládxaʼa runaʼ ca rë́ʼënuʼ Liʼ, Dios quiaʼ. Naguʼa icja ládxiʼdaʼahuaʼ xibá naguixjuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Ga tuʼdubi bönachi guizxi yu quiuʼ, Xan, busiyöndaʼ léguequi nacuʼ tsahuiʼ. Bitiʼ caʼ guzóaʼ dxisö. Nöz quézinuʼ lë ni, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Bitiʼ bucáchiʼzaʼ icja ládxiʼdaʼahuaʼ ca ruúnuʼ tsahuiʼ bönachi. Buluʼa lahui ca runuʼ ca rnnoʼ, en ca rusölóʼ bönachi. Ga nudúbigaca bönachi quiuʼ bitiʼ guzóaʼ dxisö, pero bëʼa didzaʼ ca nacuʼ dxiʼi ladxiʼ, en ca ruʼu didzaʼ le nácatë. ");
INSERT INTO zarNT_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Bitiʼ ugúʼ quiaʼ yöl-laʼ dxiʼi ladxiʼ quiuʼ, Xan. Yöl-laʼ dxiʼi ladxiʼ quiuʼ, en ca runuʼ ca rnna xtídzuʼu ilún chíʼiticaʼsö nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Zián le raca quiaʼ nagúʼugaca nedaʼ lë́ʼajlö, le cabí gaca nu ulaba. Nabágaʼa yuguʼ döʼ biʼa, en bítiʼrö gaca iléʼedaʼ. Nayanrö ca guitsaʼ icjaʼ, ateʼ rudú ládxaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","¡Busölá nedaʼ, Xan! ¡Gudáchi gácalenuʼ nedaʼ, Xan! ");
INSERT INTO zarNT_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Ben ga uluʼtuíʼi, en ilaʼbö́ʼ baguíʼi nupa naʼ të́ʼëni uluʼsuniti nedaʼ. Ben ga uluʼhuécaj, en uluʼgáʼana cáʼasö nupa naʼ të́ʼëni gaca quiaʼ le cabí naca dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Ben ga uluʼdú ládxiʼgaca tuʼ nabíxigaca nupa naʼ tuʼtitaj nedaʼ, taʼnná: “¡Buyútsöcaʼ le raca queëʼ!” ");
INSERT INTO zarNT_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Ben ga uluʼdzeja, en uluʼzíʼ xibóʼ yúguʼtë nupa tuʼguilaj Liʼ. Ben ga ilaʼnnáticaʼsö nupa taʼdxíʼi yöl-laʼ rusölá quiuʼ, ilaʼnná: “Nayë́psëtërëʼ Xanruʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Nacuídiʼdaʼ, en bitiʼ bi gaca gunaʼ, pero ruíʼi ladxiʼ cazuʼ Liʼ nedaʼ, Xan. Naca cazuʼ Nu rácalen nedaʼ, en Nu rusölá nedaʼ. Bitiʼ tsenuʼ guíduʼ quiaʼ, Dios quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Bicaʼ ba bönniʼ ruíʼi ládxëʼë nupa nácagaca yechiʼ. Xanruʼ gácalen cazëʼ bönniʼ naʼ cateʼ bi gaca queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Xanruʼ Dios gun chiʼë lëʼ, en gunëʼ ga soëʼ ibanëʼ. Gunëʼ caʼ ga uziʼë xibé xiyú cazëʼ. Bitiʼ usán nëʼë lëʼ lu náʼagaca nupa bitiʼ taʼléʼe lëʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Xanruʼ utipëʼ ládxëʼë bönniʼ naʼ cateʼ réʼenëʼ. Uchisëʼ lëʼ lu daʼa le rátiʼnëʼ, en gunëʼ ga soëʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Gunníaʼ: Benaʼ dul-laʼ loʼ Liʼ, Xan. Buéchiʼ ladxiʼ nedaʼ, en bun nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Nupa bitiʼ taʼléʼe nedaʼ dxiʼa taʼnnë́ quiaʼ, taʼnná: “¿Bátaxi gátiëʼ, en huáca gal-la ládxiʼgaca bönachi lëʼ?” ");
INSERT INTO zarNT_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Channö uduyúgaquiëʼ nedaʼ, taʼzíʼ yëʼë. Taʼgǘëʼ didzaʼ ca naca le raca quiaʼ, en cateʼ taʼrúajëʼ, tuʼsiyönnëʼ bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Tuʼdubi nupa bitiʼ taʼléʼe nedaʼ dxiʼa, en taʼnnë́ quiaʼ. Taʼzáʼ ládxiʼgaca zián le naca döʼ le ilún quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Taʼnnë́ quiaʼ, taʼnná: “Yuʼë yödzöhuë́ʼ le guti lëʼ. Bítiʼrö caz huöásëʼ ga naʼ dëʼ lu le denëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Lëscaʼ caní benëʼ böchiʼ luzáʼa ruzxöni ládxaʼa-nëʼ. Bönniʼ gudágulenëʼ nedaʼ tsözxö́n ridáʼbaguëʼë nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Buéchiʼ ladxiʼ nedaʼ, Xan, en bun nedaʼ, ateʼ ubíʼi cazaʼ quégaca nupa naʼ bitiʼ taʼléʼe nedaʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Gácabeʼedaʼ raza ládxuʼu nedaʼ, tuʼ cabí uluʼxicja nedaʼ nupa bitiʼ taʼléʼe nedaʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Gáclen cazuʼ nedaʼ tuʼ runaʼ le naca dxiʼa. Gunuʼ ga sóaticaʼsaʼ loʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","¡Yöl-laʼ ba Xanruʼ, Dios quégaca bönachi Israel! ¡Guliʼcuʼë yöl-laʼ ba naʼa dza, en yuguʼ dza siʼ zaca! ¡Caʼ gaca! ¡Ön, caʼ gaca! ");
INSERT INTO zarNT_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Ca rizë́ ládxiʼbaʼ bidxinaʼ guixiʼ nisa yégudoʼ, lëscaʼ caní rizë́ ládxaʼa Liʼ, Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Ribidxi ládxaʼa Liʼ cazuʼ, Dios. ¿Bátaxi udxinaʼ ga dë quiaʼ, en tsuʼa le yúbölö yudoʼ láʼayi quiuʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Rëla, en te dza ribödxaʼ, en bitiʼ bi rahuaʼ. Yuguʼ dza nacuáʼ nupa taʼnábini nedaʼ, taʼnná: “¿Gazxi caz zoa Dios quiuʼ?” ");
INSERT INTO zarNT_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Risëbi ládxaʼa cateʼ röjnedaʼ ca guca zíʼalö, cateʼ guzáʼlenaʼ bönachi guizxi yu, en yöjnö́ruaʼ láhuilöguequi raʼ yuʼu queëʼ Dios. Lu yöl-laʼ rudzeja queë́tuʼ bíl-latuʼ, en guyéaj ládxiʼtuʼ-nëʼ Xanruʼ, en bentuʼ laní. ");
INSERT INTO zarNT_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","¿Bizx que risë́bidaʼ ládxaʼa, en bizx que röʼa böniga? Uzxöni ládxaʼa-nëʼ Xanruʼ Dios, tuʼ huadxín dza cuʼa-nëʼ yöl-laʼ ba le yúbölö. Náquiëʼ Nu rusölá nedaʼ, en náquiëʼ Dios quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Risë́bidaʼ ládxaʼa, Dios quiaʼ. Que lë ni naʼ tsöjnedaʼ Liʼ tsanni ni zoaʼ, ridáʼ rizxúnnajaʼ raʼ yegu Jordán, en tsanni ni ridáʼ lu guíʼa Hermón, en lu guíʼa Mizar. ");
INSERT INTO zarNT_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Ca tu guziúʼ rinnë́ lu nísadoʼ, en ca bö ruíʼi tu budoáʼ nísadoʼ queëʼ Dios, caní rinnë́ ladxiʼ böʼ naca cazaʼ lu yöl-laʼ risëbi ladxiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Rinábidaʼ-nëʼ Xanruʼ huéchiʼ ládxëʼë nedaʼ yuguʼ dza. Yuguʼ dzöʼ rul-laʼ yöl-laʼ ba queëʼ Lëʼ, en rulidzaʼ Dios, ruíʼilenaʼ-nëʼ didzaʼ, Nu naʼ runna quiaʼ yöl-laʼ naʼbán. ");
INSERT INTO zarNT_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Guíaʼ-nëʼ Dios, Nu ruzóa nedaʼ tsutsu, inníaʼ: ¿Bizx que nál-la ládxuʼu nedaʼ? ¿Bizx que run bayúdx quíʼi sácaʼticaʼsaʼ lu náʼagaca nupa bitiʼ taʼléʼe nedaʼ dxiʼa? ");
INSERT INTO zarNT_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Rutsaba yúguʼtë dxita yuʼa tuʼ tuʼdidzaʼ yudxi nedaʼ. Yuguʼ dza taʼnábini nedaʼ, taʼnná: “¿Gazxi caz zoa Dios quiuʼ?” ");
INSERT INTO zarNT_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","¿Bizx que risë́bidaʼ ládxaʼa, en bizx que röʼa böniga? Uzxöni ládxaʼa-nëʼ Xanruʼ Dios, tuʼ huadxín dza cuʼa-nëʼ yöl-laʼ ba le yúbölö, tuʼ náquiëʼ Nu rusölá nedaʼ, en náquiëʼ Dios quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Guléaj nedaʼ tsahuiʼ, Dios, en bëʼ didzaʼ uláz quiaʼ lógaca bönachi tuáʼ döʼ quiaʼ. Busölá nedaʼ lu naʼ nu rizíʼ yëʼ, en bitiʼ naca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Liʼ cazuʼ nacuʼ Dios, Nu rutipa ládxaʼa. ¿Bizx que nusán noʼo nedaʼ? ¿Bizx que ruhuíʼinidaʼ tuʼ taʼbía no nedaʼ nupa tuʼdíʼi nedaʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Gusö́l-laʼ quiaʼ beníʼ quiuʼ, en le naca idútë li quiuʼ para uluʼluíʼi nedaʼ nöza. Ben ga ilaʼchë́ʼ nedaʼ ga naca láʼayi quiuʼ, ga naʼ zoa cazuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Tsuʼa raʼ bucugu queëʼ Dios. Ibígaʼa lahuëʼ Dios, Nu run ga rudzéjadeʼedaʼ. Gúl-lalenaʼ bihuël-la, cuʼa Liʼ yöl-laʼ ba, Dios, nacuʼ Dios quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","¿Bizx que risë́bidaʼ ládxaʼa, en bizx que röʼa böniga? Uzxöni ládxaʼa-nëʼ Xanruʼ Dios, tuʼ huadxín dza cuʼa-nëʼ yöl-laʼ ba le yúbölö, tuʼ náquiëʼ Nu rusölá nedaʼ, en náquiëʼ Dios quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Biyö́n quézituʼ le, Dios. Buluʼsiyönnëʼ netuʼ xuz xtóʼotuʼ ca naca yuguʼ le zxön benuʼ dza niʼte, cateʼ niʼ gulaʼcuʼë légaquiëʼ luyú ni. ");
INSERT INTO zarNT_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Bulaga cazuʼ Liʼ bönachi yuguʼ yödzö izáʼa, en bucuásuʼ légaquiëʼ luyú ni. Busacaʼ ziʼu bönachi izáʼa naʼ, en gurúʼunuʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Bitiʼ gulaʼdéliʼnëʼ xuz xtóʼotuʼ luyú ni rácasö quégaquiëʼ, en bitiʼ buluʼsölá laʼ cuíngacasëʼ, pero ben cazuʼ Liʼ lë naʼ len yöl-laʼ huáca zxön quiuʼ, en lu yöl-laʼ zxön que le naca cazuʼ, ateʼ bulúʼu lahui ca nadxíʼinuʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Naca cazuʼ Liʼ Dios quiaʼ, en Nu rinná beʼe nedaʼ. Busölá bönachi quiuʼ, yuguʼ zxíʼini xiʼsóëʼ Jacob. ");
INSERT INTO zarNT_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Uguntuʼ dxin yöl-laʼ huáca quiuʼ, uxícjatuʼ nupa taʼdáʼbagaʼ netuʼ, ateʼ tuʼ zóalen cazuʼ netuʼ, ucúl-latuʼ nupa bitiʼ taʼléʼe netuʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Bitiʼ uzxöni ládxaʼa uxitiʼ yaga quiaʼ, en bitiʼ uzxöni ládxaʼa guíë tuchiʼ quiaʼ para ilácalen nedaʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","tuʼ rusölá cazuʼ Liʼ netuʼ lu náʼagaca nupa bitiʼ taʼléʼe netuʼ dxiʼa, en ruzötjuʼ nupa tuʼdíʼi netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Cúʼuticaʼstuʼ Liʼ yöl-laʼ ba, en guíëticaʼstuʼ Liʼ: “Xclenuʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Pero naʼa nusán noʼo netuʼ, Dios, en bëʼu lataj nu buxicja netuʼ. Bítiʼrö réajlenuʼ bönniʼ queë́tuʼ röjáquiëʼ gudil-la. ");
INSERT INTO zarNT_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Benuʼ ga buzxúnnajtuʼ lógaca nupa taʼdíl-lalen netuʼ, ateʼ gulaʼgǘëʼ yuguʼ le nequi queë́tuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Bëʼu lataj gulútiëʼ ziantuʼ ca nu rúti-gacabaʼ böʼcuʼ zxilaʼ. Bësilásiuʼ netuʼ ládjagaca yödzö izáʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Naca tsca bë́tiʼu netuʼ, en látiʼdoʼos guzxiʼu. Bitiʼ caʼ buziʼu xibé tsca guzxiʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Bönachi yuguʼ dzaga yödzö queë́tuʼ bilaʼléʼe lë naʼ benuʼ queë́tuʼ, ateʼ tuʼcáʼana netuʼ cáʼasö, en tuʼtitaj netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Benuʼ ga tuʼdidzaʼ yudxi bönachi yuguʼ yödzö netuʼ. Tuʼtá ícjaguequi lu yöl-laʼ rucáʼana netuʼ cáʼasö. ");
INSERT INTO zarNT_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Yuguʼ dza rutuíʼidaʼ ca raca queë́tuʼ, en röʼa böniga lu yöl-laʼ rutuíʼi quiaʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","tuʼ riyöndaʼ nupa tuʼdidzaʼ yudxi nedaʼ, en tuʼcáʼana nedaʼ cáʼasö, nupa naʼ bitiʼ taʼléʼe nedaʼ dxiʼa, en tuʼdíʼi nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Guca queë́tuʼ yúguʼtë lë ni sal-laʼ bitiʼ nál-la ládxiʼtuʼ Liʼ, en bitiʼ nucáʼanatuʼ didzaʼ dzaga bénlenuʼ netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Bitiʼ caʼ böaj ládxiʼtuʼ ca réajlëʼëtuʼ Liʼ, en bitiʼ gudáʼbagaʼtuʼ le buluíʼinuʼ netuʼ guntuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","pero nusán naʼ cazuʼ netuʼ ladaj nupa nácagaca ca yuguʼ böaʼ guiʼa síniaʼ, en nucáʼanuʼ netuʼ ga chizóa tseajtsázatuʼ lataj chul-la. ");
INSERT INTO zarNT_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Laʼtuʼ gul-la ládxiʼtuʼ Liʼ, Dios queë́tuʼ, o laʼtuʼ guyéaj ládxiʼtuʼ tu dios izáʼa, ");
INSERT INTO zarNT_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","laʼ gáquibeʼetënuʼ lë ni, Dios, tuʼ nöz quézinuʼ le rizáʼ ládxiʼtuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Tuʼ néquituʼ quiuʼ Liʼ zóaticaʼsö nu guti netuʼ. Nactuʼ ca yuguʼ böʼcuʼ zxílaʼdoʼ lo nu guti légacabaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","¡Bubán, Xan! ¿Bizx que rásitsoʼ Liʼ? ¡Guyasa! ¡Bitiʼ usán noʼo netuʼ chadía chacanna! ");
INSERT INTO zarNT_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","¿Bizx que nucachiʼ loʼ lotuʼ netuʼ? ¿Naruʼ nál-la ládxuʼu ca raca queë́tuʼ, en ca riguíʼi rizácaʼtuʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Naguíngaquiëʼ netuʼ luyú. Nadínituʼ lu bëchtö yu. ");
INSERT INTO zarNT_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","¡Gudáchi gácalenuʼ netuʼ, en lu yöl-laʼ dxiʼi ladxiʼ quiuʼ busölá netuʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Rizáʼ ládxaʼa tu le naca dxiʼa. Ruʼa didzaʼ que le runëʼ bönniʼ rinná bëʼë. Naca lúdxaʼa ca le ruzúajlenëʼ bönniʼ nabéʼedeʼenëʼ ruʼë didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Nácatëruʼ Liʼ lachi ca yúguʼtë bönachi. Nabéʼedeʼenuʼ ruʼu didzaʼ. Que lë ni naʼ nunëʼ Dios gaca dxiʼa quiuʼ chadía chacanna. ");
INSERT INTO zarNT_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Begaʼ lëʼu guíë tuchiʼ quiuʼ, bönniʼ nayë́pisëʼ, lu yöl-laʼ lachi quiuʼ, en lu yöl-laʼ unná bëʼ quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Lu yöl-laʼ unná bëʼ quiuʼ idéliʼnuʼ lu gudil-la, ugunuʼ dxin le naca idútë li, en yöl-laʼ nöxaj ladxiʼ, en le naca tsahuiʼ. Yöl-laʼ huáca zxön quiuʼ gun ga iláʼ lahui yuguʼ le zxö́ntërö. ");
INSERT INTO zarNT_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Natúchiʼgacadaʼ yaga lahui tuchiʼ quiuʼ. Bönachi yuguʼ yödzö ziʼtuʼ taʼdzö́ʼö loʼ, nupa naʼ taʼdíl-lalen liʼ. Yuguʼ yaga lahui tuchiʼ quiuʼ nachö́zaʼgaca ládxiʼdoʼguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","¡Chadía chacanna naguixjuʼ ga röʼu rinná bëʼu, Dios! ¡Ca naca le naca tsahuiʼ rinná béʼenuʼ bönachi quiuʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Nadxíʼinuʼ le naca tsahuiʼ, en bitiʼ riléʼenuʼ dxiʼa le bitiʼ nácatë. Que lë ni naʼ Dios quiuʼ nabö́ cazëʼ liʼ. Nachízirëʼ icja ládxiʼdoʼo yöl-laʼ rudzeja ca le nápagaca iaʼzícaʼrö bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Riláʼ zxixi lariʼ nacuʼ len ziʼ mirra, en ziʼ áloe, en ziʼ casia. Tunëʼ bönniʼ huil-la ga rudzéjanuʼ lu yuʼu lidxuʼ zxön. ");
INSERT INTO zarNT_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Yuguʼ nigula zxíʼinigaquiëʼ bönniʼ taʼnná bëʼë nútsaʼgacabiʼ biʼi nigula nacuáʼabiʼ lidxuʼ. Nigula quiuʼ rinná béʼenu zuínu cuituʼ ibëla, en nácunu le nazíʼi biquitaj oro nazacaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Bëʼ ladxiʼ nedaʼ, nigúladoʼ. Bëʼ ladxiʼ nedaʼ, en biyö́n xtídzaʼa. Gul-la ladxiʼ bönachi yödzö quiuʼ, en yuguʼ diʼa dza quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Níʼirö së ládxëʼë bönniʼ rinná bëʼë yöl-laʼ lachi quiuʼ. Buzóa zxibuʼ lahuëʼ tuʼ náquiëʼ xanuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Níʼirö bönachi yödzö Tiro ilaʼdxín loʼ nuáʼgaca le nazácaʼdaʼ le ilunna quiuʼ. Yuguʼ bönniʼ taʼléʼenëʼ yöl-laʼ tsahuiʼ ilaʼnábinëʼ liʼ bi unödzjuʼ quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Yuguʼ biʼi nigula queëʼ bönniʼ rinná bëʼë zóagacabiʼ lidxëʼ, en nácatërögacabiʼ lachi. Lariʼ nácubiʼ nadíalen du oro. ");
INSERT INTO zarNT_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Ilaʼchë́ʼë-biʼ lahuëʼ bönniʼ rinná bëʼë, nácubiʼ lariʼ nazácaʼdaʼ. Ilaʼdabiʼ yuguʼ biʼi nigula raʼbandoʼ cúdziʼlöbiʼ, ateʼ ilaʼchë́ʼë légacabiʼ lahuëʼ bönniʼ naʼ rinná bëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Lu yöl-laʼ rudzeja, en lu yöl-laʼ ruzíʼ xibé quégacabiʼ ilaʼdxinbiʼ, en ilaʼyázabiʼ yuʼu lidxëʼ bönniʼ naʼ rinná bëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Ilaʼcuáʼabiʼ biʼi bönniʼ quiuʼ uláz quégaquiëʼ xuz xtoʼo. Gunuʼ ga ilaʼnná bë́ʼëbiʼ idútë yödzölió. ");
INSERT INTO zarNT_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Gunuʼ ga tsöjnégacaticaʼsö bönachi ca nacuʼ Liʼ. Que lë ni naʼ yúguʼtë bönachi ilë́ liʼ “Xclenuʼ” yuguʼ dza siʼ zaca. ");
INSERT INTO zarNT_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","¡Náquiëʼ Dios Nu run chiʼi rëʼu, en Nu ruzóa rëʼu tsutsu! ¡Zóaticaʼsëʼ gácalenëʼ rëʼu cateʼ bi raca queë́ruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Que lë ni naʼ bitiʼ gádxiruʼ sal-laʼ izxizi idútë yödzölió, en ilaʼniti yuguʼ guíʼa lu nísadoʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","en sal-laʼ chasa idxía, en tsuʼu bö nísadoʼ naʼ, en ilaʼzxizi guíʼadoʼ tuʼ nözi le raca. ");
INSERT INTO zarNT_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Zoa tu yegu le run ga tuʼdzeja nupa nacuáʼ ladzëʼ Dios, ga naʼ röʼö yudoʼ láʼayi ga zoëʼ Dios nayë́pisëtërëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Zoa cazëʼ Dios yödzö naʼ, le catu caz initi. Cateʼ niʼ soa itö́ yu gácalenëʼ nupa nacuáʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Tadxi taʼdzöbi bönachi yuguʼ yödzö, ateʼ taʼbö́ʼ baguíʼi nupa taʼnná bëʼ, tuʼ ruʼë didzaʼ Dios, ateʼ riniti luyú ni. ");
INSERT INTO zarNT_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Xanruʼ nayë́pisëtërëʼ zóalen cazëʼ rëʼu. Dios quégaca zxíʼini xiʼsóëʼ Jacob rapa chiʼë rëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Guliʼdá iléʼeliʼ le nunëʼ Xanruʼ. Buliʼyú ca nusunítiëʼ luyú ni. ");
INSERT INTO zarNT_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Ruzóa dxíëʼ gudil-la rácagaca idútë yödzölió. Riguitsjëʼ yuguʼ uxitiʼ yaga, en rusunítiëʼ yuguʼ yaga lahui tuchiʼ que gudil-la. Ruzéguiʼë yuguʼ carreta que gudil-la tu lu guíʼ zxön. ");
INSERT INTO zarNT_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Rnnëʼ: “Guliʼsóa dxisö, ateʼ guéquibeʼeliʼ naca cazaʼ Dios. Nayë́pisëtëraʼ yuguʼ lu yödzö, en lu idútë yödzölió.” ");
INSERT INTO zarNT_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Xanruʼ nayë́pisëtërëʼ zóalen cazëʼ rëʼu. Dios quégaca zxíʼini xiʼsóëʼ Jacob rapa chiʼë rëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","¡Lu yöl-laʼ rudzeja queë́liʼ guliʼcapaʼ náʼaliʼ, bönachi yúguʼtë yödzö! ¡Guliʼcuʼë yöl-laʼ ba Dios, len yuguʼ le rúl-lalenliʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Ral-laʼ gunruʼ bal Xanruʼ Dios nayë́pisëtërëʼ. Náquiëʼ Nu rinná bëʼ idútë yödzölió. ");
INSERT INTO zarNT_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Benëʼ ga bidéliʼruʼ yuguʼ lu bönachi izáʼa. Benëʼ ga rinná beʼeruʼ yuguʼ yödzö. ");
INSERT INTO zarNT_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Gurö́ cazëʼ luyú ga ni nuzóëʼ rëʼu. Naca tu luyú lachi quégaca zxíʼini xiʼsóëʼ Jacob, nupa naʼ nadxíʼi quézinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Len yöl-laʼ ba zxön ribenëʼ Dios ga röʼë rinná bëʼë. Le zián le tuʼcödxëʼ cateʼ ribenëʼ Xanruʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","¡Guliʼgul-la yöl-laʼ ba queëʼ Dios! ¡Guliʼgul-la! ¡Guliʼgul-la yöl-laʼ ba queëʼ Bönniʼ rinná béʼenëʼ rëʼu! ¡Guliʼgul-la! ");
INSERT INTO zarNT_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","¡Rinná bëʼë Dios idútë yödzölió ni! ¡Idú ládxiʼliʼ guliʼgul-la yöl-laʼ ba queëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","¡Zoa cazëʼ Dios lataj láʼayi queëʼ ga röʼë rinná bëʼë! ¡Rinná béʼenëʼ bönachi yúguʼtë yödzö! ");
INSERT INTO zarNT_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Tuʼdubi nupa taʼnná beʼe yuguʼ yödzö tsözxö́n len bönachi queëʼ Dios queëʼ Abraham. ");
INSERT INTO zarNT_vpl VALUES ("PS47_10","020_47_10","PSA","47","10","10","¡Nequi queëʼ Dios yöl-laʼ zxön quégaca yúguʼtë yödzö nacuáʼ yödzölió! ¡Nayë́pisëtërëʼ Lëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Nayë́pisëtërëʼ Xanruʼ, ateʼ run bayudxi cúʼuruʼ-nëʼ yöl-laʼ ba idú ládxiʼruʼ ga zoa lu yödzö queëʼ Dios queë́ruʼ le zoa lu guíʼa láʼayi queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Lachi, en sibi naca guíʼa láʼayi naʼ, ateʼ raza ládxiʼgaca bönachi idútë yödzölió ca naca. Caní naca guíʼa Sión le röʼö tsöláʼalö ga zaʼ böʼ ziaga. Lu yödzö naʼ dë ga zoa Bönniʼ Unná Bëʼ nayë́pisëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Ruluʼë lahui Dios sóaruʼ tsutsu cuitëʼ Lëʼ ga zoa lu yuʼu lidxëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Gulaʼdáʼbagaʼ nupa taʼnná bëʼ lu yu ni, en gulaʼbíguiʼë raʼ yödzö láʼayi naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Cateʼ bilaʼléʼenëʼ yödzö naʼ buluʼbáninëʼ. Gulaʼböʼë böniga, en laʼ buluʼzxúnnajtëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Raʼ yödzö naʼ gulaʼzxíziëʼ. Gulaʼzacaʼ ziʼë ca raca queë́nu nigula chizóa uzóanu-biʼ bíʼidoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Risö́l-lëʼë Dios tu böʼ budunuʼ, le rusuniti yuguʼ barco zxön que yödzö Tarsis. ");
INSERT INTO zarNT_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Biyönruʼ ca nácagaca le zxön benëʼ Dios, ateʼ naʼa riléʼe quéziruʼ le runëʼ, lu yödzö láʼayi queëʼ Dios quégaca niʼa nëʼë guizxi yu, en náquiëʼ caʼ Dios queë́ruʼ. Tsaz naguixjëʼ yödzö naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Ga zoa lu yudoʼ quiuʼ, Dios, röjnetuʼ ca naca yöl-laʼ dxiʼi ladxiʼ quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Ca nayë́pisëtërö Loʼ, Dios, caʼ taʼgúʼu Liʼ yöl-laʼ ba bönachi idútë yödzölió. Ca naca le naca tsahuiʼ rinná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Uluʼdzeja bönachi nacuáʼ yödzö Sión. Uluʼzíʼinu xibé nigula zxíʼini xiʼsóëʼ Judá tuʼ ruchiʼa rusörö́uʼ netuʼ ca naca le naca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Guliʼdá idú gásibiʼilö ga dë yödzö Sión, en buliʼlaba yuguʼ yuʼu sibi tun chiʼi yödzö naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Buliʼyú ca naca zöʼö run chiʼi yödzö naʼ, en buliʼyú caʼ le nuzóagaca le tsutsu, para gaca quíxjöiʼiliʼ zxíʼini xiʼsóaliʼ ca náquiëʼ Dios zxön ni. ");
INSERT INTO zarNT_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Tsaz náquiëʼ Dios queë́ruʼ, naʼa dza, en dza siʼ zaca. Uluíʼinëʼ rëʼu nöza tödi gátiruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Guliʼyöni lë ni, libíʼiliʼ, bönachi yúguʼtë yödzö. Buliʼzë́ nágaliʼ, libíʼiliʼ, zóaliʼ idútë yödzölió. ");
INSERT INTO zarNT_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Libíʼiliʼ, nayë́psëtëröliʼ, en libíʼiliʼ, nácaliʼ cáʼasö. Libíʼiliʼ, dë yöl-laʼ tsahuiʼ queë́liʼ, en libíʼiliʼ, nácaliʼ yechiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Tsöjsáʼ ládxaʼa ca naca le nápagaca yöl-laʼ réajniʼi, en guʼa didzaʼ le nápagaca yöl-laʼ raca yenniʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Güíʼi ládxaʼa ca naca tu le rucudzuʼ didzaʼ, en quíxjöʼa ca nácagaca tsanni quinniaʼ lëʼe bihuël-la. ");
INSERT INTO zarNT_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Bitiʼ bi rádxidaʼ cateʼ ridxín bi raca quiaʼ, cateʼ taʼguʼë nedaʼ lë́ʼajlö bönniʼ tuáʼ döʼ bitiʼ taʼléʼenëʼ nedaʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Tuʼzxöni ládxëʼë bönniʼ naʼ yöl-laʼ tsahuiʼ quégaquiëʼ, en tun ba zxön cuíngaquiëʼ ca nácagaca le dë quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Bitiʼ gaca huöáʼuëʼ laʼ cuinsëʼ nitúëʼ bönniʼ naʼ. Bitiʼ gaca bi unödzjëʼ queëʼ Dios le gun ga usölë́ʼ lëʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","tuʼ naca zxö́ntërö le huöáʼu yöl-laʼ naʼbán que nu bönniʼ, ateʼ catu caz gaca nu bönniʼ quizxjëʼ ca naca, ");
INSERT INTO zarNT_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","para idéliʼnëʼ sóaticaʼsëʼ ibanëʼ, en cabí tsáziëʼ yeru ba ga yúʼugaquiëʼ bönniʼ nati. ");
INSERT INTO zarNT_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Riléʼenëʼ tatiëʼ caʼ bönniʼ taʼyéajniʼinëʼ, en taʼnitiëʼ tuz ca tati nupa bitiʼ bi nö́zigaca, en nupa bitiʼ taʼyéajniʼi, ateʼ tuʼcáʼanëʼ yöl-laʼ tsahuiʼ quégaquiëʼ le uluʼzíʼ xibé bönachi yúbölö. ");
INSERT INTO zarNT_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Téquinëʼ ilaʼcuáʼticaʼsö lídxigaquiëʼ bönniʼ naʼ, ateʼ tsaz ilaʼcuʼë niʼ, ateʼ taʼguʼë lágaca xiyúgaquiëʼ ca naca laʼ lágacasëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Pero yöl-laʼ ba zxön napëʼ bönniʼ naʼ bitiʼ gun ga sóaticaʼsëʼ. Gati cazëʼ ca tátibaʼ böaʼ guixiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Caní naca le gaca quégaquiëʼ bönniʼ tuʼzxöni ládxëʼë yöl-laʼ tsahuiʼ quégaquiëʼ, encaʼ quégaca zxíʼini xiʼsóagaquiëʼ, yuguʼ biʼi naʼ taʼyaza ládxiʼgacabiʼ didzaʼ guluʼë xúzgacabiʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Ilátiëʼ ca tátibaʼ böʼcuʼ zxilaʼ, ateʼ yöl-laʼ guti gaca quégaquiëʼ ca tu nu uyú böʼcuʼ zxilaʼ. Yuguʼ bönniʼ tsahuiʼ ilaʼnná béʼenëʼ légaquiëʼ cateʼ itö́ yu zila. Ilaʼniti le gutaʼ quégaquiëʼ, ateʼ ilaʼcuáʼticaʼsëʼ lataj chul-la ga dzöʼö nupa nátigaca. ");
INSERT INTO zarNT_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Huöáʼu cazëʼ Dios yöl-laʼ naʼbán quiaʼ lu yöl-laʼ guti, tuʼ ichë́ʼë nedaʼ ga tsöjsóalenaʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Bitiʼ gádxinuʼ cateʼ idéliʼnëʼ nu bönniʼ yöl-laʼ tsahuiʼ zxön, en cateʼ xön yöl-laʼ lachi que yuʼu lidxëʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","tuʼ cabí bi uʼë cateʼ gátiëʼ, en bitiʼ tséajlen lëʼ yöl-laʼ lachi que le gutaʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Sal-laʼ cateʼ niʼ zoëʼ nabanëʼ buzíʼ xibé böʼ naca cazëʼ, ateʼ gulaʼgúʼu bönachi lëʼ yöl-laʼ ba cateʼ bidéliʼnëʼ yöl-laʼ tsahuiʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","Tsáziëʼ ga naʼ dzöʼë xuz xtáʼahuëʼ, en bítiʼrö iléʼenëʼ beníʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Náquiëʼ bönniʼ napëʼ yöl-laʼ zxön, pero riyádzjanëʼ yöl-laʼ réajniʼi, ca böaʼ guixiʼ tati cázabaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Ruʼë didzaʼ Xanruʼ Dios nayë́pisëtërëʼ. Nutubëʼ dërö nupa nacuáʼ yödzölió ga naguélaʼtë ga rilén gubidza ga ridxintë ga ribía. ");
INSERT INTO zarNT_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Lu yödzö Sión riguʼë Dios beníʼ. Napa yödzö naʼ yöl-laʼ lachi idú. ");
INSERT INTO zarNT_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Zëʼë Dios queë́ruʼ, en bitiʼ soëʼ dxisö. Tsöjnöru lahuëʼ tu guíʼ zxön, ateʼ tsecja tu böʼ budunuʼ idú gasibíʼilëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Ulidzëʼ lúzxiba xitsáʼ, encaʼ luyú cateʼ uchiʼa usörö́ëʼ quégaca bönachi queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Rnnëʼ Dios: “Guliʼtúbi nupa néquiguequi quez quiaʼ, nupa naʼ gulunlen nedaʼ didzaʼ dzaga, en buluʼlalaj rön lahuaʼ le ben tsutsu didzaʼ dzaga naʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Naca bëʼ náquiëʼ tsahuiʼ Dios lúzxiba xitsáʼ, tuʼ uchiʼa usörö́ëʼ Dios bönachi queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Rnnëʼ: “Buliʼzë nágaliʼ, bönachi quiaʼ, ateʼ guʼa didzaʼ. Buliʼzë́ nágaliʼ, bönachi Israel, ateʼ uzéguiaʼ libíʼiliʼ didzaʼ. Naca cazaʼ Dios. Ön, nacaʼ Dios queë́liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Bitiʼ uzéguiaʼ libíʼiliʼ didzaʼ ca naca le rúnnaliʼ quiaʼ, en calëga ca nácagacabaʼ böaʼ bëdxi ruzéguiʼliʼ-baʼ lahuaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Bitiʼ riquindaʼ-baʼ bëdxi queë́liʼ, en calëga chivo biguiúʼ nacuáʼabaʼ queë́liʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","tuʼ néquigacabaʼ quiaʼ yúguʼtëbaʼ böaʼ guixiʼ, encaʼ böaʼ-bëdxi nacuáʼabaʼ lu gayuáʼ gayuáʼ guíʼadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Néquigacabaʼ caʼ quiaʼ yúguʼtëbaʼ böaʼ zoa xíligacabaʼ, encaʼ yúguʼtë le zoa nabán laʼ guixiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Laʼtuʼ ridunaʼ bitiʼ guíaʼ caʼ libíʼiliʼ, tuʼ nequi quiaʼ yödzölió, encaʼ yúguʼtë le nacuáʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","¿Naruʼ gágutsaʼ xipë́laʼgacabaʼ bëdxi, o guíʼjatsaʼ xichö́ngacabaʼ chivo?” ");
INSERT INTO zarNT_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Le ral-laʼ unö́dzjaliʼ queëʼ Dios naca yöl-laʼ rë Lëʼ: “Xclenuʼ” ateʼ ral-laʼ gunliʼ lahuëʼ Dios nayë́pisëtërëʼ ca naca le guzxíʼ lu náʼaliʼ gunliʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Rnnëʼ caʼ: “Ral-laʼ ulídzaliʼ nedaʼ cateʼ bi gaca queë́liʼ. Gácalen cazaʼ libíʼiliʼ, ateʼ gunliʼ nedaʼ bal.” ");
INSERT INTO zarNT_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Dios rëʼ bönniʼ huíaʼ döʼ, rnnëʼ: “¿Bizx que ruʼu didzaʼ ca nácagaca xibá naguixjaʼ? ¿Bizx que ruʼu didzaʼ ca naca didzaʼ dzaga núnlenaʼ bönachi? ");
INSERT INTO zarNT_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Bitiʼ runnuʼ lataj usédidaʼ liʼ, pero rucáʼanuʼ cáʼasö didzaʼ ruáʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Cateʼ riléʼenuʼ-nëʼ bönniʼ gubán rácalenuʼ lëʼ, en runuʼ tsözxö́n nupa taʼguitsaj xibá que yöl-laʼ nutsaga naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Zóaticaʼsuʼ guʼu didzaʼ xihuiʼ, en ruíʼiticaʼsuʼ didzaʼ bitiʼ nácatë. ");
INSERT INTO zarNT_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Zóaticaʼsuʼ uzéguiuʼ-nëʼ böchiʼ cazuʼ, en rudidzaʼ yudxuʼ böchiʼ-zan cazuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Caní benuʼ, ateʼ bitiʼ bi gunníaʼ, ateʼ gúquinuʼ nacaʼ ca naca cazuʼ liʼ, pero naʼa uzéguiaʼ liʼ didzaʼ, en uluʼa lahui le nunuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Buliʼzë́ nágaliʼ didzaʼ ni, núlöliʼ ruzóaliʼ nedaʼ tsöláʼalö. Channö cabí, usunítiaʼ libíʼiliʼ, ateʼ cuntu nu gaca usölá libíʼiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Nu rë nedaʼ: Xclenuʼ, runna quiaʼ le run nedaʼ bal, ateʼ nu run ca rnna xtídzaʼa, usölá cazaʼ nu naʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Dios quiaʼ, buzáʼ ladxiʼ quiaʼ tsca naca yöl-laʼ dxiʼi ladxiʼ zxön quiuʼ, en tsca naca le zián le ruzáʼ ládxuʼu quiaʼ, bugúa yuguʼ le gudáʼbagaʼa loʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Buguíbiticaʼsö nedaʼ tsca naca döʼ biʼa. Buchiʼa nedaʼ lu dul-laʼ nunaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Nöz quézidaʼ le gudáʼbagaʼa, en röjnétiquiʼsidaʼ yuguʼ dul-laʼ nunaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Loʼ Liʼ cazuʼ benaʼ dul-laʼ, en loʼ Liʼ caʼ biʼa döʼ. Naca bëʼ nacuʼ tsahuiʼ cateʼ ruʼu didzaʼ, en idú dxiʼa, en tsahuiʼ nacuʼ cateʼ ruchiʼa rusörö́uʼ queë́tuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Buyútsöcaʼ, nabágaʼa döʼ cateʼ gusí lotë guljaʼ, en lu dul-laʼ zoa cazaʼ cateʼ buzóanu xináʼa nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Rë́ʼënuʼ soa le naca idútë li icja ládxiʼdoʼotuʼ. Guchiza icja ládxiʼdaʼahuaʼ yöl-laʼ réajniʼi. ");
INSERT INTO zarNT_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Buchiʼa nedaʼ len le ruchíʼaninuʼ, ateʼ gacaʼ dxiʼa. Buguibi nedaʼ, ateʼ huöácaʼ zxílaʼdoʼos. ");
INSERT INTO zarNT_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Ben ga yöndaʼ le nachë́ʼ yöl-laʼ ruzíʼ xibé, en yöl-laʼ rudzeja, para huöáca ládxaʼa lu le raca quiaʼ tuʼ benuʼ ga réquibeʼedaʼ nabágaʼa dul-laʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Bitiʼ uyúʼ yuguʼ dul-laʼ nunaʼ, en busulu yúguʼtë le naca döʼ nabágaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Dios quiaʼ, bun dxiʼa ládxiʼdaʼahuaʼ, en guchiza nedaʼ tu böʼ cubi le nuzúʼ tsutsu. ");
INSERT INTO zarNT_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Bitiʼ ucuítuʼ nedaʼ ga zoaʼ loʼ Liʼ, en bitiʼ ugúʼ Dios Böʼ Láʼayi quiuʼ Nu zóalen nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Bunna quiaʼ yöl-laʼ rudzeja que yöl-laʼ rusölá quiuʼ, en ben ga gunaʼ ca rnna xtídzuʼu idú ládxaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Níʼirö usë́didaʼ nupa taʼguitsaj xibá quiuʼ ca nácagaca le rë́ʼënuʼ ilúngaca, ateʼ yuguʼ bönniʼ dul-laʼ uluʼhuécja quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Dios quiaʼ, benna nedaʼ lataj cabí ibágaʼa xiguiaʼ. Naca cazuʼ Dios, Nu rusölá nedaʼ. Lu yöl-laʼ rudzeja quiaʼ gul-laʼ ca naca cazuʼ tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Xanaʼ Dios, gusalaj ruáʼa, ateʼ usiyöndaʼ bönachi yöl-laʼ ba quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Laʼtuʼ raza ládxuʼu-baʼ böaʼ-bëdxi gútituʼ-baʼ loʼ, laʼ gúnteaʼ caní. Bitiʼ raza ládxuʼu-baʼ nu böaʼ uzéguiʼtuʼ-baʼ loʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Le rë́ʼënëʼ Dios le naca ca tu le cúʼuruʼ lahuëʼ naca böʼ naca cáziruʼ le nötaj nagula ladxiʼ. Dios quiaʼ, bitiʼ ucáʼanuʼ cáʼasö ládxiʼdoʼotuʼ le ruhuíʼini ladxiʼ, en le naca nöxaj ladxiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Lu yöl-laʼ ruzáʼ ladxiʼ quiuʼ ben le naca dxiʼa quégaca bönachi yödzö Sión. Buchisa zöʼö le run chiʼi yödzö Jerusalén. ");
INSERT INTO zarNT_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Níʼirö tsaza ládxuʼu yuguʼ le cúʼutuʼ loʼ le naca idú dxiʼa, yuguʼ böaʼ guíxiʼdoʼ gútituʼ-baʼ loʼ, en yuguʼ böaʼ-bë́dxidoʼ uzéguiʼtuʼ-baʼ loʼ. Níʼirö ilútiëʼ-baʼ yuguʼ bëdxi biguiúʼdoʼ, en ilaʼguʼë-baʼ lu bucugu quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","¿Bizx que run ba zxön cuinuʼ niʼa que döʼ ruʼu, bönniʼ nál-la? Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Len lúdxuʼu rúnlenuʼ luzóʼo didzaʼ para usunítiuʼ bönachi. Naca lúdxuʼu, bönniʼ rizíʼ yëʼ, ca tu guíë tuchiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Nadxíʼirönuʼ le naca döʼ ca nadxíʼinuʼ le naca dxiʼa, en nadxíʼirönuʼ le cabí nácatë ca nadxíʼinuʼ le naca idútë li. ");
INSERT INTO zarNT_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Nadxíʼinuʼ yúguʼtë didzaʼ tun ditaj bönachi, liʼ naʼ, bönniʼ rizíʼ yëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Tsaz uzötaj cazëʼ Dios liʼ. Sönëʼ liʼ, en ubéajëʼ liʼ lu yuʼu lidxuʼ, en ucuítëʼ liʼ ga nacuáʼ nupa nabángaca. ");
INSERT INTO zarNT_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Yuguʼ bönniʼ tsahuiʼ ilaʼléʼenëʼ lë ni, en iládxinëʼ Dios. Uluʼzxidxëʼ queëʼ bönniʼ naʼ rizíʼ yëʼë, ilaʼnë́ʼ: ");
INSERT INTO zarNT_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“¡Buliʼyútsöcaʼ! Bönniʼ ni bitiʼ gúʼunnëʼ uzxöni ládxëʼë Dios, pero buzxöni ládxëʼë yöl-laʼ tsahuiʼ queëʼ, en le zián le guzë́ ládxëʼë le cabí bi nazacaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Nacaʼ nedaʼ ca tu yaga olivo yaʼa le röʼ raʼ yuʼu lidxëʼ Dios. Uzxöni ládxaʼa yöl-laʼ dxiʼi ladxiʼ queëʼ Dios yuguʼ iz siʼ zaca. ");
INSERT INTO zarNT_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Guíëticaʼsaʼ Liʼ: “Xclenuʼ” tuʼ ben cazuʼ Liʼ ga naca caní, ateʼ gunaʼ löza Loʼ le naca dxiʼa lógaca nupa néquiguequi quez quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Taʼzáʼ ládxëʼë bönniʼ canö́z, taʼnnë́ʼ: “Bitiʼ caʼ zoëʼ Dios.” Nácagaquiëʼ xihuiʼ bönniʼ caní, en núngaquiëʼ le nácatërö xihuiʼ. Cuntu nu bönniʼ zoëʼ runëʼ le naca dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Ga naʼ zoëʼ Dios yehuaʼ yubá ruyúëʼ gátiʼtës, en riléʼenëʼ bönachi nacuáʼ idútë yödzölió, para inö́zinëʼ channö zoa nu réajniʼi, o channö zoëʼ nu bönniʼ ruíʼi ládxëʼë Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Yúguʼtë bönachi söjáquiëʼ ga yúbölö. Yúguʼtëʼ nácagaquiëʼ xihuiʼ. Cuntu nu zoa run le naca dxiʼa, nitúëʼ bönniʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","¿Naruʼ cabí nápagaquiëʼ yöl-laʼ réajniʼi bönniʼ naʼ tuʼë döʼ? Tuʼsunítiëʼ bönachi quiaʼ ca tu nu ragu yöta, en bitiʼ caʼ tuʼlidzëʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Tadxi taʼdzö́binëʼ bönniʼ caní, en bitiʼ bi nunaʼ quégaquiëʼ. Caní raca tuʼ rusunítiëʼ Dios caz nupa taʼdíl-lalen libíʼiliʼ. Gunliʼ ga uluʼtuíʼinëʼ tuʼ chigurúʼunëʼ Dios légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Raca ládxiʼruʼ irúaj Sión Nu usölá bönachi Israel. Cateʼ uchisa cazëʼ Dios bönachi queëʼ nadzúngaca, uluʼdzeja zxíʼini xiʼsóëʼ Jacob, en uluʼzíʼ xibé bönachi Israel. ");
INSERT INTO zarNT_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Busölá nedaʼ, Dios, para gaca yöl-laʼ ba que Loʼ. Len yöl-laʼ huáca quiuʼ guléaj nedaʼ tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Ruzë́ naguʼ le rulidzaʼ Liʼ, Dios. Ruzë́ naguʼ didzaʼ ruáʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Taʼdíl-lalen bönniʼ ziʼtuʼ nedaʼ, tuʼ të́ʼënëʼ bönniʼ zidzaj ilútiëʼ nedaʼ. Bitiʼ caʼ tádxinëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Buliʼyútsöcaʼ, naca cazëʼ Dios Nu rácalen nedaʼ. Ruzóëʼ tsutsu Xanruʼ yöl-laʼ naʼbán quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Ubiʼë quégaca nupa taʼdíl-lalen nedaʼ le usuniti léguequi. Tuʼ runuʼ ca rnna xtídzuʼu, Dios, busuniti léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Idú ládxaʼa gútiaʼ-baʼ böaʼ-bëdxi loʼ. Guíaʼ Liʼ: “Xclenuʼ” Xan, tuʼ naca dxiʼa Loʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Busölá cazuʼ Liʼ nedaʼ lu yuguʼ le guca quiaʼ, ateʼ riléʼedaʼ zeaj nanítiticaʼsö nupa taʼdíl-lalen nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Ruzë́ naguʼ le rulidzaʼ Liʼ, Dios, en bitiʼ táʼbaguʼ le rinábidaʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Ruzë́ naguʼ nedaʼ, en rubíʼu didzaʼ. Rulidza yúdxidaʼ Liʼ, en röʼa böniga ");
INSERT INTO zarNT_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","niʼa que chiʼë bönniʼ bitiʼ riléʼenëʼ nedaʼ dxiʼa, en tuʼ tuʼtsáʼ nedaʼ nupa tuáʼ döʼ, en tuʼsacaʼ ziʼ nedaʼ, en lu yöl-laʼ rilé quéguequi taʼbía no nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Réqui ziʼ ládxiʼdaʼahuaʼ, ateʼ yöl-laʼ radxi que yöl-laʼ guti röjtsaza ládxiʼdaʼahuaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Chigulaʼyaza yöl-laʼ radxi, en yöl-laʼ rizxizi nedaʼ, ateʼ nabagaʼ yöl-laʼ radxi ridzöbi nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Gunníaʼ: “Gaca ládxaʼa gataʼ quiaʼ xílabaʼ guʼdödoʼ, para gaca tödaʼ lu böʼös, en idxinaʼ tu lataj ga gaca uzíʼ ládxaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Raca ládxaʼa tsejaʼ ziʼtuʼ, en tsöjsóaʼ laʼ guixiʼ ga dë lataj. ");
INSERT INTO zarNT_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Uyijaʼ carelö tu lataj ga tsöjsóaʼ tsutsu, para cabí bi gun quiaʼ le naca ca böʼ budunuʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Busuniti légaquiëʼ, Xan, en buxí ruáʼagaquiëʼ, tuʼ biléʼedaʼ taʼdil-lëʼ, en tuʼtsatsëʼ lu yödzö. ");
INSERT INTO zarNT_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Rëla, en te dza taʼdödëʼ nöza lu yödzö. Tuʼë döʼ, en tunëʼ le xihuiʼ idú gásibiʼilö yödzö. ");
INSERT INTO zarNT_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Tuʼsunítiëʼ le nacuáʼ niʼ. Tuʼsacaʼ ziʼë bönachi, en taʼzíʼ yëʼë laʼ nöza que yödz. ");
INSERT INTO zarNT_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Calëga bönniʼ bitiʼ riléʼenëʼ nedaʼ dxiʼa nu rudidzaʼ yudxi nedaʼ, tuʼ huáca guáʼ ilenaʼ le gunëʼ, en calëga bönniʼ rudíʼinëʼ nedaʼ nu ridíl-lalen nedaʼ, tuʼ huáca ucachiʼ cuinaʼ lahuëʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","pero nacuʼ liʼ, tu bönniʼ ca nedaʼ. Nacuʼ böchiʼ luzáʼa, en nacuʼ tuz len nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Lu yöl-laʼ dxiʼi ladxiʼ queë́ruʼ gúcaruʼ tuz. Ladaj bönachi zián gudaruʼ, en bidxinruʼ lidxëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Xanaʼ Dios, bëʼ yöl-laʼ guti lataj idxín quégaquiëʼ bagáchiʼsö. Ben ga tsöjtsázagaquiëʼ nabángaquiëʼ lataj chul-la ga nacuáʼ nupa nátigaca, tuʼ yuʼu le xihuiʼ lídxigaquiëʼ, en lu yuʼu caʼ gapa tuʼdubëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Pero nedaʼ ulidzaʼ-nëʼ Dios, ateʼ usölá cazëʼ Xanruʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Chiʼi dzö́ʼölö, en zíladoʼ, en gatsaj dza ulidza yúdxidaʼ Lëʼ, en innë́ ládxaʼa lahuëʼ, ateʼ yön cazëʼ chiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Huöáʼuëʼ yöl-laʼ naʼbán quiaʼ lu naʼ nupa taʼdíl-lalen nedaʼ en uzóëʼ nedaʼ lataj ga cözaʼ dxiʼa tsáhuiʼdoʼ, tuʼ nayándaʼ nupa taʼdíl-lalen nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Huayö́n quézinëʼ Dios, en ubiʼë quégaquiëʼ. Röʼë rinná bë́ʼticaʼsëʼ Lëʼ. Caní gunëʼ Dios tuʼ cabí tuʼsanëʼ ca tunëʼ, en bitiʼ tádxinëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Bönniʼ ruʼë döʼ ribía nahuëʼ nu riböza dxiʼa tsáhuiʼdoʼ, en rucáʼanëʼ cáʼasö didzaʼ dzaga nunëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Bëʼë didzaʼ yúladoʼ, pero yuʼu icja ládxiʼdaʼahuëʼ yöl-laʼ ridzáʼa. Bëʼë didzaʼ zxíxidoʼ, pero didzaʼ naʼ bëʼë gulaca ca guíë tuchiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Gulúʼu le nabáguʼu lu nëʼë Xanruʼ, ateʼ utipa cazëʼ ládxuʼu. Bitiʼ guʼë lataj iguínnaj tsaz nu naca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Chúʼunëʼ bönniʼ tuʼë döʼ naʼ lataj chul-la ga nacuáʼ nupa nátigaca ga naʼ ilaʼnítigaquiëʼ. Bitiʼ ilaʼcuáʼ gatsaj tsca ral-laʼ ilaʼcuʼë nabángaquiëʼ bönniʼ tutiëʼ bönachi, en bönniʼ taʼzíʼ yëʼë. Pero nedaʼ uzxöni ládxaʼa Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Buéchiʼ ladxiʼ nedaʼ, Dios, tuʼ taʼdáʼbagaʼ bönachi nedaʼ. Yuguʼ dza nupa tuʼdíʼi nedaʼ taʼbía no nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Yuguʼ dza nupa bitiʼ taʼléʼe nedaʼ dxiʼa tuáʼ döʼ quiaʼ. Zián nupa taʼdíl-lalen nedaʼ lu yöl-laʼ run ba zxön cuínguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Cateʼ radxi ridzö́bidaʼ, uzxöni ládxaʼa Xanruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Ruzxöni ládxaʼa-nëʼ Dios, en riguʼa yöl-laʼ ba xtídzëʼë. Ruzxöni ládxaʼa-nëʼ, en bitiʼ bi gádxidaʼ. ¿Bizxi caz gaca ilún quiaʼ bönachi? ");
INSERT INTO zarNT_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Yuguʼ dza tun nigui nedaʼ nupa bitiʼ taʼléʼe nedaʼ dxiʼa. Taʼzáʼ ládxiʼticaʼsö nacxi iluáʼ döʼ quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Tuʼdubëʼ ga nagáchiʼsö, en tuʼyúlanëʼ yúguʼtë le runaʼ, para gataʼ quégaquiëʼ lataj ilútiëʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Bubiʼë quégaquiëʼ, Dios, ca naca döʼ tuʼë, en lu yöl-laʼ rilé quiuʼ busuniti légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Nöz quézinuʼ Liʼ ca röʼa böniga. Nurixuʼ Liʼ nisa ribödxi quiaʼ. ¿Naruʼ cabí nuzúʼ léguequi lu guichi quiuʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Cateʼ ulidzaʼ Liʼ, laʼ dza náʼasö uluʼhuécja gúz cúdzuʼlö nupa tuʼdíʼi nedaʼ. Nöz quézidaʼ rácalen cazuʼ nedaʼ, Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Ruzxöni ládxaʼa-nëʼ Dios, en riguʼa yöl-laʼ ba xtídzëʼë. Ruzxöni ládxaʼa-nëʼ Xanruʼ, en riguʼa yöl-laʼ ba xtídzëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Ruzxöni ládxaʼa-nëʼ, en bitiʼ bi gádxidaʼ. ¿Bizxi caz gaca ilún bönachi quiaʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","¡Gunnaʼ quiuʼ, Dios yuguʼ le guzxíʼ lu naʼa! ¡Cuʼa Liʼ yöl-laʼ ba! ");
INSERT INTO zarNT_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Busölóʼ nedaʼ lu yöl-laʼ guti, en nuzúʼ nedaʼ tsutsu. Ridá cazaʼ loʼ Liʼ, Xantuʼ Dios, lu beníʼ ruʼu quégaca nupa nabángaca. ");
INSERT INTO zarNT_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","¡Buéchiʼ ladxiʼ nedaʼ, Dios! ¡Buéchiʼ ladxiʼ nedaʼ tuʼ ruzxöni ládxaʼa Liʼ gun chiʼu nedaʼ! Guxóa noʼo nedaʼ ca runbaʼ böra run chíʼigacabaʼ bö́radoʼ zxan xílabaʼ, ga idxinrö tödi bönadxi raca quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Rulidzaʼ-nëʼ Dios nayë́pisëtërëʼ. Náquiëʼ Dios Nu run ga raca dxiʼa quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Ga zoa cazëʼ yehuaʼ yubá ubiʼë didzaʼ, en usölë́ʼ nedaʼ. Usölë́ʼ nedaʼ lu naʼ nu ribía no nedaʼ. Lu yöl-laʼ dxiʼi ladxiʼ queëʼ, en yöl-laʼ idú ladxiʼ queëʼ gácalenëʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Naca quiaʼ tsca zoaʼ ládjagacabaʼ bëdxi guixiʼ. Yuguʼ bönniʼ zidzaj nagúʼugaquiëʼ nedaʼ lë́ʼajlö. Nácagaca láyiʼgaquiëʼ ca yuguʼ yaga tuchiʼ que gudil-la, ateʼ nácagaca lúdxiʼgaquiëʼ ca yuguʼ guíë tuchiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Dios quiaʼ, buluíʼi lahui lúzxiba yöl-laʼ zxön quiuʼ, en yödzölió ni buluíʼi lahui yöl-laʼ beníʼ quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Nupa tuʼdíʼi nedaʼ nucáchiʼgaca du yalaj le sön nedaʼ. Rudú ládxaʼa tuʼ röʼa böniga. Gulaʼchö́ʼönëʼ yeru ga tsöjbixaʼ nedaʼ, pero gulaʼbixëʼ laʼ légacasëʼ lu yeru naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","¡Chinabáʼa quiaʼ, Dios! ¡Chinabáʼa quiaʼ! ¡Gul-laʼ quiuʼ, en cuʼa Liʼ yöl-laʼ ba! ");
INSERT INTO zarNT_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","¡Bubán, böʼ naca cazaʼ! ¡Guliʼbán arpa, en bihuël-la! ¡Zíladoʼ ubanaʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","en gul-laʼ quiuʼ Liʼ, Xan, ladaj bönachi yuguʼ yödzö! ¡Cuʼa Liʼ yöl-laʼ ba lógaca yúguʼtë bönachi! ");
INSERT INTO zarNT_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Zxö́ntërö naca yöl-laʼ ruhuéchiʼ ladxiʼ quiuʼ, le ridxintë yehuaʼ yubá, ateʼ ridxintë yöl-laʼ idú ladxiʼ quiuʼ lúzxiba xitsáʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Dios quiaʼ, buluíʼi lahui lúzxiba yöl-laʼ zxön quiuʼ, en yödzölió ni buluíʼi lahui yöl-laʼ beníʼ quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","¿Naruʼ ruíʼiliʼ didzaʼ idútë li, libíʼiliʼ naʼ, rinná bë́ʼëliʼ? ¿Naruʼ ruchiʼa rusöröliʼ ca naca le naca tsahuiʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","¡Bitiʼ caʼ! Rizáʼ ládxiʼliʼ yuguʼ le xihuiʼ, en rusacaʼ zíʼiliʼ bönachi len yuguʼ le cabí nácatë runliʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Taʼdödi tsöláʼalö nupa tuáʼ döʼ ga gudélaʼtë gúljagaca. Taʼzíʼ yëʼ ga gudélaʼtë buluʼcuáʼanu xináʼaguequi léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Yuʼu ruíʼiguequi le nachë́ʼ yöl-laʼ guti ca le dxía láyiʼgacabaʼ bëla síniaʼ. Nácagaca ca tubaʼ bëla síniaʼ nacö́dzubaʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","bëla naʼ bitiʼ riyönbaʼ chiʼë bönniʼ gudzáʼ, o le rul-lëʼ bönniʼ runëʼ gudzáʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","¡Dios quiaʼ! ¡Buzxuzxaj láyiʼgaquiëʼ! ¡Guladzuʼ yuguʼ layiʼ tuchiʼ quégaquiëʼ nácagaca ca layiʼ tuchiʼ quégacabaʼ bëdxi guixiʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","¡Ben ga ilaʼnítiëʼ ca raca que nisa yegu gubóʼo cateʼ ruhuíʼi! ¡Ben ga ilaʼcuádiëʼ ca raca que guixiʼ röʼö laʼ nöza! ");
INSERT INTO zarNT_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","¡Ben ga ilaʼnítiëʼ ca yuguʼ bö́ruhuinna tuʼúnabaʼ lu gubidza, o ca tubiʼ bíʼidoʼ nuzóanu-biʼ nigula zíʼalö ca ral-laʼ gáljabiʼ, en chinátitëbiʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Zíʼalö ca gaca utsëʼe yusuʼ tu guíʼ zxön, ugǘëʼ Dios légaquiëʼ lu yöl-laʼ ridzáʼa queëʼ, bönniʼ nabángaquiëʼ, en bönniʼ chizóa ilátiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Uluʼdzeja nupa nácagaca tsahuiʼ cateʼ ilaʼléʼe uzíʼ lëbëʼ Dios bönniʼ tuʼë döʼ naʼ. Uluʼzxinëʼ len náʼagaquiëʼ xichö́ngaca nupa naʼ tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Ilaʼnná bönachi: “Le nácatë zoa le rubiʼë Dios quégaca nupa nácagaca tsahuiʼ. Le nácatë zoëʼ Dios Nu ruchiʼa rusörö́ quégaca nupa nacuáʼ yödzölió.” ");
INSERT INTO zarNT_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Busölá nedaʼ, Dios, lu náʼagaca nupa taʼzóa reguʼ nedaʼ. Buzóa nedaʼ tsutsu ga bitiʼ gaca ilaʼdxín nupa taʼdíl-lalen nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Busölá nedaʼ lu náʼagaca nupa tuáʼ döʼ, en guléaj nedaʼ lu náʼagaca nupa tuti bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Buyútsöcaʼ, taʼbö́ʼ nísiëʼ nedaʼ para ilútiëʼ nedaʼ. Taʼzóa réguʼë bönniʼ zidzaj nedaʼ, calëga tuʼ gudáʼbagaʼa légaquiëʼ, o tuʼ ben ziʼa légaquiëʼ, Xan, ");
INSERT INTO zarNT_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","en calëga tuʼ bë́tiaʼ bönachi, pero taʼzë́ʼë carelö para tíl-lalenëʼ nedaʼ. Gudá gácalenuʼ nedaʼ, ateʼ iléʼenuʼ naca caní. ");
INSERT INTO zarNT_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Xantuʼ Dios quégaca niʼa noʼo guizxi yu, en Dios quégaca bönachi Israel, gudá dujenuʼ xiguiaʼ bönachi yúguʼtë yödzö. Bitiʼ uzáʼ ládxuʼu quégaca nupa tuáʼ döʼ lu yöl-laʼ rizíʼ yëʼ quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Tuʼdxinëʼ chiʼi dzö́ʼölö, taʼbödxi yechë́ʼë ca runbaʼ böʼcuʼ ragu yéchiʼbaʼ beoʼ, ateʼ taʼdödëʼ idú gásibiʼilö yödzö. ");
INSERT INTO zarNT_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Buyútsöcaʼ, didzaʼ tuʼë nácagaca ca le rë́bigaquiëʼ. Nácagaca didzaʼ tuʼë ca yuguʼ guíë tuchiʼ. Taʼnnë́ʼ: “¿Nuzxi caz yöni?” ");
INSERT INTO zarNT_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Ruzxidxuʼ ca naca le tunëʼ, Xan. Rutitjuʼ ca naca le tun bönachi yúguʼtë yödzö. ");
INSERT INTO zarNT_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Tuʼ nal-la cazuʼ Liʼ gunaʼ löza Liʼ. Nacuʼ Dios Nu run chiʼi nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Tuʼ náquiëʼ Dios quiaʼ dxiʼi ladxiʼ, dutságuiëʼ nedaʼ. Uxicja cazëʼ Dios nupa taʼdíl-lalen nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Bitiʼ gútiuʼ nupa naʼ tuáʼ döʼ para cabí ilal-la ladxiʼ bönachi ladzaʼ. Lu yöl-laʼ huáca zxön quiuʼ bë́silasi nupa tuáʼ döʼ, en buzötaj léguequi luyú. Naca cazuʼ Xantuʼ, Nu run chiʼi netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Ben ga sön légaquiëʼ yöl-laʼ run ba zxön cuíngaquiëʼ tuʼ nözi dul-laʼ tunëʼ ca tuíʼisëʼ didzaʼ, encaʼ tuʼ tuʼdxíëʼ döʼ luzáʼagaquiëʼ, en taʼzíʼ yëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Lu yöl-laʼ rilé quiuʼ busuniti légaquiëʼ. Busuniti légaquiëʼ tsaz para cabí ilaʼcuáʼarëʼ, en para iléquibeʼe bönachi Dios caz rinná béʼenëʼ zxíʼini xiʼsóëʼ Jacob, ga ridxintë idútë yödzölió. ");
INSERT INTO zarNT_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Tuʼdxinëʼ chiʼi dzö́ʼölö, taʼbödxi yechë́ʼë ca runbaʼ böʼcuʼ ragu yéchiʼbaʼ beoʼ, ateʼ taʼdödëʼ idú gásibiʼilö yödzö. ");
INSERT INTO zarNT_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Taʼdë́ʼ taʼguiljëʼ le ilahuëʼ, ateʼ taʼbö́dxiʼë channö cabí uluʼhuölaj uluʼdzéʼenëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Gul-laʼ nedaʼ ca naca yöl-laʼ huáca zxön quiuʼ. Yuguʼ zila gul-laʼ lu yöl-laʼ rudzeja quiaʼ ca naca yöl-laʼ dxiʼi ladxiʼ quiuʼ, tuʼ naca cazuʼ Liʼ Nu run chiʼi nedaʼ, en nacuʼ Nu rácalen nedaʼ cateʼ bi raca quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","¡Naca cazuʼ Liʼ Nu rutipa ládxaʼa! ¡Gul-laʼ quiuʼ yöl-laʼ ba, tuʼ nacuʼ Liʼ Nu run chiʼi nedaʼ, Dios, en Nu nadxíʼi nedaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Nusán noʼo netuʼ, Dios, en nuzötjuʼ netuʼ. Buécja queë́tuʼ naʼa, en gúcalen netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Ben cazuʼ ga gudödi budóʼ zxuʼ, en guyalaj luyú. Bun luyú ni tuʼ chizóa iguínnaj. ");
INSERT INTO zarNT_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Sizxöni busacaʼ ziʼu bönachi quiuʼ. Le guca queë́tuʼ guca tsca buguiʼjuʼ netuʼ xis uva nal-la le ben ga yöjchéguʼtuʼ ca tu bönniʼ nazúdxinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Bunödzjuʼ quégaca nupa tadxi Liʼ tu lariʼ uluʼchisa, le söjácalen cateʼ bi raca quéguequi, ");
INSERT INTO zarNT_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","para uluʼlágaca nupa naʼ nadxíʼi quézinuʼ. Len yöl-laʼ huáca zxön quiuʼ busölá netuʼ, en bubíʼi didzaʼ cateʼ rulidztuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Lu le naca láʼayi queëʼ bëʼë didzaʼ Dios, gunnë́ʼ: “Uziʼa xibé, en quísiaʼ xiyúgaca bönachi Siquem, en urixaʼ luyú dë cuita yegu Sucot. ");
INSERT INTO zarNT_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Nequi quiaʼ xiyúgaca bönachi Galaad, encaʼ xiyúgaca zxíʼini xiʼsóëʼ Manasés. Naca ca tu le rusubín icjaʼ xiyúgaca zxíʼini xiʼsóëʼ Efraín. Xiyúgaca zxíʼini xiʼsóëʼ Judá naca ga rinná bëʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Xiyúgaca bönachi Moab naca ca tu ga riguibi naʼa, ateʼ cuʼa lölaʼ uléajaʼ xiyúgaca bönachi Edom. Cö́dxiʼa tuʼ uxicjaʼ bönachi Filistea.” ");
INSERT INTO zarNT_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","¿Nuzxi caz gaca ichë́ʼ nedaʼ lu yödzö zoa zöʼö idú gásibiʼilö le run chiʼi yödzö naʼ? ¿Nuzxi caz ichë́ʼ nedaʼ lu xiyúgaca bönachi Edom? ");
INSERT INTO zarNT_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","¿Naruʼ cabí nusán ládxuʼu netuʼ, Dios? ¿Naruʼ cabí tséajlenuʼ bönniʼ queë́tuʼ röjáquiëʼ gudil-la? ");
INSERT INTO zarNT_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Gúcalen netuʼ cateʼ tíl-lalentuʼ nupa ridíl-lalen netuʼ, tuʼ cabí gaca gácalen netuʼ nu naca bönáchisö. ");
INSERT INTO zarNT_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Len yöl-laʼ huáca queëʼ Dios idéliʼruʼ tuʼ uxicja cazëʼ Lëʼ nupa taʼdíl-lalen netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Ruzë́ naguʼ le rulidzaʼ Liʼ, Dios. Ruíʼi ládxuʼu le rinábidaʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Ga ni zoaʼ ziʼtuʼ ga dë ladzaʼ rulidzaʼ Liʼ tuʼ rudú ládxaʼa. Guchë́ʼ nedaʼ ga zoa Nu naʼ naca ca tu guiö́jtoʼo, Nu naʼ nál-latërö ca nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Nacuʼ Liʼ Nu run chiʼi nedaʼ. Nacuʼ Nu rácalen nedaʼ cateʼ zoa nu ribía no nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Bëʼ lataj sóaticaʼsaʼ ga zoa cazuʼ Liʼ. Bëʼ lataj sóalenaʼ Liʼ, gunaʼ nedaʼ ca tunbaʼ bö́radoʼ taʼyázabaʼ zxan xílabaʼ yöjede. ");
INSERT INTO zarNT_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Biyö́n quézinuʼ Liʼ le guzxíʼ lu naʼa gunaʼ quiuʼ Liʼ, Dios. Benuʼ ga nequi quiaʼ le runödzjuʼ quégaca nupa tadxi Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Gunuʼ ga soëʼ xidzé bönniʼ naʼ rinná bëʼë uláz quiuʼ. Zián iz soëʼ ibanëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Sóaticaʼsëʼ loʼ Liʼ, Dios. Bëʼ queëʼ yöl-laʼ dxiʼi ladxiʼ, en le naca idútë li, yuguʼ le ilún chiʼi lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","¡Gúl-laticaʼsaʼ yöl-laʼ ba que Loʼ, para gaca gunaʼ tu tu dza le guzxíʼ lu naʼa! ");
INSERT INTO zarNT_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","¡Tuzëʼ Dios ruzxöni ládxaʼa, en rizë́ ládxaʼa Lëʼ! ¡Lë cazëʼ rusölë́ʼ nedaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","¡Tuzëʼ Lëʼ rapa chiʼë nedaʼ, en rusölë́ʼ nedaʼ! ¡Ruzóëʼ nedaʼ tsutsu, ateʼ bitiʼ gaca nu uzötaj nedaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","¿Gácaʼxte caz güíʼi ládxiʼliʼ ucúl-laliʼ nedaʼ? Rë́ʼënisiliʼ uzö́tjaliʼ nedaʼ ca tu zöʼö chizóa iguínnaj, o ca tu lëʼaj yaga le chinatëbi. ");
INSERT INTO zarNT_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Rë́ʼënisiliʼ uzö́tjaliʼ nedaʼ ga ni tunëʼ nedaʼ bal. Ruzíʼiliʼ xibé yuguʼ didzaʼ bitiʼ nácatë. Ruíʼiliʼ dxiʼa didzaʼ láhuiʼsö, pero lu icja ládxiʼdoʼoliʼ rudidzaʼ yúdxiliʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","¡Tuzëʼ Dios ruzxöni ládxaʼa, en runaʼ löza Lëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","¡Tuzëʼ Lëʼ rapa chiʼë nedaʼ, en rusölë́ʼ nedaʼ! ¡Ruzóëʼ nedaʼ tsutsu, ateʼ bitiʼ gaca nu uzötaj nedaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","¡Tuzëʼ Dios rusölë́ʼ nedaʼ, en runëʼ ga nacaʼ bicaʼ ba! ¡Dios nuzóëʼ nedaʼ tsutsu, en rapa chiʼë nedaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Libíʼiliʼ, bönachi, buliʼzxöni ládxëʼë Dios yúguʼtë dza. Buliʼsiyönnëʼ yuguʼ le raca queë́liʼ, tuʼ run chiʼi cazëʼ rëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Le nácatë nácagaca yúgutë bönachi ca tu böʼ ridö́disö, en bitiʼ bi nazácaʼgaca nupa naʼ nadéliʼgaca lataj lo. Tu lu zxigóns bitiʼ bi nál-líʼguequinëʼ. Nácagacarëʼ dzáʼasö ca tu böʼ riguélaʼsiruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Bitiʼ uzxöni ládxiʼliʼ bi idéliʼliʼ len yöl-laʼ nál-la queë́ziliʼ. Bitiʼ uzíʼiliʼ xibé le cuanliʼ. Channö gataʼ queë́liʼ yöl-laʼ tsahuiʼ, bitiʼ güíʼi ládxiʼliʼ le. ");
INSERT INTO zarNT_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Tu luzuísö bëʼë didzaʼ Dios. Chopa luzuí biyöndaʼ ca naca lë ni rnna: “Nápatërëʼ Dios yöl-laʼ huáca, ");
INSERT INTO zarNT_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","ateʼ zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ.” Ubíʼi cazuʼ, Xan, quégaca bönachi tsca naca le núngaca. ");
INSERT INTO zarNT_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Dios, nacuʼ Dios quiaʼ, ateʼ idú ládxaʼa ruguiljaʼ Liʼ. Ribidxi ládxaʼa Liʼ, ateʼ idútë le nacaʼ rizë́ ladxiʼ Liʼ. Zoaʼ tu luyú bidxi ga ni rudú ládxaʼa, ateʼ bitiʼ bi dë nisa. ");
INSERT INTO zarNT_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Ben ga iléʼedaʼ Liʼ lu lataj ga naʼ zoa cazuʼ, para iléʼedaʼ yöl-laʼ huáca quiuʼ, en yöl-laʼ beníʼ quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Tuʼ nácatërö dxiʼa yöl-laʼ dxiʼi ladxiʼ quiuʼ ca yöl-laʼ naʼbán caz. Que lë ni naʼ cuʼa Liʼ yöl-laʼ ba. ");
INSERT INTO zarNT_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Guíaʼ Liʼ: “Xclenuʼ” tsanni ni zoaʼ nabanaʼ. Uchisaʼ naʼa, en ulidzaʼ Loʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Ruhuölaj rudzéʼe icja ládxiʼdaʼahuaʼ le nácatërö dxiʼa, ateʼ lu yöl-laʼ rudzeja quiaʼ riguʼa Liʼ yöl-laʼ ba. ");
INSERT INTO zarNT_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Röjnedaʼ Liʼ cateʼ déaʼ lu le rátiʼdaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Rizáʼ ládxaʼa ca nacuʼ cateʼ rinaʼsaʼ yëla. Rácalen cazuʼ nedaʼ, en tuʼ run chiʼu nedaʼ, lu yöl-laʼ rudzeja quiaʼ rul-laʼ quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Nazö́n cazuʼ Liʼ böʼ naca cazaʼ. Rizö́n cazuʼ Liʼ nedaʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","pero ilaʼyaza lataj chul-la nupa të́ʼëni iluti nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Ilátigaca lu guíë tuchiʼ. Ilágugaca böʼcuʼ zugaʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Nu rinná bëʼ uláz queëʼ Xanruʼ udzeja ladxiʼ lahuëʼ Dios. Uluʼzíʼ xibé yúguʼtë nupa tuʼzxöni ladxiʼ Lëʼ, tuʼ usayaj cazëʼ Lëʼ ruíʼigaca nupa taʼzíʼ yëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Dios, buzë́ naguʼ chiʼa le rinabi yúdxidaʼ Liʼ, para gun chiʼu yöl-laʼ naʼbán quiaʼ tuʼ rádxidaʼ bi gun nu ridíl-lalen nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Bucachiʼ nedaʼ para cabí bi ilún quiaʼ bagáchiʼsö nupa tuáʼ döʼ, en para cabí ilaʼbía diʼë nedaʼ bönniʼ tutiëʼ bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Nácagaca lúdxiʼgaquiëʼ ca yuguʼ guíë tuchiʼ, ateʼ nácagaca didzaʼ ziʼ tuʼë ca yuguʼ yaga lahui tuchiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Bagáchiʼsö tuʼzë́ yuguʼ yaga lahui tuchiʼ naʼ para ilunëʼ huëʼ nupa bitiʼ bi nabágaʼgaca. Tsálidoʼos tuʼzë́ léguequi, en bitiʼ bi tádxinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Bitiʼ caʼ tuʼcáʼanëʼ le naca döʼ të́ʼënëʼ ilunëʼ. Tuʼë didzaʼ ca gaca uluʼcáchëʼë yuguʼ du yalaj quégaquiëʼ, taʼnnë́ʼ: “¿Nuzxi caz gaca iléʼe yuguʼ du naʼ?” ");
INSERT INTO zarNT_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Tunëʼ didzaʼ ca naca le naca döʼ ilunëʼ, taʼnnë́ʼ: “Chinabáʼa le gunruʼ.” Tuʼcáchiʼgaquiëʼ le taʼzáʼ ládxëʼë, en le taʼbequi icjëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Uzal-lëʼ Dios tu yaga lahui tuchiʼ le ideliʼ légaquiëʼ. Tsálidoʼos gunëʼ légaquiëʼ huëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Laʼ didzaʼ tuíʼisëʼ ilún ga tseajchéguʼgaquiëʼ. Lu yöl-laʼ rubani quéguequi uluʼtá ícjaguequi nupa ilaʼléʼe légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Níʼirö yúguʼtë bönachi iladxi Dios, en uluʼsiyö́n luzë́ʼeguequi ca naca le nunëʼ Dios, en ilaʼzáʼ ládxiʼgaca ca naca lë naʼ nunëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Nu bönniʼ tsahuiʼ uziʼë xibë́ʼ Xanruʼ, en gunëʼ löza Lëʼ. Yúguʼtë nupa nácagaca idú ladxiʼ uluʼzíʼ xibë́ʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Dios, nupa nacuáʼ yödzö Sión ilaʼgúʼu Liʼ yöl-laʼ ba, en ilunna quiuʼ le gulaʼzíʼ lu në́ʼeguequi, ");
INSERT INTO zarNT_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","tuʼ riyö́n quézinuʼ Liʼ cateʼ tuʼlidza Liʼ, ateʼ yúguʼtë bönachi ilaʼdxín loʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Tun nigui nedaʼ dul-laʼ nunaʼ, pero runiti lo cazuʼ netuʼ ca naca le ridáʼbagaʼtuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Bicaʼ ba nupa nabö́ cazuʼ quiuʼ, en nulidzuʼ quiuʼ, para ilaʼcuáʼ yuguʼ lataj láʼayi quiuʼ. Huölaj udzéʼetuʼ le nácagaca dxiʼa yúʼugaca lidxuʼ, encaʼ le yúʼugaca yudoʼ láʼayi quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Tuʼ nacuʼ tsahuiʼ rubiʼu didzaʼ, en runuʼ yuguʼ le zxön le tácalen netuʼ. Naca cazuʼ Dios Nu rusölá netuʼ. Nupa nacuáʼ idútë yödzölió uluʼzxöni ladxiʼ Liʼ, encaʼ nupa nacuáʼ ziʼtuʼ iaʼtsöláʼalö nísadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Len yöl-laʼ huáca quiuʼ nucúʼu yuguʼ guíʼa zxön, le naca bë́ʼgaca nál-latërö cazuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Ruzóa dxíuʼ le riyasa ridxía lu nísadoʼ, en le ruʼu bö que. Ruzóa dxíuʼ bönachi cateʼ tuʼtsatsa. ");
INSERT INTO zarNT_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Bönachi idútë yödzölió tadxi Liʼ niʼa quégaca le zxön nunuʼ. Le run cazuʼ Liʼ tun ga tuʼdzeja bönachi idapa laʼa yödzölió. ");
INSERT INTO zarNT_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Ruíʼi ládxuʼu luyú, en risö́l-luʼu nisa guiö́j. Runuʼ ga ruhuöáca yu yaʼa. Nucúʼu luyú naʼ yuguʼ yegu yúdzugaca nisa zila, le run ga dë́ticaʼsö zxoaʼ-za, tuʼ caní raza ládxuʼu Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Risö́l-luʼu nisa guiö́j gapa dë́gaca na, en rusubisuʼ gapa chinadúz. Ruúnuʼ yúludoʼ luyú zidzaj, en runuʼ ga taʼgula guixiʼ cuandoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Runuʼ ga ruláʼ yödx yanaʼ le nadúz luyú ni tu iz tu iz, en ga zóaticaʼsö le ilëʼaj ilágugaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Nacuáʼabaʼ böaʼ-bëdxi laʼ guixiʼ, ateʼ tuʼdzeja bönachi yuguʼ lu guíʼadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Gapa naca lachiʼ nacuáʼabaʼ böʼcuʼ zxilaʼ, ateʼ dxíadaʼ zxoaʼ xtila laʼ yëla. Lu yöl-laʼ rudzeja quéguequi taʼbö́dxiʼa, en tul-la bönachi quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","¡Guliʼgüíʼ zidzaj didzaʼ lahuëʼ Dios lu yöl-laʼ rudzeja queë́liʼ yúguʼtëliʼ zóaliʼ yödzölió! ");
INSERT INTO zarNT_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","¡Guliʼgul-la ca naca yöl-laʼ ba que Lëʼ! ¡Guliʼcuʼë yöl-laʼ ba! ");
INSERT INTO zarNT_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Guliʼguíëʼ Dios: “¡Zxö́ntërö nácagaca le nunuʼ tuʼ naca zxö́ntërö yöl-laʼ huáca quiuʼ!” Nupa bitiʼ taʼléʼe Liʼ dxiʼa uluʼluíʼi cuini ca nupa tun ca rnna xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Yúguʼtë nupa nacuáʼ yödzölió ilún Liʼ zxön, en ilúl-la yöl-laʼ ba quiuʼ. Ilúl-la yöl-laʼ ba que Loʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Guliʼdá iléʼeliʼ yuguʼ le nunëʼ Dios. Nayë́pisëtërëʼ Dios lu le runëʼ quégaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Benëʼ ga böáca ca luyú bidxi ga dë nísadoʼ. Gulaʼdödëʼ gatsaj láhuiʼlö yegu, taʼzë́ʼesö níʼagaquiëʼ. Niʼ udzéjadeʼeruʼ ca náquiëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Len yöl-laʼ unná bëʼ queëʼ rinná bë́ʼticaʼsëʼ. Ruyúticaʼsëʼ bönachi yúguʼtë yödzö. Bitiʼ ral-laʼ ilún ba zxön cuínguequi nupa taʼdáʼbagaʼ xtídzëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","¡Guliʼgún zxönëʼ Dios queë́tuʼ, libíʼiliʼ bönachi yúguʼtë yödzö, en guliʼcuʼë yöl-laʼ ba gátiʼtës! ");
INSERT INTO zarNT_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","¡Run cazëʼ Lëʼ ga zóaruʼ nabanruʼ, en bitiʼ ruʼë lataj cuila níʼatuʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Guzxíʼ bëʼ cazuʼ netuʼ, Dios. Buchiʼu netuʼ ca run nu ruchiʼa guíë plata lu guíʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Bëʼu lataj bidzuntuʼ lu du yalaj. Busubáguʼu netuʼ tu yuaʼ ziʼi. ");
INSERT INTO zarNT_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Benuʼ ga gulaʼlibëʼ icjtuʼ bönniʼ dxíagaquiëʼ-baʼ böaʼ. Gudö́dituʼ lu guíʼ, en lu nisa, pero guchë́ʼ cazuʼ netuʼ tu lataj ga bölaj budzéʼetuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Tsuʼa lidxuʼ, en cuʼa-baʼ loʼ böaʼdoʼ uzéguiʼa-baʼ loʼ. Gunaʼ loʼ Liʼ le guzxíʼ lu naʼa gunaʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","lë naʼ bëʼa didzaʼ que, le gunníaʼ cateʼ niʼ riguíʼi rizácaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Cuʼa-baʼ loʼ Liʼ böaʼ-bëdxi renniʼ uzéguiʼa-baʼ loʼ, tsözxö́n len dzön quégacabaʼ chivo biguiúʼ. Gútiaʼ-baʼ loʼ yuguʼ bëdxi, en yuguʼ chivo biguiúʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Guliʼdá uzë́ nágaliʼ, yúguʼtëliʼ rádxiliʼ-nëʼ Dios, ateʼ usiyöndaʼ libíʼiliʼ yuguʼ le benëʼ le gulácalen nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Len ruáʼ cuinsaʼ bulidzaʼ Lëʼ, en benaʼ Lëʼ zxön len lúdxaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Channö rucáchaʼa le naca döʼ lu ládxiʼdaʼahuaʼ, bitiʼ yönnëʼ Xanruʼ Dios didzaʼ guʼa, ");
INSERT INTO zarNT_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","pero le nácatë biyönnëʼ Dios didzaʼ bëʼa. Buzë́ naguëʼ cateʼ bulidzaʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","¡Yöl-laʼ ba Dios! ¡Bitiʼ gudáʼbaguëʼë nedaʼ cateʼ bulidzaʼ-nëʼ, en bitiʼ bugǘëʼ yöl-laʼ nadxíʼi queëʼ nedaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Xantuʼ Dios, buzáʼ ladxiʼ queë́tuʼ, en ben ga gaca dxiʼa queë́tuʼ. Lu yöl-laʼ dxiʼi ladxiʼ quiuʼ buyú netuʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","para gaca bëʼ le rë́ʼënuʼ guntuʼ yödzölió ni, en para ilaʼnözi bönachi yúguʼtë yödzö ca naca yöl-laʼ rusölá quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Ral-laʼ ilaʼgúʼu bönachi Liʼ yöl-laʼ ba, Dios. Yúguʼtë bönachi ral-laʼ ilaʼgúʼu Liʼ yöl-laʼ ba. ");
INSERT INTO zarNT_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Ral-laʼ uluʼdzeja bönachi yúguʼtë yödzö, en ilúl-la lu yöl-laʼ rudzeja quéguequi. Tuʼ uchiʼa usörö́uʼ bönachi ca naca le naca tsahuiʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","ral-laʼ ilaʼgúʼu Liʼ yöl-laʼ ba bönachi, Dios. Yúguʼtë bönachi ral-laʼ ilaʼgúʼu Liʼ yöl-laʼ ba. ");
INSERT INTO zarNT_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Yödxi yanaʼ runödzaj luyú ni. Dios queë́ruʼ runëʼ ga raca dxiʼa queë́ruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Runëʼ Dios ga raca dxiʼa queë́ruʼ, para iladxi Lëʼ yúguʼtë nupa nacuáʼ yödzölió. ");
INSERT INTO zarNT_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Raca ládxiʼruʼ chasëʼ Dios, en usulásiëʼ nupa taʼdíl-lalen Lëʼ, en gunëʼ ga uluʼzxunnaj nupa bitiʼ taʼléʼe Lëʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Ca rulaga tu böʼ recja dzön, caʼ bulaga léguequi. Ca naʼ ruúnaʼ lu guíʼ quízxiʼbaʼ buz, caʼ ilaʼniti nupa tuáʼ döʼ lahuëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Uluʼdzeja nupa nácagaca tsahuiʼ, en uluʼzíʼ xibë́ʼ Dios. Lu yöl-laʼ rudzeja quéguequi uluʼzíʼ xibë́ʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","¡Guliʼgul-la queëʼ Dios! ¡Guliʼgul-la yöl-laʼ ba que Lëʼ! Buliʼpáʼa nöza ga tödëʼ gapa dë lataj. ¡Nazíʼi lëʼ Xanruʼ! ¡Buliʼdzeja lahuëʼ Lëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Náquiëʼ ca xúzgacabiʼ biʼi uzë́bidoʼ, encaʼ Nu ruchiʼa rusörö́ quégacanu nigula uzëbi. Caní náquiëʼ Dios ga naʼ zoëʼ lataj láʼayi queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Rucuʼë Dios nupa nagáʼanagaca bayechiʼ tu yuʼu. Rubéajëʼ nupa nadzúngaca, en runëʼ ga raca dxiʼa quéguequi, pero uluʼgáʼana tu luyú bidxi nupa taʼdáʼbagaʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Yöjnöru cazuʼ lógaca bönachi quiuʼ, Dios, cateʼ guchëʼu léguequi laʼ guixiʼ ga naʼ dë lataj. ");
INSERT INTO zarNT_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","Gudödi budóʼ zxuʼ dza niʼ. Lëscaʼ gula guiö́jsiuʼ lahuëʼ Dios. Guzxizi guíʼa Sinaí lahuëʼ Dios quégaca bönachi Israel. ");
INSERT INTO zarNT_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Benuʼ ga gulaj guiö́jsiuʼ, Dios. Benuʼ ga böáca yaʼa xiyúʼ ga niʼ guca yu bidxi. ");
INSERT INTO zarNT_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Yöjcuáʼ nupa néquiguequi quiuʼ luyú naʼ. Lu yöl-laʼ dxiʼi ladxiʼ quiuʼ, Dios, bucözuʼ le gácalen nupa nácagaca yechiʼ luyú naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Bëʼ cazëʼ didzaʼ Xanruʼ Dios. Taʼguísinu nigula zián didzaʼ dxiʼa queëʼ, taʼnnanu: ");
INSERT INTO zarNT_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","“¡Taʼzxúnnajëʼ! ¡Taʼzxúnnajëʼ bönniʼ taʼnná bëʼë, encaʼ bönniʼ röjáquiëʼ gudil-la guizxi yu quégaquiëʼ!” Nigula gulaʼbö́zanu lídxigacanu buluʼzíʼinu xibé le gutáʼ quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Sal-laʼ bucachiʼ loliʼ gapa tun chíʼiliʼ böʼcuʼ zxilaʼ, gáculiʼ le naca lachi ca nácagacabaʼ guʼdödoʼ néquiguequinibaʼ guíë plata, en xitúbigacabaʼ néquiguequini guíë oro. ");
INSERT INTO zarNT_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Cateʼ bësilásiëʼ Dios bönniʼ naʼ gulaʼnná bëʼë lu guíʼa Salmón, benëʼ ga gula guiö́j böguiʼ lu guíʼa naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Nequi queëʼ Dios guíʼa Basán. Naca guíʼa Basán naʼ tu guíʼa zxön. ");
INSERT INTO zarNT_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","¿Bizx que ruzxéʼeliʼ, yuguʼ guíʼa zxön? ¿Bizx que ruzxéʼeliʼ guíʼa naʼ guzë́ ládxëʼë Dios tsöjsóëʼ ga naʼ? Le nácatë tsaz soëʼ Dios niʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Gayuáʼ, en gayuáʼ nácagaca carreta que gudil-la queëʼ Dios. Rizë́ʼë Xanruʼ lu guíʼa Sinaí ga naʼ tseajtsaziëʼ lataj láʼayi queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Buëpuʼ yehuaʼ yubá richëʼu bönachi zián gulaʼdzúngaca. Nuʼu yuguʼ le buluʼnödzaj bönachi quiuʼ, en le gulunna quiuʼ nupa taʼdáʼbagaʼ Liʼ, para tsöjsóëʼ Dios niʼ tsaz. ");
INSERT INTO zarNT_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","¡Yöl-laʼ ba Dios, Nu ruáʼ suaʼruʼ tu dza tu dza! ¡Náquiëʼ Dios Nu rusölá rëʼu! ");
INSERT INTO zarNT_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","¡Dios queë́ruʼ rusölë́ʼ rëʼu! ¡Rusölë́ʼ Xanruʼ Dios rëʼu lu yöl-laʼ guti! ");
INSERT INTO zarNT_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Le nácatë Dios udxíëʼ huëʼ ícjagaca nupa taʼdáʼbagaʼ Lëʼ. Udxíëʼ huëʼ icjëʼ bönniʼ bitiʼ gusanëʼ ca naca döʼ ruʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Ruʼë didzaʼ Xanruʼ, rnnëʼ: “Ubéajaʼ léguequi lu guíʼa Basán, en ubéajaʼ léguequi lu nísadoʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","ateʼ ulíbiliʼ léguequi ga idxintë irúaj rön quéguequi, ateʼ ilë́ʼajbaʼ zxículiʼ xichö́ngaca nupa taʼdil-lalen libíʼiliʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Taʼléʼe yúguʼtë bönachi nupa taʼdalen Liʼ, Dios. Lu yöl-laʼ run Liʼ zxön taʼdá lu lataj láʼayi quiuʼ, Dios quiaʼ, Nu rinná beʼe nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Nupa tul-la, en nupa taʼguínnaj lë́ʼegaca bihuël-la, taʼdá niʼ, ateʼ biʼi nigula raʼbandoʼ tunbiʼ léguequi tsözxö́n, taʼgápabiʼ lë́ʼegaca guídidoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Buliʼlidzëʼ Dios dxiʼa tsáhuiʼdoʼ gapa naʼ rudúbiliʼ queëʼ, tuʼ náquiëʼ Xanruʼ, libíʼiliʼ zxíʼini xiʼsóëʼ Israel. ");
INSERT INTO zarNT_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Nacuʼë zxíʼini xiʼsóëʼ Benjamín ga naʼ, bönniʼ gúcarëʼ cuidiʼ, ateʼ taʼnná bëʼë. Bönniʼ lo quégaquiëʼ zxíʼini xiʼsóëʼ Judá nútsaʼgaquiëʼ ládjagaquiëʼ, encaʼ ládjagaquiëʼ bönniʼ lo quégaquiëʼ zxíʼini xiʼsóëʼ Zabulón, en Neftalí. ");
INSERT INTO zarNT_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Buluíʼi lahui yöl-laʼ huáca quiuʼ, Dios. Buluíʼi lahui yöl-laʼ huáca quiuʼ, Dios, tuʼ chibenuʼ zián le gulácalen netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Tuʼ dë yudoʼ quiuʼ lu yödzö Jerusalén, bönniʼ taʼnná bëʼë ilaʼchë́ʼë niʼ le ilunnëʼ quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Buzé le bach bönachi yödzö naʼ nácagaca ca böaʼ guixiʼ, encaʼ bönachi yuguʼ yödzö nácagaca ca yuguʼ bëdxi tsözxö́n len zxíʼiniguequi. Tuʼlibi bönachi yechiʼ tuʼ taʼzë́ ládxiʼgaca dumí. Bësilási nupa naʼ taʼyaza ladxiʼ röjaca gudil-la. ");
INSERT INTO zarNT_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Bönniʼ gubáz quégaca bönachi Egipto ilaʼdxinëʼ loʼ. Bönniʼ Etiopía ilaʼchisa náʼagaquiëʼ loʼ, Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","¡Guliʼgul-la queëʼ Dios, bönachi yúguʼtë yödzö! ¡Guliʼgul-la yöl-laʼ ba queëʼ Xanruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Röʼë yehuaʼ yubá xitsáʼtërö, le zoa caz dza niʼte. Buliʼyútsöcaʼ, ruʼë zidzaj didzaʼ, en naca chiʼë ca guziúʼ rinnë́. ");
INSERT INTO zarNT_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","¡Guliʼgún zxönëʼ Dios! Yöl-laʼ nayë́pisë queëʼ rusubagaʼ bönachi Israel. Yöl-laʼ huáca zxön queëʼ naláʼ lúzxiba xitsáʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Rubániruʼ ca nacuʼ Liʼ, Dios, lu lataj láʼayi quiuʼ. Runnuʼ quégaca bönachi quiuʼ yöl-laʼ nal-la, en yöl-laʼ huáca. Náquiëʼ Dios quégaca bönachi Israel. ¡Yöl-laʼ ba Lëʼ Xanruʼ Dios! ");
INSERT INTO zarNT_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Busölá nedaʼ, Xanaʼ Dios, tuʼ raca quiaʼ tsca nabágaʼa nisa ga ridxintë ruchicjaʼ nisa. ");
INSERT INTO zarNT_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Raca quiaʼ tsca ruhuötjaʼ ga rëʼ lu gunaʼ, en bitiʼ zoa ga gaca ulibaʼ. Zoaʼ ca tu lu nisa zila, en chizóa uchicjaʼ nisa. ");
INSERT INTO zarNT_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Rudú ládxaʼa tuʼ rulidzaʼ nu gácalen nedaʼ, ateʼ daʼ lubáʼa. Chirichul-la guiö́j lahuaʼ tuʼ ruyúaʼ ga guíduʼ dusölóʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Nayántërö ca guitsaʼ icjaʼ nupa bitiʼ taʼléʼe nedaʼ dxiʼa, en bitiʼ bi nunaʼ quéguequi. Nál-lagaca nupa taʼdíl-lalen nedaʼ, en të́ʼëni iluti nedaʼ, en bitiʼ bi nunaʼ quéguequi. Tunëʼ bayúdx ubiʼa dumí le cabí gulanaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Nöz quézinuʼ Liʼ, Dios, yöl-laʼ canö́z quiaʼ, en bitiʼ nagachiʼ loʼ Liʼ dul-laʼ nunaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Bitiʼ guʼu lataj nupa tuʼzxöni ladxiʼ Liʼ uluʼtuíʼi niʼa quiaʼ nedaʼ, Xanaʼ Dios nayë́pisëtëruʼ. Bitiʼ guʼu lataj nupa tun Liʼ zxön ilaʼgáʼana cáʼasö niʼa quiaʼ, Dios quégaca bönachi Israel. ");
INSERT INTO zarNT_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Tuʼ nadxíʼidaʼ Liʼ tuʼlidza ditjëʼ nedaʼ, en que lë ni naʼ rutuíʼidaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Nacaʼ ca tu bönniʼ ziʼtuʼ lógacabiʼ biʼi bö́chaʼa, en ca tu bönniʼ ziʼtuʼ lógaquiëʼ diʼa dza quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Tuʼ ruíʼi ládxaʼa yudoʼ quiuʼ régui rilá ládxiʼdaʼahuaʼ. Naca ca tuʼlidza ditaj nedaʼ nupa tuʼlidza ditaj Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Ruzötaj cuinaʼ, en runaʼ gubasa, en que lë ni naʼ tuʼdidzaʼ yudxi nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Rácuaʼ lariʼ cáʼasö ca run nu ribödxi yechiʼ, ateʼ tuʼtitaj nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Taʼnnë́ʼ quiaʼ yuguʼ laʼ nöza, ateʼ nupa nazúdxigaca tul-la ca naca quiaʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","pero nedaʼ ulidzaʼ Liʼ, Xan. Bubíʼi didzaʼ, Dios, cateʼ idxín dza raza ládxuʼu Liʼ tuʼ nadxíʼideʼenuʼ nedaʼ, en tuʼ guzxíʼ lu noʼo usölóʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Guléaj nedaʼ para cabí huötjaʼ lu le naca ca gunaʼ. Ben ga uláʼ lu náʼagaca nupa taʼdíl-lalen nedaʼ, en lu le naca ca nisa zila le chizóa ibagaʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Bitiʼ guʼu lataj ibagaʼ nedaʼ lë naʼ. Bitiʼ guʼu lataj uchicjaʼ lu le naca ca nísadoʼ, encaʼ cabí huötjaʼ tu lu yeru ba. ");
INSERT INTO zarNT_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Bubíʼi didzaʼ, Xan, tuʼ nacuʼ dxiʼi ladxiʼ, en tuʼ ruhuéchiʼ ládxuʼu nedaʼ, gudá quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Bitiʼ ucachiʼ cuinuʼ lahuaʼ nedaʼ, huen dxin quiuʼ. ¡Röʼa böniga! ¡Gudáchi gúcalen nedaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","¡Gudá ga zoaʼ dusölóʼ nedaʼ! ¡Ben ga uláʼ lu náʼagaca nupa taʼdíl-lalen nedaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Nöz quézinuʼ Liʼ ca tuʼdidzaʼ yudxi nedaʼ, en ca tuʼlidza ditaj nedaʼ, en tuʼcáʼana nedaʼ cáʼasö. Riléʼe quézinuʼ yúguʼtë nupa bitiʼ taʼléʼe nedaʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Rudú ládxaʼa tuʼ tuʼdidzaʼ yudxi nedaʼ, en bitiʼ bi gaca gunaʼ. Gulözaʼ nu huéchiʼ ladxiʼ nedaʼ, pero cuntu nu guzóa. Gúʼunidaʼ nu huë tsahuiʼ nedaʼ, pero cuntu nu bidzöli. ");
INSERT INTO zarNT_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Cateʼ gudunaʼ buluʼgahuëʼ nedaʼ tu le siláʼ, en cateʼ gubidxaʼ nisa, buluʼguiʼjëʼ nedaʼ nupe zi. ");
INSERT INTO zarNT_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Ben ga huöáca laní quégaquiëʼ ca tu le sön légaquiëʼ, en ben ga huöáca le tuʼziʼë xibé ca tu le gun ga ilaʼchixi ilaʼníguinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Ben ga ichul-la guiö́j lógaquiëʼ para cabirö ilaʼléʼenëʼ. Ben ga ilaʼzéchuticaʼsö cúdzuʼgaquiëʼ zxan yuaʼ nuáʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Busubagaʼ légaquiëʼ lu yöl-laʼ rilé quiuʼ, en bëʼ quégaquiëʼ yöl-laʼ ridzáʼa quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Ben ga cuntu nu soa ládzagaquiëʼ, en ga bítiʼrö nu soa lu yuʼu lídxigaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Taʼzóa réguʼë nupa naʼ benuʼ léguequi xiguiaʼ. Tuʼsiyönnëʼ ca taʼguíʼi taʼzacaʼ nupa naʼ nunuʼ léguequi huëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Buzúaj lu guichi yuguʼ dul-laʼ tunëʼ, en bitiʼ guʼu légaquiëʼ lataj ilaʼdéliʼnëʼ yöl-laʼ rusölá quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Busulu lágaquiëʼ nazúajgaca lu guichi quégaca nupa nabángaca. Bitiʼ guʼu légaquiëʼ lataj ilaʼbábalenëʼ nupa nácagaca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Nedaʼ riguíʼi rizácaʼa, en rudú ládxaʼa. Guchisa nedaʼ, Dios, en busölá nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","¡Cuʼa-nëʼ yöl-laʼ ba Dios len tu le gul-laʼ! ¡Gunaʼ Lëʼ zxön, en guíaʼ-nëʼ: “Xclenuʼ”! ");
INSERT INTO zarNT_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Chaza ládxëʼë Xanruʼ Dios lë ni ca raza ládxëʼë-baʼ böaʼ-bëdxi rútiaʼ-baʼ lahuëʼ, o ca raza ládxëʼë-baʼ tubaʼ bëdxi zxön chinagúlabaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Nupa taʼguíʼi taʼzacaʼ ilaʼléʼeni lë ni, en uluʼdzeja. Ilaʼdipa ládxiʼgaca nupa tuʼguilaj Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Ruzë́ naguëʼ Xanruʼ Dios nupa taʼyadzaj taʼyudxi, en bitiʼ ral-la ládxëʼë bönachi queëʼ nadzúngaca. ");
INSERT INTO zarNT_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","¡Guliʼcuʼë yöl-laʼ ba Dios, libíʼiliʼ yehuaʼ yubá, en luyú ni, encaʼ nísadoʼ, en yúguʼtë le nacuáʼ tu tu lataj naʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Usölá cazëʼ Dios bönachi Sión, en uchisëʼ yuguʼ yödzö quégaca zxíʼini xiʼsóëʼ Judá. Ilaʼcuáʼ bönachi queëʼ ga naʼ, ateʼ guequi quéguequi luyú naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Zxíʼini xiʼsóagaquiëʼ huen xichinëʼ ilaʼzíʼibiʼ luyú naʼ, ateʼ ilaʼcuáʼticaʼsö niʼ nupa nadxíʼigaca Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","¡Busölá nedaʼ, Dios! ¡Gudáchi gácalenuʼ nedaʼ, Xan! ");
INSERT INTO zarNT_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Ben ga uluʼtuíʼi, en ilaʼbö́ʼ böniga nupa naʼ të́ʼëni iluti nedaʼ. Ben ga uluʼhuécja, en uluʼgáʼana cáʼasö nupa naʼ të́ʼëni gaca bi gaca quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Ben ga uluʼhuécja lu yöl-laʼ rutuíʼi quéguequi nupa naʼ tuʼtitaj nedaʼ, taʼnná: “Ja, ja.” ");
INSERT INTO zarNT_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Ben ga uluʼdzeja, en uluʼzíʼ xibóʼ yúguʼtë nupa tuʼguilaj Liʼ. Ben ga iluíʼiticaʼsö didzaʼ nupa taʼdxíʼi yöl-laʼ rusölá quiuʼ, ilaʼnná: “¡Zxö́ntërö náquiëʼ Dios!” ");
INSERT INTO zarNT_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Nedaʼ nacuídiʼdaʼ, en bitiʼ bi gaca gunaʼ. ¡Gudáchi gácalenuʼ nedaʼ, Dios! Nacuʼ Nu rácalen nedaʼ, en Nu rusölá nedaʼ. ¡Bitiʼ caʼ tsenuʼ guíduʼ quiaʼ, Xan! ");
INSERT INTO zarNT_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Nuzóa cazuʼ nedaʼ dxiʼa tsáhuiʼdoʼ ga naʼ zuʼ, Xan. ¡Bitiʼ guʼu lataj utuíʼidaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","¡Tuʼ nacuʼ tsahuiʼ gúcalen nedaʼ, en busölá nedaʼ! ¡Buzë́ naguʼ nedaʼ, en busölá nedaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Nacuʼ le uzóa nedaʼ tsutsu, en le gun chiʼi nedaʼ ga gaca ucachiʼ cuinaʼ. Chigunná béʼenuʼ nu usölá nedaʼ tuʼ nacuʼ Nu ruzóa nedaʼ tsutsu, en Nu run chiʼi nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Dios quiaʼ, busölá nedaʼ lu naʼ nu ruáʼ döʼ, en lu naʼ nu ridáʼbagaʼ Liʼ, en run dzatsa. ");
INSERT INTO zarNT_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Tuzuʼ Liʼ runaʼ löza, Xan. Ruzxöni ládxaʼa Liʼ ga gudélaʼtë nacaʼ bíʼidoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Ruzxöni ládxaʼa Liʼ ga gudélaʼtë guljaʼ, tuʼ guzóalen cazuʼ nedaʼ cateʼ niʼ buzóanu xináʼa nedaʼ. ¡Cúʼuticaʼsaʼ Liʼ yöl-laʼ ba! ");
INSERT INTO zarNT_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Zián nupa tuʼbani ca naca quiaʼ, tuʼ run chiʼi cazuʼ Liʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","¡Rigúʼuticaʼsaʼ Liʼ yöl-laʼ ba, en tu dza tu dza ruluʼa lahui yöl-laʼ ba quiuʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","¡Bitiʼ usán noʼo nedaʼ naʼa, ni nacaʼ bönniʼ gula! ¡Bitiʼ ucáʼanuʼ nedaʼ naʼa cateʼ ni rudú ládxaʼa! ");
INSERT INTO zarNT_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Tuíʼi didzaʼ nupa bitiʼ taʼléʼe nedaʼ dxiʼa ca gaca bi ilún quiaʼ, ateʼ tun tuz xtídzaʼgaca nupa të́ʼëni iluti nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Taʼnná: “¡Nusán nëʼë Dios lëʼ! ¡Guliʼdá sönruʼ-nëʼ tuʼ cuntu nu zoa gácalen lëʼ!” ");
INSERT INTO zarNT_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","¡Dios, bitiʼ suʼ ziʼtuʼ ga ni zoaʼ! ¡Dios quiaʼ, gudáchi gácalenuʼ nedaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Ben ga uluʼtuíʼi, en ilaʼniti nupa të́ʼëni iluti nedaʼ. Ben ga uluʼtuíʼinëʼ, en ilaʼböʼë böniga bönniʼ të́ʼënëʼ iluʼë döʼ quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","¡Nedaʼ gúnticaʼsaʼ löza Liʼ, en cúʼuticaʼsaʼ Liʼ yöl-laʼ ba! ");
INSERT INTO zarNT_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Idú dza usiyöndaʼ bönachi nacuʼ tsahuiʼ, en rusölóʼ yúguʼtë bönachi. Bitiʼ nözdaʼ bal-laxi luzuí busölóʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","¡Guʼa didzaʼ ca nácagaca le zxön benuʼ Liʼ, Xanaʼ Dios! ¡Usiyöndaʼ bönachi tuzuʼ Liʼ nacuʼ tsahuiʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Dios, rusédinuʼ nedaʼ ga gudélaʼtë niʼ nacaʼ bíʼidoʼ, ateʼ ga ridxintë naʼa dza ruáʼa didzaʼ ca nácagaca le zxön nunuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Naʼa nacaʼ bönniʼ gula, en chinaguchaʼ. ¡Bitiʼ usán noʼo nedaʼ, Dios! Benna nedaʼ lataj usiyöndaʼ yuguʼ zxíʼini xsoaʼ ca naca yöl-laʼ huáca quiuʼ, ateʼ quíxjöiʼidaʼ nupa ilalaj ca naca yöl-laʼ nál-la quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","¡Le tsahuiʼ nacuʼ, Dios, ridxintë lúzxiba! ¡Nunuʼ Liʼ yuguʼ le zxö́ntërö! ¡Cúnturö nu zoa nu naca ca nacuʼ Liʼ, Dios! ");
INSERT INTO zarNT_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Gusöl-laʼ cazuʼ quiaʼ yuguʼ le guca quiaʼ le gulún nedaʼ ziʼ, pero ruúnuʼ nedaʼ tsutsu, en le yúbölö uchisuʼ nedaʼ para cabí gátiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Gunuʼ ga tsë́piseaʼ, en huë tsahúʼu nedaʼ le yúbölö. ");
INSERT INTO zarNT_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","¡Le nácatë cuʼa Liʼ yöl-laʼ ba, en gul-laʼ tu bihuël-la, Dios! ¡Gul-laʼ ca runuʼ ca rnnoʼ, en nacuʼ Nu naca láʼayi lógaca bönachi Israel! ");
INSERT INTO zarNT_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","¡Lu yöl-laʼ rudzeja quiaʼ cö́dxiʼa cateʼ gul-laʼ quiuʼ, en idú ládxaʼa gul-laʼ tuʼ busölóʼ nedaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","¡Idú dza guʼa didzaʼ ca nacuʼ tsahuiʼ! ¡Tuʼtuíʼi, en taʼbö́ʼ baguíʼi nupa gulë́ʼëni iluáʼ döʼ quiaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Dios, buzéajniʼinëʼ bönniʼ rinná bëʼë para gaca uchiʼa usörö́ëʼ ca ruchiʼa rusörö́uʼ Liʼ. Ben ga ilácagacabiʼ tsahuiʼ zxíʼinëʼ ca nacuʼ Liʼ tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Bëʼë lataj uchiʼa usörö́ëʼ quégaca bönachi quiuʼ ca naca le naca tsahuiʼ, encaʼ quégaca bönachi quiuʼ taʼguíʼi taʼzacaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Ben ga ilaʼcuáʼ dxiʼa tsáhuiʼdoʼ bönachi quiuʼ yuguʼ lu guíʼa, en ilácagaca tsahuiʼ yuguʼ lu guíʼadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Bëʼë lataj ubéajëʼ tsahuiʼ nupa taʼguíʼi taʼzacaʼ ladaj bönachi quiuʼ, en usölë́ʼ yuguʼ zxíʼinigaca nupa taʼyadzaj taʼyudxi, en ucul-lëʼ nu ribía no léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Ben ga iladxi bönachi quiuʼ Liʼ tsanni niʼ soa gubidza, encaʼ tsanni niʼ soa beoʼ ga idxintë dza udxi. ");
INSERT INTO zarNT_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Ben ga gáquiëʼ bönniʼ rinná bëʼë ca nisa guiö́j ribixi lu guíxiʼdoʼ, en ca yuguʼ guiö́j gúpaʼdoʼ tuʼsubisa luyú. ");
INSERT INTO zarNT_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Ben ga gaca dxiʼa quégaca nupa nácagaca dxiʼa yuguʼ dza inná bëʼë lëʼ, en ilaʼcuáʼ dxiʼa tsáhuiʼdoʼ ga idxintë bítiʼrö soa beoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Ben ga inná bëʼë idapa laʼa yödzölió, ga naguelaʼ raʼ yegu Eufrates ga idxintë idútë luyú. ");
INSERT INTO zarNT_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Ben ga uluʼzechu zxíbigaca lahuëʼ lëʼ nupa nacuáʼ luyú bidxi, en iladxi lëʼ nupa taʼdíl-lalen lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Ben ga ilaʼdxinëʼ lahuëʼ bönniʼ taʼnná bëʼë luyú Tarsis en yuguʼ lu yödzö, nuáʼgaquiëʼ yuguʼ le uluʼnödzjëʼ queëʼ. Bönniʼ taʼnná bëʼë luyú Sabá, en luyú Seba iláʼdxinëʼ bi uluʼnödzjëʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Ben ga uluʼzechu zxíbigaquiëʼ lahuëʼ yúguʼtë bönniʼ taʼnná bëʼë, en ilúngaca xichinëʼ bönachi yúguʼtë yödzö. ");
INSERT INTO zarNT_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Usölë́ʼ nu riyadzaj riyudxi cateʼ ulidza lëʼ, encaʼ nu riguíʼi rizacaʼ, en nu bitiʼ zoa nu gácalen nu naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Huéchiʼ ládxëʼë nupa nácagaca yechiʼ, en nupa taʼyadzaj taʼyudxi, en gun chiʼë yöl-laʼ naʼbán quégaca nupa nácagaca yechiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Usölë́ʼ léguequi lu náʼagaca nupa tun léguequi ziʼ, en lu náʼagaca nupa tuáʼ döʼ, en güíʼi ládxëʼë léguequi cateʼ nu guë́ʼëni guti léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Soëʼ ibanëʼ, ateʼ iluáʼgaca bönachi queëʼ oro que lu xiyúgaca bönachi Sabá. Ben ga uluʼlidza Dios bönachi, ilaʼnábiticaʼsö Liʼ gácalenuʼ lëʼ. Ben ga uluʼlidza lëʼ dxiʼa tsáhuiʼdoʼ idú dza. ");
INSERT INTO zarNT_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Ben ga unö́dzjadaʼ zxoaʼ luyú queëʼ, encaʼ yuguʼ lu guíʼadoʼ, le unödzaj yödxi yanaʼ xiyúëʼ ca run guíʼa Líbano. Ben ga ilaʼyán nupa nacuáʼ ladzëʼ ca röʼö guíxiʼdoʼ lu xiyúëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Ben ga tsöjnégaca le lëʼ ga idxintë dza udxi. Ben ga gaca yöl-laʼ ba que lëʼ tsanni niʼ soa gubidza. Ben ga ilaʼnabi bönachi Liʼ yúguʼtë yödzö gunuʼ ga gaca dxiʼa quéguequi ca benuʼ queëʼ lëʼ. Ben ga ilaʼgúʼu lëʼ yöl-laʼ ba bönachi yúguʼtë yödzö. ");
INSERT INTO zarNT_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","¡Yöl-laʼ ba Xanruʼ Dios, Dios quégaca bönachi Israel! ¡Tuzëʼ Lëʼ runëʼ le túngaca ga rubániruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","¡Yöl-laʼ ba Lëʼ le naca lachi ga idxintë dza udxi! ¡Rizë́ ládxiʼruʼ ilí idútë yödzölió le naca beníʼ queëʼ! ¡Caʼ gaca! ¡Ön, caʼ gaca! ");
INSERT INTO zarNT_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Chibudxi le rinábidaʼ-nëʼ Dios nedaʼ, David, zxíʼinëʼ Isaí. ");
INSERT INTO zarNT_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Le nácatë runëʼ Dios ga raca dxiʼa quégaca bönachi Israel, nupa naʼ naca dxiʼa tsahuiʼ ládxiʼdoʼguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Iaʼlátiʼsö guchixi guníguidaʼ. Iaʼlátiʼsö tsöjdödaʼ tsöláʼalö, ");
INSERT INTO zarNT_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","tuʼ buzxéʼedaʼ nupa tun ba zxön cuínguequi, en tuʼ dëdaʼ yöl-laʼ tsahuiʼ quégaca nupa tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Bitiʼ caʼ téquinëʼ ziʼ bönniʼ tuʼë döʼ naʼ. Nácagaquiëʼ tsutsu, en nacuʼë dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Bitiʼ taʼguíʼi taʼzáquëʼë ca taʼguíʼi taʼzacaʼ iaʼzícaʼrö bönachi. Bitiʼ caʼ raca quégaquiëʼ ca raca quégaca bönachi yúbölö. ");
INSERT INTO zarNT_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Naca yöl-laʼ run ba zxön cuini quégaquiëʼ ca tu le néquini oro dxía ícjagaquiëʼ. Yöl-laʼ rutsatsa quégaquiëʼ naca ca zxágaquiëʼ nácugaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Tuʼziʼë xibé le taʼdödi bëʼë tëʼaj tahuëʼ, en taʼzáʼ ládxiʼgaquiëʼ quégaca le zián le ilaʼdéliʼnëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Tuʼtitjëʼ iaʼzícaʼrö bönachi, en tuʼë didzaʼ lu yöl-laʼ run ba zxön cuini quégaquiëʼ. Tun ba zxön cuíngaquiëʼ, en të́ʼënëʼ ilaʼbía nahuëʼ iaʼzícaʼrö bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Taʼnnë́ʼ queëʼ Dios zoëʼ yehuaʼ yubá, en tuʼdidzaʼ yudxëʼ nupa nacuáʼ yödzölió. ");
INSERT INTO zarNT_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Que lë ni naʼ taʼdáʼ bönachi queëʼ Dios légaquiëʼ, en taʼyéajlëʼ didzaʼ tuʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Taʼnnë́ʼ: “Bitiʼ caʼ nö́zinëʼ Dios, en bitiʼ iléʼe lë ni Nu naʼ zoa xitsáʼalö.” ");
INSERT INTO zarNT_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Caní nácagaca nupa tuáʼ döʼ. Dëdaʼ yöl-laʼ tsahuiʼ quéguequi, en taʼzíʼticaʼsö iaʼlatiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","¿Naruʼ nítisö ben chiʼi cuinaʼ para gacaʼ dxiʼa en para cabí ibágaʼa dul-laʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Dios, benuʼ ga gudíʼi guzxácaʼa idú dza. Yuguʼ zila benuʼ nedaʼ ziʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Laʼtuʼ bëʼa didzaʼ ca nácagaca lë ni guzxíʼ yéʼedaʼ bönachi quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Que lë ni naʼ bëʼ ládxaʼa tséajniʼidaʼ lë ni, sal-laʼ gúcadaʼ böniga ");
INSERT INTO zarNT_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","ga bidxintë dza guyuʼa yudoʼ quiuʼ en guyéajniʼidaʼ ca gaca quégaca nupa tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Le nácatë nuzúʼ léguequi ga taʼchixi taʼnigui, en runuʼ ga ilaʼniti tsaz. ");
INSERT INTO zarNT_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Laʼ ilaʼnítitë, en ilaʼyaza ga udxi quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Nácagaca ca tu le rinetuʼ yëla le ridödi que cateʼ ritö́ yu. Cateʼ chasuʼ, Xan, laʼ udö́diteuʼ léguequi tsöláʼalö. ");
INSERT INTO zarNT_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Cateʼ yöjdín icjaʼ le nácagaca ca tu le siláʼ, en guzáʼ ládxaʼa yuguʼ le gúquidaʼ ziʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","gucaʼ tuʼ canö́z, en bitiʼ bi guyéajniʼidaʼ. Gucaʼ ca tubaʼ böaʼ guixiʼ loʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Zóaticaʼsaʼ loʼ Liʼ, ateʼ rizö́n cazuʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Rigúʼu yö́l-luʼu nedaʼ le rugúʼu nedaʼ nöza quiuʼ, en ga údxitë uziʼu nedaʼ, en gunuʼ nedaʼ bal. ");
INSERT INTO zarNT_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","¿Núzxirö zoa yehuaʼ yubá nu gácalen nedaʼ? ¡Tuzuʼ Liʼ! Tuʼ rácalenuʼ nedaʼ cúnturö nu zoa yödzölió nu riquindaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Ricuidiʼ le nacaʼ, en rudú ládxaʼa. Le ruzóa tsutsu ládxiʼdaʼahuaʼ, en le ruzíʼticaʼsaʼ xibé naca cazuʼ Liʼ, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Le nácatë ilaʼniti nupa tuʼcáʼana Liʼ. Usunítiuʼ yúguʼtë nupa tuʼzóa Liʼ tsöláʼalö. ");
INSERT INTO zarNT_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Raca dxiʼa quiaʼ cateʼ ribigaʼ ga zuʼ Liʼ, Dios. ¡Naca cazuʼ Liʼ, Xanaʼ Dios, Nu run chiʼi nedaʼ para uluʼa lahui yúguʼtë le nun cazuʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Dios, ¿naruʼ tsaz nusán ládxuʼu netuʼ? ¿Rilédeʼenuʼ netuʼ, böʼcuʼ zxilaʼ queë cazuʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Yöjné netuʼ, bönachi tuʼdubi quiuʼ, nupa böáʼu cazuʼ dza niʼte, nupa böáʼu cazuʼ para gácatuʼ bönachi queë cazuʼ. Yöjné guíʼa Sión, ga ni guzóa cazuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Gudá töduʼ ga ni naguínnajdërö yödzö láʼayi quiuʼ. Buluʼsunítidërö nupa gulaʼdáʼbagaʼ Liʼ yúguʼtë le gulaʼcuáʼ lataj láʼayi quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Tuʼtsatsa nupa naʼ gulaʼdáʼbagaʼ Liʼ idú gásibiʼilö ga ni budúbituʼ quiuʼ. Nucuáʼgaquiëʼ ni le naca bë́ʼgaca nuxícjagaquiëʼ yödzö láʼayi quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Naláʼ lahui yödzö ni ca naláʼ tu guíʼa cateʼ nu gulúʼu le bidín, en nurixi nu naʼ yuguʼ yaga gulaʼcuáʼ lu guíʼa naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Buluʼzxuzxjëʼ le nácagaca lachi lu yödzö ni len yuguʼ guíë huága quégaquiëʼ, en yuguʼ yaga zidzaj. ");
INSERT INTO zarNT_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Buluʼzéguiʼë idútë lataj láʼayi quiuʼ. Nucáʼanagaquiëʼ cáʼasö lataj ga benruʼ bal Loʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Lu icja ládxiʼdoʼgaquiëʼ gulaʼnë́ʼ: “Nuxícjadërötuʼ bönachi ni.” Idútë lu xiyutuʼ buluʼzéguiʼë yúguʼtë yuʼu ga naʼ budúbituʼ loʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Bítiʼrö caz riléʼetuʼ yuguʼ le buluʼsubán ládxiʼtuʼ gulísatuʼ lu xiyutuʼ. Bítiʼrö zoa nu bönniʼ ruʼë didzaʼ uláz quiuʼ. Bítiʼrö zóalen netuʼ nu bönniʼ nö́zinëʼ gácaʼxte caz gaca caní queë́tuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","Dios, ¿gácaʼxte caz uluʼlidza ditaj netuʼ nupa taʼdíl-lalen netuʼ? ¿Gácaʼxte caz uluʼcáʼana ditaj Loʼ nupa taʼdáʼbagaʼ Liʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","¿Naruʼ cabí gácalenuʼ netuʼ? ¿Bizx que nucáchuʼu yöl-laʼ huáca zxön quiuʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Rinná beʼe quézinuʼ netuʼ Liʼ, Dios, dza niʼte quez, en rusölá cazuʼ bönachi idútë yödzölió. ");
INSERT INTO zarNT_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Len yöl-laʼ huáca zxön quiuʼ bubéaj cazuʼ choplö nísadoʼ. Guláʼa cazuʼ ícjagacabaʼ böaʼ zxön nacuáʼabaʼ nísadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Bzxuzxja cazuʼ ícjagacabaʼ böaʼ síniaʼ lëbaʼ Leviatán. Ben cazuʼ ga gulágubaʼ yuguʼ böaʼ guixiʼ xipë́laʼbaʼ böaʼ síniaʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Gusalaj cazuʼ yuguʼ beaj nisa, en gapa rálajdaʼ nisa. Busubidxi cazuʼ yuguʼ yegu nisa gulaʼyúdzuticaʼsö nisa. ");
INSERT INTO zarNT_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Nequi queë cazuʼ lahuiʼ dza, en nequi caʼ quiuʼ chiʼi dzö́ʼölö. Ben cazuʼ Liʼ beníʼ, encaʼ gubidza. ");
INSERT INTO zarNT_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Naguixaj cazuʼ Liʼ yúguʼtë buzáʼ nacuáʼ yödzölió. Nun cazuʼ Liʼ beoʼ la, en beoʼ ziaga. ");
INSERT INTO zarNT_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Yöjné lë ni, Dios. Nupa taʼdáʼbagaʼ Liʼ nucáʼanagaca ditaj Loʼ, ateʼ nupa nácagaca canö́z nucáʼanagaca cáʼasö Loʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Bitiʼ usán noʼo nupa nadxíʼinuʼ lu náʼagaca nupa nácagaca ca yuguʼ böaʼ guixiʼ síniaʼ. Bitiʼ gal-la ládxuʼu tsaz nupa néquiguequi quiuʼ, en taʼguíʼi taʼzacaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Yöjné didzaʼ dzaga naʼ núnlenuʼ netuʼ, tuʼ nacuáʼ nupa tuti bönachi gapa naca chul-la lu xiyutuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Bitiʼ guʼu lataj uluʼgáʼana cáʼasö nupa nácagaca bayechiʼ. Ben ga ilaʼgúʼu Liʼ yöl-laʼ ba nupa taʼguíʼi taʼzacaʼ, en taʼyadzaj taʼyudxi. ");
INSERT INTO zarNT_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","¡Guyasa, Dios, en ben ca rnna xtídzuʼu! ¡Ruzë́ naguʼ ca rulidza ditjëʼ Liʼ bönniʼ canö́z idú dza! ");
INSERT INTO zarNT_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Bitiʼ gal-la ládxuʼu didzaʼ ziʼ tuíʼi nupa taʼdáʼbagaʼ Liʼ. Yöl-laʼ dzatsa tun nupa tuʼcáʼana Liʼ cáʼasö riyö́nticaʼsö. ");
INSERT INTO zarNT_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","¡Rëtuʼ Liʼ: “Xclenuʼ, Dios”! ¡Rëtuʼ Liʼ: “Xclenuʼ”, tuʼ zóaticaʼsuʼ gal-laʼ ga zóatuʼ! ¡Tuíʼi didzaʼ bönachi ca nácagaca le zxön nunuʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Rnnëʼ Dios: “Nuzóaʼ dza cateʼ uchiʼa usörö́aʼ bönachi. Uchiʼa usörö́ cazaʼ léguequi ca naca le nácatë. ");
INSERT INTO zarNT_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Tuʼsuniti yödzölió, en nupa nacuáʼ niʼ, pero tsaz nuzóa cazaʼ le.” ");
INSERT INTO zarNT_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Gudxaʼ nupa tun ba zxön cuínguequi, gunníaʼ: “Bitiʼ gun ba zxön cuinliʼ”, en gudxaʼ nupa tuáʼ döʼ: “Bitiʼ huë tsahuiʼ cuinliʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Bitiʼ huë tsahuiʼ cuinliʼ, en bitiʼ güíʼiliʼ didzaʼ lu yöl-laʼ run ba zxön cuinliʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Calëga ga rilén gubidza, en calëga ga ribía gubidza, en calëga laʼ guixiʼ ga dë lataj irúaj le huë tsahuiʼ bönachi, ");
INSERT INTO zarNT_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","pero uchiʼa usörö́ cazëʼ Dios bönachi. Uzötjëʼ tuëʼ bönniʼ, en uchisëʼ iaʼtúëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Nuáʼ cazëʼ Xanruʼ lu nëʼë tu zxigaʼ yudzu xisa le ribía lubá uva le ribixi rilëbi. Chinugútsiʼdërëʼ le, ateʼ riguʼë le para ilëʼaj le nupa tuáʼ döʼ yödzölió ni, ateʼ ilë́ʼjadërö le siláʼ que. ");
INSERT INTO zarNT_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Nedaʼ usiyö́nticaʼsaʼ bönachi lë ni, en gul-laʼ yöl-laʼ ba queëʼ Dios queëʼ Jacob. ");
INSERT INTO zarNT_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Ugǘëʼ yöl-laʼ unná bëʼ quégaca nupa tuáʼ döʼ. Quíxjëʼ tsaz yöl-laʼ unná bëʼ quégaca nupa nácagaca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Zxíʼini xiʼsóëʼ Judá núnbëʼgaquiëʼ Dios. Nayë́pisë le lëʼ ladaj bönachi Israel. ");
INSERT INTO zarNT_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Zoa caz lataj láʼayi queëʼ lu yödzö Jerusalen, ateʼ nazíʼi le Sión lataj ga naʼ zoa cazëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Niʼ guditsjëʼ yuguʼ yaga lahui tuchiʼ zoa guíʼ láhuiguequi, encaʼ yuguʼ guíë la, en yuguʼ le taʼdíl-lalen bönachi lu gudil-la. ");
INSERT INTO zarNT_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","¡Yöl-laʼ ba Liʼ, Dios! ¡Nayë́pisëtëruʼ ca yuguʼ guíʼa zxön! ");
INSERT INTO zarNT_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Buxicjuʼ bönniʼ nál-lagaquiëʼ. Gudödi yëla guiö́j lógaquiëʼ bönniʼ röjáquiëʼ gudil-la, en bitiʼ guca ilaʼchisa náʼagaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Cateʼ Liʼ, Dios queëʼ Jacob, gudíl-lalen cazuʼ légaquiëʼ gulátibaʼ böaʼ, ateʼ gulati caʼ nupa dxíagaca légacabaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Liʼ caz ral-laʼ gádxituʼ, tuʼ cabí gaca nu soa loʼ cateʼ ilenuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Ga zuʼ Liʼ yehuaʼ yubá gunnóʼ uchiʼa usörö́uʼ bönachi. Níʼirö guladxi nupa nacuáʼ lu yu, en gulaʼcuáʼ dxisö, ");
INSERT INTO zarNT_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","cateʼ guzuínëʼ Dios para uchiʼa usörö́ëʼ quégaca bönachi, para usölë́ʼ nupa nácagaca nöxaj ladxiʼ yödzölió ni. ");
INSERT INTO zarNT_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Sal-laʼ taʼlédeʼe bönachi, gaca yöl-laʼ ba queëʼ Lëʼ. Uziʼë xibégaca nupa uluʼgáʼana ládjaguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Guliʼsíʼ lu náʼaliʼ bi gunliʼ lahuëʼ Xanruʼ Dios, en guliʼgún ca naʼ innaliʼ. Yúguʼtë nupa nacuáʼ ga naʼ zoëʼ ral-laʼ bi uluʼnödzaj queëʼ, tuʼ náquiëʼ Nu ral-laʼ gádxiruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Ubéaj cazëʼ böʼ nácagaca caz nupa nadéliʼgaca lataj lo. Bönniʼ taʼnná bëʼë luyú ni tádxinëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Rulidzaʼ-nëʼ Dios, en ruáʼa zidzaj didzaʼ. Rulidzaʼ-nëʼ Dios, ateʼ riyönnëʼ chiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Cateʼ bi guca quiaʼ bulidzaʼ-nëʼ Dios. Chiʼi dzö́ʼölö guchisa naʼa lahuëʼ, en bitiʼ busanaʼ rulidzaʼ-nëʼ. Bitiʼ guca nu huë tsahuiʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Cateʼ röjnedaʼ-nëʼ Dios, röʼa böniga. Cateʼ rinnë́ ládxaʼa, níʼirö rudú ládxaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Bubéaj cazuʼ yëla guiö́j lahuaʼ. Tuʼ riböʼa böniga bitiʼ gaca guʼa didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Chiguzáʼ ládxaʼa ca guca dza niʼte, ca guca yuguʼ iz chigulaʼdödi. ");
INSERT INTO zarNT_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Tsöjnedaʼ le buláʼ chiʼi dzö́ʼölö, en tsöjsáʼ ládxaʼa ca naca que, ateʼ rinábini cuinaʼ: ");
INSERT INTO zarNT_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","¿Naruʼ tsaz nusán Xanruʼ nedaʼ? ¿Naruʼ cabirö uzáʼ ládxëʼë quiaʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","¿Naruʼ cabirö gáquiëʼ dxiʼi ladxiʼ? ¿Naruʼ cabirö tsöjnenëʼ le guzxíʼ lu nëʼë gunëʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","¿Naruʼ nál-la ládxëʼë Dios tuʼ cabirö ruzáʼ ládxëʼë queë́ruʼ? ¿Naruʼ bítiʼrö huéchiʼ ládxëʼë rëʼu tuʼ rilenëʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Níʼirö gudxi cuinaʼ: Raca caní quiaʼ tuʼ risë́bidaʼ ládxaʼa, en que lë ni naʼ réquidaʼ nadzáʼ yöl-laʼ unná bëʼ queëʼ Dios nayë́pisëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Tsöjnedaʼ yuguʼ le nun cazuʼ Liʼ, Xantuʼ. Tsöjnedaʼ yuguʼ yöl-laʼ huáca benuʼ dza niʼte. ");
INSERT INTO zarNT_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Saʼ ládxaʼa ca nácagaca le nunuʼ, en cuéqui icjaʼ ca nácagaca le runuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Naca láʼayi ca run cazuʼ Liʼ, Dios. Cúnturö nu zoa naca dios ca nacuʼ Liʼ, Dios queë́tuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Naca cazuʼ Liʼ Dios, runuʼ yuguʼ yöl-laʼ huáca zxön. Bulúʼu lahui yöl-laʼ huáca quiuʼ lógaca bönachi yúguʼtë yödzö. ");
INSERT INTO zarNT_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Len yöl-laʼ huáca zxön quiuʼ busölóʼ bönachi quiuʼ, nupa nácagaca zxíʼini xiʼsóagaquiëʼ Jacob, en José. ");
INSERT INTO zarNT_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Bilaʼléʼe yuguʼ nísadoʼ Liʼ, Dios. Bilaʼléʼe yuguʼ nísadoʼ Liʼ, en gulaʼbö́ʼ böniga. Gulaʼzxízilëʼe yuguʼ nísadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Buluʼlalaj böaj lúzxiba nisa. Lúzxiba xitsáʼ gunnëdaʼ guziúʼ. Guyëpi yösa ca yuguʼ yaga lahui tuchiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Lu böʼ budunuʼ biyö́n guziúʼ quiuʼ gunnëdaʼ. Yösa gulaʼyëpi buluʼzeníʼ luyú. Gudö́didaʼ budóʼ zxuʼ, en guzxizi luyú. ");
INSERT INTO zarNT_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Biláʼ lahui nöza quiuʼ gatsaj láhuiʼlö nísadoʼ, ateʼ guzóa nöza ga gudöduʼ gatsaj láhuiʼlö nisa zila. Bitiʼ naláʼ lahui naʼa ga naʼ bulibuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Guchë́ʼ cazuʼ bönachi quiuʼ ca runëʼ bönniʼ richë́ʼë-baʼ böʼcuʼ zxilaʼ huë́ʼënidoʼ. Guchëʼu léguequi lu náʼagaquiëʼ Moisés, en Aarón. ");
INSERT INTO zarNT_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Buliʼzë́ nágaliʼ le uzéajniʼidaʼ libíʼiliʼ, bönachi quiaʼ. Buliʼzë́ nágaliʼ didzaʼ guʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Usaljaʼ ruáʼa, en ucúdzuʼa didzaʼ. Guʼa didzaʼ tu le nagachiʼ dza niʼte quez, ");
INSERT INTO zarNT_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","tu didzaʼ chibiyönruʼ, en núnbëʼëruʼ, le gulë́ʼ xuz xtóʼoruʼ rëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Bitiʼ ucáchiʼruʼ didzaʼ naʼ lógacabiʼ zxíʼiniruʼ. Usiyönruʼ yuguʼ zxíʼini xiʼsóaruʼ yöl-laʼ ba queëʼ Xanruʼ, ca naca yöl-laʼ huáca queëʼ, en yuguʼ le zxön benëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Gudixjëʼ tu didzaʼ naca bëʼ queëʼ Jacob, en nuzóëʼ le rinná bëʼë quégaca bönachi Israel, le gunná béʼenëʼ yuguʼ xuz xtóʼoruʼ. Uluʼzéajniʼinëʼ zxíʼinigaquiëʼ ca naca, ");
INSERT INTO zarNT_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","para ilúnbëʼgacabiʼ le, biʼi siʼ záʼgacabiʼ, encaʼ biʼi siʼ iláljabiʼ, para uluʼluíʼibiʼ caʼ zxíʼinigacabiʼ ca naca lë naʼ gunná bëʼë Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Uluʼzxöni ládxiʼgacabiʼ Dios, en bitiʼ gal-la ládxiʼgacabiʼ yuguʼ le nunëʼ Dios. Ilunbiʼ ca nácagaca le gunná bëʼë, ");
INSERT INTO zarNT_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","en bitiʼ ilácagacabiʼ ca guláquiëʼ xuz xtóʼogacabiʼ. Guláquiëʼ zidzaj ladxiʼ tuʼ gulaʼdáʼbaguëʼë xtídzëʼë Dios, en bitiʼ guláquiëʼ nöxaj ladxiʼ, ateʼ lu icja ládxiʼdoʼgaquiëʼ bitiʼ gulaʼyéajlëʼë Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Yuguʼ zxíʼini xiʼsóëʼ Efraín guluáʼgaquiëʼ yaga uxitiʼ, pero buluʼzxúnnajëʼ lu gudil-la. ");
INSERT INTO zarNT_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Bitiʼ gulaʼdáʼgaquiëʼ didzaʼ dzaga Dios bénlenëʼ légaquiëʼ, en bitiʼ gulunëʼ ca naca le gunná béʼenëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Gulal-la ládxiʼgaquiëʼ yuguʼ le benëʼ Dios, en yuguʼ yöl-laʼ huáca zxön benëʼ lógaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Benëʼ Dios le gulún ga buluʼbáninëʼ xuz xtóʼogaquiëʼ luyú Egipto, en luyú Zoán. ");
INSERT INTO zarNT_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Gusaljëʼ nísadoʼ, en benëʼ ga gulaʼdödëʼ gatsaj láhuiʼlö nísadoʼ naʼ. Benëʼ ga guca nísadoʼ naʼ ca yuguʼ guíʼadoʼ tsöláʼa huéaj. ");
INSERT INTO zarNT_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Buluíʼinëʼ légaquiëʼ nöza lahuiʼ dza, bugunëʼ dxin tu böaj, ateʼ chiʼi dzö́ʼölö bugunëʼ dxin tu böaj ruzeníʼ ca guíʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Bulë́ʼë tu guiö́j ga naca laʼ guixiʼ ga dë lataj, en bëʼë le gulë́ʼajëʼ le guca ca tu nísadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Gulë́ʼajëʼ nisa yegu le gulén lu guiö́jtoʼo. Benëʼ ga birúaj nisa ca tu yegu zxön lu guiö́jtoʼo naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Laʼ níʼisö gulunëʼ dul-laʼ lahuëʼ Lëʼ, en gulaʼdáʼbaguëʼë Dios nayë́pisëtërëʼ laʼ guixiʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Lu icja ládxiʼdoʼgaquiëʼ gulaʼzíʼ bëʼë Dios quégaquiëʼ, cateʼ gulaʼnábinëʼ Lëʼ ugahuëʼ légaquiëʼ ca gulaʼzësö ládxiʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Níʼirö gulaʼnnë́ʼ queëʼ Dios, gulaʼnnë́ʼ: “¿Naruʼ huáca cuʼë Dios le gáguruʼ laʼ guixiʼ ni ga dë lataj? ");
INSERT INTO zarNT_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Buliʼyútsöcaʼ, bëʼë guiö́jtoʼo, ateʼ birúajdaʼ nisa, le guca ca nisa yegu gubóʼo zxön. ¿Naruʼ huáca gunnëʼ caʼ queë́ruʼ yöta gáguruʼ? ¿Naruʼ gaca ugahuëʼ bönachi queëʼ le naca bëlaʼ?” ");
INSERT INTO zarNT_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Biyönnëʼ Xanruʼ Dios didzaʼ ni, en gulédeʼenëʼ, ateʼ gulén tu guíʼ le buzegui zián zxíʼini xiʼsóëʼ Jacob, tuʼ gulédeʼenëʼ bönachi Israel, ");
INSERT INTO zarNT_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","tuʼ cabí gulaʼyéajlëʼë Dios, en bitiʼ buluʼzxöni ládxiʼgaquiëʼ Lëʼ usölë́ʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Gunná béʼenëʼ Lëʼ yuguʼ böaj lúzxiba, en gusaljëʼ yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","Gusö́l-lëʼë yöta maná le ilahuëʼ, en bugahuëʼ légaquiëʼ laʼ huagu que yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Gulahuëʼ bönniʼ niʼ yöta tahuëʼ gubáz que yehuaʼ yubá. Gusö́l-lëʼë guizxi yu le ilahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Benëʼ ga guyecja böʼ birúaj ga rilén gubidza, ateʼ len yöl-laʼ huáca queëʼ gunná béʼenëʼ böʼ recja le birúaj tsöláʼalö ga ridödi gubidza beoʼ ziaga. ");
INSERT INTO zarNT_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Benëʼ ga böxaj bëlaʼ ca bëchtö yu ládjalö ga naʼ nacuʼë, le naca böaʼ zoa xíligacabaʼ gurö́ʼöbaʼ ca yuzxi dë tu raʼ yegu zxön. ");
INSERT INTO zarNT_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Benëʼ ga bö́xjagacabaʼ gatsaj láhuiʼlö ga naʼ nacuʼë, en ládjagaca yuguʼ yuʼu guídidoʼ quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Caʼ guca, gulahuëʼ, en buluʼhuö́laj gulaʼdzéʼenëʼ, tuʼ bëʼë quégaquiëʼ le gulaʼzësö ládxiʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Zíʼalö ca budxi buluʼhuö́laj gulaʼdzéʼenëʼ, tsanni niʼ yuʼu ruáʼagaquiëʼ le tahuëʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","gulénëʼ Dios légaquiëʼ, en bë́tiëʼ bál-lagaquiëʼ, bönniʼ nál-latërögaquiëʼ ládjagaquiëʼ, en bucul-lëʼ bönniʼ Israel nayë́pisëtërögaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Sal-laʼ guca caní, gulunrëʼ dul-laʼ, en bitiʼ gulaʼyéajlëʼë Lëʼ niʼa quégaca le zxön benëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Que lë ni naʼ benëʼ ga böáca nítisö dxin gulunëʼ, ateʼ lu yöl-laʼ radxi gulaʼzóëʼ yuguʼ lu iz quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Cateʼ bë́tiëʼ ziángaquiëʼ, níʼirö buluʼlidzëʼ Lëʼ. Buluʼbíʼi ládxiʼgaquiëʼ, en yöjtáʼgaquiëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Níʼirö yöjnéguequinëʼ náquiëʼ Dios Nu run chiʼi légaquiëʼ, en náquiëʼ Dios nayë́pisëtërëʼ Nu böáʼuö légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Gulaʼzíʼ yéʼenëʼ Lëʼ len didzaʼ guluʼë, tuʼ guluʼë dizaʼ bitiʼ nácatë lahuëʼ Lëʼ len ruáʼagaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Bitiʼ gudáʼgaquiëʼ Lëʼ idú ládxiʼgaquiëʼ, en bitiʼ gulunëʼ ca rnna didzaʼ dzaga naʼ bénlenëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Tuʼ buéchiʼ ládxëʼë Dios légaquiëʼ, buniti lahuëʼ ca naca xiguiaʼ gulunëʼ, en bitiʼ busunítiëʼ légaquiëʼ. Bubequi lahuëʼ quégaquiëʼ, en bítiʼrö gulénëʼ légaquiëʼ, en bitiʼ benëʼ ca saʼyéaj yöl-laʼ ridzáʼa queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Caʼ guca, yöjnenëʼ nácagaquiëʼ bönáchisö. Nácagaquiëʼ ca tu böʼ recja le ridö́disö, en bitiʼ rudxín. ");
INSERT INTO zarNT_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Zián luzuí gulaʼdáʼbaguëʼë Lëʼ ga naʼ naca laʼ guixiʼ, en buluʼsuhuíʼinëʼ Lëʼ lu yu bidxi naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Zián luzuí gulaʼzíʼ bëʼë Dios, en gulunëʼ ziʼ Dios Láʼayi quégaca bönachi Israel. ");
INSERT INTO zarNT_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Bitiʼ yöjnéguequinëʼ yöl-laʼ huáca zxön queëʼ, le buluʼe lahui dza niʼ böáʼuëʼ légaquiëʼ lu náʼagaca nupa bitiʼ bilaʼléʼe légaquiëʼ dxiʼa, ");
INSERT INTO zarNT_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","cateʼ niʼ benëʼ le gulaca bëʼ luyú Egipto, en benëʼ yuguʼ yöl-laʼ huáca queëʼ luyú Zoán, ");
INSERT INTO zarNT_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","cateʼ benëʼ ga böáca nisa rön yuguʼ lu yegu luyú Egipto, encaʼ nisa yuguʼ lu beaj quégaquiëʼ para cabí guca ilë́ʼajëʼ le. ");
INSERT INTO zarNT_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Gusö́l-lëʼë ládjagaquiëʼ bö́tsugayu guizxi yu, böaʼ gulaʼguídxibaʼ légaquiëʼ. Gusö́l-lëʼë caʼ riu buluʼsunítibaʼ le nequi quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Budödëʼ le naz nuzóagaquiëʼ lu ruáʼagacabaʼ böchiʼ zu, ateʼ gulágubaʼ böchiʼ zu naʼ le röʼö yuguʼ laʼ yëla quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Busunítiëʼ yuguʼ lubá uva quégaquiëʼ len nisa guiö́j yöla sunna naʼ, en busunítiëʼ yuguʼ yaga higo quégaquiëʼ len böguiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Bë́tiëʼ-baʼ böaʼ-bëdxi quégaquiëʼ len nisa guiö́j yöla sunna naʼ, en lu yösa gulaʼyëpi. ");
INSERT INTO zarNT_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Lu yöl-laʼ rilé queëʼ gusö́l-lëʼë quégaquiëʼ yuguʼ lë ni, en lu yöl-laʼ ridzáʼa queëʼ busacaʼ ziʼë légaquiëʼ, en gusö́l-lëʼë quégaquiëʼ gubáz que yehuaʼ yubá para buluʼsunítiëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Bitiʼ bubequi lahuëʼ quégaquiëʼ para cabirö lenëʼ légaquiëʼ, en bitiʼ buniti lahuëʼ légaquiëʼ para cabí ilátiëʼ. Budödëʼ légaquiëʼ lu yöl-laʼ guti, ");
INSERT INTO zarNT_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","en bë́tiëʼ yúguʼtëbiʼ biʼi bönniʼ lo quégaquiëʼ bönniʼ Egipto, yuguʼ biʼi bönniʼ lo quégaquiëʼ zxíʼini xiʼsóëʼ Ham. ");
INSERT INTO zarNT_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Guchë́ʼë bönachi queëʼ ca yuguʼ böʼcuʼ zxílaʼdoʼ, en buluíʼinëʼ légaquiëʼ nöza laʼ guixiʼ ga dë lataj. ");
INSERT INTO zarNT_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Guchë́ʼë légaquiëʼ lu nëʼë para cabí bi iládxinëʼ, pero gubagaʼ nísadoʼ nupa bitiʼ bilaʼléʼe légaquiëʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Caʼ guca, guchë́ʼë légaquiëʼ ga zoa luyú láʼayi queëʼ, luyú ni bidéliʼnëʼ uláz quégaquiëʼ len yöl-laʼ huáca queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Buláguiʼë bönachi izáʼa luyú ni lógaca bönachi queëʼ, en burixëʼ que queë́gaquiëʼ xiyúgaquiëʼ ga ilaʼcuʼë, en benëʼ ga gulaʼcuʼë bönachi Israel yuguʼ lu yuʼu guídidoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Le yúbölö gulaʼzíʼ bëʼë Lëʼ, en gulaʼdáʼbaguëʼë Dios nayë́pisëtërëʼ, en bitiʼ gulunëʼ yuguʼ le gunná béʼenëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Buluʼhuö́a ládxiʼgaquiëʼ, en buluʼcáʼanëʼ Lëʼ ca gulunëʼ xuz xtóʼgaquiëʼ. Gulaʼdödëʼ tsöláʼalö ca run tu yaga lahui tuchiʼ bitiʼ nácatë li. ");
INSERT INTO zarNT_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Gulún lenëʼ Lëʼ tuʼ gulunëʼ xilátjagaca budóʼ guiö́j budóʼ yaga yuguʼ lu guíʼa, en gulunëʼ ga budúliʼnëʼ légaquiëʼ niʼa quégaca budóʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Cateʼ biléʼenëʼ lë ni Dios, gulédeʼenëʼ, en budíʼinëʼ bönachi Israel. ");
INSERT INTO zarNT_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Níʼirö bucáʼanëʼ xilatjëʼ lu yödzö Siló, ga naʼ guzóa yuʼu láʼayi queëʼ ládjagaquiëʼ bönniʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Bëʼë lataj gulaʼchë́ʼë bönniʼ ziʼtuʼ guíʼina láʼayi queëʼ, guíʼina naʼ buluíʼi lahui yöl-laʼ zxön queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Budödëʼ bönachi queëʼ lu náʼagaca nupa bë́tigaca léguequi, ");
INSERT INTO zarNT_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","en gúquinëʼ ziʼ nupa nácagaca quez queëʼ. Buzegui tu guíʼ zxön yuguʼ biʼi bönniʼ quégaquiëʼ, ateʼ cuntu nu bugáʼana nu uluʼtsaga naʼlenbiʼ yuguʼ biʼi nigula raʼbandoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Yuguʼ bixúz quégaquiëʼ gulátiëʼ lu guíë tuchiʼ, ateʼ bitiʼ guca ilaʼbö́dxinu nigula uzëbi quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Níʼirö gúquiëʼ Xanruʼ ca tu bönniʼ rubanëʼ lu yöl-laʼ rasi. Gúquiëʼ ca bönniʼ rejëʼ gudil-la gudödi bëʼë guʼë xisi lubá uva nál-la. ");
INSERT INTO zarNT_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Buláguiʼë yuguʼ bönniʼ gulaʼdíl-lalenëʼ bönachi queëʼ, en tsálidoʼos burixëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Lëscaʼ budödëʼ tsöláʼalö yuguʼ zxíʼini xiʼsóëʼ José, en bitiʼ gurö́ëʼ yuguʼ zxíʼini xiʼsóëʼ Efraín. ");
INSERT INTO zarNT_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Gurö́ëʼ yuguʼ zxíʼini xiʼsóëʼ Judá, en yödzö Sión le nadxíʼi quézinëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Niʼ benëʼ tu lataj láʼayi queëʼ le naca ca tu guíʼa zxön, le zoa tsutsu ca yödzölió ni nuzóëʼ tsaz. ");
INSERT INTO zarNT_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Gurö́ëʼ caʼ David, huen dxin queëʼ, en bubéajëʼ lëʼ ga naʼ zoëʼ ruyúëʼ-baʼ yuguʼ böʼcuʼ zxílaʼdoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Bubéajëʼ lëʼ ga naʼ rapa chiʼë-baʼ yuguʼ böʼcuʼ zxilaʼ gunáʼ, nacuáʼabaʼ böaʼ huë́ʼënidoʼ quégacabaʼ, para gáquiëʼ nu uyú bönachi queëʼ, yuguʼ zxíʼini xiʼsóëʼ Jacob, en bönachi Israel, nupa naʼ nácagaca quez queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Caʼ guca, idú ládxëʼë buyúëʼ David bönachi naʼ, en lu yöl-laʼ rácadaʼ queëʼ guchë́ʼë légaquiëʼ lu nëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Dios, nacuáʼ bönachi izáʼa lu xiyúgaca bönachi quiuʼ. Nucáʼanagaca cáʼasö yudoʼ láʼayi quiuʼ, en nusunítigaca yödzö Jerusalén. ");
INSERT INTO zarNT_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Buluʼcáʼanëʼ bönachi quiuʼ nátigaca luyú para ilágubaʼ bíchulab léguequi, en bëlaʼ rön quégaca huen xichinuʼ ga ilágubaʼ böaʼ guixiʼ le. ");
INSERT INTO zarNT_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Buluʼlaljëʼ xichö́ngaca bönachi quiuʼ ca nisa idútë lu yödzö Jerusalén, ateʼ cuntu nu bugáʼana nu ucacheʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Bönachi yuguʼ dzaga luyú queë́tuʼ tuʼtitaj netuʼ. Tuʼzxidxëʼ, en tuʼdidzaʼ yudxi netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","¿Naruʼ tsaz ilenuʼ netuʼ, Xan? ¿Naruʼ sóaticaʼsö yöl-laʼ rilé quiuʼ ca tu guíʼ ruzegui netuʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Gulégaca bönachi yuguʼ yödzö ziʼtuʼ bitiʼ tun Liʼ bal, encaʼ bönachi bitiʼ tuʼlidza Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Bë́tigaca bönachi quiuʼ nácagaca zxíʼini xiʼsóëʼ Jacob, en nusunítigaca xiyutuʼ ga zoa cazuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Bitiʼ gunuʼ netuʼ xiguiaʼ tuʼ nözi dul-laʼ gulunëʼ xuz xtóʼotuʼ. Buéchiʼ ladxiʼ netuʼ naʼa, tuʼ rudú ládxiʼtuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Gúcalen netuʼ, Dios, Nu rusölá netuʼ, para guntuʼ bal Loʼ. Busölá netuʼ, en buniti lo netuʼ ca naca dul-laʼ nabágaʼtuʼ para idxíʼituʼ Loʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","¿Bizx que taʼnabi bönachi yuguʼ yödzö izáʼa netuʼ, taʼnná: “Gázxitë zoa Dios queë́liʼ”? Bëʼ lataj iléʼetuʼ, en ben ga gaca bëʼ lógaca yúguʼtë bönachi rizíʼ loʼ nupa tuʼlalaj xichö́ngaca huen xichinuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Buzë́ naguʼ ca taʼnnë́ ládxiʼgaca nupa nadzúngaca. Len yöl-laʼ huáca zxön quiuʼ busölá nupa naʼ narugu quéguequi ilátigaca, ");
INSERT INTO zarNT_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","en bubíʼi quégaca bönachi yuguʼ dzaga yödzö queë́tuʼ iaʼgadxi cöʼlö caʼ tsca naca didzaʼ ziʼ gulaʼnnë́ quiuʼ Liʼ, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Netuʼ, bönachi quiuʼ, encaʼ böʼcuʼ zxilaʼ ruyú cazuʼ Liʼ, guíëticaʼstuʼ Liʼ: “Xclenuʼ”, en cúʼuticaʼstuʼ Liʼ yöl-laʼ ba naʼa dza, en dza siʼ zaca. ");
INSERT INTO zarNT_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Ruzë́ naguʼ netuʼ, Dios, Nu rapa chiʼi bönachi Israel. Nacuʼ Nu ruyú yuguʼ zxíʼini xiʼsóëʼ José ca nu ruyú yuguʼ böʼcuʼ zxilaʼ. Buzeníʼ queë́tuʼ, Liʼ naʼ röʼu rinná bëʼu ga nacuáʼ nupa nál-lágacatërö quiuʼ lë́gaca querubín. ");
INSERT INTO zarNT_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Buluíʼi yöl-laʼ huáca quiuʼ lógaca zxíʼini xiʼsóagaquiëʼ Efraín, en Benjamín, en Manasés. Gudá queë́tuʼ, en busölá netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Ben ga huécjatuʼ quiuʼ Liʼ, Dios. Buluíʼi netuʼ nadxíʼinuʼ netuʼ, ateʼ ulatuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Xantuʼ Dios quéguequi niʼa noʼo guizxi yu, ¿gácaʼxte caz ilenuʼ netuʼ, en bitiʼ yönnuʼ le rulidztuʼ Liʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Rugaguʼ netuʼ nisa ribödxi queë́tuʼ, en ruguiʼjuʼ netuʼ sizxöni nisa ribödxi. ");
INSERT INTO zarNT_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Nunuʼ ga bönachi dzaga yödzö queë́tuʼ tuʼzxidxi queë́tuʼ, ateʼ nupa bitiʼ taʼléʼe netuʼ dxiʼa tuʼtitaj netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Ben ga huécjatuʼ quiuʼ Liʼ, Dios quégaca niʼa noʼo guizxi yu. Buluíʼi netuʼ nadxíʼinuʼ netuʼ, ateʼ ulatuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Guléajuʼ tu lubá uva le nácatuʼ netuʼ luyú Egipto. Bulaguʼ bönachi izáʼa yuguʼ lu yödzö luyú ni, en budóʼo lubá naʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Buchiʼu lataj ga guzxö́n lubá naʼ. Benuʼ ga ben luí ga rëʼ, ateʼ bulí idútë luyú ni. ");
INSERT INTO zarNT_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Gulúʼu zxul-la lubá naʼ yúguʼtë lu guíʼadoʼ, ateʼ niʼa nëʼe gulaʼbagaʼ yuguʼ guíʼa zxön. ");
INSERT INTO zarNT_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Gulaʼtunna niʼa nëʼe ga bidxintë raʼ nísadoʼ, encaʼ ga bidxintë raʼ yegu Eufrates. ");
INSERT INTO zarNT_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","¿Bizx que buquínnajuʼ yuguʼ lëʼaj gulún chiʼi lubá naʼ, en ruʼu lataj nupa taʼdö́disö taʼbán le ribía lubá uva naʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Tuʼlíbigacabaʼ cuchi guixiʼ le, ateʼ tágubaʼ böaʼ guixiʼ le. ");
INSERT INTO zarNT_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Buécja queë́tuʼ, Dios quégaca niʼa noʼo guizxi yu. Ga niʼ zuʼ yehuaʼ yubá buyú ca raca que lubá quiuʼ, en busölá netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Gudá dusölóʼ lubá ni budáʼ cazuʼ, le naca ca tu lubá huë́ʼëni buxö́n cazuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Nupa bitiʼ taʼléʼe netuʼ dxiʼa gulaʼchugu niʼa nëʼe lubá naʼ, en buluʼquelaʼ le guíʼ. Buyú ca tun, en lu yöl-laʼ rilé quiuʼ busuniti léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Gúcalen bönniʼ naʼ gurö́ cazuʼ quiuʼ, netuʼ, bönachi naʼ nuzóa cazuʼ tsaz quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Caní gaca, bítiʼrö ucáʼanatuʼ Liʼ. Bunna queë́tuʼ yöl-laʼ naʼbán, ateʼ uzxöni ládxiʼtuʼ Loʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Ben ga huécjatuʼ quiuʼ Liʼ, Dios quégaca niʼa noʼo guizxi yu. Buluíʼi netuʼ nadxíʼinuʼ netuʼ, ateʼ ulatuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Lu yöl-laʼ rudzeja queë́liʼ guliʼgul-la queëʼ Dios. Lëʼ náquiëʼ yöl-laʼ nál-la queë́liʼ. Lu yöl-laʼ rudzeja queë́liʼ guliʼcö́dxiʼa lahuëʼ Dios queëʼ Jacob. ");
INSERT INTO zarNT_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Guliʼgul-la tu le gúl-laliʼ, cápaʼliʼ lëʼe guídidoʼ. Guliʼquinnaj lë́ʼegaca bihuël-la. ");
INSERT INTO zarNT_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Guliʼcödxi luzu chivo cateʼ zoa beoʼ huë́ʼëni, en cateʼ zoa beoʼ nál-la, en cateʼ raca laní. ");
INSERT INTO zarNT_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Lë ni naca tu xibá quégaca bönachi Israel, le naca tu le gunná béʼenëʼ Xanruʼ Dios zxíʼini xiʼsóëʼ Jacob. ");
INSERT INTO zarNT_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Gudixjëʼ le para gaca tu le gun ba nalí queëʼ lógaca zxíʼini xiʼsóëʼ José, le gudixjëʼ cateʼ gudödëʼ luyú Egipto, ga niʼ biyöndaʼ didzaʼ izáʼa bitiʼ guyéajniʼidaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Rnnëʼ Dios: “Gudúaʼ yuaʼ zxoa yaʼzxícjagaquiëʼ, en bucuitaʼ le nuáʼgaquiëʼ le buluʼsubagaʼ légaquiëʼ nupa bitiʼ bilaʼléʼe légaquiëʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Bulídzaliʼ nedaʼ cateʼ bi guca queë́liʼ, ateʼ busöláʼ libíʼiliʼ. Bubiʼa didzaʼ cateʼ bi gunábiliʼ nedaʼ, niʼ nucachiʼ cuinaʼ tu lu böaj gasaj. Guzxíʼ bëʼa libíʼiliʼ ga zoa nisa naʼ lë Meriba. ");
INSERT INTO zarNT_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Buliʼzë́ nágaliʼ, libíʼiliʼ, bönachi quiaʼ, ateʼ uxösaʼ libíʼiliʼ. Raca ládxaʼa uzë́ nágaliʼ nedaʼ, bönachi Israel. ");
INSERT INTO zarNT_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Bitiʼ ral-laʼ soa tu dios izáʼa ga naʼ zóaliʼ, en bitiʼ gunliʼ zxön tu dios quégaca bönachi ziʼtuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Nedaʼ, Xanliʼ, nacaʼ Dios queë́liʼ. Guléajaʼ libíʼiliʼ luyú Egipto. Guliʼsalaj ruáʼaliʼ, ateʼ cuʼa ruáʼaliʼ le gáguliʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Bitiʼ buluʼzë́ nágagaca bönachi quiaʼ chiʼa. Bitiʼ gulún bönachi Israel ca rnna xtídzaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Que lë ni naʼ busán ládxaʼa léguequi para gulún ca saʼyéaj yöl-laʼ ridáʼbagaʼ quéguequi, en para gulún ca gulaʼzaʼsö ládxiʼgaca. ");
INSERT INTO zarNT_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Guzáʼ ládxaʼa uluʼzë́ nágagaca bönachi quiaʼ xtídzaʼa, para ilún bönachi Israel ca rë́ʼëndaʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Laʼtuʼ ilún caní, uxicja cazaʼ nupa bitiʼ taʼléʼe léguequi dxiʼa, en tíl-lalenaʼ nupa taʼdíl-lalen léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Uluʼluíʼi cuínguequi nupa bitiʼ taʼléʼe nedaʼ dxiʼa, ca nupa tun ca rnna xtídzaʼa, pero tsaz gunaʼ léguequi xiguiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Lëscaʼ ugahuaʼ libíʼiliʼ, bönachi quiaʼ, zxoaʼ xtila dxíʼadoʼ, en gunaʼ ga huölaj idzéʼeliʼ le zxixi que buz, le irúaj lëʼe guiö́j.” ");
INSERT INTO zarNT_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Zuínëʼ Dios ladaj nupa tuʼdubi queëʼ niʼ yehuaʼ yubá. Ruchiʼa rusörö́ëʼ nupa taʼnná bëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Rnnëʼ: “¿Gácaʼxte caz uchiʼa usörö́liʼ quégaca bönachi lu yöl-laʼ bitiʼ naca tsahuiʼ queë́liʼ? Caní naca tuʼ rubéajliʼ tsahuiʼ nupa tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Buliʼbéaj tsahuiʼ nupa taʼcuidiʼ, en yuguʼ biʼi uzëbi. Guliʼgún le naca tsahuiʼ quégaca nupa taʼguíʼi taʼzacaʼ, en quégaca nupa taʼyadzaj taʼyudxi. ");
INSERT INTO zarNT_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Buliʼsölá nupa taʼcuidiʼ, en nupa nácagaca yechiʼ. Buliʼsölá léguequi lu náʼagaca nupa tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Bitiʼ nö́ziguequi, en bitiʼ taʼyéajniʼi. Taʼdá ga chul-la. Rizxizi xilibi yödzölió.” ");
INSERT INTO zarNT_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Rnna cazaʼ nedaʼ: “Nácaliʼ ca yuguʼ dios. Nácaliʼ yúguʼtëliʼ zxíʼinëʼ Dios nayë́pisëtërëʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","pero gátiliʼ ca tati bönachi, en ibíxiliʼ lu gudil-la ca taʼbixi zxíʼinëʼ bönniʼ lo.” ");
INSERT INTO zarNT_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Guyasa, Dios, en buchiʼa busörö́ quégaca bönachi yödzölió ni, tuʼ nácagaca queë cazuʼ yúguʼtë yödzö bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Bitiʼ ugáʼanuʼ dxisö, Dios. Bitiʼ suʼ dxisö, Dios, en bitiʼ usayaj ruʼu, ");
INSERT INTO zarNT_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","tuʼ tuʼtsatsa nupa taʼdáʼbagaʼ Liʼ, ateʼ nupa bitiʼ taʼléʼe Liʼ dxiʼa tun ba zxön cuínguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Tun tuz xtídzaʼguequi bi ilún quégaca bönachi queë cazuʼ, en tuʼpá yuguʼ le ilún quégaca nupa nadxíʼi quézinuʼ, taʼnná: ");
INSERT INTO zarNT_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","“Guliʼdá, usunítiruʼ léguequi para cabirö ilaca tu yödzö bönachi, en para cúnturö nu tsöjné bönachi Israel.” ");
INSERT INTO zarNT_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Núngaca tuz xtídzaʼguequi. Nuzóagaca tsutsu xtídzaʼguequi taʼdáʼbagaʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Yuguʼ bönniʼ Edom, en yuguʼ bönniʼ Ismael, en yuguʼ bönniʼ Moab, en yuguʼ bönniʼ Agar, ");
INSERT INTO zarNT_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","en yuguʼ bönniʼ Gebal, en yuguʼ bönniʼ Amón, en yuguʼ bönniʼ Amalec, en yuguʼ bönniʼ Filisteo, en yuguʼ bönniʼ Tiro, ");
INSERT INTO zarNT_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","encaʼ yuguʼ bönniʼ Asiria núngaquiëʼ légaquiëʼ tsözxö́n. Rácalengaquiëʼ yuguʼ bönniʼ zxíʼini xiʼsóëʼ Lot. ");
INSERT INTO zarNT_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Ben quégaquiëʼ ca benuʼ quégaca bönachi Madián, nupa naʼ busunítiuʼ dërö, en ca naʼ benuʼ queëʼ Sísara, en ca naʼ benuʼ queëʼ Jabín raʼ yegu Cisón, ");
INSERT INTO zarNT_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","nupa naʼ busunítiuʼ lu yödzö Endor, ateʼ gulaca ca xiquë́ʼëbaʼ bëdxi luyú niʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Ben quégaquiëʼ bönniʼ lo quéguequi ca benuʼ quégaquiëʼ Oreb, en Zeb, en ben quégaquiëʼ bönniʼ taʼnná béʼenëʼ léguequi ca benuʼ quégaquiëʼ Zeba, en Zalmuna, ");
INSERT INTO zarNT_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","nupa naʼ gulaʼnná: “Ilequi queë́ruʼ yuguʼ lataj gapa naʼ gulequi queëʼ Dios.” ");
INSERT INTO zarNT_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Dios quiaʼ, ben ga ilácagaquiëʼ ca bëchtö yu le richë́ʼ böʼ, en ca bëbu zxe café le ruáʼ böʼ budunuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Ca run tu guíʼ zxön, ruzeguiʼ yuguʼ yaga zxön, o ca run tu guíʼ, ruzeguiʼ tu guíʼa zxön, ");
INSERT INTO zarNT_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","gusí reguʼ léguequi tu lu böʼ budunuʼ, en ben gadxi léguequi tu lu nisa guiö́jsiuʼ zili. ");
INSERT INTO zarNT_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","Ben ga uluʼtuíʼi para uluʼguilaj Liʼ, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Ben ga uluʼtuíʼi, en ilaʼbö́ʼ tsaz böniga. Ben ga uluʼgáʼana cáʼasö, en tsaz ilaʼniti, ");
INSERT INTO zarNT_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","para iléquibeʼe nayë́pisëtëruʼ tuzuʼ Liʼ idútë yödzölió en uluʼzóa zxíbiguequi loʼ, Xantuʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","¡Bicaʼ lachi gapa zoa cazuʼ Liʼ, Dios! ¡Nacuʼ Xángaca niʼa noʼo guizxi yu! ");
INSERT INTO zarNT_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Rizë́ ládxaʼa soaʼ lu yuʼu lidxuʼ, Xanaʼ Dios. Lu yöl-laʼ rudzeja quiaʼ idú ládxaʼa rul-laʼ quiuʼ Liʼ, Dios ban. ");
INSERT INTO zarNT_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Bidzö́libaʼ biguínni chulíʼ lataj ga nuzóabaʼ lídxibaʼ, en bidzö́libaʼ xiguichi guziúʼ ga budxíabaʼ xicáʼabaʼ, ga naʼ rigúʼubaʼ biguínnidoʼ queë́baʼ, galaʼ ga dë lu bucugu quiuʼ Liʼ, Xángaca niʼa noʼo guizxi yu. Nacuʼ Nu rinná beʼe nedaʼ, en nacuʼ caʼ Dios quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","¡Bicaʼ ba nupa taʼyaza lu yuʼu lidxuʼ! ¡Taʼgúʼuticaʼsö Liʼ yöl-laʼ ba! ");
INSERT INTO zarNT_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","¡Bicaʼ ba bönniʼ nápagaquiëʼ yöl-laʼ nál-la le nequi queë cazuʼ, en taʼzë́ ládxiʼgaquiëʼ ilaʼyuʼë nöza le ridxín yödzö Sión! ");
INSERT INTO zarNT_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Cateʼ taʼdödëʼ lu yu bidxi tunëʼ ga ruhuöáca gapa ralaj nisa beaj. Tun ga rizíʼ xibé yu bidxi naʼ yuguʼ nisa guiö́j taʼdxín bayö́n. ");
INSERT INTO zarNT_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Lu yöl-laʼ huáca quégaquiëʼ röjáquiëʼ, en tuʼzíʼrönëʼ yöl-laʼ huáca. Taʼdxinëʼ yúguʼtëgaquiëʼ loʼ Liʼ, Dios, lu yödzö Sión. ");
INSERT INTO zarNT_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Ruzë́ naguʼ le rulidzaʼ Liʼ, Dios, Xángaca niʼa noʼo guizxi yu. Ruzë́ naguʼ nedaʼ, Dios queëʼ Jacob. ");
INSERT INTO zarNT_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Buyúëʼ bönniʼ rinná béʼenëʼ netuʼ, Dios. Buyúëʼ bönniʼ naʼ nabö́ cazuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Nácarö dxiʼa soaʼ tu dza lu yuʼu lidxuʼ ca le soaʼ idú chi gayuáʼ dza ga yúbölö. Cö́aʼ zíʼalö gacaʼ huen dxin ga nu riyaza yuʼu lidxëʼ Dios ca le soa cazaʼ tu yuʼu zxön ga bitiʼ zoa Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Náquiëʼ Xanruʼ Dios ca gubidza, en le rusubín rëʼu. Xanruʼ caz runnëʼ queë́ruʼ yöl-laʼ ruzáʼ ladxiʼ queëʼ, en yöl-laʼ zxön queëʼ. Bitiʼ ugǘëʼ nitú le naca dxiʼa gapa nacuáʼ nupa tun le naca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","¡Liʼ, Xángaca niʼa noʼo guizxi yu, bicaʼ ba bönniʼ ruzxöni ládxëʼë Liʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Buzáʼ ládxuʼu quégaca bönachi quiuʼ, Xantuʼ Dios. Buchëʼu Liʼ zxíʼini xiʼsóëʼ Jacob gulaʼdzunëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Buniti loʼ bönachi quiuʼ ca naca xiguiaʼ gulaʼbagaʼ. Bucáchuʼu yuguʼ dul-laʼ gulúngaca. ");
INSERT INTO zarNT_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Buzóa dxíuʼ yöl-laʼ rilé quiuʼ. Bugúʼ yöl-laʼ ridzáʼa quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Buzóa netuʼ xilátjatuʼ le yúbölö, Dios, Nu rusölá netuʼ, en bítiʼrö lenuʼ netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","¿Naruʼ tsaz ilenuʼ netuʼ? ¿Naruʼ tsaz ilenuʼ yuguʼ zxíʼini xsoatuʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","¿Naruʼ cabí usubanuʼ ládxiʼtuʼ le yúbölö, para udzeja ládxiʼlentuʼ Liʼ netuʼ, bönachi quiuʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Lu yöl-laʼ dxiʼi ladxiʼ quiuʼ gúcalen netuʼ, en busölá netuʼ, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Uzë́ nagaʼ didzaʼ guʼë Xanruʼ Dios. Le guíëʼ bönachi queëʼ gun ga gaca dxiʼa quéguequi, nupa naʼ nácagaca quez queëʼ, pero run bayúdx bitiʼ uluʼhuö́a ládxiʼgaca. ");
INSERT INTO zarNT_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Le nácatë chizóëʼ usölë́ʼ nupa tun Lëʼ bal, para soa yöl-laʼ ba queëʼ luyú queë́tuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Dzágagaca yöl-laʼ dxiʼi ladxiʼ, en le naca idútë li. Tagu zxixi luzë́ʼeguequi nu naca tsahuiʼ, en nu riböza dxiʼa tsáhuiʼdoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Luyú caz rilén le naca idútë li, ateʼ yehuaʼ yubá rirúaj le naca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Le nácatë Xanruʼ unödzjëʼ queë́ruʼ le naca dxiʼa, ateʼ xiyuruʼ unödzaj le uláparuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Le naca tsahuiʼ röjnöru lahuëʼ Xanruʼ, en gun ga soa nöza gátiʼtës ga ulibëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Ruzë́ naguʼ, Xanaʼ Dios, en rubíʼu didzaʼ, tuʼ zoa nu rusacaʼ ziʼ nedaʼ, ateʼ riyadzaj riyúdxidaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Ben chiʼi böʼ naca cazaʼ, Dios, tuʼ nacaʼ quiuʼ Liʼ. Busölá nedaʼ, huen dxin quiuʼ, Dios quiaʼ, tuʼ ruzxöni ládxaʼa Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Buzáʼ ladxiʼ quiaʼ, Xan, tuʼ rulidzaʼ Liʼ idú dza. ");
INSERT INTO zarNT_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Ben ga udzeja ládxaʼa nedaʼ, huen dxin quiuʼ, tuʼ riguʼa lu noʼo böʼ naca cazaʼ, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Nacuʼ dxiʼa, Xan, en chizúʼ uniti loʼ bönachi quiuʼ. Nadxíʼiticaʼsuʼ yúguʼtë nupa tuʼlidza Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Ruzë́ naguʼ le rulidzaʼ Liʼ, Xan, en ruíʼi ládxuʼu gunuʼ yuguʼ le inábidaʼ loʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Cateʼ bi gaca quiaʼ ulidzaʼ Liʼ, tuʼ ubíʼi cazuʼ didzaʼ bi gunuʼ quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Cúnturö nu zoa ládjagaca dios nu naca ca nacuʼ Liʼ, Xan, en bitiʼ zoa iaʼtú nu run ca nácagaca le runuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Ilaʼdxín bönachi yúguʼtë yödzö naguixjuʼ Liʼ, Xanaʼ Dios, en ilaʼyéaj ládxiʼgaca Liʼ, en ilún zxön Loʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Nayë́pisëtërösuʼ Liʼ, en tuzuʼ Liʼ runuʼ yuguʼ yöl-laʼ huáca zxön. Tuzuʼ Liʼ nacuʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Busëdi nedaʼ ca naca le rë́ʼënuʼ gunaʼ, Xan. Gunaʼ ca naca le naca idútë li naguixjuʼ Liʼ. Ben ga gádxidaʼ Loʼ idú ládxaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Idú ládxaʼa guíaʼ Liʼ: “Xclenuʼ”, Xanaʼ Dios, en gunaʼ zxön Loʼ yuguʼ iz siʼ zaca. ");
INSERT INTO zarNT_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Nadxíʼideʼenuʼ nedaʼ, en chibusölóʼ böʼ naca cazaʼ lu lataj chul-la ga nacuáʼ nupa chinátigaca. ");
INSERT INTO zarNT_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Dios quiaʼ, nupa taʼdáʼbagaʼ nedaʼ taʼdíl-lalen nedaʼ, ateʼ yuguʼ bönniʼ zidzaj ladxiʼ të́ʼënëʼ ilútiëʼ nedaʼ, yuguʼ bönniʼ naʼ bitiʼ tunëʼ Liʼ bal. ");
INSERT INTO zarNT_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Nacuʼ Dios ruhuéchiʼ ládxuʼu netuʼ, Xan, en ruzáʼ ládxuʼu queë́tuʼ. Ridzenuʼ para ilenuʼ netuʼ, en nadxíʼideʼenuʼ netuʼ, en runuʼ ca rnna xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Buyú nedaʼ, en buzáʼ ladxiʼ quiaʼ. Butipa ládxaʼa nedaʼ, huen dxin quiuʼ, en busölá nedaʼ, zxíʼininu nigula huen dxin quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Buluíʼi nedaʼ tu le gaca bëʼ gaca dxiʼa quiaʼ, para ilaʼléʼe le nupa bitiʼ taʼléʼe nedaʼ dxiʼa. Uluʼtuíʼi, tuʼ gúcalenuʼ nedaʼ, en buë tsahúʼu nedaʼ, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Nuzóëʼ Dios xilibi zöʼö que yödzö queëʼ lu guíʼa láʼayi. ");
INSERT INTO zarNT_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Nadxíʼirönëʼ Xanruʼ lataj ga naʼ tuʼchiʼa tuʼsörö́ bönachi Sión ca nadxíʼinëʼ iaʼzícaʼrö lataj gapa nacuáʼ bönachi Israel. ");
INSERT INTO zarNT_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Zián le lachi taʼnná bönachi ca naca yödz naʼ nequi queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Cateʼ ulidzaʼ bönachi núnbëʼgaca nedaʼ, Dios, ulidzaʼ bönachi nnítaʼgaca Egipto, en Babilonia. Ca naca quégaca bönachi Filistea, en Tiro, en Etiopía inníaʼ nabábagaca yödzö láʼayi naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Cateʼ guʼa didzaʼ que yödzö Sión inníaʼ: Bönachi ni, en bönachi izáʼa ni nabábagaca le, ateʼ nedaʼ, Dios nayë́pisëtërëʼ, uzóaʼ tsutsu yödzö naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Cateʼ ulabëʼ Xanruʼ nupa nácagaca queëʼ innë́ʼ: “Bönniʼ ni nababëʼ yödzö quiaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Níʼirö iluíʼi didzaʼ nupa tul-la, en nupa tuʼcödxi gui, ilaʼná: “Ruzíʼituʼ xibé tuzi yödzö ni.” ");
INSERT INTO zarNT_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Xanaʼ Dios, Nu rusölá nedaʼ, rulidzaʼ Liʼ rëla, en te dza. ");
INSERT INTO zarNT_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Bëʼ lataj idxín loʼ le rulidzaʼ Liʼ. Ruzë́ naguʼ le rinaba yúdxidaʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Ruúbi ruguíʼi ládxiʼdaʼahuaʼ, en chizóa tsöjtsáziaʼ lataj chul-la. ");
INSERT INTO zarNT_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Chinabábalenaʼ nupa chinátigaca. Nacaʼ ca tu bönniʼ nudú dërö ládxëʼë, ");
INSERT INTO zarNT_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","en nagáʼanëʼ cáʼasö ladaj nupa chinátigaca, en ca nupa dë́gaca yeru ba, nupa naʼ bítiʼrö röjnenuʼ, en nusán noʼo léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Nuzúʼ nedaʼ tu lu yeru zila, ga naca chul-la, en le nácadaʼ zila. ");
INSERT INTO zarNT_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Rilenuʼ nedaʼ, en rusacaʼ ziʼu nedaʼ tu lu nísadoʼ quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Nucuásuʼ yúguʼtë nupa núnbëʼa. Nunuʼ nedaʼ ca tu le taʼguti bönachi. Nadzunaʼ, en bitiʼ gaca irúajaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Tuʼ riguíʼi rizácaʼa nudú guiö́j lahuaʼ. Tu dza tu dza rulidzaʼ Liʼ, Xan. Richisa naʼa zacaʼ ga naʼ zuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","¿Naruʼ guntsoʼ yuguʼ yöl-laʼ huáca zxön para gácalenuʼ nupa chinátigaca? ¿Naruʼ uluʼyasa nupa yúʼugaca lataj chul-la, en ilaʼgúʼu Liʼ yöl-laʼ ba? ");
INSERT INTO zarNT_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","¿Naruʼ uluʼluíʼi lahui yöl-laʼ dxiʼi ladxiʼ quiuʼ nupa nagáchiʼgaca yeru ba? ¿Naruʼ uluʼluíʼi lahui nupa yúʼugaca lataj chul-la ca runuʼ ca rnna xtídzuʼu? ");
INSERT INTO zarNT_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","¿Naruʼ gaca bëʼ le zxön runuʼ ga naʼ naca chul-la? ¿Naruʼ gaca bëʼ nacuʼ tsahuiʼ ga naʼ cuntu nu bi röjné? ");
INSERT INTO zarNT_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Rulidzaʼ Liʼ nedaʼ para gácalenuʼ nedaʼ, ateʼ yuguʼ zila ridxín loʼ le rinábidaʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","¿Bizx que nusán ládxuʼu nedaʼ, Xan? ¿Bizx que rucachiʼ loʼ lahuaʼ nedaʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Riguíʼi rizácaʼa, en chizóa gátiaʼ ga gudelaʼ nacaʼ bíʼidoʼ. Réquidaʼ ziʼ tuʼ ruxösuʼ nedaʼ, en rudú ládxaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Nabágaʼa nedaʼ yöl-laʼ rilé quiuʼ, ateʼ chizóa usuniti nedaʼ le ruxösuʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Idú dza naca quiaʼ ca nabagaʼ nedaʼ nisa. Nagúʼugaca nedaʼ lë́ʼajlö yuguʼ nisa. ");
INSERT INTO zarNT_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Nucuásuʼ ga zoaʼ nu nadxíʼi nedaʼ, encaʼ luzáʼa. Zóalensö le naca chul-la nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Gúl-laticaʼsaʼ ca naca yöl-laʼ dxiʼi ladxiʼ quiuʼ, Xan. Usiyöndaʼ zxíʼini xsoatuʼ ca runuʼ ca rnna xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Gunníaʼ: “Sóaticaʼsö yöl-laʼ dxiʼi ladxiʼ quiuʼ. Tsaz naca bëʼ yehuaʼ yubá ca runuʼ ca rnna xtídzuʼu.” ");
INSERT INTO zarNT_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Rnnëʼ Dios: “Naguixjaʼ tsaz didzaʼ dzaga núnlenaʼ nupa nabö́ cazaʼ quiaʼ. Benaʼ tsutsu xtídzaʼa ca gunaʼ queëʼ David, huen dxin quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","Gunníaʼ: Ucuáʼa tsaz zxíʼini xiʼsúʼ. Gunaʼ ga sóaticaʼsö nu inná bëʼ uláz quiuʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Nupa nacuáʼ yehuaʼ yubá quiuʼ ilaʼgúʼu yöl-laʼ ba le nunuʼ le tun ga rubánituʼ, Xan. Ga nudúbigaca nupa nácagaca quez quiuʼ ilaʼgúʼu yöl-laʼ ba ca runuʼ ca rnna xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","¿Nuzxi caz zoa niʼ yehuaʼ yubá naca ca nacuʼ Liʼ, Xan? ¿Nuzxi caz zoa ladaj nupa nayë́pisëgaca naca ca nacuʼ Liʼ, Xan? ");
INSERT INTO zarNT_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Nupa nácagaca láʼayi tun Liʼ bal, Dios. Ral-laʼ gúnröruʼ Liʼ bal ca tun nupa nacuáʼlen Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Dios, Xángaca niʼa noʼo guizxi yu, ¿nuzxi caz naca ca nacuʼ Liʼ, Xantuʼ nayë́pisëtëröuʼ? Naca bëʼ rúnticaʼsuʼ ca rnna xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Rinná beʼe quézinuʼ le riyasa ridxía que nísadoʼ. Cateʼ riyasa ridxía nísadoʼ, ruzóa cazuʼ le dxisö. ");
INSERT INTO zarNT_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Busuniti cazuʼ bönachi Egipto, ateʼ gulaca ca nupa chinátigaca. Bësilásiuʼ léguequi len noʼo nál-la. ");
INSERT INTO zarNT_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Nequi quiuʼ yehuaʼ yubá, en nequi caʼ quiuʼ luyú ni, tuʼ nuzóa cazuʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Naguixaj cazuʼ le dë tsöláʼa ga zaʼ böʼ ziaga, en le dë tsöláʼa ga ridödi gubidza beoʼ ziaga. Lu yöl-laʼ rudzeja quéguequi taʼbö́dxiʼa guíʼa Tabor, en guíʼa Hermón cateʼ taʼyöni Loʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","¡Nál-latërö naca noʼo! ¡Nápatërö noʼo yöl-laʼ huáca! ¡Nayë́pisëtërö noʼo ibëla! ");
INSERT INTO zarNT_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Le naca dxiʼa, en le naca tsahuiʼ tun tsutsu le rinná bëʼu. Nacuáʼlen Liʼ yöl-laʼ dxiʼi ladxiʼ, en le naca idútë li. ");
INSERT INTO zarNT_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Bicaʼ bágaca nupa taʼyöni didzaʼ que yöl-laʼ rudzeja. Taʼdá lu beníʼ que loʼ, Xantuʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Idú dza tuʼdzeja tuʼ zóalen Loʼ léguequi, en tuʼ zóalen léguequi le naca tsahuiʼ quiuʼ, le nayë́pisëtërö. ");
INSERT INTO zarNT_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Naca cazuʼ Liʼ yöl-laʼ zxön que yöl-laʼ huáca quéguequi, en tuʼ ruzáʼ ládxuʼu queë́tuʼ nazxöndaʼ yöl-laʼ nál-la queë́tuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Nequi queëʼ Xanruʼ le run chiʼi rëʼu, ateʼ néquinëʼ queëʼ Dios bönniʼ rinná béʼenëʼ rëʼu. Dios naʼ náquiëʼ láʼayi ladaj bönachi Israel. ");
INSERT INTO zarNT_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Dza niʼte bë́ʼlenuʼ nupa néquiguequi quiuʼ didzaʼ lu yuguʼ le buluíʼinuʼ léguequi, gunnóʼ: “Gúcalenaʼ tu nu nayë́pisëtërö. Nuchisaʼ tu nu gurö́ cazaʼ quiaʼ ladaj bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Budzö́lidaʼ-nëʼ David, huen dxin quiaʼ. Guluʼa-nëʼ le za le naca láʼayi quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Len naʼ cazaʼ naguixjaʼ lëʼ, ateʼ len naʼa caʼ utipaʼ ládxëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Bitiʼ siʼ yeʼe lëʼ nu rilé lëʼ, en bitiʼ usacaʼ ziʼ lëʼ nu ruáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Uquínnajaʼ lahuëʼ nupa taʼdíl-lalen lëʼ, en guʼa nupa bitiʼ taʼléʼe lëʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Sóalenaʼ lëʼ lu yöl-laʼ run ca rnna xtídzaʼa, en lu yöl-laʼ dxiʼi ladxiʼ quiaʼ, ateʼ tuʼ ulidzëʼ Laʼ, uxönaʼ yöl-laʼ nál-la queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Gunaʼ ga inná bëʼë ga naguelaʼ raʼ nísadoʼ, ga idxintë raʼ yegu Eufrates. ");
INSERT INTO zarNT_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Ulidzëʼ nedaʼ, innë́ʼ: Liʼ nacuʼ Xuzaʼ, en Dios quiaʼ, encaʼ Nu run chiʼi nedaʼ, en Nu rusölá nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Gun cazaʼ nedaʼ ga gáquiëʼ ca biʼi lo queë cazaʼ, ateʼ tsë́pisëtërëʼ ca yuguʼ bönniʼ taʼnná bëʼë yödzölió. ");
INSERT INTO zarNT_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Lu yöl-laʼ dxiʼi ladxiʼ quiaʼ gun chíʼiticaʼsaʼ lëʼ, en uzóaʼ tsaz queëʼ didzaʼ dzaga quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Ucuáʼa tsaz zxíʼini xiʼsóëʼ, ateʼ sóaticaʼsö lataj ga inná bëʼë, tsca soa yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Channö uluʼcáʼanëʼ zxíʼini xiʼsóëʼ xibá quiaʼ, en cabí ilunëʼ ca naca le buchiʼa busörö́aʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","en channö ilaʼguitsjëʼ xibá que le gunná bëʼa, en cabí ilunëʼ ca nácagaca le gunná béʼedaʼ légaquiëʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","níʼirö gunaʼ légaquiëʼ xiguiaʼ ca saʼyéaj le taʼdödi bëʼ tunëʼ, en guʼa léguequi ca naca xiguiaʼ nabágaʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Pero bitiʼ ugúaʼ queëʼ yöl-laʼ dxiʼi ladxiʼ quiaʼ, en bitiʼ usanaʼ gunaʼ ca rnna le guzxíʼ lu naʼa gunaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Bitiʼ ucáʼanaʼ cáʼasö didzaʼ dzaga nunaʼ, en bitiʼ utsáʼa didzaʼ bëʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Tu le nuzóaʼ tsutsu, en nunaʼ ba nalí que le naca láʼayi quiaʼ. Bitiʼ caʼ siʼ yéʼedaʼ David. ");
INSERT INTO zarNT_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Gunníaʼ ilaʼcuáʼticaʼsëʼ zxíʼini xiʼsóëʼ, en ga röʼë rinná bëʼë sóaticaʼsö lahuaʼ ca gubidza. ");
INSERT INTO zarNT_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Naguixjaʼ le tsaz ca nuzóaʼ tsaz beoʼ, ateʼ nacuáʼticaʼsö lúzxiba le tun ba nalí.” ");
INSERT INTO zarNT_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Pero nuzúʼ tsöláʼalö, en nusán ládxuʼu, en rilédeʼenuʼ nupa naʼ gurö́ cazuʼ quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Nuzúʼ tsöláʼalö didzaʼ dzaga bénlenuʼ huen dxin quiuʼ. Nuzötjuʼ luyú yöl-laʼ unná bëʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Nuquínnajuʼ zöʼö gulún chiʼi lëʼ, en nusunítiuʼ yuguʼ lataj tsutsu queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Yúguʼtë nupa taʼdö́disö taʼbán le nequi queëʼ, ateʼ bönniʼ dzaga yuʼu queëʼ tuʼcáʼana lëʼ cáʼasö. ");
INSERT INTO zarNT_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Nuchisuʼ nupa taʼdáʼbagaʼ lëʼ, en runuʼ ga tuʼdzeja nupa bitiʼ taʼléʼe lëʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Runuʼ ga bitiʼ sequiʼ idéliʼnëʼ lu gudil-la, ateʼ cuntu nu sequiʼ ucul-lëʼ lu gudil-la naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Bugúʼ yöl-laʼ lachi queëʼ, en nuzötjuʼ yöl-laʼ unná bëʼ queëʼ lu yu. ");
INSERT INTO zarNT_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Benuʼ ga chinagulëʼ sal-laʼ ni zoëʼ iz cuidiʼ, en nunuʼ ga rutuíʼinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","¿Gácaʼxte caz gunuʼ caní, Xan? ¿Naruʼ tsaz nucachiʼ loʼ? ¿Naruʼ gácaticaʼsö yöl-laʼ rilé quiuʼ ca tu guíʼ réguideʼe? ");
INSERT INTO zarNT_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Yöjné nabábasö iz soaʼ ibanaʼ, en tu chíʼisö nacuáʼ bönachi yödzölió ni. ");
INSERT INTO zarNT_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","¿Nuzxi caz bönniʼ gaca sóaticaʼsëʼ ibanëʼ, en cabí gátiëʼ? ¿Naruʼ huáca usölá cuin cazëʼ lu yöl-laʼ unná bëʼ que lataj chul-la? ");
INSERT INTO zarNT_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","¿Gázxitë zoa yöl-laʼ dxiʼi ladxiʼ quiuʼ guzóa zíʼalö, Xan, lë naʼ buzúʼ tsutsu xtídzuʼu gunuʼ queëʼ David, len yöl-laʼ run ca rnna xtídzuʼu? ");
INSERT INTO zarNT_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Yöjné ca tuʼcáʼana cáʼasö netuʼ, huen dxin quiuʼ, Xan, encaʼ ca tuʼcáʼana nedaʼ cáʼasö bönachi zián yödzö izáʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Tuʼcáʼana nedaʼ cáʼasö nupa bitiʼ taʼléʼe Liʼ dxiʼa, Xan. Tuʼcáʼana cáʼasö yuguʼ le runaʼ nedaʼ, bönniʼ gurö́ cazuʼ quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","¡Yöl-laʼ ba Xanruʼ Dios iz siʼ zaca! ¡Caʼ gaca! ¡Ön, caʼ gaca! ");
INSERT INTO zarNT_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Naca cazuʼ Liʼ, Xan, ca yuʼu lidxaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Zíʼatëlö ca gulataʼ yuguʼ guíʼa, o ca gutaʼ yödzölió, ga naguelaʼ cateʼ gusí lo ga idxintë dza udxi, tsaz naca cazuʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Runuʼ ga tuʼhuöáca bönachi bëchtö yu cateʼ rnnoʼ: “Guliʼhuöáca le néquiniliʼ, bönachi.” ");
INSERT INTO zarNT_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Quiuʼ Liʼ chi gayuáʼ iz nácagaca ca dza neje le chigudödi que, o ca tu chíʼisö chiʼi dzö́ʼölö. ");
INSERT INTO zarNT_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Bugacuʼ bönachi ca tu lu yegu gubóʼo, ateʼ gúcagaca ca tu yëla rineruʼ. Cateʼ naca zila zéaj naca ca tu guíxiʼdoʼ rilentë luyú. ");
INSERT INTO zarNT_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","Cateʼ naca lahuiʼ dza rizxö́n, en röʼ niʼa nëʼe, pero cateʼ chiral-la, ricuadiʼ, en ridödi que. ");
INSERT INTO zarNT_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Rinítituʼ tuʼ rilenuʼ netuʼ, ateʼ tuʼ ridzóʼo ruúbi ruguíʼituʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Nuzúʼ loʼ xiguiaʼ nabágaʼtuʼ, en nubéajuʼ lu beníʼ quiuʼ dul-laʼ yuʼu ládxiʼdoʼotuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Tuʼ rilédeʼenuʼ netuʼ ridödi quégaca dza queë́tuʼ, ateʼ chibúʼu iz queë́tuʼ ca tu le rinnë́ ládxiʼtuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Tsónnalalaj yuʼ chi ízisö zóatuʼ nabantuʼ, o channö nál-latuʼ, huazóatuʼ idú tápalalaj iz, pero runtuʼ dxin bayudxi, en ruhuíʼinituʼ yuguʼ iz naʼ, tuʼ ridö́ditë quéguequi iz naʼ, ateʼ uzáʼatuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","¿Nuzxi caz réajniʼi tsca naca yöl-laʼ rilé quiuʼ? ¿Nuzxi caz nözi ca naca tsöbi yuʼu nu naʼ rilenuʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Que lë ni naʼ busëdi netuʼ para guéquibeʼetuʼ tsca gácagaca iz zóatuʼ, para gácatuʼ bönachi taʼyéajniʼi loʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","¿Gácaʼxte caz bitiʼ huéchiʼ ládxuʼu netuʼ, Xan? Buéchiʼ ladxiʼ netuʼ, yuguʼ huen dxin quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Tu zila tu zila buluíʼi netuʼ ca naca yöl-laʼ dxiʼi ladxiʼ quiuʼ, para gúl-latuʼ lu yöl-laʼ rudzeja queë́tuʼ, en uzíʼituʼ xibé yuguʼ dza naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Ben ga udzéjatuʼ tsca chigulaca dza busacaʼ ziʼu netuʼ, en tsca gulaca iz bitiʼ guca dxiʼa queë́tuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Buluíʼi netuʼ, yuguʼ huen dxin quiuʼ, ca naca le nunuʼ, en buluíʼi zxíʼinituʼ ca naca yöl-laʼ zxön quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","¡Buzáʼ ladxiʼ queë́tuʼ, Xantuʼ Dios, en ben ga irúaj dxiʼa dxin runtuʼ! ¡Ön, ben ga gaca dxiʼa loʼ dxin runtuʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Nu bönniʼ ruzxöni ládxëʼë Dios para gun chiʼë lëʼ, en riziʼë Dios Nu napa idútë yöl-laʼ huáca, para gácalenëʼ lëʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","gaca guiëʼ Xanruʼ: “Nacuʼ Nu run chiʼi nedaʼ, en Nu ruzóa nedaʼ tsutsu. Nacuʼ Dios quiaʼ, ateʼ ruzxöni ládxaʼa Liʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Usölá cazëʼ Dios Liʼ lu du yalaj que nu rizö́n bönachi, en lu yödzöhuë́ʼ le rusuniti. ");
INSERT INTO zarNT_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Usubáguëʼë liʼ ca rusubágaʼbaʼ böra yuguʼ bö́radoʼ queë́baʼ, ateʼ gaca chiʼu lu nëʼë ca raca quégacabaʼ bö́radoʼ zxan xílabaʼ yöjede. Le run chiʼi rëʼu, en le ruzóa rëʼu tsutsu naca yöl-laʼ run ca rnna xtídzëʼë cheëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Bitiʼ gádxinuʼ le run gadxi bönachi chiʼi dzö́ʼölö, en bitiʼ gádxinuʼ yaga lahui tuchiʼ tuʼsë́ bönachi lahuiʼ dza, ");
INSERT INTO zarNT_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","en bitiʼ gádxinuʼ yödzöhuë́ʼ le rilén ga naca chul-la, en bitiʼ gádxinuʼ le naca xihuiʼ le ruti bönachi lahuiʼ dza. ");
INSERT INTO zarNT_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Ilátigaca chi gayuáʼ bönachi cuituʼ liʼ, en iaʼchí cöʼ chi gayuáʼ cuituʼ ibëla, pero bitiʼ bi gaca quiuʼ liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Le nácatë uyú ináʼasuʼ, en iléʼenuʼ le rubíʼi quégaca nupa tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Tuʼ nuzúʼ-nëʼ Xanruʼ Nu run chiʼi liʼ, nuzúʼ-nëʼ Dios nayë́pisëtërëʼ Nu gácalen liʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","bitiʼ bi gaca quiuʼ le cabí naca dxiʼa, en nitú le nachë́ʼ yödzöhuë́ʼ bitiʼ tsuʼu lidxuʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","tuʼ cuʼu cazëʼ Dios liʼ lu náʼagaquiëʼ gubáz láʼayi queëʼ, para ilún chiʼë liʼ gátiʼtës ga ridóʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Lu náʼagaquiëʼ ilaʼchë́ʼë liʼ, para cabí tsöjchéguʼu guiö́j. ");
INSERT INTO zarNT_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Uléaj ulibuʼ bëdxi guixiʼ, en bëla síniaʼ. Usunuʼ lëʼe labuʼ bëdxi guíxiʼdoʼ, en bëla xitsiníʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Rnnëʼ Dios: “Nadxiʼinëʼ nedaʼ, ateʼ que lë ni naʼ usöláʼ lëʼ. Uzóaʼ-nëʼ tsaz xitsáʼtërö tuʼ núnbëʼë Laʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Ulidzëʼ nedaʼ, ateʼ ubiʼa didzaʼ. Sóalenaʼ lëʼ cateʼ bi gaca queëʼ. Usöláʼ lëʼ, en gunaʼ lëʼ bal. ");
INSERT INTO zarNT_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Uzándaʼa dza soëʼ ibanëʼ, en uluíʼidaʼ-nëʼ ca gaca usöláʼ lëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","¡Bicaʼ tsahuiʼ naca rigúʼutuʼ Liʼ yöl-laʼ ba, Xan, en rúl-latuʼ le tun Liʼ bal, Dios nayë́pisëtërëʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","en rusiyöntuʼ bönachi yuguʼ zila ca ruhuéchiʼ ládxuʼu netuʼ, en ruluíʼituʼ lahui yuguʼ dzöʼ ca runuʼ ca rnna xtídzuʼu! ");
INSERT INTO zarNT_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","Rúl-latuʼ len yuguʼ bihuël-la, en rúl-latuʼ yuguʼ le lachi ca tul-la. ");
INSERT INTO zarNT_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Le zxön nunuʼ Liʼ, Xan, run ga rudzéjatuʼ, ateʼ ruziʼtuʼ xibé le núngaca lu noʼo. ");
INSERT INTO zarNT_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Bicaʼ zxön nácagaca le nunuʼ Liʼ, Xan. Zxö́ntërö le rizáʼ ládxuʼu gunuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Zoa tu le cabí gaca inö́zinëʼ bönniʼ nazxí icjëʼ, en bitiʼ gaca tséjniʼinëʼ bönniʼ canö́z le. ");
INSERT INTO zarNT_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Nupa nucáʼanagaca Dios ilaʼyán ca taʼyán guíxiʼdoʼ, en uluʼzíʼ xibé le tun nupa tuáʼ döʼ, pero ilaʼniti tsaz, ");
INSERT INTO zarNT_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","tuʼ nayë́psëtëruʼ Liʼ tsaz, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Naca bëʼ le gaca quégaca nupa bitiʼ taʼléʼe Liʼ dxiʼa, Xan. Naca bëʼ ilaʼniti nupa bitiʼ taʼléʼe Liʼ dxiʼa. Uluʼgáʼana cáʼasö yúguʼtë nupa tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Nunuʼ ga nácatëraʼ nal-la ca nácabaʼ bëdxi. Nagúʼu nedaʼ le za le run ga rudzéjadaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Iléʼe quézidaʼ cateʼ uxicjuʼ nupa bitiʼ taʼléʼe Liʼ dxiʼa, en yöndaʼ cateʼ ilaʼbödxi yechiʼ nupa tuáʼ döʼ, nupa naʼ taʼdíl-lalen nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Ilaʼyán nupa nácagaca tsahuiʼ ca taʼyán yaga zinaʼ caʼ. Ilaʼzxö́n ca taʼzxö́n yaga rö́ʼgaca lu guíʼa Líbano. ");
INSERT INTO zarNT_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Nácagaca ca yaga nudáʼgacuʼ raʼ yuʼu lidxuʼ, Xan, le taʼzxö́n lu löʼa lataj quiuʼ, Dios queë́tuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Cateʼ niʼ yúʼugaca iz zián ilaʼbía le zxixi quéguequi. Ilácagaca tsutsu, en ilaʼcuáʼticaʼsö yaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Caní gaca para gaca bëʼ náquiëʼ tsahuiʼ Xanruʼ, Nu run chiʼi nedaʼ. Bitiʼ bi zóalen Lëʼ le cabí naca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","¡Rinná bëʼë Xanruʼ! ¡Nácuëʼ yöl-laʼ ba zxön queëʼ! ¡Nácuëʼ zxëʼ Xanruʼ, en núguiëʼ lëʼë yöl-laʼ unná bëʼ! ¡Nuzóëʼ tsutsu yödzölió, ateʼ bitiʼ utá cuini! ");
INSERT INTO zarNT_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","¡Tsaz nuzúʼ tsutsu ga röʼu rinná bëʼu, Xan, en zóaticaʼsuʼ Liʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Riyasa ridxía nisa yuguʼ lu nísadoʼ, Xan. Riyasa ridxía nisa, en ruʼu bö que. Riyasa ridxía nisa yuguʼ lu nísadoʼ, en yuguʼ lu yegu. ");
INSERT INTO zarNT_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Xanruʼ Dios yehuaʼ yubá nápatërëʼ yöl-laʼ unná bëʼ ca bö ruʼu lu nísadoʼ le riyö́n ca guziúʼ rinnë́, encaʼ ca le riyasa ridxía nisa lu nísadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Tsaz naguixjuʼ xibá quiuʼ, Xan, ateʼ idú láʼayi naca ga zoa cazuʼ Liʼ. Caní zóaticaʼsö naʼa dza, en dza siʼ zaca. ");
INSERT INTO zarNT_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Nacuʼ Dios, Xan, Nu ruzíʼ lëbi bönachi. Buluíʼi cuinuʼ, Dios, Nu ruzíʼ lëbi. ");
INSERT INTO zarNT_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Ruchiʼa rusörö́ cazuʼ yúguʼtë bönachi. Guzë́, ateʼ len yöl-laʼ huáca zxön quiuʼ bubíʼi quégaca nupa tun ba zxön cuínguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","¿Gácaʼxte caz uluʼzíʼ xibé nupa tuʼcáʼana Liʼ, Xan? ¿Gácaʼxte caz uluʼzíʼ xibé? ");
INSERT INTO zarNT_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","¿Gácaʼxte caz ilún ba zxön cuínguequi, en iluíʼi didzaʼ ziʼ? ¿Gácaʼxte caz ilún ba zxön cuínguequi niʼa que döʼ tuáʼgaca? ");
INSERT INTO zarNT_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Tuʼsunítiëʼ nupa néquiguequi quiuʼ, Xan. Tuʼsacaʼ ziʼë nupa néquiguequi quez quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Tútigaquiëʼ nigula uzëbi, encaʼ yuguʼ biʼi uzë́bidoʼ, en tunëʼ le naca xihuiʼ ladaj bönachi ziʼtuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Taʼnnë́ʼ: “Bitiʼ iléʼenëʼ Xángaquiëʼ rëʼu, en bitiʼ ruíʼi ládxëʼë Dios queëʼ Jacob lë ni.” ");
INSERT INTO zarNT_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Guliʼtséajniʼi, bönachi bitiʼ nö́zguequi, ateʼ libíʼiliʼ, bönachi catún bal, ¿bátaxi tséajniʼiliʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Benëʼ Dios guídi nágaruʼ. ¿Naruʼ cabí riyö́n quézinëʼ? Benëʼ Dios guiö́j loruʼ. ¿Naruʼ cabí riléʼe quézinëʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Ruzéajniʼi quézinëʼ Dios bönachi yúguʼtë yödzö. ¿Naruʼ cabí gunëʼ léguequi xiguiaʼ? Ruchiza cazëʼ icja ládxiʼdoʼoruʼ yöl-laʼ réajniʼi. ¿Naruʼ cabí réquibeʼenëʼ bi runliʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Nöz quézinëʼ Xanruʼ yuguʼ le taʼzáʼ ládxiʼgaca bönachi. Nö́zinëʼ canö́z naca le taʼzáʼ ládxiʼgaca. ");
INSERT INTO zarNT_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Bicaʼ ba bönniʼ naʼ ruzéajniʼi quézinuʼ-nëʼ, Xan, en rusedi quézinuʼ-nëʼ ca naca xibá naguixjuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","Gunuʼ ga uzíʼ ládxëʼë cateʼ bi gaca queëʼ, ga idxinrö dza tsúʼugaca yeru ba nupa tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Bitiʼ usán nëʼë Xanruʼ bönachi queëʼ, en bitiʼ ucáʼanëʼ nupa néquiguequi quez queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Ca naca le naca tsahuiʼ uchiʼa usörö́ëʼ rëʼu le yúbölö, ateʼ uluʼzíʼ xibé nupa nácagaca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","¿Nuzxi caz tíl-lalen nupa tuti bönachi para gácalen nedaʼ? ¿Nuzxi caz gácalen nedaʼ cateʼ nacuáʼ nupa tuáʼ döʼ quiaʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Laʼtuʼ cabí gúcalenëʼ Xanruʼ nedaʼ, laʼ yöjtsúʼuteaʼ lataj chul-la que yöl-laʼ guti. ");
INSERT INTO zarNT_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Gunníaʼ: “Chizóaʼ ibixaʼ”, ateʼ lu yöl-laʼ dxiʼi ladxiʼ quiuʼ guzxönuʼ nedaʼ, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Cateʼ ruúbi ruguíʼi ládxiʼdaʼahuaʼ, ruhuë́ tsahúʼu nedaʼ, en runuʼ ga rudzéjadaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Bitiʼ caʼ gunuʼ tsözxö́n nupa tuʼchiʼa tuʼsörö́ netuʼ ca naca le cabí naca tsahuiʼ, nupa naʼ tuʼbéaj tsahuiʼ le cabí naca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Tuʼdubëʼ tsözxö́n para ilútiëʼ nupa nácagaca tsahuiʼ, en taʼchúguiëʼ quégaca nupa bitiʼ bi nabágaʼgaca ilátigaca, ");
INSERT INTO zarNT_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","pero run chiʼi cazëʼ Xanruʼ Dios nedaʼ. Nuzóëʼ nedaʼ tsutsu, ateʼ ruzxöni ládxaʼa lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Ubiʼë quégaquiëʼ ca naca döʼ tuʼë, en usunítiëʼ légaquiëʼ tuʼ nözi xiguiaʼ nabágaʼgaquiëʼ. Usunítiëʼ dërö Xanruʼ Dios légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Guliʼdá, gúl-laruʼ queëʼ Xanruʼ lu yöl-laʼ rudzeja queë́ruʼ. Lu yöl-laʼ rudzeja queë́ruʼ cö́dxiʼaruʼ que Nu naʼ naca ca tu guiö́jtoʼo ga nuláruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Uyéajruʼ lahuëʼ, en guië́ruʼ-nëʼ: “Xclenuʼ.” Lu yöl-laʼ rudzeja queë́ruʼ cö́dxiʼaruʼ lahuëʼ, gúl-laruʼ yuguʼ salmo. ");
INSERT INTO zarNT_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Xanruʼ Dios náquiëʼ Dios nayë́pisëtërëʼ. Nápatërëʼ yöl-laʼ unná bëʼ ca yúguʼtë dios izáʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Lu naʼ cazëʼ yuʼu le dë ga rëʼ zxan luyú, ateʼ néquiguequi caʼ queëʼ guíʼa sibi. ");
INSERT INTO zarNT_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Nequi queëʼ nísadoʼ, tuʼ nun cazëʼ le, en len náʼasëʼ benëʼ luyú bidxi. ");
INSERT INTO zarNT_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Guliʼdá, gunruʼ-nëʼ zxön, en uzóa zxíbiruʼ lahuëʼ. Uzóa zxíbiruʼ lahuëʼ Xanruʼ Nu ben rëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Naca cazëʼ Lëʼ Dios queë́ruʼ, ateʼ nácaruʼ bönachi rugagu cazëʼ, en ca böʼcuʼ zxilaʼ richë́ʼ cazëʼ-baʼ lu nëʼë. Rnna cazëʼ Dios: “Naʼa, channö rë́ʼëniliʼ yö́niliʼ chiʼa, ");
INSERT INTO zarNT_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","bitiʼ gunliʼ zidzaj icja ládxiʼdoʼoliʼ ca gulunëʼ xuz xtóʼoliʼ lataj naʼ lë Meriba, en calëga ca gulunëʼ laʼ guixiʼ ga dë lataj lë Masa, ");
INSERT INTO zarNT_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","cateʼ niʼ gulaʼzíʼ bëʼë xuz xtóʼoliʼ nedaʼ. Gulaʼzíʼ bëʼë nedaʼ sal-laʼ bilaʼléʼenëʼ yuguʼ le benaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Idú choáʼ iz gúquidaʼ ziʼ bönachi gulaʼcuáʼ dza niʼ, ateʼ gunníaʼ: “Taʼchixi taʼníguinëʼ lu icja ládxiʼdoʼgaquiëʼ, en bitiʼ nö́zguequinëʼ le rë́ʼëndaʼ ilunëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Que lë ni naʼ lu yöl-laʼ rilé quiaʼ benaʼ tsutsu xtídzaʼa, gunníaʼ: “Bitiʼ caʼ ilaʼyáziëʼ ga uluʼzíʼ ládxëʼë tsözxö́n len nedaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","¡Guliʼgul-la queëʼ Xanruʼ tu le cubi! ¡Guliʼgul-la queëʼ Xanruʼ, yúguʼtëliʼ zóaliʼ yödzölió! ");
INSERT INTO zarNT_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","¡Guliʼgul-la queëʼ Xanruʼ! ¡Guliʼgún zxön lëʼ! Tu dza tu dza buliʼsiyö́n bönachi didzaʼ dxiʼa ca rusölë́ʼ rëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Buliʼsiyö́n bönachi yúguʼtë yödzö yöl-laʼ ba queëʼ. Buliʼsiyö́n yúguʼtë bönachi le nácagaca zxön nunëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Zxö́ntërö náquiëʼ Xanruʼ, ateʼ rundaʼ bayúdx cúʼuruʼ-nëʼ yöl-laʼ ba. Ral-laʼ gádxitëruʼ Lëʼ ca tadxi bönachi izáʼa dios quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Yuguʼ dios quégaca bönachi izáʼa nácagacasö budóʼ guiö́j budóʼ yaga, pero Xanruʼ Dios nunëʼ lúzxiba xitsáʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Nacuáʼ yöl-laʼ beníʼ, en yöl-laʼ ba lahuëʼ Lëʼ. Nacuáʼ yöl-laʼ huáca, en yöl-laʼ lachi ga zoa cazëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","¡Guliʼcuʼë Xanruʼ yöl-laʼ ba, bönachi yúguʼtë yödzö! ¡Guliʼcuʼë yöl-laʼ ba, en yöl-laʼ huáca! ");
INSERT INTO zarNT_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","¡Guliʼcuʼë Xanruʼ yöl-laʼ ba niʼa que Lëʼ! ¡Guliʼguáʼ le unö́dzjaliʼ, en guliʼdá lahuëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","¡Guliʼgún Lëʼ zxön, náculiʼ le naca baʼa! ¡Guliʼzxizi lahuëʼ, bönachi idútë yödzölió! ");
INSERT INTO zarNT_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Guliʼnná lógaca bönachi yúguʼtë yödzö: “Rinná bëʼë Xanruʼ. Naguixjëʼ tsaz luyú, ateʼ bitiʼ utá cuini. Ca naca le naca tsahuiʼ uchiʼa usörö́ëʼ quégaca yúguʼtë bönachi.” ");
INSERT INTO zarNT_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Ral-laʼ udzeja lúzxiba, en uluʼzíʼ xibé luyú. Ral-laʼ cö́dxiʼa nísadoʼ, en ilaʼbödxi yúguʼtë le nacuáʼ lu nísadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Ral-laʼ udzeja guixiʼ caz, en yúguʼtë le nacuáʼ laʼ guixiʼ. Lu yöl-laʼ rudzeja quéguequi ilúl-la yaga ");
INSERT INTO zarNT_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","lahuëʼ Xanruʼ, tuʼ siʼ ulë́ʼ. Guídëʼ duchiʼa dusörö́ëʼ nupa nacuáʼ yödzölió. Ca naca le naca tsahuiʼ uchiʼa usörö́ëʼ quégaca yúguʼtë bönachi, encaʼ quégaca bönachi yúguʼtë yödzö para ilunëʼ ca rnna xtídzëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","¡Rinná bëʼ cazëʼ Xanruʼ Dios! ¡Ral-laʼ uluʼdzeja bönachi idútë yödzölió! Buliʼsíʼ xibë́ʼ, libíʼiliʼ zóaliʼ yúguʼtë yödzö izáʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Rö́ʼgaca böaj, en le chul-la idú gásibiʼilö ga naʼ zoëʼ. Le naca dxiʼa, en le naca tsahuiʼ tuʼzóa tsutsu le rinná bëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Rinöru tu guíʼ zxön lahuëʼ, le uzeguiʼ nupa taʼdáʼbagaʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Tuʼzeníʼ le taʼyëpi yösa yödzölió. Riléʼe luyú lë ni, en rizxizi. ");
INSERT INTO zarNT_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Tuʼúnaʼ guíʼadoʼ ca ruún bidxinaʼ buz lahuëʼ Xanruʼ. Náquiëʼ Xani idútë yödzölió. ");
INSERT INTO zarNT_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Lúzxiba xitsáʼ naca bëʼ náquiëʼ tsahuiʼ, ateʼ taʼléʼe bönachi yúguʼtë yödzö yöl-laʼ zxön queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Tuʼtuíʼi yúguʼtë nupa tun zxön budóʼ guiö́j budóʼ yaga, nupa naʼ tun ba zxön cuínguequi niʼa quégaca budóʼ quéguequi naʼ. Uluʼgáʼana cáʼasö yúguʼtë dios quégaca bönachi izáʼa lahuëʼ Xanruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Bilaʼyöni bönachi Sión, en buluʼdzeja, encaʼ yuguʼ zxíʼini xiʼsóëʼ Judá. Tuʼdzéjanëʼ ca ruchiʼa rusörö́uʼ netuʼ, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Nayë́pisëtërö cazuʼ Liʼ, Xan, ca yúguʼtë nupa nacuáʼ yödzölió. Nayë́pisëtërö cazuʼ Liʼ ca yúguʼtë dios quégaca bönachi izáʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Núlöliʼ nadxíʼiliʼ-nëʼ Xanruʼ, guliʼguequi ziʼ le naca döʼ. Run chiʼi cazëʼ böʼ nácagaca caz nupa néquiguequi queëʼ. Rusölë́ʼ léguequi lu náʼagaca nupa tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Ruzeníʼticaʼsö beníʼ queëʼ nupa nácagaca tsahuiʼ, ateʼ tuʼzíʼ xibë́ʼ nupa nácagaca dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","¡Buliʼsíʼ xibë́ʼ Xanruʼ núlöliʼ nácaliʼ tsahuiʼ! ¡Buliʼsubán ládxiʼliʼ ca nunëʼ Dios Láʼayi, en guliʼcuʼë yöl-laʼ ba! ");
INSERT INTO zarNT_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","¡Guliʼgul-la queëʼ Xanruʼ tu le cubi, tuʼ nunëʼ le tun ga rubániruʼ! Len yöl-laʼ unná bëʼ zxön queëʼ, en yöl-laʼ huáca láʼayi queëʼ nadéliʼnëʼ lu gudil-la. ");
INSERT INTO zarNT_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Nunëʼ Xanruʼ ga naca bëʼ le nadéliʼnëʼ. Nuluíʼinëʼ bönachi yúguʼtë yödzö náquiëʼ tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Len yöl-laʼ dxiʼi ladxiʼ queëʼ, en yöl-laʼ li ladxiʼ queëʼ benëʼ ca rnna xtídzëʼë le guzxíʼ lu nëʼë gunëʼ quégaca bönachi Israel. Bilaʼléʼe bönachi idútë yödzölió ca busölë́ʼ rëʼu Dios queë́ruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","¡Lu yöl-laʼ rudzeja queë́liʼ guliʼgul-la queëʼ Xanruʼ, yúguʼtëliʼ zóaliʼ yödzölió! ¡Idú ládxiʼliʼ guliʼcuʼë yöl-laʼ ba, en guliʼgul-la queëʼ le naca láʼayi! ");
INSERT INTO zarNT_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","¡Guliʼgul-la queëʼ Xanruʼ yuguʼ salmo, en guliʼquinnaj yuguʼ bihuël-la! ¡Guliʼquinnaj lë́ʼegaca arpa, en guliʼgul-la yöl-laʼ ba queëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","¡Guliʼcödxi lúzugacabaʼ chivo, en lúzugacabaʼ bëdxi lahuëʼ Xanruʼ Dios, Nu rinná bëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","¡Buliʼlidza zidzaj, nísadoʼ, en yúguʼtë le nacuáʼ nisa naʼ! ¡Guliʼgul-la yödzölió, en yúguʼtë nupa nacuáʼ niʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","¡Guliʼcapaʼ náʼaliʼ, yuguʼ yegu, ateʼ lu yöl-laʼ rudzeja queë́liʼ guliʼgul-la lahuëʼ Xanruʼ, libíʼiliʼ, guíʼadoʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","tuʼ zëʼë duchiʼa dusörö́ëʼ quégaca bönachi yödzölió! Ca naca le naca tsahuiʼ uchiʼa usörö́ëʼ quéguequi, en ca naca le naca dxiʼa tsahuiʼ inná béʼenëʼ yúguʼtë bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","¡Rinná bëʼë Xanruʼ Dios! Taʼzxizi yúguʼtë bönachi. Röʼë rinná bëʼë ladaj nupa nápagacatërö yöl-laʼ huáca, lë́gaca Querubín, ateʼ rizxizi luyú. ");
INSERT INTO zarNT_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Nayë́pisëtërëʼ Xanruʼ lu yödzö Sión, ateʼ rinná béʼenëʼ bönachi yúguʼtë yödzö izáʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Ral-laʼ ilaʼgúʼu Lëʼ yöl-laʼ ba yúguʼtë bönachi, tuʼ caní saʼyéaj, en le run ga runruʼ Lëʼ bal. ¡Láʼayi náquiëʼ Lëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Nadxíʼi quézinuʼ le naca tsahuiʼ, Liʼ, Bönniʼ unná bëʼ nayë́pisë. Tsaz naguixjuʼ le naca dxiʼa tsáhuiʼdoʼ, en nuzúʼ quégaquiëʼ zxíʼini xiʼsóëʼ Jacob le naca tsahuiʼ, en le naca idútë li. ");
INSERT INTO zarNT_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","¡Guliʼgún zxönëʼ Xanruʼ Dios! Buliʼzechu zxíbiliʼ lahuëʼ Lëʼ ga röʼë rinná bëʼë. ¡Láʼayi náquiëʼ Lëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Guláquiëʼ Moisés, en Aarón bixúz queëʼ, ateʼ benëʼ Samuel tsözxö́n nupa gulaʼyéaj ládxiʼgaca Lëʼ. Buluʼlidzëʼ Xanruʼ, ateʼ bubíʼi cazëʼ didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Tu lu böaj bë́ʼlenëʼ légaquiëʼ didzaʼ. Gulunëʼ ca taʼnná bëʼ xibá queëʼ, en yuguʼ le gunná béʼenëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Bubiʼu didzaʼ lógaca bönachi quiuʼ, Xantuʼ Dios. Buluíʼinuʼ légaquiëʼ nacuʼ Dios, en runiti loʼ bönachi, pero rubiʼu quégaquiëʼ ca saʼyéaj döʼ tuʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","¡Guliʼgún zxönëʼ Xanruʼ Dios! ¡Buliʼzechu zxíbiliʼ lahuiʼ lo guíʼa láʼayi ga zoa cazëʼ, tuʼ náquiëʼ láʼayi Xanruʼ Dios! ");
INSERT INTO zarNT_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","¡Lu yöl-laʼ rudzeja queë́liʼ guliʼgul-la queëʼ Xanruʼ, libíʼiliʼ zóaliʼ idútë yödzölió! ");
INSERT INTO zarNT_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","¡Lu yöl-laʼ rudzeja queë́liʼ guliʼcuʼë yöl-laʼ ba Xanruʼ! ¡Guliʼdá lahuëʼ Lëʼ, en lu yöl-laʼ rudzeja queë́liʼ guliʼgul-la queëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","¡Guliʼtsöjné Xanruʼ, náquiëʼ Dios! Buzáʼ cazëʼ rëʼu, en calëga rácasö queë́ruʼ zóaruʼ. Nácaruʼ bönachi queëʼ, en nácaruʼ ca böʼcuʼ zxilaʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Guliʼtsaza zacaʼ raʼ yuʼu queëʼ, guië́liʼ-nëʼ: “Xclenuʼ.” Guliʼtsaza gapa naca löʼa queëʼ, cúʼuliʼ-nëʼ yöl-laʼ ba. Guliʼguíëʼ: “Xclenuʼ”, en guliʼgunëʼ zxön. ");
INSERT INTO zarNT_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","¡Náquiëʼ dxiʼa tsahuiʼ Xanruʼ Dios, ateʼ zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ! ¡Zóaticaʼsö yöl-laʼ run ca rnna xtídzëʼë queëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","¡Gul-laʼ ca runuʼ ca rnna xtídzuʼu, en ca nacuʼ tsahuiʼ! ¡Gul-laʼ yöl-laʼ ba quiuʼ Liʼ, Xan! ");
INSERT INTO zarNT_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Güíʼi ládxaʼa gunaʼ le naca idú dxiʼa. ¿Bátaxi huécjuʼ quiaʼ nedaʼ? Lu yuʼu lidxaʼ gunaʼ le naca idú ladxiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Bitiʼ guʼa lataj sóalen nedaʼ nitú le naca xihuiʼ. Bitiʼ riléʼedaʼ dxiʼa le tun nupa tuʼcáʼana Liʼ. Bitiʼ caʼ gunaʼ léguequi tsözxö́n. ");
INSERT INTO zarNT_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Bitiʼ caʼ gacaʼ chopa ladxiʼ. Bitiʼ caʼ gunaʼ le naca döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Usunítiaʼ dërö nu bönniʼ rinnë́ʼ que luzë́ʼë balándoʼos. Bitiʼ caʼ guáʼ ilenaʼ nu run ba zxön cuini. ");
INSERT INTO zarNT_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Uyúaʼ dxiʼa tsáhuiʼdoʼ nupa tun ca rnna xtídzaʼguequi luyú ni, para ilaʼcuáʼlen nedaʼ. Nu bitiʼ bi xiguiaʼ nabagaʼ huáca gun xichinaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Bitiʼ caʼ tsöjsóa lidxaʼ nu rizíʼ yëʼ. Bitiʼ guʼa lataj ugáʼana lahuaʼ nu ruíʼi didzaʼ le cabí naca. ");
INSERT INTO zarNT_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Yuguʼ zila usunítiaʼ yúguʼtë nupa tuáʼ döʼ luyú ni, para ucuitaʼ lu yödzö queëʼ Xanruʼ yúguʼtë nupa tuti bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","¡Buzë́ naguʼ le rulidzaʼ Liʼ, Xan! ¡Bëʼ lataj idxín loʼ le rinaba yúdxidaʼ Liʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Bitiʼ ucacheʼ cuinuʼ lahuaʼ cateʼ bi rusacaʼ ziʼ nedaʼ. Buzë́ naguʼ nedaʼ, en gudáchi ubiʼu didzaʼ cateʼ rulidzaʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Yöl-laʼ naʼbán quiaʼ ruúlu ca dzön, ateʼ régui rilá lu dxita lu bin quiaʼ ca tu guíʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Rudú ládxaʼa ca raca que guixiʼ nabidxi, en bítiʼrö rizë́ ládxaʼa bi gahuaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Tuʼ rinnëdaʼ ládxaʼa nadxítalëʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Nacaʼ ca tubaʼ biguínni zóabaʼ luyú bidxi, o ca tubaʼ cuturú dxíabaʼ tu lu yuʼu nadachi. ");
INSERT INTO zarNT_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Nabéaj yëla guiö́j lahuaʼ, ateʼ nacaʼ ca tubaʼ biguínnidoʼ dxíabaʼ túzibaʼ ícjoʼo yuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Yuguʼ dza nupa bitiʼ taʼléʼe nedaʼ dxiʼa tuʼdidzaʼ yudxi nedaʼ. Nupa tuʼtitaj nedaʼ tuʼgún dxin laʼ cateʼ nu tuʼdxía döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","Naca le rahuaʼ ca dö́doʼsö, en nutsiʼ nisa ribödxaʼ le rëʼjaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","Caní raca quiaʼ tuʼ rilenuʼ nedaʼ, en réquinuʼ nedaʼ ziʼ. Gulisuʼ nedaʼ, en gurúʼunuʼ nedaʼ tsöláʼalö. ");
INSERT INTO zarNT_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Naca yöl-laʼ naʼbán quiaʼ ca tu zxul-la riláʼ cateʼ ribía gubidza, en rudú quiaʼ ca raca que guixiʼ ricuádi. ");
INSERT INTO zarNT_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","¡Liʼ, Xan, zóaticaʼsuʼ, en zóalenticaʼsö Loʼ bönachi! ");
INSERT INTO zarNT_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","¡Chasuʼ, en huéchiʼ ládxuʼu bönachi yödzö Sión! ¡Chibidxín dza güíʼi ládxuʼu léguequi! ¡Ön, chibidxín dza naʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Netuʼ, huen dxin quiuʼ, nadxíʼituʼ yuguʼ guiö́j nacuáʼ lu zöʼö run chiʼi yödzö Sión, en ruíʼi ládxiʼtuʼ ga ridxintë bëchtö röʼö laʼ nöza que. ");
INSERT INTO zarNT_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Bönachi yuguʼ yödzö izáʼa iladxi Lëʼ Xanruʼ, ateʼ nupa taʼnná bëʼ yödzölió iladxi yöl-laʼ zxön queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","¡Nuchisëʼ Xanruʼ caz yödzö Sión, ateʼ uluíʼi lahuëʼ niʼ lu yöl-laʼ zxön queëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Riyönnëʼ le tuʼlidza Lëʼ nupa taʼyadzaj taʼyudxi. Bitiʼ caʼ uzóëʼ tsöláʼalö le tuʼlidza yudxi Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Buliʼzúaj lë ni lu guichi para uluʼlaba zxíʼini xiʼsóaliʼ le, ateʼ nupa siʼ ilalaj ilaʼgúʼu Xanruʼ yöl-laʼ ba. ");
INSERT INTO zarNT_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Ga niʼ ribözëʼ Xanruʼ xitsáʼ lu lataj láʼayi queëʼ, ga niʼ zoëʼ Xanruʼ yehuaʼ yubá, ruzë́ naguëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","Riyönnëʼ le taʼnnë́ ladxiʼ nupa nadzúngaca, en usanëʼ nupa narugu quéguequi ilátigaca. ");
INSERT INTO zarNT_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","Soa nu usiyöni bönachi yödzö Sión ca naca Lëʼ Xanruʼ, ateʼ ilaʼgúʼu Lëʼ yöl-laʼ ba lu yödzö Jerusalén, ");
INSERT INTO zarNT_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","cateʼ uluʼdubi tsözxö́n bönachi yuguʼ yödzö izáʼa, en bönachi yuguʼ luyú, ateʼ tsözxö́n ilaʼgúʼu yöl-laʼ ba Xanruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Benëʼ Xanruʼ ga gucuídiʼdaʼ laʼ nöza, en nunëʼ ga soaʼ nabábasö dza. ");
INSERT INTO zarNT_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Gunníaʼ: Dios quiaʼ, bitiʼ gútiuʼ nedaʼ cateʼ ni zoaʼ gatsaj iza ral-laʼ soaʼ ibanaʼ. Zóaticaʼsö cazuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Dza niʼte gudixjuʼ yödzölió, ateʼ len naʼ cazuʼ benuʼ lúzxiba. ");
INSERT INTO zarNT_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Huadödi quéguequi, pero Liʼ, tsaz idiʼu. Ilexuʼ yúguʼtëguequi ca riyexuʼ lariʼ, en ca tu lariʼ utubuʼ léguequi, en utsóʼo léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","Liʼ, bitiʼ caʼ utsáʼ cuinuʼ, en bitiʼ caʼ guexuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Zxíʼinigaca huen dxin quiuʼ ilaʼböza dxiʼa tsáhuiʼdoʼ, ateʼ ucúʼu tsutsu zxíʼini xiʼsóagaquiëʼ loʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","¡Bil-la yöl-laʼ ba queëʼ Xanruʼ, liʼ, böʼ naca cazaʼ, ateʼ idútë le nacaʼ, bil-la yöl-laʼ ba que Lëʼ láʼayi! ");
INSERT INTO zarNT_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","¡Bil-la yöl-laʼ ba queëʼ Xanruʼ, liʼ, böʼ naca cazaʼ, en bitiʼ gal-la ládxuʼu yúguʼtë le ruziʼu xibë́ʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Runiti lo cazëʼ nedaʼ ca naca yúguʼtë dul-laʼ nabágaʼa, en rugǘëʼ yúguʼtë xihuëʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Ruhuöáʼuëʼ nedaʼ lu lataj chul-la, en ruzáʼ ládxëʼë quiaʼ yöl-laʼ dxiʼi ladxiʼ, en yöl-laʼ ruhuéchiʼ ladxiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Riguʼë xinözaʼ yuguʼ le naca dxiʼa, lë naʼ run ga ruhuöácaʼ ca tu bönniʼ zoëʼ iz cuidiʼ queëʼ, ca naʼ raca queë́baʼ bisiáʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Runëʼ yuguʼ le naca dxiʼa, en ruchiʼa rusörö́ëʼ quégaca yúguʼtë nupa zoa nu rusacaʼ léguequi ziʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Buzéajniʼinëʼ Moisés yuguʼ le gun cazëʼ Lëʼ, en buluíʼinëʼ bönachi Israel yuguʼ le zxön runëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Xanruʼ ruhuéchiʼ ladxiʼ cazëʼ bönachi, en ruzáʼ ládxëʼë quéguequi. Bitiʼ rilétenëʼ, pero nadxíʼitiquiʼsinëʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Bitiʼ ruzétiquiʼsinëʼ rëʼu le bach, en bitiʼ rilétiquiʼsinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Bitiʼ runëʼ rëʼu xiguiaʼ ca saʼyéaj döʼ nuáʼaruʼ, en bitiʼ rubiʼë queëruʼ ca naca le xihuiʼ nabágaʼruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Naca caní tuʼ ca naʼ naca xitsáʼtërö lúzxiba ca luyú ni, laʼ canísö naca zxön ca nadxíʼinëʼ Xanruʼ nupa tadxi Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Tsca nácatërö ziʼtuʼ ga rilén gubidza ga ridxintë ga ribía, laʼ canísö rucuitëʼ yuguʼ le taʼbágaʼruʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Ca naʼ ruhuéchiʼ ládxëʼë xúzgaca cázabiʼ yuguʼ zxíʼinëʼ, laʼ canísö ruhuéchiʼ ládxëʼë Xanruʼ nupa tadxi Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Caní runëʼ tuʼ nö́zinëʼ le nácaruʼ. Röjnenëʼ néquiniruʼ bëchtö yu. ");
INSERT INTO zarNT_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Tsca nácagaca dza zóaruʼ nabanruʼ, nácagaca ca raca que xiyija guíxiʼdoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Cateʼ recaj böʼ, ruúlu runítisö xiyija naʼ, en bitiʼ naca bëʼ ga naʼ guzóa. ");
INSERT INTO zarNT_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Xanruʼ, tsaz nadxíʼinëʼ nupa tadxi Lëʼ, en runëʼ quégaca zxíʼiniguequi le naca dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","Caní runëʼ quégaca nupa tun ca rnna xtídzëʼë, en quégaca nupa tun ca rinná bëʼ xibá queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Naguixjëʼ Xanruʼ xilatjëʼ yehuaʼ yubá ga naʼ röʼë rinná bëʼë. Rinná béʼenëʼ yúguʼtë le dë. ");
INSERT INTO zarNT_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","¡Guliʼcuʼë yöl-laʼ ba Xanruʼ, libíʼiliʼ, gubáz láʼayi queëʼ, nápatëröliʼ yöl-laʼ huáca zxön, en runliʼ ca rnna xtídzëʼë, libíʼiliʼ naʼ runliʼ ca rnna didzaʼ ruʼë! ");
INSERT INTO zarNT_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","¡Guliʼcuʼë yöl-laʼ ba Xanruʼ, libíʼiliʼ nácaliʼ niʼa nëʼë guizxi yu, libíʼiliʼ, huen dxin queëʼ naʼ, runliʼ ca rë́ʼëni quézinëʼ Lëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","¡Guliʼcuʼë yöl-laʼ ba Xanruʼ, yúguʼtëliʼ naʼ nucuʼë libíʼiliʼ, libíʼiliʼ zóaliʼ yúguʼtë lataj ga naʼ rinná bëʼë Lëʼ! ¡Bil-la yöl-laʼ ba queëʼ Xanruʼ, liʼ, böʼ naca cazaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","¡Guluʼë yöl-laʼ ba Xanruʼ, liʼ, böʼ naca cazaʼ! ¡Nayë́pisëtëruʼ Liʼ, Xanaʼ Dios! ¡Zxoʼ nacuʼ naca yöl-laʼ zxön, en yöl-laʼ ba! ");
INSERT INTO zarNT_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","¡Nusubagaʼ cuinuʼ beníʼ ca zxoʼ nacu cazuʼ, ateʼ naguixaj cazuʼ lúzxiba ca tu lariʼ zxön! ");
INSERT INTO zarNT_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Naguixjuʼ xilataj lidxuʼ lahui nisa dë xitsáʼalö. Dxía cazuʼ lu böaj ca tu lu carreta, en ridóʼ lu böʼös. ");
INSERT INTO zarNT_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Rugunuʼ dxin böʼ raca ca tu gubáz quiuʼ, encaʼ yuguʼ guíʼ ca huen dxin quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Nuzúʼ tsutsu luyú ni lu xilibi, en bitiʼ caʼ gaca nu utsáʼ xilataj. ");
INSERT INTO zarNT_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Gudixjuʼ nisa zxön luyú ni ca tu lariʼ nabagaʼ le, ateʼ yöjbagaʼ nísadoʼ naʼ yuguʼ guíʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Buzenuʼ le bach nisa naʼ, ateʼ burúaj, en cateʼ biyö́n chiʼu, bayúdx buzxunnaj nisa naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Gurén yuguʼ lu guíʼa, en bötaj ga naca raʼ yegu, ga bidxintë yöjsóa ga nupóʼo que nisa naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Gudixjuʼ buzáʼ que nísadoʼ ga bitiʼ gaca tödi. Bítiʼrö caz tseajbagaʼ nisa naʼ luyú bidxi. ");
INSERT INTO zarNT_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Runuʼ ga ralaj beaj yuguʼ lëʼe guíʼadoʼ, encaʼ ga taʼdödi yegu ga rö́ʼögaca rögaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Yudzu yuguʼ yegu naʼ nisa të́ʼajbaʼ böaʼ guixiʼ, le rugúa yöl-laʼ ribídx quégacabaʼ burro taʼdásibaʼ laʼ guixiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Yuguʼ raʼ yegu rö́ʼögaca yaga ga tuʼdxíabaʼ biguínnidoʼ xcáʼagacabaʼ, en túl-labaʼ yuguʼ lu niʼa në́ʼeguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Rigúʼu nisa guiö́j quiuʼ yuguʼ lu guíʼa, en runuʼ ga tuʼhuöla tuʼdzéʼe yuguʼ le dzöʼö luyú. ");
INSERT INTO zarNT_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Runuʼ ga rizxö́n yö le tágubaʼ böaʼ bëdx, en yuguʼ cuan guixiʼ tuʼgún dxin bönachi, le ilagu niʼa que le nudóʼo luyú, ");
INSERT INTO zarNT_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","en xisi uva le run ga tudzeja ládxiʼguequi, en za olivo le taʼgúʼu láhuiguequi lu yöl-laʼ ruzíʼ xibé quéguequi, en yöta le nabániguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Tuʼzíʼ xibé nisa guiö́j yaga cedro dzöʼö lu guíʼa Líbano, yuguʼ yaga naʼ budóʼo, Xantuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Niʼ tuʼdxiabaʼ biguínni xcáʼagacabaʼ, ateʼ tunbaʼ biyúz lídxigacabaʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Nunuʼ Liʼ yuguʼ guíʼa sibi ga dzö́ʼöbaʼ bdxinaʼ guixiʼ, encaʼ yuguʼ zxan bulóaj gapa tapa chiʼi cuíngacabaʼ bizxidxuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Benuʼ beoʼ le naca bëʼ yuguʼ beoʼ que iz, ateʼ ribía gubidza ga ral-laʼ cuía. ");
INSERT INTO zarNT_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Benuʼ chiʼi dzö́ʼölö, en cateʼ naca chul-la taʼrúajbaʼ taʼdabaʼ böaʼ guixiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Taʼbö́dxiʼabaʼ bëdxi guíxiʼdoʼ, taʼzóa réguʼbaʼ le ilaʼzönbaʼ. Tuʼguílajbaʼ le nuzóëʼ Dios ilágubaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Cateʼ rilén gubidza tuʼdxinbaʼ lídxigacabaʼ, en röjö́xagacabaʼ yuguʼ lu zxan bulóaj quégacabaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Níʼirö taʼrúaj bönachi söjaca huen dxin, en tun caz dxin ga ridxintë ribía gubidza. ");
INSERT INTO zarNT_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","Xan, ziántërö yuguʼ le nunuʼ Liʼ. Len yöl-laʼ réajniʼi zxön quiuʼ nunuʼ yúguʼtë. Nalí luyú yödzölió ni yuguʼ le dxiʼa nunuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Niʼ zoa nisa nácatërö zxön, ga naʼ nacuáʼabaʼ böaʼ guizxi yu, böaʼ cuidiʼ, encaʼ böaʼ zxön. ");
INSERT INTO zarNT_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Niʼ taʼdödi barco zxön, encaʼ böaʼ zxön lëbaʼ leviatán, böaʼ naʼ nuzóa cazuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Yúguʼtëbaʼ taʼbö́zabaʼ Liʼ, cateʼ idxinrö ugaguʼ légacabaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Rugaguʼ légacabaʼ, ateʼ tágubaʼ. Runödzjuʼ le ilágubaʼ, ateʼ tuʼhuö́laj taʼdzéʼebaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Cateʼ ruhuecjuʼ quiuʼ, tádxibaʼ, en cateʼ ruziʼu böʼ quiuʼ, tátibaʼ, en ruhuöáca yu le néquinigacabaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Cateʼ rigúʼu légacabaʼ böʼ, nabángacabaʼ. Rucubuʼ yúguʼtë le nacuáʼ yödzölió. ");
INSERT INTO zarNT_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","¡Ral-laʼ gácaticaʼsö yöl-laʼ ba queëʼ Xanruʼ! ¡Ral-laʼ ilaʼyaza ládxiʼticaʼsö bönachi le nun cazëʼ Lëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Ruyúëʼ Xanruʼ luyú, ateʼ rizxizi. Riganëʼ yuguʼ guíʼa, ateʼ rirúaj dzön. ");
INSERT INTO zarNT_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","¡Gul-laʼ queëʼ Xanruʼ yúguʼtë dza soaʼ ibanaʼ! ¡Gul-laʼ yöl-laʼ ba queëʼ Dios tsanni ni zoaʼ nabanaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","¡Zxixi naca le rizáʼ ládxaʼa ca naca queëʼ! ¡Udzéjalendaʼ-nëʼ Xanruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Ilaʼnítiëʼ bönniʼ dul-laʼ nacuʼë yödzölió ni, en bítiʼrö ilaʼcuáʼ nupa tuáʼ döʼ. ¡Gulúʼu yöl-laʼ ba Xanruʼ, liʼ, böʼ naca cazaʼ! ¡Yöl-laʼ ba Lëʼ Xanruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","¡Guliʼguíëʼ Xanruʼ Dios: “Xclenuʼ”! ¡Buliʼlidzëʼ Lëʼ! ¡Buliʼsiyö́n bönachi ca nácagaca le benëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","¡Guliʼgul-la queëʼ! ¡Guliʼgul-la yöl-laʼ ba queëʼ! ¡Guliʼgüíʼ didzaʼ ca nácagaca le zxön nunëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","¡Buliʼsíʼ xibé Lëʼ láʼayi! Ral-laʼ uluʼdzeja ladxiʼ yúguʼtë nupa taʼguilaj Xanruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Guliʼguiljëʼ Xanruʼ, encaʼ yöl-laʼ huáca queëʼ. Guliʼgüíʼ ládxiʼticaʼsö idxinliʼ lahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","5","Guliʼtsöjné le nácagaca zxön benëʼ Lëʼ, lë naʼ tun ga rubániruʼ, encaʼ ca nácagaca didzaʼ bëʼë cateʼ buchiʼa busörö́ëʼ bönachi, ");
INSERT INTO zarNT_vpl VALUES ("PS105_6","020_105_6","PSA","105","6","6","libíʼiliʼ, zxíʼini xiʼsóëʼ Abraham, huen dxin queëʼ Dios, en libíʼiliʼ, zxíʼini xiʼsóëʼ Jacob, nácaliʼ nupa gurö́ cazëʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Lëʼ náquiëʼ Xanruʼ Dios. Idútë yödzölió naca bëʼ ca buchiʼa busörö́ëʼ bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Röjnétiquiʼsinëʼ didzaʼ dzaga nunëʼ, didzaʼ naʼ gunná bëʼë ilaʼzíʼ lu náʼagaquiëʼ chi gayuáʼ cöʼ zxíʼini xiʼsóëʼ Abraham, ");
INSERT INTO zarNT_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","didzaʼ dzaga naʼ bénlenëʼ Abraham, le naca didzaʼ naʼ benëʼ tsutsu Dios ca gunëʼ queëʼ Isaac. ");
INSERT INTO zarNT_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Níʼirö benëʼ tsutsu didzaʼ naʼ lahuëʼ Jacob, le naca tu le rinná béʼenëʼ lëʼ gunëʼ, para gaca quégaca bönachi Israel tu didzaʼ dzaga le zoa tsaz. ");
INSERT INTO zarNT_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","Gunnë́ʼ: “Gunnaʼ queë́liʼ xiyúgaca bönachi Canaán, le guequi tsaz queë́liʼ, en quégaca zxíʼini xiʼsóaliʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Caní gunnë́ʼ Dios cateʼ niʼ gulaʼcuʼë nabábagaquiëʼ bönniʼ Israel. Tu chópasëʼ guláquiëʼ, en guláquiëʼ bönniʼ ziʼtuʼ luyú. ");
INSERT INTO zarNT_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Gulaʼdë́ʼ tu iaʼtú yödzö izáʼa. Buluʼzë́ʼë tu ga nu gunná bëʼ, en bilaʼdxínëʼ ga nacuáʼ bönachi izáʼa, ");
INSERT INTO zarNT_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","pero bitiʼ bëʼë lataj Dios nu usacaʼ ziʼ bönachi queëʼ naʼ, en buzenëʼ le bach bönniʼ gulaʼnná bëʼë para gulácalenëʼ bönachi queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","Gunnë́ʼ: “Bitiʼ bi gunliʼ quégaca bönachi nabö́ cazaʼ quiaʼ, en bitiʼ bi döʼ guáʼaliʼ quégaquiëʼ bönniʼ tuʼë didzaʼ uláz quiaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Benëʼ ga guyúʼu gubín yödzölió, en benëʼ ga biyadzaj yöta ilahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Gusö́l-lëʼë tubiʼ biʼi bönniʼ, biʼi bidxinbiʼ niʼ zíʼalö ca légaquiëʼ, tuʼ gulútiʼë-biʼ José para gácabiʼ biʼi nadóʼo. ");
INSERT INTO zarNT_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Gulúguiʼë bönniʼ Egipto níʼabiʼ len du guíë, en buluʼdë́ʼë yen náʼabiʼ breguiʼ guíë, ");
INSERT INTO zarNT_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","ga bidxintë dza budxín xtídzëʼë Xanruʼ, tuʼ guzxíʼ bëʼë Xanruʼ Dios José naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Níʼirö gusö́l-lëʼë bönniʼ gunná bëʼë luyú Egipto nu busán-biʼ. Bönniʼ naʼ gunná béʼenëʼ yödzö izáʼa zián busölë́ʼ-biʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Benëʼ ga gúcabiʼ xan yuʼu queëʼ, ateʼ gutaʼ lu náʼabiʼ yúguʼtë le dë queëʼ bönniʼ naʼ rinná bëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","Gutaʼ lu náʼabiʼ gulúʼubiʼ lidxi guíë bönniʼ taʼnná bëʼë tsca rë́ʼëni quézibiʼ, para busédibiʼ bönniʼ gula queëʼ yöl-laʼ réajniʼi. ");
INSERT INTO zarNT_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Níʼirö bilaʼdxín caʼ bönachi Israel luyú Egipto. Caní guca, guzóëʼ Jacob lu xiyúgaca zxíʼini xiʼsóëʼ Ham. ");
INSERT INTO zarNT_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Benëʼ Dios ga gulaʼyántërö bönachi queëʼ luyú niʼ, ateʼ guláquiëʼ ziántërëʼ ca nupa gulaʼdíl-lalen légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Benëʼ Dios ga gulunëʼ ziʼ bönniʼ Egipto bönachi queëʼ. Lu yöl-laʼ banís quégaquiëʼ gulaʼzíʼ yéʼenëʼ nupa naʼ nácagaca huen dxin queëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Níʼirö gusö́l-lëʼë Moisés, huen dxin queëʼ, lógaquiëʼ, encaʼ Aarón, bönniʼ naʼ nabö́ cazëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Gulunëʼ chopëʼ ni zián yöl-laʼ huáca zxön queëʼ Dios lógaca bönachi Egipto naʼ. Gulunëʼ zián yöl-laʼ huáca que yehuaʼ yubá lu xiyúgaca zxíʼini xiʼsóëʼ Ham. ");
INSERT INTO zarNT_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Gusö́l-lëʼë Dios le naca chul-la, ateʼ böáca chul-la lahuiʼ dza, en bitiʼ guca ilaʼdáʼbaguëʼë xtídzëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Benëʼ ga nisa yegu nacuáʼ lu yegu quégaquiëʼ böáca rön, en benëʼ ga gulátibaʼ böla dzö́ʼöbaʼ yuguʼ yegu naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Gulaʼyanbaʼ riu lu xiyúgaquiëʼ, ga bidxintë gulaʼyázabaʼ yuʼu lidxëʼ bönniʼ rinná béʼenëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Bëʼë didzaʼ Dios, ateʼ gulátsjabaʼ bö́tsugayu guizxi yu, en gulátsjabaʼ caʼ bö́ʼiyudoʼ idútë lu xiyúgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Benëʼ ga gurö́ʼö guiö́j böguiʼ yöla sunna uláz que nisa guiö́j, ateʼ böxaj caʼ guíʼ lu xiyúgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Guditsjëʼ yuguʼ lubá uva quégaquiëʼ, en yuguʼ yaga higo, en busunítiëʼ yaga rö́ʼgaca lu xiyúgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Bëʼë didzaʼ, ateʼ bilaʼdxinbaʼ bö́chiʼzu guizxi yu, encaʼ bö́chiʼzu huë́ʼënidoʼ, cuntu nu gaca ulaba légacabaʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","ateʼ gulágubaʼ idútë guixiʼ cuan röʼö lu xiyúgaquiëʼ, en gulágubaʼ caʼ idútë le naz nudáʼagaquiëʼ lu xiyúgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Benëʼ ga gulátibiʼ yúguʼtëbiʼ biʼi bönniʼ lo idútë lu xiyúgaquiëʼ. Biʼi lo naʼ quégaquiëʼ bönniʼ nál-la. ");
INSERT INTO zarNT_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Níʼirö bubéajëʼ Dios yuguʼ bönniʼ Israel luyú naʼ, nuáʼagaquiëʼ dumí plata, en oro, ateʼ cuntu nu yöjcheguʼ nu nutsaʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Buluʼdzeja bönachi Egipto cateʼ buluʼzë́ʼë bönniʼ Israel lu xiyúgaquiëʼ, ateʼ guladxi gulaʼdzöbi tuʼ nö́ziguequinëʼ bönniʼ Israel naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Gusö́l-lëʼë Dios tu böaj le gulúʼu bönachi queëʼ zxul-la, ateʼ chiʼi dzö́ʼölö gusö́l-lëʼë guíʼ le buzeníʼ quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Gulaʼnábinëʼ Lëʼ, ateʼ gusö́l-lëʼë böra guíxiʼdoʼ zián le ilahuëʼ, en benëʼ ga buluʼhuö́laj gulaʼdzéʼenëʼ yöta que yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Buluʼë lahui tu guiö́jtoʼo, ateʼ gulalaj nisa yégudoʼ. Gudödi nisa naʼ luyú bidxi niʼ ca tu nisa yegu gubóʼo. ");
INSERT INTO zarNT_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Caní benëʼ Dios tuʼ yöjnenëʼ didzaʼ láʼayi queëʼ, le guzxíʼ lu nëʼë gunëʼ queëʼ Abraham, huen dxin queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Bubéajëʼ bönachi queëʼ lu yöl-laʼ rudzeja quéguequi, ateʼ lu yöl-laʼ rudzeja quéguequi gulaʼbö́dxiʼa bönachi gurö́ cazëʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Bunödzjëʼ xiyúgaca bönachi yuguʼ yödzö izáʼa quégaquiëʼ. Buluʼziʼë xibé le iláʼ luyú niʼa que dxin gulún bönachi izáʼa naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","Caní benëʼ Dios para ilunëʼ ca rnna le gunná béʼenëʼ légaquiëʼ ilunëʼ, en ilunëʼ ca rinná bëʼ xibá gudixjëʼ Lëʼ. ¡Guliʼcuʼë yöl-laʼ ba Xanruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","¡Guliʼcuʼë yöl-laʼ ba Xanruʼ! ¡Guliʼguíëʼ Xanruʼ: “Xclenuʼ” tuʼ náquiëʼ idú dxiʼa! ¡Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","¿Nuzxi caz gaca quixjöʼ ca nácagaca le zxön nunëʼ Xanruʼ, en uluíʼi lahui ca naca yöl-laʼ ba queëʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","¡Bicaʼ ba nupa tun le naca tsahuiʼ, nupa naʼ túnticaʼsö le naca dxiʼa! ");
INSERT INTO zarNT_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Yöjné nedaʼ, Xan, cateʼ ruzáʼ ládxuʼu quégaca bönachi quiuʼ. Buzáʼ ladxiʼ quiaʼ yöl-laʼ rusölá quiuʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","para gaca iléʼedaʼ gataʼ yöl-laʼ tsahuiʼ quégaca nupa narö́ cazuʼ quiuʼ, en para gaca udzéjalendaʼ bönachi quiuʼ cateʼ tuʼdzeja, en para gaca uzíʼlenaʼ xibé nupa néquiguequi quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Nuntuʼ dul-laʼ ca gulunëʼ xuz xtóʼotuʼ. Biáʼatuʼ döʼ, en bentuʼ le naca xihuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Cateʼ gulaʼcuʼë xuz xtóʼotuʼ luyú Egipto, bitiʼ gulaʼyéajniʼinëʼ le nácagaca zxön benuʼ. Bitiʼ yöjnéguequinëʼ yuguʼ le benuʼ quégaquiëʼ lu yöl-laʼ dxiʼi ladxiʼ quiuʼ, pero gulaʼdáʼbaguëʼë xtídzuʼu cateʼ gulaʼcuʼë raʼ nísadoʼ lë Nísadoʼ Xiná. ");
INSERT INTO zarNT_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Busölë́ʼ Xanruʼ Dios légaquiëʼ para gaca bëʼ runëʼ ca rnna xtídzëʼë, en para uluʼe lahui yöl-laʼ huáca zxön queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Caní guca, buzenëʼ le bach Nísadoʼ Xiná naʼ, ateʼ laʼ gubídxitë. Guchë́ʼë légaquiëʼ ga rëʼdoʼ lu nísadoʼ naʼ, ateʼ gulaʼdë́ʼ lu yu bidxi ga naʼ gurö́ʼö nisa. ");
INSERT INTO zarNT_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Caní guca, busölë́ʼ légaquiëʼ lu naʼ nu naʼ benëʼ légaquiëʼ ziʼ, en buáʼuëʼ légaquiëʼ lu naʼ nu naʼ gudíl-lalen légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Níʼirö gubagaʼ nísadoʼ naʼ nupa gulaʼsí reguʼ légaquiëʼ. Cuntu nu bugáʼana nu bidzaga léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Níʼirö gulaʼyéajlëʼ bönachi queëʼ xtídzëʼë, ateʼ gulul-la yöl-laʼ ba queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Pero laʼ gulál-latë ládxiʼgaquiëʼ yuguʼ le benëʼ. Bitiʼ gulaʼnábinëʼ Lëʼ uluíʼinëʼ légaquiëʼ le ral-laʼ ilunëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Zián le gulaʼzë́ ládxëʼë cateʼ niʼ gulaʼcuʼë laʼ guixiʼ ga dë lataj, en gulaʼzíʼ bëʼë Dios laʼ guixiʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Níʼirö bëʼë Dios quégaquiëʼ le gulaʼnábinëʼ Lëʼ, pero gusö́l-lëʼë quégaquiëʼ tu yödzöhuë́ʼ le bëti ziángaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Cateʼ buluʼzxéʼenëʼ Moisés ga niʼ gulaʼcuʼë tsözxö́n, en buluʼzxéʼenëʼ caʼ Aarón, bönniʼ nubéajëʼ Xanruʼ quez queëʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","laʼ náʼasö guyalaj luyú, en bucachiʼ Datán. Bucachiʼ caʼ nupa gulún tsözxö́n Abiram. ");
INSERT INTO zarNT_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Gulaj tu guíʼ zxön ga naʼ nudúbigaquiëʼ, en buzeguiʼ nupa naʼ guluáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Lu guíʼa Horeb gulunëʼ tu bë́dxidoʼ néquinibaʼ oro, en gulaʼyéaj ládxëʼë budóʼ oro naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Caní guca buluʼcáʼanëʼ Dios nayë́pisëtërëʼ, para gulaʼyéaj ládxëʼë budóʼ oro le naca ca tu bëdxi rágubaʼ guixiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Gulal-la ládxëʼë Dios Nu busölá légaquiëʼ. Lëʼ benëʼ zián le zxön le gulácalen légaquiëʼ luyú Egipto. ");
INSERT INTO zarNT_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","Benëʼ zián le tun ga rubániruʼ lu xiyúgaca zxíʼini xiʼsóëʼ Ham, en zián le tun ga rádxiruʼ Lëʼ le benëʼ raʼ Nísadoʼ Xiná. ");
INSERT INTO zarNT_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Que lë ni naʼ gunnë́ʼ Dios usunítiëʼ légaquiëʼ, ateʼ laʼ cáʼasö gunëʼ laʼtuʼ cabí guzuínëʼ Moisés, bönniʼ rö queëʼ, lahuëʼ Lëʼ, en buzóa dxíëʼ yöl-laʼ rilé queëʼ para cabí usunítiëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Níʼirö bitiʼ gulë́ʼënëʼ ilaʼyáziëʼ luyú dxiʼa naʼ dë lógaquiëʼ tuʼ cabí gulaʼyéajlëʼë xtídzëʼë Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Gulaʼnnë́ ziʼë queëʼ Dios gapa naca lu yuʼu guídi quégaquiëʼ, en bitiʼ buluʼzë́ náguiëʼ chiʼë Xanruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Que lë ni naʼ benëʼ tsutsu Dios xtídzëʼë le bë́ʼlenëʼ légaquiëʼ, gunnë́ʼ gunëʼ ga ilátiëʼ ga naʼ naca laʼ guixiʼ ga dë lataj. ");
INSERT INTO zarNT_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","Gunnë́ʼ gunëʼ ga ilasi lásiëʼ zxíʼini xiʼsóagaquiëʼ ladaj zián yödzö izáʼa, en gúsiëʼ légaquiëʼ gapa nacuáʼ bönachi ziʼtuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Níʼirö buluʼdödi cuíngaquiëʼ lu naʼ budóʼ guíë lë Baal-peor, en gulahuëʼ xipë́laʼgacabaʼ böaʼ guixiʼ gulútiëʼ-baʼ para gulunëʼ zxön yuguʼ dios nati. ");
INSERT INTO zarNT_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Caʼ guca, gulún lenëʼ Dios niʼa que le gulunëʼ, ateʼ gulén tu yödzöhuë́ʼ zxön ládjagaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Níʼirö guzuínëʼ Finees, en benëʼ le raza ládxëʼë Dios, ateʼ guzóa dxi yödzöhuë́ʼ zxön naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Buzóëʼ Dios queëʼ Finees naʼ náquiëʼ tsahuiʼ niʼa que lë naʼ benëʼ le nuzóëʼ tsaz ca naca queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Lëscaʼ gulún lenëʼ Dios ga naʼ zoa nisa lë Meriba, ateʼ Dios gulénëʼ Moisés tuʼ nözi lë naʼ gulunëʼ ");
INSERT INTO zarNT_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","tuʼ gulaʼdáʼbaguëʼë xtidxëʼë Böʼ Láʼayi queëʼ, ateʼ Moisés, lu yöl-laʼ ridzáʼa queëʼ, gunnë́ lizëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Bitiʼ buluʼsunítiëʼ bönachi tuáʼ döʼ gulaʼcuáʼ lu yu ni, ca naʼ gunná béʼenëʼ Xanruʼ légaquiëʼ ilunëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","Gulunëʼ léguequi tsözxö́n en bilaʼzë́dëʼ ilunëʼ ca gulún bönachi naʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","ateʼ gulaʼyéaj ládxëʼë budóʼ guiö́j budóʼ yaga quéguequi, le guca quégaquiëʼ ca tu du yalaj le guzxö́n légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Gulútiëʼ-biʼ zxíʼinigaquiëʼ lógaca böʼ xihuiʼ, yuguʼ biʼi bönniʼ, en nigúladoʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","en buluʼlaljëʼ xichö́ngaca nupa bitiʼ bi nabágaʼgaca tuʼ buluʼlaljëʼ xichö́ngacabiʼ biʼi bönniʼ quégaquiëʼ, en biʼi nigula quégaquiëʼ, yuguʼ biʼi naʼ gulútiëʼ-biʼ lógaca budóʼ guiö́j budóʼ yaga nacuáʼ luyú Canaán, ateʼ gúcadaʼ xihuiʼ luyú ni tuʼ nözi rön naʼ buluʼlaljëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Caʼ guca, guláquiëʼ xihuiʼ niʼa que le gulunëʼ. Guláquiëʼ ca tu nigula udá dzaga tuʼ buluʼcáʼanëʼ Dios quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Que lë ni naʼ gulédeʼenëʼ Xanruʼ Dios bönachi queëʼ, en bitiʼ biléʼenëʼ dxiʼa nupa naʼ néquiguequi queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Níʼirö budödëʼ légaquiëʼ lu náʼagaca bönachi zián yödzö izáʼa, ateʼ nupa buluʼdíʼi légaquiëʼ gulaʼnná beʼe légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Nupa naʼ bitiʼ bilaʼléʼe légaquiëʼ dxiʼa gulundaʼ légaquiëʼ dxin, en buluʼzxicaj légaquiëʼ lu yöl-laʼ unná bëʼ quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Zián luzuí gúʼunëʼ Dios usölë́ʼ légaquiëʼ, pero gulaʼdáʼbaguëʼë le rë́ʼënëʼ ilunëʼ, ateʼ guzxö́ntërö xiguiaʼ nabágaʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Biléʼenëʼ Dios yöl-laʼ bayechiʼ quégaquiëʼ en biyönnëʼ taʼbödxi yechë́ʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","Yöjnenëʼ didzaʼ dzaga núnlenëʼ légaquiëʼ, ateʼ bubequi lahuëʼ quégaquiëʼ tuʼ nazxö́ntërö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","Benëʼ Dios ga buluʼhuéchiʼ ladxiʼ légaquiëʼ nupa naʼ gulaʼchë́ʼ légaquiëʼ nadzúngaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","¡Busölá netuʼ, Xantuʼ Dios! Guléaj netuʼ ládjagaca yödzö izáʼa para guíëtuʼ Liʼ: “Xclenuʼ” niʼa que Loʼ láʼayi, en lu yöl-laʼ rudzeja zxön queë́tuʼ cúʼutuʼ Liʼ yöl-laʼ ba. ");
INSERT INTO zarNT_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","¡Yöl-laʼ ba Lëʼ Xanruʼ, Dios quégaca bönachi Israel naʼa dza, en yúguʼtë dza siʼ zaca! Ral-laʼ ilaʼnná yúguʼtë bönachi: “¡Caʼ gaca! ¡Guliʼcuʼë yöl-laʼ ba Xanruʼ Dios!” ");
INSERT INTO zarNT_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","¡Guliʼguíëʼ Xanruʼ: “Xclenuʼ” tuʼ náquiëʼ dxiʼa, en tuʼ zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Ral-laʼ ilaʼnná caní nupa naʼ buáʼuëʼ Xanruʼ, nupa naʼ buáʼuëʼ lu náʼagaca nupa gulún léguequi ziʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","en nubéajëʼ léguequi zián lu yödzö izáʼa, sacaʼ ga rilén gubidza, en sacaʼ ga ribía, sacaʼ ga zaʼ böʼ ziaga, en sacaʼ ga ridödi gubidza beoʼ ziaga. ");
INSERT INTO zarNT_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Bal-lëʼ gulaʼdë́ʼ nanítigaquiëʼ laʼ guixiʼ ga dë lataj, en ga niʼ bitiʼ zoa nöza. Bitiʼ guca uluʼdzö́linëʼ tu yödzö ga gaca tsöjcuʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Gulaʼdunëʼ, en gulaʼbidxëʼ nisa, en gudú ládxiʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Níʼirö lu lë naʼ raca quégaquiëʼ buluʼlidzëʼ Xanruʼ, ateʼ busölë́ʼ légaquiëʼ lu zián le gulaʼguíʼi gulaʼzáquëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Guchë́ʼë légaquiëʼ tu laʼ nöza tsahuiʼ, en guchë́ʼë légaquiëʼ tu lu yödzö ga tsöjcuʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Ral-laʼ ilë́ʼ Xanruʼ: “Xclenuʼ” tuʼ nadxíʼinëʼ légaquiëʼ, en tuʼ benëʼ yuguʼ le zxön, gúcalenëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Ruguiʼjëʼ nupa taʼbidxi ladxiʼ, en rugahuëʼ nupa taʼdún le nácagaca dxiʼa queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Bal-lëʼ gulaʼcuʼë ga chul-la, en ga zoa bönadxi ilátiëʼ. Gulaʼdzunëʼ yuguʼ lu du guíë, en gulaʼguíʼi gulaʼzáquëʼë ");
INSERT INTO zarNT_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","tuʼ gulaʼdáʼbaguëʼë xtídzëʼë Xanruʼ Dios, en buluʼzóëʼ tsöláʼalö le riguʼë icja ládxiʼdoʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Tuʼ gulunëʼ bayúdx dxin, gudú ládxiʼgaquiëʼ. Gulaʼdzöʼë lu yu zxan yuaʼ nuáʼagaquiëʼ, ateʼ cuntu nu zoa gácalen légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Níʼirö lu lë naʼ raca quégaquiëʼ buluʼlidzëʼ Xanruʼ, ateʼ busölë́ʼ légaquiëʼ lu zián le gulaʼguíʼi gulaʼzáquëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Bubéajëʼ légaquiëʼ ga naʼ gulaʼcuʼë ga chul-la, en ga guzóa bönadxi ilátiëʼ, ateʼ guditsjëʼ yuguʼ du guíë núgaʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Ral-laʼ ilë́ʼ Xanruʼ: “Xclenuʼ” tuʼ nadxíʼinëʼ légaquiëʼ, en tuʼ benëʼ yuguʼ le zxön, gúcalenëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Ruquínnajëʼ le táʼbagaʼ gapa nu riyaza lidxi guíë le néquiniguequi guíë bronce, en ruzxuzxjëʼ yuguʼ vara néquiniguequi guíë. ");
INSERT INTO zarNT_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Bal-lëʼ gulaʼguíʼi gulaʼzáquëʼë tuʼ gulaʼdáʼbaguëʼë Dios, en tuʼ nözi döʼ guluʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Gulaʼgútiʼnëʼ bítiʼtës laʼ huagu, en gulaʼzóa ilátiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Níʼirö lu lë naʼ raca quégaquiëʼ buluʼlidzëʼ Xanruʼ, ateʼ busölë́ʼ légaquiëʼ lu zián le gulaʼguíʼi gulaʼzáquëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Gusö́l-lëʼë quégaquiëʼ xtídzëʼë, en bunëʼ légaquiëʼ, en busölë́ʼ légaquiëʼ lu yöl-laʼ guti. ");
INSERT INTO zarNT_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Ral-laʼ ilë́ʼ Xanruʼ: “Xclenuʼ” tuʼ nadxíʼinëʼ légaquiëʼ, en tuʼ benëʼ yuguʼ le zxön, gúcalenëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Ral-laʼ ilë́ʼ Dios: “Xclenuʼ”, en bi uluʼnödzjëʼ queëʼ, en lu yöl-laʼ rudzeja quégaquiëʼ ilul-lëʼ ca nácagaca le nunëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Bal-lëʼ gulaʼdödëʼ lahui nísadoʼ yuguʼ lu barco zxön, en gulunëʼ dxin yuguʼ lu nísadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Bilaʼléʼenëʼ yuguʼ le nunëʼ Xanruʼ, en yuguʼ le zxön nucuʼë lu nísadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Bë́ʼësëʼ didzaʼ, ateʼ guyecja böʼ budunuʼ, ateʼ guyasa gudxía nísadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Gulaʼyasa barco ca tu lu guíʼadoʼ nisa, en laʼ bö́tjatë ga röʼö rögaʼ lu nisa naʼ. Tuʼ guzóale̲ʼe̲ bönadxi ilátiëʼ gudú ládxiʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Gulaʼzxíziëʼ, en yöjchéguʼgaquiëʼ ca bönniʼ taʼzúdxinëʼ, ateʼ nítisö guca yöl-laʼ rácadaʼ quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Níʼirö lu lë naʼ raca quégaquiëʼ buluʼlidzëʼ Xanruʼ, ateʼ busölë́ʼ légaquiëʼ lu zián le gulaʼguíʼi gulaʼzáquëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Benëʼ Dios ga guzóa dxisö böʼ budunuʼ naʼ recja, ateʼ guzóa dxi le rasa ridxía lu nísadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Buluʼdzéjanëʼ tuʼ guzóa dxi lu nísadoʼ, en tuʼ guchë́ʼë Dios légaquiëʼ dxiʼa tsáhuiʼdoʼ ga naʼ söjáquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Ral-laʼ ilë́ʼ Xanruʼ: “Xclenuʼ” tuʼ nadxíʼinëʼ légaquiëʼ, en tuʼ benëʼ yuguʼ le zxön, gúcalenëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Ral-laʼ uluʼluʼë lahui yöl-laʼ zxön queëʼ ga nudúbigaca bönachi queëʼ, en ilaʼguʼë Lëʼ yöl-laʼ ba ga nudúbigaquiëʼ bönniʼ gula tuʼchiʼa tuʼsörö́ëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Runëʼ Xanruʼ Dios ga tuʼhuíʼi dërö yuguʼ yegu, encaʼ yuguʼ beaj nisa. ");
INSERT INTO zarNT_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","Ga naca yu yaʼa runëʼ ga ruhuöáca yu bidxi, niʼa que le xihuiʼ nabágaʼgaca nupa nacuáʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Ga naca yu bidxi runëʼ ga ruhuöáca yu nabisa, ateʼ ralaj nisa ga bitiʼ bi nisa guzóa. ");
INSERT INTO zarNT_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Niʼ ruʼë lataj ilaʼcuáʼ nupa taʼdún para ilunëʼ niʼ yödzö ga ilaʼcuʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Tazëʼ yuguʼ le tazëʼ, en tuʼdë́ʼë yuguʼ lubá uva, yuguʼ le taʼbía yödxi yanaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Runëʼ Xanruʼ ga raca dxiʼa quégaquiëʼ, en ga taʼcuáʼbiʼ ziánbiʼ biʼi quégaquiëʼ, en runëʼ ga taʼyanbaʼ böaʼ bëdxi quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Cateʼ yuguʼ bönniʼ unná bëʼ ziʼtuʼ tuʼzxicjëʼ bönachi queëʼ, en tuʼzötjëʼ léguequi, en tuʼsacaʼ ziʼë léguequi, en tuʼë döʼ quéguequi, ");
INSERT INTO zarNT_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","rucáʼanëʼ Dios bönniʼ naʼ dë lu náʼagaquiëʼ cáʼasö, en runëʼ ga taʼdë́ʼ laʼ guixiʼ ga dë lataj, en tu luyú bidxi. ");
INSERT INTO zarNT_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Rusölë́ʼ yuguʼ bönniʼ yechiʼ lu le taʼguíʼi taʼzáquëʼë, en runëʼ ga taʼyanbiʼ zxíʼinigaquiëʼ ca taʼyánbaʼ böʼcuʼ zxílaʼdoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Taʼléʼe lë ni nupa nácagaca tsahuiʼ, en tuʼdzeja, pero bitiʼ bi taʼnná nupa tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Nupa taʼyéajniʼi ral-laʼ saʼ ládxiʼgaca ca nácagaca lë ni, ateʼ iléquibeʼe náquiëʼ Xanruʼ Dios dxiʼi ladxiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","¡Chinabáʼa quiaʼ, Dios! ¡Gul-laʼ quiuʼ! ¡Ön, idú ládxaʼa gul-laʼ yöl-laʼ ba quiuʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","¡Guliʼbán, libíʼiliʼ riguínnaliʼ bihuël-la! ¡Gúl-laruʼ cateʼ niʼ ritö́ yu! ");
INSERT INTO zarNT_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","¡Guíaʼ Liʼ: “Xclenuʼ” Xan, ládjagaca bönachi yuguʼ yödzö izáʼa! ¡Gul-laʼ yöl-laʼ ba quiuʼ lógaca yúguʼtë bönachi! ");
INSERT INTO zarNT_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","¡Zxö́ntërö naca yöl-laʼ dxiʼi ladxiʼ quiuʼ, le ridxintë lúzxiba xitsáʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Buluíʼi lahui lúzxiba yöl-laʼ zxön quiuʼ, Dios, ateʼ lahui yödzölió ni buluíʼi lahui yöl-laʼ beníʼ quiuʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","para usölóʼ netuʼ, bönachi quiuʼ, nupa nadxíʼinuʼ. Len yöl-laʼ huáca zxön quiuʼ busölá netuʼ, en bubíʼi didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Lu lataj láʼayi queëʼ bëʼë didzaʼ Dios, gunnë́ʼ: “Uziʼa xibé, en quísiaʼ xiyúgaca bönachi Siquem, en urixaʼ luyú dë cuiti yegu Sucot. ");
INSERT INTO zarNT_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Nequi quiaʼ xiyúgaca bönachi Galaad, encaʼ xiyúgaca zxíʼini xiʼsóëʼ Manasés. Naca ca tu le rusubín icjaʼ xiyúgaca zxíʼini xiʼsóëʼ Efraín. Naca ga rinná bëʼa xiyúgaca zxíʼini xiʼsóëʼ Judá. ");
INSERT INTO zarNT_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Naca ca tu ga riguibi naʼa xiyúgaca bönachi Moab, ateʼ lu xiyúgaca bönachi Edom chúʼunaʼ lölaʼ. Cö́dxiʼa tuʼ uxicjaʼ bönachi Filistea.” ");
INSERT INTO zarNT_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","¿Nuzxi caz gaca ichë́ʼ nedaʼ lu yödzö dë zöʼö idú gásibiʼilö le run chiʼi yödzö naʼ? ¿Nuzxi caz gaca ichë́ʼ nedaʼ lu xiyúgaca bönachi Edom? ");
INSERT INTO zarNT_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","¿Naruʼ cabí nusán ládxuʼu netuʼ, Dios? ¿Naruʼ cabí tséajlenuʼ bönniʼ queë́tuʼ röjáquiëʼ gudil-la? ");
INSERT INTO zarNT_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Gúcalen netuʼ cateʼ tíl-lalentuʼ nupa dutíl-lalen netuʼ, tuʼ naca dádusö gácalen netuʼ nu naca bönáchisö. ");
INSERT INTO zarNT_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Len yöl-laʼ huáca queëʼ Dios idéliʼruʼ tuʼ uxicja cazëʼ Lëʼ nupa taʼdíl-lalen rëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Riguʼa Liʼ yöl-laʼ ba, Xanaʼ Dios. Bitiʼ suʼ dxisö, ");
INSERT INTO zarNT_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","tuʼ taʼnná quiaʼ nupa tuáʼ döʼ, en taʼzíʼ yëʼ. Lu yöl-laʼ rizíʼ yëʼ quéguequi tuíʼi didzaʼ le tuʼzeguiʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Nagúʼugaca nedaʼ lë́ʼajlö, en lu yöl-laʼ bitiʼ riléʼe nedaʼ dxiʼa tuíʼiticaʼsö didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Sal-laʼ nadxíʼidaʼ léguequi, tuʼzeguiʼ nedaʼ didzaʼ, pero nedaʼ rulidzaʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Benaʼ quéguequi le naca dxiʼa, pero buluʼbíʼi quiaʼ le naca döʼ. Nadxíʼidaʼ léguequi, pero bitiʼ taʼléʼe nedaʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Buzóa tu bönniʼ huíaʼ döʼ para uchiʼa usörö́ëʼ que nu naʼ bitiʼ riléʼe nedaʼ dxiʼa. Ben ga soa gagu nu uzeguiʼ nu naʼ didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Cateʼ nu uchiʼa usörö́ bönniʼ naʼ, bitiʼ guʼu lataj urúajëʼ dxiʼa. Buyú le rinábinëʼ Liʼ tsca naca dul-laʼ nabáguëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Ben ga ilaca nabábasö dza soëʼ ibanëʼ. Ben ga tsuʼu nu yúbölö uláz queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Ben ga ilácabiʼ zxíʼinëʼ biʼi uzëbi, en ga gácanu nigula queëʼ nigula uzëbi. ");
INSERT INTO zarNT_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Ben ga ilaʼdásöbiʼ zxíʼinëʼ ilaʼnábibiʼ nu bi unödzaj quégacabiʼ. Ben ga ilaʼguíljabiʼ le ilágubiʼ ziʼtuʼ ga zoa lídxigacabiʼ le nadachi. ");
INSERT INTO zarNT_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Ben ga ugúa nu bi benna lëʼ tu chíʼisö idútë le dë queëʼ, en ben ga ilaʼbanëʼ bönniʼ ziʼtuʼ le ruláʼ dxin runëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Ben ga bitiʼ soa nu huéchiʼ ladxiʼ lëʼ, en bitiʼ soa nu uzáʼ ladxiʼ quégacabiʼ zxíʼinëʼ nácagacabiʼ biʼi uzëbi. ");
INSERT INTO zarNT_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Ben ga udxi quégaca zxíʼini xiʼsóëʼ, en ga idxín dza bítiʼrö soa nu siʼ la ca guzxíʼi lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Yöjnéticaʼsö le xihuiʼ gulaʼbáguëʼë xuz xtáʼahuëʼ, Xan, en bitiʼ gal-la ládxuʼu dul-laʼ bennu xinë́ʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Ben ga ilaʼcuáʼticaʼsö dul-laʼ naʼ loʼ Liʼ, Xan, para cabirö nu soa yödzölió nu tsöjné lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Bitiʼ buéchiʼ ládxëʼë luzë́ʼë, pero gudxía nahuëʼ nupa gulaʼguíʼi gulaʼzacaʼ, en nupa gulaʼyadzaj gulaʼyudxi, encaʼ nupa gulaʼsëbi ladxiʼ, ateʼ bë́tiëʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Bidxíʼinëʼ le rudxía luzë́ʼë döʼ. Ben ga uluʼbíʼi caʼ queëʼ. Bitiʼ raza ládxëʼë gaca dxiʼa que luzë́ʼë. Ben ga bitiʼ gaca dxiʼa queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Gulaca ca zxëʼ nácuëʼ didzaʼ xihuiʼ bëʼë, ateʼ gulaʼyaza le nayáʼ nabanëʼ ca nisa, en gulaʼyúʼu caʼ dxita queëʼ ca le za. ");
INSERT INTO zarNT_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Ben ga ilaca queëʼ ca tu lariʼ rixóa cúdzëʼë, en ca xipanëʼ rúguiʼë lëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Bubíʼi caní quégaca nupa tuʼzeguiʼ nedaʼ didzaʼ, Xan, encaʼ quégaca nupa tuíʼi didzaʼ ziʼ que böʼ naca cazaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Liʼ, Xanaʼ Dios, ben quiaʼ le naca dxiʼa para gaca bëʼ runuʼ ca rnna xtídzuʼu. Tuʼ naca dxiʼa yöl-laʼ dxiʼi ladxiʼ quiuʼ, busölá nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Riguíʼi rizácaʼa, en riyadzaj riyúdxidaʼ, en raca ziʼ ládxiʼdaʼahuaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Ridödi quiaʼ ca raca que tu zxul-la cateʼ ribía gubidza. Nacaʼ ca tubaʼ bö́chiʼzu, richë́ʼ böʼ recja lëbaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Taʼcuidiʼ zxibaʼ tuʼ runaʼ gubasa. Nadxitaʼ, en bítiʼrö röʼö za lu bëlaʼ rön quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Nupa bitiʼ taʼléʼe nedaʼ dxiʼa tuʼtitaj nedaʼ. Cateʼ taʼléʼe nedaʼ, tuʼtá ícjaguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Gúcalen nedaʼ, Xanaʼ Dios. Lu yöl-laʼ dxiʼi ladxiʼ quiuʼ busölá nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Ben ga iléquibeʼe rácalen cazuʼ nedaʼ. Nun cazuʼ Liʼ lë ni, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Tuʼdxía nedaʼ döʼ, pero Liʼ, ben ga gaca dxiʼa quiaʼ. Cateʼ ilaʼyasëʼ, uluʼtuíʼinëʼ, pero udzéjadaʼ nedaʼ, huen dxin quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Ben ga uluʼgáʼana cáʼasö nupa tuʼzeguiʼ nedaʼ didzaʼ, en ben ga gaca yöl-laʼ rutuíʼi quéguequi ca tu lariʼ nabagaʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Len ruáʼ cuinaʼ, zián luzuí guíaʼ-nëʼ Xanruʼ: “Xclenuʼ”, en ladaj bönachi zián cuʼa Lëʼ yöl-laʼ ba, ");
INSERT INTO zarNT_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","tuʼ zuínëʼ cuita lëʼe ibëla nu riyadzaj riyudxi para usölë́ʼ nu naʼ lu náʼagaca nupa tuʼsiúdxi böʼ naca caz nu naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Xanruʼ Dios gudxëʼ Xanaʼ: “Guröʼi cuita lëʼa ibëla cateʼ gunraʼ ga uluʼzechu zxíbigaca loʼ nupa bitiʼ taʼléʼe Liʼ dxiʼa.” ");
INSERT INTO zarNT_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Ga zoëʼ yödzö Sión gusö́l-lëʼë Xanruʼ yöl-laʼ unná bëʼ quiuʼ, gunnë́ʼ: “Gunná beʼe nupa bitiʼ taʼléʼe Liʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Uluʼdödi cuínguequi lu noʼo bönachi quiuʼ cateʼ siʼu yöl-laʼ unná bëʼ quiuʼ tuʼ napuʼ yöl-laʼ lachi que le naca láʼayi.” Ilaʼcuáʼ biʼi bönniʼ ga zuʼ ca ribö́ʼö buzén zíladoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Runëʼ tsutsu xtídzëʼë Xanruʼ, en bitiʼ utsë́ʼë le, rnnëʼ: “Tsaz nacuʼ bixúz ca naʼ gúquiëʼ Melquisedec bixúz.” ");
INSERT INTO zarNT_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Zoa cazëʼ Xanruʼ cuita lëʼu ibëla. Ucul-lëʼ bönniʼ taʼnná bëʼë cateʼ idxín dza usiúdxëʼ luyú. ");
INSERT INTO zarNT_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Uchiʼa usörö́ëʼ quégaca bönachi yúguʼtë yödzö izáʼa, ateʼ ilí yödzölió len bëlaʼ rön quéguequi. Uzötjëʼ nupa taʼnná bëʼ zián lu yödzö izáʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Guíʼjëʼ nisa beaj raʼ nöza, en niʼa que lë ni huöáca ládxëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","¡Guliʼcuʼë yöl-laʼ ba Xanruʼ! Idú ládxaʼa reaʼ-nëʼ Xanruʼ: “Xclenuʼ.” Runaʼ caní tsazxö́n len bönniʼ tsahuiʼ zián ga naʼ nudúbigaca bönachi queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Zxön nácagaca le nunëʼ Xanruʼ. Yúguʼtë nupa taʼyaza ládxiʼgaca lë naʼ benëʼ tuʼsëda ca nácagaca. ");
INSERT INTO zarNT_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Idútë dxiʼa nácagaca, en nayë́pisëtërögaca le nunëʼ Lëʼ, ateʼ idiáʼticaʼsö le naca tsahuiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Chinunëʼ ga tsöjneruʼ yuguʼ le benëʼ, le tun ga rubániruʼ. Náquiëʼ Xanruʼ dxiʼi ladxiʼ, en ruíʼi ládxëʼë rëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Rugahuëʼ nupa tadxi Lëʼ. Röjnéticaʼsëʼ didzaʼ dzaga núnlenëʼ bönachi queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Buzéajniʼinëʼ bönachi queëʼ ca naca yöl-laʼ huáca quégaca le nunëʼ, le benëʼ ga gulaʼdéliʼnëʼ xiyúgaca bönachi izáʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Tsahuiʼ, en idútë li nácagaca le núngaca lu nëʼë. Nácagaca tsutsu yúguʼtë xibá gunná bëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Rucuáʼticaʼsëʼ tsutsu xibá queëʼ, en rusudxinëʼ léguequi lu le naca idútë li, en le naca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Gusö́l-lëʼë Nu buáʼuö bönachi queëʼ. Tsaz nuzóëʼ didzaʼ dzaga nunëʼ. Láʼayi, en baʼa ladxiʼ naca Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Lu yöl-laʼ radxi queë́ruʼ Lëʼ risí loruʼ ridéliʼruʼ yöl-laʼ réajniʼi. Yúguʼtë nupa tun ca taʼnná bëʼ xibá queëʼ nápagaca yöl-laʼ réajniʼi. Ilaʼcuáʼticaʼsö nupa ilaʼgúʼu Lëʼ yöl-laʼ ba. ");
INSERT INTO zarNT_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","¡Guliʼcuʼë yöl-laʼ ba Xanruʼ! ¡Bicaʼ ba bönniʼ naʼ rádxinëʼ Xanruʼ, bönniʼ naʼ raza ládxëʼë runëʼ ca gunná bëʼë Dios! ");
INSERT INTO zarNT_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Tsë́pisëgaca zxíʼini xiʼsóëʼ bönniʼ naʼ yödzölió ni. Gáquiëʼ bicaʼ ba bönniʼ naʼ runëʼ le naca dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Lu yuʼu lidxëʼ gataʼ yöl-laʼ tsahuiʼ, ateʼ idíaʼticaʼsö le naca tsahuiʼ runëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Gulén beníʼ ga ridë́ʼ bönniʼ tsahuiʼ ga naʼ naca chul-la. Ruzáʼ ládxëʼë que luzë́ʼë, en ruíʼi ládxëʼë lëʼ, en runëʼ le naca dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Gaca dxiʼa queëʼ bönniʼ ruzáʼ ládxëʼë que luzë́ʼë, en runnëʼ que tu chíʼisö le riyadzaj que. Urúajëʼ dxiʼa cateʼ nu uchiʼa usörö́ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Catu caz gaca nu utsáʼ bönniʼ naʼ, ateʼ sóaticaʼsö nu tsöjné lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Bitiʼ gádxinëʼ cateʼ nu usiyöni lëʼ le cabí raca dxiʼa. Ridipa ládxëʼë tuʼ ruzxöni ládxëʼë Xanruʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Dios rutipëʼ ládxëʼë, ateʼ bitiʼ gádxinëʼ cateʼ idxinrö dza iléʼenëʼ nuhuö́tjagaca nupa taʼdíl-lalen lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Idú ládxëʼë runödzjëʼ quégaca bönachi yechiʼ. Idíaʼticaʼsö le naca dxiʼa runëʼ. Dios uchisëʼ lëʼ ga tsë́pisëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Ilaʼléʼe lë ni nupa tuáʼ döʼ, en ilaʼbö́ʼ baguíʼisö. Ilagu zxe láyiʼgaca, en ilaʼniti cuínguequi. Tsaz initi le taʼzë́ ládxiʼgaca nupa tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","¡Guliʼcuʼë yöl-laʼ ba Xanruʼ! ¡Guliʼcuʼë yöl-laʼ ba, libíʼiliʼ huen dxin queëʼ Xanruʼ! ¡Guliʼcúʼu yöl-laʼ ba Lëʼ Xanruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","¡Cúʼuruʼ yöl-laʼ ba Lëʼ Xanruʼ, cateʼ risí lo naʼa, en yuguʼ iz siʼ zaca! ");
INSERT INTO zarNT_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","¡Ga naguelaʼ ga rilén gubidza ga ridxintë ga ribía, cúʼuruʼ yöl-laʼ ba Lëʼ Xanruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","¡Nayë́pisëtërëʼ Xanruʼ Dios ca yúguʼtë yödzö izáʼa! ¡Nazxö́ntërö yöl-laʼ zxön queëʼ ca naca lúzxiba! ");
INSERT INTO zarNT_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","¿Nuzxi caz zoa naca ca náquiëʼ Xanruʼ Dios? Röʼë rinná bëʼë ga naʼ nayë́pisëtërëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","Ruzötaj cuinëʼ para uyúëʼ le dë lúzxiba, en le dë luyú ni. ");
INSERT INTO zarNT_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Ruchisëʼ nupa nácagaca yechiʼ, rubéajëʼ léguequi lu bëchtö yu. Ruchisëʼ nupa taʼyadzaj, rubéajëʼ léguequi lu dö bëbu. ");
INSERT INTO zarNT_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","Runëʼ ga taʼböʼlen nupa taʼnná bëʼ. Taʼböʼlen nupa taʼnná beʼe bönachi queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Runëʼ ga zóanu nigula huödx yuʼu lídxinu. Rudzeja ládxiʼnu tuʼ runëʼ ga nacuáʼabiʼ zxíʼininu. ¡Guliʼcuʼë yöl-laʼ ba Xanruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Cateʼ bilaʼrúaj bönachi Israel luyú Egipto bilaʼrúajëʼ zxíʼini xiʼsóëʼ Judá ladaj nupa tuíʼi didzaʼ izáʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","Zxíʼini xiʼsóëʼ Judá guláquiëʼ ca lidxëʼ Xanruʼ Dios, ateʼ gulaca bönachi Israel nupa rinná béʼenëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Lahuëʼ Dios bubigaʼ nísadoʼ, ateʼ bubíʼi nisa yegu Jordán. ");
INSERT INTO zarNT_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Gulaʼxitiʼ guíʼa zxön ca yuguʼ böʼcuʼ zxilaʼ biguiúʼ, ateʼ gulaʼxitiʼ caʼ guíʼadoʼ ca yuguʼ böʼcuʼ zxílaʼdoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","¿Bi raca quiuʼ, nísadoʼ, tuʼ rubiguʼ? ¿Bi raca quiuʼ, yegu Jordán, tuʼ rubíʼi nisa quiuʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","¿Bi raca queë́liʼ, guíʼa zxön, tuʼ rixítiʼliʼ ca yuguʼ böʼcuʼ zxilaʼ biguiúʼ? ¿Bi raca queë́liʼ, guíʼadoʼ, tuʼ rixítiʼliʼ ca yuguʼ böʼcuʼ zxílaʼdoʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Guzxizi lahuëʼ Xanruʼ, yödzölió. Guzxizi lahuëʼ Dios queëʼ Jacob. ");
INSERT INTO zarNT_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Benëʼ Dios ga gulaj nisa tu lëʼe guiö́jtoʼo, en benëʼ ga böáca le guca guiö́j jara tu ga rilén nisa. ");
INSERT INTO zarNT_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Calëga queë́tuʼ, Xan, calëga queë́tuʼ, pero que loʼ gaca yöl-laʼ ba tuʼ nacuʼ dxiʼi ladxiʼ, en le naca idútë li. ");
INSERT INTO zarNT_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","¿Bizx que taʼnná bönachi yuguʼ yödzö izáʼa: “Gazxi caz zoëʼ Dios quégaquiëʼ”? ");
INSERT INTO zarNT_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Zoëʼ Dios queë́ruʼ yehuaʼ yubá. Runëʼ le raza ládxëʼë gunëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Néquiguequini plata, en oro budóʼ quégaca bönachi izáʼa naʼ, yuguʼ le núngaca lu niʼa lu naʼ bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Nacuáʼ ruíʼiguequi, pero bitiʼ gaca iluíʼi didzaʼ. Nacuáʼ guiö́j lógaca, pero bitiʼ gaca ilaʼléʼe. ");
INSERT INTO zarNT_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Nacuáʼ nágagaca, pero bitiʼ gaca ilaʼyöni. Nacuáʼ zxíniguequi, pero bitiʼ gaca ilaʼlëʼe. ");
INSERT INTO zarNT_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Nacuáʼ náʼagaca, pero bitiʼ bi gaca ilaʼgán. Nacuáʼ níʼagaca, pero bitiʼ gaca ilaʼzáʼ. Bitiʼ gaca ilún bö lubáʼagaca. ");
INSERT INTO zarNT_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Nupa tun budóʼ guiö́j budóʼ yaga ilaca ca nácagaca budóʼ naʼ, nútiʼtës nu ruzxöni ladxiʼ budóʼ guiö́j budóʼ yaga. ");
INSERT INTO zarNT_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Libíʼiliʼ, bönachi Israel, buliʼzxöni ládxëʼë Xanruʼ Dios. Rácalen cazëʼ libíʼiliʼ, en rapa chiʼë libíʼiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Libíʼiliʼ, zxíʼini xiʼsóëʼ Aarón, buliʼzxöni ládxëʼë Xanruʼ Dios. Rácalen cazëʼ libíʼiliʼ, en rapa chiʼë libíʼiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Libíʼiliʼ naʼ rádxiliʼ-nëʼ Dios, buliʼzxöni ládxëʼë Xanruʼ Dios. Rácalen cazëʼ libíʼiliʼ, en rapa chiʼë libíʼiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Xanruʼ Dios ruíʼi ládxëʼë rëʼu, en gunëʼ ga gaca dxiʼa queë́ruʼ. Gunëʼ ga gaca dxiʼa quégaca bönachi Israel. Gunëʼ ga gaca dxiʼa quégaca zxíʼini xiʼsóëʼ Aarón. ");
INSERT INTO zarNT_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Gunëʼ ga gaca dxiʼa quégaca nupa tadxi Lëʼ, nupa naʼ nácagaca cáʼasö, en nupa naʼ nayë́pisëgaca. ");
INSERT INTO zarNT_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Gunëʼ Xanruʼ Dios ga tsan le nequi queë́liʼ, lë naʼ nequi queë́liʼ, en le nequi quégaca zxíʼiniliʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Raca ládxaʼa gunëʼ Xanruʼ ga gaca dxiʼa queë́liʼ. Náquiëʼ Nu ben lúzxiba, en luyú ni. ");
INSERT INTO zarNT_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Nequi queëʼ Xanruʼ Dios lúzxiba xitsáʼ, pero nudödëʼ lu náʼagaca bönachi luyú ni. ");
INSERT INTO zarNT_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Nupa chinátigaca bitiʼ gaca ilaʼgúʼu Xanruʼ yöl-laʼ ba, en calëga nupa nacuáʼ dxisö lataj chul-la que yöl-laʼ guti. ");
INSERT INTO zarNT_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","¡Cúʼuruʼ yöl-laʼ ba Xanruʼ Dios naʼa dza, en yúguʼtë dza siʼ zaca! ¡Guliʼcuʼë Xanruʼ yöl-laʼ ba! ");
INSERT INTO zarNT_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Nadxíʼidaʼ-nëʼ Xanruʼ Dios, tuʼ riyönnëʼ le rulidzaʼ Lëʼ, en le rinábidaʼ-nëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Ruzë́ naguëʼ chiʼa. Que lë ni naʼ ulidzaʼ Lëʼ tsanni ni zoaʼ nabanaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Guzóa bönadxi quiaʼ gátiaʼ, en guyuʼa tsöbi que lataj chul-la que yöl-laʼ guti, ateʼ gusëbi ládxaʼa, en buíʼinideʼedaʼ ládxaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Níʼirö bulidzaʼ-nëʼ Xanruʼ Dios, gunníaʼ: “Rátaʼyuaʼ loʼ, Xan, usölóʼ nedaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Xanruʼ Dios ruzáʼ ládxëʼë queë́ruʼ, en náquiëʼ tsahuiʼ. Dios queë́ruʼ ruíʼi ládxëʼë rëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Rapa chiʼë Xanruʼ nupa nácagaca doʼ ladxiʼ. Buluʼxicja bönachi nedaʼ, ateʼ busölë́ʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Buzíʼ ladxiʼ böʼ naca cazaʼ, tuʼ runëʼ Xanruʼ Dios ga raca dxiʼa quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Busölóʼ böʼ naca cazaʼ, Xan, lu yöl-laʼ guti. Benuʼ ga buíʼi nisa ribödxi guiö́j lahuaʼ, en ga bítiʼrö cuílagaca niʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Taʼa lahuëʼ Xanruʼ Dios ga nacuáʼ nupa nabángaca. ");
INSERT INTO zarNT_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Guyéajlëʼa Lëʼ cateʼ gunníaʼ: “Zoa le rusacaʼ nedaʼ ziʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Lu yöl-laʼ röʼ böniga quiaʼ gunníaʼ: “Taʼzíʼ yëʼ yúguʼtë bönachi.” ");
INSERT INTO zarNT_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","¿Bizxi caz guʼa-nëʼ Xanruʼ Dios niʼa que yuguʼ le runëʼ le ruziʼa xibé? ");
INSERT INTO zarNT_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Siʼ lu naʼa yöl-laʼ rusölá queëʼ Xanruʼ, en ulidzaʼ-nëʼ Xanruʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Unödzjaʼ queëʼ Xanruʼ le guzxíʼ lu naʼa unödzjaʼ. Raca ládxaʼa gaca gunaʼ caní lógaca yúguʼtë bönachi queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Rúndëʼë Xanruʼ bal yöl-laʼ guti quégaca nupa néquiguequi quez queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","Le nácatë nacaʼ huen dxin quiuʼ, Xan. Nacaʼ huen dxin quiuʼ, encaʼ zxíʼininu nigula huen dxin quiuʼ. Busedxuʼ le biröli nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Cuʼa loʼ le unödzjaʼ quiuʼ, en guíaʼ Liʼ: “Xclenuʼ”, en ulidzaʼ Liʼ, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Unödzjaʼ queëʼ Xanruʼ le guzxíʼ lu naʼa unödzjaʼ. Raca ládxaʼa gaca gunaʼ caní lógaca yúguʼtë bönachi queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","Ga zoa löʼa que yuʼu lidxëʼ Xanruʼ, lu yödzö Jerusalén gunaʼ caní. ¡Guliʼcuʼë yöl-laʼ ba Xanruʼ Dios! ");
INSERT INTO zarNT_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","¡Guliʼcuʼë yöl-laʼ ba Xanruʼ Dios, libíʼiliʼ, bönachi yúguʼtë yödzö izáʼa! ¡Guliʼcuʼë yöl-laʼ ba yúguʼtëliʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","tuʼ buxönëʼ queë́ruʼ yöl-laʼ dxiʼi ladxiʼ queëʼ, en zóaticaʼsö le naca idú ladxiʼ queëʼ! ¡Yöl-laʼ ba Lëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","¡Guliʼguíëʼ Xanruʼ: “Xclenuʼ”, tuʼ náquiëʼ dxiʼa! ¡Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Ral-laʼ ilaʼnná bönachi Israel: “¡Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ!” ");
INSERT INTO zarNT_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Ral-laʼ ilaʼnná zxíʼini xiʼsóëʼ Aarón: “¡Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ!” ");
INSERT INTO zarNT_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Ral-laʼ ilaʼnná nupa tadxi Xanruʼ Dios: “¡Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ!” ");
INSERT INTO zarNT_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Cateʼ gudíʼi guzxácaʼa bulidzaʼ-nëʼ Xanruʼ, ateʼ bubiʼë didzaʼ, en busölë́ʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Zoëʼ Xanruʼ cuitaʼ nedaʼ, ateʼ bitiʼ bi gádxidaʼ. ¿Bizxi caz gaca ilún bönachi quiaʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Zoëʼ Xanruʼ cuitaʼ nedaʼ ladaj nupa tácalen nedaʼ. Que lë ni naʼ idéliʼdaʼ láhuigaca nupa bitiʼ taʼléʼe nedaʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Nácarö dxiʼa uzxöni ládxaʼa-nëʼ Xanruʼ, en bitiʼ uzxöni ládxaʼa nu naca bönáchisö. ");
INSERT INTO zarNT_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Nácarö dxiʼa uzxöni ládxaʼa-nëʼ Xanruʼ, en bitiʼ uzxöni ládxaʼa nupa taʼnná bëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Bönachi yúguʼtë yödzö izáʼa gulaʼgúʼu nedaʼ lë́ʼajlö. Len yöl-laʼ huáca queëʼ Xanruʼ buxicjaʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Gulaʼguʼë nedaʼ lë́ʼajlö. Ön, gulaʼguʼë nedaʼ lë́ʼajlö, pero len yöl-laʼ huáca queëʼ Xanruʼ buxicjaʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Gulaʼguʼë nedaʼ lë́ʼajlö ca yuguʼ buzúʼ rön, pero gulaʼnítiëʼ ca tu lu guíʼ guixiʼ yötsiʼ bidx. Len yöl-laʼ huáca queëʼ Xanruʼ buxicjaʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Buluʼdxíguëʼë nedaʼ ga bidxintë guzóa tsöjtsöʼa, pero gúcalenëʼ Xanruʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Naca cazëʼ Xanruʼ yöl-laʼ huáca quiaʼ, en le rul-laʼ. Naca cazëʼ yöl-laʼ rusölá quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Lu yuʼu lídxigaca nupa nácagaca tsahuiʼ ruʼu bö que nupa taʼbö́dxiʼa lu yöl-laʼ rudzeja quéguequi tuʼ nulágaca. ¡Rundaʼ dxin nëʼë ibëla Xanruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","¡Nayë́pisëtërö nëʼë ibëla Xanruʼ! ¡Rundaʼ dxin nëʼë ibëla Xanruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Bitiʼ caʼ gátiaʼ, pero soaʼ ibanaʼ, ateʼ usiyöndaʼ bönachi le nunëʼ Xanruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Xanruʼ béndëʼë nedaʼ xiguiaʼ, pero bitiʼ budödëʼ nedaʼ lu yöl-laʼ guti. ");
INSERT INTO zarNT_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Guliʼsalaj quiaʼ ga taʼyazëʼ bönniʼ tsahuiʼ. Tsuʼa niʼ, en guíaʼ-nëʼ Xanruʼ: “Xclenuʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Naca lataj ni ga riyaza cazëʼ Xanruʼ Dios. Ilaʼyazëʼ ni bönniʼ tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","¡Guíaʼ Liʼ: “Xclenuʼ” Xan, tuʼ bubiʼu didzaʼ quiaʼ, en tuʼ nacuʼ Nu rusölá nedaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Zoa tu guiö́j buluʼzóëʼ tsöláʼalö bönniʼ tuʼcuʼë zöʼö. Naʼa naca guiö́j naʼ guiö́j len squin zöʼö. ");
INSERT INTO zarNT_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Benëʼ Xanruʼ Dios ga naca caní. Naca tu le run ga rubániruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Dza ni naca dza nunëʼ Xanruʼ Dios. Udzéjaruʼ, en uzíʼiruʼ xibé. ");
INSERT INTO zarNT_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Rátaʼyutuʼ loʼ, Xan, usölóʼ netuʼ. Rátaʼyutuʼ loʼ, Xan, gunuʼ ga gaca dxiʼa queë́tuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Bicaʼ ba bönniʼ naʼ zëʼë uláz queëʼ Xanruʼ. Guntuʼ Liʼ zxön lu yuʼu lidxëʼ Xanruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Dios náquiëʼ Xanruʼ, ateʼ bennëʼ queë́ruʼ beníʼ. Buliʼnödzaj queëʼ Dios yuguʼ bëdxi renniʼ uzéguiʼruʼ-baʼ lahuëʼ lu bucugu queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Naca cazuʼ Liʼ Dios quiaʼ, ate guíaʼ Liʼ: “Xclenuʼ.” Naca cazuʼ Liʼ Dios quiaʼ, ateʼ gunaʼ Liʼ zxön. ");
INSERT INTO zarNT_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","¡Guliʼ-guië́ʼ Xanruʼ Dios: “Xclenuʼ” tuʼ náquiëʼ dxiʼa! ¡Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","¡Bicaʼ ba nupa nácagaca idú dxiʼa tsáhuiʼdoʼ, nupa naʼ tun ca rnna xibá naguixjëʼ Xanruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","¡Bicaʼ ba nupa tun ca nácagaca le benëʼ ba nalí, en idú ládxiʼgaca taʼzë́ ladxiʼ Lëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Bitiʼ bi le cabí naca tsahuiʼ tun, pero tun ca nácagaca le nuluʼë lahui. ");
INSERT INTO zarNT_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Nuzúʼ queë́tuʼ xibá quiuʼ, Xan, para idú ládxiʼtuʼ guntuʼ ca taʼnná. ");
INSERT INTO zarNT_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Raca ládxaʼa gúnticaʼsaʼ ca ral-laʼ gunaʼ, en gunaʼ yuguʼ le gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Níʼirö bitiʼ caʼ utuíʼidaʼ channö gapa chiʼa yuguʼ le gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Lu yöl-laʼ baʼa ladxiʼ quiaʼ guíaʼ Liʼ: “Xclenuʼ” cateʼ chinaziʼa le buchiʼa busörö́uʼ le naca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Gunaʼ ca taʼnná le gunná bëʼu. Bitiʼ usán noʼo nedaʼ tsaz. ");
INSERT INTO zarNT_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","¿Nacxi gaca gunbiʼ tu biʼi bönniʼ ga ugáʼana tsahuiʼ ládxiʼdoʼobiʼ? Ral-laʼ gunbiʼ ca rnna xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Idú ládxaʼa rizë́ ládxaʼa Liʼ, Xan. Bitiʼ guʼu lataj ucáʼanaʼ yuguʼ le gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Lu icja ládxiʼdaʼahuaʼ runaʼ ca rnna xtídzuʼu, para cabí gunaʼ dul-laʼ loʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","¡Bicaʼ xibóʼ, Xan! Busedi nedaʼ yuguʼ le gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Len ruáʼ cuinaʼ ruʼa didzaʼ ca nácagaca yúguʼtë le rusedi quézinuʼ netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Rudzéjadaʼ ca nácagaca le nunuʼ ba nalí ca nu rudzeja tuʼ dë yöl-laʼ tsahuiʼ que. ");
INSERT INTO zarNT_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Saʼ ládxaʼa ca nácagaca xibá quiuʼ en güíʼi ládxaʼa yuguʼ le nulúʼu lahui. ");
INSERT INTO zarNT_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Udzéjadaʼ ca nácagaca le gunná bëʼu. Bitiʼ gal-la ládxaʼa xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Ben ga gaca dxiʼa quiaʼ nedaʼ, huen dxin quiuʼ, Xan, para soaʼ ibanaʼ, en gunaʼ ca rnna xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Gusalaj guiö́j lahuaʼ para gaca iléʼedaʼ le tun ga rubánituʼ nazúajgaca lu xibá naguixjuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Zoaʼ yödzölió ca tu bönniʼ ridasö. Bitiʼ ucachuʼu yuguʼ xibá nunuʼ ga bitiʼ gaca iléʼedaʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Yúguʼtë dza ruhuíʼini ládxaʼa tuʼ rizë́ ládxaʼa yuguʼ le nusédinuʼ netuʼ ca ral-laʼ guntuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Ruzenuʼ le bach nupa tun ba zxön cuínguequi, en nupa nudxíagaca döʼ, nupa naʼ tuʼzóa tsöláʼalö yuguʼ xibá gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Bitiʼ guʼu lataj nu guequi nedaʼ ziʼ o nu ucáʼana nedaʼ cáʼasö, tuʼ runaʼ ca taʼnná le nunuʼ ba nalí. ");
INSERT INTO zarNT_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Sal-laʼ taʼbö́ʼ nupa taʼnná bëʼ, en taʼnnë́ quiaʼ, rizáʼ ládxaʼa nedaʼ, huen dxin quiuʼ, ca nácagaca le gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Raza ládxaʼa yuguʼ le nunuʼ ba nalí. Nácagaca le tuʼzéajniʼi nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Nadinni lu yu böʼ naca cazaʼ. Busubán ládxaʼa, ugunuʼ dxin xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Buluíʼidaʼ Liʼ yuguʼ le nunaʼ, ateʼ bubiʼu didzaʼ. Busedi nedaʼ yuguʼ le gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Buzéajniʼi nedaʼ ca nácagaca xibá quiuʼ, ateʼ saʼ ládxaʼa ca nácagaca le nunuʼ, le tun ga rubánituʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Ribödxi böʼ naca cazaʼ tuʼ risë́bidaʼ ládxaʼa. Butipa ládxaʼa, ugunuʼ dxin xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Ben ga bitiʼ gunaʼ le cabí saʼyéaj, en buzáʼ ladxiʼ quiaʼ xibá naguixjuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Gurö́aʼ le naca idútë li para gunaʼ ca rnna. Nuzóaʼ lahuaʼ yuguʼ le nusédinuʼ netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Nazíʼ lu naʼa yuguʼ le nunuʼ lináʼ lo. Bitiʼ guʼu lataj bi gun ga utuíʼidaʼ, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Gunaʼ ca taʼnná xibá gunná bëʼu, tuʼ rutipa cazuʼ ládxaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Busedi nedaʼ, Xan, ca taʼnná le gunná bëʼu, ateʼ gun chiʼa léguequi ga idxinrö dza udxi. ");
INSERT INTO zarNT_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Benna quiaʼ yöl-laʼ réajniʼi para gun chiʼa xibá quiuʼ, en para idú ládxaʼa gunaʼ ca taʼnná. ");
INSERT INTO zarNT_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Ben ga gunaʼ ca taʼnná le gunná bëʼu, tuʼ raza ládxaʼa gunaʼ ca taʼnná xibá naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Ben ga güíʼi ládxaʼa yuguʼ le nunuʼ ba nalí, para cabí güíʼi ládxaʼa yöl-laʼ ruhuidiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Buchiʼa guiö́j lahuaʼ para cabí uyúaʼ le cabí nazacaʼ. Butipa ládxaʼa para gunaʼ le uluíʼinuʼ netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Ben tsutsu didzaʼ bë́ʼlenuʼ nedaʼ, huen dxin quiuʼ, para gádxidaʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Bucuita ga zoaʼ nu rudidzaʼ yudxi nedaʼ, lë naʼ rádxidaʼ tuʼ nácagaca dxiʼa tsahuiʼ le nusédinuʼ netuʼ ca guntuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Buyútsöcaʼ, rizë́ ládxaʼa yuguʼ xibá quiuʼ. Busubán ládxaʼa, ugunuʼ dxin le tsahuiʼ quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Lu yöl-laʼ dxiʼi ladxiʼ quiuʼ buyú nedaʼ, Xan, en busölá nedaʼ ca rnna xtídzuʼu gunuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Ubiʼa didzaʼ bi guíaʼ nu run ga rutuíʼidaʼ, inníaʼ: “Ruzxöni ládxaʼa xtídzuʼu”, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Bitiʼ ucuítuʼ tsaz didzaʼ idútë li lu ruʼa tuʼ runaʼ löza yuguʼ le nusédinuʼ netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Gúnticaʼsaʼ ca taʼnná xibá naguixjuʼ Liʼ yúguʼtë dza, en yúguʼtë iz siʼ zaca. ");
INSERT INTO zarNT_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Lu yöl-laʼ rusölá quiuʼ soaʼ ibanaʼ tuʼ bëʼ ládxaʼa gunaʼ ca taʼnná bëʼ xibá quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Guʼa didzaʼ que le nunuʼ ba nalí lógaquiëʼ bönniʼ taʼnná bëʼë en bitiʼ caʼ utuíʼidaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","Tsaza ládxaʼa yuguʼ xibá gunná bëʼu, yuguʼ lë naʼ nadxíʼidaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Gunaʼ caʼ ca taʼnná xibá nunuʼ, lë naʼ së ládxaʼa, en saʼ ládxaʼa ca nácagaca le gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Yöjné didzaʼ naʼ bë́ʼlenuʼ nedaʼ, huen dxin quiuʼ, tuʼ benuʼ ga runaʼ löza le. ");
INSERT INTO zarNT_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Didzaʼ naʼ ruhuë́ tsahuiʼ nedaʼ cateʼ riguíʼi rizácaʼa, tuʼ tuʼsubán ládxaʼa didzaʼ bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Tuʼtítjalëʼe nedaʼ nupa tun ba zxön cuínguequi, pero bitiʼ caʼ usanaʼ xibá naguixjuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Röjnedaʼ yuguʼ le busédinuʼ netuʼ dza niʼte, Xan, ateʼ lë naʼ ruhuë́ tsahuiʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Lu yöl-laʼ ridzáʼa quiaʼ röʼa böniga niʼa quégaca nupa tuáʼ döʼ, nupa naʼ tuʼcáʼana xibá naguixjuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Rul-laʼ ca nácagaca le gunná bëʼu. Zoaʼ ni ca tu bönniʼ ridë́ʼ ziʼtuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Chiʼi dzö́ʼölö röjnedaʼ Loʼ, Xan, en run chiʼa xibá naguixjuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Nacuáʼlen nedaʼ le ruziʼa xibé ateʼ runaʼ ca rnna yuguʼ xibá quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Nacuʼ Liʼ, Xan, le ruziʼa xibé. Chigunníaʼ gunaʼ ca rnna xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Idú ládxaʼa inábidaʼ Liʼ sóalenuʼ nedaʼ. Buéchiʼ ladxiʼ nedaʼ ca rnna xtídzuʼu gunuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Guzáʼ ládxaʼa ca nácagaca le runaʼ, ateʼ bubíʼi ládxaʼa para gunaʼ ca rnna le nunuʼ lináʼ lo. ");
INSERT INTO zarNT_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Béndaʼa bayúdx, en bitiʼ gudzedaʼ para gunaʼ ca rinná bëʼ xibá quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Bönachi zián bönachi tuáʼ döʼ gulaʼgúʼu nedaʼ lë́ʼajlö, pero bitiʼ gul-la ládxaʼa xibá naguixjuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Gulahuë́la riyasaʼ, en riguʼa Liʼ yöl-laʼ ba tuʼ nácagaca tsahuiʼ yuguʼ le nusédinuʼ netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Runaʼ tsözxö́n nupa tadxi Liʼ, encaʼ nupa tun ca rnna xibá quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Ridxín idútë yödzölió yöl-laʼ dxiʼi ladxiʼ quiuʼ, Xan. Busedi nedaʼ yuguʼ le gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Benuʼ quiaʼ nedaʼ, huen dxin quiuʼ, le naca dxiʼa, ca rnna xtídzuʼu gunuʼ, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Busedi nedaʼ yöl-laʼ réajniʼi idú, en yöl-laʼ raca yenniʼ, tuʼ réajlëʼa yuguʼ xibá gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Zíʼalö cateʼ buzötjuʼ nedaʼ gudáʼ nanitiaʼ, pero naʼa runaʼ ca rnna xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Idú dxiʼa tsahuiʼ nacuʼ, en runuʼ le naca dxiʼa. Busedi nedaʼ yuguʼ le gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Nupa tun ba zxön cuínguequi taʼzíʼ yëʼ ca naca quiaʼ, pero idú ládxaʼa gunaʼ ca rnna xibá quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Chul-la niti naca icja ládxiʼdoʼguequi, pero raza ládxaʼa nedaʼ xibá naguixjuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Naca dxiʼa buzötjuʼ nedaʼ para bizédidaʼ yuguʼ le gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Nácagacarö dxiʼa quiaʼ xibá rinná bëʼu ca nácagaca gayuáʼ gayuáʼsö dumí oro, en plata. ");
INSERT INTO zarNT_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Len noʼo benuʼ nedaʼ, en buzúʼ nedaʼ. Buzéajniʼi nedaʼ para gúnbëʼa xibá gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Nupa tadxi Liʼ ilaʼléʼe nedaʼ, en uluʼdzeja ládxiʼguequi, tuʼ runaʼ löza xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","Nözdaʼ naca tsahuiʼ ca ruchiʼa rusörö́uʼ quiaʼ nedaʼ, Xan, ateʼ lu yöl-laʼ li ladxiʼ quiuʼ busacaʼ ziʼu nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Naʼa, lu yöl-laʼ dxiʼi ladxiʼ quiuʼ buë tsahuiʼ nedaʼ, ca rnna didzaʼ chibë́ʼlenuʼ nedaʼ, huen dxin quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Gudá duhuechiʼ ládxuʼu nedaʼ para soaʼ ibanaʼ, tuʼ raza ládxaʼa xibá naguixjuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Ben ga uluʼtuíʼi nupa tun ba zxön cuínguequi, tuʼ gulaʼnnë́ quiaʼ, en bitiʼ bi benaʼ quéguequi, pero nedaʼ saʼ ládxaʼa ca naca xibá quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Ral-laʼ udxín quiaʼ nupa tadxi Liʼ, nupa naʼ núnbëʼgaca le nunuʼ ba nalí. ");
INSERT INTO zarNT_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Ben ga udxín ca rnna le gunná bëʼu, para cabí utuíʼidaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Rudú ládxaʼa tuʼ ribözaʼ yöl-laʼ rusölá quiuʼ, pero runaʼ löza xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Chirequi ichul-la lahuaʼ tuʼ rizëdaʼ ládxaʼa xtídzuʼu, rnníaʼ: “¿Bátaxi huë tsaúʼu nedaʼ?” ");
INSERT INTO zarNT_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Caní raca tuʼ naxúʼunidaʼ ca tu buzudi guídi nal-laʼ lahui guíʼ, pero catu caz gal-la ládxaʼa yuguʼ le gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","¿Bál-laxi dza soaʼ ibanaʼ nedaʼ, huen dxin quiuʼ? ¿Bátaxi usiúdxuʼ nupa taʼbía no nedaʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Nupa tun ba zxön cuínguequi gulaʼchö́ʼöna tu yeru ga tsöjbixaʼ, nupa naʼ bitiʼ tun ca rnna xibá naguixjuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Idútë li nácagaca yúguʼtë xibá gunná bëʼu. Lu yöl-laʼ rizíʼ yëʼ quéguequi taʼbía no nedaʼ. ¡Gúcalen nedaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Gulaʼzóa uluʼsunítiëʼ nedaʼ lu yödzölió ni, pero bitiʼ busán naʼa xibá quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Lu yöl-laʼ dxiʼi ladxiʼ quiuʼ busubán ládxaʼa, para gapa chiʼa le nunuʼ ba nalí len ruáʼ cuinuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Rulidzaʼ Liʼ, Xan. Tsaz naguixjuʼ xtídzuʼu yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Gunuʼ ca rnna xtídzuʼu quégaca bönachi naʼa dza, en yúguʼtë dza siʼ zaca. Gudixaj cazuʼ yödzölió, ateʼ idíaʼticaʼsö. ");
INSERT INTO zarNT_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Niʼa que le gunná bëʼu nacuáʼ caz yúguʼtë ga ridxintë naʼa dza, tuʼ tun xichinuʼ yúguʼtë lë naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Laʼtuʼ cabí raza ládxaʼa xibá naguixjuʼ Liʼ, chigunítiaʼ lu le busacaʼ ziʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Catu caz gal-la ládxaʼa yuguʼ xibá quiuʼ, tuʼ busubanuʼ ládxaʼa niʼa quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Néquidaʼ quiuʼ. ¡Busölá nedaʼ, tuʼ ruíʼi ládxaʼa xibá quiuʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Nupa tuáʼ döʼ taʼbö́ʼ nisi nedaʼ para uluʼsuniti nedaʼ, pero nedaʼ güíʼi ládxaʼa le nunuʼ ba nalí. ");
INSERT INTO zarNT_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Chibiléʼedaʼ ruúdxi que yúguʼtë le naca idútë yödzölió ni, pero catu caz udxi que le gunná bëʼu guntuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Nadxíʼideʼedaʼ xibá naguixjuʼ Liʼ. Idú dza rizáʼ ládxaʼa ca naca que. ");
INSERT INTO zarNT_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Réajniʼirödaʼ ca nupa taʼdáʼbagaʼ nedaʼ tuʼ ruíʼi ládxaʼa yuguʼ le gunná bëʼu, en tuʼ dáʼticaʼsaʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Réquibeʼerödaʼ ca yúguʼtë nupa tuʼsedi nedaʼ, tuʼ rizáʼ ládxaʼa le nunuʼ ba nalí. ");
INSERT INTO zarNT_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Réajniʼirödaʼ ca yuguʼ bönniʼ gula, tuʼ rapa chiʼa xibá quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Gudapa chiʼi cuinaʼ para cabí gunaʼ le cabí naca tsahuiʼ, en para gunaʼ ca rnna xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Bitiʼ caʼ nucáʼanaʼ yuguʼ le nusédinuʼ netuʼ, le nusedi quézinuʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Bicaʼ zxixi nácagaca xtídzuʼu. Ön, nácagacarö zxixi ca le zxixi que buz. ");
INSERT INTO zarNT_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Tuʼzéajniʼi xibá quiuʼ nedaʼ. Que lë ni naʼ réquidaʼ ziʼ yúguʼtë le cabí naca. ");
INSERT INTO zarNT_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Ca tu beníʼ naca xtídzuʼu ga ridáʼ, en le ruzeníʼ nöza ga ral-laʼ tödaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Guzxíʼ lu naʼa bi gunaʼ, en nunaʼ tsutsu xtídzaʼa. Gapa chiʼa le nusédinuʼ netuʼ le naca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Zoa le rusacaʼ ziʼ nedaʼ. Busubán ládxaʼa, Xan, ugunuʼ dxin xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Guzxíʼ yöl-laʼ ba riguʼa Liʼ len ruʼa, Xan, en buzéajniʼi nedaʼ yuguʼ le nusédinuʼ netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Zóaticaʼsö bönadxi gátiaʼ, pero bitiʼ ral-la ládxaʼa xibá naguixjuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Nupa tuáʼ döʼ buluʼzë́ tu du yalaj le sön nedaʼ, pero bitiʼ bucáʼanaʼ xibá quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Tsaz nazíʼ lu naʼa le nunuʼ ba nalí, ateʼ run ga rudzeja ládxaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Ruíʼi ládxaʼa gúnticaʼsaʼ ca taʼnná le gunná bëʼu. Gunaʼ caní ga idxintë dza udxi. ");
INSERT INTO zarNT_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Réquidaʼ ziʼ nupa nácagaca chopa ladxiʼ, pero nadxíʼidaʼ xibá naguixjuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Nacuʼ ca tu ga rucachiʼ cuinaʼ, en le run chiʼi nedaʼ. Runaʼ löza xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Guliʼcuíta ga zoaʼ, libíʼiliʼ ruáʼaliʼ döʼ, tuʼ gunaʼ ca taʼnná le gunná bëʼë Xanaʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Buzóa nedaʼ tsutsu, ugunuʼ dxin xtídzuʼu, ateʼ soaʼ ibanaʼ. Bitiʼ guʼu lataj utuíʼidaʼ ca naca le runaʼ löza. ");
INSERT INTO zarNT_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Buzóa nedaʼ tsutsu, ateʼ uláʼ, en güíʼiticaʼsaʼ ládxaʼa le gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Nusán noʼo yúguʼtë nupa nusángaca le gunná bëʼu, tuʼ naca yöl-laʼ sinaʼ quéguequi le cabí nazacaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Ugúʼ nupa tuáʼ döʼ luyú ni ca nu rugúa bëbu. Que lë ni naʼ nadxíʼidaʼ le nunuʼ ba nalí. ");
INSERT INTO zarNT_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Rizxizi idútë le nayáʼ nabanaʼ tuʼ rádxidaʼ Liʼ, en rádxidaʼ le gaca cateʼ usiúdxuʼ bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Benaʼ le naca tsahuiʼ, en le naca li. Bitiʼ usán noʼo nedaʼ lu náʼagaca nupa tuʼsacaʼ ziʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Nacuʼ quiaʼ nedaʼ, huen dxin quiuʼ, le naca bëʼ gaca dxiʼa quiaʼ. Bitiʼ guʼu lataj uluʼsacaʼ ziʼ nedaʼ nupa tun ba zxön cuínguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Richí guiö́j lahuaʼ tuʼ ribözaʼ yöl-laʼ rusölá quiuʼ, encaʼ didzaʼ tsahuiʼ quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Lu yöl-laʼ dxiʼi ladxiʼ quiuʼ ben quiaʼ nedaʼ, huen dxin quiuʼ, ca rë́ʼëni quézinuʼ gunuʼ. Busedi nedaʼ yuguʼ le gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Nacaʼ huen dxin quiuʼ. Benna quiaʼ yöl-laʼ réajniʼi para gaca gúnbëʼa le nunuʼ ba nalí. ");
INSERT INTO zarNT_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Chibidxín dza bi gunuʼ, Xan, tuʼ gulaʼguítsjëʼ xibá naguixjuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Que lë ni naʼ nadxíʼirödaʼ xibá naguixjuʼ Liʼ ca nadxíʼidaʼ oro. ¡Ön, ca oro banéquini, ");
INSERT INTO zarNT_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","en réquidaʼ nácagacarö dxiʼa xibá quiuʼ ca yúguʼtë le dë! Bitiʼ riléʼedaʼ dxiʼa yúguʼtë le cabí naca. ");
INSERT INTO zarNT_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Run ga rubánidaʼ le nunuʼ ba nalí. Que lë ni naʼ böʼ naca cazaʼ nazíʼ lu nëʼe le. ");
INSERT INTO zarNT_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Cateʼ naláʼ lahui xtídzuʼu, ruzeníʼ queë́tuʼ. Run ga taʼyéajniʼi nupa nácagaca nöxaj ladxiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Gusaljaʼ ruʼa, en gunnë́ ládxaʼa, tuʼ guzë́ ládxaʼa xibá gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Buyú nedaʼ, en buzáʼ ladxiʼ quiaʼ, ca run cazuʼ quégaca nupa taʼdxíʼi Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Buzóa nedaʼ tsutsu para gunaʼ ca rnna xtídzuʼu. Bitiʼ guʼu lataj le naca xihuiʼ inná beʼe nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Buáʼu nedaʼ lu naʼ nu rusacaʼ ziʼ nedaʼ, para gaca gunaʼ ca naca xibá quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Ben ga gaca bëʼ nazíʼ lu noʼo nedaʼ, huen dxin quiuʼ, en busedi nedaʼ yuguʼ le gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Raca nisa ribödxi guiö́j lahuaʼ ca tu yegu gubóʼo, tuʼ cabí tun bönachi ca rinná bëʼ xibá quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Nacuʼ Liʼ tsahuiʼ, Xan. Dxiʼa tsahuiʼ naca le ruchiʼa rusörö́uʼ quee̲tuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Nugúʼu lu naʼtuʼ le nunuʼ ba nalí. Naca tsahuiʼ, en tsaz zoa. ");
INSERT INTO zarNT_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Tuʼ ribözaʼ le naca quiuʼ run ga régui rilá ládxiʼdaʼahuaʼ, ateʼ gulal-la ladxiʼ xtídzuʼu nupa taʼdáʼbagaʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Idú dxiʼa tsahuiʼ naca xtídzuʼu. Que lë ni naʼ nedaʼ, huen dxin quiuʼ, nadxíʼidaʼ le. ");
INSERT INTO zarNT_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Nöxaj ladxiʼ nacaʼ, ateʼ tuʼcáʼana bönachi nedaʼ cáʼasö, pero bitiʼ ral-la ládxaʼa le gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Zóaticaʼsö le naca tsahuiʼ quiuʼ, en idútë li naca xibá naguixjuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Ba bidxín le raca quiaʼ, en le rusacaʼ ziʼ nedaʼ, pero raza ládxaʼa xibá gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Nácaticaʼsö tsahuiʼ le nunuʼ ba nalí. Buzéajniʼi nedaʼ para soaʼ ibanaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","Idú ládxaʼa rulidzaʼ Liʼ. Bubíʼi didzaʼ, Xan, ateʼ gunaʼ ca naca le gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Rulídzaticaʼsaʼ Liʼ. Busölá nedaʼ, ateʼ gunaʼ ca naca le nunuʼ ba nalí. ");
INSERT INTO zarNT_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Riyasaʼ zíʼalö ca ritö́ yu zila, en rulidzaʼ Liʼ para gácalenuʼ nedaʼ. Ribözaʼ yuguʼ didzaʼ guʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Chiʼi dzö́ʼölö rubéajaʼ yëla guiö́j lahuaʼ, para ulaba ládxaʼa ca naca xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Lu yöl-laʼ dxiʼi ladxiʼ quiuʼ buzë́ naguʼ chiʼa. Busubán ládxaʼa, Xan, ca naca le nusédinuʼ netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Taʼbigaʼ nupa tuáʼ döʼ ga zoaʼ para ilaʼbía no nedaʼ. Nucáʼanagaca xibá naguixjuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Zuʼ galaʼ ga zoaʼ, Xan, ateʼ idútë li naca le gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Dza niʼte quez núnbëʼa le nunuʼ ba nalí, en nözdaʼ tsaz nuzúʼ le. ");
INSERT INTO zarNT_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Buyú le rusacaʼ ziʼ nedaʼ, en busölá nedaʼ, tuʼ cabí ral-la ládxaʼa xibá naguixjuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Bubíʼi didzaʼ uláz quiaʼ, en buáʼu nedaʼ. Busubán ládxaʼa ca naca xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Ziʼtuʼ zoa yöl-laʼ rusölá ga nacuáʼ nupa tuáʼ döʼ, tuʼ cabí tuíʼi ládxiʼgaca le gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Zxö́ntërö naca yöl-laʼ ruhuéchiʼ ladxiʼ quiuʼ, Xan. Busubán ládxaʼa ca naca le nusédinuʼ netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Ziángaca nupa taʼbía no nedaʼ, en taʼdáʼbagaʼ nedaʼ, pero bitiʼ nucáʼanaʼ le nunuʼ ba nalí. ");
INSERT INTO zarNT_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Bitiʼ riléʼedaʼ dxiʼa nupa nucáʼanagaca Liʼ, en bitiʼ tun ca rnna xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Buyú ca nadxíʼidaʼ xibá quiuʼ, Xan. Lu yöl-laʼ dxiʼi ladxiʼ quiuʼ busubán ládxaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Idútë li nácagaca yúguʼtë xtídzuʼu, en tsaz nacuáʼ yúguʼtë le nusédinuʼ netuʼ le nácagaca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Taʼbía no nedaʼ nupa taʼnná bëʼ, en bitiʼ bi benaʼ quéguequi, pero runaʼ bal xtídzuʼu lu icja ládxiʼdaʼahuaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Rudzéjalendaʼ xtídzuʼu, ca rudzeja nu rudzöli tu yöl-laʼ tsahuiʼ zxön. ");
INSERT INTO zarNT_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Réquidaʼ ziʼ, en bitiʼ riléʼedaʼ dxiʼa le cabí nácatë, pero nadxíʼidaʼ xibá naguixjuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Gadxi luzuí tu dza riguʼa Liʼ yöl-laʼ ba, niʼa que le nusédinuʼ netuʼ, le naca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Taʼböza dxiʼa tsáhuiʼdoʼ nupa nadxíʼigaca xibá naguixjuʼ Liʼ, en bitiʼ bi run ga röjchéguʼgaca. ");
INSERT INTO zarNT_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","Runaʼ löza yöl-laʼ rusölá quiuʼ, Xan, en runaʼ ca rnna xibá nunuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Yuguʼ le nunuʼ ba nalí tun chiʼi böʼ naca cazaʼ, ateʼ nadxíʼideʼedaʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Runaʼ ca taʼnná xibá quiuʼ, en yuguʼ le nunuʼ ba nalí tuʼ riléʼe quézinuʼ yúguʼtë le runaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","Ruzë́ naguʼ le rulidzaʼ Liʼ, Xan. Ruzéajniʼi nedaʼ ca rnna xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Ruzë́ naguʼ le rinábidaʼ Liʼ, en busölá nedaʼ ca rnna xtídzuʼu gunuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Bëʼ nedaʼ lataj cuʼa Liʼ yöl-laʼ ba, tuʼ rusédinuʼ nedaʼ le gunná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Bëʼ lataj gul-la lúdxaʼa ca naca xtídzuʼu, tuʼ nácagaca tsahuiʼ yúguʼtë xibá nunuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Guzóatë gácalenuʼ nedaʼ, tuʼ nabö́aʼ xibá quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","Rizë́ ládxaʼa yöl-laʼ rusölá quiuʼ, Xan, en raza ládxaʼa xibá naguixjuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Bëʼ lataj soa ibán böʼ naca cazaʼ para cuʼa Liʼ yöl-laʼ ba, en ben ga gácalen nedaʼ le nusédinuʼ netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Ridödaʼ tsöláʼalö ca tubaʼ böʼcuʼ zxilaʼ nanítibaʼ. Gudá dudiljuʼ nedaʼ, huen dxin quiuʼ, tuʼ cabí ral-la ládxaʼa xibá nunuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Cateʼ gudíʼi guzxácaʼa bulidzaʼ-nëʼ Xanruʼ, ateʼ Lëʼ bubiʼë didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","Busölá böʼ naca cazaʼ, Xan, lu naʼ nu rizíʼ yëʼ, en lu naʼ nu bitiʼ run ca gunná caz. ");
INSERT INTO zarNT_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","¿Bizxi gunëʼ quiuʼ Dios, en bizxi ubiʼë quiuʼ, liʼ naʼ rizíʼ yëʼu? ");
INSERT INTO zarNT_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Ichizëʼ liʼ yuguʼ yaga lahui tuchiʼ que nu reaj gudil-la, en cuʼë icjuʼ boʼ yalaj que yaʼ yö́ridoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Bicaʼ bayechiʼ nedaʼ tuʼ zóasaʼ yödzö Mesec, en zoaʼ tu lu yuʼu guídi quégaca bönachi Cedar. ");
INSERT INTO zarNT_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Xidzélëʼë chiguzóa böʼ naca cazaʼ len nupa tuʼsuniti yöl-laʼ riböza dxiʼa tsáhuiʼdoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Rë́ʼëndaʼ cözaʼ dxiʼa tsáhuiʼdoʼ, pero cateʼ ruáʼa didzaʼ të́ʼënnëʼ ilaʼdíl-lalen nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Uchisa icjaʼ uyúaʼ le raca yuguʼ lu guíʼa. ¿Gazxi zaʼ le gácalen nedaʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Le gácalen nedaʼ zaʼ lu nëʼë Xanruʼ. Lëʼ benëʼ lúzxiba, en luyú. ");
INSERT INTO zarNT_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Bitiʼ guʼë lataj cuiluʼ ga ridóʼ. Bitiʼ caʼ gasi Nu naʼ run chiʼi liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Buyútsöcaʼ, bitiʼ ridödi yëla guiö́j lahuëʼ, en bitiʼ rásiëʼ, Lëʼ naʼ rapa chiʼë bönachi Israel. ");
INSERT INTO zarNT_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Run chiʼë Xanruʼ Dios liʼ. Zoëʼ Xanruʼ Dios cuituʼ ibëla, riguʼë liʼ zxul-la. ");
INSERT INTO zarNT_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Bitiʼ uzeguiʼ gubidza liʼ lahuiʼ dza, en bitiʼ bi gun beoʼ quiuʼ chiʼi dzö́ʼölö. ");
INSERT INTO zarNT_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Gun chiʼë Xanruʼ Dios liʼ ga rizóʼo, en ga rudxinuʼ, dza ni zóaruʼ naʼa, en yuguʼ dza siʼ zaca. ");
INSERT INTO zarNT_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Xanruʼ Dios gun chiʼë liʼ ga rizóʼo, en ga rudxinuʼ, dza ni zóaruʼ naʼa, en yuguʼ dza siʼ zaca. ");
INSERT INTO zarNT_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Budzéjadaʼ cateʼ gulë́ bönachi nedaʼ, gulaʼnná: “Uyeajruʼ yuʼu lidxëʼ Xanruʼ Dios.” ");
INSERT INTO zarNT_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Naʼa zuíruʼ ni ga nu riyaza yödzö Jerusalén. ");
INSERT INTO zarNT_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Dxíʼadoʼ gulunëʼ yödzö Jerusalén, ateʼ naca lachi, en tuz ca röjlö́zgaca yuʼu zxön que. ");
INSERT INTO zarNT_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Taʼyaza yuguʼ cöʼ bönachi queëʼ Xanruʼ ga ni ca naʼ nusédinëʼ Dios bönachi Israel, para ilaʼgúʼu yöl-laʼ ba Xanruʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Taʼbö́ʼ nupa tuʼchiʼa tuʼsörö́ queëruʼ ga ni, ga taʼbö́ʼ taʼnná bëʼ zxíʼini xiʼsóëʼ David. ");
INSERT INTO zarNT_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Guliʼnábinëʼ Dios gunëʼ ga gaca dxiʼa que Jerusalén, en ga uluʼzíʼ xibé nupa taʼdxíʼi yödzö ni yöl-laʼ tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Dios gunëʼ ga ilaʼböza dxiʼa tsáhuiʼdoʼ nupa nacuáʼ yödzö ni, en ga uluʼzíʼ xibé nupa taʼnná bëʼ yöl-laʼ tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Tuʼ nadxíʼidaʼ yuguʼ bö́chaʼa, en yuguʼ böchiʼ luzáʼa, rnníaʼ: “Gaca yöl-laʼ riböza dxi ladxiʼ lu yödzö ni.” ");
INSERT INTO zarNT_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Tuʼ nadxíʼidaʼ lidxëʼ Xanruʼ Dios, rinábidaʼ-nëʼ gunëʼ ga gaca dxiʼa que yödzö ni. ");
INSERT INTO zarNT_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","Uchisa lahuaʼ uyúaʼ ga zuʼ Liʼ, röʼu rinná bëʼu yehuaʼ yubá niʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Ca runëʼ bönniʼ nadóʼo, ruyúëʼ bi uluʼë xanëʼ, ateʼ ruyubiʼ biʼi nigula nadóʼo bi ulúʼunu nigula xanbiʼ, lëscaʼ caní ruyuruʼ rëʼu bi uluʼë Xanruʼ Dios, ga idxinrö dza uzáʼ ládxëʼë queë́ruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Buzáʼ ladxiʼ queë́tuʼ, Xan. Buzáʼ ladxiʼ queë́tuʼ, tuʼ nacuáʼ nupa tuʼcáʼana netuʼ cáʼasö. ");
INSERT INTO zarNT_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Rudú ládxiʼtuʼ tuʼ tuʼtitaj netuʼ nupa tuʼzíʼ xibé yúguʼtë le dë, en tuʼ tuʼcáʼana netuʼ cáʼasö nupa tun ba zxön cuínguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","“Laʼtuʼ cabí gúcalenëʼ Xanruʼ rëʼu”, ral-laʼ ilaʼnná bönachi Israel: ");
INSERT INTO zarNT_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","“Laʼtuʼ cabí gúcalenëʼ Xanruʼ rëʼu cateʼ nupa bitiʼ taʼléʼe rëʼu dxiʼa gulaʼdíl-lalen rëʼu, ");
INSERT INTO zarNT_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","laʼ gulútitë rëʼu tuʼ gulaʼlédeʼe rëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","Guca queë́ruʼ ca laʼ usubágaʼtë rëʼu nisa, en laʼ uchícjatëruʼ lu nisa naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","Laʼ uchícjatëruʼ tu lu nisa zila.” ");
INSERT INTO zarNT_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","¡Bicaʼ láʼayi Xanruʼ Dios tuʼ cabí biʼë lataj nupa bitiʼ taʼléʼe rëʼu dxiʼa uluʼsuniti rëʼu! ");
INSERT INTO zarNT_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Bularuʼ ca rulabaʼ biguínnidoʼ tu lu le zön lëbaʼ. Narözaʼ du yalaj, ateʼ nuláruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Le rácalen rëʼu zaʼ lu nëʼë Xanruʼ Dios. Lëʼ benëʼ lúzxiba, en lu yu. ");
INSERT INTO zarNT_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Nupa tuʼzxöni ládxiʼgaca Xanruʼ Dios nácagaca ca guíʼa Sión, tuʼ cabí bi gaca utá guíʼa naʼ, pero tsaz zoa caz. ");
INSERT INTO zarNT_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Ca rö́ʼgaca guíʼa idú gásibiʼilö yödzö Jerusalén, laʼ canísö zoëʼ Xanruʼ Dios idú gásibiʼilö bönachi queëʼ, naʼa dza, en yúguʼtë dza siʼ zaca. ");
INSERT INTO zarNT_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Bitiʼ ral-laʼ ilaʼnná bëʼ nupa tuáʼ döʼ lu xiyúgaca bönachi tsahuiʼ, para cabí iún ga iluʼë döʼ bönniʼ tsahuiʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Xan, ben ga gaca dxiʼa quégaca nupa nácagaca dxiʼa, en quégaca nupa idú ládxiʼgaca tun ca rnna xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Nupa tuʼdödi cuínguequi lu le cabí nácatë, ben léguequi xiguiaʼ tsözxö́n len nupa tuáʼ döʼ. Ben ga ilaʼcuáʼ bönachi Israel dxiʼa tsáhuiʼdoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Cateʼ Xanruʼ Dios buchë́ʼë bönachi yödzö Sión nupa gulaʼdzún ziʼtuʼ, gúquiruʼ yë́lasö rineruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Níʼirö idú ládxiʼruʼ buzxídxiruʼ, en lu yöl-laʼ rudzeja queë́ruʼ gurö́dxiʼaruʼ. Níʼirö guluíʼi didzaʼ bönachi yuguʼ yödzö izáʼa, gulaʼnná: “Dios, Xángaquiëʼ, benëʼ le nácagaca zxön, gúcalenëʼ légaquiëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Xanruʼ Dios benëʼ le nácagaca zxön, gúcalenëʼ rëʼu, ateʼ ruzíʼiruʼ xibë́ʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Buchë́ʼ netuʼ, irúajtuʼ ga ni nadzuntuʼ, Xan, para gácatuʼ ca nisa rudxín lu yegu nuhuíʼigaca. ");
INSERT INTO zarNT_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Lu yöl-laʼ rudzeja ilaʼbö́dxiʼa cateʼ ilaʼlapa nupa lu yöl-laʼ ribödxi quéguequi röjö́zagaca. ");
INSERT INTO zarNT_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Nu bönniʼ lu yöl-laʼ ribödxi rizë́ʼë, nuʼë bínnedoʼ röjözëʼ, lu yöl-laʼ rudzeja cö́dxiʼë cateʼ udxinëʼ, nuʼë le nulapëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Channö cabí runëʼ tsutsu Xanruʼ Dios tu yuʼu, nítisö tunëʼ dxin bönniʼ tunëʼ yuʼu naʼ. Channö cabí run chiʼë Xanruʼ Dios tu yödzö, nítisö ruyúëʼ bönniʼ naʼ yuʼu lu nëʼë yödzö naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Nítisö naca rubanuʼ zíladoʼ, en röjöxuʼ cateʼ chigúl-ladaʼ, en raguʼ le guzxiʼu niʼa que le busacaʼ ziʼ cuinuʼ, tuʼ runnëʼ Xanruʼ Dios que nu nadxíʼinëʼ cateʼ niʼ rasi nu naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Buliʼyú, nácagacabiʼ zxíʼiniruʼ le runnëʼ Xanruʼ Dios queë́ruʼ, ateʼ bíʼidoʼ tuʼcuáʼanu nigula queë́ruʼ nácagacabiʼ le rubiʼë Xanruʼ Dios queë́ruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Ca nácagaca yaga lahuiʼ tuchiʼ lu naʼ nu bönniʼ rejëʼ gudil-la nácagacabiʼ zxíʼinëʼ bönniʼ zoëʼ iz cuidiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Bicaʼ ba bönniʼ nacuáʼabiʼ queëʼ ziántëröbiʼ. Bitiʼ caʼ utuíʼinëʼ cateʼ ruʼë didzaʼ láhuiʼgaquiëʼ bönniʼ tuʼchiʼa tuʼsörö́ëʼ queëʼ, en lógaca nupa taʼdíl-lalen lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Bicaʼ ba yúguʼtë nupa tadxi Xanruʼ Dios, nupa naʼ tun ca rë́ʼëni quézinëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Cateʼ gaguʼ le gataʼ quiuʼ niʼa que dxin nun cazuʼ, uziʼu xibé lë naʼ, en gaca dxiʼa quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Gácanu nigula quiuʼ ca tu lubá uva dxía ga naca löʼa lidxuʼ, ateʼ ilácabiʼ zxíʼinuʼ ca yuguʼ yaga olívodoʼ taʼbö́ʼöbiʼ ga niʼ ráguliʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Buliʼyútsöcaʼ, caní gáquiëʼ bicaʼ ba bönniʼ naʼ rádxinëʼ Xanruʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Xanruʼ Dios zoëʼ Sión gunëʼ ga gaca dxiʼa quiuʼ, en guʼë liʼ lataj iléʼenuʼ le dxiʼa gaca que yödzö Jerusalén yúguʼtë dza suʼ ibanuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","Dios guʼë liʼ lataj iléʼenuʼ yuguʼ zxíʼini xiʼsúʼ, en gunëʼ ga ilaʼböza dxiʼa tsáhuiʼdoʼ bönachi Israel. ");
INSERT INTO zarNT_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","“Zian luzuí gulaʼbía no netuʼ ga gudelaʼ nácatuʼ raʼbandoʼ”, huáca ilaʼnná bönachi Israel: ");
INSERT INTO zarNT_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","“Zian luzuí gulaʼbía no netuʼ ga gudelaʼ nácatuʼ raʼbandoʼ, pero bitiʼ gulaʼdeliʼ uluʼxicja netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Guca tsca buluʼgáʼana-baʼ bëdxi lu bëlaʼ cúdzuʼtuʼ, en gulún tunna ga gudödi xiyágabaʼ bëdxi quégaquiëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Tsahuiʼ náquiëʼ Xanruʼ Dios. Chinachúguëʼ du quégaca nupa tuáʼ döʼ le gulúguiʼni netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Ben ga uluʼtuíʼi, en uluʼhuécja guz cúdzuʼlö yúguʼtë nupa bitiʼ taʼléʼe dxiʼa netuʼ, bönachi Sión. ");
INSERT INTO zarNT_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Ben ga ilácagaca ca guíxiʼdoʼ daʼ ícjoʼolö yuʼu, le ribídxitë cateʼ niʼ naca huë́ʼënidoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","Bitiʼ gaca ulí nëʼe nu tsöjchugu le, en bitiʼ gaca nu gachi tsölén guizxi que, ");
INSERT INTO zarNT_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","en bitiʼ taʼnná nupa taʼdödi niʼ: “Rinábituʼ-nëʼ Xanruʼ Dios gunëʼ ga gaca dxiʼa quiuʼ. Lu Lëʼ Xanruʼ rinábituʼ Lëʼ gunëʼ ga gaca dxiʼa quiuʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Ga ni nö́tjadaʼ rulidzaʼ Liʼ, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Ruzë́ naguʼ chiʼa, Xanaʼ Dios. Ruzëdaʼ naguʼ le rinábidaʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Laʼ nnaruʼ tsöjnenuʼ xiguiaʼ nabágaʼgaca bönachi, ¿nuzxi caz urúaj tsahuiʼ loʼ, Xan? ");
INSERT INTO zarNT_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Runiti lo cazuʼ netuʼ, Xan, para guntuʼ Liʼ bal. ");
INSERT INTO zarNT_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Runaʼ löza Liʼ, Xanaʼ Dios. Run löza böʼ naca cazaʼ Liʼ, ateʼ runaʼ löza gaca ca rnna xtídzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Böʼ naca cazaʼ runrö löza Liʼ, Xan, ca tunëʼ bönniʼ tapa chiʼë yödzö chiʼi dzö́ʼölö taʼbözëʼ itö́ yu zila, ca tunëʼ löza itö́ yu zila yuguʼ bönniʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Guliʼgún löza Xanruʼ Dios, libíʼiliʼ, bönachi Israel, tuʼ náquiëʼ dxiʼi ladxiʼ Xanruʼ, en ruhuáʼuëʼ bönachi Israel. ");
INSERT INTO zarNT_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Xanruʼ Dios huöáʼuëʼ bönachi Israel lu yúguʼtë xiguiaʼ nabágaʼgaca. ");
INSERT INTO zarNT_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Bitiʼ run ba zxön cuinaʼ, Xan, en bitiʼ rigúʼu cuinaʼ yöl-laʼ ba, en bitiʼ ulapaʼ naʼa le nácagaca zxön, en le nácagaca böniga. ");
INSERT INTO zarNT_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Idú ládxaʼa nuzóa cuinaʼ nöxaj, en zoaʼ dxisö. Ca runbiʼ biʼi huë́ʼëni ruzíʼ ládxiʼbiʼ cuítanu xináʼabiʼ, caʼ riböza böʼ naca cazaʼ lu icja ládxiʼdaʼahuaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","¡Libíʼiliʼ, bönachi Israel, guliʼgunëʼ löza Xanruʼ Dios ga naguelaʼ naʼa dza, en yúguʼtë dza siʼ zaca! ");
INSERT INTO zarNT_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Rinábidaʼ Liʼ, Xan, uláz queëʼ David tsöjnénuʼ yúguʼtë le gudíʼi guzxáquëʼë, ");
INSERT INTO zarNT_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","en ca benëʼ tsutsu xtídzëʼë, Xan, en guzxíʼ lu nëʼë bi gunëʼ loʼ, nacuʼ Nu nál-latërö láhuigaquiëʼ zxíʼini xiʼsóëʼ Jacob, gunnë́ʼ: ");
INSERT INTO zarNT_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","“Bitiʼ caʼ tsuʼa lidxaʼ, en bitiʼ gátaʼa le rátiʼdaʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","en bitiʼ guʼa lataj tödi yëla guiö́j lahuaʼ, en bitiʼ utsudiʼ lahuaʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","ga idxinrö dza ucözaʼ tu lataj ga soëʼ Xanruʼ Dios, le gaca yuʼu lidxi Nu naʼ nál-latërö láhuigaquiëʼ zxíʼini xiʼsóëʼ Jacob.” ");
INSERT INTO zarNT_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Biyö́nituʼ didzaʼ que guíʼina láʼayi queëʼ Dios cateʼ niʼ zóatuʼ Efrata, ateʼ budzö́lituʼ le lu xiyúëʼ Jaar. ");
INSERT INTO zarNT_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","Uyéajruʼ ga naʼ zoa cazëʼ Xanruʼ Dios. Tseaj ládxiʼruʼ-nëʼ ga naca xilibi niʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","Gudödi, Xan, ga naʼ soa cazuʼ Liʼ. Gudá tsözxö́n len guíʼina láʼayi que yöl-laʼ zxön quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Ben ga sóalen le naca tsahuiʼ yuguʼ bixúz quiuʼ ca tu lariʼ taʼxóëʼ cúdzuʼgaquiëʼ. Ben ga ilúl-la bönachi quiuʼ lu yöl-laʼ rudzeja quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Uláz queëʼ David, huen dxin quiuʼ, rinábidaʼ Liʼ cabí ucáʼanuʼ bönniʼ naʼ gurö́ cazuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Xanruʼ Dios benëʼ tsutsu xtídzëʼë bi gunëʼ queëʼ David, le naca idútë li, ateʼ Lëʼ bitiʼ unítiëʼ xtídzëʼë naʼ, gunnë́ʼ: “Uzóaʼ tuëʼ zxíʼini xiʼsúʼ xilatjuʼ ga inná bë́ʼëbiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","Channö ilunbiʼ zxíʼini xiʼsúʼ ca rnna didzaʼ dzaga quiaʼ, en le nunaʼ ba nalí para uzéajniʼidaʼ légacabiʼ, ilaʼnná bë́ʼëbiʼ ga röʼu rinná bëʼu yúguʼtë dza siʼ zaca.” ");
INSERT INTO zarNT_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Xanruʼ Dios nabö́ cazëʼ queëʼ yödzö Sión. Raca ládxëʼë gaca Sión ga soa cazëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","Rnnëʼ: “Nácaticaʼsö lataj ni ga soa cazaʼ nedaʼ. Soaʼ ni tuʼ raca ládxaʼa soaʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Gunaʼ ga gátadaʼ le ilágugaca bönachi ni, en gunaʼ ga uluʼhuö́laj ilaʼdzéʼe yöta xtila nupa taʼyadzaj taʼyudxi lu yödzö ni. ");
INSERT INTO zarNT_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Gunaʼ ga sóalen yöl-laʼ rusölá yuguʼ bixúz quiaʼ ca tu lariʼ ilaʼxóa cúdzuʼgaquiëʼ, ateʼ ilúl-la bönachi quiaʼ lu yöl-laʼ rudzeja quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Gunaʼ ni ga iláʼ lahui yöl-laʼ unná bëʼ queëʼ David. Gunaʼ ga sóaticaʼsö nu inná bëʼ xilatjëʼ bönniʼ naʼ nabö́ cazaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Gunaʼ ga sóalen nupa bitiʼ taʼléʼe lëʼ dxiʼa yöl-laʼ rutuíʼi ca tu lariʼ ilácuguequi, pero tsëpi yösa beníʼ le dxía icjëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Buliʼyútsöcaʼ: ¡Bicaʼ dxiʼa tsahuiʼ naca cateʼ nupa nácagaca böchiʼ luzëʼe taʼböza lu yöl-laʼ tuz quéguequi! ");
INSERT INTO zarNT_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Naca ca le za taʼgúʼu ícjaguequi bönachi, le ridzún lu guitsaʼ láhuiguequi, en bidzún lu guitsaʼ lúzxuëʼ Aarón, le bidzún ga ridxintë lu yeni zxëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Naca ca buzén le ridinni lu guíʼa Hermón, en ca le riböʼa lu guíʼa Sión, tuʼ gunná bëʼë Xanruʼ gaca dxiʼa queëruʼ lu guíʼa naʼ, en gataʼ yöl-laʼ naʼbán idú queëruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","¡Buliʼyútsöcaʼ! ¡Guliʼcuʼë Xanruʼ Dios yöl-laʼ ba, yúguʼtëliʼ runliʼ xichinëʼ Xanruʼ, yúguʼtëliʼ naʼ zóaliʼ yuʼu lidxëʼ Xanruʼ chiʼi dzö́ʼölö! ");
INSERT INTO zarNT_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","¡Guliʼchisa náʼaliʼ ga zóaliʼ lataj láʼayi queëʼ, en guliʼnná dxiʼa queëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Xanruʼ Dios, zoa cazëʼ yödzö Sión, gunëʼ ga gaca dxiʼa queë́liʼ. Naca cazëʼ Nu ben yehuaʼ yubá, en yödzölió ni. ");
INSERT INTO zarNT_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","¡Guliʼcuʼë yöl-laʼ ba Xanruʼ Dios! ¡Guliʼcúʼu yöl-laʼ ba La laʼayi queëʼ Xanruʼ Dios! ¡Guliʼcuʼë yöl-laʼ ba, libíʼiliʼ runliʼ xichinëʼ Xanruʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","libíʼiliʼ naʼ zuíliʼ yuʼu lidxëʼ Xanruʼ, ga naʼ zóaliʼ löʼa que yuʼu lidxëʼ Dios queëruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","¡Guliʼcuʼë yöl-laʼ ba Xanruʼ Dios tuʼ náquiëʼ dxiʼa! ¡Guliʼgul-la yöl-laʼ ba que La laʼayi queëʼ, tuʼ naca lachi! ");
INSERT INTO zarNT_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Nabö́ cazëʼ Xanruʼ zxíʼini xiʼsóëʼ Jacob para ilaca quez queëʼ. Gurö́ëʼ bönachi Israel para ilequi queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Nözdaʼ nayë́pisëʼ Xanruʼ Dios. Nayë́pisëtërëʼ ca yuguʼ dios quégaca bönachi izáʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Run cazëʼ Xanruʼ ca riyaza ladxiʼ cazëʼ yehuaʼ yubá niʼ, en luyú ni, en lu nísadoʼ, en zxan lu yu. ");
INSERT INTO zarNT_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Runëʼ ga röʼ böaj gátiʼtës luyú ni, en runëʼ ga rëpi yösa cateʼ ralaj guiö́j. Rubéajëʼ böʼ recja ga rapa chiʼë le nequi queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Bë́tiëʼ yuguʼ biʼi bönniʼ zíʼalö quégaca bönachi Egipto, zxíʼinigaca bönachi, en böaʼ huë́ʼënidoʼ quégacabaʼ böaʼ guixiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","Benëʼ yuguʼ yöl-laʼ huáca zxön le gulaca bëʼ luyú Egipto, yuguʼ lë naʼ gulaca queëʼ Faraón, en quégaca huen xichinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Busunítiëʼ Dios bönachi zián yödzö izáʼa, en bë́tiëʼ bönniʼ lo taʼnná bëʼë. ");
INSERT INTO zarNT_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Bë́tiëʼ Sehón, bönniʼ gunná béʼenëʼ bönachi Amorreo, en Og, bönniʼ gunná béʼenëʼ bönachi Basán, en bönniʼ gulaʼnná béʼenëʼ bönachi yödzö nacuáʼ luyú Canaán. ");
INSERT INTO zarNT_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","Budödëʼ xiyúgaquiëʼ bönniʼ naʼ lu náʼagaquiëʼ bönniʼ Israel, bönachi queë cazëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Tsaz zoa caz Loʼ, Xan. Ilaʼcuáʼticaʼsö nupa tsöjnégaca Liʼ, Xan, ");
INSERT INTO zarNT_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","tuʼ uchiʼa usörö́uʼ bönachi queuʼ, Xantuʼ Dios, en huéchiʼ ládxuʼu nupa tun xichinuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Budóʼ quégaca bönachi yuguʼ yödzö izáʼa néquiniguequi plata, en oro, yuguʼ le núngaca lu niʼa lu náʼagaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Zóagaca ruíʼiguequi, pero bitiʼ bi didzaʼ tuíʼi. Zóagaca guiö́j lóguequi, pero bitiʼ bi taʼléʼe. ");
INSERT INTO zarNT_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","Zóagaca nágagaca, pero bitiʼ bi taʼyöni, en bitiʼ taʼguelaʼ böʼ ruíʼigaca. ");
INSERT INTO zarNT_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Nupa tun léguequi ilaca ca nácagaca budóʼ naʼ, en caní ilaca yúguʼtë nupa tuʼzxöni ladxiʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","Libíʼiliʼ, bönachi Israel, guliʼguíëʼ Xanruʼ náquiëʼ dxiʼa. Libíʼiliʼ, zxíʼini xiʼsóëʼ Aarón, guliʼguíëʼ Xanruʼ náquiëʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","Libíʼiliʼ, zxíʼini xiʼsóëʼ Leví, guliʼguíëʼ Xanruʼ náquiëʼ dxiʼa. Libíʼiliʼ, núlöliʼ rádxiliʼ-nëʼ Xanruʼ, guliʼguíëʼ Xanruʼ náquiëʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Núlöliʼ zóaliʼ yödzö Sión ral-laʼ guië́liʼ-nëʼ Xanruʼ náquiëʼ dxiʼa, tuʼ zoa cazëʼ Xanruʼ Dios yödzö Jesusalén. ¡Guliʼcuʼë yöl-laʼ ba Xanruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","¡Xclenëʼ Xanruʼ Dios tuʼ náquiëʼ dxiʼa! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","¡Xclenëʼ Dios nayë́pisëtërëʼ ca yuguʼ dios izáʼa! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","¡Xclenëʼ Xanruʼ, nayë́pisëtërëʼ ca yuguʼ xángaca bönachi! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","¡Xclenëʼ Dios, tuzëʼ Lëʼ runëʼ yuguʼ yöl-laʼ huáca zxön! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","¡Xclenëʼ Dios, len yöl-laʼ rácadaʼ queëʼ benëʼ lúzxiba! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","¡Xclenëʼ Dios, gudixjëʼ luyú láhuilö nísadoʼ! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","¡Xclenëʼ Dios, benëʼ gubidza, en beoʼ! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","¡Benëʼ Dios gubidza para tseníʼ lahuiʼ dza! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","¡Benëʼ Dios beoʼ, en yuguʼ bölaj para uluʼzeníʼ chiʼi dzö́ʼölö! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","¡Xclenëʼ Dios, bë́tiëʼ yuguʼ biʼi bönniʼ lo quégaca bönachi Egipto! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","¡Bubéajëʼ bönachi Israel ladaj bönachi Egipto naʼ! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","¡Len yöl-laʼ huáca zxön queëʼ, en lu yöl-laʼ nadxíʼi queëʼ benëʼ caní! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","¡Xclenëʼ Dios, bubéajëʼ choplö Nísadoʼ Xiná! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","¡Benëʼ ga gulaʼdödi bönachi Israel gatsaj láhuiʼlö nísadoʼ naʼ! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","¡Lu nísadoʼ naʼ busunítiëʼ Faraón, en bönniʼ queëʼ röjáquiëʼ gudil-la! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","¡Xclenëʼ Dios, guchë́ʼë bönachi queëʼ laʼ guixiʼ ga niʼ naca yu bidxi! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","¡Xclenëʼ Dios, bë́tiëʼ bönniʼ gulaʼnná bëʼë, guláquiëʼ nal-la! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","¡Bë́tiëʼ bönniʼ gulaʼnná bëʼë, dëdaʼ lu náʼagaquiëʼ yöl-laʼ unná bëʼ! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","¡Bë́tiëʼ Sehón, bönniʼ gunná béʼenëʼ bönachi Amorreo! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","¡Bë́tiëʼ Og, bönniʼ gunná béʼenëʼ bönachi Basán! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","¡Budödëʼ xiyúgaquiëʼ lu náʼagaca bönachi queëʼ! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","¡Budödëʼ le lu náʼagaca bönachi Israel, bönachi tun xichinëʼ! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","¡Yöjnenëʼ rëʼu cateʼ niʼ bugáʼanaruʼ cáʼasö! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","¡Busölë́ʼ rëʼu lu náʼagaca nupa gulaʼdíl-lalen rëʼu! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","¡Rugahuëʼ yúguʼtë bönachi! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","¡Xclenëʼ Dios, zoa cazëʼ yehuaʼ yubá! Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Raʼ yegu nacuáʼ lu yu Babilonia gurö́ʼötuʼ, en gurödxi yéchiʼtuʼ, cateʼ yöjnetuʼ yödzö Sión. ");
INSERT INTO zarNT_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Lu yaga rö́ʼgaca yuguʼ raʼ yegu niʼ bugálaʼtuʼ yuguʼ le rúl-lalentuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","Caní bentuʼ tuʼ gulaʼnabi yudxi nupa gulachë́ʼ netuʼ nadzuntuʼ niʼ gúl-latuʼ. Nupa buluʼsacaʼ ziʼ netuʼ gulaʼnaba queë́tuʼ yöl-laʼ ruzxidxi, gulaʼnná: “Guliʼgul-la queë́tuʼ tu le rul-la que yödzö Sión.” ");
INSERT INTO zarNT_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","¿Nacxi caz gaca gúl-latuʼ le rul-la queëʼ Xanruʼ ga ni nadzuntuʼ tu lu yödzö izáʼa? ");
INSERT INTO zarNT_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","Channö gal-la ládxaʼa yödzö Jerusalén, rinábidaʼ-nëʼ Dios ugǘëʼ yöl-laʼ raca que naʼa ibëla. ");
INSERT INTO zarNT_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","Rinábidaʼ-nëʼ gunëʼ ga taʼ lúdxaʼa chichjaʼ channö cabí tsöjnedaʼ ladzaʼ, en channö cabí huíʼ zxönraʼ yödzö Jerusalén ca iaʼtú le ruzíʼidaʼ xibé. ");
INSERT INTO zarNT_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","Yöjné le gulunëʼ zxíʼini xiʼsóëʼ Edom, Xan, le gulunëʼ dza busiúdxuʼ yödzö Jerusalén, ca naʼ gulaʼnnë́ʼ: “Guliʼquínnaj dëra. Guliʼquinnaj dëra ga idxintë xilibi zöʼö yödzö naʼ.” ");
INSERT INTO zarNT_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Libíʼiliʼ, bönachi Babilonia, libíʼiliʼ rusunítiliʼ, bicaʼ ba nu ubíʼi queë́liʼ ca naʼ benliʼ queë́tuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Bicaʼ ba nu quelaʼ yuguʼ bíʼidoʼ queë́liʼ en uzxuzxaj légacabiʼ yuguʼ lu guiö́j. ");
INSERT INTO zarNT_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Idú ládxaʼa guíaʼ Liʼ, “Xclenuʼ” Xan. Gul-laʼ yöl-laʼ ba quiuʼ lógaca le tun zxön bönachi yuguʼ yödzö izáʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Uzóa zxibaʼ sacaʼ yudoʼ láʼayi quiuʼ, en guíaʼ Liʼ, “Xclenuʼ” niʼa que Loʼ, tuʼ nacuʼ dxiʼi ladxiʼ, en runuʼ ca rnna didzaʼ bëʼu, tuʼ benuʼ ca naca lu xtídzuʼu, en lu le naca ca nazíʼi lo. ");
INSERT INTO zarNT_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Laʼ dza náʼasö cateʼ bulidzaʼ Liʼ, bubiʼu didzaʼ. Tuʼ butipuʼ ládxaʼa, gucaʼ rugu ladxiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Yúguʼtë bönniʼ taʼnná bëʼë ilë́ʼ Liʼ: “Xclenuʼ” Xan, cateʼ ilaʼyönnëʼ didzaʼ ruʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Ilul-lëʼ ca nácagaca le runëʼ Xanruʼ Dios, tuʼ nácatërö zxön yöl-laʼ ba queëʼ Xanruʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Sal-laʼ nayë́pisëtërëʼ Xanruʼ Dios ruíʼi ládxëʼë nupa nácagaca cáʼasö, pero ziʼtuʼ zíʼtuʼsö ruyúëʼ nupa tun ba zxön cuínguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Sal-laʼ ridáʼ ga zoa bönadxi quiaʼ, Liʼ utipa cazuʼ ládxaʼa. Tíl-lalen cazuʼ nupa taʼdíl-lalen nedaʼ, ateʼ len yöl-laʼ huáca quiuʼ usölóʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Xanruʼ gun cazëʼ quiaʼ ca chinuzóa cazëʼ gunëʼ. Zóaticaʼsö yöl-laʼ dxiʼi ladxiʼ quiuʼ, Xan. Bitiʼ usán noʼo le nun cazuʼ len naʼ cuinuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Ruyú cazuʼ le yuʼu icja ládxiʼdaʼahuaʼ, Xan, en nunbëʼ cazuʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Nöz quézinuʼ cateʼ riböʼa, en cateʼ riyasaʼ. Nö́zinuʼ le rizáʼ ládxaʼa niʼ zuʼ ziʼtuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Ruyú cazuʼ nedaʼ cateʼ bi runaʼ, en cateʼ rasiaʼ, en nö́zinuʼ yúguʼtë le runaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Zíʼatëlö ca bi didzaʼ ruʼa, chi nöz quézinuʼ bi inníaʼ, Xan. ");
INSERT INTO zarNT_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Röjnöru cazuʼ lahuaʼ, en zaʼ cazuʼ cúdzaʼa, en naxóaticaʼsö noʼo nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Run ga rubánidaʼ tuʼ nöz quézinuʼ Liʼ. Bitiʼ séquiʼdaʼ tséajniʼidaʼ ca naca. ");
INSERT INTO zarNT_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","¿Naruʼ huáca tsejaʼ ga bitiʼ idxín Böʼ quiuʼ? ¿Naruʼ huáca izxúnnajaʼ ga bitiʼ zoa cazuʼ Liʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Laʼtuʼ huabenaʼ lúzxiba, niʼ soa cazuʼ Liʼ, en laʼtuʼ huötjaʼ lataj chul-la, niʼ zoa cazuʼ caʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Laʼtuʼ uyijaʼ ga rilén gubidza, o laʼtuʼ huadödaʼ iaʼtsöláʼalö nísadoʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","niʼ caz ichëʼu nedaʼ, ateʼ len noʼo ibëla sön cazuʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Laʼtuʼ inníaʼ: “Ucachiʼ nedaʼ le naca chul-la”, en laʼtuʼ huöáca chul-la beníʼ zóalen nedaʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","bitiʼ gaca chul-la loʼ Liʼ lë naʼ naca chul-la quiaʼ, pero chiʼi dzö́ʼölö gaca quiuʼ ca lahuiʼ dza. Tuz ca nácagaca loʼ Liʼ le naca chul-la, en le naca lahuiʼ dza. ");
INSERT INTO zarNT_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Nun cazuʼ Liʼ le zoa icja ládxiʼdaʼahuaʼ. Benuʼ ga guyáʼ lë́ʼënu xináʼa le naca cazaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Guíaʼ Liʼ: “Xclenuʼ” tuʼ run ga rubánidaʼ ca nun cazuʼ nedaʼ, ateʼ rádxidaʼ Liʼ tuʼ tun le nunuʼ ga rubánidaʼ, ateʼ böʼ naca cazaʼ nözi caz naca caní. ");
INSERT INTO zarNT_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Bitiʼ bigachiʼ loʼ le naca cazaʼ cateʼ niʼ siʼ galjaʼ, cateʼ niʼ yuʼa lë́ʼënu xináʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Biléʼe quézinuʼ nedaʼ cateʼ niʼ siʼ galjaʼ, tuʼ chinuzúajgaca lu guichi quiuʼ yuguʼ dza ral-laʼ soaʼ ibanaʼ, sal-laʼ bitiʼ ridxini nitú dza naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","Nazácaʼtërögaca quiaʼ le rizáʼ ládxuʼu, Dios. Ziántërö nácagaca lë naʼ rizáʼ ládxuʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Laʼtuʼ huáca nu ulaba léguequi, ilácagaca ziántërö ca nácagaca guiö́j yuzxi. Cateʼ rubanaʼ, niʼ zóalenaʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Raca ládxaʼa usunítiuʼ nupa tuáʼ döʼ, Dios. Que lë ni naʼ, guliʼcuíta ga zoaʼ, núlöliʼ rútiliʼ bönachi. ");
INSERT INTO zarNT_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Tuíʼi didzaʼ ziʼ ca nacuʼ Liʼ, Dios, ateʼ nupa taʼdáʼbagaʼ Liʼ taʼnnë́ liz que Loʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","¿Naruʼ cabí riledaʼ nupa taʼlé Liʼ, Xan? ¿Naruʼ cabí ruzóaʼ tsöláʼalö nupa taʼdáʼbagaʼ Liʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Idú ládxaʼa bitiʼ riléʼedaʼ léguequi dxiʼa. Nuzóaʼ léguequi ca nupa taʼdíl-lalen nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Buyú nedaʼ, Dios, en gúquibeʼe le zoa icja ládxiʼdaʼahuaʼ. Guzxíʼ bëʼ nedaʼ, en gúquibeʼe le rizáʼ ládxaʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Buyú channö zóalen nedaʼ le naca döʼ, en buluíʼi nedaʼ nöza tsahuiʼ quiuʼ zóaticaʼsö. ");
INSERT INTO zarNT_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","Busölá nedaʼ, Xan, lu náʼagaca nupa tuáʼ döʼ. Ben chiʼi nedaʼ para cabí bi ilunëʼ bönniʼ ziʼ quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","Taʼzáʼ ládxëʼë le nácagaca xihuiʼ ilunëʼ, en tunëʼ ga ilaʼdíl-lalen bönachi luzë́ʼeguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Didzaʼ tuʼë tun ga nácagaca lúdxiʼgaquiëʼ ca yuguʼ bëla síniaʼ. Yuʼu ruáʼagaquiëʼ le nachë́ʼ yöl-laʼ guti ca le dxía lu láyiʼbaʼ bëla naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","Ben chiʼi nedaʼ, Xan, para cabí bi ilunëʼ bönniʼ tuʼë döʼ quiaʼ. Ben chiʼi nedaʼ para cabí bi ilunëʼ bönniʼ zidzaj quiaʼ, bönniʼ naʼ të́ʼënëʼ ilunëʼ ga ichixi iníguidaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Nupa tun ba zxön cuínguequi nucáchiʼgaca le sön nedaʼ, encaʼ du yalaj iröli nedaʼ. Nucáchiʼgaca du yalaj ga ral-laʼ tödaʼ. Nucö́zagaca le ilaʼzö́n nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","Gudxaʼ-nëʼ Xanruʼ: “Nacuʼ Dios quiaʼ. Ruzë́ naguʼ, Xan, yuguʼ le rinábidaʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","Xanaʼ Dios, naca cazuʼ Nu rusölá nedaʼ len yöl-laʼ huáca quiuʼ. Ben chiʼi cazuʼ icjaʼ cateʼ niʼ zoaʼ lu gudil-la. ");
INSERT INTO zarNT_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","Bitiʼ guʼu lataj, Xan, gaca quiaʼ le rë́ʼënëʼ gunëʼ bönniʼ ruʼë döʼ. Bitiʼ guʼu lëʼ lataj idéliʼnëʼ le rizáʼ ládxëʼë, para cabí tsë́pisëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Nacuáʼ nupa nagúʼugaca nedaʼ lë́ʼajlö. Busubagaʼ ícjagaquiëʼ döʼ të́ʼënëʼ iluʼë quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Ben ga ilaʼbixaj boʼ yalaj lahui ícjagaquiëʼ. Bëʼ lataj tsöjtsázagaquiëʼ tu lu guíʼ zxön, en yuguʼ lu yeru zila ga bitiʼ ilaʼzéquiʼnëʼ uluʼrúajëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Bitiʼ guʼu lataj soëʼ bönniʼ rizíʼ yëʼë luyú ni. Ben ga udxín queëʼ bönniʼ zidzaj döʼ ruʼë.” ");
INSERT INTO zarNT_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Nözdaʼ gunëʼ Xanruʼ ga uluʼrúaj tsahuiʼ nupa taʼguíʼi taʼzacaʼ, en uchiʼa usörö́ëʼ quégaca bönachi yechiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Le nácatë ilë́ Liʼ: “Xclenuʼ” nupa nácagaca tsahuiʼ tuʼ tuʼlidza Loʼ. Ilaʼcuáʼ ga zoa cazuʼ Liʼ nupa nácagaca dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","Rulidzaʼ Liʼ, Xan. Gudáchi ga zoaʼ. Ruzë́ naguʼ chiʼa cateʼ rulidzaʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Buyú le rulidzaʼ Liʼ ca dzön yalaj le ridxín loʼ, en cateʼ richisa naʼa, buzíʼ le ca tu böaʼdoʼ uzéguiʼa-baʼ loʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Ben chiʼi ruáʼa, Xan, en gudapa chiʼi guídi ruáʼa para cabí guʼa didzaʼ ziʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Bitiʼ guʼu lataj gaca ládxaʼa le cabí nácatë, para cabí gunaʼ le naca xihuiʼ len yuguʼ bönniʼ tutiëʼ bönachi. Bitiʼ guʼu lataj gunaʼ léguequi tsözxö́n. ");
INSERT INTO zarNT_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Bëʼ lataj guʼë nedaʼ bönniʼ tsahuiʼ lu yöl-laʼ nadxíʼi queëʼ para uzéajniʼinëʼ nedaʼ. Le gunëʼ gaca quiaʼ ca le za cuʼë icjaʼ. Bitiʼ guʼu lataj táʼbagaʼ icjaʼ le ilún nupa tuáʼ döʼ. Rinábidaʼ Liʼ uzaguʼ xinö́zguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","Ilaʼládzuʼgaquiëʼ bönniʼ lo quéguequi lëʼe guíʼa guiö́j, ateʼ iléquibeʼe gulaca dxiʼa didzaʼ bëʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Ca raca cateʼ nu rugáʼana-baʼ bëdxi, en ruláʼa yu, caʼ gaca que dxita yúʼugaquiëʼ, le gulásilasi raʼ ba que xilátjagaca nupa nátigaca. ");
INSERT INTO zarNT_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Richisa lahuaʼ ruyúaʼ ga zuʼ Liʼ, Xantuʼ Dios. Rucachiʼ cuinaʼ ga naʼ zuʼ. Bitiʼ usán noʼo nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Ben ga bitiʼ tsöjbixaʼ lu le sön nedaʼ, lë naʼ nucáchiʼgaca, en ga bitiʼ tsöjtsazaʼ lu du yalaj nucö́zagaca nupa tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Bëʼ lataj ilaʼyaza laʼ cuíngacasö lu du yalaj buluʼcachiʼ nupa tuáʼ döʼ, pero benna lataj tö́disaʼ nedaʼ ga naʼ nagachiʼ du yalaj naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Rulidzaʼ-nëʼ Xanruʼ, ruʼa zidzaj didzaʼ. Rátaʼyuaʼ lahuëʼ Xanruʼ uzáʼ ládxëʼë quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","Rudödaʼ lahuëʼ yöl-laʼ rinaba yudxi quiaʼ, en rusiyöndaʼ Lëʼ le rácagaca quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Cateʼ budú ládxaʼa, gunözi quézinuʼ Liʼ le guca quiaʼ. Laʼ nöza ga ridáʼ nedaʼ buluʼcachiʼ le sön nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Buyú cuitaʼ ibëla tuʼ cuntu nu zoa nu ruíʼi ladxiʼ nedaʼ. Bitiʼ bi zoa le gácalen nedaʼ. Cuntu nu run chiʼi böʼ naca cazaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Gurö́dxiʼa loʼ Liʼ, Xan, gunníaʼ: Run chiʼi cazuʼ nedaʼ Liʼ, en naca cazuʼ Nu rácalen nedaʼ ladaj nupa nabángaca. ");
INSERT INTO zarNT_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Ruzë́ naguʼ le rulidzaʼ Liʼ, tuʼ nagáʼanaʼ cáʼasö. Busölá nedaʼ lu náʼagaca nupa taʼzóa reguʼ nedaʼ, tuʼ nácatërögaca nál-la ca nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Guléaj böʼ naca cazaʼ lu yuʼu lidxi guíë, para gaca guíaʼ Liʼ: “Xclenuʼ” tuʼ rulidzaʼ Loʼ. Nupa nácagaca tsahuiʼ uluʼdubi idú gásibiʼilö ga zoaʼ, tuʼ gunnuʼ sizxöni quiaʼ le riquindaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Ruzë́ naguʼ le rulidzaʼ Liʼ, Xan. Ruzë́ naguʼ le rinabi yúdxidaʼ Liʼ. Tuʼ runuʼ ca rnna didzaʼ bëʼu, en nacuʼ tsahuiʼ gunníuʼ ");
INSERT INTO zarNT_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","bitiʼ ichëʼu nedaʼ loʼ ga uchiʼa usörö́uʼ quiaʼ, huen dxin quiuʼ. Cuntu nu zoa naca tsahuiʼ loʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Nu bitiʼ riléʼe nedaʼ dxiʼa zoa reguʼ böʼ naca cazaʼ. Nuzötjëʼ yöl-laʼ naʼbán quiaʼ lu yu. Benëʼ ga zoaʼ lataj naca chul-la ca raca quégaca nupa gulati dza niʼte. ");
INSERT INTO zarNT_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Que lë ni naʼ rudú ládxaʼa, en röʼa böniga. ");
INSERT INTO zarNT_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Röjnedaʼ dza chigulaʼdödi. Rizáʼ ládxaʼa ca nácagaca le benuʼ Liʼ. Ribequi icjaʼ ca nácagaca le nun noʼo. ");
INSERT INTO zarNT_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Richisa naʼa zacaʼ ga zuʼ Liʼ. Rizë́ ládxaʼa Liʼ ca tu luyú bidxi rizë́ ladxiʼ nisa guiö́j. ");
INSERT INTO zarNT_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Bubíʼitë didzaʼ, Xan, tuʼ rudú ládxaʼa. Bitiʼ ucachiʼ loʼ lahuaʼ nedaʼ, para cabí gacaʼ ca tu bönniʼ ruʼë lataj chul-la ga nacuáʼ nupa nátigaca. ");
INSERT INTO zarNT_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Ben ga yöndaʼ yuguʼ zila ca naca yöl-laʼ dxiʼi ladxiʼ quiuʼ, tuʼ ruzxöni ládxaʼa Liʼ. Busëdi nedaʼ ca ral-laʼ gunaʼ, tuʼ ruchisaʼ loʼ Liʼ böʼ naca cazaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Busölá nedaʼ, Xan, lu náʼagaca nupa bitiʼ taʼléʼe nedaʼ dxiʼa. Nacuʼ Nu ruzóa nedaʼ tsutsu. ");
INSERT INTO zarNT_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Busedi nedaʼ para gunaʼ ca rë́ʼënuʼ Liʼ, tuʼ naca cazuʼ Liʼ Dios quiaʼ. Bëʼ lataj ichë́ʼ Böʼ Láʼayi quiuʼ nedaʼ lu nöza tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Butipa ládxaʼa, Xan, para gaca yöl-laʼ ba que Loʼ. Tuʼ nacuʼ tsahuiʼ busölá nedaʼ lu le raca quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Lu yöl-laʼ dxiʼi ladxiʼ quiuʼ guchugu quégaca nupa bitiʼ taʼléʼe nedaʼ dxiʼa. Busuniti yúguʼtë nupa tuʼsacaʼ ziʼ böʼ naca cazaʼ, tuʼ nacaʼ huen dxin quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","¡Yöl-laʼ ba Lëʼ, Xanruʼ Dios! ¡Náquiëʼ ca tu guiö́j ga zoaʼ tsutsu! Rutipëʼ naʼa para gaca tsejaʼ gudil-la, en rutipëʼ caʼ xibö́n naʼa para gaca tíl-lalenaʼ bönniʼ nácagaquiëʼ nál-la. ");
INSERT INTO zarNT_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Naca cazëʼ Xanruʼ yöl-laʼ dxiʼi ladxiʼ quiaʼ, encaʼ ca tu ga zoaʼ tsutsu lu gudil-la. Rusölë́ʼ nedaʼ, en náquiëʼ ca tu ga zoaʼ tsaz. Náquiëʼ ca tu le run chiʼi nedaʼ lu gudil-la, ateʼ rucachiʼ cuinaʼ ga naʼ zoëʼ. Runëʼ ga tun nupa rinná béʼedaʼ ca rnna didzaʼ ruʼa. ");
INSERT INTO zarNT_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","¿Bízxatë caz náquiëʼ bönniʼ tuʼ runuʼ lëʼ ba láʼana, Xan? ¿Bízxatë caz náquiëʼ bönniʼ tuʼ ruíʼi ladxiʼ cazuʼ lëʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Naca cazëʼ bönniʼ naʼ ca tu böʼdoʼ recja, ateʼ yuguʼ dza zoëʼ nabanëʼ nácagacasö ca tu zxul-la le rigúʼu tu böaj ridö́disö. ");
INSERT INTO zarNT_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","Buzötaj lúzxiba, en bdinne ni, Xan. Gudán yuguʼ guíʼa, ateʼ irúaj dzön lë́ʼeguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Ben ga tsëpi yösa quiuʼ, en bë́silasi léguequi. Busë́ yuguʼ yaga lahui tuchiʼ, en ben ga ilaʼbö́ʼ baguíʼisö. ");
INSERT INTO zarNT_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Bulí noʼo ga naʼ zuʼ xitsáʼalö. Busölá nedaʼ, en guléaj nedaʼ lu náʼagaca bönachi ziʼtuʼ, le gaca ca rubéajuʼ nedaʼ lu nisa zila. ");
INSERT INTO zarNT_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","Taʼzíʼ yëʼ bönachi naʼ, ateʼ le cabí nácatë naca yöl-laʼ unná bëʼ quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","¡Gul-laʼ quiuʼ Liʼ, Dios, tu le cubi! ¡Gul-laʼ quiuʼ yöl-laʼ ba, en quínniaʼ bihuël-la nuáʼ chi du que! ");
INSERT INTO zarNT_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","Rusölá cazuʼ bönniʼ taʼnná bëʼë. Busölóʼ David, huen dxin quiuʼ, lu guíë tuchiʼ queëʼ bönniʼ ruʼë döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Gúcalen nedaʼ, en busölá nedaʼ lu náʼagaca bönachi ziʼtuʼ. Taʼzíʼ yëʼ bönachi naʼ, ateʼ le cabí nácatë naca yöl-laʼ unná bëʼ quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Ben ga ilácabiʼ biʼi bönniʼ queë́tuʼ ni yuʼugacabiʼ iz cuidiʼ ca yuguʼ yaga nazxö́ngaca, en ben ga ilácabiʼ biʼi nigula queë́tuʼ ca nácagaca yaʼzxén que tu yuʼu nazacaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Ben ga ilígaca yuʼu queë́tuʼ zxoaʼ za utúbituʼ, en ben ga iláljabaʼ gayuáʼ gayuáʼabaʼ chíbodoʼ, en böʼcuʼ zxílaʼdoʼ ga nucuáʼatuʼ-baʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","Ben ga uluʼcuáʼabaʼ böaʼ huë́ʼënidoʼ quégaca böaʼ guixiʼ queë́tuʼ, en ga bitiʼ bi gaca quégacabaʼ bëdxi zxön, en bë́dxidoʼ caʼ. Bitiʼ guʼu lataj soa nu cödxi yechiʼ laʼ nöza que ládzatuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","¡Bicaʼ bágaca bönachi raca caní quéguequi! ¡Bicaʼ bágaca bönachi naʼ Xanruʼ Dios náquiëʼ Dios quéguequi! ");
INSERT INTO zarNT_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","¡Gunaʼ Liʼ zxön, Dios! ¡Nacuʼ Nu rinná beʼe nedaʼ! ¡Gádxiticaʼsaʼ Loʼ, Xanaʼ Dios! ");
INSERT INTO zarNT_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","¡Tu dza tu dza cuʼa Liʼ yöl-laʼ zxön, en cúʼuticaʼsaʼ Loʼ yöl-laʼ ba! ");
INSERT INTO zarNT_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","¡Nayë́pisëtërëʼ Xanruʼ Dios, ateʼ cúʼuruʼ-nëʼ yöl-laʼ ba! ¡Bitiʼ caʼ gaca gúnbëʼëruʼ ca naca yöl-laʼ zxön queëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Yúguʼtë bönachi ilaʼgúʼu yöl-laʼ ba le nun cazuʼ Liʼ, para uluʼsiyö́n zxíʼinigaca, en uluʼluíʼi lahui le nácagaca zxön benuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Saʼ ládxaʼa ca naca yöl-laʼ zxön que yöl-laʼ unná bëʼ quiuʼ, en ca nácagaca yöl-laʼ huáca zxön runuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Iluíʼi didzaʼ yúguʼtë bönachi ca naca yöl-laʼ zxön quégaca yöl-laʼ huáca runuʼ. Usiyöndaʼ bönachi ca naca yöl-laʼ zxön quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Idú ládxiʼgaca iluíʼi didzaʼ cateʼ tsöjnégaca yöl-laʼ dxiʼi ladxiʼ zxön quiuʼ. Lu yöl-laʼ rudzeja quéguequi ilaʼbö́dxiʼa tuʼ nacuʼ tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Xanruʼ Dios ruzáʼ ládxëʼë queë́ruʼ, en ruhuéchiʼ ládxëʼë rëʼu. Bitiʼ iléticaʼsëʼ, ateʼ zxö́ntërö naca yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Runëʼ Xanruʼ Dios le naca dxiʼa quégaca yúguʼtë bönachi, en ruhuéchiʼ ládxëʼë yúguʼtë le nunëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Yúguʼtë le nunuʼ ilë́ Liʼ: “Xclenuʼ” Xan, ateʼ nupa néquiguequi quez quiuʼ ilún Liʼ zxön. ");
INSERT INTO zarNT_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Iluíʼi didzaʼ ca naca yöl-laʼ zxön que le rinná bëʼu, en uluʼluíʼi lahui yöl-laʼ zxön quiuʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","para uluʼsiyö́n bönachi ca nácagaca le zxön runuʼ, en ca naca yöl-laʼ zxön que le rinná bëʼu le nayë́pisëtërö. ");
INSERT INTO zarNT_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","¡Zóaticaʼsö le rinná bëʼu, ateʼ idíaʼticaʼsö yöl-laʼ unná bëʼ quiuʼ! ¡Lu le naca idú ladxiʼ queëʼ runëʼ Dios ca rnnágaca yúguʼtë didzaʼ ruʼë, en lu yöl-laʼ dxiʼi ladxiʼ queëʼ runëʼ yúguʼtë le runëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","¡Röjzönëʼ Xanruʼ yúguʼtë nupa röjtsö́ʼögaca, en ruchisëʼ yúguʼtë nupa ndínnegaca! ");
INSERT INTO zarNT_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","¡Yúguʼtë bönachi tuʼyú Liʼ, Xan, ateʼ runödzjuʼ le ilágugaca cateʼ ridxín dza que! ");
INSERT INTO zarNT_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","¡Rusalaj cazuʼ noʼo en rugaguʼ yúguʼtë le nacuáʼ nabángaca! ");
INSERT INTO zarNT_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Náquiëʼ tsahuiʼ Xanruʼ Dios ca naca yúguʼtë le runëʼ en náquiëʼ caʼ dxiʼi ladxiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Zoëʼ Xanruʼ galaʼ ga nacuáʼ yúguʼtë nupa tuʼlidza Lëʼ, nupa naʼ tuʼlidza Lëʼ idú ládxiʼguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Gunnëʼ le taʼzë́ ládxiʼgaca quégaca nupa tadxi Lëʼ. Riyönnëʼ cateʼ tuʼlidza Lëʼ, en rusölë́ʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Run chiʼi cazëʼ Xanruʼ yúguʼtë nupa nadxíʼigaca Lëʼ, pero usunítiëʼ nupa tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Len ruʼa cuinaʼ cuʼa-nëʼ Xanruʼ yöl-laʼ ba, ateʼ yúguʼtë bönachi ilúnticaʼsö Lëʼ zxön. ");
INSERT INTO zarNT_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","¡Guliʼcuʼë yöl-laʼ ba Xanruʼ! ¡Liʼ, böʼ naca cazaʼ, guluʼë yöl-laʼ ba Xanruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","¡Cuʼa-nëʼ Xanaʼ yöl-laʼ ba tsanni ni zoaʼ nabanaʼ! ¡Gul-laʼ yöl-laʼ ba queëʼ Dios quiaʼ tsanni ni zoa böʼ naca cazaʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Bitiʼ uzxöni ládxiʼliʼ bönniʼ taʼnná bëʼë, en calëga bönniʼ tati cazëʼ, bönniʼ bitiʼ caʼ gaca uluʼsölë́ʼ rëʼu. ");
INSERT INTO zarNT_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Rurúaj böʼ yuʼë nu bönniʼ, ateʼ ruhuöáquiëʼ yu. Laʼ dza náʼasö riniti le rizáʼ ládxëʼë gunëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Bicaʼ ba bönniʼ rácalenëʼ Dios queëʼ Jacob lëʼ, bönniʼ naʼ runëʼ löza Xanruʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Nunëʼ Xanruʼ Dios lúzxiba, en luyú ni, encaʼ nísadoʼ, en yúguʼtë le nacuáʼ yuguʼ lataj naʼ. Rúnticaʼsëʼ Lëʼ ca rnna didzaʼ bëʼë, ");
INSERT INTO zarNT_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","en ruchiʼa rusörö́ëʼ nupa zoa nu rusacaʼ ziʼ léguequi. Rugagu cazëʼ nupa taʼdún. Rusanëʼ Xanruʼ Dios nupa nadzúngaca. ");
INSERT INTO zarNT_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","Rusaljëʼ Xanruʼ Dios guiö́j lógaca nupa nácagaca lo chul-la. Ruchisëʼ Xanruʼ Dios nupa nadzö́ʼögaca. Nadxíʼinëʼ Xanruʼ Dios nupa nácagaca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Rapa chiʼë Xanruʼ Dios yuguʼ bönniʼ ziʼtuʼ. Rácalenëʼ-biʼ yuguʼ biʼi uzëbi, encaʼ yuguʼ nigula uzëbi, pero ruzaguëʼ xinö́zguequi nupa tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Inná bë́ʼticaʼsëʼ Xanruʼ Dios. Náquiëʼ Dios queë́liʼ, bönachi Sión. ¡Guliʼcuʼë yöl-laʼ ba Xanruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","¡Guliʼcuʼë yöl-laʼ ba Xanruʼ! ¡Tsahuiʼ naca gúl-laruʼ yöl-laʼ ba queëʼ Dios queë́ruʼ! ¡Naca lachi, en le ral-laʼ gunruʼ, cúʼuruʼ-nëʼ yöl-laʼ ba! ");
INSERT INTO zarNT_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Runëʼ Xanruʼ Dios ga rizxö́n yödzö Jerusalén. Rutubëʼ bönniʼ Israel násilasigaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Ruúnëʼ bönniʼ nácagaquiëʼ yechiʼ ladxiʼ, en rudë́ʼë lariʼ ga dxíagaquiëʼ huëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Rulabëʼ tsca nacuáʼ bölaj lúzxiba. Nucuʼë lágacabaʼ tu tubaʼ yúguʼtë bölaj naʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Nayë́pisëtërëʼ Xanruʼ Dios, en nál-latërëʼ. Ga rëʼë dzu réajniʼinëʼ yúguʼtë. ");
INSERT INTO zarNT_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Xanruʼ Dios rácalenëʼ nupa taʼguíʼi taʼzacaʼ. Ruzötjëʼ nupa tuáʼ döʼ lu yu. ");
INSERT INTO zarNT_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","¡Guliʼgul-la queëʼ Xanruʼ Dios, guië́liʼ-nëʼ: “Xclenuʼ”! ¡Guliʼgul-la yöl-laʼ ba queëʼ Xanruʼ, quínniliʼ lë́ʼegaca bihuë́l-ladoʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Riguísiëʼ yuguʼ böaj lúzxiba, en risö́l-lëʼë nisa guiö́j luyú. Runëʼ ga rilén yö yuguʼ lu guíʼadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Rugahuëʼ yuguʼ böaʼ guíxiʼdoʼ, encaʼ bóiquiajdoʼ taʼbö́dxiʼabaʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Bitiʼ raza ládxëʼë yöl-laʼ nál-la queë́baʼ böaʼ, en bitiʼ ruziʼë xibé yöl-laʼ nál-la queëʼ bönniʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","Raza ládxëʼë Xanruʼ Dios nupa tadxi Lëʼ, nupa naʼ tun löza yöl-laʼ dxiʼi ladxiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","¡Guliʼcuʼë yöl-laʼ ba Xanruʼ, libíʼiliʼ zóaliʼ Jerusalén! ¡Guliʼcuʼë yöl-laʼ ba Dios queë́liʼ, libíʼiliʼ zóaliʼ Sión! ");
INSERT INTO zarNT_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","Bucuʼë tsutsu le tuʼbagaʼ gapa nu riyaza yödzö queë́liʼ, en runëʼ ga raca dxiʼa quégaca zxíʼiniliʼ ga naʼ zóaliʼ. ");
INSERT INTO zarNT_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Runëʼ ga ribö́zaliʼ dxiʼa tsáhuiʼdoʼ, en runëʼ ga ruhuölaj ridzéʼeliʼ zxoaʼ xtila dxíʼatërö. ");
INSERT INTO zarNT_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Rinná béʼenëʼ yödzölió ni, ateʼ xtídzëʼë ridö́ditë gátiʼtës. ");
INSERT INTO zarNT_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Risö́l-lëʼë guiö́j böguiʼ ca zxilaʼ, en riguísiëʼ buzén ca dö. ");
INSERT INTO zarNT_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Riguísiëʼ böguiʼ ca yuguʼ guiö́j ruaj. ¿Nuzxi caz gaca guáʼ ilén le naca ziaga queëʼ? ");
INSERT INTO zarNT_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Risö́l-lëʼë xtídzëʼë, ateʼ ruúnaʼ böguiʼ naʼ. Runëʼ ga recja böʼ, ateʼ ruhuöáca nisa. ");
INSERT INTO zarNT_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Ruíʼilenëʼ zxíʼini xiʼsóëʼ Jacob didzaʼ, en riguíxjëʼ xibá queëʼ para ilún bönachi Israel ca rnna. ");
INSERT INTO zarNT_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Bitiʼ benëʼ caní niʼa quégaca bönachi iaʼtú yödzö izáʼa, ateʼ bitiʼ nö́zigaca ca nácagaca le gunná bëʼë. ¡Guliʼcuʼë yöl-laʼ ba Xanruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","¡Guliʼcuʼë yöl-laʼ ba Xanruʼ! ¡Guliʼcuʼë yöl-laʼ ba, libíʼiliʼ zóaliʼ yehuaʼ yubá! ¡Guliʼcuʼë yöl-laʼ ba, libíʼiliʼ zóaliʼ xitsáʼalö! ");
INSERT INTO zarNT_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","¡Guliʼcuʼë yöl-laʼ ba, libíʼiliʼ gubáz láʼayi queëʼ! ¡Guliʼcuʼë yöl-laʼ ba, libíʼiliʼ tscaliʼ dáʼaliʼ Lëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","¡Guliʼcuʼë yöl-laʼ ba, libíʼiliʼ gubidza, en beoʼ! ¡Guliʼcuʼë yöl-laʼ ba, libíʼiliʼ bölaj beníʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","¡Guliʼcuʼë yöl-laʼ ba, libíʼiliʼ zóaliʼ zxan lúzxiba! ¡Guliʼcuʼë yöl-laʼ ba, libíʼiliʼ nisa, zxóaliʼ láhuilö lúzxiba! ");
INSERT INTO zarNT_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","¡Guliʼcúʼu yöl-laʼ ba La laʼayi queëʼ Xanruʼ, yúguʼtëliʼ, tuʼ bë́ʼësëʼ didzaʼ, en canísö benëʼ libíʼiliʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Naguixjëʼ tsaz libíʼiliʼ. Naguixjëʼ xtídzëʼë le catu caz tödi que. ");
INSERT INTO zarNT_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","¡Guliʼcuʼë yöl-laʼ ba Xanruʼ idútë yödzölió, en libíʼiliʼ böaʼ ridaliʼ lu nísadoʼ, en nísadoʼ caz, ");
INSERT INTO zarNT_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","en libíʼiliʼ guíʼ, en guiö́j böguiʼ yöla sunna, böguiʼ, en böaj, encaʼ liʼ, böʼ budunuʼ, runuʼ ca rnna xtídzëʼë, ");
INSERT INTO zarNT_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","en libíʼiliʼ yuguʼ guíʼa, en yúguʼtë guíʼadoʼ, en libíʼiliʼ yaga dxíagaca le taʼbía, en yuguʼ yaga dxiʼa, ");
INSERT INTO zarNT_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","en libíʼiliʼ böaʼ guixiʼ, en böaʼ bëdxi, böaʼ táʼayöj lë́ʼëbaʼ lu yu, en böaʼ zoa xíligacabaʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","encaʼ libíʼiliʼ rinná bë́ʼëliʼ yödzölió, en bönachi yuguʼ yödzö izáʼa, yuguʼ zxíʼinigaquiëʼ bönniʼ taʼnná bëʼë, en bönniʼ ruchiʼa rusöröliʼ yödzölió, ");
INSERT INTO zarNT_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","encaʼ libíʼiliʼ biʼi bönniʼ, en biʼi nigúladoʼ, yuguʼ bönniʼ zxön, en yuguʼ bíʼidoʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","¡Guliʼcúʼu yöl-laʼ ba La laʼayi queëʼ Xanruʼ tuʼ nayë́pisëtërö tuzëʼ Lëʼ! ¡Nayë́pisëtërö yöl-laʼ ba queëʼ ca luyú ni, en ca lúzxiba xitsáʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Nuchisëʼ tu le nuzóa tsutsu bönachi queëʼ, le naca yöl-laʼ ba taʼgúʼu Lëʼ nupa néquiguequi queëʼ, yuguʼ zxíʼini xiʼsóëʼ Israel, nupa naʼ nadxíʼinëʼ. ¡Guliʼcuʼë yöl-laʼ ba Xanruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","¡Guliʼcuʼë yöl-laʼ ba Xanruʼ! ¡Guliʼgul-la queëʼ Xanruʼ Dios tu le cubi, en guliʼgul-la yöl-laʼ ba queëʼ ga nudúbigaca nupa néquiguequi quez queëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Ral-laʼ uluʼzíʼ xibë́ʼ Xanruʼ Dios bönachi Israel, tuʼ náquiëʼ Nu ben léguequi. Ral-laʼ uluʼdzéjalen Dios nupa nacuáʼ Sión, tuʼ náquiëʼ Nu rinná beʼe léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Ral-laʼ ilaʼgúʼu yöl-laʼ ba La laʼayi queëʼ, en lu yöl-laʼ rudzeja uluʼyáʼa lahuëʼ. Ral-laʼ ilúl-la yöl-laʼ ba queëʼ, ilaʼcapaʼ lëʼe guídi, en ilaʼquínni lë́ʼegaca bihuë́l-ladoʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","tuʼ raza ládxëʼë Xanruʼ Dios bönachi queëʼ. Uchisëʼ nupa taʼguíʼi taʼzacaʼ, en usölë́ʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Nupa néquiguequi quez queëʼ ral-laʼ uluʼdzeja ládxiʼgaca lu beníʼ queëʼ. Lu yöl-laʼ rudzeja quéguequi ral-laʼ ilúl-la queëʼ cateʼ niʼ dë́gaca lu le rátiʼgaca. ");
INSERT INTO zarNT_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Yöl-laʼ ba queëʼ Xanruʼ Dios ral-laʼ sóaticaʼsö ruíʼiguequi, en tu guíë tuchiʼ natuchiʼ iropa laʼa lu náʼagaca, ");
INSERT INTO zarNT_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","para uluʼzíʼ lëbi bönachi yuguʼ yödzö izáʼa, en ilún xiguiaʼ bönachi izáʼa naʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","para ilúguëʼë breguiʼ guíë náʼagaquiëʼ bönniʼ taʼná béʼenëʼ bönachi yödzö izáʼa naʼ, en uluʼcuʼë breguiʼ guíë yen náʼagaquiëʼ bönniʼ lo quégaquiëʼ, ");
INSERT INTO zarNT_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","para ilunëʼ quéguequi ca nachuguëʼ Dios gaca quéguequi. Naca lë ni le run bal nupa néquiguequi quez queëʼ Dios. ¡Guliʼcuʼë yöl-laʼ ba Xanruʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","¡Guliʼcuʼë yöl-laʼ ba Xanruʼ! ¡Guliʼcuʼë yöl-laʼ ba Dios lu lataj láʼayi queëʼ! ¡Guliʼcuʼë yöl-laʼ ba ga dëdaʼ lataj queëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","¡Guliʼcuʼë yöl-laʼ ba ca nácagaca le zxön nunëʼ! ¡Guliʼcuʼë yöl-laʼ ba ca naca yöl-laʼ zxön queëʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","¡Guliʼcuʼë yöl-laʼ ba, ucö́dxiliʼ lúzugacabaʼ chivo! ¡Guliʼcuʼë yöl-laʼ ba, quínniliʼ lë́ʼegaca bihuël-la caʼ! ");
INSERT INTO zarNT_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","¡Guliʼcuʼë yöl-laʼ ba, cápaʼliʼ lëʼe guídi, en uyaʼaliʼ! ¡Guliʼcuʼë yöl-laʼ ba, quínniliʼ lë́ʼegaca bihuël-la, en ucö́dxiliʼ gui! ");
INSERT INTO zarNT_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","¡Guliʼcuʼë yöl-laʼ ba, utíl-laliʼ guíë lëʼe luzë́ʼe! ¡Guliʼcuʼë yöl-laʼ ba, utíl-laliʼ guíë zxön lëʼe luzë́ʼe! ");
INSERT INTO zarNT_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","¡Guliʼcuʼë yöl-laʼ ba Xanruʼ, tscaliʼ rizíʼiliʼ böʼ! ¡Guliʼcuʼë yöl-laʼ ba Xanruʼ!");
INSERT INTO zarNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ni ruzúajaʼ lágaquiëʼ xuz xinëʼe gudödi queëʼ Jesucristo. Nabábagaquiëʼ David, encaʼ Abraham xuz gudödi queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham gúquiëʼ xuzëʼ Isaac. Isaac gúquiëʼ xuzëʼ Jacob. Jacob gúquiëʼ xúzgaquiëʼ Judá, en yuguʼ bönniʼ bö́chëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá gúquiëʼ xúzgaquiëʼ Fares, en Zara, ateʼ Tamar gúcanu xináʼagaquiëʼ. Fares gúquiëʼ xuzëʼ Esrom. Esrom gúquiëʼ xuzëʼ Aram. ");
INSERT INTO zarNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram gúquiëʼ xuzëʼ Aminadab. Aminadab gúquiëʼ xuzëʼ Naasón. Naasón gúquiëʼ xuzëʼ Salmón. ");
INSERT INTO zarNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón gúquiëʼ xuzëʼ Booz, ateʼ Rahab gúcanu xinë́ʼë. Booz gúquiëʼ xuzëʼ Obed, ateʼ Rut gúcanu xinë́ʼë. Obed gúquiëʼ xuzëʼ Isaí. ");
INSERT INTO zarNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí gúquiëʼ xuzëʼ David. David naʼ gunná béʼenëʼ bönachi Israel, ateʼ butsaga náʼalenëʼ-nu nigula naʼ gúcanu zíʼalö nigula queëʼ Urías, ateʼ David, en nigula ni guláquiëʼ xuz xinë́ʼë Salomón. ");
INSERT INTO zarNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón gúquiëʼ xuzëʼ Roboam. Roboam gúquiëʼ xuzëʼ Abías. Abías gúquiëʼ xuzëʼ Asa. ");
INSERT INTO zarNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa gúquiëʼ xuzëʼ Josafat. Josafat gúquiëʼ xuzëʼ Joram. Joram gúquiëʼ xuzëʼ Uzías. ");
INSERT INTO zarNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías gúquiëʼ xuzëʼ Jotam. Jotam gúquiëʼ xuzëʼ Acaz. Acaz gúquiëʼ xuzëʼ Ezequías. ");
INSERT INTO zarNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías gúquiëʼ xuzëʼ Manasés. Manasés gúquiëʼ xuzëʼ Amón. Amón gúquiëʼ xuzëʼ Josías. ");
INSERT INTO zarNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías gúquiëʼ xúzgaquiëʼ Jeconías, en yuguʼ bönniʼ bö́chëʼë. Yuguʼ bönniʼ ni gulaʼcuʼë dza niʼ cateʼ yuguʼ bönniʼ Babilonia gulaʼchë́ʼë bönachi Israel nadzúngaca lu xiyúgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jeconías gúquiëʼ xuzëʼ Salatiel. Salatiel gúquiëʼ xuzëʼ Zorobabel. ");
INSERT INTO zarNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel gúquiëʼ xuzëʼ Abiud. Abiud gúquiëʼ xuzëʼ Eliaquim. Eliaquim gúquiëʼ xuzëʼ Azor. ");
INSERT INTO zarNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor gúquiëʼ xuzëʼ Sadoc. Sadoc gúquiëʼ xuzëʼ Aquim. Aquim gúquiëʼ xuzëʼ Eliud. ");
INSERT INTO zarNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud gúquiëʼ xuzëʼ Eleazar. Eleazar gúquiëʼ xuzëʼ Matán. Matán gúquiëʼ xuzëʼ Jacob. ");
INSERT INTO zarNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob gúquiëʼ xuzëʼ José. José ni gúquiëʼ bönniʼ queë́nu María, ateʼ María ni gúcanu xinë́ʼë Jesús, lëʼ caʼ Cristo, Bönniʼ naʼ tun löza bönachi judío guídëʼ idinná béʼenëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Caní naca, gulaca chidáʼ cöʼ diʼa dza ga gusí lo zoëʼ Abraham ga bidxintë zoëʼ David, ateʼ gulaca caʼ iaʼchidáʼ cöʼ diʼa dza ga gusí lo zoëʼ David ga bidxintë dza yuguʼ bönniʼ Babilonia gulaʼchë́ʼë bönachi Israel nadzúngaca, ateʼ gulaca caʼ iaʼchidáʼ cöʼ diʼa dza ga gusí lo dza niʼ gulaʼchë́ʼë léguequi ga bidxintë dza guljëʼ Cristo. ");
INSERT INTO zarNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Caní guca cateʼ guljëʼ Jesucristo. Cateʼ niʼ chinazíʼ lu náʼabiʼ María, xinë́ʼë Jesucristo utsaga náʼalenbiʼ José, en zíʼatëlö cateʼ siʼ utsaga náʼalenëʼ-biʼ, en cabí ne sóalenëʼ-biʼ, guyúʼubiʼ tubiʼ bíʼidoʼ lë́ʼëbiʼ María naʼ. Guca caní niʼa que yöl-laʼ huáca queëʼ Dios Böʼ Láʼayi. ");
INSERT INTO zarNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Náquiëʼ José naʼ, bönniʼ queë́biʼ María, bönniʼ tsahuiʼ, pero bitiʼ gúʼunnëʼ uzéguiëʼ-biʼ didzaʼ lógaca bönachi. Gúʼunnëʼ uláʼalenëʼ-biʼ bagáchiʼsö. ");
INSERT INTO zarNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tsanni niʼ rizáʼ ládxëʼë José ca naʼ gunëʼ, buluíʼi lahuëʼ gubáz láʼayi queëʼ Xanruʼ lahuëʼ José lu yëla bë́chigal, en gudxëʼ lëʼ: —José, zxíʼini zxiʼsóëʼ David. Bitiʼ gádxinuʼ siʼu-biʼ María, para gácabiʼ nigula quiuʼ, tuʼ yúʼubiʼ biʼi bö́nniʼdoʼ lë́ʼëbiʼ niʼa que yöl-laʼ huáca queëʼ Dios Böʼ Láʼayi. ");
INSERT INTO zarNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Gáljabiʼ tubiʼ biʼi bö́nniʼdoʼ queë́biʼ, ateʼ guʼu labiʼ Jesús, tuʼ usölábiʼ bönachi queë́biʼ lu dul-laʼ nabágaʼgaca. ");
INSERT INTO zarNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Caní guca yúguʼtë lë ni para gaca lë naʼ gunnë́ʼ Xanruʼ lu ruʼë bönniʼ bëʼë didzaʼ uláz queëʼ Dios, gunnë́ʼ: ");
INSERT INTO zarNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Buliʼyútsöcaʼ, tu nigula raʼbandoʼ, tsúʼubiʼ bíʼidoʼ lë́ʼëbiʼ, ateʼ gáljabiʼ tubiʼ biʼi bö́nniʼdoʼ, ateʼ iluʼë labiʼ Emanuel. Emanuel naca tu didzaʼ hebreo le rnna: Len rëʼu Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Cateʼ bubanëʼ José lu yëla bë́chigal, benëʼ ca naʼ gudxëʼ gubáz láʼayi queëʼ Xanruʼ lëʼ, ateʼ guzxiʼë-biʼ María, ateʼ gúcabiʼ nigula queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Bitiʼ guzóalenëʼ-biʼ cateʼ bidxinrö dza chigúlajbiʼ biʼi bö́nniʼdoʼ queë́biʼ, biʼi zíʼalö queë́biʼ, ateʼ guluʼë labiʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Cateʼ gúljabiʼ Jesús lu yödzö Belén, luyú Judea, rinná bëʼë Herodes luyú niʼ, ateʼ bilaʼdxinëʼ bönniʼ taʼyéajniʼinëʼ Jerusalén, narúajgaquiëʼ tu yödzö dë sacaʼ ga rilén gubidza. ");
INSERT INTO zarNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Gulaʼnabëʼ bönniʼ ni, taʼnnë́ʼ: —¿Gazxi zóabiʼ bíʼidoʼ naʼ ral-laʼ inná béʼebiʼ bönachi judío, bíʼidoʼ naʼ siʼ gúljabiʼ? Cateʼ niʼ zóatuʼ ga rilén gubidza biléʼetuʼ-baʼ bölaj beníʼ naca bëʼ chigúlajbiʼ, ateʼ zaʼtuʼ ni para tseaj ládxiʼtuʼ-biʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Cateʼ gúquibeʼenëʼ Herodes, bönniʼ rinná bëʼë, lë ni, gurö́ʼödëʼ böniga, en lëscaʼ caní gulaʼbö́ʼ böniga yúguʼtë bönachi nacuáʼ Jerusalén. ");
INSERT INTO zarNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Níʼirö Herodes naʼ bulidzëʼ yúguʼtë bixúz unná bëʼ, len bönniʼ yudoʼ tuʼsédinëʼ, ateʼ gunábinëʼ légaquiëʼ gazxi ral-laʼ galjëʼ Cristo, bönniʼ naʼ tunëʼ löza bönniʼ judío iláʼ lahuëʼ para inná béʼenëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tëʼ lëʼ: —Lu yödzö Belén luyú Judea. Caní naca tuʼ buzúajëʼ tu bönniʼ bëʼë didzaʼ uláz queëʼ Dios le rnna caní: ");
INSERT INTO zarNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Bitiʼ nácarö cáʼasö yödzö Belén luyú Judá lahuëʼ Dios ca nácagaca yödzö gapa nacuáʼ nupa taʼnná bëʼ luyú ni, tuʼ irúajëʼ tu bönniʼ yödzö Belén, en gáquiëʼ lo, bönniʼ naʼ gun chiʼë bönachi Israel quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Níʼirö Herodes bulidzëʼ bagáchiʼsö bönniʼ taʼyéajniʼinëʼ naʼ, en gunábinëʼ légaquiëʼ para inö́zinëʼ dxiʼa gácaʼxte chiguca buluíʼi lahui bölaj naʼ bilaʼléʼenëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Níʼirö gusö́l-lëʼë légaquiëʼ tsöjáquiëʼ Belén. Rëʼ légaquiëʼ: —Guliʼtséaj niʼ, en guliʼtsöjnaba dxiʼa nacxi naca queë́biʼ bíʼidoʼ naʼ. Cateʼ chibidzö́liliʼ-biʼ, ididíxjöiʼiliʼ nedaʼ, para tsejaʼ caʼ nedaʼ, tseaj ládxaʼa-biʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Gudödi bilaʼyönnëʼ didzaʼ bëʼë Herodes naʼ, söjáquiëʼ bönniʼ taʼyéajniʼinëʼ naʼ, ateʼ bölaj naʼ bilaʼléʼenëʼ cateʼ niʼ nacuʼë ládzagaquiëʼ söjnö́rubaʼ lógaquiëʼ ga bidxintë yöjsóa ga naʼ dëbiʼ bíʼidoʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Cateʼ bilaʼléʼenëʼ bölaj naʼ, buluʼdzéjadeʼenëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Cateʼ gulaʼyáziëʼ yuʼu, bilaʼléʼenëʼ-biʼ biʼi bö́nniʼdoʼ naʼ, zóalenbiʼ-nu María, xináʼabiʼ. Buluʼzóa zxíbigaquiëʼ lobiʼ, en gulaʼyéaj ládxiʼgaquiëʼ-biʼ. Gudödi naʼ gulaʼsaljëʼ yuguʼ yöxaj quégaquiëʼ, ateʼ buluʼnödzjëʼ queë́biʼ oro, en yalaj, en nö́ridoʼ riláʼ zxixi que yaga mirra. ");
INSERT INTO zarNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tuʼ chibuzéajniʼinëʼ Dios légaquiëʼ lu yëla bë́chigal para cabí tsöjhuö́jquiëʼ ga zoëʼ Herodes naʼ, que lë ni naʼ yöjhuö́jquiëʼ ládzagaquiëʼ nöza yúbölö. ");
INSERT INTO zarNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Gudödi buluʼzë́ʼë yuguʼ bönniʼ taʼyéajniʼinëʼ niʼ, buluíʼi lahuëʼ tuëʼ gubáz láʼayi queëʼ Xanruʼ lu yëla bë́chigal, ga naʼ dëʼ José, en rëʼ lëʼ: —Guyaschi. Guchë́ʼ-biʼ bíʼidoʼ ni, encaʼ xináʼabiʼ, ateʼ buzxunnaj ni. Guyéaj luyú Egipto, ateʼ ugáʼanuʼ niʼ cateʼ guië́raʼ liʼ iaʼtú. Caní gunuʼ tuʼ uguiljëʼ Herodes bíʼidoʼ ni para gútiëʼ-biʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Níʼirö guyasëʼ José, en niʼ naca chiʼi dzö́ʼölö, guchë́ʼë-biʼ bíʼidoʼ naʼ, encaʼ xináʼabiʼ, ateʼ yöjáquiëʼ luyú Egipto. ");
INSERT INTO zarNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Buluʼgáʼanëʼ niʼ cateʼ gútirëʼ Herodes. Caní guca para gaca lë naʼ gunnë́ʼ Xanruʼ Dios lu ruʼë tu bönniʼ bëʼë didzaʼ uláz queëʼ, gunnë́ʼ: “Ga naca luyú Egipto bulidzaʼ Zxíʼinaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Cateʼ gúquibeʼenëʼ Herodes bitiʼ gulunëʼ bönniʼ taʼyéajniʼinëʼ ca rnnëʼ, gulénëʼ, ateʼ gunná béʼenëʼ bönniʼ tsöjáquiëʼ niʼ para ilútiëʼ-biʼ yúguʼtëbiʼ biʼi bö́nniʼdoʼ nacuáʼabiʼ yödzö Belén, en idú gásibiʼilö ga dë Belén naʼ, yuguʼ bíʼidoʼ chiyúʼugacabiʼ chopa iz, en bíʼidoʼ nahuë́ʼënigacaröbiʼ. Caní benëʼ ca busáquiëʼ queëʼ Herodes naʼ, tsca chiguca dza buluíʼi lahui bölaj naʼ, dza naʼ buluʼzéajniʼinëʼ bönniʼ taʼyéajniʼinëʼ naʼ lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Caní guca, bidxín lë naʼ gunnë́ʼ Jeremías, bönniʼ bëʼë didzaʼ uláz queëʼ Dios, gunnë́ʼ: ");
INSERT INTO zarNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Lu yödzö Ramá riyö́n chíʼigaca nupa taʼbödxi, en nupa taʼbödxi yechiʼ. Raquel ribö́dxinu niʼa quégacabiʼ zxíʼininu. Bitiʼ gaca nu huë tsahuiʼ lënu, tuʼ chinátigacabiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Gudödi gútiëʼ Herodes naʼ, níʼirö buluíʼi lahuëʼ gubáz láʼayi naʼ queëʼ Xanruʼ lu yëla bë́chigal lahuëʼ José ga niʼ zoëʼ luyú Egipto, ateʼ rëʼ lëʼ: ");
INSERT INTO zarNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Guyasa. Guchë́ʼ-biʼ biʼi bö́nniʼdoʼ ni, encaʼ xináʼabiʼ, ateʼ böaj luyú Israel, tuʼ chigulátiëʼ bönniʼ niʼ gulë́ʼënnëʼ ilútiëʼ-biʼ biʼi bö́nniʼdoʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Níʼirö guyasëʼ José, ateʼ guchë́ʼë-biʼ biʼi bö́nniʼdoʼ naʼ, encaʼ xináʼabiʼ, ateʼ yöhuö́jquiëʼ luyú Israel. ");
INSERT INTO zarNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Cateʼ gúquibeʼenëʼ José rinná bëʼë Arquelao luyú Judea tuʼ chigútiëʼ Herodes, xuzëʼ Arquelao naʼ, que lë ni naʼ gúdxinëʼ José huöjëʼ niʼ. Cateʼ buzéajniʼinëʼ Dios lëʼ lu yëla bë́chigal, guyijëʼ luyú Galilea. ");
INSERT INTO zarNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Cateʼ bidxinëʼ niʼ, yöjsóëʼ lu yödzö Nazaret. Caní guca para gaca lë naʼ gulaʼnnë́ʼ yuguʼ bönniʼ guluʼë didzaʼ uláz queëʼ Dios ca ral-laʼ gaca queëʼ Jesús, siʼ Lëʼ, Bönniʼ Nazaret. ");
INSERT INTO zarNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yuguʼ lu dza niʼ buluíʼi lahuëʼ Juan, bönniʼ naʼ buquilëʼ bönachi nisa, en runëʼ libán lu lataj cáʼasö luyú Judea. ");
INSERT INTO zarNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Juan naʼ rnnëʼ: —Buliʼbíʼi ládxiʼliʼ, tuʼ chizóa idxín dza idinná bëʼ Nu naʼ zoa yehuaʼ yubá luyú ni. ");
INSERT INTO zarNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ca naca queëʼ Juan naʼ, buzúajëʼ Isaías, bönniʼ bëʼë didzaʼ uláz queëʼ Dios dza niʼtë, le rnna caní: Riyö́n chiʼë bönniʼ rulidzëʼ lu lataj cáʼasö, rnnëʼ: “Buliʼpáʼa nöza para idxín Xanruʼ ga zóaliʼ. Guliʼbéaj li yuguʼ nöza lasi tödëʼ lu icja ládxidoʼoliʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nácuëʼ zxëʼ Juan lariʼ néquini lítsaʼbaʼ böaʼ, ateʼ núguëʼë lëʼë le néquini guídi. Rahuëʼ-baʼ bö́chiʼzu, en reʼjëʼ bidxindoʼ que buzdoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yuguʼ bönniʼ yödz Jerusalén len bönachi narúajgaca idú luyú Judea, en idú gásibiʼilö ga dë yegu Jordán bilaʼdxinëʼ ga zoëʼ Juan naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Cateʼ gulaʼxóalëpëʼ dul-laʼ nabágaʼgaquiëʼ, Juan naʼ buquilëʼ légaquiëʼ nisa lu yegu Jordán naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Cateʼ biléʼenëʼ Juan taʼdxinëʼ zián bönniʼ yudoʼ fariseo len yuguʼ bönniʼ yudoʼ saduceo ga zoëʼ para ilaʼdilëʼ nisa, gudxëʼ légaquiëʼ: —Libiʼiliʼ, diʼa dza quégacabaʼ bëla síniaʼ. ¿Zoa nu buzéajniʼi libíʼiliʼ para izxúnnajliʼ yöl-laʼ rusiúdxi naʼ siʼ gaca quégaca bönachi? ");
INSERT INTO zarNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Guliʼgún le gaca bëʼ chibubíʼi ládxiʼliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Bitiʼ cuéqui ícjaliʼ, bitiʼ innaliʼ nácaliʼ tsahuiʼ tuʼ naca Abraham xuz gudödi queë́liʼ. Reaʼ libíʼiliʼ, huáca gunëʼ Dios ga uluʼhuöáca yuguʼ guiö́j nacuáʼ ni diʼa dza queëʼ Abraham. ");
INSERT INTO zarNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Chizóa riböza guíë huága para ichugu yuguʼ yaga le ruluíʼi ca gaca queë́liʼ. Yúguʼtë yaga bitiʼ taʼbía le naca dxiʼa, irúgugaca, ateʼ ilaʼguʼë léguequi lu guíʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Le nácatë nedaʼ ruquilaʼ libíʼiliʼ nisa lu nisa, núlöliʼ chibubíʼi ládxiʼliʼ, pero Bönniʼ naʼ ral-laʼ guídëʼ cateʼ tödi quiaʼ nedaʼ, Lëʼ gunëʼ le ruluíʼisö yöl-laʼ ridila nisa ni, uchíziëʼ libíʼiliʼ Dios Böʼ Láʼayi len guíʼ queëʼ. Bönniʼ ni nácatërëʼ lo ca nedaʼ, ateʼ nedaʼ bitiʼ nacaʼ lesacaʼ ilecjaʼ xiráchuëʼ nudë́ʼë. ");
INSERT INTO zarNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Zönëʼ lu nëʼë böcö́ʼ queëʼ, le ulúbinëʼ ga ridxiʼa zxoaʼ xtila queëʼ. Cuʼë zxoaʼ xtila queëʼ lu yuʼu ga niʼ gun chiʼë le, pero uzéguiʼë bëbu que lu guíʼ, ateʼ guíʼ naʼ bitiʼ caʼ ulu. ");
INSERT INTO zarNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Níʼirö buzë́ʼë Jesús luyú Galilea, ateʼ bidxinëʼ raʼ yegu Jordán ga naʼ zoëʼ Juan, para idilëʼ nisa lu nëʼë Juan naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juan buzáguëʼë xinözëʼ, en rëʼ Jesús: —Nedaʼ ral-laʼ idilaʼ nisa lu noʼo Liʼ. ¿Zaʼtsoʼ Liʼ quiaʼ nedaʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Bubiʼë didzaʼ Jesús, rëʼ lëʼ: —Benna lataj naʼa, tuʼ caní ral-laʼ gunruʼ idútë le naca tsahuiʼ. Níʼirö Juan bëʼë Lëʼ lataj. ");
INSERT INTO zarNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Cateʼ chinadilëʼ Jesús nisa, laʼ burúajtëʼ lu nisa. Níʼirö guyalaj lúzxiba lahuëʼ Jesús, ateʼ biléʼenëʼ ruhuötjëʼ Dios Böʼ Láʼayi, en bidxinëʼ ga naʼ zoëʼ, rinë́ʼë ca rináʼabaʼ guʼdödoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Níʼirö biyö́n chiʼi nu ruíʼi didzaʼ yehuaʼ yubá, rnna: —Bönniʼ ni náquiëʼ Zxíʼinaʼ. Nadxíʼidaʼ Lëʼ, en raza ládxaʼa Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Níʼirö laʼ guchëʼtëʼ Dios Böʼ Láʼayi Jesús lu lataj cáʼasö para gataʼ lataj siʼ bëʼ Satanás tuʼ xihuiʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Idú choáʼ dza choáʼ yëla bitiʼ bi gudahuëʼ Jesús, ateʼ gudödi niʼ ridunëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Níʼirö tuʼ xihuiʼ, nu naʼ run ga táʼbagaʼ bönachi dul-laʼ, bidxín ga zoëʼ Jesús, en rë Lëʼ: —Channö nacuʼ idú Zxíʼinëʼ Dios, gunná naʼa uluʼhuöáca guiö́j nacuáʼ ni yöta xtila. ");
INSERT INTO zarNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Bubiʼë didzaʼ Jesús, rëʼ le: —Nazúaj lu guichi láʼayi le rnna: “Calë́gasö yöta xtila nabánigaca bönachi, pero lëscaʼ yúguʼtë didzaʼ ruʼë Dios nabánigaca bönachi.” ");
INSERT INTO zarNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Níʼirö tuʼ xihuiʼ guchë́ʼ Jesús lu yödzö láʼayi Jerusalén, ateʼ budxía Lëʼ ga naca xitsáʼ ícjoʼolö yudoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Níʼirö tuʼ xihuiʼ rë Lëʼ, rnna: —Channö nacuʼ Liʼ idú Zxíʼinëʼ Dios, busuladzuʼ cuinuʼ ni, tuʼ nazúaj lu guichi láʼayi le rnna: Dios isö́l-lëʼë gubáz láʼayi queëʼ para ilún chiʼë Liʼ, ateʼ uluʼchisëʼ Liʼ lu náʼagaquiëʼ, para cabí tsöjchéguʼu guiö́j, en cabí gunuʼ ziʼ niʼu. ");
INSERT INTO zarNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Bubiʼë didzaʼ Jesús, rëʼ le: —Iaʼstú nazúaj lu guichi láʼayi, le rë bönachi, rnna: “Bitiʼ ugunuʼ dxin Xanuʼ Dios.” ");
INSERT INTO zarNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Níʼirö tuʼ xihuiʼ guchë́ʼ Jesús ga naca tu lu guíʼa sibi, ateʼ niʼ buluíʼi Lëʼ yúguʼtë yödzö nacuáʼ yödzölió ni, en yúguʼtë yöl-laʼ tsahuiʼ quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Níʼirö rë Lëʼ: —Yúguʼtë lë ni udödaʼ lu noʼo channö uzóa zxibuʼ lahuaʼ, en gunuʼ nedaʼ zxön. ");
INSERT INTO zarNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesús rëʼ le: —Böaj quiuʼ liʼ, Satanás tuʼ xihuiʼ, tuʼ nazúaj lu guichi láʼayi le rë netuʼ, rnna: “Xanuʼ Dios tseaj ládxuʼu, en udödi cuinuʼ lu naʼ tuzëʼ Lëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Níʼirö buzáʼ Satanás tuʼ xihuiʼ ga naʼ zoëʼ Jesús, ateʼ gubáz láʼayi queëʼ Dios bilaʼdxinëʼ ga zoëʼ, en gulácalenëʼ Lëʼ, en gulaʼguʼë le gudahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Cateʼ biyönnëʼ Jesús nadzunëʼ Juan lidxi guíë, guyijëʼ luyú Galilea. ");
INSERT INTO zarNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Buzë́ʼë yödzö Nazaret, ateʼ yöjsóëʼ lu yödzö Capernaum ga naca raʼ nísadoʼ, lu buzáʼ quégaca bönachi Zabulón, en bönachi Neftalí. ");
INSERT INTO zarNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Caní guca, bidxín lë naʼ gunnë́ʼ Isaías, bönniʼ bëʼë didzaʼ uláz queëʼ Dios, gunnë́ʼ: ");
INSERT INTO zarNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Luyú Zabulón, en luyú Neftalí, laʼ nöza raʼ nísadoʼ iaʼtsöláʼa yegu Jordán sacaʼ ga rilén gubidza. Luyú Galilea, ga nacuáʼ bönachi bitiʼ nácagaca judío. ");
INSERT INTO zarNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bönachi chul-la niti niʼ bilaʼléʼe beníʼ, ateʼ bönniʼ niʼ nácagaquiëʼ ca nupa chinátigaca, gulén quégaquiëʼ beníʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Cateʼ níʼirö gusí lahuëʼ Jesús runëʼ libán, en rëʼ bönachi niʼ: —Buliʼbíʼi ládxiʼliʼ, tuʼ chizóa idxín dza idinná bëʼ Nu naʼ zoa yehuaʼ yubá luyú ni. ");
INSERT INTO zarNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Cateʼ gudë́ʼ Jesús raʼ nísadoʼ que Galilea, biléʼenëʼ chopëʼ bönniʼ. Tuëʼ lëʼ Simón, en zoa iaʼtú lëʼ Pedro, ateʼ dzáguiëʼ Andrés, bönniʼ bö́chëʼë, lëʼ. Chopëʼ ni taʼchiljëʼ yöxaj böla quégaquiëʼ lu nísadoʼ naʼ tuʼ nácagaquiëʼ uzxö́n böla. ");
INSERT INTO zarNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús rëʼ légaquiëʼ: —Guliʼdutáʼ nedaʼ, ateʼ gunaʼ ga ichë́ʼëliʼ bönachi quiaʼ, gunliʼ ca runliʼ rizönliʼ-baʼ böla. ");
INSERT INTO zarNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Chopëʼ ni laʼ buluʼcáʼanatëʼ yuguʼ yöxaj böla quégaquiëʼ, ateʼ söjácalenëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Cateʼ gudödëʼ Jesús iaʼlatiʼ níʼilö, biléʼenëʼ iaʼchopëʼ bönniʼ. Tuëʼ lëʼ Jacobo, ateʼ dzáguiëʼ Juan, bönniʼ bö́chëʼë lëʼ. Nácagaquiëʼ zxíʼinëʼ Zebedeo. Nacuʼë lëʼe bárcodoʼ dzágagaquiëʼ Zebedeo, xúzgaquiëʼ, en tuʼúnëʼ yöxaj böla quégaquiëʼ. Níʼirö Jesús bulidzëʼ chopëʼ ni para tsöjtáʼgaquiëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Laʼ buluʼcáʼanatëʼ bárcodoʼ naʼ, encaʼ xúzgaquiëʼ, ateʼ söjácalenëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Gudë́ʼ Jesús idú luyú Galilea, rusédinëʼ bönachi gapa naca lu yuʼu ga tuʼdubëʼ bönniʼ judío, en tuʼsëdëʼ queëʼ Dios. Benëʼ libán niʼ que didzaʼ dxiʼa ca siʼ idinná bëʼë Dios luyú niʼ, en bunëʼ yúguʼtë nupa teʼe tsca naca yödzöhuë́ʼ téʼeguequi. ");
INSERT INTO zarNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Guzë́ didzaʼ que yöl-laʼ huáca queëʼ Jesús, ateʼ bilaʼyöni bönachi idú luyú Siria, ateʼ dujuáʼgaquiëʼ yúguʼtë bönniʼ téʼenëʼ zián yödzöhuë́ʼ que queë́gaquiëʼ, en taʼguíʼi taʼzaquiëʼ, ga zoëʼ Jesús. Dujuáʼgaquiëʼ caʼ yuguʼ bönniʼ yúʼugaquiëʼ böʼ xihuiʼ, en yuguʼ bönniʼ téʼenëʼ huëʼ xjoteʼ, en yuguʼ bönniʼ nacúʼunigaquiëʼ bin niʼa náʼagaquiëʼ, ateʼ Jesús bunëʼ yúguʼtë bönniʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bönachi zián bilaʼrúajgaca luyú Galilea, en yuguʼ yödzö Decápolis, en yödzö Jerusalén, encaʼ luyú Judea, en yuguʼ yödzö nacuáʼ iaʼtsöláʼalö yegu Jordán sacaʼ ga rilén gubidza, ateʼ röjácalen Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Cateʼ biléʼenëʼ Jesús bönachi zián söjácalen Lëʼ, níʼirö gurenëʼ tu lu guíʼadoʼ ga naca xitsáʼalö, ateʼ guröʼë lu guíʼa niʼ. Níʼirö buluʼdubëʼ bönniʼ usëda queëʼ ga zoëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Gusí lahuëʼ rusédinëʼ légaquiëʼ, rnnëʼ: ");
INSERT INTO zarNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Bicaʼ ba yuguʼ bönniʼ téquibeʼenëʼ taʼyádzjanëʼ le naca queëʼ Dios, tuʼ nadéliʼgaquiëʼ lataj ga rinná bëʼë Bönniʼ naʼ zoëʼ yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Bicaʼ ba yuguʼ bönniʼ tuʼhuíʼini ládxiʼgaquiëʼ tuʼ nabágaʼgaquiëʼ dul-laʼ, tuʼ huë tsahuëʼë Dios caz légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Bicaʼ ba yuguʼ bönniʼ nácagaquiëʼ nöxaj ladxiʼ lahuëʼ Dios, tuʼ gataʼ quégaquiëʼ luyú ni. ");
INSERT INTO zarNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Bicaʼ ba yuguʼ bönniʼ taʼzë́ ládxiʼgaquiëʼ le naca tsahuiʼ lahuëʼ Dios, ateʼ raca quégaquiëʼ ca raca quégaca nupa taʼdún, en taʼbidxi nisa, tuʼ gunëʼ Dios ga uluʼziʼë xibé lë naʼ taʼzë́ ládxiʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Bicaʼ ba yuguʼ bönniʼ tuʼhuechiʼ ládxiʼgaquiëʼ luzáʼagaquiëʼ, tuʼ huéchiʼ ládxëʼë Dios légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Bicaʼ ba yuguʼ bönniʼ naca tsahuiʼ icja ládxiʼdoʼgaquiëʼ, en bitiʼ bi dul-laʼ nabágaʼgaquiëʼ, tuʼ ilaʼléʼenëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Bicaʼ ba yuguʼ bönniʼ taʼbequi dxíëʼ didzaʼ bizxaj, tuʼ ilaʼzíʼ lágaquiëʼ zxíʼini cazëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Bicaʼ ba yuguʼ bönniʼ taʼzacaʼ taʼguiʼë lu le taʼbía ládxiʼgaca bönachi légaquiëʼ cateʼ tunëʼ le naca tsahuiʼ, tuʼ dë lataj quégaquiëʼ ga rinná bëʼë Bönniʼ naʼ zoëʼ yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Bicaʼ ba libíʼiliʼ cateʼ tuʼlidza bönachi libíʼiliʼ ziʼ, en taʼbía ládxiʼgaquiëʼ libíʼiliʼ, ateʼ lu yöl-laʼ rizíʼ yëʼ taʼnnë́ʼ queë́liʼ le xihuiʼ tuʼ dáʼaliʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Buliʼdzeja, en guliʼchaza ládxiʼliʼ, tuʼ uzíʼdaʼaliʼ xibé yehuaʼ yubá. Ca raca queë́liʼ, guca quégaquiëʼ bönniʼ guluʼë didzaʼ uláz queëʼ Dios, en gulaʼcuʼë zíʼatëlö ca libíʼiliʼ, tuʼ gulaʼbía ládxiʼgaca caʼ bönachi légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Gunnë́ʼ caʼ Jesús: —Libiʼiliʼ nácaliʼ ca zödiʼ luyú ni, pero channö initi zödiʼ naʼ yöl-laʼ sináʼa que, bitiʼ gaca gunruʼ ga huöáca sináʼa. Bítiʼrö naca lesacaʼ, pero chinaca tu le chúʼunaruʼ, ateʼ uluʼlibi bönachi le. ");
INSERT INTO zarNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Libíʼiliʼ nácaliʼ ca beníʼ yödzölió ni para uluíʼiliʼ lahui le naca queëʼ Dios. Ral-laʼ gácaliʼ ca tu yödzö röʼö tu lu guíʼa, tuʼ cabí gaca igachiʼ yödzö naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Cateʼ ruquélaʼruʼ guíʼ, bitiʼ rigúʼuruʼ le tu zxan guíʼina, pero ruzóaruʼ le ga lináʼ para uzeníʼ yúguʼtë nupa nacuáʼ lu yuʼu. ");
INSERT INTO zarNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ca naʼ run beníʼ, ral-laʼ gunliʼ caʼ libíʼiliʼ, güíʼiliʼ lataj gaca bëʼ le nácaliʼ lógaca yúguʼtë bönachi, para cateʼ ilaʼléʼe le naca tsahuiʼ runliʼ, ilaʼgúʼu-nëʼ Xúziliʼ Dios zoëʼ yehuaʼ yubá yöl-laʼ ba. ");
INSERT INTO zarNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Gunnë́ʼ caʼ Jesús: —Bitiʼ guéquiliʼ bidaʼ para usunítiaʼ yuguʼ le gunná bëʼë Moisés, o xibá naʼ buluʼsédinëʼ bönniʼ guluʼë didzaʼ uláz queëʼ Dios. Bidaʼ, calëga para usunítiaʼ yuguʼ lë naʼ, pero para uluʼa lahui idútë le tuʼsedi lë naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Le nácatë reaʼ libíʼiliʼ. Tsanni nacuáʼ lúzxiba, en yödzölió ni, bitiʼ tödi cáʼasö nitú dídzaʼdoʼ, en nitú le rinná bëʼ xibá naʼ, cateʼ gácarö yúguʼtë le ral-laʼ gaca. ");
INSERT INTO zarNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Que lë ni naʼ, nútiʼtës bönniʼ quitsjëʼ tu xibá cuídiʼdoʼos le zoa lu xibá naʼ, en usédinëʼ bönachi para ilún caní, bönniʼ ni gácatërëʼ cuídiʼdoʼos ca yúguʼtë nupa ilaʼcuáʼ ga rinná bëʼ Bönniʼ naʼ zoëʼ yehuaʼ yubá, pero nútiʼtës bönniʼ gunëʼ ca rinná bëʼ xibá naʼ, en usédinëʼ bönachi para ilún caʼ caní, bönniʼ ni tsë́pisëtërëʼ ga rinná bëʼ Nu naʼ zoa yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Reaʼ caʼ libíʼiliʼ: Channö cabí gunliʼ le nácatërö tsahuiʼ ca le tunëʼ bönniʼ yudoʼ usedi, encaʼ ca tunëʼ bönniʼ yudoʼ fariseo, bitiʼ caʼ tsúʼuliʼ ga rinná bëʼë Dios yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Gunnë́ʼ caʼ Jesús: —Chibiyö́niliʼ ca gulaʼnnë́ʼ bönniʼ gutaʼ lu náʼagaquiëʼ le gulë́ʼ xuz xtóʼoliʼ: “Bitiʼ gútiliʼ bönachi. Nu bönniʼ gútiëʼ bönachi, nabáguëʼë xíguiaʼ, ateʼ huadxinëʼ ga uchiʼa usörö́ëʼ Dios lëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Naʼa, nedaʼ reaʼ libíʼiliʼ: Nu bönniʼ rilenëʼ böchiʼ luzë́ʼë, nabáguëʼë xíguiaʼ huadxinëʼ ga uchiʼa usörö́ëʼ Dios lëʼ. Lëscaʼ caní, nu bönniʼ innë́ ziʼë queëʼ böchiʼ luzë́ʼë nabáguëʼë xíguiaʼ uluʼchiʼa uluʼsörö́ëʼ bönniʼ lo tuʼchiʼa tuʼsörö́ëʼ lëʼ, ateʼ nu bönniʼ guíëʼ luzë́ʼë: “¡Böaʼ canö́z!” nabáguëʼë xíguiaʼ tsöjtsuʼë lu guíʼ gabila. ");
INSERT INTO zarNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Caní naca, channö chizóa cuʼu tu le unödzjuʼ lu bucugu láʼayi, ateʼ tsöjnenuʼ niʼ zoa bizx que rilenëʼ böchiʼ luzóʼo liʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","bucáʼana lë naʼ unödzjuʼ lu bucugu niʼ, en böaj lidxuʼ. Zíʼalö yöjcáʼana tsahuiʼ le benuʼ queëʼ böchiʼ luzóʼo, ateʼ níʼirö gudá unödzjuʼ lë naʼ nuʼu. ");
INSERT INTO zarNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Channö zoa nu bönniʼ rinábinëʼ liʼ bi ubiʼu queëʼ, en ichë́ʼë liʼ ga uchiʼa usörö́ëʼ tu bönniʼ liʼ, budzágatë tsahuiʼ bönniʼ naʼ tsanni niʼ yúʼulenuʼ lëʼ nöza, para cabí udödëʼ liʼ lahuëʼ bönniʼ ruchiʼa rusörö́ëʼ, ateʼ bönniʼ ni udödëʼ liʼ lu nëʼë bönniʼ rusayjëʼ lidxi guíë, ateʼ lëʼ cuʼë liʼ lidxi guíë naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Le nácatë reaʼ liʼ, bitiʼ caʼ urujuʼ niʼ cateʼ idxinrö dza quizxjuʼ ga buitë le ral-luʼu. ");
INSERT INTO zarNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Gunnë́ʼ caʼ Jesús: —Chibiyö́niliʼ ca naʼ gulaʼnnë́ʼ: “Bitiʼ gunuʼ dul-laʼ le riguitsaj xibá que yöl-laʼ nutsaga naʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Naʼa, nedaʼ reaʼ libíʼiliʼ: Nútiʼtës bönniʼ ruyúëʼ tu nigula len yöl-laʼ rizë́ ladxiʼ le ruáʼ döʼ, chibenëʼ dul-laʼ len lënu lu icja ládxiʼdaʼahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Que lë ni naʼ, channö guiö́j loʼ ibëla gun ga gunuʼ dul-laʼ, guléaj le, en gurúʼuna le. Gácarö dxiʼa quiuʼ unítiuʼ tu guiö́j loʼ, en calëga idúteoʼ tsöjtsúʼu lu guíʼ gabila. ");
INSERT INTO zarNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Channö noʼo ibëla gun ga gunuʼ dul-laʼ, guchugu le, en gurúʼuna le. Gácarö dxiʼa quiuʼ unítiuʼ tu noʼo, en calëga idúteoʼ tsöjtsúʼu lu guíʼ gabila. ");
INSERT INTO zarNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Gunnë́ʼ caʼ Jesús: —Lëscaʼ gulaʼnnë́ʼ: “Nútiʼtës bönniʼ rusanëʼ-nu nigula queëʼ, ral-laʼ unödzjëʼ queë́nu tu guichi le rnna ruláʼalenëʼ-nu.” ");
INSERT INTO zarNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Naʼa, nedaʼ reaʼ libíʼiliʼ, channö zoëʼ nu bönniʼ rusanëʼ-nu nigula queëʼ, en bitiʼ zoa le ruáʼ döʼ runnu, gunëʼ bönniʼ naʼ ga gunnu dul-laʼ le riguitsaj xibá que yöl-laʼ nutsaga naʼ channö utsaga náʼlennu bönniʼ yúbölö, ateʼ bönniʼ naʼ siʼë-nu nigula naʼ, lëscaʼ gunëʼ dul-laʼ le riguitsaj xibá que yöl-laʼ nutsaga naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Gunnë́ʼ caʼ Jesús: —Lëscaʼ biyö́niliʼ ca yuguʼ bönniʼ gutaʼ lu náʼagaquiëʼ gulë́ʼ xuz xtóʼoliʼ, gulaʼnnë́ʼ: “Bitiʼ siʼ yëʼu cateʼ run tsutsu xtídzuʼu niʼa queëʼ Dios, en ral-laʼ gunuʼ lahuëʼ Xanruʼ Dios idútë lë naʼ run tsutsu xtídzuʼu niʼa queëʼ Lëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Naʼa, nedaʼ reaʼ libíʼiliʼ, bitiʼ caʼ gun tsutsu xtídzaʼliʼ. Bitiʼ gun tsutsu xtídzaʼliʼ niʼa que yehuaʼ yubá, tuʼ naca ga röʼë rinná bëʼë Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Bitiʼ gun tsutsu xtídzaʼliʼ niʼa que luyú ni, tuʼ naca luyú ni ca xilibi niʼë Dios, en calëga niʼa que Jerusalén, tuʼ naca ladzëʼ Bönniʼ nayë́pisëtërëʼ rinná bëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Bitiʼ gun tsutsu xtídzuʼu niʼa que icjuʼ, tuʼ cabí gaca gunuʼ ga huöáca chiguichi o gasaj nitú guitsaʼ icjuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ral-laʼ innásiliʼ: “Ön”, o innásiliʼ: “Bitiʼ”, tuʼ naca que tuʼ xihuiʼ le nadödi bëʼ ca nácagaca didzaʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Gunnë́ʼ caʼ Jesús: —Chibiyö́niliʼ ca naca le gunná bëʼë Moisés, gunnë́ʼ: “Nu bi run que guiö́j lahui luzë́ʼe, ubíʼi caʼ que, encaʼ nu bi run que layiʼ luzë́ʼe, ubíʼi caʼ que.” ");
INSERT INTO zarNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Naʼa, nedaʼ reaʼ libíʼiliʼ: Bitiʼ táʼbagaʼliʼ nu guáʼ döʼ queë́liʼ, ateʼ channö nu capaʼ xaguʼ ibëla, bëʼ lataj capaʼ caʼ iaʼtú xaguʼ yö́göla. ");
INSERT INTO zarNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Channö zoa nu gun ga uchiʼa usörö́ëʼ tu bönniʼ liʼ, en cuëʼ zxoʼ, bëʼ caʼ queëʼ lariʼ rixóa cúdzuʼu. ");
INSERT INTO zarNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Channö zoa nu gun bayudxi guʼu yuaʼ que tu chiʼi, guyéajlen nu naʼ chopa chiʼi. ");
INSERT INTO zarNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nu bi rinábini liʼ, bunödzaj que, en nu bi guë́ʼëni gunnuʼ que tu chiʼi, bitiʼ táʼbaguʼu lë naʼ inabi liʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Gunnë́ʼ caʼ Jesús: —Lëscaʼ caní biyö́niliʼ lë naʼ gulaʼnnë́ʼ: “Ral-laʼ idxíʼinuʼ nu nadxíʼi liʼ, en udíʼinuʼ nu bitiʼ riléʼe liʼ dxiʼa.” ");
INSERT INTO zarNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Naʼa, nedaʼ reaʼ libíʼiliʼ, guliʼdxíʼi nupa bitiʼ taʼléʼe libíʼiliʼ dxiʼa. Guliʼnábinëʼ Dios gácalenëʼ nupa tuʼlidza libíʼiliʼ ziʼ. Guliʼgún le naca tsahuiʼ quégaca nupa tuʼdíʼi libíʼiliʼ, en buliʼlidzëʼ Dios inábiliʼ-nëʼ gunëʼ ga gaca dxiʼa quégaca nupa taʼnnë́ queë́liʼ, en tuáʼ döʼ queë́liʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Channö gunliʼ caní, gácaliʼ zxíʼini cazëʼ Xúziruʼ Dios, zoëʼ yehuaʼ yubá, tuʼ runëʼ Lëʼ ga ruzeníʼ gubidza queëʼ ga nacuáʼ bönachi tuáʼ döʼ, encaʼ ga nacuáʼ bönachi tsahuiʼ. Risö́l-lëʼë tu nisa guiö́j lu yu quégaca bönachi tsahuiʼ, encaʼ lu yu quégaca bönachi bitiʼ nácagaca tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Channö nadxíʼisiliʼ bönniʼ nadxíʼiguequinëʼ libíʼiliʼ, ¿nuzxi caz cuʼu libíʼiliʼ yöl-laʼ ba? Lëscaʼ caní tunëʼ bönniʼ bitiʼ nácagaca tsahuiʼ naʼ, bönniʼ tuʼquizxjëʼ uláz que yödzö ziʼtuʼ, nadxíʼiguequinëʼ luzáʼagaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Channö rugápaliʼ Dios tuzëʼ böchiʼ luzáʼaliʼ, ¿bizxi caz runliʼ le nácatërö dxiʼa? Lëscaʼ caní tunëʼ bönniʼ bitiʼ núnbëʼgaquiëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pero libíʼiliʼ, guliʼgaca idú tsahuiʼ, ca naʼ náquiëʼ Xúziruʼ Dios, zoëʼ yehuaʼ yubá, náquiëʼ idú tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Gunnë́ʼ caʼ Jesús: —Guliʼgüíʼ ládxiʼliʼ gaca idú ca reaj ládxiʼliʼ-nëʼ Dios. Bitiʼ gúnsiliʼ lë ni lógaca bönachi para ilaʼléʼe ca naʼ runliʼ. Channö runliʼ caní, bitiʼ bi gunnëʼ Xúziruʼ Dios zoëʼ yehuaʼ yubá queë́liʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Cateʼ bi unödzjuʼ que nu bi riyadzaj, bitiʼ gunuʼ ga iláʼ lahui lë naʼ runuʼ ca tunëʼ bönniʼ tuʼluíʼisö tsahuiʼ cuíngaquiëʼ ga naca lu yuʼu ga tuʼdubëʼ bönniʼ judío, en tuʼsëdëʼ queëʼ Dios, encaʼ ga naca lu yë́ʼëyi. Caní tunëʼ para ilaʼgúʼu bönachi légaquiëʼ yöl-laʼ ba. Le nácatë reaʼ libíʼiliʼ, cáʼasö naca yöl-laʼ ba gataʼ quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pero liʼ, cateʼ bi unödzjuʼ que nu bi riyadzaj, bitiʼ caʼ guʼu lataj nu inözi. ");
INSERT INTO zarNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Naʼa, lë naʼ unödzjuʼ, bagáchiʼsö ral-laʼ unödzjuʼ, ateʼ Xúziruʼ Dios, Nu riléʼe ca naʼ runuʼ bagáchiʼsö, Lëʼ ubiʼë quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Gunnë́ʼ caʼ Jesús: —Cateʼ ulídzaliʼ-nëʼ Dios, bitiʼ gunliʼ ca tunëʼ bönniʼ tuʼluíʼisö tsahuiʼ cuíngaquiëʼ, tuʼ taʼyaza ládxiʼgaquiëʼ taʼzuínëʼ tuʼlidzëʼ Dios gapa naca lu yuʼu ga tuʼdubëʼ tuʼsëdëʼ bönniʼ judío queëʼ Dios, en gapa naca lu yë́ʼëyi para ilaʼléʼe bönachi légaquiëʼ. Le nácatë reaʼ libíʼiliʼ, cáʼasö naca yöl-laʼ ba gataʼ quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero libíʼiliʼ, cateʼ ulídzaliʼ-nëʼ Dios guliʼtsaza lídxiliʼ, en buliʼsayaj yuʼu. Buliʼlidzëʼ Dios inábiliʼ-nëʼ Xúziruʼ Dios, zóalenëʼ libíʼiliʼ ga naʼ zóaliʼ queë́ziliʼ, ateʼ Xúziruʼ Dios, Nu riléʼe ca runliʼ bagáchiʼsö, Lëʼ ubiʼë queë́liʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Cateʼ ulídzaliʼ-nëʼ Dios bitiʼ gunliʼ laʼ yë́ʼëyi laʼ lez ca naʼ tunëʼ bönniʼ bitiʼ núnbëʼgaquiëʼ Dios, tuʼ téquinëʼ huayönnëʼ Dios légaquiëʼ tuʼ tuʼlidzëʼ laʼ yë́ʼëyi laʼ lez. ");
INSERT INTO zarNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bitiʼ gunliʼ ca naʼ tunëʼ légaquiëʼ. Xúziruʼ Dios, zíʼatëlö cateʼ siʼ inábaliʼ-nëʼ, chinö́z quézinëʼ le riyadzaj queë́liʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Que lë ni naʼ, ral-laʼ ulídzaliʼ-nëʼ Dios innaliʼ caní: Xuz netuʼ, zuʼ yehuaʼ yubá, gaca zxön Loʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Gudá inná bëʼu luyú ni. Ben ga gaca luyú ni ca raza ládxuʼu Liʼ ca naʼ raca yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Benna le gágutuʼ naʼa dza. ");
INSERT INTO zarNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Buniti lo netuʼ le huiáʼ döʼ bentuʼ Loʼ Liʼ ca runtuʼ netuʼ, runiti lotuʼ nupa bi tun queë́tuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Bitiʼ guʼu lataj siʼ bëʼ tuʼ xihuiʼ netuʼ, pero busölá netuʼ lu naʼ nu ruáʼ döʼ. Nequi quiuʼ ga rinná bëʼu, en yöl-laʼ unná bëʼ, en yöl-laʼ ba. Caní rë́ʼënituʼ gácaticaʼsö. ¡Caʼ gaca! ");
INSERT INTO zarNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Channö uniti loliʼ luzáʼaliʼ, nupa tuáʼ döʼ queë́liʼ, uniti lahuëʼ Xúziruʼ Dios, zoëʼ yehuaʼ yubá, libíʼiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Channö cabí uniti loliʼ luzáʼaliʼ, bitiʼ uniti lahuëʼ Xúziruʼ Dios libíʼiliʼ ca naca dul-laʼ nabágaʼliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Gunnë́ʼ caʼ Jesús: —Cateʼ gunliʼ gubasa, bitiʼ gunliʼ bayechiʼ loliʼ ca tunëʼ bönniʼ tuʼluíʼisö tsahuiʼ cuíngaquiëʼ, tuʼ tunëʼ bayechiʼ lógaquiëʼ para iléquibeʼe bönachi tunëʼ gubasa. Le nácatë reaʼ libíʼiliʼ, cáʼasö naca yöl-laʼ ba gataʼ quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Libíʼiliʼ, cateʼ gunliʼ gubasa, buliʼpáʼa ícjaliʼ, en guliʼquibi loliʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","para cabí iléquibeʼe bönachi runliʼ gubasa. Bagáchiʼsö ral-laʼ gunliʼ gubasa, ateʼ Xúziruʼ Dios, zóalenëʼ libíʼiliʼ ga naʼ zóaliʼ queë́ziliʼ, Lëʼ ubiʼë queë́liʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Gunnë́ʼ caʼ Jesús: —Bitiʼ utúbiliʼ yöl-laʼ tsahuiʼ luyú ni, ga ni bë́ladoʼ que tuʼtöbaʼ le, ateʼ raca ditaj, en ga ni taʼyaza gubán, taʼbanëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Buliʼtubi yöl-laʼ tsahuiʼ yehuaʼ yubá, ga niʼ bë́ladoʼ que bitiʼ uluʼtöbaʼ le, en bitiʼ gaca ditaj, en ga niʼ bitiʼ ilaʼyáziëʼ bönniʼ gubán, en bitiʼ ilaʼbanëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ga niʼ dë yöl-laʼ tsahuiʼ queë́liʼ, niʼ güíʼi ládxiʼliʼ idxinliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Gunnë́ʼ caʼ Jesús: —Guiöj loruʼ naca ca tu le rigúʼu beníʼ icja ládxiʼdoʼoruʼ. Que lë ni naʼ, channö guiö́j loliʼ naca tsahuiʼ, idútëliʼ tsë́piliʼ yösa beníʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Channö guiö́j loliʼ bitiʼ naca tsahuiʼ, idútëliʼ nachúl-laliʼ. Que lë ni naʼ, channö beníʼ zóalen libíʼiliʼ nuhuöáca le naca chul-la, yénniʼtërö nachúl-laliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Gunnë́ʼ caʼ Jesús: —Cuntu nu bönniʼ gaca gunëʼ xichíngaquiëʼ chopa xanëʼ, tuʼ uzóëʼ tuëʼ tsöláʼalö, ateʼ iaʼtúëʼ naʼ idxíʼinëʼ, o ugáʼanalenëʼ tuëʼ, ateʼ iaʼtúëʼ naʼ usán ládxëʼë. Bitiʼ gaca gunliʼ xichinëʼ Dios, encaʼ dumí. ");
INSERT INTO zarNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Gunnë́ʼ caʼ Jesús: —Iaʼstú reaʼ libíʼiliʼ: Bitiʼ ubi uguíʼiliʼ niʼa que le gáguliʼ o niʼa que le guíʼjaliʼ, yuguʼ le nabániliʼ, o niʼa que lariʼ gáculiʼ. Nazácaʼtërö yöl-laʼ naʼbán queë́liʼ ca le gáguliʼ, ateʼ nácatërö lesacaʼ le nácaliʼ ca lariʼ gáculiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Buliʼyú ca raca quégacabaʼ biguínnidoʼ taʼdabaʼ lúzxiba. Bitiʼ bi taz tuʼzóabaʼ, en bitiʼ tuʼlápabaʼ, en bitiʼ tuʼtúbibaʼ ga bi ilaʼgúʼubaʼ quégacabaʼ, pero Xúziruʼ Dios zoëʼ yehuaʼ yubá, rugagu cazëʼ légacabaʼ. Nazácaʼtëröliʼ libíʼiliʼ ca yuguʼ biguínnidoʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Nuzxi caz bönniʼ nútsëʼë ládjaliʼ gaca gunëʼ ga soëʼ ibanëʼ iaʼtúz dza tuʼ ruúbi ruguíʼinëʼ para gaca caní queëʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Bizx que ruúbi ruguíʼiliʼ niʼa que le gáculiʼ? Buliʼyútsöcaʼ ca raca quégaca yöjdoʼ rö́ʼgaca laʼ guixiʼ ca taʼzxö́n. Bitiʼ tun dxin, en bitiʼ tun du lariʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nedaʼ reaʼ libíʼiliʼ, Salomón, bönniʼ niʼ gunná bëʼë, sal-laʼ gútaʼdaʼ yöl-laʼ tsahuiʼ queëʼ, lariʼ gúcuëʼ bitiʼ gunnáʼtërö lachi ca rinnáʼgaca yöjdoʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Dios caz runëʼ lachi yöj guíxiʼdoʼ, le rö́ʼgaca laʼ guixiʼ, le nacuáʼ naʼa dza, ateʼ cuxö́ huidzaj ilaʼyegui lu guíʼ. Channö caní ruíʼi ládxëʼë yöj guíxiʼdoʼ, runëʼ léguequi lachi, gúndaʼarëʼ caʼ queë́liʼ, sal-laʼ bitiʼ réajlëʼëliʼ-nëʼ idú ládxiʼliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Que lë ni naʼ, bitiʼ ubi uguíʼiliʼ, en bitiʼ innaliʼ: “¿Bizxi gágutsatuʼ?” o “¿Bizxi guíʼjatsatuʼ?” o “¿Bizxi lariʼ gácutsatuʼ?” ");
INSERT INTO zarNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Bönachi yödzölió ni tuʼúbi tuʼguíʼi niʼa que yúguʼtë lë ni, pero zoëʼ Xúziruʼ yehuaʼ yubá, ateʼ Lëʼ nö́zinëʼ naquíniliʼ yúguʼtë lë ni. ");
INSERT INTO zarNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Naʼa, guliʼgüíʼirö ládxiʼliʼ inná béʼenëʼ Dios libíʼiliʼ, en gunliʼ le naca tsahuiʼ lahuëʼ Lëʼ, ateʼ Lëʼ cuʼë xinö́zaliʼ yúguʼtë lë ni. ");
INSERT INTO zarNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Que lë ni naʼ, bitiʼ ubi uguíʼiliʼ niʼa que le ral-laʼ gaca cuxö́ huidzaj, tuʼ huáca güíʼi ládxiʼliʼ cuxö́ huidzaj le gaca queë́liʼ dza naʼ. Tu tu dza ilaca le ral-laʼ güíʼi ládxiʼliʼ dza naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Gunnë́ʼ caʼ Jesús: —Bitiʼ ichugu bë́ʼëliʼ böchiʼ luzáʼaliʼ, para cabí ichugu bëʼë Dios queë́liʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","tuʼ ichugu bëʼë Lëʼ queë́liʼ laʼ leze ca naʼ richugu bë́ʼëliʼ queëʼ böchiʼ luzáʼaliʼ, ateʼ ca naʼ rurixi rudö́diliʼ que luzáʼaliʼ, laʼ cáʼasö urixi udödëʼ Dios queë́liʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Bizx que ruyúʼ bë́budoʼ yuʼu guiö́j lahuëʼ böchiʼ luzóʼo, en bitiʼ réquibeʼenuʼ yuʼu le zxö́ntërö guiö́j loʼ liʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Guíëtsoʼ böchiʼ luzóʼo: “Gulö́z, cuejaʼ bë́budoʼ yuʼu guiö́j loʼ”, ateʼ liʼ, le zxö́ntërö caʼ yuʼu guiö́j loʼ liʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Liʼ, bönniʼ ruluíʼisö tsahuiʼ cuinuʼ. Guléaj zíʼalö le zxön yuʼu guiö́j loʼ liʼ, ateʼ níʼirö iléʼenuʼ tsáhuiʼdoʼ para gaca cuejuʼ bë́budoʼ yuʼu guiö́j lahuëʼ böchiʼ luzóʼo. ");
INSERT INTO zarNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Bitiʼ güíʼiliʼ quégacabaʼ böʼcuʼ le naca láʼayi, para cabí uluʼhuécjabaʼ, en iláguyaʼabaʼ libíʼiliʼ, en bitiʼ chúʼunaliʼ le naca lesacaʼ queë́liʼ láhuigacabaʼ cuchi, para cabí uluʼzadiʼ níʼabaʼ le. ");
INSERT INTO zarNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Gunnë́ʼ caʼ Jesús: —Guliʼnaba, ateʼ Dios gunnëʼ queë́liʼ. Guliʼguilaj, ateʼ gunnëʼ lataj idzöli queë́liʼ. Buliʼlidza raʼ yuʼu, ateʼ Lëʼ isaljëʼ queë́liʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nútiʼtës bönniʼ rinabëʼ, ridéliʼnëʼ, ateʼ bönniʼ riguiljëʼ, ridzöli queëʼ, ateʼ bönniʼ rulidzëʼ raʼ yuʼu, ralaj queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Channö zoëʼ nu bönniʼ ládjaliʼ libíʼiliʼ, ateʼ zóabiʼ biʼi queëʼ, channö inábibiʼ lëʼ yöta xtila, ¿naruʼ unödzjëʼ-biʼ guiö́j? ");
INSERT INTO zarNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Channö inábibiʼ lëʼ tubaʼ böla, ¿naruʼ unödzjëʼ-biʼ bëla? ");
INSERT INTO zarNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Libíʼiliʼ nácaliʼ huiáʼ döʼ, pero nö́ziliʼ unö́dzjaliʼ zxíʼiniliʼ le naca tsahuiʼ. Nácatërö löza, Xúziliʼ zoëʼ yehuaʼ yubá unödzjëʼ nupa taʼnábini Lëʼ le naca dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Que lë ni naʼ, ca naʼ rë́ʼëniliʼ ilún bönachi queë́liʼ, lëscaʼ caní guliʼgún quégaquiëʼ. Lë ni naca le rinná bëʼ xibá queëʼ Moisés, encaʼ le gulaʼnnë́ʼ bönniʼ guluʼë didzaʼ uláz queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Gunnë́ʼ caʼ Jesús: —Guliʼtsáz ga nu riyaza le naca tsúpiʼdoʼ. Blagaʼ naca ga nu riyaza, en yalaj naca nöza le röjácalenëʼ bönniʼ ga niʼ ilaʼnítiëʼ, ateʼ taʼyáziëʼ bönniʼ zián niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tsúpiʼdoʼ naca ga nu riyaza, en lásidoʼos naca nöza le röjácalen bönachi ga niʼ ilaʼdeliʼ yöl-laʼ naʼbán idú, ateʼ nabábasö nupa taʼdzöli le. ");
INSERT INTO zarNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Gunnë́ʼ caʼ Jesús: —Guliʼgún chiʼi cuinliʼ para cabí ilaʼzíʼ yéʼenëʼ bönniʼ taʼzíʼ yëʼë libíʼiliʼ, taʼnnë́ʼ tuʼë didzaʼ uláz queëʼ Dios. Ilaʼdxinëʼ bönniʼ caní ga zóaliʼ, en uluʼluíʼi cuíngaquiëʼ nöxaj ládxiʼdoʼ ca nácagacabaʼ böʼcuʼ zxílaʼdoʼ, pero lu icja ládxiʼdoʼgaquiëʼ nácagaquiëʼ ca böʼcuʼ guíʼa síniaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yuguʼ le tunëʼ ilaca bëʼ le nácagaquiëʼ. Bitiʼ ruchíbiruʼ le ribía lubá uva lu yaga yötsiʼ, en bitiʼ ruchíbiruʼ le ribía yaga higo lu guixiʼ legui lásidoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Caní naca, yúguʼtë yaga dxiʼa taʼbía le naca dxiʼa, ateʼ tu yaga cabí naca dxiʼa ribía le cabí naca dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yaga dxiʼa naʼ bitiʼ gaca cuía le cabí naca dxiʼa, ateʼ yaga naʼ bitiʼ naca dxiʼa bitiʼ gaca cuía le naca dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yúguʼtë yaga bitiʼ taʼbía le naca dxiʼa ilaʼrugu, ateʼ ilaʼguʼë léguequi lu guíʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Caní naca, yuguʼ le tunëʼ bönniʼ naʼ ilaca bëʼ le nácagaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Gunnë́ʼ caʼ Jesús: —Zian nupa të nedaʼ: “Xan, Xan”, pero calëga yúguʼtëʼ ilaʼyáziëʼ ga rinná bëʼë Dios yehuaʼ yubá. Ilaʼyázasëʼ niʼ bönniʼ tunëʼ ca rë́ʼënëʼ Xuzaʼ Dios, zoëʼ yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Cateʼ idxín dza údxi que yödzölió ni, bönniʼ zián ilë́ʼ nedaʼ, ilaʼnnë́ʼ: “Xan, Xan, bentuʼ libán que xtídzëʼë Dios, buguntuʼ dxin Loʼ, en buguntuʼ caʼ dxin Loʼ para bubéajtuʼ yuguʼ böʼ xihuiʼ, en buguntuʼ caʼ dxin Loʼ bentuʼ zián yöl-laʼ huáca zxön.” ");
INSERT INTO zarNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Níʼirö nedaʼ guíaʼ légaquiëʼ: “Bitiʼ caʼ núnbëʼa libíʼiliʼ. Guliʼcuíta ga zoaʼ, libíʼiliʼ ruáʼaliʼ döʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Gunnë́ʼ caʼ Jesús: —Iaʼstú caʼ, nu bönniʼ riyönnëʼ xtídzaʼa ni, en gunëʼ ca rnna, bönniʼ ni náquiëʼ ca tu bönniʼ réajniʼinëʼ, budxíëʼ lidxëʼ ga naca lu guiö́j. ");
INSERT INTO zarNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Cateʼ gulaj guiö́jsiuʼ, en guzxö́n yegu gubóʼo, en guyecja böʼ, gudibi nisa cuita yuʼu naʼ, pero bitiʼ gubixi, tuʼ dxía xilibi lu guiö́j. ");
INSERT INTO zarNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Naʼa, nu bönniʼ riyönnëʼ xtídzaʼa ni, en bitiʼ runëʼ ca rnna, bönniʼ ni náquiëʼ ca tu bönniʼ bitiʼ réajniʼinëʼ, budxíëʼ lidxëʼ lu yu dzöbi. ");
INSERT INTO zarNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Cateʼ gulaj guiö́jsiuʼ, en guzxö́n yegu gubóʼo, en guyecja böʼ, níʼirö gudáʼa nisa cuita yuʼu naʼ, ateʼ gubíxitë, en tsaz biguinnaj. ");
INSERT INTO zarNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Cateʼ Jesús budxi bë́ʼlenëʼ légaquiëʼ didzaʼ ni, buluʼbani bönachi zián nacuáʼ niʼ ca naca le rusédinëʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tuʼ rusédinëʼ légaquiëʼ ca tu bönniʼ dë lu nëʼë, en calëga ca tunëʼ bönniʼ yudoʼ usedi quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Cateʼ bötjëʼ Jesús lu guíʼa naʼ, söjácalen bönachi zián Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Bidxinëʼ tu bönniʼ réʼenëʼ huëʼ nudzuʼ ruzödi ga zoëʼ Jesús, ateʼ buzóa zxibëʼ lahuëʼ Jesús, en rëʼ Lëʼ: —Xan, channö rë́ʼënuʼ, huáca unuʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Níʼirö Jesús laʼ bulitë nëʼë, en gudanëʼ lëʼ. Rëʼ lëʼ: —Rë́ʼëndaʼ. Huöácuʼ dxiʼa. Laʼ bunítitë xihuëʼë bönniʼ huëʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Níʼirö Jesús gudxëʼ lëʼ: —Buyú, cuntu nu guíoʼ caní, pero guyéaj, yöjluíʼi cuinuʼ lahuëʼ bixúz, ateʼ yöjnödzaj le gunná bëʼë Moisés le uluíʼi bönachi chiböácuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Cateʼ guyáziëʼ Jesús yödzö Capernaum, bidxinëʼ tu bönniʼ ga zoëʼ, bönniʼ rinná béʼenëʼ tu gáyuʼë bönniʼ röjáquiëʼ gudil-la, ateʼ gútaʼyuëʼ lahuëʼ Jesús, ");
INSERT INTO zarNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","en rëʼ Lëʼ: —Xan, biʼi huen dxin quiaʼ dëbiʼ yuʼu, réʼebiʼ huëʼ nacúʼunibiʼ bin, ateʼ riguíʼi rizácaʼdaʼabiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús rëʼ lëʼ: —Nedaʼ guídaʼ unaʼ-biʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Bubiʼë didzaʼ bönniʼ naʼ rinná béʼenëʼ bönniʼ röjáquiëʼ gudil-la, en rëʼ Jesús: —Xan, bitiʼ nacaʼ zi tsáziuʼ lidxaʼ, pero tsa innasuʼ quiaʼ, ateʼ huöácabiʼ biʼi huen dxin quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Lëscaʼ nedaʼ, zoa nu rinná beʼe nedaʼ, en nacuʼë caʼ bönniʼ röjáquiëʼ gudil-la rinná béʼegacadaʼ-nëʼ. Cateʼ reaʼ-nëʼ tuëʼ: “Guyéaj niʼ”, rejëʼ. Cateʼ reaʼ-nëʼ iaʼtúëʼ: “Gudá ni”, ridëʼ. Cateʼ reaʼ-nëʼ bönniʼ huen dxin quiaʼ: “Ben dxin ni”, laʼ runtëʼ dxin naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Cateʼ biyönnëʼ Jesús didzaʼ ni, bubáninëʼ, ateʼ gudxëʼ bönniʼ söjácalenëʼ Lëʼ, rnnëʼ: —Le nácatë reaʼ libíʼiliʼ, ga nacuáʼ bönachi Israel, cuntu nu bönniʼ röjxéquiʼdaʼ-nëʼ réajlëʼë nedaʼ ca runëʼ bönniʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Iaʼstú reaʼ libíʼiliʼ: Ilaʼrúaj bönachi zián sacaʼ ga rilén gubidza, en sacaʼ ga ribía gubidza, ateʼ ilaʼböʼlen tsözxö́n Abraham, en Isaac, en Jacob, yehuaʼ yubá niʼ ga rinná bëʼë Dios, ");
INSERT INTO zarNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","pero yuguʼ bönniʼ naʼ gurö́ cazëʼ Dios para ilaʼyáziëʼ ga naʼ rinná bëʼë Lëʼ, chúʼunëʼ légaquiëʼ níʼilö ga naʼ naca chul-la, ateʼ niʼ ilaʼbödxëʼ, en uluʼtil-la láyëʼë lu yöl-laʼ ruhuíʼini quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Níʼirö Jesús gudxëʼ bönniʼ naʼ rinná béʼenëʼ bönniʼ röjáquiëʼ gudil-la, rnnëʼ: —Böaj lidxuʼ. Ca naʼ réajlëʼu, caʼ gaca quiuʼ. Laʼ náʼasö böácatëbiʼ biʼi huen dxin queëʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Bidxinëʼ Jesús lidxëʼ Pedro, ateʼ niʼ biléʼenëʼ-nu xináʼanu nigula queëʼ, dënu lu daʼa, en yúʼunu tu xilá. ");
INSERT INTO zarNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Gudanëʼ Jesús náʼanu, ateʼ laʼ burúajtë xilá naʼ yúʼunu. Níʼirö böásanu, en bunö́dzjanu le gulahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Cateʼ chiridzö́ʼ dza naʼ, dujuáʼagaquiëʼ zián bönniʼ yúʼugaca böʼ xihuiʼ légaquiëʼ ga zoëʼ Jesús, ateʼ len yöl-laʼ rinnësö queëʼ bubéajëʼ yuguʼ böʼ xihuiʼ naʼ, en bunëʼ caʼ yúguʼtë nupa teʼe. ");
INSERT INTO zarNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Caní guca para gaca ca naʼ gunnë́ʼ Isaías, bönniʼ bëʼë didzaʼ uláz queëʼ Dios, gunnë́ʼ: “Lëʼ buʼë yuguʼ le rizácaʼruʼ, en buʼë caʼ yuguʼ yödzöhuë́ʼ queë́ruʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Cateʼ biléʼenëʼ Jesús nacuáʼ bönachi zián gásibiʼilëʼ, gunná béʼenëʼ yuguʼ bönniʼ usëda queëʼ ilaʼdödëʼ iaʼtsöláʼa nísadoʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Bidxinëʼ tu bönniʼ yudoʼ usedi ga naʼ zoëʼ Jesús, en rëʼ Lëʼ: —Bönniʼ Usedi, sáʼlenaʼ Liʼ gátiʼtës ga tsejuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús rëʼ lëʼ: —Yuguʼ bözaʼ nacuáʼ zxan guiö́j quégacabaʼ, ateʼ yuguʼ biguínnidoʼ, nudxíagacabaʼ xicáʼagacabaʼ, pero nedaʼ, Bönniʼ Guljëʼ Bönachi, bitiʼ dë ga quíxaj icjaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Iaʼtúëʼ bönniʼ, náquiëʼ bönniʼ usëda queëʼ Jesús, gudxëʼ Lëʼ: —Xan, benna nedaʼ lataj huöjaʼ ga idxinrö dza chibucáchaʼa-nëʼ xuzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús gudxëʼ lëʼ: —Gudáʼ nedaʼ. Bëʼ lataj yuguʼ bönniʼ tati cazëʼ uluʼcáchëʼë nupa ilátigaca quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Gurenëʼ Jesús lëʼe bárcodoʼ, ateʼ dzágagaquiëʼ Lëʼ bönniʼ usëda queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Níʼirö guyecja böʼ budunuʼ lu nísadoʼ naʼ, ateʼ riyasa ridxíadaʼ nísadoʼ naʼ ga bidxintë riyaza nisa lëʼe bárcodoʼ naʼ. Dëʼ rásiëʼ Jesús lëʼe barco naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Níʼirö bilaʼdxinëʼ bönniʼ usëda queëʼ Jesús ga naʼ zoëʼ, ateʼ buluʼsubanëʼ Lëʼ, en tëʼ Lëʼ: —Xan, busölá netuʼ. Chirigáchiʼruʼ lu nisa. ");
INSERT INTO zarNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Bubiʼë didzaʼ Jesús, en rëʼ légaquiëʼ: —¿Bizx que rádxiliʼ? Látiʼdoʼos réajlëʼëliʼ-nëʼ Dios. Níʼirö guyasëʼ Jesús, en bulidzëʼ böʼ naʼ recja, en nísadoʼ naʼ, ateʼ laʼ gurö́ʼötë dxi. ");
INSERT INTO zarNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Buluʼbáninëʼ bönniʼ naʼ, taʼnnë́ʼ: —¿Nuzxi caz bönniʼ ni? Ruíʼisëʼ didzaʼ, ateʼ böʼ recja, en nísadoʼ tun ca rnnëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Cateʼ bidxinëʼ Jesús iaʼtsöláʼa nísadoʼ ga naʼ naca lu xiyú yödzö Gadara, bilaʼrúajëʼ chopëʼ bönniʼ ga nacuáʼ ba quégaca nupa nátigaca, dutságagaquiëʼ Jesús. Nácagaquiëʼ síniaʼ, ateʼ cuntu nu gaca tödi laʼ nöza niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Laʼ guluíʼitëʼ zidzaj didzaʼ chopëʼ ni, taʼnnë́ʼ: —¿Bizxi ral-laʼtuʼ quiuʼ, Jesús, Zxíʼinëʼ Dios? ¿Naruʼ bidxintsoʼ ni dusacaʼ ziʼu netuʼ zíʼalö ca idxín dza queë́tuʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ga niʼ nacuʼë nacuáʼabaʼ cuchi zián taʼdabaʼ tágubaʼ, nacuáʼabaʼ látiʼdoʼ ga naca ziʼtuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Gulaʼnaba yechiʼ böʼ xihuiʼ naʼ Jesús, en të Lëʼ: —Channö ubéajuʼ netuʼ, benna lataj tsöjtsúʼugacatuʼ-baʼ cuchi zián niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Níʼirö Jesús gudxëʼ léguequi: —Guliʼtséaj. Laʼ bilaʼrúajtë böʼ xihuiʼ, en yöjcházagaca cuchi zián niʼ. Níʼirö yúguʼtëbaʼ cuchi zián naʼ yöjbíxitëgacabaʼ ga naca lëʼe guiö́j, en yöjcházagacabaʼ lu nísadoʼ, ga niʼ gulaʼyë́pibaʼ nisa, en gulátibaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Guládxinëʼ bönniʼ tuʼyúëʼ-baʼ cuchi naʼ, ateʼ buluʼzxúnnajëʼ. Cateʼ bilaʼdxinëʼ lu yödzö, gulaʼguíxjöʼë yúguʼtë lë naʼ guca quégaquiëʼ bönniʼ niʼ gulaʼyúʼu böʼ xihuiʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Níʼirö bilaʼrúaj bönachi lu yödzö niʼ, yöjtságagaquiëʼ Jesús. Cateʼ bilaʼléʼenëʼ Lëʼ, gulátaʼyuëʼ lahuëʼ uzë́ʼë lu xiyúgaquiëʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Níʼirö bubenëʼ Jesús lëʼe bárcodoʼ, en gudödëʼ iaʼtsöláʼa nísadoʼ niʼ, ateʼ budxinëʼ ga naca ladzëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Niʼ dujuáʼgaquiëʼ tu bönniʼ nacúʼuniëʼ bin ga zoëʼ Jesús, zxoëʼ lu daʼa yaga. Cateʼ biléʼenëʼ Jesús ca naʼ taʼyéajlëʼë bönniʼ ni Lëʼ, gudxëʼ bönniʼ naʼ nacúʼuniëʼ bin, rnnëʼ: —Butipa ládxuʼu, zxíʼinaʼdoʼ. Chibuníti lahuaʼ dul-laʼ nabáguʼu. ");
INSERT INTO zarNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nacuʼë caʼ bönniʼ yudoʼ tuʼsédinëʼ niʼ, ateʼ taʼnnë́ʼ lu icja ládxiʼdoʼgaquiëʼ, taʼnnë́ʼ: “Didzaʼ ruʼë bönniʼ ni ruzóa Dios tsöláʼalö.” ");
INSERT INTO zarNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Cateʼ réquibeʼenëʼ Jesús le taʼzáʼ ládxiʼgaquiëʼ, rëʼ légaquiëʼ: —¿Bizx que rizáʼ ládxiʼliʼ caní le cabí naca tsahuiʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Bitiʼ naca böniga nu guië́sö bönniʼ ni: “Yuguʼ dul-laʼ nabáguʼu chibuníti lahuaʼ”, pero naca böniga nu gun ga huöásëʼ, en uzéʼenëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Naʼa, uluíʼidaʼ libíʼiliʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, dë lu naʼa yöl-laʼ unná bëʼ uniti lahuaʼ dul-laʼ luyú ni. Níʼirö Jesús gudxëʼ bönniʼ naʼ nacúʼuniëʼ bin, rnnëʼ: —Guyása. Buchisa daʼa yaga quiuʼ, en böaj lidxuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Níʼirö laʼ guyásatëʼ bönniʼ naʼ nacúʼuniëʼ bin, en bö́ajëʼ lidxëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Cateʼ bilaʼléʼenëʼ bönniʼ nacuʼë niʼ lë ni, buluʼbáninëʼ, ateʼ gulaʼguʼë Dios yöl-laʼ ba tuʼ bunödzjëʼ yöl-laʼ huáca caní quégaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Cateʼ buzë́ʼë Jesús niʼ, biléʼenëʼ bönniʼ lëʼ Mateo, röʼë ga naʼ ruquízxjëʼ uláz que yödzö ziʼtuʼ, ateʼ Jesús gudxëʼ lëʼ: —Gudáʼ nedaʼ. Níʼirö laʼ guyásatëʼ Mateo naʼ, ateʼ saʼyéajlenëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Iaʼtú le guca, cateʼ niʼ röʼë Jesús rahuëʼ ga naca lidxëʼ Mateo, zián bönniʼ tuʼquízxjëʼ, en yuguʼ bönniʼ cáʼasö bilaʼdxinëʼ ga zoëʼ, ateʼ gulaʼbö́ʼlenëʼ Jesús tsözxö́n len yuguʼ bönniʼ usëda queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Cateʼ bönniʼ yudoʼ fariseo bilaʼléʼenëʼ lë ni, gulaʼnábinëʼ yuguʼ bönniʼ usëda queëʼ Jesús, taʼnnë́ʼ: —¿Naruʼ bönniʼ rusédinëʼ libíʼiliʼ rágulentsëʼ tsözxö́n bönniʼ tuʼquízxjëʼ, en iáʼzícaʼrëʼ bönniʼ dul-laʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Cateʼ biyönnëʼ Jesús lë ni, rëʼ légaquiëʼ: —Bitiʼ naquíniguequinëʼ bönniʼ nácagaquiëʼ dxiʼa nu un bönachi, pero bönniʼ téʼenëʼ naquíniguequinëʼ nu un bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Guliʼtséaj, en buliʼsëda le rnna lë naʼ nazúaj lu guichi láʼayi, le rnna caní: “Rë́ʼëndaʼ uluʼhuéchiʼ ládxiʼgaquiëʼ bönniʼ luzáʼagaquiëʼ, en calëga ilútiëʼ-baʼ böaʼ bëdxi lu bucugu láʼayi quiaʼ.” Bidaʼ ni, calëga para ulídzagacaʼ-nëʼ bönniʼ tsahuiʼ, pero bidaʼ para ulídzagacaʼ-nëʼ bönniʼ dul-laʼ para uluʼbíʼi ládxiʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Níʼirö bönniʼ dáʼgaquiëʼ Juan, bönniʼ naʼ buquilëʼ bönachi nisa, bilaʼdxinëʼ ga zoëʼ Jesús, ateʼ gulaʼnábinëʼ Lëʼ, taʼnnë́ʼ: —¿Bizx que naʼ netuʼ, encaʼ yuguʼ bönniʼ yudoʼ fariseo, zián luzuí runtuʼ gubasa, pero yuguʼ bönniʼ usëda quiuʼ Liʼ bitiʼ tunëʼ gubasa? ");
INSERT INTO zarNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Bubiʼë didzaʼ Jesús, en rëʼ légaquiëʼ: —¿Naruʼ huácatsö ilaʼsëbi ládxiʼgaca nupa nacuáʼ laní que yöl-laʼ rutsaga naʼ tsanni niʼ bönniʼ rutsaga nëʼë zóalenëʼ légaquiëʼ? Zaʼ dza cateʼ idúëʼ bönniʼ naʼ rutsaga nëʼë ga nacuʼë. Dza níʼirö ilunëʼ gubasa. ");
INSERT INTO zarNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Bucúdzuʼë didzaʼ Jesús, rnnëʼ: —Cuntu nu un tu lariʼ tëbi len lariʼ cubi, tuʼ uxúʼuni lariʼ cubi naʼ nuguʼë lariʼ tëbi naʼ, ateʼ ichö́zaʼrö lariʼ tëbi naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Lëscaʼ caní, cuntu nu bönniʼ riguë́ʼënëʼ xisi uva cubi tu lu buzudi guídi gula, tuʼ galaj ilëbi xisi uva cubi naʼ, en uzxuzxaj buzudi guídi gula naʼ, ateʼ gaca ditaj xisi uva naʼ, ateʼ initi caʼ buzudi guídi naʼ. Rigáʼaruʼ xisi uva cubi tu lu buzudi guídi cubi, ateʼ irópatë taca chiʼi. ");
INSERT INTO zarNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tsanni niʼ Jesús ruíʼilenëʼ légaquiëʼ didzaʼ ni, tu bönniʼ rinná béʼenëʼ bönachi judío bidxinëʼ ga zoëʼ, ateʼ buzóa zxibëʼ lahuëʼ Jesús, en rëʼ Lëʼ: —Biʼi nigúladoʼ quiaʼ laʼ gútitëbiʼ. Gudá ixóa noʼo lëbiʼ, ateʼ ubanbiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Laʼ guzuítenëʼ Jesús, en saʼyéajlenëʼ lëʼ. Dzágagaquiëʼ bönniʼ usëda queëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Níʼirö bidxinnu tu nigula zacaʼ cúdzuʼlëʼ Jesús, chiguca chinnu iz réʼenu, bitiʼ ruhuíʼi rön queë́nu que huëʼ quégaca cázanu nigula, ateʼ gudannu lariʼ nácuëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Caní bennu tuʼ rizáʼ ládxiʼnu, rnnanu: Channö cansaʼ zxëʼ, huöácaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Níʼirö buécjëʼ Jesús, en ruyúëʼ lënu, ateʼ rëʼë-nu: —Butipa ládxuʼu, zxíʼinaʼdoʼ. Chiböácateuʼ tuʼ réajlëʼu nedaʼ. Laʼ náʼasö böácatënu. ");
INSERT INTO zarNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Cateʼ bidxinëʼ Jesús lidxëʼ bönniʼ unná bëʼ naʼ, biléʼenëʼ nacuʼë niʼ bönniʼ tuʼcödxëʼ gui, en nupa taʼbödxi yechiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesús rëʼ légaquiëʼ: —Guliʼcuita ni, tuʼ cabí nátibiʼ biʼi nigúladoʼ ni. Rásisibiʼ naʼ. Níʼirö nupa nacuáʼ niʼ buluʼtitaj Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Cateʼ chinubéajëʼ Jesús bönachi naʼ níʼilö, guyáziëʼ, en gudélëʼë náʼabiʼ biʼi nigula naʼ, ateʼ laʼ guyásatëbiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Guzë́ didzaʼ ca guca lë ni, ateʼ bilaʼyöni bönachi nacuáʼ idútë luyú naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Cateʼ Jesús burúajëʼ niʼ, chopëʼ bönniʼ nachul-la guiö́j lógaquiëʼ söjácalenëʼ Lëʼ. Tuʼë zidzaj didzaʼ, taʼnnë́ʼ: —Zxíʼini xiʼsóëʼ David, buéchiʼ ladxiʼ netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Cateʼ bidxinëʼ Jesús ga naca lu yuʼu, bilaʼdxinëʼ chopëʼ bönniʼ naʼ nachul-la guiö́j lógaquiëʼ ga zoëʼ. Jesús gunábinëʼ légaquiëʼ, rnnëʼ: —¿Ba réajlëʼëliʼ nedaʼ, huáca unaʼ libíʼiliʼ? Légaquiëʼ taʼnnë́ʼ: —Ön, Xan. ");
INSERT INTO zarNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Níʼirö Jesús gudanëʼ guiö́j lógaquiëʼ, ateʼ rnnëʼ: —Ca réajlëʼëliʼ, caʼ gaca queë́liʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Laʼ böáljatë guiö́j lógaquiëʼ. Níʼirö Jesús buzenëʼ bach légaquiëʼ, rnnëʼ: —Guliʼgüíʼiticaʼsö ládxiʼliʼ cuntu nu inözi lë ni. ");
INSERT INTO zarNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Cateʼ buluʼrúajëʼ niʼ, laʼ buluʼzëtëʼ didzaʼ idútë luyú niʼ ca naca lë naʼ benëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Cateʼ Jesús, en yuguʼ bönniʼ usëda queëʼ buluʼrúajëʼ tu lu yuʼu, bilaʼdxinëʼ bönniʼ ga zoëʼ Jesús nachë́ʼgaquiëʼ lahuëʼ tu bönniʼ bitiʼ ruʼë didzaʼ, tuʼ yuʼu lëʼ böʼ xihuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Cateʼ bubéajëʼ Jesús böʼ xihuiʼ naʼ, laʼ gunnëtëʼ bönniʼ naʼ bitiʼ guca guʼë didzaʼ. Buluʼbáninëʼ bönniʼ nacuʼë niʼ, taʼnnë́ʼ: —Catu caz riléʼetuʼ le caní ladaj bönachi Israel. ");
INSERT INTO zarNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Níʼirö bönniʼ yudoʼ fariseo gulaʼnnë́ʼ queëʼ Jesús, taʼnnë́ʼ: —Bönniʼ ni rubéajëʼ yuguʼ böʼ xihuiʼ, rugunëʼ dxin yöl-laʼ unná bëʼ que xángaca böʼ xihuiʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Gudë́ʼ Jesús idú gásibiʼilö gapa nacuáʼ yödzö zxön, en gapa nacuáʼ yö́dzödoʼ, ateʼ gapa naca lu yuʼu ga tuʼdubëʼ tuʼsëdëʼ bönniʼ judío queëʼ Dios. Rusédinëʼ Jesús bönachi nacuáʼ niʼ, en runëʼ libán que didzaʼ dxiʼa ca rinná bëʼë Dios. Bunëʼ yúguʼtë nupa bi taʼguíʼi taʼzacaʼ yuguʼ lu yödzö naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Cateʼ Jesús biléʼenëʼ bönniʼ zián niʼ, buéchiʼ ládxëʼë légaquiëʼ, tuʼ taʼguíʼi taʼzáquiëʼ, en nudú ládxiʼgaquiëʼ ca raca quégacabaʼ böʼcuʼ zxilaʼ bitiʼ zoa nu ruyú légacabaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Níʼirö Jesús rëʼ yuguʼ bönniʼ usëda queëʼ, rnnëʼ: —Le nácatë dëdaʼ yöla, pero nabábasö nupa tuʼlapa. ");
INSERT INTO zarNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Que lë ni naʼ, guliʼgátaʼyu lahuëʼ Dios, náquiëʼ Xan yöla naʼ, inábiliʼ-nëʼ isö́l-lëʼë bönniʼ huen dxin uluʼlapëʼ yöla queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Níʼirö bulidzëʼ Jesús idxínnutëʼ bönniʼ usëda queëʼ, en budödëʼ lu náʼagaquiëʼ yöl-laʼ unná bëʼ para uluʼbéajëʼ böʼ xihuiʼ yúʼugaca bönachi, en uluʼúnëʼ yúguʼtë nupa teʼe, en yúguʼtë nupa bi taʼguíʼi taʼzacaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Caní naca lágaquiëʼ idxínnutëʼ gubáz naʼ nasö́l-lëʼë Jesús: Simón, (lëʼ caʼ Pedro), Andrés, (bö́chëʼë Simón naʼ), Jacobo, (zxíʼinëʼ Zebedeo), Juan, (bö́chëʼë Jacobo naʼ), ");
INSERT INTO zarNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo, (bönniʼ uquízxaj), Jacobo, (zxíʼinëʼ Alfeo), Lebeo, (lëʼ caʼ Tadeo), ");
INSERT INTO zarNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, (bönniʼ ruíʼi ládxëʼë yödzö queëʼ), Judas Iscariote, (bönniʼ udödëʼ Jesús lu náʼagaquiëʼ bönniʼ ilútiëʼ Lëʼ). ");
INSERT INTO zarNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Níʼirö Jesús gusö́l-lëʼë idxínnutëʼ bönniʼ ni tsöjéngaquiëʼ libán, ateʼ gunná béʼenëʼ légaquiëʼ, rnnëʼ: —Bitiʼ tséajliʼ ga nacuáʼ bönachi bitiʼ nácagaca judío, en bitiʼ tsúʼuliʼ ládzagaca bönachi nacuáʼ luyú Samaria. ");
INSERT INTO zarNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Guliʼtséaj ga nacuáʼ bönachi Israel, nácagaquiëʼ ca böʼcuʼ zxílaʼdoʼ nanítigacabaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Guliʼtsöjén libán, innaliʼ: “Chibidxín galaʼ dza Dios, Nu naʼ zoa yehuaʼ yubá, inná bëʼë luyú ni.” ");
INSERT INTO zarNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Buliʼún nupa teʼe. Buliʼún dxiʼa nupa teʼe huëʼ nudzuʼ ruzödi. Buliʼsubán nupa chinátigaca. Buliʼbéaj böʼ xihuiʼ yúʼugaca bönachi. Bénnasaʼ queë́liʼ yöl-laʼ unná bëʼ ni. Buliʼgún dxin le, en bitiʼ bi uquízxjaliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Bitiʼ bi guáʼaliʼ lu buzudi queë́liʼ, calëga dumí oro, en calëga dumí plata, en calëga dumí lásidoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Bitiʼ guáʼaliʼ yöxaj yöta queë́liʼ le gáguliʼ laʼ nöza. Tuz lariʼ ixóa yenliʼ, en bitiʼ guáʼaliʼ xiráchuliʼ o xiyaga queë́liʼ, tuʼ idzöli quézinëʼ bönniʼ huen dxin le gahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Gátiʼtës yödzö zxön o yö́dzödoʼ ga idxinliʼ, guliʼnaba nuzxi naca idú ladxiʼ lu yödzö niʼ, ateʼ ugáʼanaliʼ lidxi nu naʼ cateʼ gálaʼrö dza urúajliʼ yödzö naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Cateʼ tsúʼuliʼ tu lu yuʼu, buliʼgapa Dios bönachi nacuáʼ lu yuʼu naʼ, inábiliʼ-nëʼ Dios unödzjëʼ quégaquiëʼ le cuéqui dxi icja ládxiʼdoʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Channö bönachi nacuáʼ lu yuʼu niʼ nácagaca lesacaʼ, ugáʼanalen le ribequi dxi ladxiʼ naʼ léguequi, pero channö bönachi naʼ cabí nácagaca lesacaʼ, inábaliʼ cabí ugáʼana lë naʼ ribequi dxi ladxiʼ len léguequi. ");
INSERT INTO zarNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Gátiʼtës ga idxinliʼ ga bönachi niʼ bitiʼ ilún libíʼiliʼ bal, en bitiʼ uluʼzë́ nagui xtídzaʼliʼ, buliʼrúaj lu yuʼu niʼ o yödzö niʼ, ateʼ guliʼcuíbi bëchtö daʼ lëʼe lábaliʼ, le uluíʼi léguequi nabágaʼgaca xíguiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Le nácatë reaʼ libíʼiliʼ, cateʼ idxín dza ichúguiëʼ Dios quégaca bönachi, ilaʼguíʼi ilaʼzácaʼrö bönachi yödzö naʼ ca ilaʼguíʼi ilaʼzacaʼ bönachi gulaʼcuáʼ yödzö Sodoma, en yödzö Gomorra, nupa niʼ busunítiëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Gunnë́ʼ caʼ Jesús: —Buliʼyútsöcaʼ, nedaʼ risö́l-laʼa libíʼiliʼ, ateʼ gácaliʼ ca böʼcuʼ zxílaʼdoʼ taʼdabaʼ ga dzö́ʼöbaʼ böʼcuʼ guíʼa síniaʼ. Guliʼgaca sinaʼ ca nácagacabaʼ sinaʼ bëla síniaʼ, pero guliʼgaca caʼ nöxaj ladxiʼ ca nácagacabaʼ guʼdödoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Guliʼgún chiʼi cuinliʼ quégaca bönachi, tuʼ uluʼdödëʼ libíʼiliʼ lu náʼagaquiëʼ bönniʼ yúlahuiʼ, en ilaʼguínëʼ libíʼiliʼ gapa naca lu yuʼu ga tuʼdubëʼ tuʼsëdëʼ bönniʼ judío queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Lëscaʼ caní, ilaʼchë́ʼë libíʼiliʼ lógaquiëʼ bönniʼ lo, en lógaquiëʼ bönniʼ taʼnná bëʼë, tuʼ dáʼaliʼ nedaʼ. Caní gaca para gaca gunliʼ ba nalí quiaʼ lógaquiëʼ bönniʼ niʼ, en lógaquiëʼ bönniʼ bitiʼ nácagaquiëʼ judío. ");
INSERT INTO zarNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Níʼirö cateʼ uluʼdödëʼ libíʼiliʼ lu náʼagaquiëʼ bönniʼ unná bëʼ naʼ, bitiʼ cö́ʼöliʼ böniga nacxi innaliʼ, tuʼ ichizëʼ Dios icja ládxiʼdoʼoliʼ didzaʼ güíʼiliʼ, en ca innaliʼ laʼ dza náʼasö. ");
INSERT INTO zarNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Calëga libíʼisiliʼ naʼ innaliʼ, pero Dios Böʼ Láʼayi, Nu naʼ risö́l-lëʼë Xúziruʼ Dios queë́liʼ, Lë cazëʼ sóalenëʼ libíʼiliʼ, en guʼë didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Ilaʼcuáʼ bönachi uluʼdödi bö́chiʼguequi lu náʼagaquiëʼ bönniʼ ilútiëʼ légaquiëʼ, en lëscaʼ caní, bönniʼ nácagaquiëʼ xuz uluʼdödëʼ zxíʼinigaquiëʼ, ateʼ ilaʼcuáʼabiʼ biʼi ilaʼdáʼbagaʼbiʼ xúzgacabiʼ, en ilunbiʼ ga ilátiëʼ xúzgacabiʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yúguʼtë bönachi uluʼzóa libíʼiliʼ tsöláʼalö tuʼ dáʼaliʼ nedaʼ, pero nu ugáʼana tsutsu ga idxinrö dza údxi, nu ni ulá. ");
INSERT INTO zarNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Cateʼ uluʼsacaʼ ziʼ bönachi libíʼiliʼ tu lu yödzö, buliʼzxunnaj niʼ, ateʼ tséajliʼ iaʼtú yödzö, tuʼ reaʼ libíʼiliʼ, huödaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, zíʼalö cateʼ údxi gunliʼ libán gapa nacuáʼ yuguʼ yödzö quégaca bönachi Israel. ");
INSERT INTO zarNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Nútiʼtës bönniʼ náquiëʼ bönniʼ usëda bitiʼ nácarëʼ lo ca nu rusëdi lëʼ, en lëscaʼ caní, nu bönniʼ náquiëʼ huen dxin bitiʼ nácarëʼ lo ca xanëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nu naʼ naca bönniʼ usëda ral-laʼ udzéjanëʼ channö huadéliʼnëʼ gáquiëʼ ca naca nu rusëdi lëʼ, ateʼ bönniʼ huen dxin naʼ ral-laʼ udzéjanëʼ channö gáquiëʼ ca naca xanëʼ. Channö taʼnnë́ʼ quiaʼ nedaʼ, bönniʼ xan yuʼu, taʼnnë́ʼ nacaʼ Belzebú tuʼ xihuiʼ, ilaʼnnë́ zíʼirëʼ quégaca bönachi táʼgaquiëʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Gunnë́ʼ caʼ Jesús: —Que lë ni naʼ, bitiʼ gádxiliʼ bönachi. Hualáʼ lahui yúguʼtë le raca bëdxi lándoʼos, ateʼ huáca bëʼ yúguʼtë le nagachiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yuguʼ didzaʼ ruíʼilenaʼ libíʼiliʼ ga naca chul-la, guliʼquixjöʼ ga naca lu beníʼ, ateʼ le reaʼ libíʼiliʼ ga nagachiʼ, guliʼnnë́ zidzaj ga naca lahuiʼ lógaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Bitiʼ gádxiliʼ nupa tuti le nácagaca caz bönachi, pero bitiʼ gaca uluʼsuniti böʼ naca cázaruʼ. Guliʼgadxi Dios, Bönniʼ naʼ gaca gútiëʼ idútë le nácaliʼ, en chúʼunëʼ böʼ naca cázaliʼ lu guíʼ gabila. ");
INSERT INTO zarNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Taʼdáʼubaʼ chópabaʼ biguínnidoʼ len tu dumí lásidoʼ, pero bitiʼ ibíxibaʼ tubaʼ lu yu channö cabí ruʼë Xúziruʼ Dios lataj gaca caní. ");
INSERT INTO zarNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Lëscaʼ caní, nabábagaca yúguʼtë guitsaʼ ícjaliʼ lahuëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Que lë ni naʼ, bitiʼ gádxiliʼ. Ruíʼitërö ládxëʼë Dios libíʼiliʼ ca ruíʼi ládxëʼë-baʼ zianbaʼ biguínnidoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Gunnë́ʼ caʼ Jesús: —Nu bönniʼ siʼ lu nëʼë nedaʼ lógaca bönachi, nedaʼ siʼ lu naʼa bönniʼ naʼ lahuëʼ Xuzaʼ zoëʼ yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Bönniʼ taʼdáʼbaguëʼë lógaca bönachi, ilaʼnnë́ʼ bitiʼ taʼdë́ʼë nedaʼ, lëscaʼ caní nedaʼ táʼbagaʼa légaquiëʼ lahuëʼ Xuzaʼ zoëʼ yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Gunnë́ʼ caʼ Jesús: —Bitiʼ guéquiliʼ zaʼa idiguʼa le ribequi dxi bönachi yödzölió ni. Bitiʼ zaʼa idiguʼa le ribequi dxi, pero zaʼa idiguʼa le gun ga ilaʼrúaj choplö bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Zaʼa ni, ateʼ gunaʼ ga ilaʼdáʼbagaʼ bönachi xúzguequi, ateʼ yuguʼ nigula ilaʼdáʼbagaʼnu caʼ xináʼagacanu. Lëscaʼ caní, yuguʼ nigula zxoaʼ lídxigacanu ilaʼdáʼbagaʼnu xtoʼ zxíʼininu. ");
INSERT INTO zarNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Caní gaca, laʼ diʼa dzasö quégaca bönachi uluʼsacaʼ ziʼ luzë́ʼeguequi. ");
INSERT INTO zarNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Nu nadxíʼirö xuz xinëʼe ca nadxíʼi nedaʼ, bitiʼ naca bachi nu naʼ taʼ nedaʼ, ateʼ nu nadxíʼirö biʼi bönniʼ que o biʼi nigula que ca nadxíʼi nedaʼ, bitiʼ naca bachi nu naʼ taʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nu bitiʼ siʼ lu nëʼe gaca ca tu bönniʼ söjtë́ʼë lëʼe yaga cruz, en taʼ nedaʼ, bitiʼ naca bachi guequi quiaʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nu ruíʼi ladxiʼ gun chiʼi yöl-laʼ naʼbán que, uniti le, pero nu uniti yöl-laʼ naʼbán que tuʼ daʼ nedaʼ, ulá nu naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Gunnë́ʼ caʼ Jesús: —Nu gun libíʼiliʼ bal, nedaʼ caʼ gun bal, ateʼ nu naʼ gun nedaʼ bal, gun bal caʼ Dios Xuz nasö́l-lëʼë nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nu gun bal tu bönniʼ ruʼë didzaʼ uláz queëʼ Dios tuʼ ruʼë didzaʼ uláz queëʼ Dios, huadeliʼ nu naʼ lu nëʼë Dios laʼ leze naʼ idéliʼnëʼ bönniʼ ruʼë didzaʼ uláz queëʼ Dios. Lëscaʼ caní, nu gun bal tu bönniʼ tsahuiʼ tuʼ náquiëʼ bönniʼ tsahuiʼ, huadeliʼ nu naʼ lu nëʼë Dios laʼ leze naʼ idéliʼnëʼ bönniʼ tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nútiʼtës nu unödzaj queëʼ tu bö́nniʼdoʼ ni tu zxibíndoʼos nisa tuʼ náquiëʼ bönniʼ usëda quiaʼ nedaʼ, le nácatë reaʼ libíʼiliʼ, bitiʼ uniti nu naʼ le ral-laʼ siʼ lu nëʼë Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Cateʼ Jesús budxi buzéajniʼinëʼ yuguʼ bönniʼ usëda queëʼ, buzë́ʼë niʼ, saʼyéajëʼ röjsédinëʼ bönachi, en röjenëʼ libán yuguʼ lu ládzagaca bönachi naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan, bönniʼ buquilëʼ bönachi nisa, niʼ yuʼë lidxi guíë, ateʼ biyönnëʼ ca nácagaca le runëʼ Jesús. Níʼirö Juan naʼ gusö́l-lëʼë chopëʼ bönniʼ dáʼgaquiëʼ lëʼ, ateʼ bilaʼdxinëʼ ga naʼ zoëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Chopëʼ ni gulaʼnábinëʼ Jesús, tëʼ Lëʼ: —¿Nacuʼ Liʼ Cristo, Bönniʼ naʼ ral-laʼ idxinëʼ yödzölió ni, o ral-laʼ cöztuʼ dza idxinëʼ iaʼtúëʼ bönniʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Bubiʼë didzaʼ Jesús, rëʼ légaquiëʼ: —Guliʼtséaj tsöjtíxjöiʼiliʼ-nëʼ Juan lë ni riyö́niliʼ, en riléʼeliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Guliʼtsöjödxëʼ ca raca, tuʼléʼenëʼ bönniʼ guchul-la guiö́j lógaquiëʼ, ateʼ tuʼzë́ʼë bönniʼ bitiʼ guca ilaʼdë́ʼ. Nuhuöácagaquiëʼ bönniʼ güíʼiguequinëʼ huëʼ nudzuʼ ruzödi, ateʼ taʼyönnëʼ bönniʼ gulaʼcö́dzuëʼ. Nnitaʼ nabángaquiëʼ bönniʼ gulátiëʼ, ateʼ raca libán que didzaʼ dxiʼa lógaca bönachi yechiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Bicaʼ ba nu bönniʼ bitiʼ gáquiëʼ chopa ládxëʼë, bitiʼ ubéaj ládxëʼë nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Cateʼ yuguʼ bönniʼ naʼ dáʼgaquiëʼ Juan buluʼzë́ʼë söjhuö́jgaquiëʼ, níʼirö gusí lahuëʼ Jesús ruíʼilenëʼ bönachi nacuáʼ niʼ didzaʼ ca naca queëʼ Juan naʼ. Rëʼ légaquiëʼ: —¿Bizxi gúʼuniliʼ iléʼeliʼ cateʼ niʼ guyéajliʼ lu lataj cáʼasö? ¿Naruʼ gúʼuniliʼ iléʼeliʼ-nëʼ tu bönniʼ náquiëʼ ca tu gui ruzecaj böʼ recja le? ");
INSERT INTO zarNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Channö cabí, ¿bizxi gúʼuniliʼ iléʼeliʼ? ¿Naruʼ gúʼuniliʼ iléʼeliʼ-nëʼ tu bönniʼ nácuëʼ lariʼ dxíʼadoʼ? Nöz quéziliʼ bönniʼ nácugaquiëʼ lariʼ dxíʼadoʼ nacuʼë lídxigaquiëʼ bönniʼ taʼnná bëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Channö cabí, ¿bizxi gúʼuniliʼ iléʼeliʼ? ¿Naruʼ gúʼuniliʼ iléʼeliʼ-nëʼ tu bönniʼ ruʼë didzaʼ uláz queëʼ Dios? Caʼ naca, réquidaʼ. Reaʼ libíʼiliʼ, biléʼeliʼ-nëʼ tu bönniʼ nácatërëʼ lo ca iaʼzícaʼrëʼ bönniʼ guluʼë didzaʼ uláz queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Caní naca, tuʼ náquiëʼ Juan bönniʼ naʼ ruíʼi didzaʼ le nazúaj lu guichi láʼayi ca naca queëʼ, le rnna: Buyú, risö́l-laʼa bönniʼ gubáz quiaʼ, inö́ruëʼ ca Liʼ. Lëʼ upë́ʼë nöza ga töduʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Le nácatë reaʼ libíʼiliʼ. Idútë yödzölió ni, cuntu nu zoa nácarö lo ca Juan, bönniʼ niʼ buquilëʼ bönachi nisa, pero nu naca cuídiʼdoʼos ga rinná bëʼ Nu naʼ zoa yehuaʼ yubá nácatërö lo ca Juan naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Cateʼ niʼ gusí lahuëʼ buquilëʼ Juan bönachi nisa, ga ridxintë naʼa dza, bayudxi túngaca bönachi para taʼyaza ga rinná bëʼë Bönniʼ naʼ zoëʼ yehuaʼ yubá, ateʼ nupa tunsö bayudxi taʼdeliʼ le. ");
INSERT INTO zarNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ga bidxintë dza naʼ blëʼë Juan, le rinná bëʼ xibá queëʼ Moisés, en le buluʼzúajëʼ lu guichi yúguʼtë bönniʼ guluʼë didzaʼ uláz queëʼ Dios guluíʼi didzaʼ ca rinná bëʼë Bönniʼ naʼ zoëʼ yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Channö rë́ʼëniliʼ siʼ lu náʼaliʼ lë ni, ral-laʼ inö́ziliʼ Juan naʼ náquiëʼ Elías, bönniʼ niʼ bëʼë didzaʼ uláz queëʼ Dios, bönniʼ naʼ Dios gunnë́ʼ ral-laʼ iláʼ lahuëʼ leyúbölö dza ni zóaruʼ naʼa. ");
INSERT INTO zarNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nu zoa nagui, en riyöni ral-laʼ uzë́ nagui. ");
INSERT INTO zarNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Bizxi ubéquiʼtsedaʼ ca nácagaca bönachi nacuáʼ dza ni zóaruʼ naʼa? Nácagaquiëʼ ca yuguʼ bíʼidoʼ taʼbö́ʼöbiʼ lu yë́ʼëyi. Zidzaj tuʼlídzabiʼ luzáʼagacabiʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","taʼnnabiʼ: “Rucö́dxituʼ queë́liʼ gui. ¿Bizx que bitiʼ ruyáʼaliʼ? Rul-la yéchiʼtuʼ queë́liʼ. ¿Bizx que bitiʼ ribödxi yéchiʼliʼ?” ");
INSERT INTO zarNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Caní nácaliʼ, tuʼ bidëʼ Juan, ateʼ tuʼ cabí güíʼi gudahuëʼ ca ráguliʼ libíʼiliʼ, gunnëliʼ queëʼ, gunnaliʼ: “Tuʼ xihuiʼ dzágui lëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Níʼirö bidxinaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, ateʼ reʼaj rahuaʼ, ateʼ rnnëliʼ quiaʼ, rnnaliʼ: “Náquiëʼ bönniʼ huágulëʼë, en bönniʼ reʼjëʼ. Náquiëʼ luzáʼagaquiëʼ bönniʼ uquízxaj, en iaʼzícaʼrö huen dul-laʼ.” Yöl-laʼ réajniʼi queëʼ Dios naca bëʼ niʼa que le tun nupa taʼzíʼ lu në́ʼeguequi le. ");
INSERT INTO zarNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Níʼirö gusí lahuëʼ Jesús ruzenëʼ bach bönachi nacuáʼ yuguʼ yödzö gapa niʼ benëʼ zián yöl-laʼ huáca, tuʼ cabí tuʼbíʼini ládxiʼguequi. ");
INSERT INTO zarNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Gudxëʼ léguequi: —Bicaʼ bayechiʼ libíʼiliʼ, bönachi Corazín. Bicaʼ bayechiʼ libíʼiliʼ, bönachi Betsaida. Laʼtuʼ gulaca lu yödzö Tiro, en lu yödzö Sidón yuguʼ yöl-laʼ huáca benaʼ ga zóaliʼ, dza níʼtëlö uluʼbíʼi ládxiʼgaca bönachi yödzö Tiro, en yödzö Sidón naʼ, en ilácugaca lariʼ tëbi, en uluʼdxía dö ícjaguequi, le uluʼluíʼi tuʼbíʼi ládxiʼgaca bönachi naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Naʼa, nedaʼ reaʼ libíʼiliʼ, cateʼ idxín dza ichúguiëʼ Dios quégaca bönachi, quíʼi sácaʼröliʼ libíʼiliʼ ca ilaʼguíʼi ilaʼzacaʼ bönachi yödzö Tiro, en yödzö Sidón, nupa naʼ busunítiëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Libíʼiliʼ, bönachi Capernaum, guca queë́liʼ ca bidxíntëliʼ ga nu riyaza yehuaʼ yubá. Huö́tjaliʼ lu guíʼ gabila. Laʼtuʼ gulaca yuguʼ yöl-laʼ huáca benaʼ ga zóaliʼ lu yödzö Sodoma, uluʼgáʼana bönachi yödzö niʼ ga ridxintë naʼa dza. ");
INSERT INTO zarNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Naʼa, nedaʼ reaʼ libíʼiliʼ, cateʼ idxín dza ichúguiëʼ Dios quégaca bönachi, quíʼi sácaʼröliʼ libíʼiliʼ ca ilaʼguíʼi ilaʼzacaʼ bönachi Sodoma naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Dza naʼ bëʼë didzaʼ Jesús, rnnëʼ: —Xuzaʼ, nacuʼ Xani yehuaʼ yubá, en Xani luyú ni. Riguʼa Liʼ yöl-laʼ ba, tuʼ bucáchuʼu lë ni, para cabí ilaʼléʼenëʼ bönniʼ taʼyéajniʼideʼenëʼ le, pero buluíʼinuʼ nupa nácagaca ca yuguʼ bíʼidoʼ le. ");
INSERT INTO zarNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Caʼ gaca, Xuzaʼ, tuʼ caní guyaza ládxuʼu Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yúguʼtë nudödëʼ Xuzaʼ lu naʼa. Cuntu nu nunbëʼ nedaʼ, Zxíʼinëʼ Dios, pero tuzëʼ Dios Xuz, en cuntu nu nunbëʼ Dios Xuz, pero tuzaʼ nedaʼ, Zxíʼinëʼ Dios, encaʼ nupa naʼ rë́ʼëndaʼ uluíʼidaʼ léguequi Dios Xuz. ");
INSERT INTO zarNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Guliʼdá ga zoaʼ yúguʼtëliʼ röjxéquiʼliʼ tuʼ rúnticaʼsiliʼ dxin que yöl-laʼ yudoʼ, en nuáʼaliʼ yuaʼ ziʼi quégaca xibá que, ateʼ nedaʼ gunaʼ ga uzíʼ ládxiʼliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Lu yöl-laʼ nöxaj ladxiʼ queë́liʼ guliʼgún xichinaʼ, gácaliʼ ca bëdxi taʼzíʼibaʼ yuguʼ quégacabaʼ. Guliʼsëda lu naʼa nedaʼ, tuʼ nacaʼ nöxaj ladxiʼ, en doʼ ladxiʼ, ateʼ idzöli yöl-laʼ ruzíʼ ladxiʼ queë́liʼ, le cuéqui dxi ládxiʼliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yuguʼ naʼ uguʼa libíʼiliʼ, le naca le inná béʼedaʼ libíʼiliʼ, bitiʼ naca böniga, ateʼ yuaʼ uguʼa libíʼiliʼ le naca le rusédidaʼ, dzáʼdoʼos naca. ");
INSERT INTO zarNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Dza niʼ, le naca dza láʼayi quégaquiëʼ bönniʼ judío, gudödëʼ Jesús gapa dë yöla zxoaʼ xtila, ateʼ taʼdunëʼ bönniʼ usëda queëʼ, en gusí lógaquiëʼ taʼlecjëʼ do ga dxía zxoaʼ xtila, en tahuëʼ zxoaʼ xtila naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Cateʼ bilaʼléʼenëʼ bönniʼ yudoʼ fariseo lë ni, tëʼ Jesús: —Buyútsöcaʼ, tunëʼ bönniʼ usëda quiuʼ le cabí ral-laʼ gunruʼ dza láʼayi. ");
INSERT INTO zarNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Níʼirö Jesús gudxëʼ légaquiëʼ: —¿Naruʼ cabí nulábaniliʼ lu guichi láʼayi bi benëʼ David cateʼ gudunëʼ, ateʼ gulaʼdún caʼ nupa gulaʼcuáʼlen lëʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Guyuʼë lu yuʼu queëʼ Dios, en gudahuëʼ yuguʼ yöta xtila nagúʼugaquiëʼ lu bucugu láʼayi, le cabí ral-laʼ gahuëʼ lëʼ, en bitiʼ ral-laʼ ilahuëʼ bönniʼ gulaʼcuáʼlenëʼ lëʼ, pero légacsëʼ bixúz dë lataj ilahuëʼ le. ");
INSERT INTO zarNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Naruʼ cabí nulábaniliʼ le rinná bëʼ xibá queëʼ Moisés ca tunëʼ bixúz yuguʼ dza láʼayi? Tunëʼ dxin löʼa yudoʼ yuguʼ dza láʼayi, en bitiʼ taʼbáguëʼë xíguiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Naʼa, nedaʼ reaʼ libíʼiliʼ, zoaʼ nedaʼ ni, en nacaʼ bönniʼ nácarëʼ lo ca yudoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bitiʼ réajniʼiliʼ lë naʼ nazúaj lu guichi láʼayi, le rnna: “Rë́ʼëndaʼ huéchiʼ ládxiʼliʼ luzáʼaliʼ, en calëga gútigacaliʼ-baʼ böaʼ bë́dxidoʼ ruzéguiʼgacaliʼ-baʼ lu bucugu láʼayi quiaʼ.” Laʼtuʼ réajniʼiliʼ lë ni, bitiʼ ichúguliʼ quégaca nupa bitiʼ nabágaʼgaca xíguiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Caʼ naca, tuʼ nacaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, Xani dza láʼayi. ");
INSERT INTO zarNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Níʼirö buzë́ʼë Jesús niʼ, ateʼ guyuʼë lu yuʼu ga tuʼdubëʼ bönniʼ judío, en tuʼsëdëʼ queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Lu yuʼu naʼ zoëʼ tu bönniʼ narequiʼ nëʼë, ateʼ tuʼ të́ʼënnëʼ bönniʼ judío unná bëʼ ilaʼdzö́linëʼ bi uluʼzéguiʼë Jesús didzaʼ, que lë ni naʼ gulaʼnábinëʼ Lëʼ, taʼnnë́ʼ: —¿Naruʼ dë lataj unruʼ nu reʼe cateʼ naca dza láʼayi? ");
INSERT INTO zarNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Bubiʼë didzaʼ Jesús, rëʼ légaquiëʼ: —Nu bönniʼ nútsëʼë ládjaliʼ, channö zóabaʼ tubaʼ böʼcuʼ zxilaʼ queëʼ, en channö ibíxibaʼ lu yeru cateʼ naca dza láʼayi, ¿naruʼ cabí tsöjxönëʼ-baʼ, en tsöjléajëʼ-baʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nazácaʼtërëʼ tu bönniʼ ca tubaʼ böʼcuʼ zxilaʼ. Que lë ni naʼ, dë lataj gunruʼ le naca dxiʼa quégaca bönachi cateʼ naca dza láʼayi. ");
INSERT INTO zarNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Níʼirö Jesús gudxëʼ bönniʼ huëʼ naʼ: —Bulí noʼo. Cateʼ bulí nëʼë, laʼ böácatë dxiʼa ca naca iaʼtsöláʼa nëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Níʼirö buluʼrúajëʼ bönniʼ yudoʼ fariseo naʼ, ateʼ gulún xtídzaʼgaquiëʼ para gaca ilútiëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Cateʼ réquibeʼenëʼ Jesús lë ni, buzë́ʼë niʼ, ateʼ söjácalen bönachi zián Lëʼ. Jesús bunëʼ yúguʼtë nupa teʼe ladaj bönachi naʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","en gunná béʼenëʼ léguequi bitiʼ usiyö́nguequi bönachi Nu náquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Caní gunnë́ʼ, para gaca lë naʼ gunnë́ʼ Isaías, bönniʼ bëʼë didzaʼ uláz queëʼ Dios, gunnë́ʼ: ");
INSERT INTO zarNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Buliʼyútsöcaʼ, Bönniʼ ni náquiëʼ Huen Dxin quiaʼ, naʼ gurö́ cazaʼ nedaʼ Lëʼ. Nadxíʼidaʼ Lëʼ, en raza ládxaʼa Lëʼ. Ichizaʼ Lëʼ Böʼ Láʼayi. Lëʼ usiyönnëʼ yúguʼtë bönachi ca gunaʼ, uchiʼa usörö́aʼ quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Cuntu nu tíl-lalenëʼ didzaʼ, en bitiʼ ulidzëʼ zidzaj. Cuntu nu yöni chiʼë ga naca ziʼtuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tu guídoʼ zoa bö bitiʼ quitsjëʼ le, ateʼ guíʼ chizóa ulu, bitiʼ usúluëʼ le, cateʼ uzóarëʼ le naca tsahuiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Yúguʼtë bönachi ilún löza Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Níʼirö dujuáʼgaquiëʼ tu bönniʼ ga zoëʼ Jesús, nachul-la lahuëʼ, en bitiʼ raca guʼë didzaʼ, tuʼ yuʼu böʼ xihuiʼ lëʼ, ateʼ Jesús bunëʼ bönniʼ naʼ. Caní guca, riléʼenëʼ, en ruʼë didzaʼ bönniʼ naʼ guchul-la lahuëʼ, en bitiʼ guca guʼë didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Que lë ni naʼ buluʼbani yúguʼtë bönachi nacuáʼ niʼ, taʼnná: —¿Naruʼ nácatsëʼ bönniʼ ni Zxíʼini Xiʼsóëʼ David, Bönniʼ naʼ ral-laʼ guídëʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Cateʼ bilaʼyönnëʼ bönniʼ yudoʼ fariseo lë ni, taʼzáʼ ládxëʼë, taʼnnë́ʼ: Bönniʼ ni rubéajëʼ yuguʼ böʼ xihuiʼ tuʼ dzaga Beelzebú tuʼ xihuiʼ, xángaca böʼ xihuiʼ, Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Réquibeʼenëʼ Jesús lë naʼ taʼzáʼ ládxiʼgaquiëʼ, ateʼ rëʼ légaquiëʼ: —Gátiʼtës ga taʼnná bëʼ bönachi, channö bönachi niʼ ilaʼrúaj choplö, en ilaʼdíl-lalen luzë́ʼeguequi, initi yöl-laʼ unná bëʼ quéguequi. Lëscaʼ caní, channö ilaʼrúaj choplö bönachi nacuáʼ tu yödzö o tu yuʼu, en ilaʼdil-la, bitiʼ gaca ilaʼdíaʼ bönachi nacuáʼ yödzö naʼ o yuʼu naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Lëscaʼ caní, channö ubéaj Satanás tuʼ xihuiʼ laʼ luzë́ʼesö, ateʼ yuguʼ böʼ xihuiʼ naʼ ilaʼdíl-lalen laʼ léguequisö, ¿naruʼ idíaʼ yöl-laʼ unná bëʼ que tuʼ xihuiʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Rnnaliʼ quiaʼ rubéajaʼ yuguʼ böʼ xihuiʼ tuʼ dzaga Beelzebú tuʼ xihuiʼ nedaʼ. Channö runaʼ caní, ¿nuzxi dzaga nupa dáʼgaca libíʼiliʼ cateʼ tuʼbéaj yuguʼ böʼ xihuiʼ? Que lë ni naʼ le túngaca caz naca bëʼ nachíxiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Naʼa, channö nedaʼ rubéajaʼ yuguʼ böʼ xihuiʼ tuʼ zóalen yöl-laʼ huáca queëʼ Dios Böʼ Láʼayi nedaʼ, le nácatë chibidxín le rinná bëʼë Dios ga zóaliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Naruʼ huácatsö nu bönniʼ tsuʼë lidxëʼ bönniʼ nal-la, en cuéajëʼ yöl-laʼ tsahuiʼ dzöʼö lidxëʼ channö cabí gúguëʼë bönniʼ nal-la naʼ zíʼalö? Níʼirö gaca tsuʼë, en ulatjëʼ lidxëʼ bönniʼ nal-la naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Nu bitiʼ run nedaʼ tsözxö́n, ridáʼbagaʼ nedaʼ, en nu bitiʼ rutubi tsözxö́n len nedaʼ, rusilasi nu naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Que lë ni naʼ reaʼ libíʼiliʼ, ca naca yúguʼtë dul-laʼ tun bönachi, en yuguʼ didzaʼ xihuiʼ taʼnná, uniti lahuëʼ Dios léguequi, pero nu bönniʼ innë́ ziʼë queëʼ Dios Böʼ Láʼayi, bitiʼ caʼ uniti lahuëʼ Dios lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Lëscaʼ caní, nu bönniʼ innë́ʼ quiaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, Dios uniti lahuëʼ lëʼ, pero nu bönniʼ innë́ʼ queëʼ Dios Böʼ Láʼayi, bitiʼ caʼ uniti lahuëʼ Dios lëʼ. Bitiʼ uniti lahuëʼ lëʼ dza ni zóaruʼ naʼa, en bitiʼ uniti lahuëʼ lëʼ dza siʼ zaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Gunnë́ʼ caʼ Jesús: —Channö naca dxiʼa tu yaga, cuía le naca dxiʼa, pero channö naca cáʼasö yaga naʼ, cuía caʼ le naca cáʼasö. Caní naca, le ribía tu yaga naca bëʼ yaga naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Libíʼiliʼ nácaliʼ diʼa dza quégacabaʼ bëla síniaʼ. ¿Nacxi gaca güíʼiliʼ dxiʼa didzaʼ, channö cabí nácaliʼ dxiʼa? Ca naca le taʼzáʼ ládxiʼgaca bönachi, lëscaʼ caní tuíʼi didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tu bönniʼ tsahuiʼ ruʼë didzaʼ tsahuiʼ tuʼ yuʼu le naca tsahuiʼ icja ládxiʼdaʼahuëʼ, pero tu bönniʼ huiáʼ döʼ ruʼë didzaʼ bitiʼ naca tsahuiʼ tuʼ yuʼu le cabí naca tsahuiʼ icja ládxiʼdaʼahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Que lë ni naʼ reaʼ libíʼiliʼ, cateʼ idxín dza ichúguiëʼ Dios quégaca bönachi, uchiʼa usörö́ëʼ tu tu bönniʼ ca naca yúguʼtë didzaʼ gulaʼnnazëʼ caʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ca naca didzaʼ ruʼu, uchiʼa usörö́ëʼ liʼ, ateʼ urujuʼ tsahuiʼ o ibáguʼu xíguiaʼ niʼa que didzaʼ naʼ bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Níʼirö buluʼbiʼë didzaʼ yuguʼ bönniʼ yudoʼ fariseo, en yuguʼ bönniʼ yudoʼ tuʼsédinëʼ, en tëʼ Jesús: —Bönniʼ Usedi, rë́ʼënituʼ iléʼetuʼ tu le gunuʼ le gaca bëʼ dë lu noʼo yöl-laʼ unná bëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Bubiʼë didzaʼ Jesús, en rëʼ légaquiëʼ: —Yuguʼ bönniʼ tuáʼ döʼ ni, bitiʼ zoa idú ládxiʼdoʼgaquiëʼ, taʼnábinëʼ nedaʼ gunaʼ tu le gaca bëʼ nu nacaʼ. Bitiʼ bi le gaca bëʼ ilaʼléʼenëʼ, pero le naca bëʼsö naʼ ca guca queëʼ Jonás, bönniʼ bëʼë didzaʼ uláz queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ca naʼ guca queëʼ Jonás naʼ, bugáʼanëʼ lë́ʼëbaʼ tu böla zxön idú tsonna dza tsonna yëla, lëscaʼ caní gaca quiaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, tsonna dza tsonna yëla ugáʼanaʼ zxan yu. ");
INSERT INTO zarNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ilaʼyasëʼ bönniʼ gulaʼcuʼë yödzö Nínive dza ichúguiëʼ Dios quégaca bönachi cateʼ uchiʼa usörö́ëʼ bönachi nacuáʼ dza ni zóaruʼ naʼa, ateʼ le gulunëʼ usubagaʼ bönachi ni xíguiaʼ tuʼ buluʼbíʼi ládxiʼgaquiëʼ bönniʼ Nínive naʼ cateʼ niʼ busiyönnëʼ Jonás légaquiëʼ xtídzëʼë Dios, ateʼ naʼa zoaʼ ni nedaʼ, en nácatëraʼ lo ca Jonás naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Lëscaʼ caní, nigula niʼ gunná béʼenu yödzö dë sacaʼ ga ridödi gubidza beoʼ ziaga chásanu dza ichúguiëʼ Dios quégaca bönachi cateʼ uchiʼa usörö́ëʼ bönachi nacuáʼ dza ni zóaruʼ naʼa, ateʼ le bennu usubagaʼ légaquiëʼ xíguiaʼ, tuʼ birúajnu nigula naʼ ga nácatërö ziʼtuʼ para yö́ninu didzaʼ réajniʼi bëʼë Salomón, ateʼ naʼa zoaʼ ni nedaʼ, en nácatëraʼ lo ca Salomón naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Gunnë́ʼ caʼ Jesús: —Cateʼ rirúaj tu böʼ xihuiʼ yuʼu bönniʼ, ridá gapa nabidxi, riguilaj ga uzíʼ ladxiʼ. Channö cabí idzöli ga naʼ uzíʼ ladxiʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","níʼirö inná: “Huöjaʼ xilatjaʼ ga niʼ birúajaʼ.” Cateʼ udxín ga niʼ birúaj, tsöjxacaʼ bönniʼ naʼ, náquiëʼ ca tu yuʼu nadachiʼ, en nalúaj, en chinabáʼa para nu tsöjsóa niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Níʼirö tseaj, tsöjzxíʼ iaʼgadxi böʼ xihuiʼ nácagacatërö xihuiʼ ca le, ateʼ ilaʼyaza yúguʼtë, en ilaʼcuáʼ icja ládxidaʼahuëʼ bönniʼ naʼ, ateʼ ga údxi huayáliʼtërö ca gaca queëʼ bönniʼ naʼ ca guca queëʼ zíʼalö. Lëscaʼ caní gaca quégaca bönachi tuáʼ döʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Cateʼ niʼ ruíʼilenëʼ Jesús bönachi didzaʼ ni, xinë́ʼë, en yuguʼ bönniʼ bö́chëʼë bilaʼdxinëʼ niʼ. Gulaʼcuʼë lö́ʼalö, en gulë́ʼëniguequinëʼ iluíʼilenëʼ Jesús didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Níʼirö tu bönniʼ busiyönnëʼ Jesús, en rëʼ Lëʼ: —Buyútsöcaʼ, nacuʼë xinóʼo, en yuguʼ bönniʼ bö́chuʼu lö́ʼalö, en të́ʼënnëʼ iluíʼilenëʼ Liʼ didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Bubiʼë didzaʼ Jesús, en rëʼ bönniʼ naʼ busiyönnëʼ Lëʼ caní, rnnëʼ: —¿Nö́ziliʼ nuzxi caz xináʼa, en nupxi caz bönniʼ bö́chaʼa? ");
INSERT INTO zarNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Níʼirö bulí nëʼë, en buluʼe yuguʼ bönniʼ usëda queëʼ, en rnnëʼ: —Buliʼyútsöcaʼ, bönniʼ ni nácagaquiëʼ ca xináʼ cazaʼ, en yuguʼ böchiʼ cazaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nútiʼtës nu run ca rë́ʼëni quézinëʼ Xuzaʼ zoëʼ yehuaʼ yubá, nu ni naca biʼi böchiʼ cazaʼ, en biʼi zan cazaʼ, en xináʼ cazaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Laʼ dza níʼisö birúajëʼ Jesús niuʼ yuʼu, ateʼ yöjchöʼë raʼ nísadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tuʼ bilaʼdxín bönachi zián ga zoëʼ Jesús, gurenëʼ tu lëʼe bárcodoʼ, en guröʼë niʼ, ateʼ bönachi zián naʼ gulaʼcuáʼ luyú bidxi raʼ nísadoʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Níʼirö Jesús bë́ʼlenëʼ légaquiëʼ didzaʼ, zián le busédinëʼ légaquiëʼ. Bucúdzuʼë didzaʼ, rnnëʼ: —Buliʼyútsöcaʼ, birúajëʼ tu bönniʼ guz, söjë́siëʼ xisedoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tsanni niʼ söjë́siëʼ, bal-la xisedoʼ naʼ gulasi raʼ nöza, ateʼ bilaʼdxinbaʼ biguínnidoʼ, en gulë́ʼajbaʼ xisedoʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Gulasi iaʼzícaʼrö xisedoʼ naʼ luyú ga röʼö guiö́j, ga naʼ röʼö látiʼsö yu, ateʼ laʼ gulaʼlentë, tuʼ cabí rö́ʼödaʼ yu niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Níʼirö cateʼ budzáʼa gubidza, lë naʼ bësiëʼ laʼ gulaʼcuáditë, en gulaʼbidxi, tuʼ cabí dë ga ilún luí. ");
INSERT INTO zarNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Gulaʼlén iaʼzícaʼrö xisedoʼ naʼ ga buluʼlén lubá yötsiʼ, ateʼ gulaʼzxö́n lubá yötsiʼ naʼ, en bilaʼröli lë naʼ bësiëʼ, en gulún ditaj le. ");
INSERT INTO zarNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Gulasi iaʼzícaʼrö xisedoʼ naʼ ga naca luyú bëbu, ateʼ buluʼnödzaj. Bal-la lë naʼ bësiëʼ buluʼnödzaj iaʼtú gayuáʼtërö caʼ. Iaʼzícaʼrö buluʼnödzaj iaʼtsónnalalaj caʼ, ateʼ iaʼzícaʼrö buluʼnödzaj iaʼchí uruáʼ caʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nu zoa nagui, en riyöni, ral-laʼ uzë́ nagui. ");
INSERT INTO zarNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Níʼirö bilaʼdxinëʼ bönniʼ usëda queëʼ Jesús ga zoëʼ, en gulaʼnábinëʼ Lëʼ, taʼnnë́ʼ: —¿Bizx que ruíʼilenuʼ bönachi didzaʼ yuguʼ le rucúdzuʼu didzaʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Bubiʼë didzaʼ Jesús, en rëʼ légaquiëʼ: —Dios ruʼë libíʼiliʼ lataj tséajniʼiliʼ le nagachiʼ ca rinná bëʼë Lëʼ yehuaʼ yubá, pero bönachi ni bitiʼ të́ʼëni ilaʼyéajniʼi. ");
INSERT INTO zarNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nu siʼ xtídzëʼë, Dios unödzjëʼ que iaʼlatiʼ, ateʼ gátaʼdaʼarö que, pero nu bitiʼ siʼ le, laʼs dui le dë que udúa. ");
INSERT INTO zarNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Que lë ni naʼ ruíʼilenaʼ légaquiëʼ didzaʼ yuguʼ le rucúdzuʼa didzaʼ, tuʼ tuʼyúëʼ pero bitiʼ taʼléʼenëʼ. Taʼyönnëʼ pero bitiʼ tuʼzë́ nágagaquiëʼ, en bitiʼ taʼyéajniʼinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Caní raca quégaquiëʼ para gaca ca naʼ gunnë́ʼ Isaías, bönniʼ bëʼë didzaʼ uláz queëʼ Dios, gunnë́ʼ: Le nácatë yö́niliʼ pero bitiʼ tséajniʼiliʼ. Uyuliʼ ináʼaliʼ pero bitiʼ iléʼeliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Caní raca tuʼ nazidi ládxiʼdoʼgaca bönniʼ ni, en bitiʼ bi riyaza icja nágagaquiëʼ. Nadzudiʼ guiö́j lógaquiëʼ, para cabí ilaʼléʼenëʼ len guiö́j lógaquiëʼ naʼ. Bitiʼ uluʼzë́ nágagaquiëʼ, en bitiʼ uluʼzéajniʼi ládxiʼgaquiëʼ, en bitiʼ uluʼhuöáquiëʼ quiaʼ nedaʼ para gaca unaʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Naʼa, bicaʼ ba libíʼiliʼ, tuʼ riléʼe guiö́j loliʼ, en riyöni nágaliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Le nácatë reaʼ libíʼiliʼ, zián bönniʼ guluʼë didzaʼ uláz queëʼ Dios en yuguʼ bönniʼ tsahuiʼ gulë́ʼënnëʼ ilaʼléʼenëʼ le riléʼeliʼ libíʼiliʼ pero bitiʼ bilaʼléʼenëʼ le. Gulë́ʼënnëʼ ilaʼyönnëʼ le riyö́niliʼ libíʼiliʼ pero bitiʼ bilaʼyönnëʼ le. ");
INSERT INTO zarNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Gunnë́ʼ caʼ Jesús: —Buliʼzë́ nágaliʼ ca naca le bucúdzuʼa didzaʼ que bönniʼ guz. ");
INSERT INTO zarNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nútiʼtës nu riyöni didzaʼ ca rinná bëʼë Dios yehuaʼ yubá, en bitiʼ réajniʼi le, raca que didzaʼ riyöni nu naʼ ca guca que xisedoʼ naʼ gulasi raʼ nöza. Laʼ zaʼtë tuʼ xihuiʼ, en rugúa didzaʼ naʼ guyúʼu icja ládxiʼdaʼahuëʼ bönniʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Xisedoʼ naʼ gulasi luyú ga röʼö guiö́j ruluíʼi ca raca queëʼ bönniʼ riyönnëʼ didzaʼ naʼ, en laʼ ruzëtë náguiëʼ lu yöl-laʼ rudzeja queëʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","pero ca naʼ bitiʼ ridíaʼ xisedoʼ naʼ tuʼ cabí dë ga gun luí, lëscaʼ caní raca queëʼ bönniʼ ni. Cateʼ idxín tu le usacaʼ ziʼ lëʼ, ateʼ ilaʼbía náʼgaca bönachi lëʼ tuʼ nazíʼ lu nëʼë didzaʼ naʼ, laʼ gácatë chopa ládxëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Xisedoʼ naʼ gulasi ga naʼ buluʼlén lubá yötsiʼ ruluíʼi ca raca queëʼ bönniʼ naʼ riyönnëʼ didzaʼ naʼ, pero ruíʼi ládxëʼë yuguʼ le dë yödzölió ni, ateʼ nazíʼ yëʼë bönniʼ naʼ, tuʼ ruíʼi ládxëʼë yuguʼ yöl-laʼ tsahuiʼ que. Yuguʼ lë ni taʼröli didzaʼ naʼ, en tun ga bitiʼ gun dxin lu icja ládxiʼdaʼahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Xisedoʼ naʼ gulasi luyú bëbu ruluíʼi ca raca queëʼ bönniʼ riyönnëʼ didzaʼ naʼ, en réajniʼinëʼ le, ateʼ run dxin didzaʼ naʼ lu icja ládxiʼdaʼahuëʼ. Nácagaca bal-la bönachi ca xisedoʼ naʼ buluʼnödzaj iaʼtú gayuáʼtërö caʼ. Nácagaca iaʼzícaʼrö bönachi ca xisedoʼ naʼ buluʼnödzaj iaʼtsónnalalaj caʼ, ateʼ nácagaca iaʼzícaʼrö bönachi ca xisedoʼ naʼ buluʼnödzaj iaʼchí uruáʼ caʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iaʼtú le bucúdzuʼë didzaʼ Jesús, ateʼ rëʼ légaquiëʼ: —Ca gaca cate idxín ni le rinná bëʼë Dios yehuaʼ yubá naca ca guca que xisedoʼ dxiʼa le guzëʼ tu bönniʼ ga naca lu xiyúëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tsanni naʼ tasiëʼ bönniʼ nacuʼë lidxëʼ, bidxín tu nu bitiʼ riléʼe xan yuʼu naʼ dxiʼa, ateʼ yöjöza lu xiyúëʼ xisedoʼ guíxiʼdoʼ cané le naláʼ ca naca yöla zxoaʼ xtila, ateʼ böaj xilataj. ");
INSERT INTO zarNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Cateʼ gulén zxoaʼ xtila naʼ, en gurö́ʼö do que, ga naʼ dxía xuiʼi, níʼirö gulaca bëʼ guíxiʼdoʼ cané naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Níʼirö bilaʼdxinëʼ bönniʼ huen dxin ga zoëʼ bönniʼ xan laʼ yëla naʼ, en tëʼ lëʼ: “Xan, channö guzuʼ xisedoʼ dxiʼa lu yu quiuʼ, ¿nacxi guca gulaʼlén guíxiʼdoʼ cané naʼ?” ");
INSERT INTO zarNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Xan yu naʼ gudxëʼ légaquiëʼ, rnnëʼ: “Tu bönniʼ bitiʼ riléʼenëʼ nedaʼ dxiʼa benëʼ caní.” Níʼirö gulaʼnábinëʼ huen dxin queëʼ lëʼ, taʼnnë́ʼ: “¿Ba rë́ʼënuʼ tséajtuʼ tsöjö́lajtuʼ guíxiʼdoʼ cané naʼ?” ");
INSERT INTO zarNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Xángaquiëʼ rëʼ légaquiëʼ: “¡Bitiʼ caʼ! Nadx caʼ cateʼ iládzuʼliʼ guíxiʼdoʼ cané naʼ, iládzuʼlentëliʼ caʼ yöla zxoaʼ xtila. ");
INSERT INTO zarNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Gácarö dxiʼa güíʼiliʼ lataj ilaʼzxö́ngarö tsözxö́n cateʼ idxinrö dza tsöjtúbiruʼ le, ateʼ níʼirö guíaʼ nupa uluʼtubi le: Buliʼtubi zíʼalö guíxiʼdoʼ cané naʼ, en guliʼgugaʼ tsöjxili huéaj para uzéguiʼruʼ le, ateʼ níʼirö utúbiliʼ zxoaʼ xtila lu yuʼu quiaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iaʼtú le bucúdzuʼë didzaʼ Jesús, ateʼ rëʼ légaquiëʼ: —Ca gaca ga idxín le rinná bëʼë Dios yehuaʼ yubá, gaca ca raca que tu xisé mostaza, le guzëʼ tu bönniʼ ga naca lu xiyúëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Le nácatë xisé mostaza naʼ nácatërö cuidiʼ ca yúguʼtë xisedoʼ iaʼzícaʼrö, pero cateʼ chinadúz, rizxö́ntërö ca yúguʼtë guixiʼ cuan, en rizxö́n ca naca tu yaga, ateʼ taʼdxinbaʼ biguínnidoʼ, en tunbaʼ xicáʼagacabaʼ lu niʼa nëʼe. ");
INSERT INTO zarNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iaʼtú le bucúdzuʼë didzaʼ Jesús, ateʼ rëʼ légaquiëʼ: —Ca gaca ga idxín le rinná bëʼë Dios yehuaʼ yubá gaca ca le run cúa zi que yöta xtila, le buchíxinu tu nigula len tsonna libixi yöjza zxoaʼ xtila, ateʼ guyazxa idútë cúa naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yúguʼtë lë ni bucúdzuʼë didzaʼ Jesús, le bë́ʼlenëʼ bönachi nacuáʼ niʼ didzaʼ, en bitiʼ bi didzaʼ bë́ʼlenëʼ légaquiëʼ le cabí bucúdzuʼë didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Caní benëʼ para gaca lë naʼ buzúajëʼ lu guichi tu bönniʼ bëʼë didzaʼ uláz queëʼ Dios, gunnë́ʼ: Guʼa didzaʼ yuguʼ le ucúdzuʼa didzaʼ. Inníaʼ yuguʼ le nagachiʼ cateʼ niʼ gusí lo siʼ gutaʼ yödzölió. ");
INSERT INTO zarNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Níʼirö buzenëʼ Jesús bönachi nacuáʼ niʼ didzaʼ, en gusö́l-lëʼë légaquiëʼ, ateʼ guyuʼë yuʼu. Níʼirö bilaʼdxinëʼ bönniʼ usëda queëʼ ga zoëʼ, en tëʼ Lëʼ: —Gudíxjöiʼi netuʼ le rë́ʼëni inná lë naʼ bucúdzuʼu didzaʼ que guíxiʼdoʼ cané le naláʼ ca naca yöla zxoaʼ xtila. ");
INSERT INTO zarNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Bubiʼë didzaʼ Jesús, ateʼ rëʼ légaquiëʼ: —Bönniʼ razëʼ xisedoʼ dxiʼa nacaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Laʼ yëla naʼ naca yödzölió ni, ateʼ xisedoʼ dxiʼa naʼ tuʼluíʼi ca nácagaca nupa nabábagaca ga rinná bëʼë Dios. Guíxiʼdoʼ cané naʼ le naláʼ ca naca yöla zxoaʼ xtila tuʼluíʼi ca nácagaca nupa néquiguequi que tuʼ xihuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nu naʼ bitiʼ riléʼe dxiʼa xan laʼ yëla naʼ, en yöjöza guíxiʼdoʼ cané naʼ, tuʼ xihuiʼ caz naca. Dza uluʼtubëʼ naʼ ruluíʼi ca gaca dza údxi que yödzölió ni, ateʼ nupa naʼ tuʼtubi nácagaca gubáz láʼayi queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ca naʼ guca, buluʼtubëʼ guíxiʼdoʼ cané naʼ, en buluʼzéguiʼë le lu guíʼ, lëscaʼ caní gaca cateʼ údxi que yödzölió ni. ");
INSERT INTO zarNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nedaʼ, Bönniʼ Guljëʼ Bönachi, isö́l-laʼgacaʼ-nëʼ gubáz láʼayi quiaʼ, ateʼ uluʼbéajëʼ ga rinná bëʼë Dios yúguʼtë nupa tun ga tun dul-laʼ luzë́ʼeguequi, encaʼ nupa tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Yuguʼ gubáz láʼayi naʼ ilaʼguʼë bönniʼ tuáʼ döʼ naʼ lu guíʼ gabila. Niʼ ilaʼbödxëʼ, en uluʼtíl-la láyiʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Níʼirö ilaʼyëpi yösa beníʼ bönachi tsahuiʼ, en ilácagaquiëʼ ca gubidza ga niʼ rinná bëʼë Dios yehuaʼ yubá. Nu zoa nagui, en riyöni ral-laʼ uzë́ nagui. ");
INSERT INTO zarNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Lëscaʼ caní bucúdzuʼë didzaʼ Jesús, rnnëʼ: —Le rinná bëʼë Dios yehuaʼ yubá naca ca tu yöl-laʼ tsahuiʼ nagachiʼ tu laʼ yëla. Cateʼ bidzö́linëʼ tu bönniʼ le, bucáchëʼë le leyúbölö ga naʼ bigachiʼ, ateʼ lu yöl-laʼ rudzeja queëʼ guyijëʼ, yöjë́tiʼë yúguʼtë le dë queëʼ ateʼ gúʼuëʼ laʼ yëla naʼ para gataʼ yöl-laʼ tsahuiʼ naʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Gunnë́ʼ caʼ Jesús: —Ca ral-laʼ së ládxiʼliʼ le rinná bëʼë Dios yehuaʼ yubá naca ca benëʼ tu bönniʼ ráʼuëʼ, en ruútiʼë, en riguiljëʼ bugá nazácaʼgaca. ");
INSERT INTO zarNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Cateʼ bidzö́linëʼ tu bugá le nazácaʼdaʼ, guyijëʼ, yöjë́tiʼë yúguʼtë le dë queëʼ, ateʼ gúʼuëʼ bugá naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Lëscaʼ caní gunnë́ʼ Jesús: —Ca gaca ga ridxín le rinná bëʼë Dios yehuaʼ yubá, gaca ca run tu yöxaj böla le taʼchiljëʼ bönniʼ lu nísadoʼ, le röjxíʼ zián böla izáʼa. ");
INSERT INTO zarNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Cateʼ chibidzáʼ yöxaj naʼ, buluʼbéajëʼ le luyú bidxi raʼ nísadoʼ naʼ, ateʼ gulaʼböʼë niʼ, en gulaʼguʼë-baʼ yuguʼ böla dxiʼa tu lu gaʼböra, pero gulaʼrúʼunëʼ-baʼ yuguʼ böla cáʼasö. ");
INSERT INTO zarNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Lëscaʼ caní gaca cateʼ údxi que yödzölió ni. Ilaʼrúajëʼ gubáz láʼayi queëʼ Dios, ateʼ uluʼbéajëʼ quez yuguʼ bönachi tsahuiʼ, ateʼ uluʼcuítiëʼ légaquiëʼ ladaj bönachi tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","’Níʼirö ilaʼguʼë bönachi tuáʼ döʼ naʼ lu guíʼ gabila. Niʼ ilaʼbödxëʼ, en uluʼtíl-la láyëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Níʼirö Jesús gunábinëʼ yuguʼ bönniʼ usëda queëʼ, rnnëʼ: —¿Ba réajniʼiliʼ yúguʼtë lë ni? Buluʼbiʼë didzaʼ, tëʼ Lëʼ: —Ön, Xan. ");
INSERT INTO zarNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jesús gudxëʼ légaquiëʼ: —Cateʼ tu bönniʼ yudoʼ usedi chinazíʼ lu nëʼë le rinná bëʼë Dios yehuaʼ yubá, náquiëʼ ca tu bönniʼ xan yuʼu, rubéajëʼ ladaj yöl-laʼ tsahuiʼ queëʼ le naca cubi, en le naca gula, le nácagaca tsahuiʼ le ruziʼë xibé. ");
INSERT INTO zarNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Cateʼ budxi bucúdzuʼë Jesús yuguʼ didzaʼ ni, buzë́ʼë niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Cateʼ budxinëʼ ladzëʼ, busédinëʼ bönachi nacuáʼ lu yuʼu ga tuʼdubëʼ bönniʼ judío, en tuʼsëdëʼ queëʼ Dios, ateʼ buluʼbáninë, taʼnnë́ʼ: —¿Gazxi caz guzëdëʼ bönniʼ ni yöl-laʼ réajniʼi ni? ¿Nacxi caz naca, runëʼ yuguʼ yöl-laʼ huáca ni? ");
INSERT INTO zarNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Náquiëʼ bönniʼ ni zxíʼinëʼ bönniʼ gubëdxi yaga, ateʼ xinë́ʼë lënu María. Náquiëʼ bö́chiʼgaquiëʼ Jacobo, en José, en Simón, en Judas. ");
INSERT INTO zarNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Lëscaʼ nigula zanëʼ nacuáʼlennu rëʼu ni. ¿Gazxi caz guzëdëʼ yúguʼtë lë ni? ");
INSERT INTO zarNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Que lë ni naʼ gulaca chopa ládxiʼgaquiëʼ, ateʼ buluʼcáʼanëʼ Lëʼ. Níʼirö Jesús gudxëʼ légaquiëʼ: —Yúguʼtë bönachi tun bal tu bönniʼ ruʼë didzaʼ uláz queëʼ Dios, pero bönachi uládz queëʼ, en bönachi nacuáʼ lidxëʼ bitiʼ tun lëʼ bal. ");
INSERT INTO zarNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Que lë ni naʼ bitiʼ benëʼ Jesús zián yöl-laʼ huáca niʼ, tuʼ cabí taʼyéajlëʼë Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Lu dza niʼ, biyönnëʼ Herodes, bönniʼ rinná bëʼë luyú Galilea, ca nácagaca yuguʼ yöl-laʼ huáca runëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Herodes naʼ gudxëʼ yuguʼ niʼa nëʼë, rnnëʼ: —Bönniʼ naʼ Juan, bönniʼ buquilëʼ bönachi nisa. Chibubanëʼ lu yöl-laʼ guti. Que lë ni naʼ dë lu nëʼë yöl-laʼ huáca zxön naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Caní gunnë́ʼ Herodes tuʼ gusö́l-lëʼë lë cazëʼ bönniʼ gulaʼzönëʼ Juan, en gulúguiʼë lëʼ du guíë, ateʼ gulaʼguʼë lëʼ lidxi guíë tuʼ gúʼuninu Herodías ilunëʼ caní. Herodías naʼ gúcanu nigula queëʼ Felipe, bö́chëʼë Herodes naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Caní benëʼ Herodes, tuʼ gudxëʼ Juan naʼ lëʼ: “Bitiʼ ral-laʼ sóalenuʼ-nu.” ");
INSERT INTO zarNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Que lë ni naʼ gúʼunnëʼ Herodes gútiëʼ Juan, pero gúdxinëʼ ilaʼdáʼbagaʼ bönachi lu yödzö niʼ lëʼ, tuʼ téquiguequi bönachi náquiëʼ Juan naʼ tu bönniʼ ruʼë didzaʼ uláz queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Níʼirö cateʼ guca laní que dza guyéʼenëʼ iz Herodes, birúajbiʼ biʼi nigula queë́nu Herodías naʼ, en buyáʼabiʼ lógaca nupa nacuáʼ laní naʼ, ateʼ guyaza ládxëʼë Herodes le benbiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Guzxíʼ lu nëʼë Herodes, en benëʼ tsutsu xtídzëʼë unödzjëʼ queë́biʼ bítiʼtës bi inábibiʼ lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tuʼ chibusédinu-biʼ zíʼalö xináʼabiʼ, gúdxibiʼ lëʼ: —Benna quiaʼ naʼa icjëʼ Juan, bönniʼ buquilëʼ bönachi nisa. Gulúʼu le tu lu zxigaʼ zxön. ");
INSERT INTO zarNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Níʼirö buíʼinnëʼ Herodes, pero tuʼ chibenëʼ tsutsu xtídzëʼë, en tuʼ bilaʼyöni nupa teʼaj tágulen lëʼ, que lë ni naʼ gunná béʼenëʼ nu tsöjnödzaj icjëʼ Juan naʼ queë́biʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Caní guca, gusö́l-lëʼë nu tsöjríxi yenëʼ Juan ga niʼ yuʼë lidxi guíë. ");
INSERT INTO zarNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bönniʼ naʼ nasö́l-lëʼë buʼë icjëʼ Juan naʼ, zxoa lu zxigaʼ zxön, ateʼ bunödzjëʼ le queë́biʼ biʼi nigula naʼ, ateʼ lëbiʼ buáʼabiʼ le queë́nu xináʼabiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Níʼirö bilaʼdxinëʼ bönniʼ gulaʼdë́ʼë Juan naʼ, ateʼ buluʼúʼë lëʼ, en buluʼcáchëʼë lëʼ. Gudödi niʼ, yöjtíxjöiʼiguequinëʼ Jesús ca gulaca lë ni. ");
INSERT INTO zarNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Cateʼ réquibeʼenëʼ Jesús lë ni, buzë́ʼë niʼ, ateʼ gurenëʼ tu lëʼe bárcodoʼ, en saʼyéajëʼ laʼ queë́zëʼ tu lataj cáʼasö. Cateʼ bilaʼyöni bönachi zéajëʼ niʼ, bilaʼrúaj yuguʼ yödzö niʼ, en yöjaca ga niʼ idxinëʼ Jesús, taʼzëʼe níʼaguequi. ");
INSERT INTO zarNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Cateʼ burúajëʼ Jesús lëʼe barco, biléʼenëʼ nacuáʼ bönachi zián niʼ, ateʼ buéchiʼ ládxëʼë léguequi, en bunëʼ nupa teʼe, nútsaʼgaca ládjaguequi. ");
INSERT INTO zarNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Cateʼ chiridzö́ʼ dza naʼ, bilaʼdxinëʼ yuguʼ bönniʼ usëda queëʼ Jesús ga zoëʼ, en tëʼ Lëʼ: —Chiridzö́ʼ naʼa, ateʼ cáʼasö naca lataj ni. Busöl-laʼ bönachi ni para tsöjaca gapa dë yö́dzödoʼ para gáʼugaca bi ilagu. ");
INSERT INTO zarNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Níʼirö Jesús gudxëʼ légaquiëʼ: —Bitiʼ run bayudxi tsöjáquiëʼ. Buliʼnödzaj libíʼiliʼ le ilahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Níʼirö tëʼ Lëʼ: —Gáyuʼsö yöta xtila dë, en chópasöbaʼ böla dëbaʼ queë́tuʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús rëʼ légaquiëʼ: —Buliʼdödi le lu naʼa. ");
INSERT INTO zarNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Níʼirö Jesús gunná béʼenëʼ bönachi naʼ ilaʼbö́ʼ ga yuʼu dacaʼ. Gudödi naʼ gudélëʼë gayuʼ yöta xtila naʼ, en chópabaʼ böla naʼ, ateʼ guchisa lahuëʼ, ruyúëʼ zacaʼ yehuaʼ yubá. Gudxëʼ Dios: “Xclenuʼ.” Níʼirö buzxuzxjëʼ yöta xtila naʼ, en budödëʼ le lu náʼagaquiëʼ bönniʼ usëda queëʼ, ateʼ légaquiëʼ gulaʼguísiëʼ le lógaca bönachi zián naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Gulahuëʼ yúguʼtëgaquiëʼ, en buluʼhuö́ljanëʼ. Níʼirö buluʼtubëʼ yuguʼ bizxaj nagáʼanagaca, en buluʼlíëʼ chinnu gaʼböra. ");
INSERT INTO zarNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bönniʼ niʼ gulahuëʼ guláquiëʼ idú chi-un gáyuʼë, pero cuntu nu bulaba yuguʼ nigula, en bíʼidoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Níʼirö laʼ bentëʼ Jesús ga gulaʼbenëʼ bönniʼ usëda queëʼ lëʼe bárcodoʼ, en tsöjáquiëʼ, ilaʼnö́ruëʼ lahuëʼ Lëʼ, para ilaʼdödëʼ iaʼtsöláʼa nísadoʼ niʼ, tsanni naʼ uzenëʼ Lëʼ bönachi nacuáʼ niʼ didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Cateʼ chibusö́l-lëʼë Jesús bönachi naʼ, gurenëʼ tu lu guíʼadoʼ ga niʼ yöjsóëʼ tuzëʼ. Niʼ bulidzëʼ Dios. Cateʼ chigul-la, tuzëʼ zoëʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Bárcodoʼ ga naʼ nacuʼë bönniʼ usëda queëʼ ridödi gatsaj láhuiʼlö nísadoʼ naʼ, ateʼ riyasa bárcodoʼ naʼ tuʼ riyasa ridxía nísadoʼ naʼ, ateʼ ruzagaʼ böʼ recja barco naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Gudödi guluhuëla, gubíguiʼë Jesús galaʼ ga naʼ nacuʼë, rizëʼe niʼë lu nísadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Cateʼ yuguʼ bönniʼ usëda queëʼ bilaʼléʼenëʼ Lëʼ, rizëʼe niʼë lu nísadoʼ, gulaʼbö́ʼdëʼë böniga tuʼ tádxinëʼ. Gulaʼbö́dxiʼë, taʼnnë́ʼ: —Tuʼ ridasö naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Níʼirö Jesús laʼ bulidztëʼ légaquiëʼ, rnnëʼ: —Buliʼzxöni ládxiʼliʼ. Nedaʼ ni. Bitiʼ gádxiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Níʼirö bubiʼë didzaʼ Pedro, rëʼ Jesús: —Xan, channö nacuʼ Liʼ, gunná beʼe nedaʼ guídaʼ ga naʼ zuʼ lu nisa. ");
INSERT INTO zarNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesús gudxëʼ lëʼ: —Gudá. Níʼirö bötjëʼ Pedro lëʼe bárcodoʼ naʼ, en guzëʼe niʼë lu nísadoʼ, saʼyéajëʼ ga naʼ zoëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Níʼirö cateʼ biléʼenëʼ Pedro ca böʼ naʼ recja rutá nisa, gúdxinëʼ. Níʼirö gusí lahuëʼ rötjëʼ lu nisa, ateʼ gurö́dxiʼë. Bulidzëʼ Jesús, rnnëʼ: —Xan, busölá nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesús laʼ bulitë nëʼë. Buguélëʼë lëʼ, en rëʼ lëʼ: —Látiʼsö réajlëʼu nedaʼ. ¿Bizx que guca chopa ládxuʼu? ");
INSERT INTO zarNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Cateʼ buluʼbenëʼ lëʼe bárcodoʼ naʼ, gurö́ʼö dxi böʼ naʼ recja. ");
INSERT INTO zarNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Níʼirö bönniʼ nacuʼë lëʼe bárcodoʼ naʼ gulaʼyéaj ládxiʼgaquiëʼ Jesús, taʼnnë́ʼ: —Le nácatë, Zxíʼinëʼ Dios nacuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Cateʼ chigulaʼdödëʼ iaʼtsöláʼa nísadoʼ naʼ, laʼ bilaʼdxintëʼ lu xiyú yödzö Genesaret. ");
INSERT INTO zarNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Cateʼ buluʼúnbëʼë bönniʼ yödzö niʼ Jesús, gulaʼsö́l-lëʼë didzaʼ idútë luyú niʼ, ateʼ dujuáʼgaquiëʼ yúguʼtë nupa teʼe ga naʼ zoëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Gulátaʼyuëʼ lahuëʼ Jesús guʼë légaquiëʼ lataj ilaʼgansëʼ ruíʼi lariʼ nácuëʼ, ateʼ laʼ buluʼhuöácatë yúguʼtë nupa naʼ bilaʼgán lariʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Níʼirö yuguʼ bönniʼ yudoʼ fariseo, en bönniʼ yudoʼ tuʼsédinëʼ, narúajgaquiëʼ Jerusalén, bilaʼdxinëʼ ga zoëʼ Jesús, ateʼ tëʼ Lëʼ: ");
INSERT INTO zarNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Bizx que tunëʼ bönniʼ usëda quiuʼ le ridödi bëʼ ca naca le nulaga loruʼ runruʼ ca gulunëʼ xuz xtóʼoruʼ? Bitiʼ taʼguíbi nëʼë ca naca que yudoʼ cateʼ siʼ ilahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Bubiʼë didzaʼ Jesús, en gunábinëʼ légaquiëʼ, rnnëʼ: —¿Bizx que libíʼiliʼ caʼ rucáʼanaliʼ cáʼasö xibá queëʼ Dios para gunliʼ le nulaga loliʼ runliʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Caní raca, tuʼ gunná béʼenëʼ Dios libíʼiliʼ, gunnë́ʼ: “Ben bal xuz xinoʼo”, en gunnë́ʼ caʼ: “Nu innë́ ziʼ que xuz xinëʼe, tsaz gati nu naʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero libíʼiliʼ rnnaliʼ: “Channö nu guíë xuz xinëʼe: Bitiʼ bi gaca gunnaʼ quiuʼ tuʼ chiguzxíʼ lu naʼa gunnaʼ yúguʼtë queëʼ Dios, ");
INSERT INTO zarNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","bítiʼrö bi run bayudxi gun nu naʼ que xuz xinëʼe.” Caní runliʼ, rucáʼanaliʼ cáʼasö le gunná bëʼë Dios, para gunliʼ le nulaga loliʼ runliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Libíʼiliʼ, bönniʼ ruluíʼisö tsahuiʼ cuinliʼ, idú ca nácaliʼ gudíxjöʼë Isaías, bönniʼ bëʼë didzaʼ uláz queëʼ Dios, gunnë́ʼ: ");
INSERT INTO zarNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Bönniʼ ni, len rúʼagacsëʼ tunëʼ nedaʼ bal, en calëga idú ládxiʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nítisö naca le taʼyéaj ládxiʼgaquiëʼ nedaʼ, tuʼ tuʼsédinëʼ yuguʼ le gulaʼnná bëʼ bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Níʼirö bulidzëʼ Jesús bönachi nacuáʼ niʼ, en rëʼ léguequi: —Buliʼzë́ nágaliʼ le guíaʼ libíʼiliʼ, en guliʼtséajniʼi. ");
INSERT INTO zarNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Calëga le riyaza ruʼë nu bönniʼ run ga bitiʼ náquiëʼ tsahuiʼ lahuëʼ Dios, pero le rirúaj ruʼë, lë ni run ga bitiʼ náquiëʼ tsahuiʼ lahuëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Níʼirö yuguʼ bönniʼ usëda queëʼ Jesús gulaʼbíguiʼë ga zoëʼ, en tëʼ Lëʼ: —¿Naruʼ nö́ztsenuʼ gulaʼlenëʼ yuguʼ bönniʼ yudoʼ fariseo cateʼ bilaʼyönnëʼ didzaʼ ni bëʼu? ");
INSERT INTO zarNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Níʼirö bubiʼë didzaʼ Jesús, en rëʼ légaquiëʼ: —Yúguʼtë le nadúz, le cabí guzëʼ Xuzaʼ zoëʼ yehuaʼ yubá, huadúljagaca idú luí. ");
INSERT INTO zarNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Buliʼcáʼana légaquiëʼ. Chinachúl-la lógaquiëʼ, en taʼchë́ʼë nupa nachul-la lógaca. Channö tu bönniʼ lo chul-la ichë́ʼë iaʼtúëʼ bönniʼ lo chul-la, iropëʼ ilaʼbixëʼ tu lu yeru. ");
INSERT INTO zarNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Níʼirö bubiʼë didzaʼ Pedro, en rëʼ Jesús: —Buzéajniʼi netuʼ lë ni rucúdzuʼu didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús rëʼ légaquiëʼ: —¿Naruʼ cabí réajniʼitseliʼ caʼ libíʼiliʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Naruʼ cabí réajniʼitseliʼ riyaza lë́ʼëruʼ yúguʼtë le riyaza ruáʼaruʼ, ateʼ rurúaj lë́ʼëruʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Naʼa, le rirúaj rúaʼaliʼ, lu icja ládxiʼdoʼoliʼ zaʼ, ateʼ lë ni run ga bitiʼ nácaliʼ tsahuiʼ lahuëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Caní raca, tuʼ taʼlén lu icja ládxiʼdoʼoliʼ yuguʼ le rizáʼ ládxiʼliʼ le ruáʼ döʼ, le ilún ga gútiliʼ bönachi, en le ilún ga quítsjaliʼ xibá que yöl-laʼ nutsaga naʼ, en le ruáʼ döʼ runliʼ, en yuguʼ le rizë́ ládxiʼliʼ cuanliʼ, en yuguʼ le rinnëliʼ que luzáʼaliʼ le cabí nácate, en yuguʼ le rinnë́ xíhuiʼliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yuguʼ le caní tun ga bitiʼ náquiëʼ tu bönniʼ tsahuiʼ lahuëʼ Dios, pero channö cabí nayari nëʼë ca naca que yudoʼ cateʼ bi gahuëʼ, bitiʼ gun ga bitiʼ náquiëʼ tsahuiʼ lahuëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Níʼirö buzë́ʼë Jesús niʼ, en guyéajëʼ lu xiyú yödzö Tiro, en yödzö Sidón. ");
INSERT INTO zarNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tu nigula nabábanu luyú Canaán birúajnu yödzö niʼ, ateʼ bë́ʼënu zidzaj didzaʼ, rënu Jesús: —Xan, zxíʼini xiʼsóëʼ David, buéchiʼ ladxiʼ nedaʼ. Biʼi nigúladoʼ quiaʼ riguíʼi rizácaʼdaʼabiʼ tuʼ yuʼu böʼ xihuiʼ lëbiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Bitiʼ bi didzaʼ bubiʼë Jesús. Níʼirö gulaʼbíguiʼë bönniʼ usëda queëʼ ga zoëʼ, ateʼ gulë́ʼ Lëʼ, taʼnnë́ʼ: —Busö́l-laʼ-nu, tuʼ záʼanu cúdzuʼruʼ ribö́dxiʼanu. ");
INSERT INTO zarNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Níʼirö bubiʼë didzaʼ Jesús, ateʼ rëʼë-nu: —Dios nasö́l-lëʼë nedaʼ gácalenaʼ bönachi Israel, nupa nácagaca ca böʼcuʼ zxílaʼdoʼ nanítigacabaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Níʼirö gubígaʼnu nigula naʼ ga zoëʼ Jesús, en guyéaj ládxiʼnu Lëʼ, ateʼ rënu Lëʼ: —Xan, gúcalen nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Bubiʼë didzaʼ Jesús, rnnëʼ: —Bitiʼ naca dxiʼa ugúaruʼ yöta quégacabiʼ bíʼidoʼ, en chúʼunaruʼ le lógacabaʼ bö́ʼcuʼdoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Níʼirö nigula naʼ rënu Jesús, rnnanu: —Ön, Xan, pero tágubaʼ bö́ʼcuʼdoʼ naʼ le bizxaj tuʼhuö́xaj ga tagu xángacabaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Níʼirö bubiʼë didzaʼ Jesús, rnnëʼ: —Nigúladoʼ. Idú naca ca réajlëʼu nedaʼ. Gaca quiuʼ ca rë́ʼënnuʼ. Laʼ níʼisö böácatëbiʼ biʼi nigúladoʼ queë́nu. ");
INSERT INTO zarNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Níʼirö buzë́ʼë Jesús niʼ, en gudödëʼ ga naca raʼ nísadoʼ que Galilea. Gurenëʼ tu lu guíʼadoʼ, ateʼ guröʼë niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bönachi zián dujuáʼgaquiëʼ nupa bitiʼ guca ilaʼzáʼ, en nupa nachul-la guiö́j lógaca, en nupa bitiʼ guca ilaʼnnë́, en nupa narugu niʼa në́ʼeguequi, en iaʼzícaʼrö zián nupa teʼe, ateʼ gulaʼguíxaj léguequi xiniʼë Jesús, ateʼ Lëʼ bunëʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Buluʼbani bönachi niʼ ca naca le benëʼ Jesús, tuʼ bilaʼléʼe tuʼnnë́ nupa bitiʼ guca ilaʼnnë́, ateʼ nuhuöácagaca nupa gurugu niʼa në́ʼeguequi, ateʼ tuʼzáʼ nupa bitiʼ guca ilaʼzáʼ, ateʼ tuʼléʼe nupa guchul-la lógaca. Que lë ni naʼ gulaʼguʼë yöl-laʼ ba Dios quégaca bönachi Israel. ");
INSERT INTO zarNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Níʼirö Jesús bulidzëʼ yuguʼ bönniʼ usëda queëʼ, en rëʼ légaquiëʼ: —Ruhuechiʼ ládxaʼa bönachi zián ni, tuʼ chiguca tsonna dza záʼlenguequi nedaʼ, en bitiʼ bi dë le ilagu. Bitiʼ rë́ʼëndaʼ usö́l-laʼgacaʼ-nëʼ tsöjhuö́ajgaquiëʼ lídxigaquiëʼ taʼdunsëʼ caʼ, nadxi caʼ udú ládxiʼgaquiëʼ laʼ nöza. ");
INSERT INTO zarNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Níʼirö yuguʼ bönniʼ usëda queëʼ tëʼ Lëʼ, taʼnnë́ʼ: —¿Gazxi caz idzö́lituʼ yöta xtila zián lu lataj cáʼasö ni, le ugágutuʼ bönachi zián ni? ");
INSERT INTO zarNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Gunábinëʼ Jesús légaquiëʼ, rnnëʼ: —¿Bal-laxi yöta xtila dë queë́liʼ? Buluʼbiʼë didzaʼ, taʼnnë́ʼ: —Gadxi, ateʼ nabábasöbaʼ böla cuidiʼ dëbaʼ queë́tuʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Níʼirö Jesús gunná béʼenëʼ bönachi zián naʼ ilaʼbö́ʼ lu yu. ");
INSERT INTO zarNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Gudélëʼë gadxi yöta xtila naʼ, en yuguʼ böla naʼ, ateʼ gudxëʼ Dios: “Xclenuʼ.” Níʼirö buzxuzxjëʼ iroptë naʼ, en bunödzjëʼ quégaquiëʼ bönniʼ usëda queëʼ, ateʼ légaquiëʼ gulaʼguísiëʼ le lógaca bönachi zián naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Gulahuëʼ yúguʼtëʼ, en buluʼhuö́ljanëʼ. Gudödi niʼ buluʼtubëʼ le bizxaj nagáʼanagaca, ateʼ buluʼlíëʼ gadxi gaʼböra. ");
INSERT INTO zarNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Yuguʼ bönniʼ naʼ gulahuëʼ nácagaquiëʼ choáʼ gáyuʼë, pero cuntu nu bulaba yuguʼ nigula, en bíʼidoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Níʼirö busöl-lëʼë Jesús bönachi naʼ tsöjhuö́ajgaquiëʼ lídxigaquiëʼ, ateʼ gurenëʼ lëʼe bárcodoʼ niʼ, en saʼyéajëʼ lu xiyú yödzö Magdala. ");
INSERT INTO zarNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Níʼirö yuguʼ bönniʼ yudoʼ fariseo len yuguʼ bönniʼ yudoʼ saduceo bilaʼdxinëʼ ga zoëʼ Jesús para ilaʼzíʼ bëʼë Lëʼ, ateʼ gulaʼnábinëʼ Lëʼ gunëʼ tu le gaca bëʼ ga zaʼ yöl-laʼ unná bëʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Bubiʼë didzaʼ Jesús, en rëʼ légaquiëʼ: —Cateʼ ridzö́ʼ, rnnaliʼ caní: “Gun dxiʼa cuxö́, tuʼ röʼö böaj xiná lúzxiba.” ");
INSERT INTO zarNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Cateʼ naca zíladoʼ, rnnaliʼ caní: “Bitiʼ gun dxiʼa naʼa dza tuʼ röʼö böaj xiná, en ruchul-la lúzxiba.” Libíʼiliʼ, bönniʼ ruluíʼisö tsahuiʼ cuinliʼ. Raca innë́ yaʼaliʼ naca gun lúzxiba, pero bitiʼ gaca tséajniʼiliʼ le tuʼsedi le taca dza ni zóaruʼ naʼa. ");
INSERT INTO zarNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yuguʼ bönachi tuáʼ döʼ ni, en bitiʼ zoa idú ládxiʼgaca taʼnábini nedaʼ gunaʼ tu le gaca bëʼ Nu nacaʼ, pero bitiʼ bi le gaca bëʼ ilaʼléʼenëʼ. Ilaʼléʼesinëʼ lë naʼ guca bëʼ ca guca queëʼ Jonás, bönniʼ bëʼë didzaʼ uláz queëʼ Dios. Níʼirö Jesús bucáʼanëʼ légaquiëʼ, söhuö́jëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Cateʼ bilaʼdxinëʼ iaʼtsöláʼa nísadoʼ niʼ, guléquibeʼenëʼ bönniʼ usëda queëʼ Jesús gulál-la ládxiʼgaquiëʼ iluʼë le ilahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Níʼirö Jesús gudxëʼ légaquiëʼ: —Buliʼyútsöcaʼ. Guliʼgún chiʼi cuinliʼ que le naca ca cúa zi que yöta xtila quégaquiëʼ bönniʼ yudoʼ fariseo, en quégaquiëʼ bönniʼ yudoʼ saduceo. ");
INSERT INTO zarNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Níʼirö laʼ légacasëʼ gulún xtídzaʼgaquiëʼ bönniʼ usëda queëʼ, taʼnnë́ʼ: —Rnnëʼ caní tuʼ cabí nuáʼaruʼ yöta xtila. ");
INSERT INTO zarNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Réquibeʼenëʼ Jesús lë ni, ateʼ rëʼ légaquiëʼ: —¿Bizx que run xtídzaʼliʼ laʼ libíʼisiliʼ tuʼ cabí nuáʼaliʼ yöta xtila? Látiʼdoʼos réajlëʼëliʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Naruʼ cabí réajniʼitseliʼ, en bitiʼ röjnétseliʼ ca guca quégaca gayuʼ yöta xtila niʼ, lë naʼ gulahuëʼ chi-un gáyuʼë bönniʼ, ateʼ tsca xö gaʼböra butúbiliʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Naruʼ cabí röjnétseliʼ caʼ ca guca quégaca gadxi yöta xtila niʼ, lë naʼ gulahuëʼ choáʼ gáyuʼë bönniʼ, ateʼ tsca xö gaʼböra butúbiliʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Naruʼ cabí réajniʼiliʼ? Bitiʼ bëʼa didzaʼ que yöta xtila cateʼ gudxaʼ libíʼiliʼ gun chiʼi cuinliʼ que le naca ca cúa zi que yöta xtila quégaquiëʼ bönniʼ yudoʼ fariseo, en quégaquiëʼ bönniʼ yudoʼ saduceo. ");
INSERT INTO zarNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Níʼirö gulaʼyéajniʼinëʼ bitiʼ gudxëʼ Jesús légaquiëʼ ilún chiʼi cuíngaquiëʼ que cúa zi que yöta xtila, pero ral-laʼ ilún chiʼi cuíngaquiëʼ que le tuʼsédinëʼ yuguʼ bönniʼ yudoʼ fariseo, en yuguʼ bönniʼ yudoʼ saduceo. ");
INSERT INTO zarNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cateʼ bidxinëʼ Jesús lu xiyú yödzö Cesarea, ga naʼ rinná bëʼë Filipo, gunábinëʼ yuguʼ bönniʼ usëda queëʼ, rnnëʼ: —¿Bizxi taʼnná bönachi nu nacaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi? ");
INSERT INTO zarNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Buluʼbiʼë didzaʼ, taʼnnë́ʼ: —Bal-lëʼ taʼnnë́ʼ: “Juan nacuʼ, bönniʼ niʼ buquilëʼ bönachi nisa.” Iaʼzícaʼrëʼ taʼnnë́ʼ: “Elías nacuʼ, bönniʼ niʼ bëʼë didzaʼ uláz queëʼ Dios dza niʼte.” Iaʼzícaʼrëʼ taʼnnë́ʼ: “Jeremías nacuʼ, o iaʼtúëʼ bönniʼ bëʼë didzaʼ uláz queëʼ Dios.” ");
INSERT INTO zarNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Níʼirö Jesús gudxëʼ légaquiëʼ: —Naruʼ libíʼiliʼ, ¿nuzxi rnnaliʼ nacaʼ nedaʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Bubiʼë didzaʼ Simón Pedro, en rëʼ Lëʼ: —Liʼ nacuʼ Cristo, Zxíʼinëʼ Dios ban. ");
INSERT INTO zarNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Bubiʼë didzaʼ Jesús, rëʼ lëʼ: —Bicaʼ xibóʼ liʼ, Simón, zxíʼinëʼ Jonás, tuʼ cabí buluíʼinëʼ nu bönniʼ liʼ lë ni. Xuzaʼ zoëʼ yehuaʼ yubá buluíʼinëʼ liʼ lë ni. ");
INSERT INTO zarNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nedaʼ reaʼ liʼ, liʼ nacuʼ Pedro, ateʼ lu guiö́j ni ucuáʼa nupa uluʼdubi quiaʼ, ateʼ yöl-laʼ unná bëʼ que tuʼ xihuiʼ bitiʼ sequiʼ uzagaʼ xinö́zgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Gunnaʼ quiuʼ yuguʼ zxíʼini guíë que lataj ga rinná bëʼ Nu zoa yehuaʼ yubá. Le inná bëʼu luyú ni, chigunná bëʼ caʼ Nu naʼ zoa yehuaʼ yubá, ateʼ le guʼu lataj gaca luyú ni, chibë́ʼ lataj gaca lë naʼ Nu naʼ zoa yehuaʼ yubá niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Níʼirö Jesús gunná béʼenëʼ yuguʼ bönniʼ usëda queëʼ cuntu nu ilë́ʼë náquiëʼ Lëʼ Cristo. ");
INSERT INTO zarNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Laʼ dza níʼisö gusí lahuëʼ Jesús riguíxjöiʼinëʼ yuguʼ bönniʼ usëda queëʼ run bayudxi tsejëʼ Jerusalén, ga niʼ yuguʼ bixúz unná bëʼ en bönniʼ gula tuʼzéajniʼinëʼ, en bönniʼ yudoʼ tuʼsédinëʼ uluʼsacaʼ ziʼë Lëʼ, ateʼ níʼirö ilútiëʼ Lëʼ, pero cateʼ gaca tsonna dza ubanëʼ lu yöl-laʼ guti. ");
INSERT INTO zarNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Níʼirö Pedro guchë́ʼë Jesús quez, en gusí lahuëʼ ridil-lëʼ Lëʼ didzaʼ, rnnëʼ: —Xan, bitiʼ guʼë Dios lataj. Bitiʼ caʼ gaca quiuʼ ca rnnoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Níʼirö buécjëʼ Jesús, en rëʼ Pedro: —Gucuita ga zoaʼ. Runuʼ ca run Satanás, tuʼ xihuiʼ. Runuʼ ga gaca chopa ládxaʼa tuʼ cabí naca le rizáʼ ládxuʼu liʼ ca rizáʼ ládxëʼë Dios, pero ca taʼzaʼsö ládxiʼgaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Níʼirö Jesús gudxëʼ yuguʼ bönniʼ usëda queëʼ, rnnëʼ: —Channö zoëʼ tu bönniʼ rë́ʼënëʼ tëʼë nedaʼ, ral-laʼ uzóëʼ tsöláʼalö yuguʼ le rë́ʼëni quézinëʼ, en gáquiëʼ ca tu bönniʼ saʼyéajëʼ zeajtë́ʼë lëʼe yaga cruz, ateʼ níʼirö gaca tëʼë nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nu bönniʼ guë́ʼënnëʼ gun chiʼë yöl-laʼ naʼbán queëʼ, unítiëʼ le, pero bönniʼ unítiëʼ yöl-laʼ naʼbán queëʼ tuʼ dëʼë nedaʼ, gataʼ yöl-laʼ naʼbán idú queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Naruʼ uziʼtsëʼ xibé tu bönniʼ channö utubëʼ yúguʼtë le dë yödzölió ni pero unítiëʼ yöl-laʼ naʼbán idú queëʼ? Bitiʼ bi gaca unödzjëʼ tu bönniʼ para gataʼ yöl-laʼ naʼbán idú queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Caní rnníaʼ, tuʼ huödaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, en idzaga yöl-laʼ unná bëʼ queëʼ Xuzaʼ Dios nedaʼ, ateʼ idzágagaquiëʼ gubáz láʼayi quiaʼ nedaʼ. Níʼirö ubiʼa que queë bönachi tsca naca le núngaca. ");
INSERT INTO zarNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Le nácatë reaʼ libíʼiliʼ: “Bitiʼ caʼ ilátigaca bal-la nupa nacuáʼ ni cateʼ ilaʼléʼerö idinná bëʼa nedaʼ, Bönniʼ Guljëʼ Bönachi.” ");
INSERT INTO zarNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Gudödi xopa dza, Jesús gudélëʼë Pedro len Jacobo, en Juan, bö́chëʼë Jacobo naʼ, en guchë́ʼë légaquiëʼ, ateʼ yöjáquiëʼ quez tu lu guíʼa sibi. ");
INSERT INTO zarNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Niʼ bidzáʼ ca naláʼ lahuëʼ Jesús lógaquiëʼ. Guyëpi yösa beníʼ lahuëʼ Jesús ca ruzeníʼ gubidza, ateʼ lariʼ nácuëʼ böáca chiguíchidoʼos ca beníʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Níʼirö bilaʼléʼenëʼ bönniʼ usëda queëʼ buluíʼi lógaquiëʼ Moisés, en Elías, ateʼ tuíʼilenëʼ Jesús didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Níʼirö Pedro rëʼ Jesús: —Xan, naca dxiʼa zóaruʼ ni. Channö rë́ʼënuʼ, gunaʼ ni tsonna yuʼu lágaʼdoʼ, tu quiuʼ, iaʼtú queëʼ Moisés, en iaʼtú queëʼ Elías. ");
INSERT INTO zarNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tsanni niʼ ruʼë Pedro didzaʼ ni, laʼ gurö́ʼötë tu böaj beníʼ le guzxóa légaquiëʼ, ateʼ lu böaj naʼ biyö́n chiʼi nu rnna: —Bönniʼ ni Zxíʼini cazaʼ. Nadxíʼidaʼ-nëʼ, en raza ládxaʼa Lëʼ. Buliʼzë́ nágaliʼ didzaʼ guʼë. ");
INSERT INTO zarNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Cateʼ bilaʼyönnëʼ bönniʼ usëda queëʼ chiʼi naʼ, gulaʼdzöʼë gusurúʼalö, en guladxi bilaʼdzö́binëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Níʼirö gubíguiʼë Jesús ga naʼ nacuʼë, ateʼ gudanëʼ légaquiëʼ, rnnëʼ: —Guliʼchasa. Bitiʼ gádxiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Cateʼ gulaʼchisa lógaquiëʼ, en buluʼyúëʼ, cúnturö nu bilaʼléʼenëʼ, pero tuzëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Cateʼ niʼ tuʼdínniëʼ lu guíʼa naʼ, Jesús gunná béʼenëʼ légaquiëʼ, rnnëʼ: —Cuntu nu guië́liʼ ca guca lë ni biléʼeliʼ cateʼ ubanraʼ lu yöl-laʼ guti nedaʼ, Bönniʼ Guljëʼ Bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Níʼirö yuguʼ bönniʼ usëda queëʼ gulaʼnábinëʼ Lëʼ, taʼnnë́ʼ: —¿Bizx que taʼnnë́ʼ bönniʼ yudoʼ usëdi run bayudxi uluíʼi lahuëʼ Elías zíʼalö ca uluíʼi lahuëʼ Cristo? ");
INSERT INTO zarNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Bubiʼë didzaʼ Jesús, rëʼ légaquiëʼ: —Le nácatë uluíʼi lo cazëʼ zíʼalö Elías, en ucáʼanëʼ tsahuiʼ yúguʼtë. ");
INSERT INTO zarNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nedaʼ reaʼ libíʼiliʼ: “Chibuluíʼi lahuëʼ Elías naʼ, pero bitiʼ buluʼúnbëʼë lëʼ, ateʼ yúguʼtë ca rnnasö quégaquiëʼ gulunëʼ queëʼ.” Lëscaʼ caní ilunëʼ quiaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, uluʼsacaʼ ziʼë nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Níʼirö gulaʼyéajniʼinëʼ bönniʼ usëda queëʼ, bë́ʼlenëʼ Jesús légaquiëʼ didzaʼ ca guca queëʼ Juan, bönniʼ naʼ buquilëʼ bönachi nisa. ");
INSERT INTO zarNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Cateʼ bilaʼdxinëʼ ga naʼ nacuáʼ bönachi zián, gubíguiʼë tu bönniʼ ga zoëʼ Jesús, ateʼ buzóa zxibëʼ lahuëʼ Lëʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","en rëʼ Lëʼ: —Xan, buéchiʼ ladxiʼ-biʼ biʼi bö́nniʼdoʼ quiaʼ, tuʼ réʼebiʼ xjoteʼ, en riguíʼi rizácaʼdaʼabiʼ, ateʼ zián luzuí ridzö́ʼöbiʼ lu guíʼ o lu nisa. ");
INSERT INTO zarNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Chidiguáʼa-biʼ lógaquiëʼ bönniʼ usëda quiuʼ pero bitiʼ guca uluʼúnëʼ-biʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Bubiʼë didzaʼ Jesús, rnnëʼ: —Libiʼiliʼ, bönachi cabí réajlëʼëliʼ, en bitiʼ nácaliʼ tsahuiʼ. ¿Gácaʼxte caz ral-laʼ sóalenaʼ libíʼiliʼ para tséajlëʼëliʼ nedaʼ? ¿Gácaʼxte caz ral-laʼ guáʼ ilenaʼ queë́liʼ? Guliʼdiguáʼ-biʼ quiaʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Níʼirö Jesús buzenëʼ le bach böʼ xihuiʼ naʼ yuʼu lëbiʼ, ateʼ laʼ burúajtë lëbiʼ, ateʼ laʼ náʼasö böácatëbiʼ biʼi bö́nniʼdoʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Níʼirö, yuguʼ bönniʼ usëda queëʼ Jesús gulaʼbiguëʼë quez ga zoëʼ, ateʼ gulaʼnábinëʼ Lëʼ, taʼnnë́ʼ: —¿Bizx que naʼ bitiʼ guca ubéajtuʼ netuʼ böʼ xihuiʼ naʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús rëʼ légaquiëʼ: —Bitiʼ guzxéquiʼliʼ tuʼ cabí réajlëʼëliʼ Dios idú ládxiʼliʼ. Le nácatë reaʼ libíʼiliʼ, sal-laʼ cuídiʼsö naca yöl-laʼ réajlëʼ queë́liʼ Dios, nácatë ca tu xisedoʼ mostaza, huáca guië́liʼ guíʼadoʼ ni: “Gucuíta ni, en yöjsóa níʼilö”, ateʼ laʼ icuítatë guíʼadoʼ naʼ. Bitiʼ bi zoa le cabí gaca gunliʼ channö réajlëʼëliʼ Dios idú ládxiʼliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Tu böʼ xihuiʼ caní gácasö ubéajliʼ channö ulídzaliʼ-nëʼ Dios, en gunliʼ gubasa. ");
INSERT INTO zarNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tsanni niʼ taʼdë́ʼ luyú Galilea, Jesús gudxëʼ yuguʼ bönniʼ usëda queëʼ, rnnëʼ: —Zoa nu udödi nedaʼ, Bönniʼ Guljëʼ Bönachi, lu náʼagaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ilútiëʼ nedaʼ, pero cateʼ gaca tsonna dza Dios usubanëʼ nedaʼ. Níʼirö buluʼhuíʼinnëʼ bönniʼ usëda queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Cateʼ buluʼdxinëʼ Jesús, en yuguʼ bönniʼ usëda queëʼ lu yödzö Capernaum, bilaʼdxinëʼ yuguʼ bönniʼ tuʼquizxjëʼ bönachi lázagaca que yudoʼ ga zoëʼ Pedro, ateʼ tëʼ lëʼ: —¿Naruʼ cabí quizxaj lazëʼ que yudoʼ bönniʼ rusédinëʼ libíʼiliʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Bubiʼë didzaʼ Pedro, rnnëʼ: —Ön, huaguizxjëʼ. Cateʼ buáziëʼ Pedro lu yuʼu, Jesús laʼ bulidztëʼ lëʼ, en rëʼ lëʼ: —¿Nacxi rusacaʼ quiuʼ, Simón? Bönniʼ taʼnná bëʼë luyú ni, ¿nupxi tuʼquizxjëʼ le riguizxaj laz, en lazxaj que yu? ¿Naruʼ tuʼquizxjëʼ bönachi uládz quégaquiëʼ o bönachi izáʼa? ");
INSERT INTO zarNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Bubiʼë didzaʼ Pedro, rëʼ Lëʼ: —Bönachi izáʼa tuʼquizxjëʼ. Níʼirö Jesús rëʼ lëʼ: —Que lë ni naʼ, bitiʼ run bayudxi quizxaj lazaʼ que yudoʼ tuʼ nacaʼ Zxíʼinëʼ Dios ca naʼ bitiʼ bi taʼguízxaj nupa nácagaca bönachi uládz queëʼ bönniʼ naʼ ruquízxjëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Naʼa, para cuntu nu gun leruʼ, guyéaj raʼ nísadoʼ, yöjzalaj lu nisa le rizö́ninuʼ-baʼ böla, ateʼ böla cuejuʼ-baʼ zíʼalö, guzxíʼi-baʼ. Cateʼ isaljuʼ ruáʼabaʼ, niʼ idzö́linuʼ tu dumí lásidoʼ. Guzxíʼi le, ateʼ gudizxaj lazaʼ, en lazuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Laʼ dza níʼisö bilaʼdxinëʼ bönniʼ usëda queëʼ Jesús ga zoëʼ, ateʼ gulaʼnábinëʼ Lëʼ, taʼnnë́ʼ: —¿Núzxilëʼ bönniʼ ni gáquiëʼ lo ga rinná bëʼë Dios yehuaʼ yubá? ");
INSERT INTO zarNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Bulidzëʼ-biʼ Jesús tubiʼ biʼi bö́nniʼdoʼ, ateʼ buzóëʼ-biʼ gatsaj láhuiʼlö ga naʼ nacuʼë. ");
INSERT INTO zarNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Níʼirö rëʼ légaquiëʼ: —Le nácatë reaʼ libíʼiliʼ, channö cabí huöácaliʼ ca zeaj nácabiʼ bíʼidoʼ, bitiʼ caʼ tsúʼuliʼ ga niʼ rinná bëʼë Dios yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Que lë ni naʼ, nútiʼtës nu gaca nöxaj ladxiʼ, en huöáca ca nácabiʼ bíʼidoʼ ni, nu ni gaca lo ga niʼ rinná bëʼë Dios yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nútiʼtës nu gun bal tubiʼ bíʼidoʼ caní tuʼ néquibiʼ quiaʼ, nedaʼ caz gun bal. ");
INSERT INTO zarNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Gunnë́ʼ caʼ Jesús: —Nu gun ga gunbiʼ dul-laʼ tubiʼ bíʼidoʼ caní réajlëʼëbiʼ quiaʼ, gácarö dxiʼa queëʼ bönniʼ naʼ laʼtuʼ ugalëʼë guiö́j riyë́tuni yaga yenëʼ, ateʼ tsöjsuladzuʼ cuinëʼ lu nísadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Bicaʼ bayechiʼ bönachi yödzölió ni tun ga gun dul-laʼ luzë́ʼeguequi. Nacuáʼticaʼsö le tun ga nu gun dul-laʼ, pero bicaʼ bayechiʼ nu run ga nu gun dul-laʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Que lë ni naʼ, channö gun noʼo o niʼu ga gunuʼ dul-laʼ, guchugu le, en gurúʼuna le. Gácarö dxiʼa quiuʼ tsöjtsáziuʼ ga suʼ ibanuʼ bitiʼ rizóʼo o narugu niʼa noʼo, en calëga nacuáʼ chopa noʼo, en chopa niʼu ateʼ tsöjtsáziuʼ lu guíʼ gabila le catu caz ulu. ");
INSERT INTO zarNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Channö gun guiö́j loʼ ga gunuʼ dul-laʼ, guléaj le, en gurúʼuna le. Gácarö dxiʼa quiuʼ tsöjtsáziuʼ ga suʼ ibanuʼ, zoa tuz guiö́j loʼ, en calëga nacuáʼ chopa guiö́j loʼ, ateʼ tsöjtsáziuʼ lu guíʼ gabila. ");
INSERT INTO zarNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Gunnë́ʼ caʼ Jesús: —Guliʼgún chiʼi cuinliʼ para cabí uzóaliʼ-biʼ tsöláʼalö tubiʼ bíʼidoʼ caní. Nedaʼ reaʼ libíʼiliʼ, gubáz láʼayi tapa chiʼë légacabiʼ nacuáʼticaʼsëʼ lahuëʼ Xuzaʼ zoëʼ yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Bidaʼ ni nedaʼ, Bönniʼ Guljëʼ Bönachi, para usöláʼ nu ni naniti. ");
INSERT INTO zarNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Nacxi rusácaʼliʼ queë́liʼ? Tu bönniʼ, nacuáʼabaʼ tu gayuáʼ böʼcuʼ zxilaʼ queëʼ, channö nítibaʼ tubaʼ, ¿naruʼ cabí ucáʼanëʼ-baʼ tápalalaj yuʼ chë́nnabaʼ naʼ, ateʼ tsejëʼ gapa naca lu guíʼa, para tsöjtiljëʼ-baʼ böʼcuʼ zxílaʼdoʼ naʼ nanítibaʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Channö udzö́linëʼ-baʼ, le nácatë reaʼ libíʼiliʼ, udzéjarönëʼ niʼa queë́baʼ böʼcuʼ zxílaʼdoʼ naʼ ca gunëʼ quégacabaʼ iaʼtápalalaj yuʼ chë́nnabaʼ niʼ bitiʼ gulaʼnítibaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Lëscaʼ caní, Xúziruʼ Dios, zoëʼ yehuaʼ yubá, bitiʼ rë́ʼënëʼ nítibiʼ tubiʼ bíʼidoʼ caní. ");
INSERT INTO zarNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Gunnë́ʼ caʼ Jesús: —Channö böchiʼ luzóʼo guáʼ döʼ quiuʼ, guyéajtsöcaʼ, en yöjcáʼanalenëʼ tsahuiʼ laʼ libíʼisiliʼ. Channö uzë́ náguiëʼ liʼ, chibuguéluʼu böchiʼ luzóʼo. ");
INSERT INTO zarNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Channö cabí uzë́ náguiëʼ xtídzuʼu, guchë́ʼë iaʼtúëʼ o iaʼchopëʼ bönniʼ para urúaj li xtídzuʼu lógaquiëʼ chopa tsonnëʼ bönniʼ, nupa gaca ilún ba nalí que xtídzaʼliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Channö cabí uzë́ náguiëʼ xtídzaʼgaquiëʼ, gudxi caʼ bönachi tuʼdubi tuʼsëdi queëʼ Dios, en channö cabí uzë́ náguiëʼ xtídzaʼgaca bönachi naʼ, níʼirö bönniʼ naʼ gáquiëʼ quiuʼ ca tu bönniʼ bitiʼ réajlëʼë Dios, en ca tu bönniʼ ruquízxjëʼ uláz que yödzö ziʼtuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Le nácatë reaʼ libíʼiliʼ, yúguʼtë le inná bë́ʼëliʼ lu yödzölió ni, naca le chigunná bëʼë Dios yehuaʼ yubá, ateʼ yúguʼtë le güíʼiliʼ lataj lu yödzölió ni, naca le chibë́ʼë lataj Dios yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Lëscaʼ caní reaʼ libíʼiliʼ, channö chópasiliʼ gun tuz xtídzaʼliʼ lu yödzölió ni ca naca tu le inábiliʼ-nëʼ Dios, gunëʼ Xuz cazaʼ Dios, zoëʼ yehuaʼ yubá, lë naʼ rinábiliʼ-nëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ga nacuáʼ chopa tsonna nupa ni nudúbigaca quiaʼ nedaʼ, zoa cazaʼ nedaʼ gatsaj láhuiʼlö ga naʼ nacuʼë. ");
INSERT INTO zarNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Níʼirö gubíguiʼë Pedro ga zoëʼ Jesús, en gunábinëʼ Lëʼ, rnnëʼ: —Xan, ¿bál-laxitë luzuí ral-laʼ uniti lahuaʼ böchiʼ luzáʼa, nu naʼ ruáʼ döʼ quiaʼ? ¿Naruʼ gadxi luzuí? ");
INSERT INTO zarNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús rëʼ lëʼ: —Nedaʼ reaʼ liʼ, calë́gasö gadxi luzuí, pero idú tsónnalalaj yuʼ chi cuía le naca gadxi luzuí. ");
INSERT INTO zarNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Gunnë́ʼ caʼ Jesús: —Iaʼstú, ca gun Nu naʼ rinná bëʼ yehuaʼ yubá naca ca benëʼ tu bönniʼ rinná bëʼë. Gúʼunnëʼ ucáʼanalenëʼ tsahuiʼ yuguʼ bönniʼ huen dxin queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Cateʼ gusí lahuëʼ rucáʼanalenëʼ légaquiëʼ tsahuiʼ, dujuáʼgaquiëʼ ga zoëʼ tu bönniʼ ral-lëʼë queëʼ zián gayuáʼ dumí. ");
INSERT INTO zarNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tuʼ cabí guca quizxjëʼ, gunná bëʼë xanëʼ idóʼogaquiëʼ lëʼ, en nigula queëʼ, en yuguʼ biʼi queëʼ, en yúguʼtë le dë queëʼ, ateʼ níʼirö gazxaj le ral-lëʼë queëʼ xanëʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Níʼirö bönniʼ huen dxin naʼ buzóa zxibëʼ lahuëʼ xanëʼ, en gunábinëʼ lëʼ, rnnëʼ: “Xan, ben zxön ládxuʼu nedaʼ. Huaguizxaj cazaʼ liʼ idutë.” ");
INSERT INTO zarNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Níʼirö xanëʼ naʼ buéchiʼ ládxëʼë bönniʼ huen dxin queëʼ naʼ, en buniti lahuëʼ lëʼ lë naʼ ral-lëʼë queëʼ, ateʼ busanëʼ lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Cateʼ burúajëʼ bönniʼ huen dxin naʼ, laʼ yöjtságatëʼ tu bönniʼ rúnlenëʼ lëʼ tsözxö́n dxin, ateʼ bönniʼ naʼ ral-lëʼë queëʼ látiʼdoʼos dumí. Níʼirö guzxönëʼ lëʼ, en guzxínnajëʼ yenëʼ, ateʼ rëʼ lëʼ: “Gudízxjatë lë naʼ ral-luʼu quiaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Níʼirö luzë́ʼë naʼ buzóa zxibëʼ lahuëʼ, en gunaba yechë́ʼë lahuëʼ, rnnëʼ: “Ben zxön ládxuʼu nedaʼ. Huaguizxaj cazaʼ liʼ idutë.” ");
INSERT INTO zarNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Bitiʼ gúʼunnëʼ bönniʼ huen dxin naʼ, ateʼ yöjluʼë lëʼ lidxi guíë dza quízxjarëʼ lë naʼ ral-lëʼë queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Cateʼ bilaʼléʼenëʼ lë ni iaʼzícaʼrëʼ huen dxin, buluʼhuíʼinideʼenëʼ niʼa queëʼ, ateʼ yöjtíxjöiʼiguequinëʼ xángaquiëʼ yúguʼtë lë naʼ guca. ");
INSERT INTO zarNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Níʼirö xángaquiëʼ bulidzëʼ bönniʼ huen dxin naʼ, ateʼ rëʼ lëʼ: “Liʼ, huen dxin catsahuiʼ. Yúguʼtë dumí naʼ gúl-luʼu quiaʼ buniti lahuaʼ liʼ. Busúluaʼ lë naʼ gúl-luʼu quiaʼ tuʼ gunaba yechuʼu lahuaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Naruʼ cabí ral-laʼ huéchiʼ ládxuʼu caʼ luzóʼo ca naʼ benaʼ nedaʼ, buéchiʼ ládxaʼa liʼ?” ");
INSERT INTO zarNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Níʼirö gulédeʼenëʼ xanëʼ, en budödëʼ lëʼ lu náʼagaca nupa uluʼsacaʼ ziʼ lëʼ dza quízxjarëʼ idútë le ral-lëʼë queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Níʼirö rnnëʼ Jesús: —Lëscaʼ caní gunëʼ Xuzaʼ zoëʼ yehuaʼ yubá queë́liʼ channö cabí uniti loliʼ idú ládxiʼliʼ yuguʼ böchiʼ luzáʼaliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Cateʼ budxi bëʼë Jesús yuguʼ didzaʼ ni, buzë́ʼë luyú Galilea, ateʼ bidxinëʼ luyú Judea le dë iaʼtsöláʼa yegu Jordán sacaʼ ga rilén gubidza. ");
INSERT INTO zarNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bönachi zián söjácalen Jesús, ateʼ bunëʼ léguequi niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Níʼirö bilaʼdxinëʼ bal-lëʼ bönniʼ yudoʼ fariseo ga zoëʼ Jesús para ilaʼzíʼ bëʼë Lëʼ, ateʼ gulaʼnábinëʼ Lëʼ, taʼnnë́ʼ: —¿Naruʼ dë lataj bönniʼ nutsaga nëʼë usanëʼ nigula queëʼ tuʼ nözi bítiʼtës bi raca? ");
INSERT INTO zarNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Bubiʼë didzaʼ Jesús, rëʼ légaquiëʼ: —¿Naruʼ cabí nulábaniliʼ le nazúaj lu guichi láʼayi ca benëʼ Dios bönachi cateʼ siʼ benëʼ yödzölió? Bönniʼ, en nigula benëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Caní gunnë́ʼ Dios: “Que lë ni naʼ, ral-laʼ usanëʼ tu bönniʼ xuz xinë́ʼë, ateʼ tsaz tsöjsóalenëʼ-nu nigula queëʼ, ateʼ iropëʼ naʼ uluʼhuöáquiëʼ tuz bönachi.” ");
INSERT INTO zarNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Caní naca, bítiʼrö nácagaquiëʼ chopëʼ pero tuz bönachi chinuhuöáquiëʼ. Que lë ni naʼ, bitiʼ ral-laʼ uluʼlë́ʼë bönniʼ nupa naʼ benëʼ Dios tuz. ");
INSERT INTO zarNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Níʼirö bönniʼ yudoʼ naʼ gulaʼnábinëʼ Jesús, taʼnnë́ʼ: —¿Bizx que naʼ gunná béʼenëʼ Moisés légaquiëʼ le ruíʼi lataj nu bönniʼ unödzjëʼ tu guichi queë́nu nigula queëʼ le rnna nuláʼa yöl-laʼ nutsaga naʼ, ateʼ usanëʼ-nu nigula queëʼ naʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús rëʼ légaquiëʼ: —Caní benëʼ Moisés tuʼ nazidi icja ládxiʼdoʼoliʼ. Bennëʼ libíʼiliʼ lataj usanliʼ-nu nigula queë́liʼ, pero cateʼ gusí lo gutaʼ gurö́ʼö yödzölió, bitiʼ guca caní. ");
INSERT INTO zarNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nedaʼ reaʼ libíʼiliʼ, channö tu bönniʼ usanëʼ-nu nigula queëʼ, en bitiʼ gudálennu bönniʼ yúbölö, ateʼ utsaga náʼalenëʼ-nu nigula yúbölö, gunëʼ dul-laʼ le riguitsaj xibá que yöl-laʼ nutsaga naʼ. Lëscaʼ caní, channö nu bönniʼ utsaga náʼalenëʼ-nu nigula naʼ, nusanëʼ-nu bönniʼ queë́nu, gunëʼ dul-laʼ le riguitsaj xibá que yöl-laʼ nutsaga naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Níʼirö yuguʼ bönniʼ usëda queëʼ Jesús gulë́ʼ Lëʼ, taʼnnë́ʼ: —Channö caní naca queëʼ tu bönniʼ zóalenëʼ-nu nigula queëʼ, gácarö dxiʼa queëʼ laʼtuʼ cabí utsaga caz nëʼë, ugáʼanëʼ tuzëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Bubiʼë didzaʼ Jesús, rëʼ légaquiëʼ: —Bitiʼ gaca ilaʼzíʼ lu náʼagaca yúguʼtë bönachi didzaʼ ni, pero núpasö naʼ Dios ruzéajniʼinëʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nacuʼë bönniʼ bitiʼ tuʼtsaga náʼalengaquiëʼ nigula tuʼ cabí nácagaquiëʼ idú bönniʼ biguiúʼ, tuʼ gulaljëʼ caʼ, ateʼ iaʼzícaʼrëʼ bönniʼ bitiʼ tuʼtsaga náʼalengaquiëʼ nigula tuʼ buluʼzagaʼ bönachi xinö́zgaquiëʼ, ateʼ iaʼzícaʼrëʼ bönniʼ bitiʼ tuʼtsaga náʼalengaquiëʼ nigula para gaca ilunëʼ xichinëʼ Dios, Nu rinná bëʼ yehuaʼ yubá. Nu sequiʼ siʼ lu nëʼe didzaʼ ni ral-laʼ siʼ lu nëʼe le. ");
INSERT INTO zarNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Níʼirö yuguʼ xuz xináʼagacabiʼ bíʼidoʼ dujuáʼagaquiëʼ-biʼ ga zoëʼ Jesús para ixóa nëʼë légacabiʼ, en ulidzëʼ Dios niʼa quégacabiʼ, ateʼ bönniʼ usëda queëʼ buluʼzáguiʼë xinö́zgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Níʼirö Jesús rëʼ légaquiëʼ, rnnëʼ: —Guliʼgüíʼi-biʼ yuguʼ bíʼidoʼ lataj ilaʼdxinbiʼ ga zoaʼ, en bitiʼ uzágaʼliʼ xinö́zgacabiʼ, tuʼ ilaʼzíʼ lataj nupa nácagaca ca yuguʼ bíʼidoʼ caní ga niʼ rinná bëʼë Dios yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jesús guxóa nëʼë légacabiʼ, ateʼ níʼirö buzë́ʼë niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tu bönniʼ ni zoëʼ iz cuidiʼ queëʼ buduyúëʼ Jesús, en rëʼ Lëʼ: —Bönniʼ Usedi idú tsahuiʼ. ¿Bizxi le naca tsahuiʼ ral-laʼ gunaʼ para gataʼ yöl-laʼ naʼbán idú quiaʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Bubiʼë didzaʼ Jesús, rëʼ lëʼ: —¿Naruʼ nö́ztsenuʼ lë naʼ rnnoʼ quiaʼ, rnnoʼ nacaʼ idú tsahuiʼ? Cuntu nu bönniʼ náquiëʼ idú tsahuiʼ. Tuzëʼ Dios náquiëʼ idú tsahuiʼ. Channö rë́ʼënuʼ gataʼ yöl-laʼ naʼbán idú quiuʼ, ben ca rinná bëʼ xibá queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Níʼirö bönniʼ naʼ rëʼ Jesús, rnnëʼ: —¿Bízxilö xibá naʼ? Jesús rëʼ lëʼ: —Xibá naʼ gunná bëʼë Moisés: Bitiʼ gútiuʼ bönachi. Bitiʼ gunuʼ dul-laʼ le riguitsaj xibá que yöl-laʼ nutsaga naʼ. Bitiʼ cuanuʼ. Bitiʼ inníoʼ que böchiʼ luzóʼo le cabí nácate. ");
INSERT INTO zarNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ben bal xuz xinóʼo. Bidxíʼi böchiʼ luzóʼo ca nadxíʼi cuinuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Bönniʼ naʼ ni zoëʼ iz cuidiʼ queëʼ gudxëʼ Jesús, rnnëʼ: —Yúguʼtë lë ni runaʼ ga gudelaʼ nacaʼ bíʼidoʼ. ¿Naruʼ zoa iaʼtú le ral-laʼ gunaʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús rëʼ lëʼ: —Channö rë́ʼënuʼ gacuʼ tsahuiʼ, guyéaj, yöjëtiʼ le dë quiuʼ, ateʼ dumí naʼ siʼu, bunödzaj quégaca bönachi yechiʼ. Caní gataʼ yöl-laʼ tsahuiʼ quiuʼ niʼ yehuaʼ yubá. Níʼirö gudá, gudáʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Cateʼ bönniʼ naʼ ni zoëʼ iz cuidiʼ queëʼ biyönnëʼ didzaʼ ni, söhuö́jëʼ ruhuíʼinnëʼ tuʼ dëdaʼ yöl-laʼ tsahuiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Níʼirö Jesús gudxëʼ yuguʼ bönniʼ usëda queëʼ, rnnëʼ: —Le nácatë reaʼ libíʼiliʼ, böniga naca tsáziëʼ nu bönniʼ dë yöl-laʼ tsahuiʼ queëʼ ga rinná bëʼë Dios yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Iaʼstú reaʼ libíʼiliʼ, nácarö böniga tsáziëʼ tu bönniʼ dë yöl-laʼ tsahuiʼ queëʼ ga niʼ rinná bëʼë Dios ca tö́dibaʼ böaʼ lu nagui yötsiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Cateʼ bilaʼyönnëʼ yuguʼ bönniʼ usëda queëʼ didzaʼ ni, buluʼbáninë, taʼnnë́ʼ: —¿Nuzxi caz gaca ulá, channö? ");
INSERT INTO zarNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús buyúëʼ légaquiëʼ, en rëʼ légaquiëʼ: —Bitiʼ gaca ilún bönachi lë ni, pero Dios huáca gunëʼ yúguʼtë. ");
INSERT INTO zarNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Níʼirö bubiʼë didzaʼ Pedro, en rëʼ Jesús: —Buyútsöcaʼ, netuʼ chibucáʼanatuʼ yúguʼtë, en záʼlentuʼ Liʼ. ¿Bízxirö gataʼ queë́tuʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús rëʼ légaquiëʼ: —Le nácatë reaʼ libíʼiliʼ, dza niʼ cateʼ ucubi yödzölió, ateʼ cöʼa inná bëʼa nedaʼ, Bönniʼ Guljëʼ Bönachi, ga niʼ gácatëraʼ lo, lëscaʼ libíʼiliʼ záʼlenliʼ nedaʼ naʼa, cö́ʼöliʼ chinnu lataj ga inná bë́ʼëliʼ, en uchiʼa usöröliʼ quégaca idxinnu cöʼtë yödzö quégaca zxíʼini xiʼsóëʼ Israel. ");
INSERT INTO zarNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nu bönniʼ rucáʼanëʼ lidxëʼ, o yuguʼ bö́chëʼë, o yuguʼ zanëʼ, o xuzëʼ, o xinë́ʼë, o nigula queëʼ, o yuguʼ zxíʼinëʼ, o yuguʼ xiyúëʼ, para gunëʼ xichinaʼ, bönniʼ ni siʼë iaʼtú gáyuaʼtërö caʼ queëʼ, en gataʼ caʼ yöl-laʼ naʼbán idú queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Zián nupa nácagaca lo naʼa, uluʼgáʼana cáʼasö, ateʼ nupa nagáʼanagaca cáʼasö naʼa, hualácagaca lo. ");
INSERT INTO zarNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Gunnë́ʼ caʼ Jesús: —Ca gun Bönniʼ naʼ rinná bëʼë yehuaʼ yubá naca ca benëʼ tu bönniʼ xan yuʼu. Birúajëʼ zíladoʼ, yöjdiljëʼ yuguʼ bönniʼ ilunëʼ dxin ga naca lu xiyúëʼ ga naʼ nadúzgaca lubá uva. ");
INSERT INTO zarNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Cateʼ chibugáʼanalenëʼ tsahuiʼ yuguʼ bönniʼ huen dxin naʼ, quizxjëʼ légaquiëʼ tu dumí lazxaj que tu dza, gusö́l-lëʼë légaquiëʼ ilunëʼ dxin ga naca lu xiyúëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Cateʼ burúajëʼ idú xsila, biléʼenëʼ iaʼzícaʼrëʼ bönniʼ nacuáʼasëʼ caʼ ga naca lu yë́ʼëyi. ");
INSERT INTO zarNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Rëʼ légaquiëʼ: “Guliʼtséaj caʼ libíʼiliʼ ga naca lu xiyúaʼ, ateʼ quizxjaʼ libíʼiliʼ le naca tsahuiʼ.” Laʼ yöjácatëʼ caʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Burúajëʼ bönniʼ xan yuʼu naʼ leyúbölö idú huagubidza, encaʼ idú xihuö́ udzö́ʼ, en laʼ tuz ca benëʼ, gusö́l-lëʼë yuguʼ bönniʼ yöjxáquiëʼ lu xiyúëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Burúajëʼ caʼ cateʼ niʼ zoa iaʼlátiʼdoʼos gubidza, en yöjxáquiëʼ iaʼzícaʼrëʼ bönniʼ nacuáʼasëʼ caʼ niʼ, ateʼ rëʼ légaquiëʼ: “¿Bizx que zóatsaliʼ ni cáʼasö idú dza, bitiʼ bi dxin runliʼ?” ");
INSERT INTO zarNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Yuguʼ bönniʼ naʼ tëʼ lëʼ, taʼnnë́ʼ: “Cuntu nu benna xichintuʼ.” Níʼirö rëʼ légaquiëʼ: “Guliʼtséaj caʼ libíʼiliʼ ga naca lu xiyúaʼ, ateʼ quizxjaʼ libíʼiliʼ le naca tsahuiʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Cateʼ chizóa gal-la, bönniʼ xan yu naʼ rëʼ bönniʼ yuʼu lu nëʼë yuguʼ huen dxin naʼ, rnnëʼ: “Bulidza yuguʼ bönniʼ huen dxin naʼ, ateʼ guʼu lázxjagaquiëʼ. Quizxjuʼ zíʼalö yuguʼ bönniʼ naʼ bilaʼdxinëʼ yöjsetë. Udxi naʼ quizxjuʼ yuguʼ bönniʼ naʼ bilaʼdxinëʼ zíʼatëlö.” ");
INSERT INTO zarNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Níʼirö bilaʼdxinëʼ bönniʼ yöjéngaquiëʼ dxin cateʼ niʼ zoa iaʼlátiʼdoʼos gubidza, en gulaʼziʼë tu tuhuéajëʼ dumí lazxaj que tu dza. ");
INSERT INTO zarNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Cateʼ bilaʼdxinëʼ bönniʼ yöjéngaquiëʼ dxin zíʼatëlö, guléquinëʼ huazíʼgaquiëʼ iaʼlatiʼ, pero lëscaʼ gulaʼziʼë tu tuhuéajëʼ dumí lazxaj que tu dza. ");
INSERT INTO zarNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Cateʼ gulaʼziʼë le, gulaʼnnë́dëʼë queëʼ bönniʼ xan yuʼu naʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","taʼnnë́ʼ: “Yuguʼ bönniʼ ni bilaʼdxinëʼ ga yöjsetë, tu chíʼisö gulunëʼ dxin, en tuz ca gudízxjatsoʼ légaquiëʼ ca netuʼ, ateʼ netuʼ ni bentuʼ dxin idú dza, en gúguidaʼatuʼ gubidza.” ");
INSERT INTO zarNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Bubiʼë didzaʼ xan yu naʼ, en rëʼ tuëʼ: “Bö́chaʼa, bitiʼ bi runaʼ quiuʼ le cabí naca tsahuiʼ. ¿Naruʼ cabí bugáʼana tsáhuiʼruʼ siʼu tu dumí lazxaj que tu dza? ");
INSERT INTO zarNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Guzxíʼ lazxjuʼ, en böaj lidxuʼ. Nedaʼ rë́ʼëndaʼ quizxjaʼ bönniʼ ni yöjenëʼ dxin ga yöjsetë laʼ leze ca naʼ riguizxjaʼ liʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Naruʼ cabí dë lu naʼa gunaʼ ca rë́ʼëndaʼ len le nequi quiaʼ? ¿Naruʼ ruzxéʼetsenuʼ-nëʼ luzóʼo tuʼ rúnnadaʼa queëʼ?” ");
INSERT INTO zarNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Caní naca, bal-lëʼ bönniʼ, tuʼcáʼana bönachi légaquiëʼ cáʼasö, ilácagaquiëʼ lo, ateʼ iaʼzícaʼrëʼ bönniʼ, nácagaquiëʼ lo naʼa, uluʼgáʼanëʼ cáʼasö. Zián nupa nulidzaʼ, pero nabábasö nupa narö́gaca. ");
INSERT INTO zarNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Cateʼ niʼ yuʼë Jesús nöza, saʼyéajëʼ Jerusalén, guchë́ʼë quez idxínnutëʼ bönniʼ usëda queëʼ, en rëʼ légaquiëʼ: ");
INSERT INTO zarNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Buliʼyútsöcaʼ, ribenruʼ zéajruʼ Jerusalén, ateʼ niʼ soa nu udödi nedaʼ, Bönniʼ Guljëʼ Bönachi, lu náʼagaquiëʼ bixúz unná bëʼ, en lu náʼagaquiëʼ bönniʼ yudoʼ usëdi, ateʼ ilaʼchúguiëʼ quiaʼ gátiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Uluʼdödëʼ nedaʼ lu náʼagaquiëʼ bönniʼ ziʼtuʼ para uluʼtitjëʼ nedaʼ. Ilaʼguinëʼ nedaʼ, en uluʼdë́ʼë nedaʼ lëʼe yaga cruz, pero cateʼ gaca tsonna dza, Dios usubanëʼ nedaʼ lu yöl-laʼ guti. ");
INSERT INTO zarNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Níʼirö bidxinnu xináʼagaquiëʼ Jacobo, en Juan, yuguʼ zxíʼinëʼ Zebedeo, ga zoëʼ Jesús, dzágagaquiëʼ-nu chopëʼ ni, ateʼ buzóa zxíbinu lahuëʼ Jesús, en gunábinu Lëʼ tu le uzáʼ ládxëʼë queë́nu. ");
INSERT INTO zarNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús gunábinëʼ-nu, rnnëʼ: —¿Bizxi rë́ʼënuʼ? Rënu Lëʼ: —Gunná bëʼ cö́ʼöbiʼ tubiʼ zxíʼinaʼ ni cuita lëʼu ibëla, en iaʼtubiʼ cö́ʼöbiʼ cuita lëʼu yö́göla ga niʼ inná bëʼu. ");
INSERT INTO zarNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Bubiʼë didzaʼ Jesús, rëʼ légaquiëʼ: —Bitiʼ nö́ziliʼ le rinábaliʼ. ¿Naruʼ huáca guáʼ ilenliʼ le quiʼi sacaʼ nedaʼ, en idílaliʼ nisa ca idilaʼ nedaʼ nisa, gátiaʼ? Tëʼ Lëʼ: —Huácatuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Níʼirö Jesús rëʼ légaquiëʼ: —Le nácatë le ral-laʼ quiʼi sacaʼa nedaʼ, gaca caʼ queë́liʼ, en le ral-laʼ idilaʼ nedaʼ nisa, gátiaʼ, idílaliʼ caʼ nisa libíʼiliʼ, pero que cö́ʼöliʼ cuita lëʼa ibëla o cuita lëʼa yö́göla, bitiʼ dë lu naʼa nu guʼa que, pero gataʼ quégaca nupa niʼ chinupë́ʼë Xuzaʼ quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Cateʼ iaʼchíëʼ bönniʼ usëda queëʼ Jesús bilaʼyönnëʼ lë ni, gulaʼlenëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Níʼirö Jesús bulidzëʼ légaquiëʼ, rnnëʼ: —Nözquéziliʼ ca tunëʼ yuguʼ bönniʼ taʼnná béʼenëʼ bönachi izáʼa, ridö́ditë bëʼ taʼnná béʼenëʼ légaquiëʼ, ateʼ nupa niʼ nácagacarö lo taʼnná beʼe laʼ luzë́ʼeguequisö. ");
INSERT INTO zarNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Bitiʼ gaca caní queë́liʼ. Nútiʼtëslöliʼ libíʼiliʼ nu rë́ʼëni gaca zxön ga zóaliʼ, nu ni ral-laʼ gun dxin que iaʼzícaʼröliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Lëscaʼ caní, nútiʼtëslöliʼ libíʼiliʼ nu guë́ʼëni gaca lo, ral-laʼ gaca ca tu bönniʼ nadóʼo que iaʼzícaʼröliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Lëscaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, bidaʼ ni, calëga para nu gun xichinaʼ, pero para gunaʼ xichíngaca bönachi, en udödaʼ yöl-laʼ naʼbán quiaʼ, le quízxjadaʼ niʼa quégaca bönachi zián para uluʼlágaca. ");
INSERT INTO zarNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Cateʼ niʼ tuʼrúajëʼ yödzö Jericó, bönachi zián söjácalen Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nacuʼë chopëʼ bönniʼ nachul-la lógaquiëʼ niʼ, rö́ʼgaquiëʼ raʼ nöza. Cateʼ bilaʼyönnëʼ ridödëʼ Jesús niʼ, guluʼë zidzaj didzaʼ, taʼnnë́ʼ: —Xan, zxíʼini xiʼsóëʼ David, buéchiʼ ladxiʼ netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Bönachi zián nacuáʼ niʼ gulë́ légaquiëʼ ilaʼcuʼë dxisö, pero zídzajrö guluʼë didzaʼ, taʼnnë́ʼ: —Xan, zxíʼini xiʼsóëʼ David, buéchiʼ ladxiʼ netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Níʼirö guzë́ʼ ribözëʼ Jesús, en bulidzëʼ légaquiëʼ, ateʼ gunábinëʼ légaquiëʼ, rnnëʼ: —¿Bizxi rë́ʼëniliʼ gunaʼ queë́liʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tëʼ Jesús: —Xan, rë́ʼënituʼ gunuʼ ga huöálaj guiö́j lotuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Níʼirö Jesús buéchiʼ ládxëʼë légaquiëʼ, ateʼ gudanëʼ guiö́j lógaquiëʼ. Laʼ böáljatëgaca guiö́j lógaquiëʼ, ateʼ yöjácalenëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Cateʼ bilaʼdxíngalëʼ yödzö Jerusalén, en niʼ nacuʼë ga dë yödzö Betfagé ga naʼ zoa Guíʼa Yaga Olivo, níʼirö gusö́l-lëʼë Jesús chopëʼ bönniʼ usëda queëʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ateʼ rëʼ légaquiëʼ: —Guliʼtséajtsöcaʼ yö́dzödoʼ niʼ ca dö́dilö ga ni zóaruʼ, ateʼ laʼ tsöjxácaʼtëliʼ-baʼ tubaʼ burro gunáʼ nágaʼbaʼ, ateʼ dzaga lëbaʼ tubaʼ burro biguiúʼdoʼ. Guliʼtsöjsedxi-baʼ, en ichë́ʼëliʼ-baʼ quiaʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Channö nu bi guíë libíʼiliʼ, guliʼguíë nu naʼ: “Xanruʼ riquinnëʼ-baʼ.” Níʼirö isö́l-lëʼë légacabaʼ quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Caní guca para gaca lë naʼ buzúajëʼ lu guichi bönniʼ bëʼë didzaʼ uláz queëʼ Dios, gunnë́ʼ: ");
INSERT INTO zarNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Guliʼguíë nupa nacuáʼ yödzö Sión, Buliʼyútsöcaʼ, zëʼë Bönniʼ inná béʼenëʼ libíʼiliʼ. Lu yöl-laʼ nöxaj ladxiʼ queëʼ dxíëʼ-baʼ tubaʼ burro. Dxíëʼ cúdzuʼbaʼ búrrodoʼ nácabaʼ zxíʼinibaʼ böaʼ ruáʼabaʼ yuaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Níʼirö bönniʼ usëda queëʼ yöjáquiëʼ niʼ, ateʼ gulunëʼ ca naʼ gunná béʼenëʼ Jesús légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Gulaʼchë́ʼë-baʼ burro gunáʼ naʼ, en burro biguiúʼdoʼ naʼ, ateʼ buluʼdxíëʼ cúdzuʼgacabaʼ yuguʼ lariʼ guitsaʼ quégaquiëʼ, ateʼ gudxíëʼ Jesús lahuiʼ lariʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nacuáʼ caʼ bönachi zián niʼ, ateʼ gulaʼchilaj yuguʼ lariʼ taʼxóa cúdzuʼguequi laʼ nöza. Iaʼzícaʼrëʼ buluʼchibëʼ zin le buluʼzxóëʼ ga naca laʼ nöza. ");
INSERT INTO zarNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Guluíʼi zidzaj didzaʼ bönachi naʼ nanö́rugaca, en nupa naʼ söjácalen Jesús, taʼnná: —¡Yöl-laʼ ba Lëʼ, zxíʼini xiʼsóëʼ David! ¡Bicaʼ ba nu ni zaʼ niʼa que Lëʼ Xanruʼ! ¡Yöl-laʼ ba Dios! ");
INSERT INTO zarNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Cateʼ guyáziëʼ Jesús yödzö Jerusalén, buluʼdzatsa yúguʼtë bönachi lu yödzö naʼ, ateʼ zián nupa gulë́ luzë́ʼeguequi, taʼnná: —¿Nuzxi caz bönniʼ ni? ");
INSERT INTO zarNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Iaʼbal-la bönachi niʼ taʼnná: —Nu ni Jesús, bönniʼ ruʼë didzaʼ uláz queëʼ Dios, ateʼ naca ladzëʼ Nazaret luyú Galilea. ");
INSERT INTO zarNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Cateʼ guyáziëʼ Jesús löʼa yudoʼ queëʼ Dios, buláguiʼë níʼilö yúguʼtë nupa tutiʼ toʼo ga naca löʼa yudoʼ naʼ. Burixëʼ caʼ yuguʼ blaga quégaquiëʼ bönniʼ tuʼtsë́ʼë dumí yödzö ziʼtuʼ, en yuguʼ le taʼböʼi nupa tutiʼ guʼdödoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Rëʼ légaquiëʼ: —Nazúaj lu guichi láʼayi le rnna: “Lidxaʼ siʼi le, yuʼu ga nu ulidza Dios”, pero libíʼiliʼ chinunliʼ lataj ni ca naca yuʼu lídxigaca gubán. ");
INSERT INTO zarNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Cateʼ niʼ zoëʼ Jesús chila yudoʼ, bal-lëʼ bönniʼ nachul-la lógaquiëʼ, en bönniʼ bitiʼ raca ilaʼzë́ʼë bilaʼdxinëʼ ga naʼ zoëʼ, ateʼ Lëʼ bunëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Gulaʼlenëʼ yuguʼ bixúz unná bëʼ, en bönniʼ yudoʼ tuʼsédinëʼ cateʼ bilaʼléʼenëʼ yuguʼ yöl-laʼ huáca ni runëʼ Jesús, en bilaʼyönnëʼ tuíʼibiʼ bíʼidoʼ zidzaj didzaʼ ga naca chila yudoʼ, taʼnnabiʼ: —¡Bicaʼ ba Lëʼ, zxíʼini xiʼsóëʼ David! ");
INSERT INTO zarNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Níʼirö tëʼ Jesús: —¿Naruʼ cabí riyönnuʼ ca taʼnnabiʼ biʼi ni? Bubiʼë didzaʼ Jesús, rnnëʼ: —Ön, riyöndaʼ. ¿Naruʼ catu caz nulábaniliʼ le nazúaj lu guichi láʼayi caní caz ral-laʼ gaca? Caní rnna: “Liʼ benuʼ ga yuguʼ biʼi cuidiʼ, en yuguʼ bíʼidoʼ niʼ tádxiʼbiʼ gulúl-labiʼ yöl-laʼ ba le naca idú.” ");
INSERT INTO zarNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Níʼirö Jesús bucáʼanëʼ légaquiëʼ, ateʼ burúajëʼ Jerusalén. Guyijëʼ yödzö Betania ga niʼ bugáʼanëʼ idú yëla. ");
INSERT INTO zarNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Cateʼ zaʼ reníʼ, ateʼ niʼ söhuö́jëʼ Jesús Jerusalén, ridunëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Biléʼenëʼ tu yaga higo röʼ gal-laʼ cuite nöza, ateʼ gubíguiʼë ga naʼ röʼ, pero bitiʼ bi bidzö́linëʼ lu yaga naʼ. Xiláguiʼsö dxía. Níʼirö Jesús gudxëʼ le: —Bítiʼrö cuía le ribía quiuʼ. Laʼ gubídxitë yaga higo naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Cateʼ bilaʼléʼenëʼ bönniʼ usëda queëʼ lë ni, buluʼbáninëʼ, ateʼ gulaʼnábinëʼ Jesús, taʼnnë́ʼ: —¿Nacxi caz guca, gubídxitë yaga ni? ");
INSERT INTO zarNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Bubiʼë didzaʼ Jesús, rëʼ légaquiëʼ: —Le nácatë reaʼ libíʼiliʼ, channö tséajlëʼëliʼ Dios, en bitiʼ gaca chopa ládxiʼliʼ, calë́gasö huáca gunliʼ ca naʼ benaʼ que yaga ni, pero channö guië́liʼ guíʼa ni: Gucuíta, en yöjsóa lu nísadoʼ, gaca ca naʼ innaliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Lëscaʼ caní, yúguʼtë le inábaliʼ cateʼ ulídzaliʼ-nëʼ Dios, channö huayéjlëʼëliʼ gunnëʼ Dios queë́liʼ, huazíʼiliʼ lë naʼ inábaliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Níʼirö guyáziëʼ Jesús chila yudoʼ, ateʼ tsanni niʼ rusédinëʼ bönachi nacuáʼ niʼ, bilaʼdxinëʼ yuguʼ bixúz unná bëʼ len bönniʼ gula tuʼzéajniʼinëʼ ga zoëʼ, ateʼ gulaʼnábinëʼ Jesús, taʼnnë́ʼ: —¿Bizxi yöl-laʼ unná bëʼ dë lu noʼo, runtsoʼ yuguʼ lë ni? ¿Nuzxi budödi lu noʼo yöl-laʼ unná bëʼ ni? ");
INSERT INTO zarNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Bubiʼë didzaʼ Jesús, rëʼ légaquiëʼ: —Lëscaʼ nedaʼ inábatsöquiʼdaʼ libíʼiliʼ tu didzaʼ. Channö quíxjöiʼiliʼ nedaʼ ca naca, nedaʼ caʼ guíaʼ libíʼiliʼ bizxi yöl-laʼ unná bëʼ dë lu naʼa runaʼ caní. ");
INSERT INTO zarNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Nuzxi caz gusöl-laʼ Juan para buquilëʼ bönachi nisa? ¿Naruʼ Dios gusö́l-lëʼë lëʼ, o gulaʼsö́l-lëʼë yuguʼ bönniʼ lëʼ? Níʼirö gulaʼsí lógaquiëʼ bönniʼ yudoʼ naʼ taʼnnë́ʼ laʼ légacasëʼ: —Channö innaruʼ: Dios gusö́l-lëʼë lëʼ, laʼ guië́tëʼ rëʼu: “¿Bizx que bitiʼ guyéajlëʼëliʼ lëʼ?” ");
INSERT INTO zarNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Naʼa, channö innaruʼ: Gulaʼsö́l-lëʼë yuguʼ bönniʼ lëʼ, rádxiruʼ le ilún bönachi lu yödzö tuʼ taʼyéajlëʼë yúguʼtëʼ Juan naʼ bëʼë didzaʼ uláz queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Que lë ni naʼ buluʼbiʼë didzaʼ, tëʼ Jesús: —Bitiʼ nöztuʼ. Jesús rëʼ légaquiëʼ: —Nedaʼ caʼ, bitiʼ guíaʼ libíʼiliʼ bizxi yöl-laʼ unná bëʼ dë lu naʼa runaʼ lë ni. ");
INSERT INTO zarNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Níʼirö Jesús gudxëʼ yuguʼ bönniʼ yudoʼ naʼ: —¿Nacxi rusácaʼliʼ queë́liʼ? Guzóëʼ tu bönniʼ nacuáʼabiʼ chópabiʼ biʼi bönniʼ queëʼ, ateʼ yöjödxëʼ-biʼ tubiʼ biʼi queëʼ naʼ, gunnë́ʼ: “Zxíʼinaʼ, guyéaj naʼa tsöjenuʼ dxin ga naca luyú quiaʼ ga rö́ʼgaca lubá uva.” ");
INSERT INTO zarNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Bubíʼibiʼ didzaʼ biʼi naʼ, gúdxibiʼ-nëʼ: “Bitiʼ rë́ʼëndaʼ tsejaʼ.” Gudödi niʼ bubíʼi ládxiʼbiʼ, ateʼ yöjenbiʼ dxin. ");
INSERT INTO zarNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Níʼirö bönniʼ naʼ yöjödxëʼ-biʼ iaʼtubiʼ biʼi queëʼ naʼ, en laʼ tuz ca gunnë́ʼ, ateʼ bubíʼibiʼ didzaʼ biʼi ni, gúdxibiʼ-nëʼ: “Huaca, Dad. Uyéajaʼ.” Bitiʼ guyéajbiʼ biʼi ni. ");
INSERT INTO zarNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Núzxilöbiʼ biʼi chopa ni benbiʼ le guyaza ládxëʼë xúzibiʼ? Buluʼbiʼë didzaʼ, tëʼ Jesús: —Biʼi zíʼalö naʼ. Níʼirö Jesús rëʼ légaquiëʼ: —Le nácatë reaʼ libíʼiliʼ, ilaʼnö́ruëʼ bönniʼ uquízxaj tuáʼ döʼ, en yuguʼ nigula udá dzaga ca libíʼiliʼ, ateʼ ilaʼyáziëʼ ga niʼ rinná bëʼë Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Caní gaca, tuʼ bidëʼ Juan, bönniʼ buquilëʼ bönachi nisa, ga zóaliʼ, en busédinëʼ libíʼiliʼ le naca tsahuiʼ ca ral-laʼ gunliʼ, ateʼ libíʼiliʼ bitiʼ guyéajlëʼëliʼ lëʼ, pero yuguʼ bönniʼ uquízxaj, en yuguʼ nigula udá dzaga gulaʼyéajlëʼë lëʼ. Sal-laʼ biléʼeliʼ lë ni, bitiʼ bubíʼi ládxiʼliʼ para tséajlëʼëliʼ lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Gunnë́ʼ caʼ Jesús: —Buliʼzë́ nágaliʼ iaʼtú le ucúdzuʼa didzaʼ. Guzóëʼ tu bönniʼ xan yuʼu, ateʼ bönniʼ ni budë́ʼë yuguʼ lubá uva luyú queëʼ. Guléquiëʼ lëʼaj que, en guchö́ʼönëʼ tu lerui guiö́j ga isíëʼ xisi uva naʼ. Benëʼ caʼ tu yuʼu xitsáʼ ga gaca nu uyú idútë luyú queëʼ. Níʼirö budödëʼ luyú naʼ lu náʼagaquiëʼ bönniʼ huen dxin, para ilaʼziʼë quégaquiëʼ gatsaj huéaj, ateʼ saʼyéajëʼ yödzö ziʼtuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","’Cateʼ chibidxín dza uluʼchibëʼ yuguʼ lubá uva naʼ, gusö́l-lëʼë bönniʼ xan luyú naʼ bal-lëʼ niʼa nëʼë ga naʼ nacuʼë bönniʼ huen dxin niʼ para uluʼziʼë lu náʼagaquiëʼ uláz queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Níʼirö gulaʼzönëʼ bönniʼ huen dxin naʼ yuguʼ niʼa nëʼë naʼ. Gulunëʼ huëʼ tuëʼ, en iaʼtúëʼ bë́tigaquiëʼ lëʼ, en iaʼtúëʼ buluʼladxëʼ lëʼ guiö́j. ");
INSERT INTO zarNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Leyúbölö bönniʼ xan luyú naʼ gusö́l-lëʼë caʼ iaʼzícaʼrëʼ niʼa nëʼë, ateʼ guláquiëʼ ziántërëʼ ca nupa naʼ gusö́l-lëʼë zíʼalö, ateʼ laʼ tuz ca gulunëʼ bönniʼ huen dxin niʼ quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Ga yöjsete, gusö́l-lëʼë caʼ zxíʼinëʼ ga naʼ nacuʼë. Guzáʼ ládxëʼë, rnnëʼ: Hualunëʼ bal biʼi quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Cateʼ yuguʼ bönniʼ huen dxin naʼ bilaʼléʼenëʼ-biʼ zxíʼinëʼ, laʼ gulaʼnnatëʼ laʼ légacasëʼ: “Biʼi ni guequi queë́biʼ luyú ni. Guliʼdá, gútiruʼ-biʼ, ateʼ le ral-laʼ guequi queë́biʼ guequi queë́ruʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Níʼirö gulaʼzönëʼ-biʼ, ateʼ buluʼbéajëʼ-biʼ níʼilö luyú ga naʼ rö́ʼgaca lubá uva, ateʼ bë́tigaquiëʼ-biʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Níʼirö Jesús gunábinëʼ légaquiëʼ, gunnë́ʼ: —Cateʼ udxinëʼ bönniʼ xan luyú naʼ, ¿nacxi gunëʼ quégaquiëʼ bönniʼ huen dxin niʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Buluʼbiʼë didzaʼ bönniʼ yudoʼ naʼ, tëʼ Jesús: —Usunítiëʼ bönniʼ tuáʼ döʼ naʼ, ateʼ luyú queëʼ naʼ udödëʼ lu náʼagaquiëʼ iaʼzícaʼrëʼ bönniʼ huen dxin, bönniʼ iluʼë lëʼ uláz queëʼ cateʼ idxín dza uluʼchibëʼ le. ");
INSERT INTO zarNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Níʼirö Jesús gudxëʼ légaquiëʼ: —¿Naruʼ catu caz nulábaniliʼ lë naʼ nazúaj lu guichi láʼayi ca naca lë ni? Caní rnna: Guiö́j naʼ gulaʼrúʼunëʼ bönniʼ tuʼcuʼë zöʼö, laʼ guiö́j náʼasö chinaca guiö́j len zöʼö. Lë cazëʼ Xanruʼ benëʼ ga naca caní, ateʼ naca tu le run ga rubániruʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","’Que lë ni naʼ reaʼ libíʼiliʼ, xilátjaliʼ ga naʼ rinná bëʼë Dios idúa queë́liʼ, en gataʼ quégaca bönachi ilún ca ral-laʼ gun nu nadeliʼ lataj niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nu tsöjcheguʼ lu guiö́j ni, laʼ cuinsi quitsaj, ateʼ channö guiö́j ni tseajbagaʼ bönniʼ naʼ, uzxuzxaj lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Cateʼ yuguʼ bixúz unná bëʼ, en yuguʼ bönniʼ yudoʼ fariseo bilaʼyönnëʼ lë naʼ bucúdzuʼë didzaʼ Jesús, téquibeʼenëʼ bëʼë Jesús didzaʼ ca naca quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Gulaʼzóa gulaʼböʼë ilaʼzönëʼ Jesús, pero guládxinëʼ bi ilún bönachi zián nacuáʼ niʼ tuʼ taʼyéajlëʼ náquiëʼ Jesús bönniʼ ruʼë didzaʼ uláz queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús bë́ʼlenëʼ légaquiëʼ didzaʼ leyúbölö, ateʼ bucúdzuʼë didzaʼ, rnnëʼ: ");
INSERT INTO zarNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Ca gaca quégaca nupa ilaʼyaza ga rinná bëʼë Dios yehuaʼ yubá naca ca guca quégaca nupa bulidzëʼ tu bönniʼ rinná bëʼë cateʼ benëʼ laní que dza utsaga náʼabiʼ biʼi bönniʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Gusö́l-lëʼë niʼa nëʼë tsöjxíʼgaquiëʼ yuguʼ bönniʼ chinulidzëʼ para guídagaquiëʼ laní queë́biʼ, pero bitiʼ gulë́ʼënëʼ guídagaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Níʼirö gusö́l-lëʼë iaʼzícaʼrëʼ niʼa nëʼë, en gudxëʼ légaquiëʼ: “Guliʼtsöjö́dxitsöcaʼ nupa naʼ chinulidzaʼ, naʼ guië́liʼ légaquiëʼ: Buliʼyútsöcaʼ, chinupáʼa laʼ huagu. Chibë́tiaʼ-baʼ yuguʼ xpëdxaʼ, en yuguʼ böaʼ bëdxi renniʼ quiaʼ. Yúguʼtë chinupáʼa. Guliʼdá, sóaruʼ laní queë́biʼ biʼi bönniʼ quiaʼ utsaga náʼabiʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Yuguʼ bönniʼ naʼ yöjlídzagaquiëʼ bitiʼ gulunëʼ légaquiëʼ bal, ateʼ yöjáquiëʼ que queë́gaquiëʼ. Tuëʼ yöjenëʼ dxin, en iaʼtúëʼ guyijëʼ tsöjöʼu tsöjë́tiʼë. ");
INSERT INTO zarNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Iaʼzícaʼrëʼ gulaʼzönëʼ yuguʼ niʼa nëʼë naʼ, ateʼ guluʼë döʼ quégaquiëʼ, en bë́tgaquiëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Cateʼ bönniʼ naʼ rinná bëʼë biyönnëʼ lë ni, gulénëʼ, en gusö́l-lëʼë yuguʼ bönniʼ queëʼ röjáquiëʼ gudil-la, ateʼ bë́tigaquiëʼ yuguʼ bönniʼ hueti bönachi naʼ, en buluʼquélëʼë guíʼ ládzagaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Níʼirö bönniʼ naʼ rinná bëʼë gudxëʼ yuguʼ niʼa nëʼë, gunnë́ʼ: “Le nácatë chinupáʼa que laní naʼ, pero yuguʼ bönniʼ bulidzaʼ bitiʼ guláquiëʼ lesacaʼ guídagaquiëʼ laní quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Guliʼtséajtsöcaʼ gapa naca laʼ nöza, en buliʼlidza yúguʼtë nupa tsöjxácaʼliʼ niʼ para guídagaca laní queë́biʼ biʼi bönniʼ quiaʼ utsaga náʼabiʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Níʼirö bilaʼrúajëʼ niʼa nëʼë naʼ, söjáquiëʼ gapa naca laʼ nöza, ateʼ buluʼtubëʼ yúguʼtë nupa yöjxácaʼgaquiëʼ, yuguʼ bönniʼ dxiʼa, en yuguʼ bönniʼ tuáʼ döʼ, ateʼ ga naʼ raca laní bilírö bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Cateʼ guyáziëʼ bönniʼ naʼ rinná bëʼë para uyúëʼ nupa niʼ nudúbigaca, biléʼenëʼ tu bönniʼ bitiʼ nácuëʼ lariʼ tsahuiʼ le bunödzjëʼ quégaquiëʼ bönniʼ nacuʼë laní naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Níʼirö gudxëʼ bönniʼ naʼ: “Bö́nniʼdoʼ, ¿zóatsoʼ ni, en bitiʼ nacuʼ lariʼ tsahuiʼ bunödzjaʼ quégaca nupa nacuáʼ laní?” Bönniʼ naʼ busayaj ruʼë. ");
INSERT INTO zarNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Níʼirö bönniʼ naʼ rinná bëʼë gudxëʼ nupa naʼ tun xichinëʼ, gunnë́ʼ: “Guliʼgugaʼ niʼa nëʼë bönniʼ ni. Guliʼtsöjchúʼun-nëʼ níʼilö ga naʼ röʼö chul-la. Niʼ cödxëʼ, en utíl-la láyëʼë, lu yöl-laʼ ruhuíʼini queëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Níʼirö Jesús gudxëʼ légaquiëʼ: —Zian nupa nulidzaʼ, pero nabábasö nupa ilaʼrö́gaca. ");
INSERT INTO zarNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Níʼirö yuguʼ bönniʼ yudoʼ fariseo naʼ buluʼzë́ʼë niʼ, ateʼ gulún xtídzaʼgaquiëʼ ilunëʼ ga bi innë́ʼ Jesús para gaca uluʼzéguiëʼ Lëʼ didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Para ilunëʼ caní, gulaʼsö́l-lëʼë bal-lëʼ bönniʼ dáʼgaquiëʼ légaquiëʼ, len bönniʼ dáʼgaquiëʼ Herodes, ga zoëʼ Jesús, nupa naʼ gulë́ Jesús: —Bönniʼ Usedi, nöztuʼ Liʼ ruʼu didzaʼ cátëze naca, en naca idútë li ca rusédinuʼ ca naca queëʼ Dios, en bitiʼ ruíʼi ládxuʼu le taʼnná quiuʼ bönachi, tuʼ cabí ruchiʼa rusörö́uʼ bönachi ca naca le taʼnnasö bönachi naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gudíxjöiʼi netuʼ. ¿Nacxi runi liʼ? ¿Naruʼ run bayudxi, o bitiʼ run bayudxi quizxaj laztuʼ queëʼ César, bönniʼ yödzö ziʼtuʼ naʼ rinná béʼenëʼ rëʼu? ");
INSERT INTO zarNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Réquibeʼenëʼ Jesús të́ʼënnëʼ uluʼbéajëʼ Lëʼ didzaʼ, ateʼ gudxëʼ légaquiëʼ: —Libiʼiliʼ, bönniʼ ruluíʼisö tsahuiʼ cuinliʼ, ¿bizx que ruíʼiliʼ didzaʼ le ruzóa nedaʼ raʼ guíʼa? ");
INSERT INTO zarNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Buliʼluíʼi nedaʼ dumí le riguízxaj lázaliʼ. Níʼirö buluʼluíʼinëʼ Lëʼ tu dumí que yödzö Roma. ");
INSERT INTO zarNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesús gunábinëʼ légaquiëʼ, rnnëʼ: —¿Nuzxi lahui daʼ ni, en nuzxi le nazúaj lëʼe dumí ni? ");
INSERT INTO zarNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tëʼ Lëʼ: —Queëʼ César naʼ. Níʼirö Jesús gudxëʼ légaquiëʼ: —Guliʼguízxjëʼ César le nequi queëʼ César, ateʼ Dios le nequi queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Cateʼ bilaʼyönnëʼ lë ni, buluʼbáninëʼ ca naca didzaʼ tsahuiʼ bubiʼë Jesús, ateʼ buluʼcáʼanëʼ Lëʼ, söhuö́ajtëgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Laʼ dza náʼasö yuguʼ bönniʼ yudoʼ saduceo, bönniʼ naʼ taʼnnë́ʼ bitiʼ uluʼbán nupa chinátigaca, bilaʼdxinëʼ ga zoëʼ Jesús, ateʼ gulaʼnábinëʼ Lëʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","taʼnnë́ʼ: —Bönniʼ Usedi, Moisés gunnë́ʼ: “Channö gátiëʼ tu bönniʼ zóanu nigula queëʼ, en cuntu nu biʼi zóabiʼ queëʼ, níʼirö biʼi bö́chëʼë bönniʼ naʼ ral-laʼ utsaga náʼalenbiʼ-nu nigula uzëbi queëʼ, para cabí initi diʼa dza queëʼ bönniʼ bö́chiʼbiʼ naʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Gulaʼcuáʼabiʼ gadxi biʼi bönniʼ ga zóatuʼ, naca bö́chiʼgacabiʼ. Biʼi zíʼalö naʼ butsaga náʼalenbiʼ-nu nigula, ateʼ gútitëbiʼ. Tuʼ cuntu nu biʼi queë́biʼ zóabiʼ, biʼi buropi naʼ butsaga náʼalenbiʼ-nu nigula uzëbi queë́biʼ biʼi bö́chiʼbiʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Lëscaʼ caní guca queë́biʼ biʼi buropi naʼ, encaʼ queë́biʼ biʼi bunni, en laʼ tuz ca guca quégacabiʼ igádxitëbiʼ, gulátibiʼ yúguʼtëbiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ga búdxitë gútinu caʼ nigula naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Cateʼ idxín dza uluʼbán nupa chinátigaca, ¿núzxilögacabiʼ biʼi gadxi niʼ guéquinu nigula naʼ queë́biʼ, tuʼ buluʼtsaga náʼalenbiʼ-nu yúguʼtëbiʼ nigula naʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Níʼirö bubiʼë didzaʼ Jesús, ateʼ rëʼ légaquiëʼ: —Nachíxiliʼ libíʼiliʼ tuʼ cabí réajniʼiliʼ le nazúaj lu guichi láʼayi, en tuʼ cabí núnbëʼëliʼ yöl-laʼ huáca queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Cateʼ idxín dza uluʼbán nupa chinátigaca, bítiʼrö gaca yöl-laʼ rizóalen nigula, en bitiʼ uluʼtsaga náʼagaquiëʼ, pero gácagaquiëʼ ca nácagaquiëʼ gubáz láʼayi queëʼ Dios nacuʼë yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ca naʼ ral-laʼ uluʼbán nupa chinátigaca, ¿naruʼ cabí nulábaniliʼ lë naʼ gudxi cazëʼ Dios libíʼiliʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Caní gunnë́ʼ: “Nedaʼ nacaʼ Dios queëʼ Abraham, en Dios queëʼ Isaac, en Dios queëʼ Jacob.” Dios naʼ bitiʼ náquiëʼ Dios quégaca nupa nátigaca tsaz, pero náquiëʼ Dios quégaquiëʼ bönniʼ ni nabángaquiëʼ sal-laʼ gulátiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Cateʼ bilaʼyöni bönachi nacuáʼ niʼ didzaʼ ni, buluʼbani ca naca lë naʼ rusédinëʼ Jesús léguequi. ");
INSERT INTO zarNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Cateʼ guléquibeʼenëʼ bönniʼ yudoʼ fariseo ca benëʼ Jesús, busayjëʼ ruáʼagaquiëʼ bönniʼ yudoʼ saduceo, níʼirö buluʼdubëʼ yúguʼtëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tuëʼ bönniʼ nútsëʼë ládjagaquiëʼ, en nazëdëʼ xibá queëʼ Moisés, gúʼunnëʼ siʼ bëʼë Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Que lë ni naʼ gunábinëʼ Jesús, rnnëʼ: —Bönniʼ Usedi, ¿bízxilö xibá queëʼ Dios naca lo? ");
INSERT INTO zarNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús rëʼ lëʼ: —Idxiʼinuʼ Xanuʼ Dios idú ládxuʼu, en idú icja ládxiʼdoʼo, encaʼ len idú yöl-laʼ réajniʼi quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Xibá ni naca lo, en nazácaʼtërö. ");
INSERT INTO zarNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Xibá naʼ naca buropi, laʼ ca nácatë, en caní rnna: “Idxíʼinuʼ böchiʼ luzóʼo ca nadxíʼi cuinuʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Chopa xibá ni nácagaca ga röjlö́z yúguʼtë le rinná bëʼ xibá queëʼ Dios, en yúguʼtë le buluʼsédinëʼ bönniʼ guluʼë didzaʼ uláz queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tsanni niʼ nacuʼë tsözxö́n bönniʼ yudoʼ fariseo naʼ, Jesús gunábinëʼ légaquiëʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","rnnëʼ: —¿Nacxi rusácaʼliʼ queë́liʼ queëʼ Bönniʼ naʼ lëʼ Cristo? ¿Nuzxi zxíʼini náquiëʼ? Buluʼbiʼë didzaʼ, taʼnnë́ʼ: —Zxiʼini xiʼsóëʼ David náquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Níʼirö Jesús rëʼ légaquiëʼ: —¿Bizx que naʼ lë cazëʼ David bulidzëʼ Lëʼ, gunnë́ʼ: “Xanaʼ”? Caní gunnë́ʼ cateʼ niʼ bëʼë didzaʼ uláz queëʼ Dios Böʼ Láʼayi, gunnë́ʼ: ");
INSERT INTO zarNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Xanruʼ Dios gudxëʼ Xanaʼ: “Gurö́ʼö cuita lëʼa ibëla, cateʼ gunraʼ ga uluʼzechu zxíbigaca Loʼ nupa tequi Liʼ ziʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Channö David naʼ gunnë́ʼ queëʼ náquiëʼ Xanëʼ, ¿nacxi caz naca, rnnaliʼ náquiëʼ zxíʼini xiʼsóëʼ David naʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Cuntu nu guca ubíʼi didzaʼ, ateʼ ga gusí lo dza naʼ, cúnturö nu burugui bi inábini Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Níʼirö Jesús bë́ʼlenëʼ bönachi nacuáʼ niʼ len yuguʼ bönniʼ usëdi queëʼ didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Rëʼ légaquiëʼ: —Yuguʼ bönniʼ yudoʼ fariseo, en yuguʼ bönniʼ yudoʼ usedi nuhuöázagaquiëʼ xilatjëʼ Moisés, en tuʼsédinëʼ bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Que lë ni naʼ, guliʼgún yúguʼtë le ilë́ʼ libíʼiliʼ, pero bitiʼ gunliʼ libíʼiliʼ ca naʼ tunëʼ légaquiëʼ, tuʼ tu le taʼnnë́ʼ, en iaʼtú le tunëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Le taʼnná béʼenëʼ bönachi naca ca tu yuaʼ ziʼi le cabí sequiʼ nu guáʼ, ateʼ tuʼguʼë le yaʼzxícjagaca bönachi, pero légaquiëʼ bitiʼ të́ʼënnëʼ uluʼtenëʼ le, calëga len tuze xibö́n náʼagaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yúguʼtë le tunëʼ, tunëʼ para ilaʼléʼe bönachi légaquiëʼ, tuʼ tunëʼ zxön le túguiʼë yen náʼagaquiëʼ, en raʼ xigágaquiëʼ ga naʼ nuzúajgaquiëʼ tu le nazúaj lu guichi láʼayi, en tuʼtunnëʼ luzxi lariʼ nácugaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Të́ʼënnëʼ ilaʼböʼë ga naca lataj lo ga naʼ tuʼdubëʼ tahuëʼ, encaʼ ga naʼ naca lataj lo lu yuʼu ga tuʼdubëʼ tuʼsëdëʼ queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Lëscaʼ caní, të́ʼënnëʼ uluʼgapa bönachi légaquiëʼ didzaʼ ba zxön gapa naca lógaca bönachi, en të́ʼënnëʼ ilë́ bönachi légaquiëʼ: “Padiux, bönniʼ usedi.” ");
INSERT INTO zarNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Pero libíʼiliʼ, bitiʼ ral-laʼ gunliʼ ga nu guíë libíʼiliʼ: Bönniʼ Usedi, tuʼ zoa tuz Nu naca Bönniʼ Usedi queë́liʼ, nedaʼ, Cristo, ateʼ yúguʼtëliʼ nácaliʼ bö́chiʼliʼ tuliʼ iaʼtuliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Cuntu nu guië́liʼ luyú ni, bitiʼ innaliʼ: Xuz, tuʼ zoa tuz Nu naca Xúziliʼ, zoëʼ yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Bitiʼ gunliʼ ga nu guíë libíʼiliʼ: Xan, tuʼ zoa tuz Nu naca Xanliʼ, nedaʼ, Cristo. ");
INSERT INTO zarNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nu nutsaʼ ládjaliʼ nu run xichinliʼ iaʼzícaʼröliʼ, nu ni naʼ gácarö lo ga zóaliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Channö nu uzóa cuini lataj lo, cáʼasö ugáʼana nu naʼ, pero nu naca nöxaj ladxiʼ, gaca lo. ");
INSERT INTO zarNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Bicaʼ bayechiʼ libíʼiliʼ, bönniʼ yudoʼ usedi, encaʼ libíʼiliʼ, bönniʼ yudoʼ fariseo, bönniʼ ruluíʼisö tsahuiʼ cuinliʼ. Ruzágaʼliʼ nöza söjácalen bönachi para ilaʼdxín ga niʼ rinná bëʼë Dios yehuaʼ yubá. Laʼ libíʼisiliʼ bitiʼ sequiʼ tsúʼuliʼ, en bitiʼ ruíʼiliʼ lataj ilaʼyúʼu nupa të́ʼëni ilaʼyúʼu. ");
INSERT INTO zarNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Bicaʼ bayechiʼ libíʼiliʼ, bönniʼ yudoʼ usedi, encaʼ libíʼiliʼ, bönniʼ yudoʼ fariseo, bönniʼ ruluíʼisö tsahuiʼ cuinliʼ. Rugúaliʼ yuguʼ lídxigacanu nigula uzë́bidoʼ, en para uluíʼisö tsahuiʼ cuinliʼ, xidzé rulídzaliʼ-nëʼ Dios. Que lë ni naʼ, zíʼtërö irugu queë́liʼ quíʼi sácaʼliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Bicaʼ bayechiʼ libíʼiliʼ, bönniʼ yudoʼ usedi, encaʼ libíʼiliʼ, bönniʼ yudoʼ fariseo, bönniʼ ruluíʼisö tsahuiʼ cuinliʼ. Ridö́diliʼ idú lu nísadoʼ, en idú yödzölió ni para gunliʼ ga tseaj ládxëʼë tu bönniʼ Dios tsözxö́n len libíʼiliʼ, en cateʼ chiguzxéquiʼliʼ-nëʼ, runliʼ ga nabágaʼrëʼ xíguiaʼ ca libíʼiliʼ, ateʼ tsöjtsuʼë lu guíʼ gabila. ");
INSERT INTO zarNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Bicaʼ bayechiʼ libíʼiliʼ. Nachul-la loliʼ, ateʼ rë́ʼëniliʼ uluíʼiliʼ nöza bönachi. Caní naca queë́liʼ tuʼ rnnaliʼ: “Channö bi rizíʼ lu nëʼë tu bönniʼ niʼa que yudoʼ, bitiʼ run bayudxi, pero channö runëʼ le niʼa que oro dzöʼö yudoʼ, bayudxi gun.” ");
INSERT INTO zarNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Libíʼiliʼ, bönniʼ lo chul-la, en tuʼ caréajniʼi. ¿Bízxilö nácarö lo? ¿Naruʼ oro naʼ, o yudoʼ le run láʼayi oro naʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Lëscaʼ caní rnnaliʼ: “Channö nu bönniʼ gunëʼ le niʼa que bucugu láʼayi, bitiʼ gun bayudxi, pero channö gunëʼ le niʼa que gun zxoa lahui, bayudxi gun.” ");
INSERT INTO zarNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Libíʼiliʼ, nazídiliʼ, en nachul-la loliʼ. ¿Bízxilö nácarö lo? ¿Naruʼ gun zxoa láhuisö, o bucugu láʼayi naʼ run láʼayi gun naʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Que lë ni naʼ, channö nu bönniʼ runëʼ le niʼa que bucugu láʼayi, runëʼ le niʼa que le, encaʼ niʼa que yúguʼtë le zxóagaca láhuisö. ");
INSERT INTO zarNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Lëscaʼ caní, channö nu bönniʼ runëʼ le niʼa que yudoʼ, runëʼ le niʼa que le, encaʼ niʼa queëʼ Dios, nun cazëʼ xilatjëʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Lëscaʼ caní, channö nu bönniʼ runëʼ le niʼa que yehuaʼ yubá, runëʼ le niʼa que lataj ga röʼë rinná bëʼë Dios, encaʼ niʼa que Lë cazëʼ Dios röʼë niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Bicaʼ bayechiʼ libíʼiliʼ, bönniʼ yudoʼ usedi, encaʼ libíʼiliʼ, bönniʼ yudoʼ fariseo, bönniʼ ruluíʼisö tsahuiʼ cuinliʼ. Caní naca queë́liʼ tuʼ riguízxjaliʼ que yudoʼ tu cöʼ huéaj tuʼ chi cöʼ le rizíʼiliʼ que xöhuéaj, en que guixiʼ anís, en que comino laʼ huagu, pero rucáʼanaliʼ le nácarö lo le rinná bëʼ xibá queëʼ Dios, tuʼ cabí runliʼ le naca tsahuiʼ, en bitiʼ ruhuéchiʼ ládxiʼliʼ luzáʼaliʼ, en bitiʼ réajlëʼëliʼ-nëʼ Dios. Yuguʼ lë ni run bayudxi gunliʼ, en lës bitiʼ ucáʼanaliʼ iaʼzícaʼrö lë naʼ runliʼ, le riguízxjaliʼ que yudoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Libíʼiliʼ, nachul-la loliʼ, en rë́ʼëniliʼ uluíʼiliʼ nöza bönachi. Ca naʼ runliʼ naca ca rudö́diliʼ bödzádzadoʼ le réʼjaliʼ, rubéajgacaliʼ-baʼ bö́ʼiyudoʼ, pero rë́ʼjaliʼ-baʼ böaʼ taʼbíëʼ-baʼ bönniʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Bicaʼ bayechiʼ libíʼiliʼ, bönniʼ yudoʼ usedi, encaʼ libíʼiliʼ, bönniʼ yudoʼ fariseo, bönniʼ ruluíʼisö tsahuiʼ cuinliʼ. Nácaliʼ ca zxígaʼdoʼ réʼjaliʼ, en yö́ʼöna ráhuiliʼ. Riguíbiliʼ le nuáʼ cuita lëʼe, pero lu icja ládxiʼdoʼoliʼ nalí yuguʼ le ribanliʼ, en yuguʼ le ruáʼ döʼ runliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Libíʼiliʼ, bönniʼ yudoʼ fariseo lo chul-la. Zíʼalö guliʼquibi le nuáʼ lu zxígaʼdoʼ, en lu yö́ʼöna, lë naʼ saʼyéaj gácaliʼ tsahuiʼ lu icja ládxiʼdoʼoliʼ, para gácaliʼ caʼ tsahuiʼ cuita lë́ʼëliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Bicaʼ bayechiʼ libíʼiliʼ, bönniʼ yudoʼ usedi, encaʼ libíʼiliʼ, bönniʼ yudoʼ fariseo, bönniʼ ruluíʼisö tsahuiʼ cuinliʼ. Caní naca queë́liʼ tuʼ nácaliʼ ca yuguʼ yeru ba quégaca nupa chinátigaca, le nácagaca chiguíchidoʼos cuita lëʼe, en le nácatë lachi naláʼgaca, pero nalígaca dxita quégaca nupa chinátigaca, encaʼ yúguʼtë le siguti. ");
INSERT INTO zarNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Lëscaʼ caní nácaliʼ libíʼiliʼ. Le nácatë láhuisö ruluíʼi cuinliʼ tsahuiʼ lógaca bönachi, pero lu icja ládxiʼdoʼoliʼ naliliʼ yuguʼ le ruluíʼisö tsahuiʼ cuini, en le ruáʼ döʼ runliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Bicaʼ bayechiʼ libíʼiliʼ, bönniʼ yudoʼ usedi, encaʼ libíʼiliʼ, bönniʼ yudoʼ fariseo, bönniʼ ruluíʼisö tsahuiʼ cuinliʼ. Ruchísaliʼ biquitaj que ba gapa nagáchiʼgaquiëʼ bönniʼ guluʼë didzaʼ uláz queëʼ Dios, en ruíʼiliʼ biquitaj gapa nagáchiʼgaca bönachi tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Lëscaʼ caní rnnaliʼ: “Laʼtuʼ zóatuʼ dza niʼte cateʼ gulaʼcuʼë xuz xtóʼotuʼ, bitiʼ guntuʼ légaquiëʼ tsözxö́n cateʼ gulútiëʼ yuguʼ bönniʼ guluʼë didzaʼ uláz queëʼ Dios.” ");
INSERT INTO zarNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tuʼ rnnaliʼ caní, laʼ libíʼisiliʼ runliʼ ba nalí nácaliʼ zxíʼini xiʼsóagaca nupa niʼ bétigaca yuguʼ bönniʼ guluʼë didzaʼ uláz queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Caní naca, rusubagaʼ cuinliʼ xíguiaʼ naʼ gulaʼbáguiëʼ xuz xtóʼoliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Libíʼiliʼ naʼ, nácaliʼ ca yuguʼ bëla síniaʼ, en diʼa dza quégacabaʼ bëla síniaʼ. ¿Nacxi caz uláliʼ lu le usacaʼ ziʼ libíʼiliʼ lu guíʼ gabila? ");
INSERT INTO zarNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Que lë ni naʼ, nedaʼ isö́l-laʼa queë́liʼ yuguʼ bönniʼ iluʼë didzaʼ uláz queëʼ Dios, encaʼ yuguʼ bönniʼ taʼyéajniʼinëʼ, en yuguʼ bönniʼ usedi. Yuguʼ bönniʼ ni, bal-lëʼ gútiliʼ-nëʼ, en iaʼzícaʼrëʼ udáʼaliʼ lëʼe yaga cruz, en iaʼzícaʼrëʼ quinliʼ gapa naca lu yuʼu ga rudúbiliʼ rusë́daliʼ queëʼ Dios, ateʼ ulágaliʼ légaquiëʼ tu iaʼtú yödzö. ");
INSERT INTO zarNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Caní gaca, ibágaʼliʼ libíʼiliʼ xíguiaʼ que idútë rön quégaquiëʼ bönniʼ tsahuiʼ le gulalaj luyú, ga gudelaʼ nu bëti Abel, bönniʼ tsahuiʼ, ga ridxintë nupa bë́tigaca Zacarías, zxíʼinëʼ Berequías, bönniʼ naʼ bë́tiliʼ-nëʼ gatsaj láhuiʼlö ga dë yudoʼ, en ga dë bucugu láʼayi ga naʼ tuʼzéguiʼëʼ böaʼ bë́dxidoʼ lahuëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Le nácatë reaʼ libíʼiliʼ, yúguʼtë lë ni ilaʼbagaʼ bönachi nacuáʼ dza ni zóaruʼ naʼa. ");
INSERT INTO zarNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Lëscaʼ caní gunnë́ʼ Jesús: —Jerusalén, Jerusalén, libíʼiliʼ naʼ rútigacaliʼ-nëʼ bönniʼ tuʼë didzaʼ uláz queëʼ Dios, en ruládxiʼgacaliʼ guiö́j nupa nasö́l-lëʼë Dios. Zián luzuí gúʼunidaʼ utubaʼ libíʼiliʼ quiaʼ, ca runbaʼ yöjede, rutúbibaʼ bö́radoʼ queë́baʼ zxan xílibaʼ, pero bitiʼ gúʼuniliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Buliʼyútsöcaʼ, cáʼasö ugáʼana yuʼu lídxiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Caní gaca, tuʼ reaʼ libíʼiliʼ, naʼa isí lo bitiʼ uléʼeliʼ nedaʼ cateʼ innáröliʼ: “Láʼayi náquiëʼ Bönniʼ naʼ zëʼë uláz queëʼ Xanruʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Birúajëʼ Jesús chila yudoʼ, en tsanni niʼ rizë́ʼë niʼ, gulaʼbíguiʼë bönniʼ usëda queëʼ ga naʼ zoëʼ, ateʼ buluʼluíʼinëʼ Lëʼ ca nácagaca zöʼö nagúʼugaca lëʼa yudoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Bubiʼë didzaʼ Jesús, ateʼ rëʼ légaquiëʼ: —¿Riléʼetseliʼ yúguʼtë lë ni? Le nácatë reaʼ libíʼiliʼ, bitiʼ caʼ ugáʼana guiö́j nabagaʼ luzë́ʼe ni, le cabí iguínnaj. ");
INSERT INTO zarNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Cateʼ niʼ röʼë Jesús ga naca lu Guíʼa Yaga Olivo, bilaʼdxinëʼ bönniʼ usëda queëʼ ga naʼ zoëʼ queë́zëʼ, en tëʼ Lëʼ: —Gudíxjöiʼi netuʼ, ¿bátaxi ilaca lë ni, en bizxi gaca bëʼ dza huöduʼ, en dza údxi que yödzölió ni? ");
INSERT INTO zarNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Níʼirö bubiʼë didzaʼ Jesús, ateʼ rëʼ légaquiëʼ: —Buliʼyú para cabí nu siʼ yeʼe libíʼiliʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","tuʼ záʼgaquiëʼ zián bönniʼ lë́gaquiëʼ ca leaʼ nedaʼ. Ilaʼnnë́ʼ nácagaquiëʼ Cristo, en ilaʼzíʼ yéʼenëʼ bönachi zián. ");
INSERT INTO zarNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Huayö́niliʼ raca gudil-la, en le ruíʼi didzaʼ que gudil-la, pero bitiʼ cö́ʼöliʼ böniga, tuʼ ral-laʼ ilaca yúguʼtë lë ni, pero cabí ridxini dza údxi cateʼ ilácarö lë ni. ");
INSERT INTO zarNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Til-la tu yödzö len iaʼtú yödzö, ateʼ tu ga nu rinná bëʼ len iaʼtú ga nu rinná bëʼ. Ilatsaj yödzöhuë́ʼ zxön, en gaca gubín, ateʼ zián lataj tödi budóʼ zxuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yúguʼtë lë ni nácagaca le isí lógaca yuguʼ le ilaʼguíʼi ilaʼzacaʼ bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Níʼirö uluʼdödi bönachi libíʼiliʼ lu naʼ nu usacaʼ ziʼ libíʼiliʼ. Yúguʼtë bönachi uluʼdíʼi libíʼiliʼ tuʼ dáʼaliʼ nedaʼ, en ilútiëʼ bál-laliʼ libíʼiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Cateʼ gaca caní, gaca chopa ládxiʼgaca zián bönachi, en uluʼcáʼana nedaʼ, ateʼ udödi tu iaʼtú luzë́ʼe, en tu iaʼtú udíʼi luzë́ʼe. ");
INSERT INTO zarNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Níʼirö uluʼluíʼi lógaquiëʼ zián bönniʼ taʼzíʼ yëʼë. Uluʼluíʼi cuíngaquiëʼ ca yuguʼ bönniʼ tuʼë didzaʼ uláz queëʼ Dios, en ilaʼzíʼ yéʼenëʼ bönachi zián. ");
INSERT INTO zarNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Iluáʼadaʼ döʼ bönachi, ateʼ que lë ni naʼ bítiʼrö ilaʼdxíʼi böchiʼ luzéʼeguequi. ");
INSERT INTO zarNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nu guequi tsaz queëʼ Dios ga idxintë dza údxi, nu ni ulá. ");
INSERT INTO zarNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Idú yödzölió gaca libán que didzaʼ dxiʼa ca rinná bëʼë Dios para gaca ba nalí que lógaca yúguʼtë bönachi izáʼa, ateʼ níʼirö idxín dza údxi. ");
INSERT INTO zarNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","’Nu ulaba lë ni ral-laʼ uzéajniʼi ladxiʼ. Gunnë́ʼ Daniel, bönniʼ bëʼë didzaʼ uláz queëʼ Dios, gunnë́ʼ: “Tsaza le rudíʼinëʼ Dios lataj láʼayi queëʼ Dios, lë naʼ rusuniti.” Cateʼ iléʼeliʼ gaca caní, níʼirö nuliʼ zóaliʼ luyú Judea ral-laʼ tsöjzxúnnajliʼ sacaʼ guíʼadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nu dxía ícjoʼolö bitiʼ gal-laʼ huötaj tsöjzxíʼ bi dë que lu yuʼu, pero ral-laʼ izxúnnajtë. ");
INSERT INTO zarNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nu zoa laʼ guixiʼ, bitiʼ gal-laʼ huö́aj tsöjzxíʼ lariʼ que. ");
INSERT INTO zarNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Bicaʼ bayechiʼ yuguʼ nigula siʼ uluʼzóanu bíʼidoʼ quégacanu, encaʼ nigula niʼ tuʼgádxiʼnu-biʼ bíʼidoʼ quégacanu cateʼ idxín dza niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Buliʼlidzëʼ Dios inábiliʼ-nëʼ cabí idxín dza niʼ izxúnnajliʼ cateʼ raca beoʼ ziaga o cateʼ naca dza láʼayi, ");
INSERT INTO zarNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","tuʼ ilaʼguíʼi ilaʼzácaʼtërö bönachi dza niʼ ca gulaʼguíʼi gulaʼzacaʼ bönachi dza niʼte cateʼ siʼ gutaʼ gurö́ʼö yödzölió, ga ridxintë naʼa dza, en calëga dza záʼgaca bitiʼ ilaʼguíʼi ilaʼzacaʼ caní. ");
INSERT INTO zarNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Cateʼ idxín dza niʼ, channö Dios bitiʼ cuéqui lahuëʼ quégaquiëʼ, cuntu nu ulá, pero cuéqui lahuëʼ quégaquiëʼ dza niʼ, en gácalenëʼ nupa gurö́ cazëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Níʼirö bitiʼ tséajlëʼëliʼ channö nu idxín queë́liʼ, en guíë libíʼiliʼ: “Buliʼyútsöcaʼ, ni zoëʼ Cristo”, o inná: “Niʼ zoëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Uluʼluíʼi lógaquiëʼ zián bönniʼ taʼzíʼ yëʼë, en ilaʼnnë́ʼ nácagaquiëʼ Cristo, o ilaʼnnë́ʼ tuʼë didzaʼ uláz queëʼ Dios. Ilunëʼ le ilaca bëʼ, en le ilún ga uluʼbani bönachi, ateʼ ilaʼzíʼ yéʼenëʼ nupa gurö́ cazëʼ Dios channö hualaʼzéquiʼnëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Buliʼyútsöcaʼ, chigudxi cazaʼ libíʼiliʼ yúguʼtë lë ni zíʼatëlö ca siʼ ilaca. ");
INSERT INTO zarNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Que lë ni naʼ, bitiʼ irúajliʼ channö ilaʼdxín queë́liʼ nupa ilë́ libíʼiliʼ: “Buliʼyútsöcaʼ, niʼ zoëʼ Cristo lu lataj cáʼasö.” Lëscaʼ caní, bitiʼ tséajlëʼëliʼ channö ilaʼnná: “Buliʼyútsöcaʼ, lu yuʼu zoëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ca naʼ raca cateʼ rëpi yösa ga rilén gubidza, en ruzeníʼ ga ribía gubidza, lëscaʼ caní gaca cateʼ huödaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ilácatë caní, ca naʼ taʼnná bönachi: “Gátiʼtës ga dë tu le nati, niʼ uluʼdubi cázabaʼ bíchulab.” ");
INSERT INTO zarNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Gunnë́ʼ caʼ Jesús: —Tödi yuguʼ dza niʼ cateʼ ilaʼguíʼi ilaʼzacaʼ bönachi caní, ichul-la gubidza, ateʼ beoʼ bitiʼ gunna beníʼ que. Ilaʼguínnajbaʼ bölaj lúzxiba, ateʼ ilaʼzxízi le naláʼgaca naca tsutsu lúzxiba. ");
INSERT INTO zarNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Níʼirö iláʼ lahui lúzxiba le gaca bëʼ huödaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, ateʼ ilaʼbödxi yechiʼ yúguʼtë bönachi yödzölió ni, cateʼ ilaʼléʼe nedaʼ, Bönniʼ Guljëʼ Bönachi, suzáʼa lu böaj lúzxiba, dë lu naʼa yöl-laʼ unná bëʼ, en yöl-laʼ huáca zxön. ");
INSERT INTO zarNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Níʼirö isö́l-laʼgacaʼ-nëʼ gubáz láʼayi quiaʼ. Uluʼcödxëʼ zidzaj lúzubaʼ böaʼ guixiʼ, ateʼ uluʼtubëʼ nupa nabö́aʼ quiaʼ, nacuáʼ idapa laʼatë yödzölió, en yúguʼtë lataj zxan lúzxiba. ");
INSERT INTO zarNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Buliʼzéajniʼi ládxiʼliʼ le rusedi libíʼiliʼ le raca que yaga higo. Cateʼ taʼlén niʼa nëʼe yúludoʼ, en chirubía xilaguiʼ yúludoʼ, inö́ziliʼ chizóa idxín cusubá. ");
INSERT INTO zarNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Lëscaʼ caní, cateʼ iléʼeliʼ taca yúguʼtë lë ni, inö́ziliʼ chizóa idxín dza údxi naʼ, en chiridzaga lahui. ");
INSERT INTO zarNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Le nácatë reaʼ libíʼiliʼ, yúguʼtë lë ni ilaca zíʼatëlö ca ilátigaca bönachi nacuáʼ dza niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Huadödi quégaca lúzxiba, en luyú ni, pero yuguʼ xtídzaʼa bitiʼ ilaʼdödi cáʼasö. ");
INSERT INTO zarNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Cateʼ idxín dza niʼ cuntu nu nözi. Bitiʼ nö́zguequinëʼ gubáz láʼayi queëʼ Dios nacuʼë yehuaʼ yubá, en bitiʼ nözdaʼ nedaʼ, Zxíʼinëʼ Dios, pero tuzëʼ Dios Xuz nö́zinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Ca naʼ guca dza cateʼ niʼ zoëʼ Noé, lëscaʼ caní gaca cateʼ huödaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Yuguʼ dza niʼ zíʼatëlö ca siʼ idxín nisa guiö́j le busuniti yödzölió, gulëʼaj gulahuëʼ, buluʼtsaga náʼagaquiëʼ, en buluʼdödëʼ zxíʼinigaquiëʼ lu yöl-laʼ rutsaga naʼ ga bidxintë dza guyáziëʼ Noé lëʼe barco zxön niʼ benëʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","en bitiʼ guléquibeʼenëʼ cateʼ bidxintë nisa guiö́j le busuniti yödzölió, ateʼ gulaʼnítiëʼ yúguʼtëʼ. Lëscaʼ caní gaca cateʼ siʼ huödaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, cuntu nu guéquibeʼe. ");
INSERT INTO zarNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Dza huödaʼ ilaʼcuʼë chopëʼ bönniʼ laʼ guixiʼ. Tuëʼ uchëʼa-nëʼ quiaʼ, ateʼ iaʼtúëʼ ucáʼanaʼ-nëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ilaʼcuáʼanu chópanu nigula nacuáʼanu huëtu. Tunu uchëʼa-nu quiaʼ, ateʼ iaʼtunu ucáʼanaʼ-nu. ");
INSERT INTO zarNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Buliʼsubán ládxiʼliʼ tuʼ cabí nö́ziliʼ bizxi dza huödaʼ nedaʼ, Xanliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Naʼa, guliʼtséajniʼi lë ni. Laʼtuʼ nö́zinëʼ xan yuʼu bizxi dza guídëʼ gubán, huanë́ʼë yëla, en bitiʼ guʼë lataj nu quidaj zöʼö para cuan le dzöʼö lidxëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Que lë ni naʼ, buliʼsubán ládxiʼliʼ caʼ libíʼiliʼ, tuʼ huödaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, tu dza bitiʼ nuzóa icjaliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Gunnë́ʼ caʼ Jesús: —¿Nuzxi caz bönniʼ huen dxin náquiëʼ tsahuiʼ, en réajniʼinëʼ, bönniʼ huen dxin naʼ, xanëʼ cuʼë lu nëʼë bönachi nacuáʼ lidxëʼ para guʼë le ilágugaca cateʼ idxín dza? ");
INSERT INTO zarNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Bicaʼ ba bönniʼ huen dxin naʼ náquiëʼ tsahuiʼ, bönniʼ naʼ, cateʼ udxinëʼ xanëʼ, uduxáquiëʼ lëʼ caní runëʼ le nudödëʼ xanëʼ lu nëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Le nácatë reaʼ libíʼiliʼ, yúguʼtë le dë queëʼ xanëʼ, udödëʼ lu nëʼë bönniʼ huen dxin naʼ runëʼ caní. ");
INSERT INTO zarNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Channö huöáquiëʼ bönniʼ huen dxin queëʼ huiáʼ döʼ, en saʼ ládxëʼë, innë́ʼ: “Huadzenëʼ xanaʼ, en bitiʼ huö́datiëʼ”, ");
INSERT INTO zarNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","en channö isí lahuëʼ gundëʼ ziʼ bönniʼ túnlenëʼ lëʼ tsözxö́n dxin, en isí lahuëʼ caʼ guíʼaj gágulenëʼ nupa taʼzudxi, ");
INSERT INTO zarNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","níʼirö huödëʼ xanëʼ bönniʼ huen dxin naʼ tu dza cateʼ bitiʼ zoëʼ ribözëʼ, o tu yëla bitiʼ réquinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Níʼirö xanëʼ naʼ usacaʼ zíʼdëʼë bönniʼ huen dxin naʼ, en gunëʼ ga gaca queëʼ ca naʼ ral-laʼ gaca quégaca nupa tuʼluíʼisö tsahuiʼ cuínguequi. Níʼirö cödxi yechë́ʼë, en gagu zxea láyëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Gunnë́ʼ caʼ Jesús: —Ca gaca quégaca nupa ilaʼyaza ga rinná bëʼë Dios yehuaʼ yubá naca ca guca quégacabiʼ chibiʼ biʼi nigula raʼbandoʼ. Gulaʼzíʼibiʼ le nuáʼgaca guíʼ quégacabiʼ, ateʼ bilaʼrúajbiʼ tsöjtságagacabiʼ bönniʼ utsaga nëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Gáyuʼbiʼ nácagacabiʼ biʼi bitiʼ taʼyéajniʼibiʼ ateʼ iaʼgáyuʼbiʼ nasínaʼgacabiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Yuguʼ biʼi nigula bitiʼ taʼyéajniʼibiʼ naʼ gulaʼzíʼibiʼ le nuáʼgaca guíʼ quégacabiʼ pero bitiʼ guluáʼabiʼ iaʼlatiʼ za régui. ");
INSERT INTO zarNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yuguʼ biʼi sinaʼ naʼ guluáʼabiʼ za régui lu bö́gaʼdoʼ quégacabiʼ len le nuáʼgaca guíʼ quégacabiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tuʼ gudzenëʼ bönniʼ utsaga nëʼë, gudödi yëla lógacabiʼ, en gulásitëbiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Cateʼ bidxín idú guluhuëla, biyö́n chiʼi nu rinnë́ zidzaj, rnna: “¡Chizë́ʼë bönniʼ utsaga nëʼë! ¡Guliʼrúaj tsöjtságaliʼ-nëʼ!” ");
INSERT INTO zarNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Níʼirö gulaʼyásabiʼ yúguʼtëbiʼ biʼi nigula naʼ, ateʼ buluʼpáʼabiʼ le nuáʼgaca guíʼ quégacabiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Guluíʼibiʼ didzaʼ biʼi bitiʼ taʼyéajniʼibiʼ naʼ, en gulëbiʼ yuguʼ biʼi sinaʼ naʼ: “Guliʼgunna queë́tuʼ látiʼdoʼ za régui queë́liʼ tuʼ tuʼúlu le nuáʼgaca guíʼ queë́tuʼ ni.” ");
INSERT INTO zarNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Buluʼbíʼibiʼ didzaʼ biʼi sinaʼ naʼ, gulaʼnnabiʼ: “Bitiʼ gaca, tuʼ cabí bi ugáʼana queë́tuʼ, en queë́liʼ. Guliʼtséajtsöcaʼ ga ridóʼo za régui, tsöjö́ʼuliʼ queë́liʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tsanni niʼ söjácabiʼ söjxíʼgacabiʼ le, bidxinëʼ bönniʼ utsaga nëʼë. Yuguʼ biʼi naʼ nacuáʼabiʼ sinaʼ, en taʼbö́zabiʼ lëʼ gulaʼyúʼulentëbiʼ lëʼ ga naʼ raca laní que utsaga naʼ, ateʼ laʼ guyáyajtë yuʼu. ");
INSERT INTO zarNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Gudödi niʼ iaʼzícaʼröbiʼ biʼi nigula raʼbandoʼ naʼ bilaʼdxinbiʼ niʼ, ateʼ buluʼlídzabiʼ-nëʼ, en gulaʼnnabiʼ: “Xan, Xan, gusalaj queë́tuʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Lëʼ bubiʼë didzaʼ, rnnëʼ: “Le nácatë reaʼ libíʼiliʼ, bitiʼ nözdaʼ gazxi libíʼiliʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Níʼirö Jesús gudxëʼ légaquiëʼ: —Buliʼsubán ládxiʼliʼ, tuʼ cabí nö́ziliʼ bizxi dza o bizxi yëla huödaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Gunnë́ʼ caʼ Jesús: —Ca gun Nu naʼ rinná bëʼ yehuaʼ yubá naca ca benëʼ tu bönniʼ, chizóa tsejëʼ ziʼtuʼ. Bulidzëʼ yuguʼ bönniʼ huen dxin queëʼ en guluʼë yuguʼ le dë queëʼ lu náʼagaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Tuëʼ bönniʼ huen dxin naʼ, guluʼë gayuʼ dumí nazacaʼ lu nëʼë, ateʼ iaʼtúëʼ guluʼë chopa dumí nazacaʼ lu nëʼë. Iaʼtúëʼ guluʼë tu dumí nazacaʼ lu nëʼë. Tu tuëʼ guluʼë lu nëʼë tsca huéaj le ilaʼzéquiʼnëʼ. Níʼirö laʼ guzáʼatëʼ ga naca ziʼtuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Guyijëʼ bönniʼ huen dxin naʼ guzxiʼë gayuʼ dumí nazacaʼ naʼ, en yöjtíljalenëʼ le iaʼgayuʼ dumí nazacaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Lëscaʼ caní, bönniʼ naʼ guzxiʼë chopa dumí naʼ, yöjtíljalenëʼ le iaʼchopa caʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bönniʼ naʼ guzxiʼë tu dumí guyijëʼ, en yöjchö́ʼönëʼ lu yu, ateʼ bucáchëʼë dumí queëʼ xanëʼ lu yu niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Cateʼ chigudzé, budxinëʼ xángaquiëʼ bönniʼ huen dxin naʼ, ateʼ bucáʼanalenëʼ légaquiëʼ tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ga gusí lo bidxintëʼ bönniʼ naʼ guzxiʼë gayuʼ dumí nazacaʼ naʼ, en sunuʼë iaʼgayuʼ dumí caʼ, ateʼ rëʼ xanëʼ: “Xan, gayuʼ dumí gulúʼu lu naʼa. Ni dë iaʼgayuʼ dumí caʼ yöjtíljalenaʼ le.” ");
INSERT INTO zarNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Xanëʼ naʼ rëʼ lëʼ: “Naca dxiʼa. Nacuʼ huen dxin tsahuiʼ. Tsáhuiʼdoʼ benuʼ cateʼ ni dë lu noʼo látiʼdoʼos. Naʼa yénniʼtërö cuʼa lu noʼo. Guyaza ga zoaʼ, udzéjalenuʼ nedaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Gudödi niʼ bidxinëʼ caʼ bönniʼ huen dxin naʼ guzxiʼë chopa dumí nazacaʼ, ateʼ rnnëʼ: “Xan, chopa dumí gulúʼu lu naʼa. Ni dë iaʼchopa dumí caʼ yöjtíljalenaʼ le.” ");
INSERT INTO zarNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Níʼirö xanëʼ naʼ rëʼ lëʼ: “Naca dxiʼa. Nacuʼ huen dxin tsahuiʼ. Tsáhuiʼdoʼ benuʼ cateʼ ni dë lu noʼo látiʼdoʼos. Naʼa, yénniʼtërö cuʼa lu noʼo. Guyaza ga zoaʼ, udzéjalenuʼ nedaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Níʼirö cateʼ bidxinëʼ bönniʼ huen dxin naʼ guzxiʼë tu dumí nazacaʼ naʼ, rnnëʼ: “Xan, nözdaʼ nacuʼ bönniʼ bizxaj, tuʼ rulapuʼ ga bitiʼ guzuʼ, en rutubuʼ ga bitiʼ guchiljuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Que lë ni naʼ gúdxidaʼ liʼ, ateʼ guyijaʼ, yöjcáchaʼa dumí quiuʼ lu yu. Ni dë naʼa le nequi quiuʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Níʼirö bubiʼë didzaʼ xanëʼ, en rëʼ lëʼ: “Nacuʼ huen dxin bitiʼ naca tsahuiʼ, en xöhuëdi. Nöz quézinuʼ rulapaʼ ga bitiʼ guzaʼ, en rutubaʼ ga bitiʼ guchiljaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Que lë ni naʼ, gácarö dxiʼa quiuʼ laʼtuʼ bunödzjuʼ dumí quiaʼ lu náʼagaquiëʼ bönniʼ uluʼgunëʼ le dxin, ilaʼguíljalenëʼ le iaʼlatiʼ, para cateʼ huödaʼ nedaʼ, uziʼa le nequi quiaʼ len icja caʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Níʼirö xanëʼ naʼ gudxëʼ nupa nacuáʼ niʼ: “Guliʼcúa dumí naʼ dë lu nëʼë bönniʼ ni, en guliʼcúʼu le lu nëʼë bönniʼ naʼ dë queëʼ chi dumí.” ");
INSERT INTO zarNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nútiʼtës nu rugún tsahuiʼ dxin le dë queëʼ, zoa nu unödzaj queëʼ iaʼlatiʼ, ateʼ gátaʼdaʼ queëʼ, pero nu naʼ bitiʼ rugún tsahuiʼ dxin le dë lu nëʼe, laʼs dui le dë queëʼ idúa. ");
INSERT INTO zarNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Naʼa, bönniʼ huen dxin bitiʼ naca tsahuiʼ ni, guliʼtsöjchúʼuna-nëʼ níʼilö ga naca chul-la. Niʼ cödxi yéchëʼë, en gagu zxea láyëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Gunnë́ʼ caʼ Jesús: —Cateʼ niʼ huödaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, idinná bëʼa, ateʼ dzágagaquiëʼ nedaʼ yúguʼtë gubáz láʼayi quiaʼ, níʼirö cöʼa lataj tsahuiʼ quiaʼ, ga naʼ uchiʼa usörö́aʼ quégaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Uluʼdubi dërö lahuaʼ nedaʼ bönachi yödzölió ni, ateʼ ucuʼa léguequi tsöláʼa huéaj ca runëʼ bönniʼ uyú böʼcuʼ zxilaʼ, rucuʼë-baʼ tsöláʼa huéajbaʼ yuguʼ chivo, en yuguʼ böʼcuʼ zxilaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yuguʼ böʼcuʼ zxilaʼ naʼ ucuʼë-baʼ cuita lëʼë ibëla, ateʼ yuguʼ chivo naʼ ucuʼë-baʼ cuita lëʼë yö́göla. ");
INSERT INTO zarNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Níʼirö, nedaʼ, bönniʼ unná bëʼ, guíaʼ nupa nacuáʼ cuita lëʼa ibëla, inníaʼ: “Guliʼdá ga zoaʼ, libíʼiliʼ bubéajëʼ Xuzaʼ libíʼiliʼ quez queëʼ. Nequi queë́liʼ lataj ga naʼ rinná bëʼë, lë naʼ bupë́ʼë queë́liʼ dza niʼte cateʼ niʼ benëʼ yödzölió. ");
INSERT INTO zarNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Caní nequi queë́liʼ tuʼ gudunaʼ, ateʼ bénnaliʼ le gudahuaʼ. Gubidxaʼ nisa, ateʼ bénnaliʼ le guʼa. Gucaʼ ca tu bönniʼ ridá ziʼtuʼ, ateʼ gulúʼuliʼ nedaʼ lídxiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Biyadzaj le gácuaʼ, ateʼ bugáculiʼ nedaʼ le ráculiʼ. Güíʼidaʼ, ateʼ buduyúliʼ nedaʼ. Guyuʼa lidxi guíë, ateʼ buduyúliʼ nedaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Níʼirö uluʼbiʼë didzaʼ bönniʼ tsahuiʼ naʼ, ilë́ʼ nedaʼ: “Xan, ¿bátaxi biléʼetuʼ Liʼ gudunuʼ, ateʼ bugágutuʼ Liʼ? ¿Bátaxi gubidxuʼ, ateʼ bénnatuʼ le guʼu? ");
INSERT INTO zarNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Bátaxi biléʼetuʼ Liʼ gudóʼ ziʼtuʼ, ateʼ gulúʼutuʼ Liʼ lídxituʼ? ¿Bátaxi biyadzaj le gacuʼ, ateʼ bugácutuʼ Liʼ le rácutuʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Bátaxi biléʼetuʼ Liʼ güíʼinuʼ, o guyúʼu lidxi guíë, ateʼ buduyútuʼ Liʼ?” ");
INSERT INTO zarNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ubiʼa didzaʼ nedaʼ, bönniʼ unná bëʼ, ateʼ guíaʼ légaquiëʼ: “Le nácatë reaʼ libíʼiliʼ, tuʼ benliʼ caní queëʼ nu bönniʼ bö́chaʼadoʼ ni, sal-laʼ náquiëʼ bönniʼ cáʼasö, quiaʼ nedaʼ caz benliʼ caʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Níʼirö guíaʼ nupa nacuáʼ cuita lëʼa yö́göla, inníaʼ: “Guliʼcuíta ga zoaʼ, libíʼiliʼ naʼ nabágaʼliʼ xíguiaʼ, tsöjtsázaliʼ lu guíʼ naʼ bitiʼ ulu, lë naʼ bupë́ʼë Dios niʼa que tuʼ xihuiʼ, en quéguequi gubáz dáʼgaca le. ");
INSERT INTO zarNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Caní gaca queë́liʼ tuʼ gudunaʼ, ateʼ bitiʼ bénnaliʼ le gahuaʼ. Gubidxaʼ nisa, ateʼ bitiʼ bénnaliʼ le guíʼjaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Gucaʼ ca bönniʼ ridë́ʼ ziʼtuʼ, ateʼ bitiʼ gulúʼuliʼ nedaʼ lídxiliʼ. Biyadzaj le gácuaʼ, ateʼ bitiʼ bugáculiʼ nedaʼ le ráculiʼ. Güíʼidaʼ, encaʼ guyuʼa lidxi guíë, ateʼ bitiʼ buduyúliʼ nedaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Níʼirö ilaʼnná caʼ nupa naʼ, ilë́ nedaʼ: “Xan, ¿bátaxi biléʼetuʼ Liʼ gudunuʼ, o gubidxuʼ, o gucuʼ ca bönniʼ ridë́ʼ ziʼtuʼ, o biyadzaj le gacuʼ, o güíʼinuʼ, o guyúʼu lidxi guíë, ateʼ bitiʼ gúcalentuʼ Liʼ?” ");
INSERT INTO zarNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Níʼirö ubiʼa didzaʼ nedaʼ, bönniʼ unná bëʼ, guíaʼ légaquiëʼ: “Le nácatë reaʼ libíʼiliʼ, tuʼ cabí bi benliʼ que tu nu nutsaʼ ladaj nupa nacuáʼ ni, sal-laʼ naca cáʼasö nu naʼ, bitiʼ bi benliʼ quiaʼ nedaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Níʼirö bönachi tuáʼ döʼ naʼ laʼ tsöjtsázagacatë ga niʼ ilaʼguíʼi ilaʼzácaʼticaʼsö, pero bönachi tsahuiʼ niʼ gataʼ yöl-laʼ naʼbán idú quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Cateʼ budxi bëʼë Jesús yuguʼ didzaʼ ni, gudxëʼ yuguʼ bönniʼ usëda queëʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","rnnëʼ: —Nöz quéziliʼ iaʼchopa dza idxín Laní Pascua, ateʼ dza naʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, uluʼdödëʼ nedaʼ lu náʼagaca nupa uluʼdáʼ nedaʼ lëʼe yaga cruz. ");
INSERT INTO zarNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Níʼirö bilaʼdxinëʼ yuguʼ bixúz unná bëʼ len yuguʼ bönniʼ yudoʼ usedi, en bönniʼ gula tuʼzéajniʼinëʼ bönachi judío, ateʼ buluʼdubëʼ ga naca löʼa lidxi bixúz lo, lëʼ Caifás. ");
INSERT INTO zarNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Niʼ gulún xtídzaʼgaquiëʼ ilaʼzönëʼ Jesús, lu yöl-laʼ rizíʼ yëʼ quégaquiëʼ, para ilútiëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Taʼnnë́ʼ: —Bitiʼ gunruʼ lë ni dza laní, para cabí ilaʼdzatsa bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Cateʼ niʼ zoëʼ Jesús lu yödzö Betania lu yuʼu lidxëʼ Simón, bönniʼ naʼ güíʼinëʼ huëʼ nudzuʼ ruzödi, ");
INSERT INTO zarNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","bidxinnu cúdzuʼlëʼ Jesús tu nigula, nuáʼanu tu bö́gaʼdoʼ néquini guiö́j nazacaʼ, en yudzu tu le riláʼ zxixi le nazácaʼdaʼ, ateʼ gulúʼunu le icjëʼ Jesús cateʼ niʼ röʼë rahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Cateʼ bilaʼléʼenëʼ bönniʼ usëda queëʼ Jesús lë ni, gulaʼlenëʼ, taʼnnë́ʼ: —¿Bizx que réqui ditaj lë ni? ");
INSERT INTO zarNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Guca nu gutiʼ lë ni, en siʼ dumí zián para gácalenruʼ yuguʼ bönachi yechiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Cateʼ biyönnëʼ Jesús lë ni, rëʼ légaquiëʼ: —¿Bizx que rnnëliʼ queë́nu nigula ni? Tsahuiʼ naca le bennu quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yuguʼ bönachi yechiʼ ilaʼcuáʼlenticaʼsö libíʼiliʼ, pero nedaʼ bitiʼ ugáʼanalenticaʼsaʼ libíʼiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Le bennu nigula ni, gulúʼunu nedaʼ le riláʼ zxixi ni, naca le rupáʼanu nedaʼ para dza igáchaʼa yeru ba. ");
INSERT INTO zarNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Le nácatë reaʼ libíʼiliʼ, gátiʼtës luyú yödzölió ga gaca libán que didzaʼ dxiʼa ni, lëscaʼ ilaʼguixjöʼ bönachi le bennu nigula ni quiaʼ para nu tsöjné lënu. ");
INSERT INTO zarNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Níʼirö guyijëʼ Judas Iscariote ga naʼ nacuʼë bixúz unná bëʼ. Náquiëʼ bönniʼ dzáguiëʼ chínnuëʼ naʼ dáʼgaquiëʼ Jesús, ");
INSERT INTO zarNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ateʼ gudxëʼ légaquiëʼ: —¿Bizxi gúnnaliʼ quiaʼ channö nedaʼ udödaʼ-nëʼ Jesús lu náʼaliʼ? Buluʼgáʼanalenëʼ lëʼ tsahuiʼ iluʼë lëʼ chi uruáʼ dumí plata. ");
INSERT INTO zarNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Níʼirö gusí lahuëʼ Judas naʼ risí riböʼë udödëʼ Jesús lu náʼagaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Cateʼ naca dza risí lo laní quégaquiëʼ bönniʼ judío cateʼ tahuëʼ yöta xtila le cabí nazíʼi cúa zi que, gulaʼbíguiʼë bönniʼ usëda queëʼ Jesús ga zoëʼ, en tëʼ Lëʼ: —¿Gazxi rë́ʼënuʼ tsöjpáʼatuʼ queë́ruʼ para gáguruʼ-baʼ böʼcuʼ zxílaʼdoʼ dzöʼ Laní Pascua? ");
INSERT INTO zarNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesús rëʼ légaquiëʼ: —Guliʼtséajtsöcaʼ yödzö niʼ ga naʼ zoëʼ tu bönniʼ, en guliʼguíëʼ: “Bönniʼ rusédinëʼ netuʼ rnnëʼ: Chizáʼ galaʼ dza quiaʼ. Lu yuʼu lidxuʼ gágulengacaʼ-nëʼ bönniʼ usëda quiaʼ böʼcuʼ zxílaʼdoʼ dzöʼ Laní Pascua.” ");
INSERT INTO zarNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Níʼirö gulunëʼ bönniʼ usëda queëʼ ca naʼ gunná béʼenëʼ Jesús légaquiëʼ, ateʼ buluʼpë́ʼë le ilahuëʼ dzöʼ Laní Pascua. ");
INSERT INTO zarNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Cateʼ chigudzö́ʼ dza naʼ, Jesús gurö́ʼlenëʼ idxínnutëʼ bönniʼ usëda queëʼ tahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tsanni niʼ tahuëʼ, Jesús rëʼ légaquiëʼ: —Le nácatë reaʼ libíʼiliʼ, tu nu nutsaʼ ládjaliʼ ni udödi nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Níʼirö buluʼhuíʼini ládxiʼgaquiëʼ, en gulaʼnábinëʼ Jesús tu tuëʼ, taʼnnë́ʼ: —Xan, ¿naruʼ nedaʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Bubiʼë didzaʼ Jesús, rnnëʼ: —Bönniʼ ni runë́ʼ nëʼë tsözxö́n len naʼa lu yö́ʼöna, bönniʼ ni udödëʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Le nácatë nedaʼ, Bönniʼ Guljëʼ Bönachi, uyijaʼ ga gátiaʼ ca naʼ nazúaj lu guichi láʼayi ca ral-laʼ gaca quiaʼ, pero bicaʼ bayechiʼ nu naʼ udödi nedaʼ gátiaʼ. Gácarö dxiʼa queëʼ bönniʼ naʼ laʼ cabí guljëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Níʼirö bubiʼë didzaʼ Judas, bönniʼ naʼ udödëʼ Jesús, rnnëʼ: —Bönniʼ Usedi, ¿naruʼ nedaʼ? Jesús rëʼ lëʼ: —Ön, liʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tsanni niʼ tahuëʼ, gudélëʼë Jesús yöta xtila, en gudxëʼ Dios: “Xclenuʼ.” Níʼirö buzxuzxjëʼ le, en bunödzjëʼ quégaquiëʼ bönniʼ usëda queëʼ, rnnëʼ: —Guliʼsíʼ, guliʼgagu. Lë ni le naca cazaʼ. Ca benaʼ que yöta xtila ni ruluíʼi ca gaca que le naca cazaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Gudélëʼë caʼ tu zxígaʼdoʼ, en gudxëʼ Dios: “Xclenuʼ.” Níʼirö bunödzjëʼ caʼ quégaquiëʼ, rnnëʼ: —Guliʼguiʼaj yúguʼtëliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Lë ni ruluíʼi ca naca xichönaʼ le run tsutsu didzaʼ cubi rucáʼana tsahuiʼ. Xichönaʼ naʼ ilalaj niʼa quégaca bönachi zián para gaca uniti lahuëʼ Dios yuguʼ dul-laʼ nabágaʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Reaʼ caʼ libíʼiliʼ, bítiʼrö guíʼjaʼ xisi le ribía lubá uva ni cateʼ idxinrö dza niʼ guíʼjalenaʼ libíʼiliʼ tu le cubi ga niʼ rinná bëʼë Xuzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Cateʼ budxi gulúl-lëʼ yöl-laʼ ba queëʼ Dios, yöjáquiëʼ lu Guíʼa Yaga Olivo. ");
INSERT INTO zarNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Níʼirö Jesús rëʼ légaquiëʼ: —Yúguʼtëliʼ gaca chopa ládxiʼliʼ, en ucáʼanaliʼ nedaʼ naʼa dzöʼ ni, tuʼ nazúaj lu guichi láʼayi ca gaca quiaʼ, le rnna: “Gunaʼ ga gátiëʼ Bönniʼ Uyú Böʼcuʼ Zxilaʼ, ateʼ ilásilasibaʼ böʼcuʼ zxilaʼ naʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Cateʼ ubanaʼ lu yöl-laʼ guti, níʼirö tséajaʼ tsöjnö́ruaʼ loliʼ sacaʼ luyú Galilea. ");
INSERT INTO zarNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Níʼirö bubiʼë didzaʼ Pedro, en rëʼ Jesús: —Salaʼ ilaca chopa ládxiʼgaquiëʼ, en uluʼcáʼanëʼ yúguʼtëʼ Liʼ, nedaʼ bitiʼ gaca chopa ládxaʼa, bitiʼ ucáʼanaʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús gudxëʼ lëʼ: —Le nácatë reaʼ liʼ, naʼa dzöʼ ni, cateʼ siʼ cö́dxilöbaʼ böra, liʼ innóʼ tsonna luzuí bitiʼ núnbëʼu nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Níʼirö Pedro gudxëʼ Jesús: —Sal-laʼ gátilenteaʼ Liʼ, bitiʼ caʼ inníaʼ bitiʼ núnbëʼa Liʼ. Lëscaʼ caní gulaʼnnë́ʼ yúguʼtë bönniʼ usëda queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Níʼirö Jesús bidxínlenëʼ légaquiëʼ laʼ yëla Getsemaní, ateʼ gudxëʼ yuguʼ bönniʼ usëda queëʼ naʼ, rnnëʼ: —Guliʼcö́ʼtsöcaʼ ni tsanni tséajaʼ iaʼlatiʼ níʼilö, tsöjlidzaʼ-nëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesús guchë́ʼë Pedro len iropëʼ zxíʼinëʼ Zebedeo, ateʼ gusí lahuëʼ ruhuíʼinnëʼ, en risëbi ládxëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Níʼirö Jesús gudxëʼ légaquiëʼ: —Ruhuíʼini ládxaʼa, en huáti cazaʼ lu yöl-laʼ risëbi ladxiʼ. Guliʼgáʼana ni, en guliʼnáʼ yëla tsözxö́n len nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Gudödëʼ Jesús iaʼlátiʼdoʼ níʼilö, ateʼ niʼ biyéchuëʼ. Busudxín lahuëʼ lu yu, en bulidzëʼ Dios, gunnë́ʼ: —Xuzaʼ, channö huáca, ben ga bitiʼ gun bayudxi quiʼi sacaʼa lë ni, calëga ca rë́ʼëndaʼ nedaʼ, pero ca rë́ʼënuʼ Liʼ gunuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Cateʼ budxinëʼ Jesús ga naʼ nacuʼë bönniʼ usëda queëʼ, yöjxáquiëʼ légaquiëʼ tasiëʼ, ateʼ rëʼ Pedro: —¿Naruʼ cabí gúcatsö ináʼalenuʼ nedaʼ tsözxö́n yëla tu chíʼidoʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Guliʼnáʼ yëla, en buliʼlidzëʼ Dios inábiliʼ-nëʼ gácalenëʼ libíʼiliʼ, para cabí güíʼiliʼ Satanás tuʼ xihuiʼ lataj siʼ bëʼ libíʼiliʼ le xihuiʼ. Böʼ naca cázaliʼ nasínaʼticaʼsö, pero lu yöl-laʼ bönáchisö queë́liʼ nacuídiʼliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Níʼirö guyijëʼ Jesús le buropi luzuí, en bulidzëʼ Dios, rnnëʼ: —Xuz, channö cabí gaca gunuʼ ga bitiʼ quiʼi sacaʼa lë ni, ben ca raza ládxuʼu Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Cateʼ bö́ajëʼ, leyúbölö buduxaquiëʼ légaquiëʼ tasiëʼ tuʼ nadö́dirö yëla guiö́j lógaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Níʼirö bucáʼanëʼ Jesús légaquiëʼ, ateʼ guyijëʼ leyúbölö, en bulidzëʼ Dios le bunni luzuí, ateʼ tuz ca gunnë́ʼ zíʼalö rnnëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Leyúbölö bö́ajëʼ ga naʼ nacuʼë bönniʼ usëda queëʼ, en rëʼ légaquiëʼ: —¿Rásitsaliʼ naʼa, en ruziʼtsö ládxiʼliʼ? Buliʼyútsöcaʼ, chibudzaga lo. Nedaʼ, Bönniʼ Guljëʼ Bönachi, chinadödaʼ lu náʼagaquiëʼ bönniʼ dul-laʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Guliʼchasa, uyéajruʼ! Buliʼyútsöcaʼ, bönniʼ naʼ rudödëʼ nedaʼ chibidxinëʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tsanni niʼ ruʼë Jesús didzaʼ ni, Judas, bönniʼ nabábalenëʼ idxínnutëʼ naʼ, laʼ bidxintëʼ niʼ, ateʼ dzágagaquiëʼ bönniʼ zián lëʼ, nuáʼagaquiëʼ guíë tuchiʼ, en yuguʼ yágadoʼ. Yuguʼ bixúz unná bëʼ, en bönniʼ gula tuʼzéajniʼinëʼ bönachi judío nasö́l-laʼgaquiëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas, bönniʼ naʼ rudödëʼ Jesús, chibuluíʼinëʼ légaquiëʼ tu le gunëʼ le gaca bëʼ nu naca Jesús, gunnë́ʼ: —Bönniʼ naʼ utsaga lahuaʼ-nëʼ, Lëʼ naʼ Jesús. Guliʼsönëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Níʼirö gubíguiʼë Judas ga naʼ zoëʼ Jesús, rnnëʼ: —Padiux, Bönniʼ Usedi. Níʼirö laʼ busudxín lotëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús rëʼ lëʼ: —Böchaʼa, ¿bizxi huen zoʼo ni? Níʼirö gulaʼbiguëʼë bönniʼ naʼ, ateʼ gulaʼzönëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tuëʼ bönniʼ dzáguiëʼ Jesús gulecjëʼ guíë tuchiʼ queëʼ, en benëʼ huëʼ, guchúguiëʼ guídi náguiëʼ bönniʼ huen dxin queëʼ bixúz lo. ");
INSERT INTO zarNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús gudxëʼ lëʼ: —Bugúʼ guíë tuchiʼ quiuʼ lidxi. Yúguʼtë nupa tuʼdíʼini guíë tuchiʼ, lu guíë tuchiʼ ilátigaca. ");
INSERT INTO zarNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Naruʼ cabí nö́zinuʼ huáca ulidzaʼ Xuzaʼ, ateʼ Lëʼ laʼ isö́l-laʼtëʼ ziántërö ca chinnu cöʼ gubáz láʼayi le naca zián gáyuʼë tu cöʼ huéaj? ");
INSERT INTO zarNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Channö gunaʼ caní, ¿nacxi gaca udxín le nazúaj lu guichi láʼayi, le rnna caní ral-laʼ gaca quiaʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Níʼirö Jesús gudxëʼ yuguʼ bönniʼ niʼ: —¿Birúajtsaliʼ nuáʼaliʼ guíë tuchiʼ, en yágadoʼ para sönliʼ nedaʼ ca runliʼ rizönliʼ-nëʼ gubán? Yuguʼ dza guröʼa loliʼ ga naca lu chila yudoʼ, en busédigacadaʼ bönachi, pero bitiʼ guzxönliʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Raca caní yúguʼtë lë ni para udxín le nazúaj lu guichi láʼayi, ca naʼ gulaʼnnë́ʼ bönniʼ guluʼë didzaʼ uláz queëʼ Dios. Níʼirö yúguʼtë bönniʼ usëda queëʼ Jesús buluʼcáʼanëʼ Lëʼ, en buluʼzxúnnajëʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Níʼirö yuguʼ bönniʼ naʼ zö́ngaquiëʼ Jesús gulaʼchë́ʼë Lëʼ, ateʼ bilaʼdxinëʼ lahuëʼ Caifás, bixúz lo, ga niʼ nudúbigaquiëʼ caʼ yuguʼ bönniʼ yudoʼ usedi len bönniʼ gula tuʼzéajniʼinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro söjnáhuëʼ Jesús ziʼtuʼ zíʼtuʼsö, en bidxinëʼ ga naca löʼa lidxi bixúz lo naʼ, para iléʼenëʼ nacxi utságuiëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Yuguʼ bixúz unná bëʼ len bönniʼ gula tuʼzéajniʼinëʼ, en bönniʼ yudoʼ tuʼchiʼa tuʼsörö́ëʼ, buluʼguiljëʼ nu uzegui Jesús didzaʼ sal-laʼ siʼ yëʼë bönniʼ naʼ, para gaca ilaʼchúguiëʼ queëʼ gátiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Cuntu nu bilaʼdzö́linëʼ sal-laʼ bilaʼdxinëʼ bönniʼ zián, en gulaʼnnë́ʼ queëʼ le cabí nácatë. Ga búdxitë bilaʼdxinëʼ chopëʼ bönniʼ, ateʼ lu yöl-laʼ rizíʼ yëʼ quégaquiëʼ gulaʼnnë́ʼ queëʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","taʼnnë́ʼ: —Bönniʼ ni gunnë́ʼ: “Huaca uquínnajaʼ yudoʼ queëʼ Dios, ateʼ uchisaʼ le iaʼtsonna dzasö.” ");
INSERT INTO zarNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Níʼirö guzuínëʼ bixúz lo naʼ, en rëʼ Jesús: —¿Naruʼ cabí rubíʼitsoʼ didzaʼ? ¿Bizxi caz lë ni taʼnnë́ʼ bönniʼ ni quiuʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús bitiʼ bi gunnë́ʼ. Níʼirö bixúz lo gudxëʼ Lëʼ: —Niʼa queëʼ Xanruʼ Dios ban rinná béʼedaʼ Liʼ quíxjöʼu le nácatë. Gudíxjöiʼi netuʼ channö nacuʼ Liʼ Cristo, Zxíʼinëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús rëʼ lëʼ: —Ca naʼ rnnoʼ nacaʼ. Le nácatë reaʼ libíʼiliʼ, iléʼeliʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, röʼa cuita lëʼë ibëla Dios, ga niʼ dë lu naʼa yöl-laʼ unná bëʼ, ateʼ guídaʼ lu böaj lúzxiba, en idxinaʼ ga zóaliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Níʼirö lu yöl-laʼ rilé queëʼ guchözëʼ bixúz lo lariʼ nácuëʼ, rnnëʼ: —¡Gunnë́ ziʼë bönniʼ ni queëʼ Dios! ¿Núzxirö naquíniruʼ nu innë́ queëʼ bönniʼ ni? Chibiyö́n quéziliʼ didzaʼ ziʼ bëʼë queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Nacxi rusácaʼliʼ queë́liʼ? Buluʼbiʼë didzaʼ, gulaʼnnë́ʼ: —Nabáguëʼë xíguiaʼ gátiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Níʼirö buluʼchejëʼ zxönaʼ lahuëʼ Jesús, en guluʼë döʼ queëʼ. Gulaʼgápëʼë ruʼë Jesús iaʼzícaʼrëʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","en tëʼ Lëʼ: —¿Nácatsoʼ Liʼ Cristo? Gunnë́yaʼatsöcaʼ naʼa, ¿nuzxi naʼ gudapaʼ Liʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tsanni niʼ gulaca lë naʼ, röʼë Pedro lö́ʼalö, ateʼ bidxinnu tunu nigula huen dxin ga naʼ zoëʼ, ateʼ rnnanu: —Lëscaʼ liʼ gudálenuʼ Jesús, bönniʼ Galilea naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Gudáʼbaguëʼë Pedro lógaca bönachi nacuáʼ niʼ, rnnëʼ: —Bitiʼ nözdaʼ nuzxi que naʼ ruʼu didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Cateʼ birúajëʼ Pedro ga nu riyaza löʼa, biléʼenu-nëʼ iaʼtunu nigula, ateʼ gúdxinu nupa nacuáʼ niʼ: —Bönniʼ ni gudálenëʼ caʼ Jesús, bönniʼ Nazaret naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Leyúbölö gudáʼbaguëʼë Pedro, en buzötjëʼ Dios, rnnëʼ: —Bitiʼ caʼ núnbëʼa-nëʼ bönniʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Iáʼlátiʼdoʼos gudzé, gulaʼbigaʼ nupa nacuáʼ niʼ ga naʼ zoëʼ Pedro, en tëʼ lëʼ: —Le nácatë liʼ nunuʼ caʼ tsözxö́n légaquiëʼ tuʼ naca bëʼu yöl-laʼ ruíʼisö quiuʼ didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Níʼirö gusí lahuëʼ Pedro rudxía döʼ cuinëʼ, en ruzötjëʼ Dios, rnnëʼ: —Bitiʼ caʼ núnbëʼa-nëʼ bönniʼ ni. Laʼ náʼasö gurö́dxitëbaʼ böra. ");
INSERT INTO zarNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Níʼirö yöjnenëʼ Pedro didzaʼ gudxëʼ Jesús lëʼ, gunnë́ʼ: Cateʼ siʼ cö́dxilöbaʼ böra, tsonna luzuí chigunnóʼ bitiʼ núnbëʼu nedaʼ, ateʼ burúajëʼ Pedro niʼ, en gurödxi yéchiʼdëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Cateʼ zaʼ reníʼ dza naʼ, gulún xtídzaʼgaquiëʼ yúguʼtë bixúz unná bëʼ len bönniʼ gula tuʼzéajniʼinëʼ bönniʼ judío para ilútiëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Gulaʼchë́ʼë Jesús náguëʼë, ateʼ buluʼdödëʼ Lëʼ lu nëʼë Poncio Pilato, bönniʼ rinná bëʼë uláz que yödzö Roma. ");
INSERT INTO zarNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Cateʼ chinö́zinëʼ Judas, bönniʼ naʼ budödëʼ Jesús lu náʼagaquiëʼ bönniʼ yudoʼ, narugu queëʼ Jesús gátiëʼ, buíʼinnëʼ, ateʼ yöjuʼë chi uruáʼ dumí plata naʼ lu náʼagaquiëʼ bixúz unná bëʼ, en yuguʼ bönniʼ gula naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Rëʼ légaquiëʼ: —Benaʼ dul-laʼ tuʼ budödaʼ-nëʼ bönniʼ tsahuiʼ gátiëʼ. Níʼirö tëʼ lëʼ: —Bitiʼ gun lë ni ga cö́ʼötuʼ böniga. Le ben cazuʼ liʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Níʼirö gurúʼunëʼ Judas yuguʼ dumí plata naʼ ga naca chila yudoʼ, ateʼ buzë́ʼë niʼ, en yöjsí yenëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Buluʼziʼë bixúz unná bëʼ yuguʼ dumí plata naʼ, taʼnnë́ʼ: —Bitiʼ saʼyéaj cúʼuruʼ dumí ni ga rigúʼuruʼ dumí que yudoʼ, tuʼ naca lazxjëʼ tu bönniʼ ratiëʼ bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Níʼirö gulún xtídzaʼgaquiëʼ, ateʼ guláʼuinëʼ dumí naʼ tu laʼ yëla queëʼ tu bönniʼ huen röʼö para gaca ga ilaʼgáchëʼë bönniʼ ziʼtuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Que lë ni naʼ, ga ridxintë naʼa dza nazíʼi le lataj naʼ, Laʼ Yëla Rön. ");
INSERT INTO zarNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Caní guca ca naʼ gunnë́ʼ Jeremías, bönniʼ bëʼë didzaʼ uláz queëʼ Dios, gunnë́ʼ: “Gulaʼguélëʼë chi uruáʼ dumí plata naʼ, tsca le gulaʼzéquiʼnëʼ bönniʼ Israel Lëʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ateʼ dumí naʼ guláʼuinëʼ laʼ yëla queëʼ tu bönniʼ huen röʼö. Lë ni buluíʼinëʼ Xanaʼ nedaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Cateʼ buluʼsudxinëʼ Jesús lahuëʼ Pilato, bönniʼ naʼ rinná bëʼë uláz que yödz Roma, bönniʼ ni gunábinëʼ Jesús, rëʼ Lëʼ: —¿Nacuʼ Liʼ Bönniʼ inná béʼenëʼ bönachi judío? Jesús rëʼ lëʼ: —Ca nácasö rnnoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Cateʼ yuguʼ bixúz unná bëʼ len bönniʼ gula tuʼzéajniʼinëʼ buluʼzéguiʼë Jesús didzaʼ, bitiʼ bi didzaʼ bubiʼë Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Níʼirö Pilato rëʼ Jesús: —¿Naruʼ cabí riyö́ntsenuʼ cateʼ xö le taʼnnë́ʼ quiuʼ? ");
INSERT INTO zarNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesús bitiʼ bi didzaʼ bubiʼë. Caní guca, bubáninëʼ bönniʼ unná bëʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Cateʼ naca dza Laní Pascua naʼ, dë caz tu le runëʼ Pilato, bönniʼ unná bëʼ naʼ, ca taʼnaba bönachi rusanëʼ tuëʼ bönniʼ yuʼë lidxi guíë, nútiʼtës nu të́ʼëni usanëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Dza naʼ tu bönniʼ nabáguëʼë xíguiaʼ, lëʼ Barrabás, yuʼë lidxi guíë niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Cateʼ buluʼdubi bönachi zián niʼ, Pilato gunábinëʼ légaquiëʼ, rnnëʼ: —¿Nuzxi rë́ʼëniliʼ usanaʼ queë́liʼ? ¿Naruʼ Barrabás o Jesús, Bönniʼ naʼ lëʼ Cristo? ");
INSERT INTO zarNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Caní gunnë́ʼ Pilato tuʼ réquibeʼenëʼ buluʼdödëʼ bönniʼ yudoʼ Jesús lu nëʼë tuʼ tuʼzxéʼenëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Tsanni niʼ röʼë Pilato ga naʼ ruchiʼa rusörö́ëʼ, nigula queëʼ gusö́l-laʼnu nu tsöjödxi lëʼ, rnna: —Bitiʼ bi gunuʼ queëʼ bönniʼ tsahuiʼ ni, tuʼ gúdxideʼedaʼ guduyëla lu yëla bë́chigal tuʼ nö́zinëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Yuguʼ bixúz unná bëʼ len bönniʼ gula tuʼzéajniʼinëʼ gulaʼgúʼu yö́l-lëʼë bönachi zián naʼ para ilaʼnabi Pilato usanëʼ Barrabás naʼ, ateʼ gútiëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Leyúbölö bëʼë didzaʼ bönniʼ unná bëʼ naʼ, rëʼ légaquiëʼ: —¿Núzxilëʼ chopëʼ ni rë́ʼëniliʼ usanaʼ-nëʼ queë́liʼ? Gulaʼnnë́ʼ: —Barrabás. ");
INSERT INTO zarNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Níʼirö Pilato gunábinëʼ légaquiëʼ, rnnëʼ: —¿Nacxi gunaʼ queëʼ Jesús, bönniʼ naʼ lëʼ Cristo? Yúguʼtëʼ taʼnnë́ʼ: —¡Budë́ʼë lëʼe yaga cruz! ");
INSERT INTO zarNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Níʼirö bönniʼ unná bëʼ naʼ rëʼ légaquiëʼ: —¿Bizxi döʼ benëʼ? Zídzajrö guluʼë didzaʼ, taʼnnë́ʼ: —¡Budë́ʼë lëʼe yaga cruz! ");
INSERT INTO zarNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Cateʼ réquibeʼenëʼ Pilato bitiʼ birúaj xtídzëʼë, pero gulaʼdzátsarö bönachi, níʼirö gudélëʼë nisa, en gudibi nëʼë lógaquiëʼ, rnnëʼ: —Bitiʼ bi xíguiaʼ nabágaʼa nedaʼ tuʼ nözi yöl-laʼ guti queëʼ bönniʼ tsahuiʼ ni. Le gun cázaliʼ libíʼiliʼ lë ni. ");
INSERT INTO zarNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Buluʼbíʼi didzaʼ yúguʼtë bönachi niʼ, taʼnná: —¡Yöl-laʼ guti queëʼ bönniʼ ni ibágaʼtuʼ netuʼ, en ilaʼbagaʼ caʼ zxíʼinituʼ! ");
INSERT INTO zarNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Caʼ guca, Pilato busanëʼ Barrabás naʼ lu náʼagaquiëʼ. Níʼirö gunná béʼenëʼ bönniʼ röjáquiëʼ gudil-la ilaʼguínëʼ Jesús, ateʼ gudödi niʼ budödëʼ Lëʼ lu náʼagaquiëʼ para uluʼdë́ʼë Lëʼ lëʼe yaga cruz. ");
INSERT INTO zarNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Yuguʼ bönniʼ röjáquiëʼ gudil-la nacuʼë lu nëʼë bönniʼ unná bëʼ naʼ gulaʼchë́ʼë Jesús lu yuʼu yúlahuiʼ nazíʼi le pretorio, ateʼ niʼ buluʼtubëʼ yúguʼtë bönniʼ röjáquiëʼ gudil-la nacuʼë niʼ ga naʼ zoëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Níʼirö gulaʼlecjëʼ lariʼ nácuëʼ Jesús, en buluʼgácuëʼ Lëʼ tu lariʼ xiná chul-la, ca rácugaca nupa taʼnná bëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Buluʼdxíëʼ icjëʼ tu le néquini niʼa nëʼe yaga yötsiʼ le naca ca le dxia icjëʼ bönniʼ rinná bëʼë, en buluʼzóëʼ tu guídoʼ lu nëʼë ibëla le ruluíʼi ca tu yaga que bönniʼ yúlahuiʼ. Níʼirö buluʼzóa zxibëʼ lahuëʼ, en buluʼtitjëʼ Lëʼ, taʼnnë́ʼ: —¡Bicaʼ ba Liʼ, rinná béʼenuʼ bönachi judío! ");
INSERT INTO zarNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Níʼirö buluʼchejëʼ Lëʼ zxönaʼ, ateʼ buluʼguélëʼë gui naʼ, en gulaʼguínëʼ icjëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Gudödi buluʼtitjëʼ Jesús, gulaʼlecjëʼ lariʼ naʼ nácuëʼ, ateʼ buluʼgácuëʼ Lëʼ lariʼ que cazëʼ. Níʼirö gulaʼchë́ʼë Lëʼ para tsöjdáʼagaquiëʼ Lëʼ lëʼe yaga cruz. ");
INSERT INTO zarNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Cateʼ niʼ bilaʼrúajëʼ bönniʼ naʼ, yöjxácaʼgaquiëʼ Simón, tu bönniʼ Cirene, ateʼ gulunëʼ ga biʼë yaga cruz queëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Cateʼ bilaʼdxinëʼ lataj nazíʼi le Gólgota, le rnna lu didzaʼ xidzaʼ, Lataj Que Bögaʼ Ícjaruʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","buluʼguiʼjëʼ Jesús nupi zi nutsíʼi zxígalaʼabaʼ böaʼ guixiʼ. Cateʼ buxíʼi ruʼë Jesús, bitiʼ gúʼunnëʼ guíʼjëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Cateʼ chinudáʼagaquiëʼ Lëʼ lëʼe yaga cruz, gulaʼguísiëʼ lariʼ nácuëʼ, en buluʼquitjëʼ lahui le gaca bëʼ núzxilëʼ guequi queëʼ. Caní guca, budxín lë naʼ gunnë́ʼ bönniʼ bëʼë didzaʼ uláz queëʼ Dios, gunnë́ʼ: “Gulaʼguísiëʼ lariʼ nácuaʼ, en buluʼquitjëʼ lahui le gaca bëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Níʼirö gulaʼböʼë niʼ, tuʼyúëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Lëscaʼ buluʼzóëʼ lëʼe yaga cruz ícjalëʼ Jesús tu didzaʼ le riguixjöʼ le nabáguëʼë le rnna caní: “Bönniʼ ni Jesús, Bönniʼ rinná béʼenëʼ bönachi judío.” ");
INSERT INTO zarNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ga niʼ dëʼë Jesús, buluʼdë́ʼë caʼ lë́ʼegaca yaga cruz chopëʼ bönniʼ gubán. Tuëʼ buluʼdë́ʼë cuita lëʼë ibëla, en iaʼtúëʼ naʼ cuita lëʼë yö́göla. ");
INSERT INTO zarNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Gulaʼdödëʼ niʼ yuguʼ bönniʼ buluʼlidza ziʼë Jesús, en buluʼtá ícjagaquiëʼ, tuʼtitjëʼ Lëʼ, ");
INSERT INTO zarNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","taʼnnë́ʼ: —¡Ön, Liʼ naʼ uquínnajuʼ yudoʼ, ateʼ tsonna dzasö caʼ uchísatsoʼ le! ¡Busölá cuinuʼ naʼa channö nacuʼ Liʼ Zxíʼinëʼ Dios! ¡Bö́tjatsöcaʼ lëʼe yaga cruz naʼ! ");
INSERT INTO zarNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Lëscaʼ caní buluʼtitjëʼ Lëʼ yuguʼ bixúz unná bëʼ len yuguʼ bönniʼ yudoʼ usedi, en yuguʼ bönniʼ yudoʼ fariseo, len bönniʼ gula tuʼzéajniʼinëʼ, taʼnnë́ʼ: ");
INSERT INTO zarNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Yuguʼ nu yúbölö busölë́ʼ bönniʼ ni, pero bitiʼ gaca usölá cuinëʼ. Channö náquiëʼ Bönniʼ inná béʼenëʼ bönachi Israel, huö́tjatsöquiëʼ naʼa lëʼe yaga cruz, ateʼ tséajlëʼëruʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Lëʼ buzxöni ládxëʼë Dios. Dios usölá cazëʼ Lëʼ naʼa channö raza ládxëʼë Lëʼ, tuʼ gunnë́ʼ: “Zxíʼinëʼ Dios nacaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Lëscaʼ caní yuguʼ bönniʼ gubán naʼ dáʼgaquiëʼ lë́ʼegaca yaga cruz ga niʼ dëʼë Jesús buluʼlidza ziʼë Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Cateʼ bidxín huagubidza, guchul-la idútë yödzölió ga bidxintë idú ridödi xihuö́. ");
INSERT INTO zarNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Idú ridödi xihuö́ naʼ, bëʼë zidzaj didzaʼ Jesús, rnnëʼ: —Elí, Elí, ¿lama sabactani? Didzaʼ ni rnna lu didzaʼ xidzaʼ: “Dios quiaʼ, Dios quiaʼ, ¿bizx que nubéaj ládxuʼu nedaʼ?” ");
INSERT INTO zarNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Cateʼ nupa nacuáʼ niʼ bilaʼyöni didzaʼ ni, taʼnná: —Bönniʼ ni rulidzëʼ Elías, bönniʼ niʼ bëʼë didzaʼ uláz queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Laʼ guxítiʼtëʼ tuëʼ bönniʼ nútsëʼë ládjagaquiëʼ, en gudélëʼë tu le bululu rizxupi nisa, ateʼ buxúpinëʼ le nupi zi, en buzóëʼ le tu lu gui, ateʼ butságuiëʼ le ruʼë Jesús para xupëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Níʼirö iaʼzícaʼrëʼ bönniʼ niʼ taʼnnë́ʼ: —¡Gulö́zagarö! ¡Uyútsöcaʼruʼ channö huidëʼ Elías usölë́ʼ Lëʼ! ");
INSERT INTO zarNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Leyúbölö gurö́dxiʼë zidzaj Jesús, ateʼ burúajtë böʼ naca cazëʼ, gútitëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Laʼ náʼasö birö́zaʼtë lariʼ nal-laʼ lu yudoʼ, birúaj choplö, le gudelaʼ icjlö ga bidxintë xiníʼi. Níʼirö gudödi budóʼ zxuʼ, en gulaʼláʼa guiö́j. ");
INSERT INTO zarNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Gulaʼyalaj yeru ba quégaca nupa chinátigaca, nupa niʼ gulaʼyéajlëʼ Dios, ateʼ buluʼbán bönachi naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Gudödi bubanëʼ Jesús, buluʼrúajëʼ bönniʼ naʼ yeru ba quégaquiëʼ, en gulaʼyáziëʼ yödzö láʼayi Jerusalén, ga niʼ bilaʼléʼe bönachi zián légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Níʼirö gúdxinëʼ bönniʼ naʼ rinná béʼenëʼ bönniʼ röjáquiëʼ gudil-la, encaʼ yuguʼ bönniʼ röjáquiëʼ gudil-la nacuáʼlenëʼ lëʼ tuʼyúëʼ Jesús, ateʼ gunnë́ʼ: —Le nácatë bönniʼ ni gúquiëʼ Zxíʼinëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Zíʼtuʼsö gulaʼcuáʼanu nigula zián tuʼyunu Jesús, nigula naʼ gulaʼdálennu Jesús cateʼ niʼ buzë́ʼë luyú Galilea, ateʼ gulunnu xichinëʼ, gulaʼgúʼunu le gulahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Lëscaʼ María Magdalena, en María, xináʼagaquiëʼ Jacobo, en José, nútsaʼgacanu ládjagacanu, ateʼ zóanu caʼ niʼ xináʼagaquiëʼ yuguʼ zxíʼinëʼ Zebedeo. ");
INSERT INTO zarNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Cateʼ chiridzö́ʼ dza naʼ, bidxinëʼ José, bönniʼ Arimatea, tu bönniʼ riléʼenëʼ yöl-laʼ tsahuiʼ queëʼ, en dëʼë caʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Bönniʼ ni yöjyúëʼ Pilato, en gunabëʼ lataj uʼë Jesús. Níʼirö Pilato gunná bëʼë uluʼnödzjëʼ queëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Guzxiʼë José Lëʼ, en buchö́linëʼ Lëʼ tu lariʼ nazacaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Níʼirö guluʼë Lëʼ lu yeru ba cubi queëʼ le naguidjëʼ lëʼe guíʼa guiö́j. Budë́ʼë tu guiö́j blaga zxön ga nu riyaza yeru ba naʼ, ateʼ söhuö́jëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Gulaʼcuáʼanu María Magdalena, en iaʼtunu María niʼ, rö́ʼgacanu raʼ yeru ba naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Cateʼ zaʼ reníʼ iaʼtú dza, gudödi buluʼpë́ʼë que dza láʼayi quégaquiëʼ bönniʼ judío, buluʼdubëʼ yuguʼ bixúz unná bëʼ, en yuguʼ bönniʼ yudoʼ fariseo ga zoëʼ Pilato. ");
INSERT INTO zarNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Tëʼ Pilato: —Bönniʼ, röjnetuʼ bi gunnë́ʼ bönniʼ rizíʼ yëʼë naʼ, cateʼ niʼ zoëʼ nabanëʼ, gunnë́ʼ: “Cateʼ gaca tsonna dza ubanaʼ lu yöl-laʼ guti.” ");
INSERT INTO zarNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Que lë ni naʼ gunná beʼe nupa ilún chiʼi ba niʼ ga idxintë dza bunni, para cabí ídigaquiëʼ bönniʼ usëda queëʼ chiʼi dzö́ʼölö, en uluʼbéajëʼ Lëʼ. Níʼirö ilë́ʼ bönachi: “Bubanëʼ Jesús lu yöl-laʼ guti.” Channö caní gaca, didzaʼ cabí nácatë ni iluʼë gúntërö huiáʼ döʼ ca ben didzaʼ cabí nácatë naʼ guluʼë zíʼalö. ");
INSERT INTO zarNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato gudxëʼ légaquiëʼ: —Ni nacuʼë bönniʼ röjáquiëʼ gudil-la. Guliʼchë́ʼë queë́liʼ. Guliʼtséaj, guliʼgún chiʼi yeru ba naʼ tsca séquiʼliʼ gunliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Níʼirö yöjáquiëʼ niʼ, en buluʼsayjëʼ dxiʼa yeru ba naʼ, en buluʼdë́ʼë lëʼe guiö́j naʼ tu le gaca bëʼ channö isalaj, ateʼ buluʼcáʼanëʼ niʼ bönniʼ röjáquiëʼ gudil-la ilún chiʼë le. ");
INSERT INTO zarNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Cateʼ chigudödi dza láʼayi quégaquiëʼ bönniʼ judío, en chizáʼ reníʼ dza domingo, yöjyúgacanu María Magdalena en iaʼtunu María naʼ yeru ba queëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tsálidoʼos gudödi budóʼ zxuʼ. Caní guca, tuʼ bötjëʼ tuëʼ gubáz láʼayi queëʼ Xanruʼ narúajëʼ yehuaʼ yubá. Bidxinëʼ raʼ yeru ba naʼ, ateʼ gudúëʼ guiö́j blaga zxön naʼ, en guröʼë lu guiö́j naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Naláʼ lahui gubáz láʼayi naʼ ca yösa beníʼ, ateʼ zxílaʼdoʼos naca lariʼ nácuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Cateʼ yuguʼ bönniʼ naʼ röjáquiëʼ gudil-la tapa chiʼë yeru ba naʼ bilaʼléʼenëʼ lëʼ, guládxinëʼ, en gulaʼzxíziëʼ. Gulaʼdzöʼë lu yu, en guláquiëʼ ca bönniʼ nati caz. ");
INSERT INTO zarNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Níʼirö gubáz láʼayi naʼ gudxëʼ yuguʼ nigula naʼ, rnnëʼ: —Bitiʼ gádxiliʼ. Nözdaʼ ruguíljaliʼ-nëʼ Jesús, bönniʼ naʼ buluʼdë́ʼë lëʼe yaga cruz. ");
INSERT INTO zarNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Bitiʼ zoëʼ ni tuʼ chibubanëʼ ca naʼ chigunná cazëʼ Lëʼ. Guliʼdá, uyuliʼ ga niʼ gutëʼ Xanruʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Guliʼtséaj naʼa, guliʼtsöjödxi yuguʼ bönniʼ usëda queëʼ chibubanëʼ Jesús lu yöl-laʼ guti, ateʼ naʼa Lë cazëʼ inö́ruëʼ loliʼ sacaʼ luyú Galilea. Niʼ uléʼeliʼ-nëʼ. Chigudxaʼ libíʼiliʼ le guluʼë Dios lu naʼa. ");
INSERT INTO zarNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Níʼirö laʼ buluʼzáʼtënu raʼ yeru ba naʼ, tádxinu, en tuʼdzéjanu, ateʼ carelö söjácanu söjtíxjöiʼiguequinu yuguʼ bönniʼ usëda queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tsanni niʼ söjácanu, Jesús yöjtságuiëʼ légacanu, ateʼ rëʼ légacanu: —Padiux. Níʼirö gulaʼbígaʼnu ga zoëʼ Jesús, en buluʼnídaʼnu niʼë. Gulaʼyéaj ládxiʼgacanu Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Níʼirö Jesús rëʼ légacanu: —Bitiʼ gádxiliʼ. Guliʼtséaj, guliʼtsöjtíxjöiʼi yuguʼ bö́chaʼa tsöjáquiëʼ sacaʼ luyú Galilea, ateʼ niʼ uluʼléʼenëʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tsanni niʼ söjácanu nigula naʼ, yuguʼ bönniʼ naʼ röjáquiëʼ gudil-la gulún chiʼë yeru ba naʼ buluʼdxinëʼ lu yödzö niʼ, ateʼ gulaʼguíxjöiʼinëʼ yuguʼ bixúz unná bëʼ yúguʼtë lë naʼ gulaca. ");
INSERT INTO zarNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Cateʼ chibuluʼtubëʼ yuguʼ bönniʼ gula tuʼzéajniʼinëʼ, gulún xtídzaʼgaquiëʼ. Níʼirö buluʼnödzjëʼ dumí zián quégaquiëʼ bönniʼ naʼ röjáquiëʼ gudil-la. ");
INSERT INTO zarNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Tëʼ légaquiëʼ: —Caní innaliʼ: “Bilaʼdxinëʼ bönniʼ usëda queëʼ chiʼi dzö́ʼölö, en buluʼbéajëʼ Lëʼ tsanni niʼ rásituʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Channö huayönnëʼ bönniʼ rinná bëʼë lë ni, netuʼ uzéajniʼituʼ lëʼ, en guntuʼ ga bitiʼ bi gunëʼ queë́liʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Níʼirö yuguʼ bönniʼ röjáquiëʼ gudil-la naʼ gulaʼziʼë dumí naʼ ateʼ yöjéngaquiëʼ ca naʼ chinazë́dagaquiëʼ. Caní guca, tuʼzë́ʼ bönniʼ judío didzaʼ ni ga ridxintë naʼa dza. ");
INSERT INTO zarNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Níʼirö idxinéajtëʼ bönniʼ usëda queëʼ Jesús yöjáquiëʼ luyú Galilea, ateʼ bilaʼdxinëʼ lu guíʼadoʼ naʼ chibuluíʼinëʼ Jesús légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Cateʼ buluʼléʼenëʼ Jesús, gulaʼyéaj ládxiʼgaquiëʼ Lëʼ, pero bal-lëʼ gulaca chopa ládxiʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Níʼirö gubíguiʼë Jesús ga naʼ nacuʼë, en rëʼ légaquiëʼ: —Dios chinudödëʼ lu naʼa yúguʼtë yöl-laʼ unná bëʼ yehuaʼ yubá, en luyú ni. ");
INSERT INTO zarNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Que lë ni naʼ, guliʼtséaj, guliʼtsöjsëdi yúguʼtë bönachi idútë yödzölió. Buliʼquíla légaquiëʼ nisa, ugunliʼ dxin Lëʼ Dios Xuz, en Lëʼ Dios Zxíʼini, en Lëʼ Dios Böʼ Láʼayi. ");
INSERT INTO zarNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Guliʼsëdi légaquiëʼ ilunëʼ yúguʼtë lë naʼ gunná béʼedaʼ libíʼiliʼ. Buliʼyútsöcaʼ, nedaʼ caz zóalenaʼ libíʼiliʼ yúguʼtë dza ga idxinrö dza údxi que yödzölió. Caʼ gaca.");
INSERT INTO zarNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Caní gusí lo didzaʼ dxiʼa ca guca queëʼ Jesucristo, Zxíʼinëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Budxín lë naʼ buzúajëʼ lu guichi Isaías, bönniʼ bëʼë didzaʼ uláz queëʼ Dios, le gunnë́ʼ Dios: Buyútsöcaʼ, risö́l-laʼa bönniʼ gubáz quiaʼ, inö́ruëʼ Loʼ. Lëʼ upë́ʼë nöza ga töduʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Yön chiʼë tu bönniʼ ulidzëʼ zidzaj lu lataj cáʼasö, innë́ʼ: “Buliʼpáʼa nöza para idxín Xanruʼ yichaj lázxdoʼoliʼ. Buliʼbéaj li yuguʼ nöza lasi ga tödëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Caní budxín, tuʼ ruquilëʼ Juan bönachi nisa lu lataj cáʼasö, en runëʼ libán para ilaʼdila bönachi nisa, bönniʼ naʼ buluʼbíʼi ládxiʼgaquiëʼ para uniti lahuëʼ Dios dul-laʼ nabágaʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bilaʼrúaj bönachi zián yúguʼtë yödzö luyú Judea, encaʼ yödzö Jerusalén, en yöjáquiëʼ ga naʼ zoëʼ Juan, ateʼ Juan naʼ buquilëʼ légaquiëʼ nisa lu yegu Jordán, bönniʼ naʼ gulaʼxóalëpëʼ dul-laʼ nabágaʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nácuëʼ Juan lariʼ néquini lítsaʼbaʼ böaʼ, en núguëʼë lëʼë tu guídi. Rahuëʼ-baʼ bö́chiʼzu, en reʼjëʼ le zxixi que buzdoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Runëʼ Juan libán, rnnëʼ: —Siʼ zëʼë bönniʼ tödi naʼa, náparëʼ yöl-laʼ unná bëʼ ca nedaʼ. Bitiʼ nacaʼ nedaʼ lesacaʼ yéchuaʼ, para ilecjaʼ xiráchuëʼ nudë́ʼë. ");
INSERT INTO zarNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nedaʼ ruquilaʼ libíʼiliʼ nisa, pero Lëʼ gunëʼ le ruluíʼisö yöl-laʼ ridila nisa ni, uchíziëʼ libíʼiliʼ Dios Böʼ Láʼayi. ");
INSERT INTO zarNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tu dza niʼ birúajëʼ Jesús yödzö Nazaret luyú Galilea, ateʼ Juan naʼ buquilëʼ Lëʼ nisa lu yegu Jordán. ");
INSERT INTO zarNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Cateʼ burúajëʼ Jesús lu nisa, laʼ náʼasö biléʼenëʼ guyalaj lúzxiba, en ruhuötjëʼ Dios Böʼ Láʼayi, ruluíʼi cuinëʼ ca tubaʼ guʼdödoʼ, en bidisóalenëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Biyö́n chiʼi nu ruíʼi didzaʼ yehuaʼ yubá, rnna: —Liʼ nacuʼ Zxíʼinaʼ. Nadxíʼidaʼ Liʼ, en raza ládxaʼa Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Níʼirö Dios Böʼ Láʼayi guchë́ʼë Jesús bayudxi lu lataj cáʼasö. ");
INSERT INTO zarNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Guzóëʼ Jesús lataj cáʼasö naʼ idú choáʼ dza, ateʼ gúʼuni Satanás tuʼ xihuiʼ gun ga ibáguëʼë Jesús dul-laʼ. Guzóëʼ Jesús ga niʼ taʼdabaʼ böaʼ guixiʼ dzö́ʼöbaʼ guíʼadoʼ. Yuguʼ gubáz láʼayi queëʼ Dios gulácalenëʼ Jesús, en gulaʼguʼë le gudahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Gudödi gulaʼguʼë Juan naʼ lidxi guíë, saʼyéajëʼ Jesús luyú Galilea. Runëʼ libán niʼ que didzaʼ dxiʼa ca rinná bëʼë Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Caní rnnëʼ: —Chibidxín dza. Chizóa idinná bëʼë Dios. Buliʼbíʼi ládxiʼliʼ, en guliʼtséajlëʼ didzaʼ dxiʼa ni. ");
INSERT INTO zarNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tsanni niʼ ridë́ʼ Jesús raʼ nísadoʼ luyú Galilea, biléʼenëʼ Simón len Andrés, bönniʼ bö́chëʼë Simón naʼ. Nácagaquiëʼ uzxö́n böla, en taʼchiljëʼ yöxaj böla quégaquiëʼ lu nisa naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús gudxëʼ légaquiëʼ, rnnëʼ: —Guliʼdutáʼ nedaʼ, ateʼ gunaʼ ga ichë́ʼëliʼ bönachi quiaʼ nedaʼ, gunliʼ ca runliʼ rizönliʼ-baʼ böla. ");
INSERT INTO zarNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Laʼ buluʼcáʼanatëʼ yöxaj quégaquiëʼ, en söjácalenëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Gudödëʼ Jesús iaʼlátiʼdoʼ níʼilö, ateʼ biléʼenëʼ Jacobo, en Juan, yuguʼ zxíʼinëʼ Zebedeo, nacuʼë lëʼe bárcodoʼ quégaquiëʼ, tuʼúnëʼ yöxaj böla quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesús laʼ bulidztëʼ légaquiëʼ, ateʼ buluʼcáʼanëʼ xúzgaquiëʼ Zebedeo, dzáguiëʼ yuguʼ huen dxin queëʼ lëʼe bárcodoʼ naʼ, ateʼ söjácalenëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bilaʼdxinëʼ Jesús, en yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ lu yödzö Capernaum. Cateʼ niʼ naca dza láʼayi quégaquiëʼ bönniʼ judío, guyáziëʼ Jesús yuʼu ga tuʼdubëʼ bönniʼ judío, en tuʼsëdëʼ queëʼ Dios, ateʼ gusí lahuëʼ rusédinëʼ nupa nudúbigaca niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Buluʼbáninëʼ ca naʼ rusédinëʼ Jesús, tuʼ rusédinëʼ ca runëʼ tu bönniʼ dë lu nëʼë, en calëga ca tunëʼ bönniʼ yudoʼ usëdi. ");
INSERT INTO zarNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Zóatëʼ caʼ tu bönniʼ yuʼu lëʼ böʼ xihuiʼ lu yuʼu ga naʼ tuʼdubëʼ tuʼsëdëʼ queëʼ Dios, ateʼ gurö́dxiʼë bönniʼ naʼ, rnnëʼ: ");
INSERT INTO zarNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Bizxi rál-laʼtuʼ quiuʼ, Jesús, bönniʼ Nazaret? ¿Zaʼtsuʼ usunítiuʼ netuʼ? Núnbëʼa Liʼ, nacuʼ Bönniʼ Láʼayi queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús buzenëʼ le bach, rnnëʼ: —Busayaj ruʼu, en burúaj lu bönniʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Níʼirö böʼ xihuiʼ naʼ buxízidaʼ bönniʼ naʼ yuʼu lëʼ, ateʼ gurö́dxiʼa zidzaj, en laʼ burúajtë. ");
INSERT INTO zarNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Buluʼbáninëʼ yúguʼtë bönniʼ nacuʼë niʼ, ateʼ gulaʼnabi luzë́ʼegaquiëʼ, taʼnnë́ʼ: —¿Bizxi caz lë ni? ¿Naruʼ nácatsö xibá cubi? ¡Len yöl-laʼ unná bëʼ rinná béʼenëʼ yuguʼ böʼ xihuiʼ, ateʼ tun ca rnnëʼ! ");
INSERT INTO zarNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Laʼ guzëtë didzaʼ que yöl-laʼ huáca queëʼ Jesús, ateʼ bilaʼyöni bönachi idútë luyú Galilea naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Níʼirö burúajëʼ Jesús lu yuʼu ga naʼ tuʼdubëʼ tuʼsëdëʼ queëʼ Dios, en laʼ guyéajlentëʼ Jacobo, en Juan, ateʼ bilaʼdxinëʼ lídxigaquiëʼ Simón, en Andrés. ");
INSERT INTO zarNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Niʼ dënu xináʼanu nigula queëʼ Pedro, yúʼunu tu xilá. Laʼ gulaʼguíxjöiʼitenëʼ Jesús ca raca queë́nu. ");
INSERT INTO zarNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Níʼirö gubíguiʼë Jesús, ateʼ gudélëʼë náʼanu, en guchisëʼ-nu. Laʼ burúajtë tu xilá naʼ yúʼunu, ateʼ bupáʼanu le gulahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Cateʼ chiridzö́ʼ, ca gudxía gubidza, laʼ dujuáʼgacatëʼ yúguʼtë nupa teʼe, en yuguʼ bönniʼ yuʼu légaquiëʼ böʼ xihuiʼ ga zoëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Yúguʼtë bönachi lu yödzö bilaʼguírö ga nu riyaza yuʼu ga naʼ zoëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús bunëʼ zián nupa teʼe, naca zián yödzöhuë́ʼ téʼenëʼ. Bubéajëʼ caʼ zián böʼ xihuiʼ yúʼugaca bönachi naʼ. Bitiʼ bëʼë lataj ilaʼnnë́ böʼ xihuiʼ naʼ tuʼ núnbëʼgaca Lëʼ Nu náquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Zíʼacadoʼ guyasëʼ Jesús, niʼ naca chul-la. Burúajëʼ yödzö naʼ, en saʼyéajëʼ tu lataj cáʼasö, ateʼ niʼ bulidzëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón, en nupa nacuáʼlen lëʼ söjdíljagaquiëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Cateʼ yöjxácaʼgaquiëʼ Lëʼ, tëʼ Lëʼ: —Yúguʼtë bönachi tuʼguílaj Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Níʼirö Jesús gudxëʼ légaquiëʼ, rnnëʼ: —Uyéajruʼ yuguʼ dzaga yödzö, para gunaʼ caʼ libán niʼ. Que lë ni naʼ birúajaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Caní guca, gudödëʼ Jesús idú luyú Galilea, runëʼ libán lu yuʼu gapa tuʼdubëʼ bönniʼ judío, tuʼsë́dinëʼ queëʼ Dios, ateʼ rubéajëʼ böʼ xihuiʼ yúʼugaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tu bönniʼ réʼenëʼ huëʼ nudzuʼ ruzödi bidxinëʼ ga zoëʼ Jesús. Buzóa zxibëʼ, en gútaʼyuëʼ lahuëʼ, rnnëʼ: —Channö rë́ʼënuʼ, huáca unuʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús buéchiʼ ládxëʼë lëʼ. Bulí nëʼë, gudanëʼ lëʼ, en gudxëʼ lëʼ: —Rë́ʼëndaʼ. Chinuhuöácuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ca gunnë́ʼ caʼ, laʼ bunítitë huëʼ réʼenëʼ, en böáquiëʼ dxíʼadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Níʼirö Jesús buzenëʼ bach bönniʼ naʼ, en laʼ busö́l-laʼtëʼ lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Caní gudxëʼ lëʼ: —Cuntu nu guíoʼ ca benaʼ quiuʼ, pero guyéaj, yöjluíʼi cuinuʼ lahuëʼ bixúz, en yöjnödzaj para le böácanuʼ liʼ que yudoʼ ca naʼ gunná bëʼë Moisés, lë naʼ uluíʼi bönachi chinuhuöácuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Burúajëʼ bönniʼ ni, en gusí lahuëʼ riguíxjöiʼinëʼ bönachi zián ca guca queëʼ. Tuʼ buzë́ʼ didzaʼ ni, bítiʼrö guca tsáziëʼ Jesús yálajdoʼ tu lu yödzö, pero guzóasëʼ níʼilö gapa naca lu lataj cáʼasö. Bönachi yúguʼtë yödzö bilaʼdxín ga naʼ zoëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Cateʼ chigudödi chopa tsonna dza, buáziëʼ Jesús yödzö Capernaum, ateʼ guzë́ didzaʼ zoëʼ yuʼu. ");
INSERT INTO zarNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Laʼ buluʼdúbitë bönachi zián ga naʼ zoëʼ Jesús, ga bidxintë bítiʼrö guzxéquiʼ ilaʼcuáʼ niʼ, ni raʼ yuʼu, ateʼ Jesús benëʼ libán que xtídzëʼë lógaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Níʼirö bilaʼdxinëʼ ga naʼ zoëʼ Jesús tapëʼ bönniʼ, nuáʼagaquiëʼ tu bönniʼ huëʼ nacúʼuniëʼ bin. ");
INSERT INTO zarNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bitiʼ guca ilaʼdxinëʼ lahuëʼ Jesús tuʼ nacuáʼ bönachi zián niʼ. Que lë ni naʼ gulaʼsaljëʼ ícjoʼolö ca dö́dilö ga zoëʼ Jesús. Cateʼ budxi buluʼdxíëʼ yeru naʼ, niʼ buluʼzötjëʼ le denëʼ bönniʼ huëʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Cateʼ gúquibeʼenëʼ Jesús ca naʼ taʼyéajlëʼë Lëʼ, gudxëʼ bönniʼ huëʼ naʼ: —Zxiʼinaʼ, chibunít lahuaʼ liʼ ca naca dul-laʼ nabáguʼu. ");
INSERT INTO zarNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Rö́ʼögaquiëʼ bal-lëʼ bönniʼ yudoʼ usedi niʼ. Taʼzáʼ ládxiʼgaquiëʼ, taʼnnë́ʼ: ");
INSERT INTO zarNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Bizx que ruʼë caní didzaʼ bönniʼ ni? Rucáʼanëʼ cáʼasö Dios. Cuntu nu bönniʼ gaca uniti lahuëʼ dul-laʼ. Tuzëʼ Dios gaca gunëʼ lë ni. ");
INSERT INTO zarNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Laʼ gúquibeʼetenëʼ Jesús le taʼzáʼ ládxiʼgaquiëʼ, ateʼ gudxëʼ légaquiëʼ: —¿Bizx que rizáʼ ládxiʼliʼ caní? ");
INSERT INTO zarNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Bitiʼ naca böniga nu guië́sö bönniʼ huëʼ ni chibuníti lo dul-laʼ nabáguëʼë, pero naca böniga nu gun ga huöásëʼ, en uʼë le denëʼ, en uzëʼe niʼë. ");
INSERT INTO zarNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Gunaʼ le gaca bëʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, dë lu naʼa luyú ni uniti lahuaʼ dul-laʼ nabágaʼgaca bönachi. Níʼirö Jesús gudxëʼ bönniʼ huëʼ naʼ: ");
INSERT INTO zarNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Liʼ reaʼ: Guyasa. Buáʼ le denuʼ, en böaj lidxuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Laʼ guyásatëʼ bönniʼ huëʼ naʼ, buʼë le gútiʼnëʼ, en burúajëʼ lógaca yúguʼtë nupa nacuáʼ niʼ. Buluʼbáninëʼ yúguʼtëʼ, en gulaʼguʼë Dios yöl-laʼ ba, taʼnnë́ʼ: —Catu caz riléʼetuʼ le caní. ");
INSERT INTO zarNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Burúajëʼ Jesús yödzö Capernaum, naʼ gudödëʼ leyúbölö raʼ nísadoʼ. Buluʼdubi bönachi zián ga zoëʼ Jesús, ateʼ Lëʼ busédinëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Cateʼ ridödëʼ Jesús niʼ, biléʼenëʼ Leví, zxíʼinëʼ Alfeo, röʼë ga ruquízxjëʼ uláz que yödzö ziʼtuʼ. Jesús gudxëʼ lëʼ: —Gudáʼ nedaʼ. Laʼ guyásatëʼ Leví naʼ, saʼyéajlenëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Gudödi guca lë ni, röʼë Jesús rahuëʼ lu yuʼu lidxëʼ Leví naʼ, ateʼ zián bönniʼ uquízxaj, en iaʼbal-lëʼ bönniʼ cáʼasö rö́ʼölengaquiëʼ tsözxö́n Jesús, en yuguʼ bönniʼ usëda queëʼ. Caní guca, tuʼ röjaca bönachi zián len Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Cateʼ yuguʼ bönniʼ yudoʼ usedi, en yuguʼ bönniʼ yudoʼ fariseo, bilaʼléʼenëʼ Lëʼ röʼë rágulenëʼ tsözxö́n yuguʼ bönniʼ uquízxaj, en iaʼbal-lëʼ bönniʼ cáʼasö, gulë́ʼ yuguʼ bönniʼ usëda queëʼ Jesús, taʼnnë́ʼ: —¿Bizxi caz runtsëʼ? ¡Rëʼaj rágulentsëʼ yuguʼ bönniʼ uquízxaj, en iaʼbal-lëʼ bönniʼ dul-laʼ! ");
INSERT INTO zarNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Biyönnëʼ Jesús didzaʼ ni tuʼë, en gudxëʼ légaquiëʼ: —Nupa nacuáʼ dxiʼa bitiʼ naquíniguequi nu un bönachi, pero nupa teʼe naquíniguequi nu un bönachi. Zaʼa nedaʼ, calëga dulídzagacaʼ bönachi tsahuiʼ, pero rulídzagacaʼ bönachi dul-laʼ para uluʼbíʼi ládxiʼgaca. ");
INSERT INTO zarNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tu dza niʼ tunëʼ gubasa bönniʼ dáʼgaquiëʼ Juan, en bönniʼ dáʼgaquiëʼ yuguʼ bönniʼ yudoʼ fariseo, ateʼ bilaʼdxín nupa gulaʼnabi Jesús, taʼnná: —¿Bizx que tunëʼ gubasa bönniʼ dáʼgaquiëʼ Juan, en bönniʼ dáʼgaquiëʼ yuguʼ bönniʼ yudoʼ fariseo, pero bönniʼ dáʼgaquiëʼ Liʼ bitiʼ tunëʼ gubasa? ");
INSERT INTO zarNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Bubiʼë didzaʼ Jesús, rëʼ légaquiëʼ: —¿Naruʼ réquitseliʼ ilún gubasa nupa nacuáʼ laní queëʼ bönniʼ rutsaga nëʼë tsanni niʼ bönniʼ naʼ rutsaga nëʼë zóalenëʼ légaquiëʼ? Tsanni niʼ bönniʼ naʼ rutsaga nëʼë zóalenëʼ légaquiëʼ, bitiʼ gaca ilunëʼ gubasa. ");
INSERT INTO zarNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Idxín dza cateʼ udúëʼ bönniʼ naʼ rutsaga nëʼë, en bítiʼrö sóalenëʼ légaquiëʼ, ateʼ dza níʼirö ilunëʼ gubasa. ");
INSERT INTO zarNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Cuntu nu bönniʼ udë́ʼë tu lariʼ cúbidoʼ lu lariʼ chinatëbi, tuʼ utsupiʼ lariʼ cubi naʼ, en huachözaʼ lariʼ tëbi naʼ, ateʼ huarö́zaʼrö lariʼ tëbi naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Lëscaʼ caní cuntu nu bönniʼ quëʼë xisi uva cubi lu buzudi bidxi néquini guídi, tuʼ gal-la xisi uva cubi naʼ, en uláʼa buzudi bidxi naʼ néquini guídi, ateʼ ilalaj xisi uva naʼ, en gaca ditaj buzudi néquini guídi. Xisi uva cubi lu buzudi néquini guídi cubi ral-laʼ cáʼaruʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tu dza láʼayi quégaquiëʼ bönniʼ judío, gudödëʼ Jesús gapa dë yöla zxoaʼ xtila, ateʼ bönniʼ usëda queëʼ gulaʼsí lógaquiëʼ taʼlecjëʼ do ga dxía zxoaʼ xtila. ");
INSERT INTO zarNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Níʼirö bönniʼ yudoʼ fariseo gulë́ʼ Jesús, taʼnnë́ʼ: —Buyútsöcaʼ. ¿Bizx que tunëʼ bönniʼ dáʼgaquiëʼ Liʼ le cabí ral-laʼ gunruʼ dza láʼayi? ");
INSERT INTO zarNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús gudxëʼ légaquiëʼ: —¿Naruʼ cabí nulábaniliʼ ca benëʼ David cateʼ gudunëʼ? Biyadzaj le ilahuëʼ lëʼ, en nupa nacuáʼlen lëʼ ");
INSERT INTO zarNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ateʼ guyáziëʼ lu yuʼu queëʼ Dios cateʼ niʼ náquiëʼ bixúz lo Abiatar, en gudahuëʼ yöta xtila tuʼcuʼë lahuëʼ Dios, lë naʼ bitiʼ dë lataj nu gagu, pero tuz bixúz dë lataj ilahuëʼ le. Bëʼë caʼ le ilahuëʼ bönniʼ nacuáʼlenëʼ lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Níʼirö Jesús gudxëʼ légaquiëʼ: —Dios benëʼ dza láʼayi le uluʼzíʼ xibé bönachi, calëga benëʼ bönachi para ilún chiʼi dza láʼayi. ");
INSERT INTO zarNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Que lë ni naʼ, nedaʼ, Bönniʼ Guljëʼ Bönachi, nacaʼ Xani dza láʼayi. ");
INSERT INTO zarNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Leyúbölö guyuʼë Jesús tu lu yuʼu ga tuʼdubëʼ tuʼsëdëʼ bönniʼ judío queëʼ Dios, ateʼ zoëʼ caʼ niʼ tu bönniʼ narequiʼ nëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bönniʼ yudoʼ nacuʼë niʼ tuʼyúëʼ Jesús channö únëʼ bönniʼ naʼ dza láʼayi, tuʼ të́ʼënnëʼ uluʼzéguiʼë Lëʼ didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Níʼirö Jesús gudxëʼ bönniʼ naʼ narequiʼ nëʼë, rnnëʼ: —Guyasa, en guzuí lógaca bönachi ni. ");
INSERT INTO zarNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jesús gunábinëʼ bönachi niʼ, rnnëʼ: —¿Naruʼ dë lataj gunruʼ le naca dxiʼa cateʼ naca dza láʼayi o gunruʼ le ruáʼ döʼ? ¿Naruʼ dë lataj gunruʼ ga ilaʼdeliʼ bönachi yöl-laʼ naʼbán o usunítiruʼ le? Gulaʼcuáʼ dxisö bönachi niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Níʼirö len yöl-laʼ rilé queëʼ, buyúëʼ Jesús bönachi naʼ nacuáʼ gásibiʼilëʼ. Ruhuíʼinnëʼ tuʼ nácagaquiëʼ zidi ladxiʼ. Gudxëʼ bönniʼ naʼ narequiʼ nëʼë, rnnëʼ: —Bulí noʼo. Níʼirö bulí nëʼë bönniʼ naʼ, ateʼ böácatë dxíʼadoʼ nëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Níʼirö buluʼrúajëʼ bönniʼ yudoʼ fariseo, ateʼ laʼ guluntëʼ tsözxö́n didzaʼ len bönniʼ dáʼgaquiëʼ Herodes bi ilunëʼ queëʼ Jesús, para ilútiëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Buzë́ʼë Jesús niʼ tsözxö́n len bönniʼ dáʼgaquiëʼ Lëʼ, en bidxinëʼ raʼ nísadoʼ, ateʼ söjácalen Lëʼ bönachi zián narúajgaca luyú Galilea, en luyú Judea. ");
INSERT INTO zarNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Bönachi zián narúajgaca Jerusalén, en luyú Idumea, en iaʼtsöláʼa yegu Jordán, en yuguʼ yödzö nacuáʼ idú gásibiʼilö ga nacuáʼ yödzö Tiro, en yödzö Sidón bilaʼdxín caʼ ga zoëʼ Jesús. Caní gulunëʼ, tuʼ bilaʼyönnëʼ ca nácagaca yuguʼ le zxön runëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Que lë ni naʼ Jesús gunná béʼenëʼ bönniʼ dáʼgaquiëʼ Lëʼ uluʼcö́zticaʼsëʼ tu bárcodoʼ ga gaca cuenëʼ, para cabí uluʼquí bönachi zián naʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Caní guca tuʼ chibunëʼ zián nupa teʼe, ateʼ bilaʼguírö bönachi zián naʼ ga zoëʼ para ilaʼgán Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Cateʼ böʼ xihuiʼ yúʼugaca bönachi bilaʼléʼe Jesús, buluʼdxigaʼ bönachi naʼ yúʼugaca xiniʼë Jesús, ateʼ gulaʼbö́dxiʼa, taʼnná: —Nacuʼ Liʼ Zxíʼinëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesús buzenëʼ le bach böʼ xihuiʼ naʼ, cabí ilaʼguixjöʼ nu náquiëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Níʼirö gurenëʼ Jesús tu lu guíʼadoʼ, ga niʼ bulidzëʼ nupa rë́ʼënëʼ. Gulaʼbiguëʼë bönniʼ ni gásibiʼilëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jesús bucuʼë chínnuëʼ bönniʼ ni, para ilaʼcuáʼlenëʼ Lëʼ, en para isö́l-lëʼë légaquiëʼ tsöjéngaquiëʼ libán. ");
INSERT INTO zarNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Budödëʼ lu náʼagaquiëʼ yöl-laʼ huáca uluʼúnëʼ nupa teʼe, en uluʼbéajëʼ böʼ xihuiʼ yúʼugaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Caní nácagaca lágaquiëʼ: Simón, (buzóëʼ Jesús iaʼtú lëʼ, Pedro), ");
INSERT INTO zarNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo, Juan, (bönniʼ bö́chëʼë Jacobo, ateʼ nácagaquiëʼ zxíʼinëʼ Zebedeo. Chopëʼ ni, Jesús buzóëʼ iaʼtú lágaquiëʼ, Boanerges, le rnna lu didzaʼ xidzaʼ: Bönniʼ síniaʼ ca guziúʼ), ");
INSERT INTO zarNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo, (zxíʼinëʼ Alfeo), Tadeo, Simón, (bönniʼ ruíʼi ládxëʼë yödzö queëʼ), ");
INSERT INTO zarNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote, (bönniʼ udödëʼ Jesús lu náʼagaquiëʼ bönniʼ ilútiëʼ Lëʼ). Gudödi niʼ Jesús len bönniʼ dáʼgaquiëʼ Lëʼ buluʼdxinëʼ tu lu yuʼu. ");
INSERT INTO zarNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Leyúbölö bilaʼguírö bönachi zián ga zoëʼ Jesús, ateʼ bítiʼrö gutaʼ lataj bi ilahuëʼ Jesús, en bönniʼ naʼ dáʼgaquiëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Cateʼ diʼa dza queëʼ Jesús bilaʼyönnëʼ ca raca queëʼ, bilaʼdxinëʼ niʼ para uluʼchë́ʼë Lëʼ, taʼnnë́ʼ: Richixi icjëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Lëscaʼ caní bönniʼ yudoʼ usedi, narúajgaquiëʼ Jerusalén gulaʼnnë́ʼ queëʼ, taʼnnë́ʼ: —Dzaga Belzebú, xángaca böʼ xihuiʼ Lëʼ, ateʼ len yöl-laʼ unná bëʼ que rubéajëʼ yuguʼ böʼ xihuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Níʼirö Jesús bulidzëʼ yuguʼ bönniʼ yudoʼ usedi naʼ, en bucúdzuʼë didzaʼ, rnnëʼ: —¿Naruʼ ubéaj laʼ cuinsi Satanás tuʼ xihuiʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Channö ilaʼrúaj choplö bönachi tu yödzö, en ilaʼdíl-lalen luzë́ʼeguequi, bitiʼ gaca idíaʼ yödzö naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Lëscaʼ caní channö ilaʼrúaj choplö bönachi nacuáʼ tu yuʼu, en ilaʼdíl-lalen luzë́ʼeguequi, bitiʼ gaca ilaʼdíaʼ bönachi nacuáʼ yuʼu naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Que lë ni naʼ, channö Satanás tuʼ xihuiʼ táʼbagaʼ luzë́ʼe, narúajgaca choplö böʼ xihuiʼ. Bitiʼ gaca idíaʼ yöl-laʼ unná bëʼ que, pero chizóa údxi que. ");
INSERT INTO zarNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Cuntu nu gaca tsuʼu lidxëʼ tu bönniʼ nál-la, en cuéaj yöl-laʼ tsahuiʼ queëʼ channö cabí gagaʼ zíʼalö bönniʼ nál-la naʼ, ateʼ níʼirö sequiʼ cuéaj le dzöʼö lidxëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Le nácatë reaʼ libíʼiliʼ: Dios gaca uniti lahuëʼ bönachi ca naca yúguʼtë dul-laʼ nabágaʼgaca, en ca naca yúguʼtë didzaʼ schanníʼ taʼnná, ");
INSERT INTO zarNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","pero nútiʼtës nu innë́ schanníʼ queëʼ Dios Böʼ Láʼayi, catu caz uniti lahuëʼ Dios nu naʼ. Tsaz nabagaʼ xíguiaʼ nu naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Caní gunnë́ʼ Jesús tuʼ taʼnnë́ʼ queëʼ bönniʼ yudoʼ usedi naʼ, taʼnnë́ʼ: —Tuʼ xihuiʼ dzaga Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Níʼirö bilaʼdxinëʼ yuguʼ bönniʼ bö́chëʼë Jesús, encaʼ xinë́ʼë ga zoëʼ. Gulaʼcuʼë lö́ʼalö, en gulaʼsö́l-lëʼë nu tsöjlidza Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Bönachi zián naʼ rö́ʼgaca cuitëʼ Jesús gulë́ Lëʼ, taʼnná: —Yuguʼ bönniʼ bö́chuʼu, encaʼ xinóʼo nacuʼë lö́ʼalö, tuʼlidzëʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Bubiʼë didzaʼ Jesús, gudxëʼ légaquiëʼ: —¿Nuzxi caz naʼ xináʼa, en nupxi caz yuguʼ bönniʼ bö́chaʼa? ");
INSERT INTO zarNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Níʼirö buyúëʼ nupa naʼ rö́ʼgaca gásibiʼilëʼ, rnnëʼ: —Buliʼyútsöcaʼ. Nupa ni nácagaca ca xináʼa, en yuguʼ bönniʼ bö́chaʼa. ");
INSERT INTO zarNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nu run ca rë́ʼënëʼ Dios, nu ni naca ca biʼi bö́chaʼa, en biʼi zanaʼ encaʼ xináʼa. ");
INSERT INTO zarNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Leyúbölö gusí lahuëʼ Jesús rusédinëʼ bönachi ga naca raʼ nísadoʼ. Buluʼdubi bönachi zián ga zoëʼ, ateʼ gurenëʼ Jesús tu lëʼe bárcodoʼ zxoa lu nisa naʼ, en guröʼë niʼ, ateʼ yúguʼtë bönachi naʼ gulaʼcuáʼ luyú raʼ nisa naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Zián le busédinëʼ Jesús légaquiëʼ, bucúdzuʼë didzaʼ. Tsanni niʼ rusédinëʼ légaquiëʼ, rnnëʼ: ");
INSERT INTO zarNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Guliʼzë́ nágaliʼ didzaʼ ni. Birúajëʼ tu bönniʼ guz, söjë́siëʼ xisedoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tsanni niʼ rúsiëʼ, gulasi bal-la xisedoʼ naʼ raʼ nöza, ateʼ bilaʼdxinbaʼ biguínnidoʼ, gulë́ʼajbaʼ le. ");
INSERT INTO zarNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Gulasi iaʼbal-la xisedoʼ naʼ ga röʼö guiö́j ga bitiʼ röʼö yenniʼ yu. Bayö́n gulaʼlén xisedoʼ naʼ tuʼ cabí röʼö yenniʼ yu. ");
INSERT INTO zarNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Níʼirö cateʼ gulén gubidza, buquexuʼ le, ateʼ gubidxi, tuʼ cabí nun luí ga rëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Gulasi iaʼbal-la xisedoʼ naʼ ga tuʼlén lubá yötsiʼ. Cateʼ gulaʼlén xisedoʼ naʼ, buluʼlén caʼ lubá yötsiʼ naʼ, en gulaʼröli le, ateʼ lë naʼ bësiëʼ bitiʼ bi bunödzaj. ");
INSERT INTO zarNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Gulasi iaʼbal-la xisedoʼ naʼ ga naca luyú bëbu, ateʼ gulaʼzxö́n, en xitsáʼ raʼ gulaʼbö́ʼ. Buluʼnödzaj lë naʼ bësiëʼ. Tu dxiguʼ xisedoʼ naʼ bësiëʼ bunödzaj iaʼchí uruáʼ xisedoʼ caʼ. Iaʼtú bunödzaj iaʼtsónnalalaj caʼ, ateʼ iaʼtú naʼ bunödzaj iaʼtú gayuáʼ caʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Níʼirö Jesús gudxëʼ légaquiëʼ, rnnëʼ: —Nu zoa nagui, en riyöni ral-laʼ uzë́ nagui. ");
INSERT INTO zarNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Cateʼ chibugáʼanëʼ tuzëʼ Jesús, bilaʼdxín nupa dáʼgaca Lëʼ ga zoëʼ, núngaca tsözxö́n idxínnutëʼ bönniʼ usëda queëʼ, ateʼ gulaʼnábinëʼ Lëʼ bi saʼyéaj lë naʼ bucúdzuʼë didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesús gudxëʼ légaquiëʼ, rnnëʼ: —Libiʼiliʼ nadéliʼliʼ tséajniʼiliʼ le nagachiʼ ca rinná bëʼë Dios, pero nupa naʼ bitiʼ nácagaca tuz len rëʼu, ruíʼilenaʼ légaquiëʼ didzaʼ yuguʼ le rucúdzuʼa didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Caní runaʼ para gaca lë naʼ nazúaj lu guichi láʼayi, rnna: Uluʼyúëʼ, en bitiʼ ilaʼléʼenëʼ. Uluʼzë́ nágagaquiëʼ, en bitiʼ ilaʼyéajniʼinëʼ. Bitiʼ uluʼbíʼi ládxiʼgaquiëʼ para gaca uniti lahuaʼ légaquiëʼ ca naca dul-laʼ nabágaʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesús gudxëʼ caʼ yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ, rnnëʼ: —¿Naruʼ cabí réajniʼitseliʼ lë naʼ bucúdzuʼa didzaʼ? ¿Nacxi caz gaca tséajniʼiliʼ iaʼzícaʼrö le ucúdzuʼa didzaʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bönniʼ guz naʼ náquiëʼ nu ruzë́ xtídzëʼë Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","’Nácagaca bal-la bönachi ca xisedoʼ naʼ gulasi raʼ nöza. Taʼyönnëʼ xtídzëʼë Dios, en ca taʼyö́nisinëʼ caʼ, laʼ zaʼtë Satanás tuʼ xihuiʼ, en rigúa didzaʼ naʼ bidxín lu icja ládxiʼdoʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","’Nácagaca iaʼbal-la bönachi ca xisedoʼ naʼ gulasi ga röʼö guiö́j. Taʼyönnëʼ didzaʼ naʼ, ateʼ len yöl-laʼ rudzeja quégaquiëʼ taʼziʼë le. ");
INSERT INTO zarNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Bitiʼ riyaza icja ládxiʼdoʼgaquiëʼ, ateʼ tu chíʼisö taʼdë́ʼë le. Cateʼ bi raca quégaquiëʼ, o zoa nu ribía ladxiʼ légaquiëʼ tuʼ taʼdë́ʼë didzaʼ naʼ, laʼ tuʼhuö́atë ládxiʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","’Nácagaca iaʼbal-la bönachi ca xisedoʼ naʼ gulasi ga naʼ tuʼlén lubá yötsiʼ. Taʼyönnëʼ didzaʼ naʼ, ");
INSERT INTO zarNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pero tuíʼi ládxiʼgaquiëʼ le nácagaca que yödzölió ni. Nazíʼ yéʼeguequinëʼ tuʼ nadxíʼiguequinëʼ yuguʼ yöl-laʼ tsahuiʼ, en taʼzë́ ládxiʼgaquiëʼ yuguʼ le dë. Taʼyaza icja ládxiʼdoʼgaquiëʼ yúguʼtë lë ni, en tuʼsuniti didzaʼ naʼ, para cabí gun dxin lu icja ládxiʼdoʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","’Nácagaca iaʼbal-la bönachi ca xisedoʼ naʼ gulasi ga naca luyú bëbu. Taʼyönnëʼ didzaʼ naʼ, en taʼzíʼ lu náʼagaquiëʼ le, ateʼ run dxin lu icja ládxiʼdoʼgaquiëʼ. Nácagaca bal-la bönachi caní ca xisedoʼ naʼ buluʼnödzaj iaʼchí uruáʼ huéaj. Nácagaca iaʼbal-lëʼ ca xisedoʼ naʼ buluʼnödzaj iaʼtsónnalalaj caʼ, ateʼ nácagaca iaʼbal-la bönachi ca xisedoʼ naʼ buluʼnödzaj iaʼtú gayuáʼ caʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesús gudxëʼ caʼ bönniʼ dáʼgaquiëʼ Lëʼ, rnnëʼ: —¿Naruʼ rigálaʼruʼ guíʼ, ateʼ rudúsiʼruʼ le tu guíʼina, o rigúʼuruʼ le zxani le rátiʼruʼ? Bitiʼ caʼ runruʼ caní. Ruzóaruʼ guíʼ ga naca xitsáʼ ga cuʼu beníʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yúguʼtë le nagachiʼ iláʼ lahui, ateʼ yúguʼtë le raca balándoʼos ilaʼrúaj ga lináʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nu zoa nagui, en riyöni ral-laʼ uzë́ nagui. ");
INSERT INTO zarNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Gudxëʼ caʼ légaquiëʼ: —Guliʼgüíʼ ládxiʼliʼ le riyö́niliʼ. Ca naca le ruríxiliʼ, laʼ leze urixëʼ Dios queë́liʼ, ateʼ gunnëʼ queë́liʼ iaʼlatiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nu nazíʼi le zaʼ que, guʼë que iaʼlatiʼ, pero nu bitiʼ nazíʼi le, laʼs dui le dë que, udúa. ");
INSERT INTO zarNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Gunnë́ʼ caʼ Jesús: —Ca raca ni le rinná bëʼë Dios naca ca raca cateʼ ruchejëʼ tu bönniʼ zxoaʼ xtila lu yu. ");
INSERT INTO zarNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Chiʼi dzö́ʼölö rásiëʼ, en riyasëʼ cateʼ zaʼ reníʼ. Taʼlén zxoaʼ xtila naʼ, en taʼzxö́n, pero bitiʼ nö́zinëʼ lëʼ nacxi raca taʼzxö́n. ");
INSERT INTO zarNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Laʼ cuinsi luyú naʼ ruxö́n le nadúzgaca luyú naʼ, zíʼalö xiyazi, níʼirö zaʼ do que, en tödi naʼ cuía xuiʼi nál-la lu do que. ");
INSERT INTO zarNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Cateʼ chinal-la xuiʼi naʼ, laʼ tséajtëʼ tsöjchibëʼ do naʼ tuʼ chibidxín dza uziʼë xuiʼi. ");
INSERT INTO zarNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Gunnë́ʼ caʼ Jesús: —¿Bizxi caz innaruʼ ca raca ni le rinná bëʼë Dios? ¿Bizxi ucúdzuʼruʼ didzaʼ ca raca? ");
INSERT INTO zarNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Raca ca raca que tu xisedoʼ mostaza. Cateʼ riyaza luyú naca tu xisedoʼ nácatërö cuidiʼ ca yúguʼtë xisedoʼ dzöʼö luyú, ");
INSERT INTO zarNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","pero cateʼ chinadúz, rilén, en rizxö́ntërö ca yúguʼtë guixiʼ cuan rö́ʼgaca luyú. Tsca run yanaʼ niʼa nëʼe, gaca ilaʼdxinbaʼ biguínnidoʼ, en uluʼdxíabaʼ xicáʼagacabaʼ lu zxul-la que. ");
INSERT INTO zarNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Caní guca, busédinëʼ Jesús légaquiëʼ, en ziánrö caʼ le bucúdzuʼë didzaʼ tsca guca ilaʼyéajniʼinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yúguʼtë didzaʼ bë́ʼlenëʼ bönachi bucúdzuʼë didzaʼ, ateʼ yúguʼtë didzaʼ ni buchila láʼanëʼ, buzéajniʼinëʼ légacasëʼ bönniʼ usëda queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Laʼ dza náʼasö, cateʼ ridzö́ʼ, Jesús gudxëʼ yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ, rnnëʼ: —Tö́ditsöcaʼruʼ iaʼtsöláʼa nísadoʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Níʼirö buluʼláʼalenëʼ bönachi zián nacuáʼ niʼ, ateʼ buluʼsë́ʼë bárcodoʼ ga naʼ chizóasëʼ Jesús. Gulaʼcuáʼ caʼ niʼ iaʼzícaʼrö bárcodoʼ söjácalen légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Gusí lo recja böʼ budunuʼ lu nisa naʼ, ateʼ gudáʼa nisa lëʼe bárcodoʼ naʼ. Caʼ guca, zeaj ridzáʼ nisa lëʼe bárcodoʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Dëʼ rásiëʼ Jesús lu xicúgüëʼ ga naca xitsáʼalö lëʼe bárcodoʼ naʼ, ateʼ buluʼsubanëʼ Lëʼ. Tëʼ Lëʼ: —¡Bönniʼ Usedi! ¿Naruʼ cabí ruíʼi ládxiʼtsoʼ netuʼ? ¡Huáti caztuʼ lu nisa ni! ");
INSERT INTO zarNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Níʼirö guyasëʼ Jesús, en gunná béʼenëʼ böʼ naʼ recja, gunnë́ʼ: —Gurö́ʼö dxi. Gudxëʼ caʼ nisa naʼ, gunnë́ʼ: —Dxisö guzóa. Gurö́ʼö dxi böʼ naʼ guyecja, en guzóa dxi lu nísadoʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Níʼirö Jesús gudxëʼ yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ, rnnëʼ: —¿Bizx que radxi ridzö́biliʼ caní? ¿Naruʼ cabí réajlëʼëliʼ Dios? ");
INSERT INTO zarNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Niʼ tádxinëʼ gulë́ luzë́ʼë tuëʼ iaʼtúëʼ: —¿Nuzxi caz bönniʼ ni? ¡Tun böʼ recja, en nísadoʼ ca rnna xtídzëʼë! ");
INSERT INTO zarNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Níʼirö bilaʼdxinëʼ Jesús, en yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ iaʼtsöláʼa nísadoʼ ga naca lu xiyúgaca bönachi Gadara. ");
INSERT INTO zarNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Cateʼ burúajëʼ Jesús lëʼe bárcodoʼ naʼ, tu bönniʼ rirúajëʼ zxan bulóaj ga nacuáʼ yeru ba laʼ dutságatëʼ Lëʼ. Bönniʼ ni yuʼu böʼ xihuiʼ lëʼ, ");
INSERT INTO zarNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ateʼ nun xilatjëʼ ga naʼ nacuáʼ yeru ba. Cuntu nu guca gugaʼ bönniʼ naʼ, calëga len du guíë. ");
INSERT INTO zarNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Zián luzuí buluʼzóëʼ breguiʼ guíë yen nëʼë, en niʼë, en gulúguiʼë lëʼ du guíë. Yuguʼ du guíë naʼ bulë́ʼë, ateʼ breguiʼ guíë naʼ guditsjëʼ. Bitiʼ rizéquiʼnëʼ nu bönniʼ inná béʼenëʼ lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ridáticaʼsëʼ ribö́dxiʼë rëla, en të dza ga naʼ nacuáʼ yeru ba, en gapa naca lu guíʼadoʼ, run huëʼ cuinëʼ yuguʼ lu guiö́j dzöʼö niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Cateʼ biléʼenëʼ zëʼë ziʼtuʼ Jesús, guxítiʼë guyijëʼ ga naʼ zëʼë, ateʼ buzóa zxibëʼ lahuëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Bëʼë zidzaj didzaʼ, rëʼ Jesús: —¿Bizxi ral-laʼa quiuʼ Jesús, Zxíʼinëʼ Dios nayë́pisëtërëʼ? Niʼa queëʼ Xanruʼ Dios rátaʼyuaʼ loʼ, bitiʼ usacaʼ ziʼu nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Caní gunnë́ʼ bönniʼ naʼ tuʼ chigudxëʼ Jesús böʼ xihuiʼ naʼ: —Liʼ, böʼ xihuiʼ, burúaj lu bönniʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús gunábinëʼ le, rnnëʼ: —¿Bi leuʼ? Bubíʼi didzaʼ le, gudxi Lëʼ: —Leaʼ: Le Zián, tuʼ röʼö ziantuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Gulaʼnabi yechiʼ yuguʼ böʼ xihuiʼ naʼ Jesús para cabí isö́l-lëʼë léguequi ziʼtuʼ luyú niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nacuáʼabaʼ cuchi zián lu guíʼadoʼ níʼisö, taʼdabaʼ tágubaʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Gulaʼnabi yechiʼ böʼ xihuiʼ naʼ Jesús, taʼnná: —Gusöl-laʼ netuʼ ga niʼ dzö́ʼöbaʼ cuchi zián. Bëʼ netuʼ lataj tsöjtsúʼugacatuʼ-baʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Laʼ bëʼtëʼ Jesús léguequi lataj, ateʼ bilaʼrúaj böʼ xihuiʼ naʼ, en yöjtsúʼugaca cuchi zián naʼ, ateʼ gulaʼxítiʼbaʼ cuchi zián naʼ, yöjbíxigacabaʼ ga naca raʼ guíʼa, yöjcházagacabaʼ nísadoʼ. Lu nísadoʼ naʼ gulaʼyë́pibaʼ nisa, gulátibaʼ, en nácagacabaʼ ca galaj gayuáʼabaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Níʼirö buluʼzxunnaj nupa niʼ gulún chiʼi cuchi zián naʼ. Yöjtíxjöiʼiguequinëʼ bönachi lu yödzö niʼ, encaʼ bönachi nacuáʼ laʼ guixiʼ niʼ. Bilaʼrúaj bönachi lu yödzö, söjyúgaquiëʼ bizxi naʼ guca niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Cateʼ bilaʼdxinëʼ ga niʼ zoëʼ Jesús, bilaʼléʼenëʼ bönniʼ naʼ zíʼalö yúʼugaca böʼ xihuiʼ lëʼ. Bönniʼ ni röʼë niʼ, nácuëʼ lariʼ, en zoëʼ dxíʼadoʼ, ateʼ guladxi bönachi naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nupa naʼ bilaʼléʼe le benëʼ Jesús gulaʼguíxjöiʼi bönachi naʼ bilaʼrúaj lu yödzö ca naʼ guca queëʼ bönniʼ naʼ zíʼalö yúʼugaca böʼ xihuiʼ lëʼ, encaʼ ca guca quégacabaʼ cuchi naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Níʼirö gulaʼsí lógaca bönachi zián naʼ taʼtaʼyu lahuëʼ Jesús urúajëʼ lu xiyúguequi. ");
INSERT INTO zarNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Cateʼ bubenëʼ Jesús lëʼe bárcodoʼ, bönniʼ naʼ zíʼalö yúʼugaca böʼ xihuiʼ zián lëʼ, gútaʼyuëʼ lahuëʼ Jesús guʼë lëʼ lataj tséajlenëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesús bitiʼ bëʼë lëʼ lataj, pero gudxëʼ lëʼ: —Böaj lidxuʼ. Yöjtíxjöiʼi diʼa dza quiuʼ yuguʼ le zxön benaʼ quiuʼ nedaʼ, nacaʼ Xanuʼ, en ca benaʼ buéchiʼ ládxaʼa liʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Söhuö́jëʼ bönniʼ naʼ, en ruzë́ʼ didzaʼ yuguʼ yödzö Decápolis ca nácagaca le zxön benëʼ Jesús queëʼ, ateʼ buluʼbani yúguʼtë bönachi nacuáʼ yuguʼ yödzö niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Cateʼ budxinëʼ Jesús iaʼtsöláʼa nísadoʼ naʼ, níʼirö buluʼdubi bönachi zián ga naʼ zoëʼ raʼ nísadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Bönniʼ lëʼ Jairo, bönniʼ rinná bëʼë lu yuʼu ga tuʼdubëʼ bönniʼ judío, en nazëdëʼ queëʼ Dios, bidëʼ ga zoëʼ Jesús. Cateʼ biléʼenëʼ Jesús, buzóa zxibëʼ lahuëʼ, ");
INSERT INTO zarNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","en gútaʼyuëʼ lahuëʼ, rnnëʼ: —Chiraqui gátibiʼ biʼi nigúladoʼ quiaʼ. Gudá ixóa noʼo lëbiʼ para huöácabiʼ, en bitiʼ gátibiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Saʼyéajlenëʼ Jesús lëʼ, ateʼ bönachi zián söjácalen Jesús, tuʼquirö Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tu nigula, chinaca chinnu iz réʼenu, zóanu caʼ niʼ. Bitiʼ ruhuíʼi rön queë́nu que huëʼ quégaca cázanu nigula. ");
INSERT INTO zarNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yenniʼ chigudíʼi guzxácaʼnu lu náʼagaquiëʼ zián bönniʼ tuʼúnëʼ bönachi. Nítisö chibutönu dëra le dë queë́nu, tuʼ cabí bi gúcalen lënu, pero riyaliʼ queë́nu. ");
INSERT INTO zarNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Cateʼ biyö́ninu tuíʼi didzaʼ bönachi ca naca queëʼ Jesús, gudö́dinu ládjalö bönachi zián naʼ, en bidxinnu zacaʼ cúdzuʼlëʼ Jesús, en gudannu lariʼ nácuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Caní bennu tuʼ rnnanu: “Channö cansaʼ le nácuëʼ, huöácaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Laʼ buíʼitë rön queë́nu, ateʼ réquibeʼenu chiböácanu que le guca queë́nu. ");
INSERT INTO zarNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Laʼ gúquibeʼetenëʼ Jesús ben dxin yöl-laʼ huáca queëʼ, ateʼ buécjëʼ, ruyúëʼ bönachi zián naʼ. Rnnëʼ: —¿Nuzxi naʼ gudán nedaʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Níʼirö bönniʼ dáʼgaquiëʼ Lëʼ tëʼ Lëʼ, taʼnnë́ʼ: —Riléʼe quézinuʼ bönachi zián ni tuʼquirö Liʼ, en rnnatsoʼ: “¿Nuzxi naʼ gudán nedaʼ?” ");
INSERT INTO zarNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ruyúëʼ Jesús gásibiʼilëʼ para iléʼenëʼ nuzxi naʼ gudán Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Níʼirö nigula naʼ gubígaʼnu lahuëʼ. Rádxinu, en rizxízinu tuʼ chinö́zinu bi naʼ guca queë́nu, ateʼ buzóa zxíbinu lahuëʼ Jesús, en gúdxinu Lëʼ idútë le nácatë. ");
INSERT INTO zarNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús rëʼë-nu: —Nigúladoʼ. Chiböácuʼ tuʼ réajlëʼu nedaʼ. Böaj lidxuʼ idú ládxuʼu. Tsaz nuhuöácuʼ que le guca quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tsanni niʼ ruʼë caní didzaʼ Jesús, bönniʼ narúajgaquiëʼ lidxëʼ bönniʼ naʼ rinná bëʼë lu yuʼu ga tuʼdubëʼ tuʼsëdëʼ queëʼ Dios bilaʼdxnëʼ niʼ, en tëʼ bönniʼ naʼ: —Chigútibiʼ biʼi nigúladoʼ quiuʼ. Bítiʼrö upízxjanuʼ Bönniʼ Usedi. ");
INSERT INTO zarNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Bitiʼ bëʼ ládxëʼë Jesús lë naʼ taʼnnë́ʼ, ateʼ gudxëʼ bönniʼ unná bëʼ naʼ, rnnëʼ: —Bitiʼ gádxinuʼ. Guyéajlëʼësëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Bitiʼ bëʼë lataj Jesús tsöjácalen Lëʼ iaʼzícaʼrö bönachi, pero légacasëʼ Pedro, en Jacobo, en Juan, bö́chëʼë Jacobo naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Cateʼ bidxinëʼ lidxëʼ bönniʼ naʼ rinná bëʼë ga tuʼdubëʼ tuʼsëdëʼ queëʼ Dios, biléʼenëʼ raca dzatsa, encaʼ nupa niʼ taʼbödxi, en nupa taʼbödxi yechiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Guyáziëʼ Jesús, en gudxëʼ légaquiëʼ: —¿Bizx que rutsátsaliʼ, en ribö́dxiliʼ caní? Bitiʼ nátibiʼ biʼi nigúladoʼ ni. Rásisibiʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Níʼirö buluʼtitjëʼ Jesús, pero Lëʼ bubéajëʼ yúguʼtë bönachi naʼ níʼilö, ateʼ guchë́ʼë xuz xináʼabiʼ biʼi nigúladoʼ naʼ, encaʼ nupa nacuáʼlen Lëʼ, ateʼ guyáziëʼ ga naʼ dëbiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Gudélëʼë náʼabiʼ biʼi nigúladoʼ naʼ, en gudxëʼ-biʼ: —Talita, cumi. Didzaʼ hebreo ni rnna lu didzaʼ xidzaʼ: Biʼi nigúladoʼ, guyasa. ");
INSERT INTO zarNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Laʼ guyásatëbiʼ biʼi nigúladoʼ naʼ, en buzéʼebiʼ. Chiyúʼubiʼ chinnu iz. Buluʼbani nupa nacuáʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Níʼirö Jesús gunná béʼenëʼ légaquiëʼ cuntu nu uluʼsiyönnëʼ lë naʼ guca. Gudxëʼ légaquiëʼ: —Guliʼgüíʼ le gágubiʼ biʼi nigúladoʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Buzë́ʼë Jesús niʼ, budxinëʼ ladzëʼ, ateʼ yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ söjácalenëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Cateʼ bidxín dza láʼayi quégaquiëʼ bönniʼ judío, gusí lahuëʼ Jesús rusédinëʼ bönachi ga naʼ tuʼdubëʼ tuʼsëdëʼ queëʼ Dios. Gulaʼcuáʼ bönachi zián niʼ taʼyöni Lëʼ. Buluʼbani, taʼnná: —¿Gazxi caz bizë́dëʼ bönniʼ ni yuguʼ lë ni? ¿Bizxi caz yöl-laʼ réajniʼi ni nadéliʼnëʼ? ¿Nacxi caz runëʼ le nácagaca bëʼ naʼ záʼgaca yehuaʼ yubá? ");
INSERT INTO zarNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Náquiëʼ bönniʼ ni gubëdxi yaga naʼ, en zxíʼininu María. Náquiëʼ bö́chiʼgaquiëʼ Jacobo, en José, en Judas, en Simón. Nigula zanëʼ nacuáʼlennu caʼ rëʼu. Que lë ni naʼ buluʼcáʼanëʼ Lëʼ cáʼasö. ");
INSERT INTO zarNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Níʼirö Jesús gudxëʼ légaquiëʼ, rnnëʼ: —Gátiʼtës tunëʼ bal nu bönniʼ ruʼë didzaʼ uláz queëʼ Dios, pero bönachi uládz queëʼ, en bönachi diʼa dza queëʼ, en bönachi nacuáʼ lidxëʼ bitiʼ tun lëʼ bal. ");
INSERT INTO zarNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Que lë ni naʼ bitiʼ guca gunëʼ Jesús nitú yöl-laʼ huáca zxön niʼ. Bunsëʼ nabábasö bönachi teʼe cateʼ guxóa nëʼë léguequi. ");
INSERT INTO zarNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Bubáninëʼ Jesús tuʼ cabí taʼyéajlëʼ Lëʼ. Gudödi naʼ gudödëʼ yuguʼ yö́dzödoʼ nacuáʼ gásibiʼilö, rusë́dinëʼ bönachi niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Níʼirö bulidzëʼ Jesús idxínnutëʼ bönniʼ dáʼgaquiëʼ Lëʼ, en gusí lahuëʼ risö́l-lëʼë légaquiëʼ chopa huéajgaquiëʼ. Budödëʼ lu náʼagaquiëʼ yöl-laʼ unná bëʼ uluʼbéajëʼ yuguʼ böʼ xihuiʼ yúʼugaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Gunná béʼenëʼ légaquiëʼ bitiʼ bi iluʼë laʼ nöza, calëga yöxaj, calëga yöta, en calëga dumí bitiʼ ilaʼguʼë lu buzudi quégaquiëʼ, pero iluáʼasëʼ xiyágadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ral-laʼ uluʼdë́ʼë xiráchugaquiëʼ, pero calëga chopa lariʼ uluʼxóa yéngaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Gudxëʼ caʼ légaquiëʼ: —Gátiʼtës ga tsúʼuliʼ tu yuʼu, guliʼsóa yuʼu naʼ cateʼ uzáʼaröliʼ yödzö naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Channö tsúʼuliʼ tu yödzö ga bitiʼ ilún bönachi lu yödzö naʼ libíʼiliʼ bal, en bitiʼ uluʼzë́ nágagaquiëʼ xtídzaʼliʼ, buliʼrúaj niʼ, en buliʼquínnaj bëchtö daʼ lëʼe lábaliʼ. Lë ni gaca bëʼ nabágaʼgaquiëʼ xíguiaʼ. Le nácatë reaʼ libíʼiliʼ, cateʼ idxín dza ichúguiëʼ Dios quégaca bönachi, ilaʼguíʼi ilaʼzácaʼrö bönachi lu yödzö naʼ ca ilaʼguíʼi ilaʼzacaʼ bönachi Sodoma, en Gomorra, yuguʼ yödzö naʼ busunítiëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Níʼirö bilaʼrúajëʼ bönniʼ dáʼgaquiëʼ Lëʼ, yöjéngaquiëʼ libán ca ral-laʼ uluʼbíʼi ládxiʼgaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Buluʼbéajëʼ zián böʼ xihuiʼ yúʼugaca bönachi. Gulaʼguʼë le za zián nupa teʼe, ateʼ buluʼhuöáquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Biyönnëʼ Herodes, bönniʼ unná bëʼ, ca naca le runëʼ Jesús, tuʼ rizë́ didzaʼ gátiʼtës que yöl-laʼ huáca queëʼ. Bal-la bönachi taʼnná: —Chibubanëʼ Juan, bönniʼ niʼ buquilëʼ bönachi nisa, lu yöl-laʼ guti. Que lë ni naʼ napëʼ yöl-laʼ huáca runëʼ yuguʼ lë ni. ");
INSERT INTO zarNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Iaʼbal-la bönachi taʼnná: —Naquiëʼ Elías, bönniʼ bëʼë didzaʼ uláz queëʼ Dios dza niʼte. Iaʼbal-la bönachi taʼnná: —Naquiëʼ bönniʼ ruʼë didzaʼ uláz queëʼ Dios ca guláquiëʼ bönniʼ guluʼë didzaʼ uláz queëʼ dza niʼte. ");
INSERT INTO zarNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Cateʼ biyönnëʼ Herodes yuguʼ lë ni, gunnë́ʼ: —Naquiëʼ Juan, bönniʼ naʼ burixaʼ yenëʼ. Chibubanëʼ lu yöl-laʼ guti. ");
INSERT INTO zarNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Caní gunnë́ʼ Herodes tuʼ gusö́l-lëʼë lë cazëʼ bönniʼ yöjxö́ngaquiëʼ Juan naʼ, ateʼ gulúguiʼë lëʼ du guíë lu yuʼu lidxi guíë. Caní benëʼ Herodes tuʼ rilenu Herodías Juan naʼ. Nácanu nigula naʼ gúcanu nigula queëʼ Felipe, bö́chëʼë Herodes naʼ. Herodes gudúëʼ-nu Herodías naʼ, en butsaga náʼalenëʼ-nu. ");
INSERT INTO zarNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juan naʼ gudxëʼ Herodes: —Bitiʼ ral-laʼ sóalenuʼ-nu nigula queëʼ bö́chuʼu. ");
INSERT INTO zarNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Que lë ni naʼ gusí gurö́ʼönu Herodías. Gúʼuninu bi gunnu queëʼ Juan, tuʼ gúʼuninu gútinu lëʼ, pero bitiʼ bi guzxéquiʼnu ");
INSERT INTO zarNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","tuʼ rádxinëʼ Herodes Juan. Nö́zinëʼ náquiëʼ Juan naʼ tsahuiʼ, en láʼayi. Que lë ni naʼ gudapa chiʼë lëʼ, en buzë́ náguiëʼ lëʼ idú ládxëʼë sal-laʼ lë naʼ rnnëʼ Juan ben ga guröʼë böniga Herodes naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Níʼirö bidxín tu dza guzxéquiʼnu Herodías naʼ, le naca dza runëʼ Herodes laní que dza guyéʼenëʼ iz. Bupë́ʼë le ilëʼaj ilahuëʼ bönniʼ dë lu náʼagaquiëʼ uláz queëʼ, en bönniʼ taʼnná béʼenëʼ bönniʼ röjáquiëʼ gudil-la, encaʼ bönniʼ nácagaquiëʼ lo luyú Galilea. ");
INSERT INTO zarNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Guyázabiʼ biʼi nigula queë́nu Herodías ga naʼ tëʼaj tahuëʼ, en buyáʼabiʼ lógaquiëʼ. Guyaza ládxëʼë Herodes ca runbiʼ, en gulaʼyaza ládxiʼgaca caʼ nupa tëʼaj tágulen lëʼ. Níʼirö Herodes gudxëʼ-biʼ biʼi nigula naʼ, gunnë́ʼ: —Gunaba bi rë́ʼënuʼ gunnaʼ quiuʼ, ateʼ gunaʼ caʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Benëʼ tsutsu xtídzëʼë, gudxëʼ-biʼ: —Niʼa queëʼ Xanruʼ Dios gunnaʼ quiuʼ bítiʼtës bi inabuʼ ga idxintë gatsaj ga rinná bëʼa. ");
INSERT INTO zarNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Burúajbiʼ lëbiʼ, ateʼ gunábabiʼ xináʼabiʼ: —¿Bizxi inábatsaʼ? Lënu gúdxinu-biʼ: —Icjëʼ Juan, bönniʼ buquilëʼ bönachi nisa, inabuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Laʼ buázatëbiʼ ga naʼ zoëʼ Herodes, en rëbiʼ-nëʼ: —Rëʼëndaʼ ixúʼ quiaʼ naʼa lu zxigaʼ zxön icjëʼ Juan, bönniʼ naʼ buquilëʼ bönachi nisa. ");
INSERT INTO zarNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Níʼirö buíʼinnëʼ Herodes, pero tuʼ buzötjëʼ Dios, en tuʼ bilaʼyöni caʼ nupa tágulen lëʼ, bitiʼ gúʼunnëʼ initi xtídzëʼë naʼ guzxíʼ lu nëʼë queë́biʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Herodes laʼ gusö́l-laʼtëʼ tu bönniʼ rejëʼ gudil-la zoëʼ rapa chiʼë, ateʼ gunná béʼenëʼ lëʼ tsöjxiʼë icjëʼ Juan. ");
INSERT INTO zarNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Bönniʼ naʼ rejëʼ gudil-la guyijëʼ lidxi guíë, yöjrixëʼ yen Juan naʼ, ateʼ buʼë icjëʼ, nuxóëʼ le tu lu zxigaʼ zxön. Budödëʼ le lu náʼabiʼ biʼi nigula naʼ, ateʼ lëbiʼ bunö́dzjabiʼ le queë́nu xináʼabiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Cateʼ bönniʼ dáʼgaquiëʼ Juan naʼ bilaʼyönnëʼ didzaʼ chiguca lë naʼ, bilaʼdxinëʼ niʼ, en buluʼúʼë lëʼ, ateʼ yöjcáchiʼgaquiëʼ lëʼ yeru ba. ");
INSERT INTO zarNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Gudödi niʼ buluʼdubëʼ bönniʼ gubáz queëʼ Jesús ga zoëʼ, en gulaʼguíxjöiʼinëʼ Lëʼ yúguʼtë le gulunëʼ, en yuguʼ le buluʼsë́dinëʼ bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nacuáʼ bönachi zián niʼ, nupa záʼgaca, en nupa söjaca, ga bidxintë bítiʼrö dë lataj ilahuëʼ Jesús, en yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ. Que lë ni naʼ Jesús gudxëʼ légaquiëʼ, rnnëʼ: —Guliʼdá. Uyéaj cázaruʼ ga naca lataj cáʼasö, en uzíʼ ládxiʼruʼ tu chiʼi. ");
INSERT INTO zarNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Laʼ légacasëʼ yöjáquiëʼ tu lëʼe bárcodoʼ, ateʼ bilaʼdxinëʼ tu lataj cáʼasö. ");
INSERT INTO zarNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bilaʼléʼe bönachi zián légaquiëʼ söjáquiëʼ niʼ, en núnbëʼgaca Jesús. Que lë ni naʼ bönniʼ yúguʼtë yödzö niʼ carelö yöjáquiëʼ niʼ. Gulaʼzëʼe níʼagaquiëʼ, ateʼ bilaʼdxinëʼ niʼ zíʼatëlö ca Jesús, en yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Cateʼ burúajëʼ Jesús lëʼe bárcodoʼ naʼ, biléʼenëʼ bönachi zián naʼ, ateʼ buéchiʼ ládxëʼë légaquiëʼ tuʼ nácagaquiëʼ ca böʼcuʼ zxílaʼdoʼ bitiʼ zoa nu gapa chiʼi légacabaʼ. Gusí lahuëʼ rusë́dinëʼ légaquiëʼ le zián. ");
INSERT INTO zarNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Cateʼ chiridzö́ʼ dza naʼ, yuguʼ bönniʼ dáʼgaquiëʼ Jesús bilaʼdxinëʼ ga zoëʼ, en tëʼ Lëʼ: —Chiridzö́ʼ, ateʼ lataj cáʼasö naca ni. ");
INSERT INTO zarNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Busöl-laʼ bönachi zián ni para tsöjaca yuguʼ yúʼudoʼ, en yuguʼ yö́dzödoʼ nacuáʼ gásibiʼilö, tsöjö́ʼugaca yöta, tuʼ cabí bi dë ni le ilagu. ");
INSERT INTO zarNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Bubiʼë didzaʼ Jesús, gudxëʼ légaquiëʼ: —Guliʼgüíʼ libíʼi cázaliʼ le ilahuëʼ. Gulë́ʼ Lëʼ: —¿Naruʼ tsöjö́ʼutsatuʼ yöta xtila len lázxjatuʼ que idú xunuʼ beoʼ, ateʼ güíʼituʼ le ilahuëʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús gudxëʼ légaquiëʼ: —¿Bal-laxi yöta xtila dë queë́liʼ? Guliʼtsöjyútsöcaʼ. Cateʼ chinö́ziguequinëʼ, tëʼ Lëʼ: —Gáyuʼsö yöta xtila dë, en chópasöbaʼ böla dëbaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Níʼirö gunná bëʼë Jesús ilunëʼ ga ilaʼbö́ʼ bönachi zián naʼ, ilaʼcuáʼ tu cöʼ huéajguequi ga naca lachiʼ lu dacaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Gulaʼcuʼë tu cöʼ huéajgaquiëʼ, tu gayuáʼ huéajgaquiëʼ, en chi-un huéajgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Níʼirö gudélëʼë Jesús igáyuʼtë yöta xtila naʼ, en irópabaʼ böla naʼ. Buyúëʼ zacaʼ lúzxiba, en gudxëʼ Dios: “Xclenuʼ.” Níʼirö buzxuzxjëʼ yöta xtila naʼ, en bëʼë quégaquiëʼ bönniʼ usëda queëʼ para ilaʼguísiëʼ quégaca bönachi zián naʼ. Gudísiëʼ caʼ irópatëbaʼ böla naʼ quégaca yúguʼtë bönachi naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Gulahuëʼ yúguʼtëʼ, en buluʼhuö́ljanëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Níʼirö buluʼtubëʼ le bizxaj que yöta xtila naʼ, en quégacabaʼ böla, ateʼ chinnu gaʼböra buluʼlíëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Guláquiëʼ ca chi-un gáyuʼë bönniʼ naʼ gulahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Laʼ bentëʼ Jesús ga gulaʼbenëʼ yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ lëʼe bárcodoʼ, para ilaʼnö́ruëʼ lahuëʼ, ilaʼdödëʼ lu nísadoʼ naʼ, para ilaʼdxinëʼ lu yödzö Betsaida, tsanni niʼ Lëʼ rusöl-lëʼ bönachi zián naʼ lídxiguequi. ");
INSERT INTO zarNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Cateʼ chibudxi busöl-lëʼ légaquiëʼ, guyijëʼ tu lu guíʼadoʼ, ateʼ niʼ ruíʼilenëʼ Dios didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Cateʼ chizáʼ ral-la, zeaj bárcodoʼ naʼ gatsaj láhuiʼlö nísadoʼ, ateʼ zoëʼ Jesús tuzëʼ luyú bidxi naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Biléʼenëʼ Jesús légaquiëʼ, böniga tuʼsë́ʼë bárcodoʼ naʼ tuʼ recja böʼ zaʼ ga naʼ taʼdödëʼ. Gudödi guluhuëla bidxinëʼ Jesús ga naʼ nacuʼë, rizëʼe niʼë lu nísadoʼ naʼ, ateʼ gúʼunnëʼ tö́disëʼ ga naʼ nacuʼë. ");
INSERT INTO zarNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Cateʼ bilaʼléʼenëʼ Lëʼ rizëʼe niʼë lu nísadoʼ, guléquinëʼ bixín naʼ, ateʼ gulaʼbö́dxiʼë ");
INSERT INTO zarNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","tuʼ bilaʼléʼenëʼ yúguʼtëʼ Lëʼ, en guladxi gulaʼdzö́binëʼ. Níʼirö laʼ bulidztëʼ Jesús légaquiëʼ, rnnëʼ: —Buliʼtipa ládxiʼliʼ. Nedaʼ caz. Bitiʼ gádxiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Gurenëʼ Jesús lëʼe bárcodoʼ ga naʼ nacuʼë, ateʼ gurö́ʼö dxi böʼ naʼ recja, ateʼ légaquiëʼ gulaʼniti gulaʼtíquiʼsinëʼ buluʼbáninëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Bitiʼ taʼyéajniʼininëʼ le ruluíʼi lë naʼ benëʼ Jesús que yöta xtila naʼ. Niʼ naca zidi icja ládxiʼdoʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Gulaʼdödëʼ Jesús, en yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ iaʼtsöláʼa nísadoʼ, ateʼ bilaʼdxinëʼ ga naca lu xiyúgaca bönachi Genesaret. Buluʼdxíguëʼë bárcodoʼ luyú bidxi niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Cateʼ buluʼrúajëʼ lëʼe bárcodoʼ naʼ, laʼ buluʼúnbëʼtë bönachi niʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Gulaʼxitiʼ bönachi naʼ, yöjaca yúguʼtë yö́dzödoʼ idú gásibiʼilö, en gulaʼsí lógaquiëʼ dujuáʼagaquiëʼ yúguʼtë nupa teʼe ga zoëʼ Jesús, zxóagaca yuguʼ le déguequini, ateʼ bilaʼdxinëʼ gátiʼtës taʼyönnëʼ zoëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Gátiʼtës ga ridödëʼ Jesús, yuguʼ lu yö́dzödoʼ, en yuguʼ yödzö zxön, en yuguʼ yúʼudoʼ, tuʼcuʼë nupa teʼe quégaquiëʼ gapa naca laʼ nöza, en gapa naca lu yë́ʼëyi, en taʼtáʼyuëʼ lahuëʼ Jesús guʼë légaquiëʼ lataj ilaʼgansëʼ luzxi lariʼ nácuëʼ. Yúguʼtë nupa naʼ bilaʼgán lariʼ nácuëʼ buluʼhuöácatë dxíʼadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Níʼirö bal-lëʼ bönniʼ yudoʼ fariseo len bal-lëʼ bönniʼ yudoʼ usedi narúajgaquiëʼ Jerusalén, buluʼdubëʼ ga zoëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bönniʼ yudoʼ ni bilaʼléʼenëʼ bönniʼ usëda queëʼ Jesús tahuëʼ yöta, bitiʼ nuchíʼagaquiëʼ náʼagaquiëʼ, lë naʼ rnna: Bitiʼ nayárigaca ca nalë́biguequinëʼ tunëʼ bönniʼ yudoʼ naʼ. Que lë ni naʼ gulaʼnnë́ʼ quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Yuguʼ bönniʼ yudoʼ fariseo naʼ, en iaʼzícaʼrö bönachi judío tunëʼ ca gulë́biguequinëʼ gulunëʼ xuz xtóʼogaquiëʼ, ateʼ channö cabí taʼguíbi náʼagaquiëʼ zián luzuí ca naʼ nalë́biguequinëʼ tunëʼ, bitiʼ caʼ tahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Cateʼ tuʼdxinëʼ röjö́ʼugaquiëʼ lu yë́ʼëyi, channö cabí taʼguibëʼ lë naʼ ca nalë́biguequinëʼ tunëʼ, bitiʼ caʼ tahuëʼ. Ziánrö caʼ tunëʼ, yuguʼ le nalë́biguequinëʼ tunëʼ. Caní taʼguibëʼ zxigaʼ yö́ʼöna, en yuguʼ zxigaʼ guíë, en yuguʼ le tátiʼnëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Que lë ni naʼ yuguʼ bönniʼ yudoʼ fariseo, en yuguʼ bönniʼ yudoʼ usedi gulaʼnábinëʼ Jesús, taʼnnë́ʼ: —¿Naruʼ cabí tunëʼ yuguʼ bönniʼ usëda quiuʼ ca gulë́biguequinëʼ gulunëʼ xuz xtóʼoruʼ, pero tahuëʼ yöta bitiʼ nuchíʼagaquiëʼ náʼagaquiëʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Bubiʼë didzaʼ Jesús, rëʼ légaquiëʼ: —Libiʼiliʼ, bönniʼ ruluíʼisö tsahuiʼ cuinliʼ. Nácatë le gudíxjöʼë Isaías, bönniʼ niʼ bëʼë didzaʼ uláz queëʼ Dios, ca naca queë́liʼ. Buzúajëʼ lu guichi, gunnë́ʼ: Yuguʼ bönniʼ ni, len rúʼagacasëʼ tunëʼ nedaʼ bal, calëga idú ládxiʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nítiʼsö naca yöl-laʼ ba taʼguʼë nedaʼ tuʼ tuʼsë́dinëʼ le taʼnná bëʼ bönachi, calëga xibá quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Caní naca, tuʼ rucáʼanaliʼ le gunná bëʼë Dios, ateʼ runliʼ yuguʼ le nazíʼ láhuiliʼ lu náʼagaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Gudxëʼ caʼ légaquiëʼ: —Idú ládxiʼliʼ rucáʼanaliʼ cáʼasö le gunná bëʼë Dios para gunliʼ ca naca le nulaga loliʼ runliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés gunnë́ʼ caní: “Ben bal xuz xinóʼo.” Gunnë́ʼ caʼ: “Nu ulidza ziʼ xuzi o xinëʼe, guliʼgútitë nu naʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Libíʼiliʼ rnnaliʼ caní: “Channö nu bönniʼ guíëʼ xuzëʼ o xinë́ʼë: Bitiʼ gaca bi gunnaʼ queë́liʼ, tuʼ naca Corbán.” (Didzaʼ ni rnna lu didzaʼ xidzaʼ: Tuʼ nuzóaʼ quez queëʼ Dios yúguʼtë.) Níʼirö rnnaliʼ: “Bitiʼ run bayudxi bi gunëʼ bönniʼ naʼ quégaquiëʼ xuz xinë́ʼë.” ");
INSERT INTO zarNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Caní naca, rucáʼanaliʼ cáʼasö xtídzëʼë Dios para gunliʼ le nulaga loliʼ runliʼ, yuguʼ le rudö́diliʼ lu náʼagaca zxíʼini xiʼsóaliʼ. Ziánrö caʼ le caní runliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Níʼirö Jesús bulidzëʼ bönniʼ zián naʼ nacuʼë niʼ, en rëʼ légaquiëʼ: —Guliʼzë́ nágaliʼ didzaʼ guʼa, yúguʼtëliʼ, en guliʼtséajniʼi. ");
INSERT INTO zarNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Bitiʼ bi dë le riyaza nu bönniʼ le gaca gun ga bitiʼ náquiëʼ tsahuiʼ lahuëʼ Dios, pero le rirúaj lëʼ, lë ni gaca gun ga bitiʼ náquiëʼ tsahuiʼ lahuëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Channö zoa nágaliʼ, en riyö́niliʼ, buliʼzë́ nágaliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Cateʼ Jesús buláʼalenëʼ bönachi zián naʼ, guyuʼë tu yuʼu, ateʼ yuguʼ bönniʼ usëda queëʼ gulaʼnábinëʼ Lëʼ ca naca lë naʼ bucúdzuʼë didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesús gudxëʼ légaquiëʼ: —¿Riyádzjatsö caʼ queë́liʼ yöl-laʼ réajniʼi? ¿Naruʼ cabí réajniʼiliʼ, yúguʼtë le riyaza nu bönniʼ, bitiʼ gaca gun ga bitiʼ náquiëʼ tsahuiʼ lahuëʼ Dios? ");
INSERT INTO zarNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Naca caní tuʼ cabí riyaza icja ládxiʼdaʼahuëʼ, pero lë́ʼësëʼ riyaza, ateʼ rurúaj lëʼë. Tuʼ gunnë́ʼ caní Jesús, buluíʼinëʼ rëʼu naca dxiʼa yúguʼtë le rëʼaj ráguruʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Gunnë́ʼ caʼ Jesús: —Le rirúaj lu bönniʼ run ga bitiʼ náquiëʼ tsahuiʼ lahuëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Caní naca, tuʼ taʼrúaj icja ládxiʼdoʼgaquiëʼ bönniʼ yuguʼ le taʼzáʼ ládxiʼgaquiëʼ le naca xihuiʼ, yuguʼ le tun ga tunëʼ dul-laʼ taʼguitsjëʼ xibá que yöl-laʼ nutsaga naʼ, en yuguʼ le ruáʼ döʼ. Tun ga tútiëʼ bönachi, ");
INSERT INTO zarNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","en taʼbanëʼ, en taʼzë́ ládxiʼgaquiëʼ le dë que luzáʼagaquiëʼ, en tuʼë döʼ, en taʼzíʼ yëʼë, en tuʼzxë́ʼë, en taʼnná ziʼë que luzáʼagaquiëʼ, en tun ba zxön cuíngaquiëʼ, en tunëʼ le canö́z. ");
INSERT INTO zarNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yúguʼtë le xihuiʼ caní taʼrúaj icja ládxiʼdaʼahuëʼ nu bönniʼ, en tun ga bitiʼ náquiëʼ tsahuiʼ lahuëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Buzë́ʼë Jesús niʼ, ateʼ bidxinëʼ galaʼ ga nacuáʼ yödzö Tiro, en yödzö Sidón. Guyáziëʼ tu yuʼu niʼ, en gúʼunnëʼ cuntu nu inözi, pero bitiʼ caʼ guca ucachiʼ cuinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tu nigula zóabiʼ biʼi nigúladoʼ queë́nu, yuʼu böʼ xihuiʼ lëbiʼ, biyö́ninu didzaʼ rizë́ ca naca queëʼ Jesús, ateʼ laʼ bídatënu ga zoëʼ Jesús, en buzóa zxíbinu xiniʼë. ");
INSERT INTO zarNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nigula ni bitiʼ nácanu judío, pero nabábanu bönachi Sirofenicia. Gútaʼyunu lahuëʼ Jesús ubéajëʼ böʼ xihuiʼ naʼ yuʼu-biʼ biʼi nigúladoʼ queë́nu. ");
INSERT INTO zarNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Níʼirö Jesús gudxëʼ-nu, rnnëʼ: —Bëʼ lataj uluʼhuölaj zíʼalö nupa nácagaca ca zxíʼini xan yuʼu, tuʼ cabí naca dxiʼa ugúaruʼ yöta quégacabiʼ biʼi naʼ, en chúʼunaruʼ le lógacabaʼ bö́ʼcuʼdoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Bubíʼinu didzaʼ nigula naʼ, gúdxinu Jesús: —Ön, Xan, pero yuguʼ bö́ʼcuʼdoʼ nacuáʼabaʼ zxani ga tágubiʼ, tágubaʼ le bizxaj tuʼhuö́xaj ga naʼ tágubiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Níʼirö Jesús gudxëʼ-nu, rnnëʼ: —Tuʼ gunnóʼ caní, huáca huö́ajuʼ. Chiburúaj böʼ xihuiʼ naʼ guyúʼu-biʼ biʼi nigúladoʼ quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Cateʼ budxinnu lídxinu, biléʼenu-biʼ biʼi nigúladoʼ queë́nu naʼ, dëbiʼ lu daʼa, en chinurúaj böʼ xihuiʼ naʼ guyúʼu lëbiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Burúajëʼ Jesús lataj naʼ nababa yödzö Tiro, ateʼ gudödëʼ gapa dë yödzö Sidón, en yuguʼ yödzö Decápolis, ateʼ bidxinëʼ raʼ nísadoʼ lu xiyú Galilea. ");
INSERT INTO zarNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bönachi niʼ dujuáʼgaca tuëʼ bönniʼ nacö́dzuëʼ, en bitiʼ raca innë́ʼ ga zoëʼ Jesús, ateʼ taʼtaʼyu lahuëʼ Jesús ixóa nëʼë lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús bubéajëʼ lëʼ tsöláʼalö ládjagaca bönachi naʼ, ateʼ bunë́ʼë xibö́n nëʼë yeru náguiëʼ bönniʼ naʼ. Gurúʼunëʼ zxö́naʼdoʼ, en gudanëʼ lúdxëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Níʼirö buyúëʼ lúzxibálö, en gunnë́ ládxëʼë, rnnëʼ: —Efata. Didzaʼ hebreo ni rnna lu didzaʼ xidzaʼ: Guyalaj. ");
INSERT INTO zarNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Laʼ böáljatë náguiëʼ, en laʼ buguítjatë lúdxëʼë, en gunnëtëʼ dxíʼadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús gunná béʼenëʼ légaquiëʼ cuntu nu ilë́ʼ caʼ, pero tsca gunná béʼenëʼ légaquiëʼ, buluʼzë́tërëʼ caʼ didzaʼ que lë naʼ benëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Buluʼbáninë, taʼnnë́ʼ: —Tsáhuiʼdoʼ runëʼ yúguʼtë. Runëʼ ga tuʼyöni nupa gulaca cödzu, en ga tuíʼi didzaʼ nupa bitiʼ guca ilaʼnnë́. ");
INSERT INTO zarNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Yuguʼ dza naʼ buluʼdubi bönachi zián ga zoëʼ Jesús. Tuʼ cabí dë le ilágugaca, Jesús bulidzëʼ bönniʼ usëda queëʼ, ateʼ bë́ʼlenëʼ légaquiëʼ didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Gudxëʼ légaquiëʼ: —Ruhuechiʼ ládxaʼa bönachi zián ni tuʼ chinaca tsonna dza nacuáʼlen nedaʼ ni, en bitiʼ dë le ilágugaca. ");
INSERT INTO zarNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Channö usö́l-laʼa léguequi lídxigaca taʼdunsö caʼ, hualaʼcuídiʼ laʼ nöza, tuʼ záʼgaca ziʼtuʼ bál-lagaca. ");
INSERT INTO zarNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Buluʼbiʼë didzaʼ bönniʼ usëda queëʼ, tëʼ Lëʼ: —¿Bizxi ugágutsaruʼ bönachi guizxi yu ni, ga ni naca lataj cáʼasö? ");
INSERT INTO zarNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Gunábinëʼ Jesús légaquiëʼ, rnnëʼ: —¿Bál-laxi yöta xtila dë queë́liʼ? Tëʼ Lëʼ: —Gádxisö. ");
INSERT INTO zarNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Níʼirö Jesús gunná béʼenëʼ bönachi zián naʼ ilaʼbö́ʼ lu yu. Gudélëʼë gadxi yöta xtila naʼ, ateʼ gudxëʼ Dios: “Xclenuʼ.” Níʼirö buzxuzxjëʼ léguequi, en bëʼë quégaquiëʼ bönniʼ usëda queëʼ para ilaʼguísiëʼ lógaca bönachi zián naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Gutaʼ caʼ quégaquiëʼ tu chópabaʼ böla cuidiʼ. Jesús gudxëʼ Dios: “Xclenuʼ”, ateʼ gunná béʼenëʼ légaquiëʼ ilaʼguísiëʼ caʼ légacabaʼ lógaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Gulagu yúguʼtë bönachi naʼ, en buluʼhuö́laj. Níʼirö buluʼtubëʼ le bizxaj nagáʼanagaca, ateʼ gulaʼlí idú gadxi gaʼböra. ");
INSERT INTO zarNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bönachi naʼ gulagu gulaca idú ca choáʼ gayuáʼgaca. Jesús busöl-lëʼ léguequi lídxigaca, ");
INSERT INTO zarNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ateʼ gurenëʼ lëʼe bárcodoʼ tsözxö́n len yuguʼ bönniʼ usëda queëʼ, ateʼ bilaʼdxinëʼ lu xiyúgaca bönachi Dalmanuta. ");
INSERT INTO zarNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Níʼirö bilaʼdxinëʼ bönniʼ yudoʼ fariseo ga zoëʼ Jesús, en gulaʼsí lógaquiëʼ taʼdíl-lalenëʼ Lëʼ didzaʼ. Gulë́ʼënnëʼ ilaʼzíʼ bëʼë Jesús. Que lë ni naʼ gulaʼnábinëʼ Lëʼ gunëʼ tu le naca bëʼ zaʼ yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Gunnëdaʼ ládxëʼë Jesús, rnnëʼ: —¿Bizx que taʼnábitsö bönachi ni nedaʼ gunaʼ tu le naca bëʼ zaʼ yehuaʼ yubá? Le nácatë reaʼ libíʼiliʼ, bitiʼ caʼ iléʼeliʼ tu le naca bëʼ zaʼ yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Níʼirö buláʼalenëʼ légaquiëʼ. Bubenëʼ lëʼe bárcodoʼ, en saʼyéajëʼ iaʼtsöláʼa nísadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Gulal-la ládxiʼgaquiëʼ bönniʼ usëda queëʼ Jesús iluʼë bi ilahuëʼ, ateʼ tuz yöta xtila dë lëʼe bárcodoʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Níʼirö Jesús buzéajniʼinëʼ légaquiëʼ, rnnëʼ: —Buliʼyútsöcaʼ queë́liʼ. Guliʼgún chiʼi cuinliʼ para cabí síʼiliʼ le naca ca cúa zi que yöta xtila quégaquiëʼ bönniʼ yudoʼ fariseo, en queëʼ Herodes. ");
INSERT INTO zarNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Gulaʼsí lógaquiëʼ tuʼë didzaʼ bönniʼ usëda queëʼ laʼ légacasëʼ, taʼnnë́ʼ: —Gunnë́ʼ caní tuʼ cabí dë yöta xtila gáguruʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Réquibeʼenëʼ Jesús le taʼnnë́ʼ, ateʼ rëʼ légaquiëʼ: —¿Bizx que ruíʼiliʼ caní didzaʼ tuʼ cabí dë yöta xtila gáguruʼ? ¿Naruʼ cabí réajniʼitseliʼ, en bitiʼ réquibeʼitseliʼ? ¿Ni nácatsö zidi icja ládxiʼdoʼoliʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Zóatsö guiö́j loliʼ, en bitiʼ riléʼeliʼ, en zóatsö guídi nágaliʼ, en bitiʼ riyö́niliʼ? ¿Naruʼ cabí röjnétseliʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Cateʼ niʼ buzxuzxjaʼ gayuʼ yöta xtila, ateʼ gulahuëʼ chi-un gáyuʼë bönniʼ, ¿bál-laxi gaʼböra buliliʼ le bizxaj butúbiliʼ? Gulaʼnnë́ʼ: —Chinnu. ");
INSERT INTO zarNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Gunnë́ʼ caʼ Jesús: —Cateʼ niʼ buzxuzxjaʼ gadxi yöta xtila, ateʼ gulagu choáʼ gayuáʼ bönachi, ¿bál-laxi gaʼböra buliliʼ le bizxaj butúbiliʼ? Gulaʼnnë́ʼ: —Gadxi. ");
INSERT INTO zarNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Níʼirö Jesús gudxëʼ légaquiëʼ: —¿Naruʼ cabí réajniʼitseliʼ naʼa, bëʼa didzaʼ que le tuʼsë́dinëʼ bönniʼ naʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Cateʼ Jesús, en bönniʼ dáʼgaquiëʼ Lëʼ bilaʼdxinëʼ yödzö Betsaida, bilaʼdxín ga zoëʼ Jesús nupa dujuáʼgaquiëʼ queëʼ tu bönniʼ nachul-la lahuëʼ. Taʼtáʼyuëʼ lahuëʼ canëʼ bönniʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús gudélëʼë nëʼë bönniʼ naʼ nachul-la lahuëʼ, ateʼ guchë́ʼë lëʼ níʼilö raʼ yödzö. Niʼ budxíëʼ zxönaʼ guiö́j lahuëʼ, en guxóa nëʼë lëʼ. Níʼirö gunábinëʼ lëʼ, rnnëʼ: —¿Ba riléʼenuʼ latiʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Buyúëʼ bönniʼ naʼ nachul-la lahuëʼ, rnnëʼ: —Riléʼegacadaʼ bönachi, naláʼgaca ca yuguʼ yaga, pero taʼdá bönachi naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Leyúbölö guxóa nëʼë Jesús guiö́j lahuëʼ, ateʼ buyúdëʼë bönniʼ naʼ nachul-la lahuëʼ, ateʼ böácatë dxíʼadoʼ guiö́j lahuëʼ. Naʼa riléʼenëʼ dxíʼadoʼ yúguʼtë. ");
INSERT INTO zarNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Níʼirö Jesús gusö́l-lëʼë lëʼ lidxëʼ, rnnëʼ: —Bitiʼ tsöjdöduʼ lahuiʼ yödzö, en cuntu nu guíoʼ le benaʼ nu zoa lu yödzö ni. ");
INSERT INTO zarNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Gudödi naʼ, buluʼzë́ʼë Jesús, en yuguʼ bönniʼ usëda queëʼ niʼ, ateʼ gulaʼdödëʼ yuguʼ yö́dzödoʼ nabábagaca Cesarea, ga naʼ rinná bëʼë Filipo. Tsanni niʼ yúʼugaquiëʼ nöza, Jesús rinabi yudxëʼ yuguʼ bönniʼ usëda queëʼ, rnnëʼ: —¿Nuzxi taʼnná bönachi nacaʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Buluʼbiʼë didzaʼ, taʼnnë́ʼ: —Taʼnná bal-la bönachi nacuʼ Juan, bönniʼ buquilëʼ bönachi nisa. Taʼnná iaʼbal-la nacuʼ Elías, bönniʼ bëʼë didzaʼ uláz queëʼ Dios dza niʼte. Taʼnná iaʼbal-la nacuʼ bönniʼ yúbölö bëʼë didzaʼ uláz queëʼ Dios dza niʼte. ");
INSERT INTO zarNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Níʼirö Jesús gunábinëʼ légaquiëʼ, rnnëʼ: —Nazxi libíʼiliʼ, ¿nuzxi rnnaliʼ nacaʼ? Bubiʼë didzaʼ Pedro, rnnëʼ: —Liʼ nacuʼ Cristo. ");
INSERT INTO zarNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Níʼirö Jesús gunná béʼenëʼ légaquiëʼ cuntu nu uluʼsiyönnëʼ Nu náquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Níʼirö gusí lahuëʼ Jesús rusë́dinëʼ bönniʼ dáʼgaquiëʼ Lëʼ, rnnëʼ: —Run bayudxi quiʼi sacaʼa nedaʼ, Bönniʼ Guljëʼ Bönachi. Bönniʼ gula tuʼzéajniʼinëʼ, en yuguʼ bixúz unná bëʼ, en bönniʼ yudoʼ tuʼsë́dinëʼ uluʼzóëʼ nedaʼ tsöláʼalö. Ilútiëʼ nedaʼ, pero cateʼ gaca tsonna dza ubanaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yálajsö bë́ʼlenëʼ légaquiëʼ didzaʼ ni. Níʼirö Pedro guchë́ʼë Jesús tsöláʼalö, en gusí lahuëʼ ridil-lëʼ lëʼ didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Buécjëʼ Jesús, en buyúëʼ iaʼzícaʼrëʼ bönniʼ usëda queëʼ, ateʼ buzenëʼ bach Pedro, rnnëʼ: —Gucuita ga zoaʼ. Nacuʼ ca Satanás, tuʼ xihuiʼ. Le rizáʼ ládxuʼu bitiʼ zaʼ lu nëʼë Dios, pero ca taʼzáʼ ládxiʼgaca bönachi naca. ");
INSERT INTO zarNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Níʼirö Jesús bulidzëʼ yuguʼ bönniʼ usëda queëʼ, encaʼ bönachi nacuáʼ niʼ, en gudxëʼ légaquiëʼ: —Channö rë́ʼënëʼ nu bönniʼ tëʼë nedaʼ, ral-laʼ uzóëʼ tsöláʼalö le rë́ʼëni quézinëʼ, en gáquiëʼ ca tu bönniʼ saʼyéajëʼ söjtë́ʼë lëʼe yaga cruz, ateʼ níʼirö huáca tëʼë nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nu bönniʼ ruíʼidaʼ ládxëʼë yöl-laʼ naʼbán queëʼ, unítiëʼ le, pero nu bönniʼ unítiëʼ yöl-laʼ naʼbán queëʼ tuʼ dëʼë nedaʼ, o tuʼ dëʼë didzaʼ dxiʼa quiaʼ, udéliʼnëʼ bönniʼ ni yöl-laʼ naʼbán queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Naruʼ uziʼtsëʼ xibé tu bönniʼ channö utubëʼ yúguʼtë le dë yödzölió ni, pero uniti cuinëʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Bitiʼ bi gaca unödzjëʼ tu bönniʼ le huöáʼui cuinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Channö zoëʼ nu bönniʼ rutuíʼinëʼ quiaʼ nedaʼ, en que xtídzaʼa lógaca bönachi ni nucáʼanagaca Dios, en tun dul-laʼ, lëscaʼ caní nedaʼ, Bönniʼ Guljëʼ Bönachi, utuíʼidaʼ queëʼ bönniʼ naʼ cateʼ guídalenaʼ yöl-laʼ huáca zxön queëʼ Xuzaʼ, ateʼ dzágagaquiëʼ gubáz láʼayi nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús gudxëʼ caʼ légaquiëʼ, rnnëʼ: —Le nácatë reaʼ libíʼiliʼ, nacuáʼ ni nupa bitiʼ ilátigaca cateʼ ilaʼléʼerö idinná bëʼë Dios luyú ni, en iláʼ lahui yöl-laʼ huáca zxön queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Cateʼ chigudödi xopa dza, Jesús guchë́ʼë Pedro, en Jacobo, en Juan, ateʼ légacasëʼ yöjáquiëʼ tu lu guíʼa sibi. Niʼ bidzáʼa ca rináʼ lahuëʼ Jesús lógaquiëʼ yonnëʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Guyëpi yösa beníʼ lariʼ nácuëʼ Jesús, ateʼ guca chiguíchidoʼos. Zxílaʼdoʼos guca, le cuntu nu raʼ lariʼ yödzölió ni gaca gun chiguíchidoʼos ca guca lariʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Buluʼluíʼi lógaquiëʼ Elías, en Moisés, tuíʼilenëʼ Jesús didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Níʼirö Pedro gudxëʼ Jesús: —Bönniʼ Usedi, bicaʼ ba rëʼu zóaruʼ ni. Gúntsöcaʼtuʼ tsonna yuʼu lágaʼdoʼ, tu quiuʼ, iaʼtú queëʼ Moisés, en iaʼtú queëʼ Elías. ");
INSERT INTO zarNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Caní gunnë́ʼ Pedro tuʼ cabí nö́zinëʼ bi naʼ rnnëʼ, tuʼ tádxinëʼ bönniʼ usëda queëʼ Jesús naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Níʼirö gurö́ʼö böaj le gulúʼu zxul-la légaquiëʼ, ateʼ biyö́n chiʼi nu ruíʼi didzaʼ lu böaj naʼ, rnna: —Bönniʼ ni Zxíʼinaʼ. Nadxíʼidaʼ Lëʼ. Buliʼzë́ nágaliʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Laʼ buluʼyutëʼ pero cúnturö nu taʼléʼenëʼ. Tuzëʼ Jesús zóalenëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tsanni niʼ yúʼugaquiëʼ nöza, tuʼdínniëʼ lu guíʼa sibi naʼ, Jesús gunná béʼenëʼ légaquiëʼ cuntu nu uluʼsiyönnëʼ caʼ, lë naʼ bilaʼléʼenëʼ, cateʼ ubanrëʼ lu yöl-laʼ guti Lëʼ, Bönniʼ Guljëʼ Bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Que lë ni naʼ gulaʼgúʼusëʼ ícjagaquiëʼ didzaʼ ni bëʼë, ateʼ laʼ légacasëʼ taʼnabi yúdxinëʼ luzáʼagaquiëʼ bizxi saʼyéaj didzaʼ naʼ bëʼë, gunnë́ʼ ubanëʼ lu yöl-laʼ guti. ");
INSERT INTO zarNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Gulaʼnábinëʼ Jesús, taʼnnë́ʼ: —¿Bizx que taʼnnë́ʼ bönniʼ yudoʼ usedi run bayudxi guídëʼ Elías zíʼalö ca guídëʼ Cristo? ");
INSERT INTO zarNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Bubiʼë didzaʼ Jesús, rnnëʼ: —Le nácatë guídëʼ Elías zíʼalö, en ucuʼë yúguʼtë ca ral-laʼ gaca. Naʼa, ¿bizxi saʼyéaj le nazúaj lu guichi rnna run bayudxi quiʼi sáquëʼë Bönniʼ Guljëʼ Bönachi, ateʼ cáʼasö uluʼcáʼana bönachi Lëʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Reaʼ libíʼiliʼ: Chibidëʼ Elías, ateʼ gulunëʼ queëʼ tsca gulë́ʼënnëʼ, tsca nazúaj lu guichi láʼayi ca ral-laʼ gaca queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Cateʼ niʼ buluʼdxinëʼ Jesús, en bönniʼ dzágagaquiëʼ Lëʼ ga naʼ nacuʼë iaʼzícaʼrëʼ bönniʼ usëda queëʼ Jesús, bilaʼléʼenëʼ nacuáʼ bönachi zián niʼ, ateʼ bönniʼ yudoʼ tuʼsë́dinëʼ taʼdíl-lalenëʼ yuguʼ bönniʼ usëda queëʼ naʼ didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Cateʼ bönachi zián naʼ bilaʼléʼe Jesús, buluʼbani, en carelö záʼgaca ga naʼ zëʼë, dijö́dxigaca Lëʼ: “Padiux.” ");
INSERT INTO zarNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Níʼirö Jesús gunábinëʼ yuguʼ bönniʼ usëda queëʼ naʼ, rnnëʼ: —¿Bizxi didzaʼ naʼ ridíl-lalenliʼ légaquiëʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Bubiʼë didzaʼ tu bönniʼ nútsëʼë ladaj bönachi zián naʼ, rnnëʼ: —Bönniʼ Usedi, nachëʼa-biʼ biʼi bö́nniʼdoʼ quiaʼ ni quiuʼ, yuʼu lëbiʼ böʼ xihuiʼ le run ga bitiʼ raca innëbiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Cateʼ böʼ xihuiʼ naʼ ruʼu lëbiʼ, rurixi rutula lëbiʼ lu yu, ateʼ ribía bidxinaʼ zidiʼ ruáʼabiʼ, en rutil-la láyaʼbiʼ. Que lë ni naʼ zeaj ridxítabiʼ. Gunábigacadaʼ-nëʼ bönniʼ usëda quiuʼ uluʼbéajëʼ böʼ xihuiʼ naʼ, pero bitiʼ gulaʼzéquiʼnëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Bubiʼë didzaʼ Jesús, rnnëʼ: —Libiʼiliʼ, bönniʼ cabí taʼyéajlëʼë. ¿Gácaʼxte caz ral-laʼ sóalenaʼ libíʼiliʼ? ¿Gácaʼxte caz ral-laʼ guáʼ ilenaʼ queë́liʼ? Guliʼdiguáʼ-biʼ quiaʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dujuáʼagaquiëʼ-biʼ ga naʼ zoëʼ Jesús. Cateʼ böʼ xihuiʼ naʼ biléʼe Lëʼ, laʼ buxízitë lëbiʼ. Gudzö́ʼöbiʼ lu yu, ateʼ burixi butula lëbiʼ, ateʼ bidxía bidxinaʼ zidiʼ ruáʼabiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Níʼirö Jesús gunábinëʼ xúzibiʼ biʼi naʼ, rnnëʼ: —¿Gácaʼxi chiguca raca caní queë́biʼ? Rnnëʼ xúzibiʼ naʼ: —Niʼ nácatëbiʼ bíʼidoʼ réʼebiʼ caní. ");
INSERT INTO zarNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Zián luzuí rirúʼuna lëbiʼ lu guíʼ, en lu nisa para guti lëbiʼ. Que lë ni naʼ, channö racuʼ latiʼ, buéchiʼ ladxiʼ netuʼ, gácalenuʼ netuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús gudxëʼ lëʼ: —Channö huáca tséajlëʼu, yúguʼtë huáca channö tséajlëʼu Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Laʼ bëʼtëʼ zidzaj didzaʼ xúzibiʼ biʼi naʼ, rnnëʼ: —¡Réajlëʼa! ¡Gúcalen nedaʼ para tséajlëʼëraʼ Lëʼ! ");
INSERT INTO zarNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Cateʼ biléʼenëʼ Jesús záʼgaca bönachi zián, tuʼquí Lëʼ, buzenëʼ bach böʼ xihuiʼ naʼ, rëʼ le: —Liʼ, böʼ xihuiʼ runuʼ ga bitiʼ raca inná, en bitiʼ raca yöni bönachi, rinná béʼedaʼ liʼ urujuʼ lu biʼi ni, en bítiʼrö tsuʼu lëbiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Gurö́dxiʼa böʼ xihuiʼ naʼ, en burixi butúladaʼ biʼi naʼ. Níʼirö burúajtë, en bucáʼana biʼi naʼ ca biʼi nati cázabiʼ. Caʼ naca, guluíʼi didzaʼ bönachi zián niʼ, taʼnná: —Chinátibiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Níʼirö Jesús gudélëʼë náʼabiʼ, en buchisëʼ-biʼ, ateʼ guzuíbiʼ biʼi naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Níʼirö guyáziëʼ Jesús tu yuʼu, ateʼ laʼ légacasëʼ gulaʼnábinëʼ bönniʼ usëda queëʼ Lëʼ, taʼnnë́ʼ: —¿Bizx que bitiʼ guca ubéajtuʼ netuʼ böʼ xihuiʼ naʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús gudxëʼ légaquiëʼ: —Bitiʼ gaca ubéajliʼ cáʼasö böʼ xihuiʼ caní, pero tuz channö ulídzaliʼ-nëʼ Dios, en gunliʼ gubasa. ");
INSERT INTO zarNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Cateʼ buluʼzë́ʼë Jesús, en yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ niʼ, gulaʼdödëʼ luyú Galilea. Bitiʼ rë́ʼënëʼ Jesús nu inözi ga naʼ zoëʼ ");
INSERT INTO zarNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tuʼ rusë́dinëʼ yuguʼ bönniʼ usëda queëʼ. Rëʼ légaquiëʼ: —Uluʼdödëʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, lu náʼagaquiëʼ bönniʼ ilútiëʼ nedaʼ, pero tödi gátiaʼ, cateʼ gaca tsonna dza ubanaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Bitiʼ gulaʼyéajniʼinëʼ didzaʼ ni rëʼ légaquiëʼ, ateʼ tuʼ tádxinëʼ, bitiʼ bi gulaʼnábinëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Níʼirö Jesús, en bönniʼ dáʼgaquiëʼ Lëʼ bilaʼdxinëʼ yödzö Capernaum, ateʼ tsanni niʼ nacuʼë lu yuʼu, Jesús gunábinëʼ légaquiëʼ, rnnëʼ: —¿Bizxi didzaʼ naʼ gudíl-lalen luzáʼaliʼ cateʼ niʼ yúʼuliʼ nöza? ");
INSERT INTO zarNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Légaquiëʼ buluʼsayaj rúʼugaquiëʼ, tuʼ gulaʼdíl-lalen luzáʼagaquiëʼ didzaʼ laʼ nöza niʼ núzxilögaquiëʼ gáquiëʼ bönniʼ lo. ");
INSERT INTO zarNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Níʼirö guröʼë Jesús, en bulidzëʼ idxínnutëʼ bönniʼ usëda queëʼ. Rëʼ légaquiëʼ: —Nu rë́ʼëni gaca lo ral-laʼ gaca ca tu bönniʼ cuídiʼsö, encaʼ ca niʼa náʼaliʼ yúguʼtëliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Níʼirö Jesús gudélëʼë-biʼ tubiʼ bíʼidoʼ, en buzóëʼ-biʼ gatsaj láhuiʼlö ga naʼ nacuʼë. Niʼ runidëʼ-biʼ, rëʼ légaquiëʼ: ");
INSERT INTO zarNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Nu bönniʼ siʼ lu nëʼë tu bíʼidoʼ caní tuʼ néquibiʼ quiaʼ, siʼ lu nëʼë caʼ nedaʼ, ateʼ nu bönniʼ siʼ lu nëʼë nedaʼ, calëga nédaʼsö siʼ lu nëʼë, pero siʼ lu nëʼë caʼ Xuzaʼ, Bönniʼ naʼ nasö́l-lëʼë nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Níʼirö Juan gudxëʼ Jesús: —Bönniʼ Usedi, biléʼetuʼ-nëʼ tu bönniʼ rubéajëʼ yuguʼ böʼ xihuiʼ, rugunëʼ dxin loʼ. Gunná béʼetuʼ lëʼ bítiʼrö gunëʼ caʼ, tuʼ cabí dëʼë rëʼu. ");
INSERT INTO zarNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Níʼirö Jesús gudxëʼ lëʼ: —Bitiʼ inná béʼeliʼ-nëʼ, tuʼ channö zoëʼ nu bönniʼ runëʼ tu yöl-laʼ huáca le zaʼ yehuaʼ yubá, en rugunëʼ dxin Laʼ nedaʼ, bitiʼ caʼ gaca bönniʼ naʼ innë́ ziʼë quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Caní naca, nu bitiʼ ridáʼbagaʼ rëʼu, rácalen nu naʼ rëʼu. ");
INSERT INTO zarNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nútiʼtës nu gunna queë́liʼ tu zxígaʼdoʼ nisa guíʼjaliʼ tuʼ dáʼaliʼ nedaʼ, Cristo, siʼi caz nu naʼ le ral-laʼ gataʼ que. ");
INSERT INTO zarNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Gunnë́ʼ caʼ Jesús: —Nútiʼtës nu gun ga gunbiʼ dul-laʼ tubiʼ bíʼidoʼ caní réajlëʼëbiʼ nedaʼ, gácarö dxiʼa ugal-laʼ nu naʼ guichi riyëtu yaga yeni, en tsöjchúʼuna cuini lu nísadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Channö tu noʼo gun ga gunuʼ dul-laʼ, guchugu le. Dxíʼarö gaca quiuʼ tsöjtsáziuʼ ga suʼ ibanuʼ zoa tuz noʼo, calëga zoa chopa noʼo, ateʼ tsöjtsáziuʼ lu guíʼ gabila, ga niʼ bitiʼ ulu guíʼ que. ");
INSERT INTO zarNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Lataj niʼ bitiʼ ilátibaʼ buzugaʼ yúʼugacabaʼ nupa tsöjcuáʼ niʼ, ateʼ guíʼ naʼ bitiʼ caʼ ulu. ");
INSERT INTO zarNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Lëscaʼ caní, channö tu niʼu gun ga gunuʼ dul-laʼ, guchugu le. Gácarö dxiʼa quiuʼ, tsöjtsáziuʼ ga suʼ ibanuʼ zoa tuz niʼu, calëga zoa chopa niʼu, ateʼ tsöjtsáziuʼ lu guíʼ gabila, ga niʼ bitiʼ ulu guíʼ que. ");
INSERT INTO zarNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Lataj niʼ bitiʼ ilátibaʼ buzugaʼ yúʼugacabaʼ nupa tsöjcuáʼ niʼ, ateʼ guíʼ naʼ bitiʼ caʼ ulu. ");
INSERT INTO zarNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Lëscaʼ caní, channö tu guiö́j loʼ gun ga gunuʼ dul-laʼ, guléaj le. Gácarö dxiʼa quiuʼ tsöjtsáziuʼ ga rinná bëʼë Dios zoa tuz guiö́j loʼ, calëga zoa chopa guiö́j loʼ, ateʼ tsöjtsáziuʼ lu guíʼ gabila. ");
INSERT INTO zarNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Lataj niʼ bitiʼ ilátibaʼ buzugaʼ yúʼugacabaʼ nupa tsöjcuáʼ niʼ, ateʼ guíʼ naʼ bitiʼ caʼ ulu. ");
INSERT INTO zarNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Ruxiʼiruʼ bëlaʼ zödiʼ, en rugálaʼruʼ le raʼ guíʼ, para cabí gaca ditaj. Lë ni rusedi rëʼu ca uluʼhuöáca dxiʼa yúguʼtë bönachi. Lëscaʼ caní, rë́ʼënëʼ Dios izxíʼi zödiʼ yúguʼtë böaʼ bë́dxidoʼ tuʼzéguiʼgaquiëʼ-baʼ lu bucugu láʼayi queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Dxiʼa naca zödiʼ, pero channö initi yöl-laʼ sináʼa que, ¿nacxi úniruʼ le sináʼa? Guliʼgaca laʼ libíʼisiliʼ ca zödiʼ dxiʼa, sóaliʼ dxíʼadoʼ tuliʼ len iaʼtuliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Buzë́ʼë Jesús yödzö Capernaum, ateʼ guyijëʼ luyú Judea, en gudödëʼ iaʼtsöláʼa yegu Jordán sacaʼ ga rilén gubidza. Buluʼdubi leyúbölö bönachi zián ga zoëʼ, ateʼ leyúbölö busë́dinëʼ légaquiëʼ ca run cazëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Níʼirö bilaʼdxinëʼ bönniʼ yudoʼ fariseo ga zoëʼ Jesús, ateʼ të́ʼënnëʼ ilunëʼ ga bi innë́ʼ Jesús para gaca uluʼzéguiëʼ Lëʼ didzaʼ. Gulaʼnábinëʼ Lëʼ, taʼnnë́ʼ: —¿Dë lataj bönniʼ nutsaga nëʼë usanëʼ-nu nigula queëʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Bubiʼë didzaʼ Jesús, rnnëʼ: —¿Bizxi gunná béʼenëʼ Moisés libíʼiliʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Gulaʼnnë́ʼ: —Moisés bëʼë lataj nu bönniʼ uzúajëʼ lu guichi le rnna ruláʼalenëʼ-nu nigula queëʼ naʼ, ateʼ níʼirö usanëʼ-nu. ");
INSERT INTO zarNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Bubiʼë didzaʼ Jesús, rnnëʼ: —Gunná béʼenëʼ Moisés libíʼiliʼ caní tuʼ naca zidi icja ládxiʼdoʼoliʼ, ");
INSERT INTO zarNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","pero cateʼ gusí lo rataʼ yödzölió, Dios benëʼ légaquiëʼ bönniʼ, en nigula. ");
INSERT INTO zarNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Gunnë́ʼ: “Que lë ni naʼ ucáʼanëʼ bönniʼ xuz xinë́ʼë, en tsöjsóalenëʼ-nu nigula queëʼ, ");
INSERT INTO zarNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ateʼ chopëʼ ni uluʼhuöáquiëʼ ca tuz bönachi.” Que lë ni naʼ bítiʼrö nácagaquiëʼ chopëʼ pero tuz chinácagaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Que lë ni naʼ caʼ, nu naca bönachi bitiʼ ral-laʼ uláʼa nupa naʼ chinutságuiëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Cateʼ gulaʼyáziëʼ yuʼu, gulaʼnabi yúdxinëʼ bönniʼ usëda queëʼ Jesús ca naca didzaʼ naʼ bëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús gudxëʼ légaquiëʼ: —Nútiʼtës bönniʼ uláʼalenëʼ-nu nigula queëʼ, en utsaga náʼalenëʼ-nu nigula yúbölö, runëʼ dul-laʼ le riguitsaj xibá que yöl-laʼ nutsaga naʼ tuʼ rusubáguëʼë-nu dul-laʼ nigula naʼ guzóalenëʼ-nu zíʼalö. ");
INSERT INTO zarNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Lëscaʼ caní channö tu nigula nutsaga náʼlennu bönniʼ usannu-nëʼ, en síʼinu-nëʼ bönniʼ yúbölö, runnu caʼ dul-laʼ le riguitsaj xibá que yöl-laʼ nutsaga naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Níʼirö bilaʼdxín bönachi ga zoëʼ Jesús dujuáʼgaquiëʼ bíʼidoʼ quéguequi. Të́ʼëni ixóa nëʼë légacabiʼ, ateʼ gulaʼsí lógaquiëʼ bönniʼ usëda queëʼ Jesús taʼdil-la dídzaʼgaquiëʼ nupa naʼ dujuáʼagaca légacabiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Cateʼ biléʼenëʼ Jesús lë ni, gulénëʼ légaquiëʼ, en gunnë́ʼ: —Guliʼgüíʼ-gácabiʼ bíʼidoʼ lataj ilaʼdxinbiʼ quiaʼ. Bitiʼ uzágaʼgacaliʼ-biʼ, tuʼ gataʼ quégaca nupa nácagaca ca bíʼidoʼ ni, lataj ga rinná bëʼë Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Le nácatë reaʼ libíʼiliʼ: Nu cabí siʼ lu nëʼe le rinná bëʼë Dios ca runbiʼ tu bíʼidoʼ, bitiʼ caʼ tsaza ga niʼ rinná bëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Níʼirö Jesús bunidëʼ-biʼ yuguʼ bíʼidoʼ naʼ. Guxóa nëʼë légacabiʼ, en bulidza tsáhuëʼë-biʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Cateʼ buʼë Jesús nöza, carelö bidëʼ tu bönniʼ, en buzóa zxibëʼ lahuëʼ Jesús, en gunábinëʼ Lëʼ, rnnëʼ: —Bönniʼ Usedi idú dxiʼa, ¿nacxi gunaʼ para idéliʼdaʼ yöl-laʼ naʼbán idú? ");
INSERT INTO zarNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús gudxëʼ lëʼ: —¿Bizx que ruʼu nedaʼ didzaʼ, rnnoʼ: “Idú dxiʼa”? Cuntu nu bönniʼ náquiëʼ idú dxiʼa. Tuzëʼ Dios náquiëʼ idú dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Chinö́z quézinuʼ yuguʼ le gunná bëʼë Dios, gunnë́ʼ: Bitiʼ gunuʼ dul-laʼ le riguitsaj xibá que yöl-laʼ nutsaga naʼ. Bitiʼ gútiuʼ bönachi. Bitiʼ cuanuʼ. Bitiʼ inníoʼ que luzóʼo le cabí nácatë. Bitiʼ ucáchiʼlanuʼ. Ben bal xuz xinóʼo. ");
INSERT INTO zarNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bubiʼë didzaʼ bönniʼ naʼ, rëʼ Jesús: —Bönniʼ Usedi, yúguʼtë lë ni run cazaʼ cateʼ niʼ nácateaʼ bíʼidoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Len yöl-laʼ dxiʼi ladxiʼ queëʼ, Jesús buyúëʼ lëʼ, rnnëʼ: —Tu le riyadzaj quiuʼ. Guyéaj, yöjëtiʼ yúguʼtë le dë quiuʼ, en bunödzaj quégaca bönachi yechiʼ lë naʼ siʼu, ateʼ gataʼ quiuʼ yöl-laʼ tsahuiʼ yehuaʼ yubá. Níʼirö huöduʼ quiaʼ, gacuʼ ca tu bönniʼ saʼyéajëʼ söjtë́ʼë lëʼe yaga cruz, ateʼ toʼo nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Cateʼ biyönnëʼ didzaʼ ni, buíʼinnëʼ, ateʼ söhuö́jëʼ risëbi ládxëʼë tuʼ dëdaʼ yöl-laʼ tsahuiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Níʼirö buyúëʼ Jesús gásibiʼilëʼ, en gudxëʼ yuguʼ bönniʼ usëda queëʼ: —Böniga naca ilaʼyaza nupa taʼléʼe yöl-laʼ tsahuiʼ ga rinná bëʼë Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Buluʼbáninëʼ bönniʼ usëda queëʼ ca naca xtídzëʼë, ateʼ leyúbölö Jesús gudxëʼ légaquiëʼ: —Libiʼiliʼ, zxíʼinaʼdoʼ, böniga naca ilaʼyáziëʼ bönniʼ tuʼzxöni ládxiʼgaquiëʼ yöl-laʼ tsahuiʼ quégaquiëʼ ga rinná bëʼë Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nácarö böniga tsáziëʼ nu bönniʼ riléʼenëʼ yöl-laʼ tsahuiʼ ga rinná bëʼë Dios, ca tö́dibaʼ böaʼ taʼbía-baʼ bönachi lu nagui yötsiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Cateʼ bilaʼyönnëʼ didzaʼ ni, buluʼbánitërönëʼ caʼ. Taʼnnë́ʼ laʼ légacasëʼ: —¿Nuzxi caz gaca ulá, channö? ");
INSERT INTO zarNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Buyúëʼ Jesús légaquiëʼ, rnnëʼ: —Bitiʼ gaca gun bönachi lë ni, pero huáquiëʼ Dios, tuʼ rizéquiʼnëʼ Dios yúguʼtë. ");
INSERT INTO zarNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Níʼirö Pedro gudxëʼ Lëʼ: —Xan, netuʼ nucáʼanatuʼ yúguʼtë, en dáʼatuʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Bubiʼë didzaʼ Jesús, rnnëʼ: —Le nácatë reaʼ libíʼiliʼ, nu bönniʼ ucáʼanëʼ lidxëʼ, o bö́chëʼë, o zanëʼ, o xuzëʼ, o xinë́ʼë, o nigula queëʼ, o yuguʼ zxíʼinëʼ, o xiyúëʼ, tuʼ runëʼ xichinaʼ o tuʼ runëʼ libán que didzaʼ dxiʼa quiaʼ, ");
INSERT INTO zarNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","bönniʼ ni huazíʼ queëʼ iaʼtú gayuáʼtërö caʼ dza ni zóaruʼ naʼa, yuguʼ lidxëʼ, en yuguʼ bö́chëʼë, en yuguʼ zanëʼ, en yuguʼ xinë́ʼë, en yuguʼ zxíʼinëʼ, en yuguʼ xiyúëʼ, encaʼ yuguʼ le ilaʼbía ládxiʼgaca bönachi lëʼ, ateʼ lu yödzölió siʼ zaʼ, gataʼ yöl-laʼ naʼbán idú queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Zián nupa nácagaca lo naʼa, ilaca cuídiʼsö niʼ, ateʼ nupa nácagaca cuídiʼsö naʼa, ilaca lo niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Cateʼ niʼ yúʼugaquiëʼ nöza, taʼbenëʼ söjáquiëʼ Jerusalén, nanö́ruëʼ Jesús lógaquiëʼ bönniʼ usëda queëʼ. Nanítiguequinëʼ, en lu yöl-laʼ rádxisö söjácalenëʼ Lëʼ. Leyúbölö Jesús guchë́ʼë quez idxínnutëʼ naʼ. Gusí lahuëʼ ruíʼilenëʼ légaquiëʼ didzaʼ ca naca le ral-laʼ gaca queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Rnnëʼ: —Riléʼe quéziliʼ ribenruʼ zéajruʼ Jerusalén ga niʼ zoa nu udödi nedaʼ, Bönniʼ Guljëʼ Bönachi, lu náʼagaquiëʼ bixúz unná bëʼ, en lu náʼagaquiëʼ bönniʼ yudoʼ usedi, ateʼ chúguiëʼ quiaʼ gátiaʼ, en uluʼdödëʼ nedaʼ lu náʼagaquiëʼ bönniʼ ziʼtuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bönniʼ naʼ uluʼtitjëʼ nedaʼ, en ilúndëʼë nedaʼ ziʼ. Uluʼchejëʼ nedaʼ zxönaʼ. Níʼirö ilútiëʼ nedaʼ, pero cateʼ gaca tsonna dza ubanaʼ lu yöl-laʼ guti. ");
INSERT INTO zarNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Níʼirö gulaʼbiguëʼë Jacobo, en Juan, zxíʼinëʼ Zebedeo, lahuëʼ Jesús, en tëʼ Lëʼ: —Bönniʼ Usedi, rë́ʼënituʼ gunuʼ queë́tuʼ le inábatuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesús gudxëʼ légaquiëʼ: —¿Bizxi rë́ʼëniliʼ gunaʼ queë́liʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Gulë́ʼ Lëʼ: —Cateʼ idxín dza cöʼu ga inná bëʼu, ben ga cö́ʼötuʼ tutuʼ cuituʼ ibëla, en iaʼtutuʼ cuituʼ yö́göla. ");
INSERT INTO zarNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Níʼirö Jesús gudxëʼ légaquiëʼ: —Bitiʼ nö́ziliʼ bi rinábaliʼ. ¿Naruʼ huáca síʼiliʼ le ral-laʼ siʼa nedaʼ, le naca le quiʼi sacaʼa? ¿Naruʼ huáca idílaliʼ nisa ca idilaʼ nedaʼ nisa, gátiaʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Buluʼbiʼë didzaʼ, taʼnnë́ʼ: —Huácatuʼ. Jesús gudxëʼ légaquiëʼ: —Le nácatë, le quiʼi sacaʼa nedaʼ, síʼiliʼ caʼ libíʼiliʼ, en ca idilaʼ nedaʼ nisa, idílaliʼ caʼ nisa, ");
INSERT INTO zarNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","pero bitiʼ dë lu naʼa cö́aʼ nu cuía cuitaʼ ibëla, en nu cuía cuitaʼ yö́göla. Dios unödzjëʼ quégaquiëʼ bönniʼ chinupë́ʼë quégaquiëʼ yuguʼ lataj naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Cateʼ bilaʼyönnëʼ iaʼchíëʼ bönniʼ usëda queëʼ Jesús didzaʼ ni, gulaʼlenëʼ Jacobo, en Juan naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Níʼirö Jesús bulidzëʼ légaquiëʼ, rnnëʼ: —Nöz quéziliʼ ca tun nupa taʼnná beʼe yuguʼ yödzö, tuʼzenëʼ bach bönachi, ateʼ nupa nácagaca lo ládjagaquiëʼ taʼnná beʼe luzë́ʼeguequi. ");
INSERT INTO zarNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Bitiʼ gaca caní queë́liʼ, pero nu guë́ʼëni gaca zxön ga zóaliʼ, ral-laʼ gun xichinliʼ iaʼzícaʼröliʼ, ");
INSERT INTO zarNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ateʼ nútiʼtëslöliʼ nu guë́ʼëni gaca lo ral-laʼ gaca ca bönniʼ huen dxin tsaz queë́liʼ yúguʼtëliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Caní ral-laʼ gunliʼ tuʼ bidaʼ ni nedaʼ, Bönniʼ Guljëʼ Bönachi, calëga para nu gun xichinaʼ, pero para gunaʼ xichíngaca bönachi, en udödaʼ yöl-laʼ naʼbán quiaʼ le huöáʼuidaʼ bönachi zián. ");
INSERT INTO zarNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Níʼirö bilaʼdxinëʼ Jesús, en yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ yödzö Jericó. Cateʼ niʼ rurujëʼ Jesús yödzö ni, dzágagaquiëʼ Lëʼ yuguʼ bönniʼ usëda queëʼ, encaʼ bönachi zián. Raʼ nöza niʼ röʼë tu bönniʼ nachul-la lahuëʼ, lëʼ Bartimeo, zxíʼinëʼ Timeo. Rinabëʼ nu bi gúnnasö queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Cateʼ biyönnëʼ Bartimeo ridödëʼ Jesús, bönniʼ Nazaret, niʼ, gusí lahuëʼ ruʼë zidzaj didzaʼ, rnnëʼ: —¡Jesús, zxíʼini xiʼsóëʼ David! ¡Buéchiʼ ladxiʼ nedaʼ! ");
INSERT INTO zarNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nupa taʼdödi niʼ gulaʼdil-la lëʼ didzaʼ. Të lëʼ: —Busayaj ruʼu. Níʼirö zídzajrö bulidzëʼ, rnnëʼ: —¡Zxíʼini xiʼsóëʼ David! ¡Buéchiʼ ladxiʼ nedaʼ! ");
INSERT INTO zarNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Níʼirö guzóëʼ dxisö Jesús, ribözëʼ, ateʼ rëʼ légaquiëʼ: —Buliʼlidzëʼ. Buluʼlidzëʼ bönniʼ naʼ nachul-la lahuëʼ. Tëʼ lëʼ: —¡Butipa ládxuʼu! ¡Guyaschi! ¡Rulidzëʼ liʼ! ");
INSERT INTO zarNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Níʼirö gurúʼunëʼ tsöláʼalö lariʼ naxóa yenëʼ. Laʼ guyásatëʼ, en bidëʼ ga naʼ zoëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús gunábinëʼ lëʼ, rnnëʼ: —¿Bizxi rë́ʼënuʼ gunaʼ quiuʼ? Bubiʼë didzaʼ bönniʼ naʼ nachul-la lahuëʼ, rnnëʼ: —Bönniʼ Usedi, rë́ʼëndaʼ gunuʼ ga huöálaj guiö́j lahuaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús gudxëʼ lëʼ: —Böaj lidxuʼ. Chinuhuöácuʼ tuʼ réajlëʼu nedaʼ. Laʼ böáljatë guiö́j lahuëʼ, ateʼ saʼyéajlenëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Bilaʼdxinëʼ Jesús, en yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ galaʼ ga dë Jerusalén, ga naʼ nacuáʼ yödzö Betfagé, en yödzö Betania, en ga naʼ dë caʼ Guíʼa Yaga Olivo. Níʼirö Jesús gusö́l-lëʼë chopëʼ bönniʼ usëda queëʼ, ");
INSERT INTO zarNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","en rëʼ légaquiëʼ: —Guliʼtséaj lu yö́dzödoʼ dë loruʼ niʼ, en cateʼ tsúʼuliʼ niʼ, tsöjxácaʼliʼ-baʼ tubaʼ búrrodoʼ nágaʼbaʼ niʼ, en cuntu nu ribíani lëbaʼ. Guliʼsedxi-baʼ, en guliʼchë́ʼ-baʼ quiaʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Channö nu bi guíë libíʼiliʼ tuʼ runliʼ lë ni, guliʼguíë nu naʼ: “Xanruʼ riquinnëʼ-baʼ, ateʼ laʼ usö́l-laʼtëʼ-baʼ quiuʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Níʼirö yöjáquiëʼ, en yöjxácaʼgaquiëʼ-baʼ búrrodoʼ naʼ, nágaʼbaʼ raʼ nöza ga nu riyaza löʼa, ateʼ gulaʼsedxëʼ-baʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nupa nacuáʼ niʼ të légaquiëʼ: —¿Bizxi ni runliʼ? ¿Bizx que risédxiliʼ-baʼ búrrodoʼ naʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Buluʼbiʼë didzaʼ bönniʼ usëda queëʼ Jesús, gulë́ʼ légaquiëʼ ca naʼ chigudxi cazëʼ Jesús légaquiëʼ, ateʼ guluʼë légaquiëʼ lataj. ");
INSERT INTO zarNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Níʼirö gulaʼchë́ʼë-baʼ búrrodoʼ naʼ ga naʼ zoëʼ Jesús. Gulaʼxóëʼ lariʼ quégaquiëʼ cúdzuʼbaʼ, ateʼ Jesús gudxíëʼ-baʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Zián bönniʼ nacuʼë niʼ gulaʼchiljëʼ lariʼ quégaquiëʼ gapa naca laʼ nöza. Iaʼbal-la bönachi niʼ gulaʼguítsaj zin le buluʼzxóa laʼ nöza. ");
INSERT INTO zarNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Gulaʼsí lo nupa nanö́rugaca lahuëʼ Jesús, en nupa naʼ záʼgaca cúdzuʼlëʼ tuíʼi zidzaj didzaʼ, taʼnnë́ʼ: —¡Yöl-laʼ ba! ¡Xanruʼ Dios gun láʼayëʼ Bönniʼ zëʼë ni, nasö́l-lëʼë Dios Lëʼ! ");
INSERT INTO zarNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Dios gun láʼayëʼ Bönniʼ ni siʼ inná bëʼë, ca naʼ gunná bëʼë xuz xtóʼoruʼ David! ¡Yöl-laʼ ba Dios! ");
INSERT INTO zarNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Caní guca, bidxinëʼ Jesús Jerusalén, ateʼ guyáziëʼ löʼa yudoʼ. Cateʼ budxi buyúëʼ yúguʼtë le nacuáʼ idú gásibiʼilö niʼ, burúajëʼ zacaʼ yödzö Betania tuʼ chiridzö́ʼ, ateʼ dzágagaquiëʼ Lëʼ yuguʼ bönniʼ usëda queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Cateʼ zaʼ reníʼ iaʼtú dza, ateʼ tuʼrúajëʼ Jesús, en yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ yödzö Betania, ridunëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ziʼtuʼ biléʼenëʼ tu yaga higo dxía xilaguiʼ. Gubíguiʼë ga naʼ zoa yaga naʼ channö utsöjxaquiëʼ latiʼ le ribía. Cateʼ bidxinëʼ niʼ bitiʼ bi yöjxáquiëʼ le ribía. Xiláguiʼsö dxía tuʼ cabí ridxini dza cuía. ");
INSERT INTO zarNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Níʼirö Jesús bulidzëʼ yaga naʼ, rnnëʼ: —Bítiʼrö nu gagu le ribía quiuʼ. Yuguʼ bönniʼ usëda queëʼ bilaʼyönnëʼ didzaʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Cateʼ bilaʼdxinëʼ Jesús, en yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ, yödzö Jerusalén, guyáziëʼ Jesús löʼa yudoʼ, en gusí lahuëʼ rubéajëʼ níʼilö nupa tutiʼ, en nupa toʼo lu löʼa yudoʼ. Burixëʼ yuguʼ blaga quégaca nupa tuʼtsáʼ dumí izáʼa, encaʼ yuguʼ ga taʼbö́ʼ nupa tutiʼ yuguʼ guʼdödoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Bitiʼ caʼ bëʼë lataj nu bi guáʼ, uzóa nöza ga naca löʼa yudoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Busë́dinëʼ nupa nacuáʼ niʼ, rnnëʼ: —Nazúaj lu guichi láʼayi, rnna: “Lidxaʼ siʼi le, yuʼu ga bönachi idútë yödzölió uluʼlidza Dios.” Libíʼiliʼ chinunliʼ le ca naca lídxigaca gubán. ");
INSERT INTO zarNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Cateʼ yuguʼ bixúz unná bëʼ, en yuguʼ bönniʼ yudoʼ usedi bilaʼyönnëʼ didzaʼ ni, gulaʼsí lógaquiëʼ tuʼguiljëʼ nacxi ilútiëʼ Jesús, pero tuʼ tádxinëʼ le ilún bönachi, bitiʼ bi gulunëʼ queëʼ, tuʼ tuʼbani yúguʼtë bönachi ca naca le rusë́dinëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Cateʼ chiridzö́ʼ burúajëʼ Jesús lu yödzö naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Cateʼ zaʼ reníʼ iaʼtú dza, gulaʼdödëʼ Jesús, en yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ ga zoa yaga higo naʼ bulidza ziʼë Jesús, en bilaʼléʼenëʼ le, chinabidxi idú luí. ");
INSERT INTO zarNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Níʼirö yöjnenëʼ Pedro bi guca, ateʼ gudxëʼ Jesús: —Bönniʼ Usedi, buyútsöcaʼ. Chinabidxi yaga higo ni bulidza ziʼu néaje. ");
INSERT INTO zarNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Bubiʼë didzaʼ Jesús, rëʼ légaquiëʼ: —Guliʼtseajlëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Le nácatë reaʼ libíʼiliʼ, channö nu bönniʼ guíëʼ guíʼadoʼ ni: “Gucuíta ni, yöjsóa lu nísadoʼ”, en bitiʼ gaca chopa ládxëʼë bönniʼ naʼ, pero idú ládxëʼë tseajlëʼë gunëʼ Dios ca naʼ rnnëʼ, caʼ gaca. ");
INSERT INTO zarNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Que lë ni naʼ reaʼ libíʼiliʼ: Yúguʼtë le inábaliʼ cateʼ ulídzaliʼ-nëʼ Dios, guliʼtséajlëʼ chibennëʼ Dios queë́liʼ lë naʼ rinábaliʼ, ateʼ gunnëʼ queë́liʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Cateʼ niʼ rulídzaliʼ-nëʼ Dios, channö zoa nu rileliʼ nu bi ben queë́liʼ, buliʼniti lo nu naʼ, para uniti lahuëʼ caʼ libíʼiliʼ Xúziliʼ naʼ zoëʼ yehuaʼ yubá ca naca dul-laʼ nabágaʼliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Channö cabí uniti loliʼ bönachi, bitiʼ uniti lahuëʼ Xúziliʼ zoëʼ yehuaʼ yubá libíʼiliʼ dul-laʼ nabágaʼliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Níʼirö Jesús, en yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ yöjhuö́jgaquiëʼ Jerusalén. Cateʼ niʼ ridë́ʼ Jesús ga naca chila yudoʼ, bilaʼdxinëʼ yuguʼ bixúz unná bëʼ, en yuguʼ bönniʼ yudoʼ usedi, en bönniʼ gula tuʼzéajniʼinëʼ, ga zoëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Gulaʼnábinëʼ Jesús, taʼnnë́ʼ: —¿Bizxi yöl-laʼ unná bëʼ dë lu noʼo runuʼ yuguʼ lë ni? ¿Nuzxi caz budödi lu noʼo yöl-laʼ unná bëʼ gunuʼ caní? ");
INSERT INTO zarNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Bubiʼë didzaʼ Jesús, rëʼ légaquiëʼ: —Nedaʼ caʼ inábidaʼ libíʼiliʼ tu didzaʼ. Channö ubíʼiliʼ quiaʼ didzaʼ, níʼirö guíaʼ libíʼiliʼ bi yöl-laʼ unná bëʼ rúnidaʼ yuguʼ lë ni. ");
INSERT INTO zarNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Nuzxi budödi lu nëʼë Juan uquilëʼ bönachi nisa? ¿Naruʼ Dios o bönachi? Guliʼnnátsöcaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Gulaʼsí lógaquiëʼ tun xtídzaʼgaquiëʼ laʼ légacasëʼ, taʼnnë́ʼ: —Channö innaruʼ Dios gusö́l-lëʼë lëʼ, guíëʼ rëʼu: “¿Bizx que bitiʼ guyéajlëʼëliʼ lëʼ?” ");
INSERT INTO zarNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Naruʼ guíëtsaruʼ-nëʼ: Gulaʼsö́l-lëʼë bönniʼ lëʼ? Caní taʼzáʼ ládxiʼgaquiëʼ tuʼ tádxinëʼ le ilún bönachi zián nacuáʼ niʼ tuʼ téquiguequi yúguʼtë bönachi naʼ bëʼë didzaʼ Juan naʼ uláz queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Que lë ni naʼ gulë́ʼ Jesús: —Bitiʼ nöztuʼ. Níʼirö Jesús gudxëʼ légaquiëʼ: —Nedaʼ caʼ bitiʼ quíxjöiʼidaʼ libíʼiliʼ bi yöl-laʼ unná bëʼ dë lu naʼa rúnidaʼ yuguʼ lë ni. ");
INSERT INTO zarNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Níʼirö gusí lahuëʼ Jesús ruíʼilenëʼ yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ didzaʼ yuguʼ le rucúdzuʼë didzaʼ, rnnëʼ: —Guzóëʼ tu bönniʼ, budë́ʼë lubá uva zián ga naca lu xiyúëʼ. Guléquiëʼ lëʼa que, en guchö́ʼönëʼ tu rögaʼ guiö́j ga isíëʼ xisi uva naʼ. Budxíëʼ tu yuʼu gupa ga naca xitsáʼ ga nu uyú xiyúëʼ naʼ. ’Níʼirö budödëʼ xiyúëʼ naʼ lu náʼagaquiëʼ huen dxin, ilaʼziʼë gatsaj huéaj le unödzaj, ateʼ guyijëʼ yödzö ziʼtuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Cateʼ bidxín dza uluʼchibëʼ le ribía, gusö́l-lëʼë-biʼ biʼi huen dxin tsöjxíʼibiʼ lu náʼagaquiëʼ huen dxin naʼ le ral-laʼ siʼë xanbiʼ que le gulaʼbía lubá uva naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Níʼirö yuguʼ huen dxin naʼ gulaʼguélëʼë-biʼ biʼi naʼ, en gulundëʼ-biʼ ziʼ, ateʼ buluʼsö́l-lëʼë-biʼ cáʼasöbiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Níʼirö bönniʼ xan luyú naʼ gusö́l-lëʼë-biʼ iaʼtubiʼ biʼi huen dxin queëʼ, ateʼ biʼi ni buluʼladxëʼ-biʼ guiö́j. Buluʼlë́ʼë ícjabiʼ. Guluʼë döʼ queë́biʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Níʼirö bönniʼ xan luyú naʼ gusö́l-lëʼë-biʼ caʼ iaʼtubiʼ biʼi huen dxin queëʼ, ateʼ biʼi ni gulútiëʼ-biʼ. Gusö́l-lëʼë-biʼ caʼ ziánröbiʼ, ateʼ bál-labiʼ gulúngacadëʼ-biʼ ziʼ, en iaʼbál-labiʼ gulútigaquiëʼ-biʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Cúnturö nu nagáʼana queëʼ xan luyú naʼ. Nagáʼanasibiʼ zxíʼinëʼ, ateʼ nadxíʼideʼenëʼ-biʼ. Ga yöjsetë, gusö́l-lëʼë-biʼ zxíʼinëʼ, rnnëʼ: “Ilunëʼ bal zxíʼinaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Níʼirö yuguʼ bönniʼ huen dxin naʼ gulaʼnnë́ʼ laʼ légacasëʼ, taʼnnë́ʼ: “Biʼi ni ral-laʼ guequi queë́biʼ luyú ni. Guliʼdá, gútiruʼ-biʼ, ateʼ guequi queë́ruʼ luyú ni.” ");
INSERT INTO zarNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Que lë ni naʼ gulaʼzönëʼ-biʼ, en gulútiëʼ-biʼ. Gulaʼrúʼunëʼ-biʼ níʼilö ga dáʼgaca lubá uva naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Níʼirö Jesús gunábinëʼ bönniʼ nacuʼë niʼ, rnnëʼ: —¿Nacxi gunëʼ bönniʼ xan luyú naʼ, channö? Huidëʼ, en gútigaquiëʼ bönniʼ huen dxin naʼ, ateʼ udödëʼ luyú naʼ lu náʼgaquiëʼ bönniʼ yúbölö. ");
INSERT INTO zarNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Naruʼ cabí nulábaniliʼ lë naʼ nazúaj lu guichi láʼayi? Caní rnna: Guiö́j naʼ gulaʼrúʼunëʼ bönniʼ tuʼcuʼë zöʼö, naʼa naca guiö́j len, squin zöʼö. ");
INSERT INTO zarNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Xanruʼ Dios benëʼ ga naca caní ateʼ rubániruʼ ca naca lë ni riléʼeruʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Níʼirö taʼzóa taʼböʼë ilaʼzönëʼ Jesús tuʼ téquibeʼenëʼ bucúdzuʼë didzaʼ ca naca quégaquiëʼ, pero tádxinëʼ le ilún bönachi zián nacuáʼ niʼ, en que lë ni naʼ buluʼcáʼanëʼ Lëʼ, söhuö́jgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Gudödi lë ni yuguʼ bönniʼ yudoʼ unná bëʼ naʼ gulaʼsö́l-lëʼë bal-lëʼ bönniʼ yudoʼ fariseo len bönniʼ dáʼgaquiëʼ Herodes ga zoëʼ Jesús para ilunëʼ ga bi innë́ʼ para gaca uluʼzéguiëʼ Lëʼ didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bilaʼdxinëʼ bönniʼ ni ga naʼ zoëʼ Jesús, en tëʼ Lëʼ: —Bönniʼ Usedi, nö́zituʼ ruʼu didzaʼ idútë li. Bitiʼ ruíʼi ládxuʼu bi taʼnnasö bönachi, tuʼ cabí ruyusuʼ le tuʼluíʼisö cuínguequi bönachi, pero rusë́dinuʼ ca nácatë le rë́ʼënëʼ Dios ilún bönachi. ¿Ruíʼi netuʼ lataj xibá queëʼ Moisés quizxaj laztuʼ le tuʼquizxjëʼ uláz queëʼ César? ¿Naruʼ uguízxajtuʼ o bitiʼ quízxajtuʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Réquibeʼenëʼ Jesús tuʼë didzaʼ lu yöl-laʼ riguílaj ladxiʼ quégaquiëʼ, ateʼ rëʼ légaquiëʼ: —¿Bizx que rubéajliʼ nedaʼ didzaʼ? Guliʼdiguáʼtsöcaʼ tu dumí ridá para iléʼedaʼ le. ");
INSERT INTO zarNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Diguáʼagaquiëʼ le, ateʼ Jesús gunábinëʼ légaquiëʼ, rnnëʼ: —¿Nuzxi lahui daʼ lëʼe ni, en nuzxi lë ni? Buluʼbiʼë didzaʼ, taʼnnë́ʼ: —Queëʼ César naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Níʼirö Jesús gudxëʼ légaquiëʼ, rnnëʼ: —Buliʼnödzaj queëʼ César le nequi queëʼ César, ateʼ queëʼ Dios le nequi queëʼ Dios. Buluʼbáninëʼ ca naca didzaʼ bubiʼë Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Níʼirö bilaʼdxinëʼ bal-lëʼ bönniʼ yudoʼ saduceo ga zoëʼ Jesús. Bönniʼ ni taʼnnë́ʼ bitiʼ uluʼbán nupa chinátigaca. Que lë ni naʼ gulë́ʼ Jesús, taʼnnë́ʼ: ");
INSERT INTO zarNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Bönniʼ Usedi, Moisés nuzúajëʼ queë́ruʼ lu guichi channö gátiëʼ tu bönniʼ bitiʼ zoa biʼi queëʼ, ateʼ ugáʼananu nigula queëʼ, biʼi bö́chëʼë bönniʼ naʼ ral-laʼ utsaga náʼalenbiʼ-nu, en uzóabiʼ bíʼidoʼ gácabiʼ biʼi queë́biʼ bö́chiʼbiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Gulaʼcuáʼabiʼ gádxibiʼ biʼi nácagacabiʼ bö́chiʼgacabiʼ. Biʼi huáca naʼ butsaga náʼalenbiʼ-nu nigula, ateʼ gútibiʼ, cuntu nu zoa bíʼidoʼ queë́biʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Biʼi buropi naʼ butsaga náʼalenbiʼ-nu nigula uzëbi naʼ, ateʼ gútibiʼ caʼ, cuntu nu zoa bíʼidoʼ queë́biʼ. Lëscaʼ caní guca queë́biʼ biʼi bunni. ");
INSERT INTO zarNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Caní guca, buluʼtsaga náʼalenbiʼ-nu yúguʼtëbiʼ, cuntu nu zoa bíʼidoʼ quégacabiʼ. Ga yöjsetë, gútinu caʼ nigula naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Naʼa, cateʼ uluʼbán nupa chinátigaca, ¿núzxilöbiʼ guéquinu nigula naʼ queë́biʼ, tuʼ buluʼtsaga náʼalenbiʼ-nu igádxitëbiʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Bubiʼë didzaʼ Jesús, rëʼ légaquiëʼ: —Richíxiliʼ tuʼ cabí núnbëʼëliʼ le nazúaj lu guichi láʼayi, en bitiʼ nö́ziliʼ ca naca yöl-laʼ huáca queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Cateʼ uluʼbán nupa chinátigaca, bitiʼ caʼ uluʼtsaga náʼagaquiëʼ, ateʼ yuguʼ bönniʼ bitiʼ ilaʼcuáʼlenëʼ nigula, pero ilácagaquiëʼ ca nácagaquiëʼ gubáz láʼayi queëʼ Dios, nacuʼë yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Naʼa, ca naca quégaca nupa chinátigaca channö uluʼbán, ¿naruʼ cabí nulábaniliʼ le buzúajëʼ lu guichi Moisés? Ruíʼi didzaʼ ca naʼ bulidzëʼ Dios lëʼ lu yaga yö́tsiʼdoʼ régui. Gudxëʼ lëʼ: “Nedaʼ nacaʼ Dios queëʼ Abraham, en Dios queëʼ Isaac, en Dios queëʼ Jacob.” Tuʼ gunnë́ʼ caní quégaquiëʼ, naca bëʼ nabángaquiëʼ sal-laʼ gulátiëʼ zíʼalö. ");
INSERT INTO zarNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dios náquiëʼ Dios quégaca nupa nabángaca, calëga quégaca nupa nátigaca tsaz. Richíxitëröliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Bidëʼ caʼ tu bönniʼ yudoʼ usedi ga zoëʼ Jesús. Biyönnëʼ ca naʼ guluíʼilenëʼ Jesús didzaʼ, en nö́zinëʼ dxíʼadoʼ bubiʼë Jesús didzaʼ. Que lë ni naʼ gunábinëʼ Jesús, rnnëʼ: —¿Bízxilö le gunná bëʼë Dios nácatërö lo ca yúguʼtë le gunná bëʼë? ");
INSERT INTO zarNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Bubiʼë didzaʼ Jesús, rëʼ lëʼ: —Le gunná bëʼë le nácatërö lo ca yúguʼtë naca lë naʼ rnna: “Guliʼyöni bönachi Israel. Xanruʼ Dios, tuzëʼ Lëʼ náquiëʼ Xanruʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ral-laʼ idxíʼinuʼ Xanuʼ Dios idú ládxuʼu, en lu idú icja ládxiʼdoʼo, en lu idú yöl-laʼ réajniʼi quiuʼ, en lu idú yöl-laʼ huáca quiuʼ.” Lë ni naca le gunná bëʼë le nácatërö lo. ");
INSERT INTO zarNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Le gunná bëʼë le naca buropi, lë́bisö ca naca. Caní rnna: “Ral-laʼ idxíʼinuʼ luzóʼo ca nadxíʼi cuinuʼ.” Bitiʼ caʼ zoa iaʼtú le gunná bëʼë le nácarö lo ca chopa ni gunná bëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Níʼirö bönniʼ yudoʼ usedi naʼ gudxëʼ Jesús, rnnëʼ: —Dxíʼadoʼ gunnóʼ, Bönniʼ Usedi. Le nácatë rnnoʼ. Tuzëʼ náquiëʼ Dios, en cúnturö nu zoa naca Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Para idxíʼiruʼ-nëʼ Dios idú ládxiʼruʼ, en lu idú yöl-laʼ réajniʼi queë́ruʼ, en lu idú icja ládxiʼdoʼoruʼ, en lu idú yöl-laʼ huáca queë́ruʼ, en para idxíʼiruʼ luzáʼaruʼ ca nadxíʼi cuinruʼ, nácarö lesacaʼ ca yúguʼtë böaʼ bë́dxidoʼ rútigacaruʼ-baʼ lu bucugu láʼayi queëʼ Dios, encaʼ ca yúguʼtë böaʼ bë́dxidoʼ ruzéguiʼgacaruʼ-baʼ lu bucugu naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Cateʼ biyönnëʼ Jesús dxíʼadoʼ rubiʼë didzaʼ bönniʼ ni, níʼirö gudxëʼ lëʼ, rnnëʼ: —Iaʼlátiʼsö riyadzaj quiuʼ gúnbëʼu le rinná bëʼë Dios. Cúnturö nu burugui bi inábini Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Cateʼ niʼ rusë́dinëʼ Jesús bönachi ga naca chila yudoʼ, rnnëʼ: —¿Bizx que taʼnnë́ʼ bönniʼ yudoʼ usedi náquiëʼ Cristo zxíʼini xiʼsóëʼ David? ");
INSERT INTO zarNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Lë cazëʼ David naʼ bëʼë didzaʼ, zóalenëʼ Dios Böʼ Láʼayi lëʼ, gunnë́ʼ: Xanruʼ Dios gudxëʼ Xanaʼ: “Gurö́ʼö cuita lëʼa ibëla cateʼ gunraʼ ga uluʼzóa zxíbigaca loʼ nupa bitiʼ taʼléʼe Liʼ dxiʼa.” ");
INSERT INTO zarNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Naruʼ nácatsëʼ Cristo zxíʼini xiʼsóëʼ David channö lë cazëʼ David naʼ rnnëʼ queëʼ náquiëʼ Xanëʼ? Bönachi zián nacuáʼ niʼ tuʼzë́ nágagaca Lëʼ gulaʼyaza ládxiʼgaca didzaʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Niʼ rusë́dinëʼ Jesús yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ, rëʼ légaquiëʼ: —Guliʼgún chiʼi cuinliʼ quégaquiëʼ bönniʼ yudoʼ tuʼsë́dinëʼ. Taʼyaza ládxiʼgaquiëʼ taʼdë́ʼ nilö naʼlö, nácugaquiëʼ lariʼ tunna. Taʼyaza ládxiʼgaquiëʼ caʼ tuʼlidza tsahuiʼ bönachi légaquiëʼ gapa naca lu yë́ʼëyi. ");
INSERT INTO zarNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Taʼböʼë yuguʼ lataj lo lu yuʼu ga tuʼdubëʼ tuʼsëdëʼ queëʼ Dios, encaʼ gapa tuʼdubëʼ tëʼaj tahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Rugúagaquiëʼ lídxigacanu nigula uzëbi, en para uluʼluíʼisö tsahuiʼ cuíngaquiëʼ, xidzé tuʼlidzëʼ Dios. Bönniʼ ni, gúndaʼrëʼ Dios légaquiëʼ xíguiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tsanni niʼ röʼë Jesús chila yudoʼ ga zoa guíʼina ga taʼgúʼu bönachi dumí que yudóʼ, ruyúëʼ ca tun bönachi taʼgúʼu dumí lu guíʼina. Dumí zián taʼguʼë bönniʼ dë yöl-laʼ tsahuiʼ quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Níʼirö bidxinnu tu nigula yechiʼ uzë́bidoʼ niʼ, ateʼ gulúʼunu chopa dumí lásidoʼ, le nazácaʼgaca látiʼdoʼos. ");
INSERT INTO zarNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Níʼirö bulidzëʼ Jesús yuguʼ bönniʼ usëda queëʼ, en rëʼ légaquiëʼ: —Le nácatë reaʼ libíʼiliʼ, nigula yechiʼ uzë́bidoʼ ni gulúʼurönu ca yúguʼtë nupa bi taʼgúʼu lu guíʼina que yudoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yúguʼtë bönniʼ ni taʼguʼë que le nagáʼanasö quégaquiëʼ, pero nigula ni, lu yöl-laʼ yéchiʼdoʼ queë́nu gulúʼunu idútë laʼs dui tsca le dësö queë́nu, le ral-laʼ gáhuinu. ");
INSERT INTO zarNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Cateʼ burúajëʼ Jesús chila yudoʼ, tuëʼ bönniʼ usëda queëʼ gudxëʼ Lëʼ, rnnëʼ: —Bönniʼ Usedi, buyútsöcaʼ náctiga yuguʼ yuʼu zxön ni, en náctiga yuguʼ guiö́j lëʼe zöʼö quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Bubiʼë didzaʼ Jesús, rëʼ lëʼ: —Riléʼenuʼ yuguʼ yuʼu zxön ni, pero bitiʼ caʼ ugáʼana guiö́j lahui luzë́ʼe ni, tuʼ uluʼquínnaj bönachi léguequi. ");
INSERT INTO zarNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Níʼirö yöjáquiëʼ Jesús, en yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ lu Guíʼa Yaga Olivo, guíʼa naʼ dë ca dö́dilö raʼ yudoʼ. Cateʼ chiröʼë Jesús niʼ, laʼ légacasëʼ Pedro, en Jacobo, en Juan, en Andrés, gulë́ʼ Lëʼ, taʼnnë́ʼ: ");
INSERT INTO zarNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Gudíxjöiʼi netuʼ bátaxi ilaca lë ni. ¿Bizxi gaca bëʼ chizóa ilaca yúguʼtë lë ni? ");
INSERT INTO zarNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Bubiʼë didzaʼ Jesús, rusë́dinëʼ légaquiëʼ, rnnëʼ: —Guliʼgún chiʼi cuinliʼ para cabí nu siʼ yeʼe libíʼiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ilaʼláʼ lahuëʼ zián bönniʼ siʼ lágaquiëʼ ca leaʼ nedaʼ, ilaʼnnë́ʼ nácagaquiëʼ Cristo. Caní ilaʼzíʼ yéʼenëʼ bönachi zián. ");
INSERT INTO zarNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Níʼirö cateʼ yö́niliʼ raca gudil-la nilö náʼalö, bitiʼ gádxiliʼ. Yúguʼtë lë ni ral-laʼ ilaca, pero bitiʼ ridxini dza údxi. ");
INSERT INTO zarNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tu yödzö tíl-lalen iaʼtú yödzö, en tu ga nu rinná bëʼ tsöjtíl-lalen iaʼtú ga nu rinná bëʼ. Zián lataj tödi budóʼ zxuʼ, en tsuʼu gubín. Ilaʼtsatsa bönachi. Yuguʼ lë ni ilaca le isí lo ilaʼguíʼi ilaʼzacaʼ bönachi dza niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Níʼirö guliʼgún chiʼi cuinliʼ, tuʼ uluʼdödëʼ libíʼiliʼ lu náʼagaquiëʼ bönniʼ yúlahuiʼ. Ilaʼguinëʼ libíʼiliʼ gapa tuʼdubëʼ tuʼsëdëʼ queëʼ Dios bönniʼ judío. Idxinliʼ lógaquiëʼ bönniʼ taʼnná béʼenëʼ libíʼiliʼ, en lógaquiëʼ bönniʼ taʼnná béʼenëʼ yödzö ziʼtuʼ. Ilunëʼ caní queë́liʼ tuʼ dáʼaliʼ nedaʼ, pero gunliʼ ba nalí quiaʼ nedaʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Zíʼalö ca idxín dza údxi, run bayudxi gaca libán que didzaʼ dxiʼa quiaʼ lógaca bönachi idútë yödzölió. ");
INSERT INTO zarNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Cateʼ niʼ ilaʼchë́ʼë libíʼiliʼ, en uluʼdödëʼ libíʼiliʼ lu náʼagaquiëʼ bönniʼ yúlahuiʼ, bitiʼ güíʼi ládxiʼliʼ bizxi innaliʼ. Laʼ dza níʼisö Dios gunnëʼ queë́liʼ didzaʼ güíʼiliʼ, ateʼ lë ni innaliʼ. Cateʼ niʼ güíʼiliʼ didzaʼ, calëga libíʼisiliʼ naʼ innaliʼ, pero Dios Böʼ Láʼayi innë́ʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Uluʼdödi bönachi laʼ bö́chiʼgacasö lu náʼagaquiëʼ bönniʼ ilútiëʼ légaquiëʼ. Yuguʼ bönniʼ nacuáʼabiʼ biʼi quégaquiëʼ uluʼdödëʼ laʼ zxíʼinigaca cazëʼ caʼ, ateʼ zxíʼinigaquiëʼ naʼ uluʼdö́dibiʼ laʼ xuz xináʼagaca cázabiʼ lu náʼagaquiëʼ bönniʼ ilútiëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yúguʼtë bönachi uluʼzóa libíʼiliʼ tsöláʼalö tuʼ dáʼaliʼ nedaʼ, pero núlöliʼ guáʼ ilenliʼ lë naʼ ga idxinrö dza údxi, uláliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Nupa tuʼlaba didzaʼ ni ral-laʼ ilaʼyéajniʼi. Buzúajëʼ lu guichi Daniel, bönniʼ niʼ bëʼë didzaʼ uláz queëʼ Dios, le rnna caní: “Tsaz tu le xihuiʼ le rucáʼana cané ga naca laʼayi.” Dza níʼirö ral-laʼ ilaʼzxunnaj nupa nacuáʼ luyú Judea, en tsöjaca gapa naca lu guíʼadoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nu zoa ícjoʼolö dza niʼ ral-laʼ izxúnnajtë, en bitiʼ huötaj zxan yuʼu para tsöjzxíʼ bi dë que lu yuʼu. ");
INSERT INTO zarNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nu zoa laʼ guixiʼ ral-laʼ izxúnnajtë, en bitiʼ huö́aj tsöjzxíʼ lariʼ rixóa yeni. ");
INSERT INTO zarNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Bicaʼ bayechiʼ yuguʼ nigula dza niʼ nuáʼagacanu-biʼ bíʼidoʼ, encaʼ nigula tuʼgádxiʼnu-biʼ bíʼidoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Buliʼlidzëʼ Dios inábiliʼ-nëʼ cabí gun bayudxi izxúnnajliʼ cateʼ raca beoʼ ziaga caʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yuguʼ dza niʼ ilaʼguíʼi ilaʼzacaʼrö bönachi ca le guca zíʼatëlö cateʼ siʼ gutaʼ yödzölió le benëʼ Dios ga ridxintë naʼa dza, ateʼ dza záʼgaca bitiʼ gaca caní. ");
INSERT INTO zarNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Laʼtuʼ cabí nunëʼ Dios ga uluʼhuöáca nabábasö yuguʼ dza niʼ, cuntu nu ulá, pero tuʼ nadxíʼinëʼ nupa chigurö́ cazëʼ, chinunëʼ queëʼ gunëʼ ga uluʼhuöáca nabábasö yuguʼ dza niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Naʼa, channö nu guíë libíʼiliʼ: “Buliʼyútsöcaʼ, ni zoëʼ Cristo”, o inná: “Buliʼyútsöcaʼ, niʼ zoëʼ”, bitiʼ caʼ tséajlëʼëliʼ nu naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ilaʼláʼ lahuëʼ zián bönniʼ ilaʼzíʼ yéʼenëʼ bönachi. Ilaʼnnë́ʼ nácagaquiëʼ Cristo, en ilaʼnnë́ʼ nácagaquiëʼ bönniʼ tuʼë didzaʼ uláz queëʼ Dios. Uluʼluíʼinëʼ le ilaca bëʼ, en ilunëʼ yuguʼ yöl-laʼ huáca zxön. Hualaʼzíʼ yéʼenëʼ caʼ nupa gurö́ cazëʼ Dios channö ilaʼzéquiʼnëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Níʼirö libíʼiliʼ, guliʼsóa ban ladxiʼ. Yúguʼtë chigudxaʼ libíʼiliʼ zíʼatëlö ca gaca. ");
INSERT INTO zarNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Gunnë́ʼ caʼ Jesús: —Yuguʼ dza niʼ, tödi gaca dza naʼ ilaʼguíʼi ilaʼzacaʼ caní bönachi, ichul-la gubidza, en bitiʼ cuʼu beníʼ beoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ilaʼguínnaj bölaj lúzxiba, en ilaʼzxizi le nál-lagaca naláʼgaca lúzxiba naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Níʼirö ilaʼléʼeni nedaʼ, Bönniʼ Guljëʼ Bönachi, zaʼa lu böaj lúzxiba, napaʼ yöl-laʼ huáca zxön, en yöl-laʼ beníʼ quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Isö́l-laʼgacaʼ-nëʼ gubáz láʼayi quiaʼ, ateʼ uluʼtubëʼ bönachi gurö́ cazaʼ quiaʼ nacuáʼ idapa laʼa yödzölió, ga naguélaʼtë luyú bidxi, ga ridxintë ga naguelaʼ lúzxiba. ");
INSERT INTO zarNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Guliʼtséajniʼi le rusedi yaga higo niʼ. Cateʼ taʼlén niʼa nëʼe huë́ʼënidoʼ, en rubía xilaguiʼ yulu, nö́ziliʼ chizóa idxín beoʼ cusubá. ");
INSERT INTO zarNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Lëscaʼ caní, cateʼ iléʼeliʼ taca lë ni, inö́ziliʼ chizóa idxín dza údxi naʼ, en chiridzaga lo. ");
INSERT INTO zarNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Le nácatë reaʼ libíʼiliʼ, yúguʼtë lë ni ilaca zíʼatëlö ca ilátigaca nupa nacuáʼ dza naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Huadödi que lúzxiba, en que luyú ni, pero xtídzaʼa catu caz tödi que. ");
INSERT INTO zarNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Cateʼ idxín dza niʼ o rëla niʼ, cuntu nu nözi. Bitiʼ nö́zguequinëʼ gubáz láʼayi nacuʼë yehuaʼ yubá, en bitiʼ nözdaʼ nedaʼ, Zxíʼinëʼ Dios. Tuzëʼ Dios Xuz nö́zinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Que lë ni naʼ, buliʼsubán ládxiʼliʼ. Guliʼsóa sinaʼ, en buliʼlidzëʼ Dios tuʼ cabí nö́ziliʼ bizxi dza gaca lë ni. ");
INSERT INTO zarNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Gaca ca raca cateʼ saʼyéajëʼ ziʼtuʼ tu bönniʼ. Cateʼ chizóa uzë́ʼë lidxëʼ, udödëʼ lu náʼagaquiëʼ huen dxin queëʼ yuguʼ le dë queëʼ. Que queë́gaquiëʼ guʼë xichíngaquiëʼ, en inná bëʼë soa ban ladxiʼ nu zoa huen chiʼi ga nu riyaza. ");
INSERT INTO zarNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Guliʼsóa libíʼiliʼ ban ladxiʼ tuʼ cabí nö́ziliʼ bátaxi huödëʼ xan yuʼu, cateʼ chiridzö́ʼ, o gatsaj lahuiʼ yëla, o cateʼ ribö́dxibaʼ böra, o zíladoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Guliʼgún caní, para cabí idixáquiëʼ libíʼiliʼ rásiliʼ channö huödëʼ tsálidoʼos. ");
INSERT INTO zarNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Lë ni reaʼ libíʼiliʼ, reaʼ caʼ yúguʼtë bönachi: Guliʼsóa ban ladxiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Iaʼchopa dza caʼ gaca Laní Pascua cateʼ tuʼsubanëʼ bönniʼ judío ca benëʼ Dios, bubéajëʼ xuz xtóʼogaquiëʼ luyú Egipto. Naca laní cateʼ tahuëʼ yöta xtila bitiʼ nazíʼ cúa zi que. Taʼzóa taʼböʼë yuguʼ bixúz unná bëʼ, en bönniʼ yudoʼ tuʼsë́dinëʼ ilaʼzönëʼ Jesús bagáchiʼsö para ilútiëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Taʼnnë́ʼ: —Bitiʼ gaca sönruʼ-nëʼ dza laní tuʼ ilaʼtsatsa bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Zoëʼ Jesús yödzö Betania, lu yuʼu lidxëʼ Simón, bönniʼ güíʼinëʼ huëʼ nudzuʼ ruzödi. Tsanni niʼ röʼë rahuëʼ Jesús, guyázanu tu nigula, nuáʼanu tu bö́gaʼdoʼ néquini guiö́j zacaʼ, yudzu le riláʼ zxixi que yöj susén lasi idú, le nazacaʼ yenniʼ. Guláʼanu bö́gaʼdoʼ naʼ, en gulúʼunu le riláʼ zxixi naʼ icjëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Gulaʼlélanëʼ bal-lëʼ bönniʼ nacuʼë niʼ. Taʼnnë́ʼ laʼ légacasëʼ: —¿Bizx que guca ditaj le zxixi naʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Laʼtuʼ nu gutiʼ lë naʼ, huazíʼ que iaʼlatiʼ ca lázxjaruʼ que tu iz para nu quisi le quégaca bönachi yechiʼ. Gulaʼnnë́dëʼë queë́nu. ");
INSERT INTO zarNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Níʼirö Jesús bëʼë didzaʼ, rnnëʼ: —Guliʼgüíʼi-nu lataj. ¿Bizx que rinnë́ zíʼiliʼ queë́nu? Naca dxiʼa le bennu quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nacuáʼlenticaʼsö bönachi yechiʼ libíʼiliʼ, en bátatiʼtës guë́ʼëniliʼ, huáca gunliʼ dxiʼa quégaquiëʼ, pero nedaʼ bitiʼ sóaticaʼsaʼ ga zóaliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tsca le guzxéquiʼnu bennu nigula ni. Cateʼ gulúʼunu le riláʼ zxixi ni nedaʼ, bupáʼanu nedaʼ zíʼatëlö ca igáchaʼa yeru ba. ");
INSERT INTO zarNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Le nácatë reaʼ libíʼiliʼ, gátiʼtës ga gaca libán que didzaʼ dxiʼa quiaʼ idú yödzölió, soa nu quixjöʼ caʼ lë ni bennu nigula ni quiaʼ. Caní gaca para nu tsöjné lënu. ");
INSERT INTO zarNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Níʼirö birúajëʼ Judas Iscariote, bönniʼ nabábalenëʼ chínnuëʼ naʼ dáʼgaquiëʼ Jesús. Guyijëʼ ga nacuʼë bixúz unná bëʼ para udödëʼ Jesús lu náʼagaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Cateʼ bilaʼyönnëʼ xtídzëʼë Judas naʼ, buluʼdzéjanëʼ, ateʼ gulaʼzíʼ lu náʼagaquiëʼ iluʼë lëʼ dumí. Níʼirö gusí lahuëʼ Judas rizóa riböʼë udödëʼ Jesús lu náʼagaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Naca dza risí lo laní cateʼ tahuëʼ yöta xtila bitiʼ nazíʼi cúa zi que, dza naʼ tutiëʼ-baʼ böʼcuʼ zxílaʼdoʼ tahuëʼ-baʼ dzöʼ Laní Pascua naʼ, cateʼ tuʼsubanëʼ ca benëʼ Dios busölë́ʼ bönachi judío luyú Egipto. Níʼirö bönniʼ usëda queëʼ Jesús gulaʼnábinëʼ Lëʼ, taʼnnë́ʼ: —¿Gazxi rë́ʼënuʼ tséajtuʼ tsöjpáʼatuʼ le gáguruʼ xtsöʼ que Laní Pascua? ");
INSERT INTO zarNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Níʼirö Jesús gusö́l-lëʼë chopëʼ bönniʼ usëda queëʼ, en rëʼ légaquiëʼ: —Guliʼtséaj lu yödzö. Niʼ huadzágaliʼ tu bönniʼ nuʼë tu röʼö nisa. Guliʼtséajlenëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ga naʼ tsáziëʼ, guliʼguíëʼ xan yuʼu naʼ: “Rnnëʼ Bönniʼ Usedi: ¿Gazxi zoa yuʼu ga naʼ gágulengacaʼ-nëʼ bönniʼ usëda quiaʼ xtsöʼ que Laní Pascua?” ");
INSERT INTO zarNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Níʼirö uluíʼinëʼ libíʼiliʼ tu yuʼu zxön ga naca buropi cuía ga chinabáʼa. Buliʼpáʼa le gáguruʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bilaʼrúajëʼ bönniʼ usëda queëʼ naʼ, en bilaʼdxinëʼ lu yödzö, ateʼ yöjxácaʼgaquiëʼ yúguʼtë ca naʼ chigudxëʼ légaquiëʼ Jesús. Buluʼpë́ʼë le ilahuëʼ niʼ que Laní Pascua. ");
INSERT INTO zarNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Cateʼ chizáʼ ral-la, bidxinëʼ Jesús niʼ, dzágagaquiëʼ idxínnutëʼ bönniʼ usëda queëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tsanni niʼ rö́ʼögaquiëʼ tahuëʼ, bëʼë didzaʼ Jesús, rnnëʼ: —Le nácatë reaʼ libíʼiliʼ, zoa nu dzaga libíʼiliʼ, nu rágulen nedaʼ tsözxö́n, nu udödi nedaʼ lu náʼagaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Níʼirö buluʼhuíʼinnëʼ, en gulaʼsí lógaquiëʼ tu tuëʼ tëʼ Lëʼ: —¿Naruʼ nedaʼ? Iaʼtúëʼ caʼ gunnë́ʼ: —¿Naruʼ nedaʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Bubiʼë didzaʼ Jesús, rëʼ légaquiëʼ: —Naca tu nu nutsaʼ ladaj chínnuliʼ ni, bönniʼ naʼ nunë́ʼë nëʼë tsözxö́n len naʼa lu yö́ʼöna. ");
INSERT INTO zarNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tsejaʼ ga gátiaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, ca naʼ nazúaj lu guichi láʼayi ca gaca quiaʼ, pero bicaʼ bayechiʼ bönniʼ naʼ udödëʼ nedaʼ lu náʼagaquiëʼ bönniʼ ilútiëʼ nedaʼ. Gácarö dxiʼa queëʼ bönniʼ naʼ laʼtuʼ cabí guljëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tsanni niʼ tahuëʼ, gudélëʼë Jesús yöta xtila. Gudxëʼ Dios: “Xclenuʼ.” Buzxuzxjëʼ le, en bëʼë quégaquiëʼ, rnnëʼ: —Guliʼgagu. Lë ni naca bëlaʼ rön quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Gudélëʼë caʼ tu zxígaʼdoʼ, en gudxëʼ Dios: “Xclenuʼ.” Níʼirö bëʼë quégaquiëʼ, ateʼ yúguʼtëʼ gulë́ʼajëʼ le. ");
INSERT INTO zarNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesús rëʼ légaquiëʼ: —Lë ni xichönaʼ le run tsutsu didzaʼ cubi rucáʼana tsahuiʼ, le núnlenëʼ Dios bönachi. Rön ni ilalaj niʼa quégaca bönachi zián. ");
INSERT INTO zarNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Le nácatë reaʼ libíʼiliʼ, bítiʼrö guíʼjaʼ xisi uva ga idxinrö dza guíʼjaʼ le cubi ga niʼ rinná bëʼë Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Gudödi gulúl-lëʼ yöl-laʼ ba, bilaʼrúajëʼ söjáquiëʼ Guíʼa Yaga Olivo. ");
INSERT INTO zarNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Níʼirö Jesús gudxëʼ légaquiëʼ, rnnëʼ: —Yúguʼtëliʼ gaca chopa ládxiʼliʼ, ucáʼanaliʼ nedaʼ naʼa dzöʼ, tuʼ nazúaj lu guichi láʼayi, rnna: “Gutiaʼ-nëʼ uyú böʼcuʼ zxilaʼ, ateʼ ilásilasibaʼ böʼcuʼ zxilaʼ naʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tödi ubanaʼ lu yöl-laʼ guti, tsejaʼ luyú Galilea zíʼalö ca libíʼiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Níʼirö Pedro gudxëʼ Jesús, rnnëʼ: —Sal-laʼ yúguʼtëʼ ilaca chopa ládxiʼgaquiëʼ, en uluʼcáʼanëʼ Liʼ, bitiʼ caʼ gaca chopa ládxaʼa nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús gudxëʼ lëʼ, rnnëʼ: —Le nácatë reaʼ liʼ, laʼ dzöʼ nisö, siʼ cö́dxilöbaʼ böra le buropi luzuí, tsonna luzuí innóʼ bitiʼ núnbëʼu nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Níʼirö Pedro buzötjëʼ Dios, rnnëʼ: —Sal-laʼ gátilenteaʼ Liʼ tsözxö́n, bitiʼ caʼ inníaʼ bitiʼ núnbëʼa Liʼ. Lëscaʼ caní gulaʼnnë́ʼ yúguʼtëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Níʼirö Jesús, en bönniʼ dáʼgaquiëʼ Lëʼ bilaʼdxinëʼ laʼ yëla Getsemaní, ateʼ Jesús gudxëʼ légaquiëʼ, rnnëʼ: —Guliʼcö́ʼ ni, tsanni tsejaʼ nedaʼ, tsöjlidzaʼ-nëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jesús guchë́ʼë Pedro, en Jacobo, en Juan, ateʼ gusí lahuëʼ ridzö́binëʼ, en risëbi ládxëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Gudxëʼ légaquiëʼ, rnnëʼ: —Huati cazaʼ lu yöl-laʼ risëbi ladxiʼ. Guliʼcö́z ni, en guliʼnáʼ yëla. ");
INSERT INTO zarNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Níʼirö guzë́ʼë Jesús iaʼlátiʼdoʼ, en busudxín lahuëʼ lu yu, bulidzëʼ Dios. Gunábinëʼ Lëʼ, channö huáca, ucuítëʼ queëʼ le ral-laʼ quiʼi sáquëʼë dza naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Niʼ rulidzëʼ Dios, rnnëʼ: —Xúzaʼdoʼ, yúguʼtë huáca gunuʼ Liʼ. Gucuíta lë naʼ ral-laʼ quiʼi sacaʼa, pero calëga ca rë́ʼëndaʼ nedaʼ, pero ca rë́ʼënuʼ Liʼ, gunuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Níʼirö bö́ajëʼ Jesús ga naʼ nacuʼë bönniʼ usëda queëʼ, ateʼ yöjxáquiëʼ légaquiëʼ tasiëʼ. Gudxëʼ Pedro: —Simón, ¿rásitsoʼ? ¿Naruʼ cabí rubéajtsoʼ yëla loʼ tu chíʼidoʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Guliʼnáʼ yëla, en buliʼlidzëʼ Dios, inábiliʼ-nëʼ para cabí gataʼ lataj tuʼ xihuiʼ idilúʼu yöl-laʼ libíʼiliʼ. Le nácatë böʼ naca cázaliʼ zoa caz sinaʼ, pero lu yöl-laʼ bönáchisö queë́liʼ ricuídiʼliʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Níʼirö saʼyéajëʼ Jesús leyúbölö, rulidzëʼ Dios, en laʼ tuz ca gunnë́ʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Cateʼ bö́ajëʼ leyúbölö ga naʼ nacuʼë, yöjxáquiëʼ légaquiëʼ tasiëʼ tuʼ nadö́ditë yëla lógaquiëʼ. Bitiʼ nö́zguequinëʼ bizxi didzaʼ uluʼbiʼë, le ilë́ʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Cateʼ bö́ajëʼ le bunni luzuí ga naʼ nacuʼë, rëʼ légaquiëʼ: —¿Rásitsaliʼ? ¿Ruziʼtsa ládxiʼliʼ? ¡Tscaʼtiʼ gaz! ¡Chibidxín dza! ¡Buliʼyútsöcaʼ, Nedaʼ, Bönniʼ Guljëʼ Bönachi, chinadödaʼ lu náʼagaca bönachi dul-laʼ! ");
INSERT INTO zarNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Guliʼchasa, uyéajruʼ! ¡Buliʼyútsöcaʼ, chizë́ʼë bönniʼ naʼ udödëʼ nedaʼ lu náʼagaca bönachi! ");
INSERT INTO zarNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Niʼ ruʼë Jesús didzaʼ ni, bidxinëʼ Judas, bönniʼ nabábalenëʼ chínnuëʼ naʼ dáʼgaquiëʼ Jesús, ateʼ záʼlengaquiëʼ bönniʼ zián lëʼ, nuáʼagaquiëʼ guíë tuchiʼ, en yaga. Yuguʼ bixúz unná bëʼ, en yuguʼ bönniʼ yudoʼ usedi, en bönniʼ gula tuʼzéajniʼinëʼ nasö́l-laʼgaquiëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas, bönniʼ naʼ rudödëʼ Jesús lu náʼagaquiëʼ chinuluíʼinëʼ légaquiëʼ tu le gunëʼ le gaca bëʼ nu naca Jesús, gunnë́ʼ: —Bönniʼ naʼ utsaga lahuaʼ-nëʼ, Lëʼ naʼ Jesús. ¡Guliʼsönëʼ, en guliʼchë́ʼë! ¡Guliʼyútsöquiëʼ! ");
INSERT INTO zarNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Cateʼ bidxinëʼ Judas niʼ, laʼ gubígaʼtëʼ ga naʼ zoëʼ Jesús, en gudxëʼ Lëʼ: —Bönniʼ Usedi, Bönniʼ Usedi. Níʼirö busudxín lahuëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Níʼirö gulaʼzönëʼ Jesús, en gulaʼchë́ʼë Lëʼ nadzunëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Níʼirö tuëʼ bönniʼ niʼ dëʼë Jesús guléajëʼ guíë tuchiʼ, en benëʼ-biʼ huëʼ biʼi huen dxin queëʼ bixúz lo. Guchúguiëʼ guídi nágabiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús gudxëʼ bönachi naʼ, rnnëʼ: —¿Narúajtsaliʼ nuáʼaliʼ guíë tuchiʼ, en yaga para sönliʼ nedaʼ, runliʼ ca runliʼ cateʼ rizönliʼ-nëʼ gubán? ");
INSERT INTO zarNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yuguʼ dza guzóalenaʼ libíʼiliʼ rusë́digacadaʼ bönachi ga naca chila yudoʼ, ateʼ bitiʼ guzxönliʼ nedaʼ, pero raca caní para gaca le nazúaj lu guichi láʼayi. ");
INSERT INTO zarNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Níʼirö yúguʼtë bönniʼ usëda queëʼ Jesús buluʼcáʼanëʼ Leʼ, taʼzxúnnajëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Zóabiʼ caʼ niʼ tubiʼ biʼi raʼbán söjnobiʼ Jesús, nuxóasö cuinbiʼ tu lariʼ blagaʼ. Yuguʼ bönniʼ naʼ nachë́ʼgaquiëʼ Jesús gulaʼzönëʼ-biʼ ");
INSERT INTO zarNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","pero busanbiʼ lariʼ naʼ, en xiguídisöbiʼ buzxúnnajbiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Gulaʼchë́ʼë Jesús lahuëʼ bixúz lo, ateʼ buluʼdubëʼ niʼ yúguʼtë bixúz unná bëʼ, en bönniʼ gula tuʼzéajniʼinëʼ, en yuguʼ bönniʼ yudoʼ usedi. ");
INSERT INTO zarNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro yöjnahuëʼ Jesús ziʼtuʼ zíʼtuʼsö, en guyáziëʼ löʼa lidxi bixúz lo naʼ, en gurö́ʼölenëʼ tsözxö́n yuguʼ niʼa nëʼë bixúz lo naʼ, rutsëʼe cuinëʼ raʼ guíʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Yuguʼ bixúz unná bëʼ len yúguʼtë bönniʼ yúlahuiʼ lo buluʼguiljëʼ tu le uluʼsubáguiëʼ Jesús para gaca ilaʼchúguiëʼ queëʼ gátiëʼ pero bitiʼ bi buluʼdzö́linëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bönniʼ zián gulaʼnnë́ʼ queëʼ Jesús le cabí nácatë, pero bitiʼ yöjlö́zagaca le gulaʼnnë́ʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Níʼirö gulaʼzuínëʼ yuguʼ bönniʼ gulaʼnnë́ʼ queëʼ Jesús le cabí nácatë, taʼnnë́ʼ: ");
INSERT INTO zarNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Netuʼ biyö́nituʼ didzaʼ bëʼë bönniʼ ni, gunnë́ʼ: “Uquínnajaʼ yudoʼ ni, lë ni nequi lu niʼa lu naʼ bönachi, ateʼ tsonna dzasö uchisaʼ iaʼtú le cabí nequi lu niʼa lu naʼ bönachi.” ");
INSERT INTO zarNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Lëscaʼ lë ni, bitiʼ yöjlö́zagaca xtídzaʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Níʼirö guyasëʼ bixúz lo naʼ gatsaj láhuiʼlö bönachi nacuáʼ niʼ, en gunábinëʼ Jesús, rnnëʼ: —¿Naruʼ cabí rubiʼitsoʼ didzaʼ? ¿Bizxi naʼ taʼnnë́ʼ quiuʼ bönniʼ ni? ");
INSERT INTO zarNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús, dxisö zoëʼ. Bitiʼ bi didzaʼ rubiʼë. Gunábinëʼ Lëʼ leyúbölö bixúz lo naʼ, rnnëʼ: —¿Naruʼ nacuʼ Liʼ Cristo, Zxíʼinëʼ Dios Láʼayi? ");
INSERT INTO zarNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Bubiʼë didzaʼ Jesús, rnnëʼ: —Nacaʼ. Iléʼeliʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, soaʼ cöʼa cuitëʼ ibëla Dios napa cazëʼ yöl-laʼ huáca cateʼ niʼ huödaʼ lu böaj lúzxiba. ");
INSERT INTO zarNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Níʼirö bixúz lo naʼ, lu yöl-laʼ rilé queëʼ guchözëʼ lariʼ nácuëʼ, rnnëʼ: —¿Núzxirö naquíniruʼ nu quixjöʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","¡Riyö́n quéziliʼ rucáʼanëʼ Dios cáʼasö len didzaʼ ruʼë! ¿Nacxi rusácaʼliʼ queë́liʼ? Yúguʼtëʼ gulaʼchúguiëʼ queëʼ gátiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Níʼirö gulaʼsí lógaquiëʼ bal-lëʼ tuʼchejëʼ Jesús zxönaʼ. Buluʼsayjëʼ lahuëʼ, en gulundëʼ Lëʼ ziʼ, taʼnnë́ʼ: —Gunnë́ yáʼatsöcaʼ nuzxi naʼ bëʼ Liʼ. Yuguʼ bönniʼ niʼa nëʼë bixúz lo gulaʼgápëʼë ruʼë Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Cateʼ niʼ zoëʼ Pedro löʼa zxan yuʼu, bidxinbiʼ tubiʼ biʼi nigula huen dxin queëʼ bixúz lo naʼ ga naʼ zoëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Cateʼ biléʼebiʼ Pedro, röʼë rutsëʼe cuinëʼ raʼ guíʼ, buyubiʼ lëʼ, rnnabiʼ: —Doʼo caʼ liʼ Jesús, bönniʼ Nazaret naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Gudáʼbaguiëʼ Pedro, rnnëʼ: —Bitiʼ núnbëʼa-nëʼ, en bitiʼ nözdaʼ bizxi naʼ rnnoʼ. Burúajëʼ Pedro yöjsóëʼ ga nu riyaza löʼa. Níʼirö gurö́dxibaʼ böra. ");
INSERT INTO zarNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Buyubiʼ lëʼ leyúbölö biʼi nigula huen dxin naʼ, en gusí lobiʼ rëbiʼ nupa nacuáʼ niʼ: —Bönniʼ ni dzáguiëʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Leyúbölö gudáʼbaguiëʼ Pedro. Iaʼlatiʼ gudzé nupa nacuáʼ niʼ të Pedro, taʼnná: —Le nácatë dzaguʼ légaquiëʼ, tuʼ nacuʼ bönniʼ Galilea. Yöl-laʼ ruíʼisö quiuʼ didzaʼ naca bëʼu, tuʼ tuz ca ruíʼiliʼ didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Gusí lahuëʼ Pedro rudxía döʼ cuinëʼ, en ruzötjëʼ Dios, rnnëʼ: —Bitiʼ caʼ núnbëʼa-nëʼ bönniʼ naʼ ruíʼiliʼ didzaʼ ca naca queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Laʼ gurö́dxitëbaʼ böra le buropi luzuí. Níʼirö yöjnenëʼ Pedro didzaʼ naʼ bëʼë Jesús, gudxëʼ lëʼ: “Ziʼalö cö́dxibaʼ böra le buropi luzuí, tsonna luzuí innóʼ bitiʼ núnbëʼu nedaʼ.” Cateʼ yöjnenëʼ didzaʼ ni, gusí lahuëʼ ribö́dxidëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Niʼ naca zíladoʼ, yuguʼ bixúz unná bëʼ len bönniʼ gula tuʼzéajniʼinëʼ, en yuguʼ bönniʼ yudoʼ usedi, en yúguʼtë bönniʼ yúlahuiʼ lo gulún xtídzaʼgaquiëʼ. Níʼirö gulaʼchë́ʼë Jesús náguëʼë, en buluʼdödëʼ Lëʼ lu nëʼë Pilato, bönniʼ rinná bëʼë uláz que yödz Roma. ");
INSERT INTO zarNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato gunábinëʼ Jesús, rnnëʼ: —¿Naruʼ nacuʼ Liʼ Bönniʼ inná béʼenëʼ bönachi judío? Bubiʼë didzaʼ Jesús, rnnëʼ: —Ca nácatë rnnoʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Yuguʼ bixúz unná bëʼ buluʼzéguiëʼ Jesús didzaʼ le zián. ");
INSERT INTO zarNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Níʼirö Pilato gunábinëʼ Lëʼ leyúbölö, rnnëʼ: —¿Naruʼ cabí rubiʼitsoʼ didzaʼ? Buzë́tsöcaʼ naguʼ cateʼ xö zián le taʼnnë́ʼ quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bitiʼ bi didzaʼ bubiʼë Jesús. Caʼ guca, bubáninëʼ Pilato. ");
INSERT INTO zarNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Dë tu le runëʼ Pilato cateʼ raca laní naʼ, rusanëʼ lu náʼagaca bönachi tu bönniʼ nadzunëʼ lidxi guíë, nútiʼtës nu taʼnaba. ");
INSERT INTO zarNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nadzunëʼ tu bönniʼ lëʼ Barrabás lidxi guíë, ateʼ dzágagaquiëʼ lëʼ iaʼbal-lëʼ luzë́ʼë, yuguʼ bönniʼ gulútiëʼ bönachi cateʼ gulaʼdáʼbáguiëʼ yúlahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Cateʼ bilaʼdxín bönachi zián niʼ, gulaʼsí lógaquiëʼ taʼnabëʼ lahuëʼ Pilato gunëʼ quégaquiëʼ ca run cazëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bubiʼë didzaʼ Pilato, rnnëʼ: —¿Rë́ʼëniliʼ usanaʼ-nëʼ queë́liʼ Bönniʼ Inná Béʼenëʼ Bönachi Judío? ");
INSERT INTO zarNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Caní gunnë́ʼ Pilato tuʼ réquibeʼenëʼ buluʼdödëʼ yuguʼ bixúz unná bëʼ Jesús lu nëʼë tuʼ tuʼzxéʼenëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Yuguʼ bixúz unná bëʼ naʼ gulaʼguʼë xilá ládxiʼgaca bönachi zián naʼ, para ilaʼnabëʼ lahuëʼ Pilato usanëʼ lu náʼagaquiëʼ Barrabás. ");
INSERT INTO zarNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Níʼirö Pilato gunábinëʼ légaquiëʼ leyúbölö, rnnëʼ: —¿Bizxi rë́ʼëniliʼ gunaʼ queëʼ bönniʼ naʼ ruíʼiliʼ lëʼ, Bönniʼ Inná Béʼenëʼ Bönachi Judío? ");
INSERT INTO zarNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Guluʼë zidzaj didzaʼ, taʼnnë́ʼ: —¡Budë́ʼë lëʼe yaga cruz! ");
INSERT INTO zarNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Gunábinëʼ Pilato légaquiëʼ, rnnëʼ: —¿Bizxi caz döʼ nuʼë? Leyúbölö tuʼë zidzaj didzaʼ, taʼnnë́ʼ: —¡Budë́ʼë lëʼe yaga cruz! ");
INSERT INTO zarNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tuʼ gúʼunnëʼ Pilato gunëʼ ga ilaʼyaza ládxiʼgaca bönachi zián naʼ, busanëʼ Barrabás lu náʼagaquiëʼ. Níʼirö gunná béʼenëʼ nu quin Jesús, ateʼ budödëʼ Lëʼ lu náʼagaquiëʼ bönniʼ uluʼdë́ʼë Lëʼ lëʼe yaga cruz. ");
INSERT INTO zarNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Níʼirö yuguʼ bönniʼ röjáquiëʼ gudil-la gulaʼchë́ʼë Jesús löʼa yúlahuiʼ, ateʼ buluʼtubëʼ luzáʼagaquiëʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Buluʼgácuëʼ Jesús tu lariʼ xiná gul-la, en gulunëʼ tu breguiʼ niʼa nëʼe yötsiʼ, le buluʼdxíëʼ icjëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Níʼirö gulaʼsí lógaquiëʼ tuʼlidzëʼ Jesús, taʼnnë́ʼ: —¡Yöl-laʼ ba liʼ, rinná béʼenuʼ bönachi judío! ");
INSERT INTO zarNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Gulaʼguínëʼ gui icjëʼ, en buluʼchejëʼ Lëʼ zxönaʼ. Buluʼzóa zxíbigaquiëʼ lahuëʼ, en lu yöl-laʼ rutitaj gulunëʼ Lëʼ bal. ");
INSERT INTO zarNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Cateʼ budxi buluʼtitjëʼ Lëʼ, buluʼgǘëʼ lariʼ xiná chul-la naʼ nácuëʼ ateʼ buluʼgácuëʼ Lëʼ lariʼ que cazëʼ. Níʼirö gulaʼchë́ʼë Lëʼ níʼilö yúlahuiʼ naʼ para tsöjdaʼgaquiëʼ Lëʼ lëʼe yaga cruz. ");
INSERT INTO zarNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Gulunëʼ ga biʼë tu bönniʼ Cirene yaga cruz queëʼ Jesús, ridö́disëʼ niʼ suzë́ʼë laʼ guixiʼ. Lëʼ Simón, xúzgacabiʼ Alejandro, en Rufo. ");
INSERT INTO zarNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Gulaʼchë́ʼë Jesús lataj naʼ nazíʼi le Gólgota, tu didzaʼ hebreo le rnna lu didzaʼ xidzaʼ, Lataj Que Bögaʼ Ícjaruʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Guluʼë le guíʼjëʼ Jesús xisi uva nutsiʼ nöri siláʼ que yaga mirra, pero Lëʼ bitiʼ guʼë le. ");
INSERT INTO zarNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Níʼirö buluʼdë́ʼë Jesús lëʼe yaga cruz, ateʼ gulaʼguísiëʼ lariʼ nácuëʼ, le gulaʼzíʼ que queë́gaquiëʼ bönniʼ naʼ röjáquiëʼ gudil-la. Buluʼbéajëʼ le gaca bëʼ para ilaʼnö́zinëʼ bízxilö idelaʼ que queë́gaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Naca idú xsila cateʼ buluʼdë́ʼë Lëʼ lëʼe yaga cruz. ");
INSERT INTO zarNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Didzaʼ naʼ buluʼzóëʼ lëʼe yaga cruz ícjalëʼ Jesús ca naca le tuʼquíëʼ Lëʼ rnna caní: “Bönniʼ Rinná Béʼenëʼ Bönachi Judío.” ");
INSERT INTO zarNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Buluʼdáʼlenëʼ Jesús tsözxö́n lë́ʼegaca yaga cruz chopëʼ gubán, tuëʼ cuita lëʼë ibëla, en iaʼtúëʼ cuita lëʼë yö́göla. ");
INSERT INTO zarNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Caní guca lë naʼ nazúaj lu guichi láʼayi, rnna: Gubábalenëʼ bönniʼ tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Yuguʼ bönniʼ taʼdödëʼ niʼ tuʼlidza ziʼë Jesús, en tuʼtá ícjagaquiëʼ, taʼnnë́ʼ: —¡Ön! ¿Naruʼ uquínnajtsoʼ yudoʼ queëʼ Dios, ateʼ tsonna dzasö uchísatsuʼ le? ");
INSERT INTO zarNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Busölá cuinuʼ naʼa, en bötaj lëʼe yaga cruz naʼ! ");
INSERT INTO zarNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Lëscaʼ caní yuguʼ bixúz unná bëʼ, en yuguʼ bönniʼ yudoʼ usedi tuʼtitjëʼ Lëʼ. Tëʼ luzáʼagaquiëʼ tuëʼ iaʼtúëʼ: —Bönachi yúbölö busölë́ʼ, pero bitiʼ gaca usölá cuinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Taʼnnë́ʼ caʼ: —¡Ön! ¿Nácatsuʼ Cristo, Bönniʼ Inná Béʼenëʼ Bönachi Israel? ¡Bö́tjatsöcaʼ naʼa lëʼe yaga cruz para iléʼetuʼ, ateʼ tséajlëʼëtuʼ Liʼ! Yuguʼ bönniʼ naʼ dáʼgaquiëʼ tsözxö́n len Lëʼ lë́ʼegaca yaga cruz buluʼlidza ziʼë caʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Cateʼ bidxín idú huagubidza, guchul-la idútë yödzölió. Guca caní ga bidxintë idú ridödi xihuö́. ");
INSERT INTO zarNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Idú ridödi xihuö́ naʼ bëʼë Jesús zidzaj didzaʼ, rnnëʼ: —Eloi, Eloi, ¿lama sabactani? Didzaʼ hebreo ni rnna lu didzaʼ xidzaʼ: Dios quiaʼ, Dios quiaʼ, ¿bizx que nubéaj ládxuʼu nedaʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Yuguʼ bönniʼ nacuʼë niʼ bilaʼyönnëʼ didzaʼ ni, ateʼ taʼnnë́ʼ: —Buliʼzë́tsöcaʼ nágaliʼ. Elías rulidzëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Níʼirö guxítiʼë tu bönniʼ nútsëʼë ládjagaquiëʼ, en buxúpinëʼ nupi zi tu le bululu rëʼaj nisa. Budë́ʼë le lahui gui, en bëʼë le xupëʼ Jesús, rnnëʼ: —Cö́ztsöcaʼruʼ, uyuruʼ channö huidëʼ Elías uzötjëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Gurö́dxiʼë zidzaj Jesús, en laʼ gútitëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Birözaʼ lariʼ yödx nalaʼ lu yudoʼ. Birúaj choplö, gudelaʼ icjlö, en birúajtë zxánilö. ");
INSERT INTO zarNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Bönniʼ naʼ rinná béʼenëʼ bönniʼ röjáquiëʼ gudil-la zuínëʼ lahuëʼ Jesús, en biléʼenëʼ ca naʼ guca gurö́dxiʼë Jesús, en laʼ gútitëʼ, ateʼ gunnë́ʼ: —Le nácatë bönniʼ ni gúquiëʼ Zxíʼinëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nacuáʼanu caʼ niʼ nigula, zíʼtuʼsö tuʼyunu. Nútsaʼgacanu ládjagacanu María Magdalena, en Salomé, en María, xináʼagacabiʼ Jacobo cuidiʼ, en José. ");
INSERT INTO zarNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nigula ni yöjácalennu Jesús cateʼ niʼ gudë́ʼ luyú Galilea, en gulácalennu Lëʼ, gulaʼgúʼunu le gulahuëʼ. Nacuáʼanu caʼ niʼ iaʼbál-lanu nigula zián gulaʼzáʼlennu Lëʼ lu yödzö Jerusalén. ");
INSERT INTO zarNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Chizáʼ ral-la, en naca dza tuʼpë́ʼë, dza siʼ idxín dza láʼayi quégaquiëʼ bönniʼ judío. ");
INSERT INTO zarNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Que lë ni naʼ bidëʼ José, bönniʼ yödzö Arimatea, bönniʼ lo ládjagaquiëʼ bönniʼ yúlahuiʼ lo. Ribözëʼ caʼ dza idinná bëʼë Dios. Idú ládxëʼë guyáziëʼ ga naʼ zoëʼ Pilato, en gunábinëʼ lëʼ guʼë lëʼ lataj uʼë Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bubáninëʼ Pilato tuʼ gunnë́ʼ chigútiëʼ Jesús, ateʼ bulidzëʼ bönniʼ naʼ rinná béʼenëʼ bönniʼ röjáquiëʼ gudil-la para inábinëʼ lëʼ channö chinátiëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Cateʼ biyönnëʼ ca naʼ gunnë́ʼ bönniʼ naʼ rinná béʼenëʼ bönniʼ röjáquiëʼ gudil-la, bëʼë José lataj uʼë Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Níʼirö José naʼ gúʼuëʼ tu lariʼ xtila dxíʼadoʼ, ateʼ buzötjëʼ Jesús lëʼe yaga cruz, en buchö́linëʼ Lëʼ lariʼ naʼ. Níʼirö guluʼë Lëʼ yeru ba nadaj lëʼe guíʼa guiö́j. Budë́ʼë tu guiö́j blaga zxön ga nu riyaza ba naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena, en María, xinë́ʼë José tuʼyunu ga naʼ taʼguʼë Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Cateʼ chinadödi dza láʼayi quégaca bönachi judío le naca dza gadxi, María Magdalena, en Salomé, en María, xinë́ʼë Jacobo, taʼzíʼinu yuguʼ le riláʼ zxixi para tsöjlúʼugacanu Jesús. ");
INSERT INTO zarNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Niʼ naca zíladoʼ dza risí lo, yöjácanu raʼ yeru ba queëʼ. Bilaʼdxinnu niʼ cateʼ siʼ gulén gubidza. ");
INSERT INTO zarNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Gulaʼnábinu luzáʼagacanu: —¿Nuzxi cúatsö queë́ruʼ guiö́j naʼ daʼ ga nu riyaza ba queëʼ? ");
INSERT INTO zarNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Cateʼ bilaʼdxinnu niʼ, buluʼyunu, en bilaʼléʼenu chinadúa guiö́j naʼ, ateʼ guiö́j zxön naca. ");
INSERT INTO zarNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Gulaʼyúʼunu yeru ba lëʼe guíʼa guiö́j naʼ, ateʼ niʼ bilaʼléʼenu-biʼ tubiʼ biʼi bönniʼ raʼbán, nácabiʼ gubáz láʼayi queëʼ Dios. Rö́ʼöbiʼ tsöláʼa ibëla lu yeru ba naʼ, nácubiʼ lariʼ tunna chiguíchidoʼos. Guládxideʼenu. ");
INSERT INTO zarNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Níʼirö biʼi naʼ gúdxibiʼ légacanu, rnnabiʼ: —Bítiʼrö gádxiliʼ. Ruguílajliʼ Jesús, Bönniʼ Nazaret, Bönniʼ naʼ gudë́ʼë lëʼe yaga cruz. Chibubanëʼ. Bitiʼ zoëʼ ni. Buliʼyú ga ni gulaʼguʼë Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Guliʼtséaj naʼa, guliʼtsöjtíxjöiʼi caʼ yuguʼ bönniʼ usëda queëʼ, encaʼ Pedro. Guië́liʼ légaquiëʼ: “Tsejëʼ Jesús luyú Galilea zíʼalö ca libíʼiliʼ. Niʼ uléʼeliʼ-nëʼ ca naʼ chigudxi cazëʼ libíʼiliʼ.” ");
INSERT INTO zarNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Níʼirö buluʼrúajnu niʼ, buluʼzxúnnajnu raʼ yeru ba naʼ tuʼ taʼzxízinu lu yöl-laʼ radxi ridzöbi quégacanu. Cuntu nu gulënu caʼ tuʼ tádxinu. ");
INSERT INTO zarNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Cateʼ bubanëʼ Jesús zíladoʼ dza naʼ, buluíʼi lahuëʼ zíʼalö lonu María Magdalena, nigula naʼ bubéajëʼ gadxi böʼ xihuiʼ gulaʼyúʼu lënu. ");
INSERT INTO zarNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Guyéajnu yöjtíxjöiʼinu nupa naʼ gulaʼdalen Jesús. Nupa ni taʼsëbi ládxiʼgaca, en taʼbödxi yechiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Cateʼ bilaʼyöni didzaʼ ruíʼinu, zoëʼ nabanëʼ Jesús, ateʼ biléʼe quézinu Lëʼ, bitiʼ gulaʼyéajlëʼ lënu. ");
INSERT INTO zarNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Gudödi naʼ, nadzáʼalö buluíʼi lahuëʼ Jesús lógaquiëʼ chopëʼ bönniʼ usëda queëʼ yúʼugaquiëʼ nöza, söjáquiëʼ ga naca ladaj guixiʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Níʼirö buluʼdxinëʼ, dutíxjöiʼiguequinëʼ iaʼzícaʼrëʼ, ateʼ ni xtídzaʼgaquiëʼ bitiʼ gulaʼyéajlëʼë. ");
INSERT INTO zarNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ga yöjsetë, buluíʼi lahuëʼ Jesús lógaquiëʼ idxinéajtëʼ tsanni niʼ taʼböʼë tahuëʼ, ateʼ gudil-lëʼ légaquiëʼ didzaʼ tuʼ cabí taʼyéajlëʼë Lëʼ, en tuʼ naca zidi icja ládxiʼdoʼgaquiëʼ, tuʼ cabí gulaʼyéajlëʼë xtídzaʼgaca nupa naʼ bilaʼléʼe Lëʼ nubanëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Níʼirö gudxëʼ légaquiëʼ, rnnëʼ: —Guliʼtséaj idútë yödzölió tsöjenliʼ libán que didzaʼ dxiʼa lógaca yúguʼtë bönachi. ");
INSERT INTO zarNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nu tséajlëʼ nedaʼ, en idila nisa, ulá nu naʼ, pero nu bitiʼ tséajlëʼ, irugu que gati nu naʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Le ilaca bëʼ ni ilunëʼ bönniʼ ilaʼyéajlëʼë nedaʼ. Uluʼgunëʼ dxin Laʼ nedaʼ, en uluʼbéajëʼ yuguʼ böʼ xihuiʼ yúʼugaca bönachi, en iluʼë didzaʼ izáʼa. ");
INSERT INTO zarNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Channö ilaʼzönëʼ-baʼ bëla síniaʼ lu náʼagaquiëʼ, o channö ileʼjëʼ le nachë́ʼ yöl-laʼ guti, bitiʼ bi gun quégaquiëʼ. Ilaʼxóa nëʼë nupa teʼe, ateʼ uluʼhuöácatë. ");
INSERT INTO zarNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Cateʼ Xanruʼ budxi bë́ʼlenëʼ légaquiëʼ didzaʼ ni, buchisëʼ Dios Lëʼ yehuaʼ yubá ga niʼ guröʼë cuitëʼ ibëla Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bilaʼrúajëʼ légaquiëʼ, yöjéngaquiëʼ libán yúguʼtë yödzö. Gúcalenëʼ Xanruʼ légaquiëʼ, en benëʼ ga gulunëʼ le nácagaca bëʼ naca idútë li didzaʼ tuʼë. Caʼ naca.");
INSERT INTO zarNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Zián nupa chigulún bayudxi uluʼzúaj lu guichi idútë le nácatë, le guca ga zóaruʼ, ");
INSERT INTO zarNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ca naʼ bilaʼléʼe nupa niʼ dza niʼte, ateʼ buluʼluíʼi rëʼu, en buluʼzë́ didzaʼ que. ");
INSERT INTO zarNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Teófilo, bönniʼ tsáhuiʼdoʼ, runi nedaʼ naca dxiʼa uzúajaʼ quiuʼ lu guichi, ga ze lo dzöʼ yúguʼtë lë ni, tuʼ chibuguílaj bubéquiaʼ ga ze lo dzöʼ ca naca yúguʼtë lë naʼ guca dza niʼte. ");
INSERT INTO zarNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ruzúajaʼ quiuʼ lu guichi ni para inö́zinuʼ naca idútë li lë naʼ chinazëduʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Dza niʼte cateʼ gunná bëʼë Herodes luyú Judea, niʼ zoëʼ tu bixúz lëʼ Zacarías. Nabábalenëʼ cöʼ bixúz, nazíʼi le Cöʼ Queëʼ Abías. Elisabet, nigula queëʼ Zacarías naʼ nácanu caʼ zxíʼini xiʼsóëʼ Aarón, bönniʼ gúquiëʼ bixúz lo dza niʼte. ");
INSERT INTO zarNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nácagaquiëʼ Zacarías, en Elisabet tsahuiʼ lahuëʼ Dios, ateʼ idú ládxiʼgaquiëʼ tunëʼ ca rnna xtídzëʼë Dios, en le rinná bëʼ xibá queëʼ. Caní guca, cuntu nu guca bi innë́ quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Cuntu nu zoa biʼi quégaquiëʼ, tuʼ nácanu Elisabet nigula huödx, ateʼ chinagúlagaquiëʼ irópatëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Guca beoʼ gul-laʼ uláz que cöʼ naʼ nabábalenëʼ Zacarías ilunëʼ dxin lahuëʼ Dios, lu yöl-laʼ bixúz quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ca naca le nulaga lógaquiëʼ tunëʼ bixúz, gul-laʼ uláz queëʼ Zacarías guyáziëʼ lu lataj láʼayi que yudoʼ para uzéguiʼë yalaj lahuëʼ Xanruʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tsanni niʼ ruzéguiʼë Zacarías naʼ yalaj, gulaʼcuáʼ yúguʼtë bönachi níʼilö, tuʼlidza Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Laʼ náʼasö buluíʼi lahuëʼ gubáz láʼayi queëʼ Xanruʼ ga zoëʼ Zacarías naʼ. Zuínëʼ gubáz naʼ tsöláʼa ibëla bucugu láʼayi ga naʼ régui yalaj. ");
INSERT INTO zarNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Cateʼ biléʼenëʼ Zacarías gubáz láʼayi naʼ, guröʼë böniga, en gudxi bidzö́binëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Níʼirö gubáz láʼayi naʼ gudxëʼ lëʼ, gunnë́ʼ: —Zacarías, bitiʼ gádxinuʼ, tuʼ chibiyönnëʼ Dios le rinabuʼ lahuëʼ, ateʼ Elisabet, nigula quiuʼ, uzóanu-biʼ tubiʼ biʼi bö́nniʼdoʼ, ateʼ guʼu labiʼ Juan. ");
INSERT INTO zarNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Gataʼ quiuʼ le uziʼu xibé, en udzéjanuʼ, ateʼ zián nupa uluʼdzeja ládxiʼgaca cateʼ gálajbiʼ bíʼidoʼ naʼ, ");
INSERT INTO zarNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","tuʼ gácatëbiʼ zxön lahuëʼ Dios. Bitiʼ guíʼajbiʼ xisi uva, en calëga tu le rusudxi bönachi, ateʼ sóalenëʼ-biʼ Dios Böʼ Láʼayi cateʼ isí lo siʼ gálajbiʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Gunëʼ Juan ni ga uluʼhuöáca zián bönachi Israel queëʼ Xanruʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Inö́ruëʼ lëʼ ca Xanruʼ, ateʼ ilaʼcuáʼalen lëʼ Böʼ naʼ, en yöl-laʼ huáca naʼ gulaʼcuáʼalen Elías, bönniʼ bëʼë didzaʼ uláz queëʼ Dios dza niʼte. Caní gunëʼ para únëʼ tuz nupa nácagaca xuz len zxíʼinigaquiëʼ, en uzéajniʼinëʼ nupa taʼdáʼbagaʼ para ilácagaca tsahuiʼ, en ucözëʼ bönachi para ilaʼzíʼ lu në́ʼeguequi Xanruʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías gunábinëʼ gubáz láʼayi naʼ, rnnëʼ: —¿Bizxi gaca bëʼ para inözdaʼ ilaca lë ni? Chinagúlaʼ nedaʼ, en chinagúlanu caʼ nigula quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Bubiʼë didzaʼ gubáz láʼayi naʼ, rnnëʼ: —Nedaʼ leaʼ Gabriel. Runaʼ dxin lahuëʼ Dios. Lë cazëʼ gusö́l-lëʼë nedaʼ para güíʼilenaʼ liʼ didzaʼ, en usiyöndaʼ liʼ didzaʼ dxiʼa ni. ");
INSERT INTO zarNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Naʼa, tuʼ cabí guyéajlëʼu xtídzaʼa, icödzuʼ, en bítiʼrö gaca innóʼ cateʼ gácarö lë ni. Yúguʼtë lë ni udxín cateʼ idxín dza que. ");
INSERT INTO zarNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tsanni niʼ raca lë ni, nacuáʼ bönachi níʼilö, taʼböza Zacarías, ateʼ tuʼbani tuʼ ridzenëʼ xidzé ga naʼ zoëʼ lu lataj láʼayi. ");
INSERT INTO zarNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Cateʼ burúajëʼ Zacarías, bitiʼ guca güíʼilenëʼ légaquiëʼ didzaʼ, ateʼ guléquibeʼenëʼ biléʼenëʼ tu le buluíʼinëʼ Dios lëʼ lu lataj láʼayi. Buláʼa buluíʼisëʼ Zacarías, buzéajniʼinëʼ légaquiëʼ, tuʼ cabí raca innë́ʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Cateʼ bizáʼa yuguʼ dza naʼ ral-laʼ gunëʼ dxin Zacarías lahuëʼ Dios, níʼirö bö́ajëʼ lidxëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Gudödi yuguʼ dza naʼ Elisabet, nigula queëʼ Zacarías naʼ, biáʼanu-biʼ lë́ʼënu bíʼidoʼ, ateʼ idú gayuʼ beoʼ bugáʼanasinu ga zoa lídxigaquiëʼ. Guzáʼ ládxiʼnu, rnnanu: ");
INSERT INTO zarNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Caní runëʼ Xanruʼ quiaʼ. Ruzáʼ ládxëʼë quiaʼ bíʼidoʼ, en runëʼ ga bítiʼrö utuíʼidaʼ lógaca bönachi.” ");
INSERT INTO zarNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Cateʼ chiguca xopa beoʼ, buluíʼi lahuëʼ gubáz láʼayi naʼ, tuʼ gusö́l-lëʼë Dios lë cazëʼ Gabriel, tsejëʼ Nazaret, tu yödzö luyú Galilea. ");
INSERT INTO zarNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Dios gusö́l-lëʼë lëʼ niʼ tsöjyúëʼ-biʼ tubiʼ biʼi nigula raʼbandoʼ lëbiʼ María. Chinazíʼ lu náʼabiʼ María utsaga náʼalenbiʼ-nëʼ bönniʼ lëʼ José. Nababëʼ José diʼa dza queëʼ David, bönniʼ gunná béʼenëʼ bönachi Israel dza niʼte. ");
INSERT INTO zarNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Cateʼ guyáziëʼ Gabriel naʼ ga zóabiʼ María, gudxëʼ-biʼ: —Padiux. Dios ruzáʼ ládxëʼë quiuʼ. Xanruʼ Dios zóalenëʼ liʼ. Lë cazëʼ benëʼ ga nácaruʼ liʼ bicaʼ ba ca yúguʼtë nigula. ");
INSERT INTO zarNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Cateʼ biléʼebiʼ María gubáz láʼayi naʼ, gurö́ʼöbiʼ böniga tuʼ nözi didzaʼ naʼ bëʼë, en rubani ládxiʼbiʼ nacxi saʼyéaj didzaʼ naʼ bulidzëʼ-biʼ gubáz láʼayi naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Níʼirö gubáz láʼayi naʼ gudxëʼ-biʼ, rnnëʼ: —María, bitiʼ gádxinuʼ, tuʼ chibidéliʼnuʼ le ruzáʼ ládxëʼë Dios quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Naʼa, tsúʼubiʼ tubiʼ bíʼidoʼ lëʼu, ateʼ uzúʼ-biʼ tubiʼ biʼi bö́nniʼdoʼ, ateʼ guʼu labiʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jesús ni tsë́pisëtërëʼ, en siʼ Lëʼ Zxíʼinëʼ Dios, Nu nayë́pisëtërö. Xanruʼ Dios gunëʼ ga inná bëʼë ca naʼ gunná bëʼë David, xuz gula gudödi queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jesús naʼ inná béʼeticaʼsinëʼ bönachi Israel, ateʼ le inná bëʼë Lëʼ catu caz tödi que. ");
INSERT INTO zarNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Níʼirö María gunábibiʼ gubáz láʼayi naʼ, rnnabiʼ: —¿Nacxi caz gaca lë ni, tuʼ cabí zóalenaʼ bönniʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Bubiʼë didzaʼ gubáz láʼayi naʼ, rëʼë-biʼ: —Guidëʼ Dios Böʼ Láʼayi ga zuʼ, ateʼ yöl-laʼ huáca queëʼ Dios, Nu nayë́pisëtërö, sóalen liʼ, le gaca ca tu zxul-la rigúʼu böaj ga zuʼ. Que lë ni naʼ biʼi bö́nniʼdoʼ naʼ ral-laʼ gálajbiʼ, tsúʼubiʼ lu nëʼë Dios, ateʼ siʼ labiʼ Zxíʼinëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Cáʼanqueze Elisabet, nigula diʼa dza quiuʼ, chinuáʼanu-biʼ lë́ʼënu tubiʼ biʼi bö́nniʼdoʼ sal-laʼ chinagúlanu. Gulaʼnnë́ʼ queë́nu: “Nácanu nigula huödx”, pero chizéaj xopa beoʼ nuáʼanu-biʼ lë́ʼënu bíʼidoʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bitiʼ bi zoa le cabí séquiʼnëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Níʼirö María gunabiʼ: —Ni zoaʼ. Tsaz nacaʼ huen dxin queëʼ Xanruʼ. Gaca quiaʼ ca naʼ chigunnóʼ. Níʼirö laʼ buzaʼtëʼ gubáz láʼayi naʼ ga zóabiʼ María. ");
INSERT INTO zarNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Laʼ dza níʼisö guyúʼubiʼ nöza María, ateʼ carelö saʼyéajbiʼ ga naca guíʼadoʼ, en bidxinbiʼ tu yödzö luyú Judea. ");
INSERT INTO zarNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Niʼ guyázabiʼ lidxëʼ Zacarías, en gúdxibiʼ-nu Elisabet: —Padiux. ");
INSERT INTO zarNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Cateʼ biyö́ninu Elisabet didzaʼ naʼ bë́ʼëbiʼ María, laʼ butátë cuinbiʼ biʼi huë́ʼënidoʼ naʼ yúʼubiʼ lë́ʼënu, ateʼ bidisóalenëʼ-nu Dios Böʼ Láʼayi. ");
INSERT INTO zarNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Níʼirö bë́ʼënu Elizabet zidzaj didzaʼ, rnnanu: —¡Chinunëʼ Dios ga nácaruʼ liʼ bicaʼ ba ca yúguʼtë nigula, en chinunëʼ caʼ ga nácabiʼ bicaʼ ba bíʼidoʼ naʼ yúʼubiʼ lëʼu! ");
INSERT INTO zarNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Núzxitë nedaʼ, záʼanu xinë́ʼë Xanaʼ quiaʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Cateʼ biyöndaʼ didzaʼ bëʼu, bulidzuʼ nedaʼ, lu yöl-laʼ rudzeja queë́biʼ laʼ butátë cuinbiʼ biʼi huë́ʼënidoʼ ni yúʼubiʼ lëʼa. ");
INSERT INTO zarNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Bicaʼ ba liʼ tuʼ guyéajlëʼu xtídzëʼë gubáz láʼayi, ateʼ udxín caz lë naʼ gudxëʼ liʼ uláz queëʼ Xanruʼ! ");
INSERT INTO zarNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Níʼirö gunabiʼ María: ¡Idútë le nacaʼ rigúʼu Xanruʼ yöl-laʼ ba, ");
INSERT INTO zarNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","en rudzeja ládxiʼlenaʼ-nëʼ Dios, Nu rusölá nedaʼ! ");
INSERT INTO zarNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","¡Dios caz buzáʼ ládxëʼë quiaʼ nedaʼ! Yuʼa lu nëʼë, en tsaz nacaʼ huen dxin queëʼ. Naʼa isí lo, ca naca quiaʼ ilaʼnná: Bicaʼ ba nigula naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","¡Zxö́ntërö naca le benëʼ Dios unná bëʼ quiaʼ! ¡Láʼayi naca Lëʼ! ");
INSERT INTO zarNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Lëʼ ruhuéchiʼ ládxiʼticaʼsëʼ bönachi tadxi Lëʼ naʼa dza, en dza záʼgaca. ");
INSERT INTO zarNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yuguʼ yöl-laʼ huáca zxön chibenëʼ Lëʼ. Buzötjëʼ nupa gulún zxön yöl-laʼ réajniʼi quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Bugǘëʼ yöl-laʼ unná bëʼ quégaca nupa gulaca lo, en benëʼ ga gulaca lo nupa gulaca nöxaj ladxiʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Benëʼ ga buluʼhuö́laj buluʼdzë́ʼe nupa gulaʼdún, en bucáʼanëʼ cáʼasö nupa bilaʼléʼe yöl-laʼ tsahuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Gúcalenëʼ bönachi Israel, nupa naʼ tun xichinëʼ, tuʼ yöjnenëʼ légaquiëʼ, en buéchiʼ ládxëʼë légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Benëʼ ca guzxíʼ lu nëʼë gunëʼ quégaquiëʼ xuz xtóʼoruʼ encaʼ queëʼ Abraham, en quégaca diʼa dza queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María bugáʼanalenbiʼ-nu Elisabet idú ca tsonna beoʼ, ateʼ gudödi niʼ bö́ajbiʼ lídxibiʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Cateʼ bidxín dza ral-laʼ sóabiʼ bíʼidoʼ queë́nu Elisabet, buzóanu-biʼ tubiʼ biʼi bö́nniʼdoʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bilaʼyöni dzaga yuʼu queë́nu, en yuguʼ diʼa dza queë́nu ca naʼ guca, buéchiʼ ládxëʼë-nu Dios, ateʼ buluʼdzéjalen lënu. ");
INSERT INTO zarNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Cateʼ chiguca xunuʼ dza zóabiʼ bíʼidoʼ naʼ, bilaʼdxinëʼ diʼa dza queë́nu para ilaʼchúguiëʼ lu xipë́laʼbiʼ biʼi bö́nniʼdoʼ naʼ lë naʼ gaca bëʼ néquibiʼ queëʼ Dios, ateʼ të́ʼënnëʼ iluʼë labiʼ Zacarías ca naʼ lëʼ xúzibiʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Níʼirö bubíʼinu didzaʼ Elisabet, xináʼabiʼ, rnnanu: —Calëga. Juan siʼ labiʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Gulaʼnábinëʼ-nu, taʼnnë́ʼ: —¿Bizx que? Cuntu nu diʼa dza quiuʼ lëʼ Juan. ");
INSERT INTO zarNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Níʼirö buluʼláʼ buluʼluíʼisinëʼ, gulaʼnábinëʼ xúzibiʼ nacxi rë́ʼënëʼ guʼë labiʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zacarías naʼ gunabëʼ tu blágadoʼ, ateʼ buzúajëʼ lahui caní: Juan lëbiʼ. Buluʼbáninëʼ yúguʼtëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Laʼ níʼisö böáljatë ruʼë Zacarías naʼ, en buguítjatë lúdxëʼë, ateʼ bëʼë didzaʼ le guluʼë Dios yöl-laʼ ba. ");
INSERT INTO zarNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Níʼirö guládxinëʼ, en buluʼbáninëʼ yúguʼtë dzaga yuʼu quégaquiëʼ, ateʼ yúguʼtë yö́dzödoʼ nacuáʼ lu guíʼadoʼ luyú Judea, guzë́ didzaʼ ca guca lë ni. ");
INSERT INTO zarNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Gulaʼzáʼ ládxiʼgaca yúguʼtë nupa bilaʼyöni ca naʼ guca, taʼnná: “¿Nacxi caz gácabiʼ biʼi bö́nniʼdoʼ ni? Le nácatë Xanruʼ zóalenëʼ-biʼ.” ");
INSERT INTO zarNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Níʼirö Dios Böʼ Láʼayi bidisóalenëʼ Zacarías, xúzibiʼ Juan, ateʼ bëʼë didzaʼ uláz queëʼ Dios, rnnëʼ: ");
INSERT INTO zarNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","¡Yöl-laʼ ba Dios, Xángaca bönachi Israel tuʼ buduyúëʼ rëʼu, bönachi queëʼ, en böáʼuëʼ rëʼu! ");
INSERT INTO zarNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","¡Gusö́l-lëʼë queë́ruʼ Bönniʼ usölë́ʼ rëʼu, len yöl-laʼ huáca zxön queëʼ! Bönniʼ ni guljëʼ ládajgaca diʼa dza queëʼ David, huen dxin queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","¡Dza niʼte guzxíʼ lu nëʼë gunëʼ ga gaca caní! Raca ca naʼ gunnë́ʼ lu ruáʼagaquiëʼ bönniʼ guluʼë didzaʼ uláz queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Guzxíʼ lu nëʼë usölë́ʼ rëʼu lu náʼagaca nupa tequi rëʼu ziʼ, encaʼ lu náʼagaca nupa bitiʼ taʼléʼe rëʼu dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Guzxíʼ lu nëʼë huéchiʼ ládxëʼë xuz gudödi queë́ruʼ, en tsöjnenëʼ le guzxíʼ lu nëʼë le naca láʼayi. ");
INSERT INTO zarNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Lë ni benëʼ tsutsu xtídzëʼë, en guzxíʼ lu nëʼë, le gunëʼ queëʼ Abraham, xuz gudödi queëruʼ, le naca tu le ral-laʼ gunëʼ queë́ruʼ rëʼu. ");
INSERT INTO zarNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Guzxíʼ lu nëʼë usölë́ʼ rëʼu lu náʼagaca nupa bitiʼ taʼléʼe rëʼu dxiʼa para cabirö gádxiruʼ gunruʼ xichinëʼ Lëʼ, ");
INSERT INTO zarNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","en para gácaruʼ baʼa ladxiʼ, en idú dxiʼa lahuëʼ Lëʼ yúguʼtë dza sóaruʼ ibanruʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Liʼ, zxíʼinaʼdoʼ, siʼ loʼ bönniʼ ruʼë didzaʼ uláz queëʼ Dios unná bëʼ tuʼ tsöjnöruʼ ca Xanruʼ caz, en upóʼo nöza ga tödëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Gunuʼ ga ilaʼnözi bönachi queëʼ ca gaca uluʼlágaca, en ca naʼ uniti lahuëʼ Dios dul-laʼ nabágaʼgaca. ");
INSERT INTO zarNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Caní gaca, tuʼ ruhuéchiʼdaʼ ládxëʼë Dios rëʼu, en runëʼ ga tseníʼ queë́ruʼ Bönniʼ naʼ náquiëʼ beníʼ idú. ");
INSERT INTO zarNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Lëʼ uzeníʼë quégaca nupa nacuáʼ gapa naca chul-la, en gapa nacuáʼ nupa chizóa ilátigaca para ugúʼë rëʼu nöza ga cöʼö dxi ládxiʼdoʼoruʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Guzxönbiʼ biʼi bö́nniʼdoʼ naʼ, en bidipa ládxiʼbiʼ. Guzóasibiʼ gapa naca lu lataj cáʼasö cateʼ bidxinrö dza buluíʼi lobiʼ lógaca bönachi Israel. ");
INSERT INTO zarNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Lu dza naʼ gunná bëʼë Augusto César, bönniʼ Roma, ilaʼyaza lu guichi yúguʼtë bönachi nacuáʼ yödzölió. ");
INSERT INTO zarNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Cateʼ gusí lo taʼyaza lu guichi caní, rinná bëʼë bönniʼ lëʼ Cirenio luyú Siria. ");
INSERT INTO zarNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Yúguʼtë bönachi yöjaca yödzö que queë́guequi ga naʼ zeaj nababa para ilaʼyaza lu guichi. ");
INSERT INTO zarNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Guzë́ʼë José yödzö Nazaret luyú Galilea, saʼyéajëʼ luyú Judea, en bidxinëʼ yödzö Belén, ga niʼ guljëʼ David, tuʼ guljëʼ José ládajgaca diʼa dza queëʼ David naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Guyijëʼ José niʼ para tsáziëʼ lu guichi, ateʼ dzágabiʼ-nëʼ María, biʼi nigula nazíʼ lu náʼabiʼ utsaga náʼalenbiʼ lëʼ, en chizóa sóabiʼ bíʼidoʼ queë́biʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Cateʼ niʼ nacuʼë lu yödzö Belén, bidxín dza sóabiʼ bíʼidoʼ queë́biʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Buzóanu-biʼ tubiʼ biʼi bö́nniʼdoʼ, biʼi huáca queë́nu. Buchö́linu-biʼ yuguʼ láriʼdoʼ, ateʼ gudíxjanu-biʼ tu lu yúʼudoʼ ga tun chiʼi le tágubaʼ böaʼ quégaca bönachi yúʼugaca nöza. Caní guca, tuʼ cabí bidzöli lataj ilaʼcuʼë lu yuʼu ga niʼ taʼdxín bönachi yúʼugaca nöza. ");
INSERT INTO zarNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Galaʼ raʼ yödzö Belén nacuʼë bönniʼ tuʼyúgaquiëʼ-baʼ böʼcuʼ zxilaʼ laʼ guixiʼ, tapa chíʼigaquiëʼ-baʼ chiʼi dzö́ʼölö. ");
INSERT INTO zarNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Laʼ buluíʼitë lahuëʼ gubáz láʼayi queëʼ Xanruʼ ga naʼ nacuʼë. Yöl-laʼ beníʼ queëʼ Xanruʼ buzeníʼ ga naʼ nacuʼë, ateʼ guládxinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Níʼirö gubáz láʼayi naʼ gudxëʼ légaquiëʼ, rnnëʼ: —Bitiʼ gádxiliʼ. Naʼa rusiyöndaʼ libíʼiliʼ didzaʼ le gun ga udzéjadeʼeliʼ, le uluʼzíʼ caʼ xibé yúguʼtë bönachi. ");
INSERT INTO zarNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Naʼa chigúlajbiʼ lu ladzëʼ David Nu usölá libíʼiliʼ. Nu ni naca Cristo, Xanruʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Lë ni gaca bë́ʼëbiʼ. Udzö́liliʼ-biʼ Bíʼidoʼ naʼ, narö́libiʼ yuguʼ láriʼdoʼ, en dëbiʼ tu lu yúʼudoʼ ga tun chiʼi le tágubaʼ böaʼ quégaca bönachi yúʼugaca nöza. ");
INSERT INTO zarNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ga naʼ zoëʼ gubáz láʼayi naʼ, tsálidoʼos buluʼluíʼi lógaquiëʼ ziánrö caʼ gubáz láʼayi queëʼ Dios, narúajgaquiëʼ yehuaʼ yubá, en taʼguʼë Dios yöl-laʼ ba, taʼnnë́ʼ: ");
INSERT INTO zarNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Yöl-laʼ ba Dios zoëʼ xitsáʼ, ateʼ luyú gaca le cuéqui dxi ládxiʼdoʼgaquiëʼ bönniʼ raza ládxëʼë Dios légaquiëʼ! ");
INSERT INTO zarNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Cateʼ buluʼzë́ʼë gubáz láʼayi naʼ ga niʼ nacuʼë, söjhuö́jgaquiëʼ yehuaʼ yubá, níʼirö gulë́ luzë́ʼë tuëʼ iaʼtúëʼ bönniʼ uyú böʼcuʼ zxilaʼ naʼ, taʼnnë́ʼ: —Uyéajtsöcaʼruʼ Belén para iléʼeruʼ lë ni chiguca ca naʼ chibusiyönnëʼ Xanruʼ rëʼu. ");
INSERT INTO zarNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Laʼ yöjácatiëʼ, ateʼ yöjxácaʼgaquiëʼ María len José, encaʼ bíʼidoʼ naʼ, dëbiʼ tu lu yúʼudoʼ ga tun chiʼi le tágubaʼ böaʼ quégaca bönachi yúʼugaca nöza. ");
INSERT INTO zarNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Cateʼ bilaʼléʼenëʼ lëbiʼ, gulaʼguíxjöʼë lë naʼ siʼ busiyönnëʼ gubáz láʼayi naʼ légaquiëʼ ca naca queë́biʼ bíʼidoʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Buluʼbani yúguʼtë nupa bilaʼyöni didzaʼ guluʼë bönniʼ tuʼyúëʼ böʼcuʼ zxilaʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María gulúʼusö icja náganu didzaʼ ni, ateʼ guzáʼ ládxiʼnu ca naca que. ");
INSERT INTO zarNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Söjhuö́jgaquiëʼ bönniʼ naʼ tuʼyúëʼ-baʼ böʼcuʼ zxilaʼ, tunëʼ zxön Dios, en taʼguʼë Lëʼ yöl-laʼ ba niʼa que yúguʼtë lë naʼ bilaʼyönnëʼ, en bilaʼléʼenëʼ, le guca ca naʼ busiyönnëʼ gubáz láʼayi naʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Cateʼ chiguca xunuʼ dza zóabiʼ bíʼidoʼ naʼ, gulaʼchúguiëʼ lu xipë́laʼbiʼ lë naʼ naca bëʼ néquibiʼ queëʼ Dios, ateʼ guluʼë labiʼ Jesús ca naʼ chibë́ʼ cazëʼ labiʼ gubáz láʼayi naʼ zíʼalö cateʼ siʼ tsúʼubiʼ lë́ʼënu xináʼabiʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Cateʼ chibizáʼa dza que le tuʼpáʼa cuíngacanu nigula ca rinná bëʼ xibá queëʼ Moisés, gulaʼchë́ʼë-biʼ bíʼidoʼ Jesús yödzö Jerusalén para ilaʼguʼë-biʼ lu nëʼë Xanruʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Caní gulunëʼ, tuʼ nazúaj lu guichi lu xibá queëʼ Xanruʼ le rnna: “Yúguʼtëbiʼ biʼi bö́nniʼdoʼ nácagacabiʼ biʼi zíʼalö queë́nu xináʼagacabiʼ, uluʼbéajëʼ-biʼ quez queëʼ Xanruʼ Dios.” ");
INSERT INTO zarNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Que lë ni naʼ yöjáquiëʼ niʼ para ilútiëʼ-baʼ, en ilaʼgúʼë-baʼ lahuëʼ Dios chópabaʼ gúgudoʼ o chópabaʼ budöduʼ ca naʼ rinná bëʼ xibá queëʼ Xanruʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Dza níʼisö zoëʼ tu bönniʼ lëʼ Simeón lu yödzö Jerusalén. Bönniʼ ni náquiëʼ tsahuiʼ, en reaj ládxëʼë Dios. Ribözëʼ Bönniʼ naʼ isö́l-lëʼë Dios, Bönniʼ naʼ gácalenëʼ bönachi Israel. Dios Böʼ Láʼayi zóalenëʼ Simeón naʼ, ");
INSERT INTO zarNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","en chibuluíʼinëʼ lëʼ bitiʼ gátiëʼ cateʼ iléʼerönëʼ Cristo, Bönniʼ naʼ isö́l-lëʼë Xanruʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Bidxinëʼ Simeón naʼ chila yudoʼ tuʼ guchë́ʼë Dios Böʼ Láʼayi lëʼ niʼ. Cateʼ xuz xináʼabiʼ gulaʼchë́ʼë-biʼ bíʼidoʼ Jesús chila yudoʼ para ilunëʼ queë́biʼ ca rinná bëʼ xibá naʼ, ");
INSERT INTO zarNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","níʼirö bunidëʼ-biʼ Simeón naʼ, en guyéaj ládxëʼë Dios, rnnëʼ: ");
INSERT INTO zarNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Xanaʼ, naʼa huáca gunnuʼ nedaʼ lataj gátiaʼ, soa dxi ládxaʼa tuʼ chiguca le gudxuʼ nedaʼ, huen dxin quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Chibiléʼedaʼ Nu naʼ buzóa cazuʼ, Nu usölá bönachi, ");
INSERT INTO zarNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nu naʼ ulúʼu lahui lógaca yúguʼtë bönachi. ");
INSERT INTO zarNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Lëbiʼ nácabiʼ beníʼ le uzeníʼ bönachi izáʼa, en nácabiʼ caʼ beníʼ quégaca bönachi Israel quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Buluʼbáninëʼ José, en María, xináʼabiʼ bíʼidoʼ Jesús, ca naca lë naʼ gunnë́ʼ Simeón ca naca queë́biʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeón naʼ gunábinëʼ Dios gunëʼ ga gaca dxiʼa quégaquiëʼ, ateʼ gudxëʼ-nu María, xináʼabiʼ Jesús, rnnëʼ: —Buyútsöcaʼ. Biʼi ni nuzóëʼ-biʼ Dios para gunbiʼ ga ilaʼchixi bönachi zián, ateʼ uluʼhuöása bönachi zián ladaj bönachi Israel. Gácabiʼ tu le naca bëʼ, ateʼ ilaʼnnë́ bönachi queë́biʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Gaca caní para ilaʼláʼ lahui le taʼzáʼ ládxiʼgaca bönachi zián. Yuguʼ lë ni ilaca quiuʼ ca tu guíë tuchiʼ le tsaza ládxiʼdoʼo. ");
INSERT INTO zarNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ana, nigula ruíʼinu didzaʼ uláz queëʼ Dios, zóanu caʼ niʼ. Nácanu zxíʼinëʼ Fanuel, bönniʼ nababëʼ diʼa dza queëʼ Aser. Chinagúladaʼanu Ana naʼ, tuʼ guzóalennu bönniʼ queë́nu idú gadxi iz gudödi gúcanu raʼbandoʼ, ");
INSERT INTO zarNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ateʼ bugáʼananu tuzi cateʼ bidxintë dza chiyúʼunu idú ca tápalalaj yuʼ tapa iz. Bitiʼ caʼ rubíʼi ruzáʼanu ga naca chila yudoʼ. Rëla, en te dza reaj ládxiʼnu-nëʼ Dios, runnu gubasa, en rulídzanu-nëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Laʼ náʼasö bidxíntënu niʼ, rënu-nëʼ Dios: “Xclenuʼ.” Gudíxjöiʼinu yúguʼtë bönachi ca naca queë́biʼ bíʼidoʼ Jesús, bönachi naʼ nacuáʼ Jerusalén, nupa taʼböza dza idxín Nu naʼ isö́l-lëʼë Dios para gácalen bönachi. ");
INSERT INTO zarNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Gudödi gulunëʼ José, en María yúguʼtë le rinná bëʼ xibá queëʼ Xanruʼ Dios, yöjhuö́jgaquiëʼ ládzagaquiëʼ Nazaret luyú Galilea. ");
INSERT INTO zarNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Guzxönbiʼ bíʼidoʼ Jesús, en bidipa ládxiʼbiʼ. Gutaʼ queë́biʼ yöl-laʼ réajniʼi, ateʼ zxön naca le ruzáʼ ládxëʼë queë́biʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yuguʼ iz röjáquiëʼ xuz xináʼabiʼ Jesús Jerusalén cateʼ raca Laní Pascua, laní tuʼsubanëʼ bönniʼ judío ca benëʼ Dios, bubéajëʼ xuz xtóʼogaquiëʼ luyú Egipto. ");
INSERT INTO zarNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Cateʼ chiyúʼubiʼ chinnu iz biʼi Jesús, yöjáquiëʼ Jerusalén ca tun cazëʼ cateʼ raca laní naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Cateʼ gudödi laní, söjhuö́jgaquiëʼ, ateʼ bugáʼanabiʼ bíʼidoʼ Jesús Jerusalén, pero bitiʼ téquibeʼenëʼ José, en María, xináʼabiʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tuʼ téquinëʼ nútsaʼbiʼ ladaj bönachi zián yúʼulengaca légaquiëʼ nöza, tu dza nayáʼ gulaʼzë́ʼë. Níʼirö cateʼ buluʼguiljëʼ-biʼ gapa nacuáʼ diʼa dza quégaquiëʼ, en gapa nacuáʼ nupa núnbëʼgaquiëʼ ");
INSERT INTO zarNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","bitiʼ buluʼdzö́linëʼ-biʼ. Que lë ni naʼ yöjhuö́jgaquiëʼ Jerusalén, söjdíljagaquiëʼ-biʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Cateʼ chiguca dza bunni, buluʼdzö́linëʼ-biʼ ga naca chila yudoʼ, rö́ʼöbiʼ gatsaj láhuiʼlëʼ bönniʼ yudoʼ tuʼsédinëʼ. Ruzë́ nágabiʼ didzaʼ tuʼë, en rinaba yúdxibiʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Buluʼbani yúguʼtë nupa bilaʼyöni didzaʼ bë́ʼëbiʼ ca naca yöl-laʼ réajniʼi queë́biʼ, en ca nácagaca didzaʼ bubíʼibiʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Cateʼ bilaʼléʼenëʼ-biʼ xuz xináʼabiʼ, buluʼbáninëʼ, ateʼ gúdxinu-biʼ xináʼabiʼ, rnnanu: —Zxiʼinaʼ, ¿bizx que benuʼ caní queë́tuʼ? Buyútsöcaʼ, len yöl-laʼ ruúbi ruguíʼi nedaʼ, en xuzuʼ buguíljatuʼ liʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Níʼirö gúdxibiʼ Jesús légaquiëʼ, rnnabiʼ: —¿Bizx que buguíljaliʼ nedaʼ? ¿Naruʼ cabí nö́ziliʼ run bayudxi gunaʼ xichinëʼ Xuzaʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bitiʼ gulaʼyéajniʼinëʼ xuz xináʼabiʼ didzaʼ naʼ gúdxibiʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jesús bö́ajlenbiʼ légaquiëʼ, budxinbiʼ Nazaret, ateʼ benbiʼ ca rnna xtídzaʼgaquiëʼ xuz xináʼabiʼ. María, xináʼabiʼ Jesús, gulúʼusönu icja ládxiʼdoʼonu yúguʼtë lë ni. ");
INSERT INTO zarNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Rátaʼrö yöl-laʼ réajniʼi queë́biʼ biʼi Jesús, en rizxönbiʼ. Burúajbiʼ dxiʼa lahuëʼ Dios, en lógaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Cateʼ chiguca chinu iz rinná béʼenëʼ Tiberio César idútë yödzölió, rinná bëʼë Poncio Pilato luyú Judea, ateʼ Herodes rinná bëʼë caʼ luyú Galilea. Felipe, bö́chëʼë Herodes naʼ, rinná bëʼë luyú Iturea, en luyú Traconite, ateʼ Lisanias rinná bëʼë luyú Abilinia. ");
INSERT INTO zarNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Yuguʼ dza naʼ nácagaquiëʼ bixúz lo Anás, en Caifás, ateʼ laʼ náʼasö Dios bë́ʼlenëʼ Juan, zxíʼinëʼ Zacarías, didzaʼ cateʼ niʼ zoëʼ Juan lu lataj cáʼasö. ");
INSERT INTO zarNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ridë́ʼ Juan ni yúguʼtë lataj nacuáʼ raʼ yegu Jordán, runëʼ libán ca ral-laʼ ilaʼdila nisa nupa tuʼbíʼi ládxiʼgaca para uniti lahuëʼ Dios dul-laʼ nabágaʼgaca. ");
INSERT INTO zarNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Guca caní ca naʼ nazúaj lu guichi láʼayi yuguʼ didzaʼ bëʼë Isaías, bönniʼ bëʼë didzaʼ uláz queëʼ Dios, rnna: Riyö́n chiʼë bönniʼ rulidzëʼ lu lataj cáʼasö, rnnëʼ: “Buliʼpáʼa nöza lu icja ládxidoʼoliʼ para idxín Xanruʼ queë́liʼ. Buliʼbéaj li yuguʼ nöza lasi ga tödëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ral-laʼ ulígaca yúguʼtë gapa naca rögaʼ, en uluʼhuöáca lachiʼ yúguʼtë guíʼa sibi, en guíʼadoʼ. Ral-laʼ uluʼrúaj li nöza nayecja nabíʼigaca, ateʼ uluʼhuöáca dxiʼa nöza guiö́j. ");
INSERT INTO zarNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ilaʼléʼeni yúguʼtë bönachi Bönniʼ naʼ isö́l-lëʼë Dios, Nu usölá bönachi.” ");
INSERT INTO zarNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Cateʼ bilaʼrúaj bönachi zián para ilaʼdila nisa lu nëʼë Juan, lëʼ gudxëʼ légaquiëʼ: —Libiʼiliʼ, diʼa dza quégacabaʼ bëla síniaʼ. ¿Zoa nu buluíʼi libíʼiliʼ ral-laʼ izxúnnajliʼ yöl-laʼ rusiúdxi siʼ gaca quégaca bönachi? ");
INSERT INTO zarNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Naʼa, guliʼgún le ilaca bëʼ chibubíʼi ládxiʼliʼ, en bitiʼ saʼ ládxiʼliʼ, bitiʼ innaliʼ: “Nácatuʼ tsahuiʼ tuʼ nácatuʼ diʼa dza queëʼ Abraham”, tuʼ reaʼ libíʼiliʼ, huáca quélëʼë Dios yuguʼ guiö́j ni, en gunëʼ ga uluʼhuöáca diʼa dza queëʼ Abraham. ");
INSERT INTO zarNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nácaliʼ ca yuguʼ yaga. Chizóa riböza guíë huága para ichugu yuguʼ yaga. Yúguʼtë yaga bitiʼ taʼbía le naca dxiʼa, ilaʼchúguiëʼ yaga naʼ, en ilaʼguʼë léguequi lu guíʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Níʼirö bönachi nacuáʼ niʼ gulaʼnabi lëʼ, taʼnná: —¿Nacxi gúntsatuʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Bubiʼë didzaʼ Juan, rëʼ légaquiëʼ: —Nu dë chopa cöʼ zxe ral-laʼ unödzaj que nu bitiʼ dë que, ateʼ nu dë le gagu, lëscaʼ caní ral-laʼ quisi quégaca nupa bitiʼ dë le ilágugaca. ");
INSERT INTO zarNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bal-lëʼ bönniʼ tuʼquizxjëʼ lázagaca bönachi uláz que yödzö ziʼtuʼ bilaʼdxinëʼ caʼ niʼ para ilaʼdilëʼ nisa, ateʼ gulaʼnábinëʼ lëʼ, taʼnnë́ʼ: —Bönniʼ usëdi, ¿nacxi gúntsatuʼ netuʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan gudxëʼ légaquiëʼ: —Bitiʼ uquízxjaröliʼ tsca le chigunnë́ʼ bönniʼ yúʼuliʼ lu nëʼë. ");
INSERT INTO zarNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Bal-lëʼ bönniʼ röjáquiëʼ gudil-la gulaʼnábinëʼ caʼ lëʼ, taʼnnë́ʼ: —¿Nazxi netuʼ, nacxi guntuʼ? Juan gudxëʼ légaquiëʼ: —Bítiʼrö gun gádxiliʼ bönachi para cúaliʼ le dë quéguequi. Bítiʼrö innëliʼ quégaca bönachi le cabí nácatë para gunliʼ ga ilaʼguizxaj libíʼiliʼ, pero guliʼtsaza ládxiʼliʼ tsca rázxjaliʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Taʼzáʼ ládxiʼgaca bönachi naʼ taʼböza Bönniʼ naʼ ral-laʼ isö́l-lëʼë Dios, channö náquiëʼ Juan naʼ Bönniʼ lëʼ Cristo. ");
INSERT INTO zarNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Bubiʼë didzaʼ Juan, gudxëʼ yúguʼtëʼ, rnnëʼ: —Le nácatë nedaʼ ruquilaʼ libíʼiliʼ nisa, pero zëʼë Bönniʼ gunëʼ le ruluíʼisö yöl-laʼ ridila nisa ni, ichíziëʼ libíʼiliʼ Dios Böʼ Láʼayi, en le naca guíʼ queëʼ. Bönniʼ ni náparëʼ yöl-laʼ unná bëʼ ca nedaʼ, ateʼ nedaʼ bitiʼ nacaʼ lesacaʼ ilecjaʼ le nudë́ʼë niʼe. ");
INSERT INTO zarNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Zönëʼ lu nëʼë böcö́ʼ queëʼ, ateʼ ulubëʼ ga rilubi zxoaʼ xtila queëʼ, lë ni ruluíʼi le gaca quégaca bönachi. Utubëʼ zxoaʼ xtila, en cuʼë le xilataj, pero bëbu que uzéguiʼë lu guíʼ le catu caz ulu. ");
INSERT INTO zarNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ca nácagaca didzaʼ ni, en iaʼzícaʼrö zián didzaʼ le guchíziëʼ icja nágagaca bönachi, benëʼ libán Juan lógaquiëʼ que didzaʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Juan naʼ buzéguiʼë didzaʼ Herodes, bönniʼ rinná bëʼë, tuʼ zóalenëʼ-nu Herodías, nigula queëʼ Felipe, bönniʼ bö́chëʼë, encaʼ tuʼ runëʼ zián le ruáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Níʼirö benëʼ Herodes tu le nácarö huiáʼ döʼ, guluʼë Juan naʼ lidxi guíë. ");
INSERT INTO zarNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Dza naʼ cateʼ cabí nadzunëʼ Juan lidxi guíë, cateʼ niʼ ruquilëʼ bönachi nisa, bidilëʼ caʼ Jesús nisa. Cateʼ niʼ rulidzëʼ Dios, guyalaj lúzxiba, ");
INSERT INTO zarNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ateʼ bötjëʼ Dios Böʼ Láʼayi, bidxinëʼ ga naʼ zoëʼ Jesús. Buluíʼi lahuëʼ, rinë́ʼë ca rináʼ tubaʼ guʼdödoʼ, ateʼ biyö́n chiʼi Nu ruíʼi didzaʼ yehuaʼ yubá, rnna: —Liʼ nacuʼ Zxíʼinaʼ. Nadxíʼidaʼ Liʼ, en raza ládxaʼa Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Cateʼ gusí lahuëʼ runëʼ xichinëʼ Jesús, yuʼë ca chi uruáʼ iz. Téquiguequi bönachi náquiëʼ zxíʼinëʼ José. Jesús náquiëʼ zxíʼini xiʼsóëʼ Elí, nu naʼ náquiëʼ xúzinu María, nigula queëʼ José naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí naʼ gúquiëʼ zxíʼinëʼ Matat, nu ni guca zxíʼinëʼ Leví, nu ni guca zxíʼinëʼ Melqui, nu ni guca zxíʼinëʼ Jana, nu ni guca zxíʼinëʼ iaʼtúëʼ José. ");
INSERT INTO zarNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José ni gúquiëʼ zxíʼinëʼ Matatías, nu ni guca zxíʼinëʼ Amós, nu ni guca zxíʼinëʼ Nahum, nu ni guca zxíʼinëʼ Esli, nu ni guca zxíʼinëʼ Nagai. ");
INSERT INTO zarNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai naʼ gúquiëʼ zxíʼinëʼ Mat, nu ni guca zxíʼinëʼ iaʼtúëʼ Matatías, nu ni guca zxíʼinëʼ Semei, nu ni guca zxíʼinëʼ iaʼtúëʼ José, nu ni guca zxíʼinëʼ Judá. ");
INSERT INTO zarNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá naʼ gúquiëʼ zxíʼinëʼ Joana, nu ni guca zxíʼinëʼ Resa, nu ni guca zxíʼinëʼ Zorobabel, nu ni guca zxíʼinëʼ Salatiel, nu ni guca zxíʼinëʼ Neri. ");
INSERT INTO zarNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri naʼ gúquiëʼ zxíʼinëʼ iaʼtúëʼ Melqui, nu ni guca zxíʼinëʼ Adi, nu ni guca zxíʼinëʼ Cosam, nu ni guca zxíʼinëʼ Elmodam, nu ni guca zxíʼinëʼ Er. ");
INSERT INTO zarNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er naʼ gúquiëʼ zxíʼinëʼ Josué, nu ni guca zxíʼinëʼ Eliezer, nu ni guca zxíʼinëʼ Jorim, nu ni guca zxíʼinëʼ iaʼtúëʼ Matat. ");
INSERT INTO zarNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat naʼ gúquiëʼ zxíʼinëʼ Leví, nu ni guca zxíʼinëʼ Simeón, nu ni guca zxíʼinëʼ Judá, nu ni guca zxíʼinëʼ iaʼtúëʼ José, nu ni guca zxíʼinëʼ Jonán, nu ni guca zxíʼinëʼ Eliaquim. ");
INSERT INTO zarNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim naʼ gúquiëʼ zxíʼinëʼ Melea, nu ni guca zxíʼinëʼ Mainán, nu ni guca zxíʼinëʼ Matata, nu ni guca zxíʼinëʼ Natán. ");
INSERT INTO zarNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán naʼ gúquiëʼ zxíʼinëʼ David, nu ni guca zxíʼinëʼ Isaí, nu ni guca zxíʼinëʼ Obed, nu ni guca zxíʼinëʼ Booz, nu ni guca zxíʼinëʼ Salmón, nu ni guca zxíʼinëʼ Naasón. ");
INSERT INTO zarNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón naʼ gúquiëʼ zxíʼinëʼ Aminadab, nu ni guca zxíʼinëʼ Aram, nu ni guca zxíʼinëʼ Esrom, nu ni guca zxíʼinëʼ Fares, nu ni guca zxíʼinëʼ iaʼtúëʼ Judá. ");
INSERT INTO zarNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá naʼ gúquiëʼ zxíʼinëʼ Jacob, nu ni guca zxíʼinëʼ Isaac, nu ni guca zxíʼinëʼ Abraham, nu ni guca zxíʼinëʼ Taré, nu ni guca zxíʼinëʼ Nacor. ");
INSERT INTO zarNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor naʼ gúquiëʼ zxíʼinëʼ Serug, nu ni guca zxíʼinëʼ Ragau, nu ni guca zxíʼinëʼ Peleg, nu ni guca zxíʼinëʼ Heber, nu ni guca zxíʼinëʼ Sala. ");
INSERT INTO zarNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala naʼ gúquiëʼ zxíʼinëʼ Cainán, nu ni guca zxíʼinëʼ Arfaxad, nu ni guca zxíʼinëʼ Sem, nu ni guca zxíʼinëʼ Noé, nu ni guca zxíʼinëʼ Lamec. ");
INSERT INTO zarNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec naʼ gúquiëʼ zxíʼinëʼ Matusalén, nu ni guca zxíʼinëʼ Enoc, nu ni guca zxíʼinëʼ Jared, nu ni guca zxíʼinëʼ Mahalalel, nu ni guca zxíʼinëʼ iaʼtúëʼ Cainán. ");
INSERT INTO zarNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán naʼ gúquiëʼ zxíʼinëʼ Enós, nu ni guca zxíʼinëʼ Set, nu ni guca zxíʼinëʼ Adán, nu ni guca ca zxíʼini cazëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Buzë́ʼë Jesús raʼ yegu Jordán, zóalenëʼ Dios Böʼ Láʼayi Lëʼ, ateʼ Dios Böʼ Láʼayi naʼ guchë́ʼë Jesús lu lataj cáʼasö. ");
INSERT INTO zarNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Guzóëʼ Jesús niʼ idú ca choáʼ dza, ateʼ gúʼuni tuʼ xihuiʼ usubagaʼ Jesús dul-laʼ. Bitiʼ bi gudahuëʼ Jesús yuguʼ dza naʼ, ateʼ gudödi niʼ ridunëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Níʼirö tuʼ xihuiʼ naʼ gudxi Jesús, rnna: —Channö naca cazuʼ Liʼ Zxíʼinëʼ Dios, gunnátsöcaʼ uluʼhuöáca guiö́j ni yöta xtila. ");
INSERT INTO zarNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Bubiʼë didzaʼ Jesús, rëʼ le: —Nazúaj lu guichi, rnna: “Calë́gasö yöta xtila nabánigaca bönachi, pero nabánigaca caʼ yúguʼtë xtídzëʼë Dios.” ");
INSERT INTO zarNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Níʼirö guchë́ʼ tuʼ xihuiʼ naʼ Jesús ga naca tu lu guíʼa sibi ateʼ tu chíʼidoʼosö buluíʼi Lëʼ yúguʼtë xilátjagaca nupa taʼnná bëʼ yödzölió. ");
INSERT INTO zarNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Tuʼ xihuiʼ naʼ rë Jesús, rnna: —Gunnaʼ quiuʼ yúguʼtë xilátjagaca nupa taʼnná bëʼ ni, en yöl-laʼ tsahuiʼ quéguequi, tuʼ nadödi lu naʼa yúguʼtë lë ni, ateʼ nu rë́ʼënisidaʼ ruáʼa que. ");
INSERT INTO zarNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Channö Liʼ uzóa zxibuʼ lahuaʼ, en gunuʼ nedaʼ zxön, yúguʼtë lë ni guequi quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Bubiʼë didzaʼ Jesús, rëʼ le: —Gucuita ga zoaʼ, Satanás, tuʼ nazúaj lu guichi láʼayi le rë netuʼ, rnna: “Xanuʼ Dios tseaj ládxuʼu-nëʼ, en tuzëʼ Lëʼ gunuʼ xichinëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Níʼirö tuʼ xihuiʼ naʼ guchë́ʼ Jesús Jerusalén, ateʼ budxía Lëʼ lu zöʼö ícjoʼolö yudoʼ, en rë Lëʼ: —Channö nacuʼ Zxíʼinëʼ Dios, busuládzuʼtsöcaʼ cuinuʼ ni ");
INSERT INTO zarNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","tuʼ nazúaj lu guichi láʼayi, rnna: Dios isö́l-lëʼë gubáz láʼayi queëʼ, ilácalenëʼ Liʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Lu náʼagaquiëʼ uluʼchisëʼ Liʼ para cabí tsöjchéguʼu guiö́j, en bitiʼ gunuʼ ziʼ niʼu. ");
INSERT INTO zarNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Bubiʼë didzaʼ Jesús, rëʼ le: —Nazúaj lu guichi láʼayi le rë netuʼ: “Bitiʼ siʼ bëʼu Xanuʼ Dios.” ");
INSERT INTO zarNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Cateʼ bitiʼ budzöli tuʼ xihuiʼ naʼ iaʼtú le siʼ bëʼ Jesús, buzáʼ ga zoëʼ tu chíʼidoʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Bö́ajëʼ Jesús luyú Galilea, dë lu nëʼë yöl-laʼ huáca queëʼ Dios Böʼ Láʼayi. Guzë́ didzaʼ ca naca queëʼ, ateʼ bilaʼyöni bönachi nacuáʼ yúguʼtë yödzö idú gásibiʼilö. ");
INSERT INTO zarNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Busédinëʼ Jesús bönachi gapa naca lu yuʼu ga tuʼdubëʼ tuʼsëdëʼ bönniʼ judío queëʼ Dios, ateʼ yúguʼtë bönachi gulún Lëʼ zxön. ");
INSERT INTO zarNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Níʼirö budxinëʼ Jesús yödzö Nazaret ga niʼ guzxönëʼ. Cateʼ bidxín dza láʼayi quégaquiëʼ bönniʼ judío, ca run cazëʼ Jesús, guyáziëʼ lu yuʼu ga tuʼdubëʼ tuʼsëdëʼ bönniʼ judío queëʼ Dios, ateʼ guzuínëʼ para ulabëʼ tu le nazúaj lu guichi láʼayi. ");
INSERT INTO zarNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Buluʼdödëʼ lu nëʼë Jesús guichi ga naʼ nazúaj didzaʼ bëʼë Isaías, bönniʼ bëʼë didzaʼ uláz queëʼ Dios. Cateʼ gusaljëʼ guichi naʼ, budzö́linëʼ ga nazúaj lu guichi le rnna: ");
INSERT INTO zarNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Zóalenëʼ Böʼ Láʼayi queëʼ Xanruʼ nedaʼ tuʼ nubéajëʼ nedaʼ quez queëʼ para usiyöndaʼ bönachi yechiʼ didzaʼ dxiʼa. Gusö́l-lëʼë nedaʼ para unaʼ nupa raca ziʼ ládxiʼdoʼguequi, en usiyöndaʼ nupa nadzúngaca, ca gaca uluʼlágaca, en únaʼ bönachi nachul-la lóguequi, en usöláʼ bönachi zoa nu run léguequi ziʼ, ");
INSERT INTO zarNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","en gunaʼ libán que dza ruzáʼ ládxëʼë Xanruʼ Dios quégaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Níʼirö butubëʼ Jesús guichi naʼ, en buguʼë le lu nëʼë bönniʼ rapa chiʼë yuguʼ guichi láʼayi, ateʼ guröʼë. Níʼirö yúguʼtë nupa nudúbigaca lu yuʼu naʼ gulaʼnáʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Gusí lahuëʼ Jesús rëʼ légaquiëʼ: —Naʼa dza ni zóaliʼ libíʼiliʼ, rudxín caz le nazúaj lu guichi ni. ");
INSERT INTO zarNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Yúguʼtëʼ gulaʼnnë́ʼ dxiʼa queëʼ, en buluʼbáninëʼ ca naca didzaʼ dxiʼa ruʼë, ateʼ taʼnnë́ʼ: —¿Naruʼ calëga bönniʼ ni zxíʼinëʼ José? ");
INSERT INTO zarNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús rëʼ légaquiëʼ, rnnëʼ: —Nadxi huëliʼ nedaʼ lë ni taʼnná bönachi, le rnna: “Liʼ, bönniʼ ruún bönachi, bun cuinuʼ.” Lëscaʼ caní huëliʼ nedaʼ: “Yuguʼ le biyö́nituʼ benuʼ Capernaum, ben caʼ ga ni naca ladzuʼ.” ");
INSERT INTO zarNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Gunnë́ʼ caʼ Jesús: —Le nácatë reaʼ libíʼiliʼ, channö zoëʼ nu bönniʼ ruʼë didzaʼ uláz queëʼ Dios, bitiʼ tun bönachi uládz queëʼ lëʼ bal. ");
INSERT INTO zarNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Le nácatë reaʼ libíʼiliʼ, gulaʼcuáʼanu zián nigula uzëbi luyú Israel yuguʼ dza niʼ zoëʼ Elías, bönniʼ bëʼë didzaʼ uláz queëʼ Dios, cateʼ niʼ bitiʼ gulaj guiö́j idú ca tsonna iz yuʼ xopa beoʼ, ateʼ guca gubín luyú naʼ, ");
INSERT INTO zarNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","pero Dios bitiʼ gusö́l-lëʼë Elías naʼ ga nacuáʼanu nigula uzëbi nabábagacanu Israel, pero gusö́l-lëʼë lëʼ ga naʼ zóanu tu nigula uzëbi lu yödzö Sarepta, le nababa yödzö Sidón. ");
INSERT INTO zarNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Lëscaʼ caní, gulaʼcuáʼ zián nupa teʼe huëʼ nudzuʼ ruzödi luyú Israel dza niʼ zoëʼ Eliseo, bönniʼ bëʼë didzaʼ uláz queëʼ Dios, pero bitiʼ böáquiëʼ nu bönniʼ nútsëʼë ladaj bönachi Israel naʼ, pero böáquiëʼ tuzëʼ Naamán, bönniʼ nababëʼ luyú Siria. ");
INSERT INTO zarNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Cateʼ bilaʼyönnëʼ didzaʼ ni, gulaʼlenëʼ yúguʼtë bönniʼ nacuʼë lu yuʼu ga naʼ tuʼdubëʼ tuʼsëdëʼ queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Níʼirö gulaʼyasëʼ, en buluʼbéajëʼ Jesús níʼilö raʼ yödzö. Gulaʼchë́ʼë Lëʼ ga naca lëʼe guíʼa guiö́j ga naʼ dë ládzagaquiëʼ para uluʼsuládzuëʼ Lëʼ ga naca lëʼe guíʼa guiö́j naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Níʼirö gudödëʼ Jesús gatsaj láhuiʼlö ga naʼ nacuʼë, söhuö́ajtëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Níʼirö guyijëʼ Jesús yödzö Capernaum luyú Galilea, ateʼ busédinëʼ bönachi yuguʼ dza láʼayi quégaquiëʼ bönniʼ judío. ");
INSERT INTO zarNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Buluʼbáninëʼ ca naca le rusédinëʼ Jesús légaquiëʼ, tuʼ bëʼë didzaʼ ca tu bönniʼ dë lu nëʼë yöl-laʼ unná bëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Zóatëʼ caʼ tu bönniʼ yuʼu lëʼ böʼ xihuiʼ lu yuʼu ga naʼ tuʼdubëʼ tuʼsëdëʼ queëʼ Dios, ateʼ bëʼë zidzaj didzaʼ, ");
INSERT INTO zarNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","rnnëʼ: —¡Busán netuʼ! ¿Bizxi rálaʼtuʼ quiuʼ, Jesús, bönniʼ Nazaret? ¿Naruʼ zoʼo para usunítiuʼ netuʼ? Núnbëʼa Liʼ Nu nacuʼ. Bönniʼ Láʼayi queëʼ Dios nacuʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús buzenëʼ le bach böʼ xihuiʼ naʼ, en rëʼ le: —Busayaj ruʼu, en burúaj lu bönniʼ ni. Níʼirö böʼ xihuiʼ naʼ gurúʼuna bönniʼ naʼ lu yu lógaca bönachi nacuáʼ niʼ. Burúajtë lu bönniʼ naʼ, en bítiʼrö bi ben queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Buluʼbáninëʼ yúguʼtëʼ, en guluʼë didzaʼ tuëʼ len iaʼtúëʼ, taʼnnë́ʼ: —¿Bizxi didzaʼ ni ruʼë? Len yöl-laʼ unná bëʼ, en yöl-laʼ huáca zxön rinná béʼenëʼ yuguʼ böʼ xihuiʼ, ateʼ tuʼrúajtë böʼ xihuiʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Guzë́ didzaʼ ca naca queëʼ Jesús, ateʼ bilaʼyöni bönachi yúguʼtë yödzö idú gásibiʼilö. ");
INSERT INTO zarNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Níʼirö guyasëʼ Jesús, en burúajëʼ lu yuʼu ga naʼ tuʼdubëʼ tuʼsëdëʼ queëʼ Dios, ateʼ guyáziëʼ lidxëʼ Simón. Xináʼanu nigula queëʼ Simón naʼ zóanu niʼ, en yúʼunu xilá, ateʼ gulátaʼyuëʼ lahuëʼ Jesús únëʼ-nu. ");
INSERT INTO zarNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Gubíguiʼë Jesús ga naʼ dënu, ateʼ bulidzëʼ huëʼ xilá naʼ yúʼunu. Laʼ birúajtë xilá naʼ yúʼunu, ateʼ laʼ guyástënu, en bë́ʼënu le gulahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Cateʼ chiribía gubidza, yúguʼtë nupa nacuáʼlen léguequi nupa naʼ teʼe que queë́guequi yödzhuë́ʼ bilaʼdxín niʼ, ateʼ dujuáʼgaca léguequi ga naʼ zoëʼ Jesús. Lëʼ guxóa nëʼë nupa naʼ teʼe, en bunëʼ léguequi. ");
INSERT INTO zarNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Buluʼrúaj caʼ zián böʼ xihuiʼ yúʼugaca bönachi teʼe naʼ. Taʼbö́dxiʼa böʼ xihuiʼ naʼ, taʼnná: —Liʼ nacuʼ zxíʼinëʼ Dios. Níʼirö Jesús buzenëʼ le bach yuguʼ böʼ xihuiʼ naʼ, en bitiʼ bëʼë lataj ilaʼnná, tuʼ nö́ziguequi náquiëʼ Cristo. ");
INSERT INTO zarNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Cateʼ zaʼ reníʼ iaʼtú dza, burúajëʼ Jesús Capernaum naʼ, ateʼ guyijëʼ tu lataj cáʼasö. Bilaʼdxín bönachi zián niʼ, tuʼguílaj Jesús. Cateʼ bilaʼdxinëʼ ga naʼ zoëʼ, gulë́ʼëniguequinëʼ uluʼtsenëʼ Lëʼ, para cabí uzë́ʼë ga naʼ nacuʼë. ");
INSERT INTO zarNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Níʼirö Jesús gudxëʼ légaquiëʼ, rnnëʼ: —Run bayudxi tsejaʼ gapa nacuáʼ iaʼzícaʼrö yödzö, tsöjenaʼ caʼ libán niʼ que didzaʼ dxiʼa ca rinná bëʼë Dios. Que lë ni naʼ gusö́l-lëʼë nedaʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Caní guca, benëʼ libán yuguʼ yödzö luyú Galilea gapa naca lu yuʼu ga tuʼdubëʼ bönniʼ judío, en tuʼsëdëʼ queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Cateʼ niʼ zoëʼ Jesús raʼ nísadoʼ nazíʼi le Genesaret, lu xiyú Galilea, buluʼquídaʼ bönachi zián Lëʼ para ilaʼyöni xtídzëʼë Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Níʼirö biléʼenëʼ Jesús chopa bárcodoʼ, zxóagaca lu nísadoʼ ga naʼ naca raʼ yu bidxi, ateʼ narúajgaquiëʼ bönniʼ uzxö́n böla lë́ʼegaca bárcodoʼ naʼ, en taʼguibëʼ yöxaj böla quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Gurenëʼ Jesús tu lëʼe bárcodoʼ naʼ, le nequi queëʼ Simón Pedro, ateʼ gunábinëʼ lëʼ udxíguiëʼ le iaʼlátiʼdoʼ ziʼtuʼ ga naca raʼ yu bidxi naʼ. Níʼirö guröʼë Jesús lëʼe bárcodoʼ naʼ, en rö́ʼösëʼ caʼ niʼ rusédinëʼ bönachi zián nacuáʼ lu yu bidxi naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Cateʼ budxi bëʼë didzaʼ Jesús, níʼirö gudxëʼ Simón, rnnëʼ: —Busáʼ bárcodoʼ ni lu nísadoʼ ga naʼ röʼö zila, ateʼ niʼ guliʼzalaj yöxaj böla queë́liʼ para sönliʼ-baʼ böla. ");
INSERT INTO zarNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Bubiʼë didzaʼ Simón, rëʼ Jesús: —Bönniʼ Usëdi, idú yëla chibentuʼ dxin, en bitiʼ bi böla nazö́nituʼ-baʼ, pero didzaʼ quiuʼ izáljagaraʼ yöxaj. ");
INSERT INTO zarNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Cateʼ chigulaʼzaljëʼ le, gulaʼzönëʼ ziántëröbaʼ böla, ateʼ réquitiquiʼ irözaʼ yöxaj böla naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Níʼirö buluʼláʼa buluʼluíʼisinëʼ, buluʼlidzëʼ luzáʼagaquiëʼ nacuʼë iaʼtú lëʼe bárcodoʼ naʼ para záʼgaquiëʼ ilácalenëʼ légaquiëʼ. Cateʼ bilaʼdxinëʼ niʼ buluʼdzë́ʼë-baʼ böla irópatë bárcodoʼ naʼ, ateʼ chirequi uluʼhuö́taj bárcodoʼ naʼ lu nisa. ");
INSERT INTO zarNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Cateʼ biléʼenëʼ Simón Pedro lë ni, níʼirö buzóa zxibëʼ lahuëʼ Jesús, rnnëʼ: —Gucuita ga zoaʼ, Xan, tuʼ nacaʼ bönniʼ dul-laʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Caní gunnë́ʼ tuʼ radxi ridzö́binëʼ Pedro niʼa quégacabaʼ böla zián naʼ gulaʼzö́ngaquiëʼ-baʼ, en lëscaʼ caní guca quégaca nupa nacuáʼlen lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Guladxi gulaʼdzö́binëʼ caʼ Jacobo, en Juan, yuguʼ zxíʼinëʼ Zebedeo, nupa ni nácagaca luzë́ʼë Simón Pedro naʼ. Níʼirö Jesús rëʼ Simón naʼ, rnnëʼ: —Bitiʼ gádxinuʼ. Naʼa isí loʼ ichëʼu quiaʼ bönachi ca runuʼ rizönuʼ-baʼ böla. ");
INSERT INTO zarNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Cateʼ chibuluʼsudxinëʼ yuguʼ bárcodoʼ naʼ ga naca raʼ yu bidxi, níʼirö buluʼcáʼanëʼ yúguʼtë niʼ, ateʼ söjácalenëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Cateʼ zoëʼ Jesús tu lu yödzö niʼ, bidxinëʼ tu bönniʼ réʼedeʼenëʼ huëʼ nudzuʼ ruzödi ga naʼ zoëʼ. Cateʼ biléʼenëʼ Jesús, busudxín lahuëʼ lu yu, en gútaʼyuëʼ lahuëʼ, rnnëʼ: —Xan, channö rë́ʼënuʼ, huáca unuʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Níʼirö bulí nëʼë Jesús, en gudanëʼ lëʼ. Rëʼ lëʼ: —Rë́ʼëndaʼ. Gacuʼ dxiʼa. Laʼ gubídxitë huëʼ nudzuʼ queëʼ bönniʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Níʼirö Jesús gunná béʼenëʼ lëʼ cuntu nu guíëʼ caʼ. Gudxëʼ lëʼ: —Guyéaj, yöjluíʼi cuinuʼ lahuëʼ bixúz, ateʼ yöjnödzaj que yudoʼ le ruluíʼi nuhuöácuʼ dxiʼa ca gunná bëʼë Moisés, lë naʼ uluíʼi légaquiëʼ chiböácuʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Guzë́tërö didzaʼ que yöl-laʼ huáca queëʼ Jesús, ateʼ buluʼdubi bönachi zián ga naʼ zoëʼ para ilaʼyöni xtídzëʼë, en para únëʼ léguequi, ugǘëʼ yödzöhuë́ʼ téʼeguequi. ");
INSERT INTO zarNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Níʼirö buzë́ʼë Jesús niʼ, en guyijëʼ tu lataj cáʼasö, ateʼ niʼ bulidzëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Iaʼtú dza, cateʼ niʼ rusédinëʼ Jesús bönachi, rö́ʼögaquiëʼ yuguʼ bönniʼ yudoʼ fariseo len bönniʼ yudoʼ tuʼsédinëʼ xibá queëʼ Moisés niʼ, narúajgaquiëʼ yúguʼtë yödzö luyú Galilea, en luyú Judea, en lu yödzö Jerusalén. Naca bëʼ dë lu nëʼë Jesús yöl-laʼ huáca queëʼ Xanruʼ Dios tuʼ ruúnëʼ bönachi teʼe nacuáʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Níʼirö bönniʼ nuáʼagaquiëʼ le denëʼ tu bönniʼ huëʼ nacúʼuniëʼ bin bilaʼdxinëʼ ga niʼ, ateʼ buluʼguiljëʼ nacxi ilunëʼ para ilaʼguʼë lëʼ lu yuʼu para ilaʼguixjëʼ lëʼ lahuëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Cateʼ bitiʼ gulaʼdzö́linëʼ nacxi ilunëʼ, tuʼ nacuáʼ bönachi zián niʼ, gulaʼbenëʼ ícjoʼolö yuʼu naʼ, en gulaʼsaljëʼ ícjoʼo naʼ. Níʼirö buluʼzötjëʼ le denëʼ bönniʼ huëʼ naʼ, ateʼ gulaʼguíxjëʼ lëʼ gatsaj láhuiʼlö bönachi niʼ lahuëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Cateʼ gúquibeʼenëʼ Jesús ca naʼ taʼyéajlëʼë Lëʼ, gudxëʼ bönniʼ huëʼ naʼ: —Bönniʼ, yuguʼ dul-laʼ nabáguʼu chibuníti lahuaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Níʼirö gulaʼsí lógaquiëʼ taʼzáʼ ládxiʼgaquiëʼ bönniʼ yudoʼ tuʼsédinëʼ naʼ, en yuguʼ bönniʼ yudoʼ fariseo, taʼnnë́ʼ: “¿Nuzxi caz bönniʼ ni rnnëʼ le rucáʼana Dios cáʼasö? ¿Nuzxi caz gaca uniti lo dul-laʼ? Tuzëʼ Dios runiti lahuëʼ dul-laʼ.” ");
INSERT INTO zarNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Réquibeʼenëʼ Jesús le taʼzáʼ ládxiʼgaquiëʼ, ateʼ rëʼ légaquiëʼ: —¿Bizx que rizáʼ ládxiʼliʼ caní? ");
INSERT INTO zarNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Bitiʼ naca böniga nu guië́sö bönniʼ ni: “Yuguʼ dul-laʼ nabáguʼu chibuníti lahuaʼ”, pero naca böniga nu gun ga chasëʼ, en sëʼe niʼë. ");
INSERT INTO zarNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Gunaʼ ga inö́ziliʼ dë lu naʼa nedaʼ, Bönniʼ Guljëʼ Bönachi, yöl-laʼ unná bëʼ uniti lahuaʼ dul-laʼ luyú ni. Níʼirö gudxëʼ bönniʼ naʼ nacúʼuniëʼ bin, rnnëʼ: —Liʼ reaʼ, guyasa. Buáʼ le denuʼ, en böaj lidxuʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Laʼ guyásatëʼ bönniʼ huëʼ naʼ lógaquiëʼ, ateʼ buʼë lë naʼ gútiʼnëʼ, en söhuö́jëʼ lidxëʼ, riguʼë Dios yöl-laʼ ba. ");
INSERT INTO zarNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Gulaʼnítitiquiʼsinëʼ yúguʼtëʼ, ateʼ gulaʼguʼë Dios yöl-laʼ ba, en tádxisinëʼ caʼ, taʼnnë́ʼ: —Naʼa biléʼeruʼ le run ga rubániruʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Gudödi gulaca yuguʼ lë ni burúajëʼ Jesús niʼ, ateʼ biléʼenëʼ tu bönniʼ uquízxaj lázagaca bönachi, lëʼ Leví, röʼë ga naʼ ruquízxjëʼ, ateʼ Jesús rëʼ lëʼ: —Gudáʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Laʼ guyásatëʼ Leví, ateʼ bucáʼanëʼ yúguʼtë, en saʼyéajlenëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Gudödi niʼ benëʼ Leví naʼ tu güíʼi huagu queëʼ Jesús ga naca lu yuʼu lidxëʼ, ateʼ gulaʼcuʼë zián bönniʼ uquízxaj niʼ len iaʼbal-lëʼ bönniʼ taʼbö́ʼlenëʼ légaquiëʼ tahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Níʼirö bönniʼ yudoʼ tuʼsédinëʼ len yuguʼ bönniʼ yudoʼ fariseo gulaʼnnë́ʼ quégaquiëʼ bönniʼ usëda queëʼ Jesús, taʼnnë́ʼ: —¿Bizx que rëʼaj rágulenliʼ yuguʼ bönniʼ uquízxaj, en iaʼzícaʼrëʼ bönniʼ dul-laʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Bubiʼë didzaʼ Jesús, rëʼ légaquiëʼ: —Yuguʼ bönniʼ nacuʼë dxiʼa bitiʼ naquíniguequinëʼ nu un bönachi, pero bönniʼ téʼenëʼ naquíniguequinëʼ nu un bönachi. ");
INSERT INTO zarNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Zaʼa, calëga ulídzagacaʼ-nëʼ bönniʼ tsahuiʼ, pero zaʼa ulídzagacaʼ-nëʼ bönniʼ dul-laʼ para uluʼbíʼi ládxiʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Níʼirö bönniʼ yudoʼ naʼ gulaʼnábinëʼ Jesús, taʼnnë́ʼ: —¿Bizx que tunëʼ gubasa zián luzuí bönniʼ dáʼgaquiëʼ Juan, en tuʼlidzëʼ Dios, ateʼ tunëʼ caʼ caní bönniʼ dáʼgaquiëʼ yuguʼ bönniʼ yudoʼ fariseo, pero bönniʼ dáʼgaquiëʼ Liʼ tëʼaj tahuëʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús rëʼ légaquiëʼ: —¿Naruʼ huácatsö gunliʼ ga ilunëʼ gubasa bönniʼ nacuʼë laní que yöl-laʼ rutsaga naʼ tsanni niʼ bönniʼ rutsaga nëʼë zóalenëʼ légaquiëʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Huadxín dza cateʼ udúëʼ bönniʼ rutsaga nëʼë ga nacuʼë. Dza níʼirö ilunëʼ gubasa. ");
INSERT INTO zarNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Níʼirö bucúdzuʼë didzaʼ Jesús ca naca lë ni, ateʼ rëʼ légaquiëʼ: —Cuntu nu bönniʼ ichúguiëʼ tu lariʼ cubi chinadía, en cuejëʼ tsötacaʼ le udë́ʼë lëʼe lariʼ tëbi. Channö gunëʼ caní, calë́gasö gaca ditaj lariʼ cubi naʼ, pero láriʼdoʼ naʼ birúaj lëʼe lariʼ cubi naʼ bitiʼ tsöjlö́za lariʼ tëbi naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Lëscaʼ caní, cuntu nu bönniʼ riguë́ʼë xisi uva cubi lu buzudi guídi gula. Channö nu gun caní, xisi uva cubi naʼ uchözaʼ buzudi guídi gula, ateʼ ilalaj xisi uva naʼ, ateʼ gaca ditaj buzudi guídi gula naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Que lë ni naʼ ral-laʼ cáʼaruʼ xisi uva cubi lu buzudi guídi cubi, ateʼ irópatë ilaca chiʼi. ");
INSERT INTO zarNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Channö zoa nu rëʼaj xisi uva gula, bitiʼ guë́ʼënitë guíʼaj xisi uva cubi, tuʼ rnna: “Nácarö sizxíʼ xisi uva gula naʼ.” ");
INSERT INTO zarNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Cateʼ naca tu dza láʼayi quégaquiëʼ bönniʼ judío, ridödëʼ Jesús gapa dë yöla zxoaʼ xtila, ateʼ bönniʼ usëda queëʼ taʼlecjëʼ do ga dxía zxoaʼ xtila. Taʼzxúbiʼni náʼagaquiëʼ le, en tahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Níʼirö gulaʼnábinëʼ bönniʼ yudoʼ fariseo légaquiëʼ, taʼnnë́ʼ: —¿Bizx que runliʼ le cabí ral-laʼ gunruʼ dza láʼayi? ");
INSERT INTO zarNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Bubiʼë didzaʼ Jesús, rëʼ légaquiëʼ: —¿Naruʼ cabí nulábaniliʼ ca benëʼ David cateʼ gudunëʼ, ateʼ gulaʼdún caʼ nupa nacuáʼlen lëʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Guyáziëʼ lu yuʼu queëʼ Dios, en guzxiʼë yöta xtila tuʼcuʼë lahuëʼ Dios, lë naʼ bitiʼ ral-laʼ gáguruʼ, pero tuz bixúz dë lataj ilahuëʼ, ateʼ gudahuëʼ David le, en bëʼë caʼ quéguequi nupa nacuáʼlen lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Níʼirö Jesús gudxëʼ légaquiëʼ, rnnëʼ: —Nedaʼ, Bönniʼ Guljëʼ Bönachi, nacaʼ xani dza láʼayi. ");
INSERT INTO zarNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Cateʼ naca iaʼtú dza láʼayi quégaquiëʼ bönniʼ judío, guyáziëʼ Jesús lu yuʼu ga tuʼdubëʼ tuʼsëdëʼ queëʼ Dios, en busédinëʼ nupa nacuáʼ niʼ. Zoëʼ caʼ tu bönniʼ niʼ narequiʼ nëʼë ibëla. ");
INSERT INTO zarNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yuguʼ bönniʼ yudoʼ tuʼsédinëʼ, en yuguʼ bönniʼ yudoʼ fariseo tuʼyúëʼ Jesús para ilaʼléʼenëʼ channö únëʼ bönniʼ naʼ cateʼ naca dza láʼayi quégaquiëʼ para uluʼdzö́linëʼ nacxi uluʼzéguiëʼ Lëʼ didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Réquibeʼenëʼ Jesús le taʼzáʼ ládxiʼgaquiëʼ, ateʼ gudxëʼ bönniʼ naʼ narequiʼ nëʼë, rnnëʼ: —Guyasa. Guzuí gatsaj láhuiʼlö ni. Laʼ guyásatëʼ bönniʼ naʼ, guzuínëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Níʼirö Jesús gudxëʼ yuguʼ bönniʼ yudoʼ naʼ, rnnëʼ: —Unábitsöquiʼdaʼ libíʼiliʼ tu didzaʼ. ¿Naruʼ dë lataj cateʼ naca dza láʼayi gunruʼ le naca dxiʼa o gunruʼ le ruáʼ döʼ? ¿Naruʼ dë lataj uguélaʼruʼ yöl-laʼ naʼbán quégaca bönachi, o ugúaruʼ le? ");
INSERT INTO zarNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Níʼirö buyúëʼ Jesús yúguʼtë bönniʼ naʼ nacuʼë gásibiʼilëʼ, ateʼ gudxëʼ bönniʼ huëʼ naʼ: —Bulí noʼo. Bulí nëʼë bönniʼ naʼ, ateʼ laʼ böácatë nëʼë naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Níʼirö gulaʼlenëʼ bönniʼ yudoʼ naʼ, ateʼ gulún xtídzaʼgaquiëʼ laʼ légacasëʼ nacxi bi ilunëʼ queëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Dza niʼ guyijëʼ Jesús ga naca tu lu guíʼadoʼ. Bulidzëʼ Dios niʼ, ateʼ idú yëla bë́ʼlenëʼ Dios didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Cateʼ zaʼ reníʼ, bulidzëʼ yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ, ateʼ gurö́ëʼ chínnuëʼ para iláquiëʼ gubáz queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Bulidzëʼ: Simón, (lëʼ caʼ Pedro), Andrés, (bö́chëʼë Pedro), Jacobo, en Juan, en Felipe, en Bartolomé, ");
INSERT INTO zarNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, en Tomás, Jacobo, (zxíʼinëʼ Alfeo), Simón, (bönniʼ ruíʼi ládxëʼë yödzö queëʼ), ");
INSERT INTO zarNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, (bö́chëʼë Jacobo), en Judas Iscariote, (bönniʼ udödëʼ Jesús lu náʼagaquiëʼ bönniʼ ilútiëʼ Lëʼ). ");
INSERT INTO zarNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús bö́tjalenëʼ yuguʼ bönniʼ gubáz queëʼ naʼ lu guíʼadoʼ naʼ, ateʼ bilaʼdxinëʼ tu ga naca lachiʼ, ga niʼ nacuʼë ziánrö caʼ bönniʼ usëda queëʼ, ateʼ nacuáʼlen légaquiëʼ bönachi zián narúajgaca yúguʼtë yödzö luyú Judea, en yödzö Jerusalén, en yuguʼ yö́dzödoʼ dë́gaca raʼ nísadoʼ ga naʼ nacuáʼ yödzö Tiro, en yödzö Sidón. Bilaʼdxín bönachi ni ga niʼ para uluʼzë́ nágagaca xtídzëʼë Jesús, en uluʼhuöáca lu yödzöhuë́ʼ téʼeguequi. ");
INSERT INTO zarNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Buluʼhuöáquiëʼ caʼ bönniʼ niʼ taʼguíʼi taʼzáquiëʼ lu náʼagaca böʼ xihuiʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yúguʼtë bönachi zián naʼ tuíʼi ládxiʼgaca ilaʼgán Jesús tuʼ ruúnëʼ léguequi len yöl-laʼ huáca queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Níʼirö buyúëʼ Jesús yuguʼ bönniʼ usëda queëʼ nacuʼë niʼ, en gudxëʼ légaquiëʼ: —Bicaʼ ba libíʼiliʼ, réquibeʼeliʼ riyadzjaliʼ le naca queëʼ Dios, tuʼ gataʼ queë́liʼ lataj ga rinná bëʼë Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Bicaʼ ba libíʼiliʼ ridunliʼ le gunnëʼ Dios queë́liʼ, tuʼ huö́ljaliʼ. ’Bicaʼ ba libíʼiliʼ ribö́dxiliʼ tuʼ bi nadéliʼliʼ le naca tsahuiʼ, tuʼ huadxín dza uzxídxiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Bicaʼ ba libíʼiliʼ, tuʼ zaʼ dza cateʼ bitiʼ ilaʼléʼe bönachi libíʼiliʼ dxiʼa, en uluʼbéaj libíʼiliʼ ga nacuáʼ, en ilaʼnnë́ ziʼ queë́liʼ, en uluʼcáʼana cáʼasö le nazíʼi laliʼ ca tu le naca xihuiʼ tuʼ dáʼaliʼ nedaʼ, Bönniʼ Guljëʼ Bönachi. ");
INSERT INTO zarNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Buliʼsíʼ xibé dza naʼ, en buliʼdzeja, tuʼ naca zxön le guequi queë́liʼ yehuaʼ yubá. Lëscaʼ caní gulunëʼ xuz xtóʼogaca bönachi ni quégaquiëʼ bönniʼ guluʼë didzaʼ uláz queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Bicaʼ bayechiʼ libíʼiliʼ, dë yöl-laʼ tsahuiʼ queë́liʼ, tuʼ chidë́ le ruzíʼiliʼ xibé. ");
INSERT INTO zarNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Bicaʼ bayechiʼ libíʼiliʼ nuhuö́laj nudzéʼeliʼ naʼa, tuʼ huadunliʼ. ’Bicaʼ bayechiʼ libíʼiliʼ ruzxídxili naʼa, tuʼ huíʼiniliʼ, en cödxi yéchiʼliʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Bicaʼ bayechiʼ libíʼiliʼ taʼnnë́ yúguʼtë bönachi dxiʼa queë́liʼ. Lëscaʼ caní gulunëʼ xuz xtóʼoliʼ, gulaʼnnë́ʼ dxiʼa quégaquiëʼ bönniʼ gulaʼzíʼ yëʼë, gulaʼnnë́ʼ nácagaquiëʼ bönniʼ tuʼë didzaʼ uláz queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Gunnë́ʼ caʼ Jesús: —Libiʼiliʼ zóaliʼ ni, en riyö́niliʼ xtídzaʼa, reaʼ libíʼiliʼ: Guliʼdxíʼi nupa bitiʼ taʼléʼe libíʼiliʼ dxiʼa. Guliʼgún le naca dxiʼa quégaca nupa tuʼdíʼi libíʼiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Guliʼnabi Dios gaca dxiʼa quégaca nupa tuaʼ döʼ queë́liʼ, en buliʼlidzëʼ Dios inábiliʼ-nëʼ gácalenëʼ nupa taʼnnë́ ziʼ queë́liʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Channö nu capaʼ tsöláʼa xaguʼ, buzë́ iaʼtsöláʼa caʼ xaguʼ. Channö nu cúa lariʼ naxóa cúdzuʼu, bëʼ lataj cúa caʼ zxoʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nútiʼtës nu bi inaba le dë quiuʼ, bunödzaj que, ateʼ nu cúa le nequi quiuʼ, bitiʼ unabuʼ le. ");
INSERT INTO zarNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ca rë́ʼëniliʼ ilún bönachi queë́liʼ, lëscaʼ caní guliʼgún quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Channö nadxíʼisiliʼ nupa nadxíʼigaca libíʼiliʼ, ¿bizxi yöl-laʼ ba idéliʼliʼ? Lëscaʼ caní tunëʼ bönniʼ dul-laʼ, taʼdxíʼinëʼ nupa nadxíʼiguequi légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Channö runliʼ le naca dxiʼa quégacasö nupa tun dxiʼa queë́liʼ, ¿bizxi yöl-laʼ ba idéliʼliʼ? Lëscaʼ caní tunëʼ bönniʼ dul-laʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Channö runö́dzjaliʼ quégaca nupa runliʼ löza uluʼbíʼi queë́liʼ, ¿bizxi yöl-laʼ ba idéliʼliʼ? Lëscaʼ caní tunëʼ bönniʼ dul-laʼ, tuʼnödzjëʼ quégaca nupa tun dul-laʼ, tuʼ tunëʼ löza uluʼbíʼi quégaquiëʼ lë naʼ buluʼnödzjëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nedaʼ reaʼ libíʼiliʼ: Guliʼdxíʼi nupa bitiʼ taʼléʼe libíʼiliʼ dxiʼa, en guliʼgún le naca dxiʼa. Buliʼnödzaj quégaca bönachi sal-laʼ bitiʼ runliʼ löza nu ubíʼi queë́liʼ. Channö caní gunliʼ, zxön naca le gataʼ queë́liʼ, ateʼ gácaliʼ zxíʼini cazëʼ Dios, Nu nácatërö lo, tuʼ runëʼ Lëʼ le naca dxiʼa quégaca bönachi bitiʼ taʼyaza ládxiʼgaca, en quégaca bönachi tuáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Buliʼhuéchiʼ ládxiʼliʼ bönachi ca naʼ runëʼ Xúziliʼ Dios, ruhuéchiʼ ládxëʼë yúguʼtë bönachi. ");
INSERT INTO zarNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Gunnë́ʼ caʼ Jesús: —Bitiʼ ichugu bë́ʼëliʼ que luzáʼaliʼ, ateʼ cuntu nu ichugu bëʼ queë́liʼ. Bitiʼ cuéaj bë́ʼëliʼ que luzáʼaliʼ, ateʼ cuntu nu cuéaj bëʼ queë́liʼ. Buliʼniti lo luzáʼaliʼ, ateʼ Dios uniti lahuëʼ caʼ libíʼiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Buliʼnödzaj que luzáʼaliʼ, ateʼ Dios gunnëʼ queë́liʼ. Uluʼnödzjëʼ queë́liʼ le uluʼrixëʼ len tu guíʼina ribixi le naca idú, le naguirö, en naguí gate ga rëʼ, en zóaticaʼ gubá. Ca naca le ruríxiliʼ, laʼ cáʼasö urixëʼ Dios caʼ queë́liʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Bucúdzuʼë didzaʼ Jesús, rëʼ légaquiëʼ: —¿Naruʼ huácatsö nu bönniʼ lo chul-la ichë́ʼë iaʼtúëʼ bönniʼ lo chul-la? Bitiʼ caʼ gaca, tuʼ ilaʼbixëʼ iropëʼ tu lu yeru. ");
INSERT INTO zarNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Bitiʼ caʼ gácarëʼ lo tu bönniʼ usëda ca nu rusëdi lëʼ, pero cateʼ údxi izëdëʼ bönniʼ naʼ, gáquiëʼ ca naca nu naʼ rusëdi lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Bizx que ruyúʼ bë́budoʼ yuʼu guiö́j lahuëʼ böchiʼ luzóʼo, en bitiʼ riléʼenuʼ le zxön yuʼu guiö́j lo cazuʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Naruʼ huácatsö guíoʼ-nëʼ böchiʼ luzóʼo: “Bö́chaʼa, benna lataj cuejaʼ bë́budoʼ yuʼu guiö́j loʼ”, en bitiʼ riléʼenuʼ le zxön yuʼu guiö́j lo cazuʼ? Liʼ, bönniʼ ruluíʼisö tsahuiʼ cuinuʼ, guléaj zíʼalö le zxön yuʼu guiö́j lo cazuʼ, ateʼ níʼirö iléʼenuʼ dxiʼa para cuejuʼ bë́budoʼ yuʼu guiö́j lahuëʼ böchiʼ luzóʼo. ");
INSERT INTO zarNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Gunnë́ʼ caʼ Jesús: —Tu yaga dxiʼa bitiʼ cuía le naca cáʼasö. Lëscaʼ caní, tu yaga guíʼa bitiʼ gaca cuía le naca dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Caní naca, le ribía tu yaga naca bëʼ ca naca yaga naʼ. Bitiʼ ruchíbiruʼ le ribía yaga higo lu yaga yötsiʼ, en calëga lu bisequiʼ yötsiʼ bitiʼ ruchíbiruʼ le ribía lubá uva. ");
INSERT INTO zarNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tu bönniʼ dxiʼa ruʼë didzaʼ dxiʼa tuʼ yuʼu le naca dxiʼa icja ládxiʼdaʼahuëʼ, ateʼ didzaʼ xihuiʼ ruʼë bönniʼ xihuiʼ tuʼ yuʼu icja ládxiʼdaʼahuëʼ le xihuiʼ. Rinnë́ ruáʼaruʼ ca naca le yuʼu icja ládxiʼdoʼoruʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Gunnë́ʼ caʼ Jesús: —¿Bizx que rulídzaliʼ nedaʼ, rnnaliʼ: “Xantuʼ, Xantuʼ”, pero bitiʼ runliʼ ca rinná béʼedaʼ libíʼiliʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Uluíʼidaʼ libíʼiliʼ ca naca nu naʼ zaʼ quiaʼ, en riyöni xtídzaʼa, en run ca rnna xtídzaʼa. ");
INSERT INTO zarNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nu ni naca ca tu bönniʼ, cateʼ benëʼ lidxëʼ, guchö́ʼönëʼ ga rëʼ, en guléquiëʼ xilibi yuʼu ga naca lu guiö́j. Cateʼ bötaj yegu gubóʼo, guchö́ʼöna cuita yuʼu naʼ, pero bitiʼ guca uquínnaj le, tuʼ nulibi ga naca lu guiö́j. ");
INSERT INTO zarNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Naʼa, nu riyöni xtídzaʼa, en bitiʼ run ca rnna, nu ni naca ca tu bönniʼ benëʼ lidxëʼ ga naca lu yu cáʼasö. Bitiʼ benëʼ xilibi. Cateʼ guchö́ʼöna yegu gubóʼo cuita yuʼu naʼ, laʼ biguínnajtë, ateʼ gubixi dërö zöʼö que. ");
INSERT INTO zarNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Cateʼ Jesús budxi bë́ʼlenëʼ légaquiëʼ didzaʼ ni, guyáziëʼ yödzö Capernaum. ");
INSERT INTO zarNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Lu yödzö niʼ zoëʼ tu bönniʼ Roma rinná béʼenëʼ bönniʼ röjáquiëʼ gudil-la. Zóabiʼ biʼi huen dxin queëʼ nadxíʼideʼenëʼ-biʼ, ateʼ biʼi ni réʼebiʼ, en chirequi gátibiʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Cateʼ biyönnëʼ bönniʼ ni didzaʼ tuʼë bönachi ca naca queëʼ Jesús, laʼ gusö́l-laʼtëʼ bal-lëʼ bönniʼ gula tuʼzéajniʼinëʼ bönniʼ judío ga naʼ zoëʼ Jesús, tsöjö́taʼyugaquiëʼ lahuëʼ Lëʼ guídëʼ uduhuénëʼ-biʼ biʼi huen dxin queëʼ naʼ réʼebiʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bönniʼ gula tuʼzéajniʼinëʼ naʼ bilaʼdxinëʼ ga zoëʼ Jesús, ateʼ gulátaʼyuëʼ lahuëʼ idú ládxiʼgaquiëʼ, taʼnnë́ʼ: —Náquiëʼ lesacaʼ bönniʼ naʼ gunuʼ queëʼ lë ni, ");
INSERT INTO zarNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","tuʼ runëʼ bal bönachi uládz queë́ruʼ, en benëʼ tu yuʼu queë́ruʼ ga rudúbiruʼ rusë́daruʼ queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Níʼirö Jesús guyéajlenëʼ légaquiëʼ. Cateʼ chizóa ilaʼdxinëʼ lidxëʼ bönniʼ naʼ, lëʼ gusö́l-lëʼë bal-lëʼ böchiʼ luzë́ʼë ga zëʼë Jesús, ateʼ tëʼ Lëʼ: —Xan, rnnëʼ bönniʼ naʼ: “Bitiʼ uguíʼinuʼ, tuʼ cabí nacaʼ lesacaʼ tsáziuʼ lidxaʼ, ");
INSERT INTO zarNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","en bitiʼ nacaʼ lesacaʼ guídaʼ ga zuʼ. Que lë ni naʼ bitiʼ burúguidaʼ guídaʼ ga zuʼ. Bë́ʼësö didzaʼ, ateʼ huöácatëbiʼ biʼi huen dxin quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nedaʼ caʼ, zoa nu rinná beʼe nedaʼ, ateʼ nacuʼë caʼ bönniʼ röjáquiëʼ gudil-la rinná béʼedaʼ légaquiëʼ. Reaʼ-nëʼ tuëʼ: Guyéaj niʼ, ateʼ rejëʼ. Reaʼ-nëʼ iaʼtúëʼ: Gudá ni, ateʼ ridëʼ. Reaʼ-nëʼ caʼ huen dxin quiaʼ: Ben dxin ni, ateʼ runëʼ dxin naʼ.” ");
INSERT INTO zarNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Cateʼ biyönnëʼ Jesús didzaʼ ni, bubáninëʼ queëʼ bönniʼ naʼ, ateʼ buécjëʼ, en gudxëʼ bönachi naʼ záʼgaca cúdzuʼlëʼ, rnnëʼ: —Le nácatë reaʼ libíʼiliʼ, cuntu nu bönniʼ Israel bitiʼ röjxáquiʼdaʼ-nëʼ réajlëʼë quiaʼ ca réajlëʼë quiaʼ bönniʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Cateʼ buluʼdxinëʼ bönniʼ naʼ gusö́l-lëʼë bönniʼ rinná béʼenëʼ bönniʼ röjáquiëʼ gudil-la, gulaʼyáziëʼ ga naca lu yuʼu lidxëʼ, en bilaʼléʼenëʼ chiböácabiʼ biʼi huen dxin naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Gudödi guca lë ni, saʼyéajëʼ Jesús yödzö Naín, ateʼ dzágagaquiëʼ bönniʼ usëda queëʼ Lëʼ, len bönachi zián. ");
INSERT INTO zarNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Cateʼ bidxinëʼ galaʼ raʼ yödzö naʼ, biléʼenëʼ yuguʼ bönniʼ nuáʼagaquiëʼ-biʼ tubiʼ biʼi bönniʼ nati. Söjcáchiʼgaquiëʼ-biʼ. Biʼi nati naʼ nácabiʼ laʼs dui biʼi queë́nu tu nigula uzë́bidoʼ. Zián bönachi uladza queë́nu nigula uzëbi naʼ söjácalen-nu. ");
INSERT INTO zarNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Cateʼ Xanruʼ biléʼenëʼ-nu, buéchiʼ ládxëʼë-nu, ateʼ gudxëʼ-nu: —Bítiʼrö cödxuʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Níʼirö gubíguiʼë Jesús, en gudanëʼ daʼa yaga ga naʼ dëbiʼ biʼi nati naʼ. Gulaʼbözëʼ bönniʼ naʼ nuáʼagaquiëʼ-biʼ, ateʼ Jesús gunnë́ʼ: —Biʼidoʼ, liʼ reaʼ, guyasa. ");
INSERT INTO zarNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Níʼirö bubanbiʼ. Gurö́ʼöbiʼ biʼi naʼ zíʼalö nátibiʼ, ateʼ gusí lobiʼ ruíʼibiʼ didzaʼ. Jesús budödëʼ-biʼ lu náʼanu xináʼabiʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Cateʼ bönniʼ niʼ bilaʼléʼenëʼ lë ni, guládxinëʼ yúguʼtëʼ, ateʼ gulaʼguʼë Dios yöl-laʼ ba, taʼnnë́ʼ: —Bidxín queë́ruʼ tu bönniʼ lo, ruʼë didzaʼ uláz queëʼ Dios. Dios caz rácalenëʼ bönachi queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Guzë́ didzaʼ ca naca yöl-laʼ huáca queëʼ Jesús, ateʼ bilaʼyöni bönachi yúguʼtë yödzö luyú Judea, en yúguʼtë yödzö idú gásibiʼilö. ");
INSERT INTO zarNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Bönniʼ dáʼgaquiëʼ Juan gulaʼguíxjöiʼinëʼ lëʼ yúguʼtë lë ni runëʼ Jesús. Niʼ yuʼë Juan lidxi guíë, bulidzëʼ chopëʼ bönniʼ naʼ dáʼgaquiëʼ lë, ");
INSERT INTO zarNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ateʼ gusö́l-lëʼë légaquiëʼ ga naʼ zoëʼ Jesús para ilaʼnábinëʼ Lëʼ, ilaʼnnë́ʼ: “¿Nacuʼ Liʼ Cristo, bönniʼ ral-laʼ guídëʼ, o naruʼ ral-laʼ cöztuʼ-nëʼ bönniʼ yúbölö?” ");
INSERT INTO zarNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Cateʼ bilaʼdxinëʼ bönniʼ naʼ nasö́l-lëʼë Juan ga naʼ zoëʼ Jesús, tëʼ Lëʼ: —Juan, bönniʼ buquilëʼ bönachi nisa, nasö́l-lëʼë netuʼ para inábituʼ Liʼ, innatuʼ: “¿Nacuʼ Liʼ Cristo, bönniʼ naʼ ral-laʼ guídëʼ, o naruʼ ral-laʼ cöztuʼ-nëʼ bönniʼ yúbölö?” ");
INSERT INTO zarNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Laʼ náʼasö ruúnëʼ Jesús zián nupa teʼe, yuguʼ bönniʼ huëʼ, en bönniʼ yúʼugaca légaquiëʼ böʼ xihuiʼ, ateʼ zián bönniʼ lo chul-la busaljëʼ guiö́j lógaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Bubiʼë didzaʼ Jesús, rëʼ chopëʼ bönniʼ naʼ nasö́l-lëʼë Juan, rnnëʼ: —Guliʼtséaj, guliʼtsöjtíxjöiʼi-nëʼ Juan ca naca le biléʼeliʼ, en le biyö́niliʼ. Tuʼléʼenëʼ bönniʼ guchul-la lógaquiëʼ. Tuʼzë́ʼë bönniʼ gulatsjëʼ. Nuhuöácagaquiëʼ bönniʼ güíʼiguequinëʼ huëʼ nudzuʼ ruzödi. Tuʼyö́nnëʼ bönniʼ gulaʼcö́dzuëʼ. Nubángaquiëʼ bönniʼ gulátiëʼ. Taʼyönnëʼ bönniʼ yechiʼ didzaʼ dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Bicaʼ ba nu bitiʼ gaca chopa ladxiʼ, ateʼ zaʼlen nedaʼ sal-laʼ bitiʼ runaʼ ca réqui nu naʼ ral-laʼ gunaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Cateʼ bönniʼ naʼ gusö́l-lëʼë Juan buluʼzë́ʼë niʼ, gusí lahuëʼ Jesús ruluíʼinëʼ bönachi niʼ ca naca queëʼ Juan naʼ, rnnëʼ: —¿Bizxi birúajliʼ yöjyuliʼ lu lataj cáʼasö? ¿Naruʼ birúajliʼ yöjyuliʼ tu gui rutá böʼ recja le? ");
INSERT INTO zarNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Bizxi caz birúajliʼ yöjyuliʼ? ¿Naruʼ birúajliʼ yöjyuliʼ-nëʼ tu bönniʼ nácuëʼ lariʼ nazácaʼdeʼe? Nöz quéziliʼ nupa nácugaca lariʼ nazácaʼdeʼe, en tuʼzíʼ xibé yöl-laʼ tsahuiʼ, nacuáʼ lídxigaquiëʼ bönniʼ taʼnná bëʼë. ");
INSERT INTO zarNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Bizxi caz birúajliʼ yöjyuliʼ? ¿Naruʼ birúajliʼ yöjyuliʼ-nëʼ tu bönniʼ ruʼë didzaʼ uláz queëʼ Dios? Ön, reaʼ libíʼiliʼ, ateʼ nayë́pisëtërëʼ ca nu ruíʼi didzaʼ uláz queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Náquiëʼ Juan bönniʼ naʼ nazúaj lu guichi láʼayi ca naca queëʼ, rnna: Buyútsöcaʼ, risö́l-laʼa-nëʼ gubáz quiaʼ, inö́ruëʼ ca Liʼ. Bönniʼ ni uchiʼë nöza ga töduʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","’Nedaʼ reaʼ libíʼiliʼ: Gapa nacuáʼ bönachi, channö zoëʼ nu bönniʼ ruʼë didzaʼ uláz queëʼ Dios, bitiʼ nácarëʼ lo ca Juan, bönniʼ naʼ buquilëʼ bönachi nisa, pero nu nácatërö cuídiʼsö ga rinná bëʼë Dios nayë́pisëtërö ca Juan naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Cateʼ bönachi niʼ, en bönniʼ tuʼquizxjëʼ lázagaca bönachi bilaʼyönnëʼ didzaʼ ni bëʼë Juan, guléquibeʼenëʼ le naca tsahuiʼ lahuëʼ Dios, en bilaʼdilëʼ nisa lu nëʼë Juan, ");
INSERT INTO zarNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","pero yuguʼ bönniʼ yudoʼ fariseo, en bönniʼ yudoʼ tuʼsédinëʼ xibá queëʼ Moisés bitiʼ bilaʼdilëʼ nisa lu nëʼë Juan, ateʼ caní guca, buluʼcáʼanëʼ cáʼasö le gúʼunnëʼ Dios gunëʼ quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Gunnë́ʼ caʼ Xanruʼ: —¿Nacxi uséquiʼtsedaʼ bönachi nacuáʼ dza ni zóaruʼ naʼa? ¿Nacxi caz nácagaquiëʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nácagaquiëʼ ca bíʼidoʼ taʼguítjabiʼ. Taʼbö́ʼöbiʼ lu yë́ʼëyi, en taʼbö́dxiʼabiʼ. Taʼnnabiʼ tubiʼ iaʼtubiʼ: “Rucö́dxituʼ queë́liʼ gui, pero bitiʼ ruyáʼaliʼ. Rul-la yéchiʼtuʼ, pero bitiʼ ribö́dxiliʼ.” ");
INSERT INTO zarNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Caní nácaliʼ tuʼ bidëʼ Juan, bönniʼ buquilëʼ bönachi nisa, en bitiʼ gudahuëʼ yöta xtila, en bitiʼ guʼë xisi uva, ateʼ rnnaliʼ queëʼ: “Tuʼ xihuiʼ dzaga lëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Cateʼ bidaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, en rëʼaj rahuaʼ, rnnaliʼ quiaʼ: “Bönniʼ ni náquiëʼ bönniʼ huágulëʼë, en bönniʼ reʼjëʼ. Náquiëʼ luzáʼagaquiëʼ bönniʼ tuʼquizxjëʼ, en iaʼzícaʼrëʼ bönniʼ dul-laʼ.” ");
INSERT INTO zarNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Reaʼ libíʼiliʼ: Naca bëʼ nupa nápagaca yöl-laʼ réajniʼi queëʼ Dios niʼa que le túngaca. ");
INSERT INTO zarNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tu bönniʼ yudoʼ fariseo bulidzëʼ Jesús gágulenëʼ lëʼ tsözxö́n, ateʼ guyáziëʼ Jesús lidxëʼ bönniʼ naʼ, en guröʼë rahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Zóanu lu yödzö naʼ tu nigula udá dzaga, en cateʼ nö́zinu röʼë rahuëʼ Jesús lidxëʼ bönniʼ yudoʼ fariseo naʼ, níʼirö bidxinnu niʼ nuáʼanu tu bö́gaʼdoʼ néquini guiö́j nazacaʼ le yudzu tu le riláʼ zxixi. ");
INSERT INTO zarNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Cateʼ bidxinnu zacaʼ cúdzuʼlëʼ Jesús, gurö́ʼönu xiniʼë ribö́dxinu. Níʼirö gusí lonu rigúʼunu nisa ribö́dxinu niʼë Jesús, en ruzxinu niʼë len guitsaʼ ícjanu. Butsaga lonu niʼë, en gulúʼunu niʼë lë naʼ riláʼ zxixi. ");
INSERT INTO zarNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Cateʼ bönniʼ yudoʼ fariseo naʼ nulidzëʼ Jesús biléʼenëʼ lë ni, guzáʼ ládxëʼë, rnnëʼ: “Laʼtuʼ náquiëʼ bönniʼ ni bönniʼ ruʼë didzaʼ uláz queëʼ Dios, huéquibeʼenëʼ nuzxi naʼ, en nacxi nácanu nigula ni rigannu Lëʼ, tuʼ nácanu nigula udá dzaga.” ");
INSERT INTO zarNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Níʼirö Jesús gudxëʼ bönniʼ fariseo naʼ, rnnëʼ: —Simón, dë tu le ral-laʼ guíaʼ liʼ. Bubiʼë didzaʼ bönniʼ naʼ, rnnëʼ: —Gunná, Bönniʼ Usedi. ");
INSERT INTO zarNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús rëʼ lëʼ: —Zoëʼ tu bönniʼ dë dumí queëʼ, ateʼ nacuʼë chopëʼ bönniʼ tál-lëʼë dumí queëʼ. Tuëʼ bönniʼ naʼ ral-lëʼë queëʼ lazxjëʼ que chopa iz, ateʼ iaʼtúëʼ naʼ ral-lëʼë queëʼ lazxjëʼ que chopa beoʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tuʼ cabí dë quégaquiëʼ dumí uluʼguízxjëʼ lë naʼ tál-lëʼë queëʼ, que lë ni naʼ buniti lahuëʼ iropëʼ lë naʼ tál-lëʼë queëʼ. Gunnátsöcaʼ naʼa. ¿Núzxilëʼ bönniʼ chopëʼ ni idxíʼirönëʼ bönniʼ naʼ buniti lahuëʼ légaquiëʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Bubiʼë didzaʼ Simón naʼ, rnnëʼ: —Réquidaʼ nedaʼ, bönniʼ naʼ rálaʼrëʼ queëʼ dumí, lë naʼ buniti lahuëʼ. Jesús gudxëʼ lëʼ: —Le nácasö rnnoʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Níʼirö buécjëʼ Jesús, ateʼ niʼ ruyúëʼ-nu nigula naʼ, rëʼ Simón: —¿Naruʼ riléʼenuʼ nigula ni? Guyáziaʼ lidxuʼ, ateʼ bitiʼ bennuʼ quiaʼ nisa quíbidaʼ niʼa, pero nigula ni gulúʼunu niʼa nisa ribö́dxinu, en buzxinu niʼa len guitsaʼ ícjanu. ");
INSERT INTO zarNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Bitiʼ butsaga loʼ nedaʼ, pero cateʼ bidxínteaʼ lidxuʼ, bitiʼ ruzóa dxinu nigula ni, rutsaga lonu niʼa. ");
INSERT INTO zarNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Bitiʼ gulúʼu icjaʼ le za, pero nigula ni gulúʼunu niʼa lë naʼ riláʼ zxixi. ");
INSERT INTO zarNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Que lë ni naʼ reaʼ liʼ, dul-laʼ zián gubágaʼnu nigula ni, chiguyúʼu yöl-laʼ runiti lo quéguequi, ateʼ nadxíʼideʼenu nedaʼ. Nu naʼ Dios runiti lahuëʼ le látiʼdoʼos, látiʼdoʼos nadxíʼi Dios nu naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Níʼirö Jesús gudxëʼ-nu nigula naʼ, rnnëʼ: —Dul-laʼ gubáguʼu chiguyúʼu yöl-laʼ runiti lo que. ");
INSERT INTO zarNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Yuguʼ bönniʼ naʼ taʼbö́ʼlenëʼ Jesús tahuëʼ gulaʼsí lógaquiëʼ tëʼ luzáʼagaquiëʼ, taʼnnë́ʼ: —¿Nuzxi caz bönniʼ ni, runiti lotsëʼ caʼ dul-laʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Níʼirö Jesús gudxëʼ-nu nigula naʼ, rnnëʼ: —Tuʼ réajlëʼu nedaʼ, chibulóʼ liʼ. Böaj lidxuʼ, zoa dxi ládxuʼu. ");
INSERT INTO zarNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Gudödi gulaca lë ni, gudë́ʼ Jesús gapa nacuáʼ zián yödzö zxön, en yuguʼ yö́dzödoʼ, ateʼ benëʼ libán niʼ, en bëʼë didzaʼ que didzaʼ dxiʼa ca rinná bëʼë Dios, ateʼ idxínnutëʼ bönniʼ usëda queëʼ dzágagaquiëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Bál-lanu nigula bunëʼ Jesús légacanu dzágagacanu caʼ Lëʼ. Bubéajëʼ böʼ xihuiʼ yúʼugaca légacanu, en bugǘëʼ yuguʼ yödzöhuë́ʼ güíʼiguequinu. Nútsaʼnu ládjagacanu María, lënu caʼ Magdalena, nigula naʼ bubéajëʼ gadxi böʼ xihuiʼ yúʼugaca lënu. ");
INSERT INTO zarNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Juana, nigula queëʼ Chuza, bönniʼ yuʼu lu nëʼë le dë lidxëʼ Herodes, nútsaʼnu caʼ ládjagacanu, ateʼ cáʼanqueze Susana nútsaʼnu caʼ légacanu. Taʼgúʼunu nigula ni, en ziánrönu caʼ, le tahuëʼ Jesús, en yuguʼ bönniʼ usëda queëʼ. Tuʼnö́dzjanu le dë quégacanu. ");
INSERT INTO zarNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bilaʼrúaj bönachi zián yuguʼ yödzö niʼ, en biláʼgaca ga naʼ zoëʼ Jesús. Cateʼ buluʼdubëʼ ga naʼ zoëʼ, Lëʼ bucúdzuʼë didzaʼ, rëʼ légaquiëʼ: ");
INSERT INTO zarNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Birúajëʼ bönniʼ guz, söjë́siëʼ xisedoʼ. Cateʼ niʼ söjë́siëʼ, buluʼhuöxaj bal-la xisedoʼ naʼ ga naca laʼ nöza, ateʼ buluʼlibi bönachi léguequi. Bilaʼdxinbaʼ caʼ biguínnidoʼ, en gulë́ʼajbaʼ xisedoʼ naʼ dzöʼö laʼ nöza. ");
INSERT INTO zarNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Buluʼhuöxaj iaʼbal-la xisedoʼ naʼ lu yu ga röʼö guiö́j. Cateʼ gulaʼlén xisedoʼ naʼ, laʼ gulaʼbídxitë tuʼ cabí nalupaʼ yu naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Buluʼhuöxaj iaʼbal-la xisedoʼ naʼ ga buluʼlén lubá yötsiʼ. Tsözxö́n gulaʼzxö́n lubá yötsiʼ naʼ, en xisedoʼ naʼ, ateʼ lubá yötsiʼ naʼ bilaʼröli xisedoʼ naʼ gulaʼlén, en gulún ditaj léguequi. ");
INSERT INTO zarNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Buluʼhuöxaj iaʼbal-la xisedoʼ naʼ ga naca luyú bëbu. Cateʼ chigulaʼzxö́n, buluʼnödzaj. Tu dxiguʼ naʼ bunödzaj iaʼtú gayuáʼtërö xisedoʼ caʼ. Cateʼ budxi gunnë́ʼ caní Jesús, bëʼë zidzaj didzaʼ, rnnëʼ: —¡Nu zoa nagui, en riyöni ral-laʼ uzë́ nagui! ");
INSERT INTO zarNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Níʼirö yuguʼ bönniʼ usëda queëʼ Jesús gulaʼnábinëʼ Lëʼ, taʼnnë́ʼ: —¿Bizxi saʼyéaj lë naʼ bucúdzuʼu didzaʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús gudxëʼ légaquiëʼ: —Dios ruzéajniʼinëʼ libíʼiliʼ le nagachiʼ ca rinná bëʼë Lëʼ, pero iaʼzícaʼrö bönachi ni, ruíʼilenaʼ léguequi didzaʼ le rucúdzuʼa didzaʼ para cateʼ uluʼyúëʼ, bitiʼ ilaʼléʼenëʼ, en cateʼ ilaʼyönnëʼ, bitiʼ ilaʼyéajniʼinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Gunnë́ʼ caʼ Jesús: —Caní naca le ruluíʼi lë naʼ bucúdzuʼa didzaʼ. Xisedoʼ naʼ naca xtídzëʼë Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Xisedoʼ naʼ buluʼhuöxaj laʼ nöza tuʼluíʼi ca raca quégaca bönniʼ taʼyönnëʼ didzaʼ naʼ, pero laʼ zaʼtë tuʼ xihuiʼ, en rigúa didzaʼ naʼ bidxín lu icja ládxiʼdoʼgaquiëʼ, para cabí ilaʼyéajlëʼë, en cabí uluʼlë́ʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Xisedoʼ naʼ buluʼhuöxaj lu yu ga röʼö guiö́j tuʼluíʼi ca raca quégaquiëʼ bönniʼ taʼyönnëʼ didzaʼ naʼ, en tuʼdzéjanëʼ taʼziʼë le, pero nácagaquiëʼ ca xisedoʼ naʼ bitiʼ ben lui. Tu chíʼisö taʼyéajlëʼë, tuʼ ridxín le rizíʼ bëʼ légaquiëʼ, ateʼ laʼ tuʼhuö́atë ládxiʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Xisedoʼ naʼ buluʼhuöxaj ga buluʼlén lubá yötsiʼ tuʼluíʼi ca raca quégaquiëʼ bönniʼ taʼyönnëʼ didzaʼ naʼ, en cateʼ chibilaʼyönnëʼ, yuguʼ le tuíʼi ládxiʼgaquiëʼ yödzölió ni, en yuguʼ yöl-laʼ tsahuiʼ que, en yuguʼ le taʼyaza ládxiʼgaquiëʼ le taca ni, tun nigui légaquiëʼ, ateʼ bitiʼ run dxin didzaʼ naʼ lu icja ládxiʼdoʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Xisedoʼ naʼ buluʼhuöxaj ga naca luyú bëbu tuʼluíʼi ca raca quégaquiëʼ bönniʼ, idú ládxiʼgaquiëʼ taʼyönnëʼ didzaʼ naʼ, en taʼguʼë tsutsu le lu icja ládxiʼdoʼgaquiëʼ, ateʼ lu yöl-laʼ riböza zxön ladxiʼ tunëʼ ca rnna didzaʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Gunnë́ʼ caʼ Jesús: —Cuntu nu bönniʼ ruquélëʼë guíʼ, ateʼ laʼ rudúsiʼtëʼ le guíʼina, en bitiʼ riguʼë le zxani le rátiʼnëʼ, pero ruzóëʼ le xilataj ga naca lináʼ lu yuʼu, ateʼ nupa ilaʼyaza niʼ uluʼzíʼ xibé guíʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Iláʼ lahui yúguʼtë le nagachiʼ, ateʼ gaca bëʼ, ateʼ irúaj ga lináʼ yúguʼtë le raca balándoʼos. ");
INSERT INTO zarNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Que lë ni naʼ, buliʼzë́ nágaliʼ, tuʼ huadéliʼnëʼ iaʼlatiʼ bönniʼ ruzóëʼ tsutsu icja ládxiʼdaʼahuëʼ didzaʼ riyönnëʼ, en huaziʼrëʼ xtídzëʼë Dios, pero bönniʼ bitiʼ ruzóëʼ tsutsu icja ládxiʼdaʼahuëʼ didzaʼ riyönnëʼ, huadúa didzaʼ naʼ biyönnëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Níʼirö bilaʼdxinëʼ xinë́ʼë Jesús, en yuguʼ bönniʼ bö́chëʼë ga naʼ zoëʼ, pero bitiʼ guca ilaʼbíguëʼë galaʼ ga zoëʼ tuʼ nacuáʼ bönachi zián niʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Zoa niʼ nu bulidza Jesús, rnna: —Nacuʼë xinóʼo, en yuguʼ bönniʼ bö́chuʼu löʼa. Të́ʼënnëʼ iluíʼilenëʼ Liʼ didzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Bubiʼë didzaʼ Jesús, rëʼ légaquiëʼ: —Nupa ni taʼyöni xtídzëʼë Dios, en tun ca rnna, bönniʼ ni nácagaquiëʼ ca xináʼ cazaʼ, en yuguʼ bönniʼ böchiʼ cazaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tu dza gurenëʼ Jesús tu lëʼe bárcodoʼ, dzágagaquiëʼ bönniʼ usëda queëʼ Lëʼ, ateʼ Jesús rëʼ légaquiëʼ: —Udö́ditsöcaʼruʼ iaʼtsöláʼa nísadoʼ ni. Níʼirö söjácatëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tsanni niʼ taʼdödëʼ lu nísadoʼ naʼ, rásiëʼ Jesús. Níʼirö gusí lo recja böʼ budunuʼ lu nísadoʼ naʼ, ateʼ chirequi huötaj bárcodoʼ naʼ zxan nisa, en zoa bönadxi quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Níʼirö gulaʼbiguëʼë ga dëʼ Jesús, en buluʼsubanëʼ Lëʼ, taʼnnë́ʼ: —¡Bönniʼ Usedi! ¡Bönniʼ Usedi! ¡Chirequi huö́tjaruʼ lu nisa! Cateʼ bubanëʼ Jesús, bulidzëʼ böʼ naʼ recja, en nisa naʼ riyasa ridxíadaʼ, ateʼ guzóa dxi böʼ naʼ recja, en gurö́ʼö dxi lu nísadoʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Níʼirö Jesús gudxëʼ yuguʼ bönniʼ usëda queëʼ, rnnëʼ: —¿Naruʼ cabí réajlëʼëliʼ Dios? Guládxinëʼ légaquiëʼ, en tuʼbáninëʼ. Gulë́ luzáʼagaquiëʼ tuëʼ iaʼtúëʼ: —¿Nuzxi caz bönniʼ ni? Rinná béʼenëʼ böʼ recja, en nísadoʼ, ateʼ tun ca rnna xtídzëʼë. ");
INSERT INTO zarNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Níʼirö bilaʼdxinëʼ lu xiyúgaquiëʼ bönniʼ Gadara, le dë iaʼtsöláʼa nísadoʼ ca dö́dilö ga dë luyú Galilea. ");
INSERT INTO zarNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Cateʼ birúajëʼ Jesús lëʼe bárcodoʼ naʼ ga naca lu yu naʼ, dutságuiëʼ tu bönniʼ yödzö naʼ Lëʼ. Chigudzé yuʼu böʼ xihuiʼ lëʼ, ateʼ bítiʼrö rácuëʼ lariʼ, en bítiʼrö rizóëʼ lu yuʼu, pero nun xilatjëʼ lu zxan bulóaj ga nádjagaca yeru ba. ");
INSERT INTO zarNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Cateʼ bönniʼ naʼ yuʼu böʼ xihuiʼ lëʼ biléʼenëʼ Jesús, gurö́dxiʼë zidzaj, ateʼ buzóa zxibëʼ lahuëʼ Jesús, en bëʼë zidzaj didzaʼ, rnnëʼ: —¿Bizxi ral-laʼa quiuʼ, Jesús, Zxíʼinëʼ Dios nayë́pisëtërëʼ? Rátaʼyuaʼ loʼ cabí usacaʼ ziʼu nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Caní gunnë́ʼ tuʼ chigunná béʼenëʼ Jesús böʼ xihuiʼ naʼ urúaj lu bönniʼ naʼ. Zián luzuí zíʼatëlö burixi butúludaʼ böʼ xihuiʼ naʼ bönniʼ naʼ, ateʼ yuguʼ bönniʼ yödzö niʼ gulúguiʼë lëʼ du guíë, en buluʼxéjanëʼ breguiʼ guíë niʼa nëʼë, pero blëʼë yuguʼ du guíë naʼ, ateʼ böʼ xihuiʼ naʼ yuʼu lëʼ guchë́ʼ lëʼ lu lataj cáʼasö. ");
INSERT INTO zarNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Níʼirö Jesús gunábinëʼ böʼ xihuiʼ naʼ, rnnëʼ: —¿Bi leuʼ? Böʼ xihuiʼ naʼ gudxi Lëʼ: —Le Zián leaʼ. Caní gunná tuʼ yúʼugaca böʼ xihuiʼ zián bönniʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Níʼirö yuguʼ böʼ xihuiʼ naʼ gulátaʼyugaca lahuëʼ Jesús cabí isö́l-lëʼë léguequi lataj chul-la quégaca nupa nátigaca. ");
INSERT INTO zarNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nacuáʼabaʼ caʼ tu cö́ʼöbaʼ cuchi zián taʼdabaʼ tágubaʼ lu guíʼadoʼ niʼ, ateʼ böʼ xihuiʼ naʼ gulaʼnaba yechiʼ Jesús guʼë léguequi lataj tsöjtsúʼugaca cuchi zián naʼ. Jesús bëʼë léguequi lataj. ");
INSERT INTO zarNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Buluʼrúaj yuguʼ böʼ xihuiʼ lu bönniʼ naʼ, en yöjtsúʼugaca cuchi zián naʼ, ateʼ yöjácabaʼ cuchi zián naʼ ga naca tu lëʼe guiö́j. Yöjbíxigacabaʼ lu nísadoʼ, ateʼ niʼ gulaʼyë́pibaʼ nisa, gulátibaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Cateʼ bilaʼléʼenëʼ bönniʼ tuʼyúgaquiëʼ-baʼ cuchi zián naʼ ca naʼ guca quégacabaʼ, guladxi gulaʼdzö́binëʼ. Buluʼzxúnnajëʼ niʼ, ateʼ yöjhuö́jgaquiëʼ yöjtíxjöiʼiguequinëʼ nupa nacuáʼ yödzö naʼ, en nupa nacuáʼ laʼ guixiʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Níʼirö bilaʼrúajëʼ bönniʼ yödzö naʼ, yöjyúgaquiëʼ lë naʼ guca. Cateʼ bilaʼdxinëʼ ga naʼ zoëʼ Jesús, bilaʼléʼenëʼ bönniʼ naʼ gulaʼyúʼu böʼ xihuiʼ lëʼ, röʼë xiniʼë Jesús. Nácuëʼ lariʼ, en dxíʼadoʼ chizóëʼ, ateʼ guládxinëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nupa naʼ bilaʼléʼe lë naʼ guca gulaʼguíxjöiʼi légaquiëʼ ca guca, böáquiëʼ bönniʼ naʼ gulaʼyúʼu böʼ xihuiʼ lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Níʼirö yúguʼtë bönachi zián naʼ quégaca yödzö nabábagaca Gadara naʼ gulátaʼyu lahuëʼ Jesús urúajëʼ lu xiyúguequi, tuʼ tádxinëʼ. Bubenëʼ Jesús lëʼe bárcodoʼ naʼ, en söhuö́jëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Bönniʼ naʼ buluʼrúaj böʼ xihuiʼ naʼ lëʼ gútaʼyuëʼ lahuëʼ Jesús guʼë lëʼ lataj tséajlenëʼ Lëʼ tsözxö́n. Gunná béʼenëʼ Jesús lëʼ ugáʼanëʼ niʼ, rnnëʼ: ");
INSERT INTO zarNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Böaj lidxuʼ. Yöjtíxjöiʼi bönachi uládz quiuʼ yuguʼ le zxön benëʼ Dios quiuʼ. Bö́ajëʼ bönniʼ naʼ lidxëʼ, ateʼ buzë́ʼ didzaʼ idú lu yödzö niʼ ca naca le zxön benëʼ Jesús queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Cateʼ budxinëʼ Jesús iaʼtsöláʼa nísadoʼ naʼ, buluʼdzeja bönachi zián nacuáʼ niʼ niʼa queëʼ Lëʼ, tuʼ taʼböza Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Níʼirö bidxinëʼ Jairo ga zoëʼ Jesús. Náquiëʼ bönniʼ lo que yuʼu ga tuʼdubëʼ bönniʼ judío, en tuʼsëdëʼ queëʼ Dios. Biyéchuëʼ xiniʼë Jesús, en gútaʼyuëʼ lahuëʼ tsejëʼ lidxëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Caní benëʼ tuʼ zóabiʼ tubiʼ biʼi nigula queëʼ, chirequi gátibiʼ. Nácabiʼ biʼi laʼs dui queëʼ, en yúʼubiʼ ca chinnu iz. Tsanni niʼ saʼyéajëʼ Jesús, sönógaca tuʼquirö bönachi zián Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nútsaʼnu tu nigula ladaj bönachi zián naʼ, chiguca chinnu iz riguíʼi rizácaʼnu. Bitiʼ ruhuíʼi rön queë́nu que huëʼ quégaca cázanu nigula, ateʼ chibutönu dëra le dë queë́nu, riguízxjanu nupa tuʼún bönachi, pero bitiʼ guca nu bönniʼ únëʼ-nu. ");
INSERT INTO zarNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Gubígaʼnu zacaʼ cúdzuʼlëʼ Jesús, en gudannu ruíʼi lariʼ nácuëʼ, ateʼ laʼ buíʼitë huëʼ rön queë́nu. ");
INSERT INTO zarNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Níʼirö Jesús gunábinëʼ nupa nacuáʼ niʼ, rnnëʼ: —¿Nuzxi naʼ gudán nedaʼ? Gulaʼdáʼbaguiʼë yúguʼtëʼ. Níʼirö Pedro, en nupa nacuáʼlen lëʼ gulë́ʼ Lëʼ, taʼnnë́ʼ: —Bönniʼ Usedi, nacuáʼ bönachi zián ni, tuʼquirö Liʼ, en tuʼdxigaʼ Liʼ, ateʼ ¿rnnatsoʼ: “¿Nuzxi naʼ gudán nedaʼ?” ");
INSERT INTO zarNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Níʼirö Jesús gunnë́ʼ: —Zoa nu gudán nedaʼ, tuʼ gúquibeʼedaʼ birúaj yöl-laʼ huáca nedaʼ le ruún bönachi. ");
INSERT INTO zarNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Cateʼ réquibeʼenu nigula naʼ nö́zinëʼ Jesús le bennu, níʼirö guzxízinu. Biyéchunu xiniʼë Jesús, en gudíxjöiʼinu Lëʼ lógaca bönachi zián naʼ bizx que naʼ gudannu lariʼ nácuëʼ, en ca naʼ guca, laʼ böácatënu. ");
INSERT INTO zarNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Níʼirö Jesús gudxëʼ-nu: —Nigúladoʼ, tuʼ réajlëʼu nedaʼ chiböácuʼ. Böaj lidxuʼ, zoa dxi ládxuʼu. ");
INSERT INTO zarNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Cateʼ niʼ ruʼë Jesús didzaʼ ni, bidxinëʼ tu bönniʼ niʼ, zëʼë lidxëʼ bönniʼ lo naʼ que yuʼu ga tuʼdubëʼ tuʼsëdëʼ queëʼ Dios, ateʼ gudxëʼ bönniʼ lo naʼ: —Chigútibiʼ biʼi nigúladoʼ quiuʼ. Bítiʼrö upízxjanuʼ-nëʼ Bönniʼ Usedi. ");
INSERT INTO zarNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Cateʼ biyönnëʼ Jesús lë ni, bubiʼë didzaʼ, rëʼ bönniʼ lo naʼ: —Bitiʼ gádxinuʼ. Guyéajlëʼësö Dios. Huöácabiʼ biʼi nigúladoʼ quiuʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Cateʼ guyáziëʼ Jesús yuʼu naʼ, bitiʼ bëʼë lataj nu tsázalen Lëʼ, pero légacasëʼ Pedro, en Jacobo, en Juan, encaʼ xuz xináʼabiʼ nigúladoʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Taʼbödxi nupa nacuáʼ niʼ. Taʼbödxi yechë́ʼë niʼa queë́biʼ biʼi nigúladoʼ naʼ, ateʼ Jesús rëʼ légaquiëʼ, rnnëʼ: —Bítiʼrö cö́dxiliʼ. Bitiʼ nátibiʼ nigúladoʼ ni. Rásisibiʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Buluʼtitjëʼ Lëʼ tuʼ nö́zguequinëʼ chinátibiʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Níʼirö gudélëʼë Jesús náʼabiʼ, en bëʼë zidzaj didzaʼ, rnnëʼ: —Biʼi nigúladoʼ, guyaschi. ");
INSERT INTO zarNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Níʼirö buʼu böʼ naca cázabiʼ, bubanbiʼ, ateʼ laʼ guyásatëbiʼ. Jesús gunná béʼenëʼ légaquiëʼ iluʼë le gágubiʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Buluʼbáninëʼ xuz xináʼabiʼ, pero Jesús gunná béʼenëʼ légaquiëʼ cuntu nu ilë́ʼ ca naʼ guca. ");
INSERT INTO zarNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Níʼirö butubëʼ Jesús idxínnutëʼ bönniʼ usëda queëʼ, ateʼ budödëʼ lu náʼagaquiëʼ yöl-laʼ huáca, en yöl-laʼ unná bëʼ para uluʼbéajëʼ böʼ xihuiʼ yúʼugaca bönachi, en uluʼúnëʼ nupa teʼe. ");
INSERT INTO zarNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Gusö́l-lëʼë légaquiëʼ tsöjéngaquiëʼ libán ca rinná bëʼë Dios, en tsöjhuéngaquiëʼ nupa teʼe. ");
INSERT INTO zarNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jesús gudxëʼ légaquiëʼ: —Bitiʼ bi guáʼaliʼ para laʼ nöza, calëga xiyágadoʼ, en calëga yöxaj, en calëga yöta, en calëga dumí, en bitiʼ ixóa yenliʼ chopa lariʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Bítiʼtës yuʼu ga tsúʼuliʼ, guliʼsóa niʼ cateʼ uzáʼaröliʼ yödzö naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Gátiʼtës ga bitiʼ ilún bönachi libíʼiliʼ bal, buliʼrúaj yödzö naʼ, en guliʼcuíbi bëchtö daʼ lëʼe lábaliʼ, le uluíʼi légaquiëʼ nagáʼana xíguiaʼ nabágaʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Níʼirö bilaʼrúajëʼ bönniʼ usëda queëʼ naʼ. Gulaʼdödëʼ yúguʼtë yö́dzödoʼ, tunëʼ libán que didzaʼ dxiʼa, en tuʼúnëʼ nupa teʼe yúguʼtë lu yödzö naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Biyönnëʼ Herodes, bönniʼ rinná bëʼë, ca naca yúguʼtë le runëʼ Jesús, ateʼ guröʼë böniga, tuʼ taʼnná bönachi: —Juan naʼ chibubanëʼ lu yöl-laʼ guti. ");
INSERT INTO zarNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Iaʼbal-lëʼ taʼnnë́ʼ: —Chibulë́ʼë Elías, bönniʼ naʼ bëʼë didzaʼ uláz queëʼ Dios. Iaʼbal-lëʼ taʼnnë́ʼ: —Chibubanëʼ tu bönniʼ bítsëʼë yuguʼ bönniʼ guluʼë didzaʼ uláz queëʼ Dios dza niʼte. ");
INSERT INTO zarNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes naʼ gunnë́ʼ: —Juan naʼ burixaʼ yenëʼ. ¿Nuzxi caz bönniʼ ni, riyöndaʼ queëʼ runëʼ yuguʼ lë ni? Rizóa riböʼë Herodes iléʼenëʼ Jesús. ");
INSERT INTO zarNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Cateʼ buluʼdxinëʼ bönniʼ gubáz nasö́l-lëʼë Jesús ga zoëʼ Lëʼ, buluʼsiyönnëʼ Lëʼ yúguʼtë le gulunëʼ. Níʼirö guchë́ʼë Jesús légaquiëʼ quez. Yöjáquiëʼ tu lataj cáʼasö lu xiyú yödzö Betsaida. ");
INSERT INTO zarNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Cateʼ chinö́ziguequi bönachi lë ni, yöjnóguequi Lëʼ, ateʼ Jesús benëʼ léguequi bal, en bë́ʼlenëʼ léguequi didzaʼ ca rinná bëʼë Dios, ateʼ bunëʼ nupa teʼe. ");
INSERT INTO zarNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Cateʼ chizáʼ ral-la dza naʼ, idxínnutëʼ bönniʼ gubáz queëʼ Jesús gulaʼbíguëʼë ga zoëʼ, en tëʼ Lëʼ: —Busöl-laʼ bönachi ni tsöjaca gapa dë yö́dzödoʼ, en gapa dë yúʼudoʼ idú gásibiʼilö para tsöjtíljagaquiëʼ gapa uluʼgáʼanëʼ, en bi ilahuëʼ, tuʼ naca lataj cáʼasö ga ni zóaruʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Níʼirö Jesús rëʼ légaquiëʼ: —Guliʼguʼë libíʼiliʼ le ilahuëʼ. Tëʼ Lëʼ: —Gáyuʼsö yöta xtíladoʼ dë, en chópasöbaʼ böla dëbaʼ queë́tuʼ, o ¿naruʼ huayéajtsatuʼ tsöjö́ʼöutuʼ le ilágugaca bönachi zián ni? ");
INSERT INTO zarNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nacuʼë ca chi-un gáyuʼë bönniʼ ga naʼ. Níʼirö Jesús gudxëʼ yuguʼ bönniʼ usëda queëʼ, rnnëʼ: —Guliʼgún ga ilaʼböʼë tu cöʼ huéajgaquiëʼ, ilaca ca chi-un huéajgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Caní gulunëʼ, ateʼ gulaʼböʼë yúguʼtëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Níʼirö gudélëʼë Jesús gayuʼ yöta xtila naʼ, en chópabaʼ böla naʼ, ateʼ guchisa lahuëʼ ruyúëʼ lúzxiba, en rëʼ Dios: “Xclenuʼ.” Níʼirö buzxuzxjëʼ léguequi, en bëʼë quégaquiëʼ bönniʼ usëda queëʼ para uluʼcuʼë lógaca bönachi naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Gulahuëʼ yúguʼtëʼ, en buluʼhuö́ljanëʼ. Gudödi naʼ buluʼtubëʼ yuguʼ bizxaj bugáʼana, ateʼ buluʼlíëʼ idú chinnu gaʼböra. ");
INSERT INTO zarNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tu dza tsanni niʼ zoëʼ quez Jesús, rulidzëʼ Dios, bilaʼdxinëʼ bönniʼ usëda queëʼ ga zoëʼ, ateʼ gunábinëʼ légaquiëʼ, rnnëʼ: —¿Nuzxi taʼnná bönachi nacaʼ nedaʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Buluʼbiʼë didzaʼ, taʼnnë́ʼ: —Taʼnná bal-la bönachi nacuʼ Juan, bönniʼ buquilëʼ bönachi nisa. Taʼnná iaʼbal-lëʼ nacuʼ Elías, ateʼ taʼnná iaʼbal-lëʼ nacuʼ tu bönniʼ bítsëʼë yuguʼ bönniʼ guluʼë didzaʼ uláz queëʼ Dios dza niʼte, en nubanëʼ lu yöl-laʼ guti. ");
INSERT INTO zarNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Níʼirö Jesús gunábinëʼ légaquiëʼ, rnnëʼ: —Názxi libíʼiliʼ, ¿nuzxi rnnaliʼ nacaʼ? Bubiʼë didzaʼ Pedro, rnnëʼ: —Nacuʼ Cristo nasö́l-lëʼë Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Níʼirö Jesús gúdxidëʼë légaquiëʼ, en gunná béʼenëʼ légaquiëʼ cuntu nu ilë́ʼ Nu náquiëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Níʼirö rëʼ légaquiëʼ: —Run bayudxi quiʼi sacaʼa nedaʼ, Bönniʼ Guljëʼ Bönachi, zián le gaca quiaʼ. Uluʼcáʼanëʼ nedaʼ cáʼasö yuguʼ bönniʼ gula tuʼzéajniʼinëʼ, en yuguʼ bixúz unná bëʼ, en yuguʼ bönniʼ yudoʼ usedi. Ilútiëʼ nedaʼ, pero dza tsonna dza Dios usubanëʼ nedaʼ lu yöl-laʼ guti. ");
INSERT INTO zarNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Gudxëʼ caʼ yúguʼtëʼ: —Channö rë́ʼënëʼ nu bönniʼ tëʼë nedaʼ, ral-laʼ uzóëʼ tsöláʼalö le dë queëʼ, en gáquiëʼ ca tu bönniʼ saʼyéajëʼ söjtë́ʼë lëʼe yaga cruz, ateʼ níʼirö gaca tëʼë nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nútiʼtës bönniʼ ruíʼi ládxëʼë gun chiʼë yöl-laʼ naʼbán queëʼ, unítiëʼ le, pero channö unítiëʼ yöl-laʼ naʼbán queëʼ tuʼ dëʼë nedaʼ, bönniʼ ni gataʼ yöl-laʼ naʼbán idú queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bitiʼ bi uziʼë xibé tu bönniʼ channö utubëʼ queëʼ yúguʼtë le dë yödzölió ni, pero unítiëʼ tsaz yöl-laʼ naʼbán queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nu bönniʼ rutuíʼinëʼ nedaʼ, en rutuíʼinëʼ caʼ xtídzaʼa, lëscaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, utuíʼidaʼ bönniʼ naʼ cateʼ huödaʼ idinná bëʼa, dzágagaca nedaʼ yöl-laʼ zxön queëʼ Xuzaʼ, en yöl-laʼ zxön quégaquiëʼ gubáz láʼayi queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Le nácatë reaʼ libíʼiliʼ, nacuáʼ bal-lëʼ bönniʼ ni bitiʼ ilátiëʼ cateʼ ilaʼléʼerönëʼ dza idinná bëʼë Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Cateʼ bizáʼa xunuʼ gubidza gudödi bëʼë Jesús yuguʼ didzaʼ ni, níʼirö guchë́ʼë Pedro, en Juan, en Jacobo, ateʼ gurenëʼ tu lu guíʼadoʼ, ga naʼ bulidzëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tsanni niʼ ruíʼilenëʼ Dios didzaʼ, bidzáʼ ca rináʼ lahuëʼ, ateʼ böáca chiguíchidoʼos lariʼ nácuëʼ, en guyëpi yösa beníʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Níʼirö buluʼluíʼi lógaquiëʼ chopëʼ bönniʼ ga zoëʼ Lëʼ tuíʼilenëʼ Lëʼ didzaʼ. Nácagaquiëʼ Moisés, en Elías. ");
INSERT INTO zarNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Chopëʼ ni gulaʼyëpëʼ yösa beníʼ, ateʼ tuíʼilenëʼ Jesús didzaʼ ca siʼ uzë́ʼë yödzölió ni, gátiëʼ lu yödzö Jerusalén. ");
INSERT INTO zarNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Sal-laʼ chirácadaʼ ilásiëʼ Pedro, en nupa nacuáʼlen lëʼ, bayudxi gulaʼnáʼasëʼ, ateʼ bilaʼléʼenëʼ yöl-laʼ beníʼ queëʼ Jesús, en chopëʼ naʼ nacuáʼlenëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Cateʼ buluʼzë́ʼë chopëʼ naʼ ga naʼ zoëʼ Jesús, níʼirö Pedro gudxëʼ Lëʼ: —Bönniʼ Usedi, dxiʼa naca zóaruʼ ni. Gúntsöcaʼtuʼ tsonna yuʼu lágaʼdoʼ, tu quiuʼ, iaʼtú queëʼ Moisés, en iaʼtú queëʼ Elías. Bitiʼ réquibeʼenëʼ Pedro bi naʼ rnnëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tsanni niʼ ruʼë didzaʼ ni, laʼ gurö́ʼötë böaj le bugacu légaquiëʼ, ateʼ guládxinëʼ tuʼ nacuʼë lu böaj naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Níʼirö biyö́n chiʼi Nu ruíʼi didzaʼ lu böaj naʼ, rnna: —Bönniʼ ni náquiëʼ Zxíʼinaʼ. Nadxíʼidaʼ Lëʼ. Buliʼzë́ nágaliʼ didzaʼ guʼë. ");
INSERT INTO zarNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Cateʼ budxi bëʼ didzaʼ chiʼi naʼ, tuzëʼ Jesús nagáʼanalenëʼ légaquiëʼ. Taʼcuáʼ dxíëʼ bönniʼ usëda queëʼ, ateʼ dza naʼ cuntu nu gulë́ʼ ca naca le bilaʼléʼenëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Cateʼ zaʼ reníʼ iaʼtú dza buluʼhuötjëʼ Jesús, en bönniʼ naʼ dzágagaquiëʼ Lëʼ lu guíʼadoʼ naʼ, ateʼ bilaʼrúaj bönachi zián dutságagaca Jesús. ");
INSERT INTO zarNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Níʼirö bëʼë zidzaj didzaʼ tu bönniʼ nútsëʼë ladaj bönachi zián naʼ. Bulidzëʼ Jesús, rnnëʼ: —Bönniʼ Usedi, rátaʼyuaʼ loʼ duyúʼ-biʼ biʼi bönniʼ quiaʼ tuʼ nácabiʼ biʼi laʼs dui quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yuʼu böʼ xihuiʼ lëbiʼ le run ga ribö́dxiʼabiʼ, en ruxízidaʼ lëbiʼ. Run ga ribía bidxinaʼ zxönaʼ ruáʼabiʼ, en rurixi rutúludaʼ lëbiʼ, ateʼ catu caz rusán lëbiʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Gútaʼyuaʼ lógaquiëʼ bönniʼ usëda quiuʼ uluʼbéajëʼ le, pero bitiʼ gulaʼzéquiʼnëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Bubiʼë didzaʼ Jesús, rnnëʼ: —Libiʼiliʼ, bitiʼ réajlëʼëliʼ, en nachixi ícjaliʼ. ¿Gácaʼxte ral-laʼ sóalenaʼ libíʼiliʼ, en guáʼ ilenaʼ queë́liʼ? Dijuáʼa-biʼ biʼi bönniʼ quiuʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Cateʼ niʼ záʼabiʼ ribígaʼbiʼ ga naʼ zoëʼ Jesús, burixi butúludaʼ böʼ xihuiʼ naʼ lëbiʼ. Jesús gudil-lëʼ böʼ xihuiʼ naʼ, en bunëʼ-biʼ biʼi bönniʼ naʼ. Níʼirö buguʼë-biʼ lu nëʼë xúzibiʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Buluʼbani yúguʼtë bönachi niʼ ca naca yöl-laʼ huáca zxön queëʼ Dios. Tsanni niʼ tuʼbani yúguʼtë bönachi ca naca le zxön runëʼ Jesús, Lëʼ gudxëʼ yuguʼ bönniʼ usëda queëʼ, ");
INSERT INTO zarNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","rnnëʼ: —Guliʼcúʼu icja nágaliʼ didzaʼ ni, tuʼ siʼ uluʼdödëʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, lu náʼagaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Bitiʼ gulaʼyéajniʼinëʼ bönniʼ usëda queëʼ didzaʼ ni, tuʼ cabí ruíʼinëʼ Dios légaquiëʼ lataj ilaʼyéajniʼinëʼ, pero bitiʼ buluʼrúguinëʼ ilaʼnábinëʼ Jesús ca naca didzaʼ ni. ");
INSERT INTO zarNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Níʼirö gulaʼsí lógaquiëʼ bönniʼ usëda queëʼ Jesús tuʼë didzaʼ. Taʼnábini luzáʼagaquiëʼ tuëʼ iaʼtúëʼ núzxilëʼ gáquiëʼ lo. ");
INSERT INTO zarNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Réquibeʼenëʼ Jesús le taʼzáʼ ládxiʼgaquiëʼ, ateʼ gudélëʼë-biʼ tubiʼ bíʼidoʼ, en buzóëʼ-biʼ cuitëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Níʼirö rëʼ légaquiëʼ: —Nútiʼtës bönniʼ gunëʼ bal tu bíʼidoʼ caní tuʼ néquibiʼ quiaʼ nedaʼ, nedaʼ caz gunëʼ bal, ateʼ nu bönniʼ gunëʼ nedaʼ bal, gunëʼ caʼ bal Xuzaʼ nasö́l-lëʼë nedaʼ. Que lë ni naʼ bönniʼ nútsëʼë ládjaliʼ nácarëʼ nöxaj ladxiʼ, bönniʼ ni náquiëʼ lo. ");
INSERT INTO zarNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Níʼirö Juan bulidzëʼ Jesús, rnnëʼ: —Bönniʼ Usedi, biléʼetuʼ-nëʼ tu bönniʼ rugunëʼ dxin Loʼ rubéajëʼ böʼ xihuiʼ, ateʼ gunná béʼetuʼ-nëʼ tuʼ cabí dëʼë rëʼu. ");
INSERT INTO zarNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús rëʼ lëʼ: —Bitiʼ inná béʼeliʼ-nëʼ, tuʼ rácalen rëʼu nu bitiʼ ridáʼbagaʼ rëʼu. ");
INSERT INTO zarNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Cateʼ chizáʼ gal-laʼ dza ral-laʼ gátiëʼ Jesús, en huëpëʼ yehuaʼ yubá, benëʼ bayudxi tsejëʼ Jerusalén. ");
INSERT INTO zarNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Gusö́l-lëʼë yuguʼ bönniʼ gubáz queëʼ ilaʼnö́ruëʼ ca Lëʼ, ateʼ yöjáquiëʼ tu yö́dzödoʼ quégaca bönachi Samaria para tsöjpáʼagaquiëʼ ga ugáʼanëʼ Jesús tu yëla. ");
INSERT INTO zarNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Yuguʼ bönniʼ yödzö naʼ bitiʼ gulunëʼ Jesús bal tuʼ chinaca queëʼ saʼyéajëʼ Jerusalén. ");
INSERT INTO zarNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Cateʼ Jacobo, en Juan, bönniʼ usëda queëʼ Jesús, bilaʼléʼenëʼ lë ni, tëʼ Lëʼ: —Xan, ¿naruʼ inábatsöcaʼtuʼ huötaj guíʼ le zaʼ yehuaʼ yubá, en usuniti légaquiëʼ, guntuʼ ca naʼ benëʼ Elías? ");
INSERT INTO zarNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Buécjëʼ Jesús, en gudil-lëʼ légaquiëʼ, rnnëʼ: —Bitiʼ nö́ziliʼ bizxi böʼ dzágui libíʼiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Bidaʼ ni nedaʼ, Bönniʼ Guljëʼ Bönachi, calëga para usunítiaʼ yöl-laʼ naʼbán quégaca bönachi, pero bidaʼ dusöláʼ bönachi. Níʼirö yöjáquiëʼ yödzö yúbölö. ");
INSERT INTO zarNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tsanni niʼ yúʼugaquiëʼ nöza Jesús, en yuguʼ bönniʼ dáʼgaquiëʼ Lëʼ, bidxinëʼ tu bönniʼ yödzö Jerusalén, en rëʼ Jesús: —Xan, rë́ʼëndaʼ sáʼlenaʼ Liʼ gátiʼtës ga tsejuʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús rëʼ lëʼ: —Yúguʼ bözaʼ, nacuáʼ zxan bulóaj quégacabaʼ, ateʼ biguínnidoʼ, dxíagaca xcáʼagacabaʼ, pero nedaʼ, Bönniʼ Guljëʼ Bönachi, bitiʼ dë quiaʼ ga gátaʼa uzíʼ ládxaʼa. ");
INSERT INTO zarNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Níʼirö Jesús gudxëʼ tu bönniʼ yúbölö, rnnëʼ: —Gudáʼ nedaʼ. Bönniʼ ni gudxëʼ Lëʼ: —Xan, benna nedaʼ lataj huöjaʼ lidxaʼ ga idxinrö dza chibucáchaʼa-nëʼ xuzaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús gudxëʼ lëʼ: —Bëʼ lataj bönniʼ chizóa ilátiëʼ uluʼcáchëʼë nupa chinati quégaquiëʼ, pero liʼ, guyéaj, yöjén libán ca inná bëʼë Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Níʼirö bidxinëʼ iaʼtúëʼ caʼ, en rëʼ Jesús: —Xan, rë́ʼëndaʼ sáʼlenaʼ Liʼ, pero benna nedaʼ lataj tsejaʼ tsöjzégacadaʼ-nëʼ didzaʼ diʼa dza quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús gudxëʼ lëʼ: —Nútiʼtës bönniʼ ruíʼi ládxëʼë le raca yödzölió náquiëʼ ca tu bönniʼ rugáʼanëʼ-baʼ bëdxi, en ruyúëʼ zacaʼ cúdzuʼlëʼ. Nu run caní bitiʼ naca lesacaʼ tsaza ga rinná bëʼë Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Gudödi gulaca yuguʼ lë ni, gurö́ëʼ Xanruʼ iaʼtsónnalalaj yuʼ chiëʼ bönniʼ usëda queëʼ, ateʼ gusö́l-lëʼë légaquiëʼ chopa huéajgaquiëʼ para ilaʼnö́ruëʼ ca Lëʼ, en tsöjáquiëʼ yúguʼtë yödzö, en yö́dzödoʼ gapa chizóa tödëʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Gudxëʼ légaquiëʼ: —Le nácatë, dëdaʼ dxin quiaʼ, le naca ca tu laʼ yëla zxön ga nu tsöjlapaʼ, pero nabábasö huen dxin quiaʼ nacuáʼ. Que lë ni naʼ, guliʼgátaʼyu lahuëʼ Dios, náquiëʼ Xan laʼ yëla naʼ, isö́l-lëʼë yuguʼ huen dxin ga naca laʼ yëla queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Guliʼtséaj naʼa. Buliʼyútsöcaʼ, nedaʼ risö́l-laʼa libíʼiliʼ, nácaliʼ ca yuguʼ böʼcuʼ zxilaʼ söjácabaʼ ládjagacabaʼ böʼcuʼ guíʼa síniaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bitiʼ guáʼaliʼ yöxaj dumí, en calëga buzudi yöta, en bitiʼ guáʼaliʼ iaʼtú cöʼ xiráchuliʼ, en bitiʼ tseliʼ para güíʼilenliʼ bönachi didzaʼ gapa naca laʼ nöza. ");
INSERT INTO zarNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Gátiʼtës yuʼu ga tsúʼuliʼ, innaliʼ: “Le ribequi dxi ladxiʼ gaca quégaca bönachi nacuáʼ yuʼu ni.” ");
INSERT INTO zarNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Channö zoa niʼ nu bönniʼ siʼë yöl-laʼ ribequi dxi ladxiʼ, ugáʼanalen lëʼ le ribequi dxi ladxiʼ naʼ inábaliʼ, pero channö cabí zoa niʼ nu bönniʼ caní, ugáʼanalen libíʼiliʼ le ribequi dxi ladxiʼ naʼ inábaliʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Guliʼgáʼana yuʼu ga naʼ tsúʼuliʼ, en guliʼguíʼaj guliʼgagu bi ilunnëʼ queë́liʼ, tuʼ udzöli quézinëʼ bönniʼ huen dxin le gahuëʼ. Bitiʼ tö́diliʼ yuʼu yuʼu. ");
INSERT INTO zarNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Gátiʼtës yödzö ga tsúʼuliʼ, ateʼ ilún libíʼiliʼ bal, guliʼgagu le uluʼcuʼë loliʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Buliʼún nupa teʼe nacuáʼ yödzö naʼ, en guliʼguíë léguequi: “Chibidxín le rinná bëʼë Dios ga zóaliʼ.” ");
INSERT INTO zarNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Gátiʼtës yödzö ga tsúʼuliʼ, channö cabí ilún libíʼiliʼ bal, guliʼrúaj, tsöjsóaliʼ laʼ nöza que yödzö naʼ, en innaliʼ: ");
INSERT INTO zarNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Bëchtö que ládzaliʼ le daʼ lëʼe lábatuʼ ruquínnajtuʼ, le ruluíʼi nabágaʼliʼ xíguiaʼ, pero ral-laʼ inö́ziliʼ lë ni, chibidxín le rinná bëʼë Dios ga zóaliʼ.” ");
INSERT INTO zarNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nedaʼ reaʼ libíʼiliʼ, cateʼ idxín dza ichúguiëʼ Dios quégaca bönachi, ilaʼguíʼi ilaʼzacaʼrö bönachi yödzö niʼ ca ilaʼguíʼi ilaʼzacaʼ bönachi yödzö Sodoma, nupa niʼ busunítiëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Gunnë́ʼ caʼ Jesús: —Bicaʼ bayechiʼ libíʼiliʼ, bönachi yödzö Corazín. Bicaʼ bayechiʼ libíʼiliʼ, bönachi yödzö Betsaida. Laʼtuʼ gulaca lu yödzö Tiro, en lu yödzö Sidón yuguʼ yöl-laʼ huáca rubani ca yuguʼ le benaʼ ga zóaliʼ, dza niʼte uluʼbíʼi ládxiʼgaquiëʼ bönniʼ niʼ, ateʼ ilácuëʼ lariʼ cáʼasö, en ilaʼguʼë dö ícjagaquiëʼ, le uluíʼigaca chibuluʼbíʼi ládxiʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Que lë ni naʼ, cateʼ idxín dza ichúguiëʼ Dios quégaca bönachi, quíʼi sácaʼröliʼ ca ilaʼguíʼi ilaʼzáquiëʼ bönniʼ yödz Tiro, en yödz Sidón. ");
INSERT INTO zarNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Libíʼiliʼ, bönachi Capernaum. Réquiliʼ tsázaliʼ yehuaʼ yubá. Huö́tjaliʼ tsöjtsázaliʼ lataj chul-la quégaca nupa nátigaca. ");
INSERT INTO zarNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Níʼirö Jesús gudxëʼ yuguʼ bönniʼ usëda queëʼ, rnnëʼ: —Nu ruzë́ nagui libíʼiliʼ, ruzë́ nagui caʼ nedaʼ, ateʼ nu rucáʼana libíʼiliʼ cáʼasö, rucáʼana caʼ nedaʼ cáʼasö, en nu rucáʼana nedaʼ cáʼasö, rucáʼana caʼ cáʼasö Xuzaʼ, nasö́l-lëʼë nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Cateʼ tsónnalalaj yuʼ chiëʼ bönniʼ naʼ gusö́l-lëʼë Jesús buluʼdxinëʼ ga zoëʼ Lëʼ, bönniʼ naʼ yöjéngaquiëʼ libán, taʼnnë́ʼ: —Xan, tun böʼ xihuiʼ ca rnnatuʼ cateʼ ruguntuʼ dxin Loʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús gudxëʼ légaquiëʼ: —Nedaʼ biléʼedaʼ Satanás tuʼ xihuiʼ, gubixi zxan lúzxiba ca run yösa, le riyaza luyú. ");
INSERT INTO zarNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Buliʼyútsöcaʼ, nedaʼ nudödaʼ lu náʼaliʼ yöl-laʼ unná bëʼ para gaca sö́ngacaliʼ-baʼ bëla síniaʼ, en xöjnö́ʼ, en bitiʼ bi gaca queë́liʼ, ateʼ ucúl-laliʼ yöl-laʼ unná bëʼ que tuʼ xihuiʼ, nu bitiʼ riléʼe rëʼu dxiʼa. ");
INSERT INTO zarNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Naʼa, buliʼdzeja, calë́gasö tuʼ tun böʼ xihuiʼ ca rnnaliʼ, pero tuʼ nuzúajgaca laliʼ lu guichi niʼ yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Laʼ níʼisö rudzéjanëʼ Jesús, dzáguiëʼ Dios Böʼ Láʼayi Lëʼ, rnnëʼ: —Riguʼa Liʼ yöl-laʼ ba, Xuzaʼ, nacuʼ Xani yehuaʼ yubá, en Xani luyú ni, tuʼ bucáchuʼu yuguʼ lë ni lógaquiëʼ bönniʼ táquiëʼ yenniʼ, en bönniʼ taʼyéajniʼinëʼ, pero buluíʼiguequinuʼ-biʼ bíʼidoʼ ca naca. ¡Caʼ gaca, Xuzaʼ, tuʼ caní guyaza ládxuʼu! ");
INSERT INTO zarNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Níʼirö gunnë́ʼ: —Yúguʼtë budödëʼ Xuzaʼ lu naʼa. Cuntu nu bönniʼ nö́zinëʼ Nu náquiëʼ Zxíʼinëʼ Dios, pero tuzëʼ Dios Xuz nö́zinëʼ, ateʼ cuntu nu nözi Nu náquiëʼ Dios Xuz, pero tuzëʼ Zxíʼinëʼ nö́zinëʼ, ateʼ inö́zigaca caʼ nupa naʼ Zxíʼinëʼ rë́ʼënëʼ uluíʼinëʼ léguequi Xuzëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Níʼirö Jesús buyúëʼ yuguʼ bönniʼ usëda queëʼ, en rëʼ légaquiëʼ: —Bicaʼ bágaca nupa taʼléʼe le riléʼeliʼ libíʼiliʼ, ");
INSERT INTO zarNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","tuʼ reaʼ libíʼiliʼ: Zián bönniʼ guluʼë didzaʼ uláz queëʼ Dios, encaʼ bönniʼ gulaʼnná bëʼë, gulë́ʼënnëʼ ilaʼléʼenëʼ le riléʼeliʼ, pero bitiʼ bilaʼléʼenëʼ le. Gulë́ʼënnëʼ ilaʼyönnëʼ le riyö́niliʼ, pero bitiʼ bilaʼyönnëʼ le. ");
INSERT INTO zarNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Níʼirö guyasëʼ tu bönniʼ yudoʼ usedi, en para siʼ bëʼë Jesús, gunábinëʼ Lëʼ, rnnëʼ: —Bönniʼ Usedi, ¿bizxi ral-laʼ gunaʼ para idéliʼdaʼ yöl-laʼ naʼbán idú? ");
INSERT INTO zarNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús rëʼ lëʼ: —¿Bizxi caz nazúaj lu guichi lu xibá queëʼ Moisés? ¿Nacxi rusacaʼ quiuʼ lë naʼ rulabuʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Bubiʼë didzaʼ bönniʼ naʼ, rnnëʼ: —Caní rnna: “Idxíʼinuʼ Xanuʼ Dios idú ládxuʼu, en len idú icja ládxiʼdoʼo, en len idú yöl-laʼ run quiuʼ, en len idú yöl-laʼ réajniʼi quiuʼ, ateʼ idxíʼinuʼ bönniʼ luzóʼo ca nadxíʼi cuinuʼ.” ");
INSERT INTO zarNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús rëʼ lëʼ: —Dxíʼadoʼ bubiʼu didzaʼ. Ben caní, ateʼ gataʼ quiuʼ yöl-laʼ naʼbán naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tuʼ gúʼunnëʼ bönniʼ naʼ ubéaj dxiʼa cuinëʼ, rëʼ Jesús: —¿Nuzxi naʼ bönniʼ luzáʼa? ");
INSERT INTO zarNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Bubiʼë didzaʼ Jesús, rëʼ lëʼ: —Buzë́ʼë tu bönniʼ Jerusalén, rudínniëʼ, saʼyéajëʼ yödzö Jericó. Laʼ nöza niʼ gulaʼzönëʼ gubán lëʼ. Gulaʼgúëʼ lariʼ nácuëʼ, en gulunëʼ lëʼ huëʼ. Níʼirö buluʼzë́ʼë niʼ, en nucáʼanagaquiëʼ lëʼ, chirati cazëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Níʼirö gudödëʼ tu bixúz laʼ nöza niʼ. Cateʼ biléʼenëʼ bönniʼ huëʼ naʼ, tsöláʼalö gudödëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Gudödëʼ caʼ niʼ tu bönniʼ nababëʼ zxíʼini xiʼsóëʼ Leví, yuguʼ bönniʼ naʼ tunëʼ dxin que yudoʼ. Cateʼ biléʼenëʼ lëʼ, tsöláʼalö caʼ gudödëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Lëscaʼ yuʼë tu bönniʼ Samaria nöza naʼ, ateʼ bidxinëʼ galaʼ ga dëʼ bönniʼ huëʼ naʼ. Cateʼ biléʼenëʼ lëʼ, buéchiʼ ládxëʼë lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Gubíguiʼë ga naʼ dëʼ, ateʼ guluʼë le za, en xisi uva nál-la lu huëʼ queëʼ, ateʼ buchö́linëʼ le lariʼ. Níʼirö budxíëʼ lëʼ cúdzuʼbaʼ böaʼ queëʼ, en buʼë lëʼ yuʼu ga taʼdxinëʼ bönniʼ yúʼugaquiëʼ nöza, ateʼ niʼ gudapa chiʼë lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Cateʼ zaʼ reníʼ iaʼtú dza, en chizóa uzë́ʼë bönniʼ Samaria naʼ, guléajëʼ lázxjaruʼ que chopa dza, le bucáʼanëʼ lu nëʼë bönniʼ xan yuʼu naʼ, en rëʼ lëʼ: “Gudapa chiʼë bönniʼ ni, en channö utö́uʼ iaʼlatiʼ dumí, ubiʼa nedaʼ quiuʼ cateʼ huödaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Naʼa, ¿nacxi runi liʼ? ¿Núzxilëʼ bönniʼ yonna ni gúquiëʼ bönniʼ luzë́ʼë bönniʼ naʼ guluʼë döʼ bönniʼ gubán queëʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Bubiʼë didzaʼ bönniʼ yudoʼ usedi naʼ, rëʼ Jesús: —Bönniʼ naʼ buéchiʼ ládxëʼë lëʼ. Níʼirö Jesús gudxëʼ lëʼ: —Guyéaj naʼa, yöjén caʼ liʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Níʼirö buʼë nöza Jesús, ateʼ bidxinëʼ tu yö́dzödoʼ ga niʼ tu nigula lënu Marta guchë́ʼënu Lëʼ lídxinu. ");
INSERT INTO zarNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta ni zóanu nigula zxílanu lënu María, ateʼ María naʼ gurö́ʼötënu ga naca xiniʼë Jesús, en ruzë́ náganu xtídzëʼë. ");
INSERT INTO zarNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta naʼ bubi buguíʼinu, zián dxin runnu, ateʼ gubígaʼnu ga naʼ zoëʼ Jesús, en rënu Lëʼ: —Xan, ¿naruʼ cabí ruíʼi ládxiʼtsoʼ nedaʼ tuʼ nucáʼanabiʼ biʼi zxilaʼ ni nedaʼ, ateʼ tuzaʼ runaʼ dxin? Gudxi-biʼ gácalenbiʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bubiʼë didzaʼ Jesús, rëʼë-nu: —Marta, Marta, ruúbi ruguíʼideʼenuʼ, en zián le ruíʼi ládxuʼu runuʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tuz le run bayudxi nu gun, ateʼ María ni guröbiʼ lë naʼ nácatërö dxiʼa, ateʼ lë naʼ guröbiʼ bitiʼ udúa queë́biʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tu dza niʼ Jesús rulidzëʼ Dios. Cateʼ budxi bë́ʼlenëʼ Dios didzaʼ, tuëʼ bönniʼ usëda queëʼ rëʼ Lëʼ, rnnëʼ: —Xan, busedi netuʼ ulídzatuʼ-nëʼ Dios güíʼilentuʼ-nëʼ didzaʼ, ca benëʼ Juan, busédinëʼ bönniʼ dáʼgaquiëʼ lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Níʼirö Jesús rëʼ légaquiëʼ: —Cateʼ ulídzaliʼ-nëʼ Dios güíʼilenliʼ-nëʼ didzaʼ, guliʼná: Xuztuʼ, zuʼ yehuaʼ yubá, gáʼana zxön Loʼ. Gudá inná bëʼu. Gaca ca raza ládxuʼu Liʼ luyú ni, ca naʼ raca yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Benna le gágutuʼ naʼa dza. ");
INSERT INTO zarNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Buniti lo netuʼ dul-laʼ nabágaʼtuʼ ca netuʼ caʼ runiti lotuʼ nupa tuaʼ döʼ queë́tuʼ. Bitiʼ guʼu lataj siʼ bëʼ tuʼ xihuiʼ netuʼ, pero busölá netuʼ lu naʼ nu ruáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús rëʼ caʼ légaquiëʼ: —Channö zoëʼ nu bönniʼ ládjaliʼ, en zoëʼ böchiʼ luzë́ʼë, en channö huidëʼ ga naʼ zoëʼ guluhuëla, ateʼ ulidzëʼ lëʼ, innë́ʼ: “Bö́chaʼa, benna quiaʼ tsonna yöta xtila ");
INSERT INTO zarNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","tuʼ siʼ bidxinëʼ quiaʼ böchiʼ luzáʼa, zëʼë ziʼtuʼ, pero bitiʼ bi dë le guʼa-nëʼ gahuëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","¿Naruʼ ubiʼë didzaʼ caní bönniʼ naʼ zoëʼ yuʼu, guíëʼ lëʼ: “Bitiʼ utsóʼo nedaʼ tuʼ chinayayaj yuʼu, en chidë́lengacabiʼ biʼi quiaʼ nedaʼ, ateʼ bitiʼ gaca chasaʼ bi gunnaʼ quiuʼ”? ");
INSERT INTO zarNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nedaʼ reaʼ libíʼiliʼ: Sal-laʼ bitiʼ chasëʼ bi unödzjëʼ queëʼ tuʼ náquiëʼ böchiʼ luzë́ʼë, pero chasëʼ, en unödzjëʼ queëʼ idutë le riquinnëʼ para cabirö upízxjanëʼ lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Que lë ni naʼ reaʼ libíʼiliʼ: Guliʼnaba, ateʼ Dios gunnëʼ queë́liʼ. Guliʼquilaj, ateʼ idzöli queë́liʼ. Buliʼlidza raʼ yuʼu, ateʼ tsalaj queë́liʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nu rinaba, rizíʼ que, ateʼ nu riguilaj, ridzöli que, ateʼ nu rulidza raʼ yuʼu, ralaj que. ");
INSERT INTO zarNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Channö zoëʼ nu bönniʼ ládjaliʼ, en náquiëʼ xuz, ateʼ channö zxíʼinëʼ inábibiʼ lëʼ yöta xtila, ¿naruʼ unö́dzjatsëʼ queë́biʼ guiö́j? Channö inábibiʼ lëʼ tubaʼ böla, ¿naruʼ unö́dzjatsëʼ queë́biʼ bëla? ");
INSERT INTO zarNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Channö inábibiʼ lëʼ dxita que böra, ¿naruʼ unö́dzjatsëʼ queë́biʼ xöjnö́ʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Caní naca, nácaliʼ libíʼiliʼ huiáʼ döʼ, pero nö́ziliʼ unö́dzjaliʼ quégacabiʼ zxíʼiniliʼ le naca dxiʼa. Nácatërö löza Xúziliʼ zoëʼ yehuaʼ yubá gunnëʼ queë́liʼ Dios Böʼ Láʼayi, núlöliʼ inábiliʼ Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tu dza bubéajëʼ Jesús böʼ xihuiʼ yuʼu tu bönniʼ, le run ga bitiʼ raca innë́ʼ. Cateʼ burúaj böʼ xihuiʼ naʼ, bëʼë didzaʼ bönniʼ naʼ bitiʼ guca innë́ʼ, ateʼ buluʼbani bönachi nacuáʼ niʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Bal-la bönachi nacuáʼ niʼ taʼnná: —Len yöl-laʼ huáca que tuʼ xihuiʼ Beelzebú, xángaca böʼ xihuiʼ, rubéajëʼ yuguʼ böʼ xihuiʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Iaʼbal-la bönachi naʼ gulë́ʼëni ilaʼzíʼ bëʼ Jesús, ateʼ gulaʼnabi Lëʼ gunëʼ tu le gaca bëʼ le zaʼ yehuaʼ yubá. ");
INSERT INTO zarNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Réquibeʼenëʼ Jesús le taʼzáʼ ládxiʼgaquiëʼ, ateʼ rëʼ légaquiëʼ: —Gátiʼtës ga taʼnná beʼe bönachi luzë́ʼeguequi, channö ilaʼrúaj choplö laʼ léguequisö bönachi naʼ, ilaʼniti. Channö ilaʼrúaj choplö bönachi nacuáʼ tu yuʼu, údxi quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Lëscaʼ caní raca que Satanás, tuʼ xihuiʼ, nazíʼi le caʼ Beelzebú. Channö ilaʼrúaj choplö nupa dáʼgaca le, ¿nacxi gaca idíaʼ yöl-laʼ unná bëʼ que? ¿Rnnátsaliʼ naʼa: Len yöl-laʼ huáca que Beelzebú rubéajaʼ yuguʼ böʼ xihuiʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Channö nedaʼ, len yöl-laʼ huáca que Beelzebú rubéajaʼ yuguʼ böʼ xihuiʼ, ¿nuzxi runna quégaca nupa dáʼgaca libíʼiliʼ yöl-laʼ huáca tuʼbéaj yuguʼ böʼ xihuiʼ? Que lë ni naʼ, le tun nupa ni naca bëʼ nachíxiliʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Channö nedaʼ, len yöl-laʼ huáca queëʼ Dios rubéajgacaʼ böʼ xihuiʼ, le nácatë chibidxín le rinná bëʼë Dios ga zóaliʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Cateʼ tu bönniʼ nál-la dë lu nëʼë le rudíʼinëʼ, en rapa chiʼë lidxëʼ, naca chiʼi dërö le dë queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Naʼa, channö zëʼë iaʼtúëʼ bönniʼ nál-latërëʼ ca lëʼ, en ucul-lëʼ lëʼ, níʼirö cuëʼ yúguʼtë le rudíʼinëʼ, lë naʼ ruzxöni ládxëʼë, ateʼ quísiëʼ le dë queëʼ bönniʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Nu bitiʼ rácalen nedaʼ, ridáʼbagaʼ nedaʼ. Nu bitiʼ rutúbilen nedaʼ, rusilasi nu naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Gunnë́ʼ caʼ Jesús: —Cateʼ rirúaj böʼ xihuiʼ lu bönniʼ, ridá gapa nabídx, riguilaj ga uzíʼ ladxiʼ. Channö cabí idzöli que, inná: “Huöjaʼ xilatjaʼ ga niʼ birúajaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Cateʼ rudxín niʼ, röjxacaʼ bönniʼ naʼ, náquiëʼ ca tu yuʼu chinulúa, en chinabáʼa para nu tsöjsóa niʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Níʼirö reaj, en röjxíʼ iaʼgadxi böʼ xihuiʼ, nácagacatërö xihuiʼ ca le, ateʼ taʼyúʼu bönniʼ naʼ. Naʼa, le raca queëʼ bönniʼ naʼ nayáliʼtërö ca le guca queëʼ zíʼalö. ");
INSERT INTO zarNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tsanni niʼ ruʼë Jesús didzaʼ ni, tu nigula nútsaʼnu ladaj bönachi zián naʼ bë́ʼënu zidzaj didzaʼ, rnnanu: —Bicaʼ ba nigula naʼ biáʼanu Liʼ lë́ʼënu, en bicaʼ ba caʼ luchúʼunu ga naʼ gúdxuʼu. ");
INSERT INTO zarNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Bubiʼë didzaʼ Jesús, gunnë́ʼ: —Nácagacatërö bicaʼ ba nupa taʼyöni xtídzëʼë Dios, en tun ca rnna. ");
INSERT INTO zarNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tsanni niʼ taʼbigaʼ bönachi zián ga zoëʼ Jesús, gusí lahuëʼ ruʼë didzaʼ, rnnëʼ: —Taʼnába bönachi tuáʼ döʼ ni gunaʼ le gaca bëʼ ga zaʼ yöl-laʼ huáca quiaʼ, pero bitiʼ bi le gaca bëʼ ilaʼléʼenëʼ. Tuz le gaca bëʼ ca naʼ guca queëʼ Jonás ilaʼléʼenëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ca naʼ guca queëʼ Jonás, gúquiëʼ tu le naca bëʼ lógaca bönachi yödzö Nínive, lëscaʼ caní gaca quiaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, gacaʼ tu le gaca bëʼ lógaca bönachi dza ni zóaruʼ naʼa. ");
INSERT INTO zarNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Cateʼ idxín dza ichúguiëʼ Dios quégaca bönachi ilaʼguíʼi ilaʼzacaʼ, en uchiʼa usörö́ëʼ bönachi dza ni zóaruʼ naʼa, Dios uchisëʼ-nu nigula gunná béʼenu bönachi dza niʼte luyú niʼ dë tsöláʼa ga ridödi gubidza beoʼ ziaga, ateʼ le bennu uluíʼi nabágaʼgaca bönachi ni xíguiaʼ, tuʼ bídanu lënu, birúajnu ga naca ziʼtuʼ para uduzë́ náganu didzaʼ réajniʼi bëʼë Salomón, bönniʼ gunná béʼenëʼ bönachi Israel, pero naʼa, zoaʼ nedaʼ ni, en nayë́pisëtëraʼ ca Salomón naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Lëscaʼ caní, Dios uchisëʼ bönniʼ gulaʼcuʼë yödzö Nínive cateʼ idxín dza ichugu bëʼë quégaca bönachi, en uchiʼa usörö́ëʼ bönachi dza ni zóaruʼ naʼa, ateʼ le gulunëʼ uluíʼi nabágaʼgaca bönachi ni xíguiaʼ, tuʼ buluʼbíʼi ládxiʼgaquiëʼ bönniʼ Nínive cateʼ bilaʼyönnëʼ libán benëʼ Jonás, ateʼ naʼa zoaʼ nedaʼ ni, en nayë́pisëtëraʼ ca Jonás naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Gunnë́ʼ caʼ Jesús: —Cateʼ nu ruquelaʼ guíʼ, bitiʼ rigúʼu le ga nagachiʼ, en bitiʼ rudusiʼ le guíʼina, pero ruzóa le xitsáʼ ga lináʼ, para uzeníʼ quégaca nupa taʼyúʼu yuʼu naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Guiö́j loruʼ naca ca tu le rigúʼu beníʼ lu icja ládxiʼdoʼoruʼ. Channö guiö́j loʼ naca dxiʼa, idúteoʼ yudzu le naca beníʼ, pero channö naca xihuiʼ guiö́j loʼ, idúteoʼ yudzu le naca chul-la. ");
INSERT INTO zarNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ben chiʼi cuinuʼ naʼa, para cabí huöáca chul-la lë naʼ rigúʼu beníʼ lu icja ládxiʼdoʼo. ");
INSERT INTO zarNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Caní naca, channö idúteoʼ nalísinuʼ le naca beníʼ, en bitiʼ bi zóalen liʼ le chul-la, yúguʼtë iléʼenuʼ dxiʼa ca raca cateʼ ruzeníʼ quiuʼ guíʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Cateʼ budxi bëʼë didzaʼ ni Jesús, tu bönniʼ yudoʼ fariseo bulidzëʼ Lëʼ para tsöjtágulenëʼ lëʼ. Cateʼ guyáziëʼ Jesús lidxëʼ bönniʼ yudoʼ naʼ, guröʼë rahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Cateʼ bönniʼ yudoʼ fariseo naʼ biléʼenëʼ Lëʼ, bubáninëʼ tuʼ cabí gudibi nëʼë Jesús cateʼ siʼ gahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Xanruʼ rëʼ lëʼ: —Libiʼiliʼ, bönniʼ yudoʼ fariseo, riguibi cuinliʼ ca riguíbiliʼ láhuilögaca le rë́ʼaji ráhuiliʼ, pero lu icja ládxiʼdoʼoliʼ ruhuídiʼliʼ, en rizáʼ ládxiʼliʼ le ruáʼ döʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Libíʼiliʼ, bönniʼ bitiʼ réajniʼiliʼ. ¿Naruʼ cabí nö́ziliʼ, Nu ben le zoa láhuisö ben caʼ le yuʼu lë́ʼelö? ");
INSERT INTO zarNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Naʼa, guliʼgún gun le dë queë́liʼ, ateʼ níʼirö huöáca dxiʼa yúguʼtë le dë queë́liʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Bicaʼ bayechiʼ libíʼiliʼ, bönniʼ yudoʼ fariseo. Riguízxjaliʼ que yudoʼ tu cöʼ huéaj tuʼ chi cöʼ le rizíʼiliʼ que xöhuéaj, en que guixiʼ ruda, en quégaca guixiʼ cuandoʼ, pero rudö́disiliʼ le naca tsahuiʼ, en yöl-laʼ nadxíʼi queë́liʼ Dios. Yuguʼ lë ni run bayudxi gunliʼ, en bitiʼ ucáʼanaliʼ iaʼzicaʼ lë naʼ runliʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Bicaʼ bayechiʼ libíʼiliʼ, bönniʼ yudoʼ fariseo. Rë́ʼëniliʼ cö́ʼöliʼ gapa naca lo lu yuʼu ga rudúbiliʼ rusë́daliʼ queëʼ Dios, en rë́ʼëniliʼ uluʼlidza bönachi libíʼiliʼ ba zxön gapa naca láhuilöguequi bönachi. ");
INSERT INTO zarNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Bicaʼ bayechiʼ libíʼiliʼ, bönniʼ yudoʼ usedi, encaʼ libíʼiliʼ, bönniʼ yudoʼ fariseo, bönniʼ ruluíʼisö tsahuiʼ cuinliʼ, tuʼ nácaliʼ ca nácagaca yeru ba quégaca nupa nátigaca le cabí naláʼgaca, ateʼ taʼdá bönachi láhuigaca yeru ba naʼ, en bitiʼ téquibeʼe. ");
INSERT INTO zarNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Níʼirö bubiʼë didzaʼ tu bönniʼ yudoʼ usedi raquiëʼ xibá queëʼ Moisés. Rëʼ Jesús: —Bönniʼ Usedi, cateʼ rnnoʼ caní, netuʼ caʼ runuʼ ziʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús rëʼ lëʼ: —Bicaʼ bayechiʼ caʼ libíʼiliʼ, bönniʼ yudoʼ usedi rácaliʼ xibá queëʼ Moisés, tuʼ rusubágaʼgacaliʼ bönachi tu yuaʼ ziʼi le cabí gaca nu guáʼ, pero libíʼiliʼ calëga látiʼdoʼos bitiʼ ruláhuiʼliʼ le len náʼaliʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Bicaʼ bayechiʼ libíʼiliʼ, tuʼ richísaliʼ biquitaj quégaca ba ga nagáchiʼgaquiëʼ bönniʼ guluʼë didzaʼ uláz queëʼ Dios, ateʼ gulútiëʼ xuz xtóʼoliʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Caní naca, runliʼ ba nalí runliʼ tuz le gulunëʼ xuz xtóʼoliʼ tuʼ gulútiëʼ xuz xtóʼoliʼ naʼ légaquiëʼ, ateʼ libíʼiliʼ richísaliʼ biquitaj quégaca ba ga nagáchiʼgaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Que lë ni naʼ, lu yöl-laʼ réajniʼi queëʼ, Dios gunnë́ʼ caní: “Isö́l-laʼa queë́liʼ bönniʼ iluʼë didzaʼ uláz quiaʼ, en yuguʼ bönniʼ gubáz quiaʼ, ateʼ yuguʼ bönniʼ ni, bal-lëʼ gútiliʼ, en iaʼbal-lëʼ cuia naʼliʼ légaquiëʼ.” ");
INSERT INTO zarNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Caní gunëʼ Dios tuʼ uchiʼa usörö́ëʼ quégaca bönachi dza ni zóaruʼ naʼa, niʼa que rön quégaca yúguʼtë bönniʼ guluʼë didzaʼ uláz queëʼ, bönniʼ niʼ bë́tigaca bönachi légaquiëʼ cateʼ gusí lo rataʼ yödzölió, ");
INSERT INTO zarNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ga gusí lo nu bëti Abel, ga bidxintë gulútiëʼ Zacarías, bönniʼ naʼ gulútiëʼ gatsaj láhuiʼlö ga dë bucugu láʼayi ga naʼ tuʼzéguiʼgaquiëʼ-baʼ böaʼ bë́dxidoʼ lahuëʼ Dios, en ga dë lataj láʼayi. Que lë ni naʼ, reaʼ libíʼiliʼ, Dios uchúguëʼ quégaca bönachi dza ni zóaruʼ naʼa, niʼa que rön quégaca yúguʼtë bönniʼ naʼ gulútiëʼ xuz xtóʼoliʼ légaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Bicaʼ bayechiʼ libíʼiliʼ, bönniʼ yudoʼ usedi, rácaliʼ xibá queëʼ Moisés. Laʼ libíʼisiliʼ dë lu náʼaliʼ zxíʼini guíë que lataj ga taʼdzöli bönachi yöl-laʼ réajniʼi. Libíʼiliʼ bitiʼ riyázaliʼ, ateʼ ruzágaʼliʼ xinö́zigaca nupa të́ʼëni ilaʼyaza. ");
INSERT INTO zarNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Cateʼ Jesús budxi bë́ʼlenëʼ légaquiëʼ didzaʼ ni, bönniʼ yudoʼ tuʼsédinëʼ, en yuguʼ bönniʼ yudoʼ fariseo gulaʼlédeʼenëʼ Lëʼ, ateʼ gulaʼsí lógaquiëʼ taʼnaba yúdxideʼenëʼ Lëʼ ca naca zián le taca, ");
INSERT INTO zarNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","en tuʼbéajëʼ Lëʼ didzaʼ para gaca uluʼzéguiëʼ Lëʼ didzaʼ niʼa que didzaʼ ubiʼë. ");
INSERT INTO zarNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Laʼ dza naʼ buluʼdubi zián gayuáʼ bönachi ga zoëʼ Jesús ga bidxintë taʼrö́lisö luzë́ʼeguequi bönachi naʼ. Níʼirö gusí lahuëʼ Jesús rëʼ yuguʼ bönniʼ usëda queë cazëʼ, rnnëʼ: —Guliʼgún chiʼi cuinliʼ que le naca ca cúa zi que yöta xtila quégaquiëʼ bönniʼ yudoʼ fariseo, le naca yöl-laʼ ruluíʼisö tsahuiʼ cuini quégaquiëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bitiʼ bi dë le naca balándoʼos le cabí iláʼ lahui, en bitiʼ bi dë le nagachiʼ le cabí gaca bëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Que lë ni naʼ, yúguʼtë le chigunnáliʼ ga naca chul-la, ilaʼyöni bönachi ga naca lu beníʼ, ateʼ didzaʼ bë́ʼëliʼ bagáchiʼsö ga guzóa lu yuʼu nayayaj, gaca libán que ga naca lógaca bönachi. ");
INSERT INTO zarNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Gunnë́ʼ caʼ Jesús: —Bö́chaʼadoʼ, reaʼ libíʼiliʼ: Bitiʼ gádxiliʼ bönniʼ tútigaquiëʼ bönachi, ateʼ tödi naʼ bítiʼrö bi gaca ilunëʼ quéguequi. ");
INSERT INTO zarNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Uluíʼidaʼ libíʼiliʼ nu ral-laʼ gádxiliʼ. Guliʼgadxi Nu naʼ gaca ugúa yöl-laʼ naʼbán queë́liʼ, en tödi naʼ dë lu nëʼë yöl-laʼ unná bëʼ chúʼunëʼ libíʼiliʼ lu guíʼ gabila. Ön, reaʼ libíʼiliʼ, guliʼgadxi Nu naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Tútiʼgaquiëʼ-baʼ gáyuʼbaʼ biguínnidoʼ len chopa dumí lásidoʼ. Bitiʼ ral-la ládxëʼë-baʼ Dios tu biguínnidoʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Lëscaʼ caní, yúguʼtë guitsaʼ ícjaliʼ nabábagaca lahuëʼ Dios. Que lë ni naʼ, bitiʼ gádxiliʼ. Nazácaʼtëröliʼ libíʼiliʼ ca zianbaʼ biguínnidoʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Gunnë́ʼ caʼ Jesús: —Reaʼ libíʼiliʼ: Yúguʼtë bönniʼ taʼnnë́ʼ néquiguequinëʼ quiaʼ nedaʼ lógaca bönachi, lëscaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, inníaʼ néquiguequinëʼ quiaʼ lógaquiëʼ gubáz láʼayi queëʼ Dios, ");
INSERT INTO zarNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ateʼ bönniʼ taʼdáʼbaguëʼë néquiguequinëʼ quiaʼ lógaca bönachi, lëscaʼ nedaʼ táʼbagaʼa néquiguequinëʼ quiaʼ lógaquiëʼ gubáz láʼayi queëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Yúguʼtë nupa bi ilaʼnnë́ quiaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, gaca uniti lahuëʼ Dios léguequi, pero nu innë́ ziʼ queëʼ Dios Böʼ Láʼayi, bitiʼ uniti lahuëʼ Dios nu naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Cateʼ ilaʼchë́ʼë libíʼiliʼ gapa naca lu yuʼu ga tuʼdubëʼ bönniʼ judío, en tuʼsëdëʼ queëʼ Dios, en lógaquiëʼ bönniʼ uluʼchiʼa uluʼsörö́ëʼ libíʼiliʼ, en lógaquiëʼ bönniʼ dë lu náʼagaquiëʼ, bitiʼ ubi uguíʼiliʼ nacxi gunliʼ o bizxi didzaʼ ubíʼiliʼ, o bizxi innaliʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Laʼ dza náʼasö usédinëʼ Dios Böʼ Láʼayi libíʼiliʼ le ral-laʼ innaliʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tu bönniʼ nútsëʼë ladaj bönachi zián naʼ rëʼ Jesús, rnnëʼ: —Bönniʼ Usedi, gudxëʼ bö́chaʼa gunnëʼ uláz quiaʼ le gutaʼ queëʼ xuztuʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús rëʼ lëʼ: —Bönniʼ. ¿Naruʼ zoa nu buzóa nedaʼ ca nu uchiʼa usörö́ libíʼiliʼ, o nu gun gatsaj le dë queë́liʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Níʼirö Jesús gudxëʼ bönachi nacuáʼ niʼ, rnnëʼ: —Buliʼyútsöcaʼ. Guliʼgún chiʼi cuinliʼ para cabí uhuídiʼliʼ. Le uziʼë xibé nu bönniʼ bitiʼ nácasö le zián le dë queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Níʼirö Jesús bë́ʼlenëʼ légaquiëʼ didzaʼ, bucúdzuʼë didzaʼ, rnnëʼ: —Zoëʼ tu bönniʼ riléʼenëʼ yöl-laʼ tsahuiʼ queëʼ, ateʼ runö́dzjadaʼ gulapa lu xiyúëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Níʼirö guzáʼ ládxëʼë bönniʼ naʼ, rnnëʼ: “¿Nacxi guntsaʼ? Bitiʼ dë ga gapa chiʼa le ruláʼ quiaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Níʼirö rnnëʼ: “Caní gunaʼ. Uquínnajgacaʼ yuʼu ga rapa chiʼa le ruláʼ quiaʼ, ateʼ gunaʼ yuguʼ yuʼu zxö́ntërö caʼ, ateʼ gapa chiʼa le ruláʼ quiaʼ niʼ, len yuguʼ le dë quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Níʼirö gaca guíë cuinaʼ: Chidë́daʼ quiaʼ zián le chinutubaʼ, le gáhuidaʼ zián iz. Uzíʼ ládxaʼa. Guíʼaj gahuaʼ, en udzéjadaʼ.” ");
INSERT INTO zarNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Níʼirö Dios rëʼ lëʼ: “Liʼ, bönniʼ bitiʼ bi nö́zinëʼ. Naʼa dzöʼ gátiuʼ. Naʼa, ¿nuzxi caz guequi que, lë naʼ chinutubuʼ?” ");
INSERT INTO zarNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Caní raca queëʼ bönniʼ rutubëʼ laʼ queë́zëʼ yöl-laʼ tsahuiʼ, en bitiʼ runëʼ le naca ca yöl-laʼ tsahuiʼ lahuëʼ Dios. ");
INSERT INTO zarNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Gudödi niʼ Jesús gudxëʼ yuguʼ bönniʼ usëda queëʼ, rnnëʼ: —Que lë ni naʼ reaʼ libíʼiliʼ: Bitiʼ ubi uguíʼiliʼ niʼa que le guíʼaj gáguliʼ, lë naʼ nabániliʼ, o niʼa que lariʼ gáculiʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nácarö lesacaʼ yöl-laʼ naʼbán queë́liʼ ca le ráguliʼ, ateʼ nácarö lesacaʼ idú le nácaliʼ ca lariʼ ráculiʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Buliʼyutëz ca raca quégacabaʼ boíquiaj. Bitiʼ tázabaʼ, en bitiʼ taʼlápabaʼ, en bitiʼ nacuáʼ quégacabaʼ ga ilún chíʼibaʼ le ruláʼ quégacabaʼ, pero Dios rugahuëʼ légacabaʼ. ¿Naruʼ cabí nazácaʼtëröliʼ libíʼiliʼ ca yuguʼ biguínnidoʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Nuzxi caz bönniʼ ládjaliʼ gaca gunëʼ ga soëʼ ibanëʼ iaʼtú chíʼidoʼos tuʼ ruúbi ruguíʼi ládxiʼdaʼahuëʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Que lë ni naʼ, channö cabí gaca gunliʼ lë ni naca cuídiʼsö, ¿bizx que ruúbi ruguíʼiliʼ niʼa que le naca zxö́ntërö? ");
INSERT INTO zarNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Buliʼyutëz ca taʼzxö́n yöjdoʼ. Bitiʼ tun du lariʼ, en bitiʼ taba lariʼ, pero reaʼ libíʼiliʼ, bitiʼ gúcarö lachi le gúcuëʼ Salomón ca nácagaca yöjdoʼ ni, sal-laʼ gútaʼdaʼ yöl-laʼ tsahuiʼ queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Channö Dios runëʼ lachi yöj guíxiʼdoʼ rö́ʼgaca naʼa laʼ guixiʼ, ateʼ cuxö́ huidzaj ilaʼguʼë léguequi lu guíʼ, ¿naruʼ cabí gunëʼ le nácarö dxiʼa queë́liʼ, libíʼiliʼ naʼ bitiʼ réajlëʼëliʼ Dios idú ládxiʼliʼ? ");
INSERT INTO zarNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Que lë ni naʼ, bitiʼ güíʼi ládxiʼliʼ le ral-laʼ gáguliʼ, en le ral-laʼ guíʼjaliʼ, en bitiʼ ubi uguíʼi ládxiʼdoʼoliʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yúguʼtë lë ni taʼguilaj bönachi yödzölió ni, pero chinö́z quézinëʼ Xúziliʼ Dios le riquíniliʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Guliʼgüíʼ ládxiʼliʼ tsúʼuliʼ ga rinná bëʼë Dios, ateʼ yúguʼtë lë ni cuʼë xinöza queë́liʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Gunnë́ʼ caʼ Jesús: —Bitiʼ gádxiliʼ, libíʼiliʼ naʼ nácaliʼ böʼcuʼ zxílaʼdoʼ quiaʼ. Nabábasiliʼ zóaliʼ, pero raza ládxëʼë Xúziliʼ Dios gunnëʼ queë́liʼ lataj tsúʼuliʼ ga niʼ rinná bëʼë Lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Guliʼgutiʼ le dë queë́liʼ, en buliʼnödzaj quégaca bönachi yechiʼ. Caní gaca, gunliʼ queë́liʼ yöxaj dumí le cabí gaca ditaj, en cúʼuliʼ yöl-laʼ tsahuiʼ naʼ yehuaʼ yubá le bitiʼ ubidxi udú, ga niʼ bitiʼ idxinëʼ bönniʼ gubán, en bitiʼ usunítibaʼ böaʼdoʼ le. ");
INSERT INTO zarNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ga niʼ dë yöl-laʼ tsahuiʼ queë́liʼ, niʼ güíʼi ládxiʼliʼ idxinliʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Gunnë́ʼ caʼ Jesús: —Guliʼsóa sinaʼ, en guliʼquelaʼ guíʼ le uzeníʼ queë́liʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Guliʼgaca ca bönniʼ huen dxin taʼbözëʼ dza huödëʼ xángaquiëʼ, bönniʼ saʼyéajëʼ laní que yöl-laʼ rutsaga naʼ, para cateʼ udxinëʼ, en ulidzëʼ, laʼ ilaʼsáljatëʼ queëʼ tsuʼë. ");
INSERT INTO zarNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bicaʼ bágaca huen dxin naʼ ilaʼcuʼë ban ladxiʼ cateʼ huödëʼ xángaquiëʼ. Le nácatë reaʼ libíʼiliʼ, upáʼa cuinëʼ xángaquiëʼ naʼ, ateʼ gunëʼ ga ilaʼböʼë ga ilahuëʼ, ateʼ cuʼë le ilahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Sal-laʼ huödëʼ cateʼ chiral-la o idú guluhuëla, channö idixáquiëʼ légaquiëʼ nacuʼë ban ladxiʼ, bicaʼ bágaca huen dxin naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Lë ni ral-laʼ inö́ziliʼ. Laʼtuʼ nö́zinëʼ xan yuʼu bizxi dza huadxinëʼ bönniʼ gubán, usubán ládxëʼë, en bitiʼ guʼë lataj bönniʼ naʼ udxíëʼ yeru lidxëʼ, para cabí cuanëʼ le dzöʼö lidxëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Que lë ni naʼ, guliʼsóa ban ladxiʼ caʼ libíʼiliʼ, tuʼ huödaʼ nedaʼ, Bönniʼ Guljëʼ Bönachi, tu dza bitiʼ ribö́zaliʼ nedaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Níʼirö Pedro gunábinëʼ Jesús, rnnëʼ: —Xan, ¿naruʼ reoʼ nétuʼsö lë ni rucúdzuʼu didzaʼ, o reoʼ caʼ caní yúguʼtë bönachi? ");
INSERT INTO zarNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Rëʼ Xanruʼ lëʼ: —¿Nuzxi naʼ bönniʼ huen dxin tsahuiʼ, en réajniʼinëʼ, dë lu nëʼë uláz queëʼ xanëʼ? Bönniʼ ni, xanëʼ udödëʼ lu nëʼë lidxëʼ para cateʼ gálaʼrö ilahuëʼ bönniʼ nacuʼë lidxëʼ, guʼë que queë́gaquiëʼ le ilahuëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Bicaʼ ba bönniʼ huen dxin naʼ cateʼ huödëʼ xanëʼ, idixáquiëʼ lëʼ runëʼ caní dxin naʼ nudödëʼ lu nëʼë. ");
INSERT INTO zarNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Le nácatë reaʼ libíʼiliʼ, udödëʼ xanëʼ lu nëʼë bönniʼ huen dxin tsahuiʼ naʼ idutë le dë queëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Channö guéquinëʼ bönniʼ huen dxin naʼ huadzenëʼ huödëʼ xanëʼ, ateʼ isí lahuëʼ guʼë döʼ quégaquiëʼ iaʼzícaʼrëʼ huen dxin, bönniʼ en nigula, en isí lahuëʼ guíʼaj gahuëʼ, en súdxinëʼ, ");
INSERT INTO zarNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","níʼirö huödëʼ xanëʼ bönniʼ huen dxin naʼ cateʼ bitiʼ ribözëʼ lëʼ, en cateʼ bitiʼ réquibeʼenëʼ, ateʼ usacaʼ ziʼë bönniʼ huen dxin bitiʼ náquiëʼ tsahuiʼ naʼ, en ichúguiëʼ queëʼ quiʼi sáquiëʼ ca narugu quégaquiëʼ bönniʼ bitiʼ taʼyéajlëʼë. ");
INSERT INTO zarNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Bönniʼ huen dxin naʼ nö́zinëʼ le rë́ʼënëʼ xanëʼ, en bitiʼ zoëʼ sinaʼ, en bitiʼ runëʼ ca rnnëʼ xanëʼ, bönniʼ ni, quínitërëʼ xanëʼ lëʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Channö cabí nö́zinëʼ tu bönniʼ huen dxin le rë́ʼënëʼ xanëʼ, en gunëʼ le gun ga ibáguëʼë le quinëʼ xanëʼ lëʼ, bönniʼ ni quinëʼ lëʼ látiʼdoʼos. Tu bönniʼ yuʼu lu nëʼë yenniʼ, yenniʼ unabëʼ xanëʼ lu nëʼë, ateʼ bönniʼ naʼ xanëʼ nuzxöni ládxëʼë lëʼ le zxön, le zxö́ntërö caʼ unabëʼ xanëʼ lu nëʼë bönniʼ huen dxin naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Gunnë́ʼ caʼ Jesús: —Bidaʼ nedaʼ dujénaʼ ga tsegui guíʼ yödzölió ni, en caba ládxaʼa chinaguélaʼ guíʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Naʼa, dë tu le ral-laʼ quiʼi sacaʼa le naca ca tu le idílidaʼ nisa, ateʼ röʼa böniga ga idxintë gaca caní quiaʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Naruʼ réquiliʼ bidaʼ dulequi dxíaʼ le raca yödzölió ni? Reaʼ libíʼiliʼ: ¡Calëga! Bidaʼ duléquiaʼ le gun ga ilaʼrúaj choplö bönachi. ");
INSERT INTO zarNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Naʼa isí lo uluʼláʼalen luzë́ʼeguequi gayuʼ bönachi nacuáʼ tu yuʼu. Tsonnëʼ ilaʼdáʼbaguëʼë chopëʼ nazíʼigaquiëʼ xtídzaʼa, ateʼ chopëʼ naʼ ilaʼdáʼbaguëʼë tsonnëʼ naʼ. ");
INSERT INTO zarNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nu bönniʼ zóabiʼ biʼi bönniʼ queëʼ táʼbaguëʼë zxíʼinëʼ naʼ, ateʼ biʼi bönniʼ naʼ táʼbagaʼbiʼ xúzibiʼ. Nigula zóabiʼ biʼi nigula queë́nu táʼbagaʼnu zxíʼininu naʼ, ateʼ biʼi nigula naʼ táʼbagaʼbiʼ xináʼabiʼ. Nigula zóanu nigula zxoaʼ lídxinu táʼbagaʼnu zxoaʼ lídxinu naʼ, ateʼ nigula zxoaʼ lídxinu naʼ táʼbagaʼnu xtoʼ zxíʼininu. ");
INSERT INTO zarNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús gudxëʼ caʼ bönachi zián nacuáʼ niʼ, rnnëʼ: —Cateʼ riléʼeliʼ zaʼ böaj sacaʼ ga ribía gubidza, laʼ rnnátëliʼ: “Hualaj guiö́j”, ateʼ caní raca. ");
INSERT INTO zarNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Cateʼ recja böʼ zaʼ sacaʼ ga ridödi gubidza beoʼ ziaga, rnnaliʼ: “Udzáʼa naʼa”, ateʼ caní raca. ");
INSERT INTO zarNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Libíʼiliʼ, bönniʼ ruluíʼisö tsahuiʼ cuinliʼ. Nö́zi