﻿USE sofia;
DROP TABLE IF EXISTS sofia.zaoNT_vpl;
CREATE TABLE zaoNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zaoNT_vpl WRITE;
INSERT INTO zaoNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucrist ngol lo raz chaan rey David, ne lo raz chaan Abraham kuu ngok tey re zha Israel ndala. ");
INSERT INTO zaoNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ngok xut Isaac, Isaac ngok xut Kob, ne Kob ngok xut Judá ne re wets Judá. ");
INSERT INTO zaoNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá ngok xut Fares ne xut Zara, ne xnaa rop zhaʼa ngok Tamar, Fares ngok xut Esrom, Esrom ngok xut Aram. ");
INSERT INTO zaoNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ngok xut Aminadab, Aminadab ngok xut Naasón, ne Naasón ngok xut Salmón. ");
INSERT INTO zaoNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón ngok xut Booz ne Rahab ngok xnaa Booz, Booz ngok xut Obed ne Rut ngok xnaa Obed, ne Obed ngok xut Isaí. ");
INSERT INTO zaoNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí ngok xut rey David, ne lee rey David ngok xut Salomón, ne lee xnaa Salomón ngok ngot kuu ngok tsaal Urías. ");
INSERT INTO zaoNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón ngok xut Roboam, Roboam ngok xut Abías, ne Abías ngok xut Asa. ");
INSERT INTO zaoNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ngok xut Josafat, Josafat ngok xut Joram, ne Joram ngok xut Uzías. ");
INSERT INTO zaoNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías ngok xut Jotam, Jotam ngok xut Acaz, ne Acaz ngok xut Ezequías. ");
INSERT INTO zaoNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías ngok xut Manasés, Manasés ngok xut Amón, ne Amón ngok xut Josías. ");
INSERT INTO zaoNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías ngok xut Jeconías ne re wets Jeconías, ne re zhaʼa naban leettsa mndeno re zha Babilonia re zha Israel par Babilonia. ");
INSERT INTO zaoNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ne leettsa mtelaa re zha Babilonia re zha Israel; lee Jeconías ngok xut Salatiel, ne lee Salatiel ngok xut Zorobabel. ");
INSERT INTO zaoNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel ngok xut Abiud, Abiud ngok xut Eliaquim, ne Eliaquim ngok xut Azor. ");
INSERT INTO zaoNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ngok xut Sadoc, Sadoc ngok xut Aquim, ne Aquim ngok xut Eliud. ");
INSERT INTO zaoNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ngok xut Eleazar, Eleazar ngok xut Matán, Matán ngok xut Kob; ");
INSERT INTO zaoNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ne lee Kob ngok xut Che tsaal Mari xnaa Jesús, Zha Kuu Mtaal Diox Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ne tsiida raz ngoo desde Abraham asta rey David, ne tedib tsiiday desde rey David asta leettsa mndeno re zha Babilonia re zha Israel par Babilonia, ne tedib tsiiday ngoo desde leettsa mtelaa re zha Babilonia re zha Israel, asta leettsa mzin Zha Kuu Mtaal Diox Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Tenzhee ngok leettsa ngol Jesús: Leettsa lee Mari xnaa Jesús naka diiz tseya kon Che, per bee ter yo rop zha, ne lee Mari ngoo zhiinn por yalney chaan Mbi Nayon chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tsa lee Che mtsow xgab laa Mari, tak thib mbyi wen nak zha, mtsow zha xgab laa zha Mari xgaatsta, tak nlaazt zha roo yalnathoy Mari lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ne leettsa ngetsow Che xgab laa Che Mari, lee thib mandad chaan Diox cha ngwani lo Che lo mkaal, ne nzhab lo Che: ―Che, lu nak thib zha raz rey David, yat leettsooʼa kaaʼa Mari, tak lee Mari ngoo zhiinn por yalney chaan Mbi Nayon, ");
INSERT INTO zaoNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ne gap Mari thib mbet ne tob leʼa mbet Jesús. Tbaa role mbet tak lee mbet tuyy falt chaan re tawlaz mbet. ");
INSERT INTO zaoNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ne lee le Jesús nak: Lee Zha Nabee ntelaa. Reta koree mriid tsa ngok kuu nzhab Zha Nabee, por roo profet kuu ngoo ndala, or nzhab profet: ");
INSERT INTO zaoNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Lee thib nzaa kuu ter gak rop thib mbyi, yo zhiinn ne gap thib mbet; ne tob le zha mbet Emanuel, (diiz ree nak: “Diox ndo kon lee”). Is. 7:14 ");
INSERT INTO zaoNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ne leettsa mroo mkaal lo Che, tsa mtsow Che kuu nzhab mandad chaan Diox lo Che, ne mkayaa Che Mari ngok Mari tsaal Che. ");
INSERT INTO zaoNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Per ngogt rop zha, asta leettsa ngol xgann Mari kuu ner; ne mtob le Che mbet Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Leettsa ngol Jesús yez Belén chaan yezlyu Judea, re wiz kuu mban rey Herodes, tsya lee chop tson zha kuu nteed kwent chaan re mbel kuu nzib lobee, mroo lad ta nlen wiz, ne mzin re zha Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ne mnaabdiz re zha, nzhab zha: ―¿Ma mbet kuu gak rey chaan re zha Israel, kuu ngola? Tak asta ta nlen wiz mwii nee mbel chaan mbet, kona ndyaad nee gol nee lo mbet. ");
INSERT INTO zaoNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Per leettsa mbin rey Herodes ne re zha yez Jerusalén koree, kwathoz nda leettsoo Herodes ne noga re zha Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tsa mkaltaa Herodes re ngwleyy kuu nabee lo re ngwleyy, ne re maestr chaan ley, tsa mnaabdiz Herodes lo re zha, naa plo nzhab re profet kuu ngoo ndala ndoblo gal Zha Kuu Taal Diox Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tsa lee re zha nzhab: ―Yez Belén, kuu nzi yezlyu Judea; tak tabaa nkey lo xkeets Diox kuu mkee profet, or kuu nzhab profet: ");
INSERT INTO zaoNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Goo zha yez Belén kuu nzi yezlyu chaan Judá, tegal laz goo nak thib yez kuu nataagt xid re yez kuu nzi yezlyuʼa, per lo goo roo thib zha kuu nabee ne kenap re zha yez da, zha Israel. Mi. 5:2 ");
INSERT INTO zaoNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tsa xgaatsta mrez rey Herodes re zha kuu nteed kwent chaan re mbel kuu nzib lobee, ne mnaabdiz rey naa pol mloo mbel lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tsa mtaal Herodes re zha yez Belén, ne nzhab rey lo re zha: ―Gwa goo, gwakwaan goo mbet, ne leettsa yetsal mbet lo goo, ko goo diize lon, tsa no na ya gol lo mbet. ");
INSERT INTO zaoNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Leettsa ngwalo mbin re zha kuu nzhab rey, tsa ngoo re zha net nda zha, ne lee mbel kuu mwii zha ner, mroo mndener lo re zha, ne mlet mbel asta ta nax mbet. ");
INSERT INTO zaoNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ne or mwii re zha lee mbel mlet, kwathoz naley ngoo leettsoo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ne leettsa mndaab re zha leen yuu, mwii zha lo mbet kon Mari xnaa mbet, tsa mtobxub re zha ne mbil zha lo mbet; ne mloo re zha re kwaa ndano zha mndelaaz zha lo mbet, mndaa zha or, straak ne mirra. ");
INSERT INTO zaoNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ne lo mkaal mni Diox lo re zha, tsa retabt raa zha lo rey Herodes, tata mod tedib net mretab re zha laz zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Leettsa lee re zha kuu nteed kwent chaan mbel mroo ndya, lee thib mandad chaan Diox ngwani lo Che lo mkaal ne nzhab lo Che: ―Gwache, ne teno mbet kon xnaa mbet, tyee goo par yezlyu Egipto, ne kwet goo tya asta or nin lo goo roo goo tya, tak lee rey Herodes nkwaan mbet par kuth mbet. ");
INSERT INTO zaoNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tsa ngwache Che, leeka yaala ndano Che mbet ne xnaa mbet, ne ndya re zha par Egipto, ");
INSERT INTO zaoNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ne tya ngoo zha asta nguth Herodes; tsa mrolo kuu nzhab Zha Nabee, por roo profet kuu ngoo ndala leettsa nzhab profet: “Asta yez Egipto mrezʼn xgann na”. Os. 11:1 ");
INSERT INTO zaoNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Per leettsa bee ter gath rey Herodes, myeen rey lee re zha kuu nteed kwent chaan mbel kuu nzib lobee, mkedi zha rey, tsa kwathoz mkezhyan rey, kona lee rey mnabee ne mtaal soldad yez Belén ne re yez kuu nzi gaxta Belén, tsa kuth zha re mbet bzhizh kuu nap asta chop liin, kuu ngol tyemp kuu nzhab re zha kuu nteed kwent chaan mbel lo rey Herodes. ");
INSERT INTO zaoNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tbaa mrolo kuu nzhab profet Jeremí, or nzhab profet: ");
INSERT INTO zaoNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Desde yez Ramá mbin na thib bos, ta mbin na nzhonn ne ndi leettsoo re ngot kuu nak raz Raquel, por re zhiinn re ngot nzhonn ngot, tak nguth re zhiinn ngot, ne nlaazt re ngot tetsey zha leettsoo ngot. Jer. 31:15 ");
INSERT INTO zaoNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Per leettsa ngutha rey Herodes, lee thib mandad chaan Zha Nabee ngwani lo Che lo mkaal yez Egipto, ne nzhab lo Che: ");
INSERT INTO zaoNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Gwache, teno mbet ne xnaa mbet ne bretab yezlyu Israel tedib welt, tak ngutha re zha kuu nlaaz kuth mbet. ");
INSERT INTO zaoNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tsa ngwache Che ne mndeno Che mbet ne xnaa mbet, ne mretab re zha yezlyu Israel tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Per leettsa mbin Che lee Arquelao xgann rey Herodes nabee Judea, tsa mzeb Che retab Che tya; per lee Diox mni lo Che lo mkaal; kona ndya Che par yezlyu Galilea. ");
INSERT INTO zaoNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ne mzin Che ngoo Che yez kuu le Nazaret. Tsa mrolo kuu nzhab re profet, leettsa nzhab re zha: “Nazaren tob le re men Jesús”. ");
INSERT INTO zaoNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ne lee re wiza lee Juan kuu mtsowleyy re men, mzin yubiz chaan yezlyu Judea. ");
INSERT INTO zaoNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ne nzhab Juan: ―¡Btsee goo mod went kuu nak goo, tak lee wiz kuu lee Diox nabee lo goo mzin gaxa! ");
INSERT INTO zaoNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ne Juan ree mteth profet Isaí, leettsa nzhab profet: Lee thib zha kuu ndo yubiz, dib gan zha kwez zha: “Thib nali bloo goo leettsoo goo, par kayaa goo Zha Nabee, ne nali gok goo lo re kuu ntsow goo”. Is. 40:3 ");
INSERT INTO zaoNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ne lee xab Juan natexkwaa kon yits lad kamey, ne naliib thib sinch yid leeyy Juan; ne kuu nzhow Juan nak ngebeez ne kuu nzhuu Juan nak mzin wan. ");
INSERT INTO zaoNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Reta men yez Jerusalén, re men yezlyu chaan Judea, ne re men re yez kuu nzi dita roo yoo Jordán ngwa lo Juan. ");
INSERT INTO zaoNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Or ngwalo mbin re zha lee Juan nzhab, ndoblo xoobdol zha re kuu went kuu mtsow zha. Tsa mxoobdol re zha re kuu went kuu mtsow zha, ne lee Juan mtsowleyy zha leen yoo Jordán. ");
INSERT INTO zaoNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Per or mwii Juan kwathoz re zha fariseo ne re zha saduceo ndyaad gakleyy lo Juan, tsa nzhab Juan lo re zha: ―¡Goo nak zha kuu nakap nak taxal mbeel! ¿Cho ne lo goo tak laa goo lo yalnayii chaan Diox, kuu yaad leettsa lux yezlyu? ");
INSERT INTO zaoNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ner ban goo thib mod nali, ne bloo goo mtsee goo mod went kuu nak goo, tsaraa yaad goo tsa tsow leyyʼn goo, ");
INSERT INTO zaoNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ne rubt goo gab goo: “Zhiinn Abraham nak nee”. Kona tegal ndaa nee falt tekayaa Diox nee, tak wlipaa na nin lo goo, lee Diox tak tsow lo re ke ree roo zhiinn Abraham, kona ndechet Diox goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tak lista ndo Diox par teti Diox goo, os tseet goo mod went kuu nak goo, ne leey nak, taxal yeba kuu ndoba xann re ya kuu ndaat xle wen, tsa ga zhay ne ko zhay lo ki. ");
INSERT INTO zaoNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Tak wlipaa lee na ntsowleyy goo kon nit, tsa tsee goo mod went kuu nak goo; per lee men kuu ndyaadke ditsʼn, tsowleyy goo kon Mbi Nayon ne kon ki, tak masraa nataak zha nake na, kona neeka dits labyid zha ndoblotʼn xakʼn. ");
INSERT INTO zaoNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Lee zha nak taxal thib zha kuu lista ndo nzo ya yaa, par koo paj lo nzob xtil, ne kotsow zha nzob xtil leen loo, lee paj teyy zha lo ki kuu thitanax nyuyyt. ");
INSERT INTO zaoNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tsa ngwa Jesús roo yoo Jordán kuu nzi yezlyu Galilea ta ndo Juan, tsa tsowleyy Juan Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ner mzhyalt Juan, tsa nzhab Juan lo Jesús: ―Lu ndoblo tsowleyyʼn. ¿Chebee leel lu ndyaad gakleyy lon? ");
INSERT INTO zaoNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Lee Jesús mkab, ne nzhab: ―Bloo kona yeka nal, tak ropaa ndoblo tsow kuu nlaaz Diox. Tsaraa mzhyal Juan mtsowleyy Juan Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ne or ngwalo ngokleyy Jesús ne mroo Jesús leen nit, oraaka lee yibaa mzhaal, ne lee Mbi Nayon chaan Diox ndela taxal thib palom mla dits Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tsa mbin re men thib bos kuu mroo yibaa kuu nzhab: ―Zha ree nak xgann na kuu kwathoz nke leettsoon, ne kwathoz wen nzo leettsoon nen zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tsa lee Mbi Nayon ndano Jesús thib ta yubiz, ne leettsa mndo Jesús tya, lee Maxuuy ngwalaaz gatsow Jesús kuu went. ");
INSERT INTO zaoNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ne chop gal wiz ne chop gal yaal mndo Jesús tya, ne yent kwaan ndow Jesús, tsaraa mlann Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tsa lee Maxuuy mbig lo Jesús, tsa naa chu tetsow Jesús kuu gab Maxuuy, tsa nzhab Maxuuy lo Jesús: ―Os leeʼa wlipaa Xgann Diox naka, bloo leeʼa nak Xgann Diox, guz tsa lee re ke ree reyal pan. ");
INSERT INTO zaoNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Per lee Jesús mkab, ne nzhab: ―Lo xkeets Diox nzhab: “Nabant men kon beeta pan, sinke lee men naban por re diiz kuu ndroo roo Diox”. Dt. 8:3 ");
INSERT INTO zaoNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tsa mndeno Maxuuy Jesús yez Jerusalén, yez nayon, ne mndeno Maxuuy Jesús yek gwodoo ta mas ya ndab, ");
INSERT INTO zaoNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ne nzhab Maxuuy lo Jesús: ―Os leeʼa wlipaa Xgann Diox naka, bloo leeʼa nak Xgann Diox, brethin par yath, yent kwan taka, tak lee lo libr chaan Salm nzhab: “Lee Diox taal mandad chaan Diox, tsa ten mandad lu kon yaa mandad, tsa gabta lo ke”. Sal. 91:11-12 ");
INSERT INTO zaoNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tsa lee Jesús nzhab: ―Noga nzhab lo xkeets Diox: “Kithnota Diox kuu nak Zha Nabee loʼa”. Dt. 6:16 ");
INSERT INTO zaoNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ne bluz mndeno Maxuuy Jesús yek thib yii kuu kwathoz naro, tsa mloo Maxuuy reta yez kuu nzi lo yezlyu lo Jesús, re yalnabee chaan re yeza, naa xomod chul na re yeza. ");
INSERT INTO zaoNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tsa nzhab Maxuuy lo Jesús: ―Reta koree tan loʼa, os leeʼa tobxuba lon ne gola lon. ");
INSERT INTO zaoNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tsa nzhab Jesús lo Maxuuy: ―Beche lon goltʼn loʼa, tak lo xkeets Diox nzhab: “Bil lo Diox kuu nak Zha Nabee loʼa, ne beeta lo Diox ndoblo gona diz”. Dt. 6:13 ");
INSERT INTO zaoNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tsaraa mlaa Maxuuy Jesús, tsa lee chop tson mandad chaan Diox mlortsin lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Leettsa mbin Jesús lee Juan nzo tsib, tsa ngwa Jesús yezlyu Galilea, ne leettsa ndo Jesús yezlyu Galilea, tsa ngwa Jesús yez Nazaret. ");
INSERT INTO zaoNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Per myaant Jesús yez Nazaret, sinke lee Jesús ndya ngoo yez Capernaúm, yez kuu nzi gax roo nitdoo, yezlyu kuu ngok chaan Zabulón rop Neftalí, tsa loo Jesús lo re men tya. ");
INSERT INTO zaoNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Koree ngok tsa mrolo kuu mkee profet Isaí, or kuu nzhab profet: ");
INSERT INTO zaoNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Yezlyu chaan Zabulón rop Neftalí, kuu nzi roo nitdoo tedib lad roo yoo Jordán, yezlyu Galilea ta nzo re zha kuu nagt zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Lee re zha yeza mndaa falt, kona nabil nzo leettsoo zha, nak zha taxal thib yez kuu nzi lo yalkow, ne mndelo re zha yeza myen xkiiz Diox, kona nak taxal mwii zha thib xni thoz, ne lee re zha kuu nzi thib ta nathoz ta nzo ryez gath zha, mndelo zha myen zha xkiiz Diox, ne nake taxal mla thib xni lo re zha. Is. 9:1-2 ");
INSERT INTO zaoNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Desde tsya mndelo Jesús mndaa kwent xkiiz Diox, ne nzhab Jesús: ―Btsee goo mod went kuu nak goo, tak lee wiz kuu lee Diox nabee lo goo mzin gaxa. ");
INSERT INTO zaoNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ne leettsa ndiy Jesús roo nitdoo chaan Galilea, tsa mwii Jesús Simún kuu noga le Pey ne wets Pey kuu le Ndres, rop zha ree ngeniit mbel leen nitdoo, tak zha niit mbel nak zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tsa nzhab Jesús lo rop zha: ―Bteke goo ditsʼn, tsa tsowʼn gak goo zha kuu niit men par Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ne oraaka mlaa zha yex zha ne mndeke zha dits Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ne ndaka Jesús, tsa mwii Jesús Santiag ne Juan, rop zha ree nak xgann Zebedeo, lee re xut zha nzo leen thib kano ngeyib zha yex zha, tsa mrez Jesús rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ne oraaka mlaa rop zha xut zha leen kano ne mndeke zha dits Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ne mndiy Jesús dita yezlyu Galilea, ne nloo Jesús lo re men ta nkaltaa re men nteed xkiiz Diox. Ne ndaa Jesús kwent Diiz Chul chaan ta nabee Diox, ne mtegwe Jesús relota yiz ne relota yalne kuu ndak re men. ");
INSERT INTO zaoNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ne dita yezlyu Siria myath re kuu ntsow Jesús; ne lee re mena ndyaadno re zha kuu ne ndak, re zha kuu ndak tedib net re yiz, re zha kuu nzo mbi fyer leettsoo, re zha kuu ndak yizguthye ne re zha mthans, tsa mtegwe Jesús re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kwaro re men yezlyu Galilea, re men re tsii yez kuu nak Decápolis, re men Jerusalén, re men yezlyu Judea ne re men kuu nzo tedib lad roo yoo Jordán ndyaad lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Or mwii Jesús kwathoz men, tsa mkendab Jesús yek yii ne mndob Jesús, ne myaad re zha kuu ngeteed lo Jesús lo Jesús, ");
INSERT INTO zaoNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ne mndelo Jesús mloo lo re zha, ne nzhab Jesús: ");
INSERT INTO zaoNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Wen nzo leettsoo Diox ne Diox re goo kuu nyeen leettsoo ndeche Diox, tak Diox taa diiz tab goo ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Wen nzo leettsoo Diox ne Diox re goo kuu nzhonn, tak mndaa goo falt, tak lee goo tetsey leettsoo goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Wen nzo leettsoo Diox ne Diox re goo kuu nadoo nak, tak lee goo kayaa yezlyu kuu taa Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Wen nzo leettsoo Diox ne Diox re goo kuu nlaaz tsow re kuu nali, tak goo nak taxal zha kuu nlann ne nzheek leettsoo, ne lee goo tse leettsoo. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Wen nzo leettsoo Diox ne Diox re goo kuu nlat leettsoo ne taben, tak talat leettsoo Diox ne Diox goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Wen nzo leettsoo Diox ne Diox re goo kuu nambi leettsoo, tak lee goo wii lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Wen nzo leettsoo Diox ne Diox re goo kuu ntsow wen kwin re men, tak lee goo role zhiinn Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Wen nzo leettsoo Diox ne Diox re goo kuu ndreke re men dits, tak ntsow goo kuu wen, tak chaan goo nak ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Wen nzo leettsoo Diox ne Diox re goo, leettsa ntsalzhoo zha goo ne ndreke zha dits goo, ne nkedi zha ni zha ndota kuu went lo goo, tak tataka mreke zha dits re profet kuu ngoo ndala. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ndoblo wen ne naley bloo goo leettsoo goo, tak naroob re kwaa kayaa goo yibaa. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Goo nak taxal ted lo yezlyu ree, per os lee ted natsigt ted, ¿xomod gak natsig ted tedib welt? Lortsint raay, sinke kobi zhay, tsa lo re men ditse. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Goo nak taxal xni lo yezlyu. Leeka tata, gagt gaats thib yez kuu nzi yek yii. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ne neeka nkeet zha thib kandil, ne ngo zhay xann thib zhibey; sinke ntob zhay ta mas ya ndab, tsa teniy lo re men kuu nzo leen yuu. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ndoblo goo tsow goo re kuu wen, tsa wii re men re kuu wen kuu ntsow goo. Goo nak taxal xni kuu nteni, tsa wii re men re kwaa. Btsow gooy, tsa leettsa wii zha re kuu wen kuu tsow goo, taa zha texkix lo Xutaa Diox kuu ndob yibaa. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Tsowt goo xgab leen ndyal luux ley kuu mkee Moisés, ne re kuu nzhab ne re kuu mkee re profet kuu ngoo ndala, sinke leen ndyal tsow kuu nzhab ley ne kuu nzhab re profet. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tak wlipaa na nin lo goo, leettsa lee yezlyu ree ne lee lobee bee nzika, gagt yiib neeka thib lan re diiz kuu nke lo ley, sinke reta ndoblo gak. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kona loka cho zha kuu gont diiz thib re kuu nabee lo ley, tegal kuu mas nataagte, ne tataga loo zhay lo tedib net zha, leeka tata lee zhaʼa gak zha kuu mas nataagt ta nabee Diox. Per lee zha kuu nzhon diize ne tataka loo zhay lo tedib net zha, zhaʼa gak zha kuu mas nataak ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kona nin lo goo, os lee goo gagt goo masraa wen lo re kuu ntsow goo, nake re maestr chaan ley ne nake re fariseo, tsowt goo gan tab goo ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Ne mbin goo kwan nzhab Moisés lo re teyaa zha ndala, leettsa nzhab Moisés: “Kuthta tabena, ne loka cho kuth taben, lee Diox naab kwent lo zhaʼa ne laat zha”. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Per lee na ni lo goo, loka cho kuu gak nayii lo taben, tenaab Diox kwent lo zhaʼa, ne loka cho gab lo taben “zha nad”, tenaab jwez kwent lo zhaʼa ne laat zhaʼa, ne loka cho gab “bxen” lo taben, zhaʼa nak thib zha kuu ndoʼa net ndya gabil. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Kona os leeʼa ndyaadnoʼa gona lo bkoog chaan Diox, ne ora telaaza mndaaʼa thib falt lo wetsa, ");
INSERT INTO zaoNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","blaa gona leeka tya, ne bkwaan mod yaana wen kon wetsa. Tsaraa bretaba lo bkoog chaan Diox ne btaa gona. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Os lee thib zha kuu nayii neʼa, teno zha lu lo zha kuu nak tsiin par keki zha lu, kwaan mod tsa wen yaana kon lee zha, or bee ter kwez zha lu lo zha kuu nak tsiin, tak os leeʼa yaanta wen kon zha kuu nayii neʼa, cha yataa zha lu lo zha kuu naab kwent loʼa, ne lee zha kuu naab kwent lo lu taa zha lu lo zha kuu nkenap roo tsib, tsa ko zha lu tsib. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Wlipaa na nin roota tya, asta yelo kizha lultm rehal kuu ndobloʼa kizha. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Ne mbina goo nzhab Moisés: “Gagt rop goo kon thib zha kuu nagt tsaal goo”. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Per leen ni lo goo, loka cho thib mbyi kuu ngwii lo thib ngot, ne ntsow zha xgab gak rop zha kon ngota, mndaaʼa zha falt. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kona os lee ngutloʼa ntsow ntsowa kuu went, btsow kuu taxal mlooʼa ngutloʼa ne mlobi luy tith, mas wen luuzha thib ngutloʼa ne ndyaʼa yibaa, nake diba ndya gabil. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ne os lee yaa bana ntsow ntsowa kuu went, btsow kuu taxal mga luy choʼa; tak mas wen luuzha thibka yaaʼa ne ndyaʼa yibaa, nake diba ndya gabil. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Ne noga nzhab Moisés: “Loka cho mbyi kuu laa tsaal, ndoblo taa zha thib yeets kuu mroo yuulow, kuu nzhab lee zha mtso rop tsaal”. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Per leen ni lo goo, os lee thib mbyi laa tsaal, ne nagte tak ngok rop ngot zha kon tedib mbyi, mbyiʼa ntsow taa ngot falt, leettsa kaa ngot tedib mbyi, ne noga mbyi kuu kaa ngota taa falt. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Noga mbin goo nzhab Moisés lo re teyaa zha ndala: “Lortsinta le Diox par tseloʼa, sinke btsow kuu nzhaba tsowa lo Zha Nabee”. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Per leen ni lo goo, tselot goo por neeka thib re kwaa, neeka por re zha kuu nzo yibaa, tak tya nak ta ndob Diox, ");
INSERT INTO zaoNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","neeka por re mbi kuu nzo lo yezlyu, tak tya nak ta ndo nii Diox; neeka por yez Jerusalén, tak tya nak yez chaan rey, zha kuu kwathoz nataak. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Neeka tselot goo gab goo tan na gathʼn os tsowtʼn kuu nin. Ndoblot tselo goo, tak Diox ntsow nzhak re kwaa ne nagte goo, tak neeka thib goo gagt tsow naguz goo o tsow goo nagat goo thib yitsek goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Sinke nali ndoblo tediz goo gab goo “wliy” o “wlite”. Tak os lee goo tsowt goo tabaa, went kuu ntsow goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Noga mbin goo nzhab Moisés: “Os lee thib zha koo ngutlo tedib zha, tataka ndoblo tsow zha lo zhaʼa, ne os lee thib zha koo keley tedib zha, tataka ndoblo tsow zha lo zhaʼa”. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Per leen ni lo goo: Tsowt goo kuu went lo zha kuu nlaaz tsow thib kuu went lo goo; sinke loka cho kuu nlaaz keey kwat goo lad ban, noga btaa goo tedib lad kwat goo kee zhay. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ne loka cho zha kuu nlaaz teno goo lo zha kuu nak tsiin, tsa kib zha kamis goo, noga btaa goo xabits goo lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ne loka cho kuu nabee lo goo gwe goo thib kwaa thib mil metr, be gooy chop lala. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ne loka cho naab kwaa lo goo, btaa gooy lo zha, ne loka cho zha kinn kwaa lo goo, btseche gooy lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Tak noga mbin goo nzhab Moisés: “Bke leettsooʼa tabena, ne byii ne zha kuu nayii neʼa”. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Per leen ni lo goo, bke leettsoo goo re zha kuu nayii ne goo, ne bnaab goo lo Diox por re zha kuu ndreke dits goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tsa gak goo taxal ndoblo gak re zhiinn Xutaa Diox kuu ndob yibaa; tak lo reta men ntsow Diox kuu wen, ndaa Diox xni wiz lo re men wen ne lo re men went, ne ntela Diox yi lo re men kuu nali nak ne lo re men kuu nalit nak. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Os lee goo nke leettsoo goo beeta re zha kuu nkelaaz goo, ¿kwan tsow goo gan? Tak tataga ntsow re zha kuu ndab falt, kuu ntsow kobral temi chaan yezlyu kuu nzhax lo zha Roma. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ne os lee goo ni goo “diox”, beeta lo re zha kuu nak raz chaan goo. ¿Kwan kuu wen ntsow goo tsa? Noga re zha kuu nagt zha Israel tata ntsow, ne yent kwan kayaa zha lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nali gok goo, taxal nali nak Xutaa Diox kuu ndob yibaa. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Kenap goo goo, tsowt goo kuu wen beeta par wii re men lo goo; os lee goo tata ntsow goo, neeka thib kwaa kayaat goo lo Xutaa Diox kuu ndob yibaa. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","’Kona leettsa taa goo karida lo thib zha kuu ndechey, tetht gooy lo re men ne gab goo: “Nlazʼn ne goo leen mtsow ayud zha kuu ndechey”, taxal ntsow re zha kuu nkedi, re zha kuu zhaa kuu mbez ne zhaa kuu ntsow. Tak tabaa ntsow re zhaʼa, ta nkaltaa reʼaa nteedaa xkiiz Diox, noga ntsow zhay net, tsa wen ni re men zha. Wlipaa na nin, beeta kona nak kuu tsow zha gan. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Per lee goo, leettsa taa goo thib kwaa lo thib zha kuu ndechey, btsow goo tsa yent cho ney, ne neeka amig goo kuu mas nzaal leettsoo goo ndoblot ney. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Xgaatsa btsow gooy, tsa lee Xutaa kuu ne re kuu xgaatsta, taa kuu tsow goo gan lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Kona nin lo goo, leettsa tediz goo lo Diox, tsowt goo taxal ntsow re zha kuu nkedi, re zha kuu zhaa kuu mbez ne zhaa kuu ntsow zha. Re zhaʼa nyow leettsoo zha tediz zha lo Diox, ta nkaltaa reʼaa nteedaa xkiiz Diox ne re net, tsa wii re men lo zha lee zha ngetediz lo Diox. Wlipaa na nin, beeta kuu tsow zha gan nak, wen ni re men lo zha, per lo Diox yent kwan tsow zha gan. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Per lee re goo, leettsa tediz goo lo Diox, btaab goo leen liz goo, btow goo roo pwert, ne btediz goo lo Xutaa Diox kuu nloot, tsa lee Xutaa kuu ne re kuu xgaats, taa kuu tsow goo gan lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Ne leettsa tediz goo lo Diox, gabt goo thibka lan diiz tyen welt, taxal ntsow re zha kuu nagt zha Israel. Tak lee re zhaʼa ntsow zha xgab ton Diox xkiiz zha, ne taa Diox re kuu naab zha, tak nol ndediz zha lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tsowt goo taxal ntsow re zhaʼa; tak lee Xutaa neʼa naa kwan ndeche goo, leettsa terka naab gooy lo Xutaa. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kona, tenzhee ndoblo tediz goo lo Xutaa Diox: Xutʼn, kuu ndob yibaa, nlazʼn tsow nataak re mena tak nayon naka. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Taxal ntsow re zha kuu nzo yibaa kuu nlaaza, leeka tata nlazʼn tsow re men yezlyu ree kuu nlaaza. Nlazʼn yaada nabeeʼa lo yezlyu ree, taxal nabeeʼa yibaa. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Taa kuu wun naltseree. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ne btuyy re falta kuu mtsowʼn loʼa, taxal mloʼa na yekʼn re falt kuu mtsow re taben da lon. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Btsow tsa tsowtʼn kuu went, leettsa nkiil tedib zha na, ne bkenapʼn lo kuu went kuu nlaaz Maxuuy tsow lon, tak chaana nak ta nabeeʼa, yalney ne ta nla xni chul chaana thitanax. Tata gake. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Ne os lee goo, koo goo yek goo reta falt kuu mtsow re taben goo lo goo, noga Xutaa kuu ndob yibaa tetuyy re falt chaan goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Per os lee goo koot goo yek goo re kuu mtsow tedib net zha lo goo, noga Xutaa kuu ndob yibaa, tuyyt re falt chaan goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Kona nin lo goo, leettsa tsow goo ayun, tak ntsow goo xgab tata mas wen nzo leettsoo Diox ne Diox goo, leettsa nzhowt goo neeka thib kwaa, tsowt goo taxal thib zha nalatt, taxal ntsow re zha kuu nkedi, re zha kuu zhaa kuu mbez ne zhaa kuu ntsow. Kwathoz nabil ntsow zha, tsa reta men ne lee zha ngetsow ayun. Per wlipaa na nin lo goo, napa zha kuu tsow zha gan. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Per lee na ni lo goo, leettsa tsow goo ayun, bteech goo lo goo ne wen btee goo bow yek goo, ");
INSERT INTO zaoNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tsa net re men lee goo ngetsow ayun. Sinke beeta Xutaa kuu ne re kuu xgaats ndoblo ney, ne lee Xutaa taa lo goo, kuu tsow goo gan. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Kaltaat goo kwathoz kwaa lo yezlyu ree, tak lo yezlyu ree nke mbete ne nke yitoy, ne ndaab wann nlowann wann. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mas wen kaltaa goo kwaa leen yibaa, ta neeka thib kwaa luxt ne neeka ket mbete, ne neeka ket yitoy, ta tabt wann lowann wann. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mas wen btsow goo kuu wen, tak os lee goo tsow gooy, masraa yo leettsoo goo tsow goo kuu wen. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Os leeʼa ndablaazta re kuu yezlyu ree kuu ngwiiʼa, kona nak nagwe ngutloʼa ne wen nyeni ngutloʼa, tak wiiʼa re kwaa ne tablaazt luy. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Per os leeʼa ndablaaza re kwaa yezlyu ree, kuu ngwiiʼa, kona nak taxal nagwet ngutloʼa ne yent kwan nyeni loʼa. Os leeʼa tata naka, reta kuu ntsowa nloo leeʼa nak thib zha ndaa falt. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Neeka thib zha gagt ke tsiin lo chop zha, tak teyii zha ne thib zha, ne lee tedib zha kelaaz zha, lo thib zha gon zha diiz, lee lo tedib zha gont zha diiz. Gagt lortsin goo lo Diox ne lo re kwaa yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Kona nin lo goo: Yat leettsoo goo por re kuu wu goo ne kuu gu goo, tsa ban goo, neeka tsowt goo xgab re lar kuu gok goo. ¿Chu nagt masraa nataak yalnaban goo, nake kuu nzhow goo, kuu nzhuu goo ne kuu nzhok goo? ");
INSERT INTO zaoNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Wii goo lo re min kuu nlazbi, nzhannt maa, neeka nthopt maa yalgonn, neeka ngotsowt maa yalgonn leen loo, per lee Xutaa kuu ndob yibaa ndaa loww maa. ¡Chu nagt masraa nataak goo nake re min! ");
INSERT INTO zaoNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tsowt goo xgab re kona, tak ¿cho thib goo kuu kwathoz nlaaz ban telut, per tegal nlaaz gooy, gagt tsow goo ban goo neeka telut? ");
INSERT INTO zaoNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Ne chebee kwathoz ntsow goo xgab, naa xomod tsanaa goo lar kuu gok goo? Mas wen wii goo lo re yee kuu ndab wan; nket yee tsiin ne neeka ndexkwaat yee lar. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Per lee na ni neeka rey Salomón, kon dita yalrik chaan Salomón mdogt xab Salomón taxal thib re yee kuu ndab wan. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ne os lee Diox ntsow chul nyaal re yizh kuu ndab wan naltseree, ne lee tedib wiz nzheeke, ¿chu nagt tataga taa Diox reta kuu ndeche goo lo goo, men kuu lutta nyelaaz Diox? ");
INSERT INTO zaoNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ne yat leettsoo goo gab goo: “¿Kwan dowaa o kwan guʼaa ne kwan gokaa?” ");
INSERT INTO zaoNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tak reta zha kuu nagt zha Israel, kwathoz ntsow zha xgab re koree. Per lee Xutaa kuu ndob yibaa neʼa naa kwan ndeche goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Taa goo diiz nabee Diox lo goo lo reta kwaa, ne bkwaan goo thibka nali ban goo taxal nlaaz Diox, tsa lee Diox taa reta koree lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kona nin, tsowt goo xgab re kuu nzo yek goo tsow goo yee o wiz, tak kadta wiz nzo kwan tsow goo xgab. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Naabt goo kwent lo tedib zha, tsa naabt Diox kwent lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tak leeka taxal naab goo kwent lo tedib zha, leeka tata naab Diox kwent lo goo, ne taxal nchiix goo kuu ndaa goo lo tedib net zha, leeka tata chiix Diox kuu taa Diox lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Chebee nye leettsooʼa ngwiiʼa lo paj kuu nzo ngutlo tedib zha, ne ngwiita lo ya kuu nzo ngutloʼa? ");
INSERT INTO zaoNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ne os leeʼa nyeenta nzo ya ngutloʼa, ¿xomod nye leettsooʼa mbeza lo tedib zha: “Laa gon paj kuu nzo ngutloʼa”? ");
INSERT INTO zaoNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Zha nkedi, zhaa kuu mbeza ne zhaa kuu ntsowa! Ner bloo ya kuu nzo ngutloʼa, tsa tak wiiʼa wen, tsa tak kooʼa paj kuu nzo ngutlo tedib zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Taat goo re kuu nayon lo re mbak, tak cha yii maa lo goo ne wuley maa goo. Ne neeka taat goo re ke kuu nzhol kuu kwathoz nataak lo re nguch, tak nataagte lo maa, cha lo maa ditse ne luux maay. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Kona nin lo goo, kon dib ndroo leettsoo goo bnaab gooy lo Zha Nabee, ne lee Zha Nabee taay; ne nake taxal nkwaan goo thib kuu ne tatsale lo goo; noga nake taxal nteez goo roo yuu, tsa xaal zha roo yuu lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tak reta zha kuu naabe nkayaa zhay; ne reta zha kuu nkwaane teyetsale lo zha; ne reta zha kuu nteez roo yuu taxal zha roo yuu lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Os lee zhiinn goo naab tsa pan lo goo, ¿chu tataa goo thib ke lo zhiinn goo? Wlipaa taat gooy. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ne os lee zhiinn goo naab thib mbel lo goo, ¿chu tataa goo thib mbeel lo zhiinn goo? Wlipaa tsowt goo tata. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ne leeka tata tegal zha kuu kwathoz went nak goo, per nzhaak goo ndaa goo kuu wen lo zhiinn goo, ¡xomod lee Xutaa kuu ndob yibaa, taat kuu wen lo reta zha kuu naabe lo Xutaa! ");
INSERT INTO zaoNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Kona, leeka taxal nlaaz goo tsow tedib net re men lo goo, tataga btsow goo lo zha; tak tata nzhab lo ley kuu mkee Moisés, ne tataka nzhab re kuu mkee re profet kuu ngoo ndala. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Btaab goo roo pwert kuu naya. Tak lee net naxen ne roo pwert kuu naxen, ndano zha ta lux zha thitanax. Ne kwathoz zha nden neta. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Per lee pwert ne net kuu ndano men lo yalnaban, naya nak, ne lut zha nden neta. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Bkenap goo goo, yelaazt goo kuu ne re zha kuu nkedi lo goo nal tyemp ree: “Tak ne zha na nak profet”. Ne nadoo nzhak zha taxal mbak zhiil, ne lee leettsoo zha nayii nzo taxal mbeez kuu nayii. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tak lebee goo re zhaʼa por re kuu ntsow zha; leeka taxal reta ya nabee ya por xle kuu ndaa ya, tak nthopt men ub lo ya yits, ne neeka nthopt men ig lo yitsti. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ne tataga reta ya kuu wen ndaay xle wen, per lee ya kuu went ndaay xle went. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kona lee ya xle, kuu ndaa xle kuu nzhow men, gagt taay xle kuu nzhowt men, ne tataga lee ya xle kuu ndaa xle kuu nzhowt men, gagt taay xle kuu wu men. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Reta ya kuu ndaat xle kuu nzhow men, taga zhay ne ko zhay lo ki. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Tenzhee tak lebee goo reta zha, por re kuu ntsow zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Ret men kuu ni lon: “Zha Nabee, Zha Nabee”, tab ta nabee Diox, sinke beeta re zha kuu ntsow kuu nlaaz Xutʼn kuu ndob yibaa, tab ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ne lee wiza kwathoz zha tablaaz, taa Diox diiz to zha kon Diox, tsa ne zha lon: “Zha Nabee, re nee ngok profet kuu mndaa kwent xkiiza, ne kon yalnabee chaana mloo nee mbi fyer, ne kon yalnabee chaana mtsow nee naroob kwaa”. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Per tsa kabʼn ne nin: “¡Thitanax mlebeetʼn goo, beche goo lon, men kuu ntsow kuu went!” ");
INSERT INTO zaoNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Kona, loka zha kuu ngeyon kuu ngenin lo goo, ne ntsow zha kuu nin, zhaʼa nak taxal thib mbyi list kuu mta liz dits ke. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tegal mla yi thoz, ne mroo nit ne mroo mbi thoz, ne mdiinne yuuʼa; per mbixt yuu tak lo ke ndob yuu. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Per lee zha kuu ngeyon xkizʼn ne ntsowt zha kuu nin, zhaʼa nak taxal thib mbyi bxen kuu mta liz lo gux. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Per leettsa mla yi thoz, ne mroo nit ne mroo mbi thoz, mdiinne yuuʼa, tsa mbix yuuʼa ne mlux yuuʼa thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Leettsa ngwalo nzhab Jesús re koree, kwathoz mzegey leettsoo re men re kuu mloo Jesús lo re men; ");
INSERT INTO zaoNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tak kon yalnabee mloo Jesús lo re men, ne mloot Jesús taxal nloo re maestr chaan ley. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Leettsa mretab Jesús ngwa Jesús yek yii, kwathoz men mndeke dits Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ne xid re mena mroo thib mbyi kuu ndeye kwerp, mbig lo Jesús ne mtobxub, ne nzhab zha: ―Zha Nabee, os leeʼa nlaaza, tak tegweʼa na lo yiz ree. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tsa mxoob Jesús yaa Jesús dits zha, ne nzhab Jesús lo zha: ―Nlazʼn, weʼa. Ne oraaka mgwe zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tsa nzhab Jesús lo zha: ―Wii, yent cho lo gaba koree. Sinke gwa lo ngwleyy ne btaa gona taxal nabee ley chaan Moisés, gon kuu ndaa re zha kuu mgwe lo yiz kuu mzhaaka, tsa ne ngwleyy leeʼa mgweʼa ne gab ngwleyye lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ne or mndaab Jesús yez Capernaúm, lee thib soldad kuu nabee lo thib gayoo soldad, ngwa mnaab thib yalwen lo Jesús, ");
INSERT INTO zaoNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ne nzhab: ―Zha Nabee, lee mos da kwathoz ne ndak, gagt gwin zha ne kwathoz ndakti zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tsa nzhab Jesús lo soldad: ―Nal yan tsa tegwen zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tsa lee soldad kuu nabee lo thib gayoo soldad nzhab: ―Zha Nabee, ndoblotʼn taba leen lizʼn, anta nabee ne lee mos da gwe. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tak noga na napʼn zha kuu nabee lon, ne noga na napʼn soldad kuu nabeen lo. Os leen gapʼn lo thib zha: “Gwa”, ne nya zha; ne or gapʼn lo tedib zha “De”, ne nyaad zha; ne leettsa mbezʼn lo mos da “Tsow koree”, ntsow zhay. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kwathoz mzegey leettsoo Jesús mbin Jesús kona, tsa nzhab Jesús lo re zha kuu ndeke dits Jesús: ―Wlipaa na nin lo goo, ¡neeka thib re tawlazaa zha Israel nyelaazt Diox taxal mbyi ree! ");
INSERT INTO zaoNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Wlipaa na nin lo goo, kwathoz tyen re zha kuu nagt zha Israel, kuu nzo dib naxta lo yezlyu, tob zha wu zha kon Abraham, kon Isaac ne kon Kob ta nabee Diox, ");
INSERT INTO zaoNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","per lee re zha Israel kuu nak diiz tob ta nabee Diox, ndya gabil ta nakow na, ne tya gonn zha ne tub zha keley zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tsa nzhab Jesús lo mbyi kuu nabee lo thib gayoo soldad: ―Tyee liza, tak ngwalaaza lee Diox tak tegwe, kona mgwe mosa. Leeka ora lee mos soldad mgwe. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tsa lee Jesús kon chop tson zha kuu ngeteed lo Jesús ngwa liz Pey, ne mwii Jesús lee xnaatsaap Pey ne ndak, nax lo luun ndak xlee. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ne mzhen Jesús yaa zha, ne oraaka lee xlee mroo zha. Ne ngwache zha ne mndaa zha kuu ndow re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Leettsa mkow yezlyu lee re men kuu nzo yezlyuʼa, myaadno kwathoz re zha lo Jesús, re zha kuu nzo mbi fyer leettsoo ne re zha kuu ndak choraa yiz, ne kon thibka lan diiz mloo Jesús re mbi fyer, ne noga mtegwe Jesús reta mbyiz. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Koree ngok, tsa mrolo kuu mkee profet Isaí zha ndala, leettsa nzhab profet: “Lee zha mbe reta yiz chaanaa ne re yalne chaanaa”. Is. 53:4 ");
INSERT INTO zaoNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Or mwii Jesús kwathoz men mrin dita lo Jesús, tsa mnabee Jesús lo re tsiibchop zha kuu ngeteed lo Jesús, tsa rid re zha tedib lad roo nitdoo, tsa roxkwan re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ne ora lee thib maestr kuu nloo xkiiz Diox mbig lo Jesús, ne nzhab: ―Maestr, nlazʼn teken ditsa loka pa ta yaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ora mkab Jesús lo maestr, ne nzhab Jesús: ―Lee re mbeet nap maa kelyoo ta nyoo maa, ne lee re min nap maa lyaat maa; per lee na Kuu Mzin Ngok Men, neeka ta xoobʼn yekʼn roxkwan na naptʼn. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tsa lee tedib zha kuu ngeteed lo Jesús nzhab lo Jesús: ―Zha Nabee, nlazʼn teken ditsa, per laa anta yelo kaatsʼn xutʼn. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tsa nzhab Jesús lo zha: ―Bteke ditsʼn, laa kaats re zha kuu nyelaazt Diox re zha nguth. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tsa mke Jesús leen thib kano, ne noga re zha kuu teed lo Jesús nda kon Jesús, par rid re zha tedib lad roo nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Per leettsa nda re zha lo nitdoo, tsa mroo thib mbi thoz, ne asta ndaab nit leen kano. Per lee Jesús ngoth ne mzhen mkaal Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tsa lee re zha kuu ngeteed lo Jesús, mloo zha mkaal lo Jesús, ne nzhab re zha lo Jesús: ―Zha Nabee, laata luzhaa, tak ngelowgwaa leen nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús mkab ne nzhab: ―¿Chebee kwathoz nzeb goo? ¿Chebee lutta nyelaaz goo Diox? Tsa ngwateli Jesús ne mkox mbi ne nitdoo lo Jesús, ne zheta ngok mbi ne nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Reta zha kuu ngeteed lo Jesús kwathoz mzegey leettsoo zha, ne mbez zha lo altaa zha: ―¿Cho nak mbyi ree? ¿Chebee asta mbi ne nitdoo nzhon diiz lo zha? ");
INSERT INTO zaoNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Leettsa mzin Jesús kon re zha kuu ngeteed lo Jesús tedib lad roo nitdoo, yezlyu chaan re zha Gadara, ne tya lee chop zha kuu nzo mbi fyer leettsoo, mroo leen re kelyoo ta nkaats zha re zha nguth, tya mtsow zha liz zha rop zha, ne mbig rop zha lo Jesús, ne kwathoz nakap nzhak zha, kona yent cho tak rid neta. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ne mretsyath zha ne nzhab zha: ―¿Chaka ndyaad lo nee, Jesús Xgann Diox? ¿Chu ndyaada tetiʼa nee, leettsa terka tsin wiz kuu tetiʼa nee? ");
INSERT INTO zaoNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Gax tya nzi kwathoz nguch ngeyow. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tsa lee re mbi fyer mnaab lo Jesús, ne nzhab: ―Os leeʼa kooʼa nee, taa diiz tab nee leettsoo re nguch baa. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tsa nzhab Jesús: ―¡Gwa goo! Ne lee re mbi fyer mroo leettsoo rop zhaʼa ne mndaab leettsoo re nguch. Ne oraaka mrozhonn re nguch ne mbix maa yek kedoo ngob maa leen nitdoo, ngwaap re maa nit ne thitanax nguth maa. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Oraaka lee re zha kuu nkenap re nguch mzhonn ndya, ne or mzin re zha yez, mndelo zha mndaa zha kwent re kuu ngok, kon rop zha kuu ngoo mbi fyer leettsoo. ");
INSERT INTO zaoNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tsa reta zha yez mroo ngwa ta ndo Jesús. Ne or mwii re zha Jesús; mnaab zha lo Jesús, tsa roo Jesús yezlyu zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tsa mndaab Jesús leen thib kano, ne mriid Jesús tedib lad roo nitdoo, ne mzin Jesús ta nak laz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tya mbe zha thib zha mthans kuu nzoob lo luun lo Jesús. Ne myeen Jesús lee re zha kuu ndyaadno mthansa, nyelaaz lee Jesús tak tegwe mthans, tsa nzhab Jesús lo mthans: ―Wen bloo leettsooʼa; tak reta falta myuyya. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tsa lee chop tson maestr kuu nloo xkiiz Diox mtsow xgab: “Went ni zha ree Diox, tak mbez zha lee zha tak tuyy re falt men”. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Per lee Jesús neʼa naa kwan ntsow re zha xgab, tsa mnaabdiz Jesús lo re zha: ―¿Chebee kwathoz went ntsow goo xgab? ");
INSERT INTO zaoNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Kwan ntsow goo xgab? ¿Kwan mas nagant gap na lo mbyiz ree: “Lee re falta myuyya”, per nagan tegwe men zha ne gab men lo zha, “Gwache ne bte”? ");
INSERT INTO zaoNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Tsowʼn koree lo goo, tsa ne goo lee na, Kuu Mzin Ngok Men, napʼn yalnabee tuyʼn re falt goo. Tsa nzhab Jesús lo mthans: ―Gwache bzhen luuna, ne tyee liza. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tsa lee mthans ngwache mzhen luun ne ndya lize. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Leettsa mwii re men kona, kwathoz mzeb re men ne mbil men lo Diox, tak lee Diox mndaa yalnabee lo thib men, tsa tegwe men tedib men. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Leettsa mroo Jesús tya mwii Jesús na kuu le Mateo, ndobʼn ngetsowʼn kobral temi chaan yezlyu kuu nzhax lo zha Roma, tsa ne Jesús lon: ―Bteke ditsʼn. Tsa ngwatelin ne mndekeen dits Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ne leettsa ngeyow Jesús lizʼn, noga mzin tedib net re zha kuu ntsow kobral temi chaan yezlyu kuu nzhax lo zha Roma, ne tedib net re zha kuu ntsow kuu went, ne mndob re zha roo mes kon Jesús, ne kon re zha kuu ngeteed lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ne or mwii re fariseo koree, tsa nzhab zha lo re zha kuu ngeteed lo Jesús: ―¿Chebee nzhow maestr goo, kon re zha kuu ntsow kobral temi chaan yezlyu kuu nzhax lo zha Roma, ne kon re zha kuu ntsow kuu went? ");
INSERT INTO zaoNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús mbin kona, tsa nzhab Jesús lo re zha: ―Lee re zha kuu net ndak, ndechet zha doctor, per lee re mbyiz, zhaʼa ndeche doctor. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tyaa goo, ne bteed goo naa kwan nak re diiz ree: “Kuu nlazʼn nak, blat leettsoo goo ne goo taben goo, nlaztʼn beeta kuth goo maa taa goo lon”. Os. 6:6 Tak ndyaltʼn ndyaadchezʼn re zha wen, sinke lee na ndyal ndyaadchez re zha kuu ndab falt, tsa tsee zha mod went kuu nak zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tsa mbig re zha kuu mndeke dits Juan kuu mtsowleyy, ne mnaabdiz zha lo Jesús, nzhab zha: ―¿Chebee re nee, ne re fariseo kwaro ntsow nee ayun, ne lee re zha kuu ngeteed loʼa ntsowt zhay? ");
INSERT INTO zaoNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús mkab, ne nzhab: ―¿Chu tak tsow re zha kuu nzi lo fandan ayun, leettsa lee mbyi kuu mtseyaʼa ndoka lo re zha? Per tetsin wiz kib re zha mal mbyi kuu mtseyaʼa lo re zha; tsasi lee re zha tsow ayun. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Noga nzhab Jesús: ―Neeka thib zha ngibt thib le lar kub cho lar gox, tak lee lar kub mbich, leettsa nteech zhay ne masraa nchatte lar gox ne gagt raa lortsin zhay. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ne neeka ngot zha xit ub kuu kub leen gom yid gox, tak lee xit ub kuu kub yezhoob, ne chatte gom gox. Tsa lee xit ub zho, ne noga gom lux. Kona lee xit ub kuu kub ndoblo yo leen gom yid kub tsa neeka thibe luxt. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Leettsa bee ngenika Jesús lee thib mbyi mzin lo Jesús, mbyiʼa nak thib zha kuu nabee ta nkaltaa re zha Israel nteed xkiiz Diox, ne mtobxub zha lo Jesús ne nzhab zha: ―Ngulota nguth rtsaapʼn; per os leeʼa yaada ne xooba yaaʼa yek nzaa teroban nzaa. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tsa lee Jesús kon re zha kuu ngeteed lo Jesús mndeli ne mndeke dits mbyiʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ne ora lee thib ngot kuu ndaʼa tsiibchop liin nlath ren leettsoo, mbig dits Jesús ne mdiinn ngot xab Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tak mtsow ngot xgab: “Os anta diinn na xab Jesús tegwen”. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Per lee Jesús mre ne mwii lo ngot, ne nzhab: ―Rtsaapʼn. Wen bloo leettsooʼa, tak ngwalaaza lee Diox tak tegweʼa, kona mgweʼa. Ne leeka ora lee ngot mgwe. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ne leettsa mzin Jesús kon chop tson zha kuu ngeteed lo Jesús liz zha kuu nabeeʼa, tsa mwii Jesús lee re musk nzi ngeyol, ne lee re men nzi nzhonn ne mbetsyath tak nguth nzaa. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tsa nzhab Jesús lo re zha: ―Broo goo nzhee, tak ngutht nzaa, beeta naxat nzaa. Tsa lee re men mzhizno Jesús, tak tata nzhab Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Per or ngwalo mroo re men leen yuu, tsa mndaab Jesús ne mzhen Jesús yaa nzaa, ne lee nzaa mroban ne mndeli. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ne reta men yezlyuʼa mbin kuu mtsow Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Leettsa mroo Jesús tya, lee chop zha syeg mndeke dits Jesús, dib gan zha mrez zha ne nzhab zha lo Jesús: ―¡Lu kuu nak thib zha raz rey David, blat leettsooʼa neʼa nee! ");
INSERT INTO zaoNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Per or mndaab Jesús leen yuu, lee rop syeg mbig gax lo Jesús, tsa mnaabdiz Jesús lo rop zha: ―¿Chu nyelaaz goo tak tegwen goo? ―Zha Nabee, tak tsow luy ― mkab rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tsa lee Jesús mdiinn ngutlo zha, ne nzhab lo rop zha: ―Tak ngwalaaz goo tak tegwen goo, kona mgwe goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ne oraaka mzaal lo rop zha, tsa nzhab Jesús lo rop zha: ―Yent cho lo gab gooy. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Per or mroo rop zha, mndelo zha mndaa zha kwent kuu mtsow Jesús lo rop zha, lo reta men dita yezlyuʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Leeka or kuu mroo rop zha kuu ngok syeg, lee tedib net zha ndyaadno thib zha mud kuu nzo mbi fyer leettsoo lo Jesús, tsa tegwe Jesús zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ne or mloo Jesús mbi fyer leettsoo mbyiʼa, mndelo mbyiʼa mndediz. Tsa mzegey leettsoo re men, ne nzhab re men: ―¡Neeka mas ter wiiʼaa thib kuu tenzhee lazaa! ");
INSERT INTO zaoNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Per lee re fariseo nzhab: ―Maxuuy kuu nabee lo reta mbi fyer, mndaa diiz lo zha par ngoo zha re mbi fyer. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Tsa mriid Jesús re yez ne re ranch ne reta ta mloo Jesús lo re men, ne mndaa Jesús kwent Diiz Chul chaan ta nabee Diox ne mtegwe Jesús relota yiz ne relota yalne. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Or mwii Jesús lo re men mlat leettsoo Jesús ne Jesús re men, tak kwathoz nalatt nzhak re men, taxal mbak zhiil kuu napt bzhaan. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tsa nzhab Jesús lo re zha kuu ngeteed lo Jesús: ―Wlipaa na nin lo goo, kwathoz naroob rtsin Zha Nabee nzo, per lutta zha kuu ntsow rtsin zha nzo. ");
INSERT INTO zaoNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kona bnaab goo lo Zha Nabee, tsa taal zha masraa zha ke tsiin thop yalgonn chaan Zha Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tsa mrez Jesús re tsiibchop nee kuu ngeteed lo Jesús ne mndaa Jesús yalnabee lo nee, par koo nee re mbi fyer kuu nzo leettsoo re men, ne tegwe nee relota yiz ne relota yalne. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Tenzhee le re tsiibchop nee kuu mteed lo Jesús kuu noga le apóstl: Simún (kuu noga le Pey), Ndres (wets Pey), Santiag, Juan (wets Santiag, rop zha ree nak xgann Zebedeo), Lip, Bartolomé, Mach, Mateo (kuu nak na, kuu mthop temi kuu nzhax lo zha Roma), Santiag (xgann Alfeo), Lebeo (kuu noga ni zha lo Tadeo), Simún (kuu ngoo xid partid zha Canaán) ne Judas Iscariote (kuu mndaa Jesús lo re zha par mbeth zha Jesús). ");
INSERT INTO zaoNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tsa mtaal Jesús re tsiibchop nee ne tenzhee ne Jesús lo re nee: ―Yat goo laz re zha kuu nagt tawlazaa, neeka re yez chaan re zha Samaria. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Gwa goo lo re tawlazaa zha Israel, zha kuu mndab xnet Diox, zha kuu nak taxal re mbak zhiil kuu mndab lo bzhaan. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Gwa goo ne gab goo, lee wiz kuu nabee Diox mzin gaxa. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Btegwe goo re mbyiz, teroban goo re zha nguth, btegwe goo re zha kuu ndeye kwerp, ne bloo goo mbi fyer leettsoo re men kuu nzo mbi fyer leettsoo. Por yalwen chaan Diox mkayaa goo yalnabee ree; kona ndoblot tsow goo kobral por tsow goo re koree. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Gwet goo temi. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Neeka gwet goo bols kuu yo re chaan goo, neeka tedib net lar kuu gok goo, neeka tedib net labyid kuu ke nii goo, neeka aga gwet goo, tak lee zha kuu nke tsiin ndoblo zha gax lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Leettsa tsin goo thib yez o thib ranch, kwaan goo liz thib zha kuu ndoblo zha kwet goo liz zha, ne tya kwet goo asta or kuu roo goo yeza. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Or kuu tsin goo thib yuu bni goo “diox” lo zha ne guz goo lo zha, lee Diox tsow wen kwin goo liz goo ne bzhen goo yaa re zha kuu nzo yuuʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ne os lee re zha kuu nzo yuuʼa, ndoblo zha lee Diox tsow wen kwin zha liz zha, tsa lee kuu gab goo lo zha, take lo zha; per os lee zha ndoblot zha tsow Diox wen kwin zha liz zha, gagte lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ne os lee zha kayaat zha goo ne tyalt zha gon zha kuu gab goo, broo goo yuuʼa o yeza ne btsib goo yuyaaz kuu mke nii goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Wlipaa na nin lo goo, leettsa naab Diox kwent lo re men, lee yalti kuu rid re zha yeza, gak masraa nati nake yalti kuu rid re men rop yez kuu ngoo ndala kuu le Sodoma ne Gomorra, rop yez kuu mluux Diox kon ki. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’¡Wii goo! Na taal goo yataa goo kwent chaan Diiz Chul, taxal mbak zhiil xid re mbeez kuu nayii, kona list gok goo taxal mbeel ne nadoo gok goo taxal palom. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Bkenap goo goo lo re men, tak teno zha goo lo re zha kuu nataak lo re Israel, ne kin zha goo ta nkaltaa reʼaa nteedaa xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ne teno zha goo lo re zha kuu nak gobyern ne lo re rey kwent chaan da, tata tak taa goo kwent chaan da lo re zha gobyern ne lo re zha kuu nagt zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Per leettsa taa zha goo lo re zha nak tsiin, tsowt goo xgab naa kwan kab goo lo zha ne xomod gab gooy, tak ora lee Mbi Nayon taa diiz kuu kab goo lo zha, ");
INSERT INTO zaoNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","tak nagt goo kuu ni ora, sinke lee Mbi Nayon chaan Xutaa kuu nzo leettsoo goo ni ora. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Ne leeka wets zha kuu nyelaazt Diox, taa zha lo re zha nak tsiin tsa kuth zha zha, ne tataka tsow xut zha kon xgann zha. Lee re zhiinn zha yii ne xut ne xnaa, ne taa zhiinn zha zha lo re zha kuu nlaaz kuth zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Reta men yii ne goo tak nak goo zha da. Per lee zha kuu xek rid re koree asta bluz, zhaʼa tsow gan yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Per leettsa reke zha dits goo thib yez, bzhonn goo ne tyaa goo tedib yez ne noga tya taa goo kwent chaan da. Tak wlipaa na nin, tsowt goo gan yataa goo kwent chaan da, reta yez kuu nak chaan reʼaa zha Israel, leettsa lee na Kuu Mzin Ngok Men bretab. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Neeka thib zha kuu ngeteed nataagt zha masraa nake maestr zha, ne tataka neeka thib zha kuu nke tsiin, nataagt zha masraa nake patron zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kona lee zha kuu ngeteed, ndoblo wen yo leettsoo zha, tsow re men lo zha taxal ntsow re men lo maestr zha, ne leeka tata lee mos, ndoblo wen yo leettsoo mos, tsow re men lo mos taxal ntsow re men lo patron mos. Ne os lo na kuu nak taxal mndan thib yuu ni zha lo Beelzebú kuu nabee lo re mbi fyer. ¡Kwanpaa gabt zha lo re goo kuu nak goo taxal zhiinn mndan yuu! ");
INSERT INTO zaoNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Ne tsebt goo ne goo re men kuu ndreke dits goo, tak ndaa goo kwent xkizʼn. “Tak neeka thib kuu ntsow zha xlaanta gagt loote, ne tataka neeka thib kuu ntsow zha xgaatsta gagt loote”. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kona loka kuu mnin lo goo xgaatsta, taxal re kuu ndediz xlaan zha ta nakow, tse guz gooy lo reta men; ne lee re kuu mnin lo thita goo, kendab goo yek yuu ne nex guz gooy lo reta men. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tsebt goo ne goo re zha kuu nzhuth kwerp, tak gagt kuth zha xbi goo. Btseb goo ne goo Diox, tak Diox tak kib yalnaban goo ne ko xbi goo ne kwerp goo kuu kub gabil. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Wii goo, ¿chu nthot zha chop min bzhizh por thap rehal? Per leen ni lo goo, neeka thib min lat lo yezlyu ree os lee Xutaa Diox kuu ndob yibaa taat diize. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Diox nlebee reta goo, asta re yitsek goo nak kwent lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kona tsebt goo ne goo re zha kuu mbez kuth goo, tak masraa nataak goo nake naroob min bzhizh. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Os lee thib zha gab zha lo re men lee zha nak zha da, noga na gapʼn lo Xutʼn kuu ndob yibaa lee zha nak zha da. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Per lee zha kuu gabt lo re men lee zha nak zha da, noga na gapʼn lo Xutʼn kuu ndob yibaa lee zha nagt zha zha da. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Tsowt goo xgab leen ndyal, tsa wen kwin re men lo yezlyu ree. Ndyaltʼn tsa wen kwin re men lo yezlyu ree; sinke chakʼn ndyal kona lee re zha kuu nyelaazt na kuth re zha kuu nyelaaz na. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tak por kuu nloon tsow yo re zha kuu nyelaazt na, kon re zha liz zha kuu nyelaaz na, lee re mbyi yo kon xut, ne tataka lee re nzaa yo kon xnaa, ne lee zhizh zha yo kon xnaatsaap zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Leeka re zha liz zha yii ne zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Ne loka zha kuu mas nke leettsoo xut ne xnaa nake na, ndoblot zhaʼa gak zha zha da, ne loka zha kuu mas nke leettsoo xgann o rtsaap nake na, ndoblot zhaʼa gak zha zha da, ");
INSERT INTO zaoNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ne loka zha kuu kot leettsoo thib gath, tak ndeke zha ditsʼn, ndoblot zha gak zha zha da. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Zha kuu nzeb gath tak nyelaaz zha na lo yezlyu ree, tath zha ne tsowt zha gan yalnaban kuu thitanax, per lee zha kuu nzebt gath lo yezlyu ree, tak nyelaaz zha na, zhaʼa tsow gan yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Zha kuu nkayaa goo noga na nkayaa zha. Ne lee zha kuu nkayaa na, noga nkayaa zha, zha kuu mtaalʼn. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Loka zha kuu nkayaa thib profet, tak ne zha nak zha zha Diox, zhaʼa kayaa lo Diox leeka kuu kayaa profet lo Diox; ne loka zha kuu kayaa thib zha kuu nali nak, tak ne zha nali nak zha, zhaʼa kayaa lo Diox leeka kuu kayaa zha kuu nali naka lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ne loka cho zha kuu taa thib kuu ndeche goo, tegal beeta thib bas nit kuu gu goo, tak nak goo zha da, wlipaa na nin, noga lo zhaʼa tataa Diox kuu tsow zha gan. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Leettsa ngwalo mteni Jesús re tsiibchop zha kuu ngeteed lo Jesús, tsa mroo Jesús tya ne nda Jesús nda loo Jesús ne mndaa Jesús kwent xkiiz Diox lo tedib net re zha kuu nzo re yez kuu nzi yezlyuʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ne lee Juan kuu mtsowleyy re men nzo tsib, ne leettsa mbin Juan re kuu ngetsow Jesús, tsa mtaal Juan chop tson zha kuu ngeteed lo Juan, ");
INSERT INTO zaoNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","tsa yanaabdiz zha lo Jesús, naa chu wli lee Jesús nak Crist Kuu Mtaal Diox Nabee o chu tebet zha tedib zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús mkab ne nzhab: ―Tyee goo, ne guz goo lo Juan re kuu mwii goo ne re kuu mbin goo ntsowʼn. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Guz goo lo Juan: “Lee ngutlo re zha syeg nyeni, lee re zha mthans ndiy, lee re zha kuu ndeye kwerp ngwe, lee re zha kuu nakwee mzhaal nza; lee re zha nguth ndroban; ne lee re zha kuu nyeen ndeche zha Diox nzhon zha Diiz Chul chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Wen nzo leettsoo Diox ne Diox re zha kuu nzhagt chop xgab, tak nyelaaz zha na!” ");
INSERT INTO zaoNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Leettsa ndya re zha kuu mtaal Juan, lee Jesús mndelo mndaa kwent chaan Juan lo re men, ne nzhab Jesús: ―¿Kwan ngwatwii goo ngwa goo yubiz? ¿Chu lo thib nith kuu nkwin mbi ngwatwii goo? ");
INSERT INTO zaoNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ne os leey nagte tata, ¿kwan ngwa goo ngwatwii goo tsa? ¿Chu lo thib zha kuu nok lar wen ngwa goo ngwatwii goo? Tak reta goo ne lee re zha kuu nzhok lar wen, nak re zha kuu nzo liz rey. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Per ne goo lon: ¿Cho lo ngwatwii goo tsa? Wlipaa na nin lo goo, lee goo ngwatwii lo thib profet. Ne Juan nak thib profet kuu mas nataak nake re profet kuu ngoo ndala. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juan nak zha kuu nteth xkeets Diox ta nzhab: Na taal thib mos da kuu tener loʼa. Tsa to list zha leettsoo re men par kayaa zha lu. Mal. 3:1 ");
INSERT INTO zaoNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Wlipaa na nin lo goo, xid reta men kuu nzhal yent raa tedib zha kuu mas nataak nake Juan kuu mtsowleyy. Ne tegal tatay, lee zha kuu mas nataagt xith re zha kuu nabee Diox leettsoo, zhaʼa nak zha kuu mas nataak nake Juan. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Desde leettsa mndaa Juan kwent xkiiz Diox ne asta nal, lee re zha kuu nabee Diox leettsoo ndriid yalti lo re zha kuu nakap nak, re zha kuu nlaaz nabee lo re zha kuu nabee Diox leettsoo. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Reta profet ne ley kuu mkee Moisés mndaa kwent lee Crist yaad, ne asta leettsa myaad Juan, asta tyatha mndaa zha kwente. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ne os lee goo nlaaz goo yelaaz goo koree, Juan nap xbi profet Lí, ne Juan nak Lí kuu nzhab re profet yaad. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","¡Os lee goo ndob nza goo ndoblo yen goo koree! ");
INSERT INTO zaoNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Ne nal nin lo goo naa xa nzhak re men tyemp ree. Lee re men nzhak taxal re ndyeen bzhizh, kuu nzi nke byith lo xbi, kuu mbez lo altaa: ");
INSERT INTO zaoNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Naley mbil nee flaut per mkanit goo ne mbilga nee nabil per mbinnt goo”. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Koree nin, tak leettsa mzin Juan kuu mtsowleyy re men, zha kuu nzhowt pan neeka nzhuut xit ub, tsa mbez goo mbi fyer nzo leettsoo Juan. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Per lee nal ndyal na, Kuu Mzin Ngok Men, nzhowʼn ne nzhuun, tsa mbez goo leen nak thib zha kuu nzhowcho ne nzhuucho xit ub, ne nakʼn amig re zha kuu ntsow kobral temi chaan yezlyu kuu nzhax lo zha Roma, ne amig re zha kuu ntsow re kuu went. “Per lee zha kuu nap yalnzhaak chaan Diox, por re kuu ntsow zha nabee lee zha nap yalnzhaak”. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tsa lee re zha yez ta mtsow Jesús re kuu thoz mkox lo Jesús, tak lee re zha re yeza, mlaat zha mod went kuu nak zha, tsa nzhab Jesús: ");
INSERT INTO zaoNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Aka nati rid re goo zha yez Corazín! ¡Aka nati rid re goo zha yez Betsaida! Os lo re men rop yez kuu nak Tiro ne Sidón gagak re kuu thoz kuu ngok lo re goo, chu nal galaa zha re kuu went kuu mtsow zha ne gayelaaz zha Diox, gagok zha lar kuu nambaat ne gatob zha lo di, tsa galoo zha kwathoz nalatt nzo leettsoo zha por re falt zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kona nin, lee wiz kuu naab Diox kwent lo re men, lee yalti kuu rid re goo gak masraa nati nake yalti kuu rid re zha rop yez kuu nak Tiro ne Sidón. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ne lee re goo zha yez Capernaúm, ¿chu ntsow goo xgab lee Diox teno goo yibaa? Nagte tata, lee goo ya asta ta mas naats. Tak os lo re zha yez Sodoma gagak re kuu thoz kuu ngok lo re goo, bee nzika yeza asta nal. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Per wlipaa na nin, lee wiz kuu naab Diox kwent lo re men, lee yalti kuu rid goo gak masraa nati nake yalti kuu rid re zha yez Sodoma. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ne lee tsya nzhab Jesús: ―Nzhoolʼn loʼa Xutʼn, Zha Nabee yibaa ne yezlyu, tak mkaatsa re koree lo re zha nzhaak ne lo re zha kuu nyen re kwaa, ne mloo luy lo re zha kuu nlaaz teed. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Xutʼn, tabaa mtsow luy tak tabaa nlaaza. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tsa nzhab Jesús lo re men: ―Reta kwaa mndaa Xutʼn lon. Ne yent cho ne cho nakʼn, sinke beeta Xutʼn ne cho nakʼn. Ne yent cho ne cho nak Xutʼn, sinke beeta na ne cho nak Xutʼn, ne beeta lo re zha kuu nlazʼn gapʼn naa cho nak Xutʼn. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","De re goo lon, reta goo kuu ngwatsay ne nee kuu ne, na tsow roxkwan goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Bkayaa goo yug kuu tan lo goo, ne bteed goo lon, tak nadoo ne wen nakʼn. Ne tata tak neyy goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tak lee yug ne kuu tan gwe goo naxax nake. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ne re wiza thib wiz sabd, nda Jesús kon re zha kuu ngeteed lo Jesús, mriid re zha thib ta ndab xtil. Tsa lee re zha kuu ngeteed lo Jesús mlann, ne mndelo re zha mthop zha ton nzobxtil, mtembi zhay ne ndow zhay. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ne lee re fariseo mwii kona, tsa nzhab zha lo Jesús: ―Wii lee re zha kuu ngeteed loʼa, ngetsow thib kuu ndoblotaa tsowaa wiz kuu ndroxkwanaa. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tsa lee Jesús mkab ne nzhab: ―¿Chu ter lab goo xkeets Diox naa kwan mtsow rey David, leettsa mlann David kon re zha kuu nda kon David? ");
INSERT INTO zaoNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mndaab David leen gwodoo chaan Diox, ne ndow David re pan nayon kuu ndoblot David wu David, ne noga mndaa Davide ndow re zha kuu nda kon David, pan kuu beeta re ngwleyy ndoblo wu. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ne, ¿chu ter lab goo ley chaan Moisés ta nzhab, lee re ngwleyy mbint ngwleyy diiz kuu nabee ley, tak mke ngwleyy tsiin leen gwodoo chaan Diox wiz sabd, ne mndaat ngwleyy falt? ");
INSERT INTO zaoNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Per lee na ni lo goo, nzhee ndo thib zha kuu mas nataak nake gwodoo chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nyent goo kuu nzhab lo xkeets Diox ta nzhab: “Kuu nlazʼn nak, lat leettsoo goo ne goo taben goo, ne nlaztʼn kuth goo beeta maa par taa goo gon lon”. Os. 6:6 Ne os gayen gooy, gakekit goo zha kuu ntsow kuu wen. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ngenin re koree lo goo, tak na nak xgann mbyi, Kuu Mzin Ngok Men, ne napʼn yalnabee nabeen lo wiz sabd. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tsa mroo Jesús tya, ne ngwa Jesús ta nkaltaa re zha Israel nteed xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ne tya ndo thib mbyi kuu mbiz yaa. Ne kom nkwaan re zha mod keki zha Jesús, tsa nzhab zha lo Jesús: ―¿Chu ndoblo tegwe men thib zha wiz kuu ndroxkwanaa? ");
INSERT INTO zaoNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ne lee Jesús nzhab: ―Os lee thib goo nap thib mbak zhiil ne la maa leen pos wiz sabd, ¿chu koot goo maa? ");
INSERT INTO zaoNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Per lee na ni lo goo mas nataak thib men nake thib mbak zhiil. Kona wen tsow men kuu wen lo thib men wiz sabd. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tsa nzhab Jesús lo mbyi kuu mbiz yaa: ―Bteli yaaʼa. Tsa mteli mbyi yaa mbyi, ne mgwe yaa mbyi taxal tedibe. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tsa oraaka mroo re fariseo ne myaan re zha diiz kuth zha Jesús, tak myet roo zha lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Per lee Jesús myeen naa kwan mtsow re zha xgab tsow zha. Tsa mroo Jesús tya ne naroob men mndeke dits Jesús, ne mtegwe Jesús reta mbyiz kuu nzo xid re mena. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ne nzhab Jesús lo re zhaʼa, tsa yent cho lo gab zha naa cho nak Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Koree ngok, tsa mrolo kuu nzhab profet Isaí, leettsa nzhab profet kuu nzhab Diox kwent chaan Crist: ");
INSERT INTO zaoNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Zha ree nak mos da, kuu mlin, kwathoz nke leettsoon zha, ne kwathoz wen nzo leettsoo nen zha. Taalʼn Mbi Nayon chaan da lo zha, ne taa zha kwent re kuu nali ne kuu wen lo re zha kuu nagt zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Neeka kab root zha, neeka kwez gutht zha, ne yent cho gon kuu ni zha re net. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ne neeka gat zha nith kuu ngots, ne neeka tuyyt zha doo zer kuu penta mke, asta yelo tsow zha, tsow kuu wen gan lo kuu went. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ne reta zha kuu nagt zha Israel ngebet yelaaz zha, zha kuu telaa zha. Is. 42:1-4 ");
INSERT INTO zaoNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tsa ngwano zha thib mbyi kuu nzo mbi fyer leettsoo lo Jesús, syeg zha ne mud zha. Ne mtegwe Jesús zha, tsa mwii zha ne mndediz zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Reta men mzegey leettsoo, ne nzhab: ―¿Chu nagt zha ree, zha raz chaan rey David? ");
INSERT INTO zaoNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Per leettsa mbin re fariseo kona, tsa nzhab re zha: ―Beelzebú kuu nak Maxuuy kuu nabee lo re mbi fyer, mndaa yalnabee lo zha, tsa nabee zha lo re mbi fyer. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Per lee Jesús neʼa naa kwan ntsow re zha xgab, tsa nzhab Jesús: ―Reta yez naro ne re yez bzhizh, ne asta thib yuu kuu nzhak rol zha, gaxta ndo luzhe. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ne tataka, os leeka Maxuuy koo Maxuuy, tsa leeka Maxuuy yo kon leeka Maxuuy, xegt yalnabee chaan Maxuuy naroob, os tatay. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Re goo ni lee na ngo mbi fyer kon yalnabee chaan Beelzebú, os leey tata nake, noga re zha kuu ngeteed lo goo ngoo mbi fyer kon yalnabee chaan Beelzebú. Kona leeka re zhaʼa nloo ngobeet goo kuu ni goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Per os leen ngon mbi fyer por yalnabee chaan Mbi Nayon chaan Diox, koree nloo lee wiz kuu nabee Diox lo goo mzin gaxa. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Gagt tab thib zha liz tedib zha kuu kwathoz ney par kib zha chaan zhaʼa, os ter liib zha zha. Tak os lee zha tsowt zhay gagt kib zha chaan zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Re zha kuu nyelaazt lee na ngo mbi fyer kon yalnabee chaan Mbi Nayon, nzot zhaʼa fabor da ne zhaʼa nayii nen; ne re zha kuu nket tsiin kon na re zhaʼa nluux rtsin na. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Tak nyelaazt goo lee Mbi Nayon chaan Diox ntsow ngon re mbi fyer, kona nin lo goo tetuyy Diox reta falt kuu ntsow men, leettsa ngode men re zha, per tuyyt Diox falt kuu ngode men lo Mbi Nayon. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ne tetuyy Diox re falt kuu ngode men na, Kuu Mzin Ngok Men, per lee men kuu ngode lo Mbi Nayon, tuyyt Diox falt zhaʼa, neeka lo yezlyu ree ne neeka lo tedib yezlyu kuu yo. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Ne ndoblo ne goo, lee ya wen ndaa xle wen, ne lee ya went ndaa xle went, tak reta ya nabee ya por xle kuu ndaa ya. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Goo nak zha raz mbeel! Went nak goo, kona gagt ni goo kuu wen; tak kuu nzo leettsoo men ndroo roo men. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tak lee zha wen kuu wen ni zha, tak kuu wen nzo leettsoo zha, per lee zha kuu went kuu went ni zha, tak kuu went nzo leettsoo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Kona nin lo goo, leettsa tsin wiz kuu naab Diox kwent lo reta men, asta re diiz kuu legaʼa ni goo, taa goo kwent lo Diox ora. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tak por re diiz kuu ni goo naab Diox kwent lo goo, tsa ne Diox naa chu ndab goo falt o ndabt gooy. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tsa lee chop tson fariseo ne chop tson maestr kuu nloo xkiiz Diox, nzhab lo Jesús: ―Nlaaz nee wii nee tsowa thib seny thoz kuu gagt tsow re men yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús mkab ne nzhab: ―Lee re men tyemp ree kuu thitanax went nak ne mlaa Diox, nlaaz zha thib seny thoz, per neeka thib seny loot lo re zha, beeta seny chaan profet Jonás zha ndala loo lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tak leeka taxal ngoo Jonás leettsoo thib mbel, kuu kwathoz naro, tson wiz ne tson yaal, tataka lee na Kuu Mzin Ngok Men, yoon tson wiz ne tson yaal leen yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Leettsa naab Diox kwent lo re men wiz bluz, tsya teti Diox re goo, tak mlaat goo re kuu went kuu ntsow goo, ne telaa Diox re zha kuu ngoo yez Nínive, tak mbin re zhaʼa diiz xkiiz Jonás ne mlaa zha re kuu went kuu mtsow zha. Ne ndoblo ne goo, nzhee ndon ne na nak thib zha kuu mas nataak nake Jonás. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ne lee wiz kuu naab Diox kwent lo re men, tsya teti Diox re goo, tak mlaat goo re kuu went kuu ntsow goo, ne telaa Diox ngot kuu mnabee re yez kuu nzi lad Sur, tak kwathoz tith mroo zha ne ngwa zha lo Salomón, tak nlaaz zha gon zha yalnzhaak chaan Salomón. Ne noga ndoblo ne goo nzhee ndon ne na nak thib zha kuu masraa nataak nake Salomón. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Leettsa lee thib mbi fyer ndroo leettsoo thib zha, tsa nda mbi ndiy mbi thib ta yubiz, nkwaan mbi thib ta roxkwan mbi, ne mzalt ta roxkwan mbi, tsa ntsow mbi xgab: ");
INSERT INTO zaoNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Bretabʼn leeka ta mroon”. Ne leettsa mzin mbi ta mroo mbi, ne mzal mbi mbyiʼa, taxal thib yuu kuu nalath kuu wen nalob ne nambi na. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tsa nda mbiʼa ndaxii tedib gaz mbi kuu masraa went nake mbiʼa, ne ndretab mbi ta ngoo mbi ner. Tsa lee zhaʼa masraa nakap nzhak nake taxal ngok zha ner. Leeka tata gak kon re zha tyemp ree, zha kuu kwathoz nakap nak. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Leettsa bee ngenika Jesús lo re men, lee xnaa Jesús ne re wets Jesús mzin tya, tak nlaaz re zha tediz zha kon Jesús. Ne mlet re zha lee. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tsa lee thib zha nzhab lo Jesús: ―Lee xnaaʼa kon re wetsa nzi lee, ne nlaaz zha tediz zha loʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Per lee Jesús nzhab lo zhaʼa: ―¿Cho nak xnaan ne re wetsʼn? ");
INSERT INTO zaoNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tsa mwii Jesús lo re zha kuu ngeteed lo Jesús, ne nzhab Jesús: ―Re zha ree nak taxal xnaan ne re wetsʼn ne re btan na. ");
INSERT INTO zaoNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tak re zha kuu ntsow kuu nlaaz Xutʼn kuu ndob yibaa, zhaʼa nak taxal wetsʼn btan na ne xnaan. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Thib wiz mroo Jesús leen yuu ta mbet Jesús kon re zha kuu ngeteed lo Jesús, ne ngwa Jesús mndob Jesús roo nitdoo Galilea. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ne kwathoz men mkaltaa lo Jesús, tsa mke Jesús leen thib kano ne mndob Jesús leen kano lo nitdoo. Ne lee re men mrin roo nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tsa mloo Jesús kwaro kwaa lo re men por kwent nanzee. Ne nzhab Jesús: ―Nal tan thib kwent lo goo, lee thib zha kuu nzhann mroo ndalo bin lo yu. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ne leettsa ngego zha bin lo yu, thib nete mla roo net, ne myaad re min ndowe. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tedib nete mla xid ke, ta yent naroob yu; ne kwathoz lijer mlene, tak lut yu nzo ta mlay. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ne leettsa mla be mgole, tak yent naroob yu lozhe kona mbize. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tedib nete mla xid yits, ne mzhen re yits tsa mluux yitse ne mndaate xle. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Per lee tedib nete mla lo yu naal, kwathoz wen mzhene ne kwathoz ngoke. Thib bin mndaa gayoo nzob, lee tedib nete mndaa tson gale ne lee tedib nete mndaa galbtsiiy. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡Os lee goo ndob nza goo ndoblo yen goo koree! ");
INSERT INTO zaoNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tsa lee re zha kuu ngeteed lo Jesús mbig lo Jesús, ne nzhab zha: ―¿Chebee pur kon kwent nanzee niʼa lo re men? ");
INSERT INTO zaoNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús mkab ne nzhab: ―Diox mndaa yalnzhaak lo goo, tsa yen goo re kuu nagaats chaan ta nabee Diox; per lo tedib net zha mndaat Diox diiz yen zhay. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tak lee zha kuu nyen kuu wli chaan Diox, Diox tsow tsa yen zhay masraa; per lee re zha kuu nyente, asta lut kuu nyen zha teyiibe lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kona pur kon diiz nanzee nin lo re zha, tsa tegal wii zhay yent zha kuu ngwii zha, ne tegal gon zhay yent zhay. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Lo re zhaʼa mrolo kuu nzhab profet Isaí zha ndala, leettsa nzhab profet lo re zha ndala: Tegal gon gooy ne yent gooy, tegal wii gooy ne yent goo kuu ngwii goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tak mkow yek re zha yez ree, taxal re zha kuu now nza nak zha, ne taxal re zha kuu now ngutlo nak zha, tsa gagt wii zhay ne gagt gon zhay ne tsa gagt yen zhay kuu nzhon zha. Koree ntsow tsa bretabt zha lon, tsa tegwen zha. Is. 6:9-10 ");
INSERT INTO zaoNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Per wen nda re goo zha kuu nyen kuu ngwii ne nyen kuu nzhon. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tak wlipaa na nin lo goo, tyen re profet kuu ngoo ndala, ne re zha kuu nali mndo lo Diox, ngwalaaz zha gawii zha re kuu ngewii goo nal, per mwiit zhay; noga ngwalaaz zha gagon zha re kuu ngeyon goo, per mbint zhay. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Kenza goo tsa yen goo naa xomod nak kwent nanzee chaan zha kuu ndalo bin lo yu. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Lee re zha kuu nzhon re diiz, kuu ndaa kwent naa xomod nlaaz Diox nabee Diox leettsoo re men, ne nyent zhay, zhaʼa nak taxal bin kuu mla roo net. Nyaad Maxuuy nkib xkiiz Diox leettsoo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ne lee bin kuu mla xid ke ta yent naroob yu, bina nak taxal re zha kuu nzhon xkiiz Diox, ne kwathoz laz zha nkayaa zhay. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Per lee zhaʼa nak taxal bin kuu nzot lozh naats, kona neyt ndo zha lo xkiiz Diox. Ne leettsa nzin thib yalti lo zha o ndreke men dits zha, tak nyelaaz zha Diox, tsa nlaa zha Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Lee bin kuu mla xid yits, bina nak taxal re zha kuu nzhon xkiiz Diox, per kwathoz ntsow zha xgab re kuu yezlyu ree, ne ndablaaz zha keno zha naroob temi. Re kona ntsow nyaant xkiiz Diox leettsoo zha, ne ndaate diiz taa zha xle. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Per lee bin kuu mla lo yu naal, bina nak zha kuu nzhon xkiiz Diox ne nyen zhay. Zhaʼa nak taxal bin kuu ndaa kwathoz xle. Taxal bin kuu mndaa gayoo nzob, lee tedib net zha nak taxal bin kuu mndaa tsongal nzob, ne lee tedib net zha nak taxal bin kuu mndaa galbtsii nzob. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús mndaa tedib kwent nanzee lo re zha, ne nzhab Jesús: ―Lee nal tan tedib kwent nanzee lo goo. Tsa ne goo xomod nak leettsa nabee Diox leettsoo re men. Leey nak taxal thib zha kuu nzhann nzob xtil wen lo yu. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Per leettsa mdat reta zha, tsa lee thib zha kuu nayii ne zha, mndaab ne mloo yizh goob xid nzob xtil zha. Ne leettsa ngwalo mloo zhay, tsa ndya zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ne leettsa lee nzob xtil mlen, mzhene ne mla tone, no yizh goob ndab xid nzob xtil. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tsa lee re zha kuu nke tsiin lo zha kuu nak chaan yu, nzhab lo zha: “Zha Nabee, ¡at nzob xtil wen mloʼaa lo yu! ¿Xomod mlen yizh goob xide?” ");
INSERT INTO zaoNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tsa lee zha kuu nak chaan nzob xtil nzhab: “Thib zha kuu nayii nen mtsow kona”. Tsa lee re zha kuu nke tsiin lo zha mnaabdiz ne nzhab: “¿Chu nlaaza ya nee ne kib nee yizh goob?” ");
INSERT INTO zaoNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Per lee zha nzhab: “Aha, kibt gooy. Tak os lee goo kib goo yizh goob, cha noga nzob xtil kib goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mas wen blaa goo thibka zhene, asta leettsa dop yalgonn. Leettsa taalʼn re zha kuu thop yalgonn, tsa ner re yizh goob thop zha ne liib zhay par yeeke thitanax. Ne lee nzob xtil thop zha ne kotsow zha leen loo ta nzotsow xoobʼn.” ");
INSERT INTO zaoNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús mndaa tedib kwent nanzee lo re zha, ne nzhab Jesús: ―Leettsa lee Diox nabee leettsoo re men, leey nak taxal thib mbiz mostaz kuu mloo thib mbyi lo yu. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Leey nak thib mbiz kuu mas lut lo reta mbiz, per leettsa nlene masraa nzhene nake re ya kuu nzhann zha leen wert. Ne nzhake thib ya naro ne lee re min ndyaad ndexkwaa lyaat lo re zhite. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Noga nzhab Jesús: ―Leettsa lee Diox nabee leettsoo thib men, leey nak taxal lebadur kuu mloo thib ngot xid tson medid arin tsa yezhoobe. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Reta koree nzhab Jesús lo re men kon diiz nanzee, ne os leey nagte kon diiz nanzee nit zhay lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Koree ngok, tsa mrolo kuu nzhab profet kuu ngoo ndala, leettsa nzhab profet: Kon diiz nanzee nin re kuu nagaats chaan Diox, kuu nzogaats desde leettsa mdexkwaa yezlyu. Sal. 78:2 ");
INSERT INTO zaoNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Leettsa ngwalo mchaats Jesús re men, tsa mndaab Jesús leen yuu, ne lee re zha kuu ngeteed lo Jesús mbig ne nzhab lo Jesús: ―¿Xomod nak kwent nanzee chaan nzob xtil kon yizh goob? ");
INSERT INTO zaoNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesús mkab ne nzhab: ―Lee zha kuu nzhann nzob xtil wen, nak na Kuu Mzin Ngok Men. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ne lee yezlyu nak taxal yu, ne lee re zhiinn Diox kuu nabee Diox leettsoo, nak taxal nzob xtil, ne lee re zha kuu nzhon diiz lo Maxuuy, zhaʼa nak taxal yizh goob. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Lee zha kuu nayii nen mloo yizh goob, zhaʼa nak Maxuuy. Wiz bluz leettsa naabʼn kwent lo reta men, leey nak taxal wiz kuu thop zha yalgonn, ne lee re mandad chaan Diox, nak taxal re zha kuu thop yalgonn. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Leeka taxal nthop re mos yizh goob ne nteyy zhay lo ki, leeka tata gak wiz bluz leettsa naabʼn kwent lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Lee na Kuu Mzin Ngok Men, taalʼn re mandad da thop re zha kuu ntsow, ntsow re zha da kuu went, ne reta zha kuu ntsow kuu went. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ne ko re mandad da zha gabil. Tya gonn zha ne tub zha keley. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tsa lee re zha kuu nali nak lo Diox la xni zha ta nabee Xutʼn, taxal nla xni wiz la xni zha. ¡Os lee goo ndob nza goo ndoblo yen goo koree! ");
INSERT INTO zaoNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Leettsa nabee Diox leettsoo men, leey nak taxal kwathoz or kuu nzogaats lo thib lo yu. Ne lee thib zha mzal ora, tsa mkaatska zhay tya. Ne kwathoz laz zha ndya zha ne mtho zha reta kuu nap zha, ne mzhii zha yuʼa, par gak ora chaan zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Leettsa nabee Diox leettsoo re men, leey nak taxal thib zha kuu ndiy nkwaan tyen ke kuu le perla kuu kwathoz nap. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ne leettsa nyetsal zha thib kuu kwathoz chul na, tsa ndya zha ne mtho zha reta kwaa nap zha, ne mzhii zha keʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Leeka tata, leettsa nabee Diox lo re men, leey nak taxal yex kuu ngobi zha leen nitdoo, tsa niit zha relota mbel. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Leettsa ngwalo mze yex zha, tsa ngoo zhay asta roo nitdoo, ne ndob re zha roo nitdoo mbi zha re mbel. Ne ngo zha re mbel wen leen chekwit ne lee re mbel kuu nzhowt men ngobi zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Leeka tata kozhaa re mandad chaan Diox re zha went xid re zha kuu nali nak. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Tsa ko zha re zha went leen orn ki, tya gonn zha ne tub zha keley zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tsa mnaabdiz Jesús lo re zha, ne nzhab Jesús: ―¿Chu myen goo re kwent nanzee ree? Lee re zha mkab ne nzhab: ―Myen neey. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tsa nzhab Jesús kwent nanzee ree lo re zha ne nzhab Jesús: ―Leettsa lee thib maestr, kuu nloo xkiiz Diox, wlipaa nyen xomod nak leettsa nabee Diox leettsoo men, nzhak zha taxal thib mndan yuu, kuu nzhaak ngoo re kuu kub ne re kuu gox xid re kuu nap zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Or ngwalo mni Jesús re kwent nanzee ree, tsa mroo Jesús kon re zha kuu ngeteed lo Jesús tya, ");
INSERT INTO zaoNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ne mzin re zha laz Jesús. Ne wiz sabd mndelo Jesús mloo lo re men ta nkaltaa re zha Israel nteed xkiiz Diox. Tsa mzegey leettsoo re men mbin kuu mloo Jesús, ne mbez zha lo re altaa zha: ―¿Xomod mteed zha ree yalnzhaak ree? ¿Chebee nzhaak ntsow zha re milagr thoz? ");
INSERT INTO zaoNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¡Lee zha ree nak thib zha tbaata, ne nak zha xgann Che kuu nak karpinter ne xnaa zha nak Mari, ne re wets zha nak: Santiag, Che, Simún ne Judas! ");
INSERT INTO zaoNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ne leeka loʼaa nzhee nzi re btan zha. ¿Xomod mteed zha re kuu nzhaak zha? ");
INSERT INTO zaoNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kona ngwalaazt re men Jesús. Per lee Jesús nzhab: ―Neeka thib profet nkayaat re tawlaz zha zha wen ne neeka re zha liz zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kona mtsowt Jesús tyen re kuu thoz tya, tak ngwalaazt re men Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Re wiza lee Herodes kuu mnabee dita yezlyu Galilea, mbin re kuu mtsow Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tsa nzhab rey Herodes lo re zha kuu nke tsiin lo rey: ―Juan kuu mtsowleyy re men nak zhaʼa; mroban zha xid re zha nguth; kona nap zha yalnabee ntsow zha re kuu thoz. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tata nzhab Herodes, tak lee Herodes mnabee mzhen zha Juan ne mloo zha Juan tsib, kwent chaan Herodías tsaal Lip kuu nak wets Herodes. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tak lee Juan nzhab lo rey Herodes: ―Went kenoʼa tsaal wetsa. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ne ngwalaaz Herodes aguth Juan, per nzeb rey ne re men yez, tak reta men nyelaaz lee Juan nak profet. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ne leettsa mzaal rey liin, tsa mtsow rey thib ani, ne lee rtsaap Herodías mkani lo re zha kuu nzi tya, ne kwathoz myow leettsoo rey xa mkani nzaa, ");
INSERT INTO zaoNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","tsa mtselo rey kruz lo nzaa ne nzhab rey: ―Naab loka kuu nlaaza lon, na taay. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tsa mnaabdiz nzaa lo xnaa nzaa, tsa naa kwan ndoblo naab nzaa, tsaraa nzhab nzaa lo rey: ―Taa yek Juan kuu ntsowleyy lon, leen thib yann. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tsa kwathoz nabil ngoo leettsoo rey; per tak kwathoz men nzi or mtselo rey kruz, ne reta zhaʼa mbin kuu nzhab rey, kona nzhab rey lo thib soldad, tsa taa zha yek Juan lo nzaa. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tsa mtaal rey soldad mchuug yek Juan leen tsib. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ne mbe soldad yek Juan leen thib yann, ne mndaa soldade lo nzaa, ne lee nzaa mndaay lo xnaa nzaa. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tsa mzin re zha kuu ngeteed lo Juan, ne mbe zha kwerp Juan mkaats zha. Bluz tsaraa nzhab zhay lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Leettsa mbin Jesús lee Juan nguth, tsa ngoo Jesús leen thib kano ne mroo Jesús tya, nda Jesús thib ta yubiz. Ne mbin re men lee Jesús nda, tsa mroo re men yez ne nda nii re men, mndeke re men dits Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ne leettsa mla Jesús leen kano, mwii Jesús kwathoz men ndeke dits Jesús. Tsa mlat leettsoo Jesús mne re men, ne mtegwe Jesús re mbyiz kuu ndyaadno re men. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ne leettsa mziʼa yezlyu, tsa lee re zha kuu ngeteed lo Jesús mzin lo Jesús, mbig zha ne nzhab zha lo Jesús: ―Mziʼa yezlyu, ne yent men gax nzhee. Bchaats re men tsa ya zha re ranch kuu nzi gaxta nzhee, tsa tii zha lut kuu wu zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tsa mkab Jesús lo re zha: ―Ndoblot bi re zha. Taa goo kuu wu zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Per lee re zha nzhab lo Jesús: ―Napt nee kuu taa nee wu re zha, beeta gaay pan ne chopka mbel nap nee. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tsa nzhab Jesús lo re zha: ―Deno gooy nzhee. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tsa mnabee Jesús tob re men lo yizhwan. Ne mzhen Jesús re gaay pan ne rop mbel, tsa mwii Jesús lobee ne mndaa Jesús texkix lo Diox, ne mtsow rol Jesús re pan ne rop mbel ne mndaa Jesúse lo re zha kuu ngeteed lo Jesús, tsa kiid zhay lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Reta men ndow asta plotha mze leettsoo re men. Ne tsiibchop chekwit pan byu myaan or ngwalo ndow reta men. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ne thib gaay mil mbyi nak kuu ndow, ne mtsowt zha kwent re ngot ne re ndyeen bzhizh. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Bluz leettsa ngwalo mriid koree, tsa mtaal Jesús re zha kuu ngeteed lo Jesús, tsa kendab zha leen kano, par rid zha tedib lad nitdoo. Per lee Jesús myaanka chaats re men. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Or ngwalo mchaats Jesús re men, tsa mkendab thita Jesús yek yii par tediz Jesús lo Diox. Ne or mkow yezlyu thita Jesús ndo tya. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ne lee kano kuu nzo re zha kuu ngeteed lo Jesús ndaʼa tith lo nitdoo. Ne lee nitdoo kwathoz nkwin kano, tak par ta nda re zha ndyaad mbi. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tsa lee Jesús zhaaraa ndyaad lo nitdoo mbig lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Per or mwii re zha lee Jesús ndyaad lo nitdoo, tsa dib gan mrez re zha, tak kwathoz mzeb re zha, ne nzhab zha: ―¡Kuu fyera! ");
INSERT INTO zaoNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Per lee Jesús nzhab lo re zha: ―Tsebt goo, bloney goo leettsoo goo nay. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tsa lee Pey nzhab lo Jesús: ―Zha Nabee, os luy, btsow tsa no na te lo nitdoo, tsa tsin na ta ndoʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tsa nzhab Jesús lo Pey: ―De nzhee. Tsa lee Pey mla leen kano ne mnde lo nitdoo nda lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Per or myeen Pey kwathoz nax mbi, tsa mzeb Pey, ne lee Pey ndalowgwa leen nit, tsa mretsyath Pey, ne nzhab Pey: ―Zha Nabee, laata lowʼn. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Oraaka mzhen Jesús yaa Pey, ne nzhab Jesús lo Pey: ―¿Chebee lutta nyelaaza na? ¿Chebee ngok chop xgaba? ");
INSERT INTO zaoNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Leeka or kuu mke rop zha leen kano, lee mbi mlet. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tsa lee re zha kuu nzo leen kano mtobxub lo Jesús, ne mbil zha lo Jesús nzhab zha: ―Wlipaa lee lu nak Xgann Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tsa mriid re zha tedib lad roo nitdoo, ne mzin zha thib yez kuu le Genesaret. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Or mlebee re men yeza Jesús, dita lo yezlyuʼa mchaats zha diize, tsa myaadno re zha re mbyiz ta ndo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ne mnaab re zha lo Jesús tsa taa Jesús diiz diinn re mbyiz xab Jesús; ne reta zha kuu ndiinn xab Jesús ngwe zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tsa mbig chop tsonta fariseo ne chop tsonta maestr kuu nloo xkiiz Diox, re zhaʼa nak zha Jerusalén, tsa mnaabdiz zha lo Jesús, nzhab zha: ");
INSERT INTO zaoNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Chebee lee re zha kuu ngeteed loʼa ntsowt zha kuu mloo re teyaa zha ndala? ¿Chebee nat zha or nzhow zha, taxal nzhab re teyaa? ");
INSERT INTO zaoNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tsa mnaabdiz Jesús lo re zha, nzhab Jesús: ―¿Chebee noga goo nzhont goo diiz kuu nabee Diox lo goo tsow goo, leel re kuu mloo teyaa zha ndala ntsow goo? ");
INSERT INTO zaoNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tak lee Diox nzhab: “Bke leettsooʼa xuta ne xnaaʼa”. Ex. 20:12 “Ne loka zha kuu ngode xut ne xnaa, ndoblo gath zha”. Lv. 20:9 ");
INSERT INTO zaoNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Per lee goo mbez tak gab zha lo xut zha ne lo xnaa zha: “Gagt raa tsowʼn ayud goo, tak reta kuu gatan lo goo mndaʼa nay gon lo Diox”. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ne ni goo loka cho kuu tenzhee gab, ndoblot raa tsow zha ayud xut zha ne xnaa zha. Tbaa nak goo, mlaa goo re diiz nataak kuu nabee Diox tsow goo, leel re kuu mloo re teyaa zha ndala nyelaaz goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Zha nkedi nak goo, zhaa kuu mbez ne zhaa kuu ntsow goo! Wen wen mndaa profet Isaí kwent chaan goo, leettsa nzhab profet: ");
INSERT INTO zaoNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Re men yez ree beeta kon roo zha nzhool zha lon, per lee leettsoo zha tith ndo lon. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nataagt nzhool re zha ree lon, tak purta leyy kuu nloo re men nloo zha. Is. 29:13 ");
INSERT INTO zaoNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tsa mrez Jesús re men, ne nzhab Jesús: ―Bkenza goo koree, tsa yen gooy. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nagt kuu nzhow zha ntsow nambit zha lo Diox, tak re kuu went kuu ndroo roo zha kuu ntsin leettsoo zha, kona ntsow nzhak nambit zha lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tsa mbig re zha kuu ngeteed lo Jesús, ne nzhab zha lo Jesús: ―¿Chu myeenta mkezhyan re fariseo mbin kuu nzhaba? ");
INSERT INTO zaoNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tsa mkab Jesús, ne nzhab Jesús: ―Reta zha kuu nloo re leyy kuu nagt leyy chaan Xutʼn kuu ndob yibaa, teluux Xutʼn re zhaʼa, koree nak taxal zha kuu nkib dib lozh thib ya kuu mtot zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Laa goo zha baa, tak syeg zha. Ne os lee thib syeg teno tedib syeg, leen thibka yeeryu la ropta zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Per lee Pey nzhab lo Jesús: ―Taa kwent lo nee naa xomod nak diiz nanzee ree. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tsa mkab Jesús ne nzhab Jesús: ―¿Chu no goo nyente? ");
INSERT INTO zaoNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Chu nyent goo, reta kuu nzhow zha ndya leettsoo zha, ne tsaraa ndrooy? ");
INSERT INTO zaoNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Per lee kuu ndroo roo zha, leen leettsoo zha ntsin kona, ne ntsowe nzhak nambit zha lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tak leen leettsoo zha: ntsin re xgab kuu went, kuth zha taben zha, gak rop zha kon thib zha kuu nagt tsaal zha, gak rop zha kon ndota zha, lowann zha, nkeki zha re zha kuu nkedi zha, ne re kuu nge zha taben zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Re koree ntsow nzhak nambit zha lo Diox; per lee kuu wu men ne nat men, ntsowt kona par gak nambit men lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tsa mroo Jesús tya ne nda Jesús yezlyu Tiro ne yezlyu Sidón. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tya lee thib ngot zha Canaán, kuu nzo tya mbig lo Jesús, ne dib gan zha mrez zha ne nzhab zha lo Jesús: ―¡Zha Nabee, xgann rey David, blat leettsooʼa neʼa na! Tak kwathoz ndakti rtsaapʼn, tak nzo thib mbi fyer leettsoo nzaa. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Per neeka thib lan diiz mkabt Jesús lo ngot. Tsa lee re zha kuu ngeteed lo Jesús mbig, ne nzhab lo Jesús: ―Btaal ngot baa liz ngot, tak kwathoz nkee ngot bi ndeke ngot ditsaa. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tsa lee Jesús nzhab: ―Beeta lo re tawlazaa kuu nak taxal mbak zhiil kuu mndab, mtaal Dioxʼn. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Per lee ngota mbig lo Jesús mtobxub ne nzhab: ―Zha Nabee, btsow ayudʼn. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tsa mkab Jesús, ne nzhab Jesús: ―Went kib zha pan lo ndyeen bzhizh ne taa zhay lo re mbak. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tsa nzhab ngot lo Jesús: ―Tata nake, Zha Nabee. Per noga mbak nzhow mbak re kuu byu kuu nzhab xann mes bzhaan mbak, leettsa nzhow zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tsa nzhab Jesús lo ngot: ―¡Ngot, tak kwathoz nyelaaza Diox! Kona gak kuu nlaaza. Ne leeka ora mgwe rtsaap ngot. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tsa mroo Jesús tya ne nda Jesús mzin Jesús roo nitdoo chaan Galilea, ne mkendab Jesús yek yii tya ne mndob Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tsa kwathoz men mkaltaa lo Jesús ta ndob Jesús. Ne myaadno re men re zha renk, re zha syeg, re zha tunk, ne re zha mud ne tedib net re mbyiz. Tsa mtegwe Jesús re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ne lee re zha kuu nzi tya kwathoz mzegey leettsoo zha, or mwii zha, lee re zha mud nzhaak ndediz, lee re zha tunk ngwe, ne lee re zha renk ngwe ne lee re zha syeg nyeni lo. Tsa mndelo re zha mbil zha lo Diox chaanaa, zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tsa mrez Jesús re zha kuu ngeteed lo Jesús, ne nzhab Jesús lo re zha: ―Nlat leettsoon nen re men ree, tak ndaʼa tson wiz nzi zha kon reʼaa nzhee, ne yent kwan nap zha wu zha. Nlaztʼn taalʼn re zha liz zha ne wut zha, tak cha layaal zha net. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tsa lee re zha kuu ngeteed lo Jesús nzhab: ―¿Per pa yaxiiʼaa kuu wu thib labaa raa men, thib ta yent men? ");
INSERT INTO zaoNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús mnaabdiz, ne nzhab: ―¿Plal pan nap goo? Tsa nzhab re zha: ―Gaz pan ne chop tsonta mbel. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tsa mnabee Jesús lo re men tob re men lo yu. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ne mzhen Jesús re gaz pan ne re mbel ne mndaa Jesús texkix lo Diox. Tsa mtsow rol Jesús pan ne mndaa Jesús pan lo re zha kuu ngeteed lo Jesús. Ne lee re zha mdide lo re men kuu nzi tya. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Reta men ndow asta plotha mze leettsoo men. Ne mtse zha gaz chekwit ngoo re kuu byu kuu mrozhoob. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Thap mil mbyi ndow tya, ne ngoot kwent re ngot kon re ndyeen bzhizh. ");
INSERT INTO zaoNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Bluz tsaraa mchaats Jesús re men ndya, ne lee Jesús mke leen thib kano ne nda Jesús par yezlyu Magadán. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tsa lee re fariseo ne re saduceo ngwa lo Jesús; ne mnaab zha thib seny yibaa lo Jesús, tsa tak keki zha Jesús ne ten zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Per lee Jesús mkab lo re zha ne nzhab: ―Leettsa nane na xkow lobee or ndetsi yezlyu; tsa mbez goo: “Wen la bee”. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ne leettsa nane na xkow lobee ne nakal na nzhal til, tsa mbez goo: “Naltseree tela yi ne tax mbi thoz”. ¡Zha nkedi nak goo, zhaa kuu mbez goo ne zhaa kuu ntsow goo! Nlebee goo re seny kuu nyoo lobee, ¡per nlebeet goo re seny nal tyemp ree! ");
INSERT INTO zaoNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Goo kuu ngwii re milagr thoz kuu ntsowʼn, went nak goo ne thitanax mlaa goo Diox. Naab goo thib seny thoz, per neeka thib seny loot lo goo, sinke beeta seny chaan profet Jonás zha ndala loo lo goo. Ngwalo nzhab Jesús kona, tsa mlaa Jesús re zhaʼa ne nda Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Leettsa ngwalo mriid Jesús kon re zha kuu ngeteed lo Jesús tedib lad roo nitdoo, tsa mtelaaz re zha kuu ngeteed lo Jesús mbet zha pan. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tsa nzhab Jesús lo re zha: ―List gok goo, kayaat goo lebadur chaan re fariseo ne lebadur chaan re saduceo. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tsa nzhab re zha lo altaa zha: ―Ndyaadnotaa; pan kona tabaa ne zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Per myeen Jesús kona, tsa nzhab Jesús lo re zha: ―¿Chebee ni goo nkenot goo pan? ¡Men kuu lutta nyelaaz Diox! ");
INSERT INTO zaoNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Chebee terka yen goo lee na, tak ntsowʼn re kuu thoz? ¿Chu ntelaazt goo re gaay pan kuu mndan ndow gaay mil mbyi? Ne, ¿plal chekwit kuu byu mrozhoob? ");
INSERT INTO zaoNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Chu neeka gaz pan kuu mndan ndow thap mil mbyi, ntelaazt goo plal chekwite mrozhoob? ");
INSERT INTO zaoNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Chebee nyeent goo ngenitʼn kwent lebadur chaan pan? Sinke leen ni lo goo list gok goo, kayaat goo lebadur chaan re fariseo ne chaan re zha saduceo. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tsaraa myeen re zha, lee Jesús ngetaat kwent chaan lebadur kuu nyoo pan, sinke list ndoblo gak zha lo re kuu nloo re fariseo ne re saduceo, kuu nak taxal lebadur. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Leettsa mzin Jesús yezlyu ta nak Cesarea-Filipo, tsa mnaabdiz Jesús lo re zha kuu ngeteed lo Jesús, ne nzhab Jesús: ―¿Cho nak na Kuu Mzin Ngok Men, ni re men? ");
INSERT INTO zaoNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tsa lee re zha nzhab: ―Thib net zha mbez leeʼa nak Juan kuu mtsowleyy, lee tedib net zha mbez leeʼa nak profet Lí, lee tedib net zha mbez leeʼa nak profet Jeremí, ne lee tedib net zha mbez leeʼa nak tedib re profet. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tsa nzhab Jesús lo re zha: ―Ne lee re goo, ¿cho nakʼn ndak goo? ");
INSERT INTO zaoNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tsa lee Simún Pey mkab, ne nzhab: ―Lu nak Xgann Diox kuu naban, Kuu Mtaal Diox Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tsa lee Jesús mkab lo Pey, ne nzhab: ―Wen ndaʼa Simún xgann Jonás. Tak neeka thib men mloot koree loʼa, sinke Xutʼn kuu ndob yibaa mlooy loʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ne na ni lee lu nak Pey, ne lee leʼa nak “ke”, ne dits ke ree tan gwodoo da, kuu nak re zha kuu nyelaazʼn. Ne lee yalney chaan yalguth tsowt gan loy. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ne loʼa tan yab chaan ta nabee Diox. Tsa reta kuu liiba lo yezlyu ree, naliibe yibaa, ne reta kuu xaka lo yezlyu ree, nazhake yibaa. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tsa lee Jesús mnabee lo re zha kuu ngeteed lo Jesús, tsa yent cho lo gab re zha, lee Jesús nak Crist Kuu Mtaal Diox Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Desde tsya mndelo Jesús nzhab Jesús lo re zha kuu ngeteed lo Jesús, lee Jesús ndoblo ya Jerusalén, ne tya kwathoz rid Jesús yalti lo re zha gol, ne lo re ngwleyy kuu nabee lo re ngwleyy ne lo re maestr chaan ley. Ne kuth zha Jesús, per leettsa tsaal tson wiz lee Jesús roban. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tsa lee Pey mloo Jesús thib lad, ne mndelo Jesús mkox Jesús lo Pey, ne nzhab Pey lo Jesús: ―Diox, Zha Nabee, lat leettsoo neʼa. ¡Ridta kona! ");
INSERT INTO zaoNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Per lee Jesús mtsere lo, ne nzhab lo Pey: ―¡Btow rooʼa Maxuuy! Lu ngetow lon. Tak ntsowta xgab kuu ntsow Diox xgab; sinke leeʼa ntsow xgab taxal ntsow re men xgab. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tsa lee Jesús nzhab lo re zha kuu ngeteed lo Jesús: ―Os cho goo nlaaz teke ditsʼn, bnithlaaz goo reta kuu nap goo, ne reta kuu nzo yek goo tsow goo, ne thib bloo goo leettsoo goo gath goo, tak nyelaaz goo na. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tak lee zha kuu kot thib leettsoo gath, tak nyelaaz zha na, tath zhaʼa ne tsowt zha gan yalnaban kuu thitanax; per lee zha kuu thib ko leettsoo gath tak nyelaaz na, tetsow zhaʼa gan yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Kwan tsow men gan keno zha reta kuu nzo yezlyu ree, ne kenot zha yalnaban kuu thitanax? Gagt taa men neeka thib kwaa lo Diox par taa Diox yalnaban kuu thitanax lo men. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Koree nin lo goo, tak lee na Kuu Mzin Ngok Men, yaalʼn kon xni thoz chaan Xutʼn ne kon re mandad Xutʼn, ne tsa taa na lo kadta thib thib zha kuu ndoblo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Wlipaa na kuu ngenin lo goo, nzo chop tson goo kuu nzi nzhee, gatht goo, asta wii goo naa xa nabee Diox kon yalnabee chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Xoop wiz bluz lee Jesús zhaata mndeno Pey, Santiag ne Juan wets Santiag, ne ngwa re zha yek thib yii naro. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ne tya mzee mod na Jesús lo re yon zha. Ne lee lo Jesús mla xni taxal xni wiz, ne dita xab Jesús naguz na taxal xni wiz. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ne tya mloo Moisés ne Lí ngetediz kon Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tsa nzhab Pey lo Jesús: ―Zha Nabee, ¡wen thoz nzi nee nzhee nal! Os leeʼa nlaaza, taa nee tson ramad, thibe gak chaana, tedibe gak chaan Moisés ne lee tedibe gak chaan Lí. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Or lee Pey bee ngenika, lee thib xkow kuu anta xni na mtow re zha, ne xid xkowa mroo thib bos kuu mbin re zha, kuu nzhab: ―Zha ree nak xgann na kuu kwathoz nke leettsoon, ne kwathoz wen nzo leettsoon nen zha. Bin goo diiz lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Or mbin re zha kuu ngeteed lo Jesús kona, reta zha mkiits zha yek zha lo yu, ne kwathoz mzeb zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tsa mbig Jesús lo re yon zha, ne mdiinn Jesús zha, ne nzhab Jesús lo re zha: ―Gwateli goo; tsebt goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ne leettsa mwii re zha yenta cho nak, sinke beeta Jesús ndo tya. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Or ndyaadla re zha yek yiiʼa, lee Jesús mnabee lo re zha ne nzhab: ―Neeka thib lo zha gabt goo kuu mwii goo, asta leettsa lee na Kuu Mzin Ngok Men, roban xid re zha nguth. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tsa lee re zha kuu ngeteed lo Jesús mnaabdiz lo Jesús, ne nzhab: ―Os leey tata nake, ¿chebee lee re maestr kuu nloo xkiiz Diox nzhab, ner Lí yaad? ");
INSERT INTO zaoNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tsa lee Jesús mkab ne nzhab: ―Wli ner Lí yaad, tsa texnet Lí reta kwaa. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Per leen ni lo goo, myaada Lí per mkayaat re men Lí, sinke mtsowno re men Lí kuu nlaaz men. Ne leeka tata lee na Kuu Mzin Ngok Men, kwathoz ridʼn yalti lo re mena. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tsa lee re yon zha kuu ngeteed lo Jesús, myeen lee Jesús ngetaa kwent chaan Juan kuu mtsowleyy re men. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Leettsa lee Jesús kon re yon zha kuu ngeteed lo Jesús mretab ngwa yek yii, tsa mzin re zha ta nzi re men. Tsa mbig thib zha ne mtobxub zha lo Jesús, ne nzhab zha: ");
INSERT INTO zaoNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Zha Nabee, blat leettsooʼa neʼa xgann na, tak ndak nyo yizguthye. Ne kwathoz ndakti nyo lo yiz; ne kwathoz tyen welt nzhab nyo lo ki ne leen nit. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Myaadnon nyo lo re zha kuu ngeteed loʼa, per mtsowt zha gan gategwe zha nyo. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús mkab ne nzhab lo re zha kuu nzi tya: ―Zha went, kuu nyelaazt Diox nak goo. ¿Asta pol ton lo goo? ¿Asta pol xek leettsoon nen goo? Deno xganna nzhee. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tsa lee mbi fyer mkox lo Jesús ne mroo leettsoo nyo, ne oraaka lee nyo mgwe. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tsa lee re zha kuu ngeteed lo Jesús, ngwa mnaabdiz lo Jesús zhaata ne nzhab re zha lo Jesús: ―¿Xomod lee nee, ngogt gagoo nee mbi fyer baa? ");
INSERT INTO zaoNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tsa lee Jesús nzhab: ―Ngogt gagoo goo mbi fyer baa, tak lutta nyelaaz goo Diox. Wlipaa na nin lo goo, os lee goo nyelaaz goo Diox mase lut taxal na thib mbiz mostaz, kuu thib ndezhen, neeka thib kuu gagt nagan lo goo. Tak gab goo lo yii ree: “Beche nzhee ne tyee tedib lad”, ne teyiib yii. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Reta mbi kuu tenzhee nak, tak rooy os lee men naab mene lo Diox ne tsow men ayun. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Thib wiz leettsa nzi re zha yezlyu Galilea, tsa lee Jesús nzhab lo re zha kuu ngeteed lo Jesús: ―Lee na Kuu Mzin Ngok Men, taa zha na lo re men, ");
INSERT INTO zaoNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ne kuth zha na, per leettsa tsaal tson wiz lee na roban. Leettsa mbin re zha koree, kwathoz nabil ngoo leettsoo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Leettsa mzin Jesús kon re zha kuu ngeteed lo Jesús yez Capernaúm, tsa lee re zha kuu ntsow kobral temi chaan gwodoo, ngwa mnaabdiz lo Pey ne nzhab: ―¿At ngixt maestr goo temi kuu nzhax lo gwodoo? ");
INSERT INTO zaoNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Lee Pey mkab ne nzhab: ―Ngix zhay. Ne leettsa lee Pey mndaab leen yuu, lee Jesús mni lo Pey ne nzhab: ―¿Simún, kwan ntsowa xgab? ¿Cho lo ntsow re zha kuu nabee lo yezlyu ree kobral temi chaan yezlyu? ¿Chu lo re tawlaz zhay o chu lo re zha tedib yeze? ");
INSERT INTO zaoNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pey mkab ne nzhab: ―Lo zha tedib yeze. Tsa lee Jesús nzhab: ―Kona lee re tawlaz zha ndoblot kix neeka thib rehal. ");
INSERT INTO zaoNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Per ndoblot tsowaa, tak leettsoo neeka thib zha. Kona nin loʼa, gwa roo nitdoo, ne blebi answel kuu niita mbel. Ne roo mbel kuu ner niita yetsala thib temi kuu tegaa kizha chaanaa. Bzhene ne gwathix lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Thib welt lee re zha kuu ngeteed lo Jesús, mbig lo Jesús ne nzhab: ―¿Cho nak zha kuu mas nataak lo re zha kuu nabee Diox lo? ");
INSERT INTO zaoNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tsa mrez Jesús thib nyo lut, ne mto Jesús nyo ndrol lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ne nzhab Jesús: ―Wlipaa na nin lo goo, os lee goo gagt goo taxal ndyeen bzhizh, gagt tab goo ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kona lee zha kuu nadoo nak taxal nyo lut ree, zhaʼa nak zha kuu mas nataak ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Loka zha kuu nkayaa thib re ndyeen bzhizh, tak nyelaaz zha na, leey nak taxal na nkayaa zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Loka cho kuu tsow lee thib re ndyeen bzhizh kuu nyelaaz na, tsow kuu went; mas wen kee zha thib ke naro yen zhaʼa, ne kobi zha zhaʼa leen nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Aka! Kwathoz nalatt rid re men yezlyu ree wiz bluz, ne lo yezlyu ree wli too re zha kuu ntsow par laa zha da na. Aka nalat rid re men kuu nzo lo yezlyu ree, kuu tsow laa re zha da na. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Kona os lee yaaʼa o niiʼa ntsow ntsowa kuu went, mas wen lortsint raa luy, ne btsow taxal mga luy ne mlobi luy tith, tak mas wen taba kayaaʼa yalnaban kuu thitanax tunka, nake nkenoʼa rop yaaʼa ne rop niiʼa ne ndyaʼa lo bel kuu thitanax nyuyyt. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ne os lee ngutloʼa ntsow tsowa kuu went, mas wen lortsint raa luy, tak mas wen taba kayaaʼa yalnaban kon thibka ngutloʼa, nake napa rop ngutloʼa ne ndyaʼa gabil ta nyuyyt bel thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Wii goo ndoblot tsow nataagt goo, neeka thib re ndyeen bzhizh ree, tak kwathoz nataak ndyeen lo Xutʼn Diox, ne lee re mandad chaan re ndyeen ree thibka nzi lo Xutʼn kuu ndob yibaa. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tak lee na Kuu Mzin Ngok Men, ndyaad kwaan re zha kuu mndab ne telaa re zha lo yalguth. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Kwan ntsow goo xgab, kwan tsow thib zha, os lee thib zha tak koree? Os lee thib zha nap thib gayoo mbak zhiil ne tab zha thib maa, wlipaa telaa zha tedib re thap galbtsiiyee maa wan, ne yakwaan zha maa kuu mndaba, asta tsal maa lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ne or tsal maa lo zha, wlipaa na nin lo goo, mas naley yo leettsoo zha ne zha maa kuu mndaba, nake re thap galbtsiiyee maa kuu mndabt. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Leeka tata lee Xutaa kuu ndob yibaa, nlaazt zha roo neeka thib re ndyeen bzhizh ree xid re zha kuu nyelaaz na. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Os lee wetsa ntsow thib kuu went loʼa, bni lo zha or thita zha, ne btsow yen zha went kuu mtsow zha, tsa tsee zha mod nak zha. Os lee zha gon zha xkiiza, mtsowa lu gan yaan wetsa xith re zha kuu nabee Diox leettsoo. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ne os lee zha gont zha xkiiza, tsa brez thib zha o chop zha da, gwa goo lo zha ne ndoblo tsow goo taxal nke lo xkeets Diox ta nzhab: “Ndeche chop zha o tson zha kuu gab thibka kwaa, ne kuu gab re zhaʼa kona gak, tsa tyatha yaan kwent”. Dt. 19:15 ");
INSERT INTO zaoNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Os lee zhaʼa gont xkiiz goo, guz gooy lo re zha da kuu nyelaaz Diox. Tsa kox zhaʼa lo re zha da, ne os lee zhaʼa nlaaztga zha gon zha xkiiz re zha kuu nyelaaz Diox, tsa ndoblo wii goo zha, taxal thib zha kuu nagt zha yez chaan Diox, ne taxal thib zha kuu ntsow kobral temi chaan yezlyu kuu nzhax lo zha Roma. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Wlipaa na nin lo re goo, reta kuu liib goo lo yezlyu ree, naliibe yibaa; ne reta kuu nxak goo lo yezlyu ree, nazhake yibaa. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Ne noga nin lo goo: Os beeta chop goo myaan goo diiz lo yezlyu ree, naab goo thib kuu nlaaz goo lo Xutʼn kuu ndob yibaa, tataa Xut nay. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tak ta nzi chop zha o tson zha kuu nak zha da, tya ndon ndrol lo re zha ne gon na kuu gab zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tsa lee Pey mbig lo Jesús ne nzhab: ―Zha Nabee, ¿plal welt ndoblo la leettsoon lo re kuu went kuu ntsow wetsʼn lon? ¿Chu wen asta gaz welt? ");
INSERT INTO zaoNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús mkab ne nzhab: ―Nitʼn gazka welte, sinke leen ni: Thap gayoo thap galbtsii welt, ndoblo la leettsooʼa neʼa wetsa. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Ne tak tabaa nake, kona nin kwent nanzee ree lo goo. Leettsa nabee Diox, leey nak taxal thib rey, kuu ngwalaaz gatsow kwent naa plo ndab re mos rey lo rey. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Leettsa mndelo rey mtsow kwent, tsa ner mtaal rey zha ngwachez thib zha kuu ndab kwathoz miyon temi lo rey. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ne lee zhaʼa gagt kix lo rey, tsa lee rey mnabee: “Tho zha zha, kon tsaal zha ne kon re zhiinn zha ne kon reta kuu nap zha, tsa tata mod gax kuu ndab zha”. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tsa mtobxub mos ne mnaab mos lo rey ne nzhab mos: “Zha nabee bxek leettsooʼa neʼa na; xlaaz yizhʼn retay loʼa”. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tsa mlat leettsoo rey ne mla leettsoo rey mne zhaʼa, tsa mlaa rey zha taxal thib zha kuu ndabt neeka thib pes. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Per leettsa mroo zha lo rey, tsa nda zha ne mzaal zha thib zha kuu ndab lut temi lo zha. Tsa mzhen zha yen zhaʼa ne mde zha yen zhaʼa, ne nzhab zha lo zhaʼa: “¡Bdix kuu ndaba lon!” ");
INSERT INTO zaoNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tsa lee zha kuu ndab lo zha, mtobxub lo zha ne nzhab: “Bxek leettsooʼa neʼa na; xlaaz yizhʼn retay loʼa”. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Per lee zha mzhyalt zha, leel ndano zha zha ne mloo zha zha tsib, asta kix zha reta kuu ndab zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Leettsa mwii tedib net re mos rey kona, kwathoz nabil ngoo leettsoo re zha, tsa ngwa re zha ne nzhab zha kuu ngok lo rey. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tsa lee rey mrez zha kuu tata mtsowa, ne nzhab rey lo zha: “¡Zha nakap! Mla leettsoon mnen lu por reta kuu ndaba lon, tak mnaab luy lon. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Noga lu ndoblo galat leettsooʼa ganeʼa altaaʼa, taxal mlat leettsoon mnen lu.” ");
INSERT INTO zaoNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tsa kwathoz mnayii rey, ne mnabee rey mteti zha zha, asta kix zha reta kuu ndab zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tsa nzhab Jesús: ―Tabaaka tsow Xutʼn Diox kuu ndob yibaa lo re goo, os lee goo latta leettsoo goo lo re kuu went kuu ntsow taben goo lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Leettsa ngwalo nzhab Jesús re diiz ree, tsa mroo Jesús yezlyu Galilea, ne nda Jesús par yezlyu Judea kuu nzi tedib lad roo yoo Jordán, kon re zha kuu ngeteed lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ne kwaro men mndeke dits Jesús, ne mtegwe Jesús re zha kuu ne ndak, kuu nzo xid re mena. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tsa lee chop tson zha fariseo mbig lo Jesús, ne mnaabdiz zha thib kuu nzhab lo ley, tsa naa chu takab Jesús thib kuu ndoblot, tak nlaaz zha kwaan zha naa xomod keki zha Jesús, tsa nzhab zha lo Jesús: ―¿Chu tak laa thib mbyi tsaal mbyi por ndota kwaa? ");
INSERT INTO zaoNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tsa lee Jesús mkab ne nzhab: ―¿Chu ter lab goo lo xkeets Diox, leettsa mdexkwaa Diox yezlyu, thibka mbyi ne thibka ngot mtsaal Diox? ");
INSERT INTO zaoNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ne noga nzhab Diox: “Kona lee mbyi ndoblo roo zhaa lo xut ne lo xnaa, tsa tseya mbyi kon ngot mbyi, ne lee rop zha gak taxal thibka zha”. Gn. 2:24 ");
INSERT INTO zaoNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kona nagt raa zha chop zha, sinke taxal thibka zha nak zha rop zha. Kona ndoblot laa zha tsaal zha, tak Diox mtsaal rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tsa mnaabdiz re zha lo Jesús ne nzhab zha: ―¿Xomod lee Moisés nzhab tak laa mbyi tsaal mbyi, beeta ndoblo taa mbyi thib yeets kuu mroo yuulow kuu nzhab, lee mbyi mtso rop tsaal? ");
INSERT INTO zaoNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tsa lee Jesús nzhab: ―Tbaa mne Moisés lo goo, tak kwathoz nad leettsoo goo, per ner ngogte tata. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Per lee na ni, loka cho mbyi kuu laa tsaal, ne nagte tak ngok rop ngot kon tedib mbyi, ne kaa mbyi tedib ngot, ndaa mbyi thib falt ro lo Diox, tak nzhak rop mbyi kon tedib ngot. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tsa lee re zha kuu ngeteed lo Jesús nzhab: ―Os tata nak kwent chaan mbyi kon tsaal mbyi, mas wen kat mbyi ngot. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús mkab ne nzhab: ―Ret men nxek ntseyat, beeta re men kuu mndaa Diox diiz lo tak tsowe. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nzo zha nyowt leettsoo kaa ngot, tak tata nak zha ngol zha, ne nzo zha nkaat ngot, tak men mtsow nyoot yek zha kaa zha ngot, ne nzo zha nkaat ngot, tak nlaaz zha ke zha tsiin taa zha kwent chaan ta nabee Diox. Zha kuu tak tsow koree, wen ntsow zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tsa ngwano zha chop tson ndyeen bzhizh lo Jesús, tsa xoob Jesús yaa Jesús yek re ndyeen, tsa naab Jesús lo Diox por re ndyeen. Per lee re zha kuu ngwano ndyeen mndelo mkox lo re zha kuu ngeteed lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Per lee Jesús nzhab: ―Laa goo yaad re ndyeen bzhizh lon, ne towt goo lo re ndyeen, tak lee ta nabee Diox, nak chaan re zha kuu nadoo nak taxal re ndyeen bzhizh. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ne mxoob Jesús yaa Jesús yek re ndyeen, par tsow Diox kuu wen lo re ndyeen. Tsaraa mbi Jesús tya. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Lee thib zha mndyeen ngwa mnaabdiz lo Jesús ne nzhab: ―Maestr wen, ¿kwan kuu wen tsowʼn tsa tsowʼn gan yalnaban kuu thitanax? ");
INSERT INTO zaoNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús mkab lo zha ne nzhab: ―¿Chebee zha wen niʼa lon? Tak neeka thib zha wen yent, beeta Diox wen nak. Per os leeʼa nlaaza kenoʼa yalnaban kuu thitanax, bin diiz re diiz kuu nataak kuu nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tsa lee zha mndyeen nzhab: ―¿Pa kuu tsa? Tsa lee Jesús nzhab: ―Kuthta tabena, gagt ropa kon ngot kuu nagt tsaala, lowannta, kekita tabena kon thib kuu wlit, ");
INSERT INTO zaoNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","bke leettsooʼa xuta ne xnaaʼa, ne bke leettsooʼa tabena taxal nke leettsooʼa leeka lu. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Lee zha mdyeena nzhab: ―Reta koree nzhona na diiz. ¿Kwan raa ndoblon tsowʼn? ");
INSERT INTO zaoNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tsa nzhab Jesús lo zha: ―Os leeʼa nlaaza gaka thib zha nali, tyee ne btho reta kwaa napa ne btaay lo re zha prob, tsa kenoʼa naroob kwaa yibaa; tsaraa yaada ne tekeʼa ditsʼn. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Leettsa mbin zha mndyeen kona, kwathoz nabil ngoo leettsoo zha ndya zha, tak naroob kwaa nap zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tsa lee Jesús mne lo re nee kuu ngeteed lo Jesús: ―Wlipaa na nin, kwathoz nagan laa thib zha rik nabee Diox leettsoo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tedib welt nin lo goo, mas nagant rid thib kamey yeer kuu le ngutlo abuj, nake tab thib zha rik yibaa ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Leettsa lee re zha kuu ngeteed lo Jesús mbin kona, tsa kwathoz mzegey leettsoo zha ne mbez zha lo altaa zha: ―¿Cho tak tsow gan yalnaban, os tata nake? ");
INSERT INTO zaoNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Tsa mwii Jesús lo re zha ne nzhab Jesús: ―Lo re men yezlyu ree gagte, per lee lo Diox reta kuu tak. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tsa lee Pey nzhab lo Jesús: ―Wii lee re nee. Mlaa nee reta kuu nap nee ne mndeke nee ditsa. ¿Kwan tsow nee gan tsa? ");
INSERT INTO zaoNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Lee Jesús mkab ne nzhab: ―Wlipaa na nin lo goo, leettsa tsin wiz kuu lee reta kwaa gak kuu kub, tsa lee na Kuu Mzin Ngon Men, tobʼn lo asi chaan yalnabee, ta kwathoz nzhol na ne nabeen, noga re goo kuu ndeke ditsʼn, tob lo thib asi chaan yalnabee, tsa naab goo kwent lo re tsiibchop net raz kuu nak zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ne loka cho mlaa liz, wets, btan, xut, xnaa, tsaal, zhiinn, yu, par tsow rtsin na, kwaro kuu wen kayaa zha lo Diox ne kayaa zha yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kwaro re zha kuu nataak nal, re zhaʼa gak zha kuu nataagt, ne lee re zha kuu nataagt nal, re zhaʼa gak zha nataak. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Lee nal leen ta thib kwent lo goo, tsa ne goo xomod nabee Diox. Leey nak taxal thib mbyi kuu nap thib fink. Til mroo zha ngwa zha lo xbi ngwakwaan zha mos ke rtsin zha, par thop ub. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ne myaan zha diiz kon re mos zha, kix zha lo kadta mos loka kuu nzhax nkaa thib zha thib wiz. Tsa mtaal zha re mos nda tsiin lo yu zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ne or ndaʼa or lee zha kuu nak chaan fink mroo ngwakwaan tedib net mos, ne mwii zha lee chop tson zha nalath nzi lo xbi. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tsa nzhab zha lo re zhaʼa: “Gwa goo ke goo tsiin fink da, ne yizhʼn kuu nzhax nkaa thib zha thib wiz lo goo”. Tsa nda re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ne lee zha kuu nak chaan fink, mroo ngwa lo xbi tedib welt teeka ndrol wiz, ne noga mroo zha, or ndethoʼa wiz ngwakwaan zha mas mos, ne nzhab zha kix zha kuu nzhax nkaa thib zha thib wiz. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ne telutta ndob wiz mre zha ngwa zha lo xbi tedib welt ne mzal zha tedib net zha, ne nzhab zha lo re zhaʼa: “¿Chebee tbaata nzi goo tree dita wiz ne nket goo tsiin?” ");
INSERT INTO zaoNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tsa lee re zha mkab ne nzhab: “Nket nee tsiin, tak yent cho zha ne lo nee ke nee rtsin zha”. Tsa lee zha kuu nak chaan fink nzhab lo re zha: “Gwa goo ke goo tsiin fink da, ne yizhʼn kuu nzhax nkaa thib zha thib wiz lo goo, ne nda re zha”. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Leettsa mziy yezlyu, lee zha kuu nak chaan finka, nzhab lo zha kuu nabee lo re zha kuu nke tsiin: “Brez re zha kuu nke tsiin ne bdix lo zha. Btelo kon re zha kuu mzin bluz, tsaraa kon re zha kuu mzin ner.” ");
INSERT INTO zaoNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tsa mbig re zha kuu mndelo mke tsiin or mziy yezlyu, ne lo kadta thib zha ngozh kuu ntsow thib zha gan thib wiz. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tsaraa mndelo zha mdix zha lo re zha kuu mndaab ner, ne mnda leettsoo re zha kuu mndaab ner, masraa gax kaa zha nake re zha kuu mndaab nda or; per noga zha mkaa kuu nzhax nkaa thib zha thib wiz. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Leettsa ngwalo mdix zha lo re zha, tsa mndelo re zha kuu mndaab ner mbyodiz kon zha kuu nak chaan fink. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ne nzhab re zha: “Re zha kuu mzin bluz, thibka or mke zha tsiin; ne lee re nee mke tsiin dita wiz, ne kwathoz mzhakti nee lo bee ne yewalka mdizha mkaa re nee”. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Per lee zha kuu nak chaan fink nzhab lo re zha: “Amig, neeka thib kuu went ngetsowtʼn lo goo. ¿Chu myaantaa diiz yizhʼn kaa goo kuu nzhax nkaa thib zha thib wiz? ");
INSERT INTO zaoNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kona wen bloo goo leettsoo goo kon kuu ngox lo goo ne tyee goo, tak os leen nlazʼn yizhʼn yewalka lo goo kon re zha kuu mndaab nda or, ");
INSERT INTO zaoNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿chu ndoblotʼn tsowʼn kuu nlazʼn kon temi da? ¿O chu nayii goo ne goo na, tak wen nakʼn?” ");
INSERT INTO zaoNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kona lee re zha kuu bluz gak zha ner, ne lee re zha ner gak zha bluz. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Bluz lee Jesús ndoʼa net ndya yez Jerusalén, tsa zhaata ndano Jesús re tsiibchop zha kuu ngeteed lo Jesús, ne nzhab Jesús lo re zha: ");
INSERT INTO zaoNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Lee nal neʼa goo, leeʼaa nda Jerusalén ta taa zha na, Kuu Mzin Ngok Men, lo re ngwleyy kuu nabee lo re ngwleyy ne lo re maestr kuu nloo xkiiz Diox, ne naab re zha kwent lon ne gab re zha ndoblo gathʼn. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tsa taa zha na lo re zha kuu nagt zha Israel, zhizno zha na ne yeloʼa kin zha na, tsa kee zha na lo kruz. Per leettsa tsaal tson wiz lee na roban. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tsa mbig tsaal Zebedeo lo Jesús, kon rop xganne kuu nak Santiag ne Juan, mtobxub ngot, ne mnaab ngot thib yalwen lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Tsa lee Jesús mnaabdiz lo ngot ne nzhab: ―¿Kwan nlaaza? Tsa lee ngot nzhab: ―Leettsa nabeeʼa, nlazʼn lee thib xgann na tob lad ban loʼa lee tedib zha tob lad beg loʼa, ta kwathoz nataak. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Lee Jesús mkab ne nzhab lo re zha: ―Neeka net goo naa kwan naab goo. ¿Chu texek goo rid goo yalti kuu riidʼn? Lee rop zha nzhab: ―Texek nee. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Lee Jesús nzhab: ―Wli, lee goo rid yalti taxal rid nay; per gagt tsowʼn tobʼn goo lad ban ne lad beg lon, tak nagt na kuu taa kona. Sinke Xutʼn taa kona lo re zha kuu naka diiz kayaay. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Leettsa mbin tedib tsii zha kuu ngeteed lo Jesús kona, tsa mnayii zha mne Juan rop Santiag. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kona mrez Jesús re zha, ne nzhab Jesús lo re zha: ―Wen ne goo lee re zha kuu nabee lo yezlyu ree, kwathoz nabee zha lo re zha kuu nzi lo zha, ne tataka ntsow re zha kuu nataak, kwathoz nabee zha lo re zha zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Lee lo re goo gagte tata, zhaa gake. Loka cho zha kuu nlaaz gak zha kuu mas nataak lo goo, zhaʼa ndoblo lortsin lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ne loka cho nlaaz nabee lo re goo, ndoblo gak mos kuu tsow tsiin lo re goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Leeka tata lee na, Kuu Mzin Ngok Men, ndyaltʼn tsa lortsin re men lon, sinke leen ndyal lortsin lo re men, ne gathʼn, tsa telaan naroob men lo yalguth kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Leettsa lee Jesús kon re zha kuu ngeteed lo Jesús ndaroo roo yez Jericó, kwathoz men mndeke dits re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ne tya lee chop syeg ndob roo net; ne leettsa mbin rop syeg lee Jesús nderid, tsa dib gan rop syeg, nzhab rop syeg: ―Zha Nabee, Xgann rey David, blat leettsooʼa neʼa nee ne btegwe nee. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tsa lee re men mnayii lo rop syeg, tsa tow roo rop syeg, per lee rop syeg masraa mrez ne nzhab: ―Zha Nabee, Xgann rey David, blat leettsooʼa neʼa nee. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tsa lee Jesús mlet, ne mrez Jesús rop syeg, ne nzhab Jesús lo rop syeg: ―¿Kwan nlaaz goo tsowʼn lo goo? ");
INSERT INTO zaoNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tsa lee rop syeg mkab ne nzhab: ―Zha Nabee, nlaaz nee yeni lo nee. ");
INSERT INTO zaoNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tsa mlat leettsoo Jesús mne rop zhaʼa, ne mdiinn Jesús ngutlo rop zha. Ne oraaka mwii rop zha, ne mndeke zha dits Jesús nda zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Leettsa lee Jesús ndetsin gaxa yez Jerusalén, tsa mzin Jesús yez Betfagé kuu nzi gaxta yii Olib, tsa mtaal Jesús chop zha kuu ngeteed lo Jesús ya yeza, ");
INSERT INTO zaoNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ne nzhab Jesús lo zha: ―Gwa goo yez kuu nzi baa. Tya yetsal goo thib burr kuu ndekedoo rop zhiinn. Xak goo maa ne yaadno goo maa. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ne os cho zha kwan ne lo goo, gab goo lo zha: “Zha Nabee ndeche maa, ne tsaraa yaadtaan zha rop maa”. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Koree ngok, tsa mrolo re kuu nzhab profet kuu ngoo ndala, leettsa nzhab zha: ");
INSERT INTO zaoNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Guz goo lo re zha yez Jerusalén: “Wii goo, lee rey goo ndyaad lo goo, zha kuu nadoo nak, ndob dits thib burr ndyaad, zhiinn thib maa kuu nzhee yoo”. Zac. 9:9 ");
INSERT INTO zaoNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tsa lee rop zha kuu ngeteed lo Jesús, ngwa zha ne mtsow zha taxal nzhab Jesús lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ne mndeno zha rop zhiinn burr, tsa mxoob zha xab zha dits burr yeena, ne mndob Jesús dits maa. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ne kwathoz men nzi, cho zha ngix xabe net, ne cho zha nga baat ne ngix zhay net. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ne lee re zha kuu ndener ne re zha kuu ndeke, nex mbez zha: ―¡Golaa lo Zha kuu ndyaad Nabee lo raz chaan rey David! ¡Aka wen nak zha kuu ndyaad kon yalnabee chaan Zha Nabee! ¡Golaa lo Diox kuu ndob yibaa! ");
INSERT INTO zaoNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ne leettsa mndaab Jesús yez Jerusalén, reta zha yeza mgab ndata leettsoo zha, ne mnaabdiz zha lo altaa zha, ne mbez zha: ―¿Cho nak zha ree? ");
INSERT INTO zaoNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ne reta men mbez: ―Zha ree nak Jesús, profet zha yez Nazaret kuu nzi yezlyu Galilea. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ne leettsa mndaab Jesús lee roo gwodoo, tsa mloo Jesús re zha kuu nzi ntho ne re zha kuu ndi tya. Ne mlobi Jesús re mes chaan re zha kuu ntsiil temi, ne mlobi Jesús re mes chaan re zha kuu ntho palom. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ne nzhab Jesús: ―Lee lo xkeets Diox nzhab: “Lee lizʼn nak yuu ta ndediz re men lon”, Is. 56:7; Jer. 7:11 ne noga tedib ta nzhab: Per lee re goo mtsowe taxal liz wann. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ne lee roo gwodoo mbig re zha syeg ne re zha renk lo Jesús, ne mtegwe Jesús re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tsa lee re ngwleyy kuu nabee lo re ngwleyy ne re maestr kuu nloo xkiiz Diox, mwii zha re kuu thoz kuu mtsow Jesús, ne mbin zha lee re ndyeen bzhizh mbez: “¡Golaa lo Zha Kuu Mtaal Diox Yaad Nabee, zha kuu ndyaad lo raz chaan rey David!”, tsa kwathoz mnayii re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ne nzhab zha lo Jesús: ―¿Chu nzhona kuu mbez re ndyeen baa? Tsa lee Jesús mkab ne nzhab: ―Ah, nzhon nay. ¿Per chu ter lab goo lo xkeets Diox ta nzhab koree: “Mtsowa lee re ndyeen bzhizh ne re mbetdoo gol loʼa”? Sal. 8:2 ");
INSERT INTO zaoNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tsa mlaa Jesús re zha ne nda Jesús yez Betania, ne tya mlet Jesús yaala. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ne til tedib wiza leettsa mre Jesús yez Jerusalén tedib welt, tsa mlann Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tsa mwii Jesús lee thib ya ig ndob gax roo net, tsa mbig Jesús lo ya, tsa naa chu ndab xle lo ya, per mzalt Jesús ig lo ya beeta la ndab lo ya. Kona nzhab Jesús lo ya: ―Neeka mas taat raa lu xle. Ne oraaka lee ya mbiz. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Leettsa mwii re zha kuu ngeteed lo Jesús kona, kwathoz mzegey leettsoo zha ne nzhab zha: ―¡Xomod oraaka mbiz ya ig! ");
INSERT INTO zaoNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Lee Jesús mkab ne nzhab: ―Wlipaa na nin lo goo, os lee thib goo nyelaaz Diox ne gagt chop xgab goo, tak tsow goo koree ne asta tak gab goo lo yii ree: “Beche nzhee ne bla leen nitdoo”, ne leey gak. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Reta kuu naab goo lo Diox, os nyelaaz goo lee goo kayaay, tekayaa gooy. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tsa lee Jesús mndaab lee roo gwodoo, ne mndelo Jesús mloo lo re men, tsa lee re ngwleyy kuu nabee lo re ngwleyy, ne re zha gol kuu nabee lo re zha Israel, mbig lo Jesús, ne mnaabdiz zha lo Jesús, ne nzhab zha: ―¿Cho mndaa diiz ntsowa koree? ¿Ne cho mndaa yalnabee ntsow luy? ");
INSERT INTO zaoNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús mkab ne nzhab: ―Noga na naabdizʼn thib kwaa lo goo. Os lee re goo kab goo yalnaabdiz da, tsa nin lo goo naa cho mndaa diiz ntsowʼn ree koree. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Cho mtaal Juan kuu mtsowleyy re men? ¿Chu Diox mtaal zha o re men mtaal zha? ¡Kab goo lon nal! Tsa lee re zha mndelo mbyodiz kon re altaa zha, ne nzhab zha: ―Os leeʼaa gabaa: “Diox mtaal zha”, tsa ne zha loʼaa: “¿Chebee ngwalaazt goo kuu mni zha?” ");
INSERT INTO zaoNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ne os leeʼaa gabaa: “Re men mtaal zha”, tsa yii re men ne re menaa, tak ne re men lee Juan nak thib profet chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tsa mkab re zha lo Jesús ne nzhab zha: ―Net nee cho mtaal Juan. Tsa lee Jesús mkab ne nzhab: ―Neeka na nitʼn lo goo naa cho mndaa yalnabee lon ntsowʼn re koree. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Tsa lee Jesús nzhab lo re men: ―Nal leen ta thib kwent lo goo. Thib mbyi mkeno chop xgann, ne nzhab mbyi lo xgann mbyi kuu ner: “Gwa keʼa tsiin naltseree”. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ne lee xgann mbyi mkab lo xute ne nzhab: “Yatʼn”. Per bluz mtsee zha xgab zha ne ngwa zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tsa nzhab mbyi lo tedib xgann mbyi, leeka taxal nzhab mbyi lo xgann mbyi kuu nera. Ne lee zhaʼa nzhab: “Mbay, nal ndan”. Per ngwat zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Lo rop zhaʼa, ¿cho mbin diiz lo xute? ―Zha nera ―nzhab re zha. Tsa lee Jesús nzhab: ―Wlipaa na nin lo goo, re zha kuu ntsow kobral temi chaan yezlyu kuu nzhax lo zha kuu nabee Roma, ne re ngot kuu ntho kwerp, ne tedib net re zha kuu ndaa falt, re zhaʼa tab ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tak lee Juan myaad mloo lo goo, naa xomod ndoblo nali ban goo, ne lee goo ngwalaazt goo kuu mni Juan. Per lee re zha kuu ntsow kobral temi chaan yezlyu kuu nzhax lo zha kuu nabee Roma, ne re ngot kuu ntho kwerp, re zhaʼa ngwalaaz kuu nzhab Juan, ne lee re goo tegal mwii goo kuu nzhab Juan, per neeka mlaat goo mod went kuu nak goo, ne neeka ngwalaazt goo kuu mni Juan. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Kenza goo tedib kwent nanzee kuu nin lo goo: Thib welt lee thib mbyi mkeno thib fink, ne mto zha luts ub dita lo yu zha. Ne mtow zha dita fink kon btsin ke. Ne mdexkwaa zha thib ta tii zha ub, noga mdexkwaa zha thib yuu naro kuu ya ndab, ta loo dita lo yu zha lo zha. Ne mndaa zha yu zha kompani lo tedib net zha, ne mroo zha nda zha tith. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Leettsa ngozhoob wiz kuu dop ub, tsa mtaal zha chop tson mos zha, ya lo zha kuu nke tsiin lo yu zha, tsa tsow rol zha ub kuu ndoblo zha kaa zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Per lee re zha kuu nzhann lo yu zha, mzhen re mos zha, ne mdin re zha thib mos, lee tedib mos mbeth zha ne lee tedib mos mkee zha ke yeke. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tsa lee zha kuu nak chaan fink, mtaal tedib net mos lo re zha kuu nke tsiin lo yu zha; per lee re zha kuu nzhann lo yu zha, leeka taxal mtsow re zha lo re mos kuu ner, tataka mtsow zha lo tedib net mos. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Bluz mtaal zha xgann zha, tak mtsow zha xgab, nzhab zha: “Lo xgann na si ton re zha diz”. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Per leettsa mwii re zha kuu nzhann lo yu zha lee xgann zha ndyaad, tsa nzhab zha lo re altaa zha: “Zha ree kayaa reta chaan xute, leettsa lee xut zha gath. Nal kuthaa zha, tsa yaan re chaan zha loʼaa.” ");
INSERT INTO zaoNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tsa mzhen re zha xgann zha ne mloo zha xgann zha thib lad, ta nzhannt zha ne mbeth zha zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’Lee nal leettsa yaad zha kuu nak chaan fink, ¿kwan ntsow goo xgab, kwan tsow zha kon re zha kuu nzhann lo yu zha? ");
INSERT INTO zaoNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Lee re zha mkab ne nzhab: ―Kuth zha re zhaʼa, ne latta leettsoo zha ne zha re zha wenta, ne taa zha fink zha lo tedib net zha, tsa ke zha tsiina, ne tsa taa re zhaʼa kuu ndoblo zha kaa zha leettsa gak yalgonn. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tsa lee Jesús nzhab lo re zha: ―¿Chu ter lab goo lo xkeets Diox ta tenzhee nzhab: Lee ke kuu mlobi re zha kuu nta yuu thib lad, leey nak thib ke kuu mas nataak kuu ndob skin yuu? Lee Diox kuu nak Zha Nabee loʼaa mtsow koree; ne mzegey leettsooʼaa neʼaa koree. Sal. 118:22-23 ");
INSERT INTO zaoNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kona nin lo goo: Leettsoo goo nak diiz nabee Diox, per lee nal yiibe lo goo ne kayaa tedib net re men tedib yeze, re mena si tetsow kuu nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ne lee zha kuu ral ke ree nii tats zha; ne os lee ke ree la dits thib zha, dita tsowe zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tsa lee re ngwleyy kuu nabee lo re ngwleyy ne re fariseo, myeen zha lee kwent nanzee ree nloo re kuu ntsow re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kona leeka ora ngwalaaz re zha gaten zha Jesús, per nzeb re zha ne zha re men, tak lee re men nyelaaz lee Jesús nak profet chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Tsa mnika Jesús lo re men kon diiz nanzee, ne nzhab Jesús: ");
INSERT INTO zaoNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Nal tan tedib kwent. Leettsa nabee Diox leettsoo men, leey nak taxal thib rey kuu mtsow thib ani leettsa mtseya xgann rey. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tsa mtaal rey re mos ya yachez re zha kuu naka diiz ya lo ani, ne lee re zhaʼa mzhyalt gaya lo ani. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mbre rey mtaal tedib net mos, ne nzhab rey lo re mos: “Gwa goo ne guz lo re zha kuu naka diiz yaad lo ani, tsa yaad zha. Ne gab goo lo zha, mdexkwaaʼa na kuu wu re zha kuu yaad lo ani, mbetha na ngon da ne re maa da kuu mas natsi, ne reta kuu nziʼa.” ");
INSERT INTO zaoNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Per lee re zha kuu naka diiz yaad lo ani mzhyalt gayaad lo ani. Thib zha ndatwii lo yu, lee tedib zha nda lo negos, ");
INSERT INTO zaoNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ne lee tedib net zha mzhen re mos rey, tsa mteti zha mos, ne mbeth zha re mos. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ne or mbin rey kona, kwathoz mnayii rey ne mtaal rey re soldad rey ngwa mbeth re zha kuu nzhuth mena, ne mteyy rey laz re zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tsa nzhab rey lo re mos rey: “Reta kuu nziʼa par yo fandan, per lee re zha kuu naka diiz yaad, ndoblot zha yaad zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Gwa goo re net to ne guz gooy lo reta zha kuu tsaal goo, tsa yaad zha lo fandan.” ");
INSERT INTO zaoNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tsa lee re mos mroo ngwa re neta, ne mrez mos reta zha kuu mwii mos, zha wen ne zha went; tsa lee yuu ta yo fandan mze nzo re men. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Tsa lee rey mndaab leen yuu, ne mwii rey lo re zha kuu mrez rey yaad fandan, tsa mwii rey thib mbyi kuu ndob tya, kuu nogt lar kuu nzhok re zha kuu nya lo fandan. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tsa nzhab rey lo zhaʼa: “Amig, ¿xomod mndaaba nzhee ne nogta lar kuu nzhok re zha kuu nya fandan?” Ne lee zhaʼa mkabt neeka thib lan diiz. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tsa nzhab rey lo re mos rey: “Bliib goo nii zha ne yaa zha, ne bloo goo zha lee ta kwathoz nakow na, tya gonn zha ne tub zha keley zha”. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tak kwathoz zha mrez Diox per lut zha mli Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tsa ndya re fariseo, ne ngwa re zha mndediz zha ne myaan zha diiz, naa xomod tsow zha gab Jesús thib kuu went, par tak keki zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tsa mtaal zha chop tson re zha zha kuu ngeteed lo zha, ne chop tson zha Herodes, tsa lee re zhaʼa nzhab: ―Maestr, ne nee wli kuu niʼa, ne nali nlooʼa xnet Diox lo re men taxal ndobloy, yewal niʼa lo reta men ne ngwiita chu nataak zha o nataagt zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kona lu ne, kwan ndoblo nee tsow nee: ¿Chu ndoblo kix nee lo zha kuu ntsow kobral temi chaan yezlyu, kuu nzhax lo zha Roma, o ndoblot nee kix neey? ");
INSERT INTO zaoNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Per lee Jesús neʼa went nak xgab re zha, kona nzhab Jesús lo re zha: ―¡Zha nkedi nak goo, zhaa kuu mbez ne zhaa kuu ntsow goo, nlaaz goo naabdiz goo kuu wli per went nak goo! ¿Chebee tabaa mod nkwaan goo ten goo na? ");
INSERT INTO zaoNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Bloo goo thib temi kuu ngix goo lon. Tsa mloo zha thib temi lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ne or mwii Jesús loy, tsa mnaabdiz Jesús lo re zha: ―¿Cho lo ne cho le nke loy? ");
INSERT INTO zaoNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Lee re zha mkab ne nzhab: ―Chaan César kuu nabee Roma. Tsa nzhab Jesús lo re zha: ―Taa goo lo César kuu ndoblo César, ne taa goo lo Diox kuu ndoblo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Leettsa mbin re zha koree, kwathoz mzegey leettsoo re zha xa mkab Jesús, tsa mlaa re zha Jesús ne ndya zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Leeka wiza lee chop tson zha saduceo, re zha kuu nyelaazt lee re zha nguth roban, mnaabdiz lo Jesús ne nzhab: ");
INSERT INTO zaoNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Maestr, lee Moisés mkee lo xkeets Diox: “Os lee thib mbyi kuu mtseya gath, ne mkenot mbyi neeka thib zhiinn mbyi, tsa lee wets mbyi ndoblo tseya kon ngot mbyi, tsa keno wets mbyi thib zhiinn mbyi kuu ngutha, tsa gak zhiinn wets mbyi taxal raz chaan mbyi kuu ngutha”. Dt. 25:5 ");
INSERT INTO zaoNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Thib welt ngoo gaz wets zha; lee zha ner mtseya ne nguth, ne mkenot zha neeka thib zhiinn zha, tsa lee tedib wets zha mtseya kon ngota. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Leeka tata mzhaak zhaʼa, ne tataka mzhaak zha myon; ne tataka mzhaak reta gazta wets zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Bluz leettsa ngwalo nguth re zha, noga ngot nguth. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kona os lee re men roban, ¿cho gak tsaal ngota, tak re gazta wets zha mtseya kon ngota? ");
INSERT INTO zaoNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús mkab lo re zha ne nzhab: ―¡Thitanax ngobeet goo! Nyent goo re kuu nke lo ley chaan Moisés, ne neeka nlebeet goo yalney chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Leettsa lee re zha nguth roban, neeka mbyi ne neeka ngot tseyat raa, sinke lee re zha gak taxal re mandad chaan Diox kuu nzo yibaa. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Per leen ni lo goo, wlipaa lee re zha nguth teroban. ¿Chu ter lab goo lo xkeets Diox, ta leeka Diox nzhab kwent chaan re zha nguth: ");
INSERT INTO zaoNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Na nak Diox chaan Abraham, Diox chaan Isaac ne Diox chaan Kob”? Ex. 3:6 ¡Lee Diox nagt Diox chaan re zha nguth, lee Diox nak Diox chaan re zha naban! ");
INSERT INTO zaoNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Leettsa mbin re zha koree kwathoz mzegey leettsoo re zha xa mloo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ne leettsa mbin re fariseo lee Jesús mtow roo re zha saduceo, tsa mkaltaa re fariseo. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tsa lee thib zha kuu nak maestr kuu nloo ley chaan Moisés, mnaabdiz thib kwaa lo Jesús, tsa naa chu tab Jesús thib kuu ndoblot, ne nzhab zha: ");
INSERT INTO zaoNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestr, ¿cho diiz kuu mas nataak lo ley chaan Moisés? ");
INSERT INTO zaoNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tsa lee Jesús nzhab lo zha: ―“Ke leettsoo Diox kuu nabee loʼa kon dib ndroo leettsooʼa, kon dib yalnabana, ne kon dib xgaba”. Dt. 6:5 ");
INSERT INTO zaoNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Koree nak kuu ner ne kuu mas nataak. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ne lee tedibe mer lalka nak: “Ndoblo ke leettsooʼa tabena taxal nke leettsooʼa lu”. Lv. 19:18 ");
INSERT INTO zaoNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ne os leeʼa ntsowa ropta koree, ngetsowa reta kuu nzhab lo ley chaan Moisés ne reta kuu nzhab re profet. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ne or lee re fariseo bee nzika, ");
INSERT INTO zaoNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","tsa mnaabdiz Jesús lo re zha, ne nzhab Jesús: ―¿Kwaan ntsow goo xgab kwent chaan Crist Kuu Mtaal Diox Nabee? ¿Cho lo raz ndyaad Crist Kuu Mtaal Diox Nabee? Ne lee re zha mkab ne nzhab: ―Lo raz David ndyaad zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tsa lee Jesús nzhab: ―Os tata nake, xomod leettsa mban rey David ndala lee Mbi Nayon mtsow lee David, nzhab Zha Nabee lo Crist, tenzhee mkee David: ");
INSERT INTO zaoNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Lee Diox kuu nak Zha Nabee, nzhab lo Zha Nabee lon: “Btob lad ban lon, asta tsowʼn leeʼa gak nabee lo reta zha kuu nayii neʼa, ne tobxub zha loʼa”. Sal. 110:1 ");
INSERT INTO zaoNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Xomod tak gak Crist xgann David, os Zha Nabee nzhab David lo Crist? ");
INSERT INTO zaoNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ne neeka thib zha ngogt gakab thib lan diiz lo Jesús. Ne desde tyatha, yent raa cho mye leettsoo ganaabdiz raa lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Bluz lee Jesús nzhab lo re men, ne lo re zha kuu ngeteed lo Jesús: ");
INSERT INTO zaoNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Lee re maestr kuu nloo xkiiz Diox ne re fariseo, ndak zha beeta lee zha nap yalnabee, tak ne zha naa xomod nak ley chaan Moisés. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kona bin goo diiz lo zha ne btsow goo re kuu ni zha. Per tsowt goo taxal ntsow zha, tak zhaa kuu mbez zha ne zhaa kuu ntsow zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ntsib zha re kuu ne dits re men, kuu neeka gagt gwe men, ne lee zha neeka kwen yaa zha ndiinnt zhay. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Reta kuu ntsow zha, ntsow zhay tsa wen wii re men lo zha. Nyow leettsoo zha ke lut xkiiz Diox yeklo zha ne yen yaa zha. Nyow leettsoo zha ntsow nol zha lozh xab zha, tsa wii re men zha taxal zha ro. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nyow leettsoo zha tob zha ta mas nataak leettsa nyoo ani, ne ta mas nataak ta nkaltaaʼaa nteedaa xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ne nyow leettsoo zha kiits re men yek men lo zha, or ni re men “diox” lo zha lo xbi, ne kwathoz wen nzo leettsoo zha nkiits re men yek men lo zha ni re men “maestr” lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Per lee goo, ndoblot tsow goo tsa ni re men maestr lo goo, tak thibka maestr nap goo ne wets goo re goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ne nit goo xut goo lo neeka thib zha yezlyu, tak thibka xut goo kuu ndob yibaa nap goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ne ndoblot ni re men lo goo, “lee goo nak zha kuu nloo xkiiz Diox” tak beeta na Crist Kuu Mtaal Diox Nabee, nak kuu nloo lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tak lee zha kuu mas nataak lo re goo, zhaʼa ndoblo lortsin lo re goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tak lee zha kuu leeka lee ntsow naro, tetsin thib wiz lee zhaʼa thoy; ne lee re zha kuu nadoo nak, tetsin thib wiz lee zhaʼa gak zha nataak. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Aka kwathoz nati rid goo maestr kuu nloo xkiiz Diox, ne re goo zha fariseo! ¡Zha nkedi nak goo, zhaa kuu mbez ne zhaa kuu ntsow goo! Kuu ntsow goo nak taxal thib zha kuu ntow roo yuu lo tedib zha, tsa gagt tab zha. Nlaat goo nabee Diox leettsoo re men, ne neeka goo nlaazt goo nabee Diox leettsoo goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Aka kwathoz nati rid goo maestr kuu nloo xkiiz Diox ne goo zha fariseo! ¡Zha nkedi nak goo, zhaa kuu mbez ne zhaa kuu ntsow goo! Tak nkib goo liz re ngot byud, ne par kaats goo kuu ntsow goo, nol ndediz goo lo Diox. Kona mas nathoz yalti kuu rid re goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Aka kwathoz nati rid goo maestr kuu nloo xkiiz Diox ne goo fariseo! ¡Zha nkedi nak goo, zhaa kuu mbez goo ne zhaa kuu ntsow goo! Ndiy goo dita lo yezlyu ne ndriid goo lo nitdoo, nkwaan goo re zha kuu nagt zha Israel, tsa teteed goo zha re leyy goo, ne leettsa nyelo nteteed goo zha, ntsow goo nzhak zha chop welt mas nakap nake goo kuu ndya gabil. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Aka kwathoz nati rid goo, zha kuu nlaaz loo net lo tedib syeg taxal goo! Tak mbez goo: “Os lee thib zha ntselo kruz por gwodoo, par tsow zha thib trat, yent pa nataak kona. Per os lee zha ntselo zha kruz por or kuu nzo leen gwodoo, konasi nataak ne ndoblo tsow zha kuu mtselo zha kruz.” ");
INSERT INTO zaoNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Zha bxen ne zha syeg! Mas nataak gwodoo nake or, tak por gwodoo nayon or kuu nzo leen gwodoo. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ne noga mbez goo: “Os cho zha ntselo kruz por bkoog par tsow zha thib trat, nataagte. Per os lee zha ntselo zha kruz por gon kuu nzib lo bkoog, konasi nataak ne ndoblo tsow zha kuu mtselo kruz zha.” ");
INSERT INTO zaoNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Zha bxen ne zha syeg! Mas nataak bkoog, tak por bkoog nayon re gon. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kona lee zha kuu ntselo kruz por bkoog, ntselot zha beeta por bkoog, noga ntselo zha por reta kuu nzib lo bkoog. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ne lee zha kuu ntselo kruz por gwodoo chaan Diox, ntselot zha beeta por gwodoo, noga ntselo zha kruz por Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Leeka tata, lee zha kuu ntselo kruz por yibaa ta ndob Diox, ntseloga zha por ta ndob Diox, ne por Diox, kona ndoblo tsow zha kuu nzhab zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Aka kwathoz nati rid goo maestr kuu nloo xkiiz Diox ne goo zha fariseo! ¡Zha nkedi nak goo, zhaa kuu mbez goo ne zhaa kuu ntsow goo! Tak ndaa goo tsii part re chaan goo gon lo Diox, ne asta re bthyon xtil, re komin ne relota yizh kwaan kuu nyetle komid. Per nzhont goo diiz re diiz kuu mas nataak lo xkiiz Diox, kuu nak: Tsow goo re kuu nali lo re men, blat leettsoo goo ne goo taben goo, ne btsow goo kuu ni goo. Re koree nak kuu ndoblo tsow goo, ne btsowka goo tedib net re kona. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Goo nak taxal zha syeg kuu nloo net lo re zha kuu nak taxal syeg; ngoo goo mzhuuz leen nit kuu nzhuu goo, per nyeent goo ngab goo dib kamey! ");
INSERT INTO zaoNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Aka kwathoz nati rid goo maestr kuu nloo xkiiz Diox ne re goo zha fariseo! ¡Zha nkedi nak goo, zhaa kuu mbez goo ne zhaa kuu ntsow goo! Tak wen wen nteech goo dits yann ne dits bas, ne lee leen leettsoo goo tseta nzo re kuu went: yalwann ne yaltablaaz. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Fariseo syeg! Ner blaa goo mod went kuu nak goo, kona nak taxal ntembi goo leen bas ne leen yann, tsa noga ditse gak nambi. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Aka kwathoz nati rid goo maestr kuu nloo xkiiz Diox ne re goo zha fariseo! ¡Zha nkedi nak goo, zhaa kuu mbez ne zhaa kuu ntsow goo! Goo nak taxal thib roo baa kuu naguz na dits, per lee leene tseta nzo tsidth re zha nguth, ne nzo re kuu nambit. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tbaa nak goo; kwathoz wen ntsow goo leettsa ngwii re men lo goo, per lee leen leettsoo goo tseta nzo yalrub ne re kuu kwathoz went. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Aka kwathoz nati rid goo maestr kuu nloo xkiiz Diox ne re goo zha fariseo! ¡Zha nkedi nak goo, zhaa kuu mbez goo ne zhaa kuu ntsow goo! Tak ndexkwaa goo almitr roo baa chaan re profet kuu ngoo ndala, ne re roo baa chaan re zha kuu nali, re zha kuu mtsow kuu wen, ");
INSERT INTO zaoNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ne ni goo: “Os leeʼaa gabanaa, leettsa mban re teyaa zha ndala, gatsowtaa ayud re teyaa leettsa mbeth re teyaa re profet kuu ngoo ndala, ne tataga ntsow goo”. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ne kon kuu mbez goo, leeka goo nyeen goo lee re goo nak zha raz chaan re zha kuu mbeth re profet. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Baa btelo btsow goo goo re kuu mndelo re tey goo zha ndala. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Goo nak zha nakap nak taxal mbeel! ¿Xomod laa goo lo yalti, goo kuu ndya gabil? ");
INSERT INTO zaoNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kona lee na taal profet lo goo, re zha kuu nap yalnzhaak ne re maestr. Ne lee re goo kuth thib re zhaʼa, ne kee goo zha lo kruz, ne lee techop tson zha kin goo, ta nkaltaa reʼaa nteedaa xkiiz Diox, ne reke goo dits zha thib yez ne tedib yez. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kona goo ndab ren chaan re zha nali, re zha kuu nguth ndala. Ren chaan Abel kuu mbeth zha ner, ne asta ren chaan Zacarí xgann Berequías, kuu mbeth zha xtow bkoog ne gwodoo. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Wlipaa na nin lo goo, lee re men tyemp ree ndab re falt kuu mtsow re zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Zha yez Jerusalén, zha yez Jerusalén, goo kuu nzhuth ne nkee ke yek re profet, re Zha Kuu Mtaal Diox Nabee lo goo! Tyen welt ngwalazʼn gakaltaan re zhiinn goo, taxal nkaltaa ngid re zhiinn ngid xann xiil ngid, per mzhyalt goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Wii goo, lee liz goo yaan wan. ");
INSERT INTO zaoNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ne leen ni lo goo, desde nalor wiit raa goo na, asta leettsa tsin wiz kuu bretabʼn, tsya gab goo: “¡Aka wen nak zha kuu ndyaad kon le Zha Nabee!” ");
INSERT INTO zaoNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Leettsa lee Jesús mroo lee roo gwodoo ndya, tsa lee re zha kuu ngeteed lo Jesús mbig lo Jesús, ne mloo zha re bla gwodoo lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tsa lee Jesús mkab ne nzhab: ―¿Chu nloo re koree lo goo? ¡Wlipaa na nin lo goo, neeka thib re ke ree yaante dits tedibe, reta koree lux! ");
INSERT INTO zaoNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ne nda re zha yek yii Olib, tya mndob Jesús, tsa lee re zha kuu ngeteed lo Jesús mbig lo Jesús, ne mnaabdiz zha lo thita Jesús ne nzhab zha: ―Nlaaz nee neʼa lo nee, ¿pol gak re koree ne cho seny loo leettsa yaada tedib welt, leettsa lux yezlyu? ");
INSERT INTO zaoNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tsa lee Jesús mkab ne nzhab: ―List gwatsin goo, tsa neeka thib zha kedit goo, ");
INSERT INTO zaoNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","tak kwathoz zha yaad ne: “Na mkayaa yalnabee lo Jesús”. Ne noga ne zha: “Na nak Crist Kuu Mtaal Diox Nabee”, ne kedi zha kwathoz men. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Per leettsa gon goo lee zhoo nzo nzhee ne baa na, ne gon goo tooraa zhoo, tsebt goo, tak tata ndoblo gake; per nagt re kona kuu lux yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Lee thib yez yo kon tedib yez, ne thib nación yo kon tedib nación, ne kwathoz ta la win ne gwin zho thoz. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Leettsa gak reta koree, penta telo yalti kuu rid men. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Tsa taa zha goo lo re zha kuu nak tsiin, par teti zha goo, kuth zha goo ne reta zha yii ne goo, tak nyelaaz goo na. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ne lee re wiza kwathoz zha laa na, ne yii zha ne zha thib zha ne tedib zha, ne kedi zha thib zha ne tedib zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kwathoz zha kuu wlit nak profet yaad ne: “Lee na nak profet Diox”, ne kedi zha kwathoz men. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ne tak kwaro yo kuu went, kona naroob zha ket raa leettsoo zha altaa zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Per lee zha kuu xek, asta yelo rid reta koree, zhaʼa tsow gan yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ne dita lo yezlyu taa zha kwent Diiz Chul, kwent chaan xomod Nabee Diox leettsoo re zha Diox, tsa reta men reta yez gone; tsaraa lee yezlyu lux. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Ne leettsa wii goo lee thib kuu kwathoz nakap kwib ta ndoblote kwibe, taxal nzhab profet Daniel zha ndala. (Loka cho nlab koree ndoblo zha yen koree.) ");
INSERT INTO zaoNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Tsa lee re zha yezlyu Judea ndoblo zhonn ne ya net yii. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ne lee zha kuu ndob yek yuu, ndoblot raa zha ya zha leen liz zha par koo zha thib chaan zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ne lee zha kuu ndo wan ndoblot raa bretab zha xit zha xab zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Aka kwathoz nati rid re ngot kuu nzo zhiinn wiza, ne re ngot kuu nap mbetdoo. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Naab goo lo Diox, tsa gagt re koree re mbee kuu kwathoz nla yig, ne neeka gagte wiz sabd. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Lee re wiza gak thib wiz kuu kwathoz rid re men yalti, kuu neeka mas ter yo desde leettsa terka texkwaa Diox yezlyu, ne neeka yot raay bluz. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ne os lee Zha Nabee gatsow nadopt re wiza, neeka thib zha laat lo yaltiʼa. Per mtsow nadop zhay, tak nke leettsoo zha re zha kuu mli zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Ne lee re wiza, os lee thib zha ne lo goo: “Wii goo, lee Crist Kuu Mtaal Diox Nabee ndo nzhee, o ne zha lee zha ndo baa”, yelaazt gooy, ");
INSERT INTO zaoNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","tak yaad re zha kuu kedi. Ne lee re zhaʼa ne: “Na nak Crist Kuu Mtaal Diox Nabee”, ne lee tedib net zha ne: “Na nak profet chaan Diox”, per wlit zhay. Ne tsow zha re kuu thoz par kedi zha re men, ne asta re zha kuu mli Diox kedi zha, os take lo zha, per gagt tsow zhay. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Lee nal niʼa na re koree lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kona os lee zha ne zha lo goo: “Gwa goo. Lee Crist ndo yubiz”, yat goo, ne os lee zha ne zha lo goo: “Lee Crist nzogaats nzhee”, yelaazt gooy. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tak leettsa yal na, Kuu Mzin Ngok Men, gake taxal bel bti kuu nkee xni ta nlen wiz ne nkee xni asta ta mbix wiz, tata yalʼn. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tak ta nax maa nguth, tya nkaltaa re ngol. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Leettsa yelo yezhoob wiz kuu rid reta zha yalti, tsa lee wiz ne mbee taat raa xni, ne lee re mbel rethin lobee ne lee re kuu nzo lobee zhiit. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tsa lee seny chaan Zha Kuu Mzin Ngok Men loo lobee ne looy lo reta men lo yezlyu ree. Ne re men reta raz lo yezlyu gonn zha, leettsa wii zha lee na yal xid xkow lobee. Ne wii zha lee na nabee kon kwathoz yalnabee ne yalʼn xid xni thoz. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tsa taalʼn re mandad da, ne dib gan zha kwez zha trompet, ora lee re mandad da kaltaa re zha kuu mlin dib naxta lo yezlyu, desde thib lad lo yezlyu ne asta tedib lad lo yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Bteed goo lo ya ig. Leettsa lee re zhite ndelo nla bzhits, ne ntsetab lay, tsa ne goo lee mbee beyi ndetsin gaxa. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Leeka tata, leettsa ne goo lee re koree ngeyak, tsa ne goo lee na, Kuu Mzin Ngok Men, mera bretabʼn. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Wlipaa na nin lo goo, reta koree gak. Tsaraa gath re men tyemp ree. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Lobee ne yezlyu telux, per lee xkizʼn ridt; leechay gake. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Neeka thib zha net polor tsin wiza, neeka re mandad chaan Diox nete, neeka na, Kuu Mzin Ngok Men nete. Beeta Xutʼn ney. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Leeka taxal ngok re wiz leettsa mban Noé, tataka gak leettsa bretab na, Kuu Mzin Ngok Men. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Re wiz kuu mban Noé, leettsa terka la yi thoz lo yezlyu ne asta wiz kuu lee Noé mndaab leen bark, lee re men nzi nzhuu ne nzhow ne ntseya ne ndaa zha yalntseya. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Per thitanax mtsowt zha xgab lee yi la luux zha, tsa lee yi mndelo mla, ne mluux nit re zha. Tataka gak leettsa yal na, Kuu Mzin Ngok Men. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ne wiza, lee chop mbyi ya wan, thib zha teno zha yibaa ne lee tedib zha yaan. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ne chop ngot ngetoo lo molin; thib ngot teno zha yibaa ne lee tedib ngot yaanka. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Kona thibka list gwatsin goo, tak net goo pol yalʼn par tenon goo, Na Zha Nabee lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Per ndoblo yen goo koree: Os lee thib zha kuu nak mndan thib yuu, ne zha polor la wann liz zha, tsa lowann wann chaan zha, gatta zha ne laat zha lowann wann chaan zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kona noga goo list gwatsin goo tsa tenon goo, tak lee na, Kuu Mzin Ngok Men, yalʼn wiz kuu ntsowt goo xgabe. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Cho nak mos kuu ngobee? Lee mos kuu ngobee nak mos kuu mtaan patron liz patron, tsa taa mos kuu wu tedib net re mos, or kuu ndoblo taa zhay. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kwathoz wen nda mos kuu ngetsow kuu mnabee patron mos, leettsa lee patron bretab. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Wlipaa na nin lo goo, lee patron taan mos tsa nabee mos lo reta kwaa nap patron. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Per os lee mos patron nak thib mos kuu ngobeet, ne tsow mos xgab: “Lee patron bretabt lijer”, ");
INSERT INTO zaoNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ne telo mos kin mos re mos patron, ne telo mos wu mos ne gu mos kon re zha kuu nke yalgwiy. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ne wiz kuu ndat leettsoo mos, ne or kuu ntsowt mos xgab lee patron tsin. ");
INSERT INTO zaoNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tsa kwathoz teti patron mos, ne taal patron mos ta nzo re zha nkedi, re zha kuu zhaa kuu mbez ne zhaa kuu ntsow, ne tya gonn mos ne tub mos keley mos. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Nal leen ta tedib kwent lo goo, tsa ne goo naa xomod nabee Diox leettsoo men. Leey nak taxal tsii mndyeen got, kuu mroo mzhen kandil, tsa kwet mndyeen kayaa mndyeen mbyi kuu tseya. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Gaay mndyeen ngobee list nzi ne lee tedib gaay mndyeen ngobeet. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Lee re mndyeen kuu ngobeet, mzhen mndyeen kandil mndyeen, per mbet mndyeen masraa aseyt par yo leen kandil mndyeen. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Per lee tedib gaay mndyeen kuu ngobee, mzhen mndyeen kandil mndyeen ne mbe mndyeen aseyt, par tse kandil mndyeen. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ne lee zha kuu tseya mzint lijer, tsa reta mndyeen mzhen mkaal ne mdat. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ne teeka ngulal yaal mbin re mndyeen thib bos kuu nzhab: “Lee zha kuu tseya ndyaada, broo goo kayaa goo zha”. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tsa lee re mndyeen ngwache ne mtexnet mndyeen kandil mndyeen. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tsa lee re gaay mndyeen kuu ngobeet nzit list, nzhab lo re gaay mndyeen kuu list nzi: “Taa goo lut aseyt goo kaa nee, tak lee kandil nee nlaaz yuyy”. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Per lee re mndyeen kuu ngobee nzhab: “Taat neey, tak cha gaate lortsin nee ne neeka gaate lortsin goo. Mas wen gwa goo ta ntho zhay ne bzhii goo chaan goo.” ");
INSERT INTO zaoNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Per leettsa lee re gaay mndyeen kuu ngobeet ndati aseyt, lee zha kuu tseya mzin, ne lee re gaay mndyeen kuu ngobee list nzi mkayaa zha kuu tseya, ne mndaab re zha leen yuu ta ngoo fandan, ne lee roo pwert myoww. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Bluz tsaraa mzin re mndyeen kuu ngobeet, ne nzhab mndyeen: “¡Zha Nabee, Zha Nabee, xaal roo pwert par tab nee!” ");
INSERT INTO zaoNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Per lee zha mkab ne nzhab: “Wlipaa na nin lo goo, nlebeetʼn goo”. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tsa lee Jesús mre nzhab: ―Kona list gwatsin goo, gatta goo, tak net goo wiz ne neeka or kuu yaad Zha Kuu Mzin Ngok Men. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Nal tan tedib kwent nanzee lo goo, tsa ne goo xomod nak, leettsa lee Diox nabee leettsoo men. Leey nak taxal thib mbyi kuu mera roo liz ya tith. Tsa mrez zha re mos zha ne mndaa zha temi zha ke mos tsiin. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Lo thib mos mndaa zha gaay temi or, ne lee lo tedib mos mndaa zha chop temi ne lee lo tedib mos mndaa zha thibka temi, ne lo kadta thib mos mndaa zha taxalta kuu tak lo mos ke mos tsiin. Ne mroo zha nda zha tith. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tsa lee mos kuu mkayaa gaay temi, tsyaka mndelo zha mke zha tsiin kon temiʼa ne mtsow zha gan tedib gaay temi. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Leeka tata, lee mos kuu mkayaa chop temi, mndelo mos mke tsiin kon temiʼa, ne mtsow mos gan techop temi. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Per lee mos kuu mkayaa thibka temi, ndya mos ne mdaan mos lo yu ne tya mkaats mos temi patron mos. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Kwathoz bluz tsaraa lee patron re mos mretab. Tsa mtsow patron kwent kon re mos. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ner mzin mos kuu mkayaa gaay temi, ne ndyaadno mos tedib gaay temi mas lo patron, ne nzhab mos: “Zha Nabee, lee gaay temiʼa kuu mndaaʼa lon nzhee, ne noga tan tedib gaaye kuu mtsowe gan”. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Tsa lee patron nzhab lo mos: “Wene, lu nak thib mos da kuu wen ne ngobee; ne tak wen mkeʼa tsiin lo lut kuu mndan loʼa, lee nal mas naroobe tan loʼa. Btaab ne naley bloo leettsooʼa kon na.” ");
INSERT INTO zaoNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tsaraa mzin mos kuu mkayaa chop temi, ne nzhab mos: “Zha Nabee, lee chop temiʼa kuu mndaaʼa lon nzhee, ne lee kuu mtsowe gan nzhee”. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tsa lee patron nzhab lo mos: “Wene, lu nak thib mos da kuu wen ne ngobee; ne tak wen mtsowa lo lut kuu mndan loʼa, lee nal mas naroobe tan loʼa. Btaab ne naley bloo leettsooʼa kon na.” ");
INSERT INTO zaoNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Tsaraa mzin mos kuu mkayaa thibka temi, tsa nzhab mos lo patron: “Zha Nabee, nen lee lu nak thib zha kuu nakap, nzhanna ta nagt loyuʼa, ne nthopa yalgonn ta mlota bin. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kona mzebʼn nen lu ne mkaatsʼn temiʼa lo yu. Lee nal lee temiʼa nzhee.” ");
INSERT INTO zaoNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tsa lee patron mkab ne nzhab lo mos: “Lu nak thib mos kuu went ne kwathoz natsaab, tak neʼa lee na nzhann na ta nagt lo yu da, ne nthopʼn yalgonn ta mlotʼn bin. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kona ndoblo gagoʼa temi da bank, tsa leettsa gabretabʼn gakayaan temi da kon zhiinne.” ");
INSERT INTO zaoNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tsa nzhab patron lo re zha kuu nzi tya: “Kib goo temi lo zha, ne btaa gooy lo zha kuu nap tsiiy, ");
INSERT INTO zaoNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","tak lee zha kuu nkeno naroobe, masraay kayaa zha, tsa keno zha masraay; per lee zha kuu yent kwan nap, asta lut kuu nap zha teyiibe lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Bzhen goo zha tsaab baa, ne blebi goo zha par lee ta nakow na, tya gonn zha ne tub zha keley zha.” ");
INSERT INTO zaoNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Leettsa lee na, Kuu Mzin Ngok Men, yalʼn xid xni thoz kon re mandad da, tsa tobʼn ta nla xni thoz ta nabeen. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Reta men kuu nzi dib naxta lo yezlyu kaltaa lon, ne koo zhann zha, taxal ngoo zhaa zha mbak zhiil xid re chib. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ne tsa tsin re mbak zhiil da lad ban lon ne lee re chib tsin lad beg lon. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tsa lee na zha kuu nak rey, gapʼn lo re zha kuu nzi lad ban lon: “De goo zha kuu mkayaa re kuu wen lo Xutʼn; bkayaa goo ta nabee Xutʼn, ta mdexkwaa Xutʼn par goo, asta leettsa mdexkwaa yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tak mlann na ne mndaa goo kuu ndowʼn, mndob xyeek leettsoon ne mndaa goo kuu ngwin, mndiyʼn ne yent ta gabetʼn ne goo mndaa ta mletʼn, ");
INSERT INTO zaoNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","mkenotʼn lar gokʼn ne goo mndaa lar mdokʼn, mzhak nen ne myaad goo lon mkenap goo na, ngoon tsib ne myaadtwii goo lon.” ");
INSERT INTO zaoNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tsa lee re zha nali kuu nzi lad ban lon ne: “Zha Nabee, ¿pol mne nee leeʼa mlann ne mndaa nee kuu ndowa? ¿Ne pol mne nee leeʼa mndob xyeek leettsoo ne mndaa nee kuu ngwiiʼa? ");
INSERT INTO zaoNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ne pol mne nee leeʼa ndiy ne yent ta kwetta ne mndaa nee ta mletta? ¿Ne pol ne nee leeʼa nkenot lar goka ne mndaa nee lar mndoka? ");
INSERT INTO zaoNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ne pol ne nee leeʼa ne mzhaak ne ngwatwii nee loʼa? ¿Ne pol ngooʼa tsib ne ngwatwii nee loʼa?” ");
INSERT INTO zaoNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tsa lee na zha kuu nak rey kabʼn ne nin: “Wlipaa na nin lo goo, reta kuu mtsow goo lo re thib wetsʼn, tegal nagt zha zha nataak, lon mtsow gooy”. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Tsa lee na zha kuu nak rey gapʼn lo re zha kuu nzi lad beg lon: “Beche goo lon tak mlodeʼa Diox goo. Tyee goo gabil, ta thitanax nyuyyt ki, ta mdexkwaa Diox par Maxuuy ne par re mandad Maxuuy. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tak mlann na ne mndaat goo kuu gawun, ne mndob xyeek leettsoon ne mndaat goo kuu gagun. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mndiyʼn yent ta gayoon ne mndaat goo ta gayoon. Mkenotʼn lar gagokʼn, ne mndaat goo lar gagokʼn, mzhak nen ne myaadtwiit goo lon gakenap goo na, ne ngoon tsib ne myaadtwiit goo lon.” ");
INSERT INTO zaoNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tsa lee re zha kab ne: “Zha Nabee, ¿pol mne nee leeʼa mlann, nzheek leettsooʼa, ndiya yent ta gabeta, ne yent lar gagoka, mzhak neʼa, ngooʼa tsib, ne mtsowt nee ayuda?” ");
INSERT INTO zaoNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tsa kabʼn lo re zha, ne gapʼn: “Wlipaa na nin lo goo, reta kuu mtsowt goo lo thib re wetsʼn, tegal nagt zha zha nataak, neeka lon mtsowt gooy”. ");
INSERT INTO zaoNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Reta zhaʼa ndya ta rid zha yalti thitanax, ne lee re zha kuu nali nak ndya tsow gan yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Leettsa ngwalo nzhab Jesús reta koree, tsa nzhab Jesús lo re zha kuu ngeteed lo Jesús: ");
INSERT INTO zaoNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Reta goo ne, nzhak falt chop wiz gak ani Paskw, lee na Kuu Myaad Ngok Men, taa zha na lo re zha nak tsiin par kee zha na lo kruz. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ne re wiza lee re ngwleyy kuu nabee lo re ngwleyy, ne re zha gol zha Israel, mkaltaa re zha liz Caifás kuu nak ngwleyy kuu nabee lo reta ngwleyy. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ne myaan re zha diiz naa xomod ten zha Jesús xlaanta, ne kuth zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Per lee re zha nzhab: ―Tsowtaay lo ani, tsa yiit re men neʼaa. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tsa nda Jesús yez Betania liz Simún kuu mzhaak yiz kuu nteyaaz kwerp zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tsa mbig thib ngot kuu ndyaadno thib bot ke kuu le alabastr, kuu tseta nzo aseyt kuu kwathoz chul ndetsi ne kwathoz naap. Ne leettsa lee Jesús ndob roo mes, lee ngota mlath aseyt yek Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Leettsa mwii re zha kuu ngeteed lo Jesús kona, tsa mnayii re zha ne mndelo zha mbez zha: ―¿Chebee tbaata mlux koree? ");
INSERT INTO zaoNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ngok gadoy naap, ne garoo temi gataa lo re zha prob. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús mbin koree, kona nzhab Jesús: ―¿Chebee ntsalzhoo goo ngot ree? Lee kuu mtsow ngot lon nak thib kuu wen. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tak lee re zha prob thibka nzi kon goo, ne tak tsow goo wen lo zha leettsa nlaaz goo, per lee na ndotʼn lo goo thibka. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Lee ngot ree mtsow kuu tak lo ngot tsow ngot, mloo ngot aseyt kwerp da leettsa terka kaats zha na. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Wlipaa na nin lo goo, dita lo yezlyu ta taa zha kwent Diiz Chul chaan da, noga teteth zha kuu mtsow ngot ree, tsa telaaz zha ngot. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Judas Iscariote, kuu nak thib zha lo re tsiibchop zha kuu ngeteed lo Jesús, ngwa lo re ngwleyy kuu nabee lo re ngwleyy. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ne nzhab Judas lo re zha: ―¿Plal kix goo kan, tsa tan Jesús lo re goo? Tsa myaan re zha diiz, ne mndaa zha galbtsii temi plat lo Judas. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ne leeka ora lee Judas mkwaan naa xomod taa Judas Jesús lo re zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ne lee wiz ner ani Paskw, ani kuu nzhow zha pan kuu nyoot lebadur, lee re zha kuu ngeteed lo Jesús mbig ne mnaabdiz lo Jesús ne nzhab: ―¿Pa nlaaza texkwaa nee rtsee Paskw dow rtseeʼaa? ");
INSERT INTO zaoNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Lee Jesús mkab ne nzhab: ―Gwa goo yez, liz thib zha kuu nlebeen, ne gab goo lo zha: “Lee maestr ne: Mzin gaxa or da. Liza wun rtsee chaan Paskw kon re zha kuu ngeteed lon.” ");
INSERT INTO zaoNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tsa lee re zha kuu ngeteed lo Jesús mtsow zha taxal nzhab Jesús lo zha. Ne mdexkwaa zha rtsee Paskw. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ne leettsa ngoo yaal yezlyu, lee Jesús ndob roo mes kon re tsiibchop zha kuu ngeteed lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ne leettsa ngeyow rtsee re zha, nzhab Jesús: ―Wlipaa na nin lo goo, leeka thib goo tan lo re kuu nayii nen. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tsa lee re zha kuu ngeteed lo Jesús kwathoz nabil ngoo leettsoo zha, ne mndelo zha mnaabdiz zha thibga thibga zha lo Jesús, ne nzhab zha: ―¿Chu nay? Zha Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús mkab ne nzhab: ―Thib zha kuu ntenit pan leen thibka yann kon nay, zhaʼa taan lo re zha kuu nayii nen. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Lee na Kuu Mzin Ngok Men, ndoblo ridʼn kwathoz yalti taxal nzhab lo xkeets Diox, per kwathoz nalatt rid zha kuu taan lo re zha kuu nayii nen. Mas wen gagalt zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tsa lee Judas kuu mndaa Jesús lo re zha kuu nayii ne Jesús, mnaabdiz ne nzhab lo Jesús: ―Maestr, ¿chu nay? ―Lu ney ―nzhab Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ne leettsa ngeyow rtsee re zha, lee Jesús mzhen pan, ne mndaa Jesús texkix lo Diox, ne mtsow rol Jesús pan, ne mndaa Jesús pan lo re zha kuu ngeteed lo Jesús, ne nzhab Jesús: ―Dow goo, koree nak beel da. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tsaraa mzhen Jesús bas kuu nzo xit ub ne mndaa Jesús texkix lo Diox, ne mriid Jesús bas lo re zha kuu ngeteed lo Jesús, ne nzhab Jesús lo re zha: ―Wii goo xit ub kuu nzo leen bas ree. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Koree nak ren da, ne leey nloo wli nak trat kub kuu mtsow Diox lo goo. Leey xon tsa tuyʼn falt kwathoz men. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Per wlipaa na nin lo goo, gut raa na xit ub ree, asta wiz kuu leettsa gun kuu kub kon re goo ta nabee Xutʼn. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Bluz leettsa ngwalo mbil re zha thib himn, tsa mroo re zha nda zha yek yii Olib. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tya nzhab Jesús lo re zha kuu ngeteed lo Jesús: ―Nal yaal ree lee re goo laan, tak lee lo xkeets Diox nzhab: “Kuthʼn zha kuu nkenap mbak zhiil, tsa lee re mbak zhiil raats”. Zac. 13:7 ");
INSERT INTO zaoNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Per bluz leettsa roban na, nerʼn ya lo re goo yezlyu Galilea. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tsa lee Pey nzhab lo Jesús: ―¡Tegal reta zha laa lu, per lee na thitanax latʼn lu! ");
INSERT INTO zaoNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Lee Jesús nzhab lo Pey: ―Wlipaa na nin loʼa, leeka nal yaal ree, or terka kwez ngite, leeʼa gab tson welt nlebeeta na. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tsa lee Pey nzhab: ―Tegal gathʼn kon lu, per gabtʼn nlebeetʼn lu. Ne reta re zha kuu ngeteed lo Jesús leeka tata nzhab zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tsa nda Jesús kon re zha kuu ngeteed lo Jesús leen alo Getsemaní, ne nzhab Jesús lo re zha: ―Nzhee brin goo, leen nda tediz lo Diox baa. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ne ndano Jesús Pey, ne rop xgann Zebedeo kuu nak Juan ne Santiag, tsa mndelo mndebi leettsoo Jesús ne nalatt ngoo leettsoo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tsa nzhab Jesús lo re yon zha: ―Kwathoz nalatt nzo leettsoon, taxal zha ndeyatha. Yaanka goo nzhee ne gatta goo tsa wii goo kuu gak. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tsa lee Jesús nda tut kwat, ne mtobxub Jesús asta mdiinn yeklo Jesús lo yu, ne mndediz Jesús lo Diox, ne nzhab Jesús: ―Xutʼn, os leey take, btelaan tsa riidtʼn yalti kuu riidʼn, per nlaztʼn gake taxal nlazʼn, sinke taxal nlaaza gake. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tsaraa mre Jesús lo re yon zha kuu ngeteed lo Jesús, ne lee re yon zha naxat; tsa nzhab Jesús lo Pey: ―¿Chu neeka thib or mxegt goo lo mkaal? ");
INSERT INTO zaoNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bloo goo mkaal lo goo ne bnaab goo ayud lo Diox, tsa kedit Maxuuy goo. Nlaaz goo tsow goo kuu nlaaz Diox, per men nak goo ne xegt beel goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mrop welt nda Jesús ne mndediz Jesús lo Diox, ne nzhab Jesús: ―Xutʼn, os tak riidtʼn yalti ree kuu ndoblon riidʼn; per ndoblo gake taxal nlaaza. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tsa mre Jesús lo re yon zha kuu ngeteed lo Jesús tedib welt, ne lee re zha naxat, tak kwathoz ngwatin zha mkaal. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tsa mlaa Jesús re zha ne ngwa Jesús mndediz lo Diox tedib welt, ne nzhab Jesús leeka re diiz kuu nzhab Jesús ner. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tsa mretab Jesús ta nzi re zha kuu ngeteed lo Jesús, ne nzhab Jesús lo re zha: ―¡Nalsi bneyy goo ne bdat goo! Tak mzina or kuu lee na, Kuu Mzin Ngok Men, taa zha lo re zha kuu nap falt. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Gwache goo, ndaa goo reʼaa, tak ndyaada zha kuu taan lo re zha kuu nayii nen. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Leettsa lee Jesús bee ngenika, lee Judas kuu nak thib re zha kuu mteed lo Jesús, mzin kon kwathoz zha kuu nzo espad ne ya yaa. Re zhaʼa ndyaad kwent chaan re ngwleyy kuu nabee lo re ngwleyy, ne kwent chaan re zha gol kuu nabee lo re zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ne mndaaʼa Judas thib seny lo re zhaʼa nzhab Judas: ―Zha kuu wun thib chut cho kwat, zhaʼa ten goo ne teno goo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tsa lee Judas mbig lo Jesús ne mni “diox” lo Jesús ne nzhab: ―¡Maestr! Oraaka ndow Judas thib chut kwat Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Per lee Jesús nzhab lo Judas: ―Amig, btsow kuu ndyaada tsowa. Tsa lee re men mbig ne mzhen Jesús, ne ndano zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Per thib re zha kuu ndo kon Jesús, mloo spad ne mga nza mos ngwleyy kuu nabee lo reta ngwleyy. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tsa nzhab Jesús lo zhaʼa: ―Blotsow espada, tak reta zha kuu nzhuth kon spad kon spadka gath zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Chu neta tak naabʼn lo Xutʼn, tsa taal Xutʼn thib tsiibchop mil mandad chaan Xutʼn nalorka? ");
INSERT INTO zaoNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Per os tatay, ¿xomod gak re kuu nzhab lo xkeets Diox, kuu nzhab leey tabaa ndoblo gak? ");
INSERT INTO zaoNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tsa lee Jesús nzhab lo re men kuu nzi tya: ―¿Chebee kon spad ne kon ya ndyaad goo ten goo na taxal thib wann? Gandata wiz ngwaton mloon lo goo lee roo gwodoo. Ne, ¿chebee mzhent goo na tsya? ");
INSERT INTO zaoNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Per reta koree ngeyak, tsa rolo re kuu mkee re profet kuu ngoo ndala. Tsa lee re zha kuu ngeteed lo Jesús mlaa zha Jesús, ne mzhonn zha ndya zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tsa lee re zha kuu mzhen Jesús ndano zha Jesús liz Caifás, kuu nak ngwleyy kuu nabee lo reta ngwleyy, ne tya nzi re maestr kuu nloo xkiiz Diox ne re zha gol kuu nabee lo re zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Per lee Pey tith tith ndeke dits re zhaʼa, asta lee liz ngwleyy kuu nabee lo reta ngwleyy, tsa myaan Pey mndob Pey kon re polisi kuu nkenap liz ngwleyy, tak nlaaz Pey ne Pey naa kwan yelo tsowno re zhaʼa Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tsa lee re ngwleyy kuu nabee lo re ngwleyy, kon re zha gol kuu nabee lo re zha Israel, ne kon reta zha kuu mas nataak lo re zha Israel, nkwaan zha naa kwan keki zha Jesús, tegal kuu wlite, tsa kuth zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Per mzalt zha naa kwan keki zha Jesús, par tak kuth zha Jesús, tegal nzin kwathoz men kuu nkedi ne nkeki Jesús. Tsaraa mzin chop zha kuu nzhab kuu wlit, ");
INSERT INTO zaoNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ne nzhab zha: ―Nee mbin lee zha ree nzhab: “Na luux gwodoo chaan Diox, ne tsonka wiz taa nay tedib welt”. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tsa lee ngwleyy kuu nabee lo reta ngwleyy ngwateli, ne mnaabdiz lo Jesús, ne nzhab: ―¿Chebee nkabta neeka thib kwaa? ¿Xomod nak re kuu nkeki zha lu? ");
INSERT INTO zaoNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Per lee Jesús mkabt neeka thib kwaa lo ngwleyy kuu nabee lo reta ngwleyy. Tsa lee ngwleyya mre mnaabdiz lo Jesús ne nzhab: ―Btselo lo Diox kuu naban leeʼa ne kuu wli. Ne lo nee: ¿Chu lu nak Xgann Diox Kuu Mtaal Diox Nabee? ");
INSERT INTO zaoNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús mkab ne nzhab: ―Lu ney. Noga nin lo goo, lee goo wii goo lo na, Kuu Mzin Ngok Men, tobʼn lad ban lo Diox kuu tak tsow reta kwaa, tsa nabeen. Ne wii goo leen yal leen xkow lobee. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tsa lee ngwleyy kuu nabee lo reta ngwleyy mchat xab, ne nzhab: ―¡Lee zha ree ni de Diox! Kon kuu ni zha. Ndechet raa lee tedib testig, mbina goo xa ni de zha Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Xa nloo koree lo goo? Lee re zha mkab ne nzhab: ―Nap zha falt, ndoblo gath zha por falt zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tsa mtsuk zha lo Jesús ne mdinke zha Jesús. Ne chop tson zha mkee maket kwat Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ne mbez zha: ―Lu ne, lu nak Crist Kuu Mtaal Diox Nabee, ne naa cho mkeey yeka. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Leettsa lee Pey ndob lee liz ngwleyy kuu nabee lo reta ngwleyy, tsa lee thib ngot mndyeen kuu nke tsiin lo ngwleyya, mbig lo Pey ne nzhab: ―Noʼa ndiy kon Jesús zha Galilea, taxal tedib net zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Per lee Pey nzhab lo re zha: ―Netʼn kwan ntetha lon. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tsa lee Pey nda ndo roo pwert, tsa mwii tedib ngot mndyeen kuu nke tsiin lo ngwleyya lo Pey, tsa nzhab ngot lo re zha kuu nzi tya: ―No zha ree ndiy kon Jesús, zha yez Nazaret. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ne tedib welt lee Pey mtselo kruz, ne nzhab: ―¡Nlebeetʼn mbyi baa! ");
INSERT INTO zaoNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tut bluz lee re zha kuu nzi tya, mbig lo Pey ne nzhab: ―Wlipaa noʼa thibka naka kon re zha baa, asta xa ndediza nabeey. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tsa lee Pey mtselo kruz, ne mndelo mde leeka lee, ne nzhab: ―¡Wlipaa na, nlebeetʼn mbyi baa! Ne ora lee ngite mrez. ");
INSERT INTO zaoNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tsa lee Pey mtelaaz kuu nzhab Jesús lo Pey: “Leettsa terka kwez ngite, leeʼa gab tson welt nlebeeta na”. Or mtelaaz Pey kona, mroo pey tya ne mla yalne leettsoo Pey ne mndelo Pey mbinn Pey. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Leettsa ngwani yezlyu, lee re ngwleyy kuu nabee lo re ngwleyy ne re zha gol kuu nabee lo re zha Israel, myaan zha diiz tsa naa xomod tsow zha kuth zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tsa mliib zha Jesús ne ndano zha Jesús lo Pilat, zha kuu nabee dita yezlyuʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tsa lee Judas kuu mndaa Jesús lo re zha kuu kuth Jesús, leettsa myeen Judas lee re zha kuth Jesús, kwathoz ndowe leettsoo Judas, ne ngwa Judas mtsere re galbtsii temi plat, lo re ngwleyy kuu nabee lo re ngwleyy ne lo re zha gol kuu nabee lo re zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ne nzhab Judas lo re zha: ―Mndan thib falt thoz, tak mndan thib zha kuu mtsowt neeka thib kuu went gath. Per lee re zha mkab lo Judas ne nzhab: ―¿Yent cho mport nee kona? ¡Kwenta kona! ");
INSERT INTO zaoNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tsa lee Judas mlobi re temiʼa leen gwodoo, ne ndya Judas ne leeka lee Judas mloo doo yene. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tsa lee re ngwleyy kuu nabee lo re ngwleyy mthop temiʼa, ne nzhab: ―Gagt koʼaa temi ree leen ta nyoo gon, tak nambit temi ree, tak leey mndaa reʼaa par gath thib zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tsaraa ngoo re zha thib junt, tsa naa kwan tsow zha kon temiʼa, ne kon temiʼa mzhii re zha thib le yu, ta ngoo re men yu ndexkwaa men yet, tsa tya gaats re zha tith. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ta mod lee yuʼa le Yu Ren asta nal. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tbaa mrolo kuu nzhab profet Jeremí lo re men ndala, leettsa nzhab profet: “Mzhen zha re galbtsii temi plat, lala nataak zha nzhab re zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ne kon temiʼa mzhii zha thib le yu, ta ngoo re men yu ndexkwaa men yet, taxal mnabee Zha Nabee.” Jer. 32:6; Zac. 11:12-13 ");
INSERT INTO zaoNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Tsa ndano zha Jesús lo Pilat zha kuu nabee tsya. Ne mnaabdiz Pilat lo Jesús ne nzhab Pilat: ―¿Chu lu nak rey chaan re zha Israel? Jesús nzhab: ―Lu ney. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tsa lee re ngwleyy kuu nabee lo re ngwleyy ne re zha gol, mkeki zha Jesús kon kuu wlit, per lee Jesús neeka thib lan diiz mkabt. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tsa lee Pilat nzhab lo Jesús: ―¿Chu nzhonta re kuu nkeki zha lu? ");
INSERT INTO zaoNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Per neeka thib lan diiz mkabt Jesús lo Pilat, tsa lee Pilat mzegey leettsoo ne net Pilat naa kwan tsow Pilat xgab. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ne gandata liin lo ani Paskw, lee Pilat ntelaa thib zha kuu nzo tsib, loka zha kuu naab re men yez lo Pilat. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Lee thib zha kuu le Barrabás kuu kwathoz nzib xkiiz nzo tsib tsya, ne nlebee reta men zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Or lee reta zha mkaltaa, tsa mnaabdiz Pilat lo re zha kuu nzi tya, ne nzhab Pilat: ―¿Cho nlaaz goo telaan? ¿Chu nlaaz goo telaan Barrabás, o Jesús kuu ni re zha, Crist Kuu Mtaal Diox Nabee? ");
INSERT INTO zaoNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tak myeen Pilat lee re ngwleyy kuu nabee lo re ngwleyy kon re zha gol, mndaa zha Jesús lo Pilat, tak nayii zha ne zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ne lee Pilat bee ndobka ta naab Pilat kwent, lee tsaal Pilat mtaal thib zha, nzhab lo Pilat: ―Tsowta neeka thib kuu went lo mbyi baa, tak zha wen nak zha. Ne naabtsiʼa kwathoz went mtsaa leettsoon por mbyi baa. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Per lee re ngwleyy kuu nabee lo re ngwleyy ne re zha gol, mtekiil zha re men kuu nzi tya, tsa naab re zha telaa Pilat Barrabás ne lee Jesús kuth zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tsa lee Pilat mre mnaabdiz, ne nzhab: ―¿Cho lo rop zha ree nlaaz goo telaan? Tsa lee re men mkab ne nzhab: ―Barrabás btelaa. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tsa lee Pilat mre mnaabdiz lo re men, ne nzhab: ―Ne, ¿kwan tsowʼn kon Jesús kuu ni re zha, Crist Kuu Mtaal Diox Nabee? Reta men mkab ne nzhab: ―¡Bkee zha lo kruz! ");
INSERT INTO zaoNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Lee Pilat nzhab: ―Per, ¿kwan kuu went mtsow zha? Lee re men masraa nex mrez, ne nzhab: ―¡Bkee goo zha lo kruz! ");
INSERT INTO zaoNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Leettsa mne Pilat yet roo Pilat lo re men, tak masraa nakap nzhak re men, ora mtaal Pilat zha ngwaxii nit, ne mteech Pilat yaa Pilat lo re men, tsa loo Pilat napt Pilat falt, ne nzhab Pilat: ―Kwibt ren chaan mbyi wen ree ditsʼn, goo bene. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tsa lee re men mkab ne nzhab: ―¡Dits nee, ne dits raz nee kwib ren chaan mbyi baa! ");
INSERT INTO zaoNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tsa lee Pilat mtelaa Barrabás, ne mnabee Pilat mdinke zha Jesús, ne mndaa Pilat Jesús lo re soldad tsa kee zha Jesús lo kruz. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tsa lee re soldad chaan Pilat ndano Jesús leen thib yuu naro lee liz Pilat, ne mkaltaa re soldad Pilat dita lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ne mloo zha xabits Jesús ne mtegok zha Jesús thib lar kuu nanexa na. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ne mtob zha thib koron kuu natexkwaa kon yits yek Jesús, ne mloo zha thib aga yaa ban Jesús. Ne mtobxub re zha lo Jesús ne mzhizno zha Jesús, ne mbez zha: ―¡Wii goo lo rey chaan re zha Israel! ");
INSERT INTO zaoNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Noga mtsuk re zha lo Jesús, ne leeka aga kuu nzo yaa Jesús mkee zha yek Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ne leettsa ngwalo mzhizno zha Jesús, tsa mloo zha lar kuu naneʼa yen Jesús, ne mtegok zha Jesús xabka Jesús. Tsa ndano zha Jesús ta kee zha Jesús lo kruz. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ne leettsa mroo re soldad tya, ndano zha Jesús ta kee zha Jesús lo kruz, tsa mzaal zha thib mbyi zha yez Cirene kuu le Simún. Tsa mnabee re soldad lo zha gwe zha kruz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ne leettsa mzin zha thib ta le Gólgota. (Diiz ree nak: “Tsidth yek zha”.) ");
INSERT INTO zaoNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ne mndaa zha xit ub kuu nabexnit kon zhewla gu Jesús; ne ngwalo mtsow Jesús prebe, ngwiit Jesús nita. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Mkee zha Jesús lo kruz, tsa lee re soldad mloo swert tsa naa cho tsow gan xab Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ne tya mndob re soldad tsa kenap soldad Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ne yek kruz Jesús mkee zha thib letr kuu nzhab naa chebee mkee zha Jesús lo kruz. Lee Letr nzhab: “ZHA REE NAK JESÚS KUU NAK REY CHAAN RE ZHA ISRAEL”. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Noga chop wann mke lo kruz kon Jesús, thib zha mke lad ban Jesús, lee tedib zha mke lad beg lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ne reta zha kuu ndriid lo Jesús, ndota kuu mbez zha lo Jesús, ne nkwin zha yek zha lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ne nzhizno zha Jesús ne mbez zha lo Jesús: ―Lu mbez luuzha gwodoo, ne tsonka wiz taaʼa tedibe. ¡Os leeʼa wli Xgann Diox naka, leeka lu blaʼa lo kruz! ");
INSERT INTO zaoNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ne tataka ndota kuu mbez re ngwleyy, kuu nabee lo re ngwleyy lo Jesús ne re maestr kuu nloo xkiiz Diox lo re men ne re zha gol kuu nabee lo re zha Israel, ");
INSERT INTO zaoNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","mbez re zha: ―Mlaat zha gagath tedib net zha, ¿ne chebee gagt la zha leeka lee zha zha lo kruz? Ne os lee zha nak zha, Zha Kuu Mtaal Diox Nabee lo re zha Israel, ndoblo leeka lee zha la zha zha lo kruz, tsa yelaazaa zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ne tak kwathoz nyelaaz zha Diox, nez Diox telaa zha nal, os wli nke leettsoo Diox zha; tak leeka zha ne Xgann Diox nak zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Noga rop wann kuu nke lo kruz cho Jesús, ndota kuu mbez lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ndrolta wiz dita yezlyu mla yaal, koree mxek asta las tres. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ne oraaka lee Jesús dib gan mrez ne nzhab: ―Elí Elí ¿lama sabactani? (Diiz ree nak: “Diox da, Diox da, ¿chebee mlaaʼa na?”) Sal. 22:1 ");
INSERT INTO zaoNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ne lee chop tson zha kuu nzi tya, mbin kuu nzhab Jesús, tsa nzhab zha: ―Lee zha ngebez profet Lí zha ndala. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Oraaka lee thib zha mrozhonn ngwaxii thib le zhiil, ne mtenit zhay leen xit ub kuu myal kuu nala ne ni, ne mtob zhay yek thib mnix, ne mtob zhay roo Jesús, tsa gu Jesús kona. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Per lee techop tson zha nzhab: ―Laa goo, tsa neʼaa naa chu tyaad Lí telaa zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ne lee Jesús dib gan mrez tedib welt ne nguth. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ne lee lar kuu ntow, Ta Kwathoz Nayon leen gwodoo, mrat asta yeke ne asta xanne. Ne lee yezlyu mwin zho, ne lee re ke nabii ngok rol. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ne lee re roo baa mzhaal; ne kwaro re zha nguth kuu nali ngok lo Diox mre mban. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tsa mroo re zha leen baa, leettsa ngulo mroban Jesús, mndaab re zha leen yez Jerusalén, ne tya kwathoz men mwii lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tsa lee soldad kuu nabee lo thib gayoo soldad ne re soldad kuu nkenap Jesús, mne zha mwin zho thoz ne mne zha reta kuu ngok, tsa kwathoz mzeb re zha ne nzhab zha: ―Wlipaa, lee mbyi ree nak Xgann Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kwaro ngot nzi tith ndiy ngwii, re ngota mndeke dits Jesús desde yezlyu Galilea ne mtsow re ngota ayud Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ne xid re ngota nzo Mari Magdalen, ne Mari xnaa Santiag ne xnaa Che, ne noga xnaa ropta xgann Zebedeo. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Leettsa ndekowa yezlyu, tsa mzin thib mbyi rik kuu le Che, zhaʼa nak zha yez Arimatea ne no zha mndeke dits Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tsa ngwa zha lo Pilat ne mnaab zha kwerp Jesús. Tsa mnabee Pilat taa zha kwerp Jesús lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tsa mkayaa zha kwerp Jesús, ne mchiix zha kwerp Jesús kon thib le lar nambi. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ne mloo zha kwerp Jesús leen thib baa zha, kuu kub kuu mdaan zha leen ke. Ne mtow zha roo baa kon thib ke naro ne ndya zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ne tya ndo Mari Magdalen ne tedib Mari, rop ngot ndob gax roo baa. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ne leettsa ngwalo mriid wiz kuu ndexkwaa zha kuu nzhow zha wiz sabd, tsa lee re ngwleyy kuu nabee lo re ngwleyy ne re fariseo ngwa lo Pilat, ");
INSERT INTO zaoNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ne nzhab zha: ―Zha nabee, mtelaaz nee lee mbyi kuu kwathoz mkediʼa, leettsa bee naban zha ne zha lo nee: “Bluz leettsa tsaal tson wiz lee na roban”. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kona bnabee tsa wen kenap zha roo baa, asta tsaal tson wiz. Tak cha ya re zha kuu mteed lo zha yalowann kwerp zha yaal, ne gab re zha lo re men: “Lee zha mrobana”. Tsa lee yalkedi ree gak kuu masraa went nake kuu mtsow zha ner. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tsa lee Pilat nzhab: ―Baa nzi re soldad, gwa goo ne bkenap goo roo baa taxal nlaaz goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tsa ngwa re zha ne mkenap zha roo baa, ne key mtow zha roo baa, ne mtob zha sey cho ke kuu now roo baa, ne mtaan zha re soldad kenap roo baa. ");
INSERT INTO zaoNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ngulo mriid wiz sabd, ne ndeyeni yezlyu wiz domin, lee Mari Magdalen ne lee tedib Mari ngwatwii roo baa ta mloo zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ne oraaka lee thib zho thoz mwin lo yezlyu. Lee thib mandad chaan Diox mroo yibaa mla lo yu, mbig roo baa ne mkib ke kuu now roo baa ne mndob mandad dits ke. ");
INSERT INTO zaoNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ne taxal bel bti na mandad, ne lee xab mandad naguz na taxal na yig. ");
INSERT INTO zaoNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Or mwii re soldad kona, kwathoz mzeb re zha ne mzhiit zha, ne thitanax mkow zha, taxal zha nguth. ");
INSERT INTO zaoNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tsa lee mandad nzhab lo rop ngot: ―Tsebt goo. Na ne lee goo nkwaan Jesús, zha kuu mkee zha lo kruz. ");
INSERT INTO zaoNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yenta zha nzhee, mrobana zha, taxal ne zha lo re goo. De goo tsa wii goo ta mloo zha zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Lijer tyee goo ne guz gooy lo re zha kuu mteed lo zha, lee zha mrobana. Ne ner Jesús ya yezlyu Galilea lo re goo. Tya wii goo Jesús. Koree nak kuu nin lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ne lee rop ngota oraaka ndya, tak kwathoz mzeb rop zha ne kwathoz laz zha. Ne lijer ndya zha nzhab zhay lo re zha kuu mteed lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ne leeka ora lee Jesús cha mzin lo rop ngot, ne mni “diox” lo rop ngot. Tsa lee rop ngot mbig lo Jesús, ne mdeez zha nii Jesús, ne mtobxub zha lo Jesús ne mbil zha lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tsa nzhab Jesús lo rop zha: ―Tsebt goo. Gwa goo gwane goo lo re wetsʼn tsa ya zha Galilea, ne tya wii zha na. ");
INSERT INTO zaoNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Leettsa lee rop ngot ndya, tsa lee chop tson re soldad ngwa lo re ngwleyy kuu nabee lo re ngwleyy ngwane reta kuu ngok. ");
INSERT INTO zaoNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tsa lee re ngwleyy kuu nabee lo re ngwleyy mrez re zha gol kuu nabee lo re zha Israel, par yaan re zha diiz. Ne myaan re zha mndaa zha naroob temi lo re soldad, ");
INSERT INTO zaoNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ne nzhab re zha lo re soldad: ―Lee re goo ndoblo gab: “Yaal, leettsa lee nee mzhen mkaal, lee re zha kuu mteed lo Jesús myaad mlowann kwerp Jesús”. ");
INSERT INTO zaoNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ne os lee Pilat gon xomod nak koree, lee re nee kab lo Pilat por goo, tsa tetit Pilat goo. ");
INSERT INTO zaoNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tsa lee re soldad mkayaa temi, ne mtsow re soldad taxal nzhab re zhaʼa lo re soldad. Kuu nzhab re soldad konaka nak kuu ni re zha Israel asta wiz naltseree. ");
INSERT INTO zaoNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tsa lee re tsiibthib zha kuu mteed lo Jesús, ndya yezlyu Galilea, yek yii ta nzhaba Jesús lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ne leettsa mwii re zha Jesús mbil zha lo Jesús, tegal nzo chop tson zha nyelaazte. ");
INSERT INTO zaoNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tsa lee Jesús mbig lo re zha ne nzhab: ―Lee Diox mndaa reta yalnabee lon leen yibaa ne lo yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Gwa goo lo reta men dib naxta lo yezlyu, ne btsow goo gak zha, zha kuu teed lon, ne btsowleyy goo zha, kon yalnabee chaan Xutʼn, kon yalnabee chaan da, ne kon yalnabee chaan Mbi Nayon chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ne bloo goo lo re zha gon zha diiz reta kuu mnabeen lo re goo. Ne btelaaz goo le na ndo kon reta goo reta wiz, asta leettsa lux yezlyu.");
INSERT INTO zaoNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Tenzhee mod mndelo Diiz Chul chaan Jesucrist Xgann Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Taxal nke lo xkeets Diox kuu mkee profet Isaí, or nzhab profet: Na taal thib zha kuu tener loʼa, tsa to list zha leettsoo re men, par kayaa men lu. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ne dib gan zha kwez zha thib ta yubiz ne gab zha: “Nali bloo goo leettsoo goo par kayaa goo Zha Nabee, ne nali gok goo lo re kuu ntsow goo”. Is. 40:3 ");
INSERT INTO zaoNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tata mrolo kuu nzhab Isaí, or lee Juan kuu mtsowleyy re men mzin mndaa kwent xkiiz Diox thib ta yubiz, ne nzhab Juan lo re men, ndoblo tsee zha re mod kuu went kuu nak zha ne tob yek zha xkiiz Diox, tsa tuyy Diox re falt kuu mtsow zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Reta zha Jerusalén yez naro, ne re yez bzhizh chaan yezlyu Judea, mzin re zha tsa gon zha xkiiz Juan. Ne mndaa zha kwent re falt kuu mtsow zha, tsa mtsowleyy Juan zha leen yoo Jordán. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan mdok lar kuu natexkwaa kon yits lad kamey, ne naliib thib sinch yid leeyy Juan, ne kuu nzhow Juan nak ngebeez ne kuu nzhuu Juan nak mzin wan. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Or mndaa Juan kwent xkiiz Diox, nzhab Juan: ―Mera yaad thib zha kuu mas nataak nake na, ne neeka ndoblotʼn xakʼn korre dits labyid zha, tak mas nataak zha nake na. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Na mtsowleyy goo kon nit, per lee mbyiʼa tsowleyy goo, or kuu taa zha Mbi Nayon chaan Diox lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Thib wiz mroo Jesús yez Nazaret yezlyu Galilea, ne mzin Jesús ta ngetsowleyy Juan re men, tsa mtsowleyy Juan Jesús leen yoo Jordán. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Or mroo Jesús leen nit mwii Jesús lee lobee mzhaal, ne lee Mbi Nayon mla dits Jesús taxal thib palom. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Oraaka mbin Jesús thib bos kuu mroo lobee kuu nzhab: ―Lu nak xgann na kuu kwathoz nke leettsoon, ne kwathoz wen nzo leettsoon nen lu. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tsa lee Mbi Nayon chaan Diox mndeno Jesús thib ta yubiz. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tya ngoo Jesús chop gal wiz, ne chop gal yaal xid re maa nayii. Tsa lee Maxuuy ngwalaaz gakedi Jesús tyen welt, tsaraa lee re mandad chaan Diox mkenap Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Leettsa ngoo Juan tsib lee Jesús ngwa yezlyu Galilea, ne mndaa Jesús kwent Diiz Chul chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ne nzhab Jesús: ―Mzin gaxa wiz kuu lee Diox nabee lo goo. Btsee goo mod went kuu nak goo, ne gwalaaz goo Diiz Chul chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Leettsa ndiy Jesús roo nitdoo yezlyu Galilea, tsa mwii Jesús Simún ne wets Simún kuu le Ndres, lee rop zha ngegobi yex zha leen nitdoo, tak zha niit mbel nak zha rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ora nzhab Jesús lo rop zha: ―Bteke goo ditsʼn, tsa tsowʼn gak goo zha kuu niit men par Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Oraaka mlaa rop zha yex zha ne mndeke zha dits Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ne nda Jesús mas kwat, tsa mwii Jesús Santiag ne Juan kuu nak rop xgann Zebedeo, re zha nzo leen kano ngeyib yex. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tsa mrez Jesús rop zhaʼa, ne oraaka mlaa zha xut zha Zebedeo kuu nzo leen kano kon re mos, ne mndeke rop zha dits Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ne mndaab Jesús kon re zha yez Capernaúm wiz kuu nzhool re zha Israel lo Diox, ne ngwa re zha ta nkaltaa re men nteed xkiiz Diox, tsa mndelo Jesús mloo lo re men kuu nzi tya. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kwathoz mzegey leettsoo re zha naa xomod mloo Jesús lo re zha, tak kon yalnabee mloo Jesús lo re zha, ne mloot Jesús taxal nloo re maestr chaan ley. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ne tya ndo thib mbyi kuu nzo mbi fyer leettsoo, ne lee zhaʼa mretsyath, ne nzhab: ");
INSERT INTO zaoNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿Kwan nlaaza kon nee Jesús zha Nazaret? ¿Chu ndyaada luuzha nee? Nen cho naka. Lu nak Zha kuu Nayon lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Oraaka mkox mbi fyer lo Jesús, ne nzhab Jesús: ―¡Btow rooʼa, ne broo leettsoo mbyi ree! ");
INSERT INTO zaoNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tsa lee mbi fyer mtsow mlen zhaʼa yizguthye ne mretsyath mroo leettsoo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ne reta zha kuu nzi tya kwathoz mzegey leettsoo zha, ne mnaabdiz zha lo altaa zha, ne nzhab zha: ―¡Neeka mas ter wiiʼaa koree! ¿Kwan koree? Zha ree nloo pur kuu kub, ne nabee zha lo re mbi fyer ne nzhone diiz lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tsa kwathoz ney mraats diiz re kuu mtsow Jesús dita yezlyu Galilea. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Leettsa mroo re zha Jesús leen yuu ta nkaltaa re zha Israel, tsa ngwa Jesús kon Santiag ne Juan liz Simún rop Ndres. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tsa nzhab re zha lo Jesús lee xnaatsaap Simún, nax lo luun ndak xlee. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ora mbig Jesús ne mzhen Jesús yaa zha ne mlit Jesús zha, oraaka mroo xlee zha, ne mndaa zha kuu mdow re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Or ndekowa yezlyu, tsa lee re men myaadno re mbyiz ne re zha kuu nzo mbi fyer leettsoo lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ne dita yez mkaltaa roo yuu ta ndo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tsa mtegwe Jesús re mbyiz, ne mloo Jesús kwathoz re mbi fyer kuu nzo leettsoo re men. Ne mndaat Jesús diiz gatediz re mbi fyera, tak neʼa re mbi fyera naa cho nak Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ne zhaaraa na ngwache Jesús, ne ngwa Jesús thib ta wan ta nagan, ta nlaaz Jesús to thita Jesús, tsa tediz Jesús kon Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tsa lee re altaa Simún ngwakwaan Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ne or mzal Jesús lo re zha, tsa nzhab zha lo Jesús: ―¡Reta men ngekwaana! ");
INSERT INTO zaoNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Per lee Jesús nzhab lo re zha: ―Nda goo reʼaa re yez kuu nzi gaxta nzhee, tsa tan kwent xkiiz Diox lo re zha kuu nzo tya, tak par kona ndyalʼn. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ne mndaa Jesús kwent xkiiz Diox ta nkaltaa re zha Israel dita yezlyu Galilea, ne mloo Jesús re mbi fyer kuu nzo leettsoo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tsa myaad thib zha kuu ndeye kwerp lo Jesús, ne mtobxub zha lo Jesús, ne dib ndroo leettsoo zha nzhab zha lo Jesús: ―Os leeʼa nlaaza tegweʼa na, btegwen lo yiz ree. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tsa mlat leettsoo Jesús mne Jesús zhaʼa, ne kon yaa Jesús mdiinn Jesús cho zha. Tsa nzhab Jesús lo zha: ―Nlazʼn weʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Leeka or kuu mni Jesús lo zha, oraaka mgwe zha, ne myaan nambi zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tsa mteni Jesús zha, ne mtaal Jesús zha liz zha, ");
INSERT INTO zaoNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ne nzhab Jesús lo zha: ―Yent cho lo gaba koree, gwa lo ngwleyy ne be gon kuu ndoblo taa thib mbyi kuu mgweʼa taxal mnabee Moisés, tsa ne reta zha leeʼa mgweʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Per lee mbyiʼa ndya ne nzhabe lo reta men, kona ngogt raa gataab Jesús re yeza, sinke roo re yeza mlet Jesús, ne lee re men reta yez ndyaad lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Leettsa mriida chop tson wiz, tsa mretab Jesús yez Capernaúm tedib welt, ne mbin re men lee Jesús nzo liz thib zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kwathoz ney mkaltaa kwaro re men tya, ne mgaat raa leen yuu gataab neeka tedib zha, tsa mndaa Jesús kwent xkiiz Diox lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tsaraa ndyaad thap mbyi kuu ndyaadno thib mbyi mthans lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ne ngogt gabig zha lo Jesús, tak kwaro men nzi, tsa mxaal re zha yek yuu, ne mla zha dib luun zha mthansa lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ne oraaka myeen Jesús lee re zhaʼa nyelaaz Diox. Tsa nzhab Jesús lo zha mthansa: ―Xgann na, mtuyya na re falta. ");
INSERT INTO zaoNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Per tya nzi tyen maestr kuu nloo xkiiz Diox, re zhaʼa mtsow xgab ne nzhab: ");
INSERT INTO zaoNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Chebee tabaa ndediz mbyi ree? ¡Taxal Diox ndediz zha! Neeka thib men gagt kib falt beeta Diox tak kib falt.” ");
INSERT INTO zaoNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Per lee Jesús myeen naa kwan ntsow re maestr chaan ley xgab, tsa nzhab Jesús lo re zha: ―¿Chebee tabaa ntsow goo xgab? ");
INSERT INTO zaoNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Kwan ntsow goo xgab? ¿Kwan mas nagant gapʼn lo mbyiz: “Lee re falta myuyya”, o tegwen zha ne gapʼn lo zha: “Gwache bzhen luuna ne bte”? ");
INSERT INTO zaoNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Tsowʼn koree lo re goo, tsa ne goo lee na, Kuu Mzin Ngok Men, napʼn yalnabee par tuyʼn re falt chaan re men. Tsa nzhab Jesús lo mthans: ");
INSERT INTO zaoNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Loʼa nin gwache, bzhen luuna ne tyee liza. ");
INSERT INTO zaoNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Oraaka lee mbyi mthansa ngwache, ne mzhen zha luun zha ne ndya zha, ne reta zha kuu mwii kuu ngok, kwathoz mzegey leettsoo zha, ne mndaa zha texkix lo Diox ne nzhab zha: ―¡Neeka mas ter wiiʼaa koree! ¡Re kuu thoz kuu ntsow Diox! ");
INSERT INTO zaoNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tsa mre Jesús ngwa Jesús roo nitdoo tedib welt; ne lee re men ngwa lo Jesús, tsa mloo Jesús lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ne nda Jesús tut kwat, tsa mwii Jesús Leví xgann Alfeo, thib zha kuu ntsow kobral temi chaan yezlyu, kuu nzhax lo zha Roma, tsa nzhab Jesús lo zha: ―Bteke ditsʼn. Oraaka ngwateli Leví ne mndeke Leví dits Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ngwalo mriid koree, lee Jesús kon re zha kuu ngeteed lo Jesús ngwa liz Leví, ne or ndob Jesús ngeyow Jesús liz Leví, kon tyen zha kuu ntsow kobral temi chaan yezlyu ne kon re zha kuu ntsowt kuu wen, tak kwaro men mndeke dits Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tsa lee chop tson maestr chaan ley kuu nak fariseo, mne zha lee Jesús ndow kon re zha kuu ntsow kobral temi chaan yezlyu, tsa nzhab re zha lo re zha kuu ngeteed lo Jesús: ―¿Chebee nzhow zha baa, kon re zha kuu ntsow kobral temi chaan yezlyu, ne kon re zha kuu ntsowt kuu wen? ");
INSERT INTO zaoNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesús mbin kona, tsa nzhab Jesús lo re zha: ―Re zha kuu ndolizt ndechet zha cho tegwe zha, per lee re zha kuu ndoliz ndeche zha cho tegwe zha, ndyaltʼn ndyaadchezʼn re zha wen, lee na ndyal ndyaadchez re zha kuu ndab falt. ");
INSERT INTO zaoNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Re zha kuu mndeke dits Juan, ne re fariseo ntsow zha ayun, tsa mas wen tediz zha lo Diox. Tsa ngwa zha lo Jesús ne nzhab zha: ―Chebee lee re zha kuu mndeke dits Juan ne re fariseo, ntsow zha ayun, tsa mas wen tediz zha lo Diox, ne lee re zhaʼa ntsowt zha tata. ");
INSERT INTO zaoNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Lee Jesús nzhab lo re zha: ―¿Chu tak wut re zha kuu nzi lo fandan, or lee zha kuu mtseya ndoka lo re zha? ¡Rebeete! Tak dita lo ndo zha kuu mtseyaʼa lo re zha, gagt tsow zha ayun. ");
INSERT INTO zaoNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Per tetsin thib wiz yiib mbyi kuu mtseyaʼa lo re zha, tsasi lee re zha tsow ayun, tsa mas wen tediz zha lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Neeka thib zha ngibt thib le lar kub cho lar gox, tak mbich lar kub ne masraa nchatte lar gox. ");
INSERT INTO zaoNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ne neeka thib zha ngot xit ub kuu kub leen gom yid gox; tak lee xit ub kuu kub tsow ratt gom gox, ne luuzhe gom ne lee xit ub zho, kona lee xit ub kuu kub ndoblo yo leen gom yid kub. ");
INSERT INTO zaoNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Thib wiz sabd nda Jesús kon re zha kuu ngeteed lo Jesús thib ta ndab nzob xtil, ne lee re zha kuu ngeteed lo Jesús mndelo mthop ton nzob xtil. ");
INSERT INTO zaoNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tsa lee re fariseo nzhab lo Jesús: ―¿Chebee ntsow re zhaʼa, thib kuu ndoblot tsowaa wiz kuu nzhoolaa lo Diox? ");
INSERT INTO zaoNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Lee Jesús nzhab lo re zha: ―¿Chu ter lab goo kuu mtsow rey David, leettsa mlann zha kon re zha kuu nda kon lee zha? ");
INSERT INTO zaoNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mndaab zha leen liz Diox, leettsa lee Abiatar ngok ngwleyy kuu mnabee lo reta ngwleyy, ne ndow zha pan kuu ndoblot zha wu zha, kuu beeta re ngwleyy ndoblo wu, ne noga mndaa zhay ndow re zha kuu nda kon lee zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ne noga nzhab Jesús lo re zha: ―Lee wiz kuu nzhoolaa lo Diox mndaa Diox par wen rid re men ne mndaat Diox wiz par nabee wiz lo mbyi. ");
INSERT INTO zaoNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kona na nabee lo wiz sabd, tak na nak xgann mbyi, Kuu Mzin Ngok Men. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tedib welt mndaab Jesús ta nkaltaa re zha nteed zha xkiiz Diox, ne tya ndo thib mbyi kuu mbiz thib yaa. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Noga nzi thiban zha kuu ngewii, naa chu tetegwe Jesús mbyiʼa wiz kuu nzhool re zha Israel lo Diox, tsa tak keki zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tsa lee Jesús nzhab lo mbyi kuu mbiz yaaʼa: ―Gwateli, ne bto ndrol. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tsa mnaabdiz Jesús lo re zha, ne nzhab Jesús: ―¿Kwan mas wen tsowaa wiz kuu nzhoolaa lo Diox? ¿Chu ndoblo tsowaa kuu wen o kuu went? ¿Chu wen tegwe men thib zha, o chu wen kuth men thib zha? Per lee re zha neeka thib kuu mkabt zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tsa nayii mwii Jesús lo re zha kuu nzi lo Jesús: Ne nabil ngoo leettsoo Jesús, tak kwathoz nad leettsoo re zhaʼa, tsa nzhab Jesús lo mbyiʼa: ―Bteli yaaʼa. Tsa mteli zha yaa zha, ne oraaka mgwe yaa zha taxal tedib yaa zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tsa mkaltaa re fariseo kon re zha rey Herodes, tsa myaan zha diiz, naa xomod tsow zha par kuth zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Leettsa mroo Jesús tya ne nda Jesús roo nitdoo kon re zha kuu ngeteed lo Jesús, kwaro re zha yezlyu Galilea kon re zha yezlyu Judéa, mndeke dits Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ne noga re zha Jerusalén yez naro, kon zha yezlyu Idumea ngwa lo Jesús; noga ngwa re zha kuu nzo tedib lad roo yoo Jordán, re zha yez Tiro ne zha yez Sidón. Ngwa zha tak mbin zha re kuu thoz kuu ntsow Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tsa nzhab Jesús lo re zha kuu ngeteed lo Jesús: ―Btolist goo thib kano par keen, tak naroob men ndeke ditsʼn ne kwaro nzhoo re men na. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tak kwaro men mtegwe Jesús, ne lee re mbyiz nzhoo Jesús, tak nlaaz zha diinn zha cho Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ne or ngwii re mbi fyer kuu nzo leettsoo re zha lo Jesús, tsa ntsow mbi fyer ntobxub re zha lo Jesús, ne mbetsyath zha mbez zha: ―Lu nak Xgann Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kwathoz mkox re mbi fyer lo Jesús, ne nzhab Jesús: ―Yent cho lo gab goo naa cho nakʼn. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tsa mkendab Jesús yek thib yii, ne mrez Jesús re zha kuu nlaaz Jesús, ne ngwa re zha lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tsa mli Jesús tsiibchop zha par kwin kon Jesús, ne par taal Jesús zha yataa zha kwent xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ne mndaa Jesús yalnabee lo re zha, tsa koo zha re mbi fyer kuu nzo leettsoo re men. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tsiibchop re zha ree nak re zha kuu mli Jesús: Simún (kuu mtob le Jesús Pey), ");
INSERT INTO zaoNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiag ne Juan (rop zha ree nak xgann Zebedeo, kuu mtob le Jesús Boanerges, diiz ree nak: “Zhiinn bel bti”); ");
INSERT INTO zaoNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ndres, Lip, Bartolomé, Mateo, Mach, Santiag (zhiinn Alfeo), Tadeo, Simún (kuu ngoo xid partid Cananita), ");
INSERT INTO zaoNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ne Judas Iscariote (kuu mndaa Jesús lo yalguth). ");
INSERT INTO zaoNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ne mndaab Jesús kon re zha kuu ngeteed lo Jesús leen thib yuu, ne tedib welt kwathoz men mkaltaa lo Jesús, ne neeka myobt gawu re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ne mbin re zha liz Jesús kona, tsa ngwa zha gaxii zha Jesús, tak nzhab zha: ―Mbix yek Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ne lee re maestr chaan ley kuu mroo Jerusalén nzhab: ―Wlipaa yalnabee chaan Beelzebú nap Jesús, ne kon yalnabee chaan Beelzebú ngoo Jesús re mbi fyer. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tsa mrez Jesús re zha ne mni Jesús lo re zha kon diiz nanzee, ne nzhab Jesús: ―¿Xomod koo Maxuuy leeka lee Maxuuy Maxuuy? ");
INSERT INTO zaoNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Os lee thib yez nzhak chop tant ne ngyo leeka re zha, xegt yeza naroob. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ne noga os leen thib yuu nzhak chop zha, ne ngyo leeka re zha, reta zha kuu nzo leen yuuʼa xegt zha naroob tyemp. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kona os lee Maxuuy yo kon leeka lee Maxuuy, xegt yalnabee chaan Maxuuy naroob tyemp, gaxta ndo luzhe. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Ne leeka tata gagt tab thib zha leen liz thib zha ney, os ter liib zha zha, tsa tak lowann zha re chaan zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Wlipaa na nin, tekib Diox relota falt kuu ntsow men, asta kuu ngode men Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Per lee re zha kuu ngode lo Mbi Nayon chaan Diox, thitanax tuyyt Diox falta neeka mas. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Tata nzhab Jesús lo re zha, tak lee re zha nzhab mbi fyer nzo leettsoo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tya mzin xnaa Jesús kon re wets Jesús, ne mlet re zha roo yuu, tsa mtaal zha thib zha ngwachez Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ne lee re zha kuu nzi re ladta lo Jesús nzhab lo Jesús: ―Lee xnaaʼa ne re wetsa nzi lee ndiy nkwaana. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Lee Jesús mkab ne nzhab: ―¿Cho nak xnaan ne re wetsʼn? ");
INSERT INTO zaoNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tsa mwii Jesús lo re zha kuu nzi re ladta lo Jesús, ne nzhab Jesús: ―Re zha ree ndakʼn taxal xnaan ne re wetsʼn. ");
INSERT INTO zaoNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tak reta zha kuu ntsow kuu nlaaz Diox, zhaʼa nak wetsʼn, btan na ne xnaan. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tedib welt mndelo Jesús mloo Jesús lo naroob men roo nitdoo, tak kwathoz zha mkaltaa roo nitdoo, tsa mke Jesús leen thib kano, ne mndob Jesús leene lo nitdoo. Ne lee re men mrin roo nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tsa mloo Jesús tyen kuu lo re men kon diiz nanzee. Ne nzhab Jesús: ");
INSERT INTO zaoNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Kenza goo kwent kuu tan lo goo. Thib welt lee thib zha mroo ndalo bin. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Leettsa ngego zha bin, thib nete mla roo net, ne myaad re min ndowe. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tedib nete mla xid ke, ta lut yu nzo. Ne neyta mlene tak lut yu nzib ditse. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Per leettsa mla be, tee mgole ne mbize tak yent naroob lozhe. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tedib nete mla xid yits, ne lee yits mzhen ne mluux yitse, ta mod mndaate xle. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Per lee tedib nete mla lo yu naal, mlene ne mzhene ne mndaay xle. Thib nete mndaa galbtsii bin por thibka bin, lee tedib nete mndaa tson gale, ne lee tedib nete mndaa thib gayooy. Tbaa nak kwent. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ne nzhab Jesús: ―¡Os lee goo ndob nza goo, ndoblo yen goo koree! ");
INSERT INTO zaoNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Leettsa myaan Jesús kon re tsiibchop zha kuu ngeteed lo Jesús, lee chop tson zha kuu nzi gax mnaabdiz lo Jesús, naa xomod nak kwent kuu mndaa Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tsa nzhab Jesús: ―Diox mzhyal ne goo naa xomod nak re kuu nzogaats kuu nak chaan Diox, tsa ne goo xomod nabee Diox. Per lee lo re zha kuu nlaazt teke ditsʼn, pur diiz nanzee nin lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Tegal wii zhay ne yent zha kuu ngwii zha, ne tegal gon zhay per yent zhay, ta mod nyent zha xkiiz Diox ne nyelaazt zhay, tsa tuyyt Diox re falt zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tsa nzhab Jesús lo re zha: ―¿Os nyent goo koree? ¿Xomod yen goo tedib nete? ");
INSERT INTO zaoNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Lee zha kuu ngoo bin nak taxal thib zha kuu ndaa kwent xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Thib net men nak taxal bin kuu mla roo net. Leettsa nzhon zha xkiiz Diox, tsa nyaad Maxuuy nkib xkiiz Diox leettsoo zha, taxal nak bin kuu ndow min roo net. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tedib net zha nak taxal bin kuu mla xid ke, kwathoz wen nyoo leettsoo zha or nzhon zha xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Re zhaʼa nak taxal thib ya kuu yent lozh, ta mod nxegt zha, ne leettsa nzin thib yalti lo zha o ndreke zha dits zha, tak nyelaaz zha Diox, tsa tee nlaa zha Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tedib net zha nak taxal bin kuu mla xid yits, nzhon zha xkiiz Diox, ");
INSERT INTO zaoNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","per kwathoz ntsow zha xgab re kuu yezlyu ree, ndablaaz zha temi, ne reta kwaa yezlyu ree, kona nak kuu nkedi zha, re koree nluux xkiiz Diox leettsoo zha. Re zhaʼa nak taxal ya kuu ndaat xle. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Per lee re zha kuu nak taxal bin kuu mla lo yu naal. Nzhon zha xkiiz Diox, ne nkayaa zhay kon dib ndroo leettsoo zha, re zhaʼa nak taxal bin kuu mndaa galbtsii bin por thibka bin, taxal bin kuu mndaa tson gal bin ne taxal bin kuu mndaa gayoo bin. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Noga nzhab Jesús: ―Neeka thib zha nkeet thib kandil ne ntow zhay kon thib zhibey, o ngoo zhay xann luun, sinke lee zha ntobe thib ta ya ndab, tsa nteniy. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tak yent thib kuu nagaats kuu loot, ne yent thib kuu xlaan kuu net men. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","¡Os lee goo ndob nza goo ndoblo yen goo koree! ");
INSERT INTO zaoNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Noga nzhab Jesús: ―Wen kenza goo reta kuu nin. Leeka taxal ntsow goo lo re taben goo, tataka rid goo, ne asta masraa kuu rid goo. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tak lee zha kuu nap kwaa, masraay kayaa zha, per lee zha kuu yent kuu nap, asta lut kuu nap zha teyiibe lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Noga nzhab Jesús: ―Nalor tan tedib kwent, tsa ne goo xomod nak leettsa nabee Diox leettsoo men, leey nak taxal thib bin kuu ngo zha lo yu. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tegal nzhat zha o naxna zha, tse ne yaal lee bin nlen ne nzhen, per net zha naa xomod nzhene. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Leeka yezlyu nxeene. Ner nlen kottse, tsaraa nziib gatte, nla doy, nziib kwate ne nla yattse. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ne bluz leettsa nzhatslay, tsa nthop zhay, tak mzina wiz dope. Tbaa nak kwent. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Noga nzhab Jesús: ―Nal tan tedib kwent lo goo, tsa ne goo xomod nak leettsa nabee Diox leettsoo men. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Leey nak taxal thib mbiz mostaz, mbiz mostaz nak thib mbiz kuu mas lut lo re mbiz kuu nzhann men. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Leettsa nyelo nzhann mene, nlene nzhene ne nziib tyen zhite, ne ndaay xkal, ne asta ndyaad re min ndexkwaa lyaat loy. Tbaa nak kwent. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kon tyen kwent nanzee mloo Jesús xkiiz Diox lo re men. Tata mni Jesús lo re men asta plotha kuu takta yen re mene. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Leettsa ni Jesús lo re men pur nanzee ni Jesús, per leettsa nyaan Jesús kon re zha kuu ngeteed lo Jesús, tsaraa nambi ni Jesús lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Leeka wiza or mbix wiz, tsa nzhab Jesús lo re zha kuu ngeteed lo Jesús: ―Nda goo reʼaa tedib lad roo nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tsa mlaa re zha reta men kuu nzi tya, ne mkendab re zha leen kano kuu ndob Jesús. Ne noga nzi techop tson kano tya. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ne leettsa nda re zha lo nitdoo, tsa mndelo ngoth thib mbi thoz lo nitdoo, ne mndelo mbi mchop mbi kano, ne asta ndaab nit leen kano. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ne lee Jesús naxat par ya xann kano, ne mtob Jesús thib xkoog Jesús yek Jesús. Tsa lee re zha kuu ngeteed lo Jesús mloo mkaal lo Jesús, ne nzhab re zha: ―Maestr, ¿chu ndat leettsooʼa mer lowgwaa leen nitdoo? ");
INSERT INTO zaoNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Oraaka ngwache Jesús ne mkox mbi ne nitdoo lo Jesús, ne nzhab Jesús: ―¡Keeta bi! ¡Zheta gok! Ne lee nitdoo zheta ngok. ");
INSERT INTO zaoNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tsa nzhab Jesús lo re zha kuu ngeteed lo Jesús: ―¿Chebee kwathoz nzeb goo? ¿Chu ntsow goo xgab lee Diox nkenapt goo? ");
INSERT INTO zaoNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kwathoz mzegey leettsoo re zha ne kwathoz mzeb zha, ne nzhab zha lo re altaa zha: ―¿Cho nak zha ree? ¿Chebee asta mbi ne nitdoo nzhon diiz lo zha? ");
INSERT INTO zaoNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ne leettsa mzin re zha tedib lad roo nitdoo yezlyu chaan re zha Gadara. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Leettsa mla Jesús leen kano, tsa mbig thib zha kuu nzo mbi fyer leettsoo lo Jesús, zhaʼa ndende leen re kelyoo, ta nkaats zha re zha nguth. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ne leen re kelyoo ta nkaats zha re zha nguth, tya mtsow zhaʼa taxal liz zha. Ne yent cho ntsow gan liib zha neeka kon kaden. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tyen welt mliib zha zhaʼa kon kaden, per lee zhaʼa mchuug kaden ne yent cho nye lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tse ne yaal ndende zha leen re kelyoo ne leen yii, mbetsyath zha, ne leeka lee zha ngin zha zha cho re ke. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tith raa ngwani Jesús lo zha, oraaka mrezhonn zha mbig zha ne mtobxub zha lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Tsa nzhab Jesús: ―Mbi fyer broo leettsoo zha ree. Tsa dib gan zha mretsyath zha ne nzhab zha: ―Jesús. ¡Xgann Diox kuu ndob yibaa! ¡Kwan nlaaza kon nee! Naabʼn loʼa tetita nee, leettsa ter tsin wiz kuu tetiʼa nee. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tsa mnaabdiz Jesús lo zha, ne nzhab Jesús: ―¿Cho bleʼa? ―Nee le kwathoz, tak kwathoz tyen nee ―nzhab zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Lee re mbi fyer kwathoz mnaab lo Jesús, tsa koot Jesús re mbi fyera yezlyuʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ne gax chu yii tya nzi naroob nguch ngeyow. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tsa lee re mbi fyera kwaro mnaab lo Jesús, ne nzhab: ―Taal nee lo re nguch baa, ne taa diiz tab nee leettsoo re maa baa. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tsa mndaa Jesús diiz mndaab re mbi fyera leettsoo re ngucha. Ne nzhak teeka chop mil nguch, tsa mrezhonn re maa ne mrethin maa roo kedoo, ne mla maa leen nitdoo ne ngwaap maa nit. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ne lee re zha kuu nkenap re ngucha, mzhonn ngwalo diiz lo re zha yez kuu ngok, ne noga nzhab zhay lo re zha kuu nzi wan. Tsa ngwatwii re zha yez naa kwan ngok. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Leettsa mzin re zha ta ndo Jesús, tsa mwii zha mbyi kuu ngoo mbi fyer leettsoo, ndoba nok xab ne mgweʼa mbyi, ora mzeb re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ne lee re zha kuu mwii kuu ngok kon mbyi kuu ngoo mbyi fyer leettsooʼa, ne kuu ngok kon re nguch, nzhab zhay lo re altaa zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tsa mnaab re zha yeza lo Jesús ne nzhab zha: ―Broo nzhee. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ne leettsa mretab Jesús leen kano tedib welt, lee zha kuu ngoo mbi fyer leettsooʼa, mnaab lo Jesús ne nzhab: ―Laaʼa teken ditsa. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Per lee Jesús mzhyalt, ne nzhab: ―Tyee liza lo re zha liza, ne guz re kuu mtsow Zha Nabee loʼa, ne xa mlat leettsoo zha mne zha lu. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tsa ndya zha ne nzhab zha re kuu mtsow Jesús lo zha, lo re zha re tsii yez kuu nak Decápolis, ne reta zha re yeza mzegey leettsoo. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Leettsa ngwalo mriid Jesús tedib lad roo nitdoo, myaanka Jesús leen kano, ne naroob men mkaltaa lo Jesús roo nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tsa mzin Jairo thib zha kuu nataak ta nkaltaa re zha kuu nteed xkiiz Diox, ne or mwii zha Jesús, mtobxub zha xann nii Jesús, ");
INSERT INTO zaoNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ne kwaro mnaab zha lo Jesús, ne nzhab zha: ―Lee rtsaapʼn mer gath. De toba yaaʼa dits nzaa, tsa gwe nzaa ne ban nzaa. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tsa ngwa Jesús kon lee zha, ne naroob men mndeke dits Jesús, ne kwathoz nzhoo re men Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ne xid re mena ndyaad thib ngot mbyiz, kuu ndaʼa tsiibchop liin nlath ren leettsoo, ");
INSERT INTO zaoNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ne kwathoz ndakti zha, reta temi zha kuu nap zha mluuzha zha lo re doctor, ne ngwet zha, leel masraa mndezhoo yiz kuu ndak zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ne leettsa mbin zha re kuu ngetsow Jesús, tsa mndaab zha xid re men kuu nzi lo Jesús, ne mzin zha par dits Jesús ne mdiinn zha xab Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tak mtsow zha xgab: “Os leen diinn na xab Jesús, tegwen”. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ne or mdiinn zha xab Jesús, oraaka mlet kuu nlath ren leettsoo zha, ne myeen zha lee zha mgweʼa lo yiz kuu ndak zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Oraaka myeen Jesús lee Jesús mtegwe thib zha kon yalney chaan Jesús, tsa mtsere lo Jesús, ne mnaabdiz Jesús lo re zha kuu ndeke dits Jesús, ne nzhab Jesús: ―¿Cho mdiinn xabʼn? ");
INSERT INTO zaoNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Lee re zha kuu ngeteed lo Jesús nzhab: ―¿Chu ngwiita re ladta nzhoo zha lu? Ne naabdiza: “¿Cho mdiinn xabʼn?” ");
INSERT INTO zaoNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Per lee Jesús mwii re ladta, naa cho kuu mdiinn xab Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tsa lee ngota kwathoz mzeb, tak tata nzhab Jesús, oraaka mbig ngot ne mtobxub ngot lo Jesús, ne nzhab ngot kuu wli. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Tsa nzhab Jesús lo ngot: ―Rtsaapʼn, tak ngwalaaza na kona mgweʼa. Wen tyee yat leettsooʼa, tak mgweʼa lu lo yiz kuu mzhaaka. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Bee ngenika Jesús, lee chop tson zha liz Jairo mzin, nzhab lo Jairo: ―Ngutha rtsaapa. ¿Chebee ngenika lu lo maestr? ");
INSERT INTO zaoNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Per lee Jesús mbin kona, tsa nzhab Jesús lo Jairo: ―Tsebta. Anta gwalaaz xkizʼn kon dib ndroo leettsooʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ne mndaat Jesús diiz gateke choraa dits Jesús, beeta Pey, Santiag ne Juan wets Santiag. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Or mzin re zha liz Jairo, tsa mwii Jesús lee re zha kuu nzi tya nzhonn ne mbetsyath. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tsa mndaab Jesús leen yuu, ne nzhab Jesús: ―¿Chebee kwathoz nkee goo bi ne nzhonn goo? Ngutht nzaa, beeta naxat nzaa. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tsa mzhizno re zha kuu nzi tya Jesús, per lee Jesús mnabee mroo reta zha leen yuu, ne mndeno Jesús xnaa nzaa, xut nzaa ne re yon zha kuu ngeteed lo Jesús, tsa mndaab re zha leen yuu ta nax nzaa. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tsa mzhen Jesús yaa nzaa ne nzhab Jesús lo nzaa: ―Talita kumi. (Diiz ree nak: “Nzaa, loʼa nin, ¡gwache!”) ");
INSERT INTO zaoNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Oraaka ngwache nzaa ne mnde nzaa, ne lee nzaa nap tsiibchop liin. Ne reta zha kuu mwii kona kwathoz mzegey leettsoo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Per lee Jesús mnabee lo re zha, ne nzhab: ―Yent cho lo gab goo kuu ngok. Noga nzhab Jesús lo zha: ―Taa goo kuu wu nzaa. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Mroo Jesús tya ne ndya Jesús laz Jesús, kuu nak Nazaret, kon re zha kuu ngeteed lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Leettsa ngok wiz sabd, wiz kuu nzhool re nee kuu nak zha Israel lo Diox, tsa mloo Jesús lo re men, ta nkaltaa zha nteed zha xkiiz Diox. Ne kwathoz mzegey leettsoo re zha mbin zha kuu nzhab Jesús, tsa nzhab zha lo altaa zha: ―¿Pa ngwateed zha ree re kuu nzhaak zha? ¿Ne cho mndaa yalnzhaak lo zha? ¡Kona nzhaak ntsow zha re kuu thoz kuu gagt tsow re men yezlyu ree! ");
INSERT INTO zaoNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¡Zha ree nak karpinter zhiinn Mari! ¡Ne re wets zha nak: Santiag, Che, Judas ne Simún ne re btan zha nzi loʼaa nzhee! Kona nataagt Jesús lo re zha, ne nzhont zha diiz lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tsa nzhab Jesús lo re zha: ―Lee re profet kuu ntaal Diox nataak zha reta ta, per lee laz zha ne lo re zha liz zha nataagt zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kona ngogt gatsow Jesús kwaro kwaa laz Jesús, beeta chop tsonta zha mxoob Jesús yaa Jesús yeke ne mtegwe Jesús zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kwathoz mzegey leettsoo Jesús, mne Jesús lee re tawlaz Jesús nyelaazt Jesús. Tsa mroo Jesús tya ne ngwa Jesús re yez kuu nzi gaxta tya, ne mloo Jesús lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tsa mrez Jesús re tsiibchop zha kuu ngeteed lo Jesús, ne mtaal Jesús chopga chopga zha, ne mndaa Jesús yalnabee lo re zha, tsa koo zha mbi fyer leettsoo re men. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Noga nzhab Jesús lo re zha: ―Be goo thibka aga ne yent raa kwan gwe goo, neeka bols, neeka kuu wu goo ne neeka temi. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Anta labyid kuu nke nii goo be goo, ne ndoblot gwe goo chop net xab goo. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ne noga nzhab Jesús lo re zha: ―Loka yuu ta tsin goo, tya kwet goo, asta leettsa bi goo tya. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ne os thib ta kayaat zha goo, ne neeka tyalt zha gon zha xkiiz goo, broo goo tya ne btsib goo yuyaaz kuu mke nii goo, tsa ne re zha yeza lee re zhaʼa went nak, tak mkayaat zha goo. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ne mroo re zha ngwataa zha kwent xkiiz Diox ne mbez zha, btsee goo mod went kuu nak goo ne btob yek goo xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Noga mloo zha kwaro mbi fyer leettsoo re men, ne mndaab zha aseyt re mbyiz ne mtegwe zha re mbyiz. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ne lee rey Herodes mbin re kuu ntsow Jesús, tak reta ta nyath re kuu ntsow Jesús. Tsa nzhab rey Herodes: ―Juan kuu mtsowleyy mroban, tata mod nzhaak ntsow zha re kuu gagt tsow re men yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Lee tedib net zha mbez: ―Lee zha nak Lí kuu ngok profet ndala. Ne tedib net zha nzhab: ―Lee zha nak thib re profet kuu ngoo ndala. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Or mbin rey Herodes re kona, tsa nzhab rey Herodes: ―¡Lee zha nak Juan kuu mtaalʼn mchuug zha yek, ne nal mroban zha! ");
INSERT INTO zaoNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tak kwent chaan Herodías, mnabee rey Herodes mzhen zha Juan, mliib zha Juan kon kaden ne mloo zha Juan tsib. Herodías nak tsaal Lip wets rey Herodes. Per lee rey Herodes nak rop Herodías. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ne lee Juan nzhab lo rey Herodes: ―Went kenoʼa tsaal wetsa. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kona mnayii Herodías mne Juan, ne nlaaz Herodías kuth Juan, per gagt tsow zhay. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Tak nzeb rey Herodes ne Juan, noga ne rey Herodes lee Juan nak thib mbyi wen ne nayon lo Diox, kona nkenap rey Herodes Juan. Ne or kuu nkenza rey Herodes xkiiz Juan net rey Herodes naa kwan tsow rey Herodes, ne kwathoz nyow leettsoo rey Herodes nzhon xkiiz Juan. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Per mtsow rey Herodes thib ani naro, leettsa mzaal rey Herodes liin, ne mrez rey Herodes re zha kuu nabee lo yezlyu, re zha kuu nabee lo thib mil soldad ne re zha kuu mas nataak kuu nabee yezlyu Galilea. Tsa lee Herodías mwii tak tsow Herodías thib kwaa. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tsa lee rtsaap Herodías mndaab ta nzo ani ne mkani, ne kwathoz myow leettsoo rey Herodes ne re zha kuu nzi tya xa mkani nzaa, tsa nzhab rey Herodes lo nzaa: ―Bnaab loka kuu nlaaza lon, ne lee na tay. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ne mtselo rey kruz ne nzhab rey: ―Loka kuu naaba na taay, ne asta garol yezlyu ta nabeen tatan loʼa nzhab rey. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ora mroo nzaa ne mnaabdiz nzaa lo xnaa nzaa, ne nzhab nzaa: ―¿Kwaan naabʼn? Lee xnaa nzaa nzhab: ―Bnaab yek Juan kuu ntsowleyya. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Oraaka nda nzaa ta ndob rey, ne nzhab nzaa lo rey: ―¡Nalorka nlazʼn taaʼa yek Juan kuu ntsowleyya lon leen thib yann! ");
INSERT INTO zaoNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Or mbin rey kona, kwathoz nabil ngoo leettsoo rey, tak mtselo rey kruz nzhab rey lee rey tsowe, ne reta zha kuu nzi lo ani mbin kuu nzhab rey, kona ngogt raa gatsee rey xkiiz rey. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Oraaka mtaal rey Herodes thib soldad, tsa yaxii soldad yek Juan. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tsa lee soldad ngwa leen tsib mga yek Juan, ne mloo zhay leen thib yann, ne ndyaadno zhay ne mndaa zhay lo nzaa, ne lee nzaa mndaay lo xnaa nzaa. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Or mbin re zha kuu ngeteed lo Juan lee Juan nguth, tsa ngwanaab zha kwerp Juan mkaats zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tsaraa lee re zha kuu ngeteed lo Jesús kuu noga le apóstl, mkaltaa kon Jesús, ne mndaa re zha kwent re kuu mtsow zha ne re kuu mloo zha lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tsa nzhab Jesús lo re zha: ―De goo, nda goo anta leeʼaa thib ta yent men, tsa roxkwanaa lut. Tak kwaro men nda ndyaad ne neeka yobt wu re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tsa ngoo Jesús beeta kon re zha kuu ngeteed lo Jesús leen kano, ne ndya re zha thib ta yent men. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ne naroob men mwii lee re zha nda, ne mlebee re men Jesús; tsa reta men re yez nda par tya, ne ner re mena mzin nake Jesús kon re zha kuu ngeteed lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Leettsa mla Jesús leen kano, mwii Jesús naroob men, tsa mlat leettsoo Jesús mne Jesús re zhaʼa, tak taxal mbak zhiil kuu napt bzhaan nzhak zha, ne mndelo Jesús mloo kwaro kuu lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ne leettsa ndaʼa or, lee re zha kuu ngeteed lo Jesús mbig lo Jesús, ne nzhab zha: ―Mziʼa yezlyu ne nzhee nak thib ta yubiz. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Bchaats re men, tsa ya re zha re ranch kuu nzi gax nzhee, tsa tii zha kuu wu zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Per lee Jesús mkab lo re zha, ne nzhab: ―Taa goo kuu wu zha. Tsa nzhab re zha: ―¿Chu nlaaza yati nee chop gayoo denario pan, tsa taa nee kuu wu re zha? ");
INSERT INTO zaoNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Lee Jesús nzhab lo re zha: ―¿Plal pan nap goo? ¡Gwa goo gwatwii goo! Ora ngwatwii re zha, tsa nzhab zha: ―Gaay pan ne chop mbel. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tsa mnabee Jesús lo re zha tob zha por grupga lo yizhwan. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ne mndob zha por grupga, nzo ta mrin thib gayooga zha, ne nzo ta mrin garol gayoo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tsa mzhen Jesús re pan ne rop mbel ne mwii Jesús lobee ne mndaa Jesús texkix lo Diox, ne mtsow rol Jesús pan ne mndaa Jesús pan lo re zha kuu ngeteed lo Jesús, tsa taa zhay lo re men, tataka mtsow rol Jesús rop mbel, ne mndaa re zhay lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Reta men ndow asta plotha mze leettsoo re men. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ne mrozhoob tsiibchop chekwit pan byu ne mbel. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ne lee re men kuu ndow pan tya ngok teeka gaay mil mbyi. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Leettsa ngwalo ngok kona, ora mtaal Jesús re zha kuu ngeteed lo Jesús, tsa mke re zha leen kano, par rid zha tedib lad roo nitdoo, par tsin zha yez kuu le Betsaida. Lee Jesús myaanka chaats re men. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Or ngwalo mchaats Jesús re men, ora ngwa Jesús yek yii ngwatediz Jesús lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ne leettsa mkow yezlyu lee kano ndaʼa ndrol nit ne lee Jesús myaan thita yubiz, ");
INSERT INTO zaoNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ne mwii Jesús lee re zha kuu ngeteed lo Jesús, kwathoz ndakti kon kano lo nitdoo, tak kwathoz nax mbi. Ne zhaaraa na lee Jesús nde ndyaad lo nitdoo, mtsow Jesús taxal zha kuu nlaaz ner lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Or mwii re zha lee Jesús ndyaad lo nitdoo, mtsow re zha xgab, kuu fyera ne mretsyath re zha; ");
INSERT INTO zaoNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","tak reta zha mwiiy ne mzeb zha. Per ora lee Jesús mni lo re zha ne nzhab: ―¡Bloney goo leettsoo, tsebt goo nay! ");
INSERT INTO zaoNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tsa mke Jesús leen kano ta nzo re zha, ne lee mbi mlet; kwathoz mzegey leettsoo re zha mwii zha kuu mtsow Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tak myent re zha naa kwan mtsow Jesús kon re pan, tak ter tsow Diox yen zhay, tak mkow yek zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tsa mriid Jesús kon re zha kuu ngeteed lo Jesús tedib lad roo nitdoo, tsa mzin re zha yezlyu Genesaret, tya mkedo zha kano roo nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Per or mla re zha leen kano, lee reta men mlebee Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tsa lee re men lijer ngwalo diize re yez gax, ne mbe re men re mbyiz ne nxoob zha re mbyiz lo da ne nyadtaan zha mbyiz ta ndo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ne reta ta ndaab Jesús re ranch re yez bzhizh ne re yez naro, nyadtaan zha re mbyiz roo yuulow ne roo net ne naab zha lo Jesús, laa Jesús diinn zha xab Jesús; ne lee re zha kuu ndiinn xab Jesús ngwe zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Thib wiz mkaltaa thiban fariseo lo Jesús, kon thiban maestr kuu nloo ley, re zhaʼa ndyaad desde yez Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Or mwii re zhaʼa lee chop tson zha kuu ngeteed lo Jesús, nat zha nzhow zha, tsa mkeki re fariseo re zha Jesús. Tak ntsowt zha kuu mtsow re tey zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tak lee re fariseo ne reta zha Israel ntsow zha re kuu mloo tey zha lo zha, os lee zha nat zha, wut zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Or ndretab zha nya zha lo xbi, wut zha os ter tsow zha kuu mloo tey zha lo zha, kuu nak na zha, ne kwaro re kuu tata ntsow zha, taxal nteech zha re tas, re yann ne re yet wen wen. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tsa lee re fariseo ne re maestr chaan ley mnaabdiz lo Jesús, ne nzhab zha: ―¿Chebee lee re zha kuu ngeteed loʼa ntsowt zha re kuu mloo teyaa, nat zha nzhow zha? ");
INSERT INTO zaoNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús mkab lo zha, ne nzhab: ―¡Zha nkedi nak goo, zhaa kuu mbez ne zhaa kuu ntsow goo! Wen wen mndaa profet Isaí kwent naa xomod nak goo. Or kuu nzhab zha: Lee re zha yez ree beeta kon roo zha nzhool zha lon, ne lee leettsoo zha tith ndo lon. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nataagt nzhool goo lon, tak kuu nloo goo nak leyy chaan re men. Is. 29:13 ");
INSERT INTO zaoNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Thib lad nlaa goo xkiiz Diox, leettsa ntsow goo re kuu mloo re tey goo. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Noga nzhab Jesús lo re zha: ―Thib lad nlaa goo kuu nabee Diox tsow goo, leettsa ntsow goo re kuu mloo tey goo lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tak lee Moisés nzhab: “Bke leettsooʼa xuta ne xnaaʼa”. Ex. 20:12 Noga nzhab lo ley: “Lee zha kuu ngode xute ne xnaa, beth goo zha”. Ex. 21:17 ");
INSERT INTO zaoNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Per lee goo mbez goo: Tak gab zha lo xut zha ne lo xnaa zha: “Gagt raa tsowʼn ayuda, tak reta kuu nkenon nak korban”. (Diiz ree nak: “Retay mndan lo Diox”.) ");
INSERT INTO zaoNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ne noga mbez goo, zha kuu tata gab, ndoblot raa tsow zha ayud xut zha ne xnaa zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tata mod ntsow nataagt goo xkiiz Diox, kon re kuu mloo tey goo lo goo, ne kwaro re kuu tata ntsow goo. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tsa mrez Jesús re men, ne nzhab Jesús lo re zha: ―Bin goo xkizʼn ne byen gooy. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Neeka thib kuu ndaab par roo zha, gagt tsow nambite zha lo Diox, sinke re kuu went kuu ntsin leettsoo zha, kona ntsow nzhak nambit zha lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","¡Os lee goo ndob nza goo ndoblo goo yen goo koree! ");
INSERT INTO zaoNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Leettsa mlaa Jesús re men tsa mndaab Jesús leen thib yuu, ne lee re zha kuu ngeteed lo Jesús mnaabdiz lo Jesús, ne nzhab: ―Xomod nak kwent kuu mndaaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tsa nzhab Jesús: ―¿Chu no goo nyente? ¿Chu nyent goo neeka thib kuu ndaab par roo zha, gagt tsow nambite zha? ");
INSERT INTO zaoNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tak ndaabte leettsoo zha, leey ndaab leeyy zha, ne tsaraa ndrooy. Kon diiz ree nlaaz Jesús ne, reta kuu tak wu men tak nambiy. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ne noga nzhab Jesús: ―Re kuu went kuu ntsin leettsoo zha, kona ntsow nzhak nambit zha lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tak leen leettsoo zha ndroo re xgab went kuu nak: Gak rop zha kon ndota zha, lowann zha, kuth zha taben zha, ");
INSERT INTO zaoNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","gak rop zha kon zha kuu nagt tsaal zha, ndablaaz zha keno zha reta kwaa, ntsow zha reta kuu went, nkedi zha, ntsow zha re kuu nlortsint, nawent nzhak leettsoo zha ne zha chaan tedib zha, ndediz zha diiz yix, ndrub zha, ngobeet zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Reta kuu went ree ntsin leettsoo zha, ne ntsowe nzhak nambit zha lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Leettsa mroo Jesús yezlyu Galilea, tsa nda Jesús yezlyu Tiro ne Sidón, ne mndaab Jesús leen thib yuu, tak nlaazt Jesús yeen choraa zha pa ndo Jesús. Per ngogt gakaslo Jesús, ");
INSERT INTO zaoNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","tak kwathoz lijer myeen thib ngot kuu nap thib nzaa, kuu nzo mbi fyer leettsoo pa ndo Jesús, ngota ndyaad lo Jesús ne mtobxub ngot lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Lee ngota nak thib zha tith zha yez Sirofenicia, ne mnaab ngota lo Jesús, tsa koo Jesús mbi fyer kuu nzo leettsoo rtsaap ngot. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Per lee Jesús nzhab lo ngot: ―Laa wu re ndyeen bzhizh ner, tak went kib zha pan lo re ndyeen ne taa zhay lo re mbak. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Lee ngot mkab ne nzhab: ―Wliy, Zha Nabee, per noga mbak nzhow mbak re kuu kuu ndrethin ya ndyeen nzhab xann mes. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Lee Jesús nzhab lo ngot: ―Wen mkaba, tyee lee mbi fyer mrooʼa leettsoo rtsaapa. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Or mzin ngot liz ngot, lee rtsaap ngot ndoba roo luun, ne lee mbi fyer mrooʼa leettsoo rtsaap ngot. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tsa mroo Jesús yez Tiro ne mriid Jesús yez Sidón ne re tsii yez kuu nak Decápolis, tsa mzin Jesús roo nitdoo chaan Galilea. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ne tya ngwano re men thib zha kuu nakwee ne mud lo Jesús, ne mnaab zha, tsa xoob Jesús yaa Jesús dits zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tsa ndeno Jesús zha thib lad lo re men, ne mtob Jesús kwen Jesús leen nza zha, ne kon nzuk mdiinn Jesús lo loz zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ora mwii Jesús lobee ne mndii leettsoo Jesús, ne nzhab Jesús lo mbyiʼa: ―¡Efata! (Diiz ree nak: “¡Bxaal!”) ");
INSERT INTO zaoNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Oraaka lee nza zha mzhaal, ne lee loz zha mgwe ne wen mndediz zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tsa mteni Jesús re zha, tsa yent cho lo gab zha kuu mtsow Jesús; per leel masraa mndediz zhay. ");
INSERT INTO zaoNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kwaro mzegey leettsoo re men, ne nzhab re men: ―¡Xomod ntsow zha ree re kuu tenzhee! ¡Ntsow zha nzhaal nza zha kuu nakwee, ne ntsow zha ndediz zha mud! ");
INSERT INTO zaoNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ne lee re wiza mkaltaa naroob zha, ne napt zha kuu wu zha. Tsa mrez Jesús re zha kuu ngeteed lo Jesús, ne nzhab Jesús lo re zha: ");
INSERT INTO zaoNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Nlat leettsoon nen re zha ree, tak ndaʼa tson wiz nzi reʼaa nzhee, ne terka wu zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Os leen taalʼn zha liz zha ne wut zha, cha layaal zha net, tak thiban zha ndyaad tith. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tsa lee re zha kuu ngeteed lo Jesús, mkab lo Jesús ne nzhab: ―¿Per xomod taaʼaa loww naroob men thib ta yubiz, taxal nzhee, ta yent cho nak? ");
INSERT INTO zaoNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tsa mnaabdiz Jesús lo re zha, ne nzhab Jesús: ―¿Plal pan nap goo? Tsa nzhab re zha: ―Gaze. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tsa mnabee Jesús lo re men tob zha lo yu, ne mzhen Jesús re gaz pan ne ngwalo mndaa Jesús texkix lo Diox, mtsow rol Jesús pan ne mndaa Jesús pan lo re zha kuu ngeteed lo Jesús, ne lee re zha mdide lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Noga nap re zha chop tson mbel; ne mndaa Jesús texkix lo Diox por re mbela ne mnabee Jesús mdid zha maa. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Reta zha ndow asta mze leettsoo zha, ne mtse zha gaz chekwit ngoo re kuu byu kuu mrozhoob. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ne teeka thap mil zha ndow, tsaraa mchaats Jesús re zha ndya zha laz zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tsaraa lee Jesús kon re zha kuu ngeteed lo Jesús, mke re zha leen kano ne ndya zha yezlyu kuu le Dalmanuta. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tsa mzin re fariseo ne mndelo zha mbyodiz zha kon Jesús, tak nlaaz zha ne zha naa chu wli kuu ni Jesús. Tsa nzhab re zha lo Jesús: ―Tsow thib kwaa kuu beeta Diox tak tsow, tsa ne nee lee Diox mtaala. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús mndii leettsoo ne nzhab: ―¿Chebee naab re men ree thib seny kuu gagt tsow re men? Wlipaa na kuu nin lo goo, neeka thib kuu thoz tsowtʼn lo re men nal tyemp ree. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tsa mlaa Jesús re men, ne mre Jesús mndaab leen kano ne ndya re zha tedib lad roo nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ne mtelaazt re zha kuu ngeteed lo Jesús gagwe zha kuu wu zha, thibka zha ne tsaka pan. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ne leettsa nda re zha leen kano, tsa nzhab Jesús lo re zha: ―Bkenap goo goo lo lebadur chaan re fariseo ne lo lebadur chaan rey Herodes. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ora lee re zha mndelo nzhab lo altaa: ―Tbaa ne zha, tak mtelaaztaa gagweʼaa pan. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús myeen kuu ngetediz re zha, tsa mnaabdiz Jesús lo re zha, ne nzhab Jesús: ―¿Chebee mbez goo napt goo pan? ¿Chu bee ter yen gooy? ¿Chu thitanax mkow yek goo par yen gooy? ");
INSERT INTO zaoNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Nap goo ngutlo goo ne nyenite lo goo, nap goo nza goo ne nzhont gooy? ¿Chu thitanax ntelaazt goo? ");
INSERT INTO zaoNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Leettsa mtsow rolʼn pan ndow thib gaay mil mbyi, ¿plal chekwite mrozhoob? ―Tsiibchope ―nzhab re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Ne leettsa mtsow rolʼn pan ndow thib thap mil mbyi, ¿plal chekwite mrozhoob? ―Gaze ―nzhab re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tsa nzhab Jesús: ―¿Chu terka yen gooy? ");
INSERT INTO zaoNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Leettsa mzin re zha yez kuu le Betsaida, tsa lee thiban zha ndyaadno thib mbyi syeg lo Jesús, ne nzhab re zha lo Jesús: ―Tsow yalwen bxoob yaaʼa dits mbyi ree, tsa gwe mbyi. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tsa mzhen Jesús yaa syeg ne mloo Jesús zha thib lad roo yez, ne mtenit Jesús lo zha kon nzuk, ne mxoob Jesús yaa Jesús yek zha, oraaka mnaabdiz Jesús lo zha, ne nzhab Jesús: ―¿Chu nyeniʼa loʼa? ");
INSERT INTO zaoNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Lee syeg mndelo mwii ne nzhab: ―Nloo re zha lon, taxal ya nloo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tsa mre Jesús mdiinn ngutlo syeg, ¡ora lee syeg mwii, tak mgweʼa ngutlo zha ne reta kuu mloo lo zha! ");
INSERT INTO zaoNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tsa mtaal Jesús zha liz zha, ne nzhab Jesús lo zha: ―Ridta leen yez. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Leettsa lee Jesús ne re zha kuu ngeteed lo Jesús, ngwa re ranch chaan yezlyu kuu le Cesarea-Filipo. Ne or ndo re zha net, tsa mnaabdiz Jesús lo re zha kuu ngeteed lo Jesús, ne nzhab Jesús: ―¿Cho nakʼn ni re men? ");
INSERT INTO zaoNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Lee re zha nzhab: ―Thib net zha mbez lee lu nak Juan kuu mtsowleyy, tedib net zha mbez lee lu nak profet Lí zha ndala, ne lee tedib net zha ni lee lu nak thib re profet. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","―Lee re goo, ¿cho nakʼn ndak goo? Pey mkab ne nzhab: ―Lu nak Crist Kuu Mtaal Diox Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Per lee Jesús mnabee lo re zha ne nzhab: ―Neeka thib lo zha gabt goo koree. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesús mndelo mloo lo re zha kuu ngeteed lo Jesús, ne nzhab Jesús lo re zha: ―Na nak xgann mbyi, Kuu Mzin Ngok Men, ne ndoblo ridʼn yalti, ne neeka kayaat re zha gol na neeka re ngwleyy kuu nabee lo re ngwleyy, neeka re maestr chaan ley. Ne kuth re zha na, per leettsa tsaal tson wiz lee na roban. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nambi nzhab Jesús koree. Tsa mloo Pey Jesús thib lad, ne mndelo mkox Jesús lo Pey. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Per lee Jesús mtsere lo mwii lo re zha kuu ngeteed lo Jesús, ne mkox Pey lo Jesús ne nzhab Jesús: ―¡Beche lon, lu nak taxal Maxuuy! Ntsowta xgab taxal ntsow Diox xgab; lu ntsow xgab taxal ntsow re men xgab. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tsa mrez Jesús re zha kuu ngeteed lo Jesús ne re men, ne nzhab Jesús: ―Os lee thib goo nlaaz teke ditsʼn, ndoblo laa goo reta kuu nap goo, ne reta kuu nzo yek goo tsow goo, ne ndoblo thib ko goo leettsoo goo gath goo, tak nyelaaz goo na. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Os lee thib zha nzeb zha gath zha, tak nyelaaz zha na, tsowt zhaʼa gan yalnaban kuu thitanax. Per lee zha kuu nzebt gath, tak nyelaaz zha na, zhaʼa tetsow gan yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Per kwan tsow zha gan keno zha reta kwaa nzo yezlyu ree, ne tsowt zha gan yalnaban yibaa. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Neeka thib kwaa gagt taa zha lo Diox, par tsow zha gan yalnaban kuu thitanax yibaa. ");
INSERT INTO zaoNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Os lee thib zha nthoy zha ne zha na ne xkizʼn xid re men tyemp ree, re men kuu thitanax mlaa Diox ne thitanax went nak, noga na Kuu Mzin Ngok Men, tethoyʼn nen zhaʼa, leettsa bretabʼn kon xni chaan Xutʼn ne kon re mandad Xutʼn kuu nayon. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Noga nzhab Jesús: ―Wlipaa na nin lo goo, nzo goo kuu nzi nzhee, gatht goo asta wii goo naa xa nabee Diox, kon yalnabee chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Leettsa mzaal xoop wiz lee Jesús ndano anta Pey, Santiag ne Juan zhaata, ne ngwa re zha thib yii naro, tya mzee mod na Jesús lo re yon zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kwathoz mla xni xab Jesús, naguz mlooy, tegal mas teech zha lar, ne tsowt zha gan looy tata. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ne mloo lo re zha lee Lí ne Moisés ngetediz lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tsa nzhab Pey lo Jesús: ―Maestr, kwathoz wen nzi nee nzhee; nal taa nee tson ramad, thibe par lu, tedibe par Moisés ne lee tedibe par Lí. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tata nzhab Pey tak kwathoz mzeb re zha, ne neeka net Pey naa kwan nzhab Pey. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ne oraaka lee thib xkow mla ne mtow re yon zha, ne xid xkowa mroo thib bos kuu nzhab: ―Zha ree nak xgann na kuu kwathoz nke leettsoon, bin goo diiz lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ne or mwii re zha re ladta lo re zha, yent raa cho mwii zha, anta Jesús ndo. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Or kuu ndyaadla re zha mroo zha yek yii, tsa nzhab Jesús lo re zha: ―Yent cho lo gab goo re kuu mloo lo goo, asta tsin wiz kuu lee na, Kuu Mzin Ngok Men roban. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ne mbin re zha diiz, ne yent cho lo nzhab zhay, per kwaro welt naabdiz zha lo altaa zha, naa xomod nak kuu roban men nguth. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tsa mnaabdiz re yon zha lo Jesús ne nzhab zha: ―¿Chebee ni re maestr kuu nloo xkiiz Diox, ner profet Lí zha ndala yaad? ");
INSERT INTO zaoNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Lee Jesús nzhab: ―Wli lee Lí ner yaad, tsa to list zha re kwaa. Ne ¿chebee nzhab xkiiz Diox: “Lee na Kuu Mtaal Diox Ngok Men, ndoblo ridʼn yalti ne tsow nataagt re men na”? ");
INSERT INTO zaoNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Per lee na ni lo goo, lee Lí myaada ne mtsow re men loka kuu nlaaz re men lo Lí, taxal nkey lo xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Leettsa mretab Jesús kon Pey, Santiag ne Juan, tsa mzin Jesús ta nzi reta zha kuu ngeteed lo Jesús, tsa mwii Jesús kwaro men nzi lo re zha, ne lee re maestr chaan ley ngeyodiz kon re zha kuu ngeteed lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ne or mwii re zha Jesús, reta zha mzegey leettsoo ne mrezhonn zha mni zha “diox” lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tsa mnaabdiz Jesús lo re zha, ne nzhab Jesús: ―¿Kwan ngeyodiz goo kon tedib net zha baa? ");
INSERT INTO zaoNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tsa lee thib zha kuu ndo xid re mena mkab ne nzhab: ―Maestr, lee na ndyaadno xgann na loʼa, tak nzo thib mbi fyer leettsoo nyo, ne mtaan mude nyo. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ndota ta ndo nyo lee mbi fyer nden nyo ne ngobiy nyo lo yu; ne ntsowe ndroo btsiin roo nyo ne ntube keley nyo ne nteliy nyo. Kona kwathoz mlache nyo. Ne mnaaba na lo re zha kuu ngeteed loʼa, tsa koo zha mbi fyer baa leettsoo nyo, per ngogt gatsow zhay. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús mkab ne nzhab: ―¡Cho klas men nak goo! ¿Chebee nyelaazt goo lee Diox tak tsow koree? ¿Asta pol ton lo goo? ¿Asta pol kez leettsoon nen goo? Deno goo nyo nzhee. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tsa ngwano zha nyo lo Jesús, per or mwii mbi fyer Jesús, ora mlobi mbi fyer nyo lo yu ne mtsow mbi fyer mzhaak nyo yizguthye. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús mnaabdiz lo xut nyo ne nzhab: ―¿Pol mndelo yiz ree lo nyo? Lee xut nyo mkab ne nzhab: ―Asta lut nyo mziibe. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ne kwaro welt ngobi mbi nyo lo ki ne lo nit, tak nlaaz mbi kuth mbi nyo, os leeʼa tak kooʼa mbi fyer baa leettsoo nyo, blat leettsooʼa neʼa nee, btsow ayud nee. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Lee Jesús nzhab: ―¿Chebee mbeza chu take? ¡Reta kuu tak, os leeʼa nyelaaz luy! ");
INSERT INTO zaoNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tsa lee xut nyo mrez dib gan ne nzhab: ―Nyelaz nay, btsow ayudʼn tsa masraa yelaz nay. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ne or mwii Jesús kwaro men ndetsin, tsa mkox mbi fyer lo Jesús ne nzhab Jesús: ―Mbi fyer kuu ntsow nakwee nyo ne kuu tsow mud nyo. Na nabee loʼa, broo leettsoo nyo ne bret raa lu taba leettsoo nyo tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tsa lee mbi fyer mretsyath ne mtsow mzhaak nyo yizguthye tedib welt, ne mroo mbiʼa leettsoo nyo ne mtaane nyo taxal zha nguth. Ne lee re zha kuu nzi tya nzhab: ―Nguth nyo. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Per lee Jesús mzhen yaa nyo ne mlit Jesús nyo, tsa ngwateli nyo. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tsaraa mndaab Jesús kon re zha kuu ngeteed lo Jesús leen thib yuu, tsa mnaabdiz re zha lo Jesús, ne nzhab zha: ―¿Chebee ngogt gagoo nee mbi fyera? ");
INSERT INTO zaoNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Lee Jesús nzhab: ―Reta mbi kuu tabaa gagt rooy tabaata, ner ndoblo naab mene lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tsa mroo re zha tya ne mriid zha yezlyu Galilea. Per lee Jesús nlaazt ne re men naa pa ndo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ne mloo Jesús lo re zha kuu ngeteed lo Jesús, ne nzhab Jesús: ―Na nak Zha Kuu mtaal Diox Ngok Men, ne taa zha na lo re zha kuu nak tsiin ne kuth zha na, per leettsa tsaal tson wiz lee na roban. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Per lee re zha myent zha kuu nzhab Jesús, ne nzeb zha naabdiz zha lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ne mzin re zha thib yez kuu le Capernaúm, or mzin re zha thib yuu. Tsa lee Jesús mnaabdiz lo re zha, ne nzhab: ―¿Kwaan mbyodiz goo net? ");
INSERT INTO zaoNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Per neeka thib zha mkabt, tak leettsa ndo re zha net nzhab re zha: “¿Choʼaa nak zha kuu mas nataak?” ");
INSERT INTO zaoNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tsa mndob Jesús ne mrez Jesús re tsiibchop zha kuu ngeteed lo Jesús, ne nzhab Jesús lo re zha: ―Os lee thib goo nlaaz gak zha kuu mas nataak, ndoblo gak goo zha kuu lortsin lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ne mto Jesús thib ndyeen lut ndrol, ne mdeez Jesús ndyeen, ne nzhab Jesús: ");
INSERT INTO zaoNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Loka cho nkayaa thib ndyeen lut tak nyelaaz zha na, noga nkayaa zha na, ne noga nkayaa zha, zha kuu mtaal na. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tsa nzhab Juan lo Jesús: ―Maestr, ne nee lee thib zha ngoo mbi fyer kon leʼa, per nagt zha, zhaʼaa, kona nzhab nee lo zha: “Tsowt raa luy”. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tsa nzhab Jesús: ―Blaa goo yent kwan gab goo lo zha. Tak thib zha kuu ntsow thib kuu thoz kon len, ndoblot looz zha na, or ngwalo mtsow zhay. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tak reta zha kuu nayiit neʼaa nzo zhaʼa faboraa. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Wlipaa na nin, loka cho taa thib bas nit gu goo, tak nak goo zha da, wlipaa na lee Diox kizhe lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Loka cho tsow lee thib re zha kuu nyelaaz na ne nzhon diiz xkizʼn tsow kuu went, mas wen liib zha thib ke naro yen zhaʼa ne kobi zha zhaʼa leen nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Os lee thib yaaʼa ntsow ntsowa thib kuu went, ta bchuuge mas wen tunka ne tsowa gan yalnaban kuu thitanax, nake nkenoʼa rop yaaʼa ne ndyaʼa gabil ta thitanax nyuyyt bel, ");
INSERT INTO zaoNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ta neeka mbyaat nluxt, ne neeka nyuyyt bel. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ne os lee thib niiʼa ntsow ntsowa kuu went taa bchuuge, mas wen tunka ne tsowa gan yalnaban kuu thitanax, nake nkenoʼa rop niiʼa ne ndyaʼa gabil. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ta neeka mbyaat nluxt ne neeka nyuyyt bel. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Os lee thib ngutloʼa, ntsow ntsowa kuu went, taa blooy mas wen nkenoʼa thibka ngutloʼa ne tsowa gan yalnaban kuu thitanax, nake nkenoʼa rop ngutloʼa ne ndyaʼa gabil, ");
INSERT INTO zaoNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ta neeka mbyaat nluxt ne neeka nyuyyt bel. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Reta men gak natsig kon ki. ");
INSERT INTO zaoNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Wen ted leettsa natsig ted, per os lee ted natsigt raa ted, gagt raa gak natsig ted tedib welt, ndoblo gak natsig goo taxal ted lo re men yezlyu ree, ne wen brin goo re altaa goo. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tsa mroo Jesús yez Capernaúm ngwa Jesús yezlyu Judea, tedib lad roo yoo Jordán, tya mre mkaltaa re men lo Jesús, tsa mloo Jesús lo re men, taxal ntsowka Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tsa mzin re fariseo, ne mnaabdiz zha lo Jesús, ne nzhab zha: ―¿Kwaan nzhab lo ley? ¿Chu tak laa thib mbyi tsaal mbyi? Tata nzhab zha, tak nlaaz zha keki zha Jesús, tsa tak ten zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tsa nzhab Jesús lo re zha: ―¿Xomod nzhab lo ley chaan Moisés? ");
INSERT INTO zaoNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tsa nzhab re zha: ―Moisés nzhab, tak laa mbyi tsaal mbyi, anta ndoblo taa mbyi thib yeets kuu mroo yuulow, ta nzhab lee mbyi mtso rop tsaal. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tsa nzhab Jesús lo re zha: ―Tata nzhab Moisés lo re teyaa tak kwathoz nad zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Per leettsa mdexkwaa Diox yezlyu, thibka mbyi ne thibka ngot mtsaal Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kona nzhab Diox: “Lee mbyi ndoblo roo zhaa mbyi lo xut mbyi ne lo xnaa mbyi, tsa tseya mbyi kon ngot mbyi, ");
INSERT INTO zaoNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ne lee rop zha gak taxal thibka zha”. Gn. 2:24 Kona nagt raa zha chop zha, sinke thibka men nak zha rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Diox mtsaal rop zha, kona ndoblot laa mbyi tsaal mbyi. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Leettsa ndoʼa Jesús kon re zha kuu ngeteed lo Jesús yuu, tsa mnaabdiz re zha lo Jesús leeka kona. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tsa nzhab Jesús lo re zha: ―Loka cho mbyi kuu laa tsaal, ne kaa mbyi tedib ngot, ndaa mbyi thib falt ro lo tsaal mbyi kuu ner, ");
INSERT INTO zaoNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","noga ngot kuu laa tsaal, ne kaa ngot tedib mbyi, ndaa ngot thib falt ro lo tsaal ngot kuu ner. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ne myaadno re men re ndyeen bzhizh lo Jesús, tsa xoob Jesús yaa Jesús yek re ndyeen, per lee re men kuu ndyaadno ndyeen mkox lo re zha kuu ngeteed lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Or mwii Jesús kona, mnayii Jesús lo re zha kuu ngeteed lo Jesús, ne nzhab Jesús: ―Laa goo yaad re ndyeen lon, ne towt goo lo ndyeen, tak Diox nabee leettsoo re zha kuu nak taxal re ndyeen. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Wlipaa na kuu nin lo goo, loka cho goo taat diiz nabee Diox leettsoo goo, taxal re ndyeen ree, gagt tab goo ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ne mdeez Jesús re ndyeen, ne mxoob Jesús yaa Jesús yek re ndyeen, ne mnaab Jesús lo Diox tsa kenap Diox re ndyeen. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Thib wiz or ndaroo Jesús roo yez, mrozhonn thib zha ne mtobxub zha lo Jesús, ne nzhab zha: ―Maestr wen, ¿kwan tsowʼn tsa tsowʼn gan yalnaban kuu thitanax? ");
INSERT INTO zaoNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús mkab lo zha: ―¿Chebee, zha wen neʼa lon? Neeka thib zha wen yent, beeta Diox nak zha wen. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ne, neʼa lu re kuu mtaan Diox tsowa. Kuu nak re koree: Kuthta tabena, gagt ropa kon thib zha kuu nagt tsaala, lowannta, kedita, bke leettsooʼa xuta ne xnaaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tsa mkab zha ne nzhab zha: ―Desde lutʼn ngetsowʼn reta kona. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús mwii lo zha ne mke leettsoo Jesús zha, tsa nzhab Jesús lo zha: ―Thibka kuu ter tsowa, tyee ne btho reta kuu napa ne btaay lo re prob, tsa kenoʼa kwaro kwaa yibaa, ne bteke ditsʼn. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Per leettsa mbin zha tata nzhab Jesús lo zha, kwathoz nabil ngoo leettsoo zha, tak naroob kwaa nap zha, ne ngoo zha net ndya zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tsa mwii Jesús lo re zha kuu ngeteed lo Jesús, ne nzhab Jesús: ―Kwathoz nagan laa thib zha rik nabee Diox leettsoo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ne kwathoz mzegey leettsoo re zha kuu ngeteed lo Jesús, leettsa mbin zha kona, per lee Jesús mre mni lo re zha, ne nzhab: ―Re goo kuu nak taxal Xgann na, aka kwathoz nagan tab thib zha rik ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas nagant rid thib kamey yeer kuu le ngutlo abuj, nake tab thib zha rik ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Reta zha kuu ngeteed lo Jesús kwathoz ntsow zha xgab, ne nzhab zha: ―Os leey tabaay, ¿cho kuu tsow gan ndya yibaa tsa? ");
INSERT INTO zaoNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús mwii lo re zha, ne nzhab lo re zha: ―Lo re men yezlyu ree gagte, per lee Diox reta kuu tak tsow Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tsa lee Pey nzhab lo Jesús: ―Per lee re nee, reta kuu mlaa nee, ne ndeke nee ditsa. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ne lee Jesús nzhab: ―Wlipaa na nin, loka cho zha laa liz, wets, btan, xut, xnaa, zhiinn, o yu zha, tak nyelaaz zha na ne nlaaz zha taa zha kwent Diiz Chul chaan da, ");
INSERT INTO zaoNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","wlipaa na gayoo welt tebre, liz zha, wets zha, btan zha, xnaa zha, zhiinn zha, ne yu zha lo zha, per noga teteriid re zha zha yalti lo yezlyu ree, per tetsin wiz kuu lee zha kayaa yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Wiza lee zha kuu nataak nal gak zha kuu nataagt raa tsya, ne lee zha kuu nataagt nal zhaʼa gak zha kuu nataak tsya. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tsa ngoo Jesús net nda Jesús yez Jerusalén, ne mndener Jesús lo re men kuu ndeke dits Jesús, ne kwathoz mzegey leettsoo re zha, ne kwathoz ntsow zha xgab. Tsa mndeno Jesús re zha kuu ngeteed lo Jesús tedib lad, ne nzhab Jesús re kuu rid Jesús lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ne nzhab Jesús: ―Bin goo koree. Nda goo reʼaa Jerusalén ta taa zha na Kuu Mtaal Diox Ngok Men, lo re ngwleyy kuu nabee lo re ngwleyy, lo re maestr kuu nloo xkiiz Diox, ne lo re zha kuu nagt zha Israel, tsa kuth re zha na. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Zhizno zha na, kin zha na, tsuk zha lon ne kuth zha na, per leettsa tsaal tson wiz lee na roban. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Santiag ne Juan kuu nak rop xgann Zebedeo, ngwa lo Jesús ne nzhab: ―Maestr, nlaaz nee tsowa thib yalwen kuu naab nee loʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tsa mkab Jesús ne nzhab Jesús: ―¿Kwan nlaaz goo? ");
INSERT INTO zaoNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tsa lee rop zha nzhab: ―Taa diiz tob thib nee lad ban ne lee tedib nee tob lad beg loʼa, leettsa nabeeʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tsa nzhab Jesús lo rop zha: ―Net goo kwan ngenaab goo. ¿Chu texek goo rid goo yalti kuu mera riidʼn, ne gath goo taxal gathʼn? ");
INSERT INTO zaoNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tsa nzhab rop zha: ―Texek nee. Jesús nzhab lo rop zha: ―Wli teriid goo yalti taxal rid nay ne gath goo taxal gathʼn. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Per tobʼn goo lad ban ne lad beg lon, nagt na cho taa kona. Leey kayaa re zha kuu naka diiz kayaay. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ne or mbin tedib tsii zha kuu ngeteed lo Jesús kona, tsa mnayii zha mne zha Juan rop Santiag. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tsa mrez Jesús re zha, ne nzhab Jesús lo re zha: ―Wen ne goo, lee re zha kuu nabee lo yezlyu ree, kwathoz nabee zha lo re zha kuu nzi lo zha, ne tataga re zha kuu nataak kwathoz nabee zha lo re zha zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Per lee lo re goo, gagte tata, zhaa gake, loka cho nlaaz gak zha kuu nataak lo re goo, zhaʼa ndoblo gak zha kuu lortsin lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ne loka cho nlaaz nabee lo re goo, zhaʼa gak zha kuu lortsin lo re goo. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tak na nak Zha Kuu Mzin Ngok Men, ne ndyaltʼn tsa lortsin re men lon, sinke lee na ndyalʼn tsa lortsin na lo re men, ne gathʼn por re men, tsa telaan naroob men lo yalguth, ne tan yalnaban lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tsa ngwa re zha yez Jericó, ne leettsa lee Jesús ndarooʼa roo yeza kon re zha kuu ngeteed lo Jesús, ne kon re men kuu mndeke dits Jesús. Tsa lee thib zha syeg kuu le Bartimeo ndob ngenaab gon roo net, zhaʼa nak xgann Timeo. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Leettsa mbin syeg lee Jesús zha yez Nazaret nda tya, tsa mndelo syeg mrez dib gan ne nzhab: ―Jesús xgann David, blat leettsooʼa neʼa na. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tsa lee tyen zha mnayii lo syeg, ne nzhab zha lo syeg: ―¡Tow rooʼa! Per lee syeg masraa mrez, ne nzhab: ―Jesús xgann David, blat leettsooʼa neʼa na. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tsa mlet Jesús ne nzhab Jesús: ―Brez goo zha. Tsa mrez zha syeg ne nzhab zha lo syeg: ―Wen bloo leettsooʼa ne gwateli, tak lee Jesús ngebez lu. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Lee syeg mkee thibka brink ne mlobi xabits thib lad ne mbig lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Tsa mnaabdiz Jesús lo syeg, ne nzhab Jesús: ―¿Kwaan nlaaza tsowʼn loʼa? Lee syeg mkab ne nzhab: ―Maestr, nlazʼn yeni lon. ");
INSERT INTO zaoNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Lee Jesús nzhab lo zha: ―Tyee, tak kon dib ndroo leettsooʼa ngwalaaza leeʼa gwe, kona mgweʼa. Ne oraaka lee lo zha mzhaal, ne mndeke zha dits Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Or kuu ndetsin gaxa re zha yez naro Jerusalén, tsa mzin re zha gax rop yez kuu le Betfagé ne Betania, gax yii kuu le Olib, tsa mtaal Jesús chop zha kuu ngeteed lo Jesús, ");
INSERT INTO zaoNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ne nzhab Jesús lo rop zha: ―Gwa goo yez kuu nzi baa. Ne or tab goo yeza, tya yetsal goo thib burr yeen kuu ndekedoo, thib maa kuu neeka thib zha ter ke. Xak goo maa ne yaadno goo maa. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ne os cho naabdiz lo goo ne: “¿Chebee ntsow goo kobaa?” Tsa gab goo lo zha: “Lee Zha Nabee ndeche maa, tsaraa yaadtaan zha maa”. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ne ngwa rop zha ne mzal zha burr, lee burr ndekedoo roo pwert thib lad roo net ne mxak zha burr. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ne lee chop tson zha kuu nzi tya mnaabdiz lo rop zha ne nzhab: ―¿Kwan ngetsow goo? ¿Chebee ngexak goo burr? ");
INSERT INTO zaoNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Lee rop zha mkab taxal nzhab Jesús lo zha, tsa mlaa re zhaʼa rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ne ndyaadno rop zha burr lo Jesús, ne mxoob re zha xab zha dits maa, tsa mke Jesús dits maa. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kwaro zha mdix xab laaz net, ne tedib net zha mga baat ne mdix zhay laaz net. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ne lee re zha kuu ndener ne re zha kuu ndeke, tenzhee mbez re zha: ―¡Aka wen nak Diox! ¡Wen nak zha kuu ndyaad kon le Zha Nabee! ");
INSERT INTO zaoNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Aka wen leettsa nabee zha taxal mnabee teyaa David zha ndala! ¡Kwathoz wen nak Diox kuu ndob yibaa! ");
INSERT INTO zaoNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tsa mndaab Jesús leen yez naro Jerusalén, ne ngwa Jesús lee roo gwodoo ne mwii Jesús re ladta, ne mziʼa yezlyu, tsa nda Jesús yez Betania kon re zha kuu ngeteed lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tedib wiz leettsa mroo re zha yez Betania, mlann Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ne tith mloo thib ya ig kuu ndab la lo Jesús, tsa ngwa Jesús lo ya naa chu ndab xle lo ya. Per or mzin Jesús xann ya yent xle lo ya, beeta la ndab lo ya, tak nagt tyemp kuu ndaa ya xle. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tsa nzhab Jesús lo ya ig: ―Neeka tedib welt wut raa zha xle loʼa. Ne mbin re zha kuu ngeteed lo Jesús, kuu nzhab Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Leettsa mzin Jesús yez naro Jerusalén, tsa mndaab Jesús lee roo gwodoo naro, ne mndelo Jesús mloo re zha kuu ntho, ne re zha kuu ndi. Ne mlobi Jesús re mes chaan re zha kuu ntsiil temi, ne mlobi Jesús re asi chaan re zha kuu ntho palom. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Neeka thib re zha kuu ndyaadno kuu ntho, mlaat Jesús gariid lee roo gwodoo. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ne mndelo Jesús mloo Jesús lo re men ne nzhab Jesús: ―Lo xkiiz Diox nzhab: “Lee lizʼn nak yuu ta ndediz re men lo Diox”, per lee re goo ntsowe taxal liz wann. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ne mbin re ngwleyy ne re maestr kuu nloo xkiiz Diox re kuu nzhab Jesús, tsa mndelo zha nkwaan zha naa xomod kuth zha Jesús, tak nzeb re zha ne zha re men yez, tak reta men yez nyow leettsoo xa nloo Jesús, ne kwathoz mzegey leettsoo re zha xa nloo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Per leettsa mziʼa yezlyu, tsa mroo Jesús kon re zha kuu ngeteed lo Jesús yeza. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ne til tedib wiza, leettsa mriid re zha lo ya ig, tsa mwii zha lee dib lozh ya mbiz. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tsa mtelaaz Pey kuu nzhab Jesús tedib wiza, tsa nzhab Pey lo Jesús: ―Maestr, wii lee ya ig kuu mlodeʼa mbiza. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús mkab ne nzhab: ―Gwalaaz goo kon dib ndroo leettsoo goo, lee Diox tak tsow reta kwaa. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Wlipaa na nin lo goo, loka cho thib zha kuu gab lo yii ree: “Beche nzhee ne bla leen nitdoo”, ne os gagt chop xgab zha, sinke yelaaz zha lee Diox tak tsowe ne leey gak. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tata nin lo goo, reta kuu naab goo lo Diox, gwalaaz goo lee Diox taay ne tekayaa gooy. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ne or tediz goo lo Diox, bloo goo yek goo reta kuu went kuu mtsow taben goo lo goo, tsa noga Xutaa kuu ndob yibaa, tuyy reta kuu went kuu mtsow goo. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tak os lee goo koot goo yek goo, re kuu went kuu mtsow taben goo lo goo, noga Xutaa kuu ndob yibaa tuyyt zha reta kuu went kuu ntsow goo lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tsa mre re zha yez Jerusalén, ne or lee Jesús ndiy lee roo gwodoo, tsa ngwa re ngwleyy kuu nabee lo re ngwleyy, re maestr chaan ley ne re zha gol lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tsa nzhab re zha lo Jesús: ―¿Cho mndaa diiz loʼa ntsowa koree? Ne ¿cho nabee loʼa tsow luy? ");
INSERT INTO zaoNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús mkab ne nzhab: ―Noga na naabdizʼn thib kuu lo goo. Os lee goo kab goo kuu naabdizʼn lo goo, tsasi tenin lo goo naa cho mndaa diiz ntsowʼn koree. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Cho mtaal Juan kuu mtsowleyy re men? ¿Chu Diox mtaal zha o re men mtaal zha? ¡Kab goo! ");
INSERT INTO zaoNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tsa lee re zha mndelo zha nzhab zha lo re altaa zha: ―Os leeʼaa gabaa: “Diox mtaal zha”, tsa ne zha loʼaa: “¿Chebee ngwalaazt goo kuu ne zha?” ");
INSERT INTO zaoNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ne os leeʼaa gabaa: “Re men mtaal zha…”, per gagt gabaa tata ―nzhab re zha. Tak nzeb re zha ne zha re men, tak ne re men yez lee Juan nak profet kuu mndaa kwent xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Tsa nzhab re zha lo Jesús: ―Net nee cho mtaal zha. Tsa nzhab Jesús lo re zha: ―Neeka na nitʼn lo goo, naa cho mndaa diiz ntsowʼn koree. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tsa mndelo Jesús mni lo re zha por kwent nanzee, ne nzhab Jesús: ―Lee na ta thib kwent chaan thib zha kuu mxeen luts ub dita lo yu, ne mtow zha dibe kon btsin ke, ne mdexkwaa zha thib ta tii zha ub. Noga mdexkwaa zha thib yuu naro ta nloo dita lo yu zha lo zha. Ne mndaa zha yu zha lo tedib net zha gaane, ne mroo zha nda zha tith. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ne leettsa mzin tyemp kuu thop zha ub, tsa mtaal zha thib mos zha lo re zha kuu ngonn lo yu zha, tsa tsow rol zha re ub kuu dop. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Per lee re zha kuu nzhann lo yu zha mzhen zha mos ne mdin zha mos, ne yent kwan mndaa zha lo mos, or kuu mtaal zha mos. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tsa lee zha kuu nak chaan yu mre mtaal tedib mos, per lee re zha kuu nzhann lo yu mdin mos, ne mle zha yek mos, ne mloo zha yalnathoy chaan mos ne mzhizno zha mos. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tsa lee zha kuu nak chaan yu mre mtaal tedib mos, per lee re zha kuu nzhann lo yu mbeth zha mos. Tsa lee zha kuu nak chaan yu mtaal tyen mos, per thib net mos mloo zha grid, lee tedib net mos mbeth zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Neeka tedib mos myaant raa lo zha kuu nak chaan yuʼa, beeta thibka xgann zha, kuu kwathoz nke leettsoo zha. Per mas bluz mtaal zha xgann zha, tak mtsow zha xgab nzhab zha: “Lo xgann na si ton re zha diz”. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Per lee re zha kuu nzhann lo yu zha nzhab lo altaa: “Zha ree kayaa yu leettsa gath zha kuu nak chaan yu, nda kuthaa zha tsa yaan dita yu loʼaa, ne gake chaanaa”. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tsa mzhen re zha xgann zha kuu nak chaan yuʼa ne mbeth zha zha, ne mni re zha zha thib lad ta nzhannt zha, tabaa nak kwent. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tsa mnaabdiz Jesús lo re zha, ne nzhab Jesús: ―¿Kwan ntsow goo xgab? ¿Kwan tsow zha kuu nak chaan luts ub? Yaad zha, ne kuth zha re zha kuu ngonn lo yu zha ne taa zha yu zha lo tedib net zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Chu ter lab goo lo xkeets Diox? Ta nzhab: Lee ke kuu mni re zha kuu ndexkwaa yuu, leey nak thib ke kuu mas wen kuu ndob skin yuu. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Lee Diox, Zha Nabee mtsow koree, ne kwathoz nzegey leettsooʼaa mwii leey. Sal. 118:22-23 ");
INSERT INTO zaoNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tsa mkwaan re zha naa xomod ten zha Jesús, tak myeen re zha lee kwent nanzee kuu mndaa Jesús, ndaa kwent naa xomod nak re zha, per nzeb re zha ne zha re men, tsa mlaa re zha Jesús ne ndya zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tsa mtaal re fariseo chop tson fariseo, ne chop tson zha rey Herodes ngwa lo Jesús, tsa naa kwan gab Jesús lo re zha, tsa tak keki zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Or mzin re zha lo Jesús ne nzhab zha: ―Maestr, nee ne leeʼa nak thib zha wen ne nali, ndat leettsooʼa re kuu ni zha lu, ne yewal niʼa lo re men, ne ngwiita chu nataak zha o nataagt zha, sinke nali nlooʼa xnet Diox. ¿Chu ndoblo nee kix nee kwent chaan yezlyu lo Gobyern César kuu nabee Roma, o chu ndoblot kix neey? ");
INSERT INTO zaoNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Per lee Jesús neʼa naa kwan ntsow re zha xgab, tsa nzhab Jesús lo re zha: ―¿Chebee nlaaz goo keki goo na? Deno goo thib temi Roma lon, tsa wii nay. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tsa ndyaadno zha thib temi lo Jesús, ne mnaabdiz Jesús lo re zha, ne nzhab Jesús: ―¿Cho yek, ne cho le nke loy? Tsa mkab re zha, ne nzhab zha: ―Chaan gobyern César. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tsa lee Jesús mkab ne nzhab lo re zha: ―Btaa goo lo César kuu ndoblo César, ne btaa goo lo Diox kuu ndoblo Diox. Or mbin re zha tata nzhab Jesús, kwathoz mzegey leettsoo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tsa ngwa chop tson saduceo lo Jesús, re zhaʼa ntsow xgab: “Lee re men nguth robant”. Tsa ngwanaabdiz zha lo Jesús ne nzhab zha: ");
INSERT INTO zaoNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestr, Moisés mkee lo xkeets Diox nzhab: “Os lee thib mbyi kuu mtseya nguth ne mkenot mbyi neeka thib zhiinn mbyi, tsa lee wets mbyi ndoblo tseya kon tsaal mbyi kuu ngutha, tsa keno wets mbyi zhiinn mbyi, tsa luxt raz chaan mbyi”. Dt. 25:5 ");
INSERT INTO zaoNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Thib welt ngoo gaz zha re wets zha. Lee zha kuu ner mtseya ne nguth, ne mkenot zha neeka thib zhiinn zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Lee tedib wets zha kuu ndeke dits zha mtseya kon ngota, ne noga zhaʼa nguth ne neeka thib mbet mkenot zha, ne tataka ngok kon zha myon. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ne tataka re gazta wets zha mtseya kon ngota, ne neeka thib zha mkenot zhiinne kon ngota, ne bluz noga ngot nguth. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Leettsa roban re men, ¿cho gak tsaal ngota, tak re gazta zha mkaa ngot? ");
INSERT INTO zaoNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tsa mkab Jesús, ne nzhab Jesús: ―Lee na ni lo goo, ¡ngwatsaa xgab goo! Tak nyent goo xomod nak xkiiz Diox. ¿Chu net goo kwathoz ney Diox ne tak tsow Diox reta kwaa? ");
INSERT INTO zaoNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Leettsa roban re men, neeka mbyi ne neeka ngot tseyat raa, sinke lee zha gak taxal re mandad chaan Diox kuu nzo yibaa. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wli lee re zha nguth roban, ¿chu ter lab goo xkeets Diox kuu mkee Moisés leettsa mni Diox lo Moisés xid bel chaan ya bxiid? Leettsa nzhab Diox lo Moisés: “Lee na nak Diox chaan Abraham, Diox chaan Isaac ne Diox chaan Kob”. Ex. 3:6 ");
INSERT INTO zaoNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","¡Nagt Diox, Diox re zha nguth, lee Diox nak Diox lo re men kuu naban! ¡Thitanax ngwatsaa xgab goo! ");
INSERT INTO zaoNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tsa mzin thib maestr kuu nloo xkiiz Diox, kuu mbin lee Jesús kon re saduceo mbyodiz. Ne mwii zha lee Jesús wen mkab lo re zhaʼa. Tsa mbig zha ne mnaabdiz zha lo Jesús, ne nzhab zha: ―¿Cho diiz kuu mkee Moisés, nak diiz kuu mas nataak kuu mnabee Diox tsow men? ");
INSERT INTO zaoNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Lee Jesús mkab ne nzhab: ―Lee diiz kuu mas nataak lo reta diiz kuu mnabee Diox nak: “Kenza goo men Israel, lee Diox kuu nabee loʼaa thibka nak. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bke leettsooʼa Diox kon dib ndroo leettsooʼa, kon dib yalnabana, kon dib xgaba ne kon dib yalney chaana.” Dt. 6:4-5 Diiz ree nak kuu mas nataak lo reta diiz. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ne lee tedib diiz kuu kwathoz nataak nak: “Bke leettsooʼa tabena, leeka taxal nke leettsooʼa lu”. Lv. 19:18 Yent raa tedib diiz kuu mas nataak taxal rop diiz ree. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tsa lee maestr kuu nloo xkiiz Diox nzhab lo Jesús: ―¡Wli luy, maestr! ¡Thibka Diox nzo ne yent raa tedib zha kuu mas nataak nake Diox! ");
INSERT INTO zaoNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ne ke leettsoo men Diox kon dib ndroo leettsoo men, kon dib xgab men, kon dib yalnaban men, kon dib yalney chaan men ne ke leettsoo men taben men taxal nke leettsoo men leeka lee men. Mas nataak koree nake reta maa kuu nzhuth zha, por re falt zha ne re gon kuu nteyy zha lo bkoog. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ne ne Jesús lee maestr mkab kon yalnzhaak, tsa nzhab Jesús lo maestr: ―Mera nabee Diox leettsooʼa. Tsa lee re zha kuu nzi tya mzeb naabdiz tedib kwaa lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Or ngeloo Jesús lo re men lee roo gwodoo chaan re zha Israel, tsa nzhab Jesús: ―¿Chebee lee re maestr kuu nloo xkiiz Diox mbez: “Lee Crist Kuu taal Diox Nabee, nak thib zha raz chaan David”? ");
INSERT INTO zaoNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ne leeka David mni por Mbi Nayon chaan Diox ne nzhab: Diox Kuu Nabee reta kwaa, nzhab lo Zha Kuu Nabee lon: “Tob lad ban chon, asta tsigʼn re zha kuu nayii neʼa xann niiʼa; tsa tobxub zha loʼa”. Sal. 110:1 ");
INSERT INTO zaoNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ne leeka David nzhab lo zha: “Zha Nabee lon”. ¿Xomod gak zha zha raz chaan David? Ne kwathoz men kuu nzi nzhon xkiiz Jesús tya, ne kon dib ndroo leettsoo zha nzhon zhay. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Or kuu ngeloo Jesús lo re men, ne nzhab Jesús: ―Kenap goo goo, tsa kedit re maestr kuu nloo xkiiz Diox goo. Lee re zhaʼa nyow leettsoo zha tiy zha kon lar wen, tsa ni re men “diox” lo zha lo xbi. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ne nkwaan zha re ta mas nataak tob zha leen yuu ta nkaltaaʼaa nteedaa xkiiz Diox, ne re ta mas nataak nyetob zha leettsa nyoo ani, ");
INSERT INTO zaoNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ne nkib zha liz re ngot byud, ne kwathoz tetse naab zha lo Diox, par tak kaats zha re kuu ntsow zha. ¡Per mas naroob yalti teriid Diox re zhaʼa! ");
INSERT INTO zaoNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Thib welt ndo Jesús lee roo gwodoo chaan re zha Israel, gax ta ngo re zha gon leen alkansi. Tsa mwii Jesús ngo re zha gon leen alkansi, ne tyen re zha rik ngo naroob temi leen alkansi. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ora mzin thib ngot byud kuu kwathoz prob, ne mloo ngot chopka temi kuu lut nataak leen alkansi. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tsa mrez Jesús re zha kuu ngeteed lo Jesús, ne nzhab Jesús lo re zha: ―Wlipaa na kuu nin lo goo, mas nataak gon kuu mloo ngot byud baa leen alkansi, nake kuu mloo re zha rik. ");
INSERT INTO zaoNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tak reta zha rik mloo zha temi kuu mrozhoob lo zha, per lee ngot prob baa mndaa ngot reta temi kuu nden ngot, par tii ngot kuu wu ngot. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Or mroo Jesús roo gwodoo lee thib zha kuu ngeteed lo Jesús nzhab: ―¡Wii na, maestr! ¡Aka nabii re ke chaan gwodoo ree, ne kwathoz wen natexkwaa re yuu chaan gwodoo! ");
INSERT INTO zaoNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Per lee Jesús mkab ne nzhab: ―Kwathoz naro gwodoo ree. ¡Per nzhee neeka thib ke yaant dits tedib ke, reta koree lux! ");
INSERT INTO zaoNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tsa ngwa re zha yek thib yii kuu le Olib, tya nloo gwodoo, ne or ndob Jesús, tsa lee Pey, Santiag, Juan ne Ndres, mnaabdiz re zha zhaata lo Jesús, ne nzhab re zha: ");
INSERT INTO zaoNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Nlaaz nee neʼa loo nee naa pol gak re koree. ¿Ne cho seny loo lo nee, leettsa gak re koree? ");
INSERT INTO zaoNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús mkab ne nzhab: ―List gwatsin goo tsa yent cho kedi goo. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kwathoz tyen zha yaad ne ne zha: “Na nak Crist Kuu Mtaal Diox Nabee”. Ne kedi zha kwathoz men. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Per leettsa gon goo lee zhoo nzo nzhee ne baa, tsebt goo, tak tata ndoblo gake, per nagt kona kuu lux yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tsa lee thib nación yo kon tedib nación, ne thib yez kon tedib yez ne tyen ta kwathoz ney gwin zho thoz, ne kwathoz ta la win, tsya neeka net re men naa kwan tsow re men, leettsa gak re koree, penta telo re men rid yalti. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Per list gwatsin goo, tak tataa zha goo lo re zha kuu nataak lo re zha Israel, ne kee zhay yek goo ta nkaltaa re men nteed xkiiz Diox. Ne noga tataa zha goo lo re zha kuu nabee ne lo re gobyern, tak nyelaaz goo na. Per tenzhee tak taa goo kwent chaan da lo re zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Leettsa ter lux yezlyu, reta men ndoblo gon Diiz Chul chaan Diox dib naxta lo yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Leettsa kwez zha goo ne yataa zha goo lo re zha nak tsiin; yat leettsoo goo ne neeka tsowt goo xgab naa kwan gab goo, tak lee Mbi Nayon chaan Diox ne lo goo naa kwaan ndoblo goo gab goo ora. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tsya leeka wets zha kuu nyelaazt Diox taa zha lo yalguth; ne tataka leeka xut zha taa xgann zha; ne lee xgann zha gak bi lo xut, tsa kuth zha xut zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Reta men yii ne goo tak nyelaaz goo na, per loka cho xek rid re koree, zhaʼa tsow gan yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Per leettsa wii goo, lee kuu kwathoz went kwib ta ndoblote kwibe, taxal nzhab profet Daniel. (Loka cho zha lab koree, ndoblo zhaʼa yen zhaʼay.) Tsa lee re zha kuu nzo yezlyu Judea ndoblo zhonn net yii. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ne lee re zha kuu ndob yek yuu wiza, neeka ndoblot la zha ne ya zha leen liz zha, par koo zha thib chaan zha; ");
INSERT INTO zaoNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ne lee re zha kuu ndo wan, neeka ndoblot zha bretab zha par thop zha xab zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Per kwathoz nabil rid re ngot kuu nzozhiinn ne re ngot kuu nap mbetdoo wiza! ");
INSERT INTO zaoNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bnaab goo lo Diox, tsa gagt koree tyemp kuu nla yig. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tak lee re wiza, gak thib wiz kuu mas rid re men yalti, nake reta yalti kuu mriid re men lo yezlyu ree, desde leettsa mdexkwaa Diox yezlyu, ne yot raa tedib yalti kuu tata bluz. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ne os lee Zha Nabee gatsow nadopt re wiza, neeka thib zha laat lo yaltiʼa, per mtsow nadop zhay, tak nke leettsoo zha re zha kuu mli zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Ne re wiza, os lee thib zha ne lo goo: “Wii nzhee, lee Crist Kuu Mtaal Diox Nabee ndo nzhee”. O “wii lee zha ndo baa”, yelaazt goo xkiiz zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tak yaad re zha kuu kedi; re zha kuu wlit nak profet chaan Diox, ne tsow zha re kuu thoz kuu gagt tsow re men, ne loo zha seny thoz, ne os take, asta re zha kuu mli Diox kedi zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","List gwatsin goo, tak reta kuu mniʼa na lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Ne re wiza, leettsa ngwaloʼa mriid re men yalti, tsa lee wiz ne mbee taat raa xni. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ne lee re mbel rethin lobee, ne lee re kuu nzo lobee zhiit. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tsa wii re zha lee na Zha Kuu Mtaal Diox Ngok Men, yaalʼn leen xkow kon kwathoz yalney ne xni. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tsa taalʼn re mandad da thop re zha kuu mlin dita lo yezlyu, desde thib lad lo yezlyu ne asta tedib lad lo yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Bteed goo lo ya ig, leettsa lee zhite nziib ne nziib lay, tsa ne goo lee mbee beyi mzin gaxa. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tataka leettsa ne goo lee re koree ngeyak, ndoblo yen goo lee wiza ndetsin gaxa. Ne lee na, Kuu Mzin Ngok Men, ndoʼa roo pwert. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Wlin kuu nin lo goo, reta koree gak leettsa terka gath re men tyemp ree. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Lee yezlyu ne lee lo lobee telux per lee xkizʼn ridte, retay ndoblo gak. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Per lee wiza ne ora yent cho ney; neeka re mandad chaan Diox, neeka Xgann Diox, beeta Xutʼn Zha Nabee ney. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Ne list gwatsin goo kenap goo goo, tak net goo pol tsin wiza. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Koree nak taxal thib zha mroo nda tedib yez. Ne leettsa mroo zha liz zha mlaa zha re mos zha, tsa kenap re mos liz zha. Ne mndaa zha tsiin tsow re mos, ne mtaan zha re mos, ne mto zha thib mos kuu kenap roo yuu. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kona list gwatsin goo, tak net goo naa pol yaad zha kuu nabee yuu. Cha yaad zha yaal, o ngulal yaal, o yaad zha or kwez ngite, o yaad zha or ndeyeniʼa yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tak cha tsin zha ne yegaa goo lo zha lee goo naxat. ");
INSERT INTO zaoNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Koree nak kuu nin lo goo ne noga ni nay lo reta men: List gwatsin goo. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nzhak falt techop wiz par gak ani kuu le Paskw, leettsa ntelaaz re zha Israel, naa xomod mloo Diox re tey zha, zha ndala Egipto, lo ani kuu nzhow zha pan kuu nyoot lebadur. Tsa lee re ngwleyy kuu nabee lo re ngwleyy kon re maestr kuu nloo xkiiz Diox, zheta mkwaan zha mod ten zha Jesús, tsa kuth zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Per nzhab zha: ―Tsowt leey leen ani, tsa net re mene ne yiit re men. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Leettsa ndo Jesús Betania, liz Simún kuu mzhaak yiz kuu nteyaaz kwerp, ne or ndob Jesús roo mes. Tsa mzin thib ngot kuu myaadno thib bot kuu natexkwaa kon ke kuu le alabastr, kuu tseta nzo perfum kuu chul ndetsi, perfum kuu ngoo zha thib ya kuu le nardo, ne kwathoz naap perfuma, ne mle ngot bot tsa mzhaal bot, ne mloo ngot perfum kwerp Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Per lee chop tson re zha kuu nzi tya mnayii lo ngot, ne nzhab zha lo altaa zha: ―¿Chebee tabaata mlux perfum ree? ");
INSERT INTO zaoNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Lee perfum ree masraa nataak nake kuu tsow men gan thib liin, ngok gadoy tsa gataaʼaa temi lo re zha prob. Tsa mndelo re zha mnayii zha lo ngota. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Per lee Jesús nzhab lo re zhaʼa: ―Blaa goo ngot; ¿chebee nayii goo lo ngot? Lee kuu mtsow ngot lon nak thib kuu kwathoz wen. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Lee re prob thibka nzi lo goo, ne tak tsow goo wen lo prob leettsa nlaaz goo, per lee na ndotʼn lo goo thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Lee ngot ree mtsow loka kuu takta tsow ngot, ner mloo ngot perfum na, leettsa terka gaatsʼn. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Wlipaa na nin, dita lo yezlyu ta taa zha kwent Diiz Chul chaan da, teteth zha kuu mtsow ngot ree, tsa telaaz zha ngot. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tsa lee Judas Iscariote kuu nak thib zha lo re tsiibchop zha kuu ngeteed lo Jesús, ngwanii lo re ngwleyy kuu nabee lo re ngwleyy, tsa myaan Judas diiz taa Judas Jesús lo re ngwleyy. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Or mbin re zha kona, kwathoz wen ne naley ngoo leettsoo re zha. Ne nzhab re zha lo Judas: ―Nal kix nee kaaʼa. Tsa lee Judas mkwaan mod par taa Jesús lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ner wiz kuu ndelo ani, leettsa nzhow zha pan kuu nyoot lebadur, ne nzhow zha mbak zhiil yeen, tsa ntelaaz zha naa xomod mloo Diox re tey zha, zha ndala Egipto. Tsa lee re zha kuu ngeteed lo Jesús mnaabdiz lo Jesús ne nzhab: ―¿Pa nlaaza yatexkwaa nee kuu dow rtseeʼaa nal ani Paskw? ");
INSERT INTO zaoNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tsa mtaal Jesús chop zha kuu ngeteed lo Jesús, ne nzhab Jesús lo rop zha: ―Gwa goo yez, ne tya tsaal goo thib mbyi kuu ne thib ree nit, bteke goo dits zha, ");
INSERT INTO zaoNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ne loka pa tab zha, gab goo lo zha kuu nak chaan yuu: “Lee maestr ne, nlazʼn wun kon re zha kuu ngeteed lon rtsee chaan Paskw. ¿Pa ndob yuu kuu ta wu rtsee nee?” ");
INSERT INTO zaoNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tsa loo zha thib yuu naro lo goo, kuu ndob asta yek yuu ta nzo reta kwaa, tya texkwaa goo kuu dow rtseeʼaa. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ne mroo rop zha kuu ngeteed lo Jesús nda zha yez, ne mzal zha zha kuu nzhab Jesús lo rop zha, ne mdexkwaa rop zha rtsee kuu le Paskw. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ne or mkow yezlyu, tsa mzin Jesús kon re tsiibchop zha kuu ngeteed lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Leettsa ndob re zha roo mes ngeyow rtsee re zha, tsa nzhab Jesús lo re zha: ―Wlipaa na nin lo re goo, thib goo kuu ngeyow kon na taan lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tsa nabil ngoo leettsoo re zha, ne mndelo re zha thibga thibga zha mnaabdiz lo Jesús, ne nzhab zha: ―¿Chu nay? ");
INSERT INTO zaoNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tsa lee Jesús mkab ne nzhab: ―Thib zha lo re thib tsiibchop gooy, lee zha ntenit pan leen thibka yann kon na. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Wlipaa lee Zha Kuu Mtaal Diox Ngok Men, ndoblo rid zha taxal nke lo xkiiz Diox. Per thitanax went rid zha kuu tan lo re men, mas wen gagalt mbyiʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ne or kuu ndob re zha ngeyow rtsee zha, tsa lee Jesús mzhen pan ne mndaa Jesús texkix lo Diox, ne mtsow rol Jesús pan ne mndaa Jesús pan lo re zha kuu ngeteed lo Jesús, ne nzhab Jesús: ―Dow goo, koree nak beel da. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Noga mzhen Jesús bas ne ngwalo mndaa Jesús texkix lo Diox, ne mndaa Jesús bas lo re zha kuu ngeteed lo Jesús, tsa ngwii re zha kuu nzo leen bas. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Tsa nzhab Jesús: ―Koree nak ren da, leey texkwaa trat kub chaan Diox, ne leey xon kwent chaan naroob men. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Wlipaa na nin lo goo, nalsi gut raa na xit ub, asta wiz kuu gun kuu kub ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bluz or ngwalo mbil re zha, tsa ndya zha net yii ta ndab ya olib. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tsa nzhab Jesús lo re zha: ―Reta goo laa goo na nal yaal ree, tak lee lo xkiiz Diox nzhab: “Kuthʼn zha kuu nkenap re mbak zhiil, ne lee re maa raats”. Zac. 13:7 ");
INSERT INTO zaoNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Per bluz leettsa roban na, tsa tenerʼn lo re goo ne ya reʼaa yezlyu Galilea. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tsa nzhab Pey lo Jesús: ―¡Per tegal reta zha laaʼa, per lee na latʼn lu! ");
INSERT INTO zaoNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús nzhab lo Pey: ―Wlipaa na nin loʼa, leeka nal yaal ree, neeka ter kwez ngite chop welt, lee lu gab tson welt nlebeeta na. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Per lee Pey masraa nex mkab ne nzhab: ―Tegal gathʼn kon lu, per gabtʼn: “Leen nlebeetʼn lu”. Ne reta zha tataga nzhab zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tsa mzin re zha leen thib alo kuu le Getsemaní, tsa nzhab Jesús lo re zha kuu ngeteed lo Jesús: ―Tob goo nzhee, lee na nda tediz lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ne mndeno Jesús Pey, Santiag ne Juan ne mndelo mndebi ne nalatt ngoo leettsoo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tsa nzhab Jesús: ―Kwathoz nalatt nzo leettsoon, tak mera gathʼn, nzheeta yaan goo, kenap goo goo ne gatta goo. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tsa nda Jesús tut kwat ne mtobxub Jesús asta mdiinn yeklo Jesús lo yu. Ne mnaab Jesús lo Diox, tsa ridt Jesús yalti kuu ndoblo Jesús rid Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ne nzhab Jesús: ―¡Pa! Reta kuu tak tsowa. Btelaan lo yalti kuu riidʼn, per nlaztʼn gake taxal nlazʼn, sinke taxal nlaaza tata gake. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Leettsa mre Jesús ta nzi re zha, lee re zha naxat, tsa nzhab Jesús lo Pey: ―Simún, ¿chu naxata? ¿Chu mxegta lo mkaal neeka thib or? ");
INSERT INTO zaoNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nzheeta yaan goo ne gatta goo, bnaab goo lo Diox, tsa kedit Maxuuy goo. Wlipaa na nin, nlaaz zha tsow zha kuu nlaaz Diox, per lee kwerp zha xegt tsowe. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tsa ngwa Jesús tedib welt ne mndediz Jesús lo Diox, ne nzhab Jesús leeka re diiz kuu nzhab Jesús ner. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Leettsa mretab Jesús lo re zha kuu ngeteed lo Jesús ne lee re zha naxata tedib welt, tak ngwatin zha mkaal. Ne neeka net zha naa kwan kab zha lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ora ngwa Jesús myon welt, ne mre Jesús nzhab lo re zha: ―¡Nalsi, bneyy goo ne bdat goo! Wii goo, mzina or kuu lee na Zha Kuu Mtaal Diox Ngok Men, taa zha na lo re zha kuu ndab falt. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Gwache goo tsa ndaa goo, tak ndyaada zha kuu taan lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ne lee Jesús bee ngenika, lee Judas kuu nak thib zha lo re tsiibchop zha kuu mteed lo Jesús mzin. Ne kwathoz men ndeke dits Judas kon espad ne kon ya, lee re zhaʼa ndyaad kwent chaan re ngwleyy kuu nabee lo re ngwleyy, kwent chaan re maestr kuu nloo xkiiz Diox ne kwent chaan re zha gol. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ne mndaaʼa Judas thib seny lo re zhaʼa: Or nzhab Judas: ―Loka cho zha kuu wun thib chut kwat, zhaʼa ten goo ne teno goo. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ne or mzin Judas, ne mbig Judas lo Jesús ne nzhab Judas: ―¡Maestr! ¡Maestr! Ne mdow Judas chut kwat Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tsa mzhen re zha Jesús ne ndano zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Per lee thib zha kuu ndo lo Jesús mloo espad ne mga nza mos ngwleyy kuu nabee lo reta ngwleyy. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tsa nzhab Jesús lo re men: ―¿Chebee ndyaad goo kon espad ne kon ya, ten goo na taxal thib wann? ");
INSERT INTO zaoNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Reta wiz mndon lo goo, ne mloon lo re men lee roo gwodoo, ne neeka thib welt mzhent goo na. Per koree ngeyak, tsa gak kuu nzhab lo xkeets Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tsa lee re zha kuu mteed lo Jesús mlaa zha Jesús ne mzhonn zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Per lee thib nde kuu ndeke dits Jesús, nok thib le lar, tsa mzhen re men ndeʼa. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Per lee ndeʼa mlaa nde xab nde ne cheey nde mzhonn nde. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tsa mndeno zha Jesús lo ngwleyy kuu nabee lo reta ngwleyy, ne mkaltaa re ngwleyy kuu nabee lo re ngwleyy, re zha gol ne re maestr kuu nloo xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Per lee Pey tith tith mndeke dits re zha, asta mzin Pey lee liz ngwleyy kuu nabee lo reta ngwleyy, ne myaan Pey mbiz Pey kon re polisi kuu ngebiz lo ki. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ne lee re ngwleyy kuu nabee lo re ngwleyy ne re zha kuu nataak yuulow, mkwaan zha mod, naa xomod keki zha Jesús, tsa kuth zha Jesús, per mzalt mod lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kwathoz zha nkedi, per zhaa kuu mbez thib zha ne zhaa kuu mbez tedib zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tsa lee chop tson zha ngwateli ne mkedi zha ne mkeki zha Jesús nzhab zha: ");
INSERT INTO zaoNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Nee mbin leeʼa nzhab: “Na luux gwodoo ree kuu mdexkwaa kon yaa men, ne tsonka wiz tan tedibe, kuu texkwaat kon yaa men”. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Per tegal tata mbez re zha, per nzaalt kuu mbez re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tsa lee ngwleyy kuu nabee lo reta ngwleyy mndeli xid re zha, ne mnaabdiz lo Jesús, ne nzhab: ―¿Chebee neeka thib kuu nkabta? ¿Kwan re kuu nkeki zha lu? ");
INSERT INTO zaoNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Per lee Jesús mkabt neeka thib kwaa, tsa lee ngwleyy kuu nabee lo reta ngwleyy mre mnaabdiz lo Jesús, ne nzhab: ―¿Chu lu nak Crist kuu Mtaal Diox nabee? ¿Chu lu nak Xgann Diox? ");
INSERT INTO zaoNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Lee Jesús mkab ne nzhab: ―Nay. Ne wii goo lee na Zha Kuu Mtaal Diox Ngok Men, tob lad ban lo Diox kuu nzhak ntsow reta kwaa. Ne wii goo lee na yal tedib welt xidth xkow lobee. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tsa lee ngwleyy kuu nabee lo reta ngwleyy mchat xab ne nzhab: ―¡Ndechet raa lee tedib testig! ");
INSERT INTO zaoNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","¡Mbina goo ne zha, yewal zha kon Diox! ¿Xa ntsow goo xgab koree? Reta men nzhab: ―¡Ndoblo gath zha! ");
INSERT INTO zaoNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tsa lee chop tson zha mndelo mtsuk lo Jesús, ne mtow zha lo Jesús, ne mdin re zha Jesús ne nzhab zha lo Jesús: ―¡Ne, naa cho mkeey yeka! Ne lee re polisi mgaat yaa lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ne lee Pey ndob lee liz ngwleyy. Ora mzin thib ngot kuu nke tsiin lo ngwleyy kuu nabee lo reta ngwleyy. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ne or mwii ngot lee Pey ngebiz lo ki, yichey mwii ngot lo Pey ne nzhab ngot: ―Noʼa ndiy kon Jesús, zha yez Nazaret. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Per lee Pey nzhab: ―Nlebeetʼn Jesús, neeka netʼn naa kwan ngeniʼa lon. Ne or mroo Pey lee lee ngite mrez thib roo. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ne tedib welt mwii ngot lo Pey, ne nzhab ngot lo re zha kuu nzi tya: ―Zha ree nak thib zha kuu ndiy kon re zha baa. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Per lee Pey mkab tedib welt ne nzhab: ―Nlebeetʼn mbyi baa. Ne bluz lee re zha kuu nzi tya nzhab lo Pey: ―Wlipaa noʼa nak thib re zha kuu nzo xid re zha baa, tak lu nak zha yezlyu Galilea. ");
INSERT INTO zaoNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tsa mndelo Pey mde Pey, ne mteth Pey Diox, ne nzhab Pey: ―¡Wlipaa naa nlebeetʼn mbyi kuu nteth goo lon! ");
INSERT INTO zaoNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ne oraaka lee ngite mrez tedib welt, tsa lee Pey mtelaaz kuu nzhab Jesús lo Pey ner: “Terka kwez ngite chop welt ne lee lu gab tson welt nlebeeta na”. Ne or mtelaaz Pey kona, oraaka mndelo Pey mbinn Pey. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kwathoz til mkaltaa re ngwleyy kuu nabee lo re ngwleyy, re zha gol, re maestr kuu nloo xkiiz Diox, ne reta zha kuu nabee lo re zha Israel. Ne ngwalo myaan re zha diiz, tsa mliib zha Jesús ne mndaa zha Jesús lo Pilat. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Lee Pilat mnaabdiz lo Jesús ne nzhab: ―¿Chu lu nak rey chaan re zha Israel? Lee Jesús mkab nzhab: ―Lu ney. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ne lee re ngwleyy kuu nabee lo re ngwleyy mkeki zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tsa lee Pilat mnaabdiz tedib welt lo Jesús ne nzhab Pilat: ―¿Chebee neeka thib kuu nkabta? ¡Wii naa plal kuu nkeki zha lu! ");
INSERT INTO zaoNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Per lee Jesús mkabt neeka thib lan diiz. Tsa lee Pilat kwathoz mzegey leettsoo ne net Pilat naa kwan tsow Pilat xgab. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ne reta liin lo aniʼa lee Pilat ntelaa thib zha kuu nzo tsib, loka cho zha kuu naab re men yez. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ne lee thib mbyi kuu le Barrabás, nzo tsib thibka kon thiban zha kuu mbeth men, leettsa mbyo re zha kon re zha gobyern Roma. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tsa mzin re men, ne mndelo zha mnaab zha lo Pilat, tsa telaa Pilat thib zha taxalka ntsow Pilat reta liin. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ne lee Pilat mkab ne nzhab: ―¿Chu nlaaz goo telaan Jesús, kuu nak rey chaan re zha Israel? ");
INSERT INTO zaoNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tata nzhab Pilat, tak neʼa Pilat lee re ngwleyy kuu nabee lo re ngwleyy, nyowt leettsoo zha ndeke tyen men dits Jesús, kona mndaa re zha Jesús lo Pilat. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Per lee re ngwleyy kuu nabee lo re ngwleyy mtekiil re men, tsa gab re men lo Pilat telaa Pilat Barrabás. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Tsa lee Pilat mnaabdiz tedib welt: ―¿Kwaan nlaaz goo tsowʼn, kon zha kuu mbez goo nak rey chaan re zha Israel? ");
INSERT INTO zaoNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ne lee re men mrez dib gan ne nzhab: ―¡Bkee zha lo kruz! ");
INSERT INTO zaoNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Per lee Pilat nzhab: ―¿Kwaan kuu went mtsow zha ree? Per lee re men mre mrez dib gan ne nzhab: ―¡Bkee zha lo kruz! ");
INSERT INTO zaoNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Per lee Pilat nlaaz yaan wen kon re men, kona mtelaa Pilat Barrabás, ne bluz mnabee Pilat mdin re zha Jesús, tsaraa mndaa Pilat Jesús, tsa kee re soldad Jesús lo kruz. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tsa lee re soldad mndeno Jesús par lee liz Pilat, ne mrez zha reta soldad. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ne mtegok zha Jesús thib lar kuu nanexa na, ne mtob zha thib koron kuu natexkwaa kon yits yek Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ne oraaka mndelo re zha mrez zha dib gan zha, ne nzhab zha: ―¡Kwathoz kuubil rey chaan re zha Israel! ");
INSERT INTO zaoNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mkee re zhay yek Jesús kon thib le ya, mtsuk zha lo Jesús ne mtobxub re zha lo Jesús taxal lo rey. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ne or kuu ngwalo mzhizno zha Jesús, tsa mloo zha lar kuu nanexa na yen Jesús, ne mtegok zha Jesús xabka Jesús, ne mloo re zha Jesús tsa kee zha Jesús lo kruz. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ne lee thib mbyi zha yez Cirene kuu le Simún, kuu nak xut Alejandr ne xut Rufo ndyaad ngwa wan. Ne or nderid zha tya, tsa mnabee re soldad lo zha gwe zha kruz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ne mndeno re zha Jesús thib ta le Gólgota. (Diiz ree nak: “Tsidth yek men”.) ");
INSERT INTO zaoNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ne mndaa zha xit ub kon thib remed kuu nala kuu le mirra gagu Jesús, per lee Jesús ngwiite. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tsa mkee re soldad Jesús lo kruz. Ne mndelo re zha mloo zha swert, tsa naa cho zha tsow gan xab Jesús, ne kwan kuu diinn kadta thib zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ne til teeka las nueve mkee zha Jesús lo kruz. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ne lee letr kuu mkee zha yek kruz nzhab, naa chebee mbeth zha Jesús, ne lee letr nzhab “REY CHAAN RE ZHA ISRAEL”. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ne thibka mkee zha Jesús lo kruz kon chop wann, thib zha mkee zha lad ban lee tedib zha mkee zha lad beg lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Tata ngok tsa mrolo xkiiz Diox kuu nzhab: “Thibka ngok kwent zha kon re wann”. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ne lee re zha kuu ndriid tya ntsalzhoo zha Jesús kon ndota diiz, ne nkwin zha yek zha lo Jesús, ne mbez zha: ―¡Lu kuu nlaaz luux gwodoo, ne tsonka wiz taa luy tedib welt, ");
INSERT INTO zaoNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","os leeʼa kwathoz kuubiʼa laata gatha, leeka lu blaʼa lo kruz! ");
INSERT INTO zaoNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ne noga re ngwleyy kuu nabee lo re ngwleyy ne re maestr chaan ley, mzhizno zha Jesús ne nzhab zha lo altaa zha: ―Mlaat zha gagath tedib net zha, per lee zha gagt la zha leeka lee zha lo kruz. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Noga nzhab re ngwleyy: ―Lu ne: Lu nak Crist Kuu Mtaal Diox nabee lo re zha Israel. Bla lo kruz nal, tsa ne nee lee lu nap yalnabee, ne tsa yelaaz nee lu. Ne asta rop wann kuu nke lo kruz ntsalzhoo Jesús kon ndota diiz. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ne teeka ndrol wiz dita yezlyu mla yaal, ne lee kona mxek tson or. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ora lee Jesús mrez dib gan ne nzhab: ―Eloi, Eloi, ¿lama sabactani? (Diiz ree nak: “Diox da, Diox da, ¿chebee mlaaʼa na?”) ");
INSERT INTO zaoNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ne lee chop tson zha kuu nzi tya mbin kuu nzhab Jesús, tsa nzhab zha: ―Bin goo, lee zha ngebez profet Lí zha ndala. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Oraaka le thib zha mrezhonn mzhen thib le lar, ne mtenit zhay kon xit ub kuu ni, ne mtob zhay yek thib nith ne mndaa zhay ngwii Jesús. Tsa nzhab tedib zha: ―Laa, naa chu tyaad Lí la zha lo kruz. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Per lee Jesús mrez dib gan ne nguth. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tsa lee lar kuu now Ta Kwathoz Nayon leen gwodoo mrat asta yek ne asta xann. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ne lee soldad kuu nabee lo thib gayoo soldad ndo lo Jesús, ne mbin zha dib gan Jesús mrez Jesús ne mwii zha naa xa nguth Jesús. Tsa nzhab zha: ―Wlipaa lee mbyi ree nak Xgann Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Noga chop tson ngot nzi tith ngewii, xid re ngota ndo Mari Magdalen ne Mari xnaa Santiag kuu mas yeen lo Che ne lo Salomé. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Re ngota mndeke dits Jesús, ne mtsow zha ayud Jesús leettsa mndiy Jesús yezlyu Galilea. Ne tyen ngot kuu ngwa kon Jesús yezlyu Jerusalén nzi tya. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Lee wiza nak wiz byern kuu ndexkwaa re zha kuu nzhow zha wiz sabd kuu ndroxkwan zha. Ne mziʼa yezlyu wiza, ");
INSERT INTO zaoNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","tsa lee Che kuu nak zha yez Arimatea, kuu nak thib zha kuu kwathoz nataak lo re zha Israel, ne lee zha ngebet wiz kuu nabee Diox. Tsa thib mloo zha yek zha ne ngwa zha lo Pilat. Ne mnaab zha kwerp Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tsa lee Pilat kwathoz mzegey leettsoo, tak lijer nguth Jesús ne mrez Pilat soldad kuu nabee lo thib gayoo soldad, tsa mnaabdiz Pilat ne nzhab Pilat: ―¿Chu ngutha Jesús? ");
INSERT INTO zaoNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Lee soldad kuu nabee lo thib gayoo soldad nzhab: ―Ngutha zha. Tsa mndaa Pilat diiz mbe Che kwerp Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tsa mzhii Che thib lar wen, ne mchal Che lar kwerp Jesús, ne mloo Che kwerp Jesús leen thib baa kuu natexkwaa cho ke, ne mtow Che thib ke naro roo baa. ");
INSERT INTO zaoNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ne lee Mari Magdalen ne Mari xnaa Che mwii zha ta mloo zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Leettsa mriid wiz sabd, lee Mari Magdalen ne Mari xnaa Santiag ne Salomé, mzhii perfum kuu chul ndetsi, tsa ko zhay kwerp Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ne til wiz domin, ngwa re ngot roo baa ta ngoo Jesús, ne penta mlen wiz ora. ");
INSERT INTO zaoNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tsa nzhab ngot lo altaa ngot: ―¿Cho kib ke kuu now roo baa or tsinaa? ");
INSERT INTO zaoNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Per or mzin yon ngot, tsa mwii ngot lee ke naro kuu now roo baa mbyiiba. ");
INSERT INTO zaoNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ne or mndaab re ngot leen baa, mwii re ngot lee thib nde ndob lad ban, nok thib lar kuu naguz ne nol kuu ndedoob asta dits nii nde, tsa kwathoz mzeb re ngot. ");
INSERT INTO zaoNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Per lee nde nzhab: ―Tsebt goo. Goo ngekwaan Jesús zha Nazaret, zha kuu mkee zha lo kruz. ¡Mrobana zha! ¡Yent zha nzhee! Wii goo ta mloo zha zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tyee goo lo re zha kuu mteed lo Jesús ne lo Pey. Ne gab goo lo re zha: “Lee Jesús tener lo goo ya yezlyu Galilea, tya wii goo Jesús taxal ne Jesús lo goo”. ");
INSERT INTO zaoNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tsa lee re ngota mroo roo baa, ne mzhiit re ngot tak kwathoz mzeb re ngot. Ne yent cho lo nzhab re ngote, tak nzeb re ngot. ");
INSERT INTO zaoNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Bluz or ngwalo mroban Jesús domin til, ner lo Mari Magdalen mloo Jesús, ngot kuu mloo Jesús gaz mbi fyer leettsoo. ");
INSERT INTO zaoNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ne lee ngota ngwalo diiz lo re zha kuu mteed lo Jesús, ne nzhonn re zha ne nabil nzo leettsoo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Or mbin re zha lee Jesús naban, ne lee ngota mwiiʼa Jesús, ngwalaazt re zhay. ");
INSERT INTO zaoNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ngwalo mriid kona, tsa ngwani Jesús tedib mod lo chop zha kuu ndo net nda wan. ");
INSERT INTO zaoNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tsa lee rop zha mretab; ne ngwalo zha diize lo re altaa zha, per neeka xkiiz rop zhaʼa ngwalaazt re zha. ");
INSERT INTO zaoNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mas bluz lee Jesús ngwani lo re tsiibthib zha kuu mteed lo Jesús. Or lee re zha ndob roo mes, tsa mkox re zha lo Jesús tak kwathoz nad leettsoo re zha, tak ngwalaazt re zha xkiiz re zha kuu mwii lee Jesús mroban. ");
INSERT INTO zaoNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tsa lee Jesús nzhab lo re zha: ―Gwataa goo kwent xkiiz Diox lo re men dib naxta lo yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ne loka cho zha kuu yelaaz na ne gakleyy zha, tetsow zha gan yalnaban kuu thitanax; per lee zha kuu yelaazt na, Diox teriid zha yalti kuu thitanax gabil. ");
INSERT INTO zaoNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ne koree tsow re zha kuu nyelaaz na ne xkizʼn: Kon len koo zha mbi fyer; ne tediz zha tedib net diiz kub. ");
INSERT INTO zaoNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ne os lee zha ten zha mbeel kon yaa zha; ne os wu zha kwaan yent kwan tak zha, ne xoob zha yaa zha yek re mbyiz, ne lee re mbyiz gwe. ");
INSERT INTO zaoNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ne ngwalo mni Jesús lo re zha kuu mteed lo Jesús, tsa lee Jesús Zha Nabee loʼaa ngwazhoob yibaa, ne mndob Jesús lad ban lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ne lee re zha kuu mteed lo Jesús mroo, ne mndaa kwent Diiz Chul chaan Jesús reta ta, diiz kuu ndyaadno yalnaban kuu thitanax. Ne lee Zha Nabee ntsow ayud re zha, ne nloo Zha Nabee lee xkiiz Diox nak kuu wli, ne ntsow re zha re kuu thoz kuu gagt tsow re men, tsa ne re men lee re kuu ni re zha nak xkiiz Diox. ¡Tbaa nak diiz chul chaan Jesús!");
INSERT INTO zaoNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kwaro zha ngwalaaz gakee reta kuu ngok lo re nee, taxal ngoke, ");
INSERT INTO zaoNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","re zha kuu mwii re kuu ngok kon prop lo zha, ne mwii zha xomod mndelo re koree ndala, re zhaʼa mkayaa tsiin par taa zha kwent xkiiz Diox, ne mne zhay lo re nee. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Kona mnaabdiza na wen wen naa xomod nak kwent ree, ne ndakʼn wen keen thibgay lo yeets taxal ngoke, tsa neʼa xomod mndelo re kuu wli kuu mloo zha loʼa amig Tyof. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Leettsa lee Herodes nak rey yezlyu Judea, tsya ngoo thib ngwleyy kuu le Zacarí, thib zha kuu nak zha partid chaan ngwleyy Abías. Ne lee tsaal Zacarí le Elisabet kuu nak zha raz Aarón. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Rop tsaalta zha nali ndo nyelaaz Diox, nzhon zha diiz reta kuu nabee ley chaan Zha Nabee, tata mod neeka thib kuu gagt keki re men rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Per napt rop tsaal zha mbet, tak mndaat Diox mbet lo Elisabet, ne zha gola rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Thib wiz, leettsa mdiinn re zha partid Zacarí tsow zha tsiin lo Diox leen gwodoo chaan Diox, ");
INSERT INTO zaoNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ne lee kostumr re zha nak koo zha swert, ne Zacarí mdiinn tab leen gwodoo chaan Zha Nabee, par teyy zha straak lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ne or lee straak ngeyeek, lee re men nzi lee ngenaab lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tsa lee thib mandad chaan Diox ngwani lo Zacarí, ndeli lad ban lo bkoog ta nteyy zha straak. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ne or mwii Zacarí lo mandad, kwathoz mzegey leettsoo Zacarí ne mzeb Zacarí. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Per lee mandad nzhab lo Zacarí: ―Zacarí, tsebta, tak mbina Diox kuu mnaaba lo Diox, lee tsaala Elisabet gap thib mbet, ne Juan tob leʼa mbet. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ne kwathoz naley yo leettsooʼa, ne noga kwathoz men naley yo leettsoo tak lee mbet gal, ");
INSERT INTO zaoNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","tak lee xganna gak thib zha nataak lo Zha Nabee. Ne gut zha xit ub ne neeka thib re nit kuu nzo xtuz, ne leettsa bee ter gal mbet lee Mbi Nayon chaan Diox nabeeʼa leettsoo mbet. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ne lee xganna tsow, tsa kwaro re zha Israel bre lo Diox kuu nak Zha Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ne Juan tener lo Zha Nabee, ne keno Juan leeka Mbi Nayon ne yalney chaan Lí, zha kuu ngok profet ndala. Tsa lee re zha wen kwin zha kon re zhiinn zha, ne lee re zha kuu nzhont diiz, teed gon diiz. Tenzhee mod tolist Juan leettsoo re men, tsa kayaa re men Zha Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tsa mnaabdiz Zacarí lo mandad ne nzhab Zacarí: ―¿Xomod nen wli kuu neʼa lon? Tak zha gola rop tsaal nee. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tsa lee mandad mkab, ne nzhab lo Zacarí: ―Na nak mandad Gabriel, na ntsow tsiin lo Diox. Ne lee Diox mtaalʼn par tedizʼn loʼa, tsa nin re kuu wen ree loʼa. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Per nal, tak ngwalaazta kuu nin, kona yaana mud, ne gagt tediza asta wiz kuu gak re koree. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ne lee re men ngebet Zacarí lee roo gwodoo, ne naabdiz zha lo re altaa zha, naa chebee ntsan Zacarí leen gwodoo. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ne leettsa mroo Zacarí gagt raa tediz Zacarí, tsa myeen re zha lee Zacarí mwii thib kwaa leen gwodoo, ne kon seny mni Zacarí lo re zha, tak myaan Zacarí mud. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ne leettsa ngozhoob wiz kuu mtsow Zacarí kuu ndoblo tsow Zacarí leen gwodoo, tsa ndya Zacarí liz Zacarí. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bluz leettsa ngwalo mriid re koree, lee tsaal Zacarí Elisabet ngoo zhiinn, ne thitanax mroot ngot liz ngot dita thib gaay mbee, tak mtsow ngot xgab: ");
INSERT INTO zaoNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Mtsow Zha Nabee ayudʼn, mlat leettsoo zha mne zha na, ne mkib zha yalnathoy da lo re men”. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Xoop mbee bluz lee Diox mtaal mandad Gabriel yez Nazaret kuu nzi yezlyu Galilea, ");
INSERT INTO zaoNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ne ngwa mandad lo thib nzaa yeen kuu le Mari, kuu ter gak rop kon neeka thib mbyi, ne nzaa ree naka diiz tseya kon thib mbyi kuu le Che, kuu nak thib zha raz chaan rey David. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tsa mndaab mandad ta nzo Mari ne nzhab mandad: ―¡Tsan Mari, naley bloo leettsooʼa, tak kwathoz wen nzo leettsoo Diox ne Diox lu! Ne lee Zha Nabee ndo kon lu. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Per or mbin Mari kuu nzhab mandad chaan Diox lo Mari, neeka net Mari naa kwan tsow Mari, tsa mtsow Mari xgab na chebee tata nzhab mandad lo Mari. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tsa lee mandad nzhab: ―Mari, tsebta, tak wen nzo leettsoo Diox ne Diox lu. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nal lee lu yo zhiinn ne gapa thib mbet ne tob leʼa mbet Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Lee mbet gak thib zha kuu kwathoz nataak lo Diox, ne Xgann Diox kuu ndob yibaa tob le re men mbet, ne lee Diox kuu nak Zha Nabee, tsow tsa nabee zha taxal mnabee David tey zha, zha ndala, ");
INSERT INTO zaoNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","tsa thitanax nabee zha lo re zha Israel. Ne lee yalnabee chaan zha luxt thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tsa lee Mari mnaabdiz lo mandad, ne nzhab: ―¿Xomod tak gak koree? Tak lee na ter gakʼn kon neeka thib mbyi. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Lee mandad mkab, ne nzhab: ―Lee Mbi Nayon ne lee yalney chaan Diox kuu ndob yibaa la ditsa taxal thib xkow. Kona lee zhiinna kuu gal role Xgann Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Noga Elisabet zha liza gap thib mbet, tegal zha gola Elisabet, ne tegal mndaat Diox mbet lo Elisabet. Per ndaʼa xoop mbee nzo zhiinn Elisabet. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tak lee Diox nzhaak ntsow reta kwaa. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tsa lee Mari nzhab: ―Na nak mos chaan Zha Nabee, ndoblo tsow Diox lon taxal neʼa lon. Oraaka lee mandad ndya. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ne leeka thib re wiza, kwathoz nyob leettsoo Mari ngwa Mari thib yez kuu nzi leen yii yezlyu Judea, ");
INSERT INTO zaoNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ne or mzin Mari liz Zacarí, mni Mari “diox” lo Elisabet. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ne leettsa mbin Elisabet mni Mari “diox” lo Elisabet, lee mbet Elisabet kwathoz naley ngoo leettsoo, ne mwin mbet leettsoo Elisabet, ne oraaka lee Mbi Nayon mnabee leettsoo Elisabet. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tsa lee Elisabet nex nzhab: ―¡Kwathoz wen nzo leettsoo Diox ne Diox lu nake tedib net re ngot, ne kwathoz wen nzo leettsoo Diox ne Diox xganna! ");
INSERT INTO zaoNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Cho nakʼn par ndyaada ndyaadtwiiʼa lon xnaa Zha Nabee lon? ");
INSERT INTO zaoNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tak leettsa mbin na mniʼa “diox” lon, kwathoz naley ngoo leettsoo mbet da ne mwiin mbet leettsoon. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Kwathoz wen ndaʼa, tak ngwalaaza lee Zha Nabee tsow re kuu ne zha tsow zha loʼa! ");
INSERT INTO zaoNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tsa lee Mari nzhab: Lee yalnaban da nzhool lo Zha Nabee, tak lee zha nzhaak ntsow reta kwaa, ");
INSERT INTO zaoNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ne lee xbi da kwathoz naley nzo leettsoo ne Diox, kuu koon lo yalguth ne lo re falt da. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ne tegal nataagt, per lee Diox mlin, ne desde nal lee re men telo ni lon zha nataak, ");
INSERT INTO zaoNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","tak lee Diox nap yalney, kona mtsow Diox re kuu thoz lon. ¡Ne Nayon nak le Diox! ");
INSERT INTO zaoNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Thibka nlat leettsoo Diox ne Diox re zha kuu nzhon diiz lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ne mtsow Diox re kuu thoz, kon yalney chaan Diox. Ne mluux Diox re xgab re zha kuu naro nak. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mkib Diox yalnataak lo re zha kuu nabee, ne mtsow nataak Diox re zha kuu nataagt, kuu nadoo nak. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kwaro kwaa mndaa Diox lo re zha kuu nlann, per lee lo re zha rik yent kwan mndaa Diox lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Mtsow Diox ayud re nee, zha Israel, ne mlat leettsoo Diox mne Diox nee, mnithlaazt Diox re nee zha kuu nak mos Diox, ");
INSERT INTO zaoNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","taxal nzhab Diox lo teyaa Abraham zha ndala, lo Abraham ne lo re zha raz Abraham. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tsa mlet Mari teeka tson mbee liz Elisabet, tsaraa ndya Mari liz Mari tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ne leettsa mzin wiz gal zhiinn Elisabet, ngop Elisabet thib mbet bi. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tsa mbin re zha liz Elisabet ne re zha kuu nzo gaxta liz Elisabet, lee Diox mlat leettsoo mne Elisabet, tsa ngwatwii re zha lo Elisabet ne mndaa re zha texkix lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ne leettsa mzaal mbet xon wiz, lee chop tson zha liz Zacarí ngwa mkee seny mbet, kuu nak seny re zha Israel. Ne ngwalaaz re zha gatob le zha mbet Zacarí taxal le xut mbet. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Per lee xnaa mbet nzhab: ―Rolet mbet tabaa, Juan role mbet. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tsa lee re zha nzhab lo Elisabet: ―Neeka thib zha liza let tabaa. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tsa kon seny mnaabdiz zha lo xut mbet, tsa naa xomod nlaaz xut mbet role mbet. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Per lee Zacarí xut mbet mnaab thib le tabl, tsa kee Zacarí lee mbet lo tabl, tsa mkee Zacarí lo tabl: “Juan role mbet”. Ne reta zha kwathoz mzegey leettsoo zha mbin zha kona. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ne oraaka lee Zacarí mre mndediz tedib welt, ne mndelo Zacarí mbil lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ne reta zha kuu nzo gax liz Zacarí kwathoz mzeb zha por kuu ngok, ne reta zha kuu nzo re yez kuu nzi leen yii chaan yezlyu Judea, mndediz zha re kuu ngok. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ne reta zha kuu mbin re kuu ngok nda leettsoo zha, ne nzhab zha: “¿Cho nak mbet ree?” Tata mtsow re zha xgab, tak lee Zha Nabee mtsow re kuu thoz lo mbet. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ne lee Mbi Nayon mnabee leettsoo Zacarí xut mbet, tsa mndaa Zacarí kwent kuu nzhab Diox lo Zacarí, ne nzhab Zacarí: ");
INSERT INTO zaoNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","¡Kwathoz wen nak Zha Nabee, Diox kuu nak Diox reʼaa zha Israel, tak myaad Diox lo reʼaa kuu wlipaa nak zha yez Diox, ne mtelaa Diox reʼaa lo re faltaa! ");
INSERT INTO zaoNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ne mtaal Diox thib zha kuu tak kooʼaa lo yalguth, ne tuyy zha re falt chaanaa kon yalney chaan zha. Zha ree ndyaad lo raz chaan rey David kuu ngok teyaa, ne kuu ngok mos Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Koree nak kuu nzhab re profet kuu ngoo ndala, re zha kuu nambi mndo lo Diox. Leettsa nzhab zha: ");
INSERT INTO zaoNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Diox nak cho telaaʼaa lo re zha kuu nayii neʼaa, ne lo re zha kuu went nzo leettsoo neʼaa. Sal. 106:10 ");
INSERT INTO zaoNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ne loo Diox xa nlat leettsoo Diox ne Diox reʼaa, tak mnithlaazt Diox re diiz kuu nzhab Diox lo re teyaa, zha ndala. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ne koree nak kuu nzhab Diox lo teyaa Abraham: ");
INSERT INTO zaoNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Nzhab Diox lee Diox telaaʼaa lo re zha kuu nayii neʼaa, tsa tsebtaa tsowaa rtsin Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ne ndoblo thibka nambi ne nali toʼaa lo Diox, reta wiz kuu nabanaa. Tsa nzhab Zacarí lo xgann Zacarí: ");
INSERT INTO zaoNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Lee lu nak profet chaan Diox kuu ndob yibaa, tak lu tener lo Zha Nabee, tsa xaala xnet zha, ");
INSERT INTO zaoNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ne taaʼa kwent lo re zha kuu nak zha yez chaan Diox, lee Diox tuyy re falt zha, ne taa Diox yalnaban kuu thitanax lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tak nlat leettsoo Diox ne Diox reʼaa, kona ndaa Diox tedib xni kuu taxal xni wiz lo reʼaa, ");
INSERT INTO zaoNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","tsa la xni ree lo re zha kuu nzo lo yalkow, ne lo re zha kuu nzo xann xkal chaan yalguth, ne ko Diox reʼaa net kuu wen kwinaa.” ");
INSERT INTO zaoNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ne lee mbet ndezhen raa ne nzhak ney mbet lo Mbi Nayon chaan Diox, ne wan ngoo zha, asta wiz kuu mndelo zha mndaa kwent xkiiz Diox lo re zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ne lee re wiza lee Augusto nak zha kuu nabee dita ta nabee yez Roma, tsa mnabee Augusto thop zha le re men dita ta nabee Roma, tsa la le re men padron. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ne Ciren nak zha kuu nabee yezlyu Siria, leettsa mthop zha le re men welt ner. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Reta zha ndoblo zha ya zha laz zha, tsa la le zha padron. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kona, no Che mroo yez Nazaret, ta nabee yezlyu Galilea, ne ngwa Che yez Belén kuu nzi yezlyu Judea ta ngol rey David, tak lee Che nak zha raz chaan rey David. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Tsa ngwa Che rop Mari tya, tsa la le rop zha padron ne naka diiz tseya Mari rop Che, ne lee Mari nzo zhiinna. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ne leettsa bee nzi rop zha Belén, mzin wiz kuu lee Mari gal zhiinn. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tya ngop Mari zhiinn Mari kuu ner, tsa mchiix Mari mbet lar ne mdix Mari mbet ta nzi yizh kuu nzhow maa, tak mgaat rop zha yuu ta gabet zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Gaxta Belén nzi chop tson zha kuu nkenap mbak zhiilee yaal. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tsa cha mloo thib mandad chaan Diox lo re zha, ne lee xni chaan Zha Nabee mla dita ta nzi re zha, tsa kwathoz mzeb re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tsa lee mandad nzhab lo re zha: ―Tsebt goo, tak leen ndyaadno thib diiz kuu kwathoz wen lo goo, ne kwathoz naley yo leettsoo re men gone. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tak naltseree ngol thib mbet laz David, ne mbet ree telaa goo lo re falt goo. Ne mbet ree nak Crist Kuu Mtaal Diox Nabee, ne leeka mbet nak Zha Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Koree nak thib seny tsa yetsal mbet lo goo, lee mbet nabix lar nax lo yizh kuu nzhow maa. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ne leeka ora lee kwaro mandad chaan Diox mndo lo mandada, ne mbil re mandad lo Diox ne nzhab re mandad: ");
INSERT INTO zaoNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Ndoblo gol re men lo Diox kuu ndob yibaa! ¡Ne wen kwin re men lo yezlyu ree, tak nlaaz Diox tsow Diox kuu wen lo re men! ");
INSERT INTO zaoNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Leettsa lee re mandad ndya yibaa, tsa lee re zha kuu nkenap mbak zhiil mndelo zha nzhab zha lo re altaa zha: ―Ndaa goo reʼaa yez Belén nal, tsa wiiʼaa naa kwan ngok, tak kona mloo Zha Nabee diize loʼaa. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tsa lijer nda re zha, ne mzal Mari ne Che lo re zha, ne lee mbet nax ta nzi yizh kuu nzhow maa. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ne or mwii re zha mbet, tsa mndelo zha mndaa zha kwent chaan mbet, kuu nzhab mandad chaan Diox lo re zha, ");
INSERT INTO zaoNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ne reta zha kuu mbin kuu nzhab re zha kuu nkenap mbak zhiil, kwathoz mzegey leettsoo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Per thibka nzo re diza yek Mari, ne thibka ntsow Mari xgabe. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tsa lee re zha kuu nkenap mbak zhiil ndya, ne mbil zha lo Diox ne mndaa zha texkix lo Diox, por re kuu mbin zha ne re kuu mwii zha, tak ngok reta kuu nzhab mandad chaan Diox lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Leettsa mzaal mbet xon wiz, tsa mkee zha seny chaan zha Israel mbet, ne mtob le zha mbet Jesús, taxal nzhab mandad chaan Diox lo Mari, leettsa bee ter yo zhiinn Mari. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ne leettsa ngwazhoob wiz kuu lee Mari ngok nambi, taxal nabee ley chaan Moisés, tsa lee Che ne Mari mbe mbet yez Jerusalén, tsa kayaa Zha Nabee mbet. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tata mtsow zha, tak lo ley chaan Zha Nabee nzhab: “Reta mbet bi kuu gal ner, gak zha nayon lo Zha Nabee”. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ngwa zha ne mndaa zha gon kuu ndoblo zha taa zha, taxal nabee ley chaan Zha Nabee: “Ndoblo gwe zha chop ngog o chop palom”. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ne re wiza ngoo thib mbyi kuu le Simeón yez Jerusalén. Ne mbyiʼa nak thib zha nali lo Diox, ne nzhool zha lo Diox, ne ngebet zha tetsey Diox leettsoo re zha Israel. Ne lee Mbi Nayon chaan Diox mnabee leettsoo zha, ");
INSERT INTO zaoNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ne nzhaba Mbi Nayon lo zha gatht zha, os ter wii zha, zha kuu taal Diox nabee. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tsa lee Mbi Nayon mtsow ngwa Simeón gwodoo, ne leeka ora mbe Che ne Mari mbet gwodoo, tsa tsow zha kuu nabee ley chaan Moisés. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ora mdeez Simeón mbet ne mbil Simeón lo Diox ne nzhab Simeón: ");
INSERT INTO zaoNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Zha Nabee, nalsi ngoka kuu mneʼa lon, kwathoz wen nzo leettsoon, taka laaʼa gathʼn nal. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tak nalsi mwiiʼa na zha kuu telaa re men lo yalguth, ");
INSERT INTO zaoNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","mtaala zha lo reta men taxal mtsowa xgabe desde ndala. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Lee zha nak xni kuu teni lo reta men kuu nagt zha Israel, ne tsow nataak zha re nee, zha kuu nak zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kwathoz mzegey leettsoo Che ne Mari xnaa Jesús, or mbin rop zha kuu nzhab Simeón kwent chaan Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tsa mnaab Simeón lo Diox kenap Diox re zha, ne nzhab Simeón lo Mari xnaa Jesús: ―Diox mli mbet ree par kib mbet falt chaan kwathoz tawlazaa o par masraa kwibe dits zha, ne nak mbet thib seny kuu kwaro zha kayaat mbet, ");
INSERT INTO zaoNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","tsa lee re kuu ntsow kadta thib re men xgab gak nabeey. Per lee loʼa gak kona taxal thib espad kuu rid leettsooʼa. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ne leeka tya ndo thib ngot kuu le An, ngota nak profet chaan Diox, ne ngota nak rtsaap Fanuel kuu nak zha raz chaan Aser, ne zha gola ngot. Tak kwathoz mndyeen ngot mtseya ngot, gazka liin ngoo rop tsaal ngot, ");
INSERT INTO zaoNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ne ndaʼa thap galbthap liin myaan ngot byud. Ne thitanax mbechet ngot gwodoo chaan Diox, tse ne yaal ntsow ngot tsiin lo Diox ntsow ngot ayun ne ndediz ngot lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ne ora mzin ngota ne mndelo ngot mndaa ngot texkix lo Diox, ne mndaa ngot kwent chaan Jesús, lo re zha kuu ngebet tsin zha kuu koo re zha Jerusalén lo yalguth. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ne leettsa ngwalo mtsow Che rop Mari re kuu nabee ley chaan Zha Nabee, tsa mretab rop zha yezlyu Galilea tedib welt, ta nak laz zha Nazaret. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ne thib wiz tedib wiz lee Jesús masraa ndezhen ne masraa nzhaak, ne lee Diox thibka ndo kon Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Gandata liin nya xut Jesús ne xnaa Jesús lo ani Paskw yez Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ne leettsa mzaal Jesús tsiibchop liin, ngwa Jesús rop xut Jesús ne xnaa Jesús Jerusalén, taxal nak Kostumr zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ne leettsa ngwalo mriid ani, tsa mretab re zha laz zha, ne lee Jesús myaanka Jerusalén, per myeent xut Jesús ne xnaa Jesús lee Jesús myaanka. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tak mtsow rop zha xgab xid re men ndyaad Jesús, ne leettsa ndaʼa thib wiz ndo zha net. Tsaraa mndelo zha mkwaan zha Jesús xid re zha liz zha ne xid re tawlaz zha, per mzalt Jesús lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Tsa mretab rop zha Jerusalén tedib welt, ne mkwaan zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ne leettsa mzaal tson wiz tsaraa mzal Jesús lo rop zha. Lee Jesús ndob lee roo gwodoo chaan Diox xid re maestr kuu nloo xkiiz Diox, nkenza Jesús ne naabdiz Jesús lo re maestr. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ne reta zha kuu nkenza kuu ni Jesús, kwathoz nzegey leettsoo re zha, tak kwathoz nzhaak Jesús, ne nzhaak Jesús nkab lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Or mzal Jesús lo xut Jesús ne lo xnaa Jesús, kwathoz mzegey leettsoo rop zha, tsa nzhab xnaa Jesús lo Jesús: ―Xgann na, ¿chebee tabaa mtsowa lo nee? Kwathoz nalatt nzhak rop nee xuta ngekwaan nee lu. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Lee Jesús mkab ne nzhab: ―¿Chebee nkwaan goo na? ¿Chu net goo lee na ndoblo ton lo re kuu nak rtsin Xutʼn? ");
INSERT INTO zaoNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Per lee xut Jesús ne xnaa Jesús myent rop zha kuu nzhab Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tsa mre Jesús laz Jesús yez Nazaret kon xut Jesús ne kon xnaa Jesús, ne mbin Jesús diiz lo xut Jesús ne lo xnaa Jesús. Per thibka nzo re koree leettsoo Mari xnaa Jesús ne ntsow Mari xgab naa kwan nak re kona. ");
INSERT INTO zaoNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ne lee Jesús masraa ndezhen, ne masraa nzhaak Jesús, ne nataak Jesús lo Diox ne lo re men por re kuu ngok lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ne leettsa ndaʼa tsiin liin nabee Tiberio César dita ta nabee Roma, lee Poncio Pilat nak zha kuu nabee yezlyu Judea, lee Herodes nabee Galilea, lee Lip wets Herodes nabee yezlyu Iturea ne yezlyu Traconite, ne lee Lisanias nak zha kuu nabee yezlyu Abilinia. ");
INSERT INTO zaoNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ne Anás ne Cáifas nak ngwleyy kuu kwathoz nataak yez Jerusalén tsya. Re wiza lee Juan xgann Zacarí ngoo thib ta yubiz, ne lee Diox mni lo Juan. ");
INSERT INTO zaoNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tsa lee Juan mriid dita yezlyu kuu nzi roo yoo Jordán, ne mbez Juan lo re men, ndoblo laa re men net went ne tsee zha mod went kuu nak zha, ne gakleyy zha, tsa tuyy Diox re falt zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ne lee kona ngok taxal nzhab Isaí, kuu ngok profet ndala, or nzhab Isaí: Thib zha kuu ndo yubiz nex gab: “Btexkwaa goo xnet Zha Nabee; bxaal goo thib net nali te zha.” Is. 40:3 ");
INSERT INTO zaoNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Reta bte ndoblo zhobtse, ne reta yii ne reta lom ndoblo gak nali, ne reta net kuu naral nak ndoblo gak nali, ne lee re net kuu nakap nak tezhobtse, ");
INSERT INTO zaoNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ne reta men wii Zha Kuu Mtaal Diox Nabee, zha kuu telaa re men lo yalguth. Is. 40:3-5 ");
INSERT INTO zaoNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Leettsa mzin re men kuu gakleyy lo Juan, tsa mbez Juan lo re zha: ―¡Goo nak zha kuu nakap nak taxal mbeel! ¿Cho mloo diiz lo goo par zhonn goo lo yalnayii kuu ne Diox yaad? ");
INSERT INTO zaoNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bloo goo lee goo mlaaʼa goo re kuu went ne wlipaa mlaa goo mod went kuu nak goo, ne gabt goo lo altaa goo: “¡Leeʼaa nak raz chaan Abraham!” Tak wlipaa na nin lo goo, lee Diox tak tsow, tsa noga re ke ree gak raz chaan Abraham. ");
INSERT INTO zaoNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ne lee yeba ndoba xann re ya kuu ndaat xle wen, tsa ga zhay ne ko zhay lo ki. ");
INSERT INTO zaoNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tsa lee re zha mnaabdiz lo Juan, ne nzhab zha: ―¿Kwan ndoblo nee tsow nee? ");
INSERT INTO zaoNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan mkab ne nzhab: ―Loka cho goo kuu nap chop xab, btaa goo thibe lo zha kuu napte, ne loka cho goo nap kuu wu, btaa gooy wu zha kuu napte. ");
INSERT INTO zaoNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ne noga myaad chop tson zha kuu ntsow kobral temi chaan yezlyu, kuu nzhax lo zha Roma lo Juan, tsa tsowleyy Juan zha, tsa mnaabdiz zha lo Juan, ne nzhab zha: ―Maestr, ¿kwan ndoblo nee tsow nee? ");
INSERT INTO zaoNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan nzhab lo re zha: ―Bnaab goo beeta kuu ndoblo zha kix zha lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Noga chop tson soldad mnaabdiz lo Juan, ne nzhab: ―¿Lee nee kwan ndoblo nee tsow nee? Tsa lee Juan mkab, ne nzhab lo re zha: ―Kibt goo chaan re men lafwers, neeka kekit goo zha kon thib kuu wlit, ne ndoblo wen yo leettsoo goo kon temi kuu nzhax lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Lee re men ngebet naa kwan gak. Ne ntsow zha xgab cha lee Juan nak Crist Kuu Mtaal Diox Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Per lee Juan nzhab lo re zha: ―Na, ntsowleyy goo kon nit, per ditsʼn ndeke tedib zha kuu tsowleyy goo kon Mbi Nayon ne kon ki. Mas nataak zhaʼa nake na, kona neeka korre dits labyid zhaʼa ndoblotʼn xakʼn. ");
INSERT INTO zaoNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ne nzoʼa ya yaa zha par koo zha paj lo nzob xtil, ne kotsow zha nzob xtil leen loo ta nyetsow nzob xtil, ne lee paj ko zha lo ki kuu thitanax nyuyyt. ");
INSERT INTO zaoNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tenzhee, ne kwathoz tyen mod mteni Juan re men, ne mndaa Juan kwent Diiz Chul chaan Diox lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ne noga rey Herodes mkox lo Juan, tak ngok rop Herodes kon Herodías kuu nak tsaal Lip wets Herodes, ne noga mkox Herodes lo Juan, tak mtsow Herodes tedib net re kuu went, ");
INSERT INTO zaoNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ne mbint rey Herodes diiz lo Juan, leel tedib kuu mas went mtsow Herodes, mloo Herodes Juan tsib. ");
INSERT INTO zaoNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ne leettsa ngetsowleyy Juan re men, noga Jesús ngwa ngokleyy, ne leettsa ngeni zha lo Diox lee yibaa mzhaal, ");
INSERT INTO zaoNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ne lee Mbi Nayon mloo taxal thib palom mla dits Jesús, ne koree mloo lo re men, tsa lee thib bos mroo yibaa ne nzhab: ―Lu nak xgann na, kuu kwathoz nke leettsoon ne kwathoz wen nzo leettsoon nen lu. ");
INSERT INTO zaoNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Teeka galbtsii liin nap Jesús leettsa mndelo Jesús mndaa Jesús kwent Diiz Chul chaan Diox. Ne lee re men ngwalaaz lee Jesús nak xgann Che, Che xgann Elí, ");
INSERT INTO zaoNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí ngok xgann Matat, Matat ngok xgann Leví, Leví ngok xgann Melquí, Melquí ngok xgann Jana, Jana ngok xgann Che, ");
INSERT INTO zaoNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Che ngok xgann Matatías, Matatías ngok xgann Amós, Amós ngok xgann Nahúm, Nahúm ngok xgann Eslí, Eslí ngok xgann Nagai, ");
INSERT INTO zaoNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ngok xgann Maat, Maat ngok xgann Matatías, Matatías ngok xgann Semeí, Semeí ngok xgann Josec, Josec ngok xgann Judá, ");
INSERT INTO zaoNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá ngok xgann Joanán, Joanán ngok xgann Resa, Resa ngok xgann Zorobabel, Zorobabel ngok xgann Salatiel, Salatiel ngok xgann Nerí, ");
INSERT INTO zaoNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerí ngok xgann Melquí, Melquí ngok xgann Adí, Adí ngok xgann Cosam, Cosam ngok xgann Elmadam, Elmadam ngok xgann Er, ");
INSERT INTO zaoNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ngok xgann Jesús, Jesús ngok xgann Eliezer, Eliezer ngok xgann Jorim, Jorim ngok xgann Matat, ");
INSERT INTO zaoNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat ngok xgann Leví, Leví ngok xgann Simeón, Simeón ngok xgann Judá, Judá ngok xgann Che, Che ngok xgann Jonám, Jonám ngok xgann Eliaquim, ");
INSERT INTO zaoNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim ngok xgann Meleá, Meleá ngok xgann Mena, Mena ngok xgann Matatá, Matatá ngok xgann Natán, ");
INSERT INTO zaoNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán ngok xgann rey David, rey David ngok xgann Isaí, Isaí ngok xgann Obed, Obed ngok xgann Booz, Booz ngok xgann Salmón, Salmón ngok xgann Naasón, ");
INSERT INTO zaoNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón ngok xgann Aminadab, Aminadab ngok xgann Admín, Admín ngok xgann Arní, Arní ngok xgann Esrom, Esrom ngok xgann Fares, Fares ngok xgann Judá, ");
INSERT INTO zaoNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá ngok xgann Kob, Kob ngok xgann Isaac, Isaac ngok xgann Abraham, Abraham ngok xgann Taré, Taré ngok xgann Nacor, ");
INSERT INTO zaoNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor ngok xgann Serug, Serug ngok xgann Ragau, Ragau ngok xgann Péleg, Péleg ngok xgann Heber, Heber ngok xgann Sala, ");
INSERT INTO zaoNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala ngok xgann Cainán, Cainán ngok xgann Arfaxad, Arfaxad ngok xgann Sem, Sem ngok xgann Noé, Noé ngok xgann Lamec, ");
INSERT INTO zaoNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec ngok xgann Matusalén, Matusalén ngok xgann Enoc, Enoc ngok xgann Járed, Járed ngok xgann Mahalaleel, Mahalaleel ngok xgann Cainán, ");
INSERT INTO zaoNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán ngok xgann Enós, Enós ngok xgann Set, Set ngok xgann Adán, Adán ngok xgann Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ne kwaro mnabee Mbi Nayon leettsoo Jesús, leettsa mroo Jesús roo yoo Jordán, tsa ndano Mbi Nayon Jesús ta nak yubiz. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ne chop gal wiz ne chop gal yaal mndo Jesús tya, ne neeka thib kwaa ndowt Jesús, tsaraa mlann Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tsa lee Maxuuy ngwalaaz gakedi Jesús, ne nzhab lo Jesús: ―Os leeʼa wlipaa Xgann Diox naka, guz lo ke ree tsa reyale pan. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Lee Jesús mkab ne nzhab: ―Lo xkeets Diox nzhab: “Nabant men beeta kon pan, sinke lee men naban kon reta diiz kuu ndroo roo Diox”. Dt. 8:3 ");
INSERT INTO zaoNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tsaraa ndano Maxuuy Jesús yek thib yii naro, ne mloo Maxuuy reta yez kuu nzi lo yezlyu lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ne nzhab Maxuuy lo Jesús: ―Na ta dita yalnabee ne yalney chaan re yez ree loʼa, tsa nabee luy, tak chaan da nake, ne loka cho lo nlazʼn ta nay. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Os leeʼa tobxuba lon ne gola lon, retay gak chaana. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Per lee Jesús mkab, ne nzhab: ―Beche lon Maxuuy, tak lo xkeets Diox nzhab: “Beeta lo Diox kuu nabee loʼa ndoblo gola ne ndoblo tsowa tsiin lo”. Dt. 6:13 ");
INSERT INTO zaoNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tsa mndeno Maxuuy Jesús yez Jerusalén, ne ngwano Maxuuy Jesús yek gwodoo ta mas ya ndab, tsa nzhab Maxuuy lo Jesús: ―Os leeʼa wlipaa Xgann Diox naka, gob par yath, ");
INSERT INTO zaoNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","tak lo xkeets Diox nzhab: Diox taal mandad chaan Diox tsa kenap mandad lu, tsa yent kwan taka, ");
INSERT INTO zaoNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ne ten mandad yaaʼa, tsa yent kwan tak niiʼa lo ke. Sal. 91:11-12 ");
INSERT INTO zaoNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús mkab, ne nzhab: ―Noga nzhab lo xkeets Diox: “Kwaanta mod par kediʼa Diox kuu nak Zha Nabee loʼa”. Dt. 6:16 ");
INSERT INTO zaoNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ne lee Maxuuy ngogt raa gakedi Jesús, tsa mlaa Maxuuy Jesús thib tyemp. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tsa mre Jesús yezlyu Galilea kon yalney chaan Mbi Nayon, ne dita yezlyuʼa mndediz re men kwent chaan Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ne mloo Jesús lo re men ta nkaltaa re zha Israel nteed xkiiz Diox, ne ntsow nataak re men Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tsa ngwa Jesús yez Nazaret ta mzhen Jesús. Thib wiz sabd kuu ndroxkwan re zha Israel, mndaab Jesús ta nkaltaa re zha Israel nteed zha xkiiz Diox, taxalka nak kostumr Jesús, ne mndeli Jesús lab Jesús xkeets Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tsa mndaa zha yeets kuu mkee profet Isaí lo Jesús. Ne leettsa mxaal Jesús lo yeets, mzal Jesús ta tenzhee nzhab: ");
INSERT INTO zaoNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Lee Mbi Nayon chaan Zha Nabee ndo kon na, tak mli zha na par tan kwent Diiz Chul chaan zha lo re zha prob, ne mtaal zha na, tsa tetseyʼn leettsoo re zha kuu yent gan leettsoo, noga mtaal zha na, tsa telaan re zha kuu nzo tsib lo Maxuuy, par tegwen ngutlo re syeg; ne par telaan re zha kuu ndakti lo Maxuuy; ");
INSERT INTO zaoNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ne tan kwent chaan wiz kuu leettsa lee Zha Nabee, taa re chaane kuu wen lo re men. Is. 61:1-2 ");
INSERT INTO zaoNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tsaraa mthuz Jesús yeets, ne mndaa Jesús yeets lo zha kuu nkenap ta nkaltaa re zha nteed xkiiz Diox, ne mndob Jesús. Ne reta zha kuu nzi tya key mwii zha lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tsa lee Jesús mndelo nzhab lo re zha: ―Naltseree ngok kuu nke lo xkeets Diox lo re goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ne reta zha wen mndediz zha Jesús, ne kwathoz mzegey leettsoo zha mbin zha re diiz kuu nzhab Jesús, ne mbez re zha lo altaa zha: ―¿Chu leet zha ree nak xgann Che? ");
INSERT INTO zaoNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tsa mkab Jesús lo re zha, ne nzhab Jesús: ―Wlipaa na nin lo goo, lee re goo ntsow goo xgab ne goo diiz ree lon: “Doctor leeka lu btegweʼa lu”. Ne noga ntsow goo xgab ne goo lon: “Lee re kuu mbin nee mtsowa yez Capernaúm, noga nzhee laza btsowe”. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Noga nzhab Jesús: ―Wlipaa na nin lo goo, neeka thib re profet nkayaat re tawlaz zha zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Wlipaa na nin lo goo, kwathoz tyen ngot byud ngoo lazaa yez Israel, tyemp kuu mban profet Lí, leettsa mlat yi tson liin narol, ne mla win dita lo yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Per mtaalt Diox Lí lo neeka thib ngot byud zha tawlazaa zha Israel, sinke lee Diox mtaal Lí lo thib ngot byud zha yez Sarepta, kuu nzi ta nabee yez Sidón. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ne noga ngoo kwathoz tawlazaa kuu mzhaak yiz kuu ndezhoz kwerp zha, tyemp kuu mban profet Eliseo, per neeka thib zha mtegwet Eliseo, sinke beeta Naamán zha yezlyu Siria mtegwe Eliseo. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ne or mbin re zha Israel kuu mkaltaa ta nteed zha xkiiz Diox kona, kwathoz mkezhyan re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tsa ngwateli re zha ne mloo zha Jesús tya, ne ndano zha Jesús yek yii kuu nzi yeza, tsa tub zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Per lee Jesús mriid xid re zha ne nda Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tsa lee Jesús ngwa yez Capernaúm, kuu nzi yezlyu Galilea. Ne reta sabd wiz kuu nzhool re zha Israel lo Diox, mloo Jesús lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ne kwathoz mzegey leettsoo re zha, mwii zha xa mloo Jesús lo re zha, tak kon yalnabee ni Jesús lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ne ta nkaltaa re zha nteed zha xkiiz Diox, ndo thib mbyi kuu nzo mbi fyer leettsoo, mretsyath ne nzhab: ");
INSERT INTO zaoNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¡Blaa nee! ¿Kwan ndaka neʼa nee? ¿Chu ndyaada luuzha nee Jesús zha Nazaret? Nlebeen lu, nen leeʼa nak Zha Kuu Nayon lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tsa mkox mbi fyera lo Jesús, ne nzhab Jesús: ―¡Btow rooʼa ne broo leettsoo mbyi ree! Tsa lee mbi fyera mlobi mbyiʼa lo yu xid re mena, ne mroo mbi fyera leettsoo mbyiʼa, ne yent kwan mzhaak mbyi. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Reta zha kuu nzi tya kwathoz mzegey leettsoo zha, ne mbez zha lo altaa zha: ―¿Cho nak zha ree? Nap zha yalnabee ne yalney ngoo zha re mbi fyer leettsoo re men, ne nzhon re mbi fyer diiz lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ne kwathoz ney mraats diiz, re kuu mtsow Jesús dita yezlyu Galilea. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tsa mroo Jesús ta nkaltaa re zha Israel nteed xkiiz Diox, ne nda Jesús liz Pey, tsa nzhab re zha lo Jesús lee xnaatsaap Pey ndak xlee, ne mnaab zha lo Jesús tsa tegwe Jesús xnaatsaap Pey. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Tsa mwii Jesús lo ngot, ne ora mkox xlee lo Jesús, ne oraaka mroo xlee ngot. Ne ngwache ngot ne mndaa ngot kuu ndow re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ne leettsa mera bix wiz, reta zha kuu nap mbyiz kuu ndak zhaapaa zhaapaa yiz, myaadno zha re mbyiz lo Jesús, tsa mxoob Jesús yaa Jesús yek re mbyiz ne mtegwe Jesús mbyiz. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ne noga mloo Jesús mbi fyer leettsoo tyen zha, ne mbezguth re zha ne mbez zha lo Jesús: ―¡Lu nak Xgann Diox! Per lee re mbi fyera mkox lo Jesús, ne mlaat Jesús gani re mbi fyera lo Jesús, tak neʼa re mbi fyer lee Jesús nak Crist Kuu Mtaal Diox Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Leettsa ngwani yezlyu tedib wiza, mroo Jesús yeza ne nda Jesús thib ta to thita Jesús. Per lee re men mkwaan Jesús, ne or mzin re zha ta ndo Jesús. Ngwalaaz zha gatekweet zha Jesús par bit Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Per lee Jesús nzhab lo re zha: ―Noga ndoblo tan kwent Diiz Chul kuu ndaa kwent xomod nabee Diox lo re men tedib net re yez, tak par kona mtaal Dioxʼn. ");
INSERT INTO zaoNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ne mroo Jesús mndaa Jesús kwent Diiz Chul chaan Diox, re yez chaan Judea, ta nkaltaa re zha Israel nteed xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Thib welt ndo Jesús roo nitdoo kuu le Genesaret, ne kwathoz men mkaltaa lo Jesús ne mzhoo re men Jesús, tak nlaaz re zha gon zha Diiz Chul chaan Diox kuu ndaa Jesús kwent. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tsa mwii Jesús chop kano roo nitdoo, kuu neeka thib men yent leene, tak lee re zha kuu niit mbel mroo leen kano ndateech yex. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tsa mkendab Jesús leen kano chaan Simún, ne nzhab Jesús lo Simún tsig Simún kano tut kwat lo nitdoo. Tsa mndob Jesús leen kano, ne mndelo Jesús mloo Jesús lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Leettsa ngwalo mloo Jesús lo re men, tsa nzhab Jesús lo Simún: ―Btsig goo kano lo nit, ne blebi goo yex goo, tsa niit goo mbel. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tsa nzhab Simún lo Jesús: ―Maestr, dita yaal mke nee tsiin ne neeka thib mbel mniitta nee, per tak lu ney, kona kobi nee yex nee leen nit. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ne leettsa mloo re zha yex leen nitdoo, kwaro mbel mniit zha, ne asta ndrat yex. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tsa mtsow re zha seny lo re altaa zha kuu nzo leen tedib kano, tsa yaad re zhaʼa tsow ayud re zha. Ne myaad re zhaʼa mtsow ayud zha, ne mtse zha ropta kano, ne nlaa nlaa tab naats kano leen nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ne leettsa myeen Simún Pey kwathoz mbel mniit re zha, tsa mtobxub Pey lo Jesús ne nzhab Pey: ―¡Beche lon, Zha Nabee, tak zha ndab falt nakʼn! ");
INSERT INTO zaoNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kwathoz mzegey leettsoo Simún kon re altaa Simún, tak kwaro mbel mniit re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ne noga Santiag ne Juan kuu nak rop xgann Zebedeo, rop zhaʼa nak altaa Simún. Per lee Jesús nzhab lo Simún: ―Tsebta, tak desde naltseree gaka zha kuu niit men par Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Leettsa ngwalo mtsino re zha kano roo nitdoo, tsa mlaa zha reta kwaa ne mndeke zha dits Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Thib wiz leettsa ndo Jesús thib re yeza, tsa mzin thib zha kuu ndak yiz kuu ndeye lo Jesús, ne or mwii zha lo Jesús, mtobxub zha lo Jesús asta mdiinn yeklo zha lo yu, ne nzhab zha: ―Zha Nabee, os leeʼa nlaaza, tak tegweʼa na lo yiz ree. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tsa mxoob Jesús yaa Jesús yek zha, ne nzhab Jesús lo zha: ―Nlazʼn weʼa. Ne oraaka mgwe zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tsa nzhab Jesús lo zha: ―Neeka thib lo zha yent kwan gaba. Sinke gwa lo ngwleyy, tsa ne zha leeʼa mgweʼa lo yiz kuu mzhaaka, ne btaa gona taxal mnabee Moisés. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Per lee re kuu mtsow Jesús masraa mraats, ne kwathoz men mkaltaa mkenza kuu mni Jesús, ne noga mkaltaa re zha tsa tegwe Jesús zha lo yiz kuu ndak zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Per lee Jesús mbeche lo re men ne nda Jesús ta yent men, ne tya mndediz Jesús lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Thib wiz leettsa lee Jesús ngeloo lo re men, xid re mena ndob chop tson fariseo ne chop tson maestr kuu nloo xkiiz Diox, re zhaʼa ndyaad re yez kuu nzi dita ta nabee Galilea, Judea ne Jerusalén, ne nap Jesús yalney chaan Diox ntegwe Jesús re mbyiz. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tsa mzin chop tson mbyi kuu ngwano thib zha mthans kuu nzoob lo luun, ne nlaaz re zha ko zha mthans leen yuu, tsa kix zha mthans lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ne ngogt gataab zha leen yuu, tak kwaro men nzi tya, tsa mkendab zha yek yuu, ne mxaal zha lut yek yuu, ne tya mriid zha dib luun mthans, ne mdix zha mthans lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ne myeen Jesús lee re zha kuu myaadno mbyiza wlipaa nyelaaz Diox, tsa nzhab Jesús lo mbyiz: ―Lee re falta myuyya. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tsa lee re maestr kuu nloo xkiiz Diox kon re fariseo mndelo mtsow xgab: “¿Cho nak mbyi ree? ¿Chebee tabaa mbez mbyi ree? Beeta Diox nak cho kuu tak tuyy re falt chaan re men.” ");
INSERT INTO zaoNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Per lee Jesús myeen naa kwan ntsow re zha xgab, tsa nzhab Jesús lo re zha: ―¿Chebee tabaa ntsow goo xgab? ");
INSERT INTO zaoNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Kwan ntsow goo xgab? ¿Kwan mas nagant gapʼn lo mbyiz: “Lee re falta myuyya”, o tegwen zha ne gapʼn lo zha: “Gwache, bzhen luuna ne tyee”? ");
INSERT INTO zaoNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Per tsowʼn koree lo goo, tsa ne goo lee na, Kuu Mzin Ngok Men, napʼn yalnabee tuyʼn re falt goo. Tsa nzhab Jesús lo zha mthansa: ―Loʼa nin, gwache, bzhen luuna ne tyee liza. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ne oraaka lee zhaʼa ngwache, ne mzhen luun, ne ngeyol zha lo Diox ndya zha liz zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kwathoz mzegey leettsoo reta men ne mbil men lo Diox, ne lo tseb re zha nzhab zha: ―¡Naltseree si mwiiʼaa thib kuu thoz kuu mtsow Diox! ");
INSERT INTO zaoNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Bluz leettsa ngwalo mriid re koree, tsa mroo Jesús ne mwii Jesús thib zha kuu ntsow kobral temi chaan yezlyu, kuu nzhax lo zha Roma, zhaʼa le Leví, ndob zha roo mes ta nya re men ngix lo zha. Tsa nzhab Jesús lo Leví: ―Bteke ditsʼn. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tsa ngwateli Leví ne mlaa Leví reta kwaa, ne mndeke Leví dits Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tut bluz, mtsow Leví thib ani liz Leví par Jesús, ne tya mkaltaa kwaro re zha kuu ntsow kobral temi chaan yezlyu kuu nzhax lo zha Roma, ne noga nzi tedib net re zha kuu ngeyow kon re zha roo mes. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Per lee re fariseo ne re maestr kuu nloo xkiiz Diox, mndelo zha mrezta zha loo re zha kuu ngeteed lo Jesús, ne nzhab re zha: ―¿Chebee nzhow goo ne nzhuu goo kon re zha kuu ntsow kobral temi chaan yezlyu, ne kon re zha kuu ntsowt kuu wen? ");
INSERT INTO zaoNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús mkab ne nzhab lo re zha: ―Re zha kuu net ndak, ndechet zha zha kuu tegwe zha, per lee re zha kuu ne ndak, ndeche zha zha kuu tegwe zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ne ndyaltʼn ndyaadchezʼn re zha wen, sinke leen ndyal ndyaadchez re zha kuu nap falt, tsa tsee zha mod went kuu nak zha ne yelaaz zha Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tsa mnaabdiz re zha lo Jesús, ne nzhab zha: ―¿Chebee lee re zha kuu ngeteed lo Juan ne re fariseo kwathoz ntsow zha ayun, ne noga kwaro ndediz zha lo Diox, per lee re zha kuu ngeteed loʼa thibka nzhow zha ne nzhuu zha? ");
INSERT INTO zaoNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús mkab ne nzhab: ―¿Chu tak tsow goo, wut re zha kuu nzi lo fandan, or kuu lee zha kuu mtseya ndoka lo re zha? ");
INSERT INTO zaoNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Per too thib wiz kib zha zha kuu mtseyaʼa lo re zha, tsyasi tatsow zha ayun. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ne noga mndaa Jesús thib kwent nanzee lo re zha, ne nzhab Jesús: ―Neeka thib zha ngat lut lar kub, ne ngib zhay chu lar gox. Os lee zha tata tsow zhay, ntetsaa zha lar kub, tak lee lar kub nzaalte gwataak cho lar gox. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ne neeka ngot zha xit ub kuu kub leen gom yid gox. Tak os lee zha tata tsow zhay, lee xit ub kuu kub luux gom gox. Tsa lee xit ub zho ne lee gom gox lux. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kona lee xit ub kuu kub ndobloy yo leen gom yid kub, tsa roptay lortsin. ");
INSERT INTO zaoNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ne reta zha kuu nzhuu xit ub kuu ndaʼa wiz mroo, yowt leettsoo zha gu zha kuu kub, tak gab zha: “Mas wen ndee kuu gox”. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Thib sabd, wiz kuu nzhool re zha Israel lo Diox, lee Jesús ndiy thib ta nzhann zha nzob xtil, tsa lee re zha kuu ngeteed lo Jesús mndelo zha mdiits zha ton nzob xtil, ne mtembi zhay kon yaa zha ne ndow zhay, ");
INSERT INTO zaoNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","tsa lee chop tson fariseo mnaabdiz lo re zha, ne nzhab: ―¿Chebee ntsow goo thib kuu ndoblotaa tsowaa wiz sabd? ");
INSERT INTO zaoNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tsa mkab Jesús, ne nzhab Jesús lo re zha: ―¿Chu ter lab goo xkeets Diox, naa kwan mtsow David thib welt, leettsa mlann David kon re altaa David? ");
INSERT INTO zaoNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Mndaab David leen gwodoo chaan Diox, ne mzhen David re pan kuu Nayon lo Diox, kuu beeta re ngwleyy ndoblo wu, ne ndow David pan ne noga mndaa Davide ndow re zha kuu nda kon lee David. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ne noga nzhab Jesús: ―Na nak Zha Kuu Mtaal Diox Ngok Men ne napʼn yalnabee, tsa nabeen lo wiz sabd. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Lee tedib sabd, wiz kuu nzhool re zha Israel lo Diox, lee Jesús mndaab ta nkaltaa re zha Israel nteed xkiiz Diox, ne mndelo Jesús mloo lo re men. Ne tya ndo thib mbyi kuu mbiz yaa ban. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tsa lee re maestr kuu nloo xkiiz Diox ne re zha fariseo yichey mwii lo Jesús, tsa naa chu tetegwe Jesús mbyiz wiz sabd, tsa tak keki zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Per lee Jesús neʼa naa kwan ntsow re zha xgab, tsa nzhab Jesús lo mbyi kuu mbiz yaaʼa: ―Gwateli ne bto ndrol lo re zha. Tsa lee mbyiʼa ngwateli ne ngwato. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tsa nzhab Jesús lo re zha kuu nzi tya: ―Nal naabdizʼn thib kuu lo goo: ¿Kwan ndoblo tsow men wiz sabd, kuu wen o kuu went? ¿Chu wen tegwe men thib men, o chu wen kuth men thib men? ");
INSERT INTO zaoNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tsa mwii Jesús lo re zha kuu nzi lo Jesús, tsaraa nzhab Jesús lo mbyi kuu mbiz yaaʼa: ―Bteli yaaʼa. Tsa lee mbyiʼa mteli yaa, ne oraaka lee yaa mbyi mgwe. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Per lee re fariseo ne re maestr kwathoz mkezhyan ne mndelo mbyodiz, tsa naa xomod tsow zha par keki zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ne thib re wiza lee Jesús ngwa yek thib yii, tsa tediz Jesús lo Diox, ne dita yaal mndediz Jesús lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ne leettsa ngwani yezlyu, tsa mrez Jesús re zha kuu ngeteed lo Jesús, ne xid re zha kuu ngeteed lo Jesús mli Jesús tsiibchop zha kuu gak apóstl. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Simún (kuu mtob le Jesús Pey), Ndres (wets Simún), Santiag, Juan, Lip, Bartolomé, Mateo, Mach, Santiag (xgann Alfeo), Simún (kuu ngoo xid partid zha Canaán), Judas (xgann Santiag) ne Judas Iscariote (kuu mndaa Jesús lo re zha kuu mbeth Jesús). ");
INSERT INTO zaoNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tsa mroo Jesús yek yii kon re zha kuu ndeke dits Jesús, ne mzin re zha thib ta laats nak. Tya mkaltaa Jesús kon re zha kuu mndeke dits Jesús, ne noga kwaro re men tedib net re yez ngwa lo Jesús, re zhaʼa mroo re yez chaan yezlyu Judea ne yezlyu Jerusalén, ne rop yez kuu nak Tiro ne Sidón kuu nzi roo nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Reta zhaʼa mzin tya tsa kenza zha kuu gab Jesús, ne noga tsa tegwe Jesús zha lo yiz kuu ndak zha. Ne reta re zha kuu ndakti lo mbi fyer, mtegwe Jesús zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kona reta men nlaaz diinn cho Jesús, tak myeen re zha cho Jesús ndroo yalney kuu ntegwe Jesús re mbyiz. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tsa mwii Jesús lo re zha kuu ngeteed lo Jesús, ne nzhab Jesús lo re zha: ―Wen nda re goo zha prob, tak chaan goo gak ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Wen nda re goo zha kuu nlann nal, tak lee re goo gak zha kuu tse leettsoo. ’Wen nda re goo zha kuu nzhonn nal, tak bluz lee re goo zhiz. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Wen nda goo leettsa yii re men ne goo, leettsa ndriid goo yalti tak nyelaaz goo na, Kuu Mzin Ngok Men, leettsa koo zha goo laz goo, ne leettsa nge zha goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Naley bloo goo leettsoo goo ne bzhiz goo wiza, tak lee re goo kayaa thib kuu thoz leen yibaa, tak tataka mnayii re tey re zhaʼa mne re profet kuu ngoo ndala. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Per aka nalatt rid re goo zha kuu rik nal, tak mkenoʼa goo reta kuu mtetsey leettsoo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Ne aka nalatt rid re goo, kuu nap naroob kuu wu nal, tak lee re goo talann. ’Ne aka nalatt rid re goo kuu nzhiz nal, tak lee re goo gonn ne nabil yo leettsoo. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Aka nalatt rid re goo tak wen ndediz re men goo, tak tataka mndediz wen re men re zha kuu wlit ngok profet. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ne noga nzhab Jesús: ―Per lee na ni lo re goo kuu ngeyon xkizʼn: Bke leettsoo goo re zha kuu nayii ne goo, ne wen btsow goo lo re zha kuu ndak leettsoo ne goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ne wen btediz goo lo re zha kuu ngode goo, ne bnaab goo lo Diox por re zha kuu ntsalzhoo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Os lee thib zha kee thib maket cho kwat goo, noga btaa goo tedib lad kwat goo lo zha. Ne lee zha kuu nlaaz kib chamar goo, noga laa goo gwe zha kamis goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ne loka cho naab thib kwaa lo goo, btaa gooy lo zha, ne os lee thib zha ten thib kuu nak chaan goo, gabt goo lo zha tsere zhay lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Leeka taxal nlaaz goo tsow re men lo goo, leeka tata btsow goo lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Tak os lee goo nke leettsoo goo beeta re zha kuu wen ntsow lo goo, ¿kwan kuu wen ntsow goo tsa? Noga re zha kuu ndab falt tata ntsow. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ne os lee goo wen nak goo beeta lo re zha kuu wen nak lo goo, ¿kwan kuu wen ntsow goo tsa? Noga re zha kuu ndab falt tata ntsow. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ne os ntseche goo kwaa beeta lo re zha kuu taa thib kwaa lo goo, ¿kwan kuu wen ntsow goo tsa? Noga re zha kuu ndab falt, ntseche zha kwaa lo altaa zha kuu ndaa thib kwaa lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ndoblo ke leettsoo goo re zha kuu nayii ne goo, wen btsow goo lo re zha, ne btseche goo kwaa lo re zha, ne kwetta goo taa zha thib kwaa lo goo, tsa naroob kwaa kayaa goo yibaa, ne gak goo zhiinnpaa Diox kuu ndob yibaa, tak wen nak Diox lo reta men kuu ndaat texkix lo Diox ne lo re men kuu nakap nak. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ne blat leettsoo goo ne goo re men, taxal nlat leettsoo Diox ne Diox reta men. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Ndoblot gak goo zha kuu naab kwent lo tedib men, tsa lee Diox naabt kwent lo goo. Naabt goo kuu went par tedib men, tsa tsowt Diox rid goo tata. Bloo goo yek goo re kuu went kuu mtsow taben goo lo goo, tsa noga Diox tuyy re kuu went kuu mtsow goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Taa goo kwaa lo tedib net zha, tsa noga Diox taa kwaa lo goo, kon thib medid kuu wen nabix. Tak leeka taxal nchiix goo kuu ndaa goo lo tedib net men, leeka tata chiix Diox kuu taa Diox lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Noga nzhab Jesús diiz nanzee ree lo re zha: ―¿Chu tak teno thib syeg tedib syeg? ¿Chu ropt zha gab leen yeeryu? ");
INSERT INTO zaoNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Neeka thib zha kuu ngeteed nataagt zha masraa nake maestr zha, per leettsa yelo teed zha, tsaraa gak zha taxal maestr zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Chebee ngwiiʼa paj kuu nzo ngutlo wetsa, ne ngwiita ya kuu nzo ngutloʼa? ");
INSERT INTO zaoNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Os leeʼa nyeenta nzo thib le ya ngutloʼa, ¿xomod nye leettsooʼa mbeza lo wetsa: “Wets, taa diiz gon paj kuu nzo ngutloʼa”? ¡Zha kuu nkedi ne ntsowt kuu wen naka! Ner bloo ya kuu nzo ngutloʼa, tsa tak wiiʼa wen, par tak kooʼa paj kuu nzo ngutlo wetsa. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Noga nzhab Jesús: ―Yent thib ya wen kuu ndaa xle went, ne yent thib ya went kuu ndaa xle wen. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Reta ya nabee ya por xle kuu ndaa ya, tak nthopt zha ig lo ya yits, ne neeka nthopt zha ub lo luts yitsti. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Lee mbyi wen, kuu wen ndediz mbyi, tak kuu wen ntsin leettsoo mbyi. Ne lee mbyi went, kuu went ndediz mbyi, tak kuu went ntsin leettsoo mbyi. Tak leettsoo zha ntsin reta kuu ndediz zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Chebee Zha Nabee ni goo lon, ne ntsowt goo kuu nabeen lo goo? ");
INSERT INTO zaoNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nal nin lo goo naa xomod nak zha kuu nkenza xkizʼn ne ntsow kuu nin. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Lee zhaʼa nak taxal thib zha kuu mta thib yuu. Ner mdaan zha simyent, asta mgaa zha ke, ne leettsa mla yizhoo, kwathoz ngoo nit yoo ne mke nit yuu, per mtsowt nit gan gakwin nit yuu, tak lo ke ndob yuu. ");
INSERT INTO zaoNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Per lee zha kuu nzhon kuu nin, ne ntsowt kuu nin, zhaʼa nak taxal thib zha kuu mta yuu lo gux, mdaant zha simyent naats. Ne leettsa mla yizhoo kwathoz ngoo nit yoo, ne mke nit yuuʼa ne mluux nit yuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Leettsa ngwalo mni Jesús lo re men, tsa nda Jesús yez Capernaúm. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ne yeza nzo thib zha Roma, kuu nak thib soldad kuu nabee lo thib gayoo soldad, ne lee zhaʼa nap thib mos kuu kwathoz nke leettsoo zha, kuu ne ndak ne mer gath. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ne leettsa mbin soldad kuu nabee lo thib gayoo soldad re kuu mtsow Jesús, tsa mtaal soldad chop tson zha bye zha Israel, tsa yachez zha Jesús, tsa tegwe Jesús mos zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ne leettsa mzin re zhaʼa lo Jesús, tsa mnaab zha lo Jesús ne nzhab zha: ―Ndoblo tsowa ayud soldad kuu nabee lo thib gayoo soldad, ");
INSERT INTO zaoNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","tak kwathoz nke leettsoo zha re tawlazaa, ne mdexkwaa zha thib ta nkaltaaʼaa nteedaa xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tsa lee Jesús mndeke dits re zhaʼa, per leettsa mera tsin re zha liz soldad kuu nabee lo thib gayoo soldad, tsa lee soldad kuu nabee lo thib gayoo soldad, mtaal zha chop tson amig zha nzhab lo Jesús: ―Zha Nabee,tsowta xgab taba leen lizʼn, tak thitanax ndoblot nay, ");
INSERT INTO zaoNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","kona neeka myaltʼn gakwaan na lu. Beeta nabee tsa lee mos da gwe. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tak noga na napʼn zha kuu nabee lon, ne tataga, napʼn soldad kuu nabeen lo. Leettsa mbezʼn lo thib zha: “Gwa” ne nda zha, ne leettsa mbezʼn lo tedib zha: “De”, ne nyaad zha, ne leettsa nabeen lo mos da tsow mos thib kwaa, ntsow zhay. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kwathoz mzegey leettsoo Jesús or mbin Jesús kona, ne mwii Jesús lo re zha kuu ndeke dits Jesús, ne nzhab Jesús: ―Wlipaa na nin lo goo, ¡neeka thib tawlazaa nyelaazt Diox taxal mbyi ree! ");
INSERT INTO zaoNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ne leettsa mretab re zha kuu mtaal soldad lo Jesús, liz soldad kuu nabee lo thib gayoo soldad, lee mos soldad kuu nabeeʼa mgweʼa. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Bluz leettsa ngwalo mriid re koree, tsa lee Jesús kon re zha kuu ngeteed lo Jesús nda yez kuu le Naín. Ne kwaro men mndeke dits Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Per or ndetsin gaxa re zha yeza, tsa mwii re zha, kwaro men yeza nda ndakaats thib thebol, ne thita zha kuu ngutha lo xnaa zha, ne byud xnaa zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tsa mwii Zha Nabee lo xnaa thebol, ne mlat leettsoo Zha Nabee mne xnaa thebol, tsa nzhab Jesús lo ngot: ―Gonnta. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ne ora mbig Jesús gax cho kaj, ne lee re zha kuu ndano kaj mlet, tsa lee Jesús mdiinn cho kaj, ne nzhab Jesús lo zha kuu ngutha: ―Mndyeen, loʼa nin: ¡Gwache! ");
INSERT INTO zaoNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tsa lee zha kuu ngutha, cha mndob ne mndelo mndediz, ne lee Jesús mzhen yaa zha ne mteli zha, ne mndaa Jesús zha lo xnaa zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ne kwathoz mzeb re men mwii re men kuu ngok, ne mndelo zha mbil zha lo Diox, ne nzhab zha: ―Thib profet kuu kwathoz nataak mzin loʼaa nzhee nal. Noga nzhab re zha: ―Diox ndyaad tsow ayud re tawlazaa. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ne dita yezlyu Judea mbin re men kuu mtsow Jesús, ne noga tedib net re zha kuu nzo yezlyu gax mbin re koree. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Reta kona mbin Juan, tak lee re zha kuu ngeteed lo Juan nzhabe lo Juan. Tsa mrez Juan chop zha kuu ngeteed lo Juan, ");
INSERT INTO zaoNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ne mtaal Juan zha yanaabdiz zha lo Jesús, tsa naa chu lee Jesús nak Zha Kuu Mtaal Diox Nabee, o chu leet zhay, par kwet zha yaad tedib zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tsa lee rop zha kuu mtaal Juan mbig lo Jesús, ne nzhab: ―Juan kuu ntsowleyy re men, mtaal nee tsa naabdiz nee loʼa, “¿naa chu lu nak Zha Kuu Mtaal Diox Nabee o chu tebet nee tedib zha?” ");
INSERT INTO zaoNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ne leeka ora mtegwe Jesús kwathoz men lo relota yiz, noga mloo Jesús re mbi fyer kuu nzo leettsoo re men kuu nteti re men, ne noga mtsow Jesús mzhaal ngutlo re syeg. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tsaraa mkab Jesús lo rop zha kuu mtaal Juan, ne nzhab Jesús: ―Tyee goo ne guz goo re kuu mwii goo ne re kuu mbin goo lo Juan. Guz goo lo Juan lee ngutlo re syeg nzhaal, lee re zha mthans nde, lee re zha kuu ndak yiz kuu ndezhoz ngwe, lee re zha kuu nakwee nzhaal nza, lee zha nguth ndroban, ne lee lo re zha prob ndaa zha kwent Diiz Chul chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡Wen nda re zha kuu nzhagt chop xgab, tak nyelaaz zha na! ");
INSERT INTO zaoNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Or lee rop zha kuu mtaal Juan mbi lo Jesús, tsa lee Jesús mndelo mndaa kwent chaan Juan lo re men, ne nzhab Jesús: ―Leettsa ngwa goo yubiz, ¿kwan ngwatwii goo? ¿Chu lo thib nith kuu nkwin mbi ngwatwii goo? ");
INSERT INTO zaoNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ne os nagte tata, ¿cho lo ngwatwii goo tsa? ¿Chu ngwa goo ngwatwii goo lo thib zha kuu nzhok lar wen? Wen ne goo lee re zha kuu nzhok lar wen ne re zha kuu ntsow kuu nlaaz, nak re zha kuu nzo liz rey. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mbay, ¿kwan mroo goo ngwatwii goo tsa? ¿Chu ngwatwii goo lo thib profet? Wlipaa na nin, lee Juan nak thib zha kuu mas nataak nake thib re profet kuu ngoo ndala. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan nak zha kuu ndaa xkeets Diox kwent, ta nzhab: Leen taal thib mos da kuu tener loʼa, tsa to list zha leettsoo re men par kayaa re mena. Mal. 3:1 ");
INSERT INTO zaoNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","’Per lee na ni lo goo, neeka thib zha ngok nataagt taxal Juan. Per tegal tata nake lee zha kuu nataagt ta nabee Diox, zhaʼa nak zha kuu mas nataak nake Juan. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Leettsa mbin reta men kona, noga re zha kuu ntsow kobral temi chaan yezlyu kuu nzhax lo zha Roma mbine, tsa reta zha kuu ngokleyy lo Juan, nzhab zha: “Nali nak Diox”. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Per lee re fariseo ne re maestr kuu nloo xkiiz Diox, ngokleyyt zha lo Juan, ta mod mkayaat zha kuu nap Diox par re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tsa lee Jesús nzhab: ―Nal nin lo goo naa xa nzhak re men tyemp ree ne xa nak zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Lee re men nzhak taxal re ndyeen bzhizh, kuu nzi nke byith lo xbi, kuu mbez lo altaa: “Naley mbil nee flaut, per mkanit goo, mbilga nee nabil ne mbinnt goo”. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tbaa nin, tak leettsa myaad Juan kuu mtsowleyy, ndowt Juan pan neeka ngwiit Juan xit ub, tsa nzhab goo: “Mbi fyer nzo leettsoo Juan”. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","’Lee nal ndyal na, Kuu Mzin Ngok Men, nzhowʼn ne nzhuun reta kwaa, tsa mbez goo, lee na nak thib zha kuu kwathoz nzhowcho ne kwathoz nzhuu xit ub, noga mbez goo, nakʼn zha kuu nzaal leettsoo, kon re zha kuu ntsow kobral temi chaan yezlyu kuu nzhax lo zha Roma, ne noga mbez goo, nakʼn zha kuu nzaal leettsoo kon re zha kuu ntsow kuu went. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Per lee zha kuu nap yalnzhaak chaan Diox, por re kuu ntsow zha nabee lee zha nap yalnzhaak. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tsa lee thib fariseo kuu le Simún mndeno Jesús lize, tsa wu Jesús kon lee zha. Ne leettsa ngeyow zha, ");
INSERT INTO zaoNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","tsa lee thib ngot kuu nzo yeza, kuu ndab kwathoz falt ngwa lo Jesús, tak mbin ngot lee Jesús ngeyow liz fariseo, ne ngwano ngot thib bot kuu natexkwaa kon thib ke kuu le alabastr, kuu tseta nzo perfum kuu kwathoz wen ndetsi. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ne mndelo ngot mbinn ngot xann nii Jesús, ne leeka kon nit kuu nzhonn ngot mtenit ngot nii Jesús, ne mtekwiiz ngot nii Jesús kon yitsek ngot, ne mtselo ngot nii Jesús, tsaraa mdaab ngot perfum nii Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ne ora lee fariseo kuu mndeno Jesús lize, mwii kuu mtsow ngota, tsa mnda leettsoo zha: “Os lee mbyi ree nak thib profet, teyeen mbyi naa cho men kuu ngediinn cho mbyi, tak thib ngot kuu ntsow kuu went nak ngot baa”. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tsa lee Jesús nzhab lo fariseo: ―Simún, nlazʼn nin thib kwaa loʼa. Tsa lee fariseo mkab, ne nzhab: ―Ne, naa kwan nlaaza neʼa maestr. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tsa lee Jesús nzhab: ―Nal tan thib kwent loʼa. Thib welt ngoo chop zha kuu mdinn temi lo thib zha. Thib zha mdinn gaay gayoo temi plat; lee tedib zha mdinn chop galbtsii temi plat. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ne napt rop zha temi par kix zha lo zha kuu mtseche temi lo zha, tsa lee zha kuu mtseche temi lo rop zha, mtsow perdon temi kuu ndab rop zha. Per nal naabdizʼn loʼa Simún: Lo rop zhaʼa, ¿cho zha masraa ke leettsoo zha kuu mtseche temi? ");
INSERT INTO zaoNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tsa lee Simún mkab, ne nzhab: ―Ndakʼn zha kuu mdinn masraa temiʼa, masraa ke leettsoo zha. Tsa lee Jesús nzhab lo Simún: ―Wen mkaba. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tsa lee Jesús mwii lo ngota, ne nzhab Jesús lo Simún: ―¿Chu ngwiiʼa ngot ree? Leettsa mndaabʼn liza mndaata nit gateechʼn niin, per lee ngot ree mteech niin kon nit kuu mbinn ngot, ne mtekwiiz ngot niin kon yitsek ngot. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Leettsa mndaabʼn leen liza, neeka mtselota lon, per lee ngot ree, lo lal mzin ngot ne asta nal ngetselo ngot niin. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ne neeka aseyt mdaabta yekʼn, per ngot ree si mdaab perfum nin. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kona nin loʼa, lee reta falt chaan ngot ree mtuyya nay, tak kwathoz mke leettsoo ngotʼn. Per lee zha kuu lutta nke leettsoo na, lutta falt chaan zha tuyʼn. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tsa nzhab Jesús lo ngot: ―Reta falt chaana mtuyya na. ");
INSERT INTO zaoNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tsa lee re zha kuu nzi tya, mnda leettsoo re zha ne nzhab zha: ―¿Cho nak mbyi ree? ¿Chebee ndak mbyi tak tuyy mbyi falt? ");
INSERT INTO zaoNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tsa lee Jesús nzhab lo ngota: ―Tak nyelaaza na, kona mtuyʼn reta falta, tyee ne wen bloo leettsooʼa. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Leettsa ngwalo mriid re koree, tsa nda Jesús kon re tsiibchop zha kuu ngeteed lo Jesús, nda re zha ngetaa zha kwent Diiz Chul chaan ta nabee Diox, re yez ne re ranch. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ne noga nda chop tson ngot kuu mloo Jesús mbi fyer leettsoo, ne re ngot kuu mtegwe Jesús lo yiz. Ne thib re ngota nak Mari kuu noga le Magdalen, kuu mloo Jesús gaz mbi fyer leettsoo, ");
INSERT INTO zaoNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ne tedib ngot kuu le Juan kuu nak tsaal Cuza, kuu mke tsiin lo rey Herodes, noga Susan ne tedib net re ngot kuu mtsow ayud Jesús kon kuu nap re ngot. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ne kwaro men mroo laz ngwa gon kuu ni Jesús, ne leettsa ngwalo mkaltaa kwaro men, tsa mni Jesús lo re men kon diiz nanzee, ne nzhab Jesús: ");
INSERT INTO zaoNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Nal leen ta thib kwent lo goo, kwent chaan thib zha kuu mroo ndalo nzob xtil lo yu. Ne leettsa ngelaal zhay, thib nete mlaa laaz net, ne lee re men mloo ditse, ne myaad re min ndowe. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tedib nete mlaa xid ke, ta yent naroob yu, ne leettsa mlene mzhene lut, ne zhega zhega mbize, tak yent naroob naz par gazhene. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Lee tedib nete mla xid yits, mlene ne thibka mzhene kon yits, ne mluux yitse. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Per lee tedib nete mla lo yu naal, ne kwathoz mzhene ne kwaro ngoke, asta thib gayoo nzob xtil mndaa thibka bin. Tata nak kwent. Tsa nex nzhab Jesús: ―¡Os lee goo ndob nza goo ndoblo yen goo koree! ");
INSERT INTO zaoNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tsa lee re zha kuu ngeteed lo Jesús mnaabdiz lo Jesús, ne nzhab: ―¿Xomod nak kwent nanzee ree? ");
INSERT INTO zaoNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús mkab lo re zha ne nzhab: ―Diox mtsow tsa yen goo naa xomod nak re kuu nloot chaan ta nabee Diox; per lee lo tedib net zha pur nanzee nin lo zha, tsa tegal wii zhay loote lo zha, ne tegal gon zhay yent zhay. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Tenzhee nak kwent nanzee: Lee nzob xtil nak taxal xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Lee nzob xtil kuu mla laaz net, nak taxal re zha kuu nzhon xkiiz Diox, per lee Maxuuy nyaad nkibe leettsoo zha, tsa yelaazt zha Diox ne tsowt zha gan yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Lee nzob xtil kuu mla xid ke, ta yent naroob yu, nak taxal re zha kuu nzhon xkiiz Diox; ne kwathoz naley nzo leettsoo zha nkayaa zhay, per taxal ya kuu napt lozh nak zha, nyelaaz zhay lut, per leettsa nzin thib yalti lo zha, tsa nlaa zha Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Lee nzob xtil kuu mla xid yits, nak taxal re zha kuu nzhon xkiiz Diox, per lutga lutga lee re xgab yezlyu ree, kuu nak xomod gak rik zha, ne re gust yezlyu ree ntsow gan lo zha, re kona nluux xkiiz Diox leettsoo zha, kona ndaat zha xle. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Per lee nzob xtil kuu mla lo yu naal, nak taxal re zha kuu nzhon xkiiz Diox kon dib ndroo leettsoo, ne ntsow zha re kuu mbez xkiiz Diox, ne ney ndo zha lo xkiiz Diox, re zhaʼa ndaa kwathoz xle. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Noga nzhab Jesús: ―Neeka thib zha nkeet thib kandil ne ntow zhay kon thib zhibey o ngo zhay xann luun, sinke ntob zhay thib ta ya ndab, tsa teniy lo re zha kuu tab leen yuu. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Leeka tata, neeka thib kuu nzogaats gagt loote, ne neeka thib kuu xgaats gagt net re mene, retay tanabeey. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Kona wen kenza goo re kuu nin. Tak lee re zha kuu nkeno kwaa, tekayaa zha masraay, per lee re zha kuu nkenote, asta lut kuu nap zha teyiib lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Lee xnaa Jesús ne re wets Jesús mzin ta ndo Jesús, per gagt big re zha gax lo Jesús, tak kwathoz men nzi tya. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tsa mloo zha diiz lo Jesús nzhab zha: ―Lee xnaaʼa ne re wetsa nzi lee, ne nlaaz zha ni zha loʼa. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesús mkab ne nzhab: ―Reta zha kuu nzhon xkiiz Diox ne ntsow kuu nzhab xkiiz Diox, re zhaʼa nak taxal xnaan ne re wetsʼn. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Thib wiz mndaab Jesús leen kano kon re zha kuu ngeteed lo Jesús, tsa nzhab Jesús lo re zha: ―Nda goo reʼaa tedib lad roo nitdoo. Tsa nda re zha tedib lad roo nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ne leettsa nda re zha lo nitdoo, lee Jesús mdat. Ne lee thib mbi thoz ngoth lo nitdoo, ne lee nit mndelo mndaab leen kano, ne asta nlaa loww kano leen nit, ne kwathoz mzhakti re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tsa mloo re zha mkaal lo Jesús, ne nzhab zha lo Jesús: ―¡Maestr! ¡Maestr! ¡Mer lowgwaa! Tsa ngwache Jesús ne mkox mbi ne nitdoo lo Jesús, ne oraaka lee mbi ne nitdoo zheta ngok. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tsa nzhab Jesús lo re zha kuu ngeteed lo Jesús: ―¿Chebee nzeb goo? ¿Ma kuu ni goo nyelaaz goo Diox? Per lee re zha kwathoz mzeb zha ne mzegey leettsoo zha, ne naabdiz zha lo altaa zha ne mbez zha: ―¿Cho nak zha ree, chebee nzhaak nabee zha lo mbi ne lo nitdoo ne nzhone diiz lo zha? ");
INSERT INTO zaoNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Leettsa mzin re zha tedib lad roo nitdoo chaan yezlyu Galilea, yezlyu chaan re zha yez Gadara. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ne or mla Jesús leen kano, tsa myaad thib zha yeza mbig lo Jesús. Ne lee zhaʼa ndaʼa tyemp nzo mbi fyer leettsoo zha. Ne neeka nzhogt zha xab zha, ne neeka nzot zha liz zha, sinke leen re baa ta nkaats re men re thebol nyoo zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Per or mwii zha Jesús, tsa mbig zha mtobxub zha lo Jesús ne mrez zha, nzhab zha: ―¿Chebee ndyaada lo nee Jesús Xgann Diox kuu ndob yibaa? ¡Naabʼn loʼa tetita nee! ");
INSERT INTO zaoNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Tata nzhab zha, tak lee mbi fyer mkox lo Jesús tsa roo mbi fyer leettsoo zha. Tyen welt nden mbi fyer zha, ne tegal nliib re men zha kon kaden, per ntsow zha gan nchuug zhay ne nyano mbi fyer zha re yubiz. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tsa mnaabdiz Jesús lo zha, ne nzhab Jesús: ―¿Cho bleʼa? Lee zha mkab, ne nzhab: ―Leen le, kwathoz. Tata nzhab zha, tak kwathoz mbi fyer nzo leettsoo zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tsa lee re mbi fyer mnaab ne nzhab lo Jesús: ―Taalta nee leen yeerdoo. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ne gax tya nzi naroob nguch ngeyow, tsa nzhab re mbi fyera lo Jesús: ―Taa diiz tab nee leettsoo re nguch baa. Tsa mndaa Jesús diize. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tsa lee re mbi fyera mroo leettsoo mbyiʼa ne mndaab re mbiʼa leettsoo re nguch. Ne oraaka lee re nguch mrezhonn ne mla re maa leen nitdoo, ngwaap re maa nit ne thitanax nguth re maa. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Per leettsa mne re zha kuu nkenap re nguch kona, tsa lijer ndya zha ne mndaa zha kwent kuu ngok, lo re zha kuu nzi wan ne lo re zha kuu nzo yez. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tsa lee re men yez mroo ngwatwii naa kwan kuu ngok. Ne leettsa mzin re zha ta ndo Jesús, tsa mwii zha lee mbyi kuu mroo re mbi fyer leettsooʼa ndoba lo Jesús, ne nok xaba mbyi ne mgweʼa mbyi, tsa kwathoz mzeb re men. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ne lee re zha kuu mwii kuu ngok, mndaa zha kwente lo tedib net re zha, naa xomod mgwe zha kuu ngoo mbi fyer leettsooʼa. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tsa lee re men kuu nzo yezlyu Gadara, nzhab lo Jesús bi Jesús, tak kwathoz mzeb re zha. Tata mod lee Jesús mndaab leen kano ne mroo Jesús tya. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Per lee mbyi kuu mroo re mbi fyer leettsoo, nzhab lo Jesús: ―Laaʼa teken ditsa. Per lee Jesús mnabee lo zha, tsa yaan zha, ne nzhab Jesús lo zha: ");
INSERT INTO zaoNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Tyee liza, ne guz re kuu mtsow Diox loʼa. Tsa lee mbyiʼa ndya, ne mndaa kwent lo re men kuu mtsow Jesús lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Leettsa mretab Jesús tedib lad roo nitdoo, kwathoz laz re men mkayaa re men Jesús, tak reta men ngebet Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ne ora mzin thib mbyi kuu le Jairo, kuu nak thib zha kuu nabee ta nkaltaa re zha Israel nteed xkiiz Diox, ne mtobxub lo Jesús, ne mnaab zha lo Jesús ya Jesús liz zha, ");
INSERT INTO zaoNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","tak thibka rtsaap zha nap zha, kuu nap teeka tsiibchop liin, ne mer gath rtsaap zha. Ne or nda Jesús kwaro men mndeke dits Jesús, ne kwathoz mzhoo re men Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ne xid re mena nda thib ngot, kuu ndaʼa tsiibchop liin ndak yiz kuu nlath ren leettsoo. Ne reta kuu nap ngot mluux ngot ngwa ngot lo re doctor, ne yent cho ngok gategwe ngot. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tsa lee ngota mbig dits Jesús, ne mdiinn ngot xab Jesús. Ne oraaka lee kuu nlath ren leettsoo ngot mlet. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tsa lee Jesús mnaabdiz, ne nzhab: ―¿Cho mdiinn chon? Ne lee re zha nzhab: ―Yent cho mdiinn choʼa. Tsa lee Pey nzhab: ―Maestr, ¿chu ngwiita reta lad nzhoo zha lu, ne naabdiza, cho mdiinn choʼa? ");
INSERT INTO zaoNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tsa lee Jesús mre nzhab: ―Nzo cho mdiinn chon, tak myeen na mroo yalney chon mtegwen thib zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tsa lee ngot myeen ngot ngogaa ngot, tsa mzhiit ngot ne mbig ngot ne mtobxub ngot lo Jesús. Ne tya lo re men nzhab ngot naa chebee mdiinn ngot xab Jesús, ne xomod oraaka mgwe ngot, tak mdiinn ngot xab Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Tsa nzhab Jesús lo ngot: ―Rtsaapʼn, tak ngwalaaza Diox, kona mgweʼa. Wen bloo leettsooʼa ne tyee. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Bee ngenika Jesús leettsa mzin thib zha liz Jairo, nzhab lo Jairo: ―Lee rtsaapa ngutha, chebee ngenika lu lo maestr. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Per lee Jesús mbin nzhab zha kona, tsa nzhab Jesús lo Jairo: ―Tsebta; beeta gwalaaz Diox, ne lee rtsaapa tegwe. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ne leettsa mzin Jesús liz Jairo, mndaat Jesús diiz gataab re men liz Jairo, beeta Pey, Santiag, Juan ne xut nzaa ne xnaa nzaa. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ne reta men nzi nzhonn ne mbetsyath tak nguth nzaa, per lee Jesús nzhab lo re zha: ―Gonnt goo, tak ngutht nzaa, beeta naxat nzaa. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tsa mzhizno re zha Jesús, tak ne re zha nguth nzaa. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tsa mzhen Jesús yaa nzaa, ne nex nzhab Jesús: ―¡Nzaa, gwache! ");
INSERT INTO zaoNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tsa lee nzaa mroban. Ne oraaka ngwache nzaa, ne mnabee Jesús taa zha kuu wu nzaa. ");
INSERT INTO zaoNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ne lee xut nzaa ne xnaa nzaa kwathoz mzegey leettsoo. Per lee Jesús nzhab lo rop zha, yent cho lo gab zha kuu ngok. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Tsa mrez Jesús re tsiibchop zha kuu ngeteed lo Jesús, ne mndaa Jesús yalney ne yalnabee lo re zha, tsa tak koo zha relota mbi fyer kuu nzo leettsoo re men, ne par tegwe zha re mbyiz. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ne mtaal Jesús re zha tsa taa zha kwent chaan ta nabee Diox, ne par tegwe zha re mbyiz. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ne nzhab Jesús lo re zha: ―Neeka thib kwaa gwet goo leettsa yo goo net, neeka aga, neeka bols goo kuu yo re chaan goo, neeka pan, neeka temi; ne neeka gwet goo chop net xab goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ne loka yuu ta tsin goo, tya kwet goo asta leettsa roo goo yeza. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ne loka yez ta kayaat zha goo, broo goo yeza ne btsib goo yuyaaz kuu mke nii goo, tak kona nak thib seny kuu loo lo re tawlaz zha lee re zhaʼa went nak zha, tak mkayaat zha goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tsa mroo re zha ne ngwa zha re yez ne re ranch, mndaa zha kwent Diiz Chul ne mtegwe zha re mbyiz. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ne lee rey Herodes zha kuu nabee dita yezlyu Galilea mbin reta kuu mtsow Jesús; ne neeka net rey Herodes naa kwan tsow rey xgab, tak chop tson men mbez lee Juan mroban, ne lee Juan ntsow re kona. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ne lee tedib net zha mbez lee Jesús nak Lí kuu ngok profet ndala, ne lee tedib net zha mbez lee Jesús nak thib re profet kuu ngoo ndala, mroban. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Per lee rey Herodes nzhab: ―Si na mnabee mga zha yek Juan. Mbay ne, ¿cho nak zha kuu nzhon na ndaa zha kwent chaan tsa? Kona nlaaz rey Herodes wii Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ne leettsa mretab re kuu ngeteed lo Jesús, tsa nzhab zha re kuu mtsow zha lo Jesús. Tsa mndeno Jesús beeta re zha, ne ngwa re zha thib ta yubiz, gaxta yez Betsaida tsa kwin anta re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Per leettsa myeen re men lee Jesús nda neta, tsa mndeke re zha dits Jesús, ne mkayaa Jesús re zha ne mndaa Jesús kwent chaan ta nabee Diox lo re zha, ne mtegwe Jesús re mbyiz. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Per leettsa ndetsiy yezlyu, tsa mbig re tsiibchop zha kuu ngeteed lo Jesús ne nzhab zha lo Jesús: ―Taal re men ree bi, tsa ya zha neyy zha ne yakwaan zha kuu wu zha, re ranch kuu nzi gaxta nzhee; tak yent kwan nak nzhee wu zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Tsa nzhab Jesús lo re zha: ―Taa goo kuu wu zha. Tsa lee re zha mkab, ne nzhab: ―Beeta gaay pan ne chop mbel nap nee, chu nlaaza yati nee kuu wu reta men ree. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ne tya nzi teeka gaay mil mbyi. Tsa nzhab Jesús lo re zha kuu ngeteed lo Jesús: ―Guz goo lo re men, tsa yetob chop galbtsiiga zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ne tata mtsow re zha, tsa ngwatob re men. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tsa mzhen Jesús re gaay pan ne rop mbel, ne mwii Jesús lobee ne mndaa Jesús texkix lo Diox, tsa tsow Diox gak naroobe, ne mtsow rol Jesús re pan ne mndaa Jesús pan lo re zha kuu ngeteed lo Jesús, tsa kiid zhay lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Reta men ndow asta plotha mze leettsoo re men; ne bee mtse re zha tsiibchop chekwit pan kuu mrozhoob. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Thib wiz thita Jesús ndo ngetediz lo Diox, ne lee re zha kuu ngeteed lo Jesús nzi gaxta lo Jesús, tsa mnaabdiz Jesús lo re zha, ne nzhab Jesús: ―¿Cho nakʼn ni re men? ");
INSERT INTO zaoNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Lee re zha mkab ne nzhab: ―Thib net zha mbez lee lu nak Juan kuu mtsowleyy, tedib net zha mbez lee lu nak Lí, ne lee tedib net zha mbez lee lu nak thib re profet kuu ngoo ndala, kuu mroban nal. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","―Lee re goo, ¿cho nakʼn ndak goo? Tsa lee Pey mkab, ne nzhab lo Jesús: ―Lu nak Crist Kuu Mtaal Diox Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Per lee Jesús mnabee lo re zha, tsa yent cho lo gab zha kona. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tsa nzhab Jesús lo re zha: ―Lee na nak Zha Kuu Mtaal Diox Ngok Men, ndoblo riidʼn kwathoz yalti. Ne kayaat re zha golʼn, neeka re ngwleyy kuu nataak, ne neeka re maestr kuu nloo xkiiz Diox. Ne kuth zha na, per leettsa tsaal tson wiz lee na roban. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ne noga nzhab Jesús lo re zha: ―Loka cho goo nlaaz teke ditsʼn, ndoblo laa goo reta kuu nap goo, ne reta kuu nzo yek goo tsow goo, ne ndoblo thib ko goo yek goo gath goo, tak nyelaaz goo na. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Os lee thib zha gath tak ndeke zha ditsʼn, tetsow zha gan yalnaban kuu thitanax. Per os lee zha nzeb zha gath zha tak ndeke zha ditsʼn, tsowt zha gan yalnaban kuu thitanax yibaa. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Per kwan tsow zha gan tegal reta kwaa yezlyu ree keno zha, ne tsowt zha gan yalnaban kuu thitanax yibaa? ");
INSERT INTO zaoNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ne loka zha kuu nthoy nen ne xkizʼn, noga na Kuu Mzin Ngok Men, tethoyʼn nen zhaʼa, leettsa bretabʼn lo yezlyu ree tedib welt kon xni thoz chaan da, ne kon xni thoz chaan Xutʼn ne kon re mandad da kuu nayon. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Wlipaa na nin lo goo, lee chopta goo kuu nzi nzhee nal gatht goo, asta wii goo naa xomod nabee Diox kon yalnabee chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ne leettsa ndaʼa teeka xon wiz nzhab Jesús kona, tsa mkendab Jesús yek thib yii par tediz Jesús lo Diox. Ne mndeno Jesús Pey, Santiag ne Juan. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ne leettsa ngetediz Jesús lo Diox, mzee mod na Jesús, kwathoz naguz mloo xab Jesús, ne kwathoz mla xniy. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ne mloo chop mbyi kuu ngetediz lo Jesús. Rop zhaʼa nak Moisés ne Lí. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ne ngoo re yon zha xid thib xni thoz, ne mndediz re zha kwent chaan yalguth chaan Jesús, kuu rid Jesús yez Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ne lee Pey, Santiag ne Juan ngwatin re zha mkaal, per mdatta zha, tsa mwii zha xni thoz chaan Jesús ne lo rop zha kuu mndo lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Per leettsa lee rop mbyiʼa ndya, tsa lee Pey nzhab lo Jesús: ―Maestr, ¡wen nzi nee nzhee! Nal taa nee tson ramad, thibe gak chaana, tedibe gak chaan Moisés ne tedibe gak chaan Lí. Per neeka net Pey naa kwan nzhab Pey. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Leettsa lee Pey bee ngenika lee thib xkow mla mtow re zha, ne kwathoz mzeb re zha ngoo zha xid xkowa. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ne xid xkowa mroo thib bos kuu nzhab: ―Zha ree nak xgann na kuu mlin. Bin goo re kuu ne zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bluz or ngwalo mni bosa, tsa mwii re zha thita Jesús ndo. Ne re wiza yent cho lo nzhab re zha kuu mwii zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ne lee tedib wiz, leettsa ndyaad re zha ngwa zha yek yii, tsa kwathoz men ngwa lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tsa lee thib mbyi kuu nzo xid re mena, nex nzhab: ―Maestr, blat leettsooʼa neʼa xgann na, tak thibka zha lon. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ne nden thib mbi fyer zha, ne ntsow mbi mbetsyath zha, ne ntsow mbi nlen zha yizguthye, ne ntsow mbi ndroo btsiin roo zha. Kwathoz nakap ntsowno mbi zha ne nlaazt mbi laa mbi zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ne nzhapa na lo re zha kuu ngeteed loʼa, tsa koo zha mbi fyer leettsoo xgann na, per ngogt gatsow zhay. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Lee Jesús mkab ne nzhab: ―¡Men nad, kuu nyelaazt Diox! ¿Plal tyemp ndoblo ton lo goo ne xek leettsoon nen goo? Deno xganna nzhee. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ne leettsa lee zha ngebig, tsa lee mbi fyer mlobi zha lo yu, ne oraaka mtsow mbi mlen zha yizguthye tedib welt. Per lee mbi fyer mkox lo Jesús, ne mtegwe Jesús zha, ne mndaa Jesús zha lo xut zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ne reta men kuu nzi tya, kwathoz mzegey leettsoo zha mwii zha kuu thoz kuu mtsow Diox. Ne leettsa lee reta zha bee nzegey leettsoo mwii kuu ngok, tsa lee Jesús nzhab lo re zha kuu ngeteed lo Jesús: ");
INSERT INTO zaoNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Wen wen kenza goo koree ne nithlaazt gooy, tak na, Kuu Mzin Ngok Men, taa zha na lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Per myent re zha kuu nzhab Jesús, tak mkow yek zha kona myent zha. Ne nzeb re zha naabdiz zha lo Jesús, naa kwan kuu nzhab Jesús lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tsa lee re zha kuu ngeteed lo Jesús mndelo zha mbyodiz zha naa cho nak zha kuu mas nataak lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Per lee Jesús myeen naa kwan ntsow re zha xgab, tsa mdeez Jesús thib ndyeen lut, ne mto Jesús ndyeen lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Tsa nzhab Jesús lo re zha: ―Loka zha kuu nkayaa thib ndyeen, na nkayaa zhaʼa, ne loka zha kuu nkayaa na, noga nkayaa zha, zha kuu mtaalʼn. Tak lee zha kuu mas nataagt lo re goo, zhaʼa nak zha kuu mas nataak. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tsa lee Juan nzhab lo Jesús: ―Maestr, mwii nee lee thib zha ngoo mbi fyer kon yalnabee chaana, ne nzhab nee lo zha: “Tsowt zhay”, tak nagt zha, zhaʼaa. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Per lee Jesús nzhab lo re zha: ―Ndoblot gab goo lo zha: “Tsowt zhay”, tak lee zha kuu nayiit neʼaa, nzo zhaʼa faboraa. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Leettsa ndetsin gaxa wiz kuu bretab Jesús yibaa, thib mloo Jesús yek Jesús ya Jesús Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tsa mtaal Jesús chop tson zha mndenerga lo Jesús, ne lee re zhaʼa ngwa thib yez lut chaan zha Samaria, tsa kwaan zha pa kwet re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Per lee re zha yeza mkayaat zha re zha, tak myeen re zha yeza lee re zha nda yez Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Or mbin Santiag ne Juan kona, tsa nzhab rop zha: ―Zha Nabee, ¿chu nlaaza nabee nee tsa roo ki yibaa, ne luuzhe re zha yez ree? ");
INSERT INTO zaoNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tsa mwii Jesús lo Santiag ne lo Juan, ne mkox rop zha lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tsaraa nda re zha tedib yez. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Leettsa ndo Jesús kon re zha net, thib re zha nzhab lo Jesús: ―Zha Nabee, nlazʼn teken ditsa loka pa ta yaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Tsa mkab Jesús lo zha, ne nzhab Jesús: ―Lee re mbeet nap maa kelyoo ta nyoo maa, ne lee re min nap maa lyaat maa; per lee na, Kuu Mzin Ngok Men napt lizʼn. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tsa nzhab Jesús lo tedib zha: ―Bteke ditsʼn. Per lee zhaʼa mkab, ne nzhab: ―Zha Nabee, laa yelo kaatsʼn xutʼn. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Lee Jesús mkab lo zha, ne nzhab: ―Laa kaats re zha nguth zha nguth; per lee lu gwa gwataa kwent xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ne lee tedib zha nzhab lo Jesús: ―Zha Nabee, nlazʼn teken ditsa, per beeta laaʼa yalon diize lo re zha lizʼn. ");
INSERT INTO zaoNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús mkab lo zha, ne nzhab: ―Loka zha kuu nden yaa arad ne ngwii zha par dits zha, lortsint zhaʼa par taa zha kwent chaan ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Leettsa ngwalo mriid re koree, tsa lee Zha Nabee mli tson galbtsii chop zha, ne mtaal Jesús chopga chopga zha tener lo Jesús, tsa ya zha re yez ta naka diiz ya Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Tsa nzhab Jesús lo re zha: ―Wlipaa na nin lo goo, kwathoz nzo rtsin Zha Nabee, per lutta zha kuu ke rtsin zha nzo. Kona bnaab goo lo Zha Nabee, tsa taal zha masraa zha kuu ke rtsin zha thop yalgonn chaan zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Gwa goo, ne wen wii goo, tak lee na ngetaal goo taxal mbak zhiil xid re mbeez kuu nayii. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ne neeka thib kwaa gwet goo, gwet goo bols kuu yo re chaan goo, neeka temi, neeka tedib net labyid, ne kwetta goo tediz goo lo neeka thib zha net. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ne leettsa tab goo leen thib yuu, ner bni goo “diox” gab goo: “Wen kwin re goo kuu nzo yuu ree”. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ne os lee re zha kuu nzo yuuʼa ndoblo zha kayaa zha re diiz wen kuu ni goo lo zha, tekayaa zhay, per os lee zha ndoblot zha kayaa zhay yaante lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ne kwet goo yuuʼa, ne dow goo ne gwii goo loka kuu taa zha lo goo, tak lee zha kuu nke tsiin ndoblo gax kaa zha. Ne yat goo thib yuu tedib yuu. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ne loka yez ta ya goo ne kayaa zha goo, dow goo loka kuu tsib zha lo goo, ");
INSERT INTO zaoNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ne btegwe goo re mbyiz kuu nzo yeza, ne gab goo lo re zha: “Lee wiz kuu nabee Zha Nabee lo goo mzin gaxa lo goo”. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Per os tsin goo thib yez ta kayaat zha goo, broo goo yeza ne gab goo lo zha: ");
INSERT INTO zaoNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“¡Asta yuyaaz laz goo kuu mke nii nee, tsib neey tsa yaane! Tsa ne re tawlaz goo lee goo mkayaat nee. Per ndoblo ne goo koree: Lee wiz kuu nabee Diox mzin gaxa lo goo.” ");
INSERT INTO zaoNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Tak wlipaa na nin, lee wiz kuu naab Diox kwent lo reta men, lee yalti kuu rid re zha yeza, gak masraa nati nake yalti kuu rid re zha yez Sodoma. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Aka nalatt rid re goo zha yez Corazín! ¡Aka nalatt rid re goo zha yez Betsaida! ¡Aka nalatt rid goo yalti! Os leen yez Tiro ne Sidón gagak re kuu thoz ree kuu ngok lo re goo, ndaʼa wiz gatsee zha mod nak zha ne gagok zha lar kuu nambaat ne gatob zha lo di, tsa galoo zha lee leettsoo zha kwathoz nabil nzo por re falt kuu mtsow zha lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kona lee wiz kuu naab Diox kwent lo reta men, lee yalti kuu rid goo gak masraa nati, nake yalti kuu rid re zha yez Tiro ne Sidón. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ne lee re goo zha yez Capernaúm, ¿chu ntsow goo xgab lee goo tsin yibaa? ¡Nagte tata, sinke lee goo tsin asta xann ta nak Hades ta nzo xbi re zha nguth! ");
INSERT INTO zaoNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tsa nzhab Jesús lo re zha kuu mtaal Jesús re yeza: ―Loka zha kuu kenza kuu gab goo, noga kenza zha kuu nin; ne lee zha kuu kayaat goo noga na nkayaat zha, ne lee zha kuu nkayaat na noga nkayaat zha, zha kuu mtaalʼn. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Leettsa mretab re tson galbtsii chop zha kuu mtaal Jesús re yez, kwathoz naley nzo leettsoo re zha, ne nzhab zha: ―Zha Nabee, asta re mbi fyer nzhon diiz lo nee kon yalnabee chaana. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tsa lee Jesús nzhab lo re zha: ―Mwiin lee Maxuuy mrethin yibaa taxal bel bti. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","’Mndan yalnabee lo goo, tsa lo goo dits mbeel ne dits mbezhub, ne mndan yalnabee lo goo tsow goo gan lo yalney chaan Maxuuy, ne yent kwan tak goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ne ndoblot yo naley leettsoo goo, tak nzhon re mbi fyer diiz lo goo, sinke naley bloo goo leettsoo goo, tak lee le goo nkeʼa yibaa. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ne leeka ora lee Mbi Nayon mtsow kwathoz naley ngoo leettsoo Jesús, ne nzhab Jesús: ―Nzhoolʼn loʼa Xutʼn, Zha Nabee yibaa ne yezlyu, tak mkaatsa koree lo re zha kuu nzhaak, ne lo re zha kuu nyen re kuu, ne mloo luy lo re zha kuu gagt. Xutʼn tabaa mtsow luy tak tabaa nlaaza. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Reta kwaa mndaa Xutʼn lon. Ne neeka thib zha net cho nakʼn, sinke beeta Xutʼn ne cho nakʼn. Ne neeka thib zha net cho nak Xutʼn, sinke beeta na ne cho nak Xutʼn, ne lo re zha kuu nlazʼn lebee zha Xutʼn, tetsowʼn lebee zha Xutʼn. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tsa mwii Jesús lo re zha kuu ngeteed lo Jesús, ne nzhab Jesús lo re zha: ―Wen nda re zha kuu ngwii re kuu ngwii goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tak wlipaa na nin lo goo, tyen re profet ne tyen re rey ngwalaaz gagwii re kuu ngewii goo, per mwiit zhay, ne ngwalaaz zha gagon zha re kuu ngeyon goo per mbint zhay. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tsa lee thib maestr kuu nloo xkiiz Diox, ngwateli ne mnaabdiz lo Jesús, tak nlaaz zha yetsal zha thib kuu keki zha Jesús, tsa nzhab zha: ―Maestr, ¿kwan ndoblo tsowʼn, tsa tsowʼn gan yalnaban kuu thitanax? ");
INSERT INTO zaoNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús mkab ne nzhab: ―¿Kwan nzhab ley? ¿Ne kwan nyena or nlab luy? ");
INSERT INTO zaoNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Lee maestr kuu nloo xkiiz Diox mkab, ne nzhab: ―Ndoblo ke leettsooʼa Diox kon dib ndroo leettsooʼa, ne kon dib yalnaban chaana, ne kon dib yalney chaana, ne kon dib xgaba, ne ndoblo ke leettsooʼa tabena taxal nke leettsooʼa leeka lu. Lv. 19:18; Dt. 6:5 ");
INSERT INTO zaoNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús mkab lo zha, ne nzhab: ―Wen mkaba, btsow koree tsa bana. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Per lee zha nlaaz gab, nyent zha kona, tsa mnaabdiz zha lo Jesús, ne nzhab zha: ―¿Ne cho nak taben da tsa? ");
INSERT INTO zaoNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tsa lee Jesús mkab lo zha, ne nzhab: ―Nal tan thib kwent loʼa. Thib zha mroo yez Jerusalén ndyaadla zha yez Jericó, ne mroo chop tson wann lo zha, tsa mlowann re wann chaan zha; ne mkee wanne yek zha ne mtaan wann zha taxal zha nguth. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tsa lee thib ngwleyy mriid tya. Per or mwii ngwleyy zha, beeta mwii ngwleyy lo zha, ne thib lad mriid ngwleyy nda ngwleyy. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ne leeka tata mriid thib zha raz Leví, ne or mwii zha zhaʼa, beeta mwii zha zha, ne mriid zha nda zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Per leettsa mriid thib zha Samaria neta, or mwii zha zhaʼa, mlat leettsoo zha mne zha zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tsa mbig zha lo zhaʼa, ne mloo zha aseyt ne xit ub lo grid zhaʼa, ne mliib zha lar lo grid zhaʼa. Ne mtob zha zha dits burr zha, ne mndeno zha zha thib yuu ta mbet re men ne mkenap zha zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ne lee tedib wiza or lee zha Samaria mbi, tsa mloo zha chop temi, ne mndaa zhay lo zha kuu mndaa ta mlet zha, ne nzhab zha lo zhaʼa: “Bkenap mbyi ree, ne os leeʼa tsow raa lu gast, yat leettsooʼa na yizhe loʼa leettsa bretabʼn”. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tsa mnaabdiz Jesús lo maestr, ne nzhab Jesús: ―¿Kwan ntsowa xgab? ¿Cho lo re yon zhaʼa nak taben zha kuu mkee re wanne yek? ");
INSERT INTO zaoNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Lee maestr kuu nloo xkiiz Diox mkab, ne nzhab: ―Zha kuu mlat leettsoo mne zha kuu mkee wanne yek. Tsa nzhab Jesús lo maestr: ―Tyee, ne tataga btsow. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ne lee Jesús ndaka xnet, tsa mzin Jesús thib yez, ne tya lee thib ngot kuu le Mart mkayaa Jesús lize. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ne nap Mart thib bel Mart kuu le Mari. Ne lee Mari mndob lo Jesús, nzhon Mari re kuu nzhab Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Per lee Mart kwathoz ntsow xgab re rtsin, tsa mbig Mart lo Jesús, ne nzhab Mart: ―Zha Nabee, thita na mlaa belʼn, tsow reta kwaa. Guz lo belʼn tsa tsow zha ayudʼn. ");
INSERT INTO zaoNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Lee Jesús mkab lo Mart, ne nzhab: ―Mart, Mart, kwathoz nda leettsooʼa, ne kwathoz ntsowa xgab, ");
INSERT INTO zaoNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","per thibka kuu ndoblo tsow men ne lee Mari mli kuu mas wen, ne yent cho kibe lo Mari. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Thib wiz leettsa ngetediz Jesús lo Diox thib ta. Ne leettsa ngwalo mndediz Jesús lo Diox, lee thib zha kuu ngeteed lo Jesús nzhab lo Jesús: ―Zha Nabee, bloo lo nee naa xomod ndoblo tediz nee lo Diox, taxal mloo Juan lo re zha kuu mndeke dits Juan. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tsa nzhab Jesús lo re zha: ―Leettsa tediz goo lo Diox tenzhee ndoblo gab goo: Xut nee Diox kuu ndob yibaa, nayon nak leʼa. Nlaaz nee yaada nabeeʼa lo yezlyu ree, taxal nabeeʼa yibaa. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Taa kuu wu nee naltseree. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Btuyy reta falt kuu ntsow nee loʼa, taxal ngoo nee yek nee re falt kuu ntsow taben nee lo nee. Ne layaata nee par tsow nee kuu went. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Noga nzhab Jesús lo re zha: ―Tsow goo xgab, lee thib amig thib zha ya liz zha ngulal yaal, ne gab amig zha lo zha: “Amig, tseche tson pan lon, ");
INSERT INTO zaoNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","tak lee thib amig da kuu tith mzin lizʼn, ne naptʼn kuu tan wu zha”. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ne lee zha kab asta leen yuu ne gab zha: “Tow rooʼa keeta bi yekʼn, tak noowa roo yuu ne naxata re zhiinn na, yechetʼn par tan pan loʼa”. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Wlipaa na nin lo goo, tegal nlaazt zha yeche zha par taa zha pan lo amig zha ngulal yaal, per tak thib ndo amig zha ngenaabe lo zha, teyeche zha ne taa zha reta kuu ndeche amig zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kona nin lo goo; bnaab gooy, ne lee Zha Nabee taay; bkwaan gooy tsa yetsale lo goo; Bteez goo roo yuu, tsa xaal zha roo yuu lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tak reta zha kuu naabe tekayaa zhay; ne reta zha kuu nkwaane, teyetsale lo zha; ne reta zha kuu nteez roo yuu, taxaal zha roo yuu lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Os lee thib goo nap thib ndyeen lut, ne naab ndyeen tsa pan wu ndyeen lo goo, ¿chu tataa goo thib ke lo ndyeen? O os lee ndyeen naab ndyeen thib mbel wu ndyeen, ¿chu tataa goo thib mbeel lo ndyeen? ");
INSERT INTO zaoNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ne os lee ndyeen naab thib ngo lo goo, ¿chu tataa goo thib mbezhub lo ndyeen? ");
INSERT INTO zaoNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ne tegal zha went nak goo, per nzhaak goo ndaa goo kuu wen lo zhiinn goo, ne lee Xutaa kuu ndob yibaa, masraa wen nak zha, ¡xomod taat zha Mbi Nayon chaan zha lo reta zha kuu naabe lo zha! ");
INSERT INTO zaoNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Leettsa lee Jesús ngegoo thib mbi fyer leettsoo thib mbyi mud; ne leettsa mroo mbi fyera leettsoo mbyiʼa, lee mbyiʼa mndediz. Tsa kwathoz mzegey leettsoo re men mwii kona. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Per lee chop tson zha nzhab: ―Kon yalney chaan Beelzebú, kuu nabee lo re mbi fyer ngoo zha re mbi fyer. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Lee tedib net zha nlaaz ne naa cho nak Jesús, tsa nzhab zha lo Jesús: ―Bloo thib seny yibaa lo nee. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Per neʼa Jesús naa kwan ntsow re zha xgab, tsa nzhab Jesús lo re zha: ―Reta yez kuu nzhak chop, ne ngyo zha leeka re tawlaz zha, xegt yeza naroob, ne tataka leen thib yuu ta ngyo zha kon leeka re zha kuu nzo liz zha, xegt re zhaʼa naroob. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ne tataka, os lee Maxuuy nzhak chop, ne ngyo Maxuuy kon leeka Maxuuy, xegt Maxuuy naroob. Nin koree tak lee re goo mbez lee na ngo mbi fyer kon yalney chaan Beelzebú; ");
INSERT INTO zaoNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ne os leey tatay, ¿cho mndaa yalnabee lo re zha kuu ngeteed lo goo, tsa ngoo zha mbi fyer? Tak leeka re zha nloo wlit kuu ni goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Per os leen ngon mbi fyer kon yalney chaan Diox, koree nloo lee yalnabee chaan Diox mzina lo re goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Leettsa lee thib mbyi kuu ney wen nkenap liz kon yiib, wlipaa na nin, yent cho lowann re chaan zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Per os lee tedib mbyi kuu mas ney nake lee zha, ndyaad ne tsow gan lo zha, ne kib mbyiʼa reta yiib zha kuu nap zha konfyans, tsasi tak kib mbyiʼa re kuu nkeno zha ne kiid mbyiy lo re amig mbyi. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Re zha kuu nagt zha da, re zhaʼa nak zha kuu nayii nen; ne lee re zha kuu nket tsiin kon na, re zhaʼa nluux rtsin na. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Leettsa lee thib mbi fyer ndroo leettsoo thib zha, nda mbi thib ta yubiz, ne nkwaan mbi ta roxkwan mbi; ne tak mzalt ta roxkwan mbi, tsa nda leettsoo mbi fyer: “Bretabka na lizʼn, ta mroon”. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ne leettsa ndretab mbi, nzal mbi leettsoo zha kuu mroo mbi, taxal leen thib yuu kuu nalob ne nambi na. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tsa nda mbi ne ndaxii mbi tedib gaz mbi kuu mas nakap nak nake mbiʼa. Tsa lee zhaʼa mas nakap gak nake taxal ngok zha ner. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Leettsa ngeni Jesús re koree, tsa lee thib ngot kuu nzo xid re mena mrez dib gan ne nzhab: ―¡Kwathoz wen nda xnaaʼa, kuu ngopa ne mndaa nzii ngwiiʼa! ");
INSERT INTO zaoNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Per lee Jesús mkab, ne nzhab: ―Lee na ni: ¡Kwathoz wen nda re zha kuu nzhon xkiiz Diox, ne nzhon dize! ");
INSERT INTO zaoNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ne leettsa mkaltaa kwaro men lo Jesús, tsa nzhab Jesús lo re zha: ―Kwathoz nakap nak re men kuu nzo tyemp ree, tak nlaaz zha tsowʼn thib kuu thoz, per neeka thib kuu thoz loot lo re zha, beeta seny chaan Jonás loo lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tak leeka taxal ngok Jonás thib seny lo re zha yez Nínive, leeka tata gak na, Kuu Mzin Ngok Men, seny lo re men kuu nzi nal. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ne lee wiz kuu naab Diox kwent lo re men tyemp ree, tsa lee ngot kuu nabee lo re zha re yez kuu nzi lad Sur, keki re men kuu nzi nal re wiz ree, tak lee zhaʼa mroo asta tedib lad lo yezlyu ne myaad zha par gon zha yalnzhaak chaan Salomón. Ne nzhee ndo thib zha kuu mas nataak nake Salomón. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ne noga re zha yez Nínive keki re zha kuu nzi nal re wiz ree, wiz kuu naab Diox kwent lo reta men, tak mbin re zha yeza diiz lo Jonás, ne mtsee zha mod went kuu nak zha ne ngwalaaz zha Diox. Ne nzhee ndo thib zha kuu mas nataak nake Jonás. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Neeka thib zha nkeet thib xni, ne ntob zhay thib ta nagaats, ne neeka ntowt zhay leen thib zhibey, sinke ntob zhay thib ta ya ndab, tsa teniy lo re zha kuu ndaab leen yuu. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ngutlo zha nak taxal xni kuu nteni dita zha; ne os lee ngutlo zha wen, dita zha ndo lo xni; per os lee ngutlo zha went, dita zha ndo lo yalkow. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","List gwatsin goo, tak cha nyenit ngutlo goo ne cha lo yalkow nzi goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kona os lee dita kwerpa nzo xni, ne neeka lutte nakowt na, reta kuu wen loo loʼa, taxal thib ta wen nke xni. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Leettsa ngwalo nzhab Jesús re koree, tsa lee thib fariseo ngwa nzhab lo Jesús, ya Jesús wu Jesús liz zha. Ne leettsa mzin Jesús liz zha, tsa mndob Jesús ne mndelo Jesús ndow. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tsa mzegey leettsoo zha mwii zha, lee Jesús mnat ngeyow. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tsa lee Jesús Zha Nabee, nzhab lo zha kuu nak liz yuu: ―Lee re goo zha fariseo, wen wen nteech goo dits re bas ne dits re yann, per lee leettsoo goo nambit, tak tsey nzo re kuu nlowann goo ne re kuu went. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Zha nad! ¿Chu net goo leeka zha kuu mdexkwaa dits kwaa leeka zhaʼa mdexkwaa leene? ");
INSERT INTO zaoNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mas wen leettsa taa goo karida lo thib zha prob, tsa dita goo gak zha nambi. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Aka nalatt rid goo zha fariseo! Tak ndaa goo tsii part re chaan goo gon lo Diox, ne asta re bthyon xtil, rud ne relota yizh kwaan, per ntsowt goo xgab tsow goo re kuu nak kuu wen, ne neeka yent yalnkelaaz chaan Diox leettsoo goo. Re koree nak kuu ndoblo tsow goo, ne neeka laat goo tsow goo tedib net re kona. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Aka nalatt rid goo zha fariseo! Tak kwathoz nyow leettsoo goo tob goo re ta nataak, ta nkaltaa reʼaa nteedaa xkiiz Diox, ne wen nzo leettsoo goo nkiits yek re men ni men “diox” lo goo lo xbi. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Aka nalatt rid re goo zha fariseo ne goo maestr kuu nloo xkiiz Diox! Tak lee re goo nak taxal roo baa kuu nloot, ne lee re men kuu ndiy ditse nete. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tsa lee thib re maestr kuu nloo xkiiz Diox nzhab lo Jesús: ―¡Maestr, leettsa tabaa niʼa lo nee, nkox nee loʼa! ");
INSERT INTO zaoNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Tsa nzhab Jesús lo zha: ―¡Noga goo maestr kuu nloo xkiiz Diox, aka nalatt rid goo! Tak ntsib goo kuu ne dits tedib men, kuu neeka thib men yet gwe. Ne lee goo neeka kon kwen yaa goo ndiinnt gooy. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Kwathoz nalatt rid goo! Tak ndexkwaa goo almitr re roo baa chaan re profet kuu ngoo ndala, re zha kuu leeka re tey goo mbeth. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ne koree nloo lee re goo ndak goo wen kuu mtsow re tey goo zha ndala, tak re tey goo mbeth re profet, ne lee re goo ndexkwaa almitr roo baa chaan re profeta. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Kona lee Diox lo yalnzhaak chaan Diox nzhab Diox: “Taalʼn re profet da ne re apóstl da, ne thib net zha kuth zha ne lee tedib net zha reke zha dits”. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kona lee ren chaan reta profet kuu mbeth zha ndala, desde leettsa mdexkwaa yezlyu ne asta nal, leey naab kwent lo reta men kuu nal re wiz ree, ");
INSERT INTO zaoNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","desde leettsa mxo ren Abel ne asta leettsa mxo ren Zacarí kuu mbeth zha xtow bkoog ne gwodoo. Wlipaa na nin lo goo, reta koree naab Diox kwent lo re zha kuu nzi nal wiz ree. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Aka kwathoz nalatt rid goo maestr kuu nloo xkiiz Diox! Tak nap goo yab chaan yalnzhaak, per nteedt goo ne neeka nlaat goo teed tedib net zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Leettsa ngwalo nzhab Jesús re koree; tsa lee re maestr kuu nloo xkiiz Diox ne re fariseo kwathoz mkezhyan zha, ne mndelo re zha mnaabdiz zha kwaro kwaa lo Jesús, ");
INSERT INTO zaoNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","tsa kab Jesús thib kuu went, tsa tak keki zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ne tyen mil men mkaltaa lo Jesús, asta ndelo zha nzhoo altaa zha. Tsa mni Jesús lo re zha kuu ngeteed lo Jesús, ne nzhab Jesús: ―List gwatsin goo lo re kuu nloo re fariseo, re zha kuu kwathoz ndrub ne ntsowt kuu wen, tak lee re zha nak taxal lebadur kuu ntsow nyezhoob koob. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tak reta kuu nloot, too thib wiz telooy, ne reta kuu nzogaats too thib wiz leey roo lo xni. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kona, reta kuu ni goo lo yalkow, reta zha gone lo xni, ne reta kuu mni goo xlaanta, asta yek yuu to zha ne dibgan zha gab zhay. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Lo re goo kuu nak amig da nin. Tsebt goo ne goo re zha kuu nzhuth kwerp, tak leettsa yelo tsow zha kona yent raa kwan tak tsow zha lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nal nin lo goo naa cho lo ndoblo tseb goo; btseb goo ne goo zha kuu tak kuth kwerp goo ne nap yalnabee par ko goo gabil. Lo zhaʼa btseb goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Wii goo, nthot zha gaay min bzhizh por chopka rehal. Per wlipaa na nin, nithlaazt Diox neeka thib re maaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ne asta re yitsek goo nak kwent lo Diox. Kona tsebt goo, tak masraa nataak goo nake naroob min bzhizh. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Wlipaa na nin, os lee thib zha gab zha lo re men lee zha nak zha da, noga na Kuu Mzin Ngok Men, gapʼn lo re mandad Xutʼn, lee zha nak zha da. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Per lee re zha kuu gab lo re men nagt zha, zha da, noga na gap lo re mandad chaan Xutʼn nagt zhaʼa zha da. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Ne reta zha kuu ni diiz went lo na, Kuu Mzin Ngok Men, tetuyy Diox falta, per lee zha kuu ngode lo Mbi Nayon chaan Diox, tuyyt Diox falt chaan zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Ne leettsa yataan zha goo lo re zha kuu nak gobyern ne lo re zha kuu nak tsiin, ne lo re zha kuu nabee ta nkaltaaʼaa nteedaa xkiiz Diox, tsowt goo xgab naa kwan kab goo ora, ");
INSERT INTO zaoNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","tak lee Mbi Nayon ne lo goo naa kwan kuu ndoblo goo gab goo ora. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tsa lee thib zha kuu ndo xid re men nzhab lo Jesús: ―Maestr, guz lo wetsʼn, tsa taa zha garol herens chaan xutʼn lon. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús mkab, ne nzhab: ―Amig, ¿cho mton lo goo par gakʼn jwez o par gakʼn zha kuu kiid yu? ");
INSERT INTO zaoNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tsa lee Jesús mwii lo re men, ne nzhab: ―List gok goo, kenap goo goo, tablaazt goo keno goo masraa kwaa kuu ndoblot goo keno goo, tak nataagt re kona masraa nake yalnaban chaan goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tsa mndaa Jesús thib kwent nanzee, ne nzhab Jesús: ―Ngoo thib zha rik, kuu kwathoz ngok yalgonn, ");
INSERT INTO zaoNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ne kwathoz ntsow zha xgab, ne nzhab zha: “¿Kwan tsowʼn? Naptʼn pa kotsowʼn re yalgonn da.” ");
INSERT INTO zaoNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tsa mtsow zha xgab nzhab zha: “Neʼa na kwan tsowʼn. Nal luuzhʼn re loo da ta ngotsowʼn xoobʼn ne texkwaan tedib kuu mas naro, tsa tegaay kotsowʼn re yalgonn da, ne re kuu napʼn”, ");
INSERT INTO zaoNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ne gapʼn lo yalnaban da: “Nalsi kwathoz kuu napa, ne tegaay wuʼa tyen liin, kwathoz wen bloo leettsooʼa, broxkwan, bdow ne wii”. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Per lee Diox nzhab lo zhaʼa: “Mbyi nad, leeka nal yaal ree yalʼn kibʼn yalnaban chaana, ne lee re kuu napa, ¿cho lo yaane tsa?” ");
INSERT INTO zaoNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tbaa tak re zha kuu nkaltaa naroob kwaa lo yezlyu ree, per lee lo Diox neeka thib kwaa napt zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tsa nzhab Jesús lo re zha kuu ngeteed lo Jesús: ―Tata mod nin lo goo: Tsowt goo xgab por kuu wu goo ne kuu gu goo par ban goo, ne neeka tsowt goo xgab lar kuu gok goo, ");
INSERT INTO zaoNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","tak masraa nataak yalnaban chaan goo nake kuu nzhow goo, ne masraa nataak kwerp goo nake xab goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Wii goo lo re myak, neeka nzhannt maa, neeka nthopt maa yalgonn, ne neeka ngotsowt maa yalgonn maa leen loo, per lee Xutaa kuu ndob yibaa, ndaa kuu nzhow maa. Ne masraa nataak goo nake re myak. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ne tegal kwathoz ntsow goo xgab zhen goo telut, per gagt raa zhen goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ne os lee goo gagt tsow goo thib kuu lut taxal koree, ¿chebee ntsow goo xgab tedib net re kwaa? ");
INSERT INTO zaoNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Wii goo naa xomod nzhen re yee kuu ndab wan. Nkeet yee tsiin ne neeka ndexkwaat yee lar. Per nin lo goo, neeka rey Salomón, kuu mdok pur lar wen, mdok xabt taxal thib re yee ree. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ne os lee Diox ntsow chul na re yizh kuu ndab wan naltseree, ne lee gal yee thop zhay ne teyy zhay lo ki, wlipaa na tataga taa Diox re kuu ndeche goo lo goo. ¿Chebee lutta nyelaaz goo Diox? ");
INSERT INTO zaoNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kona yat leettsoo goo naa kwan wu goo ne gu goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tak lee re men yezlyu ree nkwaan re koree, per lee Xutaa neʼa naa kwan ndeche goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mas wen kwaan goo nabee Diox lo goo lo reta kwaa, tsa lee Diox taa reta kuu ndeche goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Tsebt goo, tak goo nak mbak zhiil da, tegal lutta goo, lee Xutaa nlaaz taa yibaa ta nabee Xutaa lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Btho goo re kuu nap goo, ne btaa goo temi lo re prob, tabaa mod ngegotsow goo chaan goo leen bols kuu nluxt, tsa keno goo chaan goo yibaa, ta gagt lowann zhay ne ta ket mbete. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tak ta nap goo re chaan goo, leeka tya ndo leettsoo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’List gwatsin goo, ne list bdok goo xab goo, ne list bkee goo kandil goo, ");
INSERT INTO zaoNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","gok goo taxal thib mos kuu list ndo, leettsa lee patron mos bretab ngwa lo fandan, or lee patron zha teez roo yuu, lee zha lista ndo xaal roo yuu. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kwathoz wen nda re mos kuu list ndo leettsa lee patron mos yaad; wlipaa na nin lo goo, lee patron zha gab lo zha: “De wuʼa”. Ne leeka lee patron zha ko kwaa leen yann wu zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ne kwathoz wen nda re mos kuu list ndo leettsa yaad patron zha, tegal ngulal yaal o ndeyeniʼa yezlyu yaad patron zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Per ndoblo ne goo koree: Os lee zha kuu nabee thib yuu, ne zha polor la wann liz zha, thibka list to zha ne taat zha diiz xaal wann liz zha, tsa lowann wann chaan zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kona noga goo list gwatsin goo, tak lee na, Kuu Mzin Ngok Men, yalʼn wiz kuu ntsowt goo xgabe. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tsa lee Pey mnaabdiz ne nzhab: ―Zha Nabee, ¿chu lo re nee mniʼa kwent nanzee ree o noga lo re men mni luy? ");
INSERT INTO zaoNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tsa lee Zha Nabee nzhab: ―¿Cho nak mos wen? Lee mos wen nak zha kuu mlaa patron liz patron, tsa taa zha kuu wu tedib net re mos patron, leettsa ndoblo wu re mos. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kwathoz wen nda mos kuu ngetsow kuu nzhab patron mos lo mos, leettsa lee patron zha bretab. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Wlipaa na nin lo goo, lee patron zha tsow gak zha, zha kuu nabee lo reta kuu nap patron. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Per os lee mosa tsow xgab: “Bretabt patron da nal”, ne telo zha kee zhay yek tedib net mos patron, ne telo zha wu zha ne gu zha ne ke zha yalgwiy, ");
INSERT INTO zaoNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ne wiz kuu ntsowt zha xgab lee patron zha bretab, ne leettsa tsin patron zha, tsa teti patron zha, ne ko patron zhaʼa ta nzo re zha kuu nzhont diiz. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Lee mos kuu neʼa, naa kwan mtaan patron zha tsow zha, ne mndo lista zha, ne neeka mbint zha diiz kuu mnabee patron lo zha, kwathoz kin zha zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Per lee mos kuu net naa kwan mtaan patron zha tsow zha, ne mtsow zha kuu went, mas lutta yaa bins kee zha yek zhaʼa. Tak loka zha kuu kwaro kwaa mndaa patron lo, kwaro kwaa naab patron lo zhaʼa, ne lee zha kuu mkayaa naroob kwaa lo patron, tataga naroob kwaa naab patron lo zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Tsa nzhab Jesús: ―Lee na ndyal mtob ki lo yezlyu ree. ¡Ne ndakʼn malaay mzhena bele! ");
INSERT INTO zaoNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","¡Per ndoblo riidʼn yalti kuu kwathoz nagan, kuu nak taxal gak leyʼn! ¡Ne dita nal kwathoz nalatt nzo leettsoon, asta yelo riidʼn koree! ");
INSERT INTO zaoNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Chu ntsow goo xgab lee na ndyal, tsa wen kwin re men lo yezlyu ree? Nagte tata. Sinke leen ndyal tsow rol re men. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ne desde naltseree par delant, leen thib yuu ta nzo gaay zha, tson zha yii ne chop zha, ne chop zha yii ne tson zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tsa lee xut zha yii ne xgann zha ne lee xgann zha yii ne xut zha, ne lee ngot yii ne rtsaap, ne lee rtsaap ngot yii ne xnaa. Ne lee xnaatsaap zha yii ne zhizh ne lee zhizh zha yii ne xnaatsaap zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ne noga nzhab Jesús lo re men kuu nzi tya: ―Leettsa ne goo lee xkow nke ta mbix wiz, mbez goo: “Tala yi”, ne tata nzhake. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ne leettsa ne goo le mbi ndroo lad sur, mbez goo: “Kwathoz la bee nal”, ne tata nzhake. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Zha nkedi nak goo, zhaa kuu mbez ne zhaa kuu ntsow goo! Nlebee goo re seny kuu nloo lobee ne kuu nloo lo yezlyu, ¿per xomod gagt yen goo naa cho tyemp naban goo nal? ");
INSERT INTO zaoNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Ne chebee gagt kobee goo naa kwan nak kuu wen? ");
INSERT INTO zaoNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Os leeʼa ndoblo yaʼa lo re zha kuu nak tsiin kon zha kuu nayii neʼa, mas wen btsow yaan wen goo rop goo leettsa ndo goo net, tsa teriidt zha lu yuulow, ne tsa lee zha kuu nak tsiin taat zha lu lo zha kuu nkenap tsib, tsa ko zhaʼa lu tsib. ");
INSERT INTO zaoNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tak wlipaa na nin loʼa, roota tsib, asta yelo kizha kuu ndobloʼa kizha. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ne leeka thib re wiza, ngwa chop tson zha nzhab lo Jesús, lee Pilat mbeth chop tson zha yezlyu Galilea, ne mchuuxnit Pilat ren re zhaʼa kon ren re maa kuu mndaa re zhaʼa lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tsa nzhab Jesús lo re zha: ―¿Kwan ntsow goo xgab? ¿Chu ntsow goo xgab tata mzhaak re zhaʼa, tak masraa falt ndab zha nake tedib net re zha yezlyu Galilea? ");
INSERT INTO zaoNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Per lee na ni lo goo, nagte tata; ne os lee goo laat goo re mod went kuu nak goo, ne yelaazt goo Diox, noga goo tath goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ne, ¿kwan ntsow goo xgab? Leettsa mla thib yuu naro dits re tsiinbtson zha, thib ta le Siloé ne nguth re zha, ¿chu ntsow goo xgab masraa ndab re zhaʼa falt nake re zha yez Jerusalén? ");
INSERT INTO zaoNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Bren ganin lo goo, nagte tata; os lee goo laat goo re mod went kuu nak goo, ne yelaazt goo Diox, noga goo gath. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tsa lee Jesús nzhab tedib kwent nanzee lo re zha, ne nzhab Jesús: ―Thib mbyi mkeno thib xann ya ig lo yu zha ta nzhann zha luts ub. Ne ngwa zha ngwakwaan zha ig lo ya, per neeka thib ig mzalt lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tsa nzhab zha lo zha kuu nkenap yu zha: “Wii, ndaʼa tson liin thibka nyalʼn nyaadkwaan na xle lo ya ree, per neeka thib welt nzaltʼn xle lo ya. Bgay tak ntetsaay yu da.” ");
INSERT INTO zaoNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Per lee zha kuu nke tsiin lo zha, nzhab: “Zha Nabee, btaane tedib liin, nal teleen yu xanne ne gon bewgwe, ");
INSERT INTO zaoNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ne os leey taay xle ya wene, per os leey taate xle tsa ga nay”. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jesús mloo lo re men ta nkaltaa zha nteed zha xkiiz Diox wiz kuu ndroxkwan zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ne tya ndo thib ngot kuu ndaʼa tsiinbtson liin ndakti lo thib mbi went, kuu ndaat diiz li dits ngot. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ne leettsa mwii Jesús zha, tsa mrez Jesús zha, ne nzhab Jesús lo zha: ―Mgweʼa lu lo yiz went kuu mzhaaka. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ne mxoob Jesús yaa Jesús dits zha, ne oraaka lee dits zha mli, ne mndelo zha mbil zha lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tsa lee zha kuu nabee ta nkaltaa re zha nzhool zha lo Diox, mkezhyan zha, tak lee Jesús mtegwe thib ngot wiz kuu ndroxkwan re zha, tsa nzhab zhaʼa lo re men: ―Xoop wiz nke men tsin thib sman ne tsow men re kwaa, tsa ndoblo goo yaad goo tsa tegwe zha goo. Per yaadt goo wiz kuu ndroxkwanaa. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tsa lee Jesús mkab ne nzhab: ―¡Zha nkedi nak goo, zhaa kuu mbez goo ne zhaa kuu ntsow goo! ¿Chu nxagt goo ngon goo o burr goo, wiz kuu ndroxkwanaa, ne nyano goo maa nzhuu maa nit? ");
INSERT INTO zaoNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ne lee ngot ree, nak zha raz chaan Abraham, ne ndaʼa tsiinbtson liin naliib zha lo Maxuuy, ne ¿chu ndoblot laa ngot nal wiz kuu ndroxkwanaa? ");
INSERT INTO zaoNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Leettsa ngwalo nzhab Jesús kona, reta zha kuu nayii ne Jesús mthoy zha, per lee re men kwathoz naley ngoo leettsoo mwii re kuu thoz kuu mtsow Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tsa lee Jesús nzhab lo re men: ―Nal leen ta tedib kwent nanzee lo goo, chaan ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Leey nak taxal thib mbiz mostaz kuu ngonn thib mbyi lo yu mbyi. Mlene, mzhene ne ngoke thib ya, tsa lee re min mdexkwaa lyaat lo re zhite. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Noga nzhab Jesús: ―Nal lee na ta tedib kwent nanzee lo goo, tsa ne goo xomod nak ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Leey nak taxal lebadur kuu mloo thib ngot leen tson medid arin, tsa tsowe yezhoob koob. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ne leettsa ndo Jesús net nda Jesús Jerusalén, tsa mloo Jesús lo re zha kuu nzo re yez ne lo re zha kuu nzo re ranch ta ndriid Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tsa lee thib zha mnaabdiz lo Jesús, ne nzhab: ―Zha Nabee, ¿chu lut zha nak zha kuu tsow gan yalnaban kuu thitanax? Tsa lee Jesús mkab ne nzhab: ");
INSERT INTO zaoNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Bxek goo tsa tetsow goo gan tab goo roo pwert kuu naya, tak wlipaa na nin lo goo, kwathoz zha kwaan zha tab zha, per tsowt zha gan tab zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","’Ne leettsa lee zha kuu nak chaan yuu yeteli tow roo yuu, tsa lee re goo kuu yaan lee teez goo roo yuu, ne gab goo: “Zha Nabee, xaal roo yuu lo nee”. Tsa lee Zha Nabee kab lo goo ne ne: “Nlebeetʼn goo, ne neeka netʼn naa cho nak goo”. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tsa lee re goo telo ne lon: “Ndow nee kon lu ne ngwii nee kon lu, ne lu mloo lo re tawlaz nee re net”. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Per lee na ni lo re goo tedib welt: “Nlebeetʼn goo, neeka netʼn naa cho zha goo; beche goo lon, zha kuu ntsow kuu went”. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ne tsa gonn goo ne tub keley goo, or wii goo Abraham, Isaac, Kob ne reta profet, re zha kuu nzo yibaa ta nabee Diox, ne lee re goo yaan lee. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tak kwathoz re zha kuu nzo dib naxta lo yezlyu, yaad tob roo mes leen yibaa ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ne nzo chop tson goo kuu nataagt nal, gak nataak tsya; ne lee re goo kuu nataak nal, lee tsya gak goo zha nataagt. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ne lee chop tson fariseo mbig lo Jesús, ne nzhab: ―Broo nzhee ne tyee, tak lee rey Herodes nlaaz kutha. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Lee Jesús mkab ne nzhab: ―Gwa goo ne guz goo lo mbeeta: “Naltseree ne yee gon re mbi fyer, ne tegwen re mbyiz, ne lee wiz yelo luuzhʼn rtsin na”. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Per ndoblo ndaka na xnetʼn, naltseree yee ne wiz. Tak ndoblot gath thib profet ta nagt Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Men Jerusalén, men Jerusalén, goo kuu nzhuth re profet ne nkee ke yek re zha kuu ntaal Diox lo goo! ¡Tyen welt ngwalazʼn gathopʼn re zhiinn goo, taxal nthop ngid re bich ngid xann xiil ngid, per mzhyalt goo! ");
INSERT INTO zaoNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Wii goo, lee ta nzo goo yaan wan; ne wlipaa na nin lo goo, bret raa goo wii goo na, asta leettsa tsin wiz kuu gab goo: “¡Kwathoz wen nak zha kuu ndyaad kon yalnabee chaan Zha Nabee!” ");
INSERT INTO zaoNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Thib wiz sabd, lee Jesús ngwa ndow liz thib fariseo, kuu nabee lo re fariseo, ne lee tedib net fariseo ngewii naa kwan tsow Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ne tya ndo thib zha kuu ndak yiz ki. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Tsa lee Jesús mnaabdiz lo re maestr chaan ley ne lo re fariseo, ne nzhab: ―¿Kwan nzhab lo ley? ¿Chu tak tegwe men thib mbyiz wiz sabd o gagte? ");
INSERT INTO zaoNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Per mkabt re zha. Tsa lee Jesús mdiinn mbyiza ne mtegwe Jesús zha ne mtaal Jesús zha ndya zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tsaraa nzhab Jesús lo re fariseo: ―Os lee thib goo nap thib xgann o thib ngon, ne la xgann goo o ngon goo leen pos wiz sabd, ¿chu koot goo xgann goo o ngon goo wiz sabd? ");
INSERT INTO zaoNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ne neeka thib zha ngogt gakab lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Or mwii Jesús lee re zha kuu mrez zha lo ani, ngekwaan zha thib ta mas wen tob zha, tsa mre Jesús mni Jesús kon diiz nanzee lo re zha tedib welt, ne nzhab Jesús: ");
INSERT INTO zaoNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Leettsa lee thib zha kweza yaʼa fandan, kwiita ta mas nataak toba, tak cha tsin tedib zha kuu mas nataak nake lu, ");
INSERT INTO zaoNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","tsa lee zha kuu mreza big ne loʼa: “Amig taa ta ndoba tob zha ree”. Tsa nathoy nzhaka yeteliʼa ne yaʼa toba lo bank kuu nzi asta dits re men. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kona mas wen leettsa kwez zha lu yaʼa lo thib fandan, asta par dits re zha toba, ne leettsa yaad zha kuu mreza, tsa ne zha loʼa: “Amig, briid toba asta delant”. Tsasi gaka zha kuu nataak taxal re zha kuu nzi ta nataak. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tak lee zha kuu ntsow nataak leeka lee, zhaʼa gak zha kuu nataagt, ne lee re zha kuu ntsow nataagt leeka lee, zhaʼa gak zha nataak. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tsa nzhab Jesús lo zha kuu mtsow fandan: ―Leettsa tsowa thib ani, kwezta re amiga, neeka re wetsa, neeka re zha liza, ne neeka re zha rik kuu nzo gaxta liza; tak reta zhaʼa tak kwez zha lu wuʼa liz zha, ne tata kix zha kuu ndow zha loʼa. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kona mas wen leettsa tsowa thib ani, brez re prob, re tunk, re mthans ne re zha syeg, ");
INSERT INTO zaoNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","tsa lee Diox taa re kuu wen loʼa, tak lee re zhaʼa gagt kix zha re kuu ndow zha loʼa, per leettsa tsin wiz kuu roban re zha kuu nali ngok lo Diox, tsa leeʼa kayaa kuu wen kuu mtsowa gan. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Leettsa mbin thib zha kuu ndob roo mes kona, tsa nzhab zha lo Jesús: ―Kwathoz wen nda re zha kuu tab wu pan leen yibaa ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tsa lee Jesús mkab lo zhaʼa ne nzhab: ―Thib mbyi mtsow thib rtsee ro, ne mrez zha kwaro men. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ne or mzin or kuu wu rtsee re men, tsa mtaal zha mos zha ngwane lo re zha kuu mrez zha: “De goo, tak reta kuu nziba”. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Per lee reta zha mndelo zha nzhab zha lo mos gagt ya zha. Lee thib zha nzhab: “Ngwalota mzhiin thib le yu, ne ndeche yatwiin loy, ta mod gagt yan; gaba lo zha kuu mtaala tsow zha perdon na”. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Lee tedib zha nzhab: “Ngwalota mzhiin gaay net ngon, kona gagt yan; gaba lo zha kuu mtaala tsow zha perdon na”. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ne lee tedib zha nzhab: “Ngwalota mtseyan, kona gagt yan”. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tsa lee mos mre ne mndaa kwent kona lo patron. Tsa lee patron mos kwathoz mndak leettsoo, ne nzhab lo mos: “Lijer gwa re net to ne re net thib dita yez, ne yaadnoʼa re zha prob, zha tunk, zha mthans ne re zha syeg”. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ne leettsa mretab mos nzhab mos: “Zha Nabee, mtsowa na kuu mnabeeʼa lon, per bee nzo raa ta tob masraa men”. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tsa lee patron nzhab lo mos: “Gwa re net yez ne re net kuu nda wan, ne btsow fwers re zha tsa yaad zha, tsa tse lizʼn. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tak lee na ni, neeka thib re zha kuu mrezʼn ner, wut kuu mtsowʼn.” ");
INSERT INTO zaoNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ne kwathoz men mndeke dits Jesús, tsa mtsere lo Jesús ne nzhab Jesús lo re zha: ");
INSERT INTO zaoNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Os lee thib zha nlaaz teke ditsʼn, ne nket leettsoo zha na masraa nake xut zha ne xnaa zha, ne tsaal zha, ne zhiinn zha, ne wets zha ne btan zha ne leeka lee zha, gagt gak zha, thib zha kuu teke ditsʼn. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ne os kot zha leettsoo zha thib gath zha tak nyelaaz zha na, ne teket zha ditsʼn, gagt gak zha thib zha da. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tak os lee thib zha nlaaz ta thib yuu, ndoblo koo zha kwent naa chu tegaa temi lo zha par taa zha yuu. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tak os lee zha tob zha simyent ne tsowt zha gan taa zha yuu, tsa lee re zha kuu wiiy telo zha zhizno zha zha, ");
INSERT INTO zaoNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ne gab zha: “Anta mtob zha baa simyent ne mtsowt zha gan gata zha yuu”. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ne tataka, os lee thib rey, nlaaz yo kon tedib rey, ner ndoblo tob rey ne tsow rey xgab, naa chu tak yo rey kon tsii mil soldad chaan rey, kon tedib rey kuu ndyaad kon thib gal mil soldad. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ne os lee rey ne rey gagt yo rey kon tedib reya; leettsa lee tedib reya bee ndo tith, tsa ndoblo rey taal thib zha kuu ya ni lo tedib reya, tsa wen kwin re zha ne yot zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ne tataka, os lee goo laat goo re kuu nap goo, gagt gak goo zha kuu teke ditsʼn. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Wen ted leettsa natsig ted, per os lee ted natsigt raa ted, gagt raa gak natsig ted tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Neeka lortsin raa ted par gak ted beww, neeka par gake yu sinke tabaata kobi zhay. ¡Os lee goo ndob nza goo ndoblo yen goo koree! ");
INSERT INTO zaoNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Reta zha kuu ntsow kobral temi chaan yezlyu kuu nzhax lo zha Roma nzi tya, ne re zha kuu went nak, mbig re zha tsa gon zha kuu ni Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Per lee re fariseo ne re maestr kuu nloo xkiiz Diox, nlooz zha Jesús ne mbez zha: ―¡Zha ree nkayaa re zha kuu nap falt ne noga nzhow zha kon re zha kuu ndab falt! ");
INSERT INTO zaoNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tsa lee Jesús nzhab tedib kwent nanzee lo re zha, ne nzhab Jesús: ");
INSERT INTO zaoNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―¿Cho thib zha, os nap zha thib gayoo mbak zhiil ne mtab zha thib maa? ¿Chu laat zha re thap gal tsiinbthap maa ne yakwaan zha maa kuu mndaba, asta yetsal maa lo zha? ");
INSERT INTO zaoNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ne leettsa mzal maa lo zha, kwathoz laz zha ne mxoob zha maa dits yen zha ne ndyaadno zha maa, ");
INSERT INTO zaoNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ne leettsa mzin zha liz zha, tsa mkaltaa zha re kuu nzaal leettsoo zha ne kon re zha kuu nzo gax liz zha, ne mbez zha lo re zhaʼa: “Naley bloo goo leettsoo goo kon na, tak mzala na mbak zhiil da kuu mndab”. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Per lee na ni lo goo, tabaaga naley nzo leettsoo re zha kuu nzo yibaa, leettsa lee thib zha kuu ndab falt, ntsee zha mod went kuu nak zha, ne tsowt raa zha kuu went ne nyelaaz zha Diox, nake thap gal tsiinbthap zha kuu ndak wen nak, kuu ndechet tsee mod went nak lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Noga mni Jesús tedib kwent nanzee lo re zha, ne nzhab Jesús: ―Os lee thib ngot nap tsii temi plat ne tab ngot thibe, ¿kwan ntsow goo xgab? ¿Chu keet ngot kandil ne loob ngot yuu wen wen, asta yetsale lo ngot? ");
INSERT INTO zaoNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ne leettsa mzale lo ngot, tsa mbez ngot re ta got ngot kuu nzaal leettsoo ngot ne lo re zha kuu nzo gax liz ngot, ne mbez ngot lo re zha: “Naley bloo goo leettsoo goo kon na, tak mzala na temi da kuu mtabʼn”. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ne leen ni lo goo, leeka tata naley nzo leettsoo re mandad chaan Diox kuu nzo yibaa, leettsa lee thib zha kuu ndab falt, nlaa zha re kuu went kuu mtsowt zha ne nyelaaz zha Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Noga nzhab Jesús tedib kwent nanzee, ne nzhab Jesús: ―Ngoo thib mbyi kuu mkeno chop xgann. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ne lee xgann mbyi kuu mas mndyeen, nzhab lo mbyi: “Pa, taa kuu ndoblon diinn na”. Tsa lee xut zha mtsow garol chaane lo rop xgann zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ne leettsa mriid lut tyemp lee xgann mbyi kuu mas mndyeena, mtho zha reta kuu mndaa xut zha lo zha, ne mroo zha nda zha tith. Ne tya mluux zha reta temi zha kuu ndano zha, lo re kuu went kuu yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ne leettsa ngwalo mluux zha reta temi zha, mla win yezlyuʼa, ne mzhaak zha win. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tsa ngwakwaan zha tsiin ke zha lo thib zha yeza, ne lee zha yeza mtaal zha tsa kenap zha nguch. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ne tak kwathoz nlann zha, ngwalaaz zha gawu zha re ton kuu nzhow nguch, per yent cho mndaay gawu zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","’Leettsa myeen zha kuu ngeriid zha, tsa mtsow zha xgab, ne nzhab zha: “¡Plalpaa re zha kuu nke tsiin liz xutʼn, nap zha kuu nzhow zha ne asta ndrozhoobee lo zha! ¡Ne lee na mer gath lo win nzhee!” ");
INSERT INTO zaoNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nal bretabʼn ne ndyan lo xutʼn, ne gapʼn lo xutʼn: “Pa, mndan falt lo Diox ne loʼa, ");
INSERT INTO zaoNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ndoblot raa na rolen xganna, sinke btsowʼn taxal thib mosa”. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","’Tsa ngoo zha net ne ndya zha liz xut zha. Ne leettsa tith raa ndyaad zha, lee xut zha mwii lee zha ndyaad, tsa mlat leettsoo xut zha mne zha. Ne mrozhonn xut zha nda lo zha ne mdeez xut zha zha, ne mdow xut zha chut kwat zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tsa nzhab zha lo xut zha: “Pa, mndan falt lo Diox ne loʼa, ndoblot raa na gakʼn xganna”. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Per lee xut zha mnabee lo re mose ne nzhab: “Deno goo lar kuu mas wen ne btegok gooy xgann na, ne bloo goo thib ani kwen yaa zha ne bkee goo labyid nii zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ne gwaxii goo thib la ngon kuu mas natsi, ne beth goo maa dowaa, tsa tsowaa ani, ");
INSERT INTO zaoNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","tak lee xgann na kuu ngutha, mre mroban, mndab zha per mre mzal zha.” Tsa mndelo re zha mtsow zha ani. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Ne lee xgann mbyi kuu nera ndo wan, ne or ndyaad zha ndetsin gax zha liz zha, mbin zha nzhool musk ne lee re men ngekani. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tsa mrez zha thib mos xut zha, ne mnaabdiz zha lo mos, naa kwan ngetsow xut zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tsa lee mos nzhab lo zha: “Lee wetsa kuu ndaʼa mre, ne lee xuta mnabee mbeth zha ngon kuu mas natsi, tak nagwe wetsa ne wen wetsa mzin wetsa”. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","’Per lee wets zha kuu byeʼa kwathoz mkezhyan, ne mzhyalt zha gataab zha leen yuu. Tsa lee xut zha mroo leen yuu ne ngwa nzhab lo zha, tsa tab zha leen yuu. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Per lee zha nzhab lo xute: “Tyen liin nda nkeen tsiin loʼa ne thibka nzhon na diiz loʼa, ne neeka thib mbak zhiil lut ter taaʼa lon, par tsowʼn ani kon re zha kuu nzaal leettsoon. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ne lee nal mzin xganna kuu legal mluux temiʼa lo re ngot kuu ntho kwerp lo re men, ne mbetha ngon kuu mas natsi.” ");
INSERT INTO zaoNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","’Tsa lee xut zha nzhab lo zha: “Xgann na, thibka ndoʼa lon, ne reta kuu napʼn nak chaana. ");
INSERT INTO zaoNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Per nal ndoblo tsowaa ani ne naley yoo leettsooʼaa, tak lee wetsa kuu ngutha mroban, mndab zha per nal mzala zha.” ");
INSERT INTO zaoNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Tsa lee Jesús nzhab lo re zha kuu ngeteed lo Jesús: ―Ngoo thib zha rik kuu mkeno thib mos kuu nabee re chaan zha. Ne lee tedib zha ngwa lo zha rika, ne nzhab lo rik: “Lee mosa ngeluux re chaana”. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tsa mrez rik mos kuu nke tsiin lo rik, ne nzhab rik lo mos: “Kwan re kuu nzhon na kwent chaana, ney lon. ¿Kwan ngetsowa kon re chaan na? Tak gagt raa gaka mos da.” ");
INSERT INTO zaoNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tsa mnda leettsoo mos ne nzhab mos: “¿Kwan tsowʼn nal, tak lee patron da taat raa tsiin keen? Gagt keen tsiin, ne nthoyʼn naabʼn gon. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ah, neʼa na kwan tsowʼn, tsa taa re men kuu wun, leettsa napt raa na tsiin keen.” ");
INSERT INTO zaoNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tsa mrez mos thibga thibga re zha kuu ndab lo patron mos, ne nzhab mos lo zha kuu ner: “¿Plal ndaba lo patron da?” ");
INSERT INTO zaoNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tsa lee zhaʼa mkab ne nzhab: “Thib gayoo barril aseyt ndabʼn”. Tsa lee mos nzhab lo zha: “Lee xkeetsa nzhee, bluuzhe ne btexkwaa tedibe ne bkee loy leey nak garol gayoo barril aseyt”. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tsa mnaabdiz mos lo tedib zha ne nzhab mos lo zha: “¿Plal ndaba?” Lee zhaʼa mkab ne nzhab: “Thib gayoo sak nzob xtil ndabʼn”. Tsa lee mos nzhab lo zha: “Lee xkeetsa nzhee, bluuzhe ne btexkwaa tedibe, ne bkee loy leey nak thap gal sak nzob xtil”. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ne leettsa mne patron mos kona, tsa nzhab patron: “Kwathoz nalatts zha baa, tsa naa xomod rid zha bluz”. Tak lee re men yezlyu ree mas nalatts yek zha lo re kuu yezlyu ree nake re zha kuu nzi lo xni. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Tsa lee Jesús nzhab: ―Per lee kuu ganin lo goo nak, blortsin goo re kuu nap goo lo yezlyu ree, tsa tsow goo gan amig goo. Tsa leettsa lux re kuu yezlyu ree, napa goo cho kayaa goo leen thib yuu kuu thitanax luxt. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Loka zha kuu wen nke tsiin tegal kon lut kwaa, tataka wen ke zha tsiin kon naroob kwaa, ne lee zha kuu nket tsiin wen kon lut kwaa, tataka went ke zha tsiin kon naroob kwaa. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ne os lee goo went mke goo tsiin kon temi yezlyu ree, ¿cho taa re kuu wlipaa lo goo tsa? ");
INSERT INTO zaoNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ne os lee goo mtsowt goo nali lo re kuu nagt chaan goo, ¿cho taa kuu ndoblo kayaa goo lo goo tsa? ");
INSERT INTO zaoNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Neeka thib mos gagt ke tsiin lo chop patron, tak teyii mos ne mos thib zha ne kelaaz mos tedib zha, lee lo thib zha wen ke mos tsiin ne laa mos tedib zha. Gagt teke goo xnet Diox ne teke goo dits re kuu yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Per lee re fariseo mbin re kona, ne mzhizno zha Jesús, tak kwathoz ndablaaz zha temi. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tsa nzhab Jesús lo re zha: ―Leeka goo mbez goo lo re men lee goo wen nak, per lee Diox nlebee re xgab chaan goo; tak lee re kuu ndak re men nataak, nkap leettsoo Diox ne Diox re kona. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Asta leettsa mzin Juan kuu mtsowleyy re men, lee ley ne re kuu nzhab re profet mlortsin. Desde wiza asta nal ngetaa zha kwent Diiz Chul naa xomod nabee Diox leettsoo re men, ne reta zha nlaaz yelaaze. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mas nagant lux yezlyu ne yibaa, nake gagt lut kuu nke lo ley chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Os lee thib mbyi laa tsaal, ne kaa mbyi tedib ngot, ndaa mbyi falt lo Diox, ne loka mbyi kuu tseya kon ngot kuu mlaa zha, noga mbyiʼa ndaa falt lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesús mndaa tedib kwent nanzee, ne nzhab Jesús: ―Ngoo thib zha rik kuu nzhok lar wen, ne ganda wiz ntsow ani ne pur kuu wen nzhow rik. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ne noga ngoo thib mbyi prob kuu le Las, kuu dita mzaal yaaz, ne nyatob Las gax roo pwert zha rika, naab Las gon. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lee mbyiʼa nlaaz tse leettsoo kon re kuu ndrethin roo mes rik. Ne lee re mbak nteeloz lo re yaaz kuu ndo mbyiʼa. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Per thib wiz lee Las nguth, ne lee re mandad chaan Diox mndeno Las ta nzo Abraham. Ne leettsa mzin wiz lee rik nguth ne mkaats zha rik. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","’Ne leettsa kwathoz ndakti rik gabil, tsa mlap lo rik ne mwii rik lee Abraham ndo tith, ne lee Las ndo lo Abraham. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tsa dib gan rik nzhab rik: “Xutʼn Abraham, blat leettsooʼa neʼa na. Btaal Las tsa tenit Las yek kwen yaa Las, ne tee Las kwen Las lo lozʼn, tsa rozhyal lozʼn, tak kwathoz ndaktin lo bel nzhee.” ");
INSERT INTO zaoNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Per lee Abraham nzhab lo rik: “Xgann na, btelaaz mkenoʼa lu reta kuu mndablaaza lo yezlyu, ne lee Las neeka thib kuu mkenot Las lo yezlyu, per nal lee Las naley nzo leettsoo ndo nzhee, ne lee lu ndakti baa. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ne noga, nzhee nzo thib ble thoz kuu ntow lo goo ne lo nee, tsa neeka thib zha kuu ndo nzhee gagt rid baa tegal nlaaz zha, ne neeka thib zha kuu ndo baa, gagt yaad nzhee tegal nlaaz zha.” ");
INSERT INTO zaoNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","’Tsa lee zha rik mkab ne nzhab: “Xutʼn Abraham, naabʼn loʼa, tsa taala Las ya liz xutʼn, ");
INSERT INTO zaoNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","tak napʼn gaay wetsʼn, ne nlazʼn ni Las lo re zha, tsa yaadt zha nzhee, tak kwathoz nati nzhee”. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Per lee Abraham nzhab lo rik: “Napa zha re kuu mkee Moisés ne re kuu mkee re profet; ndoblo gon zha diiz re kuu nzhab re zhaʼa”. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tsa lee rik mkab ne nzhab: “Xutʼn Abraham, gont zha diize, per os lee thib zha kuu ngutha ya lo re zha, tetsee zha mod went kuu nak zha ne tsowt raa zha kuu went ne teyelaaz zha Diox”. ");
INSERT INTO zaoNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Per lee Abraham nzhab lo rik: “Os lee zha nlaazt zha gon zha diiz, re kuu nzhab Moisés ne re kuu nzhab re profet kuu ngoo ndala, gont zha diize, tegal thib re zha kuu ngutha roban ne yataa kwent lo zha”. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús nzhab lo re zha kuu ngeteed lo Jesús: ―Wli too kuu tsow par tsow re zha kuu nyelaaz Diox kuu went: ¡Per aka nalatt rid re zha kuu tsow par la re zha kuu nyelaaz Diox lo kuu went! ");
INSERT INTO zaoNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mas wen gakegaa zha thib ke molin yen zha, ne kobi zha zha leen nitdoo, nake tsow zha par tsow thib re zha kuu nyelaaz Diox kuu went. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Kenap goo goo! Os lee wets goo taa falt lo goo, ndoblo kox zha lo goo, os lee zha laa zha re mod went kuu nak zha, tee bnithlaaz goo kuu mtsow zha lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ne tegal os gaz welt ndaa zha falt lo goo thib wiz, ne os tataka gaz welt yaad zha thib wiz ne zha lo goo: “Tsowt raa nay”, ndoblo nithlaaz goo re kuu mtsow zha lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tsa lee re zha kuu ngeteed lo Jesús nzhab lo Jesús: ―Btsow tsa masraa yelaaz nee lu. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tsa lee Zha Nabee mkab lo re zha, ne nzhab: ―Os lee goo nyelaaz goo na, mase lut taxal na thib mbiz mostaz, tak gab goo lo ya ree: “Beche nzhee ne to leen nitdoo”, ne lee ya ton diiz lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Os lee thib goo nkeno thib mos kuu ndyaad ngwa gonn gon gonn o ndyaad ngwatewoy maa wan, chu mbez goo lo mos: “Briid tob tsa wuʼa”. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ntsowt gooy, sinke leel mbez goo lo mos: “Btexkwaa kuu wu rtseen, ne list toʼa tsa koʼa kwaa leen yann, or wun ne gun. Tsaraa wuʼa ne guʼa.” ");
INSERT INTO zaoNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Chu ndaa patron texkix lo mos, tak mtsow mos kuu mnabee patron lo mos? Wlipaa ndaat zha texkix lo mos. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tataka goo, leettsa yelo tsow goo kuu nabee Diox tsow goo, tsa gab goo: “Leeʼaa nak mos kuu nataagt, tak beeta mtsowaa kuu ndobloʼaa tsowaa”. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Leettsa nda Jesús yez Jerusalén, tsa mriid Jesús yezlyu chaan zha Samaria ne yezlyu chaan zha Galilea. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ne leettsa mzin Jesús thib ranch, tsa mzin tsii mbyi kuu ndak yiz kuu ndezhoz cho lo Jesús. Ne tithxa mrin re zha lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Tsa mrez re zha lo Jesús, ne nzhab zha: ―¡Maestr! ¡Jesús! ¡Blat leettsooʼa neʼa nee! ");
INSERT INTO zaoNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Leettsa mwii Jesús re zha; tsa nzhab Jesús lo re zha: ―Gwa goo, gwaloo goo goo lo ngwleyy. Ne leettsa ndo re zha net nda zha, ora mgwe re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ne lee thib re zhaʼa myeen zha lee zha mgwe, tsa mretab zha ne mbil zha lo Diox kon dib ndroo leettsoo zha, ");
INSERT INTO zaoNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","tsa mtobxub zha ne mkiits zha yek zha lo yu, ne mndaa zha texkix lo Jesús. Ne zha Samaria nak zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tsa lee Jesús nzhab lo zhaʼa: ―¿Chu nagt tsii goo mgwe? ¿Ma tedib yee zha? ");
INSERT INTO zaoNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Beeta zha tith ree mretab ne mndaa texkix lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tsa nzhab Jesús lo mbyiʼa: ―Gwateli ne tyee. Tak ngwalaaza Diox kona mgweʼa. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tsa lee re fariseo mnaabdiz lo Jesús ne nzhab: ―¿Pol tsin yalnabee chaan Diox? Tsa mkab Jesús, ne nzhab Jesús: ―Leettsa yaad yalnabee chaan Diox, loote lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Neeka yent cho gab: “¡Leey ndo nzhee! O ¡Leey ndo baa!” Tak lee yalnabee chaan Diox mzin gaxa lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tsa nzhab Jesús lo re zha kuu ngeteed lo Jesús: ―Tetsin wiz kuu tak re goo, malaay wii goo wiz kuu nabee na, Kuu Mzin Ngok Men lo yezlyu ree, per wiit gooy. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tyen zha gab: “Lee zha ndo nzhee, lee zha ndo baa”, per neeka yat goo ne neeka teket goo dits zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tak taxal nla xni bel bti dita lo yezlyu, tata gak wiz kuu lee na, Kuu Mzin Ngok Men bre yaad. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Per ner ndoblo riidʼn kwathoz yalti, ne lee re men kuu nzi wiz ree kayaat zha na. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Leeka taxal ngok re wiz kuu mban Noé, tataka gak wiz kuu bretab na, Kuu Mzin Ngok Men. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ne re wiz kuu mban Noé, leettsa terka la yi luux re kwaa, lee re men nzi nzhow ne nzhuu, ntseya zha ne ntetseya zha re zha, asta wiz kuu lee Noé mndaab leen bark, ne lee yi mndelo mla mluux re men. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ne leeka tata ngok re wiz kuu mban Lot, lee re men nzi nzhow ne nzhuu, ntho zha ne ndi zha, nzhann zha ne nta zha liz zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Per lee wiz kuu lee Lot mroo yez Sodoma, lee ki ne azufre mroo lobee, ne taxal yi mlay yeza, ne mluuzhe reta men yez Sodoma. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ne tataka gak wiz kuu leettsa lee na, Kuu Mzin Ngok Men bretab. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Lee wiza loka zha kuu ndob yek yuu, lat zha koo zha re chaan zha kuu nzotsow leen liz zha, ne lee re zha kuu ndo wan bret zha liz zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","¡Btelaaz goo naa kwan ngok kon tsaal Lot! ");
INSERT INTO zaoNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","’Per os lee thib zha gath zha tak nyelaaz zha na, ne nlaaz zha gon zha diiz xkizʼn, tetsow zhaʼa gan yalnaban kuu thitanax, per lee zha kuu nzeb gath zha tak nyelaaz zha na, tsowt zhaʼa gan yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ne wlipaa na nin lo goo, lee yaala lee chop zha nax lo thibka luun, thib zha teno zha lee tedib zha yaanka. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Lee chop ngot ngetoo nil, thib ngot teno zha lee tedib ngot yaanka. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Lee chop mbyi kuu nke tsiin wan; thib zha teno zha lee tedib zha yaanka. ");
INSERT INTO zaoNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tsa mnaabdiz zha lo Jesús, ne nzhab zha: ―¿Pa gak re koree, Zha Nabee? Lee Jesús mkab, ne nzhab: ―Ta nax re maa nguth, tya nkaltaa re ngol. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Noga mndaa Jesús tedib kwent nanzee lo re zha, tsa ne re zha thibka ndoblo tediz zha lo Diox, ne laat zha tsow zhay. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tsa nzhab Jesús: ―Thib welt thib yez ngoo thib jwez kuu nzebt ne Diox ne neeka ndat leettsoo zha ne zha re men. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ne leeka yeza ngoo thib byud kuu ngyo kon tedib zha, ne thibka nya ngot lo jwez ne mbez ngot lo jwez: “¡Btsow ayudʼn ne bloo zha kuu nayii nen tsib!” ");
INSERT INTO zaoNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ne ndaʼa thiban welt nlaazt jwez tsow jwez kas ngot, per mzin thib wiz mtsow jwez xgab, ne nzhab jwez: “Neeka nzebtʼn nen Diox ne neeka ndat leettsoon nen re men, ");
INSERT INTO zaoNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","per tak lee byud ree thibka ngegozhon, kona tsowʼn ayud zha, tsa yaadt raa zha, tak cha yeche leettsoon nen zha”. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tsa lee Zha Nabee nzhab: ―Bkenza goo kuu nzhab jwez kuu went nak. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kona nin, wlipaa tetsow Diox ayud re zha kuu mli Diox ne ton Diox xkiiz re zha kuu tse ne yaal naabe lo Diox, ne nxek leettsoo Diox ne Diox zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Wlipaa na nin lo goo, wlipaa tetsow Diox ayud goo leettsa naab gooy lo Diox. Per leettsa yal na, Kuu Mzin Ngok Men lo yezlyu ree, ¿nabet naa chu tetsal raa na zha kuu nyelaazʼn lo yezlyu ree? ");
INSERT INTO zaoNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús mndaa tedib kwent nanzee lo tedib net re zha kuu ndak wen nak, ne ndak zha lee tedib net re men thitanax went nak. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Tsa nzhab Jesús: ―Thib welt lee chop mbyi ndaa gwodoo nda tediz lo Diox. Thib zha nak fariseo, lee tedib zha nak zha kuu ntsow kobral temi chaan yezlyu kuu nzhax lo zha Roma. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tsa lee fariseo mndeli, ne tenzhee mndelo zha nzhab zha lo Diox: “Diox, texkizha, tak nagtʼn taxal tedib net re men. Nagtʼn wann, zha wen nakʼn, neeka nagtʼn thib zha kuu nzhak rop kon tedib ngot, ne neeka nagtʼn taxal zha ree, zha kuu ntsow kobral temi chaan yezlyu kuu nzhax lo zha Roma. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ne chop welt ntsowʼn ayun thib sman, ne ndan loʼa tsii part lo re kuu ntsowʼn gan.” ");
INSERT INTO zaoNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Per lee zha kuu ntsow kobral temi chaan yezlyu ndo tithxa, ne neeka mlapt zha lo zha lobee, sinke nkaan yaa zha pech zha ne mbez zha: “Diox, blat leettsooʼa neʼa na, tak thib zha kuu ntsow kuu went nakʼn”. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Lee na ni lo goo, mtuyya Diox falt zha kuu ntsow kobral temi chaan yezlyu, leettsa mre zha liz zha, per lee fariseo mtuyyt Diox re falt zha. Tak lee zha kuu ntsow nataak leeka lee lo Diox, nataagt zhaʼa, per lee zha kuu ntsow nataagt leeka lee lo Diox, tetsin wiz lee zhaʼa gak zha nataak. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tsa lee re men ngwano re ndyeen bzhizh lo Jesús, tsa xoob Jesús yaa Jesús yek re ndyeen. Per leettsa mwii re zha kuu ngeteed lo Jesús kona, tsa mkox re zha kuu ngwano re ndyeen lo re zha kuu ngeteed lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tsa mrez Jesús re zha kuu ngeteed lo Jesús, ne nzhab Jesús lo re zha: ―Laa goo yaad re ndyeen lon, ne towt goo lo ndyeen. Tak Diox nabee leettsoo re zha kuu nak taxal re ndyeen bzhizh ree. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Wlipaa na ngenin lo goo, loka zha kuu tyalt nabee Diox leettsoo, taxal thib re ndyeen ree, gagt tab zha ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Thib zha kuu nataak mnaabdiz lo Jesús, ne nzhab: ―Maestr wen, ¿kwan ndoblo tsowʼn, tsa tsowʼn gan yalnaban kuu thitanax? ");
INSERT INTO zaoNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús mkab ne nzhab: ―¿Chebee neʼa wen nakʼn? Neeka thib men wen yent, beeta Diox wen nak. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Neʼa lu re kuu mtaan Diox tsowa: “Ndoblot gak ropa kon thib ngot kuu nagt tsaala, kuthta tabena, lowannta, tedizta kuu wlit, ne bke leettsooʼaa xutaa ne xnaaʼa”. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Lee zhaʼa nzhab: ―Reta koree ngetsowʼn desde leettsa mndyeen na. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Or mbin Jesús kona, tsa nzhab Jesús lo zha: ―Tedibka kuu nzhak falt tsowa. Tyee, ne btho reta kuu napa ne btaa temi lo re zha prob, tsa kenoʼa naroob kwaa leen yibaa, tsaraa yaada ne tekeʼa ditsʼn. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Per leettsa mbin zha rika kona, kwathoz nabil ngoo leettsoo zha, tak kwathoz rik zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ne mwii Jesús nabil ngoo leettsoo zha, tsa nzhab Jesús: ―¡Aka nagan laa thib zha rik nabee Diox leettsoo zha! ");
INSERT INTO zaoNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ne mas nagant rid thib kamey yeer kuu le ngutlo abuj, nake tsow thib zha rik gan tab yibaa ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ne lee re zha kuu mbin kona nzhab: ―¿Os leey tabaay cho tsow gan ndya yibaa tsa? ");
INSERT INTO zaoNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tsa lee Jesús nzhab lo re zha: ―Re kuu nagan lo re men yezlyu ree, lo Diox nagante. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tsa lee Pey nzhab: ―Lee re nee, mlaa nee reta kuu nap nee, ne ndeke nee ditsa. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Tsa lee Jesús mkab, ne nzhab lo re zha: ―Wlipaa na ngenin lo goo, loka zha kuu laa liz, tsaal, wets, xut ne xnaa, ne zhiinn kwent chaan ta nabee Diox, ");
INSERT INTO zaoNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","zhaʼa mas naroobe kayaa lo yezlyu ree, ne tetsin wiz kayaa zha yalnaban kuu thitanax yibaa. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Tsa mrez Jesús re tsiibchop zha kuu ngeteed lo Jesús, ne nzhab Jesús lo re zha: ―Bin goo, nal nda reʼaa yez Jerusalén, ta ndoblo gak reta kuu mkee re profet kuu ngoo ndala, kwent chaan da, Kuu Mzin Ngok Men. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Taa zha na lo re zha kuu nagt zha Israel, tsa zhizno zha na, tsalzhoo zha na ne tsuk zha lon. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ne leettsa yelo kin zha na, tsaraa kuth zha na, per leettsa tsaal tson wiz lee na roban. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Per lee re zha kuu ngeteed lo Jesús, myent zha re kuu nzhab Jesús, ne neeka net zha na kwan kuu nzhab Jesús, tak lee Diox mkaats re kona lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ne leettsa ndetsin gaxa Jesús yez Jericó, tsa mwii Jesús lee thib mbyi syeg ndob roo net ngenaab gon. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Or mbin syeg kwathoz men nderid, tsa mnaabdiz syeg ne nzhab syeg: ―¿Kwan ndiy nzhak? ");
INSERT INTO zaoNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tsa nzhab re men lo syeg: ―Jesús zha Nazaret nderid nzhee. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tsa lee syeg dib gan mrez, ne nzhab: ―¡Jesús xgann David, blat leettsooʼa neʼa na! ");
INSERT INTO zaoNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tsa lee syeg mkox lo re zha kuu ndener, ne nzhab zha: ―¡Btow rooʼa! Per lee syeg masraa mrez ne nzhab: ―¡Jesús xgann David, blat leettsooʼa neʼa na! ");
INSERT INTO zaoNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tsa lee Jesús mlet, ne mnabee Jesús ngwaxii zha syeg. Ne leettsa mzin syeg lo Jesús. Tsa mnaabdiz Jesús lo syeg: ");
INSERT INTO zaoNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Kwan nlaaza tsowʼn loʼa? Tsa lee syeg mkab ne nzhab: ―Zha Nabee, nlazʼn yeni ngutlon. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Lee Jesús nzhab lo zha: ―Tak yeni ngutloʼa, tak ngwalaaza na. ");
INSERT INTO zaoNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ne oraaka lee lo zha mzhaal, ne mndeke zha dits Jesús ne mbil zha lo Diox. Ne reta zha kuu mwii kuu ngok, noga re zhaʼa mbil lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tsa mndaab Jesús yez Jericó ne mriid Jesús leen yeza. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ne tya nzo thib mbyi rik kuu le Zaqueo, ne lee zha nak zha kuu nabee lo re zha kuu ntsow kobral temi chaan yezlyu kuu nzhax lo zha Roma. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ne nlaaz zha wii zha Jesús, per gagt wii zha Jesús, tak kwathoz men nzi, ne tak kwathoz lut Zaqueo. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tsa lijer mndener zha ne mkendab zha lo thib ya kuu le sicómoro, par wii zha Jesús leettsa rid Jesús tya. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Leettsa mzin Jesús tya, ne mwii Jesús lo ya, tsa nzhab Jesús lo zha: ―Zaqueo, lijer bla, tak liza betʼn naltseree. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tsa lijer mla zha ne kwathoz naley ngoo leettsoo zha, mbin zha lee Jesús kwet liz zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ne or mbin re men kona, mndelo zha mbez zha lo re altaa zha, ne nzhab zha; lee Jesús nda kwet liz thib zha kuu kwathoz ndab falt. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tsa lee Zaqueo mndeli ne nzhab lo Jesús: ―Zha Nabee, wii, garol re kuu napʼn tan lo re zha prob; ne os leen mlowann na chaan thib zha, thap lal kuu mkibʼn lo zha tseren lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tsa nzhab Jesús lo Zaqueo: ―Naltseree lee re zha kuu nzo yuu ree mkayaa yalnaban kuu thitanax, tak no zha ree nak zha raz Abraham. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tak lee na, Kuu Mzin Ngok Men, ndyaad kwaan re zha kuu mndab, tsa tan yalnaban lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ne leettsa ngeyon re zha re kuu ngeni Jesús, tsa nzhab Jesús tedib kwent nanzee lo re zha, tak gaxa Jerusalén nzi re zha kon Jesús, ne mtsow re zha xgab, mera nabee Diox lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tsa lee Jesús nzhab lo re zha: ―Ngoo thib zha rik kuu kwathoz nataak, ne mroo zha nda zha thib ta kwathoz tith, ne tya gak zha rey kuu nabee, ne tsaraa bretab zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ne leettsa ter roo zha, tsa mrez zha tsii mos zha, ne mndaa zha thibga temi kuu mas nataak lo kadta thib mos, ne nzhab zha lo re mos: “Bke goo tsiin kon temi ree, asta leettsa bretabʼn”. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Per lee re tawlaz zha nayii ne zha, tsa mtaal re tawlaz zha thib net zha ngwalo diiz lo rey ne nzhab: “Nlaazt nee gak zha ree rey lo nee”. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’Per leettsa naka zha rey, tsa mre zha laz zha. Tsa mrez zha re mos zha kuu mndaa zha temi lo, tak nlaaz zha ne zha naa xa mke re mos tsiin kon temiʼa. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tsa mzin mos kuu ner ne nzhab mos: “Zha Nabee, lee temi kuu mndaaʼa lon, mtsowe gan tedib tsiiy”. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Tsa lee rey nzhab lo mos: “Mos da, kwathoz wen mkeʼa tsiin. Wen mtsowa lo lut kwaa mndan loʼa, kona lee nal tan tsii yez loʼa, tsa nabee luy.” ");
INSERT INTO zaoNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tsa mzin tedib mos ne nzhab lo rey: “Zha Nabee, lee temiʼa kuu mndaaʼa lon mtsowe gan tedib gaaye”. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Tsa lee rey nzhab: “Nal tan thib gaay yez loʼa tsa nabee luy”. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tsa mzin myon mos ne nzhab: “Zha Nabee, lee temiʼa kuu mndaaʼa lon nzhee. Mkee nay lo thib panyit ne mkaats nay, ");
INSERT INTO zaoNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","tak nzebʼn nen lu, tak nen lee lu nak thib zha kuu kwathoz nakap, ndena kuu mtaanta ne nthopa yalgonn ta ngonnta.” ");
INSERT INTO zaoNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tsa lee rey nzhab lo mos: “Kon leeka re diiz kuu mroo rooʼa, naabʼn kwent loʼa; lu nak thib zha nakap. Neʼa lee na nden na kuu mtaantʼn ne nthopʼn yalgonn ta mlootʼn bin. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Chebee mlota temi da bank? Tsa leettsa gabren, gataaʼa temi da kuu mndan loʼa, ne gataaʼa zhiinne kuu mtsowe gan lon.” ");
INSERT INTO zaoNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tsa nzhab rey lo re zha kuu nzi lo rey: “Bkib goo temi lo mos ree, ne btaa gooy lo mos kuu nap tsiiy”. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tsa lee re zha nzhab lo rey: “Zha Nabee napa zha baa tsii temi”. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Per lee rey mkab ne nzhab: “Lee na ni lo goo: Lee zha kuu nap naroobe tekayaa zha masraay, per lee zha kuu yent kwan nap, asta lut kuu nap zha yiib lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ne noga nzhab rey: Deno goo re zha kuu nlaazt gakʼn rey lo nzhee, ne beth goo zha nzhee lon.” ");
INSERT INTO zaoNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Leettsa ngwalo nzhab Jesús kona, ndaka Jesús yez Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Leettsa ndetsin gaxa Jesús yez Betfagé ne yez Betania, gaxta yii kuu le Olib, tsa mtaal Jesús chop zha kuu ngeteed lo Jesús, ");
INSERT INTO zaoNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ne nzhab Jesús lo rop zha: ―Gwa goo yez kuu nzi gaxta nzhee, tya yetsal goo thib burr kuu ndekedoo, thib maa kuu terka yo xab. Xak goo maa ne yaadno goo maa nzhee. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ne os cho zha naabdiz lo goo ne: “¿Chebee ngexak goo burr?” Gab goo lo zha: “Lee Zha Nabee ndeche maa”. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tsa lee rop zha kuu mtaal Jesús nda, ne mzal burr lo zha taxal nzhab Jesús lo rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ne leettsa ngexak zha burr, lee bzhaan burr, mnaabdiz lo rop zha ne nzhab: ―¿Chebee ngexak goo burr da? ");
INSERT INTO zaoNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tsa lee zha mkab ne nzhab: ―Lee Zha Nabee ndeche maa. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tsa ngwano zha maa lo Jesús. Ne mxoob zha xab zha dits maa ne mke Jesús dits maa. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ne taxal nderid Jesús lee re men ngix xab net. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ne or ndyaadla re zha ndetsin zha gax yii kuu le Olib, tsa lee reta men kuu ndeke dits Jesús mndelo zha mbil zha dibgan zha ne mndaa zha texkix lo Diox, por re kuu thoz kuu mwii zha mtsow Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ne mbez re zha: ―¡Kwathoz wen nak zha kuu ndyaad kon le Zha Nabee! ¡Wen kwin re zha yibaa ne golaa lo Diox kuu ndob yibaa! ");
INSERT INTO zaoNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tsa lee chop tson re fariseo kuu nzi xid re mena, nzhab lo Jesús: ―Maestr, gok nayii lo re zha kuu ndeke ditsa. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Per lee Jesús nzhab lo re zha: ―Wlipaa na nin lo goo, os lee re zha ree tow roo, lee re ke kwez guth. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Leettsa ndetsin gax Jesús yez Jerusalén, or mwii Jesús yez, ora mbinn Jesús, ");
INSERT INTO zaoNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ne nzhab Jesús: ―¡Os lee re goo zha yez Jerusalén gane goo, lee wiz naltseree tak wen kwin goo, per tak nzogaats koree lo goo, kona nloote lo goo! ");
INSERT INTO zaoNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tak too wiz kuu lee re zha kuu nayii ne goo telo yo kon goo, ne tow zha re ladta lo goo, taxal thib btsin ke. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Wlipaa teluux zha re zhiinnta goo, ne neeka thib ke yaant dits tedib ke yez ree, tak mlebeet goo Diox wiz kuu myaadtwii Diox lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tsa mndaab Jesús lee roo gwodoo naro, ne mndelo Jesús mtezhonn re zha kuu ntho ne ndi tya. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Tsa nzhab Jesús lo re zha: ―Nkeʼa lo xkeets Diox ta mbez: “Lee lizʼn nak yuu ta ndediz re men lon” Is. 56:7; Jer. 7:11; ne lee re goo ntsowe taxal liz wann. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Gandata wiz nloo Jesús lo re men lee roo gwodoo, per lee re ngwleyy kuu nabee lo re ngwleyy, ne re maestr kuu nloo xkiiz Diox lo re men, ne re zha kuu nabee yez, nkwaan zha naa xomod kuth zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Per mzalt zha mod gatsow zhay, tak kwathoz men nzi nzhon re kuu nloo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Thib wiz leettsa lee Jesús ngeloo lo re men lee roo gwodoo, ne mndaa Jesús kwent Diiz Chul lo re men, tsa ngwa re ngwleyy kuu nabee lo re ngwleyy lo Jesús, noga re maestr chaan ley ne re zha gol. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Tsa nzhab zha lo Jesús: ―¿Cho mndaa diiz ntsowa re koree? Ne ¿cho mndaa yalnabee loʼa? ");
INSERT INTO zaoNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tsa lee Jesús nzhab lo re zha: ―Noga na naabdiz thib kwaa lo goo, kab goo lon. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Cho mtaal Juan tsowleyy Juan re men? ¿Chu Diox mtaal Juan o mene? ");
INSERT INTO zaoNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ne lee re zha mndelo zha mbez zha lo re altaa zha: ―Os leeʼaa gabaa lo zha: “Diox mtaal Juan”, tsa ne zha loʼaa: “¿Chebee mbint goo diiz lo zha?” ");
INSERT INTO zaoNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Per os leeʼaa gabaa lo zha: “Re men mtaal zha”, tsa kuth re menaa kon ke, tak ne re men lee Juan nak profet chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tsa lee re zha nzhab: ―Net nee cho mtaal Juan. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tsa lee Jesús nzhab lo re zha: ―Neeka na nitʼn naa cho mndaa yalnabee lon ntsowʼn re koree. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tsa lee Jesús nzhab tedib kwent nanzee lo re men, ne nzhab Jesús: ―Thib welt ngoo thib zha kuu ngonn luts ub dita lo yu zha, ne mndaa zha yu zha kompani lo tedib net zha tsa tenaa zhay, ne ndya zha ngoo zha tith naroob tyemp. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ne leettsa mzin tyemp kuu thop zha yalgonn, tsa mtaal zha thib mos zha, par yanaab kuu ndoblo zha diinn zha. Per lee re zha kuu nke tsiin lo yu zha, mdinke re zhaʼa mos zha, ne mtenet zha mos tabaata. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tsa lee zha kuu nak chaan yu mtaal zha tedib mos zha, ne lee re zha kuu nke tsiin lo yu zha, mdinke zha mos ne kwathoz mteti zha mos ne mtenet zha mos tabaata. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tsa lee zha kuu nak chaan yu mre mtaal tedib mos, per lee re zha kuu nzhann lo yu zha, mloo zha grid mos, ne mlobi zha mos ta nzhannt zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Tsa lee zha kuu nak chaan yu nzhab: “¿Kwan tsowʼn? Nal taalʼn thibka xgann na kuu napʼn; ne leettsa wii zha xgann na, ton re zha diiz lo xgann na.” ");
INSERT INTO zaoNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Per leettsa mwii re zha kuu nzhann lo yu lee xgann zha kuu nak chaan yuʼa ndyaad, tsa nzhab zha lo altaa zha: “Zha ree nak kuu kayaa dita chaan xute, leettsa lee xut zha gath. Nda kutha zha, tsa lee yu ree gak chaanaa”. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tsa mloo re zha zha laats ta ndab luts ub ne mbeth zha zha. Tsa mnabdiz Jesús ne nzhab Jesús: ―¿Kwan ntsow goo xgab? ¿Kwan tsow zha kuu nak chaan yu lo re zha kuu mke tsiin lo yu zha? ");
INSERT INTO zaoNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yaad zha ne kuth zha re zha kuu nzhann lo yu zha, ne taa zha yu zha lo tedib net zha. Leettsa mbin re men kona, tsa nzhab re zha: ―¡Net Diox kona! ");
INSERT INTO zaoNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Tsa lee Jesús mwii lo re zha, ne nzhab Jesús: ―¿Xomod nak kuu nzhab lo xkeets Diox? Ta nzhab: Lee ke kuu mlobi re zha kuu nta yuu, lee nal leey ngok ke kuu mas wen kuu mtob zha skin yuu. Sal. 118:22 ");
INSERT INTO zaoNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ne reta zha kuu ral ke ree nii tats zha, per os lee ke ree la dits thib zha dita tsowe zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tsa lee re ngwleyy kuu nabee lo re ngwleyy ne re maestr kuu nloo xkiiz Diox, ngwalaaz zha gaten zha Jesús, tak myeen re zha lee kwent nanzee kuu nzhab Jesús, nloo naa xomod nak re zha. Per nzeb zha ne zha re men, kona mlaa zha Jesús ne ndya zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tsa lee re zha kuu nayii ne Jesús thibka nkwaan re zha mod ten zha Jesús. Tsa mtaal zha chop tson zha kuu ntsow taxal zha kuu wlipaa ngeteed lo Jesús, beeta par yegaa Jesús, os lee Jesús ni thib kuu ndoblote, tsa tak taa zha Jesús lo gobyern. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tsa nzhab re zhaʼa lo Jesús: ―Maestr, neʼa nee lee re kuu ndediza ne re kuu nlooʼa nak kuu wli, ne lalka nzhak leettsooʼa neʼa reta men, ne nali nlooʼa xnet Diox lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Chu ndoblo kix nee temi o ndoblot kix nee temi lo César? ");
INSERT INTO zaoNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ne lee Jesús neʼa lee re zha ngekedi, tsa nzhab Jesús lo re zha: ");
INSERT INTO zaoNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―Bloo goo thib temi lon. ¿Cho yek nke loy? ¿Ne cho le nke loy? Tsa lee re zha mkab, ne nzhab: ―Chaan César, zha kuu nabee Roma nke loy. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tsa lee Jesús nzhab lo re zha: ―Mbay, btaa goo chaan César lo César, ne btaa goo chaan Diox lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ne mzalt zha neeka thib kuu went lo re kuu nloo Jesús lo re men. Ne leettsa mbin re zha kuu mkab Jesús, kwathoz mzegey leettsoo zha ne zheta mtow roo zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tsa lee chop tson zha saduceo re zha kuu nyelaazt lee re zha nguth roban, ngwa mnaabdiz lo Jesús, ne nzhab: ");
INSERT INTO zaoNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maestr, lee Moisés mkee lo xkeets Diox nzhab: “Os lee thib zha gath, ne lee tsaal zha yaan ne ngopt tsaal zha neeka thib zhiinn zha, tsa lee wets zha ndoblo tseya kon byuda, tsa keno wets zha zhiinn zha, ne lee zhiinn wets zha yaan taxal zhiinn zha ngutha”. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Thib welt ngoo gaz re wets zha. Lee zha kuu ner mtseya, ne nguth. Ne mkenot zha neeka thib zhiinn zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tsa lee tedib wets zha kuu ndeke dits zha, mtseya kon byuda, ne noga zhaʼa nguth, ne neeka mkenot zha zhiinn zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ne tataka ngok kon wets zha kuu myon. Ne re gazta wets zha mtseya kon byuda ne neeka thib zha mkenot zhiinn. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ne bluz noga ngot nguth. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Os lee re men roban, ¿cho thib re zhaʼa gak tsaal ngota, tak kon re gazta wets zha mtseya ngot? ");
INSERT INTO zaoNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tsa nzhab Jesús lo re zha: ―Lee re men yezlyu ree ntseya zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Per lee re zha kuu ndoblo ndya yibaa ne roban xid zha nguth, neeka tseyat zha ne neeka taat raa zha zhiinn zha tseya. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ne gatht raa zha, tak mroban zha tsa gak zha zhiinn Diox, ne gak zha taxal re mandad chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ne asta Moisés mloo lee re men roban, leettsa mndaa Moisés kwent chaan ya yits kuu ngeyeek, or mni Zha Nabee lo Moisés, ne nzhab zha: “Na nak Diox Abraham, Diox Isaac ne Diox Kob”. Ex. 3:6 ");
INSERT INTO zaoNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","¡Ne lee Diox nagt Diox Diox re zha nguth, lee Diox nak Diox lo re men kuu naban, tak lo Diox reta zha naban! ");
INSERT INTO zaoNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tsa lee thib maestr kuu nloo xkiiz Diox, nzhab lo Jesús: ―¡Kwathoz wen mkaba! ");
INSERT INTO zaoNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ne ngwalo mriid re koree, myet raa leettsoo zha ganaabdiz zha masraa kwaa lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tsa lee Jesús nzhab lo re men: ―¿Xomod mbez goo lee Crist Kuu Mtaal Diox Nabee nak xgann David? ");
INSERT INTO zaoNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ne leeka David mkee lo yeets chaan salm, ne nzhab: Lee Diox kuu nak Zha Nabee lo reta kwaa, nzhab lo Zha Nabee lon: “Btob lad ban lon, ");
INSERT INTO zaoNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","asta tsiin na re zha kuu nayii neʼa, tsa tobxub zha loʼa”. Sal. 110:1 ");
INSERT INTO zaoNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","’Ne leeka David nzhab: “Lee zha nak: Zha Nabee lon”. ¿Xomod tak gak zha xgann David tsa? ");
INSERT INTO zaoNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Reta men nzi ngeyon leettsa lee Jesús nzhab lo re zha kuu ngeteed lo Jesús: ");
INSERT INTO zaoNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Kenap goo goo, tsa kedit re maestr kuu nloo xkiiz Diox goo, tak nyow leettsoo zha gok zha re lar nol kuu kwathoz wen, ne nyow leettsoo zha kiits yek re men ni re men “diox” lo zha lo xbi. Ne nkwaan zha re ta mas wen tob zha ta nkaltaaʼaa nteedaa xkiiz Diox, ne nkwaan zha ta mas nataak nyetob zha leettsa nyoo ani. ");
INSERT INTO zaoNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ne nkib zha liz re ngot byud. Tsaraa kwathoz tetse naab zha lo Diox, tsa wen wii re men lo zha. ¡Per mas naroob yalti teriid Diox re zhaʼa! ");
INSERT INTO zaoNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tsa mwii Jesús lee re zha rik ngo naroob temi leen alkansi kuu ndob lee roo gwodoo chaan re zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ne noga mwii Jesús thib ngot byud kuu prob. Lee ngota mloo chopka temi kuu nataagt leen alkansi. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tsa nzhab Jesús: ―Wlipaa na nin lo goo, lee ngot prob ree mndaa mas naroob gon nake tedib net re men. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tak reta zha mloo naroob temi leen alkansi, per beeta kuu mrozhoob lo zha mloo zha. Per lee ngot prob ree mndaa reta temi kuu nap ngot, kuu tii ngot kuu wu ngot. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tsa lee chop tson re men kuu nzi ngetediz kwent chaan gwodoo chaan re zha Israel. Ne mbez zha lee re ke kuu naya gwodoo kwathoz chul nay, ne kon kwaro gon ngway. Tsa nzhab Jesús lo re zha: ");
INSERT INTO zaoNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Lee re ke kuu ngewii goo nal, tetsin thib wiz lee reta ke ree lux, yaant thibe dits tedibe. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tsa mnaabdiz re zha lo Jesús, ne nzhab zha: ―Maestr, ¿pol gak re koree? Ne, ¿kwan loo leettsa mera gak re koree? ");
INSERT INTO zaoNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús mkab lo re zha, ne nzhab: ―Kenap goo goo, tsa neeka thib zha kedit goo. Tak kwathoz zha yaad ne ne: “Na nak Crist Kuu Mtaal Diox Nabee”. Ne noga ne zha: “Mzin gaxa wiz kuu gak re koree”, per yelaazt goo kuu ne zha neeka teket goo dits zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Leettsa gon goo nzo zhoo reta ta, tsebt goo. Reta koree ndoblo gak ner; per nagt koree kuu lux yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Noga nzhab Jesús lo re zha: ―Lee thib yez yo kon tedib yez, ne lee re zha kuu nzo ta nabee thib rey yo kon re zha kuu nzo ta nabee tedib rey. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ne kwathoz gwin zho thoz lo yezlyu, ne la win, ne kwathoz tyen ta la yiz, ne loo re seny thoz lobee, ne yo re kuu thoz kuu tseb re men ne. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Per leettsa ter gak re koree, lee re men ten goo ne teti zha goo, ne yataan zha goo ta nkaltaa reʼaa nteedaa xkiiz Diox, ne noga yataan zha goo lo re rey, ne lo re zha kuu nak tsiin tsa ko zha goo tsib. Reta koree tsowno zha goo tak nyelaaz goo na. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Reta koree gak tsa tak taa goo kwent chaan da lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tsowt goo xgab naa kwan kab goo, or kuu naab re zha kuu nak tsiin kwent lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tak na ta yalnzhaak lo goo, tsa wen ne goo naa kwan kab goo ora; tsa lee re zha kuu nayii ne goo, gagt tow zha roo goo ne neeka gagt kab zha neeka thib kwaa lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ne leeka xut goo, leeka re wets goo, leeka re zha liz goo, ne leeka re zha nyey goo, yataan goo lo zha kuu nak tsiin. Ne kuth zha chop tson goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Reta men yii ne goo, tak nyelaaz goo na. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Per neeka thib yitsek goo luxt. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Per loka zha kuu xek rid re koree, zhaʼa tetsow gan yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Leettsa wii goo lee re soldad kwin dita roo yez Jerusalén, tsa ne goo mera lux Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tsa lee re zha kuu nzo yezlyu Judea ndoblo zhonn zha par net yii, ne lee re zha kuu nzo yeza ndoblo zhonn zha par yek yii, ne lee re zha kuu nzi wan, ndoblot bretab zha yez. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tak re wiza gak wiz kuu lee re mena rid kwathoz yalti thoz, tak retay ndoblo gak taxal nzhab lo xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kwathoz nati rid re ngot kuu nzo zhiinn wiza. Ne kwathoz nati rid re ngot kuu nap mbetdoo wiza, ne kwathoz nati rid re men kuu nzi lo yezlyu ree wiza, tak lee yalnayii chaan Diox la dits re zha kuu nzi lo yezlyu ree wiza. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Lee thib net re men gath lo zhoo, ne lee tedib net zha teno zha zha par gak zha mos tedib yezlyu. Tsa lee re zha kuu nagt zha Israel nabee lo re zha yez Jerusalén, asta yezhoob wiz kuu ndoblo nabee re zhaʼa lo re zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Ne telo loo re seny thoz lo wiz, lo mbee ne lo re mbel kuu nzib lobee. Tsa lee re men kuu nzo re yez kuu nzi lo yezlyu ree, teguz zha lo tseb leettsa wii zha lee nitdoo telo bexnit ne ke bi. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ne thitanax teguz re men lo tseb, por re kuu rid lo yezlyu, tak lee re kuu nzo lobee zhiit. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tsa lee re men wii, lee na Kuu Mzin Ngok Men, yalʼn xid xkow kon kwaro yalnabee chaan da ne kon xni thoz chaan da. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Leettsa ne goo lee re koree ngeyak, gwateli goo ne wii goo lobee, tak mera tsin na kuu taa yalnaban kuu thitanax lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tsa nzhab Jesús tedib kwent nanzee lo re men, ne nzhab Jesús: ―Wii goo lo ya ig ne wii goo lo tedib net re ya. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Leettsa ngwii goo lee re zhite ndelo la bzhits, tsa ne goo lee mbee beyi ndetsin gaxa. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Leeka tata, leettsa wii goo lee re koree ngeyak, neʼa goo ndetsin gaxa wiz kuu lee Diox nabee lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Wlipaa na nin lo goo, terka gath re men kuu nzi lo yezlyu nal ne lee re koree gak. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yezlyu ne lobee telux per lee xkizʼn ridt. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Bkenap goo goo, lo re kuu yezlyu ree, tsa kedit re kuu yezlyu ree goo, tsowt goo re kuu went kuu nlortsint, keet goo yalgwiy, neeka tsowt goo xgab naa kwan wu goo ne gu goo, tsa lista nzi goo wiz kuu lee na bretab, ");
INSERT INTO zaoNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","tak lee wiz kuu wenta chatta tsin lo reta men kuu nzo dib naxta lo yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","List gwatsin goo, ne thibka bnaab goo lo Diox gandata or, tsa ridt goo neeka thib re kuu went kuu rid, ne tsa ney to goo nyelaaz goo na, Kuu Mzin Ngok Men. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ne gandata wiz nloo Jesús lo re men lee roo gwodoo, ne reta yaal nya Jesús yii kuu le Olib, ne tya nyaan Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ne gandata wiz kwathoz til nzin re men lee roo gwodoo, tsa gon zha kuu ni Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ne tsya ndetsin gaxa wiz ani kuu le Paskw, leettsa nzhow zha pan kuu nyoot lebadur, tsa ntelaaz re zha Israel naa xomod mloo Diox re tey zha yezlyu Egipto. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tsa lee re ngwleyy kuu nataak lo re ngwleyy, ne re maestr kuu nloo xkiiz Diox, nkwaan zha naa xomod kuth zha Jesús xgaatsta, tak nzeb zha ne zha re men yez. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tsa lee Maxuuy mndaab leettsoo Judas kuu le Iscariote, zhaʼa nak thib zha lo re tsiibchop zha kuu mteed lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tsa lee Judas ngwa mndediz lo re ngwleyy kuu nabee lo re ngwleyy ne lo re polisi kuu nkenap gwodoo, tsa naa xomod tsow Judas par taa Judas Jesús lo re zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kwathoz laz re zha or mbin zha kona, ne nzhab re zha taa zha temi lo Judas. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tsa lee Judas myaan diiz taa Jesús lo re zha, ne mkwaan Judas mod tsow Judas or kuu yent men. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tsa mzin wiz kuu ndelo ani kuu le Paskw, wiz kuu nzhow zha pan kuu nyoot lebadur, ne leeka wiza nzhuth zha mbak zhiil kuu ndaa zha gon lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Tsa mtaal Jesús Pey rop Juan ne nzhab Jesús lo rop zha: ―Gwa goo ne btexkwaa goo rtsee Paskw dowaa. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Per lee rop zha mnaabdiz lo Jesús, ne nzhab zha: ―¿Pa nlaaza yatexkwaa neey? ");
INSERT INTO zaoNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Lee Jesús mkab, ne nzhab: ―Gwa goo yez, ne tya tsal goo thib mbyi kuu ne thib ree nit, teke goo dits zha, asta yuu ta tab zha, ");
INSERT INTO zaoNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ne gab goo lo zha kuu nak chaan yuu: “Lee maestr ne: ¿Pa ndob yuu ta wu rtseen rtsee Paskw kon re zha kuu ngeteed lon?” ");
INSERT INTO zaoNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tsa loo zha thib yuu naro kuu chop pis lo goo, ne yuu kuu ndob par ya tya nziʼa reta kuu lortsin goo, tya texkwaa goo kuu dow rtseeʼaa. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tsa nda rop zha kuu ngeteed lo Jesús, ne mzal zha re kuu taxalka nzhab Jesús lo zha, ne mdexkwaa zha rtsee Paskw. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Leettsa mzin or kuu wu rtsee re zha, tsa lee Jesús mndob roo mes kon re tsiibchop apóstl. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ne nzhab Jesús lo re zha: ―Kwathoz nlazʼn wun rtsee Paskw ree kon re goo, nal kuu bee ter riidʼn yalti. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Wlipaa na nin lo goo, bret raa na wun rtsee ree tedib welt, asta leettsa gak kuu nak rtsee ree yibaa ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tsa mzhen Jesús bas ne mndaa Jesús texkix lo Diox, ne nzhab Jesús: ―Bzhen gooy ne gwii gooy ne briid gooy lo re altaa goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tak wlipaa na nin lo goo, nalsi gut raa na xit ub, asta wiz kuu gu nay ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tsa mzhen Jesús pan ne mndaa Jesús texkix lo Diox, ne mtsow rol Jesús pan. Ne mndaa Jesús pan lo re zha kuu ngeteed lo Jesús, ne nzhab Jesús lo re zha: ―Koree nak beel da, kuu tan tsa tsow goo gan yalnaban kuu thitanax. Btsow goo koree tsa telaaz goo na. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ne leeka tata mzhen Jesús bas, leettsa ngwalo ndow re zha pan, tsa nzhab Jesús: ―Lee xit ub kuu nzo leen bas ree, leey nak ren da kuu nak trat kub, ne ta nay por re goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Wii goo, lee zha kuu taan lo re zha kuu nayii nen, thibka nzob yaa lo mes kon na. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Wlipaa na nin lo goo, lee na Kuu Mzin Ngok Men, taa zha na lo re zha kuu nayii nen, tak tata mtsow Diox xgabe. ¡Per thitanax went rid zha kuu taan lo re zha kuu nayii nen! ");
INSERT INTO zaoNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tsa lee re zha kuu ngeteed lo Jesús, mndelo zha mnaabdiz zha lo altaa zha, naa cho zha kuu tsow kona. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tsa lee re zha kuu ngeteed lo Jesús mndelo zha mbyodiz zha, naa cho zha nak zha kuu mas nataak. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Per lee Jesús nzhab lo re zha: ―Wen ne goo lee re zha kuu nabee lo yezlyu ree, kwathoz nabee zha lo re zha kuu nzi lo zha, ne tataka ntsow re zha kuu nataak kwathoz nabee zha lo re zha zha, ne ni re men lee zha nak zha kuu ntsow kuu wen. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Per lo re goo gagte tata zhaa gake. Lee zha kuu mas nataak lo re goo zhaʼa ndoblo gak taxal zha kuu mas mndyeen, ne lee zha kuu nabee lo goo ndoblo gak kuu lortsin lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Kwan ntsow goo xgab? ¿Cho nak zha kuu mas nataak; chu zha kuu ndob roo mes ngeyowe o zha kuu ngego kwaa leen yanne? Wlipaa, zha kuu ndob roo mes nak zha kuu mas nataak nake zha kuu ngego kwaa leen yann. Per lee na nak zha kuu nlortsin lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Ne lee re goo thibka ndo goo kon na lo re yalti kuu ngeriidʼn. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kona tan yalnabee nabee goo, taxal mndaa Xutʼn yalnabee nabeen, ");
INSERT INTO zaoNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","tsa tak wu goo ne gu goo ta nabeen, ne tob goo naab goo kwent lo re tsiibchop raz zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tsa nzhab Jesús lo Pey: ―Pey, bkenza koree. Lee Maxuuy mnaab nabee lo goo, tsa koo zhaa Maxuuy goo, taxal ntsib zha nzob xtil leettsa ntembi zhay. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Per lee na ngenaab lo Diox, tsa laata kuu nyelaaza. Tsa leettsa breʼa lon, tsowa ayud re wetsa tsa ney to zha lon. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Per lee Pey nzhab lo Jesús: ―¡Zha Nabee! Lista ndon yan tsib kon lu, ne asta lista ndon gathʼn kon lu. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Lee Jesús mkab lo Pey ne nzhab: ―Pey, wlipaa na nin loʼa, leettsa terka kwez ngite naltseree leeʼa gab tson welt nlebeeta na. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tsa nzhab Jesús lo re zha kuu ngeteed lo Jesús: ―Leettsa mtaalʼn goo, nin lo goo gwet goo temi, neeka bols kuu yo re chaan goo, neeka tedib net labyid goo. Ne, ¿chu nzo kwan ngok falt lo goo? Tsa lee re zha mkab ne nzhab: ―Neeka thib kwaa ngogt falt lo nee. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tsa lee Jesús nzhab lo re zha: ―Per lee nal zhaa nake; ndoblo gwe goo temi ne bols kuu yo re chaan goo. Ne loka cho goo kuu nkenot espad, ndoblo tho goo kamis goo tsa tii goo thibe. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ne leen ni lo goo, ndoblo gak kuu nke lo xkeets Diox kwent chaan da, ta nzhab: “Lee re men ndak no zha nak thib zha went”. Is. 53:12 Ne reta kuu nzhab lo xkeets Diox kwent chaan da, leechay ndoblo gak. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tsa lee re zha kuu ngeteed lo Jesús nzhab: ―Zha Nabee, nzhee nap nee chop espad. Tsa lee Jesús mkab ne nzhab: ―Wene. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tsa lee Jesús mroo tya, ne ngwa Jesús yii kuu le Olib taxalka ntsow Jesús, ne noga re zha kuu ngeteed lo Jesús ngwa kon Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ne leettsa mzin Jesús tya, tsa nzhab Jesús lo re zha: ―Bnaab goo lo Diox tsa kedit Maxuuy goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tsa mbeche Jesús lo re zha, asta teeka plotha gol men thib ke. Ne tya mtobxub Jesús ne mndelo Jesús mnaab lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ne tenzhee nzhab Jesús: ―Xutʼn, os leeʼa nlaaza, laata riidʼn re kuu ndoblo riidʼn, per gagte taxal nlazʼn, sinke taxal nlaaza gake. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tsa lee thib mandad chaan Diox ndyaad mroo yibaa mloney leettsoo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ne kwathoz nalatt ngoo leettsoo Jesús, tsa mas tetse mndediz Jesús lo Diox. Ne lee lon Jesús nzhab lo yu taxal thib ke ren. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ne leettsa ngwalo mndediz Jesús lo Diox, tsa ngwateli Jesús, ne mretab Jesús ta mlaa Jesús re zha kuu ngeteed lo Jesús. Ne or mzin Jesús lo re zha, lee re zha naxat, tak kwathoz nabil nzo leettsoo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tsa nzhab Jesús lo re zha: ―¿Chebee naxat goo? Gwache goo ne bnaab goo lo Diox, tsa kedit Maxuuy goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ne leettsa lee Jesús bee ngenika lo re zha, tsa lee Judas kuu nak thib zha lo re tsiibchop zha kuu mteed lo Jesús, ndener lo kwaro men. Tsa mbig Judas lo Jesús ne ndow Judas chut cho kwat Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Per lee Jesús nzhab lo Judas: ―Judas, ¿chu anta kon thib chut taaʼa na, Kuu Mzin Ngok Men lo re zha kuu nayii nen? ");
INSERT INTO zaoNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Or mwii re zha kuu nzi lo Jesús kuu ngeyak, tsa mnaabdiz re zha lo Jesús ne nzhab zha: ―Zha Nabee, ¿chu ndoblo yo nee kon espad nee? ");
INSERT INTO zaoNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Per lee thib zha kuu ndo kon Jesús, mloo espad ne mga zha nza ban mos ngwleyy kuu nabee lo reta ngwleyy. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tsa lee Jesús nzhab lo zha kuu mga nza mos ngwleyy: ―¡Laa! Ne ora mzhen Jesús nza mosa ne mkengiin Jesús nza mos tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Oraaka nzhab Jesús lo re ngwleyy kuu nabee lo re ngwleyy ne lo re zha kuu nabee lo re zha kuu nkenap gwodoo, ne lo re zha gol, re zha kuu ndyaad teno Jesús: ―¿Chebee kon espad ne kon ya ndyaad goo ten goo na taxal thib wann? ");
INSERT INTO zaoNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Gandata wiz mndon lo re goo lee roo gwodoo, ne mzhent goo na. Per nal nak or goo, tak lee yalkow nabee lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tsa mzhen zha Jesús ne ndano zha Jesús liz ngwleyy kuu nabee lo reta ngwleyy, ne lee Pey tith tith ndeke dits re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tsa mtee re zha bel lee, ne mndob re zha roo lo ki mbiz zha. Ne no Pey mndob xid re zha mbiz lo ki. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tsa lee thib ngot kuu nak mos chaan ngwleyy kuu nabee lo reta ngwleyy, mwii lee Pey ndob ngebiz lo ki, ne wen wen mwii ngot lo Pey ne nzhab ngot: ―Noga mbyi ree mndiy kon zha baa. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Per lee Pey mkedi ne nzhab: ―Ngot, neeka nlebeetʼn mbyi baa. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tut bluz, lee tedib zha mwii lo Pey, ne nzhab zha: ―Noga lu naka thib zha kuu mndeke dits re zha baa. Per lee Pey nzhab: ―¡Aha, notʼn! ");
INSERT INTO zaoNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ne teeka thib or bluz, lee tedib zha nzhab: ―Wlipaa noga mbyi ree ndiy kon zha baa, tak lee mbyi ree nak thib zha yezlyu Galilea. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Per lee Pey mkab, ne nzhab: ―¡Neeka netʼn naa kwan mbeza lon! Ne lee Pey bee ngenika lee ngite mrez. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ne ora lee Zha Nabee mwii lo Pey, tsa mtelaaz Pey kuu nzhab Zha Nabee lo Pey, or kuu nzhab zha: “Leettsa terka kwez ngite, leeʼa gab tson welt nlebeeta na”. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tsa lee Pey mroo ne kwathoz nabil ngoo leettsoo Pey ne kwathoz mbinn Pey. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ne lee re zha kuu mkenap Jesús mzhizno zha Jesús, ne mdin zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ne mtow re zha lo Jesús kon thib le lar, ne mbez re zha lo Jesús: ―¡Ne, naa cho mkeey yeka! ");
INSERT INTO zaoNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ne kwathoz re kuu went mbez re men lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Leettsa ngwani yezlyu tedib wiz, lee re zha kuu nataak lo re zha Israel, re ngwleyy kuu nabee lo re ngwleyy ne re maestr kuu nloo xkiiz Diox, mkaltaa re zha, ne mndeno zha Jesús ta nzi re men kuu mkaltaa re zha. Ne tya mnaabdiz zha lo Jesús, nzhab zha: ");
INSERT INTO zaoNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Ne lo nee, ¿chu lu nak Crist Kuu Mtaal Diox Nabee? Jesús mkab ne nzhab: ―Os ni nay lo goo yelaazt gooy. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ne os leen naabdizʼn thib kwaa lo goo, kabt goo lon. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Per desde naltseree, lee na Kuu Mzin Ngok Men tob lad ban lo Diox kuu kwathoz ney. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tsa reta men nzhab lo Jesús: ―¿Chu lu nak Xgann Diox tsa? Tsa lee Jesús nzhab: ―Leeka re goo mbez, lee na nake. ");
INSERT INTO zaoNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tsa lee re zha nzhab: ―Ndechet raa naabdizaa lo masraa zha, kuu taa kwent chaan zha ree. Mbina lee leeka lee zha mney kon roo zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tsa lee reta zha ngwateli ne mndeno zha Jesús lo Pilat. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ne mndelo re zha mkeki zha Jesús, ne mbez re zha: ―Ngogaa zha ree lo re nee, lee zha ndano tawlaz nee tedib net kuu went, ne mbez zha lo re men: “Ndoblot kizhaa temi chaan yezlyu lo César zha kuu nabee Roma”, ne noga nzhab zha: “Lee zha nak Crist Kuu Mtaal Diox Nabee”. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tsa lee Pilat mnaabdiz lo Jesús, ne nzhab: ―¿Chu lu nak rey chaan re zha Israel? Jesús mkab lo Pilat ne nzhab: ―Taxal neʼa, tabaa nake. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tsa lee Pilat nzhab lo re ngwleyy kuu nabee lo re ngwleyy ne lo re men kuu nzi tya: ―Ndakʼn neeka thib falt mndaat mbyi ree. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Per lee re men ndelo mbez: ―Wii, asta yezlyu Galilea mndelo zha ngeloo zha kwent chaan zha, ne nal mzina zha asta nzhee yez Judea. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Leettsa mbin Pilat koree, tsa mnaabdiz Pilat: ―¿Chu zha yezlyu Galilea nak mbyi ree? ");
INSERT INTO zaoNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ne leettsa mbin Pilat lee Jesús nak zha yezlyu ta nabee rey Herodes, tsa mtaal Pilat Jesús lo rey Herodes. Ne lee wiza lee Herodes ndo yez Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ne kwathoz laz Herodes or mwii zha Jesús, tak ndaʼa wiz nlaaz zha wii zha Jesús, tak kwathoz tyen welt nda nzhon zha kwent chaan Jesús, ne nlaaz zha wii zha tsow Jesús thib kuu thoz. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tsa lee Herodes mnaabdiz kwaro kwaa lo Jesús, per yent kwan mkab Jesús lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Per lee re ngwleyy kuu nabee lo re ngwleyy, ne re maestr kuu nloo xkiiz Diox kuu nzi tya, naroob kuu mkeki re zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tsa lee Herodes ne re soldad zha, taxal zha kuu nataagt mtsowno re zha Jesús ne mzhizno zha Jesús. Ne mtegok xab zha Jesús taxal thib rey. Tsaraa mtaal Herodes Jesús lo Pilat tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ne wiza lee Pilat rop Herodes myey, tak mbyo rop zha ndala. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tsa lee Pilat mrez re ngwleyy kuu nabee lo re ngwleyy ne re zha kuu nabee lo re zha yez, ne re men yez, tsa kaltaa re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Tsa nzhab Pilat lo re zha: ―Lee goo myaadno zha ree lon, ne nkeki goo zha lee zha nkedi re men, ne ndano zha re men net went. Ne nal ngewii goo mnaabdizʼn lo zha, ne ndakʼn neeka thib re kuu nkeki goo zha mtsowt zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ne noga Herodes ndak yent kwan mtsow zha, kona mre Herodes mtaal zha lon tedib welt. Ne neeka thib kuu went mtsowt zha ree par ndoblo zha gath zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nal tetin zha, tsaraa telaan zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ne gandata liin leettsa ntsow zha ani Paskw, lee Pilat ntelaa thib zha kuu nzo tsib. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Per reta men mndelo mrez dib gan, ne nzhab: ―¡Nlaazt nee telaaʼa mbyi baa! ¡Lee nee nlaaz telaaʼa Barrabás! ");
INSERT INTO zaoNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ne lee Barrabás nak thib zha kuu mbeth men, leettsa mbyo Barrabás kon re zha kuu nabee yez, kona mloo zha Barrabás tsib. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tsa lee Pilat ngwalaaz gatelaa Jesús, tsa mre Pilat mni zha lo re men tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Per lee re men mre mrez dib gab tedib welt, ne nzhab: ―¡Bkee zha lo kruz, bkee zha lo kruz! ");
INSERT INTO zaoNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Myon welt mre Pilat nzhab lo re men: ―Mbay, ¿kwan thib kuu went mtsow zha ree? Ter yetsalʼn neeka thib kuu went kuu mtsow zha par ndoblo gath zha, beeta tetin zha, tsaraa telaan zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Per lee re zha tataka dib gan nzo zha mbez zha; ndoblo ke Jesús lo kruz. Ne kwaro mrez re zha, asta mtsow zha gan mtsow Pilat kuu nlaaz zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tsa lee Pilat mnabee gake taxal nlaaz re men. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Tsa mtelaa Pilat Barrabás kuu nzo tsib, kuu mbeth men leettsa mbyo re zha, kon zha kuu nabee yez, ne mndaa Pilat Jesús lo re zha, tsa tsowno zha Jesús loka kuu nlaaz zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Leettsa ndano zha Jesús par kee zha Jesús lo kruz, tsa lee thib mbyi kuu le Simún kuu nak zha yez Cirene, ndyaad ngwa wan, tsa mnabee re soldad gwe Simún kruz Jesús ne teke Simún dits Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ne kwathoz men mndeke dits Jesús, ne kwathoz re ngot nalatt nzhonn ne Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Per lee Jesús mwii lo re ngot ne nzhab: ―Rtsaapʼn zha Jerusalén, nzhonnt goo ne goo na, lee goo nzhonn kwent chaanka goo ne kwent chaan re zhiinn goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tak too thib wiz kuu gab goo: “Kwathoz wen nda re ngot kuu mndaat Diox mbet lo, ne noga kwathoz wen nda re ngot kuu ngwiit mbet nzii”. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tsa telo re men gab lo re yii: “Bla goo dits nee”. Ne noga gab zha lo re yii: “Bkaats goo nee”. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tak os lee zha tenzhee ntsow zha lo thib ya nayee, ¿kwanta nak ya biz lo zha? ");
INSERT INTO zaoNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ne noga ndano zha chop zha nakap, tsa thibka kuth zha rop zhaʼa kon Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Leettsa mzin re zha thib ta ni zha “Tsith yek men”, tsa lee re soldad mkee Jesús lo kruz, ne noga mkee zha rop zha kuu mbeth men lo kruz, thib zha mkee zha lad ban lo Jesús lee tedib zha mkee zha lad beg lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tsa lee Jesús nzhab: ―Xutʼn, btuyy re kuu went kuu ngetsow re zha ree, tak net zha naa kwan ngetsow zha. Ne mloo re soldad swert naa cho tsow gan xab Jesús, tsa naa kwan diinn kadta thib thib zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ne dita lo Jesús nzi re men ngewii, ne xid re zhaʼa nzi re zha kuu nabee lo re zha yez, ne mzhizno zha Jesús, mbez zha: ―Mlaat zha gagath tedib net zha, ne chebee gagt la zha leeka lee zha lo kruz, os lee zha nak Crist Kuu Mtaal Diox Nabee lo re zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ne noga re soldad mzhizno Jesús, ne mbig zha mndaa zha xit ub kuu ni gu Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Tsa nzhab re soldad lo Jesús: ―Os lu nak rey chaan re zha Israel, blaʼa leeka lu lo kruz. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ne mkee zha thib letr lo kruz kuu nzhab: “ZHA REE NAK REY CHAAN RE ZHA ISRAEL”. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tsa lee thib wann kuu nke lo kruz cho Jesús, mtsalzhoo Jesús, ne nzhab: ―Os lu nak Crist Kuu Mtaal Diox Nabee, blaʼa leeka lu lo kruz, ne blaga nee lo kruz. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Per lee tedib wann kuu nke tedib lad cho Jesús lo kruz, mnayii lo tedib wanna, ne nzhab: ―¿Chebee nzebta neʼa Diox? Si re yonaa ngeriid yalti. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ropaa ndoblo ridaa yalti tak mtsowaa kuu went, per lee mbyi ree neeka thib kuu went mtsowt zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tsa nzhab zhaʼa lo Jesús: ―Zha Nabee, btelaazʼn, leettsa tsina ta nabeeʼa. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Tsa lee Jesús nzhab lo zha: ―Wlipaa na nin loʼa, leeka naltseree leeʼa to kon na laats chul chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ne ndrol wiz mkow yezlyu, ne kona mxek asta las tres mziy yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ne lee wiz mndaat raa xni. Ne lee lar kuu now Ta Kwathoz Nayon leen gwodoo mrat ngok chop le. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tsa lee Jesús mrez ne nzhab: ―Xutʼn, loʼa tan xbi da. Or ngwalo nzhab Jesús kona, nguth Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tsa lee soldad kuu nabee lo thib gayoo soldad, or mwii zha xa nguth Jesús, mbil zha lo Diox, ne nzhab zha: ―Wlipaa lee mbyi ree nak thib mbyi nali. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ne reta zha kuu nzi ngwii naa xa nguth Jesús, kwathoz nabil ngoo leettsoo zha ne nkaan yaa zha pech zha ndya zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ne reta zha kuu nzaal leettsoo ne Jesús, ne re ngot kuu mndeke dits Jesús desde Galilea, tithxa mrin zha mwii zha re kuu mtsowno re men Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Noga ngoo thib mbyi wen kuu le Che. Zhaʼa nak thib zha yez Arimatea yez chaan yezlyu Judea, ne nak zha thib re zha kuu nataak lo re zha Israel, re zha kuu mnabee nguth Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ne ngebet zha tsin wiz kuu nabee Diox, ne ngoot leettsoo zha kuu mtsowno re men Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tsa ngwa zha lo Pilat ne mnaab zha kwerp Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Leettsa mla zha kwerp Jesús lo kruz, mchiix zhay thib le lar kuu kwathoz wen, ne mloo zha kwerp Jesús leen thib baa kuu mdaan zha cho ke. Kuu neeka thib zha ter yo. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Wiza nak wiz kuu ndexkwaa re zha re kuu nzhow zha wiz kuu ndroxkwan zha, kuu mera telo. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ne lee re ngot kuu mndeke dits Jesús desde Galilea, ngwa re ngot roo baa. Ne mwii ngot xa mloo zha kwerp Jesús leen baa. ");
INSERT INTO zaoNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tsa mretab re ngot ndya ngot, ne mzhii re ngot thib perfum kuu kwathoz chul ndetsi, ne mneyy re zha wiz kuu ndroxkwan re zha, taxal nabee ley. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Leettsa penta ndeyeni yezlyu wiz domin wiz kuu nak ner sman, tsa ngwa re ngota roo baa ta mloo zha kwerp Jesús, ne mbe re ngot perfum kuu kwathoz chul ndetsi. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Leettsa mzin re ngot roo baa, mwii re ngot lee ke kuu myow roo baa, nowtle roo baa. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tsa mndaab re ngot leen baa, ne mzalt re ngot kwerp Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ne leettsa kwathoz ngetsegey leettsoo re ngot, mwii re ngot lee chop mbyi ndeli cho ngot, nok lar naguz kuu nla xni. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ne tak kwathoz mzeb re ngot, tsa mkiits ngot yek ngot ne mwii ngot lo yu. Tsa lee rop mbyiʼa nzhab lo re ngot: ―¿Chebee nkwaan goo zha kuu naban xid re zha nguth? ");
INSERT INTO zaoNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wii goo yenta zha nzhee; mrobana zha. ¿Chu ntelaazt goo kuu ne zha lo goo, leettsa ndoka zha lo goo yezlyu Galilea? ");
INSERT INTO zaoNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Leettsa ne zha lo goo: “Lee na Kuu Mzin Ngok Men, ndoblo taa zha na lo re zha kuu ndab falt, tsa kee zha na lo kruz, per leettsa tsaal tson wiz lee na roban”. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tsaraa mtelaaz re ngot naa kwan nzhab Jesús lo re ngot, leettsa bee ndo Jesús lo re ngot. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ne leettsa mretab re ngot ngwa roo baa, tsa nzhab re ngot re kuu mwii re ngot lo re tsiibthib zha kuu mteed lo Jesús, ne lo tedib net zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ne re ngota nak kuu ngwalo diize lo re tsiibthib zha kuu mteed lo Jesús; Mari Magdalen, Juan ne Mari xnaa Santiag ne tedib net ngot. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Per lee re zha kuu mteed lo Jesús mgab ndata leettsoo zha mbin zha re kuu nzhab re ngot lo re zha, ne ngwalaazt zhay. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Oraaka lee Pey ngwateli ne mrozhonn ngwa roo baa. Ne or mzin Pey mwii Pey leen baa, ne beeta lar kuu mchiix zha Jesús mwii Pey, tsa kwathoz mzegey leettsoo Pey ndya Pey, tak mwii Pey kona. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Leeka wiza lee chop zha kuu mteed lo Jesús nda net yez Emaús, yez kuu nzi teeka tsiibthib kilometro lo yez Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nda rop zha ne ndediz zha re kuu ngok. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ne leettsa ngetediz rop zha, leeka ora lee Jesús nda ndiy kon rop zha, ");
INSERT INTO zaoNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","per thib kuu mtow lo rop zha, kona mlebeet zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tsa lee Jesús mnaabdiz lo rop zha ne nzhab: ―¿Cho kwent ngetediz goo ndo goo net? Tsa mlet rop zha ne kwathoz nabil ngoo leettsoo rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tsa lee thib zha kuu le Cleofas nzhab lo Jesús: ―¿Chu nagt Jerusalén mrooʼa? ¿Chu ter gona re kuu ngok nal leen re wiz ree? ");
INSERT INTO zaoNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tsa lee Jesús mnaabdiz lo rop zha ne nzhab: ―¿Kwan ngok? Lee rop zha mkab ne nzhab: ―Lee nee ngetediz kwent chaan Jesús zha Nazaret, lee zha ngok thib zha kuu kwathoz nataak ne ngok zha profet lo re men. Diox mtaal zha mtsow zha re kuu thoz, ne mni zha kon yalnabee lo re men, ne kwathoz mzegey leettsoo re men mwii re kuu mtsow zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ne lee re ngwleyy kuu nabee lo re ngwleyy ne re zha kuu nabee, mndaa zha Jesús lo re zha kuu mbeth Jesús, ne mkee zha Jesús lo kruz. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ne lee re nee mtsow xgab lee Jesús gak zha kuu nabee lo re tawlazaa, ne tenet zha re zha yez Roma, per nal ndaʼa tson wiz nguth zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","¡Per nal til ree lee chop tson ngot mtsow mzegey leettsoo nee, tak ngwa re ngot roo baa Jesús, ");
INSERT INTO zaoNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ne mzalt ngot kwerp Jesús! Ne leettsa mretab re ngot ne ngot lo nee, lee ngot mwii chop mandad chaan Diox, kuu nzhab lo ngot lee Jesús naban. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tsa ngwa chop tson nee, ngwatwii roo baa, ne leeka taxal mne re ngota ne zha, per mwiit zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tsa lee Jesús nzhab lo rop zha: ―¡Chebee kwathoz nayez yek goo! Ne ¿chebee kwathoz nad leettsoo goo ne nyelaazt goo re kuu nzhab re profet kuu ngoo ndala? ");
INSERT INTO zaoNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Chu ndoblot rid Crist Kuu Taal Diox Nabee yalti, ne tsaraa bretab zha ndya zha lo xni ta nabee zha? ");
INSERT INTO zaoNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tsa lee Jesús mndelo mndaa kwent naa xomod mrolo re kuu nke lo xkeets Diox kwent Jesús, ne mndelo Jesús mndaa kwente kon re kuu mkee Moisés lo re libr chaan ley ne re kuu mkee re profet kuu ngoo ndala. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ne leettsa mzin rop zha yez ta nda zha, tsa lee Jesús mtsow taxal thib zha kuu nda mas tith, ");
INSERT INTO zaoNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","tsa lee rop zha nzhab lo Jesús: ―Blet kon nee, tak mziʼa yezlyu. Tsa mlet Jesús lo rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Leettsa nzi re zha roo mes wu zha, ora mzhen Jesús pan ne mndaa Jesús texkix lo Diox ne mtsow rol Jesús pan ne mndaa Jesús pan lo rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tsaraa mzhaal lo rop zha, ne mlebee zha Jesús. Per oraaka lee Jesús mnith lo rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tsa nzhab rop zha lo altaa zha: ―¿Chu wlipaa neeka lut myeentaa leettsa ndyaadaa ngetedizaa net, leettsa ngetaa zha kwent xkiiz Diox kuu nke lo xkeets Diox lo ropaa? ¿Chu thitanax mdowte leettsooʼaa ora? ");
INSERT INTO zaoNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ne oraaka ngoo rop zha net mretab zha yez Jerusalén tedib welt. Ne leettsa mzin rop zha tsa mzal zha re tsiibthib zha kuu mteed lo Jesús, ne tedib net re zha kuu nzi kon re zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tsa nzhab re zha lo rop zhaʼa: ―Wlipaa mroban Zha Nabee, tak mwiiʼa Simún zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tsaraa lee rop zhaʼa mndaa kwent, naa xomod mwii zha Jesús leettsa ndo zha net, ne xomod mlebee rop zha Jesús, leettsa mtsow rol Jesús pan. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Leettsa lee re zha bee ngetedizka re kona, lee Jesús cha mtsetab lo re zha, ne nzhab lo re zha: ―Wen brin goo. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Per lee re zha kwathoz mzeb zha, ne mnda leettsoo zha thib xbi thib zha ngewii. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Per lee Jesús nzhab lo re zha: ―¿Chebee kwathoz nzeb goo? ¿Ne chebee nzhak chop xgab goo? ");
INSERT INTO zaoNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Wii goo yaan ne niin. ¡Nay! Bdiinn goo na, tsa ne goo nay. Tak thib mbi yent beel mbi neeka yent tsidth mbi, taxal na. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Leettsa ngwalo nzhab Jesús kona, tsa mloo Jesús yaa Jesús ne nii Jesús lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ne tegal tata mloo Jesús yaa Jesús ne nii Jesús lo re zha, per ngwalaazt zhay, tak bee laz re zha. Tsa nzhab Jesús lo re zha: ―¿Chu nap goo lut kuu dowaa nzhee? ");
INSERT INTO zaoNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tsa mndaa zha thib le mbel kuu mbyex lo ki lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ne tyaka lo re zha ndow Jesús kona. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tsa nzhab Jesús lo re zha: ―Koree nak kuu mnin lo re goo, leettsa mndon kon re goo, reta kwent chaan da kuu nke lo ley chaan Moisés, ne re kuu nzhab re profet Diox zha ndala, ne re kuu mke zha lo libr chaan salm, retay mrolo. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tsaraa mtsow Jesús mzhaal yek re zha, tsa myen re zha xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tsa nzhab Jesús lo re zha: ―Tbaa nzhab lo xkiiz Diox lee Crist Kuu taal Diox Nabee ndoblo gath, ne leettsa tsaal tson wiz lee zha roban, ");
INSERT INTO zaoNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ne ndoblo taa goo kwent re koree lo reta men kuu nzo reta yez dib naxta lo yezlyu, ne ndoblo telo goo yez Jerusalén, ne koree nak kuu ndoblo gab goo lo zha, ndoblo tsee zha mod went kuu nak zha, tsa tuyy Diox re falt zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Re goo ndoblo taa kwent chaan da, tak re goo mbin ne mwii re kuu mtsowʼn. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kenza goo. Lee na taal zha kuu mne Xutʼn taal Xutʼn lo goo, per ndoblo kwet goo yez Jerusalén, asta yelo kayaa goo yalney kuu roo yibaa. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tsa mloo Jesús re zha tya ne mndeno Jesús re zha asta thib yez kuu le Betania, tsa mlap Jesús yaa Jesús ne mnaab Jesús lo Diox por re zha, tsa kenap Diox re zha. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ne leettsa bee ngenika Jesús lo Diox, zhega zhega ngwaap Jesús yibaa. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ne leettsa ngwalo mbil re zha lo Jesús, kwathoz laz re zha mretab zha Jerusalén tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ne thibka nzi re zha lee roo gwodoo chaan Diox, nzhool zha ne ndaa zha texkix lo Diox.");
INSERT INTO zaoNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Leettsa ter yo neeka thib kwaa, lee diiz naban nzoʼa, ne lee diiz naban ndo kon Diox, ne leeka diiz naban nak Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Lee diiz naban ree ndoʼa kon Diox desde ndala. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ne por diiz naban mdexkwaa reta kwaa, ne os nagte por diiz naban neeka thib re kuu nzo nal gatexkwaate. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Lee diiz naban ree nak yalnaban, ne lee yalnaban nak xni lo re men yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Lee xni ree ndaa xni lo yalkow, ne lee yalkow gagt tuyye. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ngoo thib mbyi kuu le Juan, Diox mtaal Juan, ");
INSERT INTO zaoNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","tsa myaad Juan par mndaa Juan kwent chaan xni, tsa yelaaz re men zha kuu nak xni por lee Juan. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nagt Juan xni, per lee Juan nak thib zha kuu mtaal Diox mndaa kwent chaan xni. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tsa lee xni kuu wlipaa nak xni kuu nteni lo re men, ndyaad lo yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Lee zha kuu nak diiz naban myaad lo yezlyu ree, ne tegal por lee zha mdexkwaa Diox yezlyu ree; per lee re men yezlyu ree mlebeet zha zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Lee zha myaad por re tawlaz zha, per lee re tawlaz zha mkayaat zha zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Per lee re zha kuu mkayaa zha ne ngwalaaz zha, mndaa zha diiz lo re zhaʼa, par gak re zhaʼa zhiinn Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Lee re zha ree nak zha zhiinn Diox, tak tata nlaaz Diox, ne nagte tak nlaaz xut zhay o xnaa zhay. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Lee diiz naban ngok men, mban zha ne ngoo zha xid re nee, mwii nee yalnkelaaz chaan zha ne mne nee wli kuu nzhab zha. Ne noga mwii nee yalnabee chaan zha kuu mndaa Xut zha lo zha; ne yalnabee ree mloo beeta lee zha nak Xgann Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan mndaa kwent chaan zha, leettsa nzhab Juan: ―Zha ree nak zha kuu mtethʼn lo goo leettsa mnin: “Lee zha kuu ndyaad tut bluz nake na, mas nataak zhaʼa nake na, tak nzoʼa zhaʼa desde ndala leettsa terka galʼn”. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ne retalee nkayaaʼaa yalwen lo zha, thibe ne tedibe nkayaaʼaa. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés nak cho mndaa ley chaan Diox lo re men, per lee yalnkelaaz chaan Diox ne kuu wli myaad por Jesucrist. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Neeka thib men ter wii Diox, beeta Xgann Diox kuu thita lo Diox, kuu thibka ndo lo Diox mwii lo Diox, ne lee Xgann Diox nak cho mloo naa xa nak Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Leettsa lee re zha Israel zha Jerusalén, mtaal re ngwleyy ne re zha kuu ntsow ayud re ngwleyy ngwanaabdiz lo Juan, naa cho nak Juan. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Tsa lee Juan mkab lo re zha, ne nzhab Juan: ―Nagtʼn Crist Kuu Mtaal Diox Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tsa lee re zha mre mnaabdiz lo Juan, ne nzhab: ―¿Cho naka tsa? ¿Chu lu nak Lí, profet kuu ngoo ndala? Juan mkab ne nzhab: ―Nagte na. Tsa mre re zha nzhab: ―¿Chu lu nak tedib re profet kuu ngoo ndala, kuu naka diiz yaad? Lee Juan mkab ne nzhab: ―Nagte na. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tsa mre re zha mnaabdiz zha: ―¿Cho naka tsa? Tak ndoblo gab nee thib kwaa lo re zha kuu mtaal nee. ¿Chu tak neʼa lo nee naa cho naka? ");
INSERT INTO zaoNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan mkab ne nzhab: ―Na, nak taxal thib bos kuu nii thib ta yubiz, taxal nzhab profet Isaí zha ndala, or kuu nzhab zha: ¡Bxaal goo thib net nali par te Zha Nabee! Is. 40:3 ");
INSERT INTO zaoNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Tsa lee re zha kuu mtaal re fariseo lo Juan, mre mnaabdiz lo Juan, ");
INSERT INTO zaoNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ne nzhab: ―Os leeʼa nagta Crist Kuu Mtaal Diox Nabee, neeka nagta Lí, ne neeka nagta thib re profet, ¿chebee ntsowleyya re men tsa? ");
INSERT INTO zaoNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan mkab, ne nzhab: ―Na ntsowleyy re men kon nit, per xid goo ndo thib zha kuu nlebeet goo, ");
INSERT INTO zaoNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","lee zha ndyaad tut bluz nake na, per masraa nataak zha nake na, ne kona neeka korre dits labyid zha ndoblotʼn xakʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ne reta koree ngok thib ta le Betania, tedib lad roo yoo Jordán, ta mtsowleyy Juan re men. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ne lee tedib wiza mwii Juan lee Jesús ndyaad lo Juan, tsa nzhab Juan: ―¡Wii goo, zha ree nak Mbak zhiil Diox, kuu nkib falt chaan re men yezlyu ree! ");
INSERT INTO zaoNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Zha ree nak zha kuu mndan kwent lo goo or kuu mnin: “Tut bluz nake na ndyaad thib zha kuu mas nataak nake na, tak nzoʼa zha desde ndala leettsa terka galʼn”. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tegal mlebeetʼn zha, per mtsowleyyʼn re men kon nit, par lebee re zha Israel zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ne noga mndaa Juan kwent ne nzhab Juan: ―Mwiin lee Mbi Nayon mroo lobee taxal thib palom mla dits zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ne lee na netʼn cho nak zha tsya. Per lee zha kuu mtaalʼn tsowleyyʼn re men kon nit, ne lon: “Loka zha kuu wiiʼa la Mbi Nayon dits ne yaan Mbi Nayon lo, zhaʼa nak zha kuu tsowleyy kon Mbi Nayon”. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ne na mwiiy, ta mod ndan kwent lo re men, lee zha nak Xgann Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ne lee tedib wiza, leeka tya ndo Juan kon chop zha kuu ngeteed lo Juan. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Or mwii Juan lee Jesús nderid tya, tsa nzhab Juan: ―¡Wii goo, zha baa nak, Mbak zhiil Diox! ");
INSERT INTO zaoNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ne mbin rop zha kuu ngeteed lo Juan kuu nzhab Juan, tsa mndeke rop zha dits Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Or mtsere lo Jesús lee rop zhaʼa ndeke dits Jesús, tsa mnaabdiz Jesús lo rop zha, ne nzhab Jesús: ―¿Kwan nkwaan goo? Lee rop zha mkab ne nzhab: ―Maestr, ¿pa nzoʼa? ");
INSERT INTO zaoNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús mkab ne nzhab lo rop zha: ―De goo, tsa ne gooy. Tsa ngwa rop zha, ne mwii zha pa nzo Jesús, ne myaanka rop zha kon Jesús wiza, tak ndaʼa or, ora nzhak teeka las cuatro wiza. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ne lee Ndres wets Simún Pey, nak thib zha lo rop zha kuu mbin kuu nzhab Juan, ne mndeke zha dits Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ne or mzal Ndres wets Ndres kuu le Simún, tsa nzhab Ndres lo Simún: ―Mwiiʼa nee Zha Kuu Mtaal Diox Nabee (zha le Crist). ");
INSERT INTO zaoNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tsa ndano Ndres Simún ta ndo Jesús, ne or mwii Jesús lo Simún, tsa nzhab Jesús lo Simún: ―Lu nak Simún, xgann Jonás, per desde nal leeʼa role Cefas (diiz ree nak “Pey”). ");
INSERT INTO zaoNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ne tedib wiza lee Jesús mroo nda yezlyu Galilea. Tsa mwii Jesús Lip ne nzhab Jesús lo Lip: ―Bteke ditsʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ne lee Lip nak zha yez Betsaida, tawlaz Ndres rop Pey nak Lip. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Tsa ngwakwaan Lip Natanael, ne or mzal Natanael lo Lip, nzhab Lip: ―Mzala nee zha kuu mndaa Moisés kwent lo libr chaan ley, leeka zha kuu mndaa re profet kwent. Lee zha nak Jesús xgann Che zha Nazaret. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tsa nzhab Natanael: ―¿Chu tak roo thib zha ro yez Nazaret? Lip mkab ne nzhab: ―De, tsa ne luy. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Or mwii Jesús lee Natanael ngebig lo Jesús, tsa nzhab Jesús: ―Baa ndyaad thib zha kuu wlipaa nak zha Israel, thib zha kuu nkedit. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tsa lee Natanael mnaabdiz lo Jesús ne nzhab: ―¿Xomod nlebeeʼa na? Jesús mkab lo Natanael ne nzhab: ―Or kuu ter kwez Lipa, mwiin leeʼa ndob xann ya ig. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tsa nzhab Natanael lo Jesús: ―Maestr, ¡lu nak Xgann Diox, lu nak rey lo re zha Israel! ");
INSERT INTO zaoNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús mkab lo Natanael, ne nzhab: ―¿Nyelaaza na tak nin loʼa: Leeʼa ndob xann ya ig? Per nalraa wiiʼa masraa re kuu thoz nake koree. ");
INSERT INTO zaoNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Noga nzhab Jesús lo re zha: ―Wlipaa na nin: Desde naltseree wii goo lee lobee zhaal, ne lee re mandad chaan Diox ndeke ne ndela lo na, Kuu Mzin Ngok Men. ");
INSERT INTO zaoNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ne leettsa ndaʼa tson wiz, tsa ngoo thib fandan yez Caná, yez kuu nzi yezlyu Galilea. Ne tya ndo xnaa Jesús, ");
INSERT INTO zaoNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ne noga mrez zha Jesús kon re zha kuu ngeteed lo Jesús, tsa ya re zha lo fandan. ");
INSERT INTO zaoNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Per leettsa mbiz xit ub, tsa nzhab xnaa Jesús lo Jesús: ―Nkenot raa zha ree xit ub. ");
INSERT INTO zaoNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tsa lee Jesús mkab ne nzhab: ―¿Chebee lon mbeza koree? Bee ter tsin or kuu leen tsow koree. ");
INSERT INTO zaoNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Per lee xnaa Jesús nzhab lo re zha kuu ngeyiid xit ub: ―Btsow goo reta kuu ne zha lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ne tya nzi xoop ree ke, kuu nlortsin re zha Israel par nyoo nit kuu na zha, tsa nzhak nambi zha lo Diox ley lo zha. Ne kadta thib re reeʼa nyoo teeka thap gal o thib gayoo litr nit. ");
INSERT INTO zaoNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tsa nzhab Jesús lo re zha kuu ntsow tsiin tya: ―Btse goo re ree baa bloo goo nit. Ne mtse zhay mloo zha nit. ");
INSERT INTO zaoNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tsa nzhab Jesús lo re zha: ―Bloo goo lutte, ne be gooy lo zha kuu nabee lo goo. Ne tata mtsow zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ne lee zha kuu nabee lo re zha mtsow preb nit kuu mreyal xit ub, per neeka net zha pa mrooy, beeta re zha kuu ntsow tsiin ne pa mrooy, tak re zha mtse re ree. Ne lee zha kuu nabee lo re zha mrez mbyi kuu mtseyaʼa, ");
INSERT INTO zaoNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ne nzhab zha lo mbyi: ―Reta zha, ner ndaa zha xit ub kuu mas wen, ne or lee re zha kuu mrez zha yaad lo ani ngwiiʼa zha naroobe, tsaraa ndaa zha xit ub kuu rax. Per lee lu mlotsowa xit ub kuu wen par kiida bluz. ");
INSERT INTO zaoNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Koree mtsow Jesús yez Caná kuu nzi yezlyu Galilea, ne koree nak thib re kuu thoz, kuu ner mtsow Jesús, tenzhee mloo Jesús yalnabee chaan Jesús, tsa lee re zha kuu ngeteed lo Jesús ngwalaaz zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Leettsa ngwalo mriid koree, tsa ngwa Jesús yez Capernaúm kon xnaa Jesús, kon re wets Jesús ne kon re zha kuu ngeteed lo Jesús, ne mlet re zha tya chop tsonta wiz. ");
INSERT INTO zaoNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ne tsya ndetsin gaxa ani Paskw chaan re zha Israel, tsa ngwa Jesús yez Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ne mndaab Jesús roo gwodoo naro Jerusalén, ne mwii Jesús re zha kuu ntho ngon, re zha kuu ntho mbak zhiil, re zha kuu ntho palom, ne re zha kuu ndob ntsiil temi lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ne or mwii Jesús re zha, tsa mzhen Jesús chop tson doo bzhizh ne mdexkwaa Jesús thib bins, ne kon binsa mloo Jesús re zha lee gwodoo kon re mbak zhiil zha ne kon re ngon zha. Ne mchaats Jesús re temi re zha kuu ntsiil temi, ne mlobi Jesús re mes chaan re zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ne nzhab Jesús lo re zha kuu ntho palom: ―¡Nalorka bloo goo re maa goo nzhee! ¡Tsowt goo xbi leen liz Xutʼn Diox! ");
INSERT INTO zaoNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tsa lee re zha kuu ngeteed lo Jesús mtelaaz xkiiz Diox ta nzhab: “Nkezhyan na por re kuu ntsow zha leen liza”. Sal. 69:9 ");
INSERT INTO zaoNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tsa lee re zha Israel mnaabdiz lo Jesús ne nzhab: ―¿Kwan thib kuu looʼa lo nee, tsa ne nee leeʼa mtsow re koree kon yalnabee chaan Diox? ");
INSERT INTO zaoNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús mkab lo re zha ne nzhab: ―Bluux goo gwodoo ree, ne lee na tsonka wiz taa nay tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tsa lee re zha Israel nzhab lo Jesús: ―Chop galbxoop liin mta zha gwodoo naro ree, ¿ne lee lu tsonka wiz taa luy? ");
INSERT INTO zaoNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Per gwodoo kuu mteth Jesús lo re zha nak kwerp Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kona leettsa mroban Jesús xid re zha nguth, tsa lee re zha kuu ngeteed lo Jesús mtelaaz kuu nzhab Jesús, ne ngwalaaz zha re kuu nzhab lo xkiiz Diox ne re kuu nzhab Jesús, nak kuu wli. ");
INSERT INTO zaoNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Leettsa bee ndo Jesús lo ani Paskw yez Jerusalén, kwaro zha ngwalaaz Jesús, tak mwii zha mtsow Jesús re kuu thoz lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Per nyelaazt Jesús kuu mbez re men, tak nlebee Jesús reta men. ");
INSERT INTO zaoNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ne ndechet Jesús naa cho taa kwent lo Jesús naa xa nak re men, tak lee Jesús nlebee leettsoo reta men. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ngoo thib mbyi kuu le Nicodemo kuu nak fariseo, ne lee mbyiʼa nak thib zha kuu nataak lo re zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Thib btsi ngwa zha lo Jesús ne nzhab zha: ―Maestr, nee ne lee Diox mtaala lo nee, tak yent cho tak tsow re milagr thoz kuu ntsowa, os lee Diox ndot kon lee zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tsa nzhab Jesús lo zha: ―Wlipaa na nin loʼa, loka cho galt tedib welt, gagt tab zha ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tsa mnaabdiz Nicodemo, ne nzhab zha: ―¿Xomod tak gal men tedib welt leettsa ngozha men? ¿Chu tak tab men leettsoo xnaa men ne gal men tedib welt? ");
INSERT INTO zaoNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Lee Jesús nzhab lo zha: ―Wlipaa na nin loʼa, os galt zha leen nit ne kayaat zha Mbi Nayon chaan Diox, gagt tab zha ta nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Lee zha kuu nzhal lo men, men nak zha, ne lee zha kuu nkayaa Mbi Nayon leen leettsoo zha, taxal Mbi Nayon nak zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Tsegeyt leettsooʼa tak nin loʼa: “Ndoblo gala tedib welt.” ");
INSERT INTO zaoNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Lee mbi nzhax mbi loka pa nlaaz mbi, ne tegal nzhona nzhaxe, per neta naa pa ndyaade ne neeka neta naa pa nday. Tbaa nak re zha kuu nkayaa Mbi Nayon chaan Diox leettsoo. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Lee Nicodemo mre mnaabdiz lo Jesús ne nzhab: ―¿Xomod tak gak re koree? ");
INSERT INTO zaoNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tsa nzhab Jesús lo Nicodemo: ―¿Lu nak maestr lo re zha Israel, ne xomod nyenta koree? ");
INSERT INTO zaoNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Wlipaa na nin loʼa, nee ndediz nee kuu ne nee, ne ndaa nee kwent kuu mwii nee, per lee re goo nyelaazt goo re kuu nii nee. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ne os lee goo nyelaazt goo re kuu yezlyu ree kuu ndan kwent lo goo, ¿xomod yelaaz goo os kuu yibaa tan kwent lo goo? ");
INSERT INTO zaoNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Neeka thib men ter ya yibaa, sinke beeta zha kuu mroo yibaa ne mla lo yezlyu ree, ne lee zha kuu ntethʼn loʼa nak na, Kuu Mzin Ngok Men. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ne leeka taxalka mkee Moisés mbeel lo ya yubiz, tataka kee zha na, Kuu Mzin Ngok Men lo ya, ");
INSERT INTO zaoNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tsa reta zha kuu yelaazʼn, tsow zha gan yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ne tak kwathoz mke leettsoo Diox reta men kuu nzi lo yezlyu ree, kona mtaal Diox thibka Xgann Diox kuu nkeno Diox myaad lo yezlyu ree, ne lee zha kuu yelaaz Xgann Diox, gatht zha, sinke keno zha yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tak mtaalt Diox Xgann Diox lo yezlyu ree, par naab Diox kwent lo re men ne par teti Diox re men, sinke mtaal Diox Xgann Diox, tsa por Xgann Diox tsow re men gan yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ne lee zha kuu yelaaz Xgann Diox, naabt Diox kwent lo zhaʼa, per lee re zha kuu yelaazt Xgann Diox wlipaa mnaaba Diox kwent lo zhaʼa, tak ngwalaazt zha Xgann Diox kuu thibka lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ne re zha kuu yelaazt Xgann Diox, mnaaba Diox kwent lo re zhaʼa, tak leettsa myaad zha kuu nak xni lo yezlyu ree, mas myow leettsoo re men yalkow nake xni, tak pur kuu went ntsow zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Reta zha kuu ntsow kuu went, nayii zha ne zha zha kuu nak xni, ne mbigt zha lo xni, tsa loot re kuu went kuu ntsow zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Per lee re zha kuu ndeke dits kuu wli, mbig zha lo xni, tsa loo lee re kuu ntsow zha nak kuu nlaaz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Bluz leettsa ngwalo nzhab Jesús koree, tsa mroo Jesús kon re zha kuu ngeteed lo Jesús yez Jerusalén, ne ngwa Jesús yezlyu Judea, tya mlet re zha chop tson wiz, ne mtsowleyy zha re men. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ne noga Juan ngetsowleyy re men xlen, kuu le Enón, gaxta thib ta le Salim, tak tya nzo naroob nit ne lee re men nya lo Juan, ne ntsowleyy Juan re zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Re koree ngok, leettsa ter ko zha Juan tsib. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Per lee chop tson zha kuu ngeteed lo Juan mndelo mbyodiz kon thib zha Israel, kwent chaan xomod gak nambi men lo Diox, ");
INSERT INTO zaoNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","tsa myaad zha mnaabdiz zha lo Juan ne nzhab zha: ―Maestr, lee zha kuu mndo rop goo roo yoo Jordán, zha kuu mndaaʼa kwent lo nee, nal lee zha ngetsowleyy re men, ne reta men nya lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tsa lee Juan nzhab lo re zha: ―Neeka thib zha gagt kayaa thib kwaa os lee Diox taate lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","At mbin goo kwathoz nambi mnin, nagtʼn Crist Kuu Mtaal Diox Nabee, lee na nak beeta thib zha kuu mtaal Diox ndener lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Tak lee lo thib fandan, lee mbyi kuu nden yaa nzaa, nak kuu tseya kon nzaa, ne lee amig mbyi kuu tseyaʼa ndo tya, ne nzhon amig mbyi kwan ndediz rop zha kuu tseyaʼa, ne naley nzo leettsoo amig mbyi nzhon amig mbyi ndediz rop zha kuu tseyaʼa. Kona leeka tata kwathoz naley nzo leettsoon. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tak lee zha ndoblo gak zha masraa nataak, ne lee na ndoblo gakʼn zha kuu nataagt raa. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Lee zha kuu mroo yibaa nabee zha lo reta men ne lo reta kwaa. Lee zha yezlyu ree, zha yezlyu ree nak zha, ne pur kuu yezlyu ree ndediz zha. Per lee zha kuu mroo yibaa, zhaʼa nak zha kuu nabee lo reta men ne lo reta kwaa, ");
INSERT INTO zaoNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ne ndediz zha kuu mwii zha ne kuu mbin zha, per neeka thib zha nyelaazt kuu ni zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Per lee zha kuu nyelaaz kuu ni zha, zhaʼa nloo lee Diox nali nak. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tak lee zha kuu mtaal Diox taa kwent chaan Diox, ndaa zha kwent chaan Diox ne ndaa Diox Mbi Nayon lo zha, ne ngwiit Diox ploy ndaa Diox lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nke leettsoo Xut zha zha, ne mndaa Xut zha yalnabee lo Zha, tsa nabee zha reta kuu nzo lo yezlyu ree ne lobee. ");
INSERT INTO zaoNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ne loka zha kuu yelaaz Xgann Diox, tetsow zhaʼa gan yalnaban kuu thitanax, per lee zha kuu yelaazt Xgann Diox, tsowt zhaʼa gan yalnaban, sinke lee yalnayii chaan Diox la dits zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Tsa mbin re fariseo lee dits Jesús ndeke masraa zha nake dits Juan, ne masraa zha nda ntsowleyy Jesús nake Juan. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Per tegal leet Jesús ntsowleyy re men, sinke re zha kuu ngeteed lo Jesús ntsowleyy re men. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ne leettsa myeen Jesús kona, tsa mroo Jesús yezlyu Judea ne nda Jesús yezlyu Galilea tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Per or nda Jesús, ndoblo rid Jesús yezlyu Samaria. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tsa mzin Jesús thib yez chaan Samaria kuu le Sicar, ne gax tya nax thib le yu kuu mndaa Kob lo Che xgann Kob. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ne tya ndob pos kuu ni re zha pos Kob. Ne tak ngokwan Jesús ndo Jesús net, tsa mneyy Jesús thib lad roo pos. Kona ngok teeka ndrol wiz. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ne lee re zha kuu ngeteed lo Jesús, mlaa zha Jesús, ne nda re zha yez ndati zha kuu wu zha. Ne ora lee thib ngot kuu nak zha yez Samaria ngwaxii nit roo pos, tsa nzhab Jesús lo ngot: ―Taa lut nit gun. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Per lee re zha Israel nzaalt leettsoo kon re zha Samaria, kona lee ngota mkab, ne nzhab lo Jesús: ―¿Chebee lon naaba nit, si zha Samaria nakʼn ne lee lu nak zha Israel? ");
INSERT INTO zaoNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Lee Jesús mkab lo ngot ne nzhab: ―Os leeʼa nlebeeʼa kuu nataak kuu ndelaaz Diox, ne os neʼa naa cho nak zha kuu ngenaab nit loʼa, ne os lu naaba nit lo zha, lee zha taa nit kuu ndaa yalnaban guʼa. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Tsa lee ngot nzhab lo Jesús: ―Zha Nabee, per neeka thib kuu ndenta par kooʼa nit, ne lee pos kwathoz naats, ¿ne pa nkenoʼa nit kuu ndaa yalnaban kuu taaʼa gun? ");
INSERT INTO zaoNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Naa ¿chu masraa nataaka nake tey nee Kob? Lee zha mlaa pos ree lo nee, ne lee zha, re zhiinn zha ne re maa zha ngwii nit pos ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ora mkab Jesús ne nzhab Jesús lo ngot: ―Reta zha kuu nzhuu nit pos ree, tebre tob xyeek leettsoo zha, ");
INSERT INTO zaoNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","per lee zha kuu gu nit kuu tan, thitanax bret raa zha tob xyeek leettsoo zha, tak lee nit kuu tan gu zha, leettsoo zha gake taxal thib xlen nit, kuu ndaa yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tsa lee ngot nzhab lo Jesús: ―Zha Nabee, taa nita gun, tsa tob xyeegt raa leettsoon, ne tsa yalt raa na yaadlon nit nzhee. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ora nzhab Jesús lo ngot: ―Gwa gwaxii tsaala, tsaraa yaada nzhee. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Lee ngot mkab ne nzhab: ―Naptʼn tsaalʼn. Tsa nzhab Jesús lo ngot: ―Wliʼa kuu neʼa, napta tsaala, ");
INSERT INTO zaoNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","tak mkenoʼa lu gaay tsaala, ne lee zha kuu napa nal, nagt zha tsaala, wliʼa kuu neʼa. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Or mbin ngot kona, tsa nzhab ngot: ―Ndakʼn thib profet naka. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Lee re tey nee zha ndala mbil zha lo Diox yek yii ree, per lee re goo zha Israel mbez goo, yez Jerusalén nak ta ndoblo golaa lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Tsa lee Jesús nzhab lo ngot: ―Wlipaa na nin loʼa, too wiz kuu ndechet raa yaad goo yek yii ree, neeka Jerusalén, par gol goo lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Lee re goo net goo cho lo nzhool goo, per lee re nee ne nee cho lo nzhool nee, tak lo re zha Israel ndyaad yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Per mzina or, ne nal nak or kuu lee re zha kuu wlipaa nzhool lo Diox, gol zha lo Diox taxal nlaaz Mbi Nayon chaan Diox. Tak tata nlaaz Diox gol re men lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Diox nak mbi, ne lee re zha kuu wlipaa nzhool lo Diox, taxal nlaaz Mbi Nayon, ndoblo gol zha lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tsa nzhab ngot lo Jesús: ―Nen tyaad Zha Kuu taal Diox Nabee (kuu nak Crist), ne leettsa yaad zha, tsa ne zha naa xomod nak reta kwaa lo nee. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús nzhab lo ngot: ―¡Na nak zhaʼa, kuu ngetediz loʼa! ");
INSERT INTO zaoNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ne ora mzin re zha kuu ngeteed lo Jesús, ne kwathoz mzegey leettsoo re zha, tak mwii zha lee Jesús ngetediz kon thib ngot, per neeka thib zha myet leettsoo ganaabdiz, kwan nlaaz ngot o cho kwent ngetediz Jesús kon ngot. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tsa lee ngota mlaa ree, ne ngwane ngot lo re men yez, nzhab ngot: ");
INSERT INTO zaoNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Ndaa goo, tsa wii goo thib mbyi, kuu mne lon reta kuu mtsowʼn. ¿Naa chu nagt zha Crist Kuu Mtaal Diox Nabee? ");
INSERT INTO zaoNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tsa mroo re zha ne ngwa zha ta ndo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ne lee re zha kuu ngeteed lo Jesús, nzhab lo Jesús: ―Maestr, dow lut kwaa. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Per lee Jesús nzhab lo re zha: ―Napʼn thib kwaa wun, per net goo kwane. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tsa lee re zha kuu ngeteed lo Jesús mndelo zha mnaabdiz zha lo altaa zha, ne nzhab zha: ―¿Chu nzo cho myaadtaan kuu ndow zha? ");
INSERT INTO zaoNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Per lee Jesús nzhab lo re zha: ―Lee kuu nzhowʼn nak, ntsowʼn kuu nlaaz zha kuu mtaalʼn, ne kona nak taxal kuu nzhowʼn, ne wlipaa teyelo tsow nay. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Lee re goo mbez: “Bee nzhak falt thap mbee par thop zha yalgonn”, per lee na ni lo re goo, wii goo, ngoka yalgonn ne mzina wiz thop zhay. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Lee zha kuu nke tsiin par thop yalgonn, nzhax lo zha, ne lee yalgonn kuu nthop zha, nak kuu xek thitanax, tsa lee zha kuu mloo bin, ne zha kuu mthop yalgonn kwathoz naley nzo leettsoo rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Wli kuu nzhab diiz: “Thib zha ngo bin lo yu ne lee tedib zha nthop yalgonn”. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Na mtaal goo thop goo yalgonn kuu ngonnt goo, tedib net zha nak zha kuu ngonne ne mtembiy, per lee re goo thope ne kayaay. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Kwathoz zha yez Sicar kuu nzi yezlyu Samaria ngwalaaz Jesús, tak lee ngota nzhab lo re zha: “Mne zha reta kuu mtsowʼn”. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ne or lee re zha yez Samaria mzin, tsa nzhab zha lo Jesús, kwet Jesús lo re zha. Tsa mlet Jesús lo re zha chop wiz, ");
INSERT INTO zaoNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ne naroob raa zha ngwalaaz Jesús por re kuu nzhab Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ne nzhab re zha lo ngot: ―Nagt beeta por kuu neʼa lo nee, tsa nyelaaz nee Jesús, sinke mbina nee kuu ne Jesús, ne kona ne nee wlipaa lee Jesús nak zha kuu ntelaa re men lo yalguth ne ndaa yalnaban lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Leettsa ndaʼa chop wiz, tsa lee Jesús mroo ndya par yezlyu Galilea. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ne leeka Jesús nzhab lo re men, nzhont re men diiz lo thib zha kuu nak profet, leettsa tawlazka zha nak Profet. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Per leettsa mzin Jesús Galilea, wen mkayaa re zha Jesús tya, tak ngwa re zha lo ani Paskw yez Jerusalén, ne mwii zha re kuu mtsow Jesús tya. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesús mre ngwa yez Caná kuu nzi yezlyu Galilea, ta mtsow Jesús mreyal nit xit ub. Ne tya mzaal Jesús thib zha kuu nataak kuu nke tsiin lo rey, ne lee xgann zhaʼa ne ndak nzo yez Capernaúm. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Or lee zha kuu nataak lo rey mbin lee Jesús mzin yezlyu Galilea, tsa ngwa zha lo Jesús ne mnaab zha lo Jesús, ya Jesús liz zha, yategwe Jesús xgann zha kuu mer gath. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tsa nzhab Jesús lo zha: ―Os leen tsowtʼn thib re milagr thoz lo goo, yelaazt goo na. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Per lee zhaʼa nzhab lo Jesús: ―Zha Nabee, lijer ndaa tak cha gath xgann na. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Tsa lee Jesús nzhab lo zha: ―Tyee liza, ¡mgweʼa xganna, naban xganna! Tsa lee zhaʼa ngwalaaz kuu nzhab Jesús ne ndya zha liz zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ne or ndo zha net ndya zha liz zha, lee re mos zha ngwaxii net zha, ne nzhab lo zha: ―¡Mgweʼa xganna! ");
INSERT INTO zaoNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tsa mnaabdiz zha lo re mos zha, polor mndelo ngoo wen leettsoo xgann zha, tsa lee re mos mkab ne nzhab: ―Naaʼa a la una mroo xlee xganna. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tsa lee xut ndeʼa mtelaaz, leeka ora nzhab Jesús lo zha “naban xganna”. Tsa re lizta zhaʼa ngwalaaz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ne koree ngok mrop milagr kuu mtsow Jesús, leettsa mroo Jesús Judea ne ndyaad Jesús par Galilea. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Bluz leettsa ngwalo mriid koree, lee re zha Israel mtsow thib ani, tsa lee Jesús ngwa Jerusalén tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ne leen yez Jerusalén, gax roo pwert kuu ni zha chaan re mbak zhiil, tya ndob thib tank kuu diiz hebreo le Betesda, kuu nap gaay korredor, ");
INSERT INTO zaoNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ne roo re korredora nzi thiban zha syeg, zha mthans ne zha kuu gagt gwin. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tya nzi re zha ngebet zha, or lee mandad chaan Diox kwin nit leen tank, ne loka zha kuu ner tab leen tank, ngwe zha lo yiz kuu ndak zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ne xid re zhaʼa nzo thib zha mthans kuu ndaʼa galbtsiibxon liin ne ndak. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ne or mwii Jesús lee zha nax tya, ne ne Jesús ndaʼa tyen liin tata ndak zha, tsa mnaabdiz Jesús lo zha, ne nzhab Jesús: ―¿Chu nlaaza weʼa? ");
INSERT INTO zaoNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Lee mbyiza mkab ne nzhab: ―Zha Nabee, naptʼn cho kon leen tank or lee nit gwin. Ne kadta leettsa nlazʼn taabʼn leel ner tedib zha ndaab. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Tsa lee Jesús nzhab lo zha: ―Gwache, bthuz daʼa ne bte. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ne oraaka lee zha mgwe, ne mthuz zha da zha ne mndelo zha mnde zha. Ne kona ngok thib wiz sabd. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Tsa lee re zha Israel nzhab lo zha kuu mgweʼa: ―Naltseree nak wiz sabd kuu ndroxkwanaa, ndoblot gweʼa daʼa. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tsa lee mbyiʼa mkab ne nzhab: ―Zha kuu mtegwen ne lon: “Bzhen daʼa ne bte”. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tsa lee re zhaʼa mnaabdiz lo mbyiʼa ne nzhab: ―¿Cho ne loʼa: “Bzhen daʼa ne bte”? ");
INSERT INTO zaoNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Per lee mbyiʼa net mbyi naa cho mtegwe mbyi, tak lee Jesús mnith xid re men kuu nzi tya. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tut bluz mzaal Jesús mbyiʼa roo gwodoo, tsa nzhab Jesús lo mbyi: ―Wii mgweʼa lu, tsowt raa lu kuu went, tsa ridta tedib yalti kuu mas nathoz nake kuu mriida. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Lee mbyiʼa ndya ne nzhab lo re zha Israel: “Jesús nak zha kuu mtegwen”. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ne tak mtsow Jesús kona wiz kuu ndroxkwan re zha Israel, kona mreke re zha Israel dits Jesús ne nlaaz zha kuth zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Per lee Jesús nzhab lo re zha: ―Lee Xutʼn thibka nke tsiin, ne noga na tataga nkeen tsiin. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ne kona lee re zha Israel masraa nlaaz zha kuth zha Jesús, ne nagte tak beeta nke Jesús tsiin wiz sabd, sinke tak noga nzhab Jesús lee Diox nak Xut Jesús, ne tata mod ntsow Jesús leeka lee Jesús taxal Diox ley lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tsa nzhab Jesús lo re zha: ―Wlipaa na nin, na nak Xgann Diox ne neeka thib kuu ntsowtʼn tak nlazʼn tsow nay, beeta ntsowʼn re kuu ngwiin ntsow Xutʼn. Ne reta kuu ntsow Xutʼn ntsowga nay. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ne tak nke leettsoo Xutʼn na nloo Xutʼn reta kuu ntsow Xutʼn lon, ne nalraa loo Xutʼn masraa kuu thoz lon, re kuu kwathoz tsegey leettsoo goo wii goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ne leeka taxal nteroban Xutʼn re zha nguth, ne ntsow Xutʼn mban zha tedib welt, leeka tabaa ndan yalnaban lo zha kuu nlazʼn ta nay. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ne nagt Xutʼn kuu naab kwent lo re men, sinke mndaa Xutʼn yalnabee lon tsa naabʼn kwent lo re men, ");
INSERT INTO zaoNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","tsa reta zha gon diiz lon taxal nzhon zha diiz lo Xutʼn; tak lee zha kuu nataagtʼn lo, noga Xutʼn kuu mtaalʼn nataagt lo zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Wlipaa na nin lo goo, loka zha kuu nkenza xkizʼn kuu nin lo goo, ne yelaaz zha lee Diox mtaalʼn, tetsow zhaʼa gan yalnaban kuu thitanax, ne naabt Diox kwent lo zhaʼa wiz bluz, tak mrooʼa zhaʼa xid re zha nguth ne nkenoʼa zha yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Wlipaa na nin lo goo, mzin gaxa wiz, ne nal nak or kuu lee re zha nguth gon bos da, ne loka zha kuu gon bos da taban zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ne leeka taxal nap Xutʼn yalnaban por leeka lee Xutʼn, leeka tata mndaa Xutʼn yalnabee lon par napʼn yalnaban, ");
INSERT INTO zaoNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ne noga mndaa Diox yalnabee lo na, Kuu Mzin Ngok Men, tsa naabʼn kwent lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tsegeyt leettsoo goo por ree kuu nin lo goo, tak tetsin wiz kuu lee reta zha nguth gon bos da, ");
INSERT INTO zaoNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","tsa roo re zha leen baa. Ne lee re zha kuu mtsow kuu wen, roban zha par kayaa zha yalnaban, per lee re zha kuu mtsow kuu went, roban zha beeta par kayaa zha yalti kuu thitanax lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Gagt tsowʼn neeka thib kuu por leeka na. Naabʼn kwent taxal nabee Xutʼn lon, ne nali naabʼn kwent lo re men, tak ntsowtʼn kuu nlazʼn, sinke ntsowʼn kuu nlaaz zha kuu mtaalʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Os leen ndan kwent chaanka na, wlit kuu ndan kwent. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Per nzo thib zha kuu ndaa kwent chaan da, ne nen wli kuu ni zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Re goo mtaal zha kuu ngwa mnaabdiz lo Juan, ne wli kuu mkab Juan lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ne ndechetʼn neeka thib zha kuu taa kwent chaan da, per nin koree lo goo, tsa ne goo tak laa goo lo yalguth ne tsow goo gan yalnaban. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan nak taxal thib xni kuu mke ne mteni lo goo, ne lo xni chaan Juan ngwalaaz goo gayoo naley leettsoo goo lut. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Per lee na, napʼn thib zha kuu taa kwent chaan da mas nali, nake kuu mndaa Juan kwent. Re kuu ntsowʼn leey nak re kuu mnabee Xutʼn lon tsowʼn, ne leey nloo lee Xutʼn mtaalʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ne noga Xutʼn kuu mtaalʼn nzo fabor da, ne neeka ter gon goo bos chaan Xutʼn, ne neeka ter wii goo Xutʼn, ");
INSERT INTO zaoNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ne neeka yent xkiiz Xutʼn leettsoo goo, tak nyelaazt goo lee Xutʼn mtaalʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kwathoz nteed goo xkiiz Diox, tak ndak goo loy yetsal goo yalnaban kuu thitanax, per nyent goo lee xkeets Diox ndaa kwent naa cho nakʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Per lee re goo nlaazt goo yaad goo lon, tsa keno goo yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Nkwaantʼn tsa tsow nataak re men na. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Per nlebeen re goo, ne nen napt goo yalnkelaaz chaan Diox leettsoo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na ndyalʼn kwent chaan Xutʼn, per lee re goo nkayaat goo na, ne os tedib zha yaad por kwent chaanka zha, zhaʼa si tekayaa goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Xomod yelaaz goo na, os beeta nkwaan goo par tsow nataak re men goo, ne nkwaant goo par tsow nataak Diox goo? ");
INSERT INTO zaoNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Tsowt goo xgab lee na keki goo lo Xutʼn, lee zha kuu nkeki goo nak Moisés kuu mndaa ley kuu nyelaaz goo, ne ndak goo por leey tsow goo gan yalnaban. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Os wli nyelaaz goo kuu mkee Moisés, noga ndoblo yelaaz goo na, tak kwent chaan da mndaa Moisés lo re yeets kuu mkee Moisés. ");
INSERT INTO zaoNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Per os nyelaazt goo kuu mkee Moisés, ¿xomod yelaaz goo kuu nin lo goo? ");
INSERT INTO zaoNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ne leettsa ngwalo mriid re koree, tsa ngwa Jesús tedib lad roo nitdoo Galilea, kuu le Tiberias. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ne naroob men mndeke dits Jesús, tak mwii zha re milagr thoz kuu mtsow Jesús lo re men kuu ne ndak. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tsa lee Jesús kon re zha kuu ngeteed lo Jesús, mkendab re zha yek thib yii ne tya mndob re zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ne ndetsin gaxa ani Paskw chaan re zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Or mtsere lo Jesús mwii Jesús lo re men kuu ndeke dits Jesús, tsa nzhab Jesús lo Lip: ―¿Pa yatiʼaa kuu wu re men ree? ");
INSERT INTO zaoNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tenzhec mnaabdiz Jesús, tsa naa kwan gab Lip, tak neʼa Jesús naa kwan tsow Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tsa lee Lip mkab lo Jesús ne nzhab: ―Neeka chop gayoo denario pan, gaate par wu re men lutgay. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tsa lee Ndres thib re zha kuu ngeteed lo Jesús kuu nak wets Simún Pey, nzhab: ");
INSERT INTO zaoNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Nzhee ndo thib nde lut kuu nap gaay pan cebad ne chop mbel; per pa ga koree wu naroob men. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tsa nzhab Jesús: ―Guz goo lo re men tsa tob men. Ne kwaro ndab yizhwan tya, tsa mndob re men ne beeta re mbyi nak teeka gaay mil zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tsa mzhen Jesús re pan, ne mndaa Jesús texkix lo Diox, ne mdid re zhay lo re men. Ne tataka mtsow Jesús kon rop mbel, ne mdow re zha asta plotha mze leettsoo zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Or ngwalo ndow re zha, tsa nzhab Jesús lo re zha kuu ngeteed lo Jesús: ―Bthop goo re kuu mrozhoob, tsa yetsaate. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tsa mthop re zhay, ne mtse zha tsiibchop chekwit ngoo re kuu byu kuu mrozhoob lo re gaay pan. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Or mwii re men re milagr kuu mtsow Jesús, tsa nzhab re zha: ―Wlipaa lee zha ree nak profet kuu ne Diox yaad lo yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Per myeen Jesús lee re men ngwalaaz to Jesús, tsa gak Jesús rey lo re zha, kona tee mbeche Jesús lo re zha, ne ngwa thita Jesús yek yii tedib welt, tak nlaaz Jesús to thita Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Or ngoo yaal, lee re zha kuu ngeteed lo Jesús ndala roo nitdoo, ");
INSERT INTO zaoNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ne mke re zha leen thib kano par rid zha tedib lad nitdoo, par tsin zha yez Capernaúm. Ne ngooʼa yaal lee Jesús terka tsin lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ne lee thib mbi thoz mroo mndelo mkwin nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ne or ndaʼa re zha teeka thib gaay mil o xoop mil metr lo nitdoo, tsa mwii re zha lee Jesús ndetsin lo re zha ndyaad nde lo nitdoo, tsa kwathoz mzeb re zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ora nzhab Jesús lo re zha: ―¡Tsebt goo nay! ");
INSERT INTO zaoNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ne mlaa re zha mke Jesús leen kano, per oraaka mzin re zha yezlyu ta nda zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ne tedib wiza, lee re men kuu myaan tedib lad roo nitdoo, myeen re men lee re zha kuu ngeteed lo Jesús ndya leen thibka kano kuu mndob tya, ne myeen re men ndat Jesús kon re zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tsa lee tedib net kano mzin gax ta ndow re zha pan, ta mndaa Jesús texkix lo Diox, re kanoʼa nak kano chaan re zha yez Tiberias. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Or mwii re men neeka Jesús ne neeka re zha kuu ngeteed lo Jesús yenta tya, tsa mke re zha leen kano ne ndya zha par Capernaúm nda kwaan zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Or mzin re men tedib lad roo nitdoo, ne tya mzal Jesús lo re zha, tsa mnaabdiz zha lo Jesús nzhab zha: ―Maestr, ¿pol mzina nzhee? ");
INSERT INTO zaoNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tsa nzhab Jesús lo re zha: ―Wlipaa na nin lo goo, ngekwaant goo na tak myen goo re kuu thoz kuu mtsowʼn, sinke nkwaan goo na, tak ndow goo asta plo mze leettsoo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ket goo tsiin par kwaan goo kuu wu goo kuu nlux, sinke bkwaan goo kuu ndaa yalnaban kuu thitanax, ne na Kuu Mzin Ngok Men, ta yalnaban kuu thitanax lo goo, tak lee Diox kuu nak Xutʼn mtob seny chaane na, tsa ne re men lee na nak Xgann Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tsa mnaabdiz re zha lo Jesús, nzhab zha: ―¿Kwan ndoblo tsow nee, tsa tak tsow nee reta kuu nabee Diox tsow nee? ");
INSERT INTO zaoNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ora mkab Jesús ne nzhab Jesús: ―Kuu nlaaz Diox nak, yelaaz goo zha kuu mtaal Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tsa mnaabdiz re zha lo Jesús ne nzhab zha: ―¿Cho thib re milagr tak looʼa lo nee, tsa yelaaz nee lu? ¿Kwan kuu tak tsowa? ");
INSERT INTO zaoNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Lee re teyaa zha ndala ndow zha pan kuu le maná yubiz, taxal nzhab lo xkiiz Diox: “Pan yibaa mndaa Diox ndow re zha”. Sal. 78:24 ");
INSERT INTO zaoNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tsa mkab Jesús ne nzhab Jesús: ―Wlipaa na nin, nagt Moisés kuu mndaa pan kuu mroo yibaa ndow goo, sinke Xutʼn nak kuu ndaa pan kuu wlipaa mroo yibaa lo re goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tak lee pan kuu wlipaa ndaa Diox, nak zha kuu mroo yibaa, ne ndaa yalnaban lo re men yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tsa lee re zha mnaab lo Jesús ne nzhab zha: ―Zha Nabee, thibka btaa pana wu nee. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús mkab ne nzhab lo re zha: ―Na nak pan kuu ndaa yalnaban. Ne lee zha kuu yaad lon thitanax laant raa zha, ne lee zha kuu yelaaz na thitanax naa tob xyeekt raa leettsoo zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Per niʼa na lo goo, nyelaazt goo na tegal ngwii goo na. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Reta zha kuu mndaa Xutʼn lon, ndyaad zha lon, ne reta zha kuu ndyaad lon, tezhonntʼn zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Yibaa mroon ne ndyaltʼn par tsowʼn kuu nlazʼn, sinke ndyalʼn tsowʼn kuu nlaaz Xutʼn kuu mtaalʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ne lee kuu nlaaz Xutʼn kuu mtaalʼn nak, lee reta zha kuu mndaa Xutʼn lon, latʼn lux neeka thib re zha, sinke teroban na zha wiz bluz. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tak kuu nlaaz Xutʼn nak, lee reta zha kuu yelaaz xgann Xutʼn, keno zha yalnaban kuu thitanax ne lee na teroban zha wiz bluz. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tsa mndelo re zha Israel mbyodiz, tak lee Jesús nzhab: “Na nak taxal pan kuu mroo yibaa”. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ne lee re men nzhab: ―¿Chu leet zha ree nak Jesús xgann Che? Nlebeeʼaa xut zha ne xnaa zha. Ne ¿chebee mbez zha yibaa mroo zha? ");
INSERT INTO zaoNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tsa lee Jesús mkab ne nzhab lo re zha: ―Tow roo goo yodizt raa goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Neeka thib zha yaadt lon, os lee Xutʼn kuu mtaalʼn yaadnot zha lon, tsa lee na teroban zha wiz bluz. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ne lo yeets kuu mkee re profet mbez: “Diox teteed reta men”. Kona lee reta zha kuu nzhon diiz lo Xutʼn ne nteed lo Xutʼn, ndyaad zha lon. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Ne yent neeka thib zha kuu mwii lo Xutʼn Diox, sinke beeta zha kuu mroo lo Diox mwii lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Wlipaa na nin, lee zha kuu nyelaaz na napa zhaʼa yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Na nak taxal pan kuu ndaa yalnabana. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Lee re teyaa zha ndala ndow zha maná yubiz, ne nguth re zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Per lee na ngetan kwent chaan pan kuu mroo yibaa lo goo, ne loka zha kuu wuy taban zha thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Na nak pan kuu naban kuu mroo yibaa, ne loka zha kuu wu pan ree taban zha thitanax. Lee pan kuu tan nak kwerp da, ne ta nay por reta men yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tsa lee re zha Israel mndelo mbyodiz, ne nzhab: ―¿Xomod taa mbyi ree leeka beel mbyi ree wu men? ");
INSERT INTO zaoNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tsa nzhab Jesús lo re zha: ―Na Kuu Mzin Ngok Men. Wlipaa na nin lo goo, os lee goo wut goo beel da, ne gut goo ren da kenot goo yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Loka zha kuu wu beel da ne gu ren da, tekeno zha yalnaban kuu thitanax, ne lee na teroban zha wiz bluz. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tak lee beel da wlipaa nak loww zha, ne lee ren da wlipaa nak kuu nzhuu zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ne lee zha kuu nzhow beel da ne nzhuu ren da, thibka nak nee rop nee zhaʼa ne thibka ndon kon lee zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Lee Xutʼn kuu mtaalʼn nkeno yalnaban, ne lee na naban na por Xutʼn; ne tataka lee zha kuu wu beel da taban zha por na. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kwent chaan pan kuu mroo yibaa ngetan. Lee pan ree nagt taxal maná kuu ndow re teyaa zha ndala, tegal ndow zhay per nguth zha, per lee zha kuu wu pan kuu tan taban zha thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Re koree nzhab Jesús lo re men yez Capernaúm, or mloo Jesús xkiiz Diox lo re men ta nkaltaa zha nteed zha xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Or mbin re men re kuu mloo Jesús, tyen re zha kuu ngeteed lo Jesús nzhab: ―Kwathoz nagan yenaa kuu ni zha; ¿cho tak gon diiz xkiiz zha? ");
INSERT INTO zaoNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ne myeen Jesús kwan ngetediz re zha, tsa nzhab Jesús: ―Cho koree ntsow went nzo leettsoo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Kwan tsow goo xgab, os wii goo lee na, Kuu Mzin Ngok Men, ndyan yibaa leeka ta mroon? ");
INSERT INTO zaoNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Lee Mbi Nayon nak kuu ndaa yalnaban, per lee lo kwerp yent pa lortsine. Ne lee re kuu nin lo goo nak chaan Mbi Nayon ne leey nak kuu ndaa yalnaban. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Per bee nzo thib chop goo kuu nyelaazt na. Tak desde ner neʼa Jesús, naa cho nak re zha kuu nyelaazt Jesús, ne cho taa Jesús lo re zha kuu kuth Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tsa nzhab Jesús: ―Kona nin lo goo, neeka thib zha gagt yaad lon, os lee Xutʼn yaadnot zha lon. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kona tyen zha kuu ngeteed lo Jesús, mlaa zha Jesús ne ndya zha, ne mndiyt raa zha kon Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tsa nzhab Jesús lo re tsiibchop zha kuu ngeteed lo Jesús: ―¿Chu noga goo nlaaz goo bi goo? ");
INSERT INTO zaoNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tsa nzhab Simún Pey lo Jesús: ―Zha Nabee, ¿cho lo ya nee? Si xkiiza nak kuu ndaa yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Re nee ne leeʼa nak Zha Nali kuu mroo lo Diox, ne nyelaaz nee lu. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús mkab ne nzhab: ―Tsiibchop goo nak zha kuu mlin, per thib goo nak kuu nzhon diiz lo Maxuuy. ");
INSERT INTO zaoNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Or nzhab Jesús kona ngeteth Jesús Judas Iscariote, xgann Simún Iscariote, tak Judas nak kuu taa Jesús lo re zha kuu kuth Jesús, tegal lee Judas nak thib zha lo re tsiibchop zha kuu ngeteed lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Leettsa ngwalo mriid re koree, lee Jesús mndiy re yez yezlyu Galilea ne nlaazt Jesús ya Jesús yezlyu Judea, tak tya nlaaz re zha Israel kuth Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Per ndetsin gaxa ani kuu le Ramad, thib re ani kuu ntsow re zha Israel, ");
INSERT INTO zaoNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","tsa lee re wets Jesús nzhab lo Jesús: ―Broo nzhee, ne gwa yezlyu Judea, tsa noga re zha kuu nyelaaza kuu nzo tya, wii re kuu ntsowa. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tak leettsa lee thib zha nlaaz zha lebee re men zha, ntsowt zha re kuu xgaatsta. Ne nal os ntsowa re kuu thoz, btsowe delant lo reta men. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tak neeka re wets Jesús ngwalaazt zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tsa nzhab Jesús lo re zha: ―Ter tsin or da, per lee re goo reta or wen lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Lee re men yezlyu nayiit zha ne zha goo, per na si nayii zha ne zha na, tak nloon lee re kuu ntsow zha went nak. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gwa goo lo ani yatʼn nal, tak ter tsin or kuu yan. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ngwalo nzhab Jesús kona lo re wets Jesús, tsa myaanka Jesús yezlyu Galilea. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Leettsa lee re wets Jesús nda, noga Jesús mndeke ngwa lo ani, per xgaatsta ngwa Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tsa lee re zha Israel mkwaan Jesús lo ani, ne mbez re zha: ―¿Ma mbyiʼa? ");
INSERT INTO zaoNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ne kwathoz nteth re men Jesús. Thib net zha mbez: “Wen nak mbyiʼa”; per lee tedib net zha mbez: “Pa gak zhaʼa zha wen, lee zha nak thib zha kuu nkedi re men”. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Per neeka thib zha myet leettsoo gatediz kwent chaan Jesús lo re men, tak nzeb zha ne zha re zha Israel kuu nataak. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Per leettsa ndrola ani, tsaraa lee Jesús ngwa lee roo gwodoo, ne mndelo Jesús mloo lo re men tya. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tsa lee re zha Israel kwathoz mzegey leettsoo zha, ne nzhab zha: ―¿Chebee kwathoz nzhaak zha ree, ne ngwat zha skwel? ");
INSERT INTO zaoNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ora mkab Jesús lo re zha, ne nzhab Jesús: ―Lee leyy kuu ngeloon lo re goo nagte chaan na, leey nak chaan zha kuu mtaalʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Os lee thib zha nlaaz tsow kuu nlaaz Diox, tak lebee zha os lee leyy kuu ngeloon nake chaan Diox o chaan na. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Lee zha kuu ndaa leeka kwent chaane, ntsow zhay tsa tsow nataak re men zha, per lee zha kuu nkwaan par tsow nataak re men zha kuu mtaal zha, zhaʼa si mbez kuu wli ne nkedit zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Chu wlit lee Moisés mndaa ley lo re goo? Per neeka thib goo ntsowt kuu nzhab lo ley. ¿Tak nlaaz goo kuth goo na? ");
INSERT INTO zaoNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tsa lee re men mkab ne nzhab lo Jesús: ―¡Mbi fyer nzo leettsooʼa, nzhak naxen yeka! ¿Cho nlaaz kutha? ");
INSERT INTO zaoNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ora nzhab Jesús lo re men: ―Reta goo mzegey leettsoo goo, tak mtsowʼn thib kuu thoz wiz sabd, wiz kuu ndroxkwan reʼaa zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés mloo lo goo kee goo seny ree mbet byi, seny kuu nak seny chaan reʼaa zha Israel (tegal leet Moisés nak kuu mndelo mtsow koree, sinke re teyaa zha ndala mndeloy), ne tegal wiz sabd nal per lee re goo nkee goo seny re mbet byi goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ne os ndak goo wen kee goo seny thib mbetdoo wiz sabd, wiz kuu ndroxkwan reʼaa zha Israel, par tsow goo kuu mbez lo ley chaan Moisés, mbay ¿chebee nayii goo ne goo na, tak mtegwen thib zha wiz sabd tsa? ");
INSERT INTO zaoNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Naabt goo kwent taxal nloo re kwaa lo goo, sinke leettsa naab goo kwent, btsow goo thib mod nali. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tsa lee chop tson re zha Jerusalén nzhab: ―¿Chu leet zha ree kuu nkwaan zha par kuth zha? ");
INSERT INTO zaoNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ne nal lee zha ndo ngeni lo re men baa, ne neeka thib zha yent kwan mbez lo zha. ¿Chu noga re zha kuu nak tsiin nyelaaz lee zha nak Crist Kuu Mtaal Diox Nabee? ");
INSERT INTO zaoNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Per leeʼaa neʼaa naa cho nak zha, tak leettsa yaad Crist Kuu Taal Diox Nabee, neeka thib zha net naa pa lad roo zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ne or ngeloo Jesús lo re men lee roo gwodoo, mbin Jesús tata nzhab re zha, tsa nex nzhab Jesús lo re zha: ―¡Ndak goo nlebee goo na, ne ne goo pa mroon! Per ndyaltʼn tak nlazʼn yalʼn, sinke lee zha kuu mtaalʼn, nak thib zha kuu nali ne wli, ne lee re goo nlebeet goo zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Per na si nlebeen zha, tak lo zha mroon ne lee zha mtaalʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tsa ngwalaaz re zha gaten zha Jesús, per neeka thib zha mzhent Jesús, tak ter tsin or kuu ten zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kwaro zha ngwalaaz Jesús ne mbez zha: ―Leettsa yaad Crist Kuu Taal Diox Nabee, ¿chu tetsow zha masraa kuu thoz nake zha ree? ");
INSERT INTO zaoNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tsa lee re fariseo mbin kuu nzhab re men kwent chaan Jesús, re zhaʼa ne re ngwleyy kuu nataak, mtaal zha chop tson zha kuu nkenap gwodoo, tsa ten zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tsa lee Jesús nzhab: ―Bee ndon lo re goo telut tyemp, tsaraa bren lo zha kuu mtaalʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Tsa lee re goo kwaan na, per yetsaltʼn lo goo, tak gagt ya goo ta ndyan. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tsa lee re zha Israel mndelo mnaabdiz lo re altaa nzhab: ―¿Pa bi zha, xomod gagt yetsal zha loʼaa? ¿Chu lo re tawlazaa kuu nzo tedib ta ndya zha, re zha kuu nzo xid re zha kuu nagt zha Israel ne tya loo zha lo re zhaʼa? ");
INSERT INTO zaoNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Kwan nak kuu ne zha loʼaa: “Kwaan goo na per yetsaltʼn lo goo, tak gagt ya goo ta ndyan”? ");
INSERT INTO zaoNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ne wiz kuu nyelo nlux ani wiza nak wiz ro. Ne wiza lee Jesús mndeli ne nex nzhab lo re men: ―¿Os lee thib goo nzheek leettsoo, de goo lon ne gwii goo nit? ");
INSERT INTO zaoNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Taxal nke lo xkiiz Diox: “Lee zha kuu nyelaaz na, leen leettsoo zha gats taxal thib yoo kuu ndaa nit kuu ndaa yalnaban thitanax”. Ez. 47:1; Zac. 14:8 ");
INSERT INTO zaoNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Kon re diiz ree ngwalaaz Jesús gagab Jesús lo re zha: Loka zha kuu yelaaz Jesús, kayaa zha Mbi Nayon, per ter yaad Mbi Nayon, tak ter bretab Jesús yibaa tsya. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tsa lee chop tson zha kuu mbin kona nzhab: ―Wlipaa lee zha ree nak thib zha kuu ni Diox lo, profet nak zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tedib net zha mbez: ―Zha ree nak Crist Kuu Mtaal Diox Nabee. Per lee tedib net zha mbez: ―Leet zhay, tak lee Crist Kuu Taal Diox Nabee, root Zha yezlyu Galilea. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tak lee lo xkiiz Diox nzhab lee Crist Kuu Taal Diox Nabee, ndoblo gak zha, zha raz chaan rey David, ne ndoblo gak zha, zha yez Belén, leeka yez pa ngol rey David. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kona ngok rol re men kwent chaan Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nzo cho zha ngwalaaz gago zha Jesús tsib, per neeka thib zha mtsowte. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tsa lee re zha kuu nkenap gwodoo mre ta nzi re fariseo ne re ngwleyy kuu nataak, ne mnaabdiz re zhaʼa lo re zha kuu nkenap gwodoo: ―¿Chebee ndyaadnot goo mbyiʼa? ");
INSERT INTO zaoNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Lee re zha kuu nkenap gwodoo mkab ne nzhab: ―¡Neeka thib zha ndedizt taxal ndediz mbyiʼa! ");
INSERT INTO zaoNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tsa lee re fariseo nzhab: ―¿Chu noga goo mkediʼa mbyiʼa? ");
INSERT INTO zaoNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Si neeka thib re zha kuu nabee ne neeka re fariseo, ngwalaazt lee mbyiʼa nak Crist, Zha Kuu Ne Diox Yaad Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Per pasya re men kuu nlebeet ley chaan Moisés, tak mkayaa zha mbyiʼa taxal Zha Kuu Mtaal Diox Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tsa lee Nicodemo, kuu nak thib fariseo kuu ngwatediz lo Jesús thib welt, mkab ne nzhab: ");
INSERT INTO zaoNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Lee ley chaanaa mbez: Gagt kekiʼaa thib zha, os ter gonaa kuu ne zha, tsa neʼaa naa kwan mtsow zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Lee re zha mkab nzhab: ―¿Chu noga lu nak zha Galilea? Bteed xkiiz Diox, tsa yena neeka thib profet ndroot yezlyu Galilea. ");
INSERT INTO zaoNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tsa kadta thib thib zha ndya zha liz zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tsa nda Jesús yek yii Olib, ");
INSERT INTO zaoNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ne leettsa ngwani yezlyu tedib wiz, mre Jesús ngwa Jesús lee roo gwodoo. Tsa mndob Jesús mloo Jesús lo re men kuu mkaltaa lo Jesús tya. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ne lee re maestr chaan ley ne re fariseo ngwa lo Jesús, ngwano thib ngot kuu ngok rop kon thib mbyi. Ne mto re zha ngot ndrol lo re men kuu nzi lo Jesús, ");
INSERT INTO zaoNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","tsa nzhab re zha lo Jesús: ―Maestr, lee ngot ree ngogaa lo nee, ngok rop kon thib mbyi kuu nagt tsaal ngot. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ne lee lo ley mnabee Moisés, ndoblo kuthaa ngot kuu tabaa ntsow kon ke. ¿Per lee lu xa neʼa? ");
INSERT INTO zaoNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tata nzhab re zha, tak lee xgab re zha nak, naabdiz zha thib kwaa lo Jesús, tsa tak keki zha Jesús. Per lee Jesús mkiits yek ne mndelo mkee kon kwen yaa lo yu. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Per kom naabdizka re zha lo Jesús, tsa mlit yek Jesús ne nzhab Jesús: ―Loka cho thib goo kuu napt neeka thib falt, zhaʼa ndoblo kee ke yek ngot ree ner. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tsa mre Jesús mkiits yek ne mkeeka lo yu. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Or mbin re zha kona, tsa mroo thibga thibga zha ndya zha, ne ner re zha gol mndelo mroo ndya, tsaraa mroo reta zha. Ne or beeta Jesús kon ngota myaan tya, ");
INSERT INTO zaoNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","tsa mlit Jesús yek Jesús ne mnaabdiz Jesús lo ngota: ―¿Ma re zha kuu mkekiʼa? ¿Chu neeka thib zha myet leettsoo gagutha? ");
INSERT INTO zaoNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tsa mkab ngot: ―Neeka thib zha, Zha Nabee. Tsa nzhab Jesús lo ngot: ―Neeka na yent kwan tsowʼn loʼa, tyee ne tsowt raa lu kuu went. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús mre mni lo re men, ne nzhab: ―Na nak xni lo re men yezlyu ree, ne loka cho kuu teke ditsʼn, tekeno zha xni kuu ndaa yalnaban, ne tet raa lo yalkow. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tsa lee re fariseo nzhab lo Jesús: ―Leeka kwent chaana ndaaʼa kwent, nataagt kuu niʼa. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús mkab ne nzhab: ―Wli kuu mnin tegal leeka na mniy. Tak nen pa mroon ne pa ndyan, per lee re goo neeka net goo pa mroon ne neeka net goo pa ndyan. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Lee re goo naab goo kwent lo re men taxal ntsow re mene, per lee na naabt kwent lo neeka thib men, ");
INSERT INTO zaoNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","per os leen naabʼn kwent lo re men, nali nak kuu tsowʼn, tak nagt thita na kuu tsowe, sinke noga Xutʼn kuu mtaalʼn naab kwent kon na. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ne leeka lo ley chaan goo mbez: Os lee chop testig mbez thibka kwaa, wli kuu ni rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Leeka na nak thib testig da, ne lee Xutʼn kuu mtaalʼn nak tedib testig. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tsa mnaabdiz re zha lo Jesús, ne nzhab zha: ―¿Ma Xuta? Jesús mkab ne nzhab: ―Nlebeet goo na, ne neeka Xutʼn nlebeet goo, os nlebee goo na noga nlebee goo Xutʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús nzhab re kona, leettsa mloo Jesús lo re men lee roo gwodoo, ta nzib re alkansi kuu ngo zha gon. Per neeka thib zha mzhent Jesús, tak ter tsin or kuu ten zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús mre nzhab lo re zha: ―Leen ndya ne lee re goo kwaan na, ne lee re goo tath goo por re falt goo, lee ta ndyan gagt ya goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tsa nzhab re zha Israel: ―¿Chu ntsow zha xgab leeka lee zha kuth zha zha, kona mbez zha gagt ya reʼaa ta ya zha? ");
INSERT INTO zaoNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Per lee Jesús nzhab lo re zha: ―Lee re goo zha yezlyu ree nak goo, per lee na nagtʼn zha yezlyu ree, zha yibaa nakʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kona nin lo goo, tath goo por re falt goo, tak os lee goo nyelaazt goo lee na nak Crist, Zha Kuu Mtaal Diox Nabee, tath goo por re falt goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tsa mnaabdiz re zha lo Jesús ne nzhab zha: ―¿Cho naka? Jesús mkab ne nzhab: ―Desde ner niʼa naa cho nakʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ne kwathoz re kuu nlazʼn nin lo goo ne naabʼn kwent lo goo, per lee zha kuu mtaalʼn kuu wli ni zha, ne beeta kuu ne zha lon kona nin lo re men yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Per myent re zha lee Jesús mndaa kwent chaan Xut Jesús lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kona nzhab Jesús lo re zha: ―Leettsa kee goo na zha kuu Myaad Ngok Men lo kruz, tsaraa ne goo naa cho nakʼn, ne tsaraa ne goo ntsowtʼn kuu nlazʼn, sinke beeta kuu mloo Xutʼn lon kona nin. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tak lee Xutʼn kuu mtaalʼn ndo kon na; nlaat Xutʼn na, tak thibka ntsowʼn kuu nlaaz Xutʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Leettsa nzhab Jesús re koree, kwaro zha ngwalaaz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tsa nzhab Jesús lo re zha Israel kuu ngwalaaz Jesús: ―Os lee goo wlipaa gon goo diiz xkizʼn, wlipaa zha kuu ngeteed lon nak goo, ");
INSERT INTO zaoNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","tak lebee goo kuu wli, ne lee kuu wli tsow gak goo zha kuu laa. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Lee re zha mkab ne nzhab: ―Zha raz Abraham nak nee, ne neeka mas ter gak nee mos lo thib zha, ne ¿chebee mbeza lo nee, gak nee zha kuu laa? ");
INSERT INTO zaoNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tsa nzhab Jesús lo re zha: ―Wlipaa na nin lo goo, reta zha kuu ndaa falt mos nak zha lo falt zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tak lee thib mos nyaant mos liz zha kuu nabee lo mos thitanax, per lee xgann zhaʼa thitanax nyaan xgann zha liz zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kona os lee Xgann Diox telaa goo lo re falt goo, tsasi wlipaa gak goo zha kuu mlaa. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Neʼa na lee re goo nak zha raz chaan Abraham, per nlaaz goo kuth goo na, tak nlat xkizʼn leettsoo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Na nin kuu mloo Xutʼn lon, ne lee re goo ntsow goo kuu ne xut goo lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Lee re zha mkab ne nzhab: ―¡Abraham nak xut nee! Per lee Jesús nzhab lo re zha: ―Os lee goo wlipaa xgann Abraham nak goo, kuu mtsow Abraham ndoblo goo tsow goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Per lee re goo, tegal kuu wli kuu mloo Diox lon mnin lo goo, ne nlaaz goo kuth goo na. ¡Ne lee Abraham thitanax mtsowt Abraham kuu tata! ");
INSERT INTO zaoNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Lee re goo ntsow goo kuu ntsow xut goo. Lee re zha mkab nzhab: ―¡Lee re nee nagt nee zhiinn wan zha, nap nee thibka xut nee, kuu nak Diox! ");
INSERT INTO zaoNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús mkab ne nzhab: ―Os wlipaa Diox nak xut goo, gake leettsoo goo na, tak lo Diox mroon, ne ndyaltʼn tak nlazʼn yalʼn, sinke ndyalʼn tak lee Diox mtaalʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Chebee nyent goo re kuu nin lo goo? Nyent gooy, tak nlaazt goo gon goo xkizʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Maxuuy nak xut goo, zha Maxuuy nak goo, ne ntsow goo re kuu nlaaz Maxuuy. Tak lee Maxuuy nak thib zha kuu nzhuth men desde ndala. Ne ndedizt Maxuuy kuu wli, tak neeka lut kuu wli yent leettsoo Maxuuy. Ne leettsa ndediz Maxuuy kuu wlit kuu nak Maxuuy kona ndediz Maxuuy, tak zha nkedi nak Maxuuy, ne lee Maxuuy nak xut yalkedi. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Per lee na kuu wli nin lo goo ne nyelaazt goo xkizʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Cho thib goo, tak loo goo lee na nap thib falt? Os kuu wli nin lo goo, ¿chebee nyelaazt goo xkizʼn? ");
INSERT INTO zaoNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Lee zha kuu nak zha Diox, nkenza zha xkiiz Diox, per lee goo nagt goo zha Diox, kona nlaazt goo gon goo xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tsa lee re zha Israel nzhab lo Jesús: ―Wenka nzhab nee lee lu nak thib zha yez Samaria, ne mbi fyer nzo leettsooʼa. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús mkab ne nzhab: ―Neeka thib mbi fyer yent leettsoon. Lee kuu ntsowʼn nak ntsow nataak na Xutʼn; per lee re goo ngoo goo yalnathoy da. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nkwaantʼn tsa tsow nataak re men na, per nzo thib zha kuu nlaaz tsow nataak re men na, ne lee zhaʼa nak zha kuu naab kwent. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Wlipaa na nin, loka cho kuu nzhon diiz xkizʼn gatht zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Lee re zha Israel mkab ne nzhab: ―Nalsi ne nee, wlipaa mbi fyer nzo leettsooʼa, Abraham ne reta profet nguth zha, ne lee lu mbeza: “Loka zha kuu gon diiz xkizʼn gatht zha”. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Naa ¿chu mas nataaka nake teyaa Abraham? Lee Abraham, ne noga re profet kuu ngoo ndala nguth re zha. ¿Cho naka ndaka? ");
INSERT INTO zaoNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús mkab ne nzhab: ―Os leen tsow nataak na leeka na, nataagt kuu nin. Per lee zha kuu ntsow nataak na nak Xutʼn, leeka Diox kuu mbez goo nak Diox goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Per nlebeet goo Diox. Per na si nlebeen Diox. Ne os nin nlebeetʼn Diox, noga na nakʼn zha nkedi taxal goo. Per wlipaa nlebeen Diox, ne ntsowʼn kuu nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Lee Abraham teyaa zha ndala, kwathoz laz zha, tak ngwalaaz zha gawii zha wiz ree, ne mwii zhay ne kwathoz naley ngoo leettsoo zha mwii zhay. ");
INSERT INTO zaoNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Lee re zha Israel nzhab lo Jesús: ―¡Neeka napta chop galbtsii liin, ne mbeza mwiiʼa lu Abraham! ");
INSERT INTO zaoNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús mkab ne nzhab: ―¡Wlipaa na nin lo goo, nzoʼa na leettsa terka yo Abraham! ");
INSERT INTO zaoNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tsa lee re zha mzhen ke, gakee zha yek Jesús, per lee Jesús mkaslo ne mroo lee roo gwodoo, ne mriid Jesús xid re men nda Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Or nderid Jesús thib ta, tsa mwii Jesús thib mbyi kuu ngol syeg. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tsa lee re zha kuu ngeteed lo Jesús mnaabdiz lo Jesús ne nzhab: ―Maestr, ¿chebee syeg mbyi ree ngol mbyi? ¿Chu tak mndaa xut mbyi ne xnaa mbyi falte o chu tak leeka mbyi mndaa falt konay? ");
INSERT INTO zaoNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Tsa lee Jesús mkab ne nzhab: ―Ngolt mbyi tabaa, por falt chaan xut mbyi ne xnaa mbyi, neeka nagte por falt mbyi, tabaa ngol mbyi, tsa por lee mbyi loo Diox re kuu tak tsow Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ne nal beet raa tse nziʼaa, ndoblo tsowʼn rtsin zha kuu mtaalʼn, tak leettsa nlaa yaal neeka thib zha gagt raa ke tsiin. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nal kuu bee ndon lo yezlyu ree, xni nakʼn lo re men yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Or ngwalo nzhab Jesús re koree, tsa mtsuk Jesús lo yu, ne mtsow Jesús lut ben ne mdaab Jesús ben ngutlo syeg. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tsa nzhab Jesús lo syeg: ―Gwa, gwateech ngutloʼa roo tank kuu le Siloé. (Diiz ree nak: “Ntaal zha zha”.) Tsa ngwa zha syega ngwateech ngutlo, ne leettsa mretab zha nyeniʼa ngutlo zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tsa lee re zha kuu nzo gax liz zhaʼa, ne re zha kuu mwii lee zha mnaab karida, mnaabdiz zha lo re altaa zha ne mbez zha: ―¿Chu leet zha ree kuu nyatob nyanaab karida ganda wiz? ");
INSERT INTO zaoNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tsa thib net zha mbez: ―Lee zhay. Lee tedib net zha mbez: ―Leet zhay, tegal tata na zha. Per lee zha mbez: ―Nay. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tsa mnaabdiz re zha lo zhaʼa ne nzhab zha: ―¿Xomod nzhaaka ngwiiʼa? ");
INSERT INTO zaoNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Lee zha mkab ne nzhab: ―Lee mbyi kuu lee Jesús mtsow lut ben, ne mdaab mbyiy ngutlon, tsa ne mbyi lon: “Gwa roo tank Siloé gwateech ngutloʼa”. Ne oraaka ngwan ne mteechʼn ngutlon, ne lee ngutlon mzhaal. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tsa mnaabdiz re zha lo zhaʼa ne nzhab zha: ―¿Ma mbyiʼa tsa? Tsa nzhab zha: ―Netʼn, ma mbyi. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tsa ndano re zha zha kuu ngok syega lo re fariseo. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ne wiz sabd kuu ndroxkwan re zha Israel, wiza mtsow Jesús lut ben ne mtegwe Jesús ngutlo zha kuu ngok syega. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tsa lee re fariseo mnaabdiz lo zha kuu ngok syega ne nzhab re zha: ―¿Xomod mgwe ngutloʼa? Lee zha mkab ne nzhab: ―Lee mbyiʼa mdaab ben ngutlon, ne mteechʼn ngutlon, ne lee nal nzhaaka ngwiin. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Lee chop tson fariseo nzhab: ―Nagt mbyiʼa thib zha kuu mtaal Diox, tak ngotsowt zha wiz sabd kuu ndroxkwanaa. Per techop tson zha mbez: ―¿Xomod nzhaak ntsow zha re milagr thoz ree, os zha kuu nap falt nak zha? Ne ta mod ngok rol re zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tsa mre re zha mnaabdiz zha lo zha kuu ngok syega, ne nzhab zha: ―Lee lu, ¿cho nak zha kuu mtegwe ngutloʼa ndaka? Lee zha mkab ne nzhab: ―Na ni lee zha nak thib profet chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Per lee re zha Israel ngwalaazt zha lee zha kuu ngok syega, nzhaaka ngwii, tsa mtaal re zha chop tson zha ngwachez xut zhaʼa ne xnaa zha, ");
INSERT INTO zaoNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ne or mzin xut zha ne xnaa zha, tsa mnaabdiz re zha lo xut zha ne lo xnaa zha, ne nzhab re zha: ―¿Chu zhiinn goo nak mbyi ree? ¿Chu wli goo syeg zha ngol zha? ¿Ne xomod nzhaaka ngwii zha nal? ");
INSERT INTO zaoNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Lee xut zha ne xnaa zha mkab ne nzhab: ―Wli xgann nee nak zha, ne syeg zha ngol zha, ");
INSERT INTO zaoNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","per net nee chebee nzhaaka ngwii zha, ne neeka net nee cho mtegwe ngutlo zha. Bnaabdiz goo lo zha zha byeʼa zha, lee zha tak ney lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tata nzhab xut zha ne xnaa zha, tak nzeb rop zha ne zha re zha Israel kuu nataak, tak lee re zha kuu nataaka myaan re zha diiz, os lee thib zha gab lee Jesús nak Zha Kuu Mtaal Diox Nabee, koo zha zhaʼa xid re zha ta nkaltaa re zha nteed zha xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ta mod nzhab xut zha ne xnaa zha: “Bnaabdiz goo lo zha zha byeʼa zha”. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tsa lee re zha Israel mre mrez zha kuu ngok syega, ne nzhab re zha lo zhaʼa: ―Bloo rooʼa lo nee delant lo Diox. Tak neʼa nee lee mbyiʼa nak thib zha kuu ndaa falt. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tsa lee zhaʼa mkab ne nzhab: ―Netʼn chu zha nap falt nak zha o nagt zha zha kuu nap falt. Beeta kuu nen nak, ngokʼn syeg, per lee nal nyeniʼa ngutlon. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tsa mre re zha mnaabdiz zha lo zhaʼa nzhab zha: ―¿Kwan mtsow zhaʼa loʼa? ¿Xomod mtsow zha par mzhaal ngutloʼa? ");
INSERT INTO zaoNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Lee zha mkab ne nzhab: ―Niʼa nay lo goo, per nyelaazt gooy. ¿Chebee nlaaz goo bren ni nay lo goo tedib welt? O, ¿chu no goo nlaaz goo teke goo dits Jesús? ");
INSERT INTO zaoNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tsa mtsalzhoo re zha zhaʼa, ne nzhab re zha: ―Lu ndekeʼa dits mbyiʼa, per lee nee ndeke nee dits Moisés. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nee ne lee Diox mni lo Moisés, per lee mbyiʼa neeka net nee pa mroo mbyiʼa. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Lee mbyi kuu ngok syega mkab ne nzhab: ―¡Koree si wlipaa nzegey leettsoo men ngwii men! Tak ¿chebee net goo pa mroo zha, ne lee zha mtegwe ngutlon? ");
INSERT INTO zaoNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Retalee neʼaa nzhont Diox xkiiz re zha kuu nap falt, per nzhon Diox xkiiz re zha kuu nyelaaz Diox ne ntsow kuu nlaaz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Thitanax neeka mas ter yath, lee thib zha ntsow nyeni lo thib zha kuu ngol syeg. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Os lee mbyiʼa ndyaadt por Diox, yent kwan tak tsow mbyi. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tsa nzhab re zha lo zha kuu ngol syega: ―¡Zhiinn wan zha naka! Ne nlaaza teniʼa nee. Tsa mloo re zha zhaʼa ta nkaltaa re zha nteed zha xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Tsa mbin Jesús lee re fariseo mloo zha kuu ngol syega, ta nkaltaa zha nteed zha xkiiz Diox, ne or mzaal Jesús zha kuu ngok syega, tsa nzhab Jesús lo zha: ―¿Chu nyelaaza, Zha Kuu Mtaal Diox Ngok Men? ");
INSERT INTO zaoNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Lee zha kuu ngok syega mkab ne nzhab: ―Zha Nabee, ne lon choy, tsa yelazʼn zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús mkab lo zha ne nzhab: ―Mwiiʼa lu zha, tak na nak zhaʼa kuu ngetediz loʼa. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tsa lee mbyiʼa mtobxub lo Jesús ne nzhab: ―Zha Nabee, nyelazʼn lu. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ora nzhab Jesús lo zha: ―Na ndyalʼn lo yezlyu ree par naabʼn kwent lo re men yezlyu ree, tsa lee re zha kuu syeg yeni lo, ne lee re zha kuu nyeni lo yaan syeg. ");
INSERT INTO zaoNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Per lee chop tson fariseo kuu nzi tya, or mbin zha kona, tsa mnaabdiz zha lo Jesús ne nzhab zha: ―¿Chu no nee nak nee taxal syeg? ");
INSERT INTO zaoNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús mkab lo re zha ne nzhab: ―Os gagak goo syeg, napt goo falt lo Diox. Per tak mbez goo wen nyeni lo goo, kona nap goo falt lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Tsa nzhab Jesús: ―Wlipaa na nin, lee zha kuu ndaabt par roo korral chaan re mbak zhiil, sinke ndaab zha thib lad cho liz maa, wann nak zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Per lee zha kuu ndaab par roo liz maa, zhaʼa nak zha kuu nkenap maa. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ne lee zha kuu nkenap roo korral, nxaal zha roo korral lo zha kuu nkenap re mbak zhiil, ne ndaab zha ne mbez zha thib thib mbak zhiil por le mbak zhiil ne lee re mbak zhiil nlebee maa xkiiz zha. Ne ngoo zha maa leen korral. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ne or ngwaloʼa mroo reta maa, ora ndener zha lo re maa, ne ndeke maa dits zha tak nlebee maa xkiiz zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Per os leey thib zha kuu nlebeet maay, nzhonn maa lo zha ne teket maa dits zha, tak nlebeet maa xkiiz zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús nzhab kona lo re men, per lee re men myent kuu nlaaz Jesús gab Jesús lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesús mre nzhab lo re men: ―Wlipaa na nin lo goo: Na nak taxal roo pwert ta ndaab re mbak zhiil. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Reta zha kuu myaad ner nake na, wann nak re zhaʼa, per lee re mbak zhiil mbint mbak zhiil diiz lo re zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Na nak taxal roo pwert, ne lee zha kuu tab roo pwert ree, telaa zha lo re falt chaan zha. Ne gak zha taxal thib mbak zhiil, kuu ndaab ne ndroo ne nyetsal yizh nayee wu. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Lee wann beeta ndyaad wann par lowann wann, par kuth wann ne par luux wann re maa, per lee na ndyalʼn par keno goo yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Na nak zha kuu wen nkenap re mbak zhiil. Ne lee zha kuu wen nkenap re mbak zhiil, ndaa zha yalnaban chaan zha por re mbak zhiil, ");
INSERT INTO zaoNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","per lee zha kuu nzhax lo por nkenap re mbak zhiil, or ne zha lee mbez ndyaad, nlaa zha re mbak zhiil ne nzhonn zha, tak nagt zhaʼa, zha kuu wen nkenap re mbak zhiil, neeka nagt re maa, maa zha. Tsa lee mbeez nla nzhuth re mbak zhiil, ne nchaats mbeez re maa. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Lee zhaʼa nzhonn zha, tak tsiin nke zha beeta par gax kaa zha, ne ndat leettsoo zha por re mbak zhiil. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’Na nak zha kuu wen nkenap re mbak zhiil. Ne taxal nlebee Xutʼn na, ne lee na nlebeen Xutʼn, leeka tata nlebeen re mbak zhiil da, ne noga re maa da nlebee maa na. Ne ndan yalnaban da por re maa. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Noga napʼn tedib net maa kuu nagt maa korral ree, ne noga re maaʼa ndoblo yaxin. Tsa gon maa diiz lon, ne yo re maa thibka korral, tsa keno maa thibka zha kuu wen kenap re maa. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Lee Xutʼn nke leettsoo Xutʼn na, tak ndan yalnaban da, par kayaa nay tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Neeka thib zha gagt kuthʼn, per tan diiz kuth zha na tak tata nlazʼn. Tak napʼn yalnabee par tan yalnaban da, ne napʼn yalnabee par kayaa nay tedib welt. Koree nak kuu mnabee Xutʼn lon tsowʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Or mbin re zha Israel re kona, mre zha ngok rol zha tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kwathoz zha mbez: ―¿Chebee nzhon goo kuu ni zha? Si mbi fyer nzo leettsoo zha ne nzhak naxen yek zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Per lee tedib net zha mbez: ―Neeka thib zha kuu nzo mbi fyer leettsoo nit tabaa. ¿Chu, tak tegwe thib mbi fyer ngutlo thib zha syeg? ");
INSERT INTO zaoNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tyemp kuu nla yig, lee re zha yez Jerusalén ntsow zha ani chaan gwodoo zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ne lee Jesús ndiy lee roo gwodoo ne roo korredor gwodoo, korredor kuu le chaan Salomón. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tsa lee re zha Israel mkaltaa re ladta lo Jesús, ne mnaabdiz zha lo Jesús ne nzhab zha: ―¿Asta pol neʼa lo nee naa cho naka, tsa rooy yek nee? ¿Chu lu nak Crist Kuu Mtaal Diox Nabee? Neey lo nee. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús mkab ne nzhab: ―Niʼa nay lo goo, per nyelaazt goo xkizʼn. Reta kuu ntsowʼn, ntsow nay kon yalnabee chaan Xutʼn, re kona nambi nloo naa cho nakʼn, ");
INSERT INTO zaoNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","per nyelaazt gooy, tak nagt goo mbak zhiil da, taxal mniʼa na lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Lee re mbak zhiil kuu nak mbak zhiil da, nlebee maa xkizʼn, ne nlebeen maa, ne ndeke maa ditsʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ne na nda yalnaban kuu thitanax lo re maa, ne thitanax gatht raa maa, ne yent cho tak kib maa lon. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tak lee Xutʼn kuu mndaa reta mbak zhiil lon, lee Xutʼn nak kuu mas ney nake reta kwaa, ne yent cho tak kib maa lo Xutʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tak lee Xutʼn ne na thibka nak nee. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tsa lee re zha Israel mre mzhen ke, par kee zhay yek Jesús tedib welt, ");
INSERT INTO zaoNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","per lee Jesús nzhab lo re zha: ―Kon yalnabee chaan Xutʼn mtsowʼn re kuu thoz lo re goo, ¿por cho thib re kona nlaaz goo kee goo ke yekʼn? ");
INSERT INTO zaoNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tsa lee re zha Israel mkab lo Jesús ne nzhab: ―Keet nee ke yeka por re kuu wen kuu mtsowa, lee nee keey yeka por kuu went kuu niʼa. Tak thib mbyi naka, ne leeka lu ntsowa lu taxal Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús mkab ne nzhab: ―At lo ley chaan goo mbez: “Na ni lee goo nak diox”, nzhab Diox. Sal. 82:6 ");
INSERT INTO zaoNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ne tak lo xkeets Diox nzhabe gagt gabaa wlite, ne os lee Diox, diox mtob le Diox re zha kuu mkayaa xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿Chebee mbez goo lon leen mni kuu went, tak nin lee na nakʼn Xgann Diox? Ne lee Diox mlin ne mtaalʼn lo yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Os leen ntsowtʼn re kuu ntsow Xutʼn, yelaazt goo na. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Per os leen ntsow re kuu ntsow Xutʼn, tegal yelaazt goo na, per gwalaaz goo re kuu ntsowʼn, tsa ne goo lee Xutʼn ndo kon na ne lee na ndon kon Xutʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ne tedib welt ngwalaaz re zha gaten zha Jesús, per lee Jesús tee mbeche lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mre Jesús tedib welt tedib lad roo yoo Jordán, ta mtsowleyy Juan re men, ne tya myaan Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ne naroob men ngwa lo Jesús, ne nzhab re men: ―Wlipaa, tegal neeka thib milagr thoz mtsowt Juan, per reta kuu ne Juan kwent chaan mbyi ree wliy. ");
INSERT INTO zaoNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tsa kwaro zha ngwalaaz Jesús tya. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ngoo thib mbyi kuu le Las kuu mzhak ne, ne btan Las nak Mari ne Mart, zha yez Betania nak re zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ne Mariʼa, nak zha mxo perfum kuu chul ndetsi nii Jesús Zha Nabee, ne mtekwiiz Mariy kon yitsek Mari. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Tsa mtaal rop bel ngot thib zha ngwa ngwane lo Jesús ne nzhab: ―Zha Nabee, lee amiga Las kuu kwathoz nke leettsooʼa ne ndak. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Or mbin Jesús kona, tsa nzhab Jesús: ―Lee yiza nagt kona par gath Las, sinke leey nak par loo yalnabee chaan Diox, ne noga looy yalnabee chaan Xgann Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ne kwathoz nke leettsoo Jesús Mart, bel Mart ne btan Mart Las, ");
INSERT INTO zaoNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","or mbin Jesús lee Las ne ndak, mletka Jesús ta ndo Jesús techop wiz. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tsaraa nzhab Jesús lo re zha kuu ngeteed lo Jesús: ―Nda goo reʼaa tedib welt yezlyu Judea. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tsa nzhab re zha lo Jesús: ―Lo nal lee re zha Israel kuu nzo yezlyuʼa, ngwalaaz gagutha kon ke, ne nal nlaaza lu yaʼa tya tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Tsa nzhab Jesús: ―¿Chu nagt tsiibchop or nak thib wiz? Os lee thib zha tiy zha tse, yent kwan ral nii zha, tak nteni xni wiz lo zha, ");
INSERT INTO zaoNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","per os lee zha tiy zha yaal, teral kuu nii zha, tak yent xni kuu teni lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ngwalo nzhab Jesús kona, noga nzhab Jesús: ―Lee amigaa Las naxat, per nal yan yalitchen Las. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tsa lee re zha kuu ngeteed lo Jesús nzhab: ―Zha Nabee, os lee zha naxat zha, tegwe zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lee Jesús ngwalaaz gagab lee Las nguth, per lee re zha kuu ngeteed lo Jesús mtsow xgab naxat Las. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tsaraa nambi nzhab Jesús lo re zha kuu ngeteed lo Jesús: ―Ngutha Las. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ne kwathoz lazʼn tak mndotaa tya, tak tabaa mas wen par goo, tsa yelaaz gooy. Nda goo reʼaa lo Las. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tsa lee Mach kuu ni zha “kwach”, nzhab lo tedib net re zha kuu ngeteed lo Jesús: ―Nda goo reʼaa, tsa noga lee gathaa kon lee zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ne leettsa mzin Jesús yez Betania, mne Jesús lee Las ndaʼa thap wiz mgaats. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ne gax yez Jerusalén nzi yez Betania, teeka tson kilometro. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ne kwathoz re zha Israel kuu nzo Jerusalén nzi tya, ngwa ngwatetsey leettsoo Mart ne Mari, tak nguth Las btan rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Or mbin Mart lee Jesús ndetsin tya, tsa mroo Mart mkayaa Mart Jesús, per lee Mari myaanka yuu. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tsa nzhab Mart lo Jesús: ―Zha Nabee, os leeʼa gatoʼa nzhee gagatht btan na. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Per tegal nalraa ndoʼa nzhee, nen tetsow Diox kuu naaba lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Lee Jesús nzhab lo Mart: ―Lee btana teroban. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tsa lee Mart nzhab: ―Wliy, neʼa na lee btan na roban wiz kuu roban re zha nguth, leettsa gak wiz bluz. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Tsa nzhab Jesús lo Mart: ―Na nak yalndroban ne yalnaban. Loka zha kuu yelaaz na, tegal gath zha taban zha, ");
INSERT INTO zaoNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ne reta zha kuu naban ne nyelaaz na, thitanax gatht zha. ¿Chu nyelaaza koree Mart? ");
INSERT INTO zaoNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Lee Mart mkab ne nzhab: ―Nyelaz nay Zha Nabee. Ne, nen lee Lu Nak Crist, Xgann Diox Kuu Mtaal Diox Nabee, kuu naka diiz yaad lo yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ngwalo nzhab Mart kona, tsa ngwachez Mart bel Mart Mari, ne xlaanta nzhab Mart lo Mari: ―Lee maestr ndo nzhee ne ngebez maestr lu. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Or mbin Mari kona, oraaka ngwateli Mari nda Mari lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ne lee Jesús neeka ter tab leen yez, bee ndoka Jesús ta mwii Mart Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ne or mwii re zha Israel kuu ngetetsey leettsoo Mari, lee Mari ngwateli nda, tsa mndeke re zha dits Mari, tak mtsow re zha xgab lee Mari nda roo baa Las ndayonn. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ne or mzin Mari ta ndo Jesús, tsa mtobxub Mari xann nii Jesús, ne nzhab Mari: ―Zha Nabee, os leeʼa gatoʼa nzhee, gagatht btan na. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ne or mwii Jesús nzhonn Mari ne noga re zha Israel kuu ndeke dits Mari nzhonn, kwathoz nalatt ne nabil ngoo leettsoo Jesús, ");
INSERT INTO zaoNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","tsa mnaabdiz Jesús ne nzhab Jesús: ―¿Pa mkaats goo Las? Lee re zha nzhab: ―Zha Nabee, de tsa wiiʼa. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tsa mbinn Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ne lee re zha Israel nzhab: ―¡Wii goo xa kwathoz mke leettsoo zha Las! ");
INSERT INTO zaoNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Per lee chop tson zha mbez: ―Zha ree kuu mtegwe ngutlo syega; ne ¿chu ngogt gatsow zha tsa na gagatht Las? ");
INSERT INTO zaoNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ne tedib welt kwathoz nalatt ngoo leettsoo Jesús, tsa mbig Jesús roo baa. Lee baaʼa nak leen thib kelyoo, ne now thib ke rooy. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tsa nzhab Jesús: ―Kib goo ke. Tsa lee Mart, btan Las nzhab: ―Zha Nabee, ser ndetsiʼa Las, tak ndaʼa thap wiz nguth Las. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús mkab ne nzhab: ―¿Chu nitʼn loʼa, os leeʼa nyelaaza na, tewiiʼa re kuu thoz kuu tsow Diox? ");
INSERT INTO zaoNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tsa mkib zha ke. Ne lee Jesús mwii lobee ne nzhab: ―Xutʼn, ndan texkix loʼa tak mbina kuu nin loʼa. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Na ne, lee lu thibka nzhona xkizʼn, per ni nay tsa ne re men kuu nzi nzhee lee lu mtaalʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Or ngwalo mni Jesús koree, tsa dib gan Jesús nzhab Jesús: ―¡Las broo baa! ");
INSERT INTO zaoNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ne lee mbyi kuu ngutha mroo nabix lar, ne noga lo zha nabix lar, tsa nzhab Jesús: ―Bkib goo lar kuu nabix Las ne laa goo bi Las. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ta mod kwaro re zha Israel kuu ngwatetsey leettsoo Mari ngwalaaz Jesús, tak mwii zha kuu mtsow Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Per lee chop tson zha ngwa lo re fariseo, ne nzhab zha kuu mtsow Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tsa lee re fariseo ne re ngwleyy kuu nataak, mkaltaa re zha lo thib junt ne nzhab zha: ―¿Kwan tsowaa? Tak lee mbyiʼa ngetsow re milagr thoz. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Os laaʼaa zha, reta men yelaaz zha, tsa lee re zha yez Roma yaad zha ne luux zha lazaa ne gwodooʼaa. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Per lee thib zha kuu nzo xid re zhaʼa kuu le Caifás, thib zha kuu nak ngwleyy kuu nabee lo reta ngwleyy liina, nzhab lo re zha: ―¡Yent kwan nane goo! ");
INSERT INTO zaoNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ne neeka nyent goo re kwaa, mas wen gath thibka mbyi por reta men yez, nake reta men yez lux. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Per nzhabt Caifás kona por leeka lee Caifás, sinke lee Caifás nak ngwleyy liina, kona mtsow Diox, par mroo roo Caifás lee Jesús gath por reta zha Israel, ");
INSERT INTO zaoNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ne nagte beeta por re zha Israel, sinke noga par kaltaa Diox re zhiinn Diox kuu nzo dib naxta lo yezlyu, tsa gak re zha thibka yez. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ne desde wiza lee re zha kuu nataak myaan re zha diiz kuth zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kona mndiyt raa Jesús legal xid re zha Israel, sinke mroo Jesús yezlyu Judea, ne ngwa Jesús thib yez kuu nzi gax yubiz kuu le Efraín, ne tya myaan Jesús kon re zha kuu ngeteed lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ne leettsa mera tsin ani Paskw chaan re Israel, tsa kwathoz men kuu nzo tedib net re yez ngwa Jerusalén, par tsow zha taxal nak kostumr zha kuu nak, ntsow nambi zha zha lo Diox ley lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tsa ndiy re zha nkwaan zha Jesús lee roo gwodoo, ne naabdiz re zha lo altaa zha, mbez zha: ―¿Kwan ndak goo? ¿Chu tyaad mbyiʼa lo ani o yaadt mbyi? ");
INSERT INTO zaoNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tsa lee re fariseo ne re ngwleyy kuu nabee lo re ngwleyy mnabee re zha, tsa loka zha kuu wii Jesús, ko zha diize, tsa ten zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Leettsa ndoraa xoop wiz tsin ani Paskw, tsa myaad Jesús yez Betania ta nzo Las kuu lee Jesús mteroban. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ne tya mdexkwaa zha thib rtsee par Jesús, lee Mart mloo komid leen yann, ne lee Las nak thib re zha kuu mndob roo mes ndow kon Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tsa lee Mari ndyaadno teeka garol litr perfum kuu chul ndetsi, kuu natexkwaa kon ya kuu le nardo ne kwathoz naape, tsa mloo Mari perfum nii Jesús ne kon yitsek Mari mtekwiiz Mariy. Ne dita leen yuu mndetsii tsii perfum. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tsa lee Judas Iscariote, thib re zha kuu ngeteed lo Jesús, kuu mtsowa xgab taa Jesús lo re zha kuu nayii ne Jesús, nzhab: ");
INSERT INTO zaoNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Chebee mdot perfum ree por tson gayoo denario, par gakaa re probe? ");
INSERT INTO zaoNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Per nzhabt Judas kona tak ntsow Judas xgab re prob, sinke tata nzhab zha tak wann nak zha, ne lee zha natsaal bols temi, ne nlowann zha temi kuu ngoo re zha leen bols. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tsa nzhab Jesús lo Judas: ―Laaʼa Mari, tak mlotsow Mari perfum ree, tsa chul tetsin leettsa kaats zha na. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Lee re prob thibka nzi zha lo goo, per lee na ndotʼn lo goo thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tyen re zha Israel mbin lee Jesús ndo yez Betania, tsa ngwa zha tya, par wii zha Jesús ne par wii zha Las kuu lee Jesús mteroban. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tsa lee re ngwleyy kuu nabee lo re ngwleyy myaan zha re zha diiz kuth zha Las, ");
INSERT INTO zaoNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","tak por lee Las naroob re zha Israel ngwalaaz Jesús ne mlaa zha re ngwleyy. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ne lee tedib wiza, lee naroob re men kuu ngwa lo ani Paskw, leettsa mbin re zha lee Jesús ndetsin Jerusalén, ");
INSERT INTO zaoNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","tsa mga re zha la yin, ne mroo zha mkayaa zha Jesús, ne nex nzhab re zha: ―¡Aka wen nak Diox! ¡Aka wen nak zha kuu ndyaad kon yalnabee chaan Zha Nabee! ¡Golaa lo zha kuu nak rey lo re zha Israel! ");
INSERT INTO zaoNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Tsa mzal Jesús thib burr yeen ne mke Jesús dits maa, tsa gak kuu mbez lo xkiiz Diox: ");
INSERT INTO zaoNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Tsebt goo zha yez Sión. Wii goo, lee zha kuu nak rey goo ndyaad ndob dits thib burr yeen. Zac. 9:9 ");
INSERT INTO zaoNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Per lee re zha kuu ngeteed lo Jesús, myent zha neeka thib re koree, per bluz leettsa lee Jesús ndya yibaa, tsaraa mtelaaz re zha re kuu ngok, re kuu ndaa xkiiz Diox kwent chaan Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ne lee re zha kuu ndo kon Jesús, leettsa mrez Jesús Las roo baa, ne mteroban Jesús Las, re zhaʼa mndaa kwent kuu mwii zha mtsow Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kona lee re men mroo ngwaxiinet Jesús, tak mbin zha re milagr thoz kuu mtsow Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Per lee re fariseo mbez lo re altaa: ―¿Chu ngwiit goo yent kwan tak tsowaa? Reta men ndeke dits zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ne xid re zha kuu ngwayol lo Diox lo ani yez Jerusalén, ngwa chop tson zha kuu nak zha gryeg. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Lee re zhaʼa mbig lo Lip, kuu nak zha yez Betsaida, thib yez chaan yezlyu Galilea, ne nzhab re zha lo Lip: ―Nlaaz nee wii nee Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ora lee Lip ngwa nzhabe lo Ndres ne ngwa rop zha nzhab zhay lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tsa nzhab Jesús lo rop zha: ―Mzina or kuu lee Diox tsow nataak xgann. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Wlipaa na nin, os lee thib bin nzob xtil yot lo yu ne os leey gathte par lene, thibe yaane ne taate nzob xtil, per os leey yoy lo yu ne lene naroob nzob xtil taay. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Lee zha kuu nke leettsoo yalnaban chaan teluux zhay, per lee zha kuu nket leettsoo yalnaban chaan lo yezlyu ree, tetsow zhaʼa gan yalnaban kuu thitanax yibaa. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Os lee thib zha nlaaz tsow rtsin na, ndoblo teke zha ditsʼn, ne loka pa ta ndon no zha kuu ntsow rtsin na ndo tya. Ne lee re zha kuu ntsow rtsin na, lee Xutʼn tsow nataak zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’¡Kwathoz nalatt nzo leettsoon nalor! Ne netʼn kwan gapʼn: “Xutʼn, laata riidʼn yalti ree”. ¡Per par kona ndyalʼn! ");
INSERT INTO zaoNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Xutʼn, btsow nataak leʼa. Tsa ora mbin na thib bos kuu mroo lobee, kuu nzhab: ―Mtsow nataaka nay, ne tetsow nataak nay tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ne mbin re zha kuu nzi tya bosa, tsa nzhab re zha, bi ngundiiy, per lee tedib net zha nzhab: ―Thib mandad chaan Diox mni lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tsa nzhab Jesús lo re men kuu nzi tya: ―Mniit bosa por na, sinke por goo mniy. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ne nal nak or kuu naab Diox kwent lo re men yezlyu ree, ne nal koo Diox Maxuuy kuu nabee lo yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Per leettsa roban na, tsa tsowʼn lee re men yelaaz na. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ne tenzhee mod mndaa Jesús kwent naa xomod gath Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Lee re men mkab lo Jesús ne nzhab: ―Nee ne lee lo ley kuu mkee Moisés mbez, lee Crist Kuu Taal Diox Nabee, thitanax ban zha ne gatht zha. ¿Kona chebee mbeza lee Zha Kuu Mzin Ngok Men ndoblo roban? Ne ¿cho nak Zha Kuu Mzin Ngok Men? ");
INSERT INTO zaoNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tsa nzhab Jesús lo re zha: ―Nal bee ndo xni lo re goo telut. Bte goo lo xni nalt raa kuu bee ndobke xni, tsa tsint yalkow chatta lo goo taxal thib kuu ngebeta goo, tak lee zha kuu ndiy lo yalkow, net zha pa nda zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Gwalaaz goo xni nalt raa bee ndobkey lo goo, tsa gak goo zhiinn zha kuu nak xni. Or ngwalo nzhab Jesús re koree, tsa nda Jesús ne mkaslo Jesús lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ne tegal mtsow Jesús re milagr thoz lo re zha, per ngwalaazt re zha Jesús, ");
INSERT INTO zaoNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","tak tabaa mrolo kuu mkee profet Isaí lo re men, leettsa nzhab profet: Zha Nabee, ngwalaazt re men xkiiza kuu mndaa nee kwent lo re men, tegal mtsowa re kuu thoz lo re zha ngwalaazt zha lu. Is 53:1 ");
INSERT INTO zaoNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ngwalaazt re zha Jesús, tak noga mkee Isaí: ");
INSERT INTO zaoNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Diox mtekow ngutlo re men, ne mtsow nad Diox leettsoo re men, tsa gagt wii zha ne tsa gagt yen zha xkiiz Diox. “Tsa bretabt zha lon, ne tegwetʼn zha”. Is. 6:10 ");
INSERT INTO zaoNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Nzhab Isaí re koree, tak mwii Isaí yalnabee chaan Jesús, kona mndaa Isaí kwent chaan Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ne tegal tatay, kwathoz re zha Israel ngwalaaz Jesús, ne asta chop tson re gobyern ngwalaaz Jesús, per nzeb re zha gab zhay, tak nzeb zha ne zha re fariseo, tak os lee zha gab zhay, tsa lee re fariseo koo zha ta nkaltaa re zha nteed zha xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tak mas nlaaz zha tsow nataak re men zha, nake tsow nataak Diox zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Tsa nex nzhab Jesús: ―Loka cho nyelaaz na, nyelaazt zha beeta na, sinke noga Xutʼn kuu mtaalʼn nyelaaz zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ne loka zha kuu ngwii lon noga ngwii zha zha kuu mtaalʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Na nak taxal xni, ne ndyalʼn lo yezlyu ree, tsa loka zha kuu yelaaz na yaant lo yalkow. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Per lee zha kuu nzhon xkizʼn, ne nzhont diize, nat naab kwent lo zha, tak ndyaltʼn par naabʼn kwent lo re men, sinke leen ndyalʼn par telaan re men lo yalguth. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Lee zha kuu nyelaazt na ne ntsowt re kuu nin, napa zhaʼa cho naab kwent lo zha, leeka re diiz kuu mnin naab kwent lo zha wiz bluz. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tak mnitʼn kuu nlazʼn; sinke re kuu mnabee Xutʼn kuu mtaalʼn, kona mnin. ");
INSERT INTO zaoNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ne, nen lee kuu mnabee Xutʼn nak, tsow re men gan yalnaban kuu thitanax. Kona reta kuu nin, ni nay taxal mnabee Xutʼn lon. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ne leettsa mera ndetsin ani kuu le Paskw, neʼa Jesús mzina or kuu lee Jesús laa Jesús yezlyu ree, par ndya Jesús lo Xut Jesús. Ne kwathoz mke leettsoo Jesús re zha Jesús kuu nzi lo yezlyu ree, tataka mke leettsoo Jesús re zha asta bluz. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Leettsa ngeyow rtsee re zha lee Maxuuy mlooʼa yek Judas Iscariote, xgann Simún, tsa taa zha Jesús lo re zha kuu kuth Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ne kom neʼa Jesús lo Diox mroo Jesús ne lo Diox bretab Jesús, ne noga neʼa Jesús lee Xut Jesús mndaa reta yalnabee lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kona leettsa ngeyow rtsee re zha, tsa ngwateli Jesús roo mes ne mloo Jesús thib xab Jesús, ne mliib Jesús thib tway leey Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tsaraa mloo Jesús nit leen thib bandej ne mndelo Jesús mteech nii re zha kuu ngeteed lo Jesús, ne mtekwiiz Jesús nii zha kon tway kuu naliib leey Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Per or ndateech Jesús nii Pey, tsa nzhab Pey lo Jesús: ―Zha Nabee, ¿chu neʼa lu teech niin? ");
INSERT INTO zaoNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tsa mkab Jesús lo Pey ne nzhab Jesús: ―Nyenta kuu ngetsowʼn nal, per bluz tsaraa yen luy. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Lee Pey nzhab: ―Neeka mas latʼn teecha niin. Lee Jesús mkab ne nzhab: ―Os leen teechtʼn niiʼa gagt gaka zha da. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simún Pey mkab ne nzhab: ―Os leey tabaay, Zha Nabee, teechta beeta niin, noga yaan ne yekʼn bteech. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Per lee Jesús nzhab lo Pey: ―Lee zha kuu mkeeʼa got, ndechet yeech dita zha sinke beeta nii zha ndoblo yeech, tak nambiʼa zha. Ne nambiʼa re goo, tegal ret gooy. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Leettsa nzhab Jesús: “Ret goo nambi”, tata nzhab Jesús, tak neʼa Jesús naa cho kuu taa Jesús lo re zha kuu kuth Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Leettsa ngwalo mteech Jesús nii re zha, tsa mdok xab Jesús, ne mndob Jesús roo mes tedib welt, ne nzhab Jesús lo re zha: ―¿Chu nyen goo kuu mtsowʼn? ");
INSERT INTO zaoNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Lee re goo ni goo maestr ne Zha Nabee lon, ne wen ntsow goo ni gooy, tak nak nay. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na nak maestr goo ne Zha Nabee lo goo, ne mteechʼn nii goo, kona noga goo ndoblo goo teech goo nii altaa goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mtsowʼn koree lo goo, tsa noga goo tsow goo taxal mtsowʼn lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Wlipaa na nin lo goo, neeka thib mos nataagt mos masraa nake zha kuu nabee lo mos, ne neeka thib zha kuu ntsow mandad nataagt zha masraa nake zha kuu mtaal zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Os lee goo nyen goo re koree ne ntsow gooy, kwathoz wen nda goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Ngenitʼn koree lo reta goo, tak neʼa na cho re zha kuu mlin. Per ndoblo gak kuu mbez lo xkiiz Diox: “Lee zha kuu nzhow kon na, nak zha kuu mnayii nen”. Sal. 41:9 ");
INSERT INTO zaoNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nin koree lo goo, tsa leettsa gake, yelaaz goo lee na nakʼn kuu nakʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Wlipaa na nin, loka zha kuu kayaa zha kuu talʼn, na nkayaa zhaʼa, ne loka zha kuu nkayaa na, nkayaa zha zha kuu mtaalʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Or ngwalo nzhab Jesús re koree, kwathoz nalatt ngoo leettsoo Jesús, tsa nzhab Jesús: ―Wlipaa na nin lo goo, lee thib re goo taan lo re zha kuu kuthʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tsa lee re zha kuu ngeteed lo Jesús mndelo mwii lo altaa, ne neeka net zha naa cho mteth Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ne lee thib zha kuu kwathoz nke leettsoo Jesús ndob cho Jesús, ");
INSERT INTO zaoNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","tsa lee Simún Pey mtsow seny lo zhaʼa, tsa naabdiz zha naa cho nak zha kuu mteth Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tsa mbig zhaʼa mas gax cho Jesús ne mnaabdiz zha lo Jesús ne nzhab zha: ―Zha Nabee, ¿cho kuu ntetha? ");
INSERT INTO zaoNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús mkab ne nzhab: ―Nal tenitʼn thib le pan ne lo zha kuu ta nay, zhaʼay. Ora mtenit Jesús lut pan ne mndaa Jesús pan lo Judas Iscariote, xgann Simún Iscariote. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ne ora mzhen Judas pan, ne ndow Judas pan ne oraaka lee Maxuuy mndaab leettsoo Judas. Tsa nzhab Jesús lo Judas: ―Loka kuu nlaaza tsowa, btsowe nalor. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Per lee re zha kuu ngeteed lo Jesús kuu nzi tya, myent zha naa chebee tata nzhab Jesús lo Judas. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ne kom lee Judas nak kuu nden bols temi, kona lee chop tson zha kuu ngeteed lo Jesús mtsow xgab, lee Jesús nzhab lo Judas, tii Judas lut kuu ndeche re zha lo ani o taa Judas lut kwaa lo re prob. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ngwalo ndow Judas pan kuu mzhen Judas oraaka nda Judas. Ne mkowa yezlyu ora. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ne or ngwalota mroo Judas, tsa nzhab Jesús: ―Mzina or kuu lee re men tsow nataak na, Kuu Mzin Ngok Men, ne tataga tsow nataak re men Diox por Xgann Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ne os por Xgann Diox tsow nataak re men Diox, noga Diox tetsow nataak xgann, ne mera tsow nataak Diox Xgann Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Re goo kuu nak taxal zhiinn na, telutta ndon lo goo. Tsa lee re goo kwaan na, per leeka kuu nzhapʼn lo re zha Israel, nin lo goo nal: Gagt ya goo ta ndyan. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ne lee nal nabeen thib diiz kub kuu nataak lo goo: Bke leettsoo goo thib goo ne tedib goo. Taxal nke leettsoon leeka goo, leeka tata bke leettsoo goo thib goo ne tedib goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Os lee goo nke leettsoo goo thib goo ne tedib goo, reta men yezlyu ree ne lee re goo nak zha da. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Tsa lee Simún Pey mnaabdiz lo Jesús ne nzhab: ―Zha Nabee, ¿pa ndyaʼa? Lee Jesús mkab nzhab: ―Gagt yaʼa ta ndyan, per mas bluz tsaraa yaada. ");
INSERT INTO zaoNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Lee Pey nzhab: ―Zha Nabee, ¿chebee gagt teken ditsa nal? ¡Si lista ndon gathʼn por lu! ");
INSERT INTO zaoNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús mkab lo Pey ne nzhab: ―¿Gatha por na kaa? Wlipaa na nin loʼa, leettsa terka kwez ngite leeʼa gab tson welt nlebeeta na. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Gagt chop xgab goo, gwalaaz goo Diox ne gwalaaz goo na. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lee liz Xutʼn kwathoz yuu ta yo men nzo; ne os leey nagte tata, ganit nay lo goo. Kona lee nal ndyan ndatexkwaan ta yo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ne os leen ndyan ne ndatexkwaan ta yo goo, bren tedib welt ne yaadxin goo, tsa no goo yo goo ta yoon. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Neʼa goo pa ndyan, noga ne goo net. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tsa lee Mach nzhab lo Jesús: ―Zha nabee, net nee pa ndyaʼa, ne ¿xomod ne nee net tsa? ");
INSERT INTO zaoNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Lee Jesús mkab ne nzhab: ―Na nak taxal net, na nak kuu wli, ne na nak yalnaban. Ne neeka thib men tsint lo Xutʼn, os nagte por na. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Os lee goo nlebee goo na, noga nlebee goo Xutʼn; ne nlebeeʼa goo Xutʼn, tak mwiiʼa goo Xutʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tsa nzhab Lip lo Jesús: ―Zha nabee, beeta bloo Xuta lo nee, ne kon kona wena yo leettsoo nee. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tsa lee Jesús nzhab: ―Lip, ndaʼa wiz ndon lo re goo, ne ¿chu terka lebeeʼa na? Loka zha kuu ngwii lon, mwiiʼa zhaʼa lo Xutʼn; ne ¿chebee mbeza lon “bloo Xuta lo nee”? ");
INSERT INTO zaoNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Chebee nyelaazta lee Xutʼn nzo leettsoon ne lee na nzon leettsoo Xutʼn? Lee re kuu nin lo goo, nit nay por kwent chaan da, sinke lee Xutʼn kuu thibka ndo kon na, ntsow Xutʼn rtsin Xutʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Gwalaaz goo lee na nzon leettsoo Xutʼn, ne lee Xutʼn nzo leettsoon. Ne os lee goo nyelaazt gooy, por re kuu ntsowʼn gwalaaz goo kuu nin. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Wlipaa na nin, loka zha kuu nyelaaz na, no zha tetsow zha re kuu ntsowʼn, ne masraa kuu thoz tsow zha, tak lee na ndyan lo Xutʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ne reta kuu naab goo lo Xutʼn por len, tetsow nay, tsa gak nataak Xutʼn por na. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Os naab goo thib kuu por len, tetsow nay. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Os lee re goo nke leettsoo goo na, bin goo diiz re kuu mnabeen lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ne lee na nal naabʼn lo Xutʼn, tsa taal Xutʼn Mbi Nayon, par tsow ayud goo ne thibka to lo goo, ");
INSERT INTO zaoNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ne Mbi ree nak Mbi Nayon kuu wli ne gagt kayaa re men yezlyu Mbi ree, tak nloot Mbi lo zha ne neeka nlebeet zha Mbi, per lee re goo nlebee goo Mbi, tak lo goo ndo Mbi, ne thitanax ban Mbi leettsoo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Latʼn goo taxal btab, bren tedib welt tsa ton kon re goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Telutta ne lee re men yezlyu ree wiit raa na; per lee re goo tewii goo na ne taban goo, tak lee na naban na. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ne wiza lee re goo ne, lee na nzon leettsoo Xutʼn, ne lee re goo nzo leettsoon, ne lee na nzo leettsoo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ne loka zha kuu nkayaa re kuu nabeen ne nzhon zha diize, zhaʼa nak zha kuu wlipaa nke leettsoo na; ne lee zha kuu nke leettsoo na nke leettsoo Xutʼn zhaʼa ne noga na nke leettsoon zhaʼa, ne lon na lo zha, tsa mas wen lebee zha na. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tsa lee Judas (kuu nagt Judas Iscariote), mnaabdiz lo Jesús ne nzhab: ―Zha Nabee, ¿chebee looʼa lu lo nee, ne lee lo re zha yezlyu loota lu? ");
INSERT INTO zaoNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Lee Jesús mkab ne nzhab: ―Lee zha kuu nke leettsoo na nzhon zha diiz kuu nabeen; ne lee Xutʼn nke leettsoo Xutʼn zhaʼa, ne lee rop nee Xutʼn yaad nee yo nee kon zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Lee zha kuu nket leettsoo na, nzhont zhaʼa diiz lon. Lee re diiz kuu ngeyon goo ngenin, nagte xkizʼn, leey nak xkiiz Xutʼn kuu mtaalʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Nal ndon lo goo ngenin re koree lo goo, ");
INSERT INTO zaoNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","per lee Mbi Nayon kuu taal Xutʼn par kenap re goo kwent chaan da, lee Mbi loo reta kuu lo goo, ne tsow Mbi telaaz goo reta kuu mnin lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Lee na ndyan, per nlazʼn wen kwin goo, ne tsowʼn tsa wen kwin goo, per tsowt nay taxal ntsow re men yezlyu reey. Yat leettsoo goo ne neeka tsebt goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mbina goo nin, lee na ndya ne bren yalʼn tedib welt. Os lee goo wlipaa nke leettsoo goo na, kwathoz naley gayoo leettsoo goo mbin goo lee na ndya lo Xutʼn, tak masraa nataak Xutʼn nake na. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ne nal nin re koree lo goo, tsa leettsa gake yelaaz goo na. ");
INSERT INTO zaoNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Telutta tedizʼn lo goo, tak ndyaada Maxuuy kuu nabee lo yezlyu ree. Ne tegal neeka lut yalnabee napt Maxuuy par nabee Maxuuy lon, ");
INSERT INTO zaoNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","per tabaa ndoblo gake. Tsa lee re men yezlyu ree ne lee na nke leettsoon Xutʼn, ne ntsowʼn re kuu mtaal Xutʼn na tsowʼn. Tsa nzhab Jesús: ―Gwateli goo nda goo reʼaa. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Noga nzhab Jesús: ―Na wlipaa nakʼn taxal thib xann luts ub, ne Xutʼn nak kuu ntenaa luts. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ne os lee thib zhit luts ndaate xle, thitanax nchuug Xut nay. Per lee zhit kuu ndaa xle, ntembi Xut nay tsa ke masraa xley. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ne lee goo nambiʼa goo por re diiz kuu mnin lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Thibka gwato goo lon, taxal thibka ndon kon goo. Taxal thib zhit gagt taay xle os leey ndobte lo luts; tataka gagt taa goo xle, os lee goo ndot goo kon na. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Na nak taxal xann luts ta mas nachaa, ne lee re goo nak taxal re zhit luts. Kona lee re zha kuu thibka ndo kon na, ne lee na thibka ndo kon lee zha kwathoz xle ndaa zha, tak os lee goo ndot goo kon na, yent kwan tak tsow goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tak lee zha kuu ndot kon na, zhaʼa nak taxal thib zhit ya kuu mlobi zha kwatxa tsa bize, ne tsaraa nthop zhay ngo zhay lo ki ne nzheeke. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Os lee goo thibka ndo goo kon na, ne ntsow goo kuu mnabeen lo goo, bnaab goo loka kuu nlaaz goo lon ne lee na tay. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tsa lee re men tsow nataak Xutʼn leettsa wii zha lee re goo ndaa xle, ne os lee goo ndaa goo xle, wlipaa nak goo zha kuu ngeteed lon. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ne nke leettsoon goo taxal nke leettsoo Xutʼn na, ne thibka gwato goo lo yalnkelaaz da. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Os nzhon goo diiz re kuu nabeen lo goo, tsasi wlipaa ndo goo loo yalnkelaaz da, leeka taxal nzhon na diiz ntsowʼn re kuu nabee Xutʼn lon, ne thibka ndon lo yalnkelaaz chaan Xutʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Mnin koree lo goo, tsa yo yalnaley chaan da leettsoo goo, tsa thibka naley yo leettsoo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Lee kuu nabeen lo goo nak koree: Bke leettsoo goo thib goo ne tedib goo, taxal nke leettsoon goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Lee yalnkelaaz kuu mas nataak nak, leettsa lee thib zha taa zha zha gath zha por amig zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Goo nak amig da, os lee goo ntsow goo kuu mnabeen lo goo tsow goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ne nitʼn lo goo lee goo nak mos da, tak lee mos net mos naa kwan ntsow patron mos. Amig nin lo goo, tak reta kuu ne Xutʼn lon mniʼa nay lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Goot mlin, sinke na mli goo par taa goo kwathoz xle, ne lee xle kuu taa goo, gak xle kuu xek thitanax; tsa lee Xutʼn taa lo goo, reta kuu naab goo lo Xutʼn por len. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Koree nak kuu nabeen lo goo: Bke leettsoo goo thib goo ne tedib goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Os lee re men yezlyu ree yii ne goo, nlazʼn ne goo, na nayii zha ne zha os lee zha yii zha ne zha goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Os lee goo gagak goo zha yezlyu ree, kwathoz ke leettsoo re men yezlyu ree goo, taxal nke leettsoo zha re zha zha, per tak mlin goo xid re men yezlyu ree, kona nayii re men yezlyu ree ne goo, tak nagt raa goo zha yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Btelaaz goo kuu mnin lo goo: “Neeka thib mos nataagt mos masraa nake patron mos”. Ne os mreke zha ditsʼn, noga dits goo tereke zha, ne os lee zha mbin zha diiz xkizʼn, noga tonga zha diiz xkiiz goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Reta koree tsowno zha goo por na, tak nlebeet zha naa cho mtaalʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Os gayaltʼn ne os ganitʼn lo re men, neeka thib falt napt re men. Per nal nap zha falt ne yent kwan kuu kelo zha, tak mniʼa na lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Loka zha kuu nayii nen, noga nayii zha ne zha Xutʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ne gagapt re men falt, os gatsowtʼn re kuu thoz lo re zha, re kuu neeka thib zha gagt tsow. Per nal mwiiʼa zha mtsowʼn re kuu thoz, ne tegal mwii zhay, nayii zha ne zha na ne Xutʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Per lee re koree ngeyak tsa gak re kuu nke lo ley: Yent xkwan ne nayii zha ne zha na. Sal. 35:19; Sal. 69:4 ");
INSERT INTO zaoNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Per leettsa yaad Mbi Nayon tetsey leettsoo goo, Mbi kuu taalʼn lo goo por Xutʼn, Mbi kuu wlipaa roo lo Xutʼn, lee Mbi taa kwent chaan na lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ne no goo taa kwent chaan da, tak desde ner ndo goo kon na. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Nin re koree lo goo, tsa thib to goo yelaaz goo na. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tak tagoo zha goo ta nteed zha xkiiz Diox, noga tetsin or o wiz ndota zha kuth thib goo, tak tsow zha xgab ngetsow zha kuu nyow leettsoo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Tata tsow zha tak nlebeet zha Xutʼn ne neeka na. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nin koree lo goo, tsa leettsa gake, telaaz goo lee na mniʼa nay lo goo, ne mnitʼn koree lo goo ner, tak ndon lo goo tsya. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ne noga nzhab Jesús: ―Per lee nal leen ndya lo Xutʼn kuu mtaalʼn, ne ¿chu neeka thib goo naabdizt lon naa pa ndyan? ");
INSERT INTO zaoNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Leel nabil nzo leettsoo goo, tak nin koree lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Per kuu wli nin lo goo, mas wen ndyan. Tak os leen bitʼn yaadt Mbi kuu tsow ayud goo, per os leen bin, na taal Mbi. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ne leettsa yaad Mbi, nambi loo Mbi re kuu went, re kuu wli ne kuu wen lo re men yezlyu ree, ne loo Mbi xomod naab Diox kwent lo re men yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Lee Mbi Nayon loo lo re zha lee zha went nak zha, tak nyelaazt zha na. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ne lee Mbi Nayon loo lo re zha lee na wen nakʼn, tak lee na ndyan lo Xutʼn ne wiit raa goo na; ");
INSERT INTO zaoNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ne lee Mbi Nayon loo lo re men yezlyu ree, naa xomod naab Diox kwent lo reta men, tak mnaaba Diox kwent loo Maxuuy kuu nabee lo yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Kwathoz kuu nzo nin lo goo, per gagt nin rey lo goo nal, tak gagt yen gooy os ni nay lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Per leettsa yaad Mbi Nayon kuu wlipaa, tsa loo Mbi re kuu wli lo goo, tak nit Mbi por leeka lee Mbi, sinke lee Mbi taa kwent beeta re kuu gon Mbi, tsa ne Mbi re kuu gak lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Lee Mbi tsow tsa tsow nataak re men na, tak kayaa Mbi kuu nak chaan da kuu wli tsa ne Mbi Nayone lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Reta kuu nap Xutʼn nak chaan da, kona nin lo goo lee Mbi Nayon kayaa kuu nak chaan da ne taa Mbi Nayone lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Telutta ne wiit raa goo na, per telut bluz lee goo bre wiiʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tsa lee chop tson zha kuu ngeteed lo Jesús, mndelo zha mnaabdiz zha lo altaa ne nzhab zha: ―¿Kwan nlaaz Jesús ne, ne chebee mbez Jesús? Telutta ne wiit raa goo na ne telutta lee goo bre wiin, ne ¿chebee mbez Jesús ndyan lo Xutʼn? ");
INSERT INTO zaoNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Kwan nlaaz Jesús ne, ne chebee mbez Jesús: “telutta”? Nyentaa kuu ndediz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Per myeen Jesús lee re zha nlaaz naabdiz lo Jesús, tsa nzhab Jesús lo re zha: ―Na ni lo goo telutta ne wiit raa goo na, ne telut bluz bre goo wii goo na tedib welt, ¿chu nyent goo koree? ");
INSERT INTO zaoNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Wlipaa na nin, lee re goo gonn goo ne nabil yo leettsoo goo, per lee re men yezlyu ree naley yo leettsoo zha. Per tegal nabil yo leettsoo goo, ne lee yalnabil kuu yo leettsoo goo gak yalnaley lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Leettsa gal zhiinn thib ngot, nlaaz leettsoo ngot tak mzina or kuu gal zhiinn ngot, per leettsa ngwalo ngol zhiinn ngot, nithlaaz ngot yalnlaaz, tak kwathoz naley nzo leettsoo ngot, tak ngola zhiinn ngot. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ne leeka tata nabil nzo leettsoo goo nal, per tebreʼaa tsaalaa tedib welt. Tsa lee re goo kwathoz naley yo leettsoo, ne yent cho kib yalnaleya leettsoo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Ne wiza yent raa kwan naabdiz goo lon. Wlipaa na nin, lee Xutʼn taa reta kuu naab goo lo Xutʼn por len. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Asta nal, neeka thib kuu ter naab goo por len, bnaab gooy ne tekayaa gooy, tsa kwathoz naley yo leettsoo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Reta koree nin lo goo kon diiz nanzee, per tetsin wiz kuu niit raa na lo goo kon diiz nanzee, sinke nambita nin kwent chaan Xutʼn lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ne wiza lee re goo naab kuu lo Xutʼn por len, ne niitʼn lo goo lee na naabʼn lo Xutʼn por re goo, ");
INSERT INTO zaoNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","tak nke leettsoo Xutʼn goo. Ne nke leettsoo Xutʼn goo, tak nke leettsoo goo na, ne nyelaaz goo leen mroo lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Lo Xutʼn mroon ndyalʼn lo yezlyu ree, ne lee nal lan yezlyu ree ne bren ndyan lo Xutʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tsa lee re zha kuu ngeteed lo Jesús nzhab: ―Nalsi nambita ngeniʼa loo nee, ngenit raa lu kon diiz nanzee. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nalsi ne nee lee lu ne reta kwaa, ne ndechet naabdiz neeka thib zha loʼa. Kona nyelaaz nee lee Diox mtaala. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús mkab ne nzhab lo re zha: ―¿Chu nalsi nyelaaz goo lee Diox mtaalʼn? ");
INSERT INTO zaoNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Per mzina or kuu lee re goo raats, kadta goo ndya goo liz goo ne laa goo thita na. Per ndotʼn thita na, tak lee Xutʼn ndo kon na. ");
INSERT INTO zaoNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Reta koree ngenin lo goo, tsa yat leettsoo goo tak nyelaaz goo na. Lo yezlyu ree teriid goo yalti, per tsebt goo, tak mtsowa na gan lo yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Or ngwalo nzhab Jesús re koree, tsa mwii Jesús lobee, ne nzhab Jesús: ―Xutʼn, nalsi mzina or kuu leen rid yalti, btsow tsa tsow nataak re men xganna. Tsa noga xganna tsow tsa tsow nataak zha lu. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Lu mndaa yalnabee lon, tsa nabeen lo reta men yezlyu ree, tsa tan yalnaban kuu thitanax lo re zha kuu mndaaʼa lon. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Lee yalnaban ree nak, lebee re zha lee lu nak thibka Diox kuu wlipaa ne Jesucrist kuu mtaala. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Mtsowa tsa tsow nataak re mena lo yezlyu ree, tak mtsowa na re kuu mtaala na tsowʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kona Xutʼn, taa yalnabee lon, yalnabee kuu mkenon leettsa mndon loʼa, leettsa terka texkwaa yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Mloon naa cho naka lo re zha kuu mliʼa, re zha kuu mndaaʼa lon, tak zhaʼa nak zha ne mndaaʼa zha lon ne mbin zha diiz xkiiza. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Lee nal neʼa zha lee reta kuu mndaaʼa lon chaana nake. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tak nzhapa na lo re zha re kuu neʼa lon, mbina zhay ne wlipaa ne zha loʼa mroon ne wlipaa ngwalaaz zha lee lu mtaalʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Ngenaabʼn loʼa tsa kenapa re zha ree, per ngenaabtʼn loʼa por reta men yezlyu, sinke ngenaabʼn loʼa, tsa kenapa re zha kuu mndaaʼa lon, tak zhaʼa nak re zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Reta zha da nak zhaʼa ne reta zhaʼa nak zha da, ne lee re zha ree ntsow nataak zha na. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Ya yetot raa na lo yezlyu ree, per lee re zha ree bee nzi zha lo yezlyu ree, lee na ndyal loʼa Xutʼn kuu nayon, bkenap re zha kon yalnabee chaana kuu mndaaʼa lon, tsa thibka gak zha re zha taxal thibka nakaa ropaa. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","’Leettsa mndon kon re zha kuu mndaaʼa lon lo yezlyu ree, tsa mkenapʼn re zha kon yalnabee chaana kuu mndaaʼa lon. Ne neeka thib zha kuu mndaaʼa lon mluuxt, beeta zha kuu naka diiz lux mlux, tsa ngok kuu nke lo xkeetsa. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Ne lee nal beren loʼa, per nal kuu bee ndon lo yezlyu ree, ngenin koree, tsa kwathoz naley yo leettsoo re zha, taxal naley nzo leettsoon. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Na mndaa kwent xkiiza lo re zha, per lee re men yezlyu nayii ne re zha, tak nagt zha zha yezlyu ree, taxal nagt na zha yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ngenaabtʼn loʼa kooʼa zha lo yezlyu ree, sinke ngenaabʼn loʼa tsa kenapa zha lo Maxuuy. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Leeka taxal nagtʼn zha yezlyu ree, noga re zha nagt zha zha yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Btembi re zha kon xkiiza kuu wli nak. Tak xkiiza nak kuu wli. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Leeka taxal mtaala na lo re men yezlyu ree, tabaaka taalʼn re zha lo re men yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ne por re zha ree, ntembin na leeka na, tsa noga re zha gak nambi zha por xkiiza kuu nak kuu wli. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Ne ngenaabtʼn loʼa kenapa beeta re zha ree, sinke ngenaabka na loʼa tsa kenapa re zha kuu yelaaz na bluz por xkiiz re zha ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Xutʼn naabʼn loʼa, tsa gak re zha ree taxal nakaa ropaa, nzoʼa leettsoon ne nzon leettsooʼa, ne naabʼn tsa wlipaa yo re zha leettsooʼa ne leettsoon, tsa yelaaz re men yezlyu ree lee lu mtaalʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ne ntsow nataak na re zha, taxal ntsow nataaka na, tsa thibka gak re zha, taxal thibka nakaa ropaa. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Na nzo leettsoo re zha ne lu nzo leettsoo na, tsa wlipaa gak re zha thibka, tsa lee re men yezlyu ne lee lu mtaalʼn, ne ne re men yezlyu ree nke leettsooʼa re zha, taxal nke leettsooʼa na. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Xutʼn, nlazʼn lee reta zha kuu mndaaʼa lon kwin zha ta ndon, tsa wii re zha yalnabee kuu mndaaʼa lon; leettsa terka texkwaaʼa yezlyu, nkeʼa leettsooʼa na. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Xutʼn nali naka, lee re men yezlyu ree nlebeet zha lu, per lee na nlebeen lu, ne noga re zha ree ne zha lee lu mtaalʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mloon lo re zha naa cho naka, ne teloo raa nay, tsa taxal nke leettsooʼa na, ke leettsooʼa re zha, ne lee na to kon re zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Leettsa ngwalo mndediz Jesús lo Diox, tsa mroo Jesús kon re zha kuu ngeteed lo Jesús, ne ndano Jesús re zha tedib lad roo bte kuu le Cedrón. Tya nak leen thib alo. Ne tya mndaab Jesús kon re zha kuu ngeteed lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Noga Judas kuu mndaa Jesús lo re zha nak tsiin nlebee tya, tak tyen welt mrin Jesús kon re zha kuu ngeteed lo Jesús tya. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Tsa mzin Judas kon thiban soldad ne kon tyen zha kuu nkenap gwodoo; ne re ngwleyy kuu nabee lo re ngwleyy kon re fariseo mtaal re zhaʼa, ne ne zha yiib, kandil ne yerbel. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Per neʼa Jesús naa kwan rid Jesús, tsa mroo Jesús ne nzhab Jesús lo re zha: ―¿Cho nkwaan goo? ");
INSERT INTO zaoNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Lee re zha mkab ne nzhab: ―Lee nee nkwaan Jesús zha kuu nak zha yez Nazaret. Lee Jesús nzhab lo re zha: ―Na nak Jesús. Ne no Judas kuu mndaa Jesús ndyaad kon re zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ne leettsa nzhab Jesús lo re zha, na nak Jesús, tsa mre ardits re zha ne ngob zha lo yu. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tsa mre Jesús mnaabdiz lo re zha ne nzhab: ―¿Cho nkwaan goo? Lee re zha mre mkab ne nzhab: ―Lee nee nkwaan Jesús zha yez Nazaret. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Tsa nzhab Jesús lo re zha: ―Niʼa na lo goo, na nak Jesús. Os lee goo nkwaan goo na, laa goo bi re zha ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Koree ngok, tsa mrolo kuu nzhab Jesús, Xutʼn lee re zha kuu mndaaʼa lon, neeka thib zha mluxt. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tsa lee Simún Pey nkeno thib espad, ne mloo Pey espad ne mchuug Pey nza ban thib zha kuu lee Malco kuu nak mos ngwleyy kuu nabee lo reta ngwleyy. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Tsa nzhab Jesús lo Pey: ―Pey blotsow espada. Os lee Xutʼn nlaaz riidʼn yalti, ¿chu nda leettsooʼa riidt nay? ");
INSERT INTO zaoNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tsa lee re soldad, re zha kuu nabee lo re soldad ne re polisi kuu nkenap gwodoo, mzhen re zha Jesús ne mliib zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tsa ner ndano zha Jesús liz Anás, tak lee Anás nak xutsaap Caifás kuu nak ngwleyy kuu nabee lo reta ngwleyy liina. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ne leeka Caifás nak kuu nzhab lo re zha Israel, mas wen gath thibka zha por dita yez, nake gath reta zha yez. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Tsa lee Simún Pey ne thib zha kuu ngeteed lo Jesús mndeke dits Jesús. Tak lee tedib zha kuu ngeteed lo Jesús nlebee zha ngwleyy kuu nabee lo reta ngwleyy, kona mndaab zha kon Jesús lee roo yuu. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Per lee Pey myaan lee dits pwert, tsa lee zha kuu mteed lo Jesús kuu nlebee ngwleyya, mni lo mos got kuu nkenap roo pwert, tsa taa ngot diiz tab Pey. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tsa lee ngot kuu nkenap roo pwert nzhab lo Pey: ―¿Chu nota nak thib re zha kuu ngeteed lo mbyi baa? Lee Pey mkab lo ngot ne nzhab: ―Aha not na. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ne tak kwathoz nal, tsa lee re mos ne re polisi kuu nkenap gwodoo mtee bel, ne ngebiz re zha ne noga Pey ndo lo re zha ngebiz. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tsa lee ngwleyy kuu nabee lo reta ngwleyy mndelo mnaabdiz lo Jesús, kwent chaan re zha kuu mteed lo Jesús ne kwent leyy kuu nloo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Lee Jesús mkab ne nzhab: ―Na ndedizʼn delant lo reta men, thibka nloon lo re men ta nkaltaa zha nteed zha xkiiz Diox, ne roo gwodoo ta nkaltaa reta zha Israel, neeka thib kuu mlootʼn lo re men xgaatsta. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Chebee lon naabdiza? Bnaabdiz lo re zha kuu mbin kuu mnin. Re zhaʼa tak ne naa kwan nzhapʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Or nzhab Jesús kona, tsa lee thib zha kuu nkenap gwodoo mkaan yaa lo Jesús ne nzhab: ―¿Chu tabaa nkaba lo ngwleyy kuu nataak? ");
INSERT INTO zaoNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Lee Jesús mkab ne nzhab: ―Os mnin thib kuu mal, bne lon naa kwan kuu mal mnin; per os kuu wli mnin, ¿chebee nkee luy yekʼn? ");
INSERT INTO zaoNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tsa naliibka Jesús mtaal Anás Jesús lo Caifás kuu nak ngwleyy kuu nabee lo reta ngwleyy. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ne lee Pey ngebizka lo ki tya, tsa mnaabdiz zha lo Pey ne nzhab zha: ―¿Chu nota nak thib re zha kuu ngeteed lo mbyi baa? Tsa lee Pey mkab ne nzhab: ―Not na. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tsa mnaabdiz thib mos kuu nke tsiin lo ngwleyy kuu nataaka lo Pey ne nzhab mos: ―¿Chu lut kuu ndo leen alo kon Jesús? Mosa nak zha liz zha kuu mchuug Pey nza. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Tsa lee Pey nzhab tedib welt, nlebeet Pey Jesús, ne oraaka lee ngite mrez. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tsa mloo zha Jesús liz Caifás, ne ndano zha Jesús roo yuulow, ta ndob zha kuu nabee ne tak ndeyeniʼa yezlyu, kona mndaabt re zha Israel leen yuulow, tsa nambika zha ley lo zha, tsa tak wu zha rtsee chaan Paskw. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Tsa mroo Pilat, ne nzhab Pilat lo re zha: ―¿Cho kwent nkeki goo mbyi ree? ");
INSERT INTO zaoNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tsa mkab re zha, ne nzhab zha: ―Os gagagt zha ree zha nakap, gayaadnot nee zha loʼa. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tsa nzhab Pilat lo re zha: ―Bteno goo zha, bnaab goo kwent lo zha taxal nzhab lo ley chaan goo. Tsa lee re zha mkab ne nzhab: ―Lee re nee zha Israel, napt nee yalnabee par kuth nee thib men. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tata nzhab zha, tsa ngok kuu nzhab Jesús, leettsa mndaa Jesús kwent naa xomod gath Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Per lee Pilat mre mndaab leen yuulow, ne mrez Pilat Jesús ne mnaabdiz Pilat lo Jesús ne nzhab Pilat: ―¿Chu lu nak rey chaan re zha Israel? ");
INSERT INTO zaoNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Lee Jesús mkab ne nzhab: ―¿Chu naabdiza koree por lu, o tak tedib net zha ney loʼa? ");
INSERT INTO zaoNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Tsa lee Pilat mkab ne nzhab: ―¿Chu zha Israel nakʼn? Lee re tawlaza ne re ngwleyy kuu nabee lo re ngwleyy mndaaʼa lon. ¿Kwan mtsowa? ");
INSERT INTO zaoNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Lee Jesús mkab ne nzhab: ―Nagt lo yezlyu ree ta nabeen, os lo yezlyu ree gagak ta nabeen, tsa lee re zha kuu nak zha da, gayo zha ne galaat zha na lo re tawlazʼn. Per lee ta nabeen nagte lo yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tsa lee Pilat nzhab lo Jesús: ―¿Mbay rey naka tsa? Tsa lee Jesús mkab ne nzhab: ―Wli kuu neʼa, rey nakʼn. Par kona ngolʼn ne par kona ndyalʼn lo yezlyu ree; par tan kwent kuu wli lo re men. Ne reta zha kuu nyelaaz kuu wli nzhon zha diiz xkizʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Tsa nzhab Pilat lo Jesús: ―¿Kwan nak kuu wli? Or ngwalo mnaabdiz Pilat koree, tsa mroo Pilat ne mni Pilat lo re zha Israel tedib welt, ne nzhab Pilat: ―Neeka thib kuu went mtsowt mbyi ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Per lee re goo nap goo costumr, telaan thib zha kuu nzo tsib lo ani Paskw. ¿Chu nlaaz goo telaan zha kuu nak rey chaan re zha Israel? ");
INSERT INTO zaoNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tsa reta zha mre nzhab: ―¡Telaata zha baa! ¡Barrabás btelaa! Ne Barrabás nak thib wann. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tsa ndano Pilat Jesús, ne mnabee Pilat mdin zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ne lee re soldad mdexkwaa thib koron kon yits ne mtob re soldade yek Jesús, ne mtegok zha Jesús thib lar kuu nane na. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tsa mbig re zha lo Jesús ne nzhab zha: ―¡Kuubidoo rey chaan re zha Israel! Ne mkaan yaa zha kwat Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Tsa lee Pilat mre mroo tedib welt, ne nzhab lo re zha: ―Wii goo, mloon zha tsa ne goo, neeka thib kuu mal mtsowt zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ne ndob koron yitsa yek Jesús ne nok Jesús lar naneʼa mroo Jesús. Tsa lee Pilat nzhab lo re men: ―¡Wii goo, lee zha ndo nzhee! ");
INSERT INTO zaoNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Leettsa mwii re ngwleyy kuu nabee lo re ngwleyy ne re soldad kuu nkenap gwodoo lo Jesús, ora mrez re zha ne nzhab: ―¡Bkee zha lo kruz! ¡Bkee zha lo kruz! Tsa nzhab Pilat lo re zha: ―Bzhen goo zha ne bkee goo zha lo kruz, tak lee na mzaltʼn neeka thib kuu went kuu mtsow mbyi ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Per lee re zha Israel mkab ne nzhab: ―Lee re nee nap nee thib ley, ne lee lo ley chaan nee mbez ndoblo gath zha, tak ni zha lee zha nak Xgann Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Or mbin Pilat kona masraa mzeb Pilat. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Tsa mre Pilat mndaab leen yuulow tedib welt, ne nzhab Pilat lo Jesús: ―¿Cho zha naka? Per lee Jesús mkabt lo Pilat. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tsa nzhab Pilat: ―¿Chebee nkabta lon? ¿Chu neta napʼn yalnabee par keen lu lo kruz ne napʼn yalnabee par telaan lu? ");
INSERT INTO zaoNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tsa lee Jesús mkab ne nzhab: ―Gagt nabeeʼa, os lee Diox gataat yalnabee loʼa; per masraa falt nap zha kuu mndaan loʼa nake lu. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ne desde ora mkwaan Pilat mod par gatelaa Pilat Jesús; per lee re zha Israel mre mrez ne nzhab: ―¡Os leeʼa telaaʼa zha baa, nagta amig zha kuu nabee Roma! ¡Tak loka zha kuu mbez nak rey, zhaʼa nzhak zha kuu nayii ne zha kuu nabee dita ta nabee Roma! ");
INSERT INTO zaoNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Or ngwalo mbin Pilat kona; tsa mnabee Pilat mloo zha Jesús par lee ne mndob Pilat ta nyetob Pilat naab Pilat kwent lo re men, thib lee ta natexkwaa kon thib lo ke; ne lee diiz hebreo ley Gabata. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Teeka ndrol wiz ngok koree, wiz kuu ndelo zha ndexkwaa zha re kuu par ani Paskw. Tsa nzhab Pilat lo re zha Israel: ―¡Lee rey goo baa! ");
INSERT INTO zaoNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Per lee re zha mkab nzhab: ―¡Ndoblo gath zha! ¡Ndoblo gath zha! ¡Bkee zha lo kruz! Lee Pilat nzhab lo re zha: ―¿Chu rey goo nlaaz goo keen lo kruz? Tsa lee re ngwleyy kuu nabee lo re ngwleyy, mkab ne nzhab: ―¡Napt nee tedib rey, beeta César kuu nabee Roma nak rey nee! ");
INSERT INTO zaoNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tsa mndaa Pilat Jesús lo re zha, tsa kee zha Jesús lo kruz, ne mzhen zha Jesús ndano zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ne mbe Jesús kruz Jesús asta thib ta le tsidth yek men, (ne lee diiz Hebreo ley Gólgota). ");
INSERT INTO zaoNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tya mkee zha Jesús lo kruz kon techop zha, mkee zha thibga kad lad cho Jesús tsa myaan Jesús xtow rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Tsa mnabee Pilat mkee zha thib letr yek kruz, kuu nzhab: “JESÚS ZHA NAZARET, REY CHAAN RE ZHA ISRAEL”. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Kwathoz re zha Israel mlab kuu mkee zha yek kruz, tak gax yez Jerusalén nak ta mkee zha Jesús lo kruz, ne lee letr mkee zhay kon diiz Hebreo, kon diiz Latín ne kon diiz gryeg. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tsa lee re zha Israel ne re ngwleyy kuu nabee lo re ngwleyy; nzhab lo Pilat: ―Keeta: “Rey chaan re zha Israel”, sinke bkee: “Zha kuu mbez nak rey chaan re zha Israel”. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Per lee Pilat mkab ne nzhab: ―Kuu mkeen, mkeeʼa nay ne tabaaka yaane. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Bluz or ngwalo mkee re soldad Jesús lo kruz, tsa mzhen re zha xab Jesús, ne mtsow zhay thap le, ne thibga ley mkaa thibga soldad. Ne noga mzhen zha tedib xab Jesús, kuu nak thib lar kuu asta yek ne asta xann yent pa nadibe. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Tsa nzhab re soldad lo re altaa zha: ―Chatta lee lar ree, mas wen kooʼaa swert, tsa naa choʼa diinne. Ne tata ngok kuu nzhab lo xkiiz Diox: “Mdid zha xabʼn lo re zha, ne mloo zha swert dits xabʼn”. Sal. 22:18 Ne tata mtsow re soldad. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ne gax lo kruz ndo xnaa Jesús, bel xnaa Jesús, Mari tsaal Cleofas ne Mari Magdalen. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ne or mwii Jesús lo xnaa Jesús, ne leeka tya ndo zha kuu mteed lo Jesús zha kuu kwathoz nke leettsoo Jesús, tsa nzhab Jesús lo xnaa Jesús: ―Lee xganna baa. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ne oraaka nzhab Jesús lo zha kuu ngeteed lo Jesús: ―Lee xnaaʼa baa. Ne desde tsyatha lee zha kuu mteed lo Jesús mkayaa xnaa Jesús lize. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Leettsa ngwalo mriid re koree, neʼa Jesús lee re kuu nke lo xkeets Diox kwent Jesús ngwaloʼa ngok, ne par yelo gak re kuu nzhab lo xkeets Diox, tsa nzhab Jesús: ―Nzheek leettsoon. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ne tya ndo thib jar kuu tse nzo xit ub kuu ni; tsa mtenit zha thib le zhiil leen xit uba, ne mtob zhay yek thib lee ya kuu le hisopo, ne mtob zhay roo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tsa ngwii Jesús xit ub kuu niʼa ne nzhab Jesús: ―¡Retay ngwaloʼa ngok! Ora mkiits yek Jesús ne nguth Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Re koree ngok wiz kuu ndelo zha ndexkwaa zha kuu wu zha lo ani Paskw, ne nlaazt re zha Israel yaan re kwerp lo kruz, wiz sabd kuu nzhool re zha Israel lo Diox, tak lee wiza nak thib wiz ro lo re zha Israel, kona mnaab re zha lo Pilat, tsa nabee Pilat yakiits zha nii re yon zha kuu nke lo kruz ne la zha re kwerp re zhaʼa lo kruz. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tsa lee re soldad ngwa mdiizts nii rop zha kuu mke lo kruz cho Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Per or mbig re zha lo Jesús, mwii zha ngutha Jesús, kona mdiizts zha nii Jesús: ");
INSERT INTO zaoNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Per lee thib re soldad mtsib thib le ya roo leettsoo Jesús ne ora mroo ren ne nit leettsoo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ne na nak zha kuu mwii re koree ne ndan kwente, ne wli kuu ndan kwent; ne nen wli kuu mwiin ne kuu ndan kwent; tsa no goo yelaaze. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ne re koree ngok, tsa ngok re kuu nke lo xkiiz Diox; kuu nzhab: “Kiizt zha neeka thib tsidth zha”. Sal. 34:20 ");
INSERT INTO zaoNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ne lee tedib ta nzhab: “Wii re zha lo zha kuu mtsib zha thib le ya roo leettsoo”. Zac. 12:10 ");
INSERT INTO zaoNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ngwalo mriid re koree, tsa lee Che zha yez Arimatea, mnaab lo Pilat, tsa taa Pilat diiz gwe Che kwerp Jesús. Noga Che ree nak thib zha kuu mteed lo Jesús, per xgaatsta nteed zha, tak nzeb zha ne zha re zha Israel. Tsa mndaa Pilat diiz lo Che, tsa ngwa Che ne mbe Che kwerp Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ne noga ngwa Nicodemo kuu ngwa gwatediz kon Jesús thib yaal, ne ngwano Nicodemo teeka galbtsii kil perfum kuu chul ndetsi, kuu natexkwaa kon thib lo ya kuu le mirra, ne kon thib lo ya kuu le áloe. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tsa lee Che rop Nicodemo mbe kwerp Jesús, ne mchiix zha kwerp Jesús kon lar kuu ndo perfum kuu chul ndetsi, taxal ntsow re zha Israel leettsa nkaats zha thib thebol. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ne leeka ta mkee zha Jesús lo kruz, ndob thib wert, ne leen werta ndob thib baa kuu kub, kuu neeka thib zha ter yo. ");
INSERT INTO zaoNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ne tya mloo rop zha kwerp Jesús, tak gax tya ndob baa, ne tak mera telo wiz sabd kuu nzhool re nee zha Israel lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ner wiz kuu ndelo sman, lee Mari Magdalen ngwa roo baa kwathoz til, or kuu bee nakow raa na; ne mwii Mari yenta ke kuu now roo baa. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tsa lijer ndya Mari ta ndo Simún Pey kon na, ne ne Mari lo rop nee: ―Mlooʼa zha Jesús Zha Nabee leen baa, ne netaa pa ngwalaa zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tsa mroo rop nee Pey ne ngwa nee roo baa. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ne lijer nda nee rop nee, per masraa lijer ndan nake Pey, ne nerʼn mzin roo baa. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tsa mkiitsʼn yekʼn ne mwiin, tsa mwiin re lar kuu mchiix zha Jesús, per mndaabtʼn leen baa. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tsaraa mzin Simún Pey ne mndaab Pey leen baa. Ne noga Pey mwii re lar kuu mchiix zha Jesús; ");
INSERT INTO zaoNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ne noga mwii Pey lar kuu mchiix zha yek Jesús ne nzibte thibka kon lar kuu mchiix zha Jesús, sinke leey nayiits ne zhaata nzibe. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tsa no na mndaab leen baa; tsa mwiin ne ngwalaazʼn kuu ngok. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tak ter yen na kuu mbez lo xkiiz Diox, kuu nzhab lee Jesús ndoblo roban xid re zha nguth. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ora lee rop nee Pey ndya nee liz nee. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Per lee Mari Magdalen myaan par dits gax roo baa, ne nzhonn Mari ne nkiits yek Mari mwii Mari leen baa. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Tsa ngwani chop mandad chaan Diox lo Mari, rop mandad nok lar kuu nakits na ne rop mandad ndob ta mxoob zha kwerp Jesús, thib zha ndob ta mzhoob yek Jesús, lee tedib zha ndob ta mzhoob nii Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tsa nzhab rop mandad lo Mari: ―¿Chebee nzhonna? Lee Mari mkab ne nzhab: ―Nzhonn na tak mbe zha Zha Nabee lon, ne netʼn pa ngwalaa zha zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ne ngwalo nzhab Mari koree, tsa mtsere lo Mari, ora mwii Mari lee Jesús ndo tya; per net Mari Jesúse. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Tsa nzhab Jesús lo Mari: ―¿Chebee nzhonna? ¿Cho nkwaana? Per lee Mari mtsow xgab zha kuu nkenap wert mni lo Mari. Tsa nzhab Mari: ―Os lu mbe zha, ne lon naa pa ngwatana zha, tsa gwen zha. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tsa lee Jesús nzhab lo Mari: ―¡Mari! Ne lee Mari mtsere lo, ne diiz Hebreo nzhab Mari: ―¡Raboni! ―diz ree nak maestr. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Lee Jesús nzhab lo Mari: ―Keezta na, tak ter ndyan lo Xutʼn, per gwa ne guz lo re wetsʼn, lee na ndyan lo Xutʼn kuu nak Xut goo, lo Diox kuu nak Diox da ne Diox kuu nak Diox goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tsa lee Mari Magdalen, myaadne lo re nee kuu mteed lo Jesús, lee Mari mwii Jesús Zha Nabee; ne ne Mari lee Jesús nzhab re koree lo Mari. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ne leettsa mziy yezlyu wizaka, kuu nak ner wiz sman, lee re nee zha kuu mteed lo Jesús, mkaltaa nee leen thib yuu ne mtow nee roo yuu, tak nzeb nee ne nee re zha Israel. Tsa lee Jesús mndaab ne mndo ndrol lo re nee, ne ne Jesús lo re nee: ―Tsan, reta goo, ¡nlazʼn wen kwin goo! ");
INSERT INTO zaoNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ngwalo nzhab Jesús kona, tsa mloo Jesús yaa Jesús ne cho Jesús lo re nee, tsa kwathoz naley ngoo leettsoo nee, tak mwii nee Zha Nabee tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tsa ne Jesús lo re nee tedib welt: ―¡Nlazʼn, wen kwin re goo! Leeka taxal mtaal Xutʼn na. Tabaaka taalʼn goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ne or ngwalo ne Jesús koree, ora mlaa Jesús lo re nee ne ne Jesús: ―Bkayaa goo Mbi Nayon. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Loka zha kuu tsow goo perdon falt chaan, tetsow Diox perdon falt chaan zhaʼa; ne loka zha kuu tsowt goo perdon falt chaan, tsowt Diox perdon falt chaan zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Per lee Mach, kuu nak thib zha lo re tsib chop nee; zha kuu ni nee lo kwach, yent zha or mzin Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Bluz tsaraa nzhab nee lo Mach: ―Mwiiʼa nee Zha Nabee. Per lee Mach mkab ne ne lo nee: ―Os leen wiitʼn yaa Zha Nabee ta mtob re zha klab, ne os leen gotʼn kwen yaan ta mtob zha klab, ne gotʼn yaan cho zha, yelaztʼn lee zha mroban. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Xon wiz bluz; lee re nee mkaltaa leen yuu tedib welt, ne no Mach ndo kon re nee tsya. Ne now roo yuu nzo re nee, per lee Jesús mndaab ne mndeli ndrol lo re nee, ne ne Jesús: ―Tsan reta goo, nlazʼn wen kwin goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tsa nzhab Jesús lo Mach: ―Wii yaan ne bloo kwena tree, ne bloo yaaʼa chon. Ne gagta zha nad. ¡Sinke gwalaaz leen mroban! ");
INSERT INTO zaoNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tsa lee Mach nzhab: ―¡Lu nak Zha Nabee lon ne Diox da! ");
INSERT INTO zaoNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Tsa nzhab Jesús lo Mach: ―Nyelaaza mroban na, tak mwiiʼa na. ¡Wen nda re zha kuu mwiit na ne nyelaaz zha lee na mroban! ");
INSERT INTO zaoNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ne noga mtsow Jesús tedib net re milagr lo re nee, kuu mket lo yeets ree. ");
INSERT INTO zaoNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Per lee re diiz ree mkey, tsa yelaaz goo lee Jesús nak Crist Kuu Mtaal Diox Nabee, ne lee zha nak Xgann Diox, ne tsa tsow goo gan yalnaban kuu thitanax. ");
INSERT INTO zaoNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ngwalo mriid re koree, tsa lee Jesús mre ngwani lo re nee zha kuu mteed lo Jesús roo nitdoo kuu le Tiberias, ne tenzhee ngoke: ");
INSERT INTO zaoNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ndo Simún Pey, Mach (kuu ni zha lo “kwach”), Natanael (zha yez Caná yez kuu nzi yezlyu Galilea), ne rop nee wetsʼn (xgann Zebedeo), ne techop zha kuu mteed lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tsa lee Simún Pey nzhab: ―Lee na nda niit mbel. Tsa nzhab re nee lo Pey: ―No nee ya kon lu. Tsa mke re nee leen thib kano ne nda nee, per mniitta nee mbel yaala. ");
INSERT INTO zaoNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ne or ndeyeniʼa yezlyu, lee Jesús ngwani lo re nee roo nitdoo, per myeent re nee Jesúse. ");
INSERT INTO zaoNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Tsa ne Jesús lo nee: ―Mndyeen, ¿chu neeka thib mbel mniitta goo? Tsa nzhab nee: ―Neeka thibe. ");
INSERT INTO zaoNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tsa ne Jesús lo nee: ―Blebi goo yex goo lad ban lo kano, tsa niit goo mbel. Ne tata mtsow neey, ne kwathoz mbel mniit nee ne neeka gagt koo nee yex leen nit. ");
INSERT INTO zaoNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tsa nzhapʼn lo Pey: ―¡Zha Nabeey! Per or mbin Simún Pey, Zha Nabeey, tsa mdok Pey xab Pey, tak mloo Pey xab ne oraaka mndaab Pey leen nit. ");
INSERT INTO zaoNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Lee tedib net nee mtsino kano asta roo nitdoo, ne mdobyu nee yex kuu tseta nzo mbel, tak teeka thib gayoo metr nzo nee lo nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ne or mzin re nee roo nitdoo, mwii nee nde bel, ne mwii nee lee thib mbel ngeyex lo ki, noga mwii nee pan. ");
INSERT INTO zaoNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Tsa ne Jesús lo re nee: ―Deno goo chop tson mbel kuu mniit goo. ");
INSERT INTO zaoNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ne lee Simún Pey mke leen kano, ne mdobyu yex kuu nzo re mbel kuu nabii, asta roo nitdoo, ne leen yexa nzo thib gayoo chop galbtsii btson mbel, ne tegal kwathoz mbel, per mratta yex. ");
INSERT INTO zaoNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Tsa ne Jesús lo re nee: ―De wu ren goo. Per neeka thib nee myet leettsoo ganaabdiz lo Jesús, naa cho nak Jesús. Tak ne nee Jesús Zha Nabeey. ");
INSERT INTO zaoNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Tsa mbig Jesús gax ne mzhen Jesús pan ne mndaa Jesús pan lo nee; ne tataga mtsow Jesús kon mbel. ");
INSERT INTO zaoNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Welt ree ngok myon welt kuu ngwani Jesús lo re nee, kuu mteed lo Jesús, lo mrobana Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Or ngwalo ndow ren re nee, tsa mnaabdiz Jesús lo Simún Pey ne nzhab Jesús: ―Simún xgann Jonás, ¿chu masraa nke leettsooʼa na nake re zha ree? Pey mkab ne nzhab: ―Ah Zha Nabee, neʼa lu nke leettsoon lu. Tsa nzhab Jesús lo Pey: ―Bkenap re mbak zhiil da. ");
INSERT INTO zaoNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tsa mbre Jesús mnaabdiz lo Pey tedib welt, ne nzhab Jesús: ―Simún xgann Jonás, ¿chu nke leettsooʼa na? Lee Pey mkab nzhab: ―Ah, Zha Nabee, neʼa lu nke leettsoon lu. Tsa nzhab Jesús lo Pey: ―Bkenap re mbak zhiil da. ");
INSERT INTO zaoNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ne ngok myon welt mnaabdiz Jesús lo Pey, ne nzhab Jesús: ―Simún xgann Jonás, ¿chu nke leettsooʼa na? Tsa nabil ngoo leettsoo Pey, tak myona welt ngenaabdiz Jesús lo Pey, naa chu nke leettsoo Pey Jesús. Ora mkab Pey ne nzhab Pey: ―Zha Nabee, reta kuu neʼa, neʼa lu nke leettsoon lu. Tsa nzhab Jesús lo Pey: ―Bkenap re mbak zhiil da. ");
INSERT INTO zaoNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Wlipaa na nin loʼa. Leettsa mndyeena mdoka xaba, ne nyaʼa loka pa ta nlaaza, per leettsa gaka zha gox, taaba yaaʼa ne tedib zha tegok xaba, ne teno zha lu ta nlaazta yaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Or nzhab Jesús kona, mndaa Jesús kwent naa xomod gath Pey, ne tsow Pey naroob men yelaaz Jesús. Tsaraa nzhab Jesús lo Pey: ―¡Bteke ditsʼn! ");
INSERT INTO zaoNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Or lee Pey mtsere lo, tsa mwii Pey na Juan ndeken dits re zha. Ne leeka na kuu mnaabdiz lo Jesús btsi kuu ndow rtsee re nee, rtsee chaan Zha Nabee, or kuu nzhapʼn, ¿cho taaʼa lo re zha kuu kutha? ");
INSERT INTO zaoNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Or mwii Pey na, tsa nzhab Pey lo Jesús: ―Zha Nabee, ne lee zha ree, ¿kwan gak kon zha ree? ");
INSERT INTO zaoNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús mkab ne nzhab: ―Os leen nlazʼn banka zha, asta leettsa bretabʼn, tata gake. ¡Ndoblota gona kona! Komsi bteke ditsʼn. ");
INSERT INTO zaoNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ne lee diza mraats lo re wets ne lo re btan lee na gatht, per net Jesús gathtʼn, sinke kuu nzhab Jesús lo Pey nak: “Os leen nlazʼn banka zha asta leettsa bren, ¿cho mporta kona?” ");
INSERT INTO zaoNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Na ndaa kwent re koree, mwiin re koree ne mkee nay lo yeets. Ne, neʼaa wli kuu mkeen. ");
INSERT INTO zaoNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Noga mtsow Jesús tedib net re kuu thoz; ne os gake retay lo yeets, ndakʼn neeka dita lo yezlyu gaat yo re yeets kuu gake retay. Tbaa nake.");
INSERT INTO zaoNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Amig Teófilo, lo yeets kuu mtaalʼn loʼa ner, mkeen reta kuu mtsow Jesús ne reta kuu mloo Jesús, leettsa mndelo Jesús rtsin Jesús, ");
INSERT INTO zaoNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ne asta wiz kuu ngozhoob Jesús yibaa. Per leettsa ndoraa yezhoob Jesús yibaa, mli Jesús re zha kuu gak apóstl Jesús, ne kon Mbi Nayon mloo Jesús lo re zha naa kwan ndoblo tsow re zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nguth Jesús ne mroban Jesús, ne chop gal wiz ngwani Jesús lo re apóstl Jesús. Tata mtsow Jesús, tsa mne re zha wlipaa naban Jesús, ne nzhab Jesús lo re zha naa xomod nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Or bee ndoka Jesús lo re apóstl Jesús, nzhab Jesús lo re zha ndoblot roo re zha Jerusalén. Ne nzhab Jesús: ―Kwet goo yelo gak kuu mne Xutʼn tsow Xutʼn kuu mnda na kwent lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Wli lee Juan mtsowleyy re men kon nit, per techopta wiz lee re goo kayaa Mbi Nayon kuu nabee leettsoo goo. ");
INSERT INTO zaoNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Lee re zha kuu mkaltaa lo Jesús, mnaabdiz lo Jesús ne nzhab: ―Zha Nabee, ¿chu nal tsowa bre nabee leeka re tawlazaa zha Israel loʼaa tedib welt? ");
INSERT INTO zaoNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesús mkab lo re zha, ne nzhab: ―Ndoblot goo ne goo polor o pol tsow Diox kuu beeta lee Diox ne pol tsow, ");
INSERT INTO zaoNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","per leettsa kayaa goo Mbi Nayon, tsasi tekayaa goo yalnabee ne roo goo yataa goo kwent naa cho nakʼn yez Jerusalén, dita yezlyu Judea, yezlyu Samaria ne dib naxta lo yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Or ngwalo tata nzhab Jesús, ngewiika re zha lee Jesús ndya lobee, ne mndaab Jesús leen xkow kuu mtow Jesús, ne mwiit raa re zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ne or ngewiika re zha lobee, leettsa lee Jesús ngeyap lobee, tsa lee chop mbyi kuu nok lar naguz mloo lo re zha, ");
INSERT INTO zaoNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ne nzhab lo re zha: ―Men, Galilea, ¿chebee ngewiika goo lobee? Leeka Jesús kuu mndo xid re goo ne mwii goo ndya lobee, leeka Jesús ree yaad tedib welt, leeka taxal mwii goo ndya zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Or mla re zha yek yii kuu le Olib, tsa mre re zha Jerusalén, ne mnde re zha loka plotha kuu takta te zha wiz kuu ndroxkwan zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Or mzin zha Jerusalén, tsa mkendab re zha leen yuu kuu ndob yek thib yuu, tya nak ta mbet re zha, re zha ree nak: Pey, Juan, Santiag, Ndres, Lip, Mach, Bartolomé, Mateo, Santiag xgann Alfeo, Simún kuu ngoo xid partid Cananita ne Judas (wets Santiag). ");
INSERT INTO zaoNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ne thibka nkaltaa re zha naab zha lo Diox kon re wets Jesús, kon Mari xnaa Jesús ne kon tedib net re ngot. ");
INSERT INTO zaoNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ne re wiza ngwateli Pey xid re zha kuu nyelaaz Jesús, ne nzhak teeka thib gayoo gal re zha kuu nkaltaa tya, tsa nzhab Pey lo re zha: ");
INSERT INTO zaoNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Wets ne btan, re goo kuu nyelaaz Jesús, ndoblo ngok kuu nzhab Mbi Nayon por David lo xkeets Diox, leettsa nzhab David kuu mtsow Judas, kuu mndaa Jesús lo re zha kuu mzhen Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ne Judas ngok thib re nee kuu mteed lo Jesucrist, tsa noga tsow zha kuu ngetsow nee. ");
INSERT INTO zaoNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Per lee Judas ngwa, mzhii thib le yu kon temi kuu ngox lo Judas, por kuu went kuu mtsow Judas, ne leeka loyuʼa ngob Judas par yek Judas ne mrat Judas, ne mroo reta xtii Judas. ");
INSERT INTO zaoNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ne or mbin re zha Jerusalén kona, tsa mtob le zha loyuʼa Acéldama (diiz ree nak: “Loyu ren”). ");
INSERT INTO zaoNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tak nkeʼa lo yeets chaan Salm ta nzhab: Lee liz Judas gan ne neeka thib zha yote. Sal. 69:25 Ne noga nzhabe: Tedib zha tsow rtsin Judas. Sal. 109:8 ");
INSERT INTO zaoNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Kona xid re zha kuu mndiy kon Jesús, dita lo mndo Jesús lo reʼaa, ");
INSERT INTO zaoNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","desde or kuu mtsowleyy Juan Jesús, ne asta wiz kuu ngwazhoob zha yibaa. Xid re zhaʼa ndoblo yetsal thib zha kuu tsow ayud nee, taa nee kwent lo re men lee Jesús mroban. ");
INSERT INTO zaoNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tsa mli re zha chop zha: Thib zha le Mati lee tedib zha le Che Barsabás, zha kuu noga ni zha lo Justo. ");
INSERT INTO zaoNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ne mnaab re zha lo Diox, ne nzhab zha: ―Zha Nabee, lu nlebee leettsoo reta nee. Bloo naa cho thib lo rop zha ree mliʼa, ");
INSERT INTO zaoNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","tsa gak zha apóstl ne tsow zha rtsin Judas, tak mlux Judas lo kuu went kuu mtsow Judas, ne ndyaʼa Judas ta ndoblo Judas. ");
INSERT INTO zaoNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tsa mloo zha swert, tsa naa cho diinne, ne leey mdiinn Mati. Ne leeka ora mla Mati xid re tsiibthib apóstl. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Or mzin wiz kuu nyoo ani kuu le Pentecostés, reta zha kuu nyelaaz Jesús mkaltaa ne thibka mrin re zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ne cha ngoo thib bi kuu mroo lobee, taxal bi chaan thib mbi thoz, kuu mndez dita leen yuu ta nzi re zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tsa mloo taxal loz bel, kuu mraats mlaal mla yek kadta thib re zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ne reta zha mkayaa Mbi Nayon, ne mndelo re zha mndediz zhaapaa zhaapaa diiz, kuu nlaaz Mbi Nayon tediz zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ne re wiza lee re zha Israel kuu ndyaad gol lo Diox kuu nzi Jerusalén, re zha kuu ndyaad reta ta lo yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Or mbin re zha biʼa, kwaro zha mzin tya tsa naa kwan ngok, ne neeka net re zha naa kwan tsow zha xgab, tak kadta thib re zha nzhon zha ndediz re zhaʼa mer xkiiz zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kwathoz mzegey leettsoo re zha, ne mndelo zha mnaabdiz zha lo altaa zha, ne nzhab zha: ―¿Chu nagt zha Galilea re zha kuu ngetediz ree? ");
INSERT INTO zaoNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Chebee nzhonaa ndediz zha mer xkiizaa? ");
INSERT INTO zaoNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nzhee nzi reʼaa kuu ndyaad re yezlyu ree, Partia, Media, Elam, Mesopotamia, Judea, Capadocia, Ponto, Asia, ");
INSERT INTO zaoNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, Panfilia, Egipto, Libia kuu nzi gax Cirene ne noga zha Roma kuu nzo tree. Re zha kuu nak zha Israel ne re zha kuu ngok zha Israel, tak nyelaaz zha re kuu nyelaaz re zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ne noga nzi zha yezlyu Creta ne zha yezlyu Arabia nzhee. Per retalee ngeyon re kuu thoz kuu ntsow Diox, tak ngeyonaa ndediz re zha mer xkiizaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kwathoz mzegey leettsoo re zha, ne neeka net zha naa kwan tsow zha xgab, ne naabdiz zha lo altaa zha, ne mbez zha: ―¿Kwan koree? ");
INSERT INTO zaoNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Per lee tedib net zha mzhizno zha re zha Jesús, ne mbez zha: ―¡Nduz re zha baa! ");
INSERT INTO zaoNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tsa ngwateli Pey kon re tsiibthib apóstl, ne nex nzhab Pey: ―Reta goo zha Israel, ne reta goo kuu nzo yez Jerusalén. Bne goo koree, ne wen bin goo kuu nin lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nduzt re zha ree taxal ntsow goo xgab, tak til nal penta nzhak las nueve. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Sinke nal ngeyak kuu nzhab profet Joél, leettsa nzhab profet: ");
INSERT INTO zaoNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Diox nzhab: “Thib wiz leen taal Mbi Nayon da leettsoo reta men lo yezlyu. Ne lee re xgann goo ne re rtsaap goo, taa kwent kuu gapʼn lo zha, kwaro kuu yibaa loo lo re xgann goo kuu mndyeen, ne lee re zha gol kwaro kuu tsaa leettsoo zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ne re wiza taalʼn Mbi Nayon da lo reta zha kuu ntsow rtsin na, lo zha byi ne lo zha got, tsa taa zha kwent xkizʼn, ne gab zha re kuu nlazʼn gapʼn lo re zha da. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Lee lobee tsowʼn re kuu thoz, kuu tetsegey leettsoo re men wii men, lee lo yezlyu loo ren, bel, xkow ne tsen. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lee lo wiz kow ne lee lo mbee loo taxal ren, leettsa terka tsin wiz ro kuu yaad Zha Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ne reta zha kuu naab lo Zha Nabee, tetsow zha gan yalnaban kuu thitanax.” Joél 2:28-32 ");
INSERT INTO zaoNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Men Israel, kenza goo kuu nin lo goo nal, wen ne goo lee Jesús zha Nazaret, nak thib mbyi kuu mtaal Diox lo re goo, ne mtsow Jesús kwaro re milagr ne re kuu thoz kuu mzegey leettsooʼaa. Tbaa mloo Diox lee Diox mtaal Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ne ndala neʼa Diox naa kwan tsowno goo Jesús. Mzhen goo Jesús ne mndaa goo Jesús lo re zha went, tsa mbeth zha Jesús lo kruz. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Per lee Diox mteroban Jesús, ne mtelaa Diox Jesús lo yalguth, tak gagt nabee yalguth lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ne leettsa mteth rey David Jesús, nzhab David: Ngwiin lee Zha Nabee lon thibka ndo kon na, lee zha ndo lad ban lon, tsa thibka ney ndon. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kona naley nzo leettsoon, ne kwathoz lazʼn nzhoolʼn lo zha. Tak neʼa na yent kwan takʼn or gathʼn, ");
INSERT INTO zaoNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","tak laata yalnaban da leen baa ta nzo re zha nguth, ne neeka laata yetsaa kwerp mosa, kuu mndaat falt. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mlooʼa lu net kuu ndaa yalnaban lon, ne lu ntsow naley nzo leettsoon, tak ndoʼa lon. Sal. 16:8-11 ");
INSERT INTO zaoNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Wets taa goo diiz nin koree lo goo. Lee teyaa David zha ndala, nguth David ne mkaats zha David, ne lee baa David ndobka xidaa asta wiz naltseree. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Per David ngok profet lo re men, ne wen mne David lee Diox nzhab lo David, lo raz David yaad Crist, zha kuu tob ta mndob David mnabee David. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ne mni David taxal thib zha kuu mwiiʼa re kuu gak: Lee yalnaban chaan Zha Kuu Mtaal Diox Nabee, yaanta ta nzo re zha nguth, ne neeka kwerp zha yetsaat. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ne lee Diox mteroban Jesús ne retalee ney. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ne leettsa mroban Jesús tsa ndya Jesús ndob lad ban lo Diox, ne mkayaa Jesús Mbi Nayon kuu nzhab Xutaa lo Jesús desde ner, ne lee nal mtaala Jesús Mbi Nayona lo yezlyu ree, ne Mbi Nayona mtsow kuu ngewii goo ne ngeyon goo nal. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ne ngwat David yibaa. Per leeka David nzhab: Lee Diox Kuu Nabee, nzhab lo Zha Nabee lon: “Btob lad ban lon, ");
INSERT INTO zaoNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","asta yelo tsin re zha kuu nayii neʼa, xann niiʼa, tsa tobxub zha loʼa”. Sal. 110:1 ");
INSERT INTO zaoNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Kona retalee zha Israel ndoblo ne: Lee Jesús zha mkee re goo lo kruz, Diox mtsow nak Jesús Zha Nabee, ne lee Jesús nak Crist Kuu Mtaal Diox Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Or mbin re zha kuu mkaltaa tya koree, kwathoz nabil ngoo leettsoo re zha, tsa mnaabdiz zha lo Pey ne lo re apóstl, ne nzhab zha: ―Wets, ¿kwan ndoblo nee tsow nee? ");
INSERT INTO zaoNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tsa lee Pey mkab lo re zha, ne nzhab: ―Btsee goo mod nak goo, ne gokleyy kadta thib goo kon le Jesucrist, tsa tuyy Diox re falt goo, ne taa Diox Mbi Nayon lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tak lee kuu mne Diox taa Diox nak par re goo, par re zhiinn goo ne par re zha ndo tith, leey nak chaan reta zha kuu nlaaz Diox kwez Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kon re diiz ree ne kon tedib net diiz mni Pey lo re zha ne mteni Pey re zha, ne nzhab Pey: ―¡Broo goo lo re zha kuu ntsow kuu went! ");
INSERT INTO zaoNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ne tata, lee re zha kuu ngwalaaz kuu nzhab Pey, ngokleyy zha, ne wiza mla teeka tson mil re zha xid re zha kuu nyelaaz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Reta zha kuu ngwalaaz Jesús, ntsow zha kuu mbez re apóstl, ne thibka nak xgab re zha, ne nzhow re zha rtsee chaan Zha Nabee, noga nkaltaa re zha naab zha lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ne reta men kwathoz mzegey leettsoo, por re milagr ne re kuu thoz kuu mtsow re apóstl. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ne reta zha kuu ngwalaaz Jesús thibka ngok xgab re zha, ne ngiid zha re kuu nap zha lo re altaa zha kuu ndechey. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ntho re zha kuu nap zha, ne nyadno zha temi ne ngiid zhay lo re zha taxalta ndeche zhay. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ne gandata wiz nkaltaa re zha lee gwodoo, nkaltaa zha liz re altaa zha ne thibka nzhow re zha, ne kwathoz naley nzo leettsoo re zha, ne kwathoz nke leettsoo zha altaa zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ne nzhool re zha lo Diox, ne dita yez nyow leettsoo naa xa nak re zha, ne kad wiz lee Zha Nabee ntsow ayud re zha, tsa nyoo raa zha kuu nyelaaz xkiiz zha, ne ntuyy Diox falt chaan re zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Thib wiz teeka las tres ngwa Pey rop Juan gwodoo, or kuu nkaltaa zha par ndediz zha lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ne roo gwodoo ndob thib mbyi kuu mthans desde ngol, ne reta wiz nyatob zha zha roo pwert gwodoo kuu le chuldoo, tsa naab zha karida lo re zha kuu nya gwodoo. ");
INSERT INTO zaoNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ne lee zha mthansa mwii lo Pey rop Juan, or mera tab rop zha gwodoo, ne mnaab zha karida lo rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tsa key mwii Pey rop Juan lo zha, ne nzhab Pey lo zha: ―Wii lo nee. ");
INSERT INTO zaoNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Lee zhaʼa zheta mwii lo rop zha, mtsow zha xgab lee rop zha taa thib kwaa lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Per lee Pey nzhab lo zha: ―Ndentʼn temi tan loʼa, per kuu tak tsowʼn loʼa tetsow nay. Nalor nin loʼa: “Kon yalnabee chaan Jesucrist zha Nazaret, gwateli ne bte”. ");
INSERT INTO zaoNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Or ngwalo tata nzhab Pey, mzhen Pey yaa ban zha ne mteli Pey zha, ne oraaka ngoo fwers nii zha ne mli nii zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tsa lee zha mthansa ngwateli ne mndelo mnde, ne mndaab zha leen gwodoo kon rop zhaʼa. Nkee zha brink ne nzhool zha lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Reta zha yez mne lee zha mnde ne nzhool lo Diox, ");
INSERT INTO zaoNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ne kwathoz mzegey leettsoo re men ne mzeb zha mwii zha kuu ngok, tak nlebee zha mbyiʼa, ne reta zha ne lee mbyiʼa nyatob roo pwert gwodoo kuu le kwathoz chul, nyanaab karida. ");
INSERT INTO zaoNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Lee zha mthans kuu mgweʼa, mlaat zha Pey rop Juan. Leettsa mbin re men kona, kwathoz mzegey leettsoo re zha ne mrozhonn re zha ngwa zha ta ndo Pey rop Juan, ta le korredor chaan Salomón. ");
INSERT INTO zaoNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Or mwii Pey lo re mena, tsa nzhab Pey: ―Zha Israel, ¿chebee nzegey leettsoo goo ngwii goo lo nee? ¿Chebee ngwii goo lo nee taxal nee mtsow mnde zha ree kon yalney chaan nee, o tak nali naban nee taxal nlaaz Diox, lee zha mgwe kon yalnabee chaan Jesucrist? ");
INSERT INTO zaoNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Lee Diox chaan re teyaa zha ndala, Diox chaan Abraham, chaan Isaac ne chaan Kob, lee Diox mndaa yalnabee lo Jesucrist kuu mndaa re goo lo re zha kuu nak tsiin. Ne leettsa lee Pilat ngwalaaz gatelaa Jesucrist mzhyalt goo. ");
INSERT INTO zaoNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Leel mnaab goo mtelaa Pilat thib zha kuu mbeth men, tabaa mloo goo mlaa goo Jesús zha Nayon ne Nali nak. ");
INSERT INTO zaoNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Tbaa mbeth goo Xgann Diox, kuu ndaa yalnaban, per Diox mteroban Jesús, ne re nee mne koree. ");
INSERT INTO zaoNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Per lee mbyi kuu nloo lo goo, zha kuu reta goo nlebee, thitanax mgwe zha, tak ngwalaaz zha Jesús, ne reta goo ne mgwe zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Lee nal neʼa na, lee re goo kuu nak tawlazʼn kon re zha kuu nak tsiin, mnabee goo mbeth zha Jesús, per neeka net goo naa kwan mtsow goo. ");
INSERT INTO zaoNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tata mtsow Diox, tsa ngok kuu nzhab re profet Diox zha ndala: Leettsa nzhab re profet lee Crist Kuu Taal Diox Nabee, ndoblo rid yalti ne gath. ");
INSERT INTO zaoNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kona, bloo goo mtsee goo mod went kuu nak goo, ne bre goo lo Diox, tsa tuyy Diox re falt goo. Tsa tetsey Diox leettsoo goo, ");
INSERT INTO zaoNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ne taal Diox Jesús lo goo, kuu nak Crist Kuu Mtaal Diox Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ne tegal nal lee Jesús ndoblo to yibaa, asta yelo wen tsi Diox reta kwaa, taxal nzhab re profet kuu ngoo ndala. ");
INSERT INTO zaoNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisés nzhab lo re teyaa zha ndala: “Lee Diox kuu nak Xutaa tsow roo thib profet xid re goo, thib profet kuu taa kwent xkiiz Diox taxal na lo re goo, Dt. 18:15 bin goo diiz lo profet lo reta kuu ne profet, ");
INSERT INTO zaoNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","tak reta zha kuu tobyegt xkiiz profet, telux zha thitanax ne tegoo zha zha yez Israel”. Dt. 18:19 ");
INSERT INTO zaoNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Reta profet desde Samuel par tenzhee, reta profet nzhaba zha re kuu ngeyak re wiz ree. ");
INSERT INTO zaoNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ne re goo nak zha kuu mdiinn re kuu nzhab re profet. Lo re goo lortsin xkiiz Diox kuu nzhab re profet, ne diinn goo re kuu nzhab Diox taa Diox lo teyaa Abraham, leettsa nzhab Diox lo Abraham: “Por raza kwathoz men dib naxta lo yezlyu kayaa Diox por zha wen”. Gn. 22:18 ");
INSERT INTO zaoNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Tak leettsa mteroban Diox Jesucrist Xgann Diox, ner lo re goo mtaal Diox Jesucrist, tsa wen kwin goo kon Diox, ne tsa laa goo re kuu went kuu ntsow goo. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Lee Pey rop Juan ngenika lo re men, ne lee re ngwleyy zha Israel mzin kon zha kuu nabee lo re soldad kuu nkenap gwodoo Jerusalén ne kon re zha saduceo. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Kwathoz nayii zha tak lee Pey rop Juan nloo lo re men, ne mbez rop zha lo re men; lee re zha nguth teroban taxal mroban Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tsa mzhen zha Pey rop Juan, ne mloo zha rop zha tsib ne mlaa zha rop zha tsib, asta ngwani yezlyu tedib wiz, tak mziya yezlyu wiza. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Per kwaro re men kuu mbin kuu nzhab Pey rop Juan ngwalaaz xkiiz Diox, ne beeta re mbyi nak teeka thib gaay mil. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Or ngwani yezlyu tedib wiz, tsa mkaltaa re zha kuu nabee yez Jerusalén, kon re zha gol ne kon re maestr chaan ley; ");
INSERT INTO zaoNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ne noga Anás kuu nak ngwleyy kuu nabee lo reta ngwleyy ndo tya, Caifás, Juan, Alejandr ne reta zha kuu nak zha liz ngwleyy kuu nabee lo reta ngwleyy. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tsa mtaal zha zha ngwaxii Pey rop Juan ne mto zha rop zha ndrol lo re zha kuu nak tsiin. Tsa mnaabdiz zha lo rop zha, ne nzhab zha: ―¿Cho mndaa diiz lo goo ntsow goo koree? ¿Ne cho mndaa yalnabee ntsow goo re koree? ");
INSERT INTO zaoNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tsa lee Pey kwaro mnabee Mbi Nayon leettsoo, ne nzhab lo re zha: ―Kenza goo, reta goo kuu nabee lo re zha Israel ne re goo kuu nak zha gol: ");
INSERT INTO zaoNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Lee re goo ngenaabdiz lo nee, naa xomod mtsow nee yalwen mtegwe nee thib zha mthans, tsa ne goo naa xomod mgwe zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kona ndyaad nee taa nee kwente lo re goo nzhee, tsa ne re goo lee mbyi kuu ndo nzhee lo re goo, mgwe kon yalnabee chaan Jesucrist zha Nazaret kuu mkee re goo lo kruz, zha kuu leeka lee Diox mteroban. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Re goo nak taxal zha kuu nta yuu ne lee Jesús nak taxal ke kuu mlaa re goo kuu nta yuu, per lee Jesús nak taxal ke kuu mas wen kuu mndob thib skin yuu. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tak beeta Jesús nak kuu ndaa yalnaban kuu thitanax, ne yent raa tedib zha kuu ndaa yalnaban kuu thitanax, tak mtaalt Diox tedib zha, kuu tak telaa reʼaa lo yalguth. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Leettsa mne re zha kuu nak tsiin lee Pey rop Juan ney leettsoo ndediz, ne wen ne re zha mteedt rop zha, ne neeka gagt lab rop zha, kona kwathoz mzegey leettsoo re zha, ne myeen re zha lee rop zha mndiy kon Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ne lee mbyi kuu mgweʼa ndoka tya, kona gagt keki zha Pey rop Juan. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tsa mnabee re zha kuu nak tsiin, mroo rop zha lo junt, tsa yaan beeta re zha tediz. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Tsa nzhab re zha: ―¿Kwan tsowaa kon rop mbyi ree? Tak reta zha Jerusalén mwii mtsow zha re milagr thoz ree, ne gagt gabaa wlite. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Per nal yiiʼaa lo zha ne tseba zha, tsa taat raa zha kwent chaan Jesús lo re men, tsa raats raa xkiiz Jesús lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tsa mrez re zha rop zha ne mnabee zha lo rop zha, tsa tedizt raa zha zha ne neeka loot raa zha kwent chaan Jesús lo re men: ");
INSERT INTO zaoNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Per lee Pey rop Juan mkab lo re zhaʼa ne nzhab: ―Leeka re goo btsow goo xgab, ¿chu mas wen gon nee diiz lo goo, nake gon nee diiz lo Diox? ");
INSERT INTO zaoNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Leecha nee tediz re kuu mwii nee ne re kuu mbin nee. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tsa lee re zha kuu nak tsiin mre mnayii lo rop zha, ne mtelaa zha rop zha, tak mzalt zha mod gateti zha rop zha, tak reta men nzhool lo Diox, tak mwii re men kuu mtsow rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Lee mbyi kuu mgwe lo milagr thoza, nap masraa chop gal liin. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Leettsa mtelaa zha Pey rop Juan, tsa ngwa rop zha mkaltaa zha kon re altaa zha kuu nyelaaz Jesús, ne mndaa zha kwent reta kuu nzhab re ngwleyy kuu nabee lo re ngwleyy ne re zha gol zha Israel lo rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Or ngwalo mbin re zha kuu nzhab rop zha, tsa reta zha mnaab lo Diox ne nzhab zha: ―Zha Nabee, lu mdexkwaa lobee, yezlyu, nitdoo ne reta kuu nzo leene, ");
INSERT INTO zaoNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ne por Mbi Nayon chaana mni David re koree, or nzhab David: ¿Chebee nayii re men yezlyu ree? ¿Chebee ntsow re zha xgab kuu nataagt? ");
INSERT INTO zaoNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Re rey ne re zha kuu nak tsiin lo yezlyu ree, thibka ngok re zha, tsa yii zha ne Zha Nabee, kuu nak Crist Kuu Mtaala Nabee. Sal. 2:1-2 ");
INSERT INTO zaoNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Tak wlipaa mkaltaa Herodes kon Poncio Pilat ne re zha kuu nagt zha Israel, ne mbyii zha mne zha xganna Jesús, zha nayon kuu mliʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tbaa mtsow re men reta kuu mtsowa lu xgab gak desde ndala. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ne lee nal, Zha Nabee, wii naa xa nayii zha ne zha nee, tsow ayud re nee kuu nak mosa, tsa tsebt nee taa nee kwent xkiiza, ");
INSERT INTO zaoNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ne kon yalney chaana tegwe nee re mbyiz, ne tsow nee re milagr thoz kon yalnabee chaan xganna Jesús kuu Nayon. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Or ngwalo mndediz re zha lo Diox, lee ta nzi re zha mndelo mzhiit. Ne reta zha mkayaa Mbi Nayon, ne mzebt re zha mndelo zha mndaa zha kwent xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ne thibka ngok xgab reta zha kuu nyelaaz Jesús. Ne neeka thib re zha mbezt zha beeta chaan zha nak re kuu nkeno zha, sinke chaan reta zha nake. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ne Diox mtsow ayud re apóstl, tsa mndaa re zha kwent lee Jesús Zha Nabee mroban, ne lee yalwen chaan Diox mndo kon re apóstl. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kona reta zha nap zha kuu ndeche zha, tak lee zha kuu nkeno yu o thib yuu ntho zhay, ne nyadno zha temi ");
INSERT INTO zaoNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ne ndaa zhay lo re apóstl, tsa kiid zhay lo re zha, taxalta ndeche kadta thib thib zhay. ");
INSERT INTO zaoNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ne xid re zhaʼa ngoo thib mbyi kuu le Che, zha kuu nak zha raz Leví, ne zha Chipre nak Che. Re apóstl mtob le zha Bernabé. (Diiz ree nak: “Zha kuu ntetsey”.) ");
INSERT INTO zaoNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Lee mbyi ree mkeno thib le yu, ne mtho zhay ne myaadno zha temi lo re apóstl. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Per ngoo thib mbyi kuu le Ananías ne lee tsaal Ananías le Safira. Mtho rop zha thib le yu zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ne myaan rop tsaal zha diiz kedi zha, ne mtaan Ananías garol temi, lee tegarole mndaa Ananías lo re apóstl. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Tsa lee Pey nzhab lo Ananías: ―¿Chebee mlaaʼa mndaab Maxuuy leettsooʼa, kona nlaaza kediʼa Mbi Nayon, tsa yaana kon plo temi kuu mthoʼa loyuʼa? ");
INSERT INTO zaoNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Chu nagte loyuʼa leettsa ter tho luy? ¿Chu nagt temiʼa kuu mkayaaʼa? ¿Chebee mtsowa xgab tsowa koree? Ngwalaaza gakediʼa re men per myeenta lo Diox ngetsow luy. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Or ngwalo mbin Ananías koree, cha ngob Ananías ne nguth Ananías. Ne reta zha kuu mbin koree kwathoz mzeb zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tsa myaad chop tson zha mndyeen, mchal mndyeen lar Ananías ne mbe mndyeen Ananías ngwakaats mndyeen. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Teeka tson or bluz, tsaraa mzin tsaal Ananías, ne net ngot naa kwan ngok. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Tsa mnaabdiz Pey lo ngot, ne nzhab Pey: ―Ne lon, ¿chu taxal ne tsaala? ¿Chu lala mtho goo yu goo? Lee ngot mkab ne nzhab: ―Ah, pres baa mtho neey. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Tsa lee Pey nzhab lo ngot: ―¿Chebee myaan rop tsaal goo diiz tsow goo koree, nlaaz goo kedi goo Mbi Nayon? Wii baa ndyaad re zha kuu ngwakaats tsaala, ne nalor gwe zha lu. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ne oraaka lee Safira cha ngob lo Pey ne nguth. Ne or mndaab re mndyeen ngutha ngot, tsa mbe mndyeen ngot, ngwakaats mndyeen ngot leeka cho tsaal ngot. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ne reta zha kuu nyelaaz Jesús kon reta zha kuu mbin koree, kwathoz mzeb zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Lee re apóstl mtsow kwathoz milagr ne re kuu thoz lo re men; ne reta zha nkaltaa roo korredor kuu ni zha, roo korredor chaan Salomón. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Lee re men yez kwaro wen ngoo leettsoo zha mne zha re zha kuu nyelaaz Jesús, per myet leettsoo zha gataab zha xid re zha kuu nyelaaz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ne masraa zha ngwalaaz Jesús tant mbyi ne ngot. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ne nyadno re men re mbyiz roo net ne nxoob zha zha lo luun, tsa or lee Pey rid, mase xinn Pey diinn thib chop re zha, tsa gwe zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ne noga kwaro re men re yez kuu nzi gax ngwa Jerusalén, ne nyadno zha re mbyiz ne re zha kuu nzo mbi fyer leettsoo. Ne reta zha ngwe. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tsa lee ngwleyy kuu nabee lo reta ngwleyy kon re saduceo kuu nzi kon lee zha, kwaro mnayii zha mne zha rop apóstl, ");
INSERT INTO zaoNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","mzhen zha rop apóstl, ne mloo zha rop zha tsib. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Per leeka yaala lee thib mandad chaan Diox mxaal roo tsib, mloo rop zha ne nzhab lo rop zha: ");
INSERT INTO zaoNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Gwa goo lee gwodoo Jerusalén, ne btaa goo kwent xkiiz Diox kuu ndaa yalnaban lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ne leettsa ngwalo mbin rop zha kona, ne til tedib wiz ngwa zha lee roo gwodoo ne mndelo zha mloo zha xkiiz Diox lo re men. Tsa lee ngwleyy kuu nabee lo reta ngwleyy, ne re zha kuu nzi kon lee zha, mrez zha reta zha gol zha Israel lo thib junt, tsa mnaab zha yaxii zha rop apóstl tsib. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Per or mzin re zha kuu nkenap gwodoo roo tsib, yenta rop zha leen tsib, tsa mretab zha ndyaadno zha diiz, ");
INSERT INTO zaoNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ne nzhab zha: ―Or mzin nee roo tsib, nowka roo tsib, ne lee re soldad nzika nkenap roo tsib. Per or mxaal nee tsib, yentka cho nak leen tsib. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ne leettsa mbin ngwleyy kuu nabee lo reta ngwleyy kon zha kuu nabee lo re zha kuu nkenap gwodoo, ne kon re ngwleyy kuu nabee lo re ngwleyy kona, tsa mndelo re zha mtsow zha xgab: “¿Asta plotha tsin re koree?” ");
INSERT INTO zaoNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ne oraaka mzin thib zha nzhab lo re zha: ―Lee rop zha kuu mloo goo tsib, ndo lee roo gwodoo ngeloo lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tsa lee re zha kuu nkenap gwodoo kon zha kuu nabee lo re zha, ngwakwaan rop apóstl, per yent kwan mtsow zha lo rop zha, tak nzeb zha kee re zha yez ke yek zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Or mtsino zha rop apóstl lo re zha kuu nak tsiin ne lo ngwleyy kuu nabee lo reta ngwleyy. Tsa lee ngwleyya nzhab lo rop zha: ");
INSERT INTO zaoNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―¿Chu mnet nee lo goo taat raa goo kwent chaan Jesús lo re men? Ne lee nal ngwaloʼa mtsow goo, lee reta men mbin re kuu mloo goo, ne nlaaz goo keki goo nee lee nee mbeth mbyiʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tsa lee Pey kon tedib net re apóstl mkab, ne nzhab: ―Ndoblo ner lo Diox gon nee diiz, tsaraa gon nee diiz lo re men yezlyu ree. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Leeka Diox chaan re teyaa zha ndala, mteroban Jesús, kuu mbeth goo mkee goo lo kruz. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Diox mteroban Jesús, ne mtob Diox Jesús lad ban lo Diox, lee Jesús nak Zha Nabee, lee Jesús nak zha kuu ntelaa re men lo re falt men, ne leeka Jesús mxaal net, tsa lee reʼaa zha Israel tsowt raa lee kuu went, ne ndoblo yelaazaa Jesús, tsa tuyy Jesús re faltaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ne re nee ne Mbi Nayon nak cho ne koree, Mbi Nayon ree ndaa Diox lo re zha kuu nzhon diiz lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Or mbin re zhaʼa koree, kwathoz mkezhyan re zha, ne ngwalaaz zha gaguth zha rop apóstl. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Per xid re zha kuu nak tsiin, ngoo thib fariseo kuu le Gamaliel, kuu nak thib maestr chaan ley, ne reta men yez nzhon diiz lo Gamaliel. Mndeli Gamaliel ne mnabee Gamaliel, tsa koo zha re apóstl lee thib gatil. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ora nzhab Gamaliel lo re zha kuu nak tsiin: ―Zha Israel, wen wii goo naa kwan tsow goo kon rop mbyi baa. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Btelaaz goo ndala ngoo thib mbyi kuu le Teudas, kuu ngwalaaz gagak thib mbyi nataak, ne mkaltaa Teudas thap gayoo zha kuu mndeke dits Teudas, ne leettsa mbeth zha Teudas, reta zha kuu mndeke dits Teudas mraats mlaal, ne yent raa cho zha myaan. Tyatha ngwalo re kuu mtsow Teudas. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ne noga leettsa mthop gobyern le re men, ngoo tedib mbyi kuu le Judas zha Galilea. Ne leeka tata mthop Judas kwaro re men kuu mndeke dits Judas, per noga mbeth zha Judas, ne reta zha kuu mndeke dits Judas mraats mlaal. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kona lee na ni lo goo laa goo rop mbyi baa, yent kwan tsow goo lo zha. Tak os lee koree nak chaan re men, teluzhe. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Per os Diox ngetsow koree, tsowt goo gan lo zha, kenap goo goo cha leel kon Diox ngeyo goo. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Reta zha mbin diiz lo Gamaliel. Tsa mrez re zha rop apóstl ne mkee zhay yek rop zha, ne nzhab zha lo rop zha, tedizt raa zha kwent chaan Jesús lo re men. Tsaraa mtelaa zha rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Per lee rop apóstl kwathoz laz zha mroo zha lo re zha nak tsiin, tak mndaa Diox diiz mriid zha yalti, tak nyelaaz zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ne neeka mzebt zha ne neeka mlaat zha gataa zha kwent chaan Jesucrist lo re men gandata wiz, lee roo gwodoo Jerusalén ne noga liz re men. ");
INSERT INTO zaoNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ne re wiza lee re zha kuu nyelaaz Jesús ndiy nzhak mas plo, ne lee re zha Jesús kuu ndediz diiz gryeg, mndelo mtob kej kwent chaan re zha kuu ndediz Hebreo. Mbez zha ke reta wiz, leettsa ngiid zha kuu wu re byud, lee re byud kuu ndediz gryeg nkayaat ploy, taxal nkayaa re byud kuu ndediz Hebreo. ");
INSERT INTO zaoNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tsa lee re tsiibchop apóstl mkaltaa re zha kuu nyelaaz Jesús, ne nzhab re apóstl lo re zha: ―Went os laa nee taat raa nee kwent xkiiz Diox, par kiid nee kuu wu re men. ");
INSERT INTO zaoNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kona wets ne btan, bli goo gaz mbyi xid re goo, zha kuu nzhak ne nali nak ne kuu nabee Mbi Nayon leettsoo, tsa taa nee tsiin ree tsow zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ne lee re nee naabka lo Diox ne taa nee kwent xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Reta zha mkab nzhab tata gake, ne mli zha Steb, thib mbyi kuu wlipaa nyelaaz Jesús ne kwaro nabee Mbi Nayon leettsoo zha, Lip, Prócoro, Nicanor, Timón, Pármenas ne Nicolás zha yez Antioquía (zha ree ngok zha Israel). ");
INSERT INTO zaoNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tsa mndeno zha re gazta re zha ree lo re apóstl, ne lee re apóstl mxoob yaa yek re zha, ne mnaab re zha lo Diox por re gazta zha ree. ");
INSERT INTO zaoNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ne lee xkiiz Diox masraa mraats, ne lee re zha kuu nyelaaz Jesús ndiy ngeyak mas plo raa yez Jerusalén. Ne asta kwaro re ngwleyy noga ngwalaaz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Lee Steb kwaro nabee Mbi Nayon leettsoo ne mndaa Diox yalnabee lo Steb, mndaa Diox diiz tsow Steb kwaro milagr ne re kuu thoz lo re men yez. ");
INSERT INTO zaoNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ne lee chop tson zha kuu nteed xkiiz Diox thib ta le: “Re men Libr” mndelo zha mbyodiz kon Steb, re zha ree ndyaad re yez ree, yez Cirene ne zha yez Alejandría, ne zha kuu ndyaad yezlyu Cilicia, ne re zha kuu ndyaad yezlyu Asia. ");
INSERT INTO zaoNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Per yet roo re zha lo yalnzhaak chaan Steb, tak lee Steb ndediz kon yalnzhaak chaan Mbi Nayon. ");
INSERT INTO zaoNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tsa mdix re zha lo chop tson mbyi, tsa gab re zha ree lee Steb nlooz Moisés ne Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ne tabaa mtsow re zha, tsa mbyii re zha yez, re zha gol ne re maestr chaan ley. Tsa mzhen zha Steb ne mndeno zha Steb lo re zha kuu nak tsiin. ");
INSERT INTO zaoNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ne noga mkwaan re zha re zha kuu nkedi nzhab: ―Lee mbyi ree thibka nlooz gwodoo Nayon chaan Diox ne ley Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ne re nee mbin nzhab zha lee Jesús, zha Nazaret luux gwodoo, ne tsee zha costumr kuu mlaa Moisés lo reʼaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Lee re zha kuu nak tsiin kon reta zha kuu nzi tya, or mwii re zha lo Steb, lee lo Steb mloo taxal lo thib mandad chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tsa lee ngwleyy kuu nabee lo reta ngwleyy mnaabdiz lo steb, ne nzhab: ―¿Chu wli re kuu mbez re zha loʼa? ");
INSERT INTO zaoNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Lee Steb mkab ne nzhab: ―Wetsʼn ne xutʼn, kenza goo kuu nin, lee Diox kuu nak chaan xni ne kuu kwathoz naro mloo lo teyaa Abraham, leettsa ngoo Abraham yezlyu Mesopotamia, leettsa terka ya Abraham yo yez Harán. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Diox nzhab lo Abraham: “Broo laza ne blaa re tawlaza, tsa ndyaʼa yezlyu kuu lon loʼa”. Gn. 12:1 ");
INSERT INTO zaoNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Tsa mroo Abraham yezlyu Caldea ne ndya Abraham ngoo yez Harán. Ne tya nguth xut Abraham ne leettsa ngutha xut Abraham, lee Diox ndyaadno zha yezlyu ree, ta nzo re goo nal. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ne mndaat Diox neeka thib le yu ree lo Abraham, neeka lutte, per nzhab Diox lo Abraham, taa Diox yezlyu ree lo re raz chaan Abraham, or lee Abraham ngutha. Ne napt Abraham zhiinn Abraham tsya. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ne noga nzhab Diox lo Abraham: “Lee re zha raz Abraham ya yo thib yez tith, ne lee re zha yeza tsow, gak re zha raz Abraham mos lo re zha kuu nzo yeza, ne teti re zha yeza re zha raz Abraham thib thap gayoo liin”. Gn. 15:13 ");
INSERT INTO zaoNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Noga nzhab Diox lo Abraham: “Na teti zha yezlyuʼa, zha kuu tsow gak raza mos lo re zha kuu nzo tya, per bluz roo re raza tya, ne yaad re zha nzhee gol zha lon”. Ex. 3:12 ");
INSERT INTO zaoNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ne lo trat kuu mtsow Diox kon Abraham, mnabee Diox lo Abraham, tsa kee Abraham seny Abraham ne re zha raz Abraham. Kona penta mzaal xon wiz ngol xgann Abraham Isaac, mkee Abraham seny xgann Abraham, ne tataka mtsow Isaac kon xgann Isaac Kob; ne leeka tata mtsow Kob kon re xgann Kob, kuu ngok xut re tsiibchop re zha raz zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Re xgann Kob kuu ngok re teyaa zha ndala, mnayii zha mne zha wets zha Che, tsa mtho zha Che lo zha kuu mriid ndya net Egipto, per mlaayaat Diox Che, ");
INSERT INTO zaoNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","mtsow Diox ayud Che lo re yalti kuu mriid Che, ne mndaa Diox yalnzhaak lo Che, noga mtsow Diox lee faraón zha kuu nak rey Egipto mkayaa Che. Ne rey ree mtsow ngok Che zha nabee dita yezlyu Egipto ne noga liz rey. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Tsya mla win dita yezlyu Egipto ne yezlyu Canaán, ne lee re teyaa kwathoz nabil ngoo leettsoo zha, tak yent raa kuu wu zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ne leettsa mbin Kob nzo nzob xtil yez Egipto; tsa mtaal Kob re xgann Kob tya, yaxii nzob xtil thib welt, ne re zha ree ngok re teyaa zha ndala. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ne leettsa ngwa re zha tedib welt, tsaraa lee Che mlaa mlebee re wets Che Che, ne tabaa lee faraón mne naa cho raz ndyaad Che. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tsa mnabee Che yaad xut Che Kob ne reta zha liz Che, tsa yo re zha Egipto, ne re zha ree nak tson gal tsiin. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ta mod ndya Kob ngoo Egipto; ne tya nguth Kob, ne tyaka nguth re teyaa zha ndala. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ne bluz mbe re zha tsidth Kob yez Siquem, ne mloo zhay leen baa kuu mzhii Abraham lo re zhiinn Hamor yez Siquem. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Ne leettsa ndetsin gaxa wiz kuu gak kuu nzhab Diox lo Abraham, lee zhiinn re teyaa zha ndala kwaro myazh zha Egipto. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ne lee tedib rey mnabee Egipto, ne zha ree mlebeet zha Che. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","rey ree mkedi re tawlazaa ne mteti zha re tawlazaa zha ndala. Mnabee zha, tsa laa re tawlazaa gath re xgann zha kuu penta ngol. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ne thib re wiza ngol Moisés, thib mbet kuu kwathoz wen ngoo leettsoo Diox mne Diox, ne lee xnaa mbet ne xut mbet mxeen mbet tsonka mbee. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ne mzin wiz kuu laa rop zha mbet, tsa lee rtsaap faraón mzal mbet ne mxeen nzaa mbet taxal zhiinn nzaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kona lee Moisés mteed lo yalnzhaak chaan re zha Egipto, ne lo xkiiz Moisés ne lo re kuu mtsow Moisés ngok Moisés zha nataak. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Per leettsa napa Moisés chop gal liin, tsa ngoo leettsoo Moisés ngwatwii Moisés lo re tawlaz Moisés, zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tsa mne Moisés lee thib zha Egipto ngeyin thib zha Israel, tsa mla Moisés tawlaz Moisés, ne mbeth Moisés zha Egipto. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mtsow Moisés xgab tabaa mod lee re tawlaz Moisés yeen lee Diox mtaal Moisés, tsa koo Moisés re tawlaz Moisés Egipto; per myent re tawlaz Moisése. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ne tedib wiz mwii Moisés lee chop tawlazaa zha Israel ngeyo ne nlaaz Moisés wen kwin rop zha, tsa nzhab Moisés lo rop zha: “Tawlaz rop goo; ¿Chebee ngyo goo kon leeka tawlaz goo?” ");
INSERT INTO zaoNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Tsa lee zha kuu ngeyin tedib zha mchop Moisés ne nzhab lo Moisés: “¿Cho mtoʼa tsa nabeeʼa lo nee, ne teniʼa nee? ");
INSERT INTO zaoNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Chu nlaaza kutha na taxal mbetha zha Egipto naaʼa?” Ex. 2:14-15 ");
INSERT INTO zaoNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Leettsa mbin Moisés kona, tsa mzhonn Moisés ndya Moisés ngoo Moisés yezlyu chaan re zha yez Madián, ne tya ngoo Moisés taxal zha tedib yez ne tya mkeno Moisés chop xgann Moisés. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Ne mriid chop gal liin lee Moisés ndo thib yubiz, gax yii Sinaí, tsa mloo thib mandad chaan Diox xid bel lo ya bxiid lo Moisés. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Tsa kwathoz mzegey leettsoo Moisés mwii Moisés kona, tsa mbig Moisés gax tsa wen wen wii Moisése. Ora mbin Moisés lee Zha Nabee mni lo Moisés, ne nzhab: ");
INSERT INTO zaoNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Na nak Diox chaan re teya, Diox chaan Abraham, chaan Isaac ne chaan Kob”. Ex. 3:6 Tsa lee Moisés mzeb ne mzhiit ne myet raa leettsoo Moisés gawii Moisés kona. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tsa lee Zha Nabee nzhab lo Moisés: “Kib labyid niiʼa, tak lee ta ndoʼa, nak thib ta nayon. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Na ngewii naa xa ngeriid re zha da kuu nzo Egipto yalti, ne asta nzhonn zha naab zha lon. Kona mlan tsa gon zha, de nzhee, tsa taalʼn lu Egipto.” Ex. 3:5,7 ");
INSERT INTO zaoNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Ne tegal mzegeyt re zha Moisés, or kuu nzhab zha lo Moisés: “¿Cho mtoʼa gaka zha kuu nabee ne naaba kwent lo nee?” Per lee Diox mtaal Moisés, tsa nabee Moisés lo re teyaa, ne Moisés ngwa mloo re zha Egipto, ne lee mandad chaan Diox mtsow ayud Moisés, leeka mandad kuu mloo lo Moisés ndrol xid bel lo ya bxiid. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ne Moisés nak cho mloo re teyaa zha ndala yezlyu Egipto, ne kon yalney chaan Diox mtsow Moisés kwaro kuu thoz yezlyu Egipto ne lo Nitdoo Nane ne lo yubiz thib chop gal liin. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ne leeka Moisés ree nzhab lo re zha Israel: “Diox kwii thib zha xid re goo kuu gak profet taxal na”. Dt. 18:15 ");
INSERT INTO zaoNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ne Moisés mndo kon re teyaa yubiz, ne leeka lo Moisés mni mandad chaan Diox yek yii Sinaí, ne lee Moisés mkayaa ley chaan Diox ne mndaay lo re teyaa zha ndala ne tabaaga mriide loʼaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Per lee re teyaa zha ndala, ngwalaazt zha gagon zha diiz lo Moisés, ne mlaazt re zha Moisés, leel ngwalaaz re zha garetab zha Egipto tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ne nzhab re zha lo Aarón: “Btexkwaa thib diox kuu tener loʼaa, tak netaa naa kwan ngok kon Moisés kuu mloo reʼaa yezlyu Egipto”. Ex. 32:1 ");
INSERT INTO zaoNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tsa mdexkwaa zha thib ngon lut kuu or, kuu mtsow zha diox zha, ne mbeth zha maa mndaa zha lo kona, ne mtsow re zha thib ani lo kuu mdexkwaa re zha, tak kwathoz wen ngoo leettsoo re zha mdexkwaa zhay. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kona mlaa Diox re zha, ne mlaa Diox mbil re zha lo wiz, lo mbee ne lo re mbel kuu nzib lobee. Tak tabaa nke lo xkeets Diox, kuu mkee re profet lo re men, leettsa nzhab profet: Zha Israel, leettsa mndiy re goo yubiz chop gal liin, ¿chu lon mndaa goo re maa kuu mbeth goo? ");
INSERT INTO zaoNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mndaat gooy lon sinke leel lo Moloc mbil goo, ne lo mbel chaan Refán, re diox kuu leeka re goo mdexkwaa ne mndeno re goo yuu yid chaan kona. Ta mod taalʼn goo mas tith lo Babilonia. Amós 5:25-27 ");
INSERT INTO zaoNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Leettsa mndiy re teyaa zha ndala yubiz, mkeno re zha yuu yid, ta mbil re zha lo Diox yubiz, ne leene mlotsow zha re ley chaan Diox. Ne yuu yid ree mdexkwaa taxal nzhab Diox lo Moisés. Or nzhab Diox lo Moisés tsow Moisése taxal kuu mloo Diox lo Moisés. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ne yuu yid ree myaan lo re teyaa zha ndala, ne re zha Josué mbe zhay, leettsa mbyo re zha kon tedib net yez, par mtsow zha gan yezlyu, ne Diox mtsow ayud re zha tsa mtsow zha gane, ne yuu yid ree mkeno re zha, asta wiz kuu ngok David rey. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ne lee Diox kwathoz wen ngoo leettsoo mne rey David, ne leeka David ngwalaaz gataa gwodoo chaan Diox reʼaa zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Per rey Salomón raa mdexkwaay. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Tegal nzot Diox leen gwodoo kuu ndexkwaa men, taxal nzhab profet kuu ngoo ndala, or kuu nzhab profet: ");
INSERT INTO zaoNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Yibaa nak ta ndobʼn nabeen, ne lo yezlyu nak ta ndo nin. ¿Cho yuu taa goo par na? ¿Pa texkwaa goo neyʼn? ");
INSERT INTO zaoNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Chu nagt na cho mdexkwaa reta kwaa? Ne Zha Nabee. Is. 66:1-2 ");
INSERT INTO zaoNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Per lee re goo nzhab Steb: ―Thitanax nad goo, taxal zha ndobt nza ntsow goo, ne nlaazt goo tsow goo kuu nlaaz Diox, neeka nlaazt goo gon goo kuu nlaaz Mbi Nayon chaan Diox ne lo goo, leeka taxal ngok re teyaa zha ndala taga nak goo. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Ne cho thib re profet kuu ngoo ndala, mtetit re teyaa zha ndala? Asta mbeth re teyaa re profet, or nzhab profet lee Zha Kuu Nali Nak Yaad, ne leettsa myaad Zha Kuu Nali Nak, mzhen goo zha ne mnabee goo mbeth zha, zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ne tegal re goo mkayaa ley chaan Diox lo re mandad chaan Diox, per nzhont goo diiz kuu nzhab lo ley. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Leettsa mbin re zha diiz ree, kwathoz mkezhyan zha ne asta nduub zha keley zha, tak kwathoz mnayii zha mne zha Steb. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ne lee Mbi Nayon kwaro nabee leettsoo Steb, ne mwii Steb yibaa ne mloo xni yibaa chaan Diox lo Steb, ne mloo lo Steb lee Jesús ndo lad ban lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tsa nzhab Steb: ―¡Wii goo! Ngewiin lee yibaa ndezhaal, ne lee Jesucrist ndo lad ban lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Per lee re zha mtow zha nza zha, ne mrezta zha ne mbig zha mzhen zha Steb. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Tsa mloo re zha Steb yez ne mkee zha ke yek Steb, ne lee re zha kuu mkee ke yek Steb, mlaa re zha chamar zha, tsa lee thib nde kuu le Saulo mkenape. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ne or ngekee re men ke yek Steb, lee Steb mnaab lo Diox ne nzhab: ―Jesús Zha Nabee, bkayaa xbi da. ");
INSERT INTO zaoNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Or ngwalo nzhab Steb koree, tsa mtobxub Steb ne dib gan Steb mrez Steb, ne nzhab Steb: ―¡Zha Nabee, naabta kwent re kuu went kuu ngetsow re zha ree lon! Leettsa ngwalo tata nzhab Steb, ora nguth Steb. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ne wen ngoo leettsoo Saulo lee Steb nguth. Ne leeka re wiza mndelo re men mreke dits reta zha kuu nyelaaz Jesús yez Jerusalén. Kona reta zha mraats ndya tedib re yez chaan yezlyu Judea ne yezlyu Samaria beeta re apóstl myaan Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ne thib chop mbyi kuu thib mloo yek tsow kuu nlaaz Diox mkaats Steb, ne kwathoz mbinn zha lo Steb. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ne lee Saulo mreke dits re zha kuu nyelaaz Jesús, ne ndaab Saulo liz re zha, ne lafwers ndeno Saulo mbyi ne ngot ngo Saulo tsib. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Per lee re zha kuu mraats mndaa zha kwent xkiiz Diox reta ta nda zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Tsa lee Lip ngwa yez Samaria ne mndaa zha kwent xkiiz Diox tya. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kwaro men nkaltaa, ne nkenza zha kuu ni Lip, ne mwii zha re milagr thoz kuu ntsow Lip. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ne kwaro zha kuu nzo mbi fyer leettsoo ngwe, ne mbetsyath re mbi fyer ndroo, ne lee re zha mthans ne re zha koj mgwe, ");
INSERT INTO zaoNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","kona kwathoz laz re men yeza. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Per tya ngoo thib mbyi kuu le Simún, zha kuu mtsow yalwez ne mkedi Simún re men yez Samaria, mtsow Simún taxal thib zha kuu kwathoz nataak. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Reta men nzhon re kuu mbez Simún, desde zha mndyeen asta zha gox ne mbez re zha: ―Mbyi ree nap yalney chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nyelaaz re men kuu mbez Simún, tak kon yalwez mkedi Simún re men naroob tyemp. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Per leettsa mndaa Lip kwent naa xomod nak yalnabee chaan Diox ne chaan Jesucrist; tsa ngwalaaz re zha Diox, ne mbyi ne ngot ngokleyy. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Asta noga Simún ngwalaaz Diox ne ngokleyy ne mndeke Simún dits Lip, ne kwathoz mzegey leettsoo Simún mwii re milagr thoz kuu ngok. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ne leettsa mbin re apóstl kuu nzo Jerusalén lee re zha yez Samaria ngwalaaz Diiz Chul chaan Diox, tsa mtaal zha Pey rop Juan tya. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ne or mzin rop zha tya, mnaab zha lo Diox por re zha kuu ngwalaaz Jesús tya; tsa kayaa re zha Mbi Nayon. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tak neeka thib re zhaʼa ter kayaa Mbi Nayon, beeta ngokleyy re zha kon le Jesús Zha Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tsa lee Pey rop Juan mxoob yaa yek re zhaʼa, ne tata mkayaa re zha Mbi Nayon. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Leettsa mwii Simún lee rop apóstl nxoob yaa dits re men, ne lee re men nkayaa Mbi Nayon, tsa ngwalaaz Simún gataa temi lo rop apóstl, ");
INSERT INTO zaoNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ne nzhab Simún lo rop apóstl: ―Noga lon taa goo yalnabee baa, tsa noga na or xoobʼn yaan dits re men, tsa noga re zha kayaa Mbi Nayon. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Tsa lee Pey mkab lo Simún, ne nzhab: ―¡Lu ne temiʼa lux kon lu, tak ntsowa xgab kon temi tiiʼa kuu nataak kuu ndelaaz Diox! ");
INSERT INTO zaoNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ndoblota ne neeka nzaalt tsowa tsiin ree, tak nalit nak leettsooʼa lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Blaa re xgab went kuu nzo yeka, ne bnaab lo Diox tsa naa chu tetuyy Diox xgab went kuu mtsowa. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tak nyeen na anta yalnayii nzo leettsooʼa, ne naliiba lo kuu went kuu nabee loʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tsa mkab Simún ne nzhab Simún: ―Naab goo lo Zha Nabee, tsa neeka thib re kuu ne goo lon tagtʼn. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Leettsa ngwalo mndaa rop apóstl kwent chaan Jesús ne xkiiz Diox lo re zha yez Samaria, tsa mretab rop zha Jerusalén ne ndaa zha kwent Diiz Chul chaan Jesús re yez chaan Samaria. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Bluz or ngwalo mriid re koree, lee thib mandad chaan Zha Nabee, nzhab lo Lip: ―Gwa net yath, net kuu ndroo Jerusalén kuu nzin yez Gaza. Net kuu ndriid yubiz. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Tsa lee Lip ngoo net nda, ne neta mzaal Lip thib mbyi zha yezlyu Etiopía, zha ree nak Eunuco, thib zha nataak; mbyi ree nkenap temi Candace ngot kuu nak reyna kuu nabee dita Etiopía, mbyiʼa ndyaad ngwa Jerusalén ngwayol lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ne ndya zha laz zha, ndob zha leen karret zha ne ngelab zha yeets kuu mkee profet Isaí zha ndala. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Tsa lee Mbi Nayon nzhab lo Lip: ―Gwa tsa yedaab karret baa loʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ne leettsa ngwadaab karret lo Lip, tsa mbin Lip lee zha Etiopía ngelab yeets kuu mkee Isaí. Tsa mnaabdiz Lip lo zha, ne nzhab Lip: ―¿Chu nyena kuu ngelaba? ");
INSERT INTO zaoNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Lee zha mkab lo Lip nzhab: ―¿Xomod yen nay, os yent cho ne lon naa xomod nake? Tsa nzhab zha lo Lip kendab Lip leen karret zha, tsa tob Lip cho zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Lee xkiiz Diox kuu ngelab zha nak koree: Mbe zha zha taxal thib mbak zhiil lo yalguth; ne yent kwan nzhab zha taxal thib mbak zhiil kuu naxa lo re zha kuu ga yits lad maa. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ne leettsa mtsowno re men zha taxal nlaaz re men, ne mnaabt zha kwent lo zha taxal ndobloy, ¿Cho tak taa kwent chaan re raz zha? Tak mkib re zha yalnaban chaan zha lo yezlyu ree. Is. 53:7-8 ");
INSERT INTO zaoNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tsa lee zha Etiopía nzhab lo Lip: ―Tsow yalwen ne lon, ¿cho nteth profet? ¿Chu leeka lee profeta o tedib zhay? ");
INSERT INTO zaoNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tsa lee Lip mndelo mndaa kwent xkiiz Diox lo zha, kon leeka xkiiz Diox kuu ngelab zha, tabaa mndaa Lip kwent Diiz Chul chaan Jesús lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ne or mzin rop zha thib ta nzo nit, tsa nzhab zha lo Lip: ―Nzhee nzo nit, ¿chu tak gakleyyʼn? ");
INSERT INTO zaoNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Tsa lee Lip nzhab lo zha: ―Os leeʼa nyelaaza Jesús kon dib ndroo leettsooʼa, tak gakleyya. Lee zha mkab ne nzhab: ―Nyelazʼn lee Jesús nak Xgann Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tsa mnabee zha tekweet zha karret, ora mla rop zha ne mndaab zha leen nit, ne mtsowleyy Lip zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ne leettsa mroo rop zha leen nit, lee Lip mnith lo zha, tak lee Mbi Nayon chaan Zha Nabee mndeno Lip; ne kwathoz naley ngoo leettsoo zha Etiopía ndya zha xnet zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Leettsa myeen Lip lee Lip ndoʼa yez Azoto, tsa mriid Lip thib yez ne tedib yez, mndaa Lip kwent Diiz Chul chaan Jesucrist, asta mzin Lip yez Cesarea. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Lee Saulo be nayiika ne re zha kuu nyelaaz Jesús, ne nlaaz Saulo kuth re zha. Tsa ngwa Saulo lo ngwleyy kuu nabee lo reta ngwleyy. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ngwanaab Saulo thib yeets, tsa tak ya Saulo yez Damasco re ta nkaltaa re zha nteed zha xkiiz Diox, tsa liib Saulo mbyi na ngot kuu nyelaaz Jesús, ne teno Saulo zha tsa yo zha tsib yez Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Per leettsa ndo Saulo net gaxta yez Damasco, tsa cha mroo thib xni lobee kuu mla dita ta ndo Saulo. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Tsa ngob Saulo lo yu, ne mbin Saulo thib bos kuu nzhab lo Saulo: ―Saulo Saulo, ¿chebee ndrekeʼa ditsʼn? ");
INSERT INTO zaoNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Tsa mnaabdiz Saulo: ―¿Cho naka Zha Nabee? Ne lee bosa mkab lo Saulo, ne nzhab: ―Na nak Jesús, zha kuu ngerekeʼa dits. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Gwateli ne gwa yez Damasco, tya ne zha loʼa naa kwan ndoblo tsowa. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ne lee re zha kuu nda kon Saulo kwathoz mzeb zha, tak mbin zha bos, per yent kwan mloo lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Tsa ngwache Saulo; ne or mxaal Saulo ngutlo Saulo, nyenit raa ngutlo Saulo. Tsa mzhen re zha kuu nda kon lee Saulo yaa Saulo ne mndeno zha Saulo yez Damasco. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tya ngoo Saulo tson wiz ne ngwanit lo Saulo, neeka thib kuu ndowt Saulo ne neeka thib kuu ngwiit Saulo. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ne yez Damasco nzo thib mbyi kuu le Ananías kuu nyelaaz Jesús. Ne lee Jesús ngwanii lo Ananías, ne nzhab lo Ananías: ―¡Ananías! Tsa lee Ananías mkab ne nzhab: ―Leen ndo nzhee, ¿kwan nlaaza Zha Nabee? ");
INSERT INTO zaoNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ne lee Zha Nabee nzhab lo Ananías: ―Bteli ne gwa kay kuu le Nali, ne liz Judas naabdiza thib mbyi zha yez Tarso kuu le Saulo, tak lee Saulo ngenaab lon. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Tak lo Saulo ngwani thib mbyi kuu le Ananías, kuu mndaab ne mxoob yaa yek Saulo, tsa yeni lo Saulo tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Or mbin Ananías kona, tsa nzhab Ananías: ―Zha Nabee, kwaro zha ndaa kwent chaan mbyiʼa lon, ne re kuu went kuu ntsow Saulo lo re zha kuu nyelaaza Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ne lee nal ndyaad Saulo nzhee ne nap Saulo yalnabee chaan re ngwleyy kuu nabee lo re ngwleyy, tsa ten Saulo re zha kuu nyelaaz lu nzhee ne teno Saulo re zha Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Per lee Zha Nabee nzhab lo Ananías: ―Gwa, tak mliʼa na mbyiʼa par taa zha kwent xkizʼn lo re zha kuu nagt zha Israel, ne lo re rey yezlyu, ne noga lo re zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Na loo lo Saulo lee Saulo ndoblo rid kwathoz yalti, leettsa taa Saulo kwent xkizʼn. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tsa lee Ananías ngwa yuu ta mlet Saulo, ne or mndaab Ananías, tsa mxoob Ananías yaa Ananías yek Saulo, ne nzhab Ananías: ―Wets Saulo, lee Jesús Zha Nabee kuu ngwani loʼa or ndyaada net mtaalʼn, tsa yeni loʼa tedib welt, ne kayaaʼa Mbi Nayon chaan Diox leen leettsooʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ne oraaka ngob thib kuu na taxal med mbel ngutlo Saulo, ne mre ngwani lo Saulo tedib welt, tsa ngwateli Saulo ne ngokleyy Saulo. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Tsaraa ndow Saulo tsaraa mkaa Saulo fwers, ne mlet Saulo thiban wiz lo re wets kuu nyelaaz Jesús kuu nzo yez Damasco. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tsa lee Saulo mndelo mndaa kwent xkiiz Diox, lo re men ta nkaltaa re zha Israel nteed xkiiz Diox, ne mbez Saulo lee Jesús nak Xgann Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Reta zha kuu nzhon kuu mbez Saulo; mzegey leettsoo re zha ne mbez zha: ―¿Chu leet zha ree kuu ndreke dits re zha Jerusalén kuu nyelaaz Jesús? ¿Chu ndyaadt zha nzhee, tsa ten zha re zha kuu nyelaaz Jesús ne teno zha zha lo re ngwleyy kuu nabee lo re ngwleyy? ");
INSERT INTO zaoNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ne taxal ndriid wiz lee Saulo ngoo ney raa leettsoo, ndaa kwent xkiiz Diox, ne kwathoz nambi nzhab Saulo lee Jesús nak Crist Kuu Mtaal Diox Nabee, tsa lee re zha Israel kuu nzo Damasco, net zha naa kwan tsow zha xgab. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ne lutta ngwatey lee re zha Israel kuu nzo Damasco myaan diiz kuth Saulo, ");
INSERT INTO zaoNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","per myeen Saulo lee re men nlaaz kuth Saulo. Tse ne yaal ntow zha lo Saulo roo pwert yez, tsa kuth zha Saulo. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Per lee re zha kuu nyelaaz Jesús, yaal mloo zha Saulo leen thib chekwit ne mlaa zha Saulo lad cho blaa kuu now dita yez. Tbaa mroo Saulo yez. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Leettsa mzin Saulo Jerusalén, ngwalaaz Saulo gakaltaa kon re zha kuu nyelaaz Jesús tya; per reta zha nzeb lo Saulo, tak nyelaazt re zha lee Saulo nyelaaza Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Per lee Bernabé ngwano Saulo lo re apóstl. Ne nzhab Bernabé naa xomod mwii Saulo ne mni Jesús lo Saulo or ndo Saulo net nda Saulo yez Damasco. Ne xomod mzebt Saulo mndaa Saulo kwent chaan Jesús yeza ");
INSERT INTO zaoNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tsa lee Saulo myaan Jerusalén ne ndiy Saulo kon re zha. Ne mzebt Saulo ndaa kwent chaan Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ndediz Saulo ne ngyodiz Saulo kon re zha Israel kuu ndediz diiz gryeg; per lee re zha ree nlaaz kuth Saulo. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Leettsa myeen re zha kuu nyelaaz Jesús kona, tsa mndeno zha Saulo asta yez Cesarea, ne tya mtaal zha Saulo yez Tarso. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tsa lee re zha kuu nyelaaz Jesús, kuu nzo re yez chaan Judea chaan Galilea ne chaan Samaria, wen ngoo re zha tak ndreket raa zha dits zha, ne xlaazga mas wen myen re zha xkiiz Diox ne nzhon zha diize, ne lee Mbi Nayon mtsow masraa myazh re zha kuu nyelaaz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ne leettsa ndiy Pey re yez nyatwii Pey lo re zha kuu nyelaaz Jesús, noga ngwa Pey lo re zha kuu nyelaaz Jesús kuu nzo yez Lida. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tya mzal Pey thib mbyi kuu le Eneas, kuu nax ne ndak ne ndaʼa xon liin gagt gwin Eneas. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Tsa nzhab Pey lo Eneas: ―Eneas, mtegweʼa Jesucrist lu. “Gwache ne blit daʼa”. Ne oraaka ngwache Eneas. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ne mne reta zha kuu nzo yez Lida ne re zha kuu nzo laats Sarón kona, ne ngwalaaz zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ne tsya ngoo thib ngot kuu nyelaaz Jesús yez Jope, kuu lee Tabita (diiz gryeg le zha Dorcas). Lee ngot ree thibka mtsow yalwen, mtsow Dorcas ayud re zha prob dita lo mban Dorcas. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ne re wiza mlen liz Dorcas ne nguth Dorcas, ne ngwalo mtegat zha Dorcas, tsa mxoob zha Dorcas leen yuu kuu ndob yek yuuʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ne gax yez Jope nzi yez Lida ne tya ndo Pey, ne or mbin re zha kuu nyelaaz Jesús lee Pey ndo tya, tsa mtaal zha chop mbyi ngwachez Pey, ne nzhab re zha lo Pey: ―Tsow yalwen nda yez Jope. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Tsa mndeke Pey dits rop zha, ne or mzin re zha, tsa mndeno zha Pey yuu ta nax thebol, tya nzi re ngot byud nzhonn, ne mloo re ngot re lar kuu mdexkwaa Dorcas lo Pey, leettsa bee naban Dorcas. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Tsa mnabee Pey mroo reta zha kuu nzi tya, tsa mtobxub Pey ne mnaab Pey lo Diox: Ne ora mwii Pey lo thebol ne nzhab Pey: ―¡Tabita, gwache! Tsa lee ngot mxaal lo, ne or mxaal ngot lo ngot mwii ngot lo Pey, ne mndob ngot. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ne lee Pey mzhen yaa ngot mtsow ayud ngot mndeli ngot, tsaraa mrez Pey re zha kuu nyelaaz Jesús ne re byud, tsa mwii re zha lee ngot naban. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ne dita yez Jope myath koree ne kwaro zha ngwalaaz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ne lee Pey myaan thiban wiz yez Jope liz thib zha le Simún kuu nteguuz yid. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ne yez Cesarea ngoo thib mbyi kuu le Kornel, kuu nak soldad kuu mnabee lo thib gayoo soldad, partid kuu le Italiana. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ne Kornel nak thib mbyi kuu nali kuu thib mloo yek tsow kuu nlaaz Diox kon re lizta Kornel, ne kwaro mtsow Kornel ayud re prob zha Israel, ne thibka naab Kornel lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Thib wiz teeka las tres, taxal zha kuu ntsaa leettsoo ngwani thib mandad chaan Diox lo Kornel kuu mndaab ta ndo Kornel, ne nzhab lo Kornel: ―¡Kornel! ");
INSERT INTO zaoNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Tsa mwii Kornel lo mandad chaan Diox ne mzeb Kornel nzhab Kornel: ―¿Kwaan nlaaza, Zha Nabee? Tsa lee mandad chaan Diox nzhab lo Kornel: ―Mbina Diox re kuu nzhaba lo Diox, ne ngewii Diox xa ntsowa ayud re prob. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Btaal chop tson zha yez Jope, tsa yaxii zha Simún kuu noga le Pey. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Kuu nzo liz Simún kuu nteguuz yid, kuu ndob liz roo nitdoo, lee Pey ne loʼa naa kwan ndoblo tsowa. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Leettsa lee mandad chaan Diox kuu mndediz lo Kornel ndya, lee Kornel mrez chop zha kuu nke tsiin lo Kornel, ne thib soldad zha kuu wlipaa nyelaaz Diox, zha kuu ne Kornel tetsow kuu gab Kornel lo. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Leettsa ngwalo mndaa Kornel kwent kuu mzhaak Kornel lo re zha, tsa mtaal Kornel re zha yez Jope. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ne tedib wiz, leettsa lee re zha ndetsin gaxa yez Jope, teeka ndrol wiz lee Pey mkendab yek yuu, par tediz Pey lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kwathoz mlann Pey ne ngwalaaz Pey gawu Pey, per ora lee men ngetexkwaa kuu wu Pey, ne ora cha ngwani thib kwaa lo Pey, ");
INSERT INTO zaoNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ne mwii Pey mzhaal yibaa, ne mloo lo Pey thib kuu naa taxal thib le lar naro kuu ndob bgo re thapta skin, mlato lo Pey. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ne lo lara nzo relota maa kuu nde kon thap nii, noga re maa kuu ndedoob yu lo yu, ne re maa kuu nlazbi. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tsa mbin Pey thib bos kuu nzhab lo Pey: ―Pey, gwateli, beth maa ne dow maa. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Tsa lee Pey mkab ne nzhab: ―Gagte, Zha Nabee; neeka thib welt ter wun maa nambit kuu nzhowt men. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Lee bosa mre mni tedib welt, ne nzhab lo Pey: ―Loka kuu mtembiʼa Diox, ndoblot gaba nambite. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ne tson welt ngwani kona lo Pey, tsaraa lee lar mre ngwaap yibaa tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ne lee Pey kwathoz mtsow xgab naa kwan nak kuu mloo lo Pey, ne oraaka mzin re zha kuu mtaal Kornel roo liz Simún, tak mnaabdiza zha naa pa nak liz Simún. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ne or mzin re zha, mnaabdiz zha naa chu tya mbet Simún, kuu noga le Pey. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ne lee Pey bee ngetsow xgab naa kwan nak kuu mloo lo Pey, ne lee Mbi Nayon nzhab lo Pey: ―Wii lee tson mbyi ngekwaana. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Gwateli, bla ne ngwake dits re zha, ne gagt chop xgaba, tak na mtaal zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Tsa mla Pey mzin Pey lo re zha kuu mtaal Kornel, tsa nzhab Pey lo re zha: ―Na nak zha kuu nkwaan goo, ¿chebee ndyaad goo? ");
INSERT INTO zaoNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ne lee re zha mkab, ne nzhab: ―Nee ndyaad kwent chaan soldad Kornel, kuu nabee lo thib gayoo soldad. Lee Kornel nak thib mbyi nali, ne nzhon Kornel diiz lo Diox ne reta zha Israel ndediz wen zha Kornel. Ne thib mandad chaan Diox mni lo Kornel: Kona mtaal Kornel nee ndyaadxii nee lu, tsa yaʼa liz Kornel, ne lee Kornel gon re kuu gaba lo Kornel. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tsa lee Pey nzhab lo re zha: ―Briid goo leen yuu. Ne tya myaan re zha yaala, lee tedib wiz ngwa Pey kon re zha, ne noga thiban re zha kuu nyelaaz Jesús ngwa kon Pey. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ne tedib wiza mzin re zha yez Cesarea, ta nak liz Kornel, ne lee Kornel mkaltaa re zha Liz Kornel ne re amig Kornel ne ngebet Kornel tsin Pey. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Or mzin Pey liz Kornel, ora mroo Kornel mkayaa Pey ne mtobxub Kornel lo Pey taxal lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Per lee Pey mteli Kornel, ne nzhab lo Kornel: ―Gwateli, tak roptalee nak men. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ne ngetediz Pey rop Kornel asta mzin roo pwert yuu, tsa mndaab Pey leen liz Kornel, ne mwii Pey kwaro men mkaltaa tya. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tsa nzhab Pey lo re zha kuu nzi tya: ―Wen ne re goo lee thib zha Israel, ndaat ley chaan nee diiz tsaal nee kon re zha kuu nagt zha Israel, ne neeka ndoblot nee tab nee leen liz zha, per lee Diox mlooʼa lon, ndoblot gapʼn lo neeka thib men lee zha nambit nak, neeka ndoblot tsowʼn xgab went nak zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kona ndyalʼn leettsa mrez goo na, ne neeka mtotʼn neeka thib kuu tsa gayaltʼn. Ne lee nal nlazʼn nen naa chebee mrez goo na. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornel mkab ne nzhab: ―Ndaʼa thap wiz leeka or ree, ndon nzhee lizʼn teeka las tres, ngetsowʼn ayun ne ngetedizʼn lo Diox, ne oraaka ngwani thib mbyi kuu nok thib lar kuu kwathoz nla xni lon. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Kuu mne lon: “Kornel, mbina Diox re kuu mnaaba lo Diox, ne ngewii Diox naa xa ntsowa ayud re zha prob. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Btaal zha ya yez Jope yaxii Simún, kuu noga le Pey, lee Pey nzo liz Simún kuu nteguuz yid kuu ndob liz gax roo nitdoo, lee Pey ne loʼa naa kwan ndoblo tsowa.” ");
INSERT INTO zaoNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ta mod mtaalʼn zha ngwaxiiʼa. Ne wen mtsowa ndyaada, ne nalor lee Diox ndewii lee retalee nzi nzhee ne nlaaz nee gon nee reta kuu mnabee Diox loʼa neʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tsa mndelo Pey mni ne nzhab: ―Nalsi nen wlipaa lalka nataak reta men lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ne nkayaa Diox re zha kuu wlipaa ntsow kuu nlaaz Diox, tegal zha tedib yez nak zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Diox mniʼa lo re zha raz Israel, nzhaba Diox lo re zha naa xomod wen kwin re zha kon Diox, kwent chaan Jesús, Zha Nabee lo reʼaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Goo mbin xomod mndaa zha kwent chaan Jesús desde yezlyu Galilea ne asta dita yezlyu Judea, leettsa mndelo Juan mndaa kwent lo re men, lee re men ndoblo gakleyy. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ne wen ne goo lee Diox mndaa Mbi Nayon ne yalnabee lo Jesús zha Nazaret, ne Jesús ree mndiy mtsow yalwen ne mtegwe re zha kuu nzo mbi fyer leettsoo, ne reta koree ngok mtsow Jesús, tak lee Diox ndo kon Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ne nee nak cho mwii reta kuu mtsow Jesús dita yezlyu Judea ne yez Jerusalén. Ne or ngwalo mriid koree, tsaraa mbeth zha Jesús ne mkee zha Jesús lo kruz. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Per lee Diox mteroban Jesús leettsa ndaʼa tson wiz nguth Jesús, ne mndaa Diox diiz ngwani Jesús lo re nee. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ne ngwanit Jesús lo reta men, sinke beeta lo re nee kuu mteed lo zha ngwani zha, ne nee ngok zha kuu mwii reta kuu mtsow Jesús. Ne re nee ndow ne ngwii kon Jesús, leettsa mroban Jesús xid re zha nguth. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Lee Jesús mtaal nee tsa taa nee kwent chaan Jesús lo re men, tak Diox mto Jesús, tsa naab Jesús kwent lo re zha kuu naban ne lo re kuu ngutha, leettsa tsin wiza. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ne reta profet kuu mndaa kwent xkiiz Diox lo re men ndala, mndaaʼa profet kwent chaan Jesús, leettsa nzhab profet: “Reta zha kuu yelaaz Jesús; tetuyy Diox falt zhaʼa, tak ngwalaaz zha Jesús”. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Bee ngetedizka Pey, lee re men kuu nzi ngeyon kuu nzhab Pey mkayaa Mbi nayon. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ne lee re zha Israel kuu nyelaaz Jesucrist kuu ngwake dits Pey, kwaro mzegey leettsoo re zha, tak noga re zha kuu nagt zha Israel mkayaa Mbi Nayon. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Tak mbin re zha lee re zhaʼa ndediz tedib net diiz ne nzhool zha lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Tsa nzhab Pey lo re zha: ―¿Chu nzo men tak ne, gagt gakleyy re zha ree kuu mkayaaʼa Mbi Nayon taxal reʼaa? ");
INSERT INTO zaoNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tsa mnabee Pey gakleyy re zhaʼa kon le Jesucrist. Tsa nzhab re zha lo Pey kwet Pey lo re zha chop tsonta wiz. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Lee re apóstl kon re zha Judea kuu nyelaaz Jesús, mbin re zha lee re zha kuu nagt zha Israel ngwalaaz xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ne leettsa mre Pey Jerusalén, tsa lee chop tson re zha Israel kuu nyelaaz Jesús, re zha kuu bee ntsowka kuu nzhab lo ley, mndelo zha mbyodiz zha kon Pey. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ne nzhab re zha lo Pey: ―¿Chebee ngwaʼa liz zha kuu nagt zha Israel, ne mdowa kon re zha? ");
INSERT INTO zaoNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tsa lee Pey nzhab lo re zha, naa chebee ngwa Pey, ne mndelo Pey nzhab reta kuu ngok. Ne nzhab Pey: ");
INSERT INTO zaoNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Leettsa mndon yez Jope ngetedizʼn lo Diox, tsa taxal lo mkaal ngwani thib kwaa lon: Kuu na taxal thib le lar naro kuu naliib re thapta skin kuu ndyaadla lobee, ndyaad asta ta ndon. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ne or wen mwiin naa kwan nzo leen lara, tsa mwiin re maa nayii, re maa thap nii, re maa kuu ndedoob lo yu ne re maa nlazbi. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tsa mbin na thib bos kuu mne lon: “Pey, gwateli, beth maa ne dow maa”. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ora nzhapʼn: “Gagte Zha Nabee, tak neeka thib welt ter wun maa kuu nambit, maa kuu nzhowt men”. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Tsa lee bosa mre mni lon desde lobee tedib welt ne ne lon: “Loka kuu mtembiʼa Diox gabta nambite”. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tson welt ngok koree, tsaraa mrey ngwape lobee tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ne ora lee tson mbyi mzin roo yuu ta ndon, re zhaʼa mroo desde Cesarea ne myaad kwaan zha na. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Tsa lee Mbi Nayon ne lon: “Bteke dits zha”; noga mndenon xoop wets, ne reta nee mndaab liz Kornel. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ne lee Kornel mndaa kwent lo nee, naa xomod mwii Kornel thib mandad chaan Diox liz Kornel, kuu nzhab lo Kornel: “Btaal zha ya yez Jope yaxii Simún kuu noga le Pey; ");
INSERT INTO zaoNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","lee Pey ne loʼa naa xomod laaʼa lo re falta, lu ne reta zha liza”. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ne leettsa mndelon mndan kwent lo re zha, tsa mkayaa re zha Mbi Nayon, leeka taxal mkayaa releey ner. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tsa mtelaazʼn xkiiz Jesús, leettsa nzhab zha: “Wlipaa lee Juan mtsowleyy kon nit, per lee re goo gakleyy kon Mbi Nayon”. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kona nal, os lee Diox mndaa lo re zhaʼa leeka kuu mndaa Diox lo reʼaa, leettsa ngwalaazaa Jesucrist Zha Nabee loʼaa, gagt gapʼn went kuu ngetsow Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Or mbin re zha koree, yent raa kwan nzhab zha, neeka mnayiit raa zha, ne mbil re zha lo Diox ne nzhab zha: ―¡Nalsi ne nee noga re zha kuu nagt zha Israel, mloo Diox naa xomod laa zha lo re kuu went kuu ntsow zha, tsa bre zha lo Diox, ne tsow zha gan yalnaban kuu thitanax! ");
INSERT INTO zaoNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Bluz or ngwalo mbeth zha Steb, mndelo re zha mreke zha dits re zha kuu nyelaaz Jesús, tsa lee re zha mzhonn, cho zha ndya yezlyu Fenicia, cho zha ndya yezlyu Chipre ne cho ndya yez Antioquía, tya mndelo re zha mndaa zha kwent Diiz Chul, beeta lo re zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Per xid re zhaʼa ngoo chop tson zha Chipre ne zha yez Cirene, leettsa mzin re zha ree yez Antioquía, tsa noga mndelo zha mndaa zha kwent Diiz Chul chaan Jesús lo re zha kuu nagt zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ne lee yalney chaan Zha Nabee ndo kon re zha, ne ta mod kwathoz zha mlaa re kuu nyelaaz zha ndala, ne ngwalaaz Jesús Zha Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Or mbin re zha Jerusalén kuu nyelaaz Jesús kona, tsa mtaal zha Bernabé yez Antioquía. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ne leettsa mzin Bernabé tya, kwathoz naley ngoo leettsoo Bernabé mne Bernabé naa xomod ngetsow Diox ayud re zhaʼa, tsa mteni Bernabé re zha, tsa laat zha xkiiz Jesús kuu ngwalaaza zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Tak lee Bernabé nak thib zha wen, ne kwaro nabee Mbi Nayon chaan Diox leettsoo Bernabé, ne wlipaa nyelaaz Bernabé Jesús. Ta mod kwaro men ngwalaaz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tsaraa ngwa Bernabé yez Tarso ngwakwaan Saulo, ");
INSERT INTO zaoNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ne leettsa mzal Saulo lo Bernabé, tsa mndeno Bernabé Saulo yez Antioquía, tya mlet rop zha thib liin lo re zha kuu nyelaaz Jesús ne mloo rop zha lo re men. Ne tya mndelo re men mtob le re zha kuu nyelaaz Jesús “cristian”. (Diiz ree nak: “zha kuu ndeke dits Jesús”.) ");
INSERT INTO zaoNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Re wiza, chop tson profet mroo Jerusalén ngwa yez Antioquía. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Thib re profeta le Agabo ngwateli ne nzhab, kuu nzhab Mbi Nayon: ―Lee win la dita yezlyuʼa. Ne koree ngok, leettsa mnabee rey Claudio. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tsa lee re zha Antioquía kuu nyelaaz Jesús, myaan diiz kaltaa loka kuu takta taa kadta thib zha, tsa tsow zha ayud re zha kuu nyelaaz Jesús kuu nzo yezlyu Judea. ");
INSERT INTO zaoNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ne tata mtsow re zha Antioquía, tsa mtaal zha Bernabé rop Saulo yataane lo re zha kuu nabee, lo re zha kuu nyelaaz Jesús kuu nzo yezlyu Judea. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Re wiza lee rey Herodes mzhen thib chop re zha kuu nyelaaz Jesús, tsa teti rey zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Mnabee Herodes mbeth zha Santiag wets Juan kon espad, ");
INSERT INTO zaoNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ne mwii Herodes wen ngoo leettsoo re zha Israel, tak mtsow Herodes kona, tsa mnabee Herodes mzhen zha Pey, koree ngok re wiz ani kuu nzhow zha pan kuu nyoot lebadur. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Mzhen zha Pey ne mloo zha Pey tsib, ne mnabee Herodes thap grup soldad kenap Pey, ne thapga soldad nak thib grup. Mtsow Herodes xgab loo zha Pey lo re men yez or yelo rid ani Paskw. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Lee Pey nzo tsib, ne kwathoz wen mkenap zha Pey, per lee re zha kuu nyelaaz Jesús thibka ngenaab lo Diox kwent chaan Pey. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Leeka yaal kuu yeni yezlyu kuu nak diiz galoo Herodes Pey lo re men yez, lee Pey naxat xtow chop soldad, ne naliib Pey kon chop kaden, ne lee tedib net soldad ngekenap roo pwert tsib. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tsa cha mzin thib mandad chaan Diox lo Pey, ne dita leen tsib mla xni, tsa lee mandad mkwin cho Pey mloo mkaal lo Pey, ne nzhab lo Pey: ―¡Lijer gwache! Oraaka lee kaden mzhak yaa Pey. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Tsa nzhab mandad lo Pey: ―Btedoo leeyya, ne bkee labyida niiʼa. Ne tata mtsow Pey, tsa nzhab mandad lo Pey: ―Bdok xabitsa ne bteke ditsʼn. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ne oraaka mndeke Pey dits mandad, ne neeka net Pey naa chu wli o wlit kuu ngetsow mandad, tak mzhaak Pey ngetsaa leettsoo Pey. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Mbriid rop zha lo thib grup soldad kuu nkenap, ne tataka mriid zha lo tedib grup, tsaraa mzin Pey roo pwert yiib kuu nke roo kay. Lee pwert ree tubta mzhaal par mroo rop zha. Or ngwalo mriid Pey tedib kay, tsa lee mandad mlaa thita Pey. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tsaraa myeen Pey kuu ngok ne nzhab Pey: ―Nalsi nen lee Diox mtaal mandad Diox par mtelan lo Herodes ne lo re kuu nlaaz re zha Israel tsownon. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ne or ngwalo myeen Pey kona, ora ndya Pey liz Mari xnaa Juan kuu noga le Mark, ne kwaro men nzi tya ngenaab lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ne or mteez Pey roo pwert, tsa mroo thib nzaa kuu le Rode wii naa choy. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ne or myeen nzaa bos Pey, kwathoz naley ngoo leettsoo nzaa, ne mzhonn nzaa ngwalo nzaa diiz lo re zha, lee Pey ndo dits pwert lee. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ne lee re zha nzhab lo nzaa: ―¡Nzhak bxen yeka! Per lee nzaa nzhab: ―Wlicheen na kuu nin lo goo. Lee re zha mkab nzhab: ―Nagte Pey, ser mandad kuu nkenap Peya. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Per lee Pey ngeteezka roo pwert, ne or mxaal zha roo pwert kwaro mzeb re zha mwii zha lo Pey. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Tsa lee Pey mtsow seny lo re zha, tsa keet raa zha bi ne mndaa Pey kwent naa xomod mloo Zha Nabee Pey tsib. Noga nzhab Pey: ―Guz goo koree lo Santiag ne lo reta wets kuu nyelaaz Jesús, tsaraa mroo Pey ndya tedib ta. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Leettsa ngwani yezlyu, lee re soldad neeka net re soldad naa kwan tsow re soldad xgab, tak net zha naa kwan ngok kon Pey. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Tsa lee Herodes mnabee kwaan re soldad Pey, per mzalt Pey lo re zha. Ne or ngwalo mnaabdiz rey Herodes lo re soldad, naa kwan ngok kon Pey, tsa mnabee Herodes mbeth zha re soldada. Leettsa ngwalo mriid koree, lee Herodes mroo yezlyu Judea ne ndya ngoo Cesarea. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Kwathoz mnayii Herodes mne re zha yez Tiro ne re zha yez Sidón, per lee re zha rop yez ree myaan diiz, naa xomod tsow zha gan tediz zha kon Herodes, re zha ree mtsow gan myey kon Blasto, thib zha kuu kwathoz nataak, kuu nke tsiin lo rey Herodes, ne por zhaʼa mnaab zha wen kwin re zha kon Herodes, tak reta yez ta nabee Herodes, tya ndroo re kuu nzhow re zha rop yeza. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodes mto thib wiz, kuu tediz Herodes kon re zhaʼa, ne wiza mdok Herodes xab Herodes kuu mas wen, ne mndob Herodes lo asi ta nabee Herodes ne mndelo Herodes mni lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tsa lee re men mndelo nex mrez ne nzhab: ―¡Lee zha kuu ngeni ree nagt zha men, lee zha nak thib diox! ");
INSERT INTO zaoNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ne oraaka lee thib mandad chaan Diox mtsow mlen liz Herodes, ne ndow mbyaat Herodes leettsa nguth Herodes. Tak mlaa Herodes mtsow nataak re men Herodes taxal Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Per lee xkiiz Diox ndiyka ngeraats reta ta, ne reta ta masraa ngeyax re zha kuu nyelaaz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Or lee Bernabé rop Saulo ngwalo mtsow zha kuu nak diiz tsow zha yez Jerusalén, tsa mre rop zha yez Antioquía ne mndeno zha Juan kuu noga le Mark. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Xith re zha kuu nyelaaz Jesús yez Antioquía, ngoo profet ne maestr kuu ndaa kwent xkiiz Diox. Ne re zha ree nak, Bernabé, Simún kuu ni zha Niger, Lus zha yez Cirene, Manaén kuu thibka mzhen kon rey Herodes kuu mnabee yezlyu Galilea ne Saulo. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Thib wiz leettsa lee re zha ngetsow ayun ne ngeyol lo Diox. Tsa lee Mbi Nayon nzhab lo re zha: ―Bli goo Bernabé rop Saulo, tsa tsow zha tsiin kuu mrezʼn zha tsow zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Leettsa ngwalo mnaab re zha lo Diox ne mtsow zha ayun, tsa mxoob re zha yaa zha yek Bernabé rop Saulo, tsa tsow Diox ayud rop zha, par tsow zha tsiin kuu mrez Diox zha tsow zha. Ne ngwatenet zha rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ne lee Mbi Nayon mtaal Bernabé rop Saulo yez Seleucia, tya ngoo zha leen bark ndya zha par Chipre, thib yezlyu kuu nzi leen nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Or mzin zha thib yez kuu le Salamina kuu nzi yezlyu Chipre, tya mndelo zha mndaa zha kwent xkiiz Diox ta nkaltaa re zha Israel nteed xkiiz Diox, ne noga mndeno zha Juan Mark par tsow ayud zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Mbriid zha dita yezlyu Chipre ne mzin zha yez Pafos, tya mzaal zha thib zha Israel kuu nak wez, kuu le Barjesús, zha ree nkedi re men, mbez zha lee zha nak profet. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ne nyey zha Sergio Paulo thib mbyi kuu kwathoz nalatts, ne Sergio Paulo nabee dita yezlyu Chipre, ne mtaal Sergio Paulo zha mrez Bernabé rop Saulo, tak nlaaz zha gon zha xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Per lee wez Barjesús kuu noga le Elimas diiz gryeg, nlaazt zha yelaaz Sergio Paulo xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tsa lee Saulo kuu noga le Paba, kuu thitanax nabee Mbi Nayon leettsoo, key mwii lo weza. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Ne nzhab lo weza: ―¡Zhiinn Maxuuy, zha mal, zha nkedi, kuu nlaaz luux kuu wen! ¿Asta pol laaʼa teke re men net nali chaan Diox? ");
INSERT INTO zaoNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kona teti Diozha ne yaana syeg ne gagt raa wiiʼa xni wiz thib tyemp. Oraaka mkow lo Elimas ne ngogt raa gawii zha, tsa mkwaan zha cho ten yaa zha par teno zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Or mwii zha kuu nabee yezlyuʼa koree, tsa ngwalaaz zha yalney chaan Diox, ne kwathoz mzegey leettsoo zha mbin zha xkiiz Jesús kuu mloo Paba lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Or ngwalo mriid koree, lee re altaa Paba ngoo bark yez Pafos ne ngwa zha yez Perge kuu nzi yezlyu Panfilia. Tya mlaa Juan Mark rop zha, tsa mre Juan Mark Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Paba rop Bernabé mroo yez Perge ndya mzin yez Antioquía kuu nzi yezlyu Pisidia. Ne leettsa ngok wiz sabd ngwa zha ta nkaltaa re zha Israel nteed xkiiz Diox, ne mndob zha tya. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Leettsa ngwalo mlaab zha yeets kuu mkee Moisés ne kuu mkee re profet, tsa lee re zha kuu nabee ta nkaltaa re zha Israel, mtaal zha, zha nzhab lo rop zha: ―Wets, ¿os nlaaz goo ne goo thib diiz lo nee, tsa koney goo leettsoo re nee kuu nyelaaz Diox? ¡Ne gooy nalor! ");
INSERT INTO zaoNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Tsa lee Paba ngwateli, ne kon yaa zha mtsow zha seny tsa keet re zha bi, ne nzhab zha: ―Zha Israel kenza goo koree, ne noga re goo zha tedib yez kuu nzhon diiz lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Lee Diox reʼaa, mli re teyaa zha ndala ne mtsow Diox ngok re zha thib yez naro, leettsa bee nzo re zha yez Egipto taxal zha tedib yez, ne bluz kon yalney chaan Diox, mloo Diox re zha yezlyuʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ne mkez leettsoo Diox mne Diox re zha chop gal liin, leettsa mndiy re zha yubiz, ");
INSERT INTO zaoNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ne mluux Diox gaz nación kuu nzo yezlyu Canaán, ne mndaa Diox yezlyuʼa lo re teyaa zha ndala. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Re koree ngok thap gayoo chop galbtsii liin. Tsaraa mli Diox re jwez kuu mnabee lo re teyaa zha ndala, ne profet Samuel ngok jwez bluz lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Bluz mnaab re zha thib rey kuu nabee lo re zha, tsa lee Diox mli Saúl xgann Cis, zha nak zha raz Benjamín ne chop gal liin ngok Saúl rey. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Leettsa mkib Diox rey Saúl lo re zha, tsa mli Diox David ngok rey lo re zha, ne nzhab Diox: “Mwiiʼa na lee David xgann Isaí nak thib zha kuu nlaa leettsoon, ne tetsow zha kuu nlazʼn”. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ne leeka lo raz David myaad Jesús, Zha Kuu Mtaal Diox Nabee, par telaa re men Israel lo yalguth, taxal nzhab Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Leettsa bee ter yaad Jesús, Juan nzhab lo re zha Israel ndoblo laa zha re kuu went ne ndoblo gakleyy zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ne or mera luux Juan rtsin Juan, nzhab Juan: “¿Nagtʼn zha kuu ntsow goo xgab? Per ndyaada zha kuu mas nataak nake na, zha kuu neeka ndoblotʼn kibʼn labyid nii”. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Wetsʼn retalee kuu nak zha raz Abraham, ne re goo zha tedib yez kuu wlipaa nzhon diiz lo Diox; lee diiz kuu ndaa yalnaban ree nak par retalee. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tak lee re zha Jerusalén ne re zha kuu nabee lo re zha, mndaat zha yek zha gagon zha diiz lo Jesús, neeka myent zha kuu mbez lo xkiiz Diox kuu mkee re profet, kuu nlab zha ta nkaltaa re zha nteed zha xkiiz Diox reta wiz kuu ndroxkwan zha. Kona mbeth zha Jesús, ne tabaa ngok re kuu nke lo xkeets Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ne tegal mzalt zha neeka thib kuu keki zha Jesús, par tak kuth zha Jesús, per lee re zha nzhab lo Pilat “¡Beth Jesús!” ");
INSERT INTO zaoNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bluz or ngwalo mtsowno zha Jesús reta kuu ndaa xkiiz Diox kwent rid Jesús, tsa mla zha Jesús lo kruz ne mkaats zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","¡Per lee Diox mteroban Jesús! ");
INSERT INTO zaoNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ne tyen wiz ngwani Jesús lo re zha kuu ngwa kon lee Jesús, leettsa mroo Jesús yezlyu Galilea ne ngwa Jesús Jerusalén. Ne nal lee re zha ree nak zha kuu ndaa kwent chaan Jesús lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Ne lee nal lee re nee ndaa kwent chaan Diiz Chul chaan Jesús lo re goo, kuu nzhab Diox tsow Diox lo re teyaa zha ndala. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Lee Diox mtsow koree loʼaa, zha kuu nak raz re zhaʼa, koree mtsow Diox leettsa mteroban Diox Jesús, taxal nke lo salm chop ta nzhab: “Lu nak xgann na, ne na mnda yalnaban loʼa naltseree”. Sal. 2:7 ");
INSERT INTO zaoNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Diox nzhaba lee Diox teroban Jesús, tsa yetsaat kwerp Jesús; taxal nzhab xkiiz Diox ta nzhab: “Tetsowʼn lo re goo reta kuu nali ne wli kuu nzhapʼn lo David tsowʼn”. Is. 55:3 ");
INSERT INTO zaoNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Noga tata nzhab tedib salm: “Neʼa lu taata diiz yetsaa kwerp mosa kuu nayon”. Sal. 16:10 ");
INSERT INTO zaoNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Lee kuu mbez salm ree nagt par David, leettsa ngwalo mnabee David lo re men taxal nzhab Diox lo David leettsa mban David, bluz nguth David ne mkaats zha David, ta mkaats zha re tey David ne lee kwerp David ngwatsaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Per lee kwerp Jesús mteroban Diox ne mluxte. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","’Kona reta goo wetsʼn, ndoblo ne goo lee Jesús tak tuyy reta falt goo, taxal ndaa nee kwent lo re goo, ");
INSERT INTO zaoNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","tsa reta zha kuu yelaaz Jesús tuyy Jesús re falt zha. Re kuu ngogt ley chaan Moisés gatuyy. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kona kenap goo goo, tsa diinnt goo re kuu mkee re profet: ");
INSERT INTO zaoNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Wii goo, re goo kuu nzhizno re kuu wli, wlipaa tetsegey leettsoo goo naa xa luuxʼn goo, tak lee re wiz kuu naban goo tsowʼn thib kuu kwathoz naro, thib kuu yelaazt goo tegal taa zha kwente lo goo. Hab. 1:5 ");
INSERT INTO zaoNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Or mroo re altaa Paba ta nkaltaa re zha Israel nteed xkiiz Diox, tsa lee re zha kuu nagt zha Israel nzhab lo Paba, tsa yaad Paba tedib wiz sabd, tsa looka Paba re diza lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Or ngwalo mraats re men ta nkaltaa re zha nteed zha xkiiz Diox, tsa kwaro zha Israel, ne re zha kuu ngok zha Israel, re zha kuu thib mloo yek tsow kuu nlaaz Diox, mndeke zha dits Paba rop Bernabé. Lee rop zha mteni re zhaʼa, tsa nali to re zha lo yalwen chaan Diox, tak nke leettsoo re zha Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ne lee tedib sman wiz sabd, mer dita zha yez mkaltaa mbin xkiiz Zha Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Per lee re zha Israel ngok celos zha. Or mwii zha kwaro men mkaltaa tya, tsa mndelo zha mlooz zha Paba, ne mbez zha wlit kuu mbez Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Tsa lee Paba rop Bernabé ngoo ney leettsoo mkab lo re zha, ne mzebt Paba nzhab Paba: ―Ndoblo nee, taa nee kwent xkiiz Diox ner lo re goo zha Israel, per lee re goo nlaazt goo kayaa gooy, ne leeka goo ndak goo ndoblot goo kayaa goo yalnaban kuu thitanax, ta mod lee nee nda taa kwente lo re zha kuu nagt zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tak tabaa mnabee Diox lo nee, taxal nke lo xkeets Diox ta nzhab: Mton lu tsa gaka taxal xni lo re zha kuu nagt zha Israel, tsa yataaʼa kwent naa xomod laa re zha lo re falt zha, asta lo re zha kuu nzo ta mas tith lo yezlyu. Is. 49:6 ");
INSERT INTO zaoNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Or lee re zha kuu nagt zha Israel mbin koree, kwathoz naley ngoo leettsoo zha, ne mndaa zha texkix lo Diox por xkiiz Diox kuu mbin zha, ne reta zha kuu naka diiz kayaa yalnaban kuu thitanax ngwalaaz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ne lee xkiiz Zha Nabee mraats dita yezlyuʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Per lee re zha Israel mtekiil chop tson ngot kuu nataak ne chop tson mbyi kuu nataak yeza, tsa reke re zha dits Paba rop Bernabé, tsa koo zha rop zha yezlyuʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tsa lee rop zha ree mtsib yuyaaz kuu mke nii zha, tak kona nak thib seny kuu nloo lee re zhaʼa ntsowt kuu nlaaz Diox, ora ndya rop zha yez Iconio. ");
INSERT INTO zaoNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Per lee re zha kuu ngwalaaz Jesús tya, kwaro naley ngoo leettsoo re zha ne kwaro mnabee Mbi Nayon leettsoo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Leettsa mzin Paba rop Bernabé yez Iconio, tsa mndaab rop zha ta nkaltaa re zha Israel nteed xkiiz Diox, mndaa zha kwent Diiz Chul chaan Jesús ne kwaro zha Israel ne zha kuu nagt zha Israel ngwalaaz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Per lee re zha Israel kuu ngwalaazt Jesús, mndelo zha mtekiil zha re zha kuu nagt zha Israel, tsa tsow re zha ree xgab went nak re zha kuu nyelaaz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ne tegal tatay lee Paba rop Bernabé myaan tya tyen wiz, ne mzebt zha mndaa zha kwent Diiz Chul chaan Jesús, ne ngwalaaz zha lee Zha Nabee tsow ayud zha. Kona lee Zha Nabee mndaa diiz mtsow zha re kuu thoz, re kuu mloo wli nak re kuu mloo zha, ne kuu mndaa zha kwent chaan yalnkelaaz chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Per lee re zha yeza ngok chop net zha, thib net zha ngoo fabor re zha Israel lee tedib net zha ngoo fabor rop apóstl. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Per lee re zha Israel kon re zha kuu nagt zha Israel myaan zha diiz kon re zha kuu nak tsiin, tsa tsalzhoo zha rop apóstl ne kee zha ke yek rop apóstl. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Per or mbin Paba rop Bernabé kona, tsa mzhonn rop zha ndya zha yez Listra ne yez Derbe rop yez kuu nzi yezlyu Licaonia, ne noga ngwa zha reta yez kuu nzi tya, ");
INSERT INTO zaoNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ngwa zha ngwataa zha kwent Diiz Chul chaan Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Yez Listra ngoo thib mbyi kuu gagt te, neeka thib welt mndet zha, tak tataʼa mthans zha ngol zha. Lee mbyi ree ndob, ");
INSERT INTO zaoNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ngeyon re kuu ngeni Paba. Ne lee Paba mwii lo zha, tsa myeen Paba thib mloo zha leettsoo zha lee Diox tegwe zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Tsa nex nzhab Paba lo zha: ―¡Gwateli! Ne lee mbyiʼa ngwateli, mkee zha brink ne mndelo zha mnde zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Or lee reta men mne kuu mtsow Paba, tsa mndelo re zha mndediz zha mer xkiiz zha ne nzhab zha: ―¡Re diox kuu na taxal men ndyaad loʼaa! ");
INSERT INTO zaoNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Tsa nzhab re zha lee Bernabé nak diox Zeus, lee Paba nak diox Hermes, tak Paba nak zha kuu ni lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ne roo yeza ndob gwodoo chaan Zeus, tsa lee ngwleyy gwodooʼa kon re men mbe yee ne chop tson ngon par kuth zha lo rop apóstl, taxal ntsow zhay lo re diox zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Per or mne Paba rop Bernabé kona, mchat zha xab zha ne lijer mndaab zha xid re mena, ne mrez zha ne nzhab zha: ");
INSERT INTO zaoNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―¡Kenza goo! ¿Chebee ntsow goo koree? Taben goo nak nee, lee nee ndyaadtaa kwent lo goo, tsa laa goo re kuu nataagt kuu ntsow goo. Tsa yelaaz goo Diox kuu naban, Diox kuu mdexkwaa lobee, yezlyu, nitdoo ne reta kuu nzo leen re kona. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Re wiz ndala mlaa Diox mban re men taxal nlaaz re men, ");
INSERT INTO zaoNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ne tegal tatay mlaat Diox re men, thibka mloo Diox lo re men naa cho nak Diox, por re kuu wen kuu ntsow Diox, tak lee Diox ntela yi tsa nzhak yalgonn goo, ne tabaa ndaa Diox reta kuu ndecheʼaa, tsa naley nzo leettsooʼaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Per tegal tata nzhab Paba rop Bernabé, penta mtsow zha gan tsa mbeth re mena ngon gataa lo rop zha, taxal ndaa zhay lo re diox zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tsa mzin chop tson zha Israel kuu nzo Antioquía ne Iconio, re zha ree mtekiil re zha yez Listra, tsa mkee zha ke yek Paba, ne mnda leettsoo re zha mbetha zha Paba, tsa mdobyu zha Paba ne mloo zha Paba roo yez. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Per or lee re zha kuu nyelaaz Diox mkaltaa dita welt lo Paba, ora ngwache Paba ne mre Paba mndaab yez tedib welt. Ne tedib wiza mroo rop zha Bernabé ndya zha yez Derbe. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Bluz or ngwalo mndaa zha kwent Diiz Chul chaan Jesús yeza, ne mtsow zha gan kwathoz men ngwalaaz Jesús, tsaraa mretab zha yez Listra, Iconio ne Antioquía. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Lee Paba rop Bernabé mloney leettsoo re zha kuu nyelaaz Jesús kuu nzo re yeza, tsa ney to re zha ne gagt chop xgab zha lo xkiiz Diox, ne nzhab zha lo re zha: “Os leeʼaa nlaazaa tabaa ta nabee Diox, ndoblo ridaa kwaro yalti”. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Noga kadta re gwodooʼa mli zha zha gol xid re zha kuu nyelaaz Jesús, tsa nabee zha lo re zha kuu nyelaaz Jesús re yeza. Tsa mtsow re zha ayun ne mnaab zha lo Diox tsa kenap Diox re zha gola. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Leettsa mriid Paba rop Bernabé yezlyu Pisidia, mzin zha yezlyu Panfilia. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Tsa mndaa zha kwent chaan Jesús yez Perge, tsaraa ngwa zha yez Atalia, ");
INSERT INTO zaoNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","tya ngoo zha bark ndya zha Antioquía. Ta nak ta mndaa re zha kuu nyelaaz Jesús rop zha lazya Diox, tsa tsow Diox ayud zha taa zha kwent chaan Jesús, ne kona nak kuu ngwalo mtsow zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Or mzin zha Antioquía, mkaltaa zha re zha kuu nyelaaz Jesús tya, ne mndaa zha kwent re kuu mtsow Diox kon rop zha. Ne nzhab zha naa xomod mtsow Diox, tsa noga re zha kuu nagt zha Israel ngwalaaz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ne myaan rop zha tya plo tyemp lo re zha kuu nyelaaz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Re wiza, thiban zha kuu mroo yezlyu Judea mzin yez Antioquía, lee re zha ree mndelo mloo lo re zha kuu nyelaaz Jesús, ne nzhab zha: ―Yent mod laa goo lo re falt goo, os lee goo ket goo seny chaan re zha Israel, taxal nzhab lo ley chaan Moisés. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Tsa lee Paba rop Bernabé mbyodiz kon re zhaʼa, ne bluz lee re zha kuu nyelaaz Jesús mli Paba rop Bernabé, ne techop tson zha tsa ya re zha yez Jerusalén, tsa tediz zha kwent ree kon re apóstl ne kon re zha gol zha gwodoo naro. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ne lee re zha kuu nyelaaz Jesús kuu nzo yez Antioquía, ngwatenet zha Paba rop Bernabé, ne leettsa nderid zha yezlyu Fenicia ne yezlyu Samaria, mndaa zha kwent naa xomod lee re zha kuu nagt zha Israel, mlaaʼa zha re creens zha ne ngwalaaz zha Diox. Ne kwathoz naley ngoo leettsoo re zha kuu nyelaaz Jesús mbin zha koree. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Leettsa mzin Paba rop Bernabé Jerusalén, tsa lee re zha kuu nyelaaz Jesús, re apóstl ne re zha gol mkayaa zha zha. Tsa mndaa rop zha kwent reta kuu mtsow Diox kon lee zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Per chop tson re fariseo kuu ngwalaaza Jesús ngwateli ne nzhab: ―Ndoblo gabaa lo re zha kuu nagt zha Israel, ndoblo ke zha seny chaan reʼaa zha Israel, ne noga gabaa lo zha ndoblo gon zha diiz kuu nabee lo ley chaan Moisés. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tsa mkaltaa re zha kon re apóstl ne kon re zha gol, tsa tediz re zha kwent ree. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Bluz or kwathoza mndediz zha, tsa lee Pey ngwateli ne nzhab: ―Wets wen ne goo, nda wiza, Diox mlin tsa tan kwent Diiz Chul chaan Jesús lo re zha kuu nagt zha Israel, tsa noga re zha yelaaz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ne Diox kuu nlebee leettsoo reta men, mloo Diox lee Diox mkayaa zha, ne mndaa Diox Mbi Nayon lo re zha, taxalka mndaa Diozhe loʼaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ne leeka taxal mtsow Diox kuu wen lo reʼaa, tataka mtsow Diox lo re zhaʼa, tak leeka taxal mtembi Diox leettsooʼaa, tataka mtembi Diox leettsoo re zhaʼa, tak ngwalaaz zha Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ne lee nal; ¿chebee thib lad nlaa goo kuu mtsow Diox, ne nlaaz goo tsow re zha kuu nyelaaz Jesús kuu mbez lo ley, thib kuu neeka reʼaa ne neeka re teyaa ngogt gatsow? ");
INSERT INTO zaoNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ne neʼa lee mlaaʼa lee lo re faltaa, por yalwen chaan Jesucrist Zha Nabee, tataga mlaaʼa re zhaʼa tak nyelaaz re zha Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tsa mtow roo re zha ne mkenza zha, or lee Paba rop Bernabé mndaa kwent re milagr kuu mtsow rop zha por yalney chaan Diox lo re zha kuu nagt zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Or ngwalo mni rop zha, tsa noga Santiag nzhab: ―Wets, re goo kuu nyelaaz Jesús kenza goo kuu nin: ");
INSERT INTO zaoNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simún Pey mndaaʼa kwent lo reʼaa ner, naa xomod mndelo Diox mli Diox re zha kuu nagt zha Israel, tsa gak zha zha Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Reta koree ngok taxal nzhab re profet kuu ngoo ndala lo xkeets Diox ta mbez: ");
INSERT INTO zaoNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Bluz or ngwaloʼa ngok re koree, tsa bren texkwaan liz David kuu mlux. Bren tan kuu myaan ne xit nay tedib welt, ");
INSERT INTO zaoNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","tsa lee tedib net re men kwaan Zha Nabee, ne no re zha kuu nagt zha Israel kuu nlebeeʼa na. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Tata ne Zha Nabee, Diox kuu mtsow mne re zha ndala koree. Amós 9:11-12 ");
INSERT INTO zaoNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Kona lee na ni: Ndoblot tsowaa fwers re zha kuu nagt zha Israel gon zha diiz kuu mbez lo ley, re zha kuu mlaaʼa re costumr ne ngwalaaz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Mas wen taalaa thib yeets lo re zha, tsa wut zha re kuu ntsib re men lo re diox kuu nagt Diox, gagt rop zha kon ndota zha, wut zha beel re maa kuu nxot ren ne neeka ren ndoblot wu zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tata keeʼaa lo re zha, tak reta yez nzo re zha kuu ndaa kwent ley desde ndala, ne nlab zha ley ta nkaltaa re tawlazaa zha Israel nteed xkiiz Diox, wiz kuu ndroxkwanaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tsa lee re apóstl ne re zha gol, kon reta zha kuu nyelaaz Jesús, myaan re zha diiz kwii zha chop tson zha kuu taal zha ya yez Antioquía kon Paba rop Bernabé. Tsa mli zha Judas kuu noga lee Barsabás ne Silas, rop zha ree nak zha kuu nataak xid re zha kuu nyelaaz Jesús, ");
INSERT INTO zaoNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ne lo re zha ree mtaal zha yeets kuu tenzhee nzhab: “Re nee kuu nak apóstl ne re nee kuu nak zha gol kon reta zha kuu nyelaaz Jesús. Tsan reta goo wets ne btan, kuu nagt zha Israel kuu nyelaaz Jesús kuu nzo yez Antioquía, ne reta goo kuu nzo yezlyu Siria ne Cilicia. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Mbin nee lee chop tson tawlaz nee ngwa lo re goo ne ntegan zha goo, tsa nzhak chop xgab goo, ne ne zha lo goo ndoblo goo ke goo seny chaan nee zha Israel, ne gon goo diiz kuu mbez lo ley, per leet nee mtaal zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kona mtsow nee xgab kwenta ne myaan re nee diiz mli nee chop tson zha, par taal nee lo re goo kon Bernabé ne Paba rop zha kuu kwathoz nke leettsoo nee. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Rop zha ree mndaa zha yalnaban chaan par rid zha yalti kwent Diiz Chul chaan Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ne kon rop zha mtaal nee Judas ne Silas, rop zha ree ne lo goo kuu myaan nee diiz nzhee. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Tak lee Mbi Nayon ne lo nee, ndoblot raa ne nee lo goo gon goo diiz kwan raa, beeta re koree ndoblo tsow goo: ");
INSERT INTO zaoNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Wut goo re beel kuu ndaa re men lo re diox kuu nagt Diox, neeka wut goo ren neeka re beel maa kuu nxot ren, ne ndoblot gak rop goo kon ndota zha. Os lee re goo ntsow goo re koree, wen ngetsow goo.” ");
INSERT INTO zaoNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ne tata lee re zha kuu mtaal zha nda yez Antioquía, mkaltaa zha re zha kuu nyelaaz Jesús, ne mndaa zha yeetsa lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Or mlab re zha yeetsa, kwathoz naley ngoo leettsoo re zha, tak kwaro mtetsey re diza leettsoo zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ne kom noga Judas rop Silas nak profet, kwaro mtetsey zha ne mloney rop zha ree leettsoo re zha kuu nyelaaz Jesús tya. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Leettsa ndaʼa tyen wiz ndo Judas rop Silas tya, tsaraa lee re zha kuu nyelaaz Jesús mtaal zha rop zha, ne nzhab zha lo rop zha “Wen ndya goo”, tsa bre rop zha Jerusalén lo re zha kuu mtaal zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Per lee Silas mtsow xgab mas wen yaanka zha tya. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paba rop Bernabé myaan yez Antioquía, ne lo tyen zha yeza mloo rop zha ne mndaa zha kwent Diiz Chul chaan Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Telut bluz lee Paba nzhab lo Bernabé: ―Ndatwiiʼaa lo re zha kuu nyelaaz Jesús, reta yez ta mndaaʼa lee kwent xkiiz Diox, tsa naa xa nzi re zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabé ngwalaaz gateno Juan kuu noga le Mark, ");
INSERT INTO zaoNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","per lee Paba mzhyalt gateno Juan, tak mlaa Juan Paba rop Bernabé yezlyu Panfilia ne mndeket raa Juan dits rop zha gataa zha kwent xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Koree mtsow mbyodiz rop zha, ne asta mtso rop zha; tsa lee Bernabé mndeno Juan Mark, ngoo leen bark nda par Chipre yezlyu kuu nzi leen nit. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Lee Paba mli Silas, tsa lee re zha kuu nyelaaz Jesús mlaa zha Paba lazya Diox, tsa tsow Diox ayud rop zha, ne mroo rop zha yez Antioquía. ");
INSERT INTO zaoNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ne ngwa zha Siria ne Cilicia ne nzhab zha lo re zha kuu nyelaaz Jesús tya, tsa ney to re zha lo kuu ngwalaaz zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paba rop Silas mzin yez Derbe ne yez Listra, tya mlebee zha thib zha kuu nyelaaz Jesús kuu le Tim, xgann thib ngot Israel kuu nyelaaz Jesús, per lee xut zha nak zha gryeg. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lee re zha kuu nyelaaz Jesús yez Listra ne re zha yez Iconio wen ndediz zha Tim. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Tsa lee Paba nzhab teno Tim, per ner mkee Paba seny re zha Israel Tim, por re zha Israel, tak reta zha ne lee xut Tim nak zha gryeg. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Reta yez ta mriid zha nzhab zha lo re zha kuu nyelaaz Jesús, tsa tsow re zha re kuu nzhab re apóstl kon re zha gol zha Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Tsa lee re zha kuu nyelaaz Jesús masraa ney mndo zha lo kuu nyelaaz zha, ne wiz kon wiz ndiy ngok mas ploraa zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Tsa lee re altaa Paba mriidabta yezlyu Frigia ne yezlyu Galacia, tak lee Mbi Nayon mzhyalt gataa zha kwent xkiiz Diox Asia, ");
INSERT INTO zaoNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ne mzin zha yezlyu Misia. Tsa mtsow zha xgab ya zha yezlyu Bitinia, per mzhyaltga Mbi Nayon gaga zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ne leettsa mriidabta zha Misia, tsa mzin zha yez Troas, tya mla zha leen bark. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ne yaala taxal lo mkaal ngwani thib zha yezlyu Macedonia lo Paba, thib zha kuu ndeli nzhab lo Paba: “Bzhyal de Macedonia tsa tsowa ayud nee”. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Or mzhaak Paba kona, oraaka lee re nee mdexkwaa, tsa ndya nee yezlyu Macedonia, tak myeen nee lee Diox ngebez nee, tsa taa nee kwent Diiz Chul tya. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ngoo nee leen bark yez Troas ne ngwa nee nali par Samotracia yezlyu kuu nzi leen nit, ne lee tedib wiz mzin nee yez Neápolis. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ne tya mroo nee ngwa nee yez Filipos, kuu nak yez kuu mas nataak, kuu nzi ta ndelo yezlyu Macedonia ne Roma nabee yeza. Tya mlet nee chop tsonta wiz. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Thib wiz kuu ndroxkwan re zha Israel, mroo nee yez ne ngwa nee thib roo yoo, ta neʼa nee nkaltaa re zha Israel naab lo Diox, ne mndob nee mndaa nee kwent xkiiz Diox lo re ngot kuu mkaltaa tya. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ne xid re ngota ngoo thib ngot kuu le Lidia zha yez Tiatira, thib ngot kuu ntho lar morad kuu kwathoz wen, thibka nzhool ngot lo Diox, ne ngeyon ngot kuu mbez Paba per Diox mtsow mzhaal leettsoo ngot, tsa kenza ngot kuu ngeni Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Tsa ngokleyy re lizta ngot, ne mne ngot lo nee: ―Os lee goo wli nyelaaz goo lee na nyelaaz Jesús, de goo tsa kwet goo lizʼn. Ne mtsow ngot fwers lo nee par myaan nee liz ngot. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Thib wiz Leettsa nda nee ta nkaltaa re zha Israel nteed xkiiz Diox, tsa mzal nee thib nzaa kuu nzo mbi fyer leettsoo, ne kon yalnabee chaan mbi fyer ntsow nzaa divin, ne kwathoz ntsow re patron nzaa gan temi por yaldivina. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Lee nzaa ree mndeke dits re nee Paba ne mbetsyath nzaa mbez nzaa: ―¡Lee re mbyi ree nak zha kuu nke tsiin lo Diox kuu ndob yibaa, ne ndaa zha kwent lo re goo naa xomod laa goo lo re falt goo! ");
INSERT INTO zaoNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Tyen wiz tata mtsow nzaa, asta leettsa mkezhyan Paba, tsa lee Paba mre ne nzhab lo mbi fyera: ―Kon yalnabee chaan Jesucrist nabeen loʼa, broo leettsoo nzaa ree. Ne oraaka lee mbi fyer mroo leettsoo nzaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Per leettsa myeen re patron nzaa, gagt raa tsow re zha gan temi kon nzaaʼa, tsa mzhen zha Paba rop Silas ne mndeno zha rop zha yuulow lo re zha nak tsiin. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Leettsa ngwalo mndaa zha rop zha lo zha kuu nak tsiin, tsa nzhab re zha: ―Re zha Israel ree ngetsee xgab re tawlazaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ne nloo zha tedib net re leyy kuu ndoblot kayaaʼaa ne neeka ndoblot tsowaa, tak zha Roma nakaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Tsa lee re men mnayii mne Paba rop Silas, oraaka lee re zha kuu nak tsiin mnabee, koche zha xab rop zha, tsa kin zha rop zha kon bar. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bluz or ngwalo kwathoza mdin zha rop zha, tsaraa mloo zha zha tsib, ne mnabee zha lo re zha kuu nkenap roo tsib, tsa wen wen kenap zha rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Or tata mbin zha kuu nkenap roo tsib, tsa mloo zha Paba rop Silas ta mas naats leen tsib, ne key mloo zha nii rop zha leen thib le ya nachaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Per ngulal yaal lee Paba rop Silas mnaab ne mbil lo Diox, ne mbin re zha kuu nzo tsib kuu nzhool rop zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tsa lee thib zho thoz mndelo mwin kuu thitanax mtsib asta simyent tsib. Ne leeka ora mzhaal reta pwert chaan tsib ne noga mzhak reta kaden kuu naliib re zha kuu nzo tsib. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Leettsa mroo mkaal lo zha kuu nkenap roo tsib, mwii zha lee re pwert tsib ndezhaal, oraaka mloo zha espad zha, tsa kuth zha leeka lee zha, tak mtsow zha xgab lee re zha kuu nzo tsib mzhonna. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Per lee Paba mrez ne nzhab lo zha: ―¡Kuthta lu, reta nee nzika nzhee! ");
INSERT INTO zaoNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tsa lee zha kuu nkenap roo tsib mnaab xni, ne mzhonn zha mndaab zha leen tsib, ne lo tseba mtobxub zha lo Paba rop Silas. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tsa mloo zha rop zha tya ne mnaabdiz zha lo rop zha: ―Ne goo lon, ¿naa kwan ndoblo tsowʼn, tsa tsow Diox laan gabil ne tsowʼn gan yalnaban kuu thitanax? ");
INSERT INTO zaoNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Lee rop zha mkab, ne nzhab: ―Gwalaaz Jesús Zha Nabee, tsa tuyy Diox re falta ne falt re zha kuu nzo liza. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ne mndaa zha kwent xkiiz Diox lo zha ne lo reta zha kuu nzo liz zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Leeka yaala lee zha kuu nkenap roo tsib, mteech re grid Paba rop Silas kuu mdin zha zha, tsaraa ngokleyy re lizta zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ne mndeno zha rop zha ree liz zha ne mndaa zha kuu ndow zha, ne naley ngoo leettsoo re lizta zha, tak ngwalaaz re zha Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Or ngwani yezlyu lee re zha kuu nak tsiin, mtaal chop tson soldad ngwayab lo zha kuu nkenap roo tsib, tsa telaa zha Paba rop Silas. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tsa lee zha kuu nkenap roo tsib nzhab lo Paba: ―Lee re zha nak tsiin mnabee telaan goo; taka roo goo ne yat leettsoo goo ne wen tyaa goo. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Per lee Paba nzhab lo re soldada: ―¡Nee nak zha Roma! Ne ndewii re men yez mdin zha nee, ne neeka mnaabt zha kwent lo nee naa chu nap nee falt o napt neey, ne mloo zha nee tsib. Ne lee nal, ¿chebee nlaaz zha telaa zha nee xlaanta? ¡Rebeete! Ndoblo lee zha yaad koo nee. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Tsa lee re soldad ngwayab re koree lo re zha kuu nak tsiin, ne or mbin re zha lee rop zha nak zha Roma, kwathoz mzeb re zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Tsa lee re zha kuu nak tsiin ngwanaab Perdon lo Paba rop Silas, ne mloo zha rop zha ne nzhab zha lo rop zha, tsa roo zha yeza. ");
INSERT INTO zaoNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Or mroo rop zha tsib ngwa zha liz Lidia, ne mloney zha leettsoo re zha kuu nyelaaz Jesús, tsaraa mroo zha yeza. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Tsa nda Paba rop Silas ne mriid zha yez Anfípolis ne yez Apolonia, tsaraa mzin zha yez Tesalónica, ta nap re zha Israel thib ta nkaltaa zha nteed zha xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Lee costumr Paba nak, nya Paba ta nkaltaa re zha nteed zha xkiiz Diox, ne tson wiz kuu ndroxkwan re zha Israel, ngwa Paba mndaa kwent xkiiz Diox lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ne or mndaa Paba kwent mloo Paba lo re men kon xkiiz Diox ta mbez: Lee Crist Kuu Mtaal Diox Nabee mbriid yalti, ne leettsa nguth zha, mroban zha xid re zha nguth. Tsa nzhab Paba lo re zha: ―Leeka Jesús kuu ngetan kwent lo re goo nak Crist Kuu Mtaal Diox Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Tsa lee chop tson re zha Israel kuu ngwalaaz Jesús, thibka ngok zha kon Paba rop Silas, noga tyen zha gryeg kuu ntsow kuu nzhab lo ley ngwalaaz Jesús, ne noga tyen ngot kuu nataak yeza ngwalaaz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Per lee re zha Israel kuu ngwalaazt Jesús, kwathoz mkezhyan zha, ne mkaltaa zha chop tson re zha kuu went nak kuu ndiy lo xbi, tsa tsow re zha ree yii re zha yez ne Paba rop Silas. Ne mndaab zha liz Jasón mkwaan zha Paba rop Silas, tsa koo zha rop zha ne loo zha rop zha lo re zha yez; ");
INSERT INTO zaoNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","per leettsa mne re zha yent rop zha tya, tsa mdobyu zha Jasón kon techop tson zha kuu nyelaaz Jesús, mndeno zha re zha ree lo re zha kuu nak tsiin yez, ne dib gan mrez re zha ne nzhab zha: ―¡Lee re zha ree ngetetsaa reta men lo yezlyu, ne lee nal mzina zha nzhee, ");
INSERT INTO zaoNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ne Jasón mndaa yuu mlet rop zha! ¡Rop zha ne reta zha kuu nyelaaz xkiiz zha, nzhont zha diiz kuu nzhab ley chaan César, tak mbez re zha nzo tedib rey kuu le Jesús! ");
INSERT INTO zaoNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Or mbin re zha kuu nak tsiin ne re zha kuu nzi tya koree, neeka net zha naa kwan tsow zha xgab. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Tsa mnaab re zha temi lo Jasón ne lo re zha kuu nyelaaz Jesús, kuu mzhen re zha, ngwalo mdix re zha tsaraa mtelaa zha zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ne leeka yaala mtaal re zha kuu nyelaaz Jesús Paba rop Silas yez Berea. Leettsa mzin rop zha tya, ngwa zha ta nkaltaa re zha Israel nteed xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Per lee re zha Israel kuu nzo yeza, mas wen nak zha nake re zha kuu nzo yez Tesalónica, ne kon dib ndroo leettsoo zha mbin zha re kuu nzhab Paba, ne wiz kon wiz nlab re zha xkiiz Diox, tsa ne zha naa chu wli kuu mbez Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ta mod kwaro re zha ree ngwalaaz Jesús. Ne noga kwaro re zha gryeg ngwalaaz Jesús, mbyi ne ngot kuu nataak tya. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ne leettsa mne re zha Israel kuu nzo yez Tesalónica lee Paba ngetaaʼa kwent xkiiz Diox yez Berea. Tsa ngwa re zha tya mtekiil zha re zha yeza, tsa yii zha ne Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Per lee re zha kuu nyelaaz Jesús, oraaka mtaal zha Paba par roo nitdoo, lee Tim rop Silas myaanka yez Berea. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ne lee re zha kuu ngwatenet Paba ngwatan zha Paba asta yez Atenas. Ne mtaal Paba diiz lo re zha kuu ngwatan Paba, tsa leettsa bretab zha yez Berea, gab zha lo Tim rop Silas tsa lijer kaltaa rop zha kon Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Leettsa ngebet Paba lo Silas rop Tim yez Atenas, kwathoz nabil ngoo leettsoo Paba, or mwii Paba lee re zha yeza kwathoz nyelaaz zha re diox kuu nagt Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kona lee Paba ngwa ta nkaltaa re zha Israel nteed xkiiz Diox ne mndediz Paba kon re zha ne kon re zha kuu nagt zha Israel kuu nyelaaz Diox, ne reta wiz ndediz Paba lo re zha kuu nzaal Paba lo xbi yeza. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Noga mndediz Paba kon chop tson re zha kuu nloo leyy chaan thib mbyi kuu mrole Epicúrio ne kon tedib net zha kuu nloo leyy chaan thib mbyi kuu mrole Estoico, ne mndelo re zha mndediz zha kon Paba, ne chop tson re zha ree nzhab: ―¿Kwan nlaaz mbyi kuu kwathoz ndediz ree ne? Ne lee tedib net zha nzhab: ―Ndakʼn lee zha ndaa kwent xkiiz re diox kuu nlebeetaa. Koree mbez re zha, tak lee Paba mndaa kwent Diiz Chul chaan Jesús ne kwent chaan yalroban. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Tsa mndeno zha Paba thib ta le Areópago, ta nkaltaa re zha, ne mnaabdiz zha lo Paba: ―¿Chu tak ne nee naa xomod nak re diiz kub kuu ndyaad looʼa lo nee? ");
INSERT INTO zaoNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Tak pur re diiz kuu ter gon nee ndediza, ta mod nlaaz nee ne nee naa xomod nak re diiz ree. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Tak reta zha yez Atenas ne re zha tedib yez kuu nzo tya, anta nyow leettsoo zha kenza zha ne tediz zha pur kuu kub, ne thibka tata nzi re zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Tsa ngwateli Paba lo re zha ta le Areópago, ne nzhab Paba lo re zha: ―Men Atenas, kuu nloo lon nak, lee re goo nak zha kuu kwathoz nyelaaz re diox kuu nagt Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ne or mwiin re ta nzhool goo lo re diox goo, mzalʼn thib ta tenzhee mbez: “DIOX KUU NLEBEETAA”. Lo Diox ree nzhool goo ne neeka nlebeet goo Diox, xkiiz Diox ree nak kuu ngetan kwent lo goo nal. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Diox ree mdexkwaa yezlyu ne reta kuu nzo lo yezlyu, lee Diox nabee yibaa ne lo yezlyu. Ne nzot Diox leen yuu kuu ndexkwaa re men, ");
INSERT INTO zaoNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","neeka ndechet Diox men kuu tsow ayud Diox, tak lee Diox ndaa yalnaban, mbi ne reta kuu ndecheʼaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Ne por thibka mbyi mtsow Diox myazh kwaro men, tsa yo re zha dita lo yezlyu. Ne mlooʼa Diox naa plo tyemp xek re raz zha, ne asta plotha nak ta yo zha ne nabee zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Tsa kwaan zha Diox, tegal taxal zha kuu ndaab yaa nkwaan thib kwaa par tsal Diox lo zha, per kuu wli nak, ndot Diox tith loʼaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Tak lee Diox ntsow nabanaa ne ngwinaa, ne lee Diox ntsow, tsa nziʼaa lo yezlyu ree. Taxal nzhab chop tson re tawlaz goo kuu nak zha kuu kwathoz nzhaak, leettsa nzhab zha: “Reʼaa nak zha raz chaan Diox”. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kona os leeʼaa nakaa zha raz Diox, ndoblot tsowaa xgab lee Diox nak ndota kuu or, o plat, o ke, kuu ndexkwaa re zha taxal nlaaz zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Re tyemp ndala mkez leettsoo Diox mne Diox re men, leettsa mtsow re men taxal mgab yek re men, tak mkow yek zha, per nalsi dita lo yezlyu, nabee Diox lo re men, tsa laa re men re falt men ne teke men dits Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Tak mliʼa Diox thib wiz, kuu nali naab Diox kwent lo reta men, ne mli Diox Jesucrist tsow koree, ne mloo Diox mli Diox Jesucrist tak mteroban Diox Jesucrist. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Or mbin zha nzhab Paba lee Jesucrist mroban, tsa lee thib net zha mndelo mzhizno Paba, lee tedib net zha nzhab: ―Tedib welt yelo taaʼa kwent baa lo nee. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Tsa mroo Paba xid re zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Per noga chop tson re zha ngwalaaz Jesús, mzaal zha kon Paba. Xith re zhaʼa ngoo thib mbyi kuu le Nich, zha ree nak thib zha nataak ta nkaltaa re zha yeza ta le Areópago, ne thib ngot kuu le Dámaris kon tedib net zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Bluz leettsa ngwalo mriid re koree, tsa lee Paba mroo yez Atenas ndya yez Corinto. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Tya mzaal Paba thib tawlaz Paba, zha Israel, zha ree le Aquila, zha ree ngol yezlyu Ponto. Aquila ne Priscila tsaal Aquila penta ndyaad rop zha mroo zha yezlyu Italia ne mzin zha tya, tak lee rey Claudio mnabee roo reta zha Israel Roma. Tsa lee Paba ngwatwii lo rop tsaal zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ne leeka tsiin kuu ntsow Paba nak rtsin rop zha. Kona myaan Paba lo rop zha, tsa thibka mke re zha tsiin, lee re zha ngib yid kuu ndexkwaa yuu yid. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ne reta wiz kuu ndroxkwan zha, lee Paba nya ndaa kwent xkiiz Diox ta nkaltaa re zha Israel nteed xkiiz Diox, ne mkwaan Paba mod tsa yelaaz re zha Israel ne re zha kuu nagt zha Israel Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Leettsa lee Silas rop Tim mzin yez Corinto, rop zha ree mroo yezlyu Macedonia. Tsa lee kuu ntsow Paba nak anta ndaa Paba kwent xkiiz Diox, ne mbez Paba lo re zha Israel lee Jesús nak Crist Kuu Mtaal Diox Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Per lee re zha mndelo mnayii mne Paba, ne mlooz zha Paba. Tsa lee Paba mtsib xabe lo re zha, taxal thib seny lee re zha nzhont diiz, ne nzhab Paba lo re zha: ―Gooka nap falt os lux goo, napt nay. Desde nalor leen ndata kwent xkiiz Diox lo re zha kuu nagt zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Tsa mroo Paba ta nkaltaa re zha Israel nteed xkiiz Diox, ne ngwa Paba liz thib mbyi kuu le Justo, zha ree kwathoz nzhon diiz lo Diox. Ne gaxta ta nkaltaa re zha nteed xkiiz Diox ndob liz zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Tsa lee Crispo thib zha kuu nabee ta nkaltaa re zha nteed zha xkiiz Diox, re lizta zha ngwalaaz Jesús, noga kwaro re zha yez Corinto leettsa mbin zha xkiiz Diox ngwalaaz zha Jesús ne ngokleyy zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Thib yaal lee Diox mloo lo Paba taxal lo mkaal, ne nzhab Diox lo Paba: ―Tsebta, taaka kwent xkizʼn. Towta rooʼa, ");
INSERT INTO zaoNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","tak na ndo kon lu, ne neeka thib zha gagt tsow thib kuu went loʼa, tak kwaro zha kuu nzo yez ree gak zha da. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ne mlet Paba thib liin narol yez Corinto, mteteed Paba re men xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Per leettsa lee Galión nak zha kuu nabee yezlyu Acaya, tsa lee re zha Israel myaan zha diiz ne mzhen zha Paba ne mndeno zha Paba lo Galión, ");
INSERT INTO zaoNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ne nzhab re zha lo Galión: ―Zha ree ngetsow thib kuu went lo ley chaanaa: Tak mbez zha lo re men, ndoblo men gol men lo Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Leettsa lee Paba nda ni, tsa lee Galión nzhab lo re men: ―Kenza goo zha Israel, os lee goo nkeki goo mbyi ree por thib kuu went kuu mtsow zha, taxal mbeth zha thib men, tetsowʼn kas kuu ne goo. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Per koree nak kwent chaan ley chaan goo, btexnet gooy, nlaaztʼn taabʼn lo kwenta. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ne mloo Galión re zha yuulow. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Tsa lee re zhaʼa mzhen Sostenés zha kuu nabee ta nkaltaa re zha Israel nteed xkiiz Diox, ne mdinke zha Sostenés roo yuulow, ne neeka kas mtsowt Galión kona. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ne mlet Paba plo tyemp yez Corinto, tsaraa nzhab Paba lo re zha kuu nyelaaz Jesús lee Paba bi, ne ndya Paba kon Priscila ne Aquila par yezlyu Siria. Or bee ter ten Paba bark yez Cencrea, tsa mga Paba yitsek Paba, tak mtsowa Paba thib kuu nzhab Paba lo Diox tsow Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Or mzin re zha yez Éfeso, tya mlaa Paba Priscila ne Aquila, lee Paba ngwa ta nkaltaa re zha Israel nteed xkiiz Diox, ne mndediz Paba kon re zha kuu mkaltaa tya, ");
INSERT INTO zaoNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ne lee re zha ree mnaab lo Paba kwet Paba plo tyemp lo re zha, per mzhyalt Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Tsa nzhab Paba lo re zha: ―Leen ndya, tak ndoblo riidʼn ani kuu ndyaad ree Jerusalén. Per os lee Diox taa diiz tayadtwin lo re goo tedib welt. Ne telut bluz lee Paba ngoo bark mroo yez Éfeso. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ne or mzin Paba Cesarea, tsa ngwa Paba yez Jerusalén, ngwatwii Paba lo re zha kuu nyelaaz Jesús, tsaraa ndya Paba Antioquía. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Leettsa ndaʼa tyemp nzo Paba Antioquía, tsa mre Paba ngwa thibga re yez kuu nzi yezlyu Galacia ne yezlyu Frigia, tsa mloney Paba leettsoo re zha kuu nyelaaz Jesús kuu nzo par tya. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ne re wiza mzin thib zha Israel kuu le Apolos yez Éfeso, Apolos nak zha yez Alejandría. Ne kwathoz nzhaak Apolos ndediz, noga kwathoz nzhaak Apolos xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Kwathoz wen mteed Apolos xkiiz Diox, kon dib ndroo leettsoo Apolos mndaa Apolos kwent xkiiz Diox lo re men ne nambi mloo Apolos lo re zha, tegal beeta mod kuu mtsowleyy Juan nlebee Apolos. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ne mzebt Apolos mndelo Apolos mndaa kwent xkiiz Diox, ta nkaltaa re zha Israel nteed xkiiz Diox, per or mbin Priscila rop Aquila koree, tsa mndeno rop zha Apolos liz zha ne mteteed zha Apolos mas wen xkiiz Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Or lee Apolos mtsow xgab ya yez Acaya, tsa lee re zha kuu nyelaaz Jesús yez Éfeso, mloney leettsoo Apolos ne mkee re zha thib yeets mtaal zha lo re zha kuu nyelaaz Jesús tya, tsa wen kayaa zha Apolos or tsin Apolos tya. Ne or mzin Apolos Acaya kwaro mtsow Apolos ayud re zha kuu ngwalaaz Jesús por yalwen chaan Zha Nabee, ");
INSERT INTO zaoNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ne kon xkiiz Diox kwathoz nambi mloo Apolos, lee Jesús nak Crist Kuu Mtaal Diox Nabee, ne mloo Apolos wlit re kuu mloo re zha Israel. Ne neeka thib zha yent kwan nzhab lo Apolos. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Leettsa lee Apolos ndo yez Corinto, lee Paba mriid re yez kuu nzi net yii, tsa mzin Paba yez Éfeso, tya mzal Paba chop tson zha kuu nyelaaz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Tsa mnaabdiz Paba lo re zha ne nzhab Paba: ―¿Chu mkayaaʼa goo Mbi Nayon leettsa ngwalaaz goo Jesús? Lee re zha mkab, ne nzhab: ―Neeka net nee naa chu nzo Mbi Nayon. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Tsa mnaabdiz Paba lo re zha tedib welt: ―¿Xomod ngokleyy goo? Lee re zha mkab ne nzhab: ―Taxal mloo Juan, tata ngokleyy nee. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Tsa nzhab Paba lo re zha: ―Wli lee Juan mtsowleyy re men, kuu mlaa re kuu went kuu ntsow ne ngwalaaz Diox, ne nzhab Juan lo re men, yelaaz re men zha kuu yaadke dits Juan. Lee zha ree nak Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Or mbin re zha koree, tsa ngokleyy zha kon le Jesús Zha Nabee, ");
INSERT INTO zaoNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ne or mxoob Paba yaa Paba yek re zha, tsa mkayaa re zha Mbi Nayon ne mndelo re zha mndediz zha tedib net diiz, ne mndelo re zha mndaa zha kwent xkiiz Diox lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ne reta zha ree nzhak teeka tsiibchop mbyi. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ne dita tson mbee ngwa Paba ta nkaltaa re zha Israel nteed xkiiz Diox, ne mzebt Paba mndaa Paba kwent xkiiz Diox lo re men tya. Mndediz Paba kon re zha ne mtsow Paba tsa yelaaz re zha naa xomod nak yalnabee chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Per ngoo chop tson zha kuu ngok nad leettsoo ne ngwalaazt zha kuu mbez Paba, ne delant lo re men mndelo re zha ree mlooz zha Paba, kwent chaan Diiz Chul chaan Jesucrist. Tsa mbeche Paba kon re zha kuu nyelaaz Jesús lo re zhaʼa, ne mndeno Paba re zha leen thib yuu skwel chaan thib zha kuu le Tirano, tya mteteed Paba re zha gandata wiz. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ne tata mteteed Paba re zha chop liin, ne reta zha kuu nzo Asia, zha Israel ne zha kuu nagt zha Israel mbin Diiz Chul chaan Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ne kon yalney chaan Diox mtsow Paba re milagr thoz kuu mzegey leettsoo re men mwii, ");
INSERT INTO zaoNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ne asta noga panyit ne re lar kuu ndiinn cho Paba nzhe re men lo re mbyiz, tsa gwe re zha lo re yiz kuu ndak zha, ne noga ndroo re mbi fyer kuu nzo leettsoo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ne ngoo chop tson zha Israel, kuu ndiy ngoo re mbi fyer kuu nzo leettsoo re men, re zha ree nlaaz lortsin le Jesús, tsa koo zha re mbi fyer, ne mbez zha lo re mbi fyera: ―Kon le Jesús kuu ndaa Paba kwent nabeen loʼa broo. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Koree mtsow re gaz xgann thib zha Israel kuu le Esceva, kuu ngok thib re ngwleyy kuu mnabee lo re ngwleyy. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Per thib welt lee mbi fyer mkab lo re zha ne nzhab: ―Nlebeen Jesús, ne nen cho nak Paba, per lee re goo, ¿cho nak goo? ");
INSERT INTO zaoNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ne lee zha kuu nzo mbi fyer leettsoo, mndelo mkeey yek re zha, ne kon yalney kuu nap zha mtsow zha gan lo reta zha, ne kwathoz nakap mkee zhay yek re zha, kona cheey ne grid re zha mzhonn zha mroo zha leen yuuʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Reta zha kuu nzo yez Éfeso mbin koree, re zha Israel ne re zha kuu nagt zha Israel, kona kwathoz mzeb re zha, ne tata mod lee xkiiz Jesús kwathoz ngok nataak tya. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ne noga kwaro re zha kuu ngwalaaz Jesús, myaad zha ne mloo roo re zha re kuu went kuu mtsow zha ndala delant lo re men, ");
INSERT INTO zaoNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ne noga kwaro re zha kuu mtsow yalwez, myaadno zha re libr zha ne ndewii re men mteyy zhay. Or mtsow zha kwent naa plo nataak re libra. Leey nataak chop galbtsii mil pes plat. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Tata lee xkiiz Jesús masraa mraats re yeza ne naroob men ngwalaaz Jesús Zha Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Bluz leettsa ngwalo mriid re koree, mtsow Paba xgab ya Paba Macedonia ne Acaya, ne yaka Paba asta Jerusalén, ne noga nzhab Paba, or yelo ya Paba Jerusalén, tsa ya Paba asta Roma. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Tsa mtaal Paba Tim rop Erast par Macedonia rop zha ree ntsow ayud Paba, lee Paba myaanka Asia. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ne re wiza kwaro mnayii re zha yez Éfeso ne xkiiz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Demetrio zha kuu ndexkwaa re kuu plat mtsow koree, ndexkwaa zha re gwodoo bzhizh, kuu nak taxal gwodoo chaan diox Diana, ne lee Demetrio ne re zha kuu nke tsiin kon plat, kwaro temi ntsow re zha gan. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Tsa mkaltaa Demetrio re zha kuu nke leeka tsiina, ne nzhab Demetrio lo re zha: ―Companyer: Wen neʼaa lo tsiin ree ntsanaaʼaa naroob temi. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Per lee nal lee re goo ngwii ne nzhon, lee Paba ndiy mbez lo re men, lee re diox kuu ndexkwaa men nagt diox, ne tabaa ngetsow Paba gan kwathoz men, ne nagte beeta re zha Éfeso sinke mera dita yezlyu Asia. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Koree nak thib kuu thitanax went, tak cha lux rtsinaa, ne nagt beeta rtsinaa lux, sinke noga gwodoo chaan diox Diana nzo mod lux yalnataak kuu nkenoy. Ne tabaa lee re men yelaazt raay, taxal nyelaaz zhay asta nal, ne tsowt raa zha kas diox Diana, kuu nyelaaz re zha kuu nzo dita yezlyu Asia ne dita lo yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Or mbin re zha koree, kwathoz mnayii re zha, ne dib gan re zha mrez zha ne nzhab zha: ―¡Kwathoz naro nak Diana, diox reʼaa zha Éfeso! ");
INSERT INTO zaoNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Reta zha yeza, kwaro mkezhyan zha. Tsa mzhen re zha Gayo rop Aristarco zha yezlyu Macedonia, zha kuu mndiy kon Paba, ne mdobyu zha rop zhaʼa asta ta nyoo junt. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ne ngwalaaz Paba gataab tya, tsa ni Paba lo re men, per mzhyalt re zha kuu nyelaaz Jesús gaya Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Noga chop tson zha kuu nak tsiin Asia, kuu nak amig Paba, mtaal diiz lo Paba tsa tabt Paba tya. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ne thib net re zhaʼa mbez thib kuu lee tedib net zha mbez tedib kuu, nathoz nkee re zha bi, ne kwaro zha kuu mkaltaa tya neeka net zha naa chebee mkaltaa zha tya. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Tsa lee chop tson zha Israel mndaa kwent lo Alejandr re kuu ngeyak, ne mndeno zha Alejandr tsa ni Alejandr por re zha Israel, tsa mtsow Alejandr seny kon yaa Alejandr, tsa keet raa re men bi. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Per or myeen re men lee Alejandr nak zha Israel, tsa mndelo re men dib gan re men mrez re men teeka chop or ne nzhab re men: ―¡Kwathoz naro nak Diana, diox reʼaa zha Éfeso! ");
INSERT INTO zaoNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Or lee secretar yeza mtsow gan mkeet raa re men bi, tsa nzhab zha: ―Reta goo zha Éfeso, reta men yezlyu ne, lee reʼaa zha yez ree nkenap gwodoo diox Diana, imaj kuu ngob lobee. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Re goo ne wli koree, kona ndoblot kwez goo tabaa, os tsowt goo xgabe wen wen ner. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Tak lee re mbyi kuu ndyaadno goo nzhee, mtsowt zha kuu went lo gwodoo ne neeka mloozt zha diox reʼaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Os lee Demetrio kon re zha kuu nke tsiin kon Demetrio nkeno zha thib kwaa kon thib zha, baa ndob yuulow, ta nzi re zha kuu nak tsiin, tya ya zha yatexnet zha kwent chaan zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Per os kwan raa nlaaz goo, leettsa yo junt yez tsa texnete. ");
INSERT INTO zaoNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ne nal por re kuu mriid ree, cha tsow gobyern xgab leeʼaa ngetekiil re men tsow re kuu rax ree, ne os lee gobyern naabdiz loʼaa por re kuu ngok ree, ¿kwan kabaa lo re zha tsa? ");
INSERT INTO zaoNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Or ngwalo tata nzhab zha, tsa mchaats zha re men. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Or ngwalo ngok zhe re zha yez Éfeso, tsa lee Paba mrez re zha kuu nyelaaz Jesús, mteni Paba re zha, nzhab Paba lo re zha lee Paba bi, ne ndya Paba yezlyu Macedonia. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Leettsa ngwa Paba re yez kuu nzi tya, kwathoz mloney Paba leettsoo re zha kuu nyelaaz Jesús kon re kuu nzhab Paba, ne ndya Paba mzin yezlyu Grecia, ");
INSERT INTO zaoNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","tya mlet Paba tson mbee. Or mer thoz ten Paba bark bi Paba par Siria, mbin Paba lee re zha Israel nlaaz tsow thib kuu went lo Paba. Tsa mtsee Paba xgab Paba ne mretab Paba par Macedonia tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ne re zha ree mtsow company Paba; Sópater zhiinn Pirro zha Berea, Aristarco ne Segundo rop zha ree nak zha Tesalónica, Gayo zha Derbe ne Tim, Tíquico ne Trófimo zha yezlyu Asia. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Reta zha ree mndener ne mlet zha lo rop nee Paba yez Troas. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ne or ngwalo mriid ani kuu nzhow zha pan kuu nyoot lebadur, tsaraa mroo nee yez Filipos, ne gaay wiz ngoo nee bark mzin nee Troas, ta ngebet re zha lo nee, tya mlet nee gaz wiz. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ne or ngok wiz domin mkaltaa nee, tsa wu nee rtsee chaan Jesús Zha Nabee, ne lee Paba mtsowa xgab bi tedib wiz, kona asta ngulal yaal mndediz Paba ne mloo Paba lo re zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ne leen yuu ya ta mkaltaa nee ndobke thiban kandil, ");
INSERT INTO zaoNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","tsa lee thib nyo mndyeen kuu le Eutico ndob roo ventan. Ne tak kwathoz nol mndediz Paba lo re zha, ngwatin nyo mkaal ne desde yon pis ya ngob nyo lo yu, ne ngutha nyo mlit zha nyo. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Tsa mla Paba ta nax nyo ne mtobxub Paba mdeez Paba nyo, ne nzhab Paba lo re zha: ―Tsebt goo, naban nyo. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Tsa mre Paba mkendab tedib welt, ne mdid Paba pan mdow re zha, tsa mndaaka Paba kwent lo re zha, asta ngwani yezlyu; tsaraa mbi Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ne kwathoz mtsey leettsoo re zha, tak naban nyo kuu ngoba, ne mndeno re zha nyo liz zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Tsa mzhen nee bark ndya nee yez Asón, ta myaan nee diiz tsaal nee kon Paba, tak mtsowa Paba xgab ya ni Paba tya. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Or mzaal nee Paba yez Asón, tsa mzhen re nee Paba bark ndya nee yez Mitilene. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tedib wiz mroo nee yez Mitilene mriid nee yezlyu kuu le Quío kuu nzi leen nitdoo, ne tedib wiz tsaraa mzin nee ta le Samos, ne asta tedib wiz tsaraa mzin nee yez Mileto. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Tak lee Paba mtsowa xgab ridndabta yez Éfeso, tsa tsant raa Paba Asia; tak nyob leettsoo Paba tsin Paba yez Jerusalén, tak lee xgab Paba nak, os leey take, tsin Paba ne to Paba tya lo ani Pentecostés. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Or nziʼa nee yez Mileto, tsa mrez Paba re zha gol kuu nyelaaz Jesús yez Éfeso. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ne or mzin re zha, tsa nzhab Paba lo re zha: ―Desde wiz ner kuu leettsa mzin na nzhee Asia, ne asta naltseree, ne goo naa xa ngetsowʼn, ");
INSERT INTO zaoNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","dita tyemp kuu nda ndon lo re goo, ngetsow rtsin Jesús kon dib ndroo leettsoon, ne relota yalti ngeriidʼn lo re zha Israel, ne kwaro welt asta nzhonn na. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Per tegal tabaay, mlatʼn tan kwent re kuu nak kuu wen lo re goo, sinke mloon lo re goo delant lo re men ne liz goo. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Lo re zha Israel ne lo re zha kuu nagt zha Israel, nzhapa na lo zha bre zha lo Diox ne yelaaz zha Jesús Zha Nabee. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Nal leen ndya Jerusalén, ta ngetaal Mbi Nayon na ne netʼn naa kwan riidʼn tya. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Beeta kuu nen nak, reta ta nyan ne Mbi Nayon lon, ko zha na tsib ne ridʼn kwathoz yalti. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Per neeka thib lo re koree ndat leettsoon, kuu nataak nak tsowʼn kuu nabee Jesús lon, kuu nak tan kwent Diiz Chul chaan Jesús, ne lon xomod nak yalwen chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’Ne lee nal nen, bret raa goo wii goo na, re goo kuu mndan kwent lo naa xomod nabee Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ta mod nlazʼn nin lo reta goo nal, naptʼn kulp os lee goo went ndo goo lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Tak mndaʼa na kwent naa xomod nak xkiiz Diox lo re goo, ne mkaatsʼn neeka thib kwaa lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Kona kenap goo goo ne kenap goo re zha kuu nyelaaz Jesús, re zha kuu mndaa Mbi Nayon diiz kenap goo, taxal thib zha kuu nkenap re mbak zhiil, tak kon ren Jesús mzhii Jesús re zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Noga nen or leen bi, lee tedib net re zha kuu kwathoz nayii taxal mbeez nak yaad, kuu nlaaz luux re goo kuu nyelaaz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ne leeka xid re goo roo chop tson re zha kuu loo kuu wlit, ne tsow zha gan yelaaz re zha kuu nyelaaz Jesús xkiiz zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kona bkenap goo goo, btelaaz goo por tson liin tse ne yaal mlatʼn thibka mnin lo goo, ne asta mbinn na. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","’Kona re goo wetsʼn kuu nyelaaz Jesús, naabʼn lo Diox tsa kenap Diox goo. Thibka btelaaz goo Diiz Chul chaan yalnkelaaz chaan Diox, tak leey nap yalnabee tsow ayud re goo, tsa masraa ne goo naa xomod nlaaz Diox ban goo, tsa taa Diox re kuu mne Diox taa Diox lo re zha kuu nak zha Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mndablaztʼn temi ne neeka xab neeka thib zha, ");
INSERT INTO zaoNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","reta goo wen ne goo kon prop yaan mkeen tsiin, tsa mtsanaan kuu ndowʼn ne kuu ndow re zha kuu mndo kon na. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mloon lo re goo naa xomod ndoblo ke men tsiin, tsa tak tsow men ayud re zha kuu ndeche kwaa. Btelaaz goo xkiiz Jesús Zha Nabee or nzhab zha: “Mas wen nzo leettsoo zha kuu ndelaaz kwaa, nake zha kuu nkayaay”. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Or ngwalo nzhab Paba koree, tsa mtobxub Paba ne mnaab Paba lo Diox kon re zhaʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Reta zha mbinn ne mdeez zha Paba ne mdow zha chut kwat Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ne kwathoz nabil ngoo leettsoo re zha, tak lee Paba nzhab lo re zha: “Bret raa goo wii goo na”. Tsaraa ngwatenet re zha Paba, asta ta ten Paba bark. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Leettsa mlaa nee re wets zha yez Éfeso, tsa mzhen nee bark kuu ndya par Cos yezlyu kuu nzi leen nitdoo. Ne tedib wiz tsaraa mzin nee yezlyu Rodas kuu nzi leen nitdoo, ne tya mroo nee ndya nee yez Pátara. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ne tya mgaa nee thib bark kuu ndya par Fenicia, tsa mzhen nee barka. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ne leettsa ndya nee mwii nee lee yezlyu Chipre nzi lad beg. Ndyaka nee mzin nee Siria ne lee barka ndeche lath yez Tiro, tsa mla nee mndaab nee yeza. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Tsa mzaal nee re zha kuu nyelaaz Jesús, ne mlet nee gaz wiz lo re zha, tsa nzhab re zha lo Paba yat Paba Jerusalén, tak lee Mbi Nayon mloo thib kuu lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Per leettsa mzaal gaz wiza, tsa mroo nee yeza ne reta wets kon tsaal zha ne kon re zhiinn zha, myaadtaan zha nee asta roo nitdoo yeza. Ne tya roo nitdoo mtobxub re nee ne mnaab nee lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Tsa nzhab nee lo re zha, lee nee ndya ne mke nee bark lee re zha mretab zha liz zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Leettsa mroo nee yez Tiro mzin nee yez Tolemaida tyatha ngoo nee bark, ne or mzin nee tya mni re nee Paba “diox” lo re zha kuu nyelaaz Jesús, ne mlet nee lo re zha thibka wiz. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Lee tedib wiz mroo re nee Paba tya, tsa mzin nee yez Cesarea. Tsa ngwa nee liz Lip kuu ndaa kwent xkiiz Jesucrist, kuu nak thib re gaz zha kuu mli zha par tsow ayud re apóstl, ne mlet nee liz Lip. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Zha ree nap thap rtsaap kuu mndyeen, ne re nzaa ree nak profet chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ne leettsa ndaʼa wiz ndo nee tya, tsa mzin Agabo thib profet chaan Diox, zha ree ndyaad yezlyu Judea. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ne or mzin zha lo nee, tsa mzhen zha sinch Paba ne mliib zhay yaa zha ne ni zha, tsa mne zha: ―Lee Mbi Nayon ne, tenzhee liib zha bzhaan sinch ree yez Jerusalén, ne taa zha zha lo re zha kuu nagt zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Or mbin re nee kon re zha kuu nyelaaz Jesús kuu nzo yeza kona, tsa nzhab nee lo Paba yat Paba Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Per lee Paba mkab: ―¿Chebee nzhonn goo ne ntsow goo nabil nyoo leettsoon? Per na yent kwan nda leettsoon, tegal liib zha na o kuth zha na yez Jerusalén, kwent chaan Jesús Zha Nabee lo reʼaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Per or mne nee mtsowt nee gan gatekweet nee Paba, tsa mlaa nee ndya zha, ne nzhab nee lo zha: ―¡Gake taxal nlaaz Zha Nabee! ");
INSERT INTO zaoNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Or ngwalo mriid wiza mdexkwaa nee tsa ndya nee Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ne noga chop tson re wets zha Cesarea mtsow company nee, ne xid re zha nzo thib zha Chipre kuu le Mnasón, zha kuu ndala nyelaaz Jesús ne liz zha mlet nee. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Leettsa mzin nee Jerusalén, kwathoz laz re zha kuu nyelaaz Jesús mkayaa zha nee. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Lee tedib wiz ngwatwii re nee Paba lo Santiag ne tya nzi re zha gol kuu nabee lo re zha kuu nyelaaz Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Or ngwalo mni nee “diox” lo re zha, tsa mndelo Paba mndaa kwent thibga thibga re kuu mtsow Diox por Paba lo re zha kuu nagt zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Or mbin re zha kona, tsa mndelo re zha mbil zha lo Diox. Tsa nzhab re zha lo Paba: ―Wets Paba, wii xid re zha Israel kwaro zha ngwalaaza Jesús ne reta zha mbez ndobloka gon re men diiz lo ley chaan Moisés. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ne mbin re zha leeʼa ngeloo lo re zha Israel kuu nzot Israel, tsa gont raa zha diiz lo ley chaan Moisés, noga mbin zha nzhaba ndechet raa kee zha seny re xgann zha, ne tsowt raa zha re kuu mloo re teyaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Lee nal, ¿kwan tsowaa nal? Tak reta zha Israel ne leeʼa ndyaad. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Mas wen btsow koree: Xith re nee nzhee nzo thap mbyi kuu tsow thib kuu nzhab zha lo Diox tsow zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Gwa re goo zha ne btsow goo taxal nzhab lo ley, tsa gak nambi goo, ne bdix re gast zha, tsa tak ga re zha yitsek zha. Ne tabaa lee reta men ne, wlit kuu mbin zha kwent chaana, sinke nzhona diiz taxal nabee ley chaan Moisés. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Per lee re zha kuu nagt zha Israel kuu ngwalaaza Jesús, mtaala nee yeets lo re zha taxal mtsow nee xgab: Ndechet tsow zha reta kuu nzhab lo ley chaan Moisés. Per ndoblot wu zha re kuu ntsib re men lo diox re men, neeka wut zha ren ne re beel re maa kuu nxot ren, neeka gagt rop zha zha kon ndota zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Tsa mndeno Paba re thap mbyiʼa, ne tedib wiza mtsow Paba taxal mbez lo ley kon re zhaʼa, tsa ngok nambi re zha. Tsaraa mndaab Paba leen gwodoo naro yez Jerusalén, par gab Paba lo ngwleyy, naa pol yelo tsow re zha kuu nabee ley, wiz kuu gwe kadta thib thib zha, thib maa kuu gath par taa zha gon lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Leettsa mera yezhoob gaz wiz kuu ndoblo tsow zha taxal nabee ley, tsa ndyaad chop tson zha Israel zha yezlyu Asia, ne mwii zha Paba roo gwodoo naro yez Jerusalén, ne mndelo re zha mkee zha bi ne mzhen zha Paba, ");
INSERT INTO zaoNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ne mbetsyath re zha nzhab zha: ―¡Tawlazaa zha Israel tsow goo ayud nee! Tak zha ree nak zha kuu ndiy reta ta ne nlooz zha re zha Israel ne gwodooʼaa, ne mbez zha lo re zha ndoblot tsow zha taxal nabee ley chaan Moisés. Ne nagte beeta kona, sinke noga mteyu zha gwodooʼaa, tak mloo zha, zha kuu nagt zha Israel leen gwodoo nayon chaanaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Tata nzhab re zha, tak mwii zha lee Paba kon thib zha yez Éfeso kuu le Trófimo ndiy yez, ne mtsow zha xgab mloo Paba zhaʼa leen gwodoo. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Tsa lee reta zha yez mkee bi ne mrezhonn re zha mzhen zha Paba, mdobyu zha Paba mloo zha Paba leen gwodoo naro, ne oraaka mtow zha roo pwert gwodoo. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ne or mera kuth re zha Paba, lee diiz mzin lo soldad kuu nabee lo thib mil soldad, lee re zha yez Jerusalén ngetsow thib zhoo. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Oraaka mkaltaa zha re soldad, ne tedib net re soldad kuu nabee lo thib gayoo soldad, ne lijer ngwa re zha ta nzi re men. Or mne re men lee soldad kuu nabee lo thib mil soldad mzin kon re soldad zha, tsa mlaa re men mdint raa zha Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ora mbig soldad kuu nabee lo thib mil soldad ne mzhen zha Paba, ne mnabee zha mliib zha Paba kon chop kaden; tsaraa mnaabdiz, naa cho nak Paba ne kwan mtsow Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Per thib net re men mbez thib kwaa lee tedib net zha mbez tedib kwaa, ne kwathoz mbetsyath re zha, ta mod neeka thib kuu myent zha kuu nabee lo re soldad. Tsa mnabee zha mndeno re soldad Paba ta nzo re soldad. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Or mzin re zha lo skaler tya, tsa mxoob zhuk re soldad Paba, tak lee re men kuu ndeke nlaaz kuth Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ne reta men mbetsyath mbez beth goo zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Or mera ko zha Paba ta nzo re soldad, tsa mnaabdiz Paba lo soldad kuu nabee lo thib mil soldad: ―¿Chu tak nin chop lan diiz loʼa? Lee soldada mkab nzhab: ―¿Chu ndediza diiz gryeg? ");
INSERT INTO zaoNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Chu leet lu nak zha Egipto, kuu mbyo kon re zha kuu nak tsiin, ne mndenoʼa thap mil mbyi par net yubiz, re zha kuu nzhuth men? ");
INSERT INTO zaoNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Tsa nzhab Paba lo zha: ―Na nak zha Israel, zha yez Tarso kuu nzi yezlyu Cilicia, thib yez kuu nataakxa; tsow yalwen taa diiz nin lo re men ree. ");
INSERT INTO zaoNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Lee soldada mzhyal. Tsa lee Paba mndeli lo skaler ne mtsow seny kon yaa, tsa keet raa re men bi. Or lee re men mkeet raa bi, tsa mni Paba lo re men kon diiz Hebreo, ne nzhab Paba: ");
INSERT INTO zaoNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","―Re goo wetsʼn ne xutʼn, kenza goo chop lan xkizʼn kuu nin lo goo. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Or mbin re zha lee Paba mndediz diiz Hebreo, tsa masraa zheta ngok re zha ne mkenza zha kuu mni Paba, tsa nzhab Paba lo re zha: ");
INSERT INTO zaoNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","―Na nak zha Israel, ne ngolʼn yez Tarso kuu nzi yezlyu Cilicia, per nzhee Jerusalén mzhen na ne lo maestr Gamaliel mteedʼn reta ley chaan re teyaa zha ndala. Ne kon dib ndroo leettsoon mtob yekʼn tsowʼn kuu ne Diox, leeka taxal ntsow gooy nal. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Kona mreken dits re zha kuu nyelaaz Jesús asta mbethʼn zha, ne mlon mbyi ne ngot tsib. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ne leeka ngwleyy kuu nabee lo re ngwleyy ne re zha kuu nak tsiin, reta zha ne wen wli reta koree, tak re zha mndaa yeets lon par mndan lo re zha Israel kuu nzo yez Damasco, tsa tak kwan na re zha kuu nyelaaz Jesús kuu nzo tya, tsa ten na zha ne yaadnon zha nzhee Jerusalén par tetin zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","’Per leettsa ndon net ndan ne mera ndetsin na yez Damasco, teeka ndrol wiz cha mroo thib xni lobee kuu mlaa dita ta ndon, ");
INSERT INTO zaoNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","tsa ngobʼn lo yu. Ne mbin na thib bos kuu mne lon: “Saulo Saulo, ¿chebee ndrekeʼa ditsʼn?” ");
INSERT INTO zaoNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Tsa mnaabdizʼn: “¿Cho naka Zha Nabee?” Ne lee bos mne lon: “Na nak Jesús zha Nazaret kuu ngerekeʼa dits”. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Lee re zha kuu nda re nee, mwii zha xni ne mzeb zha, per mbint zha bos kuu mni lon. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Tsa nzhapʼn: “¿Kwan nlaaza tsowʼn Zha Nabee?” Ne lee Zha Nabee mne lon: “Gwateli ne gwaka yez Damasco, tya ne zha naa kwan ndobloʼa tsowa”. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ne lee xniʼa mtsow mkow lon, tsa lee re zha kuu nda re nee mzhen yaan ne mndeno zha na yez Damasco. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","’Tya nzo thib mbyi kuu le Ananías kuu ntsow kuu nlaaz Diox, ne nzhon Ananías diiz reta kuu nabee ley chaan Moisés, ne reta zha Israel kuu nzo yez Damasco kwathoz wen ndediz zha Ananías. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Tsa myaad Ananías lon, ne or mzin Ananías mne Ananías lon: “Wets Saulo, nal bre yeni loʼa tedib welt”. Ne oraaka ngwani lon ne mwiin Ananías. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Tsa lee Ananías mne lon, lee Diox re teyaa mliʼa, tsa neʼa naa kwan nlaaz Diox tsowa, tsa yelaaza Jesucrist zha kuu nali nak, ne gona xkiiz zha kuu roo roopa zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Tak lu taa kwent chaan zha lo reta men dita lo yezlyu, gaba re kuu mwiiʼa ne re kuu mbina lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Lee nal, ¿kwan ngebeta? Gwateli ne gokleyy ne bnaab lo Zha Nabee, tsa tembi zha lu lo re falt kuu mtsowa. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","’Leettsa mren Jerusalén, tsa ngwan lee roo gwodoo naro ngwanaabʼn lo Diox, tsa taxal zha kuu ntsaa leettsoo. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Mwiin Jesús ne lee Jesús mne lon: “Lijer broo Jerusalén, tak yelaazt re men kwentʼda kuu gaba lo re men”. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Tsa nzhapʼn: “Zha Nabee, reta zha mne lee na ngwa reta ta nkaltaa re tawlazʼn zha Israel nteed xkiza, ne mzhen na re zha kuu nyelaaz lu, mlon zha tsib ne mdin na zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ne or mbeth re zha Steb, zha kuu mndaa kwent xkiza, noga na ndo tya, ne nzhapʼn wenka mbeth zha Steb, ne asta mkenapʼn xab re zha kuu mbeth Steb.” ");
INSERT INTO zaoNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Per lee Jesús ne lon: “Gwa, na taala tith lo re zha kuu nagt zha Israel”. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Konata mkenza re zha, ne mndelo re zha mrez zha ne nzhab zha: ―¡Ndoblot raa ban mbyi baa! ¡Beth goo zha! ");
INSERT INTO zaoNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ne or ngebez re zha nkezhyan zha ntsib zha xab zha ne nchoon zha yu lo mbi, ");
INSERT INTO zaoNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","tsa lee soldad kuu nabee lo thib mil soldad, mnabee ko re soldad Paba ta nzo re soldad, ne mnabee zha kin zha Paba, tsa koo roo Paba naa chebee tata mbetsyath re men kwent chaan Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Per or ngeliib zha Paba tsa kin zha Paba, lee Paba nzhab lo soldad kuu nabee lo thib gayoo soldad kuu ndo tya: ―¿Chu tak kin goo thib zha Roma, leettsa ter naab goo kwent lo zha? ");
INSERT INTO zaoNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ne or mbin soldad kuu nabee lo thib gayoo soldad koree, tsa ngwalo zha diiz lo soldad kuu nabee lo thib mil soldad, ne nzhab zha lo zha: ―¿Kwan tsowa? Tak lee mbyi ree nak zha Roma. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Tsa lee soldad kuu nabee lo thib mil soldad mbig lo Paba ne mnaabdiz lo Paba nzhab: ―Chu wli zha Roma naka. Paba mkab ne nzhab: ―Wliy. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Lee soldad kuu nabee lo thib mil soldad nzhab lo Paba: ―Na mdix naroob temi tsa mrebee ngokʼn zha Roma. Per lee Paba mkab ne nzhab: ―Per lee na desde ngolʼn nakʼn zha Roma. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Or mbin re soldad kuu nda keey yek Paba lee Paba nak zha Roma, ora mbeche re zha, noga soldad kuu nabee lo thib mil soldad kwathoz mzeb, or mne zha lee Paba nak zha Roma, tak lee zha mnabee mliib zha Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ne tedib wiza lee soldad kuu nabee lo thib mil soldad, nlaaz wen ne naa chebee nayii re zha Israel ne Paba, mxak zha Paba ne mnabee mkaltaa re ngwleyy kuu nabee lo re ngwleyy ne reta zha kuu nak tsiin. Tsaraa mloo zha Paba ne mto zha Paba delant lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paba mwii lo reta zha nak tsiin, tsa nzhab Paba lo re zha: ―Re goo wets zha Israel, reta diiz kuu mnabee Diox wen ngetsow nay asta wiz naltseree. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Tsa lee Ananías ngwleyy kuu nabee lo reta ngwleyy, mnabee lo re zha kuu nzi gax lo Paba, tsa gaat ya zha roo Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Per lee Paba mkab lo ngwleyya, ne nzhab: ―¡Tabaaka tsow Diox loʼa, zha nkedi! Lu ndob baa tsa naaba kwent lon taxal nabee ley. ¿Chebee nzhonta diiz taxal nabee ley, leel nabeeʼa kee zhay yekʼn? ");
INSERT INTO zaoNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Tsa lee re zha kuu nzi tya nzhab lo Paba: ―¿Chebee tabaa nkaba lo ngwleyy Diox kuu nabee lo reta ngwleyy? ");
INSERT INTO zaoNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Tsa nzhab Paba: ―Wetsʼn, netʼn lee zha nak ngwleyy kuu nabee lo reta ngwleyy. Tak lo xkeets Diox mbez: “Loozta re zha kuu nabee laza”. Ex. 22:28 ");
INSERT INTO zaoNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Tsa myeen Paba chop net zha nzi tya, zha saduceo ne zha Fariseo, ora nex nzhab Paba: ―Wets, na nak zha fariseo, xgann thib zha fariseo, tak nyelazʼn lee re zha nguth roban, kona myaadno zha na nzhee. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Or tata nzhab Paba, tsa mndelo re saduceo kon re fariseo mbyo diiz, ne ngok chop net zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Tak lee re zha Saduceo nyelaazt lee re zha nguth roban, neeka nyelaazt zha nzo mandad chaan Diox neeka choraa mbi, per lee re fariseo nyelaaz reta koree. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Tsa kwathoz ngoo bi tya ne lee chop tson maestr kuu nloo xkiiz Diox, kuu ndroo fabor chaan re fariseo nzhab: ―Mtsowt mbyi ree neeka thib kuu went, ser nzo cho thib mbi o thib mandad chaan Diox mni lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Or lee soldad kuu nabee lo thib mil soldad mne masraa ngeyodiz re men, tsa mzeb zha tsow byu re zha Paba, tsa mnabee zha lo chop tson soldad, tsa koo zha Paba xid re men, ne teno zha Paba ta nzo re soldad tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ne or ngoo yaal lee Jesús Zha Nabee mloo lo Paba ne nzhab lo Paba: ―Paba tsebta, tak leeka taxal mndaaʼa kwent xkizʼn nzhee Jerusalén, tabaaka taaʼa kwente Roma. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ne leettsa ngwani yezlyu, lee thib net re zha Israel myaan diiz kuth Paba, ne nzhab zha: “Wutaa neeka gutaa neeka thib kwaa, asta tsowaa gan kuthaa Paba”. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Masraa chop gal mbyi myaan diiz tsow koree. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ne lee re zha ree ngwa lo re ngwleyy kuu nabee lo re ngwleyy ne lo re zha kuu nabee lo re zha Israel, ne nzhab zha: ―Lee re nee myaan nee diiz wut nee neeka thib kwaa, asta kuth nee Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Lee nal goo kon reta zha kuu nak tsiin, bnaab goo lo soldad kuu nabee lo thib mil soldad, tsa yaadno zha Paba lo re goo yee, to goo thib kuu gab goo, lee goo nlaaz raa ne naa xomod nak kwent chaan Paba, ne lee re nee list yetsin nee, tsa kuth nee Paba net, or bee ter tsin Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Per lee xgann btan Paba mbin koree, tsa ngwa nyo ta nzo re soldad ngwalo nyo diize lo Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Tsa mrez Paba thib re soldad kuu nabee lo thib gayoo soldad ne nzhab Paba lo zha: ―Tsow yalwen bteno nyo ree lo soldad kuu nabee lo thib mil soldad, tak nap nyo thib kuu gab nyo lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Lee soldada mndeno nyo lo zha kuu nabee lo reta soldad ne nzhab lo zha: ―Lee Paba kuu nzo tsib mrezʼn ne mnaab lon, tsa yaadnon nyo ree loʼa, tak nap nyo thib kuu ne nyo loʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Lee zha kuu nabee lo thib mil soldad mzhen yaa nyo, ne mloo zha nyo thib lad, ora mnaabdiz zha lo nyo: ―¿Kwan nlaaza neʼa lon? ");
INSERT INTO zaoNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Lee nyo nzhab lo zha: ―Lee re zha Israel myaana zha diiz naab zha loʼa, tsa yee tenoʼa Paba lo re zha kuu nak tsiin, ne to zha diiz lee re zha masraa nlaaz ne naa xomod nak kwent Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Yelaazta kuu ne zha, tak masraa chop gal zha, yo wan zha net tow zha lo Paba, ne nzhaba zha wut zha neeka gut zha, asta yelo kuth zha Paba, ne nal lista nzi re zha ngebet zha naa kwan gaba. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Tsa lee soldad kuu nabee lo thib mil soldad mtaal nyo ndya ne nzhab zha lo nyo; tsa yent cho lo taa nyo kwent kuu nzhab nyo lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Tsa lee zha kuu nabee lo thib mil soldad, mrez chop soldad kuu nabee lo thib gayoo soldad ne mnabee zha to list zha chop gayoo soldad kuu teni, ne tson galbtsii soldad kuu ke kabay ne chop gayoo zha kuu gwe lans, tsa teno re zha Paba yez Cesarea yaala. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ne noga mnabee zha ko xab zha thib kabay kuu ke Paba, ne mnabee zha kenap zha Paba, tsa wen tsin Paba lo Bech kuu nak gobyern yez Cesarea. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ne mtaal zha thib yeets lo re soldad par Bech kuu nzhab: ");
INSERT INTO zaoNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Gobyern Bech, lu kuu nak thib zha kuu kwathoz nataak. Na Claudio Lisias nin “diox” loʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Lee re zha Israel mzhen mbyi ree ne mer aguth zha zha, per mnen lee zha nak thib zha Roma, tsa ngwanon re soldad da par mtelaan zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ne tak nlazʼn nen naa chebee nayii re zha ne zha zha, tsa mndenon zha lo re zha kuu nak tsiin zha Israel, ");
INSERT INTO zaoNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","tsa mnen lee re zha nayii ne zha kwent chaan ley chaan re zha, per yent kwan mtsow zha par ndoblo zha gath zha neeka par yo zha tsib. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Per myeen na lee re zha Israel myaan diiz kuth zha, kona mtaalʼn zha loʼa, ne nzhapa na lo re zha kuu nayii ne zha, yaad zha loʼa, tsa ne zha naa chebee nayii zha ne zha zha.” ");
INSERT INTO zaoNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ne lee re soldad mtsow taxal mnabee zha lo re zha, tsa yaal mndeno zha Paba yez Antípatris. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ne lee tedib wiz lee re soldad kuu nda ni mretab ta nzo re soldad, ne lee re zha kuu ndob kabay mndenoka Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Or mzin re zha yez Cesarea, tsa mndaa zha yeets lo gobyern ne mndaaka zha Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Or ngwalo mlab gobyern yeetsa, tsa mnaabdiz zha lo Paba naa cho men nak Paba, or myeen zha lee Paba nak zha yezlyu Cilicia, ");
INSERT INTO zaoNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","tsa nzhab zha lo Paba: ―Or yaad re zha kuu nayii neʼa, ora gon na re kuu neʼa. Tsa mnabee zha kenap zha Paba leen yuu naro chaan rey Herodes. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Or ndaʼa gaay wiz, tsa lee Ananías ngwleyy kuu nabee lo reta ngwleyy mzin Cesarea, kon chop tson zha kuu nabee lo re zha Israel, ne kon thib licenciad kuu le Tértulo. Re zha ree ngwa lo gobyern, tsa keki zha Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Or ngwaxii zha Paba, tsa lee licenciad Tértulo mndelo mkeki Paba, ne nzhab lo Bech: ―Texkixa gobyern Bech, por lu wen nzo nee ne por yalnzhaak chaana kwaro kuu wen ngeyak laz nee. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ne reta ta naley nzo leettsoo re men por re kuu ngetsowa ne ndaa zha texkix loʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Per nlazt nee kib nee naroob tyemp loʼa, kona naabʼn loʼa, tsa kenzaʼa chop lanta xkiiz nee. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Lee mbyi ree ngogaa lo nee ngetekiil re zha Israel, ne nda zha dita lo yezlyu ntsow rol zha re zha Israel, ne lee zha nabee lo re zha kuu nak zha Nazareno. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Noga ngwalaaz zha gateyu zha gwodoo chaan nee, kona mzhen nee zha ne ngwalaaz nee ganaab nee kwent lo zha taxal nzhab lo ley chaan nee. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Per or mzin Lisias kon re soldad Lisias, tsa lafwers mkib Lisias zha lo nee ne mne Lisias: “Ndoblo yaad re zha kuu nlaaz keki Paba loʼa”. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Leeka lu ndoblo naabdiz lo zha, tsa neʼa wli re kuu nkeki nee zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ne reta zha Israel kuu nzi tya, nzhab wli reta koree. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Tsa lee gobyern mtsow seny lo Paba, tsa kab Paba, ne lee Paba mkab ne nzhab: ―Tak neʼa na kwathoz tyen liin nda naka gobyern yezlyu ree, kona kon dib ndroo leettsoon kabʼn re kuu nkeki zha na. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Leeka lu tak naabdiza naa chu wli koree, nal nda tsiibchop wiz mzin na yez Jerusalén, ne ngwan roo gwodoo naro tsa golʼn lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ne mwiit zha lee na ngeyodiz kon thib men, neeka mtsowtʼn zhoo lee roo gwodoo naro, neeka re ta nkaltaa re zha nteed zha xkiiz Diox ne neeka thib ta leen yez mtsowtʼn tata. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Re zha ree gagt loo zha wli re kuu nkeki zha na loʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Per kuu nin nak, ntsowʼn kuu nlaaz Diox kuu nak Xutaa, taxal ndaa Net Kub chaan Jesús kwent, kuu ni re men went nak, tak nyelazʼn reta kuu nke lo libr chaan Ley ne re kuu mkee re profet chaan Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Leeka taxal nyelaaz re zha ree Diox, tataka nyelazʼn lee re men nguth roban, re zha kuu mtsow kuu wen ne re zha kuu mtsow kuu went. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","’Kona thibka nkwaan na, tsa nali ton lo Diox ne lo re men. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","’Bluz leettsa ndaʼa tyen liin nda ndiyʼn, tsaraa mren lazʼn, ngwatan na re gon kuu mtaal re zha lo re zha prob, ne noga ngwatan na gon da lo Diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Kona ngetsow leettsa mwii re zha Israel na lee roo gwodoo naro Jerusalén, re zha kuu ndyaad Asia, leen ngetsow taxal nabee ley, tsa gak nambin lo Diox. Ne neeka ndotʼn kon naroob men neeka nkeet nee bi. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Kona nzhee ndoblo to re zha kuu mzhen na, tsa ne zha naa kwan mtsowʼn ne chebee nayii zha ne zha na. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ne os leey nagte tabaa, leeka re zha kuu nzi nzhee ndoblo ne zha naa kwan mwii zha mtsowʼn, leettsa mndon lo re zha kuu nak tsiin ne lo re ngwleyy kuu nabee lo re zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","O chu tak nex nzhapʼn, leettsa mndon xid re zha, or nzhapʼn: “Tak nyelazʼn yalndroban tabaa mod tabaa ngetsowno goo na”. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Or tata mbin Bech, ne tak neʼa Bech naa xa nak kwent chaan Jesucrist kuu ndaa Paba kwent, tsa mlaa Bech kona par tedib wiz, ne nzhab Bech lo re zha: ―Or yaad soldad Lisias kuu nabee lo thib mil soldad, tsa ne wen nen naa xomod nak kwent goo. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Tsa mnabee Bech, lo soldad kuu nabee lo thib gayoo soldad, tsa kenapka zha Paba, per laa zha tsow Paba kuu nlaaz Paba, ne taa zha diiz yatwii re amig Paba lo Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Leettsa mriida chop tson wiz, tsa mzin Bech kon Drusila kuu nak tsaal Bech, lee Drusila nak zha Israel, tsa mnabee Bech yaadno zha Paba, tsa mbin rop zha kuu nzhab Paba, kuu nak yelaaz men Jesucrist. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Per leettsa mndelo Paba mndaa Paba kwent, lee re zha ndoblo nali ban zha, ne taat zha diiz tsow kwerp zha re kuu went, tak tetsin thib wiz kuu naab Diox kwent lo reta zha, ne or mbin Bech re koree, mzeb Bech ne nzhab Bech lo Paba: ―Tyee ne or teyobe lon, tsa bezʼn lu tedib welt. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Per lee Bech ngebet taa Paba temi lo Bech, tsa telaa Bech Paba, kona kwathoz welt mrez Bech Paba par tediz zha kon Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Tbaa mriid chop liin ne lee Bech mroo lo yalgobyern, tsa mla Porcio Festo lugar Bech. Ne nlaaz Bech wen yaan Bech kon re zha Israel, tsa mlaaka Bech Paba tsib. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Or ndaʼa tson wiz mzin gobyern Festo Cesarea, tsa ngwa Festo Jerusalén. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Tya lee re ngwleyy kuu nabee lo re ngwleyy ne re zha kuu nataak lo re zha Israel, ngwa keki Paba lo Festo. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Tsa mnaab zha lo Festo taal Festo Paba Jerusalén. Tak lee xgab re zha nak kuth zha Paba net. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Per lee Festo mkab ne nzhab: ―Lee Paba nzo tsib Cesarea, ne lee xgab da nak techopta wiz bretabʼn tya. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ne os cho goo, tak ya kon na Cesarea, ne os lee mbyiʼa mtsow thib kuu went, tya tak keki goo zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Lee Festo mletka Jerusalén teeka xon wiz o tsii wiz, tsaraa mre Festo Cesarea, ne tedib wiza mndob Festo ta nabee Festo, ne mnabee Festo yaadno zha Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ne or mtsino zha Paba, tsa lee re zha Israel kuu ndyaad Jerusalén, mbig zha ne mkeki zha Paba kon kwaro kuu nathoz, per gagt loo re zha wli kuu mbez re zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Tsa lee Paba mkab ne nzhab: ―Neeka thib kuu went mtsowtʼn lo ley chaan re zha Israel, neeka lo gwodoo naro Jerusalén ne neeka lo César. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Per lee Festo nlaaz wen yaan lo re zha Israel. Tsa mnaabdiz Festo lo Paba: ―¿Chu nlaaza yaʼa Jerusalén, tsa tya naabʼn kwent loʼa lo re koree? ");
INSERT INTO zaoNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paba mkab ne nzhab: ―Leen ndo lo zha kuu mto César zha kuu nabee Roma, ta ndoblo naaba kwent lon por re kuu mtsowʼn, ne wen neʼa yent kwan kuu went mtsowʼn lo re zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Os leen mtsowʼn thib kuu went kuu ndoblon gathʼn, ne nitʼn kutht goo na, per os wlit re kuu nkeki re zha na, yent cho ndoblo taan lo re zha kuu nayii nen, mas wen btaalʼn lo César, tsa naab César kwent lon. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Tsa or ngwalo mnaabdiz Festo lo re zha nzhaak kuu nteni Festo, tsa nzhab Festo lo Paba: ―Lu mnaab yaʼa lo rey César, mbay nal yaʼa lo César tsa. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Or mriida chop tson wiz, tsa lee rey Agripa rop Berenice mzin Cesarea ne ngwanii rop zha “diox” lo gobyern Festo. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ne tak tyen wiz mlet rop zha tya, tsa lee Festo mndaa kwent chaan Paba lo rey, ne nzhab: ―Nzhee nzo thib mbyi kuu mtaan Bech tsib. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ne leettsa ngwan Jerusalén, lee re ngwleyy kuu nabee lo re ngwleyy kon re zha kuu nabee xid re zha Israel mkeki re zha zha ne mnaab zha lon, tsa nabeen gath zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Per lee na nzhap lo re zha: “Lee re nee zha Roma napt nee costumr nabee nee kuth zha thib zha, leettsa ter to nee zha lo re zha kuu nkeki zha, tsa ne nee naa chu wli o wlit kuu nkeki zha zha”. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Per or myaad re zhaʼa nzhee, mtsantʼn sinke tedib wiza mndobʼn lo asi da ta nabeen, ne mnabeen myaadno zha mbyiʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Per lee re zha kuu myaad mkeki mbyiʼa, mtetht zha neeka thib kuu nathoz taxal mtsowʼn xgab. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Beeta kuu mbez re zha nak kwent chaan kostumr re zha, ne kwent chaan Jesús thib zha kuu ngutha, per lee Paba mbez naban Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ne netʼn naa xomod texnetʼn kwenta, tsa mnaabdizʼn lo zha naa chu nlaaz zha ya zha Jerusalén, tsa tya naab zha kwent lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Per lee zha mnaab taalʼn zha lo César, tsa tya naab César kwent lo zha, kona mnabeen yoka zha tsib, asta leettsa tak taalʼn zha lo César. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Tsa nzhab rey Agripa lo Festo: ―Os take noga na nlazʼn gon na kuu ni mbyiʼa. Ne lee Festo mkab ne nzhab: ―Yee tsa gona kuu ne zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ne lee tedib wiza lee rey Agripa rop Berenice mdok lar kuu mas wen na ne mzin zha kon re soldad kuu nabee lo thib gayoo soldad, ne kon re zha kuu nataak yez, ne mzin zha leen yuu ta gon zha kuu gab Paba, ora mnabee Festo ngwaxii zha Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Tsa nzhab Festo: ―Rey Agripa, ne reta goo kuu nzi nzhee. Lee mbyi kuu ngwii goo nzhee. Reta zha Israel zha Jerusalén ne re zha nzhee, naab zha lon ne mbez zha ndoblot ban mbyi baa. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Per leen ndak mtsowt zha neeka thib kuu went par ndoblo zha gath zha, per leeka lee zha mnaab zha ya zha lo César. Ne mlooʼa na yekʼn taalʼn zha lo César. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Per netʼn naa kwan keen lo yeets kuu taalʼn lo César, kwent chaan zha ree, kona mton zha lo re goo, ne loʼa rey Agripa, tsa naabdiza lo zha, tsa tak gon lut kuu keen lo César, or yelo naabdiza lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Tak ndakʼn went taalʼn thib zha kuu nzo tsib lo César ne gabtʼn naa kwan mtsow zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Tsa lee rey Agripa nzhab lo Paba: ―Tak kaba kwent chaana nal. Tsa lee Paba mlit yaa ne mndelo tenzhee nzhab: ");
INSERT INTO zaoNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","―Kwathoz lazʼn tak ndon loʼa naltseree rey Agripa, tsa nin ne kabʼn por reta kuu nkeki re zha Israelʼn, ");
INSERT INTO zaoNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","tak wen neʼa naa xomod nak costumr chaan re nee zha Israel, re kuu ntsow ngyodiz nee, kona naabʼn loʼa xek leettsooʼa kenza kuu nin. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","’Reta zha Israel ne naa xomod ngoon lazʼn ne yez Jerusalén leettsa mndyeen na. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Noga asta ndala nlebee re zha na, ne nzo mod ne zha koree os nlaaz zha, thibka nakʼn fariseo, re zha kuu kwathoz nlaaz tsow kuu mbez lo ley chaan re zha Israel. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ne lee nal ndon nzhee, tak nyelazʼn lee Diox teroban re zha nguth taxal nzhab Diox lo re teyaa zha ndala. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ne reta tsiibchop raz zha Israel ngebet wiz kuu tsow Diox kuu mne Diox, ta mod tse ne yaal nzhool zha lo Diox. Kona lee nal rey Agripa, tak nyelazʼn kona, kona nkeki re zha Israelʼn. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","¿Chebee kwathoz nagan yelaaz goo lee Diox tak teroban re zha nguth? ");
INSERT INTO zaoNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","’Ndala mtsowʼn xgab ndoblo luuzhʼn re zha kuu nyelaaz Jesús, zha Nazaret, ");
INSERT INTO zaoNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ne tabaa mtsowʼn yez Jerusalén. Ne kon yeets kuu mndaa re ngwleyy kuu nabee lo re ngwleyy lon, kwaro zha kuu nyelaaz Jesús mloon tsib, ne or nzhuth zha zha mbezʼn kwathoz wene. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Tyen welt mtetin re zha ta nkaltaa re zha nteed zha xkiiz Diox, tsa gab zha nyelaazt zha Jesús. Ne tak kwathoz mnayiin mnen re zha, asta noga mreken dits re zha tedib yez. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","’Ne par kona ndan Damasco mben yeets kuu mndaa re ngwleyy kuu nabee lo re ngwleyy lon. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Per kenza rey Agripa, teeka ndrol wiz, leettsa ndon net ndan, tsa mwiin thib xni kuu mroo lobee kuu mas ney nake xni wiz, kuu mteni dita ta ndon kon re zha kuu nda kon na. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Reta nee ngob lo yu, tsa mbin na thib bos kuu mni lon diiz Hebreo: “Saulo Saulo, ¿chebee ndrekeʼa ditsʼn? Leeka lu nkwaana yaltiʼa, taxal thib maa kuu leeka lee nkee patad yek ya kuu ntsib zha cho maa.” ");
INSERT INTO zaoNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Tsa nzhapʼn: ¿“Cho naka Zha Nabee”? Tsa lee zha ne lon: “Na nak Jesús zha kuu ngerekeʼa dits. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Gwateli tak ngwanin loʼa, tsa tsowa rtsin na, ne tediza re kuu mwiiʼa naltseree ne re kuu nalraa tsowʼn wiiʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Na taala lo re tawlaza zha Israel ne lo re zha kuu nagt zha Israel, ne tsowʼn ayuda, tsa yent kwaan tsow re zha loʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Na taala lo re zha, tsa xaala lo re zha, tsa laa zha net went ne teke zha dits net wen, ne tsa laat zha nabee Maxuuy lo zha, ne teke zha xnetʼn ne yelaaz zha na, tsa tuuyʼn re falt zha, tsa diinn zha re kuu diinn re zha kuu nambi nak lo Diox.” ");
INSERT INTO zaoNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","’Tbaa ngoke rey Agripa, mbin na diiz lo Jesús leettsa ngwani Jesús lon. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ne ner yez Damasco mndan kwent xkiiz Jesús, tsaraa Jerusalén ne dita yezlyu Judea ne lo re zha kuu nagt zha Israel. Nzhapa na lo re zha laa zha re falt chaan zha, ne tsow zha kuu wen kuu loo lee zha mtseeʼa mod went kuu nak zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ne por kona mzhen re tawlazʼn na lee roo gwodoo naro Jerusalén, ne ngwalaaz zha gaguth zha na. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Per Diox mtsow ayudʼn kona ndoka na nzhee asta wiz naltseree, ne ngetaka na kwent xkiiz zha, lo re zha kuu nataak ne lo re zha kuu nataagt, ne kuu mbezʼn lo re zha nak re kuu mkee re profet ne re kuu mkee Moisés. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Tak lee re zha nzhab: “Lee Crist Kuu Taal Diox Nabee ndoblo rid naroob yalti ne gath; ne lee zha nak kuu ner roban xid re zha nguth, ne taa zha kwent chaan Diiz Chul kuu ndaa yalnaban lo re zha Israel ne lo re zha kuu nagt zha Israel”. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Or tata nzhab Paba: Tsa lee Festo nex mkab ne nzhab: ―¡Naxen nzhak yeka Paba! Tak kwathoz ngeteeda kona ngok bxen yeka. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Per lee Paba mkab ne nzhab: ―Nzhak naxent yekʼn gobyern Festo, kuu ngenin nak kuu wli ne kuu nali. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Lee rey Agripa ndo nzhee, lee zha ne re koree, kona nzebtʼn ngetedizʼn, tak wen nen lee zha ne reta kuu ngetan kwent, tak ngetediztʼn thib kuu ngok xlaan, kuu yent cho ne. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Rey Agripa ¿Chu nyelaaza kuu nzhab re profet? Na ne nyelaaz luy. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Tsa lee rey Agripa nzhab lo Paba: ―Telutta gatsowa gan gayelazʼn Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Ne lee Paba nzhab: ―Tegal teluttay o ploraay, os nlaaz Diox nagte beeta lu, sinke noga reta zha kuu ngeyon kuu ngenin naltseree, ndoblo yelaaz Jesús taxal na, tegal gagte kon kaden. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Leettsa ngwalo nzhab Paba re koree, tsa ngwateli rey Agripa kon gobyern Festo ne kon Berenice ne kon re zha kuu ndob tya, ");
INSERT INTO zaoNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ne mroo re zha tya ne zhaata mndediz re altaa zha kwenta, ne nzhab zha: ―Yent kwan mtsow mbyi ree, tsa ndoblo gath zha, neeka tsib ndoblot yo zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ne lee rey Agripa nzhab lo Festo: ―Ngok gatelaaʼaa mbyi ree, os lee zha ganaabt zha ya zha lo rey César, tsa naab César kwent lo zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Leettsa mloo yek zha taal zha nee Italia, tsa mndaa zha Paba kon tedib net re zha kuu nzo tsib lo soldad Jul, kuu nabee lo thib gayoo soldad, grup Jul le Augusto. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ne mke nee thib bark pwert kuu le Adramitio kuu mer thoz bi par Asia. Noga Aristarco ndo kon nee, zha kuu nak zha yez Tesalónica, yez kuu nzi yezlyu Macedonia. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ne lee tedib wiza mzin nee yez Sidón, tya kwathoz wen ngok Jul lo Paba ne mzhyal Jul ngwatwii Paba lo re amig Paba yeza, ne lee re zhaʼa mndaa kuu ndow Paba ne kuu ndeche Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Leettsa mroo nee Sidón, tsa mriid nee cho yezlyu Chipre kuu nzi leen nitdoo, tsa tak nee lo mbi, tak kwathoz nax mbi nali ta nda nee ora. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ne mrendab nee lo nitdoo gax yezlyu Cilicia ne Panfilia, tsa mzin nee yez Mira kuu nzi yezlyu Licia. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Tya lee soldad kuu nabee lo thib gayoo soldad mzal thib bark chaan yez Alejandría kuu bi par Italia, ne mtsow zha ngoo nee leen barka. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ne tyen wiz kwathoz xlaaz ndya nee, ne kwathoz nagan mzin nee thib ta le Gnido. Ne tak naxka mbi lad ta nda nee, kona ndya nee par Salmón, ne mndaa nee welt cho yezlyu Creta kuu nzi leen nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ne kwathoz nagan mriid nee dita roo nitdoo, asta mzin nee thib ta le Buenos Puertos, gax ta nzi thib yez kuu le Lasea. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ne tak mtsana nee tyen wiz lo nit, ne nathoza yaka nee lo nitdoo, tak ndetsina tyemp nal, tsa mni Paba lo re zha, ");
INSERT INTO zaoNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ne nzhab Paba: ―Re goo amig, ndakʼn kwathoz nagan ya reʼaa welt ree, tak nzo ryez lux bark ne re kuu ne bark, asta nzo ryez gathaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Per lee soldad kuu nabee lo thib gayoo soldad, mas ngwalaaz zha kuu nzhab bzhaan bark ne kuu nzhab zha kuu ntetee bark, nake kuu nzhab Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ne tak nagt tya ta wen par kwet nee tyemp nal, kona mer reta zha mtsow xgab wen roo nee tya, ne tsow nee par tsin nee Fenice, kuu nak pwert chaan yezlyu Creta, ta nzhaxt xa mbi ne tsa tya rid nee tyemp nal. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Tsa mndelo ngoth lutta mbi lad sur, tsa mtsow re zha xgab mtsowa zha gan kuu mtsow zha xgab, ne ndya re nee gax gax roo yezlyu Creta kuu nzi leen nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Per lutta nda mroo nee, leettsa lee thib mbi thoz kuu le Euroclidón mndelo ngoth, ");
INSERT INTO zaoNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ne mndelo mbi mchop mbi bark, tak par ta nda nee ndyaad mbi, ngogt raa gatetee nee bark par ta nlaaz nee, kona mlaa nee mbe mbi bark. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Tsa mriid nee cho yezlyu Clauda, thib yezlyu lut kuu nzi leen nitdoo, tya naxtxa mbi, tya mxak nee kano lut kuu naliib xann bark ne mxap neey leen bark. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Or ngwalo mxap nee kanoʼa leen bark, tsa mliib re zha bark tsa luxte. Ne tak nzeb zha yetob bark lo gux kuu le Sirte, tsa mla zha re lon chaan bark, ne mlaa zha nda bark net ta nchoop mbi bark. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ne lee tedib wiz tataka nathoz nax mbi lo nitdoo, tsa mndelo re zha mni zha re kuu nzo leen bark leen nitdoo, ");
INSERT INTO zaoNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ne lee myon wiz mlobi nee re kwaa nlortsin leen bark leen nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ne tyen wiz mwiit raa nee lo wiz neeka lo re mbel kuu nzib lobee, ne tak kwathoz nathoz ngoth mbi lo nitdoo, tsa mtsow re nee xgab laat raa nee. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ne tak ndaʼa tyen wiz ndow nee, tsa mndeli Paba xid re nee ne mne Paba: ―Re goo amig, mas wen os gagon goo diiz lon ne garootaa Creta, tsa gariidtaa yalti ree, ne neeka galuuxtaa neeka thib kwaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Per lee nal yat leettsoo goo ne neeka tsebt goo, tak neeka thibaa gatht, beeta bark lux. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Tak lee Diox kuu nabee lon, Diox kuu ngetsowʼn tsiin lo, mtaal thib mandad chaan mloo lon naabtsiʼa, ");
INSERT INTO zaoNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ne, mne lon: “Tsebta Paba, tak ndoblo yaʼa lo rey César, ne kwent chaana laat Diox gath re zha kuu ndyaad re goo leen bark”. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ta mod bloney goo leettsoo goo, tsebt goo, tak nyelaazʼn Diox, ne wen nen lee reta kuu mne mandad chaan Diox lon tak. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Per lee bark ree teyetob roo thib yezlyu kuu nzi leen nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Leettsa ndaʼa tsiin wiz nda nee lo nitdoo, yaala mzin nee nitdoo kuu le Adriático, ne thib lad tedib lad mndeno mbi bark lo nitdoo, ne teeka ngulal yaal lee re zha kuu nke tsiin leen bark myeen zha mera ndetsin nee lo yezlyu. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Tsa mchiix re zha naa plo naats nit tya, ne galbtsii xoop metr naatse. Ne mas delant mre zha mchiix zhay, ne naatslay galbgazka metr. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ne mzeb re zha cha diinn bark cho re ke, tsa mlobi zha thap ganch yiib par xann bark, tsa yetob bark. Ne lee re men ndak: “Malaay ngwaniʼa yezlyu”. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ne lee re zha kuu nke tsiin leen bark mtsow zha xgab zhonn zha. Ne mndelo zha mla zha kano lut lo nit, mtsow re zha taxal zha kuu ngegobi yiib par yek bark leen nit, beeta par zhonn zha leen kanoʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Per lee Paba mloo diiz lo soldad kuu nabee lo thib gayoo soldad ne lo re soldad, ne nzhab Paba: ―Os lee re zha ree yaant leen bark, laat re goo. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Tsa lee re soldad mga doo kuu naliib kanoʼa ne mlaa zha mlowgwe lo nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Leettsa ndeyeniʼa yezlyu, lee Paba nzhab lo re zha: ―Ndoblo dowaa lut kwaa, tak ndaʼa tsiin wiz nzhatta goo ne neeka lut kwaa ter wu goo. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Na ni lo goo dow goo lut kwaa, tsa gatht goo, tak neeka thib goo luxt neeka thib yitsek. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Leettsa ngwalo tata nzhab Paba, mzhen Paba tsa pan ne mndaa Paba texkix lo Diox lo re zha, ne mtsow rol Paba pan ne mndelo Paba ndow. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Tsa reta zha ngoo ney leettsoo ne mdow re zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Chop gayoo tson galbtsii xoop nak re nee kuu nzo leen bark. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ne leettsa ngwalo ndow re nee plotha kuu mze leettsoo nee, tsa mni re zha nzob xtil leen nitdoo, tsa xax bark. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Leettsa ngwani yezlyu, lee re zha kuu nke tsiin leen bark mlebeet zha yezlyuʼa, per mwii zha thib yaa nitdooʼa ta nzi gux re ladta, ne mtsow re zha xgab tsig zha bark par tya. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Tsa mga zha re doo kuu naliib re yiib ganch kuu nlortsin tsa yetob bark, ne mlaa zha mlay leen nitdoo, ne mxak zha ya kuu ntetee zha bark, tsa telo bark te bark. Ne mlap re zha lon kuu now yek bark, tsa tene mbi, tsa lee bark mndelo mbig lo gux roo nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ne mndaab bark ta kwathoz nzi gux ne tya myaan bark. Ne ngwatob yek bark lo gux ne gagt raa wine, ne lee xanne mndelo mlux, tak kwathoz mdinke nitdooy. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Tsa lee re soldad ngwalaaz aguth re pres, tsa zhonnt re zha lii zha nadar lo nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Per lee soldad kuu nabee lo thib gayoo soldad mzhyalt gagake tata, tak nlaazt zha gath Paba, tsa mnabee zha lo re zha kuu nzhaak nlii nadar, tsa ner re zhaʼa tab lo nit par roo zha leen nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Tsaraa teke re zha kuu ten tabl o re ya byu kuu mroo cho bark. Ne tata mla reta nee mzin nee lo yu. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Leettsa ngwalo mroo reta nee leen nitdoo, tsa myeen nee lee yezlyu ta mzin nee le Malta, thib yezlyu kuu nzi leen nitdoo. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Lee re zha kuu nzo yezlyuʼa kwathoz wen ngok zha lo nee. Ne mtee zha thib bel thoz mbiz nee, tak kwathoz nal ne ndo yi. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Tsa lee Paba ngwakwaan thib zhuk ya, ne or ngego Paba ya lo ki, ora lee thib mbeel kuu mroo xid yaʼa por xlee ki, mkee maay ne mkengiinka maa yaa Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Or mwii re zha Malta lee mbeel nkegaa yaa Paba, tsa nzhab zha lo altaa zha: ―Zha mbeth men nak zha ree, ne tegal mlaa zha lo nitdoo, per tathka zha por re kuu mtsow zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Per lee Paba mtsib yaa, tsa ngob mbeela lo bel, ne yent kwan mzhaak Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Reta men ngebet la ki yaa Paba o cha gab Paba ne gath Paba. Per leettsa ndaʼa or ngewii re men yentka kwan mzhaak Paba, tsa mtsee re men xgab men, ne mndelo re men nzhab lee Paba nak thib re diox. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Gax ta mrin nee nax re yu chaan thib mbyi kuu nataak yezlyu Malta, zha ree le Publio, ne mne zha ya nee liz zha, kwathoz wen mkayaa zha re nee, ne mlet nee liz zha tson wiz. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ne lee xut Publio nax ndak xlee ne yiz bren. Tsa mbig Paba ta nax zha, ne or ngwalo mnaab Paba lo Diox tsa mxoob Paba yaa Paba yek zha, ne lee zha mgwe. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ne or mbin re mbyiz kuu nzo tya kona, tsa myaad re zha lo Paba ne mtegwe Paba re zha. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Kwaro kwaa mndelaaz re zha lo nee. Ne leettsa mndaab nee leen bark par roo nee tya, mndaa zha reta kuu ndeche nee net. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Tson mbee ngoo nee Malta yezlyu kuu nzi leen nitdoo, tsaraa ngoo nee leen thib bark kuu mlet tya tyemp nal, kuu nak chaan yez Alejandría. Ne lad loy nke chop diox kuu nak Cástor ne Pólux. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Tsa mzin nee pwert kuu le Siracusa, tya mlet nee tson wiz, ");
INSERT INTO zaoNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ne tya mroo nee ndya nee dita roo nitdoo, asta mzin nee thib yez kuu le Regio. Ne lee tedib wiz kuu mroo nee tya, ngoth thib mbi kuu ndyaad lad sur, ne asta wiz mrop tsaraa mzin nee yez Puteoli. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ne tya mzaal nee chop tson zha kuu nyelaaz Jesús, re zha ree mnaab lo nee kwet nee lo re zha thib sman, tsa mlet nee lo re zha. Bluz tsaraa ndya nee par Roma. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ne lee re wets zha Roma mne zha lee re nee tsin, ngoo cho zha myaadxii net zha nee, asta yez kuu le Foro chaan Apio ne cho zha myaad asta yez kuu le Tres Tabernas. Or mwii Paba re zha kwaro naley ngoo leettsoo Paba ne mndaa Paba texkix lo Diox ne ngoo ney leettsoo Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Leettsa mzin nee Roma, tsa lee soldad kuu nabee lo thib gayoo soldad, mndaa re zha kuu ndyaad yo tsib tya, lo zha kuu nabee roo tsib tya, per lee Paba mlaa zha yo thib yuu zhaata, ta thibka soldad mkenap Paba. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Leettsa ndaʼa tson wiz mzin nee Roma, tsa mrez Paba re zha Israel kuu nabee xid re zha Israel kuu nzo tya. Leettsa mkaltaa re zha, tsa nzhab Paba lo re zha: ―Re goo wets, tegal yent kwan mtsowʼn lo re zha Israel neeka lo re costumr re teyaa zha ndala, per mzhen re zha na Jerusalén, ne mndaa zha na lo re zha kuu nak tsiin zha Roma. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ne leettsa mnaabdiz re zha lon, ngwalaaz zha gatelaa zha na, tak mne re zha yent kwan mtsow par ndoblon gathʼn. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Per lee re zha Israel ngok bi, kona mnaabʼn mteriid zha na lo César, tsa texnet César kwent da, per nagte tak nlazʼn kekin re tawlazaa. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ta mod mrezʼn goo yaadtwii goo lon tsa tedizaa, ne tak nyelazʼn lee re zha nguth roban, leeka taxal nyelaaz re tawlazaa zha Israel, kona naliibʼn kon kaden ree. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Tsa lee re zha nzhab lo Paba: ―Neeka thib yeets kuu mtaal re zha Judea ter kayaa nee kwent chaana, ne neeka thib re tawlazaa kuu mroo Judea, yent kwan kuu went ne zha lo nee kwent chaana. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Per nlaaz nee gon nee kuu neʼa, tak ne nee reta ta went ndediz re men kwent Net Kub chaan Jesús kuu ndyaad loʼa. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Tsa mto re zha thib wiz kuu kaltaa re zha. Ne leettsa mzin wiza kwathoz zha mkaltaa ta nzo Paba. Asta til ne asta mziy yezlyu mndaa Paba kwent lo re zha naa xomod nak yalnabee chaan Diox. Ne tata mtsow Paba tsa yelaaz re zha Jesús, ne mteteed Paba re zha kon re kuu nzhab lo ley chaan Moisés ne kuu mkee re profet ta mbez kwent chaan Jesús. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Thib net zha ngwalaaz kuu nzhab Paba, per lee tedib net zha ngwalaazte. ");
INSERT INTO zaoNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ne tak mbyodiz re zha, mndelo re zha mbi zha. Tsa lee Paba nzhab lo re zha: ―Wli kuu nzhab Mbi Nayon por profet Isaí lo re teyaa zha ndala, or kuu nzhab profet: ");
INSERT INTO zaoNT_vpl VALUES ("AC2